﻿USE sofia;
DROP TABLE IF EXISTS sofia.cpbNT_vpl;
CREATE TABLE cpbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cpbNT_vpl WRITE;
INSERT INTO cpbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiroka iwairopaini icharineyetari Jesucristo. Tema iriitake icharine David-ni, eejatzi Abraham-ni. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ikanta pairani Abraham-ni, itzimake itomi iitakeri Isaac. Ikanta Isaac tzimanake itomi irirori, iitakeri Jacob. Ikanta Jacob tzimanake itomi irirori, iitakeri Judá. Te apaani ikanta itomi Jacob, osheki itomipaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ikanta Judá rowaiyakaakawo Tamar, iitakeri Fares, iriima itsipa iitakeri Zara. Ikanta Fares tzimanake itomi irirori, iitakeri Esrom. Ikanta Esrom tzimanake itomi irirori, iitakeri Aram. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ikanta Aram tzimanake itomi irirori, iitakeri Aminadab. Ikanta Aminadab tzimanake itomi irirori, iitakeri Naasón. Ikanta Naasón tzimanake itomi irirori, iitakeri Salmón. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ikanta Salmón rowaiyakaawo Rahab, iitakeri Booz. Ikanta Booz rowaiyakaawo Rut, iitakeri Obed. Ikanta Obed tzimanake itomi irirori, iitakeri Isaí. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ikanta Isaí tzimanake itomi irirori, iitakeri David. Iri pinkatharitaintsiri. Ikanta pinkathari David rowaiyakaakawo iina Urías, iitakeri Salomón. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ikanta Salomón tzimanake itomi irirori, iitakeri Roboam. Ikanta Roboam tzimanake itomi irirori, iitakeri Abías. Ikanta Abías tzimanake itomi irirori, iitakeri Asa. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ikanta Asa tzimanake itomi irirori, iitakeri Josafat. Ikanta Josafat tzimanake itomi irirori, iitakeri Joram. Ikanta Joram tzimanake itomi irirori, iitakeri Uzías. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ikanta Uzías tzimanake itomi irirori, iitakeri Jotam. Ikanta Jotam tzimanake itomi irirori, iitakeri Acaz. Ikanta Acaz tzimanake itomi irirori, iitakeri Ezequías. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ikanta Ezequías tzimanake itomi irirori, iitakeri Manasés. Ikanta Manasés tzimanake itomi irirori, iitakeri Amón. Ikanta Amón tzimanake itomi irirori, iitakeri Josías. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ikanta Josías tzimanake itomi irirori, iitakeri Jeconías. Irojatzi itzimantanakari irirentzipaini eejatzi. Aripaite ripokaiyakeni owayeripaini poñagainchari Babilonia-ki, inoshikanakeri maawoini inampiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ikanta ripiyaiyaani inoshikaweetakari Babilonia-ki. Tzimapai itomi Jeconías irirori, iitakeri Salatiel. Ikanta Salatiel tzimanake itomi irirori, iitakeri Zorobabel. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ikanta Zorobabel tzimanake itomi irirori, iitakeri Abiud. Ikanta Abiud tzimanake itomi irirori, iitakeri Eliaquim. Ikanta Eliaquim tzimanake itomi irirori, iitakeri Azor. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ikanta Azor tzimanake itomi irirori, iitakeri Sadoc. Ikanta Sadoc tzimanake itomi irirori, iitakeri Aquim. Ikanta Aquim tzimanake itomi irirori, iitakeri Eliud. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ikanta Eliud tzimanake itomi irirori, iitakeri Eleazar. Ikanta Eleazar tzimanake itomi irirori, iitakeri Matán. Ikanta Matán tzimanake itomi irirori, iitakeri Jacob. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ikanta Jacob tzimanake itomi irirori, iitakeri José. Iriitake oimenthoritakari María. Jiroka María irootake tomintakariri Jesús, irijatzi iitaitakeri Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iriira icharineyetakari. Retanakawo Abraham-ni irijatzi David-ni, ikaataiyini 14. Ipoñaanaka David-ni irojatzi inoshikaweetantakariri Babilonia-ki, ikaataiyini 14. Ripiyaiyaini inoshikaweetakarira Babilonia-ki, irojatzi itzimantakari Cristo, ikaataiyini 14 eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiroka okanta itzimantakari pairani Jesucristo. Eenitatsi José iinathori oita María, ikashaakawo iinantyaawo. Temaita iñiiro intsipawaityaawo. Iro kantacha María motzitake, ikantakaakawo Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tema tampatzikashireri rinake José irirori, ikowawetaka rookerome rimananekiini, te ikowi rowaariperowaitero inkemakoitero itzimashiwaitaka eentsite. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ikanta ikenkithashiryaawaita José tsireniriki, romishimpyaakeri imaninkarite Pawa ikantakeri: “José, icharine David-ni. ¿Oitaka pikenkithashiryaantari pookero María? Payero, tema Tasorenkantsi kantakaawori omotzitantakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Arika intzimake eentsi, piiteri JESÚS. Iriira owawisaakotairine isheninkapaini ikaariperoshirewetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ari imonkaatakari maawoini rosankenatakeri pairani Kamantantaneri, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ari owaiyakya tsinane kaari ñeerine shirampari, intzime otomi, Iitaiteri Emanuel, akantziri apaanteki aaka: “Itsipatai Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ikanta ikakitanake José, rimatakero okaatzi inintakaakeriri Pawa, raakero iinantyaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Te raawimaitawo irojatzi itzimantakari eewarite otomi. Iitakeri JESÚS. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Itzimake Jesús nampitsiki Belén saikatsiri janta Judea-ki. Tema itzimantakari Jesús, ipinkathariwentantzira Herodes. Ari rareetakari nampitsiki Jerusalén yowairentzipaini ikenapaakero rishitowapiintzira ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rosampitapaakeri: “¿Tsika risaikika iwinkatharite Judá-ite owakera tzimaintsiri? Janta nonampiki nopoñaakaga, noñaake impokiro niyotantakari tzimake. Iroowa nipokantaiyarini noñaapinkathateri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ikanta ikemawake pinkathari Herodes, antawo okantzimoshiretanakari, ari ikantakari maawoini Jerusalén-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ikaimakaantakeri Herodes maawoini reeware Imperatasorentsitaarewo, eejatzi maawoini yowairentziite, rosampitakeri: “¿Tsikajaantaka intzimeka Cristo?” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ikantaiyanakeni iriroripaini: “Intzime janta nampitsiki Belén saikatsiri Judea-ki, ari okantzi rosankenare Kamantantaneri, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Isaiki nampitsi Belén janta Judea-ki, tekaatsi thainkerone. Ari impoñeeyaari pinkathariperori janta. Iri jewatairine isheninkapaini Israel-iite nashitari naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ikanta Herodes, ikaimakaantakeri pokaintsiri iñeeri owakerari tzimaintsiri, rosampitakeri: “¿Tsikapaiteka piñaakeri impokiro piyotantakari tzimake pinkathari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ikamantakeri maawoini. Irojatzi ikantantanakariri irirori: “Ariwé, pimatero piyaate Belén-ki, pamine tsika risaiki eentsi. Arika piñaakeri, eejatzi pinkenapai jaka, pinkamantanaina. Niyaateeta naaka, noñaapinkathateri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Irojatzi riyaatantanakari. Eejatzi iñaanairi impokiro iñaakeri chapinki inampiki. Iñaatziiri rowaatzinkapaaka, iro riyotantapaakawori pankotsi risaikakera eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikanta iñaakerira rowaatzinkapaaka impokiro, kimoshire ikantaiyakani. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Areetaiyapaakani pankotsiki, iñaapaakeri eentsi eejatzi inaanate María. Rotziwerowashitapaakari, iñaapinkathatapaakeri. Roosoryaakotapaakero ramakeniriri, ipapaakeri ooro, ipakeri kasankayetatsiri, ipakeri eejatzi kasankaari kepishaatatsiri. Osheki owinawo jirokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ikanta rimagaiyapaakeni, romishimpyaakeri Pawa, ikantziri: “Eero pipiyashitari Herodes. Pinkenanai otsipaki awotsi piyaatantaiyaari pinampiki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ari ripiyaawo yowairentzipaini. Rapiitairo imaninkarite Pawa riñaanatairi José rimishireki, ikantziri: “José, pishiyakayeri eentsi eejatzi inaanate nampitsiki Egipto. Ari pisaikeri janta irojatzi nonkantantaimiri: ‘Pipiyai.’ Awotsikitake Herodes ritsitokeri eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kakitanake José, ikamantanakero María, tsireniriki rishiyaka Egipto-ki, raanakeri eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari risaikakeri janta, irojatzi ikamantakari Herodes. Ari imonkaataka rosankenatakeri pairani Kamantantaneri, ikantake: Risaikawetaka notomi nampitsiki Egipto, nokaimairi ripiyai eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ikanta Herodes, yotake ramatawitakeri yowairentzipaini, te ripiyashitaari. Ityaanakari imashirenka. Rotyaantake rowayeritepaini, ikantakeri: “Piyaate Belén-ki, paperaateri eentsipaini. Pithonkeri maawoini, petanakyaari owakera tzimaintsiri irijatzi tzimaintsiri apite rosarentsite.” Tema ikamantakeri chapinki yowairentzi tsikapaite iñaakeri impokiro. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iro ikantantakari pairani Kamantantaneri jitachari Jeremías, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Icheraaperotatzi Ramá-sato iragaiyani. Osheninkathori Raquel-ni iraakotakariri eentsitepaini. Iro owashiretantakari rowamayitaitakerowa maawoini eenchaanite. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Okanta osamanitake, kamai Herodes, irojatzi risaikake José nampitsiki Egipto. Ari riñaanatairi imaninkarite Pawa rimishirekiini, ");
INSERT INTO cpbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ikantairi: “José, piyaatai pinampiki, paanairi peentsite pintsipataanairi inaanate. Tema kamai kowawetachari ritsitokerime.” ");
INSERT INTO cpbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Rimatakero José, piyaawo inampiki Israel. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iro rareewetaa José inampiki, ikantaitawairi: “Pinkatharitai Arquelao janta Judea-ki. Ripoyaataari ipaapateni Herodes.” Ari ikenkithashiretanaa José, eero ikenanai janta. Ari rapiitaitairi riñaanaitairi rimishireki, ikantairi: “Paamayaari Arquelao.” Irojatzi ikenantanaari José Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ikanta riyaatai, risaikapai nampitsiki Nazaret. Irojatzi imonkaatantakari rosankenatakeri pairani Kamantantaneri, ikantake: Nazaret-satzi iitaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Okanta pairani ochempiki saikatsiri Judea-ki, ripokake Juan omitsitsiyaatantaneri, ikamantantzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ikantantapaake: “Pipakairo pikaariperoshirewaitake, irootaintsi impinkathariwentantai jaka Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iro riñaanetakari pairani Kamantantaneri jitachari Isaías, ikantake: Richeraapiintaitake ochempiki, ikantaitzi: Powameethatainiri Pinkathari tsika inkenapaake. Poshiyakayero rotampatzikaitziro awotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Iithaaretakari pairani Juan, rontyagaitziro iwitzi camello, romathakitakari mashitsimashi. Rañaantari rowayetari maapataki, ririri iyaa pitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Osheki pokashitakeriri pairani Juan, Jerusalén-satzi, Judea-satzi, ripokashitakeri eejatzi nampiyetawori antawaaki ñaa Jordán. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Thawetakoyetapaaka ikaariperoshirewaitakera, romitsitsiyaayetawakeri ñaaki Jordán. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ripokawetaiyakani Fariseo-paini, eejatzi Sadoc-iite, ikowi romitsitsiyaatyaame. Iro kantzimaitacha ikisathatawakeri Juan, ikantakeri: “Te pikameethashiretaiyini eeroka, poshiyashitakari maanke. ¿Poshiyakaatzi eero rowasanketaitzimi? ");
INSERT INTO cpbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kyaaryooperorika pipakagairo tsika pikantaweta pairani, pinkameethashiretaiyeni, poshiyaawo pankirentsi kithokitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eero pikantashirewaitashita: ‘Naaka icharine Abraham-ni, te okowaperota nipakagairo nokaariperoshirewaitzi.’ Pinkeme nonkante: ‘Eero pishamewaitashita piitakaatzi eeroka ikowaperotanewo Pawa, tema kantacha ratziritakairo jiroka mapi, iroowa poyaataiyaarine incharineyetaiyaari Abraham-ni.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Eerorika poshiyawo pankirentsi kithokitatsiri, richekakagaitakawo shacha owaatoki kaari kithokitatsine, ragaitziro ritagaitero. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Arika ripakaanairo atziri ikaariperoshirewetaka, ari nomitsitsiyaatantakyaari ñaa. Iro kantzimaitacha, awotsikitake matzirori ipinkatharentsitzi, nopinkathatzitari naaka, te onkantya roshiyakaina rimperatanewo nonowikyaantyaanariri i-zapato-te. Iriira oshiyakairone romitsitsiyaatantatyeeyaarime Tasorenkantsi, romitsitsiyaatantatyeeyaarime eejatzi paampari. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tema arika ankowiitero awankire, otekakitziro, irojatzi ataantakyaawori otaaki. Iroowa aye okithoki, otekitakero, owakotakero. Ari inkantaiyaari Awinkatharite eejatzi, rinashiyetaiyaari atziri. Ineshironkayetairi inkaate kemisantanairine, iriima kaari pakairone ikaariperoshirewaitzi, ritagairi paampariki kaari tsiwakanetatsine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ripokake Jesús antawaaki ñaa Jordán, ipoñaakawo Galilea-ki. Ripokashitakeri Juan romitsitsiyaateri. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te ikowaweta Juan romitsitsiyaateri Jesús, ikantawakeri: “¿Oitaka pipokashitantanari naaka nomitsitsiyaatemi? Eeroka omitsitsiyaatenane naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Rakanakeri Jesús: “Nokowaperotatzi pomitsitsiyaatena. Iro inintakaakenari Pawa.” Kowanake Juan, ikantziri: “Aritake nomitsitsiyaatakemi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Raanakeri, romitsitsiyaatakeri. Iro ritonkaawetanaka Jesús, oshiyanakawo ashitaryaanakityeeyaame inkite, iñagaitawakeri ripokashitakeri Tasorenkantsi ikenapaake inkiteki roshiyapaakari shiro. ");
INSERT INTO cpbNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ikemaitatzi inkiteki ikantaitanake: “Notomi rinatzi jirika netakokitari, osheki nokimoshirewentakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ikantakaanakari Jesús Tasorenkantsi, jatanake ochempiki, ari ikowawetakari Kamaari inkaariperotakairime. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Osheki kiteesheri risaikawaitake, ritziwentaka, ayimatakeri ritashe. Okaatzi 40 kiteesheri risaikawaitake. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ikanta Kamaari, ripokashitakeri Jesús inkaariperotakairime. Ikantapaakeri: “Imaperotatyaarika Itomintzimi Pawa, pimpeyero pan jiroka mapi, poyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Rakanakeri Jesús, ikantanakeri: “Eenitatsi osankenarentsi kantatsiri: Te apatziro onkowimotai pan oyaawo, iroowa kowaperotacha ankemisantairo maawoini ikantayetairi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ikanta Kamaari raanakeri nampitsiki tasorentsitatsiri, risaikakaakeri jenoki omitzikaaki tasorentsipanko. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ikantawetapaakari: “Imaperotatyaarika Itomintzimi Pawa, pimitaye isaawikinta. Pinkenkithashiretero rosankenaitakeri pairani okantzi: Rotyaantemiri Pawa imaninkarite kempoyeemine. Iriira thomaawakemine eero pomposantawaitapaaka mapiki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Rakanakeri Jesús: “Okantzi eejatzi rosankenaitakeri pairani: Te okameethatzi piñaantashiwaityaari Piwinkatharite Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Rapiiwetakari Kamaari raanairi Jesús ochempiki. Raminakaakeri maawoini nampitsi ipinkathariyetzira atziripaini, tema kameetha okantaka owaneenkayetaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ikantziri: “Piñaakero okaatzi tzimatsiri. Arika potziwerowashitakena piñaapinkathatena, arira nompakemiro maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Rakanakeri Jesús, ikantanakeri: “Piyaate intaina. Satanás pini eeroka. Tema rosankenaitake pairani, kantatsiri: Ampinkathateri Awinkatharite, apatziro ankemisanteri irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ari rintainaryaanake Kamaari. Pokaiyapaakeni imaninkarite Pawa, ramitakotapaakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ikanta Jesús ikemakowentakeri Juan romonkyaakaantaitakeri. Irojatzi ripiyantanaari irirori Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te risaikapai Nazaret-ki, ikenanai Capernaum-ki, ari risaikapairi. Inkaarecheraaki isaikira Capernaum, inampiwetawowa icharineyetari Zabulón eejatzi Neftalí. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ari imonkaatakari ikenkithatakotakeri pairani Kamantantaneri Isaías, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Isaike inampitsite Zabulón-iite eejatzi Neftalí-ite janta inkaarecheraaki, Intatsikero antawaaki ñaa Jordán, Saikatsiri Galilea-ki, ipiyotapaawowa atziri kaari asheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Iriira oshiyakawori risaikatyeeme otsirenikitzira, iñaayetairi ootamentotsi. Itsimankakowetakari raampare kathatayeri inkenayetaime sarinkaweniki. Iro kantzimaitacha, oshiyaawo iroñaaka risaikaatyeeme okiteeshetzira. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ari retanakawo Jesús ikamantapaakeri atziripaini, ikantapaakeri: “Pookairo pikaariperoshirewaitake, irootaintsi impinkathariwentantai jaka Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Irojatzi ipampithacheraatantanakawori inkaare saikatsiri Galilea-ki, iñaapaakeri Simón, iitaitziri eejatzi Pedro, itsipatari irirentzi iita Andrés, itarajaataiyini. Tema tarajaawairentzi rinaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ikantapaakeri: “Poyaatena, oshiyaiyaawo iroñaaka iriime atziri nontarajaatakaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Royaatanakeri, rookanakero itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iro rowaaganeentanaka eepichokiini, iñaapaatziiri Jacobo, itsipatakari irirentzi Juan, risaikaiyini ipitoki rowamatankawaitzi itarajaamento itsipatakari ipaapate Zebedeo. Romiñaanakeri eejatzi irirori, ");
INSERT INTO cpbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","rookanakeri ipaapate ipitoki, royaatanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Rithonkakero ranashitawo Jesús Galilea-ki, riyotaantake maawoini nampitsiki eejatzi rapatotapiintaitaga, ikamantantakero Kameethari Ñaantsi kenkithatakotzirori ipinkathariwentantai Pawa. Retsiyatakotakaayetake mantsiyayetatsiri nampitsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ikemakotaitakeri Jesús intaina. Ikemaiyakeni eejatzi Siria-satzi, ramayetapaakeniri maawoini mantsiyayetatsiri isheninka, retsiyatakotakaayetainiri. Ramakeri maawoini imatziri inashiyetachari mantsiyarentsi, katsiwaitatsiri, kamanawaitatsiri, kisopookiwaitatsiri. Ramake eejatzi raagayetziri peyari. Ari rithonkiri retsiyatakotakaayetairi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Royaataiyakerini osheki Galilea-satzi, Decápolis-satzi, Jerusalén-satzi, Judea-satzi, poñaayetanainchari eejatzi intatsikero antawaaki ñaa Jordán. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ikanta iñaakeri Jesús osheki piyowentakariri, tonkaanake ochempiki, ari risaikapaake. Pokaiyapaakeni riyotaanewopaini, ipiyowentapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ari riyotaayetakeri, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kimoshire inkantaiya jentashiretatsiri, iri ñagairone impinkathariwentantai Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kimoshire inkantaiya iraaneentawaitachari, iri roimoshirenkaitairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kimoshire inkantaiya tsinampashireri, iri saikaatsine kameetha kipatsiki inintakagaitakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kimoshire inkantaiya aminaminatzirori inkameethashirete, ari iñagairo raminaminatziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kimoshire inkantaiya neshironkashiretantaneri, ari ineshironkaitairi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kimoshire inkantaiya kiteshireri, iri ñagairine Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kimoshire inkantaiya oitsimariirori mashirenkaantsi, iri intomintaiyaari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kimoshire inkantaiya inkaate inkemaatsitakagaityaari ikameethashiretzira, iri ñagairone impinkathariwentantai Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kimoshire pinkantaiya imanintawaitaitemi, inkemaatsitakaitemi, inthaiyawentaitemi okantakaantzirowa pikemisantaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Thaamenta pinkantayetanakya, tema Pawa pinayetaimine inkiteki. Pinkenkithashiretakotero jiroka, ari ikantaitakeri pairani etayetakawori Kamantantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Poshiyakawo eerokapaini tziwi. Arika rowaitaitero tziwi oitarika, eero opantanaawo inkatyokantaityaawo. Ontzimatye imanintaitero, rookaitakero raatzikawaitaitero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Arika isaike nampitsi tonkaariki, okoñaatzi maawoini arika ootya tsireniriki, te imana nampitsi. Kiteesheetyaakotantaneri pinaiyini eeroka eejatzi, eerokatake yotaayetanairine maawoini atziri, eero pimanimotziri okaatzi piyoyetanairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ari okantari eejatzi, arika oosheri ootamentotsi, te ashitakotziri kantzirinaki. Owakotziri jenoki inkiteesheenkatakotantyaari maawoini saikatsiri pankotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ari pinkantaiyaari eejatzi eeroka, pisaikayetai kameetha iñaantaimiri pisheninka okameethatzi maawoini pantayetanairi. Iro riyotantaiyaari irirori impinkathateri Ashitairi Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Eero pikenkithashiretashita iro nipokantari nipakaakaimiro pikemisantziro Inintakaantaitanewo, te nokowi eejatzi nipakaakaimiro ikenkithatakotakeri pairani Kamantantaneri. Iro nipokantakari nimonkaatero okaatzi ikenkithatakoitakeri pairani. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Imapero nokantzi: Aritake ithonkaiya paata kipatsi eejatzi inkite, iro kantzimaitacha eero ithonkimaita Inintakaantaitanewo, irojatzi imonkaatantakyaari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eerorika pikemisantziro Inintakaantaitanewo, eerorika piyotaayetairi pisheninka inkemisantayetairo, eerowa pinintagaawo ipinkathariwentantaira Inkitesatzi. Iriima matakerone inkemisantairo, riyotaantairo eejatzi, iriira iriiperotaatsine inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Poshiyakaatziima kameethashire ikantayetaka Yotzinkariite eejatzi Fariseo? Tera. Te rimonkaatziro kameethaini inintakaawetariri Pawa. Eerorika pawisayetairi eeroka pinkameethashireyetai, eerowa piñagairo impinkathariwentantai Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Piyotaiyironi eeroka ikantaitakeriri pairani etakaantanakawori, ikantaitziri: Eero pitsitokantzi. Arika pitsitokantake, ari rowasanketaitakemi eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iro kantzimaitacha nokantzi naaka: Eero pikishiri pisheninka, rowasanketaitzimikari. Eero pikantawaitziri eejatzi: ‘Te piyowainetzi eeroka.’ Rowasanketaitzimikari pinkatharentsiki. Te okameethatzi eejatzi pinkisaneentawaiteri pisheninka piitamasontziwaiteri, patsipetaawokari pitagaiya sarinkaweniki. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tema paapiintzi pipira pitayiniri Pawa, iro kantzimaitacha arika pinkenkithashiretapaakero tzimatsi ikisawentzimiri pisheninka, ");
INSERT INTO cpbNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ari pookanakeri pipira, piyaatashiteri kisakemiri. Pinkantairi: ‘Asheninká, jame aakameethatawakagaiya.’ Arika paakameethatawakagaiya, pipiyai taapokimentotsiki, pitaapainiri Pawa pipira. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Arika intzime kishemine, irojatzi raantanakemi pinkatharentsiki, pinthaawakote eeroka awotsiki, pinkantairi: ‘Eero pikisawaita, jame aakameethatawakagaiya.’ Arika rareetakaakemi pinkatharentsiki, inkantaitakeri rimperatanewo: ‘Paanakeri jirika.’ Ari romonkyagaitemiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eerorika pipinatashitari okaatzi pireewetakeri, eero piñagairo romishitowakaantaimi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Piyotziro eerokapaini ikantaitakeri pairani, ikantaitzi: Eero pimayempitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iro kantacha nokantzi naaka: Piñaamashiretaworika piñiiro tsinane, matakemi, pimayempishiretakero. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jiroka noshiyakaawentemiro: Iroorika pokipero pantanta kaariperori, pipakagairo, poshiyakaantero pinkithoryaatyeerome, pookero. Tema te pikowiro poki atsipetakagaimiro sarinkaweni, iro kameethatatsi pisaikapityaakitai. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iroorika pakopero pantanta kaariperori, pipakagairo poshiyakagairo pithatzinkatyeerome, pookero. Tera pikowiro pako atsipetakagaimiro sarinkaweni, iroowa kameethatatsiri pisaikaponchokitai. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ikantaitake eejatzi pairani: Arika rookawakaitya, ontzimatye impaiteri tsika osankenatakota jokawakagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iro kantzimaitacha nonkante naaka: Kaariperoshireri rini jokashitawori iina. Arika aawetaiya itsipa oime, omayempitzimotakeri etawetari oimentari. Ari ikantari eejatzi agairone, mayempitake irirori. Te okaariperoweta rookerome atziri iina, arika iñeero omayempitzimowaiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Piyotaiyironi eejatzi ikantaitakeriri pairani etakaantawori: Eero pamatawithatantzi. Pinkante: ‘Rowasanketaina Nowinkatharite eerorika nantayetziro nokantayetziri.’ Iroorika pikantakeri ontzimatye pimonkaatero. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iro kantacha nokantzi naaka: Te onkameethate paakowaitashityaari Pawa, pimonkaatantyaawori pikantayetziri. Eero paakowaitashitawo inkite, arira risaikiri Pawa janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Eero paakowaitashitawo kipatsi, tema irojatzi rashitari Pawa, ari rimakoryaayitzitapiintzi. Eero paakowaitashitawo Jerusalén, ari ipinkathariwentantzi Pinkathariperori. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Eero paakowaitashitawo piito, pinkante: ‘Eerorika nimonkaatziro nokantziri, rithatzinkitaitenawoota noito.’ Te eeroka materone pishookakairo pipai, picheenkaishitakagairo eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eero pamatawithatantzi. Imaperotatyaarika pantero pikantayetziri, ari pinkante: ‘Jee, nimatero.’ Eerorika pantziro, apatziro pinkante: ‘Eero nimatziro.’ Tema te okameethatzi poshekyeero piñaane.” ");
INSERT INTO cpbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Piyotaiyironi eeroka ikantaitakeri pairani: Arika pinkithoriiteri roki itsipa atziri, okameethatzi ripiyakowentaityaari, rikithoriitaitemiro poki eeroka. Arika pintzinkeryaakoteri itsipa atziri, okameethatzi ripiyakowentaityaari intzinkeryaakotzitaitemi eejatzi eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iro kantacha nokantzi naaka: Te okameethatzi pipiyatyaari kisaneentzimiri. Arika ripasaitemi kashetawooni, pishinetainiri rimontewootemi ripasatemi. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Arika raapithaitemiro piithaare, pishineteniri raanakero eejatzi piwewiryaakowo. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Arika rimperaitemi paanakero owaagawontsi pookero niyanki awotsi, paanakero owaagawontsi pawisakairo tsika ikantaweetakemi pookero. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Arika inkantaitemi: ‘Pimpenawo’, okameethatzi pimperi. Arika inkantaitemi eejatzi: ‘Pimpawakenawo, ari noipiyaimiro’, okameethatzi pimperi eero pithañaapithatari. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Piyotaiyironi eeroka ikantaitakeri pairani: Pineshironkateri powawiiroki. Iriima ikaatzira kishimiri, pinkisheri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jiroka nokantzi naaka: ‘Petakotyaari kisayetzimiri. Pamanakoyetyaari maawoini ineshironkatantyaariri Pawa irirori. Eero pipiyatari kisaneentzimiri, paakameethatairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iroowa ikowakagaitakeriri itomintayetaari Ashitairi Inkitesatzi. Iriitake wetsikakeriri ooryaatsiri, oorentakotziriri maawoini atziri: kameethashireri, eejatzi kaariperoshireri. Iri wetsikakerori eejatzi inkani, rowariiniri maawoini atziri: kameethashireri, eejatzi kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Apatzirorika petakotyaari ikaatzi etakoyetzimiri eeroka, ¿poshiyakaatzi ari ripinataimi Pawa? Eerowa, iroowa rantapiintakeri kaariperoshireri apatotziriri koriki. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apatzirorika petakotari powawiiroki, ¿kaarima aminaashiwaitaantsi? Tema iro rimatapiintakeri itsipasatzi atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kameethashireri pinkantanaiya eeroka, poshiyakotaiyaari Ashitairi Pawa, tema imapero ikameethashireperotake irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pipakagairo powapeyimotari atziripaini pantayetziro pinkameethashiretantaiyaarime. Eekerorika pantatyeero, tekaatsi ripinataimiri Ashitairi Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Arika pimpashitantya, te okameethatzi pinkantante: ‘Nopashitantaka naaka.’ Iroowa rametari owapeyimotantaneri, ikowi irirori impinkathaiterime. Eenitatsirika pinkathatakerine jirika, iro iñaamatsitantyaawori irirori iñaapinkathataiterime. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Arika pamitakoteri ashironkainkari, eero pikamantziri itsipapaini, ");
INSERT INTO cpbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","managa onkantya okaatzi pipashitantakari. Riyotake Pawa irirori, iri pinataimine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Arika pamanamanaatyaari Pawa, te opantawo poshiyakotyaari shamewaitatsiri. Ikatziyapiinta irirori rapatotapiintaitaga, ikatziya eejatzi niyankineki nampitsi, iñaantyaariri isheninka. Ari iñaamatsiwetakawo irirori iñaapinkathaiterime. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Irooma eeroka, arika pamaña, pashitakotya apaniroini pipankoki pinkowakoteri Ashitairi tsipatakemiri apaniroini. Iri ñiimiri apaniroini, ari ineshironkatakemi, irijatzi pinataimine. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Arika pamaña, te ompantyaawo papiipiintero piñaane okaatzi pikantakeri. Iroowa rametari kaari asheninkata aakapaini. Roshiyakaatzi rapiipiintawetawowa riñaane ari inkemakeri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paamaiya poshiyakotarikari eeroka. Tekera pinkowakotanakeriita Ashitzimiri koityiimotzimiri, riyotzitakawo irirori maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jiroka pinkante pamaña eeroka: Ashitanarí, nampitawori inkiteki, Tasorentsi pini eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pimpinkathariwentaina naaka. Pantakainawo jaka kipatsiki okaatzi pinintakaanari eeroka, Poshiyakagainari inkiteweri, pantakairi irirori maawoini pinintakairiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pimpapiintena koityiimotanari noyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimpeyakotakagainawo nokaariperoshirewaitake, Tema nimatakero naaka, nopeyakotairi owaariperoshiretakenari. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eero pishinetana iñaantaitena, inkowaite rantakaitenawo kaariperori. Ari pinkantaitaatyeero pimpinkathariwentantai. Ari pinkantaitaatyeero oshekitzimotemi pishintsinka, eejatzi powaneenkawo. Ari onkantaitaatyeeyaani. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Arika pimpeyakotairi atziri kishimiri, ari impeyakotaimi eejatzi eeroka Ashitairi Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Irooma eerorika pipeyakotairi eeroka atziri kishimiri, eerowa ipeyakotzitaimi Ashitairi irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Arika pitziwentya pinkenkithashiretakoteri Pawa, eero pikamantantayetzi, pinkante: ‘Nitziwentatyaari Pawa.’ Paamaiya poshiyarikari owapeyimotantaneri. Ritziwentapiintaweta irirori, mantsiya ikantayeta ipooki riyotantaityaariri ritziwentatya. Iro iñaamatsitantyaawori irirori impinkathawentaiteri. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Irooma eeroka arika pitziwentyaari Pawa pinkenkithashiretantyaariri, pinkiwawootya, pinkishitya kameetha, ");
INSERT INTO cpbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eero riyotantaitzimi pitziwentatya. Apatziro riyotemi Ashitairi Inkitesatzi, iri pinataimine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Te opantawo pashaagantashiwaitya jaka kipatsiki, owana ipathayi, ari ipiyotari koshintzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iro kameethatatsi pantayetanairo piñaantaiyaawori pisaikai kameetha inkiteki. Oshiyawaityaawo pashaagantaatyeeyaame inkiteki tsika te ipathaanetapai, te itzimapai eejatzi koshintzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tsikarika pashaagantaka, ari pinkenkithashiretapiintero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kameetharika onkantya poki, piñaantawo kameethaini, oshiyawo pinkoñeetyaakotaatyeeme. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Terika opantawo poki, eero piñaantawo kameethaini, oshiyakawo pintsirenikitakotatyeeme.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tekaatsi materone rantawaiteniri apite imperatantaneri. Tema apaani inkowaperote rimonkaateniri rimperatariri, iriima itsipa, inkisaneentanakeri. Ari ikantari eejatzi: Tekaatsi materone ranteniri Pawa ikowakaantziri irirori, arika inkenkithashiretakotero eejatzi ashaagawontsi roshiyakaantanakero iroorikame imperatyaarine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pinkeme nonkante: Te opantawo onkantzimoshirewaitemi pinkante: ‘¿Oitaka noyaari, oitaka nireri, oitaka nonkithaatyaari?’ Eenitatsi otsipa ankenkithashiretapiintairi añaamentoki, iro kowaperotachari, anairo okaatzi owayetapiintari, okaatzi akithaayetapiintari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Thame ankenkithashiretakoteri tsimeryaanipaini. Te riyotziro impankite royaari, te riwetsiki ipanko rowaantyaawori iwankire. Iri kantzimaitacha Pawa, ipayetapiintakeri rowanawo. Aaka rimaperotzi retakotai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Arika onkantzimoshirewaitemi ¿arima pinkantakero powawineentawairo posarentsite? ");
INSERT INTO cpbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Thame ankenkithashiretakotero inchateyakipaini, te añiiro antawainete, te ontyagaanta onkithaatyaari. Temaita okantzimoshirewaitawo, onkante: ‘¿Oitaka nonkithaatyaari?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Owaneenkata kameetha, anairo rowaneenkawo Salomón, pinkathariwetachari pairani. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iri Pawa owaneenkayetzirori. Okantaweta eepichokiini añaawetawo owaneenkatapainta, iro osamani, tekaatsi pantyaawone arika onkamateyatanake, tema richekaitakero, ritagaitakero. ¿Eeroma ikempoyaawentzimi eeroka Pawa? Aritake, eero pikisoshiretzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ataama okantzimoshirewaitakemi, pikantzi: ‘¿Oitaka noyaari, oitaka nireri, oitaka nonkithaatyaari?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apatziro okantzimoshirewaitari kaari kemisantatsine. Irooma eerokapaini, riyotakoyetzimiro Ashitairi Inkitesatzi oitarika koityiimotzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iro kowaperotacha pithotyaakotairi impinkathariwentaimi, pithotyaakotairi eejatzi rowameethashiretaimi, irojatzi piñaantaiyaawori impayetaimiro okaatzi koityiimoyetzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Arira okanta, eero okantzimoshirewaitzimi oitarika awishimotemine inkaamani. Tema okaatzi awishimoyetzimiri jiroka kiteesheri iroñaaka, irootake pawentaantaariri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Te opantawo ankantante: ‘Kaariperoshireri rini nosheninka.’ Arika ankantantake, ari rimataitakai aaka, inkantaitai: ‘Kaariperoshireri pini eeroka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Arika ankantakoteri asheninka, ari inkantakotanakai eejatzi aaka. Ontzimatye aamaiya, arika ontzime antzimotantanewo, rimaperoitaikari paata ripiyaitai. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Oshiyawaitakawo arika ityaakitaime antawo inchapetoki okiki, ¿kantachama amineri itsipa tyaakitachari eepichokiini? ");
INSERT INTO cpbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Eero okanta ankanteri: ‘Pipoke, nagaimiro tyaakitakemiri?’ Tema ityaakitzitakemi eeroka antawo inchapetoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Poshiyakari owapeyimotantaneri. Petawakyaawo eeroka paawairo inchato otzikaakemiri, paminantanaiyaari kameetha paantaiyaanariri tyaakitzitachari itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Te ipaitapiintziri otsitzi wathatsi tasorentsitatsiri. Te ipaitziri eejatzi chancho poreryaayetatsiri, ari roipatsitakero raatzikawaitero. Tera ipaitziri ikowawetari, osheki inkatsimate, ari ratsikantake.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pamanakotaiyani, pithotyaakotante eejatzi, ari piñaakero impaitemiro pikowakotantziri. Poshiyakayero arika pareetya pankotsiki, pinkantapaakeri ashitawori: ‘Pashitareenawo.’ Aritake rashitaryaakemiro ipanko. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ari impaitairi kowakotantatsiri. Inkaate thotyaakotairone, ari roñaagaitairi. Arika inkantaiteri: ‘Pashitareero.’ Aritake rimatakero. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Arika inkowakotemi pitomi, inkantemi: ‘Papá, pimpena pan.’ ¿Arima pimpakeri mapi? ");
INSERT INTO cpbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Arika inkantemi: ‘Pimpena shima noya.’ ¿Arima pimpakeri maanke royaari? ");
INSERT INTO cpbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Petakotari eeroka pitomipaini, kaariperoshireri pinaweta. Iri maperotzirori Ashitairi Inkitesatzi, retakotari irirori maawoini amanayetariri. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Arika pinkowe retakoitemi, petawakyaawo eeroka petakotantya. Iro okantakotziri Inintakaantaitanewo, irojatzi ikantakeri pairani Kamantantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Arika pinkowe pinkyaapankotairi Pawa, poshiyakairo pimpampithatairome awotsimanchaki. Eenitatsi otsipa saawokitatsiri, kaari pomeentsitachane inkenantaityaawo. Osheki pampithatakerori, rashironkaayetaiya sarinkaweniki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irooma awotsimanchaki, te ishenitzi kenantyaawone, iriira areetaachane Pawaki, inkantaitaatyeero rañagai janta.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pinkyaaryootaiyeni, ramatawitzimikari oshiyawetariri Kamantantaneri, roshiyakotapaakyaari oweja te ikatsimatanetzi. Iro kantzimaitacha kaariperoshireri rinatzi, roshiyakari owantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ontzimatye aamagaiyaawo rantayetziri ayotantyaariri ikameethashiretzirika. ¿Añiiroma uva onkithokitantyaawo owaato kitochee? Te. ¿Imatziroma higo onkithokitantyaawo iroori? Te imata eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inchato saankanatatsiri ishooki, okithokitzi kameetha. Irooma inchato sampishitaintsiri, te onkithokinete. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Inchato saankanatatsiri ishooki, te iñagaitziro onkaariperote okithoki. Ari okantari eejatzi inchato sampishitaintsiri, eero iñagaitziro onkameethate okithoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ritowaitziro inchato kaari kithokitatsine, ragaitziro ritagaitero. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Paamagaiyaari yotaayetaimiri. Roshiyakaworika okithokitzi inchato saankanatatsiri ishooki, panterowa riyotaayetzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tzimawetacha osheki kantawetanari: ‘Nowinkatharite pini eeroka, nopinkathakitakemi.’ Eeromaita iñagairo impinkathariwentairi Pawa. Apatziro ikaatzi antanairori ikowakaantziri Ashitanari Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Arika nompinkatharitai paata nompiyotairi maawoini atziri. Eenitatsi kantayetainane: ‘Nowinkatharité, naakotakemi piwairo naaka nokenkithatakoyetzimi. Naakotakemi piwairo nowawisaakotziri raagayetziri peyari. Ari nokantayetziri eejatzi nosheninka: Iro nitasonkawentantariri naakotzirira iwairo Jesús.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nonkantzimaitanakyaari naaka: ‘Te niyotemi. Piyaate jantyaatsikaini, imapero pikaariperoshiretake.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pinkeme, arika pinkenkithashiretero maawoini nokantakemiri, arika pinkemisantakero maawoini, ari okameethatzi. Iro piyotanetyaari. Poshiyaari owatzikirori ipanko shirantaaki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oparyaaweta antawoite inkani, amaaniwetaka. Otampyaawetaka shintsiini, ookantawetapaakawo pankotsi, te aawiiro. Tema owatzikakitya kameethaini shirantaaki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari okantari eejatzi, eerorika pikenkithashiretziro nokantakemiri, eerorika pikemisantanairo, eero piñiiro piyotanetyaawo. Poshiyakotyaari owatzikirori ipanko impanekiiteki. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oparyaapaake inkani, amaanitapaake. Okanta otampyaatapaake, ookantapaakawo pankotsi, tyaanake. Te iñagaitairo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iroowa riyotaayetakeriri Jesús ikaatzi piyowentakariri. Riyokitziiwentanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Te imana ishintsinka riyotaantzira, ranairi riyotaantzi Yotzinkariite. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ikanta roirinkaawo Jesús ikenkithatakera tonkaariki, royaatairi osheki atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ari ripokashitakeri imatane pathaawontsi, rotziwerowashitapaakari, ikantapaakeri: “Pinkatharí, pikowirika petsiyatakotakagaina, niyotzi tzimatsi pishintsinka petsiyatakotakaantantenari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Irojatzi rakotashitantanakariri, riterotakeri, ikantziri: “Nokowi, petsiyatakotai.” Etsiyatanake ripathaawaiwetaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ikantawetawaari Jesús jirika pathaawetachari: “Eerowa pithawetakotana. Apatziro piyaatashiteri Imperatasorentsitaarewo, pimonkaatantyaawori Inintakaantaitakeri rosankenatakeri Moisés, pimperi pashitakaariri Pawa, riyotantaityaari etsiyatakotaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ikanta rowaaganaa Jesús, areetaiyakani nampitsiki Capernaum. Ari ripokakeri reeware rowayerite Roma-satzi, iñeeri Jesús, ");
INSERT INTO cpbNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ikantapaakeri: “Nowinkatharité, tzimatsi nimperatanewo nopankoki, maperokitaka imantsiyatzi, kisopookitake.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Rakanakeri, ikantziri: “Aritake niyaatake netsiyatakotakagairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ikantanake irirori: “Osheki nopinkathatakemi, kaariperori nini naaka, niyotzi te ishinetaantsita pinkyaapankotena. Apatziro nokowi pinkantakaanteri retsiyatakotai. Ari imatakya pinkanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tzimatsi imperatanari naaka, tzimatsi eejatzi owayeripaini nimperatari naaka. Arika nonkanteri: ‘Piyaate’, ari riyaatake. Arika nonkanteri itsipa: ‘Pipoke’, ari ripokake. Arika nonkanteri nimperatanewo: ‘Pantero jiroka’, rimatziro rantziro.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Riyokitziiwentanakeri Jesús ikemakerira ikantake reeware owayeripaini. Ikantanakeri oyaataiyirini: “Rimatakero ikemisantzi jirika, jaka Israel-ki tekaatsi asheninka oshiyaarine. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pinkeme, arika impinkathariwentantai Inkitesatzi, ari intzimake osheki kaari asheninkata poñaayetachari otsipaki nampitsi, inintaayetaiya intsipataiyaari Abraham-ni, Isaac-ni eejatzi Jacob-ni. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iro kantzimaitacha eero itzimaperotai asheninka saikaatsine janta. Iri ikowawetakari impinkathariwentairime maawoini janta, iro kantzimaitacha osheki ripiyathataka, rookairi otsirenikitakera. Ari riraawaitaiyaari, ratsikaikiwaitya inkemaatsitaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ripithokashitanakari reeware owayeripaini, ikantziri: “Pipiye pipankoki. Pimatakero pikemisantzi eeroka, iro retsiyatakotantaiyaari pimperatanewo.” Ari rawisakotanai rimperatanewo janta ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ikanta Jesús jatake ipankoki Pedro. Iñaapaatziiro riyote, omaryaaka, imatakero katsiirentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Riterotapaakero eepichokiini, etsiyatakotanake. Piriintanaka, aminayetawakeniri oita ompawakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Okanta otsireniityaanake, ramaitapaakeniri osheki raayiri peyari. Retsiyatakotakaayetairi, ikisathatawakeri iweyarite. Retsiyatakotakaayetairi eejatzi maawoini mantsiyayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Irojatzi imonkaatantakari ikenkithatakotakeri pairani Kamantantaneri Isaías, ikantake: Iri aanakerori amantsiyare, Irijatzi aanakerori okaatzi akemaatsiyetari. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ikanta iñaakeri Jesús isheniperotapaake atziri piyowentariri, ikantanakeri riyotaanewo: “Jame amontyagai intatsikero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikantawetawaari Yotzinkari: “Yotaantanerí, nokowi noyaatanakemi tsikarika pinkenayete eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Rakanake Jesús, ikantziri: “Apaani otsitziniro, eenitatsi imoo rimaantari, eejatzi tsimeryaanipaini eenitatsi romayero. Iriima jirika Itomi Atziri te otzimi ipanko rimaantapiintyaari irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ari ikantanake apaani riyotaanewo: “Yotaanarí, nokowawetaka naaka noyaatanakemi, iro kantzimaitacha nokowi noñaanairi nopaapate nonkitatanairi, ari noyaatemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ikantanake Jesús: “Poyaatena. Ikaatzi kamashireyetatsiri, ari inkitatairi irirori kaminkaripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ikanta rotetanaa Jesús pitotsiki, itsipatanaari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikanta rimontyaakotanaka, maanake Jesús pitotsiki. Iro riweyaakowetaka niyankyeeronkaini, omapokakeri riyotaanewo otampyaatapaake antawoite, otetaagapaaka ñaa pitotsiki, otamakaatanake inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Riyaatashitanakeri, rowakiryaakiteri Jesús, ikantapaakeri: “¡Yotaanarí, apiinkatye! ¡Powawisaakotaina!” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ikantanakeri irirori: “¿Iitaka pithaawantari? ¿Tekerama pikemisantaperotziita?” Piriintanaka, romairyaakero tampyaa eejatzi otamakaare inkaare, awisanake, mairyaatanai kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Riyokitziiwentaitanakeri Jesús, ipinkathatanakeri antawoite, ikantawakaiyani: “¿Tsika iitaka atziritatsiri jirika? Romairiiro tampyaa eejatzi inkaare.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Areetaiyakani intatsikero, aatakotaiyapaakeni nampitsiki jitachari Gadara. Ari rishiyashitawakari apite atziri raayiri peyari, ipoñaakawo kitataarewoki. Katsimaki ikantakaakari peyari, osheki ithaawantaitakari, te onkameethate inkenaite janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ikantawakeri: “¡Jesús, Itomi Pawa! ¿Irootaintsima powasanketena? ¿Tsikama nokantakemika eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari risaiki janta osheki chancho, roshimotokawaitaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Riñaawaitanake iweyarite, ikantanake: “Arika powawisaakotairi jirika naaganewo, potyaantena naaka ipiyotakaga chancho.” ");
INSERT INTO cpbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Rakanakeri Jesús, ikantziri: “Piyaate peyari.” Jatanake peyaripaini chanchoki, raagapaakeri, irojatzi rishiyantaiyanakarini impeetaki, mitagaiyapaakeni maawoini inkaareki, thonkaiyakani ripiinkake. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ikanta iñaakeri saikawentziriri, shiyaiyanakani. Jatake nampitsiki, ikamantapaakeri maawoini atziri okaatzi iñaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Irojatzi riyaatashitaitantanakariri Jesús, ikantaitapaakeri: “Te nokowaiyini pisaike nonampiki, pamine tsika pinkene.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ikanta rotetanaawo Jesús pitotsiki, montyaakotaawo inampiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari ramaitakeniri kisopookiri, inatakoitakeri shitashintsiki romaryaantapiintari. Riyoshiretawakeri Jesús atziripaini natakotakeriri, riñaanatawakeri mantsiyari, ikantziri: “Thaamentashire pinkantya notomi, ari netsiyatakotakagaimi, ipeyakoitaimiro pikaariperoshirewetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ikanta ikemawake yowairentziite, ikantashiretanake: “Rithainkatziiri Pawa jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Riyotake Jesús tsika ikantashiretzi, rosampitanakeri: “¿Oitaka okaariperotantari pikantashiretziri? ");
INSERT INTO cpbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tema okameethatzi nonkante: ‘Ipeyakoitaimiro pikaariperoshireweta?’ ¿Irooma pikowi nonkanteri: ‘Pinkatziye, panashitaiya?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iroñaaka piyoteri jirika Itomi Atziri oshekitzimotziri ishintsinka, ipeyakotairi kaariperoshirewetachari.” Ripithokashitanakari mantsiyari, ikantziri: “Pinkatziye, paanairo pomaryaantawetari, piyaatai pipankoki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Katziyanaka mantsiyawetachari, jatai ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iñaakeri maawoini atziri piyotainchari, riyokitziiwentanakeri iñaawairira riyaatai. Ikantaiyanakeni: “Imaperotatziiri Pawa, iri matakerori oshekitzimotantakariri ishintsinka Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ikanta rowaaganaka Jesús, irojatzi iñaantapaakariri jitachari Mateo, apatotziriri koriki. Ikantapaakeri: “Poyaatena.” Katziyanaka, royaatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Raanakeri ipankoki rowakayaari, itsipataanakeri riyotaanewo. Osheki jatanaintsiri apatotziriri koriki, riyaatake eejatzi osheki kaariperoshiretatsiri. Ari itsipatakari Jesús rowaiyakani. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ikanta iñaakeri Fariseo-paini, ikaimakeri riyotaanewo Jesús, rosampitakeri: “¿Iitaka itsipatantariri Jesús apatotziriri koriki, itsipatakari eejatzi kaariperoshireyetatsiri? Te okameethatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ikemawake Jesús, ikantanake irirori: “Arika imantsiyate atziri ripokashitziri aawintantzinkari, iriima atziri kaari mantsiyatatsi tekaatsi inkowe irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ontzimatye pinkenkithashiretero Inintakaantanewo Pawa, kantatsiri: Te apa nonkoweri pamayetainari pipira pitagainari. Iro nokowaperotairi pineshironkayetairi pisheninka. Te apa nipokashiteri kameethashireri nonkaimashiretairi, tema nipokashitatziiri kaariperoshireri nonkaimashiretairi rookairo kaariperori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ikanta ripokaiyakeni riyotaanewo Juan, rosampitapaakeri Jesús, ikantziri: “¿Iitaka kaari ritziwentanta piyotaanewo? Nitziwentapiinta naaka, ari ikantzita riyotaanewo Fariseo-paini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Rakanakeri Jesús, ikantanakeri: “Arika aate awakagaantsiki, ¿arima owashiretapaakya? Arika paata, ragaitakeri iimentaitari, aripaite ritziwentaitya. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Apaani antyashipawo ikithaataitari, arikame rowamatankaitantyaawo osape owakerari, ari isagaaperotanake aminthatanakyaarika owakerari. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ari okanta eejatzi, te ikameethatzi antyashipari mashitsinaki rowantaityaawo eeryaatatsiri riraitziri. Arika rowantaitakyaawo, ari risanaryaanake, apaatashiwaitakya riraitziri eejatzi mashitsinaki. Iri kameethatatsi owakerari mashitsinaki rowantaityaari, eero apaawaita apitekeroini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ikenkithawaiminthaitzi Jesús, areetapaaka apaani jewari, rotziwerowapaaka, ikantapaakeri: “Kamake nishinto, iroowa nipokantari piyaate nopankoki piterotero eepichokiini, añagaita.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jatanake Jesús eejatzi riyotaanewo, royaatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Okanta apaani mantsiyatatsiri tsinane, osheki osarentsi osokaawaitaka, tzimakotake 12 osarentsi, okenashitapaakeri itaapiiki Jesús, iterotakero opatzikaakiki iithaare. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Okantashiretzi: “Arika niterotakero iithaare, ari netsiyatakotai.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ripithokashitanakawo Jesús, ikantziro: “Thaamenta pinkantaiya nishintó, etsiyatakotakagaimi pikemisantake.” Apathakero etsiyatanake omantsiyarentsite tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ikanta rareetapaaka Jesús ipankoki jewari, iñaapaatziiri showiwentzirori kamaintsiri, osheki atziri akisheenkataintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ikantapaakeri Jesús: “Pisheke, te okami piraakotaiyakarini imakoryaatzi.” Thainka rowaitakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Romishitowapaakeri maawoini, kyaapaake Jesús, rotaiyawakotapaakero, piriintanaawo ewankawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te imanakotanaka rantakeri Jesús, ikemakoitanakeri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ikanta rowaaganaawo Jesús, royaatanakeri apite mawityaakiri, ikaimi, ikantzi: “¡Icharine David-ni, pineshironkataina!” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Areetapaaka pankotsiki, eejatzi mawityaakiri. Ripokashitapaakeri okaakiini, rosampitakeri Jesús, ikantziri: “¿Pawentaanama eeroka ari imatakya nowawisaakotaimi?” Ikantaiyini irirori: “Ari pimatakero nowinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Rakotanake Jesús, riterokitakeri, ikantziri: “Okiryaakagaimi pawentagaanaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Apathakero raminanai kameetha. Ishintsineentawakari, ikantziri: “Te nokowi pinthawetakotena nokiryaakagaimira.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ikanta riyaatai, ikamantantayetanake, ithonka ikemakoitanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ikanta ramaitapaakeniri Jesús apaani atziri raayiri peyari, kisowaante ikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Retsiyatakotakaawakeri Jesús jirika atziri, kenkithawaitanai roisowaantewetakari peyari, tema rookapithatakeri iweyarite. Riyokitziiwentaitanakeri Jesús, ikantashiretaitanake: “Te añaapiintzi oshiyaarine jirika anampiki Israel-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ikantaiyini Fariseo-paini irirori: “Ripasawyaatziiri reeware iweyarite retsiyatakotakaantariri raaganewo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Rithonkakero ranashitawo Jesús maawoini nampitsi, riyotaantayetake rapatotapiintaitaga. Ikenkithatakotapiintakero Kameethari Ñaantsi tsika onkantya impinkathariwentantai. Retsiyatakotakaayetairi maawoini, tekaatsi apaani mantsiyarentsi pomeentsitzimotyaarine. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iñaayetzirira osheki piyowentariri, antawo retakoshiretakari Jesús, ikantake: “Imapero rashironkaayetaka jirika atziripaini. Roshiyakari oweja eerorika itzimi kempoyeerine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eekero ikantanakitziiri riyotaanewo: “Jirikapaini atziri roshiyakawo isampainkatzi pankirentsi, temaita itzimaperotzi atziri owiiterone. ");
INSERT INTO cpbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pamanaiyaari Awinkatharite rotyaanteeta osheki jatatsine atziriki, tema yotacha osheki inkaate kemisantaatsine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ikanta riyoyaake Jesús ikaatzi 12 riyotaanewo, ripasawyaakari ritasonkawentantzi. Rimatanakero irirori retsiyatakotakaayetai osheki atziri kantawaitachari imantsiyarentsite, eejatzi ikaatzi raagayetziri peyari. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jirika ikaatzi 12 riyoyaakeri Jesús: Etanakawori Simón, iitakeri Pedro. Eejatzi Andrés, irirentzi Pedro. Eejatzi Jacobo itomi Zebedeo itsipatakari rowawiiroki Juan. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Eejatzi Felipe, Bartolomé, Tomás, Mateo apatowetariri koriki, Eejatzi Jacobo itomi Alfeo, Tadeo, ");
INSERT INTO cpbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","eejatzi Simón, iitzitakari Jokaakotantaneri. Eejatzi weyaantaapaakawori Judas Iscariote, iriira pithokashityaarine paata. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ikanta rotyaantakeri Jesús kaatatsiri 12, ikantawakeri: “Eero pikenanake risaikira atziri kaari asheninkata, eero pikeni eejatzi inampiki Samaria-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iri petapaintya piyaatashiteri icharineyetari Israel-ni, oshiyakariri oweja itzipinawaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tsikarika pinkenayetake pinkamantantayete, pinkante: ‘Irootaintsi impinkathariwentantai Inkitesatzi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Petsiyatakotakaayetairi maawoini mantsiyari, powañaayetairi kamayewetachari, petsiyatakotakagairi pathaawaitatsiri, eejatzi raagayetziri peyari. Tema neshironkataarewo pinayetake, te piñiiro inkowakoitemi. Pimatairo eeroka pineshironkatantai eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Eero paanake piyorikite pithaateki, ");
INSERT INTO cpbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","eero paanake eejatzi pithaate, eero paanake apite piithaare, pizapato-te, pikotziki, tekaatsi apaani paanake. Tema ikantaitzi: Ripinaiteri antawaitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Arika pareetakya nampitsiki, pamine aakameethatemine, iri pintsipatapaakyaari, irojatzi pawisantanakyaari otsipaki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Arika pareetakya pankotsiki, piwethatapaakyaari ikaatzi saikatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Arika raakameethatawakemi piwethatapaakari, ari iñeero risaikai kameetha. Irooma eerorika raakameethatawakemi, aminaashitaka piwethawetapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eerorika raakameethaitzimi, eerorika ikemisantaitzimi eejatzi, pawisapithateri, potekanairo piipatsiyitzite. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tema iri rimaperoite paata rowasankeeteri jirika, ari anaanakero ikantaitakerira Sodoma-satzi eejatzi Gomorra-satzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Notyaantzimika iroñaaka. Poshiyawaitakari rotyaantaitziri oweja tsika ipiyotapaa owantaneri. Iro kantacha ontzimatye poshiyakotyaari kokiyantzi maanke. Ontzimatye eejatzi poshiyaari shiro te ikatsimawaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Paamaawentya. Tema raakaantaitatyeemi jewariki ripasawaitaitemi pankotsiki rapatotapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Irojatzi ragaitantanakemi risaikira pinkathariperori okantakaantziro pawentaanaga. Ari pinkenkithatakoyetainari, irojatzi inkemantayetaiyaari itsipasatzi atziri kaari asheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Arika piñaakero raayeetanakemi, eero pikantashirewaitzi: ‘¿Oitaka nonkantapaakeri?’ Tzimatsi yotakaimirone oita pinkanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eero piyotashitawo apaniroini oita pinkanteri, Tasorenkantsi poñaachari Ashitzimiriki, iriira yotakaimirone onkaate pinkantayetapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ari iñagaitake aakaanterine irirentzi rowamaakaanteri. Piñe aakaanterine itomi. Piñe tsitokakaanterine ipaapate inkisaneentanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Osheki piñeero inkisaneentaitemi okantakaantziro pikemisantaanaga, iro kantzimaitacha arika pinkamaitanakyaawo pawentaina, aritake nowawisaakoshiretaimi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Arika inkisaneentaitanakemi nampitsiki, pawishe otsipaki nampitsi. Tema tekera pithonkiroota pinkenayete maawoiniki nampitsi tsika risaikayetzi Israel-iite, irojatzi ripiyantaiyaari jirika Itomi Atziri. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Te iñagaitzi apaani riyotagaitziri ranayeri yotairiri. Te iñagaitzi apaani imperataarewo ranayeri imperatariri impinkathaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apatziro añiiri riyotagaitziri roshiyakotari yotairiri pairani. Ari ikantari eejatzi imperataarewo. Tema ikisaneentaitakena naaka iroñaaka, roshiyakagaitakena naakame Beelzebú iwinkatharite peyari. Eeroka rimaperoite inkisaneentaitemi pikemisantaanaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Iro kantzimaitacha eero pipinkashiwaitari jirikapaini. Ontzimatye onkoñaatakoyetai okaatzi manakowetainchari, ooñaawontairo kaari ikemathaweeta pairani. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apaniroini niyotakaayetaimiro eeroka jirokapaini, te riyotakotziro thainkantaneri irirori, eeroka kenkithatakaayetairine. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Eero pipinkashiwaitari kowatsine ritsitokemi, eerowa rimatziro irirori rotyaantemi sarinkaweniki. Iri pimpinkathateri Pawa, tema iri matzirori rotyaantemi sarinkaweniki. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pamine, te ripinaperoweta tsimeryaanipaini, iri kantacha Pawa riyotzi arika inkamagaante apaani. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Riyotzitawo Pawa okaatzi tzimayetatsiri aishi. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Piñaakero, raminawentziri Pawa tsimeryaanipaini, eeroka rimaperotzi raminawentzimi. Eerowa pipinkashiwaitari kisaneentzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Arika pinkanteri pisheninka: ‘Nopinkathatairi Jesús’, aritake nonkantairi Ashitanari Inkitesatzi: ‘Papá, ipinkathataana jirika, asheninkataari.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Irooma pinkanteririka pisheninka: ‘Te nompinkathateri Jesús’, ari nonkantzityaari naaka, nonkantairi Ashitanari: ‘Papá, te ipinkathatana jirika, te asheninkatari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Te nokowi ikompitzimotemi oita nipokantakari. Te inta niyotaayetairi atziri raakameethatawakagaiya. Tema nipokakera, oshiyawaitakawo namatyeemirome owathaamentotsi pantaminthatawakaantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tema iro nipokantakari: Inkisaneentantyaariri atziripaini ipaapatetari, Onkisaneentantyaawori tsinane onaanatetari, Onkisaneentantyaawori tsinane ayiro. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iri pithokashitawakaachane atziripaini inkisaneentawakaiya risaikaiyinira ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tema iro kameethawetachari petakoyetyaari pipaapate, pinaanate, peentsitepaini eejatzi. Iro kantzimaitacha arika anaanakero okaatzi pinintana pawentaana naaka, tekeraga pithotyiiro pawentaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ontzimatye pinkyaaryoowentero nokenkithatakoyetakemiri, onkantawetya inkentakoitemi. Arika pipakaakero, tera pikyaaryoowentziro pawentaawetaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tema ikaatzi etakowaitachari apaniroini rantayetziro iñaamatashiyetari, ari impeyashitaiya. Iriima kamawentenane rantanairo nokowakairiri naaka, ari rawisakoshiretai.” ");
INSERT INTO cpbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tzimatsirika iita aapatziyemine, naakaga raapatziyaka. Ari okantari eejatzi, inkaate aapatziyainane naaka, iri raapatziyaka Ashitanari otyaantakenari jaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tzimatsirika yotemine Kamantantaneri pini, irojatzi raapatziyantanakemi, arira ripinatairi Pawa paata, tsipatakariri Kamantantaneriite. Ari okantari eejatzi, tzimatsirika yotakemine kameethashireri pikantanaawo pikemisantanai, irojatzi raakameethatantanakemi, arira ripinatairi Pawa paata, tsipatakariri kameethashireri. ");
INSERT INTO cpbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Arika riyoitemi eerokatake niyotaanewo, iro ompoñaantyaari impemi pimere, riyotakerowa Pawa, iri pinatairine jirika etakotakemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ikaatakero Jesús riyotaayetakeri 12 riyotaanewo. Owaaganaka inkamantante maawoiniki nampitsi saikatsiri janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ikanta Juan omitsitsiyaatantaneri, romonkyagaitakeri chapinki, ikemakotakeri rantayetakeri Cristo, rotyaantake apite riyotaanewo irirori, ");
INSERT INTO cpbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","rosampiteri Jesús, inkanteri: “¿Eerokatakema iitaitziri, ‘Pokatsine?’ Kaaririka eeroka, ¿Eenitatsima itsipa naamayaari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ikanta rareetaiyakani, rosampitapaakeri Jesús. Iro ikantantanakariri irirori: “Arika piyaatai, pinkamantapairi Juan maawoini pikemakeri eeroka, okaatzi piñaayetakeri nantakeri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tema nokiryaakagairi mawityaakiri, nanashitakaayetaari kisopookiri, netsiyatakotakaayetairi pathaawaiwetachari, nokemakaayetairi witakempitari, nowañaayetairi kaminkari, nokenkithatakoyetainiri Kameethari Ñaantsi ashironkainkaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Irootake inkimoshiretantaiyaari kaari kisoshirewentainane.” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ikanta ripiyayetanaa riyotaanewo Juan, rosampitanakeri Jesús ikaatzi piyowentakariri, ikenkithatakotziri Juan, ikantzi: “¿Tsika iitaka poshiyakairi piñaakeri chapinki ochempiki? ¿Iriima piñaake apaani oshiyakawori sawoo ompironkatonkitakaari tampyaa okantakaari te ithaamentashireta? ");
INSERT INTO cpbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Piñaapaakerima rowaneenkataka ikithaataka? Te. Tema ikaatzi owaneenkatachari ikithaata, risaikawankotziri irirori pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Iro piyaatashitantariri piyotaiyakeni Kamantantaneri rini. Tema rimaperotatziiro irirori rawisanakeri Kamantantaneriite. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tema iriitake rosankenatakoitakeri pairani, riñaanatziri Pawa Itomi, ikantziri: Notomí, ari notyaantake etyaawone inkamantakotemi, Iri wetsikaantemine tsika pinkenapaake eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pinkeme nonkante naaka: Atziripaini ikaatzi tzimayewetainchari pairani, tekaatsi anairone riyotanetakari Juan. Iro kantzimaitacha inkaate impinkathariwentairi Pawa inkiteki, tsinampashiretaatsine janta, ranagairi irirori Juan. Imaperotatyaaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tema retanakawo pairani Juan ikenkithatakaayetakemi, eenitatsi osheki atziri ñaamatanakawori kameethaini iñeero tsika ipinkatharitai Inkitesatzi. Antawoite ikowanake iñeero oshiyawaitakawo ishintsitaitzi arika romanataitya. Irojatzi ikantaita iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pairani tekera itzimiita Juan, tzimawetacha Kamantantaneri eejatzi Inintakaantaitanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iriira Juan ikenkithatakoitakeriri pairani, iriitake Elías-tatsiri piyaatsine. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kowirori inkemathatero, inkemisante. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Noshiyakaakemiri koshekawairentzi eentsi arika roshiyakaawaitya, ");
INSERT INTO cpbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ikantawaka: ‘Jame ashowite omampaantyaari.’ Temaita ikowi. Ikantawaka eejatzi: ‘Jame omampaiya owashiretantyaari.’ Te ikowiro eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ari pikantaiyakani eeroka. Piñaawetawakari Juan, ritzitapaakawo rowanawo, te ririro kachori, pikantaiyakerini: ‘Raagatziiri peyari, iro ritziwentantari.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ripokawetaka Itomi Atziri, te ritzitawo owanawontsi, ririro kachori eejatzi. Pikantaiyakerini: ‘Kaariperori rini jirika, osomiyawairentzi, shinkiyantzi rini eejatzi. Raapatziyari apatotziriri koriki, raapatziyari eejatzi kaariperoshireri.’ Tekaatsi oitya, tema arika iñagaitakero onkaate awisayetaatsine paata, arira riyoitairi imapero riyotanetzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ikenkithatakotanakeri Jesús ikaatzi ñaawetakawori ritasonkawentantayetake nampitsikipaini, temaita ripakairo ikaariperoshiretaiyini. Ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ikantamatsitaitziri Corazín-satzi, eejatzi Betsaida-satzi. Osheki iñaayewetakena nitasonkawentantayetake, temaita ikemisantaiyini. Iriime ñaakenane Tiro-satzi, Sidón-satzi nitasonkawentantzi, ari rowashiretakotanakyaame ikaariperoshiretake, ripakaanakerome. Inkemisantayetaime maawoini iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Paata arika raayeetairi kameethashiretaintsiri, eero rimaperoitziri rowasanketaiteri Tiro-satzi, eejatzi Sidón-satzi. Rimaperoitairi rowasanketaiteri Corazín-satzi, eejatzi Betsaida-satzi, tema iñaawetakena nitasonkawentantayetzi, temaita ikemisantzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eejatzi inkantayetaiya Capernaum-satzi, ikenkithashiretaiyani irirori riyaayetai inkiteki, iro kantzimaitacha osheki ikisoshiretake, riyaayetai ikenayetzira kaminkari. Iriime ñaakeroneme Sodoma-satzi pairani okaatzi iñaayetakeri Capernaum-satzi, inkemisantayetaime irirori, eero raperaatairime pairani Pawa saikaiyatsinime iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Arika raayeetairi paata kameethashireyetaintsiri, iriira rimaperoitai rowasanketaitairi Capernaum-satzi, anaanakero rowasanketakeri pairani Sodoma-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ikanta ramanamanaatanakari Jesús Ashitariri, ikantanakeri: “Papá, eeroka pinkathariwentziriri maawoini inkitesatzi, eejatzi maawoini kipatsisatzi, osheki niwetharyaakemi. Tema eeroka yotakaayetairiri oshiyakariri eentsi tsinampashiretaatsiri, kaari riyoyetzi yowairentziite. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tema iro inimotakemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ikantanakeri piyowentakariri: “Iri Ashitanari yotakaakenawori maawoini. Apaniroini riyoperotana naaka tema Itomi rowana. Ari nokantari eejatzi naaka apaniroini niyoperotziri. Irojatzi riyoyetairi inkaate niyotakaayetairi naaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Arika piñeero pimakoshirewaite, arika piñeero oita ñaantsipookitzimotemine, pipokashitaina naaka, pinkamantainawo, aritake piñagairo nimakoryaakaayetaimi. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Eero pimanintziro ñaantsipookitzimotemine, naakatake imperatzimiri pantero. Eenitatsi nokowiri niyotaimiri, te niyote naaka nowatsimaashirewaitya, tsinampashireri nini. Ari piñagairo nimakoryaashiretakagaimi. ");
INSERT INTO cpbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tema okaatzi nimperatantari naaka, te opomeentsiperota.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Okanta apaani kiteesheri rimakoryaantaitari, ikenanake Jesús pankirentsimashiki. Tema ritasheyaiyatziini riyotaanewo, ikowiitanake okithokiki pankirentsi royaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iñaakeri Fariseo-paini, iro ikantantakariri Jesús: “Pamineri piyotaanewo. Jiroka kiteesheri rimakoryaantaitari ini, te ishinetaantsita inkowiitaite.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rakanakeri Jesús ikantziri: “Tema piñaanatakotziri ikantakota David-ni, aantawetariri ritashe itsipayetakari ikaataiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ikyaake pairani tasorentsipankoki, rowakawo tasorentsitatsiri, ipayetakeri eejatzi itsipatakari. Te ishinetaantsiweta, apatziro rowapiintawo Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Rosankenaitake eejatzi pairani Inintakaantaitanewo, okantzi: ‘Eero pantawaitantawo kiteesheri rimakoryaantaitari.’ Iro kantzimaitacha riyaatapiintzi Imperatasorentsitaarewo kiteesheriki rimakoryaantaitari tasorentsipankoki, rantawaitapiintzi. Tekaatsi kisakotyaawone. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nokantzi naaka, eenitatsi jaka impinkathaperoiteri, iri anairori tasorentsipanko. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iro rosankenatantaitakawori pairani, kantatsiri: Te apa nonkoweri pamayetaina pipira pitagainari. Iro nokowaperotairi pineshironkayetairi pisheninka. Arikame pinkemathatero jiroka, eero pikantzirime jirikapaini, te ikaariperoshiretzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jirika Itomi Atziri ipinkathariperotzi irirori, ranairo kiteesheri rimakoryaantaitari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ikanta rowaaganaawo Jesús, ikyaapai eejatzi rapatotapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ari risaikakeri janta atziri kisoimpekitatsiri. Ikanta Fariseo-paini, rosampitakeri Jesús, ikantziri: “¿Kameethatatsima petsiyatakotakagairi kisoimpekiri kiteesheriki rimakoryaantaitari?” Iroowa rosampitantariri ontzimantyaari inkantakoteriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Rakanakeri irirori, ikantziri: “Te paminaminthatashitari pipira arika rotetya omoonaki kiteesheriki rimakoryaantaitari, petakotari, pagairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iriira retakoperoitari atziri, ranairi piratsi. Te owaariperoshiretantzi aneshironkatante kiteesheriki rimakoryaantaitari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Riñaanatanakeri atziri kisoimpekiri, ikantziri: “Pampiryaawakotai.” Matanaka atziri, akotsitanai, oshiyanaawo otsipa rako. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kisaiyanakani Fariseo-paini. Jataiyakeni, ikenkithawaitaiyini, ikantzi: “¿Jimpe ankanterika Jesús, ampeyakaantyaariri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yotake Jesús ikowaitatzi ritsitokaiteri, iro rowaagantanaari. Royaatanakeri osheki atziri, retsiyatakotakagairi maawoini mantsiyari. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ikantayewetakari: “Eerowa pithawetakotana.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ari imonkaatari rosankenatakagaitakeriri pairani Kamantantaneri Isaías-ni, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jirika nimperatanewo, iri niyoyaakeri. Netakotanewo rini, iri oimoshirenkanari. Kisokero roweri Tasorenkantsi, Inkenkithatakagairi kaari asheninkata, inkamantairi irooperotatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eero richeraawentawaita irirori, Eero ikemaitziri ishintsite inkenkithatakotya, ");
INSERT INTO cpbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eero rowatsiperotziro risatairo sonkare sataawetainchari, Eero roitsiwakiro paampari paampamenkiwetainchari, Irojatzi rimatantyaawori iñeero irooperotatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iri royaakoneentairi kaari asheninkata raakotairi iwairo. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ikanta ramaitakeniri Jesús raayiri peyari, ramashookitakaakari, ikisowaantetakaakeri eejatzi. Retsiyatakotakaawakeri, aminanai kameetha, ñaawaitanai eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Riyokitziitanake maawoini atziri, ikantaiyini: “¿Iriima jirika icharine David-ni oyaakoneentziri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kemaiyakeni Fariseo, ikantaiyanakeni irirori: “Jirika atziri ishintsitakaatziiri ashitariri peyari Beelzebú, iro rowawisaakotantariri raagayetziri peyari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iri kantzimaitacha Jesús riyotakotakeri ikenkithashireyetari, ikantanakeri: “Atziri ipinkathariwentaitziri tsikarikapaini, arika rantaminthatawakaiya, ari iñaakero rookanawentawakaiya. Eejatzi arika rantaminthatawakaiya inampiki atziri, ari iñaakero rookanawentawakaiya inampiki. Arika rantaminthatawakaiya atziri ikaatzi risaikawankotawakaa, ari iñaakero rookanawentawakaiya ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ari ikantari eejatzi peyari arika rantaminthatawaiyaame. Arika rookanawentawakaanakya, ¿eeroma iñiiro rithonkya? ");
INSERT INTO cpbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iriirikame Kamaari Beelzebú shintsitakainane naaka, ¿irijatzima Kamaari shintsitakayiriri piyotaanewo eeroka rowawisaakotantariri raagaitziri? Arika okanta pithawetakotatziiri piyotaanewo, ari inkisaneentawentakemiro okaatzi pikantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Iri Tasorenkantsi poñaachari Pawaki shintsitakaanari naaka nowawisaakotantariri raayiri peyari. Irijatzi Pawa omapokakemiri eeroka ipinkathariwentantzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Arika inkowaite inkoshiiteri shintsitatsiri kameetha atziri, ontzimatye retaitawakyaari roosoiteri, eero ikisakowentantawo rashiwetari arika rayitaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ikaatzi kaari aapatziyanari naaka, iriitake kisaneentanari. Inkaate kaari amitakotenane rowiitakotena, reewanatakotatyaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iro kantzimaitacha nokantzi naaka: Kantacha impeyakotairi Pawa inkaate kaariperoshirewetachari, eejatzi inkantairi maawoini ñaawaiwetawori kaariperori ñaantsi. Iriima kishimatakerine Tasorenkantsi, eero ipeyakoitairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ari okantari eejatzi: Kantacha impeyakotairi Pawa inkaate kishimawetyaarine Itomi Atziri, iriima kishimatakerine Tasorenkantsi, eero iñagairo impeyakoitairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Oshiyawaityaawo arika iñagaitero kameethari chochoki, riyotaitzi kameetha ini owaato tsika opoñaakawo chochoki. Ari okantari eejatzi arika iñagaitero chochoki piyantatsiri, riyotaitzi kaariperori ini owaato tsika opoñaaka iroori. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Poshiyakari maanke, kaariperoshireri pikantaiyakani. Tekaatsi pinkenakairo piñaawaitero kameethari, te ompantyaawo pikenkithashireyetari, iro okaariperotantakari piñaawaiyetziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tema apaani kameethashireri ikenkithashiretawo kameethatatsiri, iro okameethatantari rantayetziri. Iriima kaariperoshiretatsiri te ikenkithashiretapiintawo kameethatatsiri, iro okaariperotantari rantayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iro nokantantari naaka, ari raminakoitairo paata kaariperori riñaawaitaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kameetharika okaatzi piñaaneyetari, ari raakameethaitaimi. Irooma terika okameethatzi, inkantayeetaimi: ‘Kaariperoshireri pinake, osheki pinkemaatsitaiyaawo.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ikanta rakaiyanakeni Fariseo itsipatakari Yotzinkariite ikantanakeri: “Yotaantanerí, nokowi noñeemi pitasonkawentante.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Rakanake Jesús ikantzi: “Kaariperoshireri pinaiyini eeroka, pithainkanewo powakeri Pawa, pikowaiyini piñeena nitasonkawentante. Eeromaita noñaayimiro, apatziro piñeero oshiyaawone awishimotakeriri pairani Jonás, ");
INSERT INTO cpbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","iniyantakariri oshiyariri antari ñaaweri, tema mawa kiteesheri risaikake imotziki. Ari inkantyaari eejatzi jirika Itomi Atziri inkitawetapaintya mawa kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Paata arika raminakoitairo okaatzi rantaitziri, ari riyakowentaimi Nínive-satzi, tema ikemisantairi pairani irirori Jonás ripakaanairo ikaariperoshirewetaiyani. Tema jirika saikimotakemiri iroñaaka ranairi Jonás. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Paata arika raminakoitairo okaatzi rantaitziri, ari iyakowentaimi tsinane pinkathawotatsiri pairani nampitsiki Sabá, tema ipokashitakeri iroori pinkathari Salomón, okemisantairi. Jirika saikimotakemiri iroñaaka ranairi Salomón.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Oshiyawaitakawo risaikashiretantari peyari apaani atziri, ipankotetakawo rañaamento. Arika rookaweetakyaari, awisakowetaa atziri risaikantakari peyari. Jatawetaawo ikenawaitzi ochempiki, te iñi jimpe risaike. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ikantashiretai peyari: ‘Nipiyaita nopankoki tsika nopoñaanaka ketziroini.’ Piyaawo peyari, iñaapairi atziri kameetha opishitaka rañaamento, owaneenka okantaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Riyaatashitakeri maperotzirori ipeyaritzi, inkantakeri: ‘Jame aate nopankoki, pintsipatena ampinkatharite.’ Ramake ikaatzi 7. Ari rashironkaaperotyaari jirika atziri, eero roshiyaa rashironkaaweta pairani eepichokiini. Ari pinkantayetaiyaari iroñaaka eerokapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eekero ikenkithatakaatziiri Jesús atziri piyowentakariri, ari areetapaaka inaanate otsipatakari irirentzipaini, okatziyapaaka jakakeroki, okaimakaantapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ikantaweetakari: “Ari ipoki pinaanate otsipatakari pirentzipaini, okowi oñeemi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ari rakanake ikantzi: “¿Iitaka pikenkithashiryaari iroowa nonaanate, iriira nirentzitari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Rookotanakeri ikaatzi riyotaayetapiintakeri, ikantzi: “Jirikapaini iriitake noshiyakagairi nirentzi, iro noshiyakagairi eejatzi nonaanate. ");
INSERT INTO cpbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tema maawoini antanairori ikowayetziri Ashitairi Inkitesatzi, iriitake nirentzitaari, irootake nitsirotaari, irootake ninirotaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ikanta rishitowanai Jesús pankotsiki, jatanai inkaarecheraaki. Ari risaikapaake. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ipiyowentapaari osheki atziri. Iñaake othataka pitotsi, otetapaaka, saikapaake. Katziyaiyakani atziri inkaarecheraaki. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Roshiyakaawentatziiniri okaatzi ikenkithatakairiri, ikantziri: “Tzimatsi pankiwairentzi jatatsiri impankiwaite. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ikanta rookakitakero iwankire, tzimatsi jokakitapainchari awotsiki, ripokapaake tsimeryaani, rowapaakawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tzimatsi otsipa jokakitapainchari omapipookitzira tekaatsipero kipatsi, ari ishookawetanakari intsipaite. Te otontapathatzi kipatsi, ");
INSERT INTO cpbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","sampishitanake pankirentsi ishintsikitapaakera ooryaa, tema te okyaaperotzi oparitha inthomoiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tzimatsi otsipa jokakitapainchari kitocheemashiki, anaanakero kitochee ishookanake, kamanake pankirentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Irooma otsipa jokakitapainchari okameethapathatzi kipatsi, saankana ishookanake, kithokitanake maawoini. Tzimanai okithoki apawopaini okaatzi shookapaintsiri. Apaani shekichonchoitanaintsiri okithoki, otsipa shekipiyokineentaintsiri, otsipa eepiyokiini okithokitanake. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kowatsiri inkemathatero, rowayempitatya inkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Irojatzi rosampitantanakariri riyotaanewo, ikantziri: “¿Oitaka poshiyakaawentziniriri atziripaini?” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rakanake Jesús, ikantzi: “Rishinetaitakemiro eerokapaini piyotairo tsika ikanta ipinkathariwentantai Inkitesatzi, iriima jirikapaini te rishinetaitziniri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ikaatzi oshekitzimotakeri, ari oshekichonchoitzimotairi. Iriima kaari oshekitzimotzi, eero oshekichonchoitzimotairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iroowa noshiyakaawentantawori jiroka, onkantya raminawetya jirikapaini, eero iñiimaitawo. Arika inkemawetyaawo, eero riyotawakero nokantawetariri. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iri ikenkithatakotake pairani Isaías-ni, ikantake: Pinkemaiyawetyaani, eeromaita piyotaiyironi. Paminaiyawetyaani, eeromaita piñagaiyironi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tema kisoshire ikantaiyakani jirikapaini. Witakempitari ikantaiyakani. Amashookiri ikantaiyakani eejatzi. Irootake kaari iñaantaiyawoni, Kaari ikemantaiyani, Kaari ikenkithashiretantaiyani. Te ikemisantaiyini, eero nowawisaakotairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Irooma eerokapaini kimoshire pikantaiyaani, tema piñagairo, pikemayetairo eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iro ikowaiyawetakarini pairani Kamantantaneriite eejatzi kameethashireriite, iñeerome irirori okaatzi piñaayetairi eerokapaini. Ikowawetaiyakani inkemerome pikemaiyakerini eeroka. Te iñeena, te ikemana eejatzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pinkeme nonkamantemiro okaatzi noshiyakaawentakeriri pankiwairentzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tzimatsi kemirori nokenkithatakotziro ipinkathariwentantaira Pawa, temaita riyotakotziro. Ikanta ripokapaake owaariperoshiretantatsiri ripakaakaapaakeri ikemisantawetana. Iri oshiyakawori pankirentsi jokakitapainchari awotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eenitatsi thaamentawori niñaane, ikemisantaweta intsipaite. Iri oshiyakawori pankirentsi jokakitapainchari omapipookitzira. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Te riyoperotero ñaantsi, te ikisashitawo rowasankewentaitanakeri ikemisantzi, ripakaanakero. Roshiyakawo pankirentzi sampishitanaintsiri te okyaaperotzi oparitha inthomoiki kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eenitatsi kemawetawori niñaane, iro kantzimaitacha iñaamawaitawo inthaamentawaitya, osheki eejatzi ikenkithashiretakotziro rowaagawo, irootake ipeyakotantakawori niñaane, te ikemisantzi. Roshiyakawo pankirentsi jokakitapainchari kitocheemashiki, kaari kithokitatsine. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tzimatsi itsipa kemirori niñaane, ikemisantanakero. Ikyaaryoowentanakero. Iri oshiyakawori pankirentsi shookapaintsiri okameethapathatzira kipatsi, shekichonchoitanake okithoki, otsipa shekipiyokineentaintsiri, otsipa eepiyokiini okithokitanake.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Roshiyakaawentakeniri eejatzi Jesús, ikantzi: “Jirokaga ikanta ipinkathariwentantai Inkitesatzi, oshiyatyaari apaani atziri pankitakaantzirori kameethakiri trigo. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Okanta tsireniriki rimagaiyinira ratziritepaini eejatzi irirori, pokake kisaneentziriri ramake okithoki trigo-niro, ipankitapaakeniri rowaneki, rowaitakero trigo-pero, piyanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Okanta ishookanake trigo-pero, kithokitanake. Eejatzi okantzitaka trigo-niro rowaitaitakerori. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ikanta iñaakero ratzirite, riyaatashitakeri ashitawori, ikantakeri: ‘Te opantawo okithoki trigo apankitakeri powaneki, ¿iitaka owaitantakari ishooki trigo-niro?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantanake ashitawori rowane: ‘Kisaneentanari pankitakerori.’ Ikantzi ratzirite: ‘¿Pikowima niyaate nonthokayetairo trigo-niro?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Rakanake, ikantzi: ‘Eero, aamaashitya pithokakotzirokari trigo-pero. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Atake okantawakaata owaityaawoota ishooke, irojatzi isampatantakyaari trigo-pero. Aripaite nonkantemi: Pithatzinkero trigo-niro, pitayero. Powiitero trigo-pero, powayetairo.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ikanta rapiitakero Jesús roshiyakaawentziniri, ikantziri: “Jirokaga ikanta eejatzi ipinkathariwentantai Inkitesatzi, roshiyakari pankitzirori oryaanikitatsiri okithoki pankirentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oryaani okantaweta okithoki, iro kantzimaitacha arika ishookanake, anairo otsipa pankirentsi, antawo otewayetanake ari imenkoshiyetari tsimeryaaniki itsimankatapishitakera.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jiroka otsipa roshiyakaawentakeri Jesús, ikantzi: “Jirokaga ikanta ipinkathariwentantai Inkitesatzi, roshiyakawo apaani tsinane naashewaitatsiri. Aake eepichokiini kachopathari, owaitantakawo maawoini oshe. Ari oñaakero onkachopathate.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ari ikantapiinta Jesús roshiyakaawentziro okaatzi riyotaantayetziri. Tekaatsi apaani kaari roshiyakaawente. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ari imonkaatari ikenkithatakotakeri pairani Kamantantaneri ikenkithatakotziro ikantakeri Pawa: Noshiyakaawentatyeeniri atziri maawoini nonkamanteriri. Nooñaawontainiri kaari riyotaitzi pairani owakera iwetsikantakari kipatsi irojatzi iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ikanta riyaatanai Jesús, rookanairi piyowentakariri, jatanake pankotsiki. Ari rosampitakeri riyotaanewo, ikantziri: “Piyotainawo okaatzi poshiyakaawentakeri. ¿Oitaka oshiyakaawentachari trigo-niro rowaitaitakerori ipankiitziro trigo-pero?” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ikantzi Jesús: “Jirika Itomi Atziri iriitake oshiyakariri ashitawori rowane ipankiitakerowa trigo-pero. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jiroka owaantsi iro oshiyakaawentzirori kipatsi risaikantaitari. Jiroka trigo-pero iri oshiyakaawentacha ikaatzi ipinkathariwentairi Pawa. Irooma trigo-niro oshiyakaawentziri ikaatzi rashiyetari Kaariperori. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jirika kisaneentantatsiri pankitakerori trigo-niro iri oshiyakaawentachari Kamaari. Oshiyawori rowiitaitziro okithoki trigo, oshiyakaawenta arika ithonkaiya paata kipatsi. Jirikapaini owiiyetairori okithoki iri oshiyakaawentachari maninkariite. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Piñaakero, ipiyoitakero trigo-niro, ritagaitakero. Iro oshiyakaawentachari arika ithonkaiya paata kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jirika Itomi Atziri rotyaantairi maninkariite, impiyotairi kaariperoshiretatsiri, tema te ikowi rowaitaiyaari ikaatzi kemisantayetakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ritaayeetairi kaariperoshireri, riraawaitaiya ratsikaikiwaitya inkemaatsiwaitaiya. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iriima kameethashiretaintsiri, shipakirya inkantaiya roshiyaiyaari ooryaatsiri. Risaikimotairi Ashitairi tsika ipinkathariwentantzi irirori. Powayempitatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rapiitanakero eejatzi Jesús, ikantzi: “Jiroka otsipa noshiyakaawentemiri. Tzimatsi osheki koriki rimanaitziri owaantsiki. Ikanta apaani atziri iñaakeri, te onkantya raanakeri, eejatzi rimananairi, tekaatsi inkamante, ikantashiretanake irirori: ‘Ontzimatye namanantero jiroka kipatsi, ompoñaantyaari nashityaari tzimatsiri janta.’ Ipimantakero okaatzi tzimimowetariri, ramanantakero kipatsi. Kimoshire ikantaka, tema ramanantakotake osheki koriki. Ari okantari eejatzi ipinkathariwentantai Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ikantzi eejatzi Jesús: “Jirokaga ikanta ipinkathariwentantai Inkitesatzi, roshiyari apaani atziri kowaintsiri ramanante poreryaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iñaake poreryaari, osheki ikowake rayeri. Irojatzi ripiyantanaari inampiki, ipimantapaakero okaatzi tzimimotziriri, ramanantakero poreryaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ikantake eejatzi Jesús: “Jirokaga ikanta ipinkathariwentantai Inkitesatzi, roshiyakari apaani tarajaatatsiri. Raake osheki kantawaitachari shima. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inoshikakotakeri othapyaaki, riyoyaakeri kameethatatsiri. Rookayetakeri ikaatzi kaari kameethatatsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ari onkantaiyaari paata arika ithonkaiya kipatsi. Ripokake maninkariite, rinashiyetaiyaari kameethashireri, ari inkanteri eejatzi kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Irojatzi ritaantayetyaariri kaariperoshireri, ari riraawaitaiyaari, ratsikaikiwaitaiya inkemaatsitaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ikantzi Jesús: “¿Pikemathatakero okaatzi nokantayetakeri?” Ikantaiyini riyotaanewo: “Nokemathatakero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ikantanake eejatzi Jesús: “Noshiyakaawenteri apaani ashitaanitachari, tzimatsiri rowaagawo pinatachari. Raapiintziro antyashipawo rowaagawo, eejatzi owakerari. Ari ikanta ipinkathariwentantai Inkitesatzi, roshiyakari yowairentziite riyotaantairo okaatzi riyotaantaitziri pairani, riyotaantairo eejatzi owakerari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikaatakero Jesús roshiyakaawentakero okaatzi ikenkithatakotakeri, ari rowaaganaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ikenanai inampiki. Riyotaantayetapai rapatotapiintaitaga. Riyokitziiwentawairi ikaatzi kemayetakeriri, ikantaiyini: “¿Iitakama matakaakeriri jirika riyotanetantari, ritasonkawentantake eejatzi? ");
INSERT INTO cpbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Kaarima itomi pimantzirori inchakotapaini? ¿Kaarima otomi María? ¿Kaarima irirentzipaini: Jacobo, José, Simón, eejatzi Judas? ");
INSERT INTO cpbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Kaarima atsipatari iritsiropaini jaka? ¿Tsika iitaka roshiyakaawaimatsitantari ipinkathariwentantzi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Osheki rithainkaitakeri, ikisaneentaitanakeri. Iro ikantantanakari Jesús: “Rashi rowiro te ipinkathaitziri Kamantantaneri inampiki irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tema osheki rithainkimawaitaitakeri Jesús inampiki, iro kaari ritasonkawentanta. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ikanta Herodes jitachari Tetrarca, ikemakotakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ikantziri rimperatanewo: “Jirika Jesús iriitake Juan omitsitsiyaatantaneri. Iri añagaatsi, piñeeri otzimi ishintsinka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tema iri Herodes aakaantakeriri ketziroini Juan, roosotakaantakeri, romonkyaakaantakeri. Iro kantakaantzirori Herodías iinantawetari irirentzi Felipe. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tema ikaminaawetatyaari Juan jirika Herodes, ikantawetari: “Te okameethatzi paapithatantziro.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ari ikowawetaka ritsitokakaanterime, iro kantzimaitacha osheki pinkathatakeriri Juan, riyotaiyini Kamantantaneri rini. Ithaawantanakari Herodes atziripaini, ikantashiretzi: “Arika nitsitokakaantakeri, ari inkisaneentaitakena.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Okanta imonkaataka kiteesheri roimoshirenkawentawo itzimantari Herodes. Ipiyotaiyakani osheki isheninka, roimoshirenkaiyani. Ari ipokapaake ishinto Herodías, omampaapaaka. Okameethatzimotanakeri Herodes. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ikantakero: “Oitarika pinkowakotenari, ari nompakemiro. Imaperotatya, riyotzi Pawa eero namatawitzimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Okantakero onaanate: “Pinkanteri rithatzinkakaanteri Juan.” Irojatzi okantantanakariri: “Nokowi pamakotakenawo iito Juan pasoshetaki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ari rowashiretanaka Herodes, te ikowaweta. Iro kantzimaitacha ikemaiyakerini isheninka ikantakerori ketziroini. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Irootake rithatzinkakaantantakariri Juan. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ramakoitakero iito, ipakoitakero aanakeniro onaanate. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Irojatzi ripokaiyantapaarini riyotaanewo Juan, ikitatairi. Jataiyanakeni risaikira Jesús, ikamantapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ikanta ikemake Jesús kamake Juan, otetanaka pitotsiki riyaatero tonkaariiteki. Iro kantzimaitacha ikemakoitakeri tsika riyaate, shiyaiyanakani ikenaiyanakeni awotsiki, royaataitanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iro raatakotapaakitziini Jesús, iñaapaatziiri osheki ipiyotaka atziri. Retakoshiretapaakari, retsiyatakotakaake osheki mantsiyayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Okanta otsireniityaanake, ikantzi riyotaanewo Jesús: “Pamine, asaikatzi tonkaariki, tsireniityaanake. Pinkaatero pikenkithatzi, riyaataita atziri nampitsiki rowapaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Rakanakeri, ikantziri: “¿Iitaka ratsipetantyaawori riyaayetai? Pimperi eeroka rowanawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ikantanake riyotaanewo: “Tekaatsi nomperiri naaka. Apatziro otzimi 5 pan eejatzi apite shima.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikantzi Jesús: “Pamakenari jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ikantakeri maawoini atziri: “Pisaikaiyeni.” Saikaiyanakeni atziripaini. Raakero pan, eejatzi shima, aminanake jenoki inkiteki, ramananaka, ikantzi: “Niwethareemi Ashitanarí, eerokatake pakenawori jiroka nowanawo.” Itzipetowakero, ipayetakeri riyotaanewo, rowawisaakeniri atziripaini piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Maawoini rowaiyakani, kemakitaiyakani. Ipiyotairo tzimagaantapaintsiri, roteyetairo kantziriki, okaatzi 12 yeekitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aamaaka ikaatzi 5000 shirampari owainchari. Eenitatsi tsinane eejatzi eentsipaini owainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ikantairi Jesús riyotaanewo: “Jame petaiyaawo intatsikero.” Ikantakeri eejatzi piyotainchari atziripaini: “Kantacha piyaataiyaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Irojatzi ikenantanakari irirori tonkaariki, ramanamanaatari Ashitariri. Okanta otsirenitanake, saikake apaniroini Jesús janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Weyaakotaiyaani riyotaanewo niyankyaaneki, antawo otamakaare inkaare, oipiyapiyatakotakeri tampyaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Okanta okiteeshetzimatake, pokai Jesús ranashaatantaawo inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te riyotawairi, thaawaiyanakeni riyotaanewo, ikaimaiyanakeni: “¡Kaakitake shiretsiwé!” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Riñaanatapairi irirori, ikantziri: “Naaka pokaatsi, tontashire pinkantya eero pithaawawaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ari ikantanake Pedro: “Eerokama Nowinkatharité, pimatakainawo nanashaatantyaawo naaka inkaare.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ikantzi Jesús: “Pipokanakeeta.” Anashitanaka Pedro inkaareki riyaatashitanakeri ikatziyakaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ari ikenkithashiretanaka Pedro antawo otamakaare inkaare, thaawanake, irootake ritsitsiyantanakari, ikaimanake: “Pinkatharí paawaina.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rakothatashitanakeri Jesús, raawairi. Irojatzi ikantantanakariri: “Eepichokiini pikemisantakena. ¿Oitaka pikisoshiretantari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ikanta rotetapaa pitotsiki, awisainkatanake tampyaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Antawoite ipinkathatanakeri riyotaanewo, ikantaiyanakerini: “Imaperotatya eerokatake Itomi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ikanta rareetaiyaani intatsikero nampitsiki Genesaret. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iro raatakotapaakitziini Jesús, riyotaitawakeri. Ikamantaitakeri maawoini nampitawori janta, ramayetapaakeri mantsiyayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ikantaitakeri Jesús: “Pishineteri mantsiyari riterotawakero piithaare, retsiyatakotantaiyaari.” Ari okantzimaitaka, ikaatzi terotzitakeriri iithaare, etsiyatakoyetai. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ikanta ripokaiyakeni Fariseo itsipatakari Yotzinkariite. Ipoñaakawo nampitsiki Jerusalén. Ikantapaakeri Jesús: ");
INSERT INTO cpbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Judá-ite anaiyini. Iro ametaiyarini akiwaakota tekera oyaata, ari okanta riyotaayetairi pairani acharineete. ¿Oitaka kaari rimatantawo piyotaanewo? Rowapiintaiyani te ikiwiro rako.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Rakanake Jesús, ikantzi: “Irojatzi poshiretawo eerokapaini riyotaayetairi pairani acharineete, te pimatzimaitawo riyotaayetairi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jiroka ikantzi Pawa: Pimpinkathateri ashitzimiri. Ikantake eejatzi: Ontzimatye romposaiteri kishimatziriri ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iro kantzimaitacha pikantashitapiintaiyani eeroka: ‘Kameethatatsi ankanteri apaapate: “Nokashaakaakeri Pawa maawoini noorikite, eero okanta noneshironkatemi eeroka.” ’ ");
INSERT INTO cpbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Piyotaantashitakawo rametaitari pairani, te piyotaantziro inintaperotziri Pawa. Iro kaari retakotantaari asheninkapaini ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Owapeyimotantaneri pinaiyini. Eeroka ikenkithatakotake pairani Isaías, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ipinkathawaantewaitashitakena atziripaini. Temaita ikenkithashiretakotana kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aminaashita rotziwerowawaita ipinkathawetana, Riyotaantashiwaitawo rameyetari irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ikaimakeri Jesús maawoini piyowentakariri, ikantziri: “Pinkemisantaiyeni, pinkemathatantyaawori nonkenkithatakoteri: ");
INSERT INTO cpbNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ikaatzi owari te rowaariperoshiretantzi, irooma okaatzi añaawaitziri, iroowa owaariperoshiretantatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Irojatzi ripokashitantapaakariri riyotaanewo okaakiini, ikantapaakeri: “Te inimoteri Fariseo-paini ikemakemi pikantake.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ikantanake Jesús: “Ashitanari Inkitesatzi, ari inthokairo okaatzi kaari ipankitzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Piñaaminthatashityaari, te riyotaiyini irirori, roshiyakari amashookiri. Roshiyakotakari rakathatawakaa mawityaakiri, te riyotzi jimpe inkene, apitekeroini impare omooki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ari ikantzi Pedro: “Pooñaawontenawo okaatzi poshiyakaawentakeniriri jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikantzi Jesús: “¿Tekerama otzimimotzimiita eeroka piyorenka? ");
INSERT INTO cpbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tema piyotzi okaatzi owapiintari okeni asheetoki, irojatzi omishitowantaiyaawori? ");
INSERT INTO cpbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Irooma añaawaitero kaariperori akenkithashireyetari, iroowa owaariperoshiretantatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tema ashireki akenkithashiretawo kaariperori, omposawakaantsi, mayempitaantsi, ñaathatakotaantsi, koshitaantsi, thaiyakotaantsi, kishimataantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irootake jiroka owaariperoshiretantatsiri. Irooma eerorika akiwaakota ankowerika oya, te owaariperoshiretantzi iroori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ikanta ikenanake Jesús nampitsiki jitachari Tiro irojatzi Sidón-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ari ipokashitakeri apaani tsinane Canaán-sato, kaari Judá-ite iroori. Okantapaakeri: “Nowinkatharité, eeroka icharine pinkathari David-ni. Nokowi pineshironkataina, osheki okemaatsitakawo nishinto raayiro peyari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ari imairetake Jesús, te rakiro. Ikantaiyirini riyotaanewo: “Potyaantairo iyaataita, osheki oomerenchaakai.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ikantanakero Jesús: “Apatziro rotyaantakena Ashitanari noneshironkayetairi nosheninkaite Israel-iite, oshiyakariri oweja ipeyawaitaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari otziwerowashitanakari Jesús jiroka tsinane, okantanakeri: “Pinkatharí, pineshironkataina naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ikantanakero irirori: “Paata tsinane. Tema ikantaitake pairani: ‘Te aapithatziri rowanawo eentsite amperi otsitzi royaawo.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akanakeri iroori, okantziri: “Imapero pikantakeri Pinkatharí. Iro kantzimaitacha, rowapiintamatsitawo otsitzi rowaryagaitziro owanawontsi otapinaki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Rakanairo Jesús, ikantziro: “Tsinané, imapero pikemisantai eeroka. Irootake nimatantyaawori pikowakotakenari.” Apathakero awisakotanai ishinto. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ikanta rowaaganaawo Jesús ikenanairo ocheraaki inkaare Galilea. Irojatzi ritonkaantanakari otzishiki, ari risaikapaake janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ari ripokashitakeri osheki atziri, ramayetake kantawaiyetachari imantsiyare: ethoriwaitatsiri, amashookiri, kisowaanteri, pesaponchokiri, maawoini. Rithonkiri retsiyatakotakaayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Riyokitziiwentaitanakeri Jesús iñagaitakeri riñaawaitakagairi kisowaanteri, ranashitakaayetaari kisopookiri, ethoriwaitatsiri eejatzi, raminakaayetairi mawityaakiri. Ikantaiyini atziripaini: “Imapero ikameethatake Pawa, iriitake pinkathariwentairiri isheninkapaini Israel.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ikanta Jesús ipiyotakeri riyotaanewo, ikantakeri: “Osheki netakotakari atziripaini, tema mawa kiteesheri risaikaiyakeni ikemisantana, tekaatsi rowaiya. Arika riyaatashitaiya eero rowanaa, ari aakeri ritashe awotsiki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ikantaiyini riyotaanewo: “Pamine, asaikatzi ochempiki. ¿Tsika ayeka owakayaariri? Osheki ikaataiyini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ari rosampitziri Jesús riyotaanewo: “¿Tsika okaatzika pan tzimatsiri?” Ikantzi riyotaanewo: “Tzimatsi okaatzi 7, tzimitacha eejatzi shiwaireki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ari ikantaitanakeri ikaatzi piyotainchari: “Pisaikaiyeni.” ");
INSERT INTO cpbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Raakero pan eejatzi shiwaireki, riwetharyaawentakawo. Irojatzi itzipetowantakawori pan, ipayetakeri riyotaanewo, rowawisaakeniri piyotainchari atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Owaiyakani maawoini, kemaneentaiyakani. Ipiyotairo tzimagaantapaintsiri, yeekitai okaatzi 7 kantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amaaka ikaatzi 4000 shirampari owainchari. Tzimitacha tsinanepaini eejatzi eentsipaini owainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Irojatzi ikantantanaari Jesús: “Ari owaiyakani, kantacha piyaayetai.” Ari rotetanaawo Jesús pitotsiki, montyaanaka iipatsiteki Magdala-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ikanta ripokaiyakeni Fariseo itsipatakari Sadoc-iite, ikowawetaiyatyaani rikompitakayaarime Jesús inantyaari riyakowenterime. Ikantawetapaakari: “Janjaatya pitasonkawentante niyotantyaari imaperotatyaarika opoñaawo pitasorenka inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Rakanake Jesús ikantzi: “Arika onkityonkaitye tsireniiteeni, pikantaiyini eeroka: ‘Osaryaamanaatye onkiteeshetamanai.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Irooma piñaamanairorika menkori onkityonkaitye inkiteki, pikantzi: ‘Omparyaatye inkani.’ Piñaakero, piyotakowetawo inkite, piyotakotziro ompare inkani. Iro kantzimaitacha te piyotzimaitawo piñaayewetari jaka kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Te pikameethashiretaiyini eeroka, thainka powakeri Pawa, iro pikowantaiyarini piñeena nitasonkawentante, eeromaita noñaayimiro. Apatziro piñeero awishimotakeriri pairani Jonás.” Ari ripiyanaawo Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ikanta rareetaiyakani riyotaanewo Jesús intatsikero, te raanake iwaane, imaisantanakero. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ikantzi Jesús: “Paamaiyaawo kachotakairori iwaane Fariseo eejatzi rashi Sadoc-iite.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ari rosampitawakaanaka riyotaanewo, ikantawakagaiyani: “¿Oitaka ikantantairori jiroka? ¿Irooma ikantantairi te amanake awaane?” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yotake Jesús ikantawakaari riyotaanewo, ikantziri: “Te pikemisantaiyini eeroka, iro pikenkithashirewaitantari, pikantaiyini: ‘Te amake awaane.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tema piyotaiyironi? Chapinki otzimaweta pan okaatzi 5, iro kantzimaitacha nowakaaka 5000 shirampari. Powiitairo tzimagaantapaintsiri. ¿Tsika okaatzika kantziri piyeekitairi? ");
INSERT INTO cpbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ari nokantzitakawo kaatatsiri 7 pan, nowakaakari 4000 shirampari. ¿Tsikama okaatzika kantziri piyeekitairi? ");
INSERT INTO cpbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Oitaka kaari piyotakotantawo eeroka? Te iro niñaawente rowaitari pan. Nokantatziimi: ‘Paamaiyaawo kachotakairori iwaane Fariseo eejatzi rashi Sadoc-iite.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ari riyotaiyanakeni riyotaanewo, te iro riñaawente Jesús kachotakairori pan, roshiyakaawentatziiro okaatzi riyotaantayetziri Fariseo eejatzi Sadoc-iite. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ikanta ikenanake Jesús janta Cesarea-ki, inampitsiteki Filipos. Ari rosampitakeri riyotaanewo, ikantziri: “¿Oitaka ikenkithashiretakoitariri Itomi Atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rakaiyanakeni, ikantzi: “Eenitatsi atziri kantatsiri, ‘Juan omitsitsiyaatantaneri piriintaachari.’ Ikantzi itsipa, ‘Iri koñaataatsiri Elías.’ Ikantzi itsipa ‘Iri Jeremías-ni.’ Tzimatsi kantayetatsiri eejatzi, itsipa Kamantantaneri rini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ikantziri riyotaanewo: “Eeroka. ¿Tsika pikantaiyinika?” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rakanake Simón Pedro, ikantzi: “Eerokatake Cristo, Itomi Pawa Kañaaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantzi Jesús: “Imaperotatya okaatzi pikantakeri Simón itomi Jonás, kaari atziri yotakaakemirone jiroka, iri Ashitanari Inkitesatzi yotakaakemirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Noitaimi Pedro, mapi oshiyakaawentacha piwairo. Tema mapi poshiya, ari niwetsikairo nopanko. Inkaate kemisantaatsine paata, iri oshiyaawone pankotsi. Eero rimatziro sarinkaweniweri impeyakaashitaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iri poshiyaiyaari aminirori ashitakowo pankotsi, kantacha rashitareero, kantzitacha eejatzi rashitero, rintsiriitero shintsiini. Iro pankotsi oshiyakaawentacha tsika ipinkathariwentantai Inkitesatzi. Ikaatzi pishinetairi eeroka jaka, iri rishinetaitzi inkiteki. Iriima kaari pishinetai jaka, iri kaari rishineetzi inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ikantanakeri Jesús maawoini riyotaanewo: “Paataga pikamantantzi, pinkante: ‘Iri Cristo jirika Jesús.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ikanta Jesús ikamantakeri riyotaanewo, ikantziri: “Irootaintsi aate nampitsiki Jerusalén, antawoite inkemaatsitakaina Itzinkamipaini, reewaperore Imperatasorentsitaarewo, reeware Yotzinkariite, ari ritsitokaantaitena. Iro awisawetakya mawa kiteesheri nañagai eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ikanta Pedro, raanakeri Jesús jantyaatsikaini, ikantakeri: “Pinkatharí, te inimotena naaka pikantziri, te nokowi awishimotemi jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ari ripithokanaka Jesús, rakanake: “Piyaate Satanás. Te poshiretawo eeroka ikowakaanari Pawa, apatziro poshiretawo ikowapiintakeri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ikantanakeri Jesús maawoini riyotaanewo: “Tzimatsirika kowatsiri intsipatena, ripakairo ikowashiyetari rantero, onkantawetya inkentakoiterime, intsipatena. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tema ikaatzi etakowaitashitachari apaniroini rantayetziro iñaamatashiyetari, ari impeyashitaiya. Iriima kamawentenane rantayetanairo nokowakayiriri, ari rawisakoshiretai. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aminaashiwaita otzimimotziri maawoini rowaagawopaini tzimatsiri jaka kipatsiki, ari ompeyakaashitaiyaari rañaamento. ¿Kantachama ripinakowentaitya eero iñaantaitawo impeyashitaitya? ");
INSERT INTO cpbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ari ripiyai paata jirika Itomi Atziri ramairo rowaneenkawo Ashitariri, intsipataiyaari maninkariite, iri pinatantapairone okaatzi rantaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Imaperotatya, eenitatsi pikaatzira jaka, tekera pikamiita ari piñaakeri Itomi Atziri jimpe ikanta ipinkathariwentantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Okanta awisake 6 kiteesheri, eejatzi raanairi Jesús: Pedro, Jacobo, eejatzi Juan, irirentzi Jacobo. Ritonkaiyanakeni otzishiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ari ipashinitzimotakeri riyotaanewo, rishipakiryaanake ipooki, roshiyanakari ooryaatsiri, matanaka iithaare kitamaaki okantanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iñaatziiri Moisés-ni, eejatzi Elías ikenkithawaitakairi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ikanta Pedro, ikaimakotanakeri Jesús, ikantzi: “Pinkatharí, imapero okameethatzi pamakenaga jaka. Kameetha niwetsikemi mawa pankoshetantsi: apaani pashitya eeroka, apaani rashitya Moisés, rashitya apaani Elías.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ikenkithawaiminthaitzi, ipamankapaakeri menkori, shipakirya okantapaaka. Ikematzi ñaawaitanaintsiri menkoriki, ikantaitzi: “Notomi rinatzi jirika netakokitakari, osheki nokimoshirewentakeri. Pinkemisantairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ikanta ikemaitakero jiroka ñaantsi, oiyotaiyanakani isaawiki, antawoite ithaawaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iri kantzimaitacha Jesús ripokashitapairi riyotaanewo, riterotapaakeri, ikantziri: “Pinkatziye, eero pithaawaiyini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Raminawetaiyanaani, tekaatsi iñaanai, apatziro ikatziyaka Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ikanta roirinkaiyaani otzishiki, ikowakotakeri eero ikamantantziro iñaakeri irojatzi paata arika rañagai. Tema jirika Itomi Atziri ari rañagai inkamawetakyaarika. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Rosampitanakeri riyotaanewo, ikantziri: “¿Oitaka ikantakotziri Yotzinkariite ikantaiyini: ‘Arika ripokimatake Cristo, iri jewataatsine Elías ripoke?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rakanake Jesús, ikantzi: “Imaperotatya ikantziri, iri jewatapaintsine Elías ripokake, rowameethashiretantapaake. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pinkeme nonkante naaka: Areewetaka Elías, iro kantzimaitacha te riyotawakeri atziri, osheki rowasankewaitakeri. Ari inkantaiteri eejatzi Itomi Atziri, osheki rowasankeeteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ari riyotaiyanakeni riyotaanewo iri ikenkithatakotzi Juan omitsitsiyaatantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ikanta rareetaiyaani ipiyotaiyanira atziri. Ari ripokashitakeri Jesús apaani atziri. Rotziwerowashitapaakari, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Pinkatharí, pineshironkatainari notomi osheki ikamanawaitake, antawoite ikemaatsiwaitaka, osheki ritaawaitapiintaka, ripiinkawaitzi ñaaki. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namawetakanari piyotaanewo, rowawisaakotainari. Iro kantzimaitacha te rimatziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ari rakanake Jesús, ikantanake: “Te pikemisantaiyini eeroka, pikenashiwaitaka. ¿Tsikapaitema piyotaiyeni? Pamakenari eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ikisathatanakeri peyari, jatanake. Ari retsiyatakotairi ewankari. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikanta riyotaanewo Jesús, rosampitairi apaniroini, ikantairi: “¿Iitaka kaari nimatantari naaka netsiyatakotakairi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikantzi Jesús: “Iro kaari pimatantari te pikemisantaperotzi. Pinkeme nonkante: Onkantawetya pinkemisantaironkate, kantacha pinkantero otzishi: ‘Pishirinke.’ Ari ishirinkake. Tema tekaatsi kompitzimotemine arika pinkemisantaperote. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iro kantacha pinkowerika petsiyatakotakagairi oshiyakariri jirika ewankari, ontzimatye pamanaperotyaari Pawa, pitziwentyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ikanta risaikaiyini Jesús nampitsiki Galilea, ari ikantakeri riyotaanewo: “Irootaintsi ripithokashitaityaari Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ari ritsitokaiteri. Iro awisawetakya mawa kiteesheri, ari rañagai eejatzi.” Antawoite rowashiretaiyanakani riyotaanewo ikemakerira ikantake. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ikanta rareetaiyaani Jesús nampitsiki Capernaum, ari ripokakeri apatotakaantziriri koriki ashi tasorentsipanko, rosampitapaakeri Pedro: “¿Ripinatapiintziro yotaimiri tasorentsipanko?” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ikantanake Pedro: “Ripinatapiintziro.” Ikanta ripiyapaawo pankotsiki, iri thaawakotawaincha Jesús rosampitawairi: “¿Iitaka pikenkithashiretari eeroka Simón? ¿Iitaka inintakaantapiintziri itsipasatzi pinkatharipaini? ¿Iriima inintakaayetzi isheninkaperotari? ¿Iriima inintakaayetzi areetzinkari kaari isheninkaita?” ");
INSERT INTO cpbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ari rakanake Pedro, ikantzi: “Iri inintakaitziri areetzinkaripaini.” Ikantzi Jesús: “Ari okanta. Tema te okowa ripinayetairo ikaatzi isheninkayetari. ");
INSERT INTO cpbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iro kantzimaitacha te nokowi inkisaneentawaitya apatoyetziriri koriki. Piyaate pakachaate inkaareki. Arika pinoshikake apaani, paminawaanteteri, ari piñeeri koriki. Paanakeniri apatotziriri, pimperi. Iri pipinawentyaari eeroka eejatzi naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ikanta ipiyotaiyakani riyotaanewo Jesús, rosampitakeri, ikantziri: “Arika impinkathariwentantai Inkitesatzi. ¿Tsika itzimika iriiperotatsine intsipatyaari impinkatharite?” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ikanta Jesús ikaimake apaani eentsi, ikatziyakeri niyankineki risaikaiyakenira irirori, ");
INSERT INTO cpbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ikantzi: “Eerorika pawentanaari Pawa, eerorika poshiyakotanaari jirika eentsi, eerowa piñagairo ipinkathariwentantai Inkitesatzi. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tema jirika eentsi te riyotziro ishamewaite. Maawoini inkaate oshiyakotaiyaarine eentsi, iriitake iriiperotaatsine ipinkathariwentantaira Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ikaatzi aakotanari nowairo ikemisantaana, raakameethatanairi oshiyakariri jirika eentsi, naakatake raakameethatake.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tzimatsirika antakaakerine kaariperori oshiyakotariri jirika eentsi rawentaana, onkamintha inthataitenirime mapi ikentsiki, rowiinkaiteri inthomoyaaki inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Imapero onkoweenkate jaka kipatsiki. Iñagaite osheki antayeterone kaariperori. Iro kantacha ari rowasankeyetaitakeri antakaantakerone. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Iroorika pako, iroorika piitzi pantantari kaariperori, pipakagairo, poshiyakagairo pithatzinkatyeerome, ompoñaantaiyaari. Tema te okameethatzi otzimawetaga apite pako, apite piitzi, iro ompoñaantaiyaari paata piñagairo pashi powaatyeero pitagaiya. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iroorika poki pantantari kaariperori, pipakagairo, poshiyakagairo pisoryaakitatyeeme, ompoñaantyaari pawisakopityaakitai. Tema te okameethatzi otzimawetaga apite poki, iro ompoñaantaiyaari paata rookaitaimi opaampatzira sarinkaweni.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paamaawentya pimanintawaitzirika oshiyakotanaariri jirika eentsi. Tema ikempoyaawentakeri maninkariite nampiyetawori Ashitanariki Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tema iro ripokantakari Itomi Atziri rowawisaakoshireyetairi ikaatzi peyawetainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pinkeme noshiyakaawentemiro. Tzimatsi atziri piratariri ikaatzi 100 oweja. Ikanta ipeyagaantaka apaani, ikaatanai 99 oweja. Rookanakeri itsipa, jatake otenkanaamashiki otzishi rithotyaakotairi peyainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ikanta iñagairi antawo ikimoshiretanai ragairira peyawetainchari. Antawoite ikimoshiretanai, anaanakero ikimoshirewentziri kaari peyachari kaatatsiri 99. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ari ikantari eejatzi Ashitairi Inkitesatzi, te ikowi impeyagaantawaitya apaani ikaatzi oshiyanaariri jirika eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Arika piñeeri pisheninka rantakero kaariperori, piyaatashiteri, pinkenkithawaitakairi apaniroini, poñaayeri okaatzi ikenakaashitakari. Arika inkemisantanakemi, pimatakeri poshiyakagairi iriirikame pirentzipero. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Eerorika ikemisantzimi, paanake itsipa kemisantzinkari, eerorika apite kemisantzinkari, iri pintsipatanakyaari pinkaminairi. Irootake pimonkaatantyaawori Inintakaantaitziri pairani, ikantaitzi: Inkaaterika apaani ñaakotakemirone pantakero kaariperori, tera okameethatzi rowasanketaitemi. Irooma inkaaterika apite, eerorika inkaate mawa ñaakotakemirone pantakero kaariperori, iroowa ompoñaantyaari rowasanketaitemi. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eerorika ikemisantzi jirika, pinthawetakoteri rapatotapiintaitaga. Eerorika ikemisantashita, eerowa pishinetairi intsipataimi papatotapiintaga, poshiyakagairi kaari pisheninkata, tema roshiyakotakari apatotziriri koriki. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tema ikaatzi pishineyetairi eeroka jaka, irijatzi rishinetaitzi inkiteki. Iriima ikaatzi kaari pishineyetai eeroka jaka, irijatzi kaari rishinetaitzi inkiteki. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pinkeme nonkante eejatzi: Arika pinkaate apite, arika oshiyawakaiya pikenkithashiretanewo, iroowa ompoñaantyaari pithotyaakotairi Ashitairi Inkitesatzi, ari rimatakemiro. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsikarika ipiyota apite, terika mawa atziri, raakotana nowairo ikemisantaana, ari nisaikitari naaka notsipatari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ari ripokapaake Pedro, rosampitapaakeri Jesús, ikantziri: “Pinkatharí, arika ontzime rantzimotenari nosheninka, ¿onkaateka rapiitero nompeyakoteri? ¿onkaatema 7?” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Rakanakeri Jesús, ikantanakeri: “Te okameethatzi pipiyatantya. Te apatziro pimpeyakoteri onkaate 7, osheki onkaate papiipiinteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Jiroka ikanta ipinkathariwentantai Inkitesatzi, roshiyakotari rantziri pinkathari ikowakotziri rimperatanewo ripinatairi rireewetzirira. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ikanta ikowakoyetziri ireewetziriri, ari ripokapaake apaani ireewetatsiri osheki koriki. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tekaatsi raye ripinakowentaiyaari. Ikantzi pinkathari: ‘Paanakeri jirika atziri, iina, itomipaini, eejatzi okaatzi tzimimotziriri, pimpimanteri. Naantaiyaariri koriki rireewetanari.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ikanta ikemawake rimperatanewo, rotziwerowashitanakari pinkathari, ikantanakeri: ‘Eero pipimantana, poyaawentawakya eepichokiini, aritake nipinataimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ikanta jirika pinkathari ineshironkatanakeri rimperatanewo, ikantzi: ‘Ariwé, te pireewetaana.’ Ipeyakotairi okaatzi rireewetziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ikanta riyaatai rimperatanewo, ritonkyotaka irirori ireewetziriri eepichokiini. Rotaiyakentsitawakeri, ikantziri: ‘Pipinatena iroñaaka pireewetanari.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari rotziwerowashiwetanakari, ikantziri: ‘Poyaawentawakya eepichokiini aritake nipinataimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Te ikowi royaawentya, raanakeri, romonkyaakaantakeri, ikantziri: ‘Arika pipinataina pireewetanaga, ari nomishitowakaantaimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iñaakeri ikaataiyini te inimotanakeri, jatake ikamantakeri pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ikanta pinkathari ikaimakaantakeri, ikantziri: ‘Kaariperoshireri pini eeroka. Nopeyakotaimi eeroka pireewetanari pikantakenaga poyaawentawakya. ");
INSERT INTO cpbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ari pinkantanteme eeroka, pineshironkatanteme.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Antawo ikisanaka pinkathari, romonkyaakaantakeri, ikantziri: ‘Arika pipinataina eeroka, ari nomishitowakaantaimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Arira inkantaiya paata Ashitanari Inkitesatzi, eerorika pineshironkayetairi pisheninka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ikanta rithonkanakero Jesús riyotaantzi Galilea-ki, jatake intatsikero Jordán-ki irojatzi rareetantakari Judea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ipiyowentaitawaari. Retsiyatakotakaapai osheki mantsiyari. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ari ripokashitakeri Fariseo-paini, ikowi rikompitakayaarime Jesús, rosampitapaakeri ikantziri: “¿Shinetaantsitatsima inkowe atziri rookashiwaityaawo iina?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Rakanakeri irirori, ikantanakeri: “¿Tema piñaanatakotziri owakera riwetsikantaitakariri atziri. Tema riwetsikaitake shirampari eejatzi tsinane? ");
INSERT INTO cpbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ikantaitake pairani: Rontsiparyaari ipaapate mainari raakerika iina, Apaani ikantanaawo iwathaki raawakaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iro eero okantanta rookawakaiya atziri itsipatakaakariri Pawa, tema apaani ikantanaawo, eero okanta rookawakagaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rapiitanakeri Fariseo rosampitziri, ikantziri: “¿Iitaka rosankenatantari pairani Moisés, ikantake: Arika rookawakagaitya, ontzimatye impaiteri osankenarentsi rookawakaantyaari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantzi Jesús: “Okantakaantziro pipiyathataga, iro rishinetantakemirori Moisés. Iro kantzimaitacha te ari onkantya pairani owakera etantanakari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pinkeme nonkante naaka: Ikaatzi jokashiwaitawori iina ragairika otsipa, mayempitakera. Irooma omayempitakerika tsinane, kantacha rookaitero. Tzimatsirika agairone tsinane jokaarewo, mayempitake irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ikantaiyanakeni riyotaanewo: “Arika okanta, eerotya ragaitzi iinantaitari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ari rakanakeri Jesús, ikantziri: “Iriirika Pawa kowakayemirone, aritake pinkemathatakero. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tzimatsi kantakaantzirori eero raanta iina atziri. Tema tzimatsi atziri amashithakitachari ishiramparitantari owakera itzimapaake, eero okanta raye iina. Eenitatsi itsipa inowikyaanikiitziri eero okanta raye iina. Tzimatsi eejatzi kowatsiri risaikashiwaitya, tema ikantakotatziiri pinkathariwentantatsiri inkiteki. Kowatsiri rimatero nokantakeri, rimatero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ikanta ramaitapaakeniri Jesús eentsipaini, ikantaitapaakeri: “Nokowi pamanakotenari neentsite, potzimikapatziitoteri pitasonkawenteri.” Ikantzi riyotaanewo Jesús: “Eero poñaashirenkiri Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ikantanake Jesús: “Eero pikoshekari, nokowi ramaitenari eentsipaini. Tema ikaatzi oshiyakotanaariri jirikapaini eentsi, iri ñagairone jimpe ipinkathariwentantai Inkitesatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ikanta Jesús rotzimikapatziitoyetakeri eentsipaini, jatanai irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ikanta apaani mainari ripokashitakeri Jesús, rosampitapaakeri, ikantziri: “Kameethari yotaantanerí. ¿Oitaka nantairi noñaantaiyaawori kantaitaachane añaamentotsi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Rakanakeri Jesús, ikantziri: “¿Oitaka pikantantanari ‘kameethari’? Tekaatsi apaani kameethatatsine, apatziro ikantakaawo Pawa ikameethatzi. Pinkowerika piñagairo añaamentotsi, pantairo Inintakaantaitanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ikantzi irirori: “¿Otzimika?” Ikantzi Jesús: Eero pitsitokantzi. Eero pimayempitzi. Eero pikoshitzi. Eero pithaiyakotanta. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pimpinkathateri ashitzimiri. Petakotaiyaari pisheninka poshiyakagairo petakota eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rakanake mainari: “Nimatakero maawoini jirokapaini, irojatzi netanakawo pairani eeniro neentsitzi. ¿Oitaka kowachari iroñaaka?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ikantanakeri Jesús: “Pikowirika pinkameethashirete, piyaate pipankoki, pimpimantero maawoini tzimimotzimiri, pimpayeteri ashironkainkari, tema inkiteki piñagairo pinintagaiya. Arika pimatakero, pipoke poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikanta ikemawake mainari, owashire ikanta ripiyanaka, tema ashaagantzinkari rini. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ikantanakeri Jesús riyotaanewo: “Antawoite ompomeentsitzimotyaari ashaagantzinkari impinkathariwentairi Inkitesatzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eekero ikantatzi: “Tema te okanta inkye piratsi camello imooki akoshi. Iriira maperotacha ikompitzimotyaari inkye ashaagantachari tsika ipinkathariwentantai Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ikanta ikemaiyakeni riyotaanewo, riyokitziitaiyanakeni, ikantawakaiyani: “¿Iitakama awisakoshiretaatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ari raminanakeri Jesús, ikantziri: “Eero rimatziro apaniroini atziri, iriima Pawa tekaatsi kompitzimotyaarine.” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rakanake Pedro, ikantanake: “Jirikapaini nokaataiyakeni nokowi noyaatemi, nookanawentanakawo maawoini tzimimotanari. ¿Oitaka ripinaitainari paata?” ");
INSERT INTO cpbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Rakanake Jesús, ikantzi: “Arika owakeratai paata kipatsi, ari impinkathariwentantairi Itomi Atziri, roshiyakotyaari ikanta apaani pinkathari risaikantawo owaneenkatachari risaikamento. Ari pinkantaiyaari eejatzi eerokapaini pimpinkathariwentairi maawoini charineyetyaarine Israel-ni, ikaatzi 12 rinashiyeta. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tema ikaatzi oyaatakenari, rookanawentanakawo ipanko, irirentzi, iritsiro, ipaapate, iina, reentsite, iipatsite. Aritake iñaayetairo ontzimimotairi osheki, tema iriitake aakoyetaanari nowairo rawentagaana. Irijatzi ñaayetairone kantaitaachane añaamentotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tema tzimayetatsi etawori iroñaaka, iri ñagairone rimpoiyetai. Tzimayetatsi impoiyetatsiri iroñaaka, iri ñagairone retaiyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Jiroka ikanta ipinkathariwentantai Inkitesatzi, roshiyakowaitakari ikanta apaani atziri tzimatsiri ichochokimashite. Riyaatake okiteeshetamanai ramine antawaitatsine iwankiremashiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ikanta iñaake kowatsiri rantawaite, ikantakeri: ‘Arika petanakyaawo pantawaite iroñaaka irojatzi ishaawiiteeni, nipinatemi apapentyaki koriki.’ Ikantaiyini antawairentzi: ‘Kameethatake.’ Rotyaantaitakeri pankirentsimashiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ikanta reenokiityaapaake ooryaa eejatzi ripiyanaawo ashitawori iwankiremashi nampitsiki. Iñaapai itsipa ikatziyaiyani tekaatsi rantawaire. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ikantapaakeri: ‘Arika piyaate pantawaite nowankiremashiki, ari nipinaperotakemi.’ Riyaataiyakeni rantawaite. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ari ikantakero itampatzikatapaake ooryaa, eejatzi ritainkanakera ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ari ikantakero eejatzi otsireniityaanake, iñaapai atziri risaikaiyini, tekaatsi rantawaire, rosampitapaakeri: ‘¿Tekaatsima pantawaire pisaikashiwaitantari kiteesheriki?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Rakaiyanakeni, ikantzi: ‘Tekaatsi antawaitakainane.’ Ikantzi irirori: ‘Piyaate eejatzi eeroka pantawaite nowankiremashiki, ari nipinaperotakemi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Okanta otsirenitanake, ashitawori iwankiremashi, ikantakeri oisaikiniriri iyorikite: ‘Pinkaimeri maawoini antawairentzi pipinateri. Iri petawakya pipinateri impoitaintsiri rantawaitake irojatzi pimatantakyaariri ananinkaintsiri rantawaitake.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ikanta ripokake impoitaintsiri rantawaitzi, eepichoki rantawaitake, iro kantacha ripinaitakeri apapentyaki koriki. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Irojatzi ripokaiyantakani ananinkaintsiri rantawaitake, roshiyakaatzi iri ripinaperoiteri. Te, apapentyaki koriki ripinaitakeri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ikanta raawetawakari ripinaitakeriri, ikisanakeri ashitawori rantawaire, ");
INSERT INTO cpbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ikantanakeri: ‘Jirikapaini impoitapaintsiri rantawaitzi, te rantawaiperotzi, iro kantacha rimonkaatakena pipinatakenari, naaka atsipetaperotakariri ooryaa.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ikantzi ashitawori iwankiremashi: ‘Asheninká, nipinatakemi kameethaini, ¿tema nokantzitakemi amaityaake nipinatemi apapentyaki koriki? ");
INSERT INTO cpbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jirika piyorikite nipinatzimiri, piyaatai pipankoki. Naaka kowashitaincha nipinatziri apapentyaki koriki impoitapaintsiri rantawaitzi, ");
INSERT INTO cpbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Eeroma okanta nipinatante nonintziri naaka? ¿Pisamaneentakotashitanawo noneshironkatantzi?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tema eenitatsi etawori iroñaaka, iri ñagairone rimpoiyetai. Tzimatsi impoiyetatsi iroñaaka, iri ñagairone retaiyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ikanta ritonkaanake Jesús riyaatero Jerusalén-ki, raanakeri 12 riyotaanewo ikenakaanairi awotsiki, ari ikantakeri: ");
INSERT INTO cpbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aatatziira Jerusalén-ki. Ari raakaantaiteri Itomi Atziri, rayeri reeware Imperatasorentsitaarewo, intsipatakyaari Yotzinkariite, iri yakowenterine ritsitokaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iro raantanakyaariri atziri kaari asheninkata. Ari ripasawaitaiteri. Irojatzi inkentakotaitantakyaari. Iro awisawetakya mawa kiteesheri, ari rañagai eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Okanta iina Zebedeo ipokashitakeri Jesús, otsipatakari otomipaini: Jacobo eejatzi Juan. Otziwerowashitapaakari, okantapaakeri: “Nokowi pineshironkatena.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Rosampitanakero Jesús, ikantziro: “¿Oitaka pikowakotanari?” Okantanake iroori: “Tema irootaintsi pimpinkatharentsite, nokowi intsipatemi notomi impinkathariwentante, risaikimotemi apaani pakoperoki, itsipa risaike pampateki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Rakanakero Jesús ikantanakero: “Te piyotziro oita pikowakotanari. Osheki nonkemaatsityaari naaka. ¿Arima pinkisashitakyaawo eeroka pinkemaatsitya osheki? ¿Arima poshiyakena nonkame naaka?” Ikantaiyanakeni: “Aritake nimatakero.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Irojatzi ikantantanakari Jesús: “Imapero, irootaintsi awishimotemi onkaate nonkemaatsityaari naaka. Irooma pintsipatenarika ampinkathariwentante pisaike nakoperoki, itsipa nampateki, tera naaka nintakayaawone iita nontsipatyaari, apatziro riyotzi Ashitanari jimpe iita ikashaakaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ikanta ikemaiyakeni itsipa riyotaanewo, ikisaitanakeri Juan eejatzi Jacobo. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Irojatzi ipiyotantakari Jesús maawoini riyotaanewo, ikantziri: “Piyotaiyini eeroka jimpe ikanta ipinkatharitzi kaari asheninkata, osheki rimperatanta. Ari roshiyari eejatzi iriiperoyetatsiri ipinkathaitziri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Irooma eerokapaini, arika pinkowe piriiperote, iri poshiyakotya ikanta onampitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iroorika pinkowe peewatakaante, iriira poshiyakotyaari ikanta noshikaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te iro ripokantyaari Itomi Atziri rimperatantya iro ripokantari roshiyakotyaari onampitaarewo, inkamawentante, iriira pinakowentairine maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ikanta rawisaiyanakeni Jericó-ki, osheki atziri oyaatanakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari risaikake awotsinampiki apite mawityaakiri. Kemake irirori, ikantaitzi: “Ari inkenapaake Jesús jaka awotsiki.” Irootake ikaimantanakari, ikantzi: “¡Pinkatharí, icharinetari David-ni, pineshironkataina naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Osheki ikisathawetaitanakari. Te imairetzi, eekero ikaimanakitzi shintsiini: “¡Pinkathari, icharinetari David-ni, pineshironkataina naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Katziyapaaka Jesús, ikaimakeri, ikantziri: “¿Iita pikowiri nantzimotemiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikantaiyini irirori: “Pinkatharí, nokowi naaka naminawaitai kameethaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Antawoite ineshironkashiretanakeri Jesús jirika mawityaakitatsiri, riterotzitakeri roki. Aminanai kameetha, royaatanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jekaatzimatapaake rareetantyaari Jerusalén-ki. Riweyaiyakani Betfagé-ki nampitsi imontetari otzishi Olivo. Ari rotyaantake Jesús apite riyotaanewo, ");
INSERT INTO cpbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantakeri: “Piyaate nampitsiki amontetakari, ari piñaapaake inthatakotya burro ontsipatakyaari iryaani. Pinthataryaakotero, pamakenawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tzimatsirika osampitawakemine, pinkanteri eeroka: ‘Ikowatziiro pinkathari. Aritake roipiyaimiri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ari imonkaatari rosankenatakeri pairani Kamantantaneri, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pinkamantayetairi maawoini Jerusalén-satzi: Kaakitataike Piwinkatharite ripokashitakemi Tsinampashire ikantaka, ikyaakaakawo apaani burro Ewonkeri ini burro, owaiyanewo piratsi ikyaakaitziri tenari. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ikanta rotyaantakeri apite riyotaanewo, rimatakero okaatzi ikantawakeriri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ramakero burro otsipatakari iryaani. Rowanketaitakeniri manthakintsi imitzikaaki inkene inkyaakagaityaari. Ikanta Jesús ikyaakaanakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ikanta atziripaini piyotainchari janta, romaankashitanakeri imanthaki awotsiki tsika inkenanake. Eenitatsi itsipa chekayetaintsiri inchashi romaankashiteriri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ikaatzi atziri jewayetaintsiri, ikaatzi oyaatakeriri itaapiiki, ikaimaiyini, ikantzi: ¡Thame ampinkathatairi icharinetari David-ni! ¡Tasonkawentaarewo rini, tema Pinkathari aitziri otyaantakeriri! ¡Kaakitataike Awinkatharitepero! ");
INSERT INTO cpbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Irojatzi rareetantapaakari Jesús nampitsiki Jerusalén. Ari rosampitawakaanaka nampitawori, ikantaiyini: “¿Iitaka jirika?” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eenitatsi atziri kantanaintsiri: “Iriitake Jesús kamantantaneri, iriira poñaachari Nazaret-ki saikatsiri Galilea-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ikanta Jesús, kyaapaake isaikira tasorentsipanko. Rookapaakeri pimantayetatsiri eejatzi ikaatzi yompariyetachari. Rotatsinkayetapaakero rowantaitariri koriki, eejatzi ikantakero jimpe rowaitziri shiro. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikantapaake: “Okantzi osankenarentsi, riñaawaitziri Pawa, ikantzi: Nopanko ini jiroka, ari ramanapiintaitenari. Iro kantacha eeroka pamatawitantake jaka pipimantayetzi, poshiyakaakero koshintzipanko.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ikanta Jesús, ripokashitapaakeri tasorentsipankoki osheki mawityaakiri, kisopookiri, retsiyatakotakagairi maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tema osheki okameethatake rantakeri Jesús. Ikanta iñaakeri ewankaripaini rantakeri, ikaimaiyanakeni, ikantzi: ¡Thame ampinkathatairi icharinetari David-ni! Iri kantzimaitacha reewarepaini Imperatasorentsitaarewo, itsipatakari Yotzinkariite, kisaiyanakani, tema te inimotziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ari rosampiitanakeri Jesús, ikantaitziri: “¿Pikemakeri ikantaiyirini ewankaripaini?” Ari rakanake Jesús, ikantzi: “Nokemakeri. ¿Tema piñaanatero eeroka osankenarentsi kantatsiri pairani? Iri ewankaripaini eejatzi eentsipaini thoyetzirori iteni, Pikantakaakari impinkathayetaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ikanta Jesús, piyanaka ikenanairo Betania-ki. Ari rimaapai. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Okanta okiteeshetamanai eejatzi ripiyaawo Jesús nampitsiki. Ari ritasheyapaake niyankineki awotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iñaapaake awotsinampiki okatziya pankirentsi, riyaatashitanakero, iñaapaakitziiro te otzimi okithoki, iyoshiita oshi. Ikantanakero: “Pashi powaatyeero eero pikithokitai.” Okanta pankirentsi, kamashitanake. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ikanta iñaakero riyotaanewopaini, riyokitziiwentanakero, rosampitaiyakerini: “¿Iitaka okamashitantanakari pankirentsi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ari rakanake Jesús, ikantziri: “Imapero nonkantemi, imaperotatyaarika pawentaana, eerorika pikisoshirewaitzi, ari pimatakero eeroka, anaanakero jimpe okanta piñaakero pankirentsi. Kantacha pinkante: ‘Ishirinke otzishi, ipiinke inkaareki.’ Kantacha imatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Onkaate pinkowakotairiri Pawa, arika pawentaaperotanaiyaari, aritake impakemiro.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikanta ripiyaawo Jesús tasorentsipankoki, riyotaantapai eejatzi. Ari ripokashitapaakeri reeware Imperatasorentsitaarewo, itsipatakari Itzinkamipaini, rosampitapaakeri: “¿Jimpe itzimajaantzika pinkathari otyaantzimiri pantantawori jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ari rakanakeri Jesús, ikantanakeri: “Eejatzi naaka eenitatsi nosampitemiri. Arika pakakenawo, ari nonkamantakemi iita otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Romitsitsiyaatantake Juan-ni, ¿Iitaka otyaantakeriri? ¿Pawama? ¿Atzirima?” Ikantawakagaiyanakani: “Arika ankantakeri Pawa otyaantakeri, ari inkantanakai: ‘¿Oitaka kaari pikemisantantari?’ ");
INSERT INTO cpbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Arika ankante: ‘Atziri otyaantakeri’, ari inkisanakai atziripaini.” Tema ikantaiyini atziri Kamantantaneri rini Juan-ní. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ikantaiyini: “Te niyotero.” Ari ikantanake eejatzi Jesús: “Ari nokantzita naaka, eero nokamantzimiro iita otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Rosampitantake Jesús, ikantzi: “¿Tsika okantzimotzimika eerokapaini jiroka? Eenitatsi apaani atziri tzimatsiri apite itomi. Okanta apaani kiteesheri ikantakeri itomi: ‘Notomi, piyaate pantawaite pankirentsimashiki.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Rakanakeri itomi, ikantanakeri: ‘Te nokowi.’ Iro kantacha osamaniityaake, ipiyimoshiryagaari itomi, jatake rantawaite. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Riyaatashitakeri itsipa itomi, ikantakeri eejatzi. Ikantanake irirori: ‘Ari nimatakero, Papá.’ Iro kantacha te riyaatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Itzimika apite itomi antakerori ikowakeri ipaapate?” Ari rakaiyanakeni, ikantzi: “Iri antakerori retawetakari ketziroini rimperawetakari.” Ikantzi Jesús: “Iriira awisaimine ikaatzi apatotziriri koriki, eejatzi mayempiroyetatsiri, ipinkathariwentairi Pawa. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tema ripokake pairani Juan omitsitsiyaatantaneri, ikamantawetakemi jimpe pinkantya pinkameethashiretantaiyaarime, iro kantacha te pikemisantawakeri. Iriima ikaatzi apatotziriri koriki, eejatzi mayempiroyetatsiri, okemisantawakeri. Piñaawetawakari eerokapaini, iro kantacha te pipakayiro jimpe pikantaiyani, ompoñaantyaari pinkemisantawakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pinkemero otsipa noshiyakaawentemiri. Tzimatsi pankitzirori chochokimashi, rotantakotakero maawoini othapiki, riwetsikashitakero rowerowa owaa paata, riwetsikake eejatzi pankoshetantsi onkene raminakoitero. Rithotyaakotake atziri aminerone iwankiremashi. Jatake irirori intaina. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Okanta okithokitanake chochoki, rotyaantake rimperatanewo ragaate okithoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ikanta antawairentzi aminirori pankirentsimashi, iñaawakeri ripokaiyakeni imperataarewo, raawakeri romposawetawakari apaani, ritsitokawakeri itsipa, rishemyaantakari mapi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Rotyaantawetaka itsipa rimperatanewo, osheki ikaataiyakeni. Ari ikantzitaitawakari eejatzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ikanta weyaantapaakawori, rotyaantakeri itomi irirori, ikantzi: ‘Ari impinkathaitawakeri notomi naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikanta jirikapaini antawairentzi, iñaawakeri itomi, ikantawakaanaka: ‘Iri ashitaiyaawone paata jiroka pankirentsimashi. Jame atsitokeri, ayeroota aaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Rotaiyawakeri, raanakeri othapiki pankirentsimashi, ritsitokakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Arika ripokanake ashitawori iwankiremashi, ¿tsika inkanterika jirikapaini antawairentzi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ari rakaiyanakeni, ikantzi: “Ontzimatye ritsitokaiteri jirikapaini kaariperori, raminai itsipa iriiperori aminairone pankirentsimashi, amapiintainirine okithoki iwankire.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ikantanake Jesús: “Tema piñaanatero okantziri Osankenarentsipero: Imanintawetakawo mapi wetsikirori pankotsi, Iro kantzimaitacha ipiriintaitakero mapi pankotsinampiki, roshiyakaitairo iroorikame tzinkamitsi. Iri Awinkatharite Pawa owairori onampinaki, Iroowa ayokitziiwentantariri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Iro nokantantari: Eero piñagairo eeroka impinkathariwentaimi Pawa, iri impinkathariwentairi itsipasatzi atziri ikaatzi oshiyaawone pankirentsi ikithokitzi ikemisantanai. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jiroka okantakota mapi: Inkaate ontziwatyaawone, ari ritankawaitake. Iriima inkaate anawyagairi, ari ishemyaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ikanta reeware Imperatasorentsitaarewo itsipatakari Fariseo-paini riyotawakero iriira roshiyakaawentake Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ikowaiyawetanakani raakaantanakerime, osheki ithaawakayimaitakari atziripaini. Tema riyoshiretaiyini atziripaini Kamantantaneri rini Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ikanta rapiitakero Jesús roshiyakaawentziro riyotaantziri. Ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Jiroka ikanta ipinkathariwentantai Inkitesatzi, roshiyakotari pinkathari oimoshirenkiriri itomi raawakaaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rotyaantakeri rimperatanewo, inkamanteri inkaate pokatsine roimoshirenkya. Iri kantacha jirikapaini, te ripokaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Rotyaantake itsipa rimperatanewo, ikantawakeri: ‘Pinkanteri noyaimanewo ripoke roya, nowamaake wathayetatsiri nopira, nokimoshirewentziri notomi raawakaiya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eekero ripiyathataiyatyaani. Jatake rowaneki, itsipa ikenanake ipimantawaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eenitatsi itsipa owasanketawakeriri imperataarewo, ritsitokakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ikanta ikemake pinkathari, rotyaantake rowayerite, rithonkakeri ritsitokapaakeri tsitokantaintsiri, ritaakero ipanko. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ikantairi itsipa rimperatanewo: ‘Aritake wetsikayetaka owanawontsi oimoshirenkyaari, te opantari noyaimanewo, eero ripoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Piyaate awotsiki ikenapiintaitzira, pinkanteri inkaate piñeeri ripokeeta oimoshirenkya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ikanta riyaatake imperataarewo, ipiyotakeri ikaatzi iñaakeri: kameethatatsiri eejatzi kaariperotatsiri. Piyotaiyakani oimoshirenkayetachari. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ikanta pinkathari raminakeri ikaatzi pokaintsiri. Iñaatzi osatekainchari apaani te ikithaatapaakawo rowaneenkatashitantyaariri aawakaachane. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ikantapaakeri: ‘Asheninká, ¿tsika okantaka pikyaantakari te pikithaawentari notomi?’ Ari imairetake, te raki. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ikantakeri rimperatanewo: ‘Poosowakoteri, poosoyitziteri, pookeri otsirenikitakera, ari riraawaityaari ratsikaikiwaitya inkemaatsitaiya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Osheki inkaimawetaitya, iro kantzimaitacha apawopaini riyoyaayeetai.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ikanta ripiyaiyanaani Fariseo-paini. Ikenkithawaitaiyakeni, ikantawakagaiyani: “¿Jimpe ankanterika Jesús akompitakaantyaariri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rotyaantanakeri riyotaanewo irirori itsipataanakeri raapatziyanepaini Herodes, ikantapaakeri Jesús: “Yotaantanerí, okaatzi piyotaantziri iroopero ini. Iro ompoñaantyaari riyotakoperoitairi Pawa. Tekaatsi pinthaawakaiya. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pinkantena eeroka oita pikenkithashiretari: ¿Kameethatatsima apinateri Pinkathari César ikowakaantziri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iri kantacha Jesús, riyotawakeri ikenkithashiretari, ikantziri: “Owapeyimotantanerí. ¿Iitaka pikowantari pikompitakaina? ");
INSERT INTO cpbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poñaayenari koriki pipapiintziriri Pinkathari.” Ramaitapaakeniri apaani koriki iitaitziri “denario”. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rosampitanakeri: “¿Iitaka ashitawori iwairo jaka? ¿Iitaka ashitawori roshiyakaawo?” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ikantaiyini: “Rashi César.” Ikantzi Jesús: “Tema iri César ashitariri, pantantyaanari okaatzi ikowakaimiri, pipinateri. Iriima ikaatzi rashitari Pawa, pantantyaanari okaatzi ikowakaimiri Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikanta ikemaiyakeni ikantakeriri Jesús, riyokitziiwentanakeri, ripakaanakeri. Jataiyaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ikanta ripokaiyakeni Sadoc-iite iñeeri Jesús. Iriitake Sadoc-iite kantapiintatsiri: “Eero rañagai kamayetatsiri.” Rosampitapaakeri Jesús, ");
INSERT INTO cpbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ikantapaakeri: “Yotaantanerí, rosankenatake pairani Moisés, okantzi: ‘Arika inkame apaani atziri, eerorika rowaiyakaanakawo iina, shinetaantsitatsi ragairo irirentzi, rowaiyakagaiyaawo. Roshiyakagairi iriime ashityaarine irirentzi kamaintsiri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jame ankantawake: Tzimatsi kaatatsiri 7 irirentzi. Etawori itzimi raake iina, te rowaiyakaawo iina kamake, ragairo itsipa irirentzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ari ikantakari eejatzi apitetapaintsiri irirentzi. Poñaapaaka itsipa mawatapaintsiri. Ari ikantakari maawoini ikaatzira 7. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Okanta osamanitake kamai eejatzi tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Arikame rañaayetai paata kamayetatsiri, ¿tsika itzimika oimentaperotaiyaari tsinane? Tema maawoini ikaatzira 7 iinantawetakawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rakanakeri Jesús, ikantziri: “Pikenakaashitakawo eeroka, te piyotakotziro Osankenarentsipero, te piyotakotairo eejatzi ishintsinka Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Arika rañaayetai paata kamayetatsiri, eero itzimayetai aawakagaachane. Roshiyapaiyaari imaninkarite Pawa Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Tema piñaanatakotziro tsika onkantya arika rañaayetai kamayetatsiri? Tema ikantake Pawa, riñaawaitake: ");
INSERT INTO cpbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Naakatake Pawa ipinkathatziri Abraham, Isaac, eejatzi Jacob. Ari ayotaiyini añaayetatsi irirori, te okanta kaminkari impinkathateri Pawa, apa rimatziro añaayetatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ikanta ikemaiyakerini Jesús ikantakeriri, riyokitziiwentanakeri, ikantaiyini: “Imapero okameethatzi riyotaantziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ikanta ipiyotaiyakani Fariseo, tema ikemake kameetha rakakeri Sadoc-iite rosampitakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ikanta apaani, irijatzi yotakoperowetawori Inintakaantaitanewo, ripokashitakeri Jesús rosampiteri, tema ikowatzi rikompitakayaarime, ikantapaakeri: ");
INSERT INTO cpbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yotaantanerí, ¿otzimika Inintakaantaitanewo anairori otsipa?” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ari rakanake Jesús, ikantziri: “Piwinkatharite rini Pawa, ontzimatye pinintaperotairi, pinintashirenkatairi, pinintashiretairi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iroowa etawori Inintakaantaitanewo ikowaperotaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ari oshiyawo apitetanaintsiri: Ontzimatye petakotaiyaari pisheninka, poshiyakagairi pineshironkatziro eeroka piwatha. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pimonkaatakerorika jiroka kaataintsiri apite, pimatakerowa maawoini rosankenayetakeri Moisés-ni, maawoini eejatzi rosankenayetakeri Kamantantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Rimatanakero irirori Jesús, rosampitakeri Fariseo-paini itsipatakari ipiyotaiyanira. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ikantziri: “¿Iitaka pikenkithashiretakotariri eeroka Cristo? ¿Tsika iitaka charinetariri?” Ikantaiyini Fariseo: “Icharine David-ni rini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ikantzi Jesús: “¿Tsika oitaka riñaawaitakaantariri pairani David-ni Tasorenkantsi, roshiyakaakeri Iwinkatharite? Ikantake pairani: ");
INSERT INTO cpbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ikenkithawaitake Pinkathari, ikantawairi nowinkatharite: Pisaikapai nakoperoki ampinkathariwentante, Irojatzi paata nowasanketantakyaariri kisaneentakemiri, Ari pimakoryaayitzitantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Rimatzitakawo David-ni ikantake: ‘Nowinkatharite rini.’ ¿Tsika inkene incharinetyaari?” ");
INSERT INTO cpbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mairetaiyanakeni te raki. Thaawashire ikantaiyakani, tekaatsi kowanaatsine rosampitanairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ari ikenkithatakaakeri Jesús atziripaini itsipataakeri riyotaanewopaini, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pamineri Yotzinkariite eejatzi Fariseo-paini, iro ikamaita rowaagakoyetziro okaatzi rosankenayetakeri pairani Moisés-ni. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pinkemisanteri onkaate inkantayetemiri, te okameethatzi poshiyakotyaari okaatzi rantayetziri, tema te rimonkaayetziro irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Imapero opomeentsita okaatzi ikowakayimiri pimayetairime. Te iñiimaitawo impomeentsiwentyaawo irirori rimatantyaawori. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rantashiyetawo ikowiri irirori iñaantaityaariri. Osheki rashiminthatari mashitsimonki roteyetzirowa Osankenarentsipero rontarekakotziro ishempaki, eejatzi itamakoki. Osheki rowaneenkakaakiyetziro iithaare rishirikiro manthakintsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rashiminthatawo rosatekaiteri niyankineki arika rowaiyani isheninka. Ari ikantari eejatzi arika riyaate pankotsiki rapatotapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ikowi impinkathaiteri arika iñagaiteri, riwethaityaari. Ikowi eejatzi inkantaiteri: ‘¡Yotaantanerí!’ ");
INSERT INTO cpbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Te okameethatzi pimatero eeroka, eero pikowashita inkantaitemi: ‘¡Yotaantanerí!’ Tema maawoini eerokapaini oshiyawaitakawo pirentzitawakagaatya. Apaani ikanta yotaantatsiri, iriitake Cristo, tekaatsi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jaka kipatsiki, te okameethatzi pinkantashiwaityaari pisheninka: ‘¡Ashitanarí!’ Tema apaani ikanta Ashitzimiri Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Te okameethatzi eejatzi inkantaitemi: ‘¡Nowinkatharité!’ Tema apaani ikanta piwinkatharite, iriitakera Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inkaate kowatsine ririiperote, roshiyakotyaari ikantaga ronampitaitari. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Inkaate kowashiwaitachane impinkathaiterime, ari iñaakero intsinampashiretakagaitairi. Iriima tsinampashirewaitatsiri, iri ñagairone impinkathaitairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Ikantamatsitaitzimi eeroka Yotzinkari eejatzi Fariseo, owapeyimotantaneri pinatzi! Osheki potzikakeri ipinkathariwentairi Pawa. Eero piñagairo eeroka impinkathariwentaimi, ¿tsika piiteroka piyotaantyaariri itsipa impinkathariwentai irirori? ");
INSERT INTO cpbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ikantamatsitaitzimi eerokapaini Yotzinkari eejatzi Fariseo, owapeyimotantaneri pinatzi! Pawentaashitawo kamatsiri oime pashitzitawo opanko, iro posamaninkantawori pamanapiintawetaga eero riyotantaitzimi. Iro kantzimaitacha antawo rowasankeetaimi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ikantamatsitaitzimi eerokapaini Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Osheki poomerenchaakeri atziripaini kaari asheninkata roshiyakotai aaka a-judá-itetzira, piyotaakeri rowapeyimotante irirori. Roshiyakotantaimiri eeroka ratsipetaiyaawo sarinkaweni. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ikantamatsitaitzimi eerokapaini, oshiyakotariri mawityaakiri rakathatawakagaiyani! Tema raakoitziro owairo tasorentsipanko, ikantaitzi: ‘Rowasanketainaata Tasorentsipankotsiweri eerorika nimonkaatziro nokantziri.’ Pikantapiintaiyakeni eerokapaini: ‘Eerorika rimonkaataitziro, tekaatsi oitya.’ Irooma arika raakoiteri iwairo ooro saikatsiri tasorentsipankoki, pikantapiintake: ‘Ontzimatye rantaitero ikantaitakeri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Masontzishirerí, mawityaakishirerí! ¿Iitaka kowaperotachari, iriima ooro? Kaari, tema iro irooperotatsi tasorentsipanko otasorentsitakairi ooro. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ari okantari eejatzi arika raakoitero owairo taapokimentotsi, ikantaitzi: ‘Rowasanketainaata Ataapiintziniri eerorika nimonkaatziro nokantziri.’ Iro kantacha pikantapiintaiyakeni eerokapaini: ‘Eerorika rimonkaataitziro, tekaatsi oitya.’ Irooma arika raakoitero iwairo piratsi ritagaitziri taapokimentotsiki, pikantapiintake: ‘Ontzimatye rantaitero ikantaitakeri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Masontzishirerí, mawityaakishirerí!, ¿Iitaka kowaperotachari, iriima piratsi? Kaari, tema iro irooperotatsi taapokimentotsi otasorentsitakairi ritagaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ikaatzi aakotzirori owairo taapokimentotsi, raakotakero owairo maawoini ikaatzi ritagaitziri janta. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ari ikanta eejatzi ikaatzi aakotzirori owairo tasorentsipanko, raakotakero owairo maawoini okaatzi tzimantawori. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ikaatzi aakotzirori owairo inkite, raakotakero owairo maawoini janta risaikinta Pawa, roshiyakaakero iriime Pawa raakotake iwairo. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ikantamatsitaitzimi Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Pinashitapiintanari pashitakaariri Pawa, pipayetapiintziri inchashaaniki. Temaita pantayetziro irooperotatsiri ikowakaitzimiri: Pinkameethashireyete, pineshironkashiretante, pawentaashiretaiyaari. Irootake irooperotatsiri pantayetairo, eero pipakayimaitawo panteniri otsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Mawityaakiri, akathatawakaachari! Poshiyakari pankenatariri shikiryaaniki eero rirakotantari, iro kantzimaitacha rirakotakeri antari piratsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ikantamatsitaitzimi eeroka Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Poshiyakotakawo iramentotsi eejatzi owamentotsi, okiteweta kameetha jakakeroki, irooma inthomoiki kipatsi okantaka. Ari pikantayetaka eeroka kantacha iñagaitemi kameethashireri pini, koshintzimaita pini, pikowapiintakero pinintaawaitya. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mawityaakiri Fariseo! Poshiyakairo poshetatyeerome inthomoiki piraamento eejatzi powamento, ompoñaantyaari onkitetai eejatzi jakakeroki. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ikantamatsitaitzimi eeroka Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Poshiyakawo okitamaaweta rowantaitariri kaminkari, owaneenka okantaka jakakeroki. Iro kantacha inthomoiki, ari risaikake itonkipooki kaminkari, shityeenkatake. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ari pikantayetakari eeroka, iñaayewetakemi atziri pantakero kameethari, iro kantzimaitacha inthomoikinta owapeyimotantaneri pinatzi, kaariperoshiretakemi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ikantamatsitaitzimi eeroka Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Oitaka piwetsikapookitantawori ikitayeetakerira Kamantantaneri, powaneenkayetakero eejatzi inkene inkenkithashiretakoitapiintemi, inkantaite: ‘Kameethashireri rinake jirika.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pikantaiyini eejatzi: ‘Arime nontzimakeme ketziroini naaka eero nowamairime, eero noshiyakotari nocharineni ikaatzi owamaakeriri Kamantantaneri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eerokatake thawetakotacha apaniroini, iri poshiyakoyeta eeroka picharineni ikaatzi owamaayetakeriri pairani Kamantantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Janjaatya pithotyeero eeroka kaariperori okaatzi retanakari pairani picharinepaini! ");
INSERT INTO cpbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Poshiyakawo pisheninkatatyeeyaarime maanke! Kaariperoshire pikantaka. ¿Tsika pinkantaiyaaka pishiyapithatantaiyaawori powashironkagaiya sarinkaweniki? ");
INSERT INTO cpbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iro notyaantantakemiriri pairani Kamantantaneri, yotaneri, eejatzi etawori Yotzinkari. Eenitatsi apawopaini powamaakaantayetakeri, pikentakotakaantayetakeri itsipa. Eenitatsi itsipa, pipasatakaantawaitakeri rapatotapiintaitaga, osheki powasankeyetakeri maawoiniki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iro piñaantyaawori rowasankewentaitemiri eeroka ikaatzi kamayetaintsiri pairani, retanakawo kameethashireri Abel irojatzi Zacarías itomini Berequías. Iriira rowamagaitake pairani riyaaterome taapokimentotsiki ipoñaanakawo tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Imapero nokantzimi ari rowasankewentaitakemiri jirikapaini nosheninka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalén-satzí! Osheki pitsitokake Kamantantaneri. Pishemyaayetakeri ikaatzi rotyaantawetakemiri. Tema nokowawetapiintaka noshiyakotyaarime tyaapa rosatetziri iryaani, ari nokowawetaka nonkantairime naaka maawoini ikaatzi notomintaari. Iro kantzimaitacha te pikowaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jaka pisaikawetaga eero iñagaitai paata iita nampitaiyaawone, kaankiityagai. ");
INSERT INTO cpbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tema eero piñaapiintaana jaka, irojatzi paata pinkantantaiyaari: Tasonkawentaari rini, tema Pinkatharentsi aitziri otyaantakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ikanta rishitowanairo Jesús ipoñaanaawo tasorentsipankoki, iro riyaatai. Ari ikantziri riyotaanewo: “Paminero jimpe okanta riwetsikaitziro tasorentsipanko.” ");
INSERT INTO cpbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Rakanakeri irirori, ikantanakeri: “Maawoini piñaakeri, eero piñagairo paata jimpe okanta mapi opewiryaayetaka iroñaaka, iroowa rithonkaitero intzimpookaitero. Imaperotatya nokantzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ikanta ritonkaanake otzishiki Olivo, ari risaikapaake. Rosampitakeri riyotaanewo, ikantziri: “Janjaatya pinkantena, ¿tsikapaiteka imonkaatya pikantakeri? ¿Aripaitema ithonkaiya arika pipiyimatai? ¿tsika onkantyaaka niyotantyaawori?” ");
INSERT INTO cpbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Rakanake Jesús, ikantanakeri: “Ontzimatye paamaya ramatawitaitzimikari. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tema osheki kowatsine ramatawitemi paata, raakotapaakena nowairo, inkante: ‘Cristo nini naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ari pinkemakoyetakero omanataantsi, paamaiya ominthaawashiretzimikari. Ontzimatye awisayete jirokapaini, tekeraata imonkaatyaata ithonkantaiyaari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Rantaminthatawakaiya maawoini nampitsiki inkaate rotyaantayeteri pinkathariyetatsiri. Iñagaite mantsiyarentsi, tashetsi, omoyekya kipatsi tsikarikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iroowa etanakyaawone inkemaatsitaityaawo jirokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Raakaantaitanakemi eeroka, inkoshekawaitaitemi irojatzi rowamaantaitakemiri. Osheki inkisaneentanakemi atziri okantakaantziro paakotairi nowairo pikemisantaana. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ari iñagaitake atsipetashitawori ikemisantaweta, iñagaite kisaneentawakaachane, iñagaite aakaantawakaachane. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Osheki pokapaintsine roshiyawetapaakyaarime Kamantantaneri, ramatawitapaakeri inkaate kemisantawakerine. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Rantaperoitero kaariperori, eero ineshironkatawakaanaa atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iriima kyaaryootaintsine, iriitake awisakoshiretaatsine. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Arika ithonkakya inkemakoitairo maawoini kipatsiki Kameethari Ñaantsi kenkithatakotzirori ipinkathariwentantai Pawa, aripaite imonkaataiya ithonkantaiyaari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ari piñaakeri iitaitziri ‘Pinkaari Thonkaatantaneri’, ikenkithatakotakeri pairani Kamantantaneri Daniel. Risaikapaake otasorentsitzira. (Maawoini ñaanaterone jiroka, okowaperotatya inkemathatairo.) ");
INSERT INTO cpbNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Inkaate nampitaiyaawone paata jaka Judea-ki, ontzimatye rishiyayetai tonkaariki. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pisaikerika jekokeroini pipankoki, irojatzi pishiyantanakyaari, eero pikyaapanaantzi paapanaante oitarika. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Powanekirika pisaiki, pishiyanake tsika pikanta, eero paapanaantziro piithaare. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Inkantamatsitaitero paata onkaate motziyetatsine, onkaate eejatzi tzimayetatsine eentsite eeni ithotsi! ");
INSERT INTO cpbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pamañaari Pawa, onkantyaama arika pishiyayetake, eero pitonkyotantawo kyaawontsi, eero pishiyanta eejatzi kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tema antawo iñagaitero rashironkaitya paata. Pairani owakera riwetsikaitakero kipatsi, irojatzi iroñaaka, te iñagaitziro oshiyaawone jiroka ashironkagaantsi. Eero apiita iñagaitairo oshiyaawone. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eerome ishintsitaitzi romairyagaitero jiroka ashironkagaantsi, tekaatsime awisakotaatsine. Ikamintha itzimayetzi riyoyaitakeri, awentaayetaariri Pawa, iro romairyaantaitakawori intsipaiteeni jiroka ashironkagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Arika pinkeme inkantaitemi: ‘Jirika Cristo’, itsipa kantatsine: ‘Jirinta Cristo’, eero pikemisantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ripokayetapaake oshiyakotyaarine Cristo, oshiyakotyaarine Kamantantaneri. Ari ritasonkawentantapaake, inkowawetya ramatawiteri riyoyaayetakeri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nokamantzitakemirowa. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ari inkantaitakemi: ‘Areetaka janta ochempiki.’ Eero piyaatashitziri. Inkantaite eejatzi: ‘Ari risaiki inthomoiki pankotsiki.’ Eero pikemisantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tema arika ripiyai Itomi Atziri, roshiyapaiyaawo okanta ookathawontsi. Etanakyaawo imorekanake rishitowapiintzira ooryaatsiri, irojatzi tsika ikyaapiintzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tsikarika risaiki shitziwari, ari ipiyowentari amempori.” ");
INSERT INTO cpbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Arika onkaatapaake paata rashironkaita antawo, ari ritsiwakake ooryaa, eero roorenta kashiri eejatzi. Rithopiryaayete impokiro, maawoini ikaatzi oorentachari inkiteki rithonkya ripookayete. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aripaite inkoñaatapai Itomi Atziri inkiteki. Antawo inthaawayetanake atziri jaka kipatsiki. Tema iñagaitawairo rowaneenkawo eejatzi ishintsinka, inkenantapaiyaawo menkori. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Rityootapaake shintsiini maninkariite, impiyotapairi ikaatzi riyoyaakeri nampitawori maawoini tsikarika jaka kipatsiki, irojatzi jimpe owatzitapaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Oshiyawo piñaapiintziro eereshiyetai pankirentsi, piyotzi irootaatsi osarentsitzimatai. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iro piyoteri eerokapaini, arika piñaayetakero nokantayetakemiri, jekaatzimataana. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Imaperotatya nonkante, eero ipeyayetzitaawo jirika asheninkapaini, irojatzi iñaantayetakyaawori nokamantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ari ithonkaiya inkite eejatzi kipatsi, irooma okaatzi niñaaneyetakari imaperotatya iroori. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iro kantacha tekaatsi yotatsine tsikapaite, iri owatsipero inkiteweri te riyotzi. Tema apatziro ikantakaawo Ashitanari riyotziro irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ari oshiyawo okanta pairani eeniro rañaaweta Noé, ari onkantaiyaari eejatzi arika ripiyai Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tema pairani tekera areetaata oonkawo, inimowaitziri atziri, rowawaitaiyani, rirawaitaiyini, itsipatari aayetatsiri iina. Irojatzi rotetantanakari Noé pitotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tekaatsi inkenkithashirete, irojatzi omapokantakari oonkawo, ari raperaataiyakani maawoini. Ari onkantaiyaari eejatzi arika ripiyai Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Risaike apite antawaitatsiri rowaneki, ragaitanai apaani inkiteki. Iriima itsipa rookaitanairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Isaike apite tsinane itoonkawaite, ragaitanai apaani inkiteki. Irooma otsipa tsinane rookaitanairo. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Paamaawentaiya eeroka, tema te piyotzi tsikapaite ripiyai Piwinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pinkenkithashiretakoteri apaani atziri, arikame riyote ripokatye koshintzi tsireniriki, ari raamaakyaame, eero ikoshaagantaitzirime ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ari onkantyaari, ontzimatye paamaawentaiya eejatzi eeroka. Tema tekaatsi yotatsine tsikapaite ripiyai Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Poshiyakotyaari kameethashireri noshikaarewo, kenkithashiretachari kameetha. Rookanakeri ipankoki imperatariri, ikantanakeri: ‘Paminenari ikaatzi saikatsiri pankotsiki.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kimoshire inkantaiya jirika noshikaarewo, arika ripiyai imperatariri, tema iñaapairi rimonkaatakero ikantanakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ari rishinetaakeniri inkempoyagainiri maawoini okaatzi rashitari. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iriima kaariperoshireri noshikaarewo, ikantzi: ‘Eero ripiyita imperatanari.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Arira rowasankewaitakeri itsipa noshikaarewo. Jatake intsipayetyaari shinkiyantzi. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Inimowaitziri jirika noshikaarewo, romapokashitaiyaari rareetaiya imperatariri. ");
INSERT INTO cpbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Rimaperoiteri rowasanketapairi, rookapaakeri tsika ikashaakagaitakeri owapeyimotantaneri. Ari riraawaitya, ratsikaikiwaitya inkemaatsitaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Jiroka ikanta ipinkathariwentantai Inkitesatzi, roshiyatyaawo 10 mainawo jatatsiri tsireniriki itonkyotyaari aawakaachane. Aayetanake ootapiintaiyarini. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Eenitatsi okaatzi 5 mainawo kyoshiretatsiri, eenitatsi eejatzi okaatzi 5 mainawo kaari kyoshiretatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jirokapaini 5 mainawo kaari kyoshiretatsiri aawetanakari ootapiintari, iro kantacha eepichoki aanake iyaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Irooma otsipa kyoshiretaintsiri, aayetanake iroori ootapiintari, aanake eejatzi osheki iyaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te ripokita aawakaachane, ayimatapaakero owochokine, magaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Okanta niyankiite tsireniri, okematzi ikaimaitzi, ikantaitzi: ‘¡Kaakitake aawakaachane, pitonkyotawakyaari!’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kakitaiyanakeni mainawo, iyeekiyetanairi iyaa ootapiintari. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mainawopaini kaari kyoshiretatsiri, okantawetanakawo kyoshiretaintsiri: ‘Pimpena iyaa pootapiintari, irootaintsi ritsiwake nashi naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ari okantanake: ‘Te ikimaatzi nashi naaka, piyaate pamanantapainte eeroka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iyaaminthaitapaintzi amanantzi, areetapaaka aawakaachane. Jirokapaini okaatzi aamaawentainchari, itonkyotawakari, raanakero tsika roimoshirenkaiteri. Rashitaitanakero otantotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Okanta ipiyawetapaaka jatatsiri amanantzi, okaimakaimawetapaaka, okantapaake: ‘¡Pashitareenawo naaka!’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Okematzi rakaitanakero, ikantaitziro: ‘Te niyotzimi. Imaperotatya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ontzimatye paamaawentayetaiya eeroka. Tema te piyotzi tsikapaite ripiyai Itomi Atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Jiroka ikanta ipinkathariwentantai Inkitesatzi, roshiyakotatyaari apaani atziri kowatsiri riyaate intaina, ipiyotakeri rimperatanewo, ipanakeri inkempoyeeniri okaatzi rashitari. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ipanakeri apawopaini rimperatanewo iyorikite. Jirika kenkithashiretachari kameetha, impanakeri ikaatzi 5 koriki, itsipa yoneentatsiri impanakeri ikaatzi apite, iriima itsipa weyaantapaakawori impanakeri apaani. Jatake intaina. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ikanta jirika ipaitakeri 5 koriki, rantawaitakaakeri, roshekyaakeri ragai ikaatzi 5. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ari ikantakari ipaitakeri apite, roshekyaakeri irirori, ragai ikaatzi apite. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iriima itsipa ipaitakeri apaani, raanakeri iyorikite, ikitatakeri kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Okanta osamanitake piyaawo ashitariri koriki, ikaimakaantapairi rimperatanewo riyote oita rantantakari iyorikite. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ari ripokapaake ipaitakeri 5 koriki, roñaagapairi itsipa 5 koriki roshekyaakeri, ikantapaakeri: ‘Pinkatharí, 5 koriki pipakena pairani, jirika itsipa 5 noshekyagairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ikantzi Pinkathari: ‘Ariwé nimperatanewo, kameethashireri pini. Eepichokiini koriki pikempoyaakena, ari pinkempoyagai itsipa osheki. Pipoke, pintsipataina pinintagaiya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Areetapaaka ipaitakeri apite koriki, ikantapaakeri: ‘Pinkatharí, apite koriki pipakena, jirika itsipa apite noshekyagairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ikantzi pinkathari: ‘Ariwé nimperatanewo, kameethashireri pini. Eepichokiini koriki pikempoyaakena, ari pinkempoyagai osheki itsipa. Pipoke, pintsipatena pinintagaiya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Areetapaaka ipaitakeri apaani koriki, ikantapaakeri: ‘Pinkatharí, niyotzi naaka mashireyantzi pini, pashi powiro pantawaitakaantziri piyorikite, piñaantyaawori poshekyeeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iroowa nothaawantakari, naakeri piyorikite, nokitatakeri kipatsiki. Jirika iroñaaka namaimiri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Rakanakeri ikantziri: ‘Kaariperoshireri pini, perantzi pini. Piyowetaka ari nonkisakemi eerorika poshekyaanari noorikite, ");
INSERT INTO cpbNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","piñaawetaka eero pimatziro eeroka, pamineme iita antawaitakaimirine, ari ishenitaime iroñaaka, iri pimpawainarime nipiyaawowa.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ikantanakeri ikaatzi saikaintsiri: ‘Paapithateri koriki, pimpairi itsipa oshekyaakeriri 10 koriki.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ikaatzi otzimimotziri, ari ontzimimotairi osheki. Iriima kaari otzimimotzi, eekero riyaatatye iñagairo eero otzimimotairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Paanakeri jirika kaariperoshireri, pookeri otsirenikitzira. Ari riraawaityaari, ratsikaikiwaitya inkemaatsiwaitaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Arika ripiyai Itomi Atziri pinkatha rowaitairi. Intsipataiyaari maninkariite, roshiyakotaiyaari ikanta pinkathari risaikantawo owaneenkatachari risaikamento. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Impiyotairi maawoini atziri tsikarika risaikai irirori. Rinashiyetaiyaari roisaikayetairi. Roshiyakotaiyaari atziri yoshiitziriri ipira te ikowakayiri intentaiya. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Roisaikairi ikowaperotziri rakoperoki, iriima imanintayetziri rampateki roisaikairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kenkithawaitake Pinkathari, riñaanateri rinashitakari rakoperoki, inkanteri: ‘Pipoke maawoini, osheki inkimoshiretakagaimi Ashitanari, pinampitaiyaawo tsika ipinkathariwentantzi irirori, arira riwetsikaantakemi pairani owakera riwetsikantakawori kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tema piñaana pairani aawetana nitashe, iro kantacha pipakena nowanawo. Piñaana ayimatana nomere, pipakena nirakeri. Piñaakena nareeta pinampiki, pineshironkatakena pipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Piñaana nisagaakowaitzi, pipakena nokithaatari. Piñaana nomantsiyatake, pamitakotakena netsiyatakotantaari. Romonkyaakaantaitakena, pipokashitakena piñaana.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ikantaiyini kameethashireri: ‘Pinkatharí. ¿Tsikapaite noñiimika pitasheneentzi, nopantzimiri powanawo? ¿Tsika noñiimika pimereneentzi, nopantzimiri pimere? ");
INSERT INTO cpbNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tsikapaite noñiimika, naakameethatantzimiri nopankoki? ¿Tsikapaite noñiimika pisagaakowaitzi, nopantzimiri piithaare? ");
INSERT INTO cpbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tsikapaite noñiimika pimantsiyatzi, romonkyagaitzimi, niyaatashitantzimiri noñiimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ari rakanake Pinkathari, ikantzi: ‘Tema pineshironkatakeri ikaatzi awentaayetanari noshiyakagairi iyeki, naakatajaantake pineshironkatake. Imaperotatya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ripithokashitanakari saikaintsiri rampateki, ikantziri: ‘Kaariperorí, piyaate eeroka pinkemaatsiwaitaiya paampariki kaari tsiwakanetatsine, ikashaakaitakeriri Kamaari intsipataiyaari maawoini imaninkarite irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Piñaawetakana nitasheneentzi, te pipana nowanawo. Owamaimatakena nomere, te pipana nire. ");
INSERT INTO cpbNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Piñaawetana nareeta pinampiki, te pineshironkatena pipankoki. Piñaawetana nisagaakowaitzi, te pipana nonkithaatyaari. Piñaawetana nomantsiyatzi, romonkyaakaantaitana, te pareetana.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Rakanake kaariperoshireri, ikantzi: ‘Nowinkatharite, ¿tsikapaiteka noñaawetzimi pitasheneentzi, pimereneentzi, pareetanta, pisagaakowaitzi, pimantsiyatzi, romonkyagaitzimi, temaita noneshironkayetzimi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ikantanake Pinkathari: ‘Te pineshironkayetantai, inkantawetakya iryaani rine, naakatake pantzimotake. Imaperotatya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iroowa ratsipetantaityaawori kantaitaachane ashironkagaantsi. Iriima inkaate kameethashiretaintsiri, inkantaitaatyeero rañaayetai.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ikanta rithonkanakero Jesús okaatzi ikenkithawaitakotakeri, ikantanakeri riyotaanewo: ");
INSERT INTO cpbNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Piyotaiyini eeroka yotapaaka apite kiteesheri roimoshirenkaityaawo Anonkoryagaantsi. Ari raakaantaiteri Itomi Atziri inkentakoiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ikanta reeware Imperatasorentsitaarewo itsipatakari Yotzinkariite, eejatzi Itzinkamipaini, ipiyotaiyakani ipankoki Caifás reewaperore Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ari ikamantawakaiyakani, ikantaiyini: “Jame amatawiteri Jesús ayeri atsitokakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iro kantacha eero akoshekari kiteesheriki roimoshirenkantaitari, ikisawentzirikari atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ikanta ikenanai Jesús Betania-ki, ipankoki Simón pathaawaiwetachari. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ari areetapaaka tsinane amakotake kasankari, kameetha okantaka onaki riwetsikaitziro mapi jitachari “alabastro”, osheki owinawo. Isaitantapaakari iitoki Jesús risaikakera rowaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ikisaiyanakani riyotaanewo iñaakerowa, ikantaiyini: “¿Oitaka apaawaitantawori? ");
INSERT INTO cpbNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Arikame ompimantya, ragaiteme osheki koriki impaiterime ashironkainkari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Riyotakotakeri Jesús, ikantziri: “¿Oitaka pikisantawori jiroka tsinane? Kameetha okanta noñaakero naaka antakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Rashi rowaatyeero ashironkainkari pintsipatyaari, irooma naaka eero pintsipataana. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tema jewatake isaitantanawo kasankari imotaawentatyaanawo paata arika inkitaitakena. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Arika inkamantantaitero paata Kameethari Ñaantsi, inkenkithatakoitero jiroka tsinane, roshiretakoitantyaawori antakeri. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ikanta Judas Iscariote kaawetachari 12 riyotaanewo Jesús, riyaatashitakeri reeware Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ikantapaakeri: “¿Iitaka pimpenari arika namakemiri?” Roñaagaitanakeri ikaatzi 30 ipewiryaaka koriki. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aripaite raminaminatanakero Judas tsikapaite raakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Areetapaaka etawori kiteesheri rowantapiintaitawori tashirentsiponka, pokaiyapaakeni riyotaanewo Jesús, rosampitziri: “¿Tsika onkotsitakaanteka oyaari kiteesheriki Anonkoryagaantsiki?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ari rakanakeri: “Piyaate nampitsiki. Ari pitonkyotyaari apaani atziri, pinkanteri: ‘Ikantzi yotaanari: “Monkaatapaaka, nokowi niyaate pipankoki noimoshirenkero kiteesheri Anonkoryagaantsi, nontsipatyaari niyotaanewopaini.” ’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rimatakero riyotaanewo okaatzi ikantakeriri Jesús. Ronkotsitakaantake royaari kiteesheriki Anonkoryagaantsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ari otsireniityaanake areetapaaka Jesús, saikapaake rowaiyaanira itsipatapaakari riyotaanewo ikaataiyini 12. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ikanta rowaiyani, ikantanake Jesús: “Pinkeme nonkante, pikaataiyinira eeroka jaka, eenitatsi apaani pithokashitenane. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Owashire ikantaiyanakani. Apaanipaini rosampitanakeri: “¿Naakama, Pinkatharí?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Rakanakeri, ikantziri: “Akaatakera owaiyani, iri pithokashitenane. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Imaperotatya impeya jirika Itomi Atziri, iroowa rosankenatakoitakeriri pairani. ¡Ikantamatsitaitziri pithokashitenane! ¡Iitaka itzimaatsikaitantakari jirika!” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ari riñaawaitanake Judas pithokashitantachane, ikantzi: “¿Naaka yotaanarí?” Ikantzi Jesús: “Irootake pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eeniro rowaiyani raakero Jesús pan, riwetharyaawentakawo, itzipetowakero, ipayetakeri riyotaanewo, ikantziri: “Jiroka, poyaawo, nowatha ini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Raakotakero riraitziri, riwetharyaawentakawo, ipakotakeri riyotaanewo, ikantziri: “Piraiyeroni maawoini, ");
INSERT INTO cpbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","niraa inatzi jiroka, iro ooñaawontaperotairone aapatziyawakaantaiyaari, iro shitowaatsine rariperotantaitaiyaariri kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pinkeme nonkante, eero niritaawo jiroka irojatzi paata impinkathariwentantaira Ashitanari, ari apiitairo eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ikanta rithonkanakero romampaakotari Pawa, jataiyanakeni tonkaariki otzishiki Olivo. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ikantanakeri Jesús riyotaanewo: “Irootaintsi pookanawentaiyenani tsirenirikika. Rosankenaitake pairani kantatsiri: Nitsitokeri kempoyiiriri oweja, ari rithonkya ripookanake ipira. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iro kantacha arika nañagai, Galilea-ki piñaapaina.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ari rakanake Pedro, ikantzi: “Aritaikema rookanawentakemi itsipapaini, eero nimatziro naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ikantzi Jesús: “Pinkeme nonkantemi, iroñaaka tsirenirikika tekera riñaakeeta tyaapa, mawa papiitero pinkante: ‘Te niyotziri Jesús.’ Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ikantanake Pedro: “Eero nookanawentzimi, aritake ankaate ankame.” Ari ikantaiyanakeni eejatzi maawoini riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ikanta Jesús itsipatakari riyotaanewo, areetaiyakani Getsemaní-ki, ikantapaakeri: “Ari pisaikawake jaka, niyaatawakeeta naaka jantyaatsikaini namaña.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Raanakeri Pedro itsipataanakeri apite itomi Zebedeo. Ari riraakoshiretapaaka Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ikantzi: “Owamaimatatyaana nowashirenka. Ari pisaikawakeeta eeroka jaka, jame ankakite.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jataneentanake jantyaatsikaini irirori. Otziwerowapaaka, amanapaaka. Ikantzi: “Ashitanarí, pikowirika eeroka, pontsiparyaakowentena onkaate nonkemaatsityaari. Iro kantacha eero pimatanawo nokowawetari naaka, iro pimate okaatzi pikowakaanari eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Irojatzi ripiyashitantapaari riyotaanewo, iñaapaatziiri rimagaiyini. Ikantapaakeri Pedro: “¿Tema pikisashitawo piwochokine, pintsipatena ankakite? ");
INSERT INTO cpbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pinkakite, pamaña, otzimikari piyenakaashitanewo. Osheki naaweta pikowawetari panterome kameethatatsiri, iro kantacha te pikisashiwaineta.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eejatzi ripiyanaa Jesús, amanapaa, ikantzi: “Ashitanarí, tekaatsirika nonkenakairo naaka eero nokemaatsiwaitanta, panterowa okaatzi pikowakeri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ikanta ripiyapaa, eejatzi iñaapairi rimagaiyini, tema antawo okantaka iwochokine. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ripiyapithatanaari, mawa ripiyaka ramana. Irojatzi rapiitapai ikantakeri inkaaganki. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Irojatzi ripiyashitantapaari riyotaanewo, ikantapaakeri: “¿Irojatzima pimagaiyini? Monkaatapaakaga raantaityaariri Itomi Atziri, ragaiteri kaariperoshireriki atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pimpiriinte, jame aatai. Okaakitzimatapaake pithokashitenane.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ikenkithawaiminthaitzi Jesús, areetapaaka Judas itsipawetapiintari. Osheki atziri itsipatapaakari, ramayetake rowathaamento, ripasamento. Rotyaantanewo rini reewaperore Imperatasorentsitaarewo, eejatzi rashi Itzinkami. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ikantzitakari ketziroini ramanewo Judas pithokashitantaneri: “Tsikarika itzimi nonthowootapaakeri, iriitake, potaiyeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ikanta rareetapaaka Judas, ripokashitapaakeri okaakiini Jesús, ikantapaakeri: “Yotaanarí.” Ithowootapaakeri riwethatapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Rosampitanakeri Jesús, ikantziri: “Asheninká, ¿Iitaka pipokashitziri?” Rotaiyaitapaakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ikanta apaani tsipatakariri okaakiini Jesús, inowikyaanakero rosataamento, rithatzinkitakeri ikempita inoshikanewo reeware Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ari ikantanake Jesús: “Powero posataamento, ripiyaitzimikari. Tema ikaatzi thatzinkantatsiri, rithatzinkaitziri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Piyotzi eeroka, kantacha namañaari Ashitanari, ari rotyaantakeme osheki maninkariite kisawentenane. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Iroowa imonkaatantaiyaari okaatzi rosankenatakoitakenari pairani.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ripithokashitanakari Jesús ikaatzi pokashitakeriri, ikantziri: “¿Naakama koshintzi pamashitantanari powathaamento, pipasamento? ¿Tema piñaapiintawetana niyotaantzi tasorentsipankoki, kaari paantana? ");
INSERT INTO cpbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Arira imonkaatari okaatzi rosankenayetakeri pairani Kamantantaneri.” Ari rishiyayetanaka riyotaanewo, rookanawentaitanakeri Jesús apaniroini. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ikanta ragaitanakeri Jesús ipankoki Caifás, reewaperore Imperatasorentsitaarewo, ari ipiyotaiyakani maawoini Yotzinkariite itsipatakari Itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Noshikacha neetsikeroini Pedro royaatakowentakeri Jesús, irojatzi rareetantapaakari ipankoki reewaperore Imperatasorentsitaarewo. Kyaapaake pankotsiki itsipayetapaakari kempoyaantaneri, ikowi Pedro inkemakowenteri tsika inkantaiteri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ikanta reewarepaini Imperatasorentsitaarewo itsipatakari ikaatzi piyotainchari, raminawetaiyakani iita thaiyakotyaarine Jesús ompoñaantyaari ritsitokakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Te iñiimaita, ripokayewetaka osheki kowatsiri inthaiyakotyaarime. Irojatzi ikatziyantanakanari apite thaiyakotanakariri, ");
INSERT INTO cpbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ikantanake: “Nokemiri naaka chapinki ikenkithawaitzi ikantzi: ‘Ari nontzimpookakero tasorentsipanko, iro awisawetakya mawa kiteesheri, nithonkairo niwetsikairo.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ari ikatziyanaka reewaperore Imperatasorentsitaarewo, ikantanakeri Jesús: “¿Iitaka kaari pakanta? ¿Tema pikemiri okaatzi ikantakotakemiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Irojatzi imairetake, te raki. Ari ishintsineentanakeri, ikantziri: “Paakoteri iwairo Kañaaneri Pawa, niyotantyaari imaperorika onkaate pinkantenari. ¿Eerokama Cristo, Itomi Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Rakanake Jesús, ikantzi: “Irootake pikantakeri. Iroñaaka piñeeri Itomi Atziri risaikimotairi rakoperoki Pawa impinkatharitai. Piñeeri ripiyai inkenapai menkoriki.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ikanta ikemawake jewaperori, itzisagaanakero iithaare ikisanaka, ikantanake: “Piñaakero, raakowaitashitakari Pawa. Te ankowe itsipa kantakoterine. Pikemaiyakeni eeroka rithainkakeri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tsika pikantaiyinika eeroka?” Rakaiyanakeni, ikantaiyini: “¡Tzimataike iyenakaashitanewo! ¡Ontzimatye inkame!” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Irojatzi reewawootaitantanakariri. Itsipa kaposawootakeri. Itsipa pasawootakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rosampitzimaitari ikantziri: “Cristo, ¿tema Kamantantaneri pini, janjaatya pinkantena iita pasawaitzimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ari risaikake Pedro jakakeroki, irojatzi oñaantapaakari rimperaitari, okantapaakeri: “¿Tema eeroka itsipata pairani Jesús Galilea-satzi?” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Osheki ñaakeriri Pedro roipiyanakero, ikantanake: “Te, te niyotziri iita pikantanari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Shitowaneentanake Pedro jakakeroki. Oñaapairi otsipa rimperataitari, okantapaakeri itsipayetakari: “Irijatzira jirika itsipatari pairani Jesús Nazaret-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Rapiitanakero Pedro roipiyiro, ikantanake: “Apatziro riyotzi Pawa, te niyotziri naaka jirika atziri pikantanari.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tekera osamaniteeta, rapiitakeri ikaatzi itsipatakari ikantziri: “Eerokaga itsipatapiintari Jesús, Galilea-satzi pini, ariwaitakemi ikantziro riñaawaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ikantanakeri: “Té, te niyotziri jirika atziri pikantanari. Riyotzi Pawa nothaiyarika, rowasanketainaata.” Ari riñaanake tyaapa. ");
INSERT INTO cpbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ikenkithashiretanairo Pedro ikantakeriri Jesús: “Tekera riñeeta tyaapa, mawa poipiyero, pinkante: ‘Te niyotziri Jesús.’ ” Shitowanake Pedro, antawoite riraawaitanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Okanta okiteeshetamanai, piyotaiyakani reewarepaini Imperatasorentsitaarewo itsipayetakari Itzinkamipaini, ikamantawakaiyakani ritsitokeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Irojatzi roosoitantanakari Jesús, ragaitanakeri risaikira Poncio Pilato, jewaripero rini jirika. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ikanta Judas pithokashitantaneri, riyotanake rowamaakaantashitakari Jesús. Antawoite ikenkithashiretanaka, jatake roipiyainiri iyorikite reeware Imperatasorentsitaarewo, eejatzi Itzinkamipaini, ");
INSERT INTO cpbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ikantapairi: “Jirika piyorikite. Te okameethatzi okaatzi nantakeri. Tekaatsi rante Jesús naakaantashitakari.” Ikantaiyanakeni irirori: “Iitaanitya eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Romanatanakeri koriki janta tasorentsipankoki, rishiyaperotanakitya ripiyanaka, irojatzi rishirikantapaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ikanta reeware Imperatasorentsitaarewo, ragairi koriki, ikantaiyini: “Te ishinetaantsite ankempoyagairi koriki, tema iriitake apinatakeriri ritsitokantaityaariri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ari rosampitawakaiyani: “¿Tsika ankanterika jirika koriki?” Ikantaiyini: “Jame amanantantyaari tsirepathari kipatsi, tsika inkitaiteri arika inkamayete kaari asheninkata.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Irojatzi iroñaaka iitaitziro jiroka kipatsi: “Iraantsipatha”. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Irojatzi imonkaatantakari rosankenatakeri pairani Kamantantaneri Jeremías, ikantake: Ragaitakeri 30 ipewirya koriki, Ikowaiyakerini icharinepaini Israel ripinaiteri, ");
INSERT INTO cpbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iri ramanantaitantakawori tsirepathari kipatsi, Iro ikowakaakenari Pinkathari namanantero. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Areetaka Jesús risaikira reewaperori, rosampitawakeri, ikantziri: “¿Eeroka iwinkatharite Judá-ite?” Rakanake Jesús, ikantzi: “Irootake pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ikanta reeware Imperatasorentsitaarewo itsipayetakari Itzinkamipaini, osheki ithaiyakowetapaakari Jesús. Te rakimaita irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Irojatzi ikantantari Pilato: “¿Tema pikemi okaatzi ikantakoitzimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Irojatzi imairetake, te raki. Riyokitziiwentanakeri Pilato jirika Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tzimatsi rametapiintari reewaperori: Maawoini osarentsi arika roimoshirenkya Judá-ite, romishitowakaantzi apaani isheninka raakaantaitziri intzimerika inkoweri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eenitatsi itsipa Judá-ite raakaantaitziri iita Barrabás, ikemakoitanewo rini jirika rantakero koweenkatatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ikanta ipiyotaiyakani atziripaini, rosampitantake Pilato, ikantziri: “¿Iitaka pikowiri nomishitowakaanteri? ¿Iri Barrabás? ¿Iriima pikowiri Jesús iitaitziri Cristo?” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Riyotake Pilato ikisaneentashitaitari Jesús, iroowa raakaantaitantariri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tema inkaaganki, okantakaantakeri iina, okantake: “Eero pikoshekawaitari eeroka kameethashireri. Osheki romishimpyaakena tsireniriki ominthaawashiryaakena.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iri kantacha reeware Imperatasorentsitaarewo itsipatakari Itzinkamipaini, rowatsimaakeri atziripaini, ikantaiyini: “Iri kameethatatsi romishitowaiteri Barrabás, iriima Jesús ritsitokaiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Irojatzi rapiitantanakawori reewaperore rosampitantzi: “¿Iitaka pikowiri nomishitowakaantairi?” Ikantaiyini maawoini: “¡Barrabás!” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ikantzi Pilato: “¿Tsika nonkanterika Jesús iitaitziri Cristo?” Rakaiyini atziri: “¡Pinkentakotakaanteri!” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ikantzi reewaperore: “¿Eenitatsima kaariperori rantakeri?” Eeke ishintsitatzi ikaimaiyini atziripaini, ikantzi: “¡Pinkentakotakaanteri!” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ari riyotanake Pilato raminaashiwaita rosampitantzi, tema osheki iyatsimashirenka atziripaini. Ikaimakaantake ñaa, iñagaitakeri maawoini ikiwaakotanaka, ikantanake: “Te naaka kowatsine nitsitokakaanteri jirika kameethashireri. Pikowirika eerokapaini, piyotaiyeroni.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ikantaiyanakeni atziripaini: “Nokowaiyini, naaka rookoite oitarika awisaintsine eejatzi inkaate nocharinepaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Irojatzi romishitowakaantantaitaariri Barrabás. Iriima Jesús ripasatakaantaitanakeri, riyakowentaitakeri inkentakoiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ikanta owayeripaini, ikyaakaanakeri Jesús ipankoki Pilato iitaitziro “Pretorio”. Ari ipiyowentakari maawoini owayeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Raatonkoryagaitakeri Jesús, ikithaataitakeri kithaarentsi anashirikimawotatsiri oshiyawori ikithaatapiintari pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ramanthaitantaitakari kitocheetapo iitoki, rotaiyakagaitakeri rakoperoki sawookaaki. Irojatzi rotziwerowashitaitantanakari Jesús rithainkimawaitaitziri, ikantaiyini: “¡Paakameethatawakeri iwinkatharite Judá-ite!” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Osheki reewawoowaitakeri, romposayinawaitantari sawookaaki. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ikanta reshitakero ishirontawentawaitari. Raatonkoryagairi ikithaatakeriri inkaaganki, ikithaatairi iithaare, raanakeri inkentakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ikanta riyaataiyanakeni, ritonkyotakari Simón poñaachari Cirene, ishintsineentaitanakeri inatanakero inkentakotantaityaariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Irojatzi rareetantakari tonkaariki oita Gólgota (akantziro aaka: Atziriitoni.) ");
INSERT INTO cpbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ari ipakowetaitakari Jesús imere rowaitaitakero yepitentsi, ikanta ithowetawakawo eepichoki, te ririro. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Irojatzi ikentakotantaitakari. Ikanta owayeripaini raakero ikithaayetari Jesús, rowawisaawakaakawo, roshiyakaakero iñaaryaataita riyotantyaari iita ayerone. Ari imonkaatakari ikenkithatakotakeri pairani Kamantantaneri, ikantake: Iñaaryaawentaitakawo noithaare, Rowawisaawakaayetakawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ari risaikawentaiyirini, ikempoyiiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Irojatzi rosankenaitantakari kantakaantakerori ikentakoitantakariri, okantzi: JIRIKA JESÚS, IRIITAKE IWINKATHARITE JUDÁ-ITE. Rontarekakoitakeniri jeñokiini ipatziitoki. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ari itsipatagaitakeri ikentakoitziri apite koshintzi, ikatziyakotaka apaani rakoperoki, itsipa rampateki. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Rithainkimayetakeri ikaatzi awisayetatsiri janta, rotekayinata, ");
INSERT INTO cpbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ikantaitziri: “Eeroka tzimpookirori tasorentsipanko, iro awisake mawa kiteesheri piwetsikairo eejatzi. Eerokame Itomi Pawa ¿Oitaka kaari payiitanta ikentakoitakemira? Powawisaakotya.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Irojatzi ikantakeri eejatzi reeware Imperatasorentsitaarewo itsipayetakari Yotzinkariite, Fariseo-paini, eejatzi Itzinkamipaini, ikantaiyini: ");
INSERT INTO cpbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Rowawisaakotziri itsipa, ¿kaari rimatantawo rowawisaakotya irirori iriime iwinkatharite Israel-iite? Ari rowawisaakotakyaame ikentakoitakerira, aritake ankemisantakerime. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rawentaawetakari Pawa, janjaatya añeeri imaperorika retakotari ari rowawisaakotairi. Tema ikantapiintzi: ‘Naaka Itomi Pawa.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Rimatzitakawo koshintzipaini itsipatakari ikentakota, rithainkawaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ikanta itampatzikatapaake ooryaatsiri, omapokashitapaaka otsirenikitanake, irojatzi ishaawiiteeni ithaperotanakaga ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ari ikaimanake Jesús shintsiini, ikantanake: “¡Elí! ¡Elí! ¿Lama sabactani?” (Iro ikantaitziri apaanteki aaka: “¡Pawá! ¡Pawá! ¿Iitaka pookanawentantanari?”) ");
INSERT INTO cpbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ikanta saikawentakeriri, ikemawetawakari ikaimanake, ikantaiyini: “Pinkemeri, ikaimatziiri Elías.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Irojatzi rishiyantapaintari apaani, romitsitsiyaatapaintzi manthakintsi kepishaariki, rankowitakeniri sawoopankeki, rowaankakotakeniri ratsimiyaatawakeme. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ikantaiyini itsipa: “Añaawakeriita ari ripokake Elías rowayiitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Irojatzi rapiitantanakawo ikaimanai shintsiini, peyanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Okanta tasorentsipankoki, sagaanake niyanki tontamawotatsiri ithatashiitzirori, apimankite okantanaka, opoñaanaka jenoki areetaka isaawiki. Antawoite omoyekanaka tankayetanake mapi. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rithonka ripookakotanake kaminkari, osheki añaanaatsiri kameethashireri kamawetainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tema rañagaira Jesús, osheki añaayetaatsiri rishitowanairo omooki riyaayetai nampitsiki tasorentsitatsiri, roñaagayetantaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ikanta reeware owayeripaini itsipayetakari itsipa ikaatzi ikatziyawentakari Jesús, iñaakero omoyekanaka, iñaakero okaatzi awisayetaintsiri, antawoite ithaawanake, ikantanake: “¿Imaperowetyaama Itomintari Pawa jirika?” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eenitatsi janta tsinanepaini aminakotakeriri, irootake poñagainchari Galilea-ki oyaatziri Jesús, osheki amitakoyetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jiroka okaataiyini: María Magdala-sato, María inaanate Jacobo eejatzi José, ari isaikake eejatzi inaanate itomipaini Zebedeo. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Okanta otsireniityaanake, ari ripokakeri apaani ashaagantzinkari poñagainchari Arimatea, iita José. Irijatzi riyotaapiintakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Riyaatashitakeri Pilato, ikantapaakeri: “Pishinetenari nonkitatairi Jesús.” Ikanta Pilato ikantakaantake raanairi inkitatairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ikanta José iponatantakari Jesús kiteri manthakintsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Romonkyaakotakeri owakeranatzira imoontashiitziri kaminkaripaini shirantaaki, roipinaakaantake antawoite mapi, rashitakotantakari. Piyanaka José. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Okanta María Magdala-sato, eejatzi otsipa María, isaikawentakeri tsika ikitaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Okanta awisanake riwetsikawentaitawo kiteesheri rimakoryaantaitari, ari riyaatake reeware Imperatasorentsitaarewo itsipatakari Fariseo-paini janta ipankoki Pilato, ");
INSERT INTO cpbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ikantapaakeri: “Pinkatharí, chapinki eeni rañaaweta amatawitantzinkari, nokemiri ikantzi: ‘Arika nonkamawetakya, iro mawatapaintsi kiteesheri, aritake nañagai.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nokowi potyaante kempoyeerine irojatzi imonkaatantakyaari mawa kiteesheri. Aamaashitya ari riyaatake tsireniriki riyotaanewopaini, ragaateri. Inkantzimaitya: ‘¡Añagai Jesús!’ Arika rimatakero, ari owatsiperotya ramatawitante.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ikantanake Pilato: “Jirika owayeripaini, paanakeri, pinkanteri inkempoyeeri tsikarika okanta pikowiri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ari riyaataiyanakeni, rontsirekakoyetakeri omooki. Ari risaikawentaiyakerini. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Okanta awisanake kiteesheri rimakoryaantaitari, ari okiteeshetamanai etapiintawori kiteesheri. Ari iyaatamanai María Magdala-sato otsipatanakawo otsipa María aminairo jimpe ikitaitakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ari omoyekanakari shintsiini kipatsi, tema rayiitapaakitzi inkiteweri maninkariite rotainkapaakero mapi rashitantaweetakawori omoo, risaikantapaakawo. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Shipakirya ikantapaaka roshiyapaakawo ookathawontsi. Kitamaaniki okantaka iithaare oshiyawaitakawo okitamaatzi jiriniki. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ikanta owayeripaini aminiriri, iñaawakeri, antawo ithaawaiyanakeni, oshiyawaitanakawo inkamanakityeeme. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ikanta maninkariite, ikantanakero tsinanepaini: “Eero pithaawaiyini eeroka. Niyotake iri pipokashitzi Jesús ikentakoweetakari. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Te añiiri jaka, añagai. Tema ari ikantzitaka pairani. Pipoke, paminero tsika rowaweetakari Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pipiyanake, pinkamantayetairi riyotaanewopaini, pinkanteri: ‘Añagai Jesús, piyaatai Galilea-ki, ari piñaayetairiri.’ Tema nokamantakemi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Okanta ipiyaiyanakani iyokitzii okantaiyanakani. Iro kantacha antawoite okimoshiretanake, ishiyashitanakari riyotaanewo onkamantayetairi. Ishiyaminthaita iyaate onkamantante, ");
INSERT INTO cpbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ari roñaagaawo Jesús, riwethatawakawo. Iyaatashitanakeri okaakiini, otziwerowashitapaakari, awithakiyitzitapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Irojatzi ikantantanakawo Jesús: “Eero pithaawi, piyaate pinkamantayetairi nirentziyetaari, riyaataita Galilea-ki, ari iñaapaina.” ");
INSERT INTO cpbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Okanta ipiyaiyanakani tsinane onkamantante, jatanake eejatzi owayeripaini nampitsiki, ikamantapaakeri reeware Imperatasorentsitaarewo okaatzi awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ari ipiyotaiyanakani Itzinkamipaini, ikenkithawaitaiyanakeni. Ikaimakeri owayeri, ikantziri: “Jirika osheki nipinatemiri, ");
INSERT INTO cpbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pinkantayeteri atziripaini: ‘Niyankiiteki tsireniri, nimaanake. Aamaaka ari ripokaiyakeni riyotaanewo, raanairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Arika inkemake reeware, naakaga kantakowentemine eero rowasanketantzimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Rimatakero owayeripaini, raakeri ripinaitakeriri, rantakero okaatzi ikantaitakeriri. Iroowa rantetakari maawoini Judá-ite jiroka, irojatzi iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ikanta 11 riyotaanewo Jesús, jataiyakeni Galilea-ki isaikira otzishi ikantakeri pairani Jesús ari iñagairi. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ikanta iñaawairi, rotziwerowashitawaari. Iro kantacha tzimayetatsi kisoshirewentawairiri. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ikanta ikempiyapaari Jesús, ikantapairi: “Impinkathaperoitaina inkiteki eejatzi kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iro nonkantantemiri: Piyaate maawoiniki nampitsi, pinkemisantakaayetairi atziripaini, pithotyagairo maawoini. Arika inkemisantayetai, pomitsitsiyaayetairi, paakotairi iwairo Ashitairi, Itomi, eejatzi Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Piyotaayetairi atziripaini rimayetairo okaatzi nokamantayetakemiri. Ari nontsipatapiintaimi naaka, kisokero nowemi irojatzi paata ithonkantaiyaari kipatsi.” Ari onkantaitaatyeeyaani.");
INSERT INTO cpbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jiroka okanta opoñaantari Kameethari Ñaantsi kenkithatakotziriri Itomi Pawa, jitachari Jesucristo. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pairani eenitatsi Kamantantaneri iita Isaías. Rosankenatakotakeri Pawa ikamantziri Itomi, ikantziri: Notomí, ari notyaantake etyaawone kenkithatakotemine, Iri wetsikaantemine. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Richeraapaake ochempiki, inkantapaake: Powameethatainiri Awinkatharite tsika inkenapaake, Poshiyakaantero rotampatzikaitziro awotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ari okantaka, monkaataka ikenkithaitakeri. Ikenkithatake pairani Juan ochempiki, ikenkithatakotakero omitsitsiyaataantsi, ikantapaake: “Pomitsitsiyaawentaiyaari Awinkatharite, pookairo kaariperori, ari rariperotaimi pikaariperowetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Osheki pokashitakeriri Juan, Judea-satzi eejatzi Jerusalén-satzi. Ithawetakotapaakero iyaariperoshirenka, irojatzi romitsitsiyaatantawakariri ñaaki Jordán. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ikithaatari Juan rontyagaitziro iwitzi camello. Romathakitari mashitsimashi. Rowayetari maapataki, ririri iyaa pitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jiroka ikantake Juan ikenkithatzi: “Kaakitake maperotzirori ipinkatharentsitzi, nopinkathatzitari naaka. Te onkantaatsikaitya roshiyakaina rimperatanewo noiyotashitantyaariri no-zapato-reeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iri omitsitsiyaatantairine Tasorenkantsi. Irooma naaka nomitsitsiyaatantashimatsitawo ñaa.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ikanta ripokake Jesús ipoñaakawo nampitsiki Nazaret saikatsiri Galilea. Romitsitsiyaatawakeri Juan antawaaki ñaa Jordán. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iro ritonkaantanaiyaarime Jesús, oshiyanakawo ashitaryaanakityeeyaame inkite, iñaawakeri rishaawiinkashitapaakeri Tasorenkantsi ikenapaake jenoki roshiyapaakari shiro. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ikemaitatzi jenoki ikantaitanake: “Osheki nokimoshirewentakemi Notomí, eerokaga netakokitane.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ikantakaanakari Jesús Tasorenkantsi, jatanake ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ari ikowawetaka Satanás inkaariperotakairime. Tema osheki kiteesheri risaikake itzimira atsikantaneri, okaatzi 40 kiteesheri. Irojatzi ripokantapaakari maninkariite ramitakotapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ikanta ikenanake Jesús Galilea-ki inkamantantero Kameethari Ñaantsi kenkithatakotziriri Pawa tsika ikanta ipinkathariwentantzi. Arira romonkyagaitakeri Juan irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ikantapaake Jesús, ikamantantzi: “Monkaatapaakaga iñagaitantyaariri Pawa impinkathariwentante, pinkemisantairo Kameethari Ñaantsi. Pookairo pikaariperowaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Okanta otsipa kiteesheri ikenanake Jesús inkaarecheraaki Galilea, iñaapaatziiri jitachari Simón itsipatakari irirentzi Andrés itarajaataiyini. Tema tarajaawairentzi rini. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ikantapaakeri: “Poyaatena, oshiyaiyaawo iriime atziripaini nontarajaatakagaimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Royaatanakeri, rookanakero itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iro ranashineentanaka, iñaapaatziiri itomipaini Zebedeo jitachari Jacobo itsipatakari irirentzi Juan, risaiki ipitoki rowamatankawaitzi itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Raanakeri eejatzi. Eeniro risaikanake ipaapate itsipatanaari ratzirite. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ari rareetaiyakani Jesús nampitsiki Capernaum. Okanta kiteesheri rimakoryaantaitari, riyotaantapaake ipiyotaitapiintaga. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te imana ishintsinka riyotaantzira, ranaanakeri Yotzinkaripaini, antawoite riyokitziiwentaitanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ari risaikake atziri raayiri peyari, kaimanake irirori, ");
INSERT INTO cpbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ikantzi: “Jesús, Nazaret-satzi, niyotzimi naaka, eerokatake itasorentsite Pawa. Iro pipokantari jaka pithonkaiyenani.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ikantanakeri Jesús: “¡Pisantzikote peyari! ¡Piyaatai!” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ikaimanake antawoite atziri, rompetatakaawaitanakari iweyarite, rookanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ikantawakaanaka atziripaini: “Pamineri jirika, rowawisaakotziri raayiri peyari.” Riyokitziiwentaperoitanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Intsipaite ikemakoitanakeri Jesús Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ikanta rishitowanai Jesús ipiyotaitapiintaga, itsipatanakari Juan eejatzi Jacobo, ikenaiyanakeni ipankoki Simón, risaikira eejatzi Andrés irirentzi Simón. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Iro rareetapaakityaani, ikantaitawakeri: “Okatsiiwaitatzi riyote Simón.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ripithokashitanakawo, rotaiyawakotakero, roisaikakero. Etsiyatanake oyatsiirentsite. Piriintanaka aminanake oita ompawakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Okanta otsireniityaanake, ramaitapaakeniri Jesús osheki mantsiyari, ramaitapaakeniri eejatzi raaganewo peyari. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ipiyotaiwentapaakari pankotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Retsiyatakotakaayetairi maawoini. Te rishinetanairi riñaawaitanai peyari, retsiyatakotakagairira ikaatzi raagayetziri. Tema riyotzi peyari tsika iita Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Okanta okiteeshetzimatake, ananinkanake Jesús ramana ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ikanta Simón itsipatakari ikaatzi royaataiyirini, rithotyaakotairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ikanta iñaapairi, ikantapairi: “Yotaanarí, rithotyaakoitatziimira.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Rakanake irirori ikantzi: “Jame aate, te iro nipokantyaari nisaike jaka, ontzimatye niyotaante otsipaki nampitsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ari okantaka, rithonkakero Jesús ranashitawo Galilea, riyotaantake maawoiniki nampitsi ipiyotaitapiintaga, retsiyatakotakaake osheki raaganewo peyari. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ikanta ripokake imatane pathaawontsi, rotziwerowashitapaakari Jesús, ikantapaakeri: “Pikowirika petsiyatakotakagaina, niyotzi tzimatsi pishintsinka petsiyatakotakaantantenari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Raminanakeri Jesús, retakoshiryaanakari. Riterotantakari rako, ikantanakeri: “¡Nokowi, petsiyatakotai!” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Etsiyatakotanake ripathaawaiweta. ");
INSERT INTO cpbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ikantawetawaari riyaataira inampiki, ");
INSERT INTO cpbNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ikantziri: “Eero pithawetakotana. Tampatzika powanairo piyaatashiteri Imperatasorentsitaari, pimonkaatairo Inintakaantakeri pairani Moisés-ni, paanake pinkitewathatantaiyaari, iro riyotantaityaari etsiyatakotaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ikanta pathaawaiwetachari, ithawetanake nampitsiki tsika ikanta retsiyatakotantaari. Iroowa kaari risaikantanaa Jesús nampitsiki. Jatake ochempiki, ari risaiki. Ari riyaatashitziri osheki atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Awisake otsipa kiteesheri, eejatzi ripiyaawo Jesús nampitsiki Capernaum. Ikemaiyawaini atziri, ikantaitzi: “Areetaawo Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ipiyowentaitawaari, te rimonkaatapaakawo pankotsi. Riyotaayetapairi maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eenitatsi atziri ikaatzi 4 pokashitakeriri Jesús inatakotakeri kisopookiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te onkantya iñeeri, rotzikaakeri osheki atziri piyotainchari. Rateetashitakeri jenoki pankotsiki, imoontashitakeri ikatziyakaga Jesús, rowayiitakotakeri mantsiyari. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ikanta Jesús, riyotakotawakeri rawentaatyaari, riñaanatawakeri mantsiyari, ikantziri: “Notomí, rariperoitaimi pikaariperowetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kemaiyawakeni Yotzinkaripaini, ikantashiretanake irirori: ");
INSERT INTO cpbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Rithainkakeri Pawa jirika. Tema tekaatsi peyakotanterone kaariperori, apatziro ikantakaawo Pawa ipeyakotantziro.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Riyotake Jesús ikenkithashiryaari, irojatzi rosampitantanakari, ikantziri: “¿Iitaka pikenkithashiryaantawori jiroka? ");
INSERT INTO cpbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tema inimotemi nonkanteri kisopookiri: ‘Rariperoitaimi pikaariperowetakaga?’ ¿Iro pikowi nonkanteri: ‘Pinkatziye, paanairo pomaryaamento, piyaatai?’ ");
INSERT INTO cpbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iroñaaka piñeeri Itomi Atziri osheki ishintsinka, rariperotairi kaariperoshireri.” Ripithokashitanakari kisopookiri, ikantanakeri: ");
INSERT INTO cpbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“¡Pinkatziye! Paanairo pomaryaamento. Piyaatai.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Katziyanaka mantsiyari, raanairo romaryaantari, shitowanake. Maawoini atziri iñaawairi. Riyokitziiwentanakeri iñaakerira. Ikimoshirewentanakeri Pawa, ikantzi: “Imapero okameethatzi jiroka. Te añaapiintziro oshiyaawone.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ikanta rapiitapairo Jesús riyotaapairi atziri inkaarecheraaki. Ari ipiyowentaitawaari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ikanta rithonkanakero riyotaantzi, awisanake. Irojatzi iñaantapaakariri itomi Alfeo jitachari Leví, risaiki rapatotziri koriki. Ikantapaakeri: “¡Poyaatena!” Katziyanaka, royaatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ikanta Leví raanakeri Jesús rowakayaari ipankoki. Ari riyaatzitanakari riyotaanewo, itsipatapaakari apatotziriri koriki, itsipatapaakari eejatzi kaariperoshireri. Osheki piyotainchari rowaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ikanta Fariseo-paini itsipatakari Yotzinkaripaini, rosampitakeri riyotaanewo Jesús, ikantziri: “¿Iitaka itsipatantariri iyotaimiri kaariperoshireri, itsipatakari eejatzi apatotziriri koriki?” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ari rakanake Jesús, ikantanake: “Arika imantsiyate atziri ripokashitziri aawintantzinkari, iriima kaari mantsiyatatsine tekaatsi inkowe irirori. Tera iri nipokashite kameethashireri, tema nipokashitatziiri kaariperoshireri nonkaimashireyetairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tzimatsi pokashitakeriri Jesús, rosampitapaakeri ikantziri: “Ritziwentapiinta riyotaanewo Juan, ari ikantaiyani riyotaanewo Fariseo-paini. ¿Iitaka kaari ritziwentanta piyotaanewo eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Rakanakeri Jesús, ikantziri: “Arika intsipataityaari aawakainkari, ¿Arima rowashiretaitakya? Eero rowashiretaita, kimoshire inkantya rowawaitya. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Irooma paata, arika ragaitakeri iimentaitari, aripaite ritziwentaitya. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Arikame rowamatankaitantyaawo owakerasaperi antyashipawo kithaarentsi, ari isagaaperotanake amithatanakyaarika owakerasaperi. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iro kameethatatsi apiyaatantyaawo eeryaari riraitziri owakerari mashitsinaki. Irooma apiyaatantashitakyaaworika antyashipari mashitsinaki, ari itankakotanake, apitepaini eewanawaitashitakya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Okanta kiteesheri rimakoryaantaitari, ikenanake Jesús pankirentsimashiki. Ari rowiikitanake riyotaanewo okithoki pankirentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te inimoteri Fariseo-paini, rosampitakeri Jesús, ikantziri: “¿Iitaka rowiikitantawori pankirentsi piyotaanewo? ¿Tema riyotzi te ishinetaantsite kiteesheriki rimakoryaantaitari?” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Rakanake Jesús ikantzi: “¿Tema piñaanatakotziri ikantakota David itsipatari ikaataiyinira aantawetakariri ritashe? ");
INSERT INTO cpbNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ikyaake tasorentsipankoki reewaritzira Abiatar, rowakawo owanawontsi tasorentsitatsiri, ipakeri itsipayetakari. Te ishinetaantsiweta, inta rowapiintawo Imperatasorentsitanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Eekero ikantatzi Jesús: “Iriira atziri kantakaawori riwetsikantaitakawori kiteesheri rimakoryaantaitari. Kaarira kiteesheri rimakoryaantaitari kantakayaawone riwetsikantaitariri atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jirika Itomi Atziri ipinkathariperotzi irirori, ranairo jiroka kiteesheri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ikanta ikyaapai Jesús ipiyotaitapiintaga. Ari risaikake atziri kisoimpekiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ikowaitatzi iñagaiteri retsiyatakotakagaiteri mantsiyari kiteesheriki rimakoryaantaitari. Aamaako rowaitakeri inkantakoitantyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ikanta Jesús ikaimakeri mantsiyari, ikantziri: “Pipokeeta, posatekya niyanki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Rosampitakeri piyotainchari, ikantziri: “¿Oitaka shinetaantsitatsiri anteri kiteesheriki rimakoryaantaitari? ¿Tema onkantya aneshironkatante, irooma kameethatatsi owamaante? ¿Tema onkantya antero kameethari, irooma kameethatatsi ankaariperowaite?” Tekaatsi akatsine. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Raminanakeri Jesús piyowentakariri, owatsimaashiretanakeri iñaakerira te ineshironkatante, ikantanakeri mantsiyari: “¡Pampiryaawakotai!” Matanaka, akotsitanai kameetha atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ikanta Fariseo-paini, jatanake ikenkithawaitakairi akiriri Herodes raminakero tsika inkantero ritsitokakaantantyaariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ikanta rishitowanake Jesús, ikenanai inkaarecheraaki itsipatanaari riyotaanewo. Kisokero rowanakeri Galilea-satzi, Judea-satzi, ");
INSERT INTO cpbNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén-satzi, Idumea-satzi, maawoini nampitawori intatsikeronta antawaaki ñaa Jordán. Ikemakotakeri eejatzi Tiro-satzi, Sidón-satzi, ikantaitzi: “Osheki ritasonkawentantake Jesús, roñaagantake osheki kaari iñagaitapiintzi.” Pokaiyanakeni ramineri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iro ikantantanakariri Jesús riyotaanewo rithotyaakoteniri pitotsi, eero ranawyaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Rimatakero Jesús, retsiyatakotakaantake. Otatsinkawirinikyaatanaka mantsiyari ikowi riterotantyaari rako. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ripokayetzi raaganewo peyari, rotziwerowashitari Jesús, antawoite ikaimi, ikantzi: “¡Eeroka Itomi Pawa, niyotzimi naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eero riyotzitantaitari Jesús, ishintsineentanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ikanta ritonkaanake Jesús ochempiki. Ari ikaimakaantakeri wetsikimotariri. Jataiyakeni ikaatzi ikaimakaantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ari riyoyaake intsipatapiintyaari ikaatzi 12, iriira rotyaantakeri inkenkithatakaante. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ripasawyaakeri retsiyatakotakaayetairi mantsiyari, eejatzi raagayetziri peyari. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jirika ikaatzi riyoyaakeri: Simón, iitakeri Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Eejatzi Jacobo itomi Zebedeo itsipataakeri Juan, irijatzi rowawiiroki Jacobo. Iitakeri “Boanerges”, (akantziri apaanteki aaka: “Otomi ookathawontsi”). ");
INSERT INTO cpbNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Eejatzi Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo itomi Alfeo, Tadeo, eejatzi Simón jitachari “Jokaakotantaneri”, ");
INSERT INTO cpbNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","eejatzi Judas Iscariote, iri pithokashityaarine paata. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ikanta rareetawo Jesús pankotsiki. Ari ipiyowentawaari osheki atziri, te inkantaiya riyaatapainte rowaiya Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tzimatsi kantatsiri: “Shinkiwentaka Jesús.” Iro ripokantawetakari isheninkathori, raanairime. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Areetapaaka Yotzinkaripaini ipoñaakawo Jerusalén-ki, ikantapaake irirori: “Jirika atziri ripasawyaatziiri ashitariri peyari jitachari ‘Beelzebú’, iro retsiyatakotakaantariri raaganewo peyari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ikanta ikemake Jesús, rapatotakeri, roshiyakaawentatziiniri, ikantziri: “¿Tzimatsima peyari kaminaawakaachari eero raagantanta? ");
INSERT INTO cpbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Arika romanatawakaiya inampiki atziri, ari rookanawentawakaakya. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Arika romanatawakaiya ipankoki atziri, ari iñaakero rookanawentawakaiya. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ari ikantari eejatzi peyari arikame romanatawakaiya, ari rookanawentawakaakya, eero iñaaperota, ari rithonkyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atziri ñaaperotachari kameetha, tekaatsi kanterine inkyaashiteri rayiteri oitarika tzimatsiri ipankoki. Irooma arika roosotaitakeri, atake rimataitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pinkeme nonkante: Ari rariperotairi Pawa kaariperotatsiri, onkantawetakya inkishimawaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iriima kishimatziriri Tasorenkantsi, rashi rowatyeero, eero rariperoitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iro ikantantakari Jesús, tema ikantaitatziiri: “Kamaari rini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Areetapaaka iriniro Jesús otsipatakari irirentzipaini, okaimakaantapaakeri, okatziyapaaka jakakeroki. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ikantawetakari ikaatzi piyowentakariri: “Ari ipoki piniro otsipatakari pirentzipaini, okowi oñeemi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ikantanake Jesús: “¿Iitaka pikenkithashiryaari iroowa nonaanate, iriira nirentzitari?” ");
INSERT INTO cpbNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Raminanakeri piyotainchari, ikantzi: “Jirikapaini, iri noshiyakagairi yeeyepaini, irojatzi noshiyakagairi naana. ");
INSERT INTO cpbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ikaatzi antanairori ikowiri Pawa, iriira nirentzitari, iro nitsirotari, irojatzi ninirotari eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ikanta ripiyanaa Jesús inkaarecheraaki, riyotaantapai. Ipiyowentaitawaari. Otetanaka pitotsiki, risaikakotake niyankyeeronkaini, katziyaiyakani atziri ocheraaki ikemisantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Okaatzi riyotaayetziriri, roshiyakaawentatziiniri, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Jatake pankiwairentzi, impankiwaite. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ikanta rookakitakero iwankire, tzimatsi jokakitapainchari awotsiki. Ari rayiitaiyapaakeni owawori. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tzimatsi otsipa jokakitapainchari omapipookitzi. Intsipaite ishookawetanaka. Tekaatsiperowa kipatsi, ");
INSERT INTO cpbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","sampishitanake pankirentsi ooryaanakera. Tema te onkyaaperote oparitha inthomoiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tzimatsi otsipa jokakitapainchari kitocheemashiki, anaanakero iroori ishookanake. Te okithokitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tzimatsi otsipa jokakitapainchari okameethapathatzira kipatsi, saankana ishookanake, kithokitanake maawoini. Tzimayetai okithoki apaanipaini okaatzi shookayetanaintsiri. Apaani shookapaintsiri, eepiyokiini okithokitanake, otsipa shekipiyokitanaintsiri, otsipa shekichonchoitanaintsiri okithoki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eekero ikantanakitzi Jesús: “Kowatsiri inkemathatero, rowayempitatya inkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ari riyaataiyanaini maawoini atziri, apa risaikanai Jesús itsipatanaari oyaatapiintziriri, eejatzi riyotaanewo ikaatzi 12. Ari rosampitakeri Jesús, ikantziri: “¿Tsika okantakotaka okaatzi poshiyakaawentakeri inkaaganki?” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Rakanakeri Jesús, ikantzi: “Iroñaaka nonkamantemiro kaari piyotakoweta, ari piyotairo jimpe ikanta Pawa ipinkathariwentantzi. Iriima itsipapaini, eero nokamantzitari, apa noshiyakaawenteniri, ");
INSERT INTO cpbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","eero riyotakotantawo ikemawetari. Onkantawetya inkemisante, eero ikemathatziro, eero rowakerashiretai irirori, tema eero rariperoitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ikanta Jesús rosampitakeri, ikantziri: “¿Tema piyotawakero noshiyakaawentakeri? Arika napiitakemiro noshiyakaawentemiro, ¿tsika onkantyaaka piyotantyaawori? ");
INSERT INTO cpbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jirika atziri jokakitakerori iwankire, iri roshiyakaawentaitzi kenkithatakotzirori riñaane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Eenitatsi kemawetawori ñaantsi, ripokapaake Satanás, imaisantakaapaakeri. Iri oshiyakaawentakeri jokakitapainchari awotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Eenitatsi kemawetawori ñaantsi, intsipaite ikemisantaweta. Roshiyakotakawo jokakitapainchari omapipookitzira, intsipaite ishookawetanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tera riyoperotatyeero ñaantsi, te inkisashityaawo rowasanketaitziri ikemisantawetawowa ñaantsi, rowashaantanakero. Roshiyakawo pankirentsi sampishitanaintsiri, te onkyaaperote oparitha inthomoiki kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Eenitatsi itsipa kemawetawori ñaantsi, oshiyakaawentakeri jokakitapainchari kitocheemashiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Okantakaantziro ramatawiwaita apaniroini, ikenkithashiryaakotawo rashaagantya, iro ikowaperotake ontzimimotairi maawoini. Awisanakero ñaantsi ikemawetakari, roshiyakawo pankirentsi kaari kithokitatsine. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eenitatsi kemawakerori ñaantsi, oshiyakaawentakeri jokakitapainchari okameethapathatzira kipatsi. Ikemisantanai, roshiyakawo apaani shookapaintsiri, tzimanaintsiri eepiyokiini okithoki, otsipa shekipiyokineentanaintsiri, otsipa shekichonchoitanaintsiri okithoki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ari ikantanake eejatzi: “Ankowerika oorentakotya, ¿arima ashitakotakeri oorentamento? ¿Owakotzirima otapinaki? Tera. Akowatzi onkoñaate maawoini onkene aminawaite. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ari onkantaiya eejatzi, onkoñaatakoyetai manakowetainchari, ooñaawontairo kaari ikemathaitzi pairani. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kowirori ikemathatairo, inkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ikantanakeri eejatzi: “Paamagaiyaawo okaatzi pikemakeri. Otzimikari pantzimotantane, rimaperoitaimikari paata eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ikaatzi oshekitzimotziri oitarika, eekerowa oshekitzimotatyeeri. Iriima kaari oshekitzimotzi oitarika, eekerowa riyaatatye eero oshekitzimotziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ikantanake eejatzi Jesús: “Arika impinkathariwentantai Pawa, roshiyari pankiwairentzi, ");
INSERT INTO cpbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","rimayi tsireniriki, inkakitamanai. Te riyote tsika okanta rishookantari iwankire. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Apaniroini rishooki, riyothowatanake oryaani oshi, ripowainkaryaanake, patanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Arika risampatake, monkaataka rowiitaiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ikantanake eejatzi Jesús: “¿Iitaka oshiyari ipinkathariwentantai Pawa? ¿Iitaka noshiyakaawentemiri? ");
INSERT INTO cpbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oshiyatyaawo arika ampankitero okithokyaaniki pankirentsi. Onkantawetya oryaaniinitzi, ");
INSERT INTO cpbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","arika ampankitakero, ishookanake, anaanakero otsipa pankirentsi, antawotewatanake, ari imenkoshityaari tsimeryaani itsimankatapishitzira.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rashi rowapiintziro Jesús roshiyakaawentziniri atziri okaatzi riyotairiri. Eepichokiinirika inkemathatawakero atziri, eepichokiini riyotairi. Inkemathaterorika, osheki riyotairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ikaatzi ikenkithatakairi Jesús roshiyakaawentatziiniri, te rooñaawontziniri. Iriima riyotaanewo, ikemathatakairi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Okanta otsireniityaanake, ikantanairi riyotaanewo: “Jame amontyagai intatsikeronta.” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Irojatzi riyaatantanaari maawoini piyowentariri. Risaikitaka ketziroini irirori pitotsiki, montyaakotaiyanaani. Tzimatsi oyaatanakeriri ikenakotanake otsipaki pitotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ari omapokakeri antawo tampyaa, otamakaatanake antawoite, okitaaganakero pitotsi, irootaintsi ritsitsiyakoteme. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ikaakaitanakeri rimayira opataki pitotsi, rotziitotaka, ikantaitziri: “Yotaanarí ¡Atsitsiyakotatyé!” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Piriintanaka Jesús, riñaanatanakero tampyaa, ikantziro: “¡Ataama pitampyaatake!” Ikantzitanakawo inkaare: “¡Pimairyaate!” Awisanake otampyaatzi, mairyaatanai inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ikantziri riyotaanewo: “¿Iitaka pithaawantari? ¿Tema pawentaari Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Osheki ipinkathatanakeri, ikantawakagaiyani ithaawankakiini: “¿Tsikama iitaka jirika romairyaatantawori tampyaa, romairyaatzitawo eejatzi inkaare?” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rareetaka Jesús intatsikero inkaare, inampiki Gadara-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iro raatakotapaakitziini, rishiyashitawakari raayiri peyari ipoñaakawo kitataarewoki, ");
INSERT INTO cpbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ari risaikawaitzi irirori. Te raawyaitziri roosotantaitari kotsirotha. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Itzimpeshiro roosotantaitari iitziki eejatzi rakoki. Tekaatsi otsinampairine. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rashi rowiro kiteesheriki eejatzi tsireniriki, ikenayetzi ochempiki, kitataarewoki, ikaimawaitzi, itowaitakeri mapisheta. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ikanta iñaawakeri ripokake Jesús, rishiyashitawakari, rotziwerowashitawakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Antawoite ikaimapaake, ikantzi: “¡Jesús, Itomi Pawapero, te nokowi powashironkaina! ¿Tsikama pinkantenaka?” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tema rotyaantapaakitziiri Jesús, ikantapaakeri: “¡Peyarí, piyaate!” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ari rosampitanakeri: “¿Tsika piitaka?” Ari rakanake peyari, ikantzi: “Noita ‘Shekiyantzi’, osheki nokantaiyani.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eekero ikantanakitzi peyari: “Te nokowi potyaantena otsipaki nampitsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ari ipiyotaka tyonkaarikiini osheki chancho roshimotokawaitaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ikantaiyini peyari: “Potyaantena chanchoki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ikantanakeri Jesús: “Pimatero piyaate.” Shiyanaka chancho impeetaki, mitaapaake inkaareki, thonkaka ripiinkake. Ikaatzi 2000 chancho. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Thaawaiyanakeni kempoyiiriri chancho, shiyanaka, thawetapaake nampitsiki, ikamantanakeri maawoini saikatsiri rowaneki. Pokanake maawoini raminero awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Riyaatashitaitanakeri Jesús, iñagaitapaatziiri raaganewo peyari. Risaikake, ikithaataawo, kameetha ikantanaa. Ithaawantapaakari iñagaitapaakerira. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ikaatzi ñaakeriri inkaaganki ikamantawakeri pokayetaintsiri, ikantziri: “Pamineri jirika, iriira Jesús etsiyatakotakagairiri. Rowiinkake osheki chancho.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ikantaitanakeri Jesús: “Piyaatai, te nokowi pisaikimotena.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Irojatzi rotetantanaari Jesús pitotsiki. Ikantawetawaari retsiyatakotakaanewo: “Nokowi paanaina naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Rakanake Jesús, ikantziri: “Eero nayimi, piyaatai pisheninkaki. Pinkamantapairi pinkanteri: ‘Ineshironkataana Pinkathari, retsiyatakotakagaana.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ikanta raagawetari peyari, jatai inampiki jitachari Decápolis, ikamantapairi maawoini atziri, ikantapairi: “Retsiyatakotakagaana Jesús.” Riyokitziiwentaitakeri ikemaitzirira ikamantantzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ikanta ripiyaawo Jesús ipoñagaawo intatsikero. Ipiyowentawaari osheki atziri inkaarecheraaki. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ari rareetapaaka jitachari Jairo jewatatsiri ipiyotaitapiintaga. Iñaapaakerira Jesús, rotziwerowashitapaakari, ");
INSERT INTO cpbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ikantapaakeri: “Onkamatye nishintyo. Nokowi piyaate piterotantaiyaawo pako, etsiyatakotaita.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Irojatzi riyaatantanaka Jesús, ari royaatanakeri osheki atziri, ranawiimatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Okanta tsinane osokaawaitachari, tzimakotake 12 osarentsi omantsiyawaitake, ");
INSERT INTO cpbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","osheki raawintaweetakawo, ithonkakero owaagawo ipinawentawo. Aminaashiwaitaka, eekero iyaatatzi omantsiyatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Okemake iroori ikenkithatakoitziri Jesús, ikantaitzi: “Etsiyatakotakaantaneri rinatzi Jesús.” Osatekantanakari atziri okenashitanakeri itaapiiki, iterotzitakeri iithaare. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Okantashiretanake iroori: “Arika niterotzitakeri iithaare, ari netsiyatakotai.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Apathakerotanaka etsiyatakotanake osokaawaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Riyotzitanaka Jesús eenitatsi etsiyatakotakaantakeri ishintsinka, rosampitanakeri oyaayetakeriri, ikantziri: “¿Iitaka terotzitakenawori noithaare?” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rakanakeri riyotaanewo, ikantzi: “¿Tema piñiiri ranawiimatakemira atziri? Eekero pikantatzi: ‘¿Iitaka terotzitakenawori noithaare?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eekero raminanakitzi Jesús, iñaantyaariri terotzitakeriri iithaare. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Okanta tsinaneka othaawantanakari Jesús, ompetawaitanaka. Tema iro retsiyatakotakaake. Iyaatashitanakeri, otziwerowashitapaakari, othawetakotapaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ikantanakero irirori: “Nishintó, etsiyatakotakagaimi pawentaane, kimoshire pinkantanaiya piyaatai, tema etsiyatakotaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tekera inkaateroota Jesús riñaanatziro, ritonkyotawakari poñagainchari ipankoki Jairo. Ikantapaakeri: “Kamakera pishinto. Eero poñaashirenkiri iyotaantaneri” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ikanta ikemawakera Jesús ikantaitapaakeri, ikantanakeri Jairo: “Eero powashireta, pinkimoshirewentena naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tekaatsi inkowe oyaaterine. Apatziro raanakeri Pedro, Jacobo, Juan irirentzi Jacobo. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ikanta riyaatake, areetaka ipankoki Jairo. Iñaapaakitziiri rakisheenkatake atziri riraakoiyawoni kaminkawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kyaapaake Jesús, ikantapaakeri: “¿Iitaka piraantaiyarini? Te okami, imakoryaatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Thainkashire rowaitakeri Jesús. Romishitowapaakeri maawoini. Apatziro risaikanake ashitawori, eejatzi riyotaanewo. Ikyaashitanakero romaryagaitakerowa eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rotaiyawakotapaakero, riñaanatapaakero, ikantziro: “¡Talita cumi!” (akantziri apaanteki aaka: “Eentsi, pimpiriinte.”) ");
INSERT INTO cpbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Piriintanaawo eentsi, anashitanaawo. Tema tzimake 12 osarentsite, irootake anashiwaitantanaari. Riyokitziiwentanakero ikaatzi ñaakerori. ");
INSERT INTO cpbNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ikantzi Jesús: “Pimpero owanawo.” Ikantanake eejatzi: “Te nokowi pinkamanteri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ikanta ripiyaawo Jesús inampiki, royaatairi maawoini riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Okanta kiteesheri rimakoryaantaitari, riyotaantake Jesús ipiyotaitapiintaga. Riyokitziiwentaitakeri. Ikantaitzi ikemaitzirira: “¿Tsika ipookamatsitawoka riyomatsitantari? ¿Iitaka yotaakeriri rantantawori kaari iñaapiintaitzi? ");
INSERT INTO cpbNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Kaarima jirika kisaatapiintzirori inchakota? ¿Kaarima otomi María? ¿Kaari irirentzipaini Jacobo, José, Judas eejatzi Simón? ¿Kaarima iritsiro tsipatakairi anampiki?” Ari opoñaawo kaari ikemisantantaitari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ikantanake Jesús: “Rashi rowiro Kamantantaneri ikemisantaitziri otsipaki nampitsi, te ikemisantaitziri inampiki irirori risaikira isheninkapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iro kaari okantanta rooñaawontero Jesús ishintsinka inampiki. Te ishenitzi mantsiyari retsiyatakotakairi riterotantyaari rako. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Antawo rowashiretakotakari kisoshirewaitatsiri, kaari kowatsine inkemisante. Iroowa riyaatantanakari riyotaantzi otsipaki nampitsi tzimayetatsiri janta. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ikanta Jesús ipiyotakeri riyotaanewo ikaatzi 12. Ripasawyaakeri ishintsinka, raawyaantyaariri irirori peyari. Rotyaantakeri, intsipatawakaanakya apitepaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ikantakeri: “Eerowa paanake pithaate, powanawo, piyorikite, apatziro paanake pikotzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Eero paanake otsipa piithaare. Apatziro pizapato-tetanakya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ikantawakeri eejatzi: “Pareetakyaarika pankotsiki arira pimaapiinte, irojatzi pawisantanakyaari otsipaki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eerorika raapatziyaitawakemi, eerorika ikemisantaitzimi, pawisapithateri. Potekanairo piipatsite piitziki, iro riyotantaityaari te ikemisantaitziri Pawa. Iri rimaperoite rowasanketaiteri paata, anaanakero rowasanketaitakeri pairani Sodoma-satzi eejatzi Gomorra-satzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ikanta riyaatanake riyotaanewo Jesús ikantakeri atziripaini rookairo ikaariperowaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Retsiyatakotakaake raayiri peyari, retsiyatakotakaake osheki mantsiyari ritziritantari oyeenka pankirentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Areetakotakari pinkathari Herodes okaatzi rantakeri Jesús. Ikantaitzi: “Añagai Juan omitsitsiyaatantaneri. Piñeeri otzimi ishintsinka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tzimatsi itsipa kantaintsiri: “Elías rini.” Ikantaitzi eejatzi: “Aamaaka iri itsipa Kamantantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ikemake Herodes ikantaitakeri, ikantanake irirori: “Iri añagaatsiri Juan nithatzinkakaantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ipoñaantari ketziroini Herodes romonkyaakaantziri Juan, okantakaantziri Herodías, iinantawetari Felipe irirentzi Herodes. Iroowa iinantaari irirori Herodes. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tema ikaminaawetatyaari Juan, ikantziri Herodes: “Te onkameethate payiteri iina pirentzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Iro opoñaantari okisaneentziri Herodías, okowake owamaakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Iro romonkyaantakariri ketziroini Herodes. Iri kantacha Herodes antawoite ipinkathatakeri Juan, riyotzi kameethashire rinatzi, kiteshire ikanta. Te rishinewetari rowamagaiteri. Okaatzi ikaminaawetariri, ikompitzimotakari Herodes. Ari reshiwentawetawo ikemisantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Okanta otsipa kiteesheri, roimoshirenkawentawo Herodes itzimantakari pairani. Ripokaiyakeni iwinkatharentsite, ripokake reeware owayeripaini Roma-satzi, ripokake Itzinkamipaini Galilea-satzi. Rowaiyakani. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ari okyaapaake ishinto Herodías rowaiyanira, omampayimotapaakari, okameethatzimotanakeri Herodes omampaane, okameethatzimotanakeri eejatzi itsipatakari rowaiyani. Ikantanakero Herodes: “Ari nompakemi oitarika pinkowakotenari. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eero namatawitzimi, riyotzi Pawa imaperotatya nokantzi. Iroorika pinkoweri nopinkathariwentziri, ari nompakemi niyanki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iyaatashitanakero iniro, okantapaakero: “¿Oitaka nonkowakoteriri?” Okantanakero onaanate: “Pinkowakoteri iito Juan omitsitsiyaatantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ipiyapaaka mainawo, okantapaakeri: “Nokowi pimpenawo iito Juan, powakenawo pachakashetaki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Antawoite rowashiretanaka pinkathari. Tema maawoini ikemaitakeri inkaaganki ikantakerowa mainawo, tekaatsi inkenakaanairo, ontzimatye impero okowakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Rotyaantake owayeri ramakeniri iito Juan. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jatanake owayeri romonkyagaitakerira Juan, rithatzinkapaakeri, ramakotakero iito pachakashetakiki. Ipakoitapaakero mainawo, aanakeniro iniro. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ikanta ikemaiyakeni riyotaanewo Juan-ni, pokaiyakeni, ikitatairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Piyaawo rotyaantanewo Jesús, piyotaiyapaani maawoini risaikira, ikamantapairi okaatzi rantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eekero ripokatzi atziri, piyayetacha itsipa. Te onkantaiya rowaiya Jesús. Iro ikantantariri riyotaanewo: “Jame aate ochempiki, amakoryaawakeeta eepichokiini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Otetanaka pitotsiki, jatanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iri kantacha, osheki aminakotawakeriri riyaatanakera, riyotawakeri. Shiyaiyanakani ikenanake awotsiki, ipoñaanakawo nampitsiki. Iri etakawo rareetaka, piyotaiyapaakani. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ikanta rareetapaaka Jesús, iñaapaatziiri ipiyotaiyani. Retakotapaakari. Roshiyakari oweja eerorika itzimi kempoyiiriri. Riyotaapairi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ari otsireniityaanake, ripokashitapaakeri riyotaanewo, ikantapaakeri: “Yotaanarí, asaikatziira ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pipakairo piyotaantzi, riyaataita atziripaini nampitsiki ramanante royaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ikantanakeri Jesús: “Pimperi eeroka royaari.” Ikantzi riyotaanewo: “¿Pikowatziima niyaate namanantakite nowakayaariri? Osheki owanawontsi, eero rimonkaata koriki nowakaantyaariri maawoini, osheki ipinatyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ikantanake Jesús: “¿Tsika okaatzika pan ramakeri atziripaini? Piyaate paminakitero.” Jatanake raminakitziro, ikantzi: “Eenitatsi okaatzi 5 pan, apite shima.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ikantzi Jesús: “Poisaikeri maawoini atziri onatsiryaapankaatakera kishipeenkashi, pinashiyetyaari poisaikeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rimatakero. Eenitatsi inashitainchari risaikayetake ikaatzi 100 atziri, eejatzi ikaatzitaka itsipa 50 atziri. Ari ikantakeri roisaikakeri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ikanta raakotakero Jesús 5 pan itsipataakero apite shima, aminanake jenoki inkiteki, riwetharyaanakari Ashitariri. Itzipetowakero pan, ipakeri riyotaanewo, rowawisaakeniri itsipa atziripaini. Eejatzi ikantakeri shima, rantetakari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Rowaiyakani maawoini, kemaneentaiyakani. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yeekiyetai kantziriki okaatzi 12 rowagaantakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ikaatzi ishekitzi 5000 shiramparipaini owainchari. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ikantanairi Jesús riyotaanewo: “Petaiyaawo pimontyagai nampitsikinta Betsaida.” Ikantanakeri piyowentakariri: “Piyaataira pipankoki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ikanta riyaayetai maawoini atziri, tonkaanake Jesús ochempiki ramana. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsirenitanake, riweyaakotaka riyotaanewo niyankyaaki inkaare rimontyaakotaiyaani. Apaniroini risaikanake Jesús ochempiki, ");
INSERT INTO cpbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","raminakotakeri riyotaanewo, shintsiini rikomataiyini oipiyakotakeri tampyaa. Okanta okiteeshetzimatake, riyaatashitairi, ranashaatantanaawo inkaare, ikenashitapairi itaapiiki, oshiyakawo rawisanakityeerime. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Irojatzi iñaantaitawaari, roshiyakaatziiri iri shiretsi, kaimaiyanakeni, ");
INSERT INTO cpbNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","maawoini rominthaawakeri iñaawairira. Ikantapaakeri Jesús: “Naaka pokaatsi, eero pithaawashita, tontashire pinkantya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Otetapaawo pitotsiki, awisainkatanake tampyaa. Riyokitziiwentanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tema tekera riyotakotziroota roshekyaantakawori Jesús pan, okantakaakari ikisoshirewaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Irojatzi rareetantakari inampiki Genesaret-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iro raatakotapaakitziini, riyoitawakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ikamantawakaiyanakani nampitawori janta, ramakotakeri mantsiyari romaryaamentoki. Tsikarika risaiki Jesús, ari ramakoitziniri mantsiyari. ");
INSERT INTO cpbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ari ikantzitaitari ikenayetzira oryaaniki nampitsi, nampitsi antawo, eejatzi owaantsiki, rowakoitziniri mantsiyari awotsiki, ikantaitziri: “Pishinetya riterotawakero piithaare.” Maawoini terotzitakeriri iithaare etsiyatakoyetai. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ikanta ripokaiyakeni Fariseo itsipatakari Yotzinkaripaini, ipoñaakawo Jerusalén-ki. Ipiyowentapaakari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ari iñaapaakeri riyotaanewo Jesús te rantero rametapiintari ikiwaakota arika roya. Ikishimatapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Okaatzi rantapiintziri Fariseo-paini, eerorika ikiwaakota, eero rowaa. Iro rametari pairani icharine: Arika roya ontzimatye inkiwaakotawakya, inkitewathatantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Arika rareetaiya ramanantawaitzira, tekera rowapaiyaata, inkiwaakoperotapaiya. Te apatziro rametawo jiroka, ikiwayetziro eejatzi riramento, rowamento, ronkotsimento, rimaamento, maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iroowa rosampitantakariri Jesús, ikantziri: “¿Oitaka ipeyakotantakawori piyotaanewo riyotagairi pairani acharine? Noñaapaakeri rowaiyani, te ikiwaakota.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Rakanakeri Jesús, ikantziri: “Owapeyimotantaneri pinaiyini. Eeroka ikenkithatakotake pairani Isaías, rosankenatake, ikantzi: Ipaanteki ipinkathawaitakena atziripaini. Temaita inkenkithashiryaakotaina ishireki. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Raminaashiwaita rotziwerowa ipinkathawetana, Riyotaantashitawo rameyetari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pipeyakotakero eeroka Inintakaantanewo Pawa, pantashitakawo rametari acharineni. Pikiwayetziro powamento, piramento. Osheki okaatzi pantashitakari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ikantanakeri eejatzi: “Iroowa pantaperotakeri pameyetari, pithainkanakero Inintakaantanewo Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jiroka rosankenare Moisés-ni, ikantzi: Pimpinkathateri ashitzimiri. Ikantzi eejatzi: Ontzimatye rowamagaiteri kishimawaitziriri ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iro kantacha pikantapiintzi eeroka: ‘Ankashaakairirika ayorikite Pawa, ontzimatye amperi. Onkantawetakya añeeri rashironkaawaitya apaapate.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ari pikantakari eeroka, piyotaashitakari atziripaini rithainkantzi, te retakotari ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pantashitakawo rameyetari pairani picharine, iroowa pithainkantakawori riñaane Pawa. Ari pikantapiintatya pantziro oshiyawori jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ikaimakeri Jesús maawoini piyotainchari, ikantziri: “Pinkemisantaiyeni maawoini, pinkemathatantyaawori nonkantemiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Okaatzi rowaitari, te owaariperotziro ashire. Irooma okaatzi omishitowiri inthomoiki, iroowa owaariperotzirori ashire. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Powayempitatyaawo jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ikanta riyaataiyaini atziri, kyaapai Jesús pankotsiki. Ari rosampitakeri riyotaanewo, ikantziri: “¿Oitaka poshiyakaawentakeri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rakanake Jesús, ikantzi: “¿Tema pikemathatawakero eeroka? ¿Te piyote eeroka te owaariperotero ashire okaatzi rowaitari? ");
INSERT INTO cpbNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tekaatsi onkantero ashire, apatziro okeniro asheetoki, irojatzi ishitowantaiyaari.” Iroowa riyotaantakeri Jesús, tema te owaariperotantzi okaatzi rowaitari. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ikantanake eejatzi: “Arika antakayeri asheninka kaariperori, iroowa owaariperotzirori ashire. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tema ashireki opoñaawo jiroka: kaariperori kenkithashiryagaantsi, kaari kinataantsi, mayempitaantsi, tsitokaantsi, ");
INSERT INTO cpbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","koshitaantsi, shampitsitaantsi, kaariperoshiretaantsi, amatawitaantsi, mayempikyaataantsi, samakoneentaantsi, kishimataantsi, asagaawentaantsi, tzimaityaashiwaitaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Okaatzi ikenkithashiretapiintari atziri kaariperori inatzi, iroowa rowaariperotantawori ishire. Tema ishireki opoñaawo jirokapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ikanta ikenanake Jesús nampitsiki jitachari Tiro, irojatzi Sidón-ki. Ari risaikapaake pankotsiki, te ikowaweta inkemakoiteri. Temaita rimanakota. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Eenitatsi janta tsinane raayiri peyari ishinto. Okemakotawakeri iroori Jesús, ipokashitakeri, otziwerowashitapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jiroka tsinane kaari Judá-ite, opoñaawo iroori otsipaki nampitsi oita Sirofenicia. Okantapaakeri: “Jesús, petsiyatakotakagainawo nishintyo, raagatziiro peyari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Rakanakero irirori: “Paata tsinané. Ikantaitzi pairani: Te raapithaitziri eentsi rowanawo impaiteri otsitzi royaawo, apatziro rowawo eentsi irojatzi inkemantakya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Akanakeri tsinane, okantziri: “Imaperotatya pinkatharí pikantakeri. Iro kantzimaitacha ikatziyapiinta irirori otsitzi jantyaatsikaini, rowayetawo rookagaantayetziri eenchaaniki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ikantzi Jesús: “Imaperotatya pikantakeri. Piyaatai, ari piñaapairo pishinto etsiyatakotai iroori.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Okanta iyaatai tsinane opankoki, oñaapairo ishinto omaryaa imaamentoki, etsiyatakotai. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ari rawisanake Jesús risaikawetapaakaga nampitsiki Tiro, ikenanairo Sidón-ki, Decápolis-ki irojatzi rareetantaawo Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ramaitakeniri witakempitari, masontziwaanteri rini eejatzi. Ikantaitapaakeri: “Jesús, piterotantawakyaari pako.” ");
INSERT INTO cpbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Raanakeri Jesús jantyaatsikaini, rosagaantantakari rako ikempitaki, ritziritantakari ishimore ineneki. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aminanake jenoki inkiteki, rowiñeenkatanaka rañaanake Jesús, ikantzi: “¡Efata!” (Akantziri apaanteki aaka: “Piwitaryagaiya.”) ");
INSERT INTO cpbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Irojatzi iwitaryaantanakari ikempita, te imasontziwaantetanai eejatzi, wetsikanaawo riñaawaitanai kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ikantawetakari Jesús: “Eerowa pithawetakotana.” Te ikemisantzimaitari, thawetanake atziripainiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Riyokitziiwentaitanakeri Jesús, ikantaiyini: “¿Oitaka okameethatantari rantziri jirika? Ikemakagairi witakempitari, riñaawaitakagairi eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ikanta ipiyotaiyani osheki atziri, thonkapaaka rowanawo. Ikaimakeri Jesús riyotaanewo ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Antawoite netakoshiretakari atziripaini. Itsipatakena okaatzi mawa kiteesheri, thonkapaaka rowanawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Arika notyaantairi, ari aakeri ritashe awotsiki, tema tzimayetatsi poñagainchari intaina.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rakanake riyotaanewo, ikantanakeri: “Ochempikira asaiki ¿tsika ayeka owakayaariri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Rosampitanakeri Jesús, ikantziri: “¿Eenitatsi pan?” Ikantaiyini irirori: “Eenitatsi okaatzi 7.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ari roisaikakaantanakeri Jesús maawoini atziri kipatsiki. Raakero pan okaatzi 7, riwetharyaawentanakawo, itzipetowakero, ipakeri riyotaanewo rowawisaakeniri atziripaini irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tzimitacha eejatzi shiwaireki. Riwetharyaawentakari, ipitakari eejatzi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rowaiyakani maawoini, kemaneentaiyakani. Yeekitai tzimagaantapaintsiri kantziriki okaatzi 7. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maawoini shiramparipaini owainchari ikaataiyini 4000. Rotyaantayetairi inampiki. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ari rotetanaawo Jesús pitotsiki itsipatanaari riyotaanewo, montyaakotanaawo intatsikero nampitsiki oita Dalmanuta. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ari ripokaiyapaakeni Fariseo, riñaanaminthatapaakeri Jesús, ikowi iñeeri ritasonkawentante, iro riyotantyaari imaperotatya opoñaawo itasorenka jenoki inkiteki, tema iñaantashiretatyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Rañaashiryaanake Jesús, ikantziri: “¿Oitaka ikowantari iñeena nitasonkawentante jirikapaini? Eeromaita noñaayiri. Imaperotatyaaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Piyanaawo Jesús, montyaakotanaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ari imaisantanakero riyotaanewo ragaantanakyaame pan, apaani ragaantamatsitanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ikantzi Jesús: “Paamaawentyaawowa kachotakairori iwaane Fariseo eejatzi rashi Herodes.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ari ikantawakaanaka riyotaanewo: “Kaari amantanaka pan.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Riyotake Jesús okaatzi ikantawakaakari riyotaanewo, ikantziri: “¿Oitaka piñaanatawakaawentari: ‘¿Kaari amantaka pan, kaari amantaka pan?’ ¿Tema pikemi? Kisoshire pikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tzimawetacha poki te piñaante, tzimitawetacha pikempita te pinkeme. ¿Tema poshiretawo noshekyaantakawori pan? ");
INSERT INTO cpbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tema tzimawetacha pan okaatzi 5, nowakaaka isheki atziri ikaatzi 5000. Powiitairo okaatzi tzimagaantapaintsiri. ¿Tsika okaatzika kantziri yeekitaatsiri?” Ikantaiyini: “Okaatzi 12 kantziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Eejatzi nokantakero, kaawetachari 7 pan, rowaiyakani isheki atziri ikaatzi 4000. Powiitairo tzimagaantapaintsiri. ¿Tsika okaatzika kantziri piyeekitairi?” Ikantaiyini: “Okaatzi 7 kantziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ikantanakeri: “¿Tekerama piyotakotziroota?” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Areetaka Jesús nampitsiki Betsaida. Ramaitakeniri mawityaakiri, ikantaitapaakeri: “Piterotantawakyaari pako.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ikanta Jesús, rotaiyawakotanakeri. Raanakeri othapiki nampitsi. Reewaakitakeri, rosheyookitantakari rako. Rosampitzimaitari, ikantziri: “¿Koñaatanai pamine?” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aminanake, ikantzi: “Aminawetaana, noñaawetaari atziri, te ikoñaaperotzimaita, roshiyashitakawo inchato.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Rapiitanairi riterookitziri, ikantairi: “Pamine iroñaaka.” Okiryaanake, koñaatanai ramini intaina, iñaanairo maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Rotyaantairi, ikantawairi: “Eero pikenanai nampitsiki, tera nokowi pinthawetakotena.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ikanta rawisanake Jesús itsipatanaari riyotaanewo ikenake Cesarea-ki inampipainiki Filipos. Okanta niyanki awotsi rosampitakeri riyotaanewo, ikantziri: “¿Oitaka ikenkithashiretakotanari atziripaini?” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ari rakaiyanakeni riyotaanewo, ikantzi: “Ikantaitatziimi Juan-ni omitsitsiyaatantaneri pinatzi, ikantaitzimi eejatzi Elías pinatzi. Eenitatsi itsipa kantayetzimiri Kamantantanerira piriintaachari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ari rosampitanakeri irirori, ikantanakeri: “¿Oitaka pikenkithashiryaakotanari eeroka?” Ari rakanake Pedro: “¡Eeroka, Cristo pinatzi!” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ikantzi Jesús: “Paataga pithawetakotzitana.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ari retanakawo Jesús ikamantziri riyotaanewo onkaate awishimoterine, tema iri jitainchari Itomi Atziri. Ikantziri: “Osheki rowasanketaitena. Osheki inkisaneentena Itzinkamipaini, eejatzi reewarepaini Imperatasorentsitaarewo, eejatzi Yotzinkaripaini. Rowamaakaantena. Iro onkaatakeme kiteesheri mawa, añagaana.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ari ikantakeri, te rimaniro. Ikanta Pedro, raanakeri Jesús jantyaatsikaini, ikowaweta inkaminairime. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ripithokapithatanakari, raminanakeri riyotaanewo, ikisathatanakeri Pedro, ikantanakeri: “¡Piyaate Satanás! Te poshiretawo eeroka inintakaantziri Pawa, apatziro poshiretawo ikowayetziri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ikaimanakeri Jesús piyowentakariri, ikaimitanakari eejatzi riyotaanewo, ikantakeri: “Tzimatsirika kowatsine intsipatena, rookero ikowashiwaitari irirori. Onkantawetya inkentakoiteri, intsipataina naaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ikaatzi antashiwaitawori iñaamatashitari, ari impeyashitaiya. Irooma ikaatzi kamawentenane, okantakaantziro ikemisantziro Kameethari Ñaantsi, aritake rawisakoshiretai. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aminaashiwaitaga iñiiro oshekitzimotziri rashaagawo tzimawetachari kipatsiki, arira impeyashitaiyaawo rañaamento. ");
INSERT INTO cpbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Arima ripinawentaiya eero iñaantaawo impeyashitaiya? ");
INSERT INTO cpbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ikaatzi kaaniwentanari inkenkithatakotena kaariperoriki atziri, atake nimatairi naaka paata nonkaaniwentairi arika nipiyai namairo rowaneenkawo Ashitanari nontsipataiyaari maninkaripaini, tema naaka Itomi Atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Irojatzi ikantantanakari eejatzi Jesús: “Pikaataiyakenira jaka, tzimatsira apawopaini eero ikamita irojatzi iñaantakyaawori ishintsinka Pawa tsika ikanta ipinkathariwentantzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Okanta awisanake kiteesheri okaatzi 6. Tonkaanake Jesús ochempiki, raanakeri Pedro, Juan, eejatzi Jacobo. Ari rishipakiriimotakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kitamaaniki okantanaka iithaare, tekaatsi oshiyakairi okitamaatanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iñaatziiri Elías itsipatapaakari Moisés, ikenkithawaitakaapaakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Riñaawaitashitanaka Pedro, ikantanakeri Jesús: “Yotaanarí, imaperotatya okameethatzi pamaiyakenani jaka. Kameetha niwetsikaiyemini mawa pankoshetantsi: apaani pashi eeroka, apaani rashi Moisés, apaani rashi Elías.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tema ithaawaiyanakitziini, irootake riñaawaitashitantanakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Irojatzi ipokantapaaka menkori itsimankakotapaakeri. Ikematzi ikantaitzi: “Notomi rinatzi jirika netakokiperotari, pinkemisanteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Raminaperowetanaari, te iñaanairi, apatziro Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ikanta roirinkaiyaani ochempiki, ikowakotakeri eero ikamantantziro okaatzi iñaakerira irojatzi paata arika rañagai. Tema jirika Itomi Atziri ari rañagai inkamawetakyaarika. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iro kaari ithawetakotantari, iro kantacha osheki rosampitawakagaiyakani irirori tsika oita ikantakotziri Jesús, arika rañagai inkamawetakyaarika. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Irojatzi rosampitantakariri, ikantziri: “¿Oitaka ikantakotziri Yotzinkaripaini iri jewatapaintsine Elías ripoke?” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ari rakanake Jesús, ikantziri: “Imaperotatya, iri jewatapaintsine Elías ripoke, rowameethatantapaake. ¿Tsika okantzika rosankenatakoitakenari pairani? Tema okantatzi: ‘Jirika Itomi Atziri, osheki rithainkawaitaiteri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pinkeme, ari pokake Elías. Osheki ikoshekaitakari, rimonkaatakero okaatzi rosankenatakoitakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ikanta rareetaawo Jesús rookanakeri riyotaanewo, iñaapaatziiri ipiyowentari osheki atziri itsipatakari Yotzinkariite riñaanaminthatziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ikanta iñaawairi ripokai Jesús, riyokitziiwentawairi, rishiyanaka riwethatawaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rosampitapaakeri Jesús, ikantziri: “¿Iitaka piñaanatakotziriri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Akanake apaani, ikantanake: “Yotaanarí, namatziimiri notomi raayiri peyari, te inkantaiya riñaawaitai. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ripokashitapairirika, osheki romposakaawaitari kipatsiki. Ishimorewaantewaitakairi, ratsikaikiwaita, ikisotakairi. Nokantawetakari piyotaanewo rowawisaakotainari, te rimatziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rakanake Jesús, ikantanake: “Te pinkemisantaiyeni eeroka. ¿Tsika onkaateka piyote? Pamakenari jaka eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ramaitapaakeniri. Ikanta peyari iñaawakeri Jesús, antawoite rompetatakaanakari eentsi, tyaanake isaawiki, ripinaawaitanaka kipatsiki, ishimorewaantewaitanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Rosampitanakeri Jesús ipaapate eentsi, ikantziri: “¿Tsikapaiteka retaka peentsite?” Ikantzi: “Rashi rowiro eeniro ikaatziinitzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ritaakaawaitari paampariki, ripiinkawaitzi eejatzi ñaaki, ikowi rowamairime. Kantacharika pineshironkatena, pimatero.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ikantziri Jesús: “¿Oitaka pikantantari ‘Kantacharika...?’ Arika pinkemisantanai, aritake imatakya maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Irojatzi ikaimantanakari antawoite ipaapate eentsi, ikantanake: “Kemisantawetachana, terika nokemisantaperotzi, pinkemisantakaaperotaina eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eekero iñaatzi Jesús ripokaiyapaakeni atziri, ikisathatanakeri peyari, ikantanakeri: “Pitainkapithateri eentsi, te nokowi pipiyashiteri eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Antawoite ikaimanake peyari. Ikamimatakaanakeri eentsi. Osheki kantanaintsiri: “Kamake eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Rakathawakotanakeri Jesús, ipiriintakeri. Añaanai. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ikanta ikyaapaake Jesús pankotsiki, ari rosampitakeri riyotaanewo apaniroini, ikantziri: “¿Iitaka kaari nimatantari naaka nowawisaakoteri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ikantzi Jesús: “Imaperotatya ishintsitzi jirika peyari, okowatyaaga ankamaityaawo amaña, atziwentya eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ikanta rowaaganaawo Jesús, ikenanai Galilea-ki. Te ikowi inkemakoteri atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Riyotaayetziri riyotaanewo, ikantziri: “Irootaintsi raakaantaiteri Itomi Atziri, ritsitokaiteri. Awisawetakyaarika mawa kiteesheri, aritake rañagai eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iro kantzimaitacha tera riyotawakero okaatzi ikantawetariri. Tekaatsi kowatsine rosampiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Areetaiyaani Capernaum-ki. Ikanta risaikaiyapaini pankotsiki, rosampitakeri Jesús, ikantziri: “¿Oitaka pikantawakaari inkaaganki awotsiki?” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ari imairetaiyakeni irirori. Tema ikantawakaawentatyaawo awotsiki tsika itzimi iriiperotatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Saikanake Jesús, ipiyotakeri riyotaanewo ikaatzi 12, ikantziri: “Arika pinkowe piriiperote, poshiyakotyaari imperataarewo, te ipinkathariwentantzi irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ramake eentsi risaikaiyakeni, ithomaakeri, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Inkaate aakoterone nowairo ikemisantaana, arika raakameethatairi oshiyariri jirika eentsi, naakaga raakameethatake. Ari okantari eejatzi, arika raakameethatakena naaka, oshiyakawo iri raakameethatzi otyaantakenari jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ari ikantanake Juan: “Yotaanarí, noñaake chapinki atziri aakotzirori piwairo, rowawisaakotziri raayiri peyari. Te añiiri ankaateri jaka, nipakaakaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ikantzi Jesús: “Eero pipakaakairime. Tema ikaatzi tasonkawentantatsiri raakotziro nowairo, eero ikishimataana paata. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tema aritake akaatziri kaari kisaneentairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Arika ineshironkaitemi raakoitero nowairo, inkantaite: ‘Nompakoteri ñaa rashitaari Cristo.’ Iri ripinaitairi paata. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tzimatsirika antakaakerine kaariperori oshiyakariri jirika eentsi rawentaana, ari rowasanketaitakeri. Iro kameethatatsi inthataiteniri mapi ikentsiki, rowiinkaiteri inkaareki. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iroorika pako pantantapiintawori kaariperori, pipakairo pawisakotantaiyaari, oshiyaawo pithatzinkatyeerome pako, piyaaponchokitantaiyaari inkiteki. Te okameethatzi otzimawetaga apite pako iro piñaantaiyaawori paata rookaitaimi sarinkaweniki pashi powaatyeero pitagaiya, ");
INSERT INTO cpbNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","janta te ikaamanetapai chowitsi, te itsiwakanetapai paampari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Iroorika piitzi pantantapiintawori kaariperori, pipakairo pawisakotantaiyaari, oshiyaawo pithatzinkatyeerome piitzi, piyaaponchokitantaiyaari inkiteki. Te okameethatzi otzimawetaga apite piitzi iro piñaantaiyaawori paata rookaitaimi sarinkaweniki pashi powaatyeero pitagaiya, ");
INSERT INTO cpbNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","janta te ikaamanetapai chowitsi, te itsiwakanetapai paampari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iroorika poki pantantapiintawori kaariperori, pipakairo pawisakotantaiyaari, oshiyaawo pinkithoryaatyeerome poki, piyaapityaakitantaiyaari inkiteki. Te okameethatzi otzimawetaga apite poki iro piñaantaiyaawori paata rookaitaimi sarinkaweniki pashi powaatyeero pitagaiya, ");
INSERT INTO cpbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","janta te ikaamanetapai chowitsi, te itsiwakanetapai paampari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tema paampariki iñaantaitantemi maawoini, roshiyakagaitemi katyori. ");
INSERT INTO cpbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kameetha iwetsika tziwi okatyotzi, arika rowaitaitero tsikarika oita, eero okameethatai inkatyokantaityaawo. Ontzimatye poshiyaawo eeroka tziwipero, paapatziyawakagaiya, te opantawo pintzimawentawakaya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ikanta rowaaganaawo Jesús riyaatero Judea-ki, ikenanakero intatsikero Jordán. Ipiyowentawaari osheki atziri. Retapaawo riyotaayetapairi ikantapiintzirowa. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ari ripokake Fariseo, rosampitapaakeri Jesús ikowi rikompitakayaarime, ikantapaakeri: “¿Shinetaantsitatsima atziri rookero iina?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Rakanake Jesús, ikantanakeri: “¿Oitaka inintakaantziri Moisés-ni?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ikantaiyini irirori: “Rishinetakaantziro Moisés-ni ookero aina arika impaitairo osankenatakotaga jokawakagaantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ari rakanake Jesús, ikantanakeri: “Okantakaantziro te pikemisantanetzi, iro rishinetantakemirori jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tema pairani etantanakari riwetsikantzi Pawa, Riwetsikake shirampari eejatzi tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iro rontsiparyaantariri atziri ashitariri, ompoñaantyaari raye iina, ");
INSERT INTO cpbNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Apaani ikantanaa raawakaana. Te apite atziri rine, apaani ikantanaawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iroowa eero okantanta rontsiparyagaiyaawo atziri itsipatakaariri Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ikanta risaikaiyini pankotsiki, rosampitairi riyotaanewo okaatzi ikantakeri, ");
INSERT INTO cpbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ikantanake Jesús: “Inkaate jokerone iina, arika ragai otsipa tsinane, imayempiwentakero retawetari ketziroini. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ari okanta tsinane arika ookeri oime, agairika itsipa shirampari, mayempitake eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ari ramaitakeniri Jesús eentsipaini, ikowaitzi riterotantyaari rako. Ikanta riyotaanewo Jesús ikisathatakeri amayetziriri eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te inimotanakeri Jesús iñaakeri, ikantziri: “Pishineteri eentsipaini ripokashitenaata. Eero pithañaana. Maawoini oshiyaiyaarine eentsi, iri ñagairone ipinkathariwentantzi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Imaperotatya, eerorika ipinkathatziri Pawa roshiyakotyaari eentsipaini, eerowa iñiiro ipinkathariwentantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ithomaawakeri eentsipaini, rotzimikapatziitoyetakeri, ritasonkawentayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iro rawisantanaiyaarime Jesús, rishiyashitakari mainari, rotziwerowashitapaakari, rosampitapaakeri: “Kameethari Yotaantanerí, ¿oitaka nantairi noñaantaiyaawori añagaantsi kantaitaachane?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ari rakanakeri Jesús, ikantziri: “¿Oitaka pikantantanari: ‘Kameethari pinatzi?’ Apatziro ikantakaawo Pawa ikameethatzi, tekaatsi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Piyotakotakeroma Inintakaantaitziri: Eero pitsitokantzi. Eero pimayempitzi. Eero pikoshitzi. Eero pithaiyakotanta. Eero pamatawitantzi. Pimpinkathateri ashitzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rakanake irirori, ikantzi: “Yotaantanerí, nithotyaakero maawoini irojatzi netanakawo pairani eeniro nokaatziinitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Raminanakeri Jesús, retakotanakari, ikantziri: “Eenitatsi kowapainchari kaari pantzi. Piyaataate pipankoki, pimpimantero maawoini pashitari, pimpashityaari ashironkainkari. Ari piñagairo pinintagaiya jenoki inkiteki. Pipoke, poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ikanta ikemawake, okantzimoneentanakari. Owashire ikanta ripiyanaka, tema ashaagantzinkari rini. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ikanta raminanake Jesús omerekiki, ikantziri riyotaanewo: “¡Osheki opomeentsita riyaatai ashaagantzinkari ipinkathariwentantzira Pawa!” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Riyokitziitanake riyotaanewo ikemakerira ikantakeri. Irojatzi rapiitantanakawo ikantzi: “Notomyaayí ¡Osheki ompomeentsitzimotyaari awentaawori rashaagawo riyaatai tsika ipinkathariwentantzi Pawa! ");
INSERT INTO cpbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tema eero imata inkye piratsi camello imooki akoshi, iro owatsiperotachane ompomeentsitya inkye ashaagantzinkari tsika ipinkatharitzi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eekero riyokitziitanakitzi riyotaanewo, ikantashiretanake: “¿Tsikama iityaaka awisakoshiretaatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Raminanakeri Jesús, ikantziri: “Eero rimatziro apaniroini atziri, iri Pawa matakairine. Tema tekaatsi kompitzimotyaarine irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ikantanake Pedro: “Naakaga maawoini nokaataiyakeni, nookanakero okaatzi oshekitzimoyetanari, noyaataiyakemini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Rakanake Jesús, ikantanakeri: “Imaperotatya, tzimatsirika kemisantanairori Kameethari Ñaantsi, kenkithatakotairone eejatzi, iro rookantanakawori inampi, irirentzi, iritsiro, ashitariri, iina, reentsite, rowane, ");
INSERT INTO cpbNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iri ñagairone impairi Pawa osheki. Osheki onkaate pankotsi, irirentzi, iritsiro, ashitariri, reentsite, rowane. Onkantawetakya osheki inkisaneentawaitaiteri, iñagairo paata añagaantsi kantaitaachane. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tema tzimayetatsi etawori, iri ñagairone rimpoiyetai. Tzimayetatsi impoiyetatsiri, iri ñagairone retaiyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ikanta ritonkagaiyini ipampithatziro awotsi riyaatero Jerusalén-ki. Iri jewatatsi Jesús ranashitaiyani. Iyokitzii ikantayetaka riyotaanewo, thaawashire ikantaiyani royaatziri. Irojatzi rapiitantakawo Jesús ipiyotziri riyotaanewo ikaatzi 12, inkamanteri onkaate awishimoterine, ikantakeri: ");
INSERT INTO cpbNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Aatatzi Jerusalén-ki. Ari ragaiteri Itomi Atziri raakaanteri reeware Imperatasorentsitaarewo intsipatakyaari Yotzinkariite, riyakowenteri ritsitokaiteri, ragaitanakeri atziriki kaari asheninkata, ");
INSERT INTO cpbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ishirontawentaityaari, ripasawaitaiteri, reewawaitaiteri, ritsitokaiteri. Iro awisawetakya mawa kiteesheri, ari rañagai eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ikanta Jacobo itsipatakari Juan, itomipaini Zebedeo, rontsitokapaakari okaakiini Jesús, ikantakeri: “Yotaantaneri, nokowi pantainawo namanemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Rosampitanakeri irirori: “¿Oitaka pikowiri nantemiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ikantaiyini: “Tema irootaintsi pimpinkathariwentante, pishinetena nisaikanampitemi pakoperoki nontsipatemi ampinkathariwentante.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ikantanakeri Jesús: “Te piyotziro oita pamananari. Osheki nonkemaatsityaari naaka. ¿Arima pinkisashitakyaawo eeroka pinkemaatsitya osheki? ¿Arima poshiyakena nonkame naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ikantaiyini irirori: “Aritake nimatakero.” Ikantzi Jesús: “Imapero, irootaintsi pimatero onkaate nonkemaatsityaari, ");
INSERT INTO cpbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","irooma pisaikanampitena nakoperoki pintsipatena ampinkathariwentante, eero okanta naaka nishinetaimiro, rashi iita ikashaakaitzitakari ketziroini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ikanta ikemaiyakeni itsipa riyotaanewo, ikisaitanakeri Jacobo eejatzi Juan. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ipiyotanairi eejatzi, ikantziri: “Piyotaiyini eeroka jimpe ikanta pinkathariyetatsiri jaka, rimperatanta. Ari roshiyari eejatzi iriiperotatsiri ipinkathataitziri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Irooma eerokapaini arika pinkowe piriiperote, poshiyakotyaari ronampiitari. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iroorika pinkoweri peewatakaante, poshiyakotyaari noshikaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te iro ripokantyaari Itomi Atziri rimperatantya, iro ripokantari roshiyaari onampirentsi inkamawentante, ripinakowentante.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ikanta rareetaka Jesús nampitsiki Jericó. Irojatzi rowaagantanaawo itsipatanaari riyotaanewo eejatzi ikaatzi piyowentakariri. Ikanta awotsinampiki, iñaapaakeri atziri jitachari Bartimeo, itomi Timeo, ikowakotantzi impashitaityaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kemake irirori, iri Jesús poñaachari Nazaret, ikaimotawakeri, ikantziri: “¡Jesús, icharinetari David-ni, pineshironkataina!” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ikisathawetanakari ikaataiyinira imairetantyaarime, eekero ikaimanakitzi antawoite: “¡Icharinentari David-ni, pineshironkataina!” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Katziyapaaka Jesús, ikantzi: “Pinkaimenari.” Ari ikaimaitakeri ikantaitziri: “Pinkatziye, ikaimatziimi, thaamenta pinkantanakya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rookanakero iwewiryaakowo, katziyanaka, rishiyashitanakari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Rosampitawakeri, ikantziri: “¿Oitaka pikowakotanari? ¿Tsika nonkantemika?” Rakanake irirori, ikantzi: “Yotaantanerí, nokowi naminawaitai kameetha.” ");
INSERT INTO cpbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ikantanake Jesús: “Kameetha piyaatai, etsiyatakotakagaimi pawentagaanaga.” Apathakerotanaka raminanai kameetha, royaatanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Irootaintsi rareetya Jesús Jerusalén-ki, riweyaaka otsipaki nampitsi jitachari Betfagé eejatzi Betania, otsipakerotawo otzishi Olivo. Rotyaantakeri apite riyotaanewo, ");
INSERT INTO cpbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ikantakeri: “Piyaate nampitsiki atsipakerotakari. Ari piñaapaake ewonkeri piratsi burro inthatakotya, tekera ikyaakagaitariita. Pishiryaakoteri, pamakenari. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Arika inkantaitawakemi: ‘¿Piiterika pishiryaakotantariri burro?’ Pinkantanakeri eeroka: ‘Ikowatziiri Pinkathari. Aritake roipiyaimiri paata.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jataiyakeni, iñaapaakeri ithatakotaka ewonkeri burro pankotsikeroki. Rishiryaakotapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eenitatsi itsipa atziri ñaawakeriri, ikaimotakeri: “¿Piiterika burro pishiryaakotantariri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ikantanakeri irirori okaatzi ikantawakeriri Jesús ketziroini. Rishinetaakeniri. Raanakeri burro. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ramakeniri Jesús. Rowaitakeniri manthakintsi imitzikaaki burro, ikyaakaanakari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eenitatsi omaankanaintsiri manthakintsi, itsipa chekanaintsi inchashi romaankashitanakeri owaneenkatantyaari tsika inkenanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Atziripaini jewatanaintsiri, ikaatzi oyaatakeriri itaapiiki, ikaimaiyini, ikantzi: ¡Kaakitake awinkatharitewé! Tasonkawentaarewo rini, tema Pinkathari aitziri otyaantakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Aakameethatairi poyaatyaarine acharine David-ní. ¡Kaakitake Awinkathariteperotyaari! ");
INSERT INTO cpbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Areetapaaka Jesús Jerusalén-ki, kyaapaake tasorentsipankoki, raminayetapaakero maawoini. Tema tsireniityaanake, piyanaka Betania-ki itsipatanaari riyotaanewo ikaatzi 12. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Okanta okiteeshetamanai, piyaawo Jesús ipoñagaawo Betania-ki, tasheyapaake niyanki awotsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Raminake jantó iñaatziiro pankirentsi, owaneenka okantaka oshi. Riyaatashitanakero raminero tzimatsirika okithoki. Tekaatsimaita, iyoshiita oshi, tema tekeraata okithokipaitetziita. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Riyakatanakero pankirentsi, ikantziro: “Pashi powairo eero pikithokitai.” Ikemaiyakerini maawoini riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ikanta rareetaiyapaani Jerusalén-ki. Kyaapaake Jesús tasorentsipankoki, rookapaakeri ikaatzi yompariyetachari. Rotatsinkapaakero rowaitzirira koriki, ari ikantakero tsika rowaitziri shiro. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tekaatsi rishinetanai awisakairone rowaagawo tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Riyotaantanake, ikantzi: “Pairani rosankenaitakero, kantatsiri: ‘Nopanko ini jiroka, ari ramanapiintenari poñaayetachari maawoiniki nampitsi.’ Iro kantzimaitacha eerokapaini pamatawitantapiintake jaka pipimantayetzi, poshiyakaakero koshintzipanko.” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ikanta ikemaiyakeni Yotzinkaripaini, itsipatakari reeware Imperatasorentsitaarewo, raminaiyakeroni jimpe inkenakairo ritsitokakaanteri. Iro kantzimaitacha osheki ithaawantakari Jesús, tema tzimatsi osheki atziri iyokitziiwentakeriri iñiirira kameetha okanta riyotaantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tema ari tsireniityaanai, piyanaawo Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ikanta ikenamanai isaikinta pankirentsi, iñaatziiro kamashitanake, kamanake maawoini oparitha. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ikenkithashiryaanairo Pedro riyakatakerowa chapinki Jesús. Ikantziri: “Yotaantanerí, paminero pankirentsi piyakatakeri, kamashitanake.” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Rakanake Jesús, ikantzi: “Pawentaiyaari eeroka Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Arika pinkowakoteri Pawa roshirinkerome otzishi rookero inkaareki, eerorika pikisoshirewaitzi, iri pawentaanakya, ari rimatakemiro. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iro nokantantzimirori jiroka, tema arika pamañaari Pawa pinkowakoteri tsika oita, pawentaanakyaaririka, ari rimatakemiro pikowakotziriri. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Arika pamañaari Pawa, pimpeyakotairo kaari inimotzimiri rantzimotaitzimiri eeroka, inantyaari Ashitairi Jenokisatzi impeyakotakagaimiro eeroka okaatzi pikenakaawaitashitakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eerorika pipeyakotziro rantzimotaitzimiri eeroka kaari inimotzimi, ari inkantaimi eejatzi Ashitairi Jenokisatzi, eero ipeyakotzitaimi eeroka pantakero kaariperori.” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ikanta rareetaiyapaani Jerusalén-ki, anashiwaitapaa Jesús tasorentsipankoki. Ripokashitapaakeri reeware Imperatasorentsitaarewo, itsipatakari Yotzinkaripaini, ripokake eejatzi Itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Rosampitapaakeri, ikantziri: “¿Jimpe itzimajaantzika pinkathari otyaantzimiri pantantawori jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ari rakanakeri Jesús, ikantanakeri: “Tzimatsi naaka nosampitemiri, arika pakakena ari nonkamantakemiro iitarika otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tema romitsitsiyaatantake Juan-ní, ¿Iitaka otyaantakeriri? ¿Pawama? ¿Atzirima? Pakaiyeni.” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ikantawakaanaka: “Arika ankantakeri Pawa otyaantziri, ari inkantanakai: ‘¿Oitaka kaari pikemisantantari?’ ");
INSERT INTO cpbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Arika ankante: ‘Atziri otyaantakeri’, ari inkisanakai atziripaini. Tema ikantaiyini atziripaini, Kamantaperotantaneri rini Juan-ni.” ");
INSERT INTO cpbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ari rakaiyanakeni, ikantaiyini: “Te niyotero.” Ikantzitanaka eejatzi Jesús: “Ari nokantzitari naaka, eero nokamantzimi iita otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ari retanaawo Jesús roshiyakaawentziro okaatzi riyotaantayetziri, ikantzi: “Ipankitake atziri chochokimashi, rotantotakotakero, riwetsikake inchatona inkatzikaaterowa paata, riwetsikake iwamakare onkene risaikawentaitero pankirentsimashi. Raminake saikawenterone iwankiremashi, jatake irirori intaina. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Okanta irakapaitetake iwankire, rotyaantawetaa rimperatanewo ragaateme okithoki. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ikanta iñaawakeri antawairentzi, raawakeri ripasatawakeri, roipiyairi tekaatsi raanai. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rotyaantawetaa eejatzi itsipa rimperatanewo. Romposayinawaitawakeri, ikaweyawaitawakeri, roipiyairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rotyaantake eejatzi itsipa, ritsitokaitakeri. Osheki ikaatzi rotyaantawetakari, eenitatsi ripasawaitakeri, ritsitokayetakeri itsipapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Apaani ikantapaaka itomi irirori, retakoperotane, rotyaantakeri, ikantashiretzi: ‘Jirikarika notomi naaka ari impinkathaitakeri.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ikanta saikawentzirori pankirentsimashi, ikantawakaiyani: ‘Jirikaga ashitaiyaawone paata pankirentsimashi. Jame owamayeri, ayeroota aaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Raawakeri, ritsitokawakeri. Rookakeri othapiki pankirentsimashi. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Iitaka ranteri ashitawori pankirentsimashi? ¿Tema ari ripokanake irirori, ritsitokeri saikawentzirori iwankiremashi, raminai itsipa? ");
INSERT INTO cpbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Tema piñaanatero osankenarentsi? Kantatsiri: Imanintawetakawo mapi wetsikirori pankotsi. Iro kantzimaitacha ipiriintaitairo mapi, roshiyakagaitairo iroorikame tzinkamitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iri Awinkatharite Pawa piriintairori. Iro ayokitziiwentantariri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ari ikowawetaiyakani raakaantanakerime Jesús, riyotanake iri ikenkithatakotake. Te okanta, tema ithaawantakari atziripaini piyowentakariri. Ripakaanakeri, ripiyapithataari. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Rotyaantaitake Fariseo itsipatakari aapatziyariri Herodes, ikowaweta rikompitakayaarime Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ikanta rareetaiyakani, ikantapaakeri: “Yotaantanerí, okaatzi piñaanetari eeroka irooperori inatzi, te oshiyawo ikowashiwaitari atziri. Apa piyotaantziro kameethaperoini ikowakaantziri Pawa. ¿Kameethatatsima amperi koriki rapatotakaantziri Pinkathari César?” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Riyotakotakeri Jesús, ikowatzi rikompitakayaarime osampitakeriri, ikantanakeri: “¿Oitaka piñaantantanari? Pamakenari koriki, naminawakeriita.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ramaitapaakeniri. Ikantzi Jesús: “¿Iitaka ashitawori roshiyakaawo jaka? ¿Iitaka ashitawori iwairo?” Ikantaiyini irirori: “Rashi César.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ikantanake Jesús: “Tema iri César ashitawori, panteniri okaatzi ikowakaimiri pipinateri. Irooma okaatzi rashitari Pawa, panteniri okaatzi ikowakaimiri irirori.” Osheki riyokitziiwentaitanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ikanta ripokaiyakeni Sadoc-iite iñeeri Jesús. Iri Sadoc-iite kantayetatsiri eero rañagai kamayetatsiri. Rosampitapaakeri: ");
INSERT INTO cpbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yotaantanerí, rosankenatake pairani Moisés-ni, kantatsiri: Arika inkame atziri, rookanawentawo iina. Eerorika rowaiyakaawo, okameethatzi iinantaiyaawo irirentzi. Arika owaiyaiya tsinane, roshiyakaawo iriime ashityaarine oime kamaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jame ankantawake: Tzimatsi ikaatzi 7 atziri, irirentzi rinaiyini. Etawori itzimi raawetaka iina, tekera osamaniteeta, kamake, te rowaiyakaanakawo iina. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Irojatzi raantaawo itsipa irirentzi oyaatapaakeriri itzimi. Eejatzi ikantzitaka irirori, kamake, te rowaiyakaawo. Ipoñaapaaka itsipa, eejatzi ikantzitaawo irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ari ikantaka maawoini irirentzi ikaatzira 7. Tekaatsi apaani owaiyakayaawone. Okantaawo paata tsinane kamai iroori. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Arika rañaayetaime paata ikamayewetaka, ¿tsika itzimika oimentaperotaiyaari tsinane? Tema maawoini iinantawetakawo ikaatzira 7.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Rakanakeri Jesús, ikantziri: “¿Iitaka kaari pikemathatantawo osankenarentsi? ¿Iitaka kaari piyotakotantawo ishintsinka Pawa? ");
INSERT INTO cpbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tema arika rañaayetai paata kamayetatsiri, eero itzimapai aawakainkari. Roshiyapaiyaari maninkariite saikayetatsiri inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Irooma ikantakota rañaayetai kamayetatsiri, ¿tema piñaanatero rosankenare Moisés-ni tsika ikanta Pawa riñaanatantakariri itagaganki kitocheemaishi? Ikantakeri: Moisés, Naaka Pawa, ipinkathatziri Abraham, Isaac, eejatzi Jacob. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ari ayotziri, añaayetatsi irirori, tema te rimatziro kaminkari impinkathateri Pawa, apatziro añaayetatsiri. ¿Piñaakero? Pikenakaashitakawo eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ari ripokapaake Yotzinkari, ikemapaakeri riñaanatawakaa. Yotapaake kameetha Jesús riyotaakeri Sadoc-iite, rosampitapaakeri irirori: “¿Otzimika kowaperotachari Inintakaantaitanewo?” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Rakanake Jesús, ikantzi: “Jiroka kowaperotachari, okantzi: ¡Israel-iite! Jirika Awinkatharite Pawa, apaniro ikanta Ipinkatharitzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pinintaperotairi, pinintashirenkatairi, pinintashiretairi, pinintashintsitairi eejatzi. Iroowa kowaperotachari Inintakaantaitanewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ari oshiyawo oyaatapaakerori, okantzi: Petakotaiyaari pisheninka, poshiyakagairi pinethairo piwatha eeroka. Tekaatsira otsipa Inintakaantaitanewo anayirori jirokapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ikantanake Yotzinkari: “Kameethatake Yotaantanerí, imaperotatya pikantakeri: Apaani ikanta Pawa tekaatsi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Osheki okameethatake anintaperotairi, anintashirenkatairi, anintashiretairi, anintashintsitairi. Ari ankantawakagaiyaari eejatzi aaka, etakotawakagaiya. Iro ikowakaaperotairi Pawa, anairo ritagaitziniriri, maawoini rashitakagaitariri jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ikanta Jesús, iñaakeri kameetha okanta ikantakeri, ikantanakeri: “Iroowetaincha pimpinkathaterime Pawa, inantyaari impinkathariwentaimi irirori.” Tekaatsira kowanaatsine rosampitanairi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Riyotaantanake Jesús tasorentsipankoki, ikantzi: “¿Oitaka pikenkithashiryaari eeroka, arika pinkemeri Yotzinkaripaini, ikantzi irirori: ‘Jirika Cristo-tatsiri icharine rinatzi David-ni?’ ");
INSERT INTO cpbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tema Tasorenkantsi ñaawaitakaakeriri pairani David-ni, ikantake: Riñaawaitake Pinkathari, ikantawairi Nowinkatharite: Pisaikapai nakoperoki, ampinkathariwentante, Irojatzi paata nowasanketantaiyaariri kisaneentakemiri, ari pimakoryaayitzitantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ikantzitaka David-ni irirori: ‘Nowinkatharite rinatzi Cristo.’ ¿Tsika inkene incharinetyaari?” Inimoyetakeri maawoini atziri piyotainchari, ikemirira okaatzi ikantayetziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ari ikantanake eejatzi Jesús: “Paamaiyaari Yotzinkaripaini. Osheki iñaamatawo rowaneenkatya kameetha, ishametakayero iithaarekoryampyaa. Ikowi impinkathatapiintaiteri riwethaityaari arika iñagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Arika riyaate pankotsiki ipiyotaitapiinta, ikowapiintziro rosatekakya niyankineki. Ari ikantari arika rowaiyani isheninka, ikowapiintzi rosatekya. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rawentaakawo eejatzi kamayetatsiri oime rashitzitawo opanko. Iro rosamaninkantawori ramanayetapiinta eero riyotantaitari. Iro kantzimaitacha antawowa rowasanketaiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ikanta Jesús risaikimotapaakero rowaitapiintzirira koriki, raminaminthatziri oteyetziriri iyorikite. Ripokaiyapaakeni ashaagantzinkari roteperotzi irirori iyorikite. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pokapaake tsinane kamatsiri oime, ashironkainkawo inatzi, otetapaake iroori apipentyakiteeni koriki, tekaatsi yomaatyaarine ramanantantaityaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ikantanakeri Jesús riyotaanewo: “Anaantake jiroka tsinane, anaakeri ikaatzi oteyewetachari osheki. Imaperotatyaaga. ");
INSERT INTO cpbNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tema ikaatzi otewetachari osheki, rotetashitakari tzimagaantatsiri iyorikite. Irooma jiroka ashironkainkawo, apintziryaakeri oorikite amanantantyaarime okowayetziri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ikanta rishitowanai Jesús tasorentsipankoki, ikantziri riyotaanewo: “Yotaantanerí, paminero mapi riwetsikantaitawori, antawo inayetzi, owaneenkawaitaka pankotsi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ikantzi Jesús: “Maawoini pankotsi okaatzi piñaakerika, irootaintsi intzimpookaitero, eero iñagaitairo pewiryaayetachari mapi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ikanta ritonkaanake otzishiki Olivo, otsipakerotari tasorentsipanko. Ari risaikapaake Jesús. Ikanta Pedro, Juan, Jacobo eejatzi Andrés, rosampitakeri jantyaatsikaini, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pinkamantena: ¿Tsikapaiteka imonkaatya pikantakeri? Arika imonkaatzimatakya, ¿tsika onkantyaaka niyotantyaari?” ");
INSERT INTO cpbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ari rakanake Jesús ikantzi: “Paamaya ramatawitaitzimikari. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tema osheki kowatsine ramatawitemi paata, raakotapaakena nowairo, inkante: ‘Cristo ninatzi naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ari pinkemakoyetakero omanarentsi, paamaya ominthaawashiretzimikari, tema ontzimatye imonkaayetaiya jirokapaini, ithonkimatantaiyaari maawoini paata. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Romanatawakaiya rotyaantane pinkatharipaini otsipaki nampitsiki. Iñagaitairo eejatzi osheki omoyekayetya, iñagaitairo ritasheneentaite. Iroowa retaityaari iñagaitero inkemaatsitaityaawo jirokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Paamaya. Tema atake raakaantaitakemi jewaripainiki ripasawaitaitemi pankotsiki rapatotapiintaitaga. Ari ragaitakemi risaikira pinkatharentsiperori okantakaantziro pawentaanaga, arira pinkenkithatakotenari janta. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iroowa kowaperotachari inkemakotairo atziripaini Kameethari Ñaantsi maawoiniki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Arika ragaitanakemi, eero pikantashiretzi: ‘¿Oitaka nonkanteriri?’ Tema Tasorenkantsi yotakaimirone oitarika pinkanteri, tera eeroka ñaawaitashitachane. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ari iñagaitake aakaanterine irirentzi rowamaakaanteri. Piñeeri aakaanterine itomi. Piñeeri owamaakaanterine ipaapate inkisaneentanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Osheki piñeero inkisaneentaitemi okantakaantziro paakotaanaga nowairo pikemisantaana naaka, iro kantzimaitacha arika pinkamaitanakyaawo pawentaina, ari nowawisaakotaimi. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Arika piñaakeri iitaitziri ‘Pinkaari Thonkaatantaneri’ risaikapaake tsika te ishinetaantsita, inkaatera nampitaiyaawone Judea-ki, ontzimatye rishiye tonkaariki. Iroowa ikenkithatakotakeri pairani Kamantantaneri Daniel-ni.” (Maawoini ñaanayetairone jiroka, ontzimatye inkemathatairo.) ");
INSERT INTO cpbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Pisaikirika jakakeroki pipanko, ari pimpoñaanakya pishiyanake, eero pikyaapanaantzi paapainte tsikarika oita. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Powanekirika pisaiki, eero paapanaantziro piithaare. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Inkantamatsitaitero paata motziyetatsiri, tzimayetatsiri eentsite thotatsiri iteni! ");
INSERT INTO cpbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pamañaari Pawa, arika pishiyayetanake, onkantya eero itonkyotantzimi kyaawontsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tema antawoite rashironkagaitya paata. Pairani owakera riwetsikaitakero kipatsi, irojatzi iroñaaka, te iñagaitziro oshiyaawone jiroka ashironkagaantsi. Eerowa apiitaawo iñagaitairo oshiyaawone. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eerome ishintsitakeme Awinkatharite romairyaantakawori ashironkagaantsi, tekaatsira awisakotaatsineme. Ikamintha intzimayetai riyoyaayetairi Pawa, awentagaiyaarine, iroowa romairyaantaiyaawori ashironkagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Arika pinkeme inkantaitemi: ‘Jirika Cristo’, itsipa kantemine: ‘Jirinta Cristo’, eero pikemisantziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tema ripokayete oshiyakotyaarine Cristo, oshiyakotyaarine Kamantantaneri. Ari ritasonkawentantake, inkowe ramatawiteri riyoyaayetairi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Paamaya eeroka, tema nokamantzitakemiro iroñaaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Paata, arika onkaatapaake rashironkagaita antawo, eero ritamorekaawo ooryaa, eero ritamorekitaawo kashiri, ");
INSERT INTO cpbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","rithopiryaayete impokiro, maawoini oorentayetachari jenoki ripookayetairo. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aripaite ripokai Itomi Atziri inkenantapaiyaawo menkori, iñagaitawairo ishintsinka eejatzi rowaneenkawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Rotyaanteri maninkaripaini, impiyotairi riyoyaitakeri nampiyetawori kipatsiki, maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ari oshiyawo piñaapiintzirowa eereshiyetzi pankirentsi, piyotaantziro irootaintsi osarentsitzimatai. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iro piyoteri eerokapaini, arika piñaayetero nokamantakemiri, pokimataanaga. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eero ipeyayetzita jirika asheninkapaini, irojatzi iñaantakyaawori nokamantakemiri. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Eero piñaaneentairo inkite eejatzi kipatsi, irooma niñaaneyetakari imaperotaatyeeya iroori. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Apatziro riyotziro Ashitairi imonkaatantaiyaari. Tera riyotziro Itomi eejatzi maninkaripaini saikatsiri inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Paamaya, aamaawenta pinkantya, pamaña. Tera piyote tsikapaite imonkaatantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Oshiyaawo arika riyaate atziri intaina. Rookanakero ipanko, ikantayetanakeri inoshikanewo oitarika ranteniriri. Eejatzi inkantakeri kempoyiirori pankotsi, ikantanakeri: ‘Paamaya.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Paamaya eeroka, tera piyote tsikapaite ripiyai ashitawori ipanko, tsireniiteeni, niyankiiteki, riñaakerika tyaapa, onkiteeshetamanairika, ");
INSERT INTO cpbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","tema arika romapokairo ripiyai, onkantya eero iñaantapaimi pimaye. ");
INSERT INTO cpbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Okaatzi nokantayetakemiri eeroka, irojatzira nokantzitariri maawoini: Paamaya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yotapaaka apite kiteesheri roimoshirenkantaitawori Anonkoryagaantsi, rowantaitawori eejatzi tashirentsiponkaki. Ari ikamantawakaari reeware Imperatasorentsitaarewo itsipatakari Yotzinkaripaini, ikantawakagaiyani: “Jame amatawiteri Jesús ayeri, owamaakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iro kantacha eero akoshekari kiteesheriki roimoshirenkaitaga, ikisakowentzirikari atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ikanta ikenanai Jesús Betania-ki, ipankoki Simón pathaawaiwetachari. Ari risaikake rowaiyani. Areetapaaka tsinane amakotake kasankari. Iyoshiita owaa inchateyaki jitachari “nardo”, osheki owinawo, kameetha okantaka onaki riwetsikaitziro mapi oita “alabastro”. Isataakotakero othowaki, isaitantakari ipatziitoki Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kisanaka ikaatzi ñaakerori, ikantawakaanaka: “¿Oitaka apaatantawori kasankari? ");
INSERT INTO cpbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Arikame ompimantyaame, ragaiteme osheki koriki inkaate 300 denario, iri ampashityaarime ashironkainkari.” Ikisanakero tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ari ikantanake Jesús: “Piñaaminthatashityaawo, ¿Oitaka pikisantawori? Kameetha okanta noñaakero antakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pitsipatapiintari ashironkainkari, pinkowerika petakotyaari, ari pimpashitakyaari. Irooma naaka, eero piñaapiintana pintsipatena. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jiroka tsinane antatziiro aawiiri iroori, jewatake isaitantanawo kasankari oshiyakaawentatyaana arika inkitaitakena. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Arika inkenkithatakoitero paata Kameethari Ñaantsi, inkemakotaitero tsinane, iroowa roshiretantaityaawori antakeri iroori. Imaperotatyaaga.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ikanta Judas Iscariote, riyaatashitakeri reeware Imperatasorentsitaarewo impimanteri Jesús. Iriiwetakaga riyotaanewo kaawetachari 12. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Antawo ikimoshiretaiyanakeni jewari, ikashaakaakari imperi koriki paata. Raminake Judas tsikapaite raakaanteri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Areetapaaka etawori kiteesheri rowantaitawori tashirentsiponkaki, rowamaitzi eejatzi rowaitari kiteesheriki Anonkoryagaantsiki. Rosampitakeri riyotaanewo Jesús, ikantziri: “Yotaantanerí, ¿Tsika onkotsitakaanteka aaka?” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ari ikantanakeri apite riyotaanewo: “Piyaate nampitsiki. Ari pitonkyotyaari atziri raakotziro iñaate chomoki. Poyaatanakeri, ");
INSERT INTO cpbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","tsikarika inkyaapai, pinkanteri ashitawori ipanko: ‘Ikowatzi riyote yotaanari tsikarika rowakayaari riyotaanewo.’ ");
INSERT INTO cpbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ari roñaaganakemiro jenoki ipanko, antawo okantaka riwetsikaitakero maawoini onkene rowaitya. Ari ponkotsitakaanteri oyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jatake riyotaanewo areetaka nampitsiki. Iñaakero okaatzi ikantakeriri, ari ronkotsitakaantakeri royaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Okanta otsireniityaanake areetapaaka Jesús, itsipatapaakari riyotaanewo ikaatzi 12. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ikanta rowaiyani, ikantzi Jesús: “Pikaatakera pakiyootana, eenitatsi apaani pithokashitenane. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Owashire ikantaiyanakani. Rosampiyetanakeri, ikantziri: “¿Naakama pithokashitemine?” Itsipa rosampitziri: “¿Naakama?” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ikantzi Jesús: “Jirira pikaatakera pakiyootakena. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Imaperotatyaaga impeya Itomi Atziri, rosankenatakoitakeri pairani. Ikantaitake: ‘¡Ikantamatsitziri aakaanterine! Eerome itzimime irirori.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eeniro rowaiyani, raakero Jesús pan. Riwetharyaawentakawo, itzipetowakero, ipayetakeri riyotaanewo, ikantziri: “Poyaawo, nowatha inatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Raakotanakero riraitziri, riwetharyaawentakawo, ipakotakeri riyotaanewo, rirayetakero maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikantziri: “Niraa inatzi, iro shitowaatsine rawisakotantaiyaari osheki. Iroowa oñaagantaperoterone aapatziyawakaantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eero niritaawo, irojatzi paata tsika impinkathariwentantai Pawa, ari napiitairo. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ikanta romampaakotanakari Pawa, jatanai tonkaariki otzishiki Olivo. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ikantzi Jesús: “Irootaintsi pookanawentaiyenani tsirenirikika. Tema rosankenaitake pairani kantatsiri: Rowamaiteri kempoyairiri oweja, rithonkya ripookayetanake ipira. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iro kantacha, arika nañagai, Galilea-ki añaawakagaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ikantanake Pedro: “Aritaikema rookanawentakemi itsipapaini, eero nimatziro naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ikantzi Jesús: “Iroñaaka tsirenirika, tekera rapiiteroota riñe tyaapa, mawa poipiyero, pinkante: ‘Te niyotziri Jesús.’ Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eekero ishintsitatzi Pedro, ikantzi: “Eero nookanawentzimi, kemetaka ari ankaate ankame.” Ari ikantaiyakeni eejatzi maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ikanta rareetaiyakani Getsemaní-ki, ikantapaakeri riyotaanewo: “Ari pisaikawake jaka, namanamanaatawakyaata.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Itsipatanakari Pedro, Jacobo eejatzi Juan. Antawo riraakoshiretapaaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ikantziri: “Owamaimatatyaana nowashirenka. Ari pisaikawake eeroka, pinkakempite.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rowaaganeentanaka irirori. Otziwerowapaaka kipatsiki, ramanapaaka, onkantyaama eero ikemaatsitantawo awishimoterine. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ikantzi: “Ashitanarí, tekaatsi kompitzimotemine eeroka. Nokowaweta pontsiparyaakowentename onkaate nonkemaatsityaari. Iro kantacha eero pimatanawo okaatzi nokowawetakari, iroowa pimate pikowakaanari eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Piyapaawo, iñaapaatziiri rimagaiyini. Ikantapaakeri Pedro: “Simón, ¿Iitaka pimaantari? ¿Tema pikisashitawo piwochokinka? ");
INSERT INTO cpbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pinkakempite, pamaña, otzimikari piyenakaashitanewo. Te pikisashiwaineta, osheki pikowawetari panterime.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eejatzi ripiyanaa, amanapaa. Irojatzi rapiitapai ikantakeri inkaaganki. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ikanta ripiyapaa, eejatzi iñaapairi rimagaiyini, tema antawo okantaka iwochokinka. Ikaaniwaitzi riyotaanewo, te riyotzi tsika inkante. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Okanta mawatapaintsiri ripiyaka, ikantapaakeri: “¿Irojatzima pimagaiyini? Monkaatapaakaga ragaitantyaariri Itomi Atziri, ragaiteri janta kaariperoshireriki atziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pimpiriinte, thame aatai. Jekaatapaakera pithokashitenane.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ikenkithawaiminthaitzi Jesús, areetapaaka Judas itsipawetapiintari. Osheki itsipatapaakari, ramayetake rosataamento, ripasamento. Rotyaantanewo pinkatharipaini piyowentakariri Jesús: Reeware Imperatasorentsitaarewo, Yotzinkaripaini, eejatzi Itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tema Judas pithokashitantachari, ikantzitakari ketziroini ramanewo: “Tsikarika intzime nonthowootapaakeri, iriitakera, poosoteri, paanakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ikanta rareetapaaka, rontsitokapaakari okaakiini Jesús, ikantapaakeri: “Yotaantanerí.” Ithowootapaakeri riwethatapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Rotaiyaitapaakeri Jesús, roosotaitapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ikanta tsipatakariri okaakiini Jesús, inowikyaanakero rosataamento, rithatzinkitakeri ikempita inoshikane reeware Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ikantanake Jesús: “¿Naakama koshintzi, pamashitantanari posataamento, pipasamento? ");
INSERT INTO cpbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nashi nowapiintziro piñaapiintana niyotaantzi tasorentsipankoki ¿Kaarima paantana janta? Arira imonkaatakari rosankenatakoitakenari pairani.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Shiyaiyanakani riyotaanewo, rookanawentanakeri apaniroini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tzimatsi itsipa mainari oyaatakowentanakeriri Jesús. Ikithaawetaka. Iro kantzimaitacha rotaiyaweetakari irirori, ");
INSERT INTO cpbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","rookanakero iithaare rithañaanakaga, raamerekitashitanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ikanta ragaitanakeri Jesús reewaperoreki Imperatasorentsitaarewo. Ari ipiyotaiyakani maawoini reeware Imperatasorentsitaarewo, itsipatakari Itzinkamipaini, eejatzi Yotzinkaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ikanta Pedro noshikaka irirori ripoki neetsikeroini, royaatakowentakeri Jesús, irojatzi rareetantapaaka isaikira ipanko reewaperore Imperatasorentsitaarewo. Ari ikatziyapaaka itsipatapaakari rimperatanepaini, rakitsitaiyani paampariki. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ikanta reewarepaini Imperatasorentsitaarewo itsipatakari piyotainchari, raminawetaka iita thaiyakotyaarine Jesús onkene rowamaakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Osheki thaiyakowetapaakari, te oshiyawakaa ikantayewetakari itsipapaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Katziyanaka apaanipaini, ithaiyakotanakari Jesús, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nokemiri chapinki jirika, ikantzi: ‘Ari nontzimpookakero tasorentsipanko riwetsikanewo atziri, iro awisawetakya mawa kiteesheri niwetsikai otsipa, kaari ratsipeta atziri riwetsikairo.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Inashiyetaka okaatzi ikantayetakeri itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Katziyanaka reewaperote Imperatasorentsitaarewo, rosampitanakeri Jesús, ikantziri: “¿Oitaka kaari pakanta? ¿Tema pikemi okaatzi ikantakoitzimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Irojatzi imairetake, te raki. Rapiitakeri rosampitziri, ikantziri: “¿Eeroka Cristo, Itomi Tasorentsi?” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Rakanake Jesús, ikantzi: “Naakatake. Irootaintsi piñeeri Itomi Atziri risaikai rakoperoki Pawa impinkatharitai. Piñeeri eejatzi ripiyai inkenapai menkoriki.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ikanta ikemake jewaperori, itzisagaanakero iithaare ikisanaka, ikantzi: “¿Eenitatsima otsipa ankoweri inthawetakoiteri? ");
INSERT INTO cpbNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pikemake maawoini rithainkakeri Pawa. ¿Tsika pikantaiyinika eeroka?” Ikantzi maawoini: “¡Tzimataike iyenakaashitanewo! ¡Ontzimatye inkame!” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eenitatsi jewawootanakeriri. Tzimatsi itsipa otzimikawootakeriri, ikaposawaitziri, ikantzimaitari: “¿Piyote Kamantantanerí?” Rimatzitakawo rimperatanewo jewaperori, ripasawoowaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Risaikake Pedro irirori jakakeroki, shitowapaake tsinane rimperanawo reewaperore Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oñaapaakeri Pedro rakitsita paampariki, okantziri: “¿Tema eeroka itsipataganki Jesús Nazaret-satzi?” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Roipiyanakero Pedro, ikantanake: “Te, tera niyotziri iita pikantanari.” Shitowanake eepichokiini. Ñaanake tyaapa. ");
INSERT INTO cpbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Okanta osamaniityaake, oñaapairi eejatzi, okamantakeri ikaatzi akitsitachari, okantziri: “Irijatzira jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Rapiitanakero Pedro roipiyiro. Tekera osamaniteeta, rapiitanakero ikaatzi saikaintsiri rosampitziri, ikantziri: “Eerokaga itsipata Jesús, tema Galilea-satzi pinatzi, ariwaitakemi riñaawaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ikantzi: “Te niyoteri pikantanari. Riyotzi Pawa imapero nokantzi, nothaiyarika, rowasanketainaata.” ");
INSERT INTO cpbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ari rapiitanakero riñaanake tyaapa, apitera rapiitakero. Ikenkithashiryaana Pedro ikantakeriri Jesús: “Arika apitetanake riñe tyaapa, mawa poipiyero, pinkante: ‘Te niyotziri Jesús.’ ” Iraanaka ikenkithashiryaanakerowa. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Okanta okiteeshetamanai, ipiyotaiyamanaani maawoini pinkatharentsi: reeware Imperatasorentsitaarewo itsipatakari Itzinkamipaini, eejatzi Yotzinkaripaini, osheki ikantzimataitakeri Jesús. Roosoitanakeri, ragaitanakeri risaikinta Pilato. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Rosampitawakeri Pilato, ikantziri: “¿Eerokama iwinkatharite Judá-ite?” Rakanake Jesús, ikantzi: “Irootake pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ikanta reeware Imperatasorentsitaarewo, iñaakatsimatanakari, ithaiyakotanakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Rapiitanakeri Pilato rosampitziri: “¿Tekaatsima pinkanteri eeroka? ¿Tema pikemi okaatzi ikantakoitzimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Te raki Jesús. Riyokitziiwentanakeri Pilato jirika Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eenitatsi rantapiintziri Pilato: Maawoini osarentsiki arika roimoshirenkya Judá-ite, romishitowakaantzi isheninka raakaantaitziri, tsikarika itzimi inkoweri atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tzimatsi jitachari Barrabás, raakaantaitziri itsipayetakari ikaataiyinira ritsitokantzi, rantaminthatziri iwinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ikanta ripokaiyapaakeni atziri, ikowakotapaakeri Pilato rantero rametapiintari. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rakanake Pilato, ikantzi: “¿Iriima pikowi nomishitowakaanteri iitaitziri ‘Iwinkatharite Judá-ite?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Riyotake irirori Pilato, ikisawaitashita reeware Imperatasorentsitaarewo raakaantantakariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iri kantzimaitacha reeware Imperatasorentsitaarewo, rakakaakeri atziripaini inkante: “Iri kameethatatsi romishitowaiteri Barrabás.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Rapiitanakeri Pilato rosampitziri: “Jirika iitaitziri ‘Iwinkatharite Judá-ite’, ¿Tsikama nonkanterika?” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ikantzi ikaimaiyini atziri: “¡Pinkentakotakaanteri!” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ikantzi Pilato: “¿Eenitatsima kaariperori rantakeri?” Eekero ishintsitatzi ikaimaiyini ikantzi: “¡Pinkentakotakaanteri!” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ikowanake Pilato ranteniri ikowakeri atziripaini, romishitowakaantakeri Barrabás. Ripasatakaantanakeri Jesús, ragaitanakeri inkentakoiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ikanta owayeripaini ikyaakaanakeri Jesús ipankoki Pilato, iitaitziro “Pretorio”. Ari ipiyotari maawoini owayeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ikithaatapaakeri kithaarentsi anashirikimawotatsiri oshiyawori ikithaatapiintari pinkathariyetatsiri. Irojatzi ramanthaitantanakariri kitocheetapo. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iroowa rantantawori jiroka, tema rithainkimawaitatziiri. Ikaimakowaitziri, ikantzi: “¡Jirikatá iwinkatharite Judá-ite!” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Romposayinatantanakari sawoopanke. Reewawootanakeri. Rotziwerowashitzimaitari impinkathaterime. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Reshitakeri ishirontaminthatari. Raatonkoryagairi ikithaatakeriri inkaaganki, ikithaatairi iithaare. Raanakeri inkentakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ikanta Simón, poñaachari Cirene, ipaapate Alejandro eejatzi Rufo, ritonkyotakari rareeta irirori nampitsiki, ishintsineentaitanakeri inatanakero inkentakotaitantyaariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ragaitanakeri tonkaariki oita “Gólgota”, (akantziri apaanteki aaka: “Atziriitoni”). ");
INSERT INTO cpbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ipakoitapaakeri imere rowaitaitakero kepishaari, te ririmaitawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ikentakoitakeri. Ikanta owayeripaini rookaitawakaakawo iithaare Jesús, roshiyakaakero iñaaryaataita riyotantyaari iitarika ayerone. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jenokiityaapaake ooryaatsiri, ikentakoitakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rosankenaitake opoñaantari ikentakoitantariri, okantzi: IWINKATHARITE JUDÁ-ITE. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ari itsipatagaitakeri ikentakoitziri apite koshintzi, ikatziyakotaka apaani rakoperoki, itsipa rampateki. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ari imonkaatakari osankenatainchari pairani, okantzi: Itsipatagaitakeri kaariperoshiretatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rithainkawaitakeri ikaatzi awisayetatsiri janta, rotekayinata, ikantziri: “Tema eeroka tzimpookirori tasorentsipanko, iro awisake mawa kiteesheri piwetsikairo eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Iitaka kaari payiitanta ikentakoitakemira powawisaakotaiya?” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ari ikantakeri eejatzi reeware Imperatasorentsitaarewo itsipatakari Yotzinkaripaini, rowashiyawentari, ikantawakaiyani: “Rowawisaakotzi itsipa, ¿Kaarima rimatantawo rowawisaakotya irirori? ");
INSERT INTO cpbNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Janjaatya, rayiite Cristo-wetachari iitaitziri ‘Iwinkatharite Israel-iite’, ankemisantantyaariri!” Rimatzitakari eejatzi ikaataiyinira ikentakota, rithainkitakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ikanta itampatzikatapaake ooryaatsiri, omapokashitapaaka otsirenikitanake, irojatzi ishaawiiteeni ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ari ikaimanake Jesús shintsiini, ikantanake: “¡Eloi! ¡Eloi! ¿Lama sabactani?” (Iro ikantaitziri apaanteki aaka: “Pawa, Pawa, ¿iitaka pookanawentantakenari?”) ");
INSERT INTO cpbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ikanta saikawentakeriri Jesús, ikemawetawakari ikaimanake. Ikantanake: “Pinkemeri, ikaimatziiri Elías.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rishiyapainta apaani, romitsitsiyaatapaintzi manthakintsi kepishaariki, rankowitakeniri sawoopankeki, rowaankakotakeniri ratsimiyaatero, ikantzi: “Añaawakeriita ari ripokake Elías rowayiitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Rapiitanakero ikaimanake antawoite, te rañeenkatanai. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Okanta tasorentsipankoki, sagaanake niyanki tontamawotatsiri ithatashiitzirori, etanakawo jenoki irojatzi isaawiki, apimawote okantanaka. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ikanta reeware owayeripaini katziyawentakariri Jesús, iñaakeri ikaimanake antawoite ikamantanakari, ikantanake irirori: “Imaperowetatyaama Itomintari Pawa jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eenitatsi eejatzi tsinane aminaintsiri jantyaatsikaini. Jiroka okaatzi: María Magdala-sato, Salomé, María inaanate iyaapitsi Jacobo eejatzi José. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jirokapaini tsinane iro tsipatakariri pairani Jesús Galilea-ki, osheki amitakoyetakeri. Otsipatakawo eejatzi otsipa tsinanepaini oyaatapaakeriri Jesús ripokake Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsireniityaanake. Iroowa kiteesheri riwetsikantapiintaitari rowaityaari oñaatamanai kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ikanta José poñaachari nampitsiki Arimatea, itsipatapiintari ipiyota Itzinkamipaini, irijatzi oyaawentziriri Pawa impinkathariwentantai. Te ithaawi irirori riyaatashitanakeri Pilato, ikantapaakeri: “Pishinetagainari nonkitatairi Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tema romapokapaakeri Pilato, te riyotzi kamake Jesús. Ikaimakaantakeri reeware owayeriite, rosampitakeri imaperorika ikamake Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ikamantaitakeri Pilato, rishinetainiri José raanairi. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ramanantashitakeri kithaarentsi jentamankitatsiri. Ikentakoryaakotairi, iponatairi. Rowakotakeri imoontashiitzirira kaminkaripaini shirantaaki, roipinakaantake mapi, rashitakotantakari. ");
INSERT INTO cpbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Okanta María Magdala-sato otsipatakawo María inaanate José, aminaiyakeni iroori tsika rowaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Awisanake kiteesheri rimakoryaantaitari. María Magdala-sato, otsipatakawo otsipa María iriniro Jacobo, eejatzi Salomé, amanantake kasankari, iyaate itziritantaatyaari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Okanta okiteeshetamanai tominko, ananinkanake iyaate omooki roowaitakerira Jesús. Shitowimatapaake ooryaatsiri iroowa areetzimatya janta. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Okantawakagaiyani: “¿Iitaka otatsinkerone mapi rashitakotantaitakariri?” ");
INSERT INTO cpbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iro aminawetapaaka, oñaatziiro otatsinkaka mapi, tema antawo mapi inatzi. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kyaapaake omooki rowaweetakarira. Oñaashitapaakari mainari risaikake akoperoki, kitamaaniki okanta iithaare. Antawoite areetanakawo. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ikantanakero irirori: “Eero pithaawashita. Iriima pipokashiwetari Jesús Nazaret-satzi, ikentakotaitakeri chapinki. Añagai, tekaatsi jaka. Paminero rowaweetakarira. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pipiyanake, pinkamantayetairi riyotaanewo, pinkamantairi eejatzi Pedro ari riyaatai Jesús Galilea-ki, arira piñaayetairi. Ikamantzitakemi ketziroini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ipiyapithatanakawo omoo, ompetawaitanaka. Tekaatsi itsipa atziri onkamantanake, tema antawo othaawanake. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ari rañagai Jesús owakera okiteeshetamanai tominko, iro retanaa roñaagaawo María Magdala-sato retsiyatakotakagairi pairani raagawetawo peyari kaatatsiri 7. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Irojatzi iyaatashitantanakariri iroori tsipatakariri pairani Jesús, oñaapaatziiri riragaiyani, okamantapaakeri oñagairi iroori. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ikanta ikemawetaiyawakawoni oñagairi Jesús rañagai, te ikemisantaiyironi. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ikanta Jesús, roñaagaari apite riyotaanewo ranashitaiyani awotsiki, pashiniwootapai eepichokiini. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ari ripiyaiyanakani irirori, ikamantawetapaakari ikaataiyinira. Eejatzi ikantzitaitakari irirori, te ikemisantaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rowawaiminthaita riyotaanewo ikaatzi 11, ari roñaagaari Jesús, ikisathatapairi, iñaakeri kisoshire ikantaiyani, te ikemisantziri ikaatzi ñaayetairiri rañagaira. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ikantapairi: “Piyaate pithotyeero maawoini kipatsi. Pinkenkithatakagairi atziripaini Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inkaate kemisantanairone, omitsitsiyaataachane, iriira awisakotaatsine. Iriima kaari kemisantanairone, rowasanketaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jiroka inkantaiya inkaate kemisantanaatsine: retsiyatakotakaayetairi raagayetziri peyari raakotaina nowairo naaka. Riñaawaiyetairo inashiwaiyetachari ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Arika rotaiyawetyaari maanke, arika rirawetyaawo piyantatsiri, tekaatsi onkanteri, eero ikami. Ari onkantakya retsiyatakotakagairi mantsiyaripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ikaatakero Awinkatharite ikamantayetakeri riyotaanewo, irojatzi rowenonkantaari inkiteki, itsipatapaari Pawa ipinkathariwentantapai. Risaikimotapairi rakoperoki. ");
INSERT INTO cpbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Riyaataiyanaini riyotaanewo, ikamantantake maawoiniki nampitsi. Awinkatharite matakaayetakeriri, rantakaayetakeri kaari iñaapiintaitzi, iroowa riyotantaityaari imaperotatya okaatzi ikamantantayetziri. Ari onkantaitaatyeeyaani.");
INSERT INTO cpbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Osheki kowawetaincha rosankenaterome okaatzi awishimoyetakairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ikowi rithotyeerome okaatzi riyotaayetakairi ñaayetawakerori ketziroini, iriitajaantakera ñaawakerori, ikamantakairo ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","¡Teófilo! Ari nokantakari eejatzi naaka. Tema neetsikeroini nonoshikawentakawo tsika okanta opoñaantanakari ñaantsi, irootake nosankenatantzimirori eeroka okaatzi awisayetaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iro ompoñaantyaari piyotakoperotairo maperotachari okaatzi riyotagaitakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pairani, ipinkatharitantari Herodes janta Judea-ki, ari risaikiri Imperatasorentsitaarewo iita Zacarías, icharine Abías-ní rini. Irooma iina oita Elisabet, isawo Aarón-ni ini eejatzi iroori. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kameethashireri ikantaiyani apitekeroini ipinkathatziri Pawa. Rimonkaatziniri okaatzi ikowakairiri, tekaatsi apaani inkenakaashiwaityaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iro kantacha te itzimi rowaiyane, tema maaniro ini Elisabet. Rantarikitashiiyakani. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Okanta kiteesheri, ari imonkaatari rantantapiintantawori Zacarías rimperatasorentsitantari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tema iro rametaiyapiintarini Imperatasorentsitaarewo, roshiyakaakero iñaaryaataita, ari iñagaitakeri iri Zacarías kyaatsine tasorentsipankoki ritayeniri Pawa kasankainkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Piyotaiyachani atziri jakakeroki ramanaiyani, ritagaitziro kasankainkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ari roñaagakari Zacarías imaninkarite Awinkatharite, ikatziyimotapaakari rakoperoki ritayirowa kasankainkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Antawo ithaawanake, iyokitziitanake iñaawakerira. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Irojatzi riñaanatantanakari, ikantziri: “Zacarías, eero pithaawi. Tema ikemaitakero pamananewo. Ari piñaakero piina Elisabet intzimai eentsite, iri piiteri Juan. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Arika intzimake pitomi, osheki pinkimoshirewenteri, ari inkantyaari eejatzi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tema iriiperori inkantakayaari Pawa. Eero pirakairi shinchaari ishinkitaitari. Tema risaikashiretantatyaari Tasorenkantsi tekera itzimiita. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ikenkithashiretakairi Israel-iite inkemisantairi Awinkatharite Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iriitake jewatapaakerine Awinkatharite. Inkantakayaari ishintsinka Elías, ari raapatziyakaayetaiyaari ipaapateetari maawoini rowaiyane. Ari rotsimaryaashiretairi katsimashireri, ari onkantya riwetsikashiretantaiyaari inkemisantairi Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Rakanakeri Zacarías maninkari, ikantziri: “¡Ari! ¿Tsikama onkantya niyotantyaawori jiroka? Antarikitakena naaka, eejatzi okantzitaka noina.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ikantzi maninkari: “Naakatake Gabriel, poñaachari Pawaki. Rotyaantakena nonkamantemiro Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iro kantzimaitacha, okantakaantziro pithainkawaantetakena, kisowaante pinkantya iroñaaka irojatzi imonkaatantakya okaatzi nokantakemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Saikaiyatsini itsipa jakakeroki royaawentaiyirini Zacarías, ari rosampitawakaanaka: “¿Iitaka rosamanitantari Zacarías tasorentsipankoki?” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ikanta rishitowawetapaa Zacarías, te okanta inkenkithawaitapai, rookowaitashitapaaka. Ari riyotaiyanakeni eenitatsi iñaakeri tasorentsipankoki. Rashi rowanakero ikisowaantetanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Irojatzi imonkaatantaawo kiteesheri rantawaitzi tasorentsipankoki, piyaawo ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Okanta Elisabet iina Zacarías, motzitake. Antawoite okenkithashiretaka, te ishitowai opankoki ikaatzi 5 kashiri omairentaka, okantashirewaitzi: ");
INSERT INTO cpbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Irootake inintakaakenari Pinkathari naaka, ompoñaantyaari eero imanintaitantana.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ikanta rawisake 6 kashiri, rotyaantairi Pawa maninkari Gabriel nampitsiki jitachari Nazaret saikatsiri Galilea-ki, ");
INSERT INTO cpbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","iñeero mainawo kaari yoterine shirampari, jitachari María, tema irootake iinantyaari mainari jitachari José, icharine David-ni. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ikanta ikyaapaake maninkari isaikira María, ikantapaakero: “¡Pinkeme María, itsipashiretakemi eeroka Awinkatharite. Pawisayetakero otsipa tsinanepaini ineshironkaperotaimi Pawa!” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Okanta oñaawakeri maninkari, iyokitziitanake, okenkithashiryaakotziro ikantapaakerori riwethatapaakawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Irojatzi ikantantanakawori maninkari: “María, eero pithaawi, tema ineshironkatanewo Pawa pinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ari piñaakero pimotzite, intzime peentsite. Iri piiteri JESÚS. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iriitake materone ririiperote, iitaiteri Itomi Jenokisatzi. Tema Pawa Awinkatharite, iriitake pinkatharitakairine roshiyakagairi pairani icharineni David-ni ipinkatharitakaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Irijatzi pinkathariwentairine ikaatzi icharinetari Jacob-ni, rashi rowaatyeero impinkathariwentantai irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Akanakeri María, okantziri: “¿Tsikama onkene nomotzite, te noñiiri shirampari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rakanakero maninkari, ikantziro: “Iriira kantakayaawone Tasorenkantsi. Tema ritsimankantakemiro ishintsinka Jenokisatzi, oshiyaawome itsimankantzi aamparentsi. Irootake iitantyaari peentsite Tasorentsi Itomi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ari okantaka eejatzi pisheninkathori Elisabet, ikantaweetari maaniro, okantawetaka antawokiwetaka iroori, motzitai. Ikaatake oyashirite 6. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tekaatsi kompitzimotyaarine Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Irojatzi okantantanakari María: “Naakatake rimperatanewo Pinkathari, rantenawo okaatzi pikantakenari.” Irojatzi ripiyantanaari maninkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Okanta otsipa kiteesheri, shintsiini iyaatanake María, jatake tonkaariki Judea-ki isaikira nampitsi, ");
INSERT INTO cpbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","irojatzi areetantakari ipankoki Zacarías, iwethatapaakawo Elisabet. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Okanta okemawakero Elisabet iwethatapaakawo María, shewatanaka omotzitakeri. Tema ikantakaanakityaawo Elisabet Tasorenkantsi, ");
INSERT INTO cpbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","okenkithawaitanake shintsiini iroori, okantanake: “Eerokatake anairori otsipa tsinanepaini ritasonkawentaitakemi. Ari inkantzityaari eejatzi powaiyane. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Iitaka pipokashitantanari irinirotyaari Nowinkatharite? ");
INSERT INTO cpbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tema nokemawakemi piwethatapaakena, shewatanaka nomotzitakeri naaka, kimoshiretanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kimoshire pinkantaiya eejatzi eeroka pikemisantake, tema ari imonkaataiya okaatzi ikowakaakemiri Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Irojatzi okantantanakari María: Antawoite niweshiryaawentaiyaari Nowinkatharite, ");
INSERT INTO cpbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kimoshire nonkantawentyaari Pawa owawisaakoshiretainane. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tema iñaakero rimperatanewo ashironkaawaitaka, Aripaite inkantayeetai: Antawoite ritasonkawentaitakero. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tema antawoite rantzimotakenari matzirori otzimi ishintsinka. ¡Tasorentsi ini iwairo! ");
INSERT INTO cpbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Rashi rowaatyeero ineshironkayetairi inkaate incharineyeetyaari paata, Inkaatera pinkathayetairine. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iroowa ishintsinka rantantayetakari. Raperotzitairi ikenkithashirewetari shamewaitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pawa kantakaakawori eero riyaatakaantawo impinkatharite ikaatzi pinkathariwetachari. Iri iñaaperotakaayeta ikaatzi tsinampashirewetachari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rashaagantakaayetari ikaatzi tasheneentawetachari, Iriima ikaatzi ashaagantawetachari raapithatairi oshekitzimowetariri romishitowakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ramitakotairi Israel-iite, tema rimperatanewo rinayetake. Irojatzi ineshironkayetziri, ");
INSERT INTO cpbNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tema iro ikantaitakeriri pairani acharineyetakari, Retanakari Abraham-ni irijatzi maawoini incharinetaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ari isaikimowaitapaintziro María jiroka Elisabet ikaatzi mawa kashiri, irojatzi ipiyantaawo opankoki iroori. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Okanta imonkaataka ontzimaanitantyaari Elisabet, tzimake otomi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ari ripokaiyakeni osheninkapaini ikimoshirewentaiyironi, tema riyotaiyakeni antawoite ineshironkatakero Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Maakotake 8 kiteesheri eentsi, ragaitanakeri ritomeshaanitaiteri, ari ikowaweetaka iitaiterime Zacarías, tema iwairo inatzi ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Irojatzi okantantanakari inaanate: “Eero iita Zacarías, iitya Juan.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ari ikantaitanakero: “¿Oitaka? Tema tekaatsi pisheninka jitachane Juan.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Rookowakoitashitanari rosampiitziri ashitariri, tsikarika inintziri iiteri itomi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Rookotanakero Zacarías inchakota ramaiteniri, ari rosankenatakero, okantzi: “Iitya Juan.” Iyokitziitanake ikaatzi osampitakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Romapokashitanaawo riñaawaitanai Zacarías. Antawoite ikimoshirewentanakeri Pawa, riwetharyaanakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pagaanka ikantaiyanakani isheninkapaini Zacarías. Tema ithonka ikemakoitanakero tonkaariki Judea-ki okaatzi awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kenkithashireri ikantaiyani ikaatzi kemakotakeriri, ikantaiyini: “¿Tsikama iityaaka paata jirika? Tema kempoyaawenta rowakeri Awinkatharite jirika eentsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ikanta Zacarías, ashitakariri eentsi, ikantakaanakari Tasorenkantsi, ikenkithawaitanake, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kameethari rinatzi Awinkatharite Pawa, Iwawanetari Israel-iite, Ripokake retsinaryaakoyetai. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Rotyaantakairi matzirori rowawisaakoshiretantzi, Iriitake incharinetyaari David-ni, tema iriitake rimperatane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iro ikenkithawaitakaakeriri pairani tasorentsitatsiri Kamantantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iri owawisaakotaine itzimawetaga kisaneentayetairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tema ineshironkatairi ikaatzi acharineyetakari, Eero ipeyakotziro tasorentsitatsiri raapatziyawakaantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Irootake jiroka ikashaakagaitakeriri pairani acharineni Abraham, Onkaate rantzimotairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Rontsiparyaakowentai itzimawetaga kisaneentairi, Tekaatsi anthaawantya ankemisantairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kiteshire ankantaiya. Kameethashire ankantawentaiyaari maawoini kiteesheriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Irooma eeroka notomi, iitaitemi iyamantanewo Jenokisatzi. Tema eerokatake jewatakeriri Pinkathari, piwetsikaanteri tsika inkenayetanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Eeroka kamantairine asheninkapaini, iro riyotantyaari iriitake owawisaakotantaneri. Iri peyakotakagairine ikaariperoshirewaiwetaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tema antawoite ineshironkatakai Pawa, Rotyaantakairi poñaachari inkiteki roshiyapaakawo okantaganki owakera onkiteeshetamanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Inkiteesheetyaakotairi saikayetatsiri otsirenikitzi. Inkiteesheetyaakotairi eejatzi itsimankakowetakari raampare yotaantzirori riyaatantaitari sarinkaweniki. Iri oñaagantairone risaikaitzi kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kameetha ikimotatzi eentsi, ñaaperoshireri ikanta. Ari risaikawaitzi ochempiki, irojatzi imonkaatantakari roñaayaari Israel-iite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ikanta Pinkathari César Augusto, ikantakaantake rosankenatakotya maawoini atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aripaite omapokaka rosankenatakoyeetya reewatakaantantari Cirenio janta Siria-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Maawoini atziri riyaatake rosankenatakotya inampiki tsika ipoñaayeta pairani icharine. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Irojatzi ritonkaantanakari José irirori, ipoñaanakawo Nazaret saikatsiri janta Galilea, riyaatero nampitsiki tsika itzimake pairani Pinkathari David, oita Belén saikatsiri janta Judea-ki. Tema jirika José icharine rinatzi David-ni. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ari rosankenatakotyaari irirori intsipatyaawo iinathori María, tsika otzimi ikashaakari rayero. Iro kantzimaitacha motzitake iroori. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ikanta rareetaiyakani Belén-ki, tzimaanitzimatake María. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ari itzimakeri etanakawori otomi. Oponatakeri, omaryaakeri rowamentoki piratsi, tema te oñaapaake tsika imaapaake. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Okanta jantyaatsikaini nampitsi, eenitatsi kakiwentziriri tsireniriki ipira oweja ikempoyiiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ari roñaagakari imaninkarite Awinkatharite. Roorentantapaakari rowaneenkawo, antawoite ithaawaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Riñaanatapaakeri, ikantziri: “Eero pithaawashita. Namatziimiro Kameethari Ñaantsi, iro oimoshirenkairine maawoini atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tzimataike owawisaakotantaneri inampiki pairani pinkathari David-ni, iriitake Cristo Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jiroka piyotantyaariri: Ari piñaakeri imponaiteri eenchaaniki romaryagaitakeri rowamentoki piratsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iñagaitatzi ikoñaatapaake osheki inkiteweri itsipatapaakari maninkari, romampaawentapaakari Pawa, ikantaiyini: ");
INSERT INTO cpbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Iro kameethaperotatsi oshekitzimotziri rowaneenkawo Pawa nampitawori ojenokiperotzinta inkite! ¡Risaikayetai kameetha ineshironkatanewopaini jaka kipatsiki! ");
INSERT INTO cpbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ikanta riyaataiyanaini maninkariite inkiteki, ikantawakaanaka kempoyiiriri oweja: “Jame aate Belén-ki, aminakitero oita awisaintsiri. Ari añeero ikamantakaantakairi Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Shiyaiyanakani, irojatzi iñaantapaakawori María otsipatakari José, omaryaakeri eenchaanikite rowamentoki piratsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ikanta iñaapaakeri, ikamantantapaake okaatzi ikantakeriri inkaaganki maninkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyokitziiwenta rowaitawakeri kempoyiiriri oweja ikemaitzirira ikamantantapaake. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Irooma María, antawo okenkithashiretakotawo iroori okaatzi ikantaitapaakerori. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Irojatzi ripiyaiyantanaarini kempoyiiriri oweja, thaamenta ikanta romampaawentanaari Pawa, tema iñaakero okaatzi ikamantaitakeriri inkaaganki. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maakotapaake 8 kiteesheri eenchaaniki, ragaitanakeri ritomeshaanitaiteri. Irojatzi iitantaitakariri JESÚS, tema ari iitzitakariri ketziroini maninkari tekera omotzitziriita María. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Okanta imonkaatapaaka omairentaiyanira onkitewathatantaiyaari, tema iro Inintakaantakeri Moisés-ni. Ari ragaitanakeri Jesús Jerusalén-ki rashitakaityaari Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iro imonkaatantyaawori Osankenarentsipero Inintakaantziri Awinkatharite, kantatsiri: Iriirika shirampari omapokanewo tsinane, Rashitakaityaari Pinkathari, intasorentsite rinatye. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Rimatantyaawori rimonkaatairo Inintakaantanewo Pinkathari, ontzimatye ritagainiri Pawa: Apite konthawo, eerorika apite iryaani shiro. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Eenitatsi itsipa atziri janta Jerusalén-ki iita Simeón. Tampatzikashireri rinatzi, pinkathatasorentsitantaneri ikanta, tema iri risaikashiretantakari Tasorenkantsi. Iriitake oyaakoneentawori roimoshirenkaitairi Israel-iite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Riyoshiretakaakeri Simeón Tasorenkantsi, eero ikamita irirori irojatzi iñaantakyaariri Risaipatziitotane Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ikantakaakari Tasorenkantsi, pokake tasorentsipankoki. Ikanta ashitariri Jesús, raanakeri tasorentsipankoki rimonkaatantyaawori Inintakaantaitanewo, ");
INSERT INTO cpbNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ithomaawakeri Simeón jirika eenchaaniki, riwetharyaanakari Pawa, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Monkaataka Pinkathari okaatzi pinintakaakenari, Pishinetena iroñaaka nonkame, tema pimperatanewo powana. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tema noñagairi owawisaakotantaneri, ");
INSERT INTO cpbNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iriitake potyaantakeri owawisaakotairine atziripaini, ");
INSERT INTO cpbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iri kiteesheetyaakotairine atziri kaari asheninkata, Iri kantakayaawone impinkathayeetantyaariri Israel-iite. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iyokitziiwenta rowaitanakeri ashitariri, ikemakowentzirira ikenkithatakoitziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ikanta Simeón riwetharyaawentakari eenchaaniki, ikantanakero inaanate: “Jirika, iri kantakayaawone impeyawaitashitantaiyaari osheki asheninka Israel-iite, oshiyawaityaawo rontziwatatyeeyaame, iri kantakayaawone eejatzi rawisakoshiretantaiyaari osheki, oshiyawaityaawome impiriintaatyeeme rontziwataka. Tema osheki inkantaite: ‘Kaari irooperori ñaantsi riñaaneyeetakari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tema jirika eenchaaniki iri oñaaganterone onkaate inkenkithashiretaityaari. (Iro kantzimaitacha antawoite powashiretanakya eeroka kemewaitaka rowathagaitatyeemime.)” ");
INSERT INTO cpbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ari isaiki eejatzi tsinane jitachari Ana, kamantantanewo inatzi iroori, rishinto Fanuel icharinetanakari Aser. Antawokitake iroori. Aawetaka oime eeniro omainawoweta, 7 osarentsi otsipawetakari oime. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kinankawo inatzi, tzimake 84 osarentsite. Ari ashi owatziiro isaiki tasorentsipankoki, okamaitawo kiteesheriki eejatzi tsireniriki amana, itziwentakawo eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ari ipokapaakeri jiroka tsinane, iwetharyaapaakari Pawa. Okenkithatakotanakeri eenchaaniki, ikemaiyakeni ikaatzi oyaakoneentzirori rookaakowentaiteri Jerusalén-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Rimonkaatakerowa okaatzi Inintakaantayetziri Pinkathari, piyaawo Galilea-ki isaikira inampi Nazaret. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Thaamenta ikanta ikimotatzi eenchaaniki, eekero riyaatatzi ishintsitzi, yowaiyantzi rinatzi. Kempoyaawenta rowakeri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ari ikantapiintatya osarentsiki ashitariri Jesús riyaatzi Jerusalén-ki roimoshirenkiro Anonkoryagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tzimake Jesús 12 rosarentsite, jataiyakeni Jerusalén-ki tema iro rametaiyapiintarini roimoshirenkawaita. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ari ithonkapaaka roimoshirenkaiyani, piyaiyaani ashitariri, irojatzi risaikanake Jesús Jerusalén-ki, te riyotzimaita ashitariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iñaataawetakari jewatanake Jesús itsipayetanaari ikaataiyini. Tzimakotake apaani kiteesheri ranashitaka, ari ikowawetaari, rosampiwetakari isheninkapaini ikaatzi riyaataiyini. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Te iñiiri. Piyanaawo Jerusalén-ki raminapanaantziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mawa kiteesheri iñaantaariri risaiki tasorentsipankoki, ikenkithawaitakaayetziri yotakotzirori Inintakaantaitanewo, rosatekaitakeri niyanki, rosampiminthaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyokitzii ikantaita iñagaitzirira imapero riyowaitzi, rakayetakero kameetha okaatzi rosampitaitziriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ikanta iñaapairi ashitariri, iyokitzii ikantapaaka irirori. Okantapaakeri inaanate: “Notomí, ¿tsika pinkantenaka? Osheki naminaminatakemi notsipatari pipaapate, antawoite pominthaawashiryaakena.” ");
INSERT INTO cpbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Irojatzi rakantanakari irirori, ikantanake: “¿Iitaka pithotyaakotantanari? ¿Tema piyote okowaperotatya nanteniri ikowakaanari Ashitanari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iri kantacha ashitariri te ikemathatziro okaatzi ikantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Raanairi, jataiyaini Nazaret-ki. Rantziro maawoini okaatzi rimperatariri ipaapate. Iro kantacha kenkithashire owakotakeri inaanate. ");
INSERT INTO cpbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eekero ithaamentatya Jesús ikimotatzi, osheki riyorenka. Kempoyaawenta rowiri Pawa. Ari ikantzitariri eejatzi atziripaini neshironka rowiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ari imonkaataka 15 osarentsi ipinkathariwentantzi Tiberio César. Ari reewatzi irirori Poncio-ki Pilato janta Judea-ki. Iriima Herodes reewatzi irirori Galilea-ki. Iriima Felipe irirentzi Herodes, reewatzi irirori Iturea-ki eejatzi Traconite-ki. Ikanta Lisanias, reewatzi irirori Abilinia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Iriima Anás itsipatakari Caifás reewatziri irirori Imperatasorentsitaarewo. Aripaite riñaanashiretakeri Pawa itomi Zacarías jitachari Juan janta ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Irojatzi ikenayetantanakari Juan intatsikero Jordán-ki, ikenkithatakotziro omitsitsiyataantsi, ikantzi: “Pomitsitsiyawentaiyaari Awinkatharite, pipakagairo pantayetziro kaariperori, ari impeyakotakagaimiro pikaariperoshirewetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tema iro rosankenatakeri pairani Isaías Kamantantaneri, ikantake: Inkamantantaite paata janta ochempiki, inkantaite: Powameethatainiri Pinkathari tsika inkenapaake, Poshiyakairo rotampatzikaitziro awotsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Onkameeropathayetai otenkanaayetzira, Onkarenipathayetai otzishi. Tampatzika inaatye awotsi tzipiwokiwetachari, Mameripatha onkantayetaiya. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ari iñeero maawoini atziri tsika ikanta Pawa rowawisaakotantzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ikantayetawakeri atziri pokayetaintsiri romitsitsiyaatya: “Te pikameethashiretaiyini eeroka, poshiyashitakari maanke. ¿Piñaawetaka eero rowasanketaitzimi? ");
INSERT INTO cpbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kyaaryooperorika pipakagairo jimpe pikantaweta pairani, pinkameethashireyetai, poshiyaiyaawo pankirentsi kithokitatsiri. Eero pikantashirewaitashita: ‘Tema naaka icharineni Abraham, te okowaperota nipakagairo nokaariperoshirewaitzi.’ Pinkeme nonkante: Arika inkowerikame Pawa, kantacha ratziritakairome jiroka mapi, iro poyaataiyaarine icharineyetakari Abraham-ni. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pankirentsi kaari kithokitatsi, ritowaitziro ritagaitero. Ari inkantayeetaimi eeroka eerorika pikameethashireyetai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ikanta atziripaini rosampitanakeri, ikantziri: “¿Oitaka nantairi?” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ari rakanakeri, ikantzi: “Eenitatsirika apite piithaare, pimperi apaani kaari otzimimotzi. Tzimatsirika powanawo, ari pinkantero eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Irojatzi ripokantapaakari apatoyetziriri koriki ikowi romitsitsiyaatya, ikantapaakeri: “Pinkathari, ¿oitaka nantairi naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ikantakeri: “Eero panaakairo onkaate pinkowakotanteri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ikanta owayeripaini Roma-satzi, rosampitakeri eejatzi, ikantziri: “Naaka, ¿iitaka nantairi?” Rakanakeri, ikantzi: “Eero pasariimatanta, eero pithaiyakotanta ompoñaantyaari paapithateri atziri tsikarika oitya. Pinkinatyaari ikaatzi ripinaitzimiri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Osheki atziri aamaakariri Juan, ikantashiretaiyini: “¿Kaarima jirika Cristo?” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ari ikantanakeri Juan maawoini atziri: “Naaka apatziro nomitsitsiyaatantawo ñaa. Iro kantzimaitacha, awotsikitake maperotzirori ipinkatharentsitzi, nopinkathatzitari naaka. Te onkantaatsikaitya roshiyakaina naaka rimperatanewo no-zapato-ryaantyaariri. Iriitake kemetakaantyaawone romitsitsiyaatantatyeeyaarime Tasorenkantsi, romitsitsiyaatantatyeeyaarime eejatzi paampari. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tema arika ankowiitero awankire, otekakitziro, irojatzi ataantakyaawori otaaki. Iro aye okithoki, otekitakero, owakotakero. Ari inkantaiyaari Awinkatharite eejatzi, rinashiyetaiyaari atziri. Ineshironkayetairi inkaate kemisantanairine, iriima kaari pakairone ikaariperoshirewaitzi, ritagairi paampariki kaari tsiwakanetatsine.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Osheki ikaminaantakeri Juan ikenkithatakairi atziripaini Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rimatakeri eejatzi Herodes pinkatharitatsiri, ikaminaawetakari, raakero Herodías iinantawetari Felipe irirentzi. Tema tzimatsi otsipa kaariperori rantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iroowa owatsiperotakerori rantakeri Herodes romonkyagaitziri Juan. ");
INSERT INTO cpbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ikanta Juan romitsitsiyaayetziri osheki atziri, ari romitsitsiyaatakari Jesús irirori. Ramanaminthaita Jesús, kemewaitaka ashitaryaanakityeeyaame inkite, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iñagaitatzi ripokashitakeri Tasorenkantsi ikenapaake jenoki roshiyapaakari shiro. Ikemaitatzi inkiteki ikantaitanake: “Eerokatake Notomi netakoperotanewo. Osheki nokimoshirewentakemi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ikanta Jesús retantanakawori rantayetakeri, ari tzimake 30 rosarentsite. Ikantaitzi iri tomintakariri José. Tomintanakariri José iita Elí, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","tomintanakariri Elí iita Matat, tomintanakariri Matat iita Leví, tomintanakariri Leví iita Melqui, tomintanakariri Melqui iita Jana, tomintanakariri Jana iita José, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","tomintanakariri José iita Matatías, tomintanakariri Matatías iita Amós, tomintanakariri Amós iita Nahum, tomintanakariri Nahum iita Esli, tomintanakariri Esli iita Nagai, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","tomintanakariri Nagai iita Maat, tomintanakariri Maat iita Matatías, tomintanakariri Matatías iita Semei, tomintanakariri Semei iita José, tomintanakariri José iita Judá, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","tomintanakariri Judá iita Joana, tomintanakariri Joana iita Resa, tomintanakariri Resa iita Zorobabel, tomintanakariri Zorobabel iita Salatiel, tomintanakariri Salatiel iita Neri, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","tomintanakariri Nateri iita Melqui, tomintanakariri Melqui iita Adi, tomintanakariri Adi iita Cosam, tomintanakariri Cosam iita Elmodam, tomintanakariri Elmodam iita Er, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","tomintanakariri Er iita Josué, tomintanakariri Josué iita Eliezer, tomintanakariri Eliezer iita Jorim, tomintanakariri Jorim iita Matat, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","tomintanakariri Matat iita Leví, tomintanakariri Leví iita Simeón, tomintanakariri Simeón iita Judá, tomintanakariri Judá iita José, tomintanakariri José iita Jonán, tomintanakariri Jonán iita Eliaquim, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","tomintanakariri Eliaquim iita Melea, tomintanakariri Melea iita Mainán, tomintanakariri Mainán iita Matata, tomintanakariri Matata iita Natán, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","tomintanakariri Natán iita David, tomintanakariri David iita Isaí, tomintanakariri Isaí iita Obed, tomintanakariri Obed iita Booz, tomintanakariri Booz iita Salmón, tomintanakariri Salmón iita Naasón, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","tomintanakariri Naasón iita Aminadab, tomintanakariri Aminadab iita Aram, tomintanakariri Aram iita Esrom, tomintanakariri Esrom iita Fares, tomintanakariri Fares iita Judá, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","tomintanakariri Judá iita Jacob, tomintanakariri Jacob iita Isaac, tomintanakariri Isaac iita Abraham, tomintanakariri Abraham iita Taré, tomintanakariri Taré iita Nacor, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","tomintanakariri Nacor iita Serug, tomintanakariri Serug iita Ragau, tomintanakariri Ragau iita Peleg, tomintanakariri Peleg iita Heber, tomintanakariri Heber iita Sala, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","tomintanakariri Sala iita Cainán, tomintanakariri Cainán iita Arfaxad, tomintanakariri Arfaxad iita Sem, tomintanakariri Sem iita Noé, tomintanakariri Noé iita Lamec, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","tomintanakariri Lamec iita Matusalén, tomintanakariri Matusalén iita Enoc, tomintanakariri Enoc iita Jared, tomintanakariri Jared iita Mahalaleel, tomintanakariri Mahalaleel iita Cainán, ");
INSERT INTO cpbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","tomintanakariri Cainán iita Enós, tomintanakariri Enós iita Set, tomintanakariri Set iita Adán, tomintanakariri Adán iriitake Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ikanta ripiyaawo Jesús ipoñagaawo Jordán, risaikashiretantakari Tasorenkantsi. Ikantakaanakari Tasorenkantsi, jatake ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ari risaikakeri okaatzi 40 kiteesheri, irojatzi ikowantawetakari Kamaari inkaariperotakairime. Tema tekaatsi rowaiyaa janta, ayimatakeri ritashe. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pokake Kamaari, ikantawetapaakari: “Imaperotatyaarika Itomintzimi Pawa, pimpeyero pan jiroka mapi, poyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ari rakanakeri Jesús, ikantanakeri: “Eenitatsi osankenarentsi kantatsiri: Te apatziro okowimotari atziri royaawo pan, iroowa kowaperotachari ankemisantairo maawoini ikantairi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ikanta Kamaari raanakeri Jesús ochempiki, rampaaretakaapaintari maawoini nampitsi ipinkathariyetzira atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ikantziri: “Ari nonkantakaakyaawo impinkathayetaimi maawoini piñaayetakeri, ari nompakemiro eejatzi rowaneenkawo. Tema irootake rashitakaayeetakenari naaka maawoini, ari nimatakero nomperi itzimirika nokowiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Arika potziwerowashitakena piñaapinkathatena, maawoini ikaatzira piñaakeri, eeroka ashitanaiyaawone.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ari rakanakeri Jesús, ikantziri: “Eenitatsi osankenarentsi, kantatsiri: Apatziro ampinkathatairi Awinkatharite Pawa, iri ankemisante apaani.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ikanta Kamaari raanakeri nampitsiki Jerusalén, risaikaakeri jenoki omitzikaaki tasorentsipanko, ikantapairi: “Kyaaryooperorika Itomintzimi Pawa, pimitaye isaawikinta kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tema eenitatsi osankenarentsi, kantatsiri: Rotyaantemiri Pawa imaninkarite aamaakowentemine, ");
INSERT INTO cpbNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iri thomaawakemine, Eero pomposantapaaka mapiki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ari rakanakeri Jesús, ikantziri: “Aritake ikantaitake pairani: Te okameethatzi piñaantashiwaityaari Piwinkatharite Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ikanta Kamaari te rotsinampaashitari Jesús inkaariperotakairi, rintainaryaapithatapaintziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ikanta ripiyaawo Jesús Galilea-ki, ityaakari ishintsinka Tasorenkantsi. Rithonka ikemakoitanakeri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Riyotaantayetake maawoini tsika rapatotapiintaita. Thaamenta ikantawentakari maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ikanta Jesús piyaawo inampiki Nazaret tsika rantaritake. Okanta kiteesheri rimakoryaantaitari, jatake Jesús rapatotapiintaitaga, tema iro rametapiintari irirori. Ari ikatziyanakari riñaanatero osankenarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ipaitakeri rosankenare Kamantantaneri Isaías-ni. Ikanta rampinairyaakero osankenarentsi, iñaatziiro rosankenaitakero, kantatsiri: ");
INSERT INTO cpbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Risaikantana naaka Itasorenka Awinkatharite, Tema iri saipatziitotakenari ompoñaantyaari nonkenkithatakoteniri ashironkainkari Kameethari Ñaantsi. Irijatzi otyaantakenari nowawisaakoyetairi okantzimoneentayetari. Nonkamantairi romonkyaakaantaitziri tsika inkantaiya rontsiparyaakowentayeetairi. Ari naminakaayetairi kaari kowichaatatsine, Nisaikakaashiwaitaiyaari ikaatzi rimperaitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nonkenkithatakoyetairo tsikapaite raakameethatantai Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Irojatzi rampinaitantanaawori Jesús osankenarentsi, ipanairi kenkithatakaantapiintatsiri, saikanake. Iyokitzii ikantanaka maawoini atziri ikaatzi saikaintsiri rapatotapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ari retanakawo ikantanakeri piyotainchari: “Imonkaatzimoyetakemi iroñaaka jiroka osankenarentsi okaatzi pikemakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyokitziiwenta ikantaitanakeri Jesús, tema kameetha okanta ikenkithatakoyetziri. Osheki kenkithatakoyetanakeriri kameethaini. Ikantaitzi eejatzi: “¿Kaarima jirika itomi José?” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Irojatzi ikantantanakariri: “Aamaaka ari pinkantakena: ‘Janjaatya paawintya eeroka aawintantzinkari. Tema osheki nokemakowentakemi pantayetakeri Capernaum-ki, janjaatya pantapairo eejatzi jaka pinampiki.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eekero ikantanakitzi Jesús: “Imaperotatya nonkantemiri, ashi rowatziiro Kamantantaneri te ipinkathaitziri inampiki tsika risaikayetzi isheninka. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tema imaperotya jiroka, pairani eeniro risaikawetani Elías, te oparyagai inkani janta Israel-ki okaatzi mawa osarentsi eejatzi 6 kashiri. Antawoite ritasheneentaitake. Osheki kamatsiri oime saikawetachari janta, ");
INSERT INTO cpbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","iro kantzimaitacha, te rotyaantaitziri Elías-ni riyaatashitero kamatsiri oime, apatziro rotyaantaitakeri nampitsiki Sarepta saikatsiri Sidón-ki, isaikira tsinane kamatsiri oime kaari isheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ari oshiyakawo eejatzi eeniro risaikaweta Kamantantaneri Eliseo, tzimawetachaganki Israel-ki osheki mantsiyari pathaawaitatsiri. Iro kantzimaitachari te rotyaantaitziri Eliseo retsiyatakotakagai apaani, apatziro rotyaantaitakeri Naamán kaari isheninkata poñaachari nampitsiki Siria, retsiyatakotakagairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ikanta ikemaiyakeni ikaatzi saikaintsiri rapatotapiintaitaga, antawoite ikisaiyanakani. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ikatziyaiyanakani, ragaitanakeri Jesús iweyaathapitaga nampitsi, ikenakaitanakeri tsika isaiki impeeta rotziryagaiterime. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Iri kantamaitacha Jesús, rishiyapithatanakari rosatekantanakari niyankineki, jatai. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ikanta Jesús oirinkanaa nampitsiki Capernaum saikatsiri Galilea-ki. Riyotaantayetapai kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tema te omaanta ishintsinka riyotaantzira, iyokitziiwenta ikantaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Okanta janta tsika rapatotapiintaita, ari risaikakeri atziri raayiri peyari, kaimanake shintsiini irirori, ");
INSERT INTO cpbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ikantzi: “Piñaaminthatashitena Jesús Nazaret-satzi, niyotzimi naaka eerokatake itasorentsite Pawa. Iro pipokantari jaka pithonkaiyenani.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ikisathatanakeri Jesús, ikantanakeri: “¡Pimairete peyari, piyaatai! Tyaanake atziri rintainaryaapithatanakeri iweyarite, temaita rowaariperowaitanakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyokitziiwenta ikantawentanakari maawoini, ikantawakaiyanakani: “¿Iitatyaakama jirika? Rotsinampairi romishiyiri peyari richeraimotzirira.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ari ithonka ikemakoitanakeri Jesús maawoiniki nampitsi okaatzi saikatsiri janta. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ikanta rishitowanake Jesús rapatotapiintaitaga, kyaapaake ipankoki Simón. Okanta riyote Simón, imatakero antawoite katsiirentsi. Ikantaitawakeri Jesús retsiyatakotakaapairo. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Roiyotashitanakawo omaryaakaga, kemewaitaka richeraimotakityeerome katsiirentsi. Etsiyatakotanake osaawakiweta, piriintanaka aminawakeniri oita ompawakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Okanta otsireniityaanake, ramaitapaakeniri Jesús osheki atziri kantawaiyetachari imantsiyare. Ikanta iñaawakeri Jesús, apatziro riterotantawakari rako, etsiyatakoyetanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Osheki romishitowitakeri eejatzi iweyarite, antawoite ikaimayetzi peyari, ikantzi: “¡Itomi Pawa pinatzi!” Iri kantzimaitacha Jesús, ikisathayetakeri peyari, te rishineteri inkenkithawaite, tema riyotake peyari iriitake Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Okanta okiteeshetamanai, ananinkanake Jesús apaniroini ikenanake ochempiki. Osheki aminaminatairiri tsikarika ikenake. Ikanta iñagaitairi, te rishineetairi riyaatai. ");
INSERT INTO cpbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Irojatzi ikantantanakari Jesús: “Ontzimatye inkemaitero eejatzi otsipaki nampitsi Kameethari Ñaantsi kenkithatakotziriri ipinkathariwentantaira Pawa. Tema irootake nipokantakari naaka jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eekero riyaatakaanakitziiro Jesús ikenkithatanake pankotsikipaini rapatotapiintaitaga saikatsiri Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Okanta kiteesheri, risaiki Jesús inkaarecheraaki Genesaret. Ranawiimatakeri atziri ikaatzi piyowentakariri ikemisantziro riñaane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ari iñaake Jesús apite pitotsi aataka othapyaaki. Tekaatsi otetantyaawone, tema ikiwaiyatziironi itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Otetapaaka Jesús pitotsiki. Tema iri ashitawo Simón jiroka pitotsi, ikantakeri rotyaantero eepichokiini niyankyeeronkaini. Ari risaikantanakawo Jesús pitotsi, retanaawo riyotaayetanairi atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ikanta rithonkanakero riyotaantzi, ikantzi: “Simón, paanakero pipito niyankyeeronkaini, ari pintarajaateri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ari rakanake Simón, ikantzi: “Ari notarajaaweta tsireniriki, tekaatsi naye. Eerokarika kantanari, aritake nimatakero.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Rimatakero itarajaatzi, raake osheki shima, iro isagaimateme itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ikaimawakotanakeri ikaataiyapiintzinira itarajaatzi ramitakoteri. Ikanta riyaatashitanakeri, ikenakotanake otsipaki pitotsi, riyeekitantakawo apitekeroini, iroowetainchame ritsitsiyakotaiyenime. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ikanta iñaakero Simón Pedro awisaintsiri, rotziwerowashitanakari Jesús, ikantanakeri: “Pintainaryaapithatena Pinkatharí, kaariperoshireri ninatzi naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tema antawoite ithaawanake Simón iñaakerira osheki raake shima. Ari ikantaiyanakani eejatzi maawoini itsipapaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Rimatzitanakawo Jacobo eejatzi Juan, itomipaini Zebedeo, tema iri itsipatakari Simón. Iri kantzimaitacha Jesús ikantanakeri Simón: “Eero pithaawashiwaita, oshiyaiyaawo iroñaaka nontarajaatakagaimiri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ikanta raatakotaiyapaini, rookanawentanakero maawoini, royaataiyanakerini Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Okanta otsipa kiteesheri rareetaka Jesús nampitsiki, ari ripokakeri imatziri pathaawontsi. Ikanta iñaapaakeri Jesús, rotziwerowashitapaakari, ikantapaakeri: “Pinkatharí, pikowirika petsiyatakotakagaina, niyotzi tzimatsi pishintsinka petsiyatakotakaantantenari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Irojatzi retakotantanakariri Jesús, riterotantakari rako, ikantziri: “Nokowi, petsiyatakotai.” Etsiyatanake ripathaawaiwetaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ari ikantziri: “Te nokowi pinthawetakotena. Apatziro powanakero piyaatashiteri Imperatasorentsitaarewo, pimonkaatero rosankenatakeri Moisés-ni, paanake pinkitewathatantaiyaari, riyotantaityaari etsiyatakotaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iro kantzimaitacha ikemakoitanakeri intaina Jesús. Osheki atziri piyowentakariri ikemisantziri. Ikowaiyini retsiyatakotakaayetairi eejatzi mantsiyaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iri kantacha Jesús risaikawaitapiintzi irirori ochempiki, ari ramanari. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Okanta otsipa kiteesheri riyotaantzi Jesús, ari risaikaiyakeni Fariseo itsipayetakari Yotzinkariite, poñaayetachari nampitsiki Galilea, Judea, eejatzi Jerusalén-ki. Tema ityaakari Jesús ishintsinka Awinkatharite, kantacha retsiyatakotakaayeteri mantsiyari. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Irojatzi rareetantaiyapaakarini atziri inatakotakeri shitashintsiki kisopookiri. Ikowawetaiyakani inkyaakaapaakerime pankotsiki, romaryaakoterime risaikakera Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Te okanta inkyaakairi, tema piyochonchoitaka atziri. Rataitakaanakeri jenoki pankotsiki, imoontakero pankotsi, rowayiitakotakeri mantsiyari ikatziyajaantakaga Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ikanta Jesús riyotakotawakeri osheki rawentaakari, riñaanatawakeri mantsiyari, ikantziri: “Asheninká, ipeyakotaitaimiro pikaariperoshirewetaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ikanta ikemawake Yotzinkariite itsipayetakari Fariseo, ikantashiretaiyanakeni: “Rithainkatziiri Pawa jirikawé. Tema tekaatsi materone impeyakotakaantero kaariperori, apatziro ikantakaawo Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iri kantzimaitacha Jesús riyoshiretakotakeri, ari rosampitziri: “¿Oitaka pikenkithashiryaawaitantari? ");
INSERT INTO cpbNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tema okameethatzi nonkante: ‘Ipeyakotaitaimiro pikaariperoshirewetaka?’ Irooma pikowi nonkanteri: ‘Pinkatziye, piyaatai.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iroñaaka piyoteri Itomi Atziri oshekitzimotziri ishintsinka, ari impeyakotairi kaariperoshirewetachari.” Ripithokashitanakari mantsiyari, ikantziri: “Pinkatziye, paanairo pishitashi, piyaatai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Piriintanaka kisopookiri, raanairo ishitashi romaryaantawetari. Iñagaitawairi riyaatai ipankoki, kimoshire ikantawentanakari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyokitziiwenta ikantanaka maawoini atziripaini, ikimoshirewentanakeri iriroripaini Pawa. Ithaawankakiini ikantaiyini: “Te añaapiintero oshiyaawone jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ikanta rishitowanai Jesús, iñaapaakeri jitachari Leví risaiki rapatotziriri koriki, ikantapaakeri: “Poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Katziyanaka Leví, rookanawentanakero maawoini, royaatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ikanta Leví, raanakeri Jesús roimoshirenkya ipankoki itsipataanakeri riyotaanewo. Ari riyaatakeri eejatzi osheki apatotziriri koriki, osheki jatayetaintsiri itsipa. Ari ikaataiyini rowaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ikanta Fariseo itsipatakari Yotzinkariite, riñaanaminthatakeri riyotaanewo Jesús, ikantziri: “¿Iitaka pitsipatantariri powaiyani kaariperoshireri pitsipatakari eejatzi apatotziriri koriki?” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Irojatzi rakantanakari Jesús irirori, ikantanakeri: “Arika imantsiyate atziri, ripokashitziri aawintantzinkari, iriima atziri kaari mantsiyatatsi tekaatsi inkowe irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te inta nipokashiteri naaka nonkaimashiretairi kameethashireri, tema nipokashitatziiri kaariperoshireri nonkaimashiretairi rookairo kaariperori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ikanta rosampiitakeri Jesús, ikantaitziri: “¿Iitaka kaari ritziwentanta piyotaanewo? Iriima rashini Juan, rashi eejatzi Fariseo-paini, osheki ritziwentapiintaiyani irirori, ramanaiyani eejatzi. Noñiiri piyotaanewo eeroka, te ritziwentawaita, owawaitacha, irawaitatsi imere.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Rakanake Jesús, ikantzi: “Arika intsipataityaari aawakaachari, ¿arima rowashireneentaitakya? ");
INSERT INTO cpbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Arika paata ragaitakeri iimentaitari, aripaite ritziwentaitya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ari roshiyakaawentanakeniri Jesús, ikantziri: “Antyashipawo ikithaataitari, arikame rowamatankaitantyaawo osapeki owakerari, ari imaperotanakya isagaaperotanake arika aminthatanakya owakerari. Te irooperotakairo antyashipawo ikithaataitari rowamatankaitantyaawome owakerari. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te ikameethatzi eejatzi antyashipari mashitsinaki rowantaityaari eeryaatatsiri riraitziri. Arika rowantaitakyaari, ari risanaryaanake, apaawaitashitakya riraitziri, eejatzi inkemetakya mashitsinaki irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iri kameethatatsi owakerari mashitsinaki rowantaityaari eeryaari riraitziri. Eero rapaawaitanta apitekeroini. ");
INSERT INTO cpbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ikaatzi ametawori ririro poitatsiri, eero rametaawo rirairo eeryaari. Inkantapiinte: ‘Iro kameethatatsi arero poiri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Okanta kiteesheri rimakoryaantaitari, ikenanake Jesús pankirentsimashiki. Ikanta riyotaanewopaini ikowiitanake okithoki pankirentsi, ramirokakitzimaitawo inkene royaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Te inimoteri Fariseo-paini, rosampitakeri ikantziri: “¿Iitaka pikowiitantawori? ¿Tema piyote te ishinetaantsita kiteesheriki rimakoryaantaitari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Rakanake Jesús, ikantanake: “¿Tema piñaanatakoteri eeroka ikantaganki David-ni itsipayetakari ikaataiyini aantawetakari ritashe? ");
INSERT INTO cpbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ikyaake tasorentsipankoki, raakero pan tasorentsitatsiri, rowakawo irirori, ipakeri ikaatzi itsipayetakari. Tema te ishinetaantsiweta rowaityaawo, apatziro rowapiintawo Imperatasorentsitaarewo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Irojatzi ikantantakari eejatzi: “Jirika Itomi Atziri ipinkathariperotzi irirori, ranayiro jiroka kiteesheri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Okanta otsipa kiteesheri rimakoryaantaitari, ikyaake Jesús rapatotapiintaitaga, riyotaantapai eejatzi. Ari risaikakeri atziri kisoimpekitatsiri rakoperoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ikanta Yotzinkariite itsipayetakari Fariseo, aamaane rowakeri Jesús iñeeri arika retsiyatakotakagairi mantsiyari kiteesheriki rimakoryaantaitari, ontzimantyaari inkantakoteriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iri kantacha Jesús, riyotake irirori oita ikenkithashiretari. Ikaimakeri kisoimpekiri, ikantziri: “Pipoke, posatekya niyanki.” Pokapaake kisoimpekiri, katziyapaaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Irojatzi ikantantanakari Jesús: “Tzimatsi nosampitemiri: ¿Iitakama shinetaantsitatsiri anteri kiteesheriki rimakoryaantaitari? ¿Tema okameethatzi aneshironkatante, irooma kameethatatsi owamaante? ¿Tema okameethatzi etsiyatakotakaante, irooma kameethatatsi ankaariperowaite?” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ikempoyaanakeri piyowentakariri, irojatzi riñaanatantanakariri mantsiyari, ikantziri: “Pampiryaawakotai.” Matanaka, akotsitanai kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iri kantzimaitacha jirikapaini, antawoite ikisaiyanakani. Ikenkithawaitaiyakeni tsika inkanteri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ikanta ritonkaanake ramañaari Pawa. Ari ikamaitawo maawoini tsireniriki ramana. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Okanta okiteeshetamanai, ipiyotakeri maawoini riyotaanewo. Ari riyoyaake ikaatzi 12, iriitake jitakeri Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jirika ikaatzi riyoyaakeri: Simón, irijatzi iitakeri Pedro. Ipoñaapaaka Andrés irirentzi Simón. Ipoñaapaaka Jacobo itsipataakeri Juan, Felipe, Bartolomé, ");
INSERT INTO cpbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo itomi Alfeo. Ipoñaapaaka Simón iitaitziri Jokaakowentantaneri, ");
INSERT INTO cpbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ipoñaapaaka Judas irirentzi Jacobo. Ipoñaapaaka eejatzi Judas Iscariote, iri pithokashityaarine paata. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ikanta roirinkaiyaani Jesús itsipataari riyotaanewo. Ari risaikaiyapaakeni owintenipathatzira. Osheki atziri piyowentapaakariri, Judea-satzi, Jerusalén-satzi, Tiro-satzi eejatzi Sidón-satzi. Ripokaiyakeni jirikapaini inkemero ikenkithatakotziri Jesús, ikowaiyatziini eejatzi retsiyatakotakagairi mantsiyaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tema ikaatzi raagayetziri peyari, retsiyatakotakaayetairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ikowaiyanakeni atziri riterotantawakyaari rako, tema oshekitzimotziri Jesús ishintsinka, retsiyatakotakaayetziri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ikanta raminanakeri Jesús riyotaanewo, ikantziri: “Kimoshire pinkantaiya ashironkainkari, tema eerokatake ñagairone impinkathariwentantai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kimoshire pinkantaiya piñaawetawowa pitasheyaneentawaitzi, tema irootaintsi piñagairo pinkemaneentaiya. Kimoshire pinkantaiya piñaawetawowa piraaneentawaita, tema irootaintsi piñeero pishirontawaitaiya. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kimoshire pinkantaiya onkantawetakya piñaawetyaawo inkisaneentaitemi, rookimawaitaitemi, inkaweyawaitaitemi, imanintawaitaitemi, okantakaantziro poshiretaarira Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Thaamenta pinkantayetaiya, pinkimoshireyetai, tema Pawa pinayetaimine inkiteki. Pinkenkithashiryaakotero tsika ikantaitakeri pairani etanakawori Kamantantaneriite, irojatzi awishimotemine eejatzi eeroka iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Inkantamatsitaitairi ashaagantzinkari! Tema iñaawetakawo ketziroini inintaawaitaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Inkantamatsitaitairi kemaneentachari! Tema ari iñagairo paata ritasheyaneentai irirori. ¡Inkantamatsitaitairi ñaayetzirori ishirontawaita! Ari iñagairo paata rashironkaawaitaiya, ari riraawaitaiyaari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Inkantamatsitaitairi rasagaawentaitari! Tema ari ikantaweetakari pairani oshiyakowetakariri Kamantantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Iro kantzimaitacha pinkeme nokantzi naaka: Petakotaiyaari ikaatzi kisaneentayetzimiri, paakameethayetairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Eero pipiyatari kishimawaitzimiri. Pamanakoyetaiyaari thaiyakoyetzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Arika ripasaitemi kashetawooni, pishinetaiyaari rimontewootemi ripasatemi. Arika inkowaite ragaitero piithaare posaawantapiintari, pishinetainiri raanakero pikithaatakari eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Arika inkantaitemi: ‘Pimpena’, ontzimatye pimperi. Arika rayitaitemiro pashitari, eero piñaawaitakotziro. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pikowirika retakoitemi, petawakyaawo eeroka petakotantya. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Iriirika petakotya etakoyetzimiri eeroka. ¿Kameetharinima jiroka? Tema te, iroowa rantapiintakeri kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iriirika paakameethatake aakameethatzimiri eeroka ¿Kameethatakema jiroka? Tema te, iroowa rantapiintakeri kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Arika inkantaitemi: ‘Pimpawakenawo, ari noipiyaimi paata’, irojatzi pimpantanakyaariri tema piyotzi ari rimataimi eeroka paata, ¿Kameethatakema jiroka? Tema te, iroowa rantapiintakeri kaariperoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Petakoyetaiyaari kisaneentayetzimiri, eero pipiyatari. Pimpantayete arika inkowakoitemi, eero poyaawenta rimataitaimi eeroka. Antawoite ripinataimi, itomintaimira Jenokisatzi. Imaperotatya retakoyetari irirori maawoini kaariperoshireripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikemetai Ashitairi retakotai, ari pinkantyaari eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Eero pikishimatantzi, rimataitaimikari eeroka paata. Eero piyakowentantzi, rimataitzimikari eeroka paata. Arika pimpeyakotakaante, ari rimataitaimi eeroka paata. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pantaneri pinatye, tema ari rimataitaimi eeroka paata, ranaakaitaimiro okaatzi pipantakeri. Eenitatsirika pantakeri, arira inkantaitaimi paata eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Irojatzi roshiyakaawentantanakanariri Jesús, ikantzi: “¿Kantachama rakathatawakaiya kaari kowichaatatsine? ¿Tema ari imparyaake apitekeroini omoonakiki? ");
INSERT INTO cpbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te iñagaitzi apaani riyotagaitziri rawisheri yotairiri. Irooma paata arika riyotaaperoitakeri ari roshiyaiyaari yotairiri pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Iitaka pikowantari pamineniri itsipa tyaakitzinkari rokiki? Petawaiyaawo eeroka paawairo antawo inchapetoki tyaakitakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Eero okanta pinkanteri pisheninka: ‘Pipoke, nayemiro tyaakitakemiri pokiki.’ Tema tzimatsi pokiki antawo inchapetopi tyaakitakemiri. ¡Owapeyimotantanerí! Petawaiyaawo paawairo eeroka tyaakitakemiri pokiki, onkene pamineniri pisheninka tyaakitainchari eepichokiini rokiki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Inchato saankanatatsiri ishooki, te iñagaitziro onkaariperote okithokiki. Irooma inchato sampiyashitatsiri, te kameetha iñagaitero onkithokite. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tema okaatzi kameethayetatsiri chochoki, tera okameethawaitashita apaniroini, iroowa kantakaawori owaato okameethatzi iroori. ¿Añiiroma higo onkithokitantyaawo owaato kitochee? ¿Kantachama uva onkithokitantyaawo kitochee eejatzi? ");
INSERT INTO cpbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ari ikantaari kameethashireri ikenkithashiryaapiintawo kameethari, irootake okameethatantari rantayetziri. Iriima kaariperoshireri te ikenkithashiryaapiintawo kameethari, irootake okaariperotantari rantayetziri. Tema okaatzi ikenkithashireyetari, irootake riñaaneyetakari eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Iitaka ikantantaitanari: ‘Pinkatharí, pinkatharí?’ Temaita rantaitanawo okaatzi nokantayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eenitatsi antanairori okaatzi nokantayetziri. Jirika roshiyakari: ");
INSERT INTO cpbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Roshiyakari atziri wetsikatsiri ipanko, ikiyashitakero itzinkami okisopathatzira, rowatzikakero. Irojatzi ipokantakari antawoite amaani, ookantapaakawo shintsiini pankotsi, te eewokiro. Tema rowatzikaitakitziiro kameethaini okisopathatzira. ");
INSERT INTO cpbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iriima ikaatzi peyakotzirori nokantayetziriri, kaari antanairone, roshiyakari atziri wetsikawetachari ipanko, temaita ikiyashitziro inthomoiki itzinkami. Okanta ipokake antawoite amaani, ookantapaakawo shintsiini, tyaanake. Te iñagaitairo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ari rithonkanakero Jesús ikenkithatakairi atziripaini, jatai nampitsiki Capernaum. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ikanta mantsiyatake retakoperotanewo ronampire reeware owayeripaini Roma-satzi, irootaintsi inkameme. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ari ikemakowentakeri Jesús, rotyaantake Itzinkamipaini Judá-ite, inkaimeri Jesús, retsiyatakotakagainiri ronampire. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ikanta riyaatashitakeri Jesús, ikantapaakeri: “Okowaperota pamitakoteri reeware owayeripaini, ");
INSERT INTO cpbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tema raakameethatapiintakena, riwetsikaiyakenani pankotsi napatotapiintaga.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ikanta Jesús, royaatanakeri. Iro rareetantyaarime ipankoki, ritonkyotakari isheninkathori reeware owayeri, iri itsipa rotyaantakeri, ikantapaakeri irirori: “Jesús, ikantakaantzimi jewari, ikantzi: ‘Kaariperori nini naaka, eero pikyaawankotana. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Irootake kaari niyaatashitantzimi noñeemi naaka. Apatziro nokowiro piñaane pinkantakaantawakeri nonampire, aritake retsiyatakotai. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tema eenitatsi imperatanari naaka, eenitatsi eejatzi owayeri nimperatari naaka. Arika nonkanteri: “Piyaate”, aritake riyaatake. Arika nonkante otsipa: “Pipoke”, aritake ripokake. Arika nonkanteri nonampire: “Pantero jiroka”, rimatziro rantziro.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Riyokitziitanake Jesús ikemawakerira, ikantanakeri itsipatakari: “Iriitake matakerori jirika ikemisantzi, te itzimi jaka Israel-ki asheninka oshiyaarine jirika. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ikanta ripiyaa pankotsiki rotyaantaitakeri, iñaapaatziiri onampirentsi, etsiyatakotai imantsiyawaiwetaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ikanta ikenanake Jesús nampitsiki jitachari Naín, iri itsipayetanaari riyotaanewo. Osheki eejatzi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iro rareetzimatya nampitsiki, ritonkyotakotantakari ragaitziri kaminkari inkitaiteri, apintzi rinatzi otomintari tsinane kinankawo. Osheki atziri oyaatakerori tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ikanta Jesús iñaawakero tsinane, antawoite retakoshiretanakawo. Ikantziro: “Ataama piraawaitaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ripokapaake okaakiini, ipampitapaakero rowantaitakariri. Katziyaiyapaakani natakotziriri. Ikantzi Jesús: “Ewankarí, eeroka niñaanatzi, pimpiriintai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Piriintanaa kamawetainchari kenkithawaitanai. Rakathatanairi Jesús irojatzi iriniroki. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Antawoite ithaawaiyanakeni ikaatzi ñaakeriri. Ikimoshirewentanakeri Pawa, ikantaiyanakeni: “Pokataike iriiperori Kamantantaneri.” Ikantaiyanakeni eejatzi: “Pokataike Pawa iri neshironkayetaine aaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ithonka ikemakoitanakero rantakeri Jesús maawoini Judea-ki, eejatzi otsipaki nampitsi okaatzi saikanampiyetzirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ikanta Juan ikemake irirori okaatzi awisaintsiri, ikamantapaakeriri riyotaanewopaini. Ari riyoyaake apite riyotaanewo, ");
INSERT INTO cpbNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","rotyaantakeri rosampiteri Jesús, inkanteri: “¿Eerokama iitaitziri ‘Pokatsine?’ Kaaririka eeroka, ¿Tzimatsima itsipa naamaiyaari pokatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ikanta ripokaiyakeni, iñaapaakeri Jesús, ikantapaakeri: “Rotyaantakena Juan omitsitsiyaatantaneri nosampitemi: ¿Eerokama iitaitziri ‘Pokatsine?’ Kaaririka eeroka, ¿Eenitatsima itsipa naamaiyaari pokatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eekero retsiyatakotakaayetatziiri Jesús kantawaiyetachari mantsiyari, raagayetziri peyari, rokiryaakaayetairi mawityaakiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Irojatzi rakantanakariri pokaintsiri, ikantanakeri: “Arika pipiyanai, pinkamantapairi Juan okaatzi piñaakeri eeroka nantakeri, okaatzi pikemakeri nokantakeri. Tema nokiryaakagairi mawityaakiri, nanashitakaayetaari kisopookiri, nokemakaayetairi matyokempitari, netsiyatakotakaayetairi imatane pathaawontsi, nowañaayetairi kaminkari, nokamantayetairi ashironkainkari Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Irootake inkimoshiretantaiyaari kaari kisoshirewentainane.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ikanta ripiyaiyanaani rotyaantanewo Juan, rosampitanakeri Jesús ikaatzi piyowentakariri, ikenkithatakotziri Juan, ikantziri: “¿Iitaka pikenkithashiretakotariri piñaakeri chapinki ochempiki? ¿Iriima piñaake oshiyawori sawoo ompironkatonkitakaawo tampyaa okantakaantziro te ithaamentashireta? ");
INSERT INTO cpbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Piñaakerima rowaneenkataka ikithaataka? Tema maawoini nintaawaitachari, owaneenkatachari ikithaata, risaikawankotziri pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iro piyaatashitantakariri piyotaiyakeni Kamantantaneri rinatzi. Rimaperotatziiro irirori ranaakeri Kamantantaneripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iriitake rosankenatakoitakeri pairani, riñaanatziri Pawa itomi, ikantzi: Notomí, ari notyaantake paata etyaawone inkamantakotemi, Iriitake wetsikaantemine tsika pinkenapaake eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nokantzi naaka: Atziripaini ikaatzi tzimayewetainchari, tekaatsi Kamantantaneri anairone riyotanetakari Juan. Iri kantacha inkaate impinkathariwentairi Pawa inkiteki, tsinampashiretaatsine janta, ranagairi irirori paata Juan.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iriima atziripaini itsipatakari apatotziriri koriki, riyotanai tampatzikashireri rinatzi Pawa, romitsitsiyaayetairi Juan. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Irima Fariseo-paini itsipatakari Yotzinkariite te rishineta romitsitsiyaateri Juan, ari rapaatzirori rantzimotanteri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Irojatzi ikantantanakariri Pinkathari Jesús: “¿Iitaka noshiyakayeri jirikapaini? ");
INSERT INTO cpbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Noshiyakagairi owashaantawairentzi eentsi arika roshiyakaawaitya ikaatzira reentsitaiyini, ikantawakaiyani: ‘Jame ashowiwaite omampaantyaari.’ Temaita ikowi. Ikantaweta eejatzi: ‘Jametya omampaawaitya owashiretantyaari.’ Temaita ikowi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Irootake rantayetakeri jirikapaini. Ñaayewetakariri Juan, ritzitapaakawo irirori owanawontsi, te ririro poiri, iro kantzimaitacha ikantaitakeri: ‘Peyarishireri rini.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Irojatzi ripokantakari Itomi Atziri, te ritzitawo irirori owanawontsi, ririro poiri. Ikantaitakeri: ‘Kaariperori rinatzi, owawairentzi rinatzi, shinkiyantzi, raapatziyari apatotziriri koriki, raapatziyari eejatzi kaariperoshireri.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tekaatsi oitzimaitya, tema yotzinkari ari riyoitairi paata imapero riyotanetzi, arika iñaaperoitairo onkaate awisayetatsine.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ikanta Fariseo raanakeri Jesús rowakayaari. Areetaiyakani ipankoki, saikapaake Jesús rowapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Okanta kaariperoshirero tsinane nampitawori janta, okemakowentakeri Jesús ripokake ipankoki Fariseo rowaiyaani, pokanake iroori amakotanake kasankaari owantawo onaki riwetsikaitziro mapinaki. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okatziyimotapaakari iitzikeroki Jesús, irayimotapaakari. Ithaatanaka oyaaki okiki ashetzitakeri iitzi, oshetantzimaitari oishi. Othoyitzitanakeri, isaitantanakari kasankaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ikanta jirika Fariseo amakeriri Jesús, iñaakeri, ikantashiretanake: “Rimaperotatyeeyaame jirika inkamantantaneriite, ari riyotakerome tsika okantawaita jiroka tsinane thotayitzitakeriri, kaariperoshirero inatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ikanta Jesús ikantanakeri Fariseo: “Simón, tzimatsi nokowiri nonkantemiri.” Ari ikantanake: “Janjaatya pinkantenawo yotaantanerí.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Irojatzi ikantantanakariri: “Tzimatsi Atziri, ipakeri iyorikite apite atziri. Apaani ipake 500 denario, iriima itsipa ipakeri 50 denario. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Okanta osamanitake, te rimatairi roipiyairi koriki jirika apite atziri, ipeyakoitairi rireewetanewo apitekeroini. Janjaatya pinkantena, ¿Itzimikama etakoperotantatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rakanake Simón: “Nokantzi naaka iri etakoperotantatsiri atziri ipeyakoperoitakeri rireewetanewo.” Ari ikantzi Jesús: “Irootake pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Raminanakero Jesús isaikakera tsinane, ikantziri Simón: “¿Piñaakero antakeri jiroka tsinane? Nokyaawankotakemi eeroka, temaita pipana ñaa nonkiwayitzitapaakyaari. Irooma jiroka tsinane, okiwayitzitantakenawo oyaaki shitowanaintsiri okiki, irojatzi oshetantantakenawo oishi. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te pinintawootawakena piwethatawakena eeroka, irooma jiroka tsinane osheki onintayitzitakena. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te pisaipatziitotantenawori eeroka oyeenka pankirentsi pimpinkathatena, irooma jiroka tsinane, isaitantakenawo kasankaari noitziki. ");
INSERT INTO cpbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Osheki okaariperoshirewetaka jiroka tsinane, impeyakoitainiro tema osheki onintakena. Iriima ikaatzi ipeyakoitziri eepichokiini, eepichokiini inintantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Irojatzi ikantantanakawori tsinane: “Ipeyakoitaimiro pikaariperoshirewetaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ikantaiyanakeni ikaatzi itsipataiyakarini: “¿Iitatyaakama jirika rimatantyaawori impeyakotakaantero kaariperori?” ");
INSERT INTO cpbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eekero ikantanakitziiro Jesús jiroka tsinane: “Piyaatai kameetha, iro pawisakoshiretantaari pikemisantanai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ikanta Jesús itsipayetakari 12 riyotaanewo, rithotyaakero nampitsi ikenkithatake, ikenkithatakotakeri Pawa tsika ikanta ipinkathariwentantai. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ari itsipatakawo eejatzi tsinanepaini okaatzi retsiyatakotakagairi raagawetawo peyari, eejatzi okaatzi mantsiyayewetachari. Jiroka okaatzi oyaatakeriri: María Magdala-sato raagawetari peyari ikaatzi 7, ");
INSERT INTO cpbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","opoñaapaaka Juana iina Chuza rimperatanewo Herodes, opoñaapaaka Susana. Ari otsipatakawo eejatzi otsipapaini tsinane okaatzi papiintziriri koriki Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ikanta ipiyowentapaakari Jesús osheki atziri poñaayetachari otsipaki nampitsi. Roshiyakaawentatziiniri okaatzi riyotaayetziriri, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Eenitatsi apaani pankiwairentzi jatatsiri impankiwaite. Ikanta rookakitakero iwankire, tzimatsi jokakitapainchari awotsiki, ithonka raatzikakitaitakero, ikanta ripokaiyakeni tsimeryaani, rowapaakawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tzimatsi otsipa jokakitapainchari omapipookitzira kipatsi. Okanta ishookawetanaka pankirentsi, sampiyashitanake, tema te irenkapathata kameethaini kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tzimatsi otsipa jokakitapainchari kitocheemashiki. Okanta ishookawetanaka, kamanake anaanakero kitocheemashi. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tzimatsi otsipa jokakitapainchari okameethapathatzira kipatsi, saankana okanta ishookapaake, kithokitanake. Apaanipaini shookapaintsiri kameethaini tzimayetai 100 okithoki.” Irojatzi ikantantanakari Jesús: “Kowirori inkemathatero, rowayempitatya inkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ikanta riyotaanewo Jesús rosampitanakeri oita oshiyakaawentachari okaatzi riyotaantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rakanakeri Jesús, ikantziri: “Eerokapaini nonkamante kaari piyowetaiyani, ontzimatye piyotairo tsika ikanta Pawa ipinkathariwentantai. Iriima itsipapaini, eero nokamantziri irirori, apatziro noshiyakaawenteniri. Ari raminawetya, eeromaita ikowichaatzi. Ari inkemawetyaawo, eero ikemiro ikantaweetari. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jiroka oshiyakaawentachari: Jiroka okithoki ipankiitakeri, riñaane Pawa oshiyakaawentachari. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Okaatzi jokakitapainchari awotsiki, oshiyakaawentziri kemawetawori ñaantsi, ikanta ripokapaake Kamaari imaisantakaapaakeri, te ikemisantanai, eero rawisakoshiretai. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eejatzi oshiyawo jokakitapainchari omapipookitzira, oshiyakaawentziri kemawetawori ñaantsi intsipaite ikemisantaweta. Temaita riyotakoperotzimaitawo ñaantsi, ripakaanakero ikemisantzi. Te ikisashitawo rantakagaitziri kaariperori, roshiyakawo pankirentsi kaari kyaaperotatsine oparitha inthomoiki kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eejatzi oshiyawo jokakitapainchari okitocheemashitzira, oshiyakaawentziri kemawetawori ñaantsi. Okantakaantziro okantzimoshirewaitari, ikenkithashiryaakotawo rashaagantya, iñaamawaitawo inthaamentawaitya. Iro anaanakero ñaantsi ikemawetakari, roshiyakotakawo pankirentsi kaari kithokitatsine. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Irooma okithoki jokakitapainchari irenkapathataga kipatsi, oshiyakaawentziri kemanairori ñaantsi, kameethashire ikantanaa, roshiyakotanaawo pankirentsi saankana rishookanake, osheki ikithokitanake.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ari ikantake eejatzi: “Ankowerika ootyaari ootamento, ¿arima ashitakotakeri chomooki? ¿Amanakotzirima otapinaki? Tera. Owakotziri jenoki onkene ankoñaatakote maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ari oshiyawo eejatzi, ontzimatye onkoñaatakoyetai manakoyewetainchari, ooñaawontairo kaari riyotakoweeta pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Paamayaawo okaatzi pikemakeri. Tzimatsirika oshekitzimotziri oitarika, ari iñaakero oshekitzimoperotairi. Iriima kaari oshekitzimotzi, eekero iñaatyeero eero oshekitzimoperotziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Okanta ipokashitakeri inaanate Jesús otsipatakari irirentzipaini oñeeri. Temaita okanta oñeeri rotzikaakeri atziri piyochonchoitainchari. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Irojatzi ikantaitantakariri: “Ari ipoki pinaanate otsipatakari pirentzipaini, okowi oñeemi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ikantanake irirori: “Ikaatzi kemanairori riñaane Pawa, rantanairo ikowakairiri, iriitake nirentzitari, irootake ninirontari eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ikanta rotetanaka Jesús pitotsiki itsipatanaari riyotaanewo, ikantanairi: “Jame amontye intatsikeronta.” Jataiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ikanta rimontyaakoiyanakani, maanake Jesús. Ari omapokapaakari antawoite tampyaa, antawo otamakaatanake inkaare, otetaagapaaka ñaa pitotsiki, iroowetaincha ritsitsiyakoteme. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ari rowakiryagaitanakeri Jesús, ikantaitziri: “¡Yotaanarí! ¡Atsitsiyakotatye!” Piriintanaka, riñaanatanakero tampyaa, ikantziro: “¡Ataama pitampyaatake!” Riñaanatanakero eejatzi inkaare, ikantziro: “¡Pimairyaate!” Awisanake tampyaa, mairyaatanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Irojatzi ripithokashitantanakariri riyotaanewo, ikantziri: “¿Tsikama okenanakeka pawentaanewo?” Antawoite ipinkathatanakeri, ikantawakaiyani riyotaanewo ithaawankakiini: “¿Iitatyaakama jirika romairyaantawori tampyaa, romairiiro eejatzi inkaare?” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ikanta rimontyaanakawo Jesús intatsikeroki inkaare Galilea, areetaka inampiki Gadara-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iro raatakotapaakitziini, rishiyashitawakari raayiri peyari. Pairanitake raayiri peyari aatonkoryaamereki ikantaka, te rametaiyaawo risaikai pankotsiki, ari risaikawaitzi kitataarewomashiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ikanta iñaawakeri rareetapaaka Jesús, rishiyashitawakari, rotziwerowashitawakari. Shintsiini ikaimanake, ikantzi: “¡Jesús, Itomi Pawaperotatsiri! ¿Tsikama pinkantenaka? Te nokowi powashironkaina.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Ikisathatapaakitziiri peyari ripakagairiita atziri. Tema pairanitake risaikashiretantakari. Osheki roosoweetantari kotsirotha, rithatyiiro. Rishiyashiyawaita ochempiki ikantakaakari peyari.) ");
INSERT INTO cpbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ikanta Jesús rosampitakeri peyari, ikantziri: “¿Tsikama piitaka?” Rakanake peyari, ikantzi: “Noita ‘Shekiyantzi.’ ” Tema osheki nokantaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eekero ikantanakitzi peyari: “Te nokowi pithonkaiyenani.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ari ipiyotaiyani chancho roshimotokawaitaiyini. Ikantaiyini peyari: “Potyaantena janta chanchoki.” Irojatzi ikantantanakariri Jesús: “Piyaate.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ikanta Shekiyantzi, ikyaantapaakari chancho-paini. Irojatzi rishiyantanakari impeetaki, mitagaiyanakeni inkaareki, rithonka ripiinkake. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ithaawaiyanakeni kempoyiiriri chancho-paini, shiyaiyanakani ikamantantapaake nampitsiki, ikamantzitanakari eejatzi saikayetatsiri rowaneki. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pokaiyapaakeni atziri raminero okaatzi awisaintsiri. Irojatzi riyaatashiitantanakariri Jesús. Iñagaitapaatziiri raagawetari peyari risaikake itsipatakari, ikithaataka, kameetha ikantaawo. Antawoite ithaawaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ikaatzi ñaakerori awisaintsiri ketziroini, ikamantawakeri pokayetaintsiri, ikantzi: “Piñaakeri raagawetari peyari, iriitake Jesús owawisaakotairiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ikanta Gadara-satzipaini roipiyawakeri Jesús, ikantziri: “Piyaatai, te nokowi pisaikimotena.” Iro roipiyantakariri ithaawakaanakityaari antawoite. Ari rotetanaawo Jesús pitotsiki, piyanaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ari ikantawetawaari rowawisaakotairi: “Nokowi noyaatanakemi.” Rakanakeri Jesús, ikantanakeri: ");
INSERT INTO cpbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Eero poyaatana, piyaatai pisheninkaki pinkamantapairi, pinkanteri: ‘Rowawisaakotaana Pawa.’ ” Ari ikantakari atziri, jatai inampiki ikamantantapairo okaatzira rowawisaakotantaariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ikanta ripiyaawo Jesús, thaamenta ipiyowentawaari atziri, iriitakera royaaneentakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tzimatsi atziri jitachari Jairo, iriitake jewatakaantatsiri rapatotapiintaitaga. Ari iñaapaakeri Jesús, rotziwerowashitapaakari, ikantapaakeri: “Nokowi piyaate nopankoki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tema okamimatatzi rapintote rishinto. Tzimake 12 osarentsite. Ikanta royaatziri atziripaini Jesús, ranawiimatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Okanta tsinane osokaawaitachari, tzimakotake 12 osarentsi okemaatsiwaitaka, ithonkakero tzimimowetawori opimantziro ipinawetariri aawintantzinkari, temaita etsiyatakotzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Okenashitapaakeri itaapiiki Jesús, iterotzitakeri opatzikaaki iithaare. Apathakero etsiyatanake osokaawaita. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ari rosampitantanake Jesús, ikantzi: “¿Iitaka terotzitakenawori noithaare?” Tekaatsi thawetakotachane iitarika terotzitakeriri. Ikanta Pedro itsipatakari ikaataiyini, ikantzi: “Yotaanarí, tema piñiiri ranawiimatakemira atziripaini, eekero pikantatzi: ‘¿Iitaka terotzitakenawori noithaare?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eekero ishintsitanakitzi Jesús ikantzi: “Tzimatsi terotzitashitakenawori noithaare. Tema nokemawakero noshintsinka eenitatsi etsiyatakotakaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Okanta iñaakero tsinane te imanakota okaatzi antakeri, antawoite othaawanake, ipokashitapaakeri Jesús, otziwerowashitapaakari, maawoini ikemaitakero othawetakota, ikemaitakero eejatzi tsika okanta etsiyatakotantaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ikantanakero Jesús irirori: “Tsinané, iro owawisaakotaimiri pawentaanewo. Kantacha piyaatai, kimoshire pinkantanaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tekera ikaatziroota Jesús riñaanatziro tsinane, areetapaaka poñagainchari ipankoki jewatakaantatsiri rapatotapiintaitaga, ikantapaakeri: “Kamake pishinto, ataama poomerenchiiri yotaantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ikanta ikemakeri Jesús areetapainchari, ikantanake irirori: “Eero pithaawashiwaita. Pawentaina, aritake etsiyatakotai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ikanta rareetaiyapaakani pankotsiki, tekaatsi rishinete inkyaapaake, apatziro Pedro, Jacobo, Juan, ashitawori rishinto eejatzi iniro. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Osheki iraakotaiyaworini kamaintsiri. Ikantapaakeri Jesús: “Eero piragaiyani, te okami eentsi, imakoryaatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Thainkashire rowaweetakari Jesús, tema imapero iñagaitakero okamake eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ikanta Jesús rotaiyawakotapaakero, riñaanatzimaitawo shintsiini ikantziro: “¡Tsinané, pimpiriinte!” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Piyashiretapaaka eentsi, piriintanaawo. Ikantanake Jesús: “Pimpero owanawo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyokitzii ikantanaka ashitawori eentsi. Eekero ikantanakitzi Jesús: “Te nokowi pinkamantantero okaatzi piñaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ikanta Jesús ipiyotakeri 12 riyotaanewo ripasawyaakeri ishintsinka roitsinampaantyaariri peyari eejatzi mantsiyarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Rotyaantakeri inkamantantero jimpe ikanta Pawa ipinkathariwentantzi, retsiyatakotakaayetairi mantsiyayetatsiri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ikantawakeri: “Eero paanake tsika oitya, eero paanake pikotzi, pithaate, powanawo, piyorikite, eero paanake eejatzi apite piithaare. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Arika pareetakya pankotsiki, ari pimaapiintatye irojatzi pawisantakyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eerorika raakameethaitzimi janta, pawisapithateri, potekanairo piipatsite piitziki, iro riyotantaityaari te ikemisantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ikanta riyaataiyakeni riyotaanewo, rithotyaakero nampitsi ikamantantziro Kameethari Ñaantsi, osheki mantsiyari retsiyatakotakaayetake. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ikanta pinkathari Herodes iitaitziri eejatzi Tetrarca ikemakotakeri Jesús okaatzi rantayetziri, okantzimoshiretanakari, tema eenitatsi kantatsiri: “Añagai Juan omitsitsiyaatantaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Itsipa kantatsiri: “Elías rinatzi.” Ikantaitzi eejatzi: “Aamaaka itsiparika Kamantantaneri piriintaacha.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Irojatzi ikantantanakari Herodes: “Noshiyakaatzi nithatzinkakaantakeri Juan-ni. ¿Itzimikama nokemakowentziri iroñaaka?” Oshekira ikowake iñeeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ikanta ripiyayetaawo otyaantaarewo, ikamantapairi okaatzi rantayetakeri. Irojatzi ipiyotantawaariri maawoini, raanakeri nampitsiki iitaitziro Betsaida. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iro kantacha yotake atziripaini tsika ikenake, rimpoitairi. Ikanta Jesús iñaawairira raawakeri kameethaini, ikamantakeri impinkathariwentantai Pawa, retsiyatakotakaakeri mantsiyayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Okanta otsireniityaanake, ripokashitapaakeri Jesús 12 riyotaanewo, ikantapaakeri: “Potyaantairi atziripaini, ramine jimpe rimaye, jimpe royaa eejatzi, tema asaikatzi ochempiki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Rakanake Jesús, ikantanakeri: “Pimperi eeroka royaari.” Ari ikantaiyini: “Tekaatsi nomperiri, apatziro otzimi 5 pan eejatzi apite shima. ¿Pikowima niyaate namanantakite royaari maawoini atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tema ikaataiyini 5000 shiramparipaini piyotainchari. Ikanta Jesús ikantakeri riyotaanewo: “Pimpiyoteri inkaate 50 atziri poisaikayeteri, ari pinkantakeriri maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Rantakero, roisaikakeri maawoini atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Raakero Jesús 5 pan eejatzi apite shima, raminanake inkiteki, riwetharyaawentakawo owanawontsi, itzipetowakero ipakeri riyotaanewo impayeteri maawoini atziri piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rowaiyakani maawoini, kemaneentaiyakani kameetha. Rowiitai 12 kantziri okaatzi tzimagaantapaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ikanta risaiki Jesús ramanamanaata itsipatari riyotaanewo. Ari rosampitakeri ikantziri: “¿Iitaka ikenkithashiretakotanari atziripaini?” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ari rakaiyanakeni, ikantzi: “Ikantayeetzimi Juan-ni omitsitsiyaatantaneri pinatzi, ikantayeetzi eejatzi Elías-ni pinatzi. Tzimatsi kantatsiri eejatzi: ‘Iri itsipa piriintaacha etawori Kamantantaneri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Irojatzi ikantantanakari Jesús: “¿Tsikama pikantaiyinika eeroka?” Rakanake Pedro, ikantzi: “Eerokatake Cristo poñaachari Pawaki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ari ikantanakeri Jesús riyotaanewo: “Eero pithawetakotana.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Eekero ikantanakitzi: “Osheki inkemaatsitakaityaari Itomi Atziri, imapero inkisaneentena Itzinkamipaini, reeware Imperatasorentsitaarewo, eejatzi Yotzinkariite. Ari rowamaakaantakena. Iro awisawetakya mawa kiteesheri, ari nañagai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Irojatzi ikantantanakariri maawoini: “Tzimatsirika kowatsiri intsipatena, ripakayero okaatzi ikowashiwaitari rantayeteri, onkantawetakya inkentakotaiterime roshiretaanaga, intsipatapiintaina kiteesheriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tema ikaatzi etakowaitachari apaniroini rantayetziro iñaamashireyetari, ari impeyawaitashitaiya. Iriima inkaate kamawentenane okantakaantziro ikemisantana, aritake rawisakoshiretai. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aminaashiwaita otzimimotziri maawoini rowaagawopaini tzimatsiri jaka kipatsiki, ari ompeyakaashitaiyaari rañaamento, apaniroini rithonkaiya. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tema ikaatzi kaaniwentakotanari naaka, kaaniwentakotakerori niñaaneyetakari, ari rimatairi Itomi Atziri inkaaniwentapairi paata arika ripiyai ramairo rowaneenkawo, rashi Ashitariri, rashi eejatzi maninkariite tasorentsitatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Irojatzi ikantantanakari eejatzi Jesús: “Kyaaryoo, eenitatsi pikaatake jaka, eerowa ikamita ari iñaanairo tsika inkantya Pawa impinkathariwentantai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Okanta awisake 8 kiteesheri, tonkaanake Jesús ramaña, ari itsipatanakari Pedro, Jacobo eejatzi Juan. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ikanta ramanaga, ari ipashiniwootanake Jesús, kitamaaniki okantanaka iithaare ishipakiryaanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iñaatzi apite katziyapainchari itsipatapaakari Jesús, Moisés rinatzi itsipatakari Elías. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ari ikatziyaiyapaakani otapotakari rowaneenkawo, ikenkithatakotziro jimpe inkantya Jesús impeyakaityaari Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ayimatakeri iwochokine Pedro eejatzi ikaatzi itsipatakari. Okanta awishimotanakeri iwochokine, iñaatziiro rowaneenkawo Jesús itsipatakari apite koñaatapaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iro ripiyimatanaka apite tsipatapaintariri Jesús, riñaawaitanake Pedro, ikantzi: “¡Yotaanari, kameethawaitake asaike jaka! Ari niwetsikemiri mawa pankoshetantsi pashi eeroka, rashi Moisés, rashi Elías.” Riñaawaitashitanaka Pedro, te riyotzi oita ikantziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ikenkithawaiminthaitzi Pedro, ipamankapaakeri menkori, thaawanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ikematzi riñaawaitaitanake menkoriki ikantaitzi: “Notomi netakokitanewo rinatzi jirika, iriitake pinkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ari okaatapaake ñaantsi ikenkithawaitaitakeri, iñagaitatzi apaniroini ikatziyanaawo Jesús. Te ikamantantzitawo riyotaanewo jimpe ikanta iñaakeri, rimanane rowakero. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Okanta okiteeshetamanai, oirinkaiyaani Jesús ipoñagaawo tonkaariki, osheki pokapaintsiri ritonkyotawaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ari rosatekaka atziri, ikaimanake shintsiini ikantzi: “¡Jesús, nokowi paminenari napintzite notomi! ");
INSERT INTO cpbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Raagatziiri peyari, osheki ikaimakaawaitziri, ishimorewaantetakairi ikamanawaitzi, romposakaawaitari, te ripakairi eepichokiini. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nokantawetakari piyotaanewo rowawisaakotainari, te rimatziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rakanake Jesús ikantanake: “Te pikemanetzi eeroka. ¿Tsikama onkaate nisaikimotanaimi noñeero nonkisashitemi? Pamakeri pitomi jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ikanta ramaitapaakeri eentsi, ishinkiwentakaanakari peyari, tyaanake isaawiki, antawoite rompetawaitanaka. Ikanta Jesús ikisathatakeri peyari, etsiyatakotanai eentsi, raanairi ashitariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Riyokitziiwentanakeri atziri iñaakerowa ishintsinka Pawa. Irojatzi rapiitantanakawori Jesús ikantziri riyotaanewo: ");
INSERT INTO cpbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Powayempitatyaawo eeroka jiroka ñaantsi, eero pipeyakotziro. Tema jirika Itomi Atziri ripithokashitaitatyeeri raakaantaiteri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iro kantzimaitacha te ikemathataiyironi okaatzi ikantawetariri, tema rimanapithaitatziiri eero ikemathatantawo. Iro ithaawantaiyarini tekaatsi osampiterine oita ikenkithatakotziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ikanta riyotaanewo Jesús ikantawakaawentakawo itzimirika iriiperotatsine. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iri kantzimaitacha Jesús riyoshiretakeri ikenkithashiretari. Raake eentsi, roisaikakeri jimpe risaikaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Riñaawaitanake ikantzi: “Ikaatzi aapatziyariri oshiyariri jirika eentsi okantakaantziro raakotziro nowairo, oshiyawaitakawo naakame raapatziya. Ari oshiyawo eejatzi, arika raapatziyena naaka, oshiyawaitanakawo iri raapatziyaka otyaantakenari jaka. Ikaatzi kaari iriiperowaitatsine jaka, iriitake iriiperotaatsine paata.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ari ikantanake Juan: “Yotaanarí, noñaake chapinki atziri raakotziro piwairo, retsiyatakotakaakeri raayiri peyari. Te añiiri antsipatyaari jaka, nipakaakaakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ari ikantanake Jesús: “Eero pipakaakairime, tema ari akaatziri kaari kisaneentairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ari imonkaatzimatapaaka reethonkitantaiyaari Jesús, tontashire ikantanaka riyaate Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rotyaantake iita aminaanterine janta Samaria-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iro kantzimaitacha te ikowaiyini Samaria-satzi inkenimoteri, tema riyotaiyini riyaatatye Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ikanta Jacobo itsipatakari Juan, ikantanakeri Jesús: “Pinkathari, jame ankaimakaante paampari inkiteki, oshiyawori rantakeri pairani Elías, rithonkyaata ritaiya maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ari ripithokashitanakari Jesús, ikisathatanakeri, ikantziri: “Te pikameethashiretzi eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Te iro ripokantakari Itomi Atziri jaka impeyashiwaitaiya atziri, ontzimatye rowawisaakoyetairi.” Irojatzi ikenantanakari otsipaki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ikanta riyaatanai Jesús, ikantaweetawaari awotsiki: “Pinkatharí, nokowi noyaatemi tsikarika pinkenayete eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Rakanakeri Jesús ikantziri: “Tzimatsi imoo otsitziniro jimpe rimaapiintzi, eejatzi tsimeryaani eenitatsi imayemento. Iriima jirika Itomi Atziri tekaatsi ipanko rimaantapiintyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ikantanakeri Jesús itsipa: “Poyaatena eeroka.” Ari ikantzi irirori: “Pinkatharí, nokowawetaka noyaatanakemi, iro kantzimaitacha nokowi noñaanakero nonkitateri nopaapate, ari noyaatemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ikantanakeri Jesús: “Poyaatena, pishineteri ikaatzi kamashireyetatsiri inkitatairi irirori kamayetatsiri. Ontzimatye pinkenkithatakotairo eeroka tsika inkantya Pawa impinkathariwentantai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ari ikantanake itsipa: “Pinkatharí, nokowi naaka noyaatemi, iro kantzimaitacha pishinetena niwethatapanaantyaari nosheninka nonampiki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Rakanake Jesús, ikantziri: “Apatziro potzikanatawo pikiyashitziro piwankire, tekaatsi paminayetanai otsipa. Ari roshiyari kaari pakairone rantayetapiintziri, te opantaperotari iñeero impinkathariwentairi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ikanta Jesús riyoyaake itsipa ikaatzi 70, apitepaini rotyaantakeri, reewateri nampitsiki inkenanakenta irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ikantayetziri: “Roshiyakawo atziripaini pankirentsi risampainkatzi, iro kantacha te itzimaperotzi iita owiitairine. Pamañaari Pinkathari rotyaanteeta jatatsine atziriki, tema yotacha osheki kemisantayetaatsine. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Notyaantaiyatyeemini, noshiyakaimi rotyaantaitziri oweja ipiyotaga owantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eero paanake pithaate, piyorikite, pizapato-te. Eero piwethatari, eero pikenkithawaitakairi eejatzi inkaate piñaanakeri awotsiki posamanitzikari. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Arika pareeyetakya pankotsiki, piwethatapaakyaari saikatsiri. Pinkantapaakeri: ‘Onkamintha pisaikawaite kameetha pipankoki.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tzimatsirika aakameethatakemine, aritake iñaakero risaikake kameetha. Irooma eerorika raakameethataitzimi, aminaashita piwethatapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Apatziro pimaapiinte pankotsiki tsika pareeta, eero paminaminatzi otsipa pankotsi. Ari poyaari, pirero onkaate impaitemiri. Tema ikaatzi antawaitatsiri ripinaitziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Arika raakameethataitakemi nampitsiki, poyaawo onkaate impaitemiri janta. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Petsiyatakotakaayeteri mantsiyari, pinkanteri: ‘Irootaintsi impinkathariwentantai Pawa.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Irooma pareewetakya nampitsiki, eerorika raakameethaitzimi, pawisapithateri, pinkantanake: ");
INSERT INTO cpbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Notekanairo noipatsiyitzite jaka, riyotaitantyaari te pikemisantzi. Ontzimatye piyotzimaitya romapokakemi Pawa ipinkathariwentantai.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tema rimaperoitatyeeri rowasanketaiteri paata, anaanakero ikantaitakerira Sodoma-satzi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ikantamatsitaitziri Corazín-satzi, eejatzi Betsaida-satzi. Iñaawetakawo nitasonkawentantake, temaita ikemisantaiyini. Iriime ñaakenaneme Tiro-satzi eejatzi Sidón-satzi, aritake rowashiretakotakyaame ikaariperoshireyetzira. Ari ripakaakerome, inkemisantaime maawoini iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Arika raayeetairi paata kameethashireri, eero rimaperoitziri rowasanketaiteri Tiro-satzi eejatzi Sidón-satzi. Iriima Corazín-satzi, eejatzi Betsaida-satzi, iriira rimaperoitairi rowasanketaitairi paata. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eejatzi inkantaiya Capernaum-satzi, ikenkithashiretaiyani irirori riyaayetaime inkiteki, iro kantzimaitacha inkenashitaiya kaminkarimashiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eenitatsirika kemisantemine, naaka ikemisantake. Itzimirika manintashiretakemine, naaka imanintashiretake. Itzimirika manintashiretakenari naaka, imanintakeri otyaantakenari jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kimoshire ripiyaiyaani rotyaantaitakeri kaatatsiri 70, ikantayetapai: “Pinkatharí, naakotairo piwairo, nimatakeri peyari nokantayetziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ikantzi Jesús: “Noñaakeri Satanás rowaryaitakeri inkiteki roshiyawaitanakawo ookathawontsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tema naaka pakemirori shintsinkantsi, ari imatakya posatekantyaari maanke eejatzi kitoniropaini. Ari potsinampaakeri peyari kisaneentzimiri, tekaatsimaita awishimotemine. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eero pikimoshirewentashitawo pimatakeri peyari okaatzi pikantakeriri. Iro pinkimoshirewente rosankenaitairo piwairo inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Irojatzi ikimoshiretantanakari Jesús, ikantanake: “Ashitanarí, eerokatake pinkathariwentziriri inkiteweri, eejatzi kipatsisatzi, antawoite niwetharyaakemi. Tema eerokatake yotakaayetairiri tsinampashireri kaari riyoyetzi yotaneriite. Ari okantzimaita Ashitanari, irootake inimotakemiri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ikantzi Jesús: “Iriitake Ashitanari pasawyaakenawori maawoini. Apatziro ikanta irirori riyoperotana naaka tema itomi rowana. Ari nokantzitakari naaka apatziro niyoperotziri. Tema inkaate niyotakaayetairi naaka ari riyoyetairi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ikanta Jesús ipiyotakeri riyotaanewo, raanakeri jantyaatsikaini, ikantakeri: “Kimoshire rinaatye inkaate ñaayetairone okaatzi piñaayetairi eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tema tzimawetacha osheki Kamantantaneri, eejatzi pinkatharipaini kowawetainchari iñeerome okaatzi piñaakeri eeroka, temaita okanta iñeero, te ikemayetairo eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ari risaikakeri yotaantzirori Inintakaantaitanewo, ikowaweta rikompitakayaarime Jesús, ikantake irirori: “Yotaanarí, ¿oitaka kowachari noñaantaiyaawori añagaantsi?” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Rakanakeri Jesús: “¿Iitaka okantziri Inintakaantaitanewo? ¿Tsika okantaka piyotakotziro eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ari rakanai irirori, ikantzi: “Pinintaperotairi Piwinkatharite Pawa, pinintashirenkatairi, pinintashintsitairi, pinintashiretairi.” Ari oshiyawo eejatzi: “Petakotawakaiya maawoini, oshiyakairo anethairo awatha, ari ankantairi asheninka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Irojatzi ikantantanakari Jesús: “Imapero pikantakeri. Pantero jiroka, aritake pawisakoshiretai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iro kantzimaitacha jirika, ikowajaantzi rotzikaawentanakya, rosampitziri Jesús: “¿Iitaka noshiyakairi nosheninka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Rakanai Jesús, ikantzi: “Tzimatsi asheninka poñaachari Jerusalén-ki ikowi riyaatero nampitsiki Jericó. Okanta niyanki awotsi, ritonkyotakari koshintzi, romposawaitawakeri, rookanakeri awotsinampiki, kamimatake. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ari ripokake Imperatasorentsitaarewo, iñaawetapaakari romaryaaka, rawisapithatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ari ikantakari eejatzi isheninka Leví-ite, iñaawetapaakari romaryaaka, rawisapithatanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Irojatzi ripokantakari Samaria-satzi, iñaapaakeri romaryaa, ineshironkatapaakeri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Raawintapaakeri ritziritantapaakari oyeenka pankirentsi, rotetakaanakari iyawayoteki, raanakeri nampitsiki. Iriitake kempoyaapaakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Okanta otsipa kiteesheri, raake apite denario, ripinakowentanakeri, ikantanake: ‘Pinkempoyeenari jirika, aritake nipinatapaimi arika nipiyake.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ari ikantzi Jesús: “Mawa ikaatzi nokenkithatakotakeri ñaakeriri romposanewo koshintzi. ¿Tsika itzimika oshiyakaakeriri isheninka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rakanai yotakotzirori Inintakaantaitanewo, ikantzi: “Iriitake matakeriri ineshironkatakeri.” Irojatzi ikantantanaari Jesús: “Piyaatai, iroowa panteri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ikanta rawisanake Jesús areetaka otsipaki nampitsi. Ari isaikiri tsinane jitachari Marta, irootake risaikimotapaake opankoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jiroka tsinane tzimatsi irento oita María. Irootake tsipatawakariri okaakiini Jesús okemisantziri ikenkithawaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Iro kantzimaitacha Marta osheki okantzimotakawo aminaminawaitzi oita ompawakeriri Jesús. Irootake ipokashitantapaakariri, okantapaakeri: “Pinkatharí, ookanawentakena eentyo. ¿Pinkantenawo amitakotawakena?” ");
INSERT INTO cpbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ikantzi Jesús: “Marta, ¿oitaka okantzimoshiretantzimiri onkaate pantayeteri? ");
INSERT INTO cpbNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pinkeme nonkantemi: Apaani okanta kowaperotachari, irootake iyoyaakeri María tekaatsi kanterone raapithatairo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ikanta Jesús riyaatake ramaña. Ikanta riyotaanewo, ikantakeri: “Pinkatharí, piyotainawo ramanaita, ikemetairo Juan-ni riyotaantziro amanaantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ari ikantanake Jesús: “Jiroka pinkantero pamanapiintya eeroka: Ashitanarí, Inkitesatzi, Tasorentsi pini eeroka. Pimpinkathariwentaina naaka. Pantakainawo jaka kipatsiki okaatzi pinintakaanari eeroka. Poshiyakagainari saikatsiri inkiteki, rantayetziro okaatzi pinintakairiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pimpapiintenawo koityiimotanari nowanawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimpeyakotakagainawo nokaariperoshirewaitzi, Tema nimatakero naaka, nopeyakotairi ikaatzi owaariperoshiretanari. Eero pishinetaana iñaantaitena, inkowaite rantakaitenawo kaariperori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ikantantanake eejatzi Jesús: “Arika intzime pitsipaminthare, ripokake niyankiiteki, inkantemi: ‘Pimpawakena mawa pan, ");
INSERT INTO cpbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tzimatsi areetainchari nopankoki, tekaatsi nompawakeriri.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ari pinkantawetyaari: ‘Eero poomerenchaana noimaatziiri neentsitepaini, tema nashitanakero nopanko, irootake eero okantanta nompemi.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Oshiyawaitakawo eero pikowaweta pimperi okantawetaka iriiwetaka pitsipaminthare. Iro kantacha eekero ishintsitatzi ikowakotzimi, ari potsiwakanakyaawo pinkakitanake, pimpawakeri okaatzi ikowiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ikantzi Jesús: “Pinkowakotante, pithotyaakote eejatzi, aritake piñaakero impaitemiro pikowiri. Poshiyakairo pareetya pankotsiki, pishintsineentantapaake, pinkanteri: ‘Pashitareenawo. Aritake rashitaryagaitakemiro.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ari impayeetairi kowakowatatsiri. Inkaate aminaminatatsine roñaagaitziri. Aritake rashitaryagaitainiri inkaate shintsishintsitatsiri inkaime. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tema arika inkowakotemi pitomi, inkantemi: ‘Papá, pimpena pan.’ ¿Arima pimpakeri mapi? Arika inkantemi: ‘Pimpena shima noya.’ ¿Arima pimpakeri maanke royaari? ");
INSERT INTO cpbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Arika inkantemi: ‘Pimpena iithoki.’ ¿Arima pimpakeri kitoniro? ");
INSERT INTO cpbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tema piyotziro petakotari pitomipaini eeroka, kaariperori pinaweta. Iriitake maperotzirori Ashitairi saikatsiri inkiteki, retakotari irirori ikaatzi amanapiintariri, risaikashiretakaantari Tasorenkantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ikanta Jesús rowawisaakotakeri kisowaanteri raayiri peyari. Ikanta retsiyatakotakagairi, kenkithawaitanai kisowaantewetachari. Antawoite riyokitziiwentaitanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eenitatsi kantayetanaintsiri: “Ripasawyaatziiri ashitariri peyari, iitaitziri ‘Beelzebú’, irootake rimatantawori rowawisaakotziri ikaatzi raagayetziri peyari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tzimatsi itsipa kowatsiri iñeero ritasonkawentante Jesús, iro riyotantaityaari imaperotatya opoña itasorenka inkiteki, tema iñaantaitatyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ikanta Jesús riyotake okaatzi ikenkithashiretari atziripaini, ikantanake: “Arika rantaminthatawakaiya atziri ipinkathariwentaitziri nampitsiki, iñiiro rookanawentawakaiya. Arika rantaminthatawakaiya eejatzi atziri risaikawankotawakaiyanira, ari iñaakero rookanawentawakaiya. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ari ikanta eejatzi peyari arika rantaminthatawakayaame, ari rookanawentawakaakya eero iñiiro ishintsite, ari rithonkyaari. ¿Iitaka pikantantanari iri Beelzebú matakaanawori netsiyatakotakaantantari? ");
INSERT INTO cpbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iriirikame Kamaari Beelzebú matakainawoneme netsiyatakotakaante, ¿irijatzima Kamaari matakairiri piyotaane eeroka retsiyatakotakaantariri raagayetziri? Arika okanta, pithawetakotatziiri piyotaanewo, ari inkisantakemiro okaatzi pikantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iriitake Pawa kantakaantzirori netsiyatakotakaantariri raayiri peyari, tema romapokakemi Pawa eeroka ipinkathariwentantai. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Atziri ñaaperori kameethaini, tekaatsi materine inkyaashiteri ipankoki rayiteri okaatzi rashitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Irooma ripokashitakeri itsipa atziri maperotzirori ishintsitzi, raapithatakeri rawentaawetari, raapithatakeri rashitari, rantetakyaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tema ikaatzi kaari aapatziyanari naaka, iriitake kisaneentanari. Inkaate kaari amitakotenane rowiitakotena, reewanatakotakena.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Oshiyawaitakawo risaikashiretantaime peyari, ipankotetakawo rañaamento atziri. Arika rookaweetakyaari, awisakoweta atziri risaikantari peyari. Jatake inkenawaite ochempiki, eero iñi jimpe risaike. Irojatzi inkantantaiya peyari: ‘Nipiyaita nopankoki nopoñaakaga.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Piyaawo peyari, iñaapairi atziri kameetha opishitaka rañaamento, owaneenka ikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ikanta peyari riyaatashitakeri maperotzirori ipeyaritzi, inkantapaakeri: ‘Jame aate nopankoki, pintsipatena ampinkatharite.’ Ramake inkaate 7. Ari rowashironkaaperotyaari atziri, eero oshiyaawo rashironkaawetaga pairani eepichokiini ikanta.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te ikaatziro ikenkithawaitzi Jesús, okaimanake tsinane osatekainchari ipiyotakaga atziri, okantzi: “Thaamenta onkantya tsinane owaiyimiri, antarintakemiri othotaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Irojatzi rakantanakawori Jesús, ikantzi: “Iri thaamentaperotaachane inkaate kemisantairone riñaane Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ikanta ipiyotapaaka osheki atziri, ikantanake Jesús: “¿Iitaka ikowantari iñeena kaariperoshireri nitasonkawentante? Eero noñaayimaitari, apatziro iñeero oshiyawori iñaakeri pairani Jonás. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tema ikantakaga pairani Jonás iñagaiyakerini Nínive-satzi, ari inkantaiyaari eejatzi Itomi Atziri iñagairi jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Paata arika raminakoitairo okaatzi rantayeetziri, ari iyakowentaimi tsinane pinkatharitatsiri pairani nampitsiki Sabá, tema ipokashitakeri iroori yotzinkari jitachari Salomón, okemisantairi. Jirika saikimotakemiri eeroka, ranairi Salomón. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Eejatzi oshiyawo ari riyakowentaimi paata Nínive-satzi, tema ikemisantaiyakerini irirori pairani Jonás, ripakaanakero ramewetari. Jirika saikimotakemiri eeroka jaka, ranairi Jonás.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Arika ankowe ootyaari ootamento, ¿arima owakotakeri otapinaki? Tera, owakotziri jenoki onkene ankoñaatakote maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Okameethatzirika poki, piñaantawo kameethaini, oshiyawaitakawo pinkoñeetyaakotatyeeme. Terika okameethatzi poki, eero piñaantawo kameethaini, oshiyawaitakawo pintsirenikitakotatyeeme. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Paamaawentya poitsiwakirikari ootamentotsi saikantakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Imaperorika risaikantakemi ootamentotsi, eerorika pantanairo kaariperori, aritake poñaagantairo irooperori kameethari, poshiyanaiyaari ootamentotsi roorentantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ikanta ikaatapaakero ikenkithatake Jesús, ripokashitapaakeri Fariseo riyaatakairi ipankoki roya. Ikanta rareetaka Jesús pankotsiki, saikapaake rowapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Osheki ikompitzimotakari Fariseo iñaakerira Jesús te rimonkaatziro rametapiintari, inkiwaakotapaakya rowantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iri kantzimaitacha Jesús, ikantanake: “Poshiyakotakawo piraamento eejatzi powamento okiteweta kameetha jakakeroki, irooma inthomoikinta, sheretake okantaka. Ari pikantakari eeroka iñaaweetzimi kameethashireri pikantaka, tema koshintzi pinatzi kaariperoshireri pikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Masontzí. Tema eenitatsi wetsikakemiri piwathaki koñaayetatsiri, ¿kaarima wetsikitakemiri eejatzi inthomoiki pañaamentoki? ");
INSERT INTO cpbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Okowaperotatya pimpashitantaiyaawo oshekitzimotzimiri inthomoiki pañaamentoki, ompoñaantaiyaari pinkiteshireperotantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ikantamatsitaitzimi Fariseo! Pipapiintziri Pawa inchashitsityeyaki. Temaita pantziniri ikowiri. Ontzimatye pinkameethashiretai, pinintashiretairi eejatzi. Tema iro kowaperowetacha pantayeterome jiroka, eero pipakayimaitawo otsipa. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ikantamatsitaitzimi Fariseo! Osheki pikowapiintziro posatekya niyankineki rapatotapiintaitaga, ari pikantzitawo eejatzi pikowi pinkatha riwethatapiintaitemi arika iñagaitemi. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ikantamatsitaitzimi Yotzinkariite eejatzi Fariseo, owapeyimotantaneri pinatzi! Poshiyashitakawo te riyoitzi ari ikitaitziri kaminkari, te riyotzimaita atziri raatzikakotatziirira kaminkari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ari rakanake Yotaantzirori Inintakaantaitanewo, ikantanakeri Jesús: “Yotaantanerí, pikemakaakenawo naakapaini okaatzi pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Rakanake Jesús, ikantzi: “¡Ikantamatsitaitzimi eejatzi eeroka Yotaantzirori Inintakaantaitanewo! ¿Iitaka pikematenatakaantariri atziripaini? Te pimatzimaitawo eeroka pinkematenatyaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ikantamatsitaitzimi eeroka, oitaka powaneenkachonchoinatakotantariri ikitaitakerira etayetakawori Kamantantaneri! Iriitake rowamaakeri pairani picharinepaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pimatakero eeroka piwetsikashitakeri tsika ikitaitakeri, ari okoñaatziri pakakotatziiri rantakeri picharinepaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tema yotane rinake Pawa, ikantake: ‘Ari notyaantake Kamantantaneri intsipatakyaari otyaantaarewo. Apaanipaini ikoshekaitaka, ritsitokaitake itsipa.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ari onkantya rowasanketantaitemiri eeroka, okantakaantziro powamaayetakeri Kamantantaneri etanakawori pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eeroka atsipetaiyaawone okantakaantziro rowamaakaantaitakeri pairani, retanakawo Abel-ni irojatzi Zacarías-ki iriitajaantake rowamagaitakeri ripiyawetaawo tasorentsipankoki ritayiniri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ikantamatsitaitzimi Yotaantzirori Inintakaantaitanewo! Te pimataatsikaitziro eeroka piyotanete, ari pikantakero eeroka kaari ikemathatantawo itsipapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ikanta Jesús rithonkakero ikantayetakeri. Ari retanakawo Fariseo itsipayetapaakari Yotzinkariite, ipiyowentari Jesús ikowi rikompitakayaarime, inkemantyaariri oitarika inkanteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ishintsithawaitakeri, ikowi riñaawaitakairi ñaantsi kaariperori ompoñaantyaari inkamantakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ikanta ipiyowentaitapaakari Jesús, piyochonchoi ikantapaaka atziri. Irojatzi ikantantanakariri riyotaanewo: “Ontzimatye paamaawentyaawo kachotakairori iwaane Fariseo, ramatawimentowa inatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tema ontzimatye onkoñaatakoyetai okaatzi manakowetainchari, ooñaawontairo kaari ikemathaweeta pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Okaatzi pimanakowetari, ari onkoñaatakotai. Okaatzi pikenkithawaitziri apaniroini pipankoki, ari inkemakoitairo inkenkithataitero shintsiini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ikantzi Jesús: “Asheninká, eero pipinkashiwaitari kowatsiri ritsitokemi, tema ari iweyaari raawiiri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jirikaga pimpinkeri: Iriitake Pawa materone rowamaante, aritake rotyaantakemi sarinkaweniki. Iriitake pimpinkathatairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tema te ripinaperoweta tsimeryaanipaini, riyotzimaita Pawa arika inkamagaante, tekaatsi ramaakite apaani. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Riyotzitawo Pawa okaatzi tzimayetatsiri aishi. Tema piñaakero raminawentziri tsimeryaanipaini, eeroka rimaperotzi raminawentzimi, eero pipinkantashiwaita.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Intzimerika kanterine isheninka: ‘Rashitaana Jesús.’ Ari inkantaiya Itomi Atziri inkantairi imaninkarite Pawa: ‘Nashitaari jirika.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iriima kantairine isheninka: ‘Te rashitana Jesús.’ Ari inkantaiyaari irirori, inkantairi imaninkarite Pawa: ‘Te nashitaari jirika.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Itzimirika kishimatakerine Itomi Atziri, ari impeyakotakagaitairi. Iriima kishimatakerine Tasorenkantsi, eero ipeyakotakagaitairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Arika ragaitemi rapatotapiintaita risaikira pinkatharentsi, eero okantzimoshirewaitzimi, pinkante: ‘¿Oitaka nonkanteriri?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tema Tasorenkantsi yotakaimirone oitarika pinkenkithatakoteri janta.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ikanta riñaawaitanake apaani piyowentakariri, ikantzi: “Yotaanari, pinkantenari nirentzi impainaata kashetani rookanairi ashitanari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ikantzi Jesús: “Asheninká, te naaka aminakoyetzirori tzimawentawakagaantsi nonkantantyaariri pirentzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eekero ikantanakitzi Jesús: “Paamaawentya piñaayetzirowa ashaagawontsi. Te iro añaakaashiretemine.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ari roshiyakaawentanakeniri, ikantzi: “Tzimatsi ashaagantzinkari kithokitaintsiri osheki iwankirepaini rowaneki. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ikenkithashirewaita, ikantzi: ‘¿Tsika noweroka shenitaintsiri nowankire?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Irojatzi ikantashiretantanakari: ‘Jiroka nanteri. Notantoreero nowantapiintawori nowankire. Irojatzi niwetsikantaiyaari antawo, ari nowero nowankire, eejatzi nashaagawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ari inimotena, tema osheki nowakeri. Osheki osarentsi nimakoryaawaite, nowaperowaitya, nirawaite nomere, noimoshirenkawaitya.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iro kantzimaitacha, ikantzi Pawa: ‘Masontzí, iroñaaka tsireniriki raashireetaimi, te piyote iita agairone pashitari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ari ikantakotari osheñaawaitashitawori rashaagawo, te rosheñiimaitawo rashitari Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ikantanairi riyotaanewo: “Pinkeme nonkante: Te okameethatzi onkantzimoshirewaitemi, pinkante: ‘¿Oitaka noyaari, oitaka nireri, oitaka nonkithatyaari?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tema tzimatsi otsipa ankenkithashiretakotapiinteri añaamentoki, iro kowaperotacha anairo okaatzi owapiintari, okaatzi akithaatapiintari. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pinkenkithashiretakoteri tsimeryaani. Te riyotziro impankitero royaari, te riwetsiki ipanko rowantyaawori iwankire. Iri kantzimaitacha Pawa, ipapiintziri rowanawo. Aaka rimaperotzi retakotai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Arika pinkamaityaawo onkantzimoshirewaitemi, ¿arima powawineentawairo posarentsite eepichokiini? ");
INSERT INTO cpbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eero pimatziro powawineentero eepichokiini, ¿oitaka okantzimoshirewaitantzimiri? ");
INSERT INTO cpbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pinkenkithashiretakotero inchateya, te añiiro antawainete, te ontyagaanta onkithaatyaari. Iro kantzimaitacha te okantzimoshirewaitawo, onkante: ‘¿Oitaka nonkithaatyaari?’ Tema owaneenkata kameetha, anairi rowaneenkawetaga Salomón pinkathariwetachari pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iriitake Pawa owaneenkatzirori, okantawetaka eepichoki añaawetawo owaneenkatapainta, iro osamanitanake, eero opantanaawo arika onkamateyatanake, tema richekaitziro, ritagaitakero. Eeroka rimaperote inkempoyaawentemi Pawa, pipakairo pikisoshirewaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ataama okantzimoshirewaitakemi eeroka, pikantzi: ‘¿Oitaka noyaari, oitaka nireri?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Apatziro okantzimoshirewaitari kaari kemisantatsiri. Irooma eeroka, riyotakoyetzimiro Ashitairi oitarika koityiimotzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iro kowaperotacha pithotyaakotairi impinkatharishirewentaimi, arira impaimiro okaatzi koityiimotzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Eeroka oshiyakariri nopira, eero pithaawashitaiyani, tema iriitake Pawa kowaintsiri impinkathariwentaimi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pimpimantayetero oshekitzimotzimiri, pimpantashitya. Irootake kameethatatsi pantayetairo piñaantaiyaawori pisaikai kameetha inkiteki. Oshiyaiyaawome powaagaantatyeeyaame inkiteki tsika te ipathaanetapai, te itzimapai koshintzi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tema janta tsikarika powaagantapiinta, ari poshiretapiintawo eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Pawinakanakyaawo piithaare. Pootayeteri pootamento. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Poshiyakotyaari imperataarewo oyaawentziriri rareetaiya iwinkatharite roimoshirenka, onkene rantawainiri intsipaite arika rimperatapaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kimoshirera inkantaiya imperataarewo iñaapairi iwinkatharite aamaawenta ikantaka. Imapero nonkante, aritake roisaikapairi imperataarewo rowapiintaitaga royiitapainiri rowanawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kimoshire inkantya, iñagaitapairi aamaawenta ikanta, okantawetaka te riyotzi tsikapaite rareetya, niyankiite aamaaka onkiteeshetzimatake. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pinkemero jiroka. Arikame riyote ashitaanitachari ripokatye koshiterine, ari raamaakyaame, eero ikoshaagantaitzirime. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Irootake piyoteri eerokapaini, ontzimatye paamaawentya. Tema te piyotzi tsikapaite ripiyai Itomi Atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ari ikantanake Pedro: “Pinkatharí. ¿Arima nokaatziri maawoini atziri poshiyakaawentantakenari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ikantzi Jesús: “Poshiyakotyaari kameethashireri imperataarewo kenkithashiretachari kameetha. Rookanakeri ipankoki imperatariri, ikantanakeri: ‘Paminenari maawoini saikatsiri pankotsiki.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kimoshire inkantya jirika imperataarewo, arika ripiyai iwinkatharite iñaapairi rimonkaatakero ikantanakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aritake rishinetakeniri inkempoyeeniri okaatzi rashitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Irooma inkantashiretakeme imperataarewo: ‘Eero ripiyita nowinkatharite.’ Irojatzi ripasawaitantakyaari ikaatzi rimperaitari eejatzi inkantakero tsinane rimperaitari. Jatake rowaperowaitya, ishinkiwaitya. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Inimowaitziri jirika imperataarewo, romapokashitaiyaari rareetaiya imperatariri. Rimaperoitairi rowasanketapairi, rookapairi tsika ikashaakagaitakeri kisoshireri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tema jirika imperataarewo riyowetakawo okaatzi inintakaawetariri iwinkatharite, temaita raamaiyaari ripiyai. Irootake ripasaperoitantyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iriima kaari yotakoterone inintakairiri, eero ripasaperoitairi. Tema ikaatzi rishinetaitakeri ontzimimoperotairi, iriitake rawentaaperoityaari osheki. Intzimerika osheki rawentaaperoitari, osheki inkowakoitairi irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iro nipokantari nowasanketeri kaariperoshireri, oshiyawaitakawo iroome paampari namakeme kipatsiki. Osheki nokowakitake etataityaawo iroñaaka rowasanketaite, ithonkaiyaame kaariperori. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iro kantacha ontzimatye netanakyaawo naaka nonkemaatsitanakya, irojatzi nimonkaatantakyaawori. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Piñaamatsitake iro nipokantari iñeero atziri risaike kameetha. Tema nipokake, namatziiro kisawakagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iroñaaka iñagaitero inkisawakaiya atziri risaikawankotawakaaga, apite atziri kisherine itsipa atziri kaatatsiri mawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mainari ripithokashityaari ipaapate, ripiyatzityaari eejatzi ipaapate inkisaneenteri itomi. Ipithokashityaawo tsinane onaanate, ipiyatzityaawo eejatzi onaanate. Ipithokashityaawo tsinane ayiro, ipiyatzityaawo eejatzi ewatairo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ikanta Jesús ikantziri atziri piyowentakariri: “Arika piñeero menkori ikyaapiintzira ooryaatsiri, pikantapiintzi: ‘Omparyaatye inkani.’ Matachaga pikantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Arika pinkemero tampyaa ompoñeeya katonkonta, pikantapiintzi: ‘Osaryaatye kameetha jiroka kiteesheri.’ Matachaga okaatzi pikantziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Owapeyimotantanerí! Piyowetawo eeroka jimpe okanta piñaapiintziro inkite, eejatzi kipatsi. ¿Oitaka kaari piyotakotantawo okaatzi awisatsiri iroñaaka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Oitaka kaari paminantawo eeroka okaatzi kameethatatsiri? ");
INSERT INTO cpbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Arika intzime kishemine, irojatzi raantanakemi pinkathariki, pinthaawakote eeroka awotsiki, pinkanteri: ‘Eero pikisawaita, jame aakameethatawakagaiya.’ Tema arika rareetakaakemi pinkathariki, inkantaitakeri aamaawentantaneri: ‘Paanakeri jirika.’ Irojatzi raantaitanakemiri romonkyagaitemi. ");
INSERT INTO cpbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tema eerorika pipinatashitawo pireewere, eerowa piñagairo romishitowakaantaimi. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ari ripokaiyakeni kamanterine Jesús, tema rowamaakaantake Pilato apaani Galilea-satzi janta ritaapiintaitzinirira Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ikantanake Jesús: “¿Piñaamatsitakema eerokapaini iro awishimotantakariri jiroka tsika ikantaitakeri rowamaitakeri, iri maperotzirori ikaariperoshiretzi ranairi itsipa Galilea-satzi? ");
INSERT INTO cpbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nokantzi naaka: Te ari onkantya. Eerorika pipakairo pameyetari eeroka, ari poshiyakotaiyaari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ari roshiyakari kaatatsiri 18 kamaintsiri anawyaakeri pankotsi janta Siloé-ki, ¿piñaamatsitakema iri maperotzirori ikaariperoshiretzi ranairi itsipa Jerusalén-satzi? ");
INSERT INTO cpbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nokantzi naaka: Te ari onkantya. Eerorika pipakairo pameyetari, ari poshiyakotaiyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ikanta Jesús roshiyakaawentanakero, ikantzi: “Otzimimotziri atziri iwankire rowaneki. Ikanta riyaatake raminero tzimakerika okithoki, temaita iñaapaake. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ikantakeri kempoyiiniriri: ‘Mawa osarentsi nipokaweta naminiro nowankire onkithokite, temaita noñi. Pichekero, aminaashiwaita okatziya jaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Rakanake kempoyiiniriri, ikantzi: ‘Eero nowinkatharite, añaawairoota jiroka osarentsika eerorika okithokitzi, nonkeekashitawakeroota nityaakotero oponkitziki onkithokitantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Arika onkithokitai, kameetha inatzi. Irooma eerorika, aripaite pitowakaantero.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ikanta riyotaantzi Jesús kiteesheriki rimakoryaantaitari janta ipiyotaitapiintaga, ");
INSERT INTO cpbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ari isaikake tsinane tzimakotaintsiri 18 osarentsi raagaitziro. Tsinkamitzitake, te okanta onkatziye kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ikanta iñaapaakero Jesús, ikaimapaakero, ikantziro: “Tsinané, etsiyatakotaimi pimantsiyawetaga.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Riterotakero itsinkamitziwetakaga. Tampatzikatanai kameetha. Osheki okimoshirewentanairi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Temaita inimoteri jewatatsiri ipiyotaitapiintaga, antawoite ikisanaka, iñaakerira Jesús retsiyatakotakaantake kiteesheriki rimakoryaantaitari. Ikantanake jewari, ikantziri atziripaini: “Eenitatsi 6 kiteesheri rantawaitantaitari, arika pinkowe petsiyatakotakaante, pipoke kiteesheriki kaari rimakoryaantaitari. Te ishinetaantsita kiteesheriki rimakoryaantaitari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Irojatzi rakantanakari Jesús, ikantzi: “¡Owapeyimotantanerí! Kiteesheriki rimakoryaantaitari pithataryaakotapiintziri pipira pirakairi imere. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tema jiroka tsinane asheninka inatzi, iro isawontari Abraham-ni tzimakotake 18 osarentsi ikemaatsitakaakawo peyari. ¿Tema okameethatzi etsiyatakotakagairo kiteesheriki rimakoryaantaitari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ikantanakera Jesús, antawoite ikaanitanake ikaatzi kisaneentziriri. Iro kantzimaitacha kimoshire ikantaiyanakani atziri ikaatzi ñaakerori rantakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ari ikantanake Jesús: “¿Oitaka oshiyari ipinkathariwentantai Pawa? ¿Oitaka noshiyakaawentemirori? ");
INSERT INTO cpbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tema oshiyaatyaawo arika impankiitero okithoki oryaanikitatsiri pankirentsi. Tema tzimatsi atziri pankitakerori rowaneki, anaanakero otsipa pankirentsi, antawo otewayetanake, ari imenkoshiyetari tsimeryaani itsimankatapishitakera.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ari rapiitakero Jesús, ikantzi: “¿Oitaka noshiyakaawentemirori ipinkathariwentantai Pawa? ");
INSERT INTO cpbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tema oshiyawaitakawo apaani tsinane naashewaitatsiri. Aake eepichokiini kachopathari, owaitantakawo maawoini oshe. Ari oñaakero onkachopathate.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Rithonka ikenayetake Jesús nampitsiki riyotaantzi. Irojatzi ikenantanakari Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ari rosampitaitakeri, ikantaitziri: “Pinkatharí, ¿eepichokima awisakotaatsine?” Irojatzi ikantantari Jesús: ");
INSERT INTO cpbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ontzimatye piñaashintsitya poshiyakayero pinkyaatyeeme oryaanityenkaki ikyaapiintaitzira. Tema osheki kowawetachari inkyaantaiyaawome, eeromaita rimatziro. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Arika rashitanakero ipanko ashitawori, irojatzirika pisaikake jakakeroki, pinkantawetya: ‘Pinkatharí, pashitareenawo.’ Ari rakanake irirori, inkante: ‘Te niyotzimi tsika pipoña eeroka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ari pinkantawetanakya eeroka: ‘¿Tema piyotana ari akaatzi atsipatawakaa pairani owaiyani, ari akaatzi atsipatawakaa irawaitaiyini eejatzi? Piyotaantapiintana nonampiki.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inkante irirori: ‘Imapero, te niyotemi jimpe pipoña. Piyaaperote tzimawentzirori kaariperori.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ari piraawaityaari, patsikaikiwaitya, arika piñaayetairi Abraham, Isaac, Jacob intsipataiyaari Kamantantaneriite risaike ipinkathariwentantaira Pawa. Irooma eeroka jakakeroki pisaikamatsitai. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tema inkaate awisakoshiretaatsine impoñaayetaiya tsikarika iweyaapaa kipatsi, risaikai rakiyooyetairi Pawa ipinkathariwentantaira. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tzimatsi etawetawori iroñaaka, iriitake ñagairone rimpoiyetai. Eeniyetatsi eejatzi impoiyetatsiri iroñaaka, iriitake ñaayetairone retaiyaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ari rareetapaaka Fariseo, ikantapaakeri Jesús: “Pishiye, kaakitake Herodes ikowi ritsitokemi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ikantzi Jesús: “Pipiyanake, pinkanteri oshiyakariri sagari: netsiyatakotakairi raayiri peyari, netsiyatakotakairi mantsiyari. Yotapaaka mawa kiteesheri nonkaatantyaawori nantziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eekeromaitatya niyaatatye irojatzi mawatapaintsine kiteesheri, tema iro kameethatatsi ritsitokaiteri maawoini Kamantantaneriite Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalén-satzipaini! Osheki pitsitokake Kamantantaneriite. Pitsitokakeri ikaatzi rotyaantaweetakemiri. Tema nokowawetapiintaka noshiyaarime tsimeryaani rosatetziri iryaani. Ari nonkanterime naaka ikaatzi notomintaari. Iro kantzimaitacha te pikowaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jiroka pinampi pisaikapiintawetaga, eero iñagaitai iita nampitaiyaawone. Pinkeme nonkante: Eero piñiitaana, irojatzi paata pinkantantaiyaari: ‘Tasonkawentaarewo rinatzi, tema Pinkathari aitziri otyaantakeriri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Okanta kiteesheri rimakoryaantaitari, ikenanake Jesús ipankoki reeware Fariseo roya. Osheki kempoyaakeriri oita ranteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ari risaikakeri janta mantsiyari eeniyawaitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ikanta Jesús rosampitakeri Yotaantzirori Inintakaantaitanewo itsipataakeri Fariseo, ikantziri: “Kiteesheri rimakoryaantaitari inatzi iroñaaka, ¿tema ishinetaantsita etsiyatakotakaante?” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Te rakaiyini, irojatzi imairetaiyakeni. Raakeri Jesús mantsiyari, retsiyatakotakagairi, rotyaantairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ripithokashitanakari jirikapaini, ikantziri: “Arika rotetya pipira omooki kiteesheriki rimakoryaantaitari, ¿tema ari pinoshikairi intsipaite?” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te rakanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ari risaiki Jesús ikempoyiiri akiyooterine reeware Fariseo, thaawako ikantaiyani ikowi rosatekya niyankineki rakiyooteri jewari. Ikanta Jesús roshiyakaawentanakeniri, ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Arika inkaimaitemi poimoshirenkya aawakagaantsiki, eero posatekawaita pinkowe pintsipatyaari jewari, aamaaka tzimatsi itsipa pokatsine anayimiri ririiperotzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Arika rareetapaakya kaimakaantzimiri, inkantapaakemi: ‘Eero posatekawaita eeroka, piyaate pisaike jantyaatsikaini.’ Antawoite pinkaaniwentanakya. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Iroowa kameethatatsi eero posatekawaita, pisaikapaake jantyaatsikaini. Irojatzi ripokantapaakya kaimakemiri, inkantakemi: ‘Asheninká, pipoke posatekya eeroka jaka.’ Aripaite impinkathaitemi. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Itzimirika kowashiwaitachane impinkathaiterime, aritake iñaakero intsinampashiretakaiteri. Iriima tsinampashirewaitatsiri, iriitake ñeerone impinkathaitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Irojatzi ripithokashitantanakariri Jesús aanakeriri rowakayaari, ikantziri: “Arika pinkaime atziri powakayaari, eero pikaimiri pisheninkaperotari eeroka, pirentzi, eejatzi ikaatzi ashaagantachari, tema ari ripiyataimi eeroka rakiyootaimi. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Arika poimoshirenkya, iriitake pinkaimayete ashironkainkari, mawityaakiri, pesaponchokiyetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ari piñagairo pinkimoshiretai, tema jirikapaini, eero ripiyataimi paata rakiyootaimi roimoshirenkya. Aritzimaitaka ripinaitaimiro pantakeri arika rañaayetai kameethashireri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ikanta ikemawake apaani ikaatzira risaiki rowaiyani, ikantanake: “Kimoshire inkantya inkaatera owaachane impinkatharitanakerika Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Irojatzi ikantantari Jesús: “Tzimatsi atziri, riwetsikakaantake antawoite oimoshirenkaantsi, ari rowaiyaani. Rithonka ikaimakeri ikaataiyinira. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Okanta imonkaatapaaka rowantyaari rotyaantakeri rimperatanewo inkamanteri ikaatzi ikaimakaantakeri, tema irootaintsi rowaiyaani. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Te ikowi ripokaiyeni ikaatzi ikaimakaantawetakari. Retanakawo apaani, ikantzi: ‘Eero okanta niyaate, niyaatatye naminero owaantsi namanantakeri. Irootake eero okantanta niyaate.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ikantake itsipa: ‘Niyaatatye noñaantyaari namanantakeri nopira, irootake eero okantanta niyaate.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ari ikantanake itsipa eejatzi: ‘Eero okanta niyaate, tema owakera naawakaaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Irojatzi ripiyantaawo imperataarewo, ikamantapairi iwinkatharite awisaintsiri. Antawoite owatsimaanakeri, ikantanakeri rimperatanewo: ‘Piyaate, panashityaawo jimpe iweyaa nampitsi, pamakeri ashironkainkari, mawityaakiri, pesaponchokiri inkaatera piñeeri janta.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ari ikantakero rimperatanewo. Irojatzi ikantantaariri iwinkatharite, ikantziri: ‘Nimatakero okaatzi pikantakenari, eenitzimaitacha okaankitzi pankotsi.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ikantanairi rimperatanewo: ‘Pithonkero panashityaawo awotsi, piyaate tsikarika, pishintsineenteri inkaate piñeeri janta, ripokeeta iyeekiteeta nopanko. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pinkeme nonkante: Tzimawetacha osheki atziri netawetakari nokaimakaantziri, eeromaita iñaamatsitairo royaawo eepichokiini niwetsikakaantakeri owanawontsi.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Osheki oyaatakeriri Jesús. Ari ripithokashitanakari, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Irootake inimotzimiri petakotari pipaapate, pinaanate, piina, pitomi, pirentzi, pitsiro, petakotzita eejatzi eeroka. Iroorika anaanakerone onkaate pinintename naaka pawentaana, tekeraataga pithotyiiroota pinkemisantena. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ontzimatye pinkyaaryoowentero nokenkithatakaakemiri, onkantawetakya inkentakoitemi. Arika pipakaakero, eero noshiyakagaimi eeroka niyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Apaani kowatsiri riwetsike pankotsi raminakomento, retawakyaawo inkenkithashiretya tzimatsirika rimatantyaawori riwetsikero. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ari onkantya rithonkantyaawori riwetsikero retanakari, arika rookashitakyaawo, ishirontaminthatyaari inkaate ñeerine. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Inkantaiyeni: ‘Piñaamatsiteri jirika, te raawiiro, rookashitakawo.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ari ikanta eejatzi pinkathari tzimatsiri 10,000 rowayerite, rominthata romanatyaari itsipa pinkathari tzimatsiri 20,000 rowayerite. Ontzimatye retawakyaawo inkenkithashiretawakya, arika roitsinampaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iñaakerorika eero roitsinampairi, eeniro riweyaa intaina itsipa pinkathari pokatsiri romanatyaari, rotyaante kanterine: ‘¿Tsikama ankantyaaka eero omanatawakaanta?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ari onkantyaari eejatzi ontzimatye petawakyaawo pinkenkithashiretawakya eerokapaini, eerorika pipakairo petakoyetawo pashiyetari, eero noshiyakaimi niyotaanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tema kameetha okanta tziwi okatyotzi. Iro kantacha arika rowaitaitero tsika oitya, eero opantaawo inkatyokantaityaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Te ompantaiyaawo tziwi, eero opantaatsikaitawo eejatzi risaiponkitzitantaityaawo pankirentsi, ontzimatye rookaitero. Kowirori inkemathatero jiroka, rowayempitatya inkemisante.” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ipiyotaka apatotziriri koriki itsipatakari osheki kaariperoshireri, ikemisantziri Jesús riyotaantzira. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ikanta Fariseo itsipatakari Yotzinkariite, ikenkithatakotanakeri Jesús, ikantzi: “Pamineri jirika, itsipatakari atziri kaariperoshireri, itsipatari rowapiintaiyani.” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ikanta Jesús roshiyakaawentanakeniri, ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tzimatsi atziri piratariri oweja ikaatzi 100. Ikanta ipeyaka apaani, rookanakeri itsipa ikaatzi 99 janta owintenipathatzira, jatake rithotyaakotairi peyainchari. ¿Tema pantziro eeroka jiroka? ");
INSERT INTO cpbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ikanta iñaapairi oweja, kimoshire ikanta inatapairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tema areetaa ipankoki, ipiyotapairi isheninka, ikantapairi: ‘Pipoke pintsipatena oimoshirenkya, tema noñagairi oweja peyawetainchari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eekero ikantatzi Jesús: “Ari onkantaiyaari inkiteki, antawoite inkimoshirewentaiteri pakagairone ikaariperoshireweta. Ranaanakeri kameethashiretaintsiri kaatatsiri 99.” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ari ikantanake: “Eenitatsi tsinane tzimatsiri 10 oorikite. Okanta ipeyapithatakawo apaani oorikite, ootakeri ootamento, opishitakero maawoini opanko ithotyaakotairi oorikite. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Okanta oñagairi, okaimakeri osheninka, okantakeri: ‘Pipoke, pintsipatena noimoshirenkya, tema noñagairi noorikite peyawetainchari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eekero ikantatzi Jesús: “Ari inkantaiya imaninkarite Pawa antawoite inkimoshiretai iñaakerika apaani atziri ripakagairo ikaariperoshirewaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ari ikantanake eejatzi Jesús: “Eenitatsi atziri tzimatsiri apite itomi. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ikanta iyaapitsi, ikantakeri ipaapate: ‘Papá, pimpenawo pashitakainari.’ Rimatakero, ipakeri itomi rashitakayaariri paata apaanipaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jatanake iyaapitsi itomi intaina otsipaki nampitsi. Ari reewanawaitakari iyorikite. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ikanta reewanawaitakari maawoini, iñaakero antawoite tashetsi janta nampitsiki. Ari ikoityaanakeriri ikaatzi reewanatakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Riyaatashitakeri nampitawori janta ikowi antawairentsi, rotyaantaitakeri inkempoyeeri chancho. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Antawoite ritasheyake, ikowake rakiyooteri chancho, tema tekaatsi perine rowanawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Irojatzi ikantashiretantanakari mainari: ‘Osheki inintaawaita rowaperowaita antawaitatsiri ipankoki nopaapate, ¿iitaka nashironkaawaitantari naaka jaka nitasheyawaitzi? ");
INSERT INTO cpbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ontzimatye niyaatai ashitanariki, nonkantapairi: “Papá, nokaariperotzimotakemi, nokantakeri eejatzi Inkitesatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Te onkameethate poshiyakagaina pitomi, apatziro nokowi poshiyakagainari antawaitatsiri powaneki.” ’ ");
INSERT INTO cpbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Katziyanaka, pokai ashitaririki. Tema aminawooki ikanta ashitariri, iñaawairi ripokai, rishiyashitawaari, rawithakitawairi, inintawootawairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ikantapaake itomi: ‘Papá, nokaariperotzimotakemi, ari nokantakeri eejatzi Inkitesatzi. Te okameethatzi pintomitaina iroñaaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iri kantzimaitacha ashitariri, ikantakeri rimperatanewo: ‘Pamake irooperori kithaarentsi, pinkithaatawairi notomi. Pinkyaantakayaari rakoki poreryaatsiri, pizapato-teri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pamake wathantzi ewankari waaka, pitsitokeri. Nokowi oimoshirenkya. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tema jirika notomi kamawetaka, iro kantzimaitacha añagai iroñaaka. Pairani ipeyaka, iñagaitairi iroñaaka.’ Ari retanakawo roimoshirenkaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ikanta rantarite irirentzi saikatsi rantawaitzi owaantsiki. Pokai pankotsiki, ikemapaatziiri roimoshirenkaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rosampitapaakeri rimperatanewo oitarika ikimoshiretantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ari ikantanakeri: ‘Areetaawo pirentzi, irootake rowamaakaantantari pipaapate ewankari waaka, tema kameethaini rareetaawo pirentzi tekaatsi awishimoterine.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ari ikisanaka, te ikowi inkyaapai pankotsiki. Irojatzi riyaatashitantakariri ipaapate, osheki ikowake intsipatyaari roimoshirenkya. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Irojatzi ikantantanakariri ipaapate: ‘Piñaawetana naaka nashi nowiro nisaikimotzimi, tekaatsi nantzimotemi. Te pipaatsikaitana apaani piratsi noimoshirenkya. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Irooma ripokaira yeeye eewanatzitakemiriri piyorikite ipiro mayempiro, iri powamainiri wathatatsiri piratsi poimoshirenkawairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ari rakanake ipaapate, ikantziri: ‘Notomí, ari pashi powiro pisaikimotakena eeroka, maawoini okaatzi nashitari, eeroka ashitawori maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Irootake ankimoshiretantyaari iroñaaka, tema jirika pirentzi, kamawetaka, iro kantacha añagai iroñaaka. Ipeyawetaka iñagaitairi iroñaaka.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ikanta Jesús ikantakeri eejatzi riyotaanewo: “Eenitatsi atziri ashaagantachari. Tzimatsi irirori rimperatanewopaini. Eenitatsi pokaintsiri, ikantapaakeri ashaagantzinkari: ‘Jirika reeware pimperatanewo, rapaatzitakemiro pashaagawo.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ikanta jirika ashaagantzinkari ikaimakaantakeri rimperatanewo, rosampitakeri: ‘¿Oitaka pantakeri? Nokemake ikantaitana. Poñaayenawo okaatzi pantawaitakenari. Ari iweyaapaaka peewatziri nimperatanepaini.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ari ikantashiretanake jirika rimperatanewo: ‘¿Tsika nonkantyaaka iroñaaka? Romishitowatyeena imperatanari. Te nimatziro nompankiwaite, arika nonkowakotante impashitaitena, osheki nonkaaniwentya.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ikantashiretanake: ‘Niyotake oita nanteri raakameethatantaitenari arika nishitowai.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ipiyotakeri ireewetziriri iwinkatharite, ikantakeri etawori: ‘¿Okaatzika pireewetziri nowinkatharite?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ikantzi irirori: ‘Nireewetziri 100 inchatonaa oyeenka pankirentsi.’ Ikantanairi: ‘Jiroka pireewere, posankenate otsipa, onkaatanai 50 pireewetanai.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Rosampitakeri itsipa ikantziri: ‘¿Eeroka okaatzika pireewetzi?’ Ikantzi: ‘Nireewetziri 100 royaantantaitawori trigo.’ Ikantanairi eejatzi: ‘Jiroka pireewere, posankenate otsipa, onkaatanai 80 royaantaitzirowa.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ikanta jirika pinkathari, roñaagantakeri rimperatanewo tema iñaakeri imaperotatziiri riyotzi tsika inkenakairo rantakeri. Ari ikantayeta atziripaini iroñaaka, imaperotziri riyotzi tsika ikenakairo raakameethatantyaariri isheninka, ranairi tsika ikanta kemisantzinkaripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ari ikantanake Jesús: “Ontzimatye piyote pantawaitakairo pashaagawo paakameethatantyaariri itsipa, okantaweta te opantaperowetawo ashaagawontsi, iroowa raakameethatantaitemiri paata eeroka inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Itzimirika kyaaryootaintsiri eepichokiini, iriitake kyaaryooperotaatsine. Itzimirika kaariperoshiretatsiri eepichokiini, iriitake maperotairone inkaariperotai. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Terika pikyaaryoowentziro ashaagawontsi kaari pantaperotawori jaka, tekaatsi ameentaimine impemiro ashaagawontsipero. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Terika pikyaaryoowentziro ashinentsi, tekaatsi pemine pashityaari eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tekaatsi imperataarewo materone rantawaiteniri apite pinkathari. Tema apaani inkowaperote rimperatyaari, iriima itsipa inkisaneentakeri. Ari oshiyawo eejatzi, tekaatsi materone inkemisanteri Pawa, arika inkenkithashiretakotero ashaagawontsi, oshiyawaitanakawo imperatatyeeyaarime.” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ikemaiyakeni eejatzi Fariseo, tema irijatzi ñaawenatawori ashaagawontsi, ritainkimawaitakeri Jesús ikemirira ikenkithatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ikantanakeri: “Piyotziro potzikaawentaiyani eeroka eero riyotantzimi atziri, riyotzimaitakemi Pawa okaatzi pikenkithashiryaakari. Okaatzi kameethatzimowetariri atziri, te iñaamatawo Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tema pairani ikenkithatakoitakero Inintakaantaitanewo eejatzi rosankenare Kamantantaneriite. Ipoñaapaaka Juan ikenkithatapaake. Ikematziiro atziripaini Kameethari Ñaantsi tsika ikanta ipinkathariwentai Pawa. Antawoite ikowaitzi iñagaitero, oshiyawaitakawo ishintsitaitzi arika romanataitya. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Te opomeentsita ithonkaiya paata kipatsi eejatzi inkite, iro kantzimaitacha eero ithonkimaitaa Inintakaantaitanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Itzimirika jokerone iina, arika ragai otsipa tsinane, imayempiwentakero etakawori. Ari oshiyawo eejatzi, itzimirika agairone tsinane jokaarewo, mayempitake irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tzimatsi atziri ashaagantachari, owaneenka ikithaatapiinta. Ikamaitawo kiteesheriki roimoshirenka, owaneenka rawirikawaita. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eenitzitacha ashironkaawaitachari iita Lázaro, rithonka ripathaawaitake. Ari romaryaapiinta jakakeroki ipankoki ashaagantachari. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iriitake aperotapiintzirori rowaryaayetziri rowanawo ashaagantzinkari. Pokatsi otsitzi ithotzitziri ripathaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ikanta paata kamake ashironkainkari, raanakeri imaninkarite Pawa, jatake risaikira Abraham. Ikanta ikamake eejatzi ashaagantachari, ikitaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ikanta janta sarinkaweniki, osheki ikemaatsiwaitaka ashaagantawetachari. Raminakotakeri intaina iñaatziiri Abraham itsipatakari Lázaro. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ari ikaimawetari irirori, ikantzi: ‘Chariné, Abraham, pineshironkatena. Potyaanteri Lázaro ramaatsikaitakena eepichokiini ñaa nirawakeeta, tema antawo itaaneentakena paampari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ikantanake Abraham: ‘Nochariné, poshiretakotaiyaawo pashaagawo pairani, eejatzi ikantzita Lázaro roshiretakotaawo rashironkaawaitaga pairani. Iri kantzimaitacha kimoshire ikanta irirori jaka, irooma eeroka iroñaaka ontzimatye pashironkaawaitaiya. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tekaatsi onkene pipoke, tzimatsi antawo impeeta otzikaimiri, eero okanta niyaatashitemi eeroka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Eekero ikantawetatya irirori: ‘Pinkemena nonkante chariné, potyaante jatatsine risaikira ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tzimatsi janta ikaatzi 5 nirentzi, pinkamanteri eero ripokanta irirori jaka, osheki rashironkaawaitaita.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ikantanakeri Abraham: ‘Eenitatsi Inintakaantakeri Moisés, eenitatsi eejatzi ikenkithatakeri Kamantantaneri, iroowa inkemisanterime.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ikantanake eejatzi: ‘Eerowa Chariné, Abraham. Tzimatsirika apaani kamatsiri kamantairine añaatsiri atziri, ari ripakagairo kaariperori rameyetari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eekero ikantanakitzi Abraham: ‘Tema te ikemisantziro ikenkithawetakari Moisés eejatzi Kamantantaneri, eerowa ikemisantziri iroñaaka inkamantantawetyaarika kaminkari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ikanta Jesús ikantanakeri riyotaanewo: “Ari intzimapiintatye antakaanterone kaariperori. Inkantamatsitaiteri jirika. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Itzimirika antakaakerine kaariperori oshiyakariri eentsi rawentagaana, ari rowasankeyeetairi. Iri kameethatatsi inthataitenirime mapi ikentsiki, rowiinkaiteri inkaareki, ompoñaantyaari eero ikaariperotakaantanta. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ontzimatye paamaakowentya eeroka. Tema intzimerika antzimotemirone kaariperori, pinkaminairi. Arika ripakaanairo rantayewetakari, pimpeyakotero rantzimowetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ari oshiyawo eejatzi. Tzimatsirika atziri osheki rantzimotakemi, onkaate 7 rapiipiintero apaaniki kiteesheri, ontzimatye papiipiinteri pimpeyakotakairi arika ripokashitemi inkowe pimpeyakotakagairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ikanta Rotyaantaperotanewo, ikantanakeri Jesús: “Nokowi poshiretakaaperotaina.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ari ikantanake Awinkatharite: “Onkantawetakya eero antawotzi poshiretaana, poshiyaawo okithoki oryaanikitatsiri pankirentsi, aritake pimatakero antawo inchato katziyainchari, pinkantero: ‘Pishirinke, pinkatziye inkaareki.’ Nonkante naaka, atake imatakya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tzimatsirika pimperatanewo, piñaawairi rareetaiya rowintawaitzira powaneki, ikempoyiirira pipira ¿arima pinkantawairi: ‘Pakiyootapaina?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tema eero, apatziro pinkantawairi: ‘Ponkotsitapai owanawontsi. Pomathakitya onkene poyiitena, nowawaitya, nirawaite nomere eejatzi. Eeroka impoitatsine poya.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Arima pinkimoshirewentakero okaatzi rantakeri pimperatanewo? Tema eero. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ari pinkantyaari eejatzi eeroka, arika pimonkaatakero inintakaimiri Pawa, pinkante: ‘Eero asagaawentawaita arika rimperayeetai, tema apatziro amonkaatero ikowakaitakairi anteri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ikanta rawisanake Jesús riyaate Jerusalén-ki, ikenanakero Samaria-ki ipoñagaawo Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ikanta rareetaka nampitsiki, ari ritonkyotakari 10 atziri pathaawaitatsiri, jantyaatsikaini ikatziyaiyapaakani. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ikaimimaita, ikantzi: “¡Yotaantanerí Jesús, pineshironkataina naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ari raminanake irirori, iñaatziiri ikatziyaiyani, ikantziri: “Piyaatashiteri Imperatasorentsitaarewo raminawakemiro pipathaawo.” Ikanta riyaataiyanakeni, omapokashitaka opeyanaka ripathaawo, etsiyatakotanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ikanta apaani iñaakero retsiyatakotai, thaamenta ripiyaawo irirori, ikimoshirewentanakeri antawoite Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rotziwerowashitapaakari iitziki Jesús, riwetharyaapaakari. Jirika piyaachari Samaria-satzi rinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Irojatzi ikantantanakari Jesús: “¿Tema 10 etsiyatakotaatsiri, tsika ikenakeka itsipa? ");
INSERT INTO cpbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tekaatsi nosheninka piyaatsine inkimoshirewentanairi Pawa riwetharyagaiyaari, apatziro ripiyaawo itsipasatzi atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Riñaanatanakeri Jesús pathaawaiwetachari, ikantziri: “Pinkatziye, piyaatai. Iroowa etsiyatakotakagaimiri poshiretaana.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ikanta Fariseo rosampitakeri Jesús, ikantziri: “Tsikapaiteka etantanakyaawo impinkathariwentantai Pawa.” Ari rakanake irirori: “Omapokashitaiya impinkathariwentantai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tekaatsi kantaatsine: ‘Jiroka jaka. Jironta janta.’ Tema mataka pinkatharishirewentantai Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ari ripithokashitanakari riyotaanewo, ikantziri: “Ari pinkowawetaiya paata piñeerime eepichokiini Itomi Atziri, eero okantzimaita. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ari pinkemake inkantaite: ‘Jirika jaka.’ Itsipa kantatsine: ‘Jirinta janta.’ Eero piyaatashitziri, eero poyaatziri eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Arika ripiyai Itomi Atziri, roshiyapaatyeeyaawo ookathawontsi, etanakyaawo tsika iweyaa kipatsi irojatzi tsika janta ithonka. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Etanakya iñagaitawakero antawoite rashironkawaitaitya, imanintawaitaiteri jirikapaini atziri tzimatsiri iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aritake oshiyaiyaawo okanta pairani eeniro risaikaweta Noé. Aritake onkantaiyaari eejatzi arika ripokimatai Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Inimotziri atziripaini rowawaita, rirawaitzi, raawakaawaita eejatzi. Irojatzi ikyaantanakari Noé antawoki pitotsi riwetsikakeri. Okanta oonkanaka kipatsiki, thonkaiyakani maawoini atziri ikamake. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ari oshiyaawo pairani eeniro risaikaweta Lot. Inimotziri atziri rowaiyani, rirawaitzi, riyomparitaiyani, ipankiwaitaiyini, riwetsikaiyini ipanko eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iro kantzimaitacha imonkaatapaaka kiteesheri rishitowantanakari Lot nampitsiki Sodoma, omapokashitaka oparyaapaake paampari, ari rithonkakari maawoini atziri ritagaa. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Arira onkantaiyaari eejatzi arika ripiyai Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tzimatsirika saikatsiri jakakeroki ipanko, ari impoñaanakya rishiyanake, eero ikyaapanaantzi raapanaante tsika oita. Itzimirika saikatsine rowaneki, rishiye tsika ikanta, eero ripiyapanaanta. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pinkenkithashiryaakotero awishitzimotakerori pairani iina Lot. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ikaatzi etakowaitachari apaniroini rantayetziro iñaawenatashitari, aritake impeyashiretaiya. Iriima inkaate kamawentenane rantanairo nokowakairiri naaka, aritake rawisakoshiretai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eekero ikantatzi Jesús: “Intzimai tsipatawakaachane rimaye. Apaani ragaitai inkiteki, iriima itsipa rookaitanairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ontzimai apite tsinane tsipatawakaachane itoonkawaite. Apaani ragaitai inkiteki, irooma otsipa rookaitanairo. ");
INSERT INTO cpbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Risaike apite atziri rowaneki. Apaani ragaitai inkiteki, iriima itsipa rookaitanairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ari rosampitaitanakeri Jesús, ikantaitziri: “¿Tsikajaantaka Pinkatharí?” Ikantzi Jesús: “Tsikarika risaiki kaminkari, ari rewotaiyani tziso.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ari roshiyakaawentanakero Jesús ompoñaantyaarime ramanaityaarime kiteesheriki, eero ripakagaitantawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ikantzi: “Eenitatsi nampitsi, ari risaikiri kaariperori pinkathari, te ipinkathatziri Pawa, te ipinkathatzitari eejatzi atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ari isaikitari tsinane kinankawo. Ipokashitakeri kaariperori pinkathari, okantziri: ‘Nokowi pinkaimenari kisaneentanari, piwetsikainawo awishimotanari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Te ikowaweta pinkathari. Irojatzi ikantashiretantakari: ‘Te nompinkathateri Pawa, eejatzi atziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iro kantacha jiroka kinankawo, ontzimatye nanteniro okowiri. Nisamawokari arika oomerencheena ipiyapiyatashitena.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ikantzi Jesús: “Piñaakero ikantashiretakeri kaariperori pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iri maperotzirori Pawa, te rishenkaantzi rantainiri kameetha rashiyetaari, kamaitanaawori ramanaiyaari kiteesheriki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eekero ikantatzi Jesús: “Eero rishenkagaita rantantaityaawori kameethari. Iro kantacha arika ripiyapaake Itomi Atziri, ¿eekeroma iñaapaatye awentaapiintaariri kipatsiki?” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Eeniyetatsi kenkithashiretachari kameethashireri rinatzi. Irojatzi imanintashirewaitantariri itsipa atziri. Irojatzi roshiyakaawentantanakanariri Jesús, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Eenitatsi apite atziri jatake tasorentsipankoki ramaña. Fariseo rinatzi apaani, iriima itsipa apatotziriri koriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ikanta ikatziyapaaka Fariseo ramana, ikantzi: ‘Ariwé Pawa, tema te noshiyari naaka itsipa atziri, koshintzi rinatzi, kaariperoshireri ikanta, mayempiri rinatzi, ari roshiyari apatotziriri koriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Apite nitzitapiintawo awisayetzira kiteesheri rimakoryaantaitari, nowapiintzi koriki ikaatzi ripinaitanari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ikanta apatotziriri koriki, ikatziyapaaka jantyaatsikaini, oiyotapaaka ramana te ramini jenoki. Tema rowashiretakoshiryaanakitya, ikantzi: ‘Pawa, pinkaminthagaina naaka, kaariperoshireri ninatzi.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ikantanake Jesús: “Iriitake raakameethaiteri jirika, kameethashire riyaatai ipankoki, te roshiyari itsipa. Tema ikaatzi iriiperowaiwetachari iroñaaka, ari intsinampashiretakagaitairi. Iriima ikaatzi tsinampashirewaitatsiri iroñaaka, aritake iñagairo ririiperotakagaitairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ikanta ramaitapaakeniri Jesús eenchaaniki, ikowaitzi riterotantyaari rako. Iri kantacha riyotaanewo Jesús, ikisathatawakeri amayetziriri eentsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Irojatzi ikantantanakari Jesús: “Pishineteri eenchaaniki ripokashitena. Eero pithañaana. Tema inkaate oshiyaarine eentsi, iriitake ñaagairone ipinkathariwentantaira Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Imaperotatya, eerorika ipinkathaitziri Pawa roshiyakotaityaari ikantaga eentsi, eero iñagairo impinkatharitai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ikanta apaani pinkathari rosampitakeri Jesús, ikantziri: “Kameethari Yotaantanerí, ¿oitaka nantairi noñaantaiyaawori kantaitaachane añaamentotsi?” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Irojatzi rakantanakari Jesús, ikantzi: “¿Oitaka pikantantanari: ‘kameethari pinatzi?’ Apatziro ikantakaawo Pawa ikameethatzi, tekaatsi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Piyotakotakeroma Inintakaantaitanewo, kantatsiri: Eero pitsitokantzi. Eero pimayempitzi. Eero pikoshitzi. Eero pithaiyakowaitanta. Eero pamatawitantzi. Pimpinkathateri ashitzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ari rakanake mainari, ikantzi: “Yotaantanerí, nithotyaakero maawoini netanakawo pairani eeniro neentsitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ikanta ikemakerira, ikantanakeri Jesús: “Tzimatsi kowapainchari panteri. Pimpimantero okaatzi pashitari, pimpashityaari ashironkaachari. Tema ari piñagairo pinintagaiya inkiteki. Pipoke, poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ikanta ikemawake, owashire ikantanaka, tema ashaagantzinkari rinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tema iñaakeri Jesús antawoite rowashiretanaka, ikantanake: “¡Imapero opomeentsita riyaatai ashaagantzinkari tsika ipinkatharitzi Pawa! ");
INSERT INTO cpbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tema eero okanta inkye piratsi camello imooki akoshi, iriitake maperotzirori impomeentsitya inkye ashaagantzinkari tsika ipinkatharitzi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ikantayetanake ikaatzi kemakeriri Jesús: “¿Iitakama awisakoshiretaatsine?” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Irojatzi ikantantanakari Jesús: “Eenitatsi pomeentsitzimotariri atziri, iriima Pawa tekaatsi pomeentsitzimotyaarine.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ari ikantanake Pedro: “Jirika nokaataiyakenika naaka, nookayetanakero tzimimoyetanari, noyaataiyakemini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ikantanake Jesús: “Imaperotatya, tzimatsirika kowanairori impinkathariwentairi Pawa, irootake rookantanakawori ipanko, ashitariri, irirentzi, iina, eejatzi rowaiyanepaini, ");
INSERT INTO cpbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tema osheki raakotakeri iwairo Pawa jirika, aritake anagairo okaatzi rookanakeri. Ari inkantaityaari eejatzi paata arika iñagairo kantaitaachane añaamentotsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ikanta Jesús rapatotairi 12 riyotaanewo, ikantziri: “Aatatye iroñaaka Jerusalén-ki. Ari imonkaatyaari awishimoterine Itomi Atziri, tema irootake rosankenatakotakeri pairani Kamantantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ari raakaantaiteri, rayeri atziri kaari asheninkata. Antawoite ishirontaminthaityaari, inkemaatsitakagaityaari, reewawootaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Arika onkaatake ripasawaitaiteri, ari rowamagaiteri. Iro awisawetakya mawa kiteesheri, ari rañagai eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iro kantzimaitacha, te ikemathatziro jirikapaini ikaatzi kemawetainchari, tema te ikowaitzi inkemathatakagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ikanta Jesús areetzimataka nampitsiki Jericó. Ari risaiki mawityaakiri awotsinampiki ikowakotantzi impashitaityaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ikemake mawityaakiri, rosampitakeri awisayetatsiri atziri, ikantziri: “¿Iitaka pokatsiri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ikantaitanakeri: “Ripokatzi Jesús, iitaitziri Nazaret-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Irojatzi ikaimantanakari, ikantzi: “¡Jesús, icharinetari David-ni, pineshironkataina naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Osheki ikisathaweetanakari imairetantyaari. Eekero ikaimanakitzi shintsiini, ikantzi: “¡Icharinetari David-ni, pineshironkataina naaka!” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ari ikatziyapaaka Jesús, ikantzi: “Pamakenari jaka.” Ikanta ramaitapaakeniri, rosampitawakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ikantziri: “¿Oitaka pikowiri nantaimiri?” Rakanake mawityaakiri, ikantzi: “Nokowi nokiryagai, Pinkatharí.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ikantanake Jesús: “Aritake pokiryagai, iro etsiyatakotakagaimiri pawentagaana.” ");
INSERT INTO cpbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Romapokashitanaka raminanai, royaatanakeri Jesús, kimoshire ikantawentanakari Pawa. Ikanta atziripaini iñaakero rantakeri Jesús, rimatanakero iriroripaini ithaamentawentanakari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ikanta rareetapaaka Jesús Jericó, ranashitapaakawo nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ikanta reeware apatotziriri koriki iita Zaqueo. Ashaagantzinkari rinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ikowaperotake irirori iñeeri Jesús. Iro kantacha te imata osheki atziri otzikaakeriri, ikaamokokitziini eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Irojatzi reewatantanakari Zaqueo, ateetapaake inchatoki onkene iñeeri Jesús, tema ari inkenapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ikanta rareetapaaka Jesús rateetakera Zaqueo, raminapaake jenoki, iñaapaakeri, ikantapaakeri: “Zaqueo, payiite intsipaite, ari noshiretawo nimaye pipankoki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Intsipaite rayiitanake Zaqueo. Kimoshire raanakeri ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ikanta iñagaitakeri, ñaawaitanake atziripaini ikantzi: “¿Iitaka ikyaawankotantariri Jesús kaariperoshireri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Irojatzi ikantantanakari Zaqueo: “Pinkatharí, ari nompakeri ashironkainkari niyanki nashaagawo. Tzimatsirika namatawitakeri nokoshitziri, ari noipiyainiri onkaate 4 nayitakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ikantanake Jesús: “Iroñaaka piñeero pawisakoshiretai. Tema pantanairo poshiyakotanaari rowawiiroki isheninkaani okaakiini Abraham. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tema iro ripokantakari Itomi Atziri rithotyaakoyetairi ikaatzi peyashiwetainchari, rowawisaakoshireyetairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Irojatzi ikemisantaiyakeni atziri ikenkithatzira Jesús. Irojatzi roshiyakaawentantanakanariri, tema ikenkithashirewetaiyani atziripaini koñaawoini impinkathariwentantai Pawa, tema irootaintsi rareetya Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ikantanake: “Tzimatsi jewari jatake otsipaki nampitsi, impinkatharitakagaiteri, eejatzi ripiyai. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ipiyotanakeri 10 rimperatanewo, ipanakeri 10 koriki, ikantayetanakeri: ‘Pantawaitakairi koriki nopayetakemiri, irojatzi nipiyantaiyaari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Iro kantacha eenitatsi kaari kowerine impinkathariwentante. Rotyaantaitake kantatsine: ‘Te nokowaiyini impinkatharite.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ikanta ripiyaa, ipinkatharitakaitakeri. Rapatotapairi rimperatanewo ipayetanakeriranki koriki, ikowi iñeeri tsika ikanta rantawaitakaakeri iyorikite. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Retapaakawo ripokake apaani, ikantapaake: ‘Pinkatharí, nosheñaakerira piyorikite, nagai itsipa ikaatzi 10.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ikantanake irirori: ‘Kameethatake nimperatanewo, okamintha pikyaaryootake eepichokiini, aritake piñaakero peewatakaantero nampitsi onkaate 10.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ari ripokapaake itsipa rimperatanewo, ikantapaake: ‘Pinkatharí, nosheñagaimiri piyorikite, nagai itsipa ikaatzi 5.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eejatzi ikantanakeri irirori: ‘Ari pinkantzityaari eeroka, aritake piñaake peewatakaantero nampitsi onkaate 5.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ripokapaake itsipa, ikantapaake: ‘Pinkatharí, jirika piyorikite kameetha noponatakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tema antawoite nothaawantzimi imaperotatziimi pimashireyantzitzi, te piñaakota posheñaantariri piyorikite.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ikantanake irirori: ‘Kaariperori nimperatanewo pinatzi. Eeroka atsipetyaawone okaatzi pikantakenari. Piyowetaka osheki nomashireyantzitzi, te noñaakoneta nosheñaantariri noorikite. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Piñaawetaka eero pimatziro, pamineme iita antawaitakairineme noorikite, ari ishenineentakeme iroñaaka, iri pimpawainarime nipiyaaga.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ari ikantanakeri atziripaini piyotainchari: ‘Paapithateri koriki, pimperi osheñaakeriri ikaatzi 10.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ikantaiyanakeni atziri: ‘Pinkatharí, ¿oitaka impantaityaariri, tema tzimatsi rashi irirori 10 koriki pipakeriri inkaaganki?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eekero ikantatzi ashitariri iyorikite: ‘Ikaatzi ishekitzimotakeri, ari ishekitzimoperotairi. Iriima kaari ishekitzimoperotzi, eekero iñaatyeeri eero ishekitzimoperotairi.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ikantanake eejatzi: ‘Pamakeri ikaatzi kisaneentanari kaari kowatsine nompinkathariwenteri, poñaayenari pithatzinkeri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Rithonkanakero ikantakeri Jesús, jewatanake riyaatziro Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ikanta rareetzimataka nampitsiki Betfagé eejatzi Betania imontenampitari otzishi Olivo. Ari rotyaantakeri Jesús apite riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ikantakeri: “Piyaate nampitsiki amontenampitakari. Ari piñaapaakeri ewonkeri burro inthatakotya, tekera ikyaakagaitariita. Pinthataryaakoteri, pamakenari jaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Arika rosampiitawakemi: ‘¿Piiterika pithataryaakotantariri burro?’ Pinkantanakeri eeroka: ‘Ikowatziiri Pinkathari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jataiyanakeni rotyaantaitakeri, iñaakero okaatzi ikantaitakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ithataryaakotapaakeri burro. Rosampitakeri ashitariri, ikantziri: “¿Piiterika pithataryaakotantariri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ikantanake irirori: “Ikowatziiri Pinkathari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Irojatzi ramantakanariri Jesús. Rowanketakeniri manthakintsi imitzikaaki, ikyaakaanakari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ikanta ranashitakaanakari Jesús burro, romaankashiitanakeri manthakintsi awotsiki inkenanakera. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ikanta riyotaapiintziri Jesús, oirinkimatanaka otzishiki Olivo, ikaimaiyini ithaamentawentari Pawa, tema iñaapiintziri ritasonkawentantzi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ikantaiyini: ¡Kaakitataike awinkatharite! Tasonkawentaarewo rinatzi, tema Pinkathari aitziri otyaantakeriri. ¡Risaikakaayetziri kameetha nampitawori inkiteki! ¡Iri kameethatatsiri oshekitzimotziri rowaneenkawo Pawa nampitawori ojenokiperotzinta inkite! ");
INSERT INTO cpbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ikanta Fariseo saikayetaintsiri eejatzi janta, ikantakeri Jesús: “Yotaantanerí, pinkisathateri piyotaanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Rakanake Jesús, ikantzi: “Arika nomairyaakeri ikaatzi kaimayetaintsiri, aritake onkaimanake mapi iroori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ikanta rareetzimatapaakaga Jesús Jerusalén-ki, riraakotapaakawo iñaapaakerowa. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ikantzi: “¡Osheki onkameethateme pinkemathatawakityeerome eepichokiini iroñaaka, irootake kiteesheri piñaantaiyaawori pisaikai kameetha! Iro kantzimaitacha eero imata tema mawityaaki ikantakagaitakemi. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tema irootaintsi ripoke kisaneentzimiri, riwetsikashitapaakemi rithonkantemiri. Rithonka rotzikapaakemi iweyaaga potanto, eero piñiiro tsika pinkene pishiye. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ari intzimpookaitakemi, rashiryagaityaari maawoini. Eero iñagaitairo mapipaini okaatzi pewiryaayetachari iroñaaka, okantakaantziro te piyotawakeri tsika itzimi pokashiwetakemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ikanta ikyaapaake Jesús tasorentsipankoki, rookapaakeri yompariyetachari. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ikantayetziri: “Pairani rosankenaitakero kantatsiri: ‘Nopanko inatzi jiroka, ari ramanapiintaitenari.’ Iro kantzimaitacha eeroka pamatawitantapiintake jaka pipimantayetzi, poshiyakaakero koshintzipanko.” ");
INSERT INTO cpbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rashi rowapaakitziiro Jesús riyotaantzi kiteesheriki tasorentsipankoki. Iri kantacha reeware Imperatasorentsitaneri, itsipatakari Yotzinkariite eejatzi Antariite, raminaminatakero tsika inkenakairo rowamaakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te iñiimaita tsika inkenakairo, tema owayempita ikantaiyakani atziripaini ikemisantziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ikanta Jesús riyotaayetakeri atziri tasorentsipankoki, ikenkithatakairi Kameethari Ñaantsi. Irojatzi ripokantapaakari reeware Imperatasorentsitaarewo, itsipatakari Yotzinkariite, ripokitaka Itzinkamipaini eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rosampitapaakeri Jesús, ikantziri: “Pinkantena, ¿Jimpe itzimajaantzika pinkathari otyaantzimiri pantantawori jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Irojatzi rakantanakari Jesús, ikantziri: “Tzimatsi eejatzi nosampitemiri naaka, ontzimatye pakena. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tema romitsitsiyaatantake Juan-ni, ¿iitaka otyaantakeriri? ¿Pawama? ¿Iriima otyaantakeri atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ari ikantawakaiyanakani irirori: “Arika ankantakeri Pawa otyaantakeriri, ari inkantanakai: ‘¿Oitaka kaari pikemisantantari?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Irooma ankanteririka: ‘Tema atziri otyaantakeriri’, ari rishemyagaitakai. Tema maawoini atziripaini ikantaiyini Kamantantaneri rinatzi Juan-ni.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ari ikantaiyakeni: “Te niyote iita otyaantakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ari ikantzitanakari Jesús irirori: “Eejatzi naaka, eero nokamantzimiro iita otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ikanta Jesús roshiyakaawentanakeniri atziripaini, ikantzi: “Tzimatsi pankitzirori chochokimashi. Irojatzi raminantakari iita aminerone iwankiremashi, jatake irirori intaina osheki ipeyaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ari rotyaantawetaari rimperatanewo ragaateme okithoki iwankire. Ikanta iñaawakeri antawairentzi, ripasapasatawakeri, roipiyairi tekaatsi raanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Rotyaantake itsipa. Eejatzi roshiyakaawakeri, ikisawaitawakeri, romposaposaatawakeri, roipiyairi tekaatsi raanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Irojatzi rotyaantantakariri mawatanaintsiri rimperatanewo. Eejatzi roshiyakagaitakeri, rantawakeri, roipiyakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ikantzi ashitawori iwankiremashi: ‘¿Tsika nonkantyaaka? Iriirika notyaantake netakotanewo notomi naaka, aamaaka ari impinkathaitakeri.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ikanta antawairentzi iñaawakeri itomi ripokake, ikantawakagaiyani: ‘Pokake ashitaiyaawone paata pankirentsimashi. Jame owamayeri, ayeroota aaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Raawakeri, raanakeri othapiiteki pankirentsimashi, rowamaakeri. ¿Oitaka ranteri ashitawori pankirentsimashi? ");
INSERT INTO cpbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tema pokanake irirori, rowamaakeri maawoini kempoyiirori rowane, raminai itsipa atziri.” Ikanta jirikapaini ikaatzi kemakerori ikantakeri Jesús, ikantaiyanakeni: “¡Onkamintha eero imata!” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ikanta Jesús raminanakeri atziripaini, ikantanakeri: “¿Tsika okantziranki osankenatainchari? Imanintawetakawo mapi jirikapaini wetsikirori pankotsi. Iro kantzimaitacha ipiriintaitairo mapi pankotsinampiki, roshiyakaitairo iroome tzinkamitsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jiroka okantakota mapi: Iitarika ontziwatyaawone, ari risataake. Iriima anawyagairi, ari ishemyaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ari ikowawetaka reeware Imperatasorentsitaarewo itsipatakari Yotzinkariite raakaanterime Jesús, tema riyotake iriitake ikenkithatakotzi. Temaita rimatziro, osheki ithaawantakari atziri piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Irojatzi rotyaantantaitakariri aminaantantaneri, roshiyakotapaakyaari atziri kameethashireri, ikowaiyawetani rikompitakayaarime Jesús, inthawetakotzimaityaari pinkathariki. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ikanta rareetaiyakani, ikantapaakeri Jesús: “Yotaantanerí, okaatzi piñaanetari eeroka irooperori inatzi, kaari Inintakaantashitari atziri. Piyotaantziro eeroka irooperori Inintakaantziri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Okameethatzima amperi koriki ikowakaantane Pinkathari César?” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iri kantzimaitacha Jesús riyotawake ikowatzi ramatawiteri ikaatzi osampitakeriri, ikantanakeri irirori: “¿Oitaka piñaantantanari? ");
INSERT INTO cpbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Janjaatya poñaayenari koriki. ¿Iitaka ashitawori ipoo oshiyakaawentainchari? ¿Iitaka ashitawori iwairo eejatzi?” Ikantaiyini: “Rashi César.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eekero ikantatzi Jesús: “Tema iri César ashitari, pantantyaanari okaatzi ikowakayimiri. Iriima ikaatzi rashitari Pawa, pantantyaanari ikowakaayetzimiri irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Te roitsinampairi rikompitakayaari, apatziro riyokitziiwentanakeri ikemakeri ikantake, tekaatsi inkantanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ikanta ripokaiyakeni Sadoc-iite iñeeri Jesús. Iriitake Sadoc-iite kantayetatsiri eero rañagai kamayetatsiri. Rosampitapaakeri Jesús, ");
INSERT INTO cpbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ikantapaakeri: “Yotaanarí, rosankenatake pairani Moisés-ni, kantatsiri: ‘Arika inkame atziri, rookanawentanaiyaawo iina. Eerorika rowaiyakaawo, okameethatzi ragairo irirentzi iinantaiyaawo irirori. Arika rowaiyakagaiyaawo tsinane, oshiyawaityaawo iriime ashityaarineme irirentzi kamaintsiri.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jame oshiyakaawentawakero: Tzimatsi ikaatzi 7 irirentzi. Etawori itzimi raawetaka iina, tekera osamaniteeta, kamake, te rowaiyakaawo iina. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Irojatzi raantawetaawori itsipa irirentzi oyaatapaakeriri. Eejatzi ikantakari irirori, kamake, te rowaiyakaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ipoñaawetapaaka itsipa irirentzi, eejatzi ikantaka irirori. Ari ikantakari maawoini irirentzi ikaatzira 7. Tekaatsi owaiyakayaawone tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Okanta osamanitake kamai eejatzi iroori. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Arika rañaayetaime paata ikamayetakera, ¿Iitaka oimentaperotari tsinane? Tema oimentawetakari ikaatzira 7.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ari rakanakeri Jesús, ikantanakeri: “Apatziro raayetzi iina atziripaini añaayetziri iroñaaka jaka, rakotagaitziri kowatsiri iina. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Iriima añagaatsine paata ikamawetakaga, eero raayetai iina, eero rakotagaitairi kowatsine iina. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tema eero ikaamanetapai janta, roshiyapaiyaari maninkariite, tema itomi Pawa rinayetaatzi rañaayetai. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jiroka ikenkithatakoitziri rañaayetai kamayetaintsiri, ¿tema piñaanatero rosankenare Moisés-ni riñaanatantakariri Pawa kitocheemaishiki? Ikantakeri: Moisés, Naaka Pawa, ipinkathatziri Abraham, Isaac, eejatzi Jacob. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ari ayotziri, añaayetatsi irirori, tema te rimatziro kaminkari impinkathateri Pawa, apatziro añaayetatsiri. ¿Piñaakero? Tema ikaatzi kamayewetachari, irojatzi rañiimotziri Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ari ikantanake apaani Yotzinkari: “Yotaantanerí, pimatakerowa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tekaatsi kowanaatsine rosampitanairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ikanta Jesús rosampitantake, ikantzi: “¿Oitaka ikantantaitari, ‘jirika Cristo-tatsine, iriitake incharinetyaari David-ni?’ ");
INSERT INTO cpbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tema iri David-ni osankenatakerori kantatsiri: Ikenkithawaitake Pinkathari, ikantawairi Nowinkatharite, ikantziri: Pisaikapai nakoperoki, ampinkathariwentantai, ");
INSERT INTO cpbNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Irojatzi paata nowasanketantaiyaariri kisaneentayetakemiri, Ari pimakoryaayitzitantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Piñaakero, ikantzita David-ni irirori: ‘Nowinkatharite rinatzi Cristo.’ ¿Iitama incharinetantaityaariri David-ni?” ");
INSERT INTO cpbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maawoini atziripaini ikemaiyakerini Jesús ikantakeri riyotaanewo: ");
INSERT INTO cpbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Paamaiyaari Yotzinkariite. Osheki iñaamatawo rowaneenkakitya, ishametakaayetero iithaarekoryampyaa. Ikowi pinkatha riwethatapiintaityaari arika iñagaiteri. Arika riyaate pankotsiki rapatotapiintaita, ikowapiintziro rosatekya niyankineki. Ari ikantzitari arika rowaiyaani isheninka, ikowapiintzi rosatekya. ");
INSERT INTO cpbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rowashironkaakero kinankawo raapithatziro opanko. Iro rosamaninkantayetawori ramanapiinta eero riyotantaitari. Oshekimaita rowasankeyeetairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ikanta Jesús raminaminthatziri ashaagantzinkari roteyetziri iyorikite janta rotetapiintaitzirira. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Irojatzi ipokantapaaka kinankawo tsinane ashironkainkawo inatzi, otetapaake iroori apipentyakite koriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ikantzi Jesús: “Imapero anaantake jiroka tsinane, anaakeri ikaatzi oteyewetainchari. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tema ikaatzi oteyewetainchari osheki ikashaakaawetariri Pawa, rotetashitakari tzimagaantatsiri iyorikite. Irooma jiroka tsinane, apintziryaakeri otetakeri oorikite amanantantyaarime owanawo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eenitatsi kantayetaintsiri: “Kameetha inatzi mapi riwetsikantaitawori tasorentsipanko, owaneenka okanta.” Irojatzi ikantantanakari Jesús: ");
INSERT INTO cpbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Okaatzi piñiiri wetsikayetainchari, irootaintsi rithonkaitero intzimpookaitero, eero iñagaitairo pewiryaayetachari mapi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ari rosampitaitanakeri, ikantaitziri: “Yotaanarí, ¿tsikapaiteka imatya pikantakeri? Arika imonkaatzimatakya, ¿onkantyaaka riyotantaityaari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ari rakanake Jesús ikantzi: “Paamaiya ramatawitaitzimikari. Tema osheki kowatsine ramatawitemi paata, raakotapaakero nowairo, inkante: ‘Irootaintsi imonkaatzimatya, Naakaga Cristo.’ Eero poyaatziri. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ari pinkemakotakero omanarentsi, koshekawakagaantsi, paamaiya omapokimikari, ontzimatye imonkaayetya jiroka, eekero iyaatanakitye imaperotya. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rantaminthatawakaanakya maawoini nampitsiki inkaate rotyaantayeteri pinkathariyetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iñagaitero osheki omoyekayetya kipatsi, ritasheneentayeete, imantsiyataite. Iñagaite osheki inthaawantaityaari, iñagaite inkiteki kaari iñagaitapiintzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Iroowa etayetanakyaawone raakaantawaitanakemi atziri, inkoshekakaantawaitemi. Ari ripasatakaantawaitemi rapatotapiintaitaga, romonkyaakaantawaitemi. Raayetanakemi risaikira pinkatharentsipero okantakaantziro paakotaana nowairo pikemisantaanaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Irootake antantari jiroka ompoñaantyaari pinkenkithatakotantenari janta. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ontzimatye pawentaina naaka, eero pipomeentsiwentashitawo oita pinkantapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tema naaka yotakaimirone, ompoñaantyaari eero piñaantawo ripiyatemi onkaate pinkanteriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ari piñaake raakaantemi ashitzimiri, raakaantemi pirentzi, raakaantemi pisheninkathori eejatzi. Eeniyetatsi rowamaakaantaite. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Osheki piñeero inkisaneentaitemi okantakaantziro paakotaana nowairo pikemisantaanaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iro kantzimaitacha eero opeyagaantawaita apaani piishi. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Arika pinkisashitakyaawo, iroowa piñaantaiyaawori pawisakoshireyetai. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Arika piñaake rotzikapaakero owayeripaini Jerusalén, ari piyote monkaatapaaka raperoitantyaawori. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Inkaate nampitaiyaawone paata Judea-ki, rishiyayetai otzishiki. Inkaate saikatsine nampitsipainiki, ari impoñeeya rishiyanake. Inkaate saikatsine rowaneki, eero ripiyapanaanta ipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tema ripiyakowentaitatziiri jirikapaini, ari imonkaatyaari rosankenaitakeri pairani. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Inkantamatsitaitero paata onkaate motziyetatsine, eejatzi onkaate tzimatsine eentsite eeniro ithotayetzi iteni! Tema antawo onkantya rashironkagaitya arika rowasankeyeetairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Rithonkaitairime Jerusalén-satzi. Rimperatanewo rowayetairi atziri poñaayetachari otsipaki nampitsi. Iriitake oipatsiterone nampitsi Jerusalén itsipasatzi atziri, irojatzi imonkaatantaiyaari okaatzi ikowakaakeriri Pawa jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ari iñagaitake paata kaari iñagaitapiintzi inkiteki, impashiniyetai ooryaatsiri, kashiri, eejatzi impokiro. Ari onkantzityaari kipatsiki, antawoite rashironkaayetya atziripaini, eero riyotai oita rantairi, onkantakaantero owaimanka otamakaare inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Owamayimatakeri ithaawanka atziripaini inkenkithashiretakotero awisatsine kipatsiki. Ari inkantzitakyaari eejatzi inkiteweri oshekitzimotziri ishintsinka, osheki inkantakantayetanakya. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aripaitera ripokai Itomi Atziri, inkenapai menkoriki, iñagaitawairo ishintsinka, eejatzi rowaneenkawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Arika piñaayetakero etanakyaawo kantayetachane, aminapiinta pinkantya jenoki, tema irootaatsi rontsiparyaakowentaitaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Irojatzi roshiyakaawentantanakanariri, ikantzi: “Pinkenkithashiretakotero tsika okanta piñaayetapiintziro inchatopaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Arika piñaakero eereshiyetai, piyotzi irootaintsi osarentsitzimatai. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iroowa piyoteri eerokapaini, arika piñaayetakero nokamantayetakemiri, irootaintsi impinkathariwentantai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Imaperotatya nonkante, eero ipeyaawo jirika asheninkapaini, irojatzi iñaantakyaawori nokamantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eero ashi owero piñeero inkite eejatzi kipatsi, irooma niñaaneyetakari imaperotaatyeeya iroori. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aamaawenta pinkantayetaiya eerokapaini, eero ityiimi piyaariperonka, ayimawaitemi pishinkitya, onkantzimowaiyetemi. Kyaaryoowa romapokaitzimikari. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Eenitatsi oshiyapaakyaawone iwirentsi. Ari riwitaiyaari saikayetatsiri kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paamaiya, kamaita pinkantya pamaña, pinkante: ‘Pookaakowentena eero nokemaatsitantawo kenkithatakoyetainchari. Piwetsikashiretakayena nitonkyotantawaiyaariri Itomi Atziri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tema kiteesheriki riyotaantzi Jesús tasorentsipankoki. Irooma tsireniriki, riyaatzi tonkaariki Olivo, ari rimayi. ");
INSERT INTO cpbNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ananinkayetake osheki atziri ikemisantziri Jesús riyotaantzi tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Irootaatsi roimoshirenkaitero rowantapiintaitawori tashirentsiponka iitaitziro kiteesheri Anonkoryagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ari ikamantawakaari reeware Imperatasorentsitaarewo itsipatakari Yotzinkariite, ikantawakaiyani: “Jame owamaakaanteri Jesús.” Iro kantzimaitacha antawoite ithaawantakari atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ikanta Judas iitaitziri eejatzi Iscariote kaawetachari 12 riyotaanewo Jesús, ikyaantashiretanakari Satanás. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Riyaatashitakeri reeware Imperatasorentsitaarewo, eejatzi reeware kempoyiirori tasorentsipanko, ikenkithawaitakaakeri tsikapaite raakaanteri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Antawoite ikimoshiretanake jewari, ikamantawakaiyakani imperi koriki. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Arira raminaminatanakero Judas tsikapaite raakaanteri, eero riyotzimaita atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ari imonkaatakari kiteesheri rowantapiintaitawori tashirentsiponka, rowamaapiintaitantariri eejatzi oweja rowaitari kiteesheriki Anonkoryagaantsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ikanta Jesús rotyaantakeri Pedro itsipatanakari Juan, ikantakeri: “Piyaate ponkotsitakaante oyaari kiteesheriki Anonkoryagaantsiki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ikantaiyini irirori: “¿Tsika pikowika nonkotsitakaante?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ikantanake Jesús: “Arika pareetzimatakya nampitsiki, ari pitonkyotakya aakotzirori iñaate chomaanikiki. Poyaatanakeri irojatzi pankotsiki tsika inkyaapaake. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tsikarika inkyaapaake, pinkanteri ashitawori ipanko: ‘Ikowi riyote yotaanari tsika rowakayaari riyotaanewo, roimoshirenkero kiteesheri Anonkoryagaantsi.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ari roñaaganakemiro jenoki ipanko, antawo okantaka riwetsikaitakero onkene rowaitya. Ari ponkotsitakaanteri janta.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jataiyakeni riyotaanewo, iñaakero okaatzi ikantakeriri, ari ronkotsitakaantakeri royaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Okanta imonkaataka rowantyaari, saikapaake Jesús itsipatakari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Irojatzi ikantantakariri: “Irootaintsi noñeero inkemaatsitakagaitena, antawoite nokimoshiretzi owaiyanira iroñaaka kiteesheriki Anonkoryagaantsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tema eero nowitaawo jiroka, irojatzi paata imonkaatantaiyaari impinkathariwentantai Pawa, aripaite napiitairo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Irojatzi raakotantakawori riraitziri, riwetharyaawentanakawo, ipakotakeri riyotaanewo, ikantakeri: “Pirero jiroka, pantetyaawo pikaataiyinira. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tema eero niritaawo naaka, irojatzi paata arika imonkaataiya impinkathariwentantai Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Irojatzi raantanakawori pan, riwetharyaawentakawo, itzipetowakero, ipayetakeri riyotaanewo, ikantziri: “Poyaawo, nowatha inatzi, irootake kamawentemine. Irootake pinkenkithashiryaapiintantenari.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ari ikaatanakero rowaiyanira, raakotakero riraitziri, ikantzi: “Niraa inatzi, irootake shitowaatsine rawisakotantaiyaari osheki atziri. Irootake oñaagantairone owakerari aapatziyawakagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Imaperotatya nonkante: Pikaataiyakenira pakiyootana, eenitatsi pithokashitenane raakaantena. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tema imaperotya impeya Itomi Atziri, ari imonkaatakari ikowaitakeri pairani. Iro kantacha, ¡inkantamatsitaiteri aakaanterine!” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Irojatzi riñaanatawakaantanakari riyotaanewo, ikantzi: “¿Iitaka koshekachane?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ikanta riñaanatawakagaiyanakani riyotaanewo, ikantzi: “¿Itzimika iriiperotatsine paata?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Irojatzi ikantantanakari Jesús: “Piyotaiyini eeroka tsika ikanta pinkatharitatsiri jaka, rimperatanta. Tema iriiperori rinayetzi ipashitantayeta ikosheka rimperatantantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eero pimatziro eerokapaini arika piriiperoyete iroñaaka, ontzimatye poshiyakotyaari iyaapitsi rowaiyaitziri. Arika peewatakaante, poshiyakotyaari onampirentsi ");
INSERT INTO cpbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Tsikama itzimi iriiperotatsiri? ¿Tema iriitake iriiperotatsiri oshiyariri oyaawentachari rantawaitaiteniri? Irooma naaka noshiyaari pantawaitakaaneme powena. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iro kantzimaitacha, eerokapaini pitsipatapiintakena, noñaayetzirowa pomeentsitzimoyetanari. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irootake nokashaakaantakemirori pimpinkathariwentante, ari ikantakenari Ashitanari naaka ikashaakaakenawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ari piñeero ankaate owaiyaani, irawaitaiyeni janta tsika nompinkatharitai. Ari poshiyakotaiyaari pinkathari risaikantawo owaneenkatachari risaikamento, pimpinkathariwentairi maawoini icharineyetari Israel, kaatatsiri 12 rinashiyeta.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ikanta Jesús ikantanakeri riyotaanewo: “Simón, ikowakemi Satanás iñaantashiretemi, roshiyakaimi ritsikaatatyeemime. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iro kantzimaitacha osheki namanakoyetakemi eero pipakaantawo pikemisantanairi. Tema arika pipiyashiretapaake, eerokatake aawyaashiretakaapairine pisheninka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ari rakanake ikantanake: “Tema ari ankaate Pinkatharí romonkyagaitai, aritake ankaate eejatzi rowamagaitai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Irojatzi rapiitantanakawori Jesús ikantziri: “Pedro, nonkantemi, iroñaaka tsirenirikika, tekera riñiita tyaapa, mawa papiitero pinkantake: ‘Te noñiiri Jesús.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ikanta Jesús rosampitanakeri riyotaanewo, ikantziri: “Chapinki notyaantakemi te paanake pithaate, te paanake pizapato-te. ¿Eenitatsima kowimotakemiri?” Ikantaiyini irirori: “Tekaatsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Irojatzi ikantantariri eejatzi: “Kameethatatsi iroñaaka payero pithaate. Kaari tzimatsiri rosataamento, impimantero iithaare, ramanantantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tema imapero imonkaatya rosankenatakoitakenari pairani, kantatsiri: Ari intsipatagaitakeri kaariperoshireri. Eero awisashita jiroka, ontzimatye imonkaatya.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ikaimaiyanakeni riyotaanewo: “Pinkatharí, tzimatsi jaka apite osataamentotsi.” Ikantanake Jesús: “Ataama.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ikanta ikenanai Jesús otzishiki Olivo ikenapiintzira, ari itsipatanari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ikanta rareetaiyakani janta, ikantanakeri riyotaanewo: “Pamanaiyaani eeroka jaka inkempoyaawentantaitemiri otzimikari inkenakaashitakagaitemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ari rowaaganeentanakari irirori. Otziwerowapaaka kipatsiki, amanapaaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ikantzi ramana: “Ashitanarí, iroorika pikowakaanari, paawyaakainawo pookapithatenawo onkaate nonkemaatsityaari. Iro kantzimaitacha, eero pantanawo nokowawetari naaka, iro pante pikowakaakenari eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ari romapokapaaka maninkari poñagainchari inkiteki, iñaaperoshiretakaapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tema antawoite okantzimoshiretanakari, ramanaperotanaka. Iro ishitowantanakari imasawinka oshiyawaitanakawo iro thaatanainchari riraa ipitenkapaaka kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ikanta ramanaka, piyapaaka, iñaapaatziiri riyotaanewo rimagaiyini okantakaawo rowashiretaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ikantapaakeri: “¿Iitaka pimaantari? Pinkaakitaiyeni, pamaña eeroka inkempoyaawentantaitemiri otzimikari inkenakaashitakagaitemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ikenkithawaiminthaitzi Jesús, iñaawakitziiri pokaiyaintsirini. Iri jewatapaintsi Judas kaawetachari ketziroini 12. Rontsitokapaakari Jesús ithowootapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ikanta Jesús ikantawakeri: “Judas, ¿Arima pipithokashityaari Itomi Atziri pithowootapaakeri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ikanta iñaawakeri itsipatakari Jesús, ikantanakeri: “Pinkatharí, jame apiyatantyaari osataamento.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Akotanake, rithatzinkitakeri rakoperoki ikempita rimperatanewo reewaperore Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ikantanake Jesús: “Ataama, eero pikoshekari.” Ipampitzitairi ikempita, etsiyatakotanai rithatzinkitawetakarira. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ikanta Jesús ikantanakeri pokashitakeriri, reeware Imperatasorentsitaarewo, kempoyiirori tasorentsipanko, Itzinkamipaini, ikantziri: “¿Naakama koshintzi pamashitantanari posataamento, eejatzi pipasamento? ");
INSERT INTO cpbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿Tema piñaawetapiintana tasorentsipankoki niyotaantzi? ¿Kaarima paantana janta? Aritake onkantya, tema aripaite rimatakaimiro tsireniriweri kaari pimatzi pairani.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ikanta roosoitanakeri Jesús, ragaitanakeri risaikira reewaperore Imperatasorentsitaarewo. Impoitatsi Pedro irirori royaatakowentziri Jesús jantyaatsikaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Irojatzi roonthotaitantaka paampari pankotsinampiki, rakitsitaiyani. Ari risaikitapaaka irirori Pedro rakitsita. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Okanta tsinane imperataarewo, oñaapaakeri Pedro risaiki rakitsita. Opampoyaapaakeri, ari okantzi: “¿Tema irijatzi jirika itsipatapiintakari Jesús?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Iri kantzimaitacha Pedro, ikantanake irirori: “Te noñiiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Okanta osamaniityaake, ikenapaake itsipa, ikantapaakeri Pedro: “¿Tema eejatzi eeroka ari pikaatziri Jesús?” Ikantanai Pedro: “Tera naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Iro osamani eejatzi, tzimatsi itsipa kantapaakeriri Pedro: “Imaperotatya, eerokatake tsipatariri Jesús chapinki, tema Galilea-satzi pinatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Irojatzi ikantantanaari Pedro: “Te niyotziri iita pikantanari.” Aripaite riñaanake tyaapa. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ari ripithokapainta Jesús, raminapaintziri Pedro. Irojatzi ikenkithashiretantanakari Pedro ikantakeriri ketziroini: “Tekera riñeeta tyaapa, mawa pinkante: ‘Te noñiiri Jesús.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Shitowanake jakakeroki, antawoite riraawaitanaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ikanta jirikapaini ikaatzi kempoyiiriri Jesús, ishirontawentawaitakari, ripasawaitanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rotzimikawootakeri, romposawootzimaitari, ikantziri: “¿Kamantantaneri pinatzi, janjaatya piyote iita pasawootakemiri?” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tzimatsi osheki oita ikantawaitziriri kaariperori ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Okanta okitaitamanai, rapatotaiyakani reewaperore Imperatasorentsitaarewo itsipatakari Itzinkamipaini, eejatzi Yotzinkariite. Ari ramaitakeri Jesús, rosampiitakeri, ikantaitziri: ");
INSERT INTO cpbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Pinkantena, ¿Eerokatakema Cristo?” Ikantanake irirori: “Arika nonkantakemi, eero pikemisantana. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Arika nosampitemi, eero pakana, eero pipakaana eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iro kantzimaitacha retanakyaawo iroñaaka, iñagairo Itomi Atziri risaikai rakoperoki Pawa roñaagantairo ishintsinka.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Irojatzi rosampitantanakariri apatowentakariri, ikantziri: “¿Eerokama Itomi Pawa?” Ikantanake Jesús: “Eerokatake kantaintsi naakatake.” ");
INSERT INTO cpbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Irojatzi ikantantanakari jirikapaini: “Aakaite kemakeriri. ¿Iitaka ankoweri iroñaaka?” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ikanta ikatziyaiyanaani ikaatzi apatotainchari, raanakeri Jesús Pilato-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ikantapaakeri Pilato: “Jirika atziri osheki rowaariperotakero nampitsi, ikaminaakeri atziripaini eero ipantaari koriki pinkathari César, ikantake eejatzi Cristo rinatzi iri pinkatharitatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ikanta Pilato, rosampitanakeri irirori, ikantziri: “¿Eeroka iwinkatharite Judá-ite?” Ari rakanakeri ikantzi: “Irootake pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ikantziri Pilato Imperatasorentsitaarewo, eejatzi maawoini atziripaini: “Tekaatsi noñe oita inkenakaashityaari jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iri kantzimaitacha atziripaini eekero ishintsitanakitzi ikantzi: “Osheki ikaminaantake jirika inkoshekantya atziripaini nampitsiki, retanakawo Galilea-ki irojatzi iroñaaka jaka Judea-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ikanta ikemawake Pilato ikaminaantake Galilea-ki, rosampikowentanakeri Jesús iriirika Galilea-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ikematzi ikantaitzi iriitake. Rowawisaakeniri pinkathari Herodes ripoki irirori rareeta Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ikanta Herodes iñaawakeri Jesús, antawoite ikimoshiretanake, tema osheki ikowawetapiintaka iñeeri, osheki ikemakowentakeri eejatzi okaatzi rantayetakeri, ikowaperotake iñeeri irirori ritasonkawentante. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Osheki rosampitawakeriri. Iri kantzimaitacha Jesús te rakiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ari risaikitakari reeware Imperatasorentsitaarewo itsipatakari Yotantaneripaini, osheki ikantakowetakariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ikanta Herodes itsipatakari rowayerite irirori, ikisashiryaanakeri, ikaweyawaitanakeri. Ikithaatantakari irooperori kithaarentsi, roipiyairi risaikira Pilato. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aripaite raakameethatanakeri Herodes jirika Pilato, tema pairani osheki ikisaneentawakaawetaka. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ikanta Pilato rapatotakeri reeware Imperatasorentsitaarewo itsipataakeri ikaatzi jewatakaantatsiri nampitsiki, eejatzi maawoini atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ikantakeri: “Tema pamawetakenari jirika atziri owaariperoteroneme nampitsi, nosampisampiwetakari, te noñiiro onkaariperote okaatzi rantakeri ikantakoitziriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ari ikantakari eejatzi Herodes, tema notyaantawetakanari irirori. Tekaatsi rante jirika atziri ompoñaantyaari owamaakaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Apatziro nipasatakaanteri naaka, nipakagairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iroowa rametapiintari Pilato romishitowakaantziri omonkyaakaantaarewo kiteesheriki roimoshirenkaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iro kantzimaitacha ikantaiyanakeni atziripaini: “¡Te nokowiri jirika! ¡Iri pomishitowakaante Barrabás!” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jirika Barrabás iri romonkyaakaantaitziri okantakaantziro ritsitokantzi ikoshekakari pinkatharitatsiri nampitsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ari rapiiwetanakawo Pilato tema ikowawetatya irirori ripakaakaantairime Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Iro kantacha rapiitanakero atziripaini ikaimaiyini: “¡Pinkentakotakaanteri, pinkentakotakaanteri!” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Iro mawawetainchari rapiiwetakawo Pilato rosampitantzi: “¿Oitaka kaariperori rantakeri jirika? Tekaatsi oita rante, eero okanta owamaakaantashityaari. Apatziro nipasatakaantashityaari, riyaataita.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eekero ishintsitatzi atziripaini ikaimaiyini, ikowi inkentakoiteri Jesús. Rimatzitanakawo ikaimaiyini reeware Imperatasorentsitaarewo, ari imatakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Irojatzi rantantakawori Pilato okaatzi ikowakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Romishitowakaantakeri tsitokantzinkari koshekariri pinkatharitatsiri nampitsiki, iriitake ikowaiyakerini atziripaini. Rishinetakeniri inkantawaiteri Jesús ikowakaari iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ikanta ragaitanakeri Jesús, ritonkyotaitakari jitachari Simón poñaachari Cirene-ki, ari rareetaka irirori ipoñagaawo rowaneki, ishintsineentanakeri inatanakero inkentakoitantyaariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Osheki atziri oyaatakowentanakeriri Jesús. Eenitatsi tsinane iraakotanakariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Raminapaintziro Jesús okaatzira tsinane iraakotakariri, ikantziro: “Jerusalén-sato, eero piraakowaitashitana naaka, piraakotaiya eeroka, eejatzi powaiyanepaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tema irootaintsi piñeero inkantayeetai: ‘Kimoshire onkantya tsinane kaari owaiyachane, othotaantashitakari.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Arira inkaimayeetai, inkantaite: ‘Pitaankashitena impeeta, pinkitatenaata.’ ");
INSERT INTO cpbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tema piñaakero tsika ikantaitakero inchato añiinkawo, iro rimaperoite kaminkawo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ari ragaitanake eejatzi apite kaariperoshireri itsipatagaitanakeri Jesús rowamagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ikanta rareetakagaitapaakari iitaitziro atziriitoni, ari ikentakoitakeri. Ikentakoitake apaani kaariperoshireri rampateki, iriima itsipa rakoperoki. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ikantanake Jesús: “Ashitanarí, te riyotzi oita rantziri kemaatsiwaitakaakenari, pimpeyakoteri.” Irojatzi ragaitantakawori iithaare Jesús rookaitawakaakawo, roshiyakaakero inewiyataita. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Irojatzi raminaiyakeni atziripaini. Rimatzitakawo jewatakaantatsiri nampitsiki, rithainkimatakeri Jesús, ikantziri: “Rowawisaakotziri itsipa, ¿kaari rimatantawo rowawisaakotya irirori? Iriime Cristo riyoyaanewo Pawa, ari rimatakerome.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rimatzitanakawo eejatzi owayeripaini, rithainkakeri Jesús, irojatzi ramakotantanakari kepishaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ikantapaakeri: “Janjaatya powawisaakotya, kyaaryooperorika eeroka iwinkatharite Judá-ite.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tzimatsi osankenarentsi ikentakoitakeri jeñokiini ipatziitoki, riñaaneki Judá-ite, riñaaneki Roma-satzi, riñaaneki eejatzi Grecia-satzi, okantzi: “IWINKATHARITE JUDÁ-ITE.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ari rimatzitakawo eejatzi riñaanaminthatziri apaani kaariperoshireri itsipatakarira ikentakota, ikantziri: “Eerokatakerika Cristo, powawisaakotya, powawisaakotzitena naaka eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Irojatzi rakantanakari itsipa kaariperoshireri, ikisathatanakeri ñaanatakeriri Jesús, ikantziri: “Pimatzitawoma eeroka te pipinkathatziri Pawa, ari akaatakeri rowasankeyeetai. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tema eenitatsi antakeri aaka añaantakawori rowasanketaitai. Iriima jirika rowasanketashitaitari, te rantziro kaariperori.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ripithokashitanakari Jesús, ikantziri: “Pinkatharí, eero pipeyakotana naaka paata arika pipiyai pimpinkathariwentantai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Rakanake Jesús, ikantzi: “Imaperotya nonkantemiri, aritake pintsipatapaina iroñaaka janta tsika ikimoshireetapai.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ikanta itampatzikatapaake ooryaatsiri, omapokashitapaaka otsirenikitanake, irojatzi ishaawiiteeni ithaperotanakaga ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ari ritsiwakanakeri ooryaatsiri. Okanta janta tasorentsipankoki, saperyaanake niyanki tontamawotatsiri ithatashiitzirori. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Irojatzi ikaimantanakari Jesús shintsiini, ikantzi: “Ashitanarí, paawainawo noshire.” Ikantanakera, kamanake. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ikanta reeware owayeri katziyawentakariri iñaakero okaatzi awisaintsiri, antawoite ithaamentawentanakari Pawa, ikantanake: “Imaperotyaama ikameethashiretzi jirika atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eejatzi ikaatzi ñaayetakerori awisaintsiri, okatsitzimoneentanakeri riyaayetai. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iriima ikaatzi ñaapiintakeriri, eejatzi tsinanepaini, tsipatakariri ipoñaantakari Galilea-ki, intaina ikatziyaiyakani raminakotakeri oita awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ikanta José poñaachari nampitsiki Arimatea saikatsiri Judea-ki, kameethashireri rinatzi jirika, iriitake itsipatapiintari rapatota reewarepaini Judá-ite, ");
INSERT INTO cpbNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","temaita inimoteri okaatzi ikantawaitaitakeriri Jesús, tema osheki royaakotziri irirori Pawa impinkathariwentantai. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Riyaatashitakeri Pilato, ikantapaakeri: “Pishinetenari Jesús, nonkitatairi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Irojatzi ikentakoryaakotantaariri, iponatantanaari manthakintsi, ikitatakeri ikiyaitzirowa shirantaamoo, kaari ikitatantaita kaminkari. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tema irootake kiteesheri raminantapiintaitari royaari inkaamani kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Okanta tsinanepaini tsipatakariri ipoñaantakari Jesús Galilea-ki, oyaatakowentanakeri, oñaakowentakeri tsika ikanta romaryagaitapaintziri ikitaitakerira. ");
INSERT INTO cpbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Okanta ipiyaiyapaakani iwetsikayetakeniri kasankaari. Imakoryagaiyakeni, tema iro kiteesheri Inintakaantaitziri rimakoryaantaityaawo. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Okanta okiteeshetamanai tominko, ananinkamanake tsinane iyaate shirantaamooki romonkyaakoitakerira Jesús, aanakero kasankaari iwetsikakeri ketziroini. Ari otsipatanaawo eejatzi otsipapaini tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Okanta aminawetapaaka, oñaatzi itainkanake mapi rashitantaweetakawori omoo. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kyaapaake inthomoiki, te oñaapairi tsika rowakoweetakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Osheki othaawanake. Oñaashitakari ikatziyimotapaakawo apite mainari, shipakiryaa okantaka iithaare. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tema othaawantanakityaari, otziwerowashitanakari. Ari ikantanakero: “¿Iitaka paminaminatantariri añagaatsiri jaka kaminkarimooki? ");
INSERT INTO cpbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Te risaiki, añagai. Pinkenkithashiretero okaatzi ikantakeri risaikantawetari Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ikantake ketziroini: ‘Irootaintsi raakaantaiteri Itomi Atziri, inkentakoteri kaariperoshireri atziri. Awisawetakya mawa kiteesheri, aritake rañagai eejatzi.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ari okenkithashiryaanakawo iroori okaatzi ikantakeri ketziroini Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ipiyapithatanakawo omoonaki, okamantapairi 11 riyotaanewo Jesús eejatzi itsipapaini. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jiroka okaatzi tsinane: María Magdala-sato, Juana, María inaanate Jacobo eejatzi otsipapaini tsinane, irootake kamantapaakeriri Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iro kantzimaitacha ikaatzi okamantawetapaakari, te ikemisantziro, roshiyakaaminthaitziro okantawaitashita jirokapaini tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ikanta Pedro, jatanake irirori omoonakiki, rishiyaarikoperotanakitya. Raminawetapaaka inthomoiki omoonaki, iñaapaatziiro omaryaaka manthakintsi iponatantaitakariri ketziroini. Iyokitziitapaake iñaapaakerowa, piyaawo pankotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tekera rimakoteeta, ranashitaiyani apite riyotaanewo Jesús riyaatero nampitsiki jitachari Emaús. Te osamaniperotzi isaikinta Jerusalén okaatzi 11 kilómetro. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iro ikenkithatakaawakaiyarini ranashitaga okaatzi awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ikenkithawaiminthaitzi ranashitaiyanira, ripokapaake Jesús itsipatapaakari ranashitaga. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iro kantzimaitacha jirika riyotaanewo, oshiyawaitakawo rotzimikaitatyeerime rokiki, eero riyotantawaari. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ikantapaakeri: “¿Oitaka pikenkithatakotziri panashitaiyanira? ¿Oitaka powashireneentantari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ari rakanake apaani iitaitziri Cleofas, ikantanake: “¿Eerokama yotapainchari te piyotakotziro okaatzi awisaintsiri Jerusalén-ki?” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ikantzi: “¿Oitaka awisaintsiri?” Ari ikantaiyini riyotaanewo: “Iriitake Jesús iitaitziri Nazaret-satzi, rotyaantakeri Pawa, Inkamantantanerite, iri riyotawake atziripaini. Tema okaatzi rantayetakeri, okaatzi ikantayetakeri eejatzi, ari roñaagantziro ishintsinka. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iro kantzimaitacha raakaantakeri reeware Imperatasorentsitaarewo itsipatakari pinkatharipaini, ritsitokaantakeri janta ikentakoitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tema noshiyakaaminthaitziro naakapaini iri jokaawiritaantairine maawoini asheninka. Irootake mawatatsiri iroñaaka kiteesheri rowamagaitantakariri. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eeniyetatsi tsinane nokaatapiintzira omapokashitakenari, ananinkamanake iyaatamanai omoonakiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te oñaapairi rowaweetakarira Jesús, ipiyaawo okamantantapai: ‘Noñaake maninkari, ikantakena: “Añagai Jesús.” ’ ");
INSERT INTO cpbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ari riyaatanake nokaataiyinira janta omoonakiki, iñaapaakero okaatzira okantaiyakerini tsinane, te iñiimaitapaari Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ari rakanakeri irirori, ikantanakeri: “¡Te piyotanetzi eerokapaini, osheki pithainkashiretakero okaatzi ikamantantayetakeri Kamantantaneriite! ");
INSERT INTO cpbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tema iro kowaperotacha awishimoteri Cristo jirokapaini, irojatzi risaikantaiya rowaneenkawoki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ari retanakawo rooñaawontziniri okaatzi osankenayetainchari tsika ikenkithatakoitziri Cristo. Retanakawo rosankenareki Moisés rithonkakeniri okaatzi rosankenayetakeri maawoini Kamantantaneriite. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Areetaiyakani nampitsiki tsika roshiretawo. Ari ikowi Jesús rawisanakeme irirori oshiyawaitakawo riyaatatyeeme intaina. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ikantaiyini jirika apite: “Eero pawishi, ari pimaanake. Tema tsireniityaake.” Irojatzi risaikantapaakari Jesús pankotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ari risaikaiyakeni rowaiyaani, raakero Jesús pan, riwetharyaawentakawo, itzipetowakero, ipayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aripaite riyotakaayeetanairi iriitakera Jesús. Iri kantzimaitacha Jesús ipeyashiwaitanaawo, te iñaawairi jimpe ikenanai. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ikantawakagaiyani: “¿Tema thaamentashire pikanta ikenkithawaitakaira ketziroini awotsiki, ikenkithatakotairo osankenarentsipaini?” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te rimaapaintzi, piyanaka Jerusalén-ki. Iñaapaatziiri 11 riyotaanewo rapatotaiyani, itsipayetakari ikaatapiintzira. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ikantaiyini: “Imaperotatya rañagai Awinkatharite. Tema roñaagaari Simón.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Irojatzi ithawetakotantapaawori okaatzi awishimotakeriri awotsiki, tsika okanta riyotantawaariri riwetharyaawentapaawowa pan. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ikenkithawaiminthaitzi riyotaanewo, osatekapaaka Jesús, riwethatapaakari ikantziri: “Pisaikai kameetha.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Antawoite ithaawaiyanakeni, roshiyakaaminthaitziri shiretsi ñaanatziriri. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Irojatzi ikantantanakariri eejatzi: “¿Iitaka pithaawantari? ¿Iitaka pikisoshirewentantanari? ");
INSERT INTO cpbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Paminero nako, eejatzi noitzi, naakatake. Piterotena, potzikanatena. Naakame shiretsi eero otzimime nowatha, eejatzi notonki. Irooma naaka tzimatsi.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ikantakerira, roñaaganakeri rako eejatzi iitzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Okantakaanakari ithaamentanaka te ikenkithashiretanaka iriira Jesús. Eekero rosampitanakitziiri, ikantziri: “¿Eenitatsima oyaari?” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ari ipaitakeri tzimagaantatsiri shima itsipatagaitakeniri iyaa pitsi. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Raawakeri Jesús, iñaakeri ikaatzira riyotaanewo rowakari. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ari ikantanake: “Iroowa nokantzitakemiri ketziroini eeniro notsipatzimi. Ontzimatye imonkaayetya rosankenatakoyetakenari Moisés-ni, Kamantantaneriite, eejatzi Salmo.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ikemathatakaanairi Jesús okaatzi osankenatakoyetainchari. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ikantziri: “Irootake rosankenayeetakeri. Ontzimatye inkemaatsitakagaityaari Cristo, iro awisawetakya mawa kiteesheri aritake rañagai. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ontzimatye rowaagakoitero nowairo maawoiniki kipatsi, retaitanakyaawo Jerusalén-ki. Iro ompoñaantyaari ripakaantaiyaawori kaariperori rantayeetziri, impeyakoyeetairi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eerokatake ñaayeterone jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ari piñaakeri notyaantemiri ikashaakaakemiri Ashitanari. Ari pisaikaiyawakeni jaka Jerusalén-ki, irojatzi ishintsitakaantanakemiri poñaachane inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ikanta Jesús raanakeri riyotaanepaini janta Betania-ki. Ari itzinaawakotanaka, ritasonkawentanairi. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ikanta ritasonkawentakeri, romapokashita reethonkitanai inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ikanta ipinkathataiyanakerini riyotaanewo. Piyaiyaani Jerusalén-ki, antawoite ikimoshiretaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ari ikantapiintanaatya ithamentawentanaari Pawa janta tasorentsipankoki. Ari onkantaitaatyeeyaani.");
INSERT INTO cpbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Owakera etantanakari riwetsikantaitzi pairani, ari itzimake iitaitziri “Ñaantsi”. Ari itsipatari Pawa. Tema Pawa rini irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iri itsipatakari pairani Pawa owakera etantanakari riwetsikantaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iri wetsikajaantakerori maawoini tzimayetatsiri. Tekaatsi apaani okaatzi tzimayetatsiri jaka kaari riwetsike irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Roshiyawaitakari kiteesheenkari ikiteenkaatakotairi atziripaini ompoñaantyaari inkañaaneyeetai. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Roshiyawaitakari kiteesheenkatakotantatsiri otsirenikitzira. Temaita roitsinampairi roitsiwakawakerira oshiyakotakawori tsirenikiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pairani rotyaantake Pawa apaani atziri, iita Juan. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iriitake kenkithatakotapaakeriri iitaitziri “Kiteesheenkari”, ompoñaantyaari inkemisantaitero maawoini riyotaanteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jirika Juan kaari iitaitziri “Kiteesheenkari.” Iriira pokaintsiri inkenkithatakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tema pokake jaka kipatsiki maperotzirori roshiyakotari kiteesheenkari, iri kiteesheenkatakotairiri atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Risaikapaintzi jaka isaawiki. Tema iri wetsikakeriri isaawikisatzipaini. Iro kantzimaitacha te riyotawakeri isaawikisatziite. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Risaikimowetapaintari isheninkapaini. Temaita raakameethatawakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iriima ikaatzi aakameethatawakeriri, aakotaapiintanairiri iwairo ikemisantairi, iriira itomintaari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Itomi rowayetairi Pawa. Temaita oshiyawo itomintantapiinta atziripaini, iñaamankakiini ikowi rowaiyantawaite. Iriima Pawa apaniroini ikowake intomitantya tekaatsi otsiwakakaiyaarine. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jirika iitaitziri “Ñaantsi”, atziritake, risaikimotapaintai. Neshironkakitantaneri rini. Irooperori okanta riñaaneyetari. (Naakapaini ñaakerori itasorenka rapintzite itomi, ari oshiyakawo itasorenka Ipaapate.) ");
INSERT INTO cpbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iriitake richeraawentapaake pairani Juan, ikantapaake: “Jirika nokenkithatakotakeri pairani, nokantake: ‘Awotsikitake poyaatenane, ranaana naaka, tema iri etakawo pairani itzimi.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tema iriiperowaitake irirori, iro añaantaawori maawoini ineshironkatapiintai. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pairani, iri Moisés-ni rosankenatakaitakeri Inintakaantaitanewo. Iriima Jesucristo iri neshironkayetairi, irijatzi kenkithatapaintzirori Irooperori. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tekaatsi materone iñeeri Pawa. Iriima rapintzite itomi Ashitairi, saikimotziriri, iriitake kamantairi aakapaini ayotantaari tsika ikanta irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ikanta Judá-ite nampitawori Jerusalén-ki, rotyaantake Imperatasorentsitaarewo itsipataakeri Leví-ite, riyaate rosampiteri Juan, inkanteri: “¿Piitaka eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Te rimanakota Juan, ikamantakeri, ikantziri: “Te naaka Cristo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Irojatzi rapiitantaitakariri rosampiitziri: “¿Tsikama piitatyaaka? ¿Eerokama Elías-ni” Ikantzi Juan: “Te naaka.” Eekero ishintsitaitatzi rosampiitziri: “¿Eerokama Kamantantaneri noyaakoneentziri?” Ikantzi: “Te.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ari ikantaitziri: “¿Piitaka eeroka? Pinkamantena, onkene nonkamantapairi otyaantanari. Pinthawetakotya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Rapiitanakero Juan, ikantzi: “Naakatake cheraacheraatapaintsine ochempiki, nonkantante: ‘Powameethatainiri Awinkatharite tsika inkenapaake, poshiyakayero rotampatzikaitziro awotsi.’ Irootajaantake ikenkithatakotakeri pairani Kamantantaneri Isaías-ni.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ikanta rotyaantane Fariseo-paini, ");
INSERT INTO cpbNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","eekero rosampitanakitziiri, ikantziri: “Tera eeroka Cristo pine, te eeroka Elías, te eeroka Kamantantaneri eejatzi. ¿Oitaka pomitsitsiyaatantantari?” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ari ikantzi Juan: “Apatziro nomitsitsiyaatantashimatsitawo naaka ñaa. Iro kantzimaitacha eenitatsi apaani jaka pitsipatakari, kaari piyotaiyeni, ");
INSERT INTO cpbNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iriitake poyaatapaakenane. Te onkantaatsikaitya naaka roshiyakaina rimperatanewo ompoñaantyaari no-zapato-ryaayitziteri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Maawoini jiroka, iro awisaintsiri pairani janta iitaitziri Betábara, intatsikero ñaa Jordán tsika romitsitsiyaatantzi pairani Juan. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Okanta okiteeshetamanai iñaawairi Juan ikenapai Jesús, ikantzi: “Jirika rowejate Pawa, iriira peyakotairine iyaariperonka atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iri nokenkithatakotzitakari nokantake: ‘Awotsikitake atziri poyaatenane, ranaana naaka, tema iri etakawo pairani tekera notzimiita naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te niyowetari naaka. Iro nipokantakari nomitsitsiyaatante, ompoñaantyaari riyote Israel-iite.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jiroka ikantanake eejatzi Juan: “Noñaakeri Tasorenkantsi ikenapaake jenoki roshiyapaakari shiro. Rookantapaakari. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Te niyowetari naaka. Iri kantacha jirika otyaantakenari nomitsitsiyaatante, ikantakena: ‘Arika piñaake rishaawiinkashiteri Tasorenkantsi rookantapaakyaari iitoki, iriitake oshiyakaanterone romitsitsiyaatantatyeerime Tasorenkantsi.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naakatake ñaakeriri, iro nokenkithatakotantariri tema Itomi Pawa rini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Okanta okiteeshetamanai ari risaiki Juan itsipatakari apite riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ikanta iñaawairi Jesús ikenapai, ikantanake Juan: “Jirinta rowejate Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ikemawake apite riyotaanewo Juan, royaatanakeri Jesús iñeeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ripithokanaka Jesús, iñaatziiri royaatakeri, ari rosampitziri: “¿Tsika piyaateka?” Ikantaiyini irirori: “Rabí (Iro ikantaitziri ‘Yotaantanerí’), ¿tsika pinampitawoka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ikantzi Jesús: “Pipoke piñeero.” Ikanta royaatanakeri, iñaakero tsika inampitawo. Ari rimayimotapaintziri, tema tsireniityaake. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jirika kemakeriri Juan, oyaatanakeriri Jesús, iriitake Andrés irirentzi Simón Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ikanta Andrés, apatziro riyaatashitanakeri irirentzi, jirika Simón, ikantapaakeri: “Noñaakeri Mesías (iri ikantaitziri eejatzi, ‘Cristo.’)” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ikanta Andrés raanakeri Simón risaikira Jesús. Ikanta Jesús iñaawakeri irirentzi Andrés, ikantawakeri: “Eeroka Simón, itomi Jonás. Iroñaaka piitaiya ‘Cefas.’ (Iri ikantaitziri eejatzi, Pedro.) ");
INSERT INTO cpbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Okanta okiteeshetamanai, jatake Jesús Galilea-ki. Ari iñaakeri Felipe, ikantapaakeri: “Poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jirika Felipe, Betsaida-satzi rini, irojatzi inampi Andrés eejatzi Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ikanta Felipe, riyaatashitakeri Natanael, ikantapaakeri: “Noñaakeri rosankenatakotakeri Moisés-ni janta Inintakaantaitaneki, rosankenatakotakeri eejatzi Kamantantaneriite. Iriitake itomi José, Nazaret-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ikantzi Natanael: “¿Eenitatsima kameethashireri poñaachari Nazaret-ki?” Ikantzi Felipe: “Pipoke, piñeeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ikanta Jesús iñaawakeri ripokake Natanael, ikantanake: “Kaakitake iriiperori isheninka Israel-ni, te ithaiyaneta.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rakanake Natanael ikantzi: “¿Tsikama piñaanaka piyotantanari?” Rakanake Jesús: “Noñaakemi tekera ikaimimiita Felipe pisaiki pankirentsitapishiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ikantanake Natanael: “Rabí, ¡Eerokatake Itomi Pawa, eeroka Iwinkatharite Israel-iite!” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ikantzi Jesús: “Iroowa pikemisantantamatsitanakari nokantakemiro ‘noñaakemi pisaiki pankirentsitapishiki.’ Iro kantacha, ari piñaakero otsipa anayerone jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eekero ikantanakitzi Jesús: “Ari piñaakero ashitaryagaiya inkite. Ari ripiyapiyataiyeni maninkariite rayiitashiteri Itomi Atziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Okanta mawatapaintsiri kiteesheri ari raawakaitakari nampitsiki jitachari Caná, saikatsiri Galilea-ki. Ari isaikakeri eejatzi inaanate Jesús janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ari ikaimakaantaitakeri eejatzi Jesús itsipatanakari riyotaanewopaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ikanta roimoshirenkaiyani, thaatapaaka riraiyirini. Okanta inaanate Jesús, okantakeri: “Thaatapaakaga riraitziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ikantzi irirori: “Tsinané, ¿Oitaka pikantantanari naaka? Tekera imonkaapaitetaata noñaagantya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Okantanakeri iroori kitantatsiri: “Pantero onkaate inkantemiri notomi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ari otaamaaka 6 chomo mapinatatsiri, iro rowantapiintari Judá-ite ñaa ikiwantari inkitewathatantyaari. Jiroka chomo, tzimatsi okaatzi yeekitatsiri 50 litro ñaa, otsipa 60 litro. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ikantanakeri Jesús ikaatzi kitantatsiri: “Piyeekite ñaa maawoini chomoki.” Riyeekiperotakero chomoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ikantzi Jesús: “Pinkitanake eepichokiini, paakotanakeniri aminakaantzirori oimoshirenkaantsi.” Ari ikantaiyakeroni. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ikanta jirika aminakaantzirori oimoshirenkaantsi ikemaantawakero eepichokiini riraitziri ñaawetachari naaweta, te riyotzi tsika okenakotapaake irooperori riraitziri. Apatziro riyotaiyini kitantatsiri, tema iri yeekitakerori ñaa. Ikanta jirika aminakaantzirori oimoshirenkaantsi, ikaimakeri aawakaachari, ");
INSERT INTO cpbNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ikantziri: “Iro rametari atziripaini retapiintawo ikitakaantziro irooperori riraitziri, arika inkemakitaiyakyaani oimoshirenkachari, ari roitaatantaitero saakyaari. Irooma eeroka powapithatantakero irooperori riraitziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iro rantakeri Jesús nampitsiki Caná saikatsiri Galilea-ki, ari retanakawo ritasonkawentantzi roñaagantziro ishintsinka. Ari ikemisantaperotanake riyotaanepaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Okanta okaatapaake roimoshirenkaiyani, jatanake Capernaum-ki itsipatanakawo inaanate, irirentzipaini, eejatzi riyotaanewopaini. Te osamani risaikapainte janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Okaakitzimatai roimoshirenkapiintantawori Judá-ite Anonkoryagaantsi. Jatake Jesús Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iñaapaakeri tasorentsipankoki pimantayetziriri ipira eejatzi ishironepaini. Ari risaikakeri eejatzi amanantziriri koriki. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ikanta iñaapaakeri, raminthatake Jesús ripasamento, rookapaakeri maawoini yompariwaitachari tasorentsipankoki, ari itsipataakeri ipirapaini. Rosokitakeri iyorikite ikaatzi amanantziriri koriki, rotatsinkitakeri risaikamentopaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ikantakeri Jesús yomparitariri ishirone: “¡Paanairi pipira! ¡Te okameethatzi poshiyakairo ipanko Ashitanari yomparimentotsipanko!” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ari ikenkithashiretanakero riyotaanewo okaatzi rosankenaitakeri, kantatsiri: Antawoite nonkisakotyaawo pipanko. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ikanta Judá-ite ikantanakeri Jesús: “Janjaatya pitasonkawentante noñaantemiri eenitatsirika pishintsinka pantantakaworitya jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ikantanake Jesús: “Pintzimpookero jiroka tasorentsipanko, awisawetakya mawa kiteesheri, ari nontzinagairo eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ikantaiyini Judá-ite: “Okaatzi 46 osarentsi riwetsikantaitakawori jiroka tasorentsipanko, ¿arima pintzinagairo eeroka onkaate mawa kiteesheri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jiroka “tasorentsipanko” ikenkithatakotakeri Jesús, iro ikantakotzi iwatha irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ikanta itzinagaa pairani Jesús, ikenkithashiretanairo riyotaane okaatzi ikenkithatakotzitakari. Iro ikemisantaperotantanakawori Osankenarentsipero, eejatzi okaatzi ikantayetakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Eeniro risaiki Jesús Jerusalén-ki roimoshirenkaitziro Anonkoryagaantsi, osheki kemisantanakeriri iñagaitakerira ritasonkawentantake. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iri kantacha Jesús, te rawentaashiretari jirikapaini, tema riyoshiretziri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Te okowajaanta Jesús inkamantaiteri tsika ikantashiretzi atziripaini riyoshireyetziri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Eenitatsi apaani Fariseo jitachari Nicodemo, iriiperori Judá-ite rini. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ikanta jirika jatake tsireniriki iñeeri Jesús. Ikantapaakeri: “Rabí, niyotaiyini iriitake Pawa otyaantakemiri piyotaayetena, tekaatsi kanterone rantero okaatzi poñaagantakeri eeroka, eerorika itsipashiretari Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ari rakanakeri Jesús, ikantziri: “Kaari apiitairone intzimai, eero iñagairo ipinkathariwentantaira Pawa. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ikantzi Nicodemo: “¿Kantachama rapiitairo intzimai apaani atziri antarikitaintsiri? ¿Arima onkantakya inkyagai omotziki inaanate, onkene rapiitairo intzimai?” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ari rakanake Jesús, ikantziri: “Kaari tzimantaiyaawone ñaa, kaari itzimashiretakai Tasorenkantsi, eero iñagairo tsika ipinkathariwentantai Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ikaatzi rowaiyantziri atziripaini, atziri rini. Iriima ikaatzi tzimantaariri Tasorenkantsi, tasorentsishireri ikantanaa. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eero ikompitzimotzimi nokantakemiri: ‘Papiitairo pintzimayetai.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Okanta tampyainka itasonkantapiintzi tsika okowakaawo. Pikemawetawo oyameninka, temaita piyote tsika okenapaake, tsikarika iyaatziro. Ari ikantari eejatzi ikaatzi itzimashiretakaayetairi Tasorenkantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Rapiitanakero Nicodemo rosampitziri: “¿Tsikama okantakotaka jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ikantzi Jesús: “¿Eeroka, yotaapiintziriri Israel-iite, tema piyote tsika okantakota jiroka? ");
INSERT INTO cpbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nokenkithatakotaiyimironi okaatzi niyotakotziri. Nokenkithatakotaiyimironi okaatzi nokitari. Iro kantzimaitacha te pikemisantziro eerokapaini nokantayetzimiri. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Te pikemisantana nokenkithatakotzimiro isaawikisato, iro owatsipero eero pikemisantana arika nonkenkithatakotemiro inkitesato. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tekaatsi apaani jatatsine inkiteki, apatziro apaani poñainchari inkiteki. Iriira akenkithatakotzi, Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tema pairani Moisés-ni rowatzikakotake maanke ochempiki, ari inkantaiteri eejatzi Itomi Atziri, ontzimatye rowatzikakoiteri irirori, ");
INSERT INTO cpbNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ompoñaantyaari inkañaaneyetai inkaate kemisantairine.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tema retakokiperotari Pawa isaawikisatzi, rishinetakeri rapintzite Itomi inkamawenteri, eero ikaamanetantaa inkaate kemisantanairine, tema ontzimatye inkañaaneyetai. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tema Pawa te iro rotyaantantyaariri Itomi kipatsiki riyakowentairi isaawikisatzi, rotyaantakeri rowawisaakoshiretairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ikaatzi kemisantairine Itomi Pawa, eero riyakowentaitziri. Iriima kaari kemisantaatsine, riyakowentaiteri, okantakaantziro te ikemisantairi rapintzite Itomi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maawoini kaari kemisantatsine, aritake riyakowentaitakeri, tema rantapiintatziiro kaariperori. Tema ripokawetapainta pairani kipatsiki iitaitziri ‘Kiteesheenkari’, iro ikowaperotake tsirenikiri, imanintawakeri ‘Kiteesheenkari.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maawoini antayetzirori kaariperori ikisaneentatziiri iitaitziri ‘Kiteesheenkari.’ Ramawenawaita eero riyotantaitari rantayetziro kaariperori. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iriima antanairori irooperori, rawentaanaari ‘Kiteesheenkari’, iroowa iñagaitantyaariri rantawaitainirira Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Okanta okaatapaake jiroka, jatanai Jesús Judea-ki itsipatanaari riyotaanewo, ari itsipatakari romitsitsiyaatantzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Romitsitsiyaatzitanta irirori Juan janta Enón-ki, okaakitapai Salim, ari otzimaperotziri ñaa janta. Ikaatzi jatashitziriri janta, romitsitsiyaayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tekera raakaantaiteriita Juan romonkyagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ikanta riyotaanewo Juan riñaanaminthatake apaani Judá-ite tsika onkantya inkitewathatantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Irojatzi riyaatantanakari risaikira Juan, ikantapaakeri: “Rabí, jirintaganki tsipatakemiri intatsikero ñaa Jordán, pikenkithatakotakenari, romitsitsiyaatantzi irirori, osheki atziripaini pokashitziriri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ari rakanake Juan, ikantzi: “Tsika ikanta piñaakeri jirika, iriira Pawa iriiperotakaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Eeroka kemajaantakena nokantake pairani: ‘Te naaka Cristo apatziro rotyaantaitakena neewatapaakeri irirori nonkenkithatakoteri.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Thame noshiyakaawentemiro: apaani aawakagaantsi, iriitake iimentaitari iriiperori, aapiintzirori tsinane. Iriima itsipaminthare, eero iñaaperowaita irirori, apatziro inkimoshiretanake inkemakeririka inkenkithawaitanake jimetsi. Ari nokantakari naaka, te niriiperowaite, iro kantzimaitacha, antawo nokimoshiretake. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eekero riyaatatye ririiperote jirika, irooma naaka ari nompairaniityaakotai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tema poñagainchari jenoki ranairi maawoini. Iriima nampitawori kipatsiki, isaawikisatzi rinatzi, ikenkithatakotashitapiintawo isaawikisato. Iriima poñagainchari inkiteki ranairi maawoini, ");
INSERT INTO cpbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ikenkithatakotziro okaatzi iñiiri, okaatzi ikemiri. Iro kantzimaitacha eero ikemisantaitziro okaatzi ikenkithatakotziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iri kantacha inkaate kemisantanairine, ari inkantanakya irirori ikenkithatakotanakeri Pawa iriiperori rinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Itzimi rotyaantakeri Pawa, riñaane Pawa ikenkithatakotzi. Tema rithotyiiro Pawa inampishiretakaantawo Itasorenka. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jirika Ashitairi retakotari Itomi, ipinkathariwentakaakeri maawoini tzimayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ikaatzi kemisantanairine Itomi, ari inkañaanetai. Iriima kaari kemisantairine Itomi, eero iñagairo inkañaanetai irirori, apatziro ratsipetaiyaawo rowasanketairi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ikanta Fariseo-paini ikemaiyakeni, ikantaitzi: “Tzimake osheki riyotaanewo Jesús, romitsitsiyaatake osheki atziripaini, ranaanakeri Juan.” Riyotake irirori Jesús okaatzi ikemaiyakerini Fariseo. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kaarira Jesús omitsitsiyaatantatsine, tema riyotaanewopaini omitsitsiyaatantatsiri.) ");
INSERT INTO cpbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iro rishitowantanakari Jesús Judea-ki, ripiyaawo Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ari eekaatziri inkenanairo iipatsiteki Samaria-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Irojatzi rareetantakari nampitsiki saikatsiri Samaria-ki oita Sicar, iro tsipanampitawori iipatsite pairani Jacob-ni ipanairiri itomi, José. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ari isaikiri ñaa iiyane Jacob-ni. Tema makokitake Jesús ranashitaga, risaikashitapaakero ñaa, riweyaaka ooryaa tampatzika. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ari ipokake apaani Samaria-sato onkaye ñaa. Ikantawakero Jesús: “Pimpena ñaa nirawakeeta.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tema riyaataiyatziini riyotaanewo nampitsiki ramanante owanawontsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Maawoini Judá-paini te raapatziyari kameethaini Samaria-satzipaini. Ari akanakeri tsinane okantanakeri: “¿Tsika pikenakairoka eeroka Judá-ite pini, pikowakotana naaka Samaria-sato nompemi ñaa?” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ari rakanakero Jesús, ikantziro: “Arime piyote oita ipantziri Pawa, ari piyoterime kowakotakemiri ñaa, eeroka kowakotenaneme naaka. Aritake nompakemiro ñaa añaakaantatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Okantanake tsinane: “Pinkatharí, tekaatsi pinkitaagantyaari ñaa, inthomoi okantaka omoo, ¿tsika payeroka pimpenari ñaa añaakaantatsiri? ");
INSERT INTO cpbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iri acharineete Jacob-ni panairori pairani jiroka ñaa, iro rirakeri irirori, irojatzi rirakeri itomipaini, rirakero eejatzi ipirapaini. ¿Panairima eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Rakanakero Jesús, ikantanakero: “Maawoini irayetzirori jiroka ñaa, eero opeyawo imeretzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Inkaate irakerone ñaa nomperiri naaka, eero imerenetai. Tema ñaatatsiri nopantziri naaka ari ishitowashiretantaiyaari oshiyawaityaawo ishitowantatyeeyaarime ñaa añaakaantatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okantanake tsinane: “Pinkatharí, pimpenawo naaka jiroka ñaatatsiri, eero napiitantaawo nomeretai, eero nipiyapiyawaitanta jaka nonkaye ñaa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ikantanakero Jesús: “Piyaate, pinkaimeri piime, eejatzi pipiyapai jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Okantanake tsinane: “Tekaatsi noime.” Ikantziro Jesús: “Kyaaryoopero pikantake, tekaatsi piime, ");
INSERT INTO cpbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tema tzimawetaka pairani ikaatzi 5 piime. Iriima pitsipatari iroñaaka, kaari piime. Imaperotatya okaatzi pikantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Okemakerira ikantakero, okantanake tsinane: “Pinkatharí, niyotanakemi naaka Kamantantaneri pini. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pairani nosariite Samaria-satzi ipinkathatapiintakeri Pawa jaka ochempiki. Iro kantzimaitacha eerokapaini Judá-peroriite, pikantaiyini apinkathatapiintairi Pawa janta Jerusalén-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ikantanakero Jesús: “Pinkemisantawake tsinane, irootaintsi piñeero, eero okowajaanta piyaate janta ochempiki pimpinkathayetairi Ashitairi, eero okowajaanta piyaate eejatzi Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imaperowetatya, te piyotaiyirini eerokapaini iita pipinkathatapiintziri. Irooma naakapaini niyotziri itzimi nopinkathatziri. Tema jirika owawisaakotantatsine, Judá-ite rine. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iro kantacha, irootzimataintsi piñeero. Ikaatzi maperotachari ipinkathatairi Ashitairi, iriitakera ikaatzi pinkathatairiri ishireki. Tema iriiyetake raminaminatairi Ashitairi impinkathatakaantaiyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pawa irijatzi Tasorenkantsi, kaari koñaatatsine. Inkaate pinkathayetairine, ontzimatye impinkathashiretairi, te okowajaanta rantayetairo koñaayetatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Akanake tsinane okantzi: “Niyotzi naaka, arika ripokake Mesías, iitaitziri Cristo, arika rareetakya irirori, ari inkamantapaakairo maawoini tsika okantakota.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ikantanake Jesús: “Naakatake, ñaanatakemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ari rareetaiyapaani riyotaanewo, iñaapaakitziiri itsipatawo tsinane ikenkithawaitakairo, riyokitziiwentapaakeri. Iro kantzimaitacha tekaatsi osampitapaakerine oita okowiri tsinane, tsikarika oita ikenkithawaitakairori. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ookanakero tsinane ochomone, jatake nampitsiki, okantapaakeri atziripaini: ");
INSERT INTO cpbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pipokaiyeni pamineri apaani atziri yotakotakenawori maawoini nantayetakeri pairani. ¿Kaaririka Cristo?” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ikanta ripokaiyanakeni atziripaini ipoñaakawo nampitsiki, areetaiyakani risaikapaakera Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ari ipankenataiyarini riyotaanewo, ikantziri: “¡Rabí, poya!” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rakanakeri Jesús, ikantzi: “Tzimatsi oita nowari naaka, te piñagaiyironi eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ari rosampitawakaiyanakani riyotaanewo: “¿Eenitatsima amakeniriri rowanawo?” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ikantanake Jesús: “Iro noshiyakairi nowanawo nantero okaatzi ikowiri otyaantakenari, ontzimatye nithonkero eejatzi antawairentsi ipakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jiroka pikantapiintaiyini eeroka: ‘Yotapaaka 4 kashiri isampatantyaari pankirentsi.’ Nonkantemi naaka: paminero pankirentsimashi, sampainkatake, ontzimatye owiitya. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Inkaate antawaitatsine rowiitero pankirentsi ari ripinaitairi. Okaatzi pankirentsi rowiiyeetairi iriitake oshiyakaawentacha inkaate kañaanetatsine. Iro inkimoshiretantaiyaari pankitakerori intsipataiyaari owiitairori. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Imaperotatya jiroka roshiyakaawentaitakeri, ikantaitzi: ‘Eenitatsi pankitakerori, tzimatsi itsipa owiitairone.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Notyaantakemi piyaate eerokapaini powiitairo kaari pipomeentsiwenta pantawaiwentero. Tema tzimayetatsi itsipa pomeentsiwentakawori rantawaiwentakero. Eerokatake nintagaawori rantawaiwentanewo jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tema osheki Samaria-satzi saikatsiri nampitsiki kemisantawakeriri Jesús okantakaantziro tsinane okamantantapaakera: “Riyotakotakenawo maawoini nantayetakeri pairani.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ikanta rareetaiyapaakani Samaria-satzipaini, ishintsineentapaakeri Jesús risaikimotanakeri inampiki. Rimatakero Jesús, apite kiteesheri risaikanake, ");
INSERT INTO cpbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","osheki itsipa kemisantanaintsiri ikemaiyakenira iriroripaini okaatzi ikantayetziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ikantaitanakero tsinane: “Kemisantayetaana naaka iroñaaka, te iro nonkemisantantaiyaari pikamantapaakenaga, tema naaka kemawakeri okaatzi ikantayetakeri. Niyotaiyaini eejatzi iriitake owawisaakoshiretantaatsine jaka kipatsiki, iriitake Cristo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Okanta imonkaatakaga apite kiteesheri risaikapaake Jesús Samaria-ki, awisanake riyaatairo Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tema iri Jesús kantaintsi: “Apaani Kamantantaneri te ipinkathaitziri inampiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ikanta rareetaawo Galilea-ki, osheki raakameethaitawairi janta, tema ari ikaatake riyaataiyakeni Jerusalén-ki roimoshirenkawo Anonkoryagaantsi, iñaakero maawoini rantayetakeri Jesús janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ari rareetaawo Jesús janta Caná-ki saikatsiri Galilea-ki, tsika ipeyakero ñaa oshiyawaitanakawo riraitziri. Tzimatsi janta Capernaum-ki iriiperori jewari, mantsiyataintsiri itomi. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ikanta jirika jewari ikemakotakeri Jesús areetaawo Galilea-ki ipoñagaawo Judea-ki, riyaatashitanakeri iñeeri. Ikowakowatapaakeri, riyaatakairi ipankoki, retsiyatakotakagainiri itomi, irootaintsi inkame. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ikantanake Jesús: “¿Iitaka kaari pikemisantantana? Pikowaperotake noñaayemiro kaari piñaapiintzi pairani, pikowaperotzi nitasonkawentante.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ikantanake jewari: “Pinkatharí, jameeta iroñaaka, tekera ikamanakeeta notomi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ikantanake Jesús: “Pipiye pipankoki. Etsiyatakotai pitomi.” Ikemisantanake atziri okaatzi ikantakeriri Jesús, piyanaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ripiyaminthaitanaka ipankoki, ritonkyotakari inoshikane, ikantawakeri: “¡Etsiyatakotai pitomi!” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rosampitanakeri irirori tsika ikaatake ooryaa retsinaryaakotanai itomi, ikantaiyanakeni rinoshikanewo: “Chapinki, ritainkanakera ooryaa, ari awisanakeri isaawakitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ari ikenkithashiretanaawo ashitariri ari riweyaaka ooryaa chapinki ikantakeri Jesús: “Etsiyatakotai pitomi.” Iroowa ikemisantantaari irirori, ari ikantakari eejatzi maawoini isheninkapaini irirori ikemisantanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iro apitetaintsiri roñaagantziro Jesús ritasonkawentantzi rareetaawo Galilea-ki ipoñagaawo Judea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Okanta okaatapaake roimoshirenkaiyaani Judá-ite Jerusalén-ki, ari riyaatzitaka eejatzi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Janta Jerusalén-ki, ari isaiki rowaankanaitziro ñaa iitaitziro riñaaneki Heber-thato “Betesda.” Tzimatsi okaatzi 5 opankoshetaaniki. Ari otsipakerotawo ashitakowontsi iitaitziri “Oweja.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ari ipiyotakari osheki mantsiyari, kaari kowichaatatsi, kisopookiri, ethoriwaitatsiri romaryaayeta kipatsiki royaawentziro ishewaata ñaa. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tema ikantaitzi: Rinatzi ripokapiintzi maninkari rishewaatakairo ñaa, itzimirika etanakyaawone ripiinkaatantyaawo ñaa ishewaatakaga, aritake retsiyatakotai imantsiyawaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eenitatsi janta mantsiyarimashiki apaani tzimakotaintsiri 38 osarentsi imantsiyawaitake. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ikanta Jesús iñaapaakeri romaryaaka, riyotapaake osamani okantaka imantsiyawaitake jirika, rosampitapaakeri, ikantziri: “¿Pikowi petsiyatakotai?” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rakanake mantsiyari: “Pinkatharí, tekaatsi iita owiinkenane arika ishewapaitetanaiya ñaa. Tema nokowawetapiintaka nipiinkaateme naaka, ranaakotakena itsipa ripiinkaatake irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ikantanakeri Jesús: “Pimpiriinte, paanairo pomaryaamento, piyaatai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Apathakerotanaka retsiyatakotanai jirika, raanairo romaryaamento, anashitanaa. Iro kantacha kiteesherira rimakoryaantaitari ini, ");
INSERT INTO cpbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ikantakeri Judá-ite jirika atziri etsiyatakotaatsiri: “Kiteesheri rimakoryaantaitari ini iroñaaka, te ishinetaantsite paanairo pomaryaamento.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rakanake jirika atziri, ikantzi: “Jirinta etsiyatakotakagaanari, ikantakena: ‘Paanairo pomaryaamento, piyaatai.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ikantaiyanakeni Judá-ite: “¿Iitaka kantakemiri: ‘Paanairo pomaryaamento, piyaatai?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iri kantacha jirika atziri te riyotziri iitaka etsiyatakotakagairiri, tema te iñaawairi Jesús tsika ikenanake, ipiyotaiyakanira atziripaini janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ikanta Jesús iñagairi atziri janta tasorentsipankoki, ikantziri: “Pinkeme, etsiyatakotaimi iroñaaka, eerowa papiitairo pantairo kaariperori, eero awishimotantaimi koweenkaperotatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ikanta jirika atziri jatanake, ikamantakeri Judá-ite iri Jesús etsiyatakotakagairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iro opoñaantari ikowi Judá-ite rowamairi Jesús, tema retsiyatakotakaantake kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iro kantzimaitacha, ikantanake Jesús: “Ashi rowatziiro rantawaitzi Ashitanari, ari nokantzitari eejatzi naaka nantawaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Irootake, ikowaperotantanakari Judá-ite rowamairi Jesús, te apatziro rantawaitantakawo kiteesheri rimakoryaantaitari, tema roshiyakotakari Pawa, ikantake Jesús iriitake Pawa ipaapatetari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ikanta Jesús rakanake, ikantzi: “Jirika Itomi Pawa tekaatsi rantashiwaitya irirori ikowakaanekiini. Apatziro rantziro okaatzi iñaakotziriri Ashitariri. Maawoini okaatzi rantziri Ashitariri, irojatzi rantziri Itomi. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tema retakotari Ashitariri jirika Itomi, roñaayiri maawoini rantayetziri irirori. Eekero roñaagatyeeri oitarika antawoitetatsiri, iroowa piyokitziiwentantyaariri eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tema ikantaga Ashitariri rowañaayetziri kaminkari, ikañaanetakairi, ari inkantyaari eejatzi Itomi, rañaakaayetairi ikowiri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te iri yakowentantatsine Ashitariri, Itomira rishinetake riyakowentantai, ");
INSERT INTO cpbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ompoñaantyaari maawoini impinkathatairi Itomi roshiyakagaitairi Ashitariri. Kaari pinkathatairine Itomi, te ipinkathatziri Ashitariri otyaantakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Inkaate owayempitataiyaawone nokantayetziri, inkemisantanairi otyaantakenari, ari inkañaaneshireyetai. Eero rowasankewaitaitziri, tema kaatapaake ikaamanewaitzi, kañaane ikantayetaa. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Irootzimataintsi imonkaatya, inkemayetairo kamayetatsiri riñaane Itomi Pawa. Inkaate kemairone, ari rañaashireyetai. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tema ikantaga Ashitariri rañaakaantzi, ikashaakaakeri eejatzi Itomi rañaakaante irirori, ");
INSERT INTO cpbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ikashaakaakeri eejatzi riyakowentantai, tema Itomi Atziri rini. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eero piyokitziiwentashitawo jiroka. Tema irootzimataintsi imonkaatya inkemantaiyaawori kaminkariite riñaane, ");
INSERT INTO cpbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","impiriintayetanake tsika ikitayetaka. Ikaatzi antayetakerori kameethari, ari inkañaaneyetai. Iriima ikaatzi antapiintakerori kaariperori, rañaayewetaiya rowasankeyeetairi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Te nantashiwaitawo nokowashitari naaka, Ashitanari nintatakaanawori niyakowentemi. Okaatzi nokantakowentantziri tampatzika okanta, tema te nantashiwaitawo nokowiri naaka, iro ikowiri Ashitanari otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naakame kenkithatakowaitashitachane apaniroini, tera opantawo nokenkithatakowaiwetaga. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iro kantzimaitacha eenitatsi itsipa kenkithatakotanari, niyotzi iro kyaaryooperotatsiri okaatzi ikenkithatakotakenari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Imaperowetatya ikenkithatakotakenari Juan potyaantantakariri pairani rosampiteri. Tema okaatzi ikenkithatakotakenari imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iro kantacha te iro nonkenkithatakote okaatzi ikenkithatakotanari apaani atziri oshiyakariri Juan. Iroowa nokenkithatakotzi matairone owawisaakoshiretaimi. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tema roshiyawetakari Juan apaani ootamentotsi kiteesheenkatapaintsiri. Iro pikowapaintziri eerokapaini pinintaawakyaawo roshiyapaintari kiteesheenkari. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Iro kantacha eenitatsi kenkithatakotanari naaka anairiri Juan. Okaatzi nantziri naaka, iro ikantanari Ashitanari nanteri, iroowa riyotantaitari naaka rotyaantane Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ari ikantakari Ashitanari otyaantakenari, ikenkithatakotakena irirori, temaita pikemisantziro riñaane. Te piñaawooteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Te okyaantzimi riñaane, tema te pikemisantziri rotyaantanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Amatsinka pikantaweta piñaanatziro Osankenarentsipero, ari poyaakoneentaawo pinkañaanetai. Naakawetakaga okenkithatakotzi Osankenarentsipero, ");
INSERT INTO cpbNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","temaita pikowaiyini eerokapaini pawentaayetaina ompoñaantyaari pinkañaaneyetai. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Te nokowi naaka inthaamentawentena atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Niyotzimi ketziroini tsika pikantaiyani eeroka, niyotzimi eejatzi te pinintziri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naakatake rowake Ashitanari nipoke naakotairi iwairo. Temaita paakameethatawakena eerokapaini. Arika ripoke itsipa aakowaitashitapaakyaawone iwairo irirori, iri paakameethaiyawakerini. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Tsika pinkene pinkemisantaiyeni? Apaniroini pithaamentashiwaitawakaa, te paminaminatairo iri Pawaperori thaamentaimine. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eero pikenkithashirewaita naaka yakowentemine Ashitanariki. Iri Moisés-ni yakowentaimine, pawentaawetakarira eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arime pinkemisantakerime Moisés-ni, aritakeme pinkemisantawakename naaka, tema naakatake rosankenatakotake Moisés-ni. ");
INSERT INTO cpbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tera pikemisantziro okaatzi rosankenawetakari Moisés-ni, ¿tsika pinkene pinkemisantero onkaate nonkantemiri naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Okanta okaatapaake jiroka, montyaanaka Jesús intatsikero inkaare saikatsiri Galilea-ki, irojatzi iitaitziri Tiberias. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Osheki atziri oyaatakeriri, tema iñaakerira ritasonkawentantake retsiyatakotakaayetairi mantsiyaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Irojatzi ritonkaantanakari Jesús otzishiki, ari risaikapaake itsipayetakari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iro areetzimataiya kiteesheri Anonkoryagaantsi, ari roimoshirenkapiintari Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ikanta raminapaake Jesús, iñaatzi osheki atziri oyaatakeriri, ikantakeri Felipe: “¿Tsika amananteka owanawontsi owakayaariri maawoini jirika atziripaini?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Rosampitashitari Felipe inkemantyaariri tsika inkante, tema riyotake Jesús oita ranteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ari rakanake Felipe, ikantanake: “Eero rimonkaata koriki amanantantyaawori owanawontsi, eepichokiinira roya jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Irojatzi rakantanakari Andrés, itsipa riyotaanewo, irirentzi Simón Pedro, ikantzi: ");
INSERT INTO cpbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Jirika apaani eentsi amaintsiri 5 pan, apite shima. ¿Arima riyomaatakyaari osheki atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ikantanake Jesús: “Pinkanteri maawoini risaikayete.” Onatsiryaapankaatakera, saikaiyanakeni. Ikaataiyini 5000 atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Raakotanakero Jesús pan, riwetharyaanakari Pawa, itzipetowakeniri ikaatzi saikaintsiri. Rimatakeri eejatzi shima, ipayetakeri okaatzi ikowakeri royaawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ikanta ikemakitaiyakani maawoini, ikantairi Jesús riyotaanewo: “Powiitairo opetoki tzimagaantapaintsiri, eero apaawaitanta.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Rowiiyetairo riyotaanewo, yeekitai 12 kantziri opetoki tzimagaantapaintsiri kaawetachari 5 pan. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jirikapaini atziri, iñaakero ritasonkawentakero Jesús owanawontsi, ikantaiyanakeni: “Imaperotatya, iriitake jirika Kamantantaneri ikashaakaitakairi ripoke jaka kipatsiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iri kantacha riyotake Jesús ishintsineentaitatyeeri ragaitanakeri impinkathariwenteri atziripaini, piyanaka otzishiki, ari risaikawaite apaniroini. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Okanta otsireniityaanake, oirinkaiyaani inkaareki riyotaanewo Jesús, ");
INSERT INTO cpbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","otetaiyapaani pitotsiki, montyaakotaiyaani riyaatairo Capernaum-ki. Tema tsireniperotanake, te ripokita Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ari otampyaatapaake, antawoite otamakaatanake inkaare. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Osamanitake rimontyaakotaiyani, iñaawaatziiri Jesús ripokashitairi ranashaatantaawo inkaare. Antawo ithaawaiyanakeni riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ikantapai Jesús: “¡Naakatake, eero pithaawaiyini!” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kimoshire ikantaiyani rotetawairi pitotsiki, tekera osamaniteeta, aatakotaiyapaakeni tsika ikowakero rareetya. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Okanta okiteeshetamanai, irojatzi royaawentaka atziripaini intatsikero, riyotaiyakeni apinto pitotsi rimontyaantanakari riyotaarewopaini, te royaatanairi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Areetakotantapaaka otsipa pitotsi poñaachari Tiberias-ki, aatapaake tsika rowaiyakani chapinki pan riwetharyaantakariri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ikanta riyotaitake te risaiki Jesús, eejatzi riyotaanewo, otetaiyanaani atziripaini pitotsiki, jatake Capernaum-ki rithotyaakotairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ikanta rareetaiyaani intatsikero, iñaapairi Jesús, rosampitapairi: “Rabí, ¿tsikapaitema pareetaka eeroka jaka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ikantanake Jesús: “Iro pithotyaakotantanari eerokapaini pikemakitaiyakanira chapinki powaiyakani, te iro pithotyaakotantenari pikemathatatziirowa nitasonkawentantakera. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Te onkameethate patsipewentyaawo owanawontsi thonkanetachari iro patsipewentya owanawontsi enitatsiri, kañaanetakaimine. Iro owanawontsi ipantziri Itomi Atziri, tema Pawa, Ashitariri, iriitake inintakaake ririiperote.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Rosampitanakeri, ikantziri: “¿Tsika nonkantyaaka natsipewentantyaawori ikowiri Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rakanake Jesús: “Eenitatsi ikowiri Pawa pantairi, ontzimatye pinkemisantairi rotyaantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Rosampiitanakeri eejatzi: “¿Janjaatya pitasonkawentante ompoñaantyaari nonkemisantemi? ¿Iitakama panteri? ");
INSERT INTO cpbNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pairani acharineete rowayetakawo ochempiki iitaitziri ‘maná’, iro ikantaitziri Osankenarentsi: Pawa pakeri owanawontsi poñagainchari inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Rakanake Jesús, ikantzi: “Okaatzi owanawontsiperori poñagainchari inkiteki, kaari Moisés-ni panterone. Iri Ashitanari pemirone. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tema jirika owanawontsi ipantziri Pawa, iriitake poñagainchari inkiteki, iri kañaanetakaayetairine isaawikisatzipaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ari ikantaitanakeri: “Pinkatharí, pimpapiintenawo jiroka owanawontsi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ikantanake Jesús: “Naakatake owanawontsi owañaantatsiri. Inkaate shentashiretainane naaka, eero ritasheyawaitai. Inkaate kemisantanainane naaka, eero imerewaitai. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tema nokantzitakemi, okantawetaka piñaawetakena temaita pikemisantaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ikaatzi rishentashiretakaakenari Ashitanari, iriitake shentashireperotainane, eero nomanintawakeri naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te iro nipokantyaari nopoñaakaga inkiteki nantayetero nokowashiwaitari, iro nantapiinte ikowiri Ashitanari, otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jiroka ikowiri Ashitanari otyaantakenari, eero nopeyagaantawaitzi apaani rishentashiretakaakenari, nowiriintairi paata weyaantapaakyaawone kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ikowi Ashitanari, maawoini aminairine Itomi Pawa, kemisantairine, aritake rañaakaayetairi. Naakatake owiriintairine imonkaatapaakyaarika kiteesheri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iro ipoñaantanakari Judá-ite ikishimawaitanakeri Jesús, ikemakeri ikantake: “Naakatake owanawontsi poñagainchari inkiteki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ikantawakaiyanakani: “¿Kaarima jirika Jesús, itomi José? Niyotziri naaka ashitariri. ¿Iitaka ikantantari: ‘Nopoñaawo inkiteki?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ikantanake Jesús: “Atake pikishimawaitakena. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tekaatsi shentashirewaitenane naaka, eerorika ramashiretairi Ashitanari otyaantakenari. Naaka owiriintairine imonkaapaitetapaakyaarika kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ikantake rosankenareki Kamantantaneriite: Iriitake Pawa yotairine maawoini. Maawoini kemairiri Ashitanari, yotairiri irirori, rishentashiretaana naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Te nokantzi eenitatsi ñaawootakeriri Ashitanari, apa iñaawootziri poñagainchari Pawaki. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Inkaate kemisantainane naaka, ari inkañaanetai. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naakatake owanawontsi añaakaantatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Rowawetakawo picharinepaini ‘maná’ ochempiki, kamimaitaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Iriima oshiyakawori owanawontsi nokenkithatakotziri naaka ipoñaakawo inkiteki. Inkaate owaiyaarine jirika, eero ikaamanetai. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naaka kañaaneri owanawontsi poñagainchari inkiteki. Inkaate owakyaawone jiroka owanawontsi, ari inkañaanetai. Jiroka owanawontsi nopantziri naaka, nowathapero ini. Iri nishinewenta isaawikisatzipaini inkañaanetantaiyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ari ikantawakaiyani Judá-ite: “¿Tsika ikenakairoka jirika rowakaantairori iwatha?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ikantzi Jesús: “Eerorika powawo eerokapaini iwatha Itomi Atziri, eerorika piriro riraa, eero pikañaanetai. Imaperotatyaaga. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inkaate owakyaawone nowatha, irakerone niraa, ari inkañaanetai. Naakatake owiriintairine imonkaapaitetapaakyaarika kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tema jiroka nowatha owanawontsiperori ini, jiroka niraa iro riraperotairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inkaate owakyaawone nowatha, irakerone niraa, rishentashiretaanaga naaka, eejatzi naaka nishentashiretaari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tema Ashitanari, otyaantakenari, kañaaneri rini, iriitake añaakaanari naaka. Ari okantari eejatzi, inkaate owainane naaka, aritake nañaakaayetairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nokenkithatakotatziiro owanawontsi poñagainchari inkiteki. Jiroka owanawontsi te oshiyawo ‘maná’ rowayetakari pairani picharinepaini. Okantawetaka rowawetakawo, kamayetai. Iriima inkaate owakyaarine jirika oshiyawori owanawontsi, ari inkañaanetai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iro riyotaantakeri Jesús janta rapatotapiintaiyanira nampitawori Capernaum-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ikanta ikemaitakero jiroka yotagaantsi, ikantaiyanakeni oyaatakeriri Jesús: “Pomeentsi ayotantyaawori ikantayetakeri Jesús. ¿Iitaka kemisantamatsiterine?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iyotake Jesús, okaatzi ikishimawaitaitziriri, rosampitanakeri: “¿Te inimotemi jiroka? ");
INSERT INTO cpbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Oitaka awisatsine, arika piñeeri Itomi Atziri rowenonkaiya ipoñaakaga pairani? ");
INSERT INTO cpbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Okaatzi nokenkithatakoyetakemiri, irootake añaashiretakaantatsiri, kaari awathapero nonkenkithatakote, tekaatsi oiperotya awatha. Iro nokenkithatakotzi awentaashirenkantsi kaari koñaanetatsi, añaakaantatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Iro kantacha eenitatsi apawopaini pikaataiyinira kaari kemisantatsine.” Tema riyotzitakari Jesús kaari kemisantatsine, tsika itzimi pithokashityaarine. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eekero ikantanakitzi Jesús: “Iro nokantzitantakemiri: ‘ikaatzi shentashiretaanari naaka, iriira rishinetaanari Ashitanari.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aripaite iñagaitake ripiyapithatanakari osheki oyaawetapiintariri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ikanta Jesús rosampitanakeri 12 riyotaanewo: “¿Pikowatziima eejatzi eerokapaini piyaayetai?” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Rakanakeri Simón Pedro: “Pinkatharí, ¿Iitaka niyaatashiteri? Eerokatake kenkithatakotakerori kañaanetaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tema nokemisantakemi naakapaini. Niyotaiyini eerokatake Cristo, Itomi Pawa Kañaaneri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Rakanake Jesús, ikantziri: “¿Kaarima naaka yoyaakemiri pikaatakera 12? Iro kantzimaitacha, eenitatsi apaani pikaatakera kamaari rinatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ikenkithawaitakero jiroka Jesús, ikenkithatakotatziiri Judas, itomi Simón Iscariote. Tema iriitake Judas pithokashityaarine, iriiwetaka apaani kaawetachari 12 riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Okanta okaatapaake jirokapaini, rareetantawaita Jesús janta Galilea-ki. Te ikowi risaikanai Judea-ki. Tema rithotyaakotatziiri janta Judá-ite ritsitokeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iro kantacha monkaatzimataka kiteesheri ikimoshirewentapiintziro Judá-ite iitaitziri “pankoshetantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rithainkitanakari irirentzi irirori okaakiini, ikantanakeri: “Eero pimanashiwaita jaka, piyaate Judea-ki iñaantemiri piyotaanewopaini onkaate pantayeteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ikaatzi kowatsiri rasagaawentaityaari, te rimanakaawo rantayetziri. Pantayetziro eeroka oitarika, poñaagantero tsika ipiyotaiyani atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Te ikemisantaatsikaitziri eejatzi irirentzipaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ikantanake Jesús: “Tekera imonkaata noñaagantantya naaka, irooma eerokapaini inimowaitzimi maawoini kiteesheriki. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Te ikisaneentzimi eeroka isaawikisatzipaini. Irooma naaka osheki ikisaneentana, tema koñaawo nokantziro naaka, okaatzi rantayetziri kaariperori ini. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Piyaataiyeni eeroka roimoshirenkaitaga, eerowa niyaatzita naaka, tema tekera imonkaapaitetyaata noñaagantantya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Riñaawaitakerowa jiroka, irojatzi risaikanake Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tema jataiyanakeni irirentzipaini, jatanake eejatzi Jesús roimoshirenkaitaga te roñaaganta rimananekiini ikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Rithotyaakotakeri Judá-ite janta roimoshirenkaitaga, ikantaiyini: “¿Tsika risaikika atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Osheki atziripaini kenkithatakotakeriri Jesús. Eenitatsi kantayetatsiri: “Kameetha rini atziri.” Tzimatsi itsipa kantatsiri: “Te ikameethatzi, ramatawitakeri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iro kantzimaitacha, rimanashirekiini ikenkithatakoitziri Jesús, tema ithaawantatyaari Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Okanta osamanitake roimoshirenkaita, kyaapaake Jesús tasorentsipankoki, riyotaantapai. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Riyokitziiwentakeri Judá-ite, ikantaiyini: “¿Iitaka riyotanetantari jirika, te ikyaaperoweta tsika riyotaantaitzi?” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ari rakanake Jesús, ikantzi: “Okaatzi niyotaantziri te naaka yotashityaawone, iri yotakaanawo otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inkaate kowaperotairone ikowiri Pawa, ari riyotairo iri Pawa yotakaanawori okaatzi niyotaantziri, tema te naaka yotashiwaityaawone. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tema ikaatzi yotaantzirori riyotashiwaitari, ikowashita impinkathataiteri. Iriima kowakowatzirori impinkathatairi otyaantakeriri, iri kenkithawaitzirori irooperori. Te itzipishirewainetzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Tema rosankenawetakemi pairani Moisés-ni Inintakaantaitanewo? Iro kantacha, te pimonkaataiyironi. ¿Iitaka pasaryaantanari pitsitokena?” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ari ikantaiyanakeni atziripaini: “¡Kamaarí! ¿Iitaka asariimiri ritsitokemi?” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ikantzi Jesús: “Maawoini eerokapaini osheki piyokitziiwentakero piñaakenaga nantakeri kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iro kantzimaitacha, inintakaantake Moisés-ni pitomeshaanitapiintante. (Okantawetaka kaari Moisés-ni poñaakaantyaawone jiroka, iriira poñaakaantanakawori acharineete tekera itzimiita Moisés-ni.) Iro opoñaantari pitomeshaanitapiintantzi eerokapaini, okantawetaka kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Piñaakero, pimonkaatantyaawori eerokapaini Inintakaantaitanewo rosankenatakeri Moisés-ni pitomeshaanitapiintantake kiteesheriki rimakoryaantaitari. ¿Iitaka pikisaneentantanari naaka netsiyatakotakagairi maawoini iwathaki apaani atziri kiteesheriki rimakoryaantaitari? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Paamaawentya owapeyimotashitzimikari arika piyakowentante. Tampatzikashirepero pinkantya paminakoyetante.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eenitatsi Jerusalén-satzi, osampitantanaintsiri, ikantzi: “¿Kaarima jirika rithotyaakoitziri ritsitokaiteri? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jirinta risaikake, maawoini iñagaitziri ikenkithawaitzi. Tekaatsi akotashiterine. ¿Riyotatziima jewaripaini imaperotatyaaga Cristo rinatzi jirika atziri? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Iri kantacha jirika, ayotaiyini tsika ipoñaawo. Irooma paata arika ripokake maperotzirori iita Cristo, tekaatsi yotatsine tsika ipoñaawo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ikanta ikemake Jesús, risaikake riyotaantzi tasorentsipankoki, shintsineenka ikantanake: “¡Arima, piyotaiyanani eerokapaini tsika nopoñaawo! Iro kantacha te naaka nintakaashityaawone nipoke, rotyaantanewo nini rawentaaperoitari. Tsika itzimi kaari piyotamatsite eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Niyotziri naaka tema ari nokaatziri, iriitake otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ari ikowawetanaka raakaantanakerime, iro kantacha tekaatsi akotashitanakerine, tema tekera imonkaapaitetaata. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Osheki kemisantanakeriri Jesús, ikantaiyini: “Kaarikame jirika Cristo pokatsineme, eero ritasonkawentantayetzime jirika, piñaakero.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ikanta Fariseo-paini ikemakero ikantayetakeri atziripaini ikenkithatakotziri Jesús, raapatziyanakari reeware Imperatasorentsitaarewo, rotyaantakeri kempoyaawentzirori tasorentsipanko rotaiyakiteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ikantanake Jesús: “Eero osamanitzi nisaikimotanaimi eerokapaini, iro niyaatai risaikira otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Osheki pinkowakowawetaina eerokapaini, eeromaita piñagaana, tema eero pitsipatana tsika nisaikapai naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ari rosampitawakaanaka Judá-ite: “¿Tsika riyaamatsiteka jirika eero añaantari? ¿Riyaatatyeema otsipaki nampitsi roiwawaayetakaga asheninkapaini Judá-ite, riyotaayetairi kaari asheninkata? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Iitaka ikantakotziri: ‘Pinkowakowawetaina, eeromaita piñagaana, tema eero pitsipatana tsika nisaikapai naaka?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Weyaantapaakawori kiteesheri ari roimoshirenkaperoitari. Ari ikatziyanakari Jesús, shintsiini ikanta ikenkithawaitanake, ikantzi: “Inkaate mereneentawaitatsine, rishentashiretaina naaka, rirawaitai. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tema okantzi Osankenarentsipero: Inkaate kemisantainane naaka, oshiyawaityaawo oshiyashiretantairime ñaa kañaanetakaantatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iri roshiyakaawentzi Jesús inkaate kemisantairine ari risaikashiretantaiyaari Tasorenkantsi. Okantawetaka tekera rotyaantaitziriita Tasorenkantsi, tema Jesús tekera rowenonkashitaawoota rowaneenkawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tzimatsi atziri kemakeriri Jesús ikantakeri, ikantaiyanakeni: “Rimaperotatya jirika atziri Kamantantaneri rini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tzimatsi itsipa kantanaintsiri: “Cristo rini jirika.” Iro kantacha eenitatsi itsipa kantatsiri: “Kaari, tema Cristo te ipoñaawo Galilea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tema okantzi Osankenarentsipero: Icharine rinatzi pinkathari David-ni tsikarika intzime Cristo-tatsine, impoñeeyaawo Belén-ki, inampiki pairani David-ni.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ari itzimawentawakaawentanakari atziripaini Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tzimatsi kowawetanainchari raakaanterime, tekaatsimaita akotashiterine. ");
INSERT INTO cpbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ikanta saikawentzirori tasorentsipanko jatake risaikira Fariseo-paini itsipatakari reeware Imperatasorentsitaarewo, ari rosampitawairi, ikantziri: “¿Iitaka kaari pamantakari?” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ikantaiyini irirori: “¡Te iñagaitzi oshiyaarine jirika ikenkithatzi!” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ikantaiyanakeni Fariseo: “¿Pimatzitakawoma eerokapaini pishinetaka ramatawitemi? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Tzimatsima Itzinkami nokaataiyini kemisantakeriri jirika atziri? ¿Tzimatsima nokaatzirira naakapaini Fariseo kemisantakeriri? ");
INSERT INTO cpbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Apatziro ikemisantamatsitake atziripaini kaari yotakoterone Inintakaantaitanewo, owasanketaarewo rinayete.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ikanta Nicodemo, Fariseo jatashitakeriri pairani iñeeri Jesús, ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Okantzi Inintakaantaitanewo, te ishinetaantsite ayakowenteri atziri terika ankemeri aakapaini onkene ayotero oita rantakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ari ikantaiyanakeni irirori: “¿Eerokama eejatzi Galilea-satzi? Piñaanaperotero Osankenarentsipero, ari piñaakero tekaatsi Kamantantaneri poñaachane Galilea-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ikanta riyaataiyaini ipankokipaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tonkaanake irirori Jesús otzishiki Olivo. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Okanta okiteeshetamanai, piyaawo tasorentsipankoki. Osheki atziri piyowentawaariri, saikapai Jesús riyotaapairi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ikanta Yotzinkariite itsipayetakari Fariseo-paini ramakeniri apaani tsinane roonthagaitakari omayempitzi. Ikatziyapaakero niyankineki ipiyotaiyakanira. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ikantapaakeri Jesús: “Yotaantanerí, jiroka tsinane roonthagaitakari omayempiwaitzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Inintakaantziro Moisés-ni pairani ritsitokaitero antzirori jiroka. ¿Tsika pikantzika eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iroowa rosampitantariri jirikapaini ikowi rikompitakayaari, ontzimantyaari oita inkantakoteriri. Iri kantacha Jesús oiyotanaka rosankenawaitantawo rako kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eekero rosampitatziiri, katziyanaka roiyotakaga, ikantanake: “Terika pikaariperoshiretaiyini eeroka, petyaawo pishemeero jiroka tsinane.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eejatzi roiyotanaa, rapiitanairo rosankenawaitzi kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ikanta ikemaiyawakeroni jiroka, piyayetanaka ikenkithashiretanakero tsika ikantayeta iriroripaini. Iri etanakawo ripiyanaka antariitepaini. Ikanta risaikanake Jesús apitekeroini itsipatakawo tsinane ramaitakeri, ");
INSERT INTO cpbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ikatziyanaawo roiyowetakaga, rosampitakero ikantziro: “Tsinané, ¿Tsika ikenaiyanakenika? ¿Tekaatsima jatakairone riyakowentemi?” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akanakeri iroori okantziri: “Tekaatsi Pinkatharí.” Ikantanake Jesús: “Eejatzi naaka eero niyakowentzimi. Piyaatai iroñaaka, eero papiitairo pinkaariperoshirewaitai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ari rapiitanakero Jesús riyotairi atziripaini, ikantziri: “Naakatake kiteesheenkatakotziriri isaawikisatzipaini. Inkaate shentashiretainane naaka, aritake nonkiteesheenkatakoshiretairi, oshiyawaityaawo te ikenawaitzi otsirenikitzira.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ikantaiyanakeni Fariseo-paini: “Powakowentawaitashitaka pikenkithatakowaita apaniroini, te opantawo pikenkithatakowaiwetaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ari rakanake Jesús: “Arime onkantawetyaame nokenkithatakowaiwetaka apaniroini, opantawo nokenkithatziri naaka. Tema niyotzi tsika nopoñaakawo, tsika janta niyaate. Temaita piyotaiyironi eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Iro pametashitapiintari eerokapaini poshiyakotari atziripaini riyakowentantzi. Irooma naaka tekaatsi niyakowente. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arime niyakowentanteme naaka, okaatzi nokantayetziri imaperotatya, te apaniroini niyakowentante, ari nokaatziri Ashitanari otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jiroka okantzi Inintakaantaitakemiri eerokapaini: Arika oshiyawakaiyaani inkantayeteri apite thawetakotantaneri, imaperotatya okaatzi ikenkithatziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naakatake thawetakotaincha. Eejatzi Ashitanari otyaantakenari irijatzi itsipa thawetakotakenari. Apite nokaatzi nothawetakotaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ari rosampitanakeri: “¿Tsika risaikika Ashitzimiri?” Ikantzi Jesús: “Eerokapaini te piyotaiyenani naaka, ari pikantziri eejatzi Ashitanari. Arika piyotename naaka, ari piyotakerime eejatzi Ashitanari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ari riyotaantake Jesús tasorentsipankoki tsika rowaitapiintziri koriki rashitakaitariri Pawa. Iro kantzimaitacha tekaatsi aakaanterine, tema tekera imonkaataata. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Rapiitanakero Jesús ikantzi: “Arika niyaatai, osheki pithotyaakowetaina eerokapaini, iro kantzimaitacha ari pinkamakoyetairo piyaariperonka. Tsika niyaatai naaka, eero pareetaawo eerokapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ari ikantaiyanakeni Judá-ite: “¿Rishinewaitatyaama jirika. Ikantantaritya eero areeta aakapaini tsika inkenai irirori?” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ikantanake Jesús: “Isaawikisatzi pinatzi eerokapaini, irooma naaka jenokisatzi nini. Arira pinampitawo eerokapaini kipatsiki, irooma naaka te nonampitawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iroowa nokantantzimiri: ‘Ari pinkamakoyetairo piyaariperonka. Tema eerorika pikemisantairo nothawetakowetakaga noitaga naaka, irootake pinkamakotantaiyaawori piyaariperonka.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Irojatzi rosampitantanakariri: “¿Piitakama eeroka?” Ari rakanakeri Jesús: “Nokamantakemi ketziroini. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Eenitatsi osheki nonkantemiri, ari niyakowentakemi eejatzi. Tema okaatzi ikenkithawaitziri otyaantakenari irooperori inatzi. Okaatzi nokamantakemiri eeroka isaawikisatzipaini, irootake ikamantakenari irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iri kantacha jirikapaini kemakeriri Jesús, te ikemathatawakeri ikenkithatakotziri Ashitairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ikantanake Jesús: “Arika pinkentakotakaantakeri Itomi Atziri, aripaite piyote naakatake. Te naaka antashiwaityaawone nokowiri. Apatziro niyotaantziro okaatzi riyotaanari Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tema itzimi otyaantakenari ari itsipashiretana naaka. Te rookanawentana Ashitanari, tema nantapiintakeniri okaatzi kameethatzimotziriri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ikanta ikenkithatakoyetakerowa Jesús jiroka, osheki kemisantanakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ipoña Jesús ikantanakeri Judá-ite ikaatzi kemisantanakeriri: “Arika poisokerotanakyaawo niñaane, eerokatake iriiperori niyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ari piyotairo irooperori, iro saikakaashiwaitaimine.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rakaiyanakeni jirikapaini: “Icharineete Abraham-ni ninayetzi naakapaini. Tekaatsi imperawaitenane. ¿Iitaka pikantantanari eeroka: ‘Ari pisaikashiwaitaiya?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ikantanake Jesús: “Ikaatzi antapiintzirori kaariperori, oshiyawaitakawo imperawaitatyeeyaarime. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Apaani imperataarewo eepichokiini isheninkaitari, iriima itomintaitari rashi rowaatyeero isheninkaityaari. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tema arika risaikakaashiwaitaimi Itomintaitari, ari pisaikashiperowaitaiya. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niyotaiyimini icharineete Abraham-ni pini. Iro kantzimaitacha pikowaiyakeni pitsitokena, tema te inimotemi niñaaneyetari. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iro nokenkithatakoyetzi naaka okaatzi roñaaganari Ashitanari. Irooma eerokapaini pantashitawo pikemakotziriri ashitzimiri eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ari rakaiyanakeni iriroripaini: “¡Iri Abraham-ni aitziri Ashitanari, iriitake nocharineete!” Ikantanake Jesús: “Eerokame charinetyaarineme Abraham-ni, ari pantakerome okaatzi rantayetakeri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iro kantacha, okantawetaka nokenkithatakemiro irooperori okaatzi riyotakaakenari Pawa, pikowaiyakeni eerokapaini pitsitokena. ¡Iroowa kaari rantzi pairani Abraham-ni! ");
INSERT INTO cpbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Irojatzi pantapiintakeri rantakeri pairani picharinepaini.” Ari ikantaiyanakeni iriroripaini: “¡Te naakapaini rowaiyane thainkatasorentsiwaitaneri. Apatziro ikanta Ashitanari, iriitake Pawa!” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ari rakanakeri Jesús: “Kyaaryoome rashitemime Pawa, ari pinintakename, tema Pawaki nopoñaakawowanki naaka, piñaakena jaka. Te naaka pokashiwaitachane nonintakaanekiini, Pawa otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Iitaka kaari pikemathatantana eerokapaini? Iro kantakaawori te pikowaiyini pinkemisantero niñaane. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Iriira ashitzimiri Kamaari, pantapiintakeniri ikowiri. Tema ari rashi rowiro Kamaari owakera etantanakari pairani, rowamaashiretantzi. Thairi rini, te riñaawaitziro irooperori. Arika inkowe ramatawitante, riñaawaitziro thaiyaantsi. Antariite thairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Irooma naaka niñaawaitziro irooperori ñaantsi, temaita pikemisantaiyanani eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Eenitatsima jaka pikaataiyakeni yotzirori ikantzi: ‘Kaariperoshireri rini Jesús?’ Tema irooperori okaatzi nokenkithawaitziri ¿iitaka kaari pikemisantantana? ");
INSERT INTO cpbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ikaatzi rashitari Pawa, ikemisantziro riñaane. Irooma eerokapaini te rashitzimi Pawa, te pikowi pinkemisantaiyeni.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ikanta Judá-ite ikantanakeri Jesús: “Imaperotya nokantaiyakemini Samaria-satzi pini, tema Kamaari pini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rakanake Jesús: “Te nonkamaarite, nopinkathatziri naaka Ashitanari. Irooma eerokapaini, te pimpinkathataiyenani. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Te naaka kowashitachane pimpinkathatena, tzimatsi itsipa kowatsiri impinkathaitena, iriitake yakowentantatsine. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Inkaate kemisantairone niñaane, eero ikaamaneyetai. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ikantaiyanakeni Judá-ite: “Ari niyoperotaiyini imapero pikamaaritzi. Tema kamake Abraham-ni, ari ikantakari Kamantantaneriite, kamayetake maawoini. Iro pikantantari eeroka: ‘Inkaaterika kemisantairone niñaane, eero ikaamaneyetai.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Panairima eeroka nocharineni Abraham? Kamake irirori, ari ikantayetakari Kamantantaneriite eejatzi. ¿Tsikama piimatsitaka eeroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rakanake Jesús: “Naakame kowashitachane impinkathaitename, tekaatsi pantenane. Iri kantacha, iri Ashitanari pinkatharitakaanari. Irijatzi pikantawetapiintari eerokapaini ‘Nowawane.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tetzimaita piyotaiyirini eerokapaini. Irooma naaka noñiiri. Arikame nonkante ‘te noñiiri’, thairi nini noshiyakotakemiro eerokapaini. Iro kantzimaitacha imapero noñiiri. Nokemisantziro riñaane. ");
INSERT INTO cpbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pairani Abraham-ni, picharineyetanakari eerokapaini, ikimoshiretake iñeero nipokapaitete. Aritake iñaakena ketziroini, antawoite ikimoshiretake.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ikanta Judá-ite ikantanakeri Jesús: “Te otzimi eeroka 50 posarentsite. ¿Iita pikantantari piñiiri Abraham-ni?” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ari rakanake Jesús: “Tekera itzimiita Abraham-ni. ‘Naakatzitaka jirika naakatapiintatsiri.’ Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ikanta jirikapaini raawetanaka mapi ikowi rishemeerime. Iri kantzimaitacha Jesús, rimanapithatanakari. Shitowanake tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ikanta ikenayetzi Jesús, iñaake mawityaakiri, rashi rowatziiro owakera itzimapaake. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ikanta riyotaanewo rosampitakeri, ikantziri: “Rabí, ¿Iitaka kaari ikowichaatanta owakera itzimake jirika atziri? ¿Irooma kantakaantzirori iyaariperonka ipaapate? ¿Irooma kantakaantzirori iyaariperonka irirori?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Rakanake Jesús, ikantzi: “Te iro kantakaanterone iyaariperonka irirori, te okantakaantziro eejatzi iyaariperonka ipaapate. Iroowa opoñaantari jiroka, iñaantaityaawori ishintsinka Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eeniro okiteeshetzi, ontzimatye antero rantawaire otyaantakenari. Tema arika ontsirenitanake, tekaatsi kanterone rantawaite. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eeniro nisaiki naaka jaka kipatsiki, naakatake kiteesheenkatakotziriri isaawikisatziite.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ikaatakero ikenkithawaitake Jesús, reewatanake kipatsiki, ramirokake eepichokiini kipatsipitha, ritziryookitakeri mawityaakiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Riñaanatakeri ikantziri: “Piyaate pinkiwaakitya owaankanaataga jitachari Siloé.” Jatanake mawityaakiri, ikiwaakitapaaka. Ikanta ripiyapaa, kantanaa raminanai kameethaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ikanta isheninkapaini, ikaatzi ñaapiintziriri ikowakotantzi impashitaityaari, rosampitawakaiyani, ikantzi: “¿Kaarima jirika kowapiintatsiri impashitaityaari?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tzimatsi kantatsiri: “Iriitake.” Itsipa kantatsiri: “Kaari, iri oshiyawetariri.” Iro kantzimaitacha, ikantzi irirori: “Naakatake.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Rosampitaitanakeri: “¿Tsika pikantaaka pikowichaatantaari iroñaaka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ikantzi irirori: “Jirinta atziri jitachari Jesús, iriitake aminakagaanari, eenitatsi ritziritantakenari nokiki, ikantakena: ‘Piyaate owaankanaataga Siloé. Pinkiwaakitya.’ Nokanta niyaatanake, ari nokiwaakitapaaka, koñaatanai namine.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ikantziri: “¿Tsika iroñaaka jirika atziri?” Rakanake irirori: “Te niyotzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ari ragaitanakeri mawityaakiri risaikira Fariseo-paini. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tema kiteesheri rimakoryaantaitari ini, ritziryookitantakariri Jesús mawityaakitatsiri, aminai kameethaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Rosampitakeri Fariseo-paini tsika okanta raminantaari kameethaini. Ikantanake irirori: “Ritziritantakenawo nokiki eepichokiini kipatsi, irojatzi nokiwaakitantakari. Aminaana iroñaaka kameethaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ikantzi Fariseo: “Itzimi antakerori jiroka kaari rashi Pawa, tema te ipinkathatziro kiteesheri rimakoryaantaitari.” Iro kantacha ikantaiyini itsipa: “¿Kaariperoshireri rinatyeeme, eerome rantziro jiroka?” Te raapatziyawakaawo ikantaiyakerini Fariseo-paini. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ari rapiitakeri rosampitziri mawityaakiwetachari: “¿Iitaka pikenkithashiretari eeroka, iitaka aminakagaimiri kameethaini?” Ikantzi irirori: “Kamantantaneri rini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aminawaitai iroñaaka kameethaini, te ikemisantziri Judá-ite mawityaakiperori rinaweta. Irojatzi ikaimantakariri ipaapate, ");
INSERT INTO cpbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","rosampitawakeri, ikantziri: “¿Iriima pitomi jirika? Pinkantena rashi rowiro imawityaakitzi owakera itzimapaake. ¿Tsika okantaka raminantaari iroñaaka kameethaini?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Rakanake ashitariri: “Niyotaiyini iriitake nowaiyanewo, ari rashi rowiro imawityaakitzi owakera itzimapaake. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Iro kantacha te niyote tsika okanta raminantaari kameethaini iroñaaka, te niyote eejatzi iita aminakagairiri kameethaini. Posampiteri irirori, antari rinatzi, iriitake kamantemine.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iro ikantantari ashitariri tema ithaawatzi, ikantaiyakeni Judá-ite: “Tzimatsirika kantatsine Cristo rini jirika Jesús, eero nishinetairi inkyagai ipiyotaitapiintaga.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iro ikantantari ashitariri: “Posampiteri irirori, tema antari rinatzi notomi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Rapiitakero Judá-ite ikaimairi mawityaakiwetachari, ikantziri: “Pimpinkathateri Pawa, pinkamantena kameethaini, eero pipinkathawaitashitari jirika atziri, kaariperoshireri rini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ikantanake irirori: “Te niyote naaka kaariperoshirerira rini. Apatziro niyotzi mawityaakiri ninaweta. Iro kantacha aminaana kameethaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Rapiitakeri rosampitziri: “¿Tsika ikantakemika? ¿Iitaka rantakeri raminakaantaimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ari rakanairi: “Nokantawetakemi, temaita pikemisantziri. ¿Iitaka pikowantari napiitemiro? ¿Pikowatziima pinkemisanteri eerokapaini?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ari ikaweyawaitanakeri, ikantziri: “Aamaaka pikemisantziririka eeroka jirika atziri, irooma naakapaini nokemisantziro Inintakaantziri Moisés-ni. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niyotzi naakapaini riñaanatakeri Pawa pairani Moisés-ni. Iriima jirika, tekaatsi yoterine tsika ipoñaaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ari rakanake atziri, ikantzi: “¡Tsikama okantatyaaka jiroka! Raminakagaana naaka kameethaini, te piyoteri eerokapaini tsika ipoñaa. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ayotaiyini maawoini te ikemiri Pawa kaariperoshireri. Apatziro ikemiro riwetharyaanewo tsika itzimi pinkathatziriri, ikaatzi antanairori ikowakairiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tekaatsi ankemakowentapiinte tzimatsi aminakagairine mawityaakitatsiri owakera itzimapaake. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eerome ipoñaakawo jirika atziri Pawakinta, eero rantzirome jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ari ikantanakeri: “Piyaariperonka pitzimakaake eeroka. ¿Pikowima piyotaina naaka iroñaaka?” Romishitowakaantairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yotake Jesús romishitowakaantaitakeri mawityaakiwetachari. Ikanta iñagairi paata, rosampitairi: “¿Pikemisantzirima eeroka Itomi Atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ikantanakeri irirori: “Pinkatharí, pookotainari tsika itzimi, onkene nonkemisanteri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ikantanakeri Jesús: “Tema piñaakeri, naakatake pikenkithawaitakaakerira.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ikanta jirika atziri rotziwerowashitanakari Jesús ipinkathatanakeri, ikantziri: “Nokemisantzimi Pinkatharí.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ikantzi Jesús: “Nipokake naaka kipatsiki niyakowentantai, iroowa inkowichaatantaiyaari mawityaakiwetachari. Iriima ikaatzi aminawetachari, mawityaaki inkantaiya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tzimatsi Fariseo tsipatakariri Jesús, ikemakeri ikantake, rosampitanakeri: “¿Poshiyakaantatyaanarima naakapaini mawityaakiri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ikantanake Jesús: “Imaperotatyeeyaame poshiyakari mawityaakitatsiri eerokapaini, tekaatsi yakowentemirone piyaariperonka. Irooma pikantaiyinira te poshiyari mawityaakiri, irootake piñaantaiyaawori riyakowentaitemiro pipiyathatakenaga.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ari ikantanake Jesús: “Inkaaterika kaari kyaatsine imoontaitzirowa owejatanto, ranonkashitakyaarika inkyaantyaari, koshintzi rini, kaariperori rini. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Iriima kyaatsiri imoontaitzirowa, iriitake kempoyaapiintziriri oweja. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iriirika ashitaryaakerone kempoyiirori ashitakowontsi, irojatzi inkyaantapaakya kempoyiiriri oweja, ripairyaapairi inkaimayetapaakeri, ari riyowaantetawairi. Iri omishitowairine kempoyaapiintakeriri oweja. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Arika romishitowakeri maawoini, iri jewaterine kempoyiiriri, royaatzimaityaari oweja, tema riyowaantetziri iri kempoyiiriri. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Iro kantacha te royaatziri kaari iñaapiintzi, osheki rishiyapithatari, tema te riyowaantetziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ikantakera Jesús roshiyakaawentziniri, iro kantacha te ikemathatawakero jirikapaini oita ikantziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ari rapiitanakero Jesús ikantziri: “Naakatake oshiyawori imoontaitzirowa owejatanto. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ikaatzi kaariperoriite etakawori ketziroini tekera nipokiita naaka, roshiyashitakari koshintzi. Irootake kaari ikemisantantaiyarini oweja. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naakatake oshiyawori imoontaitziro owejatanto. Ikaatzira kyagaatsine noshiyakawowa imoontaitziro owejatanto, ari rawisakoshiretai. Ari roshiyakotaiyaari oweja ripiyapiyata ikyaapiintzira, rishitowapiintzi eejatzi. Te okoityiimotari rowanawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iriima koshintzi apatziro ripoki inkoshite, ritsitokante, rithonkante. Irooma naaka nipokake nañaakaashireperotantai. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naaka oshiyari kameethari kempoyiiriri oweja. Apaani kameethari kempoyiiriri oweja, rishinewentari. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ikaatzi ripinaitziri ikempoyiirira ashinentsi oweja, arika iñaawake owaminthatariri, rookanawentziri, ari rowagaantaitya piratsi rishiyanakerika kempoyiiriri, pookayetai itsipa piratsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iro rishiyantari kempoyiiriri, ikowashita ripinaiteri. Te inkowaperote inkempoyeeri oweja. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Naaka oshiyari kameethari kempoyiiriri oweja. Niyotziri nowejate. Riyotzitana eejatzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ikantanaga riyoperotana naaka Ashitanari, ari nokantzitari eejatzi naaka niyoperotziri irirori. Nishinewentari naaka nowejawte. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eenitatsi itsipa nowejate kaari saikatsine jaka. Ontzimatye namayetairi eejatzi. Aritake inkemisantaina irirori. Apaani inkantya impiyotaiya. Apaani inkantaiya kempoyagairine. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Retakotana naaka Ashitanari, iro nishinetantyaawori nañaamento onkene nañagai eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tekaatsi shintsineentenane, naaka shinetashitacha. Oshekitzimotana noshintsinka nishinetantari, iroowa nañaantaiyaari eejatzi. Iro ikowakaakenari Ashitanari nantero.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ikanta ikemaiyawakeroni Judá-ite jiroka ñaantsi, rapiitanakero itzimawentawakaanaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tzimatsi osheki kantanaintsiri: “¿Iitaka pikemisantantariri? Ikamaaritatzi, iroowa ishinkiwentantakari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Iro kantacha eenitatsi itsipa kantatsiri: “Tekaatsi kamaari materone inkenkithawaitero jiroka ñaantsi. ¿Kantachama kamaari raminakagairi mawityaakiri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Okanta okyaawontsitapai. Ari roimoshirenkaitziro tasorentsipanko janta Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ari risaikitakari Jesús tasorentsipankoki, ranashiwaitaga awisatapishitzira iitaitziro “Salomón-tapishi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ipiyowentapaakari Judá-ite, rosampitakeri: “¿Tsikapaiteka pipakairo pikompitakaashiretena? Eerokarika Cristo, janjaatya poñaayenawo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Rakanake Jesús ikantzi: “Nokamantzitakemira ketziroini, temaita pikemisantana. Okaatzi imatakaanari ishintsinka Ashitanari, ooñaawontawaitakero kameethaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Iro kantacha eerokapaini te pikemisantaiyini, te poshiyakaanta eerokame nowejate. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikaatzi oshiyakaantachari nowejate riyowaantetana, niyotzitari eejatzi naaka. Royaatana iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naakatake añaakaayetairine. Eero ipeyawaita, tekaatsi aapithatenarine. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ikaatzi rashitakaanari Ashitanari, tekaatsi aapithatenarine, iri matzirori rantaritzi anaakoperotantatsiri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Itsipashiretana Ashitanari, oshiyawaitakawo apaanime nonkantya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ikanta Judá-ite raawetanaka mapi ikowi rishemeeri, ");
INSERT INTO cpbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","iri kantacha Jesús, ikantanakeri: “Iro ishintsinka Ashitanari antakaanawori kameethayetatsiri piñaakoyetakenari eeroka. ¿Tzimatsima apaani piñaakeri pitsitokawentantenari?” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ari ikantaiyanakeni Judá-ite: “Te iro nishemyaawentemi kameethatatsiri, irootake nishemyaawentemiri pithainkatasorentsitakerira Pawa. Tekaatsi piimatsitya eeroka, atziri pini, poshiyakaantashiwaitaka Pawame pinatye.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ari ikantanake Jesús: “Jiroka osankenata Inintakaantaitanewo, Naaka kantatsi: ‘Pawaite pinaiyini eerokapaini.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ayotaiyironi Osankenarentsipero, eero okanta oipiyawaantetero. Iri Pawa jitakeri atziripaini ‘Pawaitera’ riyotakaayetairi riñaane. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Iitaka pikishimatantanari eerokapaini pikantaiyini nithainkatasorentsitake nokantake naaka Itomi Pawa? Naakaga rookotake, rotyaantakena nipoke kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eero nantzirome naaka rantziri Ashitanari, eero pikemisantaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Iro kantacha nantzitakawowa. Onkantawetya eero pikemisantana naaka, iro pinkemisante okaatzi nitasonkawentantayetake, iro piyoperotantyaari niwithagaari naaka Ashitanari, riwithagaana eejatzi irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ari ikowawetanaka raakaanterime eejatzi, iri kantacha Jesús rishiyapithatanakari. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Piyanaawo Jesús katonko ñaa Jordán. Ari risaikapai tsika romitsitsiyaatantzi pairani Juan-ni. ");
INSERT INTO cpbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Osheki atziri jatashitakeriri iñeeri Jesús. Ikantaiyini: “Ikantawetaka Juan-ni te ritasonkawentantzi irirori, iro kantacha okaatzi ikenkithatakotakeriri jirika atziri irooperori ini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Osheki kemisantanakeriri Jesús janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Eenitatsi apaani mantsiyari atziri jitachari Lázaro, Betania-satzi rini, ari onampitawori janta María eejatzi irento Marta. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Jiroka María, iritsiro Lázaro, irootake saitantakariri kasankari iitziki Awinkatharite opoña oshetantanaari oishi.) ");
INSERT INTO cpbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Okanta apite iritsiro Lázaro, okaimakaantakeri Jesús, okantake: “Pinkatharí, imantsiyatatziira pitsipaminthare.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ikanta ikemawake Jesús, ikantzi: “Jiroka mantsiyarentsi te owamaantzi, arira iñagaitero ishintsinka Pawa, ari iñagaitero eejatzi ishintsinka Itomi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ikantawetaka Jesús osheki retakotawo Marta, eejatzi irento, eejatzi Lázaro, ");
INSERT INTO cpbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ikemawetaka ikantaitakeri imantsiyatatzi, eekero risaikawaitanaatzi okaatzi apite kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Irojatzi ikantantanaariri riyotaanewo: “Jame apiyai Judea-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ari ikantaiyanakeni riyotaanewo: “Rabí, ikowaiyatziinira Judá-ite ritsitokemi. ¿Eejatzi pikowanai pipiyanai janta?” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ikantanake Jesús: “¿Tema osamani okanta kiteesheri okaatzi 12 hora? Ikaatzi anashitachari kiteesheriki, te rontziwawaita, tema iñaakeri kiteesheenkari jaka kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Iriima anashitachari tsireniriki, rontziwawaita, tema okoityaatya janta kiteesheenkari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Eekero ikantanakitzi Jesús: “Makoryaake atsipaminthare Lázaro, iro kantacha ontzimatye niyaate nowiriintairi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ari ikantaiyanakeni riyotaanewo: “Pinkathari, aamaa iro retsiyatakotai, tema rimakoryaatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Okaatzi ikantawetariri Jesús riyotaanewo rimakoryaatzi, roshiyakaatzi riyotaanewo iro ikenkithatakotzi Jesús makoryagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Irojatzi rooñaawontantanakawori, ikantanakeri: “Kamakera Lázaro. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Owanaa nokimoshiretake te nisaiki janta, tema iro pinkemisantaperotantyaari, jame aate amineri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ikanta Tomás iiyeetziri “Tsipari”, ikantanakeri ikaataiyinira: “Jame oyaatanakeri, aminawakero eero rowamagaitai aaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ikanta rareetzimatapaaka Jesús, ikemapaake tzimakotake Lázaro 4 kiteesheri ikitaitantakariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Te intainaperote Betania isaikira Jerusalén, ");
INSERT INTO cpbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","iroowa riyaatashitantakawori Judá-ite jiroka Marta eejatzi María, roimoshirenkantyaawori ikamakera iyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Okanta iyotake Marta iro rareetzimatya Jesús, jatanake itonkyotyaari. Iroowa saikanaintsiri María pankotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Okantawakeri Jesús Marta: “Pinkatharí, arime pisaikeme eeroka jaka, eero ikamime aarini. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Iro kantacha niyotzi naaka arika pinkowakoteri Pawa oita rantemiri, ari rimatakemiro.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ari rakanakero Jesús: “Aritake rañagai piyaariri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Okantzi Marta: “Niyotzi aritake impiriintai paata weyaantapaakyaawone kiteesheri impiriintantaiyaari kamayetatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ikantanakero Jesús: “Naakatake owiriintantatsiri, naakatake añaakaantantaneri. Tzimatsirika kemisantainane naaka, onkantawetya inkame, ari rañagai. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ikaatzi añaayetatsiri iroñaaka, ikaatzi kemisantainane, eero ikaamaneyetai. ¿Pikemisantziroma jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ari okantziri iroori: “Arima Pinkathari, nokemisantzimi naaka eerokatake Cristo Itomi Pawa, ikowakaakerira ripoke jaka kipatsiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ikaatakero Jesús ikantayetakero jiroka, jatanake Marta okaimiro irento María, okamantapaakero, okantziro: “Areetapaaka yotaantaneri, ikaimimi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Okanta okemawake María, katziyanaka, pokanake oñeeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tekera rareetyaata Jesús nampitsiki, irojatzi risaikake itonkyotawakarira Marta. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Okanta iñagaitakero María okatziyanaka ishiyanaka, jirikapaini Judá-ite ikaatzi tsipatakawori opankoki, roimoshirenkiro, royaataiyanakeroni roshiyakaatziiro iraawaitatyeeya kitataarewoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Okanta areetapaaka María risaikakera Jesús, otziwerowashitapaakari okantziri: “Pinkatharí, arime pisaikeme eeroka jaka, eero ikamime aari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ikantanakero Jesús, iñaakerowa María irayimotapaakari, ari ikantapaakari eejatzi Judá-ite oyaatapaakerori, antawoite rowashiretanaka, okatsitzimoshiretanakeri, ");
INSERT INTO cpbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","rosampitanakero: “¿Tsikajaantaka pikitatakerika?” Ari ikantaitanakeri: “Pipokeeta Pinkatharí, piñeeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ari riraapaakari irirori Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Irojatzi ikantantanakari Judá-ite: “¡Pamine antawoite retakotari!” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Iro kantacha tzimatsi itsipa kantanaintsiri: “Iriiwetaka jirika etsiyatakotakagairiri mawityaakiri, ¿kaari rantantawo eero ikamanta Lázaro?” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Apiitanaka Jesús okatsitzimoshiretanakeri, riyaatashitanakeri okaakiini kitataarewoki. Omoonaki ini, mapi rashitakotantaitakari. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ikantanake Jesús: “Potainkero mapi.” Ari okantanake Marta iritsiro kamaintsiri: “Pinkatharí, aama shitzitake, tema tzimake 4 kiteesheri ikamantakari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Rakanakero Jesús: “¿Tema nokantakemi, pinkemisantenarika, arira piñaakero ishintsinka Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Rotainkaitakero mapi. Aminanake Jesús inkiteki, ikantanake: “Ashitanari, niwethariimi eeroka, tema pikemana. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niyotzi ari pikantapiintatya pikemana. Iroowa nokantantari inkemantyaari jirikapaini atziri saikaintsiri jaka, iroowa inkemisantantyaari eerokatake otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Okanta okaatapaake ikenkithawaitakero jiroka, ikaimanakeri: “¡Lázaro, pishitowe!” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Shitowapai kaminkari, roosotakawo manthakintsi rakoki eejatzi iitziki, irojatzi iponawootakawo rankowitantaitawakariri ketziroini. Ikantanake Jesús: “Poosoryaakoteri, riyaataita.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iroowa ikemisantantanakari osheki Judá-ite ikaatzi jatanaintsiri itsipatawo María, ikaatzi ñaakerori rantakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Iro kantacha eenitatsi jatashitanakeriri Fariseo-paini. Ikamantapaakeri okaatzi rantakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ikanta Fariseo-paini itsipatakari reeware Imperatasorentsitaarewo, ipiyotakeri Itzinkamipaini, ikantaiyini: “¿Tsikama ankantyaaka? Jirika atziri osheki ritasonkawentantake. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Arika añaaminthatashitakyaari, arira inkemisantakaakeri maawoini. Ripokake reewarepaini Roma-satzi, itzimpookakaantakero tasorentsipanko, rithonkakaantakero anampipaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iri kantacha, jirika jitachari Caifás, reewaperore Imperatasorentsitaarewo, ikantanakeri irirori: “Te piyotaiyeni eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iri kameethatatsi ashinete apaani atziri inkamawentayetai, iro ompoñaantyaari eero rithonkaitantai anampiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Iri kantacha Caifás, Imperatasorentsiperori, riñaawaitakaanakeri Pawa. Okantawetaka te riyowetawo, iri Jesús ikenkithatakotake inkamawenteri isheninkapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te apatziro inkamawenteri isheninkapaini inkamawentzityaari maawoini itomipaini Pawa pookayetanaintsiri, ompoñaantyaari riwithaawakaantaiyaari inkaate rashitaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ari ikowaiyanakeni reeware Judá-ite rowamairi Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iro kaari ikowantanaa Jesús intsipatanaiyaari Judá-ite. Shitowanake Judea-ki, jatake ochempiki isaikira nampitsi jitachari Efraín. Ari risaikakaapairi riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Irootzimataatsi roimoshirenkairo Judá-ite Anonkoryagaantsi, osheki atziri jatatsiri Jerusalén-ki riwetsikashiretaiya. ");
INSERT INTO cpbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rithotyaakoitakeri Jesús, rosampitawakaiyani tasorentsipankoki: “¿Tsika pikantaiyinika eeroka? ¿Ari ripokake roimoshirenkaityaaga?” ");
INSERT INTO cpbNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ikanta Fariseo-paini itsipayetakari Imperatasorentsiperoriite, ikantantayetake: “Ikaatzi yotatsine tsika risaiki Jesús, inthawete, naakaanteriita.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iyotapaaka 6 kiteesheri roimoshirenkantaityaawori Anonkoryagaantsi, jatake Jesús Betania-ki, inampiki Lázaro rowiriintairi chapinkiranki. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ari roimoshirenkaitakeri Jesús. Iro Marta owiitantatsiri. Ari risaikitaka eejatzi Lázaro itsipatakari Jesús rowaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amakotake María kasankari. Osheki owinawo jiroka. Isaitantakari iitziki Jesús. Oshetantzimaitari oishi. Kasankainka maawoini okantaka pankotsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ikanta Judas Iscariote, riyotaanewo Jesús iri pithokashityaarine paata, ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Arikame ampimanterome jiroka kasankari, ari aakeme osheki koriki aneshironkatantyaariri ashironkainkari. ¿Kaari antantawo iroori?” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Te iro inkantantyaari Judas retakotatyaarira ashironkainkaripaini, ikowashita inkoshite. Iriira rowaitake rapatoteri koriki, ikoshitapiintzi eepichokiini. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ari ikantanake Jesús: “Piñaaminthatashityaawo, tema imotaitatyaanawo inkitaitakenaga paata. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iriima ashironkainkaripaini rashi rowaatyeero risaikimotemi, irooma naaka eero nokantaitatyaani nisaikimotemi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Osheki Judá-ite yotaintsiri ari risaiki Jesús janta Betania-ki. Jataiyakeni janta, te apatziro ramineri Jesús eejatzi Lázaro rowañagairi pairani Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iri kantacha Imperatasorentsiperoriite ikamantawakaayetaka ritsitokeri eejatzi Lázaro. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tema iri kantakaawori Lázaro kaari raapatziyaitantanaari Judá-ite ikemisantaitanakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Osheki atziri jataintsiri Jerusalén-ki roimoshirenkawo Anonkoryagaantsi. Okanta okiteeshetamanai, ikemaiyakeni ripokatye Jesús nampitsiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Richekaiyakeni oshiyawori tsiyaroshitenki. Jataiyini ritonkyotyaari, ikaimaiyini ikantzi: ¡Kaakitake Awinkatharite! Tasonkawentaarewo rini, Pinkathari aitziri otyaantakeriri. ¡Iri Awinkathariteperotaiyaari aakapaini Israel-iite! ");
INSERT INTO cpbNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ari iñaapaake Jesús ewonkeri burro, ikyaakaanakari, tema othawetakotzitakari Osankenarentsipero, ikantaitake: ");
INSERT INTO cpbNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sion-satoité, eero pithaawaiyini, Pokataike Piwinkatharite, Kyaakaapaakariri ewonkeri burro. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ketziroini, te ikemathatziro riyotaanewo jiroka. Iro kantacha rowenonkashitaawo pairani rowaneenkawo Jesús, aripaite riyotairo iriitake Jesús rosankenatakoitzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Atziripaini ikaatzi tsipatakariri pairani Jesús rowiriintairi Lázaro, ikenkithatakoyetairo okaatzi iñaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iro riyaatantanakari atziripaini ritonkyotyaari Jesús, tema ikemakotakeri rowañagairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iriima Fariseo-paini ikantawakaiyakani iriroripaini: “Piñaakero, eero otsinampairi. Pamineri, iro riyaatashiteri maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tzimatsi Grecia-thatoweri pokaintsiri itsipatakari atziripaini roimoshirenkaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ripokashitakeri Grecia-thatoweri jirika Felipe Betsaida-satzi, nampitsi saikatsiri Galilea-ki. Ikantapaakeri: “Pinkatharí, nokowi noñeeri Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jatanake Felipe, ikamantapaakeri Andrés. Apitekeroini riyaatanake, ikamantakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ikantanakeri Jesús: “Monkaatapaaka rowenonkashitantaiyaawori rowaneenkawo Itomi Atziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Apaani okithoki kaari ipankiitzi, ari ashi owaatyeero onkaate apakithowoini. Irooma arika ipathaakitanake ishookantanakyaari ipankiitakerowa, ari iñagaitairo onkithokitai. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ikaatzi etakowaitashitachari rantayetziro iñaamatashiyetari, ari impeyawaitashitaiya. Iriima manintanakerone rantashiwaitari jaka kipatsiki, ikamaitanaatyaawowa inkañaaneyetai. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ikaatzi kowatsiri noshiyakairi nimperatanewo, roshiyakotenawo naaka. Tsikarika nisaikai naaka, ari risaikitaiya eejatzi irirori nimperatanewo. Ikaatzi noshiyakagairi nimperatanewo naaka, iri Ashitanari kantakaawori impinkathaitantyaariri paata.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Antawoite okatsitzimoshiretakena iroñaaka! ¿Tsikama nonkanteka? ¿Nonkantema: ‘Ashitanari, petsinaryaakotaina?’ ¡Tema iro nipokantakari, nimonkaatairo! ");
INSERT INTO cpbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ashitanarí, poñaagantairo powaneenkawo.” Ikemaitatzi inkiteki, ikantaitzi: “Tema noñaagantzitakawo, iroñaaka napiitero.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Atziripaini piyotainchari ikaatzi kemawakerori, ikantaiyanakeni: “Ookathawontsi ini.” Ikantayetzi itsipa: “Riñaanatakeri maninkari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ari ikantanake Jesús: “Te apatziro naaka riñaanate, eerokapaini riñaawaiwentake. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Irootaintsi iñagaiteri rowasankeeteri okantakaantziro iyaariperonka isaawikisatzipaini, roitsinampaitairi eejatzi pinkathariwentantashitainchari. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iro kantacha arika rowatzikakoitakena jaka kipatsiki, aritake nonkaimashiretanairi maawoini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ari rooñaawontziro Jesús tsikarika onkantya arika rowamagaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ari rakaiyanakeni atziripaini: “Ayotaiyini okantziri Inintakaantaitanewo: ‘Kañaaneri rini Cristo.’ ¿Iitaka pikantantari ontzimatye rowatzikakoiteri Itomi Atziri? ¿Iitaka Itomi Atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Rakanake Jesús: “Eenitatsi risaikimotanaimi iitaitziri ‘Kiteesheenkari’, eepichokiini risaikanai. Poshiyakayero panashitatyeeme okiteesheenkatzira, iroowa ompoñaantyaari eero omapokantzimi oshiyawori tsireniri. Tema ikaatzi anashitachari otsirenikitzira, te iñiiro tsika inkene. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pinkemisantairi iitaitziri ‘Kiteesheenkari’ eeniro itsipatzimira, poshiyakotyaari irirori.” Ikaatanakero ikenkithawaitakero jiroka, shitowanake Jesús. Te roñaagantanaa. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ikantawetaka Jesús osheki ritasonkawentantake inampiki jirikapaini, te ikemisantaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ontzimatye imonkaatya rosankenatakeri Kamantantaneri Isaías-ní, kantatsiri: Pinkatharí, ¿Iitaka kemisanterone añaane? ¿Iitaka roñaagaitakeri ishintsinka Pinkathari? ");
INSERT INTO cpbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jiroka otsipa rosankenatakeri Isaías-ni, iro kaari ikemisantantaita, ikantake pairani: ");
INSERT INTO cpbNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Iri Pawa mawityaakitakaakeriri, Imasontzitakaayetakeri, Iro ompoñaantyaari eero ikowichaatanta Eero ikemathawaitanta. Iro ompoñaantyaari eero ripiyashitaana naaka nowawisaakotantaiyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iro riñaawaitantakawori jiroka Isaías-ni, tema inewiyatakityaawo rowaneenkawo Jesús, irootakera ikenkithatakotantakariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iro kantacha, osheki Judá-ite kemisantanairiri Jesús, ari ikantzitanakawo Itzinkamipaini. Iro kantzimaitacha te ithawetakota irirori, tema ithaawantatyaari Fariseo-paini eero rishinetanairi inkyaayetai rapatotapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ari okantzimaitaka. Iri ikowaperotake Fariseo-paini raapatziyaari, iriima Pawa, te. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ari riñaawaitanake shintsiini Jesús, ikantanake: “Tzimatsirika kemisantainane, te apaniro ikemisantana naaka, ikemisantzitakari otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ikaatzi okitaanari naaka, oshiyawaitakawo iriime rokityaame otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iro nipokantakari naaka, noshiyaari ‘Kiteesheenkari’, ompoñaantyaari noiteenkatakotairi isaawikisatzi. Eero risaikayetai otsirenikitzira inkaate kemisantainane. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Te iro nipokantyaari kipatsiki nowasanketante, tema nipokatzi nowawisaakotante. Iro kantacha ikaatzi kemayewetawori niñaane, temaita ikemisantzi, te naaka owasanketerine. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Inkaate manintenane, kaari kemisantairone niñaane, tzimatsi iita owasanketerine. Oshiyawaitakawo jiroka ñaantsipaini okaatzi niñaawaitakeri atzirime inatye, iro owasanketantatsine paata, ripiyathawaantetaitakenaga. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tema naaka te niñaawaitashiwaitya nonintakaanekiini. Ashitanari otyaantakenari, iriitake kantakenawori okaatzi nokantakeri, okaatzi niyotaantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Niyotzi naaka, okaatzi inintakaantziri Ashitanari iro kañaanetakaantatsiri. Ari okantari, okaatzi nokantakeri naaka, nithotyaatziiro ikantakenari Ashitanari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yotapaaka apaani kiteesheri roimoshirenkantaityaawori Anonkoryagaantsi. Riyotake Jesús monkaatzimatapaaka rookanawentantyaawori kipatsi, riyaatai intsipatapaiyaari Ipaapate. Antawoite retakoyetakari ikaatzi kemisantakeriri, ari ikantapiintatya retakotari irojatzi weyaantapaakyaawone. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ikanta risaiki rowaiyani, kamaarishiretanake Judas Iscariote, itomi Simón, pithokashityaarine Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Riyotake Jesús tema ipoñaatyaawo irirori Pawaki, ari riyaateri janta. Iriitake shintsitakaakeriri Ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ari ikatziyanaka risaikakera rowaiyani, raatonkoryaanakawo iwewiryaakowo, romathakitanakawo manthakintsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Raake ñaa risakero kiwaakomentotsiki. Ikiwayitzitakeri riyotaanewo, rosheyitzitantzimaitari manthakintsi romathakitakari. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iro inkiwayitzitantyaaririme Simón Pedro, ikantanake irirori: “Pinkatharí, ¿eerokama kiwayitzitenane naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ikantzi Jesús: “Te pikemathatziro okaatzi nantziri iroñaaka, iro kantacha paata, ari pinkemathatairo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ikantanake Pedro: “¡Eero nishinetzimaitzimi poshiyaari imperataarewo pinkiwayitzitena!” Rakanake Jesús: “Eerorika nokiwayitzitzimi, te paapatziyana.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ikantzi Simón Pedro: “¡Pinkatharí, eero pikiwayitzitana eepichokiini, maawoini pinkiwena nakoki eejatzi noitoki!” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ikantzi Jesús: “Ikaatzi eshitakerone ikaawoshita, apatziro ikowi inkiwayitzitya, tema kitetake maawoini. Ari kitetakemi eerokapaini, okantawetaka te maawoini pinkiteshiretaiyeni.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tema riyotakeri Jesús iita pithokashityaarine, iro ikantantari: “Te maawoini pinkiteshirete.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ari rithonkakero ikiwayitzitakerira, ikithaatanaawo Jesús iwewiryaakowo, saikanai tsika rowaiyani, ari ikantzi: “¿Pikemathatakeroma okaatzi nantakeri? ");
INSERT INTO cpbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pikantapiintaiyini eerokapaini ‘Yotaanarí, Pinkatharí.’ Imatatya pikantanari, tema naakatake. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naaka ‘Yotaantaneri’, naaka ‘Pinkathari.’ Iro kantacha, noshiyakotari imperataarewo, nokiwayitzitakemi, ari pinkantaiyaari eerokapaini pinkiwayitzitawakagaiya. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naaka yotaakemirori, poshiyakotenawo tsika nokantakemi naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Te ipinkathaitziri noshikaarewo ranairi imperatariri. Tekaatsi eejatzi otyaantaarewo anairine otyaantziriri. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Arika pinkemathatanairo jiroka irojatzi pantantaiyaawori, aritake pinkimoshiretai. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pinkeme nonkantemi, iro kantacha te maawoini niñaanatemi. Niyotziri naaka ikaatzi niyoshiitakeri. Arira imonkaatyaari Osankenarentsipero, kantatsiri: Eenitatsi akiyootakenari, iriitake pithokashitenane. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Arika imonkaatakya jiroka, iroowa pinkemisantaperotantenari ‘Naakatzitaka.’ Iro neewatantzimirori nokamantzimiro. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Inkaate kempiyaarine notyaantanewo, naakatake ikempiyaminthata. Inkaate kempiyenane naaka, ikempiyaminthatari otyaantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ikaatapaakero riñaawaitakero jiroka, antawoite okatsitzimoshiretanakeri Jesús. Eekero rooñaawontanakitziiro ikenkithatakotakeri, ikantzi: “Pikaatakera eerokapaini jaka, eenitatsi apaani pithokashitenane. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ari raminawakaanaka riyotaanewo, te riyotzi itzimi ikantziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ikanta apaani riyotaanewo, retakoperotanewo Jesús, shentakeriri okaakiini rowaiyani, ");
INSERT INTO cpbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","riñaanacheratakeri Simón Pedro, ikantziri: “Posampiteri itzimirika ikantziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ikanta jirika shentakeriri okaakiini, rosampitakeri: “Pinkatharí, ¿Itzimika?” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Rakanake Jesús: “Piñeena nashete eepichokiini pan, itzimirika nompakeri, iriitakera.” Rashetake eepichokiini pan, ipakeri Judas Iscariote, itomi Simón. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ikanta rowawakawo Judas pan. Kamaaritanake. Ikantziri Jesús: “Thaakyaapaini pantero pikenkithashiretapiintakari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ikaatzira rowaiyani tekaatsi kemathatawakerone oita ikantantariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tema jirika Judas iriitake kempoyiiriri koriki, roshiyakagaitzi riyaatatye ramanante roimoshirenkyaari ikantakeriri Jesús, roshiyakagaitzi eejatzi ramanantatye imperiri ashironkainkaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ikaatakero Judas rowakawo pan, jatanake. Tema tsirenitanake. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jatake Judas, ikantzi Jesús: “Monkaatapaaka rowenonkashitantaiyaawori rowaneenkawo Itomi Atziri. Ari iñagaitairo rowaneenkawo Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ari okanta, iriitake Pawa oñaaganterone iñagaitantyaawori rowaneenkawo. Iroñaakaga rantero. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Notomipaini, eepichokiini nisaikimotanaimi. Osheki pithotyaakowetaina eerokapaini, eeromaita piñagaana. Iro nokantzitakariri eejatzi asheninkapaini Judá-ite, iroowa napiitemiri nonkantemiro eerokapaini, eero pitsipatana tsika nisaikapai naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jiroka owakerari nonintakaantanewo: ‘Ontzimatye petakotawakagaiya.’ Poshiyena naaka netakotzimi, ari pinkantyaari eerokapaini, petakotawakagaiya. ");
INSERT INTO cpbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Arika petakotawakaanaiya eerokapaini, ari riyoitaimi maawoini eerokatake niyotaanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ikanta Simón Pedro rosampitanakeri Jesús: “Pinkatharí, ¿tsika piyaateka?” Rakanake Jesús, ikantzi: “Tsikarika niyaate naaka, eerowa pimatziro poyaatena eerokapaini, irooma paata aritake poyaatakena.” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ikantanake Pedro: “Pinkatharí, ¿iitaka eero noyaatantzimi iroñaaka? ¡Arira nishinewentakemi!” ");
INSERT INTO cpbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Rakanakeri Jesús, ikantziri: “¿Imaperotatya pishinewentena? Tekera riñeeta tyaapa, mawa papiitero pinkante: ‘Te niyotziri Jesús.’ Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Eero powashireshiryaawaitashita. Pawentaiyaari Pawa, pawentaina eejatzi naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Janta ipankoki Nopaapate eenitatsi osheki tsika anampitapaiyaawo. Eerome otzimi, eero nokantawaitzimime niyaatai niwetsikayetapaimi tsika pinampitapaiyaawo eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Arika niyaatai, niwetsikayetapaimirika tsika pisaikapai, ari nipiyashitaimi nagaatemi, pintsipatantapainari eerokapaini tsika nisaikai naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Piyotaiyironi eerokapaini awotsi riyaatantaitari tsika nisaikai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ari ikantanake Tomás: “Pinkatharí, te niyotaiyeni tsika piyaate. ¿Tsika nonkantyaaka niyotantyaawori awotsi?” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Rakanake Jesús, ikantanake: “Naakatake ‘Awotsi’, ‘Kyaaryooperotatsiri’, ‘Añaamentotsi.’ Apatzirowa impampithawokitaitena naaka, aritake rareetaitakya Ashitanariki. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arime piyoperotaiyenaneme, arira piyotairime eejatzi Nopaapate. Tema piyotzitakari iroñaaka, iriitakera piñaapiintakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ikantanake Felipe: “Pinkatharí, janjaatya poñaayenari Pipaapatetari, tekaatsi itsipa nonkoweri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ikantanake Jesús: “Felipe, osamanitake notsipayetakemi eeroka, ¿tekerama piyotenaata? Ikaatzi ñaakenari naaka, iñaakeri Nopaapate. ¿Iitaka pikantantari? ");
INSERT INTO cpbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tema pikemisantzi ari niwithaari Nopaapate, ari riwithaana irirori? Okaatzi niñaawaitziri, te naaka kowashiwaityaawone niñaawaitero. Iri Nopaapate withaashiretanari, iri antakaanawori rantawaitanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pinkemisante ari niwithaari Nopaapate, ari riwithaana irirori. Ikompitzimotzimirika jiroka, pinkemisantaatsikaitena nitasonkawentantayetake. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inkaate kemisantainane naaka, ari ritasonkawentantayetai eejatzi. Ari rimaperotanakero ritasonkawentante, anaanakero okaatzi iñaakoitakenari, tema iro niyaatzimatai naaka nontsipatapaiyaari Nopaapate. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Maawoini aakotainane nowairo naaka inkowakotaina ramanamanaataina, aritake nantakeniri. Iro ompoñaantyaari inthaamentaiyaari Nopaapate, okantakaantziro rantzimotantakeri Itomi. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Onkaate pinkowakotainari paakotaina nowairo naaka, ari nimatakemiro.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Arika pinintayetaina, aritake pinkemisantairo nonintakaantanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ari nonkowakotairi Nopaapate rotyaantemi itsipa Kaminaakowentantaneri, ");
INSERT INTO cpbNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tasorentsiperori rinatye, iriitake tsipashiretapiintaimine. Iriima isaawikisatzipaini eero risaikimotziri, te iñiiri, te riyotziri eejatzi. Irooma eerokapaini piyotaiyirini, tema risaikimotakemi, iri saikashiretantakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Eero poshiyakotari miritzi rookanawentaitziri, ari nipiyashitaimi. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Okaakitake, eero iñagaana isaawikisatzipaini. Irooma eerokapaini ari piñaayetaina, kañaaneri pinkantayetaiya, tema kañaaneri nini naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ari piyotai niwithaashiretari Nopaapate, eejatzi eerokapaini piwithaashiretana, ari nokantari naaka niwithaashiretzimi eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inkaate kemisantawaantetainane, roñaagantziro imaperotatya inintana. Iroowa retakotantaiyaariri Nopaapate, nimateri naaka netakotaiyaari, ari noñaagaiyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ikanta Judas (kaari Iscariote) rosampitanakeri: “Pinkatharí, ¿Iitaka eero poñaagantaari itsipapaini, apa poñaagaina naakapaini?” ");
INSERT INTO cpbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Rakanake Jesús: “Ikaatzi nintanari naaka, ikemisantawaantetana. Iro retakotantaariri Nopaapate. Ari notsipatari Nopaapate nontsipashiretaiyaari jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iriima kaari nintenane, ripiyathawaantetakena. Te naaka yotashiwaityaawone okaatzi nokantayetakemiri, ashitanari otyaantakenari, iri yotakaakenawori. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nokamantatziimiro maawoini jirokapaini eeniro nisaikimoyetzimi. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Iriima Tasorenkantsi, Kaminaakowentantaneri, rotyaantemiri Nopaapate poyaatenane, riyotakaapaakemiro maawoini, inkenkithashiretakaimiro okaatzi nokantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kameetha pisaikayetai. Te nonkenkithatakotashityaawo tsika ikanta risaikakaantzi isaawikisatzipaini. Naaka kantakaantzirori pisaikantaiyaari kameethaini. Eero powashirewaiyeta, eero pithaawawaitzi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tema pikemakena nokantake: ‘Iro niyaatai, irojatzi nipiyantaiyaari ari ankaatai asaikayetai.’ Arime pinintename, eerome powashirewaitame nookayetanaimi, ari pinkimoshirewentakename piyotake niyaatatye Nopaapateki, anaakenari iroñaaka natziritapaintzira. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nokamantzitatziimiro jiroka, pinkenkithashiretantyaawori paata, arika imonkaatapaakya. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eero nokenkithawaitakayitzimi, tema okaakitake pinkathariwetachari kipatsiki. Temaita ipinkathatana naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ari onkantyaari, iro riyotantyaari isaawikisatzipaini nonintziri naaka Nopaapate, nantziniri okaatzi inintakaanari irirori. Pinkatziyaiyeni. Thame aatai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Eekero ikantanakitzi Jesús: “Naaka oshiyawo oponkitzithapero pankirentsi. Iriima Nopaapate roshiyari pankitzirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Eerorika okithokitzi otewatha, richekathatziro ashitawori. Irooma kithokitatsiri, rowameethatewatziro, rowaankiityaakotziro onkene onkithokiperote. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kaankiityaakotaimi iroñaaka eerokapaini, okantakaakemi ñaantsipaini nokamantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Apaani otewatha pankirentsi tewaryagaintsiri eero okithokitai, tema ontzimatye ishooke oponkitziki. Ari okantari eejatzi eerorika poisokerotana, eerowa pantairo kameethari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naaka oshiyakawo oponkitzi pankirentsi, irooma eerokapaini poshiyaawo notewa pinayetzi. Ikaatzi oisokerotanari naaka ari nokantzitakariri irirori, oshiyawaitakawo osheki inkithokiperotaime. Eerorika pitsipashireyetana, tekaatsi kameethari pantairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ikaatzi kaari oisokerotenane naaka, ari nookakeri. Arira roshiyaiyaawo okamatewatzi pankirentsi, ragaitziro ritagaitero. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kisokerorika powayetaina, pinkyaaryoowentairorika okaatzi niyotaayetakemiri, pinkowakotairi Nopaapate oitarika pikowiri, aritake rimatakemiro. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arika pimatanairo roshiyakaawentaitakeri kithokiperotatsiri pankirentsi, aritake riyoitaimi imapero niyotaanetaimi. Iroowa impinkathaitantyaariri Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Antawoite netakoyetakemi, noshiyakari Ashitanari retakotana naaka. Pinintaawaityaawo netakoyetaimira. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eekerorika pinkemisantanakityeero nonintakaantanewo, ari pinintaawaitaiyaawo netakonka, poshiyaina naaka nokemisantawaantetziri Ashitanari nonintaawaitawo retakonka. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iro nokamantantzimirori jiroka onkene ankimoshiretaiyeni. Imapero iroowa pinkimoshirekitantaiyaari eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jiroka nonintakaantanewo: ‘Ontzimatye petakotawakaayetaiya, poshiyaina naaka netakoyetaimi eerokapaini.’ ");
INSERT INTO cpbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Inkaate shinewentyaarine raapatziyanewo, roñaagantatziiro retakokitanta. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Notsipaminthatanewo pinatzi eerokapaini, arika pantanairo nokantzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aritapaake noshiyakaimi nonoshikane, tema apaani noshikaarewo te riyotzi oita rantziri onampitariri. Noshiyakagaimi naapatziyanewo, tema nokamantaimiro maawoini ikamantanari Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Te eerokapaini yoshiitenane, tema naaka yoshiitaimiri eerokapaini. Naakatake otyaantayetemine piyaate tsikarika, poshiyakotaiyaawo pankirentsi kithokiperotatsiri, ari pinkantapiintanakityeeya. Iro ompoñaantyaari rimatakaayetaimiro Ashitanari oitarika pinkowakoteriri paakotainarika nowairo. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pinkeme nonkantemi: ‘Ontzimatye petakotawakaayetaiya.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Arika piñaayetakero inkisaneentanakemi isaawikisatzipaini, poshiretyaawo ari ikantaitakena naaka ikisaneentawaitaitakena. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Irojatzirikame poshiyakotyaari isaawikisatzipaini, ari retakoyetakemime ikantawakaaga irirori retakotawaka. Iro kantacha niyoyagaimi naaka, pitsipawetari isaawikisatzipaini, iro ikisaneentantanakemiri. Oshiyawaitakawo iroñaaka kaarime eeroka isaawikisatzipaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pinkenkithashiretero nokantzitakemiri: Te añi apaani noshikaarewo impinkathaiteri ranairi imperatariri. Ari inkantaitemi eerokapaini inkowaite ritsitokaitemi, ikantaitakenaga naaka. Ari okantari eejatzi ikaatzi kemisantawaantetanari naaka, aritake inkemisantaitakemi eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iro inkowaitantyaari ritsitokaitemi, naakatake tsitokakaantemine, okantakaantziro te riyotena iri Pawa otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eero otzimime iyenakaashitanewo, eero nipokime niyotaayetairi. Eeromaita okanta rookaakowentaiyaawo iyaariperonka. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ikaatzi kisaneentakenari naaka, ikisaneentzitakari eejatzi Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eero otzimime iyenakaashitanewo, eerome nitasonkawentzimoyetakeri iñaantakawori kaari iñaapiintzi. Okantawetaka iñaawetakawo jirokapaini, eekero ikisaneentanakityaana, ikisaneentzitakari eejatzi Ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ari okantzimaitaka, ontzimatye imonkaatya osankenarentsi, kantatsiri: Ikisaneentashiwaitakena. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Iriima Tasorenkantsi iriiperotatsiri, iitaitziri ‘Kaminaakowentantaneri’, rotyaantaimiri Ashitanari poyaatenane, iri yotakaapaakemirone maawoini, inkenkithashiretakaimiro okaatzi nokantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Arira pinkenkithatakoyetaina eerokapaini, tema pitsipayetzitakena ketziroini etantanakawori.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Iro nokantantzimirori jirokapaini, eero pontziwashirewentantana. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ari piñaayetakero eero rishineetaimiro pinkyaayetai ipiyotaitapiintaga. Ari piñaakero eejatzi ritsitokaitemi, roshiyakagairo rantatziiniri Pawa kameethatatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iro rantantawori jiroka, tema te riyotziri Ashitanari, te riyotana eejatzi naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Arika imonkaatakya jiroka, pinkenkithashiretakotero nokantayetakemiri. Iroowa netantawori nokamantzimiro ketziroini.” “Te nokamantzimiro ketziroini jiroka, tema irojatzi notsipayetzimi. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Iro kantacha jataana iroñaaka nontsipatapaiyaari otyaantakenari. Tekaatsimaita osampikowenterone tsikarika niyaatai, ");
INSERT INTO cpbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","apatziro powashiretaiyani pikemakenaga nokantakemiro jirokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pinkeme nonkamantemiro irooperori. Osheki onkameethatzimotemi niyaatai. Tema eerorika niyaatai, eero ripoki jitachari ‘Jokaakotantaneri’ intsipashiretantapiintaimiri. Irooma arika niyaatai, naakatake otyaantapairine. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Arika ripokake Tasorenkantsi, roñaagantapaakero ikenkithashirewaitashitari isaawikisatzipaini, tema ikenakaashiwaitakawo ikenkithashiretawo kaariperonkantsi, tsika okantakota kameethashiretaantsi, tsika okantakota yakowentaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ari riyotakaantairo kaariperonkantsi ini eerorika ikemisantaitana naaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ari riyotakaantairo kameethashirenkantsi, nimatziro naaka nowameethashiretantzi, tema niyaatairika Ashitanariki eero iñagaitaana. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ari riyotakaayetairi riyakowentakeri, iri pinkathariwentashiwaitakari isaawikisatzipaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Eenitatsi osheki nonkantemiri, iro kantacha tema anaanakemi nokantayetakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Arika ripokapaake iriiperori Tasorenkantsi, iri yotakaapaakemirone maawoini irooperori. Eero riñaawaitashiwaitawo ikowashiwaitari irirori, inkamantantairo ikemakeri. Ari riyotakagaimiro onkaate awisayetaatsine paata. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iri kemayetainane niñaawaitero, irojatzi rowaagayetaimiri eerokapaini, inantyaari riyoitairo nowaneenkawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tema okaatzi riyotanetari Ashitanari, irojatzi niyotanetari naaka. Irootake nokantantakari: ‘Iri kemayetainane niñaawaitero, irojatzi rowaagayetaimiro eerokapaini.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Eepichokitapaake eero piñagaana, iro osamaniwetakya ari piñagaina eejatzi. Tema niyaatatye naaka Ashitanariki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ikanta riyotaanewo rosampitawakaanaka: “¿Oita ikantakotziri? Ikantayetakai eepichokitapaake eero añaayetairi, iro osamaniwetakya ari añagairi eejatzi, tema riyaatatye Ashitaririki. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Iitaka ikantakotziri ‘eepichokitapaake?’ Te akemathatziro iitarika ikenkithatakotziri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Riyotanake Jesús ikowatzi rosampiteri riyotaanewo, ikantanakeri: “Nokantaiyakemini: ‘Eepichokitapaake, eero piñagaana, iro osamaniwetakya ari piñagaina eejatzi.’ ¿Irooma posampitawakaawentari? ");
INSERT INTO cpbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ari piñaayetairo piraawaitaiya, owashireki pinkantaiya, piñaaminthateri isaawikisatzipaini ikimoshiretaiyini. Onkantawetya powashirekitaiyani, ari piñagairo pinkimoshiretai. Imaperotatya. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Arika ontzimaanitzimate apaani tsinane, okemaatsiwaita. Iro kantacha arika intzimake eentsite, ompeyakotanairo iyatsinka okimoshirewentanakeri eenchaanikite. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ari okantari eejatzi, ontzimatye powashireneentawakya eerokapaini iroñaaka. Arika piñaawaina paata, osheki pinkimoshiretai, tekaatsi owashiretakagaimine. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Paata tekaatsi posampitainari naaka. Iri mataimirone Ashitanari oitarika pinkowakotenari paakotainarika nowairo. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tema pamanapiintayetari Ashitanari pikowakoyetziri oiyetarika, pikowakowaitashitakari. Irooma iroñaaka arika pinkowakoyetairi, paakotapiintaina nowairo naaka. Ari pinkantya pinkowakotapiintairi, ari rimatakemiro, irootake pinkimoshirekitantaiyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Noshiyakaawentatziimiro jirokapaini nokenkithatakotzimiri. Iro kantacha eepichokitapaake imonkaatantyaari eero noshiyakaawentaimiro, koñaawoini nonkenkithatakotaimiri Ashitairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Paata, ari piñaayetairo paakotaina nowairo pinkowakotairirika Ashitanari. Te naaka kowakowentaimine. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tema iri Ashitairi etakoyetaimi eerokapaini. Iro retakoyetantaimiri pinintayetaanaga naaka, pikemisantaana nopoñagaawowa Pawaki. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ashitairiki nishitowanake nipokantanakari jaka kipatsiki. Iroñaaka nookanawentairo kipatsi nipiyaatyeero Ashitairiki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ikantaiyanakeni riyotaanewo: “Koñaatake iroñaaka pikenkithawaitziri, te poshiyakaawentero. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Noñaayetakemi iroñaaka piyotziro maawoini tsikarika oiyeta, te okowa iita osampitemine piyotziro oitarika ikenkithashiretaitari. Iro nokemisantantari imapero pipoñaaka Pawaki.” ");
INSERT INTO cpbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ari rakanake Jesús, ikantzi: “¿Arima, kemisantaimima iroñaaka? ");
INSERT INTO cpbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Monkaatzimatapaaka. Iroñaaka piñaayetero apawopaini pipookayetai tsikarika, ari pookanawentanakena apaniroini. Temaita nisaike apaniroini itsipatana ashitanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nokamantakemiro maawoini jiroka piñaantyaawori kameetha pisaike pintsipatena naaka. Jaka isaawiki, osheki piñaayetero pinkemaatsiwaityaawo. Iro kantacha, pishintsishirete. Tema noitsinampaakero naaka isaawikisato.” ");
INSERT INTO cpbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ikanta rithonkakero riñaawaitakero jirokapaini, aminanake Jesús inkiteki, ikantanake: “Ashitanarí, monkaatapaaka. Pooñaawontero iroñaaka rowaneenkawo pitomi, roñaagantantyaawori pitomi eejatzi powaneenkawo eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Eeroka owakeri ipinkathariwentantakariri maawoini atziri, inkañaanetakaantyaariri ikaatzi pashitakaakariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Arika riyoitaimi apaniroini Pipawaperotzi eeroka, riyoitairi eejatzi Jesucristo potyaantakeri, ari inkañaanetakaayetairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nooñaawontakero powaneenkawo jaka kipatsiki, nithotyaakero pikantakenari nantero. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","¡Ashitanarí! Pishinetena nontsipataimi iroñaaka, ari ankaate añaayetairo owaneenkawo akantaga pairani tekera awetsikeroota kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jirikapaini piyoshiitairi pashitakaakenari, niyotaayetairi tsika piita eeroka. Eeroka ashitakariri ketziroini, ipoña pashitakagaanari naaka. Nokemisantakaayetairi piñaane. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ikenkithashireyeta iroñaaka, okaatzi niyotanetari naaka, eerokatake yotakaayetanawori. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Niyotaayetairi okaatzi piyotakaayetanari, ikemisantanakero jirikapaini. Ikenkithashiretanaa imapero nopoñaakawo pisaikira eeroka, ikemisantayetanai eerokatake otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naakatake kowakowentziriri jirikapaini. Te iri nonkowakowente nampitashiwaitawori kipatsiki, apa nokowakowentatziiri pashitakaanari. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maawoini nashitari naaka irijatzi pashitari eeroka. Ikaatzi pashitari eeroka irijatzi nashitari naaka. Tema iri ooñaawontakerori nowaneenkawo. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eero nisaikanai jaka isaawiki, niyaatai nonkaatapaimi eeroka, iriima jirikapaini eekero risaikanaatye. Ashitanarí Tasorentsi, pinkempoyaawenteri raakotapiintantemiri piwairo, riwithaawakaantyaari eejatzi, akemetaawakaga aaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Eenirowa notsipayetari jaka isaawiki, nokempoyaayetziri raakotapiintantakemiri piwairo. Te ipeyagaantawaita, apatziro ikantakaawo iitaitziri ‘Otomi peyashiwaitaantsi’, irojatzi imonkaatantyaari okenkithatakotakeri Osankenarentsipero. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Iroñaaka niyaatai pisaikinta eeroka. Iro nokantantawori jirokapaini eenirowa nisaikira isaawiki, roshiyantenari naaka inkimoshiretai kameetha jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Osheki ikisaneentaitanakeri niyotagairi piñaane, te roshiyanaari isaawikisatzipaini, roshiyaana naaka te isaawikisatzi ninatye. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Te nokowakotzimi paayetairi risaiki jaka isaawiki, apatziro pinkempoyaawentairi ikaariperotakaitzirikari. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nokanta naaka te isaawikisatzi nini, eejatzi jirikapaini te roshiyanaari isaawikisatzipaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pintasorentsishiretakagairi inkyaaryoowentantyaawori irooperori. Tema irooperori ini piñaanetari eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pikantakena naaka potyaantakena nisaikimoteri isaawikisatzipaini, ari nonkantzityaari naaka notyaanteri risaikimoteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Okowaperotatya iroñaaka nontasorentsishiretai nishinewentaiyaari jirikapaini, intasorentsishireperotantaiyaari eejatzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Te apatziro nonkowakowenteri jirikapaini, tema nokowakowentzitari inkaate kemisantainane arika inkenkithatakaayetairi jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Namanakotari maawoini jirikapaini riwithaawakaantyaari, apaani inkantanaiya riwithagaimi eeroka. Ashitanarí, oshiyawaityaawo awithaawakaiyani aaka, ari inkantaiyaari eejatzi riwithaawakaaperotaiya inkemisantantaiyaari isaawikisatzipaini, eeroka otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jiroka nowaneenkawo okaatzi poñaagakenari, irojatzi nimatairi naaka noñaagairi iriroripaini. Ompoñaantyaari riwithaawakaaperotantyaari, roshiyakotairo aaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tema piwithaashiretana eeroka, ari nonkantzityaari eejatzi naaka niwithaashiretaiyaari iriroripaini, riwithaawakaantaperotyaari. Iro inkenkithashiretantyaari isaawikisatzipaini eerokatake otyaantakena, antawoite petakoyetzitakari poshiyakaakenaga naaka, antawoite petakotakena. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ashitanarí, eerokatake ashitakaakenariri jirikapaini, nokowi intsipataina tsika nisaikai naaka, iñaantaiyaawori nowaneenkawo. Eeroka owaneenkatakaakenari, tema petakotakena ketziroini tekera iwetsikaata kipatsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ashitanarí tampatzikashireri, te riyotzimi isaawikisatzipaini. Iro kantacha naaka niyotzimi, eejatzi ikanta jirikapaini riyotzi eeroka otyaantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Niyotagairi tsika piita eeroka, eekero niyaatakaatyeero niyotagairi, notsipashiretaari, netakoyetaari pikemetaakena naaka petakotakena.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ari rithonkanakero ikantayetakero jiroka, shitowanake Jesús itsipatanaari riyotaanewo riyaatero intatsikeronta pareenkariki iitaitziro “Cedrón.” Ari otzimiri pankirentsimashi, tsika risaikapaake Jesús itsipayetakari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iñiitawo eejatzi jirika Judas pithokashitantachari, ari risaikakaapiintziri Jesús riyotaanewo janta. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Areetapaaka Judas itsipatakari owayeriite, itsipatakari kempoyaantaneri rotyaantanewo reeware Imperatasorentsitaarewo, rotyaantanewo eejatzi Fariseo-paini. Rotaiyayetakero ripasamento, ramake eejatzi rootamento. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Riyotzitakawo ketziroini Jesús oita awishimoterine, rishitowashitanakeri, rosampitawakeri: “¿Iitaka pithotyaakotziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ikantaiyini jirikapaini: “Nithotyaakotatziiri Jesús Nazaret-satzi.” Rakanake Jesús: “Naakatake.” Jirika Judas pithokashitakariri, ari itsipayetakari jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Riñaawaitanakera Jesús, piyaponthoiyanakani, tyagaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Rapiitanakeri Jesús, rosampitziri: “¿Iitaka pithotyaakotziri?” Rapiitanakero iriroripaini, ikantzi: “Nithotyaakotatziiri Jesús Nazaret-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ari rapiitanakeri Jesús, ikantziri: “Nokantakemi naakatake. Naakarika pithotyaakotzi, potyaantairi jirikapaini notsipayetakari, riyaataita.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ari imonkaatari ikantzitakari ketziroini Jesús: “Ashitanarí, te ipeyagaantawaita apaani pashitakaakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ikanta Simón Pedro, eenitatsi irirori rosataamento, inowikyaanakero, rithatzinkitakeri rakoperokempita jitachari Malco, inoshikanewo Imperatasorentsiperori. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ikanta Jesús riñaanatanakeri Pedro, ikantziri: “Poyaagairo posataamento. Iri shinetakenari Ashitanari nonkemaatsiwaityaawo jiroka, ¿eeroma okanta nimonkaateniri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ikanta owayeripaini itsipatakari reeware, eejatzi reeware kempoyaawentantaneri rotyaantanewo Judá-ite, rotaiyanakeri Jesús, roosotanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Retapaintawo ikenakaanakeri ipankoki Anás. Iriitake rikonkiri Caifás Imperatasorentsiperotatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jirika Caifás iriitake kantakeriri pairani Judá-ite: “Iro kameethatatsi ashinete apaani atziri inkamimowentai.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ikanta Simón Pedro itsipatakari itsipa riyotaanewo Jesús, royaatakowentakeri Jesús. Jirika itsipa yotaarewo, iñaapiintanewo rini Imperatasorentsiperori, irootake ikyaantapaakari royaatakowentakerira Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Iriima Pedro ikatziyapaaka jantakeronta otantotsiki. Jirika yotaarewo iñaapiintanewo rini Imperatasorentsiperori, ikenkithawaitakaakero kempoyiirori ashitakomentotsi, omonkyaakeri eejatzi Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Okanta kempoyiirori ashitakomentotsi, osampitakeri Pedro: “¿Kaarima eeroka riyotaanewo jirika atziri?” Rakanake Pedro, ikantziro: “Tera naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tema okatsinkaityaatzi, jirikapaini noshikaarewo itsipayetakari kempoyaawentantaneri, rowaampataiyakeni paampari. Ari risaiki rakitsitaiyani. Ari itsipatakari eejatzi Pedro jirikapaini rakitsitaiyani paampari. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ikanta Imperatasorentsiperori retanakari Jesús rosampikowentziri riyotaanepaini, eejatzi okaatzi riyotaantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ari ikantanake Jesús: “Nokenkithatakaapiintakeri maawoini atziripaini. Niyotaantapiintake ipiyotaitapiinta eejatzi janta tasorentsipankoki, tsika rapatotapiintaiyani maawoini Judá-ite. Te nimanakaawo okaatzi nokenkithayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Iitaka posampitantanari naaka? Posampiteri ikaatzi kemayetakenari. Iriitake yotzirori okaatzi nokantayetakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ikantakero Jesús jiroka, apaani kempoyaawentantaneri ripasawootanakeri, ikantziri: “¿Arima pinkantya pakeri Imperatasorentsiperori?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Rakanakeri Jesús, ikantanakeri: “Eenitatsirika kaariperori niñaawaitakeri, pinkantenawo tsika otzimi. Okaatzi niñaawaitakeri kameetha ini. ¿Iitaka pipasawootantanari?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ikanta Anás rotyaantakeri janta Caifás-ki Imperatasorentsiperotatsiri, roosotaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Irojatzi ikatziyaka Pedro rakitsiwaita paampariki. Ari rosampiitakeri: “¿Kaarima eeroka riyotaanewo jirika atziri?” Ari roipiyanakero ñaantsi Pedro, ikantanake: “Tera naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Okanta osamaniityaake rosampitairi eejatzi inoshikanewo Imperatasorentsiperori, iri sheninkathoritariri ritotzitakeri inkaaganki Pedro ikempita, ikantziri: “¿Kaarima eeroka noñaake itsipatzimi janta pankirentsimashiki?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ari rapiitanakero Pedro roipiyañaanetantzi, ari riñaanake tyaapa. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tema kiteeshetzimatake, romishitowaitanairi Jesús ipankoki Caifás, ragaitanakeri risaikinta Pilato reewarite Roma-satzi. Te ikyagaiyapaakeni Judá-ite ipankoki Pilato, tema arika inkyaapankotakeri ripiyathatakawo Inintakaantaitanewo ikitewathatantaitari, eero okantzi roimoshirenkero kiteesheri Anonkoryagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iro rishitowantapaakari Pilato, ikenkithawaitakairi, ikantziri: “¿Iitaka rantakeri jirika atziri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ikantaiyini irirori: “Eerome ikaariperotzime jirika, eero namirime jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ari ikantanake Pilato: “Paanairi eerokapaini, powasanketeri tsika okantzi Inintakaantaitzimiri.” Ikantaiyanakeni Judá-ite: “Te pishinetapiintaiyenani nitsitokeri nosheninkaite.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ari imonkaatakari ikantakeri ketziroini Jesús tsika onkantya rowamagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Irojatzi ripiyantanakari Pilato ikyaapaintzi inthomoi ipankoki, ikaimapaakeri Jesús, rosampitakeri: “¿Eerokatakema Iwinkatharite Judá-ite?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ari ikantzi Jesús: “¿Piyotashitawoma jiroka posampitanari? Aamaaka tzimatsi kantakemiri noitaga naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Rakanake Pilato: “¿Naakama Judá-ite? Iriira pisheninkaite amakemiri jaka itsipatakari reeware Imperatasorentsitaarewo. ¿Iitaka pantakeri?” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ari rakanake Jesús: “Te nopinkathariwentantzi naaka jaka isaawiki. Ari onkantyaame, ari piñaakeme osheki nowayerite kisawentenane, eero raakaantantana Judá-ite. Iro kantacha te ari nompinkathariwentante jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Rapiitanakeri Pilato rosampitanakeri: “¿Arima, eerokatakema Pinkathari?” Ari rakanake Jesús: “Eerokatake kantaintsiri. Iro notzimantakari, iro nipokantakari jaka kipatsiki nonkenkithatakotairo irooperori. Tema ikaatzi kamaitanaawori irooperori, ikemisantawaantetana.” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ari ikantzi Pilato: “Irojatzitaweetacha, irooperori.” Ikantanakera, shitowanake ipiyotaiyakanira Judá-ite, ikantapairi: “Te noñiiro oita inkenakaashityaari jirika atziri. ");
INSERT INTO cpbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Poimoshirenkapiintziro Anonkoryagaantsi, pametapiintawo nomishitowi apaani raakaantaitziri. ¿Nomishitowakaantairima iitaitziri ‘Piwinkatharite?’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ari ikaimaiyanakeni maawoini, ikantaiyini: “¡Eero pomishitowiri jirika! ¡Iri pomishitowe Barrabás!” Jirika Barrabás, koshintzi rini. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ikanta Pilato ripasatakaantakeri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ikanta owayeripaini rimpitatake kitocheetapo roshiyakaakero amanthairentsi, ramanthaitakaakeri Jesús. Ikithaatakaakari anashirikimawotatsiri kithaarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ipiyowentapaari, ishirontawentawaitari ikantaiyirini: “¡Jirikaga Iwinkatharite Judá-ite!” Ripasawootzimaitari. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eejatzi rishitowapai Pilato, ikantapairi Judá-ite: “Pamine, jirika nomishitowakeri te noñi oita inkenakaashityaari.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Rishitowakaapaakeri Jesús ramanthaitakagaitakeri kitocheetapo iitoki, ikithaataitakeri anashirikimawotatsiri kithaarentsi. Ikantzi Pilato: “¡Jirika atziri!” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ikanta iñaawakeri reeware Imperatasorentsitaarewo eejatzi kempoyaantaneripaini, ikaimaiyanakeni, ikantaiyini: “¡Pinkentakotakaanteri! ¡Pinkentakotakaanteri!” Irojatzi ikantantari Pilato: “Jirika paanairi eeroka pinkentakoteri, te noñi naaka oita inkenakaashityaari jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Rakaiyanakeni Judá-ite: “Eenitatsi Inintakaantaitanari naakapaini, ontzimatye rowamagaiteri jirika, tema roshiyakaantashiwaitaka Itomi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ikemawake Pilato ikantaiyakeni roshiyakaantaka Itomi Pawa rini, osheki ithaawanake. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eejatzi ripiyanaa inthomoiki ipankoki, rosampitapaakeri Jesús: “¿Tsikama pipoñaaka eeroka?” Te raki Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ikantanake Pilato: “¿Tema pakana? ¿Tema piyote pinkathariperori nini naaka, ari imatakya nonkentakotakaantemi, ari onkantakya eejatzi nomishitowakaantaimi?” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Rakanake Jesús, ikantzi: “Eero pipinkathariwentaatsikaitzime eero ikowakaimirome Jenokisatzi. Iro nokantantari naaka, iri maperotainchari ikaariperotake amakenari jaka, anaanakero piyaariperonka eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ari rithotyaakowetanakawo Pilato romishitowakaantairime Jesús, iro kantacha eekero ikaimaiyatziini Judá-ite ikantaiyini: “¡Arika pomishitowakaantairi jirika, te paapatziyari piwinkathaperorite César! ¡Tema tzimatsirika oshiyakyaarine jirika, roshiyakaantashiwaitaka pinkatharime rinatye, ikisaneentaitatziiri César!” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ikanta ikemawake Pilato, ramakaantairi Jesús, ragaitanakeri ipiyotaiyakanira, roisaikapaakeri raminakoitapiintzirira yakowentaarewo, iitaitziro “Mapipankaari”, iro iitaitziri eejatzi Heber-thatoki “Gabata.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ari riwetsikawentaiyakawoni Anonkoryagaantsi roimoshirenkantaityaawori, tampatzikatapaake ooryaa. Ikantziri Pilato jirikapaini Judá-ite: “¡Jirika Piwinkatharite!” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ikaimaiyanakeni jirikapaini, ikantzi: “¡Inkame! ¡Inkame! ¡Pinkentakotakaanteri!” Ikantanai Pilato: “¿Kantachama nonkentakotakaanteri piwinkatharite?” Rakaiyanakeni reeware Imperatasorentsitaarewo, ikantaiyini: “¡Apatziro César nowinkatharitetari, tekaatsi itsipa!” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ikanta Pilato, romishitowanakeri inkentakotakaanteri. Raanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ikanta Jesús inatanakero inkentakoitantyaariri, jatanake janta iitaitziri “Atziriitoni”, irojatzi iitaitziri Heber-thatoki “Gólgota.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ari ikentakoitakeri, itsipatagaitakeri apite atziri, apaani rowatzikakoitake rakoperoki, rowatzikakoitakeri itsipa rampateki. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ikanta Pilato rontarekakotakaantake osankenarentsi opoñaantari ikentakoitziri Jesús, kantatsiri: “JESÚS NAZARETSATZI, IWINKATHARITE JUDÁITE.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Osheki Judá-ite ñaanatakerori jiroka osankenarentsi, te intainaperote nampitsi ikentakoitakerinta Jesús. Rosankenaitakero jiroka osankenarentsi Heber-thatoki, Grecia-thatoki, eejatzi Latín-thatoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iro ikantantakari reeware Imperatasorentsitaarewo, ikantziri Pilato: “Eero posankenatziro: ‘Iwinkatharite Judá-ite.’ Onkantatyeeme: ‘Oshiyakaantashiwaitachari iwinkatharite Judá-ite.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Iri kantacha Pilato, ikantanakeri: “Okaatzi nosankenatakeri, ari ashi owatyeero osankenatakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ikanta owayeripaini ikentakotakerira Jesús, rayitanakeri imanthaki, ritotakero 4-kota ipawakaiyakawoni apaanipaini. Rayitzitakeri eejatzi iithaare, te owawimawota iroori, apamawo okanta rontyagaitakero. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ari ikantawakaiyani owayeripaini: “Eero athatyaawaitziro jiroka, apatziro añaaryaawentyaawo, ari añeero iita ayerone.” Ari imonkaatari Osankenarentsipero, kantatsiri: Ipawakaayetakawo nomanthaki. Iñaaryaawentakawo noithaare. Irootake rantaiyakerini owayeripaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Okanta janta ikentakoitakerira Jesús ari isaikitakari inaanate otsipatakawo irento, María iina Cleofas, eejatzi María Magdala-sato. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ikanta Jesús iñaakero inaanate, otsipatakari riyotaanewo retakoperotane, ikantanakero inaanate: “Tsinané, iriitake pintomintaiyaari jirika.” ");
INSERT INTO cpbNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ikantanakeri riyotaanewo eejatzi: “Iro pinaanatetaiyaari jiroka.” Aripaite isaikapankotanakeri jirika riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Okanta awisayetake jiroka, yotake Jesús rimonkaatakerowa maawoini, ikaimanake: “¡Nomerewé!” Ari imonkaatari okenkithatakotakeriri Osankenarentsipero. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ari owakotakari kepishaari janta chomoki. Ragaitanake manthakintsi, rankowitantaitakawo inchatewa, romitsitsiyaatakero kepishaariki, rowaankakoitakeniri ipaanteki Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ratsimiyawakero Jesús jiroka kepishaari, ikantanake: “Thotyaapaaka maawoini.” Ari ithamenkotanaka, jatashirenkatanake. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ari imonkaatapaaka riwetsikawentapiintantaitawori kiteesheri rimakoryaantaitari. Iro kaari ikowanta Judá-ite inkatziyakote ikentakoitakeri kiteesheriki rimakoryaantaitari, tema jiroka kiteesheri iro ipinkathaperoitziri. Iro ikantantakariri Pilato intzinkaaporitakaanteri kentakotaarewo inkamantyaari intsipaite, rowatzikaryaakotairiita eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ikanta riyaataiyanakeni owayeripaini, itzinkaaporitapaakeri itsipatakari Jesús ikentakoitziri, eejatzi itsipa. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ari ripithokashiwetanakari Jesús, iñaatziiri kamake. Iro kaari itzinkaaporitantari irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ikanta apaani owayeri rosataamerekitantanakari rosataamento, ari iyowanake riraa otsipatanakawo ñaa. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kenkithatzirori jiroka, iriitake ñaakerori. Imaperotatya ikamantzimiri, pinkemisantayetai eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Awisantakari jirokapaini imonkaatatya okantzitakari Osankenarentsipero: Eero itzinkayiwaitaitziri apaani itonki irirori. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Okantzitaka eejatzi Osankenarentsipero: Ari raminakoitakeri rosataamerekitaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Okanta okaatapaake jiroka, José Arimatea-satzi, ikowakotairi Pilato, ikantziri: “Pishinetenari naanairi Jesús.” Jirika José irijatzi kemisantakeriri Jesús, rimananekiini ikemisantzi ithaawantari Judá-ite. Ikanta Pilato rishinetakeniri. Jatake José, raanairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ari ripokapaake eejatzi Nicodemo, jatashitakeriri pairani Jesús tsireniriki, ramakotapaake rowaitaitziri kasankari, osheki otenanka jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ikanta José itsipatakari Nicodemo raanairi Jesús, iponatantakari manthakintsi rashetantakawo kasankari. Iro rametari Judá-ite arika inkitateri kaminkari. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Janta tsika ikentakoitakeri Jesús, tzimatsi pankirentsimashi, ari isaikiri owakerari omoona tsika ikitaitziri kaminkari, tekera ikitatantaitawoota. ");
INSERT INTO cpbNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ari rowaitakeri Jesús, tema okaakiini isaiki jiroka omoonaki, irootzimatake areetya kiteesheri rimakoryaantapiintari Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Okanta awisanake kiteesheri rimakoryaantaitari, ananinkanake María Magdala-sato iyaate omoonakiki rowaitakerira Jesús. Oñaapaatziiro itainkake mapi rashitantaitakawori omoonaki. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Piyanaka iroori ishiyaperotanakitya, iyaatashiteri Simón Pedro itsipatakari itsipa yotaarewo, retakoperotanewo Jesús, okantapaakeri: “¡Ragaitakeri Awinkatharite, te ayote tsikarika rowaitairi!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ikanta Simón Pedro itsipatakari itsipa riyotaanewo Jesús, jatanake kitataarewoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Rishiyanakitya apitekeroini. Rishiyaperotanakitya itsipa rookanakeri Pedro, iri etapaakawo rareetaka kitataarewoki. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Inetapitapaake omoonakiki, iñaapaakitziiro omaryaamawotaka iponataitantakariri, temaita ikyaapaake inthomoiki. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Areetapaaka Simón Pedro, ikyaapaake inthomoiki, iñaapaakero irirori omaryaamawotaka iponaitantakariri. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iñiitapaakawo manthakintsi iponataitantakariri iitoki, inashita rowaitanakero te otsipatawo iponaitantakariri, kameetha ichonaankanake. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ikyaapaake eejatzi itsipa yotaarewo etawetakawori rareeta kitataarewoki. Iñaapaakero okaatzi awisaintsiri, ari opoña ikemisantaperotanake. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Te ikemathatziro okantziri Osankenarentsipero, aritake rañagai Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Irojatzi ripiyantanakari ipankoki jirika apite yotaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ari isaiki María omookeroki iraawaita. Okanta iraawaitaka, onetapitzi inthomoiki omoonakiki, ");
INSERT INTO cpbNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oñaatziiri apite maninkari okitamaakitake iithaare, risaikake tsika romaryaawetaitakarira Jesús. Apaani risaikake iitowetakaga, risaikake itsipa iitziwetakaga. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ikanta maninkariite, rosampitakero ikantziro: “Tsinané, ¿iitaka piraantari?” Akanakeri iroori, okantzi: “Rayitaitakenari Nowinkatharite, te niyotzi tsika rowaitakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ari ipithokanaka, oñaatziiri Jesús, temaita iyotawairi. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Rosampitanakero Jesús, ikantziro: “¿Iitaka piraantari tsinané? ¿Iitaka pithotyaakotziri?” Oshiyakaatzi iroori iri ñaanatziro aminirori pankirentsi, okantanakeri: “Pinkatharí, eerokarika aakeri, pinkamantena tsika powakeri, niyaateeta naminairi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Riñaanatanakero Jesús, ikantziro: “¡María!” Ari aminanakeri iroori, okantzi: “¡Raboní!” (iro ikantaitziri Heber-thatoki “Yotaantanerí.”) ");
INSERT INTO cpbNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ikantziro Jesús: “Papankaina, tema tekera niyaatziita nontsipatapaiyaari Ashitanari. Piyaate pinkamanteri iyekiite, iro niyaatai nontsipatapaiyaari Ashitanari tsika itzimi Ashitzimiri eejatzi eerokapaini. Iri Nowawanetari naaka, irijatzi Piwawanetzitari eerokapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Okanta iyaatanake María Magdala-sato, okamantapaakeri maawoini iyotaarewo oñagairi Awinkatharite, okamantapaakeri eejatzi okaatzi ikantawakerori. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Okanta otsirenitanake awisanake rimakoryaantaitari kiteesheri, piyotaiyakani riyotaanewo rashitakotaiyakani shintsiini ithaawantari Judá-ite. Ari ikyaapaake Jesús, ikatziyimotapaakari, riwethatapaari ikantapairi: “¡Pisaikayetai kameetha eerokapaini!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ikanta riwethatapaakari, roñaagapairi rako, eejatzi imereki. Kimoshiretaiyanakeni jirikapaini iñaawairira Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Rapiitanakeri Jesús, ikantziri: “¡Pisaikayetai kameetha eerokapaini! Rotyaantakena naaka Ashitanari, ari nonkantemiri eejatzi eerokapaini notyaantayetaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ritasonkakeri riyotaanewopaini, ikantziri: “Risaikashiretantaimi Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inkaate pimpeyakotairi eeroka jaka, ari ipeyakoitairi janta. Iriima kaari pimpeyakoyetai eeroka jaka, te ipeyakoitairi eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ikanta Tomás kaatatsiri 12 yotaarewo, iitaitziri eejatzi “Tsipari”, te risaiki irirori rareetantapaakari Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ikanta itsipapaini yotaarewo ikamantairi, ikantziri: “Noñagairi Awinkatharite.” Rakanake Tomás, ikantzi: “Eerorika noñagairi tsika ikentawakoitakeri, eerorika nokyaantawakotari rakoki, eerorika nokyaantamerekitari eejatzi, eero nokemisantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Okanta awisanake 8 kiteesheri, rapiitairo yotaarewo ipiyotaiyani. Ari risaikitakari eejatzi Tomás irirori. Rashitakoiyakani kameetha, iri kantacha Jesús kyaapaake, ikatziyimotapaari, riwethatapaari ikantapairi: “¡Kameetha pisaikaiyini eerokapaini!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ikantapaakeri Tomás: “Jiroka nako, pinkyaantawakotena, pinkyaantamerekitena eejatzi. Eero pikisoshirewaitzi, ¡Pinkemisante!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Rakanake Tomás, ikantanake: “¡Nowinkatharité, Nowawané!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ikantzi Jesús: “Iro pikemisantamatsitantanakari piñaakenaga. ¡Kimoshirera inkantaiya inkaate kemisantainane kaari ñaanari!” ");
INSERT INTO cpbNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Osheki rapiipiintakero Jesús ritasonkawentzimoyetanairi riyotaanewoite, te osankenatakoyeta jaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Iroowa osankenayetantakari jirokapaini pinkemisantantayetyaari, jirika Jesús iriitake Cristo, Itomi Pawa. Arika paakotapiintanairi iwairo pinkemisantanairi, aritake inkañaanetakaayetaimi. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Okanta okaatapaake jiroka, rapiitakero Jesús roñaagari riyotaanewo, inkaarecheraki iitaitziri Tiberias. Jiroka okantaka. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ari itsipatawakagaiyani risaiki Simón Pedro, Tomás, iitaitziri “Tsipari”, Natanael, poñaachari Caná-ki saikatsiri Galilea-ki, itomipaini Zebedeo, eejatzi apite itsipa yotaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ari ikantanake Simón Pedro: “Niyaatatye nontarajaate.” Ikantaiyini itsipa: “Ari ankaatanake.” Jataiyanakeni, otetaiyapaakani pitotsiki. Tekaatsimaita raye itarajaawetaka tsireniriki. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Okanta okiteeshetzimatake, katziyapaaka Jesús omapipookitzira inkaare. Te riyotawairi riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ikaimotapaakeri, ikantziri: “Mainariité, ¿Te payi?” Rakaiyanakeni iriroripaini: “¡Tetaawé!” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ikantzi Jesús: “Powiinkero pakoperoki pitarajaamento, ari paake.” Rowiinkakero tsika ikantaitakeri. Raake osheki shima, te raawyagairo inoshikairo itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ikanta yotaarewo retakoperotanewo Jesús, ikantanakeri Pedro: “¡Iriitake Awinkatharite jirinta!” Ikemawake Simón Pedro, tema raatonkoryaawetakitya iithaare, ikithaatanaawo, rimitaakaanakero inkaareki. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iriima itsipapaini yotaarewo pitotsiki ikenakoyetanai inoshikakotairi ishimane, irojatzi raatakotantapaari omapipookitzira. Tema risaikakotakitzi niyankyeeronkaini. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ikanta rayiitaiyapaakeni, iñaapaakitzi oisaka paampari, ari ritashitakari shima, itsipataitakeri pan. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ari ikantzi Jesús: “Pamake shima owakera paakeri.” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ikanta Simón Pedro, roosoryaakotakeri ishimane, inoshikakotakeri irojatzi omapipookitakera. Antaripaini ikanta shima, ikaatzi 153. Temaita isagayi itarajaamento. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ikantzi Jesús: “Jame oya.” Tekaatsi apaani yotaarewo osampiterine iitakarika, tema riyoperotaiyakerini iriitake Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Raakero Jesús pan, ipayetakeri apawopaini, ari ikantakeri eejatzi shima. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Irootake mawatanaintsiri roñaagari Jesús riyotaanewoite rañagaira. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Rithonkanakero rowaiyani, rosampitanakeri Jesús jirika Simón Pedro, ikantziri: “Simón, itomi Jonás, ¿Pinintaperotanama eeroka?” Ikantzi Pedro: “Piyotzi eeroka Pinkathari, naapatziyimi.” Ikantzi Jesús: “Pinkempoyagainari noshiyakayiri nowejate.” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rapiitakeri rosampitziri: “Simón, itomi Jonás, ¿pinintanama?” Ikantzi Pedro: “Piyotzi eeroka naapatziyimi.” Ikantzi Jesús: “Pinkempoyagainari noshiyakayiri nowejate.” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iro mawatatsiri rosampitziri, ikantziri: “Simón, itomi Jonás, ¿pinintanama?” Ari rowashiretanaka Pedro, tema mawa rosampiminthatakeri, ari rakake: “Pinkatharí, eerokatake yotzirori maawoini, piyotzi eeroka nonintzimi.” Ikantzi Jesús: “Pinkempoyagainari noshiyakayiri nowejate. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tema eeniro pimainaritzi, pikithaata pikenayetantari tsika pinintakaawo. Irooma arika pantarikitapaake, apatziro powaankawakotaiya, itsipa kithaataimine, raayetaimi tsika te pikowawetawo piyaate. Imaperotatya.” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ikantantakawori Jesús jiroka, ikowatzi inkemathaitero eero ikamita Pedro irojatzi rantyashiparikitantakya, iroowa impinkathaitantyaariri Pawa. Ikanta Jesús ikantanakeri Pedro: “¡Poyaatena!” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ikanta ripithokanaka Pedro, iñaatzi royaatakeri retakoperotanewo Jesús, iri shentakeriri Jesús rowaiyani pairani, osampitakeriri, ikantziri pairani: “¿Pinkatharí, iitaka pithokashitemine?” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Iñaawakeri Pedro jirika impoitapaintsiri, rosampitanakeri Jesús: “Pinkatharí, jirika, ¿iitaka awishimoterine irirori?” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ikantzi Jesús: “Arime nonkowe ari rañaaperotakeme jirika, irojatzi nipiyantakyaari paata, te okowajaanta piyotero jiroka. Poshiretaina eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Okanta paata ithonka iyaatakotanake rakakeriri Jesús jirika Pedro, ikemayetakero maawoini iyekiite, roshiyakaatzi eero ikamita jirika yotaarewo rosampikowentakeri Pedro. Iro kantacha, tera inkantatye Jesús: “Ari nokowi rañaaperote...” Jiroka ikantajaantakeri: “Arime nonkowe ari rañaaperotakeme jirika, irojatzi nipiyantakyaari paata, te okowajaanta piyotero jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Naaka kenkithatakotaincha nokantake “jirika yotaarewo”, tema naaka osankenatakerori jiroka osankenarentsi. Iro riyoperotantaitari imaperotatya jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Te nonkenkithatakotero maawoini rantayetakeri Jesús, tema osheki okanta. Arime osankenatakoyetyaame maawoini, aritakeme anaanakero maawoini kipatsi ompiyotyaame osankenarentsipaini. Ari onkantaitaatyeeyaani.");
INSERT INTO cpbNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, pairani owakera netantanakawori notyaantzimiro nosankenare, ari nokenkithatakotakemiro maawoini rantayetakeri Jesús, nokenkithatakotakemiro eejatzi okaatzi retanakari riyotaantziri, ");
INSERT INTO cpbNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","irojatzi imonkaatantapaakari reethonkitai inkiteki. Tekera reethonkitaita, riyoyaakeri Rotyaantaperotaarewo, ikantakaakari Tasorenkantsi, riyotakaakeri oitarika rantayeteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ikanta ikamawetaka, iñagaitawairi koñaawoini, ari riyotaiyini riyotaanewo añagai. Okaatzi 40 kiteesheri roñaagapanaantari riyotaanewo, riyotaapanaantziri jimpe ikanta ipinkathariwentantzi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Eeniro itsipayetari Rotyaantaperore, ikantzitakari irojatzi risaikayetawake Jerusalén-ki, ikantakeri: “Ari poyaawentawakya imonkaatya okaatzi ikashaakaakemiri Ashitanari, nokenkithatakotzitakemiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tema imapero Juan romitsitsiyaatantakawo ñaa, iro kantacha eero osamanitzimaita piñaayetantyaariri Tasorenkantsi risaikashiretantemi oshiyawaitakawome romitsitsiyaatantatyeemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ikanta jirikapaini tsipatakariri Jesús, rosampitakeri, ikantziri: “Pinkatharí, ¿Irootaintsima pookaawiritaantairi nosheninka Israel-iite?” ");
INSERT INTO cpbNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ari rakanakeri Jesús, ikantziri: “Te okowajaanta piyotero eerokapaini tsikapaite, apatziro riyotzi Ashitanari tsikapaiterika, iriitajaantake oshekitzimotzi ishintsinka rantantyaawori. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iro kantacha arika ripokake Tasorenkantsi risaikashiretantapaakemi eerokapaini, iriitake aawyaashiretakaimine, iro ompoñaantyaari piyaayetanake pinkenkithatakotaina naaka Jerusalén-ki, maawoini janta Judea-ki eejatzi Samaria-ki, irojatzi intaina jimpe iweyaapaa kipatsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ithonka ikenkithawaitakero jiroka, raminaminthaitziri riyotaanewo, eethonkitairo Jesús, irojatzi ipeyantapaakari menkoriki, te iñagaitanairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Raminaminthaitziri jimpe ikanta Jesús reethonkitai inkiteki, apite atziri katziyimotapaakari kitamaaniki iithaare, ");
INSERT INTO cpbNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ikantapaakeri: “Galilea-satzi, ¿Iitaka paminiri inkiteki? Piñaakeri jimpe ikanta Jesús riyaatai, ari inkantaiyaari eejatzi paata arika ripiye.” ");
INSERT INTO cpbNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ikanta ripiyaiyaani riyotaanewo janta Jerusalén-ki ipoñagaawo otzishiki iitaitziri Olivo, te osamaniperote, ishinetaantsita ranashiyeetya kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ikanta rareetaiyaani nampitsiki, ataitaiyapaini jenokinta pankotsi tsika rimaapiintaiyini. Jirika ikaataiyini: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo itomi Alfeo, Simón iitaitziri “Jokaakotantaneri”, ipoñaapaaka Judas irirentzi Jacobo. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maawoini jirikapaini ari ikantaiyapiintatyaani ipiyotaiyani ramanaiyani itsipayetakari irirentzi Jesús, itsipatawo María inaanate, eejatzi otsipapaini tsinane. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ikanta ipiyotaiyani kemisantzinkaripaini, ikaataiyini 120 atziri. Ari ikenkithawaitanake Pedro, ikantanake: ");
INSERT INTO cpbNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Iyekiite, monkaataka okaatzi rosankenatakaakeriri Tasorenkantsi pairani David-ni, ikenkithatakotakeri Judas jewatapaintsiri raakaantziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jirika Judas iri atsipatapiintawetari antawaireki. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iro kantacha raakeri koriki ripinataitakeriri iyaariperonka, ramanantantakawo kipatsi. Ari iparyaakeri janta Judas, rowatziitotanaka, rithonka ritankawaitapaake, jokaporenthakeerekiwaitapaaka isheeto. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ikanta ikemaiyakeni Jerusalén-satzi, iitakero kipatsi ‘Iraantsipatha’, iitziro riñaaneki iriroripaini ‘Acéldama.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tema osankenarentsiki Salmo-ki, ikantaitake: Kaankithaante onkantya ipanko, Tekaatsi saikantaiyaawone. Ikantaitake eejatzi: Intzime itsipa poyaataiyaarine rantawaireki. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Eenitatsi jaka atziripaini tsipatapiintakairi eeniro itsipawetai Awinkatharite Jesús, ");
INSERT INTO cpbNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","atsipatzitakari owakeraini romitsitsiyaataka Jesús irojatzi reethonkitantaari inkiteki. Ontzimatye aminai antsipataiyaari ñiitakariri eejatzi Jesús rañagai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Irojatzi rookotaitantanakariri José, iitaitziri Barsabás, iitaitziri eejatzi Justo, ipoñaapaaka Matías. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ari ramanakowentanakari, ikantzi: “Pinkatharí, eeroka yotashiretziriri maawoini, jirika apite nookotakeri, poñaayenari jimpe itzimi pinintakeri eeroka, ");
INSERT INTO cpbNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","iriitake nontsipataiyaari notyaantaperoritai nantawaitaimi, ripoyaataiyaari Judas-ni opeyakaashitakari iyaariperonka irirori. Tema Judas, jatake irirori tsika inintakagaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Irojatzi roshiyakaantanakawori jirikapaini iñaaryaataita, iñaatziiro iriitake Matías. Iriitakera Matías kaatanairiri jirikapaini 11 Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Okanta imonkaatapaa roimoshirenkantaitawori kiteesheri “Owiitaantsi”. Ipiyotaiyaani maawoini riyotaanewo Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ari omapokapaakari antawoite kamenitapaintsiri oshiyawetapaakawo antawo tampyaa, okenapaake jenoki inkiteki, ookantapaakawo pankotsi risaikaiyakenira. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iñaawakitzi paampashithakeerekitapaintsiri, opeyantapaakari apaanipaini ikaatzi piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Maawoini risaikashiretantapaakari Tasorenkantsi. Ari retanakawo riñaawaiyetanakero otsipasato ñaantsi, iriitakera Tasorenkantsi ñaawaitakaanakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Okanta janta Jerusalén-ki, ari risaikayetziri Judá-ite poñaayetachari intaina otsipaki nampitsi. Iriiyetake pinkathatasorentsitaneripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ikanta ikemaitakero kamenitapaintsiri, ripokaiyapaakeni osheki atziri, te riyotawakero oita awisatsiri, tema ikemathatakero apaanipaini ñaantsi okaatzi riñaawaiyeetziri, irootake riñaane. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyokitzii ikantayetanaka, ikantawakagaiyani: “¿Tema Galilea-satzi rinatzi ñaawaiyetakerori otsipasato ñaantsi? ");
INSERT INTO cpbNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tsika okantaka akemantariri riñaawaitziro añaanepaini aaka? ");
INSERT INTO cpbNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tema atsipayetakari jaka Parto-satzi, Medo-satzi, Elam-satzi, Mesopotamia-satzi, Judea-satzi, Capadocia-satzi, Ponto-satzi, Asia-satzi, ");
INSERT INTO cpbNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia-satzi, Panfilia-satzi, Egipto-satzi, eejatzi Africa-satzi jekaatapai Cirene. Tema atsipatakari eejatzi poñaayetachari Roma, Judá-ite eejatzi kaari Judá-itetatsi pairani. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Eejatzi Creta-satzi, ipoñaapaaka Arabia-satzi. Ari atsipatakari maawoini irirori akemayetakeri riñaawaitantayetakawo añaanepaini, ikenkithatakotziri Pawa ritasonkawentantzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iyokitzii ikantanaka atziripaini, te riyotzi oita iñiiri. Ikantawakagaiyani: “¿Oitaka jiroka?” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iro kantacha tzimatsi atziri thainkantaneri, ikantayetzi irirori: “¡Ishinkitaiyatyaani jirikapaini!” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ikanta ikatziyanaka Pedro irirori, itsipatakari Otyaantaperoriite ikaatzi 11, ikenkithawaitanake shintsiini, ikantzi: “¡Asheninká! ¡Jerusalén-satzipaini! Pinkemisantawakena piyotantyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Piñaawetaka eerokapaini ishinkitatya jirikapaini. Te, tema owakera reenokiityaapaake ooryaa. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imonkaatatya okaatzi rosankenatakeri pairani Kamantantaneri Joel-ni, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ikantzi Pawa: Tzimatsi awisatsine weyaantapaakyaawone kiteesheri. Ari notyaantakeniri atziripaini Notasorenka oshiyawaitakawo risakoperoitatyeenirime. Ari inkenkithatakoyetanaina itomipaini eejatzi rishintopaini. Ari iñaawyaawaitakya mainaripaini, Eejatzi antarikitaintsiri rimishiwaiyetai. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ari nonkantakeri ewankaripaini ronampireyeetari, eejatzi ewankawopaini. Notyaantainiri Notasorenka paata, ari inkenkithatakaantayetai. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ari iñagaitake inkiteki kaari iñaapiintaitzi. Iñagaitero kipatsiki iraantsi, paampari, antawo oyachaarinka. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Iñagaiteri ritsiwakimate ooryaatsiri, Iñagaiteri eejatzi kashiri riratzimotante, Irootaatsi iyomaataiya kiteesheri ripokantaiyaari Pinkathari. Tema antawo rowaneenkawo onkantaiya. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Inkaate aakotairine iwairo Pinkathari, rawentaayetaari, iriiyetake awisakoshiretaatsine. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","¡Shiramparipaini! ¡Israel-iite! Pinkemaiyeni nonkante. Piñagaiyakerini eeroka, jirikaganki Jesús Nazaret-satzi, iriitake rotyaantakemiri Pawa. Ritasonkawentayetakemi, roñaagayetakemiro kaari piñaaweta pairani. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iro kantacha, ramaitapaakemiri jirika, powamaakaantakeri eerokapaini ikentakotakeri kaariperoshireripaini, ari imonkaatakari onkaate awishimoterine, tema irootake ikenkithashiriitakari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ikanta rowiriintairi Pawa ikamawetakaga, te rishinetairi inkemaatsiwaitaiya. Tema te okitsirinkiri kaamanetaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tema iri rosankenatakotakeri pairani David-ni, ikantake: Noñaapiintziri Nowinkatharite itsipatana. Tema risaiki nakoperoki, tekaatsi kitsirinkerine. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Irootake nokimoshiretantari, Kameniwaante nokanta nothaamentawentari. Iriitake noyaakoperotairi, nawentagaiyaarini. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tema eero pookanawentanawo noshire sarinkaweniki arika nonkamawetakya. Eero pishinetziro ipathaye nowatha, pitasorentsite ninatzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Piyotaakenawo jimpe nonkantya nañaashiretai. Osheki poimoshirenkaina arika nontsipataimi. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Iyekiite, ayotaiyini aaka te iri acharine David-ni kenkithatakotachane jaka, kamake pairani irirori, ikitaitakeri, irojatzi risaiki iroñaaka jimpe ikitataka. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tema Kamantantaneri rinake irirori, riyotzitaka pairani tzimatsi ikashaakaakeriri Pawa, ari impinkatharitakagairi apaani incharinentyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tema oshiyawaitakawo iñaakityeerome David-ni, ikenkithatakotakero rañagai Cristo, ikenkithatakotakeri eero risaiki sarinkaweniki, eero ipathai eejatzi iwathaki. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iriitake añaakagairiri Pawa jirika Jesús. Imaperotatya maawoini noñagaiyawairini naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ari reethonkitai, risaikimotapairi rakoperoriki Pawa ipinkathariwentantapai. Ari imonkaatari okaatzi ikashaakayitakairi pairani Ashitairi, tema rotyaantakairi Tasorenkantsi oshiyawaitakawo risakoperoitaatyainirime. Irootajaantakera piñaayetakeri iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tema kaari David-ni eethonkitaatsine inkiteki iriitake kenkithatakerori pairani jiroka, ikantake: Ikenkithawaitake Pinkathari, ikantawairi Nowinkatharite: Pisaikapai nakoperoki ampinkathariwentante. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Irojatzi paata nowasanketantaiyaariri kisaneentakemiri, Ari pimakoryaayitzitantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","¡Asheninká! iro kameethatatsi ayotaiyeroni jiroka maawoini aakapaini icharineyetaira Israel-ni. Jirika Jesús pikentakotakaantakeri eerokapaini, iri ipinkatharitakaakeri Pawa, irijatziita Cristo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ikanta ikemaiyawakeni ikaatzi piyotainchari, antawoite ithaawashiryaanake, rosampitanakeri Pedro, eejatzi itsipapaini Otyaantaperoriite, ikantaitanakeri: “Iyekiite, ¿jimpe nonkantaiyaaka naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ari rakanakeri Pedro: “Pipiyashireyetai, pomitsitsiyaawentaiyaari Jesucristo, paakoyetanairi iwairo. Iro riyotantaityaari impeyakotakagaimiro Pawa pikaariperowetaka, ari risaikashiretantaimi Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Irootake ikashaakagaitakemiri eejatzi eeroka, irojatzi ikashaakayitaitakariri pitomipaini, eejatzi ikaatzi nampiyetawori intaina. Tema maawoini ikaimashireyeetairi iriitake ikashaakayitaitakari eejatzi irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Osheki okaatzi ikenkithatakotakeri Pedro, ishintsithatantakari eejatzi, ikantayetakeri: “¡Powawisaakoshiretya! ¡Pintainaryaapithateri atziripaini kenashiwaiyetainchari!” ");
INSERT INTO cpbNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Irojatzi ikemisantantanakari osheki atziri, omitsitsiyaayetanaka, ikaatzi 3,000 atziri kemisantanaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kisokero rowanakero okaatzi riyotaayetakeriri Otyaantaperoriite, kameetha raapatziyawakaanaka. Ari itzipetowapiintaiyironi pan, ikamaitanakawo eejatzi ramanaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Riyokitziiwentanakero iñaakerowa ritasonkawentantayetake Otyaantaperoriite, rantayetakero kaari iñagaitapiintzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Osheki raapatziyawakaanaka ikaatzi kemisantanaatsiri, rantetaawakaanawo okaatzi oshekitzimoyetziriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ipimantayetziro oshekitzimoyetziriri. Rayi koriki ipayetziri itsipapaini kemisantanaatsiri ashironkaayetachari. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ari ikantaitanaatya kiteesheriki raapatziyawakaana ipiyotaiyani tasorentsipankoki. Te ripakaanakero ikaimawakaiyani ipankoki rowaiyaani, ari itzipetowirori pan. Kimoshire ikanta itsipatawakaiyani, itsinampashireyetanai. ");
INSERT INTO cpbNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ithaamentapiintanakari Pawa. Iro inimoyetakeriri atziripaini iñaayetakero jimpe ikantayetanaa. Ari okantaitanaatya kiteesheriki roshekyiiri Awinkatharite kemisantzinkaripaini inkaate awisakoshireyetaatsine. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Okanta otsipa kiteesheri, tsireniityaanake ramanapiintaitantari. Ari ritonkaanakeri Pedro itsipatanakari Juan, riyaatero tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ari ritonkyotakotantaka ramaitziri kisopookitatsiri. Rashi rowiro owakera itzimapaake. Maawoini kiteesheri ramaitapiintziri omooki tasorentsipanko iitaitziro “Owaneenkaanto”. Ari risaikapiintziri impashiyetantyaariri koriki ikowakoyetziriri kyaayetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ikanta jirika iñaawakeri Pedro itsipatakari Juan, iro inkyaantapaakyaarime tasorentsipankoki, ikowakotawakeri impashitanakyaari koriki. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ari ipampoyaanakeri. Ikantziri: “¡Paminena!” ");
INSERT INTO cpbNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ikemisantatzi kisopookiri, roshiyakaatzi impatyeeri jimpe oitya. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Iri kantacha Pedro, ikantanakeri: “Tekaatsi noorikite, te itzimi eejatzi ooro, iro kantacha eenitatsi nantzimotemiri. ¡Pinkatziye! ¡Panashitai! Naakotatziimiri iwairo Jesucristo Nazaret-satzi, iriitake antemirone.” ");
INSERT INTO cpbNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Rakathatakeri, ipiriintakeri. Omapokashitanaka ishintsitanai iitziki eejatzi ishoonketziki. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ari rimitaanake ikatziyanaka, anashitanaka. Itsipatanakari jirikapaini ikyaapaake tasorentsipankoki, anashiwaitanaawo, mitaamitaawaitanai, ithaamentanaari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ithonka iñagaitakeri ranashitanaa, ikemaitakeri eejatzi ithaamentawaita. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Riyokitziiwentaitanakero iñagaitakerowa awisaintsiri, te rikompiyeetawakari jirika, iriitake kowakotantapiintatsiri impashiyeetyaari janta omooki tasorentsipanko, iitaitziri “Owaneenkaanto”. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ikanta kisopookiwetachari, te rookanakeri Pedro itsipatakari Juan. Iyokitziiwenta rowanakeri atziripaini, intsipaiteperoini ipiyowentapaakari awisashetakera tasorentsipanko iitaitziro “Rashi Salomón”. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ikanta iñaawakeri Pedro, ikantawakeri: “¡Shiramparipaini! ¡Judá-ite! ¿Iitaka piyokitziiwentantanari? Eero pikenkithashiryaashiwaita naaka ashitawo noshintsinka, naaka tasorentsi nimatantariri nanashitakagaari jirika. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iwawane Abraham-ni, Isaac-ni, Jacob-ni, iwawanetanakari eejatzi acharineete, iriitake matakerori jiroka, ari onkantya impinkathaitantyaariri Itomi Jesús, paakaantakeri eerokapaini janta jewaripainiki. Ikowawetaka Pilato romishitowakaantairime, te pikowimaita eerokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iriitakeme pomishitowakaantaime Tasorentsitatsiri, matzirori itampatzikashiretzi, pomishitowakaantashitaari tsitokantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Iro opoñaantari powamaantakariri añaashiretakaantaneri. Iri kantacha Pawa rowañagairi. Noñagaiyawairini naakapaini rañagai. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Okaatzi etsiyatakotakagairiri kisopookiri piñaapiintziri eerokapaini, iro matakaakeriri rawentaashirenka ikemakenaga naakotakeri iwairo Jesús. Irootake piñaantakariri iroñaaka retsiyatakotai kameethaperoini. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Iyekiite, niyotzi naaka, te piyoperotero okaatzi pantayetakeri, ari roshiyakemi eejatzi peewarepaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ari ikenakairori Pawa rimonkaatziro okaatzi ikenkithatakaayetakeriri maawoini Kamantantaneriite, ikantake: ‘Aritake inkemaatsitakagaitakyaari Cristo paata.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Irootake pipiyashitantaiyaariri eerokapaini Pawa, pipakaayetairo piyaariperonka, oshiyawaitaiyaawome roshetakotaatyeerome irirori pikaariperowetakaga. Ari piñagairo intsipashiretaimi Awinkatharite, retsinaryaashiretakagaimi. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aritake rotyaantairi Pawa eejatzi Jesucristo, tema ikashaakayitakemiro pairani aritake ripiye. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Onkantawetakya risaike Jesucristo inkiteki irojatzi inkowapaitetantakyaari Pawa rowakeratakagairo maawoini okantawetaga pairani. Iro ikenkithatakaayetakeriri Tasorentsishireri Kamantantaneriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Iro ikenkithatakotakeri pairani Moisés-ni, ikantake: Ari rotyaantake paata Pawa itsipa Kamantantaneri, ari roshiyapaakena naaka rotyaantakenaga. Asheninka rinatye. Maawoini inkamantayetapaakairi, ontzimatye ankemisantero. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Maawoini kaari kemisanterine jirika Kamantantaneri, ari rithonkayeetakeri, Eero iñagairi isheninkapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ari roshiyakari eejatzi Samuel-ni, ikenkithatakotakero okaatzi añaayetakeri iroñaaka, irojatzi ikenkithatakoyetakeri eejatzi maawoini itsipapaini Kamantantaneriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Eerokayetake ñeerone okaatzi ikowakaantakeri Pawa ikenkithatakoyetakeri Kamantantaneriite. Eerokayetake ñeerone eejatzi okaatzi raapatziyawakaantari pairani Pawa itsipatakari acharineete. Tema Pawa ikantakeri Abraham-ni: Iri picharine tasonkawentairine maawoini sheninkatawakagaachari tsikarikapaini janta kipatsiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ikanta rowañagairi Pawa itomi, retakari rotyaantakemiri eerokapaini, ompoñaantyaari ritasonkawentemi. Iroowa pipakaantaiyaawori maawoini eerokapaini piyaariperonka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ikanta Pedro itsipatakari Juan ikenkithatakaayetziri atziripaini, areetaiyapaakani Imperatasorentsitaarewo, itsipatapaakari reeware kempoyiirori tasorentsipanko, eejatzi Sadoc-iite. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ikisaiyatyaani, tema Pedro eejatzi Juan riyotaatziiri atziripaini, ikantayetziri: “Imaperotatya rañaayetai kamawetainchari, iriitake Jesús oñaagantapaintzirori.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rotaiyaitapaakeri, romonkyaakaantakeri irojatzi oñaatamanai, tema tsireniityaake. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iro kantacha osheki kemayetawakerori kenkitharentsi, ikemisantayetanake. Jirika ikaatzi tzimanaintsiri kemisantzinkaripaini, ikaataiyini 5,000 shiramparipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Okanta okiteeshetamanai, ipiyotaiyakani Jerusalén-ki maawoini reewarite Judá-ite, Itzinkamipaini, eejatzi Yotzinkariite. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ari risaikakeri eejatzi Anás Imperatasorentsiperotaarewo, Caifás, Juan, Alejandro, ipoñaapaaka isheninkapaini Imperatasorentsiperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ikaimakaantakeri ramaiteri Pedro eejatzi Juan. Rosatekaitawakeri niyanki ipiyotaiyakanira, rosampitakeri: “¿Iitaka shintsitakaimiri pimatantakawori jiroka? ¿Iitaka paakotakeri iwairo?” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Irojatzi rakantanakari Pedro, ikantakaaperotakari Tasorenkantsi, ikantanake: “Pinkatharipaini, Itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Iriima pikantakotanari netsiyatakotakagairira mantsiyari? ¿Pikowatziima piyotaiyeni jimpe ikanta retsiyatakotantaari? ");
INSERT INTO cpbNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ari nonkamantaiyakemironi, onkantya riyotantyaari maawoini Israel-iite. Jirika shirampari atsipataiyakarini jaka, iri Jesucristo etsiyatakotakaakeriri, iitzitaitari Nazaret-satzi. Iriitake naakotakeri iwairo, irijatzi pikentakotakaantakeri eerokapaini. Iro kantzimaitacha rowañagairi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jirika Jesús iri oshiyakawori mapi pimanintakeri eerokapaini, poshiyakowaitakari wetsikirori pankotsi. Iro kantacha ipiriintaitairo pankotsinampiki roshiyaawo iroorikame tzinkamitsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tekaatsi itsipa oshiyaarine Jesús rowawisaakotantzi. Tekaatsi aakotai iwairo jaka isaawiki kipatsi, apatziro ikantakaawo Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iyokitzii rowaitanakeri Pedro, eejatzi Juan, ikantaiyanakeni piyowentakariri: “Pamineri jirika, te riyotaaperoweetari, iro kantzimaitacha pinkathawaante rowaitziri. ¿Iriima yotaakeriri Jesús itsipatakari pairani?” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Irojatzi itsipatakari Pedro eejatzi Juan jirika atziri retsiyatakotakagairi. Te otzimi oita inkantakoteriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Romishitowakaantairi ipiyotaiyanira, ari risaikaiyanakeni irirori riñaanatawakagaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ikantzi: “¿Tsikama ankanterika jirikapaini atziri? Maawoini Jerusalén-satzi riyotaiyakeni ritasonkawentantake. Eero amatairo amanakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jame asariimatashityaari, iro ompoñaantyaari eero riyaatakaantawo inkenkithatakoteri Jesucristo, raakotapiintairi iwairo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Irojatzi ikaimantaariri eejatzi. Ikantaiyakerini: “Atapaake pikenkithatakotakeri Jesús, eero papiitairo piyotaantayetai paakoyetairi iwairo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Iro kantacha rakanakeri Pedro eejatzi Juan, ikantanakeri: “¿Kameethatatsima nipiyathatyaari Pawa, nonkemisantantemiri eerokapaini? Janjaatya pinkantena. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Eero okanta nipakagairo nonkenkithatakoyetero okaatzira noñaawakeri, nokemajaantakeri eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ikanta rasariimawaiwetakari jewaripaini, ripakagairi. Tema maawoini atziripaini ithaamentawentanakari Pawa iñaayetakero awisayetaintsiri, te otzimi oita rowasanketantyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jirika atziri retsiyatakotakaayeetairi, tzimatsi rosarentsite awisaneentakero okaatzi 40. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ikanta Pedro eejatzi Juan, ripakagaitairi, jatake ipiyotaiyani ikaataiyinira, ikamantakeri okaatzi ikantakeriri reeware Imperatasorentsitaarewo eejatzi Itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ikanta ikemaiyakeni, maawoini ramanaiyanakarini Pawa, ikantzi: “Pinkathariperorí, eerokatake wetsikakerori inkite, kipatsi, inkaare, eejatzi ikaatzi tzimantayetawori. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Eerokatake kenkithatakaakeri pairani ponampire David-ni, ikantake: ¿Iitaka riñaawaiwentaiyirini atziripaini? ¿Iitaka ikenkithashiryaawaitantakari? ");
INSERT INTO cpbNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Piyotaiyakani pinkathariwentantatsiri jaka kipatsiki, Ipiyoyetaka jewaripaini, Inkoshekantyaariri Pinkathari, eejatzi riyoyaanewo Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Rimatzimaitakawo Herodes eejatzi Poncio Pilato ipiyotaiyakani nampitsikika, eejatzi Israel-iite ipiyotaiyakani itsipatakari itsipasatzi atziripaini, ikoshekakari Jesús, pitasorentsite Pitomi, piyoyaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ari okantaka, rimatakero jirikapaini okaatzi pikenkithashiryaakari tsika onkantya. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iroñaaka, Pinkatharí, paminero eeroka rasariimatakena, pishinetainawo ponampireyetaina, eero nothaawawaitanta nonkamantantairo piñaane. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iro pishintsinka petsiyatakotakaantyaariri mantsiyayetatsiri. Iro pitasonkawentakaantantenari naakoteri iwairo Tasorentsi Pitomi Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ikanta ikaatakero ramanaiyani, ontziñaanaka janta tsika ipiyotaiyakani. Ikantakaakiperotanakari Tasorenkantsi ikenkithatakotanakero riñaane Pawa, tekaatsi inthaawakaanakya. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Shenitanake kemisantanaatsiri. Apaani okantanaa ikenkithashiretanaari. Te ishampitsitawakaiyaawoni oitarika, ipayetawakaawo okaatzi koityiimoyetariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jirikapaini Otyaantaperoriite eekero riyaatatzi ikenkithatakotziro tsika okanta rañaantaari Pinkathari Jesús. Antawoite ineshironkayetakeri Pawa maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Te itzimawaitzi apaani koityaawaitatsine, itzimirika tzimatsiri iipatsite, ipanko, ipimantayetziro. Raakeri koriki, ");
INSERT INTO cpbNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","impakeri Otyaantaperoriite, iriitake antetaariri maawoini raantayetari apaanipaini oita ikowiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iro rimatakeri apaani Leví-ite iitaitziri José, Chipre-satzi rinatzi, irijatzi iitakeri Otyaantaperoriite, Bernabé. (Oshiyakaawentachari jiroka wairontsi Bernabé: “Otomi oimoshirenkaantsi”.) ");
INSERT INTO cpbNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jirika atziri tzimatsi iipatsite, ipimantakero. Raanakeri owinawo iipatsite, ipapaakeri Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iro kantacha eenitatsi itsipa atziri iita Ananías, itsipatakawo iina oita Safira, ipimantakero iipatsite. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jirika atziri raapatziyakawo iina, rimanagaantake owinawo iipatsite. Ramakeri tzimagaantapaintsiri, ipapaakeri Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ikantawakeri Pedro: “Ananías, ¿iitaka pishinetantakariri Satanás inthaiyakayemi, iro pikowantanakari pamatawiteri Tasorenkantsi, pimanagaantake owinawo piipatsite?” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“¿Kaarima eeroka ashiwetawo kipatsi? ¿Kaarima eeroka ashiwetari owinawo? ¿Iitaka pikenkithashiryaantakawori pantero jiroka? Tera iri atziripaini pamatawite, Pawaga.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ikanta ikemawake Ananías, tyaanake, kamanake. Antawoite ithaawaiyanakeni ikaatzi kemayetaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ikanta mainaripaini, iponatapaakeri, raanakeri, ikitatakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tekera osamaniteeta, ari okyaapaake iina Ananías, te iyote iroori oita awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Rosampitawakero Pedro, ikantziro: “Pinkantena, ¿Arima ikaatzi owinawo?” Akanake iroori: “Jee, arimachee ikaatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ikantziro Pedro: “¿Iitaka paapatziyawakaantakari pikowi piñaantyaari Itasorenka Pinkathari? Piyaiyakani aanakeriri piime ikitatziri, iroñaaka rayitanakemi eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Apathakero ityaanake Safira ikatziyakaga Pedro, kamanake. Ikanta ikyagaiyapaini mainaripaini, iñaapaatziiro kamake. Raanakero, itsipatagairo oime ikitatakaga irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ikanta iñagaitakero awisaintsiri, antawoite ithaawaiyanakeni kemisantzinkaripaini, ari ikantzitanakari eejatzi kemakoyetakerori okaatzi awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Eekero riyaatakaanakitziiro Otyaantaperoriite ipiyotapiintaiyanakani janta awisashetatakera tasorentsipanko iitaitziro “Rashi Salomón”. Eekero ritasonkawentanakitzi osheki atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Iwinkanewo rowayetanakeri itsipapaini, te ikowayetanai intsipatanaiyaari. Iro kantzimaitacha eenitatsi osheki thaamentaperowentanakariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eekero ripokanakitzi osheki shirampari eejatzi tsinanepaini, shenitanake ikaatzi kemisantanairiri Pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ramakoyetapaakeri atziri imantsiyarite romaryaakoyetapaakeri ishitashiki tsika inkenapaake Pedro. Ikantayetzi: “Inkenapaakerika Pedro jaka, arika ritsimankantanakyaari eepichokiini raampare, aritake retsiyatakotai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ari ikantaiyapaakani atziripaini poñaayetainchari nampitsiki saikanampitzirori Jerusalén, ramayetake osheki mantsiyaripaini eejatzi osheki raagayetziri peyari, retsiyatakotakaayetawakeri maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ikanta Imperatasorentsiperori, itsipatakari ikaatzi aapatziyakariri, jirikapaini Sadoc-iite, ikisaneentaiyanakani. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Raakaantakeri Otyaantaperoriite, romonkyaakaantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Okanta otsireniwetanaka, pokake imaninkarite Pinkathari, rashitaryaakotairi, romishitowayetairi, ikantawairi: ");
INSERT INTO cpbNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Piyaate tasorentsipankoki, pinkenkithatakotainiri atziripaini tsika okantakota owakerari añaamentotsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Okanta okiteeshetamanai, areetaiyapaakani tasorentsipankoki, retapaakawo ikenkithatakaantapaake. Te riyotaatsikaitzi Imperatasorentsiperori, piyotaiyachani itsipayetakari raapatziyanewo, eejatzi maawoini Itzinkamipaini Israel-iite. Irojatzi rotyaantantakari ramaiteri Otyaantaperoriite romonkyaakaantaweetakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ikanta riyaatashiweetanakari romonkyaakaantane, te iñaapairi. Piyapaaka, ");
INSERT INTO cpbNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ikantapaakeri: “Te añagairi. Irojatzi okanta noñaawetapaakawo ashita kameethaini, irojatzi ikatziyayeweta kempoyiiriri. Ikanta nashitaryaakowetapaakari, te noñaapairi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ikanta ikemawake Imperatasorentsiperori, eejatzi reeware kempoyiirori tasorentsipanko, eejatzi reeware Imperatasorentsitaarewo, rosampitawakagaiyanakani oitarika awisatsine. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Areetapaaka kamantapaakeriri: “Jirikapaini pomonkyaakaantawetakari, risaikaiyini tasorentsipankoki ikenkithatakaayetziri atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Irojatzi riyaatantanakari reeware kempoyaantaneripaini, raanake osheki ratzirite, ramairi eejatzi. Iro kantacha te rakotashiwaitziri. Tema ithaawakaatyaari atziripaini rishemyaantyaari mapi. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ikanta rareetakaapaakari, rowawisaapaakeri tsika ipiyotaiyakani jewaripaini. Ikanta Imperatasorentsiperori rosampitawakeri, ");
INSERT INTO cpbNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ikantziri: “¿Tema pikemi nokantzi chapinki: ‘Atapaake pikenkithatakotakeri Jesús?’ Eekero piyotaatziiri maawoini Jerusalén-satzi. Pikantakotakena eejatzi naaka, pikantzi: ‘Iri owamaakaantakeri Jesús.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ari rakanake Pedro eejatzi itsipapaini Otyaantaperoriite, ikantanake: “Iriira Pawa nonkemisantaperote, eero nokemisantawaitashitari atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tema imapero powamaakaantakeri eeroka Jesús, pikentakotakaantakeri. Iro kantacha rowañagairi Pawa, ikemisantakeri pairani acharineni. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Rowenonkairi Pawa, roisaikairi rakoperoki, itsipataari ipinkathariwentantzi. Iri owawisaakotaine eejatzi. Ikowake apiyashireyetai maawoini aakapaini Israel-iite, ompoñaantyaari impeyakotantairori akaariperoshirewetakaga. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naaka ñaakero okaatzi rantayetakeri Jesús, ontzimatye nonkenkithatakotero. Irijatzi Tasorenkantsi matakainawone, tema iriitake rotyaantakenari Pawa risaikashiretantaina naakapaini nokemisantairira.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ikanta ikemaiyakeni, antawoite ikisanaka, ikowanake ritsitokerime. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iro kantacha ari ikatziyanaka apaani, jitachari Gamaliel. Fariseo rinatzi irirori, irijatzi yotaantzirori Inintakaantaitanewo. Pinkatha rowiri maawoini atziri. Ikantanake: “Asheninká, jametya omishitowawakeri eepichokiini jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Irojatzi ikantantanakari: “¡Shiramparipaini! ¡Israel-iite! Ontzimatye pinkenkithashiryaawakya kameetha tsikarika pinkanteri jirika atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pinkenkithashiryaakoteri jitachari Teudas, ishamewaitake irirori. Ipiyotake pairani 400 atziri. Iri kantzimaitacha ritsitokaitakeri Teudas, rithonka ripookayetanake maawoini tsipayewetakariri, ari ipeyari. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ari okantzitakari pairani rosankenatakotantari maawoini atziri, itzimaweta itsipa jitachari Judas, Galilea-satzi rinatzi. Ipiyotake atziri. Iro kantacha rowamagaitakeri irirori. Irojatzi ripookantanakari maawoini tsipayewetakariri, ari ipeyari. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pinkeme nonkantemi naaka: Eero pikoshekari jirika, pinkempoyaaminthatashityaari. Iriirika antashiwaitawo inintakaanekiini, apanirowa impeyashitaiya, roshiyakotyaari apitetaintsiri nokenkithatakotakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iri kantzimaitacha, iriirika Pawa matakaayetziriri okaatzi rantayetziri, eerowa pimatziri eerokapaini poitsinampairi. Paamaawentya pikoshekakari Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Inimotanakeri maawoini kemaintsiri. Ikaimairi eejatzi Otyaantaperoriite, ripasatakaantakeri, ikantakeri: “Ataama pikenkithatakotziri Jesús.” Ripakagairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Irojatzi rishitowaiyantanaarini Otyaantaperoriite ipiyowentaitakari. Thaamenta ikantaiyanakani, ikantaiyini: “Piñaakero, roshiyakagaitakai iriiperome anatye, rowasankewentaitakairi Jesús, aakotairira iwairo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ari ikantapiintanakitya riyotaantzi maawoini kiteesheriki, ikenkithatakaantzi tasorentsipankoki, ikantzi: “Cristo rinatzi jirikaganki Jesús.” Ari ikantayetakero eejatzi janta pankotsipainiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ikanta isheniperotanake riyotaanewo, ikenkithawaiyetanake Grecia-weri, ikantzi: “Pamineri rantapiintakeri Heber-thato, ipapiintayetziro owanawontsi kinankawo, ramaakiyetzimaitawo kaari isheninkayeta iriroripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ikanta Otyaantaperoriite kaatatsiri 12, ipiyotakeri maawoini riyotaanewo, ikantakeri: “Te onkameethate nipakairo nonkenkithatakotanairi Pawa, nompantapiintemiri poyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iyekiite ontzimatye pamine akaataiyinira, inkaate 7 atziri, iriitake aminakaantapiinterone jiroka. Piyoyee kameethashiretzimotakemiri, eenitatsi riyorenka, risaikashireperotantari Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iro ompoñaantyaari nonkamaitantyaawori naakapaini namanayetya, nonkenkithatakaante, niyotaantayete eejatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ikanta maawoini piyotainchari, inimotanakeri okaatzi ikantakeriri. Ari riyoyagaitakeri Esteban, awentaariri kameethaini Pawa, risaikashireperotantari Tasorenkantsi. Riyoyagaitakeri eejatzi Felipe, Prócoro, Nicanor, Timón, Parmenas, ipoñaapaaka Nicolás Antioquía-satzi, oshiyakotaariri Judá-ite, tema kaari isheninka Judá-ite pairani. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Irojatzi ragaitantanakariri jirika 7 risaikira Otyaantaperoriite, ari ramanakotawakari, ritasonkawentayetakeri rotzimikapatziitoyetantakari rako. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eekero iyaatakotanakitzi riñaane Pawa. Eekero isheniperotanakitzi riyotaanewo Jerusalén-ki. Rimatzitanakawo ikemisantayetanake osheki Imperatasorentsitaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ikanta Esteban osheki ritasonkawentantake atziripainiki, tema Pawa neshironkatakeri, ipakeri ishintsinka. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iro kantzimaitacha, eenitatsi Judá-ite ikaatzi piyotapiintachari jitayetachari “Rimperaweetari”. Iri poñaayetainchari Cirene-ki, Alejandría-ki, Cilicia-ki eejatzi Asia-ki. Riñaanaminthatanakeri Esteban. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Iro kantzimaitacha te roitsinampairi, tema imaperotatya Esteban riyotanetakaakeri Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iro ikamantantakariri rimananekiini isheninka, ikantziri: “Pinthaiyakotyaari Esteban. Pinkante: ‘Nokemakeri Esteban rithainkimawaitziri Moisés-ni, eejatzi ikantzitari Pawa.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iro owatsimaanakeriri atziripaini ikisaneentanakeri Esteban, rimatzitanakari Itzinkamipaini, eejatzi Yotzinkariite. Raakaantaitakeri, raayeetanakeri ipiyotaiyanira jewaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ari ramaitapaakeri thaiyakotakariri Esteban, ikantapaake: “Jirika atziri osheki rithainkakero tasorentsipanko, rithainkakero Inintakaantaitanewo eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nokemakeri ikantake: ‘Ari intzimpookakero tasorentsipanko Jesús, iitaitziri Nazaret-satzi. Rowashiñaayetairo eejatzi ameyetari aakapaini riyotaayetairi pairani Moisés-ni.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ikanta jewaripaini piyotainchari, ikempoyaanakeri Esteban, iñaatziiri ipooki roshiyanakari maninkari. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ikanta Imperatasorentsiperori rosampitakeri Esteban, ikantziri: “¿Imaperoma ikantakoitzimiri?” ");
INSERT INTO cpbNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ari rakanake irirori, ikantzi: “¡Iyekiite! ¡Ashitaanitachari! Pinkeme nonkantemi. Pairani risaikantawetakari acharine Abraham-ni janta Mesopotamia-ki, roñaagakari owaneenkatachari Pawa, tekera riyaatanakeeta inampityaawo Harán-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ikantakeri: ‘Pookanairo pinampi, pookanairi pisheninkapaini, piyaate otsipaki kipatsi noñaagakemiri naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ikanta Abraham-ni, rookanairo inampi jitachari Caldea. Irojatzi ripokantaari inampitaawo Harán-ki. Ikanta ikamai ipaapate, irojatzi rotyaantantakariri Pawa jaka, tsika anampitawo iroñaaka aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iro kantzimaitacha, te rashitakaaperotari, tekaachaajaini rashitakayaariri eepichokiini. Ikashaakaakeri imperi paata, arika inkamake. Iri ashitaiyaawone inkaate charinetaiyaarine. Irootake ikantakeriri okantawetaka Abraham-ni te itzimi rowaiyaneni. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iro kantacha ikantakeri eejatzi: ‘Iñeero pincharineyetyaari inampityaawo iipatsiteki itsipa atziri. Onkaate 400 osarentsi inkemaatsiwaitya rimperawaitaityaari janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ari nowasanketairi naaka inkaate imperawaitakyaarine. Iriima pincharineyetyaari namairi maawoini jaka nampitsiki, ari rantawaitainari naaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Irojatzi ikantantakariri Pawa eejatzi pairani Abraham-ni: ‘Ontzimatye pitomeshaanitya, tema tzimatsi aapatziyawakayaari.’ Rimatakero pairani Abraham-ni. Rimatakeri eejatzi itomi irirori, rimaakotapaakera 8 kiteesheri, ritomeshaanitakeri. Rimatakero Isaac itzimake pairani Jacob-ni. Rimatakeri eejatzi Jacob-ni 12 itomipaini, acharineyetanakari aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ikanta jirikapaini, acharineyetaari aakapaini, ikisaneentakeri irirentzi José, ipimantakeri. Irojatzi rareetantakari inampiki Egipto-satzi. Iri kantacha, ari itsipatapiintakari Pawa, ");
INSERT INTO cpbNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","rowawisaakotairi okaatzi ikemaatsiwaiwetaka. Ipakeri yorenkantsi, irootake raakameethatantakariri iwinkatharite Egipto-satzi jitachari Faraón. Irojatzi ipinkathariwentantakariri irirori maawoini Egipto-satzi, eejatzi maawoini isheninkapaini Faraón. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Irojatzi areetantakari antawo tashetsi janta. Osheki ikoityaaneentaiyakeni Egipto-satzi. Ari okantakari eejatzi inampiki Canaán-satzi. Te iñiiro pairani acharineni oitarika rowayetaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ari ikemakeri Jacob eenitatsi owanawontsi janta Egipto-ki. Rotyaantakeri itomipaini ramanantakite. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ikanta rapiitakero riyaataiyini, ari riyotakagaari José irirentzipaini. Irojatzi riyotantakariri Faraón isheninkapaini José. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ikanta José, ikaimakaantairi ipaapate Jacob, eejatzi maawoini isheninka, aamaaka ikaatzi 75 atziri jataintsiri Egipto-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Irojatzi rareetantakari Jacob Egipto-ki. Ari ikamairi irirori janta. Ari ikantakari eejatzi ikaatzi acharineyetanakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Irojatzi raatonkiyeetantanaariri, ikitaitapairi Siquem-ki ramanantakeri pairani Abraham-ni, rashi naaweta itomipaini Hamor. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Okanta imonkaatzimataka okaatzi ikantakeriri pairani Pawa acharine Abraham-ni. Tzimanake osheki reentsite asheninkapaini janta Egipto-ki, ");
INSERT INTO cpbNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","irojatzi itzimantakari itsipa pinkathari janta Egipto-ki, kaari yotakotziriri José. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ikanta jirika pinkathari, osheki ramatawitakeri asheninka, rowashironkaawaitakeri. Ishintsineentakeri rookayeteri reenchaanikite, inkamantyaari, eero ishenitanta. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aripaite itzimakeri Moisés irirori. Iriitake jirika eentsi kameethatzimotakeriri Pawa. Ikaatzi mawa kashiri rimanawetakari ipankoki ashitariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Okanta imonkaapaitetapaaka rookanawentantyaariri inkameme, oñaakeri rishinto Faraón, aakeri, opiraanikitakari, oshiyakaanakeri iriime owaiyane iroori. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ari ikantakari Moisés-ni riyotantakawori okaatzi riyorenkatari Egipto-satzi. Iriiperori atziri rinake, iroopero okantayetaka rantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ikanta otzimake 40 rosarentsite Moisés-ni, ikowake rareetyaari isheninkapaini, Israel-iite. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ikanta iñaapaakeri Egipto-satzi rowasanketziri isheninka. Ikisawentapaakari Moisés isheninka, ritsitokakeri Egipto-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Roshiyakaatzi Moisés-ni ari inkenkithashiryagaiyakyaani isheninkapaini, iriitake rotyaantakeri Pawa rookaawiritaantairi. Iri kantzimaitacha jirikapaini te riyotaiyirini. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Okanta okiteeshetamanai, iñaatzi rantawakaiyani isheninka. Ikowawetaka Moisés rookakairime, ikantawetapaakari: ‘Eero powashironkaawakaiyani pantawakaa, pisheninka powawakaiyani.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ikanta jirika antziriri isheninka, rotatsinkawakeri Moisés. Ikantziri: ‘¿Iitaka kantakemiri eeroka nowinkatharite? ¿Pikowatziima eeroka piyakowentena? ");
INSERT INTO cpbNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Pikowatziima pitsitokena naaka pikemetaakerira chapinki Egipto-satzi?’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ikanta ikemawake Moisés ikantakeriri isheninka, shiyanaka. Jatake iipatsiteki Madián-satzi. Ari risaikakeri janta nampitsinentsiki, irojatzi itzimantakari apite itomi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Okanta awisake okaatzi 40 osarentsi. Janta ochempiki, okaakitapai otzishi jitachari Sinaí, ari roñaagakari imaninkarite Pawa, ipaampatakairo kitocheemaishi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Riyokitziiwentanakero Moisés iñaakerowa. Ikowaminthaitzi raminero okaakiini, ari ikemakeri Pinkathari riñaanatziri, ikantziri: ");
INSERT INTO cpbNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Pawa ninatzi naaka, naakatake ipinkathatziri picharine, Abraham, Isaac, eejatzi Jacob.’ Ari ithaawanakeri Moisés, okawaitanaka, te ikowi raminanairo. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Irojatzi ikantantanakariri eejatzi: ‘Pizapato-reeya, tema pikatziyantatyaawo iroñaaka kipatsi notasorentsipathatakaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Noñaakeri janta Egipto-ki niyoyaakeri pisheninkapaini, osheki rashironkaawaitaka. Nokemakeri ratekawaitaiyini. Irootake nipokantakari nookaawiritaantairi. Eerokaga notyaante Egipto-ki pantero.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tema pairani imanintaweetakari Moisés-ni, ikantaitakeri: ‘¿Iitaka nintakaakemirori eeroka nowinkatharite?’ Tema iriitajaantake rotyaantakeri Pawa impinkathariwentairi isheninkapaini, iri jokaawiritaantairine eejatzi. Iriitakera matakaakeriri imaninkarite Pawa iñaakeri pairani ipaampatakairo kitocheemaishi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Irijatzi Moisés-ni omishitowairiri pairani asheninkapaini Egipto-ki, osheki ritasonkawentantake janta. Ari ikantakero eejatzi janta inkaareki iitaitziri ‘Kityonkaari’, eejatzi ikantakero risaikawaitantakari ochempiki okaatzi 40 osarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Irijatzi Moisés-ni kantakeriri pairani asheninkapaini: ‘Ari rotyaantake paata Pawa itsipa Kamantantaneri, ari roshiyakotapaakenawo naaka rotyaantakena. Asheninka rinatye.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Irijatzi Moisés-ni piyotakeriri pairani asheninkapaini janta ochempiki, ikenkithawaitakaakeri maninkari janta otzishiki Sinaí, itsipayetakari asheninkapaini. Iriitake aajaantakerori owañaantatsiri ñaantsi, irojatzi rowawisaantakairori aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Iro kantacha te ikowi acharineni inkemisanteri Moisés-ni, osheki ripiyathatakari. Ikowaiyakeni ripiyaime inampiki Egipto-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ikantakeri Aarón-ni: ‘Iriiwetaka Moisés jokaawiritaantaanari Egipto-ki. Iro kantacha te ayote oita awishimotakeriri kaari ripokanta riyaatzi chapinki otzishiki Sinaí. Piwetsikena nowawanetaiyaari.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ari riwetsikaitakeniri oshiyawetariri ewonkeri waaka. Ikowaiyakeni roshiyakairi Pawa. Rowamaakeniri ipirapaini roimoshirenkantyaariri iwawane. Iriiwetaiyakani wetsikakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Irootake, rintainaryaapithatantanakariri Pawa jirikapaini, rishinetanakeri impinkathayetairi oorentayetachari inkiteki, tema iriitake rosankenatakotzitakari Kamantantaneriite, ikantake: ¡Israel-iite! ¿Naakama pipinkathatantaka pipirapaini pitaapiintzirira? Tema iro pantapiintakeri okaatzi 40 osarentsi janta ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iri Moloc pipinkathatapiintashitakari, pikenakenatakaapiintakero ipankoshetaitari. Ari pikantapiintakeri iwawanetashiitari oshiyariri impokiro iitaitziri Renfán, Pipinkathatashiwaitakari piwetsikayetanewo eerokapaini. Irootake nishinetantemiri ragaitemi intaina panaanakero Babilonia. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Risaikawaitantakari pairani acharineeteni ochempiki, otzimimotziri tasorentsithaante. Ari rowakoyetzirori rosankenare Moisés-ni. Jiroka tasorentsithaante, irootakera riwetsikakaantakeri kameethaini Moisés-ni okaatzira roñaagakeriri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iroowa ikenakenatakaapiintakeri pairani acharineeteni, irojatzi rareetantakari kipatsiki rashitakaitariri. Iro ramayetairi reewatantakariri Josué, roitsinampaantakariri ashiwetawori iipatsite, ikantakaari Pawa. Ari ikantaitatziiro roisokerotakawo tasorentsithaante, irojatzi itzimantakari pairani pinkathari David-ni. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ikanta pinkathari David, osheki raakameethatakeri Pawa, ikantake irirori: ‘Tema eeroka Pawa ipinkathatake pairani Jacob-ni, pishinetena naaka niwetsikemi pankotsi pisaikantyaari.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Iri kantacha Salomón, iriira wetsikaperotakerori tasorentsipanko. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Iri kantzimaitacha Pawa Jenokisatzi, te inampitantawo pankotsi riwetsikanewoki atziri. Iro ikenkithatakotakeri Kamantantaneri, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jiroka ikantake Pawa: Iro inkite nisaikantari nopinkathariwentantzi. Iroowa kipatsi nimakoryaayitzitantari. ¿Tsika onkaateka pankotsi riwetsikaitenari? Eero niyomaatawo nimakoryaantyaawo. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Tema naaka wetsikayetakerori maawoini tzimayetatsiri? ");
INSERT INTO cpbNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eeke riñaawaitanakitzi Esteban, ikantzi: ‘Iro kantacha eerokapaini, ari pikantapiintatya pikisoshiretzi, te pikemisantanetzi, poshiyakari itsipasatzi atziri kaari asheninkata. Pashi powapiintziro pipiyathatakari Tasorenkantsi poshiyakotaari picharineni.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Eenitatsima Kamantantaneri kaari inkemaatsitakaya pairani picharineni? Rowamaayetzira ikaatzi kenkithataintsiri, ikantake: ‘Awotsikitake matzirori itampatzikashiretzi.’ Tema pokake iroñaaka matzirori, iriira pipithokashitaiyakarini eerokapaini, pitsitokakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tema eerokatake yowetawori Inintakaantaitanewo riyotaawetakairi maninkari, iro kantacha osheki pipiyathataka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ikanta ikemaiyawakeni piyotainchari, antawo ikisanakeri Esteban, ratsikaikitashitanakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Iriima Esteban risaikaperotantanakari Tasorenkantsi, raminanake inkiteki, iñaakero rowaneenkawo Pawa, iñaakeri eejatzi Jesús ikatziya rakoperoki Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ikaimanake, ikantanake: “¡Pamine! Noñaakero inkite ashitaryaanaka, noñaakeri Itomi Atziri ikatziyaka rakoperoki Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ari rotzimikayempitatanakari jirikapaini. Ikaimaiyanakeni shintsiini, rishiyashitapaakari Esteban. Rotaiyapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Irojatzi ragaitantanakariri okaathapitzira nampitsi. Ari retapaakari rishemyaantari mapi, raatonkoryaanaka, rookanakeniri iithaare mainari jitachari Saulo, ikantakeri: “Potaiyawakenawo noithaare, nishemyaawakeriita.” ");
INSERT INTO cpbNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ikanta rishemyagaitzirira Esteban, ramananakari irirori Pawa, ikantziri: “Nowinkatharite Jesús, jatashiretaana noñaapaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ari rotziwerowanakari, riñaawaitanake shintsiini, ikantanake: “Nowinkatharite, eero poipiyiniri jiroka kaariperotaantsi.” Ikaatakerowa riñaawaitzi, peyanaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ikanta Saulo ipampoyaakowentakeri Esteban ritsitokaitziri, ikantanake irirori: “Ariwé, kamake Esteban.” Aripaite etanakawo royaakyaaminthaitziri kemisantzinkaripaini Jerusalén-ki. Irootake rishiyayetantanakari maawoini Judea-ki, ikenayetanake eejatzi nampitsiki Samaria. Irojatzimaita risaikanake Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ikanta pinkathatasorentsitaneripaini ikitatakeri Esteban, antawoite riraakowaitakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iriima Saulo ikowawetaka irirori rithonkerime kemisantanaatsiri. Riyaatashitapiintakeri ipankoki, inoshikayetziri atziri, tsinanepaini, maawoini. Romonkyaakaantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ikanta maawoini shiyayetanainchari, jatayetanake otsipaki nampitsi. Ikenkithatakoyetakero Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ikanta Felipe, iriitake itsipa shiyanainchari eejatzi, areetaka nampitsiki Samaria. Ikenkithatakotapaakeri Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ari ipiyotaiyanakani maawoini atziripaini, rowayempitatakawo ikenkithatziri Felipe, tema iñaayetakero ritasonkawentantapaake. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Retsiyatakotakaayetai osheki atziri raagawetari peyari. Antawo ikaimayetzi peyari rishiyayetaga. Eejatzi ikantakeri, osheki atziri kisopookiwetachari, kaari kameethawetachane iitzi, retsiyatakotakaayetairi maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irootake ikimoshiretantakari maawoini nampitawori janta nampitsiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iro kantacha tzimatsi janta jitachari Simón. Sheripiyari rinaweta pairani. Ramatawitake osheki atziri nampitachari Samaria-ki. Osheki ishamewaitake. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ipinkathawetari atziripaini, jewaripaini, maawoini, ikantayetzi: “Jame ankemisanteri, jirika Simón rimatakero iñaawyaatari Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ikemisantaitziri Simón maawoini ikantayetziri. Osheki osarentsi riyokitziiwentaitakeri eeni isheripiyariwetaga. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iri kantacha rareetapaaka Felipe, ikenkithatapaakero Kameethari Ñaantsi kenkithatakotziriri Jesucristo, kenkithatakotziri eejatzi Pawa tsika inkantaiya impinkathariwentantai. Romitsitsiyaayetanaka shiramparipaini, eejatzi tsinanepaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Rimatzitanakawo eejatzi Simón irirori, ikemisantawetanaa, omitsitsiyaawetaka eejatzi. Kisokero rowanakeri Felipe itsipatari, iñaakeri ritasonkawentantayetzi. Iyokitzii ikantawentanakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ikanta Otyaantaperoriite saikatsiri Jerusalén-ki, ikemakotakeri Samaria-satzi ikemisantayetairo riñaane Pawa. Irootake rotyaantantakariri Pedro eejatzi Juan. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ikanta rareetaiyakani Samaria-ki, ramanakotapaakari kemisantzinkaripaini, ompoñaantyaari risaikashiretantyaariri Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tema apatziro romitsitsiyaayeetakeri raakotakeri iwairo Awinkatharite Jesús. Tekeramaita risaikashiretantyaariita iriroripaini Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ikanta Pedro eejatzi Juan, rotzimikapatziitoyetantakari rako apaanipaini. Risaikashireyetantanakari Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ikanta iñaakeri Simón rantakeri Otyaantaperoriite, ikaatzi rotzimikapatziitotantakari rako atziri, risaikashiretantaari Tasorenkantsi, ripinawetanakari irirori Otyaantaperoriite, ");
INSERT INTO cpbNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ikantanakeri: “Jirika koriki, pimpena eejatzi naaka pishintsinka, noshiyakotantemirori eeroka, ompoñaantyaari nisaikashiretakaantyaariri Tasorenkantsi nosheninka, notzimikapatziitotantyaari nako.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ari rakanakeri Pedro, ikantziri: “¡Ari pinkaatzimaitaiyaari piyorikite pimpeyashitaiya! ¿Poshiyakaatzi ari pamanantantakyaawo piyorikite ipashitantziri Pawa? ");
INSERT INTO cpbNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Eero pimataatsikaitziro poshiyakotenawo naaka, tema iñaakemi Pawa te pitampatzikashiretzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pipakagairo piyaariperonka, pinkowakotairi Pawa, añaamatsite ari impeyakotaimiro pikenkithashiryaawetakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Niyotakemi naaka, osheki pikisashirewaitaka. Ari pikantapiintatya pikaariperoshirewaitzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Irojatzi rakantanakari Simón, ikantanake: “Pamanakotaina eeroka Pinkathariki, ompoñaantyaari eero awishimotantana okaatzi pikantakenari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ikanta Pedro eejatzi Juan, ikaatakero ikenkithatakotakeri Pawa. Irojatzi ikenayetantanakari otsipaki nampitsi okaatzi saikatsiri janta Samaria-ki, ikenkithatakero janta Kameethari Ñaantsi. Ari ripiyaiyaani Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ikanta imaninkarite Pawa, riñaanatakeri Felipe, ikantziri: “Piyaate nampitsiki jitachari Gaza, iro pimpampithatanake awotsi poñaachari Jerusalén-ki irojatzi janta.” Tema jiroka awotsi irootake awisatsiri ochempiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jatake Felipe. Okanta niyanki awotsi, ritonkyotakari Etiopía-satzi. Iriiperori rinatzi. Iriitake kempoyiiriri koriki janta Etiopía-ki opinkathariwentantzira tsinane jitachari Candace. Ipoñagaawo irirori Jerusalén-ki iñaapinkathatzirira Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Iro riyaatairo irirori inampiki, risaikantakawo ranashitakomento, riñaanatziro rosankenare Kamantantaneri Isaías-ni. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Riñaanashiretanakeri Tasorenkantsi Felipe, ikantziri: “Piyaatashiteri shiyakotainchari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ikanta riyaatashitanakeri Felipe, ikematziiri Etiopía-satzi riñaanatziro rosankenare Isaías-ni. Ari ikantziri: “¿Pikemathatakero piñaanatziri?” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ari ikantzi Etiopía-satzi: “¿Tsika onkene nonkemathatero, tekaatsi yotainawone? Pipoke eeroka, pintsipatena.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jiroka okantzi Osankenarentsi riñaanatziri: Roshiyakagaitakeri ragaitziri oweja ritsitokaiteri. Roshiyakari oweja te ikaimawaitzi rameetaitziri, Ari ikantakari eejatzi irirori, maire ikantaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tsinampashireri ikantakagaitakari, te otampatzikatzi okaatzi ikantakoweetakariri. Ari rowamagaitakeri, temaita itzimi rowaiyane irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ikanta jirika iriiperori Etiopía-satzi, rosampitanakeri Felipe: “Pinkantena. ¿Iitaka ikenkithatakotziri Kamantantaneri? ¿Iriijatzima kenkithatakotacha? ¿Itsipama ikenkithatakotziri?” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ari retanakawo Felipe ikenkithatakaanakeniri rosankenareki Isaías-ni, ikenkithatakotanakeniri Kameethari Ñaantsi kenkithatakotziriri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Okanta osamaniityaake, ikenaitapaakero ñaa, ikantzi Etiopía-satzi: “Jiroka ñaa. ¿Eeroma okanta nomitsitsiyaatya naaka?” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Rakanakeri Felipe, ikantziri: “Pikemisantaperotanairika, ari onkantake.” Ikantzi Etiopía-satzi: “Nokemisantzi, iriitake Jesucristo Itomi Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ari rowaatzinkakotapaake rishiyakomento Etiopía-satzi. Ayiitanake apitepaini, jatanake ñaaki. Ari romitsitsiyaatakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ikanta ritonkaanai ñaaki, raanairi Felipe Tasorenkantsi. Jirika iriiperori Etiopía-satzi, te iñaanairi jimpe ikenanake. Iro kantacha jirika atziri kimoshire ikanta riyaatai irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iriima Felipe iñaashitaawo irirori risaikapai Azoto-ki. Irojatzi rawisantanakari otsipaki nampitsi ikamantantayetziro Kameethari Ñaantsi, irojatzi rareetantaari Cesarea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ikanta irirori Saulo, te ripakairo rasariimayetari rowamayeri riyotaanewo Pinkathari. Irootake riyaatashitantakariri Imperatasorentsiperori Judá-ite, ");
INSERT INTO cpbNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ikantakeri: “Posankenateniri Imperatasorentsitaarewo saikatsiri nampitsiki Damasco, pinkanteri: ‘Pishineteri Saulo raayeteri aapatziyanaariri iitaitziri “Awotsiweri”. Inkyaayete ipiyotaitapiintaga, roosoyeteri atziri eejatzi tsinanepaini, ramakeri jaka Jerusalén-ki.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iro rareetzimataka nampitsiki Damasco, ari romapokakeri morekanaintsiri inkiteki, roorentapaakeri ikatziyakaga Saulo. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tyaanake Saulo. Ikematzi ñaantsi inkiteki, ikantaitziri: “¡Saulo! ¡Saulo! ¿Oitaka poyaakyaaminthatantanari?” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Rakanake Saulo, ikantzi: “¿Piitaka eeroka Pinkathari?” Ari ikantaitanakeri: “Naakatake Jesús poyaakyaaminthatakeri. Eerokatakera owasankewaitacha apaniroini, oshiyawaitakawo pipaikayitzitatyeeyaawome thoyempithowari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ikanta Saulo, okawaitanaka ithaawanake, ikantanake: “Pinkathari, iita pikowiri nantairi naaka.” Ari ikantanakeri Awinkatharite: “Pimpiriintanai, piyaate nampitsiki. Ari inkamantaitemiro oita panteri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Osheki ithaawanake ikaatzi oyaatakeriri Saulo, tema ikemawakero eejatzi irirori ñaantsi, te iñiimaitari kenkithawaitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Irojatzi ikatziyantawetanaari Saulo. Ikowaweta rokiryaanaime, te onkantya raminanai. Irootake rakathatantanaariri itsipayetakari, raanakeri nampitsiki Damasco. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ari risaikeri janta okaatzi mawa kiteesheri, te okanta raminawaitai, te rowaiya, te rirai eejatzi imere. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Okanta janta Damasco-ki, ari risaiki yotaarewo iita Ananías. Iriitake riñaanatakeri Awinkatharite rimishireki, ikantziri: “¡Ananías!” Ari rakanakeri irirori: “¿Iitaka, Pinkathari? Jaka nisaiki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ikantziri: “Piyaate awotsiki iitaitziri ‘Tampatzikari’. Ari isaiki ipanko jitachari Judas, ari posampikowenteri atziri jitachari Saulo, iri poñaachari nampitsiki Tarso. Ari risaikiri irirori ramanawaita. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nomishimpyaakeri irirori. Iñaakemi pikyaashitapaakeri, potzimikapatziitotantakari pako, irojatzi raminawaitantanaari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ikanta ikemawake Ananías, ikantanake: “Pinkatharí, osheki nokemi ikenkithatakoitziri jirika atziri, koweenka okanta rantayetakeri Jerusalén-ki rowasankeyetziri pikiteshiretakaanewo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","“Iro ripokantari iroñaaka jaka, tema rotyaantatziiri Imperatasorentsiperori raayeteri aakotzimiri piwairo rawentaanaimi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ikantzi Pinkathari: “Piyaate. Tema jirika atziri iriitake niyoyaakeri naaka inkenkithatakotaina maawoiniki nampitsi. Inkenkithatakairi Israel-iite isheninkatari irirori, eejatzi itsipasatzi atziri kaari isheninkata, eejatzi iwinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ari noñaagakeri eejatzi jimpe onkaate inkemaatsiwentaina naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Irojatzi riyaatantanakari Ananías pankotsiki risaikakera Saulo. Kyaapaake, rotzimikapatziitotantapaakari rako. Ikantziri: “Iyekí, rotyaantakena Awinkatharite Jesús, oñaagakemiri awotsiki pikenapaakera. Iro rotyaantantanari ompoñaantyaari pokiryaantaiyaari, risaikashiretantaimiri eejatzi Tasorenkantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ari oparyaanake rokiki oshiyawetariri shimapentaki, aminanai kameethaini. Irojatzi ikatziyantanakari, jatanake romitsitsiyaataiteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ari rowawaitanaa, irojatzi ishintsitantaari kameethaini. Eepichokiinira risaikimowaitapaintziri kemisantzinkaripaini nampitawori Damasco-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ari retanakawo Saulo ikenkithatakaantanake rapatotapiintayeta Judá-ite, ikantzi: “Iriitake Itomi Pawa jitachari Jesús.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Riyokitziiwentanakeri ikaatzi kemiriri, ikantawaka: “¿Tema iriitake jirika kisaneentziriri Jerusalén-ki ikaatzi aakotziriri iwairo Jesús? ¿Tema irijatzi pokaintsiri jaka rayeri kemisantzinkari Imperatasorentsiperorikinta?” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Iri kantacha Saulo eekero ishintsitatzi ikenkithatakaantzi tekaatsi inthaawantya. Te riyotzi oita inkanteri Judá-ite nampitawori Damasco-ki, ikemiri Saulo ikantzi: “Jirikaganki Jesús Cristo rinatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Okanta awisanake osheki kiteesheri, ikantawakaaka Judá-ite: “Jame atsitokeri Saulo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tema kiteesheriki eejatzi tsireniriki royaawentakeri rishitowapiintaitzira nampitsiki, ritsitokeri. Iri kantacha Saulo riyotake ikowatzi rowamagaiteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ikanta kemisantzinkaripaini, rotetakeri antawoki kantziri, roinkitaakotakeri tsireniriki jakakeroki rotantotaitzirowa nampitsi. Ari okanta rishiyantakari Saulo. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ikanta rareetaawo Saulo Jerusalén-ki, ikowawetaka intsipatapaiyaarime riyotaanewo Pinkathari. Iro kantacha osheki ithaawantakari, roshiyakaatzi te ikemisantaperotai irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iro kantacha tzimatsi kemisantzinkari jitachari Bernabé, raapatziyanakari Saulo, jatake roñaagantairi ipiyotaga Otyaantaperoriite. Ikantapaakeri: “Jirika Saulo iñagairi Awinkatharite awotsiki jatachari Damasco-ki, ari ikenkithawaitakaakeriri. Ari retanakawo Saulo nampitsiki Damasco raakotanairi iwairo Jesús ikenkithatakotanairi. Tekaatsi inthaawantanakya.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ari ikantaka Saulo risaikantapaari Jerusalén-ki, itsipayetapaari jirikapaini Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Raakotakeri iwairo Pinkathari Jesús ikenkithatakotziri, tekaatsi inthaawantya. Ikenkithatakaayetziri Judá-ite Grecia-weri. Iro kantacha ikowake jirikapaini ritsitokeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ikanta riyotaiyakeni kemisantzinkaripaini, raanakeri Saulo janta Cesarea-ki. Irojatzi rotyaantantaariri Tarso-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ikanta kemisantzinkaripaini, nampiyetawori Judea-ki, Galilea-ki eejatzi Samaria-ki, kameetha ikanta risaikawaitaiyini, eekero rantakishireperotanakitzi, pinkatha rowapiintanakeri Pinkathari, ikempoyaawentziri Tasorenkantsi. Eekero riyaatatzi isheniperotanake. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ikanta rareetantayetaka Pedro nampitsipainiki, irojatzi rareetantaka Lida-ki inampiyetawowa ikiteshiretakagaitairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ari iñaapaake jitachari Eneas, kisopookiri rinatzi, tzimakotake 8 osarentsi romaryaawaitaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Riñaanatapaakeri, ikantziri: “¡Eneas, retsiyatakotakagaimi Jesucristo. Pinkatziye, paanairo pomaryaamento!” Ari ikatziyanakari Eneas. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ikaatzi nampitawori Lida-ki eejatzi Sarón-ki, iñaayetakeri ikatziyawaitanaa Eneas, iroowa ikemisantantanakariri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Okanta nampitsiki Jope, tzimatsi tsinane yotagaarewo oita Tabita, riñaaneki Grecia-thato iitaitziro “Dorcas”. Jiroka tsinane opashitantapiinta, oneshironkatantapiintzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Okanta apaani kiteesheri, omantsiyatake Dorcas, kamake. Raayeetakero, ikaawoshitaitakero, romaryagaitapaintziro jenoki opankoki. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Okanta janta Jope-ki te intainaperote nampitsi Lida, rareetakaga Pedro. Ikanta ikemaiyakeni yotaarewopaini ari risaikiri Pedro janta, rotyaantake apite atziri inkantakiteri: “Pipokeeta intsipaite Jope-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jatanake Pedro. Ikanta rareetapaaka janta, ragaitanakeri jenoki romaryagaitakerowa. Opiyowentapaakari maawoini kinankawo, iragaiyapaakani, oñaagayetapaakeri kithaarentsi ishirikanewo Dorcas. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ikanta Pedro romishitowakero maawoini, ari rotziwerowanaka, ramananaka. Irojatzi ripithokashitantanaawori kaminkawo, ikantziro: “¡Tabita, pimpiriintai!” Ari okiryaanake, oñaatziiri Pedro, piriintanaka saikanai iroori. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Rakathawakotanakero, ikatziyakero. Ikaimayetairo kinankawo eejatzi ikaatzi ikiteshiretakagaitanewo, iñaayeetairo añagai. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ikanta ikemakoyeetakero nampitsiki Jope, osheki kemisantanakeriri Pinkathari. ");
INSERT INTO cpbNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Osheki kiteesheri risaikawaitanake Pedro nampitsikika, iri risaikimotake jitachari Simón “Mashicheempeki”. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tzimatsi Cesarea-ki atziri jitachari Cornelio, iriitake reewarite owayeripaini Roma-satzi iitaitziri “Italia-satzi”. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jirika atziri pinkathatasorentsiwaitaneri rinatzi, ari ikaataiyini maawoini isheninkapaini ipinkathatziri Pawa. Ipapiintziri ashironkainkari osheki iyorikite okantawetaka te isheninkatari. Ramanapiintari Pawa irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Okanta apaani kiteesheri, thataawo ooryaa, ishaawiityaake, ari romapokakeri imaninkarite Pawa ikyaashitapaakeri risaikakera irirori, iñaawakeri koñaawoini, ikantapaakeri: “¡Cornelio!” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Iyokitzii ikantanaka Cornelio, ithaawankakiini rosampitanakeri, ikantziri: “¿Pinkatharí, iitaka pikowakotanari?” Ikantanakeri maninkari: “Ikemakemiro Pawa pamananewo, iñaakemi pineshironkatantapiintzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Potyaante ponampire nampitsiki Jope ramantyaariri Simón, iitaitziri eejatzi Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ari rimayimotziri itsipa Simón, ‘Mashicheempeki’ saikacheraatzirori inkaare. Iri kamantemine oita pantairi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ikanta rishitowanai maninkari, ikaimake Cornelio apite ronampire. Ikaimake eejatzi owayeri, rawentaanewo rowiri, pinkathatasorentsiwaitaneri rinayetzi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ikamantakeri okaatzi ikantaitakeriri. Rotyaantakeri Jope-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Okanta okiteeshetamanai, tampatzikatapaake ooryaa, areetzimataiyakani Jope-ki rotyaantaitakerira. Ari rateetanake irirori Pedro ramaña otaapiipankaki pankotsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ikemaminthatakero ritashe, ikowake roya, iro kantacha owakera ronkotsitaitzi royaari, ari iñaawyaatakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Iñaakero ashitaryaanaka inkite, rowayiitaitziro oshiyawetawori antawo manthakintsimanki, ithatotaitakero opatzikaakipainiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Okanta manthakintsimankiki eenitatsi osheki itsipasatzipaini tsimeri, tzimatsi anashiyetachari kipatsiki, eejatzi shiwankiyetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Irojatzi ikemantakari riñaanataitanakeri, ikantaitziri: “Pedro, pinkatziye, powamayeri jirikapaini, poyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Rakanake Pedro: “Eero Pinkatharí. Te nowapiintari naaka jirika ipinkaitziri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Rapiitaitanakeri Pedro riñaanataitziri, ikantaitziri: “Tema jirikapaini ikaatzi rishinetaantziri Pawa, eero piitashiwaitari eeroka ‘Ipinkaitziri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mawa apiitaka jiroka. Irojatzi ragaitantanaawori manthakintsimanki inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Antawo okantzimoshiretanakari Pedro, ikenkithashiryaawaitanaka oita oshiyakaawentachari okaatzi iñaakeri. Irojatzi rareetantapaakari rotyaantanewo Cornelio, rosampikowentapaakero ipanko Simón. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ikanta rareetapaaka pankotsiki, ikaimaiyapaakitziini rosampitantapaake, ikantzi: “¿Ari rimayiri jaka Simón, iitaitziri Pedro?” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ikenkithashiryaakominthaitawo Pedro iñaakeri, riñaanashiretanakeri Tasorenkantsi, ikantziri: “Pamine, areetapaaka mawa atziri aminaminatzimiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pinkatziye, payiite. Eero pikisoshirewaitzi, pintsipatyaari, tema naaka otyaantakeriri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ari rayiitapaake Pedro, ikantapaakeri areetapainchari: “Naaka pithotyaakotzi. ¿Iitaka pipokantari?” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ikantaiyanakeni irirori: “Nipokantari rotyaantatyaana Cornelio, reeware owayeripaini. Tampatzikashireri rinatzi, pinkathatasorentsiwaitaneri rinatzi, iri aakameethatapiintziriri pisheninkapaini Judá-ite. Tema chapinki ripokashitakeri imaninkarite Pawa, ikantakeri: ‘Pinkaimakaanteri Pedro, ripokantyaari pipankoki, ari pinkemeri oita inkamantemiri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ikanta Pedro ikyaakaanakeri pankotsiki, ari rimagaiyapaakeni. Okanta okiteeshetamanai, jatake Pedro royaataiyanakerini pokashitakeriri, itsipatanakari eejatzi Jope-satzi, “iyekiite” rinatzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Okanta otsipa kiteesheri areetaiyakani Cesarea-ki. Oyaatsi Cornelio itsipayetakari isheninkapaini, eejatzi aapatziyariri ikaatzi ikaimayetakeri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Areetapaaka Pedro pankotsiki, rishitowashitanakeri Cornelio, rotziwerowashitawakari, impinkathatawakerime. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Iri kantacha Pedro ipiriintakeri, ikantziri: “Pinkatziye, atziri ninatzi eejatzi naaka, ari noshiyimi eeroka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ikanta ikenkithawaitakaawakeri Cornelio, ikyaakaanakeri ipankoki, iñaapaakitzi osheki atziri piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ikantanake Pedro: “Piyotaiyini eeroka, naakapaini Judá-ite te rishinetaitana nontsipatemi eerokapaini kaari nosheninkata, te onkantya nonkyaawankotemi. Iro kantacha owakeraini riyotaakena naaka Pawa, te onkameethate nonkantayetemi: ‘Nowinkane pinatzi.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iroowa kaari nishenkaantanaka pikaimakaantakenaga. Iroñaaka nokowi niyote oita pikaimakaantantanari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Rakanake Cornelio, ikantzi: “Chapinki, tzimake 4 kiteesheri, ari ikaatake ooryaa iroñaaka, ishaawiityaake. Nisaiki naaka nopankoki nitziwentawaita, namana otsireniityaanaira, ari ikoñaatzimotakena atziri, shipakiryaa okantapaaka iithaare. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ikantapaakena: ‘Cornelio, ikemakemi Pawa pamanari, ikenkithashiryaakero pineshironkatantapiintzira. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Potyaante nampitsiki Jope amerine Simón, iitaitziri eejatzi Pedro. Ari rimayiri itsipaki Simón, mashicheempeki nampitawori inkaarecheraaki.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Intsipaite notyaantake iñagaitemi, pimatakero eeroka pipokanake intsipaite. Naakaga ipiyotakaakari Pawa iroñaaka. Janjaatya pinkantenawo okaatzi ikantakemiri Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Irojatzi ikantantanakari Pedro: “Ari niyotziri iroñaaka rimaperotatya Pawa te ramaakinetziri atziri, ");
INSERT INTO cpbNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","raakameethatziri pinkathatanairiri, tampatzikashiretatsiri, okantawetaka jimpe inampiyetawo, kaari nosheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tema jiroka Ñaantsi kenkithatakotziriri Jesucristo, okaatzi jatakotaintsiri nosheninkapainiki Israel-iite, iriira Pawa kantakaawori nokenkithatakotantaariri. Tema iriitake pinkathariwentaine maawoini, iriira saikakaayetaine kameetha. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Piyoperotaiyini eeroka okaatzi awisaintsiri noipatsiteki. Tema pikemakowentakero pairani ikenkithatakotakero Juan-ni okantakota omitsitsiyaataantsi. Irojatzi opoñaanaka Galilea-ki, ");
INSERT INTO cpbNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","iñagaitakeri Jesús Nazaret-satzi. Iri Pawa pakeriri ishintsinka eejatzi Itasorenka. Irojatzi ikenakenayetantanakari irirori ineshironkatantayetzi, rowawisaakoyetake osheki raagayetziri peyari. Iroowa rantantakawori jiroka tema Pawa tsipatakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naakayetake ñaaperotawakeriri rantayetakeri Jesús janta Judea-ki eejatzi Jerusalén-ki. Irojatzi rowamagaitantakariri, ikentakoitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iro awisawetaka mawa kiteesheri rowañagairi Pawa, ikantakaakawo irirori noñaayetairi naakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Te roñaagapanaantari maawoini atziri, apatziro naakapaini, ikaatzi riyoyaakeri pairani Pawa iñaayetairi. Ikanta rañagaira, notsipatawaari nowaiyani eejatzi nirawaitaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iriira otyaantakenari nonkamantayetairi atziripaini, nonkantairi: ‘Iri Jesús rowake Pawa kantakowentairine maawoini añaayetatsiri, eejatzi kamayetaintsiri.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Irijatzi Jesús ikenkithatakotzitakari pairani Kamantantaneriite, ikantake: ‘Inkaate kemisantairine jirika, raakoyetairi iwairo, aritake impeyakotainiri iyaariperonka.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ikenkithawaiminthaitzi Pedro, risaikashiretantapaakari Tasorenkantsi maawoini kemisantakeriri ikenkithatzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iyokitziitanake ikaatzi oyaatakeriri Pedro, iñaakerira risaikashiretantapaakari Tasorenkantsi kaari isheninkata, oshiyawaitakawo risakoperoitatyeenirime, ");
INSERT INTO cpbNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ikemaiyakerini riñaawaitantanakawo otsipasato ñaantsi, ithaamentanakari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ikantanake Pedro: “¿Kantachama athañaapithatyaari romitsitsiyaatya jirikapaini atziri, oshiyakairi aakapaini risaikashiretantaira Tasorenkantsi?” ");
INSERT INTO cpbNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Rotyaantakeri romitsitsiyaataiteri jirikapaini raakotakeri iwairo Jesucristo. Ikanta jirikapaini ikantakeri Pedro: “Pisaikimowaitanakena.” ");
INSERT INTO cpbNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ikanta ikemaiyakeni itsipa Otyaantaperoriite eejatzi iyekiite nampitawori Judea-ki, ikantaitzi: “Ikemairo riñaane Pawa kaari asheninkata, ikemisantayetai irirori.” ");
INSERT INTO cpbNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iro kantacha rareewetaaga Pedro Jerusalén-ki, riñaanaminthatawairi Judá-ite kemisantayetaatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ikantawairi: “¿Iitaka pareetantariri kaari asheninkata, pakiyooyetakeri eejatzi?” ");
INSERT INTO cpbNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ari ikamantanakeri Pedro oita opoñaantari. Ikantanakeri: ");
INSERT INTO cpbNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nisaiki naaka nampitsiki Jope, namana, ari noñaawyaatakari. Noñaake oshiyawetawori antawoite manthakintsimanki, ithataitakero opatzikaakiki, rowayiitaitakero okenapaake inkiteki irojatzi tsika nisaikake naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ari naminaperotanakero, noñaake osheki tsimeri, noñaake anashiyetachari kipatsiki, eejatzi shiwankiyetatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Irojatzi nokemantakari ñaanatakenari, ikantana: ‘Pedro, pinkatziye, powamairi jirikapaini, poyaari.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ari nakanake naaka: ‘Eero Pinkatharí, tema te namonkotapiintziri naaka ipinkaitziri.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Rapiitaitanakena riñaanataitana, ikantaitana: ‘Tema jirikapaini ikaatzi rishinetaantairi Pawa, eero piitashiwaitari eeroka “Ipinkaitziri”.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mawa apiitaka jiroka. Irojatzi ragaitantanaawori inkiteki okaatzi noñaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ari rareetaiyapaakani mawa atziri thotyaakotanari, rotyaantaitakeri ipoñaakawo Cesarea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Riñaanashiretakena Tasorenkantsi, ikantakena: ‘Poyaatanakeri jirikapaini, eero pikisoshirewaitanake.’ Irootake nantakeri. Jirika 6 iyekiite notsipatanakari. Iri notsipatakari nokyaapankotakeri atziri kaari asheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ikamantawakena, ikantana: ‘Chapinki, noñaake maninkari ikatziyapaaka jaka nopankoki, ikantakena: “Potyaante jatatsine nampitsiki Jope raakiteri Simón, iitaitziri eejatzi Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iriitake kamantemirone tsika pinkantya pawisakoshiretantaiyaari, pitsipataarira maawoini pisheninkapaini.” ’ ");
INSERT INTO cpbNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ikanta nokenkithawaitakaapaakeri, ari omapokapaaka risaikashiretantapaakari Tasorenkantsi iriroripaini, ariwaitake risaikashiretantakairi ketziroini aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ari nokenkithashiryaanakero ikantakeri pairani Awinkatharite: ‘Imapero Juan romitsitsiyaatantawo ñaa, iro kantacha ari piñaayetakero eeroka risaikashiretantemi Tasorenkantsi oshiyawaityaawome romitsitsiyaatantaitatyeemirime.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tema iriitake Pawa neshironkatakeriri eejatzi iriroripaini itsipayetai aakapaini akemisantayetairi Pinkathari Jesucristo. ¿Iitaka nonkoshekantyaariri Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ikanta ikemaiyawakeni iyekiite nampitawori Jerusalén-ki, tekaatsi inkantaiyanakeni. Ithaamentaiyanakarini Pawa, ikantaiyanakeni: “¡Imaperotatyaawé! ¡Ineshironkatairi Pawa kaari asheninkata! ¡Kantacha iriroripaini ripakagairo iyaariperonka, ompoñaantaiyaari rañaashireyetai!” ");
INSERT INTO cpbNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Rowamagaitakerira Esteban, ari retaitanakawo royaakyaataitziri kemisantzinkaripaini. Iro opoñaantanakari rishiyayetanaka kemisantzinkaripaini janta Fenicia-ki, Chipre-ki eejatzi Antioquía-ki. Ari ikenkithatakaayetakeri Judá-ite jimpe okantakota Kameethari Ñaantsi, temaita ikenkithatakairi kaari isheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Iro kantzimaitacha, ari rareetaiyakani Antioquía-ki, kemisantaatsiri poñaachari Chipre-ki eejatzi Cirene-ki. Ikenkithatakaapaakeri kaari isheninkata, ikenkithatakeniri Kameethari Ñaantsi tsika ikantakota Jesús, Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Okantakaaperotanakari ishintsinka Awinkatharite jirikapaini, ripakaakagairi itsipasatzi atziri ramewaitashitari. Osheki kemisantanairiri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ikanta kemisantanaintsiri Jerusalén-ki, ikemakotaiyakerini, rotyaantakeri Bernabé janta Antioquía-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Areetaka Bernabé, iñaapaakeri tsika ikanta Pawa ineshironkayetakeri jirikapaini, antawoite ikimoshiretapaake. Ikaminaayetapaakeri maawoini ompoñaantyaari roisokeroshireyetantyaariri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tema jirika Bernabé neshironkatantaneri rinatzi, rawentaashiretari Awinkatharite, risaikashiretantari Tasorenkantsi. Irootake isheniperotantanakari kemisantanairiri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ikanta Bernabé, jatake Tarso-ki iñeeri Saulo. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ikanta iñaapairi, ramairi Antioquía-ki. Ari risaikimowaitakeri riyotaanewo apaani osarentsi, riyotaayetake osheki atziri. Ari etanakawo janta Antioquía-ki iitaitziri kemisantzinkari “Cristo-weripaini”. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Okanta apaani kiteesheri, rareetaiyakani Antioquía-ki kamantantaneripaini ipoñaanakawo Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ikanta apaani kamantantaneri jitachari Agabo, ikatziyanaka ipiyotaiyanira, ikantanake: “Ari iñagaitake antawoite tashetsi maawoiniki nampitsi.” Iri Tasorenkantsi ñaanashiretakeriri riyotantakawori. Iroowa monkaatainchari pairani ipinkathariwetantakari Claudio. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Irootake ikenkithashiryaantaiyakarini Antioquía-satzi ineshironkateri Judea-satzi rotyaanteniri iyekiite okaatzi rimayetziri. ");
INSERT INTO cpbNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iro rantaiyakerini, rowaitakeri Bernabé itsipatakari Saulo iri aminakaanterone. Rotyaantakeniri itzinkamipaini janta Judea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ikanta pinkathari Herodes royaakyaatakeri kemisantzinkari. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ikantakaantakeri rithatzinkaiteri Jacobo, irirentzi Juan. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ikanta iñaakero Herodes kameetha inimotakeri Judá-ite, rotaiyakaantakeri Pedro. Aripaite imonkaatakari jiroka roimoshirenkantawori rowantapiintawori tashirentsiponka. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ari rotaiyakaantaitakeri Pedro, romonkyaakaantakeri. Rowaitake 16 owayeripaini aminerine. Ikenkithashiryaaka Herodes roñaaganterime atziripainiki onkaatakerika roimoshirenkaita kiteesheriki Anonkoryagaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Romonkyaaminthaitziri Pedro, amanaiyachani kemisantzinkaripaini ipiyowentaiyarini Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Okanta imonkaatzimatapaaka raantyaariri Herodes jirika Pedro roñaaganteri atziripainiki. Maatsi Pedro tsireniriki rosatekakeri apite owayeri, roosotantakari apite kotsirotha. Saikaiyatsini itsipa owayeripaini ikyaapiintaitzira aminiriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ari romapokaka ripokake imaninkarite Awinkatharite, kiteeshaaniki ikantakaapaakawo. Rotzinkamerekitapaakeri Pedro, rowakiryaapaakeri, ikantziri: “¡Pinkatziye!” Oparyaashiwaitanaka kotsirotha roosotantaitakariri rakoki. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Rapiitakeri maninkari, ikantziri: “Pinkithaatya, pizapato-tya.” Ari ikantakero Pedro. Eekero ikantatzi maninkari: “Pinkithaatyaawo piwewiryaakowo, poyaatena.” ");
INSERT INTO cpbNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Shitowanake Pedro royaatanakeri maninkari. Te riyotzi kyaaryooperorika okaatzi rantziri maninkari. Oshiyimowaitakari iñaawyaatatyeeyaame. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iro kantacha rawisanake apaani aminiriri, rawisanake itsipa. Iro rishitowimate, rareetapaakawo kotsirotakitatsiri ashitakowontsi, ashitaryaashiwaitanaka apaniroini. Shitowanake. Ikanta ranashitanaka, iro itaponeentanaka, ari rookanairi maninkari apaniroini. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ari ikenkithashiryaanakari Pedro, ikantanake: “Ari niyotzi iroñaaka imaperotatya rotyaantakeri Pinkathari imaninkarite, rookaawiritaantakena Herodes-ki, rookaawiritaantakena eejatzi tsikame inkantawaitename Judá-ite.” ");
INSERT INTO cpbNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ikanta riyotanakero Pedro jiroka, jatanake opankoki María, inaanate Juan, iitaitziri eejatzi Marcos, ari ipiyota ramana. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kaimapaake ikyaapiintaitzira. Okanta ewankawo jitachari Rode, jatanake amineri iitarika. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ari iyowaantetawairi Pedro rinatzi, antawoite okimoshiretanake, te ashitaryaanakeniri inkyaantapaakyaari, piyanaka inthomoiki okamantantzi, okantapaake: “Pedro rinatzi kaimatsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ari ikantaitawakero: “¡Te pishinkiwenta!” Eekero oshintsitatzi iroori, okantzi: “Imaperotatya.” Ikantaiyini irirori: “Aamaaka ramanka Pedro.” ");
INSERT INTO cpbNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eekero ishintsitatzi Pedro ikaimi. Ikanta rashitaryagaitakeniri, iñagaitatziiri Pedro rinatzi, riyokitziitaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Rowaatzinkawakotanaka Pedro, imairetantyaari. Irojatzi ikenkithatakotantanakawori jimpe ikantakero Awinkatharite romishitowantaariri. Eekero ikantanakitzi Pedro: “Pinkamanteri jiroka Jacobo eejatzi itsipa iyekiite.” Ari rishitowanai, jatanake otsipaki nampitsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Okanta okiteeshetamanai, osheki okantzimoshiretaiyakerini aminiriri, tema te riyotaiyini jimpe ikenake Pedro. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Inintakaantakero Herodes rithotyaakoitairi, iro kantacha te iñagaitairi. Irootake rookoitantanakariri aminiriri, rowamaakaantaitakeri. Okanta awisake jiroka, shitowai Herodes Judea-ki, jatake inampitapaintyaawo Cesarea-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ari ikantatya Herodes ikoshekawaitakari nampitawori Tiro-ki eejatzi Sidón-ki. Ikanta ikenkithashiryagaiyakani ikoshekaminthatane raakameethayetairi, tema ari riyomparitaiyapiintani. Rotyaantaiyakeni jatashiyeterine Herodes raapatziyaiyaari. Ikanta saikawankotziriri Herodes, rawentaaperotanewo, jitachari Blasto, raakameethayetawakeri pokashitakeriri. Ikantakowentakeri Herodes-ki tsikapaiterika inkenkithatakaantyaariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Monkaatapaaka kiteesheri ikaimakaantakeri Herodes inkenkithawaitakairi. Ari ikithaatanakawo owaneenkari iithaare ikenkithawaitantapiintari, saikapaake risaikamentoki ipiyotaiyakanira, kenkithawaitanake. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ari ikaimakotaiyirini atziripaini, ikantzi: “¡Jirinta kenkithawaitaintsiri, Pawaga rinatzi, kaari atziri!” ");
INSERT INTO cpbNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Te onkantzimotaatsikaityaari Herodes roshiyakaantaitakariri Pawa ithaamentaitakari. Irootakera romapokantanakari romantsiyaakeri imaninkarite Awinkatharite, chowiwaitanake, kamake. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iro kantacha, eekero iyaatakotanakitzi riñaane Awinkatharite, eekero isheniperotanakitzi kemisantzinkaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ikanta Bernabé eejatzi Saulo rimonkaatakero rantakero rotyaantantaitakariri Jerusalén-ki, piyaiyaani Antioquía-ki, ari itsipataari Juan iitaitziri eejatzi Marcos. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tzimatsi kamantantaneriite janta Antioquía-ki rapatotapiintaiyanira kemisantzinkaripaini, tzimatsi eejatzi yotaantaneriite. Jirika ikaataiyini: Bernabé, Simón iitaitziri eejatzi Kisaakiri, Lucio poñaachari Cirene-ki, Manaén iyempiyane pairani Herodes roimonkaiyakanira, ipoñaapaaka Saulo. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ikanta ipiyowentaiyarini Awinkatharite, ritziwentaiyani, riñaanashiretakeri Tasorenkantsi, ikantakeri: “Powenari Bernabé pintsipataakenari Saulo nantawaitakaantyaariri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ikanta rithonkakero ramanaiyani, ritziwentaiyani, rotzimikapatziitoitantakari rako jirikapaini, rotyaantaiyakerini. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ikanta rotyaantanewo Tasorenkantsi, jataiyakeni Seleucia-ki, ari rotetaiyanakani riyaatero Chipre-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Aatakotaiyapaakeni Salamina-ki. Retapaakawo ikamantantapaakero riñaane Pawa rapatotapiintaiyanira Judá-ite. Ari riyaatzitanakari irirori Juan ramitakoteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ranonkanakero eentamentare, irojatzi rareetantakari Pafos-ki. Ari iñaake kamantantaneri sheripiyari Judá-ite, thairi rinatzi, iita Barjesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jirika sheripiyari raapatziyanewo rinatzi pinkathari Sergio Paulo. Osheki riyorenka jirika pinkathari, ikaimakaantakeri Bernabé eejatzi Saulo, ikowi inkemero riñaane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iri kantacha jirika sheripiyari jitachari Elimas riñaaneki Grecia-thato, ikowake rotzikawakeri pinkathari eero ikemisantanta. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ikanta Saulo, iitaitziri eejatzi Pablo, ipampoyaanakeri jirika, ikantakaaperotanakari Tasorenkantsi, ");
INSERT INTO cpbNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ikantanakeri: “¡Thairí! Kaariperori, itomi kamaari pinatzi. Pimanintakero kameethari. ¿Eeroma pipakairo potzikayetziro tampatzikatzimotziriri Nowinkatharite? ");
INSERT INTO cpbNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iroñaaka rowasanketaitemi, osamani pinkantya pimawityaakite.” Apathakero ikantanaka, te ikowichaatanai. Rithotyaakowaiweta akathawakotairine. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ikanta iñaakero pinkathari awisaintsiri, ikemisantanake. Riyokitziiwentaitanakero ikenkithatakoitziri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ikanta rishitowanai Pablo janta Pafos-ki itsipatakari ikaataiyinira otetanaka riyaatero Perge-ki saikatsiri janta Panfilia-ki. Iri kantacha Juan, te royaatanairi, piyanaka irirori Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ikanta rareetaka Perge-ki awisanake otsipaki nampitsi Antioquía-ki saikatsiri janta Pisidia-ki. Ikanta ikyagaiyakeni rapatotapiintaga Judá-ite kiteesheriki rimakoryaantaitari, saikapaake. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tema rithonkaitakero riñaanaitziro rosankenare Kamantantaneriite, Inintakaantaitanewo eejatzi, ikantake jewatakaantatsiri rapatotapiintaitaga: “Iyekiite, eenitatsi pinkanteri ompoñaantyaari inthaamentantyaari atziripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Irojatzi ikatziyantanakari Pablo, rowaatzinkawakotanaka imairetantaityaari, ikantanake: “¡Shiramparipaini! ¡Israel-iite! ¡Maawoini pinkathatairiri Pawa! ");
INSERT INTO cpbNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iriitake Pawa yoyaakeriri pairani etakaantawori acharineeteni, Israel-iite. Iriitake oshekyaakeriri. Irojatzi roñaagantantakawori ishintsinka rookaawiritaantairi Egipto-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Irojatzi ripiyathawaitantakariri Pawa janta ochempiki okaatzi 40 osarentsi. Iri kantacha Pawa ikisashitakawo ripiyathayetakari. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Irojatzi rithonkantakariri Pawa sheninkatawakaachari janta Canaán-ki ikaatzi 7, irootake iipatsitetakaayetaariri acharineeteni. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Maawoini jiroka nokenkithatakotakemiri awisake 450 osarentsi okaatzi osamanitake. Irojatzi rowantakariri jewaripaini aminakoterine, irojatzi riweyaantantapaakawori Samuel-ni, Kamantantaneri. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iro kantzimaitacha ikowawetaka apaani iwinkathariteperotyaari. Iroowa rowantakariri Pawa jitachari Saúl, itomi Cis, icharinetari Benjamín. Iri pinkathariwentakeriri okaatzi 40 osarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Iri kantacha Pawa rowinkatharyaakeri Saúl-ni, ripoyaatantaari David-ni. Tema iri David-ni ikenkithatakotake pairani Pawa, ikantzi: Noñaakeri David itomi Isaí, rinimotakena, Iriitake materone nokowiri naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ikanta itzimake Jesús, icharinetakari David-ni. Iriitake ikashaakaakeri Pawa rotyaanteri rowawisaakoyetai aakapaini Israel-iite. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tekeraata ripokeeta Jesús, ikenkithatakotzitakari Juan-ni, ikantake: ‘Ontzimatye pipiyashireyetai, pomitsitsiyaawentaiyaari Pawa.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ikanta Juan-ni rithonkimatakero rantawaitanewo, ikantanake: ‘¿Piñaakityaanama naakatake jirika? Te naaka. Awotsikitake nopinkathaperotziri naaka, te onkantaatsikaitya roshiyakayena rimperatanewo no-zapato-ryaantyaariri.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","¡Iyekiite! ¡Isheninkapaini Abraham! ¡Maawoini eerokapaini ikaatzi pinkathatairiri Pawa! Aakatakera rotyaantaitakai jiroka Ñaantsi awisakoyetantaiyaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tema ikaatzi nampitawori Jerusalén-ki eejatzi reewarepaini, te riyotawakeri Jesús riyakowentaiyakerini. Iro opoñaantari kaari riyotantawo rimonkaatero okaatzira rosankenatakotakeriri Kamantantaneriite, okantaweta reshiwentapiintawetawo riñaanawetawo ipiyotaiyanira kiteesheriki rimakoryaantaitari. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Irojatzi ikowakotantakariri Pilato ritsitokaiteri Jesús, okantawetaka tekaatsi inkenakaashitya irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ikanta rithonkakero rantayetakero okaatzi rimonkaatakaakari rosankenatakoitakeriri pairani, inowikyaakotakeri ikentakoitakerira, ikitatakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Iri kantacha Pawa rowiriintairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ari retanakawo Jesús roñaagapanaantari ikaatzi tsipatakariri pairani ipoñaantakari Galilea-ki irojatzi Jerusalén-ki. Osheki okaatzi kiteesheri roñaagapanaantari. Iriitajaantakera kenkithatakoyetairiri iroñaaka tsikarikapaini risaikayetzi atziri. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Irijatziita nokenkithatakotzimiri iroñaaka eerokapaini, nokenkithatakotzimiro Kameethari Ñaantsi jimpe okantakota ikashaakaakeriri Pawa acharineeteni. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ari rimonkaatakero Pawa okaatzi ikashaakaakeriri, tema rowiriintairi Jesús roñaagayetai aakapaini, tema icharine anaiyini. Irootake osankenatakotachari Salmo-ki, okantzi: Notomi nowimi eeroka. Naaka pipaapatetanaa iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ari ikenkithatakotzitakari Pawa rowiriintairi Jesús, eero oshitziwaitanta iwatha. Ikantake ikenkithawaitake: Okaatzi nokashaakaakeniriri David-ni, iroowa nantemiri eeroka. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Otsipaki Salmo okoñaatakoperotzira jiroka, okantzi: Eero pishinetziri ishitziwaite iwatha pitasorentsite. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Imaperotatya, kaari David-ni onkenkithatakote jaka, tema rañaakaakeri Pawa jirika David-ni, rimakoryaagai eejatzi, itsipataari icharineete jimpe ikitayetaa, ari ishitzitairi iwatha. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Irooma iwatha jirika rowiriintairi Pawa, te ishitziwaite iwatha irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Iyekiite, ontzimatye piyoyetai eerokapaini, iri nokenkithatakotzi Jesús, tema iri matzirori ipeyakotakagaimiro piyaariperonka. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Eekerorika poyaatatyeero Inintakaantaitakeri rosankenatakeri Moisés-ni, eero ipeyakotaitzimiro piyaariperonka. Irooma arika pinkemisantanairi Jesús, ari impeyakotaimiro irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Paamaawentaiya eerokapaini, patsipetawokari rosankenatakotakeri Kamantantaneriite, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Pinkemaiyeni manintzirori kyaaryooperori, Ari pinkitakitziitapainte, irojatzi pimpeyantakyaari. Tzimawetakaga oita nantzimotaimiri, Eeromaita pikemisantziro, intzimawetakya ooñaawontemirone.” ");
INSERT INTO cpbNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ikanta rishitowimatanai Pablo rapatotapiintaitaga, ikowakotaiyakerini kaari isheninkata, ikantziri: “Pipiyai otsipaki kiteesheri rimakoryaantaitari, papiitero pinkenkithatakayenawo jiroka ñaantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ikanta riyaataiyaini Judá-ite eejatzi kaari isheninkata ipiyotaiyani, eenitatsi osheki oyaatanakeriri Pablo eejatzi Bernabé. Ari ikaminaathayetakeri roisokerotantyaawori ineshironkayetairiri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Okanta imonkaatapaawo kiteesheri rimakoryaantapiintaitari, ipiyotaiyakani osheki atziri inkemisantero riñaane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ikanta iñaakerira Judá-ite ipiyotaiyapaakani atziripaini, ikisashiretaiyanakani, retanakawo ikoshekawaitakari Pablo, rithainkimawaitanakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Te ithaawanake Pablo itsipatakari Bernabé, ikantakeri irirori: “Iro kameethawetachari netawakemi nonkamantayetemirome eerokapaini riñaane Pawa, tema Judá-ite pinayetzi. Irooma pimanintaiyakeronira, eero piñagairo rañaashiretakagaitaimi. Iroowa nonkenkithatakaantyaariri iroñaaka kaari asheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iroowa rotyaantantanari Nowinkatharite, ikantakena: Eeroka nowake poiteesheetyaakotairi kaari pisheninkata, Pinkenkithatakotainiri awisakotaantsi. Pithotyagairo maawoiniki kipatsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ikanta ikemaiyawakeni kaari isheninkata, ikimoshiretaiyanakeni, ikantaiyanakeni: “Osheki okameethatzi riñaane Pinkathari.” Rithonka ikemisantaiyaini ikaatzi riyoyagaitakeri rañaashireyetai. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ithonka ikenkithatakoitanakero riñaane Awinkatharite nampitsikipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Iri kantacha Judá-ite, ikenkithawaitakaake iriiperoripaini jewatakaantatsiri nampitsiki, tsinanepaini iyemakoitane, tsipatapiintariri Judá-ite ipiyotaiyanira, rakakaayetakeri royaakyaateri Pablo eejatzi Bernabé, romishitowairi inampitsiteki. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ikanta Pablo itsipatakari Bernabé rotekanairo iipatsiyitzite riyotantaityaari te ikemisantaitziri Pawa janta. Irojatzi ikenaiyantanakarini otsipaki nampitsi Iconio-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Iro kantacha kimoshire ikantaiyani riyotaanewopaini, risaikashireperotantanakari Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikanta Pablo itsipatakari Bernabé, ikyagaiyakeni rapatotapiintaiyanira Judá-ite janta Iconio-ki. Ikenkithatakaapaakeri, ari ikemisantaiyanakeni osheki Judá-ite eejatzi kaari isheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Iro kantzimaitacha, eeniyetatsi kisoshireri Judá-ite, ikaminaakeri kaari isheninkata inkoshekyaari kemisantakaantapaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Iroowa risaikantapaakari osamani janta. Eekero ikenkithatakotanakitziiri Awinkatharite te ithaawaiyini. Ritasonkawentantayetake, iroowa riyotantaitari imaperotatya ikenkithatakotziro ineshironka Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iro kantacha ikoshekawakaanaka ikaatzi nampitawori janta. Eenitatsi aapatziyanakariri Judá-ite, tzimatsi itsipapaini aapatziyanakariri Otyaantaperoriite. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ikanta Judá-ite itsipayetakari kaari isheninkata, ikenkithawaitakaakeri jewaripaini rowasankewaiteri, rishemyaantyaari eejatzi mapi. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iri kantacha iriroripaini, riyotake oitarika rantaiteri, shiyaka ikenaiyanakeni Listra-ki eejatzi Derbe-ki, iro nampitsipaini saikatsiri janta Licaonia-ki. Irojatzi raayetantanakari eejatzi otsipaki nampitsi okaatzi tzimayetatsiri janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Arira ikenkithayetakero Kameethari Ñaantsi janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Okanta janta Listra-ki tzimatsi atziri kisopookiri, te ranashiwaita, tema rashi rowiro owakera itzimapaake. Ari risaikiri jirika atziri, ");
INSERT INTO cpbNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ikemisantziri Pablo. Ikanta Pablo rotzikanatanakari atziri, riyotake osheki rawentaashiretakari, kantacha retsiyatakotakagairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Riñaanatanakeri shintsiini, ikantanakeri: “¡Pinkatziye, potampatzikatero piitzi!” Apathakero rimitaanake katziyanaka, anashitanaa. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ikanta iñagaitakero rantakeri Pablo, ikaimaiyanakeni atziripaini riñaaneki Licaonia-satzi, ikantaiyini: “¡Rayiitzimotakai pawa roshiyapaakari atziriwé!” ");
INSERT INTO cpbNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Roshiyakagaitanakeri Bernabé iriime jitachari “Júpiter”, iriima Pablo roshiyakagaitanakeri iriime jitachari “Mercurio”, tema iriitake Pablo ñaawaitatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Janta ikyaapiintaitzira nampitsiki, ari isaikiri iyaapapankote sheripiyariwentziriri Júpiter. Jirika sheripiyari, ramake iroñaaka ipirapaini, inchateyakipaini. Itsipayetakari atziripaini ikowawetaiyani impinkathateri Bernabé eejatzi Pablo. Ikowi rowamayenirime ipirapaini, ritayeniri. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Iri kantacha Bernabé itsipatakari Pablo, Otyaantaperori rini, riyotake irirori oita ikenkithashiryaari ranteniriri atziripaini. Weshiryaaperotanaka, risaperyaanakero iithaare. Rosatekantanakari atziripaini, ikaimanake, ");
INSERT INTO cpbNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ikantzi: “¿Oitaka pantantyaawori jiroka? Atziri ninayetatzi naaka, ari noshiyimi eerokapaini. Irootake nipokantakari nonkamantayetaimi pipakaayetairo pametashitapiintari. Ontzimatye pinkemisantairi Pawa Kañaanetatsiri, wetsikakerori inkite, kipatsi, inkaare, maawoini tzimantayetawori. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Irijatzi shinetakeriri pairani picharinepaini rantapiintantakawori iñaamatashiyetari iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Iro kantzimaitacha te rimanapithawetari kaari riyotantaatsikaitari añaatsira irirori. Tema iri Pawa neshironkatapiintakairi aakapaini, rowariiro inkani, okithokiyetantari awankirepaini, iri payetairori maawoini owayetari, iro opoñaantari akimoshiretai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Okantawetaka ikantayewetakari atziripaini jiroka, osheki opomeentsitaka ripakaakaantyaariri rowamayeniri ipirapaini ritayeniri. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ari rareetaiyapaakani Judá-ite poñagainchari Antioquía-ki eejatzi Iconio-ki. Ikaminaayetapaakeri atziripaini. Irootake rishemyaantawetakariri Pablo. Inoshikaitanakeri rookakeri nampitsithapiki, roshiyakaaminthaitzi ari rowamaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ikanta riyotaanepaini Pablo ipiyowentapaakari, ari ipiriintanaari eejatzi ripiyanaawo nampitsiki. Okanta okiteeshetamanake jatake Derbe-ki itsipatanaari Bernabé. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ikanta ikamantantapaakero Kameethari Ñaantsi janta Derbe-ki, ikemisantakaake osheki atziri. Irojatzi ripiyantanaawori Listra-ki, Iconio-ki irojatzi Antioquía-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ari ikenkithatakaayetanairi riyotaanepaini, ikaminaayetanairi onkantya roisokerotantyaariri rawentaashiretanakari, ikantayetziri: “Ontzimatye añeero osheki ankemaatsiwaityaari ompoñaantyaari ankyaantaiyaari jimpe ipinkathariwentantai Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Raminake apawopaini itzinkamipaini jewaterine kemisantzinkaripaini tsika rapatotapiintaiyani. Ramanakotanaari, ritziwentanaari, ikantapiintake: “Nowinkatharité, pinkempoyagairi jirikapaini awentaayetanaimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ikanta ikenapairo Pablo janta Pisidia-ki, irojatzi Panfilia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ikenkithatakaantanake janta Perge-ki, rawisanake irojatzi janta Atalia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ari rotetanaa irojatzi Antioquía-ki, tsika janta rowaitakeri pairani riyaatantyaari inkamantantero ineshironka Pawa. Irootake rimatakeri rantayetakero. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ikanta rareetaa Antioquía-ki, ipiyoyetapairi kemisantzinkaripaini, ikamantapairi okaatzi rantakaayetakeriri Pawa, jimpe ikanta Awinkatharite rawentaashiretakaayetaari kaari isheninkata. ");
INSERT INTO cpbNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ari risaikapairi Pablo itsipatakari Bernabé itsipayetapaari riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ari rareetaka Antioquía-ki, apawopaini atziri ipoñaayetakawo Judea-ki, riyotaantayetapaake, ikantantapaake: “Iyekiite, eerorika pimonkaayetziro Inintakaantaitanewo rosankenatakeri Moisés-ni, pitomeshaanitya, eero pawisakoshireyetai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ikanta Pablo itsipatakari Bernabé osheki riñaanaminthatakeri jirikapaini areetapainchari. Irootake ikowantaitakari rotyaantaiteri Pablo, Bernabé eejatzi itsipapaini, riyaate Jerusalén-ki iñeeri Otyaantaperoriite eejatzi itzinkamipaini, impiyowentyaawo awisaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ari rotyaantaitakeri ikenanake Fenicia-ki irojatzi Samaria-ki, ikamantantayetanake jimpe ikantayetaa ikemisantayetai kaari isheninkata. Ikimoshiretaiyanakeni iyekiite ikemawakera. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Irojatzi rareetantakari Jerusalén-ki. Kameetha raawakeri kemisantzinkaripaini, Otyaantaperoriite eejatzi itzinkamipaini. Ikamantapaakeri iriroripaini rantakaayetakeriri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Iri kantacha apawopaini Fariseo kemisantaatsiri, ikatziyanaka iriroripaini, ikantanake: “Ikaatzi kemisantayetaatsiri kaari asheninkata, okowaperotatya rimonkaayetairo Inintakaantaitanewo rosankenatakeri Moisés-ni, ritomeshaanitya.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ari ipiyotaiyakani Otyaantaperoriite itsipayetakari itzinkamipaini raminakotantyaawori tsika okantakota jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Okanta osamanitake riñaanatawakaawentakawo, ikatziyanaka Pedro, ikantanake: “Iyekiite, pinkenkithashireero eerokapaini eenitatsi rantzimoyetakairi Pawa pairani. Rotyaantakena naaka nokenkithatakaayetairi Kameethari Ñaantsi kaari asheninkata, ari okantaawo ikemisantantaari iriroripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tema Pawa riyotake jimpe ikanta ishireki, ari roñaagayetairo ikowiri irirori risaikashiretantaiyaari Tasorenkantsi kaari asheninkata ikemetaakaira pairani aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tema raakameethatairi Pawa jirikapaini ikemetaakaira eejatzi aakapaini, roiteshireyetairi rawentaashiretaarira. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Kameethatatsima piñaantawaityaari Pawa? ¿Iitaka pinkematenatakaantyaariri ayotaanewo? Tema potsiwakakaakari kaari amataatsikaitzi aakapaini, kaari rimataatsikaitzi eejatzi acharineete. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Iroowa ineshironka Awinkatharite Jesús owawisaakoshireyetairi aakapaini. Ari ikantayetaari eejatzi iriroripaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ari imairetaiyanakeni maawoini, ikemisantanakeri Bernabé eejatzi Pablo ikenkithatakotziro okaatzi rantakaayetakeriri Pawa janta itsipasatziki atziripaini, ritasonkawentantayetake. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ikanta rithonkakero ikamantantake, ikantanake Jacobo: “Iyekiite, pinkemisantawakena: ");
INSERT INTO cpbNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ikamantakairo Simón jimpe ikanta Pawa retantanakawori riyoyayetairi itsipasatzipaini, opoñaantari ikemisantairi, raakoyetairi iwairo. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ari imonkaatari iroñaaka rosankenatakotakeri pairani Kamantantaneriite, ikantake: ");
INSERT INTO cpbNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Arika onkaatapaake jiroka, ari nipiye. Nompiriintairo ipanko David tyagaintsiri. Nompinkatharitakagairi incharinetyaari ari roshiyaiyaari jimpe ikanta irirori nopinkatharitakaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iro ompoñaantyaari rithotyaakoyetaina itsipasatzipaini, inkantayetaina: ‘Nowinkatharite’, Iro ompoñaantyaari nashitaiyaari kaari pisheninkata, raakoyetaina nowairo. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ari ikantake ikenkithawaitake Awinkatharite, oñaagantzirori ikenkithashiretzitakari owakera retantanakawori. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Irootake nonkantantyaari naaka, eero okanta oomerencheeri kaari asheninkata ikaatzi kemisantayetairiri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Apatziro otyaanteniri osankenarentsi eero rowantari wathatsi rashitakagaitariri iwawanetashiyeetari, eero imayempiwaiyetanta, eero rowakoyetantawo riraa piratsipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tema irootake jiroka rosankenare Moisés-ni ikenkithatakoitapiintziri tsikarikapaini rapatotapiintayeta Judá-ite kiteesheriki rimakoryaantaitari. Irootake retanakari pairani. Irootake ripakaantyaawori jirokapaini eero ikantzimoshiretakaantari asheninkapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ikanta Otyaantaperoriite eejatzi itzinkamipaini, itsipayetakari kemisantzinkaripaini, riyoyaake rotyaanteri Antioquía-ki intsipatyaari Pablo eejatzi Bernabé. Jirika ikaatzi riyoyaakeri: Judas iitaitziri Barsabás, eejatzi Silas. Iriitake jewatakaayetakeriri iyekiite janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Iriitake aanakerone osankenarentsi. Jiroka okantzi osankenataka: “Iyekiite, naakatake Otyaantaperoriite, itzinkamipaini. Niwethataiyimini eerokapaini kaari nosheninkata nampiyetawori Antioquía-ki, Siria, eejatzi Cilicia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Niyotaiyakeni tzimatsi poñaayetanainchari jaka, iri oomerenchaakemiri janta, ikowi pimonkaayetairo Inintakaantaitanewo, pitomeshaanitaiya. Kaarira jirika notyaantanewo naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Irootake nokenkithawaitantakari jaka, ari niyoyaake apawopaini akaataiyinira, jatatsine iñeemi intsipatanakyaari etakokitanewo Pablo eejatzi Bernabé. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iriiyetake atsipewentakariri Awinkatharite Jesucristo. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jirika notyaantakemiri: Judas eejatzi Silas. Iriira kenkithawaitakaapaakemine janta inkamantapaakemiro maawoini jiroka. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Te onkameethate nonkematenatakaawaitemi eerokapaini, tema iro kameethatzimotakeriri Tasorenkantsi, eejatzi naakapaini. Apatziro pantayetairo okaatzi kowaperotachari. Jiroka okantzi: ");
INSERT INTO cpbNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eero powayetari wathatsi rashitakagaitariri iwawanetashiyeetari. Eero powakoyetawo riraa piratsi. Eero pimayempiwaitzi. Arika pimonkaayetanakero jiroka, kameethatake. Ari okaatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ikanta rotyaantaitakeri, jatake Antioquía-ki. Ari ipiyotapaakeri kemisantzinkaripaini, ipapaakeri osankenarentsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ikanta riñaanatawakero, ikimoshireperotaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tema kamantantaneri rinayetzi Judas eejatzi Silas, ithaamentakaapaakari iyekiite roisokerotyaari Pawa, ikenkithawaitakaapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Okanta osamanitake risaikimowaitakeri kameetha, rotyaantairi jimpe ipoñaakawo pairani. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Iri kantacha Silas okameethatzimotakeri irirori risaikanake. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Eejatzi Pablo itsipatakari Bernabé irojatzi risaikanake iriroripaini Antioquía-ki, itsipayetakari itsipapaini, eekero riyotaantanakitzi, ikamantantziro riñaane Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Okanta osamanitake, ikantairi Pablo jirika Bernabé: “Jame apiitero areetyaari inampipainiki iyekiite tsika akamantantakero riñaane Awinkatharite. Aminairi jimpe ikantayeta.” ");
INSERT INTO cpbNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ari ikowawetaka Bernabé raanakerime Juan, iitaitzitari Marcos. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Iro kantacha te inimoteri Pablo raanairi, tema Marcos rookanawentakeri janta Panfilia-ki, te rithotyiiro intsipatyaari jimpe ikenayetake ikenkithatakaantzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ari riñaanaminthatawakaiyakani. Aripaite rontsiparyaawakaiyanakani. Raanakeri Bernabé jirika Marcos, otetanaka ikenanake Chipre-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Iriima Pablo, raanakeri Silas. Ramanakotawaari iyekiite, ikantaiyini: “Nowinkatharité, nawentaimi eeroka, pineshironkateri jirika.” Ari riyaataiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ikanta ikenanake Siria-ki, irojatzi Cilicia-ki, rominthashiretakaayetakari ikaatzi kemisantayetaatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ikanta rareetaka Pablo janta Derbe-ki itsipatari Silas irojatzi rareetantakari Listra-ki. Ari iñaake riyotaanewo Awinkatharite iita Timoteo, otomi osheninka Judá-ite rinatzi, kemisantatsiri, riñaawaitziro Grecia-thato ipaapate. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jirikapaini kemisantzinkaripaini nampitawori Listra-ki eejatzi Iconio-ki kameetha ikenkithatakotakeri jirika Timoteo. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Kowanake Pablo intsipatyaari Timoteo. Iro kantacha retawakari ritomeshaanitziri eero ikisawaitanta Judá-ite nampitawori janta, tema riyotaiyini maawoini Grecia-thato rinatzi ipaapate Timoteo. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ikanta ikenayetanake nampitsipainiki, ikamantayetanakeri kemisantzinkaripaini rimonkaayetairo rosankenatakeri pairani Otyaantaperori itsipatakari itzinkamipaini janta Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iroowa ikyaaryooyetantanakari kemisantzinkaripaini rawentaayetanaka, eeke riyaatanakitzi kiteesheriki isheniperotanake. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ikanta Pablo roshinampitanakawo Frigia eejatzi Galacia, tema te rishinetziri Tasorenkantsi inkenkithatakaante Asia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Irojatzi rareetantakari Misia-ki. Ari ikenkithashiryaawetakari riyaatero Bitinia-ki, iro kantacha te rishinetziri Itasorenka Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Awisanake janta Misia-ki, oirinkaiyapaakani nampitsiki Troas. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ari janta rimishiwaitake Pablo tsireniriki, rimishitake apaani Macedonia-satzi, ikantziri: “Pareetena nonampiki, pineshironkayetaina naakapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ikanta rimishiwaitakera Pablo, ari niwetsikaiyanakani niyaataiyeni Macedonia-ki, tema niyotanake iri Pawa kaimashireyetakenari janta nonkenkithatakotero Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ari notetaiyanakani Troas-ki, apatziro nowanakero niyaatziro Samotracia-ki. Okanta okiteeshetamanake naatakotapaake nampitsiki Neápolis-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Okanta nawisanake irojatzi Filipos-ki, inampiyetawowa poñaayetainchari Roma-ki, otzinkami nampitsi inatzi janta Macedonia-ki. Ari nisaikawaitapaakeri janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Okanta apaani kiteesheri rimakoryaantapiintari Judá-ite, niyaatake ñaacheraaki, nokantashiretzi ari ramanapiintaiyani. Ari noñaapaake tsinane opiyotaiyani, nisaikaiyapaakeni nokenkithatakairo Kameethari Ñaantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Okanta apaani tsinane piyotainchari oita Lidia, opoñaawo iroori nampitsiki Tiatira. Ipoki iyompariwaita kithaarentsi anashirikimawotatsiri. Tema opinkathatapiintziri Pawa jiroka tsinane, okemaminthatakeri ikenkithatzi Pablo, rominthashiretakaanakawo Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Omitsitsiyaataka, otsipatakari ikaatzi saikawankotzirori. Ari okantaiyanakenani: “Piyotanarika nokyaaryoowentairi Awinkatharite, pipokaiyeni pimaye nopankoki.” Ari nimataiyakeroni, tema irootake kantakenari. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Okanta apaani kiteesheri, niyaataiyini namaña, nitonkyotaka apaani mainawo imperataarewo. Riyoshiretakairo peyari oitarika awishimoterine atziri. Iroowa ripinatantaitariri imperatawori osheki. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jiroka mainawo oyaatanakeri Pablo, oyaataiyanakenani eejatzi naakapaini, okantzi okaimi: “¡Jirika shiramparipaini rimperatanewo rinatzi Pawa Jenokisatzi, iriira kamantemirone pawisakoshiretantaiyaari!” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ari okantapiintatya kiteesheriki, irojatzi owatsimaashiretantakariri Pablo, ripithokashitanakawo, riñaanatanakeri peyari iyoshiretakairori, ikantziri: “Piyaatapithatairo mainawo, iri Jesucristo matemirone naakotakerira iwairo.” Apathakero riyaatapithatanairo peyari. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ikanta iñaakero imperatawori, riyotanake eero raantaawo osheki koriki. Rotaiyakeri Pablo itsipataakeri Silas, raanakeri jewaripainiki, irojatzi janta ipiyowentantapiintaitaga. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ikantapaakeri yakowentantaneri: “Jirikapaini Judá-ite rinatzi. Rochapishiryaakeri atziripaini jaka anampiki, ");
INSERT INTO cpbNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","riyotaayetakeri kaari ashineyetzi rantaitero, tema asheninkapaini rinatzi Roma-satzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ari ripithokashitaitanakari Pablo eejatzi Silas, ikantake yakowentantaneri: “Paatonkoreeri, pipasateri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ikanta ripasatakeri, romonkyaakaantakeri. Ikantanake: “Pinkempoyaaperoterira.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ikemake kempoyaantaneri ikantaitakeri, romonkyaaperotakeri inthomointa, rawitsinayitzitantakari inchakota. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Okanta niyanki tsireniri, ramanaiyani Pablo itsipatari Silas romampagaiyani eejatzi, kemaiyatsini itsipa omonkyagaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Omapokashitanaka omoyekanaka, eewokapaakero pankotsi romonkyagaitakerira. Ashitaryaashiwaitanaka rashitakotantaitariri, itzintaryaakowaitashitanaka omonkyagaarewo roosotakoweetantakarira kotsirotha. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ari ikakitanake kempoyiiriri, iñaatziiro ashitaryaaka rashitakowetakarira, inowikyaanakero rosataamento rishinetya rosataya, roshiyakaatzi shiyaka maawoini omonkyagaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ikaimotanakeri Pablo, ikantziri: “¡Eero pishinewaitashita, irojatzi nisaikaiyini maawoini jaka!” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ikanta jirika kempoyaantaneri ikaimakaantake ootamentotsi, rishiyaperotanakitya ikyaapaake, okawaitanaka ithaawanakera, rotziwerowashitapaakari Pablo eejatzi Silas. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ari romishitowanakeri, rosampitakeri, ikantziri: “Pinkatharí, ¿Iitaka nanteri nawisakotantaiyaari?” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ikantanakeri: “Pinkemisantairi Pinkathari Jesús, aritake pawisakotai eeroka eejatzi ikaatzi saikawankotzimiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ikenkithatakaanakeri tsika ikantakota Awinkatharite eejatzi ikaatzi saikawankotakeriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Niyankira tsireniri jirika kempoyaantaneri ikiwainiri aawyaakerira pasataantsi. Irojatzi romitsitsiyaatantakariri itsipataakeri isheninkapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Raanakeri ipankoki, ipapaakeri rowanawo. Kimoshire ikantanaka jirika ikemisantairi Pawa itsipayetaari ikaatzi saikawankotziriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Okanta okiteeshetamanai, jirikaga yakowentantaneri ikantakaantakeri kempoyaantaneri, ikantake: “Pomishitowairi jirikapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ikanta kempoyaantaneri, ikantakeri Pablo: “Inintakaantakena yakowentantaneri nomishitowayetaimi. Kantacha piyaayetai iroñaaka kameetha.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ikantanake Pablo: “Rosankenatakotane Roma-satzi nini naaka, iro kantacha ripasawaitaitakena janta ipiyowentantapiintaitaga, te raminawakero tzimatsirika nokenakaashitanewo. Romonkyaakaantakena. ¿Iroñaakama ikowi rimanakaina romishitowaina? ¡Te nokowi! Pinkanteri ripokanake irirori romishitowaina.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ikanta jirika kempoyaantaneri, ikamantakeri yakowentantaneri. Ikemawake rosankenatakotane rinatzi Roma-satzi, antawoite ithaawaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jatanake yakowentantaneri, ikantapaakeri Pablo eejatzi Silas: “Pimpeyakotainawo nowasanketakaantakemira.” Romishitowakaantairi, ikantawairi: “Piyaatai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ari riyaataiyaini opankoki Lidia. Ikenkithatakaayetanairi kemisantzinkaripaini, ithaamentashireyetakaanaari, jataiyaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ikanta rareetantayetaka Pablo eejatzi Silas ikenayetanake Anfípolis-ki, Apolonia-ki irojatzi rareetantakari Tesalónica-ki, ari isaikiri janta rapatotapiintaga Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Iro rametapiintari Pablo arika rareetya otsipaki nampitsi, ikyaapiintzi rapatotapiintaga Judá-ite, ikenkithatzi. Iroowa rantapaakeri iroñaaka. Irojatzi rapiitantaawori otsipaki kiteesheri rimakoryaantaitari, rapiitairo eejatzi. Ari riñaanaminthatapiintakeri Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rookoyetziniri Osankenarentsipero tsika ikenkithatakota Cristo inkamimotante, rañagai eejatzi. Ikantayetziri: “Jirika Jesús nokenkithatakotakemiri, iriitake Cristo.” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ari ikemisantanake apawopaini Judá-ite, itsipatanakari Pablo eejatzi Silas. Ikemisantaiyanakeni osheki Grecia-thato pinkathatasorentsitaneri, ari okantanakari eejatzi tsinanepaini irooperori. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Iri kantacha Judá-ite kaari kemisantatsine, te inimoshiretanakeri. Ipiyotakeri kaariperoshireri. Rotyaantakeri inkoshekantya nampitsiki. ikoshekawankotakari eejatzi Jasón, rithotyaakotziri Pablo eejatzi Silas. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Te iñaashitari, raanakeri Jasón itsipataanakeri itsipa kemisantzinkaripaini, raanakeri risaikira jewatakaantzirori nampitsi, ikantaiyapaakeni: “¡Tzimatsi shiramparipaini ochapishiryaantaintsiri nampitsiki, pokake iroñaaka jaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jirika Jasón oisaikawakeriri ipankoki! Rithainkayetakero jirika ikantakaantanewo pinkatharitatsiri Roma-ki, ikantaiyakeni: ‘Eenitatsi itsipa pinkathari, iita Jesús.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ikanta ikemaitawakero, te inimotanakeri atziripaini eejatzi jewaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ikowakoitakeri Jasón ripinawentya itsipayetakarira itsipapaini, ompoñaantyaari ripakagaitairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ikanta kemisantzinkaripaini, rotyaantairi tsireniriki Pablo eejatzi Silas, riyaatai Berea-ki. Ikanta rareetaiyakani janta, jataiyakeni rapatotapiintaiyanira Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jirikapaini Judá-ite, neshironkatantaneri rinaiyini te roshiyari Tesalónica-satzi, kameetha ikemisantawakero ñaantsi. Ikamaitanakawo kiteesheriki riñaanatanairo Osankenarentsipero iñaantyaawori kyaaryooperorika ikamantaitziriri. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Osheki Judá-ite kemisantanaintsiri, ari ikantakari Grecia-thato iriiperotatsiri, eejatzi tsinanepaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Iri kantacha Judá-ite nampitawori Tesalónica-ki, ikemakotakeri ikenkithatakaantatzi Pablo janta Berea-ki, pokaiyanakeni, ikoshekawaitapaakari atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Iri kantacha kemisantzinkaripaini raanakeri Pablo inkaarecheraaki. Iriima Silas itsipatakari Timoteo ari risaikanake irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ari rawisakaitanakeri Pablo irojatzi rareetantakari Atenas-ki. Ikanta ripiyaiyaani Berea-ki, ikantapairi Silas itsipatakari Timoteo: “Ikaimakaantaimi Pablo, piyaate intsipaite.” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ikanta Pablo royaawentziri Silas itsipatakari Timoteo janta Atenas-ki, te inimoteri irirori iñaayetzirira Atenas-satzi ipinkathayetziro oshiyakaawontsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iroowa ikenkithatakaantakariri Judá-ite, eejatzi itsipapaini pinkathatasorentsitaneri janta rapatotapiintaitaga. Osheki ikenkithatapiintake eejatzi kiteesheriki ipiyotapiintaiyanira atziripaini nampitsiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Riñaanaminthatakeri eejatzi yotaneriite nampitsiki. Eenitatsi kantayetatsiri: “¿Iitamatsitaka ikenkithatakotziri kenkithawaitashitachari?” Ikantaiyini itsipa: “Ikenkithatakotatziiri itsipasatzi Pawa.” Iro ikantantari jirikapaini tema Pablo ikamantantatziiro Kameethari Ñaantsi jimpe ikantakota Jesús, rañaantaari. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ikanta romiñaanakeri otzishiki jitachari “Areópago”, ari ipiyotapiintaiyani. Rosampitakeri: “Janjaatya pinkenkithatakotenawo owakeratatsiri piyotaantziri nonampiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tema pikenkithatakaakenawo kaari nokemapiintaiyini. Nokowaiyini niyote oita kantakotachari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Tema okaatzi itzimawentziri Atenas-satzipaini itsipatakari areetzinkaripaini, ikemisantayetziro owakerayetatsiri ñaantsi, rowaayimaitawo.) ");
INSERT INTO cpbNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ikatziyanaka Pablo ipiyowentaitakarira, ikantanake: “Atenas-satzipaini, noñaakemi tzimatsi osheki piwawaneyetari, pipinkathatapiintziri. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nokenayetake pinampiki, noñaayetakero pitaapokimento. Eenitatsi apaani osankenataka, okantzi: ‘PAWA KAARI RIYOYEETZI.’ Irijatzira nokenkithatakotzimiri naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Iri wetsikakerori kipatsi eejatzi maawoini tzimantayetawori, irijatzi Pinkathariwentzirori inkite eejatzi kipatsi. Te risaikantawo tasorentsipanko riwetsikanewo atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Te ikoityiiro irirori riwetsikaiteniri tsikarika oitya. Tema iriitake añaakaayetairi maawoini aakapaini, irijatzi owiñeenkatakaayetairi, ipayetairo maawoini tsikarika oiyeta. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iriitake wetsikakeriri etakawori atziri, ishenitakagairi, roiwawagairi inampitantaawori maawoini kipatsi. Ikenkithashiretzitaka tsikarika onkaate osamanite inampiyetyaawo tsikarikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iro rantantayetakawori jiroka, rithotyaakoitantaiyaariri. Oshiyawaitakawo impampipookiwaitatyeeme rithotyaakoitziri. Ari iñaayeetairi. Tema te intaina risaiki Pawa, ari itsipayetai maawoini aakapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Iriira añaakaayetairi iroñaaka, ranashitakaayetai, iri tzimakaayetairi. Irojatzi ikantayetzitari pisheninkapaini, kenkithayantzi, ikantake: ‘Rashiyetai Pawa.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tema rashitaira Pawa, ontzimatye ayote te okameethatzi oshiyakayeri oshiyakaawontsi riwetsikanewo atziripaini, riwetsikayetziri ooro, koriki, mapi. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tema pairani osheki ikisashitakawo Pawa okaatzi rantashiwaitakari imasontzinkakiini atziripaini. Iro kantacha iroñaaka ikantayetai maawoini tsikarikapaini inampiyeetawo, ikantzi: ‘Pipakagairo kaariperori pametashiyetari.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tema Pawa riyoyaake apaani atziri, iriitake rotyaantairi raminakoyetairo okaatzi antayetakeri. Tema riyotairo Pawa tsikapaiteka rantero. Tema roñaagantairi atziri rowiriintairi ikamawetakaga.” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ikanta ikemawakera ikenkithatakotakeri ipiriintaaga kaminkari, ishirontaiyanakarini. Tzimatsi itsipa kantanaintsiri: “Apiitero paata nonkememi pinkenkithatakotero jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Riyaatapithatanairi Pablo. ");
INSERT INTO cpbNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Iri kantacha eenitatsi oyaatanakeriri, kemisantayetai irirori. Jirika ikaatzi kemisantanaatsiri: Dionisio, iri tsipatapiintawetariri ipiyotapiintaga Areópago-ki. Opoñaapaaka tsinane jitachari Dámaris, tzimatsi otsipapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Okanta okaatapaake jiroka, rishitowanake Pablo janta Atenas-ki, jatake Corinto-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ari iñaake apaani Judá-ite jitachari Aquila, Ponto-satzi rinatzi jirika. Owakera rareetaka Aquila itsipatakawo iina jitachari Priscila ipoñaakawo Italia-ki, tema pinkathari Claudio ikantakaantake janta Roma-ki rishitowayete maawoini Judá-ite. Jatake Pablo rareetari Aquila. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ari risaikapaake Pablo itsipatapaakari. Tema iro rantawaire jirika, rishirikayetziro tontamawotatsiri, ipankoitawo. Irojatzi rantawaire pairani Pablo irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ari ikantapiintatya Pablo riyaatzi rapatotapiintaitaga kiteesheriki rimakoryaantaitari, ikenkithatakaantayetake ompoñaantyaari roitsinampaantyaariri Judá-ite inkemisantakaayetairi, eejatzi Grecia-thatotatsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ikanta Silas eejatzi Timoteo areetaiyapaakani ipoñagaawo Macedonia-ki. Ari ikamaitanakawo Pablo ikenkithatakaantanake. Ikantayetakeri Judá-ite: “Jirika Jesús, Cristo rinatzi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Iri kantacha te inimoteri Judá-ite, kisaneentanaka, ikaweyawaitanakeri. Ari rotekanairo iithaare Pablo riyotantaityaari te ikemisantaiyini, ikantanakeri: “Eerokaga kantakaanterone pimpeyawaitantaiyaari, te naaka kantakaanterone. Iri nipithokashite iroñaaka kaari asheninkata.” ");
INSERT INTO cpbNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Shitowanake rapatotapiintaitaga. Jatake ipankoki apaani atziri jitachari Justo, pinkathatasorentsitaneri rinatzi. Risaikanampitziro irirori rapatotapiintaiyanira Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ikanta Crispo, jewatatsiri rapatotapiintaga Judá-ite, ikemisantanakeri Awinkatharite, rimatanakero eejatzi ikaatzi saikapankotziriri. Iro rantanakeri eejatzi osheki Corinto-satzi, ikemayetakero ñaantsi, kemisantayetanake, romitsitsiyaataitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ikanta Pablo, romishimpyaakeri Awinkatharite tsireniriki, ikantakeri: “Eero pithaawi. Piyaatakairo pinkamantantero ñaantsi jaka, eero pimairetzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tema ari notsipatzimi naaka, eero rowatsinaawaitaitzimi jaka, tema tzimatsi osheki nashiyetaari naaka jaka nampitsiki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iro risaikantanakari Pablo Corinto-ki, anaaneentakero apaani osarentsi risaikawaitake. Riyotaantayetziro riñaane Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ikanta reewaritantari Galión janta Acaya-ki, retanakawo Judá-ite itzimawentanakeri Pablo. Irojatzi raantanakariri jewariki. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ikantapaakeri: “Jirika atziri ikenakaashitakawo riyotaayetziri atziripaini impinkathatairi Pawa, ripiyathatakawo inintakaantaitziri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Iro riñaawaitanakeme Pablo, akanake Galión ikantanakeri Judá-ite: “Iroorika pikenkithatakotzi ritsitokante jirika atziri, aritake nonkemisantakemi pikantanari. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Iro kantacha, aamaaka pikantakotawakaashitawo okaatzi piñaawaitashitari eeroka, paakowaitashitari, piitashiwaitari: ‘Inintakaantaitanewo.’ Piyotaiyeroni eerokapaini tsika pinkantero, te nimeraawentawaitziro naaka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Romishitowawetaari jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ikanta Grecia-thato, rotaiyanakeri jitachari Sóstenes, iri jewatzitachari rapatotapiintaga Judá-ite. Ripasawaitanakeri. Iri kantzimaitacha Galión, te rimatzimaitawo irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Osheki kiteesheri risaikawaitanai Pablo janta Corinto-ki. Irojatzi riyaatantaari itsipatanaawo Priscila eejatzi Aquila, riyaatairo Siria-ki. Okanta janta Cencrea-ki, tekera rotetanaiyaata, rameetanakero iishi, rimonkaatantyaawori ikashaakaantakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ikanta rareetaka Efeso-ki, jatake Pablo rapatotapiintaitaga, ari ikenkithatakaayetapaakeri Judá-ite. Ari rookanairi Aquila eejatzi Priscila. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ikowakowetawaari Judá-ite osamani risaikanake, iri kantacha Pablo te ikowi. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ikantanairi riyaatzimatanaira: “Ontzimatye nareetaiya Jerusalén-ki roimoshirenkaitaga. Iriirika Pawa kowatsine, aritake nipiye noñaayetaatemi.” Irojatzi rotetantanaari Pablo, jatai. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ikanta rareeta Cesarea-ki, awisapai Jerusalén-ki riwethatapaiyaari kemisantzinkaripaini. Irojatzi rawisantanaari Antioquía-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Okanta osamanitake, rapiitairo rareetantayeta apawopainiki nampitsi janta Galacia-ki eejatzi Frigia-ki, raawyaashiretakaayetairi riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Okanta janta Efeso-ki, areetaka apaani Judá-ite jitachari Apolos, Alejandría-satzi rinatzi. Kameetha ikenkithatzi, riyotakotziro kameethaini Osankenarentsipero. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Eenitatsi kenkithatakotakeniriri Juan-ni omitsitsiyaatantaneri, ikenkithatakoitakeniri eejatzi ikamantantakeri Juan-ni ikantakota Jesús. Ari iweyaa riyotakotziro irirori. Iro kantacha, kameetha ikanta rooñaawontawetawowa ikenkithatakotziri Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ari ikenkithatakaantapaake Apolos rapatotapiintaitaga. Ikanta okemakeri Priscila eejatzi Aquila, raanakeri Apolos, riyotaakeri tsika ikantakoperota Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ikowake Apolos rawishe Acaya-ki. Ari ipawakeri kemisantzinkaripaini Efeso-satzi apaani osankenarentsi raakameethatantawakyaariri Acaya-satzi. Ikanta rareetaka Acaya-ki, osheki ithaamentakaapaakari kemisantzinkaripaini ikaatzi ineshironkayetairi Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Rimatziro Apolos roitsinampaayetakeri Judá-ite, roñaagayetziri Osankenarentsipero ikenkithatakotziri Cristo, iro opoñaantari riyotakoitantanakariri Jesús, iriitake Cristo. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ikanta Apolos risaiki Corinto-ki, anonkanake Pablo ochempiki, areetaka Efeso-ki. Iñaapaake kemisantawetaachari. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Rosampitapaakeri: “¿Risaikashiretantakemi Tasorenkantsi owakera ikemisantakagaitakemi?” Ari ikantaiyanakeni jirikapaini: “Te. ¿Oitaka kantakotachari jiroka? ¿Iitaka ikantaitziri Tasorenkantsi?” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Rakanake Pablo, ikantzi: “¿Iitaka pomitsitsiyaawentakari pikemisantawetaga?” Ikantaiyini jirikapaini: “Iro nomitsitsiyaawentari riyotaantakeri Juan-ni.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ikanta Pablo riyotaanakeri, ikantziri: “Romitsitsiyaatantzi Juan-ni, roshiyakaawentatziiro ripakagaitairo kaariperori. Iro ikantzitakari Juan-ni: ‘Pinkemisantairi awotsikitaintsiri, iri poyaatapaakenane.’ Iriitake Jesucristo ikenkithatakotakeri jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ikanta ikemaiyawakeni jirikapaini, romitsitsiyaawentanakari Awinkatharite Jesús, raakotainiri iwairo jirikapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ikanta Pablo rotzimikapatziitoyetantakari rako, ari risaikashiretantanakari eejatzi iriroripaini Tasorenkantsi. Riñaawaiyetanakero otsipasato ñaantsi. Ikamantantanakero ñaantsi riyotakaayetanairiri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ikaataiyini 12. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Irojatzi rawisantakari Pablo rapatotapiintaiyanira Judá-ite, ari ikenkithatakaantapaake ikaatzi mawa kashiri. Tekaatsi inthaawakaiya, ikowi riyotakaayetairi atziripaini jimpe ikanta Pawa ipinkathariwentantai. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Iro kantacha tzimatsi apawopaini kisoshirewaitatsiri, te ikowi inkemisantaiyeni, ikishimawaitakeri tsipatanaariri iitaitziri “Awotsiweri”. Ikanta Pablo, rintainaryaanakeri jirikapaini. Romiñaanakeri riyotaanewopaini iyaapapankoteki iitaitziro “Tiranno”. Ari riyotaapiintakeri maawoiniki kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ari ikantapiintanakitziiro, tzimakotake apite osarentsi. Ikemakoyetairo riñaane Pawa nampiyetawori Asia-ki, Judá-ite, Grecia-thato, maawoini. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Osheki ritasonkawentantayetake Pablo, ikantakaakari Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Etsiyatakotakaantzita imanthaki. Arika ragaitero tsikarikapaini, riterotantaityaari mantsiyari, aritake retsiyatakotai. Imatziri eejatzi etsiyatakotakagairi raaganewo peyari. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Eenitatsi apaanipaini Judá-ite kenawaitatsiri janta retsiyatakotakayitari eejatzi irirori raaganewo peyari. Ikowake iroñaaka raakotairi iwairo Jesús, retsiyatakotakaantyaariri. Ikantawetapaakari peyari, ikantziri: “¡Pintainaryaapithateri, naakotziro iwairo Jesús, ikenkithatakotziri Pablo!” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iroowa rantawetakari 7 itomipaini Judá-ite jitachari Esceva, jewawetariri imperatasorentsitaneri janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Iro kantacha rakanake peyari, ikantziri: “Noñiiri Jesús, niyotziri Pablo. Eeroka, te niyotzimi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ikanta raayiri peyari rotaiyanakeri jirikapaini, antawoite iñaashintsitanakari roitsinampaakeri maawoini, romishiyairi ipankoki raatonkoryaamerekitakeri, antawo rowatsinawaitakeri iwathaki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ikemaiyakeni nampitawori Efeso-ki, ikemake Judá-ite eejatzi Grecia-thato, maawoini. Osheki ithaawaiyanakeni. Iro opoñaantari ipinkathaitantanakariri Awinkatharite Jesús. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ari ripokapaake osheki kemisantanaatsine, ithawetakoyetapaakero iyaariperonka. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ikanta sheripiyariwetachari, ramayetapaakero tsika riñaanatakotapiintziro isheripiyarinka, ritaapaakero. Ikanta raminakoitakero tsika okaatzi ipinata ritagaitakeri, areetaka ikaatzi: 50,000 ikithoki koriki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Eeke ikemakoperoitanakitziiri Awinkatharite. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Okanta ithonkapaaka jiroka, rominthatanakawo Pablo rareetantya Macedonia-ki eejatzi Acaya-ki. Irojatzi rawisantakyaari janta Jerusalén-ki. Ikantzitaka eejatzi: “Arika niyaatake Jerusalén-ki irojatzi nawisantakyaari Roma-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Rotyaantake Macedonia-ki apite amitakotapiintakeriri, Timoteo eejatzi Erasto, eenitatsi risaikanake irirori Asia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Okanta janta Efeso-ki antawoite riñaanatawakaawentaitakari iitaitziri “Awotsiweri”. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iri poñaakaantakawori jitachari Demetrio, kotsiropakoimpeki. Eenitatsi oshiyakariri irirori riwetsikayetziro oryaani oshiyakaawontsi iyaapapankote iwawanetashitaitari iitaitziro “Diana”. Iriira raantayetari osheki koriki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ipiyotaiyakani maawoini kotsiropakoimpeki. Ikantake Demetrio: “¡Shiramparipaini! Iroowa añaantaiyarini aakapaini jiroka antawaire. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pikemakotaiyakerini iitaitziri Pablo, roitsinampaakeri osheki atziri, ikantayetziri: ‘Riwetsikanewo atziripaini te roshiyari Pawa.’ Te apatziro ikantakero anampiki Efeso-ki, rimatzitakawo maawoini jaka Asia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Te apatziro onkantzimoshiretai eerowa ramanantayeetairi awetsikanewo, iroowa kantzimoshireperotairi ompeya inkemakoitero maawoini awawane Diana jaka Asia-ki, ari ripakagaitanakero ripokaitzi oyaapapankoteki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ikanta ikemaiyawakeni, antawo ikisaiyanakani, ikaimaiyanakeni: “¡Irooperori inatzi Diana, awawanetari jaka Efeso-ki!” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Eeke rakisheenkatanakitzi jirikapaini. Irojatzi rotaiyaitantanakariri Gayo eejatzi Aristarco, raanakeri ipiyotaiyapiintanira atziripaini. Jirika ragaitanakeri iriitake itsipatapiintari Pablo rareetantayeta, Macedonia-satzi rinaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ikowawetaka Pablo inkyaapaakeme irirori, temaita rishineteri riyotaanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ari ikantakari eejatzi ikaatzi jewaripaini raapatziyanewo Pablo, ikantakaantakeri: “Eerowa pimatzitawo eeroka janta.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ikanta janta ipiyotaiyakanira, eeke richeraacheraataiyatziini, te oshiyawakaa okaatzi richeragaiyirini. Tema jirika atziripaini te riyoperotaiyini oita ipiyowentaiyarini, ikaimaminthawaitashitaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iri kantacha apawopaini Judá-ite, iñaakeri Alejandro rosatekaka ipiyotaiyakanira, ishintsineentanakeri riñaawaite. Ikanta Alejandro rowaatzinkawakotanaka imairetantyaarime, kenkithawetanaawo. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Iro kantacha riyotake atziripaini Judá-ite rinatzi jirika Alejandro, eekero rapiitanakitziiro ikaimaiyini, osamani ikantaka ikaimi, ikantaiyini: “¡Irooperori inatzi Diana, awawanetari jaka Efeso-ki!” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Irojatzi ikatziyantanakari osankenawairentzi, romairyaakeri, ikantakeri: “Efeso-satzí, riyotaitzi aakapaini kempoyaawentzirori oyaapapankote awawane Diana, eejatzi oshiyakaawo poñainchari inkiteki. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ontzimatye pinkenkithashiryaawakya kameetha, eero pikoshekantashiwaita. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tema jirika pamayetakeri, te rowaariperotziro yaapapanko, te ikishimaminthatziro awawane. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ikowirika riyakowentante Demetrio itsipayetakari ikaataiyinira, raanakeri ajewariteki raminakoteri, iri wetsikerone okaatzira kantzimoshiretariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Okowarika ayotakotero maawoini aakapaini, kantacha apatoteri maawoini jewari, raminakotantyaawori. ");
INSERT INTO cpbNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Okaatzi awisaintsiri iroñaaka, aritake rowasankewentaitakairo akoshekantaga. Eero otzimi oita ankanteri apiyakowentantyaari.” ");
INSERT INTO cpbNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ikanta rithonkakero ikenkithawaitakero jiroka, rotyaantairi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ikanta reshitanakero rakisheenkataiyini, ipiyotakeri Pablo riyotaanewo ikaminaayetanairi. Ari riwethatanaari, jatake Macedonia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ikanta ikenayetanairo nampitsiki risaikayetzira iyekiite, ikaminaayetanairi. Irojatzi rareetantakari Grecia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ari risaikawaitapaake ikaatzi mawa kashiri. Iro rotetanaiyaame riyaatantyaari Siria-ki, ari ikemake rowamaatyeeri Judá-ite rareetakyaarika janta. Iroowa ripiyantanaari Macedonia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ari itsipatanaari Sópater, Berea-satzi rinatzi irirori, itomi Pirro. Ipoñaapaaka Aristarco, eejatzi Segundo, Tesalónica-satzi rinatzi. Eejatzi Gayo, Derbe-satzi rinatzi. Eejatzi Timoteo, Tíquico, Trófimo, Asia-satzi rinayetatzi jirika. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ari reewataiyanakeni jirikapaini iyeki, royaawentapaakena Troas-ki notsipatakari Pablo. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Okanta awisanake kiteesheri rowapiintantaitawori tashirentsiponka, ari notetanaari Filipos-ki. Awisake 5 kiteesheri, noñaayetapairi janta Troas-ki, ari nisaikaiyapaakeni okaatzi 7 kiteesheri. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Okanta imonkaatapaa kiteesheri rapatotantapiintaitari, ari nopiyotaiyakani nontzipetowero pan, ikenkithatakaantake Pablo. Tema nawisatye onkiteeshetamanairika, eekero riyaatakaanakitziiro ikenkithatzi niyankiityaakotakena. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ari nopiyotaiyakani jenoki pankotsiki, osheki ootamentotsi roonthotaitake. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ikanta apaani mainari jitachari Eutico risaikake omooki pankotsi. Tema osamanitake ikenkithatake Pablo, ayimatakeri iwochokine mainari, paryaake isaawiki, kamapaake. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ayiitanake Pablo, roiyotashitapaakari mainari, ithomaapaakeri. Ikantanake: “Eero pithaawaiyini, añagai.” ");
INSERT INTO cpbNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Eejatzi ripiyanaawo Pablo jenoki, itzipetowapaakero pan, owaiyakani. Eekero ikenkithatanakitzi, irojatzi okiteeshetantanakari. Ari nawisaiyanakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iriima mainari, ragaitanairi rañagaira. Iroowa thaamentashiretakaaperotanakariri. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ari neewatanake naakapaini, notetaiyanakani irojatzi Asón-ki, ari nokenkithashiryaaka naanairi Pablo, tema ikowatzi irirori inkenanake awotsiki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ikanta noñaapairi Pablo janta Asón-ki, ari rotetanaawo, jataiyakenani Mitilene-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Irojatzi nawisantanakari janta, nokiteeshetakotapaake Quío-ki, okanta namaatakotanai apaani kiteesheri areetakena Samos-ki, naatakotapaintzi Trogilio-ki. Irojatzi nawisantanakari otsipaki kiteesheri, areetaiyakenani Mileto-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Irojatzi nawisantanakawori Efeso te naatapaintzi, tema te ikowi Pablo raatapainte janta, eero rosamanitanta Asia-ki. Ikowatzi rareetaiya intsipaite Jerusalén-ki, roimoshirenkapairo kiteesheri “Owiitaantsi”. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ikanta nareetaka Mileto-ki, ikaimakaantapaakeri Pablo itzinkamipaini kemisantzinkari Efeso-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ikanta ripokaiyakeni, ikantawakeri: “Piyotzi eerokapaini jimpe nokanta nisaikimotaiyakemini owakera nareetantakari Asia-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ari nokantapiintatya nantawaitziniri Awinkatharite, tsinampashire nokanta, osheki niraawaitaka noñaakerowa inkoshekename Judá-ite. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iro kantacha te nipakaanakero nokenkithatakaayetzimiro onkaate pinintagaiyaari, niyotaapiintakemi pipankopainiki, eejatzi ipiyotapiintaga atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nokenkithatakaayetziri nosheninkapaini Judá-ite eejatzi Grecia-thato, nokantayetziri: ‘Pipiyashitairi Pawa, pawentagaiyaari Awinkatharite Jesucristo.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iroñaaka niyaatatye Jerusalén-ki, Tasorenkantsira thaamentashiretakaanari, te niyotzimaitya oitarika awishimotenane janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Iro kantacha tsikarika niyaayetzi, riyoshiretakaana Tasorenkantsi, ikantana: ‘Osheki pinkemaatsiwaityaawo romonkyagaitemi.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Iro kantzimaitacha naaka, tekaatsi oitzimotena onkaate nonkemaatsiwaityaari, te netakoneta. Iro kowaperotacha nonkimoshirewentero noshiyakaanakero irootaintsime nanaakotante nareetya jimpe iweyaa nishiye. Tema irootaintsi nithotyeero ikantakenari Awinkatharite Jesús nonkamantantairo Kameethari Ñaantsi okantakota ineshironkayetaira Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nokenkithatakaayetakemi eejatzi eerokapaini tsika okantakota ipinkathariwentantai Pawa. Eero papiitairo piñaayetaina. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Irootake nokowantari nonkantemi, te naaka kantakaashityaawone intzimantaiyaari peyashitaachane, ");
INSERT INTO cpbNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","tema nokenkithatakotakemiro maawoini ikenkithashiriitakari Pawa ranteri, tekaatsi apaani nimanimotemi. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pinkempoyaayetaiya, ari pinkantakaayetaiyaari apatotapiintachari tsika rowayetakeri Tasorenkantsi. Poshiyaiyaari kempoyaantaneri pinkempoyaayetairi kemisantanairiri Awinkatharite, tema iriitake ikapathainkawentake ripinawentairi. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Niyotzi naaka arika niyaatai, ripokapaake itsipapaini, roshiyapaakyaari koweenkari owantaneri, inkowapaake rithonkeri kemisantzinkaripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ari intzimanake pikaataiyinira eerokapaini amatawitanakerine kemisantzinkaripaini, ripakaakaanakeri ikemisantzi, inkantakaakyaari riyotaanewo rashi irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pinkenkithashireero eerokapaini, mawa osarentsi nisaikimowaitapaintzimi, te nipakaapaintero nokaminaayetzimi maawoini, niraakowaitakemi. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nawentaari naaka Pawa iyekiite, iriira aminawentemine, iriitake neshironkatemine, tema irootake ikantayetakairi. Ari inthaamentakaayetaimi, aritake iñaakaayetaimiro okaatzi ikowakaakeriri maawoini oiteshiretaarewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Te niyotziro naaka noñaamatakotantyaari, koriki, ooro, eejatzi ikithaataitari. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Piyotaiyini eerokapaini, naakatake antawaitaintsiri nakoki naantari koityiimoyetanari, ari nonkantzitakari eejatzi naayiniri koityiimoyetariri ikaatzi tsipayetakenari. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ari nokenakairo niyotaantakemirori jimpe ankantero antawaiperotai, aneshironkayetairi koityaawaitatsiri. Iroowa pinkenkithashiretantaiyaawori ikenkithatakotapaintziri Awinkatharite Jesús, ikantake: ‘Osheki ikimoshirewentaitziri neshironkatantaneri, anaanakero okaatzi ikimoshirewetanakaga ipaitakeri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ikanta ikaatanakero Pablo ikantakero jiroka, rotziwerowanaka ramanakaanaari maawoini, piyotainchari. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Maawoini riragaiyanakani, rawithakitaiyakerinira Pablo, riwethatawaari riyaataira. ");
INSERT INTO cpbNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Owashire ikantaiyanakani, tema ikantakerira eero iñagairi. Ari royaataiyanakerini irojatzi rotetantanaari Pablo. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ikanta nookanairi iyekiite, otetaiyanaanani, tampatzika nowanakero niyaatake Cos-ki, okanta okiteeshetamanai areetakena Roda-ki, nawisanake irojatzi Pátara-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ari noñaapaakero antawo pitotsi jatatsine Fenicia-ki, ari notetaiyanakani. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Okanta namaatakotzi, naminakotanakero othampishi Chipre nampateki, nokenakotanake nakoperoki irojatzi Siria-ki. Eenitatsi owaagawontsi rookaitanakeri Tiro-ki, ari naatakotaiyapaakeni. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Noñaapaatziiri kemisantzinkaripaini, ari nisaikimowaitanakeri okaatzi 7 kiteesheri. Ikantawakeri Pablo: “Eero piyaatzi Jerusalén-ki.” Iro ikantantari, riyoshiretakaatziiri Tasorenkantsi. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Okanta imonkaataka 7 kiteesheri, nawisantanaiyaari, ari royaataiyakenani iyekipaini, itsipayetakawo iina, eejatzi reentsite. Irojatzi othapiki nampitsi, ari notziwerokaiyapaakani impanekiiteki, namanaiyani. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ari niwethatawakaanaa, otetanaana naakapaini, piyaiyanaani irirori ipankokipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Irojatzi namaatakotantanaari areetakena Tolemaida-ki, ari niwethatapaari iyekipaini, apaani kiteesheri nisaikimowaitanakeri irirori. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Okanta okiteeshetamanai awisakotanakena, areetakena Cesarea-ki. Irojatzi nokenantanakari ipankoki Felipe kenkithatakaantaneri, ari nisaikapaake. Jirika Felipe iriitake apaani kaatatsi pairani 7 rowaitakeri ramitakoyeteri Otyaantaperori. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Eenitatsi Felipe rishinto mainawo okaatzi 4, kamantantanewo inaiyini. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Shekitake kiteesheri nisaikapaake janta, ari rareetakari kamantantaneri ipoñaakawo Judea-ki, iita Agabo. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ikanta iñaayetapaakena raapaakero romathakiro Pablo, roosotapaakawo rakoki eejatzi iitziki ikenkithawaitanake, ikantzi: “Ari inkantyaari ashitakawori jiroka omathakirontsi, roosoteri Judá-ite janta Jerusalén-ki, raanakeniri kaari asheninkata. Iroowa riyotakaanari Tasorenkantsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ikanta nokemaiyawakeni, nokantakantawetanakari Pablo: “Eero piyaatzi Jerusalén-ki.” Ari ikantawetakariri eejatzi Cesarea-satzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Iro kantacha ikantanake irirori: “¿Iitaka piraantaiyarini, antawowa powashiretakaakena? Kowakena naaka. Arika roosoitakena irojatzi nonkamawentantakyaariri Awinkatharite Jesús janta Jerusalén-ki, imawaityaata.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tera noitsinampaatyeeri, apatziro nokantanake: “Imatyaata ikowiri Awinkatharite.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Okanta okaatapaake jiroka, wetsikaiyanaanani, jataiyakenani Jerusalén-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ari royaataiyanakenani Cesarea-satzi yotaarewopaini rinatzi. Iriira aanakenari ipankoki Chipre-satzi jitachari Mnasón, pairanitake riyotaarewotzi jirika, iriitake nimayimotaiyakerini. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ikanta nareetaiyapaakani Jerusalén-ki, kimoshire ikantaiyani iyekiite iñaawakenaga. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Okanta okiteeshetamanai, raanakena Pablo nareetyaari Jacobo, ari risaikitakari eejatzi maawoini itzinkamipaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Riwethatapaakari Pablo, ikamantapaakeri maawoini oita rantakaayetakeriri Pawa janta inampipainiki itsipasatzi atziripaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ikanta ikemaiyawakeni, ithaamentanakari Pawa. Irojatzi ikantaitantanakariri Pablo: “Iyekí, imapero ishenitake jaka asheninka Judá-ite kemisantanaintsiri, tzimimaitacha rotsiwakakagaitari kemisantzinkaripaini rimonkaatero Inintakaantaitanewo rosankenatakeri Moisés-ni. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ikemakotakemi piyotaayetakeri asheninkapaini nampiyetawori otsipaki nampitsi, pinkantayeterime: ‘Te okowaawo pinkemisantero Inintakaantaitanewo rosankenatakeri Moisés-ni, te okowaawo pitomeshaanitairi pitomipaini, te okowaawo eejatzi antayetairo ameyetari pairani.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tsika ankantyaaka? Yoyetake iroñaaka asheninka, areetaimi jaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jiroka kameethatatsiri panteri: Eenitatsi akaataiyinira jaka, ikaatzi 4 atziri monkaaterone ikowakaantziri. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pintsipatanakyaari jirikapaini, pantero onkaate kitewathatakagaimine. Arika rameetaitakeniri iishi, eeroka pinakowenterine ritagaiteri. Iroowa riyoitantyaari thaiyaantsi ikantakoitzimiri, tema pimonkaatzitawo eeroka Inintakaantaitanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Irooma naakapaini, niyotzi ikenakaashitakawo asheninkapaini shintsiwaiwetachari rimonkaatakaanterome Inintakaantaitanewo. Tema ikaatzi kaari asheninkayeta kemisantayetaatsiri, notyaantakeniri pairani osankenarentsi okaatzi nokenkithashiretaiyakarini jaka, nokantakeri: ‘Eero powayetari wathatsi ritagaitziniriri iwawanetashiyeetari. Eero powakoyetawo riraa piratsi. Eero pimayempiwaitzi.’ Apatziro rantayetairo jiroka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ikanta Pablo raanakeri 4 atziri. Okanta okiteeshetamanai itsipatakari ikitewathatakagaitairi, ikyaake tasorentsipankoki inkamantante jimpe onkaate kiteesheri ithonkantyaari ikowakaantakeri, ikenkithatakotakero tsikapaite ramantyaari apawopaini rashitakayaariri Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Okanta imonkaatzimatapaaka 7 kiteesheri, eenitatsi Judá-ite poñaayetachari Asia-ki, iñaakeri Pablo janta tasorentsipankoki. Rapatotake atziripaini, ripokashiteri Pablo rotaiyeri, ");
INSERT INTO cpbNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ikaimaiyini, ikantzi: “¡Shiramparipaini! ¡Israel-iite! ¡Pamitakotena! Jirika atziri kenakenayetatsiri tsikarikapaini riyotaayetziri atziripaini pithokashitariri asheninkapaini, pithokashitawori Inintakaantaitanewo rosankenatakeri Moisés-ni, pithokashitzitawori tasorentsipanko. Iro maperotaincha, ikyaakaakeri kaari asheninkata tasorentsipankoki, rithainkatasorentsiwaitakero.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Iro ikantantawori jiroka tema iñaakitziiri Pablo janta Jerusalén-ki itsipatakari Trófimo poñaachari Efeso-ki, roshiyakaatzi ikyaakaatziiri tasorentsipankoki. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Piyotaiyapaakani osheki atziri, shiyaiyapaakani, rotaiyapaakeri Pablo, inoshikanakeri romishitowakeri jekokeroini tasorentsipankoki, rashitanakero. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Iroowetaincha ritsitokerime, ari ikamantaitakeri reeware owayeripaini poñaachari Roma-ki, ikantaitakeri: “Ikoshekawakagaitya janta.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ikanta reewarite raanake rowayerite, riyaatashitanakeri ipiyotaiyakanira atziri. Ikanta iñagaiyawakerini ripokake, ripakaanakeri ripasataitziri Pablo. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Rotaiyaitapaakeri Pablo, ikantanakeri rowayerite: “Poosotantyaari apite kotsirotha.” Rosampitanakeri atziripaini: “¿Iitaka jirika, iitaka rantakeri?” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Eenitatsi cheraanaintsiri, temaita oshiyawakaa okaatzi richeraawetaiyakarini. Te riyotero jewari oita awisatsiri. Rotyaantakeri rowayerite raanakeri Pablo rimaapiintaiyinira. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ikanta roirinkakaawetari Pablo, eekero ishintsitatzi atziripaini ikowi ripasawaiteri, iroowa inatantanakariri owayeripaini rookaakowenteri. ");
INSERT INTO cpbNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Maawoini atziri royaatakowentanakeri, ikaimaiyini: “¡Powamayeriwé!” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Iroowetaincha romonkyagaiteri rimaapiintzira owayeri, rosampitanakeri Pablo jewari, ikantziri: “¿Kantachama nonkenkithawaitakaimi eepichokiini?” Ari ikantanake jewari: “¡Jimpe piyotziroka niñaane! ");
INSERT INTO cpbNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Tema Egipto-satzi pinatzi eeroka poñaakaantakawori chapinkipaite koshekaantsi? Pikenapaakero ochempiki, pamake 4000 owayeri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ikantanake Pablo: “Judá-ite ninatzi naaka, nopoñaawo Tarso-ki saikatsiri Cilicia-ki. Otzinkami inatzi nonampi. Nokowi pishinetena nonkenkithawaitakairi nosheninka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Rishinetakeri. Katziyanaka Pablo pawitsiki, rowaatzinkawakotanaka imairetantyaari isheninkapaini. Mairetaiyanakeni. Kenkithawaitanake Heber-thato riñaaneki irirori, ikantanakeri: ");
INSERT INTO cpbNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Iyekí, Ashitantanerí, pinkeme nonkenkithatakotya.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ikanta ikemaiyawakerini riñaaneki irirori Heber-thato, imaireperotaiyanakeni. Eeke ikantanakitzi Pablo: ");
INSERT INTO cpbNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Judá-ite ninatzi naaka. Notzimake Tarso-ki saikatsiri Cilicia-ki, nokimotatake jaka Jerusalén-ki, riyotaanewo Gamaliel ninatzi, niyotakoperotziro Inintakaantanewo acharinepaini. Nokowake naaka noshireperotyaari Pawa, pikantakaga eerokapaini iroñaaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pairani nopatzimaminthatakeri iitaitziri ‘Awotsiweri’ nowamaayeteri. Osheki nonoshikayetake atziri, ari nokantakero eejatzi tsinane, maawoini, nomonkyaakaantayetakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Iñaakena maawoini reeware Imperatasorentsitaarewo eejatzi Itzinkamipaini nantayetakero jiroka. Iriitake pakenawori osankenarentsi ipakaantziri asheninka Judá-ite janta Damasco-ki. Irojatzi niyaatantakari janta nithotyaakoyetziri jirikapaini, namayeteri jaka Jerusalén-ki rowasankeeteri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Okanta nanashita awotsiki, irootaintsi nareetya Damasco-ki, ikaatake tampatzika ooryaa, ari romapokakenari morekanaintsiri inkiteki, roorentapaakena nokatziyakaga, ");
INSERT INTO cpbNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tyaanakena kipatsiki. Nokematzi riñaanaitana, ikantzi: ‘¡Saulo! ¡Saulo! ¿Iitaka poyaakyaaminthatantanari?’ ");
INSERT INTO cpbNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nosampitanakeri naaka: ¿Piitaka Pinkatharí? Ari rakaitanakena: ‘Naakatake Jesús Nazaret-satzi poyaakyaaminthatakeri.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ikaatzi tsipatakenari iñagaiyakerini oorentapainchari, antawoite ithaawaiyanakeni, temaita ikemathatawakeri iriroripaini riñaanaitakenaga naaka. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ari nosampitanakeri, nokantziri: ‘Pinkatharí. ¿Iitaka pikowiri nanteri naaka?’ Ikantanakena Pinkathari: ‘Pinkatziye, piyaate nampitsiki Damasco-ki. Ari inkamantaitemi oita panteri.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Imawityaakitakaanakena oorentakenari, rakathatashitaana notsipayetakari irojatzi Damasco-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ari risaikiri janta atziri iita Ananías, pinkathatasorentsitane rinatzi, rimonkaayetziro Inintakaantaitanewo rosankenatakeri Moisés-ni. Pinkatha rowiri maawoini Judá-ite nampiyetawori Damasco-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Pokake Ananías iñeena. Ikanta rareetapaaka, ikantapaakena: ‘Iyeki Saulo, pokiryagai.’ Apathakero nokiryaanai, aminawaitanaana. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Eeke ikantanakityaana Ananías: ‘Eeroka riyoyaake Iwawane acharinepaini. Riyoyaakemi piyotantaiyaawori ikowakaimiri irirori, piñagairi Cristo tampatzikatatsiri, pikemawaantetairi eejatzi. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Eerokatake kenkithatakotairine maawoiniki atziri. Pinkamantairi okaatzi piñaakeri, okaatzi pikemakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tekaatsi poyaawentanake. Pinkatziye iroñaaka, pomitsitsiyaatya, paakotairi iwairo Awinkatharite pinkowakotairi impeyakotaimiro piyaariperonka.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Okanta nipiyapaawo Jerusalén-ki, niyaatake tasorentsipankoki namaña, ari noñaawyaatakari janta. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Noñaakeri Awinkatharite, ikantakena: ‘Intsipaite pishitowanake Jerusalén-ki, tema eero ikemisantaitzimi pinkenkithatakotena jaka.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ari nokantanakeri naaka: ‘Pinkatharí, riyotaiyini maawoini niyaatapiintzi tsika rapatotapiintaita, nomonkyaakaantayetakeri ikaatzi kemisantayetzimiri, osheki nipasatakaantawaitakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tema rowamagaitakeri pairani pimperatanewo Esteban, kenkithatakotzimiri eeroka, ari nokaatzitakari naaka janta, naapatziyakotakari owamaakeriri, nokempoyaakeniri iithaarepaini.’ ");
INSERT INTO cpbNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Iro kantacha ikantanakena Pawa: ‘Piyaate, naakatake otyaantemine intaina risaikayetzira kaari pisheninkata.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ikanta ikemawakero atziripaini jiroka, rapiitaiyanakeroni ikaimaiyini ikantzi: “¡Jirika atziri te onkameethate rañe! ¡Pashireeyaari!” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Eeke ishintsitatzi ikaimaiyini, rotekakotaiyani iithaareki. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ikanta jewari, ikantakeri rowayerite: “Paanakeri inthomoikinta jirika, apasatawakeriita inkamantantairori oita ikenkithawaitakeri rowatsimaantakariri isheninkapaini.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ari roosoitanakeri ripasatantaityaariri, rosampitanakeri Pablo itsipa jewari, ikantziri: “Rosankenatakotanewo Roma-satzi ninatzi naaka. ¿Shinetaantsitatsima ripasawaitaitena, te raminakoitawakenawo oitarika nokenakaashitakari?” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ikanta ikemawake jirika, ripiyashitanakari reewarepero, ikantapairi: “Nowinkatharité, ¿Piyotakema oita antakeri? Iriitake jirika, rosankenatakotanewo awinkathariperote saikatsiri Roma-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ikanta ikemawake, ripokashitapaakeri Pablo, rosampitapaakeri: “¿Pimaperotatyaama posankenatakoperota eeroka?” Ari rakanake Pablo, ikantzi: “Jee.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ikantzi jewari: “Osheki nipinakowentakari naaka nosankenatakotantyaari.” Ikantzi Pablo: “Te naaka, rosankenatakoitzitakena owakera notzimapaake.” ");
INSERT INTO cpbNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ikemaiyakeni ikantake, roosoryaakotanakeri. Ithaawakaanakawo jewari, roosotakaantakeri osankenatakotachari Roma-ki. ");
INSERT INTO cpbNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Okanta okiteeshetamanai, ikowi riyote jewari oita ikoshekaminthatantariri Judá-ite Pablo. Ipiyotakaantakeri reeware Imperatasorentsitaarewo, eejatzi reewarepero Judá-ite. Romishitowakaantakeri Pablo, roisaikakeri ipiyotaiyanira. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Rotzikanaminthatapaakari Pablo jewaperori piyotainchari, ikantanakeri: “Iyekiite, nokempoyaapiintaka naaka eero otzimanta nantzimoteriri Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ikanta Ananías, Imperatasorentsiperori, ripasawaantetakaantakeri Pablo. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ikantanakeri Pablo: “¡Thaiyawairentzí! Pawa pasatemine eeroka! Saikawetatsimi jaka paminakoterome Inintakaantaitanewo, ¿Tema pipiyathatakawo eeroka pipasatakaantakenaga?” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ikanta piyotainchari, ikantanakeri Pablo: “¿Arima pinkanteri pinkaweyeri Rimperatasorentsiperotaarewote Pawa?” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ikantzi Pablo: “Iyekiite, te niyoweta naaka Imperatasorentsiperotaarewo rinatzi, tema okantzi Osankenarentsipero: ‘Eero pikaweyiri jewatakaantatsiri.’ ” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Riyotakotakeri Pablo ikaatzi jewaperori piyotainchari, apaanipaini Sadoc-iite rini, iriima itsipapaini Fariseo rinatzi. Ikantzi Pablo: “Iyekiite, Fariseo ninatzi naaka, eejatzi maawoini nosheninkapaini. Iroowa riyakowentantaitanari iroñaaka tema niyotakotaatziiro rañagaira kamaintsiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ikantakera Pablo, ari riñaanaminthatawakaanakari Fariseo-paini eejatzi Sadoc-iite. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tema ikantapiintzi Sadoc-iite: “Eero rañaayetai kamayetaintsiri, tera otzimi shiretsi, tera itzimita maninkari.” Iriima Fariseo-paini, riyoyetzi irirori imaperotatya jirokapaini. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ari richeraanake maawoini. Ikanta yotzinkaripaini Fariseo, ikatziyanaka, ikantanake: “Jirika atziri te otzimi iyenakaashitanewo. Aamaaya maninkari ñaanashiretakeriri, kaaririka shiretsi.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Eeke ishintsitatzi richeragaiyini. Ikenkithashiryaanaka reeware owayeripaini, ikantzi: “Naanairiita Pablo, rowaariperotaitzirikari.” Ikaimakaantake rowayerite romishitowairi, raanairi rimaapiintaiyinira. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Okanta otsirenitanai, eejatzi roñaaganaari Awinkatharite, ikantairi: “Pablo, eero pithaawi, arira pinkenkithatakotakena Roma-ki poshiyakairo jaka Jerusalén-ki.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Okanta okiteeshetamanai, ikenkithawaitake Judá-ite, ikantawakaiyani: “Jame atziwentashityaari Pablo irojatzi atsitokantakyaariri. Eerorika nimonkaatziro, rowasanketainaata Pawa.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Aamaaka ranaanakeri 40 atziri ikaataiyini kantaintsiri. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Irojatzi riyaatashitantanakariri reeware Imperatasorentsitaarewo, eejatzi Itzinkamipaini, ikantaiyakerini: “Nitziwentaiyarini Pablo irojatzi nitsitokantakyaariri. Eerorika nimonkaatziro, rowasanketainaata Pawa. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Janjaatya paapatziyawakaiya eerokapaini pikaatzi papatotapiinta, pinkowakotairi reeware owayeripaini, pinkantairi: ‘Pamainari Pablo onkiteeshetamanairika naminakoperotainiri iyenakaashitane.’ Aamaawenta nonkantaiyaani naaka nitsitokawakeriita tekera rareetapaakaata jaka.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kemake itzineri Pablo, jatanake rimaapiintaiyinira owayeri ikamantapaakeri. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ikanta Pablo ikaimake apaani owayeri, ikantakeri: “Paanakeniri pitzinkami jirika mainari, eenitatsi oita inkamanteriri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ikanta owayerika raanakeniri itzinkami, ikantapaakeri: “¡Itzinkami! Ikowakotakena Pablo namakemiri jirika mainari, eenitatsi inkamantemiri.” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ikanta jewarika, raanakeri mainari jantyaatsikaini, rosampitakeri: “¿Oitaka pinkamantenari?” ");
INSERT INTO cpbNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ikantanake mainari: “Ikenkithashiretaiyakani Judá-ite inkowakotemi onkiteeshetamanairika paanairi Pablo janta rapatotapiintaiyanira jewaripero, raminakoperotero iyenakaashitanewo. ");
INSERT INTO cpbNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Eero pikemisantziri, tema manaiyakani 40 atziri. Ikantaiyakeni: ‘Jame atziwentashityaari Pablo irojatzi atsitokantakyaariri. Eero owashitari, eero arita amere. Eerorik