﻿USE sofia;
DROP TABLE IF EXISTS sofia.cpaNT_vpl;
CREATE TABLE cpaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cpaNT_vpl WRITE;
INSERT INTO cpaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lah¹la² báh³ lǿa¹² si² ja³ni³ton¹² dsa² hóg¹ quián¹² Jesucristo, tsø³jong¹³ hlai³ David, tsø³jong¹³ hlai³ Abraham. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Lán¹² Abraham ti³jmi² Isaac. Lán¹² Isaac ti³jmi² Jacob. Lán¹² Jacob ti³jmi² Judá ca¹lah¹quianh¹³ roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Lán¹² Judá ti³jmi² Fares quianh¹³ Zara. (Tamar báh³ lán¹² mi³chiég³dsa.) Lán¹² Fares ti³jmi² Esrom. Lán¹² Esrom ti³jmi² Aram. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lán¹² Aram ti³jmi² Aminadab. Lán¹² Aminadab ti³jmi² Naasón. Lán¹² Naasón ti³jmi² Salmón. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Lán¹² Salmón ti³jmi² Booz. (Rahab báh³ lán¹² mi³chiég³dsa.) Lán¹² Booz ti³jmi² Obed. (Rut báh³ lán¹² mi³chiég³dsa.) Lán¹² Obed ti³jmi² Isaí. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Lán¹² Isaí ti³jmi² rai¹³ David. Lán¹² rai¹³ David ti³jmi² Salomón. (Mi³lán¹² mi³chiég³ Salomón hio¹³ quián¹² hlai³ Urías.) ");
INSERT INTO cpaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Lán¹² Salomón ti³jmi² Roboam. Lán¹² Roboam ti³jmi² Abías. Lán¹² Abías ti³jmi² Asa. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Lán¹² Asa ti³jmi² Josafat. Lán¹² Josafat ti³jmi² Joram. Lán¹² Joram ti³jmi² Uzías. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Lán¹² Uzías ti³jmi² Jotam. Lán¹² Jotam ti³jmi² Acaz. Lán¹² Acaz ti³jmi² Ezequías. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Lán¹² Ezequías ti³jmi² Manasés. Lán¹² Manasés ti³jmi² Amón. Lán¹² Amón ti³jmi² Josías. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Lán¹² Josías ti³jmi² Jeconías ca¹lah¹quianh¹³ roh¹³dsa. Dsa² héi² mi³chian² jmai³ ca¹tai¹ dsa² chian² Babilonia dsa² israel juu¹² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mi³ca¹løa¹ lah¹jøng², ca¹lø¹chián¹ Salatiel, ja³ŋiúh³ Jeconías. Lán¹² Salatiel ti³jmi² Zarobabel. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Lán¹² Zorababel ti³jmi² Abiud. Lán¹² Abiud ti³jmi² Eliaquim. Lán¹² Eliaquim ti³jmi² Azor. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Lán¹² Azor ti³jmi² Sadoc. Lán¹² Sadoc ti³jmi² Aquim. Lán¹² Aquim ti³jmi² Eliud. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Lán¹² Eliud ti³jmi² Eleazar. Lán¹² Eleazar ti³jmi² Matán. Lán¹² Matán ti³jmi² Jacob. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Lán¹² Jacob ti³jmi² José, dsa² ŋioh¹² quián¹² María, mi³chiég³ Jesús, dsa² tǿh²dsa Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hi² jøng² lán¹² hlai³ David ja³ma²guia¹tón² dsieg³ hlai³ Abraham. Ni³ jøng² mi³ca¹tǿ² ja³ca¹tai¹ dsa² chian² Babilonia dsa² israel juu¹² go²dsa, ma²ca¹lø¹chián¹ Jeconías, dsa² lán¹² ja³ma²guia¹tón² dsieg³ Salomón, ja³ŋiúh³ hlai³ David. Jøng² lán¹² Jesús ja³ma²guia¹tón² dsieg³ Jeconías. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lah¹la² báh³ ca¹lø¹chián¹ Jesucristo: Mi³ma²lǿa¹² jǿg³ hi² jian¹ José María, dsa² lén² mi³chiég³ Jesús, jøng² ca¹can¹ María guing² quianh¹³ hi² ca¹jmo¹ jmi²dsí² han¹³ quiah¹² Diú¹³. Ni³ jøng² cónh¹ niúh¹ jín³ hi² ca¹jiag¹ José, ca¹lø¹lén¹³ María hi ma²quian¹²dsa guing². ");
INSERT INTO cpaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jøng² dsa² hniu¹ ju³lah lǿa¹² lei¹³ báh³ José. Hi² jøng² lë́²dsa mi³hén²dsa jǿg³ quiah¹²dsa quianh¹³ María. Cónh¹jøng² mi³jmo¹dsa lah¹jøng² ja³tsa¹léi¹³. Di³ tsa¹hniu¹dsa cán² María ju²hiíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lah¹jøng² mi³dsø²jiag¹² dsǿa¹² José, mi³ca¹quë¹dsa jan² ángel quián¹² Juu¹³ jniang³. Jøng² ca¹juúh² ángel: ―José, tsø³jong¹³ hlai³ David, tsa¹jmóh³hning ju²hí³ dsøa¹² hi² janh¹³hning María, mǿ² quiánh² hning². Di³ jmi²dsí² han¹³ quiah¹² Diú¹³ ca¹jmo¹ hi² ma²quian¹² María guing². ");
INSERT INTO cpaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Li¹chian² jan² guing² dsa² ŋioh¹² quián¹²dsa. Tøah¹³hning guing² héi² Jesús. Lah¹jøng² li¹tsen² guing². Di³ liúg² guing² dsa² go²dsa dsag³ hi² ni³re²dsa ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ca¹lah¹jǿ¹ hi² jøng² ca¹løa¹, mi³jøng² li¹hian¹² jǿg³ la² quiah¹² Juu¹³ jniang³, jǿg³ ca¹he¹ dsa² hǿ² jǿg³ quiah¹² Diú¹³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jan² tsih² mǿ² hmë́², cán²dsa jan² guing². Li¹chian² jan² guing² dsa² ŋioh¹² quián¹²dsa. Li¹tsen² guing² héi² Emanuel, hi² hniu¹dsa juúh²dsa: Diú¹³ quianh¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jøng² mi³ca¹ŋié¹ José, ca¹mi¹ti¹dsa jǿg³ cónh¹ lǿa¹² héh¹ ca¹jmo¹ ángel quián¹² Juu¹³ jniang³. Jøng² ca¹jian¹dsa María. ");
INSERT INTO cpaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Di³ tsa¹ca¹hlanh¹dsa María ca¹lah¹ca¹tǿ² ja³ca¹lø¹chián¹ guing² ne¹³ quián¹²dsa. Jøng² ca¹tǿh¹ José guing² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ca¹lø¹chián¹ Jesús jøa³juøi² Belén, juøi² tén¹² Judea, jmai³ mi³lán¹³ Herodes rai¹³. Jøng² dsa² canh¹³, dsa² ŋi¹², dsa² chian² juu¹² ta¹lah¹juu¹² ja³hian² hieg², ca¹ja¹lé²dsa juu¹² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ca¹juúh²dsa: ―¿Nai¹² rai¹³ quián¹² dsa² judío, rai¹³ ma²ca¹lø¹chián¹? Di³ ca¹ne¹³ jnieh³ mi³ca¹uǿi² jan² chi³neng¹² jmo¹² léi¹³ ma²ca¹lø¹chián¹dsa. Jøng² ma²ja² jnieh³ hi² mi³juanh¹³ jnieh³ dsa² héi² ―ca¹juúh² dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jøng² ca¹qui² ca¹hlan¹ dsǿa¹² rai¹³ Herodes quianh¹³ ca¹lah¹já¹ dsa² chian² Jerusalén, mi³ca¹nǿng²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jøng² ca¹tǿh¹ Herodes ca¹lah¹já¹ juu¹³ jmi²dsa² ca¹lah¹quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Ca¹ŋai¹ Herodes ha² ja³mi³li¹chian² Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jøng² ca¹juúh² dsa² héi²: ―Jøa³juøi² Belén báh³ li¹chian²dsa, juøi² tén¹² Judea. Di³ lah¹jøng² báh³ lǿa¹² si² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Lah¹la² rø²juúh² si²: ");
INSERT INTO cpaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Hniah¹², dsa² chian² Belén, juøi² tén¹² huø¹ quiah¹² Judá, ha¹chi² hiug¹² tsa¹quienh¹² hniah¹² cónh¹ jín³ dsa² canh¹³, dsa² chian² Judá. Di³ jøa³ hniah¹² li¹chian² jan² dsa² dsen¹³, dsa² cán² ni³ quiah¹² dsa² quián¹² Diú¹³, dsa² israel, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ni³ jøng² ca¹tǿh¹ Herodes tø¹cøg¹² dsa² canh¹³, dsa² ca¹u¹lé² héi². Ca¹ŋai¹dsa ca¹mi¹dsøg¹²dsa dsǿa¹² he² jmai³ lah¹dsóh² ca¹jnia¹ chi³neng¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jøng² ca¹tsei¹dsa juu¹² Belén. Ca¹juúh²dsa: ―Gu³noh¹² hniah¹² ja³jøng². Gu³jaih³ hniah¹² cu²rø² ha²lah lǿa¹² quiah¹² guéng¹. Jøng² jmóh³ hniah¹² jøg³ na³ma²ca¹dsanh¹² hniah¹² guing². Mi³jøng² nei¹³jni calah, hi² mi³juanh¹³jni guing² ―ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jøng² ca¹ŋi¹lé² dsa² canh¹³ mi³ca¹nǿng²dsa jǿg³ ca¹juúh² rai¹³. Jøng² dság¹² chi³neng¹² héi², chi³neng¹² ca¹jë́²dsa mi³ca¹uǿi² juu¹² guiuh¹³. Dság¹² ma²jiá¹² ni³ dsa² héi² ca¹lah¹ca¹dsiég¹ cu¹dsøg¹² ja³hiúg³ guing². Jøng² ca¹jŋi¹ chi³neng¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jøng² hiug¹² cu¹té¹² hioh¹² jenh¹² dsa² canh¹³ ca¹løa¹ mi³ca¹jë́²dsa calah chi³neng¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jøng² mi³ca¹ŋi¹togh¹dsa dsi²néi², ca¹jë́²dsa guing² quianh¹³ María, mi³chiég³ guing². Jøng² ca¹chi¹jné¹dsa. Ca¹mi¹juanh¹²dsa guing². Ca¹ní¹dsa gog¹² quiah¹²dsa. Ca¹cuúh¹dsa guing² cog³niáng¹³, quianh¹³ chiun², quianh¹³ nang³ ma²juøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ni³ jøng² ca¹cøa¹ dsa² canh¹³ hi² tsa¹ma¹dsø¹lia¹dsa juu¹² ja³guǿ¹³ Herodes. Hi² jøng² ca¹ŋi¹lia¹dsa juu¹² siíh², ca¹tǿ² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jøng² mi³ca¹ŋi¹lia¹ dsa² héi², ca¹quë¹ José jan² ángel quián¹² Juu¹³ jniang³. Ca¹juúh² ángel: ―¡Nung²! ¡Tei³ guing² quianh¹³ mi³chiég³ guing²! Cuøin¹² juu¹² Egipto. Ja³jøng² gu³níh²hning ca¹lah¹ca¹jmo¹jni jǿg³. Di³ na¹ bíh³ hnah¹² Herodes guing² hi² jŋaih¹dsa guing² ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jøng² ca¹nung² José ja³neng². Ca¹cuøin¹dsa quianh¹³ guing², quianh¹³ mi³chiég³ guing². Ca¹ŋi¹lé²dsa juu¹² Egipto. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja³jøng² ca¹túgh²dsa ca¹lah¹ca¹jon¹ Herodes. Mi³jøng² li¹ti¹ jǿg³ quiah¹² Juu¹³ jniang³ hi² ca¹juúh² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Lah¹la² ca¹juúh²dsa: “Huø¹ Egipto báh³ ca¹tai³jni jon¹jni,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jøng² mi³ca¹lø¹lih¹³ Herodes ma²ca¹mi¹gag¹³ dsa² canh¹³ héi², ca¹lø¹hné¹ hlaih¹³dsa. Jøng² ca¹jmo¹dsa héh¹ hi² dsián¹ ca¹lah¹já¹ guing² dsa² ŋioh¹² tsa¹ma²tǿ² ton¹ ŋih¹², guing² chian² ta³cøng² ja³tén¹² Belén, ca¹lah¹ cónh¹ jmai³ ca¹juúh² dsa² canh¹³ héi² hi² ca¹lø¹chián¹ guing². ");
INSERT INTO cpaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lah¹jøng² báh³ ca¹lø¹ti¹ jǿg³ ca¹juúh² hlai³ Jeremías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Di³ lah¹la² ma²ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ca¹niúh² cu²møah¹³ jøa³juøi² Ramá, hi² tø²ho¹² hlaih¹³ dsa², hi² héng²dsa. Ho¹² Raquel, huu¹³ quiah¹² guing² quián¹²dsa. Tsa¹hniu¹dsa mi³gú²dsa liáh². Di³ ma²ca¹dsan¹ guing², ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jøng² mi³ca¹jon¹ Herodes ca¹jnia¹ jan² ángel quián¹² Juu¹³ jniang³, hi² ca¹cøa¹ José huø¹ Egipto. Jøng² ca¹juúh² ángel: ");
INSERT INTO cpaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―¡Nung²! ¡Tei³ guing² quianh¹³ mi³chiég³ guing²! Jøng² guǿnh³hning juu¹² huø¹ quián¹² dsa² israel. Di³ ma²ca¹dsan¹ dsa² hniu¹ mi³jŋaih¹dsa guing² ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jøng² ca¹nung² José. Ca¹tai¹dsa guing² quianh¹³ mi³chiég³ guing². Ca¹ŋi¹lia¹dsa juu¹² ja³tiogh³ dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jøng² mi³ca¹nǿng²dsa hi² ma²lán¹² Arquelao rai¹³ ja³tén¹² Judea, ja³mi³jmo¹² Herodes ti³jmi²dsa héh¹, jøng² ca¹lø¹goh¹²dsa hi² dsa¹lia¹dsa juu¹² jøng². Hi² jøng² ca¹ŋi¹lia¹dsa juu¹² ja³tén¹² Galilea. Di³ lah¹jøng² løa¹² jǿg³ hi² ca¹cø¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mi³ca¹dsi¹lia¹dsa ja³jøng², ca¹túgh²dsa jøa³juøi² Nazaret. Mi³jøng² li¹ti¹ jøg³ ca¹juúh² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³, jǿg³ hi² tǿh²dsa Jesús dsa² nazareno. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mi³ma²ni³ŋó¹³ ji²ŋi², jøng² ca¹dsiég¹ Juan, dsa² chiog¹² dsa² jmøi², cøng² ja³ha¹chian² dsa² tiogh³, huø¹ tén¹² Judea. Ca¹téng²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ca¹juúh²dsa: ―Ju³jeinh¹³ hoh¹² hniah¹². Di ja¹quien¹³ jií¹ ja³jmo¹ Diú¹³ héh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Di³ Juan báh³ dsa² ca¹hia¹ hlai³ Isaías, dsa² hǿ² jǿg³ quiah¹² Diú¹³. Lah¹la² rø²juúh² si² quiah¹²dsa: Jan² dsa² hløah¹ tí² ja³ha¹chian² dsa² tiogh³. Juúh²dsa: “¡Jmo³ ju²jŋia¹³ juu¹² ja³ŋøa¹ Juu¹³ jniang³! ¡Jmo³ cu²dsøg¹² juu¹² ja³ŋøa¹dsa!” juúh²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mi³quieih¹² Juan hmøah¹² løa¹² jŋiú³ camello. Mi³chi³hŋieng¹² cøng² løg² togh¹²dsa. Mi³cugh¹²dsa chi³nøh². Mi³hǿnh²dsa jmø³tah¹² ca¹dsagh¹ ja³ha¹chian² dsa² tiogh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jøng² ca¹ŋi¹lé² dsa² chian² jøa³juøi² Jerusalén, quianh¹³ dsa² chian² ta³cøng² ja³tén¹² Judea, quianh¹³ dsa² tiogh³ cøg¹² ja³hiu³ jmøi² Jordán. Ca¹ŋi¹lé²dsa ja³tsenh¹³ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ca¹tiog¹²dsa dsǿg³dsa. Jøng² ca¹jŋó²dsa jmøi² ca¹chiag¹ Juan chi²jmøi² Jordán. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jøng² mi³ca¹jë́² Juan jue¹² dsa² fariseo quianh¹³ dsa² saduceo, dsa² ja²lén² hniu¹ tsóg¹ jmøi², jøng² ca¹juúh² Juan, ca¹tsáih¹dsa dsa² héi²: ―Hniah¹², dsa² lanh¹² ju³lah lán¹² møh², héi¹ dsa² nang¹² jǿg³ quiah¹² Diú¹³ hniah¹² hi² mi³liúgh² hniah¹² ja³na¹ bíh³ cuø¹ Diú¹³ jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dsio¹ mi³tih³ hniah¹² ju³lah jan² dsa² lah¹dsóh² ma²ca¹jéinh¹ dsǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tsa¹ju³lë́h³ hniah¹² hi² ha¹chi² hi² jénh³ hniah¹² huu¹³ hi² ni³lanh¹² hniah¹² tsø³jong¹³ hlai³ Abraham. Tiúh¹ báh³ Diú¹³ jmo¹ li¹chian² tsø³jong¹³ hlai³ Abraham quianh¹³ cang³ ná¹² ti³gah¹ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja¹quien¹³ lé² quiánh² hniah¹² ju³lah lǿa¹² quiah¹² hma² tsa¹cuø¹² mǿi² gøah¹²dsa. Hma² jøng² quiuh¹²dsa. Jmo¹²dsa cuai³. Dsii¹²dsa si². Lah¹jøng² dsa¹hénh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lah¹dsóh² chiog¹² báh³ jní² hniah¹² jmøi², ju³na³ hein² hniah¹² ma²ca¹jéinh¹ hoh¹². Cónh¹jøng² jií¹ jan² dsa² tø¹chi³qu³ë́¹, dsa² hiug¹² jín³ chi² bí³ quiah¹² cónh¹ jín³ jní². Tsa¹lë́²jni ta³tén¹³jni hi² can³jni løg² dsǿ² tai³ dsa² héi². Dsa² héi² tí² jmi²dsí² han¹³ quiah¹² Diú¹³ quiánh² hniah¹². Jmo¹dsa hi² lénh² hniah¹² dsa² ti³jan¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma²tsenh¹²dsa ju²jŋia¹³ hi² quiáh²dsa dsa² li¹quianh¹³dsa ju³lah jan² dsa² juú² quii¹². Chiag¹dsa hi² dsio¹. Jøng² jøn¹dsa hi² tsa¹dsio¹ quianh¹³ si² tsa¹øg² ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jmai³ jøng² mi³guǿ¹³ Jesús juøi² ja³tén¹² Galilea. Jøng² ca¹ŋó¹dsa juu¹² ja³hiu³ jmøi² Jordán, ja³tsenh¹³ Juan. Mi³jøng² tsóg¹dsa jmøi² chiag¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jøng² tsa¹mi³hniu¹ Juan hi² chiog¹dsa Jesús jmøi². Ca¹juúh² Juan, ca¹tsáih¹dsa Jesús: ―Hning² báh³ dsa² mi³chiagh¹³ jní² jmøi². ¿He² løa¹ hnøngh²hning chióg¹³jni hning² jmøi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jøng² ca¹juúh² Jesús: ―¡Ju³lé³ lah¹jøng²! Di³ hi² hniuh¹² hi² mi³ti³ jniang³ ca¹lah¹jǿ¹ héh¹ hi² ca¹jmo¹ Diú¹³ ―ca¹juúh²dsa. Jøng² ca¹chiog¹ Juan Jesús jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mi³ca¹jŋó² Jesús jmøi², dsø¹juu¹² jøng² ca¹u¹hái¹ Jesús dsi²jmøi². Jøng² ca¹ná² ŋi¹juǿi¹. Ca¹jái¹ Jesús ma²siag² jmi²dsí² han¹³ quiah¹² Diú¹³, hi² jniá² jmi²dsí² ju³lah jniá² jan² jug², ca¹hǿi² dsi³guiuh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jøng² ca¹hløah¹ Diú¹³ guiuh¹³ ŋi¹juǿi¹. Ca¹juúh²dsa: ―Dsa² lang¹² báh³ dsa² lán¹² jon¹jni, dsa² hnó¹jni, dsa² tøa¹² dsøa¹jni ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jøng² ca¹jian¹ jmi²dsí² quiah¹² Diú¹³ Jesús juu¹² ja³ha¹chian² dsa² tiogh³, ja³ca¹jmo¹ dsa² hlanh³ láh² ju³jmo¹³ Jesús hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ja³jøng² ca¹gú² Jesús tsa¹ca¹gǿh¹dsa ton¹lág¹ jmai³ ton¹lág¹ huu². Ni³ jøng² ca¹løa¹ lø¹i³cónh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jøng² ca¹dsiég¹ dsa² hlanh³ ja³guǿ¹³ Jesús. Ca¹juúh² dsa² hlanh³: ―Chi²júh² lah¹dsóh² lanh¹² hning² jong¹² Diú¹³, jmóh³hning hi² lé² hi³ŋíh¹ cang³ ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jøng² ca¹juúh² Jesús: ―Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “A¹jáng¹ jmáh¹lah hi² quie¹² jnieh³ jmo¹² hi² chiang² jnieh³, dsa² jmøi¹guøi¹. Tiog¹³ báh³ hniuh¹² mi³ti³ jnieh³ ca¹lah¹jǿ¹ jǿg³ ca¹juúh² Diú¹³,” rø²juúh² si² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ni³ jøng² ca¹jiag¹ dsa² hlanh³ juu¹² jøa³juøi² Jerusalén. Ca¹tseh¹dsa Jesús guiuh¹³ hniú¹² guøh¹² juøh¹² quiah¹² dsa² judío. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jøng² ca¹juúh² dsa² hlanh³: ―Tiah¹³ di³ cøng² huø¹, chi²júh² lah¹dsóh² lanh¹²hning jong¹² Diú¹³. Di³ lah¹la² rø²juúh² si² quiah¹² Diú¹³: Dsiag¹² Diú¹³ ju²gug² tai³ ángeles quián¹²dsa hi² jmo¹dsa hí³ hning². Chiog¹dsa hning² juu¹² guiuh¹³. Mi³jøng² tsa¹quian¹ cang³ taih³hning, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jøng² ca¹juúh² Jesús: ―Jø¹² bíh³ lah¹la² rø²juúh² si²: “Tsa¹jmóh³hning hi² cánh³hning jǿg³ dsøg¹² quiah¹² Diú¹³ quiánh²hning, dsa² lán¹² Juu¹³ jniang³,” rø²juúh² si² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jøng² ca¹jiag¹ dsa² hlanh³ cøng² máh² ŋieing¹² hlaih¹³. Jøng² ca¹he¹dsa ca¹lah¹jǿ¹ juøi² tioh¹³ ca¹lah¹ta³cøng² jmøi¹guǿi¹. Hiug¹² jláh³ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jøng² ca¹juúh² dsa² hlanh³: ―Cuǿ¹³jni ca¹lah¹jǿ¹ hi² ió¹ quiánh²hning, chi²júh² chi²jnéh¹hning, mi³juanh¹³hning jní² ―ca¹juúh² dsa² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jøng² ca¹juúh² Jesús: ―¡Guønh², Satanás! Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Mi³juanh¹³ jniang³ Juu¹³ jniang³ dsa² lán¹² Diú¹³ quián² jniang³. Jan² dsa² héi² mi³ti³ jniang³ ni³,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jøng² ca¹ŋáh¹ dsa² hlanh³. Ni³ jøng² ca¹dsi¹lé² ángeles, ja³jøng², dsa² ca¹mi¹ti¹ ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mi³ca¹nǿng² Jesús jǿg³ hi² hiúg³ Juan hni¹ŋí³, ca¹ŋó¹dsa juu¹² huø¹ Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jøng² ha¹chi² ca¹jŋi¹dsa jøa³juøi² Nazaret. Ca¹ŋó¹dsa. Ca¹ŋi¹gú²dsa jøa³juøi² Capernaum, juøi² neng¹² cøg¹² jmøi² juøh¹² ja³tén¹² huø¹ Zabulón quianh¹³ huø¹ Neftalí. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lah¹jøng² ca¹løa¹, mi³jøng² ca¹lø¹ti¹ jǿg³ ca¹jmo¹ hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Lah¹la² rø²juúh² si² quiah¹²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Huø¹ Zabulón quianh¹³ huø¹ Neftalí, cøg¹² ja³neng¹² jmøi² juøh¹² quianh¹³ tø¹hŋoh¹³ chi³jmøi² Jordán, huø¹ Galilea, ja³tiogh³ jue¹² dsa² tsa¹lán¹² dsa² judío, ");
INSERT INTO cpaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dsa² tiogh³ ja³nioh¹² ja³neng², li¹ŋi¹²dsa jǿg³ dsio¹ quiah¹² Diú¹³. Dsa² ma²tiogh³ juu¹² ja³dsián¹dsa, li¹ŋi¹²dsa jǿg³ jmo¹ hi² liúg²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jmai³ jøng² ca¹mi¹liág¹ Jesús téng² jǿg³. Ca¹juúh²dsa: ―Ju³jeinh¹³ hoh¹² hniah¹². Di³ ja¹quien¹³ jií¹ ja³jmo¹ Diú¹³ héh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jøng² ŋøa¹² Jesús chiuh³ jmøi² Galilea, mi³ca¹jë́²dsa og¹ dsa². Jan² dsa² tsen² Simón, dsa² tǿh²dsa Pedro. Jan² dsa² tsen² Andrés, roh¹³ Simón. Dsa² og¹ héi² mi³téng² hmá¹² chi³jmøi². Di³ ta³ jøng² ŋi²nio³dsa, hi² tsánh²dsa jáh² tiogh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jøng² ca¹juúh² Jesús: ―¡Ma¹dsǿg³ quianh¹³ jní²! He³jni ha²lah jmóh³ hniah¹² ta³ hi² léh² hniah¹² dsa² li¹quianh¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta³lah¹ca¹tiú¹dsa hmá¹². Ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ma²dsa²lé²dsa ma²jiá¹²dsa hi³méh¹. Jøng² ca¹jë́² Jesús Jacobo quianh¹³ Juan, ja³ŋiúh³ Zebedeo. Mi³tiogh³dsa barco quianh¹³ ti³jmi²dsa. Cøinh¹²dsa néng³. Jøng² ca¹tǿh¹ Jesús dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ca¹lah¹dsø¹juu¹² jøng² ca¹tsih¹dsa barco quianh¹³ ti³jmi²dsa. Jøng² ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jøng² ca¹ŋøa¹ Jesús ta³cøng² huø¹ Galilea. Ja³jøng² ca¹he¹ Jesús jǿg³ dsi²néi² guøh¹². Ca¹téng²dsa jǿg³ dsio¹ ha²lah lǿa¹² ja³jmo¹ Diú¹³ héh¹. Ca¹mi¹hliú² Jesús ca¹lah¹já¹ dsa² mi³ti³lán¹² hliú² ni³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jøng² ca¹tsø² ca¹ja¹ jǿg³ quiah¹² Jesús ta³cøng² ja³tén¹² Siria. Jøng² ca¹ŋi¹jian¹²dsa ca¹lah¹já¹ dsa² mi³ti³dsoh¹, ca¹lah¹já¹ dsa mi³ti³lán¹² hliú² ni³ dsag³ quianh¹³ hliú² ni³ jmø³uai¹², quianh¹³ dsa² mi³quin¹² jmi²dsí² hlaih¹³, quianh¹³ dsa² mi³ti³lán¹² dsag³ jon¹²ŋié², quianh¹³ dsa² tsa¹li¹ŋøa¹. Jøng² ca¹mi¹hliú² Jesús ca¹lah¹já¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jøng² jue¹² dsa² chian² Galilea ca¹ŋi¹lé²dsa quianh¹³ Jesús. Quianh¹³dsa dsa² chian² guie¹ juøi² tǿh²dsa Decápolis, quianh¹³dsa dsa² chian² Jerusalén, ca¹lah¹quianh¹³ dsa² chian² huø¹ ja³tén¹² Judea, ca¹lah¹quianh¹³ dsa² chian² tø³hŋoh¹³ chi³jmøi² Jordán. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mi³ca¹jë́² Jesús dsa² jue¹² ca¹uǿi²dsa máh². Jøng² mi³ca¹gú²dsa, ca¹túgh² dsa² quianh³dsa cøg² ja³guǿ¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jøng² ca¹heh¹ Jesús dsa² quianh³dsa, ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Hioh¹² jenh¹² dsa² lø²lih¹³ hi² tsa¹quien¹²dsa. Di³ ca¹të́²dsa dsa¹lé²dsa ja³jmo¹ Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Hioh¹² jenh¹² dsa² ti³quin¹² ju²cǿh¹ dsøa¹². Di³ jmo¹ Diú¹³ hi² túgh²dsa ju²hiúg¹ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Hioh¹² jenh¹² dsa² tsa¹mi²juanh¹² guiog¹³. Di³ niu¹ gug²dsa ni³ jmøi¹guǿi¹ la² ju³lah lǿa¹² jǿg³ ma²ca¹jmo¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Hioh¹² jenh¹² dsa² hniu¹ jmo¹ hi² hniu¹ Diú¹³ ca¹lah¹hiu³ dsǿa¹²dsa. Di³ mi¹hag¹³ Diú¹³ ja³mi¹ti¹dsa ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Hioh¹² jenh¹² dsa² jmo¹ huø³ dsǿa¹² ja³cog² dsa² siáh². Di³ jmo¹ Diú¹³ huø³ dsøa¹² ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Hioh¹² jenh¹² dsa² dsø²jiag¹² dsǿa¹² cøng² ni³ jmáh¹lah jǿg³ dsio¹. Di³ ca¹të́²dsa jë́²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Hioh¹² jenh¹² dsa² jmo¹² li¹rø² jǿg³ ni³ jmøi¹guǿi¹. Di³ tǿh² Diú¹³ dsa² héi² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Hioh¹² jenh¹² dsa² ca¹can¹ jmø³uai¹², hi² ca¹jmo¹ dsa² jmøi¹guǿi¹ jian¹²dsa, ni³ huu¹³ hi² dsio¹ ma²ca¹jmo¹dsa. Di³ ca¹të́²dsa hi² dsa¹lé²dsa ja³jmo¹ Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Hioh¹² jénh² hniah¹² ju³ná³ hein² dsa² ca¹juúh² jǿg³ hlaih¹³, ho¹ ju³ ca¹jmóh²dsa hniah¹², ho¹ ju³ ca¹tsáih¹dsa hniah¹² he² jín³ jǿg³ tø³jǿg³ lé² li¹juúh²dsa, huu¹³ hi² ŋi²nioh³ hniah¹² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Túgh³ hniah¹² ju²hiúg¹ dsøa¹², hi² hioh¹² jénh² hniah¹². Di³ ma¹dsio¹² li¹chi² quiánh² hniah¹² ŋi¹juǿi¹. Lah¹jøng² báh³ ca¹jmóh² dsa² jmøi¹guǿi¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lanh¹² hniah¹² ju³lah løa¹² ŋi³ dsio¹ ja³cog² dsa² jmøi¹guǿi¹. Jøng² ha¹chi² ma¹lé² li¹ŋih³ ŋi³, ju³ná³ ca¹løa¹ tsa¹ŋih³. Ha¹chi² ta³ ma¹li¹jmo¹. Hi² jøng² guieh¹dsa. U¹tsóh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jø¹² bíh³ lah¹jøng² lanh¹² hniah¹² ju³lah løa¹² cøng² si² jmo¹² taih¹² juu¹² ja³ŋi²nio³ dsa² jmøi¹guǿi¹. Ha¹chi² lé² hma¹ jøa³juøi² neng¹² ni³ máh². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ha¹chian² dsa² hma¹² si² jmøi² cøg² niúh¹ tøh¹² na³ma²ca¹hiúh¹dsa si². Guiuh¹³ báh³ hai¹²dsa si². Mi³jøng² lé² taih¹ quiah¹² ca¹lah¹já¹ dsa² tiogh³ dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lah¹jøng² jmóh³ hniah¹² ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Mi³jøng² jái¹dsa hi² dsio¹ jmoh² hniah¹². Jøng² mi¹juanh¹²dsa Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Tsa¹ju³lë́h³ hniah¹² hi² ca¹guio¹jni hi² jŋih¹³jni lei¹³ quiah¹² hlai³ Moisés quianh¹³ jǿg³ ma²ca¹he¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Ca¹guio¹jni hi² he¹³jni ha²lah lah¹dsóh² lǿa¹² jøg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Lah¹dsóh² juǿi²jni hniah¹². Ca¹lah¹cónh¹ jmai³ ja³tsa¹ma²ca¹ŋi¹hén² jmøi¹guǿi¹ quianh¹³ ŋi¹juǿi¹, ha¹chi² dsa¹hén² jin³ cøng² punto, jin³ cøng² letra quiah¹² lei¹³ ca¹lah¹ja³ca¹lø¹ti¹ ca¹lah¹jǿ¹ jøg³ rø²juúh² lei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ju³ná³ hein² dsa² tsa¹nang¹ ca²jneh³ mih² jǿg³ rø²juúh² lei¹³, ju³ná³ tsaih¹²dsa dsa² siáh² hi² tsa¹nang¹dsa calah, dsa² héi² lén² dsa² tsa¹quien¹² cónh¹ jín³ ja³ca¹lah¹já¹ dsa² tiogh³ ja³jmo¹² Diú¹³ héh¹. Jøng² ju³ná³ hein² dsa² mi²ti¹ lei¹³, jøng² tsaih¹²dsa dsa² siáh² hi² dsio¹ mi¹ti¹dsa, dsa² héi² lén² dsa² juanh¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lah¹dsóh² juǿi²jni hniah¹². Tsa¹lé² gu³noh¹² hniah¹² ja³jmo¹² Diú¹³ héh¹ ju³ná³ tsa¹mi³tih³ hniah¹² jǿg³ quiah¹² Diú¹³ cu²rø² hi³méh¹ cónh¹ jín³ tøa¹² he¹² lei¹³ quianh¹³ dsa² fariseo. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ma²ca¹nengh² hniah¹² jǿg³ la² ca¹tsáih¹dsa dsa² hóg¹: “Tsa¹jŋë́h³ hniah¹² dsa². Ju³ná³ hein² dsa ca¹jŋëh¹ dsa², dsa² héi² ta¹canh¹³dsa dsag³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jøng² lah¹la² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹lø¹hné¹ quianh¹³ dsa² jmøi¹guǿi¹ jian¹²dsa, dsa² héi² ta¹canh¹³ dsag³. Jø¹² bíh³ lah¹jøng² dsa² chi³hia¹² dsa² jmøi¹guǿi¹ jian¹²dsa jǿg³ hlaih¹³, ta¹canh¹³ dsa² héi² dsag³ calah. Jøng² dsi¹² juu¹² hi² tiáh¹dsa juu¹² guio¹juǿi¹, ju³ná³ hein² dsa² juúh² tsa¹juøi² dsǿa¹² roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hi² jøng² ju³ná³ ca¹dságh¹ hoh¹² hning² hi² reh²hning dsag³ ja³cog² rúh²hning jmai³ ja³cuúh³hning hi² dsio¹ ja³cog² Diú¹³, ");
INSERT INTO cpaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jøng² cǿgh³hning hi² quinh³hning tø¹cøg¹². Gu³mi³rǿh³hning jǿg³ ni³jiá¹ quianh¹³ rúh²hning. Ni³ jøng² ma²lé² cuøh¹³hning Diú¹³ hi² dsio¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dsio¹ mi³rǿh³hning jǿg³ dsi²juu¹² quianh¹³ dsa² dsø¹jianh¹ hning² ni³ta³ niúh¹ jín³ hi² dsi³noh¹² hniah¹². Di³ jë́h² báh³ dsa² hning² ni³ jue¹³ ju³ná³ ca¹dsiégh¹hning ni³ta³. Jøng² jë́h² jue¹³ hning² ja³cog² policía quián¹²dsa. Tángh¹dsa hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lah¹dsóh² juǿi²jni hning²: Tsa¹lé² jogh¹³hning ja³jøng² ca¹lah¹ja³ca¹quih³hning ca¹lah¹jǿ¹ hi² reh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ma¹ca¹nengh² hniah¹² jǿg³ la² ca¹tsáih¹dsa dsa² hóg¹: “Tsa¹hlanh¹³ hniah¹² hio¹³ siáh²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jøng² lah¹la² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹jë́² jan² hio¹³, hi² dsø²jiag¹² dsǿa¹²dsa hi² hlaih¹³, dsa² héi² ma²rø²canh¹² dsag³ ja³cog² Diú¹³ ju³lah cøng² hi² ma²ca¹jmo¹ báh³ dsa² hi² hlaih¹³ dsø²jiag¹² dsǿa¹²dsa jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Jøng² chi²júh² mø³neih³hning ta¹guie¹jo¹³ jmo¹² hi² tánh¹hning dsag³, jøng² dsio¹ dsíh³hning. Tǿngh³hning tø¹guiég¹. Hiug¹² jín³ hi² dsio¹ hi² dsø¹hai¹² ca²jneh³ jmø²ŋǿa¹² quiánh²hning. Mi³jøng² tsa¹huh¹³hning ta³janh²hning guio¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chi²júh² gugh²hning ta¹guie¹jo¹³ jmo¹² hi² tánh¹hning dsag³, jøng² dsio¹ quiúh³hning. Tǿngh³hning tø¹guiég¹. Hiug¹² jín³ hi² dsio¹ hi² dsø¹hai¹² ca²jneh³ jmø²nǿa¹² quiánh²hning. Mi³jøng² tsa¹huh¹³hning ta³janh²hning guio¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Jø¹² bíh³ lah¹la² ca¹juúh²dsa ma²lǿih²: “Ju³ná³ hein² dsa² ca¹tióg² hio¹³ quián¹²dsa, hniuh¹² cuúh¹dsa hio¹³ cøng² si² hi² ca¹tsog¹dsa,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Cónh¹jøng² lah¹la² juǿi²jni hniah¹²: Ju³ná³ jan² dsa² ca¹tióg² hio¹³ quián¹² ju³lah dsa² ma²ca¹jmo¹ ju³lah lǿa¹² lei¹³ quiah¹² dsa² jenh² gug², ni³ jøng² jian¹ hio¹³ dsa² siáh², dsa² ca¹tiáng² héi² jmo¹ ta¹canh¹³ hio¹³ dsag³ cu¹dsie¹² quianh¹³ dsa² ŋioh¹² ca¹jian¹dsa ca¹tǿ² tángh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Jø¹² bíh³ ma²ca¹nengh² hniah¹² jǿg³ la² ca¹tsáih¹dsa dsa² hóg¹: “Tsa¹jmóh³ hniah¹² hi² tsa¹mi³tih³ hniah¹² jǿg³ ma²ca¹hieh¹³ hniah¹² ja³ta¹ni¹ Juu¹³ jniang³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jøng² lah¹la² juǿi²jni hniah¹²: Ha¹chian² hi² hiah¹³ hniah¹² ja³mi³dsøgh¹³ hniah¹² jǿg³. Tsa¹héh³ hniah¹² ŋi¹juǿi¹. Di³ ja³guǿ¹³ Diú¹³ báh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tsa¹héh³ hniah¹² jmøi¹guǿi¹. Di³ quiah¹² báh³ Diú¹³ jmøi¹guǿi¹ calah. Tsa¹héh³ hniah¹² jøa³juøi² Jerusalén. Di³ juøi² quiah¹² Diú¹³ juanh¹² báh³ jøng², dsa² jmo¹² héh¹ ni³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tsa¹héh³ hniah¹² dseih¹² hniah¹². Di³ tsa¹tiah¹ hniah¹² jmóh³ hi² teg² ho¹ ju³ hi² lih² ca¹lah¹jin³ cøng² mëh¹² jŋiú³ dseih¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tiúh¹ báh³ cónh¹ hi² juúh³ hniah¹² hi² dsøg¹² jǿg³, ho¹ ju³ tsa¹dsøg¹² jǿg³. Jǿg³ quiah¹² dsa² hlanh³ báh³ jøng², lǿa¹² ju³ he² jǿg³ siíh² mi³juúh³ hniah¹² ja³mi³dsøgh¹³ hniah¹² jǿg³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ma²ca¹nengh² hniah¹² jǿg³ la² ca¹tsáih¹dsa dsa² hóg¹: “Ju³ná³ jan² dsa² ca¹hén² mø³ni³ ho¹ ju³ jan³ dsa² jmøi¹guǿi¹ jian¹², jø¹² bíh³ dsa¹hén² mø³ni³dsa ho¹ ju³ jan³ dsa² ca¹jmo¹ calah,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jøng² lah¹la² juǿi²jni hniah¹²: Tsa¹jmóh³ hniah¹² hi² hlaih¹³ ja³cog² dsa² ma²ca¹jmo¹ hi² hlaih¹³ ja³cogh² hniah¹². Ju³ná³ ca¹jnáng¹ jan² dsa² ca¹jag¹³ neih³hning, jøng² dsio¹ cuúh³hning hi² jnáng¹dsa jag¹³ ca²ton² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ju³ná³ jan² dsa² jmo¹ dsag³ ni³ dsa² ta³, hi² hniu¹dsa cang¹dsa hmøah¹² hiúgh³hning, dsio¹ cuøh¹³hning dsa² hmøah¹² dsiég² quiánh²hning hi² cang¹dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ju³ná³ ca¹jmo¹ jan² dsa² héh¹ hi² cánh³hning lio¹³ quiah¹²dsa ton¹ kilometros, jøng², dsio¹ cánh³hning quiún² kilometros. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dsio¹ cuúh³hning quiah¹² dsa² møa¹² hi² chi² quiánh²hning. Jø¹² bíh³ dsio¹ dsíh³hning ju³ná³ he² hi² dsi¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ma¹ca¹nengh² hniah¹² jǿg³ la² ca¹tsáih¹dsa dsa² hóg¹: “Mi³hnoh¹³ hniah¹² dsa² jenh² hniah¹² quianh¹³. Jøng² mi³hiánh³ hniah¹² dsa² hiag¹³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jøng² lah¹la² juǿi²jni hniah¹²: Mi³hnoh¹³ hniah¹² dsa² hiag¹³. Hlanh¹³ hniah¹² Diú¹³ ni³ huu¹³ quiah¹² dsa² cuø¹² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Lah¹jøng² báh³ lénh² hniah¹² jong¹² Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. Di³ jmo¹² Diú¹³ hi² taih¹² hieg² cu²rø² ja³tiogh³ dsa² dsiog¹ quianh¹³ ja³tiogh³ dsa² tsa¹dsiog¹. Jmo¹² Diú¹³ hi² tiíh¹ jmǿa¹² ja³tiogh³ dsa² jmo¹² hi² dsio¹ quianh¹³ ja³tiogh³ dsa² jmo¹² hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chi²júh² jmáh¹lah dsa² hniang¹ báh³ hnóh¹ hniah¹², ha¹chi² ta³ jmo¹ hi² jøng² ja³cogh² hniah¹². Di³ lah¹jøng² jmo¹² ca¹lah¹ca¹tǿ² dsa² cagh¹² cog³ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ha¹chi² hi² dsio¹ jmoh² hniah¹² ju³ná³ hlanh¹² hniah¹² jmáh¹lah dsa² jenh² hniah¹² quianh¹³. Di³ lah¹jøng² báh³ jmo¹² dsa² tsa¹cue¹² Diú¹³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dsio¹ lénh² hniah¹² dsa² dsiog¹ lah¹dsóh² ju³lah lán¹² Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Tsa¹jmóh³ hniah¹² léi¹³ na³ma²tǿ² ja³jmóh³ hniah¹² hi² dsio¹. Di³ tsa¹lǿh² dsa² jmo¹² lah¹jøng² jin³ he² hi² dsio¹ ja³cog² Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Hi² jøng² tsa¹juaih¹³ hniah¹² dsa² jue¹² ja³mi³hogh³ hniah¹² dsa² chi³quian¹³ jmai³, ju³lah jmo¹² dsa² tø¹cah¹ tø¹jen¹², dsa² mi²léi¹³ hi² dsio¹ jmo¹²dsa guøh¹² quianh¹³ dsi²juu¹². Hniu¹dsa juúh² dsa² jue¹² jǿg³ dsio¹ quiah¹²dsa. Lah¹dsóh² juǿi²jni hniah¹²: jmáh¹lah jǿg³ dsio¹ quiah¹² dsa² jmøi¹guǿi¹ jian¹² báh³ dsa² líh²dsa. Ha¹chi² jǿg³ dsio¹ ma¹líh²dsa ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na³ma²tǿ² ja³mi³hogh³ hniah¹² dsa² chi² hi² chi³quian¹³ jmai³, jin³ dsa² hiug¹² jenh² hniah¹² quianh¹³ tsa¹juaih¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hiug¹² jín³ hi² dsio¹ jmóh³ hniah¹² lah¹jøng² ja³tsa¹ŋi¹² dsa² jue¹². Jái¹² báh³ Jmi² jniang³ ha²lah jmoh² hniah¹² ja³tsa¹jní². Dsa² héi² cuø¹ hi² dsio¹ ja³cogh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Na³ma²tǿ² ja³hlanh¹³ hniah¹² Diú¹³, tsa¹jmóh³ hniah¹² ju³lah jmo¹² dsa² tø¹cah¹ tø¹jen¹², dsa² hniu¹ núng¹ ja³tsog¹² juu¹², ho¹ ju³ dsi²néi² guøh¹², hi² hlanh¹²dsa Diú¹³. Mi³jøng² jái¹ dsa² jue¹². Lah¹dsóh² juǿi²jni hniah¹²: jmáh¹lah jǿg³ dsio¹ quiah¹² dsa² jmøi¹guǿi¹ báh³ líh² dsa² héi². Ha¹chi² jǿg³ dsio¹ ma¹líh²dsa ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jøng² guǿnh³hning dsi²néi² quiánh²hning na³ma²tǿ² ja³hlanh¹³ hning² Diú¹³. Jøng² na³ma²na²jnái¹ hniú¹², hlanh¹³hning Jmi² jniang³, dsa² guǿ¹² ja³tsa¹léi¹³. Jøng² jái¹² báh³ Diú¹³ ja³quiunh³. Dsa² héi² báh³ cuø¹ hi² dsio¹ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Jøng² ja³hlanh¹³ hniah¹² Diú¹³, tsa¹lø³liuh¹³ hniah¹² ma¹dsio¹² jǿg³ tsa¹quien¹², ju³lah jmo¹² dsa² tsa¹cue¹² Diú¹³. Lë́²dsa tsa¹nang¹ Diú¹³ ju³ná³ tsa¹cu¹juúh²dsa ma¹dsio¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tsa¹jmóh³ hniah¹² lah¹jøng². Di³ ma²ŋi¹² báh³ Jmi² jniang³ he² hi² chi³quianh¹³ hniah¹² jmai³ cónh¹ niúh¹ jín³ hi² mǿh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lah¹la² hlanh¹³ hniah¹² Diú¹³: Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹, ju³jmo¹³ dsa² jue¹² jǿg³ hi² lanh¹²hning dsa² han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ju³ji² ja³ jmóh³hning héh¹. Ju³jmóh³hning hi² hiug² hoh¹²hning ni³ guøh³ ni³ huø¹ la², ju³lah jmoh²hning ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuúh³hning hi² quie¹³ jnieh³ lah¹cøng² lah¹cøng² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Henh¹³hning dsag³ hi² ma²ca¹jmó³ jnieh³, ju³lah hén² jnieh³ dsag³ hi² ma²ca¹jmo¹ dsa² jmøi¹guǿi¹ ja³cog² jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tsa¹jagh¹³hning jnieh³ juu¹² ja³tiáh¹ jnieh³ dsag³. Lagh³hning jnieh³ hi² tsa¹ju³tiáh¹ jnieh³ juu¹² hlaih¹³. Di³ lanh¹² hning² dsa² jmo¹² héh¹, dsa² chi² bí², dsa² hiug¹² juanh¹² jmai³ ŋi² ja³já¹³ jmai³ ŋi² ja³dság¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Dsio¹ báh³ hénh³ hniah¹² dsǿg³ dsa² jmøi¹guǿi¹ jianh¹² hniah¹² hi² ma²ca¹jmo¹dsa ja³cogh² hniah¹². Jøng² hén² báh³ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹, dsag³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Di³ ha¹chi² hén² Jmi² jniang³ dsag³ quiánh² hniah¹² calah, ju³ná³ tsa¹hénh² hniah¹² dsag³ quiah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jøng² tsa¹hǿih³ hniah¹² hlaih¹³ neih¹² ja³mi³hanh¹³ hniah¹² hi² tsa¹cøh² hniah¹² ta³lah¹hlanh¹³ hniah¹² Diú¹³, ju³lah jmo¹² dsa² tø¹cah¹ tø¹jen¹². Di³ hlaih¹³ hai¹² dsa² héi² ni³. Mi³jøng² li¹lih¹³ dsa² siáh² hi² mi²han¹²dsa. Lah¹dsóh² juǿi²jni hniah¹²: Jmáh¹lah jǿg³ dsio¹ quiah¹² dsa² jmøi¹guǿi¹ jian¹² báh³ dsa² líh²dsa. Ha¹chi² jǿg³ dsio¹ líh²dsa ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jøng² dsio¹ siégh³ hniah¹² dseih¹², rángh³ hniah¹² neih³ jmai³ ja³mi³hanh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mi³jøng² tsa¹li¹lih¹³ dsa² jue¹² hi² mi²hanh¹³ hniah¹². Jøng² jan² báh³ Jmi² jniang³ li¹ŋi¹², dsa² guǿ¹² ja³tsa¹léi¹³. Dsa² héi² báh³ cuø¹ hi² dsio¹ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Tsa¹dsiíh³ hniah¹² loh² ma¹dsio¹² hi² jláh³ quiánh² hniah¹² ni³ jmøi¹guǿi¹ la², ja³hén² jáh² hmøah¹², ja³li¹tsáh² cog³, ja³chian² dsa² høin². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ŋi¹juǿi¹ báh³ dsio¹ dsiíh³ hniah¹² loh² cøng² hi² dsio¹ li¹quiánh² hniah¹². Tsa¹hén² jáh² hmøah¹² ja³jøng². Tsa¹li¹tsáh² cog³. Ha¹chian² dsa² høin² chian². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Di³ ja³jøng² báh³ hiug² hoh¹² hniah¹², ja³ma²neng¹² loh² hi² dsio¹ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Lǿa¹² mø³neih³ hniah¹² ju³lah lǿa¹² cøng² si². Cu²rø² jáih² hniah¹² ju³ná³ dsio¹ mø³neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jøng² ju³ná³ tsa¹dsio¹ mø³neih³ hniah¹², cu¹dsie¹² ma²tiogh³ hniah¹² lah¹jan² dsa² tiogh³ ja³neng². Jø¹² bíh³ lah¹jøng² lǿa¹² jǿg³ dsø²jiag¹² hoh¹² hniah¹². Ju³ná³ ca¹løa¹ tsa¹dsio¹ jǿg³ jøng², jǿg³ ma²ŋih³ hniah¹², jøng² lah¹dsóh² neng² juu¹² ja³ŋi³nioh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ha¹chian² dsa² tiúh¹ jmo¹ ta³ quiah¹² og¹ juu³dsa. Di³ tiog¹³ báh³ hian³dsa juu³dsa lah¹ni², ju³ná³ hnio¹dsa dsa² ja³ma²og¹. Ho¹ ju³ mi¹ti¹dsa jǿg³ ja³cog² dsa² lah¹ni². Jøng² tsa¹hiug² dsǿa¹²dsa ja³cog² dsa² ja³ma²og¹. Tsa¹lé² mi³tih³ hniah¹² jǿg³ quiah¹² Diú¹³ ju³ná³ hnøngh² hniah¹² jmáh¹lah cog³ chi² jmøi¹guǿi¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Hi² jøng² juǿi²jni hniah¹²: Tsa¹jmóh³ hniah¹² ju²hí³ hoh¹² ha²lah chianh² hniah¹², he² cǿh³ hǿgh³ hniah¹², he² hi² cáih³ hniah¹². Ma¹dsio¹² quien¹² jmi²dsí² quiánh² hniah¹² cónh¹ jín³ hi² cǿh³ hniah¹². Ma¹dsio¹² quien¹² jmø²ŋǿa¹² quiánh² hniah¹² cónh¹ jín³ hi² cáih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jai³lah ha²lah lǿa¹² quiah¹² jáh² han¹² ŋi²nio³ dsi³guøi². Tsa¹jne²jah cuøi². Tsa¹huǿi²jah cuøi². Tsa¹dsii¹²jah loh² cuøi². Cónh¹jøng² Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹ báh³ cuø¹² hi² gøah¹² jáh² héi². Jøng² hiug¹² jín³ hi² quien¹² hniah¹² ma¹dsio¹² ca¹lah¹cónh¹ jín³ jáh² han¹², jáh² ŋi²nio³ dsi³guøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ha¹chi² ta³ jmo¹ hi² jmóh³ hniah¹² ju²hí³ dsøa¹². A¹jáng¹ hi² jøng² jmo¹ hi² li¹chianh² hniah¹² jin³ cøng² jmai³ uú² hi³méh¹ cónh¹ jín³ ja³ca¹cuø¹ Diú¹³ ju²bí². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ha¹chi² ta³ jmo¹ hi² jmóh³ hniah¹² ju²hí³ dsøa¹² he² hi² cáih³ hniah¹². Jai³lah ha²lah cón² lí³ san² u²søa¹³. Ha¹chi² ta³ jmo¹² lí³. Tsa¹ta¹² lí³ tá². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cónh¹jøng² juǿi²jni hniah¹²: Hiug¹² jín³ hi² dsio¹ jní² lí³ cónh¹ jín³ hmøah¹² jláh³ mi³quieih¹² hlai³ Salomón. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jláh³ báh³ jmo¹² Diú¹³ høg² nung² ti³dsøa¹² ton¹ hnøa¹² jmai³ niúh¹ núng¹. Jøng² tsa¹hai² jøn¹ dsa² jmøi¹guǿi¹. Jøng² ma²ŋih³ hniah¹² hiug¹² jín³ hi² dsio¹ jmo¹ Diú¹³ ja³cogh² hniah¹², dsa² ja¹lái¹ héh² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hi² jøng² tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² he² hi² cǿh³ hǿgh³ hniah¹², he² hi² cáih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dsa² tsa¹cue¹² Diú¹³ báh³ dsa² dsø²jiag¹² dsǿa¹² jmáh¹lah jǿg³ jøng². Ma²ŋi¹² báh³ Jmi² jniang³ dsa² guǿ¹² ŋi¹juǿi¹ hi² hniuh¹² ca¹lah¹jǿ¹ hi² jøng² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hi² jøng² jmóh³ hniah¹² hoh¹² ha²lah ŋi³nioh³ hniah¹² juu¹² ja³jmo¹² Diú¹³ héh¹, ha²lah jmóh³ hniah¹² hi² hniu¹ Diú¹³. Jøng² li¹chi² báh³ ca¹lah¹jǿ¹ hi² jøng² quiánh² hniah¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² quiah¹² hiá¹ hiég¹. Jmai³ jøng² báh³ li¹ŋih³ hniah¹² ha²lah lé². Dsio¹ báh³ dsø²jiag¹² hoh¹² hniah¹² jmáh¹lah he² jǿg³ ca¹lø¹chí¹ lah¹cøng² lah¹cøng² jmai³ ja³ŋi²nioh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Tsa¹cuøh¹³ hniah¹² dsa² dsag³. Mi³jøng² tsa¹cuúh¹ Diú¹³ hniah¹² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Di³ cøng² ni³ jmo¹ Diú¹³ dsǿa¹² ja³cogh² hniah¹², ju³lah jmoh² hniah¹² ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cøng² ni³ mi¹rø¹²dsa jǿg³ quiánh² hniah¹², ju³lah mi³rǿh³ hniah¹² jǿg³ quiah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ha²lah dsio¹ jáih² hniah¹² ca²jneh³ qui¹² hiu³ mø³ni³ rúh² hniah¹². Jøng² tsa¹leh¹³ hniah¹² hi² tioh¹³ hma² pa³ mø³neih³ hniah¹² guiogh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ha²lah dsio¹ tí² hoh¹² hniah¹² juaih¹² hniah¹² rúh² hniah¹² hi² jŋih¹³ hniah¹² jneh³ qui¹² hiu³ mø³ni³dsa. Jøng² tsa¹jáih² hniah¹² guiogh¹³ hma² pa³ tioh¹³ mø³neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dsa² ta¹cah¹ ta¹jen¹² báh³ hniah¹². Lah¹ni² jŋih¹³ hniah¹² hma² pa³ tioh¹³ mø³neih³ hniah¹². Jøng² ma²lé² jáih³ hniah¹² cu²rø² hi² jŋih¹³ hniah¹² ca²jneh³ qui¹² hiu³ mø³ni³ rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tsa¹heh¹³ hniah¹² dsa² lán¹² ju³lah lán¹² dsøi² jǿg³ dsio¹. Di³ jmo¹dsa hniah¹² ti³jneh³. Tsa¹dsiíh³ hniah¹² hi² jláh³ ni³ dsa² lán¹² ju³lah lán¹² ŋié¹². Di³ u¹tsóh²dsa hi² jláh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ŋieh¹ báh³ hniah¹² na³ca¹møah³ hniah¹². Dsianh¹² báh³ hniah¹² na³ca¹hniangh² hniah¹². Nií¹ báh³ dsa² na³ca¹teh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Di³ ŋë² báh³ ca¹lah¹já¹ dsa² møa¹². Dsóh² báh³ dsa² hnangh². Nií¹dsa quiah¹² dsa² tǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Ju³ná³ hein² dsa² lah¹hniah¹², ca¹møa¹ tsih² quiánh² hniah¹² hi³ŋíh¹, tsa¹cuúh³ hniah¹² cang³, liáh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ho¹ ju³ ca¹më¹tsih jáh² tiogh³ jmøi², tsa¹cuanh¹³ hniah¹² møh². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jøng² chi²júh² ma²ŋih³ hniah¹² ha²lah cuúh³ hniah¹² hi² dsio¹ quiah¹² tsih² guing², hniah¹² dsa² ti³reh² dsag³, jøng² hiug¹² jín³ cuø¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹, hi² dsio¹ quiah¹² dsa² møa¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Lah¹jøng² jmóh³ hniah¹² ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah mi³hnøngh² hniah¹² hi² jmo¹dsa ja³cogh² hniah¹². Lah¹jøng² báh³ mi³tih³ hniah¹² ca¹lah¹jǿ¹ jǿg³ rø²juúh² lei¹³ quiah¹² hlai³ Moisés quianh¹³ si² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Gu³noh¹² hniah¹² juu¹² hag³hniú¹² chi³cagh¹². Di³ juøh¹² báh³ hag³hniú¹² ja³dsi¹³ juu¹² guio¹juǿi¹. Tsa¹ué² juu¹² jøng², juu¹² ja³dsø²lia¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jøng² ué² báh³ juu¹² dsø²lia¹² dsa² li¹chian² ja³cog² Diú¹³. Tig² juu¹². Chi³cagh¹² hag³hniú¹². Mih² báh³ dsa² dsioh¹ juu¹² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Jmo³ ju²hí³ dsøa¹² quiah¹² dsa² tø³júg³, dsa² jmo¹² hi² hǿ²dsa jǿg³ quiah¹² Diú¹³. Ti³lán¹² dsa² héi² ju³lah lán¹² dsøi²núng³, jáh² hlanh³, ni³quieih¹² lag³ jah¹chih². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Li¹leh¹³ báh³ hniah¹² ha²lah jmo¹² dsa² tø³júg³ héi². Jøng² li¹ŋih³ báh³ hniah¹² ha²lah lán¹²dsa. Ha¹chi² hai¹ mǿi² gu²jøah¹³ chiúh³ tang¹². Jin³ ha¹chi² hai¹ møi¹higo chi³uǿin¹ juh². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lah¹jøng² báh³ lǿa¹². Dsio¹ báh³ mǿi² cuø¹² hma² dsio¹. Jøng² mǿi² hlaih¹³ cuø¹² hma² hlaih¹³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tsa¹lé² cuø¹ hma² dsio¹ mǿi² hlaih¹³. Jø¹² bíh³ tsa¹lé² cuø¹ hma² hlaih¹³ mǿi² dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Quiuh¹²dsa ca¹lah¹jǿ¹ hma² tsa¹cuø¹ mǿi² dsio¹. Jøn¹²dsa hma². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hi² jøng² li¹leh¹³ hniah¹² hein² dsa² lán¹² dsa² tø³júg³ na³ma²ca¹jaih³ hniah¹² ha²lah jmo¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jue¹² báh³ dsa² tsaih¹² jní²: “Juu¹³ jniang³”. Cónh¹jøng² ha¹chi² dsa¹lia¹ ca¹lah¹já¹ dsa² héi² ja³jmo¹² Diú¹³ héh¹. Jmáh¹lah dsa² hé¹² báh³ dsa¹lia¹ ja³jøng², dsa² mi¹ti¹ he² hi² hniu¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na³ma²ca¹tǿ² ja³ca¹ti² ca¹dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹, jøng² jue¹² dsa² juúh², tsáih¹dsa jní²: “jnieh³ báh³ dsa² mi³hǿ² jǿg³ quiánh²hning. Quianh¹³ jmaih³hning ma²ca¹huø³ jnieh³ jmi²dsí² hlaih¹³. Jø¹² bíh³ ma¹dsio¹² juu¹² juøh¹² ca¹jmó³ jnieh³ quianh¹³ jmaih³hning,” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ni³ jøng² juǿi³jni dsa² héi²: “Ha¹chianh² hniah¹² cué¹²jni. Gu³noh¹² hniah¹² tø¹guiég¹. Di³ dsa² ma²ca¹jmo¹ hi² hlaih¹³ báh³ hniah¹²,” juǿi³jni dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Lah¹la² lán¹² ca¹lah¹já¹ dsa² nang¹² jǿg³ quieg¹jni, dsa² mi²ti¹ jǿg³. Lán¹² dsa² héi² ju³lah lán¹² jan² dsa² ŋi¹², dsa² ca¹tsih¹ hniú¹² quiah¹²dsa ni³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jøng² ca¹táh² jmǿa¹². Ca¹ŋi¹juøh¹² jmøi². Ca¹hǿi² dsí² tí² ja³tsih¹³ hniú¹². Conhjøng² ha¹chi² ca¹gug¹ hniú¹². Di³ tsih¹² hniú¹² ni³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jøng² lah¹la² lán¹² ca¹lah¹já¹ dsa² tsa¹mi¹ti¹ jǿg³ ma²ca¹nǿng²dsa, jǿg³ quieg¹ jní²: Lán¹² dsa² héi² ju³lah lán¹² jan² dsa² tsa¹chian² dsǿa¹², dsa² ca¹tsih¹ hniu³dsa ni³ tsai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jøng² ca¹táh² jmǿa¹². Ca¹ŋi¹juøh¹² jmøi². Ca¹hǿi² dsí² tí² ja³tsih¹³ hniú¹². Jøng² ca¹gug¹ hniú¹². Cu¹dsie¹² ca¹ŋi¹hén² hniú¹² jøng² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mi³ca¹jŋi¹ dsii¹² Jesús jǿg³, jøng² dsogh¹² hlaih¹³ dsǿa¹² dsa² jue¹² jǿg³ ca¹he¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Di³ ca¹he¹ Jesús jǿg³ ju³lah jan² dsa² lah¹dsóh² ŋi¹², a¹jáng¹ ju³lah he¹² tøa¹², dsa² he¹² lei¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mi³ca¹siog² Jesús máh², jøng² jue¹² hlaih¹³ dsa² ca¹ŋi¹lé² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jøng² ca¹dsiég¹ jan² dsa² lán¹² dsag³ hmih¹² tsa¹jŋi¹² ja³tsenh¹³ Jesús. Ca¹chi¹jné¹dsa. Jøng² ca¹juúh²dsa: ―Guiuh¹³, tiah¹ báh³ hning² jmóh³hning hí³ quieg¹ chi²júh² hiug² hoh¹² hning² quianh¹³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jøng² ca¹quieg² Jesús gug² ni³ quiah¹² dsa² héi². Ca¹juúh²dsa: ―Hiug² báh³ dsøa¹jni. ¡Ju³hliuh³hning! ―ca¹juúh²dsa. Ta³lah¹ca¹huá² hmih¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Jai³lah! Ha¹chian² hi² juaih¹³hning jin³ hein². Cónh¹ gu³hiah¹³ jmi²dsa² hning². Gu³cuøh¹³hning Diú¹³ ju³lah lǿa¹² lei¹³ quiah¹² hlai³ Moisés. Mi³jøng² li¹ŋi¹² ca¹lah¹já¹dsa ha¹chi² dsag³ ma¹lanh¹²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jøng² ca¹ŋáh¹ Jesús juu¹² jøa³juøi² Capernaum. Mi³ca¹dsiánh²dsa ja³jøng², ca¹dsiég¹ jan² juu¹³ hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ca¹juúh²dsa: ―Guiuh¹³, dsoh³ jan² dsa² jmo¹² ta³ quieg¹jni. Ron¹²dsa dsi²néi². Tsa¹li¹ŋøa¹dsa. Ma¹dsio¹² jmø³uai¹² chian²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jøng² ca¹juúh² Jesús: ―Nei³jni hi² mi³hliú³jni dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jøng² ca¹juúh² juu¹³ hlég²: ―Guiuh¹³, ha¹chi² lë́²jni ta³tén¹³jni hi² góh³hning dsi²néi² quieg¹jni. Dsio¹ cónh¹ hi² jmóh³ hning² héh¹ hi² hliú² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Di³ chian² báh³ juu¹jni. Jø¹² bíh³ chian² dsa² quin³jni ni³ quiah¹². Jøng² juǿi²jni jan² hlég²: “¡Gu²!” Jøng² dság¹dsa. Jøng² juǿi²jni hlég² siáh²: “¡Ŋi²!” Jøng² jií¹dsa. Jøng² juǿi³jni dsa² jmo¹² ta³ quieg¹jni: “¡Lah¹la² jmóh³hning!” Jøng² jmo¹dsa lah¹jøng² ―ca¹juúh² juu¹³ hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jøng² dsogh¹² dsǿa¹² Jesús mi³ca¹nǿng²dsa jǿg³ jøng². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² dsa²lé² quianh¹³dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chian² dsa² go² jniang³ ma²ca¹jén²jni, dsa² hé² jǿg³ quieg¹jni ju³lah hé² dsa² lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lah¹dsóh² ji¹lé² dsa² jue¹² chian² ja³uǿin³. Túgh²dsa hi² gǿh¹dsa quianh¹³ hlai³ Abraham, quianh¹³ hlai³ Isaac, quianh¹³ hlai³ Jacob ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Di³ jøng² guianh¹ Diú¹³ dsa² go² jniang³ tø¹cøg¹², dsa² mi³tén¹² hi² túgh²dsa ja³jmo¹² Diú¹³ héh¹. Dsa¹lé² dsa² héi² juu¹² guio¹juǿi¹. Ja³jøng² dsa¹tø² dsa¹hǿg²dsa. Cán²dsa ma¹dsio¹² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa juu¹³ hlég²: ―¡Guønh² ja³quiánh³hning! Ju³lé³ ju³lah lǿa¹² jǿg³ héh²hning² ―ca¹juúh²dsa. Dsø¹juu¹² jøng² ca¹hlú² dsa² quián¹² juu¹³ hlég² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jøng² ca¹ŋó¹ Jesús ja³quiah¹³ Pedro. Ja³jøng² ca¹jë́² Jesús mø²chiég³ Pedro. Rø²quia¹²dsa ni³ jein³, hi² dsé²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jøng² ca¹chi¹ŋiú² Jesús gug²dsa gug² hio¹³ dsoh³ héi². Jøng² ca¹jŋi¹ dsé²dsa. Ca¹nung²dsa. Ca¹mi¹ti¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mi³ca¹neng² jøng², ca¹jian¹dsa jue¹² dsa² quin¹² jmi²dsí² hlaih¹³ ja³guǿ¹³ Jesús. Jøng² ca¹huø¹ Jesús jmi²dsí² hlaih¹³ jøng² quianh¹³ jmáh¹lah hi² ca¹hlaih¹dsa. Jø¹² bíh³ ca¹mi¹hliú²dsa ca¹lah¹já¹ dsa² ti³dsoh¹ tiogh³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lah¹jøng² báh³ ca¹lø¹ti¹ jǿg³ ca¹juúh² hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Ca¹juúh²dsa: “Dsa² héi² ca¹mi¹hlég² jniang³. Ca¹jŋíh²dsa jmø³uai¹² quián² jniang³,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ca¹jë́² Jesús jue¹² hlaih¹³ dsa² ma²tiogh³ lah¹jin² lah¹lǿih¹ quiah¹²dsa. Jøng² ca¹jmo¹dsa héh¹ hi² dság¹dsa hŋoh¹³ jmøi² quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jøng² ca¹dsiég¹ jan² tøa¹² he¹² lei¹³ ja³tsenh¹³ Jesús. Jøng² ca¹juúh² dsa² héi²: ―Tøa¹², hiug² dsøa¹jni nei¹³jni quianh¹³ hnéng¹ ca¹lah¹jǿ¹ ha² ja³góh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jøng² ca¹ŋai¹ Jesús: ―Chi² báh³ quiah¹² guu¹² ja³li¹gú¹jah. Chi² báh³ quiah¹² tan¹². Cónh¹jøng² ha¹chi² chi² ja³li¹jan³ jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jøng² ca¹juúh² jan² dsa² lán¹² dsa² quianh³ Jesús, ca¹tsáih¹dsa Jesús: ―Guiuh¹³, ¿tsa³cuúh³hning jǿg³ hi² neh¹³jni ni³jiá¹, ca¹lah¹ja³ca¹jon¹ ti³ŋieh¹jni? Jøng² nei¹³jni quianh¹³ hnéng¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jøng² ca¹juúh² Jesús: ―¡Ma¹dsǿg³ quianh¹³ jní²! Tiúh¹ báh³ dsa¹hǿg² dsa² ma²ni³dsán¹ ja³cog²jni, dsa² tsa¹hniu¹ jǿg³ quieg¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jøng² ca¹hí¹ Jesús niúh¹ barco quianh¹³ dsa² quianh³dsa. Ca¹ŋi¹lé²dsa juu¹² tø¹hŋoh¹³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jøng² ca¹hǿi² cøng² dsí² tí² hlaih¹³ ni³ jmøi², ca¹lah¹ja³ca¹jéinh¹ jmøi² niúh¹ barco. Di³ ma²rø²güé¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jøng² ca¹ŋi³ŋie¹³ dsa² quián¹²dsa. Ca¹juúh²dsa: ―¡Juu¹³ jniang³! ¡Liag³ jniang³! Ma²tiagh³ jniang³ ja³dsiág¹ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ hiug¹² ganh¹ hniah¹²? Ja¹lái¹ héh² hniah¹² jǿg³ quieg¹jni ―ca¹juúh²dsa. Jøng² ca¹nung² Jesús. Ca¹jé²dsa dsí² quianh¹³ jmøi². Jøng² ca¹niu¹ tei³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jøng² dsogh¹² hlaih¹³ dsǿa¹² dsa² quianh³dsa. Ca¹juúh²dsa: ―¿Hein² bí³ dsa² lang¹²? Nang¹² báh³ dsí² quianh¹³ jmøi² jǿg³ hi² juúh²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mi³ca¹dsi¹lé²dsa hŋoh¹³ jmøi², huø¹ go² dsa² gadareno, jøng² ca¹huah¹ og¹ dsa² ŋioh¹² tøg²hløg² ja³rø²hog¹² hlai³. Ca¹ŋi¹lé²dsa ja³tsenh¹³ Jesús. Ta³og¹dsa mi³quin¹²dsa jmi²dsí² hlaih¹³. Hiug¹² hne²dsa. Goh¹² dsa² chian² huø¹ jøng² tsø³jue¹³ juu¹² ja³tiogh³ dsa² og¹ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jøng² ca¹ho¹ dsa² héi² tí². Ca¹juúh²dsa: ―¿He² hi² lë́h²hning quianh¹³ jnieh³, hning² dsa² lanh¹² jong¹² Diú¹³? ¿Ma³guønh¹hning hi² cuøh¹³hning jnieh³ jmø³uai¹² cónh¹ niúh¹ jín³ hi² dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quián² jnieh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cøg¹² ja³jøng² mi³ŋi²nio³ jue¹² ŋié¹², jáh² ti³gøah¹² høg² nung². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jøng² ca¹møa¹ jmi²dsí² hlaih¹³. Ca¹tsáih¹dsa Jesús: ―Ju³ná³ huah¹²hning jnieh³, cuúh³hning jǿg³ hi² tiágh³ jnieh³ quianh¹³ ŋié¹² ió¹ ―ca¹juúh² jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jøng² ca¹cuø¹ Jesús jǿg³ hi² dsa¹lé² jmi²dsí², hi² túgh² jmi²dsí² quianh¹³ ŋié¹². Jøng² ca¹huøh¹² jmi²dsí² hlaih¹³ mi³tioh¹³ dsa² og¹ héi². Ca¹ŋi¹tiogh¹² jmi²dsí² hlaih¹³ quianh¹³ ŋié¹². Dsø¹juu¹² jøng² ca¹ŋi¹lé² ŋié¹² gu¹hei¹². Ca¹siúgh²jah chi³dsió¹³. Jøng² ca¹dsan¹jah niúh¹ jmǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jøng² ca¹cuøin¹ dsa² mi³jmo¹² hí³ ŋié¹². Ca¹ŋi¹lia¹dsa juu¹² jøa³juøi², ja³ca¹he¹dsa ca¹lah¹jǿ¹ jǿg³ ha²lah ca¹hlú² dsa² mi³tioh¹³ jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jøng² ca¹ŋi¹lé² jue¹² dsa² tiogh³ jøa³juøi² jøng² ja³tsenh¹³ Jesús. Jøng² mi³ca¹jë́²dsa Jesús, ca¹møa¹dsa hi² mi³u¹hái¹ Jesús huø¹ go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jøng² ca¹uǿi² Jesús barco. Ca¹dsiánh¹dsa hŋoh¹³ jmøi² jøa³juøi² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja³jøng² ca¹ŋi³jian¹dsa jan² dsa² tsa¹li¹ŋø¹, rø²quia¹²dsa ni³ jmung². Ca¹lø¹lih¹³ Jesús hi² hé² dsa² héi² jǿg³ quiah¹²dsa, dsa² ca¹ŋi³jian¹ dsa² dsoh³. Jøng² ca¹tsáih¹ Jesús dsa² dsoh³ héi²: ―Cøng² jmo³ hoh¹², jon¹². Ma²ca¹dsan¹ dsag³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jøng² lah¹la² ca¹ŋi¹jiag¹² dsǿa¹² ca²dsiog³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³: “Tsa¹quien¹² Diú¹³ jmo¹² dsa² ná¹² jǿg³ juúh²dsa,” ca¹ŋi¹jiag¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jøng² ma²ŋi¹² Jesús he² jǿg³ dsø²jiag¹² dsǿa¹² tøa¹² héi². Jøng² ca¹juúh² Jesús: ―¿He² løa¹ hiug¹² hlaih¹³ dsø²jiagh¹² hoh¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Naih¹² hi² tsa¹ué² juǿi³jni dsa² dsoh³?: “Ma²ca¹dsan¹ dsag³ quiánh²hning,” ho² ju³ juǿi³jni dsa²: “¡Nung²! ¡Ŋøa³!” Cøng² jǿg³ báh³ jøng² ta³ton¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jøng² jmo¹³jni hi² li¹ŋih³ hniah¹² tiág¹²jni hén¹³ dsag³ ni³ guøh³ ni³ huø¹ la², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. Jøng² ca¹tsáih¹ Jesús dsa² dsoh³: ―¡Nung²! ¡Quieng² jmung² quiánh²! ¡Guønh² ja³quiánh³! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jøng² ca¹nung² dsa² tsa¹li¹ŋø¹. Ca¹ŋáh¹dsa juu¹² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mi³ca¹jái¹ dsa² jue¹² hi² jøng², ca¹can¹ hlaih¹³dsa gøg². Ca¹mi¹juanh¹²dsa Diú¹³. Di³ ca¹jái¹dsa ca¹cuø¹ Diú¹³ bí² jøng² quiah¹² jan² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mi³ca¹ŋó¹ Jesús ja³jøng², ca¹jë́²dsa jan² dsa² tsen² Mateo, dsa² cagh¹² cúg³ juøi². Guǿ¹²dsa cøng² ja³jmo¹²dsa ta³ jøng². Jøng² ca¹juúh² Jesús: ―Ma¹dsǿg³ quianh¹³ jní² ―ca¹juúh²dsa. Jøng² ca¹nung² Mateo. Ca¹ŋó¹dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jøng² ca¹ŋi¹gǿh¹ Jesús ja³quiah¹³ Mateo. Jøng² ca¹dsi¹lé² jue¹² dsa² cagh¹² cúg³ juøi², ca¹lah¹quianh¹³ dsa² tsa¹ti³jan¹ ja³cog² Diú¹³ ca¹lah¹cónh¹ lǿa¹² mai³¹ quiah¹² dsa² judío. Ca¹túgh² dsa² héi² mesa quianh¹³ Jesús quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mi³ca¹jái¹ dsa² fariseo lah¹jøng², ca¹ŋǿh¹dsa dsa² quianh³ Jesús. Ca¹juúh²dsa: ―¿He² løa¹ gøah¹² tøa¹² quiánh² hniah¹² quianh¹³ dsa² cagh¹² cúg³ juøi² quianh¹³ dsa² ti³re² dsag³ calah? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ca¹nǿng² Jesús jǿg³ jøng². Jøng² ca¹juúh²dsa: ―Ha¹chian² tøa¹²mǿa¹² hnioh¹² quiah¹² dsa² dsiog¹. Quiah¹² dsa² dsoh³ báh³ hnioh¹² tøa¹²mǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gu³hniangh¹² hniah¹² he² hniu¹dsa juúh²dsa jǿg³ la², jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³: “Hiug¹² jín³ hi² hno¹jni hi² dsø¹ŋiú² hoh¹² hniah¹² ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² cónh¹ jín³ hi² dsiíh³ hniah¹² ne¹jni ju³lah rø²juúh² lei¹³,” ca¹juúh² Diú¹³. Di³ ca¹guio¹jni hi² log³jni dsa² ti³re² dsag³, a¹jáng¹ dsa² dsiog¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jøng² ca¹dsi¹lé² dsa quianh³ Juan, dsa² ca¹chiog¹ dsa² jmøi². Ca¹dsi¹lé²dsa ja³tsenh¹³ Jesús. Ca¹juúh²dsa: ―Quin² jnieh³ quianh¹³ dsa² fariseo mai³¹ hi² tsa¹quie¹² jnieh³ ja³cog² Diú¹³. ¿He² løa¹ tsa¹quin¹² dsa² quianh³hning mai³¹ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jøng² ca¹ŋai¹ Jesús: ―Lǿa¹² quián² jnieh³ ju³lah lǿa¹² quiah¹² dsa² dsa²lé² jmai³ quiah¹² dsa² ca¹jenh² gug². Tsa¹dsio¹ cán²dsa ju²hí³ dsøa¹² ta³lah¹guǿ¹² dsa² ŋioh¹² ma²jenh² gug². Cónh¹jøng² jií¹ jmai³ ja³jŋiah¹dsa jní². Jmai³ jøng² báh³ jmo¹ dsa² quian¹jni hi² tsa¹gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Tsa¹hniuh¹² tiáng³ jniang³ jneh³ hmøah¹² tsa¹ma²ŋangh¹² quianh¹³ tsǿnh³ ma²hǿg³. Di³ ma¹dsio¹² hi³méh¹ guíg¹ na³ca¹dsøgh¹² hmøah¹² hmë́². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jø¹² bíh³ tsa¹hniuh¹² tiíh³ jniang³ jmøi²rǿg² tsø³løg² ma²hǿg³. Di³ guíg¹ løg² na³ma²ca¹lø¹hiug¹² jmøi². Jøng² téng¹ jmøi². Jø¹² bíh³ dsa¹hén² løg². Løg² hmë́² báh³ tiíh³ jniang³ jmøi²rǿg². Lah¹jøng² tsa¹dsa¹hén² jin³ he² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mi³ca¹juúh² Jesús jǿg³ jøng², ca¹já¹ jan² dsa² ta³ quiah¹² guøh¹² quiah¹² dsa² judío. Ca¹chi¹jné¹dsa ni³ Jesús. Ca¹juúh²dsa: ―Ma²na²jon¹ ja³mái¹jni. Ma¹dsǿg³ ja³quieg¹jni. Gu³quiégh²hning gugh² ni³ quiah¹²dsa. Mi³jøng² jinh¹dsa calah ―ca¹juúh² dsa² ta³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jøng² ca¹ŋó¹ Jesús quianh¹³ dsa² héi². Jin² quianh¹³dsa dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jøng² ca¹já¹ jan² hio¹³ ta¹lah¹cah¹ Jesús, hio¹³ dsoh³. Ma²ni³ŋó¹³ guie¹tǿn² ji²ŋi² lán¹²dsa dsag³ ton²dsa. Ca¹láh² hio¹³ hé¹ tsǿnh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Di³ lë́²dsa: “Ju³ná³ lah¹³jni tsǿnh³ Jesús, hliú²jni,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jøng² ca¹jénh¹ Jesús. Ca¹jë́²dsa hio¹³. Ca¹juúh² Jesús: ―¡Cøng² jmo³ hoh¹², jon¹²! Ma²na²hlúh²hning. Di³ héh²hning jǿg³ quieg¹jni ―ca¹juúh²dsa. Dsø¹juu¹² jøng² ca¹hlú² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jøng² mi³ca¹dsiég¹ Jesús ja³quiah¹³ dsa² ta³, ca¹jë́²dsa dsa² ti³jiég² løg¹². Jø¹² bíh³ tiogh³ dsa² jue¹² tø²ho²dsa quiah¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jøng² ca¹juúh² Jesús: ―¡Hueh¹² ja³la²! Ha¹chi² ma²na²jon¹ tsih²mǿ². Rø²güé¹ báh³ tsih² ―ca¹juúh²dsa. Jøng² ca¹cu² ca¹jmáh²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jøng² mi³ca¹huah¹² dsa² jue¹², ca¹ŋó¹ Jesús dsi²néi². Ca¹chính²dsa gug² tsih²mǿ² héi². Jøng² ca¹jinh³ tsih²mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jøng² ca¹tsø¹ ca¹ja¹ jǿg³ lah¹cónh¹ ja³tén¹² huø¹ jøng², ha²lah ca¹jmo¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mi³ca¹u¹hái¹ Jesús ja³jøng², ca¹ŋi¹lé² og¹ dsa² teg³ chi³quë́¹ ta¹lah¹cah¹ Jesús. Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Ju³dsø¹ŋiú² hoh¹²hning jnieh³ tsø³jon² quiah¹² hlai³ Davíd! ―ca¹juúh² dsa² teg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jøng² mi³ca¹hí¹ Jesús dsi²néi², ca¹dsi¹lé² dsa² teg³ ni³ Jesús. Jøng² ca¹ŋai¹ Jesús: ―¿Héh³ hniah¹² hi² tiág¹²jni mi³hlég³jni mø³neih³ hniah¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Hé² báh³ jnieh³, Guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jøng² ca¹láh² Jesús mø³ni³ dsa² héi². Ca¹juúh²dsa: ―¡Ju³lé³ hi² jøng² quiánh² hniah¹² ca¹lah¹cónh¹ lǿa¹² jǿg³ hi² héh² hniah¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jøng² ca¹hlég² mø³ni³ dsa² héi². Jøng² ca¹tógh¹ Jesús dsa² jǿg³ ca¹lah¹tiog¹³ ja¹². Ca¹juúh²dsa: ―Ha¹chian² dsa² gu³tseih³ hniah¹² ca¹lah¹jin³ hein² cu¹té¹² he² ma²na²løa¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Di³ mi³ca¹huah¹²dsa jøng², ca¹tsø² ca¹ja¹dsa jǿg³ ta³cøng² juøi² ha²lah ca¹jmo¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jøng² mi³ma²dsø²huah¹² dsa² og¹ héi², ca¹ŋi¹jiag¹² ca²dsiog³ dsa² jan² dsa² cag³ ni³ Jesús. Quin¹² dsa² cag³ jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mi³ca¹dsi¹ Jesús jmi²dsí² hlaih¹³, jøng² ca¹hløah¹ dsa² mi³cag³. Ca¹can¹ dsa² jue¹² gøg². Ca¹juúh²dsa: ―Ca¹lah¹jin³ cu²rón² tsa¹ma²ca¹tǿ² ni³ jniang³ dsa² israel lah¹ná¹² ―ca¹juúh² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Di³ jøng² ca¹juúh² dsa² fariseo: ―Huø¹² Jesús jmi²dsí² hlaih¹³ quianh¹³ bí² ca¹cuø¹ juu¹³ jmi²dsí² hlaih¹³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jøng² ca¹ŋøa¹ Jesús ca¹lah¹jǿ¹ juøi² ca¹lah¹quianh¹³ rancho tioh¹³ cøg¹². Ca¹he¹dsa jǿg³ dsi²néi² guøh¹² quiah¹² dsa² judío lah¹cøng² lah¹cøng² juøi² ja³dsiég¹³dsa. Ca¹téng²dsa jǿg³ dsio¹ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹. Ca¹mi¹hliú²dsa ca¹lah¹já¹ dsa² ti³dsoh¹, quianh¹³ ca¹lah¹já¹ dsa² ti³quin¹² hliú² ni³ jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mi³ca¹jë́² Jesús dsa² jue¹², ca¹ŋi¹ŋiú² dsǿa¹²dsa quianh¹³ dsa² jue¹² héi². Di³ quin¹² dsa² jue¹² ju²hí³ dsøa¹². Ŋi²nio³dsa tø¹la² tø¹ná¹² ju³lah ŋi²nio³ jah¹chih² tsa¹chian² juu¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: Jue¹² báh³ dsa² chian². Cónh¹jøng² mih² báh³ dsa² jmo¹² hi² li¹quianh¹³ jniang³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hi² jøng² mǿh³ hniah¹² ni³ Juu¹³ jniang³ hi² tse¹dsa dsa² jmo¹ hi² li¹quianh¹³ jniang³ dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jøng² ca¹tǿh¹ Jesús dsa² guia¹tón², dsa² quián¹²dsa. Jøng² ca¹cuúh¹ Jesús dsa² héi² bí² hi² huø¹dsa jmi²dsí² hlaih¹³, hi² mi¹hliú²dsa dsa² ti³dsoh¹ ca¹lah¹he² ni³ dsag³ quianh¹³ ca¹lah¹he² ni³ jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lah¹la² báh³ tsen² dsa² guia¹tón², dsa² ca¹lán¹ dsa² høh³ quián¹²dsa: Dsa² lah¹ni³ tsen² Simón, dsa² ca¹quian¹dsa Pedro, quianh¹³ roh¹³dsa Andrés. Jacobo, quianh¹³ roh¹³dsa Juan, ja³ŋiúh³ Zebedeo ta³og¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe quianh¹³ Bartolomé. Tomás quianh¹³ Mateo, dsa² mi³cagh¹² cúg³ juøi². Jacobo, ja³ŋiúh³ Alfeo, quianh¹³ Tadeo. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, dsa² cananista, quianh¹³ Judas Iscariote, dsa² ca¹hnë¹ Jesús jmai³ chi³quë́¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jøng² lah¹la² ca¹tsáih¹ Jesús dsa² guia¹tón² niúh¹ jín³ hi² ca¹tsei¹dsa: ―Tsa¹gu³noh¹² hniah¹² ja³tiogh³ dsa² tsa¹lán¹² judío. Tsa¹gu³noh¹² hniah¹² ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cónh¹jøng² gu³noh¹² hniah¹² ja³tiogh³ dsa² israel, dsa² lán¹² ju³lah lán¹² jah¹chih² ma²ca¹ŋi¹cógh². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gu³hǿh¹ hniah¹² jǿg³ hi² ja¹quien¹³ jií¹ jmai³ ja³jmo¹ Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mi³hliúh³ hniah¹² dsa² dsoh³. Gu³tiángh² hniah¹² jmi²dsí² hi² hiog¹ dsa² ma²rø²jon¹². Mi³hliúh³ hniah¹² dsa² lán¹² hmih¹² tsa¹jŋi¹². Gu³huøh³ hniah¹² jmi²dsí² hlaih¹³. La³ca¹ŋëh¹² báh³ hniah¹² bí² jmóh³ hniah¹² lah¹jøng². Hi² jøng² tsa¹gu³quinh³ hniah¹² hliah¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Tsa¹gu³noh¹² hniah¹² quinh³ hniah¹² cog³, ju³lah cog³teg² cog³niáng¹³, ju³lah ŋi³néng². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tsa¹cánh³ mu²ra³ quiah¹² dsi²juu¹². Tsa¹cánh³ hniah¹² ma¹ton¹ tsǿinh² hniah¹². Tsa¹cánh³ hniah¹² løg² dsǿ² taih³ hniah¹². Tsa¹jmáh³ hniah¹² hma²hø¹³. Di³ tiog¹³ báh³ li¹hmah¹³ quiánh² hniah¹², hi² hniuh¹² dsi²juu¹², ja³jmóh³ hniah¹² ta³. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ju³ná³ ma²ca¹dsi¹noh¹² hniah¹² cøng² jøa³juøi² ho¹ ju³ cøng² rancho, ja³jøng² gu³hniah¹³ hniah¹² dsa² jmo¹ dsio¹ dsǿa¹² ja³cogh² hniah¹². Jøng² janh³ hniah¹² ja³quiah¹³ dsa² héi² ca¹lah¹ca¹tǿ² ja³gu³noh¹² hniah¹² juøi² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jøng² jǿg³ dsio¹ cuøh¹³ hniah¹² dsa² hniu³ ja³túgh³ hniah¹² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ju³ná³ ca¹mi¹dsiog¹ dsa² hniu³ quianh¹³ hniah¹², jøng² mǿh³ hniah¹² hi² jmo¹ Diú¹³ huø³ dsǿa¹² ja³cog²dsa. Ju²ná³ tsa¹ca¹mi¹dsiog¹dsa quianh¹³ hniah¹², jøng² tsa¹mǿh³ hniah¹² hi² jmo¹ Diú¹³ hi² dsio¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jøng² ha² ja³tsa¹hie¹dsa hniah¹², ho¹ ju³ tsa¹nang¹dsa jǿg³ quiánh² hniah¹², hueh¹² hniah¹² ja³jøng². Jøng² quiah¹³ hniah¹² hleg² ti³quin¹² joh¹³taih¹ hniah¹², hi² jmóh³ hniah¹² tsa¹jeh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lah¹dsóh² juǿi²jni hniah¹²: Hiug¹² jín³ hi² cuúh¹ Diú¹³ dsa² chian² juøi² jøng² ju²lih¹³ dsøa¹², ca¹lah¹cónh¹ jín³ jmø³uai¹² cuúh¹ Diú¹³ dsa² hlanh³ mi³tiogh³ Sodoma quianh¹³ Gomorra ma²lǿih², na³ma²ca¹dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Jai³lah! Tsë́²jni hniah¹² ju³lah jan² dsa² tse² jah¹chih² jøa³ ja³tiogh³ dsøi²núng³. Jøng² mi³lih¹³ hniah¹² hoh¹², ju³lah jmo¹² møh². Cónh¹jøng² jmóh³ hniah¹² huø³ hoh¹² hniah¹² ju³lah lán¹² jug² bøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jmóh³ hniah¹² hí³. Di³ li¹chian² dsa² dsø¹jiag¹² ni³ dsa² ta³. Bá²dsa hniah¹² dsi²néi² guøh¹² quiah¹² dsa² judío. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jø¹² bíh³ hnë¹dsa hniah¹² ja³ta¹ni¹ dsa² ta³ quianh¹³ rai¹³, huu¹³ quieg¹ jní². Mi³jøng² héh³ hniah¹² jǿg³ quieg¹jni ja³ta¹ni¹ dsa² canh¹³ héi² quianh¹³ dsa² tsa¹lán¹² judío. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² ha²lah hløah¹³ hniah¹² ja³cua¹dsa hniah¹² ni³ dsa² ta³. Diú¹³ báh³ cuø¹ jǿg³ ha²lah juúh³ hniah¹² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A¹jáng¹ jǿg³ quiánh² guiogh¹³ hniah¹² hi² hløah¹³ hniah¹² jmai³ jøng². Jǿg³ he¹ jmi²dsí² han¹³ quiah¹² Jmi² jniang³ juúh³ hniah¹² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Jøng² li¹chian² dsa² jë́h² roh¹³, hi² jón²dsa. Jë́h² ti³jmi²dsa guing² quián¹²dsa. Tá¹ báh³ guing² quianh¹³ chiég³ jmi² guing². Mi¹dsiag¹² báh³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Li¹hian³ ca¹lah¹já¹ dsa² jmøi¹guǿi¹ hniah¹² huu¹³ quieg¹ jní². Jøng² liúg² báh³ dsa² ca¹mi¹tián² dsǿa¹² ca¹lah¹ca¹tǿ² jmai³ ja³dsián¹ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ju³ná³ jmóh² dsa² chian² cøng² juøi² hniah¹², cuøinh¹³ hniah¹² juøi² siíh². Lah¹dsóh² juǿi²jni hniah¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹²: Guiogh¹³ báh³ jní² niúh¹ jín³ hi² gu³noh¹² hniah¹² ca¹lah¹jǿ¹ juøi² ja³tiogh³ dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ha¹chi² lán¹² dsa² mi²tan¹² jǿg³ dsa² juanh¹² cónh¹ jín³ tøa¹² quián¹²dsa. Ca¹lah¹jin³ hein² dsa² jmo¹² ta³ tsa¹juanh¹²dsa ca¹lah¹cónh¹ jín³ juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tiúh¹ báh³ cónh¹ hi² lén² dsa² mi²tan¹² jǿg³ ju³lah lán¹² tøa¹² quián¹²dsa. Tiúh¹ báh³ cónh¹ lén² dsa² jmo¹² ta³ ju³lah lán¹² juu¹³ ta³. Ca¹tǿh¹ dsa² hiag¹³ jní² Beelzebúl, jní² dsa² lán¹² juuh² hniah¹². Jøng² ma²ŋih³ hniah¹² hiug¹² jín³ jǿg³ hlaih¹³ chi³hia¹dsa hniah¹², dsa² lanh¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Hi² jøng² tsa¹jmóh³ hniah¹² ganh¹ quiah¹² dsa² jue¹². Li¹léi¹³ ca¹lah¹jǿ¹ jǿg³ chi³jnøa¹². Dsiég¹³ jmai³ ja³jní¹ jǿg³ rø²hma¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jǿg³ hi² juǿi²jni hniah¹² ja³tsa¹jní², jǿg³ jøng² juúh³ hniah¹² calah ja³nang¹ dsa². Jǿg³ juǿi²jni hniah¹² ja³cu³guiag¹³ jniang³, jǿg³ jøng² juúh³ hniah¹² ta³cøng² juøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tsa¹jmóh³ hniah¹² ganh¹ dsa² jmøi¹guǿi¹ jianh¹² hniah¹², dsa² tiúh¹ jŋëh¹ jmáh¹lah jmø²ŋǿ¹². Di³ tsa¹lé² jŋëh¹dsa jmi²dsí² quiánh² hniah¹². Cónh¹jøng² jmóh³ hniah¹² hi² ganh¹ hniah¹² Diú¹³, dsa² tiúh¹ hén² jmø²ŋǿa¹² cu¹dsie¹² quianh¹³ jmi²dsí² quiánh² hniah¹² guio¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Jmáh¹ ma¹guie¹ ŋi³néng² cán²dsa og¹ tan¹² píh³. Cónh¹jøng² ca¹lah¹jin³ hein² jáh² héi² tsa¹tiáh¹ huø¹ ju³ná³ tsa¹ca¹cuø¹ Jmi² jniang³ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma²ŋi¹² Diú¹³ ha²cónh¹ hmëh¹² jŋiu² ti³dsøa¹² dseih¹² hniah¹² lah¹jan² lah¹jan² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hi² jøng² tsa¹jmóh³ hniah¹² ganh¹. Di³ hiug¹² jín³ hi² quien¹² hniah¹² cónh¹ jín³ jue¹² tan¹² píh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ju³ná³ hein² dsa² ca¹mi¹quianh¹³ jní² ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jian¹²dsa, dsa² héi² mi³quianh¹³ jní² ja³ta¹ni¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jø¹² bíh³ ju³ná³ hein² dsa² tsa¹ca¹mi¹jní² lah¹jøng² ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jian¹²dsa, dsa² héi² tsa¹mi³quianh¹³ jní² ja³ta¹ni¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Tsa¹ju³lë́h³ hniah¹² hi² ca¹guio¹jni hi² niu¹ tei³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹. Ca¹guio¹jni hi² túgh³ hniah¹² ma¹quién¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ca¹guio¹jni hi² jmo¹³jni túgh³ dsa² ma¹quién¹, ja³ŋiúh³dsa quianh¹³ ti³jmi²dsa, ja³mái¹³dsa quianh¹³ mi³chiég³dsa, lo¹³dsa quianh¹³ mø²chiég³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ju²rúh² báh³ hniah¹² lé² dsa² hiag¹³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Tsa¹ta³té¹³ dsa² héi² lén² dsa² quian¹jni, ju³lah dsa² hnio¹ jmi² chiég³ cónh¹ jín³ hi² hniang¹dsa jní². Tsa¹ta³té¹³ dsa² héi² lén² dsa² quian¹jni, ju³lah dsa² hnio¹ ja³ŋiúh³ ja³mái¹³ cónh¹ jín³ hi² hniang¹dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tsa¹ta³té¹³ dsa² héi² lén² dsa² quian¹jni, ju³lah hein² dsa² tsa¹hiug² dsǿa¹² hie¹dsa jón²dsa huu¹³ hi² ŋøa¹dsa quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ha¹chi² mi¹hmah¹³ dsa² héi² ja³cog² Diú¹³ jmøi¹guǿi¹ cøng², ju³lah hein² dsa² dsa²jiag¹² dsǿa¹² jmáh¹lah jǿg³ ha²lah gú¹dsa dsio¹ jmøi¹guǿi¹ la². Cónh¹jøng² ju³ná³ hein² dsa² jón² huu¹³ quieg¹jni li¹chian² dsa² héi² ja³dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ju³ná³ hein² dsa² ca¹hieh² hniah¹², ca¹hiei¹ dsa² héi² jní² calah. Jø¹² bíh³ ju³ná³ hein² dsa² ca¹hiei¹ jní², dsa² héi² ca¹hie¹ Juu¹³ jniang³, dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ju³ná³ hein² dsa² ca¹hie¹ jan² dsa² hǿ² jǿg³ quiah¹² Diú¹³ ni³ huu¹³ hi² lán¹²dsa dsa² hǿ² jǿg³, cøng² ni³ mi¹hmah¹³ dsa² héi² ju³lah mi¹hmah¹³ dsa² hǿ² jǿg³. Ju³ná³ hein² dsa² ca¹hie¹ jan² dsa² jmo¹² hi² hniu¹ Diú¹³ ni³ huu¹³ hi² jmo¹²dsa lah¹jøng², cøng² ni³ mi¹hmah¹³ dsa² ca¹hiei¹ héi² ju³lah mi¹hmah¹³ dsa² ca¹jmo¹ hi² hniu¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ju³ná³ hein² dsa² ca¹cuø¹ cøng² cuøh³ jmøi² guúh² quiah¹² jan² dsa² meh² quian¹ jní², ni³ huu¹³ hi² lán¹² dsa² meh² dsa² quian¹ jní², lah¹dsóh² mi¹hmah¹³ dsa² héi² ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mi³ca¹jŋi¹ ca¹heh¹ Jesús dsa² guia¹tón² jǿg³, ca¹ŋó¹dsa hi² he¹dsa jǿg³, hi² téng²dsa jǿg³ ca¹lah¹jǿ¹ juøi² ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jøng² ma²hiúg³ Juan hni¹ŋí³, dsa² mi³chiog¹² dsa² jmøi². Ja³jøng² ca¹nǿng²dsa ha²lah ma²jmo¹² Cristo. Jøng² ca¹tse¹dsa ca²dsiog³ dsa² quianh¹³dsa ja³hiúg³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jøng² ca¹ŋai¹ dsa² quianh¹³ Juan, ca¹tsáih¹dsa Jesús: ―¿Hning³ dsa² lanh¹² dsa² héi², dsa² ji¹liag¹³ jnieh³, ho¹ ju³ jií¹ dsa² siáh²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jøng² ca¹juúh² Jesús: ―Gu³tseih³ hniah¹² Juan he² hi² ma²na²jaih³ hniah¹² quianh¹³ he² hi² ma²na²nengh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma²jniuh¹² dsa² mi³teg³. Ma²ŋi²nio³ dsa² tsa¹mi³lé² ŋi¹nio¹. Ma²ca¹hlú² dsa² mi³lán¹³ hmih¹² tsa¹jŋi¹². Ma²niuh³ dsa² mi³guai³. Ma²ca¹jinh³ dsa² ma²ca¹dsan¹. Chi² báh³ jǿg³ dsio¹ quiah¹² dsa² ti²ŋié². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hioh¹² jenh¹² dsa² tsa¹lë́² ué² jǿg³ quieg¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mi³ca¹ŋi¹lia¹ dsa² quianh¹³ Juan, ca¹dsii¹ Jesús jǿg³ quiah¹² Juan. Ca¹tsáih¹dsa dsa² jue¹² tiogh³. Ca¹juúh²dsa: ―¿He² hi² lë́h² hniah¹² hi² jáih³ hniah¹² mi³ca¹ŋi¹janh³ hniah¹² Juan juu¹² ja³ha¹chian² dsa² tiogh³? ¿Lán¹³dsa dsa² ton¹ jǿg³ neng¹² dsǿa¹², ju³lah løa¹² hma² ta² cán² dsí²? Ha¹chi² lán¹²dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ha²lah lán¹²dsa jøng²? ¿Quieih¹³dsa hmøah¹² jláh³? Ha¹chi². Ja³guǿ¹² rai¹³, ja³jláh³ báh³ tiogh³ dsa² ti³quieih¹² hmøah¹² jláh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿He² løa¹ ma²ca¹ŋieh³ hniah¹² ja³hiúg³ Juan? ¿Tsa³ca¹janh³ hniah¹² dsa² hǿ² jǿg³ quiah¹² Diú¹³? Dsa² lah¹héi² báh³ ca¹janh³ hniah¹². Dsa² juanh¹² hi³méh¹ lán¹² Juan cónh¹ jín³ dsa² siáh² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan báh³ ca¹hia¹dsa quianh¹³ jǿg³ la², jǿg³ rø²juúh² si², hi² ca¹tsáih¹ Diú¹³ jong¹²dsa: Tsë́³jni tsih² høh³ quian¹jni ni³jiá¹ cónh¹ jín³ hning², dsa² jmo¹ ju²jŋia¹³ juu¹² ja³ŋǿh³hning, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chian² dsa² jmøi¹guǿi¹ chian², ju³lah dsa² juanh¹² jín³ cónh¹ Juan, dsa² ca¹chiog¹ dsa² jmøi². Cónh¹jøng² lǿa¹² ju³ hein² dsa² lán¹² dsa² meh² ja³jmo¹² Diú¹³ héh¹, dsa² héi² báh³ lán¹² dsa² juanh¹² cónh¹ jín³ ja³lán¹² Juan ni³ jmøi¹guǿi¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ca¹lah¹cónh¹ jmai³ mi³ca¹guøn¹ Juan, dsa² ca¹chiog¹ dsa² jmøi², ca¹lah¹jín³ na¹, jue¹² dsa² mi³hniu¹ dsa¹tiogh¹² ja³jmo¹² Diú¹³ héh¹. Quianh¹³ ca¹lah¹tiog¹³ jmo¹²dsa hi² dsa¹tiogh¹²dsa ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jǿg³ quiah¹² ja³jmo¹² Diú¹³ héh¹ ma²rø²juúh² si² quiah¹² hlai³ Moisés quianh¹³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ca¹lah¹ca¹tǿ² ja³ca¹guøn¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chi²júh² hniah¹² hnøngh² héh² jǿg³, hlai³ Elías héi² báh³ lán¹² Juan, dsa² rø²juúh² si hi² mi³jiúgh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ju³ hein² dsa² lé² nang¹, ju³neng¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Lah¹la² lán¹² dsa² ma²chian² na¹: Lán¹²dsa ju³lah lán¹² hi²meh² tiogh³ ja³dsi¹² guøh¹². Dsii¹² hi²meh² jǿg³ quianh¹³ roh¹³. Juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ma²ca¹jmó³ jnieh³ son¹³. Tsa¹ca¹jmoh³ hniah¹² jan³. Ma²ca¹jmó³ jnieh³ hi² chian² jnieh³ jmø³uai¹² calah. Jøng² ha¹chi² ca¹hagh³ hniah¹²,” juúh² hi²meh². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lah¹jøng² lanh¹² hniah¹². Di³ tsa¹tøa¹² hoh¹² hniah¹² mi³ca¹guøn¹ Juan. Hliú² rón² ca¹mi¹han¹²dsa hi² tsa¹gøah¹²dsa. Tsa¹ca¹hǿnh²dsa jmøi² hiug¹². Jøng² ca¹juøh³ hniah¹² hi² quin¹²dsa jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jøng² ca¹guio¹ jní² calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cøh²gøh²jni ca¹lah¹jǿ¹. Jøng² juúh² hniah¹² hi² lán¹² jní² dsa² jlé², dsa² hen¹², dsa² ti³jenh² jní² quianh¹³ dsa² cagh¹² cúg³ juøi² quianh¹³ dsa² ti³re² dsag³, juúh² hniah¹². Di³ léi¹³ ma²ŋi¹² Diú¹³ ha²lah jmo¹. Di³ hi² dsio¹ báh³ ca¹løa¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ni³ jøng² ca¹jé² Jesús dsa² tiogh³ jøa³juøi² ja³ca¹jmo¹dsa juu¹² juøh¹² ma¹dsio¹² cónh¹ jín³ ja³siíh³. Di³ tsa¹ca¹jéinh¹ dsǿa¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ca¹juúh² Jesús: ―¡He² báh³ ué quiánh² hniah¹², dsa² chianh² jøa³juøi² Corazín quianh¹³ jøa³juøi² Betsaida! Di³ cu¹ŋieih¹³ mi³mi¹dsian¹² dsǿa¹² dsa² chian² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón. Cu¹ŋieih¹³ mi³jéinh¹ dsǿa¹²dsa dsag³ hi² mi³jmo¹²dsa, ju³ jøng² ca¹løa¹ juu¹² juøh¹² ja³tiogh³dsa ju³lah lǿa¹² juu¹² juøh¹² ca¹jmo¹jni ja³tiogh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hiug¹² hi² tsa¹ué² lé² quiah¹² dsa² chian² Tiro quianh¹³ Sidón cónh¹ jín³ hniah¹² na³ma²ca¹dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jø¹² bíh³ hniah¹², dsa² chianh² jøa³juøi² Capernaum, lë́h² hniah¹² hi² quienh¹² hniah¹² ma¹dsio¹² ju³lah quien¹² dsa² guǿ¹² ŋi¹juǿi¹. Di³ juu¹² guio¹juǿi¹ báh³ dsiánh¹ Diú¹³ hniah¹². Ju³ jøng² ca¹løa¹ juu¹² juøh¹² jøa³juøi² Sodoma ju³lah ca¹jmo¹jni ja³tiogh³ hniah¹², mi³jeính¹ báh³ dsǿa¹² dsa² tiogh³ ja³jøng². Mi³jøng² ha¹chi² mi³hén² Diú¹³ ja³jøng². Mi³neng¹² báh³ juøi² jøng² ca¹lah¹jin³ na¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hiug¹² jín³ tsa¹ué² lé² quiah¹² dsa² mi³chian² Sodoma cónh¹ jín³ hniah¹², dsa² chian² Capernaum, na³ma²ca¹dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jmai³ jøng² ca¹juúh² Jesús, ca¹hlanh¹dsa Diú¹³: ―Di³hmah³hning, Tiá³, hning² dsa² lanh¹² Juu¹³ dsa² chian² ŋi¹juǿi¹ quianh¹³ dsa² chian² jmøi¹guǿi¹. Di³ ma²ca¹jmoh³hning hi² tsa¹ŋë́h² dsǿa¹² dsa² ŋi¹² ma¹dsio¹² jǿg³ quiah¹² jmøi¹guǿi¹ la². Ma²ca¹heh³hning dsa² tsa¹ŋi¹² ma¹dsio¹², dsa² lán¹² ju³lah lán¹² guing². Ma²ca¹heh³hning jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lah¹jøng² ca¹lø¹hiúg¹ hoh¹²hning, Tiá³. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ju²gug¹jni ma²ca¹dsii¹ ti³ŋieh¹jni ca¹lah¹jǿ¹ hi² quiah¹²dsa. Ca¹lah¹jin³ hein² dsa² tsa¹cue¹² jní² ju³lah cue¹² ti³ŋieh¹jni. Jø¹² bíh³ ca¹lah¹jin³ hein² dsa² tsa¹cue¹² ti³ŋieh¹jni. Jan² jní² báh³ dsa² cué¹² ti³ŋieh¹jni, quianh¹³ dsa² hno¹jni hé¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Ji¹noh¹² hniah¹² quianh¹³ jní², ca¹lah¹jáh¹ hniah¹² dsa² ca¹húh¹ hoh¹², dsa² mi³quinh³ mai³¹ quiah¹² dsa² hóg¹. Mi³jøng² cuø³jni ja³jah¹ hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jmáh³ hniah¹² jǿg³ quieg¹jni. Mi³tanh¹³ hniah¹² jǿg³. Di³ lán¹²jni dsa² juanh¹² dsǿa¹², dsa² huø³ dsǿa¹². Jøng² jinh¹ hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ha¹chi² ué² héh¹ jmo¹³jni quianh¹³ hniah¹². Lé² báh³ mi³tih³ hniah¹² jǿg³ quieg¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Cøng² jmai³ sa³¹ ma²ŋøa¹² Jesús jøa³ cuøi² hi³ŋíh¹, mi³ca¹løa¹ lø¹i³cónh¹² dsa² quianh¹³dsa. Hi² jøng² ca¹huøh¹ dsa² héi² hmë́h² cuøi² hi³ŋíh¹. Ca¹cǿgh²dsa mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mi³ca¹jái¹ dsa² fariseo hi² jøng², ca¹tsáih¹dsa Jesús: ―¡Jai³lah! Ma²jmo¹² dsa² quiánh²hning ta³ hi² tsa¹lé² jmo¹dsa jmai³ sa³¹, jmai³ ja³jŋi³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿Tsa³ma²ca¹híh² hniah¹² si² ha²lah ca¹jmo¹ hlai³ David jmai³ ca¹løa¹ lø¹i³cónh¹²dsa quianh¹³ dsa² quianh¹³dsa? ");
INSERT INTO cpaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ca¹hí¹dsa dsi²néi² guøh¹². Ca¹gǿh¹dsa hi³ŋíh¹ ma²ca¹dsii¹ jmi²dsa² ni³ Diú¹³, hi³ŋíh¹ ma²lǿa¹² lei¹³ hi² gǿh¹ jmáh¹lah jmi²dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jø¹² bíh³ rø²juúh² si² lei¹³ quiah¹² hlai³ Moisés, ha²lah jmo¹² jmi²dsa² ta³ dsi²néi² guøh¹² jmai³ sa³¹. Jøng² ha¹chi² dsag³ ta¹canh¹³dsa hi² jmo¹²dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Jøng² juǿi²jni hniah¹²: Ja³la² tsenh¹² jan² dsa² quien¹² cónh¹ jín³ guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tsa¹ŋih³ hniah¹² he² hniu¹dsa juúh²dsa jǿg³ la² lǿa¹² ni³ si² quiah¹² Diú¹³: “Hiug¹² jín³ hi² hno¹jni hi² dsø¹ŋiú² hoh¹² hniah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² cónh¹ jín³ hi² dsiíh³ hniah¹² ne¹jni ju³lah rø²juúh² lei¹³,” ca¹juúh² Diú¹³. Tsa¹mi³cuøh¹³ hniah¹² dsa² dsag³ tsa¹re²dsa, ju³ jøng² ma²ŋih³ hniah¹² he² hniu¹dsa juúh²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jní² báh³ dsa² jmo¹² héh¹ he² hi² lé² jmó³ jniang³ jmai³ sa³¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jøng² ca¹ŋó¹ Jesús. Ca¹hí¹dsa dsi²néi² guøh¹² quiah¹² dsa² chian² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jøng² mi³hiúg³ jan² dsa² ŋioh¹² ja³jøng², dsa² dsi¹³ huh² cøng² gug². Jø¹² bíh³ tiogh³ ca²dsiog³ dsa² hnangh¹² mai³¹ ha²lah cuúh¹dsa Jesús dsag³. Jøng² ca¹ŋǿh¹ dsa² héi² Jesús: ―¿Tsa³dsio¹ jmo¹dsa hí³ jan² dsa² dsoh³ jmai³ sa³¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ha¹chianh² hniah¹² tsa¹dsenh¹³ jah¹chih² quiánh² hniah¹² dsø¹juu¹², ju³ná³ ca¹tánh²jah niúh¹ tøg² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jøng² hiug¹² jín³ ma¹dsio¹² quien¹² jan² dsa² cónh¹ jín³ jan² jah¹chih². Hi² jøng² lé² jmó³ jniang³ hi² dsio¹ jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² dsoh³: ―¡Neih³ gugh²! ―ca¹juúh²dsa. Jøng² ca¹néih¹ dsa² ŋioh¹² gug². Ta³lah¹ca¹lái¹ dsio¹ gug²dsa ju³lah lǿa¹² gug²dsa cøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jøng² ca¹huah¹² dsa² fariseo héi². Ca¹jmo¹dsa jǿg³ ha²lah jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jøng² ca¹u¹hái¹ Jesús ja³jøng² mi³ca¹lø¹ŋi¹²dsa jǿg³ jøng². Jue¹²dsa ca¹ŋi¹lé² quianh¹³dsa. Ca¹mi¹hliú² Jesús ca¹lah¹já¹ dsa² mi³ti³dsoh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jøng² ca¹jmo¹ Jesús héh¹ hi² tsa¹jmo¹ dsa² mi³ti³dsoh¹ jǿg³ ha²lah ca¹hlú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mi³jøng² li¹ti¹ jǿg³ la² ca¹téng² hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³: ");
INSERT INTO cpaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Dsa² lang¹² báh³ dsa² lán¹² dsa² quian¹jni, juúh² Diú¹³, dsa² ma²ca¹hnah¹²jni, dsa² hnó¹jni. Tøa¹² báh³ dsøa¹jni quianh¹³dsa. Tií¹³jni jmi²dsí² quieg¹jni quiah¹²dsa. Téng²dsa jǿg³ hi² cán³jni jǿg³ dsøg¹² quiah¹² dsa² tsa¹lán¹² judío. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ha¹chi² tsë́¹dsa quianh¹³ roh¹³dsa. Tsa¹ho¹dsa tí². Ha¹chi² hløah¹dsa tí² jøa³cai³¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jmo¹dsa dsio¹ dsǿa¹² ja³cog² dsa² tsa¹hiug² dsǿa¹², dsa² lán¹² ju³lah lǿa¹² hma² ta² rø²guión², dsa² lán¹² ju³lah lǿa¹² cø² tsa¹cøg² cu²rø², ca¹lah¹ca¹tǿ² ja³ca¹lø¹chí¹ jǿg³ dsøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jǿg³ quiah¹² dsa² héi² chính² dsa² tsa¹lán¹² judío, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jøng² ca¹ŋi¹jian¹²dsa jan² dsa² mi³quin¹² jmi²dsí² hlaih¹³ ja³tsenh¹³ Jesús. Jmi²dsí² hlaih¹³ ca¹jmo¹ hi² lán¹² dsa² héi² dsa² teg³ dsa² cag³. Jøng² ca¹mi¹hliú² Jesús dsa² héi². Ca¹hløah¹dsa. Jø¹² bíh³ ca¹lø¹jniuh¹²dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² tiogh³. Ca¹juúh²dsa: ―¿Lán¹³ dsa² lang¹² tsø³jong¹³ hlai³ David, dsa² lég² jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mi³ca¹nǿng² dsa² fariseo jǿg³ jøng², ca¹juúh²dsa: ―Dsa² lang¹² huø¹² jmi²dsí² hlaih¹³ quianh¹³ jǿg³ quiah¹² Beelzebú, juu¹³ jmi²dsí² hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma²ŋi¹² báh³ Jesús ha²lah lë́² dsa² héi². Hi² jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Tsa¹hai³ dsa¹hén² juøi² juøh¹² ju³ná³ tsa¹tiogh³ dsa² juøi² cøng² jǿg³. Jø¹² bíh³ dsa¹hén² jǿg³ quiah¹² dsa² tiogh³ juøi² mih², ho ju³ dsa² tiogh³ cøng² hniú¹², ju³ná³ cø²tsë́¹²dsa guiog¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hi² jøng² dsa¹hén² jǿg³ quiah¹² Satanás, dsa² tøah¹² hniah¹² Beelzebú héi², ju³ná³ tá¹²dsa quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Juúh² hniah¹² hi² huø³jni jmi²dsi² quianh¹³ jǿg³ quiah¹² Beelzebú. ¿Hein² dsa² cuø¹² bí² hi² huø¹² dsa² quianh¹³ hniah¹² jmi²dsí² hlaih¹², chi²júh² lah¹jøng² lǿa¹²? Guiog¹³ báh³ dsa² quiánh² hniah¹² mi²léi¹³ tsa¹dsøg¹² jǿg³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Di³ hŋiah¹² jmi²dsí² han¹³ quiah¹² Diú¹³ báh³ dsa² cuø¹² bí³ hi² huø³jni jmi²dsí² hlaih¹³. Hi² jøng² ma²ŋih³ hniah¹² ca¹dsiég¹ jmai³ ja³jmo¹² Diú¹³ héh¹ jøa³ ja³tiagh³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ha¹chian² dsa² lé² hí¹ dsi²néi² quiah¹² dsa² bé², hi² cán²dsa hi² chi² quiah¹²dsa, ju³ná³ tsa¹ma²na²hŋió²dsa dsa² hniu³ ni³jiá¹. Ju³ná³ ma²na²hŋió²dsa, jøng² ma²lé² cán²dsa hi² chi² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ju³ná³ hein² dsa² tsa¹hiúg³ quianh¹³ jní², dsa² héi² lán¹² dsa² hiag¹³. Ju³ná³ hein² dsa² tsa¹mi³hag¹³ hi² li¹quianh¹³ jní² dsa², dsa² héi² jmo¹² dsø²lé² dsa² juu¹² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Hi² jøng² juǿi²jni hniah¹²: Li¹chi² báh³ ju²hén² dsǿg³ dsa² jmøi¹guǿi¹. Hén¹³jni ca¹lah¹jǿ¹ dsag³ re²dsa ho¹ ju³ he² jǿg³ hlaih¹³ ma²ca¹hløah¹dsa. Cøng² dsag³ jøng² tsa¹dsa¹hén² quiah¹² dsa² jmøi¹guǿi¹, ju³ná³ jǿg³ hlaih¹³ ca¹hia¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Li¹chi² báh³ ju²hén² dsǿg³ dsa² ma²ca¹hia¹jni jǿg³ hlaih¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cónh¹jøng² tsa¹lǿih² jmai³ dsa¹hén² dsǿg³ dsa² ca¹hia¹ jmi²dsí² han¹³ jǿg³ hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Lán¹²jni ju³lah lǿa¹² cøng² hma². Hma² dsio¹ cuø¹ mǿi² dsio¹. Hma² hlaih¹³ cuø¹ mǿi² hlaih¹³. Quianh¹³ mǿi² quiah¹² báh³ hma², li¹léi¹³ ha²lah lǿa¹² lah¹cøng² lah¹cøng² hma². Quianh¹³ hi² ca¹jmo¹jni li¹léi¹³ ha²lah lán¹²jni calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lanh¹² hniah¹² ju³lah lán¹² møh². Tsa¹lé² juúh³ hniah¹² jǿg³ dsio¹. Di³ lanh¹² hniah¹² dsa² hlanh³. Jǿg³ jøng² báh³ huøh¹² hag³ dsa² jmøi¹guǿi¹, jǿg³ dsø²jiag¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hi² dsio¹ báh³ dsø²jiag¹² dsǿa¹² dsa² dsiog¹. Hi² jøng² juúh²dsa jǿg³ dsio¹. Hi² hlaih¹³ báh³ dsø²jiag¹² dsǿa¹² dsa² hlanh³. Hi² jøng² juúh²dsa jǿg³ hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","’Hi² jøng² juǿi²jni hniah¹²: Cán² báh³ Diú¹³ jǿg³ dsøg¹² ca¹lah¹jǿ¹ jǿg³ ha¹chi² ta³ li¹jmo¹, hi² ma²ca¹juúh² dsa² jmøi¹guǿi¹, jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cán² báh³ Diú¹³ jǿg³ dsøg¹² quiánh² hniah¹² ha²lah lǿa¹² jǿg³ ma²ca¹juøh³ hniah¹². Jái¹dsa chi²júh² liúgh² hniah¹², chi²júh² ta¹canh¹³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jøng² ca²dsiog³ dsa² fariseo quianh¹³ tøa¹² he² lei¹³ quiah¹² Diú¹³ ca¹juúh², ca¹tsáih¹dsa Jesús: ―Tøa¹², hneng² jnieh³ ne¹³ jnieh³ ja³jmóh³hning cøng² juu¹² juøh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jøng² ca¹juúh² Jesús: ―Dsa² hlanh³ báh³ hniah¹². Héi¹ dsa² hnio¹ Diú¹³ møa¹² juu¹² juøh¹². Cónh¹jøng² jmáh¹lah juu¹² juøh¹² jøng² báh³ jáih³ hniah¹², ju³lah ca¹løa¹ quiah¹² hlai³ Jonás, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Di³ ca¹hí¹ Jonás niúh¹ togh¹² jáh² juanh¹² tiogh³ jmø³ŋih¹³. Ca¹hí¹dsa hnøa¹² jmai³, hnøa¹² neng¹². Jø¹² bíh³ lah¹jøng² lé² quianh¹³ jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Hú¹³jni niúh¹ huø¹ hnøa¹² jmai³, hnøa¹² neng¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jøng² tógh¹ dsa² mi³chian² jøa³juøi² Níneve jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Jøng² cuúh¹dsa hniah¹² dsag³. Di³ ca¹jéinh¹ báh³ dsǿa¹² dsa² mi³chian² ja³jøng² jmai³ ca¹hǿ² hlai³ Jonás jǿg³ quiah¹² Diú¹³. Jøng² dsa² juanh¹² báh³ jní² cónh¹ jín³ hlai³ Jonás. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jø¹² bíh³ núng¹ hio¹³ rai¹³ mi³chian² huø¹ ta¹lah¹sur jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Cuúh¹ hio¹³ hniah¹² dsag³. Di³ uǿin² hlaih¹³ ca¹já¹ hio¹³ héi² hi² nang¹dsa jǿg³ ma¹dsio¹² ma²ŋi¹² hlai³ rai¹³ Salomón. Jøng² dsa² juanh¹² báh³ jní² cónh¹ jín³ hlai³ rai¹³ Salomón. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Na³ma²ca¹u¹hái¹ cøng² jmi²dsí² hlaih¹³ hi² mi³quin¹² dsa², jøng² ŋó¹² jmi²dsí² juu¹² ja³quing² hi² hnangh¹² jmi²dsí² cøng² ja³li¹jŋi¹. Tsa¹dsóh² jmi²dsí² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jøng² lë́² jmi²dsí²: “Neh¹³jni juu¹² ja³mi³guø³jni.” Jøng² na³ma²ca¹dsiánh¹ jmi²dsí² ja³tsenh¹³ dsa² mi³quin¹², jái¹ jmi²dsí² ma²lǿa¹² dsǿa¹² dsa² héi² ju³lah lǿa¹² cøng² hniú¹² ha¹chian² dsa² chian², hniú¹² ma²rø²hieh¹³ dsi²néi², hniú¹² jní² dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jøng² dság¹ jmi²dsí². Dsø¹tei¹ jmi²dsí² guio¹ jmi²dsí² hlaih¹³ hi³méh¹ cónh¹ jín³ hŋiah¹² jmi²dsí². Jøng² dsa¹tiogh¹² jmi²dsí² cu²dsie¹² quiah¹² dsa² mi³quin¹² lah¹jiá¹². Jøng² ué² hi³méh¹ lé² quiah¹² dsa² ca¹lah¹cónh¹ hi² mi³løá¹³ lah¹jiá¹². Lah¹jøng² báh³ lénh² hniah¹², dsa² hlanh³ chian² na¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ma²heh¹² Jesús dsa² jue¹² jǿg³, mi³ca¹dsi¹lé² mi³chiég³dsa quianh¹³ roh¹³dsa. Ca¹túgh²dsa ja³dsi¹². Hniu¹dsa mi³dsii¹dsa jǿg³ quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jøng² ca¹juúh² jan² dsa², ca¹tsáih¹dsa Jesús: ―Tiogh³ mi³chiégh²hning quianh¹³ rúh²hning ja³dsi¹². Hniu¹dsa dsii¹dsa jǿg³ quianh¹³ hnéng¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jøng² ca¹tsáih¹ Jesús dsa² ca¹juúh² jǿg³ jøng²: ―¿Hein² dsa² lán¹² mi³chie¹jni lah¹quianh¹³ roh¹²jni? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jøng² ca¹hë́² Jesús gug² ja³tiogh³ dsa² quianh³dsa. Ca¹juúh²dsa. ―Dsa² ná¹² báh³ dsa² lán¹² mi³chie¹jni ca¹lah¹quianh¹³ roh¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Di³ dsa² héi² báh³ dsa² lán¹² lah¹dsóh² roh¹²jni quianh¹³ mi³chie¹jni, dsa² mi²ti¹ jǿg³ quiah¹² Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jmai³ jøng² ca¹u¹hái¹ Jesús dsi²néi² ja³mi³téng²dsa jǿg³. Ca¹ŋi¹gú¹dsa chiuh³ jmøi² juøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jøng² ca¹dsi¹lé² jue¹² hlaih¹³dsa. Hi² jøng² ca¹uǿi¹ Jesús cøng² barco. Ca¹gú²dsa. Ca¹túgh² dsa² jue¹² chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jøng² ma¹dsio¹² jǿg³ ca¹heh¹ Jesús dsa² jue¹², quianh¹³ jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Jan² dsa² ca¹ŋó¹ ca¹ŋi¹séi¹ møi¹jon². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ja³ca¹séi²dsa jøng², ca¹quia¹ mih² møi¹jon² cøg¹² juu¹². Jøng² ca¹dsi¹lé² tan¹². Ca¹jiégh¹jah mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jøng² ca¹quia¹ mih² jøa³cang³, ja³tsa¹chi² ma¹dsio¹² guøh³. Mǿi² jøng² tí² ta³ca¹hii². Di³ tsa¹hieg³ guøh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jøng² mi³ca¹hian² hieg², ca¹cǿg². Jøng² ca¹lø¹quiéng¹. Di³ tsa¹mi³chi² ma¹dsio¹² jmó³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jøng² ca¹quia¹ mih² møi¹jon² ja³tioh¹³ tang¹². Jøng² ca¹hiag² tang¹². Ca¹lø¹hmaih¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jøng² ca¹quia¹ mih² møi¹jon² ja³dsio¹. Ca¹hii². Ca¹cuø¹ mǿi². Ca²dsieg³ ca¹cuø¹ ma¹cøng² ŋi²lǿg² mǿi² cøng² møi¹jon². Ca²dsieg³ ma²to¹lu¹guí² rø²dsǿ² guie¹ mǿi². Ca²dsieg³ ma²gui²guí² mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ju³ hein² dsa² lé² nang¹ ju³neng¹³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jøng² ca¹dsi¹lé² dsa² quianh¹³ Jesús ni³dsa. Ca¹juúh²dsa: ―¿He² løa¹ juaih¹²hning dsa² jǿg³ ti³jnøa¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jøng² ca¹juúh² Jesús: ―Hniah¹² báh³ dsa² li¹ŋih³ jǿg³ ti³jnøa¹² ha²lah lé² ja³jmo¹² Diú¹³ héh¹. Tsa¹li¹ŋi¹² dsa² jue¹² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Di³ li¹ŋi¹² ma¹dsio¹² báh³ dsa², ju³lah dsa² ma²ŋi¹². Jøng² ju³lah dsa² tsa¹cán² hí³ jǿg³, dsa¹hén² báh³ jǿg³ hi² ma²ŋi¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hi² jøng² báh³ juǿi²jni dsa² jue¹² jǿg³ ti³jnøa¹². Di³ lán¹²dsa dsa² ti³jái¹². Tiogh³dsa ca¹lah¹jan² dsa² ha¹chi² ca¹jái¹. Lán¹²dsa dsa² ti³nang¹². Tiogh³dsa ca¹lah¹jan² dsa² ha¹chi² ca¹nǿng². Dsa² héi² tiogh³ ca¹lah¹cøng² hi² tsa¹ca¹lø¹ŋë́²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hi² jøng² ca¹lø¹ti¹ jǿg³ quiah¹² dsa² héi², ju³lah lǿa¹² jǿg³ la² ca¹juúh² hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: Tsa¹li¹ŋë́² dsa² he² hi² nang¹dsa. Tsa¹li¹lih¹³dsa he² hi² jái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma²ca¹lø¹húh¹ dsi³dsa. Di³ jøng² tsa¹li¹ŋë́²dsa. Ma²ca¹løa¹ tsa¹niúh² guø³dsa. Di³ jøng² tsa¹nang¹dsa jǿg³. Ma²ca¹hméh¹ mø³ni³dsa. Di³ jøng² tsa¹li¹lih¹³dsa. Di³ jøng² tsa¹jéinh¹ dsǿa¹²dsa. Jøng² tsa¹mi³hliú³jni dsa², ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jøng² ca¹juúh² Jesús calah, ca¹tsáih¹dsa dsa² quianh³dsa: ―Hioh¹² jénh² báh³ hniah¹². Di³ ma²ca¹lø¹leh¹³ hniah¹². Ma²ca¹lø¹ŋë́h² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lah¹dsóh² juǿi²jni hniah¹². Jue¹² dsa² mi³chian² ma²ca¹lø¹hniu¹ jái¹ hi² ma²ca¹jaih³ hniah¹², ju³lah dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ quianh¹³ jue¹² dsa² dsiog¹. Ha¹chi² ca¹jái¹dsa. Mi³hniu¹dsa nang¹dsa hi² ma²ca¹nengh² hniah¹². Cónh¹jøng² ha¹chi² ca¹nǿng²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Neng² di³ hniah¹² he² hniu¹dsa juúh²dsa jǿg³ ti³jnøa¹² quiah¹² dsa² ca¹séi² møi¹jon². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lǿa¹² quiah¹² dsa² tsa¹ca¹lø¹ŋë́² jǿg³ ma²ca¹nǿng²dsa quiah¹² ja³jmo¹² Diú¹³ héh¹, ju³lah lǿa¹² quiah¹² møi¹jon² ca¹quia¹ cøg¹² juu¹². Dsø¹juu¹² jøng² báh³ já¹² dsa² hlanh³. Jŋíh² dsa² hlanh³ jǿg³ ma²ca¹nǿng²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jøng² lǿa¹² quiah¹² dsa² ca¹hie¹ jǿg³ ca¹lah¹hiu³ dsǿa¹²dsa mi³ca¹nǿng²dsa jǿg³ ju³lah lǿa¹² quiah¹² møi¹jon² ca¹quia¹ ja³tioh¹³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsa¹tiúh¹dsa hi² uú². Di³ hi² tsa¹chinh¹²dsa tí² jǿg³. Dsø¹juu¹² jøng² tiáh¹ dsǿa¹²dsa ju³ná³ he² jmø³uai¹² ca¹já¹, ho¹ ju³ ca¹jmógh² dsa² huu¹³ hi² hé²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jøng² chian² dsa² lán¹² ju³lah lǿa¹² møi¹jon² ca¹quia¹ jøa³ ja³tioh¹³ tang¹². Lah¹ni² nang¹²dsa jǿg³. Jøng² chian²dsa ju²hí³ dsøa¹² jǿg³ quiah¹² jmøi¹guǿi¹ la², ha²lah jmo¹dsa li¹chi² ma¹dsio¹² quiah¹²dsa, ha²lah túgh²dsa dsio¹. Hi² jøng² tsa¹dsø¹cón³ jǿg³ quiah¹² Diú¹³ ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jøng² chian² dsa² lán¹² ju³lah lǿa¹² møi¹jon² ca¹quia¹ huø¹ dsio¹. Dsa² héi² ŋë́² jǿg³ ma²ca¹nǿng²dsa. Dsa¹jon¹ jǿg³ ja³cog²dsa. Ma¹cøng² ŋi²lǿg², ma¹to¹lu¹guí² rø²dsǿ² guie¹, ma¹gui²guí². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jøng² ca¹jmo¹ Jesús jin³ cøng² jǿg³ ti³jnøa¹², ca¹tsáih¹dsa dsa² jue¹². Ca¹juúh²dsa: ―Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan² dsa² ca¹séi² møi¹jon² cuøi² hi³ŋíh¹ dsio¹ dsieg² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jøng² mi³ma²rø²güé¹dsa, ca¹hí¹ jan² dsa² hiag¹³ jøa³ cuøi² quiah¹²dsa. Ca¹séi² dsa² hiag¹³ héi² møi¹jon² nung² hlaih¹³ jøa³ ja³ca¹séi²dsa cuøi² hi³ŋíh¹ dsio¹ jøng². Jøng² ca¹ŋáh¹ dsa² hiag¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mi³ca¹ŋi¹cón³ cuøi² hi³ŋíh¹, ca¹tóh² hmǿh². Jøng² ca¹hii² calah nung² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jøng² ca¹dsi¹lé² dsa² jmo¹² ta³ ni³ juu¹³dsa. Ca¹juúh²dsa: “Ha²lah dsio¹ ca¹hii² nung² hlaih¹³ jøa³ cuøi² hi³ŋíh¹. ¿Tsa³ca¹séih²hning møi¹jon² dsio¹ dsieg² quianh²hning?” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jøng² ca¹juúh² juu¹³ huø¹: “Dsa² hiag¹³ ma²ca¹jmo¹ lah¹jøng²,” ca¹juúh²dsa. Jøng² ca¹ŋai¹ dsa² jmo¹² ta³: “¿Hnøngh³hning hi² dsǿg³ jnieh³ hi² dsø³guíg³ jnieh³ nung² hlaih¹³?” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jøng² ca¹juúh² juu¹³ huø¹: “Ha¹chi². Di³ guíg¹ cuøi² hi³ŋíh¹ dsio¹ ju³ná³ hi² gǿih³ hniah¹² nung² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ju³dsi³cón³ cu²dsie¹² ca¹lah¹ja³ca¹lø¹lé². Ni³ jøng² ma²tsë́²jni dsa² dsø¹jmó² ta³ hi dsø¹jiegh¹dsa nung² hlaih¹³ ni³jiá¹. Jøng² cøn¹dsa ma¹cøng² hiu³ gug²dsa. Jøng² jøn¹dsa. Jøng² jín³ ma²tóh²dsa mǿi² dsio¹ niúh¹ hniú¹²,” ca¹juúh²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jøng² ca¹juúh² Jesús jín³ cøng² jǿg³ ti³jnøa¹² la²: ―Lah¹jøng² báh³ lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² møi¹jon² mostaza ca¹séi² jan² dsa² jøa³ dsieg² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Píh³ báh³ møi¹jon² jøng² cónh¹ ja³ca¹lah¹jǿ¹ ni³ møi¹jon² siíh² chi² jmøi¹guǿi¹. Jøng² hiug¹² jín³ dsa²juøh¹² chiúh³ mostaza cónh¹ jín³ ja³ca¹lah¹jǿ¹ ni³ janh¹² siíh². Lǿ² ju³lah con¹ cøng² hma² juøh¹². Jøng² tóh² jáh² ŋi²nio³ guiuh¹³ tsai³ jøa³ guh¹² hma² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jø¹² bíh³ ca¹jmo¹ Jesús calah jín³ cøng² jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² chiúh³ hi³ŋíh¹ ca¹guian¹ jan² hio¹³ quianh¹³ guieg²hŋí² kilo juu³ ca¹lah¹ja³ca¹rǿng² ta³cøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Quianh¹³ jǿg³ ti³jnøa¹² lah¹jøng² ca¹tsáih¹ Jesús dsa² jue¹². Ha¹chi² ca¹nií¹dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lah¹jøng² ca¹jmo¹ Jesús mi³jøng² li¹ti¹ jǿg³ la² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³: Hløah³jni quianh¹³ jǿg³ ti³jnøa¹². Juøh¹³jni jǿg³ hi² ha¹chian² hi² ŋi¹² ca¹lah¹cónh¹ jmai³ lah¹ni² ca¹niu¹ jmøi¹guǿi¹, ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jøng² ca¹tiúg² Jesús dsa² jue¹². Ca¹hí¹dsa dsi²néi². Ja³jøng² ca¹ŋi¹lé² dsa² quianh¹³dsa cøg¹² ja³guǿ¹³dsa. Jøng² ca¹juúh² dsa² héi²: ―Heh¹³hning jnieh³ he² hniu¹dsa juúh²dsa jǿg³ ti³jnøa¹² quiah¹² møi¹jon² hlaih¹³ ca¹séi²dsa jøa³ nung² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jøng² ca¹juúh² Jesús: ―Lán¹² dsa² ca¹séi² mǿi² dsio¹ ju³lah lán¹² jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lǿa¹² jøa³nung² quiah¹²dsa ju³lah lǿa¹² jmøi¹guǿi¹. Lǿa¹² møi¹jon² dsio¹ ju³lah lán¹² dsa² quián¹² Diú¹³. Lǿa¹² møi¹jon² hlaih¹³ ju³lah lán¹² dsa² quián¹² dsa² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lán¹² dsa² hiag¹³, dsa² ca¹séi² mǿi² hlaih¹³, ju³lah lán¹² dsa² hlanh³ hŋiah¹². Lǿa¹² jmai³ ja³jiégh¹dsa ju³lah lǿa¹² ja³ca¹tóh² jø² jmai³ quiah¹² jmøi¹guǿi¹. Dsa² jmo¹ ta³ jøng² lán¹² ju³lah lán¹² ángeles quián¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ju³lah jiégh²dsa chiúh³ nung² hlaih¹³, jøng² tóh¹dsa si² hi² jøn¹dsa, lah¹jøng² báh³ lé² na³ma²ca¹tóh² jø² jmai³ quiah¹² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jmai³ jøng² tsë́³jni ángeles, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Ji¹tiogh¹² ángeles loh² dsa² jmøi¹guǿi¹ ca¹jmo¹ ca¹tiáh¹ roh¹³dsa dsag³, quianh¹³ ca¹lah¹já¹ dsa² ca¹jmo¹ hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jøng² dsiánh² ángeles dsa² héi² juu¹² dsi²si², ja³dsø¹tø² dsø¹hǿg²dsa, ja³cán²dsa ma¹dsio¹² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jøng² ju³lah dsa² jmo¹² he² hi² juúh² Diú¹³, jláh³ báh³ lé² quiah¹² dsa² héi² ja³jmo¹² Jmi² jniang³ héh¹ ju³lah jláh³ hieg². Hein² dsa² lé² nang¹ ju³neng¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² cøng² hi² dsio¹ rø²quie¹² cøng² huø¹ ja³quiunh³. Jøng² ca¹dsóh² jan² dsa² hi² dsio¹ jøng². Ca¹hma¹dsa. Jøng² hioh¹² jenh¹²dsa ca¹ŋáh¹dsa. Ca¹hnai¹dsa ca¹lah¹jǿ¹ hi² chi² quiah¹². Mi³jøng² ca¹lá¹dsa huø¹ ja³rø²hma¹ hi² dsio¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Jø¹² bíh³ lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan² dsa² hno¹² mǿi² jláh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jøng² mi³ca¹dsóh²dsa cøng² mǿi² ma¹dsio¹² cog³ quien¹², ca¹ŋi³hnǿi³dsa ca¹lah¹jǿ¹ hi² mi³chi² quiah¹²dsa. Mi³jøng² ca¹lá¹dsa mǿi² jláh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Jø¹² bíh³ lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² ja³ca¹tsih¹dsa néng³ dsi²jmøi². Jøng² ca¹lǿh²dsa ca¹lah¹hei¹ ni³ jáh² tiogh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jøng² mi³ca¹cangh¹² néng³, jøng² ca¹lí¹dsa ca¹tǿ² ja³quing². Ja³jøng² ca¹túgh²dsa. Ca¹togh¹²dsa jáh² dsiog¹ niúh¹ møh². Ca¹guiah¹dsa jáh² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lah¹jøng² báh³ lé² ja³tiúh¹ jø² jmai³. Ji¹lé² ángeles. Ji¹tiogh¹²dsa ma¹quién¹ dsa² hlanh³ quianh¹³ dsa² dsiog¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jøng² dsiánh²dsa dsa² hlanh³ juu¹² dsi²si², ja³dsø¹tø² dsø¹hǿg²dsa, ja³cán²dsa ma¹dsio¹² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jøng² ca¹ŋai¹ Jesús dsa² quianh¹³dsa: ―¿Ŋë́h³ hniah¹² ca¹lah¹jǿ¹ jǿg³ ma²na²juúh¹jni? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Ŋë́² báh³ jnieh³ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jøng² ca¹juúh² Jesús: ―Ju³ná³ jan² tøa¹² he¹² lei¹³ quiah¹² Diú¹³ ca¹mi¹tan¹² ha²lah lǿa¹² jǿg³ quiah¹² ja³jmo¹² Diú¹³ héh¹, jøng² ma²lán¹²dsa ju³lah jan² dsa² hniu³ ma²chi² hi² dsio¹ quiah¹², cu¹dsie¹² hi² hmë́² quianh¹³ hi² hóg¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mi³ca¹jŋi¹ Jesús cuø¹²dsa jǿg³ ti³jnøa¹², ca¹u¹hái¹dsa ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ca¹ŋáh¹dsa juu¹² jøa³juøi² go²dsa. Ja³jøng³ ca¹heh¹dsa dsa² jǿg³ dsi²néi² guøh¹². Jøng² ca¹lah¹dsogh¹² hlaih¹³ dsǿa¹² dsa² tiogh³ ja³jøng². Ca¹dsii¹ dsa² héi² jǿg³ cu³guiog¹³dsa. Ca¹juúh²dsa: ―¿Ha² tøah¹ ca¹mi¹tan¹² dsa² ná¹² jǿg³ ma¹dsio¹² hi² ŋi¹²dsa? ¿Ha²lah të²dsa jmo¹²dsa juu¹² juøh¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Tsa³lán¹² dsa² ná¹² ja³ŋiúh³ tøa¹² hmá¹? Lán¹² María mi³chiég³dsa. Lán¹² Jacobo quianh¹³ José quianh¹³ Simón quianh¹³ Judas roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tiogh³ hio¹³ roh¹³dsa ja³la² quianh¹³ jniang³. ¿Ha² tøah¹ ca¹mi¹tan¹²dsa ca¹lah¹jǿ¹ lah¹jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jøng² ca¹lø¹hioh¹dsa quiah¹² Jesús. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ca¹lah¹já¹ báh³ dsa² jmo¹² juanh¹² dsa² hǿ² jǿg³ quiah¹² Diú¹³. Jmáh¹lah dsa² go²dsa tsa¹jmo¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hi² jøng² ha¹chi² ma¹dsio¹² juu¹² juøh¹² ca¹jmo¹ Jesús ja³jøng². Di³ tsa¹ca¹hé¹ dsa² go²dsa jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jmai³ jøng² mi³lán¹³ Herodes ta³ huø¹ ja³tén¹² Galilea. Jøng² ca¹lø¹lih¹³dsa hi² jmo¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quián¹²dsa: ―Lán¹² dsa² jnung² Juan, dsa² ca¹chiog¹ dsa² jmøi². Ma²ca¹hiog²dsa. Hi² jøng² báh³ lǿ² juu¹² juøh¹² quiah¹²dsa ―ca¹juúh² Herodes. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Di³ hŋiah¹² báh³ Herodes ca¹tse¹ dsa² ca¹ŋi³chiánh³ Juan. Ca¹hŋió²dsa. Jøng² ca¹tangh¹²dsa hni¹ŋí³. Di³ lah¹la² ma²ca¹løa¹: Ma²ca¹jian¹ Herodes hio¹³ mi³jian¹² Felipe, roh¹³dsa. Herodías mi³tsen² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jøng² ma²ca¹juúh² Juan, ca¹tsáih¹dsa Herodes: ―Tsa¹lé² janh¹³hning hio¹³ quián¹² rúh²hning ―ma²ca¹juúh²dsa. Hi² jøng² ca¹jmo¹ Herodes héh¹ hi² ca¹tanh¹²dsa Juan hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hniu¹ Herodes mi³jŋëh¹dsa Juan. Jøng² gan¹dsa dsa² jue¹². Di³ lë́² dsa² jue¹² hi² lán¹² Juan dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jøng² ca¹jmo¹ Herodes jmai³ ca¹dsóh¹dsa ji²ŋi². Jøng² ca¹hí¹ ja³mái¹³ Herodías. Ca¹jmo¹tsih jan³ ja³ta¹ni¹ dsa² tiogh³ jmai³. Jøng² ca¹tǿ² hlaih¹³ dsǿa¹² Herodes ha²lah ca¹jmo¹ tsih²mǿ² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jøng² ca¹tsáih¹dsa tsih²mǿ² hi² lah¹té¹² cuø¹dsa he² hi² møa¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jøng² ca¹jmo¹ mi³chiég³ héh¹ he² juúh² tsih²mǿ². Jøng² ca¹juúh² tsih²mǿ², ca¹tsáih¹dsa Herodes: ―Cuúh³hning dsi³ Juan, dsa² chiog¹² dsa² jmøi², niúh¹ uøin¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jøng² ca¹táh² dsǿa¹² Herodes, mi³ca¹nǿng²dsa jǿg³ jøng². Jøng² ca¹jmo¹dsa héh¹ hi² cuø¹dsa hi² ma²ca¹møa¹ tsih²mǿ². Di³ tsa¹hniu¹dsa dsa¹hén² jǿg³ ca¹tsáih¹dsa tsih²mǿ². Di³ ca¹juúh²dsa lah¹té¹² jǿg³, hi² ca¹nǿng² dsa² ti³gøah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jøng² ca¹tse¹ Herodes dsa² hi² dsa¹quiúh²dsa lag³ Juan hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jøng² ca¹can¹dsa dsi³ Juan, hiu³ niúh¹ uøin¹². Ca¹cuúh¹dsa tsih²mǿ². Jøng² ca¹jáinh¹ tsih²mǿ² quiah¹² mi³chiég³. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jøng² ca¹dsi¹lé² dsa² mi³quianh¹³ Juan. Ca¹ŋi³tei²dsa hlai³. Jøng² ca¹ŋi¹hǿg²dsa. Mi³ca¹løa¹ jøng², ca¹ŋi³tseih³dsa Jesús he² ma²ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mi³ca¹lø¹ŋi¹² Jesús jǿg³ jøng², ca¹ŋó¹dsa juu¹² barco, juu¹² ja³ha¹chian² dsa² tiogh³, juu¹² cu²hŋiah¹²dsa. Jøng² ca¹lø¹lih¹³ dsa² jue¹² juu¹² ja³ca¹ŋó¹dsa. Jøng² ca¹u¹hái¹dsa juøi² ja³tiogh³dsa. Ca¹ŋi¹lé²dsa juu¹² tai³. Ca¹ŋi¹hniah¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jøng² mi³ca¹u¹hái¹ Jesús niúh¹ barco, ca¹jë́²dsa jue¹² hlaih¹³ dsa² ma²tiogh³. Jøng² ca¹ŋi¹ŋiú² dsǿa¹²dsa quiah¹² dsa² héi². Ca¹mi¹hliú²dsa dsa² ti³dsoh¹ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mi³ca¹tǿ² ja³ca¹hlég² jøng², ca¹ŋi¹lé² dsa² quianh¹³ Jesús ja³tsenh¹³dsa. Ca¹juúh²dsa: ―Ca¹hlég². Jin³ hein² dsa² ha¹chian² tiogh³ ja³la². Dsianh¹³hning dsa² jue¹². Mi³jøng² dsø¹lé²dsa ja³tioh¹³ juøi² lah¹cónh¹ cøg¹². Jøng² dsø¹lii¹²dsa hi² gǿh¹dsa ―ca¹juúh² dsa² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jøng² ca¹juúh² Jesús: ―Ha¹chi² hniuh¹² dsø¹lé²dsa. Hniah¹² báh³ cuúh³ hi² gǿh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jøng² ca¹juúh² dsa² quianh¹³ Jesús: ―Jmáh¹lah hŋí² hi³ŋíh¹ quin³ jniang³ quianh¹³ og¹ jáh² tiogh³ jmøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jøng² ca¹juúh² Jesús: ―Gu³quinh³ hi³ŋíh¹ quianh¹³ jáh² ja³la² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jøng² ca¹jmo¹ Jesús héh¹ hi² ca¹túgh² dsa² jue¹² ni³ ŋi²mah². Jøng² ca¹can¹ Jesús hŋí² hi³ŋíh¹ jøng², quianh¹³ og¹ jáh² tiogh³ jmøi² héi². Ca¹jái¹dsa guiuh¹³. Ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³ hi³ŋíh¹. Ca¹cuúh¹dsa dsa² quianh¹³dsa, hi² ca¹dsiúh¹dsa. Jø¹² bíh³ ca¹dsiúh¹dsa quiah¹² jáh². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ca¹gǿh¹ ca¹lah¹já¹ dsa² tiogh³. Ca¹lø¹ta¹³dsa. Jøng² ca¹mi¹cángh² dsa² quianh¹³ Jesús guie¹tǿn² møh²tá³, jmáh¹lah jneh³ hi³ŋíh¹ quianh¹³ jáh², hi² ca¹chiág¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dsa² ca¹gǿh¹ mi³lǿ² hŋí² mei¹³ jmáh¹lah dsa² ŋioh¹². Jøng² ca¹gǿh¹ jue¹² hio¹³ calah ca¹lah¹quianh¹³ guing². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jøng² ca¹jmo¹ Jesús héh¹ hi² ca¹túgh² dsa² quianh¹³dsa niúh¹ barco. Dsø¹jian¹dsa hŋoh¹³ jmøi² ca²ton², ta³lah¹jøng² dsianh¹² Jesús dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jøng² mi³ca¹dsiánh²dsa dsa², ca¹ŋó¹ Jesús máh². Ca¹ŋi¹hlanh¹dsa Diú¹³ cu³hŋiah¹². Mi³ca¹neng², ma²tsenh¹² Jesús cu³hŋiah¹² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma²hiu³ barco dsi²jo² jmøi². Ma²tsøg² jmøi². Di³ ca¹já¹ dsí² tí² ni³ ja³dság¹² barco. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jøng² ta¹lah¹ja³jni¹ ca¹ŋó¹ Jesús ja³tiogh³ dsa² quianh¹³dsa. Ca¹ŋøa¹dsa ni³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ca¹lø¹goh¹² dsa² quianh¹³dsa mi³ca¹jǿi²dsa hi² dság¹²dsa juu¹² ni³ jmøi². Jøng² ca¹juúh² dsa² héi²: ―¡Ŋøa¹² jan² dsa gu²dsí²! ―ca¹juúh²dsa. Jøng² ca¹tø² ca¹ho¹dsa tí². Di³ hi² goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dsø¹juu¹² jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―¡Tsa¹juéh² hniah¹²! ¡Jní² báh³ lang¹²! ¡Tsa¹jmóh³ hniah¹² ganh¹! ");
INSERT INTO cpaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jøng² ca¹juúh² Pedro: ―Juu¹³ jniang³, ju³ná³ hning² báh³ ná¹², jmóh³hning héh¹ hi² nei¹³jni juu¹² ni³ jmøi². Mi³jøng² dsiég¹³jni ca¹tǿ² ja³tsenh¹³hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jøng² ca¹juúh² Jesús: ―Ŋi² ja³la². Jøng² ca¹siog² Pedro ni³ barco. Ca¹ŋøa¹dsa ni³ jmøi². Ca¹ŋó¹dsa juu¹² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mi³ca¹lø¹lih¹³ Pedro tí² hlaih¹³ dsí² dság¹², jøng² ca¹lø¹goh¹²dsa. Ca¹lø¹liág¹ ma²dsø²honh¹²dsa niúh¹ jmǿi¹. Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Liag³ jní², Juu¹³ jniang³! ");
INSERT INTO cpaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ca¹lah¹dsø¹juu¹² jøng² ca¹chính² Jesús gug²dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Pedro: ―¿He³ báh³ ja¹lái¹ héh²hning jǿg³ quieg¹jni? ¿He² løa¹ tsa¹cøng² neng¹² hoh¹²hning héh²hning jǿg³ quieg¹jni? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jøng² mi³ca¹uǿi²dsa ni³ barco, ca¹jŋi¹ dsí². ");
INSERT INTO cpaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jøng² ca¹chi¹jné¹ ca¹lah¹já¹ dsa² tiogh³ niúh¹ barco ni³ Jesús. Ca¹mi¹juanh¹²dsa Jesús. Ca¹juúh²dsa: ―Lah¹té¹² jǿg³ hi² lanh¹²hning jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jøng² ca¹dsi¹lé²dsa hŋoh¹³ jmøi² ca²ton², huø¹ ja³tén¹² Genesaret. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mi³ca¹lø¹cue¹² dsa² tiogh³ ja³jøng² Jesús, ca¹jmo¹dsa jǿg³ ca¹lah¹tan¹³ ja³tén¹² huø¹ jøng². Jøng² ca¹ŋi³jian¹dsa ca¹lah¹já¹ dsa² dsoh³ ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jøng² ca¹møa¹dsa Jesús chi²júh² lé² láh² dsa² dsoh³ ca¹lah¹cónh¹ hé¹ tsǿnh³dsa. Jøng² ca¹cuø¹ Jesús jǿg³. Jøng² ca¹hlú² ca¹lah¹já¹ dsa² mi³dsoh³ ca¹láh² hé¹ tsǿnh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jøng² ca¹dsi¹lé² ca²dsiog³ dsa² fariseo chian² jøa³juøi² Jerusalén quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³ ja³tsenh¹³ Jesús. Ca¹ŋǿh¹dsa Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿He² løa¹ tsa¹mi¹ti¹ dsa² quiánh²hning jǿg³ quiah¹² dsa² hóg¹ quián² jniang³? Tsa¹rang¹²dsa gug²dsa niúh¹ jín³ hi² gǿh¹dsa ju³lah lǿa¹² mai³¹ ma²ca¹já¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ tsa¹mi³tih³ hniah¹² cónh¹ lǿa¹² héh¹ ca¹jmo¹ Diú¹³? Mi³tih³ hniah¹² jmáh¹lah mai³¹ quiah¹² dsa² hóg¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Lah¹la² báh³ juúh² Diú¹³: “Mi³juanh¹³ hniah¹² chiégh² ŋieih¹² hniah¹². ¡Ju³jón³ dsa² hløah¹² jǿg³ hlaih¹³ quiah¹² chiég³ jmi²dsa!” juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jøng² juúh² hniah¹²: Lé² báh³ tsáih¹dsa chiég³ jmi²dsa hi² tsa¹lé² cuø¹dsa hi² mi³cuø¹dsa. Di³ la³ma²ca¹cuúh¹dsa Diú¹³. Hi² jøng² juúh² hniah¹² tsa¹hniuh¹² mi²hóg¹³ dsa² héi², dsa² ca¹tsáih¹ lah¹jøng² chiég³ jmi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hi² jøng² jmoh² hniah¹² tsa¹quien¹² jǿg³ quiah¹² Diú¹³ hi² jmoh² hniah¹² mai³¹ hi² quinh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dsa² tø²cah¹ tø²jen¹² báh³ hniah¹². Jǿg³ té¹² ca¹juúh² hlai³ Isaías mi³ca¹hia¹dsa hniah¹² jǿg³ la²: ");
INSERT INTO cpaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jǿg³ dsio¹ báh³ tsáih¹dsa jní², juúh² Diú¹³. Di³ ha¹chi² dsø²jiag¹² dsǿa¹²dsa jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jøng² ha¹chi² quien¹² hi² hlaih¹²dsa jní². Jǿg³ quiah¹² Diú¹³ báh³ he¹²dsa, juúh²dsa. Cónh¹jøng² jǿg³ ca¹jmo¹ dsa² jmøi¹guǿi¹ báh³ jøng², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jøng² ca¹tǿh¹ Jesús dsa² jue¹². Ca¹juúh²dsa: ―¡Neng² jǿg³ quieg¹ jní²! ¡Ju³li¹ŋih³ hniah¹² jǿg³! ");
INSERT INTO cpaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ha¹chi² chi² hi² gǿh¹ dsa² jmøi¹guǿi¹ hi² jmo¹ tsa¹ti³ja¹dsa ja³cog² Diú¹³. Jǿg³ hi² juúh²dsa báh³ jmo¹² tsa¹ti³ja¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jøng² ca¹ŋi¹lé² dsa² quianh¹³ Jesús ja³tsenh¹³dsa. Ca¹juúh²dsa: ―¿Ma³ŋih³hning ca¹can¹ dsa² fariseo ju²méh³ dsøa¹² mi³ca¹juøh³hning lah¹jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jøng² ca¹juúh² Jesús: ―Ju³lah jan² dsa² gǿi¹ høg² nung², dsa¹hén² báh³ ca¹lah¹jǿ¹ jǿg³ quiah¹² dsa² tsa¹quián¹² ti³ŋieh¹jni, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tsa¹tónh²hning juu¹² dsa² fariseo héi². Di³ lán¹²dsa ju³lah lán¹² dsa² teg³, dsa² he¹² juu¹² quiah¹² dsa² teg³ jian¹²dsa. Ju³ná³ heh¹² jan² dsa² teg³ dsa² teg³ jian¹²dsa juu¹², jøng² cu²dsie¹² siúgh²dsa tsøi² ta³og¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Tseih³ jnieh³ he² hniu¹dsa juúh²dsa jǿg³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jøng² ca¹juúh² Jesús: ―¡Ha²lah dsio¹ tsa¹ŋë́h² hniah¹² calah! ");
INSERT INTO cpaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tsa³ŋë́h² hniah¹² ca¹lah¹jǿ¹ hi² gǿh¹dsa dsø¹lé² juu¹² togh¹²dsa? Hi² tag¹² báh³ dsa² hi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jøng² ju³lah jǿg³ huøh¹² hag³dsa ja²lé² juu¹² jmi²dsí² quiah¹²dsa. Jǿg³ jøng² báh³ hi² jmo¹² tsa¹ti³ja¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Di³ jmi²dsí² quiah¹² báh³ dsa² jmo¹² hi² dsø²jiag¹² dsǿa¹²dsa hi² hlaih¹³, hi² jŋëh¹dsa dsa², ho¹ ju³ hi² dsii¹dsa jǿg³ quianh¹³ hio¹³ ma²jian¹² dsa² siáh², ho¹ ju³ hio¹³ tsa¹ma²jenh² gug², ho¹ ju³ hi² jmo¹dsa høin², ho¹ ju³ ta³júg³dsa, ho¹ ju³ hi² quián¹dsa dsa² jǿg³ hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hi² dsø²jiag¹² dsǿa¹²dsa jøng² báh³ jmo¹² tsa¹ti³ja¹dsa. Di³ ha¹chi² jmo¹ tsa¹ti³ja¹dsa ju³ná³ ca¹gǿh¹dsa hi² tsa¹ma²na²rang¹dsa gug² cónh¹ lǿa¹² mai³¹ quiah¹² dsa² hóg¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jøng² ca¹u¹hái¹ Jesús ja³jøng². Ca¹ŋó¹dsa juu¹² huø¹ cøg¹² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jøng² ca¹dsiég¹ jan² hio¹³ chian² Canaán ni³ ja³tsenh¹³ Jesús. Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Guiuh¹³, tsø³jong¹³ hlai³ David, ju³dsi³ŋiú³ hoh¹²hning quianh¹³ jní²! Quin¹² ja³mái¹jni jmi²dsí² hlaih¹³. Hiug¹² chian²dsa jmø³uai¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ha¹chi² ca¹ŋai¹ Jesús ca¹lah¹jin³ he². Jøng² ca¹juúh² dsa² quianh¹³ Jesús: ―Dsianh¹³hning hio¹³. Di³ tí² ho¹²dsa. Dse¹³dsa cah³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Ca¹tsei¹ Diú¹³ jní² quiah¹² dsa² israel, dsa² lán¹² ju³lah lán² jah¹chih² ma²ca¹ŋi¹cógh² juu¹². Dsa² siáh² báh³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jøng² ca¹ŋó¹ hio¹³. Ca¹chi¹jné¹dsa ja³ta¹ni¹ Jesús. Ca¹juúh²dsa: ―¡Mi³hag³ jní², Guiuh¹³! ");
INSERT INTO cpaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jøng² ca¹juúh² Jesús: ―Tsa¹dsio¹ cang¹dsa má¹ mi³gǿh¹ guing², cuúh¹dsa dsøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jøng² ca¹juúh² hio¹³ calah: ―Lǿa¹² báh³ lah¹jøng², Guiuh¹³. Juúh² báh³ dsa² israel hi² lán¹² jnieh³ ju³lah lán¹² dsøi². Di³ ca¹tǿ² dsøi² báh³ gǿh¹ ti³jneh³ quia¹² ni³ mesa quiah¹² juu¹³ dsøi² ―ca¹juúh² hio¹³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³ héi²: ―Lah¹dsóh² tí² chinh³hning jǿg³ quieg¹jni. Lé² báh³ ca¹lah¹jǿ¹ hi² hnøngh²hning ―ca¹juúh²dsa. Ca¹lah¹dsø¹juu¹² jøng² ca¹hlú² ja³mái¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ca¹u¹hái¹ Jesús ja³jøng². Jøng² ca¹ŋó¹dsa juu¹² chiuh³ jmøi² Galilea. Jøng² ca¹uǿi²dsa cøng² máh². Ja³jøng² ca¹gú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jøng² ca¹dsi¹lé² dsa² jue¹² ja³guǿ¹³dsa. Ca¹ŋi¹jian¹dsa dsa² tsa¹li¹ŋøa¹, quianh¹³ dsa² bong¹³, quianh¹³ dsa² teg³, quianh¹³ dsa² cag³, quianh¹³ jue¹²dsa ti³dsoh¹. Ca¹dsii¹dsa juu¹² gug² tai³ Jesús. Jøng² ca¹mi¹hliú²dsa dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jøng² ca¹can¹ dsa² jue¹² gøg² mi³ca¹jái¹dsa ma²hløah¹² dsa² mi³cag³, ca¹hlú² dsa² mi³bong¹³, ca¹ŋøa¹ dsa² tsa¹mi³lé² ŋøa¹, ma²jniuh¹² dsa² mi³teg³. Jøng² ca¹mi¹juanh¹² dsa² jue¹² Diú¹³ quián¹² dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jøng² ca¹tǿh¹ Jesús dsa² quianh¹³dsa. Ca¹juúh²dsa: ―Dsø²ŋiú² dsøa¹jni quiah¹² dsa² jue¹². Di³ ma²hnøa¹² jmai³ tiogh³dsa quianh¹³ jní². Jøng² tsa¹ma¹chi² hi² li¹gǿh¹dsa. Tsa¹hno¹jni dsianh¹³jni dsa² hi² tsa¹ma²na²gǿh¹dsa ju³ jmai³ tsa¹tiúh¹dsa dsi³lia¹dsa ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jøng² ca¹ŋai¹ dsa² quianh¹³dsa. Ca¹juúh²dsa: ―¿Ha² bíh³ lah¹lé² jniuh¹ jniang³ hi² gǿh¹ dsa² jue¹² ja³la², ja³tsa¹chian² dsa² tiogh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jøng² ca¹juúh² Jesús: ―¿Ha²cónh¹ hi³ŋíh¹ quinh³ hniah¹²? Jøng² ca¹juúh² dsa² quianh¹³dsa: ―Guio¹ hi³ŋíh¹ quin³ jnieh³, quianh¹³ jan² og¹ jáh² píh³ tiogh³ jmøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jøng² ca¹tsáih¹ Jesús dsa² jue¹² hi² tógh¹dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jøng² ca¹can¹dsa guio¹ hi³ŋíh¹ jøng² quianh¹³ jáh². Ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³. Ca¹cuúh¹dsa dsa² quianh¹³dsa hi² dsiúh¹dsa. Jøng² ca¹dsiúh¹dsa quianh¹³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jøng² ca¹gǿh¹ ca¹lah¹já¹dsa. Ca¹lø¹ta¹³dsa. Jøng² ca¹chiág¹ guio¹ møh²tá³ jneh³ hi³ŋíh¹ quianh¹³ jneh³ jáh². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ca¹lah¹cónh¹ quiún² mei¹³ dsa² ca¹gǿh¹, jmáh¹lah dsa² ŋioh¹². Jøng ca¹gǿh¹ jue¹² hio¹³ calah, ca¹lah¹quianh¹³ guing². ");
INSERT INTO cpaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jøng² mi³ca¹dsiánh² Jesús dsa² jue¹², ca¹hí¹dsa niúh¹ barco. Jøng² ca¹ŋó¹dsa juu¹² ja³tén¹² Magadan. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jøng² ca¹dsi¹lé² ca²dsiog³ dsa² fariseo ca¹lah¹quianh¹³ dsa² saduceo. Ca¹mǿh¹dsa Jesús hi² jmo¹dsa cøng² juu¹² juøh¹² quiah¹² Diú¹³ hi² lë́²dsa chi²júh² tiúh¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jøng² ca¹juúh² Jesús: ―Juúh² hniah¹² dsio¹ lé² jmai³ hiá¹, ju³ná³ jáih² hniah¹² hi² ma²jní² guiéng² guiuh¹³ dsi³guøi² na³ma²ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jøng² juúh² hniah¹² jií¹ jmǿa¹² ju³ná³ jáih² hniah¹² hi² ma²guiéng² guiuh¹³ dsi³guøi² tu¹heg² ŋia² hi² tioh¹³ jneng¹². Ma²ŋih³ hniah¹² ha²lah lǿa¹² guiuh¹³ dsi³guøi². Cónh¹jøng² tsa¹ŋih³ hniah¹² he² hi² ma²dsø²ŋë́h² hniah¹² guiogh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dsa² hlanh³ báh³ hniah¹². Héi¹ dsa² hnio¹ Diú¹³, dsa² møa¹² juu¹² juøh¹². Jmáh¹lah cøng² juu¹² juøh¹² jøng² báh³ jmo³jni quianh¹³ hniah¹², ju³lah ca¹løa¹ quiah¹² hlai³ Jonás ―ca¹juúh² Jesús. Jøng² ca¹tiúg² Jesús dsa² héi². Ca¹ŋó¹dsa ja³siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mi³ca¹dsi¹lé² Jesús quianh¹³ dsa² quianh¹³dsa ca²ton² jmøi², ca¹dságh¹ dsǿa¹² dsa² quianh¹³dsa ha¹chi² hi³ŋíh¹ quin¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jmóh³ hniah¹² hí³ chiúh³ hi³ŋíh¹ quiah¹² dsa² fariseo quianh¹³ chiúh³ hi³ŋíh¹ quiah¹² dsa² saduceo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jøng² ca¹dsii¹ dsa² quianh¹³dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―Lah¹jøng² juúh²dsa. Di³ tsa¹quin³ jniang³ hi³ŋíh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jøng² ca¹lø¹lih¹³ Jesús jǿg³ ca¹dsii¹ dsa² héi². Jøng² ca¹juúh² Jesús: ―Lanh¹² hniah¹² dsa² ja¹lái¹ hé² jǿg³ quieg¹jni. ¿He² løa¹ dsiih² hniah¹² jǿg³ hi² tsa¹quinh³ hniah¹² hi³ŋíh¹? ");
INSERT INTO cpaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tsa³ma²ŋë́h² hniah¹²? ¿Tsa³dságh² hoh¹² hniah¹² jmai³ ca¹dsioh¹jni hŋí² hi³ŋíh¹ quianh¹³ hŋí² mei¹³ dsa² ŋioh¹²? ¿Tsa³dságh² hoh¹² ha²cónh¹ møh²tá³ jneh³ hi³ŋíh¹ ca¹chiág¹? ");
INSERT INTO cpaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tsa³dságh² hoh¹² hniah¹² jmai³ ca¹dsioh¹jni guio¹ hi³ŋíh¹ quianh¹³ quiún² mei¹³ dsa² ŋioh¹²? ¿Ha²cónh¹ møh²tá³ jneh³ hi³ŋíh¹ ca¹chiág¹ jmai³ jøng²? ");
INSERT INTO cpaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿He³ løa¹ tsa¹ŋë́h² hniah¹²? Ha¹chi² jǿg³ quiah¹² hi³ŋíh¹ jøng² ma²na²hløah¹jni. Jmóh³ hniah¹² hí² chiúh³ hi³ŋíh¹ quiah¹² dsa² fariseo ca¹lah¹quianh¹³ dsa² saduceo ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jøng² jín³ ca¹lø¹ŋë́² dsa² quianh¹³ Jesús hi² ha¹chi² ma²na²juúh²dsa jǿg³ quiah¹² chiúh³ hi² jia¹dsa quianh¹³ hi³ŋíh¹. Ma²na²juúh²dsa jǿg³ ti³jnøa¹² hi² jmo¹dsa hí³ jǿg³ tsa¹té¹², hi² he¹² dsa² fariseo ca¹lah¹quianh¹³ dsa² saduceo. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jøng² ca¹ŋó¹ Jesús juu¹² ja³tioh¹³ juøi² tén¹² Cesarea de Filipo. Ja³jøng² ca¹tsáih¹dsa dsa² quianh¹³dsa. Ca¹juúh²dsa: ―¿He² juúh² dsa² jue¹², hein² dsa² jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jøng² ca¹juúh² dsa² héi²: ―Chian² báh³ dsa² juúh² lanh¹²hning hlai³ Juan, dsa² ca¹chiog¹ dsa² jmøi². Ca²dsiog³dsa juúh² lanh¹²hning Elías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jø¹² bíh³ chian² dsa² juúh² lanh¹²hning hlai³ Jeremías, ho¹ ju³ jan² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jøng² ca¹juúh² Jesús: ―Jøng² hniah¹², ¿hein² dsa² lán¹²jni, lë́h² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jøng² ca¹juúh² Simón Pedro: ―Cristo báh³ lanh¹²hning, jong¹² Diú¹³, dsa² chian² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jøng² ca¹juúh² Jesús: ―Hioh¹² báh³ ma²jénh²hning, Simón, ja³ŋiúh³ Jonás. Héi¹ ju³ dsa² jmøi¹guǿi¹ ca¹he¹ jǿg³ ná¹². Jǿg³ ca¹he¹ Jmi² jniang³ báh³ jøng², dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jøng² lah¹la² juǿi²jni hning²: Tsenh²hning Pedro, hi² hniu¹dsa juúh²dsa cang³. Jø¹² bíh³ lǿa¹² jǿg³ ma²na²juøh³hning ju³lah lǿa¹² cang³. Quianh¹³ jǿg³ jøng² mi¹quianh¹³ Diú¹³ dsa² jue¹², ju³lah jan² dsa² tsih¹ hniú¹² ni³ cang³. Ha¹chi² hi² jenh¹³ dsa² hé² jǿg³ jøng² ju³ná³ ca¹dsan¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jøng² cuø¹³jni ta³ náh³hning juu¹² dsa¹lé² dsa² jue¹² juu¹² ja³jmo¹² Diú¹³ héh¹. Ju³ná³ he² jǿg³ cuuh²hning lé² ni³ jmøi¹guǿi¹ la², ju³ná³ he² jǿg³ tsa¹cuuh²hning calah, jø¹² bíh³ lah¹jøng² cuø¹ Diú¹³ ŋi¹juǿi¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa hi² tsa¹he¹dsa jǿg³ hi² lán¹²dsa Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jmai³ jøng² ca¹mi¹liág¹ Jesús ca¹nií¹dsa jǿg³ ja³cog² dsa² quianh¹³dsa hi² hniuh¹² dság¹dsa juu¹² jøa³juøi² Jerusalén. Jøng² hniuh¹² cán²dsa ma¹dsio¹² jmø³uai¹², hi² cuø¹ dsa² canh¹³, quianh¹³ juu¹³ jmi²dsa², ca¹lah¹quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Jøng² hniuh¹² jŋëh¹ dsa² Jesús. Jøng² hiog¹dsa ja³hnøa¹² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jøng² ca¹jian¹ Pedro Jesús tø¹cøg¹². Ca¹jé²dsa Jesús. Ca¹juúh²dsa: ―¡Tsa¹ju³lé³ lah¹jøng², Juu¹³ jniang³! Tsa¹lé² dsø¹ŋë́h²hning lah¹jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jøng² ca¹jéinh¹ Jesús. Ca¹jé²dsa Pedro: ―¡Guønh² tø¹cah¹! Jmoh²hning ju³lah jmo¹² Satanás. Cuøh¹²hning jní² ju²méh³ dsøa¹². Tsa¹lë́h²hning ju³lah lë́² Diú¹³. Lë́h²hning jmáh¹lah hi² lë́² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Ju³ná³ hein² dsa² hniu¹ dság¹dsa quianh¹³ jní², jøng² tsa¹hniuh¹² høa¹dsa dsǿa¹² jǿg³ quiah¹² hŋiah¹²dsa. Ca¹lah¹jǿ¹ jmai³ mi¹hiúg¹dsa dsǿa¹² hie¹dsa jón²dsa huu¹³ quieg¹ jní². Jøng² báh³ dság¹dsa quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Di³ ju³ná³ hein² dsa² dsø²jiag¹² dsǿa¹² jmáh¹lah jǿg³ ha²lah guú¹dsa dsio¹ ni³ jmøi¹guǿi¹ la², ha¹chi² li¹hmah¹³ quiah¹²dsa jmøi¹guǿi¹ cøng². Cónh¹jøng² ju³ná³ hein² dsa² ca¹jon¹ huu¹³ quieg¹jni, dsa² héi² li¹chian² ja³dsio¹ jmøi¹guǿi¹ cøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ha¹chi² ta³ jmo¹ lǿh² jan² dsa² ta³cøng² jmøi¹guǿi¹ ju³ná³ dsa¹hén² jmi²dsí² quiah¹²dsa. Ha¹chian² dsa² tiúh¹ quíg¹, mi³jøng² liúg² jmi²dsí² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Di³ guiogh¹³ báh³ jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Chinh³jni hma² høh³ quiah¹² ti³ŋieh¹jni. Quianh¹³jni ángeles chian² ŋi¹juǿi¹. Jøng² mi³hmah¹³jni quiah¹² lah¹jan² lah¹jan² dsa² ju³lah cónh¹ hi² ma²ca¹jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² dsiánh¹ ca²dsiogh³ hniah¹² tiogh³ ja³la² ca¹lah¹ca¹tǿ² ja³ca¹jaih³ hniah¹² mi³liág¹³jni jmo¹³jni héh¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ja³jŋiéng² jmai³ jøng² ca¹jian¹ Jesús Pedro, quianh¹³ Jacobo, quianh¹³ Juan, roh¹³ Jacobo. Ca¹jiag¹dsa cøng² máh² ŋiei¹² ja³cu³guiog¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jøng² ca¹løa¹ ti³tsë́¹³ quiah¹² Jesús ja³ta¹ni¹ dsa² héi². Jøng² ca¹jní² ni³dsa ca¹lah¹sih¹², ju³lah jniá² hieg². Ca¹lø¹teg² hlaih¹³ tsǿnh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jøng² ca¹jnia¹ hlai³ Moisés quianh¹³ hlai³ Elías. Ca¹dsii¹ dsa² héi² jǿg³ quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, dsio¹ báh³ ma²tiagh³ jniang³ ja³la². Ju³ná³ hnøngh²hning, jmo¹³jni hnøa¹² hio¹², cøng² quiánh²hning, cøng² quiah¹² hlai³ Moisés, cøng² quiah¹² hlai³ Elías. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ta³lah¹chi³hløah¹² Pedro jǿg³ jøng² ca¹jlá¹dsa ca¹lah¹já¹dsa cøng² jneng¹² teg² hlaih¹³. Jøa³jneng¹² jøng² ca¹hløah¹ Diú¹³, ca¹juúh²dsa: ―Jesús báh³ jon¹jni, dsa² hnó¹jni, dsa² tøa¹² dsøa¹jni quianh¹³. ¡Nengh² hniah¹² jǿg³ quiah¹²dsa! ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jøng² ca¹can¹ hlaih¹³ dsa² quianh¹³ Jesús gøg² mi³ca¹nǿng²dsa jǿg³ jøng². Ca¹ti¹ganh¹dsa chi³ŋiu¹³ ni³dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jøng² ca¹ŋó¹ Jesús cøg¹² quiah¹²dsa. Jøng² ca¹hlíh²dsa gug² quiah¹²dsa. Ca¹juúh²dsa: ―¡Nungh² hniah¹²! ¡Tsa¹jmóh² hniah¹² ganh¹! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jøng² ca¹ti³ ca¹li¹ dsa² héi² lah¹jin² lah¹lǿih¹. Ha¹chian² dsa² ma¹chian² quianh¹³dsa mi³ca¹jái¹dsa. Jan² Jesús báh³ tsenh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jøng² ja³siog²dsa máh², ca¹jmo¹ Jesús héh¹: ―Ha¹chian² gu³tseih³ hniah¹² jin³ hein² hi² ma²na²jaih³ hniah¹² ca¹tǿ² ja³ca¹hiog¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jøng² ca¹ŋǿh¹dsa Jesús, ca¹juúh²dsa: ―¿Hi³ dsøg¹² jiúgh² Elías ni³jiá¹ cónh¹ jín³ hi² jií¹ dsa² lég² jnieh³, ju³lah juúh² tøa¹² he¹² lei¹³ quiah¹² Diú¹³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jøng² ca¹juúh² Jesús: ―Jiúgh² báh³ Elías ni³jiá¹. Mi¹rø¹²dsa ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Di³ juǿi² báh³ jní² hniah¹²: Lah¹dsóh² ma²ca¹guønh¹ báh³ Elías. Jøng² ha¹chi² ca¹lø¹cuai¹ dsa² jue¹². Ca¹jmógh²dsa lah¹lǿ² dsǿa¹²dsa. Jø¹² bíh³ lah¹jøng² jmógh²dsa jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jøng² ca¹lø¹lih¹³ dsa² quianh¹³ Jesús mi³hia¹² Jesús hlai³ Juan, dsa² ca¹chiog¹ dsa² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mi³ca¹dsi¹lé²dsa ja³tiogh³ dsa² jue¹². Jøng² ca¹ŋó¹ jan² dsa² ŋioh¹². Ca¹chi¹jné¹dsa ni³ Jesús. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Guiuh¹³, ju³dsi³ŋiú³ hoh¹²hning ja²ŋiúh¹jni. Lán¹²tsih dsag³ jón¹ ŋié¹dsa. Hiug¹² cu¹té¹² quin¹²tsih ma¹dsio¹² jmø³uai¹². Hliú² rón² ma²ca¹ŋi¹hë¹tsih dsi²si² dsi²jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma²na²u¹jian¹jni tsih² ni³ dsa² quiánh²hning. Ha¹chi² ma²na²tiúh¹dsa mi¹hliú²dsa tsih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jøng² ca¹juúh² Jesús: ―¡He³ lah¹hiug¹²! ¿Ha² bíh³ cónh¹ jmai³ hniuh¹² hú¹³jni hi² mi³dsian¹³jni dsøa¹ quianh¹³ hniah¹², dsa² tsa¹héh² jǿg³, dsa² ŋi²nioh³ juu¹² siíh²? ¡Ŋi³jian¹²tsih ja³la²! ");
INSERT INTO cpaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jøng² ca¹jé² Jesús jmi²dsí² hlaih¹³ jmo¹² hi² dsoh³tsih. Ca¹u¹hái¹ jmi²dsí² quiah¹²tsih. Dsø¹juu¹² jøng² ca¹hlú²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ni³ jøng² ca¹ŋi¹lé² dsa² quianh¹³ Jesús cøg¹² ja³mi³tsenh¹³dsa. Ca¹ŋǿh¹dsa Jesús jǿg³ ja³cu³guiog¹³dsa. Ca¹juúh²dsa: ―¿He² løa¹ tsa¹ca¹tiúh¹ jnieh³ mi³dsí³ jnieh³ jmi²dsí² hlaih¹³ quiah¹² tsih² héi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jøng² ca¹juúh² Jesús: ―Di³ ja¹lái¹ héh² hniah¹² jǿg³ quieg¹jni. Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ héh² hniah¹² jǿg³ cónh¹ ja³té¹² ja³juøh¹² cøng² mǿi² møi¹jon² mostaza, li¹chi² bí² quiánh² hniah¹² hi² lé² juaih¹³ hniah¹² máh² jnung² hi² jŋiángh¹ máh², tø¹tsøh³ ja³siíh³. Jøng² jŋiángh¹ báh³ máh². Ha¹chi² hi² chi², hi² tsa¹tiah¹ hniah¹² jmóh³, ju³ná³ lah¹té¹² héh² hniah¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Cónh¹jøng² ha¹chian² tiúh¹ huø¹ jmi²dsí² hlaih¹³ jøng² ju³ná³ tsa¹hlanh¹dsa Diú¹³, ju³ná³ tsa¹mi¹ha¹²dsa hi² tsa¹gǿh¹dsa ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mi³ma²tiogh³ dsa² quianh¹³ Jesús cu¹dsie¹² juøi² ja³tén¹² Galilea, ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jë́h²dsa jní² ja³cog² dsa² ");
INSERT INTO cpaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","jŋaih¹ jní². Jøng² hiog¹jni ja³hnøa¹² jmai³ ―ca¹juúh²dsa. Jøng² ca¹táh² hlaih¹³ dsǿa¹² dsa² quianh¹³dsa mi³ca¹nǿng²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mi³ca¹dsi¹lia¹ Jesús quianh¹³ dsa² quianh¹³dsa jøa³juøi² Capernaum, ca¹dsi¹lé² dsa² cagh¹² cog³ quiah¹² guøh¹² juøh¹² tsih¹² Jerusalén. Ca¹dsi¹lé²dsa ja³tsenh¹³ Pedro. Jøng² ca¹ŋǿh¹dsa Pedro. Ca¹juúh²dsa: ―¿Tsa³cuø¹² tøa¹² quiánh²hning cog³ quiah¹² guøh¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jøng² ca¹juúh² Pedro: ―Cuø¹² báh³ dsa². Jøng² mi³ca¹dsiánh¹ Pedro dsi²néi², ca¹hløah¹ Jesús lah¹ni³. Ca¹juúh²dsa: ―¿Ha²lah lë́h²hning quianh¹³ cog³ quiah¹² guøh¹²? ¿Hein² quiah¹² cagh¹² rai¹³ cog³ ni³ jmøi¹guǿi¹ la²? ¿Quiah¹³ dsa² quián¹²dsa, ho¹ ju³ quiah¹² dsa² siáh²? Jøng² ca¹juúh² Pedro: ―Quiah¹² dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jøng² ca¹juúh² Jesús: ―Hi² jøng² ha¹chi² hniuh¹² cuø¹³jni cog³ quiah¹² guøh¹², jní² dsa² lán¹² jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Cónh¹jøng² tsa¹hno¹jni li¹hiag¹³dsa. Hi² jøng² gu³tengh¹²hning hma²cog³ jmøi² juøh¹². Dsenh¹³hning jáh² lah¹ni³ ca¹cǿgh¹ hma²cog³. Hag³jah dsianh¹hning cøng² ŋi³néng². Ŋi³néng² jøng² gu³cuøh³hning dsa² cagh¹² cúg³ guøh¹² quián² jniang³ ta³ǿg² jniang³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jmai³ jøng² ca¹ŋi¹lé² dsa² quianh¹³ Jesús cøg¹² ja³tsenh¹³dsa. Jøng² ca¹juúh²dsa: ―¿Hein² dsa² lán¹² dsa² juanh¹² ja³jmo¹² Diú¹³ héh¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jøng² ca¹tǿh¹ Jesús jan² guing². Ca¹tsenh¹dsa guing² jøa³ ja³tiogh³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jøng² ca¹juúh²dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ tsa¹jéinh¹ hoh¹² hniah¹², ju³ná³ tsa¹lénh² hniah¹² ju³lah lán¹² guing², jøng² tsa¹lé² gu³noh¹² hniah¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dsa² héi² báh³ dsa² lén² dsa² canh¹³ ja³jmo¹² Diú¹³ héh¹, dsa² ca¹jmo¹ tsa¹quien¹² guiog¹³dsa ni³ jmøi¹guǿi¹ la², ju³lah jan² guing² lah¹lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ju³ná³ hein² dsa² ca¹hie¹ jan² guing² lah¹lang¹² huu¹³ quieg¹ jní², dsa² héi² ca¹hiei¹ jní² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Ué² lé² quiah¹² lǿa¹² ju³ hein² dsa² ca¹jmo¹ ca¹tánh² guing² lah¹lang¹² dsag³, ju³lah guing² hé² jǿg³ quieg¹ jní². Dsio¹ hi³méh¹ mi³lé² quiah¹² dsa² lah¹héi² ju³ jøng² ca¹tiág²dsa jmø³ŋih¹³ hi² rø²quiein¹² cøng² to² juøh¹² lag³dsa, cónh¹ jín³ hi² jmo¹dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","He³ báh³ ué² quiah¹² dsa² jmøi¹guǿi¹. Di³ chi² hi² jmo¹² hi² tiáh¹dsa dsag³. Tiog¹³ báh³ li¹chi² lah¹jøng² ni³ jmøi¹guǿi¹. Cónh¹jøng² ué² báh³ lé² quiah¹² hein² dsa² ca¹jmo¹ hi² ca¹tánh² roh¹³dsa dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Jøng² chi²júh² gugh²hning ho¹ ju³ taih³hning jmo¹ hi² ta¹canh¹³hning dsag³, jøng² quiúh³hning. Tángh³hning tø²guiég¹. Hiug¹² jín³ hi² dsio¹ dsianh¹³hning ŋi¹juǿi¹ hi² bong¹³ gugh² taih³hning cónh¹ jín³ hi² dsianh¹³hning dsi²si² tsa¹øg² ti³hian¹³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jøng² chi²júh² mø²neih³hning jmo¹ hi² ta¹canh¹³hning dsag³, jøng² dsíh³hning. Tángh³hning tø¹guiég¹. Di³ hiug¹² jín³ hi² dsio¹ dsianh¹³hning ŋi¹juǿi¹ quianh¹³ cøng² mǿi² mø³neih³hning cónh¹ jín³ hi² dsianh¹³hning dsi²si² guio¹juǿi¹ hi² tioh¹³ ta³ton¹ mø³neih³hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Tsa¹ju³jmóh³ hniah¹² tsa¹quien¹² jin³ jan² guing² lah¹lang¹². Lah¹dsóh² juǿi²jni hniah¹²: Chian² báh³ ángeles jmo¹² hí³ lah¹jan² lah¹jan² tsih² guing² lah¹lang¹². Tiá² báh³ tiogh³ ángeles héi² ja³ta¹ni¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ni³ huu¹³ jøng² ca¹guøn¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², hi² liog³jni dsa² ti³re² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Nengh² hniah¹² jǿg³ la²: Ju³ná³ jan² dsa² tiogh³ ŋia¹lúg² jah¹chih² quián¹²dsa, ju³ná³ ca¹ŋi¹hén² jan², tiog¹³ báh³ jmo¹dsa cu³tiogh³ jáh² jue¹² ja³ti³gøah¹²jah máh², ta³lah¹dsa²hniah¹²dsa jáh² ca¹ŋi¹hén². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jøng² lah¹dsóh² juǿi²jni hniah¹². Na³ma²ca¹dsanh¹²dsa jáh², hiug¹² jín³ hioh¹² jenh¹² dsa² héi² huu¹³ jáh² héi² cónh¹ jín³ jáh² jue¹², jáh² tsa¹ca¹ŋi¹hén². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jø¹² bíh³ lah¹jøng² Jmi² jniang³, dsa² guǿ¹² ŋi³juǿi¹, tsa¹hniu¹ dsø¹hén² jin³ jan² tsih² guing² lah¹lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ju³ná³ ca¹jmo¹ jan² dsa² roh¹³ jniang³ dsag³ ja³cogh²hning, jøng² gu³jmóh³hning jǿg³ rø² quianh¹³dsa ja³cu³guiogh³ hniah¹². Ju³ná³ ca¹hie¹ dsa² héi² jǿg³ quiánh²hning, dsio¹ báh³ jøng². Ma²lé² gu³noh¹² hniah¹² cu¹dsie¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ju³ná³ tsa¹ca¹hie¹dsa jǿg³ rø², jøng² tøah¹³hning jan² og¹ dsa² siáh², dsa² dsø¹néng² jǿg³ ja³gu³mi³rǿh³hning jǿg³ quianh¹³ dsa² cuøh¹²hning dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ju³ná³ tsa¹ca¹nǿng²dsa jǿg³ quiah¹² dsa² siáh² héi² calah, jøng² gu³tseih³hning ca¹lah¹já¹ dsa² roh¹³ jniang³. Ju³ná³ tsa¹ca¹nǿng²dsa jǿg³ quiah¹² dsa² roh¹³ jniang³, jøng² jah³hning dsa² héi² ju³lah jë́²dsa jan² dsa² re² dsag³, dsa² tsa¹hnio¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Lah¹dsóh² juǿi²jni hniah¹²: Chi²júh² he² hi² cuúh³ hniah¹² lé² ni³ jmøi¹guǿi¹ la², chi²júh² he² hi² tsa¹cuúh³ hniah¹² lé², jø¹² bíh³ lah¹jøng² cuø¹ Diú¹³, dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Jø¹² bíh³ juǿi²jni hniah¹²: Ju³ná³ ma²tiogh³ og¹ hniah¹² cøng² jǿg³ ni³ jmøi¹guǿi¹ la², hi² chi² cøng² hi² møah¹³ hniah¹² Diú¹³, jøng² cuø¹ báh³ Jmi² jniang³ lah¹jøng², dsa² guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Di³ ja³jøng² báh³ ma²hiúg³jni quianh¹³ hniah¹², ha² ja³ca¹túgh² og¹ úg² hniah¹² ni³ huu¹³ quieg¹ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jøng² ca¹ŋi³tseih³ Pedro Jesús. Ca¹juúh²dsa: ―Juu¹³ jniang³, ¿ha²cónh¹ rón² hi² hén¹³jni dsag³ quiah¹² roh¹²jni, dsa² ca¹jmo¹ hi² hlaih¹³ ja³cog²jni? ¿Ca³lah¹ca¹tǿ² guio¹ rón²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jøng² ca¹juúh² Jesús: ―A¹jáng¹ ju³ guio¹ rón² henh¹³hning dsag³ quiah¹² rúh²hning. Cøng² hi² henh¹³hning dsag³ ca¹lah¹cónh¹ té¹² hi² ca¹jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Di³ lǿa¹² ja³jmo¹² Diú¹³ héh¹, ju³lah lǿa¹² quiah¹² jan² rai¹³ ca¹jái¹ jǿg³ quiah¹² cog³ ti³chinh¹² dsa² jmo¹² ta³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ma²jmo¹²dsa lah¹jøng² mi³ca¹jian¹dsa jan² dsa² re² ma¹dsio¹² millón cog³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ha¹chi² cog³ chi² li¹jainh¹ dsa² héi² quiah¹² rai¹³ juu³dsa. Jøng² ca¹jmo¹ rai¹³ héh¹ hi² hnë¹dsa dsa² héi² quianh¹³ hio¹³ quián¹²dsa, quianh¹³ jong¹²dsa, quianh¹³ ca¹lah¹jǿ¹ hi² chi² quiah¹²dsa. Mi³jøng² quíg¹dsa ca¹lah¹jǿ¹ hi² re²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jøng² ca¹chi¹jné¹ dsa² re² cog³ héi² ja³ta¹ni¹ juu³dsa. Ca¹juúh²dsa: “¡Jmo³ juøh¹² hoh¹²hning quianh¹³ jní²! Cøa¹³ báh³ jní² ca¹lah¹jǿ¹,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jøng² ca¹ŋi¹ŋiú² dsǿa¹² rai¹³ dsa² héi². Jøng² ca¹hén² rai¹³ dsag³ quiah¹² dsa² héi², hi² mi³re²dsa cog³. Jøng² ca¹lég² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mi³ca¹løa¹ lah¹jøng² ca¹u¹hái¹ dsa² mi³re² cog³ héi². Jøng² ca¹jén²dsa jan² dsa² mi³jmo¹² ta³ quianh¹³dsa, dsa² re² ton¹ ŋi²lǿg² héh¹ cog³ quiah¹²dsa. Jøng² ca¹guøh¹dsa lag³ dsa² re² cog³ héi². Ca¹juúh²dsa: “¡Quig³ hi² reh²hning quieg¹jni!” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jøng² ca¹chi¹jné¹ dsa² re² cog³ ni³ dsa² héi². Ca¹juúh²dsa: “¡Jmo³ juøh¹² hoh¹²hning quianh¹³ jní²! Cøa¹³jni ca¹lah¹jǿ¹ re²jni quiánh²hning,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cónh¹jøng² tsa¹ca¹lø¹hniu¹dsa jǿg³ jøng². Jøng² ca¹ŋi³tianh¹²dsa dsa² héi² hni¹ŋí³ ca¹lah¹ja³ca¹quíg¹dsa hi² mi³re²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jøng² mi³ca¹jái¹ dsa² ti³jmo¹² ta³ quiah¹² rai¹³ hi² ca¹jmo¹ dsa² héi², hlaih¹³ ca¹jính¹dsa. Jøng² ca¹ŋi³tseih³dsa rai¹³ ca¹lah¹jǿ¹ hi² ma²ca¹løa¹, hi² ma²ca¹jmo¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jøng² ca¹tǿh¹ rai¹³ dsa² ca¹jmo¹ lah¹jøng². Ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² héi²: “¡He³ báh³ hiug¹² hlanh³hning! Ca¹hén¹jni dsag³ ca¹lah¹jǿ¹ hi² mi³reh²hning. Di³ ca¹møah³hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lah¹jøng² báh³ mi³dsø¹ŋiú² hoh¹²hning dsa² re² quiánh²hning ju³lah ca¹ŋi¹ŋiú² dsøa¹jni hning²,” ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jøng² ca¹lø¹hné¹ rai¹³ quianh¹³ dsa² héi². Jøng² ca¹tangh¹²dsa hni¹ŋí³ ca¹lah¹ja³ca¹quíg¹dsa ca¹lah¹jǿ¹ hi² mi³re²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jø¹² bíh³ lah¹jøng² jmo¹ ti³ŋieh¹jni, dsa² guǿ¹² ŋi¹juǿi¹, ja³cogh² hniah¹², ju³ná³ lah¹jan² lah¹jan² hniah¹² tsa¹henh¹² hniah¹² dsǿg³ rúh² hniah¹² ca¹lah¹hiu³ hoh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mi³ca¹jŋi¹ juúh² Jesús jǿg³ jøng², ca¹u¹hái¹dsa ja³tén¹² Galilea. Ca¹ŋó¹dsa juu¹² ja³tén¹² Judea, tø¹hŋoh¹³ chi²jmøi² Jordán. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jue¹² dsa² ca¹ŋi¹lé² quianh¹³ Jesús. Jøng² ca¹mi¹hliú²dsa dsa² mi³ti³dsoh¹ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jøng² ca²dsiog³ dsa² fariseo ca¹dsi¹lé² cøg¹² ja³guǿ¹² Jesús. Hniu¹dsa li¹gan¹² Jesús. Jøng² ca¹juúh²dsa: ―¿Tsa³lé² tióg² dsa² ŋioh¹² hio¹³ quián¹²dsa ju³ná³ he² hi² lǿa¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jøng² ca¹juúh² Jesús: ―Rø²juúh² báh³ si² quiah¹² Diú¹³ ha²lah ca¹jmo¹ Diú¹³ jmai³ lah¹ni³, ja³ca¹niu¹ jmøi¹guǿi¹. Ca¹jmo¹dsa ma¹quién¹ ni³ dsa², ju³lah dsa² ŋioh¹² quianh¹³ mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jø¹² bíh³ rø²juúh² si² quiah¹² Diú¹³ hi² tiúg² dsa² ŋioh¹² chiég³ jmi²dsa. Mi³jøng² guú¹dsa quianh¹³ hio¹³ quián¹²dsa. Jøng² dsa² mi³lán¹³ og¹ ca¹løa¹ cøng² jmø²ŋǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsa¹ma¹lán¹²dsa og¹ dsa². Cøng² jmø²ŋǿa¹² ma²løa¹² quiah¹²dsa. Hi² jøng² tsa¹lé² tsog¹dsa. Di³ Diú¹³ ca¹jmo¹ ma²lán¹²dsa ju³lah lán¹² jan² dsa² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jøng² ca¹juúh² dsa² fariseo: ―¿He² løa¹ ca¹jmo¹ hlai³ Moisés jǿg³ hi² jmo¹ dsa² ŋioh¹² si² hi² tsog¹dsa, mi³jøng² tióg²dsa hio¹³ quián¹²dsa? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jøng² ca¹juúh² Jesús: ―Hi² jøng² báh³ ca¹quieg² hlai³ Moisés jǿg³ jøng²: Di³ huh² hoh¹² hniah¹². Di³ ha¹chi² mi³lǿa¹³ lah¹jøng² cónh¹ jmai³ lah¹ni³ ca¹lø¹chián¹ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lah¹la² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹tióg² hio¹³ quián¹², ju³lah dsa² ma²ca¹jmo¹ ju³lah lǿa¹² lei¹³ quiah¹² dsa² jenh² gug², ni³ jøng² ca¹jian¹dsa hio¹³ siáh², dsa² ŋioh¹² héi² ta¹canh¹³ dsag³ ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jøng² ca¹juúh² dsa² quianh¹³ Jesús: ―Hiug¹² jín³ hi² dsio¹ tsa¹jian¹ dsa² ŋioh¹² hio¹³, chi²júh² lah¹jøng² lǿa¹² jǿg³ quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jøng² ca¹juúh² Jesús: ―Dsøg¹² báh³ jøng². Cónh¹jøng² ha¹chi² ca¹të́² ca¹lah¹já¹ dsa² jǿg³ hi² tsa¹jian¹dsa hio¹³. Jmáh¹lah dsa² héi² báh³ ca¹të́², dsa² ma²ca¹cuúh¹ Diú¹³ bí² hi² hie¹dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Di³ chian² ca²dsiog³ dsa² tsa¹jian¹ hio¹³ ni³ huu¹³ hi² ma²lán¹²dsa dsa² teh¹² mi³ca¹lø¹chián¹dsa. Jø¹² bíh³ chian² ca²dsiog³ dsa² tsa¹jian¹ hio¹³ ni³ huu¹³ hi² ca¹jmo¹ dsa² hi² teh¹²dsa. Jø¹² bíh³ chian² ca²dsiog³ dsa² tsa¹jian¹ hio¹³ ni³ huu¹³ jǿg³ quiah¹² Diú¹³. Hein² dsa² tiúh¹ hie¹ jǿg³ jøng², ju³hie³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jøng² ca¹ŋi¹jian¹ dsa² hi²meh² ni³ Jesús. Hniu¹dsa quiég¹ Jesús gug² ni³ quiah¹² hi²meh² ta³lah¹hlanh¹dsa Diú¹³. Jøng² ca¹jé² dsa² quianh¹³ Jesús dsa² ca¹jiag¹² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Di³ jøng² ca¹juúh² Jesús: ―¡Ju³ji¹lé² hi²meh² juu¹² ja³cog²jni! ¡Tsa¹jnë¹³ juu¹²! Di³ dsa² lah¹héi² li¹chian² ja³jmo¹² Diú¹³ héh¹, dsa² lán¹² ju³lah lán¹² hi²meh² ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jøng² ca¹quieg² Jesús gug² ni³ quiah¹² hi²meh². Jøng² ca¹u¹hái¹dsa ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ca¹dsiég¹ jan² dsa² ni³ Jesús. Ca¹juúh²dsa: ―Tøa¹², ¿he² hi² dsio¹ hniuh¹² jmo¹³jni, mi³jøng² li¹chian²jni tiá²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ ŋaih³hning jní² quiah¹² hi² dsio¹? Jan² báh³ dsa² dsiog¹. Diú¹³ báh³ héi². Ju³ná³ hnøngh²hning dsa¹ŋë́h²hning hi² li¹chianh²hning tiá², jøng² hniuh¹² mi³tih³hning jǿg³ ju³lah lǿa¹² lei¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jøng² ca¹juúh² dsa² héi²: ―¿He² jǿg³ mi³ti³jni? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Jǿg³ rø²juúh² si²: ¡Tsa¹jŋë́h³hning dsa²! ¡Tsa¹hlanh¹³hning hio¹³ siáh²! ¡Tsa¹høinh¹³hning! ¡Tsa¹juúh³hning jǿg³ ta³jǿg³! ");
INSERT INTO cpaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","¡Mi³juanh¹³hning chiegh² ŋieih¹²hning! ¡Ju³li¹hnóh¹hning dsa² jmøi¹guǿi¹ jianh¹²hning, ju³lah hnóh¹hning hŋiah¹hning! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jøng² ca¹juúh² dsa² héi²: ―Ca¹lah¹jǿ¹ hi² jøng² ma²ca¹mi³ti³jni ca¹lah¹cónh¹ jmai³ mi³meh²jni. ¿He² hi² hniuh¹² jmo¹³jni ni³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jøng² ca¹juúh² Jesús: ―Ju³ná³ hnøngh²hning jmóh³hning ca¹lah¹jǿ¹ hi² hniu¹ Diú¹³, guønh²hning. Gu³hnaih³hning ca¹lah¹jǿ¹ hi² chi² quiánh²hning. Di³ jøng² gu³cuøh³hning dsa² ti²ŋié² cog³. Jøng² li¹chi² ma¹dsio¹² quiánh²hning ŋi¹juǿi¹. Jøng² ŋiah¹³hning. Ŋǿh³hning quianh¹³ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mi³ca¹nǿng² dsa² héi² jǿg³ jøng², hlaih¹³ jenh¹²dsa. Di³ ma¹dsio¹² hi² chi² quiah¹²dsa. Jøng² ca¹ŋáh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: ¡He³ báh³ ué² dsianh¹³ dsa² chi² cog³ ja³jmo¹² Diú¹³ héh¹! ");
INSERT INTO cpaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jø¹² bíh³ juǿi²jni hniah¹²: Hiug¹² jín³ tsa¹ué² ŋë́² jan² camello juu¹² gǿh³ hma²cog³ cónh¹ jín³ hi² dsianh¹³ dsa² chi² cog³ ja³jmo¹² Diú¹³ héh¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jøng² dsogh¹² hlaih¹³ dsǿa¹² dsa² quianh¹³dsa mi³ca¹nǿng²dsa jǿg³ jøng². Jøng² ca¹juúh²dsa: ―¿Hein² dsa² liúg² jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jøng² ca¹jë́² Jesús dsa² quianh¹³dsa. Ca¹juúh²dsa: ―Ha¹chi² tiúh¹ dsa² jmøi¹guǿi¹. Di³ tiúh¹ báh³ Diú¹³. Ha¹chi² hi² chi² hi² tsa¹tiúh¹ Diú¹³ jmo¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Ma²ca¹tiú¹³ jnieh³ ca¹lah¹jǿ¹ hi² chi² jmøi¹guǿi¹. Ma²ca¹ja¹neng¹³ jnieh³ quianh¹³ hnéng¹. ¿He² líh² jnieh³ hi² mi³ca¹jmó³ jnieh³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Na³ma²ca¹tǿ² ja³ca¹jmo¹ Diú¹³ hi² hmë́² ca¹lah¹jǿ¹, jmai³ ja³ma²guø³jni jmo¹²jni héh¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², jmai³ jøng² jmóh³ hniah¹² héh¹ quiah¹² ca¹lah¹jǿ¹ guie¹tǿn² juøi² israel, hniah¹² dsa² guia¹tón², dsa² ma²ca¹ja¹nioh¹² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jø¹² bíh³ ju³ná³ hein² dsa² ca¹tiú² hniu³dsa, ho¹ ju³ ca¹tiúg²dsa roh¹³dsa, ho¹ ju³ chiég³ jmi²dsa, ho¹ ju³ tsih² guing², ho¹ ju³ ca¹tiú²dsa huø¹ quiah¹² huu¹³ quieg¹jni, tsug¹² jín³ ma¹dsio¹² tan¹ dsa² héi² jmøi¹guǿi¹ cøng². Jø¹² bíh³ tan¹dsa li¹chian²dsa tiá². ");
INSERT INTO cpaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jøng² dsa¹lé² jue¹² dsa² ja³ca¹tóh² jø² jmai³ jøng², ju³lah dsa² mi³quin¹² ni³ ni³ jmøi¹guǿi¹ la². Jøng² dsa² mi³chi³quë́¹, jue¹² dsa² héi² cán² ni³. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan² juu¹³ huø¹ ca¹ŋó¹ cøng² tu¹heg². Ta¹ŋih¹³ ca¹ŋi¹hnio¹dsa dsa² jmo¹ ta³ jøa³ nung² gu²jøah¹³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jøng² ca¹jmo¹dsa jǿg³ hi² quíg¹dsa ma²guie¹ héh¹ lah¹cøng² jmai³ quiah¹² dsa² jmo¹ ta³. Jøng² ca¹tse¹dsa dsa² dsø¹jmó² ta³ huø¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ni³ jøng² ca¹ŋó¹dsa calah cónh¹ hein¹³ ŋiu¹ tu¹heg². Jøng² ca¹jë́²dsa dsa² siáh², dsa² la³tiogh³ jøa³hmah³. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jøng² ca¹tsáih¹dsa dsa² héi²: “Gu³noh¹² hniah¹² calah ta³ jøa³nung² quieg¹jni. Jøng² cónh¹ té¹² báh³ mi³hmah¹³jni quiánh² hniah¹²,” ca¹juúh²dsa. Hi² jøng² ca¹ŋi¹lé² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jøng² ca¹ŋó¹ dsa² juu¹³ calah siíh² cónh¹ dsi¹hiég¹. Jø¹² bíh³ ca¹jmo¹dsa lah¹jøng² calah. Ca¹tse¹dsa dsa². Ca¹jmo¹dsa lah¹jøng² calah cónh¹ hein¹³ hnøa¹² ta¹ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jøng² ca¹ŋó¹dsa calah cónh¹ hein¹³ hŋí² ta¹ca¹hlég². Ca¹ŋó¹dsa calah juu¹² jøa³hmah³. Jøng² ca¹jë́²dsa calah dsa² la³tiogh³. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: “¿He² løa¹ tiogh³ hniah¹² ja³la² ta³cøng² jmai³ hi² ha¹chi² ta³ jmoh² hniah¹²?” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jøng² ca¹juúh² dsa² héi²: “Ha¹chian² dsa² ma²ca¹tǿh¹ jnieh³,” ca¹juúh²dsa. Jøng² ca¹juúh² dsa² juu¹³ héi²: “Jøng² gu³jmóh³ hniah¹² ta³ huø¹ quieg¹jni,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mi³ca¹neng² jøng², ca¹juúh² dsa² juu¹³, ca¹tsáih¹dsa dsa² neng¹² ni³ ta³ quiah¹²dsa: “¡Tei³ dsa² ti³jmo¹² ta³! Jøng² dsa² ca¹ŋi¹togh¹ ja³ca¹tóh² jø², ni³jiá¹ li¹hmah¹³ quiah¹² lah¹ni³. Jøng² ja³ca¹tóh² jø² li¹hmah¹³ quiah¹² dsa² ca¹ŋi¹togh¹ ta¹ŋih¹³,” ca¹juúh² dsa² juu¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jøng² ca¹dsi¹lé² dsa² ca¹ŋi¹togh¹ ta³ hein¹³ hŋí² ta¹ca¹hlég². Jøng² ca¹hiei¹dsa cog³, ma²guie¹ héh¹ cog³ lah¹jan²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jøng² mi³ca¹të́² dsa² ca¹ŋi¹togh¹ ta³ lah¹ni³, mi³lë́²dsa hiei¹dsa ma¹dsio¹² cog³. Di³ jøng² ma¹guie¹ héh¹ cog³ ca¹hiei¹dsa lah¹jan²dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mi³ma²na²hiei¹dsa cog³ jøng², ca¹jé²dsa juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ca¹juúh²dsa: “Dsa² jnung² dsa² na²u¹lé² ja³ca¹tóh² jø². Cøng² hora báh³ ca¹jmo¹dsa ta³. Ma²na²quigh¹hning cu²rø² quiah¹² dsa² héi² quianh¹³ jnieh³, dsa² ma²na²lø¹bí² dsǿa¹² dsi²hieg² ta³cøng² jmai³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jøng² ca¹juúh² dsa² juu¹³, ca¹tsáih¹dsa jan² dsa² lah¹héi²: “Jai³ di³ hning², Ha²mei¹³ quian¹jni. Ha¹chi² hi² hlaih¹³ jmo¹²jni ca¹lah¹jin³ cøng² quiánh²hning. Ca¹jmoh³hning jǿg³ quianh¹³ jní² hi² cøa¹³jni ma²guie¹ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hieih³hning cog³ quiánh²hning. Jøng² guønh²hning. Hno¹jni cøa¹³jni quiah¹² dsa² ca¹túgh² ta³ ja³ca¹tóh² jø² cu²rø² cónh¹ ja³cøa¹³jni quiánh² hning². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lé² báh³ jmo¹²jni he² hi² hno¹jni quianh¹³ cog³ quieg¹jni. Tsa¹mi³hiágh³hning jní² ni³ huu¹³ ma²na²jmo¹jni juanh¹² dsøa¹jni,” ca¹juúh² dsa² juu¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lah¹jøng² báh³ lé²: Dsa² ŋi²nio³ chi³quë́¹ cán² ni³. Jøng² dsa² ma²quin¹² ni³ dsa¹lé² ja³ca¹tóh² jø² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ma²dsø²lé²dsa juu¹² Jerusalén. Jøng² ca¹tǿh¹ Jesús dsa² guia¹tón² dsi²juu¹². Ca¹dsiúh¹dsa dsa² jǿg³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jai³lah, dsǿg³ jniang³ juu¹² Jerusalén. Ni³ jøng² jë́h²dsa jní² ni³ juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jian¹²dsa. Jøng² cuúh¹dsa jní² dsag³ juøh¹² hi² hniu¹dsa jón²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jøng² jë́h²dsa jní² quiah¹² dsa² siáh², dsa² cuø¹ ju²hiíh¹, dsa² bú²jni. Tiang¹dsa jní² ni³ crǿg¹³. Jøng² jón²jni. Di³ jøng² hi² hiog¹jni ja³hnøa¹² jmai³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jøng² ca¹ŋó¹ hio¹³ quián¹² Zebedeo ja³ta¹ni¹ Jesús. Ca¹ŋi¹jian¹dsa og¹ ja³ŋiúh³dsa, dsa² tsen² Jacobo quianh¹³ Juan. Ca¹møa¹ hio¹³ hi² jmo¹ Jesús cøng² hi² dsio¹ dsǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―¿He² hi² hnøngh²hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² hio¹³: ―Jmóh³hning hi² tógh¹ og¹ ja²ŋiuh¹jni lang¹² cugh²hning, na³ma²tǿ² ja³ma²lanh¹²hning dsa² jmo¹² héh¹, jan² dsa² guú¹ tø¹guie¹jo¹³, jan² dsa² tø¹guie¹jón¹ ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Jacobo quianh¹³ Juan: ―Tsa¹ŋih³ hniah¹² he² hi² møh² hniah¹². ¿Tiah³¹ hniah¹² cánh³ jmø³uai¹² hi² ŋi³can³jni? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Tiúh¹ báh³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² cánh³ báh³ hniah¹² jmø³uai¹² cán³jni. Di³ a¹jáng¹ jní² lé² cuø¹³ hein² togh¹ cog²jni tø¹guie¹jo¹³ tø¹guie¹jón¹. Dsa² héi² togh¹ cog²jni, dsa² ma²lǿa¹² jǿg³ togh¹, ju³lah lǿa¹² héh¹ ca¹jmo¹ ti³ŋieh¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jøng² mi³ca¹nǿng² dsa² guian¹ jǿg³ jøng², ca¹lø¹hian³dsa dsa² og¹ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Di³ jøng² ca¹tǿh¹ Jesús dsa² guia¹tón². Ca¹juúh²dsa: ―Ma²ŋih³ báh³ hniah¹² ha²lah jmo¹² dsa² lán¹² dsa² ta³ quián¹² dsa² tsa¹lán¹² judío. Jmo¹²dsa lán¹²dsa juu³ dsa² jue¹². Jøng² jmo¹² dsa² canh¹³ hi² li¹dsen¹³dsa ni³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tsa¹lé² lah¹jøng² quiánh² hniah¹². Ju³ná³ hein² hniah¹² hnøngh² lénh² dsa² juanh¹² ja³cog² dsa² jianh¹² hniah¹², jøng² hniuh¹² mi³tih³ hniah¹² ni³ dsa² jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ju³ná³ hein² hniah¹² dsa² hnøngh² cánh³ ni³, jøng² hniuh¹² mi³hogh³ hniah¹² dsa² jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Di³ jní² calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ca¹guio¹jni mi³jøng² mi³ti³jni ni³ dsa², a¹jáng¹ ju³ hi² mi¹ti¹dsa ne¹ jní². Ca¹guio¹jni hi² jón²jni. Jøng² log³jni dsa² jue¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jøng² ca¹tsø³jue¹³dsa jøa³juøi² Jericó. Jue¹² hlaih¹³ dsa² ma²dsø²lé² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jøng² mi³tiogh³ og¹ dsa² teg³ dsi²juu¹². Mi³ca¹lø¹lih¹³ dsa² héi² hi² ma²já¹² Jesús, ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Guiuh¹³, tsø³jong¹³ hlai³ David! ¡Jmo³ huø³ hoh¹² quianh¹³ jnieh³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jøng² ca¹jí² dsa² jue¹² quiah¹² dsa² teg³ héi² hi² tsa¹ma¹tóh¹dsa møah¹³. Ta³lah¹tí² hi³méh¹ ca¹hløah¹dsa. Ca¹juúh²dsa: ―¡Guiuh¹³! ¡Tsø³jong¹³ hlai³ David! ¡Jmo³ huø³ hoh¹² quianh¹³ jnieh³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jøng² ca¹jŋi¹ Jesús. Ca¹tǿh¹dsa dsa² teg³. Ca¹juúh²dsa: ―¿He² hi² hnøngh² hniah¹² jmo¹³jni ja³cogh² hniah¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jøng² ca¹juúh² dsa² teg³: ―Ju³li¹jniuh¹² jnieh³, Guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jøng² ca¹ŋi¹ŋiú² dsǿa¹² Jesús. Ca¹láh²dsa mø³ni³dsa. Dsø¹juu¹² jøng² ca¹løa¹ jniuh¹²dsa. Ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jøng² ja¹quien¹³ dsi³lé²dsa Jerusalén, ca¹dsi¹lé²dsa jøa³juøi² Betfagé ja³tsih¹³ máh² Olivo. Jøng² ca¹tse¹ Jesús og¹ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ca¹juúh²dsa: ―Gu³noh¹² hniah¹² juøi² mih² neng¹² cøg² ná¹². Dsø¹juu¹² na³ma²ca¹dsi¹noh¹² hniah¹², dsianh¹² hniah¹² jan² chi³búh³, chi³hŋioh¹jah lah¹quianh¹³ jan² búh³ meh². Tseh³ jáh². Taih³ jáh² ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ju³ná³ hein² dsa² ca¹juúh²: “¿He² løa¹ na²tseh³ hniah¹² jáh²?” Jøng² juaih¹³ hniah¹² dsa²: “Chi³quian¹³ Juu¹³ jniang³ jmai³ jáh². Dsø¹juu¹² cuø¹dsa jǿg³ hi² taih³ hniah¹² jáh²” ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lah¹jøng² báh³ ca¹løa¹, mi³jøng² li¹ti¹ jǿg³ la², hi¹ ca¹juúh² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: ");
INSERT INTO cpaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gu³tseih³ dsa² chian² Sión, dsa² israel, jǿg³ la²: “Dsa² lén² rai¹³ quiánh² hniah¹² ma²já¹². Tsa¹jmo¹²dsa hi² juanh¹²dsa. Guǿ¹²dsa cah³ búh³, jong¹² jáh² quien¹² lio¹³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jøng² ca¹ŋi¹lé² dsa² og¹ héi², dsa² ca¹tse¹ Jesús. Ca¹jmo¹dsa ju³lah ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jøng² ca¹ŋi³tei²dsa jáh² quianh¹³ jong¹²jah ja³tsenh¹³ Jesús. Ca¹jiúh²dsa tsǿnh³dsa cah³ jáh². Jøng² ca¹gú² Jesús cah³ jáh². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jøng² jue¹² hlaih¹³ dsa² ca¹jág¹ tsǿnh³ dsi²juu¹². Jøng² ca²dsiog³dsa ca¹quiúh² moh¹³ tsǿn¹². Ca¹jág¹dsa dsi²juu¹². Mi³jøng² lé² jláh³ juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jøng² tí² ca¹hløah¹ dsa² ma²jiá¹² lah¹quianh¹³ dsa² chi³quë́¹. Ca¹juúh²dsa: ―Dsa² dsiog¹ báh³ tsø³jong¹³ hlai³ David lang¹². Hiug¹² juanh¹² dsa² ma²já¹², dsa² ca¹tse¹ Diú¹³ juanh¹². Dsio¹ mi³juanh¹³ jniang³ Diú¹³, dsa² guǿ¹² guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jøng² mi³ca¹dsiég¹ Jesús jøa³juøi² Jerusalén, dsogh¹² hlaih¹³ dsǿa¹² dsa² chian² ja³jøng². Gøg² ca¹can¹dsa. Jøng² ca¹dsii¹ dsa² jue¹² jǿg³ cu³guiog¹³. Ca¹juúh²dsa: ―¿Hein² báh³ dsa² ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jøng² ca¹juúh² dsa² ŋi²nio³ quianh¹³ Jesús: ―Dsa² hǿ² jǿg³ quiah¹² Diú¹³ báh³ lang¹², dsa² tsen² Jesús, dsa² chian² Nazaret, juøi² tén¹² Galilea ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jøng² ca¹ŋó¹ Jesús juu¹² ja³tsih¹³ guøh¹² juøh¹². Jøng² ca¹huan¹ Jesús dsa² hnai¹² lio¹³ quianh¹³ dsa² lá¹², dsa² mi³tiogh³ niúh¹ jnǿ³ ja³tsih¹³ guøh¹². Ca¹jéinh¹ Jesús mesa quiah¹² dsa² mi²tsë́¹ cog³. Ca¹jéinh¹dsa hma²sai³¹ quiah¹² dsa² hnë¹² jug². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jøng² ca¹tsáih¹dsa dsa² héi². Ca¹juúh²dsa: ―Lah¹la² báh³ rø²juúh² si² quiah¹² Diú¹³: “Hniú¹² ja³hlanh¹²dsa Diú¹³,” li¹tsen² hniú¹² quieg¹jni, rø²juuh² si². Cónh¹jøng² ma²ca¹jmoh³ hniah¹² ma²lǿa¹² hniu³ Diú¹³ ju³lah lǿa¹² cøng² ja³tiogh³ dsa² høin² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ja³tsih¹³ guøh¹² jøng² ca¹dsi¹lé² dsa² teg³ quianh¹³ dsa² tsa¹li¹ŋøa¹ ni³ Jesús. Jøng² ca¹mi¹hliú² Jesús dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jøng² mi³tiogh³ juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Ca¹jái¹dsa juu¹² juøh¹² lah¹jøng², hi² ca¹jmo¹ Jesús. Ca¹nǿng²dsa jǿg³ juúh² hi²meh² ma²tiogh³ ja³tsih¹³ guøh¹². Ca¹hløah¹tsih tí². Lah¹la² ca¹juúh²tsih: “Hiug¹² juanh¹² tsø³jong¹³ hlai³ David lang¹²,” ca¹juúh²tsih. Jøng² ca¹lø¹hné¹ juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―¿Tsa³nøngh²hning jǿg³ juúh² tsih² tiogh³ ná¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Nang¹² báh³ jní². Jmo¹² báh³ tsih² ju³lah lǿa¹² jǿg³ la², hi² rø²juúh² si² quiah¹² Diú¹³: Ma²ca¹mi³tanh¹³hning tsih² guing². Mi³jøng² cu²rø² hlaih¹³ mi²juanh¹²tsih hning², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jøng² ca¹tiúg² Jesús dsa² héi². Ca¹u¹hái¹dsa jøa³juøi² Jerusalén. Ca¹ŋó¹dsa juu¹² jøa³juøi² Betania, ja³ca¹jnióh¹dsa cøng² huu². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mi³ca¹jni¹, jøng² ca¹ŋó¹ calah Jesús juu¹² jøa³juøi² Jerusalén. Jøng² ca¹løa¹ lø¹i³cónh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jøng² ca¹jái¹dsa tsih¹² cøng² hma² higo cøg¹² juu¹². Ca¹ŋó¹dsa juu¹² ja³tsih¹³ hma². Jøng² ha¹chi² mǿi² higo ca¹dsóh²dsa ca¹lah¹jin³ he². Jmáh¹lah moh¹³ báh³ ti³dsøa¹³. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hma²: ―¡Tsa¹ton¹² jmai³ ma¹hai¹ mǿi² quiánh²hning, jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹! ―ca¹juúh²dsa. Dsø¹juu¹² jøng² ca¹lø¹quiéng¹ hma² ca¹tǿ² jmó³. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jøng² ca²lah²dsogh¹² dsǿa¹² dsa² quianh¹³ Jesús, mi³ca¹jái¹dsa. Ca¹juúh²dsa: ―¿Ha²lah ca¹løa¹ ca¹lø¹quiéng¹ hma² ta³tí³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ héh² hniah¹² jǿg³ quiah¹² Diú¹³, hi² tsa¹lë́h² hniah¹² hi² tsa¹li¹ti¹, jøng² li¹chi² bí² quiánh² hniah¹² hi² jmóh³ hniah¹² hiug¹² jín³ ma¹dsio¹² cónh¹ ja³ca¹jmo¹jni quiah¹² hma² ná¹². Li¹chi² bí² hi² juaih¹³ hniah¹² máh² jnung² hi² jŋiángh¹ máh², hi² dsa¹hí² dsi²jo² jmø³ŋih¹³. Jøng² lé² báh³ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ca¹lah¹jǿ¹ he² hi² møh² hniah¹² ja³cog² Diú¹³, ŋieh¹ báh³ hniah¹² ju³ná³ héh² hniah¹² hi² tiúh¹ Diú¹³ jmo¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mi³ca¹dsiég¹ Jesús ja³tsih¹³ guøh¹², ca¹heh¹dsa dsa² mi³tiogh³ ja³jøng² jǿg². Jøng² ca¹dsi¹lé² juu¹³ jmi²dsa² ca¹lah¹quianh¹³ dsa² canh¹³ quián¹² dsa² judío. Jøng² ca¹ŋǿh¹ dsa² héi² Jesús: ―¿He² jǿg³ ca¹të́h²hning hi² jmoh²hning juu¹² juøh¹², hi² huanh³hning dsa² hnai¹² lio¹³ tø¹coh¹³ jnǿ³? ¿Hein² ca¹cuø¹ jǿg³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Juǿi²jni hniah¹² cøng² jǿg³. Na³ma²na²ŋaih³ hniah¹² jǿg³ juǿi²jni hniah¹², ni³ jøng² juøh¹³jni he² jǿg³ ca¹të́²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lah¹la² ŋaih³ hniah¹² jní²: ¿Hein² quiah¹² jǿg³ hi² ca¹chiog¹ hlai³ Juan dsa² jmøi²? ¿Jǿg³ quiah¹² Diú¹³, ho¹ ju³ jǿg³ ca¹jmo¹ dsa² jmøi¹guǿi¹ báh³? ―ca¹juúh² Jesús. Jøng² ca¹dsii¹ dsa² héi² jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―Tsa¹lé² tséih³ jniang³ dsa² jǿg³ quiah¹² Diú¹³. Di³ jøng² tsáih¹dsa jniang³ he² løa¹ tsa¹ca¹héh³ jniang³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jø¹² bíh³ tsa¹lé² juúh³ jniang³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹. Di³ gan¹ jniang³ dsa² jue¹². Di³ lah¹jøng² lë́² ca¹lah¹já¹dsa, hi² lah¹dsóh² mi³lán¹² hlai³ Juan dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jøng² ca¹juúh² juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³, ca¹tsáih¹dsa Jesús: ―Tsa¹ne³ jnieh³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jøng² tsa¹ŋi³juøh¹³jni calah he² jǿg³ ca¹të́²jni hi² jmo¹²jni láh² ma²ca¹jmo¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Nengh² hniah¹² jǿg³ la². Jan² dsa², mi³chian² og¹ ja³ŋiúh³dsa. Ca¹tsáih¹dsa jong¹²dsa, dsa² lán¹² dsa² juanh¹². Ca¹juúh²dsa: “Gu³jmo³ ta³ na¹ jøa³ gu²jøah¹³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jøng² ca¹ŋai¹ ja³ŋiúh³ héi². Ca¹juúh²dsa: “Ha¹chi² nei³jni,” ca¹juúh²dsa. Ni³ jøng² ca¹jéinh¹ dsǿa¹²dsa. Ca¹ŋó¹dsa. Ca¹ŋi¹jmó²dsa ta³. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jøng² ca¹ŋó¹ ti³jmi²dsa calah. Ca¹ŋi³tseih³dsa ja³ŋiúh³dsa, dsa² meh². Jø¹² bíh³ lah¹jøng² ca¹juúh² ti³jmi²dsa. Jøng² ca¹juúh² dsa² lán¹² dsa² meh² héi²: “Nei¹³ báh³ jní²,” ca¹juúh²dsa. Cónh¹jøng² tsa¹ca¹ŋó¹ báh³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa jmi²dsa² quianh¹³ dsa² canh¹³ héi²: ―¿Naih¹² dsa² ca¹jmo¹ hi² hniu¹ ti³jmi²dsa? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Ja³ŋiúh³dsa dsa² juanh¹² báh³ ca¹jmo¹ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Dsa¹lé² dsa² cagh¹² cog³ juøi² quianh¹³ hio¹³ lø³hiug¹² juu¹² ja³jmo¹² Diú¹³ héh¹. Cán² dsa² héi² ni³ cónh¹ jín³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Di³ ca¹guøn¹ Juan, dsa² ca¹chiog¹ dsa² jmøi². Ca¹heh¹dsa hniah¹² jǿg³ dsøg¹² ha²lah lah¹dsóh² hniu¹ Diú¹³ hi² ŋi¹nio¹ dsa² jmøi¹guǿi¹. Jøng² tsa¹ca¹héh¹ hniah¹² jǿg³ quiah¹²dsa. Di³ jøng² ca¹hé¹ báh³ dsa² cagh¹² cog³ juøi² quianh¹³ hio¹³ lø³hiug¹². Jøng² mi³ca¹jaih³ hniah¹² lah¹jøng², cónh¹jøng² ha¹chi² ca¹jéinh¹ hoh¹² hniah¹². Ha¹chi² ca¹héh¹ hniah¹² jǿg³ ca¹he¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Nengh² hniah¹² jín³ cøng² jǿg³ ti³jnøa¹², jǿg³ quiah¹² jan² dsa² ca¹jné² chiúh³ gu²jøah¹³. Jøng² ca¹jmo¹dsa jnǿ³ lah¹jin² lah¹lǿih¹. Ca¹jmo¹dsa cøng² ja³sianh¹dsa gu²jøah¹³. Jøng² ca¹tsih¹dsa cøng² hniú¹² ŋiei¹³ jøa³, hniú¹² ja³tógh¹ dsa² jmo¹ hí³. Jøng² mi³ca¹jmo¹dsa jǿg³ hi² jmo¹ dsa² siáh² hí³, jøng² ca¹ŋó¹dsa huø¹ siíh² ja³uǿin³. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jøng² mi³ca¹tǿ² jmai³ ja³cøn¹dsa gu²jøah¹³, ca¹tse¹dsa úg² dsa² quianh¹³dsa juu¹² ja³quiah¹³ dsa² jmo¹² hí³ héi². Mi³ŋi¹quieng²dsa cónh¹ hi² ta¹dsa quiah¹² huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jøng² ca¹chiángh² dsa² mi³jmo¹² hí³ héi². Ca¹bá²dsa jan² dsa². Ca¹jŋëh¹dsa jan² dsa². Ca¹qui² ca¹túg²dsa cang³ jan² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jøng² ca¹tse¹ juu¹³dsa calah dsa² quián¹²dsa, dsa² siáh². Ca¹tse¹dsa dsa² jue¹² hi³méh¹ cónh¹ jín³ dsa² ca¹tse¹dsa lah¹jiá¹². Jø¹² bíh³ lah¹jøng² ca¹jmo¹ dsa² jmo¹² hí³ huø¹ quiah¹²dsa. Ca¹jmóh²dsa dsa² héi² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ja³ca¹tóh² jø² jøng² ca¹tse¹ dsa² juu¹³ héi² ja³ŋiúh³dsa. Di³ hi² lë́²dsa hi² mi¹juanh¹² báh³ dsa² héi² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jøng² ca¹jái¹ dsa² jmo¹² hí³ huø¹ hi² ma²júgh² ja³ŋiúh³ juu¹³ huø¹. Jøng² ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: “Dsa² júgh² ná¹² báh³ dsa² ta¹ hi² chi² quiah¹² ti³jmi²dsa. Ju³jŋëh¹³ jniang³ dsa². Mi³ jøng² tai¹ jniang³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jøng² ca¹chiángh²dsa. Ca¹ŋi³tiang¹²dsa coh¹³ jnǿ³. Jøng² ca¹jŋaih¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³: ―Na³ma²dsiánh¹ dsa² juu¹³, ¿he² jmo¹dsa quianh¹³ dsa² mi³jmo¹² hí³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Lah¹dsóh² mi¹dsian¹²dsa dsa² hiug¹² hlanh³ héi². Jøng² jmo¹dsa héh¹ hi² jmo¹ dsa² siáh² hí³ huø¹ jøng², dsa² jáinh¹ hi² ta¹dsa quiah¹² huø¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jøng² ca¹juúh² Jesús: ―¿Tsa³ma²ca¹híh² hniah¹² jǿg³ la², jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³?: Cang³ tsa¹jih² dsa² jmo¹² hniú¹², cang³ jøng² báh³ ma²jmo¹² hi² ma²tsih¹² hniú¹² tí². Juu¹³ jniang³ báh³ ca¹jmo¹ lah¹jøng². Dsio¹ hlaih¹³ cu²té¹², lë́² jniang³, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Di³ jøng² juǿi²jni hniah¹²: Tsa¹ma¹cuø¹ Diú¹³ jǿg³ hi² gu³noh¹² hniah¹² ja³jmo¹²dsa héh¹, dsa² siáh² báh³ cuúh¹dsa dsa¹lia¹ ja³jøng², dsa² mi¹ti¹ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ju³ná³ hein² dsa² tsa¹hé² jǿg³ quieg¹jni, dsa² héi² dsa¹hén². Dsián¹ báh³ ca¹lah¹já¹ dsa² ca¹lø¹hné¹jni quianh¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mi³ca¹nǿng² juu¹³ jmi²dsa² ca¹lah¹quianh¹³ dsa² fariseo jǿg³ jøng², ca¹lø¹lih¹³dsa hi² ca¹të́²dsa guiog¹³dsa jǿg³ ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jøng² mi³chiángh²dsa ju³tsa¹ca¹lø¹ga¹dsa dsa² jue¹². Di³ lë́² dsa² jue¹² hi² lán¹² Jesús dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jøng² ca¹tsáih¹ calah Jesús dsa² jue¹² jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan² rai¹³ ca¹jmo¹ jmai³ quiah¹² ja³ŋiúh³dsa, dsa² ca¹jenh² gug². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jøng² ca¹tse¹ rai¹³ dsa² jmo¹² ta³ quiah¹²dsa, hi² dsa¹tseih¹dsa dsa² ma²lǿa¹² jǿg³ dsa¹lé² jmai³ hi² ma²lé² dsa¹lé²dsa. Jøng² ha¹chi² ca¹lø¹hniu¹dsa dsa¹lé²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ni³ jøng² ca¹tse¹ rai¹³ calah dsa² siáh². Ca¹juúh² rai¹³: “Gu³tseih³ hniah¹² dsa² hi² ma²lǿa¹² ju²jŋia¹³ má¹. Ca¹mi³dsian¹³jni ca³ju² dsú² quianh¹³ jáh² ma²banh². Ma²lǿa¹² ju²jŋia¹³ ca¹lah¹jǿ¹. Gu³tseih³ hniah¹² dsa² ju³ji¹lé²dsa ta¹na¹ cónh¹,” ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jøng² dsa² ca¹tǿh¹dsa héi², tsa¹ca¹tónh¹dsa juu¹² jǿg³. Ca¹ŋi¹jmó²dsa ta³ quiah¹² guiog¹³dsa. Jan² dsa² ca¹ŋó¹ juu¹² ja²ron¹² huø¹ quiah¹². Jan² dsa² ca¹ŋó¹ ŋi¹jmó² ta³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jøng² ca²dsiog³dsa ca¹chiánh² dsa² jmo¹² ta³ quiah¹² rai¹³. Ca¹jmógh²dsa. Ni³ jøng² ca¹mi¹dsiag¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jøng² ca¹lø¹hné¹ hlaih¹³ rai¹³. Ca¹tse¹dsa hlég² quián¹²dsa. Ca¹mi¹dsian¹² hlég² dsa² ca¹jmo¹ lah¹jøng². Ca¹jøn¹ hlég² juøi² ja³mi³tiogh³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² jmo¹² ta³ quiah¹²dsa: “Ma²lǿa¹² ju²jŋia¹³ ca¹lah¹jǿ¹. Cónh¹jøng² tsa¹té¹²dsa ji¹lé²dsa, dsa² mi³lǿa¹³ jǿg³ mi³ji¹lé². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hi² gu³noh¹² hniah¹² juu¹² juøh¹². Gu³teh³ hniah¹² ca¹lah¹já¹ dsa² ŋi²nio³ ja³jøng² cónh¹ té¹² dsa² ca¹dsanh¹ báh³ hniah¹²,” ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jøng² ca¹ŋi¹lé² dsa² jmo¹² ta³ quiah¹² rai¹³ juu¹² jøng². Ca¹ŋi¹tei¹dsa ca¹lah¹já¹ dsa² ca¹jén²dsa, cu¹dsie¹² dsa² dsiog¹ quianh¹³ dsa² hlanh³. Ca¹túgh²dsa ca¹lah¹chi³cángh² hniú¹² ja³jmo¹²dsa jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Mi³ca¹dsiég¹ rai¹³ ja³jøng², ca¹jë́²dsa dsa² jue¹². Jøng² ca¹jë́² rai¹³ jan² dsa² ha¹chi² hmøah¹² quiah¹² jmai³ quieih¹²dsa, hmøah¹² ma²ca¹dsiúh¹ rai¹³ quiah¹² ca¹lah¹já¹ dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² héi²: “Ha²mei¹³, ¿he² løa¹ na²ŋëh¹³hning dsi²néi², hi² ha¹chi² hmøah¹² quiah¹² jmai³ jøng² quieih³hning?” ca¹juúh² rai¹³. Jøng² ha¹chi² ca¹ŋai¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² quián¹²dsa: “¡Quiéin² gug² tai³ dsa² ná¹²! ¡Tióg² dsa² ná¹² ca¹tǿ² guio¹juǿi¹! Ja³jøng² dsø¹tø² dsø¹hǿg²dsa. Cán²dsa ma¹dsio¹² jmø³uai¹²,” ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Lah¹jøng² lǿa¹². Di³ ma²ca¹tǿh¹ Diú¹³ dsa² jue¹². Cónh¹jøng² mih² báh³ dsa² ma²ti³quióh³ quián¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jøng² ca¹ŋi¹lé² dsa² fariseo. Ca¹ŋi¹jmó²dsa jǿg³ ha²lah mi¹gan¹²dsa Jesús. Mi³jøng² dsø¹gán² Jesús jǿg³ dsii¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ni³ jøng² ca¹tse¹ dsa² fariseo ca²dsiog³ dsa² quián¹²dsa ca¹lah¹quianh¹³ dsa² quián¹² Herodes. Mi³ca¹dsi¹lé² dsa² héi² ja³tsenh¹³ Jesús, ca¹juúh²dsa: ―Ma²ne³ jnieh³ hi² juúh²hning jǿg³ dsøg¹², Tøa¹². Lah¹dsóh² heh¹²hning ju³lah juu¹² ca¹quieg² Diú¹³. Cøng² ni³ jmoh²hning ja³cog² ca¹lah¹já¹ dsa² chian². Tsa¹jmóh³hning hi² juanh¹² jan² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Juaih¹³hning jnieh³ chi²júh² he² lë́h²hning. ¿Dsio³¹ cuǿ³ jniang³ cog³ cagh¹² rai¹³ chian² Roma? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jøng² ma²ŋi¹² Jesús ta³dsǿa¹² juúh² dsa² héi², ca¹juúh²dsa: ―¿He² løa¹ mi³gagh¹³ hniah¹² jní²? Dsa² ta¹cah¹ ta¹jen¹² báh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gu³quin³ cøng² ŋi³néng² ju³lah lǿa¹² ŋi³néng² cagh¹² rai¹³, hi² mi³jái¹³jni ―ca¹juúh²dsa. Jøng² ca¹ŋi³quín³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jøng² ca¹juúh² Jesús: ―¿Hein² nióh³ quiah¹² rø²ton¹² ŋi³néng² la²? ¿Hein² jmai³ rø²ton¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jøng² ca¹juúh² dsa² héi²: ―Nióh³ quiah¹² rai¹³ romano báh³ jøng², ca¹lah¹quianh¹³ jmai³dsa ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Hi² jøng² dsio¹ mi³tih³ hniah¹² ja³cog² rai¹³ ju³lah lǿa¹² jǿg³ quiah¹² rai¹³. Jøng² dsio¹ mi³tih³ hniah¹² ja³cog² Diú¹³ calah ju³lah lǿa¹² jǿg³ quiah¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mi³ca¹nǿng² dsa² héi² jǿg³ jøng², dsogh¹² báh³ dsǿa¹²dsa. Jøng² ca¹ŋi¹lia¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jmai³ jøng² ca¹dsi¹lé² ca²dsiog³ dsa² saduceo ja³tsenh¹³ Jesús, dsa² juúh² tsa¹hiog¹ jmi²dsí². Jøng² ca¹ŋǿh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ca¹juúh²dsa: ―Tøa¹², lah¹la² lǿa¹² si² ca¹jmo¹ hlai³ Moisés: Ju³ná³ jan² dsa² ca¹jon¹, chian² báh³ hio¹³ quián¹²dsa, ha¹chian² guing² ma²chian² quián¹²dsa, jøng² hniuh¹² báh³ hi² jian¹ roh¹³ hlai³, dsa² ma²jon¹³, hio¹³ héi². Mi³jøng² li¹chian² tsø³jong¹³ hlai³, hi² lǿa¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jøng² ja³tiagh³ jnieh³ mi³chian² guiog¹ dsa² ŋioh¹², dsa² lán¹² roh¹³dsa. Dsa² ne¹³ ca¹jian¹ hio¹³. Jøng² ca¹jon¹dsa, ha¹chian² jong¹²dsa chian². Ni² jøng² ca¹jian¹ dsa² ja³ma²og¹ hio¹³ quián¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jø¹² bíh³ ca¹jon¹ dsa² héi², ha¹chian² jong¹²dsa ca¹lø¹chián¹. Jø¹ bíh³ lah¹jøng² ca¹løa¹ quiah¹² dsa² ja³ma²úg² calah siíh². Lah¹jøng² báh³ ca¹ŋi¹ŋë́² ca¹lah¹ta³guiog¹ dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ni³ jøng² ca¹jon¹ calah hio¹³ hŋiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jøng², ¿hein² dsa² ŋioh¹² li¹quián¹² hio¹³ na³ma²tǿ² ja³ca¹hiog²dsa. Di³ ca¹lah¹jǿ¹ guiog¹ báh³ dsa² ŋioh¹² ca¹jian¹ hio¹³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² saduceo héi²: ―Dsa²gán² hoh¹² báh³ hniah¹². Di³ tsa¹cuéh² hniah¹² si² quiah¹² Diú¹³. Tsa¹lë́h² hniah¹² chi² bí² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Di³ ha¹chian² hio¹³ jian¹ dsa² ŋioh¹² na³ma²tǿ² ja³ca¹hiog²dsa. Ha¹chian² dsa² ŋioh¹² jian¹ hio¹³. Di³ ma²lán¹²dsa jmai³ jøng² ju³lah lán¹² ángeles tiogh³ ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jøng² jǿg³ jøng² hi² hiog²dsa, ¿he² løa¹ tsa¹ma²ca¹híh² hniah¹² cu²rø² si² quiah¹² Diú¹³? ");
INSERT INTO cpaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Lah¹la² rø²juúh² si²: “Jní² báh³ Diú¹³ quián¹² hlai³ Abraham, Diú¹³ quián¹² hlai³ Isaac, Diú¹³ quián¹² hlai³ Jacob,” rø²juúh² si². Jøng² ma²ŋih³ hniah¹² hiog¹ dsa² úg² héi². Di³ ha¹chi² quián¹² Diú¹³ dsa² tsa¹ma¹chian². Dsa² chian² báh³ quián¹² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jøng² ca¹lø¹dsogh¹² dsǿa¹² dsa² jue¹² mi³ca¹nǿng²dsa jǿg³ jøng², hi² ca¹he¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jøng² ca¹túgh² dsa² fariseo ja³tsenh¹³ Jesús, mi³ca¹lø¹ŋi¹²dsa ca¹tiúh¹ Jesús dsii¹² jǿg³ quianh¹³ dsa² saduceo. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jøng² ca¹ŋǿh¹ jan² dsa² héi² Jesús, jan² dsa² lán¹² tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Hniu¹dsa cán²dsa jǿg³ dsøg¹² quiah¹² Jesús. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tøa¹², ¿naih¹² lei¹³ quin¹² ni³ cónh¹ ja³ca¹lah¹jǿ¹ lei¹³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jøng² ca¹juúh² Jesús: ―“Mi³hnóh¹hning Juuh²hning, Diú¹³ quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ hoh¹²hning, quianh¹³ ca¹lah¹jǿ¹ jmi²dsí² quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ hi² dsa²jiag¹² hoh¹²hning.” ");
INSERT INTO cpaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lei¹³ jøng² báh³ quin¹² ni³, lei¹³ juøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jøng² chi² báh³ jín³ cøng² lei¹³, mih² tsa¹cu²rø². Lah¹la² báh³ lǿa¹² lei¹³ ja³ma²ton¹: “Mi³hnóh¹hning dsa² jmøi¹guǿi¹ jianh¹²hning, ju³lah hnóh¹hning hŋiah¹hning.” ");
INSERT INTO cpaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ton¹ lei¹³ jøng² báh³ ma²lǿa¹² chiúh³ quiah¹² ca¹lah¹jǿ¹ lei¹³ ca¹quieg² hlai³ Moisés quianh¹³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ta³lah¹tiogh³ dsa² fariseo ja³jøng², ca¹ŋǿh¹ Jesús dsa² héi² cøng² jǿg³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Ha²lah lë́h² hniah¹² quianh¹³ Cristo? ¿Hein² tsø³jong¹³ lán¹²dsa? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Tsø³jong¹³ hlai³ David báh³ Cristo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jøng² ca¹juúh² Jesús calah: ―¿He² løa¹ ca¹jmo¹ Diú¹³ dsǿa¹² hlai³ David, hi² ca¹tǿh¹dsa Cristo juu³dsa, chi²júh² lán¹² Jesús tsø³jong¹³ hlai³ David? Lah¹la² ca¹juúh² hlai³ David: ");
INSERT INTO cpaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ca¹tsáih¹ Juu¹³ jniang³ Juu¹jni: “¡Ní² cog²jni ta¹guia¹jo¹³, ca¹lah¹ca¹tǿ² jmai³ ja³ca¹jmo¹jni ca¹tiah¹hning quianh¹³ dsa² hiag¹³ quiánh²hning!” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hŋiah¹² báh³ hlai³ David ca¹tǿh¹ Cristo juu³dsa. ¿Ha²lah lǿa¹² jøng² hi² lán¹² Cristo tsø³jon² quiah¹²dsa? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jøng² tsa¹ca¹tiúh¹ dsa² héi² ŋai¹ jǿg³ ca¹juúh² Jesús. Ni³ jøng² ha¹chian² dsa² siáh² ma¹tí² dsǿa¹² hi² ŋai¹dsa jin³ cøng² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quián¹²dsa ca¹lah¹quianh¹³ dsa² jue¹²: ");
INSERT INTO cpaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Lán¹² tøa¹² he¹² lei¹³ ca¹lah¹quianh¹³ dsa² fariseo dsa² he¹² jǿg³ ha²lah lǿa¹² lei¹³ ca¹quieg² hlai³ Moisés ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dsio¹ báh³ mi³gǿgh³ hniah¹² ca¹lah¹jǿ¹ jǿg³ he¹² dsa² héi². Dsio¹ báh³ mi³tih³ hniah¹² jǿg³. Cónh¹jøng² tsa¹jmóh³ hniah¹² ju³lah jmo¹²dsa. Di³ ha¹chi² mi²ti¹dsa guiog¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Di³ ué² jmo¹²dsa ja³mi¹ti¹ dsa² siáh² lei¹³. Jøng² tsa¹hiei¹dsa mi¹ti¹dsa guiog¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hniu¹dsa jái¹ dsa² jue¹² ja³jmo¹²dsa hi² dsio¹. Jai³lah juøh¹² gog¹² tiun¹²dsa dsi³qui¹²dsa quianh¹³ gug²dsa, gog¹² tioh¹³ ca²jneh³ si² quiah¹² Diú¹³. Jláh³ jmo¹²dsa hmøah¹² caih¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hniu¹dsa tógh¹dsa ja³jláh³ ja³jmo¹² dsa² jmai³ quianh¹³ dsi²néi² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hi² hniu¹dsa mi¹juanh¹² dsa² jue¹² ja³ŋi²nio³dsa jøa³hmah³. Hi² hniu¹dsa juúh² dsa² jue¹²: “Tøa¹².” ");
INSERT INTO cpaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Di³ jøng² tsa¹jmóh³ hniah¹² hi² juúh² dsa² jue¹² hi² lanh¹² hniah¹² tøa¹² quián¹²dsa. Di³ jan² báh³ dsa² lán¹² tøa¹² quiánh² hniah¹². Ca¹lah¹já¹ dsa² ná¹² lán¹² rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jø¹² bíh³ tsa¹tøah¹³ hniah¹² dsa² jmøi¹guǿi¹ “Jmi² jniang³.” Di³ jan² báh³ Jmi² jniang³ chian², Diú¹³ guǿ¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jø¹² bíh³ tsa¹jmóh³ hniah¹² hi² juúh² dsa² jmøi¹guǿi¹ hi² lanh¹² hniah¹² juu³dsa. Di³ jan² báh³ Juuh² hniah¹² chian². Cristo báh³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dsa² héi² báh³ lán¹² dsa² juanh¹² quiánh² hniah¹², dsa² mi²ti¹ neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dsa² meh² báh³ lén² dsa² jmo¹² juanh¹²dsa. Jøng² dsa² juanh¹² báh³ lén² dsa² jmo¹² hi² meh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Jnëh¹³ hniah¹² juu¹² ja³dsa¹lé²dsa ja³jmo¹² Diú¹³ héh¹. Guiogh¹³ báh³ hniah¹² tsa¹hnøngh² gu³noh¹² juu¹² jøng². Tsa¹cuuh² hniah¹² jǿg³ dsa¹lé² dsa² hniu¹ dsa¹lé². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo ca¹lah¹quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ tí² hoh¹² hniah¹² cángh³ hniah¹² hniu³ dsa² hnǿi². Jøng² hlanh¹³ hniah¹² Diú¹³ ma¹dsio¹² jǿg³ hi² ta³hoh¹² hniah¹². ¡Hiug¹² jín³ ma¹dsio¹² ta¹canh¹³ báh³ hniah¹²! ");
INSERT INTO cpaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡He³ báh³ ué² lé² quianh¹³ hniah¹² dsa² fariseo ca¹lah¹quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ ŋi²nioh³ hniah¹² ta³cøng² jmøi¹guǿi¹, hnangh¹² hniah¹² dsa² ŋi³nioh¹² hniah¹² quianh¹³. Jøng² na³ma²ca¹hé¹dsa jǿg³ quiánh² hniah¹², jøng² jmóh³ hniah¹² hi² lén² dsa² héi² dsa² ta¹canh¹³ tsug¹² jín³ dsag³ cónh¹ jín³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡He³ báh³ ué² lé² quiánh² hniah¹²! Lanh¹² hniah¹² ju³lah dsa² teg³. Tsa¹lé² héh³ hniah¹² juu¹² cu²rø². Di³ juúh² hniah¹² tsa¹tiog¹³ hniuh¹² mi¹ti¹ jan² dsa² jǿg³ ma²ca¹juúh²dsa, ju³ná³ jmáh¹lah guøh¹² báh³ ca¹he¹dsa ja³ca¹mi¹dsøg¹²dsa jǿg³ quiah¹²dsa. Jøng² juúh² hniah¹² hi² hniuh¹² báh³ mi¹ti¹dsa, ju³ná³ ca¹he¹dsa cog³niáng¹³ chi³lai¹ guøh¹² ja³ca¹mi¹dsøg¹²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡He³ báh³ tsa¹juøi² hoh¹² hniah¹²! ¡Tegh³ hniah¹²! Di³ guøh¹² báh³ quien¹² cónh¹ jín³ cog³niáng¹³ hi² chi³lai¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jø¹² bíh³ juúh² hniah¹² tsa¹tiog¹³ hniuh¹² mi¹ti¹ jan² dsa² jǿg³ ma²ca¹juúh²dsa, ju³ná³ jmáh¹lah ni³hiég² báh³ ca¹he¹dsa ja³ca¹mi¹dsøg¹²dsa jǿg³ quiah¹²dsa. Jøng² juúh² hniah¹² hi² hniuh¹² báh³ mi¹ti¹dsa, ju³ná³ ca¹he¹dsa hi² ma²tioh¹³ ni³ ni³hiég², ju³lah hi² ma²ca¹dsii¹dsa gug² tai³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lanh¹² hniah¹² ju³lah lán¹² dsa² teg³. Di³ ni³hiég² báh³ jmo¹² hi² ma²ha¹³ hi² tioh¹³ ni³ ni³hiég². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hi² jøng² ju³ná³ hein² dsa² ca¹he¹ ni³hiég² ja³ca¹mi¹dsøg¹²dsa cøng² jǿg³ quiah¹²dsa, jøng² ma²lǿa¹² ca¹lah¹cøng² hi² ca¹he¹dsa cu¹dsie¹² ni³hiég² ca¹lah¹ma¹quianh¹³ hi² tioh¹³ ni³ ni³hiég². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jø¹² bíh³ ju³ná³ ca¹he¹ jan² dsa² guøh¹² ja³ca¹mi¹dsøg¹²dsa cøng² jǿg³ quiah¹²dsa, ma²lǿa¹² ca¹lah¹cøng² hi² ca¹he¹dsa cu¹dsie¹² guøh¹² ca¹lah¹ma¹quianh¹³ Diú¹³, dsa² quiah¹² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jøng² ju³ná³ ca¹he¹ jan² dsa² ŋi¹juǿi¹ ja³ca¹mi¹dsøg¹²dsa cøng² jǿg³ quiah¹²dsa, jøng² ma²lǿa¹² ca¹lah¹cøng² hi² ca¹he¹dsa cu¹dsie¹² ja³guǿ¹³ Diú¹³ ca¹lah¹ma¹quianh¹³ Diú¹³ hŋiah¹², dsa² guǿ¹² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo, ca¹lah¹quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ cu²rø² cuuh² hniah¹² hi² dsiúg³ Diú¹³ ja³ma²guie¹ ca¹lah¹cónh¹ ja³té¹² ca¹lah¹i³ ni³ nung² chi² quiánh² hniah¹², ju³lah u²mong³ quiah¹² ca³juu², ju³lah høg² anís, ju³lah mǿi² quiah¹² má¹. Cónh¹jøng² ha¹chi² mi³tih³ hniah¹² lei¹³ hi² lah¹dsóh² quien¹². Tsa¹mi³rǿh³ hniah¹² cu²rø² jǿg³. Tsa¹dsa²ŋiú² hoh¹² hniah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Tsa¹té¹² jagh³ hniah¹². Jøng² mi³dsio¹ ju³ jøng² ca¹mi³tih³ hniah¹² ca¹lah¹jǿ¹ hi² jøng² cu¹dsie¹² ca¹lah¹quianh¹³ hi² ma²mi²tih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lanh¹² hniah¹² ju³lah lán¹² dsa² teg³ he¹² juu¹². Lanh¹² hniah¹² ju³lah lán¹² jan² dsa ca¹leh¹² jáh² píh³ mi³hiúg³ jmøi² hǿnh²dsa. Jøng² tsa¹ca¹len¹²dsa jáh² juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo, quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ cu²rø² rangh² hniah¹² coh¹³ cuøh³ quianh¹³ coh¹³ uøin¹². Lanh¹² hniah¹² ju³lah lǿa¹² cuøh³ uøin¹². Cónh¹jøng² jmáh¹lah jǿg³ hlaih¹³ ma²dsø²jiag¹² hoh¹² hniah¹² ha²lah léh² hniah¹² hi² chi² quiah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lanh¹² hniah¹² ju³lah lán¹² dsa² teg³. Dsio¹ báh³ rangh² hniah¹² ta¹lah¹niúh¹ cuøh³ lah¹ni³. Ni³ jøng² báh³ lé² ti³jai¹ ta¹lah¹coh¹³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo, ca¹lah¹quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ lanh¹² hniah¹² ju³lah lǿa¹² ja³rø²hog¹² hlai³ ma²hiu³ hen¹² teg² coh¹³. Di³ jøng² tioh¹³ jmáh¹lah mu² hlai³ quianh¹³ ca¹lah¹jǿ¹ ni³ hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lah¹jøng² báh³ lanh¹² hniah¹². Ca¹lah¹cøng² hi² dsiogh¹ báh³ hniah¹² jniáh² hniah¹² ta¹lah¹coh¹³. Jøng² jmáh¹lah jǿg³ hlaih¹³ báh³ dsø²jiag¹² hoh¹² hniah¹², quianh¹³ jǿg³ ta³jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo, ca¹lah¹quianh¹³ dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ta¹cah¹ ta¹jen¹²! Di³ tsǿh² hniah¹² hieh¹² ja³rø²hog¹² hlai³, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jøng² jmóh³ hniah¹² chi³lai¹ hieh¹² ja³rø²hog¹² hlai³, dsa² dsiog¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jøng² juúh² hniah¹²: “Ju³jmai³ jniang³ dsa² mi³chian² dsa² hóg¹ quián² jniang³ ma²lǿih², ha¹chi² mi³li¹hiug² dsǿa¹² jniang³ hi² mi³mi³dsian¹³ jniang³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³,” juúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hi² jøng² mi²leih¹³ hniah¹² hi² guiogh¹³ hniah¹² lanh¹² tsø³jong¹³ dsa² ca¹mi¹dsian¹² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hi² jøng² dsio¹ mi³hianh¹³ hniah¹² hi² hlaih¹³ ca¹mi¹liág¹ dsa² hóg¹ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lanh¹² hniah¹² ju³lah lán¹² møh², jáh² hlanh³. Tsa¹lé² liúgh² hniah¹², mi³jøng² tsa¹mi³dsiánh¹ Diú¹³ hniah¹² juu¹² guio¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jøng² tsë́³jni dsa² hǿ² jǿg³ quiah¹² Diú¹³, ca¹lah¹quianh¹³ dsa² ŋi¹², ca¹lah¹quianh¹³ tøa¹² he¹² lei¹³. Jøng² mi³dsianh¹³ hniah¹² ca²dsiog³ dsa² héi². Tónh³ hniah¹² dsa² crǿg¹³ ca²dsiog³dsa. Báh³ hniah¹² dsa² dsi²néi² guøh¹² ca²dsiog³dsa. Mi³dsianh¹³ hniah¹² dsǿa¹²dsa ca¹lah¹jǿ¹ juøi² ja³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta¹canh¹³ báh³ hniah¹² dsag³ hi² ca¹dsan¹ dsa² dsiog¹ ni³ jmøi¹guǿi¹, ca¹lah¹cónh¹ jmai³ ja³ca¹jŋëh¹dsa hlai³ Abel, dsa² dsiog¹, ca¹tǿ² jmai³ ja³ca¹jŋëh¹dsa hlai³ Zacarías, jong¹² Berequías, dsa² ca¹jon¹ jøa³ ja³tsih¹³ guøh¹² ca¹lah¹quianh¹³ ja³tsih¹³ ni³hiég². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lah¹dsóh² juǿi²jni hniah¹²: Dsa² chian² na¹ ta¹canh¹³ dsag³ ni³ huu¹³ ca¹dsan¹ ca¹lah¹já¹ dsa² dsiog¹ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Hniah¹², dsa² chianh² Jerusalén, hniah¹² dsa² mi²dsianh¹³ dsa² hǿ² jǿg³ quiah¹² Diú¹³, hniah¹² dsa² qui²togh³ dsa² ca¹tse¹ Diú¹³ cang³, hliú² rón² mi³li¹quianh¹³jni hniah¹² ju³lah jan² chi³chiih³ togh¹² guing² quián¹² niúh¹ cog¹². Jøng² ha¹chi² ca¹lø¹hnǿngh¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma²ca¹tiúg² Diú¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹lǿih² jmai³ ma²jaih³ hniah¹² jní² ca¹lah¹ja³ca¹dsiég¹ jmai³ ja³juúh² hniah¹²: “¡Hiug¹² juanh¹² dsa² já¹² ni³ huu¹³ quiah¹² Juu¹³ jniang³!” juúh³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jøng² ma²hiúg³ Jesús juu¹² u¹hái¹dsa ja³tsih¹³ guøh¹², mi³ca¹túgh² dsa² quianh¹³dsa ja³tsenh¹³dsa. Ca¹heh¹dsa Jesús ha²lah jní² dsio¹ guøh¹² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Jií¹ jmai³ ja³gug¹ ca¹lah¹jǿ¹. Ca¹lah¹jin³ cøng² mǿi² cang³ guøh¹² ná¹² tsa¹ma¹ti³juú¹³ lé² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mi³ca¹dsi¹lé²dsa máh² Olivo, ca¹gú² Jesús ja³jøng². Jøng² túgh² dsa² quianh¹³dsa cog² Jesús ja³cu³guiog¹³dsa. Jøng² ca¹juúh² dsa² quianh¹³dsa: ―Heh¹³hning jnieh³ jǿg³ ha²lǿih² lé² lah¹jøng². ¿He² quianh¹³ li¹lih¹³ jnieh³ ha²lǿih² ŋieh¹³hning calah? ¿Ha²lǿih² lé² jmai³ ja³dsiá¹ jmøi¹guǿi¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jøng² ca¹juúh² Jesús: ―Jmo³ ju²hí³ dsøa¹² tsa¹ju³mi¹gan¹² dsa² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Di³ jue¹² dsa² ji¹lé², dsa² jmo¹ hi² lán¹²dsa jní². Juúh²dsa: “Jní² báh³ lán¹² Cristo,” juúh²dsa. Jøng² mi¹ga¹²dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na³ma²ca¹nengh² hniah¹² jǿg³ jmo¹²dsa hning², ho¹ ju³ chi² jǿg³ jmo¹²dsa hning² ja³siíh³, jǿg³ dsii¹² dsa², jøng² tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹². Di³ lah¹jøng² báh³ hniuh¹² lé². Di³ ha¹chi² ma²tǿ² ja³dsiá¹ jmøi¹guǿi¹ mi³né³. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jøng² tán¹ juøi² quianh¹³ juøi² siíh². Tán¹ dsa² ta³ quianh¹³ dsa² ta³ jian¹²dsa. Jøng² hliú² ja³tiíh¹ onh¹². Jií¹ hag³cón² ca¹lah¹quianh¹³ hliú² ni³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lah¹jøng² báh³ lé² ja³li¹liág¹ jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jë́h²dsa hniah¹² hi² he¹dsa jmø³uai¹², hi² mi¹dsian¹²dsa hniah¹². Jøng² li¹hiag¹³ ca¹lah¹já¹ dsa² ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jøng² jue¹² dsa² tiú¹ jǿg³ quieg¹jni. Jøng² hnë¹dsa roh¹³dsa. Li¹hian¹³dsa roh¹³dsa guiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jøng² li¹chian² dsa² jue¹², dsa² he¹ jǿg³ tsa¹té¹². Mi¹gan¹²dsa dsa² jue¹² chian² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsa¹ma¹hnio¹ dsa² jue¹² dsa² jmøi¹guǿi¹ jian¹²dsa lé². Di³ li¹chi² ma¹dsio¹² hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jøng² liúg² báh³ dsa², ju³lah hein² dsa² ca¹mi¹tián² dsǿa¹² ca¹lah¹ca¹tóh² jø² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hniuh¹² báh³ tsø¹ja¹ jǿg³ dsio¹ ta³cøng² jmøi¹guǿi¹, jǿg³ quiah¹² ja³jmo¹² Diú¹³ héh¹. Mi³jøng² li¹ŋi¹² ca¹lah¹já¹ dsa² chian². Ni³ jøng² tiúh¹ jø² jmai³ quiah¹² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Jmai³ jøng² jáih³ hniah¹² hi² hiug¹² hlaih¹³ tø¹tsǿh² dsi²néi² guøh¹², ja³hiug¹² han¹³, hi² jmo¹ dsa¹hén² ca¹lah¹jǿ¹, ju³lah rø²juúh² si² quiah¹² hlai³ Daniel, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. (¡Ju³ li¹ŋë́² dsa² høa¹² si² la²!) ");
INSERT INTO cpaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na³ma²ca¹jaih³ hniah¹² hi² jøng², jøng² dsio¹ cuøin¹ dsa² chian² Judea juu¹² máh². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jøng² ju³ná³ hein² dsa² tiogh³ ja³dsi¹² jmai³ jøng², ju³ cuøin¹³dsa cu¹dsøg¹². Tsa¹ju³dsi¹quín²dsa hi² chi² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jøng² ju³ná³ hein² dsa² tiogh³ jøa³nung² quiah¹², tsa¹ju³dsi¹lia²dsa, hi² dsa¹quín²dsa tsǿnh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡He³ báh³ ué² jmai³ jøng² quiah¹² hio¹³ ti³quian¹² guing²! ¡Ué² quiah¹² dsa² jian¹² guing² píh³! ");
INSERT INTO cpaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jøng² hlanh¹³ hniah¹² Diú¹³ hi² tsa¹ju³lé³ hi² jøng² jmai³ sa³¹, ho¹ ju³ jmai³ jin² guǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Di³ hiug¹² jín³ jmø³uai¹² hí¹ jmøi¹guǿi¹ jmai³ jøng² cónh¹ jín³ jmø³uai¹² ma²ca¹hí¹ cónh¹ jmai³ ja³ma²ca¹niu¹ jmøi¹guǿi¹ ca¹lah¹ca¹tǿ² jín³ na¹. Jø¹² bíh³ ha¹chi² ma¹hí¹ jmø³uai¹² hiug¹² lah¹jøng² jmai³ siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jøng² ha¹chian² dsa² mi³liúg² jmai³ jøng² ju³ jmai³ tsa¹ca¹jné¹ Juu¹³ jniang³ ta¹jiá¹². Di³ huu¹³ quiah¹² dsa² ti³quióh³ ca¹jné¹ Diú¹³ jmai³ jøng² ta¹jiá¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Jøng² ju³ná³ hein² dsa² ca¹juúh²: “Jai³lah, dsa² lang¹² báh³ Cristo,” ho¹ ju³ ca¹juúh²dsa: “Dsa² ná¹² báh³ Cristo,” jøng² tsa¹ju³héh³ hniah¹² jǿg³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Di³ li¹chian² báh³ dsa² mi¹gag¹², dsa² juúh² lán¹²dsa Cristo, ho¹ ju³ dsa² juúh² lán¹²dsa dsa² hǿ² jǿg³ ni³ huu¹³ quiah¹² Diú¹³. Jmo¹ báh³ dsa² héi² hi² hiug¹²dsa quianh¹³ juu¹² juøh¹² quianh¹³ hi² gøg². Mi³mi¹ga¹²dsa dsa² ma²ti³quióh³ quián¹² Diú¹³ ju³ jmai³ hi² lé². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jai³lah, lah¹jiá¹² ma²ca¹juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ju³ná³ hein² dsa² juúh²: “Ja³ná³ guǿ¹² Cristo, juu¹² ja³ha¹chian² dsa² tiogh³,” jøng² tsa¹gu³noh¹² hniah¹² ja³jøng². Ju³ná³ hein² dsa² juúh²: “Ja³ná³ guǿ¹²dsa, ja³quiunh³,” jøng² tsa¹ju³héh³ hniah¹² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di³ ju³lah lǿa¹² si² ŋíh¹ taih¹² ta³cøng² dsøa³ hei¹² guiuh¹³, lah¹jøng² báh³ lé² jmai³ ja³guiogh¹³jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Li¹lih¹³ báh³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lah¹dsóh² li¹léi¹³ na³ma²ca¹tǿ² ja³guiogh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Dsø¹juu¹² mi³ma²ca¹tsø³jue¹³ jmø³uai¹², jøng² nioh¹ hieg². Tsa¹ma¹taih¹² quiah¹² tsøh². Jøng² siúgh² chi³neng¹² ti³buh¹² guiuh¹³. Hiánh² hi² ti³dsøa¹³ guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jøng² li¹léi¹³ dsi³guøi² hi² ma²guiogh¹²jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jøng² ho¹ dsa² chian² ta³cøng² jmøi¹guǿi¹. Jøng² jǿi²dsa jní², ma²guiogh¹²jni jøa³jneng¹². Ma²chi² bí² ma¹dsio¹² hlaih¹³ quieg¹jni. Ma²léi¹³ hi² hiug¹² juanh¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jøng² hein¹³ tí² løg¹² quiah¹² Diú¹³. Jøng² tsë́³jni ángeles ta³cøng² jmøi¹guǿi¹, hi² dsa²tiogh¹²dsa loh² dsa² ma²ti³quióh³ quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ma²ŋih³ hniah¹² ha²lah lǿa¹² quiah¹² hma² higo. Na³ma²tsíh² nih¹³ hma², na³ma²hiag¹³ moh¹³, ma²ŋih³ hniah¹² ja¹quién¹ jií¹ jin² jmǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jø¹² bíh³ lah¹jøng² li¹leh¹³ hniah¹² na³ma²tǿ² ja³ja¹quien¹³ lé² ca¹lah¹jǿ¹ hi² jøng², na³ma²jaíh² hniah¹² hi² ma²lǿ² lah¹jøng² ju³lah ma²na²juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹jín³ dsiá¹ dsa² chian² na¹ niúh¹ jín³ hi² lé² lah¹jøng² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dsa¹hén² báh³ jmøi¹guǿi¹ lah¹quianh¹³ dsøa³ hei¹² guiuh¹³. Di³ ha¹chi² dsa¹hén² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Jøng² ha¹chian² dsa² ŋi¹² he² jmai³ he² hora lé² lah¹jøng². Ca¹lah¹jin³ ángeles chian² ŋi¹juǿi¹ tsa¹ŋi¹². Ca¹lah¹jin³ jní², jong¹² Diú¹³, tsa¹guiang³jni. Jan² Jmi² jniang³ báh³ ŋi¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lah¹jøng² báh³ lé² jmai³ ja³guiogh¹³jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah ca¹løa¹ jmai³ mi³chian² hlai³ Noé. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jmo¹dsa ju³lah ca¹jmo¹ dsa² mi³chian² niúh¹ jmai³ ja³ca¹cangh¹² jmøi² jmøi¹guǿi¹. Cøng² ca¹cø² ca¹hǿnh² báh³ dsa². Ca¹jenh²dsa gug². Ca¹cuan¹dsa jong¹²dsa ca¹jenh² gug²dsa. Lah¹jøng² ca¹jmo¹dsa ca¹tǿ² jmai³ ja³ca¹hí¹ Noé barco juøh¹² ca¹jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ha¹chi² ca¹lø¹ŋi¹² dsa² jue¹² hi² lé² jmøi² juøh¹² ca¹lah¹ca¹tǿ² ja³ca¹ŋi¹juøh¹² jmøi². Ca¹dsan¹ ca¹lah¹já¹ dsa² héi² quianh¹³ jmøi² juøh¹² jøng². Lah¹jøng² báh³ jenh¹³ dsa² chian² jmai³ ja³guiogh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jmai³ jøng² lé² hi² tiogh³ og¹ dsa² ŋioh¹² jøa³nung². Jan² dsa² tai¹ Diú¹³. Jan² dsa² jŋi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jø¹² bíh³ lé² hi² tiogh³ og¹ hio¹³ ieih¹² hé¹². Tai¹ Diú¹³ jan². Jøng² jŋi¹ jan². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mi³lih¹³ hniah¹² hoh¹². Di³ tsa¹ŋih³ hniah¹² he² jmai³ guiogh¹³jni, jní² dsa² lán¹² Juuh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma²ŋih³ hniah¹² ha²lah lán¹² dsa² hniu³. Ju³ jøng² ca¹lø¹ŋi¹² dsa² hniu³ he² hora jií¹ dsa² høin², jøng² mi³guú¹dsa ju³jŋia¹³. Mi³jøng² tsa¹mi³hí¹ dsa² høin² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Di³ jøng² túgh³ hniah¹² ju³jŋia¹³. Guiogh¹³ báh³ jní² cónh¹ tsa¹ju²jŋiá³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Dsa² lán¹² dsa² ti³té¹³ jǿg³, dsa² ŋi¹², ju³lah dsa² ma²neng¹² gug² ta³ ma²ca¹cuø¹ juu³dsa, hi² dsiúh¹dsa hi² gǿh¹ dsa² quián¹² juu³dsa lah¹cøng² lah¹cøng² jmai³, ");
INSERT INTO cpaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","dsa² héi² báh³ dsa² lé² dsio¹ quiah¹², dsa² ma²mi²ti¹ ta³ na³ma²guønh¹² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lah¹dsóh² juǿi²jni hniah¹²: Ju²gug² tai³ dsa² lah¹héi² dsie¹ juu³dsa ca¹lah¹jǿ¹ hi² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jøng² ju³ná³ hlanh³dsa, jøng² lë́²dsa hi² li¹han³ juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jøng² qui¹jmóh²dsa uai¹² dsa² tiogh³ jmo¹² ta³ quiah¹² juu³dsa. Jøng² cø²hǿnh²dsa quianh¹³ dsa² hen¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jøng² jiúgh² juu³ dsa² ŋioh¹² héi² cónh¹ tsa¹ju²jŋiá³, jmai³ ja³tsa¹lë́² dsa² ŋioh¹² jiúgh²dsa, hora tsa¹ŋi¹² dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jøng² cuø¹ juu³dsa ju²lih¹³ dsøa¹². Tiagh¹dsa juu¹² ja³tiogh³ dsa² ta¹cah¹ ta¹jen¹². Ja³jøng² dsø¹tø² dsø¹hǿg²dsa. Cán²dsa ma¹dsio¹² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² guia¹ tsih²mǿ² ca¹cán² si² jmø²cøg², hi² ma²chi³hiúh² si². Jøng² ca¹ŋi¹lé²dsa hi² mi³jén²dsa dsa² ŋioh¹² ma²na²jenh² gug². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hŋiá² tsih²mǿ² héi² lán¹² dsa² tsa¹juøi² dsǿa¹². Hŋiá² dsa² lán¹² dsa² të². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tsih² tsa¹juøi² dsøa¹² ha¹chi² jmø²cøg² ma¹dsio¹² quin¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Di³ jøng² quin¹² tsih² ma²lih¹³ dsǿa¹² ja³ha¹² hi³méh¹ jmø²cøg². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ca¹lø¹han¹ dsa² ŋioh¹². Jøng² ca¹løa¹ lø¹i³güé¹ tsih²mǿ². Jøng² ca¹güe² ca¹lah¹já¹tsih. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jøng² jan² dsa² ca¹hløah¹ tí² cónh¹ dsi¹neng¹². Ca¹juúh²dsa: “¡He³ dsa² ŋioh¹² ŋi³jogh¹²! ¡Hiugh¹²! ¡Gu³noh¹² hniah¹²! ¡Gu³mi³jénh³ hniah¹² dsa²!” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jøng² ca¹rón² ca¹lah¹já¹ tsih²mǿ² héi². Jøng² ca¹jmóh¹dsa cu²rø² si² jmø²cøg² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jøng² ca¹juúh² tsih²mǿ² tsa¹juøi² dsǿa¹², ca¹tsáih¹dsa dsa² të²: “Cuøh¹³ hniah¹² jnieh³ mih² jmø²cøg² quiánh² hniah¹². Di³ ma²dsø²iég¹ si² quián² jnieh³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jøng² ca¹juúh² tsih²mǿ² të²: “Tsa¹lé² cuú³ jnieh³. Di³ tsa¹len¹² quián² ca¹lah¹jái¹ jniang³. Gu³lié¹ jmø²cøg² ja³hnai¹dsa,” ca¹juuh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jøng² mi³ca¹ŋi¹lé² tsih²mǿ² tsa¹juøi² dsǿa¹², ca¹guøn¹ dsa² ŋioh¹² ma²na²jenh² gug². Jøng² ca¹ŋi¹lé² hŋiá² tsih²mǿ² të² héi² juu¹² dsi²néi² ja³jmo¹²dsa jmai³ ca¹jenh² gug² dsa² ŋioh¹². Jøng² ca¹jnéi¹dsa hag³hniú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ni³ jøng² ca¹dsi¹lé² hŋiá² tsih²mǿ² tsa¹juøi² dsǿa¹² héi². Ca¹juúh²dsa: “Guiuh¹³, ¡nie³ hniú¹²!” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jøng² ca¹juúh² dsa² ŋioh¹², ca¹tsáih¹dsa tsih²mǿ² héi²: “Lah¹dsóh² tsa¹cué¹²jni hniah¹²,” ca¹juúh² dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hi² jøng² mi³lih¹³ hniah¹² hoh¹². Di³ tsa¹ŋih³ hniah¹² he² jmai³ he² hora guiogh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Lah¹jøng² báh³ lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan³ dsa² ca¹ŋó¹ juu¹² ja³uǿin³. Jøng² niúh¹ jín³ hi² ca¹ŋó¹dsa, ca¹tǿh¹dsa dsa² jmo¹² ta³ quiah¹²dsa. Jøng² ca¹dsii¹dsa gug² tai³ dsa² héi² ca²tí² ca¹lah¹jǿ¹ hi² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ca¹jáinh¹dsa to¹lu¹guií² mei¹³ héh¹ cog³ quiah¹² dsa² lah¹ni³. Ca¹jáinh¹dsa guiég² mei¹³ quiah¹² dsa² ja³ma²og¹. Ca¹jáinh¹dsa guie¹ mei¹³ quiah¹² dsa² ja³ma²úg². Ca¹jáinh¹ juu³dsa ca¹lah¹cónh¹ ja³ma²të²dsa ta³ lah¹jan² lah¹jan²dsa. Jøng² ca¹ŋó¹ juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dsø¹juu¹² ca¹ŋi¹jmó² dsa² lah¹ni³ ta³ quianh¹³ cog³ jøng². Ca¹lǿh¹dsa jín³ to¹lu¹guií² mei¹³ héh¹ cog³. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jøng² dsa² ja³ma²og¹ ca¹lǿh¹ jín³ guiég² mei¹³ héh¹ cog³. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Di³ jøng² ca¹ŋó¹ dsa² ja³ma²úg². Ca¹ŋi¹guiég²dsa tøg² ja³ca¹hma¹dsa cog³ quiah¹² juu³dsa niúh¹ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ma²ni³ŋó¹³ jmai³ mi³ca¹guøn¹ juu³ dsa² héi². Jøng² ca¹can¹ juu³dsa jǿg³ dsøg¹² quiah¹² dsa² jmo¹² ta³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lah¹ni³ ca¹dsiég¹ dsa² ca¹hiei¹ to¹lu¹guií² mei¹³ héh¹ cog³. Ma²quin¹²dsa jín³ to¹lu¹guií² mei¹³ jmáh¹lah jong¹². Jøng² ca¹juúh² dsa² héi²: “Guiuh¹³, ca¹cuøh¹³hning jní² to¹lu¹guií² mei¹³ héh¹ cog³. Jai³lah ma²ca¹lǿi¹jni jin³ to¹lu¹guií² mei¹³ calah,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jøng² ca¹juúh² juu³dsa: “Lanh¹²hning dsa² dsiog¹, dsa² ti³té¹³ jǿg³. Dsio¹ báh³ ta³ quiánh²hning. Cu²rø² ma²ca¹mi³tih³hning cøng² ta³ mih². Jøng² dsie¹³jni gugh²hning ta³ juøh¹² hi³méh¹. Cøng² ni³ tiágh³ jniang³ hi² hioh¹² jenh¹² jniang³,” ca¹juúh² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jøng² ca¹dsiég¹ dsa² ca¹hiei¹ guiég² mei¹³ héh¹ cog³. Ma²quin¹² dsa² héi² jín³ guiég² mei¹³, hi² ca¹lǿh¹dsa. Ca¹juúh²dsa: “Guiuh¹³, ca¹cuøh¹³hning jní² guiég² mei¹³ héh¹ cog³. Jai³lah ca¹lǿi¹jni jín³ guiég² mei¹³ ca¹lah,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jøng² ca¹juúh² juu³dsa: “Lanh¹²hning dsa² dsiog¹, dsa² ti³té¹³ jǿg³. Dsio¹ hlaih¹³ ta³ quiánh²hning. Cu²rø² ma²ca¹mi³tih³hning cøng² ta³ mih². Jøng² dsie¹³jni gugh²hning ta³ juøh¹² hi³méh¹. Cøng² ni³ tiágh³ jniang³ hi² hioh¹² jenh¹² jniang³,” ca¹juúh² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jøng² ca¹dsiég¹ dsa² ca¹hiei¹ guie¹ mei¹³ héh¹ cog³. Ca¹juúh²dsa: “Guiuh¹³, ma²guiang³jni hi² lanh¹²hning dsa² huh² dsǿa¹². Ma²guiang³jni hi² lø²chi² quiánh²hning ja³tsa¹ca¹jŋiúh²hning. Jøng² dsiíh³hning loh² ja³ha¹chi² møi¹jon² ma²ca¹séih¹hning. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hi² jøng² ca¹lø¹gag¹²jni. Hi² jøng² ca¹ŋi³hma³jni cog³ quiánh² niúh¹ huø¹. Ja³la² quin³jni cog³ quiánh²hning,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jøng² ca¹juúh² juu³dsa: “Dsa² hlanh³ báh³ hning², dsa² jueh¹². Ma²ŋih³hning lø²chi² quieg¹jni ja³tsa¹ca¹jan¹jni mǿi². Ma²ŋih³hning hi² dsie¹²jni loh² ja³ha¹chi² møi¹jon² ma²ca¹séi¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mi³dsio¹ ju³ ca¹quiegh²hning cog³ quieg¹jni banco. Mi³jøng² mi³hieih¹³jni ca¹lah¹ma¹quianh¹³ jong¹² na³ma²guǿnh¹jni,” ca¹juúh² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jøng² ca¹juúh² juu³dsa, ca¹tsáih¹dsa dsa² quianh¹³dsa: “¡Quieng² cog³ ca¹cuǿ¹jni dsa² ná¹²! Gu³cuøh¹³ hniah¹² dsa² quin¹² to¹lu¹guií² mei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Li¹chi² ma¹dsio¹² hi³méh¹ quiah¹² ca¹lah¹já¹ dsa² ma²chi² quiah¹². Jøng² lé² ma¹dsio¹² quiah¹²dsa. Di³ ju³ná³ hein² dsa² tsa¹chi² ma¹dsio¹² quiah¹², cu¹dsie¹² dsa¹hén² ca¹lah¹jǿ¹ hi² ca²juuh³ chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jøng² gu³dsenh¹³ hniah¹² dsa² tsa¹ta³té¹³ héi² ja³la². Gu³tianh¹² hniah¹² dsa² juu¹² guio¹juǿi¹. Ja³jøng² dsa¹hǿg²dsa. Cán²dsa ma¹dsio¹² jmø³uai¹²,” ca¹juúh² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Na³ma²tǿ² jmai³ ja³guiogh¹³jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², jøng² ji¹lé² ca¹lah¹já¹ ángeles quianh¹³ jní². Ma²léi¹³ hi² hiug¹² juanh¹² jní². Jøng² cán³jni jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jøng² tógh¹ ca¹lah¹já¹ dsa² chian² ca¹lah¹ta³cøng² jmøi¹guǿi¹ ja³ta¹ne¹jni. Jøng² jmo¹³jni héh¹ hi² tógh¹dsa ma¹quién¹ ju³lah jmo¹² juu¹³ jáh², togh¹²dsa ma¹quién¹ jah¹chih² quianh¹³ chiang³ løg². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jøng² tógh³jni dsa² dsiog¹ ta¹guia¹jo¹³. Tógh³jni dsa² hlanh³ ta¹guia¹jón¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jøng² jní², dsa² ma²lán¹² rai¹³ jmai³ jøng², juǿi³jni dsa² tiogh³ ta¹guia¹jo¹³: “Ji¹noh¹² hniah¹² ja³la². Ma²ca¹jmo¹ Jmi² jniang³ hi² dsio¹ dsǿa¹² ja³cogh² hniah¹². Hniah¹² báh³ dsa² li¹quiánh² ja³jmo¹² Diú¹³ héh¹. Ma²jmo¹² Diú¹³ ju³jŋia¹³ quiánh² hniah¹² ca¹lah¹cónh¹ jmai³ mi³ca¹niu¹ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Di³ ca¹løa¹ lø¹i³cóng¹²jni. Jøng² ca¹cuøh³ hniah¹² jní² hi² ca¹gøah¹jni. Ca¹løa¹ lø¹i¹gøh³jni jmøi². Jøng² ca¹cuøh¹³ hniah¹² jní² jmøi². Mi³ŋøa¹²jni ju³lah ŋøa¹² jan² dsa² chian² ja³siíh³. Jøng² ca¹cuøh¹³ hniah¹² ja³ca¹jan¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tsa¹mi³chi² tsønh¹jni. Jøng² ca¹cuøh¹³ hniah¹² jní² tsønh¹jni. Ca¹lø¹dsog¹jni. Jøng² ca¹jmoh³ hniah¹² hí³ jní². Mi³hiúg³jni hni¹ŋí³. Jøng² ca¹ŋi³jah³ hniah¹² jní²,” juǿi³jni dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jøng² juúh² dsa² dsiog¹ héi², tsáih¹dsa jní²: “Juu¹³ jniang³, ¿he² jmai³ ca¹ne¹³ jnieh³ hning², hi² ca¹løa¹ lø¹i³cuanh¹hning, hi² ca¹cuú³ jnieh³ hi² ca¹quíh²hning? ¿He² jmai³ ca¹ne¹³ jnieh³ hning², hi² ca¹løa¹ lø¹i¹hǿgh³hning jmøi² jøng² ca¹cuú³ jnieh³ jmøi²? ");
INSERT INTO cpaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿He² jmai³ ca¹ne¹³ jnieh³ ŋøh²hning ju³lah ŋøa¹² dsa² chian² ja³siíh³, jøng² ca¹cuú³ jnieh³ ja³ca¹jŋih³hning? ¿He² jmai³ ca¹ne¹³ jnieh³ tsa¹mi³chi² tsǿinh²hning, jøng² ca¹cuú³ jnieh³ tsǿinh²? ");
INSERT INTO cpaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿He² jmai³ ca¹ne¹³ jnieh³ dsoh³hning ho¹ ju³ hi² hiúgh³hning hni¹ŋí³, jøng² ca¹ŋi³ne¹³ jnieh³ hning²?” juúh² dsa² dsiog¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jøng² juǿi³ jní² dsa² héi² calah, jní² dsa² ma²lán¹² rai¹³ jmai³ jøng²: “Lah¹dsóh² juǿi²jni hniah¹²: Ju³lah he² hi² dsio¹ ca¹jmoh³ hniah¹² ja³cog² roh¹²jni, ca¹tǿ² dsa² tsa¹quien¹², lah¹cøng² hi² ma²ca¹jmoh³ hniah¹² lah¹jøng² ja³cog² jní² hŋiéng¹,” juǿi³jni dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Jøng² juǿi³jni dsa² mi³tiogh³ ta¹guia¹jón¹: “Lanh¹² hniah¹² dsa² hlanh³. Gu³noh¹² hniah¹² juu¹² guio¹juǿi¹, juu¹² dsi²si² tsa¹øg², ja³ca¹jmo¹ Diú¹³ hi² dsa¹lia¹ Satanás quianh¹³ ángeles hlanh³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Di³ ca¹løa¹ lø¹i³cóng¹²jni. Jøng² tsa¹ca¹cuøh¹³ hniah¹² jní² hi² mi³gøah¹³jni. Ca¹løa¹ lø¹i¹gøh³jni jmøi². Jøng² ha¹chi² ca¹cuøh¹³ hniah¹² jní² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi³ŋøa¹²jni ju³lah ŋøa¹² dsa² chian² ja³siíh³. Jøng² ha¹chi² ca¹cuøh¹³ hniah¹² jní² ja³mi³jan³jni. Ha¹chi² tsønh¹jni mi³chi². Jøng² ha¹chi² ca¹cuøh¹³ hniah¹² hmøah¹² mi³caih¹³jni. Ca¹lø¹dsog¹jni. Ca¹hú¹jni hni¹ŋí³. Jøng² ha¹chi² ca¹ŋi³janh³ hniah¹² jní²,” juǿi³jni dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jøng² juúh² dsa² héi², tsáih¹dsa jní²: “Juu¹³ jniang³, ¿he² jmai³ ca¹ne¹³ jnieh³ hning² hi² ca¹løa¹ lø¹i³cuanh¹hning, ho¹ ju³ hi² ca¹løa¹ lø¹i³hǿgh³hning jmøi², ho¹ ju³ mi³ŋøh²hning ju³lah dsa² chian² ja³uǿin³, ho¹ ju³ tsa¹chi² tsǿinh²hning, ho¹ ju³ hi² dsoh³hning, ho¹ ju³ hi² hiúgh³hning hni¹ŋí³, hi² tsa¹ca¹mi³hog³ jnieh³ hning²?” juúh² dsa² hlanh³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jøng² juǿi³jni dsa² héi² calah, jní² dsa² ma²lán¹² rai¹³ jmai³ jøng²: “Lah¹dsóh² juǿi²jni hniah¹²: Ju³lah he² hi² dsio¹ tsa¹ca¹jmoh³ hniah¹² ja³cog² roh¹²jni, ca¹tǿ² dsa² tsa¹quien¹², ca¹lah¹cøng² hi² tsa¹ca¹jmoh³ hniah¹² lah¹jøng² ja³cog²jni hŋiéng¹,” juǿi³jni dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jøng² dsa¹lia¹ dsa² hlanh³ héi² juu¹² ja³hlaih¹³ jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹. Di³ dsa¹lia¹ dsa² dsiog¹ héi² juu¹² ja³li¹chian²dsa tiá² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mi³ca¹juúh² Jesús ca¹lah¹jǿ¹ jǿg³ jøng², jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh¹³dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ma²ŋih³ báh³ hniah¹² ja³ton¹ jmai³ na¹ tøa¹ jmai³ ta²høa³. Jmai³ jøng² jë́h²dsa jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jøng² jŋaih¹dsa jní² ni³ crǿg¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jøng² ca¹túgh² juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ quián¹² dsa² judío. Ca¹túgh²dsa ja³dsi¹² quiah¹² ŋi¹jmó², dsa² tsen² Caifás. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ja³jøng² ca¹jmo¹dsa jǿg³ ha²lah mi¹ga¹²dsa Jesús. Mi³jøng² chiángh²dsa. Jøng² jŋaih¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Di³ ca¹juúh²dsa: ―Tsa¹lé² chianh¹³ jniang³ dsa² jmai³ juøh¹², na³ca¹jmo¹ dsa² jue¹² møah¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jøng² mi³hiúg³ Jesús jøa³juøi² Betania, ja³quiah¹³ Simón, dsa² mi³lán¹² dsag³ hmih¹² tsa¹jŋi¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jøng² ca¹dsiég¹ jan² hio¹³. Quin¹²dsa cøng² tsǿa¹² lǿa¹² can³ alabastro, hi² ha³ nang³ ma²juøi². Hmóh³ hlaih¹³ cu²té¹² nang³. Jøng² ca¹tsǿng² hio¹³ héi² nang³ jøng² dsi³ Jesús ja³ma²hiúg³ Jesús mesa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jøng² ca¹lø¹hioh¹ dsa² quianh¹³ Jesús mi³ca¹jái¹dsa ha²lah ca¹jmo¹ hio¹³. Ca¹juúh² dsa² quianh¹³dsa: ―¿He² løa¹ ca¹hén²dsa hi² jøng²? ");
INSERT INTO cpaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mi³dsio¹ ju³ jøng² ca¹hnai¹dsa nang³ jøng². Mi³jøng² mi³li¹chi² ma¹dsio¹² cog³ hi² mi³cuúh¹dsa dsa² ti²ŋié² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma²ŋi¹² Jesús he² jǿg³ ma²dsii¹² dsa² quianh¹³dsa. Jøng² ca¹juúh²dsa: ―Tsa¹cuøh¹³ hniah¹² hio¹³ ná¹² ju²méh³ dsøa¹². Hi² dsio¹ báh³ ma²na²jmo¹dsa quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Di³ tiog¹³ báh³ li¹quianh¹³ hniah¹² dsa² ti² dsa² ŋié². Di³ ha¹chi² li¹quianh¹³ hniah¹² jní² ja³la² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma²na²tsǿng²dsa nang³ ma²juøi². Mi³jøng² ma²na²jmo¹dsa ju³jŋia¹³ jmø²ŋǿ¹² quieg¹jni ja³dsø¹hóg¹dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lah¹dsóh² juǿi²jni hniah¹²: Li¹chi² jǿg³ ha²lah na²jmo¹ hio¹³ lang¹² ja³cog²jni ta³cøng² jmøi¹guǿi¹, ca¹lah¹jǿ¹ ja³hǿ²dsa jǿg³ dsio¹ quiah¹² Diú¹³. Mi³jøng² dsiágh¹ dsǿa¹² dsa² jmøi¹guǿi¹ he² ma²ca¹jmo¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jøng² ca¹ŋó¹ jan² dsa² guia¹tón², dsa² tsen² Judas Iscariote. Ca¹ŋó¹dsa juu¹² ja³tiogh³ juu¹³ jmi²dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa juu¹³ jmi²dsa²: ―¿Ha²cónh¹ cog³ cuúh³ hniah¹² ju³ná³ jëh¹³jni Jesús? ―ca¹juúh²dsa. Jøng² ca¹quíg¹ dsa² héi² gui²guí² cog³teg², hi² quín¹² ma¹guie¹ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jøng² ca¹hnangh² Judas mai³¹ ha²lah jë́h²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jøng² mi³ca¹dsiég¹ lah¹huu¹³ jmai³ jmai³ gøah¹²dsa hi³ŋíh¹ tsa¹quianh¹³ chiúh³, jøng² ca¹dsi¹lé² dsa² quianh¹³ Jesús ja³tsenh¹³dsa. Ca¹juúh²dsa: ―¿Ha² tøah¹ hnøngh²hning dsa³jmó³ jnieh³ ju³jŋia¹³ hi² dsa¹quie¹³ jniang³ jmai³ ta²høa³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jøng² ca¹juúh² Jesús: ―Gu³noh¹² hniah¹² jøa³juøi² Jerusalén. Gu³tseih³ hniah¹² jan² dsa² guǿ¹² ja³jøng²: “Lah¹la² juúh² tøa¹² quián² jniang³: Ja³quién¹³ jií¹ jmai³ ja³cán³jni jmø³uai¹². Ja³quiánh³hning dsa³quie¹³ jnieh³ jmai³ ta²høa³ quianh¹³ dsa² quian¹jni,” juaih¹³ hniah¹² dsa² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jøng² ca¹mi¹ti¹ dsa² quianh¹³ Jesús jǿg³ jøng². Ca¹jmo¹dsa ju³jŋia¹³ cøng² ja³ca¹gǿh¹dsa jmai³ ta²høa³. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mi³ca¹neng² jøng², ca¹hí¹ Jesús mesa ca¹lah¹quianh¹³ dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta³lah¹ti³gøah¹²dsa, ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Jan² hniah¹² dsa² tiogh³ ja³la² jë́h²dsa jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jøng² huø³ ca¹hǿi² dsǿa¹² dsa² guia¹tón². Ca¹juúh²dsa, lah¹jan² lah¹jan²dsa: ―Juu¹³ jniang³, a¹jang¹ jní² dsa² jmo¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jøng² ca¹juúh² Jesús: ―Jan² dsa² ma²na²gǿh¹ quianh¹³ jní², dsa² héi² jë́h² jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Di³ lah¹té¹² jǿg³ jón²jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah rø²juúh² si² quiah¹² Diú¹³. ¡He³ báh³ ué² lé² quiah¹² dsa² jë́h² jní²! Mi³dsio¹ quiah¹² dsa² héi² ju³ jmai³ tsa¹ca¹lø¹chián¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jøng² ca¹juúh² Judas, dsa² jë́h²dsa: ―Juu¹³ jniang³, a¹jáng¹ jní² dsa² jmo¹³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Hning² báh³ héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta³lah¹ti³gøah¹²dsa, ca¹cáng¹ Jesús hi³ŋíh¹. Ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³. Ca¹dsiúh¹dsa. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―¡Quiíh²! Jmø²ŋǿ¹² quieg¹ báh³ jní² la² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jøng² mi³ca¹cáng¹dsa cuøh³, ca¹cuúh¹dsa calah Diú¹³ di³hmah³. Jøng² ca¹cuúh¹dsa dsa² quián¹²dsa. Ca¹juúh²dsa: ―¡Hính² hniah¹² ca¹lah¹jáh¹ hniah¹²! ");
INSERT INTO cpaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jmø² quieg¹ báh³ jní² la², hi² jmo¹² lø²rø² jǿg³ hmë́² hi² jmo¹² Diú¹³ quianh¹³ hniah¹². Di³ téng¹ jmø²hán¹³jni ni³ huu¹³ quiah¹² dsa² jue¹², ni³ huu¹³ dsa¹hén² dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² ma¹gøh¹³jni jmøi² møi¹gu²jøah¹³ lah¹la² ca¹lah¹ca¹tǿ² jmai³ ja³hniúh³ jniang³ cu¹dsie¹², ja³jmo¹² Jmi² jniang³ héh¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jøng² mi³ma²na²høa¹dsa alabanza, ca¹ŋi¹lé²dsa juu¹² máh² Olivo. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quián¹²dsa: ―Na¹ ja³neng² lé² jé² hoh¹² hniah¹² ca¹lah¹jáh¹ hniah¹² ni³ huu¹³ quieg¹ jní². Di³ lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Quiugh³jni juu¹³ jáh². Jøng² dsa¹coh¹² jáh² juu¹²,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jøng² na³ma²ca¹hiog²jni, nei¹³jni juu¹² Galilea ta¹jiá¹² cónh¹ jín³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jøng² ca¹juúh² Pedro: ―Ju³ná³ ca¹lø¹jé² dsǿa¹² ca¹lah¹já¹ dsa², ha¹chi² jé² dsøa¹ jní² mi³né³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hning²: Na¹ ja³neng² cónh¹ niúh¹ jín³ hi² ho¹ chiih³, hnaih² rón² jmóh³hning tsa¹cuaih¹²hning jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jøng² ca¹juúh² Pedro calah: ―¡Ju³ lah¹la² jón²jni quianh¹³ hnéng¹, ha¹chi² jmo³jni tsa¹cué¹²jni hning²! ―ca¹juúh²dsa. Jø¹² bíh³ lah¹jøng² ca¹juúh² ca¹lah¹já¹ dsa² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jøng² ca¹dsi¹lé²dsa cøng² ja³tsen² Getsemaní. Jøng² ca¹tsáih¹ Jesús dsa² quianh¹³dsa: ―Ja³la² túgh³ hniah¹² ta³lah¹ŋi³hlanh¹³jni Diú¹³ ja³ná³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jøng² ca¹jian¹dsa Pedro quianh¹³ og¹ ja³ŋiúh³ Zebedeo héi². Jøng² ca¹lø¹chián¹ Jesús ju²cǿh¹ dsøa¹². Huø³ ca¹hǿi² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² úg² héi²: ―¡He³ báh³ hlaih¹³ jéin¹²jni! ¡Ca¹lah¹ma²li¹gu¹hai¹² jmi²dsí² quieg¹jni lǿ²! ¡Jŋi³ hniah¹² ja³la²! ¡Jai³ hniah¹² quianh¹³ jní²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jøng² ca¹ŋó¹ Jesús hi³méh¹. Ca¹quieg²dsa, hi² chi³ŋiu¹³ ni³dsa huø¹. Jøng² ca¹hlanh¹dsa Diú¹³. Ca¹juúh²dsa: ―Tiá³, chi²júh² cuúh³hning jǿg³, tsa¹can¹³jni jmø³uai¹² cuúh¹dsa jní². Di³ tsa¹lé² ca¹lah¹cónh¹ ja³hno¹jni hŋiéng¹. Hning² báh³ ma²ŋih³ ha²lah lé² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jøng² ca¹ŋáh¹ calah Jesús ja³tiogh³ dsa² úg² héi². Ca¹jái¹ Jesús ma²ti³güé¹ dsa² héi². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Pedro: ―¿Tsa³tiah¹hning jáih³hning ca¹lah¹jin³ cøng² hora? ");
INSERT INTO cpaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","¡Jai³ hniah¹²! ¡Hlanh¹³ hniah¹² Diú¹³! Mi³jøng² tsa¹ta³canh¹³ hniah¹² dsag³. Lah¹dsóh² hiug² hoh¹² báh³ hniah¹². Jmø²ŋǿ¹² báh³ tsa¹tiúh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jøng² ca¹ŋó¹ Jesús ca¹tǿ² tánh¹ rón². Ca¹ŋi¹hlanh¹²dsa Diú¹³. Ca¹juúh²dsa: ―Tiá³, chi²júh² tsa¹lé² jŋih¹³hning jmø³uai¹² can¹³jni, jøng² jmóh³ báh³ hning² hi² hiug² hoh¹² hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jøng² ca¹ŋáh¹dsa calah. Cónh¹ calah siíh² ma²ti³güé¹ dsa² héi² calah. Di³ hi² tioh¹³ chiég¹² mø³ni³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jøng² ca¹ŋó¹ Jesús ca¹tǿ² hnaih² rón². Ca¹ŋi¹hlanh¹²dsa Diú¹³ cøng² jǿg³ jøng² báh³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jøng² ca¹ŋáh¹dsa calah ja³tiogh³ dsa² quianh¹³dsa. Ca¹juúh²dsa: ―¡Na¹ jín³ ma²lé² güéh¹ hniah¹²! ¡Teh¹³ hniah¹² bí²! Di³ ma²ca¹dsiég¹ hora ja³jë́h²dsa jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cuai¹dsa jní² ja³cog² dsa² ti³re² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Nung²! ¡Ma¹dsǿg³! Ma²já¹² ma²quién¹ dsa² hnë¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lah¹cónh¹ chi³hløah¹²dsa jǿg³ jøng² ca¹dsiég¹ Judas, dsa² mi³quianh¹³ dsa² guia¹tón². Jøng² jue¹² dsa² ca¹dsi¹lé² quianh¹³dsa. Ti³chinh¹²dsa ŋí³. Ti³chinh¹²dsa hma², dsa² ca¹tse¹ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ quián¹² dsa² judío. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jøng² ma²ca¹juúh² dsa² jë́h² Jesús, mi³jøng² li¹ŋi¹² dsa² quianh¹³dsa, ca¹juúh²dsa: ―Ju³ná³ hein² dsa² ca¹chiunh¹jni ni³, dsa² héi² jmah¹³ hniah¹², dsa² héi² báh³ dsa² hnah¹² hniah¹² ―ma²ca¹juúh²dsa lah¹jiá¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jøng² mi³ca¹dsiég¹ Judas cøg¹² ja³tsenh¹³ Jesús. Ca¹juúh²dsa: ―¿Ja³ná³ báh³ tiogh³ hniah¹², Guiuh¹³? ―ca¹juúh²dsa. Jøng² ca¹chiunh¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Judas: ―¿He² løa¹ na²ŋieh¹² hning², Ha²mei¹³? ―ca¹juúh²dsa. Jøng² ca¹chiánh² dsa² jue¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jøng² ca¹dsi¹ jan² dsa² quianh¹³ Jesús ŋí³ quiah¹². Jøng² ca¹quiúgh²dsa dsa² jmo¹² ta³ quiah¹² ŋi¹jmó². Ca¹tiu¹dsa guø³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa héi²: ―¡Løg² tiangh² ŋí³ quiánh²! Di³ quianh¹³ ŋí³ báh³ jón² ca¹lah¹já¹ dsa² tá¹² quianh¹³ ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tsa³ŋih³ hniah¹² lé² báh³ møa³jni quiah¹² ti³ŋieh¹jni, mi³jøng² dsø¹juu¹² tse¹dsa ángeles jue¹² hlaih¹³ ja³cog²jni? ");
INSERT INTO cpaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Di³ tsa¹mi³li¹ti¹ jǿg³ rø²juúh² si² quiah¹² Diú¹³ ju³ná³ ca¹jmo¹jni lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ni³ jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² jue¹²: ―Ma²ja²nioh¹² hniah¹² hi² jmah¹³ hniah¹² jní², ju³lah jan² dsa² ca¹jmo¹ høin². Ti³chinh¹² hniah¹² ŋí³. Ti³chinh¹² hniah¹² hma². Hliú² rón² ca¹he¹jni jǿg³ dsi²néi² guøh¹² jøa³ ja³tiogh³ hniah¹². Jøng² ha¹chi² ca¹chianh¹² hniah¹² jní². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mi³jøng² lé² ju³lah rø²juúh² si² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih² ―ca¹juúh²dsa. Jøng² ca¹cuøin¹ ca¹lah¹já¹ dsa² mi³quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mi³ca¹chiánh²dsa Jesús, jøng² ca¹ŋi¹jiag¹²dsa juu¹² ja³quiah¹³ Caifás, dsa² lán¹² ŋi¹jmó². Ja³jøng² ma²tiogh³ dsa² he¹² lei¹³ quiah¹² Diú¹³ ca¹lah¹quianh¹³ dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jøng² ca¹ŋó¹ Pedro chi³quë́¹. Ca¹dsiég¹dsa ja³dsi¹² quiah¹² ŋi¹jmó². Ca¹gú²dsa ja³tiogh³ tsih² dsa² ta³, hi² jái¹dsa ha²lah lé² jǿg³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jøng² juu¹³ jmi²dsa², quianh¹³ dsa² canh¹³, quianh¹³ ca¹lah¹já¹ dsa² ti³lán¹² ta³ quián¹² guøh¹², ca¹hnangh²dsa dsag³ jǿg³ tø³jǿg³, dsag³ tsa¹té¹² hi² jón² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jøng² ha¹chi² jǿg³ dsøg¹² ca¹dsóh²dsa. Jue¹² hlaih¹³ dsa² ca¹cuø¹ dsag³ jǿg³ tø³jǿg³ ja³cog² Jesús. Ja³ca¹dsan¹ jø² jǿg³, ca¹túgh² og¹ dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ca¹juúh²dsa: ―Lah¹la² ca¹juúh² dsa² ná¹²: “Tiág¹²jni hén¹³jni guøh¹² juøh¹² quiah¹² Diú¹³. Jøng² tsǿh³jni calah quianh¹³ hnøa¹² jmai³,” ca¹juúh²dsa ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jøng² ca¹nung² ŋi¹jmó². Ca¹ŋǿh¹dsa Jesús: ―¿He² løa¹ tsa¹ŋaih³hning jǿg³ ma²na²juúh²dsa ja³cogh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tei³ báh³ ca¹nung² Jesús. Jøng² ca¹juúh² ŋi¹jmó² calah: ―Ja³ta¹ni¹ Diú¹³ mi³dsøgh¹³hning jǿg³ quiánh²hning chi²júh² dsøg¹² lanh¹²hning Cristo, jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jøng² ca¹juúh² Jesús: ―Dsa² héi² báh³ jní², ju³lah ma²na²juøh³hning. Jø¹² bíh³ juǿi²jni hniah¹²: Jií¹ báh³ jmai³ ja³janh³ hniah¹² jní², ma²guø³jni cog² Diú¹³, dsa² chi² bí², ta¹lah¹guia¹jo¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Guiogh¹³jni jøa³jneng¹² hei¹² guiuh¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jøng² ca¹gǿi¹ ŋi¹jmó² tsǿnh³, hi² hne²dsa. Jøng² ca¹juúh²dsa: ―Jǿg³ hlaih¹³ ja³cog² Diú¹³ ma²na²juúh²dsa. Ha¹chian² dsa² ma²hniuh¹² cuúh¹dsa dsag³. Ma²na²nengh¹² báh³ hniah¹² jǿg³ hlaih¹³ ma²na²juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ha²lah lë́h² hniah¹²? ―ca¹juúh² ŋi¹jmó². Jøng² ca¹juúh² ca¹lah¹já¹ dsa² ta³ héi²: ―Rø²canh¹² báh³ dsa² dsag³ hi² jón²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jøng² ca¹qui² ca¹hŋiéng² dsa² héi² ni³ Jesús. Ca¹bú²dsa. Ca¹qui² ca¹jnáng¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ca¹juúh²dsa: ―¡Dsi³ di³ cøng² jǿg³, Cristo! ¿Hein² dsa² qui²jnǿng² hning²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jøng² mi³guǿ¹³ Pedro ja³dsi¹², mi³ca¹dsiég¹ jan² tsih²mǿ² cøg¹², dsa² jmo¹² ta³ quiah¹² ŋi¹jmó². Ca¹juúh² tsih²mǿ², ca¹tsáih¹dsa Pedro: ―Hning² calah dsa² mi³quianh¹³ Jesús, dsa² chian² huø¹ Galilea héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jøng² ca¹juúh² Pedro ja³ta¹ni¹ dsa² jue¹²: ―¡Cu¹dsie¹² tsa¹guiang³jni he² jǿg³ juúh²hning! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jøng² ca¹ŋó¹ Pedro ja³tsih¹³ hag³jnǿ³. Jøng² ca¹jǿi² jín³ jan² tsih²mǿ², dsa² jmo¹² ta³ calah. Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² tiogh³ cøg¹²: ―Dsa² ná¹² báh³ mi³hiúg³ quianh¹³ Jesús, dsa² chian² jøa³juøi² Nazaret héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jøng² ca¹juúh² Pedro: ―Lah¹té¹² jǿg³ tsa¹cué¹²jni dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mi³ma²cu²lǿi² jøng², ca¹juúh² dsa² mi³tiogh³ cøg¹², ca¹tsáih¹dsa Pedro: ―Lah¹dsóh² mi³hiúgh³hning quianh¹³ dsa² héi². Hløah³hning ju³lah hløah¹² dsa² go² dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jøng² ca¹jí² Pedro, ca¹juúh²dsa: ―¡Ca¹lah¹jái¹² Diú¹³! ¡Tsa¹cué¹²jni dsa² hiah¹² hniah¹²! ―ca¹juúh²dsa. Dsø¹juu¹² jøng² báh³ ca¹ho¹ chiih³. ");
INSERT INTO cpaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jøng² ca¹dsagh² dsǿa¹² Pedro jǿg³ ma²ca¹juúh² Jesús, hi² juúh²dsa hnøa¹² rón² tsa¹cuai¹²dsa cónh¹ niúh¹ jín³ ca¹ho¹ chiih³. Jøng² ca¹u¹hái¹ Pedro ja³jøng². Ca¹ho¹ hlaih¹³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mi³ca¹jni¹, ca¹túgh² ca¹lah¹já¹ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ quián¹² dsa² judío. Ca¹jmo¹dsa cøng² jǿg³ hi² jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jøng² mi³ca¹hŋió²dsa Jesús, ca¹ŋi¹jiag¹²dsa juu¹² ni³ ta³, hi² ca¹jë́h²dsa Jesús ja³cog² Pilato, dsa² lán¹² dsi³máh². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jøng² mi³ca¹lø¹lih¹³ Judas, dsa² ca¹jë́h² Jesús, hi² ca¹tø³canh¹³ Jesús dsag³ hi² jón²dsa, jøng² ca¹jéinh¹ dsǿa¹²dsa. Ca¹jáinh¹dsa gui²guií² cog³ teg² jøng² ni³ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ca¹juúh²dsa: ―Dsag³ re²jni. Di³ hi² ca¹hnë¹jni dsa² dsiog¹, dsa² ha¹chi² dsag³ re² ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² tiogh³: ―Ha¹chi² jǿg³ ná¹² ca¹tǿi² jnieh³. Jǿg³ ca¹të́h² hŋiah¹ báh³ hning² ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jøng² ca¹guieh¹ Judas cog³ jøng² dsi²néi² guøh¹². Ca¹u¹hái¹dsa. Jøng² ca¹tí²dsa tsíg² lag³dsa. Ca¹hë́²dsa guiuh¹³. Ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jøng² ca¹dsii¹ juu¹³ jmi²dsa² loh² cog³ jøng². Ca¹juúh²dsa: ―Tsa¹lé² jmó³ jniang³ cog³ quiah¹² guøh¹² cog³ ná¹². Di³ cog³ ca¹hnë¹dsa dsa² báh³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hi² jøng² ca¹jmo¹dsa jǿg³ hi² lá¹dsa cøng² huø¹ quianh¹³ cog³ jøng². Huø¹ jøng² mi³quiah¹² jan² dsa² ŋøa¹² ta³ jmo¹²dsa tøh¹². Jøng² ca¹jmo¹dsa cu²san³¹ huø¹ jøng² ja³húg¹dsa dsa², ju³lah dsa² chian² ja³siíh³ ca¹jon¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hi² jøng² ca¹lah¹jín³ na¹ tsen² huø¹ jøng² Huø¹ Ca¹hnë¹dsa Dsa². Di³ cog³ ca¹hnë¹dsa dsa² báh³ hi² ca¹lá¹dsa huø¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lah¹jøng² ca¹lø¹ti¹ jǿg³ la² ca¹jmo¹ hlai³ Jeremías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: “Ca¹can¹dsa gui²guií² cog³ teg², hi² quien¹² ma¹guie¹ héh¹. (Di³ cónh¹jøng² lǿa¹² jǿg³ ca¹jmo¹ dsa² israel hi² quíg¹dsa quiah¹² dsa² hnai¹.) ");
INSERT INTO cpaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Cog³ jøng² ca¹lá¹dsa huø¹ mi³quiah¹² dsa² jmo¹² tøh¹², ju³lah lǿa¹² héh¹ ca¹jmo¹ Diú¹³, ca¹tsáih¹dsa jní²,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jøng² ca¹nung² Jesús ni³ dsi³máh², dsa² tsen² Pilato. Jøng² ca¹ŋǿh¹ dsi³máh² Jesús. Ca¹juúh²dsa: ―¿Lanh¹³hning rai¹³ quián¹² dsa² judío? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Dsa² héi² báh³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jøng² ca¹cuúh¹ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ Jesús dsag³. Di³ ha¹chi² ca¹ŋai¹ Jesús ca¹lah¹jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jøng² ca¹juúh² Pilato, ca¹tsáih¹dsa Jesús: ―¿Tsa³nøngh²hning ma¹dsio¹² dsag³ cuøh¹² dsa² hning²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Cónh¹jøng² ha¹chi² ca¹ŋai¹ Jesús ca¹lah¹jin³ cøng² jǿg³. Jøng² ca¹lø¹dsogh¹² hlaih¹³ dsǿa¹² dsi³máh². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jøng² ma²lǿa¹² mai³¹ quiah¹² dsi³máh² hi² liúg²dsa jan² dsa² hiúg³ hni¹ŋí³ jmai³ ta²høa³, lǿa¹² ju³ hein² dsa² ca¹më¹ dsa² jue¹² liúg². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jøng² mi³hiúg³ jan² dsa² hni¹ŋí³, dsa² chi² ma¹dsio¹² jǿg³ quiah¹², hi² hlanh³dsa. Barrabás mi³tsen² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jøng² mi³ma²tiogh³ dsa² jue¹², ca¹juúh² Pilato: ―¿Naih¹² dsa² hnøngh² hniah¹² log³jni? ¿Log³jni Barrabás, ho¹ ju³ log³jni Jesús, dsa² tǿh²dsa Cristo? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ma²ŋi¹² Pilato hi² ca¹jë́h² dsa² judío Jesús, di³ hi² hioh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jøng² ma²guǿ¹² Pilato mi²rø¹²dsa jǿg³ jøng², mi³ca¹dsiég¹ jan² tsih²høh³ ca¹tse¹ hio¹³ quián¹²dsa. Ca¹juúh² tsih²høh³ héi²: ―Lah¹la² juúh² hio¹³ quiánh²hning: “Tsa¹hlanh¹³hning dsa² dsiog¹ ná¹². Di³ ca³lah³uai¹² na²cø¹jni cøng² ma²hmǿi² ni³ huu¹³ quiah¹²dsa,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jøng² ca¹tsáih¹ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ dsa² jue¹² hi² møa¹dsa hi² liúg² dsi³máh² Barrabás, hi² jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jøng² ca¹juúh² dsi³máh², ca¹tsáih¹dsa dsa² jue¹²: ―¿Naih¹² jan² dsa² hnøngh² hniah¹² log³jni cónh¹ og¹ dsa² lang¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² jue¹²: ―¡Barrabás báh³ logh³hning! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jøng² ca¹juúh² Pilato calah: ―¿He² hnøngh² hniah¹² jmo¹³jni quianh¹³ Jesús, dsa² tǿh²dsa Cristo? ―ca¹juúh²dsa. Jøng² ca¹ŋai¹ ca¹lah¹já¹ dsa² héi²: ―¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jøng² ca¹juúh² dsi³máh²: ―¿He² hi² hlaih¹³ ma²ca¹jmo¹dsa? ―ca¹juúh²dsa. Jøng² hiug¹² jín³ tí² ca¹hløah¹ dsa² héi²: ―¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jøng² ca¹lø¹lih¹³ Pilato ha¹chi² li¹rø² jǿg³. Di³ ma²tiogh³ dsa² jue¹² cu²møah¹³. Jøng² ca¹møa¹ Pilato jmøi². Ca¹rang¹dsa gug² ja³ta¹ni¹ dsa² jue¹². Ca¹mi¹léi¹³dsa ha¹chi² dsag³ re²dsa ja³cog² Jesús. Ca¹juúh²dsa: ―Ha¹chi² dsag³ re²jni ni³ huu¹³ quiah¹² hi² jón² dsa² dsiog¹ lang¹². Hniah¹² báh³ ma²ŋih³ ha²lah jmóh³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jøng² ca¹ŋai¹ dsa² jue¹²: ―¡Ju³li¹røi² jnieh³ dsag³, cu¹dsié¹² quianh¹³ tsø³jong¹³ jnieh³, hi² jón² dsa² ná¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jøng² ca¹liúg² Pilato Barrabás. Jøng² ca¹jmo¹dsa héh¹ hi² ca¹bá²dsa Jesús. Ca¹cuø¹dsa jǿg³ ta¹ton¹³dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ni³ jøng² ca¹ŋi³jian¹ hlég² quián¹² dsi³máh² Jesús dsi²néi² quiah¹² dsa² ta³, ja³tǿh²dsa Pretorio. Jøng² ca¹túgh² ca¹lah¹já¹ hlég² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jøng² ca¹li²dsa tsǿnh³ Jesús. Ca¹quieh¹dsa Jesús cøng² hmøah¹² guiéng², ju³lah hmøah¹² caih¹² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jøng² ca¹jmo¹dsa cøng² tsøi² tang¹². Ca¹tí²dsa dsi³ Jesús. Ca¹tí²dsa cøng² hma² ta² gug²dsa dsio¹. Jøng² ca¹chi¹jné¹dsa ni³ Jesús. Jøng² ca¹cu² ca¹jmágh²dsa. Ta³dsǿa¹² ca¹juúh²dsa: ―Hiug¹² juanh¹² hning² rai¹³ quián¹² dsa² judío ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ca¹ti² ca¹hŋiéng²dsa. Ca¹bá²dsa dsi³dsa quianh¹³ hma² ta² mi³chinh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mi³ma²na¹cu² na²jmágh²dsa, jøng² ca¹li²dsa hmøah¹² guiéng². Jøng² ca¹quieh¹dsa dsa² calah tsǿnh³. Jøng² ca¹ŋi¹jiag¹²dsa juu¹² ja³ta¹ton¹³dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jøng² ma²dsø²lé²dsa, mi³ca¹jén²dsa jan² dsa² chian² Cirene, dsa² tsen² Simón. Jøng² ca¹jmo¹dsa héh¹ ca¹can¹ dsa² héi² crǿg¹³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jøng² ca¹dsi¹lé²dsa cøng² ja³tsen² Gólgota, hi² hniu¹dsa juúh²dsa Máh² Mu² Dsi³ Dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jøng² ca¹cuø¹dsa Jesús vino rø²guia¹² mǿa¹² jinh² hlaih¹³. Mi³ca¹can¹ Jesús jǿg³ dsøg¹² mǿa¹² jøng², ha¹chi² ca¹hǿnh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ni³ jøng² mi³ma²ton¹²dsa crǿg¹³, jøng² ca¹li² hlég² jǿg³ hein² dsa² ta¹ tsǿnh³ Jesús, lah¹cøng² lah¹cøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jøng² ca¹túgh² hlég² ti³jái¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dsi³guiuh² Jesús ca¹tiun¹dsa cøng² si² rø²hløah¹² dsag³ ca¹cuúh¹dsa Jesús. Lah¹la² rø²juúh² si²: “Jesús báh³ lang¹², dsa² lán¹² rai¹³ quián¹² dsa² judío,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jøng² ca¹tiog¹dsa og¹ dsa² høin² cog² Jesús, jan² dsa² ta¹lah¹guia¹jo¹³, jan² dsa² ta¹lah¹guia¹jón¹. Ca¹tiang¹dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jøng² jǿg³ hlaih¹³ ca¹juúh² dsa² ca¹tsø³jue¹³ ja³jøng². Ca¹guieh¹dsa dsi³dsa. Di³ tsa¹tøa¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ca¹juúh²dsa: ―¡Hning², dsa² mi³gúgh² guøh¹², jøng² mi³tsǿh³hning calah ja³hnøa¹² jmai³, logh³ hŋiah¹! ¡Siog³ crǿg¹³, chi²júh² lán¹²hning jong¹² Diú¹³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jøng² ca¹cu² ca¹jmágh² calah juu¹³ jmi²dsa², quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, quianh¹³ dsa² canh¹³. Ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ca¹liúg²dsa dsa² siáh². Tsa¹tiúh¹dsa liog¹dsa hŋiah¹²dsa. Ju³ná³ lán¹²dsa rai¹³ quián¹² dsa² israel, jøng² ju³siúg²dsa crǿg¹³. Jøng² báh³ hé² jniang³ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ma²ca¹hé¹ báh³ dsa² jǿg³ quiah¹² Diú¹³. Ju³lég³ Diú¹³ calah, chi²júh² hniang¹ Diú¹³. Di³ ma²na²juúh²dsa hi² lán¹²dsa jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jø¹² bíh³ ca¹jí² calah dsa² høin², dsa² ti³ton¹² crǿg¹³ quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jøng² mi³ca¹tǿ² dsi¹hiég¹, ca¹hǿi² neng² ta³cøng² juøi² jøng² ca¹tǿ² hein¹³ hnøa¹² ta¹ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Cónh¹ hein¹³ hnøa¹² jøng² ca¹hløah¹ Jesús tí² hlaih¹³. Ca¹juúh²dsa: ―Elí, Elí, ¿lama sabactani? ―hi² hniu¹dsa juúh²dsa: “Diú¹³ quian¹, Diú¹³ quian¹, ¿he² løa¹ ma²na²tégh²hning jní²?” ");
INSERT INTO cpaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mi³ca¹nǿng² dsa² tiogh³ ja³jøng², ca¹juúh²dsa: ―Tǿh² dsa² ná¹² Elías, dsa² mi³chian² ma²lǿih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jøng² ca¹ŋó¹ jan² dsa² gu¹hei¹². Ca¹ŋi¹tí²dsa cøng² hi² lǿa¹² ju³lah lǿa¹² hmøah¹² jmøi² jinh². Mi³jøng² ca¹ha¹ jmøi². Jøng² ca¹cǿin²dsa hi² jøng² dsi³ hma², hi² mi³henh¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jøng² ca¹juúh² dsa² siáh²: ―¡Jŋih³ ná³! Ju³ne¹³ cøng² chi²júh² jí¹ Elías hi² ji¹liúg²dsa dsa² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ni³ jøng² tí² hlaih¹³ ca¹ho¹ Jesús calah. Ta³lah¹ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jøng² ca¹gøi² hmøah¹² hei¹² dsi²jo² dsi²néi² guøh¹². Ca¹gøi² ca¹tǿ² guiuh¹³ ca¹tǿ² huø¹. Ca¹løa¹ ton¹ jag¹³ hmøah¹². Ca¹táh² onh¹². Ca¹jue¹ cang³ pa³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ca¹ná² hliú² hag³ tøg² ja³mi³ni³hóg¹² hlai³, dsa² hé² jǿg³ quiah¹² Diú¹³. Ca¹hiog² jue¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jøng² mi³ca¹hiog² Jesús, ca¹ŋi¹lé² dsa² héi² juu¹² Jerusalén, ja³ca¹jǿi² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jøng² ca¹juanh¹² hlaih¹² juu¹³ hlég² quianh¹³ hlég² quián¹²dsa, dsa² mi³jmo¹² hí³ Jesús, mi³ca¹jái¹dsa ca¹táh² onh¹² quianh¹³ ca¹lah¹jǿ¹ hi² ca¹løa¹ lah¹jøng². Jøng² ca¹juúh²dsa: ―Lah¹dsóh² mi³lán¹² dsa² ná¹² jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jøng² mi³tiogh³ jue¹² hio¹³ ti³jái¹² calah ja³uǿin³. Hio¹³ héi² chian² Galilea, ca¹ŋi¹lé² quianh¹³ Jesús juu¹² Jerusalén. Ma²ca¹mi¹ti¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mi³tsen²dsa María Magdalena, quianh¹³ María, mi³chiég³ Jacobo quianh¹³ José roh¹³dsa, quianh¹³ mi³chiég³ ja³ŋiúh³ Zebedeo. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mi³ca¹hlég² jøng², ca¹dsiég¹ jan² dsa² chi² cog³ chian² Arimatea, dsa² tsen² José. Mi³quianh¹³ Jesús dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jøng² ca¹ŋó¹dsa ni³ Pilato. Ca¹më¹dsa hlai³ Jesús. Jøng² ca¹cuø¹ Pilato jǿg³ ca¹tai¹ dsa² héi² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mi³ca¹siúg² José hlai³, ca¹dsǿgh²dsa hmøah¹² tuh¹² ti³jai¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jøng² ca¹ŋi¹hǿg²dsa cøng² niúh¹ tøg² hløg² hmë́² quiah¹²dsa, ja³ma²ca¹guiég¹dsa. Ca¹jnéi¹dsa tøg² quianh¹³ cang³. Jøng² ca¹ŋáh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mi³tiogh³ María Magdalena quianh¹³ hio¹³ siáh² tsen² María calah. Tiogh³dsa cøg¹² ja³ca¹húg²dsa hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mi³ca¹jni¹ jmai³ siíh³, mi³ca¹tsø³jue¹³ jmai³ ja³jmo¹²dsa ju³jŋia¹³ quiah¹² jmai³ ta²høa³, ca¹ŋi¹lé² juu¹³ jmi²dsa² quianh¹³ dsa² fariseo ni³ Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ca¹juúh²dsa: ―Guiuh¹³, dsagh² dsǿa¹² jnieh³ jǿg³ ca¹juúh² Jesús, dsa² mi²gag¹² héi², jmai³ mi³chian²dsa. Ca¹juúh²dsa hi² hiog¹dsa ja³hnøa¹² jmai³ ju³ná³ ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jøng² jmóh³hning héh¹ hi² jmo¹dsa hí³ ca¹lah¹ca¹tǿ² jmai³ hnøa¹². Mi³jøng² tsa¹lé² ŋi¹lé² dsa² quianh¹³dsa hi² ŋi¹hë¹²dsa hlai³. Jøng² tsa¹lé² juúh² dsa² quianh¹³ dsa² hi² ca¹hiog² báh³ dsa². Hiug¹² jín³ ma¹dsio¹² lé² mi¹gag¹² dsa² quianh¹³ Jesús cónh¹ jín³ juu³dsa ju³ná³ ca¹jmo¹dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jøng² ca¹juúh² Pilato: ―Ma²tiogh³ báh³ hlég² quiánh² hniah¹². Gu³noh¹² hniah¹². Gu³jmo³ cu²rø² hí³ tøg² ja³rø²hog¹² hlai³ ca¹lah¹cónh¹ ja³tiah¹ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jøng² ca¹ŋi¹lé²dsa. Ca¹jmo¹dsa cu²rø² ja³rø²hog¹² hlai³. Ca¹tiun¹dsa cøng² sello ni³ cang³ pa³ rø²jnái¹² hag³ tøg². Jøng² ca¹togh¹²dsa hlég², dsa² jmo¹ hí³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jøng² mi³ca¹tsø³jue¹³ jmai³ sa³¹, ta¹ŋih¹³ jmai³ du²mei³¹, ca¹ŋi¹lé² María Magdalena quianh¹³ jín³ jan² hio¹³ siáh² tsen² María calah, hi² ca¹ŋi¹jái¹²dsa ja³rø²høg¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cónh¹ tsa¹ju²jŋiá³ ca¹táh² onh¹² tí² hlaih¹³. Di³ ca¹siog² jan² ángel quián¹² Juu¹³ jniang³ juu¹² ŋi¹juǿi¹. Ca¹guøn¹dsa ja³rø²hog¹² hlai³. Ca¹jŋíh²dsa cang³ pa³ mi³rø²jnái¹² hag³ tøg². Jøng² ca¹gú² ángel ni³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jniá²dsa sih¹² ju³lah lǿa¹² si² ŋíh¹. Teg² hlaih¹³ tsǿnh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mi³ca¹jǿi² hlég², ca¹juanh¹² hlaih¹³ dsa². Ca¹jlia¹dsa hi² goh¹²dsa. Jøng² ca¹ŋi¹ganh¹³dsa huø¹ ju³lah cøng² hi² ca¹dsan¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jøng² ca¹juúh² ángel, ca¹tsáih¹dsa hio¹³ héi²: ―¡Tsa¹jmo² ganh¹! Ma²guiang³jni hi² hnah¹² hniah¹² Jesús, dsa² ca¹jon¹ ni³ crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ha¹chian² dsa² ma¹chian² ja³la². Di³ ca¹hiog² báh³ dsa² ju³lah lǿa¹² jǿg³ ca¹juúh²dsa. ¡Jai³ di³ hniah¹² ja³mi³ron¹² hlai³! ");
INSERT INTO cpaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jøng² ta³tí³ la² gu³noh¹² hniah¹². Gu³tseih³ hniah¹² dsa² quianh¹³ Jesús hi² ma²ca¹hiog² báh³ dsa². Jøng² dság¹dsa ma²jiá¹²dsa quianh¹³ hniah¹² juu¹² Galilea. Ja³jøng² janh³ hniah¹² dsa². Lah¹ná¹² báh³ jǿg³ juǿi²jni hniah¹² ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jøng² ca¹huanh¹²dsa ja³mi³ron¹² hlai³. Ca¹ŋi¹lia¹dsa cøng² gu¹hei¹². Gøg² hlaih¹³ ca¹can¹dsa. Di³ cónh¹jøng² hioh¹² jenh¹² báh³ dsa² calah. Ca¹ŋi¹jmó²dsa jǿg³ ni³ dsa² quián¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma²dsø²lia² jøng² báh³ hio¹³, ca¹jén²dsa Jesús dsi²juu¹². Jøng² ca¹haih¹ Jesús jǿg³ hio¹³ héi². Jøng² ca¹túgh² hio¹³ chi³ŋiu¹³ ni³dsa huø¹. Ca¹chính²dsa coh¹³tai¹ Jesús. Ca¹mi¹juanh¹²dsa dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jøng² ca¹juúh² Jesús: ―¡Tsa¹jmóh³ hniah¹² ganh¹! Gu³tseih³ hniah¹² dsa² quian¹jni hi² dsa¹lia¹dsa juu¹² Galilea. Ja³jøng² jǿi²dsa jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jøng² mi³ca¹ŋi¹lé² hio¹³ gu¹hei¹², ca²dsiog³ hlég², dsa² mi³jmo¹² hí³ héi², ca¹ŋi¹lé² juu¹² Jerusalén. Jøng² ca¹ŋi¹tseih¹dsa juu¹³ jmi²dsa² ca¹lah¹jǿ¹ hi² ma²ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jøng² ca¹túgh² juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³. Ca¹jmo¹dsa jǿg³. Ma¹dsio¹² cog³ ca¹cuúh¹dsa hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ca¹juúh²dsa: ―Lah¹la² juaih¹³ hniah¹² dsa² jue¹²: “Ca¹ŋi¹lé² dsa² quianh¹³ Jesús. Ca¹ŋi³tei²dsa hlai³ ta³lah¹ti³güéh¹ hniah¹² ja³neng²,” juaih¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jøng² ju³ná³ ca¹lø¹ŋi¹² dsi³máh² jǿg³ jøng², jnieh³ jmó³ hi² tsa¹jé²dsa hniah¹², hi² tsa¹cuúh¹dsa hniah¹² dsag³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jøng² ca¹can¹ hlég² héi² cog³. Ca¹ŋi¹tseih¹dsa dsa² jue¹² ju³lah héh¹ ca¹jmo¹ dsa² canh¹³ quianh¹³ juu¹³ jmi²dsa². Hi² jøng² dsii¹² dsa² judío jǿg³ jøng² ca¹lah¹jin³ na¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jøng² ca¹ŋi¹lé² dsa² guia¹ján¹ juu¹² Galilea. Ca¹dsi¹lé²dsa cøng² máh² ja³ma²ca¹he¹ Jesús hi² tógh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jøng² ca¹mi¹juanh¹² dsa² Jesús mi³ca¹jǿi²dsa. Cónh¹jøng² tiogh³ báh³ ca²dsiog³dsa tsa¹hé² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jøng² ca¹ŋó¹ Jesús cøg¹² ja³tiogh³ dsa² héi². Ca¹juúh²dsa: ―Ju²gug¹ jní² ma²ca¹dsii¹ ti³ŋieh¹jni hi² jmo³jni héh¹ ta³cøng² ŋi¹juǿi¹, ca¹lah¹ma¹quianh¹³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hi² jøng² gu³noh¹² hniah¹² ca¹lah¹jǿ¹ ja³tiogh³ dsa² jmøi¹guǿi¹. Mi³jøng² li¹quián¹²dsa jní². Jøng² chiogh¹³ hniah¹² dsa² héi² jmøi² huu¹³ quiah¹² Jmi² jniang³, huu¹³ quieg¹ jní² dsa² lán¹² jong¹²dsa, huu¹³ quiah¹² jmi²dsí² han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gu³heh³ hniah¹² dsa² héi² jǿg³, hi² mi¹ti¹dsa ca¹lah¹jǿ¹ cónh¹ ja³lǿa¹² héh¹ ma²ca¹juǿi²jni hniah¹². Jøng² tiá² báh³ quianh¹³ jní² hniah¹² ca¹lah¹ca¹tǿ² ja³dsiá¹ jmøi¹guǿi¹ ―ca¹juúh² Jesús.");
INSERT INTO cpaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Lah¹la² báh³ ca¹lø¹liág¹ jǿg³ dsio¹ quiah¹² Jesucristo, jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ca¹lø¹liág¹ ju³lah lǿa¹² jǿg³ la² ca¹tiun¹ hlai³ Isaías si², dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: Jai³lah. Tsë́³jni tsih² høh³ quian¹jni ni³jiá¹ cónh¹ jín³ hning², dsa² dsa¹jmogh¹ juu¹² ja³ŋǿh³hning, ");
INSERT INTO cpaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","dsa² hløah¹ tí² juu¹² ja³ha¹chian² dsa² tiogh³, juúh²dsa: “¡Jmo³ ju²jŋia¹³ juu¹² ja³ŋøa¹ Juu¹³ jniang³! ¡Jmo³ cu¹dsøg¹² juu¹² ja³ŋøa¹dsa!” juúh²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jøng² ca¹dsiég¹ báh³ Juan juu¹² ja³ha¹chian² dsa² tiogh³. Ca¹hǿ²dsa jǿg³ hi² hniuh¹² jéinh¹ dsǿa¹² dsa² jmøi¹guǿi¹ ja³cog² Diú¹³. Jøng² tsogh¹dsa jmøi² calah. Mi³jøng² hén² Diú¹³ dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jøng² ca¹ŋi¹lé² ca¹lah¹já¹ dsa² chian² huø¹ Judea quianh¹³ dsa² chian² jøa³juøi² Jerusalén. Ca¹ŋi¹lé²dsa ja³tsenh¹³ Juan. Ca¹tiog¹²dsa dsǿg³dsa. Jøng² ca¹jŋó²dsa jmøi² ca¹chiag¹ Juan chi³jmøi² Jordán. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mi³quieih¹² Juan hmøah¹² lǿa¹² jŋiú³ camello. Mi³chi³hŋieng¹² cøng² løg² togh¹²dsa. Mi³cugh¹²dsa chi³nøh². Mi³hǿnh²dsa jmø³tah¹² ca¹dsagh¹ ja³ha¹chian² dsa² tiogh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ca¹hǿ²dsa jǿg³. Ca¹juúh²dsa: ―Na¹ bíh³ jí¹ jan² dsa² hiug¹² jín³ hi² chi² bí² quiah¹² cónh¹ jín³ jní². Tsa¹lë́²jni tén¹²jni tsøh³jni løg² dsǿ² tai³ dsa² héi² ca¹lah¹jín³ ma²chi³jné¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jmøi² báh³ chiog¹² jní² hniah¹². Cónh¹jøng² jmi²dsí² quiah¹² Diú¹³ báh³ tí² dsa² héi² quiánh² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jmai³ jøng² mi³guǿ¹³ Jesús Nazaret, juøi² tén¹² Galilea. Jøng² ca¹ŋó¹dsa juu¹² ja³hiu³ chi³jmøi² Jordán. Ja³jøng² ca¹jŋó²dsa jmøi² ca¹chiag¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jøng² ma²u²hai¹² Jesús jmøi² mi³ca¹jái¹dsa hi² ca¹ná² guiuh¹³ ŋi¹juǿi¹. Jøng² ca¹siog² jmi²dsí² quiah¹² Diú¹³ ni³ quiah¹²dsa, hi² jní² jmi²dsí² ju³lah jniá² jan² jug². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jøng² ca¹hløah¹ Diú¹³ guiuh¹³ ŋi¹juǿi¹. Ca¹juúh²dsa: ―Hning² báh³ jon¹jni. Hnó¹jni hning². Hiug¹² tøa¹² dsøa¹jni hning² ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dsø¹juu¹² jøng², ca¹ŋó¹ Jesús juu¹² ja³ha¹chian² dsa² tiogh³, hi² ca¹jiag¹ jmi²dsí² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ja³jøng² ŋie³dsa ton¹lág¹ jmai³, ja³ca¹jmo¹ Satanás láh² ju³jmo¹³ Jesús hi² hlaih¹³. Jø¹² bíh³ mi³tiogh³ jah²núng³ ja³jøng². Cónh¹jøng² ca¹mi¹ti¹ ángeles ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jøng² mi³ca¹hí¹ Juan hni¹ŋí³, ca¹ŋáh¹ Jesús juu¹² Galilea ja³ca¹ŋi³hǿ¹³dsa jǿg³ dsio¹ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ca¹juúh²dsa: ―Ma²ca¹dse¹ báh³ jmai³. Ja¹quien¹³ jí¹ ja³jmo¹ Diú¹³ héh¹. ¡Ju³jeinh¹³ hoh¹² hniah¹²! ¡Ju³héh³ hniah¹² jǿg³ dsio¹ quiah¹² Diú¹³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma²ŋøa¹² Jesús chiuh³ jmøi² Galilea mi³ca¹jë́²dsa Simón quianh¹³ Andrés, roh¹³dsa, dsa² téng² hmá¹² chi³jmøi². Di³ ta³ jøng² lán¹²dsa, hi² tsánh²dsa jáh² tiogh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Ma¹dsǿg³ quianh¹³ jní²! He³jni ha²lah jmóh³ hniah¹² ta³ hi² léh² hniah¹² dsa² li¹quianh¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta³lah¹ca¹tiú¹ dsa² héi² hmá¹². Ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jøng² ma²dsø²lé²dsa ma²jiá¹²dsa hi³méh¹ mi³ca¹jë́² Jesús Jacobo, ja³ŋiúh³ Zebedeo, quianh¹³ Juan, dsa² ca¹ŋo² quianh¹³ Jacobo. Tiogh³ dsa² héi² cøng² barco. Cøinh¹²dsa néng³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dsø¹juu¹² jøng² ca¹tøa¹ Jesús. Hi² jøng² ca¹tiúg² dsa² héi² Zebedeo, ti³jmi²dsa, quianh¹³ dsa² jmo¹² ta³ quiah¹²dsa, dsa² tiogh³ barco. Ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jøng² ca¹dsi¹lé²dsa jøa²juøi² Capernaum. Ja³jøng² ca¹he¹ Jesús jǿg³ dsi²néi² guøh¹² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jøng² dsogh¹² dsǿa¹² dsa² chian² ja³jøng² jǿg³ ca¹he¹ Jesús. Di³ he¹²dsa ju³lah he¹² jan² dsa² lah¹dsóh² ŋi¹² ha²lah lǿa¹² jǿg³, a¹jáng¹ ju³lah he¹² tøa¹², dsa² he¹² lei¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jøng² mi³hiúg³ jan² dsa² guøh¹², dsa² quin¹² jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ca¹hløah¹ dsa² héi² tí². Ca¹juúh²dsa: ―¿He² jǿg³ ca¹të́h²hning quianh¹³ jnieh³, Jesús, dsa² chian² Nazaret? ¿Ma³guønh¹hning hi² mi³dsiagh¹³hning jnieh³? Cué¹² báh³ jní² hning². Dsa² han¹³ quián¹² Diú¹³ báh³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jøng² ca¹jé² Jesús jmi²dsí² hlaih¹³. Ca¹juúh²dsa: ―¡Cagh¹² hagh³! ¡Jú¹² quiah¹²dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jøng² ca¹jlia¹ dsa² héi², ca¹jmo¹ jmi²dsí² hlaih¹³. Ca¹ho¹dsa tí² ca¹lah¹ca¹u¹hái¹ jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jøng² ca¹ŋi¹dsógh¹ dsǿa¹² ca¹lah¹já¹ dsa² tiogh³. Ca¹dsii¹dsa jǿg³ guiog³dsa. Ca¹juúh²dsa: ―¿He² bíh³ jǿg³ la²? ¿Ho¹ ju³ jǿg³ hmë́² liáh³? Chi² báh³ bí² quiah¹² dsa² ná¹². Tsaih¹²dsa jmi²dsí² hlaih¹³, ta³lah¹ca¹can¹ jmi²dsí² jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hi² lah¹jøng² ca¹tsø² ca¹ja¹ jǿg³ quiah¹² Jesús lah¹jin² lah¹lǿih¹ ta³cøng² ja³tén¹² huø¹ Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jøng² ca¹u¹hái¹ Jesús guøh¹². Ca¹ŋó¹dsa juu¹² ja³quiah¹³ Simón quianh¹³ Andrés. Quianh¹³dsa calah Jacobo quianh¹³ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ja³jøng² rø²quia¹² mø²chiég³ Simón, hi² dsé²dsa. Jøng² ca¹tsáih¹dsa Jesús dsø¹juu¹² hi² dsoh³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jøng² ca¹ŋó¹ Jesús cøg¹². Ca¹chính²dsa gug² dsa² dsoh³. Ca¹chiag¹dsa. Jøng² ca¹jŋi¹ hi² dsé² hio¹³. Ca¹mi¹ti¹ hio¹³ ni³ Jesús quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jmai³ jøng², mi³ca¹tø³dsé³ hieg², jue¹² dsa² ca¹jian¹ dsa² dsoh³ quianh¹³ dsa² quin¹² jmi²dsí² hlaih¹³. Ca¹jiag¹dsa juu¹² ja³hiúg³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jøng² ca¹lah¹já¹ dsa² chian² ja³jøng² ca¹túgh² hag³hniú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jøng² ca¹mi¹hliú² Jesús jue¹² dsa² dsoh³, dsa² mi³lán¹² hliú² ni³ dsag³. Ca¹huø¹dsa hliú² jmi²dsí² hlaih¹³. Jøng² tsa¹ca¹cuø¹dsa hi² hløah¹ jmi²dsí². Di³ hi² cuai¹² jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jøng² ca¹nung² Jesús tu¹heg² hlaih¹³ cónh¹ nioh¹². Ca¹ŋó¹dsa cøng² ja³cu³hŋiah¹², ja³ca¹hlanh¹dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jøng² ca¹hnangh¹² Simón quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jøng² mi³ca¹dsanh¹²dsa Jesús, ca¹juúh²dsa: ―Ca¹lah¹já¹ dsa² hnah¹² hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ma¹dsǿg³ jniang³ juøi² tioh¹³ cøg¹². Mi³jøng² hǿa¹³jni jǿg³ quiah¹² Diú¹³ ja³jøng² calah. Di³ huu¹³ jøng² ca¹guio¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jøng² ca¹ŋi³téng³dsa jǿg³ guøh¹² quiah¹² dsa² chian² ta³cøng² ja³tén¹² huø¹ Galilea. Ca¹huø¹dsa jmi²dsí² hlaih¹³ quiah¹² dsa² mi³quin¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jøng² ca¹dsiég¹ jan² dsa² dsoh³ ja³tsenh¹³ Jesús, dsa² lán¹² hmih¹² tsa¹jŋi¹². Ca¹chi¹jné¹dsa. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Tiah¹ báh³ hning² jmóh³hning hí³ quieg¹jni, chi²júh² hiug² hoh¹²hning quianh¹³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jøng² ca¹ŋi¹ŋiú² dsǿa¹² Jesús. Hi² jøng² ca¹quieg²dsa gug²dsa ni³ quiah¹² dsa² dsoh³. Jøng² ca¹juúh²dsa: ―Hiug² báh³ dsøa¹jni. ¡Ju³huá² quiánh²hning! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dsø¹juu¹² jøng² ca¹huá² hmih¹². Ha¹chi² ma¹lǿa¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ni³ jøng² ca¹haih² Jesús dsa² héi² jǿg³. Cónh¹jøng² quianh¹³ hi² tiog¹³ ca¹tsáih¹dsa dsa² héi². Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Jai³lah. Ha¹chian² dsa² gu³tseih³hning ca¹lah¹jin³ hein² ha²lah ma²na²løa¹. Cónh¹ gu³hiah¹³ jmi²dsa² hning². Gu³cuøh¹³hning Diú¹³ ju³lah lǿa¹² lei¹³ quiah¹² hlai³ Moisés. Mi³jøng² li¹ŋi¹² ca¹lah¹já¹ dsa² ha¹chi² dsag³ ma¹lanh¹²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cónh¹jøng² mi³ma²u¹hái¹ dsa² mi³dsoh³ héi², ta³lah¹ca¹dsii¹dsa jǿg³. Ca¹tsø² ca¹ja¹dsa jǿg³. Hi² jøng² tsa¹ma¹lé² hí¹ Jesús jøa³juøi² ja³jái¹² dsa². Jøng² ca¹ŋó¹dsa juu¹² cøg¹². Jøng² jue¹² dsa² ca¹túgh² quianh¹³dsa, ju³lah dsa² chian² ta¹lah¹tan¹³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ja³ton¹ hnøa¹² jmai³ jøng², ca¹hí¹ Jesús calah jøa³juøi² Capernaum. Jøng² ca¹lø¹chí¹ jǿg³ ma²guønh¹²dsa ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jøng² jue¹² hlaih¹³ dsa² ca¹túgh² ja³quiah¹³dsa. Ca¹lah¹ca¹tǿ² hag³hniú¹³ tiogh³dsa. Jøng² ca¹he¹ Jesús jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jøng² quión² dsa² ŋioh¹² ca¹dsi¹jian¹ jan² dsa² dsoh³, dsa² huø³ quiah¹², dsa² tsa¹li¹ŋøa¹. Ca¹jiag¹dsa juu¹² guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cónh¹jøng² tsa¹lé² dsø¹jiag¹dsa ca¹tǿ² ja³guǿ¹³ Jesús. Di³ jue¹² dsa² tiogh³. Hi² jøng² ca¹jŋíh²dsa mih² guiuh¹³ hniú¹², guiuh¹³ ja³guǿ¹³ Jesús. Mi³ca¹jŋíh²dsa jøng², ca¹siég²dsa jein³ ja³hiúg³ dsa² dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jøng² mi³ca¹jái¹ Jesús hi² lah¹dsóh² hé² dsa² héi² jǿg³ quiah¹²dsa, ca¹juúh²dsa, ca¹tsáih¹dsa dsa² dsoh³: ―Ma²ca¹dsan¹ dsag³ quiánh²hning, jon¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ja³jøng² mi³tiogh³ og¹ úg² tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Jøng² lë́² dsa² héi²: ");
INSERT INTO cpaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿He² løa¹ lah¹ná¹² juúh² dsa² ná¹²? Tsa¹quien¹² Diú¹³ jmo¹²dsa, jǿg³ juúh²dsa. Jan² Diú¹³ báh³ dsa² tiúh¹ hén² dsag³,” lë́² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jøng² ma²ŋi¹² Jesús he² jǿg³ dsø²jiag¹² dsǿa¹² dsa² héi². Hi² jøng² ca¹juúh² Jesús: ―¿He² løa¹ lah¹jøng² høa¹² hoh¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Naih¹² hi² tsa¹ué² juǿi³jni dsa² dsoh³?: “Ma²ca¹dsan¹ dsag³ quiánh²hning,” ho¹ ju³ juǿi³jni dsa²: “¡Nung²! ¡Quieng² jein³ quiánh²hning! ¡Ŋøa³!” ");
INSERT INTO cpaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cónh¹jøng² lah¹la² juǿi³jni dsa² dsoh³. Mi³jøng² li¹ŋih³ hniah¹² hi² tiág¹²jni hén¹³jni dsag³ ni³ guøh³ ni³ huø¹ la², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jøng² ca¹tsáih¹dsa dsa² dsoh³: ");
INSERT INTO cpaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Hning² juǿi²jni. ¡Nung²! ¡Quieng² jein³ quiánh²hning! ¡Guønh² ja³quiánh³hning! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jøng² ca¹nung² dsa² dsoh³. Ca¹cáng¹dsa jein³. Ca¹u¹hái¹dsa ja³jái¹² ca¹lah¹já¹ dsa² tiogh³. Jøng² ca¹lah¹já¹ dsa² ca¹can¹ gøg². Ca¹mi¹juanh¹²dsa Diú¹³. Ca¹juúh²dsa: ―Ca¹lah¹jin³ cu²rón² tsa¹ma²ca¹tǿ² ni³ jniang³ lah¹ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jøng² ca¹u¹hái¹ Jesús ja³jøng² calah. Ca¹ŋó¹dsa juu¹² chiuh³ jmøi². Jøng² ca¹dsi¹lé² dsa² jue¹² ja³tsenh¹³dsa. Jøng² ca¹he¹ Jesús jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma²ŋøa¹² Jesús he¹² jǿg³ mi³ca¹jë́²dsa Leví, ja³ŋiúh³ Alfeo, dsa² guǿ¹² hniú¹² ja³cagh¹²dsa cog³. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Leví: ―¡Ma¹dsǿg³ quianh¹³ jní²! ―ca¹juúh²dsa. Jøng² ca¹nung² Leví. Ca¹ŋó¹dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jøng² ca¹túgh² Jesús mesa ja³quiah¹³ Leví, quianh¹³ dsa² quianh³dsa. Quianh¹³dsa calah jue¹² dsa² lán¹² ta³ cagh¹² cog³ juøi², quianh¹³ dsa² tsa¹ti³jan¹ ja³cog² Diú¹³ ca¹lah¹cónh¹ lǿa¹² mai³¹ quiah¹² dsa² judío. Di³ jue¹² dsa² lah¹héi² ma²dsø²lé² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jøng² mi³ca¹jái¹ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, dsa² quianh³ dsa² fariseo, hi² gøah¹² Jesús quianh¹³ dsa² tsa¹ti³jan¹ héi², ca¹lah¹quianh¹³ dsa² cagh¹² cog³, jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh¹³ Jesús: ―¿He² løa¹ gøah¹² Jesús quianh¹³ dsa² lah¹ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ca¹nǿng² Jesús jǿg³ jøng². Jøng² ca¹juúh² Jesús: ―Ha¹chian² tø²mǿa¹² hnioh¹² quiah¹² dsa² dsiog¹. Dsa² dsoh³ báh³ hnioh¹² tø²mǿa¹² quián¹². Huu¹³ jøng² báh³ ca¹guio¹jni, hi² tǿa¹³jni dsa² re² dsag³, a¹jáng¹ ju³ dsa² dsiog¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jøng² dsa² quianh¹³ Juan, dsa² ca¹chiog¹ dsa² jmøi², quianh¹³ dsa² fariseo, ma²mi²han¹²dsa, hi² tsa¹gøah¹²dsa cu²hna². Jøng² ca²dsiog³ dsa² ca¹ŋi³tseih³ Jesús, ca¹juúh²dsa: ―Mi²han¹² báh³ dsa² quianh¹³ Juan quianh¹³ dsa² fariseo, hi² tsa¹gøah¹²dsa cu²hna². ¿He² løa¹ tsa¹jmo¹² dsa² quiánh²hning lah¹jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Lǿa¹² ju³lah lǿa¹² quiah¹² dsa² dsø²lé² jmai³ quiah¹² dsa² jenh² gug². Tsa¹lé² mi¹han¹²dsa, hi² tsa¹gøah¹²dsa, ta³lah¹guǿ¹² dsa² ŋioh¹², dsa² ca¹jenh² gug². ");
INSERT INTO cpaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jøng² jí¹ báh³ jmai³ ja³jŋiángh² dsa² hiag¹³ jní². Jmai³ jøng² báh³ mi¹han¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Tsa¹dsio¹ tiáng³ jniang³ jneh³ hmøah¹² tsa¹ma²ŋangh¹² quianh¹³ tsǿnh³ jniang³ ma²hǿg³. Di³ ma¹dsio¹² hi³méh¹ guíg¹ ju³ná³ ca¹dsøgh¹² hmøah¹² hmë́². ");
INSERT INTO cpaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jø¹² bíh³ lah¹jøng² tsa¹dsio¹ tiíh³ jniang³ jmøi² rǿg² tsø³løg² ma²hǿg³. Di³ guíg¹ báh³ løg² na³ma²ca¹lø¹hiug¹² jmøi². Jøng² téng¹ jmøi². Jø¹² bíh³ dsa¹hén² løg². Løg² hmë́² báh³ dsio¹ tiíh³ jniang³ jmøi² rǿg² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jøng² cøng² jmai³ sa³¹ ma²ŋøa¹² Jesús juu¹² jøa³cuøi² hi³ŋíh¹. Dsa² quianh³dsa ca¹cøn¹ mih² ja³dsø²lé²dsa jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jøng² ca¹juúh² dsa² fariseo, ca¹tsáih¹dsa Jesús: ―Jai³lah. ¿He² løa¹ jmo¹² dsa² quiánh²hning hi² tsa¹lǿa¹² lei¹³ hi² jmó³ jniang³ jmai³ sa³¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿Tsa³ma²ca¹híh² hniah¹² si² ha²lah ca¹jmo¹ hlai³ David ja³ca¹chi¹quián²dsa jmai³, jmai³ ca¹løa¹ lø¹i³cónh¹²dsa quianh¹³ dsa² quianh¹³dsa? ");
INSERT INTO cpaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Di³ jmai³ mi³lán¹² Abiatar ŋi¹jmó² ca¹hí¹ David dsi²néi² guøh¹². Ca¹gǿh¹dsa hi³ŋíh¹ ma²ca¹dsii¹ jmi²dsa² ni³ Diú¹³, hi³ŋíh¹ hi² ma²lǿa¹² lei¹³ hi² gǿh¹ jmáh¹lah jmi²dsa². Ca¹lah¹ca¹tǿ² dsa² quianh¹³dsa ca¹cuúh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jøng² ca¹juúh² calah Jesús: ―Ni³ huu¹³ quián² jniang³ báh³ ca¹lø¹chí¹ jǿg³ hi² jŋi² jniang³ dsa² jmøi¹guǿi¹ jmai³ sa³¹. A¹jáng¹ lah¹jøng² hi² ca¹lø¹chián¹ jniang³ ni³ huu¹³ jǿg³ quiah¹² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hi² jøng² jní² báh³ dsa² jmo¹² héh¹ he² hi² lé² jmó³ jniang³ jmai³ sa³¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jøng² ca¹hí¹ Jesús calah guøh¹². Ja³jøng² mi³hiúg³ jan² dsa² ŋioh¹² dsi¹³ huh² cøng² gug². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jøng² ca¹jǿi² ca²dsiog³ dsa² tiogh³, chi²júh² jmo¹ Jesús hí³ dsa² héi² jmai³ sa³¹. Di³ mi³cuúh¹dsa Jesús dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² dsi¹³ huh² gug² héi²: ―¡Nung² dsi²jo² la²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jøng² ca¹juúh² calah Jesús, ca¹tsáih¹dsa dsa² ti³jǿi²: ―¿Naih¹² hi² dsio¹ jmó³ jniang³ jmai³ sa³¹? ¿Hi³ dsio¹, ho¹ ju³ hi² hlaih¹³? ¿Hi³ liúg² jniang³ jmi²dsí², ho¹ ju³ hi² hén³ jniang³? ―ca¹juúh²dsa. Jøng² ha¹chi² ca¹ŋai¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jøng² hne² Jesús ca¹jë́²dsa dsa² héi². Quin¹² Jesús ju²méh³ dsøa¹². Di³ huh² dsǿa¹² dsa² héi². Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² ŋioh¹²: ―¡Neih³ gugh²! ―ca¹juúh²dsa. Jøng² ca¹néih¹ dsa² ŋioh¹² héi² gug². Ta³lah¹ca¹lái¹ dsio¹ gug²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dsø¹juu¹² jøng² ca¹huanh¹² dsa² fariseo. Ca¹jmo¹dsa jǿg³ quianh¹³ dsa² herodiano ha²lah qui¹hén²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jøng² ca¹ŋó¹ Jesús juu¹² chiuh³ jmøi² quianh¹³ dsa² quianh¹³dsa. Jue¹² hlaih¹³ dsa² chian² Galilea ca¹ŋi¹lé² quianh¹³dsa. Jø¹² bíh³ dsa² chian² Judea, ");
INSERT INTO cpaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","quianh¹³ dsa² chian² jøa³juøi² Jerusalén, quianh¹³ dsa² chian² Idumea, quianh¹³ dsa² chian² hŋoh¹³ jmøi² Jordán, quianh¹³ dsa² chian² ja³tén¹² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón, ca¹dsi¹lé² jue¹² hlaih¹³dsa ja³tsenh¹³ Jesús. Di³ ma²ca¹nǿng²dsa he² ma²jmo¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jøng² ca¹tsáih¹ Jesús dsa² quián¹²dsa hi² hai¹dsa ju²jŋia¹³ cøng² barco ju³ná³ ca¹túgh²dsa chi³cu² chi³hliáh². Di³ jue¹² dsa² lǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ma²ca¹mi¹hliú² Jesús dsa² jue¹². Hi² jøng² cu²hliah¹²dsa Jesús, hi² hniu¹dsa láh²dsa quiah¹² Jesús, ju³lah dsa² lán¹² dsag³. Mi³jøng² hliú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jøng² lǿa¹² ju³ hein² dsa² quin¹² jmi²dsí² hlaih¹³ ca¹jë́² Jesús, ca¹chi¹jné¹dsa ni³ Jesús. Ca¹juúh²dsa tí²: ―Hning² báh³ jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jøng² hiug¹² ca¹juúh² Jesús hi² tsa¹mi¹léi¹³ jmi²dsí² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jøng² ca¹ŋó¹ Jesús juu¹² máh². Ca¹tǿh¹dsa dsa² cónh¹ dsa² hnio¹dsa. Jøng² ca¹dsi¹lé² dsa² héi² ja³tsenh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jøng² ca¹jmo¹ Jesús guia¹tón² dsa², dsa² li¹quianh¹³dsa, dsa² dsa¹téng² jǿg³ quiah¹² Diú¹³, ");
INSERT INTO cpaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dsa² li¹chi² bí² hi² huø¹dsa jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dsa² lang¹² ca¹hia¹dsa: Simón, dsa² ca¹quian¹dsa Pedro ");
INSERT INTO cpaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo quianh¹³ Juan, roh¹³dsa, ja³ŋiúh³ Zebedeo ta³og¹ (Dsa² héi² ca¹quian¹dsa Boanerges, hi² hniu¹dsa juúh²dsa Jong¹² Ŋíh¹. Di³ tsøg² dsǿa¹² dsa² héi².) ");
INSERT INTO cpaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés Felipe Bartolomé Mateo Tomás Jacobo, ja³ŋiúh³ Alfeo Tadeo Simón, dsa² cananista ");
INSERT INTO cpaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, dsa¹ ca¹hnë¹ Jesús jmai³ chi³quë́¹. Jøng² ca¹ŋáh¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ni³ jøng² ca¹dsi¹lé² dsa² jue¹² calah, ca¹lah¹jin³ tsa¹lé² gǿh¹dsa hé¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jøng² mi³ca¹nǿng² ju³roh¹³dsa jǿg³ jøng², ca¹ŋi¹lé²dsa ja³quiah¹³dsa. Mi³ŋi¹chiánh²dsa Jesús. Di³ lë́²dsa hi² ma²ŋøa¹² Jesús ŋá¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jøng² ca¹juúh² tøa¹² he¹² lei¹³ quiah¹² Diú¹³, dsa² chian² jøa³juøi² Jerusalén: ―Beelzebú quin¹²dsa. Hi² jøng² báh³ huø¹²dsa jmi²dsí² hlaih¹³ quianh¹³ bí² cuø¹² juu¹³ jmi²dsí² hlaih¹³ héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hi² jøng² ca¹tǿh¹ Jesús dsa² jue¹². Ca¹tsáih¹dsa dsa² jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Tsa¹lé² huø¹ Satanás quiah¹² Satanás hŋiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lǿa¹² ju³lah lǿa¹² quiah¹² juøi² ja³tsa¹tiogh³ dsa² juøi² cøng² jǿg³. Dsa¹hén² báh³ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jø¹² bíh³ dsa¹hén² jǿg³ quiah¹² dsa² tiogh³ cøng² hniú¹², ju³ná³ cø²tsë́¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jøng² ma²ŋih³ hniah¹² hi² dsa¹hén² jǿg³ quiah¹² Satanás, dsa² tøah¹² hniah¹² Beelzebú héi², ju³ná³ tá¹²dsa quianh¹³ dsa² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ha¹chian² dsa² lé² hí¹ dsi²néi² quiah¹² dsa² bé², hi² cán²dsa hi² chi² dsi²néi², ju³ná³ tsa¹ma²na²hŋió²dsa dsa² hniu³ ni³jiá¹. Jøng² ma²lé² cán²dsa hi² chi² dsi²néi², ju³ná³ ma²na²hŋiéng²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Lah¹dsóh² juǿi²jni hniah¹²: Li¹chi² báh³ ju²hén² dsǿg³ dsa² jmøi¹guǿi¹ ca¹lah¹jǿ¹ dsag³ re²dsa, ho¹ ju³ he² jǿg³ hlaih¹³ ma²ca¹hløah¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cøng² dsag³ jøng² tsa¹lǿih² jmai³ dsa¹hén² quiah¹²dsa, ju³ná³ ca¹hia¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³ jǿg³ hlaih¹³. Dsa² juúh² lah¹jøng² ma²re² dsag³ tsa¹ma¹dsián¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Lah¹jøng² ca¹juúh² Jesús. Di³ ma²ca¹juúh² dsa² héi² hi² quin¹² Jesús jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jøng² ca¹dsiég¹ mi³chiég³ Jesús quianh¹³ roh¹³dsa. Ca¹túgh²dsa ja³dsi¹². Jøng² ca¹tse¹dsa jǿg³ tǿh²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jue¹² dsa² tiogh³ lah¹jin² lah¹lǿih¹ ja³guǿ¹³ Jesús. Jøng² ca¹juúh² dsa² tiogh³, ca¹tsáih¹dsa Jesús: ―Hning² tǿh² mi³chiegh²hning ja³dsi¹² lah¹quianh¹³ rúh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jøng² ca¹juúh² Jesús: ―¿Hein² dsa² lán¹² mi³chie¹ lah¹quianh¹³ roh¹² jní²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jøng² ca¹jë́²dsa dsa² tiogh³ lah¹jin² lah¹lǿih¹ ja³guǿ¹³dsa. Ca¹juúh²dsa: ―Hniah¹² báh³ dsa² lanh¹² mi³chie¹jni quianh¹³ roh¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Di³ dsa² héi² báh³ lán¹² roh¹²jni quianh¹³ mi³chie¹jni, dsa² mi²ti¹ jǿg³ quiah¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cónh¹ calah ca¹he¹ Jesús jǿg³ chiuh³ jmøi². Jøng² mi³ca¹dsi¹lé² jue¹² hlaih¹³ dsa² ja³tsenh¹³dsa, ca¹uǿi² Jesús cøng² barco hei¹² dsi²jmøi². Jøng² tiogh³ dsa² jue¹² chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jøng² ca¹dsii¹ Jesús hliú² jǿg³ ti³jnøa¹². Jøng² ca¹he¹dsa jǿg³ la²: ");
INSERT INTO cpaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―¡Neng² di³ hniah¹² jǿg³ la²! Jan² dsa² ca¹ŋó¹, ca¹ŋi¹séi¹ møi¹jon². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ja³ca¹séi²dsa jøng², ca¹quia¹ mih² møi¹jon² cøg¹² juu¹². Jøng² ca¹dsi¹lé² tan¹². Ca¹jiégh¹jah mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jøng² ca¹quia¹ mih² jøa³cang³, ja³tsa¹chi² ma¹dsio¹² guøh³. Mǿi² jøng² tí² ta³ca¹hii². Di³ tsa¹hmøh² guøh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jøng² mi³ca¹dsíg¹ hieg², ca¹jlíh¹. Jøng² ca¹lø¹quiéng¹. Di³ tsa¹chi² ma¹dsio¹² jmó³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jøng² ca¹quia¹ mih² ja³tioh¹³ tang¹². Jøng² ca¹hiag² tang¹². Ca¹lø¹hmaih¹. Tsa¹ca¹cuø¹ mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jøng² ca¹quia¹ mih² ja³dsio¹. Ca¹hii². Ca¹ŋi¹cón³. Ca¹cuø¹ mǿi². Ca²dsieg³ ca¹cuø¹ ma¹gui²guí², ca²dsieg³ ma¹to¹lu¹guí² rø²dsǿ² guie¹, ca²dsieg³ ma¹cøng² ŋi²lǿg². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jøng² ca¹juúh²dsa: ―Ju³ná³ hein² dsa² lé² nang¹, ju³neng¹³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jøng² mi³ma²ca¹ŋi¹lia¹ dsa² jue¹², ca¹ŋai¹ dsa² quián¹² Jesús quianh¹³ dsa² guia¹tón² he² hi² hniu¹dsa juúh²dsa jǿg³ ti³jnøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jøng² ca¹juúh² Jesús: ―Hniah¹² báh³ dsa² li¹ŋih³ ha²lah lǿa¹² jǿg³ quiah¹² ja³jmo¹² Diú¹³ héh¹. Di³ jøng² jmáh¹lah jǿg³ ti³jnøa¹² báh³ li¹chi² quiah¹² dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mi³jøng² tsa¹li¹lih¹³dsa he² hi² jái¹dsa. Mi³jøng² tsa¹li¹ŋë́²dsa he² hi² nang¹dsa. Mi³jøng² tsa¹jénh¹dsa. Tsa¹dsa¹hén² dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jøng² ca¹juúh²dsa calah: ―¿Tsa³ŋë́h² hniah¹² jǿg³ ti³jnøa¹² quiah¹² møi¹jon²? ¿Ha²lah li¹ŋih³ hniah¹² jøng² ca¹lah¹jǿ¹ jǿg³ ti³jnøa¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dsa² téng² jǿg³ báh³ dsa² séi² mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chian² báh³ dsa² lán¹² ju³lah lǿa¹² møi¹jon² ca¹quia¹ cøg¹² juu¹². Nang¹² báh³ dsa² héi² jǿg³ quiah¹² Diú¹³. Dsø¹juu¹² jøng² báh³ já¹² dsa² hlanh³. Jŋíh² dsa² hlanh³ jǿg³ ma²dsø²jiag¹² dsǿa¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jø¹² bíh³ lán¹² ca²dsiog³ dsa² ju³lah lǿa¹² møi¹jon² ca¹quia¹ jøa³cang³. Mi³ma²nǿng² dsa² héi² jǿg³ quiah¹² Diú¹³, dsø¹juu¹² jøng² báh³ cang¹dsa jǿg³ ca¹lah¹hiu³ dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jøng² lǿa¹² quiah¹² dsa² héi² ju³lah lǿa¹² quiah¹² hma² tsa¹chi² ma¹dsio¹² jmó³. Cu²hna² báh³ tiúh¹dsa. Tsa¹hai³ tiáh¹ dsǿa¹² dsa² héi² ju³ná³ he² mih² jmø³uai¹² ca¹já¹, ho¹ ju³ ca¹jmógh² dsa² ni³ huu¹³ hi² hé²dsa jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jøng² chian² dsa² siáh², dsa² lán¹² ju³lah lǿa¹² møi¹jon² ca¹quia¹ ja³tioh¹³ tang¹². Nang¹² báh³ dsa² héi² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Jøng² li¹chian² dsa² héi² ju²hí³ dsøa¹² ja³dsø²lé²dsa jmøi¹guǿi¹. Li¹gan²dsa quianh¹³ cog³. Li¹hniu¹dsa hi² siíh², hi² chi² tø¹cøg¹². Hi² jøng² jmo¹² tsa¹ma¹dsagh² dsǿa¹²dsa jǿg³ quiah¹² Diú¹³. Tsa¹dsø¹cón³ jǿg³ ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jøng² ca²dsiog³ dsa² lán¹² ju³lah lǿa¹² quiah¹² møi¹jon² ca¹quia¹ huø¹ dsio¹. Dsa² héi² chính² tí² jǿg³ na³ma²ca¹nǿng²dsa. Dsa¹jon¹ báh³ jǿg³ ja³cog² dsa² héi² ma¹gui²guí², ma¹to¹lu¹guí² rø²dsǿ² guie¹, ma¹cøng² ŋi²lǿg³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jøng² ca¹juúh² calah Jesús: ―Ha¹chian² dsa² hma¹² si² jmøi² cøg² niúh¹ tøh¹², ho¹ ju³ niúh¹ jein³, na³ma²ca¹te¹dsa si². Guiuh¹³ hai¹²dsa si². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Di³ li¹léi¹³ báh³ ca¹lah¹jǿ¹ hi² rø²hma¹. Li¹ne³ báh³ jniang³ ca¹lah¹jǿ¹, ju³lah he² jǿg³ tsa¹léi¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ju³ná³ hein² dsa² lé² nang¹, ju³neng¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jøng² ca¹juúh² calah Jesús: ―¡Quin² hí³ jǿg³ hi² nøngh² hniah¹²! Cøng² ni³ mi¹rø¹² Diú¹³ jǿg³ quiánh² hniah¹², ju³lah mi³rǿh³ hniah¹² jǿg³ quiah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Ué² hi³méh¹ jmo¹ Diú¹³ ja³cogh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Di³ cuø¹ Diú¹³ hi² niu¹ ma¹dsio¹² jǿg³ ju²gug² dsa² cán² hí³ jǿg³. Jøng² jŋíh² báh³ Diú¹³ he² jǿg³ mih² lë́²dsa hi² ŋi¹²dsa, ju³lah dsa² tsa¹jmo¹² hí³. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jøng² ca¹juúh² Jesús: ―Lǿa¹² ja³jmo¹² Diú¹³ héh¹ ju³lah lǿa¹² quiah¹² jan² dsa² séi² møi¹jon² ni³ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jøng² güe²dsa ja³neng². Nung²dsa ŋi²jmø². Ŋøa¹² jmai³. Jøng² hií¹ mǿi². Dsa¹cón³. Tsa¹ŋi¹² dsa² héi² ha²lah lǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hŋiah¹² jmøi¹guǿi¹ báh³ jmo¹² hi² li¹chi² mǿi². Lah¹ni³ hii² moh¹³ guø³. Ni³ jøng² toh¹² hlíh². Jøng² lǿ² chi³cángh¹ hlíh² ja³dsø²cah¹³ mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jøng² mi³ca¹lø¹lé² mǿi², tse¹²dsa dsa² dsø²quiúh². Di³ ca¹dsiég¹ jmai³ ja³jiégh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jøng² ca¹juúh²dsa calah: ―¿He² jǿg³ chi² li¹juúh³ jniang³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹? ¿He² jǿg³ chi² li¹dsií³ jniang³? ");
INSERT INTO cpaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lǿa¹² ju³lah lǿa¹² møi¹jon² mostaza. Píh³ báh³ mǿi² jøng² cónh¹ jín³ ja³ca¹lah¹jǿ¹ ni³ mǿi² siíh² chi² jmøi¹guǿi¹ jmai³ ja³séi²dsa ni³ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jøng² hiug¹² jín³ dsø²juøh¹² cónh¹ jín³ ja³ca¹lah¹jǿ¹ ni³ janh¹² siíh². Dsø²cah¹³ guh¹² ca¹lah¹cónh¹ ma²lé² túgh¹ tan¹² ja³lǿa¹³ hính³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Quianh¹³ hliú² jǿg³ ti³jnøa¹² lah¹jøng² ca¹heh¹ Jesús dsa² jue¹², ca¹lah¹cónh¹ ja³té¹² li¹nang¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ha¹chi² ca¹nií¹dsa jǿg³. Jmáh¹lah dsa² quianh³dsa ca¹heh¹dsa jǿg³ chi³na¹ ja³cu³guiog³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jmai³ jøng², mi³ca¹tø³dsé³ hieg², ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quián¹²dsa: ―¡Ma¹dsǿg³ hŋoh¹³ jmøi²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jøng² ca¹tiúg²dsa dsa² jue¹². Ca¹jiag¹ dsa² quián¹²dsa juu¹² hŋoh¹³ jmøi², hi² ma²guǿ¹² Jesús lah¹jøng² báh³ barco. Jø¹² bíh³ ca¹ŋi¹lei¹ barco siíh² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jøng² ca¹hǿi² dsí² tí² hlaih¹³ cu¹té¹². Ca¹jéinh¹ jmøi² niúh¹ barco. Ca¹tǿ² ja³mi³cángh² barco. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jøng² rø²güé¹ Jesús tø¹ja³tag¹² barco. Rø²dse¹² hmøah¹² dsi³dsa. Jøng² ca¹ŋie¹dsa Jesús. Ca¹juúh²dsa: ―¡Tøa¹²! ¿Tsa³chi² lë́h²hning hi² dsiág¹ jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jøng² mi³ca¹ŋié¹ Jesús, ca¹jé²dsa dsí². Ca¹tsáih¹dsa jmøi². Ca¹juúh²dsa: ―¡Tei³ ju³niu¹³! ¡Tsa¹tóh² cu²møah¹³! ―ca¹juúh²dsa. Jøng² ca¹jŋi¹ dsí². Ca¹tsih¹ tei³ hlaih¹³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―¿He² løa¹ ganh¹ hniah¹²? ¿Tsa³héh² hniah¹² jǿg³ quieg¹ jní²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jøng² ca¹can¹ hlaih¹³ dsa² quianh¹³dsa gøg². Ca¹dsii¹dsa jǿg³ guiog³dsa. Ca¹juúh²dsa: ―¿Jin³ hein² dsa² lang¹²? Nang¹² báh³ dsí² quianh¹³ jmøi² jǿg³ hi² juúh²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jøng² ca¹dsi¹lé²dsa hŋoh¹³ jmøi², huø¹ go² dsa² gadareno. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jøng² ca¹u¹hái¹ jan² dsa² ŋioh¹² tøg²hløg² ja³rø²hog¹² hlai³. Quin¹² dsa² ŋioh¹² jmi²dsí² hlaih¹³. Ca¹jén² dsa² héi² Jesús mi³ma²siog²dsa barco. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja³jøng² guǿ¹² dsa² héi², ja³rø²hog¹² hlai³ jøng². Ha¹chian² dsa² ma¹tiúh¹ hŋio¹ dsa² héi² ca¹lah¹jin³ quianh¹³ cadena. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Di³ hliú² rón² ma²ca¹hŋiéng²dsa quianh¹³ cadena. Cónh¹jøng² ca¹hnie¹dsa. Ca¹jue¹dsa ŋí³. Ha¹chian² dsa² ma¹tia¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jøng² ca¹lah¹jǿ¹ jmai³ lah¹huu² lah¹jmø² ho¹² dsa² héi² tí². Dsø²hǿg²dsa ja³rø²hog¹² hlai³ jøng². Dsø²hǿg²dsa máh². Qui²tág¹²dsa quiah¹²dsa hŋiah¹²dsa quianh¹³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jøng² mi³ca¹jë́² dsa² héi² Jesús ca¹tǿ² uǿin², ca¹ŋó¹dsa gu¹hei¹². Ca¹chi¹jné¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jøng² ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¿He² jǿg³ ca¹të́h²hning quianh¹³ jní², Jesús, jong¹² Diú¹³ juanh¹²? Juǿi²jni hning² hi² tsa¹jmogh¹³hning jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Lah¹jøng² ca¹juúh² jmi²dsí² hlaih¹³. Di³ ma²na²juúh² Jesús, na²tsáih¹dsa jmi²dsí²: ―¡Jú¹² quiah¹² dsa² ná¹²! ―ma²na²juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa jmi²dsí² hlaih¹³: ―¿He² tsenh²hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² calah jmi²dsí²: ―Legión báh³ tsen²jni. Di³ juai¹² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jøng² ca¹møa¹ jmi²dsí² hi² tsa¹mi³huø¹ Jesús huø¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cøg¹² jøng² mi³tiogh³ jue¹² ŋié¹². Mi³ti³gøah¹²jah høg² nung² huu¹³ máh². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jøng² ca¹møa¹ jmi²dsí², ca¹juúh²dsa: ―¡Tse² jnieh³ quianh¹³ ŋié¹²! Mi³jøng² cán² ŋié¹² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jøng² ca¹cuø¹ Jesús jǿg³. Hi² jøng² ca¹huøh¹² jmi²dsí² hlaih¹³ quiah¹² dsa² ŋioh¹² héi². Ca¹can¹ ŋié¹². Jøng² ca¹ŋi¹lé² ŋié¹² gu¹hei¹², cónh¹ ton¹ mei¹³ jáh². Ca¹siúgh² jáh² ja³chi³dsió¹³. Ca¹dsan¹jah niúh¹ jmǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jøng² ca¹cuøin¹ dsa² mi³jmo¹² hí³ jáh². Ca¹he¹dsa jǿg³ jøa³juøi² lah¹quianh¹³ dsi²juu¹². Jøng² ca¹ŋi¹lé² dsa² ŋi³jái³ he² ma²na²løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jøng² mi³ca¹dsi¹lé² dsa² héi² ja³tsenh¹³ Jesús, ca¹jë́²dsa dsa² ŋioh¹² héi², dsa² mi³quin¹² jmi²dsí² hlaih¹³. Ja³jøng² ma²guǿ¹²dsa. Ma²caih¹²dsa tsǿnh³. Ma²dsiog¹dsa, dsa² mi³quin¹² hliú² jmi²dsí² héi². Jøng² gøg² ca¹can¹ dsa² ca¹dsi¹lé². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jøng² dsa² ca¹jái¹ ha²lah na²løa¹, ca¹heh¹dsa dsa² ca¹dsi¹lé² jǿg² ha²lah ca¹jính¹ ŋié¹², ha²lah ca¹jính¹ dsa² mi³quin¹² hliú² jmi²dsí² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jøng² ca¹tsáih¹ dsa² chian² ja³jøng² Jesús, hi² mi³u¹hai¹² Jesús go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jøng² ja³ma²uǿi² Jesús barco, ca¹møa¹ dsa² mi³quin¹² jmi²dsí² hlaih¹³ héi² chi²júh² cuø¹ Jesús jǿg³ hi² dság¹dsa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Cónh¹jøng² ha¹chi² ca¹cuø¹ Jesús jǿg³. Ca¹juúh²dsa: ―Dsio¹ báh³ guǿnh³hning. Gu³tseih³hning dsa² quiánh²hning ha²lah ma²ca¹jmo¹ Juuh²hning, ha²lah ma²ca¹jmo¹dsa huø³ dsǿa¹² ja³cogh²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jøng² ca¹ŋó¹ dsa² héi² juu¹² ja³tioh¹³ juøi² tǿh²dsa Decápolis. Ca¹ŋi³hǿ¹³dsa jǿg³ ha²lah ca¹jmo¹ Jesús ja³cog²dsa. Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² ca¹nǿng² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jøng² jue¹² hlaih¹³ dsa² ca¹túgh² quianh¹³ Jesús calah, mi³ca¹dsiánh¹dsa hŋoh¹³ jmøi². Ma²tiogh³dsa chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jøng² ca¹dsiég¹ jan² dsa² lán¹² ta³ quiah¹² guøh¹², dsa² tsen² Jairo. Ca¹chi¹jné¹ dsa² héi² mi³ca¹jë́²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ca¹tsáih¹dsa Jesús, ca¹juúh²dsa: ―Ma²tǿ² ja³jón² ja³mái¹jni. Juanh¹² jmóh³hning hoh¹². Gu³quiegh²hning gugh² ni³ quiah¹²dsa. Mi³jøng² hliú²dsa. Tsa¹jón²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jøng² ca¹ŋó¹ Jesús quianh¹³dsa. Jø¹² bíh³ ca¹ŋi¹lé² dsa² jue¹² ca¹lah¹cu²hliah¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jøa³ dsa² jue¹² mi³hiúg³ jan² hio¹³ dsoh³, dsa² lán¹² dsag³ ton². Ma²ni³ŋó¹³ guie¹tǿn² ji²ŋi² hi² dsoh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jue¹² tø²mǿa¹² ma²ca¹jmo¹ hí³. Ma²ca¹hén² hio¹³ cog³ quiah¹²dsa ca¹lah¹jǿ¹. Di³ ha¹chi² ca¹jŋi¹ dsag³. Hiug¹² jín³ hi² ca¹ja¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jøng² ma²ca¹nǿng² hio¹³ jǿg³ quiah¹² Jesús. Hi² jøng² ca¹ŋó¹dsa tø¹lah¹cah¹³ Jesús jøa³ ja³dsø²lé² dsa² jue¹². Jøng² ca¹láh² hio¹³ tsǿnh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Di³ lë́²dsa: “Cónh¹ lah¹³jni tsǿnh³dsa. Di³ jøng² hliú²jni,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dsø¹juu¹² jøng² mi³ca¹láh² hio¹³ tsǿnh³ Jesús, ca¹jŋi¹ ton²dsa. Jøng² ca¹lø¹lih¹³ hio¹³ ca¹hlú²dsa dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jø¹² bíh³ ma²ŋi¹² Jesús ca¹cuúh¹dsa dsa² bí². Hi² jøng² ca¹jénh¹dsa jøa³ dsa² jue¹². Ca¹juúh²dsa: ―¿Hein² na²láh² tsønh¹jni? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jøng² ca¹juúh² dsa² quianh³ Jesús: ―Ma²jáih²hning hi² cu²hliah¹² dsa² jue¹² hning². ¿He² løa¹ ŋaih³hning hein² na²láh² tsǿinh² hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Cónh¹jøng² cøng² hi² jái¹² Jesús lah¹jin² lah¹lǿih¹, hi² hnah¹²dsa dsa² ca¹jmo¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jøng² ma²ŋi¹² hio¹³ he² ma²na²jính¹dsa. Hi² jøng² ca¹chi¹jné¹dsa ni³ Jesús. Ma²jlia¹²dsa hi² goh¹²dsa. Ca¹he¹dsa jǿg³ he² ma²na²løa¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Ma²na²hlúh²hning, jon¹². Di³ héh²hning jǿg³ quieg¹ jní². Ma²lé² guǿnh³hning ca¹lah¹hiug² hoh¹²hning. Na¹ báh³ ma²na¹jŋi¹ dsag³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lah¹jøng² chi³hløah¹² Jesús mi³ca¹dsi¹lé² dsa² ja²lé² juu¹² ja³quiah¹³ dsa² ta³ quián¹² guøh¹² héi². ―Ma²na²jon¹ ja³máih¹hning ―ca¹juúh² dsa² ca¹dsi¹lé², ca¹tsáih¹dsa Jairo ―Tiúh¹ báh³ tsa¹ma¹cuøh¹³hning tøa¹² ju²méh³ dsøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Cónh¹jøng² ha¹chi² ca¹tónh¹ Jesús juu¹² jǿg³ ca¹juúh² dsa² héi². Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² ta³ héi²: ―¡Tsa¹jmo² ju²hí³ dsøa¹²! Cøng² hi² héh² báh³ hning² jǿg³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jøng² tsa¹ma¹ca¹cuø¹ Jesús jǿg³ hi² dsa¹le² dsa² jue¹² quianh¹³dsa, jmáh¹lah Pedro, quianh¹³ Jacobo, quianh¹³ Juan, roh¹³ Jacobo. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jøng² mi³ca¹dsi¹lé²dsa ja³quiah¹³ dsa² ta³, ca¹jái¹ Jesús hi² ma²tiogh³dsa cu²møah¹³. Tø²ho¹²dsa ca¹lah¹cu²møah¹³ cu¹té¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jøng² mi³ma²hiúg³ Jesús dsi²néi², ca¹juúh²dsa: ―¿He² løa¹ tø²høgh² hniah¹²? ¿He² løa¹ tiogh³ hniah¹² cu²møah¹³? Ha¹chi² ma²na²jon¹tsih. Rø²güé¹ báh³ tsih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jøng² ca¹ŋǿi² dsa² tiogh³. Di³ jøng² ca¹huan¹ Jesús dsa² héi². Jøng² ca¹ŋó¹dsa cøg¹² ja³rø²quia¹²tsih. Quianh¹³dsa chiég³ jmi²tsih, quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jøng² ca¹chính²dsa gug²tsih. Ca¹juúh²dsa: ―Talita, cumi ―ca¹juúh²dsa, hi² hniu¹dsa juúh²dsa: “Hning² juǿi²jni tsih². ¡Nung²!” ");
INSERT INTO cpaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dsø¹juu¹² jøng² ca¹nung² báh³ tsih². Ca¹ŋøa¹ báh³ tsih². Di³ hiúg³tsih ma¹guie¹tǿn² ŋih¹². Jøng² ca¹can¹ hlaih¹³ dsa² tiogh³ gøg². ");
INSERT INTO cpaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jøng² hiug¹² ja¹² ca¹juúh² Jesús: ―Ha¹chian² dsa² gu³tseih³ hniah¹² jin³ hein² he² hi² na²løa¹. ¡Cuøh¹³ hniah¹² tsih² hi² gǿh¹tsih! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jøng² ca¹u¹hái¹ Jesús ja³jøng². Ca¹ŋáh¹dsa juu¹² go²dsa. Quianh¹³dsa dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jøng² ca¹he¹dsa jǿg³ quiah¹² Diú¹³ guøh¹² jmai³ sa³¹. Jøng² dsogh¹² dsǿa¹² dsa² jue¹², dsa² ca¹nǿng² jǿg³. Ca¹juúh²dsa: ―¿Ha² tøah¹ ca¹mi¹tan¹² dsa² ná¹² jǿg³ ma¹dsio¹² ma²ŋi¹²dsa? ¿Ha²lah të²dsa jmo¹² juu¹² juøh¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Tsa³lán¹² dsa² ná¹² tøa¹²hmá¹, ja³ŋiúh³ María, dsa² lán¹² roh¹³ Jacobo quianh¹³ José quianh¹³ Judas quianh¹³ Simón? ¿Tsa³tiogh³ mǿ² roh¹³dsa ja³la² jøa³ ja³tiagh³ jniang³? ―ca¹juúh²dsa. Jøng² ca¹lø¹hioh¹dsa quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ca¹lah¹já¹ báh³ dsa² jmo¹² juanh¹² dsa² hǿ² jǿg³ quiah¹² Diú¹³. Jmáh¹lah dsa² go²dsa tsa¹jmo¹, quianh¹³ ju³roh¹³dsa, dsa² tiogh³ dsi²néi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hi² jøng² tsa¹ca¹løa¹ hi² jmo¹ Jesús juu¹² juøh¹² juøi² go²dsa jøng². Cónh¹ ca¹dsii¹dsa gug²dsa ni³ quiah¹² jan² og¹ dsa² dsoh³. Ca¹mi¹hliú²dsa dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jøng² dsogh¹² dsǿa¹² Jesús ni³ huu¹³ tsa¹hé² dsa² go²dsa jǿg³ quiah¹²dsa. Jøng² ca¹ŋi¹he¹ Jesús jǿg³ quiah¹² Diú¹³ juøi² tioh¹³ cøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jøng² ca¹tǿh¹dsa dsa² guia¹tón². Ca¹tse¹dsa ma¹og¹ dsa². Ca¹cuø¹dsa bí² hi² tiá¹dsa jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tsa¹ca¹cuø¹dsa jǿg³ hi² cán²dsa jin³ he² quiah¹² dsi²juu¹². Tsa¹cán²dsa hé¹². Tsa¹cán²dsa mu²ra³. Tsa¹cán²dsa cog³. Jmáh¹lah hma² hø¹³ báh³ chính²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tóh¹dsa løg² ca²jag¹³ tai³dsa. Ha¹chi² cáih¹dsa ton¹ tsǿnh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jøng² ca¹juúh² Jesús: ―Jøng² ha² ja³ca¹cuø¹dsa hniú¹², cøng² hniú¹² jøng² báh³ túgh³ hniah¹² ca¹lah¹ca¹tǿ² ja³gu³noh¹² hniah¹² juøi² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jøng² ha² ja³tsa¹hie¹dsa hniah¹², ho¹ ju³ tsa¹nang¹dsa jǿg³ quiánh² hniah¹², hueh¹² hniah¹² ja³jøng². Jøng² quiah¹³ hniah¹² hleg² ti³quin¹² joh¹³ taih¹ hniah¹², hi² jmóh³ hniah¹² tsa¹jeh¹³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jøng² ca¹ŋi¹lé² dsa² guia¹tón². Ca¹ŋi³téng³dsa jǿg³ hi² hniuh¹² jéinh¹ dsǿa¹² dsa² jmøi¹guǿi¹ ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ca¹huø¹dsa hliú² jmi²dsí² hlaih¹³. Ca¹tsǿng²dsa aceite quiah¹² dsa² dsoh³. Ca¹mi¹hliú²dsa dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jøng² ca¹nǿng² rai¹³ Herodes ha²lah ma²jmo¹² Jesús. Di³ ma²ca¹tsø² ca¹ja¹ jǿg³ quiah¹²dsa. Jøng² ca¹juúh² ca²dsiog³dsa: ―Ma²ca¹hiog² Juan, dsa² ca¹chiog¹ dsa² jmøi². Dsa² héi² báh³ Jesús. Hi² jøng² báh³ lǿ² juu¹² juøh¹² quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jøng² ca²dsiog³dsa ca¹juúh²: ―Hlai³ Elías báh³ héi² ―ca¹juúh²dsa. Cónh¹ calah dsa² siáh² ca¹juúh²: ―Dsa² hǿ² jǿg³ quiah¹² Diú¹³ báh³ Jesús. Lán¹²dsa ju³lah mi³lán¹² dsa² mi³hǿ² jǿg³ ma²lǿih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jøng² lah¹la² ca¹juúh² Herodes mi³ca¹nǿng²dsa: ―Ma²ca¹hiog² Juan, dsa² ca¹quiúh¹jni lag³. Dsa² héi² báh³ Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Lah¹jøng² ca¹juúh² Herodes. Di³ hŋiah¹² Herodes ma²ca¹tse¹ dsa² ca¹ŋi³chiánh³ Juan. Ca¹tangh¹²dsa hni¹ŋí³. Di³ lah¹la² ma²ca¹løa¹: Ca¹jian¹ Herodes hio¹³ mi³jian¹² Felipe, roh¹³dsa. Herodías mi³tsen² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jøng² ca¹juúh² Juan, ca¹tsáih¹dsa Herodes: ―Tsa¹lé² janh¹³hning hio¹³ quián¹² rúh²hning ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hi² jøng² ca¹lø¹hian¹³ Herodías Juan. Mi³jŋaih¹dsa. Di³ tsa¹lé². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Di³ gan¹ Herodes Juan. Ma²ŋi¹² Herodes hi² lán¹² Juan dsa² dsiog¹, dsa² quián¹² Diú¹³. Hi² jøng² ca¹tanh¹²dsa Juan hni¹ŋí³, ja³lǿa¹² hí³ quiah¹²dsa. Jøng² ca¹lah¹hiu³ dsǿa¹² Herodes ca¹nǿng²dsa jǿg³ juúh² Juan, ta³lah¹chian²dsa ju²hí³ dsøa¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jøng² ca¹dsóh¹ Herodías mai³¹ ha²lah jón² Juan mi³ca¹jmo¹ Herodes jmai³ ca¹dsóh¹dsa ji²ŋi². Jue¹² dsa² ta³ ca¹túgh² mesa quianh¹³dsa, quianh¹³ juu¹³ hlég², quianh¹³ dsa² canh¹³ chian² huø¹ Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jøng² ca¹hí¹ ja³mái¹³ Herodías ja³tiogh³ dsa² héi². Ca¹jmo¹dsa jan³ ja³ta¹ni¹dsa. Jøng² ca¹tǿ² dsǿa¹² Herodes quianh¹³ ca¹lah¹já¹ dsa² tiogh³ mesa. Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa tsih²mǿ²: ―¡Møa³ he² hi² hnøngh²hing! Jøng² cuø¹³ báh³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ca¹mi¹dsøg¹²dsa jǿg³ hi² lah¹dsóh² cuø¹dsa he² ca¹møa¹ tsih²mǿ², ca¹tǿ² ton¹dsoh¹³ hi² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jøng² ca¹u¹hái¹ tsih²mǿ². Ca¹ŋǿh¹dsa mi³chiég³dsa: ―¿He² hi² dsio¹ møa³jni? ―ca¹juúh²dsa. Jøng² ca¹juúh² mi³chiég³tsih: ―Mǿh³hning dsi³ Juan, dsa² ca¹chiog¹ dsa² jmøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jøng² ca¹ŋó¹ calah tsih²mǿ² dsø¹juu¹² juu¹² ja³guǿ¹³ rai¹³. Ca¹juúh²dsa: ―Ta¹na¹ cónh¹ mi³hno¹jni dsi³ Juan, dsa² ca¹chiog¹ dsa² jmøi² héi², hi² ma²hiu³ uøin¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jøng² ca¹táh² dsǿa¹² rai¹³ mi³ca¹nǿng²dsa jǿg³ jøng². Cónh¹jøng² ha¹chi² hniu¹dsa hén²dsa jǿg³ ma²ca¹mi¹dsøg¹²dsa ja³ca¹nǿng² dsa² jue¹² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hi² Jøng² ca¹tse¹dsa hlég² dsø¹juu¹², dsa² quianh¹³ dsa² jmo¹² hí³ hni¹ŋí³. Ca¹jmo¹dsa héh¹ hi² ŋi³quieng³dsa dsi³ Juan. Jøng² ca¹ŋi³quiuh² hlég² lag³ Juan hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jøng² ca¹cáng¹dsa dsi³ Juan hi² ma²hiu³ uøin¹². Ca¹cuúh¹dsa tsih²mǿ². Jøng² ca¹cuúh¹ tsih²mǿ² mi³chiég³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jøng² mi³ca¹nǿng² dsa² mi³quianh¹³ Juan ha²lah ca¹løa¹. Ca¹ŋi³tei²dsa hlai³. Ca¹ŋi¹hǿg²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jøng² ca¹dsi¹lia¹ calah dsa² ca¹tse¹ Jesús, dsa² ma²lán¹² ju³lah tsih² høh³ quián¹²dsa. Jøng² ca¹tsáih¹dsa Jesús ca¹lah¹jǿ¹ hi² ca¹jmo¹dsa, hi² ca¹he¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ma¹dsǿg³ jniang³ cøng² ja³cu³guiag¹³ jniang³. Dsa³jŋi³ jniang³ cu²hna² ―ca¹juúh²dsa. Di³ cøng² hi² ja¹lé² dsa¹lé² dsa² jue¹², ca¹lah¹jín³ tsa¹lé² gǿh¹ Jesús quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jøng² ca¹ŋi¹lé²dsa juu¹² barco cu³guiog³dsa, juu¹² ja³ha¹chian² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cónh¹jøng² ca¹jǿi² báh³ dsa² jue¹². Ca¹lø¹lih¹³dsa ha² juu¹² ma²dsø²lé²dsa. Hi² jøng² ca¹ŋi¹lé² dsa² jue¹² gu¹hei¹² juu¹² tai³dsa, dsa² chian² hliú² juøi². Ca¹ŋi¹jián¹³dsa ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jøng² ca¹ŋi¹ŋiú² dsǿa¹² Jesús mi³ca¹jë́²dsa dsa² jue¹², ja³ca¹u¹hái¹dsa barco. Di³ lë́²dsa hi² ti³lán¹² dsa² jue¹² ju³lah lán¹² jah¹chih² ha¹chian² juu¹³. Hi² jøng² ca¹heh¹ Jesús dsa² héi² ma¹dsio¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mi³ca¹hlég² jøng², ca¹ŋi¹lé² dsa² quianh¹³ Jesús cøg¹² ja³tsenh¹³dsa. Ca¹juúh²dsa: ―Ca¹hlég² báh³ la². Jin³ hein² dsa² ha¹chian² tiogh³ ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jøng² dsianh¹³hning dsa² jue¹². Mi³jøng² dsa¹lé²dsa rancho quianh¹³ juøi² tioh¹³ cøg¹², hi² dsa¹lii¹²dsa hi² gǿh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Hniah¹² cuúh³ hi² gǿh¹dsa ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―¿Hnøngh³hning hi² dsø³lii¹³ jnieh³ hŋí² ŋi²lǿg² héh¹ cog³ hi³ŋíh¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jøng² ca¹juúh² Jesús: ―¿Ha²cónh¹ hi³ŋíh¹ quinh³ hniah¹²? ¡Gu³jái¹³ di³ cøng²! ―ca¹juúh²dsa. Jøng² mi³ca¹jái¹dsa, ca¹juúh²dsa: ―Hŋí² hi³ŋíh¹ quin³ jniang³, quianh¹³ og¹ jáh² tiogh³ jmøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jøng² ca¹jmo¹ Jesús jǿg³ hi² túgh¹ dsa² jue¹² ja³jøng², ja³mi³dsi¹³ ŋi²mah² tsíh², hi² túgh¹dsa ma¹cu²tséh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jøng² ca¹túgh²dsa ma¹cu²tséh¹dsa, ma¹to¹lu¹guián²dsa, ma¹ŋia²lúg²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jøng² ca¹can¹ Jesús hŋí² hi³ŋíh¹ jøng² quianh¹³ og¹ jáh² tiogh³ jmøi² héi². Ca¹jái¹dsa juu¹² guiuh¹³. Ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³ hi³ŋíh¹. Ca¹cuúh¹dsa dsa² quianh¹³dsa hi² dsiúh¹dsa. Jø¹² bíh³ ca¹dsiúh¹dsa quiah¹² og¹ jáh² héi² ca¹lah¹já¹ dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ca¹lah¹já¹ báh³ dsa² ca¹gǿh¹. Ca¹lø¹tan¹³ báh³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jøng² ca¹mi¹cángh²dsa guie¹tǿn² møh²tá³ jmáh¹lah jneh³ hi³ŋíh¹ quianh¹³ jáh², hi² ca¹chiág¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jøng² hŋí² mei¹³, jmáh¹lah dsa² ŋioh¹², dsa² ca¹gǿh¹ hi³ŋíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dsø¹juu¹² jøng² ca¹jmo¹ Jesús héh¹ hi² dsa¹lé² dsa² quianh³dsa juu¹² barco, dsa¹jián¹³dsa chiuh³ jmøi² ca²ton², juu¹² jøa³juøi² Betsaida, ta³lah¹jøng² dsiánh²dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jøng² mi³ca¹dsiánh² Jesús dsa² jue¹², ca¹ŋó¹dsa juu¹² máh², ja³ca¹ŋi¹hlanh¹dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jøng² ma²hei¹² barco quiah¹² dsa² quianh³dsa dsi²jo² jmøi² juøh¹² mi³ca¹neng². Ma²tsenh¹² Jesús ni³ huø¹, ja³cu³hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jøng² ca¹jái¹ Jesús ma²ué² quiah¹² dsa² jmo¹² ŋøa¹ barco. Di³ ma²já¹² dsí² ni³ ja³dság¹²dsa. Jøng² tø¹lah¹ja³jní¹ ca¹ŋó¹ Jesús juu¹² ja³dsø²lé² dsa² héi². Ca¹ŋøa¹ Jesús ni³ jmøi². Mi³dsø¹jián¹³dsa ni³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cónh¹jøng² ca¹ho¹ dsa² héi² tí² mi³ca¹jái¹dsa hi² ma²ŋøa¹² Jesús ni³ jmøi². Lë́² dsa² héi² hi² lán¹² Jesús jan² dsa² gu²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ca¹lø¹goh¹²dsa mi³ca¹jǿi² ca¹lah¹já¹ dsa² héi². Dsø¹juu¹² jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Tsa¹juéh² hniah¹²! Jní² báh³ lang¹². ¡Tsa¹jmo² ganh¹! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jøng² mi³ca¹uǿi² Jesús barco, ca¹jŋi¹ dsí². Jøng² ca¹lø¹dsogh¹² hlaih¹³ dsǿa¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Di³ tsa¹ca¹lø¹ŋë́h² dsǿa¹²dsa juu¹² juøh¹² quiah¹² hi³ŋíh¹. Hiug¹² huh² dsi³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jøng² ca¹dsi¹lé²dsa hŋoh¹³ jmøi² ca²ton², huø¹ ja³tén¹² Genesaret. Ja³jøng² ca¹cǿin²dsa barco chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dsø¹juu¹² jøng² ca¹lø¹cuai¹² dsa² chian² ja³jøng² mi³ca¹siog²dsa barco. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jøng² ca¹ŋi¹lé² dsa² jue¹² ta³cøng² juøi². Ca¹ŋi³jian³dsa dsa² dsoh³. Ca¹ŋi³jiag³dsa hi² tiogh³dsa jein³ ha² juu¹² ja³ma²ca¹nǿng²dsa hi² ma²guǿ¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jøng² ca¹tógh¹dsa dsa² dsoh³ jøa³hmah³ lǿa¹² ju³ ha² juu¹² ca¹dsiég¹ Jesús, ho¹ ju³ juøi² juøh¹², ho¹ ju³ juøi² mih², ho¹ ju³ rancho. Ca¹tsáih¹dsa Jesús chi²júh² lé² láh² dsa² dsoh³ ca¹lah¹cónh¹ hé¹ tsǿnh³dsa. Jøng² ca¹hlú² báh³ ca¹lah¹já¹ dsa² ca¹jmo¹ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jøng² ca¹túgh² dsa² fariseo quianh¹³ ca²dsiog³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, dsa² chian² jøa³juøi² Jerusalén. Ca¹túgh²dsa ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jøng² ca¹jái¹ dsa² héi² hi² gøah¹² ca²dsiog³ dsa² quianh³ Jesús hi² tsa¹ti³jai¹ gug²dsa, hi² tsa¹rø²jŋǿi³. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Di³ tsa¹gǿh¹ dsa² fariseo, quianh¹³ ca¹lah¹já¹ dsa² judío, ju³ná³ tsa¹ni³tih¹³dsa rang¹dsa gug²dsa cu²rø², ju³lah lǿa¹² mai³¹ ca¹já¹ quiah¹² dsa² hóg¹ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jøng² ha¹chi² gǿh¹dsa mi³na²u³ŋie¹dsa jøa³hmah³, ju³ná³ tsa¹ca¹jmo¹dsa ti³jan¹dsa ju³lah lǿa¹² mai³¹ quiah¹²dsa. Jøng² hliú² mai³¹ lah¹jøng² quin¹²dsa, ju³lah ja³rang¹²dsa taza, ja³rang¹²dsa dsøg³, ja³rang¹²dsa tøh¹²ŋí³.) ");
INSERT INTO cpaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jøng² ca¹juúh² dsa² fariseo quianh¹³ tøa¹² he¹² lei¹³ héi², ca¹tsáih¹dsa Jesús: ―¿He² løa¹ tsa¹mi²ti¹ dsa² quianh³hning mai³¹ quiah¹² dsa² hóg¹? Di³ gøah¹²dsa hi² tsa¹ti³jai¹ gug²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jøng² ca¹juúh² Jesús: ―Dsa² tø²cah¹ tø²jen¹² báh³ hniah¹². Rø² báh³ ca¹tǿ² jǿg³ ca¹juúh² hlai³ Isaías, mi³ca¹hia¹dsa hniah¹² jǿg³ la², ju³lah lǿa¹² si² quiah¹²dsa: Jǿg³ dsio¹ báh³ tsaih¹²dsa jní², juúh² Diú¹³. Di³ ha¹chi² dsø²jiag¹² dsǿa¹²dsa jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jøng² ha¹chi² quien¹² hi² hlaih¹²dsa jní². Jǿg³ quiah¹² Diú¹³ báh³ he¹²dsa, juúh²dsa. Cónh¹jøng² jǿg³ ca¹jmo¹ dsa² jmøi¹guǿi¹ báh³ jøng², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Di³ tsa¹hnøngh² hniah¹² lei¹³ quiah¹² Diú¹³. Jmáh¹lah mai³¹ quiah¹² dsa² jmøi¹guǿi¹ báh³ chinh³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jøng² ca¹juúh²dsa calah: ―Li³hioh¹³ ma²ca¹tiúh¹ hniah¹² lei¹³ quiah¹² Diú¹³. Mi³jøng² lé² gu³noh¹² hniah¹² jmáh¹lah mai³¹ quiánh² báh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lah¹la² rø²juúh² lei¹³ quiah¹² Diú¹³: “Ju³mi³juanh¹³ hniah¹² chiegh² ŋieih¹² hniah¹². Ju³jón³ dsa² hløah¹² jǿg³ hlaih¹³ quiah¹² chiég³ jmi²dsa,” rø²juúh² lei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jøng² lah¹la² báh³ juúh² hniah¹²: “Lé² báh³ tsáih¹dsa chiég³ jmi²dsa hi² tsa¹lé² cuø¹dsa hi² mi³cuø¹dsa. Di³ la³ma²ca¹cuúh¹dsa Diú¹³,” juúh² hniah¹². (Corbán bah³ tǿh²dsa hi² ma²ca¹cuúh¹dsa Diú¹³.) ");
INSERT INTO cpaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jøng² tsa¹cuúh³ hniah¹² jǿg³ hi² mi¹hóg¹³ dsa² héi² chiég³ jmi²dsa, ju³ná³ ca¹tsáih¹dsa lah¹jøng² chiég³ jmi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hi² jøng² ma²jmo¹² mai³¹ quinh³ hniah¹² hi² tsa¹ma¹quien¹² lei¹³ quiah¹² Diú¹³. Hliú² hi² lah¹jøng² jmoh² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jøng² ca¹tǿh¹ Jesús calah dsa² jue¹². Ca¹juúh²dsa: ―¡Neng² di³ hniah¹², ca¹lah¹jáh¹ hniah¹²! ¡Quin² hniah¹² hí³! ");
INSERT INTO cpaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ha¹chi² chi² hi² gǿh¹ dsa² jmøi¹guǿi¹ hi² jmo¹ tsa¹ti³jan¹dsa ja³cog² Diú¹³. Jǿg³ hi² dsø²jiag¹² dsǿa¹²dsa báh³ jmo¹² hi² tsa¹ti³jan¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ju³ná³ hein² dsa² lé² nang¹, ju³neng¹³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jøng² ca¹tiúg² Jesús dsa² jue¹². Ca¹ŋáh¹dsa dsi²néi². Jøng² ca¹ŋai¹ dsa² quianh³dsa he² hniu¹dsa juúh²dsa jǿg³ ma²na²dsii¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jøng² ca¹juúh² Jesús: ―¡Ha²lah dsio¹ tsa¹ŋë́h² hniah¹² calah! Jai³lah. Ha¹chi² tø¹canh¹³dsa ja³cog² Diú¹³, hi² jmo¹ hi² gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Di³ ha¹chi² dsa¹lé² hi² jøng² juu¹² jmi²dsí² quiah¹²dsa. Dsa¹lé² juu¹² togh¹² báh³ dsa². Hi² tag¹² báh³ dsa² hi² jøng². (Quianh¹³ jǿg³ jøng² ca¹mi¹léi¹³ Jesús hi² lé² quie¹³ jniang³ ca¹lah¹i³ ni³ má¹.) ");
INSERT INTO cpaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jøng² ca¹juúh² Jesús calah: ―Hi² dsø²jiag¹² dsǿa¹² dsa² jmøi¹guǿi¹ báh³ jmo¹² hi² tø¹canh¹³dsa dsag³ ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Di³ niúh¹ tu²dsǿa¹²dsa huøh¹² hi² hlaih¹³ hi² neng¹² dsǿa¹²dsa, he² hi² mi³jmo¹dsa: Ho¹ ju³ dsii¹dsa jǿg³ quianh¹³ hio¹³ tsa¹ma²jenh² gug², ho¹ ju³ hio¹³ ma²jian¹² dsa² siáh², ho¹ ju³ jmo¹dsa høin², ho¹ ju³ jŋëh¹dsa dsa², ");
INSERT INTO cpaNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ho¹ ju³ hi² hniu¹dsa hi² chi² quiah¹² dsa², ho¹ ju³ jmo¹dsa hi² ue¹² dsǿa¹²dsa, ho¹ ju³ mi¹gag¹²dsa, ho¹ ju³ lø³hiug¹²dsa, ho¹ ju³ dsih¹²dsa, ho¹ ju³ hlaih¹³ quian¹dsa dsa², ho¹ ju³ lë́²dsa canh¹³dsa guiog¹³dsa, ho¹ ju³ tsa¹juøi² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ca¹lah¹jǿ¹ hi² hlaih¹³ jøng² huøh¹² juu¹² tu²dsǿa¹² dsa² jmøi¹guǿi¹. Hi² jøng² báh³ jmo¹² tø¹canh¹³dsa dsag³ ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jøng² ca¹ŋó¹ Jesús juu¹² ja³tén¹² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón. Ca¹hí¹dsa dsi²néi², hi² tsa¹hniu¹dsa li¹ŋi¹² dsa². Cónh¹jøng² tiog¹³ báh³ ca¹lø¹ŋi¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jøng² ca¹lø¹ŋi¹² jan² hio¹³, dsa² chian² jan² ja³mái¹³. Quin¹² ja³mái¹³dsa jmi²dsí² hlaih¹³. Dsø¹juu¹² jøng² ca¹ŋó¹ hio¹³ héi² juu¹² ja³guǿ¹³ Jesús. Ca¹chi¹jné¹dsa ja³ta¹ni¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dsa² griego báh³ hio¹³ héi², dsa² ca¹lø¹chián¹ Sirofenicia. Ca¹mǿh¹ hio¹³ Jesús chi²júh² dsi¹ Jesús jmi²dsí² hlaih¹³ quin¹² ja³mái¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Ju³mi³ho³jni dsa² go²jni ni³jiá¹. Tsa¹dsio¹ cang¹dsa má¹ hi² mi³gǿh¹ guing², hi² cuúh¹dsa dsøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jøng² ca¹juúh² hio¹³: ―Lǿa¹² báh³ lah¹jøng², Guiuh¹³. Di³ ca¹tǿ² dsøi² báh³ gǿh¹ ti³jneh³ quia¹² ni³ mesa quiah¹² guing² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jøng² ca¹juúh² Jesús: ―Dsio¹ báh³ ma²na²juúh²hning. Hi² jøng² ma²lé² guǿnh³hning. Di³ ma²na²u¹hái¹ báh³ jmi²dsí² hlaih¹³ mi³quin¹² ja²máih¹hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jøng² ca¹ŋáh¹ hio¹³. Ca¹dsanh¹²dsa ja³mái¹³dsa, hi¹ rø²quia¹²dsa ni³ jein³. Ma²ca¹u¹hái¹ jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jøng² ca¹u¹hái¹ Jesús ja³tén¹² Tiro. Ca¹tsø³jue¹³dsa ja³tén¹² Sidón quianh¹³ Decápolis. Jøng² ca¹dsiánh¹dsa chiuh³ jmøi² juøh¹² quiah¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ja³jøng² ca¹dsi¹jian¹ dsa² jan² dsa² guai³, dsa² tsa¹lé² hløah¹ cu²rø². Ca¹mǿh¹dsa Jesús hi² quiég¹dsa gug²dsa ni³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jøng² ca¹jiag¹ Jesús tø¹cøg¹², ja³tsa¹jái¹² dsa² jue¹². Jøng² ca¹tóh² Jesús chi³gug¹dsa tø²guø³ dsa² héi². Ca¹hŋiéng²dsa. Jøng² ca¹láh²dsa tsøh³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jøng² mi³ca¹jái¹dsa guiuh¹³, ca¹chiog¹dsa dsǿa¹²dsa. Jøng² ca¹juúh²dsa: ―¡Efata! ―ca¹juúh²dsa, hi² hniu¹dsa juúh²dsa: “¡Ju³ná³!” ");
INSERT INTO cpaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jøng² ca¹ná² guø³ dsa² héi². Ca¹lái¹ tsøh³dsa. Ma²lé² hløah¹²dsa cu²rø². ");
INSERT INTO cpaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jøng² hiug¹² ja¹² ca¹juúh² Jesús hi² tsa¹tsáih¹dsa jin³ hein² ha²lah ma²na²løa¹. Di³ ca¹lah¹cónh¹ jǿg³ ca¹juúh² Jesús hi² tsa¹dsii¹dsa, hiug¹² jín³ ma¹dsio¹² ca¹dsii¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jøng² dsogh¹² hlaih¹³ dsǿa¹²dsa. Ca¹juúh²dsa: ―Ca¹lah¹jǿ¹ báh³ ma²ca¹jmo¹ dsa² ná¹² dsio¹. Ca¹lah¹ca¹tǿ² dsa² guai³ jmo¹²dsa nang¹²dsa. Ca¹tǿ² dsa² cag³ jmo¹²dsa hi² hløah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jmai³ jøng² ca¹túgh² calah dsa² jue¹². Ha¹chi² chi² hi² li¹gǿh¹dsa. Jøng² ca¹tǿh¹ Jesús dsa² quianh³dsa. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Dsø²ŋiú² dsøa¹jni quiah¹² dsa² jue¹². Di³ ma²hnøa¹² jmai³ tiogh³dsa quianh¹³ jní². Jøng² tsa¹ma¹chi² hi² li¹gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tsa¹hno¹jni dsianh¹³jni dsa² hi² tsa¹ma²na²gǿh¹dsa, ju³ jmai³ tsa¹tiúh¹dsa dsi³lia¹dsa ja³quiah¹³dsa. Di³ uǿin² ja³tiogh³ ca²dsiog³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jøng² ca¹juúh² dsa² quianh³dsa: ―¿Ha² tøah¹ dsiagh¹ hi² gǿh¹ dsa² jue¹² ja³la², ja³tsa¹chian² dsa² tiogh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jøng² ca¹juúh² Jesús: ―¿Ha²cónh¹ hi³ŋíh¹ quinh³ hniah¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² quianh³dsa: ―Guio¹ hi³ŋíh¹ quin³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jøng² ca¹tsáih¹ Jesús dsa² jue¹² hi² túgh¹dsa huø¹. Jøng² ca¹can¹dsa guio¹ hi³ŋíh¹ jøng². Ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³ hi³ŋíh¹. Ca¹cuúh¹dsa dsa² quianh³dsa hi² dsiúh¹dsa. Ca¹dsiúh¹dsa quianh¹³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jøng² jian¹²dsa og¹ úg² jáh² tiogh³ jmøi². Jøng² mi³ca¹tsáih¹ Jesús Diú¹³ di³hmah³, ca¹jmo¹dsa héh¹ hi² dsiúh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jøng² ca¹gǿh¹ ca¹lah¹já¹dsa. Ca¹lø¹tan¹³dsa. Jøng² ca¹chiág¹ guio¹ møh²tá³ jneh³ hi³ŋíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ca¹lah¹cónh¹ quiún² mei¹³ dsa² mi³tiogh³. Jøng² ca¹dsiánh² Jesús dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dsø¹juu¹² jøng² ca¹ŋó¹dsa juu¹² barco quianh¹³ dsa² quianh³dsa. Ca¹ŋi¹lé²dsa juu¹² ja³tén¹² Dalmanuta. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jøng² ca¹dsi¹lé² ca²dsiog³ dsa² fariseo. Ca¹dsii¹dsa jǿg³ quianh¹³ Jesús. Hniu¹dsa hi² jmo¹ Jesús cøng² juu¹² juøh¹² quiah¹² Diú¹³. Di³ lë́²dsa chi²júh² tiúh¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jøng² ca¹táh² cøh² dsǿa¹² Jesús. Ca¹juúh²dsa: ―¿He² løa¹ tiog¹³ møh² hniah¹² juu¹² juøh¹²? Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² juu¹² juøh¹² jmo¹³jni quiánh² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jøng² ca¹tiúg² Jesús dsa² héi². Ca¹ŋó¹dsa juu¹² barco ca¹tǿ² chiuh³ jmøi² ca²ton². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jøng² tsa¹dsagh² dsǿa¹² dsa² quianh³ Jesús hi² mi³cán²dsa hi³ŋíh¹. Cøng² báh³ hi³ŋíh¹ quin¹²dsa niúh¹ barco. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jøng² ca¹tiogh² Jesús dsa² héi² jǿg³. Ca¹juúh²dsa: ―Jmóh³ hniah¹² hí³ chiúh³ hi³ŋíh¹ quiah¹² dsa² fariseo quianh¹³ dsa² quián¹² Herodes ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jøng² ca¹dsii¹ dsa² héi² jǿg³ guiog³dsa. Ca¹juúh²dsa: ―Hi² jøng² báh³ juúh²dsa lah¹jøng². Di³ ha¹chi² hi³ŋíh¹ quin³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jøng² ca¹lø¹lih¹³ Jesús tsa¹ca¹lø¹ŋë́h² dsǿa¹² dsa² héi² jǿg³. Jøng² ca¹juúh²dsa: ―¿He² løa¹ dsiih² hniah¹² jǿg³ hi² tsa¹quinh³ hniah¹² hi³ŋíh¹? ¿He² løa¹ tsa¹ŋë́h² hniah¹²? ¿He² løa¹ hiug¹² huh² dseih¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ni³ho¹² báh³ mi³neih³ hniah¹². ¿He² løa¹ tsa¹jniah¹ hniah¹²? Ti³dsøa¹³ báh³ guúh² hniah¹². ¿He² løa¹ tsa¹nøngh² hniah¹²? ¿Tsa³dsagh² hoh¹² hniah¹² ");
INSERT INTO cpaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ha²cónh¹ møh²tá³ jneh³ hi³ŋíh¹ ca¹chiág¹ jmai³ ca¹dsioh¹³jni hŋí² hi³ŋíh¹ ca¹lah¹cónh¹ hŋí² mei¹³ dsa²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² quianh³dsa: ―Guie¹tǿn² møh²tá³ báh³ ca¹chiág¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―¿Jøng² ha²cónh¹ møh²tá³ jneh³ hi³ŋíh¹ ca¹chiág¹ jmai³ ca¹dsioh¹³jni guio¹ hi³ŋíh¹ quianh¹³ quiún² mei¹³ dsa²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² quianh³dsa: ―Guio¹ møh²tá³ báh³ ca¹chiág¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jøng² ca¹juúh² calah Jesús: ―¿He² løa¹ tiog¹³ tsa¹ŋë́h² hoh¹² hniah¹² jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jøng² ca¹dsi¹lé²dsa jøa³juøi² Betsaida. Jøng² ca¹ŋi¹jian¹ ca²dsiog³dsa jan² dsa² teg³. Ca¹mǿh¹dsa Jesús hi² láh²dsa quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jøng² ca¹chính² Jesús gug² dsa² teg³. Ca¹jiag¹dsa juu¹² chiuh³ juøi². Jøng² ca¹hŋiéng² Jesús mø³ni³ dsa² héi². Jøng² mi³ca¹quieg² Jesús gug² ni³ quiah¹²dsa, ca¹ŋai¹dsa chi²júh² ma²lé² jái¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jøng² mi³ca¹jái¹ dsa² héi², ca¹juúh²dsa: ―Jniá¹² báh³ jní² dsa² ju³lah lǿa¹² hma² ni³tǿng². Jøng² lø²léi¹³jni dsa². Di² ŋi²nio³dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jøng² ca¹quieg² calah Jesús gug² mø³ni³ dsa² héi². Jøng² mi³ca¹tóh² dsa² héi² tí² mø³ni³dsa, ca¹hlú²dsa. Ma²jniuh¹²dsa cu²rø² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jøng² ca¹dsiánh² Jesús dsa² héi² juu¹² ja³quiah¹³dsa. Ca¹juúh²dsa: ―Tsa¹gu³ŋǿh³hning jøa³juøi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jøng² ca¹ŋó¹ Jesús quianh¹³ dsa² quianh³dsa. Ca¹ŋi¹lé²dsa juu¹² ja³tioh¹³ juøi² tén¹² Cesarea de Filipo. Ja³dsø²lé²dsa jøng², ca¹ŋǿh¹ Jesús dsa² quianh³dsa. Ca¹juúh²dsa: ―¿He² juúh² dsa² jue¹², hein² dsa² jní²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jøng² ca¹juúh² dsa² quianh³dsa: ―Chian² báh³ dsa² juúh² hi² lanh¹²hning hlai³ Juan, dsa² ca¹chiog¹ dsa² jmøi². Ca²dsiog³ dsa² juúh² hi² lanh¹²hning hlai³ Elías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jø¹² bíh³ chian² dsa² juúh² hi² lanh¹²hning jan² dsa² siáh², dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jøng² ca¹juúh² Jesús: ―Jøng² hniah¹², ¿hein² dsa² lán¹²jni, lë́h² hniah¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―Cristo báh³ lanh¹²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jøng² ca¹jmo¹ Jesús héh¹ hi² ha¹chian² hi² tsáih¹dsa jin³ hein². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ni³ jøng² ca¹heh¹ Jesús dsa² héi² jǿg³. Ca¹juúh²dsa: ―Hi² hniuh¹² can³jni ma¹dsio¹² jmø³uai¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Hi² hniuh¹² li¹hiag¹³ dsa² canh¹³, quianh¹³ juu¹³ jmi²dsa², quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Jøng² hniuh¹² jón²jni. Jøng² hiog¹jni jmai³ hnøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cu²rø² ca¹nií¹ Jesús jǿg³ jøng². Jøng² ca¹jiag¹ Pedro tø¹cøg¹². Ca¹jí² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jøng² ca¹jénh¹ Jesús. Ca¹jë́²dsa dsa² quianh³dsa. Jøng² ca¹jé² Jesús Pedro. Ca¹juúh²dsa: ―¡Guønh² tø¹cah¹jni! Jmoh²hning ju³lah jmo¹² Satanás. Ha¹chi² dsø²jiag¹² hoh¹²hning ju³lah jǿg³ dsø²jiag¹² dsǿa¹² Diú¹³. Dsø²jiag¹² hoh¹²hning jǿg³ quiah¹² dsa² jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jøng² ca¹tǿh¹ Jesús dsa² jue¹² quianh¹³ dsa² quianh³dsa. Ca¹juúh²dsa: ―Ju³ná³ hein² dsa² hniu¹ dság¹ quianh¹³ jní², jøng² tsa¹hniuh¹² høa¹dsa dsǿa¹² jǿg³ quiah¹² hŋiah¹²dsa. Ca¹lah¹jǿ¹ jmai³ mi¹hiúg¹dsa dsǿa¹² hie¹dsa jón²dsa huu¹³ quieg¹ jní². Jøng² báh³ dság¹dsa quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Di³ ju³ná³ hein² dsa² dsø²jiag¹² dsǿa¹² jmáh¹lah jǿg³ ha²lah guú¹dsa dsio¹ ni³ jmøi¹guǿi¹ la², ha¹chi² li¹hmah¹³ quiah¹²dsa jmøi¹guǿi¹ cøng². Cónh¹jøng² ju³ná³ hein² dsa² ca¹jon¹ huu¹³ quieg¹ jní², huu¹³ quiah¹² jǿg³ dsio¹ quiah¹² Diú¹³, dsa² héi² li¹chian² ja³dsio¹ jmøi¹guǿi¹ cøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ha¹chi² ta³ jmo¹ lǿh² jan² dsa² ta³cøng² jmøi¹guǿi¹ ju³ná³ dsø¹hén² jmi²dsí² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ha¹chian² dsa² tiúh¹ quíg¹, mi³jøng² liúg² jmi²dsí² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Di³ jmo¹³ báh³ jní² tsa¹cué¹²jni ju³lah hein² dsa² ca¹jmo¹ tsa¹cuai¹²dsa jní², tsa¹cuøh¹²dsa jǿg³ quieg¹jni ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jian¹²dsa, dsa² tsa¹gan¹ Diú¹³, dsa² ti³re² dsag³. Lah¹jøng² jmo¹³jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², na³ma²tǿ² jmai³ ja³guiogh¹³jni, na³ma²chi² bí² quieg¹jni, hi² quin³jni hma² høh³ quiah¹² Jmi² jniang³, hi² quianh¹³jni ángeles han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² dsiánh¹ ca²dsiogh³ hniah¹² tiogh³ ja³la² ca¹lah¹ca¹tǿ² ja³ca¹jaih³ hniah¹² ma²já¹ ja³jmo¹ Diú¹³ héh¹ quianh¹³ hi² tiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ja³jŋiéng² jmai³ jøng² ca¹jian¹ Jesús Pedro quianh¹³ Jacobo quianh¹³ Juan. Ca¹jiag¹dsa cøng² máh² ŋieing¹² ja³cu³guiog¹³dsa. Jøng² ca¹løa¹ ti³tsë́¹³ quiah¹² Jesús ja³ta¹ni¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ca¹løa¹ sih¹² tsǿnh³dsa. Teg² hlaih¹³ ca¹løa¹ ca¹lah¹cónh¹ hi² tsa¹lé² jmo¹dsa teg² ni³ guøh³ ni³ huø¹ la² hi² rang¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jøng² ca¹jnia¹ hlai³ Elías quianh¹³ hlai³ Moisés. Ca¹dsii¹ dsa² héi² jǿg³ quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Dsio¹ báh³ ma²tiagh³ jniang³ ja³la², Tøa¹². Ju³jmó³ jnieh³ hnøa¹² hio¹²: Cøng² quiánh² hning², cøng² quiah¹² hlai³ Moisés, cøng² quiah¹² hlai³ Elías ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Goh¹² hlaih¹³ Pedro quianh¹³ dsa² quianh¹³dsa. Hi² jøng² ca¹juúh²dsa lah¹jøng². Di³ tsa¹ŋi¹²dsa he² jǿg³ juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jøng² ca¹jlá¹dsa cøng² jneng¹². Jøa³jneng¹² jøng² ca¹hløah¹ Diú¹³. Ca¹juúh²dsa: ―Jesús lang¹² báh³ jon¹²jni. ¡Neng² jǿg³ quiah¹²dsa! ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dsø¹juu¹² jøng² ca¹jái¹ Pedro quianh¹³ dsa² quianh¹³dsa lah¹jin² lah¹lǿih¹. Ha¹chian² dsa² ma¹chian² quianh¹³ Jesús, ju³lah dsa² hóg¹ héi². Jan² Jesús ma²tsenh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jøng² ja³siog²dsa máh², ca¹jmo¹ Jesús héh¹. Ca¹juúh²dsa: ―Ha¹chian² dsa² gu³tseih³ hniah¹² jin³ hein² hi² ma²na²jaih³ hniah¹² ca¹lah¹ca¹tǿ² ja³ca¹hiog¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hi² jøng² ha¹chi² jǿg³ ca¹jmo¹dsa. Di³ tiog¹³ báh³ høa¹² dsǿa¹²dsa he² jǿg³ jøng² hi² hiog¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jøng² ca¹ŋǿh¹ dsa² héi² Jesús. Ca¹juúh²dsa: ―¿He² løa¹ juúh² tøa¹² he¹² lei¹³ quiah¹² Diú¹³ hi² hniuh¹² jiúgh² hlai³ Elías ni³jiá¹ cónh¹ jín³ dsa² lég² jnieh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² jiúgh² báh³ Elías ni³jiá¹. Mi¹rø¹²dsa ca¹lah¹jǿ¹. Jø¹² bíh³ lah¹la² rø²juúh² si² quiah¹² Diú¹³ ja³cog² jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹²: Hi² hniuh¹² can³jni ma¹dsio¹² jmø³uai¹². Di³ tsa¹jei¹³ dsa² jmøi¹guǿi¹ jní², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Di³ lah¹la² juǿi²jni hniah¹²: Ma²ca¹guǿnh¹ báh³ hlai³ Elías. Jøng² ca¹jmógh² dsa² jmøi¹guǿi¹ ca¹lah¹cónh¹ ja³neng¹² dsǿa¹²dsa, ju³lah rø²juúh² si² quiah¹² Diú¹³ ja³cog²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jøng² ca¹jë́²dsa dsa² jue¹² tiogh³ mi³ca¹dsi¹lé²dsa calah ja³tiogh³ dsa² quián¹² Jesús. Ma²dsii¹² tøa¹² he¹² lei¹³ quiah¹² Diú¹³ jǿg³ quianh¹³ dsa² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jøng² ca¹lø¹dsogh¹² dsǿa¹² dsa² jue¹² mi³ca¹jái¹dsa ma²já¹² Jesús. Jøng² ca¹ŋi¹lé² dsa² jue¹². Ca¹haih²dsa Jesús jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quián¹²dsa: ―¿He² jǿg³ dsiih² hniah¹² quianh¹³ dsa² ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jøng² ca¹ŋai¹ jan² dsa² quianh¹³ dsa² jue¹². Ca¹juúh²dsa: ―Jní² ma²na²u¹jian¹ tsih² quian¹jni ja³cogh²hning. Di³ quin¹²tsih jmi²dsí² hlaih¹³ jmo¹² hi² tsa¹lé² hløah¹tsih. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jøng² lǿ² hi² jmo¹² jmi²dsí² hi² dsø²hë¹²tsih. Jøng² hii² jan¹² hag³tsih. Cøgh²tsih jan³. Lø²huah²tsih. Jøng² ma²na²juǿi²jni dsa² quiánh²hning hi² mi³dsi¹dsa jmi²dsí² hlaih¹³. Di³ ha¹chi² ca¹tiúh¹dsa ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jøng² ca¹juúh² Jesús: ―¡He³ lah¹hiug¹²! ¿Ha²cónh¹ jmai³ hniuh¹² hú¹³jni hi² mi³dsian¹³jni dsøa¹ quianh¹³ hniah¹², hniah¹² dsa² tsa¹héh² jǿg³? ¡Ŋi³jian¹²tsih ja³la²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jøng² ca¹ŋi³jian³dsa tsih². Jøng² mi³ca¹jë́² jmi²dsí² hlaih¹³ Jesús, ta³lah¹ca¹ŋi¹hë¹²tsih huø¹. Ca¹bø² ca¹lë́h²tsih. Ca¹hii² jan¹² hag³tsih. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jøng² ca¹ŋǿh¹ Jesús ti³jmi²tsih. Ca¹juúh²dsa: ―¿Ha²cónh¹ jmai³ ma²ni³ŋó¹³ jinh¹²tsih lah¹ná¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² ti³jmi²tsih: ―Cónh¹ jmai³ meh² báh³ tsih². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jøng² hliú² rón² ma²ca¹tiáng² jmi²dsí² hlaih¹³ dsi²si² dsi²jmøi², hi² hniu¹ jmi²dsí² hi² dsø¹hén²tsih. Jøng² ju³dsi³ŋiú³ hoh¹²hning jnieh³ chi²júh² chi² hi² li¹jmóh³hning mih². Mi³hag³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa ti³jmi²tsih: ―¡Chi²júh² chi² hi² li¹jmo³jni liáh³! ¡Ca¹lah¹jǿ¹ báh³ lé² ja³cog² dsa² hé² jǿg³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dsø¹juu¹² jøng² ca¹juúh² ti³jmi²tsih tí² hlaih¹³: ―¡Hé² báh³ jní² jǿg³! ¡Mi³hag³ jní²! Mi³jøng² hé²jni cu²rø² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jøng² mi³ca¹lø¹lih¹³ Jesús hi² ma²hniu¹ togh¹ dsa² jue¹², ca¹jé²dsa jmi²dsí² hlaih¹³. Ca¹juúh²dsa: ―¡Jmi²dsí² cag³, jmi²dsí² guai³, hning² juǿi²jni, jú¹² quiah¹² dsa² ná¹²! ¡Jøng² tsa¹ma¹huh¹³hning quiah¹²dsa! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jøng² ca¹ho¹ tí² jmi²dsí². Ca¹jmo¹ jmi²dsí² hi² ca¹bø² ca¹lë́h²tsih ca¹lah¹ca¹u¹hái¹ jmi²dsí². Jøng² ca¹quieg²tsih tei³ ju³lah ron¹² hlai³. Mi³jøng² jue¹² dsa² ca¹juúh²: ―Ma²jon¹³ báh³ tsih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jøng² ca¹chính² Jesús gug²tsih. Ca¹chiag¹dsa. Jøng² ca¹nung²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jøng² mi³ca¹hí¹ Jesús dsi²néi², ca¹ŋai¹ dsa² quianh³dsa tø¹cøg¹². Ca¹juúh²dsa: ―¿He² løa¹ tsa¹ca¹tiúh¹ jnieh³ dsí³ jnieh³ jmi²dsí² hlaih¹³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jøng² ca¹juúh² Jesús: ―Jmáh¹lah hi² hlanh¹³ jniang³ Diú¹³ báh³ jmo¹ hi² u¹hái¹ jmi²dsí² lah¹jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jøng² ca¹ŋi¹lé²dsa calah. Ca¹tsø³jue¹³dsa ja³tén¹² huø¹ Galilea. Tsa¹hniu¹ Jesús li¹ŋi¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Di³ ma²heh¹²dsa dsa² quián¹²dsa. Ca¹juúh²dsa: ―Jainh¹dsa jní² quiah¹² dsa² jŋaih¹ jní², jní² dsa² ma²lán¹² dsa² jmøi¹guøí¹ jianh¹² hniah¹². Jøng² ma²hnøa¹² jmai³ ca¹jŋaih¹dsa, jøng² hiog¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jøng² tsa¹ca¹lø¹ŋë́h² dsǿa¹² dsa² quián¹²dsa. Cónh¹jøng² ha¹chi² ca¹ŋai¹dsa. Di³ hi² goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jøng² ca¹dsi¹lia¹dsa calah jøa³juøi² Capernaum. Mi³ma²tiogh³dsa dsi²néi² jøng², ca¹ŋai¹ Jesús. Ca¹juúh²dsa: ―¿He² jǿg³ mi³dsiih² hniah¹² dsi²juu¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jøng² tei³ ca¹túgh² dsa² quián¹²dsa. Di³ mi³dsii¹²dsa jǿg³ hein² dsa² quianh¹³dsa lán¹² dsa² juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jøng² ca¹guú² Jesús. Ca¹tǿh¹dsa dsa² guia¹tón². Jøng² ca¹juúh²dsa: ―Ju³ná³ hein² dsa² hniu¹ cán² ni³, jøng² dsio¹ dság¹ dsa² héi² ja³ca¹tóh² jø², dsio¹ mi¹ti¹dsa ni³ ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jøng² ca¹tsenh¹ Jesús jan² guing² jøa³ ja³tiogh³ dsa² quián¹²dsa. Jøng² mi³ca¹chiánh² Jesús guing², ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ju³ná³ hein² dsa² ca¹hie¹ jan² guing² lah¹lang¹² ni³ huu¹³ quieg¹ jní², jøng² ca¹hiei¹dsa jní² calah. Jøng² ju³ná³ hein² dsa² héi² ca¹hiei¹ jní², a¹jáng¹ ju³ jan² jní² ca¹hiei¹dsa, hi² ca¹hie¹dsa calah dsa² ca¹tsei¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jøng² ca¹juúh² Juan, ca¹tsáih¹dsa Jesús: ―Tøa¹², ca¹ne¹³ jnieh³ jan² dsa² huø¹² jmi²dsí² hlaih¹³ quiah¹² dsa² dsoh³, hi² chi³hia¹²dsa hning². Jøng² ca¹tséih³ jnieh³ dsa² hi² tsa¹ma¹jmo¹dsa lah¹jøng². Di³ tsa¹ŋøa¹²dsa quianh¹³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jøng² ca¹juúh² Jesús: ―Tsa¹jmóh³ hniah¹² tsa¹cuúh³ hniah¹² jǿg³ hi² jmo¹dsa lah¹jøng². Di³ ha¹chian² dsa² ma¹lé² juúh² jǿg³ hlaih¹³ quieg¹ jní², ju³ná³ ma²ca¹jmo¹dsa juu¹² juøh¹² quianh¹³ jmai¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Di³ dsa² quianh¹³ báh³ jniang³ ju³ná³ hein² dsa² tsa¹hiag¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹cuúh¹ hniah¹² ca¹lah¹cónh¹ cøng² cuøh³ jmøi² guúh² ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quián¹² Cristo, lah¹dsóh² mi¹hmah¹³ báh³ dsa² héi² ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ué² lé² quiah¹² lǿa¹² ju³ hein² dsa² ca¹jmo¹ ca¹tánh² jan² guing² lah¹lang¹² dsag³, ju³lah guing² hé² jǿg³ quieg¹ jní². Dsio¹ hi³méh¹ mi³lé² quiah¹² dsa² ca¹jmo¹ lah¹jøng² ju³ jøng² ca¹tiág²dsa jmø³ŋih¹³ hi² rø²quiein¹² cøng² to² juøh¹² lag³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jøng² ju³ná³ ca¹jmo¹ gug²hning hi² ca¹tánh²hning dsag³, dsio¹ quiúh³hning. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Di³ hiug¹² jín³ hi² dsio¹ dsianh¹³hning ŋi¹juǿi¹ hi² bong¹³ gugh²hning, cónh¹ jín³ hi² dsianh¹³hning guio¹juǿi¹ dsi²si² tsa¹øg² hi² ti³dsøa¹³ ta³ton¹ gugh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jøng² ju³ná³ ca¹jmo¹ taih³hning hi² ca¹tánh²hning dsag³, dsio¹ quiúh³hning. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Di³ hiug¹² jín³ hi² dsio¹ dsianh¹³hning ŋi¹juǿi¹ hi² lanh¹²hning dsa² guinh³, cónh¹ jín³ hi² dsianh¹³hning guio¹juǿi¹ hi² ti³dsøa¹³ ta³ton¹ taih³hning. ");
INSERT INTO cpaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jøng² ju³ná³ ca¹jmo¹ mø³neih³hning ca¹tánh²hning dsag³, dsio¹ dsíh³hning. Di³ hiug¹² jín³ hi² dsio¹ dsianh¹³hning ja³jmo¹² Diú¹³ héh¹ quianh¹³ cøng² mǿi² mø³neih³hning, cónh¹ jín³ hi² dsianh¹³hning guio¹juǿi¹ hi² tioh¹³ ta³ton¹ mø³neih³hning, ");
INSERT INTO cpaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ja³tsa¹dsan² jah³ quiah¹²dsa, ja³tsa¹øg² si² dsíg². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Di³ dsi²si² báh³ quíg¹dsa dsǿg³, ju³lah hein² dsa² ca¹tánh² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Dsio¹ báh³ ŋi³. Di³ ha¹chi² ma¹lé² li¹ŋih³ ŋi³, ju³ná³ ca¹løa¹ tsa¹ŋih³. Hi² jøng² huø³ jmóh³ hniah¹² hoh¹². Mi³jøng² túgh² hniah¹² tei³ quianh¹³ dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jøng² ca¹u¹hái¹ Jesús ja³jøng². Ca¹tsø³jue¹³dsa juu¹² ja³tén¹² Judea. Ca¹dsiég¹dsa hŋoh¹³ jmøi² Jordán. Quianh¹³dsa calah dsa² jue¹². Jøng² ca¹he¹dsa calah jǿg³, ju³lah ma²lǿa¹² mai³¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jøng² ca¹dsi¹lé² dsa² fariseo. Ca¹ŋǿh¹dsa Jesús chi²júh² lé² tióg² dsa² ŋioh¹² hio¹³ quián¹²dsa. Ta³dsǿa¹² juúh²dsa. Di³ hniu¹dsa tø¹canh¹³ Jesús dsag³ quianh¹³ jǿg³ dsii¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿Ha²lah lǿa¹² jǿg³ ca¹quieg² hlai³ Moisés? ");
INSERT INTO cpaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jøng² ca¹juúh² dsa² héi²: ―Ca¹cuø¹ báh³ hlai³ Moisés jǿg³ jmo¹²dsa si² hi² tsog¹dsa. Jøng² tióg²dsa hio¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Hi² jøng² báh³ ca¹quieg² hlai³ Moisés jǿg³ jøng². Di³ huh² hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Di³ jøng² cónh¹ jmai³ lah¹ni³ ja³ca¹niu¹ jmøi¹guǿi¹, ca¹jmo¹ Diú¹³ dsa² ŋioh¹² quianh¹³ dsa² mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mi³jøng² tiúg²dsa chiég³ jmi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jøng² og¹ dsa² lé² cøng² jmø²ŋǿa¹². Tsa¹ma¹lán¹²dsa og¹ dsa². Cøng² jmø²ŋǿa¹² báh³ ma²lǿa¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hi² jøng² tsa¹lé² tsog¹dsa. Di³ Diú¹³ ca¹jmo¹ ma²lán¹²dsa ju³lah lán¹² jan² dsa² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jǿg³ jøng² ca¹ŋai¹ dsa² quianh³dsa mi³ma²tiogh³dsa dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jøng² ca¹juúh² Jesús: ―Ju³ná³ hein² dsa² ca¹jian¹ hio¹³ siáh² na³ma²ca¹tióg²dsa ji²gug²dsa, dsa² héi² tø¹canh¹³ dsag³ ja³cog² ji²gug²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jø¹² bíh³ tø¹canh¹³ hio¹³ dsag³ ju³ná³ ca¹jian¹dsa dsa² siáh² na³ma²ca¹tióg²dsa ji²gug²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jøng² ca¹jian¹ dsa² jue¹² hi²meh² quián¹²dsa. Hniu¹dsa quiég¹ Jesús gug² ni³ quiah¹² hi²meh². Jøng² ca¹jí² dsa² quianh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ca¹lø¹hné¹ Jesús mi³ca¹lø¹lih¹³dsa. Ca¹tsáih¹dsa dsa² quianh³dsa: ―¡Ju³ ji¹lé² hi²meh² ja³la²! ¡Tsa¹jnë¹³ juu¹²! Di³ dsa² héi² báh³ li¹chian² ja³jmo¹² Diú¹³ héh¹, dsa² lán¹² ju³lah lán¹² hi²meh². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² tsa¹hniu¹ héh¹ ca¹jmo¹ Diú¹³ ju³lah hniu¹ hi²meh², tsa¹dsianh¹³ dsa² héi² ja³jmo¹² Diú¹³ héh¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jøng² ca¹chiánh² Jesús hi²meh². Ca¹quieg²dsa gug²dsa ni³ quiah¹² tsih², hi² ca¹mi¹jŋió¹dsa tsih². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jøng² mi³ca¹ŋó¹ Jesús calah, ca¹dsiég¹ jan² dsa² ŋøa¹² gu¹hei¹². Ca¹chi¹jné¹dsa. Jøng² ca¹juúh²dsa: ―Tøa¹² dsiog¹, ¿he² hi² hniuh¹² jmo³jni, mi³jøng² dsa¹ŋë́²jni hi² li¹chian²jni tiá²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ tøah¹²hning jní² dsa² dsiog¹? Ha¹chian² dsa² dsiog¹ chian². Jan² Diú¹³ báh³ dsa² dsiog¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ma²cueh¹² báh³ hning² lei¹³: ¡Tsa¹jŋë́h²hning dsa²! ¡Tsa¹hlanh¹³hning hio¹³ siáh²! ¡Tsa¹høinh¹³hning! ¡Tsa¹cuøh¹³hning dsa² dsag³ tsa¹re²dsa! ¡Tsa¹mi³ganh¹³hning dsa²! ¡Mi³juanh¹³hning chiegh² ŋieih¹²hning! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jøng² ca¹juúh² dsa² héi²: ―Ca¹lah¹jǿ¹ lah¹jøng² ma²ca¹can¹jni hí³ ca¹lah¹cónh¹ jmai³ meh²jni, Tøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jøng² ca¹jǿi² Jesús. Ca¹tǿ² dsǿa¹²dsa quianh¹³ dsa² héi². Jøng² ca¹juúh²dsa: ―Chi² báh³ jín³ cǿng¹ hi² hei¹². ¡Gu²hnai³ ca¹lah¹jǿ¹ hi² chi² quiánh²hning! ¡Jøng² cuøh¹³hning dsa² ti²ŋié² cog³! Mi³jøng² li¹chi² ma¹dsio¹² quiánh²hning ŋi¹juǿi¹. Di³ jøng² ŋǿh³hning quianh¹³ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jøng² hlaih¹³ ca¹hǿi² dsǿa¹² dsa² héi² mi³ca¹nǿng²dsa jǿg³ jøng². Ca¹ŋó¹dsa huø³ hei¹² dsǿa¹²dsa. Di³ mi³chi² ma¹dsio¹² cog³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jøng² ca¹jái¹ Jesús lah¹jin² lah¹lǿih¹. Ca¹tsáih¹dsa dsa² quianh³dsa: ―¡He³ báh³ ué² dsianh¹³ dsa² chi² cog³ ja³jmo¹² Diú¹³ héh¹! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jøng² dsogh¹² dsǿa¹² dsa² quianh³dsa jǿg³ jøng². Jøng² ca¹juúh² Jesús calah: ―¡He³ báh³ ué² li¹hiug² dsǿa¹²dsa héh¹ ca¹jmo¹ Diú¹³, jon¹²! ");
INSERT INTO cpaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hiug¹² jín³ tsa¹ué² ŋë́¹ jan² camello juu¹² gǿh³ hma²cog³ cónh¹ jín³ hi² ŋë́¹ dsa² chi² cog³ juu¹² ja³jmo¹² Diú¹³ héh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jøng² dsogh¹² hlaih¹³ dsǿa¹²dsa mi³ca¹nǿng²dsa lah¹jøng². Jøng² ca¹juúh²dsa: ―¿Hein² dsa² liúg² jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jøng² ca¹jǿi² Jesús. Ca¹juúh²dsa: ―Ha¹chi² tiúh¹ dsa² jmøi¹guǿi¹. Tiúh¹ báh³ Diú¹³. Ha¹chi² hi² chi² hi² tsa¹tiúh¹ Diú¹³ jmo¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Jai³lah, ma²ca¹tiú¹³ jnieh³ ca¹lah¹jǿ¹. Ma²ca¹ja¹neng¹³ jnieh³ quianh¹³ hnéng¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹tiú²dsa hniu³dsa, ho¹ ju³ ca¹tiúg²dsa roh¹³dsa, ho¹ ju³ chiég³ jmi²dsa, ho¹ ju³ tsih² guing², ho¹ ju³ ca¹tiú²dsa huø¹ quiah¹²dsa huu¹³ quieg¹ jní², huu¹³ quiah¹² jǿg³ dsio¹, ");
INSERT INTO cpaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tsug¹² jín³ ma¹dsio¹² tan¹ dsa² héi² ni³ jmøi¹guǿi¹ la², ju³lah hniú¹², ju³lah roh¹³dsa, chiég³dsa, tsih² guing², huø¹. Di³ cán² báh³ dsa² jmø³uai¹² huu¹³ quieg¹ jní². Jøng² tan¹dsa li¹chian²dsa tiá² jmøi¹guǿi¹ na¹ bíh³ já¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jøng² dsa¹lé² jue¹² dsa² ja³ca¹tóh² jø² jmai³ jøng², ju³lah dsa² mi³quin¹² ni³ ni³ jmøi¹guǿi¹ la². Jøng² dsa² mi³chi³quë́¹, jue¹² dsa² héi² cán² ni³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jøng² tiogh³dsa juu¹², dsa²lé²dsa juu¹² Jerusalén. Quin¹² Jesús ni³. Jøng² dsogh¹² dsǿa¹² dsa² quianh³dsa hi² dsø²lé²dsa ja³jøng². Goh¹² dsa² dsø²lé² quianh¹³dsa. Jøng² ca¹tǿh¹ Jesús dsa² guia¹tón². Ca¹tsáih¹dsa dsa² héi² he² hi² na¹ bíh³ dsa¹ŋë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ca¹juúh²dsa: ―Jai³lah, ma²dsǿg² jniang³ juu¹² Jerusalén. Jøng² jë́h²dsa jní² ni³ juu¹³ jmi²dsa², quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jian¹²dsa. Jøng² cuúh¹dsa jní² dsag³ juøh¹². Di³ hi² hniu¹dsa hi² jón²jni. Jøng² jáinh¹dsa jní² ja³cog² dsa² tsa¹lán¹² dsa² go² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dsa² héi² cu¹jmágh² jní². Ti¹hŋiéng²dsa jní². Bú²dsa jní². Jŋøih¹dsa jní². Jøng² hiog¹jni jmai³ hnøa¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jøng² Jacobo quianh¹³ Juan, ja³ŋiúh³ Zebedeo, ca¹ŋi¹lé²dsa cøg¹² ja³tsenh¹³ Jesús. Ca¹juúh²dsa: ―Tøa¹², mi³hneng² jnieh³ hi² jmóh³hning cøng² hi² dsio¹ hoh¹² quián² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² hi² hnøngh² hniah¹² jmo³jni quiánh² hniah¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jøng² ca¹juúh² dsa² héi²: ―Mi³cuúh³hning cogh²hning dsa³tiágh³ jnieh³ quianh¹³ hnéng¹ na³ma²tǿ² ja³ca¹hian¹² bí² quiánh²hning, jan² jnieh³ tø¹guia¹jo¹³, jan² jnieh³ tø¹guia¹jón¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jøng² ca¹juúh² Jesús: ―Tsa¹ŋih³ hniah¹² he² møh² hniah¹². ¿Tiah³¹ hniah¹² cánh³ jmø³uai¹² cán³ jní²? ¿Tiah³¹ hniah¹² ŋëh³ jmø³uai¹² dsa¹ŋë́² jní²? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jøng² ca¹juúh² dsa² héi²: ―Tiúh¹ báh³ jnieh³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² cánh³ báh³ hniah¹² jmø³uai¹² cán³ jní². Ŋieh¹ báh³ hniah¹² jmø³uai¹² dsa¹ŋë́² jní². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Di³ a¹jáng¹ jní² lé² cuø¹³ hein² togh¹ quianh¹³jni cog²jni tø¹guia¹jo¹³ tø¹guia¹jón¹. Dsa² héi² togh¹ cog²jni, dsa² ma²lǿa¹² jǿg³ togh¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jøng² mi³ca¹nǿng² dsa² guian¹, ca¹lø¹hian³dsa Jacobo quianh¹³ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jøng² ca¹tǿh¹ Jesús dsa² guia¹tón². Ca¹juúh²dsa: ―Ma²ŋih³ báh³ hniah¹² ha²lah jmo¹² dsa² lán¹² ta³ quián¹² dsa² tsa¹lán¹² judio. Jmo¹²dsa lán¹²dsa juu³ dsa² juøi². Jøng² jmo¹² dsa² canh¹³ dsen¹³dsa ni³ dsa² juøi² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tsa¹lé² lah¹ná¹² quiánh² hniah¹². Ju³ná³ hein² hniah¹² hnøngh² lénh² juanh¹² ja³cog² dsa² jianh¹² hniah¹², jøng² hniuh¹² mi³tih³ hniah¹² ni³ dsa² jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ju³ná³ hein² hniah¹² dsa² hnøngh² cánh³ ni³, jøng² hniuh¹² mi³hogh³ hniah¹² dsa² jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Di³ jní² calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ca¹guio¹jni mi³jøng³ mi³ti³jni ni³ dsa², a¹jáng¹ ju³ hi² mi¹ti¹dsa ne¹ jní². Ca¹guio¹jni hi² cuø³jni jmi²dsí² quieg¹jni. Mi³jøng² log³jni dsa² jue¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jøng² ca¹dsi¹lé²dsa juøi² Jericó. Jøng² ja³ca¹tsø³jue¹³ Jesús juøi² quianh¹³ dsa² quianh³dsa, quianh¹³ dsa² jue¹² hlaih¹³ calah. Ja³jøng² guǿ¹² jan² dsa² teg³ cøg¹² juu¹², dsa² tsen² Bartimeo, ja³ŋiúh³ Timeo. Møa¹²dsa ŋi³néng². ");
INSERT INTO cpaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jøng² mi³ca¹lø¹lih¹³ dsa² teg³ héi² já¹² Jesús, dsa² chian² Nazaret, jøng² ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Jesús! ¡Tsø³jon² quiah¹² hlai³ David! ¡Jmo³ huø³ hoh¹² quianh¹³ jní²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jøng² ca¹jí² dsa² jue¹² quiah¹²dsa hi² hniu¹dsa tsa¹tógh¹dsa møah¹³. Ta³lah¹tí² hi³méh¹ ca¹hløah¹dsa. Ca¹juúh²dsa: ―¡Tsø³jon² quiah¹² hlai³ David! ¡Jmo³ huø³ hoh¹² quianh¹³ jní²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jøng² ca¹jŋi¹ Jesús. Ca¹juúh²dsa: ―¡Gu²teh¹²dsa! ―ca¹juúh²dsa. Jøng² ca¹ŋi³téh³dsa dsa² teg³. Ca¹juúh²dsa: ―¡Tsa¹jmo² ju²hí³ dsøa¹²! ¡Nung²! Hning² tǿh²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jøng² ca¹dsi¹ dsa² héi² hmøah¹² mi³dsǿ² coh¹³ tsǿnh³dsa. Cu¹dsie¹² ca¹chiog¹dsa. Ca¹dsiég¹dsa gu¹hei¹² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² mi³hnøngh²hning jmo³jni quiánh²hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² teg³: ―Ju³ li¹jniáng¹²jni calah, Tøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jøng² ca¹juúh² Jesús: ―Ma²lé² guǿnh³hning. Ma²hlúh² báh³ hning². Di³ héh²hning jǿg³ ―ca¹juúh²dsa. Ta³lah¹ca¹jniáng¹ mø³ni³dsa. Jøng² ca¹ŋó¹ dsa² héi² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jøng² mi³ca¹dsi¹lé²dsa huu¹³ máh² Olivo, cøg¹² juøi² Betfagé quianh¹³ juøi² Betania, ja³ma²quien¹² Jerusalén, ca¹tse¹ Jesús og¹ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ca¹juúh²dsa: ―¡Gu²noh¹² juøi² mih² neng¹² cøg¹² ná¹²! cónh¹ ca¹dsi¹noh¹² hniah¹², dsianh¹² hniah¹² jan² búh³ meh², chi³hŋioh¹ jáh², jáh² ha¹chian² dsa² ma²gú² cah³. Jøng² tseh³ jáh². Taih³ jáh² ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jøng² ju³ná³ chian² dsa² ca¹juúh² he² løa¹ lah¹ná¹² jmoh² hniah¹², jøng² juaih¹³dsa: “Chi³quian¹³ Juu¹³ jniang³ jmai³ jáh². Na¹ cónh¹ ŋi¹júg²dsa jáh²,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jøng² ca¹ŋi¹lé²dsa. Ca¹dsanh¹²dsa búh³ meh², chi³hŋioh¹ jáh² hag³hniú¹³ cøg¹² jøa³cai³¹. Jøng² ca¹tséh²dsa jáh². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jøng² ca¹juúh² jan² og¹ dsa² tiogh³ ja³jøng²: ―¿He² løa¹ tsëh³ hniah¹² jáh²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jøng² ca¹tsáih¹dsa dsa² héi² ju³lah ca¹juúh² Jesús. Jøng² ca¹cuø¹dsa jǿg³ ŋi¹lia¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jøng² ca¹tái¹dsa jáh² ja³tsenh¹³ Jesús. Ca¹jiúh²dsa hmøah¹² quiah¹²dsa cah³ jáh². Jøng² ca¹gú² Jesús cah³ jáh². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jøng² jue¹² dsa² ca¹jág¹ hmøah¹² quiah¹² dsi²juu¹². Jøng² dsa² siáh² calah ca¹ŋi³quiuh² nih¹³ høg² jøa³nung², ca¹jág¹dsa dsi²juu¹², hi² hniu¹dsa lé² jláh³ juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jøng² hløah¹² dsa² ma²jiá¹² tí² lah¹quianh¹³ dsa² chi³quë́¹. Ca¹juúh²dsa: ―Dsa² dsiog¹ báh³ dsa² ma²já¹², ca¹tsei¹ Diú¹³ juanh¹². Hiug¹² juanh¹² dsa² lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hiug¹² juanh¹² Diú¹³ guǿ¹² guiuh¹³. Dsio¹ báh³ lé² ja³jmo¹ dsa² lang¹² héh¹ ju³lah héh¹ mi³jmo¹² hlai³ Davíd, dsa² juanh¹² quián² jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jøng² ca¹dsiég¹ Jesús jøa³juøi² Jerusalén. Ca¹dsiég¹dsa ja³tsih¹³ guøh¹². Jøng² mi³ca¹jái¹dsa ca¹lah¹jǿ¹, jøng² ca¹jógh¹dsa juu¹² Betania quianh¹³ dsa² guia¹tón². Di³ ca¹neng². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mi³ca¹jni¹ jøng², ca¹huah¹²dsa juøi² Betania. Lǿ² lø¹i³cónh¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jøng² ca¹jái¹dsa cøng² hma² higo tsih¹² ja³uǿin³. Ti³dsǿa¹³ moh¹³. Jøng² ca¹ŋi¹jái²dsa chi²júh² dsiagh¹ mǿi². Mi³ca¹dsiég¹dsa ja³tsih¹² hma², ha¹chi² mǿi² ca¹dságh¹. Jmáh¹lah moh¹³ báh³. Di³ tsa¹ma¹tǿ² ja³hai¹ mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hma²: ―¡Ju³lé³ tsa¹ma¹gǿh¹ jin³ hein² dsa² mǿi² quiánh²hning, jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹! ―ca¹juúh²dsa. Jøng² ca¹nǿng² dsa² quianh³dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jøng² ca¹dsi¹lé²dsa jøa³juøi² Jerusalén. Jøng² mi²ca¹hí¹ Jesús ja³tsih¹² guøh¹², ca¹huan¹dsa dsa² hnai¹² lio¹³ quianh¹³ dsa² lá¹², dsa² mi³tiogh³ niúh¹ jnǿ³. Jøng² ca¹jéinh¹dsa mesa quiah¹² dsa² mi²tsë́¹ cog³. Ca¹jéinh¹dsa hma²sai³¹ quiah¹² dsa² hnë¹² jug². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jøng² tsa¹ma¹ca¹cuø¹ Jesús jǿg³ tsa¹jue¹³dsa niúh¹ jnǿ³ quiah¹² guøh¹² hi² quin¹²dsa lio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jøng² ca¹he¹dsa jǿg³. Ca¹juúh²dsa: ―Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Li¹tsen² hniú¹² quieg¹ jní² hniú¹² ja³hlanh¹²dsa Diú¹³, dsa² chian² ca¹lah¹jǿ¹ juøi²,” rø²juúh² si². Di³ hniah¹² ma²ca¹jmoh³ hi² ma²lǿa¹² hniú¹² ju³lah lǿa¹² cøng² ja³tiogh³ dsa² høin² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jøng² mi³ca¹nǿng² juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³ jǿg³ jøng², ca¹hnangh²dsa mai³¹ ha²lah mi³jŋøih¹dsa. Di³ gan¹dsa Jesús. Di³ jue¹² dsa² dsogh¹² dsǿa¹² jǿg³ hi² he¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jøng² ca¹u¹hái¹ Jesús jøa³juøi² quianh¹³ dsa² quianh³dsa mi³ca¹neng². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jøng² mi³ca¹jni¹, ca¹tsø³jue¹³dsa ja³tsih¹² hma² higo. Ca¹jái¹dsa ma²quing² ca¹tǿ² jmó³. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jøng² dsagh² báh³ dsǿa¹² Pedro. Jøng² ca¹juúh² Pedro: ―Jai³lah Juu¹³ jniang³, ma²quing² hma² ca¹tseih³hning jǿg³ hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jøng² ca¹juúh² Jesús: ―¡Ju³héh³ hniah¹² quiah¹² Diú¹³! ");
INSERT INTO cpaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lah¹dsóh² juǿi²jni hniah¹², ju³ná³ hein² dsa² ca¹tsáih¹ máh² ná¹²: “¡Jŋiah¹! ¡Gu²ho¹² jmø³ŋih¹³!” Hi² tsa¹lë́²dsa tsa¹lé² mi³né³. Cøng² hi² hé² báh³ dsa² hi² lé² cónh¹ lǿa¹² jǿg³ juúh²dsa. Jøng² lǿ² báh³ lah¹jøng² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hi² jøng² juǿi²jni hniah¹² hi² ŋieh¹ báh³ hniah¹² ca¹lah¹jǿ¹ hi² møh² hniah¹² ja³cog² Diú¹³ ju³ná³ héh² hniah¹² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jøng² henh¹³ hniah¹² dsag³ na³ma²tǿ² ja³hlanh¹³ hniah¹² Diú¹³ chi²júh² hein² dsa² re² dsag³ ja³cogh² hniah¹². Mi³jøng² hén² calah ti³ŋieih¹² hniah¹², dsa² guǿ¹² ŋi¹juǿi¹, dsag³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Di³ ha¹chi² hén² ti³ŋieih¹², dsa² guǿ¹² ŋi¹juǿi¹, dsag³ quiánh² hniah¹² ju³ná³ tsa¹henh¹³ hniah¹² dsag³ ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jøng² ca¹dsi¹lé²dsa calah Jerusalén. Jøng² ja³ŋøa¹² Jesús ja³dsi¹² guøh¹², ca¹dsi¹lé² juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³ quianh¹³ dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa Jesús: ―¿He² jǿg³ ca¹të́h²hning hi² jmoh²hning lah¹ná¹²? ¿Hein² ca¹cuø¹ jǿg³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jní² báh³ juǿi³ hniah¹² cøng² jǿg³. Jøng² na³ma²na²ŋaih³ hniah¹² jǿg³ juǿi³jni hniah¹², ni³ jøng² juøh¹³jni he² jǿg³ ca¹të́²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ha² juu¹² ca¹já¹ jǿg³ hi² ca¹chiog¹ Juan dsa² jmøi², juu¹² ŋi¹juǿi¹, ho¹ ju³ hi² ca¹jmo¹ dsa² jmøi¹guǿi¹? ¡Ŋai³ hniah¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jøng² ca¹dsii¹ dsa² héi² jǿg³ cu³guiog³dsa, ca¹juúh²dsa: ―Ju³ná³ ca¹tséih³ jniang³ dsa² juu¹² ŋi¹juǿi¹, jøng² tsáih¹dsa jniang³ he² løa¹ tsa¹ca¹héh³ jniang³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ho¹ ju³ juúh³ jniang³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹ liáh³? ―ca¹juúh²dsa. Tsa¹lé² juúh²dsa lah¹jøng². Di³ gan¹dsa dsa² jue¹². Di³ lah¹jøng² lë́² ca¹lah¹já¹ dsa², hi² lah¹dsóh² mi³lán¹² Juan dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Tsa¹ne³ jnieh³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jøng² tsa¹ŋi³juøh¹³ jní² calah he² jǿg³ ca¹të́²jni hi² jmo¹²jni lah¹ná¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jøng² ca¹dsii¹ Jesús jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Jan² dsa², ca¹jné²dsa chiúh³ gu²jøah¹³. Jøng² ca¹jmo¹dsa jnǿ³ cang³ lah¹jin² lah¹lǿih¹. Ca¹jmo¹dsa cøng² ja³sianh¹dsa gu²jøah¹³. Jøng² ca¹tsih¹dsa cøng² hniú¹² jøa³, hniú¹² ja³túgh¹ dsa² jmo¹ hí³. ’Jøng² mi³ca¹jmo¹dsa jǿg³ hi² jmo¹ dsa² siáh² hí³, jøng² ca¹ŋó¹dsa huø¹ siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jøng² mi³ca¹tǿ² jmai³, ca¹tse¹dsa jan² dsa² quián¹²dsa juu¹² ja³quiah¹³ dsa² jmo¹² hí³ héi², mi³ŋi¹quieng²dsa cónh¹ hi² ta¹dsa quiah¹² huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jøng² ca¹chiángh² dsa² héi². Ca¹bú²dsa. Jøng² ca¹dsiánh²dsa dsa² la¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jøng² ca¹tse¹dsa calah dsa² quián¹²dsa, dsa² siáh². Jøng² dsa² héi² calah ca¹quiúh¹dsa dsi³dsa. Ca¹cu² ca¹jmógh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jøng² ca¹tse¹dsa dsa² siáh² calah. Jøng² dsa² héi² calah, ca¹jŋøih¹dsa. Jøng² jue¹²dsa ca¹tse¹dsa. Ca¹ŋi¹ba¹³ ca²dsiog²dsa. Ca¹jŋëh¹dsa ca²dsiog³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ja³ca¹tóh² jø² jøng² mi³chian² jan² ja³ŋiúh³dsa, dsa² hnio¹ ti³jmi²dsa. Jøng² ca¹tsei¹ ti³jmi²dsa, hi² lë́²dsa: “Mi¹juanh¹² báh³ dsa² guing² quian¹jni,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Di³ jøng² ca¹juúh² dsa² jmo¹² hí³ huø¹ héi², ca¹dsii¹dsa jǿg³ guiog³dsa: “Dsa² ná¹² báh³ dsa² ta¹ hi² chi² quiah¹² ti³jmi²dsa. Ju³jŋëh¹³ jniang³ dsa². Mi³jøng² ta¹ jniang³.” ");
INSERT INTO cpaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jøng² ca¹chiángh²dsa. Ca¹jnøih¹dsa. Jøng² ca¹ŋi³tiang²dsa coh¹³ jnǿ³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿He² jmo¹ dsa² quiah¹² jøa³ gu²jøah¹³? Dsánh¹ báh³ dsa². Dsa¹dsianh¹³dsa dsa² mi³jmo¹² hí³ huø¹. Jøng² jmo¹dsa héh¹ hi² jmo¹ dsa² siáh² hí³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Tsa³ma²ca¹híh² hniah¹² jǿg³ la² lǿa¹² ni³ si² quiah¹² Diú¹³?: Cang³ tsa¹jih² dsa² jmo¹² hniú¹², Cang³ jøng² báh³ ma²jmo¹² hi² tsih¹² hniú¹² tí². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Juu¹³ jniang³ báh³ ca¹jmo¹ lah¹jøng². Dsio¹ hlaih¹³ cu¹té¹², lë́² jniang³, rø²juúh² si² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jøng² mi³chiángh² dsa² canh¹³ ju³ jmai³ tsa¹ga¹dsa dsa² jue¹². Di³ lø²lih¹³dsa ca¹dsii¹ Jesús jǿg³ jøng² ni³ huu¹³ quiah¹²dsa. Jøng² ca¹tég²dsa. Ca¹ŋi¹lia¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jøng² ca¹tse¹dsa ca²dsiog³ dsa² fariseo quianh¹³ dsa² quianh³ Herodes, dsa² mi³jmo¹ láh² ju³juúh² Jesús jǿg³ hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jøng² mi³ca¹dsi¹lé²dsa, ca¹juúh² dsa² héi²: ―Tøa¹², ne³ jnieh³ lanh¹²hning dsa² té¹² jagh³. Cøng² ni³ mi²juanh¹²hning ca¹lah¹já¹ dsa². Di³ lah¹jøng² báh³ lah¹dsóh² heh²hning, ju³lah lǿa¹² juu¹² ca¹quieg² Diú¹³. ¿Dsio³¹ cuú³ jniang³ cog³ cagh¹² rai¹³ romano? ¿Cuú³ jniang³, ho¹ ju³ tsa¹cuú³ jniang³? ");
INSERT INTO cpaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jøng² ma²ŋi¹² Jesús hi² ta³dsǿa¹² juúh² dsa² héi². Jøng² ca¹juúh² Jesús: ―¿He² løa¹ mi³gagh¹³ jní²? ¡Gu²quin³ cøng² ŋi³néng² ju³lah ŋi³néng² cagh¹² rai¹³, hi² mi³jái¹³jni! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jøng² ca¹ŋi³quín³dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿Hein² nióh³ quiah¹² rø²ton¹² ŋi³néng²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Nióh³ quiah¹² rai¹³ báh³ ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jøng² ca¹juúh² Jesús: ―Dsio¹ mi³tih³ hniah¹² ja³cog² rai¹³, ju³lah lǿa¹² jǿg³ quiah¹² rai¹³. Jøng² dsio¹ mi³tih³ hniah¹² ja³cog² Diú¹³ calah, ju³lah lǿa¹² jǿg³ quiah¹² Diú¹³ ―ca¹juúh² Jesús. Jøng² dsogh¹² dsǿa¹² dsa² héi² jǿg³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jøng² ca¹dsi¹lé² dsa² saduceo ja³tsenh¹³ Jesús, dsa² juúh² tsa¹hiog¹ jmi²dsí². Ca¹ŋǿh¹ dsa² Jesús. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tøa¹², lah¹la² lǿa¹² si² ca¹jmo¹ hlai³ Moisés: Ju³ná³ jan² dsa² ca¹jon¹, chian² báh³ hio¹³ quián¹²dsa, ha¹chian² guing² ma²chian² quián¹²dsa, jøng² hniuh¹² báh³ hi² jian¹ roh¹³ hlai³, dsa² ma²jon¹², hio¹³ héi². Mi³jøng² li¹chian² guing² quián¹² hlai³, hi² lǿa¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jøng² mi³chian² guiog¹ roh¹³dsa dsa² ŋioh¹². Jøng² dsa² ne¹³ ca¹jian¹ hio¹³. Jøng² ca¹jon¹dsa ha¹chian² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ni³ jøng² ca¹jiag¹ dsa² ja³ma²og¹. Jø¹² bíh³ ca¹jon¹ dsa² héi² ha¹chian² jong¹²dsa ca¹lø¹chián¹. Jø¹² bíh³ lah¹jøng² quiah¹² dsa² ja³ma²úg² calah siíh². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ca¹tǿ² guiog¹dsa cu¹dsie¹²dsa ca¹dsan¹dsa. Ha¹chian² jong¹²dsa ca¹lø¹chián¹. Ja³ca¹tóh² jø² jøng² ca¹jon¹ hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Jøng² hein² dsa² ŋioh¹² quián¹² hio¹³ na³ma²tǿ² ja³ca¹hiog²dsa? ¿Di³ ca¹lah¹jǿ¹ guiog¹ dsa² ca¹jiag¹dsa? ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Lah¹jøng² báh³ dsa²gán² hoh¹² hniah¹². Di³ tsa¹cuéh² hniah¹² jǿg³ quiah¹² Diú¹³. Tsa¹lë́h² hniah¹² chi² bí² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ha¹chian² hio¹³ jian¹ dsa² ŋioh¹² na³ma²tǿ² ja³ca¹hiog²dsa. Ha¹chian² dsa² ŋioh¹² jian¹ hio¹³. Di³ ma²lán¹²dsa ju³lah lán¹² ángel tiogh³ ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jøng² jǿg³ jøng² hi² hiog²dsa, ha¹chi² ma²ca¹híh² hniah¹² cu²rø² si² quiah¹² hlai³ Moisés. Di³ ja³mi³hiúg³ Diú¹³ chiúh³ tang¹² mi³chi³hiúh² si², ca¹tsáih¹dsa hlai³ Moisés: “Jní² báh³ Diú¹³ quián¹² hlai³ Abraham, Diú¹³ quián¹² hlai³ Isaac, Diú¹³ quián¹² hlai³ Jacob,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jøng² ma²ŋih³ hniah¹² hiog¹ dsa² jmøi¹guǿi¹. Di³ ha¹chi² quián¹² Diú¹³ dsa² tsa¹ma¹chian². Dsa² chian² báh³ quián¹² Diú¹³. Hiug¹² báh³ dsa²gán² hoh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jøng² ca¹dsiég¹ jan² tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Nang¹²dsa dsii¹²dsa jǿg³. Jøng² mi³ca¹lø¹lih¹³dsa rø² báh³ ca¹dsiég¹ jǿg ca¹ŋai¹ Jesús, jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―¿Nai¹² lei¹³ quin¹² ni³ ja³ca¹lah¹jǿ¹? ");
INSERT INTO cpaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jøng² ca¹juúh² Jesús: ―Hi² la² báh³ lei¹³ quin¹² ni³: “¡Neng² hniah¹², dsa² israel! Juu¹³ jniang³, Diú¹³ quián² jniang³, jan² héi² báh³ Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jøng² mi³hnoh¹³hning Juuh²hning, Diú¹³ quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ hoh¹²hning, quianh¹³ ca¹lah¹jǿ¹ jmi²dsí² quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ hi² dsa²jiag¹² hoh¹²hning, quianh¹³ ca¹lah¹jǿ¹ ju²bí² quiánh²hning.” ");
INSERT INTO cpaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hi² la² báh³ lei¹³ ja³ma²ton¹: “Mi³hnoh¹³hning dsa² jmøi¹guǿi¹ jianh¹²hning ju³lah hnóh¹hning hŋiah¹hning.” Ha¹chi² lei¹³ siíh² chi², lei¹³ quin¹² cónh¹ jín³ hi² ná¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jøng² ca¹juúh² tøa¹² héi², ca¹tsáih¹dsa Jesús: ―Dsio¹ báh³ jǿg³ ma²na²juøh¹³hning, Tøa¹². Jǿg³ té¹² báh³ hi² chian² jan² Diú¹³, hi² ha¹chian² dsa² siáh² chian². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jøng² mi³hnio¹³ jniang³ Diú¹³ quianh¹³ ca¹lah¹jǿ¹ dsǿa¹² jniang³, quianh¹³ ca¹lah¹jǿ¹ hi² ma²ne³ jniang³, quianh¹³ ca¹lah¹jǿ¹ ju²bí² quián² jniang³. Jøng² mi³hnio¹³ jniang³ dsa² jmøi¹guǿi¹ jian¹² jniang³ ca¹lah¹cónh¹ ja³hnio¹ jniang³ guiag¹³ jniang³. Hiug¹² jín³ hi² quin¹² hi² ná¹² cónh¹ jín³ ca¹lah¹jǿ¹ hi² dsii¹dsa ni³ Diú¹³, ju³lah hi² jøn¹dsa hi² jŋëh¹dsa ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jøng² mi³ca¹jái¹ Jesús ca¹juúh² dsa² héi² jǿg³ dsio¹, ca¹juúh² Jesús: ―Mih² báh³ jø² hei¹² hi² li¹chianh²hning ja³jmo¹² Diú¹³ héh¹ ―ca¹juúh² Jesús. Ni³ jøng² ha¹chian² dsa² siáh² ma¹tí² dsǿa¹² hi² ŋai¹dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jøng² ja³he¹² Jesús jǿg³ ja³dsi¹² guøh¹², ca¹juúh²dsa: ―¿Ha²lah dsio¹ juúh² tøa¹² he¹² lei¹³ quiah¹² Diú¹³ hi² lán¹² Cristo tsø³jon² quiah¹² hlai³ David? ");
INSERT INTO cpaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Di³ hŋiah¹² báh³ hlai³ Davíd ca¹juúh² jǿg³ la² ca¹he¹ jmi²dsí² quiah¹² Diú¹³: Ca¹tsáih¹ Juu¹³ jniang³ Juu¹ jní²: “¡Ní² cog² jní² ta¹guia¹jo¹³ ca¹lah¹ca¹tǿ² jmai³ ja³ca¹jmo¹jni ca¹tiah¹hning dsa² hiag¹³ quiánh²hning!,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hŋiah¹ báh³ hlai³ Davíd ca¹tǿh¹ Cristo Juu³dsa. ¿Ha²lah lǿa¹² jøng² hi² lán¹² Cristo tsø³jon² quiah¹²dsa? ―ca¹juúh² Jesús. Jøng² tøa¹² dsǿa¹² dsa² ti³nang¹² jǿg dsii¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jøng² ca¹he¹ Jesús jǿg³ la²: ―¡Jmo³ ju²hí³ dsøa¹² tøa¹² he¹² lei¹³ quiah¹² Diú¹³, dsa² hniu¹ cáih¹ hmøah¹² jláh³! Jøng² dsa¹ŋi³nio³dsa jøa³hmah³. Mi³jøng² hiei¹ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hniu¹dsa tiogh³dsa ja³jláh³ dsi²néi² guøh¹² ho¹ ju³ ja³jmo¹²dsa jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dsa² héi² cang¹ hniu³ dsa² hnǿi². Jøng² hlanh¹²dsa Diú¹³ ma¹dsio¹² jǿg³ hi² ta³dsǿa¹² jmo¹²dsa. Hiug¹² jín³ ma¹dsio¹² dsag³ rø²canh¹² dsa² héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jøng² mi³guǿ¹³ Jesús cøg¹² gog¹² ja³toh¹²dsa ŋi³néng² ni³ Diú¹³. Jøng² jái¹²dsa ja³toh¹² dsa² jue¹² ŋi³néng². Jøng² jue¹² dsa² chi² cog³ ca¹tóh² ma¹dsio¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jøng² ca¹dsiég¹ jan² hio¹³ hnǿi², dsa² ti²ŋié². Ca¹tóh²dsa ton¹ ŋi³néng² píh³, hi² mi³quien¹² cónh¹ cøng² cog³. ");
INSERT INTO cpaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jøng² ca¹tǿh¹ Jesús dsa² quianh³dsa, ca¹juúh²dsa: ―Lah¹dsóh² juǿi²jni hniah¹². Ma¹dsio¹² cog³ na²tóh² hio¹³ hnǿi², dsa² ti²ŋié² ió¹, cónh¹ jín³ ŋi²toh¹² ca¹lah¹já¹ dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Di³ cónh¹ hi² chiág² quiah¹² báh³ dsa² toh¹² dsa² siáh². Jøng² na²tóh² hio¹³ ió¹ ca¹lah¹jǿ¹ cónh¹ hi² mi³ron¹², ca¹lah¹jǿ¹ hi² mi³lá¹dsa he² hi² hniuh¹² dsi²néi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jøng² ma²hiúg³ Jesús juu¹² u¹hai¹²dsa jnǿ³ ja³tsih¹³ guøh¹² mi³ca¹juúh² jan² dsa² quianh³dsa: ―Tøa¹², ¡Jai³lah dsio¹ guøh¹²! ¡He³lah jláh³ cang³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jøng² ca¹juúh² Jesús: ―¿Jáih³hning hniú¹² cah³ la² quiah¹² guøh¹²? Cu¹dsie¹² tsa¹ma¹lé² ti³juú¹³ jin³ cøng² mǿi² cang³ guøh¹². Gug¹ ca¹lah¹jǿ¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jøng² mi³ma²guǿ¹² Jesús máh² Olivo, tø¹hŋoh¹³ ja³tsih¹³ guøh¹², jøng² ca¹ŋai¹ Pedro quianh¹³ Jacobo quianh¹³ Juan quianh¹³ Andrés ja³cu³guiog³dsa. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¡Heh³ jnieh³ jǿg³ ha²lǿih² lé² lah¹jøng²! ¿He² quianh¹³ li¹lih¹³ jnieh³ na³ma²ja¹quien¹³ lé² ca¹lah¹jǿ¹ jǿg³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Jmo³ ju²hí³ dsøa¹² tsa¹ju³mi¹ga¹² dsa² hniah¹²! ");
INSERT INTO cpaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Di³ jue¹² dsa² ji¹lé², dsa² jmo¹ hi² lán¹²dsa jní². Juúh²dsa: “Jní² báh³ lang¹²” juúh²dsa. Jøng² mi¹ga¹²dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Jøng² na³ma²ca¹nengh² hniah¹² jǿg³ jmo¹²dsa hning², ho¹ ju³ chi² jǿg³ jmo¹²dsa hning² ja³siíh³, jǿg³ dsii¹² dsa², jøng² tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹². Di³ lah¹jøng² báh³ hniuh¹² lé². Di³ ha¹chi² ma²tǿ² ja³dsiá¹ jmøi¹guǿi¹ mi³né³. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jøng² tán¹ juøi² quianh¹³ juøi² siíh². Tán¹ dsa² ta³ quianh¹³ dsa² ta³ jian¹²dsa. Jøng² hliú² ja³tiíh¹ onh¹². Jií¹ hag³cón². Lah¹jøng² báh³ lé² ja³li¹liág¹ jmø³uai¹² hiug¹² li¹chi² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Jøng² cánh³ hniah¹² hí³. Di³ jë́h²dsa hniah¹² ni³ dsa² ta³. Bú²dsa dsi²néi² guøh¹². Dsa¹jiag¹²dsa ni³ dsa² quin¹² ni³ juøi², ni³ rai¹³ huu¹³ quieg¹ jní². Mi³jøng² li¹ŋi¹² dsa² héi² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hniuh¹² báh³ tsø¹ja¹ jǿg³ dsio¹ ta¹jiá¹² ca¹lah¹jǿ¹ ja³tiogh³ dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jøng² na³ma¹ca¹tai¹dsa hniah¹² hi² jë́h²dsa, jøng² tsa¹jmo² ju²hí³ dsøa¹² he² jǿg³ juúh³ hniah¹². Jǿg³ jøng² báh³ juúh³ hniah¹² cónh¹ lǿa¹² jǿg³ he¹ jmi²dsí² quiah¹² Diú¹³. Di³ a¹jáng¹ hniah¹² dsa² juúh³. Jmi²dsí² quiah¹² Diú¹³ báh³ juúh². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jøng² jë́h² dsa² roh¹³dsa. Jë́h² ti³jmi²dsa guing² quián¹²dsa. Tá¹ báh³ guing² quianh¹³ chiég³ jmi² guing². Mi¹dsiag¹² báh³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jøng² li¹hian¹³ ca¹lah¹já¹ dsa² hniah¹² huu¹³ quieg¹ jní². Jøng² liúg² báh³ dsa², ju³lah hein² dsa² ca¹mi¹tián²dsa dsǿa¹²dsa ca¹lah¹ca¹tóh² jø² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Jmai³ jøng² jáih³ hniah¹² hi² tø¹tsǿh² hi² hiug¹² hlaih¹³ ja³tsa¹mi³lé² tø¹tsǿh², hi² jmo¹ dsa¹hén² ca¹lah¹jø¹. (¡Ju³ li¹ŋë́² dsa² høa¹² si² la²!) Jøng² ju³ cuøin¹³ dsa² chian² Judea juu¹² máh². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jøng² ju³ná³ hein² dsa² tiogh³ ja³dsii¹² jmai³ jøng², ju³ cuøin¹³dsa cu¹dsøg¹². Tsa¹ju³dsi¹quín²dsa hi² chi² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jøng² ju³ná³ hein² dsa² tiogh³ jøa³nung² quiah¹²dsa, tsa¹ju³dsi¹lia¹dsa dsa¹quín²dsa tsǿnh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡He³ báh³ ué² jmai³ jøng² quiah¹² hio¹³ quian¹² guing²! ¡Ué² quiah¹² dsa² jian¹² guing² píh³! ");
INSERT INTO cpaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jøng² mi³hlanh¹³ hniah¹² Diú¹³ tsa¹ju³lé³ hi² jøng² jmai³ jin² guǿi². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Di³ hiug¹² hí¹ jmø³uai¹² jmai³ jøng² cónh¹ jín³ jmø³uai¹² ma²ca¹hí¹ jmøi¹guǿi¹ cónh¹ jmai³ ja³ca¹niu¹ jmøi¹guǿi¹ ca¹lah¹ca¹tǿ² jin³ na¹. Jø¹² bín³ ha¹chi² hí¹ jmø³uai¹² hiug¹² lah¹jøng² jmai³ siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jøng² ha¹chian² dsa² mi³liúg² jmai³ jøng² ju³ jmai³ tsa¹ca¹jné¹ Juu¹³ jniang³ ta¹jiá¹². Di³ huu¹³ quiah¹² dsa² ti³quióh³ ca¹jné¹ Diú¹³ jmai³ jøng² ta¹jiá¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Jøng² ju³ná³ hein² dsa² ca¹juúh²: “Jai³lah, dsa² lang¹² báh³ Cristo,” ho¹ ju³ ca¹juúh²dsa: “Dsa² ná¹² báh³ Cristo,” jøng² tsa¹ju³héh³ hniah¹² jǿg³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Di³ li¹chian² báh³ dsa² mi¹gag¹², dsa² juúh² lán¹²dsa Cristo, ho¹ ju³ dsa² juúh² lán¹²dsa dsa² hǿ² jǿg³ quiah¹² Diú¹³. Jmo¹ báh³ dsa² héi² hi² hiug¹²dsa quianh¹³ juu¹² juøh¹². Mi³mi¹ga¹²dsa dsa² ma²ti³quióh³ quián¹² Diú¹³, ju³ jmai³ hi² lé². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jøng² jmóh³ hniah¹² hí³. Di³ lah¹jiá¹² ma²ca¹juǿi² jní² hniah¹² ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ni³ jøng², mi³ma²ca¹tsø³jue¹³ jmø³uai¹² hiug¹² jøng², jøng² nioh¹ hieg². Tsa¹ma¹taih¹² quiah¹² tsøh². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jøng² siúgh² chi³neng¹² ti³buh¹² guiuh¹³. Hiánh² hi² ti³dsøa¹³ guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jøng² jai¹ dsa² jmøi¹guǿi¹ hi² ma²guiogh¹²jni jøa³jneng¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jian¹²dsa. Ma²chi² bí² ma¹dsio¹² hlaih¹³ quieg¹jni. Ma²léi¹³ hiug¹² juanh¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jøng² tsë́³jni ángeles ta³cøng² jmøi¹guǿi¹ ta³quiún² quiuh¹³, hi² dsa¹tiogh¹²dsa loh² dsa² ma²ti³quióh³ quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ma²ŋih³ hniah¹² ha²lah lǿa¹² quiah¹² hma² higo. Na³ma²tsíh² nih¹³ hma², na³ma²hiag¹³ moh¹³, ma²ŋih³ hniah¹² ja¹quién¹ jií¹ jin² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jø¹² bíh³ lah¹jøng² li¹leh¹³ hniah¹² na³ma²tǿ² ja³ja¹quien¹³ lé² ca¹lah¹jǿ¹ hi² jøng², na³ma²jáih² hniah¹² ma²lǿ² lah¹jøng², ju³lah ma²na²juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹jín³ dsiá¹ dsa² chian² na¹ niúh¹ jín³ hi² lé² lah¹jøng² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dsa¹hén² báh³ jmøi¹guǿi¹ lah¹quianh¹³ guiuh¹³ dsøa³. Di³ ha¹chi² dsa¹hén² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jøng² ha¹chian² dsa² ŋi¹² he² jmai³ he² hora lé² lah¹jøng². Ca¹lah¹jin³ ángeles chian² ŋi¹juǿi¹ tsa¹ŋi¹². Ca¹lah¹jin³ jní², dsa² lán¹² jong¹² Diú¹³, tsa¹guiang³jni. Jan² Jmi² jniang³ báh³ ŋi¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’¡Jøng² jáih³ hniah¹²! ¡Túgh³ hniah¹² ju²jŋia¹³! Di³ tsa¹ŋih³ hniah¹² he² jmai³ lé² lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lǿa¹² ju³lah lǿa¹² quiah¹² jan² dsa² dság¹ ja³siíh³. Togh²dsa jǿg³ dsa² quián¹²dsa he² ta³ jmo¹dsa lah¹jan² lah¹jan². Jøng² tsáih¹dsa dsa² jmo¹ hí³ hniú¹² hi² guú¹dsa ju²jŋia¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¡Hi² lah¹jøng² jáih³ hniah¹²! Di³ tsa¹ŋih³ hniah¹² ha²lǿih² guiogh¹³jni. Ju³lah dsa² héi², dsa² jmo¹² hí³ hniú¹², tsa¹ŋi¹²dsa ha²lǿih² jiúgh² dsa² hniu³, ho¹ ju³ ta¹ca¹hlég², ho¹ ju³ dsi¹neng¹², ho¹ ju³ cónh¹ ca¹ho¹ chiih³, ho¹ ju³ cónh¹ ca¹jni¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cu²rø² jáih³ hniah¹², ju³ jøng² ca¹guǿnh¹jni cónh¹ tsa¹ju²jŋiá³. Jøng² jan³jni hniah¹² ti³güéh¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jǿg³ juǿi²jni hniah¹², jǿg³ jøng² juǿi²jni ca¹lah¹já¹ dsa². ¡Ju³ túgh³ hniah¹² ju²jŋia¹³! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ton¹ jmai³ jø² hei¹² ca¹tǿ² jmai³ ta²høa³, jmai³ gøah¹²dsa hi³ŋíh¹ tsa¹quianh¹³ chiúh³. Jøng² ca¹hnangh² juu¹³ jmi²dsa², quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, mai³¹ ha²lah mi¹gan¹²dsa Jesús, hi² chiángh²dsa. Mi³jøng² jŋaih¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Di³ ca¹juúh²dsa: ―Tsa¹lé² chianh¹³ jniang³ jmai³ jmai³, ju³ná³ ca¹jmo¹ dsa² jue¹² møah¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jøng² mi³hiúg³ Jesús juøi² Betania, ja³quiah¹³ Simón, dsa² mi³lán¹² dsag³ hmih¹² tsa¹jŋi¹². Hi² gøah¹²dsa. Jøng² ca¹dsiég¹ jan² hio¹³. Quin¹² hio¹³ cøng² tsǿa¹² lǿa¹² cang³ alabastro, hi² ha³ jmáh¹lah nang³ nardo, hi² ma²juøi². Hmóh³ hlaih¹³ cu¹té¹² nang³ jøng². Jøng² ca¹hnii¹ hio¹³ tsǿa¹². Ca¹tsǿng²dsa nang³ dsi³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jøng² ca¹lø¹hioh¹ ca²dsiog³ dsa² tiogh³. Lë́²dsa: “¿He² løa¹ hén²dsa nang³? ");
INSERT INTO cpaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mi³dsio¹ ju³ ca¹ŋi¹hnai¹. Mi³quien¹² lǿa¹² jín³ guio¹ ŋi²lǿg² héh¹ cog³. Jøng² mi³cuúh¹dsa dsa² ti²ŋié² cog³ jøng²,” lë́² dsa² héi². Jøng² ca¹jé²dsa hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jøng² ca¹juúh² Jesús: ―¡Tsa¹hlanh¹³ dsa²! ¿He² løa¹ cuøh¹² hniah¹² dsa² ju²méh³ dsøa¹²? Hi² dsio¹ báh³ ma²na²jmo¹dsa quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Di³ tiog¹³ báh³ quianh¹³ hniah¹² dsa² ti² dsa² ŋié². Cøng² hi² lé² jmóh³ hniah¹² hi² dsio¹ quianh¹³dsa lah¹jmai³ ja³hnøngh² hniah¹². Di³ ha¹chi² quianh¹³ hniah¹² jní² ja³la² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ma²na²jmo¹ báh³ hio¹³ cónh¹ hi² chi² quiah¹²dsa. Di³ ma²na²tsǿng²dsa nang³ ma²juøi². Ma²na²jmo¹dsa ju³jŋia¹³ jmø²ŋǿ¹² quieg¹jni ja³dsø¹hóg¹dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lah¹dsóh² juǿi²jni hniah¹²: Li¹chi² jǿg³ he² na²jmo¹ hio¹³ lang¹² ja³cog²jni ta³cøng² jmøi¹guǿi¹, ca¹lah¹jǿ¹ ja³hǿ²dsa jǿg³ dsio¹ quiah¹² Diú¹³. Mi³jøng² li¹ŋi¹²dsa he² na²jmo¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jøng¹ ca¹ŋó¹ Judas Iscariote, dsa² quianh¹³ dsa² guia¹tón². Ca¹ŋó¹dsa juu¹² ja³quiah¹³ juu¹³ jmi²dsa², hi² jë́h²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jøng² hioh¹² jénh² dsa² héi² mi³ca¹nǿng²dsa. Ca¹løa¹ jǿg³ cuø¹dsa cog³. Jøng² ca¹hnangh² Judas mai³¹ ha²lah hnë¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jøng² mi³ca¹dsiég¹ lah¹huu¹³ jmai³ jmai³ gøah¹²dsa hi³ŋíh¹ tsa¹quianh¹³ chiúh³, jmai³ mi³jŋëh¹²dsa jah¹chih² quián¹² høa³, jøng² ca¹juúh² dsa² quianh³ Jesús: ―¿Ha²tøah¹ hnøngh²hning dsa³jmó³ jnieh³ ju²jŋia¹³ hi² dsa³quie¹³ jniang³ jmai³ ta²høa³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jøng² ca¹tse¹ Jesús og¹ dsa² quianh³dsa. Ca¹juúh²dsa: ―¡Gu³noh¹² jøa³juøi²! Ja³jøng² jénh³ hniah¹² jan² dsa² quieng² cøng² dsøg³ jmøi². ¡Ti³dse³ hniah¹² cah³dsa! ");
INSERT INTO cpaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jøng² gu³tseih³ dsa² hniu³ ja³hí¹ dsa² héi² dsi²néi²: “Lah¹la² juúh² tøa¹²: ¿Nai¹² hniú¹² dsa¹gǿh¹dsa jmai³ ta²høa³ quianh¹³ dsa² quianh³dsa?” juaih¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jøng² heh¹dsa hniah¹² cøng² hniú¹² juøh¹² ja³ma²ton¹ jué¹, hi² ma²tioh¹³ hi² hniuh¹². Ja³jøng² gu³jmoh³ hniah¹² ju²jŋia¹³ hi² dsa³quie¹³ jniang³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jøng² ca¹ŋi¹lé² dsa² quianh³dsa juu¹² jøa³juøi². Mi³ca¹dsi¹lé²dsa jøng², ca¹løa¹ ca¹lah¹jǿ¹ ju³lah ma²na²juúh² Jesús. Jøng² ca¹jmo¹dsa ju²jŋia¹³ dsa¹gǿh¹dsa quiah¹² høa³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mi³ca¹neng² jøng², ca¹dsiég¹ Jesús quianh¹³ dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jøng² mi³ma²tiogh³dsa ni³gøah¹²dsa, ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Jan² hniah¹² cǿh² quianh¹³ jní², jëh¹³hning jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jøng² huø³ ca¹ti³hǿi² dsǿa¹² dsa² héi². Ca¹juúh²dsa lah¹jan² lah¹jan²: ―¡Héi¹ jní² ná³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jøng² ca¹juúh² Jesús: ―Jan² hniah¹², dsa² guia¹tón² báh³, dsa² tí² hi³ŋíh¹ niúh¹ uøin¹² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Di³ lah¹té¹² neh¹³jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah lǿa¹² si² quiah¹² Diú¹³. ¡He³ báh³ ué² quiah¹² dsa² hnai¹ jní²! Mi³dsio¹ quiah¹²dsa ju³ jmai³ tsa¹ca¹lø¹chián¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja³gøah¹²dsa jøng², ca¹cáng¹ Jesús hi³ŋíh¹. Ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² mi³ca¹jmo¹dsa ti³jneh³, ca¹dsiúh¹dsa. Ca¹juúh²dsa: ―¡Quíh²! Jmø²ŋǿ¹² quieg¹ báh³ jní² la² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jøng² mi³ca¹cáng¹dsa cuøh³, ca¹cuúh¹dsa Diú¹³ di³hmah³. Jøng² ca¹cuúh¹dsa dsa² quianh³dsa. Jøng² ca¹hønh¹ ca¹lah¹já¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jøng² ca¹juúh²dsa: ―Jmø² quieg¹ báh³ jní² la², hi² jmo¹² lø²rø² jǿg³ hmë́² hi² jmo¹² Diú¹³ quianh¹³ hniah¹². Di³ téng¹ jmø²hán¹³jni ni³ huu¹³ quiah¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² ma¹gøh¹³jni jmøi² møi¹gu³jøah¹³ lah¹la² ca¹lah¹ca¹tǿ² jmai³ ja³jmo¹ Diú¹³ héh¹. Jmai³ jøng² gøh¹³jni ni³ hmë́² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jøng² mi³ma²ca¹høa¹dsa alabanza, ca¹ŋi¹lé²dsa juu¹² máh² Olivo. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Lé² jé² hoh¹² hniah¹² ca¹lah¹jáh¹ hniah¹² quianh¹³ jní². Di³ lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Quiugh³jni juu¹³ jáh². Jøng² dsa¹coh¹² jáh² juu¹²,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jøng² na³ma²ca¹hiog¹ jní², nei³jni juu¹² Galilea, ma²jiá¹jni cónh¹ jín³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jøng² ca¹juúh² Pedro: ―Ju³ jmai³ hi² lé² jé² dsǿa¹² ca¹lah¹já¹ dsa², ha¹chi² jé² dsøa¹ jní² mi³né³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hning², na¹ ja³neng² cónh¹ niúh¹ jín³ ca¹ho¹ tánh¹ rón² chiih³, hnaih² rón² jmóh³hning² tsa¹cuaih²hning jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jøng² hiug¹² jín³ ca¹juúh² Pedro calah: ―¡Ha¹chi² mi³né³! ¡Ju³ lah¹la² jón²jni quianh¹³ hnéng¹, ha¹chi² jmo³jni tsa¹cué¹²jni hning²! ―ca¹juúh² Pedro. Jø¹² bíh³ lah¹jøng² ca¹juúh² ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jøng² ca¹dsi¹lé²dsa cøng² ja³tsen² Getsemaní. Jøng² ca¹tsáih¹ Jesús dsa² quianh³dsa: ―Ja³la² túgh² hniah¹² ta³lah¹hlanh¹³jni Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jøng² ca¹ŋó¹dsa hi³méh¹ quianh¹³ Pedro quianh¹³ Jacobo quianh¹³ Juan. Jøng² ca¹táh² dsǿa¹² Jesús. Huø³ ca¹hǿi² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡He³ báh³ hlaih¹³ jéin¹²jni! ¡Ca¹lah¹ma¹gu¹hai¹² jmi²dsí² quieg¹ lǿ²! ¡Jŋi³ di³ hniah¹² ja³la²! ¡Jai³ hniah¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jøng² ca¹ŋó¹ Jesús hi³méh¹. Ca¹quieg²dsa chi³ŋiu¹³ ni³dsa huø¹. Jøng² ca¹hlanh¹dsa Diú¹³ hi² tsa¹mi³dsa¹ŋë²dsa jmø³uai¹² jmai³ jøng², ju³ jmai³ mi³lé². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ca¹juúh²dsa: ―Tiá³, tiah¹hning ca¹lah¹jǿ¹. Jøng² cuúh³hning jǿg³ tsa¹cán¹³jni jmø³uai¹². Di³ tsa¹lé² lah¹cónh¹ ja³hno¹ jní². Hning² ma²ŋih³ ha²lah lé² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jøng² ca¹jógh¹ Jesús ja³tiogh³ dsa² quianh¹³dsa. Ca¹jái¹dsa rø²güé¹ dsa² héi². Jøng² ca¹tsáih¹dsa Pedro: ―¿Rø³güéh¹hning, Simón? ¿Tsa³tiah¹hning jáih³hning ca¹lah¹jin³ cøng² hora? ");
INSERT INTO cpaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","¡Jáih³ hniah¹²! ¡Hlanh¹³ hniah¹² Diú¹³! Mi³jøng² tsa¹ta³canh¹³ hniah¹² dsag³. Lah¹dsóh² hiug² hoh¹² báh³ hniah¹². Jmø²ŋǿ¹² báh³ tsa¹tiúh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jøng² ca¹ŋó¹dsa calah. Ca¹ŋi¹hlanh¹³dsa Diú¹³ cøng² jǿg³ jøng² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jøng² ca¹jógh¹dsa calah. Cónh¹ calah siíh² ma²rø²güé¹ dsa² héi² calah. Di³ hi² tioh¹³ chiég¹² mø³ni³dsa. Jøng² ha¹chi² ma¹ŋi¹²dsa juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jøng² mi³ca¹tǿ² hnaih² rón² ca¹jógh¹dsa, jøng² ca¹juúh²dsa: ―¡Tsø²güe² ná³! ¡Teh³ bí² ná³! Tiúh¹ báh³ ná¹². Di³ ma²dsiég¹ hora. Jai³lah ma²ca¹hnai¹dsa jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jian¹²dsa. Cuai¹dsa ja³cog² dsa² ti³re² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Nung²! ¡Ma¹dsǿg³! Ma²ja¹² ma²quién¹² dsa² jǿinh¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lah¹cónh¹ chi³hløah¹²dsa jǿg³ jøng² ca¹dsiég¹ Judas, dsa² mi³quianh¹³ dsa² guia¹tón². Jøng² jue¹² dsa² ca¹dsi¹lé² quianh¹³dsa. Ti³chinh¹²dsa ŋí³. Ti³chinh¹²dsa hma², dsa² ca¹tse¹ juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³ quianh¹³ dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jøng², ma²ca¹juúh² Judas, dsa² jë́h² Jesús, mi³jøng² li¹ŋi¹² dsa² quianh¹³dsa, ca¹juúh²dsa: ―Ju³ná³ hein² dsa² ca¹chiunh¹jni ni³, dsa² héi² jmah¹³ hniah¹². Jøng² taih³ hniah¹² dsa². Tsa¹cuúh³ hniah¹² liúg²dsa ―ma²ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jøng² mi³ca¹dsiég¹dsa, ca¹ŋó¹ Judas ma²quién¹² ja³tsenh¹³ Jesús. Ca¹juúh²dsa: ―Juu¹³ jniang³ ―ca¹juúh²dsa. Jøng² ca¹chiunh¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jøng² ca¹chiánh²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jøng² jan² dsa² tsenh¹² cøg¹², ca¹dsi¹dsa ŋí³, ca¹quiúgh²dsa dsa² quián¹² juu¹³ ŋi¹jmó². Ca¹tiu¹dsa lø²guø³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jøng² ca¹juúh² Jesús: ―Ma²ja²nioh¹² hniah¹² ti³chinh¹² hniah¹² ŋí³, ti³chinh¹² hniah¹² hma², hi² chiángh² hniah¹² jní², ju³lah jan² dsa² ca¹jmo¹ høin². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jmai³ ca¹lah¹jǿ¹ ca¹he¹jni jǿg³ ja³tsih¹³ guøh¹², jøa³ ja³tiogh³ hniah¹². Ha¹chi² ca¹chiángh² hniah¹² jní². Mi³jøng² lé² ju³lah lǿa¹² jǿg³ quiah¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ni³ jøng² ca¹tég² dsa² quianh³dsa. Ca¹cuøin¹dsa ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jøng² ca¹chi¹dsé² jan² tsih² dsa² ŋioh¹² cah³ Jesús. Rø²guianh¹²dsa hmøah¹² tég¹. Jøng² ca¹chiánh²dsa dsa² ŋioh¹² héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jmáh¹lah hmøah¹² báh³ ca¹të́²dsa. Jøng² ca¹cuøin¹tsih ta¹ma¹ŋo¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jøng² ca¹tai¹dsa Jesús juu¹² ja³quiah¹³ ŋi¹jmó². Jøng² ca¹túgh² ca¹lah¹já¹ juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³ quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jøng² ca¹ŋó¹ Pedro chi³quë́¹. Ca¹dsiég¹dsa ja³dsi¹² quiah¹² ŋi¹jmó². Ca¹guú²dsa ja³tiogh³ tsih² dsa² ta³. Ca¹mi¹dsiogh¹³dsa quianh¹³ si². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jøng² juu¹³ jmi²dsa² quianh¹³ ca¹lah¹já¹ dsa² ti³lán¹³ ta³ quiah¹² guøh¹², ca¹hnah¹dsa dsa² mi³cuúh¹ Jesús dsag³. Mi³jøng² jón²dsa. Jøng² ha¹chian² dsa² ca¹dsanh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hi² jøng² jue¹² dsa² ca¹juúh² jǿg³ tø³jǿg³ ja³cog² Jesús. Tsa¹tø²tsøh³ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jøng² ca¹nung² ca²dsiog³dsa. Ca¹cuø¹dsa dsag³ jǿg³ tø³jǿg³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ca¹néng³ jnieh³ juúh² dsa² ná¹² gúg²dsa guøh¹² quián², hi² ca¹jmo¹ dsa² jmøi¹guǿi¹. Jøng² jmo¹dsa hi² siíh² ja³hnøa¹² jmai³, hi² tsa¹ti¹líh¹ dsa² jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jø¹² bíh³ ha¹chi² ca¹tø³tsøh³ jǿg³ jøng² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jøng² ca¹nung² ŋi¹jmó² dsi²jo². Ca¹ŋǿh¹dsa Jesús. Ca¹juúh²dsa: ―¿Tsa³ŋaih³hning he² jǿg³ juúh²dsa ja³cogh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tei³ báh³ ca¹nung² Jesús. Ha¹chi² ca¹ŋai¹dsa jin³ he². Jøng² ca¹juúh² ŋi¹jmó² calah: ―¿Lanh¹³hning Cristo, jong¹² dsa² dsiog¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jøng² ca¹juúh² Jesús: ―Dsa² héi² báh³ jní². Jøng² janh³ hniah¹² jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², guø³jni cog² dsa² chi² bí² ta¹lah¹guia¹jo¹³. Guio³jni jøa³jneng¹² hei¹² guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jøng² ca¹gǿi¹ ŋi¹jmó² tsǿnh³, hi² hne²dsa. Jøng² ca¹juúh²dsa: ―Tsa¹ma¹hniuh¹² cuø¹dsa dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma²na²nengh¹² báh³ hniah¹² jǿg³ hlaih¹³. ¿Ha²lah lë́h² hniah¹²? ―ca¹juúh² ŋi¹jmó². Jøng² ca¹juúh² ca¹lah¹já¹ dsa² héi² hi² re² Jesús dsag³, hi² mi³jón²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jøng² ca¹qui² ca¹hŋió² ca²dsiog³ dsa² héi² Jesús. Ca¹hŋiéng²dsa ni³ Jesús quianh¹³ hmøah¹². Ca¹cu² ca¹jmógh²dsa. Jøng² ca¹juúh²dsa: ―¡He³ jǿg³ hein² cu²jmágh²! ―ca¹juúh²dsa. Jøng² ca¹cuúh¹ tsih² dsa² ta³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ja³guǿ¹³ Pedro ja³dsi¹³, ca¹dsiég¹ jan² tsih²mǿ² jmo¹² ta³ quiah¹² ŋi¹jmó². ");
INSERT INTO cpaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jøng² mi³ca¹jë́² tsih²mǿ² Pedro, mi²dsiogh¹²dsa quianh¹³ si², jøng² ca¹juúh²dsa: ―Hning² mi³hiúgh³ quianh¹³ Jesús, dsa² chian² Nazaret héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jøng² ca¹juúh² Pedro: ―¡Ha¹chi² mi³né³! Cu¹dsie¹² tsa¹guiang³jni he² jǿg³ juúh²hning ―ca¹juúh²dsa. Jøng² ca¹nung²dsa tø¹cøg¹² hi³méh¹. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jøng² mi³ca¹jǿi² tsih²mǿ² héi² calah, ca¹tsáih¹dsa dsa² tiogh³ cøg¹², ca¹juúh²dsa: ―Quianh¹³dsa dsa² ió¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jøng² ca¹juúh²dsa calah ha¹chi². Ma²cu²lǿi² jøng² ca¹juúh² dsa² tiogh³ cøg¹², ca¹tsáih¹dsa Pedro: ―Lah¹dsóh² hiúgh³hning quianh¹³dsa. Dsa² chian² Galilea báh³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jøng² ca¹jí² Pedro, ca¹juúh²dsa: ―¡Ca¹lah¹jái¹² Diú¹³! ¡Tsa¹cué¹²jni dsa² hiah¹² hniah¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dsø¹juu¹² jøng² báh³ ca¹ho¹ chiih³ ma²tǿ² tánh¹. Jøng² dsagh² dsǿa¹² Pedro jǿg³ ca¹juúh² Jesús, hi² juúh²dsa hnøa¹² rón² tsa¹cuai¹²dsa cónh¹ niúh¹ jín³ ca¹ho¹ chiih³ tánh¹ rón². Jøng² ca¹táh² dsǿa¹²dsa. Ca¹ho¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jøng² mi³ca¹jni¹ jøng², ca¹túgh² juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³, quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³, quianh¹³ ca¹lah¹já¹ dsa² ti³lán¹² ta³ quiah¹² guøh¹². Jøng² mi³ca¹hŋió²dsa Jesús, ca¹ŋi¹jian¹²dsa juu¹² ni³ ta³, hi² ca¹jë́h²dsa Jesús Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jøng² ca¹ŋǿh¹ Pilato Jesús, ca¹juúh²dsa: ―¿Lanh¹³hning Rai¹³ quián¹² dsa² Judío? ―ca¹juúh²dsa. Jøng² ca¹ŋai¹ Jesús, ca¹juúh²dsa: ―Lán¹² báh³ jní² ju³lah ma²na²juøh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jøng² ca¹hnë¹ hlaih¹³ juu¹³ jmi²dsa² quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ni³ jøng² ca¹ŋai¹ Pilato calah. Ca¹juúh²dsa: ―¿Tsa³ŋaih³hning jin³ he²? Jai³lah ma¹dsio¹² dsag³ cuøh¹²dsa hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jøng² dsogh¹² dsǿa¹² Pilato. Di³ cu¹dsie¹² tsa¹ca¹ŋai¹ Jesús jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jøng² ma²lǿa¹² mai³¹ quiah¹² Pilato hi² liúg²dsa jan² dsa² hiúg³ hni¹ŋí³ jmai³ ta²høa³, lǿa¹² ju³ hein² dsa² ca¹më́¹ dsa² juøi² liúg². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jøng² mi³hiúg³ jan² dsa² tsen² Barrabás hni¹ŋí³ quianh¹³ dsa² jian¹²dsa, dsa² ca¹mi¹dsian¹² dsa² ja³ca¹tán¹dsa quianh¹³ dsa² ta³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jøng² ca¹dsi¹lé² dsa² jue¹². Ca¹møa¹dsa ju³lah lǿa¹² mai³¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jøng² ca¹juúh² Pilato, ca¹tsáih¹dsa dsa² jue¹²: ―¿Hnøngh³ hniah¹² log³jni Rai¹³ quián¹² dsa² Judío? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Di³ ma²ŋi¹² Pilato ca¹jë́h² juu¹³ jmi²dsa² Jesús ni³ huu¹³ hi² hioh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jøng² ca¹tsáih¹ juu¹³ jmi²dsa² dsa² jue¹² hi² liúg² Pilato Barrabás. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jøng² ca¹juúh² Pilato, ca¹tsáih¹dsa dsa² ca¹ŋi¹jian¹² Jesús: ―¿He² hnøngh² hniah¹² jmo¹³jni quianh¹³ dsa² lang¹², dsa² tøah¹² hniah¹² Rai¹³ quián¹² dsa² Judío? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jøng² ca¹hløah¹ dsa² héi² tí². Ca¹juúh²dsa: ―¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juuh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jøng² ca¹juúh² Pilato: ―¿He² løa¹? ¿He² hi² ma²ca¹jmo¹dsa jøng²? ―ca¹juúh²dsa. Jøng² hiug¹² jín³ tí² ca¹hløah¹ dsa² héi²: ―¡Crøg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jøng² ca¹liúg² Pilato Barrabás. Mi³jøng² li¹hiug² dsǿa¹² dsa² jue¹². Jøng² mi²ca¹ŋi³bá²dsa Jesús, jøng² ca¹jmo¹dsa héh¹ ta¹ton¹³dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jøng² ca¹ŋi¹jiag¹² hlég² dsi²néi² quiah¹² dsa² ta³, ja³tǿh²dsa Pretorio. Jøng² ca¹tǿh¹dsa ca¹lah¹já¹ hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jøng² ca¹quieh¹dsa Jesús hmøah¹² guiéng², ju³lah hmøah¹² caih¹² rai¹³. Jøng² ca¹tí²dsa cøng² tsøi² tang¹² dsi³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ni³ jøng² ca¹tsáih¹dsa Jesús: ―Hiug¹² juanh¹²hning Rai¹³ quián¹² dsa² Judío ―ta³dsǿa¹² juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jøng² ca¹bá²dsa dsi³ Jesús quianh¹³ hma² ta³. Ca¹qui² ca¹hŋiéng²dsa. Jøng² ca¹hlanh¹dsa Jesús chi³jné¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mi³ca¹cu² ca¹jmógh²dsa lah¹jøng², jøng² ca¹jŋíh²dsa hmøah¹² guiéng². Ca¹quieh¹dsa dsa² tsǿnh³dsa. Jøng² ca¹ŋi¹jiag¹²dsa juu¹² ja³ca¹ta³ton¹²dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jøng² ca¹tsø³jue¹³ jan² dsa² tsen² Simón ja³jøng², dsa² chian² Cirene, ti³jmi² Alejandro quianh¹³ Rufo. Jogh¹²dsa jøa³nung². Jøng² ca¹jmo¹dsa héh¹ ca¹cán¹ dsa² héi² crǿg¹³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jøng² ca¹jian¹dsa Jesús cøng² ja³tsen² Gólgota, hi² hniu¹dsa juúh²dsa: Máh² Mu² Dsi³ Dsa². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jøng² mi³cuø¹dsa Jesús vino rø²guia¹² mǿa¹² jinh² jmo¹² tsa¹cøh² quiah¹²dsa. Di³ tsa¹ca¹hiei¹dsa mi³né³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jøng² ca¹tiang¹dsa crǿg¹³. Jøng² ca¹jmo¹ hlég² ma¹cǿng¹ tsǿnh³ Jesús. Ca¹li²dsa jǿg³ he² hmøah¹² ta¹dsa, lah¹jan² lah¹jan²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hein¹³ ŋiu¹ tu¹heg² ca¹tiang¹dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jǿg³ la² lǿa¹² si² ca¹chio¹dsa ni³ ta³: “Rai¹³ quián¹² dsa² Judío.” ");
INSERT INTO cpaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jøng² ca¹tiog¹dsa og¹ dsa² høin² cog² Jesús, jan² dsa² ta¹lah¹guia¹jo¹³, jan² dsa² ta¹lah¹guia¹jón¹. Ca¹tiang¹dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hi² jøng² báh³ ca¹lø¹ti¹ jǿg³ ju³lah lǿa¹² si² quiah¹² Diú¹³: “Ca¹jmo¹dsa hiúg³dsa quianh¹³ dsa² ti³re² dsag³,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jøng² jǿg³ hlaih¹³ ca¹juúh² dsa² ca¹tsø³jue¹³ ja³jøng². Ca¹guieh¹dsa dsi³dsa. Di³ tsa¹tøa¹² dsǿa¹²dsa. Ca¹juúh²dsa: ―Hning², dsa² mi³gúgh² guøh¹², jøng² mi³tsøh³hning calah ja³hnøa¹² jmai³, ");
INSERT INTO cpaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Logh³ hŋiah¹! ¡Siog³ crǿg¹³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jøng² ca¹cu² ca¹jmágh² calah juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―Ca¹liúg²dsa dsa². Tsa¹tiúh¹dsa liog¹dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Ju³ siúg²dsa crǿg¹³ chi²júh² lán¹²dsa rai¹³ quián² jniang³, dsa² lég² jniang³! Mi³jøng² ne¹³ jniang³. Jøng² báh³ hé² jniang³ jǿg³ quiah¹²dsa ―ca¹juúh²dsa. Jø¹² bíh³ ca¹jí² calah dsa² ti³ton¹² crǿg¹³ quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jøng² mi³ca¹tǿ² dsi¹hiég¹, ca¹hǿi² neng² ta³cøng² ja³jøng² ca¹tǿ² hein¹³ hnøa¹² ta¹ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hein¹³ hnøa¹² jøng² ca¹hløah¹ Jesús tí² hlaih¹³. Ca¹juúh²dsa: ―Eloi, Eloi, ¿lama sabactani? ―hi² hniu¹dsa juúh²dsa: “Diú¹³ quian¹, Diú¹³ quian¹, ¿He² løa¹ ma²na²tégh²hning jní²?” ");
INSERT INTO cpaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jøng² mi³ca¹nǿng² dsa² tiogh³ ja³jøng², ca¹juúh² ca²dsiog³dsa: ―Jai³lah, tǿh²dsa hlai³ Elías ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jøng² ca¹ŋó¹ jan² dsa² gu¹hei¹². Ca¹ŋi¹tí²dsa cøng² hi² lǿa¹² ju³lah lǿa¹² hmøah¹² jmøi² jinh². Mi³jøng² ca¹ha¹ jmøi². Jøng² ca¹cǿin²dsa hi² jøng² dsi³ hma², hi² mi³hinh¹²dsa Jesús. Ca¹juúh²dsa: ―Jŋih³ ná³. Ju³ne¹³ cøng² chi²júh² jí¹ hlai³ Elías hi² ji¹siúg²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ni³ jøng² tí² hlaih¹³ ca¹ho¹ Jesús ta³lah¹ca¹hná² dsí². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jøng² ca¹gøi² hmøah¹² hei¹² dsi²jo² dsi²néi² guøh¹². Ca¹gøi² ca¹tǿ² guiuh¹³ ca¹tǿ² huø¹. Ca¹løa¹ ton¹ jag¹³ hmøah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jøng² mi³ca¹jái¹ juu¹³ hlég², dsa² mi³tsenh¹² ni³ Jesús, ha²lah ca¹hná² dsí²dsa lah¹jøng², jøng² ca¹juúh²dsa: ―Lah¹dsóh² mi³lán¹² dsa² ná¹² jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jøng² mi³tiogh³ hio¹³ calah, hi² jái¹²dsa ja³uǿin³. Tiogh³ María, dsa² chian² Magdala, quianh¹³ Salomé, quianh¹³ María mi³chiég³ Jacobo meh² quianh¹³ José. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hio¹³ héi² ca¹ŋi¹lé² quianh¹³ Jesús jmai³ ca¹ŋøa¹dsa ja³tén¹² Galilea. Ca¹mi¹ti¹dsa ni³ Jesús. Jø¹² bíh³ mi³tiogh³ jue¹² hio¹³ siáh² calah, dsa² ca¹ja¹lé² juu¹² Jerusalén quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jøng² mi³ca¹hlég² jøng², ca¹tǿ² ja³jmo¹²dsa ju²jŋia¹³ jmai³ sa³¹. Di³ hloh¹² jmai³ sa³¹ báh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hi² jøng² ca¹ŋó¹ José, jan² dsa² ta³ juanh¹², dsa² chian² Arimatea, dsa² hé² jǿg³ hi² jií¹ ja³jmo¹ Diú¹³ héh¹. Ca¹jmo¹dsa tsa¹goh¹²dsa. Ca¹ŋó¹dsa ni³ Pilato. Ca¹më́¹dsa hlai³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jøng² dsogh¹² dsǿa¹² Pilato ca¹jon¹ Jesús ta³tí³ jøng². Ca¹ŋi³téh³dsa juu¹³ hlég². Ca¹ŋai¹dsa chi²júh² ma²na²jon¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jøng² mi³ma²na²juúh² juu¹³ hlég², ca¹cua¹dsa José hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jøng² mi²ma²na²lá¹ José hmøah¹² tuh¹², ca¹siúg²dsa hlai³. Ca¹dsǿgh²dsa hmøah¹² tuh¹². Jøng² ca¹ŋi¹hǿg²dsa niúh¹ cøng² tøg²hløg² hi² ca¹guiég¹ dsa². Jøng² ca¹jnéi¹dsa tøg² quianh¹³ cang³ pa³. ");
INSERT INTO cpaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jøng² ca¹jái¹ María, dsa² chian² Magdala, quianh¹³ María mi³chiég³ José ja³ca¹quiag¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jøng² mi³ca¹tsø³jue¹³ jmai³ sa³¹, María, dsa² chian² Magdala, quianh¹³ Salomé, quianh¹³ María, mi³chiég³ Jacobo meh², ca¹lá¹dsa hi² ma²ro², hi² mi³dsa¹tsog²dsa hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jøng² ta¹ŋih¹³ cónh¹ mi³ma²hian² hieg² jmai³ du²mei³¹, ca¹ŋi¹lé²dsa juu¹² tøg²hløg². ");
INSERT INTO cpaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jøng² ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―¿Hein² dsa² jŋíh² cang³ chi³jnøa¹² hag³ tøg²hløg² quián² jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jøng² ca¹jái¹dsa ma²rø²jŋih¹² cang³. Juøh¹² hlaih¹³ cang³. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jøng² mi³ca¹túgh²dsa niúh¹ tøg², jøng² ca¹jë́²dsa jan² tsih² dsa² ŋioh¹². Guǿ¹²dsa ta¹lah¹guia¹jo¹³. Teg² tsǿnh³dsa. Jøng² gøg² hlaih¹³ ca¹can¹ hio¹³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jøng² ca¹juúh² dsa² ŋioh¹²: ―¡Tsa¹jmo² ganh¹! Hnah¹² hniah¹² Jesús, dsa² chian² Nazaret, dsa² ca¹jon¹ ni³ crǿg¹³. Ca¹hiog² báh³ dsa². Ha¹chian² dsa² chian². Jai³ ja³ca¹quiag¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jøng² gu³tseih³ hniah¹² dsa² quianh³dsa quianh¹³ Pedro hi² dsa¹jiá¹³dsa cónh¹ hniah¹² juu¹² Galilea. Ja³jøng² janh³ hniah¹² dsa² ju³lah ma²ca¹tsáih¹dsa hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jøng² ca¹huah¹ hio¹³ tøg². Ca¹cuøin¹dsa. Goh¹²dsa ca¹lah¹jlia¹²dsa cu¹té¹². Jøng² ha¹chian² dsa² ca¹tsáih¹dsa. Di³ goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mi³ca¹jni¹ jmai³ du²mei³¹, mi³ma²ca¹hiog² Jesús, jøng² ca¹jǿi² Maria lah¹ni³, dsa² chian² Magdala héi², dsa² ca¹huø¹ Jesús guio¹ jmi²dsí² hlaih¹³ quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jøng² ca¹ŋi³tseih³ hio¹³ héi² dsa² mi³quianh¹³ Jesús, dsa² huø³ ma²hei¹² dsǿa¹² hi² ho¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jøng² mi³ca¹nǿng² dsa² héi² hi² jinh³ Jesús, hi² ca¹jǿi² hio¹³ héi², jøng² ha¹chi² ca¹hé¹dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ni³ jøng² ca¹jǿi² og¹ dsa² mi³quianh¹³dsa héi² juu¹² ja³ŋi²nio³dsa juu¹² jøa³nung². Siíh² báh³ ma²jniá² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jøng² ca¹ŋi¹hǿ²dsa jǿg³ quiah¹² dsa² quianh¹³dsa. Jø¹² bíh³ ha¹chi² ca¹hé¹dsa jǿg³ quiah¹² dsa² héi² calah. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ni³ jøng² ca¹jǿi² dsa² guia¹ján¹ ja³ti³gøah¹²dsa. Jøng² ca¹jé² Jesús dsa² héi². Di³ huh² dsi³dsa. Tsa¹hé²dsa jǿg³. Di³ tsa¹ca¹hé¹dsa jǿg³ quiah¹² dsa² ca¹jǿi² mi³ca¹hiog²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Gu³noh¹² ta³cøng² jmøi¹guǿi¹! ¡Gu³hǿ² jǿg³ dsio¹ quiah¹² Diú¹³ ca¹lah¹jǿ¹ ja³tiogh³ dsa² jmøi¹guǿi¹! ");
INSERT INTO cpaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ju³ná³ hein² dsa² ca¹hé¹ jǿg³, tsogh¹dsa jmøi². Jøng² liúg²dsa. Ju³ná³ tsa¹hé²dsa, jøng² ta¹canh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jøng² mai³¹ la² báh³ cán² dsa² hé² jǿg³: Huø¹dsa jmi²dsí² hlaih¹³ ni³ quieg¹ jní². Hløah¹dsa jǿg³ siíh², tsa¹ŋë́² dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jøng² ju³ná³ chiánh²dsa møh² cónh¹ tsa¹ju²jŋiá³, di³ tsa¹ca¹jǿi²dsa, ho¹ ju³ ju³ná³ ca¹hǿnh²dsa jmøi² hiug¹², ha¹chi² hi² jenh¹³dsa. Jøng² quiég¹dsa gug²dsa ni³ quiah¹² dsa² dsoh³, jøng² hliú²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jøng² mi³ca¹hlanh¹ Jesús, Juu¹³ jniang³, dsa² héi², jøng² ca¹ŋáh¹dsa juu¹² ŋi¹juǿi¹. Ja³jøng² ca¹guú²dsa quianh¹³ Diú¹³, cog²dsa ta¹lah¹guia¹jo¹³. ");
INSERT INTO cpaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jøng² ca¹ŋi¹lé² dsa² quianh¹³dsa héi². Ca¹ŋi¹hǿ²dsa jǿg³ dsio¹ ta³cøng² jmøi¹guǿi¹. Ca¹mi¹hag¹² Juu¹³ jniang³. Ca¹jmo¹ Juu¹³ jniang³ ca¹løa¹ juu¹² juøh¹² jøng², hi² ma²lǿa¹² mai³¹ quiah¹²dsa, ja³ca¹hǿ²dsa jǿg³. Mi³jøng² ca¹lø¹lih¹³ dsa² jue¹² hi² dsio¹ jǿg³. Lah¹jøng² báh³ ca¹løa¹.");
INSERT INTO cpaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Guiuh¹³ Teófilo, jue¹² dsa² ma²ca¹jmo¹ bí² hi² tiun¹dsa si² ca¹lah¹jǿ¹ jǿg³ ca¹lah¹cónh¹ hi² ma²ca¹lø¹ti¹ jøa³ ja³tiagh³ jniang³, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ca¹lah¹cónh¹ lǿa¹² jǿg³ juúh² dsa² ca¹jái¹ ha²lah ca¹løa¹ cónh¹ jmai³ lah¹ni³, dsa² ca¹hǿ² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hi² jøng² jní² calah, mi³ca¹hnangh¹jni ha²lah lah¹dsóh² ca¹løa¹ ca¹lah¹jǿ¹ ca¹lah¹cónh¹ jmai³ mi³ca¹lø¹liág¹, ca¹jmo¹jni dsøa¹ hi² tǿng³jni cu²rø² si² la² ca¹lah¹jǿ¹ jǿg³ jøng². Jøng² dsianh¹³jni si² quiánh² hning². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mi³jøng² li¹ŋih³hning hi² lah¹dsóh² té¹² jǿg³ ma²ca¹nengh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mi³chian² jan² jmi²dsa² tsen² Zacarías, jmai³ mi³lán¹² Herodes rai¹³ huø¹ Judea. Hiúg³dsa quianh¹³ cu²tséh¹ jmi²dsa², dsa² quián¹² Abías. Elizabét báh³ tsen² ji²gug²dsa, dsa² lán¹² tsø³jong¹³ hlai³ Aarón. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dsiog¹dsa ta³og¹ Zacarías quianh¹³ Elizabet ja³ta¹ni¹ Diú¹³. Ti³jan¹dsa ja³mi²ti¹dsa ca¹lah¹jǿ¹ lei¹³ quiah¹² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jøng² ha¹chian² guing² chian² quián¹²dsa. Dsa² juu³ báh³ Elizabet. Cu¹dsie¹²dsa ma²ti³guiugh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jøng² lah¹la² ca¹løa¹ cøng² jmai³ ja³ca¹të́² Zacarías quianh¹³ cu¹tséh¹ jmi²dsa² jian¹²dsa jmo¹ ta³ ni³hiég², hi² mi²ti¹dsa ni³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ca¹dsi¹ jmi²dsa² jǿg³ he² ta³ tan¹dsa lah¹jan² lah¹jan²dsa. Di³ lah¹jøng² mi³lǿa¹³ mai³¹ quiah¹²dsa. Zacarías ca¹të́² ta³ dsa¹jín¹dsa chiun² dsi²néi² guøh¹² quiah¹² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mi³ma²jøn¹²dsa chiun² dsi²néi² guøh¹², jue¹² dsa² ma²tiogh³ ja³dsi¹², ni³hlanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jøng² ca¹jnia¹ jan² ángel quián¹² Juu¹³ jniang³, hi² ca¹jǿi² Zacarías. Tsenh¹² ángel cøg¹² ni³hiég² ta¹lah¹guie¹jo¹³, ja³jøn¹²dsa chiun². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jøng² ca¹can¹ Zacarías gøg² mi³ca¹jǿi²dsa. Ca¹lø¹chián¹dsa ju²hí³ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jøng² lah¹la² ca¹juúh² ángel: ―Tsa¹jmo² ganh¹ Zacarías. Ma²ca¹nǿng² báh³ Diú¹³ jǿg³ ca¹hlanh¹³hning dsá¹. Jmo¹ báh³ Diú¹³ li¹chian² jan² guing² dsa² ŋioh¹² quiánh²hning quianh¹³ Elizabet. Jøng² tøah¹³hning guing² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Túgh³ hniah¹² hioh¹² jénh² hniah¹². Li¹chianh² hniah¹² ju²hiúg¹ dsøa¹². Jue¹² dsa² jmo¹ hioh¹² hi² ma²ca¹lø¹chián¹guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Di³ lén² guing² quiánh²hning dsa² juanh¹² ja³ta¹ni¹ Diú¹³. Ha¹chi² jmøi² hiug¹² hǿnh²dsa, ju³lah jmøi² vino. Jmi²dsí² han¹³ quiah¹² Diú¹³ cán²dsa ca¹lah¹cónh¹ jmai³ ja³li¹chian²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jmo¹dsa hi² jéinh¹ dsǿa¹² jue¹² dsa² israel. Mi³jøng² ŋi¹nio¹dsa juu¹² quiah¹² Juu¹³ jniang³, Diú¹³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ŋøa¹dsa ja³ta¹ni¹ Diú¹³ ju³lah ca¹ŋøa¹ hlai³ Elías. Li¹chi² bí² quiah¹²dsa ju³lah mi³chi² quiah¹² dsa² héi². Jmo¹dsa niu¹ tei³ jǿg³ neng¹² quiah¹² dsa² canh¹³ quianh¹³ jong¹²dsa. Jmo¹dsa hi² jéinh¹ dsǿa¹² dsa² tsa¹nang¹² jǿg³. Mi³jøng² lén²dsa dsa² chian² dsǿa¹², dsa² dsiog¹. Togh¹²dsa dsa² jue¹² ju²jŋia¹³, dsa² li¹quianh¹³ Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jøng² ca¹juúh² Zacarías, ca¹tsáih¹dsa ángel: ―¿He² quianh¹³ li¹léi¹³jni hi² lah¹dsóh² lé² lah¹jøng²? Di³ ma²guiuh¹³jni. Jø¹² ma²guiugh² hio¹³ quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jøng² ca¹juúh² calah ángel: ―Jní² báh³ tsen² Gabriel, dsa² mi²ti¹ ni³ Diú¹³. Dsa² héi² ca¹tsei¹ jní² hi² ja¹hlanh¹³jni hning² jǿg³ dsio¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jai³lah. Lénh²hning dsa² cag³, dsa² tsa¹lé² hløah¹ ca¹lah¹ca¹tǿ² jmai³ ja³li¹ti¹ jǿg³ ma²na²juǿi²jni hning². Di³ tsa¹ca¹héh¹hning jǿg³, jǿg³ li¹ti¹ na³ma²ca¹dsiég¹ jmai³ ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jøng² ti³jŋiang¹² dsa² jue¹² ja³dsi¹² guøh¹². Dsogh¹² dsǿa¹²dsa hi² ca¹lø¹han¹ Zacarías dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jøng² mi³ca¹u¹hái¹dsa, ca¹jmo¹dsa léi¹³ quianh¹³ gug²dsa hi² tsa¹ma¹lé² hløah¹dsa. Hi² jøng² ca¹lø¹lih¹³ dsa² jue¹² hi² chi² cøng² hi² na²jái¹ Zacarías, hi² quiah¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jøng² mi³ca¹dsóh¹ Zacarías ta³ mi³jmo¹²dsa ni³hiég², ca¹ŋáh¹dsa juu¹² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ni³ jøng² Elizabet, hio¹³ quián¹²dsa, ca¹can¹ guing². Jøng² hŋiá² tsøh² jmai³ ca¹hmóh¹ hio¹³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Na¹ jín³ ma²ca¹mi³hag¹³ Juu¹³ jniang³. Ma²ca¹jŋíh²dsa ju²hiíh¹ mi³chi² quieg¹jni ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jian¹²jni,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mi³ma²ca¹tsø³jue¹³ jŋió² tsøh² jmai³, ca¹tse¹ Diú¹³ ángel tsen² Gabriel héi², ca¹tsei¹dsa juu¹² Nazaret, juøi² tén¹² Galilea, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","juu¹² ja³quiah¹³ jan² tsih² mǿ², tsih² më́², dsa² ma²lǿa¹² jǿg³ hi² jian¹ jan² dsa² tsen² José, tsø³jong¹³ hlai³ Davíd. María báh³ tsen² tsih² mǿ² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jøng² ca¹hí¹ ángel dsi²néi² ja³mi³hiúg³ tsih² mǿ² héi². Ca¹juúh²dsa: ―Juanh¹² hoh¹²hning María. Juanh¹² dsǿa¹² Diú¹³ ma²jmo¹ ja³cogh²hning. Quianh¹³ báh³ hning² Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jøng² ca¹hlan¹ dsǿa¹² María mi³ca¹nǿng²dsa jǿg³ jøng². “¿He² bíh³ jǿg³?” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jøng² ca¹juúh² calah ángel: ―Tsa¹jmo² ganh¹ María. Di³ juanh¹² báh³ dsǿa¹² Diú¹³ ja³cogh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jøng² canh¹³hning guing². Li¹chian² jan² guing² dsa² ŋioh¹² quiánh²hning. Jøng² tøah¹³hning guing² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lén²guing dsa² hiug¹² juanh¹². Li¹tsen²guing jong¹² Diú¹³ juanh¹². Jøng² cuø¹ Diú¹³, Juu¹³ jniang³, bí² hi² cán²dsa ni³ juøi², ju³lah bí² mi³chi² quiah¹² hlai³ David, dsa² juanh¹² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mi³jøng² cán²dsa ni³ juøi² israel jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹. Ha¹chi² dsa¹ŋë́² hi² jmo¹dsa héh¹ ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jøng² ca¹juúh² María, ca¹tsáih¹dsa ángel: ―¿Ha²lah lé² lah¹jøng²? Di³ ha¹chian² dsa² ŋioh¹² chian² quian¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jøng² ca¹juúh² calah ángel, ca¹tsáih¹dsa María: ―Jií¹ jmi²dsí² han¹³ juu¹² ja³ŋíh³hning. Dsa² héi² báh³ dsa² të² dsa² hiog³ quián¹² Diú¹³ juanh¹². Jmo¹ jmi²dsí² han¹³ juu¹² juøh¹². Mi³jøng² guing² li¹chian² héi² li¹tsen² dsa² han¹³, jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jø¹² bíh³ ma²quian¹² Elizabet rúh²hning guing², dsa² mi³ma²guiugh². Ma²tǿ² jŋió² tsøh² quian¹²dsa guing², dsa² mi³lán¹³ dsa² juu³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Di³ ha¹chi² hi² chi² hi² tsa¹tiúh¹ Juu¹³ jniang³ jmo¹ ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jøng² ca¹juúh² María: ―La² báh³ tsenh¹²jni, dsa² mi²ti¹ quiah¹² Juu¹³ jniang³. Ju³lé³ ja³cog²jni ca¹lah¹cónh¹ lǿa¹² jǿg³ quiánh²hning ―ca¹juúh²dsa. Jøng² ca¹ŋáh¹ calah ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jmai³ jøng² ca¹ŋó¹ María juu¹² máh², juu¹² ja³neng¹² cøng² juøi² tén¹² huø¹ Judea. Ca¹ŋó¹dsa cøng² ŋi³juu¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ja³jøng² ca¹hí¹dsa dsi²néi² ja³quiah¹³ Zacarías. Jøng² ca¹haih²dsa jǿg³ Elizabet. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mi³ca¹nǿng² Elizabet jǿg³ ca¹juúh² María, jøng² ca¹jë́h² guing² quian¹²dsa. Ca¹lø¹quianh¹³dsa jmi²dsí² han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tí² ca¹hløah¹dsa. Ca¹juúh²dsa: ―Dsio¹ dsǿa¹² Diú¹³ ja³cogh²hning María ca¹lah¹cónh¹ ja³ca¹lah¹já¹ dsa² mǿ². Dsio¹ dsǿa¹²dsa ja³cog² guing² li¹chian² quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tsa¹lë́²jni tan¹jni hi² jií¹ mi³chiég³ Juu¹³ jniang³ juu¹² ja³guø³jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Di³ ca¹jë́h² guing² quian¹²jni mi³na²nang¹jni jǿg³ hi² ma²na²tseih³hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hioh¹² jénh²hning. Di³ ca¹héh¹hning jǿg³ ca¹juúh² Juu¹³ jniang³ ca¹tsáih¹dsa hning². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jøng² ca¹juúh² María: Mi³juanh¹³ báh³ jní² Juu¹³ jniang³ quianh¹³ jmi²dsí² quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Guø³jni ju²hiúg¹ dsøa¹² ni³ huu¹³ quiah¹² Diú¹³ quian¹jni, dsa² lég²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ma²ca¹dságh¹ dsǿa¹² Diú¹³ jní², dsa² hiug¹² ti²ŋié², jní² dsa² mi²ti³ ni³dsa. Di³ na¹ ta¹lah¹jmai³ ja³já¹³ li¹juúh² dsa² jue¹² hi² lán¹²jni dsa² hioh¹² jenh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dsa² chi² bí² ma²ca¹jmo¹ hi² dsio¹ ja³cog²jni. Dsa² han¹³ báh³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Huø³ dsǿa¹²dsa ja³cog² ca¹lah¹já¹ dsa² nang¹² gøg² jǿg³ quiah¹²dsa, jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ma²ca¹mi¹léi¹³dsa hi² chi² bí² quiah¹²dsa. Ma²ca¹guianh¹dsa dsa² tø¹cøg¹², ju³lah dsa² ŋi²nio³ rú² ca¹lah¹cónh¹ dsø²jiag¹² dsǿa¹²dsa guiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ma²ca¹tiúh¹dsa quianh¹³ dsa² ue¹² dsǿa¹² mi³chi² bí² quiah¹². Ca¹jmo¹dsa ma²canh¹³ dsa² mi³lán¹² dsa² ti²ŋié². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hliú² hi² dsio¹ ma²ca¹cuúh¹dsa dsa² tsa¹mi³chi² hi² li¹gǿh¹. Ma²ca¹tióg²dsa dsa² mi³chi² ma¹dsio¹² quiah¹². Ca¹tiáng²dsa ti²ŋié²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ma²ca¹mi¹hog³dsa dsa² Israel, dsa² mi²ti¹ ni³dsa. Tsa¹ca¹ŋi¹hén² dsǿa¹²dsa jǿg³ hi² jmo¹dsa huø³ dsǿa¹²dsa, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ju³lah lǿa¹² jǿg³ ca¹tsáih¹dsa dsa² hóg¹ quián² jniang³, jǿg³ quiah¹² hlai³ Abraham quianh¹³ tsø³jong¹³dsa, dsa² li¹chian² jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹, ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jøng² ca¹jŋi¹ María ja³quiah¹³ Elizabet cónh¹ úg² tsøh² jmai³. Jøng² ca¹ŋáh¹dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mi³ca¹dsen¹ jmai³ quiah¹² Elizabet, jøng² ca¹lø¹chián¹ jan² guing² dsa² ŋioh¹² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jøng² mi³ca¹nǿng² dsa² ju³roh¹³dsa quianh¹³ dsa² juøi² jian¹²dsa ha²lah ca¹jmo¹ Juu¹³ jniang³ huø³ dsǿa¹²dsa ja³cog²dsa, jøng² ca¹túgh²dsa hioh¹² jenh¹²dsa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma²jŋi¹ jmai³ ca¹lø¹chián¹ guing² ca¹jiag¹ chieg³ jmi² guing² ja³ca¹ŋi¹jmo¹dsa circuncisión quiah¹²guing. Jøng² Zacarías mi³tǿh²dsa guing². Di³ lah¹jøng² tsen² ti³jmi²guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cónh¹jøng² chiég³guing tsa¹ca¹cuø¹ jǿg³. ―Juan¹³ báh³ li¹tsen²guing ―ca¹juúh² chiég³guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa chiég³guing: ―¿He² løa¹ lah¹jøng² li¹tsen²guing? Ha¹chian² dsa² ju²rúh²hning tsen² lah¹jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jøng² quianh¹³ gug²dsa ca¹ŋǿh¹ dsa² héi² ti³jmi²guing he² hniu¹ ti³jmi²guing li¹tsen²guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jøng² ca¹møa¹ ti³jmi²guing ca²jneh³ si². Jǿg³ la² ca¹tiun¹dsa ni³ si²: “Juan báh³ tsen² guing².” Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dsø¹juu¹² jøng² ca¹ná² hag³ Zacarías. Ca¹løa¹ ca¹hløah¹dsa calah. Jøng² ca¹mi¹juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² quianh¹³dsa, dsa² tiogh³ cøg¹². Ca¹lah¹tan¹³ ja³tiogh³dsa juu¹² máh² ja³tén¹² Judea ca¹dsii¹dsa jǿg³ ha²lah ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jøng² ca¹lah¹já¹ dsa² ca¹nǿng² jǿg³, ca¹ŋi¹jiag¹² dsǿa¹²: ―¿Ha²lah lé² quiah¹² guing² héi²? ―lë́²dsa. Di³ quianh¹³ báh³ guing² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jøng² ca¹jmo¹ jmi²dsí² han¹³ dsǿa¹² Zacarías, ti³jmi²guing. Mi³jøng² ca¹hǿ² Zacarías jǿg³ la², ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dsa² juanh¹² báh³ Juu¹³ jniang³, Diú¹³ quián² jniang³ dsa² israel. Di³ ma²ca¹guøn¹dsa jøa³ ja³tiagh³ jniang³. Ma²ca¹lég²dsa jniang³, dsa² lán¹² dsa² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma²ca¹cuan¹dsa jan² dsa² lah¹dsóh² tiúh¹ lég² jniang³, dsa² tsø³jong¹³ hlai³ David, dsa² ca¹mi¹ti¹ ni³dsa, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ju³lah lǿa¹² jǿg³ ca¹jmo¹dsa ma²lǿih² quianh¹³ hag³ dsa² ti³jan¹ mi³hǿ² jǿg³ quiah¹²dsa, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","jǿg³ hi² lég²dsa jniang³ ja³cog² dsa² ue¹² dsǿa¹², dsa² hiag¹³ hniu¹ mi³jmógh². ");
INSERT INTO cpaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mi³jøng² jmo¹dsa huø³ dsǿa¹²dsa ju³lah lǿa¹² jǿg³ ca¹tsáih¹dsa dsa² hóg¹. Mi³jøng² mi¹ti¹dsa jǿg³ ca¹jmo¹dsa ma²lǿih² jøng², ");
INSERT INTO cpaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","jǿg³ ca¹mi¹dsøg¹²dsa hŋiah¹²dsa, hi² ca¹tsáih¹dsa hlai³ Abraham, ");
INSERT INTO cpaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","jǿg³ hi² liúg² jniang³ ja³cog² dsa² hiag¹³. Mi³jøng² tsa¹li¹goh¹² jniang³ ja³mi³ti³ jniang³ ni³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Hi² ŋi³niang³ jniang³ ti³jan¹ jniang³ ja³ta¹ni¹dsa, hi² ha¹chi² dsag³ røi² jniang³ ca¹lah¹cónh¹ jmai³ ja³chiang² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jøng² hning², guing² quian¹jni, li¹tsenh²hning dsa² hǿ² jǿg³ quiah¹² Diú¹³, dsa² hiug¹² juanh¹². Di³ ŋǿh³hning ni³jiá¹ cónh¹ jín³ Juu¹³ jniang³, hi² jmóh³hning ju²jŋia¹³ juu¹² ja³ŋøa¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Héh³hning jǿg³ ha²lah lé² liúg² dsa² quián¹²dsa, ha²lah lé² dsa¹hén² dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Di³ huø³ báh³ dsǿa¹² Diú¹³ quián² jniang³. Cuan¹dsa dsa² lég² jniang³, dsa² jmo¹ taih¹ juu¹² ja³ŋi²niang³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mi³jøng² tsa¹ma¹tiágh³ jniang³ ja³neng² ja³nioh¹², ja³mi³dsiág¹ jniang³. Hi² li¹ne³ jniang³ juu¹² ja³li¹rø² jǿg³ quián² jniang³ quianh¹³ Diú¹³, ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jøng² ca¹ŋi¹juanh¹²guing. Ca¹lø¹bí² dsǿa¹²guing hi² ŋøa¹guing jmáh¹lah juu¹² quiah¹² Diú¹³. Ca¹gú²dsa máh² ja³ha¹chian² dsa² tiogh³ ca¹lah¹ca¹tǿ² jmai³ ja³ca¹lø¹cuai¹² dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jmai³ jøng² ca¹tsø² ca¹jan¹ héh¹ ca¹jmo¹ rai¹³ Augusto hi² dsa¹tion¹ dsa² jmøi¹guǿi¹ si² ca¹lah¹já¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ca¹løa¹ lah¹ni³ censo jøng², jmai³ mi³lán¹³ Cirenio dsi³máh² ja³tén¹² huø¹ Siria. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jøng² ca¹ŋi¹lia¹ ca¹lah¹já¹ dsa² ŋi¹tion¹dsa si² lah¹jan² lah¹jan² dsa² ha² juøi² ja³tén¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hi² jøng² ca¹u¹hái¹ José Nazaret, juøi² tén¹² Galilea. Ca¹ŋó¹dsa juu¹² Belén, juøi go² hlai³ David, juøi² tén¹² Judea. Juøi² jøng² ca¹të́²dsa, di³ tsø³jong¹³ hlai³ David báh³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ca¹ŋi¹tion¹dsa si² quianh¹³ María, mǿ² quián¹²dsa, dsa² lǿa¹² jǿg³ jian¹dsa, dsa² ma²quian¹² guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ja³jøng² ma²tiogh³dsa mi³ca¹tǿ² jmai³ ja³li¹chian² guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jøng² ca¹lø¹chián¹ guing² ne¹³ quián¹²dsa, guing² dsa² ŋioh¹². Ca¹dsúgh²dsa guing² hmøah¹². Ca¹quiag¹dsa niúh¹ hma² mong¹². Di³ tsa¹ca¹lø¹jǿg¹ dsi²néi² ja³mi³jŋi¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ja³jøng² mi³tiogh³ juu¹³ jah¹chih² chiuh³ juøi², dsa² jmo¹² hí³ jáh² quián¹²dsa ja³neng². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jøng² ca¹jnia¹ jan² ángel quián¹² Juu¹³ jniang³ ja³tiogh³ dsa² héi². Ta³lah¹ca¹jni¹ taih¹² quiah¹² Juu¹³ jniang³ lah¹jin² lah¹lǿih¹ ja³tiogh³dsa. Ca¹can¹ hlaih¹³dsa gøg². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jøng² ca¹juúh² ángel, ca¹tsáih¹dsa juu¹³jah: ―¡Tsa¹jmo² ganh¹! Di³ hiug¹² dsio¹ jǿg³ quin³jni quiánh² hniah¹², jǿg³ li¹quiah¹² ca¹lah¹já¹ dsa² jmøi¹guǿi¹ calah, jǿg³ jmo¹ hi² túgh³ hniah¹² hioh¹² jénh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Di³ jøa³juøi² go² hlai³ David na²lø¹chián¹ jan² dsa² liúg² hniah¹². Cristo báh³ héi², Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hi² la² báh³ jmo¹ li¹ŋih³ hniah¹²: Dsianh¹² hniah¹² guing² rø²dsugh¹² hmøah¹², hiúg³guing niúh¹ hma² mong¹² ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta¹na¹cónh¹ jøng² ca¹jnia¹ quianh¹³ ángel héi² cu²tséh¹ jue¹² dsa² chian² ŋi¹juǿi¹, dsa² mi²juanh¹² Diú¹³. Lah¹la² ca¹juúh² dsa² héi²: ");
INSERT INTO cpaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Hiug¹² juanh¹² báh³ Diú¹³, dsa² guǿ¹² guiuh¹³. Niu¹ tei³ báh³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹, ju³lah dsa² tøa¹² dsǿa¹² Diú¹³ ja³cog², ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jøng² mi³ma²na²ŋi¹lia¹ ángeles juu¹² ŋi¹juǿi¹, ca¹dsii¹ juu¹³ jáh² héi² jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―Ma¹dsǿg³ jøa³juøi² Belén jøng². Ma¹ne¹³ cøng² hi² na²løa¹, ca¹lah¹cónh¹ lǿa¹² jǿg³ ma²na²he¹ Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ca¹ŋi¹lé²dsa jøng² cøng² ŋi³juu¹³. Ca¹dsanh¹²dsa María quianh¹³ José quianh¹³ guing². Hiúg³guing niúh¹ hma² mong¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jøng² mi³ma²na²jǿi²dsa, ca¹he¹dsa jǿg³ ma²na²nǿng²dsa quiah¹²guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² ni³nang¹² jǿg³ ca¹juúh² juu¹³jah. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Cónh¹jøng² ca¹can¹ María hí³. Ca¹dsii¹dsa dsǿa¹² ca¹lah¹jǿ¹ jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ca¹ŋi¹lia¹ báh³ juu¹³jah héi². Ca¹mi¹juanh¹²dsa ca¹mi¹dsiog¹dsa Diú¹³ ni³ huu¹³ ca¹lah¹jǿ¹ hi² ca¹nǿng²dsa hi² ca¹jái¹dsa, ju³lah lǿa¹² jǿg³ ma²ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma²jŋi¹ jmai³ ca¹lø¹chián¹guing ca¹jmo¹dsa circuncisión quiah¹²guing. Jøng² ca¹tǿh¹dsa guing² Jesús, ju³lah ca¹juúh² ángel hi² li¹tsen²guing cónh¹ niúh¹ jín³ hi² ca¹can¹ María guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jøng² mi³ca¹dsen¹ jmai³ ja³ma²lé² mi¹jŋió¹ jmi²dsa² chiég³ jmi² Jesús ni³ huu¹³ hi² ca¹lø¹chián¹ guing² quián¹²dsa, ju³lah lǿa¹² lei¹³ quiah¹² hlai³ Moisés, jøng² ca¹jian¹dsa guing² juu¹² jøa³juøi² Jerusalén. Ca¹dsii¹dsa gug² tai³ Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Di³ lah¹la² rø²juúh² lei¹³ quiah¹² Juu¹³ jniang³: “Li¹quián¹² Juu¹³ jniang³ ca¹lah¹já¹ guing² ne¹³, ju³lah guing² dsa² ŋioh¹²,” rø²juúh² lei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jø¹² bíh³ ca¹dsii¹dsa ni³ Diú¹³ ju³lah rø²juúh² lei¹³. Di³ rø²juúh² báh³ lei¹³ hi² hniuh¹² cuan¹dsa og¹ jug² bøa¹² ho¹ ju³ og¹ guing² jug² tiug². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jmai³ jøng² mi³guǿ¹³ jan² dsa² tsen² Simeón jøa³juøi² Jerusalén. Dsa² dsiog¹ báh³ héi², dsa² hnio¹ Diú¹³. Mi³chi³jŋi¹²dsa jmai³ ja³liúg² dsa² israel. Quin¹²dsa jmi²dsí² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma²ca¹jmo¹ jmi²dsí² han¹³ dsǿa¹² dsa² héi² hi² jë́²dsa Cristo quián¹² Juu¹³ jniang³ ca¹lah¹cónh¹ niúh¹ jín³ hi² tsa¹jón²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jøng² ca¹jiag¹ jmi²dsí² juu¹² guøh¹². Ni³ jøng², mi²ca¹ŋi¹jiag¹ chiég³ jmi² guing² Jesús guøh¹², hi² jmo¹dsa quiah¹² guing² ju³lah lǿa¹² lei¹³, ");
INSERT INTO cpaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","jøng² ca¹chiánh² Simeón héi² guing². Ca¹mi¹juanh¹²dsa Diú¹³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Juu¹³ jniang³, na¹ jín³ ma²lé² cuúh³hning jǿg³ hi² dsa¹cu² dsa¹hén²jni jmøi¹guǿi¹, ju³lah lǿa¹² jǿg³ ma²ca¹juøh³hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Di³ ma²na²jan¹jni dsa² lég² jnieh³, ");
INSERT INTO cpaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","dsa² ca¹hiah¹³hning ni³ huu¹³ quiah¹² ca¹lah¹já¹ dsa², ");
INSERT INTO cpaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","dsa² jmo¹ taih¹ juu¹² ja³ŋi¹nio¹ dsa² tsa¹lán¹² dsa² israel, dsa² jmo¹ lén² dsa² israel dsa² canh¹³, dsa² lán¹² dsa² juøi² quiánh²hning, ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jøng² ca¹can¹ chiég³ jmi² Jesús gøg² mi³ca¹nǿng²dsa jǿg³ ca¹juúh² Simeón ja³cog² guing² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jøng² ca¹juúh² Simeon jǿg³ dsio¹ quiah¹² chiég³ jmi²guing calah. Lah¹la² ca¹juúh²dsa, ca¹tsáih¹dsa María, mi³chiég³guing: ―Jai³lah. Ca¹të́² guing² lang¹² jmo¹ li¹chi² jǿg³ dsio¹ quiah¹² jue¹² dsa israel. Jø¹² bíh³ jmo¹dsa li¹chi² jǿg³ hlaih¹³ quiah¹² dsa² jue¹² calah. Cónh¹ calah li¹chian² dsa² juúh² hlaih¹³ ja³cog² hŋiah¹² guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Li¹chianh²hning ju²cǿh¹ dsøa¹² ca¹lah¹cøng² hi² ca¹ŋai¹ ŋi³tǿi¹ jmi²dsí² quiánh²hning. Lah¹jøng² báh³ lé². Mi³jøng² li¹léi¹³ hi² dsø²jiag¹² dsǿa¹² dsa² jue¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jø¹² bíh³ ja³jøng² mi³hiúg³ jan² dsa² hǿ² jǿg³ quiah¹² Diú¹³, dsa² tsen² Ana, ja³mái¹³ hlai³ Fanuel, tsø³jong¹³ hlai³ Aser. Ma²guiugh² hlaih¹³ Ana. Ca¹gú²dsa guio¹ ji²ŋi² quianh¹³ ji²gug²dsa ma²jmai³ mi³tsih²mǿ²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jøng² ma²lán¹²dsa hio¹³ hnøi² ochenta y cuatro ji²ŋi², mi³ca¹jon¹ ji²gug²dsa. Ni³ jøng² cu¹dsie¹² ha¹chi² ma²ca¹u¹hái¹dsa coh¹³ jnǿ² ja³tsih¹³ guøh¹². Cøng² hi² ca¹mi¹juanh¹²dsa Diú¹³. Ca¹mi¹han¹²dsa ta³lah¹ca¹hlanh¹dsa Diú¹³ lah¹huu² lah¹jmø². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na¹ cónh¹ jøng² ca¹dsiég¹ dsa² guiugh² héi². Ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹dsii¹dsa jǿg³ quiah¹² Jesús. Ca¹tsáih¹dsa dsa² hé² jǿg³ hi² li¹chian² dsa² liúg² dsa² chian² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jøng² mi³ma²ca¹mi¹ti¹ chiég³ jmi² Jesús ca¹lah¹jǿ¹ ca¹lah¹cónh¹ hi² rø²juúh² lei¹³, jøng² ca¹ŋi¹lia¹dsa juu¹² ja³tén¹² Galilea, juu¹² jøa³juøi² Nazaret, juøi² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jøng² ca¹ŋi¹juanh¹² ca¹lø¹bé²guing. Ma¹dsio¹² ca¹lø¹ŋi¹²guing. Dsio¹ dsǿa¹² Diú¹³ ja³cog²guing. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lah¹cøng² lah¹cøng² ji²ŋi² dsø²lé² chiég³ jmi² Jesús jmai³ ja³tøa¹² jmai³ ta²høa³ jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jøng² mi³ca¹dsóh² Jesús guie¹tǿn² ji²ŋi², ca¹ŋi¹lé²dsa calah jmai³ ju³lah lǿa¹² mai³¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mi³ca¹ŋǿ² jmai³ jøng² ma²dsø²lia¹dsa. Tsa¹ŋi¹² chiég³ jmi² Jesús hi² ca¹jŋi¹ hi²meh² Jesús jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lë́ chiég³ jmi² hi²meh² hi² hiúg³ hi²meh² jøa³ ja³ja²lia² dsa² jue¹². Jøng² mi³ca¹tǿ² cøng² jmai³ tiogh³dsa juu¹², ca¹hnah¹²dsa hi²meh² Jesús ja³ma²ca¹jŋi¹ ju³roh¹³dsa quianh¹³ dsa² jenh² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cónh¹jøng² ha¹chian² hi²meh² ma²ca¹dsanh¹²dsa. Jøng² ca¹jénh¹dsa juu¹². Ca¹ŋi¹lé²dsa calah juu¹² jøa³juøi² Jerusalén, hi² ca¹ŋi¹hniah¹²dsa hi²meh² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma²hnøa¹² jmai³ jøng² ca¹dsanh¹²dsa hi²meh² ja³tsih¹² guøh¹². Guǿ¹²dsa jøa³ ja³tiogh³ tøa¹². Nang¹²dsa jǿg³ dsii¹²dsa. Ŋai¹²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dsogh¹² dsǿa¹² ca¹lah¹já¹ dsa² ni³nang¹² jǿg³ ca¹juúh² hi²meh² Jesús, jǿg³ ma²ŋi¹² hi²meh². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jøng² dsogh¹² dsǿa¹² chiég³ jmi² hi²meh² mi³ca¹jǿi²dsa. Jøng² ca¹juúh² mi³chiég³ hi²meh²: ―¿He² løa¹ ma²ca¹jmoh³hning lah¹jøng² ja³cog² jnieh³, jon¹²? Hiug¹² ma²chian² jnieh³ ju²hí³ dsøa¹² quianh¹³ ti³ŋieih¹²hning. Ma²ca¹ŋi³hniah¹³ jnieh³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa chiég³ jmi²dsa: ―¿He² løa¹ hnangh¹² hniah¹² jní²? ¿Tsa³ŋih³ hniah¹² hi² hniuh¹² jmo³jni ta³ quiah¹² Ti³ŋieh¹ jní²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cónh¹jøng² ha¹chi² ca¹lø¹ŋë́h² dsǿa¹²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jøng² ca¹ŋáh¹ Jesús juu¹² jøa³juøi² Nazaret quianh¹³ chiég³ jmi²dsa. Cøng² hi² ca¹nǿng² báh³ dsa² gøg² jǿg³ quiah¹² chiég³ jmi²dsa. Mi³chiég³dsa ca¹dsii¹ dsǿa¹² ca¹lah¹jǿ¹ hi² lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jøng² cøng² ca¹ŋi¹juanh¹² Jesús. Hiug¹² ma¹dsio¹² ca¹lø¹ŋi¹²dsa. Dsio¹ dsǿa¹² Diú¹³ ja³cog²dsa. Jø¹² bíh³ dsio¹ dsǿa¹² dsa² juøi² jian¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ma²guie¹hŋí² ji²ŋi² ma²lán¹² Tiberio rai¹³, ma²lán¹² Poncio Pilato dsi³máh² ja³tén¹² Judea. Jøng² Herodes ma²lán¹² ta³ ja³tén¹² Galilea. Felipe, roh¹³ Herodes, ma²lán¹² ta³ ja³tén¹² Iturea quianh¹³ Traconite. Lisanias ma²lan¹² ta³ ja³tén¹² Abilinia. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma²lán¹² Anás quianh¹³ Caifás ŋi¹jmó² quián¹² dsa² judío. Jmai³ jøng² ca¹he¹ Diú¹³ jǿg³, ca¹heh¹dsa Juan, ja³ŋiúh³ Zacarías, dsa² ma²guǿ¹² ja³ha¹chian² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jǿg³ jøng² ca¹ŋi³hǿ¹³ Juan ca¹lah¹tan¹³ cøg¹² ja³hiu³ jmøi² Jordán. Ca¹ŋi³hǿ¹³dsa jǿg³ hi² hniuh¹² jéinh¹ dsǿa¹² dsa² jmøi¹guǿi¹ ja³cog² Diú¹³. Jøng² tsogh¹dsa jmøi² calah. Mi³jøng² hén² Diú¹³ dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lah¹jøng² ca¹løa¹, ju³lah rø²juúh² si² quiah¹² hlai³ Isaías, dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³. Lah¹la² rø²juúh² si²: Li¹chian² dsa² hløah¹ tí² juu¹² ja³ha¹chian² dsa² tiogh³, dsa² juúh²: “¡Jmo³ ju²jŋia¹³ juu¹² ja²ŋøa¹ Juu¹³ jniang³! ¡Jmo³ cu¹dsøg¹² juu¹² ja³ŋøa¹dsa! ");
INSERT INTO cpaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Di³ lah¹dsóh² li¹cángh² báh³ cuú¹, ju³lah ca¹lah¹jǿ¹ ja³jøh². Lé² huø¹ møi² báh³ ja³tioh¹³ cónh¹², ja³tioh¹³ máh². Lé² báh³ cu¹dsøg¹² ca¹lah¹jǿ¹ ja³qui²jeinh¹² juu¹². Li¹rø² ca¹lah¹jǿ¹ ja³hlaih¹³ juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Li¹ŋi¹² ca¹lah¹já¹ dsa² jmøi¹guǿi¹ ha²lah lé² liúg²dsa ja³cog² Diú¹³,” juúh²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hi² jøng² lah¹la² ca¹juúh² Juan, ca¹tsáih¹dsa dsa² jue¹² ca¹ŋi¹lé² ja³tsenh¹³dsa, dsa² hniu¹ tsog¹ jmøi², ca¹juúh²dsa: ―Hniah¹² dsa² lanh¹² ju³lah lán¹² møh², héi¹ dsa² nang¹² jǿg³ quiah¹² Diú¹³ hniah¹² hi² mi³liúgh² hniah¹² ja³na¹ bíh³ cuø¹ Diú¹³ jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dsio¹ mi³tih³ hniah¹² ju³lah jan² dsa² lah¹dsóh² ma²ca¹jéinh¹ dsǿa¹². Tsa¹ju³lë́h³ hniah¹² hi² ha¹chi² hi² jénh³ hniah¹² huu¹³ hi² ni³lanh¹² hniah¹² tsø³jong¹³ hlai³ Abraham. Tiúh¹ báh³ Diú¹³ jmo¹ li¹chian² tsø³jong¹³ hlai³ Abraham quianh¹³ cang³ ná¹² ti³gah¹ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ja¹quien¹³ lé² quiánh² hniah¹² ju³lah lǿa¹² quiah¹² hma² tsa¹cuø¹² mǿi² gøah¹² dsa². Hma² jøng² quiuh¹²dsa. Jmo¹²dsa cuai³. Dsii¹²dsa si². Lah¹jøng² dsa¹hénh² hniah¹² ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jøng² ca¹ŋai¹ dsa² jue¹², ca¹juúh²dsa: ―¿He² hi² hniuh¹² jmó³ jniang³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jøng² ca¹juúh² Juan: ―Ju³lah dsa² chi² ton¹ hmøah¹² hiúg³dsa, dsio¹ cuø¹ dsa² héi² cøng² hmøah¹² quiah¹² dsa² tsa¹chi² quiah¹². Ju³lah dsa² chi² hi² li¹gǿh¹dsa, dsio¹ mi¹hog¹³ dsa² héi² dsa² tsa¹chi² quiah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jø¹² bíh³ ca¹ŋi¹lé² dsa² cagh¹² cog³. Mi³jøng² chiag¹ Juan jmøi² quiah¹²dsa. Ca¹juúh²dsa ca¹tsáih¹dsa Juan: ―Tøa¹², ¿he² hi² hniuh¹² jmó³ jnieh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jøng² ca¹juúh² Juan: ―Tsa¹cánh³ hniah¹² cog³ ma¹dsio¹². Cónh¹jøng² cánh³ hniah¹², cónh¹ ja³ma²lǿa¹² lei¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jø¹² bíh³ ca¹ŋai¹ calah ca²dsiog³ hlég², ca¹juúh²dsa: ―Jøng² jnieh³, ¿he² hi² hniuh¹² jmó³ jnieh³? ―ca¹juúh²dsa. Jøng² ca¹juúh² Juan: ―Tsa¹høinh¹³ hniah¹² jin³ he² hi² chi² quiah¹² dsa², hi² juúh³ hniah¹² hi² cuøh¹³ hniah¹² dsa² jmø³uai¹² ho¹ ju³ hi² cuúh³ hniah¹² dsag³ tsa¹re²dsa, ju³ná³ tsa¹ca¹cuø¹dsa. Ju³li¹hiug² hoh¹² hniah¹² ca¹lah¹cónh¹ té¹² hi² ma²hliah¹³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jøng² ma²ti³høa¹² dsǿa¹² dsa² jue¹² tiogh³, lë́²dsa chi²júh² lán¹² Juan Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hi² jøng² ca¹juúh² Juan, ca¹tsáih¹dsa ca¹lah¹já¹ dsa² tiogh³: ―Lah¹dsóh² chiog¹² báh³ jní² hniah¹² jmøi². Cónh¹jøng² jí¹ jan² dsa² hiug¹² jín³ hi² chi² bí² quiah¹² cónh¹ jín³ jní². Dsa² héi² tí² jmi²dsí² han¹³ quiánh² hniah¹². Jmo¹dsa hi² lénh² hniah¹² dsa² ti³jan¹. Tsa¹lë́²jni tén¹²jni tsøh³jni løg² dsǿ² tai³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma²tsenh¹²dsa ju²jŋia¹³ hi² quiáh²dsa dsa² li¹quianh¹³dsa, ju³lah jan² dsa² juú² qui¹². Chiag¹dsa hi² dsio¹. Jøng² tí²dsa hi² tsa¹dsio¹ dsi²si² tsa¹øg² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hliú² jǿg³ lah¹jøng² ca¹juúh² Juan, hi² ca¹heh¹dsa dsa² jue¹² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jøng² ca¹juúh² Juan hi² ca¹jmo¹ Herodes, dsa² lán¹² ta³, hi² hlaih¹³. Di³ ma²ca¹jian¹ Herodes hio¹³ quián¹² roh¹³dsa, hio¹³ tsen Herodías. Jø¹² bíh³ hliú² hi² hlaih¹³ lah¹jøng² ma²ca¹jmo¹ Herodes. Hi² jøng² ca¹lø¹hiag¹³ dsa² héi² mi³ca¹juúh² Juan jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ni³ ja³ca¹lah¹jǿ¹ hi² hlaih¹³ jøng² ca¹jmo¹dsa, jøng² ca¹tanh¹²dsa Juan hni¹ŋí³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mi³ma²ca¹jŋó² jue¹² dsa² juøi² jmøi², jøng² ca¹jŋó² hŋiah¹² Jesús jmøi² calah. Jøng² ma²hlanh¹²dsa Diú¹³ mi³ca¹ná² guiuh¹³ ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jøng² ca¹siog² jmi²dsí² han¹³ ni³ quiah¹²dsa, hi² jniá² jmi²dsí² ju³lah jniá² jan² jug². Jøng² ca¹hløah¹ Diú¹³ guiuh¹³ ŋi¹juøí¹, ca¹tsáih¹dsa Jesús: ―Hning² báh³ jon¹jni. Hnó¹jni hning². Hiug¹² tøa¹² dsøa¹jni hning² ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma²hiúg³ Jesús cónh¹ guieg²guí² ji²ŋi² mi³ca¹mi¹liág¹dsa hi² ca¹heh¹dsa dsa² jue¹² jǿg³ quiah¹² Diú¹³. Jue¹² dsa² lë́²dsa hi² lán¹² Jesús ja³ŋiúh³ José. Cónh¹jøng² dsa² lang¹² báh³ dsa² lán¹² dsa² canh¹³ quián¹²dsa: Elí, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","jong¹² Matat, jong¹² Leví, jong¹² Melqui, jong¹² Jana, jong¹², José, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","jong¹² Matatías, jong¹² Amós, jong¹² Nahum, jong¹² Esli, jong¹² Nagai, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","jong¹² Maat, jong¹² Matatías, jong¹² Semei, jong¹² José, jong¹² Judá, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","jong¹² Joana, jong¹², Resa, jong¹² Zorobabel, jong¹² Salatiel, jong¹² Neri, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","jong¹² Melqui, jong¹² Adi, jong¹² Cosam, jong¹² Elmodam, jong¹² Er, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","jong¹² Josué, jong¹² Eliezer, jong¹² Jorim, jong¹² Matat, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","jong¹² Leví, jong¹² Simeón, jong¹² Judá, jong¹² José, jong¹² Jonán, jong¹² Eliaquim, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","jong¹² Melea, jong¹² Mainán, jong¹² Matata, jong¹² Natán, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","jong¹² David, jong¹² Isaí, jong¹² Obed, jong¹² Booz, jong¹² Salmón, jong¹² Naasón, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","jong¹² Aminadab, jong¹² Aram, jong¹² Esrom, jong¹² Fares, jong¹² Judá, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","jong¹² Jacob, jong¹² Isaac, jong¹² Abraham, jong¹² Taré, jong¹² Nacor, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","jong¹² Serug, jong¹² Ragau, jong¹² Peleg, jong¹² Heber, jong¹² Sala, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","jong¹² Cainán, jong¹² Arfaxad, jong¹² Sem, jong¹² Noé, jong¹² Laméc, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","jong¹² Matusalén, jong¹² Enoc, jong¹² Jared, jong¹² Mahalaleel, jong¹² Cainán, ");
INSERT INTO cpaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","jong¹² Enós, jong¹² Set, jong¹² Adán, jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ma²quin¹² Jesús jmi²dsí² quiah¹² Diú¹³ mi³ca¹jŋó²dsa jmøi² chi³jmøi² Jordán. Jøng² ca¹jiag¹ jmi²dsí² juu¹² ja³ha¹chian² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ton¹lág¹ jmai³ ca¹ŋie³dsa ja³jøng², ja³ca¹jmo¹ dsa² hlanh³ láh² ju³jmo¹³ Jesús hi² hlaih¹³. Ha¹chi² ca¹gǿh¹dsa jmai³ jøng². Jøng² ma²lǿ² li¹i³cónh¹²dsa mi³ca¹hian¹² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jøng² ca¹juúh² dsa² hlanh³, ca¹tsáih¹dsa Jesús: ―Jmóh³hning hi² lé² hi³ŋíh¹ cang³ la², chi²júh² lah¹dsóh² lanh¹²hning jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jøng² ca¹juúh² Jesús: ―Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “A¹jáng¹ jmáh¹lah hi² quie¹² jnieh³ jmo¹² hi² chiang² jnieh³, dsa² jmøi¹guǿi¹,” rø²juúh² si² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jøng² ca¹jiag¹² dsa² hlanh³ cøng² ja³ca¹ŋi³heh¹³dsa Jesús cu¹ŋieih¹³ ta³cøng² jmøi¹guǿi¹, ja³tioh¹³ ca¹lah¹jǿ¹ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jøng² ca¹juúh² dsa² hlanh³: ―Cuǿ¹³jni hning² bí² ja³cog² ca¹lah¹jǿ¹ juøi² quianh¹³ ca¹lah¹jǿ¹ hi² jláh³ quiah¹² dsa² tiogh³. Di³ jní² báh³ dsa² ca¹të́² ca¹lah¹jǿ¹ hi² jøng². Lé² báh³ jainh¹³jni quiah¹² lǿa¹² ju³ hein² dsa² hno¹jni jainh¹³jni quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hi² jøng² li¹quiánh² báh³ hning² ca¹lah¹jǿ¹ hi² jøng², ju³ná³ mi³juanh¹³hning jní² ―ca¹juúh² dsa² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Cónh¹jøng² lah¹la² ca¹juúh² Jesús: ―Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Mi³juanh¹³ jniang³ Juu¹³ jniang³, dsa² lán¹² Diú¹³ quián² jniang³. Jan² dsa² héi² mi³ti³ jniang³ ni³,” rø²juúh² si² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jøng² ca¹jiag¹² dsa² hlanh³ juu¹² jøa³juøi² Jerusalén. Ca¹tseh¹dsa Jesús guiuh¹³ hniú¹² guøh¹². Jøng² ca¹juúh²dsa: ―Jmóh³hning cøng² ju³tiah²hning huø¹, chi²júh² lah¹dsóh² lanh¹²hning jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Di³ lah¹la² rø²juúh² jǿg³ quiah¹² Diú¹³: Dsiag¹² Diú¹³ ju²gug² tai³ ángeles quián¹²dsa hi² jmo¹dsa hí³ hning², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jø¹² bíh³ lah¹la² rø²juúh² si² calah: Chiag¹dsa juu¹² guiuh¹³. Mi³jøng² tsa¹quian¹ cang³ taih³hning, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jøng² ca¹juúh² Jesús: ―Jø¹² bíh³ lah¹la² rø²juúh² si²: “Tsa¹jmóh³hning hi² cánh³hning jǿg³ dsøg¹² quiah¹² Diú¹³ quiánh²hning, dsa² lán¹² Juu¹³ jniang³,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hi² jøng² ca¹ŋáh¹ dsa² hlanh³ cu²hna² mi³tsa¹ma¹ca¹dsóh²dsa mai³¹ siíh² hi² mi³ta¹canh¹³ Jesús dsag³. Jmai³ siíh² báh³ tiúh¹dsa quianh¹³ Jesús, lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tí² ma²quin¹² Jesús jmi²dsí² quiah¹² Diú¹³ ca¹ŋáh¹dsa juu¹² ja³tén¹² Galilea. Jøng² ca¹tsø² ca¹jan¹ jǿg³ quiah¹²dsa ca¹lah¹tan¹³ ja³tioh¹³ juøi² cøg¹² ja³guǿ¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jue¹² dsa² ca¹mi¹juanh¹² Jesús ja³ca¹ŋi³he¹²dsa jǿg³ guøh¹² lah¹cøng² lah¹cøng² juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jøng² ca¹dsiánh¹dsa jøa³juøi² Nazaret, juøi² ja³ca¹ŋi¹juanh¹²dsa. Jøng² jmai³ sa³¹ ca¹ŋó¹dsa guøh¹², ju³lah lǿa¹² mai³¹ quiah¹²dsa. Jøng² ca¹nung²dsa hi² hniu¹dsa høa¹dsa si² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jøng² mi³ca¹cuø¹ dsa² neng¹² ni³ jǿg³ quiah¹² guøh¹² si² ca¹jmo¹ hlai³ Isaías, ca¹jan¹ Jesús si². Ca¹dsóh²dsa ja³rø²juúh² jǿg³ la²: ");
INSERT INTO cpaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Quin³jni jmi²dsí² quiah¹² Juu¹³ jniang³. Di³ ca¹hei¹dsa jní² mi³jøng² hǿ¹³jni jǿg³ dsio¹ quiah¹² dsa² ti²ŋié². Ca¹tsei¹dsa hi² jmo¹³jni jǿg³ hi² liúg² dsa² tiogh³ hni¹ŋí³, jǿg³ hi² jniuh¹ calah dsa² teg³, jǿg³ hi² liúg² dsa² chian² jmø³uai¹², hi² jmógh² dsa², ");
INSERT INTO cpaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","hi² jmo¹³jni jǿg³ quiah¹² jmai³ ja³mi¹hag¹³ Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jøng² mi³ca¹høa¹ Jesús jǿg³ jøng², ca¹cágh¹dsa si². Ca¹jáinh¹dsa calah. Jøng² ca¹gú²dsa, ti³jǿi² ca¹lah¹já¹ dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jøng² ca¹he¹dsa jǿg³. Ca¹juúh²dsa: ―Na¹ jín³ ma²ca¹lø¹ti¹ jǿg³ quiah¹² Diú¹³ ma²na²høa¹jni jøa³ ja³tiogh³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jøng² ca¹cuø¹ ca¹lah¹já¹ dsa² jǿg³ dsio¹ quiah¹² Jesús. Dsogh¹² dsǿa¹²dsa jǿg³ rø² ma²he¹²dsa. Jøng² ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―¿Tsa³lán¹² dsa² lang¹² ja³ŋiúh³ José? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² tiog¹³ báh³ juúh³ hniah¹² ju³lah juúh²dsa jmai³ juúh²dsa: “Hí³ jmóh³ hning² hŋiah¹ chi²júh² dsøg¹² lanh¹²hning tø²mǿa¹².” Hnøngh² hniah¹² hi² jmo¹³jni ja³la² juøi² go²jni ju³lah lǿa¹² hi² ma²ca¹nengh² hniah¹² hi² ca¹jmo¹jni jøa³juøi² Capernaum. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Lah¹dsóh² juǿi²jni hniah¹². Tsa¹lǿih² jmai³ li¹tih¹ dsa² go²dsa jǿg³ juúh² dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lah¹té¹² jǿg³. Jue¹² dsa² hnǿi² mi³chian² ja³tén¹² juøi² israel jmai³ mi³chian² hlai³ Elías, jmai³ ca¹løa¹ hag³cón³ huø¹, mi³tsa¹ma¹ca¹táh² jmǿa¹² hnøa¹² ŋi² jmai³ tón² ca²dsieg³ ŋi². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Cónh¹jøng² ha¹chi² ca¹tsen¹ Diú¹³ hlai³ Elías juu¹² ja³mi³tiogh³ hio¹³ héi². Ca¹tsei¹ Diú¹³ juu¹² jøa³juøi² Sarepta, juøi² tén¹² Sidón, ja³quiah¹³ hio¹³ hnǿi² chian² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jø¹² bíh³ lah¹jøng², mi³chian² jue¹² dsa² dsoh³ ja³tén¹² juøi² israel, dsa² lán¹² hmih¹² tsa¹jŋi¹², jmai³ mi³chian² hlai³ Eliseo. Cónh¹jøng² ha¹chian² dsa² héi² ca¹hlú² hmih¹² quiah¹². Jan² Naamán ca¹hlú² dsag³ hmih¹², dsa² chian² huø¹ Siria ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jøng² ca¹lø¹hné¹ hlaih¹³ ca¹lah¹já¹ dsa² tiogh³ guøh¹², mi³ca¹nǿng²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ca¹túgh²dsa. Ca¹ŋi³jian¹dsa Jesús juu¹² chiuh³ juøi². Jøng² ca¹tai¹dsa juu¹² ni³ cónh¹² ja³neng¹² juøi². Mi³jøng² mi³tiáng²dsa tsøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cónh¹jøng² ca¹ŋë́² Jesús jøa³ ja³tiogh³ dsa² jue¹². Ca¹ŋó¹dsa calah ja³siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ca¹ŋó¹dsa juu¹² jøa³juøi² Capernaum, juøi² tén¹² Galilea. Ja³jøng² ca¹he¹dsa jǿg³ jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dsogh¹² dsǿa¹² dsa² chian² ja³jøng² jǿg³ he¹²dsa. Di³ he¹²dsa ju³lah jan² dsa² lah¹dsóh² ŋi¹² ha²lah lǿa¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jøng² mi³hiúg³ jan² dsa² ŋioh¹² guøh¹², dsa² quin¹² jmi²dsí² hlaih¹³. Ca¹hløah¹ dsa² héi² tí², ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Ai! ¿He² jǿg³ ca¹të́h²hing quián² jnieh³, Jesús, dsa² chian² Nazaret? ¿Ma³guøngh¹hning hi² mi³dsiagh¹³hning jnieh³? Cué¹² báh³ jní² hning². Dsa² han¹³ quián¹² Diú¹³ báh³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jøng² ca¹jé² Jesús jmi²dsí² hlaih¹³. Ca¹juúh²dsa: ―¡Cagh³ hagh³! ¡Jú¹² quiah¹²dsa! ―ca¹juúh²dsa. Jøng² mi³ca¹jmo¹ jmi²dsí² hlaih¹³ hi² ca¹canh¹ dsa² ŋioh¹² héi² huø¹ jøa³ ja³tiogh³ dsa² jue¹², ca¹u¹hái¹ jmi²dsí² hlaih¹³, hi² ha¹chi² ca¹jenh¹ dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jøng² ca¹ŋi¹dsógh¹ dsǿa¹² ca¹lah¹já¹ dsa² tiogh³. Ca¹dsii¹dsa jǿg³ guiog³dsa. Ca¹juúh²dsa: ―¿He² bíh³ jǿg³? Jmo¹² dsa² lang¹² héh¹ ju³lah jan² dsa² lah¹dsóh² chi² bí². Tsaih¹²dsa jmi²dsí² hlaih¹³, ta³lah¹ca¹huanh¹² jmi²dsí² quiah¹² dsa² quin¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jøng² ca¹tsø² ca¹jan¹ jǿg³ quiah¹² Jesús ta³cøng² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jøng² ca¹nung² Jesús. Ca¹u¹hái¹dsa guøh¹². Ca¹ŋó¹dsa ja³quiah¹³ Simón. Ma²dsoh³ mø¹chiég³ Simón. Dsé² hlaih¹³dsa. Hi² jøng² ca¹tsáih¹dsa Jesús hi² jmo¹dsa hí³ dsa² dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jøng² mi³ma²tsenh¹² Jesús cøg¹² ja³ron¹² dsa² dsoh³, ca¹jé²dsa hi² jmo¹² hi² dsé² hio¹³. Jøng² ca¹jŋi¹ quiah¹²dsa. Dsø¹juu¹² jøng² ca¹nung² hio¹³. Ca¹mi¹ti¹ hio¹³ ni³ Jesús quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jøng² mi³ma²tǿ² ja³tø²dsé³ hieg², ca¹ŋi¹lé² ca¹lah¹já¹ dsa² mi³ti³dsoh¹ dsa² quián¹², dsa² lán¹² hliú² ni³ dsag³. Ca¹ŋi¹jian¹dsa dsa² dsoh³ juu¹² ja³guǿ¹³ Jesús. Jøng² ca¹quieg² Jesús gug² ni³ quiah¹² ca¹lah¹já¹ dsa² dsoh³. Ca¹mi¹hlég²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jø¹² bíh³ ca¹huø¹dsa jmi²dsí² hlaih¹³ quiah¹² dsa² jue¹² calah. Tí² ca¹juúh² jmi²dsí²: ―Lanh¹²hning jong¹² Diú¹³ ―ca¹juúh²dsa. Jøng² ca¹jé² Jesús jmi²dsí² hlaih¹³. Tsa¹ma¹ca¹cuø¹dsa jǿg³ hi² hløah¹dsa. Di³ ma²ŋi¹² jmi²dsí² hi² lán¹²dsa Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mi³ca¹jni¹, ca¹ŋó¹ Jesús cøng² ja³cu²hŋiah¹². Jøng² ca¹hnah¹² dsa² jue¹² Jesús ca¹lah¹ca¹dsanh¹²dsa. Tsa¹hniu¹ dsa² jue¹² hi² dság¹ Jesús ja³siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² jue¹²: ―Hniuh¹² hi² ŋi³hǿa¹²jni jǿg³ dsio¹ ja³tioh¹³ juøi² siíh² calah, jǿg³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹. Di³ huu¹³ jøng² ca¹tsei¹ Diú¹³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hi² jøng² ca¹ŋi¹he¹² Jesús jǿg³ guøh¹² quiah¹² ja³tén¹² Judea. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cøng² jmai³ ma²tsenh¹² Jesús chiuh³ dsieg¹² Gennesaret. Jue¹² dsa² tiogh³ quianh¹³dsa ca¹lah¹ca¹qui² ca¹güeh¹dsa, hi² hniu¹dsa nang¹dsa cu²rø² jǿg³ he¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jøng² ca¹jái¹ Jesús hei¹² ton¹ barco chiuh³ jmøi². Dsa² quiah¹² barco tiogh³ cøg¹², ranh¹²dsa néng³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jøng² ca¹hí¹ Jesús cøng² barco jøng², barco quiah¹² Simón. Ca¹mǿh¹dsa Simón hi² hai¹dsa barco uǿin² hi³méh¹ cónh¹ ja³neng¹² huø¹. Jøng² mi³ca¹gú²dsa ni³ barco, ca¹heh¹dsa dsa² jue¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ni³ jøng², mi³ma²na²he¹dsa jǿg³, ca¹tsáih¹dsa Simón: ―Ma¹dsǿg³ cøng² ja³jøh² jmøi². Mi³jøng² léh²hning jáh² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jøng² ca¹juúh² Simón: ―Tøa¹², ma²ca¹jmó³ jnieh³ ta³ ta³cøng² huu², Jøng² jin³ hein² ha¹chian² jáh² ma²ca¹lǿh¹ jnieh³. Cónh¹jøng² ton³jni néng³ jmøi² chi²júh² ha²lah juúh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jøng² mi³ma²na²tí²dsa néng³ jmøi², jue¹² hlaih¹³ jáh² ca¹ŋi¹togh¹² néng³ ca¹lah¹ma¹li¹guií¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jøng² ca¹tǿh² dsa² quiah¹² barco dsa² quianh³dsa tiogh³ barco cøng², hi¹ mi¹hag¹²dsa. Ca¹ŋi¹lé² dsa² hei² calah. Jøng² ca¹cangh¹² ca¹lah¹ta³ton¹ barco quianh¹³ jáh² ma²na²lǿh²dsa, ca¹lah¹ma²hniu¹ dsa¹honh¹ barco niúh¹ jmǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jøng² mi³ca¹jái¹ Simón, ca¹chi¹jné¹dsa ni³ Jesús. Ca¹juúh²dsa: ―¡Tiog¹² jní² Juu¹³ jniang³! Di³ hi² hiug¹² hlanh³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ca¹can¹ hlaih¹³ Simón gøg² quianh¹³ dsa² quianh³dsa mi³ca¹jë́²dsa jue¹² hlaih¹³ jáh² ma²na²lǿh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jø¹² bíh³ lah¹jøng² Jacobo quianh¹³ Juan, ja³ŋiúh³ Zebedeo, dsa² ti³jmo¹² ta³ quianh¹³ Simón, goh¹² hlaih¹³dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Simón: ―Tsa¹jmo² ganh¹. Di³ na¹ ta¹lah¹ni³ ja³já¹³ jmóh³hning ta³ siíh², ta³ hi² léh²hning dsa², dsa² li¹quianh¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hi² jøng² mi³ca¹ŋi¹cang¹dsa barco juu¹² chiuh³ dsieg¹², ca¹tiú² dsa² héi² ca¹lah¹jǿ¹. Ca¹ŋi¹lé²dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jmai³ ja³mi³hiúg³ Jesús cøng² juøi², ca¹dsiég¹ jan² dsa² dsoh³, dsa² lán¹² hmih¹² tsa¹jŋi¹². Ca¹chi¹jné¹dsa, chi³ŋiu¹³ ni³dsa huø¹, mi³ca¹jë́²dsa Jesús. Ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Guiuh¹³, tiáh¹ báh³ hning² jmóh³hning hí³ quieg¹ chi²júh² hiug² hoh¹²hning quianh¹³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","―Hiug² báh³ dsøa¹ ―ca¹juúh² Jesús. Jøng² ca¹quieg²dsa gug²dsa ni³ quiah¹² dsa² dsoh³. ―¡Ju³huá² quiánh²hning¹! ―ca¹juúh²dsa. Dsø¹juu¹² jøng² ca¹huá² hmih¹². Ha¹chi² ma¹lǿa¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jøng² quianh¹³ hi² tiog¹³ ca¹juúh² Jesús hi² tsa¹tsáih¹ dsa² mi³dsoh³ jin³ hein² ha²lah ca¹løa¹ quiah¹²dsa. ―Cónh¹ gu³hiah¹³ jmi²dsa² hning². Gu³cuøh³hning ju³lah lǿa¹² lei¹³ quiah¹² hlai³ Moisés. Mi³jøng² li¹ŋi¹² dsa² juøi² ha¹chi² dsag³ ma¹lanh¹²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Cónh¹jøng² hiug¹² jín³ ca¹tsø² ca¹jan¹ jǿg³ quiah¹² Jesús. Jue¹² hlaih¹³ dsa² ca¹túgh² quianh¹³ Jesús, ju³lah dsa² hniu¹ nang¹ jǿg³ he¹²dsa, quianh¹³ dsa² hniu¹ hliú² dsag³ ni³lán¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hi² jøng² hliú² rón² ca¹ŋó¹ Jesús juu¹² ja³cu³hŋiah¹², juu¹² ja³ca¹hlanh¹dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jøng² lah¹la² ca¹løa¹ cøng² jmai³ ja³ma²he¹² Jesús jǿg³. Jue¹² dsa² fariseo tiogh³, quianh¹³ tøa¹², dsa² he¹² lei¹³ quiah¹² Diú¹³, dsa² ma²ca¹ja¹lé² hliú² juøi² ja³tén¹² Galilea quianh¹³ Judea, quianh¹³ dsa² chian² jøa³juøi² Jerusalén. Ma²cuø¹² Juu¹³ jniang³ bí² hi² mi²hliú² Jesús dsa² dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jøng² ca¹dsi¹lé² ca²dsiog³ dsa² ŋioh¹², dsa² jian¹² jan² dsa² tsa¹li¹ŋøa¹. Jiag¹²dsa juu¹² guiuh¹³, juu¹² ni³ jein³. Hniu¹dsa dsa¹quiag²dsa ja³guǿ¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jøng² tsa¹ca¹dsóh²dsa juu¹² ja³dsa¹togh¹dsa dsi²néi². Di³ jue¹² dsa² ma²tiogh³. Hi² jøng² ca¹uǿi²dsa guiuh¹³ hniú¹². Ca¹siúg²dsa dsa² dsoh³ dsi²néi² mi³ma²na²jŋíh²dsa mih² guiuh¹³ hniú¹². Ca¹siég²dsa ni³ jein³ ca¹tǿ² ja³juǿ¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jøng² mi³ca¹jái¹ Jesús hi² lah¹dsóh² hé² dsa² héi² jǿg³ quiah¹²dsa, ca¹juúh²dsa, ca¹tsáih¹dsa dsa² dsoh³: ―Dsa² ŋioh¹², ma²ca¹dsan¹ dsag³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jøng² ca¹hǿ² dsǿa¹² tøa¹² quianh¹³ dsa² fariseo héi² mi³ca¹nǿng²dsa jǿg³ jøng²: “Jǿg³ hlaih¹³ báh³ jøng²,” lë́²dsa. “Jan² Diú¹³ báh³ dsa² tiúh¹ hén² dsag³,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jøng² lø²lih¹³ Jesús ha²lah lë́² dsa² héi². Jøng² ca¹juúh²dsa: ―¿He² løa¹ høa¹² hoh¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Naih¹² hi² tsa¹ué² juǿi³jni dsa² dsoh³? “Ma²ca¹dsan¹ dsag³ quiánh²hning.” Ho¹ ju³ juǿi³jni dsa²: “¡Nung²! ¡Ŋøa³!” ");
INSERT INTO cpaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cónh¹jøng² lah¹la² juǿi³jni dsa² dsoh³, mi³jøng² li¹ŋih³ hniah¹² hi² tiág¹²jni hén¹³jni dsag³ ni³ guøh³ ni³ huø¹ la², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² dsoh³: ―Hning² juǿi²jni. ¡Nung²! ¡Quieng² jein³ quiánh²hning! ¡Guønh² ja³quiánh³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dsø¹juu¹² jøng² ca¹nung² dsa² ŋioh¹² héi² ja³ti³jái¹² dsa² jue¹². Ca¹cáng¹dsa hi² jøng² ja³mi³ron¹²dsa. Jøng² ca¹ŋáh¹dsa hi² ma²mi²juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dsogh¹² hlaih¹³ dsǿa¹² ca¹lah¹já¹ dsa² ti³jái¹². Ca¹mi¹juanh¹²dsa Diú¹³. Hiug¹² gøg² ca¹can¹dsa. ―¡He³ báh³ hi² siíh² ma²na²ne¹³ jniang³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ni³ jøng² ca¹u¹hái¹ Jesús ja³jøng². Ca¹jë́²dsa jan² dsa² lán¹² ta³ cagh¹² cog³ juøi², dsa² tsen² Leví. Guǿ¹² dsa² héi² hniú¹² ja³cagh¹²dsa cog³. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Ma¹dsǿg³ quianh¹³ jní²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jøng² ca¹tiú¹ Leví ca¹lah¹jǿ¹. Ca¹ŋó¹dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ni³ jøng² ca¹jmo¹ Leví cøng² jmai³ juøh¹² ja³quiah¹³dsa ni³ quiah¹² Jesús. Jue¹² dsa² lán¹² ta³ cagh¹² cog³ juøi² quianh¹³ dsa² siáh² calah ma²tiogh³ mesa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jøng² ca¹jí² dsa² fariseo quianh¹³ tøa¹² quián¹²dsa, ca¹jé²dsa dsa² quianh³ Jesús. Ca¹juúh²dsa: ―¿He² løa¹ cǿh³ hǿgh³ hniah¹² quianh¹³ dsa² ti³re² dsag³, ju³lah dsa² cagh¹² cog³ jnung²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jøng² ca¹juúh² Jesús: ―Ha¹chian² tø²mǿa¹² hnioh¹² quián¹² dsa² dsiog¹. Dsa² dsoh³ báh³ hnioh¹² tø²mǿa¹² quiáh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Huu¹³ jøng² báh³ ca¹guio¹jni, hi² tǿa¹³jni dsa² re² dsag³, a¹jáng¹ ju³ dsa² dsiog¹. Di³ hno¹jni hi² jéinh¹ dsǿa¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa Jesús: ―Hliú² rón² ma²ca¹mi¹ha¹² dsa² quianh³ Juan, hi² tsa¹gøah¹²dsa cu²hna² ta¹lah¹hlanh¹²dsa Diú¹³. Jø¹² bíh³ lah¹jøng² jmo¹² dsa² quianh³ dsa² fariseo. Cónh¹jøng² cøng² hi² cøh² hǿnh² báh³ dsa² quianh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Lǿa¹² ju³lah lǿa¹² quiah¹² dsa² dsa²lé² jmai³ quiah¹² dsa² ca¹jenh² gug². Tsa¹lé² mi¹han¹²dsa, hi² tsa¹gøah¹²dsa, ta³lah¹guǿ¹² dsa² ŋioh¹², dsa² ca¹jenh² gug². ");
INSERT INTO cpaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jøng² jií¹ báh³ jmai³ ja³jŋiangh² dsa² hiag¹³ jní². Jmai³ jøng² báh³ mi¹ha¹² dsa² quianh³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jøng² ca¹dsii¹ Jesús jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Ha¹chian² dsa² tiu¹dsa tsǿnh³dsa hmë́², mi³jøng² tiáng¹dsa jneh³ hmøah¹² hmë́² tsǿnh³dsa ma²hǿg³. Di³ dsa¹hén² báh³ tsǿnh³dsa hmë́² chi²júh² jmo¹dsa lah¹jøng². Jø¹² bíh³ tsa¹cuan¹² hmøah¹² hmë́² quianh¹³ hmøah¹² ma²hǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jø¹² bíh³ lah¹jøng², ha¹chian² dsa² tieh¹ vino hmë́² løg² ma²hǿg³. Di³ nih¹² løg² ju³ná³ ca¹jmo¹dsa lah¹jøng². Jøng² téng¹ jmøi². Jø¹² bíh³ dsa¹hén² løg². ");
INSERT INTO cpaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Løg² hmë́² báh³ tieh¹²dsa vino hmë́². ");
INSERT INTO cpaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ha¹chian² dsa² hniu¹ hǿnh² vino hmë́² ju³ná³ ma²ca¹hǿnh²dsa vino ma²hóg¹². “Vino hóg¹² báh³ dsio¹,” juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jøng² cøng² jmai³ sa³¹ ma²ŋøa¹² Jesús juu¹² jøa³cuøi² hi³ŋíh¹. Dsa² quianh³dsa ca¹cøn¹ mih² ja³dsa²lé²dsa jøng². Ca¹jŋíh²dsa tsǿ³ quianh¹³ gug²dsa. Jøng² ca¹cøgh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ni³ jøng² ca¹juúh² ca²dsiog³ dsa² fariseo: ―¿He² løa¹ jmoh² hniah¹² hi² tsa¹lǿa¹² lei¹³ jmó³ jniang³ jmai³ sa³¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿Tsa³ma²ca¹híh² hniah¹² si² ha²lah ca¹jmo¹ hlai³ David jmai³ ca¹løa¹ lø¹i³cónh¹²dsa quianh¹³ dsa² quianh³dsa? ");
INSERT INTO cpaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Di³ ca¹hí¹dsa dsi²néi² guøh¹². Ca¹gǿh¹dsa hi³ŋíh¹ ma²ca¹dsii¹ jmi²dsa² ni³ Diú¹³, hi³ŋíh¹ hi² ma²lǿa¹² lei¹³ hi² gǿh¹ jmáh¹lah jmi²dsa². Ca¹lah¹ca¹tǿ² dsa² quianh³dsa ca¹cuúh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jøng² ca¹juúh² calah Jesús: ―Jní² báh³ dsa² jmo¹² héh¹ he² hi² lé² jmó³ jniang³ jmai³ sa³¹, jní² dsa² ma²lán¹² dsa² jmøi¹quǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lah¹la² ca¹løa¹ calah cøng² jmai³ sa³¹ siíh². Ca¹hí¹ Jesús calah dsi²néi² guøh¹². Ca¹he¹dsa jǿg³. Jøng² hiúg³ jan² dsa² ŋioh¹² ja³jøng², dsa² dsi¹³ huh² cøng² gug², gug²dsa dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jøng² ma²ti³jái¹² tøa¹² he¹² lei¹³ quianh¹³ dsa² fariseo. Jái¹²dsa chi²júh² jmo¹ Jesús hí³ dsa² héi² jmai³ sa³¹. Hnangh¹²dsa he² dsag³ lé² cuúh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Cónh¹jøng² ma²ŋi¹² Jesús ha²lah dsø²jiag¹² dsǿa¹² dsa² hiag¹³ héi². Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² dsi¹³ huh² gug²: ―¡Ŋi²! ¡Nung² dsi²jo² la²! Ca¹nung² dsa² héi² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² hiag¹³: ―Jǿg³ la² ŋai³jni hniah¹²: ¿Naih¹² hi² ma²lǿa¹² lei¹³ jmó³ jniang³ jmai³ sa³¹? ¿Hi³ dsio¹, ho¹ ju³ hi² hlaih¹³? ¿Hi³ liúg² jniang³ jmi²dsí², ho¹ ju³ hi² hén³ jniang³? ");
INSERT INTO cpaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jøng² mi³ma²na²jái¹ Jesús ni³ dsa² tiogh³ lah¹jin² lah¹lǿih² ja³guǿ¹³dsa, ca¹juúh²dsa: ―¡Neih³ gugh²! ―ca¹tsáih¹dsa dsa² ŋioh¹² héi². Jøng² ca¹néih¹ dsa² ŋioh¹² gug². Ta³lah¹ca¹lái¹ dsio¹ gug²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jøng² ca¹lø¹hné¹ hlaih¹³ dsa² hiag¹³. Ca¹dsii¹dsa jǿg³ guiog³dsa he² hi² lé² jmo¹dsa quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jmai³ jøng² ca¹ŋó¹ Jesús máh² ja³ca¹ŋi¹hlanh¹³dsa Diú¹³ ta³cøng¹ huu². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mi³ca¹jni¹ jøng², ca¹tǿh²dsa dsa² quianh³dsa. Jøng² ca¹hia¹dsa guia¹tón² dsa² héi², dsa² ca¹quian¹dsa tsih² dsa² høh³ quián¹²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón, dsa² ca¹quian¹dsa Pedro Andrés, roh¹³ Simón Jacobo Juan Felipe Bartolomé ");
INSERT INTO cpaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo Tomás Jacobo, ja³ŋiúh³ Alfeo Simón, dsa² cananista ");
INSERT INTO cpaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, ja³ŋiúh³ Jacobo Judas, dsa² ca¹lán¹ dsa² ca¹hnë¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jøng² mi³ca¹siog² Jesús máh² quianh¹³ dsa² quianh³dsa, ca¹jŋi¹dsa cøng² ja³møi² huø¹. Quianh¹³dsa jue¹² dsa² quianh³dsa ca¹lah¹ma¹quianh¹³ jue¹² dsa² chian² ca¹lah¹tan¹³ ja³tén¹² Judea quianh¹³ jøa³juøi² Jerusalén, quianh¹³ dsa² chian² chiuh³ jmø³ŋih¹³ ja³tén¹² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón. Hniu¹ dsa² jue¹² nang¹ jǿg³ he¹² Jesús. Jø¹² bíh³ hniu¹dsa hliú²dsa dsag³ ti³lán¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jøng² ca¹løa¹ hí³ dsa² chian² jmø³uai¹² hi² jmo¹² jmi²dsí² quiah¹² dsa² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ca¹lah¹já¹ báh³ dsa² hniu¹ quiég¹ gug² ni³ quiah¹² Jesús. Di³ ca¹hlú² dsa² dsoh³ quianh¹³ bí² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jøng² ca¹jë́² Jesús dsa² quianh³dsa. Ca¹juúh²dsa: ―Hioh¹² jính² hniah¹² dsa² ti²ŋiéh². Di³ ca¹të́h² hniah¹² gu³noh¹² hniah¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Hioh¹² jính² hniah¹² dsa² lǿ² lø¹i³cuanh¹. Di³ li¹tanh¹³ báh³ hniah¹². ’Hioh¹² jính² hniah¹² dsa² høgh². Di³ ŋaih¹³ báh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Hioh¹² jính² hniah¹² jmai³ chian² dsa² hiag¹³, jmai³ tiáng²dsa, jmai³ hei¹²dsa jǿg³ hlaih¹³ ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quian¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jmai³ jøng² túgh³ hniah¹² hioh¹² jính² hniah¹². Qui³chiogh¹³ qui³cǿgh³ hniah¹² hi² jmóh³ hniah¹² hioh¹². Di³ li¹hmah¹³ ma¹dsio¹² quiánh² hniah¹² ŋi¹juǿi¹. Jø¹² bíh³ lah¹jøng² ca¹jmóh² dsa² hóg¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Juǿih² hniah¹² dsa² chi² cog³. Di³ tsø³jue¹³ hioh¹² jính² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Juǿih² hniah¹² dsa² ma²ca¹lø¹tanh¹³. Di³ lé² lø¹i³cuanh¹ hniah¹². ’Juǿih² hniah¹² dsa² ma²ŋaih¹². Di³ jií¹ jmai³ ja³hǿgh³ hniah¹² hi² hlaih¹³ jính² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Juǿih² hniah¹² ja³chi² jmáh¹lah jǿg³ dsio¹ quiánh² hniah¹². Di³ lah¹jøng² ca¹ŋi¹ŋë́² calah dsa² ca¹jmo¹ tø³júg³ ma²lǿih², hi² ca¹jmo¹dsa hi² mi³hǿ²dsa jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Jøng² lah¹la² juǿi³jni hniah¹² dsa² nøngh² jǿg³ quieg¹jni: Mi³hnóh¹ hniah¹² dsa² hiag¹³. Hi² dsio¹ jmóh³ hniah¹² ja³cog²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jǿg³ dsio¹ tséih³ hniah¹² dsa² chi²hia¹² hniah¹² jǿg³ hlaih¹³. Hlanh¹³ hniah¹² Diú¹³ ni³ huu¹³ quiah¹² dsa² jmóh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ju³ná³ ca¹jnáng¹ jan² dsa² neih³hning ca²jag¹³, jøng² dsio¹ cuúh³ hniah¹² ca²jag¹³ hi² jnáng¹dsa calah. Ju³ná³ ca¹cang¹ jan² dsa² hmøah¹² dsiég² quiánh² hniah¹², jøng² cuøh¹³ hniah¹² dsa² calah hmøah¹² hiúgh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cuúh³ hniah¹² quiah¹² lǿa¹² ju³ hein² dsa² ca¹møa¹. Jøng² ha¹chi³ ma¹máih³ hniah¹² quiah¹² dsa² ma²ca¹cang¹ hi² chi² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lah¹jøng² jmóh³ hniah¹² ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah mi³hnøngh² hniah¹² hi² jmo¹dsa ja³cogh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ha¹chi² quien¹² ja³cogh² hniah¹² ju³ná² hnóh¹ hniah¹² jmáh¹lah dsa² hnio¹ hniah¹². Di³ ca¹tǿ² dsa² jmo¹² hi² hlaih¹³ báh³ ma²hnio¹ dsa² hniang¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jø¹² bíh³ ha¹chi² ta³ li¹jmo¹ ja³cogh² hniah¹² ju³ná jmóh³ hniah¹² hi² dsio¹ jmáh¹lah ja³cog² dsa² jmo¹² hi² dsio¹ quiánh² hniah¹². Di³ ca¹tǿ² dsa² lø³hiug¹² jmo¹² lah¹jøng² ja³cog² dsa² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A¹jáng¹ hi² dsiogh¹ hniah¹² ju³ná³ ca¹cuøh³ hniah¹² hei¹² hmah³ quiah¹² dsa² lë́h² hniah¹² hi² jáinh¹dsa calah. Ca¹tǿ² guiog¹³ dsa² lø³hiug¹² jmo¹² lah¹jøng² ja³cog² dsa² jian¹²dsa. Mi³jøng² hiéih¹dsa calah ca¹lah¹jǿ¹ hi² ma²ca¹cuø¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jøng² hniah¹², mi³hnoh¹³ hniah¹² dsa² hiag¹³. Jmóh³ hniah¹² hi² dsio¹. Hǿih³ hniah¹² hmah³ ja³tsa¹lë́h² hniah¹² jáinh¹dsa calah. Jøng² mi³hmah¹³ hniah¹² ma¹dsio¹². Lénh² hniah¹² jong¹² Diú¹³, dsa² hiug¹² juanh¹². Di³ hŋiah¹² dsa² héi² báh³ huø³ dsǿa¹² ja³cog² dsa² tsa¹juanh¹² dsǿa¹², dsa² lø³hiug¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jmóh³ hniah¹² huø³ hoh¹² hniah¹² ju³lah lán¹² Jmi² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Tsa¹cuøh¹³ hniah¹² dsa² dsag³. Mi³jøng² tsa¹cuúh¹ Diú¹³ hniah¹² dsag³. Tsa¹jmóh³ hniah¹² tø¹canh¹³ dsa². Mi³jøng² tsa¹tø¹canh¹³ hniah¹². Henh¹³ hniah¹² dsag³ quiah¹² dsa². Mi³jøng² dsa¹hén² dsag² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","¡Cuø³! Mi³jøng² lǿa¹² jín³ hi² ŋieh¹ hniah¹², quianh¹³ héh¹ cu²rø², ju³lah cøng² hi² rø²hmoh¹² tí², hi² rø²hianh¹² cu²rø², ca¹lah¹tsa¹ma¹heih¹², hi² dsii¹ Diú¹³ gugh² hniah¹². Di³ quianh¹³ héh¹ hi² cuuh² hniah¹² jøng², héh¹ jøng² báh³ dsii¹ Diú¹³ gugh² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jøng² ca¹dsii¹ Jesús jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ―Tsa¹lé² he¹ jan² dsa² teg³ juu¹² ja³ŋøa¹ jan² dsa² teg³ jian¹²dsa, ho¹ jøng² ca¹siúgh²dsa ta³og¹dsa niúh¹ tøg². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ha¹chi² lán¹² dsa² mi²tan¹² jǿg³ dsa² juanh¹² cónh¹ jín³ tøa¹² quián¹²dsa. Cónh¹jøng² lén² báh³ dsa² ju³lah lán¹² tøa¹² quián¹²dsa na³ma²ca¹hian¹² jǿg³ ca¹mi¹tan¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Ha²lah dsio¹ jáih² hniah¹² ca²jneh³ qui¹² hiu³ mø³ni³ rúh² hniah¹². Jøng² tsa¹leh¹³ hniah¹² hi² tioh¹³ hma² pa³ mø³neih³ hniah¹² guiogh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ha²lah dsio¹ tí² hoh¹² hniah¹² juaih¹² hniah¹² rúh² hniah¹² hi² jŋih¹³ hniah¹² jneh³ qui¹² hiu³ mø³ni³dsa. Jøng² tsa¹jáih² hniah¹² guiogh¹³ hma² pa³ tioh¹³ mø³neih³ hniah¹². Dsa² tø¹cah¹ tø¹jen¹² báh³ hniah¹². Lah¹ni³ jŋih¹³ hniah¹² hma² pa³ tioh¹³ mø³neih¹ hniah¹². Jøng² ma²lé² jáih³ hniah¹² cu²rø² hi² jŋih¹³ hniah¹² ca²jneh³ qui¹² hiu³ mø³ni³ rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ha¹chi² cuø¹ hma² dsio¹ mǿi² hlaih¹³. Jin³ ha¹chi² cuø¹ hma² hlaih¹³ mǿi² dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Quianh¹³ mǿi² quiah¹² báh³ hma², li¹léi¹³ ha²lah lǿa¹² lah¹cøng² lah¹cøng² hma². Ha¹chi² hai¹ møi¹higo chiúh³ tang¹². Jin³ ha¹chi² hai¹ møi¹gu²jøah¹³ chi³uǿin¹ juh². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hi² dsio¹ báh³ dsø²jiag¹² dsǿa¹² dsa² dsiog¹. Hi² jøng² jmo¹²dsa hi² dsio¹. Jøng² hi² hlaih¹³ báh³ dsø²jiag¹² dsǿa¹² dsa² jmo¹² hi² hlaih¹³. Di³ jǿg³ hlaih¹³ dsø²jiag¹² dsǿa¹²dsa jøng² báh³ huøh¹² hag³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿He² løa¹ juaih¹² hniah¹² jní² Juu¹³ jniang³, jøng² tsa¹jmóh³ hniah¹² ju³lah juǿi²jni hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lah¹la² lán¹² ca¹lah¹já¹ dsa² li¹quianh¹³jni, dsa² nang¹², dsa² mi²ti¹ jǿg³ quieg¹: ");
INSERT INTO cpaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lán¹²dsa ju³lah lán¹² jan² dsa² ca¹jmo¹ hniú¹². Hieg³ ca¹guieg¹dsa. Ca¹tsih¹dsa hniú¹² ni³ cang³. Jøng² mi³ca¹juøh¹² jmøi², tí² ca¹chi¹ŋiú² jmøi² hniú¹². Cónh¹jøng² ha¹chi² ca¹løa¹. Di³ tí² ma²tsih¹² hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jøng² lán¹² dsa² tsa¹mi¹ti¹ jǿg³ ca¹nǿng²dsa ju³lah lán¹² dsa² tsa¹ca¹tsih¹ tí² hniú¹² quiah¹²dsa. Jøng² cu¹ŋieih¹² ca¹gug¹ hniú¹² mi³ca¹chi¹ŋiú² jmøi². Ma¹dsio¹² ca¹hen¹ hniú¹² quiah¹² dsa² héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mi³ma²ca¹heh¹ Jesús dsa² jue¹² jǿg³, ca¹ŋó¹dsa juu¹² jøa³juøi² Capernaum. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ja³jøng² mi³guǿ¹³ jan² juu¹³ hlég², dsa² chian² dsa² ŋioh¹² jmo¹² ta³ quiah¹². Hiug¹² dsoh³ dsa² ŋioh¹². Ja¹lái¹ hiu³ jmi²dsi² quiah²dsa. Jøng² hniang¹ juu¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hi² jøng² ca¹tsen¹ juu¹³dsa ca²dsiog³ dsa² canh¹³ quián¹² dsa² judío, mi³ca¹nǿng²dsa jǿg³ quiah¹² Jesús. Ca¹tsei¹dsa juu¹² ja³ca¹ŋi¹téh²dsa Jesús, hi² jmo¹ Jesús hí³ dsa² dsoh³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jøng² mi³ca¹dsi¹lé² dsa² canh¹³ héi² ja³tsenh¹³ Jesús, quianh¹³ hi² tiog¹³ ca¹møa¹dsa. Ca¹juúh²dsa: ―Dsio¹ gu³jmoh³hning hí³ dsa² dsoh³ quián¹² juu¹³ hlég². Di³ dsa² dsiog¹ báh³ juu¹³ hlég² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tøa¹² dsǿa¹²dsa juøi² go² jniang³. Dsa² héi² ca¹cuø¹ cog³ ja³ma²ca¹jmó³ jnieh³ guøh¹² hmë́² quián² jnieh³ ―ca¹juúh² dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jøng² ca¹ŋi¹lé² Jesús quianh¹³ dsa² héi². Jøng² mi³ja¹quien¹³ dsi³lé²dsa ja³guǿ¹³ juu¹³ hlég², ca¹tsen¹ juu¹³ hlég² ca²dsiog³ dsa² jenh² quianh¹³dsa. Ca¹jén² dsa² héi² Jesús dsi²juu¹². Ca¹juúh²dsa: ―Juanh¹² hoh¹² hning² guiuh¹³. Tsa¹hniu¹ juu¹³ hlég² cuúh¹dsa hning² ju²méh³ dsøa¹². Ha¹chi² lë́²dsa tén¹²dsa hi² góh³hning dsi²néi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hi² jøng² tsa¹na²guøn¹dsa hŋiah¹²dsa. Cónh¹ hi² jmóh³hning jǿg³ hi² hliú² dsa² quián¹²dsa, juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Di³ chian² báh³ juu³dsa. Jø¹² bíh³ chian² dsa² quin¹²dsa ni³ quiah¹². “¡Gu²!” juúh²dsa, tsaih¹²dsa hlég² quián¹²dsa, jøng² dság¹² hlég². “¡Ŋi²!” juúh²dsa, jøng² já¹² hlég². “¡Lah¹la² jmo³!” juúh²dsa, tsaih¹²dsa dsa² jmo¹² ta³ quiah¹²dsa, jøng² jmo¹²dsa lah¹jøng² ―ca¹juúh² dsa² jenh² quianh¹³ juu¹³ hlég². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jøng² dsogh¹² dsǿa¹² Jesús mi³ca¹nǿng²dsa jǿg³ ca¹tse¹ juu¹³ hlég². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² jue¹², dsa² dsø²lé² quianh¹³dsa: ―Lah¹dsóh² juǿi²jni hniah¹², ha¹chian² dsa² go² jniang³ ma²ca¹jén²jni, dsa² hé² jǿg³ ja³cog²jni ju²lah ma²hé² juu¹³ hlég² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jøng² mi³ca¹dsi¹lia¹ dsa² jenh² quianh¹³ juu¹³ hlég², ca¹lø¹ŋi¹²dsa ma²ca¹hlú² dsa² mi³dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma²ton¹ hnøa¹² jmai³ jøng², ca¹ŋó¹ Jesús juu¹² ja³neng¹² cøng² juøi² tsen² Naín. Quianh¹³dsa dsa² quianh³dsa quianh¹³ dsa² jue¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ja¹quien¹³ dsiég¹³dsa ja³jøng² mi³ca¹jén² Jesús dsa² jian¹² hlai³ juu¹² ja³dsa¹hog¹dsa. Mi³lán¹³ hlai³ ja³ŋiúh³ jan² hio¹³ hnǿi², dsa² ha¹chian² jong¹² ma¹chian². Jue¹² dsa² chian² juøi² jøng² ma²dsø²lé² juu¹² cu²san³¹ quianh¹³ hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jøng² ca¹ŋi¹ŋiú² dsǿa¹² Juu¹³ jniang³ mi³ca¹jë́²dsa hio¹³ hnǿi². ―Tsa¹ma¹høg² ―ca¹juúh²dsa, ca¹tsáih¹dsa hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jøng² ca¹ŋó¹ Jesús. Ca¹ŋi¹quiég¹dsa gug² ni³ hma² ja³ron¹² hlai³. Jøng² mi³ca¹jŋi¹ dsa² jiag¹², ca¹juúh² Jesús: ―¡Hning² juǿi²jni dsa² ŋioh¹², nung²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jøng² ca¹gú² dsa² mi³lán¹³ hlai³. Ca¹hløah¹dsa. Jøng² ca¹jë́nh² Jesús dsa² ŋioh¹² ja³cog² mi³chiég³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jøng² ca¹lah¹já¹ dsa² ca¹can¹ gøg². Ca¹mi¹juanh¹²dsa Diú¹³. Ca¹juúh²dsa: ―Jøa³ ja³tiagh³ jniang³ ma²ca¹lø¹chián¹ jan² dsa² juanh¹², dsa² hǿ² jǿg³ quiah¹² Diú¹³. Jøng² ca¹juúh²dsa calah: ―Ma²ca¹mi³hag¹³ Diú¹³ jniang³ dsa² quián¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jøng² ca¹lø¹ŋi¹² ca¹lah¹já¹ dsa² chian² ja³tén¹² Judea quianh¹³ juøi² tioh¹³ cøg¹² ha²lah ma²ca¹jmo¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jøng² ca¹nǿng² Juan jǿg³ jøng², hi² ca¹he¹ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jøng² ca¹tǿh¹ Juan og¹ dsa² quianh³dsa. “Lah¹la² gu³tseih³ hniah¹² Jesús,” ca¹juúh²dsa: “¿Lanh¹³hning dsa² ji¹leg¹³ jnieh³, ho¹ júh³ jií¹ dsa² siáh² calah?,” ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jøng² mi³ca¹dsi¹lé² dsa² ca¹tsen¹ Juan, ca¹tsáih¹dsa Jesús, ca¹juúh²dsa: ―Juan, dsa² chiog¹² dsa² jmøi², ma²ca¹tsei¹ jnieh³. Lah¹la² juúh² Juan: “¿Lanh¹³hning dsa² ji¹leg¹³ jnieh³ ho¹ ju³ jií¹ dsa² siáh² calah?” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jmai³ jøng² ma²na²mi¹hliú² Jesús jue¹² dsa² dsoh³, dsa² lán¹² dsag³, dsa² quin¹² jmi²dsí² hlaih¹³. Ma²na²jmo¹dsa hi² ma²jniuh¹² dsa² mi³teg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quián¹² Juan: ―Gu³tseih³ Juan jǿg³ ma²na²nengh² hniah¹² quianh¹³ hi² ma²na²jaih³ hniah¹²: Ma²jniuh¹² dsa² mi³teg³. Ma²ŋi²nio³ dsa² tsa¹mi³lé² ŋi¹nio¹. Ma²ca¹hlú² dsa² mi³lán¹³ dsag³ hmih¹² tsa¹jŋi¹². Ma²niuh³ dsa² mi³guai³. Ma²ca¹hiog² dsa² ma²ca¹dsan¹. Nang¹² dsa² ti²ŋié² jǿg³ dsio¹ li¹chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jøng² hioh¹² jenh¹² dsa² tsa¹lë́² hi² ué² jǿg³ quieg¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jøng² mi³ma²ŋi¹lia¹ calah dsa² quián¹² Juan, ca¹dsii¹ Jesús jǿg³ quiah¹² Juan, ca¹tsáih¹dsa dsa² jue¹² tiogh³: ―¿He² hi² lë́h² hniah¹² hi² jáih³ hniah¹² mi³ca¹ŋi¹janh³ hniah¹² Juan juu¹² ja³ha¹chian² dsa² tiogh³? ¿Lán¹³dsa dsa² ton¹ jǿg³ neng¹² dsǿa¹², ju³lah lǿa¹² hma² ta² juh¹² ha² juu¹² ja³cán² dsí²? Ha¹chi² lán¹²dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ha²lah lán¹²dsa jøng²? ¿Quieih¹³dsa hmøah¹² jláh³? Ha¹chi². Ja³guǿ¹³ rai¹³, ja³jláh³ báh³ tiogh³ dsa² ti³quieih¹² hmøah¹² jláh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿He² ca¹jaih³ hniah¹² mi³ca¹ŋi³nioh¹³ hniah¹² jøng²? ¿Tsa³ca¹janh³ hniah¹² dsa² hǿ² jǿg³ quiah¹² Diú¹³? Dsa² lah¹héi² báh³ ca¹janh³ hniah¹². Dsa² juanh¹² jín³ cónh¹ dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Di³ jǿg³ quiah¹² dsa² héi² báh³ la², jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³: Tsë́³ jni tsih² høh³ quian¹jni ni³jiá¹ cónh¹ jín³ hning², Dsa² jmo¹ ju²jŋia¹³ juu¹² ja³ŋǿh³hning, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lah¹dsóh² juǿi²jni hniah¹², ha¹chian² dsa² jmøi¹guǿi¹ chian², ju³lah dsa² juanh¹² jín³ cónh¹ Juan ni³ jmøi¹guǿi¹ la². Cónh¹jøng² lǿa¹² ju³ hein² dsa² meh² ma²ŋøa¹² juu¹² ja³jmo¹² Diú¹³ héh¹, dsa² héi² báh³ dsa² juanh¹² ja³cog² Diú¹³ cónh¹ jín³ ja³juanh¹² Juan ni³ jmøi¹guǿi¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Jøng² ca¹mi¹léi¹³ dsa² jue¹², cu¹dsie¹² quianh¹³ dsa² cagh¹² cog³ juøi², hi² dsio¹ jǿg³ quiah¹² Diú¹³ ca¹hǿ² Juan. Di² ca¹jŋó²dsa jmøi² ca¹chiag¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jmáh¹lah dsa² fariseo quianh¹³ tøa¹² he¹² lei¹³ tsa¹ca¹lø¹hiúg¹ dsǿa¹² jǿg³ ca¹jmo¹ Diú¹³ ja³cog²dsa. Di² tsa¹ca¹jŋó² dsa² héi² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’¿He² jǿg³ chi² li¹juúh³ jniang³ jøng², ha²lah lán¹² dsa² ma²chian² na¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lán¹²dsa ju³lah lán¹² hi²meh² tiogh³ ja³dsi¹² guøh¹². Tsa¹tiogh³ hi²meh² cøng² jǿg³. Juúh²dsa: “Ma²ca¹jmó³ jnieh³ son¹³. Jøng² tsa¹ca¹jmoh³ hniah¹² jan³. Ma²ca¹jmó³ jnieh³ hi² chian² jnieh³ jmø³uai¹² calah. Jøng² ha¹chi² ca¹hagh³ hniah¹²,” juúh² hi²meh². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Lah¹jøng² lanh¹² hniah¹². Di³ tsa¹tøa¹² hoh¹² hniah¹² mi³ca¹guøn¹ Juan, dsa² ca¹chiog¹ dsa² jmøi². Tsa¹ca¹gǿh¹ Juan hi³ŋíh¹. Tsa¹ca¹hǿnh²dsa vino. Jøng² ca¹juøh³ hniah¹² hi² quin¹²dsa jmi²dsí² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jøng² ca¹guio¹ jní² calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cøh²gøh²jni ca¹lah¹jǿ¹. Jøng² juúh² hniah¹² hi² lán¹²jni dsa² jlé², dsa² hen¹², dsa² ti³jenh² quianh¹³ dsa² cagh¹² cog³ juøi² quianh¹³ dsa² ti³re² dsag³, juúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Cónh¹jøng² léi¹³ hi² ma²ŋi¹² Diú¹³ ha²lah jmo¹. Di³ jue¹² dsa² ma²hé² jǿg³ ca¹hǿ² Juan, quianh¹³ jǿg³ he¹² jní² calah ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jøng² ca¹tǿh¹ jan² fariseo Jesús hi² dsa¹gǿh¹dsa ja³quiah¹³dsa. Jøng² ca¹ŋó¹ Jesús. Ca¹túgh²dsa mesa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jøng² jan² hio¹³ lø³hiug¹², hio¹³ chian² juøi² jøng², mi³ca¹nǿng² hio¹³ hi² ma²guǿ¹² Jesús mesa ja³quiah¹³ dsa² héi², ca¹hí¹dsa dsi²néi² hi² quieng²dsa tsǿ¹² lǿa¹² cang³ alabastro, hi³ ha³ nang³ ma²juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jøng² ca¹nung² hio¹³ cøg¹² tai³ Jesús, hi² ho¹² hio¹³. Jmøi² ca¹lah¹ ni³ hio¹³ ca¹séi² lø³tai³ Jesús. Jøng² ca¹tsí¹ hio¹³ quianh¹³ jŋiu² dsi³dsa. Jøng² mi³ca¹chiunh¹ hio¹³ lø³tai³ Jesús, ca¹tsǿng²dsa nang³ ma²juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jøng² lah¹la² ca¹ŋi¹jiag¹² dsǿa¹² dsa² fariseo héi², dsa² hniu³, mi³ca¹jái¹dsa: “Ma²ŋi¹² guiuh¹³ lang¹² ha²lah lán¹² hio¹³ jnung², hio¹³ ma²na²tí² gug² quiah¹²dsa, ju³ jøng² lah¹dsóh² lán¹²dsa dsa² hǿ² jǿg³ quiah¹² Diú¹³. Di³ hio¹³ lø³hiug¹² báh³ héi².” ");
INSERT INTO cpaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² hniu³ héi²: ―Simón, chi² báh³ cøng² jǿg³ mi³juǿi³jni hning² ―ca¹juúh²dsa. ―¿He² jǿg³ mi³juúh³hning, tøa¹²? ―ca¹ŋai¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jøng² jǿg³ la² ca¹dsii¹ Jesús: ―Mi³chian² jan² dsa² cuø¹² hei¹² hmah³, quianh¹³ og¹ dsa² ma²re² quiah¹²dsa. Jan² dsa² re² cøng² mei¹³ héh¹ cog³. Jan² dsa² re² cøng² ŋi²lǿg² héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jøng² mi³ca¹lø¹ŋi¹² dsa² ca¹cuø¹ cog³ hi² tsa¹lé² quíg¹ ta³og¹ dsa² héi², ca¹hén²dsa dsag³ quiah¹² ta³og¹dsa. Jøng² ¿hein² dsa² og¹ héi² li¹hniang¹ ma¹dsio¹² hi³méh¹? ―ca¹ŋai¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jøng² ca¹juúh² Simón: ―Dsa² héi² báh³ li¹hniang¹ ma¹dsio¹², lë́²jni, dsa² mi³re² ma¹dsio¹². ―Dsøg¹² báh³. Lah¹jøng² lǿa¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jøng² ca¹jénh¹ Jesús ja³tsenh¹³ hio¹³ lø³hiug¹² héi². Ca¹juúh²dsa, ca¹tsáih¹dsa Simón: ―¿Janh³hning hio¹³ lang¹²? Ha¹chi² jmøi² ma²na²cuøh³hning hi² ranh¹³jni tai¹jni mi³na²hú¹jni dsi²néi² quiánh²hning. Jøng² hio¹³ lang¹² ma²na²ranh¹dsa tai¹jni quianh¹³ jmøi² na²lah¹ ni³dsa. Ma²na²tsí¹dsa quianh¹³ jŋiu² dsi³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ha¹chi² ma²na²chiunh¹³hning ne¹jni. Jøng² ha¹chi² ma²na²jŋi¹ hio¹³ lang¹² chiunh¹² tai¹jni ca¹lah¹cónh¹ mi³ma²na²hú¹jni dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ha¹chi² nang³ ma²na²cuøh¹³hning jní² hi² tsǿng¹³jni dse¹. Jøng² tai¹jni ma²na²tsǿng² hio¹³ lang¹² nang³ ma²juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hi² jøng² lah¹la² juǿi²jni hning²: Ma¹dsio¹² hniang¹ hio¹³ lang¹². Di³ ma²ca¹hen¹ ma¹dsio¹² dsag³ mi³re²dsa. Cónh¹jøng² mih² báh³ hniang¹ dsa² ma²ca¹hen¹ mih² dsag³ quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Ma²ca¹dsan¹ dsag³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jøng² dsa² tiogh³ mesa quianh¹³dsa ca¹dsii¹ jǿg³ guiog¹³dsa, ca¹juúh²dsa: ―¿Hein² dsa² lang¹²? Ca¹tǿ² dsǿg³ dsa² jmøi¹guǿi¹ hén²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cónh¹jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Liúgh²hning. Di³ héh²hning jǿg³. Ma²lé² guǿnh³hning hi² chianh²hning ju²hiúg¹ dsøa¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ni³ jøng² ca¹ŋi³hø¹³ Jesús jǿg³ dsio¹ ja³tioh¹³ hliú² juøi², cu¹dsie¹² juøi² cah³ quianh¹³ juøi² mih². Ca¹he¹dsa jǿg³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹. Ma²quianh¹³ Jesús dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Quianh¹³dsa calah ca²dsiog³ hio¹³, dsa² ma²ca¹hlú² dsag³, quianh¹³ dsa² mi³quin¹² jmi²dsí² hlaih¹³: Ju³lah María, dsa² tǿh²dsa Magdalena, dsa² ca¹huøh¹² guio¹ jmi²dsí² hlaih¹³ quiah¹²; ");
INSERT INTO cpaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ju³lah Juana, hio¹³ quián¹² Chuza, dsa² neng¹² gug² tai³ ca¹lah¹jǿ¹ hi² chi² quiah¹² Herodes; ju³lah Susana calah, quianh¹³ jue¹² hio¹³ siáh². Ca¹mi¹ti¹ hio¹³ héi² ni³ Jesús quianh¹³ dsa² guia¹tón². Ca¹mi³hag¹³dsa quianh¹³ hi² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jøng² jue¹² hlaih¹³ dsa² ca¹túgh² ja³tsenh¹³ Jesús, dsa² chian² hliú² juøi². Jøng² ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹². Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jan² dsa² ca¹ŋó¹ ca¹ŋi¹séi¹ møi¹jon². Ja³ca¹séi²dsa jøng², ca¹quia¹ mih² møi¹jon² cøg¹² juu¹². Ca¹qui² ca¹tsóh² dsa². Jø¹² bíh³ ca¹jiégh¹ tan¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jøng² ca¹quia¹ mih² møi¹jon² ja³tioh¹³ cang³. Jøng² ca¹jlíh¹ mi³ma²dsø²cón³. Di³ tsa¹guúh² huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jøng² ca¹quia¹ mih² ja³tioh¹³ tang¹² Ca¹ŋi¹cón³ chiúh³ tang¹² cu¹dsie¹² quianh¹³ chiúh³ møi¹jon². Ca¹lø¹hmaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jøng² ca¹quia¹ mih² møi¹jon² ja³dsio¹. Ca¹ŋi¹cón³. Ma¹cøng² ŋi²lǿg² mǿi² ca¹cuø¹ lah¹cøng² lah¹cøng² møi¹jon². Jøng² tí² ca¹juúh² Jesús: ―Ju³ná³ hein² dsa² lé² nang¹, ju³neng³dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ni³ jøng² ca¹ŋai¹ dsa² quianh³ Jesús he² hniu¹dsa juúh²dsa jǿg³ ti³jnøa¹² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jøng² ca¹juúh² Jesús: ―Hniah¹² báh³ dsa² li¹ŋih³ jǿg³ ha²lah lé² ja³jmo¹ Diú¹³ héh¹. Di³ jmáh¹lah jǿg³ ti³jnøa¹² li¹chi² quiah¹² dsa² siáh². Mi³jøng² tsa¹li¹lih¹³dsa he² hi² jái¹dsa. Mi³jøng² tsa¹li¹ŋë́²dsa he² hi² nang¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Lah¹la² hniu¹dsa juúh²dsa jǿg³ ti³jnøa¹² jøng²: Lǿa¹² møi¹jon² ju³lah lǿa¹² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lán¹² dsa² tiogh³ cøg¹² juu¹² dsa² ma²ca¹nǿng² jǿg³. Dsø¹juu¹² jøng² já¹² dsa² hlanh³. Jŋíh² dsa² hlanh³ jǿg³ ma²dsø²jiag¹² dsǿa¹² dsa² héi². Mi³jøng² tsa¹hé² dsa² héi² jǿg³. Mi³jøng² tsa¹liúg²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jøng² lán¹² dsa² tiogh³ ja³tioh¹³ cang³ dsa² ca¹hiei¹ jǿg³ ca¹lah¹hiu³ dsǿa¹²dsa mi³ca¹nǿng²dsa jǿg³. Cónh¹jøng² lán¹²dsa ju³lah hma² tsa¹chi² jmó³. Cu²hna² báh³ hé²dsa jǿg³. Jøng² tiáh¹ dsǿa¹²dsa ju³ná² he² mih² jmø³uai¹² ca¹lø¹chián¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jøng² lán¹² dsa² tiogh³ jøa³ ja³tioh¹³ tang¹² dsa² ja¹lái¹ nang¹² jǿg³. Tsa¹chinh¹²dsa tí² jǿg³. Di³ chian²dsa ju²hí³ dsøa¹² jǿg³ quiah¹² jmøi¹guǿi¹ la², ha²lah jmo¹dsa li¹chi² ma¹dsio¹² quiah¹²dsa, ha²lah túgh²dsa dsio¹. Tsa¹dsø¹cón³ jǿg³ ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jøng² lán¹² dsa² tiogh³ huø¹ dsio¹ dsa² chính² tí² jǿg³ na³ma²ca¹nǿng²dsa. Dsio¹ dsǿa¹²dsa. Hiug² dsǿa¹²dsa. Jøng² dsø²cón³ quiah¹²dsa ta¹huø³ ron¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ha¹chian² dsa² te¹² si² jmøi²cøg², mi³jøng² jløa¹dsa ho¹ ju³ tsih¹dsa niúh¹ jein³. Ni³ jein³ báh³ tsih¹²dsa. Mi³jøng² jní² quiah¹² dsa² dsa¹tiogh¹² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Di³ ha¹chi² hi² chi² hi² rø²hma¹, hi² tsa¹li¹léi¹³. Ha¹chi² jǿg³ ti³jnøa¹² chi², ju³lah jǿg³ tsa¹li¹ne³ jniang². Li¹léi¹³ báh³ ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hi² jøng² dsio¹ cánh³ hniah¹² hí³ jǿg³ hi² nøngh² hniah¹². Di³ cuø¹ Diú¹³ hi² niu¹ ma¹dsio¹² jǿg³ ju²gug² dsa² cán² hí³ jǿg³. Jøng² jŋíh² báh³ Diú¹³ he² jǿg³ mih² lë́²dsa hi² ŋi¹²dsa, ju³lah dsa² tsa¹jmo¹² hí³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jøng² ca¹dsiég¹ mi³chiég³ Jesús quianh¹³ roh¹³dsa ja³hiúg³ Jesús. Cónh¹jøng² tsa¹lé² dsi³lé²dsa ca¹tǿ² dsi²néi². Di³ jue¹² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jøng² ca¹juúh² jan² dsa², ca¹tsáih¹dsa Jesús: ―Hning² tǿh² mi³chiegh²hning ja³dsi¹² lah¹quianh¹³ rúh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² tiogh³: ―Dsa² héi² báh³ lán¹² mi³chie¹ lah¹quianh¹³ roh¹² jní², dsa² nang¹² jǿg³ quiah¹² Diú¹³, jøng² mi²ti¹dsa jǿg³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jøng² lah¹la² ca¹løa¹ cøng² jmai³: Ca¹hí¹ Jesús cøng² barco quianh¹³ dsa² quianh³dsa. Jøng² ca¹juúh²dsa: ―Ma¹dsǿg³ hŋoh¹³ jmøi² ―ca¹juúh²dsa. Jøng² ca¹ŋi¹lé²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ca¹güe² Jesús ja³dsø²lé²dsa jøng². Ni³ jøng² ca¹hǿi² dsí² tí² ni³ jmøi² juøh¹² jøng². Ca¹jéinh¹ jmøi² niúh¹ barco hi² mi³cánh² barco. Ma²lǿ² gøg² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jøng² ca¹ŋi³ŋie¹³dsa Jesús. Ca¹juúh²dsa: ―Tøa¹². Ma²dsø²honh¹² barco, tøa¹² ―ca¹juúh²dsa. Jøng² mi³ma²na²ŋié¹ Jesús, ca¹jé²dsa dsí² quianh¹³ jmøi². Jøng² ca¹jŋi¹ dsí². Ca¹niu¹ tei³ ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jøng² ca¹juúh² Jesús: ―¿He² ca¹løa¹ hi² tsa¹héh² hniah¹² jǿg³? ―ca¹juúh²dsa. Jøng² dsogh¹² dsǿa¹² dsa² quianh³dsa. Ca¹can¹dsa gøg². Ca¹juúh²dsa, ca¹tsáih¹dsa guiog¹³dsa: ―¿Jin³ hein² dsa² lang¹²? Ca¹løa¹ ca¹tǿ² dsí², ca¹tǿ² jmøi² jmo¹² dsa² lang¹² héh¹. Jøng² niuh³ jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jøng² juu¹² ni³ jmøi², ca¹ŋi¹lé²dsa go² dsa² geraseno, huø¹ neng¹² hŋoh¹³ jmøi² ca¹lah¹cónh¹ ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jøng² mi³ma²na²siog¹ Jesús barco, ca¹jén²dsa jan² dsa² ŋioh¹² chian² juøi² jøng², dsa² quin¹² jmi²dsí² quiah¹² dsa² hlanh³. Ma²ni³ŋó¹³ jmai³ tsa¹caih¹² dsa² héi² hmøah¹². Ha¹chi² ma¹guǿ¹²dsa hniu³dsa. Ma²guǿ¹²dsa cu²san³¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jøng² mi³ca¹jë́² dsa² héi² Jesús, ca¹chi¹jné¹dsa ja³tsenh¹³dsa. Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¿He² jǿg³ ca¹të́h²hning quianh¹³ jní², Jesús, jong¹² Diú¹³ juanh¹²? Juǿi²jni hning² hi² tsa¹jmogh¹³hning jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Lah¹jøng² ca¹juúh² dsa² héi². Di³ ma²na²jmo¹ Jesús héh¹ hi² huøh¹ jmi²dsí² hlaih¹³ quiah¹²dsa. Di³ hliú² rón² ma²ca¹jiag¹ jmi²dsí². Jøng² ma²ca¹hŋiéng² dsa² juøi² gug²dsa quianh¹³ tai³dsa. Ca¹hŋiéng²dsa quianh¹³ ŋí³ cadena. Cónh¹jøng² ca¹hni¹ dsa² héi² cadena. Jøng² ca¹jiag¹ jmi²dsí² juu¹² ja³ha¹chian² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² tsenh²hning? Jøng² ca¹juúh² dsa² héi²: ―Legión báh³ tsen²jni ―ca¹juúh²dsa, hi² hniu¹dsa juúh²dsa cu²tséh¹ jue¹²dsa. Lah¹jøng² ca¹juúh²dsa, di³ hliúg² jmi²dsí² hlaih¹³ ma²quin¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jøng² ca¹møa¹ jmi²dsí² jǿg³ hi² tsa¹mi³tsei¹ Jesús juu¹² ja³hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ca¹møa¹ jmi²dsí² hi² cuø¹ Jesús jǿg³ hi² cán² ŋié¹². Di³ tiogh³ jue¹² ŋié¹² ja³jøng², jáh² ti³gøah¹² høg² nung² huu¹³ máh². Jøng² mi³ca¹cuø¹ Jesús jǿg³, ");
INSERT INTO cpaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ca¹huøh¹² jmi²dsí² hlaih¹³, ca¹can¹ ŋié¹². Jøng² ca¹ŋi¹lé² ŋié¹² gu¹hei¹². Ca¹siúgh²jah ja³chi³dsió¹³. Ca¹dsan¹jah niúh¹ dsieg¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jøng² ca¹cuøin¹ dsa² mi³jmo¹² hí³ jáh² mi³ma²na²jái¹dsa. Ca¹he¹dsa jǿg³ juu¹² jøa³juøi² lah¹quianh¹³ dsi²juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jøng² ca¹ŋi¹lé² dsa² jue¹² ŋi³jái³ he² ma²na²løa¹. Mi³ca¹dsi¹lé²dsa ja³tsenh¹³ Jesús, ca¹jë́²dsa dsa² mi³quin¹² jmi²dsí² hlaih¹³ héi². Ma²guǿ¹²dsa cøg¹² ja³tsenh¹³ Jesús. Ma²dsiog¹dsa. Ma²quieih¹²dsa tsǿnh³dsa. Jøng² gøg² ca¹can¹ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dsa² ca¹jái¹ ha²lah ca¹mi¹hliú² Jesús dsa² mi³quin¹² jmi²dsí² hlaih¹³, ca¹he¹ jǿg³ ha²lah ca¹løa¹, ca¹tsáih¹dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jøng² ca¹lah¹já¹ dsa² chian² huø¹ Gerasa jøng² ca¹tsáih¹ Jesús hi² mi³u¹hai¹²dsa go²dsa. Di³ hiug¹² ca¹can¹dsa gøg³. Hi² jøng² ca¹ŋáh¹ calah Jesús mi³ca¹uǿi²dsa barco. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma²ca¹møa¹ dsa² mi³quin¹² jmi²dsí² hlaih¹³ hi² mi³dság¹dsa quianh¹³ Jesús. Di³ tsa¹ca¹cuø¹dsa jǿg³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Guǿnh³ ja³quiánh³hning. Gu³jmoh³hning jǿg³ ha²lah ma²ca¹jmo¹ Diú¹³ ja³cogh²hning ―ca¹juúh² Jesús. Jøng² ca¹ŋó¹ dsa² héi². Ca¹ŋi¹dsií¹dsa jǿg³ ta³cøng² juøi² ca¹lah¹jǿ¹ hi² ma²ca¹jmo¹ Jesús ni³ huu¹³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jøng² ma²chi³jŋiang¹² dsa² jue¹² mi³ca¹dsiánh¹ Jesús hŋoh¹³ jmøi². Ca¹lah¹hiu³ dsǿa¹²dsa ca¹hien¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jøng² ca¹dsiég¹ jan² dsa² tsen² Jairo, dsa² ta³ quián¹² guøh¹². Ca¹chi¹jné¹ dsa² héi² ja³tsenh¹³ Jesús. Quianh¹³ hi² tiog¹³ ca¹tǿh¹dsa Jesús juu¹² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Di³ ma²tǿ² ja³jón² jan² héi² báh³ ja³mái¹³dsa, tsih² ma²guie¹tǿn² ŋih¹². Ma²dsø²lé²dsa jøng², cu¹dsie¹² quianh¹³ dsa² jue¹². Ca¹lah¹cu²hliah¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hiúg³ jan² hio¹³, dsa² lán¹² dsag³ ton², ja³dsø²lé² dsa² jue¹². Ma²ni³ŋó¹³ guie¹tǿn² ji²ŋi² hi² dsoh³dsa. Ha¹chian² ma²ca¹tiúh¹ jmo¹ hí³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jøng² ca¹ŋó¹ hio¹³ ta¹lah¹cah¹ Jesús. Ca¹láh²dsa hé¹ tsǿnh³ Jesús. Dsø¹juu¹² jøng² ca¹jŋi¹ ton²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","―¿Hein² na²láh² tsønh¹? ―ca¹juúh² Jesús. Ha¹chian²dsa ca¹he¹ jǿg³. Jøng² ca¹juúh² Pedro: ―Tøa¹², ma²cu²hliah¹² ma²qui²güeh¹² dsa² jue¹² hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","―Ma²na²láh² jan² dsa² quieg¹ jní² ―ca¹juúh² Jesús. ―Léi¹³jni ma²na²cuú¹jni dsa² mih² bí² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jøng² mi³ca¹lø¹lih¹³ hio¹³ hi² tsa¹lé² jnøa¹ jǿg³, ca¹ŋó¹dsa ma²jlia¹²dsa. Ca¹chi¹jné¹dsa ja³ta¹ni¹ Jesús. Ca¹he¹dsa jǿg³ ja³ta¹ni¹ dsa² jue¹² he² løa¹ na²láh²dsa quiah¹² Jesús. Ca¹juúh²dsa hi² ma²na²hlú²dsa dsø¹juu¹² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³: ―Ma²na²hlúh²hning jon¹², ni³ huu¹³ hi² héh²hning jǿg³. Ma²lé² guǿnh³hning ca¹lah¹hiug² hoh¹²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jǿg³ jøng² ma²chi³hløah¹² Jesús mi³ca¹dsiég¹ jan² dsa² guǿ¹² ja³quiah¹³ dsa² ta³ quián¹² guøh¹² héi². ―Ma²na¹jon¹ ja³máih¹hning. Tiúh¹ tsa¹ma¹cuøh¹³hning tøa¹² ju²méh³ dsøa¹² ―ca¹juúh²dsa, ca¹tsáih¹dsa Jairo. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Jairo, mi³ca¹nǿng²dsa jǿg³ jøng²: ―Tsa¹jmo² ganh¹. Cøng² hi² héh²hning jǿg³. Jøng² hliú² tsih² quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mi³ca¹dsi¹lé²dsa ja³quiah¹³ Jairo, tsa¹ca¹cuø¹ Jesús jǿg³ dsa¹tiogh¹ dsa² jue¹² dsi²néi², jmáh¹lah Pedro, quianh¹³ Juan, quianh¹³ Jacobo, quianh¹³ chiég³ jmi² tsih² dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma²tiogh² cu²møah¹³ ti³ho¹² dsa² jue¹². Jøng² ca¹juúh² Jesús: ―¡Tsa¹ma¹høg²! Ha¹chi² ma²rø²jon¹²tsih. Rø²güé¹ báh³ tsih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jøng² ca¹ŋǿi² dsa² tiogh³. Ma²ŋi¹²dsa ma²rø²jon¹²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Cónh¹jøng² ca¹chính² Jesús gug²tsih. Ca¹juúh²dsa: ―¡Nung², tsih²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cu²ŋieih¹³ ca¹jniáng¹ ni³tsih. Jøng² ca¹nung² báh³ tsih². Jøng² ca¹jmo¹ Jesús jǿg³ hi² cuø¹dsa hi² gǿh¹tsih. ");
INSERT INTO cpaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ca¹can¹ hlaih¹³ chiég³ jmi²tsih gøg². Cónh¹jøng² ca¹juúh² Jesús quianh¹³ hi² tiog¹³ hi² tsa¹tsáih¹dsa jin³ hein² he² na²løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jøng² ca¹tǿh¹ Jesús dsa¹ guia¹tón². Ca¹cuúh¹dsa dsa² bí², mi³jøng² tiúh¹dsa huø¹dsa jmi²dsí² hlaih¹³, tiúh¹dsa jmo¹dsa hí³ dsa² lán¹² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jøng² ca¹tsen¹dsa dsa² juu¹² ja³ca¹ŋi³hø¹³dsa jǿg³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹, juu¹² ja³ca¹mi¹hliú²dsa dsa² dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² guia¹tón²: ―Ha¹chi² cánh³ hniah¹² jin³ he² quiah¹² dsi²juu¹². Tsa¹cánh³ hniah¹² hma² hø¹³. Tsa¹cánh³ hniah¹² mu³ra³. Tsa¹cánh³ hniah¹² hé¹². Tsa¹cánh³ hniah¹² cog³. Tsa¹cánh³ hniah¹² ma¹ton¹ tsǿinh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jøng² ha² ja³ca¹cuø¹dsa hniú¹², cøng² hniú¹² jøng² báh³ túgh³ hniah¹² ca¹lah¹ca¹tǿ² ja³gu³noh¹² hniah¹² juøi² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jøng² ha² juøi² ja³tsa¹ca¹hien¹dsa hniah¹², gu³noh¹² hniah¹² ja³siíh³. Jøng² quiah¹³ hniah¹² hleg² ti³quin¹² ju³taih¹ hniah¹². Mi³jøng² li¹dsøg¹² dsǿa¹²dsa ta¹canh¹³dsa dsag³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jøng² ca¹ŋi¹lé² dsa² guia¹tón². Hliú² juøi² ca¹ŋi³hø¹³dsa jǿg³ quiah¹² Diú¹³. Ca¹mi¹hliú²dsa dsa² ca¹lah¹tan¹³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jøng² dsi³máh² Herodes ca¹nǿng² jǿg³ ca¹lah¹jǿ¹ hi² ca¹jmo¹ Jesús. Chian²dsa ju²hí³ dsøa¹². Di³ ca²dsiog³dsa ma²juúh² hi² lán¹² Jesús Juan. Hi² ca¹hiog² Juan calah, dsa² ma²ca¹jon¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jøng² juúh² ca²dsiog³dsa hi² lán¹² Jesús hlai³ Elías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jøng² juúh² ca²dsiog³dsa calah hi² lán¹²dsa jan² dsa² quianh¹³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih², dsa² ma²ca¹hiog². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jøng² ca¹juúh² Herodes: ―Ca¹quiúh¹jni lag³ Juan. ¿Jøng² hein² dsa² héi², dsa² ma²chi² jǿg³ quiah¹²? ―ca¹juúh²dsa. Jøng² hniu¹ Herodes jë́²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jøng² mi³ca¹dsi¹lia¹ dsa² guia¹tón², dsa² ma²lán¹² ju³lah tsih² høh³ quián¹² Jesús, ca¹heh¹dsa Jesús ca¹lah¹jǿ¹ hi² ma²ca¹jmo¹dsa. Jøng² ca¹tai¹ Jesus juu¹² cøg¹², juu¹² jøa³juøi² tsen² Betsaida. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cónh¹jøng² ca¹ŋi¹lé² calah dsa² jue¹², mi³ca¹lø¹lih¹³dsa. Jøng² ca¹hien¹ báh³ Jesús dsa² jue¹². Ca¹dsiúh¹dsa dsa² jǿg³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹. Ca¹mi¹hliú²dsa dsa² lán¹² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jøng² mi³ma²tǿ² ja³ca¹hlég² ca¹ŋi¹jmó² dsa² guia¹tón² jǿg³ quianh¹³ Jesús, ca¹juúh²dsa: ―Dsianh¹³hning dsa² jue¹². Mi³jøng² dsa¹jŋi¹³dsa dsa¹gǿh¹dsa rancho quianh¹³ juøi² tioh¹³ cøg¹². Di³ ha¹chi² chi² ja³la² ja³tiagh³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jøng² ca¹juúh² Jesús: ―Hniah¹² cuøh¹³dsa hi² gǿh¹dsa ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Jmáh¹lah hŋí² hi³ŋíh¹ quin³ jniang³ quianh¹³ og¹ jáh² tiogh³ jmøi². Tsa¹lé² dsø²lii¹³ jnieh³ hi² gǿh¹ dsa² jue¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Di³ ma²tiogh³ cónh¹ hŋí² mei¹³ dsa², jmáh¹lah dsa² ŋioh¹². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Jmo³ hi² tógh¹dsa huø¹ ma¹ton¹lug¹guián²dsa lah¹cu²tséh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jøng² ca¹jmo¹dsa lah¹jøng². Ca¹jmo¹dsa ca¹túgh² ca¹lah¹já¹dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jøng² ca¹can¹ Jesús hŋí² hi³ŋíh¹ jøng² quianh¹³ og¹ jáh². Mi³ca¹jái¹dsa guiuh¹³, ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ti³jneh³. Ca¹cuúh¹dsa dsa² quianh³dsa. Mi³jøng² ca¹dsiúh¹dsa, ca¹cuúh¹dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jøng² ca¹gǿh¹ ca¹lah¹já¹ dsa² tiogh³. Ca¹lø¹tan¹³ báh³ dsa². Ni³ jøng² ca¹mi¹cángh²dsa guie¹tǿn² møh²tá³ quianh¹³ jmáh¹lah jneh³ hi³ŋíh¹ ca¹chiág¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cøng² jmai³ ca¹ŋi¹lé² Jesús quianh¹³ dsa² quianh³dsa cøng² ja³cu³guiog¹³, ja³ca¹hlanh¹dsa Diú¹³. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―¿He² juúh² dsa² juøi²? ¿Hein² jní²? ");
INSERT INTO cpaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jøng² ca¹juúh² dsa² quianh³ Jesús: ―Ca²dsiog³dsa juúh² hi² lanh¹²hning Juan, dsa² ca¹chiog¹ dsa² jmøi². Chian² dsa² juúh² hi² lanh¹²hning hlai³ Elías. Jø¹² bíh³ chian² dsa² juúh² hi² lanh¹²hning jan² dsa² ca¹hiog², dsa² mi³quianh¹³ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jøng² ca¹juúh² calah Jesús: ―Jøng² hniah¹², ¿hein² jní²? lë́h² hniah¹² ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―Cristo ca¹tsen¹ Diú¹³ báh³ lanh¹²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jøng² quianh¹³ hi² tiog¹³ ca¹juúh² Jesús hi² tsa¹tsáih¹dsa jin³ hein² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ca¹juúh² Jesús: ―Hi² hniuh¹² can³jni ma¹dsio¹² jmø³uai¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Hi² hniuh¹² tiáng² dsa² canh¹³, quianh¹³ juu¹³ jmi²dsa², quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Jøng² hniuh¹² jón²jni. Jøng² hiog¹jni jmai³ hnøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ni³ jøng² ca¹juúh²dsa, ca¹tsáih¹dsa ca¹lah¹já¹dsa: ―Ju³ná³ hein² dsa² hniu¹ dság¹ quianh¹³ jní², jøng² tsa¹hniuh¹² høa¹dsa dsǿa¹²dsa jǿg³ quiah¹² hŋiah¹²dsa. Ca¹lah¹jǿ¹ jmai³ mi¹hiúg¹dsa dsǿa¹²dsa hie¹dsa jón²dsa ju³ná³ he² ca¹løa¹. Jøng² báh³ dság¹dsa quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Di³ ju³ná³ hein² dsa² dsa²jiag¹² dsǿa¹² jmáh¹lah jǿg³ ha²lah guú¹dsa dsio¹, dsa² héi² jón². Cónh¹jøng² ju³ná³ hein² dsa² ca¹jon¹ huu¹³ quieg¹ jní², dsa² héi² li¹chian² ja³dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿He² ta³ jmo¹ líh² jniang³ ta³cøng² jmøi¹guǿi¹ ju³ná³ dsa¹héin² jniang³, ju³ná³ quíg³ jniang³ jmi²dsí² quián² jniang³? ");
INSERT INTO cpaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Di³ jmo¹³ báh³ jní² tsa¹cué¹²jni ju³lah hein² dsa² ca¹jmo¹ tsa¹cuai¹²dsa jní², tsa¹cuøh¹²dsa jǿg³ quieg¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Lah¹jøng² jmo¹³jni jmai³ ja³guiogh¹³jni, na³ma²chi² bí² quieg¹jni, hi² chinh³jni hma² høh³ quiah¹² Jmi² jniang³, hi² quianh¹³jni ángeles han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cónh¹jøng² lah¹dsóh² juǿi²jni hniah¹². Ha¹chi² dsiánh¹ ca²dsiogh³ hniah¹² tiogh³ ja³la², ca¹lah¹ca¹tǿ² ja³ca¹jaih³ hniah¹² ma²já¹ ja³jmo¹ Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cónh¹ ja³jŋi¹ jmai³ jøng² hi² ca¹juúh² Jesús lah¹jøng², ca¹ŋó¹dsa ni³ máh² ja³dsa¹hlanh³dsa Diú¹³. Ca¹jian¹dsa Pedro, quianh¹³ Juan, quianh¹³ Jacobo. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ja³ma²hlanh¹² Jesús Diú¹³ jøng², ca¹lø¹tsë́¹ ni³dsa. Ca¹løa¹ teg² tsǿnh³dsa. Sih¹² hlaih¹³ cu¹té¹² ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jøng² ca¹jnia¹ og¹ dsa² ca¹dsii¹ jǿg³ quianh¹³ Jesús. Hlai³ Moisés quianh¹³ hlai³ Elías báh³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sih¹² hlaih¹³ ti³jniá²dsa. Ca¹dsii¹dsa jǿg³ quiah¹² ja³na¹ bíh³ jón² Jesús jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma²lǿ² lø¹i³güé¹ Pedro quianh¹³ dsa² quianh³dsa. Cónh¹jøng² ha¹chi² ca¹güe²dsa. Ca¹jái¹dsa hi² taih¹² quiah¹² Jesús. Jø¹² ca¹jë́²dsa dsa² og¹ tiogh³ quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jøng² mi³ma²dsø²lia¹ dsa² héi², ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Tøa¹², dsio¹ hi² ma²tiagh³ jnieh³ ja³la². Jmó³ báh³ jnieh³ hnøa¹² hio¹², cøng² quiánh² hning², cøng² quiah¹² hlai³ Moisés, cøng² quiah¹² hlai³ Elías ―ca¹juúh²dsa, hi² tsa¹ŋi¹²dsa he² jǿg³ juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma²chi³hløah¹² Pedro mi³ca¹siog² cøng² jneng¹² guiuh¹³ ja³tiogh³dsa. Ni³goh¹²dsa mi³ma²tiogh³dsa jøa³ ja³hei¹² jneng¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jøng² ca¹hløah¹ Jmi² jniang³ jøa³jneng¹², ca¹juúh²dsa: ―Dsa² lang¹² báh³ jon¹ jní². Ma²ca¹hia¹jni dsa². ¡Neng² di³ jǿg³ hi² juúh²dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mi³ca¹juúh² Jmi² jniang³ lah¹jøng², ca¹jái¹ dsa² tiogh³ hi² ma²tsenh¹² Jesús cu²hŋiah¹². Jøng² ha¹chian² dsa² ca¹tsáih¹dsa jin³ hein² dsø¹juu¹² jøng² hi² ma²ca¹jái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mi³ca¹jni¹ jøng², mi³ma²na²siog²dsa máh², ca¹jén² Jesús dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jøng² ca¹hløah¹ tí² jan² dsa² ŋioh¹² hiúg³ jøa³ quiah¹² dsa² jue¹², ca¹juúh²dsa: ―Juanh¹² hoh¹²hning, tøa¹². ¡Jai³ ha²lah lán¹² ja³ŋiúh¹jni! Jan² guing² héi² báh³ chian² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jøng² lǿ² hi² jiag¹² jmi²dsí² hlaih¹³. Cónh¹ tsa¹jŋia¹³ ho¹²tsih. Jmo¹² jmi²dsí² hi² dsø²hën¹²tsih. Hii² jan¹² hag³tsih. Ca¹lah¹ja¹lái¹ jŋi¹² hi² bø²lë́h²tsih. Ma¹dsio¹² jmø³uai¹² jenh¹²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma²na²juǿi²jni dsa² quianh³hning hi² mi³dsi¹dsa jmi²dsí². Cónh¹jøng² ha¹chi² na²tiúh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jøng² ca¹juúh² Jesús: ―¡He³ lah¹hiúg¹²! ¿Ha² bíh³ cónh¹ jmai³ hniuh¹² hú¹³jni hi² mi³dsian¹³jni dsøa¹ quianh¹³ hniah¹², dsa² tsa¹héh² jǿg³, dsa² ŋi²nioh³ juu¹² siíh²? ¡Ŋi³jian¹² tsih² quiánh²hning ja³la²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jøng² ma²dság¹²tsih cøg¹² ja³tsenh¹³ Jesús, mi³ca¹jmo¹ jmi²dsí² hlaih¹³ hi² ca¹ŋi¹hë¹²tsih. Ca¹bø² ca¹lë́h²tsih. Jøng² ca¹jé² Jesús jmi²dsí² hlaih¹³. Ta³lah¹ca¹hlú²tsih. Jøng² ca¹jë́inh² Jesús ja³cog² ti³jmi²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jøng² dsogh¹² dsǿa¹² ca¹lah¹já¹ dsa² tiogh³. “Hiug¹² juanh¹² Diú¹³,” lë́²dsa. Jøng² ma²tiogh³dsa dsogh¹² dsøa¹²dsa ca¹lah¹jǿ¹ hi² jmo¹² Jesús, mi³ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―¡Cu²rø² neng² jǿg³ quieg¹jni! Jainh¹dsa jní² quiah¹² dsa² hiag¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cónh¹jøng² ha¹chi² ca¹ŋë́h² dsǿa¹² dsa² quianh³dsa jǿg³ jøng². Ca¹jmo¹ Diú¹³ tsa¹ca¹lø¹ŋë́²dsa. Jøng² ha¹chi² ca¹ŋai¹dsa he² hniu¹dsa juúh²dsa jǿg³ jøng². Di³ hi² goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jøng² ca¹dsii¹ dsa² quianh³ Jesús jǿg³ hein² dsa² quianh¹³dsa lán¹² dsa² juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jøng² mi³ca¹lø¹lih¹³ Jesús he² jǿg³ dsø²jiag¹² dsǿa¹² dsa² héi², ca¹jian¹dsa jan² hi²meh². Ca¹jmo¹dsa ca¹nung²tsih cøg¹² ja³tsenh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh³dsa: ―Ju³ná³ hein² dsa² ca¹hien¹ jan² hi²meh² lah¹lang¹² ni³ huu¹³ quieg¹ jní², jøng² ca¹hiei¹dsa jní² calah. Jøng² ju³ná³ hein² dsa² héi² ca¹hiei¹ jní², jø¹² bíh³ ca¹hien¹dsa dsa² ca¹tsei¹ jní². Di³ dsa² héi² báh³ lán¹² dsa² juanh¹² quianh¹³ hniah¹², dsa² jmo¹² hi² tsa¹quien¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jøng² ca¹juúh² Juan: ―Tøa¹², ca¹ne¹³ jnieh³ jan² dsa² huø¹² jmi²dsí² hlaih¹³ quiah¹² dsa² dsoh³, hi² chi³hia¹²dsa hning². Jøng² ca¹tséih³ jnieh³ dsa² hi² tsa¹ma¹jmo¹dsa lah¹jøng². Di³ tsa¹ŋøa¹²dsa quianh¹³ jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jøng² ca¹juúh² Jesús: ―Tsa¹jmóh³ hniah¹² tsa¹cuúh³ hniah¹² jǿg³ hi² jmo¹dsa lah¹jøng². Di³ dsa² quianh¹³ báh³ hniah¹² ju³ná³ hein² dsa² tsa¹hiag¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jøng² mi³ma²ja¹quien¹³ jmai³ ja³dsánh¹ Jesús juu¹² guiuh¹³, ca¹mi¹bí²dsa dsǿa¹²dsa hi² dság¹dsa juu¹² jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jøng² ca¹tsen¹dsa jan² og¹ dsa² ni³jiá¹, dsa² mi³hno¹² cøng² neng¹² hniú¹² cøng² juøi² ja³tén¹² huø¹ Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Cónh¹jøng² tsa¹ca¹hien¹ dsa² chian² ja³jøng² mi³ca¹lø¹lih¹³dsa hi² ma²dság¹²dsa juu¹² jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jøng² mi³ca¹jái¹ Jacobo quianh¹³ Juan, dsa² quianh³dsa, ha²lah jmo¹² dsa² héi², ca¹juúh²dsa, ca¹tsáih¹dsa dsa² Jesús: ―Juu¹³ jniang³, ¿tsa³hnøng²hning hi² tséih³ jnieh³ Diú¹³? ¿Mi³jøng² quia¹ si² dsíg² juu¹² ŋi¹juǿi¹. Mi³jøng² quiúg¹ dsa² héi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jøng² ca¹jenh¹ Jesús. Ca¹jé²dsa dsa² ca¹juúh² lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ca¹ŋi¹lé²dsa juøi² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma²dsø²lé²dsa mi³ca¹juúh² jan² dsa², ca¹tsáih¹dsa Jesús: ―Nei¹³jni quianh¹³ hníng¹ lǿa¹² ju³ ha² juu¹² ca¹dsiégh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Chi² báh³ quiah¹² guu¹² ja³li¹gú¹jah. Chi² báh³ quiah¹² tan¹². Cónh¹jøng² ha¹chi² chi² ja³li¹jan³jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² siáh²: ―Ma¹dsǿg³ quianh¹³ jní² ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Juu¹³ jniang³, ¿tsa³cuúh³hning jǿg³ neh¹³jni ni³jiá¹, ca¹lah¹ca¹jon¹ ti³ŋiéh¹jni? Jøng² ma²nei¹³jni quianh¹³ hníng¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jøng² ca¹juúh² Jesús: ―Tiúh¹ báh³ dsa¹hog¹ dsa² tsa¹hniu¹ jǿg³ guieg¹jni, dsa² ma²ni³dsan². Hning² góh³. Gu³hǿh¹hning jǿg³ ha²lah lǿa¹² ja³jmo¹ Diú¹³ héh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jøng² ca¹juúh² calah dsa² siáh²: ―Nei¹³ báh³ jní² quianh¹³ hníng¹, Juu¹³ jniang³. Cónh¹jøng² neh¹³jni ca²tí² píh³ hi² ŋi³héih¹jni dsa² tiogh³ dsi²néi² jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Ha¹chian² dsa² tén¹² dsiég¹³ ja³jmo¹ Diú¹³ héh¹ ju³ná³ tsa¹neng¹² cøng² dsǿa¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ni³ jøng² ca¹hia¹ Juu¹³ jniang³ ton¹lug¹guián² rø²dsǿ² guiúg² dsa², dsa² ca¹ŋi¹can¹ jǿg³ ma²og¹dsa lah¹cøng² lah¹cøng² juøi² ja³na¹ bíh³ dság¹ Jesús hŋiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lah¹la² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Jue¹² dsa² chian², dsa² li¹quianh¹³ Diú¹³. Lán¹²dsa ju³lah lǿa¹² cuøi² quiah¹² Diú¹³. Cónh¹jøng² mih³ dsa² chian², dsa² huǿi² cuøi², dsa² tsø²jan¹² jǿg³. Hi² jøng² hlanh¹³ hniah¹² Diú¹³. Mi³jøng² tsen¹dsa dsa² tsø¹jan¹ jǿg³ quiah¹²dsa juu¹² ja³tiogh³ dsa² li¹quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Gu³noh¹² hniah¹²! Tsë́³jni hniah¹² ja³ué³, ju³lah jan² dsa² tsen¹² jah¹chih² juu¹² ja³tiogh³ dsøi² núng³. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tsa¹cánh³ hniah¹² cog³. Tsa¹cánh³ hniah¹² mu²ra³. Tsa¹cánh³ hniah¹² løg² ca²jag¹³. Ha¹chian² dsa² juaih¹³ hniah¹² dsi²juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jøng² lah¹la² juúh³ hniah¹² ja³lah¹ni³ huh¹³ hniah¹² dsi²néi² ja³quiah¹³ dsa²: “Ju³li¹chianh² hniah¹² ju²hiúg¹ dsøa¹², hniah¹² dsa² hniu³,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jøng² lé² báh³ lah¹jøng² quiah¹² dsa² hniu³, ju³ná³ lán¹²dsa dsa² hiug² dsǿa¹². Cónh¹jøng² ha¹chi² li¹ti¹ jǿg³ ju³ná³ tsa²hiug² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jøng² cøng² báh³ hniú¹² janh³ hniah¹² lah¹cøng² lah¹cøng² juøi². Ja³jøng² cǿh³ hǿgh³ hniah¹². Di³ tiog¹³ báh³ hniuh¹² li¹hmah¹³ quiah¹² dsa² jmo¹² ta³. Tsa¹ŋi³nioh³ hniah¹² lah¹cøng² lah¹cøng² hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jøng² ha² juøi² ja³ca¹hien¹dsa hniah¹², ja³jøng² cǿh³ hniah¹² lǿa¹² ju³ he² ca¹tóh²dsa ni³ mesa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mi³hliúh³ hniah¹² dsa² dsoh³ ja³jøng². Jøng² juaih¹³ hniah¹² dsa² juøi²: “Ma²ja¹quien¹³ ja³lé² hi² túgh³ hniah¹² juu¹² ja³jmo¹² Diú¹³ héh¹.” ");
INSERT INTO cpaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Cónh¹jøng² ha² juøi² ja³tsa¹ca¹hien¹dsa hniah¹², jøa³cai³¹ gu³tseih³ hniah¹² dsa²: ");
INSERT INTO cpaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ca¹lah¹ca¹tǿ² hleg² quiah¹² juøi² quiánh² hniah¹², hleg² ti³quin¹³ ju³tai¹ jnieh³, quián¹³ jnieh³. Mi³jøng² li¹ŋih³ hniah¹² ta¹canh¹³ hniah¹² dsag³. Di³ ma²ca¹ja¹quien¹³ ja³mi³lé² hi² túgh³ hniah¹² juu¹² ja³jmo¹² Diú¹³ héh¹,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lah¹dsóh² juǿi²jni hniah¹², hiug¹² jín³ hi² ué² lé² quiah¹² dsa² tiogh³ juøi² lah¹jøng² ca¹lah¹cónh¹ jín² lé² quiah¹² dsa² mi³chian² jøa³juøi² Sodoma. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡He³ báh³ ué² quiánh² hniah¹² dsa² chianh² jøa³juøi² Corazín quianh¹³ jøa³juøi² Betsaida! Di³ cu²ŋieih¹³ mi³mi¹dsian¹² dsa² chian² jøa³juøi² Tiro quianh¹³ jøa³juøi² Sidón dsǿa¹². Cu²ŋieih¹³ mi³jéinh¹ dsǿa¹²dsa ju³ jøng² ca¹løa¹ juu¹² juøh¹² ja³tiogh³dsa, ju³lah lǿa¹² juu¹² juøh¹² ma²ca¹løa¹ ja³tiogh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hiug¹² hi² tsa¹ué² lé² quiah¹² dsa² chian² ja³jøng² cónh¹ jín³ hniah¹² na³ma²ca¹dsiég¹ jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jøng² hniah¹² dsa² chianh² jøa³juøi² Capernaum, tsa¹ju³lë́h³ hniah¹² hi² mi³juanh¹³ Diú¹³ hniah¹² juu¹² ŋi¹juǿi¹. Di³ juu¹² guio¹juǿi¹ báh³ dsiánh¹dsa hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Jøng² hniah¹² dsa² ton¹lug¹guián² rø²dsǿ² guiúg², ju³ná³ hein² dsa² ca¹nǿng² jǿg³ juúh³ hniah¹², dsa² héi² báh³ ma²ca¹nǿng² jǿg³ quieg¹jni li¹juúh² jǿg³. Jøng² tsa¹hniang¹dsa jní² ju³ná³ tsa¹nang¹dsa jǿg³ juúh³ hniah¹². Jø¹² bíh³ tsa¹hnio¹dsa dsa² ca¹tsei¹ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jøng² dsa² ton¹lug¹guiá² rø²dsø² guiúg² ma²tiogh³ ju²hiúg¹ dsøa¹² mi³ca¹ŋi¹lia¹dsa, ca¹ŋi³téng³dsa jǿg³ hliú² juøi². Ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, ca¹lah¹ca¹tǿ² guiog¹³ jmi²dsí² quiah¹² dsa² hlanh³ ca¹can¹ hí³ jǿg³ quiánh²hning ca¹juúh³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jøng² ca¹juúh² Jesús: ―Ca¹lø¹léi¹³jni cu²ŋieih¹³ ca¹ŋi¹hén² jǿg³ quiah¹² dsa² hlanh³ ju³lah cøng² ca¹táh² cøng² si² ŋíh¹ juu¹² guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jai³lah. Ma²ca¹cuø¹jni bí² hi² ha¹chi² hi² jénh³ hniah¹² ju³ná³ ca¹hah¹³ hniah¹² møh² ho¹ ju³ chi³hniú¹², ho¹ ju³ he² hi² mi³jmógh² dsa² hiag¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cónh¹jøng² tsa¹jmóh³ hniah¹² hiug¹² hioh¹² jénh² hniah¹² ni³ huu¹³ hi² nang¹² jmi²dsí² jǿg³ juúh² hniah¹². Ni³ huu¹³ jøng² báh³ túgh³ hniah¹² hioh¹² jénh² hniah¹², hi² ma²rø²tonh¹² hniah¹² ni³ si² quiah¹² Diú¹³ guiuh¹³ ŋi¹juǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dsø¹juu¹² jøng² ca¹jmo¹ jmi²dsí² han¹³ hi² ca¹gú² Jesús ju²hiúg¹ dsøa¹². Ca¹hlanh¹ Jesús Diú¹³, ca¹juúh²dsa: ―Di³hmah³hning Tiá³, hning² dsa² lanh¹² Juu¹³ dsa² chian² ŋi¹juǿi¹ quianh¹³ dsa² chian² jmøi¹guǿi¹. Ma²ca¹jmoh³hning hi² tsa¹ŋë́h² dsǿa¹² dsa² ŋi¹² ma¹dsio¹² jǿg³ quiah¹² jmøi¹guǿi¹ la². Ma²ca¹heh³ hning² dsa² tsa¹ŋi¹² ma¹dsio¹², dsa² lán¹² ju³lah lán¹² guing². Di³ lah¹jøng² ca¹lø¹hiúg¹ hoh¹²hning, Tiá³. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ju²gug¹jni ma²ca¹dsii¹ ti³ŋieh¹jni ca¹lah¹jǿ¹. Ha¹chian² dsa² ŋi¹² hein² dsa² lán¹² jní². Jmáh¹lah ti³ŋieh¹jni ma²ŋi¹². Jø¹² bíh³ jan² jní², cu¹dsie¹² quianh¹³ dsa² hno¹jni hé¹³jni, ma²ne³ jnieh³ hein² dsa² lán¹² ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa ja³tsa¹lé² nang¹ dsa² siáh²: ―Dsio¹ báh³ quiánh² hniah¹² ni³ huu¹³ hi² ma²ca¹jaih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Di³ jue¹² dsa² ca¹lø¹hniu¹ jái¹ hi² ma²ca¹jaih³ hniah¹², ju³lah rai¹³, ju³lah dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jøng² ha¹chi² ca¹jái¹dsa. Hniu¹dsa nang¹dsa hi² hi² ma²ca¹nengh² hniah¹². Cónh¹jøng² ha¹chi² ca¹nǿng²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jøng² ca¹nung² jan² tøa¹², dsa² he¹² lei¹³ quiah¹² Diú¹³. Hniu¹dsa cán²dsa jǿg³ dsøg¹² quiah¹² Jesús. Jøng² ca¹juúh²dsa: ―Tøa¹², ¿he² hniuh¹² jmo¹³jni, mi³jøng² tan¹jni li¹chian²jni tiá²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jøng² ca¹juúh² Jesús: ―¿He² jǿg³ rø²juúh² lei¹³? ¿He² jǿg³ ma²ca¹híh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jøng² ca¹juúh² dsa² héi²: ―“Mi³hnóh¹hning Juu¹³ jniang³, dsa² lán¹² Diú¹³ quián² jniang³ quianh¹³ ca¹lah¹jǿ¹ hoh¹²hning, quianh¹³ ca¹lah¹jǿ¹ jmi²dsí² quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ ju²bí² quiánh²hning, quianh¹³ ca¹lah¹jǿ¹ hi² dsø²jiag¹² hoh¹²hning. Jøng² mi³hnóh¹hning dsa² jianh¹²hning ju³lah hnóh¹hning hŋiah¹hning,” rø²juúh² lei¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jøng² ca¹juúh² Jesús: ―Té¹² báh³ jǿg³ ma²na²juúh²hning. Jøng² li¹chianh²hning tiá² ju³ná³ ca¹jmoh³hning lah¹lǿa¹² jǿg³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jøng² hniu¹ tøa¹² héi² tsih¹ jǿg³ dsøg¹² quiah¹²dsa. Hi² jøng² ca¹juúh²dsa calah, ca¹tsáih¹dsa Jesús: ―¿Hein² dsa² héi², hi² juúh²dsa: “dsa² jian¹²dsa?” ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jøng² ca¹juúh² Jesús: ―Jan² dsa² dság¹² juu¹² jøa³juøi² Jericó, dsa² ma²jogh¹² juu¹² jøa³juøi² Jerusalén. Jøng² jén²dsa dsa² høin² dsi²juu¹². Jøng² ca¹bú² dsa² høin². Ca¹can¹dsa hi² quin¹²dsa lah¹ma¹quianh¹³ tsǿnh³dsa. Jøng² ca¹cuøin¹ dsa² høin² hi² ja¹lái¹ hiu³ jmi²dsí² quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Cónh¹ tsa¹jŋia¹³ ca¹ŋó¹ jan² jmi²dsa² juu¹² jøng². Jøng² mi³ca¹jë́² jmi²dsa² dsa² ron¹² dsi²juu¹², ca¹tsø³jue¹³dsa jag¹³ juu¹² ca²ton². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jø¹² bíh³ lah¹jøng² jan² dsa² levita, dsa² mi²hog¹³ jmi²dsa², ca¹tsø³jue¹³dsa ca¹jag¹³ juu¹² mi³ca¹dsiég¹dsa ja³jøng², mi³ca¹jǿi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ni³ jøng² ca¹dsiég¹ jan² dsa² chian² ja³tén¹² Samaria. Jøng² ca¹ŋi¹ŋiú² dsǿa¹²dsa mi³ca¹jë́²dsa dsa² ron¹² dsi²juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ca¹ŋó¹dsa cøg¹². Ca¹séi²dsa nang³ rø²guia¹² vino ja³uai¹² quiah¹² dsa² héi². Jøng² ca¹hŋiéng²dsa quianh¹³ tsø³hmøah¹². Ni³ jøng² ca¹chiog¹dsa dsa² dsoh³ juu¹² cah³ jáh² quián¹²dsa. Ca¹jiag¹dsa juu¹² ja³ca¹møa¹dsa cøng² neng¹² hniú¹², ja³ca¹jmo¹dsa hí³. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mi³ca¹jni¹ ca¹dsi¹dsa cónh¹ guiég² héh¹ cog³, ca¹cuúh¹dsa dsa² hniu³. Ca¹juúh²dsa: “Jmo³ hí³ dsa² lang¹². Jøng² cǿa¹³jni na³ma²guønh¹jni calah, chi²júh² ha²cónh¹ cog³ ma²ca¹hénh¹hning,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jøng² ¿naih¹² dsa² quianh¹³ dsa² úg², dsa² ca¹mi¹léi¹³ hi² lán¹²dsa dsa² jian¹² dsa² ca¹jmóh² dsa² høin²? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","―Dsa² ca¹jmo¹ huø³ dsǿa¹² báh³ héi² ―ca¹juúh² tøa¹². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa tøa¹²: ―Lah¹jøng² gu³jmoh³hning calah ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mi³ma²dsa²lé²dsa calah, ca¹dsi¹lé²dsa cøng² juøi². Ja³jøng² ca¹hiei¹ jan² hio¹³ tsen² Marta. Jøng² ca¹hí¹ Jesús dsi²neí² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jøng² ca¹gú² María, roh¹³ Marta, cøg¹² ja³guǿ¹³ Jesús. Nang¹² María ca¹lah¹jǿ¹ jǿg³ hi² juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jøng² ca¹ŋi¹méh¹ dsǿa¹² Marta. Di³ ma¹dsio¹² ta³ chi² quiah¹²dsa dsi³si². Ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Ti³guiuh¹³, ¿tsa³tónh²hning juu¹² hi² ma²na²tiáng² roh¹²jni, hi² ma²jmo¹²jni ta³ cu³hŋiéng¹jni? Juaih¹³ hning² dsa² hi² mi¹hag¹³dsa jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jøng² ca¹juúh² Jesús: ―Marta, hiug¹² jín³ ma²chianh²hning ju²hí³ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cøng² báh³ hi² hniuh¹² jmóh³hning. Lah¹jøng² ma²jmo¹² María. Jøng² ha¹chi² juǿi³jni dsa² hi² tsa¹ma¹jmo¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hiúg³ Jesús cøng² ja³mi³hlanh¹²dsa Diú¹³. Jøng² mi³ma²na²jŋi¹dsa, ca¹juúh² dsa² quianh³dsa: ―Juu¹³ jniang³, heh³ jnieh³ ha²lah hlanh¹³ jnieh³ Diú¹³, ju³lah ca¹heh¹ Juan dsa² mi³quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jøng² ca¹juúh² Jesús: ―Lah¹la² juúh³ hniah¹² ja³hlanh¹³ hniah¹² Diú¹³: Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹, Dsa² han¹³ báh³ hning². Ju³ji² ja³jmóh³hning héh¹. Ju³jmóh³hning hi² hiug² hoh¹²hning ni³ guøh³ ni³ huø¹ la², ju³lah jmoh²hning ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuúh³hning hi² quie¹³ jnieh³ lah¹cøng² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Hén¹ dsag³ quián² jnieh³. Di³ ma²ca¹hén³ jnieh³ dsag³ ma²ca¹jmo¹ dsa² jmøi¹guǿi¹ ja³cog² jnieh³. Tsa¹jiag¹² jnieh³ juu¹² ja³tiáh¹ jnieh³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jøng² ca¹juúh² calah Jesús: ―Ju³ná² jan² dsa² chian² dsa² jenh² quianh¹³dsa, jøng² ŋǿ¹²dsa ja³quiah¹³ dsa² héi² cónh¹ dsi¹neng¹², hi² juúh²dsa: “¿Tsa³mi³dsíh²hning hnøa¹² hé¹², ha²mei¹³? ");
INSERT INTO cpaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Di³ ma²na²guøn¹ jan² ha²mei¹³ quian¹jni ja³quieg¹, dsa² hiúg³ juu¹². Jøng² ha¹chi² chi² hi² li¹cuøh¹³jni dsa² hi² gǿh¹dsa.” ");
INSERT INTO cpaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jøng² juúh² dsa² hniu³: “Tsa¹cuu² ju²méh³ dsøa¹². Ma²na²jnái¹ báh³ hniú¹². Ma²rø²quian¹jni quieg¹ quianh¹³ guiéng¹. Tsa¹lé² nung¹³jni cuø¹³jni hé¹²,” juúh² dsa² hniu³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ tsa¹ca¹nung²dsa, ni³ huu¹³ hi² lán¹² dsa² héi² ha²mei¹³ quián¹²dsa, cónh¹jøng² tiog¹³ báh³ nung¹dsa. Mi³jøng² tsa¹ma¹cuø¹ dsa² héi² ju²méh³ dsøa¹². Jøng² cuúh¹dsa dsa² hi² hniu¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hi² jøng² juǿi²jni hniah¹²: Ŋieh¹ báh³ hniah¹² na³ca¹møah³ hniah¹². Dsianh¹² báh³ hniah¹² na³ca¹hniangh² hniah¹². Nií¹ báh³ dsa² na³ca¹teh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Di³ ŋë² báh³ ca¹lah¹já¹ dsa² møa¹². Dsóh² báh³ dsa² hnangh². Nií¹dsa quiah¹² dsa² tǿ². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ju³ná³ hein² dsa² lah¹hniah¹², ca¹më¹ tsih² quiánh² hniah¹² jáh² tiogh³ jmøi², tsa¹cuanh¹³ hniah¹² møh², liáh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ho¹ ju³ ca¹møa¹tsih jløi², tsa¹cuanh¹³ hniah¹² chi³hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jøng² chi²júh² ma²ŋih³ hniah¹² ha²lah cuúh³ hniah¹² hi² dsio¹ quiah¹² tsih² guing², hniah¹² dsa² ti³reh² dsag³, jøng² hiug¹² jín³ cuø¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹, jmi²dsí² han¹³ quiah¹² dsa² møa¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jøng² ma²ca¹jmo¹ jmi²dsí² quiah¹² dsa² hlanh³ hi² ca¹jénh² jan² dsa² ŋioh¹² dsa² cag³. Jøng² mi³ca¹dsi¹ Jesús jmi²dsí² hlaih¹³, ca¹hløah¹ báh³ dsa² ŋioh¹². Dsogh¹² dsǿa¹² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jøng² ca¹juúh² ca²dsiog³dsa: ―Huø¹² dsa² lang¹² jmi²dsí² hlaih¹³ quianh¹³ bí² hi² cuø¹² Beelzebú², dsa² lán¹² juu¹³ jmi²dsí² hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jøng² ca¹møa¹ ca²dsiog³dsa calah hi² jmo¹ Jesús juu¹² juøh¹², hi² cán²dsa jǿg³ dsøg¹² quiah¹² Jesús, chi²júh² quianh¹³dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cónh¹jøng² ma²ŋi¹² Jesús he² jǿg³ dsø²jiag¹² dsǿa¹²dsa. Jøng² ca¹juúh²dsa: ―Dsa¹hén² báh³ lǿa¹² ju³ he² juøi² ja³tsa¹tiogh³ dsa² juøi² cøng² jǿg³. Jø¹² bíh³ lah¹jøng² tsa¹lǿ² tiogh³dsa dsio¹ dsi²néi² ja³cø²tsë¹² dsa² hniu³ guiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hi² jøng² dsa¹hén² jǿg³ quiah¹² Satanás ju³ná³ tá¹²dsa quianh¹³ dsa² quián¹²dsa. Di³ juúh² hniah¹² huø³jni jmi²dsí² quianh¹³ bí² hi² cuø¹² Beelzebú. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Hein² dsa² cuø¹² bí² hi² huø¹² dsa² quiánh² hniah¹² jmi²dsí² hlaih¹³, chi²júh³ juúh² hniah¹² cuø¹² Beelzebú bí² ja³jmo¹² jní² lah¹jøng²? Guiog¹³ dsa² quiánh² hniah¹² báh³ mi²léi¹³ tsa¹dsøg¹² jǿg³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hŋiah¹² Diú¹³ báh³ dsa² cuø¹² bí² hi² huø³jni jmi²dsí² hlaih¹³. Hi² jøng² ma²ŋih³ hniah¹² ma²tǿ² ja³jmo¹ Diú¹³ héh¹ ni³ jmøi¹guǿi¹ la² ja³tiagh³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ma²tioh¹³ hí³ ca¹lah¹jǿ¹ quiah¹² dsa² bé² chi²júh² ma²tsenh¹²dsa ju²jŋia¹³ ja³dsi¹² quiah¹²dsa, chinh¹²dsa ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Cónh¹jøng² ju³ná³ ca¹dsiég¹ jan² dsa² bé² hi³méh¹ cónh¹ jín³ dsa² hniu³, ju³ná³ ca¹tiúh¹dsa quianh¹³dsa, jøng² jŋíh² dsa² héi² ŋí³ mi³chinh¹²dsa, jøng² dsiúh¹dsa hi² chi² quiah¹² dsa² hniu³, hi² cuúh¹dsa dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ju³ná³ hein² dsa² tsa¹hiúg³ quianh¹³ jní², dsa² héi² ma²hiúg³ quianh¹³ dsa² hiag¹³. Ju³ná³ hein² dsa² tsa¹mi¹hag¹³ hi² li¹quianh¹³ jní² dsa² jue¹², dsa² héi² jmo¹² dsa¹lé² dsa² jue¹² héi² juu¹² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Na³ma²ca¹u¹hái¹ cøng² jmi²dsí² quiah¹² dsa² hlanh³ hi² mi³quin¹² dsa², jøng² ŋó¹² jmi²dsí² juu¹² ja³quing², ŋi³hniangh¹² jmi²dsí² cøng² ja³li¹jŋi¹. Jøng² ju³ná³ tsa¹ca¹dságh¹ jøng², lë́² jmi²dsí²: “Neh¹³jni juu¹² ja³mi³guø³jni,” lë́² jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jøng² na³ma²ca¹dsiánh¹ jmi²dsí² ja³tsenh¹³ dsa² mi³quin¹², jái¹² jmi²dsí² ma²lǿa¹² dsǿa¹² dsa² héi² ju³lah lǿa¹² cøng² hniú¹² ma²rø²hieh¹³ dsi²néi², ma²lǿa¹² dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jøng² dság¹² jmi²dsí². Dsa¹tei¹³dsa guio¹ jmi²dsí² hlaih¹³ hi³méh¹ cónh¹ hi² hŋiah¹²dsa. Jøng² dsa¹tiogh¹² jmi²dsí² cu²dsie¹² quiah¹² dsa² mi³quin¹². Jøng² ué² hi³méh¹ lé² quiah¹²dsa ca¹lah¹cónh¹ hi² mi³lǿa¹³ lah¹jiá¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ma²chi³hløah¹² Jesús jǿg³ jøng², mi³ca¹hløah¹ tí² jan² hio¹³ hiúg³ quianh¹³ dsa² jue¹², ca¹juúh² hio¹³: ―¡He³ báh³ dsio¹ quiah¹² dsa² ca¹can¹ hning², dsa² ca¹cuø¹ dsiuh³ ca¹cǿgh¹hning! ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jøng² ca¹juúh² Jesús: ―Cónh¹jøng² dsa² héi² báh³ dsa² dsio¹ quiah¹², dsa² nang¹² jǿg³ quiah¹² Diú¹³. Jøng² mi²ti¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma²ŋi¹jué² dsa² tiogh³ quianh¹³ Jesús. Jøng² ca¹juúh² Jesús: ―Dsa² hlanh³ báh³ dsa² chian² na¹. Jmáh¹lah juu¹² juøh¹² báh³ møa¹²dsa. Cónh¹jøng² cøng² juu¹² juøh¹² jøng² báh³ jái¹dsa, juu¹² juøh¹² lǿa¹² ju³lah ca¹løa¹ quiah¹² hlai³ Jonás. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Di³ lah¹jøng² báh³ lén²jni ja³cog² dsa² chian² na¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah ca¹lán¹ hlai³ Jonás ja³cog² dsa² chian² Níneve. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nung¹ báh³ hio¹³ rai¹³ dsa² chian² huø¹ ta¹lah¹sur jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Cuø¹ hio¹³ dsag³ quiah¹² dsa² chian² na¹. Di³ uǿin² hlaih¹³ ca¹já¹ hio¹³. Mi³jøng² ca¹nǿng²dsa jǿg³ ma¹dsio¹² ma²ŋi¹² hlai³ Salomón. Jai³lah. Dsa² juanh¹² hi³méh¹ cónh¹ jín³ hlai³ Salomón ma²tsenh¹² la². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jøng² tógh¹ calah dsa² chian² Níneve jmai³ ja³cán² Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² chian² na¹. Jøng² cuúh¹dsa dsa² dsag³. Di³ ca¹jéinh¹ báh³ dsǿa¹² dsa² chian² ja³jøng² jmai³ ca¹hǿ² hlai³ Jonás jǿg³ quiah¹² Diú¹³. Jǿng² jai³lah. Dsa² juanh¹² jín³ cónh¹ hlai³ Jonás ma²tsenh¹² la². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ha²chian² dsa² hma¹² si² jmøi² cøg² na³ma²ca¹te¹dsa si². Tsa¹jlǿ²dsa quianh¹³ tøh¹². Guiuh¹³ hai¹²dsa si². Mi³jøng² jní² quiah¹² dsa² dsa¹tiogh¹² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lǿa¹² mø³neih³ hniah¹² ju³lah lǿa¹² si² jmøi² cøg². Cu²rø² jáih² hniah¹² ju³ná³ dsio¹ mø³neih³ hniah¹². Cónh¹jøng² ŋi²nioh³ hniah¹² lah¹cøng² ja³neng² ju³ná³ tsa¹dsio¹ mø³neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hi² jøng² dsio¹ jmóh³ hniah¹² hí³, ju³ jøng² ca¹mi¹gag¹² jǿg³ ma²ŋih³ hniah¹², ju³ jøng² ca¹ŋi¹jiag¹² juu¹² siíh². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ju³ná³ lah¹dsóh² lanh¹² hniah¹² dsa² chian² ja³taih¹² ja³jní³, jøng² cu²rø² ma²jáih² hniah¹² ha²lah lǿa¹² jǿg³, ju³lah jan² dsa² tsenh¹² ja³taih¹² si² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mi³ma²na²dsii¹ Jesús jǿg³ jøng², ca¹tǿh¹ jan² dsa² fariseo hi² dsa¹gǿh¹ Jesús ja³quiah¹³dsa. Jøng² ca¹ŋó¹ Jesús. Ca¹ŋi¹gú²dsa mesa ja³quiah¹³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jøng² dsogh¹² dsǿa¹² dsa² fariseo héi². Di³ ha¹chi² ma²na²rang¹ Jesús gug² niúh¹ jín³ hi² gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jøng² ca¹juúh² Juu¹³ jniang³, ca¹tsáih¹dsa dsa² héi²: ―Hniah¹² dsa² fariseo, cu²rø² rangh² hniah¹² coh¹³ cuøh³ quianh¹³ coh¹³ uøin¹². Cónh¹jøng² jmáh¹lah jǿg³ hlaih¹³ ma²dsø²jiag¹² hoh¹² hniah¹² ha²lah léh² hniah¹² hi² chi² quiah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tsa¹juøi² hoh¹² hniah¹². Jan² báh³ Diú¹³, dsa² ca¹jmo¹ jmø²ŋǿ¹² quianh¹³ jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Quianh¹³ jmi²dsí² quiánh² báh³ hniah¹² ŋi³nioh³ hniah¹² ja³ta¹ni¹ Diú¹³. Jøng² báh³ lé² ti³jai¹ ca¹lah¹jǿ¹ ja³cogh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo! Di³ cu²rø² cuuh² hniah¹² hi² dsiúg³ Diú¹³ ja³ma²guie¹ ca¹lah¹cónh¹ ja³té¹² ca¹lah¹i³ ni³ nung² chi² quiánh² hniah¹², ju³lah høg² ruda, quianh¹³ u²mong³ quiah¹² ca³juu². Cónh¹jøng² ha²chi² hnøngh² hniah¹² jǿg³ rø². Ha²chi² hnóh¹ hniah¹² Diú¹³ lah¹dsóh². Hiug¹² jín³ hi² quin¹² hi² jøng² cónh¹ jín³ hi² ma²mi²tih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² fariseo! Hnøngh² hniah¹² túgh³ hniah¹² ja³jláh³ dsi²néi² guøh¹². Hnøngh² hniah¹² hi² mi¹juanh¹² dsa² juøi² hniah¹² ja³ŋi²nioh³ hniah¹² jøa³hmah³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡He³ báh³ ué² lé² quiánh² hniah¹²! Lanh¹² hniah¹² ju³lah lǿa¹² cøng² ja³rø²hog¹² hlai³, hi² ma²rø²jlái². Tsa¹ŋi¹² dsa² ŋi²nio³ quianh¹³ hniah¹² hi² ma²tioh¹³ hi² hlaih¹³ tø²hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jøng² ca¹juúh² jan² tøa¹² he¹² lei¹³ quiah¹² Diú¹³, ca¹tsáih¹dsa Jesús: ―Tøa¹², jǿg³ hlaih¹³ chi²hiah¹²hning jnieh³ calah, hi² juúh²hning lah¹jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jøng² ca¹juúh² Jesús: ―Jø¹² bíh³ lah¹jøng², ué² lé² quiánh² hniah¹², dsa² lanh¹² tøa¹² quiah¹² lei¹³. Di³ ué² jmoh² hniah¹² quiah¹² dsa² siáh², dsa² hniu¹ mi¹ti¹ lei¹³. Jøng² ha¹chi² mi²tih³ hniah¹² guiogh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡He³ báh³ ué² lé² quiánh² hniah¹²! Di³ tsǿh² hniah¹² hieh¹² ja³ma²rø²hog¹² dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih², dsa² ca¹mi¹dsian¹² dsa² canh¹³ quiánh² hniah¹² guiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hi² jøng² mi²leih¹³ hniah¹² hi² hiug² hoh¹² hniah¹² hi² ca¹jmo¹ dsa² canh¹³. Ca¹mi¹dsiag¹² dsa² canh¹³. Jøng² hniah¹² ma²tsǿh² hieh¹² ja³rø²hog¹² dsa² ca¹mi¹dsian¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Hi² jøng² ma²ŋi¹² Diú¹³ ha²lah lǿa¹² mi³ca¹juúh²dsa jǿg³ la²: “Tsë́³jni dsa² hǿ² jǿg³ quieg¹jni quianh¹³ tsih² dsa² høh³. Jøng² mi¹dsian¹² dsa² jmøi¹guǿi¹ ca²dsiog³dsa. Cuúh¹dsa ca²dsiog³dsa jmø³uai¹²,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jøng² ta¹canh¹³ dsa² chian² na¹ dsag³ hi² ca¹dsan¹ ca¹lah¹já¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ca¹lah¹cónh¹ jmai³ lah¹ni³ hi² ca¹niu¹ jmøi¹guǿi¹, ");
INSERT INTO cpaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ca¹lah¹cónh¹ jmai³ ja³ca¹jŋëh¹dsa hlai³ Abel ca¹tǿ² jmai³ ja³ca¹jŋëh¹dsa hlai³ Zacarías, dsa² ca¹jon¹ jøa³ ja³tsih¹³ guøh¹² ca¹lah¹quianh¹³ ni³hiég². Lah¹dsóh² juøi²jni hniah¹², dsa² chian² na¹ báh³ ta¹canh¹³ dsag³ hi² ca¹dsan¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡He³ báh³ ué² lé² quiánh² hniah¹², dsa² lanh¹² tøa¹² quiah¹² lei¹³! Tsa¹heh¹² hniah¹² cu²rø² lei¹³, mi³jøng² tsa¹li¹ŋi¹² dsa² juøi² ha²lah lǿa¹² jǿg³ quiah¹² Diú¹³. Guiogh¹³ báh³ hniah¹² tsa¹ŋih³ ha²lah lǿa¹². Jøng² tsa¹hnøngh² hniah¹² li¹ŋi¹² dsa² siáh² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma²hiag¹³ tøa¹² quiah¹² lei¹³ quianh¹³ dsa² fariseo mi³ca¹gu¹hái¹ Jesús ja³jøng². Ma¹dsio¹² jǿg³ ca¹ŋǿh¹dsa Jesús, ");
INSERT INTO cpaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","di³ jái¹²dsa chi²júh² ca¹juúh² Jesús jǿg³ siíh². Mi³jøng² ta¹canh¹³ Jesús dsag³, lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jmai³ jøng² ta¹lah¹mei¹³ dsa² ma²tiogh³ quianh¹³ Jesús, ca¹lah¹ma²u²tsúh²dsa roh¹³dsa. Jøng² lah¹ni³ ca¹dsii¹dsa jǿg³ quianh¹³ dsa² quianh³dsa, ca¹juúh²dsa: ―Jmo² hí³, mi³jøng² tsa¹cánh³ hniah¹² mai³¹ hlaih¹³ quiah¹² dsa² fariseo. Di³ lán¹² dsa² héi² dsa² tø¹cah¹ tø¹jen¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Li¹léi¹³ ca¹lah¹jǿ¹ jǿg³ chi³jnøa¹². Jií¹ jmai³ ja³jni¹ jǿg³ ma²rø²hma¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Li¹chi² jǿg³ ja³jní³, ju³lah ca¹lah¹jǿ¹ jǿg³ ma²ca¹juøh³ hniah¹² ja³tsa¹jní². Li¹chi² jǿg³ ta³cøng² juøi², ju³lah jǿg³ ma²ca¹juøh³ hniah¹² ja³cu³guiogh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Lah¹dsóh² juǿi²jni hniah¹², dsa² quianh¹³jni, tsa¹jmóh³ hniah¹² ganh¹ hniah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah dsa² tiúh¹ mi¹dsian¹² hniah¹² jmáh¹lah ni³ jmøi¹guǿi¹ la², ni³ jøng² ha¹chi² hi² ma¹li¹jmo¹dsa ja³cogh² hniah¹² na³ma²ca¹dsanh¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dsa² héi² lé² jmóh³ hniah¹² ganh¹, dsa² tiúh¹ tiáng² juu¹² guio¹juǿi¹ na³ma²ca¹dsanh¹dsa hniah¹². Dsa² héi² lé² jmóh³ hniah¹² ganh¹, juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Jmáh¹lah ton¹ cog³ báh³ quien¹² cónh¹ hŋiá² tan¹² píh³. Cónh¹jøng² ca¹lah¹jin³ hein² jáh² héi² tsa¹dsø¹hén² dsǿa¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jai³lah. Ma²ŋi¹² báh³ Diú¹³ ha²cónh¹ hmëh¹² jŋiu² ti³dsøa¹³ dseih¹² hniah¹² lah¹jan² lah¹jan² hniah¹². Jøng² tsa¹jmóh³ hniah¹² ganh¹. Hiug¹² jín³ hi² quien¹² hniah¹² ja³cog² Diú¹³ cónh¹ jín³ jue¹² tan¹² píh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Jøng² juǿi²jni hniah¹², ju³ná³ hein² dsa² ca¹mi¹quianh¹³ jní² ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jian¹²dsa, dsa² héi² mi³quianh¹³ jní² calah ja³ta¹ni¹ ángeles quián¹² Diú¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cónh¹jøng² ju³ná³ hein² dsa² tsa¹ca¹mi¹jni¹ jǿg³ jøng² ni³ jmøi¹guǿi¹, jǿg³ quiah¹² dsa² héi² ha¹chi² li¹jni¹ calah ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Dsa¹hén² báh³ dsag³ quiah¹² ju³lah hein² dsa² ca¹chi¹hei¹ jní² jǿg³ hlaih¹³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cónh¹jøng² ha¹chi² dsa¹hén² dsag³ quiah¹²dsa, ju³ná³ ca¹hia¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³ jǿg³ hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Jøng² ju³ná³ ca¹jian¹ dsa² hiag¹³ hniah¹² ja³ta¹ni¹ dsa² neng¹² ni³ jǿg³ quiah¹² guøh¹², quianh¹³ dsa² ta³, quianh¹³ dsa² quin¹² ni³ juøi², tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² he² jǿg³ jeinh³ hniah¹² quianh¹³dsa, he² jǿg³ juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Di³ he¹ báh³ jmi²dsí² han¹³ jmai³ jøng² he² jǿg³ dsio¹ juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jøng² ca¹juúh² jan² dsa² hiúg³ quianh¹³ dsa² jue¹², ca¹tsáih¹dsa Jesús: ―Tøa¹², juaih¹³hning roh¹²jni, mi³jøng² jmo¹dsa ma¹méh¹ quianh¹³ jní² hi² mi³chi² quiah¹² hlai³ ti³ŋieh¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jøng² ca¹juúh² Jesús: ―¿Hein² ca¹juúh² hi² lén² jní² dsa² mi¹rø¹² jǿg³ quiánh² hniah¹², dsa² dsiúh¹ hi² mi³chi² quiah¹² hlai³? ");
INSERT INTO cpaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² jue¹²: ―Jmo³ hí³, mi³jøng² tsa¹jø³neh³ hniah¹². A¹jáng¹ lah¹jøng² quien¹² quián² jniang³, hi² li¹chi² ma¹dsio¹² quián² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jøng² ca¹dsii¹ Jesús jǿg³ ti³jnøa¹², ca¹juúh²dsa: ―Jan² dsa² chi² cog³, lø²chi² hlaih¹³ jøa³nung² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jøng² ca¹hnangh²dsa dsǿa¹²dsa: “¿He² jmo¹³jni? Di³ ha¹chi² chi² ja³li¹toh¹³jni hi² li¹chi² jøa³nung² quieg¹jni,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jøng² ca¹juúh²dsa: “Lah¹la² jmo¹³jni: Cu¹dsie¹² jøah¹³jni hniú¹² ja³ma²ca¹tóh²jni cuøi². Jøng² jmoh¹³jni hniú¹² cah³ hi³méh¹ ja³tóh³jni cuøi² quianh¹³ ca¹lah¹jǿ¹ hi² chi² quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jøng² juǿi³jni jmi²dsí² quieg¹jni hi² ma²chi² ca¹lah¹jǿ¹ hi² hniuh¹² hi² jiag¹² quianh¹³ hliú² ji²ŋi². Ma²lé² guø³jni ju²hiúg¹ dsøa¹², hi² cøh³ gøah¹³jni hi² ma²chi² quieg¹jni. Ha¹chi² ta³ ma¹jmo¹³jni,” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jøng² ca¹juúh² Diú¹³, ca¹tsáih¹dsa dsa² héi²: “Tsa¹juøi² hoh¹²hning, dsa² ŋioh¹². Di³ na¹ ja³neng² dságh¹ jmi²dsí² quiánh²hning. ¿Jin³ hein² li¹quiah¹² jøng² hi² ma²ca¹jmoh³hning ju²jŋia¹³?” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Lah¹jøng² lǿa¹² quiah¹² dsa² dsii¹² loh² ma¹dsio¹² quiah¹² jmáh¹lah ni³ jmøi¹guøi¹ la², ju³lah dsa² tsa¹ca¹hnangh² mai³¹ ha²lah mi³li¹chi² quiah¹²dsa ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Hi² jøng² juǿi²jni hniah¹², tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² ha²lah chianh² hniah¹², he² cǿh³ hǿgh³ hniah¹², he² hi² cáih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma¹dsio¹² quien¹² jmi²dsí² quiánh² hniah¹² cónh¹ jín³ hi² jøng², hi² cøgh² høgh², hi² quieih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jai³lah ha²lah lǿa¹² quiah¹² tsei³. Tsa¹jne²jah cuøi². Tsa¹huǿi²jah cuøi². Ha¹chi² hniú¹² chi² ja³li¹tóh¹jah hi² gǿh¹jah. Cónh¹jøng² cuø¹² báh³ Diú¹³ hi² gøah¹²jah. Jøng² hiug¹² jín³ ma¹dsio¹² quienh¹² hniah¹² ja³cog² Diú¹³ cónh¹ jín³ jáh² han¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ha¹chi² ta³ jmo¹ hi² jmóh³ hniah¹² ju²hí³ dsøa¹². Tsa¹jmo¹ lahjøng² hi² li¹chianh² hniah¹² jin³ cøng² jmai³ uú² hi³méh¹ cónh¹ jín³ ja³ca¹cuø¹ Diú¹³ ju²bí². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ju³ná³ tsa¹lé² jmóh³ hniah¹² cøng² hi² mih² lah¹jøng², jøng² tiúh¹ báh³ tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² hi² siíh² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jai³lah ha²lah lǿa¹² lí³ san² u²søa¹³. Ha¹chi² ta³ jmo¹² lí³. Tsa¹ta¹² lí³ tá². Cónh¹jøng² hiug¹² jín³ hi² dsio¹ jní² lí³ cónh¹ jín³ hmøah¹² jláh³ mi³quieih¹² hlai³ Salomón. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hiug¹² jín³ jláh³ hi² quienh¹² Diú¹³ nung² ti³dsøa¹² jøa³nung². Jøng² tsa¹hai² jøn¹dsa mi³jøng² quiég¹. Hi² jøng² ma²ŋih³ hniah¹² hiug¹² jín³ dsi¹³ juu¹² hi² cuø¹ Diú¹³ hi² cáih³ hniah¹², dsa² ja¹lái¹ héh² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tsa¹jmóh³ hniah¹² ju²hí³ dsøa¹² hi² cǿh³ hǿgh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dsa² tsa¹cue¹² Diú¹³ báh³ dsa² dsø²jiag¹² dsǿa¹² jmáh¹lah jǿg³ jøng². Ma²ŋi¹² báh³ Jmi² jniang³ hi² hniuh¹² lah¹jøng² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cøng² hi² jøng² jmóh³ hniah¹² hoh¹², ha²lah ŋi³nioh³ hniah¹² juu¹² ja³jmo¹² Diú¹³ héh¹. Jøng² li¹chi² báh³ ca¹lah¹jǿ¹ hi² jøng² quiánh² hniah¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Tsa¹jmo² ganh¹, dsa² quian¹jni. Di³ hiug² dsǿa¹² Jmi² jniang³ cuø¹dsa hi² ŋi³nioh³ hniah¹² ja³jmo¹²dsa héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dsio¹ hnǿih³ hniah¹² hi² chi² quiánh² hniah¹². Dsio¹ cuúh³ hniah¹² mih² quiah¹² dsa² ti²ŋié². Jmo³ hi² li¹chi² quiánh² hniah¹² hi² tsa¹li¹hǿg². Ŋi¹juǿi¹ dsiíh³ hniah¹² loh² cøng² hi² dsio¹ hi² tsa¹dsii¹ quiánh² hniah¹², ja³tsa¹dsiég¹³ dsa² høin², ja³tsa¹hén² jáh². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Di³ ja³jøng² báh³ lø²hiug² hoh¹² hniah¹², ha² ja³ma²neng¹² loh² hi² dsio¹ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Túgh³ hniah¹² ju²jŋia¹³, hi² ma²chi²hiúh² si² jmøi² cøg² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jmo³ ju³lah jmo¹² dsa² chi³jŋia¹² juu¹³, ja³jiúgh² juu¹³dsa jmai³ quiah¹² dsa² ca¹jenh² gug², mi³jøng² nií¹dsa hniú¹² dsø¹juu¹² na³ma²tǿ²dsa hag³hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dsiog¹ báh³ dsa² ma²ti³ne¹³ na³ma²guønh¹²jni, jní² dsa² lán¹² Juuh² hniah¹². Di³ lah¹dsóh² juǿi²jni hniah¹²: Jmo¹³jni ju²jŋia¹³. Jøng² jmo¹³jni hi² túgh³ hniah¹² mesa. Mi³ti³ báh³ jní² neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ju³ lah¹la² guiogh¹³jni cónh¹ dsi¹neng¹², ho¹ ju³ cónh¹ nioh¹² hi³méh¹, cónh¹jøng² dsio¹ lé² quiah¹² dsa² quian¹jni, dsa² dsianh¹²jni hi² ma²ti³ne¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma²ŋih³ hniah¹² ha²lah lán¹² dsa² hniu³. Ju³jøng² ca¹lø¹ŋi¹² dsa² hniu³ he² hora jií¹ dsa² høin², jøng² mi³gú¹dsa ju²jŋia¹³, mi³jøng² tsa¹mi³hí¹ dsa² høin² dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jø¹² bíh³ lah¹jøng² hniah¹², hi² hniuh¹² túgh³ hniah¹² ju²jŋia¹³. Di³ guiogh¹³ báh³ jní² cónh¹ tsa¹ju²jŋiá³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, ¿Juaih¹³hning jmáh¹lah jnieh³ jǿg³ jøng², ho¹ juaih¹²hning ca¹lah¹já¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jøng² ca¹juúh² Juu¹³ jniang³: ―¿Hein² dsa² lán¹² dsa² ti³té¹³ jǿg³, dsa² ŋi¹², ju³lah dsa² ma²neng¹² gug² tai³ ta³ ma²ca¹cuø¹ juu¹³dsa, hi² dsiúh¹dsa hi² gǿh¹ dsa² quián¹² juu¹³dsa na³ma²ca¹tǿ² hora? ");
INSERT INTO cpaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dsa² héi² báh³ dsa² lé² dsio¹ quiah¹², dsa² ma²mi²ti¹ ta³ na³ma²guønh¹² juu¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lah¹dsóh² juǿi²jni hniah¹², ju²gug² tai³ dsa² lah¹héi² báh³ dsii¹ juu¹³dsa ca¹lah¹jǿ¹ hi² chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jøng² ju³ná³ lë́² dsa² ŋioh¹² neng¹² gug² tai³ ta³ quiah¹² juu¹³dsa hi² li¹han³ juu¹³dsa, jøng² qui¹jmóh²dsa uai¹² dsa² tiogh³ jmo¹² ta³ quiah¹² juu¹³dsa, ju³lah dsa² ŋioh¹² quianh¹³ dsa² hio¹³. Jøng² ma²cø² ma²hǿnh²dsa. Ma²lø²hen¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jiúgh² juu¹³ dsa² ŋioh¹² héi² cónh¹ tsa¹ju²jŋiá³, jmai³ ja³tsa¹lë́² dsa² ŋioh¹² jiúgh²dsa. Guønh¹dsa hora tsa¹ŋi¹² dsa² ŋioh¹². Jøng² cuø¹ juu¹³dsa ju²lih¹³ dsøa¹². Tiagh¹dsa juu¹² ja³tiogh³ dsa² tsa¹ca¹mi¹ti¹ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Jøng² jmø³uai¹² tsa¹tiá² cán² dsa² ŋioh¹² ju³ná³ tsa¹ca¹jmo¹dsa ju²jŋia¹³, ju³ná³ tsa¹ca¹mi¹ti¹dsa jǿg³ ma²ŋi¹²dsa quiah¹² juu¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jøng² mih² jmø³uai¹² cán³ dsa² tsa¹ca¹mi¹ti¹, ju³ná³ tsa¹ca¹lø¹ŋi¹²dsa jǿg³. Ju³ná³ neng¹² ma¹dsio¹² ta³ gug² tai³ jniang³, hniuh¹² mi³ti³ jniang³ ca¹lah¹jǿ¹. Ma¹dsio¹² møa¹ Juu¹³ jniang³ ja³cog² jniang³, ju³ná³ ma¹dsio¹² ta³ ma²ca¹dsii¹dsa ju²gug² tai³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ca¹guio¹jni hi² mi³dsíg³jni dsǿa¹² dsa² jmøi¹guǿi¹, ju³lah jan² dsa² tí² si². Mi³hno¹jni ju³jøng² lah¹cøng² hi² ma²hiu³ si². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hniuh¹² can³jni jmø³uai¹² ma¹dsio¹². Jøng² quin³jni ju²hí³ dsøa¹² ca¹lah¹ca¹løa¹ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tsa¹ju³lë́h³ hniah¹² hi² ca¹guio¹jni mi³jøng² niu¹ tei³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹. Ca¹guio¹jni mi³jøng² túgh³ hniah¹² ma¹quién¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jøng² ta¹lah¹ni³ ja³já¹³ la² ja³tiogh³ hŋiá² dsa² cøng² hniú¹², túgh³ úg²dsa ma¹quién¹ quianh¹³ og¹dsa, hi² túgh² og¹dsa ma¹quién¹ quianh¹³ úg²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ma¹quién¹ túgh³ ti³jmi²dsa quianh¹³ ja³ŋiúh³dsa. Ja³ŋiúh³dsa túgh² ma¹quién¹ quianh¹³ ti³jmi²dsa. Ma¹quién¹ túgh² mi³chiég³dsa quianh¹³ ja³mái¹³dsa. Ja³mái¹³dsa túgh² ma¹quién¹ quianh¹³ mi³chiég³dsa. Ma¹quién¹ túgh³ mø¹chiég³dsa quianh¹³ lo¹³dsa. Lo¹³dsa túgh² ma¹quién¹ quianh¹³ mø¹chiég³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jø¹² bíh³ lah¹la² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² jue¹²: ―Ju³ná³ ma²jáih² hniah¹² hi² ma²tsøg² jneng¹² ta¹lah¹juu¹² ja³tø²dsén³ hieg², jøng² juúh² hniah¹² hi² jií¹ jmǿa¹². Jøng² lǿ² báh³ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jøng² ju³ná³ ma²lø²leh¹³ hniah¹² ma²já¹² dsí² juu¹² ta¹lah¹sur jøng² juúh² hniah¹² dsíg² niu¹. Jøng² lǿ² báh³ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hniah¹², dsa² tø¹cah¹ tø¹jen¹², ma²ŋih³ hniah¹² ha²lah lǿa¹² ni³ huø¹ quianh¹³ guiuh¹³ jmøi¹guǿi¹. ¿Ha²lah lǿa¹² jøng² tsa¹ŋih³ hniah¹² ha²lah ma²lǿa¹² jøa³ ja³tiogh³ hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿He² løa¹ tsa¹hnǿngh³ hniah¹² guiogh¹³ hniah¹² juu¹² dsio¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dsio¹ jmóh³ hniah¹² bí² hi² mi³rǿh³ hniah¹² jǿg³ dsi²juu¹² ja³ŋi³nioh³ hniah¹² quianh¹³ dsa² cuø¹² dsag³, mi³jøng² tsa¹jiag¹dsa ni³ jue¹³. Di³ jë́h² jue¹³ hniah¹² juu¹² ni³ policía quián¹²dsa. Jøng² tangh¹² policía hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² liúgh² hniah¹² ca¹lah¹ca¹tǿ² ja³ca¹quiih³ hniah¹² jø² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jmai³ jøng² mi³tiogh³ ca²dsiog³ dsa² ca¹dsii¹ jǿg³ ha²lah ma²ca¹cúgh² Pilato jmø² quiah¹² ca²dsiog³ dsa² chian² Galilea quianh¹³ jmø³ jáh² ca¹togh¹²dsa ni³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Tsa¹ju³lë́h³ hniah¹² hi² ca¹can¹ dsa² chian² Galilea héi² jmø³uai¹² jøng² ni³ huu¹³ hi² mi³re²dsa ma¹dsio¹² dsag³ cónh¹ jín³ dsag³ re² dsa² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A¹jáng¹ lah¹jøng² lǿa¹². Di³ jø¹² bíh³ lah¹jøng² dsiánh¹ ca¹lah¹jáh¹ hniah¹² calah, ju³ná³ tsa¹ca¹jéinh¹ hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tsa¹ju³lë́h³ hniah¹² ca¹dsan¹ dsa² guia¹jŋiá² ca¹jlan¹dsa hniú¹² ŋiei¹² mi³tsih¹³ Siloé ni³ huu¹³ hi² ma²ca¹jmo¹dsa hi² hlaih¹³ hi³méh¹ cónh¹ jín³ hi² hlaih¹³ ma²ca¹jmo¹ dsa² chian² Jerusalén jian¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A¹jáng¹ lah¹jøng² lǿa¹². Di³ jø¹² bíh³ lah¹jøng² dsiánh¹ ca¹lah¹jáh¹ hniah¹² calah, ju³ná³ tsa¹ca¹jéinh¹ hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jøng² ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹², ca¹juúh²dsa: ―Jan² dsa² ŋioh¹², mi³tsih¹³ cøng² hma² higo jøa³nung² quiah¹²dsa. Jøng² ca¹ŋi³jái³dsa chi²júh² ma²ti³hái¹³ mǿi². Jøng² ha¹chi² chi² jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² neng¹² gug² tai³ jøa³nung² quiah¹²dsa: “Jai³lah. Ma²ni³ŋó¹³ hnøa¹² ŋi² guio¹jni hnangh¹²jni mǿi² higo, ha¹chi² mǿi² cuø¹² hma². Jøng² quiuh³hning. Di³ la³tsih¹³ chi³jnái¹² huø¹ báh³ hma².” ");
INSERT INTO cpaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa juu¹³dsa: “Ju³lǿa¹³, ju³tsih¹³ cøng² ji²ŋi² la², Guiuh¹³. Jøng² cah³jni huø¹ ja³tsih¹³. Toh¹³jni hóh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ju³ne¹³ tsa¹cuø¹ mǿi² ji²ŋi² cøng². Jøng² báh³ uǿnh² ju³ná³ tsa¹ca¹cuø¹,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cøng² jmai³ sa³¹ ma²he¹² Jesús jǿg³ dsi²néi² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ja³jøng² mi³hiúg³ jan² hio¹³, dsa² dsoh³ ma²ŋó¹² cónh¹ guie¹jŋí² ji²ŋi². Ma²bong³ cah³dsa. Tsa¹lé² li¹néih¹dsa quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jøng² mi³ca¹jë́² Jesús hio¹³ héi², ca¹tøa¹dsa. Ca¹juúh²dsa: ―Hio¹³, ma²ca¹hlúh²hning dsag³ mi³lanh¹³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jøng² ca¹quieg²dsa gug² ni³ quiah¹² hio¹³. Dsø¹juu¹² jøng² ca¹néih¹ hio¹³ quiah¹². Ca¹mi¹juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jøng² ma²hne² dsa² neng¹² ni³ jǿg³ quiah¹² guøh¹², di³ ca¹mi¹hliú² Jesús hio¹³ jmai³ sa³¹. Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa dsa² tiogh³: ―Jŋiéng² jmai³ báh³ lé² li¹jmó³ jniang³ ta³ lah¹cøng² lah¹cøng² sø²ma³¹. Jmai³ jøng² báh³ ji³noh¹² hniah¹² hi² ji³jmoh¹² hniah¹² hí³ quiánh² hniah¹². Tsa¹jmóh³ hniah¹² lah¹jøng² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jøng² ca¹juúh² Juu¹³ jniang³, ca¹tsáih¹dsa dsa² héi²: ―Dsa² tø¹cah¹ tø²jen¹² báh³ hniah¹². Tseh³ báh³ hniah¹² búh³ quiánh² hniah¹², ho¹ ju³ ca³ju² jmai³ sa³¹. Jøng² gu³jianh¹² hniah¹² jáh² ja³dsa¹hính¹jah jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jøng² hio¹³ lang¹² liáh³, dsa² lán¹² tsø³jong¹³ hlai³ Abraham, dsa² lǿa¹² jǿg³ hi² ma²chi³chiangh¹² Satanás ma²ni³ŋó¹³ guie¹jŋí² ji²ŋi², tsa¹cuúh³ hniah¹² jǿg³ hi² hliú² hio¹³ jmai³ sa³¹ dsag³ hi² lán¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jøng² ca¹can¹ ca¹lah¹já¹ dsa² hiag¹³ ju²hiíh¹ mi³ca¹juúh² Jesús lah¹jøng². Jøng² ca¹lah¹já¹ dsa² hniang¹ quiah¹²dsa, hioh¹² jenh¹²dsa ca¹lah¹jǿ¹ hi² dsio¹ jmo¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jøng² ca¹juúh² Jesús: ―¿He² jǿg³ chi² li¹juúh³ jniang³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹? ¿He² jǿg³ chi² li¹dsií³ jniang? ");
INSERT INTO cpaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lǿa¹² ju³lah lǿa¹² møi¹jon² mostaza hi² séi²dsa jøa³nung² quiah¹²dsa. Jøng² lǿ² chiúh³ hma² cah³. Toh¹² jáh² ŋi²nio³ guiuh¹³ tsai³ gogh¹² quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jøng² ca¹juúh² calah Jesús: ―¿He² jǿg³ chi² li¹dsií³ jniang³ ha²lah lǿa¹² ja³jmo¹² Diú¹³ héh¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lǿa¹² ju³lah lǿa¹² chiúh³ hi³ŋíh¹ guian¹² hio¹³ quianh¹³ guieg²hŋí² kilo juu³ ca¹lah¹ca¹rǿng² jø² can³ hi³ŋíh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jøng² ca¹ŋó¹ calah Jesús juu¹², hi² dság¹²dsa juu¹² jøa³juøi² Jerusalén. Ca¹he¹dsa jǿg³ juøi² quianh¹³ rancho tioh¹³ dsi²juu¹² ja³ca¹tsø³jue¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jøng² ca¹juúh² jan² dsa², ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, ¿mih³ dsa² liúg²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² jue¹²: ");
INSERT INTO cpaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Jmo³ bí² hi² gu³togh³ hniah¹² ja³dsio¹. Di³ tiog¹³ báh³ ué² ŋë́¹dsa, ju³lah lǿa¹² cøng² ja³chi³cagh¹² hag³hniú¹². Lah¹dsóh² juǿi²jni hniah¹²: Jue¹² dsa² li¹hniu¹ ŋë́¹. Jøng² tsa¹tiúh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ju³ná³ ma²ca¹jnéi¹ dsa² hniu³ hag³hniú¹², jøng² túgh³ hniah¹² ja³dsi¹², qui³tøh² hniah¹² hag³hniú¹², juúh² hniah¹²: “Juu¹³ jniang³, nii³ hniú¹².” Jøng² ŋai¹dsa: “Ha¹chi² ná¹³jni. Tsa¹guiang³jni ha² chianh² hniah¹².” ");
INSERT INTO cpaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jøng² juúh³ hniah¹² calah: “jnieh³ báh³ dsa² ca¹cø² ca¹hniúh³ quianh¹³ hnéng¹. Ca¹heh³hning jnieh³ jǿg³ jøa³cai³¹ ja³tiagh³ jnieh³.” ");
INSERT INTO cpaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jøng² juúh²dsa calah: “Lah¹té¹² juǿi²jni hniah¹²: Tsa¹guiang³jni ha² chianh² hniah¹². Gu³noh¹² hniah¹², ca¹lah¹jáh¹ hniah¹² dsa² jmoh² hi² hlaih¹³,” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja³jøng² hǿgh³ hniah¹² hi² chianh² hniah¹² jmø³uai¹², na³ma²jaih³ hniah¹² hi² tiogh³ hlai³ Abraham, quianh¹³ hlai³ Isaac, quianh¹³ hlai³ Jacobo, quianh¹³ ca¹lah¹já¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³, hi² tiogh³dsa ja³jmo¹² Diú¹³ héh¹. Jøng² ma²ca¹guianh¹dsa hniah¹² tø¹cøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Di³ ji¹lé² dsa² chian² ca¹lah¹jǿ¹ quiún² quiuh¹³ jmøi¹guǿi¹, dsa² dsa¹tiogh¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jøng² jai³lah: Ca²dsiog³ dsa² dsa²lé² ja³ca¹tóh² jø², dsa² héi² cán² ni³. Jøng² ca²dsiog³ dsa² quin¹² ni³, dsa² héi² dsa¹lé² ja³ca¹tóh² jø² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jmai³ jøng² ca¹dsi¹lé² ca²dsiog³ dsa² fariseo. Ca¹tsáih¹dsa Jesús: ―Jú¹² ja³la². Di³ jŋëh¹ Herodes hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jøng² ca¹juúh² Jesús: ―Jǿg³ la² gu³tseih³ hniah¹² dsa² quin¹² mai³¹ hlaih¹³ héi²: “Jai³lah, na¹ quianh¹³ hiá¹ huø³jni jmi²dsí² hlaih¹³. Mi³hliú³jni dsa² dsoh³. Jøng² hiég¹ tiug¹²jni ta³.” ");
INSERT INTO cpaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cónh¹jøng² cøng² hi² nei¹³ báh³ jní² juu¹² ja³ma²ŋøa¹²jni na¹, hiá¹ quianh¹³ hiég¹. Di³ tsa¹lé² jón²jni ja³siíh³. Cøng² jøa³juøi² Jerusalén báh³ dsan² dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Hniah¹² dsa² chian² Jerusalén, dsa² mi²dsianh¹³ dsa² hǿ² jǿg³ quiah¹² Diú¹³, hniah¹² dsa² qui²tugh³ cang³ dsa² ca¹tsen¹ Diú¹³! ¡Hliú² rón³ mi³li¹quianh¹³jni hniah¹² ju³lah jan² chi³chiih³ togh¹² guing² quián¹² niúh¹ cog¹²! Jøng² tsa¹ca¹lø¹hnǿngh¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jai³ di³ hniah¹² ha²lah lǿa¹². Ma²ca¹tiúg² Diú¹³ hniah¹². Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹lǿih² jmai³ ma¹jaih³ hniah¹² jní² ca¹lah¹ja³ca¹dsiég¹ jmai³ ja³juúh³ hniah¹²: “Hiug¹² dsiog¹ dsa² já¹² ni³ huu¹³ quiah¹² Juu¹³ jniang³,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cøng² jmai³ sa³¹ ca¹ŋó¹ Jesús, ca¹ŋi¹gǿh¹dsa ja³quiah¹³ jan² dsa² quin¹² ni³ quián¹² dsa² fariseo. Ti³jǿi² ca²dsiog³ dsa² fariseo ha²lah jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ja³jøng² hiúg³ jan² dsa² lán¹² dsag³ guion²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jøng² ca¹ŋǿh¹ Jesús tøa¹² he¹² lei¹³ quianh¹³ dsa² fariseo. Ca¹juúh²dsa: ―¿Lé³ li¹jmo¹dsa hí³ dsa² dsoh³ jmai³ sa³¹, ho¹ tsa¹lé²? ");
INSERT INTO cpaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jøng² ha¹chi² ca¹ŋai¹ dsa² héi². Jøng² ca¹chính² Jesús quiah¹² dsa² dsoh³. Ca¹mi¹hliú²dsa dsa². Jøng² ca¹juúh²dsa hi² ma²lé² dsánh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jøng² ca¹juúh²dsa calah, ca¹tsáih¹dsa dsa² fariseo: ―Ha¹chianh² hniah¹² tsa¹dsenh¹³ hniah¹² jáh² quiánh² hniah¹² dsø¹juu¹², ju³ná³ ca¹tánh² búh³ quiánh² hniah¹² niúh¹ tøg², ho¹ ju³ ca³juu², ju³ lah¹la² lǿa¹² jmai³ sa³¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jøng² ha¹chi² ma²ŋi¹² dsa² héi² he² jǿg³ ŋai¹dsa jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jøng² ca¹dsii¹ Jesús jǿg³ la² mi³ca¹jái¹dsa ha²lah ma²jmo¹² dsa² ca¹tǿh¹ dsa² hniu³. Di³ ma²ni³hnangh¹² dsa² héi² ja³jláh³ mesa tógh¹dsa. Jøng² ca¹juúh² Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ju³ná³ ca¹tǿh¹dsa hniah¹² cøng² jmai³ ja³ca¹jenh² gug² dsa², tsa¹gu³tiogh¹² hniah¹² ja³jláh³ mesa, ju³ jøng² ma²ca¹tǿh¹ dsa² hniu³ dsa² canh¹³ hi³méh¹ cónh¹ jín³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Di³ ju²hiíh¹ jénh³ hniah¹² ju³ná³ ca¹juúh² dsa² hniu³ hi² cuúh³ hniah¹² ja³tiogh³ hniah¹², hi² túgh² dsa² canh¹³ hi³méh¹, jøng² gu³tiogh¹² hniah¹² ja³ca¹tóh² jø². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cónh¹jøng² gu³tiogh¹² hniah¹² ja³ca¹tóh² jø², ju³ná³ ca¹tǿh¹dsa hniah¹² jmai³. Mi³jøng² na³ma²dsiég¹ dsa² hniu³, juúh²dsa hi² gu³tiogh¹² hniah¹² ja³jláh³ hi³méh¹. Hi² lah¹jøng² mi¹juanh¹²dsa hniah¹² ja³ta¹ni¹ ca¹lah¹já¹ dsa² tiogh³ mesa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Di³ ju²hiíh¹ jenh¹³ ca¹lah¹já¹ dsa² ca¹jmo¹ canh¹³ guiog¹³. Dsa² héi² báh³ lén² dsa² canh¹³, dsa² ca¹jmo¹ tsa¹quien¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jøng² ca¹juúh² calah Jesús, ca¹tsáih¹ dsa² hniu³: ―Tsa¹tøah¹³hning dsa² ti³jén² jǿg³ quiánh²hning, quianh¹³ ju²rúh²hning, quianh¹³ dsa² chi² cog³, jmai³ ja³jmóh³ hniah¹² jmai³, ja³túgh³ hniah¹² mesa. Di³ tǿ² dsa² héi² jmai³ siíh³ ja³jáinh¹dsa quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cónh¹jøng² tøah¹³hning dsa² ti³ŋié², dsa² tsa¹ma¹lé² jmo¹ ta³, dsa² tsa¹li¹ŋøa¹, dsa² teg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jøng² dsio¹ lé² quiánh²hning. Di³ tsa¹lé² jáinh¹ dsa² héi². Jøng² li¹hmah¹³ quiánh²hning na³ma²ca¹hiog² dsa² dsiog¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mi³ca¹nǿng² dsa² tiogh³ mesa jǿg³ jøng², jan² dsa² héi² ca¹juúh², ca¹tsáih¹dsa Jesús: ―Dsio¹ lé² quián² jniang³ na³ma²tiagh³ jniang³ mesa quiah¹² Diú¹³ ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jan² dsa² ca¹jmo¹ cøng² jmai³ juøh¹². Ca¹tǿh¹dsa dsa² jue¹² dsa¹gǿh¹dsa ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jøng² mi³ca¹tǿ² jmai³, ca¹tsen¹dsa dsa² jmo¹² ta³ quiah¹²dsa hi² dsa¹tseih¹²dsa dsa² ca¹tǿh¹dsa hi² ma²lé² ji¹lé²dsa, di³ ma²lǿa¹² ju²jŋia¹³ ca¹lah¹jǿ¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jøng² cu¹dsie¹²dsa ca¹møa¹dsa ju²hén² dsag³ hi² tsa¹dsø¹lé²dsa jmai³. Ca¹juúh² jan² dsa² lah¹ni³: “Ma²na²lá²jni cøng² huø¹. Jøng² hniuh¹² nei¹³jni hi³ ŋi³jái¹jni. Juanh¹² jmóh³hning hoh¹² tsa¹lé² nei¹³jni jmai³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jøng² ca¹juúh² dsa² siáh²: “Ma²na²lán²jni hŋí² tséh¹ ca³juu², jáh² jmo¹² ta³. Jøng² hniuh¹² nei¹³jni hi² ŋi³quiéng¹jni jǿg³ dsøg¹² jáh². Juanh¹² jmóh³hning hoh¹² hi² tsa¹lé² nei¹³jni jmai³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jøng² ca¹juúh² dsa² siáh² calah: “Láh² ma²na²jenh¹ gug¹jni. Hi² jøng² tsa¹lé² nei¹³jni,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jøng² mi³ca¹dsiánh¹ dsa² jmo¹² ta³, ca¹jmóh¹dsa ca¹lah¹jǿ¹ jǿg³ jøng² ni³ juu¹³dsa. Jøng² ca¹lø¹hné¹ juu¹³dsa. Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² jmo¹² ta³: “Hiugh¹² gu² juu¹² jøa³cai³¹ ca¹lah¹tan¹³ jøa³juøi². Gu³teh¹²hning dsa² ti²ŋié², dsa² tsa¹ma¹lé² jmo¹ ta³, dsa² teg³, dsa² tsa¹li¹ŋøa¹.” ");
INSERT INTO cpaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mi³ca¹løa¹ jøng² ca¹juúh² dsa² jmo¹² ta³: “Juu¹³ jniang³, ma²na²jmo¹jni ca¹lah¹jǿ¹ jǿg³ ma²na²juøh¹hning. Jøng² hei¹² hi³méh¹ ja³li¹tógh¹ dsa²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jøng² ca¹juúh² juu¹³dsa, ca¹tsáih¹dsa calah dsa² jmo¹² ta³: “Gu³teh¹²hning calah dsa² ŋi²ti³ ŋi²nio³ láh² hiu³ juu¹². Jmóh³hning ca¹lah¹tiog¹³ ji¹lé²dsa. Mi³jøng² ju³cangh¹² jø² dsi²néi² quieg¹jni.” ");
INSERT INTO cpaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chian² dsa² ca¹tǿ²jni lah¹jiá¹² héi² ji¹tiogh¹² mesa quieg¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma²ŋi²nio³ dsa² jue¹² juu¹² dsi³cah³ Jesús. Jøng² ca¹jénh¹ Jesús, ca¹tsáih¹dsa dsa² héi²: ");
INSERT INTO cpaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ju³lah dsa² hniu¹ dság¹ quianh¹³ jní², ju³ná³ tsa¹jmo¹dsa hian³dsa chiég³ jmi²dsa, hio¹³ quián¹²dsa, guing² quián¹²dsa quianh¹³ roh¹³dsa, ju³ná³ tsa¹jmo¹dsa hian³ dsǿa¹²dsa jǿg³ quiah¹²dsa hŋiah¹²dsa, jøng² tsa¹lé² lén²dsa dsa² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ju³ná³ hein² dsa² tsa¹mi¹hiúg¹ dsǿa¹² jón²dsa ja³ŋøa¹²dsa quianh¹³ jní², tsa¹lé² lén² dsa² héi² dsa² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chi² na²ju² hein² hniah¹² hnøngh² jmóh³ cøng² hniú¹² ŋiei¹², lah¹ni³ cánh³ hniah¹² jǿg³ dsøg¹² ha²cónh¹ lé² li¹quë¹. Jáih³ hniah¹² chi² na²ju² chi² quianh¹³ hi² lé² li¹hian¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Di³ ca¹lah¹já¹ dsa² cuúh¹ hniah¹² ju²hiíh¹, ju³ná³ ca¹jái¹dsa hi² ha¹chi² quianh¹³ lé² li¹hian¹² ta³ quiánh²hning na³ma²ca¹hǿi² ni³. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Juúh²dsa: “Jai³lah dsa² lang¹² tsa¹ca¹tiúh¹ mi¹hian¹² ta³ ca¹mi¹liág¹dsa,” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jø¹² bíh³ lah¹jøng² rai¹³, ju³ná³ hniuh¹² jmo¹dsa hning² quianh¹³ rai¹³ siáh², tiog¹³ báh³ cán²dsa jǿg³ dsøg¹² lah¹ni³ chi²júh² tiúh¹ guie¹ mei¹³ hlég² quián¹²dsa jmo¹ hning² quianh¹³ guiég² mei¹³ hlég² quián¹² rai¹³ siáh² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ju³ná³ lë́²dsa tsa¹tiúh¹ hlég² quián¹²dsa, jøng² tsen¹dsa dsa² møa¹ ju³niu¹³ tei³ jǿg³ cónh¹ niúh¹ jín³ hi² ji¹quián¹ hlég² quián¹² rai¹³ siáh² héi² cøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hi² jøng² ju³ná³ hein² hniah¹² tsa¹tǿngh³ hniah¹² ca¹lah¹jǿ¹ hi² chi² quiánh² hniah¹², dsa² héi² tsa¹lé² lén² dsa² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Dsio¹ báh³ ŋi³. Cónh¹jøng² ha¹chi² ta³ li¹jmo¹ ŋi³ ju³ jøng² ca¹løa¹ tsa²ŋih³. ");
INSERT INTO cpaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ha¹chi² ta³ li¹jmo¹ ju³ná³ ca¹dsii¹dsa jøa³nung² quiah¹²dsa, ho¹ ju³ ja³jmo¹²dsa hóh³. Jmáh¹lah hi² mi³guieh¹ báh³ dsa². Ju³ná³ hein² dsa² lé² nang¹, ju³neng³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jue¹² dsa² jmo¹² ta³ hi² cagh¹²dsa cog³ juøi² quianh¹³ dsa² ti³re² dsag³ ca¹túgh² quianh¹³ Jesús, hi² hniu¹dsa nang¹dsa jǿg³ he¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hi² jøng² ca¹jí² dsa² fariseo quianh¹³ tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Ca¹juúh²dsa: ―Hien¹² Jesús dsa² ti³re² dsag³. Gøah¹²dsa quianh¹³dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hi² jøng² ca¹dsii¹ Jesús jǿg³ la², ca¹tsáih¹dsa dsa² héi²: ");
INSERT INTO cpaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ju³ná³ hein² hniah¹² tiogh³ ŋia¹lúg² jah¹chih² quiánh² hniah¹², ju³ná³ ca¹ŋi¹hén² jan², tiog¹³ báh³ jmóh³ hniah¹² cu³tiogh³jah ca¹lah¹ja³ca¹dsanh¹² jáh² ca¹ŋi¹hén². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jøng² na³ma²ca¹dsanh¹² hniah¹² jáh², hioh¹² jénh² hniah¹² chiogh¹³ hniah¹² jáh² guiuh¹³ cugh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jøng² na³ma²dsiánh¹ hniah¹² ja³quiánh³ hniah¹², tøah¹³ hniah¹² dsa² jenh² hniah¹² quianh¹³, quianh¹³ dsa² tiogh³ cøg¹². Juaih¹³ hniah¹² dsa² héi²: “Jmo³ hniah¹² hioh¹² quianh¹³ jní². Di³ ma²na²dsanh¹²jni jah¹chih² quian¹jni, jáh² ca¹ŋi¹hén²,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lah¹dsóh² juǿi²jni hniah¹²: Hiug¹² jín³ hioh¹² jenh¹ dsa² chian² ŋi¹juǿi¹ ju³ná³ ca¹jéinh¹ dsǿa¹² jan² dsa² re² dsag³ cónh¹ jín³ hioh¹² jenh¹dsa ja³cog² jue¹² dsa² dsiog¹, dsa² tsa¹hniuh¹² jéinh¹ dsǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Jøng² ju³ná³ jan² hio¹³, chi² guie¹ cog³ huh² quiah¹²dsa, hi² quien¹² ma¹guie¹ héh¹, ju³ná³ ca¹ŋi¹hén² cøng², tiog¹³ báh³ hiúh²dsa si². Jøng² hiíh²dsa dsi²néi² quiah¹²dsa. Hnangh¹dsa cu²rø² ca¹lah¹ja³ca¹dságh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jøng² na³ma²ca¹dságh¹, tǿh²dsa dsa² jenh²dsa quianh¹³, quianh¹³ dsa² tiogh³ cøg¹². Juúh²dsa: “Ju³jmó³ jniang³ cøng² liáh² quianh¹³ jní². Di³ ma²na²dsóh²jni cog³ huh² quieg¹jni, cog³ ca¹ŋi¹hén²,” juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lah¹dsóh² juǿi²jni hniah¹²: Lah¹jøng² báh³ hioh¹² jenh¹² ángeles quián¹² Diú¹³ na³ma³ca¹jéinh¹ dsǿa¹² jan² dsa² re² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jøng² lah¹la² ca¹juúh² calah Jesús: ―Jan² dsa², mi³chian² og¹ ja³ŋiúh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jøng² ca¹juúh² dsa² lán¹² dsa² siog¹², ca¹tsáih¹dsa ti³jmi²dsa: “Tiá³, cuúh³hning mih² dsiúg³jni, hi² chi² quián² jniang³ cónh¹ jín³ tan¹jni,” ca¹juúh²dsa. Hi² jøng² ca¹dsogh¹² ti³jmi²dsa hi² mi³chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsa¹hai³ jøng² ca¹jnáih¹ ja³ŋiúh³dsa dsa² meh² ca¹lah¹jǿ¹ hi² chi² quiah¹²dsa. Ca¹ŋó¹dsa go² dsa² siáh² ca¹tǿ² guiég¹. Ja³jøng² la³ca¹ŋi³hén¹³dsa hi² ca¹ŋë́²dsa. Ca¹jmo¹dsa la³ju² la³lán¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jøng² mi³ma²ca¹ŋi¹hén²dsa ca¹lah¹jǿ¹, ca¹já¹ hag³cón³ huø¹ jøng². Jøng² jín³ ca¹chi¹quián²dsa jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ni³ jøng² ca¹hí¹dsa ta³ quiah¹² jan² dsa² chian² huø¹ jøng². Dsa² héi² ca¹tsei¹ juu¹² jøa³nung² quiah¹²dsa, mi³jøng² ca¹jmo¹dsa hí³ ŋié¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jøng² hiug¹² lǿ² lø¹i³cónh¹²dsa. Lǿ² lø¹i³gǿh¹dsa hi² gøah¹² ŋié¹². Cónh¹jøng² ha¹chian² dsa² ca¹cuø¹ hi² gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jøng² ca¹ŋi¹jiag¹² dsǿa¹²dsa: “¡Cónh¹ báh³ dsa² tsa¹tiogh³ ti³jmo¹² ta³ quiah¹² ti³ŋieh¹jni, hi² chiág² hi² gøah¹²dsa! Jní² báh³ hiúg³ ja³la², jon¹³ cong¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neh¹³jni ja³quiah¹³ ti³ŋieh¹jni, hi² ŋi³tseih¹²jni dsa²: Tiá³, dsag³ ca¹ta³canh¹³jni ja³cog² Diú¹³, ja³cogh² hning². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tsa¹ta³té¹³jni lán¹²jni ja²ŋiúh²hning. Jaih³hning jní² hi² lán¹²jni ju³lah lán¹² jan² dsa² jmo¹² ta³ quiánh²hning, juǿi³jni dsa²,” lë́² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jøng² ca¹ŋáh¹dsa juu¹² ja³quiah¹³ ti³jmi²dsa. ’Jøng² ca¹jǿi² ti³jmi²dsa ja³jogh¹²dsa guiég¹. Ca¹ŋi¹ŋiú² dsǿa¹² ti³jmi²dsa. Ca¹ŋó¹dsa gu¹hei¹². Ca¹cúgh²dsa dsa² cog¹²dsa. Ca¹chiúnh¹dsa ni³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jøng² ca¹juúh² ja³ŋiúh³dsa: “Tiá³, ca¹ta³canh¹³jni dsag³ ja³cog² Diú¹³, ja³cogh² hning². Tsa¹ma¹ta³té¹³jni lán¹²jni ja²ŋiúh²hning,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Cónh¹jøng² ca¹juúh² ti³jmi²dsa, ca¹tsáih¹dsa dsa² jmo¹² ta³ quiah¹²dsa: “Hiugh¹², gu²quin² cøng² hmøah¹² lǿa¹² jín³ hi² dsio¹. Jøng² quienh¹³hning dsa² lang¹². Tieh¹³ cøng² ŋí³ chi³gúg¹dsa. Tóh³hning løg² tai³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gu³teih³ jan² ca³juu² meh², jáh² ma²pan¹³. Jøng² jŋë́h³hning jáh². Di³ jøng² quie¹³ jniang³. Jmó³ jniang³ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Di³ ma²guønh¹² ja³ŋiúh¹jni lang¹², dsa² lah¹cøng² ma²ca¹hiog²dsa mi³ca¹jon¹dsa. Ma²ca¹dsanh¹² jniang³ dsa² ma³ca¹ŋi¹hén²,” ca¹juúh² ti³jmi²dsa. Jøng² ca¹jmo¹dsa hioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jøng² ja³ŋiúh³dsa ma²juanh¹² ma²ca¹ŋó¹ juu¹² jøa³nung². Ma²jogh¹² dsa² héi² ja¹quien¹³ dsiánh¹dsa mi³ca¹nǿng²dsa son¹³ ja³ma²ŋi²nio³ dsa² jan³. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jøng² ca¹tǿh¹dsa jan² tsih², dsa² jmo¹² ta³. Ca¹ŋai¹dsa he² løa¹ jmo¹²dsa jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jøng² ca¹juúh²tsih: “Ma²na²guǿnh¹ rúh²hning. Jøng² ca¹jmo¹ ti³ŋieih¹²hning jǿg³ hi² ca¹jŋëh¹dsa jan² ca³juu² meh², jáh² ma²pan¹³. Di³ ma²na¹guǿnh¹dsa dsio¹. Ha¹chi² ca¹jenh¹dsa,” ca¹juúh²tsih. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jøng² ca¹lø¹hné¹ ja³ŋiúh³dsa ma²juanh¹². Tsa¹ca¹hiei¹dsa hí¹dsa dsi²néi². Hi² jøng² ca¹u¹hái¹ ti³jmi²dsa. Ca¹tsáih¹dsa ja³ŋiúh³dsa héi² hi³ mi³dság¹dsa dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jøng² ca¹juúh² ja³ŋiúh³dsa: “Jai³lah. Ma²ni³ŋó¹³ ji²ŋi² ma²ca¹jmo¹jni ta³ quianh¹³ hnéng¹. Tsa¹lǿih² jmai³ tsa¹ma²ca¹jmo¹jni hi² tsa¹nang¹²jni gøg² jǿg³ quiánh²hning. Jøng² jin³ cu²rón² ha¹chi² ma²ca¹cuanh¹³hning jin³ jan² chiang³ løg² meh² mi³jøng² mi³jmo³jni jmai³ quianh¹³ dsa² jenh² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cónh¹jøng² na¹ jín³ ma²guønh¹ ja²ŋiúh²hning héi², dsa² ma²ca¹ŋi¹hén² cog³ quiánh²hning quianh¹³ hio¹³ lø³hiug¹². Jøng² ni³ huu¹³ quiah¹² dsa² héi² ma²ca¹jŋë́h¹hning ca³juu² meh² ma²pan¹³.” ");
INSERT INTO cpaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jøng² ca¹juúh² ti³jmi²dsa: “Jon¹², cøng² hi² hiúgh³ báh³ hning² quianh¹³ jní². Hi² quiánh² báh³ hning² ca¹lah¹jǿ¹ hi² chi² quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cónh¹jøng² dsio¹ jmó³ jniang³ hioh¹². Di³ ma²na²guǿnh¹ calah rúh²hning. Lah¹cøng² ma²ca¹hiog² dsa² ma²ca¹jon¹. Ma²ca¹dsanh¹² jniang³ dsa² ma²ca¹ŋi¹hén²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jøng² ca¹dsii¹ Jesús jǿg³ la², ca¹tsáih¹dsa dsa² quianh³dsa: ―Jan² dsa² chi² cog³, mi³chian² jan² dsa² jmo¹² ta³ quiah¹²dsa. Jøng² ca¹lø¹chí¹ jǿg³ hi² ma²ca¹ŋi¹hén² dsa² jmo¹² ta³ hi² chi² quiah¹² juu¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jøng² ca¹tøa¹ juu¹³dsa. Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² jmo¹² ta³: “¿Ha²lah lǿa¹² jǿg³ ma²ca¹nang¹jni ja³cogh²hning? Jáinh³hning jǿg³ ha²lah lǿa¹² ta³ ma²ca¹jmoh³hning. Di³ tsa¹ma¹lé² jmóh³hning ta³ quieg¹jni,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jøng² ca¹ŋi¹jiag¹² dsǿa¹² dsa² jmo¹² ta³ héi². Lë́²dsa: “He² hi² dsio¹ jmo¹³jni. Di³ tsa¹ma¹cuø¹ juu¹³jni ta³. Ha¹chi² bí² chi² quieg¹jni hi² jmo¹³jni ta³ huh². Jøng² tsa¹tí² dsøa¹jni møa¹³jni hi² la³møa¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ma²guiang³jni ha²lah jmo³jni. Mi³jøng² li¹hniang¹ dsa² siáh² jmai³ ja³tsa¹ma¹chi² ta³ hi² li¹jmo¹³jni ja³la²,” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ni³ jøng² ca¹tǿh¹dsa dsa² ti³re² quiah¹² juu¹³dsa, ta¹ma¹jan²dsa. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² ca¹tǿh¹dsa lah¹ni³: “¿Ha²cónh¹ reh²hning quiah¹² juu¹³jni?” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jøng² ca¹juúh² dsa² héi²: “Lǿa¹² jín³ hnøa¹² mei¹³ litros jmáh¹lah nang³ báh³ re²jni,” ca¹juúh²dsa. Jøng² ca¹juúh² calah dsa² jmo¹² ta³: “Hiugh¹² quieng² si² la² ja³rø²ton¹² ha²cónh¹ reh²hning. Ní² ja³ná³. Jøng² tøngh¹³hning si² hi² reh²hning jmáh¹lah ton¹dsoh¹³,” ca¹juúh² dsa² jmo¹² ta³. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jøng² mi³ca¹tǿh¹dsa dsa² siáh² calah, ca¹juúh²dsa: “¿Ha²cónh¹ reh²hning?” Jøng² ca¹ŋai¹dsa héi²: “Cøng² mei¹³ tø²hmøah¹² jmáh¹lah cuøi² hi³ŋíh¹,” ca¹juúh²dsa. Jøng² ca¹juúh² dsa² jmo¹² ta³, ca¹tsáih¹dsa dsa² héi²: “Quieng² si² la² quiánh²hning. Tøngh¹³hning si² hi² reh²hning jmáh¹lah jŋi¹ ŋi²lǿg²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jøng² mi³ca¹lø¹lih¹³ juu¹³dsa ha²lah ma²ca¹jmo¹dsa hi² hlaih¹³ jøng², ca¹juúh² juu¹³dsa hi² lah¹dsóh² ma²ŋi¹² dsa² héi² ha²lah jmo¹. Di³ hiug¹² jín³ ma²ŋi¹² dsa² ŋi²nio³ jǿg³ hlaih¹³ quiah¹² jmøi¹guǿi¹ la² ha²lah jmo¹ jǿg³ quiah¹² guiog¹³dsa cónh¹ jín³ ma²ŋi¹² dsa² ŋi²nio³ juu¹² quiah¹² Diú¹³ ha²lah mi¹ti¹dsa jǿg³ ma²chinh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Lah¹dsóh² juǿi²jni hniah¹², dsio¹ jmóh³ hniah¹² hi² dsio¹ ja³cog² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² quianh¹³ hi² li¹chi² quiánh² hniah¹² ni³ jmøi¹guǿi¹ hlaih¹³ la². Mi³jøng² hien¹ dsa² héi² hniah¹² ŋi¹juǿi¹ na³ma²ca¹tǿ² ja³tsa¹ma¹quien¹² hi² jøng² ja³cogh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ju³ná³ hein² dsa² mi²ti¹ ta³ mih², dsa² héi² mi¹ti¹ lǿa¹² ju³ he² ta² juøh¹² ca¹lø¹chí¹ quiah¹²dsa calah. Jø¹² bíh³ lah¹jøng² dsa² tsa¹mi²ti¹ ta³ mih², tsa¹mi¹ti¹ dsa² héi² ta³ juøh¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hi² jøng² ma²ŋih³ hniah¹² ha¹chi² dsii¹ Diú¹³ ju²gugh² taih³ hniah¹² hi² chi² ja³lah¹dsóh² dsio¹, ju³ná³ tsa¹ca¹jmoh³ hniah¹² ti³té¹³ jǿg³ quiánh² hniah¹² quianh¹³ hi² ca¹lø¹chí¹ quiánh² hniah¹² ni³ jmøi¹guǿi¹ hlaih¹³ la². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ha¹chi² cuø¹dsa hi² li¹chi² quiánh² hniah¹², ju³ná³ tsa¹ca¹mi³tih³ hniah¹² ja³cog² hi² chi² quiah¹² dsá¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ha¹chian² dsa² tiúh¹ jmo¹ ta³ quiah¹² og¹ juu¹³dsa. Di³ tiog¹³ báh³ hian³dsa juu¹³dsa lah¹ni³ ju³ná³ hnio¹dsa dsa² ja³ma²og¹. Ho¹ ju³ mi¹ti¹dsa ja³cog² dsa² lah¹ni³. Jøng² tsa¹hiug² dsǿa¹²dsa ja³cog² dsa² ja³ma²og¹. Tsa¹lé² mi³ti³ jniang³ jǿg³ quiah¹² Diú¹³, ju³ná³ hneng² jniang³ jmáh¹lah cog³ chi² jmøi¹guǿi¹ la² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jøng² dsa² hniu¹ cog³ báh³ dsa² fariseo. Hi² jøng² ca¹cu² ca¹jmáh² dsa² héi² Jesús mi³ca¹nǿng²dsa ca¹lah¹jǿ¹ jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Hniah¹² báh³ dsa² jmoh² lanh¹² hniah¹² dsa² dsiog¹ ja³ta¹ni¹ dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cónh¹jøng² ma²ŋi¹² Diú¹³ ha²lah lǿa¹² hoh¹² hniah¹². Hiag¹³ báh³ Diú¹³ hi² ma²ca¹mi¹juøh¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ma²chi² lei¹³ quiah¹² Diú¹³ quianh¹³ jǿg³ ca¹hǿ² dsa² quián¹² Diú¹³ ca¹lah¹ja³ca¹lø¹chián¹ Juan. Ni³ jøng² ca¹lø¹chí¹ jǿg³ dsio¹ quiah¹² ja³jmo¹² Diú¹³ héh¹. Jøng² ca¹lah¹já¹dsa ma²hniu¹ dsa¹tiogh¹² ja³jøng² quianh¹³ hi² tiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Cónh¹jøng² hiug¹² jín³ hi² tsa¹ué² dsa¹hén² ŋi¹juǿi¹ quianh¹³ jmøi¹guǿi¹ cónh¹ jín³ hi² lé² tsa¹li¹ti¹ jin³ ca²jneh³ lei¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ju³ná³ hein² dsa² ca¹tiúg² hio¹³ quián¹², jøng² ca¹jian¹dsa hio¹³ siáh², dsa² héi² ta¹canh¹³ dsag³. Jø¹² bíh³ lah¹jøng² dsa² ca¹jian¹ hio¹³ mi³jian¹² dsa² ŋioh¹² siáh², hi² ma²ca¹tég² dsa² ŋioh¹² mi³jiag¹², ta¹canh¹² dsa² héi² dsag³ calah, dsa² ca¹jiag¹ ca¹tǿ² tánh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Jan² dsa² chi² cog³, mi³caih¹² hmøah¹² dsio¹, hmøah¹² jláh³. Mi³jmo¹²dsa jmai³ juøh¹² ca¹lah¹jǿ¹ jmai³ cu¹té¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jøng² hag³hniú¹² quiah¹² dsa² héi² mi³ron¹² jan² dsa² ti²ŋié², dsa² tsen² Lázaro, dsa² lán¹² hmih¹² ta³jan²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hiug² dsǿa¹² Lázaro mi³gǿh¹ he² hi² ca¹quia¹ ni³ mesa quiah¹² dsa² chi² cog³ héi². Jø¹² bíh³ ca¹dsi¹lé² dsøi². Ca¹hliuh¹jah hmih¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jøng² mi³ca¹jon¹ dsa² ti²ŋié², ca¹tai¹ ángeles juu¹² ja³cog² hlai³ Abraham. Ni³ jøng² ca¹jon¹ calah dsa² chi² cog³. Ca¹ŋi³hag¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jøng² ma²hiúg³dsa guio¹juǿi¹, ŋai¹²dsa jmø³uai¹², mi³ca¹jë́²dsa hlai³ Abraham quianh¹³ hlai³ Lázaro ca¹tǿ² guiég¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jøng² ca¹tøa¹ dsa² mi³chi² cog² héi², ca¹juúh²dsa: “Tiá³ Abraham, juanh¹² jmóh³hning hoh¹². Tse² Lázaro dsa¹tí²dsa jmøi² nih¹³ chi³gúg¹dsa. Mi³jøng² jií¹dsa ja³la², hi² mi³guǿih²dsa tsøh¹jni. Di³ hiug¹² cu¹té¹² jmø³uai¹² chian²jni dsi²si² la².” ");
INSERT INTO cpaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jøng² ca¹juúh² Abraham: “Ju³dsiagh² hoh¹²hning, jon¹². Hi² dsio¹ mi³dsø²ŋë́h²hning jmai³ ja³mi³chianh²hning jmøi¹guǿi¹. Hi² hlaih¹³ báh³ ca¹ŋi¹ŋë́² Lázaro. Na¹ jín³ ma²guǿ¹² Lázaro ju²hiúg¹ dsøa¹² ta³lah¹ŋaih¹³ hning² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jø¹² bíh³ tsøi² juøh¹² hiu³ dsi²jo² ja³tiagh³ jniang³. Hi² jøng² ha¹chian² lé² dsa¹lé², ju³lah dsa² hniu¹ dsa¹lé². Jø¹² bíh³ lah¹jøng² dsa² tiogh³ ja³ná³, tsa¹lé² ji¹lé²dsa ja³la².” ");
INSERT INTO cpaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jøng² ca¹juúh² calah dsa² mi³chi² cog³: “Jøng² hlanh¹³jni hning², tiá³. Tse² Lázaro juu¹² ja³quiah¹³ ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tiogh³ hŋiá² roh¹²jni. Mi³jøng² dsa²hlanh¹³dsa roh¹²jni tsa¹ju³ji¹lia¹dsa ja³uai¹³ la²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jøng² ca¹juúh² Abraham: “Chinh¹² báh³ dsa² lei¹³ quiah¹² hlai³ Moisés quianh¹³ jǿg³ quiah¹² Diú¹³ ca¹hǿ² dsa² quián¹²dsa. ¡Ju³neng³dsa jǿg³ jøng²!” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“A¹jáng¹ lah¹jøng², tiá³ Abraham,” ca¹juúh² dsa² mi³chi² cog³. “Di³ jéinh¹ báh³ dsǿa¹²dsa, ju³ná³ ca¹dsiánh¹ jan² dsa² ma²ca¹jon¹,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jøng² ca¹juúh² calah Abraham, ca¹tsáih¹dsa dsa² héi²: “Chi²júh² tsa¹nang¹²dsa jǿg³ quiah¹² hlai³ Moisés quianh¹³ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³, jø¹² bíh³ lah¹jøng² tsa¹hé²dsa ju³ lah¹la² ca¹hiog² jan² dsa² ma²ca¹jon¹,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Tiog¹³ li¹chi² jmøi¹guǿi¹ hi² jmo¹ ta¹canh¹³ dsa² jmøi¹guǿi¹ dsag³. Cónh¹jøng² ué² lé² quiah¹² lǿa¹² ju³ hein² ca¹jmo¹ hi² ca¹tánh² roh¹³dsa dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dsio¹ hi³méh¹ quiah¹² dsa² lah¹héi² ju³jøng² ca¹tiág²dsa jmø³ŋih¹³ hi² rø²quiein¹² cøng² to² juøh¹² lag³dsa, cónh¹ jín³ hi² jmo¹dsa tiáh¹ tsih² quián¹² Diú¹³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jmo³ di³ hniah¹² hí³ ha²lah jmóh³ hniah¹². ’Ju³ná³ ca¹jmo¹ rúh² hniah¹² dsag³ ja³cogh² hniah¹², jøng² jéh³ hniah¹² dsa². Jøng² henh¹³ hniah¹² dsag³ ju³ná³ ca¹jéinh¹ dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ju³ná³ guio¹ rón² ca¹jmo¹dsa dsag³ ja³cogh² hniah¹² quianh¹³ cøng² jmai³, jøng² guio¹ rón² lah¹jøng² ca¹juúh²dsa hi² ca¹jéinh¹ dsǿa¹²dsa, cónh¹jøng² tiog¹³ henh¹³ hniah¹² dsag³ quiah¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jøng² ca¹juúh² dsa² ma²lán¹² tsih² høh³ quián¹² Jesús, ca¹tsáih¹dsa Juu¹³ jniang³: ―Jmo³ mi³jøng² li¹hé² jniang³ jǿg³ cu²rø² hi³méh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jøng² ca¹juúh² Juu¹³ jniang³, ca¹tsáih¹dsa dsa² héi²: ―Ju³ jøng² mi³héh² hniah¹² jǿg³ cónh¹ ja³té¹² ja³juøh¹² cøng² møi¹jon² mostaza, jøng² mi³chi² bí² quiánh² hniah¹² hi² ma²lé² juaih¹³ hniah¹² hma² sicómoro tsih¹² ja³ná³ hi² jŋiángh¹hma tø¹tsøh¹³hma jmø³ŋih¹³, jøng² nang¹ báh³ hma² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ju³ná³ chianh² hniah¹² dsa² jmo¹² ta³ quiánh² hniah¹², ha¹chi² juaih¹³ hniah¹² dsa² hi² gú¹dsa mesa gǿh¹dsa dsø¹juu¹² na³ma²na²jogh¹dsa jøa³nung², ja³ca¹quih²dsa huø¹, ho¹ ju³ ca¹jmo¹dsa hí³ jáh² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lah¹ni³ juaih¹³ hniah¹² dsa² hi² jmo¹dsa má¹ cǿh³ hǿgh³ hniah¹². Jøng² báh³ cuúh³ hniah¹² jǿg³ hi² gǿh¹dsa hŋiah¹²dsa, na³ma²na²mi¹ti¹dsa neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jø¹² bíh³ lah¹jøng² tsa¹tiog¹³ juúh³ hniah¹² di³hmah³ ni³ huu¹³ hi² ca¹mi¹ti¹ dsa² jmo¹² ta³ ta³ quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hi² jøng² hniah¹², na³ma²ca¹mi³tih³ hniah¹² ca¹lah¹jǿ¹ ta³ ma²ca¹cuø¹ Diú¹³ jøng² dsio¹ juúh³ hniah¹²: “Tsa¹ta³tén¹³ jnieh³ jmo² jnieh³ ta³. Jmah¹lah ta³ jøng² ma²ca¹jmó³ jnieh³, ca¹lah¹cónh¹ ja³ma²lǿa¹² héh¹,” juúh³ hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ma²hiúg³ Jesús juu¹² hi² dság¹²dsa jøa³juøi² Jerusalén. Ma²ŋøa¹²dsa juu¹² ja³lǿa¹² ŋi¹juǿi² quiah¹² ja³tén¹² Galilea quianh¹³ ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jøng² ma²dsiég¹²dsa cøng² juøi² mi³ca¹jén²dsa guia¹ dsa² lán¹² hmih¹² tsa¹jŋi¹². Ca¹túgh² dsa² héi² ma¹quién¹ di³ tsagh¹² dsag³ lán¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ni³ jøng² ca¹ho¹ dsa² héi² tí², ca¹juúh²dsa: ―Jesús, dsa² juanh¹² quián² jniang³, huø³ jmóh³hning hoh¹² ja³cog² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jøng² mi³ca¹jë́² Jesús dsa² héi², ca¹juúh²dsa: ―Gu³heh³ hniah¹² jmi²dsa² hmih¹² quiánh² hniah¹² ―ca¹juúh²dsa. Ma²dsø²lé²dsa jøng² juu¹² ja³quiah¹³ jmi²dsa² mi³ca¹hlú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jøng² jan² dsa² héi² ca¹jénh¹ juu¹² mi³ca¹lø¹lih¹³dsa ma²na²hlú²dsa. Tí² ca¹hløah¹dsa ca¹mi¹juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jøng² ca¹chi¹jné¹dsa ja³ta¹ni¹ Jesús, chi³ŋiu¹³ ni³dsa huø¹. Ca¹cuúh¹dsa Jesús di³hmah³. Mi³lán¹² dsa² héi² dsa² chian² ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jøng² ca¹juúh² Jesús: ―¿Tsa³ca¹hlú² ta³guia¹ hniah¹²? ¿Nai¹² jín³ dsa² ŋio¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿He² løa¹ jan² dsa² lang¹², dsa² chian² ja³siíh³, ma²mi²juanh¹² Diú¹³ mi³ca¹hlú²dsa? ");
INSERT INTO cpaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² mi³dsoh³ héi²: ―Ma²lé² guǿnh³hning. Ha¹chi² ma¹dsoh³hning di³ hi² héh²hning jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ca¹ŋai¹ dsa² fariseo he² jmai³ jií¹ ja³jmo¹ Diú¹³ héh¹. Jøng² ca¹juúh² Jesús: ―A¹jáng¹ ju³ hi² jní² ja³jií¹ ja³jmo¹ Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ha¹chi² lé² li¹juúh³ jniang³: “Ja³ná³ báh³ jøng²,” ho¹ ju³ “ja³la² báh³.” Di³ jai³lah, ma²lǿa¹² ja³jmo¹² Diú¹³ héh¹ jøa³ ja³tiagh³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jøng² ca¹juúh²dsa calah, ca¹tsáih¹dsa dsa² quianh³dsa: ―Jií¹ báh³ jmai³ ja³lé² lø¹i³jáih³ hniah¹² lǿa¹² ju³ cøng² jmai³ ja³ma²hiúg³ jní² quianh¹³ hniah¹² calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jøng² ha¹chi² jáih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Li¹chian² dsa² juúh²: “Jai³lah, ja³ná³ hiúg³dsa,” ho¹ ju³ “Jai³lah, ja³la² hiúg³dsa.” Cónh¹jøng² tsa¹gu³jaih³ hniah¹². Tsa¹gu³noh¹² hniah¹² quianh¹³ dsa² juúh² lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Di³ li¹léi¹³ báh³ jøng² na³ma²tǿ² ja³guiogh¹³jni ju³lah lø²léi¹³ si² ŋíh¹, hi² jmo¹² si² ŋíh¹ hi² taih¹² jmøi¹guǿi¹ ca¹tǿ² guiég¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jøng² lah¹ni³ hniuh¹² cán³jni jmø³uai¹². Hniuh¹² li¹hiag¹³ dsa² go²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Lah¹jøng² báh³ lé² ja³cog²jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², ju³lah ca¹løa¹ jmai³ mi³chian² hlai³ Noé. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ca¹gǿh¹ ca¹hǿnh² dsa² chian² jmai³ jøng². Ca¹jenh²dsa gug²dsa. Ca¹túgh²dsa dsio¹ ca¹lah¹ja³ca¹tǿ² ja³ca¹hí¹ Noé barco quiah¹²dsa. Jøng² ca¹ŋi¹juøh¹² jmøi². Ca¹dsan¹ ca¹lah¹já¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jø¹² bíh³ lah¹jøng² ca¹løa¹ jmai³ mi³chian² hlai³ Lot: Ca¹gǿh¹ ca¹hǿnh²dsa. Ca¹lá¹ ca¹hnái¹dsa. Ca¹jmo¹dsa ta³ jøa³nung². Ca¹jmoh¹dsa hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Cónh¹jøng² ca¹quia¹ si² dsíg² quianh¹³ dsí² azufre juu¹² guiuh¹³ ŋi¹juǿi¹ mi³ma²na²u¹hái¹ Lot jøa³juøi² Sodoma. Ca¹dsan¹ ca¹lah¹já¹ dsa² mi³tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lah¹jøng² báh³ lé² jmai³ ja³li¹jniá²jni calah, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ju³ná³ hein² dsa² ma²tsenh¹² guiuh¹³ hniú¹² jmai³ jøng², tsa¹ju³siog²dsa dsi²néi² hi² dsa¹quieng¹³dsa hi² chi² quiah¹²dsa. Jø¹² bíh³ lah¹jøng² dsa² ma²tsenh¹² jøa³nung² quiah¹², tsa¹ju³dsiánh³dsa ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ju³dsiagh² hoh¹² hniah¹² ha²lah ca¹ŋi¹ŋë́² hio¹³ quián¹² hlai³ Lot. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ju³ná³ hein² dsa² dsø¹jiag¹² dsǿa¹² hi² chi² quiah¹²dsa ni³ jmøi¹guǿi¹ la², dsa² héi² jón². Dsa² héi² báh³ li¹chian², dsa² ca¹tiúgh² dsǿa¹² hi² mi³chi² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Lah¹dsóh² juǿi²jni hniah¹²: Lé² jmai³ jøng² hi² tiogh³ og¹ dsa² ŋioh¹² cøng² jein³. Jøng² tai¹ báh³ Diú¹³ jan². Tsa¹tai¹ Diú¹³ jan² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ja³ma²tiogh³ og¹ hio¹³ ieih¹² hé¹², tai¹ Diú¹³ jan². Jøng² tsa¹tai¹dsa jan² calah ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jøng² ca¹juúh² dsa² quianh³dsa: ―¿Ha² tøah¹ lé² lah¹jøng² Juu¹³ jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jøng² ca¹juúh² Jesús: ―Lǿa¹² ju³lah juúh²dsa jmai³ juúh²dsa: “Ja³jøng² báh³ tiogh³ tu² tsønh³, ja³ron¹² hi² ma²ju¹²” ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jøng² ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹², hi² ca¹he¹dsa hi² tiog¹³ hniuh¹² hlanh¹ dsa² quián¹²dsa Diú¹³, hi² tsa¹ju³hlih² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Lah¹la² ca¹juúh²dsa: ―Cøng² juøi² mi³chian² jan² dsa² lán¹² jue¹³, dsa² tsa¹gan¹ Diú¹³. Cu¹dsie¹² tsa¹tónh²dsa juu¹² ha²lah lán¹² dsa² jmøi¹guǿi¹ jian¹²dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jøng² mi³chian² jan² hio¹³ hnǿi² juøi² jøng², dsa² cøng² hi² dság¹² ja³taø¹ni¹ jue¹³, mǿa¹² hio¹³ hi² mi¹rø¹² jue¹³ jǿg³ chi² quiah¹²dsa quianh¹³ dsa² hiag¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lah¹ni³ tsa¹ca¹lø¹hiúg¹ dsǿa¹² jue¹³ mi¹rø¹² jǿg³ quiah¹² hio¹³ hnǿi². Cónh¹jøng² ta¹chi³quë́n¹ ca¹ŋi¹jiag¹² dsǿa¹² jue¹³ jǿg³ la²: “Ha¹chi² gan¹jni Diú¹³. Jin³ tsa¹tónh²jni juu¹² jǿg³ quiah¹² dsa² jmøi¹guǿi¹ jian¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Cónh¹jøng² mi³rǿ³ báh³ jní² jǿg³ quiah¹² hio¹³ hnǿi², mi³jøng² tsa¹ma¹cuø¹dsa ju²méh³ dsøa¹²,” ca¹ŋi¹jiag¹² dsǿa¹² jue¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jøng² ca¹juúh² Juu¹³ jniang³: ―Neng² di³ hniah¹² ha²lah lǿa¹² jǿg³ dsø²jiag¹² dsǿa¹² jue¹³, dsa² re² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jøng² ma²ŋih³ hniah¹² mi¹rø¹² Diú¹³ jǿg³ quiah¹² dsa² ca¹quiáh²dsa, dsa² møa¹² ju³li¹rø² jǿg³ quiah¹² lah¹huu² lah¹jmø². Tsa¹hai³ mi¹hag¹³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² ma¹hai³ ja³mi¹rø¹² Diú¹³ jǿg³ quiah¹² dsa² héi². Cónh¹jøng² tsa¹ne³ ha²cónh¹ dsa² cøng² hi² hé² jǿg³ quieg¹jni na³ma²guǿnh¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jøng² ca¹dsii¹ Jesús jǿg³ la² calah ja³cog² dsa² lë́² hi² dsiog¹dsa guiog¹³dsa, dsa² hian¹³ roh¹³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Og¹ dsa² ŋioh¹² ca¹ŋi¹lé² guøh¹². Ca¹ŋi¹hlanh¹²dsa Diú¹³. Jan² dsa² lán¹² fariseo. Jan² dsa² lán¹² ta³ cagh¹²dsa cog³ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chi²tsenh¹² dsa² fariseo. Ca¹hlanh¹dsa Diú¹³. Ca¹juúh²dsa: “Diú¹³ quian¹jni, di³hmah³hning Diú¹³. Di³ ha¹chi² lán¹²jni ju³lah lán¹² dsa² siáh², ju³lah dsa² høin², dsa² jmo¹² hi² hlaih¹³, dsa² hlanh¹² hio¹³ quián¹² dsa². Tsa¹lán¹²jni ju³lah lán¹² dsa² ná¹², dsa² cagh¹² cog³. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tánh¹ rón² lah¹cøng² sø²ma³¹ mi²han¹³jni hi² ha¹chi² gøah¹²jni. Dsii¹²jni dsiúgh³hning ja³ma²guie¹ cónh¹ ja³ca¹lah¹jǿ¹ hi² lø²chi² quieg¹jni” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cónh¹jøng² dsa² cagh¹² cog³, tø¹guiég¹ ca¹nung²dsa. Tsa¹jin³ tí² dsǿa¹²dsa jái¹dsa juu¹² guiuh¹³. Ca¹lah¹cøh² hiu³ dsǿa¹²dsa ca¹quieng¹²dsa dsǿa¹². Ca¹juúh²dsa: “Diú¹³ quian¹jni, huø³ jmóh³hning hoh¹² ja³cog²jni, jní² dsa² re² dsag³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Lah¹dsóh² juǿi²jni hniah¹²: Ma²ca¹jmo¹ Diú¹³ dsǿa¹² hi² ha¹chi² ma¹re² dsa² cagh¹² cog³ dsag³ mi³ma²tǿ² ja³ca¹dsiánh¹dsa ja³quiah¹³dsa. Tsa¹ca¹jmo¹dsa lah¹jøng² dsǿa¹²dsa ja³cog² dsa² fariseo. Dsa² meh² báh³ lén² ca¹lah¹já¹ dsa² mi¹juanh¹² guiog¹³. Jøng² dsa² jmo¹² hi² meh²dsa, dsa² héi² lén² dsa² canh¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jø¹² bíh³ ca¹jian¹ dsa² jue¹² guing² quián¹²dsa, mi³jøng² quiég¹ Jesús gug² ni³ quiah¹² guéng¹. Jøng² ca¹jí² dsa² quianh³ Jesús mi³ca¹jái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Cónh¹jøng² ca¹tǿh¹ Jesús guing². Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh³dsa: ―¡Ju³ji¹lé² tsih² guing² juu¹² ja³cog²jni! ¡Tsa¹jnë¹³ juu¹²! Di³ dsa² lah¹héi² báh³ dsa² li¹chian² ja³jmo¹² Diú¹³ héh¹, dsa² lán¹² ju³lah lán¹² tsih² guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² tsa¹hiug² dsǿa¹² héh¹ quiah¹² Diú¹³ ju³lah hiug² dsǿa¹² tsih² guing², dsa² héi² tsa¹dsianh¹³ ja³jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jøng² ca¹ŋai¹ jan² dsa² ta³, ca¹juúh²dsa: ―Tøa¹² dsiog¹, ¿he² hniuh¹² jmo³jni mi³jøng² dsa¹ŋë́²jni hi² li¹chian²jni tiá²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² løa¹ tøah¹²hning jní² dsa² dsiog¹? Ha¹chian² dsa² dsiog¹ chian². Jan² Diú¹³ báh³ dsa² dsiog¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ma²cueh¹² báh³ hning² lei¹³: ¡Tsa¹jŋë́h²hning dsa²! ¡Tsa¹hlanh¹³hning hio¹³ quián¹² dsa² siáh²! ¡Tsa¹høinh¹³hning! ¡Tsa¹cuøh¹³hning dsa² dsag³ tsa¹re²dsa! ¡Mi³juanh¹³hning chegh² ŋieih¹²hning! ");
INSERT INTO cpaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jøng² ca¹juúh² dsa² héi²: ―Ca¹lah¹jǿ¹ lah¹jøng² ma²ca¹can¹jni hí³ ca¹lah¹cónh¹ jmai³ meh²jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jøng² mi³ca¹nǿng² Jesús jǿg³ jøng², ca¹juúh²dsa: ―Chi² báh³ jín³ cǿng¹ hi² hei¹²: Gu²hnai³ ca¹lah¹jǿ¹ hi² chi² quiánh²hning. Jøng² cuøh¹³hning dsa² ti²ŋié², mi³jøng² li¹chi² ma¹dsio¹² quiánh²hning ŋi¹juǿi¹. Di³ jøng² ŋǿh³hning quianh¹³ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jøng² hlaih¹³ ca¹hǿi² dsǿa¹² dsa² héi² mi³ca¹nǿng²dsa jǿg³ jøng², di³ mi³chi² ma¹dsio¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mi³ca¹jái¹ Jesús, ca¹juúh²dsa: ―¡He³lah ué² dsianh¹³ dsa² chi² cog³ ja³jmo¹² Diú¹³ héh¹! ");
INSERT INTO cpaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hiug¹² jín³ tsa¹ué² ŋë́¹ jan² camello juu¹² gǿh³ hma²cog³ cónh¹ jín³ hi² ŋë́¹ dsa² chi² cog³ juu¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jøng² ca¹juúh² dsa² ca¹nǿng² jǿg³ jøng²: ―¿Hein² dsa² liúg² jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jøng² ca¹juúh² calah Jesús: ―Tiúh¹ báh³ Diú¹³ jmo¹ hi² tsa¹tiúh¹ dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jøng² ca¹juúh² Pedro: ―Jai³lah, ma²ca¹tiú¹³ jnieh³ hniu³ jnieh³. Ma²ca¹ja¹neng¹³ jnieh³ quianh¹³ hnéng¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh³dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹tiú²dsa hniu³dsa, ho¹ ju³ ca¹tiúg²dsa jin²gug²dsa, ho¹ ju³ roh¹³dsa, ho¹ ju³ chiég³ jmi³dsa, ho¹ ju³ tsih² guing², ni³ huu¹³ hi² hniu¹dsa ŋøa¹dsa juu¹² ja³jmo¹² Diú¹³ héh¹, ");
INSERT INTO cpaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dsa² héi² tan¹ tsug¹² jín³ ma¹dsio¹² ni³ jmøi¹guǿi¹ la². Jøng² tan¹dsa li¹chian²dsa tiá² jmøi¹guǿi¹ na¹ bíh³ jií¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jøng² ca¹tǿh¹ Jesús dsa² guia¹tón² tø¹cøg¹². Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Jai³lah, ma¹dsǿg³ jniang³ juu¹² jøa³juøi² Jerusalén. Ja³jøng² li¹ti¹ ca¹lah¹jǿ¹ jǿg³ rø²ton¹² ni³ si² quiah¹² dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih², jǿg³ quieg¹ jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Di³ jáinh¹dsa jní² ja³cog² dsa² tsa²lán¹² dsa² go jniang³. Dsa² héi² cu¹jmágh² jní². Hei¹dsa jní² jǿg³ hlaih¹³. Ti¹hŋiéng²dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bú²dsa. Jøng² jŋaih¹dsa. Jøng² hiog¹jni jmai³ hnøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cónh¹jøng² ha¹chi² ca¹ŋë́h² dsǿa¹² dsa² héi² jǿg³ jøng². Ca¹jnøa¹ Diú¹³ jǿg³, mi³jøng² tsa¹ca¹lø¹ŋi¹²dsa ha²lah lǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jøng² mi³guǿ¹³ jan² dsa² teg³ cøg¹² juu¹² ja³mi³ja¹quien¹³ dsiég¹³ Jesús jøa³juøi² Jericó. Møa¹² dsa² teg³ ŋi³néng². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jøng² mi³ca¹nǿng² dsa² teg³ hi² ma²ja¹lé² dsa² jue¹², ca¹ŋai¹dsa ha²lah lǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jøng² ca¹juúh² jan² dsa² hi² ma²já¹² Jesús, dsa² chian² jøa³juøi² Nazaret. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jøng² ca¹hløah¹ dsa² teg³ tí², ca¹juúh²dsa: ―¡Jesús, tsø³jong¹³ hlai³ David, huø³ jmóh³hning hoh¹² ja³cog²jni! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jøng² ca¹jí² dsa² ŋi²nio³ ma²jiá¹². Ca¹juúh²dsa hi² tsa¹tóh¹dsa møah¹³. Cónh¹jøng² ta¹lah¹tí² hi³méh¹ ca¹hløah¹dsa: ―¡Tsø³jong¹³ hlai³ David, huø³ jmóh³hning hoh¹² ja³cog²jni! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jøng² ca¹jŋi¹ Jesús. Ca¹jmo¹dsa jǿg³ hi² dsa¹téi²dsa dsa² teg³. Jøng² mi³ca¹dsiég¹ dsa² héi² ja³tsenh¹³ Jesús, ca¹juúh² Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿He² mi³hnøngh²hning jmo³jni ja³cogh²hning? Jøng² ca¹juúh² dsa² teg³: ―Juu¹³ jniang³, ju³li¹jniáng¹²jni calah ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jøng² ca¹juúh² Jesús: ―¡Ju³lé³ lah¹jøng²! Ma²hlúh² báh³ hning². Di³ héh²hning jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dsø¹juu¹² jøng² ca¹jniáng¹ mø³ni³ dsa² héi². Ca¹ŋó¹dsa quianh¹³ Jesús. Ca¹mi¹juanh¹²dsa Diú¹³. Jø¹² bíh³ lah¹jøng² ca¹lah¹já¹dsa, ca¹mi¹juanh¹²dsa Diú¹³ mi³ca¹jái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jøng² ca¹hí¹ Jesús jøa³juøi² Jericó. Ca¹ŋøa¹dsa juu¹² jøa³juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jøng² mi³guǿ¹³ jan² dsa² tsen² Zaqueo ja³jøng², dsa² lán¹² juu¹³ dsa² cagh¹² cog³ juøi². Mi³chi² ma¹dsio¹² cog³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jøng² hniu¹ dsa² héi² jë́² Jesús. Cónh¹jøng² tsa¹lé², di³ jue¹² dsa² tiogh³. Jø¹² hi² lán¹²dsa dsa² bøah¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hi² jøng² ca¹ŋøa¹dsa gu¹hei¹². Ca¹ŋó¹dsa juu¹² ni³ ja³dság¹ Jesús. Ca¹uǿi²dsa juu¹² guiuh¹³ cøng² hma² sicómoro, mi³jøng² jǿi²dsa na³ma³ca¹tsø³jue¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mi³ca¹dsiég¹ Jesús huu¹³ hma², jøng² ca¹jái¹dsa guiuh¹³. Ca¹juúh²dsa: ―Zaqueo, ¡hiugh¹² siog²! Hniuh¹² jan³jni ja³quiánh³hning na¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hi² jøng² ca¹siog²dsa dsø¹juu¹². Hioh¹² jenh¹²dsa ca¹hien¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jøng² ca¹hia¹ dsa² jue¹² Jesús jǿg³ hlaih¹³ mi³ca¹jái¹dsa: ―Ma²na²jŋi¹dsa ja³quiah¹³ dsa² re² dsag³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jøng² ca¹nung² Zaqueo. Ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Jai³lah, Juu¹³ jniang³, cuǿ¹³jni dsa² ti³ŋié² ton¹dsoh¹³ cónh¹ hi² chi² quieg¹jni. Jøng² jainh¹³jni quiún² rón² ca¹lah¹cónh¹ ja³té¹² chi²júh² he² hi² ma²ca¹cang¹jni quiah¹² dsa² quianh¹³ mai³¹ hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Na¹ jín³ ma²na²liúg² Diú¹³ dsa² tiogh³ hniú¹² la². Di³ lán¹² báh³ dsa² hniu³ tsø³jong¹³ hlai³ Abraham calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni³ huu¹³ jøng² ca¹guøn¹jni, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², hi² ŋi³hniah¹²jni dsa² ti³re² dsag³. Mi³jøng² liog³jni dsa² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jue¹² dsa² tiogh³, ti³nang¹²dsa jǿg³ jøng², mi³ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹². Di³ ja¹quien¹³ dsiég¹³dsa jøa³juøi² Jerusalén. Jø¹² bíh³ lë́² dsa² jue¹² hi² li¹jní² dsø¹juu¹² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hi² jøng² ca¹juúh²dsa: ―Jan² dsa² juanh¹², ca¹ŋó¹dsa juu¹² ja³neng¹² cøng² huø¹ tø¹guiég¹. Mi³jøng² li¹chi² bí² quiah¹²dsa hi² lén²dsa rai¹³. Jøng² dsánh¹dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Niúh¹ jín³ hi² ca¹ŋó¹dsa ca¹tǿh¹dsa guian¹ dsa² jmo¹² ta³ quiah¹²dsa. Ca¹cuúh¹dsa dsa² ma¹ton¹ ŋi²lǿg² héh¹ cog³ lah¹jan² lah¹jan². Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: “Jmo³ ta³ cog³ ná¹² ca¹lah¹ca¹guǿnh¹jni,” ca¹juúh²dsa. Jøng² ca¹ŋó¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jøng² hiag¹³ báh³ dsa² go²dsa. Ca¹tse¹ dsa² go²dsa ca²dsiog³ dsa² dsa¹cang¹ jǿg³ hi² tsa¹hniu¹dsa hi² lén² dsa² juanh¹² héi² rai¹³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Cónh¹jøng² ca¹dsiánh¹ báh³ dsa² héi² calah, hi² ma²chi² bí² quiah¹²dsa hi² lán¹²dsa rai¹³. Jøng² ca¹jmo¹ dsa² ma²lán¹² rai¹³ jǿg³ hi² tǿh¹dsa dsa² jmo¹² ta³, dsa² ca¹hiei¹ cog³ héi², mi³jøng² li¹ŋi¹² rai¹³ ha²cónh¹ jong¹² cog³ ca¹lǿh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jøng² ca¹dsiég¹ dsa² lah¹ni³. Ca¹juúh²dsa, ca¹tsáih¹dsa rai¹³: “Juu¹³ jniang³, ton¹ mei¹³ jong¹² cog³ ca¹jmo¹jni quianh¹³ cog³ ca¹cuøh³hning.” ");
INSERT INTO cpaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² héi²: “Dsio¹ báh³ jøng². Dsio¹ báh³ ta³ quiánh²hning. Cu²rø² ma²ca¹mi³tih³hning cøng² ta³ mih². Jøng² dsii¹³jni gugh²hning guie¹ juøi²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jøng² ca¹dsiég¹ dsa² ja³ma²og¹. Ca¹juúh²dsa: “Juu¹³ jniang³, cøng² mei¹³ jong¹² cog³ ca¹jmo¹jni quianh¹³ cog³ ca¹cuøh³hning.” ");
INSERT INTO cpaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jøng² ca¹juúh² rai¹³: “Jøng² dsii¹³jni gugh²hning hŋí² juøi²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jøng² ca¹dsiég¹ jín³ jan². Ca¹juúh²dsa: “Juu¹³ jniang³. La² báh³ cog³ quiánh²hning. Ca¹tóh²jni ja³lǿa¹² hí³, hi² rø²liág¹ pø³guiú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Di³ gan¹jni hning². Guiang³jni hi² lanh¹² hning² dsa² huh² dsǿa¹². Cángh²hning hi² ha¹chi² ma²ca¹quiegh²hning. Lø²chi² quiánh²hning hi² ca¹jné² dsa² siáh²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jøng² ca¹juúh² rai¹³: “Hŋiah¹ báh³ hning² ma²na²juøh³ ha²lah jmo³jni ja³cøg² dsa² tsa¹mi¹ti¹ ta³ quieg¹jni. Tsa¹dsiogh¹hning. Ma²ŋih³hning hi² lán¹²jni dsa² huh² dsǿa¹². Cáng¹²jni hi² ha¹chi² ma²ca¹co¹jni. Lø²chi² quieg¹jni hi² ca¹jné² dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿He² løa¹ tsa¹ca¹tioh¹²hning cog³ quieg¹jni banco, mi³jøng² mi³cáng¹³jni mi³ma²na²guǿnh¹jni ca¹lah¹ma¹quianh¹³ jong¹²?” ");
INSERT INTO cpaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jøng² ca¹juúh² rai¹³, ca¹tsáih¹dsa dsa² tiogh³ cøg¹²: “¡Quieng² cog³ ca¹cuǿ¹jni dsa² ná¹²! Gu³cuøh¹³ hniah¹² dsa² ca¹jmo¹ ton¹ mei¹³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jøng² ca¹juúh² dsa² tiogh³: “Juu¹³ jniang³, ma²chi² ton¹ mei¹³ quiah¹² dsa² héi²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jøng² ca¹juúh² calah rai¹³: “Lah¹dsóh² juǿi²jni hniah¹², li¹chi² ma¹dsio¹² hi³méh¹ quiah¹² ca¹lah¹já¹ dsa² ma²chi² quiah¹². Jøng² jŋih¹³jni he² hi² mih² chi² quiah¹² dsa² tsa¹chi² quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jøng² dsa² hiag¹³ jní² héi², dsa² tsa¹hniu¹ lén²jni rai¹³ quián¹²dsa, ji³jianh¹³ hniah¹² dsa² héi² ja³la². Mi³dsianh¹³ hniah¹² dsa² ja³ta¹ne¹jni,” ca¹juúh² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mi³ca¹dsii¹ Jesús jǿg³ jøng², ca¹hí¹dsa calah juu¹² dság¹²dsa jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jøng² mi³ca¹dsiég¹dsa cøg¹² juøi² Betfagé quianh¹³ juøi² Betania, huu¹³ máh² tsen² Olivo, ca¹tsen¹dsa og¹ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ca¹juúh²dsa: ―Gu²noh¹² juøi² mih² neng¹² cøg¹² ná¹². Dsianh¹² hniah¹² jan² búh³ meh² na³ma²ca¹dsi¹noh¹² hniah¹², hi² chi³hŋioh¹jah, jáh² ha¹chian² dsa² ma²gú² cah³. Tseh³ jáh². Taih³ jáh² ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jøng² ju³ná³ chian² dsa² ca¹juúh² he² løa¹ tsëh³ hniah¹² jáh², lah¹la² juaih¹³ hniah¹² dsa²: “Chi³quian¹³ Juu¹³ jniang³ jmai³,” juúh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jøng² ca¹ŋi¹lé² dsa² héi². Ca¹dsanh¹²dsa jáh² ju³lah ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jøng² ca¹juúh² juu¹³ jáh², mi³ma²tséh²dsa jáh²: ―¿He² løa¹ tsëh³ hniah¹² búh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jøng² ca¹juúh² dsa héi²: ―Chi³quian¹³ Juu¹³ jniang³ jmai³ jáh² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jøng² ca¹jian¹dsa jáh² ja³tsenh¹³ Jesús. Ca¹jiúh²dsa hmøah¹² quiah¹²dsa cah³ jáh². Jøng² ca¹jmo¹dsa ca¹gú² Jesús cah³jah. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ca¹jág¹dsa hmøah¹² quiah¹²dsa dsi²juu¹², ni³ ja³ŋøa¹² jáh² jian¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mi³ja¹quien¹³ dsiég¹³dsa jøa³juøi², ja³sióg²dsa tsag³ máh² Olivo, ca¹lah¹já¹ dsa² quianh³ Jesús ca¹jmo¹ hioh¹² jenh¹²dsa. Tí² ca¹hløah¹dsa. Ca¹mi¹juanh¹²dsa Diú¹³ ni³ huu¹³ ca¹lah¹jǿ¹ juu¹² juøh¹² ma²ca¹jái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ca¹juúh²dsa: ―Rai¹³ dsiog¹ báh³ dsa² ma²já¹², dsa² ca¹tsen¹ Diú¹³ dsa² juanh¹². Niu¹ tei³ báh³ jǿg³ quián² jniang³ ŋi¹juǿi¹, ja³guǿ¹³ dsa² hiug¹² juanh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jøng² ca¹juúh² ca²dsiog³ dsa² fariseo, dsa² ŋi²nio³ jøa³, ca¹tsáih¹dsa Jesús: ―Tøa¹², ¡Jé¹ dsa² quianh³hning! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Ca¹lah¹ca¹tǿ² cang³ mi³jmo¹ jǿg³ ju³jøng² tsa¹ca¹jmo¹ dsa² quianh³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mi³ca¹dsiég¹ Jesús cøg¹² ja³ma²jní² jøa³juøi² Jerusalén, ca¹ho¹dsa ni³ huu¹³ quiah¹² juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ca¹juúh²dsa: ―¿He² løa¹ tiog¹³ tsa¹lø²ŋih³ hniah¹² juu¹² ja³lé² li¹túgh³ hniah¹² ju²hiúg¹ dsøa¹² hi² niu¹ tei³ jǿg³ quiánh² hniah¹²? cónh¹jøng² tsa¹lø²ŋë́h² hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Di³ jøng² jií¹ jmai³ ja³ji¹lé² dsa² hianh¹³ hniah¹², dsa² túgh² lah¹jin² lah¹lǿih². Mi³jøng² tsa¹lé² cuøinh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jøng² gúg²dsa jnǿ³ tsih¹² lah¹jin² lah¹lǿih² juøi². Mi¹dsian¹²dsa hniah¹². Gúg²dsa ca¹lah¹jǿ¹ hniú¹² ca¹lah¹jin³ tsa¹ma¹tsih¹² cøng² mǿi² cang³ ni³ roh¹³. Di³ tsa¹ca¹lø¹lih¹³ hniah¹² jmai³ ja³mi³liúg² Diú¹³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jøng² mi³ca¹hí¹ Jesús niúh¹ jnǿ³ ja³tsih¹² guøh¹², ca¹huan¹dsa dsa² hnai¹² lio¹³ tiogh³ ja³jøng², quianh¹³ dsa² lá¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Li¹tsen² hniu³jni cøng² hniú¹² ja³dsø²hlaih¹² dsa² jmøi¹guǿi¹ jní²,” rø²juúh² si². Cónh¹jøng² hniah¹² ma²ca¹jmoh³ hi² ma²lǿa¹² hniu³ dsa² høin² ―ca¹juúhdsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jøng² ca¹he¹ Jesús jǿg³ guøh¹² ca¹lah¹jǿ¹ jmai³. Hi² jøng² ca¹hnangh² juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quianh¹³ dsa² quin¹² ni³ juøi² mai³¹ ha²lah jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Cónh¹jøng² ha¹chi² ca¹dsóh²dsa mai³¹, di³ cu²rø² ti³nang¹² ca¹lah¹já¹ dsa² juøi² jǿg³ he¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cøng² jmai³ mi³hiúg³ Jesús guøh¹² heh¹²dsa dsa² juøi² jǿg³, hǿ²dsa jǿg³ dsio¹ quiah¹² Diú¹³. Jøng² ca¹dsi¹lé² juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ quianh¹³ dsa² quin¹² ni³ juøi² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ―Juaih¹³hning jnieh³ he² jǿg³ ca¹të́h²hning hi² heh¹²hning jǿg³ ja³la². ¿Hein² ca¹cuø¹ jǿg³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jøng² ca¹juúh² Jesús: ―Jø¹² bíh³ ŋai³jni hniah¹² cøng² jǿg³. Juaih¹³ hniah¹² jní²: ");
INSERT INTO cpaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Hein² dsa² ca¹tsen¹ Juan hi² ca¹chiog¹dsa dsa² jmøi²? ¿Ca³tsen¹ Diú¹³ ho¹ ju³ dsa² jmøi¹guǿi¹ báh³? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jøng² ca¹dsii¹ dsa² héi² jǿg³ guiog¹³ ca¹juúh²dsa: ―¿Ha²lah dsio¹ juúh³ jniang³? Ju³ná³ ca¹juúh³ jniang³ hi² ca¹tsei¹ Diú¹³, jøng² ŋai¹dsa: “¿He² løa¹ tsa¹ca¹héh¹ hniah¹² jǿg³ quiah¹²dsa jøng²?” ");
INSERT INTO cpaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jøng² ju³ná³ ca¹juúh³ jniang³ hi² ca¹tsei¹ dsa² jmøi¹guǿi¹, jøng² qui¹tiágh² dsa² juøi² jniang³ cang³, di³ hé² dsa² juøi² jǿg³ hi² mi³hǿ² Juan jǿg³ quiah¹² Diú¹³ ―juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jøng² ca¹juúh² dsa² héi² hi² tsa¹ŋi¹²dsa hein² dsa² ca¹tsen¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jøng² ca¹juúh² calah Jesús: ―Hi² jøng² tsa¹juǿi³jni hniah¹² hein² dsa² ca¹cuø¹ jǿg³ hi² jmo¹²jni ju³lah jmo¹²jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jøng² ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹². Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² tiogh³: ―Jan² dsa² ŋioh¹², ca¹jné²dsa chiúh³ gu²jøah¹³. Jøng² mi³ca¹dsii¹dsa ju²gug² dsa² jmo¹² hí³, ca¹ŋó¹dsa ja³siíh³. Ja³jøng² ca¹lø¹han³dsa hi² uú². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mi³ca¹tǿ² jmai³, ca¹tsen¹dsa jan² dsa² jmo¹² ta³ quiah¹²dsa, hi² mi³ŋi¹quieng¹dsa cónh¹ hi³ tan¹dsa quiah¹² huø¹. Cónh¹jøng² ca¹bú² dsa² jmo¹² hí³ huø¹. Ca¹dsíanh²dsa dsa² ca¹tsen¹ juu¹³dsa hi² lán¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jøng² ca¹tsen¹ calah juu¹³dsa dsa² siáh² quián¹²dsa. Jø¹² bíh³ ca¹bán²dsa dsa² héi² calah. Hlaih¹³ ca¹jmo¹dsa ja³cog² dsa² héi². Jøng² ca¹dsiánh²dsa dsa² hi² lán¹dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jøng² ca¹tsen¹ juu¹³dsa dsa² ja³ma²úg². Jøng² ca¹tióg²dsa dsa² héi², mi³ca¹cuúh¹dsa dsa² jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jøng² ca¹juúh² juu¹³dsa: “¿Ha²lah jmo¹³jni? Tsë³ báh³ jní² ja²ŋiúh¹jni, dsa² hnó¹jni. Mi¹juanh¹² báh³ dsa² tsih² quian¹jni,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Cónh¹jøng² mi³ca¹jë́² dsa² jmo¹² hí³ huø¹ ja³ŋiúh³ juu¹³dsa, ca¹juúh²dsa, ca¹tsáih¹dsa guiog¹³dsa: “Dsa² ná¹² báh³ dsa² tan¹ huø¹ na³ma²ca¹jon¹ ti³jmi²dsa. Dsio¹ jŋëh¹³ jniang³ dsa². Jøng² tai¹ jniang³ huø¹,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jøng² ca¹tióg² dsa² héi² ja³ŋiúh³ juu¹³dsa coh¹³ jnǿ³ ja³ca¹jŋaih¹dsa. ¿Ha²lah jmo¹ juu¹³dsa ja³cog² dsa² héi²? ");
INSERT INTO cpaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jógh¹ báh³ dsa². Mi¹dsian¹²dsa dsa² héi². Jøng² dsii¹dsa huø¹ ju²gug² dsa² siáh² ―ca¹juúh² Jesús. Jøng² mi³ca¹nǿng² dsa² tiogh³ jǿg³ jøng², ca¹juúh²dsa: ―¡Tsa¹ju³lé³ lah¹jøng²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jøng² ca¹jë́² Jesús dsa² tiogh³. Ca¹juúh²dsa: ―¿Ha²lah lǿa¹² jøng²? ¿He² hniu¹dsa juúh²dsa jǿg³ la² lǿa¹² ni³ si² quiah¹² Diú¹³? Lah¹la² rø²juúh² si²: Cang³ tsa¹jih² dsa² ca¹jmo¹ hniú¹², cang³ jøng² báh³ ma²jmo¹² hi² tsih¹² hniú¹² tí², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ju³ná³ hein² dsa² tsa¹hé² jǿg³ quieg¹ jní², dsa² héi² dsa¹hén². Dsián¹ báh³ ca¹lah¹já¹ dsa² ca¹lø¹hné¹jni quianh¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dsø¹juu¹² jøng² ca¹jmo¹ tøa¹² he¹² lei¹³ quianh¹³ juu¹³ jmi²dsa² bí² hi² mi³chiánh²dsa Jesús. Di³ ca¹lø¹lih¹³dsa hi² ca¹dsii¹ Jesús jǿg³ ti³jnøa¹² jøng² ni³ huu¹³ quiah¹²dsa. Cónh¹jøng² ha¹chi² ca¹chiángh²dsa. Di³ gan¹dsa dsa² juøi² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hi² jøng² ca¹jái¹dsa cu²rø² ha²lah jmo¹² Jesús. Ca¹tsen¹dsa dsa² ca¹tiag¹, dsa² jniá² ju³lah jniá² dsa² hiug² dsǿa¹². Mi³jøng² ca¹nǿng²dsa chi²júh² he² jǿg³ juúh² Jesús hi² mi³jmo¹ ta¹canh¹³dsa dsag³ ni³ dsi³máh². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa Jesús: ―Tøa¹², ma²ne³ jnieh³ hi² lanh¹²hning dsa² té¹² jǿg³. Cu²rø² heh¹²hning jǿg³. Cøng² ni³ jmoh²hning ja³cog² ca¹lah¹já¹ dsa² chian². Lah¹dsóh² heh¹² báh³ hning² juu¹² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Juaih¹³hning jnieh³: ¿Dsio³¹ cuú³ jniang³ cog³ cagh¹² rai¹³ romano, ho¹ ju³ tsa¹dsio¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Cónh¹jøng² ca¹lø¹lih¹³ Jesús hi² hniu¹ mi¹gag¹² dsa² héi². Hi² jøng² ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―¡Ju³jái¹³jni cøng² ŋi³néng²! ¿Hein² nióh³ quiah¹² rø²ton¹²? ―ca¹juúh² Jesús. ―Nióh³ quiah¹² rai¹³ romano báh³ jøng² ―ca¹ŋai¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Hi² jøng² dsio¹ mi³tih³ hniah¹² ja³cog² rai¹³, ju³lah lǿa¹² jǿg³ quiah¹² rai¹³. Jøng² dsio¹ mi³tih³ hniah¹² ja³cog² Diú¹³ calah, ju³lah lǿa¹² jǿg³ quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hi² jøng² tsa¹ca¹tiúh¹ dsa² héi² jmo¹ hi² li¹juúh² Jesús jǿg³ siíh² ja³tiogh³ dsa² jue¹². Dsogh¹² dsǿa¹²dsa guiog¹³dsa ha²lah ca¹jenh¹ Jesús jǿg³ quiah¹²dsa. Hi² jøng² ha¹chi² jǿg³ ma¹ca¹jmo¹dsa ni³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jøng² ca¹dsi¹lé² ca²dsiog³ dsa² saduceo ja³tsenh¹³ Jesús, dsa² juúh² tsa¹hiog¹ jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ca¹ŋǿh¹ dsa² héi² Jesús cøng² jǿg³. Ca¹juúh²dsa: ―Tøa¹², lah¹la² lǿa¹² si² ca¹jmo¹ hlai³ Moisés: Ju³ná³ jan² dsa² ca¹jon¹, chian² báh³ hio¹³ quián¹²dsa, ha¹chian² guing² ma²chian², jøng² hniuh¹² jian¹ roh¹³ hlai³ hio¹³ hnǿi² quián¹² hlai³. Mi³jøng² li¹chian² tsø³jong¹³ hlai³, hi² lǿa¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jøng² mi³chian² guiog¹ dsa² ŋioh¹², dsa² lán¹² roh¹³. Dsa² ne¹³ ca¹jian¹ hio¹³. Jøng² ca¹jon¹dsa ha¹chian² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jøng² ca¹jian¹ dsa² ja³ma²og¹ hio¹³ quián¹² hlai³. Jø¹² bíh³ ca¹jon¹ dsa² ŋioh¹² héi² ha¹chian² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ni³ jøng² calah dsa² ja³ma²úg² ca¹jiag¹. Ca¹lah¹ja³ca¹tǿ² ca¹lah¹jǿ¹ guiog¹dsa ca¹jiag¹. Ca¹dsan¹dsa cu¹dsie¹²dsa ha¹chian² jong¹²dsa ca¹lø¹chián¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ni jøng² ca¹jon¹ hio¹³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ha²lah lǿa¹² na³ma²tǿ² ja³ca¹hiog²dsa? ¿Hein² dsa² li¹quián¹² hio¹³ jmai³ jøng²? Di³ ca¹lah¹jǿ¹ guiog¹ báh³ dsa² ma²ca¹jiag¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jøng² ca¹juúh² Jesús: ―Dsa² ti³jenh² gug² báh³ dsa² chian² jmøi¹guǿi¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cónh¹jøng² ha¹chi² jenh¹ gug² dsa² jmo¹ Diú¹³ dsǿa¹² ta³tén¹³dsa hiog¹dsa, mi³jøng² li¹chian²dsa jmøi¹guǿi¹ cøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Di³ tsa¹ma¹lé² dsián¹ dsa² lah¹héi². Ma²lán¹²dsa cu²re²dsa quianh¹³ ángeles. Ma²lán¹²dsa jong¹² Diú¹³, dsa² ma²ca¹hiog². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Cónh¹jøng² hŋiah¹² hlai³ Moisés ca¹mi¹léi¹³ hi² hiog¹ dsa² ma²ca¹dsan¹ ja³rø²ton¹² jǿg³ quiah¹² chiúh³ tang¹² mi³chi³hiúh² si². Ja³jøng² ca¹hia¹dsa Diú¹³ Juu¹³ jniang³, Diú¹³ quián¹² hlai³ Abraham, Diú¹³ quián¹² hlai³ Isaac, Diú¹³ quián¹² hlai³ Jacob. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jøng² ma²ŋih³ hniah¹² hi² tsa¹lán¹² Diú¹³ Diú¹³ quián¹² dsa² tsa¹ma¹chian². Lán¹²dsa Diú¹³ quián¹² dsa² chian². Di³ chian² ca¹lah¹já¹ báh³ dsa² ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jøng² ca¹juúh² ca²dsiog³ tøa¹² quiah¹² lei¹³: ―Dsio¹ báh³ jǿg³ ma²na²juúh²hning, Tøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jøng² ha¹chian² dsa² héi² ma¹tí² dsǿa¹² ŋǿh¹dsa Jesús jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jøng² ca¹juúh² Jesús: ―¿Ha²lah lé² li¹juúh²dsa hi² lán¹² Cristo jong¹² hlai³ David? ");
INSERT INTO cpaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Di³ lah¹la² ca¹juúh² hŋiah¹² hlai³ David, jǿg³ lǿa¹² ni³ si² Salmos: Ca¹tsáih¹ Juu¹³ jniang³ Juu¹ jní²: “Ní² cog²jni ta¹lah¹guia¹jo¹³ ");
INSERT INTO cpaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ca¹lah¹ca¹tǿ² ja³ca¹jmo¹jni ca¹tiah¹hning quianh¹³ dsa² hiag¹³ quiánh²hning,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Hŋiah¹² David ca¹tǿh¹ Cristo Juu³dsa. ¿Ha²lah lǿa¹² jøng² hi² lán¹² Cristo tsø³jong¹³dsa? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jøng² ca¹tsáih¹ Jesús dsa² quianh³dsa ja³ti³nang¹² dsa² jue¹². Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Jmóh³ hniah¹² ju²hí³ dsøa¹² quiah¹² tøa¹² he¹² lei¹³. Dsa² héi² hniu¹ cáih¹ hmøah¹² jláh³. Hniu¹dsa hi² jenh¹³dsa dsa² canh¹³ ja³ŋi³nio³dsa jøa³hmah³. Hniu¹dsa túgh²dsa ja³jláh³ dsi²néi² guøh¹² quianh¹³ ja³jmo¹²dsa jmai³ juøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dsa² héi² jŋíh² hi² chi² quiah¹² hio¹³ hnǿi². Jøng² ma¹dsio¹² jǿg³ hlanh¹²dsa Diú¹³, hi² ta³dsǿa¹² jmo¹²dsa, mi²gan¹²dsa dsa² juøi². Hiug¹² jín³ ma¹dsio¹² dsag³ ta¹canh¹³ dsa² héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ca¹jë́² Jesús dsa² chi² cog³, ma²ni³toh¹²dsa cog³ gog¹², hi² dsii¹²dsa ni³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jøng² ca¹jë́²dsa jan² hio¹³ hnǿi², dsa² ti²ŋié². Ca¹tóh² hio¹³ ton¹ ŋi³néng² ma¹hŋí². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: Ma¹dsio¹² cog³ na²tóh² hio¹³ hnǿi², dsa² ti²ŋié² ná¹², cónh¹ jín³ ca¹lah¹já¹ dsa² siáh². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Di³ toh¹² dsa² jue¹² cónh¹ hi² chiág² quiah¹²dsa. Cónh¹jøng² ti²ŋié² báh³ hio¹³. Na²tóh²dsa ca¹lah¹jǿ¹ hi² mi³chi² quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ca²dsiog³ dsa² mi³dsii¹² jǿg³ quiah¹² guøh¹². Lë́²dsa lǿa¹² hiug¹² dsio¹ quianh¹³ cang³ jláh³ quianh¹³ hi² la³ca¹cuø¹ dsa² jmai³ ca¹jmo¹dsa guøh¹². Jøng² ca¹juúh² Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Lah¹la² lé² quiah¹² hi² jáih² hniah¹²: Jií¹ jmai³ ja³gug¹ ca¹lah¹jǿ¹. Cu¹dsie¹² tsa¹ma¹lé² hi² ti³juú¹³ jin³ cøng² mǿi² cang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jøng² ca¹juúh² dsa² quianh³dsa, ca¹tsáih¹dsa Jesús: ―Tøa¹², ¿ha²lǿih² lé² lah¹jøng²? ¿He² quianh¹³ li¹lih¹³ jnieh³ na³ma²ja¹quien¹³ lé² lah¹jøng²? ");
INSERT INTO cpaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jøng² ca¹juúh² Jesús: ―¡Jmo³ hí³ tsa¹ju³mi¹gan¹² dsa² hniah¹²! Di³ jue¹² dsa¹ ji¹lé², dsa² jmo¹ hi² lán¹²dsa jní². Juúh²dsa: “Jní² báh³ lang¹². Ca¹tǿ² jmai³,” juúh²dsa. Cónh¹jøng² tsa¹gu³noh¹² hniah¹² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jøng² tsa¹jmóh³ hniah¹² ganh¹ na³ma²ca¹nengh² hniah¹² jǿg³ hi² ma²tán¹²dsa, ma²jmo¹²dsa hning². Hniuh¹² lé² lah¹jøng² ni³jiá¹. Cónh¹jøng² hei¹² hi³méh¹ ja³ca¹tóh² jø² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jøng² ca¹juúh² Jesús calah, ca¹tsáih¹dsa dsa² quianh³dsa: ―Tán¹ juøi² quianh¹³ juøi² siíh². Tán¹ dsa² ta³ quianh¹³ dsa² ta³ jian¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hliú² ja³tiíh¹ onh¹². Hliú² ja³jií¹ hag³cón³. Li¹chi² jmø³uai¹². Li¹jni¹ juu¹² juøh¹² quianh¹³ hi² gøg² guiuh¹³ ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Cónh¹jøng² lah¹ni³ chiánh²dsa hniah¹², niúh¹ jín³ hi² lé² lah¹jøng². Cuúh¹dsa hniah¹² jmø³uai¹². Jë́h²dsa hniah¹² ja³ta¹ni¹ dsa² ta³ quián¹² guøh¹² quiah¹²dsa. Tangh¹dsa hni¹ŋí³. Jian¹dsa hniah¹² ja³ta¹ni¹ rai¹³ quianh¹³ dsi³máh² ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mi³jøng² lé² juaih¹³ hniah¹² dsa² héi² ha²lah lǿa¹² jǿg³ ma²héh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jøng² cøng² ni³ jmóh³ hniah¹² hoh¹² hi² tsa¹ŋih¹³ hnángh³ hniah¹² jǿg³ hi² juaih¹³ hniah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Di³ hé¹³jni hniah¹² he² jǿg³ juúh³ hniah¹² jmai³ jøng². Jmo¹³jni lénh² hniah¹² dsa² lah¹dsóh² ma²ŋi¹² jǿg³. Mi³jøng² tsa¹tiúh¹ dsa² hiag¹³ li¹dsii¹ jǿg³ quianh¹³ hniah¹². Tsa¹tø¹tsøh¹³ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ca¹lah¹ja³ca¹tǿ² guiog¹³ chiégh² ŋieih¹² hniah¹² quianh¹³ ju²rúh² hniah¹² quianh¹³ ha²mei¹³ quiánh² hniah¹², jë́h² dsa² héi² hniah¹². Jøng² mi¹dsian¹²dsa ca²dsiogh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Li¹hiag¹³ dsa² jue¹² ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Cónh¹jøng² ha¹chi² hi² lé² quiah¹² jin³ cøng² hmëh¹² jŋiu² ti³dsøa¹³ dseih¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jøng² li¹chianh² hniah¹² ja³cog² Diú¹³. Di³ hi² tiogh³ hniah¹² tí² neng¹² hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Na³ma²ca¹jaih³ hniah¹² hi² ma²tiogh³ hlég² lah¹jin² lah¹jǿih¹ ja³neng¹² jøa³juøi² Jerusalén, jøng² ma²ŋih³ hniah¹² ma²tǿ² ja³ja¹quien¹³ dsa¹hén² juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ju³cuøin¹³ dsa² tiogh³ ja³tén¹² Judea juu¹² máh² jmai³ jøng². Ju³huanh¹dsa jøa³juøi² Jerusalén, chi²júh² hein² dsa² tiogh³ ja³jøng². Tsa¹ju³dsa¹tiogh¹²dsa jøa³juøi², chi²júh² hein² dsa² ma²tiogh³ máh². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Di³ jmai³ jøng² li¹chi² ju²lih¹³ dsøa¹². Li¹ti¹ ca¹lah¹jǿ¹ jǿg³ rø²juúh² ni³ si² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡He³ báh³ ué² quiah¹² hio¹³ quian¹² guing² jmai³ jøng²! ¡Ué² quiah¹² dsa² jian¹² guing² píh³ cøgh² dsiúh³! Di³ li¹chi² jmø³uai¹² hiug¹² ja³tén¹² Judea. Li¹hian¹³ Diú¹³ dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dsián¹ dsa² jue¹² quianh¹³ ŋi³tǿi¹. Jøng² chiánh²dsa dsa² jue¹² calah. Tsei¹dsa juu¹² go² dsa² siáh², dsa² tsa¹lán¹² judío. Dsa² siáh² héi² li¹dsen¹³ jøa³juøi² Jerusalén ca¹lah¹ja³ca¹hian¹² jmai³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Jøng² lé² hi² siíh² quiah¹² hieg² quianh¹³ tsøh² quianh¹³ chi³neng¹². Li¹chian² dsa² jmøi¹guǿi¹ ju²hí³ dsøa¹², di³ hiug¹² ma²hein¹³ ma²tsøg² jmø³ŋih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hlih² dsǿa¹² dsa² jue¹², hi² hiug¹² goh¹²dsa. Tsa¹ŋi¹²dsa ha²lah lé² quiah¹² jmøi¹guǿi¹. Di³ ma²lǿa¹² hi² siíh² quiah¹² si² ti³buh¹² guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ni³ jøng² jái¹ dsa² jmøi¹guǿi¹ hi² ma²guiogh¹² jní² jøa³jneng¹², lán¹²jni dsa² juanh¹², dsa² chi² bí², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hi² jøng² túgh³ hniah¹² cu²rø² hioh¹² jénh² hniah¹² na³ma²ca¹hǿi² ni³ ca¹lah¹jǿ¹ hi² jøng². Di³ ma²ŋih³ hniah¹² ma²ja¹quien¹³ jmai³ ja³liúgh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jøng² ca¹dsii¹ Jesús cøng² jǿg³ ti³jnøa¹², ca¹tsáih¹dsa dsa² quianh³dsa: ―Jai³lah ha²lah lǿa¹² hma² higo quianh¹³ ca¹lah¹i³ ni³ hma²: ");
INSERT INTO cpaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ma²ŋih³ hniah¹² ja¹quien¹³ jií¹ jin² jmǿa¹² na³ma²hiag² moh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jø¹² bíh³ lah¹jøng² ma²ŋih³ hniah¹² ma²ja¹quien¹³ ja³jmo¹ Diú¹³ héh¹ na³ma²lø²ti¹ jǿg³ ma²na²juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹jin³ dsián¹ ca¹lah¹já¹ dsa² chian² na¹ ca¹lah¹ca¹tǿ² ja³ca¹lø¹ti¹ ca¹lah¹jǿ¹ hi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dsa¹hén² báh² jmøi¹guǿi¹ ca¹lah¹quianh¹³ hi² tioh¹³ guiuh¹³. Cónh¹jøng² ha¹chi² dsa¹hén² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Jøng² jmóh³ hniah¹² hí³. Mi³jøng² tsa¹li¹chianh² hniah¹² jmáh¹lah juu¹² hlaih¹³, hi² ŋi³nioh³ hniah¹² ti³henh¹² hniah¹², hi² ti³quinh³ hniah¹² ju²hí³ dsøa¹² quiah¹² jmøi¹guǿi¹ la². Ju³ jøng² ma²jmoh² hniah¹² jmáh¹lah hi² siíh² jmai³ jøng². Hi² tsa¹tiogh³ hniah¹² ju²jŋia¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Di³ tøa¹ jmai³ jøng² quiah¹² ca¹lah¹já¹ dsa² chian² ni³ guøh³ ni³ huø¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hi² jøng² cøng² hi² túgh³ hniah¹² ju²jŋia¹³. Hlanh¹³ hniah¹² Diú¹³ hi² li¹chi² bí² quiánh² hniah¹². Mi³jøng² tsa¹cánh³ hniah¹² jmø³uai¹² jøng² na³ma²ca¹lø¹ti¹ ca¹lah¹jǿ¹ hi² jøng². Mi³jøng² lé² li¹quianh¹³ hniah¹² jní², dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jøng² ca¹he¹ Jesús jǿg³ guøh¹² ca¹lah¹jǿ¹ jmai³. Ca¹u¹hái¹dsa jøa³juøi² ja³neng². Ca¹güe²dsa ni³ máh² tsen² Olivo. ");
INSERT INTO cpaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta¹ŋih¹³ ca¹túgh² dsa² jue¹² lah¹cøng² lah¹cøng² jmai³ ja³tsenh¹³dsa guøh¹². Mi³jøng² ca¹nǿng²dsa jǿg³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma²ja¹quien¹³ tøa¹ jmai³ ja³gøah¹²dsa hi³ŋíh¹ tsa¹quianh¹³ chiúh³, jmai³ tǿh²dsa jmai³ ta²høa³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma²dsø²hnangh¹² juu¹³ jmi²dsa² quianh¹³ tøa¹² he¹² lei¹³ mai³¹ ha²lah jŋëh¹dsa Jesús. Ué² quiah¹²dsa, di³ gan¹dsa dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jøng² ca¹jiag¹ dsa² hlanh³ quiah¹² Judas, dsa² tǿh²dsa Iscariote, dsa² quianh¹³ dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mi³jøng² ca¹ŋi³jan¹³ dsa² héi² juu¹³ jmi²dsa² quianh¹³ comandante quián¹² guøh¹². Ca¹ŋi³jmó³dsa jǿg³ ha²lah hnë¹dsa Jesús ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ca¹tǿ² dsǿa¹² juu¹³ jmi²dsa² quianh¹³ comandante. Ca¹juúh²dsa hi² cuúh¹dsa Judas cog³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jøng² ca¹lø¹hiúg¹ dsǿa¹² Judas. Ca¹hnangh²dsa mai³¹ ha²lah mi³hnë¹dsa Jesús ja³tsa¹jái¹ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jøng² ca¹tǿ² jmai³ ja³gøah¹²dsa hi³ŋíh¹ tsa¹quianh¹³ chiúh³, jmai³ jŋëh¹²dsa jah¹chih² meh² quián¹² høa³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hi² jøng² ca¹tsen¹ Jesús Pedro quianh¹³ Juan. Ca¹juúh²dsa: ―Gu³jmoh³ hniah¹² ju²jŋia¹³ ja³dsa³quie¹³ jniang³ jmai³ ta²høa³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa Jesús: ―¿Ha² tøah¹ hnøngh²hning hi² dsø³jmó³ jnieh³? ");
INSERT INTO cpaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jøng² ca¹juúh² calah Jesús: ―Jai³lah, jénh³ hniah¹² jan² dsa² ŋioh¹² quieng² cøng² dsøg³ jmøi² ja³gu³tiogh³ hniah¹² jøa³juøi². Ti³dséh³ hniah¹² cah³ dsa² héi² ca¹tǿ² ja³hí¹dsa dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ja³jøng² juaih¹³ hniah¹² dsa² hniu³: “Lah¹la² juúh² Tøa¹², tsaih¹²dsa hning²: ¿Nai¹² hniú¹² dsa³quie¹³ jnieh³ jmai³ ta²høa³ quianh¹³ dsa² quianh³jni? juúh²dsa,” juaih¹³ hniah¹² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jøng² heh¹dsa hniah¹² cøng² hniú¹² juøh¹² ja³ma²ton¹ jué¹ hi² ma²tioh¹³ hi² hniuh¹². Ja³jøng² gu³jmoh³ hniah¹² ju²jŋia¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jøng² ca¹ŋi¹lé² dsa² héi². Ca¹løa¹ ju³lah ma²na²juúh² Jesús. Jøng² ca¹jmo¹dsa ju²jŋia¹³ quiah¹² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mi³ca¹dsiég¹ hora, ca¹túgh² Jesús mesa quianh¹³ dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jøng² ca¹juúh² Jesús: ―Hiug¹² ma²ca¹lø¹hno¹jni gøah¹³jni jmai³ ta²høa³ la² quianh¹³ hniah¹² cónh¹ niúh¹ jín³ hi² can³jni jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Di³ lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² ma¹gøah¹³jni calah jmai³ ta²høa³ ca¹lah¹ca¹tǿ² ja³quie¹³ jniang³ jmai³ ja³jmo¹² Diú¹³ héh¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jøng² ca¹cáng¹ Jesús cuøh³. Ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹juúh²dsa: ―¡Quieng² cuøh³! ¡Hǿgh³ hniah¹² ma¹méh¹! ");
INSERT INTO cpaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Di³ ni³ na¹ ja³já¹³ ha¹chi² ma¹gøh¹³jni jmøi² møi¹gu³jøah¹³ ca¹lah¹ca¹tǿ² jmai³ ja³ma²tiagh³ jniang³ ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jøng² ca¹cáng¹dsa hi³ŋíh¹. Mi³ca¹tsáih¹dsa Diú¹³ di³hmah³, jøng² ca¹jmo¹dsa ti³jneh³. Ca¹cuúh¹dsa dsa² quianh³dsa. Ca¹juúh²dsa: ―Jmø²ŋǿ¹² quieg¹ báh³ jní² la². Cuø¹³jni jmø³ŋø³jni ni³ huu¹³ quiánh² hniah¹². Lah¹la² cǿh³ hniah¹² ja³dsagh² hoh¹² hniah¹² jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jø¹² bíh³ lah¹jøng² ca¹cáng¹dsa cuøh³ mi³ma²na²gǿh¹dsa, ca¹juúh²dsa: ―Lǿa¹² jmøh¹³ møi¹gu²jøah¹³ hǿgh³ hniah¹² la² ju³lah cøng² jǿg³ hmë́² jmo¹³jni quianh¹³ jmø² han¹³jni ni³ huu¹³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Cónh¹jøng² jáih³ hniah¹²: Dsa² hnai¹ jní² ma²guǿ¹² mesa quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Di³ lé² quieg¹ jní² ju³lah ma²lǿa¹² jǿg³, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Cónh¹jøng² ué² lé² quiah¹² dsa² ca¹hnai¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jøng² ca¹dsii¹ dsa² guia¹tón² jǿg³ guiog¹³ hein² dsa² mi³jmo¹ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jøng² ma²neng¹² jǿg³ quiah¹² dsa² guia¹tón². Cø²tsë́²dsa hein² dsa² quianh¹³dsa lén² dsa² juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Jmo¹² rai¹³ chian² jmøi¹guǿi¹ hi² lán¹²dsa dsa² canh¹³ cónh¹ jín³ dsa² juøi² jian¹²dsa. Dsa² chi² bí² tǿh²dsa juu¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","A¹jáng¹ lah¹jøng² lǿa¹² quiánh² hniah¹². Dsio¹ lén² dsa² lán¹² dsa² juanh¹² quianh¹³ hniah¹² ju³lah jan² dsa² meh². Dsio¹ mi¹ti¹ dsa² quin¹² ni³ quiánh² hniah¹² neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Hein² dsa² lán¹² dsa² juanh¹² hi³méh¹, dsa² guǿ¹² mesa, ho¹ ju³ dsa² mi²ti¹ ni³dsa? Dsa² guǿ¹² mesa báh³ dsa² juanh¹². Cónh¹jøng² ma²ca¹guio¹jni quianh¹³ hniah¹² ju³lah jan² dsa² mi²ti¹ neih³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Hniah¹² báh³ dsa² cøng² ma²ca¹ŋi³nioh³ quianh¹³ jní² ja³ca¹mi¹dsian¹²dsa dsøa¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hi² jøng² cuǿ¹³jni hniah¹² cøng² ja³jmóh³ hniah¹² héh¹, ju³lah ma²ca¹cuø¹ ti³ŋieh¹jni quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mi³jøng² tiágh³ jniang³ mesa cu¹dsie¹² ja³jmo¹³jni héh¹. Jøng² túgh³ hniah¹² ja³mi³rǿh³ hniah¹² jǿg³ quiah¹² ca¹lah¹jǿ¹ guie¹tǿn² juøi² dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","’Simon, jai³lah, hiug¹² ca¹møa¹ dsa² hlanh³ jǿg³ hi² li¹quián¹²dsa hniah¹², mi³jøng² cán²dsa jǿg³ dsøg¹² quiánh² hniah¹² chi²júh² lah¹dsóh² héh² hniah¹² jǿg³ quieg¹jni. Jmo¹dsa quianh¹³ hniah¹² ju³lah jan² dsa² juú² cuøi² hi³ŋíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Cónh¹jøng² ma²ca¹hlanh¹³jni Diú¹³ ni³ huu¹³ quiánh² hning². Mi³jøng² tsa¹dsø¹hén² hoh¹²hning jǿg³ héh²hning. Hi² jøng² hning², na³ma²ca¹jenh¹ hning juu¹², cuøh¹³hning rúh²hning bí². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jøng² ca¹juúh² Pedro: ―Juu¹³ jniang³, ma²hiug² dsøa¹jni nei¹³jni quianh¹³ hnéng¹, ju³ lah¹la² ca¹tangh²dsa hni¹ŋí³, ju³ lah¹la² ca¹jŋøih¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jøng² ca¹juúh² calah Jesús: ―Lah¹dsóh² juǿi²jni hning², Pedro: Na¹ ja³neng², cónh¹ niúh¹ jín³ hi² ho¹ chiih³, hnøa¹² rón² juúh³ hning² hi² tsa¹cuaih¹²hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jøng² ca¹ŋǿh¹ Jesús dsa² guia¹tón², ca¹juúh²dsa: ―¿Tsa³ca¹løa¹ chi³quianh¹³ hniah¹² jmai³ jmai³ ca¹tsë́²jni hniah¹² hi² tsa²mi³quinh³ hniah¹² cog³ quianh¹³ mu²ra³ quianh¹³ løg² ca²jag¹³? Jøng² ca¹juúh² dsa² héi²: ―Ha¹chi². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jøng² ca¹juúh² Jesús: ―Na¹ jín³ ma²lé² cánh³ hniah¹² cog³, chi²júh² hein² hniah¹² chi² cog³. Dsio¹ cánh³ hniah¹² mu²ra³. Jøng² ju³ná³ hein² dsa² tsa¹chi² ŋí³, dsio¹ hnai¹dsa hmøah¹² dsiég², mi³jøng² lá¹dsa ŋi³tǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Di³ tiog¹³ báh³ hniuh¹² li¹ti¹ jǿg³ la² ja³cog²jni, jǿg³ lǿa¹² ni³ si²: “Jmo¹dsa hi² lán¹²dsa ju³lah lán¹² dsa² ti³re² dsag³,” rø²juúh² si². Li¹ti¹ báh³ ca¹lah¹jǿ¹ jǿg³ lǿa¹² ni³ si² ja³cog²jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jøng² ca¹juúh² dsa² guia¹tón²: ―Jai³lah, Juu¹³ jniang³, quin³ jniang³ ton¹ ŋi³tǿi¹. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Tiúh¹ báh³ ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jøng² ca¹u¹hái¹ Jesús ja³jøng². Ca¹ŋó¹dsa juu¹² máh² Olivo ju³lah ma²lǿa¹² mai³¹ quiah¹²dsa. Dsen¹³ dsa² quianh³dsa cah³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mi³ma²na²dsiég¹dsa, ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh³dsa: ―Hlanh¹³ hniah¹² Diú¹³ hi² tsa¹tiáh¹ hniah¹² dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jøng² ca¹ŋó¹dsa tø¹cøg¹² ja³cu²hŋiah¹²dsa ca¹lah¹cónh¹ ja³li¹taih¹² cøng² møi¹cang³ téng²dsa. Jøng² ca¹chi¹jné¹dsa. Ca¹hlanh¹dsa Diú¹³: ");
INSERT INTO cpaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Jmi² jniang³, chi²júh² ha²lah hnøngh²hning, lég² jní² hi² tsa¹can³jni jmø³uai¹² la². Cónh¹jøng² tsa¹lé² ca¹lah¹cónh¹ ja³hno¹ jní². Hning² ma²ŋih³ ha²lah jmóh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jøng² ca¹jë́² Jesús jan² ángel chian² ŋi¹juǿi¹. Ca¹cuúh¹ ángel Jesús bí². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jøng² hiug¹² jín³ tí² ca¹hlanh¹ Jesús Diú¹³. Di³ hlaih¹³ jenh¹²dsa. Ca¹téng¹dsa mi³dsieg² ju³lah jan² dsa² téng² jmø² ni³ huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mi³ma²na²jŋi¹dsa hlanh¹²dsa Diú¹³, jøng² ca¹nung²dsa. Ca¹ŋó¹dsa juu¹² ja³tiogh³ dsa² quianh³dsa. Ca¹dsanh¹²dsa dsa² héi², hi² ma²ti³güé¹dsa. Di³ hiug¹² ma²ca¹táh² cøh² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² løa¹ rø²güéh¹ hniah¹²? ¡Nung²! ¡Hlanh¹³ hniah¹² Diú¹³, mi³jøng² tsa¹tiáh¹ hniah¹² dsag³! ");
INSERT INTO cpaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ca¹lah¹cónh¹ chi³hløah¹² Jesús, ca¹dsi¹lé² dsa² jue¹². Quianh¹³dsa dsa² ŋioh¹² tsen² Judas héi², dsa² quianh¹³ dsa² guia¹tón². Dsa² héi² quin¹² ni³ quiah¹² dsa² jue¹². Jøng² ca¹ŋó¹dsa cøg¹² ja³tsenh¹³ Jesús, hi² mi³chiunh¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Cónh¹jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Judas, ¿lah³dsóh² mi³hnaih¹³hning jní² quianh¹³ hi² chiunh¹³hning ne¹jni? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jøng² mi³ca¹lø¹lih¹³ dsa² quianh³ Jesús ha²lah ma²lǿa¹², ca¹juúh²dsa: ―Juu¹³ jniang³, ¿dsio³¹ quiuh¹³ jniang³ quiah¹²dsa quianh¹³ ŋí³tǿi¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jøng² ca¹quiúgh² jan² dsa² héi² dsa² jmo¹ ta³ quiah¹² ŋi¹jmó². Ca¹quiúh¹dsa lø²guø³dsa, jag¹³ ta¹lah¹guie¹jo¹³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jøng² ca¹juúh² Jesús: ―Tsa¹ma¹jmóh³ hniah¹² lah¹ná¹². Jøng² ca¹quieg² Jesús gug² ni³ ja³uai¹² quiah¹² dsa² héi². Ca¹mi¹hliú²dsa dsa². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa juu¹³ jmi²dsa² quianh¹³ dsa² ta³ quián¹² guøh¹² quianh¹³ dsa² canh¹³, dsa² dsa¹chiánh² Jesús. Ca¹juúh²dsa: ―Ma²ja²nioh¹² hniah¹² ti³chinh¹² hniah¹² ŋí³ quianh¹³ hma², ju³lah cøng² hi² lán¹²jni dsa² høin². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jmai³ ca¹lah¹jǿ¹ ma²ca¹he¹jni jǿg³ guøh¹² jøa³ ja³tiogh³ hniah¹². Jøng² ha¹chi² ca¹chiángh² hniah¹² jní². Na¹ jín³ ma²tǿ² hora quiánh² hniah¹² quianh¹³ dsa² jiag¹² ja³neng² ja³nioh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jøng² ca¹chiánh²dsa Jesús. Ca¹jian¹dsa juu¹² ja³quiah¹³ ŋi¹jmó². Ca¹ŋó¹ Pedro chi³quë́¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jøng² ca²dsiog³dsa ca¹dsii¹ si² ja³dsi¹² quiah¹² ŋi¹jmó². Mi³ca¹túgh²dsa jøng² ca¹gú¹ Pedro jøa³ ja³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jøng² ca¹jǿi² jan² hio¹³, dsa² jmo¹² ta³ dsi²néi². Cøng² hi² uú² ca¹jë́²dsa Pedro ja³taih¹² si² quiah¹²dsa. Jøng² ca¹juúh²dsa: ―Dsa² ná¹² mi³hiúg³ quianh¹³dsa ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jøng² ca¹juúh² Pedro: ―Ha¹chi² cué¹²jni dsa² héi², hio¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma²cu²lǿi² jøng² ca¹jǿi² dsa² siáh². Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Pedro: ―Lanh¹²hning dsa² quianh³ dsa² héi² ―ca¹juúh²dsa. Cónh¹jøng² ca¹juúh² Pedro: ―A¹jáng¹ lah¹jøng², dsa² ŋioh¹². Ha¹chi² lán¹²jni lah¹jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma²ni³ŋó¹³ cónh¹ cøng² hora mi³ca¹juúh² dsa² siáh² calah quianh¹³ hi² tiog¹³: ―Lah¹té¹² jǿg³ mi³hiúg³ dsa² lang¹² quianh¹³ dsa² héi². Di³ lán¹²dsa dsa² chian² ja³tén¹² Galilea ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jøng² ca¹juúh² Pedro: ―Dsa² ŋioh¹², ha¹chi² guiang³jni he² jǿg³ juúh²hning ―ca¹juúh²dsa. Dsø¹juu¹² jøng², ja³ma²chi³hløah¹² Pedro jǿg³ jøng², ca¹ho¹ chiih³. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jøng² ca¹jenh¹ Juu¹³ jniang³. Ca¹jë́²dsa Pedro. Jøng² ca¹dsagh² dsǿa¹² Pedro jǿg³ ma²na²juúh² Juu¹³ jniang³. Di³ ma²na²tsáih¹dsa Pedro: “Na¹ cónh¹ niúh¹ ja³ho¹ chiih³, jmóh³hning hnøa¹² rón² hi² tsa¹cuaih¹²hning jní²,” ma²na²juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jøng² ca¹u¹hái¹ Pedro ja³jøng². Ca¹ho¹dsa, hi² ma²je² hlaih¹³ dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jøng² dsa² mi³jmo¹² hí³ Jesús ca¹cu² ca¹jmóh²dsa. Ca¹bú²dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ca¹hŋiéng²dsa ni³ Jesús quianh¹³ hmøah¹². Jøng² ca¹tsáih¹dsa Jesús, ca¹juúh²dsa: ―Hǿ¹ jǿg³. ¿Hein² dsa² quiuh¹² quiánh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jøng² hliú² jǿg³ hlaih¹³ lah¹jøng² ca¹tsáih¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mi³ma²na²jni¹ ca¹túgh² dsa² canh¹³ quián¹² dsa² judío, cu¹dsie¹² quianh¹³ juu¹³ jmi²dsa² quianh¹³ tøa¹² quiah¹² lei¹³, ca¹jian¹ dsa² héi² Jesús juu¹² ni³ ta³ quiah¹²dsa. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Juaih¹³hning jnieh³ chi²júh² lanh¹²hning Cristo ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Ha¹chi² héh² hniah¹² jǿg³ ju³ jøng² ca¹juúh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jøng² tsa¹ŋaih³ hniah¹² chi²júh² he² jǿg³ ca¹ŋai³jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cónh¹jøng² ni³ na¹ ja³já¹³ ma²guø³jni cøg¹² ja³guǿ¹³ Diú¹³ dsa² chi² bí², gug²dsa dsio¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jøng² ca¹lah¹já¹ dsa² héi² ca¹ŋǿh¹ Jesús, ca¹juúh²dsa: ―Hi² jøng², ¿Lanh¹³hning jong¹² Diú¹³? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Lán¹² báh³ jní² ju³lah lǿa¹² jǿg³ ma²na²juøh³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jøng² ca¹juúh² dsa² héi²: ―Ha¹chi² jǿg³ siíh² ma²hniuh¹². Ma²na²néng³ báh³ jniang³ jǿg³ hlaih¹³ ma²na²juúh²dsa hŋiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jøng² ca¹ŋi¹lé² ca¹lah¹já¹ dsa² tiogh³ ja³jøng². Ca¹jian¹dsa Jesús ja³ta¹ni¹ Pilato, ");
INSERT INTO cpaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ja³ca¹cuúh¹dsa Jesús dsag³. Ca¹juúh²dsa: ―Ma²ca¹dsanh¹² jnieh³ dsa² lang¹², hi² ma²jmo¹²dsa møah¹³ quianh¹³ dsa² go² jnieh³. Tsa¹cuø¹²dsa jǿg³ quíg³ jnieh³ cog³ juøi² hi² cagh¹² rai¹³ dsa² goh²hning. Juúh²dsa lán¹²dsa Cristo, lán¹²dsa rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jøng² ca¹ŋǿh¹ Pilato Jesús, ca¹juúh²dsa: ―¿Lanh¹³hning rai¹³ quián¹² dsa² judío? ―ca¹juúh²dsa. Jøng² ca¹ŋai¹ Jesús, ca¹juúh²dsa: ―Lán¹² báh³ jní² ju³lah ma²na²juøh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jøng² ca¹juúh² Pilato, ca¹tsáih¹dsa juu¹³ jmi²dsa² quianh¹³ dsa² jue¹²: ―Ha¹chi² dsag³ quiah¹² dsa² lang¹² ma²na²dsóh²jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Cónh¹jøng² hiug¹² hi³méh¹ ca¹juúh² dsa² jue¹² quianh¹³ hi² tiog¹³: ―Ma²jmo¹²dsa møah¹³ quianh¹³ dsa² go² jnieh³ ca¹lah¹tan¹³ ja³tén¹² Judea ca¹lah¹ma¹quianh¹³ ja³tén¹² Galilea, ca¹lah¹ja³ma²guønh¹dsa jøa³juøi² la² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mi³ca¹nǿng² Pilato jǿg³ jøng², ca¹ŋai¹dsa chi²júh² lán¹² Jesús dsa² chian² ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jøng² mi³ca¹lø¹ŋi¹²dsa hi² lán¹² Jesús dsa² chian² ja³tén¹² jǿg³ quiah¹² rai¹³ Herodes, ca¹tsei¹dsa juu¹² ja³ta¹ni¹ Herodes héi², dsa² hiúg³ jøa³juøi² Jerusalén jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tøa¹² hlaih¹³ dsǿa¹² Herodes mi³ca¹jë́²dsa Jesús. Di³ ma²ni³ŋó¹³ jmai³ hniu¹dsa jǿi²dsa. Ma²ca¹nǿng²dsa jǿg³ quiah¹² Jesús. Jøng² hniu¹dsa jái¹dsa jmo¹ Jesús cøng² juu¹² juøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hi² jøng² cøng² hi² cug² ca¹ŋǿh¹dsa Jesús jǿg³. Cónh¹jøng² ha¹chi² jǿg³ ca¹ŋai¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Cøg¹² ja³jøng² tiogh³ juu¹³ jmi²dsa² quianh¹³ tøa¹² quiah¹² lei¹³. Ca¹hnë¹ hlaih¹³dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jøng² Herodes quianh¹³ hlég² quián¹²dsa, ca¹cu² ca¹jmóh²dsa Jesús. Ca¹jmo¹dsa tsa¹quien¹²dsa. Jøng² mi³ca¹quieh¹dsa Jesús hmøah¹² jláh³, ca¹tsei¹dsa calah juu¹² ja³ta¹ni¹ Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jmai³ jøng² ca¹lán¹ Herodes ha²mei¹³ quián¹² Pilato. Di³ mi³ti³hiag¹³dsa cónh¹ jmai³ ja³ma²ca¹já¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jøng² mi³ca¹tǿh¹ Pilato juu¹³ jmi²dsa² quianh¹³ dsa² ta³ quián¹² guøh¹² quianh¹³ dsa² juøi², ");
INSERT INTO cpaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Ma²ca¹jianh¹² hniah¹² dsa² lang¹² ja³ta¹ne¹ jní². Juúh² hniah¹² jmo¹²dsa møah¹³. Jøng² ma²ca¹can¹jni jǿg³ dsøg¹² quiah¹²dsa ja³ta¹neih¹ hniah¹². Jai³lah ha¹chi² lë́²jni hi² re² dsa² lang¹² jin³ cøng² dsag³ ma²na²cuøh³ hniah¹² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jø¹² bíh³ lah¹jøng² lë́² Herodes calah. Di³ ma²na²tsei¹dsa calah ja³la². Jai³lah, ha¹chi² ma²ca¹jmo¹ dsa² lang¹² hi² mi³ta¹dsa jón²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hi² jøng² log³jni dsa² na³ma²ca¹cuǿ¹jni dsa² ju²lih¹³ dsøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Di³ tiog¹³ báh³ hniuh¹² liúg² Pilato jan² dsa² judío hiúg³ hni¹ŋí³ jmai³ tøa¹² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jøng² tí² ca¹hløah¹ dsa² jue¹² tiogh³, ca¹juúh²dsa: ―¡Tø¹guiég¹ dsianh¹³hning dsa² ná¹²! Logh³hning Barrabás ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ma²ca¹tangh²dsa Barrabás hni¹ŋí³. Di³ ma²ca¹jmo¹dsa møah¹³ jøa³juøi². Ca¹mi¹dsian¹²dsa dsa² calah. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jøng² hniu¹ Pilato liúg² Jesús. Hi² jøng² ca¹tsáih¹dsa calah jín³ cu²rón² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cónh¹jøng² tí² ca¹hløah¹ dsa² tiogh³: ―¡Crǿg¹³ báh³ ta¹ton¹³dsa! ¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ca¹tǿ² hnaih² rón² ca¹juúh² Pilato, ca¹tsáih¹dsa dsa² tiogh³, ca¹juúh²dsa: ―¿He² hi² hlaih¹³ ma²ca¹jmo¹dsa jøng²? Ha¹chi² lë́²jni hi² re²dsa dsag³ jón²dsa. Hi² jøng² log³jni dsa² na³ma²ca¹cuǿ¹jni dsa² ju²lih¹³ dsøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Cónh¹jøng² quianh¹³ hi² tiog¹³ ca¹hløah¹ dsa² tiogh³. Tí² ca¹juúh²dsa hi² ta¹ton¹³ Jesús crǿg¹³. Jøng² ca¹løa¹ báh³ héh¹ quiah¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ca¹jmo¹ Pilato jǿg³ jón² Jesús ju³lah lǿa¹² jǿg³ quiah¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ca¹liúg²dsa dsa² ca¹jmo¹ møah¹³ héi², dsa² ca¹mi¹dsian¹² dsa². Di³ dsa² héi² ca¹hia¹ dsa² jue¹². Jøng² ca¹jmo¹ Pilato héh¹ hi² jmo¹dsa quiah¹² Jesús ca¹lah¹cónh¹ lǿa¹² jǿg³ quiah¹² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma²jian¹²dsa Jesús mi³ca¹chiánh²dsa Simón, jan² dsa² ŋioh¹² chian² Cirene, dsa² ma²jogh¹² jøa³nung². Ca¹jmo¹dsa hi² ca¹cán¹ dsa² héi² crǿg¹³ dsi³cah³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jøng² jue¹² hlaih¹³ dsa² ca¹ŋi¹lé² quianh¹³dsa, ca¹lah¹ma¹quianh¹³ jue¹² hio¹³, dsa² ma²tø²ho¹² hi² hlaih¹³ jenh¹²dsa, chian²dsa ju²cǿh¹ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jøng² ca¹jenh¹ Jesús, ca¹tsáih¹dsa hio¹³ héi², ca¹juúh²dsa: ―Hio¹³, hniah¹² dsa² chianh² jøa³juøi² Jerusalén, tsa¹høg² ni³ huu¹³ quieg¹ jní². Dsio¹ hǿgh³ hniah¹² ja³cog² guiogh¹³ hniah¹² quianh¹³ tsih² guing². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Di³ jai³lah, jií¹ jmai³ ja³li¹juúh²dsa: “Dsio¹ quiah¹² dsa² juu³, dsa² tsa¹ma²ca¹can¹ guing², dsa² tsa¹ma²ca¹cuúh¹ guing² dsiúh³,” li¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jmai³ jøng² li¹chian² dsa² juúh², tsaih¹²dsa máh²: “Siog² ni³ quián² jnieh³.” Tsaih¹²dsa cónh¹²: “Jlai³ jnieh³.” ");
INSERT INTO cpaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Di³ hiug¹² jín³ hi² ué² jmo¹dsa ja³cogh² hniah¹² dsa² ti³reh² dsag³, chi²júh² ma²jmo¹²dsa hi² la² quieg¹ jní², dsa² lán¹² dsa² dsiog¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jø¹² bíh³ ca¹jian¹dsa og¹ dsa² siáh² calah, dsa² ca¹jmo¹ hi² hlaih¹³. Ca¹jiag¹dsa juu¹² ja³dsiág¹dsa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jøng² mi³ca¹dsi¹lé²dsa cøng² ja³tsen² Máh² Mu² Dsi³ Dsa², ca¹tióg²dsa dsa² crǿg¹³ quianh¹³ dsa² re² dsag³ héi², jan² dsa² ta¹lah¹guia¹jo¹³, jan² dsa² ta¹lah¹guia¹jón¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jøng² ca¹juúh² Jesús ja³ma²chi³tiang¹²dsa crǿg³: ―Jmi² jniang³, hén¹ dsag³ quiah¹²dsa. A¹jáng¹ hi² ŋi¹²dsa hi² jmo¹²dsa ―ca¹juúh²dsa. Jøng² ca¹jmo¹ hlég² ma²cǿng¹ tsǿnh³ Jesús. Ca¹co¹dsa. Ca¹jái¹dsa he² hmøah¹² ta¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jue¹² dsa² tiogh³ ti³jái¹². Ca¹lah¹ca¹tǿ² guiog¹³ dsa² ta³ ca¹cu² ca¹jmágh², ca¹juúh²dsa: ―Ca¹liúg²dsa dsa² siáh². Ju³liúg³dsa hŋiah¹²dsa chi²júh² lán¹²dsa Cristo, dsa² ca¹hia¹ Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jø¹² bíh³ ca¹cuø¹ hlég² ju²hiíh¹. Ca¹ŋi¹lé²dsa cøg¹². Mi³henh¹dsa Jesús jmøi² jinh². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jøng² ca¹juúh²dsa: ―Liog³ hŋiah¹hning chi²júh² lanh¹²hning rai¹³ quián¹² dsa² judío ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma²rø²ton¹² si² guiuh¹³ quiah¹² Jesús. Lah¹la² rø²juúh² si²: “Lán¹² dsa² lang¹² rai¹³ quián¹² dsa² judío,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jøng² ca¹jí² jan² dsa² re² dsag³ héi², dsa² rø²ton¹² crǿg¹³. Ca¹juúh²dsa: “Cristo lanh¹²hning, liáh³. Jøng² liogh³hning hŋiah¹ quianh¹³ jnieh³,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jøng² ca¹jí² dsa² jan², ca¹jé²dsa roh¹³dsa: ―¿Tsa³ganh¹hning Diú¹³? Di³ cøng² ni³ quinh³hning jmø³uai¹² quianh¹³ dsa² lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jøng² cu²rø² ca¹tǿi² jniang³ ma³rø²canh¹² jniang³ dsag³ quián² jniang³. Cónh¹jøng² ha¹chi² hi² hlaih¹³ ma²ca¹jmo¹ dsa² lang¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jøng² ca¹juúh²dsa: ―Jesús, ju³dsiagh² hoh¹²hning jní² na³ma²guønh¹hning hi² ma²chi² bí² quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―Lah¹dsóh² juǿi²jni hning²: Na¹ li¹quianh¹³hning² jní² ja³dsio¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jøng² mi³ma²tǿ² cónh¹ dsi¹hiég¹, ca¹neng² ta³cøng² ja³jøng² ca¹lah¹ja³ca¹tǿ² hein¹³ hnøa¹² ta¹ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tsa¹ma¹jní² si² quiah¹² hieg². Jøng² ca¹gøi² hmøah¹² hei¹² dsi²jo² dsi²néi² guøh¹². Ca¹løa¹ ton¹ jag¹³ hmøah¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jøng² ca¹hløah¹ Jesús tí², ca¹juúh²dsa: ―Jmi² jniang³, dsii¹²jni jmi²dsí² quieg¹jni ju²gugh²hning. Mi³ca¹juúh²dsa lah¹jøng² ta³lah¹ca¹hná² dsí² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jøng² ca¹mi¹juanh¹² juu¹³ hlég² Diú¹³, mi³ca¹jái¹dsa ha²lah ma²na²løa¹. Ca¹juúh²dsa: ―Lah¹dsóh² ha¹chi² dsag³ mi³re² dsa² ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jøng² ca¹ŋi¹lia¹ ca¹lah¹já¹ dsa² mi³tiogh³, hi² ma²chian²dsa ju²cǿh¹ dsøa¹² mi³ma²na²jái¹dsa ha²lah ma²na²løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jøng² ca¹lah¹já¹ dsa² cue¹² Jesús quianh¹³ hio¹³ ca¹ja¹lé² dsi³cah³dsa juu¹² ja³tén¹² Galilea, ma²tiogh³ dsa² héi² tø¹guiég¹. Ca¹jái¹dsa hi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ja³jøng² mi³hiúg³ jan² dsa² dsiog¹ tsen² José, dsa² té¹² jǿg³. Chian²dsa Arimatea, juøi² tén¹² Judea. Hiúg³ dsa² héi² quianh¹³ dsa² ta³ quián¹² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Cónh¹jøng² ha¹chi² ca¹lø¹hiúg¹ dsǿa¹²dsa ha²lah ma²ca¹jmo¹ dsa² ta³ jian¹²dsa. Lán¹²dsa dsa² hniu¹ jií¹ ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ca¹ŋó¹ dsa² héi² ja³ta¹ni¹ Pilato. Ca¹ŋi³mëh¹³dsa hlai³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jøng² mi³ma²na²siúg²dsa hlai³, ca¹dsǿgh²dsa hmøah¹² tuh¹². Jøng² ca¹ŋi¹jǿg²dsa niúh¹ cøng² tøg²hløg² hi² ca¹guiég¹ dsa², ja³ha¹chian² hlai³ ma²ca¹hóg¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ca¹hlég² jmai³ viernes jøng². Ma²ja¹quien¹³ ja³li¹liág¹ jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jøng² hio¹³, dsa² ca¹ja¹lé² juu¹² Galilea, ca¹ŋi¹lé²dsa. Ca¹ŋi³jái³dsa tøg²hløg² ja³rø²quia¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jøng² ca¹ŋi¹lia¹ hio¹³. Ca¹jmo¹dsa ju²jŋia¹³ hi² ma²ro² quianh¹³ nang³. Jøng² ca¹jŋi¹dsa jmai³ sa³¹, ju³lah lǿa¹² lei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jøng² cónh¹ nioh¹² hi³méh¹, jmai³ du²mei³¹, ca¹ŋi¹lé² calah hio¹³ juu¹² tøg²hløg². Quin¹²dsa hi² ma²ro² jøng², hi² ma²lǿa¹² ju²jŋia¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jøng² ca¹jái¹dsa ma²rø²jŋih¹² cang³ hag³ tøg². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mi³ca¹túgh²dsa niúh¹ tøg² jøng², tsa¹ma¹ca¹dsanh¹²dsa hlai³ Jesús, Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jøng² ma²chian²dsa ju²hí³ dsøa¹² mi³ca¹jnia¹ og¹ dsa² ŋioh¹² cøg¹² ja³tiogh³dsa. Tsih¹² hlaih¹³ cu¹té¹² hmøah¹² quieih¹² dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ca¹can¹ hlaih¹³ hio¹³ gøg². Hi² jøng² ca¹chi¹jné¹dsa, chi³ŋiu¹³ ni³dsa huø¹. Jøng² ca¹juúh² dsa² ŋioh¹²: ―¿He² løa¹ hnah¹² hniah¹² dsa² jinh³ ja³tiogh³ dsa² ma²ca¹dsan¹? ");
INSERT INTO cpaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ju³dsiagh² hoh¹² hniah¹² ha²lah lǿa¹² jǿg³ ca¹tsáih¹ Jesús hniah¹² jmai³ mi³hiúg³dsa quianh¹³ hniah¹² ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Di³ ca¹juúh²dsa hi² chiángh² dsa² lø³hiug¹². Hi² jón²dsa. Jøng² hiog¹dsa jmai³ hnøa¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jøng² ca¹dságh¹ dsǿa¹² hio¹³ jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jøng² ca¹ŋi¹lia¹ hio¹³ tøg²hløg². Ca¹ŋi¹tseih¹²dsa dsa² guia¹ján¹ quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jøng², María Magdalena báh³ héi², quianh¹³ Juana, quianh¹³ María, mi³chiég³ Jacobo, quianh¹³ hio¹³ jian¹²dsa, hio¹³ ca¹jmo¹ jǿg³ jøng² ja³ta¹ni¹ tsih² høh³ quián¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cónh¹jøng² lë́² tsih² høh³ hi² dsii¹² hio¹³ jǿg³ la³ju² la³løa¹. Tsa¹ca¹hé¹dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Cónh¹jøng² ca¹ŋó¹ Pedro gu¹hei¹² juu¹² ja³ho¹² tøg². Jøng² ca¹jái¹dsa niúh¹. Rø²quie¹² hmøah¹² tuh¹² ja³cu²hŋiah¹². Jøng² ca¹ŋáh¹dsa, hnangh¹²dsa dsǿa¹² ha²lah ma²ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jøng² jmai³ jøng² ma²dsø²lé² og¹ dsa² mi³quianh³ Jesús juu¹² Emaús, juøi² neng¹² cónh¹ guie¹cáng¹ kilometros ca¹lah¹cónh¹ ja³neng¹² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dsii¹²dsa jǿg³ ca¹lah¹jǿ¹ hi² ma³ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma²dsii¹²dsa jǿg³ jøng² mi³ca¹ŋó¹ Jesús cøg¹², ca¹ŋøa¹dsa quianh¹³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jøng² ca¹jmo¹ Diú¹³ tsa¹ca¹lø¹cuai¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² jǿg³ dsiih² hniah¹² ŋi²nioh³ hniah¹²? ―ca¹juúh²dsa. Jøng² ca¹jŋi¹ dsa² héi². Léi¹³ ni³dsa hi² hlaih¹³ jenh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jøng² ca¹juúh² jan² dsa² héi², dsa² tsen² Cleofas: ―Ha²lah dsio¹ jan² hning² tsa¹ca¹lø¹ŋih³ he² ca¹løa¹ jøa²juøi² Jerusalén sø²ma³¹ ca¹dság¹ cónh¹ jín³ ca¹lah¹já¹ dsa² ma²ŋi²nio³ jøa³juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jøng² ca¹juúh² Jesús: ―¿He² jǿg³ jøng²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi² calah: ―Jǿg³ quiah¹² Jesús, dsa² chian² Nazaret, dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³. Mi³chi² bí² quiah¹²dsa ja³cog² Diú¹³ ca¹lah¹ma¹quianh¹³ dsa² jmøi¹guǿi¹. Tí² ca¹hǿi² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jøng² juu¹³ jmi²dsa² quián² jniang³, quianh¹³ dsa² ta³ quián¹² guøh¹², ca¹cuø¹ dsag³ hi² jón²dsa. Jøng² ca¹tiáng¹dsa crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Cónh¹jøng² mi³lë́² jnieh³ hi² lán¹²dsa dsa² tiúh¹ lég² jniang³, dsa² israel. Lah¹jøng² ca¹løa¹. Jøng² ma²hnøa¹² jmai³ na¹ ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ni³ jøng² ca²dsiog³ hio¹³, dsa² dsa²lé² quianh¹³ jnieh³, ma²na²juǿih²dsa jnieh³. Di³ ta¹ŋih¹³ na²u³ŋie¹²dsa ja³ca¹húg²dsa hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jøng² ha¹chian² hlai³ ma²na²dsanh¹²dsa. Mi³na²jogh¹²dsa jøng² ma²juúh²dsa hi² ca¹jë́²dsa ángeles, dsa² juúh² hi² jinh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ni³ jøng² ca²dsiog³ dsa² quianh¹³ jnieh³ ca¹ŋie² ja³ho¹² tøg². Ca¹ŋi³jái³dsa hi² lah¹dsóh² lǿa¹² ju³lah ma²na²juúh² hio¹³. Cónh¹jøng² ha¹chi³ ca¹jë́²dsa Jesús ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ gøg² tsa²chian² hoh¹² hniah¹² dsa² ŋioh¹²? ¿He² løa¹ tiog¹³ tsa¹héh² hniah¹² ca¹lah¹jǿ¹ jǿg³ ma³ca¹he¹ dsa² hǿ² jǿg³ quiah¹² Diú¹³? ");
INSERT INTO cpaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hniuh¹² báh³ jøng², hi² ca¹can¹ Cristo jmø³uai¹² jøng². Mi³jøng² lén²dsa dsa² juanh¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jøng² ca¹he¹ Jesús jǿg³, cónh¹ jǿg³ lah¹ni³ quiah¹² hlai³ Moisés ca¹lah¹ma¹quianh¹³ jǿg³ quiah¹² ca¹lah¹já¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³. Ca¹he¹dsa ha²lah lø²ti¹ ca¹lah¹jǿ¹ jǿg³ lǿa¹² ni³ si² ja³cog²dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jøng² ja¹quien¹³ dsiég¹³ dsa² héi² juøi² ja³dsø²lé²dsa. Jøng² lë́² dsa² og¹ héi² hi² mi³dság¹ Jesús ja³uǿin³ hi³méh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Cónh¹jøng² ca¹juúh² dsa² héi², ca¹tsáih¹dsa Jesús quianh¹³ hi² tiog¹³: ―Jŋi³ ja³la² quianh¹³ jnieh³. Ca¹neng² báh³ la² ―ca¹juúh²dsa. Hi² jøng² ca¹hí¹ Jesús dsi²néi² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jøng² mi³ma²túgh²dsa mesa, ca¹can¹ Jesús hi³ŋíh¹. Ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹jmo¹dsa ma¹méh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jøng² cu¹ŋieih¹³ ca¹lø¹ŋi¹² dsa² héi². Ca¹lø¹cue¹²dsa Jesús. Jøng² tsa¹ma¹chian² Jesús. Ha¹chi² ma¹ca¹jǿi² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa guiog¹³dsa: ―Lah¹dsóh² lø²lih¹³ dsǿa¹² jniang³ dsi²juu¹², ja³mi³dsii¹² Jesús jǿg³, ja³mi³heh¹²dsa jniang³ jǿg³ quiah¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jøng² ca¹ŋi¹lia¹dsa calah dsø¹juu¹² jøa³juøi² Jerusalén. Ca¹dsanh¹²dsa dsa² guia¹ján¹, hi² ma²tiogh³dsa cu¹dsie¹² quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jøng² ca¹juúh² dsa² tiogh³: ―Lah¹dsóh² ma²na²hiog² Juu¹³ jniang³. Ma²na²jǿi² Simón ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jøng² ca¹dsii¹ dsa² og¹ héi² jǿg³, ha²lah na²ŋë²dsa dsi²juu¹². Ca¹juúh²dsa ha²lah na²lø²cuai¹²dsa mi³ma²na²dsiúh¹ Jesús hi³ŋíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ma²dsii¹²dsa jǿg³ jøng² mi³ca¹jnia¹ Jesús hŋiah¹² jøa³ ja³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cónh¹jøng² ca¹ja³han³ dsa² tiogh³. Ca¹can¹dsa gøg². Lë́²dsa hi² jë́²dsa jmi²dsí². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¿He² løa¹ ganh¹ hniah¹²? ¿He² løa¹ quinh³ hniah¹² ju²hí³ dsøa¹²? ");
INSERT INTO cpaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Jai³ gug¹jni quianh¹³ tai¹jni! Jní² báh³ lang¹². Quieg² gugh² ni³ quieg¹jni, mi³jøng² jáih³ hniah¹². Di³ tsa¹lǿa¹² jmø²ŋǿ¹² jmi²dsi² ju³lah lǿa¹² quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jøng² mi³ma²na²juúh²dsa lah¹jøng², ca¹heh¹dsa dsa² gug² tai³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cónh¹jøng² ha¹chi² hé²dsa jǿg³, di³ hiug¹² dsogh¹² dsǿa¹²dsa, hiug¹² hioh¹² jenh¹²dsa. Hi² jøng² ca¹juúh² Jesús: ―¿Tsa³quinh³ hniah¹² hi² li¹gøah¹³jni? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jøng² ca¹cuan¹dsa jáh² tiogh³ jmøi² ma²cág¹. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ca¹hiei¹ Jesús. Ca¹gǿh¹dsa ja³ta¹ni¹ ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jøng² ca¹juúh² Jesús: ―Lah¹jøng² ca¹juǿi²jni hniah¹² jmai³ mi³hiúg³jni quianh¹³ hniah¹²: Hi² hniuh¹² li¹ti¹ ca¹lah¹jǿ¹ jǿg³ rø²juúh² si² ja³cog²jni, ju³lah si² quiah¹² hlai³ Moisés, quianh¹³ si² quiah¹² dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³, quianh¹³ si² Salmos ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jøng² ca¹jmo¹dsa ca¹lø¹ŋë́h² dsǿa¹² dsa² quianh³dsa jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jøng² ca¹juúh²dsa calah: ―Rø²juúh² báh³ si² hi² hniuh¹² jón² Cristo. Jøng² hiog¹dsa jmai³ hnøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jø¹² bíh³ rø²juúh² si² hi² hniuh¹² tsø¹jan¹² jǿg³ jéinh¹ dsǿa¹² dsa² jmøi¹guǿi¹, mi³jøng² dsa¹hén² dsǿg³dsa. Mi¹liág¹² jǿg³ jøa³juøi² Jerusalén la², ca¹lah¹ja³ca¹lø¹chí¹ jǿg³ ja³tioh¹³ ca¹lah¹jǿ¹ juøi². ");
INSERT INTO cpaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hniah¹² báh³ dsa² tsih¹ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jai³lah tsë́³jni hi² li¹chi² quiánh² hniah¹² ju³lah ca¹juúh² ti³ŋiéh¹jni. Jøng² janh³ hniah¹² jøa³juøi² la² ca¹lah¹ca¹tǿ² ja³ma²ca¹quinh² hniah¹² bí² quiah¹² Diú¹³ dsa² juanh¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jøng² ca¹jiag¹ Jesús ca¹tǿ² jøa³juøi² Betania. Jøng² ca¹chio¹dsa gug²dsa. Ca¹hlanh¹dsa Diú¹³ ni³ huu¹³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mi³ma²hlanh¹²dsa Diú¹³ jøng², ca¹u¹hái¹dsa ja³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jøng² ca¹ŋi¹lia¹ dsa² héi² juu¹² jøa³juøi² Jerusalén, hiug¹² hioh¹² jenh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cøng² hi² ca¹túgh²dsa guøh¹². Ca¹mi¹juanh¹²dsa Diú¹³.");
INSERT INTO cpaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jmai³ lah¹ni³ ma²chian² dsa² jmo¹² jǿg³ quiah¹² Diú¹³. Ma²guǿ¹² dsa² héi² quianh¹³ Diú¹³ dsa² juanh¹². Lán¹² báh³ dsa² Diú¹³ hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jmai³ lah¹ni³ ma²guǿ¹² dsa² héi² quianh¹³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dsa² héi² báh³ ca¹jmo¹ ca¹lah¹jǿ¹ hi² ca¹lø¹chí¹. Ha¹chi² ca¹lø¹chí¹ jin³ he² ju³ hi² tsa¹ca¹jmo¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dsa² héi² cuø¹² bí² hi² li¹chian² dsa² jmøi¹guǿi¹ ja³cog² Diú¹³. Di³ hi² lah¹jøng² báh³ jmo¹² hi² taih¹² juu¹² ja³ŋi¹nio¹ dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Taih¹² juu¹² ja³ŋi²nio³dsa ju³lah lǿa¹² cøng² si² taih¹² ja³neng². Jøng² tsa¹tiúh¹ dsa² jmo¹² hi² hlaih¹³ jmo¹ hi² néng¹ juu¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jøng² ca¹lø¹chián¹ jan² dsa² tsen² Juan, dsa² ca¹hia¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ca¹lø¹chián¹ Juan mi³jøng² tsih¹dsa jǿg³ dsøg¹² quiah¹² dsa² héi², dsa² jmo¹² taih¹² juu¹² quiah¹² dsa² jmøi¹guǿi¹. Mi³jøng² hé² dsa² jmøi¹guǿi¹ jǿg³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ha¹chi² lán¹² Juan hŋiah¹² dsa² jmo¹² taih¹² juu¹². Cónh¹ jín³ hi² lán¹²dsa dsa² tsih¹ jǿg³ dsøg¹² quiah¹² dsa² héi², ");
INSERT INTO cpaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","dsa² na¹ bíh³ li¹chian² jmøi¹guǿi¹, dsa² jmo¹² hi² lah¹dsóh² taih¹² dsio¹ juu¹² quiah¹² ca¹lah¹já¹ dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma²chian² báh³ dsa² héi² jmøi¹guǿi¹, dsa² ca¹jmo¹ ca¹lø¹chí¹ jmøi¹guǿi¹. Cónh¹jøng² tsa¹ca¹lø¹cuai¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ca¹lø¹chián¹dsa jøa³ ja³tiogh³ dsa² quián¹²dsa. Cónh¹jøng² tsa¹ca¹hiei¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jøng² ju³ná³ hein² dsa² jmøi¹guǿi¹ ca¹hie¹dsa dsa² héi², hi² ca¹hé¹dsa jǿg³ quiah¹² dsa² héi², jøng² ca¹cuúh¹ dsa² héi² bí² hi² lén²dsa jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Di³ a¹jáng¹ ju³ hi² lén²dsa jong¹² Diú¹³ ju³lah lǿa¹² jǿg³ quiah¹² dsa² jmøi¹guǿi¹ hi² li¹chian² jong¹²dsa. Diú¹³ báh³ jmo¹ hi² lén² jong¹²dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jøng² dsa² jmo¹² jǿg³ quiah¹² Diú¹³ héi² ca¹lán¹ dsa² jmøi¹guǿi¹. Ca¹u¹guu¹dsa jøa³ ja³tiagh³ jniang³. Lán¹²dsa dsa² dsio¹ dsǿa¹², dsa² té¹² jag³. Ca¹ne¹³ jnieh³ hi² hiug¹² juanh¹²dsa, hi² lán¹²dsa hŋiah¹² ca²mǿi² ja³ŋiúh³ Jmi² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ca¹he¹ Juan jǿg³ quiah¹² dsa² héi². Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―Dsa² héi² báh³ hia¹²jni mi³ca¹juúh¹jni: “Hi² jií¹ jan² dsa² tø¹chi³quë́¹, dsa² lán¹² dsa² juanh¹² cónh¹ jín³ jní². Di³ hi² ma²chian²dsa niúh¹ jín³ hi² ca¹lø¹chián¹ jní²,” ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hiug¹² jín³ hi² dsio¹ dsǿa¹² ja³ŋiúh³ Diú¹³ héi². Tsug¹² ca¹jmo¹dsa hi² dsio¹ ja³cog² ca¹lah¹jái¹ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ca¹jmo¹ hlai³ Moisés hi² ca¹lø¹ne³ jniang³ lei¹³ quiah¹² Diú¹³. Jøng² ca¹jmo¹ Jesucristo hi² ca¹lø¹ne³ jniang³ hi² dsio¹ dsǿa¹² Diú¹³, hi² lah¹dsóh² té¹² jag³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ha¹chian² dsa² jmøi¹guǿi¹ ma²ca¹jë́² Diú¹³. Jan² ja³ŋiúh³dsa héi², dsa² guǿ¹² cog² Diú¹³, ma²ca¹mi³léi¹³ ha²lah lán¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lah¹la² lǿa¹² jǿg³ ca¹juúh² Juan mi³ca¹dsi¹lé² jmi²dsa² quianh¹³ dsa² levita, dsa² mi²hog¹³ jmi²dsa². Di³ ca¹dsi¹lé²dsa ja³tsenh¹³dsa, hi² ca¹tsei¹ dsa² judío tiogh³ jøa³juøi² Jerusalén. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa Juan: ―¿Hein² dsa² lanh¹²hning? ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jøng² ca¹lah¹hiu³ dsǿa¹² Juan, ca¹juúh²dsa: ―Héi¹ jní², dsa² lán¹² Cristo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jøng² ca¹juúh² jmi²dsa² quianh¹³ dsa² levita: ―¿Hein² dsa² lanh¹²hning jøng²? ¿Lanh¹³hning hlai³ Elías, dsa² ma²lǿa¹² jǿg³ hi² jiúgh²dsa? ―ca¹juúh²dsa. Jøng² ca¹juúh² Juan: ―Ha¹chi² lán¹²jni dsa² héi², mi³né³ ―ca¹juúh²dsa. Jøng² ca¹juúh² jmi²dsa² calah: ―¿Lanh¹³hning dsa² hǿ² jǿg³ quiah¹² Diú¹³, dsa² ma²lǿa¹² jǿg³ jií¹? ―ca¹juúh²dsa. Jøng² ca¹juúh² Juan: ―Ha¹chi² lán¹²jni dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jøng² ca¹ŋai¹ jmi²dsa² jin³ cøng² jǿg³. Ca¹juúh²dsa. ―¿Hein² dsa² lanh¹²hning lah¹dsóh²? Hniuh¹² quín³ jnieh³ jǿg³ dsøg¹² juu¹² ja³quiah¹³ dsa² ca¹tsei¹ jnieh³. ¿Hein² dsa² lanh¹²hning, juúh³hning hŋiah¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jøng² ca¹juúh² Juan: ―Lán¹²jni jan² dsa² hløah¹² tí² juu¹² ja³ha¹chian² dsa² tiogh³, dsa² juúh²: “¡Jmo³ cu¹dsøg¹² juu¹² ja³ŋøa¹ Juu¹³ jniang³!” ju³lah rø²juúh² si² ca¹jmo¹ hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih² ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dsa² fariseo báh³ dsa² ca¹tse¹ dsa² héi², dsa² dsii¹² jǿg³ quianh¹³ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jøng² ca¹juúh² dsa² héi²: ―¿He² løa¹ chiogh¹²hning dsa² jmøi² chi²júh² tsa¹lanh¹²hning Cristo ho¹ ju³ hlai³ Elías, ho¹ ju³ dsa² hǿ² jǿg³ quiah¹² Diú¹³, dsa² ma²lǿa¹² jǿg³ hi² jií¹ héi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jøng² ca¹juúh² Juan: ―Jmáh¹lah jmøi² báh³ chiog¹²jni hniah¹². Cónh¹jøng² hiúg³ jan² dsa² jøa³ ja³tiogh³ hniah¹², dsa² tsa¹cueh¹² hniah¹², ");
INSERT INTO cpaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","dsa² jií¹ tø¹chi³quë́¹ cónh¹ jín³ jní². Tsa¹lë́²jni ta³tén¹³jni tsøh³jni løg² dsǿ² tai³ dsa² héi² ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jøa³ juøi² Betania ca¹løa¹ lah¹jøng², juøi² neng¹² tø¹hŋoh¹³ chi³jmøi² Jordán, ja³mi³chiog¹² Juan dsa² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mi³ca¹jni¹ jmai³ siíh³, ca¹ŋó¹ Jesús juu¹² ja³tsenh¹³ Juan. Jøng² ca¹juúh² Juan mi³ca¹jë́²dsa Jesús: ―Jai³lah, dsa² ná¹² báh³ lán¹² ju³lah lán¹² jan² jah¹chih² cuan¹² Diú¹³, jáh² jŋëh¹dsa. Mi³jøng² hen¹ dsǿg³ dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dsa² ná¹² báh³ dsa² ca¹hia¹jni mi³ca¹juúh¹jni jǿg³ la²: “Jií¹ jan² dsa² tø¹chi³quë́¹, dsa² hiug¹² jín³ juanh¹² cónh¹ jín³ jní². Di³ ma²chian² dsa² héi² cónh¹ niúh¹ jín³ hi² ca¹lø¹chián¹ jní².” ");
INSERT INTO cpaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ha¹chi² guiang³jni lah¹jiá¹² hein² dsa² lán¹² dsa² héi². Cónh¹jøng² huu¹³ jøng² ma²ca¹guio¹jni hi² ca¹chiog¹jni hniah¹² jmøi². Mi³jøng² li¹ŋih³ hniah¹², dsa² israel, hein² dsa² hi² lán¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jøng² ca¹juúh² Juan calah: ―Ca¹jái¹jni. Ca¹siog² jmi²dsí² han¹³ juu¹² guiuh¹³ ŋi¹juǿi¹. Jní² jmi²dsí² ju³lah jniá² jan² jug². Jøng² ca¹jŋi¹ jmi²dsí² ni³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ha¹chi² guiang³jni hŋiéng¹jni lah¹jiá¹² hein² dsa² lán¹² dsa² héi². Jøng² ca¹tsáih¹ Diú¹³ jní², dsa² ca¹tsei¹ jní², hi² chiog¹²jni hniah¹² jmøi², ca¹juúh²dsa: “Dsa² héi² báh³ dsa² tí² jmi²dsí² han¹³ quiánh² hniah¹², dsa² janh³hning hi² siog¹ jmi²dsí², hi² jŋi¹ jmi²dsí² ni³ quiah¹²,” ca¹juúh² Diú¹³, ca¹tsáih¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jøng² ma¹ca¹jái¹jni lah¹jøng². Hi² jøng² cuø¹²jni jǿg³ dsøg¹² quiah¹² dsa² ná¹² hi² lah¹dsóh² lán¹²dsa jong¹² Diú¹³ ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mi³ca¹jni¹ jmai³ siíh³, ma²tsenh¹² Juan calah, quianh¹³ og¹ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jøng² mi³ca¹jë́² Juan Jesús, hi² ŋøa¹²dsa cøg¹² ja³jøng², ca¹juúh²dsa, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Jai³lah, dsa² ná¹² báh³ lán¹² ju³lah lán¹² jan² jah¹chih² cuan¹² Diú¹³, jáh² jŋëh¹dsa ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mi³ca¹nǿng² dsa² quianh¹³ Juan jǿg³ jøng², ca¹ŋi¹lé²dsa dsen¹³ cah³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jøng² mi³ca¹jénh¹ Jesús, ca¹jë́²dsa dsa² mi³quianh¹³ Juan héi². Jøng² ca¹juúh²dsa: ―¿He² hnøngh² hniah¹²? ―ca¹juúh² Jesús. Jøng² ca¹juúh² dsa² héi²: ―Rabí (hi² hniu¹dsa juúh²dsa: Tøa¹²), ¿ha² tøah¹ ŋíh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jøng² ca¹juúh² Jesús: ―Ma¹dsǿg³ quianh¹³ jní². Ma¹ne¹³ cøng² ja³quieg¹ ―ca¹juúh²dsa. Ca¹ŋi¹lé² dsa² quianh¹³ Jesús juu¹² ja³quiah¹³dsa. Ca¹jái¹dsa ja³jøng². Jøng² ca¹túgh²dsa ja³jøng² cøng² huu². Di³ ma²tǿ² cónh¹ hein¹³ quiún² ta¹ca¹hlég². ");
INSERT INTO cpaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés báh³ tsen² jan² dsa² mi³quianh¹³ Juan héi², dsa² ca¹ŋi¹lé² quianh¹³ Jesús jmai³ jøng². Lán¹² Andrés roh¹³ Simón Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dsø¹juu¹² jøng² ca¹ŋi¹hniah¹² Andrés roh¹³dsa, dsa² tsen² Simón héi². Jøng² mi³ca¹dsanh¹²dsa roh¹³dsa, ca¹juúh²dsa: ―Ma²na²ne¹³ jnieh³ dsa² lán¹² Mesías dsa² ma²lǿa¹² jǿg³ tse¹ Diú¹³ ―ca¹juúh²dsa. (Mesías hniu¹dsa juúh²dsa: Cristo.) ");
INSERT INTO cpaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jøng² ca¹jiag¹dsa Simón juu¹² ja³ta¹ni¹ Jesús. Jøng² mi³ca¹jë́² Jesús Simón, ca¹juúh²dsa: ―Simón báh³ tsenh²hning, ja³ŋiúh³ Jonás. Jøng² li¹tsenh²hning calah Cefas ―ca¹juúh²dsa, hi² hniu¹dsa juúh²dsa Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mi³ca¹jni¹ jmai³ siíh³ ca¹ŋó¹ Jesús juu¹² ja³tén¹² Galilea. Mi³ca¹dsiég¹dsa, ja³jøng² ca¹jë́²dsa Felipe. Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² héi²: ―¡Ma¹dsǿg³ quianh¹³ jní²! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida báh³ tsen² juøi² ja³chian² Felipe. Jø¹² bíh³ ja³jøng² chian² Andrés quianh¹³ Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jøng² ca¹ŋi³hniah¹² Felipe Natanael. Jøng² ca¹juúh²dsa, ca¹tsáih¹dsa dsa² héi²: ―Ma²ca¹jén² jnieh³ dsa² ma²lǿa¹² jǿg³ hi² jií¹ héi², dsa² ca¹hia¹ hlai³ Moisés quianh¹³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih², ju³lah rø²juúh² si² quiah¹²dsa. Jesús báh³ héi², ja³ŋiúh³ José, dsa² chian² Nazaret ―ca¹juúh² Felipe. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jøng² ca¹juúh² Natanael, ca¹tsáih¹dsa Felipe: ―¡Tsa¹lë́²jni hi² lé² li¹chian² jan² dsa² dsiog¹ jøa³juøi² Nazaret, mi³né³! ―ca¹juúh²dsa. Jøng² ca¹juúh² Felipe: ―Ma¹ne¹³ di³ cøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jøng² ca¹ŋi¹lé²dsa. Mi³ca¹jë́² Jesús Natanael, ca¹juúh²dsa: ―Jai³lah. Dsa² já¹² ná¹² lah¹dsóh² lán¹² jan² dsa² dsiog¹ quián¹² dsa² israel, dsa² tsa¹hniu¹ jin³ he² jǿg³ tø³jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jøng² ca¹juúh² Natanael: ―¿Ha²lah dsio¹ cuaih¹²hning jní²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Ca¹jan³jni hning² cónh¹ niúh¹ jín³ hi² ca¹tǿh¹ Felipe hning², ja³mi³ŋíh²hning huu¹³ hma² higo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jøng² ca¹juúh² Natanael: ―Tøa¹², lanh¹²hning jong¹² Diú¹³. Lanh¹²hning rai¹³ quián² jnieh³, dsa² israel ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jøng² ca¹juúh² Jesús: ―¿Lah³té¹² hi² héh²hning jǿg³ quieg¹ jní² ni³ huu¹³ hi² na²juúh¹jni hi² ca¹jan³jni hning² ŋíh²hning huu¹³ hma² higo? Di³ na¹ bíh³ jáih³hning ja³jmo³jni hi² ué² hi³méh¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jøng² ca¹juúh² Jesús calah: ―Lah¹dsóh² juǿi²jni hning²: Jmai³ chi³quë́¹ jáih³hning ja³nií² guiuh¹³ ŋi¹juǿi¹. Jah³hning ángeles quián¹² Diú¹³ tsø²siúg²dsa ni³ quieg¹ jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cónh¹ ma²hnøa¹² jmai³ jøng², ca¹jmo¹dsa cøng² jmai³ ja³ca¹jenh² gug² dsa² jøa³juøi² Caná, juøi² tén¹² Galilea. Jøng² mi³hiúg³ mi³chiég³ Jesús ja³ca¹jmo¹dsa jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jø¹² bíh³ ca¹ŋi³lé³ Jesús quianh¹³ dsa² quianh³dsa ja³jøng². Di³ ca¹tøa¹ dsa² ca¹jmo¹ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jøng² ca¹dsa¹ jmøi² møi¹gu³jøah¹³ mi³hǿnh² dsa² tiogh³ jmai³. Jøng² ca¹juúh² mi³chiég³ Jesús, ca¹tsáih¹dsa ja³ŋiúh³dsa: ―Ma²ca¹dsa¹ jmøi² quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ jǿg³ ná¹² juaih¹²hning jní², Mai³¹? Ha¹chi² ma²ca¹dsiég¹ jmai³ ja³mi³léi¹³jni hein² dsa² lán¹²jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jøng² ca¹juúh² mi³chiég³dsa, ca¹tsáih¹dsa dsa² dsioh¹² má¹: ―Jmóh³ hniah¹² he² hi² juúh² ja²ŋiúh¹jni ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ja³jøng² mi³tioh¹³ jŋiéng² mǿi² dsøg³ cah³, hi² lǿa¹² cang³. Dsøg³ jøng² tieh¹² dsa² hniu³ jmøi² jmo¹²dsa ti³jŋió¹³dsa, ju³lah løa¹² mai³¹ quiah¹² dsa² judío. Heih¹² cónh¹ ochenta ho¹ ju³ ŋi²lǿg² litro jmøi² lah¹cøng² lah¹cøng² dsøg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² dsioh¹² má¹: ―¡Gu²tieh³ jmøi² guúh² ca¹lah¹jǿ¹ dsøg³ tioh¹³ ná¹² ca¹lah¹ja³ca¹cángh²! ―ca¹juúh²dsa. Jøng² ca¹mi¹cángh² dsa² héi² dsøg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jøng² ca¹juúh² calah Jesús: ―¡Quin² mih² jmøi² ná¹²! ¡Gu²cuøh³ dsa² dsen¹³ quián¹² jmai³! ―ca¹juúh² Jesús. Jøng² ca¹ŋi³can¹³ dsa² héi² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ca¹cang¹ dsa² dsen¹³ jǿg³ dsøg¹² jmøi² jøng². He³ jmøi² guúh² jøng² ma²lǿa¹² jmøi² møi¹gu³jøah¹³ mi³ca¹hǿnh²dsa. Jin³ tsa¹ŋi¹² dsa² dsen¹³ ha² juu¹² ca¹já¹ jmøi². Ŋi¹² báh³ dsa² dsioh¹² má¹. Jøng² ca¹tǿh¹ dsa² dsen¹³ dsa² ŋioh¹² ca¹jenh² gug². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ca¹juúh² dsa² dsen¹³: ―Jmøi² dsio¹ báh³ dsioh¹²dsa lah¹ni³, ju³lah ca¹lah¹já¹ dsa² jmo¹² jmai³. Jøng² báh³ ma²dsioh¹²dsa jmøi² huø³ dsǿa¹², na³ma²na²hǿnh²dsa ma¹dsio¹². Siíh² báh³ ma²na²jmoh³ hning². Ha²lah dsio¹ ca¹chiagh³ hning² jmøi² hiug¹² jín³ hi² dsio¹ ca¹lah¹ca¹tǿ² ja³ca¹tóh² jø² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Lah¹jøng² báh³ ca¹løa¹ juu¹² juøh¹² ca¹jmo¹ Jesús lah¹ni³, hi² ca¹jmo¹dsa Caná ja³tén¹² Galilea. Ca¹mi¹léi¹³ Jesús hi² juanh¹²dsa. Jøng² ca¹hé¹ dsa² quianh¹³dsa jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mi³ca¹ŋǿ² jmai³, ca¹ŋó¹ Jesús juu¹² Capernaum quianh¹³ mi³chiég³dsa, quianh¹³ roh¹³dsa, quianh¹³ dsa² quianh¹³dsa. Ja³jøng² ca¹ŋi³túgh²dsa ca²tí² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ja¹quién¹³ jmai³ ta²høa³ jmo¹² dsa² judío. Jøng² ca¹ŋó¹ Jesús juu¹² jøa³juøi² Jerusalén, ja³jmo¹²dsa jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mi³ca¹dsiég¹ Jesús ja³tsih¹³ guøh¹² juøh¹² ja³jøng², ca¹jë́²dsa dsa² ti³hnë¹² ca³juu² dsú² quianh¹³ jah¹chih² quianh¹³ jug². Tiogh³ dsa² mi²tsë́¹ cog³ calah ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jøng² mi³ca¹guiu¹ Jesús cøng² hnei¹³, ca¹huan¹dsa dsa² hnë¹² jáh² héi² ja³dsi¹² guøh¹², cu¹dsie¹² quianh¹³ jah¹chih² quianh¹³ ca³juu². Ca¹quián²dsa huø¹ cog³ quiah¹² dsa² mi³mi²tsë́¹ cog³ héi². Ca¹jeinh¹dsa mesa quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² hnë¹² jug²: ―Ja³siíh³ gu³jianh¹² hniah¹² jáh² quiánh² hniah¹². Tsa¹jmóh³ hniah¹² hniu³ ti³ŋieh¹jni ju³lah lǿa¹² cøng² jøa³hmah³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jøng² ca¹dságh¹ dsǿa¹² dsa² quianh¹³ Jesús jǿg³ la² lǿa¹² ni³ si² quiah¹² Diú¹³: “Cu¹dsie¹² tsa¹ma¹ca¹lø¹juanh¹² dsøa¹jni mi³huu¹³ hniú¹² quiánh²hning,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jøng² ca¹juúh² dsa² canh¹³ quián¹² dsa² judío: ―¿He² juu¹² juøh¹² jmóh³hning? Mi³jøng² li¹ne³ jnieh³ chi² juu¹² jmø³hiég¹ quiánh²hning hi² jmóh³hning lah¹ná¹² ―ca¹juúh² dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jøng² ca¹juúh² Jesús: ―Cøng² juu¹² juøh¹² báh³ jmo¹³jni. Ju³ná³ ca¹hénh¹ hniah¹² guøh¹² la², jøng² quianh¹³ hnøa¹² jmai³ tsǿh³jni calah ni³ hmë́² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jøng² ca¹juúh² dsa² canh¹³: ―Ha¹chi² tiah¹hning tsǿh³ guøh¹² ni³ hmë́² quianh¹³ hnøa¹² jmai³. Ton¹lág¹ rø²dsǿ² jŋiéng² ŋi² jmai³ ma²tǿ² hi² jmo¹²dsa guøh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ca¹juúh² Jesús jǿg³ ti³jnøa¹² jøng² quiah¹² guøh¹², hi² he¹²dsa jmø²ŋǿ¹² quiah¹²dsa, hi² ma²lǿa¹² jmø²ŋǿ¹² ju³lah lǿa¹² cøng² hniú¹² ja³guǿ¹³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ca¹dságh¹ dsǿa¹² dsa² quianh¹³ Jesús jǿg³ jøng² mi³ca¹hiog²dsa jmai³ hnøa¹². Hi² jøng² ca¹hé¹ dsa² quianh¹³ Jesús jǿg³ quiah¹² Jesús quianh¹³ jǿg³ rø²juúh² si² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jue¹² dsa² ca¹tǿ² dsǿa¹² jǿg³ quiah¹² Jesús, mi³ca¹jái¹dsa juu¹² juøh¹² ca¹jmo¹dsa jmai³ ta²høa³ jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cónh¹jøng² ha¹chi² ca¹mi¹quianh¹³ Jesús dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Di³ ma²ŋi¹² báh³ Jesús ha²lah dsø²jiag¹² dsǿa¹² dsa² jmøi¹guǿi¹. Tsa¹hniuh¹² he¹ dsa² siáh² ha²lah lán¹² dsa² jue¹². Hŋiah¹² báh³ Jesús ma²ŋi¹² ha²lah lǿa¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jan² dsa² fariseo, dsa² lán¹² ta³ quiah¹² guøh¹² quiah¹² dsa² judío, dsa² tsen² Nicodemo, ");
INSERT INTO cpaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ca¹dsiég¹ dsa² héi² ja³guǿ¹³ Jesús cøng² ja³neng². Ca¹juúh²dsa: ―Tøa¹², ma²ne³ jnieh³ hi² lanh¹²hning jan² tøa¹², dsa² ca¹tse¹ Diú¹³. Di³ ha¹chian² dsa² tiúh¹ jmo¹ juu¹² juøh¹² ju³lah jmoh²hning ju³ná³ tsa¹mi³hag¹³ Diú¹³ ―ca¹juúh² Nicodemo. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hning²: Ha¹chian² dsa² dsianh¹³ ja³jmo¹² Diú¹³ héh¹ ju³ná³ tsa¹ca¹lø¹chián¹dsa ni³ hmë́² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jøng² ca¹juúh² Nicodemo: ―¿Ha²lah lé² hi² jøng², hi² li¹chian² jan² dsa² ma²juanh¹² ni³ hmë́²? Tsa¹lé² hí¹dsa calah togh¹² mi³chiég³dsa. Mi³jøng² li¹chian²dsa calah siíh² ―ca¹juúh² Nicodemo. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hning²: Ha¹chian² dsa² dsianh¹³ ja³jmo¹² Diú¹³ héh¹ ju³ná³ tsa¹ca¹jéinh¹ dsǿa¹²dsa ju³lah jeinh¹² dsǿa¹² dsa² tsog¹² jmøi², ju³ná³ tsa¹ca¹can¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dsa² ma²lǿa¹² jmø²ŋǿ¹² báh³ lán¹² jniang³ ja³lø²chian² jniang³ dsa² jmøi¹guǿi¹. Di³ jøng² dsa² ma²lǿa¹² jmi²dsí² báh³ lán¹² jniang³ ja³lø²chian² jniang³ quiah¹² jmi²dsí² han¹³ quiáh¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tsa³ju³li¹dsogh¹² hoh¹²hning jǿg³ ma²na²juǿi²jni hning² hi² hniuh¹² li¹chianh²hning ni³ hmë́². ");
INSERT INTO cpaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jai³ di³ ha²lah lǿa¹² dsí² hei¹² dsi³guøi². Dság¹² dsí² ta¹la² ta¹ná¹². Hein¹³ dsí², hi² nang¹² dsa² jmøi¹guǿi¹. Di³ jøng² tsa¹ŋi¹² dsa² jmøi¹guǿi¹ ha² juu¹² jií¹, ha² juu¹² dság¹ dsí². Lah¹jøng² báh³ lǿa¹² quián² jniang³ ja³lø²chian² jniang³ quiah¹² jmi²dsí² han¹³ quiah¹² Diú¹³, ju³lah lǿa¹² quiah¹² dsí². Tsa¹léi¹³ coh¹³ jmø²ŋǿ¹² ja³lø²chian² jniang³ ja³cog² jmi²dsí² han¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jøng² ca¹juúh² Nicodemo: ―Tsa¹lø²ŋë́²jni jǿg³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jøng² ca¹juúh² Jesús: ―Lanh¹²hning dsa² juanh¹², dsa² quin¹² ni³ juøi² quián¹² dsa² israel. ¿Ha²lah dsio¹ jøng² tsa¹lø²ŋë́h²hning jǿg³ jøng²? ");
INSERT INTO cpaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Lah¹dsóh² juǿi²jni hning²: Jmo² jnieh³ jǿg³ ma²ne³ jnieh³, jǿg³ quiah¹² hi² ma²ca¹ne¹³ jnieh³. Cónh¹jøng² tsa¹héh² hniah¹² jǿg³ quián² jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tsa¹héh² hniah¹² jǿg³ ca¹juǿi²jni hniah¹² ha²lah lǿa¹² ni³ jmøi¹guǿi¹. Jøng² tsa¹lë́²jni hi¹ héh² hniah¹² jǿg³ ju³ná³ ca¹juǿi²jni hniah¹² ha²lah lǿa¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ha¹chian² dsa² siáh² chian², dsa² ma²ca¹ŋie³ ŋi¹juǿi¹. Jan² jní² báh³ ma²ca¹ŋie³, jní² dsa² ca¹guio¹ juu¹² ŋi¹juǿi¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Di³ lah¹jøng² báh³ hniuh¹² lé² ju³lah ca¹jmo¹ hlai³ Moisés, mi³ca¹hë́²dsa møh² hi² lǿa¹² lai³ guiuh¹³ hma² juu¹² ja³ha¹chian² dsa² tiogh³. Di³ hi² hniuh¹² tiang¹dsa jní² guiuh¹³ hma², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mi³jøng² ju³ná³ hein² dsa² hé² jǿg³ quieg¹ jní², dsa² héi² li¹chian² tiá² ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Hiug¹² hnio¹ Diú¹³ dsa² jmøi¹guǿi¹. Hi² jøng² ca¹cuan¹dsa jan² jøng² báh³ jong¹²dsa. Mi³jøng² ju³ná³ hein² dsa² hé² jǿg³ quiah¹²dsa, tsa¹dsa¹hén² dsa² héi². Li¹chian² dsa² héi² tiá² ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ha¹chi² ca¹tse¹ Diú¹³ jong¹²dsa juu¹² ni³ jmøi¹guǿi¹, mi³huu¹³ hi² mi³cuúh¹dsa dsa² jmøi¹guǿi¹ dsag³. Ca¹tsei¹dsa mi³huu¹³ hi² liúg² jong¹²dsa dsa² jmøi¹guǿi¹ dsag³ hi² ni³re²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ha¹chi² dsag³ ta¹canh¹³ dsa² hé² jǿg³ quiah¹² jong¹² Diú¹³. Cónh¹jøng² ju³ná³ hein² dsa² tsa¹hé² jǿg³ quiah¹² jong¹² Diú¹³, dsa² héi² ma²rø²canh¹² dsag³. Di³ tsa¹ca¹hé¹dsa jǿg³ quiah¹² jan² jøng² báh³ jong¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lah¹la² báh³ jmo¹² hi² ma²rø²canh¹² dsa² jmøi¹guǿi¹ dsag³: Ca¹lø¹chián¹ jong¹² Diú¹³ ni³ jmøi¹guǿi¹, dsa² jmo¹² taih¹² juu¹² ja³ŋi¹nio¹ dsa² jmøi¹guǿi¹. Cónh¹jøng² tsa¹hniu¹ dsa² jmøi¹guǿi¹ ŋi¹nio¹ ja³taih¹². Hiug¹² jín³ hi² hniu¹dsa ja³neng². Di³ hi² hlaih¹³ jmo¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hian³ dsa² jmo¹² hi² hlaih¹³ dsa² jmo¹² taih¹² juu¹². Tsa¹hniu¹dsa li¹quianh¹³dsa dsa² héi², ju³ jøng² ca¹lø¹jní¹ hi² hlaih¹³ hi² jmo¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jøng² dsa² jmo¹² ju³lah lǿa¹² jǿg³ dsøg¹², dsa¹lé² dsa² héi² dsen¹³ cah³ dsa² jmo¹² taih¹² juu¹². Mi³jøng² li¹léi¹³ cu²rø² jmo¹²dsa ju³lah hniu¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ni³ jøng² ca¹ŋi¹lé² Jesús quianh¹³ dsa² quianh³dsa juu¹² ja³tén¹² Judea. Ca¹jŋi¹dsa ja³jøng². Ca¹ŋi¹chiog¹dsa dsa² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jø¹² bíh³ hiúg³ Juan jøa³juøi² Enón, cøg¹² juøi² Salim. Ja³jøng² mi³chiog¹²dsa dsa² jmøi². Di³ ma¹dsio¹² jmøi² hii² ja³jøng². Jue¹² dsa² ca¹dsi¹lé². Ca¹jŋó²dsa jmøi² ca¹chiag¹ Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ha¹chi² ma²ca¹dsiég¹ jmai³ ja³ca¹tanh¹²dsa Juan hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jøng² ca¹dsii¹ dsa² quianh³ Juan jǿg³ quianh¹³ jan² dsa² judío ha²lah jmo¹dsa ni³jŋió¹³dsa ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hi² jøng² ca¹ŋi¹lé²dsa ja³tsenh¹³ Juan. Ca¹juúh²dsa: ―Tøa¹², dsa² héi² ma²chiog¹² dsa² jmøi², dsa² mi³hiúg³ quianh¹³ hnéng¹ tø¹hŋoh¹³ chi³jmøi² Jordán, dsa² ca¹cuøh³hning jǿg³ dsio¹ quiah¹². Jøng² ca¹lah¹já¹ dsa² ma²dsø²lé² dsen¹³ cah³ dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jøng² ca¹juúh² Juan: ―Ha¹chi² juu¹² jmø³hiég¹ chi² quián² jniang³ dsa² jmøi¹guǿi¹, ju³ná³ tsa¹cuø¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Guiogh¹³ báh³ hniah¹² ca¹nengh² jǿg³ ca¹juúh¹jni, hi² tsa¹lán¹²jni Cristo. Lán¹²jni tsih² høh³ ca¹tse¹ Diú¹³, dsa² ŋøa¹² ma²jiá¹² jín³ cónh¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lǿa¹² quieg¹ jní² ju³lah lǿa¹² quiah¹² ha²mei¹³ quián¹² dsa² ŋioh¹² ca¹jenh² gug². Dsa² ca¹jenh² gug² héi² báh³ dsa² jian¹ hio¹³. Jøng² hioh¹² jenh¹² ha²mei¹³ quián¹²dsa na³ma²ca¹jái¹dsa ca¹hie¹ dsa² héi² hio¹³ quián¹². Lah¹jøng² báh³ hioh¹² jéin¹² jní² ja³cog² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hi² hniuh¹² báh³ jøng², hi² dsø¹cón³ jǿg³, hi² lán¹² dsa² héi² dsa² juanh¹², ta³lah¹jøng² hi² tsa¹ma¹li¹chi² jǿg³ quieg¹ jní² ―ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hiug¹² jín³ juanh¹² dsa² chian² guiuh¹³ ŋi¹juǿi¹ cónh¹ jín³ ca¹lah¹já¹ dsa² chian² jmøi¹guǿi¹. Dsa² jmøi¹guǿi¹ báh³ dsa² chian² guøh³ huø¹ la², dsa² hløah¹² jmáh¹lah jǿg³ chi² ni³ jmøi¹guǿi¹. Jøng² hiug¹² jín³ juanh¹² dsa² chian² ŋi¹juǿi¹ cónh¹ jín³ ca¹lah¹já¹ dsa² chian² guøh³ huø¹ la². ");
INSERT INTO cpaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","He¹²dsa jǿg³ quiah¹² hi² ma²ca¹ jái¹dsa, hi² ma²ca¹nǿng²dsa. Cónh¹jøng² tsa¹hé² dsa² jue¹² jǿg³ juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ju³ná³ hein² dsa² hé² jǿg³ juúh² dsa² chian² ŋi¹juǿi¹, dsa² héi² jmo¹² hi² té¹² jǿg³ juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Di³ jǿg³ quiah¹² Diú¹³ báh³ hløah¹² dsa² ca¹tse¹ Diú¹³. Cuø¹² Diú¹³ ja³ca¹lah¹jǿ¹ jmi²dsí² quiah¹²dsa ja³cog² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Hnio¹ Diú¹³ ja³ŋiúh³dsa. Ma²ca¹dsii¹dsa gug² tai³ ja³ŋiúh³dsa ca¹lah¹jǿ¹ juu¹² jmø³hiég¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ju³ná³ hein² dsa² hé² jǿg³ quiah¹² jong¹² Diú¹³, li¹chian² dsa² héi² tiá². Jøng² ju³ná³ hein² dsa² tsa¹mi²ti¹ jǿg³ quiah¹² jong¹² Diú¹³, tsa¹li¹chian² dsa² héi² ja³cog² Diú¹³. Ma²hian¹³ Diú¹³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ca¹lø¹ŋi¹² dsa² fariseo hi² hiug¹² jín³ jue¹² dsa² ma²quianh¹³ Jesús cónh¹ jín³ dsa² quianh¹³ Juan. Ca¹lø¹ŋi¹²dsa hi² ma²chiog¹² Jesús dsa² jue¹² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Cónh¹jøng² a¹jáng¹ hŋiah¹² Jesús dsa² chiag¹² jmøi² quiah¹²dsa. Dsa² quianh¹³ báh³ dsa² jmo¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jøng² mi³ca¹lø¹lih¹³ Jesús hi² ma²ŋi¹² dsa² fariseo jǿg³ jøng², ca¹u¹hái¹dsa ja³tén¹² Judea. Ca¹ŋáh¹dsa juu¹² ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hi² hniuh¹² tsø³jue¹³ Jesús ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jøng² ca¹dsiég¹dsa Sicar, juøi² tén¹² Samaria, juøi² neng¹² cøg¹² huø¹ ca¹cuúh¹ hlai³ Jacob hlai³ José, ja³ŋiúh³dsa, ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ja³jøng² ho¹² tøg² jmøi² ca¹guiég¹ hlai³ Jacob. Ma²ca¹huh¹ Jesús hi² hiúg³dsa juu¹², mi³ca¹dsiég¹dsa ja³ho¹² tøg² jmøi². Ma²tǿ² cónh¹ dsi¹hiég¹. Hi² jøng² ca¹guú²dsa cøg¹² tøg² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jøng² ca¹dsiég¹ jan² hio¹³ chian² ja³jøng², dsa² cán² jmøi² tøg² jmøi² jøng². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa hio¹³ héi²: ―Cuúh³hning ca²juuh³ jmøi² guúh² gøh³jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Cu²hŋiah¹² Jesús. Mi³guǿ¹²dsa ja³jøng². Di³ ca¹ŋi¹lé² dsa² quianh³dsa juu¹² jøa³juøi² jøng². Ca¹ŋi¹hneng²dsa hi² gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hi² jøng² ca¹juúh² hio¹³ héi²: ―¿Ha²lah dsio¹ møh²hning jmøi² ja³cog² jní², hning² dsa² lanh¹² jan² dsa² judío? Di³ hi² lán¹²jni dsa² chian² Samaria. Lah¹jøng² ca¹juúh² hio¹³. Di³ tsa¹chi² hiug² dsǿa¹² dsa² judío ca¹lah¹jin³ mih² ja³cog² dsa² chian² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jøng² ca¹juúh² Jesús: ―Tsa¹ŋih³hning he² hi² mi³cuø¹ Diú¹³ ja³cogh²hning. Tsa¹cuaih¹²hning jní², dsa² ma²na²møa¹ jmøi². Di³ mi³mǿh³hning² jmøi² ja³cog² jní² ju³ jøng² ma²ŋih³hning hein² dsa² jní². Jøng² mi³cuø¹³jni jmøi² jmo¹ li¹chianh²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jøng² ca¹juúh² hio¹³ héi²: ―Guiuh¹³, ha¹chi² quinh³hning quianh¹³ hi² li¹chioh³hning jmøi². Hieg³ báh³ ha³ jmøi². ¿Ha² tøah¹ li¹chi² jmøi² mi³cuøh¹³hning jní²? ");
INSERT INTO cpaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Lanh¹³hning dsa² juanh¹² cónh¹ jín³ hlai³ Jacob, dsa² hóg¹ quián² jniang³, dsa² ca¹guiég¹ tøg² la²? Jmøi² la² ca¹hǿnh² dsa² héi² hŋiah¹², quianh¹³ jong¹²dsa, quianh¹³ jáh² quián¹²dsa ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jøng² ca¹juúh² Jesús: ―Ju³ná³ hein² dsa² hǿnh² jmøi² ha³ tøg² jmøi² la², dsa² héi² lé² lø¹i³hǿnh² jmøi² calah jmai³ siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Cónh¹jøng² tsa¹lǿa¹² lah¹jøng² jmøi² cuø¹³ jní². Jmøi² cuø¹³ jní² jmo¹ li¹hiug² dsǿa¹² dsa² qui²hǿnh². Jøng² cøng² hi² li¹chi² jmøi² jøng² quiah¹²dsa, jmøi² jmo¹ hi² li¹chian²dsa tiá² ja³cog² Diú¹³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jøng² ca¹juúh² hio¹³: ―¿Tsa³cuøh¹³hning jní² jmøi² jøng², guiuh¹³? Jøng² tsa¹ma¹lé² li¹i³gøh³jni jmøi² jmai³ siíh³. Jøng² tsa¹ma¹guio¹³jni ja³ho¹² tøg² jmøi² la² jmai³ siíh³, hi² ŋi³quin¹jni jmøi² ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jøng² ca¹juúh² Jesús: ―Gu²tei³ ji²gugh²hning. Jøng² ŋi³noh¹² hniah¹² ja³la² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jøng² ca¹juúh² hio¹³: ―Ha¹chian² ji²gug²jni ma¹chian² ―ca¹juúh² hio¹³. Jøng² ca¹juúh² Jesús: ―Jǿg³ dsøg¹² báh³ ma²ca¹juøh³hning hi² tsa¹chian² ji²gugh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Di³ hŋí² rón² ma²ca¹jenh² gugh²hning quianh¹³ dsa² ŋioh¹². Jøng² ma²jianh¹²hning dsa² ŋioh¹² tsa¹lán¹² ji²gugh²hning. Jǿg³ dsøg¹² ma²ca¹juøh³hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jøng² ca¹juúh² hio¹³: ―Lah¹dsóh² léi¹³jni, guiuh¹³, hi² lanh¹²hning jan² dsa² hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ca¹mi¹juanh¹² dsa² hóg¹ quián² jnieh³ Diú¹³ ni³ máh² tsih¹² ja³ná³. Cónh¹jøng² juúh² dsa² goh²hning hi² hniuh¹² mi³juanh¹³ jniang³ Diú¹³ jmáh¹lah jøa³juøi² Jerusalén ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jøng² ca¹juúh² Jesús: ―Ju³héh³hning jǿg³ juǿi²jni hning², hio¹³. Jií¹ jmai³ ja³tsa¹tiog¹³ hniuh¹² dsa¹lé² dsa² jmøi¹guǿi¹ jøa³juøi² Jerusalén ho¹ ju³ ni³ máh² tsih¹² ja³ná³. Cøng² hi² ma²lé² mi¹juanh¹²dsa Diú¹³ ha² ja³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hniah¹² dsa² chianh² Samaria, tsa¹cueh¹² hniah¹² Diú¹³ mi²juanh¹³ hniah¹². Cónh¹jøng² jnieh³, dsa² judío, cue¹² báh³ jnieh³ Diú¹³ mi²juanh¹³ jnieh³. Di³ jøa³ ja³tiagh³ jnieh³ dsa² judío li¹chi² jǿg³ jmo¹ hi² liúg² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ja¹quién¹ dsiég¹³ jmai³ ja³mi¹juanh¹² dsa² jmøi¹guǿi¹ Jmi² jniang³ ca¹lah¹hiu³ dsǿa¹². Ma²ca¹gog¹ báh³ jmai³. Mi¹juanh¹²dsa Jmi² jniang³ quianh¹³ jmi²dsí² quiah¹² báh³ dsa², quianh¹³ jǿg³ dsøg¹². Di³ lah¹jøng² báh³ hniu¹ Jmi² jniang³ hi² mi³juanh¹³ jniang³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Lán¹² Diú¹³ ju³lah lǿa¹² cøng² jmi²dsí². Jøng² hniuh¹² mi³juanh¹³ jniang³ Diú¹³ quianh¹³ jmi²dsí² quián² jniang³, quianh¹³ jǿg³ dsøg¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jøng² ca¹juúh² hio¹³: ―Guiang³ báh³ jní² hi² jií¹ jan² dsa² tse¹ Diú¹³, dsa² tsen² Mesías, dsa² tǿh²dsa Cristo calah. Na³ma²ca¹guøn¹ dsa² héi² nií¹dsa jǿg³ ha²lah lán¹² Diú¹³ ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jøng² ca¹juúh² Jesús: ―Lán¹²jni hŋiéng¹jni Cristo héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta³lah¹ti³dsii¹²dsa jǿg³ ca¹dsi¹lé² dsa² quianh³ Jesús. Hiug¹² ca¹lø¹dsogh¹² dsǿa¹²dsa mi³ca¹jái¹dsa ma²dsii¹² Jesús jǿg³ quianh¹³ hio¹³ héi². Cónh¹jøng² tsa¹chian²dsa ca¹tí² dsǿa¹²dsa hi² ŋai¹dsa ha²lah lǿa¹² jǿg³ dsii¹²dsa ho¹ ju³ he² løa¹ dsii¹²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ja³jøng² ca¹tsih¹ hio¹³ dsøg³ quiah¹². Ca¹ŋáh¹dsa juu¹² jøa³juøi². Ca¹ŋi¹tseih³dsa dsa². Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ma¹dsǿg³ quianh¹³ jní². Ma¹ne³ jniang³ jan² dsa² ŋioh¹² ma²ca¹hlaih¹ jní². Ma²ŋi¹²dsa ca¹lah¹jǿ¹ ha²lah ma²ca¹jmo¹jni. ¡Ju³ne¹³! ¿Tsa³lán¹² dsa² héi² Cristo? ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jøng² ca¹ŋi¹lé² dsa² chian² juøi² jøng² juu¹² ja³guǿ¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta³lah¹hiúg³ hio¹³ jøa³juøi², quianh¹³ hi² tiog¹³ ca¹juúh² dsa² quianh¹³ Jesús: ―¿Tsa³cǿh³hning, Tøa¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jøng² ca¹juúh² Jesús: ―Tsa¹lǿ² lø¹i³cón¹³jni. Chi² báh³ hi² jmo¹² li¹hiug² dsøa¹jni, hi² tsa¹ŋih³ hniah¹² ha²lah lǿa¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jøng² ca¹dsii¹ dsa² quianh¹³dsa jǿg³ cu³guiog³dsa. Ca¹juúh²dsa: ―¿Ho¹ ju³ dsa² siáh² ma²na²u¹can¹² má¹ hi² ma²na²gǿh¹dsa ta³lah¹na²u³hnéng³ jniang³ hé¹² jøa³juøi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jøng² ca¹juúh² Jesús: ―Ca¹lah¹hiu³ dsøa¹jni mi³ti³jni héh¹ ca¹jmo¹ dsa² ca¹tsei¹ jní². Lah¹jøng² báh³ jmo¹² hi² li¹hiug² dsøa¹jni, ju³ná³ jmo¹²jni ju³lah lǿa¹² jǿg³ ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Juúh² hniah¹²: “Hi² hei¹² quión² tsøh² hi² li¹chi² jøa³nung²”, juúh² hniah¹². Cónh¹jøng² juǿi²jni hniah¹²: Jai³lah. Ma²ja¹lé² dsa² chian² jøa³juøi². Lán¹²dsa ju³lah cøng² hi² ma²chi² jøa³nung², hi² ma²lé² jiégh³ jniang³. Di³ ma²ca¹dsiég¹ jmai³ ja³li¹quianh¹³ jniang³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Li¹hmah¹³ quiah¹² dsa² jmo¹ li¹quianh¹³ jniang³ dsa² héi², dsa² jmo¹ li¹chian² dsa² héi² tiá² ja³cog² Diú¹³. Ma²ca¹mi³liág¹³jni hi² li¹quianh¹³ jniang³ dsa² héi². Jøng² cu²rø² tiágh³ jniang³ hioh¹² jenh¹² jniang³ quianh¹³ dsa² mi¹hian¹² jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jǿg³ té¹² báh³ juúh² dsa²: “Hi² jne¹ jan² dsa² møi¹jon². Cónh¹jøng² dsa² siáh² báh³ jiégh² mǿi² na³ma²chi²,” juúh² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ca¹tsë́²jni hniah¹² hi² jmóh³ hniah¹² ta³ tsa¹ca¹mi³liagh¹³ hniah¹². Dsa² siáh² báh³ ca¹mi¹liág¹ hi² li¹quianh¹³ jniang³ dsa². Hniah¹² dsa² ca¹të́h² mi³hianh¹³ hniah¹² ta³ quiah¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jøng² ca¹hé¹ jue¹² dsa² chian² juøi² jøng² jǿg³ quiah¹² Jesús huu¹³ jǿg³ ca¹juúh² hio¹³ hi² ma²ŋi¹² Jesús ca¹lah¹jǿ¹ ha²lah ma²ca¹jmo¹ hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jøng² mi³ca¹dsi¹lé² dsa² chian² Samaria héi² ja³guǿ¹³ Jesús, ca¹mǿh¹dsa Jesús hi² jŋi¹dsa ja³jøng². Jøng² ca¹jŋi¹dsa ton¹ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jøng² hiug¹² jín³ jue¹² dsa² héi² ca¹hé¹ jǿg³ quiah¹²dsa mi³ca¹nǿng²dsa jǿg³ ca¹juúh²dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jøng² ca¹juúh² dsa² jue¹², ca¹tsáih¹dsa hio¹³ héi²: ―Ha¹chi² ma¹hé² jnieh³ jǿg³ ni³ huu¹³ jǿg³ ca¹juøh³ hning². Di³ guiag¹³ báh³ jnieh³ ma²ca¹néng³ jǿg³ juúh² Jesús hŋiah¹². Hi² jøng² ma²ne³ jnieh³ hi² lah¹dsóh² lán¹² Jesús dsa² liúg² dsa² jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ma²ton¹ jmai³ jøng² ca¹ŋáh¹ Jesús juu¹² ja³tén¹² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Di³ ma²ca¹juúh²dsa lah¹jiá¹² hi² tsa¹mi²juanh¹² dsa² go²dsa dsa² hǿ² jǿg³ quiah¹² Diú¹³, ma²ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jøng² ca¹hie¹ dsa² chian² Galilea Jesús mi³ca¹dsiánh¹dsa ja³jøng². Di³ ma²ca¹jái¹dsa juu¹² juøh¹² ma²ca¹jmo¹ Jesús jøa³juøi² Jerusalén jmai³ ta²høa³. Di³ ma²ca¹ŋi³lé³dsa jmai³ jøng² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jøng² ca¹ŋó¹ Jesús calah juu¹² jøa³juøi² Caná, ja³ca¹jmo¹dsa juu¹² juøh¹² hi² ca¹lø¹tsë́¹ jmøi² guúh², hi² ca¹løa¹ jmøi² møi¹gu³jøah¹³. Jøng² mi³chian² jan² dsa² ta³ jøa³juøi² Capernaum. Dsoh³ ja³ŋiúh³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jøng² mi³ca¹nǿng² dsa² ta³ héi² hi² ca¹u¹hái¹ Jesús ja³tén¹² Judea, hi² ca¹dsiég¹ Jesús ja³tén¹² Galilea, jøng² ca¹ŋó¹dsa. Ca¹ŋi¹tseih³dsa Jesús chi²júh² dság¹dsa, hi² mi¹hliú²dsa ja³ŋiúh³dsa, dsa² ja¹quién¹³ jón². ");
INSERT INTO cpaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jøng² ca¹juúh² Jesús: ―Tsa¹héh²hning jǿg³ quieg¹ jní² chi²júh² tsa¹jáih²hning juu¹² juøh¹² quianh¹³ hi² gøg² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jøng² ca¹juúh² dsa² ta³: ―Tiog¹³ ma¹dsǿg³ quianh¹³jni ja³quieg¹jni, Guiuh¹³, niúh¹ jín³ hi² jón² jon¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jøng² ca¹juúh² Jesús: ―Ma²lé² guǿnh³hning. Hliú² báh³ ja²ŋiúh¹hning ―ca¹juúh² Jesús. Jøng² ca¹hé¹ dsa² ta³ jǿg³ jøng². Jøng² ca¹ŋáh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ca¹jén²dsa og¹ úg³ dsa² quián¹²dsa dsi²juu¹², dsa² ca¹jmo¹ jǿg³ ma²ca¹hlú² ja³ŋiúh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jøng² ca¹ŋai¹ dsa² ta³ he² hora ca¹lø¹liág¹ hi² ma²dsø²jŋi¹ quiah¹²dsa. Jøng² ca¹juúh² dsa² quián¹²dsa: ―Cónh¹ hein¹³ cøng² ta¹ca¹hlég² dsiég² ca¹jŋi¹ hi² dsén²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jøng² ca¹dsagh² dsǿa¹² dsa² ta³ cónh¹ hora jøng² báh³ ca¹juúh² Jesús hi² hliú² ja³ŋiúh³dsa. Jøng² ca¹hé¹ dsa² ta³ jǿg³ quiah¹² Jesús quianh¹³ ca¹lah¹já¹ dsa² tiogh³ ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hi² jøng² ca¹løa¹ ja³ma²ton¹ juu¹² juøh¹² ca¹jmo¹ Jesús ja³tén¹² Galilea, mi³ca¹u¹hái¹dsa ja³tén¹² Judea. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jmai³ siíh³ jøng² ca¹ŋi¹jái² Jesús cøng² jmai³ juøh¹² quiah¹² dsa² judío juu¹² jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jøa³juøi² jøng² lǿa¹² cøng² ja³neng¹² jmøi² cøg¹² hag³jnǿ³ tsen² Hag³jnǿ³ Quiah¹² Jah¹chih². Betsata báh³ tsen² jmøi² jøng² quianh¹³ jǿg³ hebreo. Lǿa¹² hŋí² corredor lah¹jin² lah¹lǿih¹ ja³neng¹² jmøi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Corredor jøng² ma²ti³ganh¹³ jue¹² dsa² lán¹² hliú² ni³ dsag³, dsa² teg³ quianh¹³ dsa² ŋøa¹² guiánh³ quianh¹³ dsa² tsa¹li¹ŋøa¹. Ja³jøng² ti³jŋi¹² dsa² dsoh³ hi² hiánh² jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Di³ jmai³ lan¹³ jógh² jan² ángel juu¹² ŋi¹juǿi¹. Jmo¹² ángel hi² hiánh² jmøi². Jøng² ju³ná³ hein² dsa² dsoh³ lah¹ni³ ca¹tí²dsa tai³dsa niúh¹ jmǿi¹ ca¹lah¹cónh¹ mi³ca¹hiánh² ángel jmøi², dsa² héi² ca¹hlú² ca¹lah¹i³ ni³ dsag³ mi³lán¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jøng² mi³hiúg³ jan² dsa² ŋioh¹² ja³jøng². Ma²ni³ŋó¹³ cónh¹ ma²gui²guií² rø²dsǿ² jŋi¹ ji²ŋi² hi² dsoh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jøng² ca¹jë́² Jesús dsa² dsoh³ héi². Ca¹lø¹lih¹³dsa ma²ni³ŋó¹³ jmai³ rø²quia¹²dsa ja³jøng². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² dsoh³: ―¿Hnøngh³hning hi² hliúh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jøng² ca¹juúh² dsa² dsoh³: ―Guiuh¹³, ha¹chian² dsa² chian² mi¹hag¹³ jní² hi² ŋi³høa¹jni jmøi² na³ma²hiánh². Jøng² dsa² siáh² báh³ tí² tai³ niúh¹ jín³ hi² dsiég¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jøng² ca¹juúh² Jesús: ―¡Nung²! ¡Chiag³ jmung² quiánh²! ¡Ŋøa³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dsø¹juu¹² jøng² ca¹hlú² dsa² dsoh³. Ca¹can¹dsa jmung² quiah¹²dsa. Ca¹ŋøa¹dsa. Lah¹jøng² ca¹løa¹ cøng² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hi² jøng² ca¹juúh² dsa² canh¹³ quián¹² dsa² judío, ca¹tsáih¹dsa dsa² mi³dsoh³: ―Tsa¹lǿa¹² lei¹³ hi² quinh³hning jmung² quiánh²hning jmai³ sa³¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jøng² ca¹juúh² dsa² mi³dsoh³: ―Dsa² ma²na²jmo¹ hí³ quieg¹jni ca¹jmo¹ héh¹. “¡Chiag³ jmung² quiánh²! ¡Ŋøa³!” ca¹juúh²dsa, ca¹tsáih¹dsa jní² ―ca¹juúh² dsa² mi³dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jøng² ca¹juúh² dsa² canh¹³: ―¿Hein² dsa² ca¹jmo¹ héh¹ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tsa¹ŋi¹² dsa² mi³dsoh³ héi² hein² dsa² ca¹jmo¹ hí³ quiah¹²dsa. Di³ dsø¹juu¹² jøng² ca¹ŋó¹ Jesús juu¹² ja³siíh³. Di³ jue¹² dsa² mi³tiogh³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mi³ca¹løa¹ lah¹jøng², ca¹jén² Jesús dsa² mi³dsoh³ héi² ja³dsi¹² guøh¹² juøh¹². Jøng² ca¹juúh² Jesús: ―Jai³lah, ma²ca¹hlúh²hning. ¡Tsa¹ma¹jmo² hi² hlaih¹³! Mi³jøng² tsa¹li¹chianh²hning jmø³uai¹² ué² hi³méh¹ cónh¹ jín³ dsag³ mi³lanh¹²hning ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jøng² ca¹ŋó¹ dsa² mi³dsoh³. Ca¹tsáih¹dsa dsa² canh¹³ quián¹² dsa² judío hi² lán¹² Jesús dsa² ca¹jmo¹ hí³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Huu¹³ jøng² ca¹mi¹dsian¹² dsa² canh¹³ dsǿa¹² Jesús. Di³ ca¹jmo¹ Jesús hí³ dsa² dsoh³ jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² canh¹³: ―Cøng² hi² ma²jmo¹² ti³ŋieh¹jni ju³lah lǿa¹² jǿg³ quiah¹²dsa. Jø¹² bíh³ lah¹jøng² jmo¹² jní² calah ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hi² jøng² hiug¹² jín³ hi² hniu¹ dsa² canh¹³ jŋëh¹dsa Jesús, mi³ca¹nǿng²dsa jǿg³ jøng². Di³ a¹jáng¹ jmáh¹lah hi² jøng², hi² ca¹jmo¹ Jesús tsa¹quien¹² lei¹³ quiah¹² dsa² judio ha²lah jmo¹ dsa² jmai³ sa³¹, cónh¹ calah ca¹jmo¹dsa cu²re²dsa quianh¹³ Diú¹³. Di³ ca¹tǿh¹dsa Diú¹³ ti³jmi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² canh¹³: ―Lah¹dsóh² juǿi²jni hniah¹²: Tsa¹lé² jmo¹³jni ju³lah hno¹jni hŋiéng¹jni, jní² dsa² lán¹² jong¹² Diú¹³. Jmáh¹lah hi² jøng² báh³ lé² jmo¹³jni, hi² jái¹²jni ma²jmo¹² ti³ŋieh¹jni. Di³ hi² jøng² báh³ jmo¹²jni, ju³lah hi² jmo¹² ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Hniang¹ báh³ ti³ŋieh¹jni jní². Heh¹²dsa jní² ca¹lah¹jǿ¹ hi² jmo¹²dsa hŋiah¹²dsa. Jøng² heh¹dsa jní² juu¹² juøh¹² ué² hi³méh¹. Mi³jøng² li¹dsogh¹² hoh¹² hniah¹² na³ma²ca¹jmo¹jni lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jmo¹² báh³ ti³ŋieh¹jni hi² hiog² dsa² ma²ca¹dsan¹. Jø¹² bíh³ lah¹jøng² jmo¹²jni li¹chian² ju³ná³ hein² dsa² hiug² dsøa¹jni quianh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Héi¹ ju³ ti³ŋieh¹jni dsa² cán² jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Gug² tai¹ jní² báh³ ma²ca¹dsii¹dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mi³jøng² mi¹juanh¹² dsa² jmøi¹guǿi¹ jní², jní² dsa² lán¹² jong¹² Diú¹³, ju³lah mi²juanh¹²dsa ti³ŋieh¹jni. Ju³ná³ hein² dsa² tsa¹mi²juanh¹² jní², jong¹² Diú¹³, jø¹² bíh³ tsa¹mi²juanh¹² dsa² héi² ti³ŋieh¹jni, dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² ca¹nǿng² jǿg³ quieg¹ jní², jøng² hé²dsa jǿg³ quiah¹² ti³ŋieh¹jni, dsa² ca¹tsei¹ jní², dsa² héi² li¹chian² tiá² ja³cog² Diú¹³. Ha¹chi² dsag³ ma²rø²canh¹²dsa. Tsa¹ma¹ŋøa¹dsa juu¹² ja³dsián¹dsa. Ma²ŋøa¹²dsa juu¹² ja³li¹chian²dsa tiá² ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Lah¹dsóh² juǿi²jni hniah¹²: Ja¹quién¹ dsiég¹³ jmai³ ja³nang¹ dsa² tiogh³ juu¹² ja³dsián¹dsa jǿg³ quieg¹ jní². Ma²ca¹gog¹ báh³ jmai³. Jøng² ca¹lah¹já¹ dsa² hé² jǿg³ quieg¹ jní² li¹chian² tiá² ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chi² ju²bí² quiah¹² ti³ŋieh¹jni hi² li¹jmo¹dsa li¹chian² dsa² jmøi¹guǿi¹. Ju²bí² jøng² ca¹dsii¹dsa gug² tai¹ jní² calah, jní² dsa² lán¹² jong¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jø¹² bíh³ ca¹cuúh¹dsa jní² bí² hi² cán³jni jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Di³ ma²lán¹²jni dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tsa¹cánh³ hniah¹² gøg² jǿg³ jøng². Jií¹ báh³ jmai³ ja³nang¹ dsa² ma²ca¹dsan¹ jǿg³ juǿi³jni dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jøng² hiog¹dsa ca¹lah¹já¹dsa. Ju³lah dsa² ma²ca¹jmo¹ hi² dsio¹ ca¹lah¹cónh¹ jmai³ mi³chian²dsa jmøi¹guǿi¹, dsa² héi² li¹chian² tiá² ja³cog² Diú¹³. Ju³lah dsa² ma²ca¹jmo¹ hi² hlaih¹³, dsa² héi² ta¹canh¹³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Tsa¹lé² jmo¹³jni ca¹lah¹cónh¹ neng¹² dsøa¹jni hŋiéng¹jni. Cán²jni jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹ ca¹lah¹cónh¹ lǿa¹² jǿg³ ma²ca¹juúh² Diú¹³. Hi² jøng² cu²rø² mi²rǿ³jni jǿg³. Di³ hi² hno¹jni jǿg³ quiah¹² dsa² ca¹tsei¹ jní², a¹jáng¹ jǿg³ quieg¹jni hŋiéng¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tsa¹quien¹² jǿg³ quieg¹jni ju³ná³ ca¹tsǿh²jni jǿg³ dsøg¹² quieg¹jni hŋiéng¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Chian² báh³ jan² dsa² siáh², dsa² tsih¹ jǿg³ dsøg¹² quieg¹ jní². Ma²guiang³jni té¹² jǿg³ hi² tsih¹ dsa² héi² ja³cog²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ca¹ŋi³ŋøh³ hniah¹² Juan. Jøng² ca¹tsih¹ dsa² héi² jǿg³ dsøg¹² quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Cónh¹jøng² ha¹chi² chi³quian³jni jmai³ hi² tsih¹ dsa² jmøi¹guǿi¹ jǿg³ dsøg¹² ja³cog²jni. Cónh¹jøng² juǿi²jni hniah¹² jǿg³ jøng². Di³ hi² hno¹jni hi² liúgh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ca¹he¹ Juan jǿg³ ju³lah cøng² si² jmo¹² taih¹² ja³tiogh³ hniah¹². Jøng² hiug² hoh¹² hniah¹² ca¹tǿ² hoh¹² hniah¹² jǿg³ quiah¹²dsa cu²hna². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Di³ jøng² chian² báh³ dsa² juanh¹² cónh¹ jín³ Juan, dsa² tsih¹ jǿg³ dsøg¹² quieg¹jni. Di³ ma²jmo¹²jni juu¹² juøh¹² ca¹dsii¹ ti³ŋieh¹jni gug² tai¹jni. Juu¹² juøh¹² jøng² báh³ ma²mi²léi¹³ hi² lán¹²jni dsa² ca¹tse¹ ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ti³ŋieh¹jni héi², dsa² ca¹tsei¹ jní², ma²ca¹tsih¹ jǿg³ dsøg¹² ja³cog²jni. Hag³ dsa² héi² tsa¹ma²ca¹nengh² hniah¹². Tsa¹lǿih² jmai³ ma²ca¹janh³ hniah¹² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tsa¹chinh³ hniah¹² jǿg³ quiah¹² dsa² héi². Di³ tsa¹ca¹héh¹ hniah¹² jǿg³ quieg¹ jní², dsa² lán¹² dsa² ca¹tse¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ma²høh² hniah¹² si² quiah¹² Diú¹³. Di³ lë́h² hniah¹² jmo¹ jǿg³ jøng² hi² li¹chianh² hniah¹² tiá². Cónh¹jøng² jǿg³ dsøg¹² quieg¹ jní² báh³ rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jøng² tsa¹hnøngh² hniah¹² jǿg³ jøng² quieg¹ jní². Tsa¹hnøngh² hniah¹² cuǿ¹³jni hniah¹² hi² li¹chianh² hniah¹² tiá² ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ha¹chi² chi³quian³jni jmai³ hi² mi¹juanh¹² dsa² jmøi¹guǿi¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Cónh¹jøng² ma²guiang³jni he² løa¹ tsa¹hnøngh² hniah¹² jǿg³ quieg¹jni. Di³ tsa¹hnóh¹ hniah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ca¹guio¹jni ni³ huu¹³ hi² mi³ti³jni héh¹ ca¹jmo¹ ti³ŋieh¹jni. Cónh¹jøng² tsa¹hieh¹³ hniah¹² jní². Dsa² lah¹héi² báh³ hieh¹³ hniah¹², ju³ná³ hein² dsa² ca¹já¹, dsa² jmo¹ héh¹ quiah¹² hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ha² báh³ jmai³ héh² hniah¹² jǿg³ quieg¹ jní²? Di³ hnøngh² hniah¹² li¹chi² jǿg³ dsio¹ quiánh² hniah¹², hi² juúh² jmáh¹lah dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Ha¹chi² hi² lë́h² hniah¹² ju³ná³ tsa¹ca¹lø¹chí¹ jǿg³ dsio¹ ja³cogh² hniah¹², hi² juúh² Diú¹³, dsa² lán¹² Diú¹³ cu³hŋiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tsa¹ju³lë́h³ hniah¹² hi² cuøh¹³jni hniah¹² dsag³ ja³ta¹ni¹ ti³ŋieh¹jni. Lei¹³ quiah¹² hlai³ Moisés báh³ jmo¹ hi² ta¹canh¹³ hniah¹² dsag³, lei¹³ lë́h² hniah¹² hi² jmo¹ hi² liúgh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mi³héh³ hniah¹² jǿg³ quieg¹ jní² ju³ jøng² ca¹héh¹ hniah¹² jǿg³ quiah¹² hlai³ Moisés. Di³ jǿg³ quieg¹ jní² báh³ ca¹jmo¹ hlai³ Moisés. ");
INSERT INTO cpaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ca¹lah¹ca¹tǿ² jǿg³ quiah¹² hlai³ Moisés tsa¹héh² hniah¹². Hi² jøng² hiug¹² jín³ ué² hi² mi³héh³ hniah¹² jǿg³ quieg¹ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mi³ca¹løa¹ hi² jøng², ca¹ŋó¹ Jesús juu¹² tø¹hŋoh¹³ jmøi² Galilea, jmøi tøh²dsa Tiberias. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jue¹² dsa² ca¹ti¹dsë́² cah³dsa. Di³ ca¹jái¹ dsa² jue¹² juu¹² juøh¹² ca¹jmo¹ Jesús ja³cog² dsa² mi³ti³dsoh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jøng² ca¹uǿi² Jesús juu¹² máh². Ca¹guú²dsa ja³jøng² quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ja¹quién¹ jmai³ ta²høa³, jmai³ jmo¹² dsa² judío. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jøng² mi³ca¹jái¹ Jesús ma²ja¹lé² dsa² jue¹², ca¹juúh²dsa, ca¹tsáih¹dsa Felipe: ―¿Ha²lah jmó³ jniang³ hi² dsø³lie¹³ jniang³ hi² gǿh¹ dsa² jue¹²? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Lah¹jøng² ca¹juúh² Jesús. Di³ hi² cán²dsa jǿg³ dsøg¹² ha²lah juúh² Felipe. Ma²ŋi¹² báh³ Jesús ha²lah jmo¹dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jøng² ca¹juúh² Felipe: ―Ha¹chi² len¹² hŋí² ŋi¹lǿg² héh¹ cog³ hi³ŋíh¹ jin³ ma¹cu² jin³ hag³dsa tsa¹tan¹dsa ―ca¹juúh² Felipe. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jøng² ca¹juúh² jan² dsa² quián¹² Jesús tsen² Andrés, roh¹³ Simón Pedro: ");
INSERT INTO cpaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Tsenh¹² jan² tsih² dsa² ŋioh¹² ja³la². Quin¹²tsih hŋí² hi³ŋíh¹ lǿa¹² juu² cebada, quianh¹³ og¹ jáh² tiogh³ jmøi². Di³ tsa¹hliú² hi² jøng² quianh¹³ dsa² jue¹² ―ca¹juúh² Andres. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Jmo³ hi² tógh¹ dsa² jue¹² huø¹ ―ca¹juúh²dsa. Ja³jøng² mi³dsi¹³ ŋi²mah² tsíh². Jøng² ca¹túgh² dsa² jue¹². Mi³té¹² cónh¹ hŋí² mei¹³ dsa², jmah¹lah dsa² ŋioh¹². Tiogh³ calah jue¹² hio¹³ quianh¹³ tsih² guing². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jøng² ca¹can¹ Jesús hi³ŋíh¹. Ca¹tsáih¹dsa Diú¹³ di³hmah³. Jøng² ca¹dsiúh¹dsa hi³ŋíh¹ quiah¹² dsa² jue¹² mi³tiogh³. Jø¹² bíh³ lah¹jøng² ca¹jmo¹dsa quianh¹³ jáh² tiogh³ jmøi², ca¹lah¹ca¹lø¹tan¹³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mi³ma²na²lø¹tan¹³dsa, ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Gu²jiegh³ jø² ti³jneh³ ma²ca¹chiág¹. Jøng² tsa¹dsø¹hén² jin³ he² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mi³ca¹jiégh² jø², ca¹cangh¹² guie¹tǿn² møh²tá³, jneh³ hi³ŋíh¹, hi² ca¹chiág¹ quiah¹² hŋí² hi³ŋíh¹ jøng² hi² ca¹gǿh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mi³ca¹jái¹ dsa² jue¹² juu¹² juøh¹² jøng² ma²na²jmo¹ Jesús, jøng² ca¹juúh² dsa² héi²: ―Lah¹dsóh² dsa² ná¹² báh³ lán¹² dsa² hǿ² jøg³ quiah¹² Diú¹³ héi², dsa² rø²juúh² si² hi² jií¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jøng² ca¹lø¹lih¹³ Jesús hi² hniu¹ dsa² jue¹² jmo¹ hi² lén² Jesús rai¹³ quián¹²dsa. Hi² jøng² ca¹ŋó¹ Jesús calah juu¹² máh² cu²hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mi³ca¹neng², ca¹ŋi¹lé² dsa² quianh¹³ Jesús juu¹² chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ca¹túgh²dsa barco. Ca¹ŋi¹lé²dsa juu¹² jøa³juøi² Capernaum. Ma²neng² báh³ jøng². Ha¹chi² ma²na²guøn¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma²tsøg² jmøi². Di³ ma²hei¹² dsí² tí². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jøng² mi³ma²dsø²lé²dsa cónh¹ hŋí² jŋiéng² mei¹³ metro, ca¹jë́²dsa Jesús. Ma²dsiég¹² Jesús ma²quién¹², hi² ŋøa¹² Jesús juu¹² ni³ jmøi². Ca¹lø¹goh¹² dsa² tiogh³ niúh¹ barco. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jøng² ca¹juúh² Jesús: ―Jní² báh³ lang¹². ¡Tsa¹jmóh³ hniah¹² ganh¹! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jøng² ca¹lah¹hiug² dsǿa¹²dsa ca¹hie¹dsa Jesús niúh¹ barco. Dsø¹juu¹² jøng² ca¹dsi¹lé²dsa hŋoh¹³ ca²ton² jmøi², ja³mi³dsa¹lé²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mi³ca¹jni¹ jmai³ siíh³, jøng² ca¹ŋi¹jiag¹² dsǿa¹² dsa² ca¹jŋi¹ hŋoh¹³ jmøi² ca²ton². Lah¹la² ca¹ŋi¹jiag¹² dsǿa¹²dsa: Cøng² barco mi³he¹² chiuh³ jmøi². Ca¹ŋi¹lé² dsa² quianh¹³ Jesús niúh¹ barco jøng². Ha¹chi² ca¹ŋó¹ Jesús quianh¹³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jøng² ca¹dsi¹lé² hliú² barco juu¹² jøa³juøi² Tiberias. Ca¹dsi¹lé² barco jøng² cøg¹² ja³ca¹gǿh¹ dsa² jue¹² hi³ŋíh¹ mi³ma²ca¹tsáih¹ Jesús Diú¹³ di³hmah³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jøng² ca¹lø¹lih¹³ dsa² jue¹² hi² tsa¹chian² Jesús ma¹chian² ja³jøng², hi² tsa¹chian² dsa² quianh¹³dsa calah. Jøng² ca¹túgh²dsa barco ca¹dsi¹lé². Ca¹ŋi¹lé²dsa juu¹² Capernaum. Ca¹ŋi³hniah³dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jøng² mi³ca¹dsanh¹²dsa Jesús ca²ton² jmøi², ca¹juúh²dsa: ―¿Ha²lah ca¹jmoh³hning hi² ca¹hanh³hning jmøi², Tøa¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹²: A¹jáng¹ ju² hnangh¹² hniah¹² jní² huu¹³ juu¹² juøh¹² ca¹jmo¹jni. Hnangh¹² hniah¹² jní² huu¹³ hi³ŋíh¹ ca¹lø¹tanh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tsa¹ju³dsi³jiag¹² hoh¹² hniah¹² jmáh¹lah jǿg³ quiah¹² má¹ hi² cǿh³ hniah¹², hi² dsø¹hén². Hiug¹² jín³ hi² dsio¹ mi³dsa¹jiag¹² hoh¹² hniah¹² ha²lah li¹chianh² hniah¹² tiá² ja³cog² Diú¹³. Di³ chi² báh³ bí² quieg¹jni hi² jmo³jni li¹chianh² hniah¹² tiá², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi² jianh¹² hniah¹². Ma²ca¹mi³léi¹³ báh³ Jmi² jniang³ hi² ma²ca¹cuø¹dsa bí² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jøng² ca¹juúh² dsa² jue¹²: ―¿He² hniuh¹² hi² jmó³ jnieh³ hi² mi³ti³ jnieh³ hi² hniu¹ Diú¹³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jøng² ca¹juúh² Jesús: ―Lah¹la² hniuh¹² hi² jmóh³ hniah¹² hi² mi³tih³ hniah¹² hi² hniu¹ Diú¹³: Héh² hniah¹² jǿg³ quieg¹ jní², dsa² ca¹tse¹ Diú¹³ ni³ jmøi¹guǿi¹ la² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jøng² ca¹juúh² dsa² jue¹²: ―¿Nai¹² juu¹² juøh¹² jmóh³hning? Di³ jøng² hé³ báh³ jnieh³ jǿg³ quiánh²hning, na³ma²ca¹ne¹³ jnieh³ juu¹² juøh¹² jøng². ¿He² juu¹² juøh¹² jmóh³hning? ");
INSERT INTO cpaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ca¹gǿh¹ dsa² hóg¹ quián² jniang³ hi³ŋíh¹ tsen² maná jmai³ mi³ŋi²nio³dsa juu¹² ja³ha¹chian² dsa² tiogh³. Lah¹la² rø²juúh² si² quiah¹² Diú¹³: “Ca¹cuúh¹dsa dsa² hi³ŋíh¹ ca¹já¹ juu¹² guiuh¹³ hi² ca¹gǿh¹dsa,” rø²juúh² si² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jøng² ca¹juúh² Jesús calah: ―Lah¹dsóh² juøi²jni hniah¹²: Héi¹ ju³ hlai³ Moisés dsa² ca¹cuø¹ hi³ŋíh¹ jøng² ca¹já¹ juu¹² guiuh¹³. Hŋiah¹² báh³ ti³ŋieh¹jni ca¹cuø¹. Jø¹² bíh³ cuø¹ ti³ŋieh¹jni cøng² hi² lǿa¹² ju³lah lǿa¹² hi³ŋíh¹, hi² lah¹dsóh¹ jií¹ juu¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Di³ juu¹² ŋi¹juǿi¹ báh³ já¹² hi³ŋíh¹ hi² cuø¹² Diú¹³, hi² jmo¹ hi² li¹chianh² hniah¹² tiá² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jøng² ca¹juúh² dsa² jue¹²: ―Guiuh¹³, ca¹lah¹jǿ¹ jmai³ cuøh¹³hning jnieh³ hi³ŋíh¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jøng² ca¹juúh² Jesús: ―Jní² báh³ héi². Lán¹²jni ju³lah lǿa¹² hi³ŋíh¹ jmo¹ hi² li¹chianh² hniah¹² tiá². Ju³ná³ hein² dsa² jií¹, li¹quianh¹³ jní², lén² dsa² héi² ju³lah jan² dsa² tsa¹lǿih² jmai³ lé² tsa¹chi² hi² li¹gǿh¹dsa. Ju³ná³ hein² dsa² hé² jǿg³ quieg¹ jní², lén² dsa² héi² ju³lah jan² dsa² tsa¹lǿih² jmai³ lé² tsa¹chi² hi² li¹hǿnh²dsa. Di³ li¹chian²dsa ju²hiúg¹ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jøng² ma²na²juǿi²jni hniah¹²: Ma²ca¹jaih³ hniah¹² jní². Cónh¹jøng² tsa¹héh² hniah¹² jøg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ji¹lé² báh³ ja³cóg²jni ca¹lah¹já¹ dsa² ca¹cuan¹ Jmi² jniang³. Jøng² ha¹chi² tiúg¹³jni jin³ hein² dsa² ca¹já¹ ja³cog²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ha¹chi² ca¹guio¹jni juu¹² ŋi¹juǿi¹ ni³ huu¹³ hi² jmo³jni ju³lah hno¹jni hŋiéng¹jni. Ca¹guio¹jni. Mi³jøng² jmo³jni ju³lah hniu¹ dsa² ca¹tsei¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lah¹la² báh³ hniu¹ dsa² ca¹tsei¹ jní²: Hi² tsa¹cuø³jni jǿg³ dsa¹hén² jin³ hein² dsa² ca¹cuan¹dsa ja³cog²jni. Hniu¹dsa hi² jmo³jni hi² hiog¹ ca¹lah¹já¹ dsa² héi² na³ma²ca¹tóh² jø² jmai³ quiah¹² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Lah¹jøng² báh³ hniu¹ ti³ŋieh¹jni. Hniu¹dsa hi² li¹chian² tiá² ca¹lah¹já¹ dsa² ca¹hé¹ jøg³ hi² lán¹²jni jong¹² Diú¹³. Jøng² jmo³jni hi² hiog¹ dsa² héi² na³ma²ca¹tóh² jø² jmai³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mi³ca¹nǿng² dsa² judío jǿg³ jøng², hlaih¹³ ca¹hia¹dsa Jesús. Tsa¹tøa¹² dsǿa¹²dsa jǿg³ ca¹juúh² Jesús, hi² lán¹²dsa ju³lah lǿa¹² hi³ŋíh¹ ca¹já¹ juu¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ca¹juúh² dsa² héi²: ―Jesús báh³ ná¹², ja³ŋiúh³ José. Cue¹² báh³ jniang³ chiég³ jmi²dsa. ¿He² løa¹ juúh²dsa ca¹já¹dsa juu¹² ŋi¹juǿi¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jøng² ca¹juúh² Jesús: ―Tsa¹ma¹dsiíh³ hniah¹² jǿg³ ná¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jmi² jniang³ báh³ dsa² ca¹tsei¹ jní². Ha¹chian² dsa² lé² jií¹ ja³cog² jní² ju³ná³ tsa¹jmo¹ Jmi² jniang³ hi² jií¹dsa. Jøng² jmo³jni hi² hiog¹ dsa² héi², dsa² ca¹u¹lé², na³ma²ca¹tóh² jø² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lah¹la² rø²juúh² si² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: “Mi¹tán¹² Diú¹³ ca¹lah¹já¹dsa,” rø²juúh² si². Hi² jøng² ja²lé²dsa ja³cog²jni, ju³lah ca¹lah¹já¹ dsa² ca¹nǿng² jǿg³ quiah¹² Jmi² jniang³, dsa² ca¹mi¹tan¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Di³ a¹jáng¹ lah¹jøng² hi² chian² dsa² ma²ca¹jë́² Jmi² jniang³. Jan² jní² báh³ dsa² ca¹jan³dsa, jní² dsa² ca¹tsei¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² hé² jǿg³ quieg¹ jní², li¹chian² dsa² héi² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jní² báh³ dsa² lán¹² ju³lah lǿa¹² hi³ŋíh¹ jmo¹ hi² li¹chianh² hniah¹² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ca¹gǿh¹ dsa² hóg¹ quiánh² hniah¹² hi³ŋíh¹ tsen² maná juu¹² ja³tsa¹chian² dsa² tiogh³. Cónh¹jøng² ca¹dsan¹ báh³ dsa² mi³ca¹tǿ² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jøng² lah¹la² báh³ lǿa¹² hi³ŋíh¹ hi² lah¹dsóh² já¹² juu¹² ŋi¹juǿi¹: Hi² ha¹chi² ma¹dsan² dsa² ca¹gǿh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jní² báh³ lán¹² ju³lah lǿa¹² hi³ŋíh¹ ca¹já¹ juu¹² ŋi¹juǿi¹, hi² jmo¹ li¹chianh² hniah¹² tiá². Ju³ná³ hein² dsa² ca¹gǿh¹ hi³ŋíh¹ jøng², li¹chian² dsa² héi² jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹. Jmø²ŋǿ¹² quieg¹ báh³ jní² ma²lǿa¹² hi³ŋíh¹ hi² cuø³jni. Di³ hi² jón²jni. Mi³jøng² li¹chian² dsa² jmøi¹guǿi¹ tiá² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mi³ca¹nǿng² dsa² canh¹³ quián¹² dsa² judío jǿg³ ca¹juúh² Jesús, ca¹dsii¹dsa jǿg³ cu³guiog³dsa. Ca¹juúh²dsa: ―¿Ha²lah lé² cuø¹ dsa² ná¹² jmø²ŋǿ¹² quiah¹² hi² quie¹³ jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jøng² ca¹juúh² Jesús: ―Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ tsa¹cøgh²hǿgh³ hniah¹² jmø²ŋǿ¹² quieg¹ jní², dsa² ma²lán¹² dsa² jmǿi¹guǿi¹ jianh¹² hniah¹², tsa¹li¹chi² bí² quiánh² hniah¹² hi² li¹chianh² hniah¹² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dsa² héi² báh³ dsa² li¹chian² tiá², dsa² cøh²hǿnh² jmø²ŋǿ¹² quieg¹jni. Jmo³jni hi² hiog¹dsa na³ma²ca¹tóh² jø² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Di³ lah¹dsóh² cuø¹ bí² jmø³ŋø³jni quiah¹² dsa² cøh²hǿnh². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dsa² ma²quianh¹³jni dsa² cøh²hǿnh² jmø³ŋø³jni. Ma²quianh¹³dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Dsa² chian² báh³ Jmi² jniang³, dsa² ca¹tsei¹ jní². Hi² jøng² báh³ chian² jní² calah. Jø¹² bíh³ lah¹jøng² li¹chian² dsa² cøh²hǿnh² jmø³ŋø³jni, ni³ huu¹³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lán¹²jni ju³lah lǿa¹² hi³ŋíh¹ ca¹já¹ juu¹² ŋi¹juǿi¹. Tsa¹lǿa¹² quieg¹jni ju³lah hi³ŋíh¹ ca¹gǿh¹ dsa² hóg¹, dsa² ca¹dsan¹. Di³ ju³ná³ hein² dsa² ca¹cø² ca¹hǿnh¹ jmø³ŋø³jni, dsa² héi² li¹chian² jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ca¹he¹ Jesús jǿg³ jøng² dsi²néi² guøh¹² tsih¹² jøa³juøi² Capernaum. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mi³ca¹nǿng² dsa² quianh¹³ Jesús ca¹lah¹jǿ¹ jǿg³ jøng², jue¹² dsa² héi² ca¹juúh²: ―Úe² báh³ lǿa¹² jǿg³ juúh² dsa² ná¹² quianh¹³ jniang³. Tsa¹tiúh¹ jniang³ mi³ti³ jniang³ ca¹lah¹cónh¹ lǿa¹² jǿg³ ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jøng² ca¹lø¹lih¹³ Jesús ha²lah lǿa¹² jǿg³ ti³dsii¹²dsa cu³guiog³dsa. Jøng² ca¹tsáih¹ Jesús dsa² héi²: ―¿Tsa³tøa¹² hoh¹² hniah¹² jǿg³ ná¹²? ");
INSERT INTO cpaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ho¹ hiug¹² jín³ tsa¹tøa¹² hoh¹² hniah¹² lé² ju³ná³ ca¹jaih³ hniah¹² jní², hi² ma²neh¹³jni juu¹² ŋi¹juǿi¹, jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jmi²dsí² quián² báh³ jniang³ cuø¹² bí² hi² ŋi³niang³ jniang³. A¹jáng¹ hi² chi² bí² cuø¹ jmø²ŋǿ¹². Lǿa¹² ca¹lah¹jǿ¹ jǿg³ ma²ca¹juǿi²jni hniah¹² ju³lah lǿa¹² jmi²dsí². Di³ cuø¹² bí² jǿg³ ha²lah ŋi³niang³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Cónh¹jøng² tiog¹³ báh³ chian² ca²dsiogh³ hniah¹² tsa¹héh² hniah¹² jǿg³ quieg¹jni ―ca¹juúh²dsa. Di³ ma²ŋi¹² báh³ Jesús lah¹jiá¹² hein² dsa² tsa¹hé² jǿg³ quiah¹²dsa, hein² dsa² hnai¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jøng² ca¹juúh² Jesús: ―Hi² jøng² ma²ca¹juǿi²jni hniah¹²: Ha¹chian² dsa² lé² jií¹ ja³cog²jni ju³ná³ tsa¹cuø¹ Jmi² jniang³ hi² jií¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ni³ jøng² ca¹tég² jue¹² dsa² mi³ŋi²nio³ quianh¹³ Jesús. Ha¹chi² ma²ca¹ŋi³nio³dsa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² guia¹tón²: ―¿Jø³ hi² tegh¹³ hniah¹² jní² calah? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jøng² ca¹juúh² Simón Pedro: ―Juu¹³ jniang³, ¿nai¹² dsa² siáh² li¹dsǿg³ jnieh³ quianh¹³? Quiánh² hning² báh³ chi² jǿg³ jmo¹ hi² li¹chian² jnieh³ tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma²ca¹hé³ jnieh³ jǿg³ quiánh² hning². Ma²ne³ jnieh³ hi² lanh¹² hning² dsa² han¹³ quián¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jøng² ca¹juúh² Jesús: ―Jní² báh³ dsa² ca¹hia¹ guia¹tónh² hniah¹². Cónh¹jøng² jan² hniah¹² lán¹² dsa² quianh¹³ dsa² hlanh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ca¹juúh² Jesús jǿg³ jøng², hi² hia¹²dsa Judas, ja³ŋiúh³ Simón Iscariote. Di³ jan² dsa² guia¹tón² héi² hnë¹ Jesús jmai³ chi³quë́¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ni³ jøng² ca¹ŋøa¹ Jesús juu¹² ja³tén¹² Galilea. Tsa¹ma¹hniu¹dsa ŋøa¹dsa juu¹² ja³tén¹² Judea. Di³ hniu¹ dsa² chian² Judea jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jøng² ja¹quién¹ tøa¹ jmai³ juøh¹² quiah¹² dsa² judío, jmai³ jmo¹²dsa hio¹² tiogh³dsa ta³lah¹jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jøng² ca¹juúh² ju³roh¹³ Jesús: ―Tsa¹janh³hning ja³la². Dsǿg³ báh³ jniang³ jmai³ tøa¹ juu¹² Judea. Di³ jøng² jái¹ dsa² quiánh²hning tiogh³ ja³jøng² ha²lah jmoh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ju³ná³ hein² dsa² hniu¹ li¹cuai¹² dsa², tsa¹hniuh¹² jmo¹dsa ja³chi³hma¹ jǿg³. Hniuh¹² jmóh³hning juu¹² juøh¹² ja³ta¹ni¹ dsa² jue¹², chi²júh² lah¹dsóh² tëh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lah¹jøng² ca¹juúh²dsa. Di³ ca¹lah¹jin³ ju³roh¹³ Jesús tsa¹hé² jǿg³ hi² lán¹²dsa Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jøng² ca¹juúh² Jesús: ―Ha¹chi² ma²ca¹tǿ² jmai³ ja³nei³jni. Di³ dsio¹ báh³ quiánh² hniah¹² gu³noh¹² hniah¹² jmai³ ja³hiug² hoh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tsa¹lé² li¹hian¹³ dsa² jmøi¹guǿi¹ hniah¹². Jan² jní² báh³ hiag¹³dsa. Di³ juǿi²jni dsa² hi² jmo¹²dsa hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gu³noh¹² hniah¹² jmai³. Ha¹chi² nei³jni. Di³ tsa¹ma²tǿ² jmai³ ja³nei³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jøng² ca¹jŋi¹ Jesús juu¹² Galilea mi³ma²ŋi¹lé² ju³roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jøng² ca¹ŋó¹ Jesús chi²quë́¹ ja³neng¹² jmai³ cónh¹ jín³ ju³roh¹³dsa. Ca¹ŋó¹dsa cónh¹ tsa¹léi¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jøng² ca¹hnah¹² dsa² canh¹³ quián¹² dsa² judío Jesús ja³neng¹² jmai³. Ni³dsii¹²dsa jǿg³ guiog³dsa. Juúh²dsa: ―¿Ha² bíh³ tøah¹ hiúg³ Jesús? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jue¹² dsa² ni³dsii¹² jǿg³ hi² chi³hia¹²dsa Jesús. Ca²dsiog³dsa ca¹juúh²: ―Dsa² dsiog¹ báh³ héi² ―ca¹juúh²dsa. Ca²dsiog³dsa ca¹juúh²: ―Dsa² hlanh³ báh³ héi². Di³ mi²ju³ mi²gan¹²dsa dsa² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ca¹lah¹jin³ jan² dsa² héi² tsa¹ca¹juúh² chi³na¹ jǿg³ tø¹lah¹jag¹³ quiah¹² Jesús. Di³ gan¹dsa dsa² canh¹³ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma²dság¹² ton¹dsoh¹³ jmai³ quiah¹² dsa² judío, mi³ca¹hí¹ Jesús ja³tsih¹³ guøh¹² juøh¹². Ca¹heh¹dsa dsa² tiogh³ ja³jøng² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ca¹can¹ dsa² canh¹³ gøg² jǿg³ ca¹juúh² Jesús. Jøng² ca¹juúh² dsa² canh¹³: ―¿Ha²lah ca¹jmo¹ dsa² ná¹² ŋi¹²dsa ma¹dsio¹² jǿg³? Ha¹chi² si² ma¹dsio¹² ca¹hǿ²dsa ju³lah ca¹hí³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jøng² ca¹juúh² Jesús: ―A¹jáng¹ ju³ hi² he¹²jni jǿg³ quieg¹ hŋiéng¹jni. He¹²jni jǿg³ quiah¹² dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ju³ná³ chian² dsa² hiug² dsǿa¹² jmo¹ hi² hniu¹ Diú¹³, li¹lih¹³ dsa² héi² chi²júh² lah¹dsóh² he¹²jni jǿg³ quiah¹² Diú¹³, ho¹ ju³ hi² he¹²jni jǿg³ hi² ca¹hnángh¹jni dsøa¹ hŋiéng¹ báh³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dsa² hniu¹ mi³juanh¹³ guiog¹³ báh² dsa² he¹² jǿg³ quiah¹² guiog³dsa. Cónh¹jøng² té¹² báh³ jǿg³ quiah¹² dsa² hniu¹ li¹juanh¹² dsa² ca¹tsei¹. Ha¹chi² ta³júg³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Tsa³dsøg¹² ca¹cuúh¹ hlai³ Moisés hniah¹² lei¹³? cónh¹jøng² ha¹chi² mi²tih³ hniah¹² cónh¹ lǿa¹² lei¹³ jøng². ¿He² løa¹ hnøngh² hniah¹² jŋë́h³ hniah¹² jní²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jøng² ca¹juúh² dsa² tiogh³ ja³jøng²: ―Dsa² ŋah¹² báh³ hning². Ha¹chian² dsa² hniu¹ jŋëh¹ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jøng² ca¹juúh² Jesús: ―Ca¹lah¹jáh¹ hniah¹² ca¹quinh² gøg². Di³ ca¹jmo¹jni cøng² juu¹² juøh¹² jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hlai³ Moisés ca¹quieg² jøg³ hi³ jmo¹dsa circuncisión quiah¹² ca¹lah¹já¹ guing² dsa² ŋioh¹² cónh¹ ma¹jŋi¹ jmai³ chian² guing². Di³ héi¹ hlai³ Moisés dsa² ca¹mi¹liág¹ jǿg³ jøng². Hi² ca¹mi¹liág¹ dsa² hóg¹ quián¹² báh³ Moisés. Hi² jøng² báh³ jmoh² hniah¹² circuncisión quiah¹² guing² jmai³ sa³¹, ju³ná³ ca¹tǿ² jmai³ sa³¹ hi² ca¹lø¹chián¹guing. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jmoh² hniah¹² lah¹jøng² jmai³ sa³¹, mi³jøng² tsa¹dsø¹hén² lei¹³ quiah¹² hlai³ Moisés. ¿He² løa¹ hneh² hniah¹² quianh¹³jni jøng², ju³ná³ ca¹mi³hliú³jni jan² dsa² dsoh³ jmai³ sa³¹? ");
INSERT INTO cpaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tsa¹cuøh¹³ hniah¹² dsa² dsag³ ju³ná³ tsa¹ŋih³ hniah¹² cu²rø² ha²lah jmo¹dsa. Dsio¹ báh³ cánh³ hniah¹² ni¹jiá¹ jǿg³ dsøg¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hi² jøng² lah¹la² ca¹juúh² ca²dsiog³ dsa² chian² Jerusalén: ―¿A³¹jáng¹ ju³ dsa² ná¹² hniu¹ dsa² canh¹³ jŋëh¹? ");
INSERT INTO cpaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ja³la² báh³ ma²hiúg³dsa. Dsii¹²dsa jǿg³ ja³ta¹ni¹ dsa² jue¹². Jin³ hein² dsa² tsa¹jín³ hlaih¹ quiah¹²dsa. Lǿa¹² jǿg³ hi² hé² dsa² ta³ jǿg³ hi² lán¹² dsa² ná¹² Cristo, dsa² ca¹tse¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Di³ ne³ báh³ jniang³ ha² juu¹² ca¹já¹ dsa² ná¹². Na³ma²tǿ² ja³jií¹ Cristo, jin³ jan² dsa² tsa¹ŋi¹² ha² juu¹² ja³jií¹dsa ―ca¹juúh² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hi² jøng² lah¹la² ca¹juúh² Jesús ja³tsih¹³ guøh¹²: ―Cuaih¹² báh³ hniah¹² jní². Ŋih³ báh³ hniah¹² ha² tøah¹ ca¹guio¹jni. Di³ a¹jáng¹ ju³ hi² ca¹guio¹ cónh¹ të² hŋiéng¹jni. Lah¹dsóh² báh³ chian² dsa² ca¹tsei¹ jní². Ha¹chi² cueh¹² hniah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jní² báh³ cué¹² dsa² héi². Di³ ca¹guio¹jni ja³guǿ¹³dsa. Dsa² héi² ca¹tsei¹ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jøng² hniu¹ dsa² tiogh³ ja³jøng² mi³chiánh²dsa Jesús. Jin³ jan² dsa² tsa¹ca¹tí² dsǿa¹² chiángh². Di³ tsa¹ma²tǿ² jmai³ ja³cuø¹ Diú¹³ jǿg³ hi² chiánh²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cónh¹jøng² jue¹² dsa² ca¹hé¹ jǿg³ quiah¹² Jesús. Jøng² ca¹juúh² dsa² héi²: ―Ha¹chian² dsa² siáh² tiúh¹ jmo¹ ma¹dsio¹² juu¹² juøh¹² ju³lah jmo¹² dsa² ná¹². Lán¹² báh³ dsa² ná¹² Cristo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ca¹nǿng² dsa² fariseo jǿg³ ti³dsii¹² dsa² jue¹², hi² hia¹²dsa Jesús. Jøng² ca¹jmo¹ dsa² fariseo jǿg³ quianh¹³ juu¹³ jmi²dsa². Mi³jøng² ca¹tse¹dsa tsih² dsa² ta³, dsa² mi³dsa¹chiánh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jøng² ca¹juúh² Jesús: ―Mih² báh³ jø² hei¹² hiúg³jni quianh¹³ hniah¹². Jøng² jín³ ma²neh¹³jni juu¹² ja³guǿ¹³ dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jmai³ jøng² hnangh¹³ hniah¹² jní². Di³ ha¹chi² dsiagh¹³ hniah¹² jní². Tsa¹lé² gu³noh¹² hniah¹² juu¹² ja³neh¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ca¹qui² ca¹ŋai¹ dsa² canh¹³ roh¹³. Ca¹juúh²dsa: ―¿Ha² bíh³ tøah¹ dsánh¹ dsa² ná¹² ja³tsa¹ma¹dsianh¹³ jniang³ dsa²? ¿Ho¹ ju³ dsánh¹dsa ja³ti² ja³hiúg³ dsa² go² jniang³ go² dsa² siáh², ja³tiogh³ dsa² hløah¹² jǿg³ griego? ¿Mi³jøng² dsa¹heh¹²dsa dsa² héi² jǿg³? ");
INSERT INTO cpaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿He² hniu¹dsa juúh²dsa jǿg³ hi² hniah¹³ jniang³ dsa², jøng² tsa¹dsianh¹³ jniang³ dsa²? ¿He² hniu¹dsa juúh²dsa hi² tsa¹lé² ŋi³niang³ jniang³ juu¹² ja³dsánh¹dsa? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jøng² ti³juøh¹² jmai³ ja³dsián¹ jmai³ quiah¹² dsa² judío, ca¹nung² Jesús. Ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―Ju³ná³ hein² hniah¹² tsa¹dsanh¹² quianh¹³ hi² li¹hiug² hoh¹² hniah¹², ju³ ja¹noh¹² hniah¹² ja³cog² jní². Jøng² cuǿ¹³jni hniah¹² ju²hiúg¹ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lé² quiah¹² dsa² hé² jǿg³ quieg¹jni, ju³lah lǿa¹² jǿg³ la² rø²juúh² si² quiah¹² Diú¹³: “Ma¹dsio¹² hlaih¹³ ju²hiúg¹ dsøa¹² cuúh¹dsa dsa² jue¹²,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lah¹jøng² ca¹juúh² Jesús, hi² hniu¹dsa juúh²dsa jǿg³ quiah¹² jmi²dsí² han¹³ cán² dsa² hé² jǿg³ quiah¹²dsa. Hei¹² hi³méh¹ cán²dsa jmi²dsí² han¹³ jmai³ jøng². Di³ ha¹chi² ma²ca¹ŋáh¹ Jesús juu¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mi³ma²na¹nǿng² dsa² jue¹² jǿg³ jøng² quiah¹² Jesús, ca²dsiog³ dsa² ca¹juúh²: ―Lah¹dsóh² báh³ lán¹² dsa² ná¹² dsa² hǿ² jǿg³ quiah¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jø¹² bíh³ ca¹juúh² ca²dsiog³dsa: ―Cristo lah¹dsóh² báh³ ná¹² ―ca¹juúh²dsa. Jøng² ca¹juúh² ca²dsiog³dsa: ―Ha¹chi² lén² Cristo dsa² chian² Galilea. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lah¹la² rø²juúh² si²: Tsø³jong¹³ hlai³ David báh³ dsa² lén² Cristo. Li¹chian²dsa jøa³juøi² Belén, go² hlai³ David ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hi² jøng² ca¹túgh² dsa² jue¹² ma¹quién¹ ni³ huu¹³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ca²dsiog³dsa mi³hniu¹ mi³chiánh²dsa Jesús. Di³ ha¹chi² ca¹tí² dsǿa¹²dsa chiángh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ca¹ŋi¹lia¹ tsih² dsa² ta³ juu¹² ja³tiogh³ juu¹³ jmi²dsa² ca¹lah¹quianh¹³ dsa² fariseo. Jøng² ca¹ŋǿh¹ dsa² héi² tsih² dsa² ta³: ―¿He² løa¹ tsa¹na²teih¹³ hniah¹² Jesús? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jøng² ca¹juúh² tsih² dsa² ta³: ―Ca¹lah¹jin³ cøng² jmai³ tsa¹ma²ca¹néng³ jnieh³ jǿg³ dsio¹ ju³lah jǿg³ juúh² dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jøng² ca¹juúh² dsa² fariseo, ca¹tsáih¹dsa tsih² dsa² ta³: ―¿Jø¹² bíh³ ma²na²héh¹ hniah¹² jǿg³ mi²gag¹² dsa² héi² liáh³? ");
INSERT INTO cpaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jin³ jan² dsa² ta³ quián¹² guøh¹² quián² jniang³ ca¹lah¹quianh¹³ dsa² fariseo tsa¹ma²ca¹hé¹ jǿg³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jmáh¹lah dsa² héi² báh³ hé² jǿg³ quiah¹² Jesús, dsa² tsa¹cuuh¹² lei¹³ quiah¹² Diú¹³. Dsa² ti³re² dsag³ báh³ héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ja³jøng² hiúg³ jan² dsa² fariseo tsen² Nicodemo, dsa² ma²ca¹ŋie³ ca¹ŋi³dsii¹ jǿg³ quianh¹³ Jesús cøng² ja³neng². Jøng² ca¹juúh² dsa² héi²: ");
INSERT INTO cpaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ha¹chi² lǿa¹² lei¹³ quián² jniang³ lah¹jøng², hi² cuǿ¹³ jniang³ dsa² dsag³ niúh¹ jín³ hi² cuø¹dsa jǿg³ dsøg¹² quiah¹²dsa ha²lah ma²jmo¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jøng² ca¹juúh² dsa² fariseo jian¹²dsa: ―¿Ho¹ ju³ hning² lanh¹² dsa² chian² Galilea calah liáh³? Hí² di³ si² quiah¹² Diú¹³ cu²rø². Di³ jøng² li¹ŋih³hning jin³ jan² dsa² hǿ² jǿg³ quiah¹² Diú¹³ tsa¹ma²ca¹lø¹chián¹ juu¹² ja³tén¹² Galilea ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jøng² ca¹ŋi¹lia¹ dsa² fariseo juu¹² ja³quiah¹³dsa, lah¹jan² lah¹jan²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ca¹ŋó¹ Jesús juu¹² máh² tsen² Olivo. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mi³ca¹jni¹ jøng² ca¹ŋó¹ Jesús calah juu¹² ja³tsih¹³ guøh¹² juøh¹². Jøng² ca¹ŋëh² dsa² jue¹² ja³ta¹ni¹dsa. Jøng² ca¹guú² Jesús, Ca¹heh¹dsa dsa² jue¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jøng² ca¹jian¹ tøa¹² he¹² lei¹³ quiah¹² Diú¹³ ca¹lah¹quianh¹³ dsa² fariseo jan² hio¹³ ja³ta¹ni¹ Jesús. Ma²na²dsanh¹²dsa hio¹³ ja³mi³dsii¹²dsa jǿg³ quianh¹³ dsa² ŋioh¹². Jøng² ca¹tsenh¹dsa hio¹³ héi² jøa³ ja³tiogh³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jøng² ca¹juúh² dsa² ca¹jiag¹, ca¹tsáih¹dsa Jesús: ―Tøa¹², ma²na²dsanh¹³ jnieh³ hio¹³ lang¹², dsii¹²dsa jǿg³ quianh¹³ dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Rø²juúh² lei¹³ quiah¹² hlai³ Moisés hi² hniuh¹² qui³tog³ jniang³ dsa² jmo¹² lah¹jøng² cang³ ca¹lah¹ca¹jon¹dsa. ¿He² juúh²hning hŋiah¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ta³dsǿa¹²dsa ca¹juúh²dsa lah¹jøng². Di³ hi² hniu¹dsa cán²dsa jǿg³ dsøg¹² quiah¹² Jesús. Hnangh¹²dsa mai³¹ ha²lah mi³cuúh¹dsa Jesús dsag³. Jøng² ca¹guú² Jesús chi³jë́³dsa. Ca¹tsø² ca¹niúh²dsa nih¹³ chi³gog¹dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cøng² hi² ca¹ŋǿh¹dsa Jesús ha²lah jmo¹dsa quianh¹³ hio¹³ héi². Jøng² ca¹nung² Jesús. Ca¹juúh²dsa: ―Ju³ná³ hein² dsa² quianh¹³ hniah¹² ha¹chi² hi² hlaih¹³ ma²ca¹jmo¹dsa, dsa² héi² lah¹ni³ quiúh¹ cang³ quiah¹² hio¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jøng² ca¹jmo¹ Jesús calah chi³jë́³dsa. Ca¹tsø² ca¹niúh²dsa calah nih¹³ chi³gog¹dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mi³ca¹nǿng² dsa² héi² jǿg³ jøng², ca¹huan²dsa ta¹ma¹jan¹dsa. Dsa² ma²guiuh¹³ ca¹u¹hái¹ lah¹ni³. Coh¹³ jøng² ca¹ti¹dsë́² ca¹lah¹já¹dsa. Jan² hio¹³ héi² báh³ tsenh¹² quianh¹³ Jesús ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jøng² ca¹chiágh¹ Jesús ni³. Ca¹juúh²dsa, ca¹tsáih¹dsa hio¹³: ―¿Nai¹² dsa² héi², hio¹³, dsa² cuøh¹² hning² dsag³? ¿Tsa³ma¹cuø¹ jin³ jan² dsa² dsag³ quiánh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jøng² ca¹juúh² hio¹³: ―Jin³ jan² dsa² tsa¹ma¹cuø¹ dsag³, guiuh¹³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Jø¹² bíh³ jní², tsa¹cuǿ¹³jni hning² dsag³. Lé² báh³ guǿnh³hning. Jøng² tsa¹ma¹jmóh³hning hi² hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jøng² ca¹juúh² calah Jesús: ―Lán¹²jni ju³lah lǿa¹² cøng² si² jmo¹² taih¹² jmøi¹guǿi¹. Tsa¹lé² neng² juu¹² quiah¹² dsa² ŋi²nio³ dsen¹³ cah¹jni. Li¹taih¹² juu¹² ja³dsø¹lé² dsa² héi², juu¹² ja³li¹chian²dsa tiá² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jøng² ca¹juúh² dsa² fariseo: ―Hŋiah¹ báh³ hning² ma²juúh² jǿg³ dsio¹ quiánh²hning. Ha¹chi² quien¹² jǿg³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jøng² ca¹juúh² Jesús: ―Ju³ he² jín³ jní² juøh¹³ jǿg³ dsio¹ quieg¹jni, quien¹² báh³ jǿg³. Di³ ma²guiang³jni ha² juu¹² ja³ca¹guio¹jni. Jø¹² bíh³ guiang³jni ha² juu¹² ja³neh¹³jni. Di³ ha¹chi² ŋih³ hniah¹² ha² juu¹² ja³ca¹guio¹jni, ha² juu¹² ja³neh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Cuøh¹³ hniah¹² dsa² dsag³ ju³lah lǿa¹² mai³¹ hlaih¹³ quiah¹² dsa² jmøi¹guǿi¹. Ha¹chian² dsa² cuǿ¹²jni dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cónh¹jøng² quien¹² báh³ jǿg³ quieg¹jni, ju³ná³ ca¹cuǿ¹jni dsa² dsag³. Di³ a¹jáng¹ cu²hŋiéng¹ báh³ jní² cuǿ¹³jni dsa² dsag³. Quianh¹³ báh³ jní² dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Rø²juúh² lei¹³ quiánh² hniah¹² hi² quien¹² jǿg³ ju³ná³ ca¹cuø¹ og¹ dsa² jǿg³ dsøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jøng² jní² cuø¹² jǿg³ dsøg¹² quieg¹jni hŋiéng¹jni. Jøng² cuø¹² calah ti³ŋieh¹jni jǿg³ dsøg¹² quieg¹jni, dsa² ca¹tsei¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jøng² ca¹juúh² dsa² fariseo: ―¿Nai¹² ti³ŋieih¹²hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Tsa¹cuaih¹² hniah¹² jní² quianh¹³ ti³ŋieh¹jni. Ju³ jmai³ hi² cuaih¹² hniah¹² jní², jø¹² bíh³ ma²cueh¹² hniah¹² ti³ŋieh¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ca¹juúh² Jesús jǿg³ jøng² ja³hiúg³dsa heh¹²dsa dsa² jǿg³ ja³tsih¹³ guøh¹² juøh¹², cøg¹² ja³tioh¹³ gog¹² tóh² dsa² dsa²lé² guøh¹² ŋi³néng². Ha¹chian² dsa² ca¹chiánh² Jesús. Di³ tsa¹ma²tǿ² jmai³ ja³chiángh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jøng² ca¹juúh² Jesús calah, ca¹tsáih¹dsa dsa² canh¹³ quián¹² dsa² judío: ―Dsa² neh¹³ báh³ jní². Jøng² hnangh¹³ hniah¹² jní². Di³ ha¹chi² dsiagh¹³ hniah¹² jní². Dsiánh¹ báh³ hniah¹². Di³ ha¹chi² dsø¹hén² dsag³ quiánh² hniah¹². Tsa¹lé² gu³noh¹² hniah¹² juu¹² ja³neh¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jøng² ca¹dsii¹ dsa² canh¹³ jǿg³ cu³guiog³dsa. Ca¹juúh²dsa: ―Lah¹cøng² hi² jŋëh¹dsa hŋiah¹² báh³ dsa². Di³ juúh²dsa hi² tsa¹lé² dsǿg³ jniang³ juu¹² ja³dsánh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jøng² ca¹juúh² Jesús: ―Dsa² chian² ni³ jmøi¹guǿi¹ la² báh³ hniah¹². Héi¹ ju³ dsa² lah¹héi² báh³ jní². Dsa² ca¹guio¹ juu¹² guiuh¹³ báh³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hi² jøng² na²juǿi²jni hniah¹² hi² dsiánh¹ hniah¹². Di³ ha¹chi² dsø¹hén² dsag³ quiánh² hniah¹², ju³ná³ tsa¹héh² hniah¹² jǿg³ hi² lán¹²jni dsa² ca¹tse¹ Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jøng² ca¹juúh² dsa² canh¹³: ―¿Hein² dsa² lanh¹²hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Ca¹juǿi²jni hniah¹² cónh¹ jmai³ lah¹ni³ hein² dsa² lán¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ma¹dsio¹² jǿg³ chi² li¹juǿi³jni hniah¹² hi² ti³reh² hniah¹² dsag³. Ha¹chi² lǿa¹² tsa¹tøa¹² hoh¹² hniah¹² jǿg³ jøng². Di³ tiog¹³ báh³ dsøg¹² jǿg³ quiah¹² dsa² ca¹tsei¹ jní². Jǿg³ ma²ca¹nang¹jni juúh² dsa² héi² báh³ hǿa¹³jni ni³ jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jøng² tsa¹ca¹lø¹ŋë́² dsa² canh¹³ hi² hia¹² Jesús Jmi² jniang³, dsa² ca¹tsei¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hi² jøng² ca¹juúh² Jesús: ―Na³ma²ca¹chiagh³ hniah¹² jní² juu¹² guiuh¹³, jøng² li¹ŋih³ hniah¹² hein² dsa² lán¹² jní², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Li¹ŋih³ hniah¹² calah hi² jmo³jni jmáh¹lah hi² ma²ca¹he¹ ti³ŋieh¹jni, hi² ha¹chi² jmo³jni ju³lah të² jní² hŋiéng¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Di³ dsa² quianh¹³ báh³ jní² dsa² ca¹tsei¹jni. Ha¹chi² ma²ca¹tiáng²dsa cu²hŋiéng¹jni. Di³ tiog¹³ báh³ jmo³jni jmáh¹lah hi² tøa¹² dsǿa¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mi³ca¹juúh² Jesús jǿg³ jøng², jue¹² dsa² ca¹hé¹ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa dsa² judío, ju³lah dsa² ma²hé² jǿg³ quiah¹²dsa: ―Lénh² hniah¹² dsa² quian¹jni lah¹dsóh², ju³ná³ cøng² hi² chinh³ hniah¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Li¹ŋih³ hniah¹² ha²lah lǿa¹² jǿg³ dsøg¹² lah¹dsóh². Jǿg³ dsøg¹² jøng² báh³ jmo¹ hi² liúgh² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jøng² ca¹juúh² dsa² héi²: ―Tsø³jong¹³ hlai³ Abraham báh³ jnieh³. Ha¹chian² dsa² siáh² tsa¹ma²ca¹jmo¹ dsen¹³ ja³cog² jnieh³. ¿He² løa¹ juúh² hning² jøng² hi² liúg² jnieh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jøng² ca¹juúh² Jesús: ―Jǿg³ dsøg¹² lah¹dsóh² báh³ juǿi²jni hniah¹²: Lán¹² ca¹lah¹já¹ dsa² jmo¹² hi² hlaih¹³ ju³lah lán¹² dsa² ma²ni³hnë¹ quiah¹² hi² hlaih¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ju³lah dsa² jmo¹² ta³ quiah¹² dsa², tsa¹chi² jǿg³ dsøg¹² chi² hi² guú¹dsa tiá² ni³ juu³dsa. Ja³ŋiúh³ juu³dsa báh³ dsa² guǿ¹² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hi² jøng² liúgh² báh³ hniah¹² lah¹dsóh² ju³ná³ ca¹log³jni hniah¹², jní² dsa² lán¹² ja³ŋiúh³ Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma²guiang³ báh³ jní² hi² lanh¹² hniah¹² tsø³jong¹³ hlai³ Abraham. Cónh¹jøng² hnøngh² hniah¹² jŋë́h³ hniah¹² jní². Di³ tsa¹hnøngh² hniah¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Hǿa¹²jni ca¹lah¹jǿ¹ jǿg³ hi² ma²ca¹he¹ ti³ŋieh¹jni. Ju³lah jmoh² hniah¹² ca¹lah¹jǿ¹ hi² ma²ca¹he¹ ti³ŋieih¹² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jøng² ca¹juúh² dsa² héi²: ―Hlai³ Abraham báh³ lán¹² ti³jmi² jnieh³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Mi³jmóh³ hniah¹² ju³lah ca¹jmo¹ hlai³ Abraham ju³ jøng² hi² lanh¹² hniah¹² lah¹dsóh² tsø³jong¹³ hlai³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ju³ he² jín³ ma²ca¹juǿi²jni hniah¹² jmáh¹lah jǿg³ dsøg¹², jǿg³ ca¹he¹ Diú¹³, cónh¹jøng² hi² hnøngh² báh³ hniah¹² jŋë́h³ hniah¹² jní². Ha¹chi² ca¹jmo¹ hlai³ Abraham lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ju³lah jmo¹² ti³ŋieih¹² báh³ hniah¹² jmoh² hniah¹² ―ca¹juúh² Jesús. Jøng² ca¹juúh² dsa² héi²: ―Héi¹ ju³ guing² la³chian² jnieh³. Chian² báh³ jan² ti³jmi² jnieh³, Diú¹³ juanh¹² báh³ héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jøng² ca¹juúh² Jesús: ―Ju³ jøng² hi² lah¹dsóh² lán¹² Diú¹³ ti³ŋieih¹² hniah¹², mi³li¹hnángh¹ hniah¹² jní² ju³ lah¹jøng². Di³ ca¹guio¹jni juu¹² ja³guǿ¹³ Diú¹³. A¹jáng¹ ju³ hi² ca¹guio¹jni hi² të²jni hŋiéng¹jni. Hi² ca¹tsei¹ Diú¹³ báh³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tsa¹ŋë́h² hniah¹² jǿg³ hi² juøh¹²jni. Di³ tsa¹hnøngh² hniah¹² jǿg³ dsio¹ quin³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dsa² hlanh³ báh³ lán¹² ti³ŋieih¹² hniah¹². Hi² jøng² hnøngh² hniah¹² jmóh³ hniah¹² ju³lah hniu¹ dsa² héi². Dsa² hlanh³ ca¹jmo¹ hi² hlaih¹³ cónh¹ jmai³ lah¹ni³. Ca¹mi¹dsian¹²dsa dsa². Tsa¹lǿih² jmai³ hniu¹ dsa² héi² jǿg³ dsøg¹². Di³ tsa¹dsøg¹² jǿg³ quiah¹²dsa. Tø³júg³dsa. Lán¹²dsa juu³ dsa² tø³júg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hi² jøng² tsa¹héh² hniah¹² jǿg³ quieg¹jni. Di² juǿi²jni hniah¹² jǿg³ dsøg¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jin³ jan² hniah¹² tsa¹tiah¹ hniah¹² cánh³ hniah¹² jǿg³ dsøg¹² ja³cog²jni hi² re²jni dsag³. Ma²ca¹juǿi²jni hniah¹² jǿg³ dsøg¹². ¿He² løa¹ tsa¹héh² hniah¹² jǿg³ dsøg¹² ma²ca¹juǿi²jni hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nang¹² báh³ dsa² quián¹² Diú¹³ jǿg³ juúh² Diú¹³. Hniah¹² tsa¹nøngh² jǿg³ quiah¹² Diú¹³. Di³ tsa¹lanh¹² hniah¹² dsa² quián¹²dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jøng² ca¹juúh² dsa² canh¹³ quián¹² dsa² judío: ―Chi² báh³ jǿg³ dsøg¹² quián² jnieh³ ma²juúh² jnieh³ hi² lanh¹² hning² dsa² hlanh³, ju³lah lán¹² dsa² chian² Samaria. Quinh³hning jmi²dsí² hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jøng² ca¹juúh² Jesús: ―Ha¹chi² jmi²dsí² hlaih¹³ quin³jni. Ca¹lah¹jǿ¹ hi² jmo³jni hi² mi³juanh¹³jni ti³ŋieh¹ báh³ jní² jøng². Cónh¹jøng² cu²jmagh¹² hniah¹² jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A¹jáng¹ ju³ hi² mi³juanh¹³ jní² hŋiéng¹jni. Chian² báh³ jan² dsa² hniu¹ lén² jní² dsa² juanh¹². Dsa² héi² báh³ mi¹rø¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein² dsa² mi¹ti¹ jǿg³ quieg¹ jní², ha¹chi² dsián¹ dsa² héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jøng² ca¹juúh² dsa² canh¹³: ―Lah¹dsóh² ma²ne³ jnieh³ hi² quinh³hning jmi²dsí² hlaih¹³. Di³ ca¹jon¹ báh³ hlai³ Abraham quianh¹³ ca¹lah¹já¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². Jøng² juúh²hning tsa¹dsián¹ dsa² mi¹ti¹ jǿg³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ho¹ hiug¹² jín³ hi² juanh¹² hning² cónh¹ jín³ hlai³ Abraham ca¹lah¹quianh¹³ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih², dsa² ma²ca¹dsan¹? ¿Hein² dsa² juúh²hning hi² lanh¹²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jøng² ca¹juúh² Jesús: ―Ha¹chi² quien¹² ju³ná³ jní² mi³juanh¹³ hŋiéng¹. Ti³ŋieh¹ báh³ jní² dsa² jmo¹ juanh¹² jní², dsa² juúh² hniah¹² hi² lán¹²dsa Diú¹³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ha¹chian² dsa² héi² cueh¹² hniah¹². Jní² báh³ cué¹² dsa² héi². Ju³ná³ juøh¹²jni tsa¹cué¹²jni dsa², lán¹²jni jan² dsa² tø³júg³ ju³lah lanh¹² hniah¹². Lah¹dsóh² cué¹² báh³ jní² dsa². Jø¹² bíh³ mi²ti³jni jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hioh¹² jenh¹² hlai³ Abraham, dsa² hóg¹ quiánh² hniah¹², mi³ca¹lø¹ŋi¹²dsa hi² jái¹dsa ja³ca¹guio¹jni ni³ jmøi¹guǿi¹. Jø¹² bíh³ hioh¹² jenh¹²dsa mi³ma²ca¹jái¹dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jøng² ca¹juúh² dsa² canh¹³. ―Tsa¹jín³ ma²hiúgh³hning to¹lu¹guií² ji²ŋi². Ha²lah dsio¹ ma²ca¹janh³hning hlai³ Abraham, dsa² mi³chian² ma²lǿih² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jøng² ca¹juúh² Jesús: ―Lah¹dsóh² juǿi²jni hniah¹². Ma²chian² báh³ jní² cónh¹ niúh¹ jín³ hi² ca¹lø¹chián¹ hlai³ Abraham, jní² dsa² chian² tiá² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jøng² ca¹jiégh¹ dsa² canh¹³ cang³, hi² mi³qui¹túg²dsa Jesús. Jøng² ca¹hmóh¹ Jesús. Ca¹u¹hái¹dsa ja³tsih¹³ guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Juu¹² ja³ca¹ŋó¹ Jesús jøng², ca¹jén²dsa jan² dsa² tsa¹jniuh¹² cónh¹ jmai³ mi³ca¹lø¹chián¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jøng² ca¹juúh² dsa² guia¹tón², ca¹tsáih¹dsa Jesús: ―Tøa¹², ¿hein² dsa² ca¹jmo¹ hi² hlaih¹³ hi² ca¹lø¹chián¹ dsa² ná¹² hi² tsa¹jniuh¹²dsa? ¿Hi³ ca¹jmo¹ chiég³ jmi²dsa, ho¹ ju³ hi² ca¹jmo¹ hŋiah¹²dsa? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jøng² ca¹juúh² Jesús: ―Ha¹chian² dsa² ca¹jmo¹ hi² hlaih¹³ hi² tsa¹jniuh¹² dsa² ná¹², a¹jáng¹ ju³ hŋiah¹²dsa, a¹jáng¹ ju³ chiég³ jmi²dsa. Hi² jøng² báh³ tsa¹jniuh¹²dsa. Mi³jøng² li¹léi¹³ tiúh¹ Diú¹³ mi¹hliú² dsa² tsa¹jŋiuh¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hniuh¹² báh³ jmó³ jŋiang³ ju³lah hniu¹ dsa² ca¹tsei¹ jní² cónh¹ chi² jmai³ li¹jmó³ jniang³. Di³ jií¹ báh³ jmai³ ja³tsa¹ma¹lé² jmó³ jniang³, ju³lah lǿa¹² quiah¹² dsa² tsa¹ma¹lé² jmo¹ ta³. Di³ ca¹neng². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jøng² ha²cónh¹ jmai³ ja³ŋøa³jni jmøi¹guǿi¹ lán¹²jni ju³lah jan² dsa² jmo¹² taih¹² juu¹² ja³ŋi¹nio¹ dsa² jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mi³ma²na²juúh² Jesús jǿg³ jøng², ca¹hŋiéng¹dsa huø¹. Ca¹jmo¹dsa jen² quianh¹³ jmø³høah¹³ quiah¹²dsa. Jen² jøng² ca¹tsǿng²dsa ja³tioh¹³ mø³ni³ dsa² tiug³. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jøng² ca¹juúh² Jesús: ―¡Gu²rang³ mø³neih³ ja³neng¹² jmøi² tsen² Siloé! ―ca¹juúh²dsa. (Siloé hniu¹dsa juúh²dsa: hi² ca¹tsei¹dsa.) Ca¹ŋó¹ dsa² tiúg³. Ca¹ŋi³rang³dsa mø³ni³dsa. Ma²jniuh¹²dsa mi³ca¹dsiánh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jøng² lah¹la² ca¹juúh² ca¹lah¹já¹ dsa² tiogh³ cøg¹², quianh¹³ dsa² ma²ca¹jái¹ ja³mi³møa¹ dsa² héi² ŋi³néng² lah¹jiá¹², ca¹juúh²dsa: ―¿A³¹jáng¹ ju³ dsa² ná¹², dsa² mi³guǿ¹³ mi³møa¹ ŋi³néng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jøng² ca¹juúh² ca²dsiog³dsa: ―Dsa² héi² báh³ ná¹² ―ca¹juúh²dsa. Ca²dsiog³dsa ca¹juúh²: ―Lah¹jøng² báh³ jniá²dsa. Di³ héi¹ ju³ dsa² héi² mi³né³ ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi² hŋiah¹²: ―Dsa² héi² báh³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jøng² ca¹juúh² dsa² jue¹² calah: ―¿Ha²lah ca¹løa¹ hi² ma²jniah¹hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jøng² ca¹juúh² dsa² mi³tiug³ héi²: ―Dsa² tsen² Jesús ca¹jmo¹ jen². Ca¹tsǿng²dsa ja³tioh¹³ mø³ne¹jni. Jøng² ca¹juúh²dsa: “¡Gu²rang³ mø³neih³ ja³neng¹² jmøi² tsen² Siloé!” ca¹juúh²dsa. Jøng² ca¹ŋie³ báh³ jní². Ca¹ŋi³rang¹jni mø³ne¹. Mi³ca¹jŋǿi² mø³ne¹jni, jøng² ca¹lø¹jniáng¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jøng² ca¹juúh² dsa² jue¹²: ―¿Ha² tøah¹ hiúg³ dsa² héi²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² mi³tiug³: ―Tsa¹guiang³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jøng² ca¹ŋi¹jian¹dsa dsa² mi³tiug³ ni³ dsa² fariseo. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jmai³ sa³¹ báh³ jøng² hi² ca¹jmo¹ Jesús jen², hi² ca¹lø¹jniuh¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jøng² ca¹juúh² dsa² fariseo, ca¹tsáih¹dsa dsa² tsa¹mi³jniuh¹² héi²: ―¿Ha²lah ca¹løa¹ hi² jniah¹hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Ca¹tsǿng²dsa jen² mø³ne¹jni. Ni³jøng² ca¹rang¹jni mø³ne¹. Jøng² ca¹lø¹jniáng¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jøng² ca¹juúh² ca²dsiog³ dsa² fariseo: ―Héi¹ ju³ dsa² quián¹² Diú¹³ ca¹jmo¹ lah¹jøng². Di³ ca¹jmo¹dsa lah¹jøng² jmai³ sa³¹ ―ca¹juúh²dsa. Ca²dsiog³dsa ca¹juúh²: ―Ha¹chi² tiúh¹ dsa² tsa¹quián¹² Diú¹³ jmo¹ juu¹² juøh¹² ju³lah jmo¹² dsa² héi² ―ca¹juúh²dsa. Jøng² ca¹løa¹ ton¹ tséh¹ dsa² fariseo. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jøng² ca¹juúh²dsa calah, ca¹tsáih¹dsa dsa² mi³tiug³: ―¿He² juúh²hning ja³cog² dsa² héi², dsa² ca¹jmo¹ hi² jniah¹hning? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Dsa² hǿ² jǿg³ quiah¹² Diú¹³ báh³ héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tsa¹hé² dsa² canh¹³ quián¹² dsa² judío jǿg³ hi² mi³lán¹³ dsa² héi² dsa² tiug³, dsa² ma²jniuh¹² héi². Jøng² ca¹tǿh¹dsa chiég³ jmi² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jøng² ca¹juúh² dsa² canh¹³: ―¿Lán¹³ dsa² lang¹² jonh¹² hniah¹², dsa² juúh² hniah¹² tsa¹jniuh¹²dsa cónh¹ jmai³ mi³ca¹lø¹chián¹dsa? ¿Ha²lah ma²jniuh¹²dsa na¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jøng² ca¹juúh² chiég³ jmi² dsa² héi²: ―Jong¹² báh³ jnieh³ dsa² ná¹². Mi³tiug³dsa mi³ca¹lø¹chián¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Di³ jøng² tsa¹ne³ jnieh³ ha²lah ca¹løa¹ ca¹lø¹jniuh¹²dsa. Tsa¹ne³ jnieh³ hein² dsa² ca¹jmo¹. ¡Ŋai³ hniah¹² dsa²! Dsa² ma²juanh¹² báh³ ná¹². Ma²lé² juúh²dsa ha²lah ca¹løa¹ hi² ca¹lø¹jniuh¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lah¹jøng² ca¹juúh² chiég³ jmi² dsa² héi². Di³ hi² gan¹dsa dsa² canh¹³. Di³ ma²ca¹jmo¹ dsa² canh¹³ jǿg³ hi² tsa¹ma¹cuø¹dsa jǿg³ dsø¹lé²dsa guøh¹², ju³ná³ hein² dsa² ca¹juúh² hi² lán¹² Jesús Cristo. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ni³ lah¹jøng² báh³ ca¹juúh² chiég³ jmi² dsa² héi²: “Ŋai³ hniah¹² dsa². Dsa² ma²juanh¹² báh³ ná¹²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jøng² ca¹juúh² dsa² canh¹³ calah, ca¹tsáih¹dsa dsa² mi³tiug³: ―¡Diú¹³ mi²juanh¹³hning! Di³ ma²ne³ jnieh³ tsa¹lán¹² dsa² héi² dsa² quián¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jøng² ca¹juúh² dsa² mi³tiug³ héi²: ―Tsa¹guiang³jni chi²júh² lán¹²dsa dsa² quián¹² Diú¹³. Hi² jøng² báh³ guiang³jni, hi² mi³lán¹²jni dsa² tiug³. Na¹ bíh³ hi² ma²jniáng¹³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jøng² ca¹juúh² dsa² canh¹³ calah: ―¿He² ca¹jmo¹dsa hi² ca¹lø¹jniah¹hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jøng² ca¹juúh² dsa² héi²: ―Ma²na²juǿi²jni hniah¹². Tsa¹héh² hniah¹² jǿg³ quieg¹jni. ¿He² løa¹ hnøngh² hniah¹² juøh¹³jni ni³ hmë́²? ¿Ho¹ ju³ hnøngh² hniah¹² li¹quianh¹³ hniah¹² dsa² héi², liáh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jøng² ca¹jé² dsa² canh¹³ dsa² héi². Ca¹juúh²dsa: ―Hning² báh³ lanh¹² dsa² quián¹² dsa² héi². Dsa² quián¹² hlai³ Moisés báh³ jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma²ne³ báh³ jnieh³ hi² ca¹hlanh¹ Diú¹³ hlai³ Moisés. Jøng² tsa¹ne³ jnieh³ ha² juu¹² ca¹já¹ dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jøng² ca¹juúh² dsa² mi³tiug³: ―¡He³ báh³ hiug¹²! Tsa¹ŋih³ hniah¹² ha² juu¹² ca¹já¹ dsa² héi². Cónh¹jøng² ca¹jmo¹dsa hi² jniáng¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ma²ne³ báh³ jniang³ hi² tsa¹nang¹ Diú¹³ jǿg³ quiah¹² dsa² tsa¹quián¹²dsa. Nang¹ báh³ dsa² jǿg³ quiah¹² dsa² jmo¹² juanh¹²dsa, dsa² mi²ti¹ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jin³ cøng² jmai³ tsa¹ma²ca¹néng³ jniang³ jǿg³ hi² chian² dsa² tiúh¹ jmo¹ hi² li¹jniuh¹² jan² dsa² tiug³ cónh¹ jmai³ mi³ca¹lø¹chián¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ha¹chi² mi³tiúh¹ dsa² héi² jmo¹ lah¹jøng² ju³ jøng² tsa¹ca¹tsei¹ Diú¹³ ―ca¹juúh² dsa² mi³tiug³. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jøng² ca¹juúh² dsa² canh¹³: ―Hning², dsa² reh² dsag³ cónh¹ jmai³ mi³ca¹lø¹chiánh¹hning, ha²lah dsio¹ mi³heh¹³hning jnieh³ jǿg³ ―ca¹juúh²dsa. Jøng² ca¹dsiánh² dsa² fariseo dsa² héi². Tsa¹ma¹cuø¹dsa jǿg³ dság¹ dsa² héi² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ca¹lø¹ŋi¹² Jesús jǿg³ hi² ma²ca¹lén²dsa dsa² mi³tiug³ héi² jøa³ ja³tiogh³dsa. Jøng² mi³ca¹dsanh¹² Jesús dsa² héi², ca¹juúh² Jesús: ―¿Héh³hning jǿg³ quiah¹² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jøng² ca¹juúh² dsa² héi²: ―Guiuh¹³, tseih³hning jní² hein² dsa² héi². Jøng² hé²jni jǿg³ quiah¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jøng² ca¹juúh² Jesús: ―Ma²ca¹janh³ báh³ hning² dsa². Jní² báh³ héi², dsa² dsiih²hning jǿg³ quianh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jøng² ca¹chi¹jné¹ dsa² héi² ni³ Jesús. Ca¹juúh²dsa: ―Hé² báh³ jní² jǿg³ quiánh²hning, Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jøng² ca¹juúh² Jesús: ―Ca¹guio¹jni ni³ jmøi¹guǿi¹ la² hi² mi³rø³jni jǿg³. Mi³jøng² li¹ŋi¹² dsa² tsa¹mi³ŋi¹². Mi³jøng² tsa¹li¹ŋi¹² dsa² lë́² hi² ŋi¹²dsa, dsa² lah¹dsóh² lán¹² ju³lah jan² dsa² tiug³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jøng² ca¹juúh² jan² og¹ dsa² fariseo mi³tiogh³ cøg¹² ja³ti³dsii¹²dsa jǿg³: ―¿Lán¹³ jnieh³ ju³lah lán¹² jan² dsa² tiug³ calah? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jøng² ca¹juúh² Jesús: ―Ha¹chi² dsag³ mi³ta¹canh¹³ hniah¹² ju³ jøng² mi³lah¹dsóh² tiugh³ hniah¹². Cónh¹jøng² ta¹canh¹³ báh³ hniah¹². Di³ hi² juúh² hniah¹² hi² ma²ŋih³ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jøng ca¹juúh² Jesús calah: ―Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Léi¹³ lán¹²dsa dsa² høin², ju³ná³ hein² dsa² ca¹uǿi² jnǿ³ ja³tiogh³ jah¹chih², hi² tsa¹hí¹dsa niúh¹ jnǿ³ ja³lǿa¹² hag³jnǿ³. Dsa² hniu¹ hë¹ jáh² báh³ héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jøng² ma²léi¹³ lán¹²dsa juu¹³ jáh², ju³ná³ ca¹hí¹dsa ja³tiogh³ jáh², hi² ca¹hí¹dsa juu¹² hag³jnǿ³. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cuø¹² báh³ dsa² jmo¹² hí³ hag³jnǿ³ jǿg³ hi² ŋë¹ juu¹³jah niúh¹ jnǿ³. Jøng² ma²cuúh¹²jah hag³ juu¹³jah na³ma²ca¹tǿh¹dsa jáh² quián¹²dsa, lah¹cøng² lah¹cøng² hi² tsen²jah. Jøng² dsa¹jian¹²dsa jah² quián¹²dsa juu¹² ja³dsa¹gǿh¹jah. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jøng² cán² juu¹³jah ni³quiah¹² jáh² quián¹²dsa, na³ma²ca¹huanh¹² ca¹lah¹já¹ jáh² niúh¹ jnǿ³. Jøng² dsø¹lé²jah ti³dsë¹³jah cah³ juu¹³jah. Di³ cuuh¹² báh³ jáh² hag³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ha¹chi² ti³dsë¹³jah cah³ dsa² tsa¹cue¹²jah. Tø¹lah¹cuøin¹ báh³ jáh² quianh¹³ dsa² tsa¹cue¹²jah. Di³ tsa¹cuuh¹²jah hag³dsa ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jǿg³ ti³jnøa¹² lah¹jøng² ca¹dsiúh¹ Jesús dsa² jue¹². Di³ jøng² ha¹chi² ca¹lø¹ŋë́² dsa² jue¹² he² hniu¹dsa juúh²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jøng² ca¹juúh² Jesús calah: ―Lah¹dsóh² juǿi²jni hniah¹²: Lán¹²jni ju³lah lǿa¹² hag³jnǿ³ ja³dsø²tiogh¹² jah¹chih², jáh² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dsa² lán¹² ju³lah lán¹² dsa² høin² báh³ dsa² ca¹u¹lé² ma²jiá¹² cónh¹ jín³ jní², dsa² mi³mi¹gan¹² dsa² quian¹jni. Cónh¹jøng ha¹chi² ca¹nǿng² dsa² quian¹jni jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jní² báh³ lán¹² ju³lah lǿa¹² hag³jnǿ³ ja³dsa¹togh¹ jáh². Ju³ná³ hein² dsa² ca¹hie¹ jǿg³ quieg¹ jní², dsa² héi¹² liúg². Dsio¹ lé² quiah¹²dsa ju³lah lán¹² jah¹chih² dsø¹lé² ja³dsø¹gǿh¹jah. Jøng² dsø¹lia¹jah calah niúh¹ jnǿ³. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dsa² høin² báh³ jmo¹² hi² dsa¹hén²jah. Hi² hë¹dsa jáh². Jøng² mi¹dsian¹²dsa jáh². Jøng² jní² ca¹guio¹, mi³jøng² li¹chian² dsa² quian¹jni tiá², hi² li¹chi² ca¹lah¹jǿ¹ hi² hniuh¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Lán¹²jni ju³lah lán¹² jan² juu¹³jah dsiog¹. Di³ hiug² báh³ dsǿa¹² dsa² lah¹héi² jón² ni³ huu¹³ hi² liúg² jah¹chih² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tsa¹lán¹² dsa² hlianh¹³ lah¹jøng², dsa² tsa¹lán¹² juu¹³jah. Cuøin¹ dsa² hlianh¹³ ju³ná³ ca¹jë́²dsa dsøi²núng³. Jmo¹dsa tiogh³ jah¹chih² cu³guiog¹³. Di³ ha¹chi² quián¹²dsa jáh². Jøng² chiánh² dsøi²núng³ jah¹chih². Cuøin¹ jah¹chih². Tsø¹jan¹jah. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cuøin¹ dsa² héi². Di³ lán¹²dsa dsa² hlianh¹³. Ha¹chi² høa¹² dsǿa¹²dsa jáh². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jøng² jní² lán¹² ju³lah lán¹² jan² juu¹³jah dsiog¹. Cué¹² báh³ jní² dsa² quian¹jni. Jø¹² bíh³ cuai¹² dsa² quian¹jni jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Lǿa¹² ju³lah lǿa¹² quiah¹² ti³ŋieh¹jni. Cuai¹² ti³ŋieh¹jni jní². Jø¹² bíh³ cuén¹²jni ti³ŋieh¹jni calah. Hiug² báh³ dsøa¹jni hi² jón²jni. Mi³jøng² liúg² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jø¹² bíh³ chian² dsa² siáh² quian¹jni, dsa² chian² ja³siíh³. Hniuh¹² mi³quianh³jni dsa² héi². Di³ nang¹ báh³ dsa² jǿg³ quieg¹jni. Jøng² tógh¹ dsa² héi² cøng² ni³ dsa² quian¹ jní², quianh¹³ dsa² quian¹jni chian² ja³la². Jan² jní² báh³ lén² dsa² juu³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Hi² jøng² báh³ hniang¹ ti³ŋieh¹jni jní². Di³ hi² hiug² dsøa¹jni jón²jni. Mi³jøng² liúg² dsa² quian¹jni. Jøng² hiog¹jni calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ha¹chian² dsa² tiúh¹ jmo¹ hi² jón² jní², ju³ná³ tsa¹hiug² dsøa¹jni jón²jni. Jón²jni. Di³ hi² hiug² dsøa¹ hŋiéng¹ báh³ jní². Hio¹² jǿg³ dsøg¹² jón²jni. Jøng² hiog¹jni calah. Di³ jǿg³ jøng² ca¹cuø¹ ti³ŋieh¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jøng² ca¹løa¹ ma²quién¹ dsa² judío, mi³ca¹nǿng²dsa jǿg³ ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jue¹² dsa² ca¹juúh²: ―Dsa² ŋa¹² báh³ ná¹². Quin¹²dsa jmi²dsí² hlaih¹³. ¿He² løa¹ nøngh² hniah¹² jǿg³ quiah¹²dsa? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ca²dsiog³dsa ca¹juúh²: ―Ca¹lah¹jín³ jan² dsa² quin¹² jmi²dsí² hlaih¹³ tsa¹hløah¹ ju³lah hløah¹² dsa² ná¹². Tsa¹tiúh¹ dsa² quin¹² jmi²dsí² hlaih¹³ jmo¹ li¹jniuh¹² dsa² teg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ca¹tǿ² jmai³ juøh¹² quiah¹² guøh¹² juøh¹² tsih¹² jøa³juøi² Jerusalén, ca¹lah¹cónh¹ mi³ca¹dsë¹ cøng² ŋi² ca¹lø¹jŋiéng¹ guøh¹² ma²lǿih² mi³ca¹tsih¹ guøh¹². Ma²lǿa¹² jin² guǿi². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jøng² ca¹ŋie³ Jesús ja³tsih¹³ guøh¹², cøng² ja³tǿh²dsa Portal de Salomón. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jøng² ca¹ŋëh² dsa² canh¹³ quián¹² dsa² judío ja³tsenh¹³ Jesús. Ca¹tsáih¹dsa Jesús: ―Ma²ni³ŋó¹³ jmai³ tsa¹lø²chi² jǿg³ dsøg¹² quiánh² hning². Tseih³hning jnieh³ cu²rø² jǿg³ chi²júh² lah¹dsóh² lanh¹²hning Cristo ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jøng² ca¹juúh² Jesús: ―Ma²ca¹juǿi²jni hniah¹² hein² dsa² lán¹²jni. Tsa¹héh² hniah¹² jǿg³. Ma²ca¹lø¹léi¹³ hein² dsa² lán¹²jni. Di³ ma²ca¹jmo¹jni juu¹² juøh¹² ni³ quiah¹² ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Cónh¹jøng² tsa¹héh² hniah¹² jǿg³. Di³ tsa¹lanh¹² hniah¹² dsa² quian¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nang¹² báh³ dsa² quian¹jni jǿg³ quieg¹jni. Cué¹² báh³ jní² dsa² héi². Ti³dsë¹³dsa cah¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cuø³jni bí² hi² li¹chian²dsa tiá². Mi³jøng² tsa¹dsø¹hén²dsa. Ha¹chian² dsa² siáh² jŋiáh² dsa² héi², dsa² neng¹² gug¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ti³ŋieh¹ báh³ jní² ca¹cuan¹ dsa² héi² ja³cog²jni. Hiug¹² juanh¹² ti³ŋieh¹jni cónh¹ jín³ ca¹lah¹já¹ dsa² siáh². Hi² jøng² ha¹chian² dsa² siáh² tiúh¹ jŋiáh² dsa² ma²neng¹² gug² ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Cøng² báh³ lán¹²jni quianh¹³ ti³ŋieh¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jøng² ca¹jiégh¹ dsa² canh¹³ cang³ hi² mi³qui¹túg²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jøng² ca¹juúh² Jesús: ―Hliú² hi² dsio¹ ma²ca¹jmo¹jni ja³ta¹neih¹² hniah¹², ni³ quiah¹² ti³ŋieh¹jni. ¿Naih¹² hi² dsio¹ ma²ca¹jmo¹jni hi² tsa¹tøa¹² hoh¹² hniah¹², hi² qui³tágh² hniah¹² jní² cang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jøng² ca¹juúh² dsa² canh¹³: ―A¹jáng¹ ju³ hi² jøng², qui³tog³ jnieh³ hning² cang³ huu¹³ hi² dsio¹ ma²ca¹jmoh³hning. Qui³tog³ jnieh³ hning² cang³. Di³ jmoh²hning tsa¹juanh¹² Diú¹³ quianh¹³ jǿg³ ma²ca¹juøh³hning. Dsa² jmøi¹guǿi¹ báh³ lanh¹²hning. Di³ jmoh²hning hi² lanh¹²hning Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jøng² ca¹juúh² Jesús: ―Ni³ si² quiah¹² Diú¹³ quiánh² hniah¹² rø²juúh² jǿg³ la², ca¹juúh² Diú¹³, ca¹tsáih¹dsa dsa² ta³ quián¹² dsa² hóg¹: “Lanh¹² hniah¹² ju³lah lán¹² diú¹³,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma²ŋih³ báh³ hniah¹² té¹² ca¹lah¹jǿ¹ jǿg³ rø²juúh² si² quiah¹² Diú¹³. Jøng² diú¹³ ca¹tǿh¹dsa dsa² héi². Di³ ca¹hei¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jøng² ca¹hei¹ Diú¹³ jní² hi² ca¹guio¹jni jmøi¹guǿi¹. Ca¹tsei¹ Diú¹³ jní². ¿He² løa¹ juúh² hniah¹² hi² jmo³jni tsa¹juanh¹² Diú¹³ jøng², ja³ma²na²juúh¹jni hi² lán¹²jni jong¹² Diú¹³? ");
INSERT INTO cpaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dsio¹ báh³ tsa¹héh² hniah¹² jǿg³ quieg¹jni, ju³ná³ tsa¹jmo³jni ju³lah hniu¹ ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jøng² ju³ lah¹la² tsa¹héh² hniah¹² jǿg³ hi² juǿi²jni hniah¹², tiog¹³ ju³héh³ hniah¹² jǿg³ ca¹mi³hag¹³ ti³ŋieh¹jni ja³ca¹jmo¹jni juu¹² juøh¹². Mi³jøng² li¹ŋih³ hniah¹² ma²quianh¹³jni ti³ŋieh¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jøng² hniu¹ dsa² canh¹³ mi³chiánh²dsa calah Jesús. Cónh¹jøng² ca¹lug² báh³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ni³ jøng² ca¹ŋó¹ Jesús juu¹² tø¹hŋoh¹³ chi³jmøi² Jordán. Ja³jøng² ca¹jŋi¹dsa ja³mi³chiog¹² Juan dsa² jmøi² lah¹jiá¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ca¹dsi¹lé² dsa² jue¹². Ca¹ŋi³ja³dsa Jesús. Jøng² ca¹dsii¹dsa jǿg³ cu³guiog³dsa. Ca¹juúh²dsa: ―Tsa¹ca¹jmo¹ Juan jin³ cøng² juu¹² juøh¹². Di³ lah¹dsóh² dsøg¹² báh³ jǿg³ ca¹juúh²dsa ja³cog² Jesús ―ca¹juúh² dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jøng² jue¹² dsa² ca¹hé¹ jǿg³ quiah¹² Jesús ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi³dsoh³ jan² dsa² tsen² Lázaro, dsa² chian² Betania, juøi² ja³chian² María quianh¹³ Marta, roh¹³ María. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María héi² báh³ dsa² ca¹séi² nang³ ma²juøi² tai³ Jesús. Ca¹mi¹quính²dsa quianh¹³ jŋiu² dsi³dsa. Roh¹³ María héi² báh³ lán¹² Lázaro. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jøng² hio¹³ roh¹³ dsa² dsoh³ héi² ca¹tse¹ jǿg³ ja³cog² Jesús hi² dsoh³ Lázaro, dsa² hnio¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mi³ca¹nǿng² Jesús jǿg³ jøng², ca¹juúh²dsa: ―Ha¹chi² jón² Lázaro cu¹té¹² dsag³ hi² lán¹²dsa. Huu¹³ jøng² báh³ ca¹lø¹dsoh¹dsa, mi³jøng² mi¹juanh¹² dsa jue¹² Diú¹³. Jø¹² bíh³ mi¹juanh¹²dsa jní², jní² dsa² lán¹² jong¹² Diú¹³, huu¹³ quiah¹² Lázaro ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hiug¹² hnio¹ Jesús Marta, quianh¹³ María, quianh¹³ Lázaro. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jøng² mi³ca¹lø¹ŋi¹²dsa jǿg³ hi² dsoh³ Lázaro, ca¹jŋi¹dsa jin³ ton¹ jmai³ ja³mi³hiúg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ni³ jøng² ca¹tsáih¹dsa dsa² quianh³dsa: ―Ma¹dsǿg³ calah ja³tén¹² Judea ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jøng² ca¹juúh² dsa² quianh³dsa: ―Tøa¹², ha¹chi² ma²ni³ŋó¹³ jmai³ hi² hniu¹ dsa² canh¹³ quián¹² dsa² judío mi³jŋëh¹dsa hning² quianh¹³ cang³. ¿He² løa¹ hnøngh²hning góh³hning calah ja³jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jøng² ca¹juúh² Jesús: ―Lǿa¹² quian¹jni ju³lah lǿa¹² quiah¹² dsa² ŋi²nio³ ŋi²jmø². Chi² báh³ guie¹tǿn² hora lah¹cøng² lah¹cøng² jmai³ ja³taih¹² jmøi¹guǿi¹. Ha¹chi² qui²niá¹² dsa² ŋi²nio³ ŋi²jmø². Di³ taih¹² ja³ŋi²nio³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Cónh¹jøng² qui²niá¹² báh³ dsa² ŋi²nio³ ja³neng². Di³ tsa¹jniuh¹²dsa. Jøng² ha¹chi² ma²ca¹tǿ² hora ja³jŋaih¹dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ni³ jøng² ca¹juúh² Jesús: ―Ma²rø²güé¹ Lázaro, dsa² jenh² quianh¹³ jniang³. Jøng² nei¹³jni hi² ŋi³ŋie¹³jni dsa² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jøng² ca¹juúh² dsa² quianh³dsa: ―Juu¹³ jniang³, ju³ná³ ma²rø²güé¹dsa ma²hei¹² ni³ hliú²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ca¹juúh² Jesús lah¹jøng². Di³ ma²rø²jon¹³ Lázaro. Jøng² lë́² dsa² quianh³ Jesús hi² lah¹dsóh² rø²güé¹ báh³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jøng² ca¹nií¹ Jesús jǿg³. Ca¹juúh²dsa: ―Ma²rø²jon¹³ Lázaro. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ni³ huu¹³ quiánh² hniah¹² báh³ tøa¹² dsøa¹jni tsa¹tiagh³ jniang³ ja³jøng² mi³ca¹jon¹dsa. Di³ jøng² héh² hniah¹² jǿg³. Ma¹ne¹³ jniang³ cøng² hlai³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jøng² ca¹juúh² Tomás, dsa² tǿh²dsa Guing² Og¹, ca¹tsáih¹dsa dsa² jian¹²dsa: ―Ma¹dsǿg³ jniang³ quianh¹³dsa. Di³ jøng² dsiág¹ jniang³ cu¹dsie¹² quianh¹³dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma¹quiún² jmai³ ca¹hog¹ Lázaro mi³ca¹dsiég¹ Jesús Betania. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Neng¹² Betania cøg¹² juøi² Jerusalén. Ton¹ kilometro tón² ca²jag¹³ báh³ ti³ja¹³ juøi² Betania quianh¹³ juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jøng² jue¹² dsa² judío ma²ca¹dsi¹lé² ja³quiah¹³ Marta quianh¹³ María, dsa² cuø¹ liáh², mi³ca¹jon¹ roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mi³ca¹lø¹ŋi¹² Marta jǿg³ hi² ja¹quien¹³ dsianh¹³ Jesús jøa³juøi² Betania, jøng² ca¹ŋó¹dsa. Ca¹mi¹jenh²dsa Jesús. Dsi²néi² báh³ guǿ¹² María, roh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jøng² ca¹juúh² Marta, ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, ha¹chi² mi³jón² roh¹²jni ju³ jøng² mi³ŋíh²hning ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma²guiang³ báh³ jní² hi² cuø¹ Diú¹³ ca¹lah¹jín³ na¹ ca¹lah¹jǿ¹ hi² møh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jøng² ca¹juúh² Jesús: ―Dsa¹hei¹ jmi²dsí² báh³ rúh²hning calah ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jøng² ca¹juúh² Marta: ―Ma²guiang³ báh³ jní² hi² hei¹ jmi²dsí² quiah¹²dsa na³ma²tǿ² ja³hiog¹ ca¹lah¹já¹ dsa² ma²ca¹dsan¹, na³ma²tǿ² ja³tiúh¹ jø² jmai³ quiah¹² jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ni³ jøng² ca¹juúh² Jesús: ―Jní² báh³ dsa² jmo¹ hi² hiog¹ dsa² ma²ca¹dsan¹. Jní² báh³ jmo¹ hi² li¹chian² dsa² chian². Ha¹chi² lǿa¹² quiah¹² dsa² hé² jǿg³ quieg¹ jní², ju³ná³ ca¹jon¹dsa. Hiog¹ báh³ dsa² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tsa¹lǿih² jmai³ dsa¹hén² dsa² chian² ja³cog²jni, dsa² hé² jǿg³ quieg¹ jní². ¿Héh³hning jǿg³ ná¹²? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jøng² ca¹juúh² Marta: ―Lah¹dsóh² hé²jni, Juu¹³ jniang³. Hé²jni jǿg³ hi² lanh¹²hning Cristo, jong¹² Diú¹³, dsa² ca¹tse¹ Diú¹³ ni³ jmøi¹guǿi¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mi³ma²na²juúh² Marta jǿg³ jøng², jøng² ca¹ŋi¹téh²dsa María, roh¹³dsa. Ca¹tsáih¹dsa María jǿg³ ta¹huø³. Ca¹juúh²dsa: ―Ma²guønh² Tøa¹². Tǿh²dsa hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ca¹lah¹cónh¹ mi³ca¹nǿng² María jǿg³ jøng², ta³lah¹ca¹nung²dsa. Ca¹ŋó¹dsa juu¹² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ha¹chi² ma²ca¹dsiég¹ Jesús jøa³juøi². Ja³jøng² tsenh¹²dsa, ja³ca¹jén²dsa Marta. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mi³ca¹jái¹ dsa² judío, dsa² cuø¹ liáh² héi², hi² ca¹u¹hái¹ María gu¹hei¹², jøng² ca¹ŋi¹lé²dsa ti³dsë¹³dsa cah³ María. Lë́²dsa hi² dsa¹hǿg² María ja³rø²hog¹² hlai³ Lázaro. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mi³ca¹dsiég¹ María ja³tsenh¹³ Jesús, jøng² ca¹chi¹jné¹dsa ni³ Jesús. Ca¹juúh²dsa: ―Juu¹³ jniang³, ha¹chi² mi³jón² roh¹²jni ju³ jøng² mi³ŋíh²hning ja³la². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mi³ca¹jái¹ Jesús ma²ho¹² María quianh¹³ dsa² judío ca¹dsi¹lé² quianh¹³dsa, ca¹tánh² dsǿa¹² Jesús. Ca¹hí¹ cøh² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jøng² ca¹juúh²dsa: ―¿Ha² tøah¹ ca¹hógh¹ hniah¹² hlai³? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² ca¹dsi¹lé²: ―Ma¹ne¹³ ja³jøng², Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jøng² ca¹ho¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jøng² ca¹juúh² dsa² judío: ―Jai³lah, hiug¹² mi³hnio¹dsa hlai³ Lázaro ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ca²dsiog³ dsa² héi² ca¹juúh²: ―Dsa² ná¹² ca¹jmo¹ hi² ca¹lø¹jniuh¹² dsa² teg³. ¿He² løa¹ tsa¹ca¹jmo¹dsa hi² tsa¹mi³jón² Lázaro? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ca¹lah¹cøh² hiu³ dsǿa¹² Jesús, ca¹ŋó¹dsa cøg¹² ja³rø²hog¹² hlai³. Cøng² tøg² hløg² báh³ jøng² ma²rø²jnøa¹² quianh¹³ ca²mǿi² cang³ pa³. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jøng² ca¹juúh² Jesús: ―¡Jŋíh² cang³ ná¹²! ―ca¹juúh²dsa. Jøng² ca¹juúh² Marta, roh¹³ hlai³: ―Juu¹³ jniang³, ma²ja² ma²jug¹² báh³ hlai³. Di³ ma¹quiún² jmai³ na¹ ca¹jon¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jøng² ca¹juúh² Jesús: ―Ma²ca¹juǿi²jni hning² hi² jáih³hning juu¹² juøh¹² jmo¹ Diú¹³ ju³ná³ héh²hning jǿg³ quieg¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jøng² ca¹jŋíh² ca²dsiog³dsa cang³ mi²rø²jnøa¹² hag³ tøg². Jøng² ca¹jái¹ Jesús juu¹³ guiuh¹³. Ca¹juúh²dsa: ―Di³hmah³ hning², Tiá³. Di³ ma²ca¹nengh²hning jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma²guiang³ báh³ jní² hi² nøngh²hning ca¹lah¹jǿ¹ jǿg³ juǿi²jni hning². Cónh¹jøng² ma²na²juúh¹jni lah¹jøng², mi³jøng² hé² dsa² tiogh³ ja³la² jǿg³ hi² lanh¹² hning² dsa² ca¹tsei¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mi³ma²na²juúh²dsa jǿg³ jøng², jøng² ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Lázaro! ¡Jú¹² ja³ná³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jøng² ca¹u¹hái¹ hlai³ niúh¹ tøg² hi² rø²liog¹dsa hmøah¹². Jøng² ca¹juúh² Jesús: ―Jein³ hmøah¹² rø²liog¹dsa. Di³ jøng² lé² dsánh¹dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jue¹² dsa² judío héi², dsa² ca¹dsi¹lé² quianh¹³ María, ca¹hé¹ jǿg³ quiah¹² Jesús, mi³ca¹jái¹dsa ca¹jmo¹ Jesús hi² ca¹jinh³ Lázaro. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Cónh¹jøng² ca¹ŋi¹lé² ca²dsiog³dsa ja³tiogh³ dsa² fariseo calah. Ca¹ŋi¹jmó²dsa jǿg³ ha²lah ca¹jmo¹ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jøng² ca¹jmo¹ juu¹³ jmi²dsa² quianh¹³ dsa² fariseo hi² ca¹túgh² dsa² ta³ quián¹² guøh¹². Jøng² ca¹juúh² dsa² héi²: ―¿Ha²lah jmó³ jniang³ quianh¹³ dsa² héi²? Di³ hliú² juu¹² juøh¹² jmo¹² dság¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ju³ná³ la³ne¹² jniang³, ca¹lah¹já¹ dsa² li¹hé² jǿg³ quiah¹² dsa² héi². Jøng² li¹hne² dsa² chian² Roma. Hén² dsa² héi² guøh¹² quián² jniang³ quianh¹³ juøi² ja³tén¹² jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jøng² ca¹juúh² Caifás, dsa² mi³lán¹³ ŋi¹jmó² jmai³ jøng²: ―Tsa¹ŋih³ hniah¹² ca¹lah¹jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tsa¹lø²leh¹³ hniah¹² hi² dsio¹ hi³méh¹ jón² jan² dsa² dsie¹² juøi². Mi³jøng² tsa¹dsø¹hén² ca¹lah¹jǿ¹ juøi² ja³tén¹² jniang³ ―ca¹juúh² Caifás. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A¹jáng¹ ju³ jǿg³ lë́² hŋiah¹² Caifás jǿg³ jøng². Diú¹³ ca¹jmo¹ dsǿa¹²dsa ca¹hǿ²dsa jǿg³ jøng² hi² jón² Jesús dsie¹² dsa² judío. Di³ hi² lán¹² Caifás ŋi¹jmó² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jø¹² bíh³ a¹jáng¹ ju³ jmáh¹lah huu¹³ quiah¹² juøi² jøng² jón² Jesús. Jón²dsa mi³jøng² lén²dsa cøng² chiúh³ dsa², ju³lah ca¹lah¹já¹ dsa² quián¹² Diú¹³ ni³tsø² ni³ja¹³ ta³cøng² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dsø¹juu¹² jøng² ca¹mi¹liág¹ dsa² ta³ héi² ca¹hnangh²dsa mai³¹ ha²lah jŋëh¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hi² jøng² tsa¹ma¹ca¹ŋøa¹ Jesús ja³tiogh³ dsa² judío. Ca¹u¹hái¹ báh³ dsa² ja³tén¹² Judea. Ca¹ŋó¹dsa cøng² juøi² neng¹² cøg¹² ja³ha¹chian² dsa² tiogh³, juøi² tsen² Efraín. Ja³jøng² ca¹túgh²dsa quianh¹³ dsa² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja¹quien¹³ tøa¹ jmai³ ta²høa³ quiah¹² dsa² judío. Jøng² ca¹ŋi¹lé² dsa² jue¹² juu¹² jøa³juøi² Jerusalén, dsa² hniu¹ li¹jŋió¹ niúh¹ jín³ hi² tøa¹ jmai³ ta²høa³. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jøng² ca¹hnah¹dsa Jesús ja³tsih¹³ guøh¹² juøh¹². Ca¹qui² ca¹ŋai¹dsa dsa² quianh¹³dsa. Ca¹juúh²dsa: ―¿He² lë́h² hniah¹²? ¿Tsa³ŋi¹jái² Jesús jmai³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma²ca¹jmo¹ juu¹³ jmi²dsa² quianh¹³ dsa² fariseo héh¹. Mi³jøng² ju³ná³ hein² dsa² ca¹lø¹ŋi¹² ha² tøah¹ ja³hiúg³ Jesús, jmo¹dsa jǿg³. Di³ jøng² lé² chiángh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jŋiéng² jmai³ jin³ hei¹² hi² tøa¹ jmai³ ta²høa³, ca¹ŋó¹ Jesús juu¹² Betania, ja³guǿ¹³ Lázaro, dsa² ca¹jmo¹ Jesús ca¹hiog² mi³ma²rø²jon¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja³jøng² ca¹jmo¹dsa cøng² má¹ hi² ca¹gǿh¹ Jesús. Ca¹tóh² Marta má¹ ni³ mesa. Hiúg³ Lázaro mesa quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jøng² ca¹ŋi¹quin¹² María ca²hnang¹³ litro nang³ ma²juøi² tsen² nardo. Hi² hmóh³. Ca¹tsǿng²dsa tai³ Jesús. Jøng² ca¹mi¹quính²dsa quianh¹³ jŋiu² dsi³dsa. Ca¹lah¹ta³cøng² dsi²néi² ca¹hǿi² dsí² ma²juøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jøng² ca¹juúh² Judas Iscariote, jan² dsa² quianh¹³ Jesús, dsa² hnë¹ Jesús jmai³ hiá¹ hiég¹: ");
INSERT INTO cpaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿He² løa¹ tsa¹ca¹hnai¹dsa nang³ ma²juøi² jøng² quianh¹³ guio¹ ŋi²lǿg² héh¹ cog³? Di³ jøng² mi³cuúh¹dsa dsa² ti²ŋié² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A¹jáng¹ ju³ hi² høa¹² dsǿa¹² Judas dsa² ti²ŋié² hi² ca¹juúh²dsa lah¹jøng². Dsa² høin² báh³ Judas. Dsa² héi² neng¹² gug² cog³ quiah¹² dsa² quianh¹³ Jesús. Ma²tan²dsa jŋíh²dsa tø¹ma¹méh¹ cog³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jøng² ca¹juúh² Jesús: ―¡Tsa¹hlanh¹³hning hio¹³! Ma²ca¹chiág²dsa hi² jøng² quiah¹²dsa. Mi³jøng² ma²na²tsǿng²dsa quieg¹jni niúh¹ hi³méh¹ hi² jón²jni. Ma²na²jmo¹dsa ju³jŋia¹³ hi² quiag¹dsa jní² dsio¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tiog¹³ báh³ quianh¹³ hniah¹² dsa² ti²ŋié². Di³ ha¹chi² li¹quianh¹³ hniah¹² jní² tiá² ni³ jmøi¹guǿi¹ la² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ca¹lø¹ŋi¹² jue¹² dsa² judío hi² hiúg³ Jesús jøa³juøi² Betania. Jøng² ca¹ŋi¹lé²dsa juu¹² jøng², hi² ŋi¹jan³dsa Jesús. Jø¹² bíh³ hniu¹dsa jë́²dsa Lázaro calah, dsa² ca¹jmo¹ Jesús ca¹hiog². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hi² jøng² ca¹jmo¹ juu¹³ jmi²dsa² cøng² jǿg³ hi² jŋëh¹dsa Lázaro calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Di³ jue¹² dsa² judío ma²tiogh³ jag¹³ quiah¹² Jesús huu¹³ quiah¹² Lázaro. Tsa¹ma¹tiogh³dsa quianh¹³ juu¹³ jmi²dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mi³ca¹jni¹ jmai³ siíh³ ca¹nǿng² dsa² jue¹² ca¹dsi¹lé² jmai³ ta²høa³ jǿg³ hi² hí¹ Jesús jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jøng² ca¹ŋi¹hieh³dsa Jesús chiuh³ juøi². Quin¹²dsa gug² moh¹³ tsǿn¹². Ca¹qui² ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Hiug¹² juanh¹² Diú¹³! ¡Hiug¹² dsiog¹ dsa² ca¹já¹ huu¹³ quiah¹² Diú¹³ juanh¹², dsa² lán¹² rai¹³ quián¹² dsa² israel! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jøng² ca¹dsanh¹² Jesús jan² búh³ meh². Ca¹gú²dsa cah³ jáh². Di³ jøng² li¹ti¹ jǿg³ la² hi² rø²juúh² si² quiah¹² Diú¹³: ");
INSERT INTO cpaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tsa¹jmóh³ hniah¹² ganh¹, hniah¹² dsa² chianh² juø³juøi² Sion. Jai³lah, ma²já¹² rai¹³ quiánh² hniah¹². Guǿ¹²dsa cah³ búh³ meh², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tsa¹ca¹lø¹ŋë́² dsa² quianh¹³ Jesús jǿg³ jøng² dsø¹juu¹². Cónh¹jøng² ca¹dsagh² dsǿa¹²dsa jǿg³ lǿa¹² ni³ si² mi³ma²ca¹ŋáh¹ Jesús juu¹² guiuh¹³. Jøng² ca¹lø¹lih¹³dsa ca¹lø¹ti¹ jǿg³ jøng² ja³cog²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jøng² dsa² mi³quianh¹³ Jesús jmai³ ja³ca¹jmo¹dsa hi² ca¹hiog² Lázaro, ca¹dsii¹ dsa² héi² jǿg³ ca¹lah¹jǿ¹ hi² ca¹jái¹dsa jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Huu¹³ jøng² ca¹ŋi³jŋiang¹³ dsa² jue¹² quiah¹² Jesús chiuh³ juøi². Di³ ca¹lø¹ŋi¹²dsa jǿg³ ca¹jmo¹ Jesús juu¹² juøh¹² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jøng² ca¹dsii¹ dsa² fariseo jǿg³ cu³guiog¹³dsa. Ca¹juúh²dsa: ―Jai³ di³ hniah¹². Ha¹chi² ma¹ne³ lé². Ca¹lah¹já¹ dsa² ma²ŋi²nio³ dsi³cah³ Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jøa³ dsa² ca¹dsi¹lé² ja³neng¹² jmai³ ma²tiogh³ mih² dsa² hløah¹² jǿg³ griego. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jøng² ca¹ŋi¹lé²dsa cøg¹² ja³tsenh¹³ Felipe, dsa² quianh¹³ Jesús chian² Betsaida, juøi² tén¹² Galilea. Jøng² ca¹tsáih¹dsa Felipe: ―Guiuh¹³, hneng² jnieh³ dsií³ jnieh³ jǿg³ quianh¹³ Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jøng² ca¹ŋó¹ Felipe. Ca¹ŋi¹tseih¹dsa Andrés. Ni³ jøng² ca¹ŋi¹lé²dsa ta³og¹dsa. Ca¹ŋi¹tseih¹dsa Jesús jǿg³ ca¹juúh² dsa² hløah¹² jǿg³ griego héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jøng² ca¹juúh² Jesús: ―Ma²tǿ² jmai³ ja³lén²jni dsa² hiug¹² juanh¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² dsa¹jon¹ møi¹jon² ju³ná³ tsa¹ca¹hóh¹ niúh¹ huø¹ ju³lah dsa¹hog¹dsa jan² dsa² ma²rø²jon¹³. Hi² jøng² báh³ dsa¹jon¹ mǿi², ju³ná³ ca¹hen¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jø¹² bíh³ ju³ná³ hein² dsa² dsa²jiag¹² dsǿa¹² jmáh¹lah jǿg³ ha²lah guú¹dsa dsio¹ ni³ jmøi¹guǿi¹ la², dsa² héi² jón². Cónh¹jøng² ju³ná³ hein² dsa² tsa¹høa¹² dsǿa¹² ha²lah guú¹dsa dsio¹ ni³ jmøi¹guǿi¹ la², dsa² héi² li¹chian² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ju³ná³ hein² dsa² hniu¹ mi¹ti¹ ne¹ jní², hniuh¹² ŋøa¹ dsa² héi² dsen¹³ cah¹ jní². Mi³jøng² li¹quianh¹³jni dsa² ha² ja³ma²hiúg³jni. Mi¹juanh¹² báh³ ti³ŋieh¹jni dsa² mi²ti¹ ne¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Chian²jni ju²hí³ dsøa¹². Tsa¹guiang³jni he² jǿg³ juøh¹³jni. ¿Dsio³¹ juǿi³jni ti³ŋieh¹jni: ¡Liag³ jní², Tiá³! Mi³jøng² tsa¹dsø¹ŋë²jni jmø³uai¹² na¹ bíh³ li¹chi² quieg¹jni?” Tsa¹dsio¹ juøh¹³jni lah¹jøng². Di³ huu¹³ jøng² báh³ ca¹guio¹jni, hi² jón² báh³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jøng² lah¹la² juǿi³jni dsa²: “Tiá³, jmóh³hning ha²lah hnøngh²hning. Mi³jøng² mi¹juanh¹² dsa² jmøi¹guǿi¹ hning²” ―ca¹juúh² Jesús. Jøng² ca¹hløah¹ Jmi² jniang³, dsa² guǿ¹² ŋi¹juǿi¹. Ca¹juúh²dsa: ―Ma²ca¹jmo¹ báh³ jní² lah¹jøng². Jø¹² bíh³ jmo¹ báh³ jní² calah jmai³ siíh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ca¹nǿng² dsa² tiogh³ ja³jøng² jǿg³ ca¹juúh² Jmi² jniang³. Ca²dsiog³dsa ca¹juúh²: ―Ca¹hein¹³ ŋíh¹ ―ca¹juúh²dsa. Jøng² ca²dsiog³dsa ca¹juúh²: ―Ma²na²hlanh¹ ángel Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jøng² ca¹juúh² Jesús: ―A¹jáng¹ ju³ jmáh¹lah jní² ma²na²hlaih¹ Jmi² jniang³. Hniah¹² báh³ ma²na²hlanh¹dsa. Mi³jøng² li¹ŋih³ hniah¹² ma²quianh¹³jni Jmi² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Di³ ma²tǿ² jmai³ ja³cang¹ Diú¹³ jǿg³ dsøg¹² quiah¹² dsa² jmøi¹guǿi¹. Ma²tǿ² jmai³ ja³dsa¹hén² jǿg³ quiah¹² dsa² hlanh³, dsa² jmo¹² héh¹ ni³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jøng² jmo¹³jni li¹quianh¹³jni dsa² jue¹², na³ma²ca¹tiang¹dsa jní² guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Quianh¹³ jǿg³ jøng² ca¹he¹ Jesús hi² jón²dsa ni³ crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jøng² ca¹juúh² dsa², ca¹tsáih¹dsa Jesús, mi³ca¹nǿng²dsa jǿg³ jøng²: ―Ma²ca¹néng³ jnieh³ jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³, hi² li¹chian² tiá² báh³ Cristo. ¿He² løa¹ juúh³hning tióg²dsa hning² crǿg¹³, hning² “dsa ma²lanh¹² dsa² jmøi¹guǿi¹ jian¹² jnieh³?” ¿Tsa³lanh¹²hning Cristo quián² jnieh³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jøng² ca¹juúh² Jesús: ―Hiúg³jni jín³ cu²hna² quianh¹³ hniah¹², jní² dsa² jmo¹² taih¹² juu¹² hi² dsi³noh¹ hniah¹² ja³dsio¹. Dsio¹ gu³noh¹² hniah¹² juu¹² he¹² jní². Mi³jøng² tsa¹lé² neng² juu¹² ja³gu³noh¹² hniah¹². Tsa¹ŋi¹²dsa ha² juu¹² ŋi²nio³dsa, ju³lah dsa² ŋi²nio³ ja³neng². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dsio¹ héh² hniah¹² jǿg³ ta³lah¹jmai³ ja³hé¹²jni hniah¹². Mi³jøng² lénh² hniah¹² dsa² ŋi¹² ―ca¹juúh²dsa. Mi³ma²ca¹juúh² Jesús jǿg³ jøng², jøng² ca¹u¹hái¹dsa jøa³ dsa² héi². Ca¹hmóh¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ju³ he² jín³ hliú² juu¹² juøh¹² ca¹jmo¹ Jesús ja³ta¹ni¹ dsa² judío, tsa¹ca¹hé¹ dsa² jue¹² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mi³jøng² li¹ti¹ jǿg³ la² rø²juúh² si² ca¹jmo¹ hlai³ Isaías, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih²: Mih² báh³ dsa² ma²ca¹hé¹ jǿg³ ca¹tséih³ jniang³ dsa², Juu¹³ jniang³. Mih² báh³ dsa² ca¹lø¹lih¹³ hning² dsa² ca¹jmoh³ juu¹² juøh¹², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hi² jøng² báh³ tsa¹lé² hé² dsa² héi² jǿg³. Di³ lah¹la² rø²juúh² si² quiah¹² hlai³ Isaías calah: ");
INSERT INTO cpaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ca¹jløa¹ Diú¹³ mø³ni³dsa. Mi³jøng² tsa¹jniuh¹²dsa. Ca¹jmo¹ Diú¹³ ca¹lø¹huh¹ dsi³dsa. Mi³jøng² tsa¹li¹ŋë́h² dsǿa¹²dsa. Mi³jøng² tsa¹jénh¹dsa. Mi³jøng² tsa¹liúg²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ca¹juúh² Isaías jǿg³ jøng² mi³ca¹lø¹lih¹³dsa hi² li¹juanh¹² Jesús tø¹chi²quë́¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tiog¹³ báh³ ca¹hé¹ ca²dsiog³ dsa² ta³ quián¹² guøh¹² jǿg³ quiah¹² Jesús. Di³ ha¹chi² ca¹mi¹léi¹³dsa lah¹jøng². Di³ hi² gan¹dsa dsa² fariseo. Gan¹dsa ju³ná³ tsa¹ma¹cuø¹ dsa² fariseo jǿg³ hi² dsø¹lé²dsa guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tsa¹ca¹mi¹léi¹³dsa hi² hé²dsa jǿg³. Di³ hiug¹² ca¹lø¹hniu¹dsa jǿg³ dsio¹ cuø¹ dsa² jmøi¹guǿi¹ jian¹²dsa ja³cog²dsa cónh¹ jín³ jǿg³ dsio¹ hi² mi³cuø¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jøng² ca¹hløah¹ Jesús tí², ca¹juúh²dsa: ―Ju³ná³ hein² dsa² hé² jǿg³ quieg¹ jní², a¹jáng¹ ju³ jmáh¹lah jǿg³ quieg¹ jní² hé²dsa. Di³ ma²hé²dsa jǿg³ quiah¹² ti³ŋieh¹jni, dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ju³ná³ hein² dsa² ma²cuai¹² jní², dsa² héi² ma²cue¹² ti³ŋieh¹jni calah, dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ca¹guio¹jni jmøi¹guǿi¹. Mi³jøng² lán¹²jni ju³lah lǿa¹² si² taih¹² jmøi¹guǿi¹. Mi³jøng² tsa¹ma¹tiogh³ dsa² jmøi¹guǿi¹ ja³neng², ju³lah dsa² hé² jǿg³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ju³ná³ hein² dsa² ca¹nǿng² jǿg³ quieg¹ jní², jøng² ha¹chi² ca¹mi¹ti¹dsa jǿg³, ha¹chi² cuǿ¹³jni dsa² héi² dsag³. Di³ ha¹chi² ca¹guio¹jni hi² cuǿ¹³jni dsa² jmøi¹guǿi¹ dsag³. Ca¹guio¹jni hi² log³jni dsa². ");
INSERT INTO cpaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Di³ jøng² ta¹canh¹³ báh³ dsa² dsag³, ju³lah dsa² tsa¹hniang¹ jní², dsa² tsa¹hniu¹ jǿg³ quieg¹jni. Jǿg³ ma²ca¹juúh²jni jøng² jmo¹ ta¹canh¹³dsa dsag³ na³ma²ca¹tóh² jø² jmai³ quiah¹² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Di³ ha¹chi² ma²ca¹juúh¹jni jǿg³ quieg¹jni hŋiéng¹jni. Jmi² jniang³ báh³ ca¹jmo¹ héh¹, dsa² ca¹tsei¹ jní², he² jǿg³ juøh¹³jni, he² jǿg³ hløah¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jøng² ma²guiang³jni jmo¹² héh¹ quiah¹²dsa hi² li¹chian² dsa² jmøi¹guǿi¹ tiá². Hi² jøng² juøh¹²jni ca¹lah¹cónh¹ lǿa¹² héh¹ ca¹jmo¹ Jmi² jniang³ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ca¹tǿ² ja³lé² ti³juøh¹² jmai³ ta²høa³. Ma²ŋi¹² Jesús hi² ma²tǿ² ja³gu¹hái¹dsa jmøi¹guǿi¹, hi² dsánh¹dsa ja³guǿ¹³ Jmi² jniang³. Hnio¹ Jesús dsa² quián¹²dsa, dsa² tiogh³ jmøi¹guǿi¹. Jøng² ca¹mi¹léi¹³dsa ha²cónh¹ té¹² ja³hniang¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma²tiogh³dsa mesa. Ma²ca¹jmo¹ dsa² hlanh³ dsǿa¹² Judas, ja³ŋiúh³ Simón Iscariote, hi² hnë¹dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma²ŋi¹² Jesús hi² ca¹cuø¹ Jmi² jniang³ ca¹lah¹jǿ¹ bí² quiah¹²dsa. Ma²ŋi¹²dsa juu¹² ja³guǿ¹³ dsa² héi² ca¹já¹dsa. Jø¹² bíh³ ja³jøng² dsánh¹dsa calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ca¹rón² Jesús mesa ja³mi³gøah¹²dsa. Ca¹li²dsa hmøah¹² dsǿ² coh¹³. Jøng² ca¹can¹dsa cøng² toalla. Ca¹cøin¹dsa togh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jøng² ca¹tieh¹dsa jmøi² cøng² ŋí³ teg². Ca¹mi¹liág¹dsa ca¹rang¹dsa tai³ dsa² guia¹tón². Jøng² ca¹mi¹quính²dsa quianh¹³ toalla rø²hŋieng¹² togh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mi³ca¹tǿ² ja³rang¹ Jesús tai³ Simón Pedro, jøng² ca¹juúh²dsa: ―¿Hi³ rángh³hning tai¹ jní² calah, Juu¹³ jniang³? ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jøng² ca¹juúh² Jesús: ―Tsa¹ŋë́h²hning ta¹na¹ he² løa¹ jmo¹²jni lah¹la². Cónh¹jøng² li¹ŋë́h² báh³ hning² tø¹chi³quë́¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jøng² ca¹juúh² Pedro: ―Tsa¹lǿih² jmai³ rángh³hning tai¹ jní². Tsa¹ca¹të́² dsa² juanh¹² rang¹ tai³ dsa² meh² ―ca¹juúh² Pedro. Jøng² ca¹juúh² Jesús: ―Ju³ná³ tsa¹rang¹³jni taih³hning, tsa¹lénh²hning dsa² quian¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jøng² ca¹juúh² Simón Pedro: ―A¹jáng¹ ju³ jmáh¹lah tai¹jni rángh³hning, chi²júh² lah¹jøng² lǿa¹², Juu¹³ jniang³. Rángh³hning gug¹jni quianh¹³ dse¹jni calah ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jøng² ca¹juúh² Jesús: ―Ju³lah dsa² lah¹ma²na²lóh¹ tsa¹ma¹hniuh¹² hi² rang¹dsa ta³jan²dsa. Jmáh¹lah tai³ báh³ dsa² hniuh¹² rang¹dsa. Mi³jøng² lé² ti³ja¹dsa. Ti³jah¹ báh³ hniah¹² ja³cog² Diú¹³. Cónh¹jøng² tsa¹lǿa¹² lah¹jøng² ca¹lah¹jáh¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ca¹juúh² Jesús jǿg³ jøng² hi² tsa¹ti³ja¹ ca¹lah¹já¹ dsa² guia¹tón². Di³ ma²ŋi¹² báh³ Jesús hein² dsa² hnai¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jøng² mi³ma²na²rang¹ Jesús tai³ dsa² guia¹tón², jøng² ca¹cáih¹dsa calah tsǿnh³. Ca¹guú²dsa calah mesa. Jøng² ca¹juúh²dsa: ―¿Lø³ŋë́h² hniah¹² he² hi² ma²na²jmo¹jni ja³cogh² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tøah¹² hniah¹² jní² Tøa¹² quianh¹³ Juuh² hniah¹². Dsøg¹² báh³ jǿg³ juúh² hniah¹². Di³ lah¹dsóh² dsa² héi² báh³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jní² báh³ Tøa¹² quiánh² hniah¹², quianh¹³ Juuh² hniah¹². Ma²na²rang¹jni taih³ hniah¹². Hi² jøng² ma²ŋih³ hniah¹² hi² hniuh¹² rángh³ hniah¹² tai³ rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma²na²he¹jni ha²lah jmóh³ hniah¹². Hniuh¹² jmóh³ hniah¹² ju³lah ma²na²jmo¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Ha¹chi² lán¹² dsa² jmo¹² ta³ dsa² juanh¹² cónh¹ jín³ juu³dsa. Ha¹chi² lán¹² dsa² ŋøa¹² man²da¹³ dsa² juanh¹² cónh¹ jín³ dsa² ca¹tsei¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ju³ná³ ŋë́h² hniah¹² jǿg³ jøng², ju³ná³ mi³tih³ hniah¹² jǿg³, jøng² hioh¹² jénh² hniah¹² lé². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","A¹jáng¹ ju³ ca¹lah¹jáh¹ hniah¹² hia¹²jni. Ma²guiang³jni hein² dsa² ma²ca¹quiah³jni. Cónh¹jøng² hniuh¹² li¹ti¹ jǿg³ la² hi² rø²juúh² si²: “Jan² dsa² ma²ca¹gǿh¹ quianh¹³ jní², ma²hiag³dsa jní²”, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jǿg³ jøng² juǿi²jni hniah¹² ta¹na¹, niúh¹ jín³ hi² li¹ti¹. Mi³jøng² héh² hniah¹² hi² lán¹²jni jong¹² Diú¹³ na³ma²ca¹jaih³ hniah¹² ca¹lø¹ti¹ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Lah¹dsóh² juǿi²jni hniah¹²: Ju³ná³ hein²dsa ca¹hie¹ dsa² ca¹tsë́²jni, dsa² héi² ma²ca¹hiei¹ jní² calah. Ju³ná³ ca¹hiei¹dsa jní² jøng², jø¹² bíh³ lah¹jøng² ca¹hie¹dsa dsa² ca¹tsei¹ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ca¹hǿ² dsǿa¹² Jesús mi³ma²na²juúh²dsa jǿg³ jøng². Ni³ jøng² ca¹juúh²dsa: ―Lah¹dsóh² juǿi²jni hniah¹²: Jan² hniah¹² hnëh¹³ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jøng² ca¹jë́² dsa² guia¹tón² ju³roh¹³. Tsa¹ŋi¹²dsa hein² dsa² hia¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jøng² mi³guǿ¹³ jan² dsa² guia¹tón² cog² Jesús. Hiúg¹² hnio¹ Jesús dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jøng² ca¹tǿh¹ Simón Pedro dsa² héi². Ca¹juúh²dsa: ―¿Hein² dsa² héi², dsa² hia¹² Jesús jǿg³ jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jøng² ca¹juúh² dsa² guǿ¹² cog² Jesús: ―¿Hein² dsa² hiah²hning, Juu¹³ jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jøng² ca¹juúh² Jesús: ―Dsa² héi² báh³ héi², dsa² cuǿ¹³jni jneh³ hi³ŋíh¹ la² na³ma²ca¹mi³hlí³jni quianh¹³ jmøah¹³ ―ca¹juúh²dsa. Jøng² ca¹mi¹hlí² Jesús ca²jneh³ hi³ŋíh¹. Ca¹cuúh¹dsa Judas, ja³ŋiúh³ Simón Iscariote. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jøng² ca¹hí¹ dsa² hlanh³ dsǿa¹² Judas, mi³ca¹gǿh¹ dsa² héi² jneh³ hi³ŋíh¹ jøng². Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Judas: ―¡Ta³tí³ jmo³ hi² hnøngh²hning jmóh³! ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ca¹lah¹jin³ jan² dsa² ti³gøah¹² quianh¹³ Jesús tsa¹ca¹lø¹ŋë́² jǿg³ jøng², hi² ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Lë́² ca²dsiog³ dsa² héi² hi² ca¹tsei¹ Jesús juu¹² ja³dsø¹lie¹² Judas he² hi² hniuh¹² ta³lah¹jmai³ ta²høa³, ho¹ ju³ ja³dsø¹cuøh¹²dsa dsa² ti²ŋié² cog³. Di³ neng¹² gug² Judas cog³ quiah¹² dsa² guia¹tón². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jøng² ca¹u¹hái¹ Judas mi³ma²na²hiei¹dsa jneh³ hi³ŋíh¹ jøng². Ma²neng² mi³ca¹u¹hái¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mi³ca¹u¹hái¹ Judas, jøng² ca¹juúh² Jesús: ―Na¹ jín³ li¹léi¹³ hi² lán¹²jni dsa² juanh¹², jní² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹². Jmo¹²jni hi² mi¹juanh¹² dsa² jue¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Huu¹³ quieg¹ jní² báh³ mi¹juanh¹² dsa² jue¹² Diú¹³. Jøng² jmo¹ Diú¹³ hi² mi¹juanh¹² dsa² jue¹² jní² calah. Ta³tí³ la² báh³ jmo¹ Diú¹³ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hniah¹² dsa² guia¹tón², dsa² quian¹jni, ha¹chi² ma¹jan³jni hi² uú² quianh¹³ hniah¹². Hnangh¹³ hniah¹² jní². Cónh¹jøng² juǿi²jni hniah¹² ju³lah jǿg³ ca¹juǿi²jni dsa² judío: “Tsa¹lé² gu³noh¹² hniah¹² juu¹² ja³neh¹³jni,” juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cuø¹²jni lei¹³ hmë́² ja³cogh² hniah¹²: ¡Ju³li¹hnóh¹ hniah¹² rúh² hniah¹²! Ju³lah hnó¹jni hniah¹², lah¹jøng² báh³ hniuh¹² li¹hnóh¹ hniah¹² rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Li¹lih¹³ ca¹lah¹já¹ dsa² jmøi¹guǿi¹ hi² lanh¹² hniah¹² dsa² quian¹jni, ju³ná³ hnóh¹ hniah¹² rúh² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jøng² ca¹ŋǿh¹ Simón Pedro Jesús. Ca¹juúh²dsa: ―¿Ha² tøah¹ guǿnh³hning, Juu¹³ jniang³? ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Tsa¹lé² góh³hning ta¹na¹ juu¹² ja³neh¹³jni. Ta¹chi³quë́¹ báh³ góh³hning ja³jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jøng² ca¹juúh² Pedro calah: ―¿He² løa¹ tsa¹lé² nei¹³jni quianh¹³ hnéng¹ ta¹na¹, Juu¹³ jniang³? Hiug² dsøa¹jni hi² jón²jni huu¹³ quiánh²hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jøng² ca¹juúh² Jesús: ―¿Lah³dsóh² hiug² hoh¹²hning jónh² huu¹³ quieg¹jni? Lah¹dsóh² juǿi²jni hning²: Niúh¹ jín³ hi² ho¹ chiih³, juúh³hning hnaih² rón² hi² tsa¹cuaih¹²hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Tsa¹jmo² ju²hí³ dsøa¹². Héh² báh³ hniah¹² jǿg³ quiah¹² Diú¹³. Ju³héh³ hniah¹² jǿg³ quieg¹ jní² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jøg² báh³ ja³guǿ¹³ ti³ŋieh¹jni, ja³li¹tiógh¹ dsa² jue¹². Ju³ jøng² tsa¹mi³lǿa¹³ lah¹jøng², mi³juǿi³jni hniah¹². Di³ huu¹³ jøng² báh³ neh¹³jni, hi² ŋi³jmo³jni ju³jŋia¹³ cøng² ja³gu³tiogh¹² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na³ma²ca¹løa¹ cu²rø² ja³gu³tiogh¹² hniah¹², jøng² guiogh¹³jni calah, hi² ŋi³tei¹jni hniah¹². Di³ jøng² gu³tiogh¹² hniah¹² quianh¹³ jní² ja³guø³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma²ŋih³ báh³ hniah¹² ha² juu¹² ja³neh¹³jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jøng² ca¹juúh² Tomás: ―Tsa¹ne³ jnieh³ ha² tøah¹ guǿnh³hning, Juu¹³ jniang³. ¿Ha² bíh³ láh² ne³ jnieh³ juu¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jøng² ca¹juúh² Jesús: ―Jní² báh³ dsa² co¹² juu¹². Jní² báh³ juøh¹² jǿg³ dsøg¹². Jní² báh³ cuø¹² ju²bí² hi² li¹chian² dsa² jmøi¹guǿi¹ tiá² ja³cog² Diú¹³. Ha¹chian² dsa² dsánh¹ ja³quiah¹³ ti³ŋieh¹jni ju³ná³ tsa¹hé²dsa jǿg³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ju³ná³ ca¹lø¹cuaih¹² hniah¹² jní² cu²rø², jøng² ma²cueh¹² hniah¹² ti³ŋieh¹jni. Na¹ báh³ ma²na²lø¹cueh¹³ hniah¹² ti³ŋieh¹jni. Ma²na²janh³ báh³ hniah¹² dsa² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jøng² ca¹juúh² Felipe: ―Ju³ne¹³ jnieh³ ti³ŋieih¹²hning, Juu¹³ jniang³. Cónh¹jøng² báh³ hi² hneng² jnieh³ ―ca¹juúh² Felipe. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jøng² ca¹juúh² Jesús: ―Ma²ni³ŋó¹³ jmai³ ŋøa¹²jni quianh¹³ hniah¹². ¿Tsa³ma²cuaih¹²hning jní², Felipe? Ju³lah dsa² jǿi² jní², jë́² báh³ dsa² héi² ti³ŋieh¹jni. ¿He² løa¹ juúh²hning hi² hnøngh² hniah¹² janh³ hniah¹² ti³ŋieh¹jni? ");
INSERT INTO cpaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tsa³héh² hniah¹² hi² quianh¹³jni ti³ŋieh¹jni, jø² hi² quianh¹³ ti³ŋieh¹jni jní²? A¹jáng¹ ju³ jǿg³ quieg¹ hŋiéng¹jni hi² juǿi²jni hniah¹². Ti³ŋieh¹jni, dsa² quianh¹³jni, dsa² héi² báh³ dsa² jmo¹² héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ju³héh³ hniah¹² hi² quianh¹³jni ti³ŋieh¹jni, hi² quianh¹³ ti³ŋieh¹jni jní². Ju³ná³ tsa¹héh² hniah¹² jǿg³ hi² juøh¹³jni, ju³héh³ hniah¹² jǿg³ quianh¹³ hi² jmo³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jǿg³ dsøg¹² juǿi²jni hniah¹²: Ju³lah dsa² hé² jǿg³ quieg¹ jní², jmo¹ dsa² héi² ju³lah jmo¹² jní². Ma¹dsio¹² jín³ hi² jmo¹dsa cónh¹ jín³ hi² ca¹jmo¹ jní². Di³ neh¹³jni ja³quiah¹³ ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ca¹lah¹jǿ¹ hi² mǿh³ hniah¹² quianh¹³ jní², cuø¹³ báh³ jní². Di³ jøng² li¹juanh¹² ti³ŋieh¹jni quianh¹³ hi² jmo¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Cuø¹³ báh³ jní² ca¹lah¹jǿ¹ hi² mǿh³ hniah¹² quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Ju³ná³ hnángh¹ hniah¹² jní², mi³tih³ hniah¹² héh¹ hi² jmo³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Møa¹²jni ja³cog² ti³ŋieh¹jni hi² tse¹dsa jan² dsa² siáh², dsa² mi¹hog¹³ hniah¹², dsa² li¹quianh¹³ hniah¹² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jmi²dsí² han¹³ quiah¹² Diú¹³ báh³ dsa² héi², dsa² juúh² jǿg³ dsøg¹². Tsa¹tiúh¹ dsa² tsa¹cue¹² Diú¹³ tógh¹ cøng² jǿg³ quianh¹³ dsa² héi². Di³ tsa¹cue¹²dsa dsa² héi². Cueh¹² báh³ hniah¹² dsa² héi². Di³ dsa² quianh¹³ hniah¹² báh³ héi², dsa² jian¹ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ha¹chi² guianh¹³jni hniah¹² cu³guiogh¹³ hniah¹². Guiogh¹³ báh³ jní² calah ja³tiogh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mih² jín³ jø² hei¹² hi² lé² tsa¹ma¹jǿi² dsa² jmøi¹guǿi¹ jní². Cónh¹jøng² jaih³ báh³ hniah¹² jní². Hi² chian² jní² báh³ jmo¹² hi² li¹chianh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jmai³ jøng² li¹ŋih³ hniah¹² hi² quianh¹³ ti³ŋieh¹jni jní², hi² quianh¹³ hniah¹² jní², jø² quianh¹³ jní² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dsa² héi² báh³ dsa² lah¹dsóh² hniang¹ jní², ju³lah dsa² ma²chinh¹² jǿg³ ca¹jmo¹jni, dsa² mi²ti¹ jǿg³. Jøng² li¹hnio¹ ti³ŋieh¹jni ca¹lah¹já¹ dsa² hniang¹ jní². Jø¹² bíh³ li¹hnó¹jni dsa² héi². Jmo¹³jni li¹cuai¹² dsa² héi² jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jøng² ca¹juúh² Judas (héi¹ ju³ Judas Iscariote héi²): ―¿He² løa¹ jmóh³hning jmáh¹lah jnieh³ báh³ dsa² li¹cue¹² hning², Juu¹³ jniang³? ¿He² løa¹ tsa¹jmóh³hning li¹cuai¹² dsa² siáh² calah? ―ca¹juúh² Judas. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jøng² ca¹juúh² Jesús: ―Ju³lah dsa² hniang¹ jní², mi¹ti¹dsa jǿg³ quieg¹jni. Jøng² li¹hniang¹ ti³ŋieh¹jni quiah¹²dsa. Jní² quianh¹³ ti³ŋieh¹jni, li¹quiinh¹³ jnieh³ dsa² héi² tiá². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ju³lah dsa² tsa¹hniang¹ jní², tsa¹mi¹ti¹dsa jǿg³ quieg¹jni. A¹jáng¹ ju³ jǿg³ quieg¹jni hi² juǿi²jni hniah¹² calah. Jǿg³ quiah¹² ti³ŋieh¹jni, dsa² ca¹tsei¹ jní², báh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Juǿi²jni hniah¹² jǿg³ la² ta³lah¹hiúg³jni quianh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cónh¹jøng² he¹ dsa² mi¹hog¹³ héi² ca¹lah¹jǿ¹ jǿg³, jmi²dsí² quiah¹² Diú¹³ héi², dsa² tse¹ ti³ŋieh¹jni huu¹³ quieg¹ jní². Dsa² héi² báh³ jmo¹ hi² dsiagh² hoh¹² hniah¹² ca¹lah¹jǿ¹ jǿg³ ma²ca¹juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jmo¹³jni hi² túgh³ hniah¹² ju²hiúg¹ dsøa¹² na³ma²ca¹ŋáh¹jni. Lah¹jøng² li¹chianh² hniah¹² ju²hiúg¹ dsøa¹² ju³lah lǿa¹² dsøa¹jni hŋiéng¹jni. Tsa¹chian² dsa² jmøi¹guǿi¹ tiúh¹ jmo¹ lah¹jøng². Hi² jøng² tsa¹jmo² ju²hí³ dsøa¹². Tsa¹jmóh³ hniah¹² ganh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma²na²nengh¹² hniah¹² jǿg³ na²juúh¹jni hi² neh¹³jni, hi² guiogh¹³jni calah ja³tiogh³ hniah¹². Ju³ jøng² lah¹dsóh² hnángh¹ hniah¹² jní², mi³li¹hiug² hoh¹² hniah¹² jǿg³ hi² neh¹³jni ja³guǿ¹³ ti³ŋieh¹jni. Di³ dsa² juanh¹² báh³ ti³ŋieh¹jni cónh¹ jín³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jǿg³ ná¹² ma²na²juǿi²jni hniah¹² niúh¹ jín³ hi² li¹ti¹. Mi³jøng² héh² hniah¹² jǿg³ quieg¹jni na³ma²ca¹lø¹ti¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ha¹chi² jǿg³ ma¹dsio¹² ma¹dsií¹³jni quianh¹³ hniah¹². Di³ ma²já¹² dsa² hlanh³, dsa² jmo¹² héh¹ ni³ jmøi¹guǿi¹. Ha¹chi² bí² chi² quiah¹² dsa² héi² ja³cog² jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Cónh¹jøng² jmo¹² báh³ jní² ju³lah ma²ca¹tsáih¹ Jmi² jniang³ jní². Mi³jøng² li¹ŋi¹² dsa² jmøi¹guǿi¹ hi² hnó¹jni Jmi² jniang³. ¡Nung² hniah¹²! ¡Ma¹dsǿg³! ");
INSERT INTO cpaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Lán¹²jni ju³lah lǿa¹² chiúh³ uøin² gu²jøah¹³. Lán¹² ti³ŋieh¹jni ju³lah lǿa¹² dsa² jmo¹ hí³ chiúh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Quiúh²dsa guh¹² chiúh³ uøin² jøng², ju³lah guh¹² tsa¹hai¹ mǿi². Ju³lah guh¹² hai¹ mǿi² jøng², lánh¹dsa mih² nih¹³. Mi³jøng² lé² ti³jai¹. Mi³jøng² hai¹ ma¹dsio¹² hi³méh¹ mǿi². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma²lanh¹² hniah¹² dsa² ti³ja¹, hi² ca¹jmo¹ jǿg³ ca¹hé¹jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cøng² hi² li¹quianh¹³ jní² hniah¹². Mi³jøng² li¹quianh¹³ hniah¹² jní². Di³ tsa¹lé² hai¹ mǿi² cøng² guh¹² uøin² gu²jøah¹³ ju³ná³ tsa¹dsi¹² quianh¹³ chiúh³. Lah¹jøng² báh³ lǿa¹² quiánh² hniah¹². Tsa¹lé² dsa¹jon¹ jǿg³ quieg¹jni ja³cogh² hniah¹², ju³ná³ tsa¹quianh¹³ hniah¹² jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Jní² lán¹² chiúh³. Hniah¹² dsa² ni³lanh¹² guh¹² quieg¹jni. Ju³ná³ ma²quiangh¹³ jniang³, jøng² dsa¹jon¹ jǿg³ quieg¹jni ja³cogh² hniah¹². Di³ tsa¹tiah¹ hniah¹² mi³tih³ hniah¹² jǿg³ quieg¹jni, ju³ná³ tsa¹quiangh¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ju³ná³ hein² dsa² tsa¹quianh¹³ jní², lán¹² dsa² héi² ju³lah lǿa¹² guh¹² hi² guieh¹dsa, guh¹² hi² li¹quing². Di³ jøng² dsii¹dsa ja³jøn¹dsa quianh¹³ si². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ju³ná³ cøng² hi² li¹quianh¹³ jní² hniah¹², hi² tsa¹dsø¹hén² hoh¹² hniah¹² jǿg³ ma²ca¹hé¹jni hniah¹², lé² báh³ mǿh³ hniah¹² he² hi² hnøngh² hniah¹². Di³ jøng² ŋieh¹ báh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lah¹jøng² báh³ jmo¹² li¹juanh¹² ti³ŋieh¹jni ju³ná³ ca¹ŋi¹jon¹ jǿg³ quieg¹jni ja³cogh² hniah¹². Di³ jøng² li¹léi¹³ hi² lanh¹² hniah¹² dsa² quian¹jni lah¹dsóh². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Lah¹jøng² báh³ hnó¹jni hniah¹² ju³lah hniang¹ ti³ŋieh¹jni jní². Cøng² hi² ŋi³nioh³ hniah¹² juu¹² ja³hnó¹jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Di³ cøng² juu¹² jøng² ŋi³nioh³ báh³ hniah¹², ju³ná³ mi³tih³ hniah¹² jǿg³ ca¹juǿi²jni hniah¹². Di³ lah¹jøng² báh³ ma²ca¹mi³ti³jni jǿg³ ca¹tsáih¹ ti³ŋieh¹jni jní². Di³ jøng² ŋøa¹²jni juu¹² ja³hniang¹dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Jǿg³ la² juǿi²jni hniah¹², mi³jøng² li¹hiug² hoh¹² hniah¹² ju³lah hiug² dsøa¹jni hŋiéng¹jni. Mi³jøng² lé² hiug¹² hioh¹² jénh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lah¹la² báh³ jǿg³ juǿi²jni hniah¹²: Ju³li¹hnóh¹ hniah¹² rúh² hniah¹², ju³lah hnó¹jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hiug¹² jín³ hi² hnio¹ dsa² jmøi¹guǿi¹ dsa² jenh²dsa quianh¹³ ju³ná³ hiug² dsǿa¹²dsa jón²dsa huu¹³ quiah¹² dsa² héi². Ha¹chian² dsa² jmøi¹guǿi¹ hnio¹ roh¹³ ma¹dsio¹² cónh¹ jín³ dsa² hiug² dsǿa¹² lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hniah¹² báh³ dsa² lanh¹² dsa² jenh²jni quianh¹³, ju³ná³ mi³tih³ hniah¹² jǿg³ ma²ca¹juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ha¹chi² ma¹tǿa¹³jni hniah¹² dsa² jmoh² ta³ quieg¹jni. Di³ tsa¹ŋi¹² dsa² jmo¹² ta³ ha²lah jmo¹² juu³dsa. Ma²tǿa¹jni hniah¹² dsa² jenh²jni quianh¹³. Di³ ma²ca¹hé¹jni hniah¹² ca¹lah¹jǿ¹ jǿg³ hi² ca¹tsáih¹ ti³ŋieh¹jni jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A¹jáng¹ ju³ hniah¹², ca¹hnangh¹² jní². Jní² báh³ ca¹quiah³ hniah¹². Jøng² ca¹cuǿ¹jni hniah¹² ta³ hi² gu³jmoh³ hniah¹² hi² dsa¹jon¹ jǿg³ quieg¹jni. Di³ jøng² tsa¹dsa¹hén² ta³ jøng² quiánh² hniah¹². Mi³jøng² cuø¹ ti³ŋieh¹jni ca¹lah¹jǿ¹ hi² mǿh³ hniah¹² huu¹³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lah¹la² juǿi²jni hniah¹²: Ju³li¹hnóh¹ hniah¹² rúh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ju³ná³ ca¹lø¹hian¹³ dsa² jmøi¹guǿi¹ hniah¹², jøng² ma²ŋih³ báh³ hniah¹² hi² ca¹lø¹hiag¹³dsa jní² lah¹ni³ cónh¹ jín³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ju³ jøng² ma²quianh¹³ hniah¹² dsa² jmøi¹guǿi¹ jianh¹² hniah¹², mi³li¹hnio¹ báh³ dsa² héi² hniah¹², ju³lah hnio¹dsa dsa² quianh¹³dsa. Cónh¹jøng² ha¹chi² ma²quianh¹³ hniah¹² dsa² héi². Di³ ma²ca¹quiah³ jní² hniah¹². Hi² jøng² báh³ hian¹³ dsa² héi² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ju³dsiagh² hoh¹² hniah¹² jǿg³ ma²ca¹juǿi²jni hniah¹²: Ha¹chi² juanh¹² dsa² jmo¹² ta³ cónh¹ jín³ juu³dsa. Jøng² ma²ŋih³ hniah¹² hi² jmóh¹dsa hniah¹², ju³ná³ ma²ca¹jmógh²dsa jní². Jøng² nang¹ báh³ dsa² jǿg³ quiánh² hniah¹² calah, ju³ná³ ma²ca¹nǿng²dsa jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hi² jøng² báh³ jmóh¹ dsa² jmøi¹guǿi¹ hniah¹² ni³ huu¹³ quieg¹ jní². Di³ tsa¹cue¹²dsa dsa² ca¹tsei¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ha¹chi² mi³ta¹canh¹³dsa dsag³ ju³ jøng² tsa¹ca¹hé¹jni dsa² jǿg³. Cónh¹jøng² ha¹chi² jǿg³ chi² li¹juúh²dsa cónh¹ lǿa¹² la². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ju³lah dsa² hiag¹³ jní², jø¹² bíh³ hian¹³ dsa² héi² ti³ŋieh¹jni calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ha¹chi² dsag³ mi³li¹chi² quiah¹²dsa, ju³ jøng² hi² tsa¹ca¹jái¹dsa juu¹² juøh¹² ca¹jmo¹ jní², juu¹² juøh¹² tsa¹tiúh¹ dsa² siáh² jmo¹. Ma²ca¹jái¹ báh³ dsa² hi² jøng². Cónh¹jøng² hiag¹³ báh³ dsa² jní² quianh¹³ ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lah¹jøng² báh³ lǿa¹². Mi³jøng² li¹ti¹ jǿg³ la², hi² rø²juúh² si² quiah¹² Diú¹³: “Hiag¹³dsa jní², hi² la³hiag¹³dsa,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Jøng² na³ma²ca¹guøn¹ dsa² mi¹hog¹³ hniah¹², mi¹dsøg¹² dsa² héi² jǿg³ quieg¹ jní². Dsa² héi² tsë́³jni, dsa² cuan¹ Jmi² jniang³. Jmi²dsí² han¹³ quiah¹² Diú¹³ báh³ dsa² héi², dsa² té¹² jag³. ");
INSERT INTO cpaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jø¹² bíh³ mi³dsøgh¹³ hniah¹² jǿg³ quieg¹jni calah ja³ta¹ni¹ dsa² jmøi¹guǿi¹. Di³ ca¹lø¹quianh¹³ hniah¹² jní² cónh¹ jmai³ lah¹ni³ mi³ca¹mi³liág¹³jni ca¹he¹jni jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Jǿg³ la² juǿi²jni hniah¹². Di³ jøng² tsa¹tiuh¹³ hniah¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tsa¹cuø¹ dsa² jmøi¹guǿi¹ jianh¹² hniah¹² jǿg³ hi² gu³noh¹² hniah¹² guøh¹² quiah¹²dsa. Lah¹dsóh² dsiég¹³ báh³ jmai³ ja³lë́² dsa² jmøi¹guǿi¹ jianh¹² hniah¹² hi² mi¹ti¹dsa ni³ Diú¹³ ju³ná³ ca¹mi¹dsian¹²dsa hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jmo¹dsa lah¹jøng². Di³ tsa¹lǿih² jmai³ ca¹lø¹cue¹²dsa ti³ŋieh¹jni quianh¹³ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cónh¹jøng² ma²na²juǿi²jni hniah¹² jǿg³ la². Di³ jøng² dsiagh¹³ hoh¹² hniah¹² ca¹juǿi²jni hniah¹² na³ma²tǿ² ja³lé² lah¹jøng². ’Tsa¹ca¹juǿi²jni hniah¹² jǿg³ la² lah¹ni³. Di³ mi³ŋøa¹²jni quianh¹³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jøng² ma²tǿ² ja³neh¹³jni ja³guǿ¹³ dsa² ca¹tsei¹ jní². Jin³ jan² hniah¹² tsa¹ma²ca¹ŋaih³ ha² tøah¹ ja³neh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Cónh¹ ma²quinh³ hniah¹² ju²hí³ dsøa¹². Di³ ma²na²juǿi²jni hniah¹² hi² neh¹³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lah¹dsóh² juǿi²jni hniah¹²: Dsio¹ báh³ lé² quianh¹³ hniah¹² hi² neh¹³jni. Di³ ha¹chi² jií¹ jmi²dsí² han¹³, dsa² mi¹hog¹³ hniah¹² héi², ju³ná³ tsa¹neh¹³jni. Jøng² tsë́³jni dsa² héi² juu¹² ja³tiogh³ hniah¹² na³ma²ca¹ŋáh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na³ma²guønh¹² dsa² héi², jmo¹ dsa² héi² hi² li¹ŋi¹² dsa² jmøi¹guǿi¹ hi² ti³re²dsa dsag³. He¹dsa hein² dsa² lán¹² dsa² lah¹dsóh² dsiog¹, hein² dsa² ta¹canh¹³ dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dsag³ re² dsa² jmøi¹guǿi¹. Di³ tsa¹hé²dsa jǿg³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jøng² li¹ŋi¹²dsa hi² lán¹²jni lah¹dsóh² dsa² dsiog¹. Di³ neh¹³jni ja³guǿ¹³ ti³ŋieh¹jni. Ja³tsa¹ma¹jaih³ hniah¹² jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Li¹ŋi¹²dsa hein² dsa² ta¹canh¹³ dsag³. Di³ ma²rø²canh¹² dsa² hlanh³ dsag³, dsa² qui²jian¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ma¹dsio¹² jǿg³ chi² hi² li¹juǿi³jni hniah¹². Di³ tsa¹li¹ŋë́h² hniah¹² jǿg³ jøng² na¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na³ma²guønh¹² jmi²dsí² han¹³, dsa² té¹² jag³, heh¹dsa hniah¹² jǿg³ dsøg¹². A¹jáng¹ ju³ jǿg³ quiah¹² hŋiah¹²dsa he¹dsa. Jmáh¹lah jǿg³ he¹ Diú¹³ jmo¹dsa. Jmo¹dsa jǿg³ ha²lah lé² ta¹chi³quë́¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mi¹juanh¹² dsa² héi² jní². Di³ heh¹dsa hniah¹² ha²lah lǿa¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jǿg³ quieg¹ jní² báh³ ca¹lah¹jǿ¹ jǿg³ chi² quiah¹² ti³ŋieh¹jni. Hi² jøng² ca¹juǿi²jni hniah¹² hi² heh¹ jmi²dsí² han¹³ hniah¹² jǿg³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Cu²hna² jø² hei¹² hi² lé² tsa¹ma¹jaih³ hniah¹² jní². Ca¹tsø³jue¹³ cu²hna², jøng² jaih³ hniah¹² jní² calah ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jøng² ca¹qui² ca¹ŋai¹ dsa² quianh¹³dsa ju³roh¹³. Ca¹juúh²dsa: ―¿He² hniu¹dsa juúh²dsa jǿg³ jøng² hi² cu²hna² jø² hei¹² hi² lé² tsa¹ma¹ne¹³ jniang³ dsa, jøng² ne¹³ jniang³ calah na³ma²ca¹tsø³jue¹³ cu²hna²? ¿He² hniu¹dsa juúh²dsa hi² dsánh¹dsa ja³guǿ¹³ ti³jmi²dsa? ");
INSERT INTO cpaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿He² hniu¹dsa juúh²dsa: “Na³ma²ca¹tsø³jue¹³ cu²hna?” Tsa¹ne³ jniang³ he² hniu¹dsa juúh²dsa jǿg³ jøng² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jøng² ca¹lø¹lih¹³ Jesús hi² hniu¹dsa ŋai¹dsa jǿg³ jøng². Jøng² ca¹juúh²dsa: ―Ma²na²juǿi²jni hniah¹² hi² hei¹² jø² cu²hna² ja³tsa¹ma¹jaih³ hniah¹² jní². Jøng² jaih³ hniah¹² jní² calah na³ma²ca¹tsø³jue¹³ cu²hna². ¿Jǿg³ ná¹² ti³ŋaih³ hniah¹² rúh² hniah¹²? ");
INSERT INTO cpaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Tø³hǿgh³ hniah¹² hi² túgh³ hniah¹² hlaih¹³ jénh² hniah¹². Cónh¹jøng² túgh² dsa² tsa¹quianh¹³ jniang³ ju²hiúg¹ dsøa¹². Li¹chianh² báh³ hniah¹² ju²cǿh¹ dsøa¹² cu²hna². Cónh¹jøng² li¹chianh² hniah¹² ju³hiúg¹ dsøa¹² hiá¹ hiég¹ hi³méh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hlaih¹³ jenh¹² hio¹³ na³ma²tǿ² ja³li¹chian² jong¹²dsa. Di³ ca¹tǿ² ja³cán²dsa jmø³uai¹². Di³ jøng² tsa¹ma¹dsagh² dsǿa¹²dsa jmø³uai¹² na³ma²ca¹lø¹chián¹ guing². Hioh¹² ma²jenh¹²dsa. Di³ ma²chian² jan² guing² quián¹²dsa ni³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lah¹jøng² báh³ lǿa¹² quianh¹³ hniah¹². Ma²chianh² hniah¹² ju²cǿh¹ dsøa¹². Cónh¹jøng² jan³ jní² hniah¹² calah jmai³ siíh³. Jmai³ jøng² li¹chianh² hniah¹² ju²hiúg¹ dsøa¹². Tsa¹chian² dsa² tiúh¹ jŋíh² ju²hiúg¹ dsøa¹² jøng² quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jmai³ jøng² ha¹chi² ma¹mǿh³ hniah¹² jin³ he² quieg¹ jní². Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hniah¹²: Cuø¹ ti³ŋieh¹jni ca¹lah¹jǿ¹ he² hi² mǿh³ hniah¹² ni³ huu¹³ quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ca¹lah¹jin³ he² ha¹chi² ma²ca¹møah³ hniah¹² quieg¹ jní² cónh¹ lǿa¹² la². ¡Møa³! Di³ jøng² ŋieh¹ hniah¹². Di³ jøng² lé² ti³hian¹³ hi² chianh² hniah¹² ju²hiúg¹ dsøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Jǿg³ jøng² ma²ca¹juǿi²jni hniah¹² quianh¹³ jǿg³ ti³jnøa¹². Cónh¹jøng² dsiég¹³ báh³ jmai³ ja³tsa¹ma¹juǿi³jni hniah¹² jǿg³ ti³jnøa¹². Jmai³ jøng² hé¹³jni hniah¹² jǿg³ quiah¹² ti³ŋieh¹jni quianh¹³ jǿg³ chi³na¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jmai³ jøng² hiah¹³ hniah¹² jní² ja³møah¹³ hniah¹² ti³ŋieh¹jni he² hi² hnøngh² hniah¹². Ha¹chi² juøh¹²jni: Jní² hlanh¹³ ti³ŋieh¹jni ni³ huu¹³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Di³ hnio¹ hŋiah¹² báh³ ti³ŋieh¹jni hniah¹². Di³ hi² hnángh¹ báh³ hniah¹² jní². Héh² hniah¹² jǿg³ hi² lán¹²jni dsa² ca¹tsei¹ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ca¹jú¹jni ja³guǿ¹³ ti³ŋieh¹jni. Ca¹guio¹jni ni³ jmøi¹guǿi¹. Jøng² ma²tǿ² ja³jú¹³jni jmøi¹guǿi¹, hi² neh¹³jni calah ja³guǿ¹³ ti³ŋieh¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jøng² ca¹juúh² dsa² quianh¹³dsa: ―Na¹ jín³ lah¹dsóh² ma²juúh²hning jǿg³ chi³na¹. Tsa¹ma¹juúh²hning jǿg³ ti³jnøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ha¹chi² hniuh¹² ŋai³ jnieh³ jǿg³. Di³ ma²ŋih³hning he² jǿg³ dsø²jiag¹² dsǿa¹² jnieh³. Hi² jøng² báh³ jmo¹² ma²ne³ jnieh³ hi² lanh¹²hning dsa² ca¹tse¹ Diú¹³ ―ca¹juúh² dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jøng² ca¹juúh² Jesús: ―¿Lah³dsóh² ma²héh² hniah¹² jǿg³? ");
INSERT INTO cpaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ma²tǿ² ja³dsiég¹³ jmai³ ja³tsø³janh¹ hniah¹². Lah¹dsóh² ma²tǿ² jmai³ ja³gu³noh³ hniah¹² ja³quiánh³ báh³ hniah¹² lah¹jan² lah¹jan² hniah¹². Tángh³ hniah¹² jní² cu²hŋiéng¹jni. Di³ ha¹chi² lé² cu²hŋiéng¹jni. Quianh¹³ báh³ jní² ti³ŋieh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jǿg³ la² ma²na²juǿi²jni hniah¹². Mi³jøng² li¹chianh² hniah¹² ju³hiúg¹ dsøa¹² ni³ huu¹³ hi² lanh¹² hniah¹² dsa² quianh¹³ jní². Cánh³ báh³ hniah¹² jmø³uai¹² ni³ jmøi¹guǿi¹. Cónh¹jøng² túgh³ hniah¹² ju²hiúg¹ dsøa¹². Di³ ma²ca¹tiá¹ báh³ jní² dsa² hiag¹³ chian² jmøi¹guǿi¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mi³ma²na²juúh² Jesús jǿg³ jøng², ca¹jái¹dsa ta¹lah¹guiuh¹³. Jøng² ca¹juúh²dsa: ―Ma²tǿ² hora, Tiá³. ¡Ju³mi³juanh¹³hning jní²! Mi³jøng² mi³juanh¹³jni hning² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Di³ ma²ca¹cuøh³hning jní² bí² ja³cog² ca¹lah¹já¹ dsa² jmøi¹guǿi¹ hi² cuø¹³jni hi² li¹chian² dsa² tiá², ju³lah dsa² ca¹cuanh¹³hning, dsa² li¹quianh¹³jni, jní² dsa² lán¹² ja²ŋiúh¹hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dsa² héi² li¹chian² tiá²: Dsa² lø²cue¹² jniang³, hning² dsa² lah¹dsóh² lanh¹² Diú¹³, quianh¹³ jní² calah, dsa² tǿh²dsa Jesucristo, jní² dsa² ca¹tseh²hning ni³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma²ca¹mi³juanh¹³jni hning² ni³ jmøi¹guǿi¹. Ma¹ca¹jmo¹jni ca¹lah¹jǿ¹ hi² ca¹tseih³hning jní² hi² jmo³jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jøng² ju³jmoh³hning na¹ hi² lén²jni dsa² juanh¹² ja³ta¹neih³hning, Tiá³, ju³lah mi³lán¹³jni cónh¹ niúh¹ jín³ hi² ca¹niu¹ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ma²ca¹juǿi²jni dsa² ca¹cuanh¹³hning li¹quianh¹³jni ha²lah lanh¹²hning. Mi³lán¹³dsa dsa² quianh¹³ hnéng¹. Jøng² ca¹cuanh¹³hning dsa² ja³cog²jni. Ma²ca¹mi¹ti¹dsa jǿg³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma²ni³ŋi¹² ca¹lah¹já¹dsa hning² báh³ dsa² ca¹cuøh³ ca¹lah¹jǿ¹ juu¹² jmø³hiég¹ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma²ca¹juǿi²jni dsa² ca¹lah¹jǿ¹ jǿg³ ca¹cuøh¹³hning jní². Ma²ca¹nǿng² báh³ dsa² jǿg³. Ma²ca¹lø¹lih¹³dsa hi² ca¹guio¹jni juu¹² ja³ŋíh²hning. Ma²ca¹hé¹dsa jǿg³ hi² ca¹tseh²hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Hlanh¹³jni hning² ni³ huu¹³ quiah¹² dsa² héi². A¹jáng¹ ju³ huu¹³ quiah¹² dsa² siáh². Hlanh¹³jni hning² huu¹³ quiah¹² dsa² ca¹cuanh¹³hning jní² héi², dsa² quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Dsa² quiánh² báh³ hning² ca¹lah¹já¹ dsa² quian¹jni. Jø¹² bíh³ dsa² quian¹jni ca¹lah¹já¹ dsa² quiánh²hning. Dsa² héi² mi²léi¹³ hi² juanh¹²jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ha¹chi² ma¹li¹chian²jni jmøi¹guǿi¹. Dsa² héi² báh³ dsa² tiogh³ jmøi¹guǿi¹. Di³ neh¹³jni hi² ŋi³guø¹jni quianh¹³ hnéng¹. ¡Jmo² hí³ dsa² héi², Tiá³, hning² dsa² lanh¹² dsa² han¹³! Mi³jøng² cøng² hi² tiogh³dsa cøng² jǿg³ quiánh²hning, ju³lah ma²tiagh³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jní² ca¹jmo¹ hí³ quiah¹²dsa jmai³ ja³mi³hiúg³jni quianh¹³dsa. Mi³jøng² cøng² hi² chinh¹²dsa jǿg³ ca¹cuøh³hning jní². Ca¹jmo¹jni hí³ quiah¹²dsa. Mi³jøng² ha¹chian² dsa² héi² ca¹ŋi¹hén². Jan² dsa² héi² ma²ca¹ŋi¹hén², dsa² tiog¹³ hniuh¹² dsø¹hén². Mi³jøng² li¹ti¹ ju³lah rø²juúh² si² quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na¹ jín³ ma²tǿ² ja³neh¹³jni juu¹² ja³ŋíh²hning. Ta³lah¹ŋøa¹²jni ni³ jmøi¹guǿi¹ juøh¹²jni jǿg³ la². Di³ jøng² cu²rø² li¹hiug² dsǿa¹² dsa² héi² ju³lah hiug² dsøa¹jni hŋiéng¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma²ca¹juǿi²jni dsa² héi² jǿg³ quiánh²hning. Jøng² ma²hiag¹³ dsa² siáh² quiah¹² dsa² héi². Di³ tsa¹jmo¹ dsa² héi² ju³lah lǿa¹² jǿg³ hlaih¹³ quiah¹² dsa² jmøi¹guǿi¹ jian¹²dsa. Ju³lah jní², tsa¹ca¹jmo¹jni lah¹jøng² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ha¹chi² møa¹²jni jǿg³ hi² táih³hning dsa² héi² ta¹ŋih¹³, hi² tsa¹ma¹tiogh³dsa jmøi¹guǿi¹. Cónh¹ hi² logh³hning dsa² ja³cog² dsa² hlanh³. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ha¹chi² tiogh³ dsa² héi² jǿg³ hlaih¹³ quiah¹² jmøi¹guǿi¹ la². Di³ ha¹chi² guø³jni jǿg³ jøng² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ju³jmo¹³ jǿg³ quiánh²hning hi² lén² dsa² héi² dsa² lah¹dsóh² mi¹ti¹ jǿg³ quiánh²hning. Di³ jǿg³ dsøg¹² báh³ jǿg³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ca¹tseh²hning jní² juu¹² ja³tiogh³ dsa² jmøi¹guǿi¹. Juu¹² jøng² tsë́²jni dsa² héi² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ni³ huu¹³ quiah¹² dsa² héi² cuan¹²jni hŋiéng¹jni ja³cogh²hning. Mi³jøng² li¹dsøg¹² jǿg³ hi² lén² dsa² héi² dsa² mi¹ti¹ jǿg³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’A¹jáng¹ ju³ jmáh¹lah ja³cog² dsa² héi² hlanh¹³jni hning². Di³ hlanh¹³jni hning² ja³cog² dsa² hé² jǿg³ quieg¹ jní² hǿ² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mi³jøng² túgh²dsa cøng² jǿg³, ju³lah ma²tiagh³ jniang³. Mi³jøng² li¹quianh¹³ jniang³ dsa². Jøng² li¹ŋi¹² dsa² siáh² calah hi² ca¹tseh²hning jní² ni³ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma²ca¹mi³juanh¹³jni dsa² héi² cøng² ni³ ju²lah ma²ca¹mi³juanh¹³hning jní². Mi³jøng² túgh²dsa cøng² ni³ quianh¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Quianh¹³jni dsa² héi². Quianh¹³hning jní². Di³ jøng² túgh²dsa cøng² jǿg³. Di³ jøng² li¹ŋi¹² dsa² siáh² calah hi² ca¹tseh²hning jní² ni³ jmøi¹guǿi¹. Li¹ŋi¹² dsa² jue¹² ca¹lø¹hnóh¹hning dsa² héi² ju³lah ca¹lø¹hnángh¹hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Lah¹la² hno¹jni, Tiá³, hi² li¹chian² dsa² héi² ja³hiúg³jni, dsa² ca¹cuanh¹³hning héi². Mi³jøng² jái¹dsa ha²lah ma²ca¹jmoh³hning hi² juanh¹² jní². Ca¹jmoh³hning lah¹jøng². Di³ hi² ma²hnángh¹hning jní² niúh¹ jín³ hi² ca¹niu¹ jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Lanh¹²hning dsa² dsiog¹, Tiá³. Tsa¹cue¹² dsa² jmøi¹guǿi¹ hning². Cónh¹jøng² cué¹² báh³ jní² hning². Ma²ŋi¹² báh³ dsa² quianh¹³ jní² hi² ca¹tseh²hning jní². ");
INSERT INTO cpaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ca¹hé¹jni dsa² héi² jǿg³ ha²lah lanh¹²hning. Cøng² hi² hé¹³ báh³ jní² dsa² jǿg³. Di³ jøng² li¹hnio¹dsa roh¹³dsa ju³lah hnángh¹hning jní². Jøng² qui³jian¹³jni dsa² héi² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mi³ma²na²juúh² Jesús jǿg³ jøng², ca¹huanh¹²dsa ja³mi³tiogh³dsa quianh¹³ dsa² quianh¹³dsa. Ca¹ŋi¹lé²dsa juu¹² hŋoh¹³ jmøi² gu² tsen² Hma² Ŋih³. Ja³jøng² lǿa¹² jøa³lí³. Jøa³lí³ jøng² ca¹ŋi¹tiogh¹² Jesús quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jøng² ma²ca¹ŋie³ Judas ja³jøng², dsa² hnai¹ quiah¹² Jesús héi². Di³ hliú² rón² ma²ca¹ŋi¹tiogh¹² Jesús ja³jøng² quianh¹³ dsa² quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hi² jøng² ca¹ŋi¹tei¹ Judas cu²tséh¹ hlég² quianh¹³ policía, dsa² ca¹tse¹ juu¹³ jmi²dsa² quianh¹³ dsa² fariseo. Ca¹tai¹dsa juu¹² jøa³lí³ jøng². Ti³quin¹²dsa si² jmøi² cøg², quianh¹³ hma² ti³hiúh² si². Ti³chinh¹²dsa ŋí³. Ti³chinh¹²dsa hma². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma²ŋi¹² báh³ Jesús ca¹lah¹jǿ¹ hi² dsa¹ŋë́²dsa. Jøng² ca¹ŋó¹ Jesús ta¹lah¹ni¹ dsa² héi². Ca¹juúh²dsa: ―¿Hein² dsa² hnah¹² hniah¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jøng² ca¹juúh² dsa² héi²: ―Jesús, dsa² chian² Nazaret, báh³ hniah¹² jnieh³ ―ca¹juúh² dsa² héi². Jøng² ca¹juúh² Jesús: ―Jní² báh³ lang¹² ―ca¹juúh²dsa. Ma²hiúg³ Judas, dsa² hnai¹² quiah¹² Jesús, jøa³ dsa² jue¹² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jøng² mi³ca¹juúh² Jesús: “Jní² báh³ lang¹²”, ca¹ŋi¹lé² dsa² jue¹² ta¹lah¹cah¹dsa. Ca¹ŋi¹ganh¹³dsa huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jøng² ca¹juúh² Jesús calah: ―¿Hein² dsa² hnah¹² hniah¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Jesús, dsa² chian² Nazaret, báh³ hniah¹² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jøng² ca¹juúh² Jesús: ―Ma²na²juǿi²jni hniah¹²: “Jní² báh³ lang¹².” Chi²júh² jní² hnah¹² hniah¹², cuø³ jǿg³ dsø¹lia¹ dsa² quianh¹³ jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ca¹løa¹ lah¹jøng², di³ jøng² ca¹lø¹ti¹ jǿg³ la² hi² ma²ca¹juúh² Jesús lah¹jiá¹², ca¹tsáih¹dsa ti³jmi²dsa: “Ha¹chian² dsa² ca¹cuanh¹³hning jní² héi² ca¹ŋi¹hén²,” ma²ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jøng² ca¹li² Simón Pedro ŋi³tǿi¹ quiah¹²dsa. Ca¹quiúh²dsa guø³ jan² dsa² tsen² Malco, guø³dsa dsio¹. Dsa² héi² jmo¹² ta³ quiah¹² ŋi¹jmó². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Pedro: ―Tiangh³ løg² ŋi³tǿi¹ quiánh²hning. Tiog¹³ báh³ hniuh¹² hi² can³jni jmø³uai¹², ju³lah lǿa¹² jǿg³ ca¹jmo¹ ti³ŋieh¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jøng² ca¹chiánh²dsa Jesús. Ca¹chiángh² juu¹³ hlég², quianh¹³ hlég² quián¹²dsa, quianh¹³ policía quián¹² dsa² judío. Ca¹qui² ca¹hŋió²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jøng² ca¹ŋi¹jiag¹²dsa juu¹² ja³quiah¹³ Anás, dsu²jmi³ Caifás, dsa² lán¹² ŋi¹jmó² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás héi² báh³ dsa² ma²ca¹juúh², ca¹tsáih¹dsa dsa² canh¹³ quián¹² dsa² judío: “Hiug¹² jín³ hi² dsio¹ jón² jan² dsa² dsie¹² juøi². Jøng² tsa¹dsø¹hén² ta³cøng² ja³tén¹² jniang³,” ma²ca¹juúh² Caifás. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jøng² ca¹ŋó¹ Simón Pedro dsi³cah³ Jesús quianh¹³ jan² dsa² guia¹tón² jian¹²dsa. Mi³ca¹dsi¹lé²dsa hag³jnǿ³ tsih¹² ja³dsi¹² quiah¹² ŋi¹jmó², ca¹hí¹ dsa² quianh¹³ Pedro niúh¹ jnǿ³ quianh¹³ Jesús. Di³ cue¹² ŋi¹jmó² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ca¹tø³tsëh³ Pedro coh¹³ jnǿ³. Jøng² ca¹ŋó¹ dsa² jan² héi², ca¹ŋi¹tseih¹dsa tsih²mǿ² jmo¹² hí³ hag³jnǿ³. Mi³ jøng² ca¹ŋë́¹ Pedro niúh¹ jnǿ³. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jøng² ca¹juúh² tsih²mǿ² héi², ca¹tsáih¹dsa Pedro: ―Lanh¹²hning jan² dsa² quianh¹³ Jesús ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―Ha¹chi² dsa² héi² lán¹²jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jøng² ma²ca¹jéinh¹ policía si² tah², quianh¹³ dsa² ti³jmo¹² ta³ tiogh³ ja³jøng². Di³ hi² guǿi². Ma²ti³tón²dsa dsioh¹²dsa si². Ja³jøng² ca¹nung² Pedro calah, jøa³ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jøng² ca¹ŋǿh¹ ŋi¹jmó² Jesús hein² dsa² lán¹² dsa² quianh¹³dsa, ha²lah lǿa¹² jǿg³ ma²ca¹he¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jøng² ca¹juúh² Jesús: ―Ma²ca¹he¹jni jǿg³ ja³ta¹ni¹ dsa² jue¹², ju³lah dsi²néi² guøh¹² mih², quianh¹³ ja³tsih¹² guøh¹² juøh¹² calah, ja³dsø²tiogh¹² dsa² judío. Ha¹chi² jǿg³ ma²ca¹juúh¹jni jin³ cøng² ja³chi³hma¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿He² løa¹ jní² ŋaih³hning? Dsio¹ báh³ gu³ŋaih³hning dsa² ma²ca¹nǿng² jǿg³ quieg¹jni. Dsa² héi² ŋi¹² ha²lah lǿa¹² jǿg³ ma²ca¹juúh¹jni ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mi³ca¹juúh² Jesús jǿg³ jøng², jøng² ca¹jnáng¹ jan² policía ni³ Jesús. Jøng² ca¹juúh² policía héi²: ―¿He² løa¹ lah¹ná¹² ŋaih³hning ŋi¹jmó²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jøng² ca¹juúh² Jesús: ―Ju³ná³ na²juǿi²jni dsa² jǿg³ hlaih¹³, juúh³hning he² jǿg³ hlaih¹³ na¹juǿi²jni dsa². Chi² ju³ná³ jǿg³ dsøg¹² ma²na²juúh¹jni, ¿he² løa¹ jnángh²hning ne¹jni? ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jøng² ca¹tse¹ Anás Jesús ja³cog² Caifás, dsa² lán¹² ŋi¹jmó². Dsio¹ rø²hŋió² Jesús quianh¹³ hnei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ja³jøng² ma²tsenh¹² Pedro cøg¹² si², hi² ma²dsioh¹²dsa. Jøng² ca¹juúh² dsa² tiogh³ quianh¹³dsa cøg¹² si² jøng²: ―¿Tsa³lanh¹²hning jan² dsa² quianh¹³ Jesús? ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―A¹jáng¹ ju³ dsa² quianh¹³ Jesús jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jøng² ca¹juúh² jan² dsa² jmo¹² ta³ quiah¹² ŋi¹jmó², ju³roh¹³ dsa² ca¹quiúh² Pedro guø³: ―¿Tsa³na²ja³jni hning² jøa³lí³ quianh¹³ dsa² héi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jøng² ca¹juúh² Pedro: ―Héi¹ ju³ jní² héi² ―ca¹juúh²dsa. Dsø¹juu¹² ca¹ho¹ chiih³. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jøng² ca¹lén²dsa Jesús ja³quiah¹³ Caifás. Ca¹ŋi¹jiag¹²dsa juu¹² ja³quiah¹³ Pilato, dsa² lán¹² dsi³máh², ja³tsen² Pretorio. Ma²lǿa¹² tø¹ja³jní¹. Jøng² ha¹chi² ca¹ŋi¹tiogh¹² dsa² canh¹³ quián¹² dsa² judío dsi²néi². Di³ lë́²dsa hi² dsa¹hén² hi² ni³jŋió¹³dsa ju³ná³ ca¹ŋi¹tiogh¹²dsa ja³quiah¹³ dsa² tsa¹lán¹² judío. Jøng² tsa¹ma¹lé² gǿh¹dsa quiah¹² jmai³ ta²høa³. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jøng² ca¹u¹hái¹ Pilato ja³dsi¹². Ca¹ŋi¹tseih¹dsa dsa² canh¹³ héi². Ca¹juúh²dsa: ―¿He² dsag³ jmoh² hniah¹² quiah¹² dsa² ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jøng² ca¹juúh² dsa² canh¹³: ―Tsa¹mi³jëh¹³ jnieh³ dsa² ja³cogh²hning, ju³ jøng² hi² tsa¹re²dsa dsag³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jøng² ca¹juúh² Pilato: ―Tei³ hniah¹² dsa². Jøng² cánh³ hniah¹² jǿg³ dsøg¹² quiah¹²dsa ju³lah lǿa¹² lei¹³ quiánh² hniah¹² ―ca¹juúh² Pilato. Jøng² ca¹juúh² dsa² canh¹³: ―Tsa¹lé² lah¹jøng². Di³ hniah¹² dsa² chianh² ja³tén¹² Roma, tsa¹cuúh³ jǿg³ hi² jŋëh¹³ jnieh³ dsa² re² dsag³ ja³cog² lei¹³ quián² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Lah¹jøng² báh³ ca¹løa¹. Mi³jøng² ca¹lø¹ti¹ jǿg³ hi² ca¹juúh² Jesús lah¹jiá¹², hi² jón²dsa ni³ crǿg¹³, ju³lah lǿa¹² mai³¹ quiah¹² dsa² romano. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jøng² ca¹ŋáh¹ calah Pilato dsi²néi². Ca¹tǿh¹dsa Jesús. Ca¹juúh²dsa: ―¿Lanh¹³hning rai¹³ quián¹² dsa² judío? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jøng² ca¹juúh² Jesús: ―¿Juúh³hning cónh¹ hi² lë́h²hning hŋiah¹hning, ho¹ ju³ jǿg³ ma²na²juúh² dsa² siáh², hi² lán¹²jni rai¹³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jøng² ca¹juúh² Pilato: ―Ha¹chi² lán¹² jní² dsa² judío. Dsa² goh²hning báh³, quianh¹³ juu¹³ jmi²dsa² quiánh²hning, ca¹jë́h² hning² ja³cog²jni. ¿He² hi² hlaih¹³ ma²ca¹jmoh³hning? ―ca¹juúh² Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jøng² ca¹juúh² Jesús: ―A¹jáng¹ ju³ dsa² jmøi¹guǿi¹ ca¹jmo¹ hi² lán¹²jni rai¹³. Ju³ jøng² hi² lǿa¹² lah¹jøng², jøng² mi³tá¹ dsa² quianh¹³jni quianh¹³ dsa² ca¹chiángh² jní². Di³ jøng² tsa¹mi³guøn¹²jni ja³la². A¹jáng¹ ju³ dsa² jmøi¹guǿi¹ ca¹jmo¹ hi² lán¹²jni rai¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jøng² ca¹juúh² Pilato: ―¿Hi³ jøng² lanh¹²hning rai¹³ jøng²? ―ca¹juúh² Pilato. Jøng² ca¹juúh² Jesús: ―Lán¹² báh³ jní² rai¹³. Cøng² huu¹³ jøng² ca¹lø¹chián¹jni jmøi¹guǿi¹, hi² tsǿh³jni jǿg³ dsøg¹². Nang¹² báh³ ca¹lah¹já¹ dsa² hniu¹ jǿg³ dsøg¹² jǿg³ quieg¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jøng² ca¹juúh² Pilato: ―¿He² jǿg³ jøng², jǿg³ dsøg¹²? ―ca¹juúh²dsa. Mi³ma²na²ŋai¹ Pilato jǿg³ jøng², ca¹u¹hái¹dsa calah ja³dsi¹². Ca¹ŋi¹tseih¹²dsa dsa² canh¹³ quián¹² dsa² judío. Ca¹juúh²dsa: ―Tsa¹dsoh³jni jin³ cøng² dsag³ ja³cog² dsa² ná¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cónh¹jøng² chi² báh³ mai³¹ quiánh² hniah¹² hi² log³jni jan² dsa² hiúg³ hni¹ŋí³ ta³lah¹jmai³ ta²høa³. ¿Hnøngh³ hniah¹² hi² log³jni dsa² tǿh²dsa rai¹³ quián¹² dsa² judío? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jøng² ca¹lah¹já¹ dsa² canh¹³ héi² ca¹hløah¹ tí². Ca¹juúh²dsa: ―¡Tsa¹logh³hning dsa² ná¹²! ¡Barrabás báh³ logh³hning! ―ca¹juúh²dsa. Dsa² høin² báh³ Barrabás héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jøng² ca¹jmo¹ Pilato héh¹ hi² ba²jmé²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jøng² ca¹jmo¹ hlég² cøng² tsøi² tang¹². Ca¹tí²dsa dsi³ Jesús. Jøng² ca¹quieh¹dsa Jesús cøng² hmøah¹² guiéng², ju³lah hmøah¹² caih¹² rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jøng² ca¹ŋi¹lé²dsa ta¹lah¹cog² Jesús. Ca¹juúh²dsa: ―Hiug¹² juanh¹²hning, Rai¹³ quián¹² dsa² Judío ―ta³dsǿa¹² juúh²dsa. Jøng² ca¹qui² ca¹jnáng¹dsa ni³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jøng² ca¹ŋó¹ Pilato calah ja³dsi¹². Ca¹juúh²dsa, ca¹tsáih¹dsa dsa² canh¹³ héi²: ―Jai³lah, lén¹³jni dsa² ná¹² ja³la². Di³ jøng² ma²ŋih³ hniah¹² hi² tsa¹dsoh³jni jin³ cøng² dsag³ quiah¹²dsa ―ca¹juúh² Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jøng² ca¹u¹hái¹ Jesús. Ma²hiu³ tsøi² tang¹² dsi³dsa. Ma²quieih¹²dsa hmøah¹² guiéng². Jøng² ca¹juúh² Pilato: ―¡He³ dsa² lang²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mi³ca¹jë́² juu¹³ jmi²dsa² quianh¹³ policía Jesús, ca¹hløah¹dsa tí². Ca¹juúh²dsa: ―¡Crǿg¹³ báh³ ta¹ton¹³dsa! ¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. Jøng² ca¹juúh² Pilato: ―Jianh¹³ hniah¹² dsa². Gu³tiogh¹² hniah¹² dsa² crǿg¹³ guiogh¹³ hniah¹². Di³ tsa¹dsoh³jni jin³ cøng² dsag³ quiah¹²dsa ―ca¹juúh² Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jøng² ca¹juúh² dsa² canh¹³: ―Chi² cøng² lei¹³ quián² jnieh³. Lei¹³ jøng² rø²juúh² hi² re²dsa dsag³ hi² jón²dsa. Di³ hi² ma²ca¹jmo¹dsa hi² lán¹²dsa jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jøng² hiug¹² jín³ ca¹lø¹goh¹² Pilato, mi³ca¹nǿng²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jøng² ca¹ŋi¹lia¹ Pilato quianh¹³ Jesús dsi²néi². Ca¹ŋi¹ŋǿh¹dsa Jesús. Ca¹juúh²dsa. ―¿Ha² tøah¹ chianh²hning? ―ca¹juúh²dsa. Ha¹chi² ca¹ŋai¹ Jesús jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jøng² ca¹juúh² Pilato: ―¿He² løa¹ tsa¹ŋaih³hning jǿg³ hi² juøh¹²jni? ¿Tsa³ŋih³hning hi² chi² bí² quieg¹jni hi² jmo³jni héh¹ ta¹tonh³hning crǿg¹³, ho¹ ju³ hi² log³jni hning²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jøng² ca¹juúh² Jesús: ―Ha¹chi² bí² mi³chi² quiánh²hning ja³cog²jni, ju³ jøng² tsa¹ca¹cuø¹ Diú¹³. Ma¹dsio¹² jín³ dsag³ re² dsa² ca¹jë́h² jní² ja³cogh²hning cónh¹ jín³ hning² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ni³ jøng² ca¹hnángh¹ Pilato mai³¹ ha²lah mi³liúg²dsa Jesús. Cónh¹jøng² ca¹qui² ca¹hløah¹ dsa² canh¹³ tí². Ca¹juúh²dsa: ―Ha¹chi² lanh¹²hning dsa² quianh¹³ rai¹³ juanh¹² guǿ¹² Roma ju³ná³ logh³hning dsa² ná¹². Dsa² ca²jag¹³ báh³ lán¹² lǿa¹² ju³ hein² dsa² siáh² jmo¹ hi² lán¹²dsa rai¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mi³ca¹nǿng² Pilato jǿg³ jøng², ca¹jmo¹dsa héh¹ hi² lén²dsa Jesús ja³dsi¹². Jøng² ca¹guú² Pilato ja³mi²rø¹²dsa jǿg³, ja³tǿh²dsa Gabata quianh¹³ jǿg³ hebreo (hi² hniu¹dsa juúh²dsa: Ja³rø²neih¹² cang³). ");
INSERT INTO cpaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hei¹² hi³méh¹ tøa¹ dsi¹hiég¹ hloh¹² jmai³ ta²høa³. Jøng² ca¹juúh² Pilato, ca¹tsáih¹dsa dsa² canh¹³ quián¹² dsa² judío: ―¡He³ rai¹³ quiánh² hniah¹² lang¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jøng² ca¹qui² ca¹hløah¹ dsa² canh¹³ tí²: ―¡Ju³jón³dsa! ¡Ju³jón³dsa! ¡Crǿg¹³ báh³ ta¹ton¹³dsa! ―ca¹juúh²dsa. Jøng² ca¹juúh² Pilato: ―¿Lé³ ta¹ton¹³jni rai¹³ quiánh² hniah¹² crǿg¹³? ―ca¹juúh²dsa. Jøng² ca¹juúh² juu¹³ jmi²dsa²: ―Ha¹chian² rai¹³ siáh² chian² quián² jnieh³, jan² rai¹³ juanh¹² guǿ¹² Roma báh³ chian² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jøng² ca¹cuø¹ Pilato jǿg³ hi² tiog¹dsa Jesús crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jøng² ca¹lén² hlég² Jesús, hi² quin¹² Jesús crǿg¹³ quiah¹²dsa. Jøng² ca¹ŋi¹jiag¹²dsa cøng² ja³tsen² Gólgota quianh¹³ jǿg³ hebreo (hi² hniu¹dsa juúh²dsa: Máh² Mu² Dsi³ Dsa²). ");
INSERT INTO cpaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja³jøng² ca¹tiog¹dsa Jesús crǿg¹³. Jø¹² bíh³ ca¹tiog¹dsa og¹ dsa² siáh² crǿg¹³ cog² Jesús, jag¹³ ca²ton² ca²ton², hi² hiúg³ Jesús dsi²jo². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jøng² ca¹jmo¹ Pilato héh¹ hi² ca¹tiun¹dsa dsi³ crǿg¹³ cøng² si² rø²hløah¹² jǿg³ la²: JESÚS, DSA² CHIAN² NAZARET, RAI¹³ QUIÁN¹² DSA² JUDÍO. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ca¹høa¹ jue¹² dsa² judío jǿg³ jøng². Di³ cøg¹² juøi² báh³ ca¹ŋi¹tiog¹dsa Jesús crǿg¹³. Ma²lǿa¹² jǿg³ jøng² quianh¹³ jǿg³ hebreo, quianh¹³ jǿg³ griego, quianh¹³ jǿg³ latín. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jøng² ca¹juúh² juu¹³ jmi²dsa² quián¹² dsa² judío, ca¹tsáih¹dsa Pilato: ―Tsa¹mi³jmóh³hning hi² rø²hløah¹² si²: RAI¹³ QUIÁN¹² DSA² JUDÍO. Hiug¹² jín³ dsio¹ jmóh³hning: DSA² JUÚH² LÁN¹²DSA RAI¹³ QUIÁN¹² DSA² JUDÍO ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jøng² ca¹juúh² Pilato: ―Lah¹jøng² báh³ lé², ju³lah ma²ca¹jmo¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mi³ma²na²tiog¹ hlég² Jesús crǿg¹³, jøng² ca¹cang¹dsa tsǿnh³ Jesús, ma¹cǿng¹ hmøah¹² lah¹jan²dsa, cónh¹ quión² hlég². Ca¹cang¹dsa calah hmøah¹² dsǿ² coh¹³, hmøah¹² ma²lǿa¹² ca¹tá¹dsa. A¹jáng¹ ju³ hmøah¹² ca¹hmi¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jøng² ca¹juúh² hlég², ca¹tsáih¹dsa roh¹³dsa: ―Tiúh¹ báh³ tsa¹guíg³ jniang³ hmøah¹². Dsio¹ báh³ dsí³ jniang³ jǿg³. Ju³ne¹³ hein² dsa² líh² hmøah¹² ―ca¹juúh² hlég². Lah¹jøng² báh³ ca¹lø¹ti¹ jǿg³ la² rø²juúh² ni³ si² quiah¹² Diú¹³: Ca¹dsiúh¹dsa tsønh¹jni. Ca¹dsi¹dsa jǿg³ hmøah¹² quieg¹jni, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lah¹jøng² báh³ ca¹jmo¹ hlég². Cøg¹² crǿg¹³ ja³rø²ton¹² Jesús mi³tsenh¹³ mi³chiég³dsa, quianh¹³ hio¹³ roh¹³ mi³chiég³dsa, quianh¹³ dsa² tsen² María calah, hio¹³ quián¹² dsa² tsen² Cleofas, quianh¹³ María dsa² chian² Magdala. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ca¹jë́² Jesús mi³chiég³dsa, quianh¹³ jan² dsa² guia¹tón², dsa² hiug¹² hnio¹ Jesús. Jøng² ca¹juúh² Jesús, ca¹tsáih¹ mi³chiég³dsa: ―¡Hio¹³! ¡He³ jonh¹²hning tsenh¹² ja³ná³! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jøng² ca¹tsáih¹dsa dsa² guia¹tón² héi²: ―Dsa² ná¹² báh³ jmóh³hning mi³chiegh²hning ―ca¹juúh²dsa. Jøng² ca¹hie¹ dsa² guia¹tón² héi² mi³chiég³ Jesús. Ca¹tai¹dsa juu¹² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma²ŋi¹² Jesús hi² ca¹hian¹² ca¹lah¹jǿ¹ jǿg³ quiah¹²dsa. Jøng² ca¹juúh²dsa jǿg³ la². Mi³jøng² li¹ti¹ jǿg³ rø²juúh² ni³ si² quiah¹² Diú¹³. Ca¹juúh²dsa: ―Lø¹i³gøh³jni jmøi² lǿ² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ja³jøng² mi³tsih¹² cøng² dsøg³ mi³ha³ jmøi² jinh² chi³cángh². Jøng² ca¹tí² jan² dsa² tiogh³ ja³jøng² cøng² hi² lǿa¹² ju³lah lǿa¹² hmøah¹² jmøi² jinh² jøng². Mi³jøng² ca¹ha¹ jmøi². Jøng² ca¹cǿin²dsa hi² jøng² dsi³ cøng² guh¹² hma² hisopo. Jøng² ca¹chio¹dsa guiuh¹³. Ca¹henh¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mi³ma²na²hǿnh² Jesús jmøi² jinh² jøng², jøng² ca¹juúh²dsa: ―Ca¹hian¹² báh³ ―ca¹juúh²dsa. Ni³ jøng², mi³ma²na²siég²dsa dsi³dsa, ca¹hie¹dsa hmó¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jøng² ca¹møa¹ dsa² canh¹³ quián¹² dsa² judío hi² tsei¹ Pilato hlég² hi² dsø¹hnie³ hlég² quiu³ dsa² ti³ton¹² crǿg¹³. Di³ jøng² dsián¹dsa ta³tí³. Jøng² jŋiáh²dsa dsa² ni³ crǿg¹³ na³ma²na²dsan¹dsa. Hloh¹² jmai³ sa³¹ báh³ jøng². Jøng² tsa¹hniu¹ dsa² canh¹³ hi² lé² ti³ton¹² hlai³ crǿg¹³ ta³lah¹ti³juanh¹² jmai³ sa³¹ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jøng² ca¹ŋi¹lé² hlég² juu¹² ja³ni³ton¹²dsa crǿg¹³. Ca¹hnie¹dsa quiu³ dsa² lah¹ni³, quianh¹³ quiu³ dsa² jan² calah, dsa² ni³ton¹² crǿg¹³ quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mi³ca¹dsi¹lé²dsa ja³rø²ton¹² Jesús, ca¹jái¹dsa hi² ma²rø²jon¹³ Jesús. Jøng² ha¹chi² ca¹hnie¹dsa quiu³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jøng² ca¹hǿh² jan² hlég² ŋí³ chiunh² mu²tsønh³ Jesús. Dsø¹juu¹² jøng² ca¹tøng² jmø² quianh¹³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lah¹dsóh² ca¹jái¹jni hi² jøng², jní² dsa² ca¹jmo¹ si² la². Jǿg³ dsøg¹² lah¹dsóh² báh³ juúh² dsa² héi². Ju³héh³ hniah¹² calah. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lah¹jøng² báh³ ca¹løa¹. Mi³jøng² ca¹lø¹ti¹ jǿg³ la², jǿg³ rø²juúh² si² quiah¹² Diú¹³: “Ha¹chi² hnie¹dsa jin³ cøng² mu² quiah¹²dsa,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jø¹² bíh³ rø²juúh² si² calah: “Jë́² báh³ dsa² dsa² ca¹hǿh²dsa quiah¹²,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ni³ jøng² ca¹møa¹ José, dsa² chian² Arimatea, jǿg³ ni³ Pilato chi²júh² lé² tai¹dsa hlai³ Jesús. Hé² José jǿg³ quiah¹² Jesús. Cónh¹jøng² ha¹chi² ca¹mi¹léi¹³dsa hi² hé²dsa jǿg³ ja³ta¹ni¹ dsa² jue¹². Di³ hi² gan¹dsa dsa² canh¹³ quián¹² dsa² judío. Jøng² mi³ca¹cuø¹ Pilato jǿg³, ca¹tai¹dsa hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jø¹² bíh³ ca¹ŋó¹ calah Nicodemo, dsa² ma²ca¹dsii¹ jǿg³ quianh¹³ Jesús lah¹jiá¹² cøng² ja³neng². Quin¹²dsa gui²guií² kilo nang³ ma²juøi², hi² ma²rø²guian¹² mirra quianh¹³ áloes. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jøng² ca¹tai¹ José quianh¹³ Nicodemo hlai³ Jesús. Jøng² ca¹guiánh²dsa Jesús hmøah¹² ma²rø²tsǿng² nang³ ma²juøi² jøng², ju³lah lǿa¹² mai³¹ quiah¹² dsa² judío, hi² jmo¹²dsa quiah¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jøng² mi³lǿa¹³ cøng² jøa³lí³ cøg¹² ja³ca¹tiog¹dsa Jesús crǿg¹³. Jøa³lí³ jøng² ho¹² cøng² tøg²hløg² hmë́², ja³ha¹chian² dsa² ma²ca¹húg²dsa jin³ jan². ");
INSERT INTO cpaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Niúh¹ tøg²hløg² jøng² ca¹ŋi³quiog¹dsa hlai³ Jesús. Di³ ma²quien¹² lǿa¹² ja³jøng². Di³ ma¹tǿ² ja³li¹liág¹ ti³juøh¹² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jøng² jmai³ du²mei³¹, cónh¹ nioh¹² hi³méh¹, ca¹ŋie³ María, dsa² chian² Magdala, ja³rø²hog¹² hlai³ Jesús. Jøng² ca¹jái¹dsa ma²rø²jŋih¹³ cang³ hag³ tøg². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jøng² ca¹ŋáh¹dsa gu¹hei¹² juu¹² ja³tiogh³ Pedro quianh¹³ dsa² guia¹tón² héi², dsa² hiug¹² hnio¹ Jesús. Jøng² ca¹juúh² María: ―Ma²ca¹jŋiángh²dsa ja³mi³rø²hog¹² hlai³ Juu¹³ jniang³. Tsa¹guiang³jni ha² tøah¹ ca¹ŋi¹quiag¹²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jøng² ca¹ŋi¹lé² Pedro quianh¹³ dsa² jan² héi² juu¹² ja³mi³rø²hog¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ca¹ŋi¹lé²dsa gu¹hei¹² ta³og¹dsa. Hiug¹² jín³ gu¹hei¹² ca¹ŋó¹ dsa² jan² cónh¹ jín³ Pedro. Jøng² ca¹dsiég¹dsa ma²jiá¹²dsa ja³mi³rø²hog¹² hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jøng² ca¹nung²dsa hi² sian¹²dsa. Ca¹jái¹dsa niúh¹ tøg² ja³mi³rø²quia¹² hlai³ Jesús. Jøng² ca¹jái¹dsa hmøah¹² mi³rø²dsugh¹² hlai³ neng¹² ja³jøng². Jøng² ha¹chi² ca¹hí¹dsa niúh¹ tøg². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ni³ jøng² ca¹dsiég¹ Simón Pedro. Jøng² ta³lah¹ca¹hí¹dsa niúh¹ tøg². Jø¹² bíh³ ca¹jái¹dsa calah hmøah¹² mi³rø²dsugh¹² hlai³ neng¹² ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ca¹jái¹dsa calah hmøah¹² mi³rø²liág¹ dsi³ hlai³. Neng¹² hmøah¹² tø¹lah¹cøg¹², hi² ma²rø²ban¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ni³ jøng² ca¹hí¹ calah dsa² ca¹dsiég¹ lah¹ni³ héi² niúh¹ tøg². Jøng² ca¹jái¹dsa ha²lah lǿa¹². Ca¹hé¹dsa jǿg³ hi² ca¹hiog² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsa¹jín³ ma²ca¹lø¹ŋë́² dsa² héi² jǿg³ rø²juúh² si² quiah¹² Diú¹³ hi² hiog¹ Jesús na³ma²ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jøng² ca¹ŋi¹lia¹ dsa² héi² juu¹² ja³quiah¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ca¹nung² María coh¹³ tøg², hi² ho¹²dsa. Ta³lah¹ho¹²dsa jøng², ca¹jmo¹dsa hi² sian¹²dsa. Mi³jøng² jái¹dsa niúh¹ tøg². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jøng² ca¹jë́²dsa og¹ ángeles ti³quieih¹² hmøah¹² tég¹. Tiogh³dsa ja³mi³rø²quia¹² hlai³ Jesús. Jan² ángel guǿ¹² ja³mi³lǿa¹³ dsi³guiuh² hlai³. Jan² guǿ¹² ja³mi³lǿa¹³ hé¹ tai³ hlai³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jøng² ca¹juúh² ángel: ―¿He² løa¹ høgh²hning, hio¹³? ―ca¹juúh²dsa. Jøng² ca¹juúh² María: ―Ho¹²jni. Di³ hi² ma²ca¹jŋiáh²dsa hlai³ juu¹jni, mi³rø²quia¹² ja³ná³. Tsa¹guiang³jni ha² tøah¹ ca¹ŋi¹quiag¹²dsa ―ca¹juúh² hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jø² ma²na²juúh²dsa jǿg³ jøng², ca¹jénh¹dsa. Jøng² ca¹jë́²dsa Jesús ma²tsenh¹² cøg¹² ja³tsenh¹³dsa. Ha¹chi² lë́²dsa Jesús héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jøng² ca¹juúh² Jesús: ―¿He² løa¹ høgh²hning, hio¹³? ¿Hein² dsa² hnanh¹²hning? ―ca¹juúh²dsa. Jøng² lë́² María lán¹² dsa² héi² dsa² jmo¹² hí³ jøa³lí³ jøng². Jøng² ca¹juúh² María: ―Guiuh¹³, chi² ju³ná³ hning² ca¹jŋiáh² hlai³, tseih³hning jní² ha² tøah¹ ca¹ŋi³quioh²hning hlai³. Di³ jøng² tai³jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jøng² ca¹juúh² Jesús: ―¡María! ―ca¹juúh²dsa. Jøng² ca¹jénh¹ Maria. Ca¹juúh²dsa quianh¹³ jǿg³ hebreo: ―¡Raboni! ―ca¹juúh²dsa, hi² hniu¹dsa juúh²dsa: Tøa¹². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jøng² ca¹juúh² Jesús: ―¡Tsa¹tei³ jní² gugh²! Di³ ha¹chi² ma²ca¹ŋie³jni ja³guǿ¹³ ti³ŋieh¹jni. Gu³tseih³hning dsa² quian¹jni hi² neh¹³jni juu¹² guiuh¹³ ja³guǿ¹³ ti³ŋieh¹jni, ti³ŋieih¹² hniah¹², Diú¹³ quian¹jni, Diú¹³ quiánh² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jøng² ca¹ŋó¹ báh³ María, dsa² chian² Magdala héi², ca¹ŋi¹tseih¹²dsa dsa² quianh¹³ Jesús. ―Ma²na²ja³jni Jesús ―ca¹juúh²dsa. Jøng² ca¹tsáih¹ María dsa² quianh¹³ Jesús héi² jǿg³ ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jøng² mi³ca¹neng² jmai³ du²mei³¹ jøng², ma²chi³jnái¹³ hniú¹² ja³tiogh³ dsa² quianh¹³ Jesús. Di³ hi² gan¹dsa dsa² canh¹³ quián¹² dsa² judío. Jøng² ca¹dsiég¹ Jesús. Ca¹nung²dsa dsi²jo² ja³tiogh³ dsa² quianh¹³dsa. Ca¹juúh²dsa: ―Mi³hiúgh³ hniah¹² hoh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mi³ma²na²juúh²dsa jǿg³ jøng², ca¹he¹dsa ju²góg¹dsa quianh¹³ mu²tsønh³dsa. Ca¹lø¹hiúg¹ hlaih¹³ dsǿa¹² dsa² quianh¹³dsa, mi³ca¹jǿi²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jøng² ca¹juúh² Jesús: ―Mi³hiúgh³ hniah¹² hoh¹². Tsë́²jni hniah¹² hi² tsø³janh¹³ hniah¹² jǿg³ quiah¹² Diú¹³, ju³lah ca¹tsei¹ ti³ŋieh¹jni jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mi³ma²na²juúh² Jesús jǿg³ jøng², ca¹jiég²dsa quiah¹² dsa² quianh¹³dsa. Ca¹juúh²dsa: ―Hieh³ hniah¹² jmi²dsí² han¹³. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dsa¹hén² dsag³ quiah¹² lǿa¹² ju³ hein² dsa² ca¹hénh² hniah¹² dsag³ quiah¹². Jøng² ha¹chi² dsa¹hén² dsag³ quiah¹² dsa² tsa¹hénh² hniah¹² quiah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jmai³ jøng² tsa¹hiúg³ Tomás, dsa² tǿh²dsa Guing² Og¹, jøa³ ja³tiogh³ dsa² guia¹tón² jian¹²dsa. Ha¹chian²dsa chian² mi³ca¹mi¹jnia¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jøng² ca¹juúh² dsa² guia¹tón² jian¹²dsa, ca¹tsáih¹dsa Tomás mi³na²dsiég¹dsa: ―Ma²na²ne¹³ jnieh³ Juu¹³ jniang³ ―ca¹juúh²dsa. Jøng² ca¹juúh² Tomás: ―¡Ju³ná³ tsa¹ma²ca¹jái¹jni ja³ca¹ŋi¹toh¹³ møi¹ŋí³ ju²góg¹dsa, ju³ná³ tsa¹ma²ca¹tí²jni nih¹³ chi³góg¹jni ja³jøng² calah quianh¹³ ja³ca¹hǿh²dsa mu²tsønh³dsa, tsa¹hé²jni jǿg³ hi² ma²ca¹hiog²dsa! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mi³ma²jŋi¹ jmai³ jøng², ma²tiogh³ dsa² quianh¹³ Jesús dsi²néi² calah. Ma²quianh¹³dsa Tomás. Ju³ he² jín³ chi³jnái¹³ cu²rø² hag³hniú¹³ ja³tiogh³dsa, cónh¹jøng² ma²tsenh¹² Jesús dsi²jo² ja³tiogh³ dsa² quianh³dsa mi³ca¹lø¹lih¹³dsa. Jøng² ca¹juúh² Jesús: ―Mi³hiúgh³ hniah¹² hoh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jøng² ca¹tsáih¹ Jesús Tomás: ―Jai³ di³ ju²góg¹jni. Tí² nih¹³ chi³gógh¹. Cuø³ gugh². Tí² gugh² mu²tsønh³ quieg¹jni. Tsa¹jmóh³hning hi² tsa¹héh²hning jǿg³. Ju³héh³ báh³ hning² jǿg³ quieg¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jøng² ca¹juúh² Tomás: ―Juu¹jni, Diú¹³ quian¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jøng² ca¹juúh² Jesús: ―Na¹ jín³ ma²héh²hning jǿg³ ca¹hiog²jni, Tomás. Di³ ma²na²jaih³hning jní². Hioh¹² jenh¹² dsa² li¹hé² jǿg³ hi² ha¹chi² ca¹jǿi²dsa jní² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jøng² ca¹jmo¹ Jesús hliú² juu¹² juøh¹² ja³ta¹ni¹ dsa² quianh¹³dsa, juu¹² juøh¹² ha¹chi² rø²ton¹² ni³ si² la². ");
INSERT INTO cpaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma²ca¹løa¹ si² la², mi³jøng² li¹héh² hniah¹² jǿg³ hi² lán¹² Jesús Cristo, jong¹² Diú¹³. Mi³jøng² li¹chianh² hniah¹² tiá² ja³cog² Diú¹³ ni³ huu¹³ quiah¹² Jesús, na³ma²ca¹héh¹ hniah¹² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ni³ jøng² ca¹mi¹jnia¹² Jesús ni³ dsa² quianh¹³dsa chiuh³ jmøi² juøh¹² tsen² Tiberias. Lah¹la² báh³ ca¹jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cøng² ja³mi³tiogh³ Simón Pedro, quianh¹³ Tomás (dsa² tǿh²dsa Guing² Og¹), quianh¹³ Natanael, dsa² chian² Caná, juøi² tén¹² Galilea, quianh¹³ ta³og¹ ja³ŋiúh³ Zebedeo, quianh¹³ og¹ dsa² siáh², dsa² guia¹tón² jian¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jøng² ca¹juúh² Simón Pedro: ―He³ jní² nei¹³ ŋi³chiánh¹ jáh² tiogh³ jmøi² ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² quianh¹³dsa: ―Dsǿg³ jnieh³ quianh¹³ hnéng¹ ―ca¹juúh²dsa. Jøng² ca¹uǿi²dsa ni³ barco. Ca¹ŋi¹lé²dsa juu¹² ni³ jmøi². Cónh¹jøng² ha¹chian² jáh² ca¹lǿh²dsa jin² jan² ta³cøng² ja³neng² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jøng² cónh¹ nioh¹² hi³méh¹ ca¹dsiég¹ Jesús chiuh³ jmøi², cøg¹² ja³tiogh³dsa. Tsa¹ŋi¹² dsa² héi² hi² lán¹²dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jøng² ca¹juúh² Jesús: ―¡Guiuh¹³! ¿Tsa³ma²na²lëh¹ hniah¹² jáh²? ―ca¹juúh²dsa. Jøng² ca¹juúh² dsa² héi²: ―Ca¹lah¹jin³ jan² jáh² tsa¹ma²na²lǿh¹ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jøng² ca¹juúh² Jesús: ―Héi² di³ cøng² néng³ quiánh² jag¹³ tø²guia¹jo¹³ barco, ja³ná³ báh³ léh² hniah¹² jáh² ―ca¹juúh²dsa. Jøng² ca¹hǿi²dsa néng³ ja³jøng². Jue¹² hlaih¹³ jáh² ca¹ŋi¹tiogh¹ niúh¹ néng³. Ca¹lah¹jín³ tsa¹tiúh¹dsa li¹dsa néng³ dsi²jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jøng² ca¹juúh² jan² dsa² guia¹tón², dsa² hnio¹ Jesús hiug¹² héi², ca¹tsáih¹dsa Pedro: ―¡Juu¹³ báh³ jniang³ jnung²! ―ca¹juúh²dsa. Ca¹lah¹cónh¹ mi³ca¹nǿng² Simón Pedro jǿg³ jøng² hi² lán¹² dsa² héi² Juu¹³ jniang³, ta³lah¹ca¹cáih¹dsa tsǿnh³dsa ma²ca¹jŋíh²dsa ja³jmo¹²dsa ta³. Jøng² ca¹tiah¹dsa dsi²jmøi². Ca¹ŋó¹dsa ta³tí³ juu¹² ja³tsenh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jøng² ca¹dsi¹lé² dsa² mi³quianh¹³ Pedro chiuh³ jmøi² juu¹² barco. Tsøah¹²dsa néng³ chi³cángh² tiogh³ jáh² tiogh³ jmøi². Mi³tiogh³ dsa² héi² cónh¹ ŋi²lǿg² metro cónh¹ ja³lǿa¹³ chiuh³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mi³ca¹siog² dsa² héi² ni³ barco, ca¹jái¹dsa ma²neng¹² cøng² si² lǿa¹² si² tah². Ma²tiogh³ jáh² ni³ si² quianh¹³ hi³ŋíh¹. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jøng² ca¹juúh² Jesús: ―Gu³quian² jan² og¹ jáh² ma²na²lëh¹ hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jøng² ca¹uǿi² Simón Pedro ni³ barco. Jøng² ca¹tsø² ca¹cuǿnh¹dsa néng³ ca¹tǿ² chiuh³ jmøi². Tiogh³ jáh² jmøi² ca¹lah¹chi³cángh², jmáh¹lah jáh² canh¹³. Ŋia²lúg² rø²dsǿ² to¹lu¹guián² rø²dsǿ² úg² jáh² mi³té¹². Ju³ he² jín³ jue¹² jáh² mi³tiogh³, ha¹chi² ca¹gøi² néng³. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jøng² ca¹juúh² Jesús: ―Ŋi³noh¹² hniah¹². Ŋi³quíh³ hniah¹² ―ca¹juúh²dsa. Ca¹lah¹jin³ jan² dsa² héi² tsa¹ca¹tí² dsǿa¹² ŋai¹ hein² dsa² héi². Lø²lih¹³ báh³ dsa² hi² lán¹² dsa² héi² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jøng² ca¹ŋi³can¹³ Jesús hi³ŋíh¹ quianh¹³ jáh² tiogh³ ni³ si². Ca¹cuúh¹dsa dsa² guiog¹ héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jøng² ca¹tǿ² hnaih² rón² hi² ca¹mi¹jnia¹² Jesús ni³ dsa² quianh¹³dsa, cónh¹ jmai³ mi³ma²ca¹hiog²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mi³ma²na²lø¹tan¹³dsa, jøng² ca¹juúh² Jesús, ca¹tsáih¹dsa Simón Pedro: ―Simón, ja³ŋiúh³ Jonás, ¿hiug¹³ hnángh¹hning jní² cónh¹ jín³ dsa² ná¹²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―Juu¹³ jniang³, ma²ŋih³ báh³ hning² hi² hnó¹jni hning² ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Jøng² heh¹³hning dsa² quian¹jni jǿg³ dsio¹ quieg¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jøng² ca¹juúh² calah Jesús: ―Simón, ja³ŋiúh³ Jonás, ¿hiug¹³ hnángh¹hning jní²? ―ca¹juúh²dsa. Jøng² ca¹juúh² Pedro: ―Juu¹³ jniang³, ma²ŋih³ báh³ hning² hi² hnó¹jni hning² ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Jøng² jmóh³hning hí³ dsa² quian¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jøng² ca¹juúh² calah Jesús, ja³ca¹tǿ² hnaih² rón²: ―Simón, ja³ŋiúh³ Jonás, ¿hiug¹³ hnángh¹hning jní²? ―ca¹juúh²dsa. Hlaih¹³ ca¹jính¹ Pedro, mi³ca¹tǿ² hnaih² rón² ca¹ŋai¹ Jesús chi² ju³ná³ hniang¹dsa. Jøng² ca¹juúh² Pedro: ―Juu¹³ jniang³, ma²ŋih³ báh³ hning² ca¹lah¹jǿ¹. Ma²ŋih³ báh³ hning² hi² hnó¹jni hning² ―ca¹juúh²dsa. Jøng² ca¹juúh² Jesús: ―Jøng² heh¹³hning dsa² quian¹jni jǿg³ dsio¹ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jǿg³ dsøg¹² lah¹dsóh² juǿi²jni hning²: Hŋiah¹hning mi³quieih³hning tsǿinh²hning jmai³ mi³tsih²hning. Mi³ŋøh²hning ha² juu¹² ja³hnøngh²hning. Na³ma²ca¹guiugh²hning, jah¹³hning cugh²hning. Di³ jøng² quieih¹ dsa² siáh² hning² hmøah¹². Di³ jøng² dsø¹jiag¹²dsa juu¹² ja³tsa¹hnøngh²hning góh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ca¹juúh² Jesús jǿg³ jøng² hi² hniu¹dsa juúh²dsa ha²lah jón² Pedro, hi² mi¹juanh¹²dsa Diú¹³. Ni³ jøng² ca¹juúh² Jesús: ―¡Ŋieh¹³hning! Dseh¹³hning cah¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mi³ca¹jénh¹ Pedro, jøng² ca¹jë́²dsa jan² dsa² guia¹tón² jian¹²dsa héi², dsa² hiug¹² hnio¹ Jesús. Dság¹ dsa² héi² dse¹³ cah³dsa. Dsa² héi² mi³guǿ¹³ cog² Jesús mi³ca¹gǿh¹dsa quiah¹² høa³, dsa² ca¹ŋǿh¹ Jesús: “Juu¹³ jniang³, ¿hein² dsa² hnë¹ hning²?” ");
INSERT INTO cpaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mi³ca¹jë́² Pedro dsa² héi², jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa Jesús: ―Juu¹³ jniang³, ¿ha²lah lé² quiah¹² dsa² ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jøng² ca¹juúh² Jesús: ―Ju³ná³ ca¹lø¹hno¹jni hi² li¹chian² dsa² ná¹² ca¹lah¹ca¹tǿ² jmai³ ja³guiogh¹³jni, ¿he² løa¹ hning² tsa¹dsøg¹² hoh¹²? ¡Hning² ŋieh¹³! Dseh¹³hning cah¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jøng² ca¹lø¹chí¹ jǿg³, hi² lë́² dsa² quianh¹³ Jesús, hi² tsa¹jón² dsa² hiug¹² hnio¹ Jesús héi². Ha¹chi² ca¹juúh² Jesús hi² tsa¹jón²dsa. Lah¹la² báh³ ca¹juúh²dsa: “Ju³ná³ ca¹lø¹hno¹jni hi² li¹chian² dsa² ná¹² ca¹lah¹ca¹tǿ² jmai³ ja³guiogh¹³jni, ¿he² løa¹ hning² tsa¹dsøg¹² hoh¹²?” ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dsa² hiug¹² hnio¹ Jesús héi² báh³ dsa² ca¹jmo¹ si² la², dsa² lán¹² jan² dsa² guia¹tón². Ma²ne³ báh³ jniang³ jǿg³ dsøg¹² lah¹dsóh² juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hliú² hlaih¹³ báh³ hi² ca¹jmo¹ Jesús ta³lah¹ca¹guøn¹dsa jmøi¹guǿi¹. Ju³ jøng² hi² ca¹tiun¹dsa ni³ si² lah¹cøng² lah¹cøng² hi² ca¹jmo¹dsa, lë́²jni jin³ tsa¹mi³heih¹³ si² jøng² ni³ jmøi¹guǿi¹.");
INSERT INTO cpaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lah¹ni³ ca¹jmo¹jni cøng² si², Guiuh¹³ Teófilo. Quianh¹³ si² jøng² ca¹he¹jni ca¹lah¹jǿ¹ hi² ca¹jmo¹ hi² ca¹he¹ Jesús ca¹lah¹cónh¹ mi³ca¹lø¹liág¹, ");
INSERT INTO cpaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ca¹lah¹ca¹tǿ² jmai³ ja³ca¹tai¹ hŋiah¹² Jmi² jniang³ juu¹² guiuh¹³. Jøng² niúh¹ jín³ hi² ca¹ŋáh¹ Jesús, mi³ca¹quióh²dsa tsih² høh³ quián¹²dsa, ca¹togh²dsa tsih² høh³ jǿg³ ju³lah ca¹he¹ jmi²dsí² han¹³ quiah¹² hŋiah¹² Diú¹³ juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jøng² hliú² rón² ca¹jnia¹ Jesús ni³ dsa² héi² ta³lah¹ton¹lág¹ jmai³ jøng² hi² ca¹hiog²dsa. Hliú² hi² ca¹jmo¹dsa. Mi³jøng² li¹dsøg¹² dsǿa¹² dsa² héi² hi² chian²dsa. Ca¹dsii¹dsa jǿg³ ha²lah lé² ja³jmo¹² Diú¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jmai³ jøng² ja³hiúg³ Jesús quianh¹³ dsa² héi², ca¹jmo¹dsa jǿg³ tsa¹ju³huanh¹² dsa² héi² jøa³juøi² Jerusalén. Ca¹juúh²dsa: ―Jøng² janh³ hniah¹² jøa³juøi² la² ca¹lah¹ca¹lø¹ti¹ jǿg³ ca¹juúh² ti³ŋieh¹jni, jǿg³ ca¹juǿi²jni hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Lah¹dsóh² jmáh¹lah jmøi² báh³ ca¹chiog¹ Juan hniah¹². Hiug¹² jín³ hi² dsio¹ jmo¹ Diú¹³ dsa² juanh¹². Di³ ja¹quien¹³ tí²dsa jmi²dsí² han¹³ quiah¹² quiánh² hniah¹² ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ja³mi³tiogh³dsa jøng², ca¹ŋai¹ dsa² héi² Jesús. Ca¹juúh²dsa: ―Ti³guiuh¹³, ¿Ma²tǿ² ja³jmóh³hning hi² liúg² dsa² israel, hi² tsa¹ma¹lén² dsa² chian² ja³siíh³ ta³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jøng² ca¹ŋai¹ Jesús. Ca¹juúh²dsa: ―A¹jáng¹ hniah¹² ca¹të́h² li¹ŋih³ jmai³ ŋi² jmai³ ja³jmo¹ Jmi² jniang³ hi² ma²hiug² dsǿa¹²dsa jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Cónh¹jøng² li¹bí² hoh¹² hniah¹² na³ma²ca¹hí¹ jmi²dsí² han¹³ quiánh² hniah¹². Jøng³ gu³heh³ hniah¹² jǿg³ quieg¹ jní² jøa³juøi² Jerusalén, quianh¹³ ta³cøng² ja³tén¹² Judea, ca¹lah¹quianh¹³ ja³tén¹² Samaria, ca¹lah¹ja³ca¹heh³ hniah¹² jǿg³ ta³cøng² jmøi¹guǿi¹ ―ca¹juúh² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mi³ma²na²juúh² Jesús lah¹jøng², ca¹tai¹ hŋiah¹² Jmi² jniang³ juu¹² guiuh¹³. Ti³jái¹³ dsa² tiogh³ ta³lah¹jøng². Jøng² ha¹chian² ma¹ca¹jǿi² mi³ca¹quiónh¹dsa jøa³jneng¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ja³jøng² tiogh³ dsa² héi², ti³jái¹³dsa guiuh¹³ ja³na²ŋáh¹ Jesús, mi³ma²tiogh³ og¹ dsa² ŋioh¹² quianh¹³dsa, dsa² chian² ŋi¹juǿi¹ quieih¹² hmøah¹² tég¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jøng² ca¹juúh² dsa² ŋioh¹² héi²: ―Hniah¹² dsa² chianh² Galilea, ¿he² løa¹ hniah¹² tiogh³ ti³jáih² juu¹² guiuh¹³? Ma²na²u¹hái¹ báh³ Jesús jøa³ja³tiogh³ hniah¹². Ma²na²ŋáh¹dsa juu¹² guiuh¹³. Di³ hŋiah¹² báh³ Jesús héi² jiúgh² calah. Lah¹jøng² báh³ jiúgh²dsa ju³lah ma²na²jaih³ hniah¹² mi³na²ŋáh¹dsa juu¹² guiuh¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jøng² ca¹ŋi¹lia¹ dsa² héi² juu¹² máh², máh² tsen² Olivo. Ca¹ŋi¹lia¹dsa juu¹² jøa³juøi² Jerusalén. Ha¹chi² uǿin² juu¹². Cónh¹ jøng² báh³ té¹² juu¹² ca¹lah¹cónh¹ ja³ma²lǿa¹² lei¹³ hi² lé² ŋi¹nio¹ dsa² judío jmai³ sa³¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jøng² mi³ca²dsi¹lia¹dsa jøa³juøi², ca¹ŋi¹lia¹dsa guiuh¹³ hniú¹² ton¹ jué¹ ja³mi³tiogh³dsa. Quianh¹³dsa Pedro, quianh¹³ Juan, quianh¹³ Jacobo, quianh¹³ Andrés, quianh¹³ Felipe, quianh¹³ Tomás, quianh¹³ Bartolomé, quianh¹³ Mateo, quianh¹³ Jacobo, ja³ŋiúh³ Alfeo, quianh¹³ Simón, dsa² cananista, quianh¹³ Judas, ja³ŋiúh³ Jacobo. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ca¹lah¹já¹ dsa² héi², tiogh³dsa cøng² jǿg³. Ti³hlanh¹²dsa Diú¹³. Quianh¹³dsa hio¹³, quianh¹³ roh¹³ Jesús, quianh¹³ María, mi³chiég³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jmai³ jøng² mi³tiogh³ ŋia¹lúg² rø²dsǿ² guiúg²dsa, dsa² roh¹³ jniang³. Jøng² ca¹nung² Pedro jøa³ ja³tiogh³dsa. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Hniah¹², dsa² roh¹³ jniang³, hi² hniuh¹² báh³ li¹ti¹ jǿg³ ca¹he¹ jmi²dsí² han¹³ quiah¹² Diú¹³, ju³lah lǿa¹² ni³ si² ca¹jmo¹ hlai³ Davíd, jǿg³ quiah¹² Judas. Di³ ca¹ŋi¹jian¹ Judas dsa² jue¹² ja³ca¹ŋi³chiánh³dsa Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mi³hiúg³ Judas quianh¹³ jniang³. Ca¹hia¹ Jesús Judas. Lah¹jøng² mi³jmo¹²dsa, ju³lah jmo² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hi² jøng² dsa² ca¹ŋi³lii¹³ cøng² huø¹ quianh¹³ cog³ ca¹lǿh¹ Judas, ja³ca¹jmo¹dsa hi² hlaih¹³ jøng². Ja³jøng² ca¹tánh² Judas ta¹rø²hén³dsa. Jøng² cu²dsie¹² ca¹ná² togh¹²dsa. Ca¹huøh¹² jmø³hmai¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jøng² mi³ca¹lø¹ŋi¹² dsa² chian² Jerusalén, ca¹tǿh¹dsa huø¹ jøng² Acéldama, hi² hniu¹dsa juúh²dsa Huø¹ Ca¹hnë¹dsa Dsa². ");
INSERT INTO cpaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Di³ lah¹la² rø²juúh² si² Salmos: Ju³lé³ tsa¹ma¹tiogh³ dsa² hniu³dsa. Ju³lé³ tsa¹chian² ma¹chian² dsi²néi². Jø¹² bíh³ lah¹la² rø²juúh² si² calah: Ju³gu² dsa² siáh² dsié¹²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Jøng² ju³lé³ lah¹jøng². Di³ tiogh³ báh³ dsa² héi² ja³la², dsa² ca¹ŋi²nio³ quianh¹³ jniang³ tiá², cónh¹ jmai³ ja³mi³quianh¹³ jniang³ Jesús, Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ca¹ŋi³lé³ dsa² héi² cónh¹ jmai³ ja³ca¹jŋó² Jesús jmøi² ca¹chiag¹ Juan. Cøng² hi² quianh¹³ báh³ dsa² Jesús ca¹lah¹ca¹tǿ² ja³ca¹ŋáh¹dsa juu¹² guiuh¹³. Jan² dsa² lah¹héi² mi³gú¹ quianh¹³ jniang³. Mi³jøng² he¹dsa jǿg³ hi² ca¹hiog² Jesús, ju³lah jmo² jniang³ ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jøng² ca¹hia¹ dsa² tiogh³ og¹ dsa². Jan² dsa² tsen² Matías. Jan² dsa² tsen² José Justo. Jø¹² bíh³ tǿh²dsa José calah Barsabás. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ni³ jøng² lah¹la² ca¹hlanh¹dsa Diú¹³: ―Juu¹³ jniang³, hning² ma²ŋih³ ha²lah lǿa¹² dsǿa¹² jnieh³ dsa² jmøi¹guǿi¹. Jøng² hning² héh³ hein² dsa² og¹ lang¹² cuanh¹³hning gú¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mi³jøng² lén²dsa tsih² høh³ quiánh²hning. Gú¹dsa dsié¹² Judas. Di³ ma²ca¹u¹hái¹ Judas ta³ quiánh²hning. Ca¹ŋáh¹dsa juu¹² ja³ca¹të́²dsa ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jøng² mi³ca¹dsi¹dsa jǿg³, Matías báh³ ca¹të́². Jøng² ca¹gú² Matías quianh¹³ dsa² guia¹ján¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jøng² cøng² ja³mi³tiogh³ ca¹lah¹já¹dsa mi³ca¹tǿ² jmai³ Ton¹lug¹guií². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Cónh¹ tsa¹ju³jŋia¹³ jmai³ jøng², ca¹nǿng²dsa cøng² hi² hein¹³ tí², ca¹já¹ juu¹² guiuh¹³, ju³lah cøng² ja³ca¹já¹ dsí² tí². Ca¹hein¹³ ta³cøng² hniú¹² ja³mi³tiogh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jøng² ca¹jni¹ hliú² hi² píh³, hi² jní² ju³lah jní² si². Ma¹cǿng¹ hi² píh³ jøng² lah¹jan²dsa ma²ti³hai¹³ dsi³guiuh²dsa mi³ca¹lø¹lih¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jøng² ca¹can¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³. Ni³ jøng² ca¹jmo¹ jmi²dsí² han¹³ hi² ti³hløah¹² dsa² héi² hliú² ni³ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jmai³ jøng² mi³tiogh³ dsa² judío jøa³juøi² Jerusalén, dsa² hnio¹ Diú¹³, dsa² ca¹ja¹lé² ta³cøng² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jøng² jue¹² dsa² héi² ca¹túgh² mi³ca¹løa¹ cu²møah¹³. ―¿He² bíh³ lǿ²? ―lë́²dsa. Di³ ca¹nǿng²dsa jǿg³ quiah¹²dsa lah¹jan² lah¹jan²dsa, hi² ti³hløah¹² dsa² ca¹can¹ jmi²dsí² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jøng² dsogh¹² dsǿa¹²dsa. Ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juuh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","―Jai³lah, dsa² chian² ja³tén¹² Galilea dsa² ti³hløah¹² tiogh³. Ha²lah dsio¹ hløah¹² dsa² ná¹² jǿg³ quián² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jøng² chian² ca²dsiog³ jniang³ ja³tén¹² Partia, quianh¹³ Media, quianh¹³ Elam, quianh¹³ Mesopotamia, quianh¹³ Judea, quianh¹³ Capadocia, quianh¹³ Ponto, quianh¹³ Asia, quianh¹³ Frisia, ");
INSERT INTO cpaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","quianh¹³ Panfilia, quianh¹³ Egipto, quianh¹³ ja³tioh¹³ juøi² tén¹² Africa ŋai¹² ja³tén¹² Cirene. Jø¹² bíh³ tiogh³ ja³la² quianh¹³ jniang³ dsa² judío chian² Roma, quianh¹³ dsa² siáh² chian² Roma, dsa² ma²hlanh¹² Diú¹³ ju³lah hlaih¹² dsa² judío. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Dsa² chian² ja³tén¹² Creta quianh¹³ Arabia, tiogh³ calah ca²dsiog³ dsa² héi² ja³la². ¿Ha²lah lǿ² jøng²? Di³ neng² jniang³ quianh¹³ jǿg³ quián² jniang³ ca¹lah¹jái¹ jniang³ jǿg³ ha²lah lǿa¹² juu¹² juøh¹² jmo¹² Diú¹³, hi² hløah¹² dsa² ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hi² jøng² ca¹can¹dsa gøg². Dsogh¹² dsǿa¹²dsa ca¹lah¹já¹dsa. Ca¹dsii¹dsa jǿg³ guiog¹³dsa. Ca¹juúh²dsa: ―¿He² lǿ²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Cónh¹jøng² ca¹cu² ca¹jmágh² ca²dsiog³dsa. Ca¹juúh²dsa: ―Dsa² ti³hen¹² báh³ ná¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jøng² ca¹nung² Pedro cu¹dsie¹² quianh¹³ dsa² guia¹ján¹. Ca¹hløah¹dsa tí². Ca¹tsáih¹dsa dsa² jue¹². Ca¹juúh²dsa: ―Hniah¹² dsa² judío, quianh¹³ ca¹lah¹jáh¹ hniah¹² dsa² tiogh³ jøa³juøi² Jerusalén la², jmóh³ hniah¹² juanh¹² hoh¹² hniah¹². Nǿngh³ hniah¹² jǿg³ quieg¹jni. Mi³jøng² li¹ŋih³ hniah¹² ha²lah lǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","A¹jáng¹ ju³ lah¹jøng², hi² ma²hen¹² dsa² lang¹². ¿He² løa¹ hniah¹² juúh² dsa² ma²hen¹²? Jø² ma²na²tǿ² hein¹³ ŋiu¹ tu¹heg². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jǿg³ siíh² báh³ hi² la², jǿg³ ca¹hǿ² hlai³ Joel, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Di³ lah¹la² rø²juúh² si² quiah¹²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Lah¹la² lé², juúh² Diú¹³, na³ma²ja¹quien¹³ hén² jmøi¹guǿi¹. Tí¹³jni jmi²dsí² quieg¹jni quiah¹² ca¹lah¹já¹ dsa². Jøng² hǿ² ja²ŋiúh² ja²máih¹ hniah¹² jǿg³ quieg¹jni. Jmo³jni li¹ŋi¹² dsa² tsih² ha²lah lé² quianh¹³ lah¹cøng² hi² cøa²dsa. Jmo³jni hi² li¹ŋë́h² dsǿa¹² dsa² canh¹³ he² hi² ca¹cøa¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jmai³ jøng² tí¹³jni jmi²dsí² quieg¹jni quiah¹² dsa² mi²ti¹ ne¹jni, cu¹dsie¹² dsa² ŋioh¹² quianh¹³ dsa² mǿ². Mi³jøng² hǿ²dsa jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jmo³jni hi² gøg² juu¹² dsi³guøi². Jmo³jni hi² li¹dsogh¹² dsǿa¹²dsa ni³ guøh³ ni³ huø¹: Jmø², quianh¹³ si², quianh¹³ jmi³ŋi³ lǿa¹² jneng¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Iég¹ si² quiah¹² hieg². Li¹guión² tsøh² ju³lah lǿa¹² jmø². Lah¹jøng² báh³ lé² niúh¹ jín³ hi² tøa¹ jmai³ juøh¹² lah¹dsóh², jmai³ quieg¹ jní², Juuh² hniah¹². Léi¹³ lé² na³ma²ca¹tǿ² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ju³ná³ hein² dsa² møa¹ mi³ho³jni, dsa² héi² liúg², rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jøng² hniah¹² dsa² israel, nǿngh³ hniah¹² jǿg³ hi² juøh¹³jni ―ca¹juúh² Pedro. ―Hŋiah¹² Diú¹³ dsa² juanh¹² ca¹mi¹léi¹³ hi² ca¹tse¹dsa Jesús, dsa² chian² Nazaret. Ma²ŋih³ báh³ hniah¹² ca¹cuø¹ Diú¹³ bí² hi² ca¹jmo¹ Jesús hliú² juu¹² juøh¹² quianh¹³ hi² gøg² jøa³ ja³tiogh³ hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma²lǿih² tsa¹ŋi¹² Diú¹³ he² jmai³ ja³cuan¹dsa Jesús. Mi³ca¹cuai¹dsa jøng², ca¹jëh³ hniah¹² dsá¹ quiah¹² dsa² tsa¹hniu¹ lei¹³ quiah¹² Diú¹³. Hniah¹² báh³ neng¹² neih³ hi² ca¹jŋëh¹ dsa² héi² Jesús ni³ crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jøng² ca¹jmo¹ Diú¹³ juanh¹² hi² ca¹hiog² Jesús. Tsa¹ca¹cuø¹dsa jǿg³ hi² dsa¹hén²dsa. Tsa¹lé² dsa¹hén² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Di³ lah¹la² ca¹juuh² hlai³ David, hi² ca¹hia¹dsa Jesús: Guiang³jni hi² jiag¹² Juu¹³jni tiá². Quianh¹³ báh³ dsa² jní², mi³jøng² tsa¹høa¹² dsøa¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hi² jøng² báh³ hioh¹² jéin¹²jni. Juøh¹²jni hi² tøa¹² dsøa¹jni. Cøng² hi² chian²jni ju²hiúg¹ dsøa¹², di³ mi¹hag¹³ báh³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tsa¹cuø¹dsa jǿg³ hi² dság¹ cu¹té¹² jmi²dsí² quieg¹jni ja³tiogh³ dsa² ma²ca¹dsan¹. Tsa¹cuø¹dsa jǿg³ hi² dsa¹hén² quieg¹jni, jní² dsa² dsiog¹ quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dsa² héi² ma²ca¹he¹ juu¹² ja³ŋøa¹²jni. Dsa² héi² báh³ jmo¹² hioh¹² jéin¹²jni, di³ ŋøa¹²dsa quianh¹³ jní², ca¹juúh² hlai³ David. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Hniah¹² dsa² go² jniang³, ma²ŋih³ báh³ hniah¹² ha²lah ca¹løa¹ quiah¹² hlai³ David, dsa² hóg¹ quián² jniang³. Di³ ca¹jon¹dsa. Ca¹ŋi³hag¹dsa. Ca¹lah¹jin³ na¹ lǿa¹² ja³rø²hog¹²dsa jøa³ ja³tiagh³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Cónh¹jøng² dsa² hǿ² jǿg³ quiah¹² Diú¹³ mi³lán¹² hlai³ David. Ma²ŋi¹²dsa ca¹mi¹dsøg¹² Diú¹³ jǿg³ hi² lén² jan² tsø³jong¹³dsa rai¹³, ju³lah lán¹²dsa hŋiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jøng² ca¹juúh² hlai³ David ha²lah lé² ta¹chi³quë́¹ quiah¹² Cristo: Hi² hiog¹dsa, hi² tsa¹dság¹dsa cu¹té¹² ja³tiogh³ dsa² ma²ca¹dsan¹, hi² tsa¹dsa¹hén² jmø²ŋǿ¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesús héi² báh³ ca¹hiog², ca¹jmo¹ Diú¹³ dsa² juanh¹². Ma²ca¹ne¹³ jnieh³ dsá¹ ca¹lah¹jái¹ jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mi³ca¹tai¹ Diú¹³ juu¹² ja³cog²dsa, mi³ca¹lø¹juanh¹² Jesús, jøng² ca¹cuø¹ Diú¹³ jmi²dsí² han¹³, ju³lah ca¹juúh²dsa lah¹jiá¹². Hi² jøng² báh³ la², hi² ma²jáih² hniah¹², hi² ma²nøngh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Di³ a¹jáng¹ ju³ hlai³ David dsa² ca¹ŋáh¹ juu¹² guiuh¹³. Lah¹la² báh³ ca¹juúh² David hŋiah¹²: Ca¹tsáih¹ Juu¹³ jniang³ Juu¹ jní², ca¹juúh²dsa: Ju³tiágh³ quianh¹³ jní² ");
INSERT INTO cpaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ca¹lah¹ca¹tǿ² jmai³ ja³ca¹jmo¹jni li¹dsenh¹³hning, tsa¹ma¹quien¹² dsa² hiag¹³hning, ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jøng² ca¹juúh² Pedro: ―Hi² jøng² lah¹la² báh³ lah¹dsóh² hniuh¹² li¹ŋi¹² ca¹lah¹já¹ dsa² israel: Hi² ca¹jmo¹ Diú¹³ ma²lán¹² Jesús Cristo, Juu¹³ jniang³. Diú¹³ báh³ ca¹hia¹ Jesús. Jesús héi² báh³, dsa² ca¹jŋë́h¹ hniah¹² ni³ crǿg¹³ ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mi³ma²na²nǿng² dsa² tiogh³ héi² jǿg³ jøng², jǿg³ ca¹juúh² Pedro, jøng² ca¹túgh²dsa høa¹² dsǿa¹²dsa. Ca¹ŋai¹dsa Pedro quianh¹³ tsih² høh³ jian¹²dsa. Ca¹juúh²dsa: ―¿He² hi² hniuh¹² jmó³ jnieh³, roh¹³ jniang³? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jøng² ca¹ŋai¹ calah Pedro. Ca¹juúh²dsa: ―Ju³jeinh¹³ hoh¹² hniah¹² ja³cog² Diú¹³. Ju³tsogh² hniah¹² jmøi². Hi² jøng² ma²lanh¹² hniah¹² léi¹³ ma²quianh¹³ hniah¹² Jesucristo. Mi³jøng² hén² dsag³ quiánh² hniah¹². Jøng² tí² Diú¹³ jmi²dsí² han¹³ quiah¹²dsa quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jǿg³ quián² jniang³ báh³ la² ca¹jmo¹ Diú¹³, quianh¹³ tsih² guing², ca¹lah¹ma¹quianh¹³ ca¹lah¹já¹ dsa² tiogh³ guiég¹, lǿa¹² ju³ ca¹tøa¹ Diú¹³, Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hliú² jǿg³ lah¹jøng² ca¹juúh² Pedro. Ca¹togh²dsa dsa² héi² jǿg³. Jøng² ca¹juúh²dsa calah: ―Ju³liúgh³ hniah¹². Tsa¹ma¹gu³noh¹² hniah¹² quianh¹³ dsa² ti³re² dsag³. Quianh¹³ Diú¹³ báh³ gu³noh¹² hniah¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jøng² dsa² ca¹hie¹ jǿg³, ca¹jŋó² dsa² héi² jmøi². Mi³té¹² cónh¹ hnøa¹² mei¹³ dsa² ca¹lø¹quianh³dsa cøng² jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tí² ca¹chính²dsa juu¹² ca¹he¹ tsih² høh³. Ca¹túgh²dsa cøng² jǿg³ quianh¹³dsa. Cøng² ja³ca¹gǿh¹dsa. Cu¹dsie¹² lah¹jøng² báh³ dsa², ti³hlanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ca¹lah¹já¹ báh³ dsa² ca¹túgh²dsa gan¹dsa Diú¹³. Hliú² juu¹² juøh¹² ca¹jmo¹ tsih² høh³ quianh¹³ hi² gøg². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jøng² ca¹lah¹já¹ dsa² hé² jǿg³, cøng² ja³ca¹dsii¹dsa hi² mi³chi² quiah¹²dsa ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jøng² mi³ca¹hnai¹dsa hi² mi³chi² quiah¹²dsa, lǿa¹² ju³ huø¹, lǿa¹² ju³ hi² mi³chi² dsi²néi², jøng² ca¹dsiúh¹dsa cog³. Ca¹cuúh¹dsa dsa² roh¹³ jniang³, cónh¹ dsa² chi³quian¹³ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lah¹cøng² lah¹cøng² jmai³ cøng² jǿg³ báh³ tiogh³dsa dsa²lé²dsa guøh¹². Ca¹gǿh¹dsa quianh¹³ dsa² roh¹³ jniang³. Hiug² dsǿa¹²dsa ca¹cuúh¹dsa dsa² roh¹³ jniang³ hi² ca¹gǿh¹dsa. Hioh¹² jenh¹²dsa lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ca¹mi¹juanh¹²dsa Diú¹³. Tøa¹² báh³ dsǿa¹² dsa² juøi² jian¹²dsa ha²lah ŋi²nio³dsa. Jøng² ca¹jmo¹ Diú¹³ ca¹ŋi¹jué² dsa² hé² jǿg³ quiah¹²dsa lah¹cøng² lah¹cøng² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ma²dsø²lé² Pedro quianh¹³ Juan juu¹² guøh¹², hi² dsa¹hlanh¹³dsa Diú¹³ hein¹³ hnøa¹² ta¹ca¹hlég², ju³lah ma²lǿa¹² mai³¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jøng² mi³guǿ¹³ jan² dsa² dsoh³ hag³ guøh¹², dsa² tsa¹lé² ŋøa¹ ca¹lah¹cónh¹ mi³ca¹lø¹chián¹dsa. Hermosa mi³tsen² hag³ guøh¹² jøng². Ja³jøng² mi³dsa¹dsiag¹ dsa² ca¹lah¹jǿ¹ jmai² ja³mi³møah¹²dsa dsa² dsa²lé² cog³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mi³ca¹jái¹ dsa² dsoh³ dság¹² Pedro quianh¹² Juan guøh¹², jøng² ca¹møa¹dsa cog³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mi³ca¹jǿi² Pedro quianh¹³ Juan, jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa dsa² dsoh³: ―Lah¹jai³lah ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jøng² ca¹jái¹ dsa² dsoh³. Lë́²dsa cuø¹dsa cog³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jøng² ca¹juúh² Pedro: ―A¹jáng¹ cog³ teg² chi² quieg¹jni, a¹jáng¹ cog³ niáng¹³. Di³ cuø¹³ báh³ jní² hi² chi² quieg¹jni báh³. Quianh¹³ ju²bí² quiah¹² Jesucristo, dsa² chian² Nazaret báh³, hi² ŋǿh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jøng² ca¹chính² Pedro gug² dsa² dsoh³, gug²dsa dsio¹. Ca¹chiag¹dsa juu¹² guiuh¹³. Dsø¹juu¹² jøng² ca¹lø¹bé² tai³ dsa² dsoh³ ca¹lah¹ma¹quianh¹³ lø³tai³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jøng² cu²ŋieih¹³ ca¹ŋøa¹dsa mi³ca¹nung²dsa. Cu¹dsie¹² ca¹ŋi¹lé²dsa juu¹² guøh¹² quianh¹³ Pedro quianh¹³ Juan. Dsa² mi³dsoh³ héi², cøng² qui³chiog¹² qui³cog¹²dsa ŋó¹²dsa. Hioh¹² jenh¹²dsa mi³ma²ŋøa¹²dsa. Ca¹mi¹juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jøng² ca¹lah¹já¹ dsa² tiogh³ ti³jái¹³dsa mi³ma²ŋøa¹²dsa mi²juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jøng² ca¹lø¹dsogh¹² dsǿa¹² dsa² ti³jái¹² mi³ca¹lø¹lih¹³dsa dsa² héi² ŋøa¹², dsa² mi³guǿ¹³ møa¹² cog³ hag³ guøh¹² hermosa héi². Lë́²dsa: ―¿Ha² bíh³ láh² ca¹løa¹ quiah¹²dsa? ―lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jøng² dsa² mi³dsoh³ héi² tsa¹ma¹ca¹tiúg²dsa Pedro quianh¹³ Juan. Mi³ca¹dsi¹lé²dsa cøng² ja³tsen² Portal de Salomón, jøng² ca¹túgh² dsa² jue¹² quianh¹³dsa. Dsogh¹² dsǿa¹²dsa ma²ŋøa¹² dsa² mi³dsoh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mi³ca¹jái¹ Pedro, ca¹tsáih¹dsa dsa² jue¹². Jøng² ca¹juúh²dsa: ―Hniah¹² dsa² israel, ¿he² løa¹ gøg² dsogh¹² hoh¹² hniah¹² tiogh³ hniah¹² ti³jáih²? A¹jáng¹ ju³ hi² dsiog¹ jnieh³ ma²ŋøa¹² dsa² lang¹². A¹jáng¹ ju³ ju²bí² quián² jnieh³ ca¹jmo¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Diú¹³ quián² hlai³ Abraham, quianh¹³ hlai³ Isaac, quianh¹³ hlai³ Jacob, Diú¹³ héi² báh³ ca¹jmo¹, Diú¹³ quián¹² dsa² hóg¹ quián² jniang³. Diú¹³ héi² báh³ ca¹jmo¹ juanh¹² Jesús, dsa² quián¹²dsa, dsa² ca¹jëh³ hniah¹². Jøng² hniah¹² tsa¹ca¹cuøh³ jǿg³ liúg² Jesús. Di³ mi³lég² Pilato. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ha¹chi² ca¹cuøh³ hniah¹² jǿg³ liúg² dsa² dsiog¹, dsa² han¹³. Dsa² ca¹jŋëh¹ dsa² báh³ ca¹møah³ hniah¹² liúg². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jøng² ca¹jŋë́h¹ hniah¹² Jesús, dsa² cuǿ¹² ju²bí² quián² jniang³. Ni³ jøng² ca¹jmo¹ Diú¹³ dsa² juanh¹² ca¹hiog² Jesús. Ma²ca¹ne¹³ jnieh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hé² báh³ jnieh³ jǿg³ quiah¹² Jesús. Hi² jøng² báh³ ca¹jmo¹ hŋiah¹² Jesús ma²bé² dsa² lang¹², dsa² janh³ hniah¹², dsa² cueh¹² hniah¹². Ca¹jmo¹dsa ma²dsiog¹dsa ja³jáih² hniah¹². Di³ hé² jnieh³ jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jøng² dsa² go² jniang³, guiang³ báh³ jní² tsa¹ŋih³ hniah¹² ha²lah ca¹jmoh³ hniah¹² mi³ca¹jmoh³ hniah¹² lah¹jøng² ca¹lah¹quianh¹³ dsa² ta³ quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Diú¹³ ca¹cuø¹ hi² ca¹jmoh³ hniah¹² lah¹jøng². Mi³jøng² li¹ti¹ jǿg³ quiah¹²dsa, jǿg³ ca¹juúh²dsa lah¹jiá¹². Di³ ma²lǿih² tsa¹juúh² dsa² hǿ² jǿg³ quiah¹² Diú¹³ hi² mi³cañ² Cristo jmø³uai¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jøng² ju³jeinh¹³ hoh¹² hniah¹². Ju³ŋi³nioh³ hniah¹² quianh¹³ Diú¹³. Mi³jøng³ hén² dsag³ quiánh² hniah¹². Mi³jøng² cuø¹ Diú¹³ jmai³ ja³tanh¹³ hniah¹² bí². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jøng² tsen¹ Diú¹³ juanh¹² calah Jesús, dsa² ma²lǿa¹² jǿg³ lah¹jiá¹² lán¹²dsa Cristo quiánh² hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cónh¹jøng² tiog¹³ báh³ hniuh¹² gú¹ Jesús cu²hna² ŋi¹juǿi¹, ca¹lah¹ca¹tǿ² jmai³ ja³ca¹jmógh¹ Diú¹³ juanh¹² cu²rø² ca¹lah¹jǿ¹ ju³lah lǿa¹² jǿg³ ca¹já¹ ma²lǿih², jǿg³ ca¹juúh² dsa² han¹³, dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Di³ lah¹la² ca¹tsáih¹ hlai³ Moisés dsa² hóg¹ quián² jniang³. Ca¹juuh²dsa: “Tsen¹ Juu¹³ jniang³ jan² dsa² go² jniang³, dsa² hǿ² jǿg³. Tsen¹dsa juu¹² ja³tiogh³ hniah¹² ju³lah ca¹tsei¹dsa jní². Jøng² túgh³ hniah¹² juu¹² chi²júh² he² jǿg³ ca¹tsáih¹dsa hniah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Di³ lah¹la² lé²: Ju³ná³ hein² dsa² go² jniang³ tsa¹togh¹² juu¹² jǿg³ ca¹hǿ² dsa² héi², cu¹dsie¹² tsa¹ma¹lé² gú¹dsa jøa³ ja³tiagh³ jniang³,” ca¹juúh² hlai³ Moisés. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jø¹² bíh³ lah¹jøng² ca¹juúh² ca¹lah¹já¹ dsa² hǿ² jǿg³ quiah¹² Diú¹³ cónh¹ ja³ca¹já¹, ca¹lah¹cónh¹ jmai³ lah¹ni³ ja³ca¹juúh² hlai³ Samuel, jǿg³ quiah¹² jmai³ tiagh³ jniang³ na¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jǿg³ quián² báh³ jniang³ jøng² hi² ca¹jmo¹ Diú¹³ ma²lǿih² quianh¹³ dsa² hóg¹ quián² jniang³, hi² ca¹juúh² dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Jǿg³ la² báh³ jøng², ca¹tsáih¹ Diú¹³ hlai³ Abraham. Ca¹juúh² Diú¹³: “Tsø³jon² quiánh² báh³ hning² jmo¹ lé² dsio¹ quiah¹² ca¹lah¹já¹ dsa² jmøi¹guǿi¹,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jøng² mi³ca¹jmo¹ Diú¹³ ca¹lø¹chián¹ ja³ŋiúh³dsa jmøi¹guǿi¹, jøng² lah¹ni³ ca¹tsei¹dsa juu¹² ni³ jniang³. Mi³jøng² jeinh¹³ jniang³ lah¹jan² lah¹jan² jniang³. Tsa¹ma¹jmó³ jniang³ hi² hlaih¹³ ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ja³jøng² tiogh³ Pedro quianh¹³ Juan, ti³dsii¹²dsa jǿg³ quianh¹³ dsa² jue¹², mi³ca¹dsi¹lé² jmi²dsa² quián¹²dsa, quianh¹³ comandante quián¹² guøh¹², quianh¹³ dsa² saduceo. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsa¹tøa¹² dsǿa¹² dsa² héi² jǿg³ he¹² Pedro quianh¹³ Juan, jǿg³ hi² hiog¹ dsa² jmøi¹guǿi¹. Lah¹la² ca¹juúh² Pedro quianh¹³ Juan: ―Léi¹³ hiog¹ calah dsa² jmøi¹guǿi¹. Di³ ca¹hiog² báh³ Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jøng² ca¹chiángh² dsa² ca¹dsi²lé² héi². Ca¹tagh²dsa hni¹ŋí³ cøng² neng¹². Tsa¹ma¹chi² jmai³ dsa¹lé²dsa ni³ ta³. Di³ ca¹neng². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jøng² tiog¹³ báh³ ca¹hé¹ dsa² jue¹², dsa² ti³nang¹² jǿg³ jmai³ jøng². Jøng² ca¹løa¹ hŋí² mei¹³ dsa² ŋioh¹², jmáh¹lah dsa² hé² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mi³ca¹jni¹ jøng², ca¹túgh² dsa² ta³ quián¹² dsa² judío jøa³juøi² Jerusalén. Quianh¹³dsa dsa² canh¹³, quianh¹³ tøa¹² quiah¹² lei¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hiúg³ ŋi¹jmó² Anás, quianh¹³ Caifás, quianh¹³ Juan, quianh¹³ Alejandro, quianh¹³ ca¹lah¹já¹ dsa² ju²roh¹³ ŋi¹jmó². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jøng² mi³ca¹togh¹²dsa Pedro quianh¹³ Juan quianh¹³ dsa² mi³dsoh³ héi² jøa³ ja³tiogh³dsa, jøng² ca¹ŋai¹dsa. Ca¹juúh²dsa: ―¿Hein² ca¹cuø¹ bí² ca¹jmoh³ hniah¹² hí³ dsa² ná¹²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jøng² jǿg³ he¹² jmi²dsí² han¹³ quiah¹² Diú¹³ dsa²jiag¹² dsǿa¹² Pedro, ca¹juúh²dsa: ―Hniah¹² dsa² ta³ quianh¹³ dsa² canh¹³, ");
INSERT INTO cpaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ŋaih³ hniah¹² jnieh³ ha²lah ca¹løa¹ hí³ quiah¹² dsa² mi³dsoh³ lang¹². Hi² dsio¹ báh³ ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ju³li¹ŋih³ hniah¹² jøng², quianh¹³ ca¹lah¹já¹ dsa² israel, dsa² go² jniang³. Quianh¹³ jǿg³ quiah¹² Jesucristo, dsa² chian² Nazaret, dsa² ca¹jŋë́h¹ hniah¹² ni³ crǿg¹³, dsa² ca¹jmo¹ Diú¹³ dsa² juanh¹² hi² ca¹hiog²dsa ni³ jøng², jǿg³ quiah¹² dsa² héi² báh³ ca¹jmo¹ ca¹hlú² dsa² lang¹². Ma²dsiog¹dsa. Tsenh¹²dsa ja³tiagh³ jniang³ la². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ca¹tiogh² hniah¹² Jesús tø¹cøg¹², ju³lah téng² dsa² jmo¹² hniú¹² mǿi² cang³ tsa¹jih²dsa. Cónh¹jøng² ma²lán¹²dsa ju³lah lǿa¹² cang³ jmo¹² hi² tsih¹² hniú¹² tí². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ha¹chian² dsa² siáh² chian² ta³cøng² jmøi¹guǿi¹, dsa² lég² jniang³ dsa² jmøi¹guǿi¹. Jan² Jesús báh³ ca¹cuan¹ Jmi² jniang³. Jan² dsa² héi² báh³ lég² jniang³ ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jøng² jái¹² dsa² ta³ dsa² ti²ŋié² báh³ Pedro quianh¹³ Juan. Ha¹chi² ma¹dsio¹² escuela ca¹ŋie³dsa. Jøng² dsogh¹² dsǿa¹² dsa² ta³ tsa¹goh¹² Pedro hløah¹² quianh¹³ Juan. Ca¹lø¹lih¹³dsa ma²ca¹ŋi²nio³ dsa² héi² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jø¹² bíh³ jái¹²dsa calah ma²dsiog¹ dsa² héi² ma²tsenh¹²dsa. Jøng² ha¹chi² ma²ŋi¹²dsa jǿg³ li¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jøng² ca¹jmo¹ dsa² ta³ jǿg³ huanh¹² dsa² héi² ca²tí² ja³dsi¹², ta³lah¹dsii¹ dsa² ta³ jǿg³ cu²guiog¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jøng² ca¹juúh² dsa² ta³: ―¿Ha²lah jmó³ jniang³ quianh¹³ dsa² jnung²? Lah¹dsóh² ca¹jmo¹ báh³ dsa² cøng² juu¹² juøh¹². Ma²ŋi¹² báh³ ca¹lah¹já¹ dsa² chian² jøa³juøi² Jerusalén la². Tsa¹lé² juúh³ jniang³ ha¹chi² ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jøng² ju³mi³dsian¹³ jniang³ dsǿa¹²dsa. Mi³jøng² tsa¹ma¹dsa¹cón³ jǿg³ quiah¹² Jesús. Tsa¹ma¹tsáih¹dsa dsa² jǿg³ jøng² ―ca¹juúh² dsa² ta³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jøng² mi³ca¹tai¹dsa calah ta¹dsi²néi², jøng² ca¹tsáih¹dsa Pedro quianh¹³ Juan: ―Tsa¹ma¹héh³ hniah¹² jǿg³ quiah¹² Jesús. Tsa¹ma¹dsiíh³ hniah¹² jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Jøng² ca¹ŋai¹ Pedro quianh¹³ Juan. Ca¹juúh²dsa: ―¿Naih¹² hi² dsio¹ jmó³ jnieh³? ¿Néng³ jnieh³ jǿg³ quiánh² hniah¹², ho¹ ju³ néng³ jnieh³ jǿg³ quiah¹² Diú¹³? ");
INSERT INTO cpaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tsa¹lé² hi² jøng² hi² tsa¹hløah³ jnieh³ jǿg³ hi² ma²ca¹ne¹³ jnieh³, jǿg³ hi² ma²ca¹néng³ jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jøng² mi³ma²na²mi¹dsian¹³ dsa² ta³ dsǿa¹² dsa² héi², ca¹tég²dsa. Tsa¹ca¹dsóh²dsa mai³¹ ha²lah mi³jmógh¹dsa. Di³ gan¹dsa dsa² jue¹². Ca¹lah¹já¹ báh³ dsa² juøi² ma²mi²juanh¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Di³ quianh¹³ juu¹² juøh¹² ca¹løa¹ hí³ quiah¹² dsa² héi², dsa² mi³dsoh³ lǿa¹² jín³ ton¹lág¹ ji²ŋi² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jøng² mi³ca¹tég² dsa² ta³, ca¹ŋi¹lé² Pedro quianh¹³ Juan juu¹² ja³mi³tiogh³ dsa² quianh³dsa. Ca¹hǿ²dsa jǿg³ ca¹lah¹jǿ¹ hi² ca¹juúh² juu¹³ jmi²dsa² quianh¹³ dsa² canh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jøng² mi³ca¹nǿng² dsa² quianh³dsa, cu¹dsie¹² ca¹hlanh¹dsa Diú¹³ ca¹lah¹já¹dsa. Ca¹juúh²dsa: ―Juu¹³ jniang³, hning² báh³ dsa² juanh¹². Jan² hning² báh³ dsa² ca¹jmoh³ jmøi¹guǿi¹, quianh¹³ jmø³ŋih¹³, quianh¹³ dsi³guøi², quianh¹³ ca¹lah¹já¹ hein² jín³ hi² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jǿg³ quiánh² báh³ hning² ca¹juúh² hlai³ David, dsa² ca¹mi¹ti¹ neih³ hning², jǿg³ ca¹he¹ jmi²dsí² han¹³ quiánh²hning. Lah¹la² ca¹juúh² hlai³ David: ¿He² løa¹ tiogh³ dsa² jmøi¹guǿi¹ cu²møah¹³? Jmáh¹lah hi² tsa¹chi² ta³ li¹jmo¹ báh³ dsø²jiag¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jøng² ca¹túgh² rai¹³ dsa² jmøi¹guǿi¹ quianh¹³ dsa² ta³ jian¹²dsa. Hian³dsa Juu¹³ jniang³ quianh¹³ Cristo quián¹²dsa, rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Jøng² lah¹dsóh² ca¹túgh² báh³ Herodes quianh¹³ Poncio Pilato jøa³juøi² la². Ca¹túgh² báh³ dsa² israel quianh¹³ dsa² siáh². Hian³dsa Jesús, dsa² han¹³ quián² jniang³, dsa² ca¹hiah¹³ hning² mi¹ti¹ neih³hning. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Lah¹jøng² báh³ ca¹jmo¹ dsa² héi², ju³lah ca¹juøh³hning lah¹jiá¹² mi³lé². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jai³lah, Juu¹³ jniang³. Dsa² héi² ma²mi²dsian¹² dsǿa¹² jnieh³, dsa² jmo² ta³ quiánh²hning. Jøng³ cuúh³hning ju²bí². Mi³jøng² tsa¹li¹goh¹² jnieh³ dsií³ jnieh³ jǿg³ quiánh² hning². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Quianh¹³ ju²bí² quiánh² hning² mi³hliú³ jnieh³ dsa² dsoh³. Quianh¹³ Jesús, dsa² han¹³ quiánh²hning lé² juu¹² juøh¹² quianh¹³ hi² gøg² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mi³ca¹hlanh¹dsa Diú¹³ lah¹jøng², jøng² cu¹dsie¹² ca¹jle¹ ta³cøng² ja³mi³tiogh³dsa. Jøng² ca¹lah¹já¹ báh³ dsa² ca¹cán¹ jmi²dsí² han¹³ quiah¹² Diú¹³. Ca¹téng²dsa jǿg³ quiah¹² Diú¹³ hi² tsa¹goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jøng² cøng² jǿg³ báh³ tiogh³ dsa² ma²hé² jǿg³. Hiug² dsǿa¹²dsa ca¹lah¹já¹dsa. Quiah¹² ca¹lah¹já¹ báh³ dsa² ca¹jmo¹dsa hi² mi³chi² quiah¹²dsa. Jin³ jan² ha¹chian² ca¹juúh²: Ju³chiág³ mih² quieg¹ jní². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jøng² ca¹hǿ² tsih² høh³ jǿg³ quiah¹² Jesús, Juu¹³ jniang³, ha²lah ca¹hiog²dsa. Ca¹hǿi² tí² jǿg³ quiah¹²dsa. Ma¹dsio¹² ca¹mi³hog¹³ Diú¹³ ca¹lah¹já¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jin³ cøng² ha¹chi² chi³quian¹³dsa jmai³. Ju³ná³ hein² dsa² mi³ron¹² huø¹ quiah¹²dsa, ho¹ ju³ mi³tsih¹³ hniú¹², ca¹hnai¹ báh³ dsa² hi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Cog³ jøng² ca¹ŋi³dsii²dsa ni³ tsih² høh³. Jøng² ca¹jmo¹ tsih² høh³ ma¹méh¹ cog³. Ca¹cuúh¹dsa dsa² chi³quian¹³ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lah¹jøng² báh³ ca¹jmo¹ jan² dsa² levita tsen² José, dsa² chian² Chipre, dsa² ca¹tǿh¹ tsih² høh³ Bernabé, hi² hniu¹dsa juúh²dsa dsa² cuø¹² liáh². ");
INSERT INTO cpaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ca¹hnai¹ báh³ José héi² huø¹ quiah¹². Ni³ jøng² ca¹dsii¹dsa cog³ ni³ tsih² høh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Cónh¹jøng² lah¹la² ca¹jmo¹ jan² dsa² tsen² Ananías quianh¹³ hio¹³ quián¹²dsa mi³ca¹hnai¹dsa cøng² huø¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ca¹jmo¹ dsa² ŋioh¹² dsii¹²dsa ca¹lah¹jǿ¹ cog³ ni³ tsih² høh³. Hi² ca¹mi¹gag¹³ báh³ dsa². Mih² báh³ cog³ jøng² ca¹dsii¹dsa. Ŋi¹² báh³ hio¹³ ha²lah ca¹jmo¹ dsa² ŋioh¹² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jøng² ca¹tsáih¹ Pedro dsa² ŋioh¹². Ca¹juúh²dsa: ―Ha²lah dsio¹ ca¹hí¹ Satanás tø²hoh¹²hning Ananías. Mi³mi³ganh¹³hning jmi²dsí² han¹³ quiah¹² Diú¹³. Di³ ma²na²chiagh¹hning mih² cog³ quiah¹² huø¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mi³quiánh² báh³ hning² huø¹. Jø¹ quiánh² báh³ hning² cog³, mi³ca¹hnaih³hning huø¹. Ha²lah dsio¹ jøng² ca¹hí¹ hoh¹²hning jǿg³ hlaih¹³. A¹jáng¹ dsa² jmøi¹guǿi¹ mi³mi³ganh¹³hning. Diú¹³ báh³ mi³mi³ganh¹³hning ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jøng² mi³ca¹nǿng² Ananías jǿg³ jøng², ta³lah¹ca¹jon¹dsa. Jøng² ca¹can¹ hlaih¹³ dsa² gøg² mi³ca¹løa¹ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jøng² ca¹dsi¹lé² tsih² dsa² ŋioh¹². Ca¹liog¹dsa hlai³. Jøng² ca¹ŋi¹hǿg²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jøng² ma²hnøa¹² hora ca¹jon¹ Ananías, mi³ca¹dsiég¹ hio¹³ quián¹²dsa. Tsa¹ŋi¹² hio¹³ he² na²løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jøng² ca¹tsáih¹ Pedro hio¹³. Ca¹juúh²dsa: ―Tseih³ jní². ¿Cónh¹ la² báh³ cog³ ca¹hnaih³ hniah¹² huø¹ quiánh²? ―ca¹juúh² Pedro. Jøng² ca¹juúh² hio¹³: ―Jan¹. Cónh¹ ná¹² báh³ té¹² cog³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jøng² ca¹juúh² Pedro: ―¿He² løa¹ ca¹jmoh³ hniah¹² jǿg³ hi² mi³mi³ganh¹³ hniah¹² jmi²dsí² quiah¹² Diú¹³? Jai³lah. Ma²ja²lia¹ dsa² ma²na²u³hog¹ dsa² ŋioh¹² quiánh²hning. Jø¹² bíh³ dsa¹hog¹dsa hning² calah ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dsø¹juu¹² jøng² báh³ ca¹jon¹ hio¹³ ja³tsenh¹³ Pedro. Jøng² ma²ron¹² hlai³ ca¹dsi¹lia¹ dsa² ca¹ŋi³hog¹ dsa² ŋioh¹² quián¹²dsa. Jøng² ca¹ŋi³hag¹dsa cøg¹² ja³rø²hog¹² dsa² ŋioh¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jøng² gøg² ca¹can¹ ca¹lah¹já¹ dsa² hé² jǿg³ quiah¹² Jesús, quianh¹³ dsa² siáh² calah, mi³ca¹nǿng²dsa jǿg³ ca¹løa¹ lah¹jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jøng² hliú² juu¹² juøh¹² quianh¹³ hi² gøg² ca¹jmo¹ tsih² høh³, ja³ca¹jái¹ dsa² jue¹². Cøng² jǿg³ tiogh³ dsa² ca¹hé¹ jǿg³ dsa²lé²dsa guøh¹² ja³tsen² Portal de Salomón. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jøng² ha¹chian² dsa² siáh² ca¹túgh² quianh¹³ dsa² héi², hi² goh¹²dsa. Cónh¹jøng² tøa¹² báh³ dsǿa¹² dsa² juøi² jian¹²dsa ha²lah ŋi²nio³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jøng² hiug¹² jín³ jue¹² dsa² ca¹hé¹ jǿg³ quiah¹² Juu¹³ jniang³, cu¹dsie¹² dsa² ŋioh¹² ca¹lah¹ma¹quianh¹³ mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jøng² ca¹huan¹ dsa² juøi² dsa² dsoh³ jøa³cai³¹. Ca¹tagh¹dsa ni³ jein³ ni³ jmung² chi²júh² tøa¹ hính³ quiah¹² Pedro ni³ quiah¹² ca²dsiog³dsa. Mi³jøng² hliú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jø¹² bíh³ ca¹dsi¹lé² dsa² jue¹² tiogh³ cøg¹² jøa³juøi² Jerusalén. Ca¹ŋi³jian¹dsa dsa² dsoh³ quianh¹³ dsa² quin¹² jmi²dsí² hlaih¹³. Jøng² ca¹hlú² báh³ ca¹lah¹já¹ dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jøng² hioh³ ŋi¹jmó² quianh¹³ dsa² quián¹²dsa, dsa² jag¹³ quiah¹² saduceo. Dsih¹²dsa hi² jmo¹² tsih² høh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jøng² ca¹ŋi³chiánh³dsa tsih² høh³. Ca¹ŋi³tiág¹³dsa hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jøng² ja³neng² ca¹ŋi³nií³ jan² ángel quián¹² Juu¹³ jniang³ hni¹ŋí³. Jøng² mi³ca¹huan¹dsa tsih² høh³, ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ja³dsi¹² guøh¹² gu³tiogh¹² hniah¹². Gu³tseih³ hniah¹² dsa² juøi² ha²lah lǿa¹² ca¹lah¹jǿ¹ jǿg³ ma²ŋi²nioh³ hniah¹² ―ca¹juuh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jøng² mi³ca¹nǿng² tsih² høh³ jǿg³ jøng² ca¹ŋi¹lé²dsa juu¹² guøh¹². Ca¹dsi¹lé²dsa cónh¹ nioh¹² hi³méh¹. Jøng² ca¹he¹dsa jǿg³. Jøng² ca¹jmo¹ ŋi¹jmó² quianh¹³ dsa² quián¹²dsa jǿg³ hi² ca¹túgh² dsa² ta³ quianh¹³ ca¹lah¹já¹ dsa² canh¹³ quián¹² dsa² israel. Ca¹jmo¹ ŋi¹jmó² jǿg³ dsa¹quián²dsa tsih² høh³, dsa² hiúg³ hni¹ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cónh¹jøng² ha¹chian² tsih² høh³ ma¹chian² hni¹ŋí³ mi³ca¹dsi¹lé² tsih² dsa² ta³. Jøng² ca¹ŋi¹cang¹ dsa² héi² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ca¹juúh²dsa: ―Chi³jnái¹³ dsio¹ báh³ hni¹ŋí³ na²dsiég¹ jnieh³. Jøng² báh³ tiogh³ hlég² jmo¹² hí³ hag³ hni¹ŋí³. Mi³na²ná² hni¹ŋí³ jøng², ha¹chian² dsa² mi³tiogh³ ma¹chian² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jøng² høa¹² dsǿa¹² juu¹³ jmi²dsa² quianh¹³ comandante quián¹² guøh¹² mi³ca¹nǿng²dsa jǿg³ jøng². “¿Ha² ca¹tǿ² dsiég¹³ jǿg³ quiah¹² Jesús?” lë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dsø¹juu¹² jøng² ca¹dsiég¹ jan² dsa². Ca¹juúh²dsa: ―Jai³lah. Dsa² ca¹tiogh³ hniah¹² hni¹ŋí³ héi² ma²tiogh³ ja³dsi¹² guøh¹². Heh¹²dsa dsa² juøi² jǿg³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jøng² ca¹ŋi³tei² comandante quianh¹³ policía quián¹²dsa. Ha¹chi² ca¹chiángh²dsa mi³né³. Ca¹tøa¹dsa quianh¹³ jǿg³ rø². Di³ gan¹dsa dsa² juøi², na³ca¹qui² ca¹tǿg²dsa cang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mi³ca¹dsi¹lia¹dsa ni³ dsa² ta³, jøng² ca¹juúh² ŋi¹jmó², ca¹tsáih¹dsa tsih² høh³ quián¹² Jesús: ");
INSERT INTO cpaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Cu²rø² ca¹tséih³ jnieh³ hniah¹² tsa¹mi³heh³ hniah¹² jǿg³ quiah¹² Jesús. Ná¹² di³ jai³ hniah¹². Ta³cøng² jøa³juøi² Jerusalén la² ma²chi² jǿg³ hi² dsiih² hniah¹². Jøng² mi³cuøh¹² hniah¹² jnieh³ dsag³ ca¹jon¹ Jesús ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jøng² ca¹ŋai¹ Pedro quianh¹³ tsih² høh³ jian¹²dsa. Ca¹juúh²dsa: ―Dsio¹ jín³ hi² néng³ jniang³ jǿg³ quiah¹² Diú¹³ cónh¹ jín³ jǿg³ quiah¹² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Diú¹³ quián¹² dsa² hóg¹ quián² jniang³ ca¹jmo¹ hi² ca¹hiog² Jesús, dsa² ca¹jŋë́h¹ hniah¹² ni³ crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jøng² ca¹jmo¹ Diú¹³ dsa² juanh¹² hi² ma²juanh¹² Jesús. Ma²lán¹²dsa Juu¹³ jniang³, dsa² lég² jniang³. Mi³jøng² lé² jéinh¹ dsǿa¹² dsa² Israel. Mi³jøng² lé² hén² dsǿg³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ma²ne³ báh³ jnieh³. Di³ ma²ca¹ne¹³ báh³ jnieh³. Ni³ jøng² ca¹tí² Diú¹³ jmi²dsí² han¹³ quiah¹² quiah¹² dsa² ca¹nǿng² jǿg³ quiah¹²dsa ―ca¹juúh² tsih² høh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jøng² ca¹lø¹hné¹ dsa² héi² mi³ca¹nǿng²dsa jǿg³ jøng². Mi³mi¹dsian¹²dsa tsih² høh³ quián¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jøng² ca¹nung² jan² dsa² ta³, dsa² jag¹³ quiah¹² fariseo, dsa² tsen² Gamaliel, dsa² lán¹² tøa¹² he¹² lei¹³ quiah¹² Diú¹³. Dsa² dsiog¹ báh³ lë́² dsa² juøi². Mi³ca¹jmo¹ dsa² héi² jǿg³ huan¹dsa ca²tí² tsih² høh³ ja³dsi¹², ");
INSERT INTO cpaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","jøng² ca¹tsáih¹dsa dsa² ta³ jian¹²dsa. Ca¹juúh²dsa: ―Hniah¹² dsa² israel, cu²rø² hniangh² hoh¹² ha²lah jmóh³ hniah¹² quianh¹³ dsa² tiogh³ ja³dsi¹² jnung². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Di³ lah¹la² ma²ca¹løa¹ ja³ca¹já¹. Ca¹lø¹chián¹ jan² dsa² tsen² Teudas. Mi³mi²juanh¹²dsa hŋiah¹²dsa. Mi³quianh¹³dsa cónh¹ quiún² ŋia²lúg² dsa². Ni³ jøng² ca¹jŋaih¹ dsa². Ca¹ŋi¹lia¹ dsa² mi³quianh¹³dsa. Cu¹ná¹² báh³. Ca¹dsan¹ jǿg³ quiah¹² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ni³ jøng² jmai³ ca¹tion¹dsa dsa² si² censo, ca¹lø¹chián¹ Judas, dsa² chian² Galilea. Ca¹lø¹quianh¹³dsa mih² dsa². Jøng² mi³ca¹jon¹ dsa² héi², ca¹ŋi¹lia¹ báh³ ca¹lah¹já¹ dsa² mi³nang¹² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jøng² jǿg³ la² juǿi³jni hniah¹²: Tsa¹ma¹hlanh¹³ hniah¹² dsa² jnung², dsa² tiogh³ ja³dsi¹². Tsa¹ten³dsa gugh². Di³ dsian¹ báh³ jǿg³ quiah¹²dsa, ju³ná³ jǿg³ ca¹hnangh² dsǿa¹² guiog¹³ dsa² jmøi¹guǿi¹, jǿg³ dsii¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ju³ná³ ton¹dsóh² jǿg³ quiah¹² Diú¹³, jǿg³ dsii¹²dsa, jøng² tsa¹lé² hén² jǿg³ jøng². Hi² jøng² tsa¹hlanh¹³ hniah¹² dsa², chi²júh² hniah¹² báh³ ca¹téh² quianh¹³ Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jøng² ca¹nǿng² báh³ dsa² ta³ jǿg³. Ca¹tai¹dsa tsih² høh³ quián¹² Jesús dsi²néi². Jøng² ca¹juúh² dsa² ta³, ca¹tsáih¹dsa tsih² høh³: ―Tsa¹ma¹dsiíh³ hniah¹² jǿg³ quiah¹² Jesús ―ca¹juúh²dsa. Jøng² mi³ca¹bán²dsa tsih² høh³, ca¹lég²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jøng² ca¹u¹hái¹ tsih² høh³ ni³ dsa² ta³, liánh² lǿa¹² dsǿa¹²dsa. Di³ ca¹cuø¹ Diú¹³ ca¹cán¹dsa mih² jmø³uai¹² ni³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jøng² ca¹hǿ² báh³ dsa² jǿg³ quiah¹² Jesucristo. Ca¹lah¹jǿ¹ jmai³ ca¹dsii¹dsa jǿg³ ja³tsih¹³ guøh¹² ca¹lah¹quianh¹³ ja³ti³tǿng² hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jmai³ jøng² ma²ŋi²jué² dsa² quián¹² Jesús. Jøng² ca¹jí² dsa² hløah¹² jǿg³ griego. Ca¹jé²dsa dsa² hløah¹² jag³ dsa² judío. Ca¹juúh²dsa: ―Ma¹dsio¹² jín³ má¹ cuøh¹²dsa hio¹³ hnǿi² judía cónh¹ jín³ hio¹³ hnǿi² griega na³ma²tǿ² ja³quie¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jøng² mi³ca¹togh¹² dsa² guia¹tón² ca¹lah¹já¹ dsa² quián¹² Jesús, ca¹juúh² dsa² guia¹tón²: ―Tsa¹dsio¹ tiú¹³ jnieh³ ta³ téng² jnieh³ jǿg³ quiah¹² Diú¹³ ni³ huu¹³ hi² mi³tioh¹³ jnieh³ má¹ ni³ mesa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jøng² hniah¹² dsa² roh¹³ jniang³, hiah¹³ hniah¹² guiog¹ dsa² ŋioh¹², dsa² chi² jǿg³ dsio¹ quiah¹², dsa² ŋi¹², dsa² quin¹² jmi²dsí² quiah¹² Diú¹³. Dsa² héi² báh³ jmo¹ ta³ quiah¹² ni³ mesa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jøng² jmáh¹lah ta³ hlanh¹² Diú¹³ jmó³ jnieh³, quianh¹³ hi² téng³ jnieh³ jǿg³ quiah¹² Diú¹³ ―ca¹juúh² tsih² høh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jøng² hiug² dsǿa¹² ca¹lah¹já¹dsa jǿg³ jøng². Hi² jøng² ca¹hia¹dsa Esteban, dsa² quin¹² jmi²dsí² han¹³ quiah¹² Diú¹³, dsa² chinh¹² tí² jǿg³. Ca¹hia¹dsa Felipe, quianh¹³ Prócoro, quianh¹³ Nicanor, quianh¹³ Timón, quianh¹³ Parmenas, quianh¹³ Nicolás, dsa² chian² Antioquía, dsa² ca¹hí¹ quianh¹³ dsa² judío niúh¹ jín³ hi² ca¹nǿng²dsa jǿg³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jøng² ca¹togh¹²dsa dsa² héi² ni³ tsih² høh³. Ca¹quieg² tsih² høh³ gug² ni³ quiah¹² dsa² héi² ta³lah¹ca¹hlanh¹dsa Diú¹³ ni³ huu¹³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jøng² ca¹tsø² ca¹ja¹ jǿg³ quiah¹² Diú¹³. Hiug¹² ca¹ŋi¹jué² dsa² quián¹² Jesús jøa³juøi² Jerusalén. Jue¹² jmi²dsa² quián¹² dsa² judío ca¹hé¹ jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jøng² mi³jmo¹² Esteban hliú² hi² gøg² hi² juøh¹² ja³ti³jái¹³ dsa² juøi². Chi² bí² quiah¹²dsa. Ca¹mi¹hag¹³ Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jøng² ca²dsiog² dsa² tiogh³ guøh¹² quiah¹² dsa² judío, dsa² tǿh¹dsa Esclavos Libertados, quianh¹³ dsa² chian² Cirene, quianh¹³ dsa² chian² Alejandría, quianh¹³ dsa² chian² Cilicia, quianh¹³ dsa² chian² Asia, ca¹dsii¹dsa jǿg³ quianh¹³ Esteban. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Jøng² ca¹tiúh¹dsa dsii¹dsa jǿg³ quianh¹³dsa. Di³ ma¹dsio¹² hlaih¹³ ma²ŋi¹² Esteban. Rø² ca¹dsii¹dsa jǿg³ ca¹he¹ jmi²dsí² han¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jøng² ja³tsa¹jní² ca¹hnó² dsa² tsa¹ca¹tiúh¹ héi² dsa² ca¹mi¹gag¹², dsa² hlianh¹³. Jøng² ca¹juúh² dsa² mi²gag¹² héi², ca¹tsáih¹dsa dsa² jue¹²: ―Ma²ca¹néng³ jnieh³ ca¹hia¹ Esteban Diú¹³ quianh¹³ hlai³ Moisés jǿg³ hlaih¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Quianh¹³ jǿg³ tø³jǿg³ jøng² ca¹jmo¹dsa møah¹³ ni³ dsa² juøi², quianh¹³ dsa² canh¹³, quianh¹³ tøa¹² quiah¹² lei¹³. Jøng² ca¹ŋi³chiánh³dsa Esteban. Ca¹ŋi³jiag¹dsa ni³ ta³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jøng² ca¹juúh² dsa² mi²gag¹² héi²: ―Ca¹lah¹tsa¹tiá² cu¹té¹² dsii¹² Esteban jǿg³ hlaih¹³ quiah¹² guøh¹² han¹³ quián² jniang³, quianh¹³ lei¹³ quián² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ma²ca¹néng³ jnieh³ juúh²dsa hi² hén² Jesús chian² Nazaret guøh¹² quián² jniang³, hi² jŋíh² Jesús mai³¹ quián² jniang³, mai³¹ ma²ca¹já¹ ca¹jmo¹ hlai³ Moisés ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jøng² ti³jái¹³ ca¹lah¹já¹ dsa² tiogh³ ni³ ta³ ma²jní² ni³ Esteban ju³lah jní² ni³ jan² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jøng² ca¹juúh² ŋi¹jmó², ca¹tsáih¹dsa Esteban: ―¿Dsøg¹³ ca¹juøh³hning lah¹jøng²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jøng² ca¹juúh² Esteban: ―Hniah¹² dsa² canh¹³, quianh¹³ dsa² go² jniang³, neng² di³ ca²tí² jǿg³ quieg¹jni. Jan² Diú¹³ báh³ dsa² juanh¹². Dsa² héi² báh³ ca¹tsáih¹ hlai³ Abraham, dsa² hóg¹ quián² jniang³, cónh¹ jmai³ mi³guǿ¹³ Abraham ja³tén¹² Mesopotamia, níuh¹ jín³ hi² ca¹ŋi¹gú¹dsa jøa³juøi² Harán. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jøng² ca¹juúh² Diú¹³: “Juh¹³hning goh²hning. Cu¹dsie¹² tiugh¹³hning dsa² rúh²hning. Jøng² góh³hning juu¹² ja³he³jni,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jøng³ ca¹u¹hái¹ Abraham go² dsa² Caldea. Ca¹ŋi¹gú¹dsa jøa³juøi² Harán. Jøng² mi³ca¹jon¹ ti³jmi²dsa, ca¹u¹jiag¹ Diú¹³ juu¹² ja³tiagh³ jniang³ la². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cónh¹jøng² ha¹chi² huø¹ ca¹cuø¹ Diú¹³ jin³ ca²jneh³. Di³ ca¹jmo¹ báh³ Diú¹³ jǿg³ hi² li¹chi² huø¹ la² quiah¹²dsa, lah¹quianh¹³ jong¹²dsa ta¹chi³quë́¹. Di³ ha¹chian² jong¹²dsa ma²chian² jmai³ jøng² mi³né³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jø¹² bíh³ ca¹juúh² Diú¹³ hi² dsa²tiogh³ tsø³jong¹³ Abraham go² dsa² siáh². Li¹quián¹² dsa² chian² ja³jøng² tsø³jong¹³dsa. Quiún² ŋi²lǿg² ji²ŋi² jmai³ dsa²tiogh³dsa ja³jøng², hi² jmógh¹ dsa² chian² ja³jøng² tsø³jong¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jøng² ca¹juúh² Diú¹³: “Jní² báh³ jmo¹³ ta¹canh¹³ dsa² héi², dsa² jmógh¹ tsø³jonh¹²hning. Jøng² huanh¹² tsø³jonh¹²hning calah. Ji¹hlaih¹³dsa jní² ja³la²,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Jøng² ca¹jmo¹ Diú¹³ jǿg³ quianh¹³ hlai³ Abraham, hi² lé² circuncisión quiah¹² guing² dsa² ŋioh¹² quián¹²dsa jmai³ ŋi² ja³já¹³, jmai³ ŋi² ja³dság¹. Jøng² ca¹jmo¹ Abraham circuncisión quiah¹² Isaac, guing² quián¹²dsa ma²jŋi¹ jmai³ ca¹lø¹chián¹guing. Jøng² ca¹lø¹chián¹ Jacob, ja³ŋiúh³ Isaac. Jøng² ca¹lø¹chián¹ guia¹tón² guing² dsa² ŋioh¹² quián¹² Jacob, dsa² ma²lán¹² dsa² hóg¹ quián² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Jøng² guia¹ján¹ dsa² héi², hian¹³dsa José, roh¹³dsa. Ca¹hnë¹dsa José quianh¹³ cog³. Ca¹lǿg² dsa² ca¹ŋi¹lé² juu¹² Egipto. Cónh¹jøng² quianh¹³ báh³ José Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ha¹chi² ca¹jénh¹dsa. Ca¹lég² báh³ Diú¹³. Ca¹tǿ² dsǿa¹² Faraón, rai¹³ quiah¹² juøi² Egipto, jǿg³ ca¹juúh² José. Jøng² ca¹hia¹ Faraón José. Ca¹lán¹dsa dsi³máh² quián¹² Egipto. Jøng² ca¹jmo¹dsa hí³ hniu³ Faraón calah. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Jøng² ca¹ŋó¹ hag³cón³ ta³cøng² ja³tén¹² Egipto quianh¹³ Canaán. Ca¹ŋai¹ dsa² chian² ja³jøng² jmø³uai¹². Ha¹chi² li¹gǿh¹ dsa² hóg¹ quián² jniang³ ca¹løa¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jøng² mi³ca¹lø¹ŋi¹² hlai³ Jacob jǿg³ hi² chi² cuøi² ja³tén¹² Egipto, ca¹tsen¹dsa dsa² hóg¹ quián² jniang³ ja³jøng². Ca¹ŋi¹lé²dsa cu²rón². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jøng² mi³ca¹tǿ² tánh¹ ca¹ŋi¹lé²dsa, ca¹juúh² José, dsa² ma²lán¹² dsi³máh² quián¹² Egipto, ca¹tsáih¹dsa roh¹³dsa: ―Jní² báh³ rúh² hniah¹², dsa² ca¹hnëh¹³ hniah¹² ma²lǿih² ―ca¹juúh²dsa. ’Jøng² ca¹lø¹lih¹³ rai¹³ he² juøi² chian² José. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jøng² ca¹ŋi³tei² José Jacob ti³jmi²dsa, quianh¹³ ca¹lah¹já¹ dsa² ju³roh¹³dsa. Ma²ca²dsǿ²dsa mi³té¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hi² jøng² báh³ ca¹ŋi¹gú¹ Jacob huø¹ Egipto. Ja³jøng² ca¹dsan¹ báh³ dsa² quianh¹³ ja³ŋiúh³dsa, dsa² hóg¹ quián² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chi³quë́¹ jøng² ca¹dsen¹dsa hlai³. Ca¹ŋi³hag¹dsa tøg²hløg² ja³tén¹² juøi² Siquem, tøg² ma²ca¹lá¹ hlai³ Abraham lah¹jiá¹² quianh¹³ cog³ teg². Ca¹hnai¹ ja³ŋiúh³ Hamor, dsa² chian² Siquem. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Jøng² mi³ma²ja¹quien¹³ tøa¹ jmai³ ja³li¹ti¹ jǿg³ ca¹jmo¹ Diú¹³ quianh¹³ hlai³ Abraham, ca¹ŋi¹jué² tsø³jon² quiah¹² Abraham huø¹ Egipto. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jøng² rai¹³ siáh², dsa² tsa¹cuen¹² hlai³ José, ca¹lán¹ ta³ huø¹ Egipto jmai³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rai¹³ héi² ca¹mi¹gan¹² dsa² go² jniang³. Ca¹jmóh¹dsa dsa² hóg¹ quián² jniang³. Ca¹jmo¹ rai¹³ jǿg³ mi³guianh¹ dsa² hóg¹ guing² quián¹²dsa. Mi³jøng² mi³dsián¹ guing². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jmai³ jøng² báh³ ca¹lø¹chián¹ Moisés. Tøa¹² dsǿa¹² Diú¹³ guing². Úg² tsøh² jmai³ ca¹jmo¹ chiég³ jmi²guing hí³ dsi²néi². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jøng² ca¹jmo¹dsa hi² tiáng²dsa. Jøng² hŋiah¹² báh³ ja³mái¹³ rai¹³ ca¹tai¹guing. Ca¹mi¹con¹²dsa guing² ju³lah jan² dsa² mi²con¹² jong¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jøng² ca¹mi¹tan¹² Moisés ca¹lah¹jǿ¹ hi² mi³ŋi¹² dsa² Egipto. Ca¹lø¹të² hlaih¹³dsa. Rø² mi³hløah¹²dsa. Rø² mi³jmo¹²dsa ta³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Jøng² mi³ma²tǿ² ton¹lág¹ ji²ŋi² quiah¹² Moisés, ca¹ŋó¹dsa juu¹² ja³mi³tiogh³ dsa² go²dsa, dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ja³ŋøa¹²dsa jøng² ca¹jái¹dsa jmóh² jan² dsa² chian² Egipto jan² dsa² go²dsa. Jøng² ca¹mi³hog¹³dsa dsa² go²dsa. Ca¹jŋëh¹dsa dsa² chian² Egipto héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Di³ lë́² Moisés: “Li¹ŋi¹² báh³ dsa² go²jni hi² jmo¹² Diú¹³ hi² liog³jni dsá¹,” lë́²dsa. Cónh¹jøng² ha¹chi² ca¹lø¹ŋë́h² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mi³ca¹jni¹ jøng² ca¹jén² Moisés og¹ dsa² Israelita, dsa² tán¹². Jøng² mi³mi²dsian¹³ Moisés jǿg³ quiah¹² dsa² héi². Ca¹juúh²dsa: “¿He² løa¹ të́h² hniah¹² ja³ná³ dsa² ŋioh¹²? Jin² rúh² báh³ hniah¹² ná¹²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jøng² dsa² mi³jmóh² roh¹³ héi², ca¹hlaih¹dsa Moisés. Ca¹juúh²dsa: “¿Hein² ca¹jmo¹ héh¹ hning² lanh¹² ta³ quián² jnieh³? ");
INSERT INTO cpaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ho¹ ¿mi³jŋáih³hning jní² ju³lah ca¹jŋë́h¹hning dsa² egipcio dsiég¹?” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ta³lah¹ca¹cuøin¹ Moisés mi³ca¹nǿng²dsa jǿg³ jøng². Jøng² ca¹ŋi³gu²dsa go² dsa² siáh² ja³tsen² Madián. Ja³jøng² ca¹lø¹chián¹ og¹ dsa² ŋioh¹² quián¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Jøng² mi³ca¹tsø³jue¹³ ton¹lág¹ ji²ŋi² jmai³, ŋie³ hlai³ Moisés huu¹³ máh² Sinaí, ja³tsa¹chian² dsa² tiogh³. Ja³jøng² ca¹jë́²dsa jan² ángel hiúg³ jøa³ ja³chi³hiúh² si² chiúh³ tang¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jøng² dsogh¹² dsǿa¹² Moisés mi³ca¹jái¹dsa juu¹² juøh¹² jøng². Ŋó¹²dsa ŋi³jái³dsa cøg¹² mi³ca¹nǿng²dsa ca¹hløah¹ Juu¹³ jniang³. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Jní² báh³ Diú¹³ quián¹² dsa² hóg¹ quiánh²hning, Diú¹³ quián¹² hlai³ Abraham, quianh¹³ hlai³ Isaac, quianh¹³ hlai³ Jacob,” ca¹juúh²dsa. Jøng² cu¹dsie¹² ca¹jlia¹ hlai³ Moisés. Tø¹cøg¹² báh³ ca¹jái¹dsa, hi² goh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jøng² ca¹juúh² calah Juu¹³ jniang³: “Huøh¹³ løg² tioh¹³ táih² ná¹². Di³ han¹³ báh³ huø¹ ja³tsenh¹³hning. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma²ca¹jái¹jni chian² dsa² quian¹jni jmø³uai¹², hi² jmógh² dsa² chian² Egipto. Ma²ca¹nang¹jni hi² ti³héng²dsa. Hi² jøng² na²guio¹jni hi² liog³jni dsá¹. Jøng² hning² góh³. Hning² tsë́³jni juu¹² Egipto,” ca¹juúh² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Jøng² tsa¹ca¹nǿng² dsa² go² jniang³ jǿg³ quiah¹² Moisés lah¹jiá¹². “¿Hein² ca¹jmo¹ héh¹ hning² lanh¹² ta³ quián² jnieh³?” ca¹juúh²dsa. Moisés héi² báh³ ca¹lán¹ ta³ hi² ca¹jmo¹ Diú¹³ ja³ca¹jnia¹ ángel jøa³ chiúh³ tang¹². Diú¹³ ca¹jmo¹ héh¹. Jøng² ca¹liúg² Moisés dsa² go²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés báh³ ca¹jiag¹ ja³ca¹huanh¹² dsa² hóg¹ huø¹ Egipto. Ca¹jmo¹ Moisés juu¹² juøh¹² quianh¹³ hi² gøg² huø¹ Egipto, lah¹quianh¹³ dsi²juu¹², ja³ca¹han¹dsa jmø³ŋih¹³ guiéng², ca¹lah¹ma¹quianh¹³ ja³ca¹ŋi³nio³dsa ton¹lág¹ ji²ŋi² jmai³ ja³tsa¹chian² dsa² mi³tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Hlai³ Moisés héi² báh³ ca¹tsáih¹ dsa² israel. Ca¹juúh²dsa: “Tse¹ Diú¹³ jan² dsa² ju³roh¹³ jniang³, dsa² hǿ² jǿg³ quiah¹²dsa, ju³lah ca¹tsei¹dsa jní²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jø¹² bíh³ Moisés mi³quianh¹³ dsa² hóg¹ ja³ca¹ŋi³nio³dsa ja³tsa¹chian² dsa² tiogh³, jmai³ ca¹hlaih¹ ángel máh² Sinaí. Dsa² héi² báh³ ca¹hien¹ jǿg³ quiah¹² Diú¹³ ma²chi² quián² jniang³ na¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Jøng² tsa¹ca¹nǿng² dsa² hóg¹ quián² jniang³ jǿg³ quiah¹² hlai³ Moisés. Mi³hniu¹dsa mi³tég²dsa. Mi³dsa¹lia¹dsa calah huø¹ Egipto. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jøng² ca¹tsáih¹dsa Aarón: “Mi³hneng² jnieh³ jmóh³hning diú¹³ lan³, diú¹³ dsa¹jiag¹² jnieh³. Tsa¹ne³ jnieh³ he² ca¹jénh¹ Moisés, dsa¹ ca¹huai¹ jnieh³ huø¹ Egipto,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jøng² ca¹jmo¹dsa diú¹³ lan³, ju³lah lǿa¹² jan² ca³ju² meh². Ja³ta¹ni¹ hi² jøng² ca¹jŋëh¹dsa jáh², hi² dsii¹²dsa ni³ diú¹³, lë́²dsa. Di³ tøa¹² dsǿa¹²dsa diú¹³ lan³ ca¹jmo¹dsa guiog³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hi² jøng² ca¹tég² Diú¹³ dsa² juanh¹² quiah¹² dsa² hóg¹. “Ju³hlanh¹³dsa chi³neng¹² ti³buh¹³ guiuh¹³ chi²júh² lah¹jøng² lë́²dsa,” ca¹juúh² Diú¹³. Di³ lah¹la² rø²juúh² si² ca¹jmo¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³: A¹jáng¹ ju³ ni³ quieg¹ jní² ca¹jŋë́h¹ hniah¹² jáh² ja³ca¹ŋi³nioh³ hniah¹² ton¹lág¹ ji²ŋi² jmai³ ja³tsa¹chian² dsa² tiogh³. A¹jáng¹ ju³ jní² ca¹cuanh¹³ hniah¹² jáh² jmai³ jøng², hniah¹² dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gog¹² ja³hiúg³ diú¹³ tsen² Moloc báh³ mi³quinh³ hniah¹², quianh¹³ chi³neng¹² quiah¹² diú¹³ tsen² Renfán. Diú¹³ lan³ héi² báh³ ca¹jmoh³ hniah¹² cu³guiogh¹³ hniah¹². Diú¹³ héi² báh³ ca¹hlanh¹³ hniah¹². Hi² jøng² dsianh¹³jni hniah¹² ŋai¹² juu¹² Babilonia. Di³ ca¹jmoh³ hniah¹² lah¹jøng², ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Jøng² ja³ca¹ŋi³nio³ dsa² hóg¹ ja³tsa¹chian² dsa² tiogh³, mi³quin¹²dsa hniú¹² tsø³hmøah¹² ja³mi³tioh¹³ cang³ rø²hløah¹² lei¹³ quiah¹² Diú¹³. Diú¹³ báh³ ca¹he¹ ha²lah ca¹jmo¹dsa hniú¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hniú¹² jøng² ma²quin¹² dsa² hóg¹ jmai³ mi³jiag¹² hlai³ Josué, jmai³ ca¹ŋi¹lé²dsa huø¹ quiah¹² dsa² siáh². Jøng² ca¹huan¹ Diú¹³ dsa² quiah¹² huø¹, mi³ca¹dsi¹lé² dsa² hóg¹. Hniú¹² jøng² mi³tsih¹³ quiah¹²dsa mi³ca¹lø¹chián¹ hlai³ David. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hniang¹ báh³ Diú¹³ hlai³ David. Jøng² mi³jmóh¹ hlai³ David cøng² hniú¹² dsio¹ ja³mi³gú¹ Juu¹³ jniang³, Diú¹³ quián¹² hlai³ Jacob. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Cónh¹jøng² hlai³ Salomón báh³ dsa² ca¹jmóh¹ hniú¹², ja³ŋiúh³ hlai³ David. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Di³ a¹jáng¹ hi² tiúh¹ dsa² jmøi¹guǿi¹ jmóh¹ hniú¹² ja³gú¹ hŋiah¹² Diú¹³ dsa² juanh¹² mi³né³. Di³ lah¹la² báh³ lǿa¹² ni³ si² quiah¹² dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³: ");
INSERT INTO cpaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Lǿa¹² ŋi¹juǿi¹ ju³lah cøng² hma²sai³¹ ja³guø³jni. Lǿa¹² jmøi¹guǿi¹ ju³lah cøng² ja³toh¹²jni tai¹. ¿He² hniú¹² jmóh³hning quieg¹jni? ca¹juúh² Juu¹³ jniang³. ¿Ha²tøah¹ dsio¹ jan³jni? ");
INSERT INTO cpaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jní² báh³ dsa² ca¹jmo¹ ca¹lah¹jǿ¹, ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jøng² ca¹juúh² Esteban calah: ―Ha²lah hiug¹² huh² dseih¹² hniah¹². Tsa¹nǿngh³ hniah¹² jǿg³ quiah¹² Diú¹³. Cu¹dsie¹² tsa¹hnøngh² hniah¹² he² hi² jmo¹² jmi²dsí² han¹³ quiah¹²dsa. Cu²re² báh³ hniah¹² quianh¹³ dsa² hóg¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ca¹jmóh¹ dsa² hóg¹ ca¹lah¹já¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³. Ca¹mi¹dsian¹² báh³ dsa² hóg¹ dsa² ca¹hǿ² jǿg³ lah¹jiá¹² hi² jí¹ jan² dsa² dsiog¹. Jøng² mi³ca¹guøn¹ dsa² dsiog¹ héi², hniah¹² báh³ dsa² ca¹hnëh¹³dsa. Jøng² cajŋë́h¹ hniah¹² dsá¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ma²ŋih³ báh³ hniah¹² lei¹³ quiah¹² Diú¹³, lei¹³ ca¹cuø¹ ángeles ma²lǿih². Ha²lah dsio¹ tsa¹nøngh² hniah¹² lei¹³ jøng² ―ca¹juúh² Esteban. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jøng² ca¹lø¹hné¹ hlaih¹³ cu¹té¹² dsa² mi³tiogh³. Ca¹lah¹hlaih¹³ ca¹jmo¹dsa hag³dsa mi³ca¹nǿng²dsa jǿg³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jøng² quin¹² Esteban jmi²dsí² han¹³ quiah¹² Diú¹³ ca¹lah¹jǿ¹ dsǿa¹²dsa. Ca¹jái¹dsa guiuh¹³. Ca¹jái¹dsa hi² hiug¹² cu¹té¹² juanh¹² Diú¹³. Jøng² tsenh¹² Jesús cog² Diú¹³ ta¹lah¹guia¹jo¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jøng² ca¹juúh² Esteban: ―Jai³lah. Jái¹²jni chi³na¹ guiuh¹³ ŋi¹juǿi¹. Tsenh¹² dsa² ma²lán¹² dsa² jmøi¹guǿi¹ jian¹² jniang³ cog² Diú¹³ dsa² juanh¹² ta¹lah¹guia¹jo¹³ ―ca¹juúh² Esteban. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jøng² ca¹jne¹ dsa² héi³ guø³dsa tiogh³. Ca¹tǿ² ca¹ho¹dsa tsa¹hniu¹dsa nang¹dsa jǿg³. Cu¹dsie¹² ca¹chiánh²dsa Esteban. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ca¹ŋi¹jiag¹dsa chiuh³ juøi² juu¹² ja³ca¹qui² ca¹tǿg²dsa cang³. Jøng² ca¹huøh¹dsa ma¹cǿng¹ tsǿnh³dsa, hmøah¹² dsǿ² coh¹³. Ca¹dsii¹dsa ni³ jan² dsa² ŋioh¹² tsen² Saulo ta³lah¹ca¹jŋëh¹dsa Esteban. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jøng² ca¹hlanh¹ Esteban Diú¹³ ta³lah¹qui²tǿg² dsa² héi² cang³. Ca¹juúh²dsa: ―Jesús Juu¹³ jniang³, hieih³ jmi²dsí² quieg¹jni ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ni³ jøng² ca¹chi¹jné¹ Esteban. Ca¹hløah¹dsa tí². Ca¹tsáih¹dsa Diú¹³: ―Juu¹³ jniang³, ju³tsa¹cuøh¹³hning dsa² lang¹² dsag³, hi² jŋaih¹dsa jní² ―ca¹juúh²dsa. Ni³jøng² ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Hiug² báh³ dsǿa¹² Saulo ca¹jŋëh¹dsa Esteban. Jmai³ jøng² ca¹lø¹liág¹ ca¹jmóh¹dsa dsa² hé² jǿg³ quiah¹² Jesús jøa³juøi² Jerusalén. Ma¹dsio¹² hlaih¹³ ca¹jmógh¹dsa. Hi² jøng² ca¹tsø² ca¹jan¹ dsa² hé² jǿg³ ca¹lah¹tan¹³ ja³tén¹² Judea quianh¹³ ja³tén¹² Samaria. Jmáh¹lah tsih² høh³ quián¹² Jesús báh³ tsa¹ca¹cuøin¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jøng² ca²dsiog³ dsa² hnio¹ Diú¹³, ca¹ŋi³hog¹dsa hlai³ Esteban. Hiug¹² ca¹táh² cøh² dsǿa¹²dsa ni³ huu¹³ hi² ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jøng² ma¹dsio¹² ca¹jmóh¹ Saulo dsa² hé² jǿg³ jmai³ jøng². Ca¹hí¹dsa dsi²néi² lah¹cøng² lah¹cøng² hniú¹² ja³tiogh³dsa. Ca¹ŋi³tiogh²dsa dsa² hni¹ŋí³, cu¹dsie¹² dsa² ŋioh¹² ca¹lah¹quianh¹³ mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jøng² dsa² ca¹cuøin¹ héi², cøng² ca¹qui² ca¹téng² báh³ dsa² jǿg³ quiah¹² Jesús juu¹² ja³ca¹ŋi¹lé²dsa jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ju³lah Felipe, ca¹téng²dsa jǿg³ quiah¹² Cristo cøng² juøi² ja³ca¹dsiég¹dsa ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ca¹can¹ dsa² jue¹² hí³ jǿg³ ca¹he¹ Felipe, mi³ca¹nǿng²dsa, mi³ca¹jái¹dsa hi² gøg² ca¹jmo¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Di³ ca¹hlú² jue¹² dsa² mi³quin¹² jmi²dsí² hlaih¹³. Ho¹² jmi²dsí² ta³lah¹jøng². Jø¹² bíh³ ca¹hlú² jue¹² dsa² ŋøa¹² uai¹², quianh¹³ dsa² tsa¹lé² ŋøa¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jøng² jue¹² dsa² ca¹túgh² hioh¹² jenh¹²dsa jøa³uøi² jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ja³jøng² mi³guǿ¹³ jan² dsa² tsen² Simón, dsa² dsi¹² jǿg³ he² hi² chian² dsa². Dsogh¹² dsǿa¹² dsa² chian² Samaria hi² jmo¹² dsa² héi². Di³ juúh²dsa hŋiah¹²dsa hi² lán¹²dsa dsa² juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jøng² ca¹lah¹já¹ dsa² meh² quianh¹³ dsa² canh¹³ ca¹tónh¹ juu¹² jǿg³ ca¹juúh² Simón. Jue¹² dsa² juúh²: ―Hiug¹² juanh¹² Simón. Bí² quiah¹² Diú¹³ quin¹²dsa ―juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A¹jáng¹ cøng² jmai³ ca¹dsi¹ Simón jǿg³. Hi² jøng² jue¹² dsa² ca¹tónh¹ juu¹² jǿg³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ni³ jøng² ca¹hé¹ dsa² jue¹² héi² jǿg³ ca¹téng² Felipe, jǿg³ quiah¹² Jesucristo, quianh¹³ jǿg³ quiah¹² ja³jmo¹ Diú¹³ héh¹. Ca¹jŋó²dsa jmøi², ju³lah dsa² ŋioh¹² quianh¹³ dsa² mǿ². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jø¹² bíh³ ca¹hé¹ hŋiah¹² Simón calah. Ca¹jŋó²dsa jmøi². Cu¹dsie¹² tsa¹ca¹tiúg² dsa² héi² Felipe. Di³ dsogh¹² dsǿa¹²dsa hi² gøg² hi² juøh¹² jmo¹² Felipe. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jøng² mi³ca¹nǿng² tsih² høh³ quián¹² Jesús tiogh³ jøa³juøi² Jerusalén hi² ma²hé² dsa² chian² Samaria jǿg³ quiah¹² Diú¹³, jøng² ca¹tse¹dsa Pedro quianh¹³ Juan ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mi³ca¹dsi¹lé² dsa² héi², jøng² ca¹mǿh¹dsa Diú¹³ hi² tí²dsa jmi²dsí² han¹³ quiah¹² dsa² ma²hé² jǿg³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Di³ ha¹chian² dsa² héi² ma²ca¹can¹ jmi²dsí² han¹³ quiah¹² Diú¹³. Jmáh¹lah hi² ca¹jŋó²dsa jmøi² ni³ huu¹³ quiah¹² Jesús, Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jøng² ca¹cán¹ báh³ dsa² jmi²dsí² han¹³ mi³ca¹quieg² Pedro quianh¹³ Juan gug² ni³ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jøng² mi³ca¹jái¹ Simón ha²lah cán² dsa² jmi²dsí² han¹³ ja³quieg² tsih² høh³ gug² ni³ quiah¹²dsa, jøng² mi³cuø¹dsa cog³. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ca¹juúh²dsa: ―¿Tsa³cuúh³hning jǿg³ jmo³jni lah¹jøng²? Mi³jøng² cán²dsa jmi²dsí² han¹³, ju³lah hein² dsa² co¹³jni gug¹ ni³ quiah¹² ―ca¹juúh² Simón. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jøng² ca¹juúh² Pedro: ―Ju³dsi³hén³ cog³ quiánh²hning juu¹² ja³guǿnh³hning, juu¹² ja³hlaih¹³. Ha²lah dsio¹ lë́h²hning láh³hning quianh¹³ cog³ hi² la³cuø¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A¹jáng¹ hning² të́h² hi² jøng². Di³ tsa¹hiug² hoh¹²hning ja³cog² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ju³jeinh¹³ hoh¹²hning jǿg³ hlaih¹³ jøng². Møah¹³hning Juu¹³ jniang³ tsa¹ju³ta¹canh¹³hning hi² ca¹hí¹ hoh¹²hning jǿg³ hlaih¹³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Léi¹³jni lanh¹²hning dsa² dsih¹². Jmáh¹lah hi² hlaih¹³ báh³ dsø²jiag¹² hoh¹²hning ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jøng² ca¹juúh² Simón: ―Hlanh¹³ hniah¹² Juu¹³ jniang³ ni³ huu¹³ quieg¹ jní². Mi³jøng² ha¹chi² ju³jéin¹³jni hi² hlaih¹³, ju³lah ma²na²juøh³ hniah¹² ―ca¹juúh² Simón. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jøng² mi³ca¹jmo¹ Pedro quianh¹³ Juan jǿg³ quiah¹² Juu¹³ jniang³, mi³ca¹héh¹dsa dsa² jǿg³, ca¹ŋi¹lia¹dsa juu¹² jøa³juøi² Jerusalén. Juu¹² ja³ca¹ŋi¹lia¹dsa jøng² ca¹téng²dsa jǿg³ quiah¹² Jesucristo hliú² juøi² ja³tén¹² Samaria. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jøng² ca¹juúh² jan² ángel quián¹² Juu¹³ jniang³, ca¹tsáih¹dsa Felipe: ―Juu¹² tø¹quín² gu², juu¹² u²hai¹²dsa Jerusalén dság¹²dsa juu¹² Gaza ―ca¹juúh² ángel. Juu¹² ja³ha¹chian² dsa² tiogh³ báh³ jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jøng² ca¹ŋó¹ báh³ Felipe. Ja³jøng² ca¹jén²dsa jan² dsa² ŋioh¹² eunuco chian² Etiopía, dsa² juanh¹² jmo¹² hí³ cog³ quiah¹² hio¹³ rai¹³ quián¹² Etiopía. Candace báh³ mi³tsen² hio¹³ rai¹³. Jøng² ŋie³ dsa² ŋioh¹² héi² Jerusalén, ja³ca¹ŋi³hlanh¹³dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ma²dsanh¹²dsa. Guǿ¹²dsa ni³ hma²løh¹². Høa¹²dsa si² quiah¹² hlai³ Isaías, dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³ ma²lǿih². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jøng² ca¹juúh² jmi²dsí² quiah¹² Diú¹³, ca¹tsáih¹dsa Felipe: ―Gu²ŋøa³ quianh¹³ dsa² quin¹² hma²løh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Jøng² mi³ca¹dsiég¹dsa cøg¹², ca¹nǿng² Felipe høa¹² dsa² héi² si² quiah¹² hlai³ Isaías. Jøng² ca¹juúh² Felipe, ca¹tsáih¹dsa dsa¹ héi²: ―¿Ŋë́h³hning si² hi² høh²hning? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jøng² ca¹juúh² dsa² ŋioh¹² héi²: ―Ha¹chi² ŋë́²jni. Di³ ha¹chian² dsa² he¹² ―ca¹juúh²dsa. Jøng² ca¹tsáih¹dsa Felipe hi² mi³gú¹dsa quianh¹³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jøng² lah¹la² rø²juúh² si² ja³mi³høa¹²dsa: Tai¹dsa dsa² héi² ju³lah cøng² ja³tai¹²dsa jan² jah¹chih² juu¹² ja³jŋaih¹dsa. Jøng² jmo¹ dsa² héi² ju³lah jmo¹² jan² jah¹chih² tsa¹ho¹² ja³tiu¹²dsa jŋiú³jah. Ha¹chi² juúh²dsa jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ha¹chian² dsa² ca¹mi¹rø¹² jǿg³ quiah¹²dsa mi³ca¹can¹dsa jmø³uai¹². Ha¹chian² jong¹²dsa li¹chian². Ha¹chi² jǿg³ chi² tsø³jong¹³dsa. Ca¹jŋaih¹ báh³ dsa². Ha¹chi² ma¹cuø¹dsa ni³ jmøi¹guǿi¹ gú¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jøng² ca¹juúh² dsa² eunuco héi². Ca¹tsáih¹dsa Felipe: ―¿Tsa³ŋih³hning hein² dsa² hia¹² Isaías quianh¹³ si² la²? ¿Hia¹³dsa dsa² hŋiah¹²dsa ho¹ ju³ dsa² siáh² báh³? ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jøng² ca¹juúh² Felipe: ―Jǿg³ quiah¹² Jesús báh³ lǿa¹² ni³ si² la² ―ca¹juúh²dsa. Ni³ jøng² ca¹heh¹dsa dsa² héi² jǿg³ dsio¹ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ja³dsa²lé²dsa jøng², ca¹dsi¹lé²dsa cøng² ja³hiu³ jmøi². Jøng² ca¹juúh² dsa² eunuco, ca¹tsáih¹dsa Felipe: ―Jai³lah, jmøi² hiu³ ja³la². ¿Tsa³lé² tsóg¹jni jmøi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jøng² ca¹juúh² Felipe: ―Lé² báh³ ju³ná³ héh²hning jǿg³ quiah¹² Jesús ca¹lah¹jǿ¹ hoh¹²hning ―ca¹juúh² Felipe. Jøng² ca¹juúh² dsa² héi²: ―Hé² báh³ jní² hi² lán¹² Jesucristo jong¹² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jøng² ca¹jmo¹ dsa² eunuco ca¹jŋi¹ hma²løh¹² quiah¹²dsa. Jøng² ca¹ŋi¹lé²dsa quianh¹³ Felipe juu¹² dsi²jmøi². Ca¹jŋó² báh³ dsa² jmøi² ca¹chiag¹ Felipe. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jøng² mi³ca¹huanh¹²dsa dsi²jmøi², ca¹jian¹ jmi²dsí² quiah¹² Juu¹³ jniang³ Felipe juu¹² siíh². Tsa¹ma¹ca¹jǿi² dsa² eunuco. Ca¹ŋáh¹ báh³ dsa² eunuco, hioh¹² jenh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jøng² ca¹jnia¹ Felipe calah jøa³juøi² Azoto. Ca¹ŋó¹dsa. Ca¹téng²dsa jǿg³ dsio¹ quiah¹² Jesús lah¹cøng² lah¹cøng² juøi² ca¹lah¹ja³ca¹dsiég¹dsa jøa³juøi² Cesarea. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jøng² cøng² ca¹mi¹dsian¹² báh³ Saulo dsǿa¹² dsa² quianh¹³ Juu¹³ jniang³. Hniu¹dsa dsián¹ dsa² héi². Ŋie³dsa ni³ ŋi¹jmó². ");
INSERT INTO cpaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ca¹møa¹dsa si² hi² li¹chian²dsa bí² ja³mi³dság¹dsa guøh¹² quiah¹² dsa² judío jøa³juøi² Damasco. Mi³jøng² ju³ná³ hein² dsa² ŋi²nio³ juu¹² quiah¹² Jesús ca¹dsanh¹²dsa, ju³ mǿ², ju³ dsa² ŋioh¹², jøng² ma²chian²dsa bí² chiánh²dsa dsa² héi², hi² tai¹dsa juu¹² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jøng² ca¹ŋó¹dsa juu¹² jøa³juøi² Damasco. Cøng² mi³ja¹quien¹³ dsiég¹³dsa, cónh¹ tsa¹ju²jŋiá³ ca¹jni¹ cøng² si² guiuh¹³, ca¹táih¹ quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jøng² ca¹canh¹dsa. Ca¹nǿng²dsa cøng² jǿg³ ca¹hløah¹ dsi³guøi²: ―Saulo, ¿he² løa¹ mi²dsianh¹³hning dsøa¹? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jøng² ca¹juúh² Saulo: ―¿Hein² hning² iéh² Guiuh¹³? ―ca¹juúh²dsa. Jøng² ca¹hløah¹ calah dsi³guøi²: ―Jesús báh³ jní², dsa² mi²dsianh¹³hning dsǿa¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","¡Nung²! ¡Gu² juu¹² jøa³juøi²! Ja³jøng² li¹chi² jǿg³ he² hniuh¹² jmóh³hning ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jøng² tei³ ca¹túgh² dsa² quianh¹³ Saulo. Ca¹nǿng² báh³ dsa² hi² hløah¹² dsa². Cónh¹jøng² ha¹chian² dsa² hløah¹² ca¹jë́²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jøng² ca¹nung² Saulo. Mi³ca¹jái¹dsa, cu¹dsie¹² tsa¹ma¹jniuh¹²dsa. Jøng² dsa² quianh¹³dsa ca¹jiag¹ juu¹² jøa³juøi² Damasco chi³chinh¹²dsa gug²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ja³jøng² ca¹gú¹dsa hnøa¹² jmai³ hi² tsa¹jniuh¹²dsa. Ha¹chi² ca¹gǿh¹dsa. Ha¹chi² ca¹hǿnh²dsa jin³ he². ");
INSERT INTO cpaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jøng² mi³guǿ¹³ jan² dsa² quianh¹³ Jesús jøa³juøi² Damasco, dsa² tsen² Ananías. Ca¹jë́² dsa² héi² Juu¹³ jniang² ju³lah jan² dsa² cøa¹². Ca¹juúh² Juu¹³ jniang³: ―¡Ananías! ―ca¹juúh²dsa. Jøng² ca¹juúh² Ananías: ―He³ jní² lang¹² Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jøng² ca¹juúh² Juu¹³ jniang³. Ca¹tsáih¹dsa Ananías: ―Gu² juu¹² jøa³cai³¹ tsen² Derecha. Ja³quiah¹³ Judas gu³hniah¹² jan² dsa² chian² juøi² Tarso, dsa² tsen² Saulo. Chi³hlanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ju³lah jan² dsa² cøa¹² ca¹jë́²dsa hning². Ca¹húh¹hning dsi²néi². Ca¹quiegh²hning gugh² ni³ quiah¹²dsa. Mi³jøng² ca¹lø¹jniuh¹²dsa calah ―ca¹juúh² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jøng² ca¹juúh² Ananías: ―Ma²ca¹nang¹jni jǿg³ quiah¹² dsa² héi², Juu¹³ jniang³. Jue¹² dsa² juúh² he² hi² hlaih¹³ ma²ca¹jmo¹dsa jøa³juøi² Jerusalén ja³cog² dsa² hé² jǿg³ quiánh²hning. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jøng² ca¹cuø¹ juu¹³ jmi²dsa² jǿg³ ca¹já¹dsa jøa³juøi² la², hi² chiángh²dsa ca¹lah¹jái¹ jnieh³, dsa² hlanh¹² hning² ―ca¹juúh² Ananías. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jøng² ca¹juúh² calah Juu¹³ jniang³: ―¡Gu²! Di³ dsa² héi² ma²ca¹hia¹jni, dsa¹can¹²dsa jǿg³ quieg¹jni ni³ dsa² chian² ja³siíh³, ni³ rai¹³, ni³ dsa² israel. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Jøng² hé¹³jni dsa he² jmø³uai¹² ma¹dsio¹² hniuh¹² cán²dsa huu¹³ quieg¹ jní² ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jøng² ca¹ŋó¹ Ananías ja³mi³hiúg³ Saulo. Mi³ca¹hí¹dsa dsi²néi² jøng², ca¹quieg²dsa gug²dsa ni³ quiah¹² Saulo. Ca¹juúh²dsa: ―Saulo, roh¹³ jniang³, jní² na²guio¹. Na²tsei¹ Jesús Juu¹³ jniang³, dsa² ca¹janh³hning dsi²juu¹² ja³ca¹ŋieh¹hning. Na¹guio¹jni. Mi³jøng² li¹jniah¹hning calah. Mi³jøng² cánh³hning jmi²dsí² han¹³ quiah¹² Diú¹³ ―ca¹juúh² Ananías. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dsø¹juu¹² jøng² lah¹cøng² hi² ca¹quia¹ løg² mi³dsǿ² mø³ni³dsa ca¹løa¹. Ca¹jniáng¹ calah mø³ni³dsa. Jøng² ca¹jŋó² Saulo jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ni³ jøng² ca¹gǿh¹dsa. Ca¹tánh¹dsa calah bí². Jøng² ca¹jŋi¹dsa ton¹ hnøa¹² jmai³ quianh¹³ dsa² chian² jøa³juøi² Damasco jøng², ju³lah dsa² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dsø¹juu¹² jøng² ca¹téng² Saulo jǿg³ dsi²néi² guøh¹² quiah¹² dsa² judío. Ca¹juúh²dsa: ―Lán¹² Jesús ja³ŋiúh³ Diú¹³ juanh¹² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jøng² dsogh¹² dsǿa¹² ca¹lah¹já¹dsa mi³ca¹nǿng²dsa jǿg³ jøng². Ca¹juúh²dsa: ―¿Jáng¹³ ju³ dsa² ná¹² mi³ŋøa¹² jøa³juøi² Jerusalén mi²dsian¹² hlaih¹³ dsǿa¹² dsa² hlanh¹² Jesús? ¿Jáng¹³ ju³ dsa² ná¹² ca¹guøn¹ calah ja³la² hi² mi³chiánh²dsa dsa² hé² jǿg³ quiah¹² Jesús, hi² mi³tai¹dsa ni³ juu¹³ jmi²dsa²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jøng² hiug¹² jín³ tí² ma²neng¹² dsǿa¹² Saulo ca¹téng²dsa jǿg³. Ca¹mi¹léi¹³dsa lán¹² Jesús Cristo, dsa² ca¹tsen¹ Diú¹³. Cu¹dsie¹² tei³ ca¹túgh² dsa² judío chian² Damasco. Di³ tsa¹ma¹tiúh¹dsa dsii¹dsa jǿg³ quianh¹³ Saulo. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jøng² mi³ma²ŋó¹² jmai³ jøng² ca¹jmo¹ dsa² judío jǿg³ guiog³dsa, hi² mi³jŋëh¹dsa Saulo. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jøng² ca¹lø¹ŋi¹² Saulo jǿg³. Lah¹huu² lah¹jmø² ma²chi³tiag² dsa² héi² hag³juu¹³ hi² jŋaih¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Cónh¹jøng² ca¹ŋi¹jiag¹ dsa² quianh¹³ Saulo juu¹² chiuh³ juøi² ja³neng². Ja³jøng² ca¹siúg²dsa Saulo coh¹³ jnǿ³ hiúg³dsa møh²tá³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jøng² mi³ca¹dsiánh¹ Saulo jøa³juøi² Jerusalén, hniu¹dsa mi³mi¹quianh³dsa dsa² quianh¹³ Jesús. Jøng² ca¹lah¹já¹ dsa² héi² gan¹dsa Saulo. Tsa¹hé²dsa ma²lán¹² Saulo dsa² quianh¹³ Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hi² jøng² báh³ ca¹ŋi¹jiag¹ Bernabé juu¹² ni³ tsih² høh³ quián¹² Jesús. Ca¹dsii¹dsa jǿg³ ha²lah ca¹jë́² Saulo Juu¹³ jniang³ dsi²juu¹². Ca¹he¹dsa jǿg³ he² ca¹juúh² Juu¹³ jniang³, ca¹tsáih¹dsa Saulo. Jøng² ca¹he¹dsa ha²lah ca¹téng² Saulo jǿg³ quiah¹² Jesús ca¹lah¹jǿ¹ dsǿa¹²dsa jøa³juøi² Damasco. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jøng² ca¹lø¹quianh¹³ Saulo dsa² chian² Jerusalén héi². Ca¹ŋi³nio³dsa cøng² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jøng² ca¹dsii¹ Saulo jǿg³ quiah¹² Juu¹³ jniang³ ca¹lah¹jǿ¹ dsǿa¹²dsa. Ca¹qui² ca¹dsii¹dsa jǿg³ quianh¹³ dsa² judío, ju³lah dsa² hløah¹² jǿg³ griego. Dsa² héi² mi³jmo¹²dsa bí² hi² jŋëh¹dsa Saulo. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jøng² mi³ca¹lø¹ŋi¹² dsa² roh¹³ jniang³, ca¹ŋi¹jiag¹dsa juu¹² juøi² Cesarea. Jøng² ca¹tsei¹dsa juu¹² juøi² Tarso. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jøng² ha¹chi² ju²méh³ dsøa¹² ma¹chi² quiah¹² dsa² quián¹² Jesús, ju³lah dsa² tiogh³ ja³tén¹² Judea quianh¹³ ja³tén¹² Galilea quianh¹³ ja³tén¹² Samaria. Ca¹niu¹ tí² jǿg³ quiah¹² Jesús ja³jøng². Ca¹mi¹juanh¹²dsa Juu¹³ jniang³. Jøng² ca¹túgh²dsa hioh¹² jenh¹²dsa. Ca¹ŋi¹jué²dsa, ca¹jmo¹ jmi²dsí² han¹³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jøng² jmai³ ca¹ŋi³ŋø² Pedro ta³cøng² ja³tiogh³ dsa² hé² jǿg³ quiah¹² Jesús, ca¹dsiég¹dsa juøi² Lida. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ja³jøng² ca¹jén²dsa jan² dsa² tsen² Eneas, dsa² ma²ron¹² huanh² jŋi¹ ji²ŋi² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa dsa² héi²: ―Mi²hliú² Jesucristo hning², Eneas. ¡Nung²! ¡Chiag³ jmung² quiánh²hning! ―ca¹juúh² Pedro. Jøng² ta³lah¹ca¹nung² Eneas. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jøng² ca¹jéinh¹ dsǿa¹² ca¹lah¹já¹ dsa² chian² Lida quianh¹³ Sarón ja³cog² Juu¹³ jniang³ mi³ca¹jái¹dsa ca¹hlú² Eneas. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jmai³ jøng² mi³guǿ¹³ jan² hio¹³ quián¹² Jesús jøa³juøi² Jope, dsa² tsen² Tabita, hi² hniu¹dsa juúh²dsa Dorcas quianh¹³ jǿg³ griego. Hliú² hi² dsio¹ ma²ca¹jmo¹ hio¹³ héi². Ca¹cuø¹dsa ju³lah he² hi² chi³quian¹³ dsa² jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ni³ jøng² ca¹lø¹dsoh¹ hio¹³. Ca¹jon¹dsa. Jøng² mi³ma²na²sen¹dsa hlai³, ca¹ŋi³quiag²dsa guiuh¹³ hniú¹² ton¹ jué¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Quién¹² jøng² báh³ neng¹² Jope cøg¹² juøi² Lida ja³mi³hiúg³ Pedro. Jøng² ma²ŋi¹² dsa² quianh¹³ Jesús hi² hiúg³ Pedro ja³jøng². Hi² jøng² ca¹tse¹dsa og¹ dsa² ca¹ŋi³tseih³ Pedro, ca¹juúh²dsa: ―Hning² tai²dsa jøa³juøi² Jope ma²ta¹na¹ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jøng² ca¹ŋó¹ báh³ Pedro quianh¹³ dsa² héi². Mi³ca¹dsi¹lia¹dsa, ca¹tai¹dsa guiuh¹³ hniú¹² ton¹ jué¹ jøng². Jøng² ca¹túgh² jue¹² hio¹³ hnǿi² ti³ho¹² lah¹jin² lah¹lǿih² ja³tsenh¹³ Pedro. Ca¹he¹dsa jóg³ dsa² quianh¹³ tsǿnh³ dsa² hi² ca¹jmo¹ Dorcas jmai³ mi³chian²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ni³ jøng² ca¹huan¹ Pedro ca¹lah¹já¹ dsa² héi². Jøng² mi³ca¹chi¹jné¹ Pedro, ca¹hlanh¹dsa Diú¹³. Jøng² ca¹jénh¹dsa ja³ron¹² hlai³. Ca¹juuh²dsa: ―¡Nung² Tabita! ―ca¹juúh²dsa. Jøng² ca¹jái¹ hio¹³. Jøng² mi³ca¹jë́²dsa Pedro, ca¹gú²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jøng² ca¹héi¹ Pedro gug² hio¹³. Ca¹chiag¹dsa. Ni³ jøng² ca¹tǿh¹ Pedro dsa² roh¹³ jniang³, quianh¹³ dsa² hnǿi² quianh³dsa. Jøng² ca¹mi¹léi¹³ Pedro hi² ma²ca¹jinh³ hio¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jøng² ca¹tsø² ca¹jan¹ jǿg³ ta³cøng² juøi² Jope. Ni³ jøng² jue¹² dsa² ca¹hé¹ jǿg³ quiah¹² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jøng² ca¹jŋi¹ Pedro cu²hna² jøa³juøi² Jope ja³quiah¹³ jan² dsa² guǿ¹² ta³ jmo¹² dsio¹ lag³ jáh², dsa² tsen² Simón. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mi³guǿ¹³ jan² dsa² tsen² Cornelio jøa³juøi² Cesarea, dsa² lán¹² juu¹³ hlég² quián¹² cu²tséh¹ hlég² tsen² Italiano. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dsa² hnio¹ Diú¹³ báh³ dsa² héi². Mi²juanh¹²dsa Diú¹³ cu¹dsie¹² quianh¹³ dsa² quián¹²dsa. Ma¹dsio¹² cog³ cuø¹²dsa, hi² mi²hog³dsa dsa² judío. Hlanh¹²dsa Diú¹³ ca¹lah¹jǿ¹ jmai³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jøng² lah¹la² ca¹løa¹ cøng² jmai³ cónh¹ hein¹³ hnøa¹² ta¹ca¹hlég². Ca¹lah¹quianh¹³ cøng² hi² cøa²dsa ca¹jë́² Cornelio cu²rø² jan² ángel quián¹² Diú¹³. Ca¹hí¹ ángel dsi²néi². Jøng² ca¹juúh²dsa: ―Cornelio ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jøng² tei³ hlaih¹³ ca¹gú² Cornelio. Chi³goh¹²dsa, mi³ca¹jǿi²dsa. Jøng² ca¹juúh²dsa: ―¿He² ná¹² Juu¹³ jniang³? ―ca¹juúh²dsa. Jøng² ca¹juúh² ángel: ―Nang¹² báh³ Diú¹³ jǿg³ hi² hlanh¹³hning dsá¹. Jái¹²dsa ca¹cuøh³hning dsa² ti²ŋié² cog³. Hi² jøng² dsagh² báh³ dsǿa¹² Diú¹³ hning². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jøng² tsë́h³hning dsa² juu¹² jøa³juøi² Jope, dsa² dsa¹tei² Simón, dsa² tǿh²dsa Pedro calah. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Guǿ¹²dsa ja³quiah¹³ jan² dsa² guǿ¹² ta³ jmo¹² dsio¹ lag³ jáh², dsa² tsen² Simón calah, dsa² tsih¹² hniu³ chiuh³ jmø³ŋih¹³ ―ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jøng² mi³ca¹ŋáh¹ ángel, ca¹tǿh¹ Cornelio og¹ dsa² jmo¹² ta³ quiah¹²dsa, quianh¹³ jan² hlég² quián¹²dsa, dsa² hnio¹ Diú¹³, dsa² mi²ti¹ ni³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jøng² mi³ca¹heh¹dsa dsa² héi² jǿg³ ca¹lah¹jǿ¹ hi² ca¹jái¹dsa, ca¹tsei¹dsa juu¹² Jope. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jøng² mi³ca¹jni¹ jøng², tiogh³ dsa² héi² juu¹², ja¹quien¹³ dsi³lé²dsa juøi² Jope, mi³ca¹ŋó¹ Pedro guiuh¹³ hniú¹². Dsa¹hlanh¹dsa Diú¹³ cónh¹ dsi¹hiég¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jøng² ma²lǿ² lø¹i³cónh¹² Pedro. Hniu¹dsa mi³gǿh¹dsa. Jøng² ta³lah¹jmo¹² dsa² má¹, ca¹jái¹ Pedro lah¹cøng² hi² cøa²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ca¹jái¹dsa rø²na¹² guiuh¹³ ŋi¹juǿi¹. Ma²siag² juu¹² huø¹ cøng² hi² jní² ju³lah jní² cøng² hmøah¹² juøh¹² ti³cogh¹² jø² quiún² quiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Niúh¹ hmøah¹² jøng² mi³tiogh³ ca¹lah¹i³ ni³ jáh², ju³lah jáh² ni³dsǿa¹² quiún² tai³, jáh² han¹², jáh² tsøah¹² quiah¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jøng² ca¹juúh² Diú¹³: ―Nung² Pedro. Mi²dsian¹³ jáh² ná¹². Cugh¹³ ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Jøng² ca¹juúh² Pedro: ―Tsa¹lé² lah¹jøng² Juu¹³ jniang³. Jin³ cøng² jmai³ tsa¹ma²ca¹gøah¹jni hi² hlaih¹³ hi² tsáh² ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jøng² ca¹juúh² Diú¹³ calah ca¹tǿ² tánh¹: ―Tsa¹juúh³hning hi² tsáh² hi² ma²ca¹jmo¹ jní² ti³jai¹ ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hnøa¹² rón² ca¹løa¹ lah¹jøng². Ni³ jøng² ca¹ŋáh¹ hi² jøng² juu¹² ŋi¹juǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jøng² ca¹gú² Pedro chi³høa¹² dsǿa¹²dsa hi² ca¹jái¹dsa. ―¿He² bíh³ ná¹²? ―lë́²dsa. Jøng² ca¹dsi¹lé² dsa² héi², dsa² ca¹tse¹ Cornelio. Ma²na²ŋai¹dsa juu¹² ja³quiah¹³ Simón. Ma²tiogh³dsa ja³dsi¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ca¹hløah¹dsa tí², ca¹juúh²dsa: ―¿Tsa³guǿ¹² Simón ja³la², dsa² tǿh²dsa Pedro? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lah¹lǿa¹² jøng² báh³ chi³høa¹² dsǿa¹² Pedro hi² ca¹jái¹dsa, mi³ca¹juúh² jmi²dsí² han¹³ quiah¹² Diú¹³: ―Jai³lah, úg² dsa² hnah¹² hning². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Siógh³hning huø¹. Góh³hning quianh¹³ dsa² héi². Ha¹chi² jmóh³hning hoh¹² jin³ he². Di³ jní² báh³ dsa² ca¹tsë́² dsa² héi² ―ca¹juúh² jmi²dsí² quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jøng² ca¹siog² Pedro ja³mi³tiogh³ dsa² héi². Ca¹juúh²dsa: ―Jní² báh³ lang¹², dsa² hnah¹³ hniah¹². ¿He² løa¹ na²ja¹noh¹² hniah¹²? ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jøng² ca¹juúh² dsa² héi²: ―Na²já¹ jnieh³ jǿg³ quiah¹² Cornelio, juu¹³ hlég², dsa² dsiog¹, dsa² mi²juanh¹² Diú¹³. Tøa¹² dsǿa¹² ca¹lah¹já¹ dsa² judío ha²lah ŋøa¹²dsa. Jøng² ca¹tse¹ Diú¹³ jan² ángel han¹³, dsa² ca¹ŋi³jmó³ jǿg³ hi² mi³tai² Cornelio hning². Mi³jøng² nang¹dsa he² jǿg³ juúh³hning ―ca¹juúh² dsa² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jøng² ca¹ŋë́² Pedro dsa² héi² dsi²néi². Ca¹cuø¹dsa hniú¹² ja³jŋi¹dsa. Mi³ca¹jni¹ jøng², ca¹ŋi¹lé² Pedro quianh¹³ dsa² héi², ca¹lah¹ma¹quianh¹³ ca²dsiog³ dsa² roh¹³ jniang³ chian² juøi² Jope. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mi³ca¹jni¹ jmai³ siíh² jøng², ca¹dsi¹lé²dsa jøa³juøi² Cesarea. Ma²chi³jŋiang¹² Cornelio cu¹dsie¹² quianh¹³ dsa² ju³roh¹³dsa quianh¹³ dsa² jenh² quianh³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jøng² ca¹hiei¹ Cornelio, mi³ca¹dsiég¹ Pedro hag³hniú¹³. Cu¹dsie¹² ca¹chi¹jné¹dsa. Ca¹mi¹juanh¹²dsa Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jøng² ca¹chiag¹ Pedro. Ca¹juúh²dsa: ―Nung². Dsa² jmøi¹guǿi¹ lah¹hning² báh³ jní² ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ta³lah¹dsii¹²dsa jǿg³ ca¹ŋi¹togh¹dsa dsi²néi² ja³ca¹jái¹dsa ma²tiogh³ dsa² jue¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jøng² ca¹juúh² Pedro: ―Ma²ŋih³ báh³ hniah¹² ha²lah lǿa¹² lei¹³ quián² jnieh³ dsa² judío. Tsa¹lǿa¹² jǿg³ tiágh³ jnieh³ quianh¹³ dsa² lah¹hniah¹², dsa² tsa¹lán¹² dsa² judío. Tsa¹lé² dsií³ jnieh³ jǿg³ quianh¹³ hniah¹². Di³ ma²ca¹heh¹ Diú¹³ jní², hi² tsa¹lé² jmo³jni hi² hlanh³ hi² tsáh² jin³ hein² dsa² jmøi¹guǿi¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jøng² ha¹chi² lë́²jni jin³ he² na²guio¹jni mi³ca¹teh¹² hniah¹². Jøng² hno¹jni li¹guiang³jni he² løa¹ ca¹teh¹² hniah¹² jní² ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jøng² ca¹juúh² Cornelio: ―Ma²quiún² jmai³ na¹, cónh¹ hora la², ca¹mi³han¹³jni hi² mi²juanh¹³jni Diú¹³. Guø³jni dsi²néi². Jøng² mi³ma²hlanh¹³jni Diú¹³ cónh¹ hein¹³ hnøa¹² ta¹ca¹hlég², dsø¹juu¹² jøng² ca¹jnia¹ jan² dsa² quieih¹² hmøah¹² sih¹² hlaih¹³ cu¹té¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jøng² ca¹tsáih¹dsa² héi² jní²: “Cornelio, ma²ca¹nǿng² báh³ Diú¹³ jǿg³ hi² hlanh¹³hning dsá¹. Dsagh² báh³ dsǿa¹² Diú¹³ cuuh²hning cog³ quiah¹² dsa² ti²ŋié². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jøng² tsë́h³hning dsa² juu¹² juøi² Jope, hi² dsa¹tei¹dsa Simón, dsa² tsen² Pedro calah, dsa² hiúg³ chiuh³ jmø³ŋih¹³ ja³quiah¹³ jan² dsa² siáh² tsen² Simón calah, dsa² guǿ¹² ta³ jmo¹² dsio¹ lag³ jáh²,” ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hi² jøng² ca¹tai³jni hning² dsø¹juu¹². Dsio¹ báh³ na²ŋiéh¹hning. Tiagh³ jnieh³ ca¹lah¹jái¹ jnieh³ ja³la² ja³ta¹ni¹ Diú¹³, hi² néng³ jnieh³ ca¹lah¹jǿ¹ jǿg³ ma²ca¹juúh² Diú¹³ hi² juaih¹³hning jnieh³ ―ca¹juúh² Cornelio. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jøng² ca¹juúh² Pedro: ―Lah¹dsóh² ma²léi¹³jni cu²rø² báh³ hnio¹ Diú¹³ ca¹lah¹i³ ni³ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Cu²rø² báh³ hiug² dsǿa¹²dsa ja³cog² dsa² mi²juanh¹²dsa, dsa² jmo¹² hi² dsio¹, lǿa¹² ju³ ha² ja³chian²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ma²ca¹heh¹ Diú¹³ dsa² israel hi² ca¹mi¹rø¹² Jesucristo jǿg³. Jøng² ma²lán¹² dsa² héi² Juu¹³ jniang³, ca¹lah¹jái¹ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ma²ŋih³ báh³ hniah¹² jǿg³ he² hi² ca¹løa¹ ta³cøng² juøi² go² jnieh³, jǿg³ ca¹lø¹liág¹ ja³tén¹² Galilea mi³ca¹téng² Juan jǿg³ hi² tsóg¹ dsa² jmøi¹guǿi¹ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma²ŋih³ báh³ hniah¹² ca¹hia¹ Diú¹³ juanh¹² Jesús, dsa² chian² Nazaret. Ca¹cuúh¹dsa dsa² jmi²dsí² han¹³ quiah¹²dsa. Mi³jøng² ma²chian²dsa bí². Jøng² ca¹ŋøa¹ Jesús. Ca¹jmo¹dsa hi² dsio¹. Ca¹mi¹hliú²dsa dsa² mi³jmoh¹² dsa² hlanh³. Di³ mi³quianh¹³ báh³ Jesús Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ma²ca¹ne¹³ jnieh³ ca¹lah¹jǿ¹ hi² ca¹jmo¹ Jesús lah¹tan¹³ ja³tiogh³ dsa² judío ca¹lah¹quianh¹³ jøa³juøi² Jerusalén. Jesús héi² báh³ ca¹jŋëh¹dsa ni² crǿg¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jøng² ca¹hiog²dsa calah jmai³ hnøa¹², ca¹jmo¹ Diú¹³ juanh¹². Ca¹ne¹³ jnieh³ dsá¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ha¹chi² ca¹jǿi² ca¹lah¹já¹ dsa² mi³né³. Jmáh¹lah jnieh³ báh³ ca¹ne¹³. Di³ ma²ca¹hei¹ Diú¹³ jnieh³ lah¹jiá¹². Jøng² ca¹cø² ca¹quie¹³ jnieh³ quianh¹³ Jesús mi³ca¹hiog²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ni³ jøng² ca¹tsei¹ Jesús dsa²hǿ¹³ jnieh³ jǿg³ hi² ma²ca¹ne¹³ jnieh³. Mi³jøng² li¹ŋi¹² dsa² ca¹hia¹ Diú¹³ Jesús, dsa² ma²lán¹² jue¹³ mi¹rø¹² jǿg³ quiah¹² dsa² chian² quianh¹³ dsa² ma²ca¹dsan¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jǿg³ quiah¹² Jesús héi² báh³ ca¹dsii¹ ca¹lah¹já¹ dsa² mi³hǿ² jǿg³ quiah¹² Diú¹³. Ca¹juúh²dsa: “Ju³ná³ hein² dsa² hé² jǿg³ quiah¹² Jesús, dsa¹hén² dsǿg³dsa,” ca¹juúh²dsa ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Guǿ¹² lah¹jøng² báh³ Pedro dsii¹²dsa jǿg³ jøng² mi³ca¹hí¹ jmi²dsí² han¹³ quiah¹² dsa² ti³nang¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jøng² dsogh¹² dsǿa¹² dsa² judío, dsa² roh¹³ jniang³ mi³quianh¹³ Pedro, mi³ca¹jái¹dsa ca¹tí² Diú¹³ jmi²dsí² han¹³ quiah¹² quiah¹² dsa² tsa¹lán¹² judío. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Di³ ca¹jái¹dsa ti³hløah¹² dsa² héi² jǿg³ siíh², hi² mi²juanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jøng² ca¹juúh² Pedro, ca¹tsáih¹dsa dsa² quianh¹³dsa: ―Tsa¹lé² tsa¹cuú³ jniang³ hi² tsóg¹ dsa² ná¹² jmøi². Di³ ma²na²can¹dsa jmi²dsí² han¹³ quiah¹² Diú¹³, ju³lah ma²quin³ jniang³ ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jøng² ca¹jmo¹ Pedro jǿg³ hi² ca¹jŋó² dsa² héi² jmøi² ni³ huu¹³ quiah¹² Jesucristo. Jøng² ca¹mǿh¹ dsa² héi² Pedro hi² jŋi¹dsa ton¹ hnøa¹² jmai³ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jøng² ca¹nǿng² tsih² høh³ quianh¹³ dsa² roh¹³ jniang³ tiogh³ ja³tén¹² Judea jǿg³ hi² ma²ca¹lø¹hiúg¹ dsǿa¹² dsa² tsa¹lán¹² judío jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hi² jøng² ca¹jí² dsa² judío, ju³lah dsa² ma²hé² jǿg³ quiah¹² Jesús, mi³ca¹dsiánh¹ Pedro jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ca¹juúh²dsa: ―¿He² løa¹ ca¹ŋieh³hning ja³quiah¹³ dsa² tsa¹lán¹² dsa² go² jniang³? ¿He² løa¹ ca¹quíh²hning quianh¹³ dsa² héi²? ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jøng² ca¹dsii¹ Pedro ca¹lah¹jǿ¹ jǿg³ ca¹lah¹cónh¹ mi³ca¹lø¹liág¹. Ca¹juúh²dsa: ");
INSERT INTO cpaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Mi³guø³jni jøa³juøi² Jope. Chi³hlanh¹³jni Diú¹³, mi³ca¹jái¹jni lah¹cøng² hi² cøa²jni ca¹siag² ju³lah jní² cøng² hmøah¹² juøh¹² ni³cogh¹² jø² quiún² quiuh¹³. Ca¹já¹ juu¹² guiuh¹³. Ca¹gog¹ ca¹tǿ² ja³mi³guø³jni. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mi³ca¹jái¹jni he² hi² tioh¹³ niúh¹, ca¹jan³jni jáh² quiún² tai³, jáh² dsi¹³ cog¹², jáh² tsøah¹² quiah¹², jáh² chian² niuh¹núng¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jøng² ca¹juúh² Diú¹³, ca¹tsáih¹dsa jní²: “Nung² Pedro. Mi²dsian¹³ jáh² ná¹². Cugh¹³,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Jøng² ca¹juúh¹jni: “Tsa¹lé² lah¹jøng² Juu¹³ jniang³. Di³ jin³ cøng² jmai³ tsa¹ma²ca¹hí¹ ho¹jni hi² hlaih¹³ hi² tsáh²,” ca¹juúh¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jøng² ca¹juúh² Diú¹³ calah ca¹tǿ² tánh¹: “Tsa¹jmóh³hning tsáh² hi² ma²ca¹jmo¹ jní² ti³jai¹,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hnøa¹² rón² ca¹løa¹ lah¹jøng². Jøng² ca¹ŋáh¹ calah hi² jøng² juu¹² guiuh¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Dsø¹juu¹² jøng² ca¹dsi¹lé² úg² dsa² ja³dsi¹² ja³mi³hiúg³jni, dsa² ca¹ja¹lé² juøi² Cesarea. Hnangh²dsa jní². ");
INSERT INTO cpaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jøng² ca¹juúh² jmi²dsí² quiah¹² Diú¹³, ca¹tsáih¹ jní²: “Ha¹chi² jmóh³hning hoh¹² hi² góh³hning quianh¹³ dsa² ná¹²,” ca¹juúh²dsa. Jøng² ca¹ŋi¹lé² jŋió² dsa² roh¹³ jniang³ lang¹² quianh¹³ jní². Ca¹ŋi¹tagh¹ jnieh³ dsi²néi² quiah¹² jan² dsa². ");
INSERT INTO cpaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dsa² héi² ca¹dsii¹ jǿg³ ha²lah ma²ca¹jë́²dsa jan² ángel dsi²néi² quiah¹²dsa. Ca¹juúh² ángel, ca¹tsáih¹dsa dsa² héi²: “Tsë́h³hning dsa² jøa³juøi² Jope hi² dsa¹tei²dsa Simón, dsa² tsen² Pedro calah. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dsa² héi² juúh² ha²lah lé² liúgh²hning cu¹dsie¹² quianh¹³ dsa² quiánh²hning,” ca¹juúh² ángel. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jøng² mi³ma²na²hløah³jni, ca¹tí² Diú¹³ jmi²dsí² han¹³ quiah¹² quiah¹² dsa² tiogh³ ja³jøng², ju³lah ca¹jmo¹dsa quián² jniang³ ca¹lah¹cónh¹ mi³ca¹lø¹liág¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jøng² ca¹dságh¹ dsøa¹jni jǿg³ ca¹juúh² Juu¹³ jniang³: “Lah¹dsóh² jmáh¹lah jmøi² báh³ ca¹chiog¹ Juan hniah¹². Hiug¹² jín³ hi² dsio¹ jmo¹ Diú¹³ dsa² juanh¹². Di³ tí²dsa jmi²dsí² han¹³ quiah¹² quiánh² hniah¹²,” ca¹juúh² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Cu²rø² báh³ ma²ca¹cuúh¹ Diú¹³ dsa² héi², ju³lah ca¹cuúh¹dsa jniang³, dsa² hé² jǿg³ quiah¹² Jesucristo, Juu¹³ jniang³. ¿He² løa¹ jní² tsa¹hno¹ hi² ca¹jmo¹ hŋiah¹² Diú¹³? ―ca¹juúh² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cu¹dsie¹² tei³ ca¹túgh² dsa² roh¹³ jniang³ chian² Jerusalén mi³ca¹nǿng²dsa jǿg³ jøng². Ca¹mi¹juanh¹²dsa Diú¹³. Ca¹juúh²dsa: ―Dsio¹ báh³ lah¹jøng². Ma²ca¹cuø¹ Diú¹³ jǿg³ jéinh¹ dsǿa¹² dsa² tsa¹lán¹² judío. Di³ jøng² li¹chian²dsa ja³cog² Diú¹³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jøng² dsa² quián¹² Jesús héi², dsa² ca¹mi¹dsian¹²dsa dsǿa¹² mi³ca¹jon¹ Esteban, ca¹cuøin¹ dsa² héi² juu¹² ja³tén¹² Fenicia, juu¹² ja³tén¹² Chipre, juu¹² ja³tén¹² Antioquía. Ja³jøng² ca¹heh¹dsa jmáh¹lah dsa² judío jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ni³ jøng² ca¹dsi¹lé² calah hi³méh¹ dsa² quián¹² Jesús, dsa² chian² Chipre quianh¹³ Cirene. Ca¹dsi¹lé²dsa jøa³juøi² Antioquía jøng². Dsa² héi² báh³ ca¹heh¹ dsa² tsa¹lán¹² judío jǿg³ quiah¹² Jesús, Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mi³quianh¹³dsa Juu¹³ jniang³. Jøng² jue¹² dsa² ca¹jéinh¹ dsǿa¹². Ca¹hé¹dsa jǿg³ quiah¹² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mi³ca¹lø¹ŋi¹² dsa² quián¹² Jesús chian² Jerusalén jǿg³ jøng², ca¹tse¹dsa Bernabé juu¹² juøi² Antioquía. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jøng² hioh¹² jenh¹² Bernabé mi³ca¹dsiég¹dsa. Di³ jái¹²dsa ma²ca¹jmo¹ Diú¹³ dsio¹ dsǿa¹² ja³cog² dsa² tiogh³ ja³jøng². Jøng² ca¹togh¹² Bernabé dsa² héi² jǿg³. Ca¹juúh²dsa: ―Cøng² jmó³ jniang³ dsǿa¹². Ca¹lah¹ma¹tiagh³ jøng² báh³ jniang³ quianh¹³ Juu¹³ jniang³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Dsa² dsiog¹ báh³ Bernabé. Hé²dsa ca¹lah¹jǿ¹ dsǿa¹²dsa jǿg³ juúh² jmi²dsí² han¹³ quiah¹² Diú¹³. Jøng² jue¹² dsa² ca¹lø¹quianh¹³ Juu¹³ jniang³ mi³ca¹nǿng²dsa jǿg³ ca¹juúh² Bernabé. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jøng² ca¹ŋó¹ Bernabé juu¹² juøi² Tarso. Ca¹ŋi³hniah²dsa Saulo. Mi³ca¹dsagh²dsa, ca¹tai¹dsa juu¹² Antioquía. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ja³jøng² ca¹jŋi¹ ta³og¹dsa cøng² ŋi² jmai³. Ca¹túgh²dsa quianh¹³ dsa² quián¹² Jesús. Ca¹heh¹dsa dsa² jue¹² jǿg³. Jøa³juøi² Antioquía jøng² báh³ lah¹ni³ ca¹lø¹tsén¹ dsa² quianh¹³ Jesús cristianos. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jmai³ jøng² ca¹dsi¹lé² ca²dsiog³ dsa² hǿ² jǿg³ quiah¹² Diú¹³ jøa³juøi² Antioquía, dsa² ca¹ja¹lé² jøa³juøi² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jøng² jan² dsa² héi² tsen² Agabo ca¹hǿ² jǿg³ ca¹he¹ jmi²dsí² quiah¹² Diú¹³, hi² já¹² hag³cón³ ta³cøng² jmøi¹guǿi¹. Jøng² ca¹løa¹ lah¹jøng² jmai³ ma²lán¹² Claudio rai¹³ jøa³juøi² Roma. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jøng² ca¹jmo¹ dsa² quianh¹³ Jesús jǿg³ hi² cuø¹dsa he² ca²juuh³ hi² chi² quiah¹²dsa, ha²cónh¹ hi² tiúh¹dsa cuø¹dsa lah¹jan² lah¹jan²dsa. Jøng² dsiánh²dsa juu¹² ja³tiogh³ dsa² roh¹³ jniang³ ja³tén¹² Judea. ");
INSERT INTO cpaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jøng² ca¹jmo¹dsa lah¹jøng². Ca¹dsiánh²dsa hi² jøng² ni³ dsa² canh¹³ quián¹² dsa² quián¹² Jesús tiogh³ Judea. Ca¹ŋi³cang² Bernabé quianh¹³ Saulo. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jmai³ jøng² ca¹jmóh¹ rai¹³ Herodes ca²dsiog³ dsa² quián¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ca¹jmo¹dsa jǿg³ ca¹jŋë́h¹ dsa² quianh³dsa Jacobo, ŋiú³ Juan. Ca¹jŋaih¹dsa quianh¹³ ŋí³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jøng² mi³ca¹jái¹ Herodes hi² tøa¹² dsǿa¹² dsa² judío hi² ca¹jmo¹dsa lah¹jøng², ca¹jmo¹dsa jǿg³ chiánh²dsa Pedro. Ca¹chiángh²dsa jmai³ juøh¹² gøah¹² dsa² judío hi³ŋíh¹ tsa¹quianh¹³ chiúh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jøng² mi³ca¹chiángh²dsa, ca¹tangh¹² Herodes hni¹ŋí³. Quiún² tséh¹ hlég², ma¹quión²dsa lah¹cu²tséh¹dsa, dsa² ca¹jmo¹ hí³ Pedro ja³hiúg³dsa hni¹ŋí³. Lë́² Herodes mi³dsen²dsa Pedro ja³ta¹ni¹ dsa² juøi² na³ma²ca¹ŋǿ² jmai³ ta²høa³. Jmai³ jøng² mi³mi¹rø¹²dsa jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jøng² ca¹hlanh¹ dsa² quián¹² Jesús Diú¹³ ca¹lah¹jǿ¹ dsǿa¹²dsa ni³ huu¹³ quiah¹² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jøng² ja³neng² lah¹hiá¹ mi³dsei¹² Herodes, ma²rø¹güé¹ Pedro jøa³ quiah¹² og¹ hlég². Chi³hŋió²dsa ton¹ cadena. Og¹ hlég² tiogh³ jmo¹² hí³ hag³ hni¹ŋí³ calah. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Cónh¹ tsa¹jŋia¹³ jøng² ca¹dsiég¹ jan² ángel quián¹² Juu¹³ jniang³. Ca¹táih¹ si² dsi²néi². Jøng² ca¹jnáng¹ ángel cog² Pedro. Ca¹ŋiei¹dsa. Jøng² ca¹juúh²dsa: ―¡Hiugh¹² nung²! ―ca¹juúh²dsa. Jøng² ca¹quia¹ cadena la³gug² Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ni³ jøng² ca¹juúh² ángel calah: ―Cu²rø² hŋioh¹² tsǿinh². Tioh¹² løg² táih² ―ca¹juúh²dsa. Jøng² mi³ca¹jmo¹ Pedro lah¹jøng², ca¹juúh² calah ángel: ―Quieih¹² hmøah¹² dsǿ² coh¹³ quiánh². Jøng² dsǿg³ quianh¹³ jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jøng² ca¹ŋó¹ Pedro chi³quë́¹ cah³ ángel. Ca¹lah¹jin³ tsa¹ŋi¹²dsa ¿hi³ dsøg¹²? ho¹ la³lǿ² báh³, hi² jmo¹² ángel. Lë́²dsa chi³jái¹²dsa lah¹cøng² hi² cøa²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jøng² mi³ca¹tsø³jue¹³dsa ton¹ ja³mi³tiogh³ hlég² jmo¹² hí³, ca¹dsi¹lé²dsa hag³ hni¹ŋí³ lǿa¹² ŋí³ ja³huan¹²dsa jøa³cai³¹. Jøng² ca¹ná² hag³ hni¹ŋí³ cu³hŋiah¹². Ca¹huanh¹²dsa. Mi³ca¹ŋi¹lé²dsa cøng² jøa³cai³¹, ca¹tiúg² ángel Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jøng² ca¹lø¹lih¹³ Pedro. Ca¹juúh²dsa cu³hŋiah¹²dsa: ―Na¹ jín³ ca¹lø¹léi¹³jni. Na²tse¹ Juu¹³ jniang³ jan² ángel quián¹²dsa, dsa² na²lég² jní². Jøng² ha¹chi² ma²jéin¹³jni hi² mi³jmógh² Herodes, hi² lë́² dsa² judío hi² mi³dsa¹ŋë́² jní² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mi³ca¹lø¹lih¹³ Pedro, ca¹ŋó¹dsa juu¹² ja³quiah¹³ María, mi³chiég³ Juan, dsa² tsen² Marcos calah. Ja³jøng² tiogh³ dsa² jue¹². Chi³hlanh¹²dsa Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Jøng² mi³ca¹tøa¹ Pedro hag³jnǿ³ tsih¹² ja³dsi¹², ca¹ŋi¹jái² jan² tsih² mǿ² jmo¹² ta³ dsi²néi², tsih² tsen² Rode. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Jøng² mi³ca¹lø¹cuuh¹² tsih² mǿ² héi² hag³ Pedro, ta³lah¹ca¹ŋáh¹ tsih² juu¹² dsi²néi². Hioh¹² jenh¹²tsih. Ca¹ŋi¹hǿ¹tsih jǿg³ ma²tsenh¹² Pedro ja³dsi¹². Cu¹dsie¹² tsa¹dsagh² dsǿa¹²tsih mi³ní¹dsa hag³jnǿ³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jøng² ca¹juúh² dsa² tiogh³ dsi²néi² mi³ca¹nǿng²dsa: ―¿Ho¹ ŋah¹² báh³ hning²? ―ca¹juúh²dsa. Jøng² ca¹juúh² tsih² mǿ²: ―Lah¹dsóh² ma²guøn¹² báh³ Pedro ―ca¹juúh²tsih. Tiog¹³ báh³ ca¹juúh² dsa² tiogh³: ―A¹jáng¹ hŋiah¹² Pedro héi². Ángel jmo¹² hí³ báh³ dsa² héi² ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lah¹ma²tsenh¹² jøng² báh³ Pedro tǿ²dsa. Jøng² mi³ca¹ní¹dsa jnǿ³, ca¹jë́²dsa Pedro. Jøng² ca¹lø¹dsogh¹² dsǿa¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Jøng² ca¹jmo¹ Pedro quianh¹³ gug² hi² tsa¹ma¹tógh¹dsa møah¹³. Ni³ jøng² ca¹dsii¹dsa jǿg³ ha²lah ma²na²jmo¹ Juu¹³ jniang³, hi² ma²na²lég²dsa hni¹ŋí³. Jøng² ca¹juúh² Pedro: ―Gu³tseih³ hniah¹² Jacobo quianh¹³ dsa² roh¹³ jniang³ ―ca¹juúh²dsa. Ni³ jøng² ca¹ŋó¹ Pedro ja³siíh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mi³ca¹jni¹ jøng², ca¹túgh² hlég² cu²møah¹³. Di³ tsa¹ŋi¹²dsa ha² juu¹² ca¹ŋó¹ Pedro. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jøng² ca¹jmo¹ Herodes héh¹ dsa¹hniah²dsa Pedro. Ha¹chian² dsa² ca¹dsanh²dsa. Jøng² mi³ca¹ŋǿh¹ Herodes hlég² mi³jmo¹² hí³ Pedro hni¹ŋí³, ca¹jmo¹dsa héh¹ hi² dsián¹ hlég² héi². Ni³ jøng² ca¹u¹hái¹ Herodes Judea. Ca¹ŋi³guu¹²dsa jøa³juøi² Cesarea. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jøng² hian¹³ hlaih¹³ rai¹³ Herodes dsa² chian² juøi² Tiro quianh¹³ juøi² Sidón. Jøng² ca¹túgh² dsa² ton¹ juøi² héi² cøng² jǿg³ ja³ta¹ni¹ rai¹³, mi³ma²ca¹mi¹quianh¹³dsa Blasto, dsa² mi²ti¹ ni³ rai¹³. Jøng² ca¹møa¹dsa hi² li¹rø² jǿg³. Di³ ja³jøng² báh³ ja²li² hi² cøgh² gøah¹² dsa² ton¹ juøi² héi², huø¹ ja³jmo¹² rai¹³ héh¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jøng² ca¹jmo¹ rai¹³ Herodes jǿg³ he² jmai³ hi² ji¹lé²dsa calah. Jmai³ jøng² ca¹cáih¹ rai¹³ tsǿnh³ jláh³ ju³lah caih¹² rai¹³ canh¹³. Jøng² mi³ca¹dsi¹lé² dsa² héi², ca¹gú² rai¹³ ni³ hma²sai³¹ jláh³ quiah¹², ca¹téng²dsa cøng² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ni³ jøng² tí² hlaih¹³ ca¹hløah¹ dsa² jue¹². Ca¹juúh²dsa: ―¡Héi¹ dsa² jmøi¹guǿi¹ ná¹² hløah¹²! ¡Diú¹³ báh³ ná¹²! ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dsø¹juu¹² jøng² ca¹jmóh¹ jan² ángel quián¹² Juu¹³ jniang³ Herodes. Di³ tsa¹ca¹juúh² Herodes hŋiah¹² báh³ Diú¹³ lán¹² dsa² juanh¹². Jøng² ca¹jian¹ Herodes jah³. Ca¹jon¹dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Jøng² ca¹tsø² ca¹jan¹ jǿg³ quiah¹² Juu¹³ jniang³. Ca¹ŋi¹jué² dsa² hé² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jøng² mi³ca¹tug¹² Bernabé quianh¹³ Saulo ta³ hi² ca¹dsiúh¹dsa hi² ca¹cuø¹ dsa² chian² Antioquía, ca¹huanh¹²dsa jøa³juøi² Jerusalén. Ca¹ŋi¹lia¹dsa calah. Ca¹tai¹dsa Juan, dsa² tsen² Marcos calah. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mi³tiogh³ dsa² hǿ² jǿg³ quiah¹² Diú¹³ jøa³juøi² Antioquía, dsa² heh¹² dsa² quián¹² Jesús jǿg³: Ju³lah Bernabé, quianh¹³ Simón, dsa² tǿh²dsa Negro calah, quianh¹³ Lucio, dsa² chian² Cirene, quianh¹³ Manaén, dsa² mi³guǿ¹³ ja³quiah¹³ dsi³máh² Herodes, quianh¹³ Saulo. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mi³ma²jmo¹² dsa² héi² hi² tsa¹gøah¹²dsa hi² mi²han¹²dsa ni³ huu¹³ quiah¹² Juu¹³ jniang³, jøng² ca¹juúh² jmi²dsí² han¹³ quiah¹² Diú¹³, ca¹tsáih¹dsa dsa² héi²: ―Jëh¹³ hniah¹² Bernabé quianh¹³ Saulo quian¹ jní². Di³ ma²ca¹jái¹jni cøng² ta³ hi² hno¹jni dsa¹jmó²dsa ―ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jøng² ca¹hlanh¹ dsa² héi² Diú¹³ calah. Ca¹jmo¹dsa hi³méh¹ hi² tsa¹gøah¹²dsa. Ni³ jøng² ca¹quieg² dsa² úg² héi² gug² ni³ quiah¹² Bernabé quianh¹³ Saulo. Ca¹hlanh¹dsa Diú¹³ ni³ huu¹³ quiah¹²dsa. Jøng² ca¹haih²dsa dsa² jǿg³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jøng² ca¹ŋi¹lé² Bernabé quianh¹³ Saulo. Ca¹tsei¹ jmi²dsí² han¹³ quiah¹² Diú¹³. Mi³ca¹dsi¹lé²dsa Seleucia, jøng² ca¹túgh²dsa barco. Ca¹ŋi¹lé²dsa juu¹² Chipre. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jøng² mi³ca¹dsi¹lé²dsa jøa³juøi² Salamina, ca¹he¹dsa jǿg³ quiah¹² Diú¹³ guøh¹² quiah¹² dsa² judío. Quianh¹³ dsa² héi² Juan calah, dsa² ca¹mi³hag¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jøng² ca¹ŋi¹lé²dsa ta³cøng² huø¹ Chipre, huø¹ neng¹² dsi²jo² jmø³ŋih¹³. Ca¹dsi¹lé²dsa jøa³juøi² Pafos. Ja³jøng² ca¹jén²dsa jan² dsa² judío, dsa² tsen² Barjesús, dsa² dsi¹² jǿg³ hi² mi²gan²dsa dsa². Jmo¹²dsa hǿ²dsa jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jøng² hiúg³ dsa² héi² quianh¹³ dsi³máh² tsen² Sergio Paulo, jan² dsa² huø³ dsi³. Jøng² ca¹tǿh¹ dsi³máh² Bernabé quianh¹³ Saulo. Hniu¹dsa nang¹dsa jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jøng² tsa¹hiug² dsǿa¹² dsa² dsi¹² jǿg³ héi², dsa² tǿh²dsa calah Elimas. Di³ lah¹jøng² tǿh²dsa dsa² dsi¹² jǿg³. Mi³mi²gan² dsa² héi² dsǿa¹² dsi³máh². Tsa¹hniu¹dsa hé² dsi³máh² jǿg³ quiah¹² Jesús. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jøng² Saulo, dsa² tǿh²dsa calah Pablo, quin¹²dsa jmi²dsí² quiah¹² Diú¹³ ca¹lah¹jǿ¹ dsǿa¹²dsa. Jøng² tí² ca¹jái¹dsa ni³ Elimas. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ca¹juúh²dsa: ―Hning², dsa² mi²ganh¹³ dsa², dsa² ue¹² hoh¹², dsa² quianh¹³ dsa² hlanh³ báh³ hning². Hianh³hning ca¹lah¹jǿ¹ jǿg³ dsio¹. ¿He² løa¹ tiog¹³ jnëh¹³hning jǿg³ dsio¹ quiah¹² Juu¹³ jniang³? ");
INSERT INTO cpaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jøng² he¹ Juu¹³ jniang³ ju²lih¹³ dsøa¹². Li¹tiugh³hning. Lé² cu²hna² tsa¹lé² janh³hning hieg² ―ca¹juúh² Pablo. Dsø¹juu¹² jøng² ca¹neng² ni³ Elimas. Ca¹lø¹tiug³dsa. Jøng² ca¹hnah²dsa dsa² quianh¹³ gug²dsa, dsa² ŋi¹jiag¹³. Di³ tsa¹ma¹jniuh¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jøng² mi³ca¹jái¹ dsi³máh² lah¹jøng², ca¹hé¹dsa jǿg³. Ca¹lø¹dsogh¹² dsǿa¹²dsa jǿg³ quiah¹² Juu¹³ jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jøng² ca¹huan¹² Pablo quianh¹³ dsa² quianh³dsa juøi² Pafos. Ca¹ŋi¹lé²dsa juu¹² barco. Jøng² mi³ca¹dsi¹lé²dsa Perge, juøi² tén¹² Panfilia, ca¹tég² Juan. Ca¹ŋáh¹dsa juu¹² Jerusalén. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jøng² mi³ca¹huanh¹²dsa Perge, ca¹dsi¹lé²dsa Antioquía, juøi² tén¹² Pisidia. Ja³jøng² ca¹ŋi¹lé²dsa guøh¹² quiah¹² dsa² judío jmai³ sa³¹. Jøng² ca¹túgh²dsa mi³ca¹ŋë́²dsa dsi²néi² guøh¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jøng² mi³ca¹hǿ² dsa² si² lei¹³ quiah¹² Diú¹³, quianh¹³ si² ca¹jmo¹ dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³, jøng² ca¹tse¹ dsa² ta³ quián¹² guøh¹² jǿg³ ni³ Pablo quianh¹³ dsa² quianh³dsa. Ca¹juúh²dsa: ―Hniah¹², dsa² go² jniang³, lé² báh³ juúh³ hniah¹² chi²júh² chi² jǿg³ mi³juaih¹³ hniah¹² jnieh³ ―ca¹juúh²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jøng² ca¹nung² Pablo. Ca¹jmo¹dsa quianh¹³ gug²dsa hi² tsa¹ma¹tógh¹dsa møah¹³. Jøng² ca¹juúh²dsa: ―Hniah¹² dsa² israel, quianh¹³ hniah¹² dsa² siáh², dsa² mi²juanh¹³ Diú¹³, neng² di³ hniah¹² jǿg³ quieg¹jni. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Diú¹³ quián² jniang³, dsa² israel, Diú¹³ héi² báh³ ca¹hia¹ dsa² hóg¹ quián² jniang³. Diú¹³ héi² báh³ ca¹jmo¹ ca¹ŋi¹jué²dsa jmai³ mi³tiogh³dsa huø¹ Egipto. Dsa² héi² báh³ ca¹cuø¹ bí², ca¹ŋi¹jiag¹ ja¹ca¹huanh¹² dsa² hóg¹ ja³jøng². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jøng² ton¹lág¹ ji²ŋi² jmai³ ca¹mi¹juanh¹² Diú¹³ dsǿa¹² ja³cog² dsa² hóg¹, ja³ca¹ŋi³nio³dsa ja³tsa¹chian² dsa² tiogh³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jøng² mi³ca¹jmo¹ Diú¹³ ca¹dsan¹ guio¹ juøi² dsa², dsa² mi³tiogh³ huø¹ Canaán, jøng² ca¹cuúh¹dsa dsa² hóg¹ quián² jniang³ huø¹ jøng², ");
INSERT INTO cpaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ja³ca¹túgh²dsa cónh¹ quiún² ŋi²lǿg² rø²dsǿ² ton¹lug¹guí² ji²ŋi² jmai³. Jøng² ca¹lø¹chián¹ jue¹² jue¹³, dsa² ca¹hei¹ Diú¹³. Ca¹lán¹ dsa² héi² ta³ ca¹lah¹ca¹tǿ² jmai³ ja³ca¹lø¹chián¹ hlai³ Samuel, dsa² ca¹hǿ² jǿg³ quiah¹² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jøng² mi³ca¹møa¹ dsa² hóg¹ hi² li¹chian² rai¹³ quián¹²dsa, ca¹cuan¹ Diú¹³ Saúl, ja³ŋiúh³ Cis, tsø³jong¹³ hlai³ Benjamín. Ton¹lág¹ ji²ŋi² jmai³ lán¹² Saúl rai¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jøng² ca¹jŋíh² Diú¹³ ta³ lán¹² Saúl. Ca¹jmo¹dsa ca¹lán¹ David, ja³ŋiúh³ Isaí, rai¹³ quián¹² dsa² hóg¹. Ca¹juúh² Diú¹³: “Léi¹³jni lán¹² David dsa² lǿa¹² dsøá¹² ju³lah lǿa¹² dsøa¹ jní². Jmo¹dsa ca¹lah¹jǿ¹ hi² hno¹jni,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jøng² ma²ca¹cuúh¹ Diú¹³ jniang³ dsa² Israel cøng² tsø³jon² quiah¹² hlai³ David héi², ju³lah jǿg³ ca¹jmo¹dsa lah¹jiá¹². Ma²ca¹cuan¹dsa Jesús, dsa² lég² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jøng² niúh¹ jín³ hi² ca¹ŋøa¹ Jesús, ca¹téng² Juan jǿg³ hi² jéinh¹ dsǿa¹² jniang³, ca¹lah¹jái¹ jniang² dsa² israel. Jøng² tsóg¹ jniang³ jmøi². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jøng² ca¹juúh² Juan mi³ja¹quien¹³ tiug¹²dsa ta³: “Héi¹ jní² dsa² héi², chi²júh² lë́h² hniah¹² jní² dsa² chi³janh¹³ hniah¹². Di³ na¹ bíh³ jí¹ jan² dsa² hiug¹² juanh¹² jín³ cónh¹ jní², dsa² jín³ tsa¹ta³tén¹³jni tsøah³jni løg² dsǿ² tai³dsa,” ca¹juúh² Juan. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Hniah¹² dsa² go² jniang³, tsø³jon² quiah¹² hlai³ Abraham, quianh¹³ hniah¹² dsa² siáh², dsa² mi²juanh¹³ Diú¹³, jǿg³ quián² jniang³ báh³ jøng² ma²chi², hi² liúg² jniang³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Di³ tsa¹ca¹lø¹ŋi¹² dsa² chian² jøa³juøi² Jerusalén, quianh¹³ dsa² ta³ quián¹²dsa, hein² dsa² Jesús. Tsa¹ca¹lø¹ŋë́h² dsǿa¹²dsa jǿg³ lǿa¹² ni³ si² quiah¹² Diú¹³, si² hǿ²dsa lah¹cøng² lah¹cøng² jmai³ sa³¹. Jǿg³ tsa¹ŋë́²dsa jøng² báh³ ca¹mi¹ti¹ dsa² héi², hi² ca¹cuúh¹dsa Jesús dsag³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ha¹chi² hi² lǿa¹² tsa¹ca¹dsóh²dsa dsag³ hi² mi³jón² Jesús. Tiog¹³ báh³ ca¹møa¹dsa hi² jmo¹ Pilato héh¹ hi² jón²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jøng² mi³ca¹lø¹ti¹ ca¹lah¹jǿ¹ jǿg³ ma²lǿa¹² ni³ si² quiah¹² Jesús, ca¹siúg²dsa hlai³ Jesús mi³ton¹² crǿg¹³. Jøng² ca¹ŋi³hag³dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Cónh¹jøng² ca¹hiog² Jesús calah, ca¹jmo¹ Diú¹³ juanh¹². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ni³ jøng² hliú² jmai³ ca¹jnia¹ Jesús, ca¹jǿi² dsa² chian² Galilea, dsa² ma²ca¹ja¹lé² juu¹² Jerusalén quianh¹³dsa. Dsa² héi² báh³ ma²tsih¹² jǿg³ dsøg¹² quiah¹² Jesús ni³ ca¹lah¹já¹ dsa². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Hi² jøng² jǿg³ dsio¹ quin³ jnieh³. Di³ ma²ca¹lø¹ti¹ jǿg³ ca¹jmo¹ Diú¹³ quianh¹³ dsa² hóg¹. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Quián² jniang³ báh³ ca¹mi¹ti¹ Diú¹³ jǿg³, jniang³ dsa² tsø³jon² quiah¹² dsa² hóg¹. Di³ ca¹jmo¹dsa ca¹hiog² Jesús, ju³lah lǿa¹² ni³ si² Salmos ja³ma²ton¹: “Hning² báh³ jon¹jni. Na¹ jín³ ma²na²hia¹jni hning² hi² jmóh³hning ta³ quieg¹jni,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ca¹jmo¹ báh³ Diú¹³ ca¹hiog² Jesús. Mi³jøng² tsa¹ma¹dsa¹hén² quiah¹²dsa. Di³ lah¹la² ca¹juúh² Diú¹³ lah¹jiá¹²: “Lah¹dsóh² cuǿ¹³jni hniah¹² ju³lah jǿg³ dsio¹ ca¹jmo¹jni quianh¹³ David,” ca¹juúh² Diú¹³. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jø¹² bíh³ lah¹la² lǿa¹² ni³ si² Salmos siíh² calah: “Tsa¹cuúh³hning dsa¹hén² jmø²ŋǿ¹² quieg¹jni, jní² dsa² dsiog¹ quiánh²hning,” rø²juúh² si². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jøng² ca¹jon¹ báh³ David mi³ca¹mi¹ti¹dsa jǿg³ ca¹juúh² Diú¹³ hi² jmo¹dsa ja³cog² dsa² jmøi¹guǿi¹ jian¹²dsa. Jøng² ca¹ŋi³hag³dsa ju³lah ni³hog¹² dsa² canh¹³ quián¹²dsa. Ca¹hen¹ báh³ jmø²ŋǿ¹² quiah¹²dsa. ");
INSERT INTO cpaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jøng² ha¹chi² ca¹hen¹ jmø²ŋǿ¹² quiah¹² dsa² ca¹jmo¹ Diú¹³ ca¹hiog² héi². ");
INSERT INTO cpaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Hi² jøng² ju³li¹ŋih³ hniah¹² dsa² go² jniang³. Ca¹jmo¹ Jesús ma²chi² ju²hén² dsag³. Jǿg³ jøng² báh³ tseih¹³ jnieh³ hniah¹². ");
INSERT INTO cpaNT_vpl V