﻿USE sofia;
DROP TABLE IF EXISTS sofia.cou_vpl;
CREATE TABLE cou_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cou_vpl WRITE;
INSERT INTO cou_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ante pëgwëko W̃ën ntind viỹë ŋa, ambin ŋa g'inkal iŋa ntiko ten. ");
INSERT INTO cou_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hara ɗuniỹa ỹi ki fo nkeyarëko do ñoñ gelohna hnam. Hn'ile nkeho w̃ënka watëw̃ah hna umëhwëry cankaf yeho do iƴir W̃ënu ŋa, le yeho had sël, cëpëko w̃ënka watac. ");
INSERT INTO cou_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Awa W̃ënu ŋa më ntehnëk: «Araɓi humpen ha nke!» Do humpen ha nkelehn. ");
INSERT INTO cou_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","W̃ënu ŋa njëkëko do nëŋëkawo gë hutac; më pitëndëlehnëk humpen ha g'umëhwëry uŋa. ");
INSERT INTO cou_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","W̃ënu ŋa më macëk humpen ha «fac» do mëhwëry uŋa «umëɗ». Nkeho umëɗ, tac gë fac; fac ryënkwëryënkw ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","W̃ënu ŋa më mbok ntehnëk: «Araɓi igwac nke fagant w̃ënka hna, pitëlahn w̃ënka ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Do koyëna nkeho. W̃ënu ŋa koyëna ntiko igwac nte fitëndëlehnëk w̃ënka waɓë gëɗ ŋa gë waɓë g'ambin ŋa. ");
INSERT INTO cou_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","W̃ënu ŋa më macëk igwac tac «ambin». Nkelehn umëɗ, tac gë fac; fac higëna ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","W̃ënu ŋa më mbok ntehnëk kat: «Araɓi w̃ënka wante sëpëk ambin ŋi mbarëpël sëñ ryampo fo nkehahn nkal iŋa!» Do koyëna nkeho. ");
INSERT INTO cou_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","W̃ënu ŋa më macëk hn'ile nkok gena w̃ënka hna «nkal» do w̃ënka wante varëpëlëk ŋa «wov». Njëkëko do nëŋëkawo gë rac. ");
INSERT INTO cou_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Do W̃ënu ŋa më ntehnëk: «Araɓi hnë nkal hna pëhn ile hwëhnak yaryef, vile lëw̃ëɗ uhnëɗa lëw̃u do gë vatëh vante lëw̃ëɗ wadëwel wadëw̃u ŋa dënk!» Do koyëna nkeho. ");
INSERT INTO cou_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nkal iŋa pëhnëndanëko fop sifa vile hwëhnak yaryef va le-wo-le sifa uhnëɗa lëw̃u w̃a ntëw̃ëko do gë vatëh vante lëw̃ëɗ wadëwel wadëw̃u ŋa dënk. W̃ënu ŋa njëkëko do nëŋëkawo gë rac. ");
INSERT INTO cou_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nkeho umëɗ, tac gë fac; fac rarëna ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","W̃ënu ŋa më mbok ntehnëk kat: «Araɓi ambin hna nke wahumpen pitëndëlehnahni fac ỹa gë umëhwëry uŋa; do nkehahn wëdahëse vambënt va, gë wafac w̃a do gë wabëhn ŋa. ");
INSERT INTO cou_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Araɓi nke ambin hna wahumpen pëtënahn nkal iŋa!» Do koyëna nkeho. ");
INSERT INTO cou_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","W̃ënu ŋa ntiko wahumpen wahi wasankaf: hunte ỹako naỹ ha, ulav w̃a yeho, soŋe fac ỹa, do hunte vako ha, lepera w̃a yeho, soŋe mëɗ uŋa. Ntiko fëna wahol w̃a. ");
INSERT INTO cou_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","W̃ënu ŋa g'ambin kwëtëko soŋe pëtënënd nkal iŋa, ");
INSERT INTO cou_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","soŋe fac ỹa g'umëɗ uŋa do pitëndëlehn humpen ha gë umëhwëry uŋa. W̃ënu ŋa njëkëko do nëŋëkawo gë rac. ");
INSERT INTO cou_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nkeho umëɗ, tac gë fac; fac hnahëna ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","W̃ënu ŋa më mbok ntehnëk kat: «Araɓi sifa viỹë fop pëɓëni wov hna, do wusëry w̃a nkwayëndëni g'ambin, cëpëni nkal iŋi!» ");
INSERT INTO cou_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","W̃ënu ŋa ntikëhniwo wulaw̃ wësankaf wavë wov do gë fop sifa vile fëɓëk do yasëlehnëɗ hnë w̃ënka hna. Ntikëhniwo fëna sifa wusëry w̃a fop. W̃ënu ŋa njëkëko do nëŋëkawo gë rac. ");
INSERT INTO cou_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","W̃ënu ŋa më ndëwakëhni ntehnëhni: «Araɓi fop vile ye w̃ënka vi nagëlëni, njaɓëni, pëɓëni wov hna do araɓi wusëry w̃a fëna njaɓëni nkal li.» ");
INSERT INTO cou_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nkeho umëɗ, tac gë fac; fac vëryëna ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","W̃ënu ŋa më mbok ntehnëk kat: «Araɓi nkeni nkal li wasifa w̃a fop: wusaw̃, gë wulaw̃ do gë fop vihaw̃ary vile yasëɗ nkal li! Do koyëna nkeho.» ");
INSERT INTO cou_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Koyëna ntikëhniwo W̃ënu ŋa wasifa wulaw̃ gë wusaw̃, gë wulaw̃ wuhnëmpëlah w̃a do gë fop vihaw̃ary vile yasëɗ nkal li. W̃ënu ŋa njëkëko do nëŋëkawo gë rac. ");
INSERT INTO cou_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tac W̃ënu ŋa më mbok ntehnëk rëkwa ỹa: «Dinëfuni vahnë mëntëlin gë fuhnë, mëntëlin ɗus! Kwëhnënihëhni wuwis wavë wov w̃i, gë wusëry wavë g'ambin w̃i, do gë wusaw̃ gë wulaw̃ do gë fop vihaw̃ary vile yasëɗ nkal li.» ");
INSERT INTO cou_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Awa W̃ënu ŋa ntikëhni vahnë va mëntëlëni g'umë dënk; ntikëhni asan g'asëval. ");
INSERT INTO cou_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tac më ndëwakëhni ntehnëhni: «Nagëlëryin, ƴaɓëryin, pëɓëryin nkal li, naw̃ëryin nkal li; kwëhnëryinëhni wuwis wavë wov w̃i, gë wusëry wavë g'ambin w̃i do gë fop vile yasëɗ nkal vi.» ");
INSERT INTO cou_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ntehnëkëhniwo fëna: «Njëɗamu arokëndu wanëɗa wante lëw̃ëɗ nkal ŋi fop do gë vatëh vante lëw̃ëɗ vi fop. ");
INSERT INTO cou_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Wulaw̃ w̃i fop vëhni njëɗaɓuhëhni tokëndëni dël iŋi gë wusaw̃ wavë nkal w̃i fop, gë wusëry w̃i fop, do gë fop vihaw̃ary vile yasëɗ nkal li.» Do koyëna nkeho. ");
INSERT INTO cou_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","W̃ënu ŋa njëkëko fop ile ntiko ỹa do nëŋëkawo ɗus gë rac. Nkeho umëɗ, tac gë fac; fac hwëhn mbëɗ gë ryaw̃ ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Koyëna puhnako W̃ënu ŋa idi ambin ŋa gë ɗuniỹa ỹi do gë fop ile yehëhna hnam ỹa. ");
INSERT INTO cou_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ga tëkëk hnë fac hwëhn mbëɗ gë wahi hna, kamahnëko ɗoku lëw̃u ỹa puk do tiw̃ako. Awa hnë fac hwëhn mbëɗ gë wahi hna tiw̃ako. ");
INSERT INTO cou_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Më ntik fac hwëhn mbëɗ gë wahi rac fac ryëwayik, do nti fac ile riw̃ahnëɗe, kaɓi hnë fac rac tiw̃ako hnë waɗoku wante ntiɗëho hna fop. ");
INSERT INTO cou_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Koyëna ntiko W̃ënu ŋa ambin ŋa gë ɗuniỹa ỹi. Ante ntiko Ahwëhn a W̃ënu ŋa ambin ŋa gë ɗuniỹa ỹi, ");
INSERT INTO cou_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","vatëh g'idël gelohna ten nkal li, do wanëɗa pëhnëlohna ten, kaɓi Ahwëhn a W̃ënu ŋa cañëtilohna ten rëv ỹa nkal li, do vahnë vëyelohna soŋe njamëni nkal iŋi. ");
INSERT INTO cou_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ɓare le ye had fampul sahnëɗëho nkal hna do turëɗëho nkal iŋa fop. ");
INSERT INTO cou_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ahwëhn a W̃ënu ŋa më nufëk nkal do ñahanëka asan. Tac më cëlëka wasëhn hna sël paryi ỹa, uwám w̃a, do asan arac nkelehn ale yënëɗ. ");
INSERT INTO cou_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tac, Ahwëhn a W̃ënu ŋa më pëlëk sarëɗiŋ hnë Eden hna, gë cape pëhna lav ka, do kwëta hnam asan ale ñahanëko ỹa. ");
INSERT INTO cou_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Më pëhnëndanëk sifa vatëh vankwamah njëki va fop do vante hnëŋëk toki. Më pëlëk fagant atëh nte yëɗahnëɗ uwám ule wok puɗina do g'atëh kaw̃ary nte yëtëndanëɗ ile yivëk g'ile w̃ek ỹa. ");
INSERT INTO cou_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Sën w̃atiɗëho hn'inkal Eden hna turënd sarëɗiŋ ỹa. Pëgw hnam, vunkaryëla vunah pitëlëko. ");
INSERT INTO cou_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Fandënkwëryënkw fa Pison maciko: fatac rënkëko inkal Havila hna. Hn'inkal tac nkeho sanu ỹa, ");
INSERT INTO cou_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","do sanu rac përënako ɗus. Nkeho vatëh vante liɗe ɗatikola do fëna nkeho itaka nte yaɓëka nafa ỹa. ");
INSERT INTO cou_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Fakigëna fa Gihon maciko: inkal Kuc ŋa fop tënkëko. ");
INSERT INTO cou_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Fatarëna fa Saw̃ maciko: fatac yaryëɗëho gë cape pëhna lav g'ankol Asur ka. Do fanahëna fa Efërat maciko. ");
INSERT INTO cou_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Awa Ahwëhn a W̃ënu ŋa më nufëka asan a, kwëta sarëɗiŋ Eden hna soŋe njamënd do njëkand. ");
INSERT INTO cou_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Më ntehnëka aki: «Koɗu arok vatëh vambë sarëɗiŋ vi fop. ");
INSERT INTO cou_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ɓare antë arok atëh ante yëtahnëɗe ile yivëk g'ile w̃ek ỹa, kaɓi hale tokëɗu, cëmëɗu.» ");
INSERT INTO cou_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tac më ntehnëk: «Caŋëna asan a nke umë fo. Ndemaɗëfuha linëhnëw̃a ale caŋëɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Inkal iŋa ñahanëko fop Ahwëhn a W̃ënu ŋa sifa wulaw̃ wuyaɓah do gë wusëry w̃a, tac njiryeryëhni asan hna soŋe njëk arac bi hak macëɗëhëhni. Intaw̃-wo w̃ac le macëɗëhawo asan a yeɗ ulëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Arac më macëkëhni uw̃ac fop wusaw̃ w̃a, gë wusëry w̃a do gë wulaw̃ w̃a. Ɓare asan a nuỹalawohna arëfëlënta ale saŋëɗëha umë dënk. ");
INSERT INTO cou_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Awa Ahwëhn a W̃ënu ŋa më ndakëndanëka asan a wakwëɗ watëw̃ah. Më ntihëtëka uyiy ryampo do mbokarya ndil ŋa gante nkehawo ka. ");
INSERT INTO cou_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Uyiy rac, Ahwëhn a W̃ënu ŋa ntik asëval do njinenëhna asan a. ");
INSERT INTO cou_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Arac ga nuka asëval a më ntehnëk: «Aŋa nkaw̃, wëliho ale ye ỹëc waỹëc mën a, mbahn imbahn mën a! “Asëval” macëɗe, kaɓi asan hna nufik.» ");
INSERT INTO cou_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Soŋe umë ye, asan a tavëɗëhëhni vëhni rëmu gë hnëmu nkeni g'asëvalu fo, do vëhni vëhi tak aryampo fo nkeɗëni. ");
INSERT INTO cou_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Asan a g'asëvalu wëtata fo nkeniho vëhni vëhi tak, ɓare cëfëhnëlëlëhniwohna. ");
INSERT INTO cou_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Awa, hnë fop wulaw̃ wule ntiko Ahwëhn a W̃ënu ŋa, lën ỹa yeho ale ỹak ritëka. Tëƴëkawo asëval a: «Paryi bi ntehnëk W̃ënu ŋa: “Antë aroku vatëh vambë sarëɗiŋ vi fop!”» ");
INSERT INTO cou_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Asëval a më ntëkwaka: «Hali, koɗëfun rokëfu. ");
INSERT INTO cou_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ɓare soŋe atëh nte ye fagant sarëɗiŋ ŋi, W̃ënu ŋa më lehnëk: “Antë aroku do antë aỹaku; ge gena më cëmëɗun!”» ");
INSERT INTO cou_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Awa lën ỹa më ntehnëka asëval a: «Muk! Cëmëɗiluhna! ");
INSERT INTO cou_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","W̃ënu ŋa nësëk umë kaɓi njëtëk, hale tokëɗun, vinkër hun va ŋesëɗ do nkeɗun had Umë dënk: njëtëɗun ile yivëk g'ile w̃ek.» ");
INSERT INTO cou_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Asëval a kamahnëko atëh ŋa nkwamëk njëki do tëfëka nëŋ toki. Ñaɗëho tok nuỹahna uyët. Awa më kwëcëk do tok. Më njëɗaka fëna asanu do umë fëna më tokëk. ");
INSERT INTO cou_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Taŋ piɗëtalehnëhni vinkër va, do kamahnëlehnëni wëtata fo nkeni. Më mbahnëni yaryef atëh nte w̃acik anuỹ ŋa do palani. ");
INSERT INTO cou_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Awa g'anëka ga, më nkwëryëniha Ahwëhn a W̃ënu ŋa, sarëɗiŋ hna njasëlehnëɗëho. Asan a g'asëvalu umë cow̃ani hnë vatëh vamb sarëɗiŋ hna soŋe antë nuhni Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ahwëhn a W̃ënu ŋa më macëka asan a, tëƴa: «Ne nkeru?» ");
INSERT INTO cou_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Më ntëkwak: «Nkwëryakëmi, më ntakëko kaɓi wëtata fo yeɓu. Awa më sow̃aɓu.» ");
INSERT INTO cou_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ahwëhn a W̃ënu ŋa më tëƴëka: «Mo fëƴaki wëtata fo yeru? Tokëru bi atëh nte vañëhnëmino ŋa?» ");
INSERT INTO cou_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Asan a më ntëkwak: «Asëval, ale yëɗaruhow̃a yefu ỹa, umë yëɗako atëh tac, do tokëɓu.» ");
INSERT INTO cou_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Awa Ahwëhn a W̃ënu ŋa më ntehnëka asëval a: «Soŋe ye liru iỹin?» Më ntëkwak: «Lën ỹa tokako, do tokëɓu atëh ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Awa Ahwëhn a W̃ënu ŋa më ntehnëka lën ỹa: «Kaɓi ntiru iỹin, araɓi nkeỹi w̃eh. Hnë wusaw̃ gë wulaw̃ wule ntik W̃ën hna fop, wëjë g'iɗonk hu ŋi rëkëɗu ayasënd do ahohnënd ivëɗ hnë wafac hu hna fop. ");
INSERT INTO cou_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ntiɗëfu takëla yëbëlan hun wëjë g'asëval a, yëbëlan vële nagëɗ va do gë vële hnagëɗu va. Vële nagëɗ asëval a nihëɗënihi nkaf ŋi, do wëjë itak ŋi ỹarëɗuhëhni.» ");
INSERT INTO cou_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tac Ahwëhn a W̃ënu ŋa më ntehnëka asëval a: «Ntiɗëfu horot sankaf hnë waryonk hnag hu hna, rëkëɗu ahorotënd ahnagahnëndëhni vutah hu va. Iña hu ŋa hnë asan hu hna nkeɗ, ɓare umë hwëhnëɗëhi.» ");
INSERT INTO cou_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Awa tac Ahwëhn a W̃ënu ŋa më ntehnëka asan a: «Maw̃ëru wanës asëval hu ŋa do tokëru atëh nte vañëhnëmino ŋa. «Soŋe ile lëntëru ỹi, araɓi nkal iŋi me. Rëkëɗu ahorotënd ɗus ahnuỹahnënd ile rokëɗu ỹa hnë wafac hu hna fop; ");
INSERT INTO cou_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","inkal iŋa pëhnëndanëɗ wadëmpëhn do idël meh. Do tëfëka arok ile fëhnëɗ wëhaỹ hna; ");
INSERT INTO cou_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","gë ŋacëŋac hu ŋa rëkëɗu ahnuỹand ile rokëɗu ỹa, hafo avoka g'inkal nte hnufiko aỹahani ŋa. Kaɓi inkal yeru, do g'inkal mbokaɗu.» ");
INSERT INTO cou_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Asan a Adam maciko do umë Ev macëkawo asëvalu. Umë fëhnëtanëɗ «Uwám» kaɓi umë ye hnëm vahnë ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ahwëhn a W̃ënu ŋa më ntinëhnëkëhni asan a g'asëvalu viỹi waƴand do cuɗahni. ");
INSERT INTO cou_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tac më ntehnëk: «Awa ahn'a had Fuhnë nke: njëtëk ile yivëk g'ile w̃ek. Tame, tëfëka memaỹehni antë tëkën atëh ante yëɗahneɗ uwám usër w̃a; age tokëk, cëmëɗina muk.» ");
INSERT INTO cou_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Awa Ahwëhn a W̃ënu ŋa më ntakëhni sarëɗiŋ vë Eden hna, soŋe njini njamëndëni nkal nte nufiniho do ntiyini ŋa. ");
INSERT INTO cou_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ga ntaka ahn'a sarëɗiŋ vë Eden hna, Ahwëhn a W̃ënu ŋa më kwëtëkëhni gë pëhna lav haryënkw sarëɗiŋ hna wamëleka wade ye vëyëka, (waseruben maciniho). Gë sëlame hwëɗëh ile wërënaɗëho vacape va fop, wamëleka ŋa ankaw̃ ante yihahnëɗe g'atëh ante yëɗahnëɗ uwám usër w̃a njëkaɗëniho. ");
INSERT INTO cou_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam ndakëniho gë Ev, asëvalu; ndonkëko do naga facan fante w̃aciko Kaỹe. Awa Ev më ntehnëk: «G'iɗema Ahwëhn a W̃ënu ŋa nagëɓuha facan.» ");
INSERT INTO cou_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mboko naga fëna Abel, aheryu Kaỹe. Abel ahery wusaw̃ yeho; Kaỹe, umë, ayam yeho. ");
INSERT INTO cou_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Awa, Kaỹe ga mbarëpëk roka le njamëko ỹa, njoko viryampo hnë virac, cënahna Ahwëhn a W̃ënu ŋa saɗëha. ");
INSERT INTO cou_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel, fëna, njonëhnëkawo vupe vunte ryënkwiko nagini hnë ntega ntëw̃u hna, vunte ỹak hniryëk va, cënahnëkawo Ahwëhn a W̃ënu ŋa. Ahwëhn a W̃ënu ŋa kacakawo g'uhnatah Abel gë saɗëha lëw̃u ỹa, ");
INSERT INTO cou_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ɓare ŋwëỹëkawo Kaỹe gë saɗëha lëw̃u per. Soŋe rac Kaỹe ntavëkawo ɗus; ŋañënëko yëka ỹa. ");
INSERT INTO cou_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ahwëhn a W̃ënu ŋa më ntehnëka: «Soŋe ye ntavëki aki, do ỹañënëru yëka ỹi aki? ");
INSERT INTO cou_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ge ntiru gante tëfëka ka, ŋwëỹëɗelihna; ge gena umë, wameh ŋa nke had intaw̃ ŋañah vofëhnëki rënka hu hna. Ñaɗ mëki, ɓare ƴaw̃ëry alëba umë.» ");
INSERT INTO cou_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ɓare Kaỹe më ntehnëka aheryu: «Cahnëfu.» Ga tëkëni kaỹ hna më ntoŋanëka aheryu do ndaw̃a. ");
INSERT INTO cou_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Awa Ahwëhn a W̃ënu ŋa më tëƴëka Kaỹe: «Ne nkeha ahery hu Abel?» Më ntëkwak: «Ƴëtëla. Ami bi yëkaɗëha ahery mën a?» ");
INSERT INTO cou_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ahwëhn a W̃ënu ŋa më mbok ntehnëka: «Soŋe ye liru iỹin? Nkwëryëɗëfu wasat ahery hu w̃a nkal hna had ahnë ryekaɗ; igwëcag tëƴëɗ. ");
INSERT INTO cou_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tame araɓi nkeỹi w̃eh, ntayiru hn'inkal nte sek wasat ahery hu ale ryaw̃ëru ỹa. ");
INSERT INTO cou_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Soŋe umë ye, rëkëɗu ayamënd ɗus, ɓare inkal iŋa ɓokëɗina njëɗayi vetak lëw̃u w̃a. Awërëtalehn fo yeɗu nkal li had ale layik.» ");
INSERT INTO cou_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaỹe më ntehnëka Ahwëhn a W̃ënu ŋa: «Piniŋ mën iŋa ntënëk ɗëcët. ");
INSERT INTO cou_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ntaɗuho dol hn'inkal përën hna, cow̃antaɗëfu ŋaw̃ët hu; Awërëtalehn fo yeɗëfu nkal li had ale layik. Ale-wo-le hnuɗëho ỹa koɗ ndaw̃o.» ");
INSERT INTO cou_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ɓare Ahwëhn a W̃ënu ŋa më ntëkwaka: «Hali, kaɓi ge ahnë ndaw̃ëki, nkwëcanëhnëɗeru wahwënta mbëɗ gë wahi (7).» Awa Ahwëhn a W̃ënu ŋa më ntika Kaỹe dahëse soŋe antë ndaw̃ëniha vële hnuɗëha va. ");
INSERT INTO cou_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Awa koyëna ŋaw̃ëtakawo Kaỹe Ahwëhn a W̃ënu ŋa nji ntëɗ hn'inkal Nod hna, gë cape pëhna lav Eden ka. ");
INSERT INTO cou_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ga ñëlëk, Kaỹe nagënihawo g'asëvalu facan fante w̃aciko Enok. Kaỹe pëgwëko mbëryënd inaw̃ do më macëk naw̃ tac uw̃ac aju w̃a, Enok. ");
INSERT INTO cou_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok yeho rëm Irad ỹa, Irad yeho rëm Mehuyayel ỹa, Mehuyayel yeho rëm Metusayel ỹa, Metusayel yeho rëm Lemëk ỹa. ");
INSERT INTO cou_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemëk vësëval vëhi ñëlëko: aryënkwëryënkw a Ada maciko do ahigëna ỹa Sila. ");
INSERT INTO cou_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yabal nagëko, rëm vële lëɗëko hnë wasank do hwëɗëɗëhëhniwo wusaw̃ w̃a. ");
INSERT INTO cou_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal kwëhnakawo fakery, Yubal maciko, umë yeho rëm fop vërëmp va do gë vësël vëtakëralu va. ");
INSERT INTO cou_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila, umë fëna, nagëkawo facan fante w̃aciko Tubal-Kaỹe. Umë ryëhwarëɗëho sifa viỹë viryokuŋa va fop, waryëhwëra wavëntah gë wëyah w̃a. Tac, Sila mboko naga facëval, ahery Tubal-Kaỹe. Nama maciko. ");
INSERT INTO cou_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemëk më lehnëkëhniwo vësëvalu: «Ada gë Sila, nëparyino, vësëval mën, nëparyino dus: ndaw̃ëɗëfuha asan ge ndafëko, ndaw̃ëɗëfuha fatah ge cërehnëko. ");
INSERT INTO cou_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Age wahwënta mbëɗ gë wahi nkwëcanëhnik Kaỹe, wafëhw mbëɗ gë wahi g'imbëɗ gë vëhi (77) wëcanëhnëɗeɓu ami.» ");
INSERT INTO cou_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam ndakëniho g'asëvalu do mboko nagëniha facan. Ev, Set macëkawo, kaɓi ntehnëɗëho: «W̃ënu ŋa mbok njëɗow̃a facan fakaw̃ary nëmpëtëhnahnow̃a Abel, nte ndaw̃ëk Kaỹe ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set umë fëna nagëhnikawo facan; Enos macëkawo. Hnë ƴamani rac pëgwëniho vahnë va cëmbëndëniha Ahwëhn a W̃ënu ŋa macatëndëniha Ahwëhn. ");
INSERT INTO cou_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Wëlin itëfëta soŋe vutah Adam. Hnë fac le ntikëhniwo W̃ën vahnë hna, ntikëhniwo mëntëlëni g'umë. ");
INSERT INTO cou_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ntikëhniwo asan g'asëval, ndëwakëhniwo do macëhni uw̃ac «vahnë». ");
INSERT INTO cou_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ante nuỹako Adam wabëhn keme gë wafëhw warar (130) ŋa, mboko naga facan fante mëntëlëniho ɗus. Set macëkawo. ");
INSERT INTO cou_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tac Adam mboko nuỹa kat wabëhn wakeme mbëɗ gë watar (800). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë wahnah gë wafëhw warar (930), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ante nuỹako Set wabëhn keme g'imbëɗ (105) ŋa, nagëhnikawo facan fante w̃aciko Enos. ");
INSERT INTO cou_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Tac Set mboko nuỹa wabëhn wakeme mbëɗ gë watar g'imbëɗ gë waki (807). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë wahnah g'ipëhw gë waki (912), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ante nuỹako Enos wabëhn wafëhw mbëɗ gë wahnah ŋa (90), nagëhnikawo facan fante w̃aciko Kenan. ");
INSERT INTO cou_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Tac Enos mboko nuỹa wabëhn wakeme mbëɗ gë watar g'ipëhw g'imbëɗ (815). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë wahnah g'imbëɗ (905), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ante nuỹako Kenan wabëhn wafëhw mbëɗ gë wahi ŋa (70), nagëhnikawo facan fante w̃aciko Malalel. ");
INSERT INTO cou_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Tac Kenan mboko nuỹa wabëhn wakeme imbëɗ gë watar gë wafëhw wahnah (840). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ga nuỹak fop ka ỹa wabëhn wakeme imbëɗ gë wahnah g'ipëhw (910), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ante nuỹako Malalel wabëhn wafëhw mbëɗ gë ryaw̃ g'imbëɗ ŋa (65), nagëhnikawo facan fante w̃aciko Yerëd. ");
INSERT INTO cou_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Tac Malalel mboko nuỹa wabëhn wakeme mbëɗ gë watar gë wafëhw warar (830). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë watar gë wafëhw imbëɗ gë wahnah g'imbëɗ (895), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ante nuỹako Yerëd wabëhn keme gë wafëhw mbëɗ gë ryaw̃ gë waki ŋa (162), nagëhnikawo facan fante w̃aciko Enok. ");
INSERT INTO cou_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Tac Yerëd mboko nuỹa wabëhn wakeme mbëɗ gë watar (800). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë wahnah gë wafëhw mbëɗ gë ryaw̃ gë waki (962), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ante nuỹako Enok wabëhn wafëhw mbëɗ gë ryaw̃ g'imbëɗ ŋa (65), nagëhnikawo facan fante w̃aciko Matusalem. ");
INSERT INTO cou_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tac Enok mboko nuỹa wabëhn wakeme watar (300) do gë W̃ënu ŋa nkeniho. Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Wabëhn wakeme watar gë wafëhw imbëɗ gë ryaw̃ g'imbëɗ (365) nuỹako fop ka ỹa cëmat. ");
INSERT INTO cou_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok gë W̃ënu ŋa nkeniho, tac nambiko, kaɓi W̃ënu ŋa nufëkawo njohna ɗarël lëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ante nuỹako Matusalem wabëhn keme gë wafëhw mbëɗ gë warar g'imbëɗ gë waki ŋa (187), nagëhnikawo facan fante w̃aciko Lemëk. ");
INSERT INTO cou_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Tac Matusalem mboko nuỹa wabëhn wakeme mbëɗ gë waki gë wafëhw mbëɗ gë warar gë waki (782). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë wahnah gë wafëhw mbëɗ gë ryaw̃ g'imbëɗ gë wahnah (969), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ante nuỹako Lemëk wabëhn keme gë wafëhw mbëɗ gë warar gë waki ŋa (182), nagëhnikawo facan. ");
INSERT INTO cou_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nowe macëkawo kaɓi ntehnaɗëho: «Aỹi kamënaỹehnëɗëhëfu hnë waɗoku fu hna, gë horot ule ỹaɗen korotënden ỹa kaɓi Ahwëhn a W̃ënu ŋa menëk nkal iŋa.» ");
INSERT INTO cou_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ga ndëcëk watac, Lemëk mboko nuỹa wabëhn wakeme mbëɗ gë wafëhw mbëɗ gë wahnah g'imbëɗ (595). Nagëhnikëhniwo vucan vukaw̃ary gë vucëval. ");
INSERT INTO cou_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ga nuỹak fop ka ỹa wabëhn wakeme mbëɗ gë waki gë wafëhw mbëɗ gë wahi g'imbëɗ gë waki (777), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ante nuỹako Nowe wabëhn wakeme mbëɗ ŋa (500) tac nagëhnikëhniwo vucan vutar: Sem gë Sam do gë Yafet. ");
INSERT INTO cou_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Awa vahnë va pëgwëniho njaɓëndëni nkal li do kwëhnanihëhniwo vëryag. ");
INSERT INTO cou_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Vijë W̃ën va nuniho vëryag vahnë va nkwamëni, më tëhnanihëhni ñëlënihëhni. ");
INSERT INTO cou_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Awa Ahwëhn a W̃ënu ŋa më ntehnak: «Sël ntaw̃ary le yëɗaɓuhëhni vahnë ỹa goɗina kwëlëkwël hnë vëhni; nkeɗ fac le cëmanhnëɗëni. Tëk pëgw iỹi wati, vëwoɗina ɗuniỹa li ile lëbik wabëhn keme gë wafëhw wahi (120).» ");
INSERT INTO cou_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Hnë wati rac, nkeniho vahnë vëyihnah, vëyaw̃ah do hnënk rac nkoko nkal li hafo mbiỹ. Vëyihnah vërac yeho vutah viju W̃ën va gë vëryag vahnë va; vësan paryi yeho, vësan vëyëtik. ");
INSERT INTO cou_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ahwëhn a W̃ënu ŋa kamahnëko wameh vahnë ŋa g'ahaw̃ary njaɓëɗëho nkal li. Do hnë fac hna fop, nahan dëw̃ hni ŋa, idi wameh fo yeho. ");
INSERT INTO cou_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ahwëhn a W̃ënu ŋa më curak soŋe ile ntikëhni vahnë hn'inkal ỹi, do ntaw̃ary dëw̃u ŋa pëɓëkawo yiw̃ëhnah w̃a. ");
INSERT INTO cou_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Më ntehnëk: «Ntihëtëɗëfuhëhni nkal li vahnë vële ỹahanëɓu vi, vahnë vi, gë wulaw̃ w̃i, gë wusaw̃ w̃i, do gë wusëry w̃i per. Curaɗëfu ɗus soŋe ile liɓuhëhni ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ɓare Ahwëhn a W̃ënu ŋa nëŋëkawo gë Nowe. ");
INSERT INTO cou_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Wëli itëfëta soŋe Nowe ŋa: Nowe vucan vutar kwëhnako: Sem, gë Sam do gë Yafet. Asan asatah yeho gë vëỹëntaw̃ va. Maw̃ëhnëɗëhawo kwëlëkwël W̃ënu ŋa do gë W̃ënu ŋa nkeniho. ");
INSERT INTO cou_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Awa W̃ënu ŋa nuko vahnë va përëkaniho do wameh fo fëɓëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ante njëkëɗëho W̃ënu ŋa ile ryëcëtaɗ ɗuniỹa li ỹa, do nuko përëkako ɗëcët kaɓi vahnë va fop ankaw̃ wameh ŋa tëfëɗëniho, ");
INSERT INTO cou_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","më ntehnëka Nowe: «Pëhnaɓu vëvehnëw̃ëhni vahnë vi fop. Kaɓi soŋe lëw̃ hni ỹa pëɓahnëk wameh ŋa ɗuniỹa li. Ha, ntihëtëɗëfuhëhni. ");
INSERT INTO cou_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Diyary wëjë sisikulu gë waɗëhwa wapërën. Ɓambery ntëpëtëlendu vacery vajaɓah do wakoyel hnëvëɗu për iŋa gë ɓambery per antë tënkënd wënka ŋa. ");
INSERT INTO cou_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Wëli gante ntiɗu ka: tëfëka nuỹa wametër keme gë wafëhw imbëɗ (150) ƴary iŋa, wametër wafëhw wahi g'imbëɗ (25) ƴank iŋa, do wametër pëhw g'imbëɗ (15) iƴihn ŋa. ");
INSERT INTO cou_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Cankëɗu ƴaŋ, do tavëɗu igwac yëbëlan ile sankantu ỹa gë wabëv sisikulu ŋa yëbëlan metër ryampo. Hn'ibëv ɗampo ntiɗu rënka ỹa. Ɓambery sisikulu hna wa-etas watar liɗu. ");
INSERT INTO cou_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Do ami, cañëtëryiɗëfu uw̃ac sankaf, soŋe mbëvehnëhni fop vile yënëɗ va. Fop vile ye nkal va mbëvëɗëni. ");
INSERT INTO cou_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ɓare ntiɓu kwëtëla gë wëjë. Tënkëɗun sisikulu hna, wëjë gë vijë hu, g'asëval hu do gë vësëval vijë hu va. ");
INSERT INTO cou_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ndënëɗuhëhni fëna san g'isëval sifa-wo-sifa hnë vile yënëɗ va, soŋe pehëntini gë wëjë. ");
INSERT INTO cou_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","San g'isëval hnë sifa wulaw̃ hna fop, gë wusëry w̃a do gë wusaw̃ w̃a, do gë fop vihaw̃ary vile yasëɗ njijëɗëni ỹal hu hna soŋe pehëntini. ");
INSERT INTO cou_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Do wëjë, nufëry sifa ile rokëɗe ỹa fop, afehn a. Umë rëkëɗun arokëndu wëjë gë vëhni.» ");
INSERT INTO cou_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowe, gante ntehnëkawo W̃ën ka, fop ntiko. ");
INSERT INTO cou_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Awa Ahwëhn a W̃ënu ŋa më ntehnëka Nowe: «Tënkëryin sisikulu hna, wëjë gë vëvë tere hu va, kaɓi wëjë fo hnuɓu ye ale satëk hnë vahnë vëvë gaki vi. ");
INSERT INTO cou_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nufëryihni wusaw̃ gë wulaw̃ wufacah w̃a, sifa-wo-sifa wusan mbëɗ gë wuhi (7) gë wësëval mbëɗ gë wuhi (7), do g'ican ɗampo g'icëval ɗampo hnë wule wok wafacëna hna. ");
INSERT INTO cou_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nufëryihni fëna wasifa wusëry mbëɗ gë wuhi, soŋe afehëtahn hnënk lëw̃ hni ỹa nkal li. ");
INSERT INTO cou_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ani gë wafac mbëɗ gë wahi, cañëtëryiɗëfu rëv ỹa hnë wafac wafëhw wahnah (40) gë vumëɗ wafëhw wahnah (40); koyëna ntihëtëɗëfu fop vile liɓuho va.» ");
INSERT INTO cou_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowe ntiko fop ile ntehnëkawo Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe wabëhn wakeme mbëɗ gë ryaw̃ (600) kwëhnako ante tëkiko uw̃ac sankaf hn'inkal ŋa. ");
INSERT INTO cou_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tënkëniho sisikulu hna gë viju gë vësëval hni soŋe pehëni w̃ac w̃a. ");
INSERT INTO cou_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Fop njiniho sisikulu Nowe hna: wule ye wufacah w̃a, gë wule wok wafacëna w̃a, gë wusëry w̃a do gë fop vihaw̃ary vile yasëɗ nkal li, ");
INSERT INTO cou_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wuhi wuhi, ican g'icëval; gante ntehnëkawo W̃ën Nowe nti ka. ");
INSERT INTO cou_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ga padëk wafac mbëɗ gë wahi w̃a, uw̃ac sankaf w̃a kohnëko nkal iŋi. ");
INSERT INTO cou_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Bëhn le nuỹahnëko Nowe wabëhn wakeme mbëɗ gë ryaw̃ ŋa (600), hnë lepera higëna hna, hnë fac pëhw g'imbëɗ gë wahi hna (17), wahaƴalin wale ntoŋahniɗëho w̃ënka ŋa fop piɗëtako do wahatëh wale kovahniɗëho w̃ënka rëv ŋa piɗëtako ɗus. ");
INSERT INTO cou_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Rëv ỹa kovaɗëho hnë wafac wafëhw wahnah (40) gë vumëɗ wafëhw wahnah (40). ");
INSERT INTO cou_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hnë fac rac dënk, Nowe tënkëniho sisikulu hna gë viju, Sem gë Sam gë Yafet, do gë vësëval hni per. ");
INSERT INTO cou_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tënkëntiniho fëna sifa wulaw̃ gë wusaw̃ w̃a fop, gë fop vihaw̃ary vile yasëɗ nkal li, do gë sifa wusëry w̃a fop. ");
INSERT INTO cou_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Njijëniho san g'isëval, hnë vile yënëɗ ntiko W̃ën va fop, tënkëntini gë Nowe sisikulu hna. ");
INSERT INTO cou_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","San g'isëval hnë sifa-wo tënkëntiniho, gante ntehnëkawo W̃ën Nowe ka. Tac Ahwëhn a W̃ënu ŋa më piɗëk rënka ỹa hamëhni Nowe. ");
INSERT INTO cou_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Uw̃ac sankaf w̃a, hnë wafac wafëhw wahnah (40) nkwënaɗëho nkal hna. Hnë wati rac kaƴëndako w̃ac w̃a, do matënd sisikulu ỹa kumb. ");
INSERT INTO cou_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","W̃ënka ŋa nkwënaɗëho g'ahaw̃ary, do sisikulu ỹa ƴaŋ w̃ënka hna njiɗëho. ");
INSERT INTO cou_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","W̃ënka ŋa nkoko nkwënand g'ahaw̃ary, hafo kohn dënk fop wahuŋ wale ỹako njihn w̃a. ");
INSERT INTO cou_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","W̃ënka ŋa kohnëko wacëmët wahuŋ w̃a ntëbi wametër mbëɗ gë waki (7). ");
INSERT INTO cou_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Fop vile yënëɗëho va cëmëniho: wusëry w̃a gë wulaw̃ w̃a gë wusaw̃ w̃a do gë fop vihaw̃ary vile yasëɗ nkal li, do gë vahnë va fëna. ");
INSERT INTO cou_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Fop vile yënëɗ nkal va cëmëniho. ");
INSERT INTO cou_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ahwëhn a W̃ënu ŋa koyëna ntihëtëkëhniwo nkal li, fop vile yënëɗëho va, pëgw vahnë va hafo wulaw̃ wusankaf w̃a, hafo fop vihaw̃ary vile yasëɗ nkal va, hafo wusëry w̃a. Ntihëtëkëhniwo nkal li. Nowe fo woko do gë vële nkeniho sisikulu hna. ");
INSERT INTO cou_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Uw̃ac rac, wafac keme gë wafëhw imbëɗ (150) ntiko nkal hna ani gë pëgwahnënd guh iŋa. ");
INSERT INTO cou_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mama mbiỹahnëko wac rac nkal li W̃ënu ŋa ɗënkwëlawohna Nowe gë fop wusaw̃ gë wulaw̃ wule nkeniho hnë sisikulu w̃a. Më cañëtik sël nkal li, do w̃ënka ŋa pëgwëlehn nkuhënd. ");
INSERT INTO cou_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Wahaƴalin w̃ënka ŋa gë wahatëh wale cahnahniɗëho w̃ënka rëv ŋa ndëpalehn. Rëv ỹa ndëmëlehn. ");
INSERT INTO cou_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Toƴe toƴe nkuhëɗëho w̃ënka ŋa hnë wafac keme gë wafëhw imbëɗ (150) hafo ");
INSERT INTO cou_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","hnë fac hwëhn pëhw g'imbëɗ gë wahi (17), hnë lepera hwëhn imbëɗ gë waki hna (7), tac tëryako sisikulu ỹa wahuŋ wavë resiỹo Ararat hna. ");
INSERT INTO cou_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","W̃ënka ŋa nkoko nkuhënd hafo lepera hwëhn pëhw hna (10). Hnë fac ryënkwëryënkw lepera rac hna, nuyiko ga cahnëk wacëmët wahuŋ w̃a. ");
INSERT INTO cou_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ga ndëcëk wafac wafëhw wahnah (40), Nowe umë piɗëtëk fenetër le ntiko sisikulu hna, ");
INSERT INTO cou_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","do cana hëw̃ar g'ipër; rac më njiɗ mbokajënd: w̃ënka ŋa napëɗëho nkuh nkal hna nkolehnëh hnam. ");
INSERT INTO cou_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tac Nowe më canëka fah, soŋe njëkahn bi nkuhëk w̃ënka ŋa nkal hna. ");
INSERT INTO cou_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ɓare fah ỹa nuỹalohna hn'ile ñëw̃ëɗ, kaɓi uw̃ac w̃a guhëlohna ten; awa më mbokak gë sisikulu. Nowe më njelëk vák ỹa, pëlahna do mbokarya ndëna. ");
INSERT INTO cou_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Më napëk wafac mbëɗ gë wahi (7) tac mbok cana kat fah ỹa. ");
INSERT INTO cou_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Fah ỹa më mbokajëk g'anëka ga; faryef oliviye fasëkah nkaw̃ajëko. Awa Nowe njëtëko w̃ënka ŋa ŋaỹëtak nkal hna. ");
INSERT INTO cou_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Më mbok napëk kat wafac mbëɗ gë wahi (7) do mbok cana fah ỹa, ɓare ɓokëlohna mbokaj. ");
INSERT INTO cou_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowe nuỹako tac wabëhn wakeme mbëɗ gë ryaw̃ gë ryampo (601). Hnë fac ryënkwëryënkw vë lepera ryënkwëryënkw bëhn rac hna, w̃ënka ŋa nkuhëko. Nowe ntihëtëko ile cankahnëko sisikulu ỹa, njëkëko g'ipër do nuko nkal iŋa cëtëko. ");
INSERT INTO cou_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hnë fac hwëhn wafëhw wahi g'imbëɗ gë wahi (27) lepera higëna hna, nkal iŋa fop kankëko. ");
INSERT INTO cou_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Awa W̃ënu ŋa më ntehnëka Nowe: ");
INSERT INTO cou_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Cahnëryin sisikulu hna gë vijë hu gë vësëval hun vi. ");
INSERT INTO cou_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Canëryihni fëna wulaw̃ gë wusaw̃ wule yerun w̃i fop: wusëry w̃i fop, gë wulaw̃ do gë wusaw̃ wusankaf w̃i do gë vutoƴ vi, do gë fop vile yasëɗ nkal vi, soŋe nagëlëni, njaɓëni, do pëɓëni nkal li.» ");
INSERT INTO cou_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Awa Nowe më cahnëni gë viju, do gë vësëval hni. ");
INSERT INTO cou_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tac cahnëni fëna sifa-wo-sifa, wulaw̃ gë wusaw̃ w̃a fop, gë wusëry w̃a fop do gë fop vihaw̃ary vile yasëɗ nkal va. ");
INSERT INTO cou_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tac Nowe më ntik hn'ile cënaɗe saɗëha soŋe Ahwëhn a W̃ënu ŋa, më nufëkëhni ryampo hnë sifa wulaw̃ gë wusaw̃ wufacah hna fop gë wusëry wufacah w̃a fop, do pëɗëhni hnë hwëɗëh ntinëhna Ahwëhn a W̃ënu ŋa saɗëha gë wulaw̃ wurac. ");
INSERT INTO cou_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ahwëhn a W̃ënu ŋa tehëkawo rehërya hnëŋah saɗëha rac do më ntehnak: «Tame ɓokëɗa fërëkanu nkal iŋi soŋe vahnë va, mama nahaɗëni wameh fo koɓëri hn'utah ntëw̃ hni hna; ɓokëɗa ryaw̃ëw̃ëhni muk fop vile yënëɗ va, gante ntiɓu takan ki. ");
INSERT INTO cou_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«Gante-wo mbiỹëk nkal iŋi, tëkëɗe naɗënde, do mbarëpënde, tëkëɗ njond huji ha, do njakënd, nkeɗ sama do aỹank, nkeɗ fac, do nkeɗ umëɗ. Koyëna nkeɗ kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","W̃ënu ŋa ndëwanëkawo Nowe gë viju ntehnëhni: «Araɓi ahnagëlu, ayaɓu, afëɓu nkal li. ");
INSERT INTO cou_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tëk pëgw gaki, wulaw̃ gë wusaw̃ wavë nkal w̃i fop, gë wusëry w̃i, gë fop vihaw̃ary vile yasëɗ nkal vi, do gë wuwis w̃i fop rëkëɗ ntakëndëhni ɗus gë w̃uhnë; njëɗamuni ahwëhnuni. ");
INSERT INTO cou_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Fop vile yënëɗ va koɗun arokuni; gante njëɗamuno wanëɗa gë vatëh ki, njëɗamuni tame vëỹin fop. ");
INSERT INTO cou_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ɓare antë aroku faỹar fale woryaryëk wasat kaɓi uwám w̃a wasat hna nke. ");
INSERT INTO cou_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Awa tëƴëɗëfu uwám soŋe sat ỹa: age ahnë ndaw̃ëka ahaw̃ary piniŋëɗëfuha; age intaw̃ ndaw̃ëka ahnë piniŋëɗëfuha fëna. ");
INSERT INTO cou_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«W̃ënu ŋa gante nke umë dënk ka ntika ahn'a. Soŋe umë ye age ahnë ryehëtëk sat aỹëntaw̃u, ahnë ryehëtëɗ sat lëw̃u ỹa fëna. ");
INSERT INTO cou_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","W̃uhnë, nagëlëryin, ƴaɓëryin do pëɓëryin nkal li.» ");
INSERT INTO cou_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","W̃ënu ŋa më mbok ntehnëkëhni vëhni Nowe gë viju: ");
INSERT INTO cou_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Tame ntiɗëfu kwëtëla gë w̃uhnë, gë vutah hun va do gë vërah hni va, ");
INSERT INTO cou_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","do gë fop vile yënëɗ yerun gë w̃uhnë va: wusëry, gë wusaw̃, gë wulaw̃, fop vile sahnëntik hnë sisikulu gë w̃uhnë va. ");
INSERT INTO cou_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Wëlin ile fëhnaɓu kwëtëlin ỹa: muk uw̃ac sankaf w̃a ñoñ ɓokëɗina ndaw̃ nkal li; ɓokëɗina nke uw̃ac sankaf soŋe mbëvehn fop le ye nkal li.» ");
INSERT INTO cou_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Do W̃ënu ŋa më nkwënëk: «Wëlin dahëse kwëtëla nte wok puɗina; liɓu soŋe hun gë fop vile yënëɗ va: ");
INSERT INTO cou_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","car ulaw̃ mën ŋa vëŋar hna kwëtëɓu; umë yeɗ dahëse le ryënkwëtehnëɗ akwëtëla mën nte liɓu soŋe ɗuniỹa ỹi. ");
INSERT INTO cou_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nte-wo-nte mbarëpëɗëfu vëŋar g'ambin do cahn car-ulaw̃ ŋa, ");
INSERT INTO cou_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","awa ndënkwëtaɗëfu kwëtëla nte liɓu soŋe hun do gë fop vile yënëɗ nkal vi: ɓokëɗina nke muk uw̃ac sankaf soŋe mbëvehn fop vile yënëɗ. ");
INSERT INTO cou_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ge car-law̃ ŋa ambin hna nke, nuɗëfu do ndënkwëtehnëɗëho akwëtëla nte liɓu wok puɗina soŋe ami gë fop vile yënëɗ nkal vi.» ");
INSERT INTO cou_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","W̃ënu ŋa më mbok ntehnëka Nowe: «Car-ulaw̃ ŋa yeɗ dahëse akwëtëla nte liɓu soŋe ami gë fop vile yënëɗ nkal vi.» ");
INSERT INTO cou_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Viju Nowe vële sahnëko sisikulu va vëhni Sem gë Yafet do gë Sam yeho; Sam yeho rëm Kanan ỹa. ");
INSERT INTO cou_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hnë viju Nowe vërar vërac matini vahnë vële yaɓëk nkal vi fop. ");
INSERT INTO cou_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe yeho ayam aryënkwëryënkw ale fëlëko ikaỹ waresen ŋa. ");
INSERT INTO cou_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Fac ryampo uñen resen ceko do ndëw̃ëko, më cuɗëtak viỹi va fop usank hna. ");
INSERT INTO cou_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Sam, rëm Kanan ỹa, më nuka rëmu wëtata fo do më cahnëk pëƴahni vicëru. ");
INSERT INTO cou_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Awa Sem gë Yafet më nufëni cuɗ cankaf, ndëcani vankus hna, tac karëcandëni tënkatëndëni usank hna do cankëniha rëm hni. Namaniho antë nuniha rëm hni wëtata fo. ");
INSERT INTO cou_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ante ndëw̃ëtako Nowe ŋa, njëtako ile ntik Sam arëkwa alëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Awa më ntehnëk: «Araɓi Kanan ndëwani w̃eh! Araɓi nke aramp vicëru va!» ");
INSERT INTO cou_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tac më nkwënëk: «Cëmbik Ahwëhn a, W̃ën Sem ŋa! Araɓi Kanan nke aramp Sem! ");
INSERT INTO cou_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Araɓi W̃ënu ŋa njankën inkal Yafet ŋa, do kacande g'untënah vëhni Sem hna, do Kanan nke aramp alëw̃u!» ");
INSERT INTO cou_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ga ndëcëk uw̃ac w̃a, Nowe wabëhn wakeme watar gë wafëhw imbëɗ (350) mboko nuỹa kat. ");
INSERT INTO cou_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ga nuỹak fop ka ỹa wabëhn wakeme imbëɗ gë wahnah gë wafëhw imbëɗ (950) cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Wëlin itëfëta soŋe vutah Nowe. Ga ndëcëk uw̃ac sankaf w̃a, viju Nowe, Sem gë Sam do gë Yafet, nagëhninihëhniwo vucan. Wëlin wamac wadëw̃ hni ŋa: ");
INSERT INTO cou_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wamac ɓulunda le hnagik hnë Yafet va: Gomer gë Magog gë Madayi gë Yavan gë Tubal gë Mesek do gë Tiras. ");
INSERT INTO cou_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wamac ɓulunda le hnagik hnë Gomer va: Asëkenas gë Rifat do gë Togarëma. ");
INSERT INTO cou_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wamac ɓulunda le hnagik hnë Yavan va: Elisa gë Tarësis gë vëvë Kit do gë vëvë Rodan. ");
INSERT INTO cou_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hnë vëhni matëniho vële sampëko ntëɗëni hnë tëfary wov sankaf vë nkal dëw̃ hni ŋa, gante nke vanësa ale-wo-le ka, gante nkeni hnënk hnë nkal dëw̃ hni ka, vankol vantëw̃ hni hna. Vëhni ye ɓulunda le hnagiko hnë Yafet va. ");
INSERT INTO cou_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wamac ɓulunda le hnagik hnë Sam va: Kuc gë Misërayim gë Put do gë Kanan. ");
INSERT INTO cou_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wamac ɓulunda le hnagik hnë Kuc va: Seba gë Havila gë Sabëta gë Ragëma do gë Sabëtëka. Wamac ɓulunda le hnagik hnë Ragëma va: Saba gë Dedan. ");
INSERT INTO cou_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuc yeho fëna rëm Nëmërod nte yeho aryënkwëryënkw hnë vële hwëhnako fanka nkal va. ");
INSERT INTO cou_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ahwëhn a W̃ënu ŋa njëɗëkawo Nëmërod nke asary asankaf; soŋe më lehnande: «Aỹi, Ahwëhn a W̃ënu ŋa njëɗëkawo nke asary asankaf had Nëmërod.» ");
INSERT INTO cou_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Wahnaw̃ waryënkwëryënkw wavë nkal dëw̃u w̃a, Babel yeho gë Erëk gë Akad do gë Kalëne hnë nkal Sineyar. ");
INSERT INTO cou_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nëmërod matëko hnë nkal tac nji Asiri hna, do mbëry Niniv gë Rehobot-Ir gë Kela ");
INSERT INTO cou_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","do gë Resen yëbëlan Niniv gë naw̃ cankaf Kela ŋa. ");
INSERT INTO cou_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misërayim yeho rëm sankaf vëvë Lud va gë vëvë Anem gë vëvë Lehab gë vëvë Nafëtu ");
INSERT INTO cou_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","gë vëvë Patëros gë vëvë Kasëlu gë hn'ile matini Wafilisëte w̃a gë vëvë Kafëtor va. ");
INSERT INTO cou_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanan yeho rëm Sidon fandënkwëryënkw fantëw̃u fa gë Het ");
INSERT INTO cou_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","gë Wayebus w̃a gë Wa-amor w̃a gë Wagirëgas w̃a ");
INSERT INTO cou_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","gë Wahiv w̃a gë Wa-arëk w̃a gë Wasin w̃a ");
INSERT INTO cou_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","gë Wa-arëvad w̃a gë Wasëmar w̃a do gë Wahamat w̃a. Tac hnënk vëvë Kanan va campëniho, ");
INSERT INTO cou_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","do nkal dëw̃ hni ŋa Sidon pëgwëko paɓ Gerar hafo Gasa do gë cape Sodom gë Gomor gë Adëma do gë cape Seboyim hafo Lesa. ");
INSERT INTO cou_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Vëhni ye ɓulunda le hnagiko hnë Sam va, fitëlëko gante nkeni hnënk do gë vanësa wadëw̃ hni ka, hn'inkal dëw̃ hni hna, vankol vantëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem fëna, acëru aryënkwëryënkw Yafet ỹa, nagëhnikëhniwo vucan. Umë yeho rëm sankaf Eber ỹa do gë fop vutah vërah vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wamac ɓulunda le hnagik hnë Sem va: Elam gë Asur gë Arëpakësad gë Lud do gë Aram. ");
INSERT INTO cou_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wamac ɓulunda le hnagik hnë Aram va: Us gë Hul gë Getër do gë Mas. ");
INSERT INTO cou_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arëpakësad yeho rëm Sela ỹa; Sela yeho rëm Eber ỹa. ");
INSERT INTO cou_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber vucan vuki nuỹako: fandënkwëryënkw fa Peleg maciko, «Pitël» pëhnëtanëɗ, kaɓi wati nte nkeho ŋa, ɓulunda vë nkal ỹi pitëlëko; aheryu Yokëtan maciko. ");
INSERT INTO cou_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokëtan yeho rëm Alëmodad ỹa gë Selef gë Hasarëmavet gë Yera gë ");
INSERT INTO cou_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram gë Usal gë Dikëla gë ");
INSERT INTO cou_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal gë Abimayel gë Saba ");
INSERT INTO cou_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","gë Ofir gë Havila do gë Yobab; vëhni ye ɓulunda le hnagiko hnë Yokëtan hna. ");
INSERT INTO cou_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yëbëlan Mesa gë Sëfar resiỹo hwëhn wahuŋ hna ntëɗëniho gë cape pëhna lav ka. ");
INSERT INTO cou_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Vëhni ye ɓulunda le hnagiko hnë Sem hna vunte fitëlëko gante nkeni hnënk gë vanësa wadëw̃ hni ka, hn'inkal dëw̃ hni hna, vankol vantëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Vëhni ye ɓulunda le hnagiko hnë Nowe hna gante tëfëlëni hnagi ka inkal g'inkal. Hnë vëhni nagini fop wahnënk wale sampëk nkal w̃i ante ndëcëko uw̃ac sankaf ŋa. ");
INSERT INTO cou_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hnë ƴamani rac, vahnë vëvë ɗuniỹa vi fop uhnës uryampo fo nësëɗëniho. ");
INSERT INTO cou_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Vahnë va njasëlendëniho gë cape pëhna lav, umë nuni lañ hn'inkal Sineyar hna do ntëɗëlehnëni hnam. ");
INSERT INTO cou_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Më ntehnëlëni: «Dinëfu wasinkiri do nkulin!» Wasinkiri ŋa yeho wëraka w̃a do ile ye had gudëro yeho sima lëw̃ hni ỹa. ");
INSERT INTO cou_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tac më mbok ntehnëlëni: «Ɓëryanëfu inaw̃ do gë cery ƴihnah nte ỹakëɗ ambin ŋi! Koyëna nkeɗen vële yëtik ɗus do ahnë koɗina campehnëfu nkal li fop.» ");
INSERT INTO cou_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ahwëhn a W̃ënu ŋa më cëlik g'ambin soŋe njëk inaw̃ nte mbëryëɗëni vahnë ŋa g'acery ŋa ");
INSERT INTO cou_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","do më ntehnëk: «Ƴëkëryin! Ɓulunda ryampo fo nkeni do uhnës uryampo fo nësëɗëni! Ge aki pëgwëni ntindëni, tame ñoñ memaỹehnëɗilëhnihna ntini ile ñaɗëni ỹa. ");
INSERT INTO cou_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Awa, mpaỹëmpaỹehnëɗëfun uhnës lëw̃ hni w̃a soŋe antë mbok nkwëryëlëni!» ");
INSERT INTO cou_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Koyëna, Ahwëhn a W̃ënu ŋa më campehnëkëhni cañëtëhni ɗuniỹa hna fop, do tavëniho iɓëry naw̃ iŋa. ");
INSERT INTO cou_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Soŋe rac macahnik inaw̃ tac Babel, kaɓi hnam mpaỹëmpaỹehnëko Ahwëhn a W̃ënu ŋa nësa vahnë vëvë ɗuniỹa va fop, do hnam campehnëkëhniwo njini ɗuniỹa hna fop. ");
INSERT INTO cou_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Wëlin gante naginiho vutah Sem va. Ante nuỹako wabëhn waki ga ndëcëko uw̃ac sankaf w̃a, hara Sem wabëhn keme (100) nuỹako, nagëhnikawo facan; Arëpakësad maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Tac, Sem mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme mbëɗ ŋa (500), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arëpakësad, ante nuỹako wabëhn wafëhw warar g'imbëɗ ŋa (35), nagëhnikawo facan; Sela maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Tac, Arëpakësad mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme wanah gë watar ŋa (403), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela, ante nuỹako wabëhn wafëhw warar ŋa (30), nagëhnikawo facan; Eber maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Tac, Sela mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme wanah gë watar ŋa (403), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ante nuỹako Eber wabëhn wafëhw warar gë wahnah ŋa (34), nagëhnikawo facan; Peleg maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Tac, Eber mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme wanah gë wafëhw warar ŋa (430), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ante nuỹako Peleg wabëhn wafëhw warar ŋa (30), nagëhnikawo facan; Rewu maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Tac, Peleg mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme waki g'imbëɗ gë wahnah ŋa (209), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rewu, ante nuỹako wabëhn wafëhw warar gë waki ŋa (32), nagëhnikawo facan; Serug maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Tac, Rewu mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme waki g'imbëɗ gë waki ŋa (207), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug, ante nuỹako wabëhn wafëhw warar ŋa (30), nagëhnikawo facan; Nahor maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Tac, Serug mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn wakeme waki ŋa (200), cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor, ante nuỹako wabëhn wafëhw wahi g'imbëɗ gë wahnah ŋa (29), nagëhnikawo facan; Tera maciko. ");
INSERT INTO cou_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tac, Nahor mboko nuỹahni vutah vukaw̃ary, vucan gë vucëval, do ante nuỹako kat wabëhn keme g'ipëhw g'imbëɗ gë wahnah ŋa (119) cëmëko. ");
INSERT INTO cou_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera, ante nuỹako wabëhn wafëhw imbëɗ gë wahi ŋa (70), nagëhnikëhniwo vucan vutar: Abëram gë Nahor do gë Aran. ");
INSERT INTO cou_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Wëlin wamac vutah Tera va. Tera yeho rëm Abëram ỹa gë Nahor do gë Aran. Aran yeho rëm Lot ỹa. ");
INSERT INTO cou_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hn'inkol nte w̃acik Ur hna, Aran umë ryënkwëko cëm gë rëmu hn'inkal Salëde hna, le nagiko hna. ");
INSERT INTO cou_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abëram Sarayi ñëlëko, do Nahor, Milëka aryagu Aran. Yisëka fëna Aran yeho rëmu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hara, Sarayi kwëhnalohna fatah, kaɓi nagëɗilohna. ");
INSERT INTO cou_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera matëko Ur vë Salëde hna, njohna aju Abëram, gë Lot, fatah ajë Aran fa, do gë Sarayi asëvalu Abëram, soŋe njini hn'inkal Kanan hna, ɓare ga tëkëni Aran hna, më ntëɗëni hnam. ");
INSERT INTO cou_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera wabëhn wakeme waki gë wabëhn imbëɗ (205) nuỹako, tac cëmëko Aran hna. ");
INSERT INTO cou_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Awa, fac ryampo Ahwëhn a W̃ënu ŋa më ntehnëka Abëram: «Tavëry nkal hu ŋi, gë hnënk hu ỹi do gë tere rëmuh ỹi soŋe ayi hn'inkal nte rufëɗëmi hna. ");
INSERT INTO cou_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ntiɗëfu nagi ƴamani sankaf hwëhn nafa hnë wëjë; ndëwaɗëmi, ntiɗëmi ahnë ale hwëhnak nafa do soŋe hu ỹa njëɗëɗëfuhëhni ƴam vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Njëɗëɗëfuhëhni ƴam vële ryëwanëɗëhi ƴam va, ɓare vële ryëwanëɗëhi w̃eh va w̃eh yëɗëɗëfuhëhni. Soŋe hu ỹa ndëwaɗëfuhëhni waɓulunda ŋa fop.» ");
INSERT INTO cou_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Awa, Abëram njiko gante ntehnëkawo Ahwëhn a W̃ën ka. Wabëhn wafëhw mbëɗ gë wahi g'imbëɗ (75) kwëhnako ante matëko cahn Aran ŋa. Më njoka asëvalu Sarayi, gë Lot, fatah aheryu fa, do gë hnapul ỹa gë vëramp vële kwëhnako hnë resiỹo Aran hna, do kahnëtalehnëni njindëni g'inkal Kanan. ");
INSERT INTO cou_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ga tëkëni hn'inkal Kanan hna, Abëram më ndëcëk nkal iŋa hafo hnë atëh cëvah mbë More, nte ye Sisem ŋa. Hnë ƴamani rac, vëvë Kanan va hnam ntëɗëniho. ");
INSERT INTO cou_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ahwëhn a W̃ënu ŋa më tufëhnaka Abëram do ntehna: «Iŋi nkal ale hnagëɗe hnë wëjë yëɗaɗëfu.» Awa Abëram më ntinëhnëka Ahwëhn a W̃ënu ŋa hnam hn'ile cënaɗe saɗëha hnë hn'ile tufëhnakawo hna. ");
INSERT INTO cou_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tac, më ndëcalëk soŋe nji resiỹo hwëhn wahuŋ hna gë cape pëhna lav Betel ka; më ntik usank lëw̃u w̃a yëbëlan Betel gë Ayi; gë cape joya lav nkeho do Ayi, gë cape pëhna lav. Më mbok ntinëhnëka hnam Ahwëhn a W̃ënu ŋa hn'ile cënaɗe saɗëha haw̃ary do njëfaɗëhawo W̃ënu ŋa macatënda «Ahwëhn W̃ënu ŋa». ");
INSERT INTO cou_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tac, Abëram toƴe toƴe njiɗëho gë resiỹo Negev ka. ");
INSERT INTO cou_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hnë wati rac inte nkelehn nkal hna. Kaɓi inte cankaf yeho Abëram më njik Esipët soŋe ntëɗënti hnam. ");
INSERT INTO cou_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ante nkëhnëko tënk Esipët ŋa, më ntehnëka asëvalu Sarayi: «Nëpary, njëtëɓu ɗus asëval awamah yeru. ");
INSERT INTO cou_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ge vëvë Esipët va nunihi, ntehnëlëɗëni: “Asëvalu ỹa ye”, awa ndaw̃ëɗëniho do wëjë tavëɗënihi. ");
INSERT INTO cou_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Awa dehnëryihni ahery mën yeru, ntënënahnëniho soŋe lëw̃ hu ỹa. Koyëna pehëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Koyëna nkeho. Ante tëkëko Abëram Esipët ŋa, vëvë Esipët va nunihawo asëvalu nkwamëko ɗus. ");
INSERT INTO cou_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Vësankaf wasoɗaɗe Faraw̃o va hnukawo më njini pëƴaniha ahnaw̃ a cëkwatëndëniha. Më njoyik asëval a cery Faraw̃o hna. ");
INSERT INTO cou_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Faraw̃o ỹa g'untënah cankaf kacakawo Abëram, soŋe asëval a. Më njëɗaka wape, g'uhnankal, do gë wuhni, vëramp vësëval gë vësan, wafali do gë wayonkomb. ");
INSERT INTO cou_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ɓare Ahwëhn a W̃ënu ŋa njëɗakawo ures sankaf Faraw̃o ỹa gë vëvë tere lëw̃u va per soŋe Sarayi ỹa, asëvalu Abëram. ");
INSERT INTO cou_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraw̃o ỹa më macehnëka Abëram do tëƴa: «Soŋe ye liruho aki? Soŋe ye woru pëƴalihohna asëval hu ye? ");
INSERT INTO cou_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Soŋe ye lehnëru ahery hu ye, do aravo hafo ỹandu ỹëlëw̃a? Tame, wëliho asëval hu; nufëryehna do ayi!» ");
INSERT INTO cou_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraw̃o ỹa më ntehnëkëhni vëryokuŋ vëlëw̃u va ntapëhnaniha Abëram cahn Esipët hna g'asëvalu, gë Lot, do gë vëvë tere lëw̃u va g'ile kwëhnak ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Awa Abëram më matëni Esipët hna g'asëvalu, gë Lot, do gë vëvë tere lëw̃u va g'ile kwëhnako ỹa fop, mbokani gë cape rëhw gë pëhna lav Kanan hnë Negev hna. ");
INSERT INTO cou_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abëram mbetako ɗus. Kwëhnakëhniwo wakore wacankaf wusaw̃ gë koryi le ryëhwarëɗe yaɓah do gë sanu. ");
INSERT INTO cou_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Matëko Negev hna mbokand toƴe toƴe gë Betel le ndënkwëko ntëɗ yëbëlan Betel gë Ayi hna, ");
INSERT INTO cou_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","do hnam ntiko hn'ile cënaɗe saɗëha ỹa. Abëram njëfaɗëhawo Ahwëhn a W̃ënu ŋa gë koɓëri ka. ");
INSERT INTO cou_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, nte nkeniho ŋa, umë fëna kwëhnakëhniwo wakore wape, g'uhnankal, gë wuhni do gë tere yaɓah. ");
INSERT INTO cou_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nkal iŋa ƴankëlohna soŋe ntëɗahnëni ndampo fo, kaɓi wakore wusaw̃ wulëw̃ hni w̃a njaɓëniho ɗus, ");
INSERT INTO cou_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","do kat, vëvë Kanan va do gë vëvë Perisi va hnë nkal tac ntëɗëniho. Soŋe umë vëhery wusaw̃ Abëram va conkëɗëniho gë vëva Lot va. ");
INSERT INTO cou_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Awa Abëram më ntehnëka Lot: «Këlami, tere ryampo fo yeyinëk. Tëfëlahna nke sonko yëbëlan fu, ma yëbëlan vëheryëherya wusaw̃ fu va. ");
INSERT INTO cou_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ƴëkëry! Nkal iŋa fop haryënkw hu nke. Pitëlënëfu. Ge g'irahahn njiru, ami g'irëhw njiɗëfu, do ge g'irëhw njiru, ami g'irahahn njiɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Awa Lot njëkalehnëko do nuko lañ Yurëdan ỹa hafo resiỹo Sowar hna fop cëkëko ɗus. Nkeho had sarëɗiŋ Ahwëhn a W̃ënu ŋa le yeho Eden hna ma had inkal Esipët ŋa. (Koyëna nkeho ani gë Ahwëhn a W̃ënu ŋa nihahnënd inaw̃ Sodom gë inaw̃ Gomor.) ");
INSERT INTO cou_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot më tëhnak lañ Yurëdan rac fop do pakëta gë cape pëhna lav; koyëna pitëlëniho vëhni vëhi. ");
INSERT INTO cou_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abëram nkal Kanan hna nkoko. Lot ɗarël wahnaw̃ Yurëdan hna njiko ntëɗ do nti wasank wadëw̃u ŋa gë cape Sodom hna. ");
INSERT INTO cou_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hara vële lëɗëko Sodom va nkeya meh ɗus kwëhnaniho, wameh wante ñak ŋwëỹëɗ Ahwëhn a W̃ënu ŋa ntiɗëniho. ");
INSERT INTO cou_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ante pitëlëniho ŋa, Ahwëhn a W̃ënu ŋa më ntehnëka Abëram: «Ƴëkëry vacape vanah tak: haryënkw gë hamëhni do gë farëhw gë farahahn. ");
INSERT INTO cou_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nkal nte hnuɗu ŋi fop njëɗaɗëmi, wëjë gë vutah hu va ahwëhnu kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Njaɓënëɗëfuhëhni fëna vutah hu va gante njaɓëk nkërëƴal ki. Koɗena ndëkwini, gante nkok koɗena ndëkwi nkërëƴal ki. ");
INSERT INTO cou_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Matëry, ayasëlehn nkal li caharaɓ; wëjë yëɗaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abëram më pakëtëk idëɗ dëw̃u ŋa nji ntëɗ hnë vatëh vacëvah vambë Mamëre, ɗarël Ebëron hna, do ntinëhna hnam Ahwëhn a W̃ënu ŋa hn'ile cënaɗe wasaɗëha. ");
INSERT INTO cou_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","6","Wëlin itëfëta uw̃ët sankaf vëhnaw̃ ŋa. Hnë wabëhn pëhw gë waki hna (12), ahnaw̃ ale w̃aciko Kedor-Lawomër avë Elam ỹa w̃ëkëkëhniwo vëhnaw̃ vëỹëntaw̃ va, vëhni ye: Bera avë Sodom ỹa, gë Birësa avë Gomor ỹa, gë Sineyab avë Adëma ỹa, gë Semeber avë Seboyim ỹa do gë avë Bela ỹa, umë w̃acëɗe fëna Sowar. Ɓare hnë hwëhn pëhw gë watar hna (13), vërac ŋañënaniho. Hnë bëhn hwëhn pëhw gë wahnah hna (14), Kedor-Lawomer gë vëhnaw̃ vërar vële nkeniho va, (ahnaw̃ Amërafel avë Mesopotami ỹa, gë Ariyok avë Elasar ỹa, do gë Tidal avë Goyim ỹa) mëkënihëhniwo Warefayi w̃a hnë Asëtarot-Karënayim hna, Wasus w̃a hnë Ham hna, do gë Wa-emi w̃a hnë Save-Kiriyatayim hna. Mëkënihëhniwo Wahori w̃a ỹal hni hna wahuŋ walëw̃ hni Seyir hna, do tëfëlehnënihëhniwo hafo atëh El-Paran hna, ɗarël wula hna. ");
INSERT INTO cou_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tac më mbokani gë cape En-Misëpat, umë lehnëɗe Kades. Më nihëni nkal Wamalesi ŋa fop do mëkënihëhni fëna Wa-amor wale lëɗëko Hasason-Tamar va. ");
INSERT INTO cou_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Awa ahnaw̃ avë Sodom ỹa, gë avë Gomor ỹa, gë avë Adëma ỹa, gë avë Seboyim ỹa do gë avë Bela ỹa, (umë ye Sowar), më canënihëhni wasoɗaɗe walëw̃ hni w̃a soŋe pëhwëtani w̃ët sankaf w̃a hnë lañ Sidim hna, umë ye tame Wov Waŋiry ŋa, ");
INSERT INTO cou_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gë vëhnaw̃ vëỹëntaw̃ vële nkeniho gë Kedor-Lawomer va. Vëhnaw̃ imbëɗ w̃ëtëɗëho gë vëhnah. ");
INSERT INTO cou_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nkeho hnam vankëɗ vajaɓah gudëro. Ahnaw̃ avë Sodom ỹa g'avë Gomor ỹa hn'igary dëw̃ hni hna, më njoni hnam; vële fehëko va gë wahuŋ cow̃aniho. ");
INSERT INTO cou_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Vële w̃ëkëkëhniwo va më nufëni fop hnapul vëvë Sodom gë Gomor va, do gë fop rokëtok le pehnaniho ỹa, njilehnëni. ");
INSERT INTO cou_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kaɓi Lot, fatah aheryu Abëram fa, Sodom hna ntëɗëntiko, njoryaryënihawo fëna, gë hnapul lëw̃u ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ale yaryëko më njik pëƴahna Abëram Ebëre le lëɗëko ɗarël vatëh vacëvah Mamëre Hamor ỹa, umë yeho acëru Esëkol gë Aner; vëhni vërar tak nkwëryëlëniho gë Abëram. ");
INSERT INTO cou_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ga njëtak Abëram fatah aheryu fa aramp ntiyik, më mbarëpëkëhni vësan wakeme watar g'ipëhw g'imbëɗ gë vërar (318) vële hnagiko tere lëw̃u va, do tëfëlehnënihëhni hafo Dan hna. ");
INSERT INTO cou_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abëram më pitëndëlehnëkëhniwo vësan vërac wakore waƴaɓah do pëgwëhni vëỹew̃ va g'umëɗ. Ndaw̃ëɗëhëhniwo do tëfëlehnëɗëhëhniwo hafo Oba, gë cape rahahn gë pëhna lav Damas ka. ");
INSERT INTO cou_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Më mbijëk hnapul lëw̃u ỹa fop, do mbijëkawo fëna Lot gë hnapul lëw̃u ỹa, gë vësëval va do gë vëramp vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ga mbokajëk Abëram ante mëkinihëhniwo vëhni Kedor-Lawomer do gë vëhnaw̃ vërar vële nkeniho va, ahnaw̃ avë Sodom ỹa kacakawo hnë lañ Save hna, (umë ye: Lañ Ahnaw̃). ");
INSERT INTO cou_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melëkiseɗek, ahnaw̃ Salem do yeho asëna wasaɗëha W̃ën Hunte Sëpëk Fop ŋa, më njojëk mburu do g'uñen. ");
INSERT INTO cou_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Më ndëwanëka Abëram aki: «Araɓi W̃ën Hunte Sëpëk Fop ŋa do lik ambin iŋi g'inkal iŋi ndëwana Abëram. ");
INSERT INTO cou_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Araɓi W̃ën Hunte Sëpëk Fop ŋa cëmbi kaɓi njëɗëki imëk vëỹew̃ hu va!» Awa Abëram më njëɗaka ihwëhn pëhw-wo hnë vile nuỹajëko hn'uw̃ët va. ");
INSERT INTO cou_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ahnaw̃ avë Sodom ỹa më ntehnëka Abëram: «Ɓësaryew̃ëhni vahnë vi do aworyary hnapul ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abëram më ntëkwaka: «Tufaɓuha Ahwëhn a, W̃ën Hunte Sëpëk Fop ŋa do lik ambin iŋi g'inkal iŋi: ");
INSERT INTO cou_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","lëk, ñoñ nufëɗa viỹë vile hwëhnëru vi, wëla faỹaw̃ar ma ỹëba wapary. Koyëna koɗila ahnës: “Mbetandanëɓuha Abëram.” ");
INSERT INTO cou_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ñoñ ñaɗa soŋe lëmën ge gena ile tokëni vahnë mën ỹi do gë sah vële lapëhnajëko vi: Aner, gë Esëkol, do gë Mamëre, vëhni teɓaɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ga ndëcëk watac, Ahwëhn a W̃ënu ŋa më tufëhnaka Abëram do ntehna: «Antë ntaki, Abëram! Keryëɗëmi do njëɗëɗëmi ɗus.» ");
INSERT INTO cou_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ɓare Abëram më ntëkwak: «Ahwëhn W̃ën mën, soŋe ye yëɗëɗuho? Kwëhnala fatah fante lëw̃ëɗ. Eliyeser mbë Damas, aramp tere mën ye ale lëw̃ëɗ hnapul mën ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ha, kaɓi ƴëɗalihow̃ëhnihna vutah, ale liɗ ɗoku mën a lëw̃ëɗ fop le hwëhnaɓu ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ahwëhn a W̃ënu ŋa më ntëkwaka: «Hali, gena umë lëw̃ëɗ ile hwëhnaru ỹa: ale hnagëru wëjë dënk lëw̃ëɗ.» ");
INSERT INTO cou_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tac Ahwëhn a W̃ënu ŋa më canëka Abëram hn'usank lëw̃u hna do ntehna: «Ƴëkëry ambin ŋi do ɗëkwëry wahol w̃i ge koɗu.» Tac më nkwënëk: «Koyëna njaɓëɗëni vutah hu va.» ");
INSERT INTO cou_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abëram më kwëtahnëka Ahwëhn a W̃ënu ŋa do Ahwëhn a W̃ënu ŋa soŋe rac catahnëka gë Abëram. ");
INSERT INTO cou_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Më ntehnëka: «Ahwëhn a W̃ënu ŋa yeɓu, ale saniki hn'inaw̃ Ur vë nkal Salëde ỹa soŋe yëɗaỹi ahwëhn nkal nte yehahnëru ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abëram më tëƴëka: «Ahwëhn W̃ën mën, hak njëtëɗëfu paryi ami hwëhnëɗ?» ");
INSERT INTO cou_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ahwëhn a W̃ënu ŋa më ntëkwaka: «Ƴonëhnew̃ëhni wusaw̃ wule hwëhnak wabëhn watar: yihni le wok nagëna, g'inankal cëval, gë yënki, tac ikuh ndampo gë fëpah fëndampo.» ");
INSERT INTO cou_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abëram më njojëkëhni wusaw̃ wurac. Ndaw̃ëhni do ntëpëtëlehnëhni fagant fo do kakëndëlehn ntëpëtel-wo g'antëpëtel ñëntaw̃ ŋa; wusëry w̃a fo nkoko dëpëtëlehnëna. ");
INSERT INTO cou_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Wahuy më njijëni wusaw̃ hna, ɓare Abëram ntakëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wati nte njoɗëho lav ŋa, Abëram wakwëɗ ñëhnëko ɗus. Awa umëhwëry mbahnah ntakah tëkëhnëlehnehna. ");
INSERT INTO cou_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ahwëhn a W̃ënu ŋa më ntehnëka hnë wakwëɗ waɗëw̃u watac: «Ƴëtëry ɗus vële hnagëɗe hnë hnënk hu va ntëɗëɗëni hn'inkal nte nkoni vëhwëhnëna; vëramp yeɗ, do mbërehnëɗeni hnë wabëhn wakeme wanah (400). ");
INSERT INTO cou_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ɓare piniŋëɗëfuhëhni vële liɗëhëhni vëramp va, do cahnëɗëni hnam gë hnapul yaɓah. ");
INSERT INTO cou_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ɓare wëjë, ntiɗu untaf nëŋah, ƴam cëmëɗu do mbañëɗeru. ");
INSERT INTO cou_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mbokajëɗ wati nte nkeɗëni vutah vërah hu va warëm sankaf kaɓi daɗëw̃ëhnihna Wa-amor ŋa ge waryëcëtëna wameh ŋa nkal li.» Koyëna ndakeryëko Abëram. ");
INSERT INTO cou_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ante njok lav do mëhwëryëk ɗus ŋa, awa w̃ura hwëɗëh le sëhnëɗ gë ryoko hwëɗëh ndëcëtalehn taŋ yëbëlan wusaw̃ wule lëpëtik hna. ");
INSERT INTO cou_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Awa koyëna kahnëndëko Ahwëhn a W̃ënu ŋa kwëtëla ŋa gë Abëram do ntehna: «Njëɗaɗëfuhëhni vële hnagëɗe hnënk hu va iŋi nkal, yëbëlan le tëkwëk nkal Esipët hna hafo sën Efërat hna, sën sankaf ỹa. ");
INSERT INTO cou_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Umë ye inkal Waken ŋa, gë Wakenis ŋa, gë Wakadëmon ŋa, ");
INSERT INTO cou_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","gë Wahit ŋa, gë Waperis ŋa, gë Warefayi w̃a, ");
INSERT INTO cou_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","gë Wa-amor ŋa, gë Wakanan ŋa, gë Wagirëgas ŋa, do gë Wayebus w̃a.» ");
INSERT INTO cou_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Awa Sarayi, asëvalu Abëram, nagëɗilohna. Ɓare kaɓi kwëhnakawo aramp avë Esipët, ale w̃aciko Agar, ");
INSERT INTO cou_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","më ntehnëka Abëram: «Nuru, Ahwëhn a W̃ënu ŋa maw̃ëna hnagu. Awa ɗakëryin g'aramp mën aỹi. Koɗ mpëd nagëhnow̃ëhni vutah.» Abëram më maw̃ëk wanës asëvalu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Awa Sarayi, më nufëka aramp alëw̃u ỹa Agar, njëɗahna asanu Abëram ñëla. Watac ante ndëcëko wabëhn pëhw (10) wante ntëɗahnëko Abëram hn'inkal Kanan hna ntiyako. ");
INSERT INTO cou_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abëram më ndakëni gë Agar do ndonkëlehn. Ga njëtëk ndonkëk, pëgwëlehn njafaŋënda Sarayi ale hwëhnëka ỹa. ");
INSERT INTO cou_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Awa Sarayi më ntehnëka Abëram: «Wëjë ye ankaf waƴew̃ wante yew̃ëɗeɓu ŋi! Ami yëɗakina aramp mën a, ɓare koɓëri ga njëtëk ndonkëk, njafaŋëɗëho. Araɓi Ahwëhn a W̃ënu ŋa kitiŋ yëbëlan wëjë g'ami!» ");
INSERT INTO cou_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abëram më ntëkwaka: «Aramp hu ỹa wëjë hwëhnëka! Diryehna gante ñaɗu ka.» Awa Sarayi pëgwëlehn ntinda këm fo Agar afo nkary gë wula. ");
INSERT INTO cou_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mëleka Ahwëhn a W̃ënu ŋa më tëkatëka ɗarël hnë hacëm hante ye hn'ankaw̃ nte yiɗ Sur. ");
INSERT INTO cou_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Më tëƴëka: «Agar, aramp Sarayi, ne matiru do ne njiɗu?» Më ntëkwaka: «Sarayi ale hwëhnëko ỹa yaryëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mëleka Ahwëhn a W̃ënu ŋa më ntehnëka: «Ɓokary g'ale hwëhnëki, do dënënëryehna.» ");
INSERT INTO cou_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Do më nkwënëk: «Ahwëhn a W̃ënu ŋa njëɗaɗëhini vutah vujaɓah ɗus. Ahnë koɗina ndëkwëhni. ");
INSERT INTO cou_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ndonkëru do facan hnagëɗu. Isëmayel w̃acëɗuha (umë fëhnëtanëɗ W̃ënu ŋa nkwëryëɗ), kaɓi Ahwëhn a W̃ënu ŋa nuɗ haỹëhnah hu w̃a. ");
INSERT INTO cou_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ajë hu had fali fav fëk nkeɗ. Mëtaryëɗëhëhni vahnë va fop, do vahnë va fop mëtaryëɗëniha. Minu fo ntëɗëɗ; vësaŋëɗina gë hnënk lëw̃u ỹa fop.» ");
INSERT INTO cou_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agar më tëƴak: «Paryi bi nuɓuha ale hnuɗëho ỹi?» Do më macëka Ahwëhn a W̃ënu ŋa, ale hnësëhnëkawo ỹa «El-Royi», (umë fëhnëtanëk W̃ën hunte hnuɗëho). ");
INSERT INTO cou_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Soŋe rac w̃acande hacëm hante ye yëbëlan Kades gë Bered ỹa: kolomba Ber-Lahayi-Royi (umë fëhnëtanëɗ kolomba ale wok cëmëɗina hnuɗëho). ");
INSERT INTO cou_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar facan nagëko, do Abëram më macëka fatah fa Isëmayel. ");
INSERT INTO cou_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hnë wati rac Abëram wabëhn wafëhw mbëɗ gë warar g'imbëɗ gë ryaw̃ (86) kwëhnako. ");
INSERT INTO cou_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Awa ante nuỹako Abëram wabëhn wafëhw imbëɗ gë wahnah g'imbëɗ gë wanah ŋa (99), Ahwëhn a W̃ënu ŋa tufëhnakawo do ntehna: «Ami ye W̃ën Hwëhn Fanka Fop ỹa. Gefu kwëlëkwël g'ami do alind ile saŋëk! ");
INSERT INTO cou_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ntiɗëfu kwëtëla yëbëlan wëjë g'ami do yëɗaỹini vutah vujaɓah ɗus.» ");
INSERT INTO cou_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abëram më ndëkwëhnëk yëka ỹi nkal hna, do W̃ënu ŋa më nkok nësëhnëɗëha ntehnënda: ");
INSERT INTO cou_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Cape mën ŋa, wëli kwëtëla nte liɓu gë wëjë ŋa: acër ɓulunda yaɓah yeɗu. ");
INSERT INTO cou_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Goɗila aw̃aci Abëram, ɓare Abëraham macëɗeru, kaɓi ntiɗëmi Rëm waɓulunda waƴaɓah ɗus. ");
INSERT INTO cou_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Vële hnagëɗe hnë wëjë va njaɓëɗëni ɗus hafo ntini wayal; do vëhnaw̃ nagëɗeni fëna hnë wëjë. ");
INSERT INTO cou_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Njaw̃ënëɗëfu kwëtëla fu ŋa kwëlëkwël, tac vutah hu hna fëna gë vërah hni hna ge golihna: koyëna nkeɗëfu W̃ën hu do gë W̃ën vutah vunte hnagëɗe hnë hnënk hu va. ");
INSERT INTO cou_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ha, wëjë gë vutah hu vumbë acahn va njëɗaɗëmu nkal nte yehantu gaki uhneh ŋi, nkal Kanan ŋi fop. Vëhni hwëhnëɗ kwëlëkwël do W̃ën hudëw̃ hni ha yeɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","W̃ënu ŋa më mbok ntehnëka Abëraham: «Cape hu ŋa, wëjë gë vutah hu va do gë vutah vuntëw̃ hni va ntënënëɗun akwëtëla mën ŋa. ");
INSERT INTO cou_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wëlin akwëtëla mën nte yeɗ yëbëlan ami gë w̃uhnë ŋa: fop vësan va tëfëka kácini. ");
INSERT INTO cou_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Háci ỹa yeɗ dahëse kwëtëla nte ye yëbëlan ami gë w̃uhnë ŋa. ");
INSERT INTO cou_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ge nuỹani wafac mbëɗ gë warar, fop vucan va kácëndeni kwëlëkwël. Kácehnëɗuhëhni fëna fop vëramp vële hnagik ỹal hu va do gë vëramp vële law̃ik hnë vëhneh wok vëyentina vëvë tere hu va. ");
INSERT INTO cou_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Vëhni fop tëfëka kácëndeni. Umë yeɗ dahëse vimbahn hun hna ile rufahnëɗ kwëtëla mën ŋa mbiỹëɗ kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ale woɗe kácina ỹa, pitëɗe ɓulunda lëw̃u hna, kaɓi dënënëna kwëtëla mën ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tac W̃ënu ŋa më mbok ntehnëka Abëraham: «Asëval hu Sarayi, ɓokëɗila aw̃aca Sarayi, tame w̃ac lëw̃u w̃a Sara yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Njëɗëɗëfuha do g'umë njëɗaɗëmina fatah facan; njëɗëɗëfuha ɗus, nkeɗ hnëm waɓulunda waƴaɓah, do nagëɗeni hnë umë vëhnaw̃ waɓulunda.» ");
INSERT INTO cou_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abëraham më mbok ndëkwëhnëk kat yëka ỹa nkal hna, do pëgwëlehn ndasënd kaɓi ntehnaɗëho: «Hak koɗëfu hnuỹaw̃a fatah, ami ale hwëhnak wabëhn keme (100), do Sara wabëhn wafëhw mbëɗ gë wahnah (90) kwëhnak: hak koɗ nag?» ");
INSERT INTO cou_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abëraham më ntehnëka W̃ënu ŋa: «Iñë ryampo fo w̃untaɗëmi: ahnaỹëna Isëmayel do afaɓa.» ");
INSERT INTO cou_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ɓare W̃ënu ŋa më ntëkwaka: «Hali, kwëtëla mën ŋa diɗa g'Isëmayel! Asëval hu, Sara, nagëhnëɗëhina facan, Isak macëɗuha do ntiɗëfu kwëtëla mën ŋa gë umë do gë vutah vuntëw̃u va ge umë gona. Kwëtëla nte wok puɗina yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Soŋe Isëmayel ỹa fëna, nkwëryëɓu ile rëƴëruho ỹa: ndëwanëɗëfuha, ntiɗëfuha nagëhni vutah vujaɓah ɗus. Nkeɗ acër vësankaf vankol pëhw gë vaki (12) do nkeɗ acër asankaf ɓulunda yaɓah. ");
INSERT INTO cou_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ɓare kwëtëla mën ŋa gë Isak fo kahnëndëɗëfu, facan fante nagëhnëɗëhina Sara, bëhn hnë iỹi wati fa.» ");
INSERT INTO cou_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ga puhnak W̃ënu ŋa nësël gë Abëraham ŋa, tavëlehna nji. ");
INSERT INTO cou_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hnë fac rac dënk, Abëraham kácehnëkawo aju Isëmayel gë fop vële hnagiko tere lëw̃u va do gë fop vëramp vële ntaw̃ëko va. Fop vësan vële hwëhniko tere lëw̃u va káciniho gante ntehnëkawo W̃ën ka. ");
INSERT INTO cou_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Ante káciniho Abëraham g'Isëmayel, aju ŋa, wabëhn wafëhw mbëɗ gë wahnah g'imbëɗ gë wanah (99) kwëhnako do aju wabëhn ipëhw gë watar (13). ");
INSERT INTO cou_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hnë fac rac fo káciniho Abëraham g'aju Isëmayel ");
INSERT INTO cou_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","do gë fop vësan vëvë tere lëw̃u va, gë vëramp vële hnagiko ỹalu ma law̃iko hnë vëhneh hna. ");
INSERT INTO cou_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Fac ryampo, Ahwëhn a W̃ënu ŋa tufëhnakawo Abëraham ɗarël vatëh vacankaf Mamëre hna. Hnë rënka usank lëw̃u hna ntañako g'anent ga hnë wati le ỹak njakëɗ ulav hna. ");
INSERT INTO cou_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Taŋ nulehnëhni vësan vërar ga kahnëni ŋaw̃ët lëw̃u toƴe. Abëraham matëlehn rënka usank hna nkary kacahni do ndëkwëhn yëka ỹa nkal hna ");
INSERT INTO cou_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","do ntehn: «Ɗemaryino asabu ỹal mën hna. ");
INSERT INTO cou_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Njonëhniɗëmu w̃ënka toƴe awuyëtahnu wapary ŋi do ayinëgawu hnë aŋi tëh. ");
INSERT INTO cou_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Njëɗaɗëmu le rokëɗun toƴe soŋe avokahnu ayaw̃u, tac ndëcalëɗun nkaw̃ hun ŋa. Koyëna cabiɗiluhna aki fo ỹal mën hna.» Vësan va më ntëkwani: «Caŋëk! Diry wante hnësëru ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Awa Abëraham më ntëfëk mboka gë usank nji tëkata Sara asëvalu do ntehna: «Nufëry ñap ile rëfëka ỹa ali vamburu vapërën vajaɓah.» ");
INSERT INTO cou_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tac më nkaryëk gë antega wusaw̃, më tahnika fañihni fakonah do faniryah njëɗahna aryokuŋ alëw̃u. Arac më ntëfëk soŋe nëga. ");
INSERT INTO cou_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ga ñëhnëk faỹar fa, Abëraham më ntëɗëhnëkëhni vëhneh va gë wambël wañëhnah. Hnë wati nte tokëɗëniho ŋa, Abëraham ɗarël lëw̃ hni kahnëko kuyët tëh hna. ");
INSERT INTO cou_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tac më tëƴëniha: «Ne nkeha asëval hu Sara?» Më ntëkwakëhni: «Usank hna nke». ");
INSERT INTO cou_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Aryampo hnë vësan vërac më ntehnëka: «Mbokajëɗëfu bëhn hnë iỹi wati dënk do tëkatëɗëfuha asëval hu Sara nuỹaka facan.» Sara rënka usank hna nkeho, hamëhni Abëraham do nkwëryëko. ");
INSERT INTO cou_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Hara, Abëraham gë Sara asëvalu ntafëniho ɗus, do Sara ndëcëkawo hnag ỹa. ");
INSERT INTO cou_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Awa, më pëgwëk ndasënd ntaw̃ary dëw̃u hna fo ntehnand: «Tame ntafëɓu ɗus do asan mën aỹi fëna ntafëk. Koɗ bi mbok përo gë asan?» ");
INSERT INTO cou_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Awa Ahwëhn a W̃ënu ŋa më tëƴëka Abëraham: «Soŋe ye ndasëk Sara? Soŋe ye ntehnaɗ: “Koɗina nke koyëna, ntafëɓu ɗus soŋe hnagëw̃a fatah?” ");
INSERT INTO cou_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nkehëhna bi ile nkok koɗina nti Ahwëhn a W̃ënu ŋa? Ge mbokajëɓu bëhn hnë iỹi wati dënk tëkatëɗëfu Sara nuỹaka facan.» ");
INSERT INTO cou_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ga ntakah ŋa, Sara më njahëtak ntehn: «Ɗasëla.» Ahwëhn a W̃ënu ŋa më ntëkwaka: «Ha, ndasëru!» ");
INSERT INTO cou_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tac vësan va matëlehnëni paɓëni Sodom. Abëraham më ntapëhnakëhni soŋe koyalëni. ");
INSERT INTO cou_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ahwëhn a W̃ënu ŋa më ntehnak: «Ñaɗa sow̃ëw̃a Abëraham ile ỹaɗëfu liwu ỹa ");
INSERT INTO cou_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kaɓi tëfëka nke rëm ɓulunda sankaf hwëhn fanka. Soŋe hu ỹa ndëwaɗëfuhëhni waɓulunda ŋa fop. ");
INSERT INTO cou_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tëhnaɓuha soŋe ntehnëhni viju gë fop vële hnagëɗe hnënk lëw̃u va tëfëka maw̃ëhnëni vakwëɗa mën va, ntindëni ile saŋëk do satëk; koyëna ntinëhnëɗëfuha ile lehnëɓuha ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Awa Ahwëhn a W̃ënu ŋa më ntehnëka Abëraham: «Wante ntehnëɗeni ntini vëvë Sodom gë vëvë Gomor va ŋaƴëk, wameh wadëw̃ hni ŋa njaɓëk ɗus. ");
INSERT INTO cou_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Cëlëndaɗëfu soŋe fëcëtaju wante wëryëɗëfu ntehnëɗeni ntini ŋi. Ge umë fop ntiɗëni, njëtëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tac vësan vëhi hnë vërar hna kahnëtalehnëni njindëni gë cape Sodom, hara Ahwëhn a W̃ënu ŋa gë Abëraham nkoniho. ");
INSERT INTO cou_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abëraham më tëhaka do tëƴa: «Ahwëhn W̃ën, paryi bi mbëvehnëɗuhëhni ndampo fo ale w̃enëk gë ale wok menëna ỹa? ");
INSERT INTO cou_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mpëd tëkëni vësatah wafëhw imbëɗ (50) Sodom hna. Tavëndilihëhnihna bi vëvë iŋi naw̃ vi soŋe vësatah wafëhw imbëɗ (50) vële lëɗëntik hnam vi? ");
INSERT INTO cou_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hali, koɗila ali koyëna! Koɗila avëvehnëhni ndampo fo ale w̃enëk gë ale wok menëna, alihni ndampo fo aw̃en a gë asatah a. Wëjë ale hitiŋëɗ ɗuniỹa fop ỹa koɗila ali le wok catëna.» ");
INSERT INTO cou_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ahwëhn a W̃ënu ŋa më ntëkwaka: «Ge tëkatëɓuhëhni vësatah wafëhw imbëɗ (50) Sodom hna, soŋe lëw̃ hni ỹa tavëhnëɗëfuhëhni vëvë hnam va fop.» ");
INSERT INTO cou_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abëraham më mbok ntehnëk: «Tavëhnërye ryëku hnësëhni, Ahwëhn W̃ën, ami ale ye ivëɗ gë iɓëhn aỹi fo. ");
INSERT INTO cou_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mpëd warëkëna wafëhw imbëɗ (50) nkojëni vahnë imbëɗ (5). Soŋe vahnë imbëɗ (5) vële wojëk vi mbëvehnëɗu bi naw̃ ŋi?» Ahwëhn a W̃ënu ŋa më ntehnëk: «Ɓëvehnëɗa ge tëkatëɓuhëhni vahnë wafëhw wahnah gë imbëɗ (45).» ");
INSERT INTO cou_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abëraham më mbok ntehnëk kat: «Mpëd wafëhw wahnah (40) fo nkeni.» Ahwëhn a W̃ënu ŋa më ntehnëk: «Soŋe vahnë wafëhw wahnah (40) vërac ɓëvehnëɗa naw̃ ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Awa Abëraham më ntehnëk: «Këlami, Ahwëhn, antë ntavi ge mbokëɓu hnësu kat. Mpëd wafëhw warar (30) fo rëkatëɗe.» Ahwëhn a W̃ënu ŋa më ntëkwak: «Ɓëvehnëɗa naw̃ ŋi la vahnë wafëhw warar (30) fo rëkatëɓu.» ");
INSERT INTO cou_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abëraham më mbok ntehnëk: «Ahwëhn, tavëhnërye ryëku vok hnësu. Mpëd wafëhw wahi (20) fo rëkatëɗe.» Ahwëhn a W̃ënu ŋa më ntëkwaka: «Soŋe vahnë wafëhw wahi (20) vërac ɓëvehnëɗa naw̃ ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Awa Abëraham më ntehnëka: «Këlami, Ahwëhn, antë ntavi ge mbokëɓu hnësu rëkwa ỹa. Mpëd ipëhw (10) fo rëkatëɗe.» Ahwëhn a W̃ënu ŋa më ntëkwaka: «Soŋe vahnë ipëhw (10) vërac ɓëvehnëɗa naw̃ ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ga puhnak Ahwëhn a W̃ënu ŋa nësël gë Abëraham ŋa njilehn do Abëraham mbokalehn gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ante tëkëniho wamëleka waki ŋa, g'anëka ga, Sodom hna, Lot rënka naw̃ hna ntañako. Nundëhni tuŋ, matëlehn nji pankëlëni do ndëkwëhn yëka ỹa nkal hna haryënkw lëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Më ntehnëkëhni: «Këlamu, wëlawo mën, maw̃ëryin asëlu ỹal mën hna, ntinëhnëɗëmu ile valëɗëhu ỹa. Koɗun awuyëtawu wapary ŋa do aryaku hnam. Acahn g'acahnëfëɗ ga ndëcalëɗun.» Wamëleka ŋa më ntëkwaniha Lot: «Hali, për hna ndakëɗëfun, ỹëw̃a ɓulunda hna.» ");
INSERT INTO cou_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ɓare Lot ndëñanëkëhniwo ɗus hafo njini gë ỹalu. Umë ntëvakëhni roka fërën do nkulëhnëhni vamburu tokëni. ");
INSERT INTO cou_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Vëryakëlohna ten, ante kwërëniho tere ỹa vësan vëvë Sodom va; vëjar gë vicër, fop hnam nkeniho, ahnë gojëlohna. ");
INSERT INTO cou_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Më macëniha Lot do tëƴëniha: «Ne nkehëhni vësan vële yijëk ỹal hu va aŋi nëka? Canihni, ñaɗëfun ryakëlahnëfu gë vëhni.» ");
INSERT INTO cou_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot më cahnëk do piɗ rënka ỹa kamëhni lëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Më ntehnëkëhni: «Këlamu, vëỹënta mën, antë aliwu uw̃i w̃eh! ");
INSERT INTO cou_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nëparyin: kwëhnaɓuhëhni vëryag vëhi vëyëtëlëhnihna vësan ten. Njonëhniɗëmuni, aliwuni gante ñaɗun ka. Ɓare antë aliwuni iñë vëỹi vësan; kaɓi njijëni kuyëtani hn'icën tere mën hna.» ");
INSERT INTO cou_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ɓare më ntëkwaniha: «Kërënary hn'ani! Ahneh fo yeru do aỹand aye ahitiŋ ỹal fu li! Awa, ntiɗeru w̃eh ntëbini vëhni!» Më cañëtëniha Lot gë fanka do tëhalehnëni rënka ỹa soŋe tënkëni. ");
INSERT INTO cou_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ɓare wamëleka waki ŋa më piɗëtëni rënka ỹa pëlaniha Lot, ndohëniha ɓambery do piɗëni. ");
INSERT INTO cou_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tac umë mëpënënihëhni vële hwërako rënka tere va, vëjar va gë vicër va per, do vëhnuɗilohna hn'ile nke rënka tere ỹa. ");
INSERT INTO cou_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Wamëleka waki ŋa më ntehnëniha Lot: «Nihëɗëfun iŋi naw̃, kaɓi Ahwëhn a W̃ënu ŋa nkwëryëk fop wameh waƴaɓah wante ntini vëvë iŋi naw̃ vi, do paƴikëfu hnihëfu. Ge nkeni hn'ani vahnë vëhaw̃ary vële yerun hnënk, vutah hu ma vëyëla hu, canëryihni aỹaw̃ëtëhni ani.» ");
INSERT INTO cou_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot më njik pëƴahni vëyëlawu, vële hwëhnëkëhniwo vëragu va. Më lehnëkëhniwo: «Matëryin ñap asahnu hn'iŋi naw̃, kaɓi Ahwëhn a W̃ënu ŋa nihëɗ!» Ɓare vëhni ntiyahnëkëhniwo nëh nëhahnëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wakëwak ỹa, wamëleka ŋa ñankëɗënihawo Lot, ntehnëndëniha: «Matëry! Nufëryehna asëval hu gë vëryag hu vëhi vi, ge ñaɗiluhna asëmëntiwu gë vëvë iŋi naw̃ vi ge kitiŋëɗeni soŋe wameh wante ntini ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kaɓi nkoko kwajëlehnand, wamëleka waki ŋa më pëlanihëhni wëɓák ŋa, umë g'asëvalu do gë vëryagu, canënihëhni naw̃ hna, kaɓi Ahwëhn a W̃ënu ŋa ñaɗëho pehëtëhni. ");
INSERT INTO cou_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ante canënihëhni ŋa, mëleka ryampo më ntehnëka Lot: «Garyëry afehët ntaw̃ary hu ŋa! Antë ayëka hamëhni do antë ahahn wëla sëñ! Garyëry asow̃a kuŋ hna soŋe antë asëm!» ");
INSERT INTO cou_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot më ntëkwak: «Hali, Ahwëhn, ");
INSERT INTO cou_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","paryi nke, ami, aryokuŋ hu ỹa, tëkëɓu hnuỹaw̃u ipaɓ hu ŋa do ndemaruho ɗus g'ipehët ntaw̃ary mën ŋi; koɗa yaryu hafo rëku kuŋ hn'ani, hara w̃eh w̃a tëkalohna, do sëmu. ");
INSERT INTO cou_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nuru faŋi fankol hn'ani? Ŋaw̃ëna, koɗëfun yaryëfu hafo hnam sow̃afu. Maw̃ëryanëryifu yifu sow̃afu hnam-kaɓi fatoƴ fo ye-soŋe feharyahnëfu walaw̃ary fu w̃a.» ");
INSERT INTO cou_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mëleka ỹa më ntehnëka Lot: «Awa! Mbokëɗëmi w̃aw̃ëryani kat iŋi ɗema do nihëɗa fankol fante lehnëru fi. ");
INSERT INTO cou_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Garyëryin ñap ayiwu asow̃awu hnam, kaɓi ñoñ koɗa liwu ge tëkëluhna hnam!» Soŋe rac ankol tac Sowar maciko (umë fëhnëtanëɗ «naỹëna»). ");
INSERT INTO cou_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Wati nte pëhniɗëho lav ŋa, tëkëɗëniho Sowar hna. ");
INSERT INTO cou_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Awa Ahwëhn a W̃ënu ŋa më këfik g'ambin hn'inkal Sodom hna gë Gomor hna rëv hwëɗëh do gë wëraka wale fëɗëɗ. ");
INSERT INTO cou_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Umë nihëk gë uw̃eh sankaf waỹi wahnaw̃ do gë resiỹo hna fop. Fop vahnë vëvë waỹi wahnaw̃ va cëmëniho do gë vile fëhnëko nkal va per. ");
INSERT INTO cou_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Asëvalu Lot më njëkak hamëhni, më mbacik nke had apahn waŋiry. ");
INSERT INTO cou_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ga pacëk koɓëri fo g'acahnëfëɗ ga, Abëraham më njik le kahnëko haryënkw Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Më njëkëk gë cape Sodom gë Gomor do gë resiỹo ỹa fop do më nuk ga cëhnëɗ hwëcic. Gë aŋan cankaf mëntëlëniho. ");
INSERT INTO cou_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Koyëna, ante mbëvehnëko W̃ën wahnaw̃ wavë iỹi resiỹo ŋa, kaɓi ɗënkwëlawohna Abëraham, do pehëtëkawo Lot hn'uw̃eh le mbëvehnahnëko wahnaw̃ wale ntëɗahnëko w̃a. ");
INSERT INTO cou_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Tac, Lot më matëk Sowar hna kaɓi ntakëkawo nko ntëɗ hnam, do nji ntëɗëni gë vëryagu hn'ikuŋ. Hn'uhary ñëw̃ëniho gë vëhni. ");
INSERT INTO cou_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Fac ryampo, fandënkwëryënkw fa më ntehnëka aheryu: «Nëpary, rëm fu ỹi ɓiỹëɗina cërëɗ do vësan vëhaw̃ary vëyena resiỹo li soŋe ndakin nuỹahnihni vutah, gante ntiɗëni vahnë fop ka. ");
INSERT INTO cou_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Pëɗëfuhna uñen hafo ndëw̃ tac ndakin nagëhnahnihna vutah nkohahn hnënk lëw̃u ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hn'umëɗ tac, më ndëw̃ënëniha rëm hni do fandënkwëryënkw fa më njik ndakëni gë rëmu. Lot ndëw̃ëko ɗus, ƴëtalohna ile ntiko aryagu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ga pacëk fandënkwëryënkw fa më ntehnëka aheryu: «Wëli umëɗ nte ryëcëk ŋi ndakëɓun gë rëm mën ỹa; ɓokëfu ndëw̃ënihna dol tac g'ayi aryakëgu. Kaɓi koyëna fo nagëhnëɗeha vutah.» ");
INSERT INTO cou_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hnë anëka tac mboko ndëw̃ënëniha rëm hni do maherya njigëlehn ndakëgëni gë rëmu. Lot mboko ndëw̃ ɗus, ƴëtalohna ile ntiko aryagu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Awa, koyëna ndonkëndëkëhniwo Lot vëryag vëhi vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Fandënkwëryënkw fa facan nagëko do maca Mowab (umë fëhnëtanëɗ «ale w̃atik hnë rëm»); rëm hnënk Mowab vële wok hafo dol va ye. ");
INSERT INTO cou_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Maherya fëna më nagëka facan, do maca Ben-Ami (umë fëhnëtanëɗ «fatah hnënk mën»); rëm hnënk Amon vële wok hafo dol va ye. ");
INSERT INTO cou_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abëraham matëko hnam njind gë cape resiỹo Negev; yëbëlan Kades gë Sur ndahëko, tac nji neh Gerar hna ");
INSERT INTO cou_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","do hnam ntehnëɗëho soŋe asëvalu Sara ỹa: «Ahery mën ye.» Soŋe rac Abimelek, ahnaw̃ avë Gerar ỹa nufahnëkawo Sara. ");
INSERT INTO cou_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ɓare g'umëɗ ga, W̃ënu ŋa më tufëhnaka Abimelek hnë huɗakery do ntehna: «Soŋe asëval ale hnufëru ỹi cëmëɗu, kaɓi ñëlik.» ");
INSERT INTO cou_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hara Abimelek nte woko vëvankëna ten ryëka gë Sara ŋa më ntëkwak: «Ahwëhn ami gë ɓulunda mën ỹi ñoñ dilëfuhna! Ndaw̃ëɗuha bi ale wok menëna? ");
INSERT INTO cou_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abëraham umë dënk lehnëko aheryu ye do Sara fëna njaw̃ënëk acëru ye. Ahwëhn, toña ye do ñoñ dila w̃eh.» ");
INSERT INTO cou_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","W̃ënu ŋa më ntëkwaka hnë huɗakery hutac dënk: «Toña ye ñoñ dilihna w̃eh, njëtëɓu ami fëna. Ami wok tavëlihna aỹaka do koyëna memaỹehnëmi ali w̃eh haryënkw mën. ");
INSERT INTO cou_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tame ɓësaryehna asanu aỹi asëval. Kila ye; njëfanëɗëhi soŋe afehary ntaw̃ary hu ŋa. Ɓare ge ɓësalihahna, ƴëtëry wapacëk cëmëɗun fop gë vëlëw̃ hu per.» ");
INSERT INTO cou_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek më matëk koɓëri fo do macëhni vële rëhaka va pëƴahni wante ndakeryëk ŋa. Vërac më ntakëkëhni ɗus. ");
INSERT INTO cou_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek më macehnëka Abëraham do tëƴa: «Soŋe ye liruhëfu aki? Ntiyehnëruhëfu ami gë ɓulunda mën ỹa uw̃eh ỹaƴah. Ntiruho ile nkok ahnë diɗilohna muk. ");
INSERT INTO cou_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ye fëlaki soŋe alihahn iỹin?» ");
INSERT INTO cou_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abëraham më ntëkwak: «Ntehnaɓuho vahnë vëvë hnani vi vëlënënëɗilahna W̃ënu ŋa do ndaw̃ëɗëniho soŋe asëval mën aỹi. ");
INSERT INTO cou_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Do dënk toña ye ahery mën ye: rëm ryampo fo yeɓun, ɓare ɓankëlëfunahna hnëm. Soŋe rac kolahnëk nke asëval mën. ");
INSERT INTO cou_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ante canëkow̃o W̃ën hnë tere rëm mën hna, ntehnëɓuhawo asëval mën aỹi: “Hn'ile-wo-le njiɗe hna, ɗemarye alehn acër hu yeɓu.”» ");
INSERT INTO cou_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ante puhnak Abëraham wanës ŋa, Abimelek më nufëkëhni wape gë wuhnankal gë wuhni gë vëramp vësëval do gë vësan, njëɗahna Abëraham mbësalehna asëvalu Sara. ");
INSERT INTO cou_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek më mbok ntehnëka Abëraham: «Nkal mën ŋi wëjë hwëhnëk. Dëɗëry hn'ile-wo-le caŋahnëki hna.» ");
INSERT INTO cou_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tac ntehna Sara: «Nuru, njëɗaɓuha waŋëc wëli koryi acër hu: umë ye dahëse le yëtëndanëɗëhëhni fop vële yerun va menëlihna iñë.» ");
INSERT INTO cou_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abëraham njëfakawo W̃ënu ŋa. W̃ënu ŋa njërënëkawo Abimelek gë asëvalu do gë vëryokuŋ vësëval vëlëw̃u va, do koɗëniho mbok nagëni. ");
INSERT INTO cou_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kaɓi Ahwëhn a W̃ënu ŋa ures le nkok koɗina ndonk asëval ntihahnëkëhniwo fop tere Abimelek ỹa, soŋe inuf asëval Abëraham ale w̃aciko Sara ỹa. ");
INSERT INTO cou_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ahwëhn a W̃ënu ŋa ndemakawo Sara gante ntehnëkawo ka. ");
INSERT INTO cou_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ndonkëko do nagëhna Abëraham, nte rëko ntaf ŋa, facan gante ntehnëkawo W̃ënu ka do ");
INSERT INTO cou_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abëraham më macëka Isak. ");
INSERT INTO cou_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kacehnëkawo ante nuỹako wafac imbëɗ gë warar ŋa (8), gante ntehnëkawo W̃ënu ka. ");
INSERT INTO cou_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abëraham wabëhn keme (100) nuỹako ante nagiko Isak ŋa. ");
INSERT INTO cou_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Awa Sara më ntehnëk: «W̃ënu ŋa njëɗako uhnatah le ryasëndanëɗëho, do fop vële yëtaɗ hnagi Isak va ndasëntëɗeni.» ");
INSERT INTO cou_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Më mbok ntehnëk kat: «Mo hoɗëho ntehna Abëraham hnë fac ryaw̃ Sara njëw̃ëndëɗëha fatah? Ɓare mama cërahnëk nagëhnëɓuha facan.» ");
INSERT INTO cou_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Fatah fa naỹëko do Sara tavëtehnëkawo ɓël iŋa. Hnë fac le tavëtendeho ỹa, Abëraham ambënt cankaf ntiko. ");
INSERT INTO cou_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Fac ryampo, Sara nukawo aju Agar mbë Esipët, ale nagëniho gë Abëraham, ga nëhahnëɗëha Isak fatah fantew̃u fa. ");
INSERT INTO cou_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Më ntehnëka Abëraham: «Daryehna asëval aramp aỹi g'aju, kaɓi aju asëval aramp aỹi tëfëlahna nuỹanti ntëw̃ iŋa gë Isak ajë mën aỹi.» ");
INSERT INTO cou_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Wanës watac pëmpëhnahnëkawo ɗus Abëraham, kaɓi Isëmayel fëna aju yeho. ");
INSERT INTO cou_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ɓare W̃ënu ŋa më ntehnëka: «Antë pëmpëhnahni soŋe ajë hu gë hnëmu. Maw̃ëry ali fop le ntehnëɗëhi Sara ỹa. Kaɓi gë Isak nuỹaɗuhëhni vutah vunte lehnëmi yëɗaɗëmini va. ");
INSERT INTO cou_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ɓare soŋe ajë aramp hu ỹi, ntiɗëfuha umë fëna rëm ɓulunda, kaɓi umë fëna ajë hu ye.» ");
INSERT INTO cou_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ga pacëk, Abëraham më matëk koɓëri fo g'acahnëfëɗ ga, nuf vamburu gë ryëpët w̃ënka njëɗahna Agar do koyahni umë g'aju. Njilehn nkwërëtand hnë wula vë Berëseba hna. ");
INSERT INTO cou_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ante puk w̃ënka ŋa ryëpët hna, më tavëka fatah fa kuyët hnë fatëh ");
INSERT INTO cou_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","do nji ntaña cahët, hnë vëntacel keme (100) ntëbi, kaɓi ntehnaɗëho: «Ñaɗa hnuw̃uw̃a ga cëmëɗ fatah mën fi.» Awa më ntañak cahët do pëgw kond. ");
INSERT INTO cou_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","W̃ënu ŋa nkwëryëko kopa fatah fa do mëleka W̃ënu ŋa më macika Agar g'ambin do ntehna: «Ye ga ye, Agar? Antë ntaki, kaɓi W̃ënu ŋa nkwëryëk wako fatah fa hn'ile tavëruha hna. ");
INSERT INTO cou_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Matëry! Nufëryehna ajë hu do ƴaw̃ënëryehna ɗus, kaɓi gë umë ntiɗëfu ɓulunda sankaf.» ");
INSERT INTO cou_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","W̃ënu ŋa më tufëka Agar kolomba. Më njik tëmpënëk ryëpët hna w̃ënka do njëɗahna aju ciya. ");
INSERT INTO cou_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","W̃ënu ŋa paɓëkawo fatah fa. Naỹëko do wula Paran hna ntëɗëko. Hnam asary g'uŋwary yeho do ");
INSERT INTO cou_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","hnëmu asëval avë Esipët njëkëlehnëhnëkawo. ");
INSERT INTO cou_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hnë ƴamani rac, Abimelek gë Pikol asankaf wasoɗaɗe walëw̃u w̃a, njiniho vëhni Abëraham hna do ntehna: «Njëtëɓun W̃ënu ŋa gë wëjë nkerun hn'ile-wo-le liɗu hna. ");
INSERT INTO cou_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Awa tame, dëkënde g'uw̃ac W̃ënu ŋa tokaɗilihohna ami, vutah mën va fëna do gë vërah vutah hni va. Kwëhnaɓuho nëf soŋe lëw̃ hu ỹa. Wëjë fëna, kwëhnary nëf soŋe lëmën ỹa do g'inkal nte lëɗahnëru ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abëraham më ntëkwak: «Ha, ntëkëɓu.» ");
INSERT INTO cou_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tac Abëraham nuỹako fere pëƴahna soŋe kolomba le nufëniho gë fanka vahnë Abimelek va. ");
INSERT INTO cou_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek më ntëkwaka: «Ƴëtëla bi mo lik rac. Wëjë dënk, pëƴalihow̃ohna. Dol fo njëtaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abëraham më nufëkëhni wape gë wuhnankal do gë wuhni njëɗahna Abimelek do vëhni vëhi ntiniho kwëtëla. ");
INSERT INTO cou_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abëraham më pitëkëhni vupe vucëval mbëɗ gë vuki. ");
INSERT INTO cou_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek më tëƴëka: «Soŋe ye fitëruhëhni vuŋi vupe mbëɗ gë vuki?» ");
INSERT INTO cou_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abëraham më ntëkwaka: «Maw̃ëry areɓahni soŋe aryënkwëtahnënd paryi ami yabëk iỹi kolomba.» ");
INSERT INTO cou_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Soŋe rac macahnëɗe hnam Berëseba (umë fëhnëtanëɗ «kolomba idëk», ma «mbëɗ gë vuki»), kaɓi hnam ntëkëniho vëhni vëhi tak. ");
INSERT INTO cou_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Awa koyëna kwëtëlëniho Berëseba hna. Tac, Abimelek mbokalehnëni gë Pikol asankaf wasoɗaɗe ỹa g'inkal Filisët. ");
INSERT INTO cou_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abëraham pëlëko atëh Tamaris Berëseba hna, do cëmbëɗëhawo W̃ën hunte ye kwëlëkwël ha macatënda Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abëraham wabëhn waƴaɓah ntiko hn'inkal Filisët hna. ");
INSERT INTO cou_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ga ndëcëk watac, W̃ënu ŋa njëkëhnahnëkawo Abëraham. Macëkawo: «Abëraham!» do Abëraham më mëtaka: «Nëpami!» ");
INSERT INTO cou_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","W̃ënu ŋa më ntehnëka: «Nufëryehna ajë hu Isak, ryamboli asëval hu ale ỹaɗu ɗus ỹi, ayi hn'inkal Moriya hna. Do hnam, ndaw̃ëhnëɗuhowa do afëɗa had saɗëha hn'ikuŋ nte yabëɗëmi hna.» ");
INSERT INTO cou_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ga pacëk, Abëraham më matëk koɓëri fo g'acahnëfëɗ ga. Më calëk waɗëhwa ŋa soŋe saɗëha ỹa, ndiɓënda fali falëw̃u fa do njohna aju Isak gë vëryokuŋ vëhi vëlëw̃u kahnëtalehn gante nkabëkawo W̃ën. ");
INSERT INTO cou_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Hnë fac rarëna hna, Abëraham nuko ŋaw̃ët kuŋ nte njihahnëɗëho ŋa. ");
INSERT INTO cou_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abëraham më ntehnëkëhni vëryokuŋ vëlëw̃u va: «Ñëw̃ëryin ani gë fali fi; ami g'ajë mën aỹi kaƴëɗëfun ƴaŋ sëmbifuna W̃ënu ŋa, tac mbokajëɗëfun.» ");
INSERT INTO cou_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abëraham më ndiɓëndëka aju Isak waɗëhwa saɗëha ŋa; umë hwëɗëh ha g'icar ŋa njoko. Njilehnëni vëhni vëhi tak ndampo fo. ");
INSERT INTO cou_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak më tëƴëka rëmu Abëraham: «Apa?» Abëraham më ntëkwaka: «Ye ye ajë mën? Nëpami.» Isak më ntehnëka: «Kwëhnayinëk hwëɗëh ha gë waɗëhwa ŋa, ɓare ne nkeha fape soŋe saɗëha ỹa?» ");
INSERT INTO cou_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abëraham më ntëkwaka: «Ajë mën, W̃ënu ŋa njëɗahnëɗëha umë dënk fape saɗëha fa.» Vëhni vëhi tak nkoniho njindëni ndampo fo. ");
INSERT INTO cou_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ga tëkëni hn'ile nkabëkawo W̃ën hna, Abëraham më ntik hn'ile cënaɗe saɗëha hna do kwët ƴaŋ waɗëhwa ŋa. Tac ñaba aju Isak, do tinda hnë waɗëhwa wante kwëtëko hn'ile cënaɗe saɗëha hna. ");
INSERT INTO cou_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tac nuf cary iŋa soŋe káca aju. ");
INSERT INTO cou_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɓare taŋ mëleka Ahwëhn a W̃ënu ŋa më macika g'ambin: «Abëraham! Abëraham!» Abëraham më mëtaka do ntehna: «Ha, nëpami!» ");
INSERT INTO cou_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mëleka ỹa më mbok ntehnëka: «Antë aỹaka fatah fi! Antë alihna w̃eh! Njëtëɓu tame ntënënëɗuha W̃ënu ŋa, kaɓi ŋwëỹëryanëlihahna ajë hu, ryamboli asëval hu ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Awa Abëraham më nuka yënki ga pëlayik wamiry ŋa hnë fasëc. Më njinëhnëka gwëcëta Isak gë yënki ỹa soŋe saɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abëraham më macëk ỹëw̃a rac: «Ahwëhn a W̃ënu ŋa njëɗahnëɗ.» Soŋe rac wok w̃acahnënde ha gaki: «Hn'ikuŋ hna, Ahwëhn a W̃ënu ŋa njëɗahnëɗ ile rëfëka ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tac mëleka Ahwëhn a W̃ënu ŋa më mbok macika Abëraham g'ambin higëna ỹa ");
INSERT INTO cou_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","do ntehna: «Wëli ile ntehnëk Ahwëhn a W̃ënu ŋa: ntëkëhnëmi g'uw̃ac mën w̃a dënk, kaɓi aki ntiru, ŋwëỹëryanëlihow̃ahna ajë hu, ryamboli hu ỹa, ");
INSERT INTO cou_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ndëwanëɗëmi do njaɓënëɗëfuhëhni vutah hu va had wahol wavë g'ambin w̃i ma nkërëƴal nte ye tëfary wov ŋi. Nufëɗëni wahnaw̃ vële ỹew̃ëkëhni va. ");
INSERT INTO cou_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Waɓulunda waɓë nkal ŋi fop gë vëhni ndëwanëɗeni kaɓi maw̃ëhnëruho.» ");
INSERT INTO cou_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tac Abëraham g'aju mbokalehnëni gante nkeni vëryokuŋ vëlëw̃u do kahnëtalehnëni mëncëndëni gë Berëseba. Hnam nkoko ntëɗ Abëraham. ");
INSERT INTO cou_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ga ndëcëk watac, Abëraham pëƴayiko Milëka fëna nagëhnëkawo aheryu Nahor vutah vucan: ");
INSERT INTO cou_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us yeho fandënkwëryënkw fa, gë aheryu ỹa Bus, gë Kemuwel rëmu Aram, ");
INSERT INTO cou_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","gë Kesed, gë Aso, gë Pilëdas, gë Yidëlaf do gë Betuwel. ");
INSERT INTO cou_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel yeho rëmu Rebeka ỹa. Vëỹi ye vutah mbëɗ gë vutar vunte nagëhnëkawo Milëka Nahor aheryu Abëraham va. ");
INSERT INTO cou_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor kwëhnakawo asëval ahigëna. Rewuma maciko. Umë fëna nagëkëhniwo vutah: Teba, gë Gaham, gë Tahas do gë Maka. ");
INSERT INTO cou_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara, asëvalu Abëraham, wabëhn keme gë wafëhw wahi g'imbëɗ gë waki (127) nuỹako cëmat. ");
INSERT INTO cou_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kiriyat-Arëba hna cëmëko, dol Ebëron macëɗe, hnë nkal Kanan hna. Abëraham ntiko wakwëy asëvalu ŋa do koɗëho soŋe icëm dëwu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tac Abëraham më matëk haryënkw asëm alëw̃u hna do nji ntehnëhni Wahit w̃a aki: ");
INSERT INTO cou_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Ahneh fo yeɓu ỹal hun li, ale sëlëndik hnë w̃uhnë do ryëcëlehnëɗ. Ɓare asëval mën a cëmëk. Awa gwafëryino iƴag ỹal hun li vañahnëw̃a.» ");
INSERT INTO cou_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahit w̃a më ntëkwaniha: ");
INSERT INTO cou_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Muntayiru aw̃aw̃ ahnëpafu! W̃ënu ŋa ntiki asan ahwëhn nafa fagant lëw̃ fu. Ɓañëryehna asëval hu hn'iƴag nte ỹak fërënak walëw̃ fu li. Wëla aryampo ŋwëỹëryanëɗilihna iƴag dëw̃u ŋa soŋe avañahna.» ");
INSERT INTO cou_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Awa Abëraham më tëhakëhni ndëkwëhn haryënkw lëw̃ hni, ");
INSERT INTO cou_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","do ntehnëhni: «Ge paryi maw̃ërun vañëw̃a asëval mën aỹi ani, tëƴëndinow̃a Efëron, aju Sohar, ");
INSERT INTO cou_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nkwafo iƴag iɓë resiỹo Makëpela nte ye hnë ikëɗ kaỹ dëw̃u ŋi. Dehnëryina nkwafo gante ñaɗ ka, tase hun. Nkehahn dëmën.» ");
INSERT INTO cou_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efëron hnam dënk nkentiko. Më ndekak soŋe ntëkwahna Abëraham nkwëryahnëni wahit w̃a fop ỹëw̃a ɓulunda hna ntehn: ");
INSERT INTO cou_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ɗemarye, aw̃aw̃ ahnëpaw̃o, gwafëɗila muk kaỹ iŋi gë ƴag iŋi. Tase vëvë ỹalënta mën vi, njëɗëmi, koɗu avaña hnam asëval hu.» ");
INSERT INTO cou_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kat Abëraham më mbok ndëkwëhnëk haryënkw Wahit hna, ");
INSERT INTO cou_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","tac ntehna Efëron hafo fop nkwëryëni, më lehnëko: «Këlami, nëparye! Njëɗaɗëmi koryi soŋe kaỹ iŋi. Maw̃ëry iỹi koryi soŋe holahnu vañëw̃a asëval mën aỹi.» ");
INSERT INTO cou_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efëron më ntëkwaka Abëraham: ");
INSERT INTO cou_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Nëparye, këlami! Ikaỹ nte hoɗe nkwafi waŋëc koryi wakeme wahnah fo (400), kwëhnana nafa yëbëlan lëw̃ fu! Awa ɓañëryehna asëval hu!» ");
INSERT INTO cou_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abëraham maw̃ëko do njëɗahnëko ile nësëko Efëron ỹa tase vëvë ỹalëntaw̃u va, waŋëc wakeme wanah (400) koryi vë wati rac. ");
INSERT INTO cou_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Koɓëri tac, ikaỹ Efëron nte yeho hnë resiỹo Makëpela favalëko gë Mamëre ŋa, gë iƴag nte yeho hnam ŋa do gë fop vatëh vante yeho ɓambery kaỹ va ");
INSERT INTO cou_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abëraham hwëhnëko. Fop Wahit wale yeho hnam va waseɗe yeho. ");
INSERT INTO cou_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Tac Abëraham më mbañëka asëvalu Sara hnam, ɗarël Mamëre hna, më w̃acëɗe tame Ebëron, nkal Kanan hna. ");
INSERT INTO cou_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ikaỹ iŋa gë ƴag nte yeho hnam ŋa golohna kwëhnëni Wahit. Abëraham hwëhnëko gë maw̃al dëw̃ hni ŋa, soŋe mbañahnëndëhni vësëm vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abëraham cërëko ɗus. Ahwëhn a W̃ënu ŋa ndëwakawo hnë fop. ");
INSERT INTO cou_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Hnë fac ryampo, Abëraham më ntehnëka aryokuŋ alëw̃u ale ỹak lafëk tere ỹa. Umë yeho ankaf fop hnapul Abëraham ỹa. Umë lehnëkawo: «Kuyëtëry vák hu ỹi mbuf mën li ");
INSERT INTO cou_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","do dëkënde gë Ahwëhn a W̃ën le hwëhnëk ambin ŋi gë nkal ŋi, ƴëkëlehnëndilihahna ajë mën aỹi asëval avë hnë iŋi nkal Kanan nte lëɗahnëɓu ŋi. ");
INSERT INTO cou_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ɓare dëkënde alehno njiɗu hnë nkal nte w̃atahniɓu hna ayëkëlehnëhnehna ajë mën a Isak asëval hnënk mën hna.» ");
INSERT INTO cou_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aryokuŋ a më ntëkwaka: «Ye liɗëfu ge asëval a ŋwëỹëk soŋe tëfe ani? Awa, tëfëka bi w̃ënceryëw̃a ajë hu hn'inkal nte w̃atahniru hna?» ");
INSERT INTO cou_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abëraham më ntehnëka: «Hali, ŋwëỹëry ɗus soŋe aw̃ëncerya ajë mën aỹi hatac. ");
INSERT INTO cou_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ahwëhn a, W̃ën le hwëhnëk ambin ŋa, caniko tere rëm mën hna g'inkal hnënk mën ỹa. Nësëhnëko do ntëkëhnëko njëɗaɗëhëhni vutah mën va kwëhnëni iŋi nkal ani. Cañëtiɗëha mëleka lëw̃u ỹa haryënkw hu soŋe aholahn ayonëhnehna asëval ajë mën aỹi. ");
INSERT INTO cou_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ge asëval a maw̃ëna tëfi, awa ntihëtaɗ idëk nte lëkënduho ŋa; ɓare antë aw̃ëncerya muk ajë mën aỹi hatac.» ");
INSERT INTO cou_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Awa aryokuŋ a më kuyëtëk vák lëw̃u ỹa hn'imbuf Abëraham hna do ntëkëhna ntehna ntiɗ fop ile ntehnëka nti ỹa. ");
INSERT INTO cou_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tac, aryokuŋ a më nufëkëhni wayonkomb ipëhw (10) wuva Abëraham w̃a do njoryary fop ile fërënak hnë hnapul le kwëhnako Abëraham ỹa. Kahnëtalehn paɓ gë inaw̃ nte ntëɗahnëko Nahor ŋa, gë cape tahahn pëhna lav Mesopotami ka. ");
INSERT INTO cou_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aryokuŋëhn Abëraham ỹa tëkëko ɗarël hnë kolomba le woko gena naw̃ hna, më njinëgehnëkëhni wayonkomb w̃a. G'anëka nkeho, hnë wati le njijëɗëniho vësëval ỹëry w̃ënka ŋa. ");
INSERT INTO cou_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Më njëfak aki: «Ahwëhn, W̃ënu Abëraham nte ryokuŋëhnëɗëfu ŋi, maw̃ëryanëhnërye fankëlëfu gë ale valëkow̃a ỹa. Tufahnëry koyëna ipërëna nte hwëhnaru soŋe Abëraham ale ryokuŋëhnëɗëfu ỹi. ");
INSERT INTO cou_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wëli ɗarël kolomba hna nkeɓu do vëryag vëvë iŋi naw̃ vi njijëɗëni ỹëry w̃ënka ŋa. ");
INSERT INTO cou_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Dol tëƴëɗëfuha aryampo hnë vëhni nkury unkwahn ntëw̃u ŋa soŋe siyawu. Ge ntehnëko “Ciyary, njëɗëɗëfuhëhni fëna wayonkomb hu w̃i ciyantini”, awa, njëtëɗëfu umë ỹaryaryëɗuha aryokuŋ hu ỹi Isak. Koyëna njëtëɗëfu ntiru gë uhwëhna nëf soŋe ale ryokuŋëhnëɗëfu ỹa Abëraham.» ");
INSERT INTO cou_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ani gë puhnahnënd iƴëfa ŋa tëkëlehni Rebeka, aryagu Betuwel, unkwahn ntëw̃u ŋa nkus hna. Betuwel ajë Milëka gë Nahor yeho, aheryu Abëraham. ");
INSERT INTO cou_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Fandag fankwamah ɗus yeho; ƴëtëlëhniwohna vësan. Cëlëndako kolomba hna, tëmpën unkwahn ntëw̃u ŋa do kaƴënda. ");
INSERT INTO cou_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Aryokuŋ Abëraham ỹa më nkaryëk pankëlëni do ntehna: «Këlami, ƴëɗërye siyawu toƴe w̃ënkahu ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Më ntëkwaka: «Këlami, Apa, ciyary.» Më nkwëtëndak ñap nkwahn uŋa do njëɗahna ciya. ");
INSERT INTO cou_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ga njëɗaka ciya, më ntehnëka: «Ñëryëhnëɗëfuhëhni fëna wayonkomb hu w̃i ciyantini afo mërëni.» ");
INSERT INTO cou_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Më kotak ñap w̃ënka waɓë nkwahn dëw̃u ŋa kosa hna, tac nkary mbok ñëryi kat. Pëɗëkëhniwo wayonkomb w̃a fop. ");
INSERT INTO cou_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Asan a njëkëɗëhawo aryag a hara ñoñ nësëna, do tëƴaɗëho bi Ahwëhn a W̃ënu ŋa caŋëndanëk uyas lëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ante puhnani wayonkomb ciya ŋa, asan a më canik waryiɓ walëw̃u hna njëɗahna aryag a anënk sanu le hwëhnak nafa yaɓah do gë wame sanu waki wante hwëhnak ule-wo-le nafa yaɓah fëna. ");
INSERT INTO cou_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Tac më tëƴëka: «Aryag mo yeru? Pëƴarye këlami bi nkehëhna igwac tere rëmuh hna soŋe asëlëndahnëfu ryakëfu dol hnam gë vële lapëhnaɗëho vi?» ");
INSERT INTO cou_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Aryag a më ntëkwaka: «Betuwel ye rëm mën ỹa, aju Milëka gë Nahor.» ");
INSERT INTO cou_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Më nkwënëk: «Lury ỹa gë idël iŋa njaɓëk ỹal fu hna, do gë hn'ile koɗun aryaku fëna.» ");
INSERT INTO cou_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Asan a më ndëkwëhnëk yëka ỹa nkal hna do camehna Ahwëhn a W̃ënu ŋa ");
INSERT INTO cou_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ntehn: «Camehnëmi Ahwëhn, W̃ën ale ryokuŋëhnëɗëfu Abëraham! Tufahnëɗu kwëlëkwël ipërëna hu ŋa do g'ikahnënda hu ŋa gë cape ale ryokuŋëhnëɗëfu ka: hnë uw̃i yas Ahwëhn a W̃ënu ŋa njiryeryëko satën fo gë hnënk ale ryokuŋëhnëɗëfu ka.» ");
INSERT INTO cou_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Aryag a më nkaryëk pëƴahn tere hnëmu hna le ryëcëtak ỹa. ");
INSERT INTO cou_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Hara Rebeka kwëhnakawo acër ale w̃aciko Laban. Nuko anënk ŋa gë wame ŋa hnë vák aheryu hna do nkwëryëko ga tëfëtaɗe ile ntehnëkawo asan a. Awa më nkaryëk nji tëkata asan a gë wayonkomb walëw̃u w̃a ɗarël kolomba hna ");
INSERT INTO cou_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","do ntehna: «Ƴij ỹal fu hna, wëjë ale ndëwak Ahwëhn a W̃ënu ŋa. Soŋe ye ỹëw̃ëru hnë gwac li? Pëhwëtëɓu cery ŋa do ntinëhnëɓuhëhni wayonkomb hu w̃i hn'ile ñëw̃ëɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Awa aryokuŋ Abëraham ỹa më njik vëhni Laban hna. Më nkwëtëndini wayonkomb w̃a ile ndiɓëniho ỹa do njëɗayini ile tokëɗëni. Do njonëhnijini fëna aryokuŋ Abëraham ỹa gë vële lapëhnakawo va w̃ënka nkuyëtahnëni wapary ŋa. ");
INSERT INTO cou_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Më njëɗayik roka, ɓare më ntehnëk: «Tokëɗa ge gena nësëɓu le ỹaɗëfu hnësu ỹa.» Laban më ntehnëka: «Awa nësëry!» ");
INSERT INTO cou_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Asan a më ntehnëk: «Aryokuŋ Abëraham yeɓu. ");
INSERT INTO cou_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ahwëhn a W̃ënu ŋa mbetandanëka ɗus ale ryokuŋëhnëɗëfu ỹa; njëɗaka wape gë wuhnankal do gë wuhni, gë koryi do gë sanu gë vëryokuŋ vësan gë vësëval, wayonkomb gë wafali. ");
INSERT INTO cou_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Asëvalu Sara, mama ntafahnëk, nagëhnëka facan fante njëɗak fop ile kwëhnak ỹa. ");
INSERT INTO cou_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ale ryokuŋëhnëɗëfu ỹa ntehnëko lëku: “Ƴëkëlehnëndilihahna ajë mën aỹi asëval avë hnë nkal Kanan nte lëɗahnëɓu ŋi.” ");
INSERT INTO cou_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Më lehnëkowo: “Dëkënde alehn njiɗu tere rëm mën hna, hnënk mën hna, soŋe ayëkëlehnëhnehna ajë mën aỹi asëval.” ");
INSERT INTO cou_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Awa më rëƴëɓuha: “Ye liɗëfu ge ŋwëỹëk asëval a tëfiɗilohna?” ");
INSERT INTO cou_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Më ntëkwako: “Ahwëhn a W̃ënu ŋa ale rëfëɗëfu kwëlëkwël ỹa, umë faƴëɗëha mëleka lëw̃u ỹa haryënkw hu, ntiɗ caŋ uyas hu w̃a do njonëhniɗuha asëval avë hnënk mën ajë mën aỹi, avë tere rëm mën hna. ");
INSERT INTO cou_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ge njiru vëvë tere mën hna, ntihëtaɗëhi idëk nte lëkëhnëruho ŋa. Wëla ñoñ nuỹajëlihna, ɗëwanëɗila w̃eh.” ");
INSERT INTO cou_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ante tëkekëɓu dol ɗarël kolomba ŋi, aki njëfakëɓu: “Ahwëhn, W̃ën ale ryokuŋëhnëɗëfu Abëraham, ɗemarye caŋaryo uyas le yiɗëfu w̃i. ");
INSERT INTO cou_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tame kaɓi ɗarël kolomba li nkeɓu, tëƴëɗëfuha aryag ale yijëɗ ỹëry w̃ënka ŋa njëɗo siyawu toƴe w̃ënka wante ñëryëɗ nkwahn ntëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ge ntëkwako: ‘Këlami ciyary, do ñëryëhnëɗëfuhëhni fëna wayonkomb hu w̃i’, awa, njëtëɗëfu umë ye asëval ale ỹaryaryëɗuha ajë ale ryokuŋëhnëɗëfu ỹa.” ");
INSERT INTO cou_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ani gë fuhnahnëndu nësëlehna ŋa, tëkiko Rebeka, unkwahn ŋa nkus hna; më cëlëndak kolomba hna do ñëryi w̃ënka ŋa. Më rëƴëɓuha: “Këlami, ƴëɗërye siyawu.” ");
INSERT INTO cou_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Më nkwëtëndak ñap nkwahn uŋa do ntehno: “Ciyary, tac pëɗëɗëfuhëhni wayonkomb hu w̃i fëna.” Më siyaɓu do më pëɗëkëhni wayonkomb w̃a fëna. ");
INSERT INTO cou_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ga tëƴëɓuha bi mo hnagëka, më ntëkwako: “Betuwel ye rëm mën ỹa do Milëka gë Nahor hnagëka.” Awa më liɓuha nënk ŋa icëhn hna do wame ŋa vák hna. ");
INSERT INTO cou_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Më ryëkwëhnëɓu yëka ỹa nkal hna soŋe sëmbëw̃a Ahwëhn a, W̃ën ale ryokuŋëhnëɗëfu ỹa, Abëraham; camehnëɓuha soŋe ile njoko ƴam fo hnë aryag mbaỹ ale ryokuŋëhnëɗëfu ỹa. Koyëna koɗëfu yonëhnëw̃a ajë ale ryokuŋëhnëɗëfu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tame, pëƴaryino ge kahnëndarun alinëhnuna ifërën ale ryokuŋëhnëɗëfu ỹa. Ge koɗiluhna, njiɗëfu sëñ haw̃ary.» ");
INSERT INTO cou_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban gë Betuwel më ntëkwaniha: «Ahwëhn a W̃ënu ŋa fëhnak koyëna. Ñoñ koɗilëfuhna hnësëfu. ");
INSERT INTO cou_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ani nke, haryënkw hu. Ƴoryehna nke asëval ajë ale ryokuŋëhnëɗu ỹa, gante ntehnëk Ahwëhn a W̃ën ka.» ");
INSERT INTO cou_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aryokuŋëhn Abëraham ỹa ga nkwëryëk waŋi wanës, më ndëkwëhnëk yëka ỹa nkal hna do camehna Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tac më canik waryiɓ walëw̃u hna vile ryëhwarik koryi gë sanu do gë wafand njëɗahna Rebeka; më njëɗakëhni fëna waɓuña wakwëhn nafa sankaf vëhni acëru gë hnëmu fandag fa. ");
INSERT INTO cou_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Aryokuŋëhn Abëraham ỹa gë vële lapëhnakawo va tokëniho do ceni, tac njilehnëni ndakëni. Ga pacëk g'acahnëfëɗ ga, nte matëni ŋa, aryokuŋëhn Abëraham ỹa më ntehnëkëhni acëru gë hnëmu Rebeka: «Napëryino vokawu gë ale ryokuŋëhnëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Më ntëkwaniha: «Rebeka ani nkoɗ ten toƴe, soŋe wafac ipëhw, tac koɗ njinti.» ");
INSERT INTO cou_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Aryokuŋëhn Abëraham ỹa më mbok ntehnëk: «antë avëỹehnuno, kaɓi Ahwëhn a W̃ënu ŋa caŋëndanëk nkaw̃ mën ŋa. Tavëryino vokawu gë ale ryokuŋëhnëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Më ntehnëniha: «Macënëfuna aryag aỹi do tëƴina ile nahak ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Awa më macëniha Rebeka do tëƴëniha: «Ñaɗu bi arëfëlu aỹi asan?» Më ntëkwakëhni: «Ha, ñaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Awa më tavëniha Rebeka gë asëval ale hnihnëɗëhawo ỹa tëfëlëni gë aryokuŋëhn Abëraham ỹa do gë vële lapëhnajëkawo va. ");
INSERT INTO cou_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Më ndëwanëniha Rebeka aki: «Araɓi aye, wëjë ahery fu ỹi, hnëm waɓulunda waƴaɓah. Araɓi vutah hu va nufëni wahnaw̃ vële ỹew̃ëki va!» ");
INSERT INTO cou_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka gë vësëval vële ryokuŋëhnëɗëhawo va më kaƴëni wayonkomb hna soŋe tëfëlëni gë aryokuŋëhn Abëraham ỹa do njini ndampo fo. ");
INSERT INTO cou_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Awa hnë wati rac, Isak, aju Abëraham, matëko kolomba le w̃aciko Lahayi-Royi hna pakëta hnë resiỹo Negev hna fo. ");
INSERT INTO cou_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Hnë anëka ndampo cahnëko nji nkwërëtalehnënd gë igwac, më nukëhni taŋ wayonkomb ga tëkiɗëni. ");
INSERT INTO cou_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka ga nuka Isak, më ntëɗak yonkomb hna ");
INSERT INTO cou_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","do tëƴa aryokuŋëhn Abëraham ỹa: «Mo ye asan ale yijëɗ pankëlin igwac li?» Aryokuŋëhn Abëraham ỹa më ntëkwak: «Ale ryokuŋëhnëɗëfu ỹa ye.» Awa Rebeka cënkalehn taŋ yëka ỹa tufahnahn ntënah ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Aryokuŋëhn Abëraham ỹa më tëfëtanëka Isak fop ile ntijëk ỹa. ");
INSERT INTO cou_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tac Isak më njoka Rebeka hnë usank le yeho va Sara hnëmu ỹa. Isak nufëkawo ñëla do ŋahnëkawo. Koyëna nduñënako Isak aju Abëraham icëm hnëmu Sara ŋa. ");
INSERT INTO cou_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abëraham ñëlëkawo asëval ahaw̃ary. Ketura maciko. ");
INSERT INTO cou_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nagëhnëkawo: Simëra gë Yokësan gë Medan gë Madiyan gë Isebak do gë Suwa. ");
INSERT INTO cou_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokësan yeho rëmu Saba gë Dedan ỹa. Hnë viju Dedan hna naginiho waɓulunda Wa-asur w̃a, gë Waletus w̃a, do gë Walewum w̃a. ");
INSERT INTO cou_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan yeho rëm Efa ỹa, gë Efer, gë Hanok, gë Abida, do gë Elëda. Vëỹi fop vërah vutah Ketura yeho. ");
INSERT INTO cou_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Abëraham njëɗëkëhniwo ɓuña viju vësëvalu vëỹëntaw̃ va wati nte nkoko cëmëna ŋa. Tac cañëtëkëhniwo ŋaw̃ëtaniha Isak, gë cape pëhna lav ka, ɓare Isak umë lëw̃ëko hnapul rëmu ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abëraham nuỹako wabëhn keme gë wafëhw imbëɗ gë wahi g'imbëɗ (175) cëmat. ");
INSERT INTO cou_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Hn'untaf ƴaryah nëŋah cëmëko nji tëkëhëhni vacërakëlo vantëw̃u va. ");
INSERT INTO cou_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isak gë Isëmayel viju, më mbañëniha hn'uhary Makëpela hna, ule yeho hn'ikaỹ Efëron aju Sohar, avë ɓulunda Het, ɗarël Mamëre hna. ");
INSERT INTO cou_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abëraham hnë ɓulunda Het hna ntaw̃ëko kaỹ tac. Hnam mbañiko Abëraham ɗarël asëvalu Sara. ");
INSERT INTO cou_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ante cëmëko Abëraham ŋa, W̃ënu ŋa ndëwanëkawo aju Isak. Isak ɗarël kolomba Lahayi-Royi hna ntëɗëko. ");
INSERT INTO cou_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Wëli itëfëta soŋe tere Isëmayel, aju Abëraham, ale nagënihawo gë Agar, aramp Sara avë Esipët ỹa. ");
INSERT INTO cou_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aki nke wamac vutah Isëmayel va gante tëfëlëni hnagi ka: fandënkwëryënkw fa Nëbayot maciko, tac fakigëna fa Kedar, gë Adëbel, gë Mibësam, ");
INSERT INTO cou_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","gë Misëma, gë Duma, gë Masa, ");
INSERT INTO cou_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","gë Hadad, gë Tema, gë Yetur, gë Nafis, do gë Kedëma. ");
INSERT INTO cou_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Waŋi ye wamac vutah pëhw gë vuki (12) vumba Isëmayel va. Ale-wo-le asankaf ɓulunda yeho; wamac wadëw̃ hni ŋa macahnëniho vankol vantëw̃ hni va gë wëryaha walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isëmayel wabëhn keme gë wafëhw warar g'imbëɗ gë waki (137) nuỹako ante cëmëko nji tëkëhëhni vacërakëlo vantëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Vëva Isëmayel va hnë resiỹo le yeho yëbëlan Havila gë Sur hna ntëɗëniho. Sur ɗarël Esipët hna nkeho, gë cape Asur. Ŋaw̃ëtanihëhniwo vutah Abëraham vuñëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Wëli itëfëta soŋe tere Isak, aju Abëraham ỹa. ");
INSERT INTO cou_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ante nuỹako Isak wabëhn wafëhw wahnah ŋa (40), ñëlëkawo Rebeka. Rëmu ỹa Betuwel yeho, avë ɓulunda Aram mbë Padan-Aram ỹa, do acëru ỹa Laban yeho. ");
INSERT INTO cou_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ɓare Rebeka nagëɗilohna; awa Isak më këlaka Ahwëhn a W̃ënu ŋa soŋe asëvalu ỹa. Ahwëhn a W̃ënu ŋa maw̃ëhnëkawo këla dëw̃u ŋa do Rebeka ndonkëko. ");
INSERT INTO cou_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Vucëp ndonkëko, do vutah vutac peñëlëɗëniho ɗonk dëw̃u hna. Awa Rebeka më ntehnak: «Ye ga fëlako ami?» Më njik tëƴa Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ahwëhn a W̃ënu ŋa më ntehnëka: «Wayal wahi yehëhna ɗonk hu hna, waɓulunda waki waỹew̃ëlah hnagëɗu. Ryampo yaw̃ëɗ ntëba ỹëntaw̃ ỹa, do fandënkwëryënkw fa rëkëɗ ndokuŋëhnënda aheryu.» ");
INSERT INTO cou_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ante tëkëkëko wati hnag ŋa, pacëkëhniwo vucëp ndonkëko. ");
INSERT INTO cou_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Avëntah had kombo ryënkwiko nagi. Wëñahn fo nkehawo mbahn iŋa had acuɗ cuɗak. Soŋe rac macahniko Esawu. ");
INSERT INTO cou_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tac nagëgik aheryu. Itak Esawu ŋa pëlako do Sakob maciko. Isak wabëhn wafëhw imbëɗ gë ryaw̃ (60) kwëhnako nte naginiho ŋa. ");
INSERT INTO cou_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Vutah va naỹëniho. Esawu asary asankaf yeho, gë fëk nkeɗëho kwëlëkwël; ɓare Sakob, asan ayamah yeho, ŋaw̃ëɗilohna tere ỹa. ");
INSERT INTO cou_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak Esawu ñako ñand, kaɓi faỹar fa ñaɗëho ɗus, ɓare Rebeka asëvalu umë, Sakob ñako ñand. ");
INSERT INTO cou_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Fac ryampo Sakob hnëg nëgëɗëho ante mënciko Esawu g'icary ka. Mbërako do inte yokawo ɗus. ");
INSERT INTO cou_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esawu më ntehnëka Sakob: «Mbëraɓu ɗus. Këlami, tavërye roku ile hnëgëru ỹi, ñaɗëfu roku iỹi roka vëntah.» (Soŋe rac macahnik Esawu «Edom», kaɓi umë fëhnëtanëk vëntah.) ");
INSERT INTO cou_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Sakob më ntëkwaka: «Maw̃ëryanërye ten intëw̃ nte rëfëka fandënkwëryënkw fa.» ");
INSERT INTO cou_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu më ntehnëka: «Inte ŋa ɗaw̃ iŋa nkeho. Ye ga nëfaɗëho intëw̃ nte rëfëka fandënkwëryënkw fa?» ");
INSERT INTO cou_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Sakob më mbok ntehnëka: «Dëkënde ten.» Awa Esawu më ntëkëk do nkwëcët koyëna intëw̃ nte rëfëka fandënkwëryënkw fa. ");
INSERT INTO cou_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Awa Sakob më nëhëtëhnëka roka ỹa. Esawu më tokëk do ciya, tac njilehn. Koyëna njafaŋëko Esawu intëw̃ nte rëfëka fandënkwëryënkw fa. ");
INSERT INTO cou_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mboko nke inte nkal hna had nte yeho hnë ƴamani Abëraham ŋa. Soŋe rac Isak njiko Gerar hn'ile nkeho Abimelek ahnaw̃ Wafilisëte w̃a. ");
INSERT INTO cou_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ahwëhn a W̃ënu ŋa më karyëtahnëka Isak do ntehna: «Antë ayi gë Esipët, dëɗënti hnë nkal nte rufëɗëmi hna. ");
INSERT INTO cou_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ñëw̃ëry hnë itac. G'ami nkeɗe do ndëwanëɗëmi, kaɓi wëjë gë fop vutah hu va gë vutah hni va yëɗaɗëfu waỹi wayal. Koyëna ntiɗëfu ile lehnëɓuhawo rëmuh Abëraham ntinëhnëɗëfuha ỹa. ");
INSERT INTO cou_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ntiɗëfu njaɓëni vutah hu va had gë wahol wavë g'ambin ki, do njëɗaɗëfuhëhni iŋi nkal fop. Waɓulunda waɓë nkal ŋi fop gë vëhni ndëwanëɗeni, ");
INSERT INTO cou_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kaɓi Abëraham maw̃ëhnëko wanës mën ŋa, gë vakwëɗa mën va, do gë sariya mën ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Awa Isak ntiko ile ntehnëkawo W̃ënu ŋa, ntëɗëko Gerar hna. ");
INSERT INTO cou_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Vahnë vëvë hnam va tëƴënihawo soŋe asëvalu ỹa. Më ntëkwakëhni ntehn aheryu ye: ɗëkëɗilohna ntehn Rebeka asëvalu ye, kaɓi ntakëkawo antë ndaw̃i soŋe lëw̃u ỹa, kaɓi nkwamëko ɗëcët. ");
INSERT INTO cou_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak mbiỹëko hnam. Hnë fac ryampo Abimelek, ahnaw̃ Wafilisëte ỹa, fenetër hna njëkëɗëho. Më nuka Isak ga nëhandëha nëh nte rufahnëɗ Rebeka asëvalu ye. ");
INSERT INTO cou_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Më macehnëka do ntehna: «Pacëk asëval hu ye! Awa soŋe ye lehnëru ahery hu ye?» Isak më ntëkwak: «Nësëɓu koyëna kaɓi ntakëko antë ryaw̃iwu soŋe lëw̃u». ");
INSERT INTO cou_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek më mbok ntehnëk: «Ye liruhëfu koyëna? Ge mbiỹakënd toƴe aryampo avë ɓulunda mën nufakëndëha asëval hu, do koyëna menehnakënduhëfu.» ");
INSERT INTO cou_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tac Abimelek më mbañëhnëkëhni ɓulunda ỹa fop ntehnëhni: «Ge ahnë ỹakëka aỹi asan ma asëvalu ndaw̃ëɗe.» ");
INSERT INTO cou_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Hnë bëhn rac, Isak njamëko hnë nkal tac do mbarëpëko roka yaɓah kaɓi Ahwëhn a W̃ënu ŋa ndëwakawo. ");
INSERT INTO cou_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Uhwëhna lëw̃u w̃a nkwënaɗëho kwëlëkwël, do nkwënaɗëho ɓeta ŋa. ");
INSERT INTO cou_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kwëhnako vantega wape gë wuhnankal do gë wuhni, gë vëryokuŋ vëyaɓah. Awa, Wafilisëte w̃a më ñew̃aryëniha Isak. ");
INSERT INTO cou_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Më mbëw̃ëni fop wakolomba wante nkabëniho vëryokuŋ rëmu Abëraham ante nkoko cëmëna ten ŋa. ");
INSERT INTO cou_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tac Abimelek më ntehnëka Isak: «Njaɓëki ɗëcët fanka fa alëbëfu fuhnë; kërënary ani.» ");
INSERT INTO cou_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Awa Isak më kërënak hnam; nji ndah hnë garyëla Gerar hna do ntëɗ hnam. ");
INSERT INTO cou_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Më nkëƴëtehnëk wakolomba wante yabiko nte nkoko cëmëna ten rëmu Abëraham do mbëw̃ëniho Wafilisëte nte cëmëko Abëraham ŋa. Më mbokaryëk mac wakolomba ŋa wamac wante macëko rëmu ŋa dënk. ");
INSERT INTO cou_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Fac ryampo, vëryokuŋ Isak va nkabëniho kolomba do pëhnëniho w̃ënka wante yalëɗëho gë fanka. ");
INSERT INTO cou_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Vëhery wusaw̃ Gerar va gë vëva Isak va conkëniho. Vëhni lehnëɗëho: «Fuhnë hwëhnëk w̃ënka ŋi.» Isak më macëk hacëm hatac Esek, umë fëhnëtanëɗ «Sonko», kaɓi vëhery wusaw̃ va conkëniho g'umë. ");
INSERT INTO cou_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Awa vëryokuŋ Isak va nkabëniho kolomba haw̃ary, do mboko nke kat sonko soŋe hatac fëna. Isak më macëk kolomba rac Sitëna, umë fëhnëtanëɗ «Gwajëtël». ");
INSERT INTO cou_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Më matëk hnam do mbok nkabehn kolomba rarëna; rac ƴojëlohna sonko. Më macëk Rehobot, umë fëhnëtanëɗ «Igwac Ƴankah». Ntehnaɗëho: «Tame, Ahwëhn a W̃ënu ŋa njankënëhnëkëfu, soŋe mbetahnin hnë iŋi nkal.» ");
INSERT INTO cou_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Më matëk hnam nji Berëseba. ");
INSERT INTO cou_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ahwëhn a W̃ënu ŋa më karyëtahnëka hn'umëɗ nte ryaviko hna do ntehna: «W̃ën rëmuh Abëraham ỹa yeɓu. Antë ntaki iñë kaɓi gë wëjë nkeyik do ndëwaɗëmi njaɓënëɗëfuhëhni vutah hu va gë vutah vuntëw̃ hni va soŋe aryokuŋëhn mën a Abëraham.» ");
INSERT INTO cou_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isak ntiko hnam hn'ile cënaɗe saɗëha njëfaɗëhawo W̃ënu ŋa do Ahwëhn a W̃ënu ŋa macëɗëhawo. Ntiko usank lëw̃u w̃a do vëryokuŋ vëlëw̃u va nkabëniho kolomba haw̃ary. ");
INSERT INTO cou_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Awa ahnaw̃ a, Abimelek, matëko Gerar hna nji njëkehna. Gë Ahusat, lawo lëw̃u ỹa, nkeniho do gë Pikol, asankaf wasoɗaɗe walëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak më tëƴëkëhni: «Soŋe ye yijërun ayëkuno, w̃uhnë vële ỹew̃ëko do lajëko ỹal hun hna?» ");
INSERT INTO cou_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Më ntëkwaniha: «Kamahnëɓun Ahwëhn a W̃ënu ŋa gë wëjë nkerun, do nahaɓun tëfëka kwëtëlin wëjë gë fuhnë, akwëtëla nte lëkik. ");
INSERT INTO cou_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Awa dëkëndifu alehn diɗilihëfuhna uw̃eh, kaɓi diyilihna këm fo; ifërën fo linëhniru, do taviru ayi ƴam. Do tame, asan ale njëɗëk Ahwëhn a W̃ënu ŋa yeru.» ");
INSERT INTO cou_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isak më ntëvakëhni. Tokëni do ceni. ");
INSERT INTO cou_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ga pacëk nëganiho do ntëkëni vëhni fop soŋe nkwëryëla ntëw̃ hni ŋa. Më koyalëni gë Isak njilehnëni ƴam. ");
INSERT INTO cou_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hnë fac rac dënk, vëryokuŋ Isak va njijëniho pëƴaniha Isak ntehnëni pëhnëni w̃ënka hnë kolomba haw̃ary le nkabëni ỹa. ");
INSERT INTO cou_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isak më macëk kolomba rac «Kolomba Idëk». Soŋe rac hafo dol inaw̃ iŋa Berëseba nkok macëɗe —umë fëhnëtanëɗ «Kolomba Idëk». ");
INSERT INTO cou_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu wabëhn wafëhw wahnah (40) kwëhnako ante ñëlëkëhniwo vësëval Wahit wahi va, Yehudit, aryag Beri ỹa, do gë Basëmat, aryag Elon ỹa. ");
INSERT INTO cou_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Vësëval vërac ndëñehnënihëhniwo vëhni Isak g'asëvalu Rebeka. ");
INSERT INTO cou_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Awa, Isak, ante cërëko ŋa, golohna nund. Fac ryampo më macëka Esawu, aju aryënkwëryënkw alëw̃u ỹa, do ntehna: «Ajë mën!» Më mëtaka: «Nëpami.» ");
INSERT INTO cou_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak më ntehnëka: «Nuru, ntafëɓu do ƴëtëla bi guve cëmëɗëfu. ");
INSERT INTO cou_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Awa tame, nufëry uŋwary hu ŋa gë wëca hu ŋa ayi g'icary. Ƴonëhne faỹar, ");
INSERT INTO cou_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","do ahnëgëhno, gante ñaɗëfu ka, ahnëhëtëhno roku, tac ndëwanëɗëmi ani gë sëmahnëndu.» ");
INSERT INTO cou_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hara Rebeka nëpaɗëho ile nësëhnëɗëhawo Isak aju Esawu ỹa. Njind tuŋ umë g'icary soŋe njoj faỹar fa, ");
INSERT INTO cou_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka më ntehnëka Sakob aju: «Nkwëryëɓuha rëmuh ga ntehnëɗëha acër hu Esawu: ");
INSERT INTO cou_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Ƴonëhne faỹar tac ahnëgëhno gante ñaɗëfu ka. Ge tokëɓu, ndëwanëɗëmi haryënkw Ahwëhn a W̃ënu ŋa ani gë sëmahnëndu.” ");
INSERT INTO cou_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Awa tame, ajë mën, nëparye ɗus do diry ile rëƴëɗëmi ỹa. ");
INSERT INTO cou_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ƴiry cery wahnankal hna do ƴonëhnew̃ëhni vunankal vuki vupërën. Nëgëhnëɗëfuha rëmuh gante ñaɗ ka. ");
INSERT INTO cou_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Njinenëhnëɗuha tok, tac ndëwanëɗëhi ani gë cëmahnënd.» ");
INSERT INTO cou_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Sakob më ntëkwaka: «Esawu wëñahn fo nkeha mbahni ŋa, ɓare ami gelohna. ");
INSERT INTO cou_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ge ñakëko apa, njëtëɗ ñaɗëfu rokaw̃a, do uw̃eh ndëwanëɗëho; geɗina fërën.» ");
INSERT INTO cou_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hnëmu më ntëkwaka: «Ge koyëna nke, araɓi wameh watac nkewo ami, ajë mën! Nëparye tuŋ do ƴinëndew̃ëhni vunankal va.» ");
INSERT INTO cou_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Awa Sakob njinëhnëlehnëhni njojëhni do njëɗahna hnëmu. Rebeka më nëgëhnëka Isak roka hnëŋah gante ñaɗ ka. ");
INSERT INTO cou_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tac më nufëk viỹi Esawu aju aryënkwëryënkw a vile ỹak wamëk, yeho tere va, do cuɗa Sakob, aju ahigëna ỹa. ");
INSERT INTO cou_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Më përyëka gë waƴand wuhnankal w̃a wëɓák ŋa g'igëb iŋa ");
INSERT INTO cou_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","do njëɗahna hnëhët hnëŋah gë mburu le nëgëko ỹa. ");
INSERT INTO cou_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Më njiryeryëk vëhni rëmu hna do ntehna: «Apa!» Isak më ntëkwaka: «Nëpami, ajë mën; ɓare pëƴarye bi mo yeru.» ");
INSERT INTO cou_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Sakob më ntëkwaka rëmu: «Ami Esawu ye, ajë hu aryënkwëryënkw a. Ntiɓu ile rëƴëruho ỹa. Awa ƴij alaña arok faỹar mën fa; tac njëɗaɗuho ɗëwara hu ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak më tëƴëka: «Hak ntiru ahnuỹahni faỹar ñap aki, ajë mën?» Sakob më ntëkwaka: «Ahwëhn a W̃ënu ŋa, W̃ën hu ŋa, yojëka nkaw̃ mën hna.» ");
INSERT INTO cou_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak më ntehnëka: «Tëhaj, ajë mën, ỹaki yëtahnu bi paryi ajë mën a Esawu yeru.» ");
INSERT INTO cou_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Sakob më tëhaka rëmu; Isak më ñakëka do ntehn: «Hohna ha, va Sakob ỹa ye, ɓare wëɓák ŋa wëɓa Esawu ŋa ye.» ");
INSERT INTO cou_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ƴavëtëlawohna kaɓi wëɓák wadëw̃u ŋa wëñahn fo nkeho had wëɓa Esawu ŋa. Ɓare njëɗahnënda ɗëwara lëw̃u ỹa, ");
INSERT INTO cou_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","mboko tëƴa kat: «Paryi bi ajë mën a Esawu yeru?» Sakob më ntëkwaka: «Ha.» ");
INSERT INTO cou_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isak më mbok ntehnëk: «Nëhëtënde, ajë mën, roku faỹar hu fi do yëɗaỹi ɗëwara mën ỹa.» Sakob më nëhëtëhnëka rëmu Isak tok, më njonëhnika uñen do ce. ");
INSERT INTO cou_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tac Isak më ntehnëka Sakob: «Tëhaj do aw̃uryawo, ajë mën!» ");
INSERT INTO cou_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Sakob më tëhak do muryahna. Isak tehëkawo viỹi vile yeho viva Esawu va, tac më ndëwanëka aju Sakob aki: «Paryi nke rehëry a ajë mën a ye! Had ikaỹ nte ndëwak Ahwëhn a W̃ënu ŋa nke. ");
INSERT INTO cou_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","«Araɓi W̃ënu ŋa njëɗi waw̃ënk wale yojëɗ g'ambin w̃a, inkal nte wufak, roka g'uñen ƴaɓah. ");
INSERT INTO cou_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Araɓi wayalu ndokuŋëhnëndënihi, araɓi waɓulunda ndëkwëhnëhnëndënihi. Gery asankaf vëhery hu, Araɓi ndëkwëhnëhnëndënihi! Ale ryëwanëki uw̃eh a, araɓi umë fëna nuỹa rac! Ale ryëwanëki ufërën a, araɓi umë fëna nuỹa rac!» ");
INSERT INTO cou_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ante puhnak Isak ɗëwan Sakob ŋa, Sakob më cahnëk do hnë wati rac dënk tëkiɗëho Esawu g'icary. ");
INSERT INTO cou_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Më nëgëk, umë fëna, roka hnëŋah, njinenëhna rëmu do ntehna: «Matëry, Apa, arok faỹar fale yonëhnimi fa; tac njëɗaɗuho ɗëwara hu ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak më tëƴëka: «Mo yeru?» Më ntëkwak: «Ami, Esawu ye, ajë hu aryënkwëryënkw a.» ");
INSERT INTO cou_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Awa Isak pëmpëhnahnëkawo ɗus hafo mbalënda mbahn iŋa fop do ntehn: «Mo ga ye, awa, ale saryëk do yonëhnekëho faỹar aỹi? Fop tokëɓu arëkahnind ỹa do njëɗaɓuha ɗëwara mën ŋa; do nkoryaryëɗ ɗëwara rac!» ");
INSERT INTO cou_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esawu ga nkwëryëk wanës rëmu ŋa, ntavëkawo ɗus, pëgwëlehn ndekand ɗus do këlahna rëmu: «Apa, ɗëwanërye, ami fëna!» ");
INSERT INTO cou_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ɓare Isak më ntëkwaka: «Ahery hu njijakëh do tokako. Nufëk ɗëwara le rëfëkawo ahnuỹa ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu më ntëkwaka: «Sakob! Paryi nke uw̃ac ule rëfëka w̃a kwëhnak —Aroka Vahnë— kaɓi tokako wahwënta wahi! Ucër uŋa ntenëhnëko ten do tame wëli nufëk ɗëwara mën ŋa!» Esawu më nkwënëk: «Goryaryëlihna bi ɗëwara soŋe lëmën?» ");
INSERT INTO cou_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak më ntëkwaka: «Sakob liɓu asankaf hu ỹa, do njëɗaɓuha vëlëw̃u va fop nkeni vëryokuŋ vëlëw̃u. Maw̃ëryanëɓuha roka ỹa do g'uñen ƴaɓah. Ye wok soŋe wëjë, ajë mën?» ");
INSERT INTO cou_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu më mbok tëƴëka rëmu: «Iɗëwara ɗampo tac fo bi hwëhnaruho? Apa, ɗëwanërye ami fëna!» Do pëgwëlehn kond ɗus. ");
INSERT INTO cou_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tac rëmu më ntëkwaka aki: «Idëɗ hu ŋa ŋaw̃ëtaɗ nkal gufak ŋa, ŋaw̃ëtaɗ waw̃ënk wale yojëɗ g'ambin w̃i. ");
INSERT INTO cou_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ɗuniỹa hu ỹa fop uw̃ët g'ule fo yeɗ, do rëkëɗu aryokuŋëhnënda ahery hu. Ɓare afaya fo rëkëɗu aw̃ërëtalehnënd, nkubëɗu sug le ryiɓëndëɗeru ỹa do ntoŋëɗu.» ");
INSERT INTO cou_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawu më ñew̃ëka Sakob soŋe iɗëwara le ndëwanëkawo rëm hni ŋa. Më ntehnak: «Apa ɓiỹëɗina cëmëɗ. Awa tac ndaw̃ëɗëfuha ahery mën aỹi, Sakob.» ");
INSERT INTO cou_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ga njëtak Rebeka ile pëhnak Esawu ỹa, më macehnëka Sakob do ntehna: «Acër hu, Esawu, ñaɗ nkwëcagi ndaw̃i. ");
INSERT INTO cou_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tame, ajë mën, nëparye ɗus do diry ile lehnëɗëmi ỹa: matëry ayary vëhni acër mën hna Laban, Aran hna. ");
INSERT INTO cou_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ñëw̃ëry hnam, hafo acër hu njama sakahn ha. ");
INSERT INTO cou_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ge njamëka do ndënkw ile liruha ỹa, awa paƴehnëryiɗëfu ayinëhnëryiyi. Ñaɗa raku w̃uhnë vëhi tak hnë fac ryampo.» ");
INSERT INTO cou_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka më ntehnëka Isak: «Gona nëŋahno ɗuniỹa ỹi soŋe vësëval Wahit ajë mën Esawu vi. Ge Sakob, umë fëna, ñëlëka aryampo hnë vësëval vëvë hn'iŋi nkal vi, goɗina tëfo wow̃ ɗuniỹa li!» ");
INSERT INTO cou_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Awa Isak më macëka Sakob, koyalëni do tac ndëwana tac ntehna aki: «Ñëlëɗilihahna asëval avë nkal Kanan. ");
INSERT INTO cou_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ƴiry Mesopotami, vëhni Betuwel rëmu hnëmuh hna. Ƴëkëlehnaryehna hnam asëval, aryag Laban, acëru hnëmuh. ");
INSERT INTO cou_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Araɓi W̃ën Hwëhn Fanka Fop ŋa njëɗi vutah vunjaɓah, ayehahn rëm waɓulunda waƴaɓah. ");
INSERT INTO cou_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Araɓi njëɗu wëjë gë vutah hu va gante njëɗëkawo Abëraham ka, soŋe areɓahnëhni inkal nte lëɗantu ŋi vële hwëhnëk va, inkal nte njëɗakawo W̃ën Abëraham ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Awa Isak më cañëtëka Sakob nji Mesopotami, vëhni Laban hna, nte yeho aju Betuwel Aram ỹa do yeho fëna acëru Rebeka ỹa, hnëmu Sakob gë Esawu. ");
INSERT INTO cou_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu njëtako Isak ndëwanëka Sakob do cañëtëkawo nji njëkëlehnaja asëval Mesopotami hna. Njëtako fëna ante ndëwanëɗëhawo Isak Sakob ŋa mbañëhnëkawo antë ñëla asëval avë inkal Kanan, ");
INSERT INTO cou_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","do Sakob ntënënëkëhniwo vëhni rëmu gë hnëmu do njiko gë Mesopotami. ");
INSERT INTO cou_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Koyëna Esawu njëtako rëmu Isak nëŋëlawohna gë vësëval vëvë Kanan va. ");
INSERT INTO cou_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Awa Esawu më pëhnak njëkëlehnahna asëvëval ahaw̃ary. Më njik vëhni Isëmayel hna, aju Abëraham, do njëkëlehnahna ñëla aryagu, ale w̃aciko Mahalat, aheryu Nëbayot. ");
INSERT INTO cou_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hnë wati rac matëko Sakob Berëseba hna soŋe nji Aran. ");
INSERT INTO cou_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kaɓi njoko lav w̃a, më ndakëk hn'ile tëkëko hna. Do itaka nufëko nkagëtahn hnam. ");
INSERT INTO cou_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Umë ndakeryëk: më nuk ihëƴa sëɓiko nkal li hafo tëk ambin hnani. Wamëleka W̃ënu ŋa kaƴëɗëhniho cëlindëni. ");
INSERT INTO cou_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ahwëhn a W̃ënu ŋa umë dënk kahnëko haryënkw lëw̃u do ntehna: «Ahwëhn a W̃ënu ŋa yeɓu, W̃ën rëmuh sankaf Abëraham ŋa do gë W̃ën Isak. Inkal Kanan nte ryakantuŋi njëɗaɗëmi wëjë gë vutah hu va. ");
INSERT INTO cou_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Vutah hu va njaɓëɗëni had ivëɗ nkal ŋi; ɗuniỹa li fop ntëɗëɗëni: gë cape pëhna lav, g'ajoya lav, gë cape rëhw do g'irahahn. Soŋe lëw̃ hu ỹa ndëwanëɗëfuhëhni ƴam vahnë vëvë ɗuniỹa vi fop. ");
INSERT INTO cou_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Antë aryënkw! Gë wëjë nkeyik, keryëɗëmi hn'ile-wo-le njiɗu hna do mbokaryiɗëmi hn'iŋi nkal. Tavëɗila, ntiɗëfu fop ile hnësëhnëmi ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Sakob më nëgak do ntehn: «Paryi nke, Ahwëhn a W̃ënu ŋa ani nke, do ami ƴëtëlëw̃ohna!» ");
INSERT INTO cou_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Më ntakëka do ntehn: «Hn'ani, ỹëw̃a W̃ën ye! Paryi nke cery W̃ënu ŋa ye do gë rënka ambin ŋa!» ");
INSERT INTO cou_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Sakob më nëgak koɓëri fo g'acahnëfëɗ ga, do nuf taka nte nkagëtahnëko ŋa, cëɓ tac tur wagu soŋe nti taka ŋa nke taka W̃ën. ");
INSERT INTO cou_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Më macëk ỹëw̃a rac Betel, umë fëhnëtanëk «Cery W̃ën». Ɓare koɓëri ŋa Lus macëɗeho hnam. ");
INSERT INTO cou_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tac Sakob më ntëkëk aki: «Ge W̃ënu ŋa g'ami nke, ge keryëko hn'uyas mën hna, ge njëɗako ile rokëɗëfu do ile liyaɗëfu, ");
INSERT INTO cou_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","do ge mbokajëɓu ƴam fo vëhni rëm mën hna, awa Ahwëhn a W̃ënu ŋa W̃ën mën yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iŋi taka nte sëɓëɓu do rurëɓu wagu ŋi yeɗ ỹëw̃a le sëmbande W̃ënu ŋa; do umë rëkëɗëfu yëɗandu ihwëhn pëhw-wo hn'ile maw̃ëryanëɗëho W̃ën hna fop.» ");
INSERT INTO cou_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Sakob kahnëtako paɓ gë cape pëhna lav ka. ");
INSERT INTO cou_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Fac ryampo, më nukëhni wakore watar wape gë wuhnankal yinëgaɗëho hnë kolomba fëk hna, kaɓi hnam ceɗëniho w̃ënka ŋa. Itaka cankaf fiɗahnëɗeho kolomba rac. ");
INSERT INTO cou_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ge fop mbarëpëlëniho wusaw̃ w̃a, vëhery wusaw̃ va ntihëtëɗëniho taka ŋa do ñëryëhnënihëhni wusaw̃ w̃a ciyani, tac mbokaryëni piɗëni kolomba ỹa g'itaka ŋa. ");
INSERT INTO cou_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sakob më tëƴëkëhni vëhery wusaw̃ va: «Wëlawo mën, ne nkejërun?» Më ntëkwaniha: «Aran.» ");
INSERT INTO cou_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Sakob më mbok tëƴëkëhni: «Njëtërunëha bi Laban, aju Nahor?» Më ntëkwaniha: «Ha njëtëɓunëha.» ");
INSERT INTO cou_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Sakob mbok tëƴëkëhni: «Hak nkok?» Më ntëkwaniha: «Aki fo nkok. Wëliha aryagu Rasel ga tëkiɗ gë wusaw̃ wulëw̃u w̃a.» ");
INSERT INTO cou_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Sakob më ntehnëk: «Lav a nkok, wati gwak wusaw̃ ŋa tëkëna ten. Pëɗëryinëhni do avokaryuni nkwënani ryav w̃a.» ");
INSERT INTO cou_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Vëheryëherya va më ntëkwani: «Koɗilëfuhna fëɗëfuni tameki ge wavarëpëlina fop. Ge padini, tac walihëtëfu taka nte fiɗahnik ŋi do yëɗafuni ciyani.» ");
INSERT INTO cou_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sakob nkoko nësëlëndëni gë vëhni tëket Rasel gë wusaw̃ rëmu w̃a, kaɓi ahery wusaw̃ yeho. ");
INSERT INTO cou_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sakob ga nuka Rasel do gë wusaw̃ acëru Laban w̃a, më tëhak kolomba ỹa, ntihëtëk taka ŋa do njëɗahni wusaw̃ acëru Laban w̃a w̃ënka ŋa ciyani. ");
INSERT INTO cou_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Tac Sakob më muryaka Rasel kotënd uhnatah w̃a. ");
INSERT INTO cou_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Më ntehnëka: «Rëmuh mbaỹ mën ye, Rebeka ye hnëm mën ỹa.» Awa Rasel nkaryëlehn pëƴahna rëmu watac. ");
INSERT INTO cou_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban, ga njëtak ajë acëru ỹa hnam nke, më nkaryëk kacahna, muryaka do njohna gë tere lëw̃u. Sakob më tëfëtanëka fop Laban ile yeha ỹa. ");
INSERT INTO cou_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban më ntehnëka: «Paryi nke mbaỹ mën yeru, sat rac fo hwëhnayik.» Ante ñëw̃ëko Sakob lepera w̃a fop vëhni Laban hna do ndokuŋëhnëndëhawo, ");
INSERT INTO cou_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","awa Laban më ntehnëka: «Mbaỹ mën iŋa yeru. Ɓare gena soŋe rac rëkëɗu aryokuŋëhnahnëndo aki fo. Pëƴarye bi waƴëhw rëkëɗëmi sosëndi.» ");
INSERT INTO cou_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hara Laban vëryag vëhi kwëhnako. Aryënkwëryënkw a Leya maciko, aheryu ỹa Rasel. ");
INSERT INTO cou_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya mëhwëryëkawo yëka ỹa, ɓare Rasel umë nkwamëko ɗus. ");
INSERT INTO cou_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Sakob ñaɗëhawo Rasel, më ntehnëka Laban: «Ndokuŋëhnëɗëmi wabëhn mbëɗ gë waki (7) soŋe ỹëlahnëw̃a Rasel, aryag hu ahigëna ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban më ntehnëka: «Yëɗayina wëjë fecehnëko gë le yëɗaɓuha asan ahaw̃ary. Gory ỹal mën li.» ");
INSERT INTO cou_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Awa, soŋe nuỹahna Rasel ỹa, Sakob ndokuŋëhnëkawo Laban wabëhn mbëɗ gë waki (7). Ɓare waŋi wabëhn ntiyahnëkawo had wafac fo ryëcëk, kaɓi ñaɗëhawo ɗus Rasel. ");
INSERT INTO cou_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tac Sakob më ntehnëka Laban: «Wabëhn wante hnësëliko ŋa padëk. Ƴëɗaryew̃a asëval mën a. Ñaɗëfu ỹëlëw̃a.» ");
INSERT INTO cou_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban më macehnëkëhni fop vële ntëɗëlahnëniho va do nëgehn roka sankaf soŋe ñël iŋa. ");
INSERT INTO cou_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ɓare g'umëɗ ga më nufëka aryagu Leya do njinehna Sakob, ndakëlahnëni g'umë. ");
INSERT INTO cou_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban aryokuŋ alëw̃u ale w̃aciko Silëpa nufëko njëɗahna aryagu nke aryokuŋ alëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ga pacëk Sakob kamahnëko Leya ye! Më ntehnëka Laban: «Soŋe ye liruho aki? Gena bi ỹëlahnëw̃a Rasel ryokuŋëhnëmi wabëhn mbëɗ gë waki (7)? Soŋe ye rokaruho?» ");
INSERT INTO cou_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban më ntëkwaka: «Gena namu ỹal fu li ñëli aryag hara acëru ỹa ñëlina ten. ");
INSERT INTO cou_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Puhnaryin ambënt ñël ŋa gë acëru tac njëɗaɗeruha aheryu fëna ge mbokëru aryokuŋëhno wabëhn mbëɗ gë waki (7).» ");
INSERT INTO cou_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Sakob më maw̃ëk: puhnani gë Leya wafac imbëɗ gë wahi ambënt ñël ŋa, tac Laban më njëɗaka Rasel. ");
INSERT INTO cou_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Rasel, umë, Laban aryokuŋ ale w̃aciko Bila njëɗakawo nke aryokuŋ alëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Sakob ndakëlahnëniho gë Rasel do ñaɗëhawo ntëbi Leya; do tac mbok ndokuŋëhna Laban wabëhn mbëɗ gë waki kat. ");
INSERT INTO cou_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ahwëhn a W̃ënu ŋa ga nuk Rasel ỹahniko ntëbi Leya, më ntika Leya nagënk, hara Rasel koɗilohna nag. ");
INSERT INTO cou_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya ndonkëko, do naga facan fante macëko Riben. Më lehnëko: «Ahwëhn a W̃ënu ŋa nuk sëfëhnah mën w̃a; tame asan mën a rëkëɗ ñando.» ");
INSERT INTO cou_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya më mbok ndonkëk do mbok naga facan. Më mbok ntehnëk: «Ahwëhn a W̃ënu ŋa njëɗakow̃a facan fakaw̃ary kaɓi njëtak ñaɗelëw̃ohna.» Umë, Simeỹo macik. ");
INSERT INTO cou_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya më mbok ndonkëk kat do mbok naga facan fatarëna. Më mbok ntehnëk: «Aŋ'ankaw̃ asan mën aỹi paɓëɗëho, kaɓi nagëhnëɓuha vucan vutar.» Soŋe rac macahnëkawo Sakob facan fatac Levi. ");
INSERT INTO cou_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leya më mbok ndonkëk. Tac mbok naga facan do ntehn: «Aŋ'ankaw̃, njëw̃ëɗëfu icëmb Ahwëhn a W̃ënu ŋa.» Soŋe rac macahnik aju Yuɗa. Tac tëryalehn hnag ỹa. ");
INSERT INTO cou_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rasel ga njëtëk koɗina nag, më ñew̃aryëka acëru vutah va. Më ntehnëka Sakob: «Diry hnagu, ge gena umë cëmëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Sakob më ntavëka g'umë do ntehn: «W̃ënu ŋa bi yeɓu, ami? Umë w̃ëỹëk antë ahnag.» ");
INSERT INTO cou_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasel më ntëkwaka: «Nufëryehna Bila, ale ryokuŋëndëho ỹi, aryaku soŋe nagëhni vutah; nufëɗëfuhëhni. Koyëna soŋe lëw̃u ỹa, nuỹaɗëfuhëhni, ami fëna, vutah.» ");
INSERT INTO cou_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Awa më njëɗaka aryokuŋ alëw̃u ỹa Sakob ndakëni. ");
INSERT INTO cou_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila ndonkëko do nagëhna Sakob facan. ");
INSERT INTO cou_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasel më ntehnëk: «W̃ënu ŋa kitiŋëk soŋe lëmën ỹa. Nkwëryëk imunta mën ŋa do maw̃ëk njëɗaw̃ow̃a ami fëna facan.» Soŋe umë macahnëkawo Dan. ");
INSERT INTO cou_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, aryokuŋëhn Rasel ỹa, mboko ndonk do mbok nagëhna facan fakigëna Sakob. ");
INSERT INTO cou_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasel më ntehnëk: «Mëtaryëɓuha ɗus acër mën a do mëkëɓuha.» Më macëka fatah fa Nefëtali. ");
INSERT INTO cou_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya, ga nuk gona nagënd, më nufëka aryokuŋëhn alëw̃u ỹa, Silëpa, njëɗahna Sakob ndakëni. ");
INSERT INTO cou_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silëpa nagëhnëkawo Sakob facan, ");
INSERT INTO cou_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","do Leya më ntehnëk: «Nkoc ŋa tëkik!» Do më macëka Gad. ");
INSERT INTO cou_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silëpa mboko nagëhn facan fakigëna Sakob. ");
INSERT INTO cou_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya mboko ntehn: «Nafa ỹa tëkik, tame vësëval va koɗëni ntehnëni nëfako.» Do më macëka fatah fa Aser. ");
INSERT INTO cou_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Fac ryampo, hnë wati ɓarëp roka hna, Riben njiko kaỹ hna do tëkat vutah atëh nte liɗëha ahnë përana ndakëntal do ndonk. Më njok njëɗahna hnëmu, Leya. Awa Rasel më ntehnëka Leya: «Këlami, ƴëɗërye vutah atëh ajë hu vi wëɗampo.» ");
INSERT INTO cou_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya më ntëkwak: «Asan ale reɓëruhow̃a ỹi geɗilihna bi gwër? Mbokëru aỹand areɓow̃a wadëwel atëh ajë mën ŋi!» Rasel më mbok ntehnëk: «Awa, umëɗ nte yejëk ŋi gë wëjë ndakëɗun Sakob nkwëcëtëli gë wadëwel atëh ajë hu ŋi!» ");
INSERT INTO cou_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","G'anëka ga ante mëncik Sakob kaỹ ŋa, Leya më kacaka do ntehna: «G'ami ndakëlahnëɗe dol: wadëwel atëh ajë mën va sosahnëɓu hnuỹahni.» Awa Sakob më ndakëlahnëni g'umë mëɗ tac. ");
INSERT INTO cou_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","W̃ënu ŋa maw̃ëko imunta Leya ŋa. Ndonkëko do nagëhna Sakob facan fambëryëna (5). ");
INSERT INTO cou_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Më ntehnëk: «W̃ënu ŋa cosëko kaɓi njëɗaɓuha aryokuŋëhn mën a asan mën a.» Do më macëka fatah fa Isakar. ");
INSERT INTO cou_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya mboko ndonk do mbok nagëhna Sakob facan fakwëhn mbëɗ gë fandaw̃ (6). ");
INSERT INTO cou_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Më ntehnëk: «W̃ënu ŋa njëɗako ɓuña wamah! Aŋ'ankaw̃ asan mën aỹi ntënënëɗëho, kaɓi nagëhnëɓuha vucan mbëɗ gë fandaw̃ (6).» Do më macëka fatah fa Sabilon. ");
INSERT INTO cou_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tac më nagëka facëval do maca Dina. ");
INSERT INTO cou_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Awa W̃ënu ŋa më nahaka Rasel, më maw̃ëk imunta dëw̃u ŋa do ntihna kol nagënd. ");
INSERT INTO cou_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Më ndonkëk do naga facan. Më ntehnëk: «W̃ënu ŋa ntihëtëko sëfëhnah mën w̃a!» ");
INSERT INTO cou_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Më macëka aju Yosef, ntehn: «Araɓi Ahwëhn a W̃ënu ŋa nkwënëhnow̃a facan fakaw̃ary!» ");
INSERT INTO cou_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ante nagiko Yosef ŋa, Sakob më ntehnëka Laban: «Tavërye vokawu g'inkal mën. ");
INSERT INTO cou_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ndokuŋëhnëmi ɗus hnuỹahnëw̃ëhni vëryag hu vi. Awa, ƴëɗaryëw̃ëhni do gë vutah mën vi yifu.» ");
INSERT INTO cou_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban më ntëkwaka: «Këlami, nëparye. Ge maw̃ëru ɗemarye, gory ani. Wamën mën ŋa njëtëndanëniho Ahwëhn a W̃ën hu w̃a ryëwako ile hwëhnaɓu ỹi. ");
INSERT INTO cou_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pëƴarye ile ỹaɗu sosi ỹa, do cosëɗëmi.» ");
INSERT INTO cou_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Sakob më ntehnëka: «Njëtëru gante ndokuŋëhnëmi ka do gante nke ntega hu wusaw̃ soŋe lëmën ka. ");
INSERT INTO cou_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Hnapul toƴe le hwëhnaruho rëkahnindu ỹa tame nkwënak ɗus. Ahwëhn a W̃ënu ŋa ndëwaki koɓëri ga tëkahniɓu tere hu li. Tëkëna bi wati ỹa ryokuŋahnu soŋe tere lëmën ỹa dënk?» ");
INSERT INTO cou_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban më mbok tëƴëka: «Ye rëfëka sosi?» Sakob më ntëkwak: «Ñoñ cosëɗilihohna. Ge maw̃ëru ile ỹaɗëmi rëƴi ỹa, ani nkoɗëfu ryokuŋëhnëndi. ");
INSERT INTO cou_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Dol pëcëtaɗëfuhëhni ɗus wusaw̃ w̃i do pitëndëlendëɓuhëhni fop wape wante hwëhnaɗ wañiñir, vutoƴ ma wahnaỹah, ma waɓahnah do fop wuhnankal wule hwëhnak wañiñir, vutoƴ ma wahnaỹah: cos mën iŋa yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ge mbiỹëk toƴe, koɗu ayët icat dëmën ŋa ge njëkëru cos mën ŋa. Fop wuhnankal wule woɗ wahwëhnana wëñahn wanëmpëlah ŋa, do fop wape wante woɗ ɓahnëna ŋa, wule leyik ye.» ");
INSERT INTO cou_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban më ntehnëk: «Awa, maw̃ëɓu wanës hu ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hnë fac rac dënk, Laban më pitëkëhni wuhnankal wule hwëhnak wañiñir waƴaryah ŋa, ma wañiñir tëɓ tëɓ ŋa, vutoƴ ma wahnaỹah, do wape wante vahnëk do hwëhnak wëñahn waƴaryah ŋa do kwëtehnahnëhni wurac viju. ");
INSERT INTO cou_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tac cañëtëhni ŋaw̃ët le njasëɗëni wafac warar tëkahnëndëni, soŋe ŋaw̃ëlëni gë Sakob nte heryëɗëhëhniwo wusaw̃ wuỹëntaw̃ Laban w̃a. ");
INSERT INTO cou_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Awa, Sakob më nufëk vundoko vatëh vatar vanëmpëlah do këcëk vakuɓ va. ");
INSERT INTO cou_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Më kwëtëk vundoko va le kosëndeni w̃ënka wusaw̃ hna. Kaɓi wusaw̃ w̃a njëw̃alëɗëniho ge njijëni siya w̃ënka ŋa. ");
INSERT INTO cou_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wusaw̃ w̃a njëw̃alëɗëniho haryënkw vundoko hna do nagëɗënihëhniwo vucaw̃ vunkwamah vunte hwëhnak wañiñir waƴaryah ma wañiñir tëɓ tëɓ ŋa, vutoƴ gë wahnaỹah. ");
INSERT INTO cou_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Sakob pitëkëhniwo wusaw̃ wulëw̃u w̃a do kwëtëni njëkëndënihëhni wusaw̃ Laban wule hwëhnako wañiñir waƴaryah do waɓahnah ŋa. Koyëna ntiko ntega ntëw̃u ŋa do tavëɗilëhniwohna mbarëpëlëni gë ntega wusaw̃ Laban ŋa. ");
INSERT INTO cou_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nte-wo-nte njëw̃alëɗëniho ŋa Sakob kwëtëɗëho vundoko va le kosëndeni w̃ënka hna, soŋe njëw̃alëni haryënkw vundoko vutac. ");
INSERT INTO cou_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ɓare ge camëni wusaw̃ w̃a, kwëtëɗilohna vundoko va: koyëna wusaw̃ wusamah w̃a Laban hwëhnëkëhniwo do wuhonah w̃a Sakob hwëhnëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Sakob nkwënaɗëhawo hnapul ỹa do nke ahwëhn wusaw̃ wuyaɓah ɗus. Kwëhnakëhniwo vëryokuŋ vësëval gë vësan gë wayonkomb do gë wafali. ");
INSERT INTO cou_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Sakob njëtako viju Laban va ntehnëɗëniho: «Sakob nufëk fop le kwëhnëk rëm fu ỹa do umë vetandanëka.» ");
INSERT INTO cou_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Sakob kamahnëko Laban gona njëkënda gë koɓëri ka. ");
INSERT INTO cou_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Awa Ahwëhn a W̃ënu ŋa më ntehnëka Sakob: «Ɓokary hn'inkal vële hnagëki hna, ɗarël vëvë tere hu hna, do g'ami nkeɗe.» ");
INSERT INTO cou_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Sakob më macehnëkëhni vësëvalu Rasel gë Leya, hnë wëhaỹ hna, le nkeho ntega wusaw̃ wulëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Më ntehnëkëhni: «Kamahnëɓu rëmun gona njëkëndo gë koɓëri ka; ɓare W̃ën rëm mën ŋa gë ami nkeɓun kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nurun, w̃uhnë dënk, ndokuŋëhnëɓuha rëmun gë fanka mën fa fop. ");
INSERT INTO cou_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ɓare, tokako nkwëcëtëɗëho cos mën iŋa. Ɓare W̃ënu ŋa tavëlahna ntiwo w̃eh. ");
INSERT INTO cou_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ge ntehnakëndëho: “Wusaw̃ wule hwëhnak wañiñir tëɓ tëɓ w̃a ye cos hu ŋa”, wusaw̃ w̃a fop wuhwëhn tëɓ tëɓ fo nagakëndëni, do ge ntehnakëndëho: “Wusaw̃ wule hwëhnak wañiñir waƴaryah ŋa ye cos hu ŋa”, fop wusaw̃ w̃a wule hwëhnak wañiñir waƴaryah fo nagakëndëni. ");
INSERT INTO cou_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","W̃ënu ŋa nufëkëhni wusaw̃ wulëw̃u w̃a do njëɗaw̃ow̃ëhni. ");
INSERT INTO cou_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Hnë wati nte njëw̃alëɗëniho wusaw̃ ŋa, nuɓu ỹinë hnë huɗakery: wusan wule yëw̃aɗëhëhniwo wësëval w̃a wañiñir waƴaryah kwëhnaniho gë tëɓ tëɓ do gë wacankaf. ");
INSERT INTO cou_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tac, mëleka W̃ënu ŋa më macëko hnë huɗakery: “Sakob!” Më w̃ëtaɓu. ");
INSERT INTO cou_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Më ntehnëko: “Ƴëkëryihni: fop wusan wule yëw̃aɗëhëhni wësëval w̃a wañiñir waƴaryah kwëhnaniho gë tëɓ tëɓ do gë wacankaf; ami lik kaɓi nuɓu fop ile ntiki Laban ỹa. ");
INSERT INTO cou_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","W̃ën Betel ŋa yeɓu, hn'ile cëɓëruho do rurëru wagu itaka hna, hnam ntëkëntuhow̃o. Tame, matëry, kërënary iŋi nkal do avoka hnë nkal nte hnagahniru hna.”» ");
INSERT INTO cou_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasel gë Leya më ntëkwaniha: «Goryaryëlëfuhna ile lëw̃ëɗëfun tere rëm fu hna. ");
INSERT INTO cou_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Had vëhneh pëlakëfu, kaɓi nkwafëkëfu do tokëk koryi lëw̃ fu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Awa, fop hnapul le nufëhnëka W̃ënu rëm fu ỹi fuhnë hwëhnëk gë vutah vudëw̃ fu vi. Tame diry fop le ntehnëki W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Awa, Sakob më pëhwëtak do kaƴëndëhni vërahu gë vësëvalu hnë wayonkomb. ");
INSERT INTO cou_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Më njokëhni fop wusaw̃ wulëw̃u w̃a gë hnapul le nuỹako hnë Padan-Aram ỹa. Mënc gë vëhni rëmu Isak, hn'inkal Kanan hna. ");
INSERT INTO cou_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Hnë wati rac, Laban imëc wëñahn wusaw̃ wulëw̃u njiko. Kaɓi rëmu Rasel golohna hnam, Rasel më nuỹak fere soŋe ntehahn vundëhwa vunte cëmbëɗëho rëmu had wamën ŋa. ");
INSERT INTO cou_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Sakob tokakawo Laban avë Aram ỹa, g'unji dëw̃u hara koyalahna ŋa. ");
INSERT INTO cou_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nkaryëko, gë fop le kwëhnako ỹa. Ntëmpëtako sën sankaf ỹa, Yufërat, do nji gë cape inkal nte hwëhnak wahuŋ, do w̃acëɗe Galad. ");
INSERT INTO cou_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hnë fac rarëna hna, më pëƴayik Laban Sakob nkaryëk. ");
INSERT INTO cou_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Më nufëkëhni vëheryu, tëfëlehna hnë uyas wafac mbëɗ gë wahi (7) do tëkahna hnë wahuŋ Galad hna. ");
INSERT INTO cou_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ɓare g'umëɗ ga W̃ënu ŋa më tufëhnaka Laban, avë Aram ỹa, hnë huɗakery do ntehna: «Antë alehna wameh Sakob.» ");
INSERT INTO cou_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Awa Laban tëkakawo Sakob. Sakob hn'ikuŋ ndampo ntiko hnam usank lëw̃u w̃a; Laban fëna ntintëlehni hnam ulëw̃u w̃a hn'ikuŋ tac. ");
INSERT INTO cou_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban më ntehnëka Sakob: «Ye fëlaki? Soŋe ye rokaruho ayojëhni vëryag mën vi had vëramp uw̃ët? ");
INSERT INTO cou_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Soŋe ye sow̃aru ayaryi, tokaruho do pëƴalihohna? Ntinëhnakëndëmi ambënt cankaf koyalahni. ");
INSERT INTO cou_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Maw̃ëlihna hoyalëfu vëryag mën vi gë vutah vuntëw̃ hni vi! Paryi nke had intëhn ntiru aŋ'ankaw̃. ");
INSERT INTO cou_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Koɗëfu liwu w̃eh ge ñaɗëfu; ɓare W̃ën rëmuh ŋa më lehnëko umëɗ nte ryëcëk ŋi: “Antë alehna wameh Sakob!” ");
INSERT INTO cou_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Awa, nkwëryëɓu njiru kaɓi ñankahnëkino aw̃ënc gë vëhni rëmuh, ɓare soŋe ye lë leru vundëhwa vunte sëmbëɗëfu had wamën ŋa?» ");
INSERT INTO cou_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sakob më ntëkwaka Laban: «Njiɓu koyëna kaɓi ntakëkow̃o do nahaɗëfuho teɓëɗuhow̃ëhni vëryag hu vi. ");
INSERT INTO cou_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tame ge nuru vundëhwa vutac hnë aryampo vëlëmën li, ahnë arac cëmëɗ. Tase vëlëw̃ fu vi ƴëkëry fop ile ye hnë ỹal mën ỹi do nufëry ile hwëhnëru ỹa.» Hara Sakob ƴëtëlohna Rasel leko vundëhwa va. ");
INSERT INTO cou_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Awa, Laban më njëkëlehnëk hn'usank Sakob hna gë va Leya hna do gë vëryokuŋ vëhi va, ɓare nulohna. Ga cahnik hn'usank Leya hna, më tënkëk hn'uva Rasel hna. ");
INSERT INTO cou_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Hara, Rasel leko vundëhwa va; hnë le tindëɗeni wayonkomb ntañahni kwëtëko do ntañahn. Laban njëkëlehnëko hn'usank hna fop hara ñoñ nuna. ");
INSERT INTO cou_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel më ntehnëka rëmu: «Apa, antë ntavi ge kolëla w̃atu haryënkw hu; ures lepera fëgwëko.» Laban njëkëlehnëko ɓare nulohna vundëhwa va. ");
INSERT INTO cou_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sakob më ntavëka do nirahna Laban ntehna: «Ye liɓu w̃eh? Mo ryaw̃ëɓu soŋe aholahn arëfëlehnëndo aki? ");
INSERT INTO cou_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Njëkëlehnëru hnë viỹë mën hna fop. Tëkatëru bi iñë ryampo ile hwëhnëru? Tufëryihni vëlëmën vi do gë vëlëw̃ hu vi, do tëfëka kitiŋënihëfu. ");
INSERT INTO cou_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«Ntiɓu wabëhn wafëhw wahi (20) ỹal hu hna; nulihahna muk icaw̃ hu nte hnacëk, do cemëlëw̃ahna muk icaw̃ hu. ");
INSERT INTO cou_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mëncënanilinahna muk icaw̃ nte ndaw̃ëk intaw̃, mbokënanëɗëminawo nte-wo-nte cëmëko icaw̃ ŋa. Tëƴëɗuhow̃ëhniwo vësayini wule leɗeho w̃a, g'umëɗ ma g'anent ŋa. ");
INSERT INTO cou_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","G'anent ga korotëɗëfuho gulav w̃a do g'umëɗ ga gë huji ha, do koɗëw̃ohna ryaku wakwëɗ. ");
INSERT INTO cou_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Maw̃ëɓuho liwu wabëhn wafëhw wahi (20) ỹal hu hna: ndokuŋëhnëmi wabëhn pëhw gë wahnah (14) ỹëlahnëw̃ëhni vëryag hu vëhi vi, do wabëhn mbëɗ gë ryaw̃ (6) soŋe hnuỹahnëw̃ëhni wusaw̃, ɓare wëjë, nkwëcëtëɗuho cos mën iŋa. Koyëna nkeho! ");
INSERT INTO cou_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ge W̃ën rëm sankaf mën Abëraham, W̃ën hunte valendëhawo rëm mën Isak ŋa, ɗemakëndilohna, tavakënduho w̃ëncu wëɓák fo. Ɓare W̃ënu ŋa nuk horot mën w̃a gë ɗoku lakah le liɓu ỹa do umëɗ nte ryëcëk ŋi niraki.» ");
INSERT INTO cou_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban më ntëkwaka Sakob: «Vëỹi vësëval ami hwëhnëkëhni, vutah vuntëw̃ hni vi ami hwëhnëkëhni, wuỹi wusaw̃ ami hwëhnëkëhni do fop le hnuɗu ỹi ami hwëhnëk. Ɓare, njavëtëɓu tëk pëgw dol, ñoñ koɗa voku liwu soŋe vëryag mën vi ma soŋe vutah vunte nagëni vi. ");
INSERT INTO cou_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tame ƴij nkwëryëli fuhnë vëhi, do tëfëka ntiyi iñë nke seɗe yëbëlan fu.» ");
INSERT INTO cou_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Awa Sakob më nufëk itaka do cëɓ. ");
INSERT INTO cou_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tac ntehnëhni vëlëw̃u va mbarëpini wëraka. Më mbarëpini do ntini akova. Tac vëhni fop hnë kova tac tokëniho. ");
INSERT INTO cou_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban Yëgar Sahaduta macëko ỹëw̃a rac, do Sakob umë Galed macëko. ");
INSERT INTO cou_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban më ntehnëk: «Aŋi kova ye dol seɗe lëw̃ fu ỹa wëjë g'ami.» Soŋe rac w̃acande ỹëw̃a ỹa Galed, umë fëhnëtanëk «kova nte ye seɗe». ");
INSERT INTO cou_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Misëpa maciko fëna, umë fëhnëtanëk «ỹëw̃a soŋe iƴëka», kaɓi Laban mboko ntehn kat: «Araɓi Ahwëhn a W̃ënu ŋa njëkandëfu antë tavi ile hwëtëlik ani ỹi ge gona nulënde. ");
INSERT INTO cou_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ge koroteyehnëruhëhni vëryag mën vi, ge ñëlëruhëhni vësëval vëhaw̃ary, diry wajira, gena ahnë ye seɗe ỹa yëbëlan fu, ɓare W̃ënu ŋa dënk ye.» ");
INSERT INTO cou_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Tac Laban më mbok ntehnëka Sakob: «Ƴëkëry aŋi kova wëraka nte hovëɓu yëbëlan fu ŋi, ƴëkëry iŋi taka nte sëɓik ŋi. ");
INSERT INTO cou_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Aŋa kova gë iŋi taka ye waseɗe walëw̃ fu w̃a: tëfëlohna ryëcu aŋa kova yiryindu ỹal hu soŋe liyi w̃eh, wëjë fëna tëfëlihna aryëci aŋa kova ayijënd ỹal mën soŋe aliwo w̃eh. ");
INSERT INTO cou_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Araɓi W̃ën Abëraham ŋa gë W̃ën Nahor ŋa, asankaf rëm mën, nke ahitiŋ yëbëlan fu.» Awa Sakob më ntëkëk gë W̃ën hunte valehnëɗëhawo rëmu Isak ŋa. ");
INSERT INTO cou_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Tac Sakob më cënak saɗëha kuŋ hna, do macehnëhni vahnë va fop roka ỹa. Tokëniho do ndakëniho kuŋ hna. ");
INSERT INTO cou_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ga pacëk Laban matëko koɓëri fo, muryahni vëryagu gë vërah hni do ndëwanëhni. Tac mëncëlehn gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sakob ndëcalëko njind nkaw̃ ntëw̃u ŋa, hnë wati rac wamëleka W̃ën më pankëlëni. ");
INSERT INTO cou_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ga nukëhni, Sakob më ndekak: «Kaŋ W̃ën ye!» Do hnam Mahanayim maciko. ");
INSERT INTO cou_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Sakob më paƴëkëhni vahnë ndënkwahëni vëhni acëru Esawu hna, nkal Seyir hna hnë resiỹo Edom hna. ");
INSERT INTO cou_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ntehnëhni aki: «Wëlin le fëƴaɗunëha Ahwëhn mën a Esawu: “Aryokuŋ hu ỹa Sakob më lehnëk: Vëhni Laban hna nkeɓuho hafo gaki. ");
INSERT INTO cou_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kwëhnaɓuhëhni wuhni gë wafali gë wape gë wuhnankal do gë vëryokuŋ vësan gë vësëval. Paƴëryiɓuhëhni vahnë pëƴanihi, soŋe gante koɗu ahacawo g'untënah.”» ");
INSERT INTO cou_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vële faƴiko va më mbokajëni pëƴaniha Sakob: «Pëƴajëɓunëha Esawu do nkejëk afankëlu, gë vësan wakeme wahnah (400) nkejëni.» ");
INSERT INTO cou_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sakob më ntakëka ɗus. Më pitëndëlehnëkëhni vahnë vële nkeniho va wakore waki, do gë wape ŋa gë wuhnankal w̃a gë wuhni w̃a do gë wayonkomb w̃a fëna. ");
INSERT INTO cou_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ntehnaɗëho: «Ge Esawu njijëk ndaw̃ëhni kore ryampo, kore ỹëntaw̃ ỹa pehëɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tac Sakob pëgwëlehn njëfand: «W̃ën rëm sankaf mën Abëraham, gë rëm mën Isak, Ahwëhn a W̃ënu ŋa ntehnëruho: “Ɓokary g'inkal hu, ɗarël vëvë tere hu hna. Ntinëhnëɗëmi ifërën.” ");
INSERT INTO cou_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ahwëhn, mbaɓu ɗus soŋe hnuỹaw̃ fop uryema ule w̃aw̃ëryanëruho g'ikahnënda ƴaɓahëhu ŋi, ami aryokuŋëhn hu ỹi. Ryoko mën ỹi fo hwëhnaɓuho ante ndëcëɗëfuho sën Yurëdan ŋi, do tame mbokajëɗëfu gë waŋi wakore waki. ");
INSERT INTO cou_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Këlami, pehëtëryew̃a Esawu, kaɓi ntakëko g'umë, ntakëko antë njij ndaw̃ëfu gë vësëval vi do gë vutah vi. ");
INSERT INTO cou_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ɗënkwëtary ntehnëruho: “Ntinëhnëɗëmi ifërën. Vutah hu va njaɓëɗëni had nkërëƴal nte wok koɗena ndëkwi.”» ");
INSERT INTO cou_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Herac, Sakob hnam ndakëniho gë vëlëw̃u va. Më nufëk hnë hnapul le nuỹajëko hna soŋe mbuñahna Esawu: ");
INSERT INTO cou_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","wuhnankal wësëval wakeme waki (200) gë wusan wafëhw wahi (20), wape wacëval wakeme waki (200) gë wacan wafëhw wahi (20), ");
INSERT INTO cou_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","wayonkomb wafëhw warar (30) wale yiw̃ëndëɗ gë vutah hni per, wuhni wësëval wafëhw wahnah (40) gë wusan ipëhw (10), wafali wasëval wafëhw wahi (20) gë wasan ipëhw (10). ");
INSERT INTO cou_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Më njëɗakëhni vëryokuŋ vëlëw̃u va, wuhnankal w̃a aryampo, wape ŋa aryampo, wayonkomb w̃a aryampo, wuhni w̃a aryampo, wafali w̃a aryampo do ntehnëhni: «Ɗënkwëhën, do ŋaw̃ëtëlehnëryinëhni wakore wusaw̃ ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tac ntehna aryënkwëryënkw a: «Ge pankëlërun acër mën Esawu tëƴati: “Mo hwëhnëki? Ne njiɗu? Mo hwëhnëkëhni wusaw̃ wule hëryëɗu w̃i?” ");
INSERT INTO cou_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ntëkwaɗuha: “Sakob aryokuŋëhn hu ỹa hwëhnëkëhni. Ɓuña njëɗanahniki, wëjë, ahwëhn mën Esawu, do umë dënk nkejëk hamëhnifu.”» ");
INSERT INTO cou_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Më ntehnëka koyëna ahigëna ỹa fëna gë ararëna ỹa do gë fop vële hëryëɗëhëhniwo wusaw̃ va: «Koyëna ntehnëɗunëha Esawu ge pankëlërun, ");
INSERT INTO cou_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","do nkwënëɗun: “Sakob aryokuŋëhn hu ỹa nkejëk kamëhni fu.”» Kaɓi Sakob ntehnaɗëho: «Njamëhnëɗëfuha gë waɓuña wante ryënkwëhnëɗëho ŋi, do tac tëkëɗëfu haryënkw lëw̃u. Ntiyahnëko kacaɗëho g'untënah.» ");
INSERT INTO cou_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Awa wusaw̃ w̃a ndënkwaryëhiniho, hara Sakob, umë dënk, hnam mboko ndak umëɗ nte rëkiko ŋa. ");
INSERT INTO cou_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Awa hnë umëɗ tac dënk, Sakob matëndëkëhniwo hnam vësëvalu gë Bila gë Silëpa do gë vutah pëhw gë fandaw̃ (11) vuntëw̃u va kegëtani garyëla Yabok ỹa, cañëtëhni. ");
INSERT INTO cou_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ga kegëtani, cañëtëkëhniwo vëryokuŋ va gë fop le kwëhnako ỹa. ");
INSERT INTO cou_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sakob nkolehn umë fo. Awa tac asan më njijëk hn'umëɗ tac njolëni g'umë hafo wakëwak ỹa. ");
INSERT INTO cou_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Asan arac, ga kamahnëk, mëkëɗilahna Sakob hn'iƴol tac, më ndafëka cokot hna, do cokëtakawo njolatëndëni. ");
INSERT INTO cou_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tac asan a më ntehnëka Sakob: «Tavërye yiwu, kaɓi pacëk.» Sakob më ntëkwaka: «Tavëɗila ayi ge gena ndëwanëruho.» ");
INSERT INTO cou_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Asan a më tëƴëka: «Hak maciru?» Më ntëkwaka: «Sakob w̃aciɓu.» ");
INSERT INTO cou_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Asan a më ntehnëka: «Goɗelihna aw̃acënde Sakob. W̃ac hu w̃a Isërayel yeɗ, kaɓi gë W̃ënu ŋa njolërun do gë vahnë va, do wëjë lëbëkëhni ƴaw̃ iŋa.» ");
INSERT INTO cou_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Sakob më tëƴëka: «Këlami, pëƴarye bi hak maciru.» Asan a më ntëkwaka: «Soŋe ye rëƴëɗuho w̃ac?» Awa tac asan a më ndëwanëka Sakob. ");
INSERT INTO cou_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Sakob më macëk ỹëw̃a rac Penuwel, umë fëhnëtanëk «yëka W̃ën»; kaɓi më lehnaɗëho: «Nulëɓun gë W̃ënu ŋa vinkër vinah, do cëmëla.» ");
INSERT INTO cou_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ante pëhnik lav ŋa, Sakob ndëcëtako Penuwel ỹa. Taɗëɗëhawo kaɓi mbuf ŋa ntavëɗëhawo. ");
INSERT INTO cou_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Soŋe umë ye, hafo dol, vëvë Isërayel va vërokëɗina faỹar favë pombor fa, kaɓi ɓaƴ hnam cërehniko Sakob. ");
INSERT INTO cou_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Awa, Sakob njëkako do nulehna taŋ Esawu tëkiɗ gë vësan wakeme wanah va (400). Më pitëndëlehnëkëhni vutah va, ale-wo-le gë hnëmu: Leya gë Rasel do gë Bila gë Silëpa fëna. ");
INSERT INTO cou_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Më ndënkwëndëkëhni Bila gë Silëpa gë vutah vuntëw̃ hni va, tac hamëhni lëw̃ hni Leya gë vërahu, do Rasel gë Yosef tëkwahnini hamëhni. ");
INSERT INTO cou_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tac Sakob umë dënk më ndënkwaryëkëhni. Ndëkwëhnëko yëka ỹa nkal hna wahwënta mbëɗ gë wahi (7) tëkahnënd ɗarël hn'ile nke Esawu hna. ");
INSERT INTO cou_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Awa Esawu më nkaryëk kacaka, nji muryahna do mbuca. Pëgwëlehnëni kondëni vëhni vëhi tak. ");
INSERT INTO cou_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ga nukëhni Esawu vësëval va gë vutah va, më tëƴëka: «Vëhni mo ye vële lapëhnajëɗëhi vi?» Sakob më ntëkwak: «Vutah vunte njëɗëkow̃ëhni W̃ën, ami aryokuŋëhn hu ỹa ye.» ");
INSERT INTO cou_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Vëryokuŋ vësëval va gë vutah vuntëw̃ hni va më tëhani do ndëkwëhnëni haryënkw Esawu. ");
INSERT INTO cou_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tac Leya gë vërahu njigëlehnëni ndëkwëhnëgëni, do Yosef gë Rasel. ");
INSERT INTO cou_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu më tëƴëk: «Ye ỹaɗu ali gë fop wusaw̃ wule fankëliɓun w̃i?» Sakob më ntëkwak: «Ahwëhn, ñakëndëɓu ahacawo g'untënah.» ");
INSERT INTO cou_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu më ntehnëk: «Ahery mën, kwëhnaɓu hnapul yaɓah, kwëtary ile hwëhnaru ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Sakob më ntehnëk: «Hali, këlami ge gona ntavi g'ami, maw̃ëry iỹi ɓuña. Ipankël gë wëjë ŋa nke soŋe lëmën had gë W̃ënu ŋa nulëɓun vinkër vinah, kaɓi kacaruho g'untënah. ");
INSERT INTO cou_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Awa maw̃ëry ɓuña ile yëɗanahnimi ỹi, W̃ënu ŋa yëɗako do kwëhnaɓu fop le rëfëko ỹa.» Sakob njaw̃ënëko do Esawu më maw̃ëntak. ");
INSERT INTO cou_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Tac, më ntehnëka: «Matëry! Njiyi lapëhnaỹi.» ");
INSERT INTO cou_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ɓare Sakob më ntëkwaka: «Njëtëru vutah va vëyaw̃ëna, do tëfëka ntiyini wajira vucaw̃ vunte wok yëw̃ëɗ ɓël va. Ge porosiŋini njasëni ñap wëla fac ryampo fo, fop cëmëɗëni. ");
INSERT INTO cou_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ɗënkwahëndëno; ami, njasaryëryiɗëfuhëhni wajira fo wusaw̃ mën w̃i gë vutah vi, hafo rëkëryiw̃u ỹal hu hna, hn'inkal Seyir hna.» ");
INSERT INTO cou_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu më ntehnëk: «Awa tavëhnëɗëmini vahnë vëryampo vële rëfëliɓun vi.» Sakob më ntëkwak: «Wëla tavëlihëhnihna, ahacawo g'untënah fo ỹaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hnë fac rac, kahnëtako Esawu mëncënd gë Seyir. ");
INSERT INTO cou_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sakob umë, Sukot njiko. Hnam më mbëryehnëk tere, do wakece, soŋe wusaw̃ wulëw̃u w̃a. Soŋe rac w̃acande ỹëw̃a rac Sukot, umë fëhnëtanëk «wasank». ");
INSERT INTO cou_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Koyëna Sakob matëko Mesopotami do ƴam fo tëkëko hn'inaw̃ Sisem vë Kanan hna. Ɗarël naw̃ hna ndahëko. ");
INSERT INTO cou_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Më ntaw̃ëk hnë vutah Hamor, ale hahnëndëko Sisem hna, inkal nte ntihahnëko usank lëw̃u w̃a. Waŋëc keme koryi ntaw̃ahnëko. ");
INSERT INTO cou_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Hnam ntiko hn'ile cënaɗe saɗëha do mac El Elohe Isërayel, umë fëhnëtanëk «W̃ën Isërayel». ");
INSERT INTO cou_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Hnë fac ryampo Dina, aryag hni vëhni Sakob gë Leya, nehahnëkëhniwo vësëval vëvë nkal va. ");
INSERT INTO cou_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sisem aju Hamor, asankaf Wahiv wavë resiỹo w̃a, nukawo. Më nufëka do ntihna ndakëni forosima. ");
INSERT INTO cou_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ɓare ñaɗëhawo ɗus do pëlakawo, njëkëlehnëɗëho fëna nuỹa ikwëtahn Dina ŋa. ");
INSERT INTO cou_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Awa Sisem më ntehnëka rëmu Hamor: «Yëkëlehnëndew̃a aỹi aryag, ñaɗëfu ỹëlëw̃a.» ");
INSERT INTO cou_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ga njëtak Sakob Sisem cëfëhnanëka aryagu Dina, viju gë wëhaỹ nkeniho gë wusaw̃ w̃a; ñoñ nësëlohna hafo nte mëncini ŋa. ");
INSERT INTO cou_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Awa Hamor më njini g'aju vëhni Sakob hna soŋe nësëhna. ");
INSERT INTO cou_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Hara tëko mëncini viju Sakob, do njëtaniho ile ryëcëtak ỹa. Vësan vërac pëɓëkëhniwo yiw̃ëhnah sankaf do ntavëkëhniwo ɗus, kaɓi Sisem ntiko iñë le wok diɗena muk Isërayel hna iɗak forosima g'aryag Sakob ỹa. ");
INSERT INTO cou_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ɓare Hamor më ntehnëkëhni: «Ajë mën a Sisem ñaɗëha ɗus aỹi aryag. Këlami, ƴëɗëryina ñëla. ");
INSERT INTO cou_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Gwëryëlënëfu: ƴëɗaryinëfuni vëryag hun vi ỹëlëfuni do aỹëluni vëryag fu vi.» ");
INSERT INTO cou_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Gë fuhnë ntëɗëntëɗerun. Piɗëtënderun resiỹo ỹi. Koɗun alëɗëntiwu ani alindu le valëɗëhu ỹa, ahwëhnu nkal iŋi. ");
INSERT INTO cou_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sisem umë dënk fëƴakëhniwo vëhni rëmu gë vicëru aryag fa: «Ɗemaryino, pëhwëtaɓu yëɗaw̃u ile rëƴëɗunëho ỹa. ");
INSERT INTO cou_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Koɗun arëƴuno hupaƴ hucankaf do gë waɓuña waƴaɓah. Njëɗaɗëmu fop le rëƴëɗunëho ỹa, ɗanko ỹëlëw̃a aryag aỹi tuŋ.» ");
INSERT INTO cou_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Viju Sakob më ntëkwaniha Sisem gë rëmu Hamor, ɓare cow̃ëniho ile nahani ỹa kaɓi Sisem cëfëhnanëkawo ahery hni ỹa Dina. ");
INSERT INTO cou_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Më ntehnënihëhni aki: «Koɗilëfuhna yëɗafuna ahery fu ỹa asan ale wok kácina; usëfëhnah lëw̃ fu yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Soŋe iñë ryampo fo w̃aw̃ëhnanderun: fop vësan vëvë ỹal hun va kácini gë fuhnë ki. ");
INSERT INTO cou_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Awa, tac njëɗaɗerunëhëhni vëryag fu va aỹëluni, do ỹëlëfuni vëryag hun va. Ntëɗëntëɗeɓun gë w̃uhnë do koyëna ɓulunda ryampo fo yeɗen. ");
INSERT INTO cou_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ɓare ge maw̃ëluhna aháciwu, mbiɗëfunëha ahery fu ỹi do njiɗëfun.» ");
INSERT INTO cou_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor g'aju më maw̃ëni watac. ");
INSERT INTO cou_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Jar ŋa pëhwëtalehn taŋ soŋe nti ile tëƴiniho ỹa, kaɓi ñaɗëhawo ɗus aryag Sakob ỹa. Hara umë yeho ale ỹako ntënëni tere ỹa. ");
INSERT INTO cou_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor gë Sisem më njini ỹëw̃a ɓulunda hna, do ntehnënihëhni aki vëvë hnam va: ");
INSERT INTO cou_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Vëỹi vësan vëhwëhn ƴam yëbëlan fu ye. Araɓi ntëɗëntini resiỹo fu li do ntindëni ile ñaɗëni ỹa, kaɓi nkal iŋi njankëk haryënkw lëw̃ hni! Koɗen ñëlinëhni vëryag vëlëw̃ hni va do koɗen njëɗayinëhni vëlëw̃ fu va ñëlënihëhni. ");
INSERT INTO cou_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maw̃ëɗëni ntëɗëntini gë fuhnë do ntiyin ɓulunda ryampo fo ge ntiyinëk ile ñaɗëni ỹa, umë ye: fop vësan vëvë ỹal fu va kácini gë vëhni ka. ");
INSERT INTO cou_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ge maw̃ayinëkëhni, njijëɗëni ntëɗëntini gë fuhnë; awa fop wusaw̃ wulëw̃ hni w̃a gë hnapul lëw̃ hni ỹa fuhnë hwëhnëɗen.» ");
INSERT INTO cou_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Fop vële yeho hnam va maw̃ëlehnëni wanës Hamor g'aju Sisem ŋa, do fop vësan vëvë naw̃ va káciniho. ");
INSERT INTO cou_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Hnë fac rarëna hna, hara vësan va ntavëɗëhëhniwo wahajëhn w̃a, viju Sakob vëhi, Simeỹo gë Levi, vicëru Dina va, më nufëni wasëlame walëw̃ hni w̃a, tënkëni naw̃ hna hara ahnë ƴëtëna do ndaw̃ënihëhni vësan va fop, ");
INSERT INTO cou_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ndaw̃aryënihëhniwo fëna vëhni Hamor g'aju Sisem. Ga cahnëɗëni tere Sisem ỹa më njoniha Dina. ");
INSERT INTO cou_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Viju Sakob vëỹëntaw̃ va më njijëni nteni ile kwëhnani vësëm va do nufëni fop le yeho naw̃ ỹa kaɓi ahery hni sëfëhnanik. ");
INSERT INTO cou_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nufënihëhniwo wusaw̃ wavë naw̃ w̃a fop gë wule yeho wëhaỹ w̃a. ");
INSERT INTO cou_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Njoniho fop hnapul lëw̃ hni ỹa, gë vësëval va fop gë vutah va fop do gë fop ile yeho watere hna. ");
INSERT INTO cou_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Awa Sakob më ntehnëkëhni vëhni Simeỹo gë Levi: «Njonëhnirunëho kata. Soŋe lëw̃ hun ỹa, vëvë Kanan vi gë vëvë Perisi vi ñew̃ëɗëniho. Nkwëryëlëɗëni do mëkëɗëniho gë tere mën ỹi, kaɓi vësan toƴe fo hwëhnaɓu.» ");
INSERT INTO cou_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ɓare vëjar vaki va më ntëkwaniha rëm hni: «Aỹi asan tëfëlawohna ntihna ahery fu ỹi had asëval ale wafëɗ nkaf ntëw̃u.» ");
INSERT INTO cou_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Fac ryampo W̃ënu ŋa më lehnëkawo Sakob: «Matëry ayi alëɗ Betel, hn'ile ntinëhnëɗuho sëna saɗëha hna. Hnam tufëhnamino ante nkaryëɗuhawo acër hu Esawu ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Sakob më ntehnëkëhni vëvë tere lëw̃u va gë vële nkeniho va fop: «Dihëtëryin wamën wahneh wale ye ỹalun w̃i. Pacënaryin do gwëcëtaryin viỹi va. ");
INSERT INTO cou_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pëhwëtaryin, Betel yiɗen. Hn'ile cënaɗe saɗëha ỹaɗëfu linëhnëw̃a W̃ën hunte ryemakowo hale ndëñëɓuho do ryemaɗëhowo hn'ile-wo-le hna.» ");
INSERT INTO cou_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Awa më njëɗaniha Sakob fop wamën wahneh wale kwëhnaniho w̃a, do gë vampebel vante mpebelaniho va. Sakob më mbañëk kuyët tëh cankaf nte ye ɗarël Sisem ŋa. ");
INSERT INTO cou_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ante kahnëtaniho Sakob gë vëlëw̃u va, W̃ënu ŋa cëlëndëhnikëhniwo ntakah cankaf vëvë vankol vante kakëniho va, hafo ahnë ɗëkëlohna tëfëlehnëhni. ");
INSERT INTO cou_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Sakob gë fop vële tëfëlëniho va tëkëlehnëni Lus, umë w̃acëɗe Betel, hn'inkal Kanan hna fo. ");
INSERT INTO cou_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Më njik ntik hn'ile cënaɗe saɗëha hna do mac ỹëw̃a rac «Ël-Betel», kaɓi hnam tufëhnakawo W̃ënu ŋa ante nkaryëɗëhawo Esawu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora, asëval ale hnihnëɗëhawo Rebeka hnëm Sakob ỹa, cëmëko do mbañi ɗarël Betel hna, kuyët hn'atëh cankaf hna; koɓëri fac rac, «Atëh Wako» macëɗe tëh tac. ");
INSERT INTO cou_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","W̃ënu ŋa mboko tufëhnahna kat Sakob ante matiko Mesopotami mbokand Betel ŋa do ntinëhna fërën. ");
INSERT INTO cou_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Më ntehnëka: «W̃ac hu w̃a Sakob yeho, ɓare ɓokëɗelihna aw̃aci koyëna. Tame w̃ac hu w̃a Isërayel yeɗ.» Awa W̃ënu ŋa Isërayel macëkawo. ");
INSERT INTO cou_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Më mbok ntehnëka kat: «W̃ën Hwëhn Fanka Fop ŋa yeɓu. Njëɗaɗëmini vutah vunjaɓah, soŋe aye rëm sankaf nkal do gë kore waɓulunda. Nkeɗëni vëhnaw̃ hnë vutah hu hna. ");
INSERT INTO cou_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Inkal nte lehnëɓuho yëɗaɗëfuhëhni Abëraham gë Isak ŋa, njëɗami, do ge mbiỹëk vutah hu va yëɗaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tac W̃ënu ŋa më ŋaw̃ëtak ỹëw̃a le nësëhnahnëkawo Sakob ŋa. ");
INSERT INTO cou_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Sakob më kahnëndëk hnam itaka, do tur wagu gë uñen toƴe, soŋe nkehahn taka W̃ën. ");
INSERT INTO cou_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kaɓi W̃ënu ŋa nësëhnëkawo hnam më macëk ỹëw̃a rac Betel, umë fëhnëtanëk «Cery W̃ën». ");
INSERT INTO cou_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sakob gë tere lëw̃u ỹa matëniho Betel hna. Nkojëkëhniwo tëkahnëni Efërata ante nagëko Rasel ŋa. Korotëko hnagi ỹa. ");
INSERT INTO cou_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ante korotëɗëho Rasel hnagi ŋa, asëval ahnagënd a më ntehnëka: «Antë ntaki, facan vok ye.» ");
INSERT INTO cou_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rasel cëm iŋa nkeho. Ante mbëvëɗëho ŋa, më macëka fatah fa Ben-Oni, umë fëhnëtanëk «Fatah horot mën», ɓare Sakob Besame macëkawo, umë fëhnëtanëk «Fatah vák rëhw». ");
INSERT INTO cou_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rasel cëmëko do mbañi tëfary ankaw̃ Efërata hna, umë w̃acëɗe tame Betëlem. ");
INSERT INTO cou_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Sakob më cëɓëk itaka ƴag hna: hafo dol nkok macënde «Itaka ɓë ƴag Rasel». ");
INSERT INTO cou_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sakob më njik kahnënd wasank wadëw̃u ŋa hnë resiỹo Migëdal-Eder hna. ");
INSERT INTO cou_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Hnë wati nte ntëɗëko Sakob hnam ŋa, Riben fandënkwëryënkw fantëw̃u fa njiko ndakëni gë Bila, asëval ale nkeniho gë rëmu ỹa. Sakob njëtako do ntavëkawo ɗus. Hara Sakob vutah vucan pëhw gë vuki (12) nuỹako: ");
INSERT INTO cou_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya nagëhnëkawo Riben fandënkwëryënkw fa tac Simeỹo gë Levi gë Yuɗa gë Isakar do gë Sabilon. ");
INSERT INTO cou_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasel umë Yosef nagëhnëkawo gë Besame. ");
INSERT INTO cou_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bila, ale ryokuŋëhnëɗëhawo Rasel ỹa, Dan gë Nefëtali nagëhnëkawo. ");
INSERT INTO cou_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silëpa ale ryokuŋëhnëɗëhawo Leya ỹa Gad gë Aser nagëhnëkawo. Vëỹi ye viju Sakob va; Mesopotami hna naginiho. ");
INSERT INTO cou_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Sakob më njik Mamëre vëhni rëmu hna, ɗarël Kiriyat-Arëba, umë w̃acëɗe tame Ebëron. Hnam ntëɗëniho Abëraham gë Isak. ");
INSERT INTO cou_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak wabëhn keme gë wafëhw mbëɗ gë warar nuỹako (180) ");
INSERT INTO cou_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","cëmat. Awa g'untaf ƴaryah tëfëlehnëkëhniwo vacërakëlow̃u va hn'icëm hna do viju, Esawu gë Sakob, më mbañëniha. ");
INSERT INTO cou_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Wëli itëfëta soŋe vutah Esawu nte w̃acëɗe Edom. ");
INSERT INTO cou_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu vësëval vëvë Kanan ñëlëko: Ada, aryagu Elon avë ɓulunda Wahit ỹa gë Oholibama aryagu Ana nte nagëko Sibeỹo avë ɓulunda Wahiv ỹa. ");
INSERT INTO cou_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basëmat ñëlaryëko fëna, aryagu Isëmayel do ye aheryu, Nëbayot. ");
INSERT INTO cou_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada yeho hnëm Elifas ỹa, Basëmat yeho hnëm Rewuyel ỹa, ");
INSERT INTO cou_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","do Oholibama yeho hnëm Yewus gë Yalam do gë Kora ỹa. Vëỹi ye vijë Esawu vële hnagiko Kanan va. ");
INSERT INTO cou_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esawu më njokëhni vësëvalu gë vërahu do gë fop vëryokuŋ vëlëw̃u va gë wusaw̃ wulëw̃u w̃a. Njoryaryëko fëna fop hnapul le nuỹako hn'inkal Kanan ỹa. Njini hnë resiỹo haw̃ary, ŋaw̃ët aheryu Sakob. ");
INSERT INTO cou_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Vëhoɗilohna nko ntëɗëlahnëni ndampo kaɓi hnapul lëw̃ hni ỹa njaɓëko ɗus. Resiỹo le nkehahnëniho ỹa geɗilohna gwër soŋe ndavahnëndënihëhni wusaw̃ w̃a. ");
INSERT INTO cou_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Soŋe umë, Esawu, (nte w̃acëɗeho Edom), njiko ntëɗ hnë resiỹo Seyir hwëhn wakuŋ hna. ");
INSERT INTO cou_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Wëli itëfëta soŋe vërah Esawu va, rëm sankaf ɓulunda Wa-edom, vële lëɗëko hnë resiỹo Seyir hwëhn wahuŋ. ");
INSERT INTO cou_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Wëlin wamac viju Esawu va: Elifas, ale nagëko asëvalu Ada; Rewuyel ale nagëko asëvalu Basëmat. ");
INSERT INTO cou_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Viju Elifas va Teman yeho gë Omar gë Sëfo gë Gatam do gë Kënas. ");
INSERT INTO cou_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas fëna nkeniho g'asëval a ahaw̃ary. Timëna maciko. Umë hnagëhnëkawo facan fakaw̃ary: Amalek maciko. Vëỹi ye vële nagëni vutah Esawu va do gë viju asëvalu, Ada va. ");
INSERT INTO cou_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wëli itëfëta soŋe viju Rewuyel va: Nahat gë Sera gë Sama do gë Misa. Vëỹi nagëk ajë hni vëhni Esawu g'asëvalu Basëmat ỹa. ");
INSERT INTO cou_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Do fëna, Oholibama, Ana yeho rëmu ỹa do Ana tac, Sibeỹo yeho rëmu ỹa, umë hnagëhnëkawo Esawu: Yewus gë Yalam do gë Kora. ");
INSERT INTO cou_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Wëlin wamac vësankaf vële nagëko Esawu va: wamac vësankaf Elifas ajë aryënkwëryënkw Esawu gë Ada ỹa, Teman ye gë Omar gë Sëfo gë Kënas gë Gatam do gë Amalek. Edom hna ntëɗëniho. ");
INSERT INTO cou_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Wëlin wamac vësankaf Rewuyel, aju Esawu ỹa, Nahat ye gë Sera gë Sama do gë Misa. Edom hna ntëɗëniho. Vërah aju Basëmat asëvalu Esawu yeho. ");
INSERT INTO cou_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wëlin wamac vësankaf vële nagëko Oholibama, asëvalu Esawu ỹa: Yewus yeho gë Yalam gë Kora. Vëỹi ye vësankaf vële nagëko Oholibama, aryagu Ana, asëvalu Esawu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Vëỹi yeho vësankaf Wa-edom, vële nagëko Esawu va. ");
INSERT INTO cou_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Wëlin wamac viju gë vijë hni Seyir, avë ɓulunda Wahori ỹa, vële ryënkwëko ntëɗëni nkal tac va: Lotan yeho gë Sobal gë Sibeỹo gë Ana, ");
INSERT INTO cou_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","gë Dison gë Esër do gë Disan. Vëỹi yeho vësankaf Wahori w̃a, viju Seyir, hn'inkal Edom hna. ");
INSERT INTO cou_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Viju Lotan va, Hori gë Hemam yeho. Lotan aheryu asëval a, Timëna maciko. ");
INSERT INTO cou_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Viju Sobal va, Alëvan yeho gë Manahat gë Ebal gë Sëfo do gë Onam. ");
INSERT INTO cou_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Viju Sibeỹo va, Aya gë Ana yeho. Ana hnuko w̃ënka ŋa wula hna, ante keryëɗëhëhniwo wafali rëmu, Sibeỹo ŋa. ");
INSERT INTO cou_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Vutah Ana va: Dison maciko facan fa, facëval fa Oholibama. ");
INSERT INTO cou_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Viju Dison va, Hemëdan yeho gë Ecëban gë Itëran do gë Këran. ");
INSERT INTO cou_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Viju Esër va, Bilëhan gë Savan gë Akan yeho. ");
INSERT INTO cou_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Viju Disan va Us gë Aran yeho. ");
INSERT INTO cou_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Awa, wëli wamac vësankaf Wahori w̃a: Lotan yeho gë Sobal gë Sibeỹo gë Ana ");
INSERT INTO cou_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","gë Dison gë Esër do gë Disan. Vëỹi yeho vësankaf Wahori w̃a, gante nkeni hnënk ka hn'inkal Seyir hna. ");
INSERT INTO cou_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wëlin wamac vëhnaw̃ vële hnaw̃ëko Edom ani gë naw̃ahnënd ahnaw̃ Isërayel hna: ");
INSERT INTO cou_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela aju Bewor, avë naw̃ Dinaba ỹa, ryënkwëko naw̃. ");
INSERT INTO cou_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ga cëmëk, Yobab aju Sera avë naw̃ Bosëra ỹa hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab ga cëmëk, Husam avë resiỹo Wateman ỹa hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam ga cëmëk, Hadad aju Bëdad nte w̃ëkëkëhniwo ɓulunda Madiyan hn'inkal Mowab hna do nkol dëw̃u ŋa Avit maciko, umë hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad ga cëmëk, Samëla mbë Masëreka hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samëla ga cëmëk, Sawul mbë Rehobot nte ye tëfary sën ŋa hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawul ga cëmëk, Bal-Hanan, aju Akëbor hnaw̃ëgëko. ");
INSERT INTO cou_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal-Hanan, aju Akëbor, ga cëmëk, Hadar hnaw̃ëgëko; naw̃ dëw̃u ŋa, Pawu maciko; asëvalu Mehetabel maciko do aryagu Matërëd yeho do Matërëd aryagu Me-Sahab yeho. ");
INSERT INTO cou_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Wëlin wamac vësankaf vëvë tere Esawu va, gante nkeho wahnënk walëw̃ hni do gë walëɗ walëw̃ hni ka: Timëna yeho gë Alëva gë Yetët ");
INSERT INTO cou_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","gë Oholibama gë Ela gë Pinon ");
INSERT INTO cou_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","gë Kënas gë Teman gë Mibësar ");
INSERT INTO cou_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","gë Magëdiyel do gë Iram. Vëỹi yeho vësankaf Wa-edom vële hnaw̃ëndiko ale-wo-le hnë resiỹo ryampo hnë nkal dëw̃ hni hna. Esawu yeho rëm sankaf Wa-edom w̃a. ");
INSERT INTO cou_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ga cëmëk Isak, awa Sakob më ñëw̃ëk hn'inkal Kanan hna, le ntëɗëko rëmu hna. ");
INSERT INTO cou_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Wëlin itëfëta soŋe tere Sakob ỹa. Yosef wabëhn pëhw mbëɗ gë waki (17) kwëhnako. Wape gë wuhnankal keryëɗëniho gë vicëru, viju Bila, gë Silëpa, vësëvalu rëmu va. Yosef pëƴaɗëhawo rëmu wameh wante ntiɗëniho vicëru ŋa. ");
INSERT INTO cou_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Sakob ñaɗëhawo Yosef ntëbini viju vëỹëntaw̃ va, kaɓi hn'ucër ntëw̃u hna nuỹakawo. Më tëfehnëhnëka acuɗ gwamah ɗus. ");
INSERT INTO cou_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Vicëru Sakob va nuniho rëm hni umë ñaɗëho ntëbini vëhni fop. Awa ñew̃ëlehnëniha do vëhoɗilohna mbok nësëhnëniha wajira. ");
INSERT INTO cou_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tac, hwënta ryampo, Yosef ndakeryëko. Më pëƴakëhni vicëru, do vicëru më ñew̃ëniha g'ahaw̃ary. ");
INSERT INTO cou_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Umë lehnëkëhniwo: «Nëparyin huɗakery mën ha. ");
INSERT INTO cou_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Fuhnë fop kaỹ hna nkeyinëko waỹabëh ỹabëɗenëho. Taŋ ñabëh mën iŋa matëndalehn kahn; awa waỹabëh hun w̃a njilehni kwëra do ndëkwëhn haryënkw lëw̃u.» ");
INSERT INTO cou_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Vicëru më tëƴëniha: «Paryi bi ñaɗu aye ahnaw̃ alëw̃ fu do aryokuŋëhnënde?» Më ñew̃ëniha g'ahaw̃ary soŋe huɗakery hutac do gë soŋe ile tëfëtaɗëho ỹa. ");
INSERT INTO cou_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yosef mboko ndakery kat më mbok tëfëtanëhnëkëhni vicëru: «Mbokëɓu ryakeryu. Ulav w̃a gë ulepera w̃a do gë wahol pëhw gë ryaw̃ (11) ryëkwëhnakëh haryënkw mën.» ");
INSERT INTO cou_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tëfëtanëkawo fëna huŋi huɗakery rëmu tase vicëru. Umë më ŋañënahnëka do ntehna: «Ye pëhnëtanëɗ huɗakery hu hi? Tëfëkëfu bi ami gë hnëmuh do gë vicër hu ryëkwëhnëfu haryënkw hu?» ");
INSERT INTO cou_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Vicëru ñew̃aryënihawo watac, ɓare rëmu hakili hna kwëtako huŋi huɗakery. ");
INSERT INTO cou_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Fac ryampo vicëru Yosef njiniho hnë resiỹo Sisem hna hery wusaw̃ rëm hni w̃a ");
INSERT INTO cou_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","do Sakob, ale w̃aciko Isërayel fëna, më ntehnëka Yosef: «Paƴëɗëmi ayi arëkatëhni vicër hu, wusaw̃ w̃a keryëɗëni hnë resiỹo Sisem hna.» Yosef më ntëkwaka: «Awa, apa.» ");
INSERT INTO cou_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Rëmu më ntehnëka: «Ƴiry ayëkihni bi ƴam nkeni vicër hu gë wusaw̃ w̃a. Tac g'ayij afëƴawo.» Sakob hnë Ebëron hna paƴëkawo Yosef nji. Ga tëkëk Sisem hna, ");
INSERT INTO cou_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","më pankëlëni g'asan hara wëwac hna nkwërëtalehnëɗëho Yosef. Asan arac më tëƴëka: «Ye yëkëlehnëɗu?» ");
INSERT INTO cou_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosef më ntëkwaka: «Vicër mën va yëkëlehnëɗëfu, pëƴarye bi ne nkeni g'usaw̃ w̃a?» ");
INSERT INTO cou_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Asan a më ntëkwaka: «Pakëtani ani, do nkwëryëɓuhëhni ga nësëɗëni: “Ƴinëfu gë cape Dotan haɗi.”» Awa Yosef njilehn njëkëlehnëhni vicëru do nuhni Dotan hna. ");
INSERT INTO cou_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Vicëru më nujëniha ŋaw̃ët. Ani gë tëhahnëndëhni ỹa, më nkwëryëlëni ndaw̃ëniha. ");
INSERT INTO cou_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ntehnëlëɗëniho: «Wëliho ahwëhn huɗakery a nkejëk! ");
INSERT INTO cou_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tame ɗaw̃ënëfuna, do ntabina hnë hatëh hatëw̃ah! Do ntehnëɗen intaw̃ ŋañah rokëka. Awa tac nuɗen bi ntiyaɗ huɗakery hudëw̃u hi.» ");
INSERT INTO cou_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Riben nkwëryëkëhniwo, më pëhnak pehëta Yosef. Më lehnëkëhniwo: «Antë aryaw̃una!» ");
INSERT INTO cou_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tac më nkwënëk: «Antë arëkwehnu wafac walëw̃u w̃a; dabëryina ki fo hnë hatëh hatëw̃ah le ye wula ỹi.» Nësëhnëɗëhëhniwo koyëna soŋe pehëtahna do mëncerya gë vëhni rëmu. ");
INSERT INTO cou_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tëkënd tuŋ Yosef le nkeniho vicëru hna, pëlalehnëniha, cuɗëtëniha cuɗ gwamah nte cuɗako ŋa ");
INSERT INTO cou_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","do ntabëniha hnë hatëh hatëw̃ah. Hatëh hatac nkuhëko. ");
INSERT INTO cou_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tac ntañalehnëni soŋe tokëni. Awa më nujënihëhni kore ɓulunda Wa-isëmayel hn'inkal Galad hna matiniho. Wayonkomb walëw̃ hni w̃a wakoyel vatëh ndiɓëniho, njiryeryëndëni nkwafini Esipët hna. ");
INSERT INTO cou_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Awa Yuɗa më ntehnëkëhni vicëru gë vëheryu: «Ye nëfaɗëhëfu ge ndaw̃inëka ahery fu ỹi do cow̃in ñas dëw̃u ŋa? ");
INSERT INTO cou_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nkwafinëhna Wa-isëmayel ŋi fecek, antë ndaw̃ina: ahery fu ye, sat ryampo fo hwëhnayinëk.» Maw̃ëhnëlehnëniha. ");
INSERT INTO cou_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hara vëwaf vërac Madiyan matëniho. Awa, vicëru më ndanëtiniha hatëh hna. Nkwafëniha gë waŋëc wafëhw wahi (20) koryi. Vëhni më njoniha Esipët. ");
INSERT INTO cou_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ante mbokako Riben hatëh ŋa, tëkatëlawohna Yosef. Pëɓëkawo yiw̃ëhnah w̃a, awa më citëk viỹi vilëw̃u va, ");
INSERT INTO cou_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","do mboka gante nkeni vëheryu ntehnëhni: «Yosef gona hatëh hna! Ye liɗëfu tame?» ");
INSERT INTO cou_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Awa më ndaw̃ëniha hotohn do nufëni acuɗ Yosef ŋa, nëvëni wasat w̃a. ");
INSERT INTO cou_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tac njëɗanahnëniha rëm hni cuɗ gwamah ŋa gë waŋi wanës: «Iỹin hnuɓun. Ƴëkëry ɗus bi acuɗ ajë hu ŋa ye.» ");
INSERT INTO cou_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Sakob njavëtëko cuɗ ŋa do ntehn: «Acuɗ ajë mën ŋa ye! Intaw̃ ŋañah lëpëtëlehnëka Yosef do rokëka!» ");
INSERT INTO cou_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Awa më citëk viỹi vilëw̃u va, do ntiya viỹi wakwëy do koko wafac wayaɓah soŋe icëm aju ŋa. ");
INSERT INTO cou_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Vutah vuntëw̃u va fop mborëɗënihawo ɓare ŋwëỹëɗëho ɓor ŋa fop; ntehnëɗëho: «Gë wakwëy ŋa cëlëɗëfu rëkëhëw̃a ajë mën a ɗuniỹa vësëm hna.» Do nkoko kond. ");
INSERT INTO cou_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Vëvë Madiyan va asan ale w̃aciko Potifar nkwafëtënihawo Yosef Esipët hna. Potifar asankaf wasoɗaɗe Faraw̃o yeho, umë yeho ankaf vëyëka Faraw̃o va. ");
INSERT INTO cou_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hnë ƴamani rac, Yuɗa tavëkëhniwo vicëru gë vëheryu do nji Adulam, hnë ale w̃aciko Hira. ");
INSERT INTO cou_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Hnam më nuka aryag Suwa, avë Kanan. Më ñëlëka. Ga mbankëni ryëka ỹa, ");
INSERT INTO cou_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","më ndonkëk do naga facan. Awa Yuɗa më macëka Er. ");
INSERT INTO cou_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Asëval arac mboko naga facan fakaw̃ary; më macëka Onan; ");
INSERT INTO cou_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","tac fakaw̃ary kat fante macëko Sela. Yuɗa Kësib nkeho hnë wati nte nagiko Sela ŋa. ");
INSERT INTO cou_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ga nayëk Yuɗa më njëkëhnëka Er aju aryënkwëryënkw a asëval. Asëval arac Tamar maciko. ");
INSERT INTO cou_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɓare ile lavëɗëha Ahwëhn a W̃ënu ŋa fo ntiɗëho, awa Ahwëhn a W̃ënu ŋa më ndaw̃ëka. ");
INSERT INTO cou_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Awa Yuɗa më ntehnëka Onan: «Dëw̃ëryehna asëval acër hu ỹi, soŋe ahnagëhnahna vutah.» ");
INSERT INTO cou_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ɓare Onan njëtëko fatah fa pëlaɗena had fantëw̃u. Soŋe umë ye, ante-wo-nte ndakëɗëniho g'asëval acëru ŋa, ɓac fo ndehëtëɗ sat lëw̃u ỹa, soŋe antë nagëhna acëru fatah. ");
INSERT INTO cou_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Watac ntavëkawo Ahwëhn a W̃ënu ŋa; më ndaw̃ëka umë fëna. ");
INSERT INTO cou_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Awa Yuɗa më ntehnëka asëval aju ỹa: «Kaɓi cëmaryëkini vësan va, mëncëry gë vëhni rëmuh ayi ahnap hnam hafo ajë mën aỹi Sela naỹ.» Kaɓi ntehnaɗëho: «Tëfëlahna Sela fëna cëm had vicëru vi.» Awa Tamar më mëncëk gë vëhni rëmu. ");
INSERT INTO cou_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ga mbiỹëk, aryagu Suwa, asëvalu Yuɗa cëmëko. Ante puk wakwëy ŋa, Yuɗa më nduñënak tac njini Timëna gë lawo lëw̃u ỹa, Hira avë Adulam ỹa, soŋe njëkinihëhni vële w̃ëcëɗëhëhni wape ŋa. ");
INSERT INTO cou_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","14","Tamar njëtako Sela naỹëk, ɓare ƴëɗayilawohna ñëlëlëni. Awa kaɓi ayëlaw̃u Timëna njiɗëho soŋe mëcehnihni wape ŋa, më cuɗëtak viỹi itiw̃ va, cënka yëka ỹa antë njavëti do nji ntaña rënka Enayim le ye hn'ankaw̃ Timëna hna. ");
INSERT INTO cou_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuɗa më nuka ɓare ƴavëtëlawohna kaɓi cënkako yëka ỹa. Awa më ntiyahnëka ale wafëɗ nkaf ntëw̃u ye. ");
INSERT INTO cou_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ƴëtëlohna asëval viju ỹa ye. Awa më tëhaka do tëƴa: «Maw̃ëry tëfëli!» Tamar më ntëkwaka: «Ye yëɗaɗuho soŋe rac?» ");
INSERT INTO cou_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuɗa më ntehnëka: «Njëɗanahniɗëmina fanankal famb ntega mën.» Tamar më ntëkwak: «Maw̃ëɓu, ɓare ƴëɗarye iñë hnapahnëhëndëw̃a.» ");
INSERT INTO cou_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuɗa më tëƴëka: «Ye ỹaɗu yëɗaỹi?» Tamar më ntëkwaka: «Ile lihahnëɗu viyavëta ỹi gë ryeƴët lëw̃u ỹi, do gë ryoko le w̃ënkëru ỹi.» Yuɗa më njëɗaka tëfëlëlehnëni. Ga mbankëni ryëkwa ỹa, Tamar nufëko ɗonk. ");
INSERT INTO cou_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Më mëncëk gë ỹalu, nji ntihët le cënkako ỹa do mbokërya viỹi itiw̃ va. ");
INSERT INTO cou_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuɗa më paƴëka lawo lëw̃u Adulam njiryerya fanankal fa do mbij viỹë vile njëɗahëkawo Tamar va. Ɓare nulawohna; ");
INSERT INTO cou_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","më tëƴëkëhni vahnë vëvë Enayim va: «Ne nkeha asëval ale wafëɗ nkaf ntëw̃u lañakëh tëfary nkaw̃ ɗarël ani ỹa?» Më ntëkwaniha: «Asëval ale wafëɗ nkaf ntëw̃u koɓëri gena ani!» ");
INSERT INTO cou_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Asan a më mbokak pëƴahna Yuɗa: «Nujëlëw̃ahna, do vahnë vëvë hnam va vëhni lehnëko: Asëval ale wafëɗ nkaf ntëw̃u koɓëri gena ani.» ");
INSERT INTO cou_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuɗa më ntëkwaka: «Araɓi nkoryaryëh vile yëɗaɓuhawo vi soŋe antë njafënihëfu vahnë va. Gante-wo nke ka, ami njëɗanahnëɓuha fanankal fa, do wëjë, nujëlihahna.» ");
INSERT INTO cou_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ga ndëcëk wadepera watar, ahnë më njijëk ntehna Yuɗa: «Tamar, asëval vijë hu va, nkwafëk nkaf ntëw̃u ŋa; wëliho ndonkëk tame.» Awa Yuɗa më ntehnëk: «Araɓi cani do pëɗi hafo cëm!» ");
INSERT INTO cou_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hnë wati nte njiryeryëɗeho ŋa, Tamar më paƴëka ahnë pëƴahna ayëlaw̃u: «Ƴëkëry iỹin. Ile lihahnëɗe viyavëta ỹi gë ryeƴët lëw̃u ỹi, do gë iỹi ryoko, asan ale ryonkëndëko ỹa hwëhnëk. Awa ƴavëtëry do afëƴawo bi mo hwëhnëk.» ");
INSERT INTO cou_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuɗa njavëtëko do ntehn: «Ntënënëk sariya ỹa ntëbo ami; ntik iỹin kaɓi ƴëɗalëw̃ahna ajë mën a Sela ñëlëlëni.» Ga ndëcëk watac, Yuɗa ɓokëlohna ndakëni muk gë Tamar. ");
INSERT INTO cou_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ante tëkëko wati hnag ŋa më hamahnik vucëp ndonkëko. ");
INSERT INTO cou_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Fëndampo hnë vutac më canik vák ryampo. Ahnagënd a më pëlaka do ñaba faỹaw̃ar favëntah tac ntehn: «Faŋi ryënkwik hnagik.» ");
INSERT INTO cou_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ɓare fatah fa më mbokaryëhëk vák ỹa do aheryu ndënkwi nagi. Ahnagënd a më ntehnëk: «Ne piɗëtëru hafo asahni!» Yuɗa më macëka fatah fa Peres, umë fëhnëtanëk «Piɗët». ");
INSERT INTO cou_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Tac cahnëgik fatah fañëntaw̃ fa gë ỹaw̃ar yavëntah ỹa vák hna, do Yuɗa më macëka Sera. ");
INSERT INTO cou_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Awa Yosef tëkaryiko Esipët hna. Vëva Isëmayel va nkwafëtënihawo avë Esipët ale w̃aciko Potifar. Potifar tac asankaf wasoɗaɗe Faraw̃o ỹa yeho, ankaf vëyëka vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ahwëhn a W̃ënu ŋa gë Yosef nkeniho, fop caŋaryëɗëhawo. Tere avë Esipët ale hwëhnëka hna ntëɗëko. ");
INSERT INTO cou_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar kamahnëko Ahwëhn a W̃ënu ŋa gë Yosef nkeniho do caŋaryëɗëhawo fop ile ntiɗëho ỹa. ");
INSERT INTO cou_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Awa Potifar nëŋëkawo gë Yosef, më kwëtehnahnëka ɗoku vë tere lëw̃u ỹa: ankaf tere lëw̃u gë hnapul ỹa fop ntikawo. ");
INSERT INTO cou_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Do tëk pëgw hnë wati rac, soŋe Yosef ỹa, Ahwëhn a W̃ënu ŋa ndëwakëhniwo tere avë Esipët ỹa. Ɗëwara rac campëko hnë viỹë vile kwëhnako hna fop, tere hna do gë wëhaỹ per. ");
INSERT INTO cou_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Awa Potifar taveryëkawo Yosef fop ile kwëhnako ỹa do ñoñ golohna paɓ, ge gena ile tokëɗ ỹa fo. Awa Yosef asan awamah yeho, ");
INSERT INTO cou_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","do, ga mbiỹëk toƴe, asëval Potifar a ŋahnëkawo më ntehnëka: «Ɗakëfu!» ");
INSERT INTO cou_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ɓare Yosef ŋwëỹëko do ntehna asëval a: «Ale ryokuŋëhnëɗëfu ỹa ñoñ tëƴëɗilohna tere li, fop kwëtehnahnëko ile kwëhnak ỹa. ");
INSERT INTO cou_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Umë dënk, kwëhnana ucankaf ntëbo ami hnë iỹi tere: ñoñ ɓañëhnëlohna ge gena wëjë, kaɓi asëvalu ỹa yeru. Awa hak koɗëfu liwu iñë ỹaƴah gë iỹi ki do liwu ile mbañëk W̃ënu ŋa?» ");
INSERT INTO cou_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Asëval a ndëñanëɗëhawo fac-wo-fac nji ndakëni, ɓare Yosef maw̃ëlohna muk do kehaɗëhawo. ");
INSERT INTO cou_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hnë fac ryampo, Yosef tënkëko cery cankaf vëhwëhn tere hna soŋe nti ɗoku lëw̃u ỹa do vëryokuŋ ntaw̃u va vëwolohna hnam. ");
INSERT INTO cou_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Asëval Potifar a më pëlanëka Yosef cuɗ cankaf ŋa ntehna: «Ƴij ndaki!» Ɓare Yosef më taveryëka cuɗ ŋa do nkary cahn cery hna. ");
INSERT INTO cou_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Asëval a, ga nuk taveryëka cuɗ ŋa do nkary cahn cery hna, ");
INSERT INTO cou_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","pëgwëlehn ndekand mëcandëhni vëryokuŋ va ntehnëhni: «Ƴëkëryin: asan mën a njonëhnikëfuna iỹi Ebëre njafaŋëndëfu! Njijakëh soŋe ryakëfu g'ami, ɓare ndekakëɓu ɗus. ");
INSERT INTO cou_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Nkwëryëndo tuŋ ga mëcaɗëfu, më tavëk cuɗ ntëw̃u ŋa, nkary do cahn cery li.» ");
INSERT INTO cou_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tac më kwëtëk cuɗ Yosef ŋa ɗarël lëw̃u hafo asanu mënci. ");
INSERT INTO cou_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ga mëncik asanu më tëfëtanëka watac fo: «Aramp Ebëre ale yonëhniruhëfuna ỹa njijakëh ryakëfu. ");
INSERT INTO cou_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ɓare ga pëgwëɓu ryekandu w̃ëcandu, tavëlehn cuɗ ntëw̃u ŋa nkary do cahn cery li.» ");
INSERT INTO cou_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ante nkwëryëko asan a wante pëƴaɗëhawo asëvalu ŋa, ntavëkawo ɗus. ");
INSERT INTO cou_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Më pëlayehnëka Yosef do cëɗi hnë kaso hn'ile cëɗahniniho vëramp ahnaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ɓare Ahwëhn a W̃ënu ŋa g'umë nkeniho do ndemaɗëhawo. Ntiko hafo asankaf vëyëka kaso ỹa kwëtahna. ");
INSERT INTO cou_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Arac më kwëtehnahnëka Yosef nke ankaf vëramp vëỹëntaw̃ va fop; umë yeho ankaf ɗoku vëramp ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Asankaf vëyëka kaso ỹa golohna paɓ ile kwëtehnahnëkawo Yosef ỹa, kaɓi Ahwëhn a W̃ënu ŋa gë Yosef nkeniho do ntiɗëho caŋarya fop ile pëhnaɗëho ỹa. ");
INSERT INTO cou_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ga mbiỹëk, hnë fac ryampo vësan vëlënah vëhi vëva Faraw̃o va iñë ntëntëniho. Asankaf vële yëɗaɗëhawo Faraw̃o ỹa ile ceɗ ỹa yeho gë asankaf vëwul vamburu va. ");
INSERT INTO cou_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraw̃o ỹa ntavëkawo gë vëhni ");
INSERT INTO cou_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","do cëɗehnëhni hnë kaso va vëyëka vëlëw̃u hna, hn'ile cëɗiko Yosef hna dënk. ");
INSERT INTO cou_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Asankaf vëyëka va më kwëtehnahnëka Yosef paɓëhni, do kaso hna taviniho hafo mbiỹ. ");
INSERT INTO cou_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Hn'umëɗ ndampo, vësan vëlënah vëhi vëva ahnaw̃ avë Esipët va ndakeryëniho vëhni vëhi tak kaso hna. Huɗakery-wo nëmpëlëko gë ỹëntaw̃ ỹa. ");
INSERT INTO cou_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ga pacëk, ante njiko Yosef njëkëhni ŋa, më tëkatëkëhni ga njamëni. ");
INSERT INTO cou_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Më tëƴëkëhni: «Soŋe ye yamërun aki dol?» ");
INSERT INTO cou_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Më ntëkwaniha: «Fuhnë vëhi tak ndakeryëɓun, do ale hoɗ pëƴafu ile pëhnëtanëk ỹa gena ani.» Awa Yosef më ntehnëkëhni: «W̃ënu ŋa koɗ pëƴawu ile pëhnëtanëk ỹa. Tëfëtanëryino ile ryakeryërun ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Asankaf vële yëɗaɗëhawo ahnaw̃ ale ceɗ ỹa më tëfëtak huɗakery hudëw̃u ha ntehn: «Huɗakery mën hna, atëh resen yekëh haryënkw mën. ");
INSERT INTO cou_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Atëh tac wahni warar kwëhnakëh. Nëpënd tuŋ, pëtëlehn, tac ntëw̃ waresen wavëntah. ");
INSERT INTO cou_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ankëlëw̃a Faraw̃o ỹa w̃ënkakëɓu. Më hwëcëɓu waresen w̃a, háw̃u nkëlëw̃a hna, do yelëhnëw̃a Faraw̃o ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosef më ntehnëka: «Wëli ile pëhnëtanëk huɗakery hu ha: wahni warar w̃a wafac warar pëhnëtanëk. ");
INSERT INTO cou_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Hnë wafac warar, Faraw̃o ỹa matëndëɗëhi. Mbësaɗëhi ɗoku hu ỹa. Tac koɗu avoka yëɗanda këlëw̃a ŋa gë koɓëri ka. ");
INSERT INTO cou_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ɓare ge fop mbokak caŋaryi, këlami antë aryënkwo; ɗemarye ahnësëhna Faraw̃o ỹa soŋe lëmën ỹa do cano hnë iỹi kaso. ");
INSERT INTO cou_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaɓi paryi pëƴaɗëmu gë fanka nufijiɓu hn'inkal Wa-ebëre hna, do hnani ñoñ dila le rëfëka sëɗahniwu.» ");
INSERT INTO cou_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Asankaf vëwul vamburu va, ga nuk ipëhnëtan nte nësëk Yosef ŋi tëfëlëk gë huɗakery ha, më ntehnëka: «Ami fëna ndakeryëɓu. Hnë huɗakery hutac, vëkankel vatar mburu ryiɓakëɓu nkaf li. ");
INSERT INTO cou_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Hnë ambë ƴaŋ hna, sifa vamburu ỹa fop yekëh hnam, vante tokëɗ Faraw̃o va. Do wusëry yijakëh tokëndëni kankel hna ƴaŋ nkaf mën hna.» ");
INSERT INTO cou_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosef më ntehnëka: «Wëli ile pëhnëtanëk huɗakery hu ha: vëkankel vatar va wafac warar pëhnëtanëk. ");
INSERT INTO cou_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Hnë wafac warar Faraw̃o ỹa matëndëɗëhi: ntëpëtëɗeru nkaf ŋi, kaŋëɗeru hn'atëh do wusëry w̃a njijëɗëni cëhëndënihi.» ");
INSERT INTO cou_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ga ndëcëk wafac warar, Faraw̃o ỹa, ambënt fac le nagahniko ỹa ntiɗëho; më nëgehnëhnëkëhni roka sankaf fop vële naw̃ëndëko va. Më cëɗëtehnëkëhni vësankaf vëhi va do njoyini haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tac më mbësaka aryënkwëryënkw a ɗoku lëw̃u ỹa. Do arac kol mbok njelëhnënda këlëw̃a ŋa gë koɓëri ka, ");
INSERT INTO cou_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ɓare ahigëna ỹa, kaŋehna hn'atëh. Koyëna ntiyako wante pëƴahnëko Yosef ŋa. ");
INSERT INTO cou_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ɓare asankaf vële yëɗaɗëha Faraw̃o ỹa ile ceɗ ỹa ndënkwëkawo Yosef. ");
INSERT INTO cou_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ga ndëcëk wabëhn waki, Faraw̃o ỹa ndakeryëko: tëfary sën Nil hna kahnëko. ");
INSERT INTO cou_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Awa më nukëhni wuhni mbëɗ gë wuhi (7) wuhonah wuwamah ga ndanëtajëɗëni sën hna, pëgwëlehnëni ndavëndëni dël ɓë tëfary sën ŋa. ");
INSERT INTO cou_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tac wuhni wuw̃eh do wusamah mbëɗ gë wuhi (7) wuhaw̃ary ndanëtagëlehnini sën hna, njini hn'ile nkeni wuhonah wuwamah hna. ");
INSERT INTO cou_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Wuhni wuw̃eh do wusamah w̃a më tokënihëhni wuhonah wuwamah w̃a. Hnë wati rac, Faraw̃o ỹa nëgalehn taŋ. ");
INSERT INTO cou_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Më mbokak ndak do mbok ndakery higëna: nuko waƴënt vantimp mbëɗ gë waki (7) hnë uriry ryampo fo cantëko, ntëw̃ëko ɗus do nkwamëko. ");
INSERT INTO cou_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tac, waƴënt mbëɗ gë waki (7) wakaw̃ary santëgëko, wante kankënëko sël vë wula ŋa. ");
INSERT INTO cou_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Awa waƴënt wakankah ŋa më kohnëk wadëw̃ah wagwamah ŋa. Hnë wati rac, Faraw̃o ỹa mbok nëgalehn do kamahnëko ndakeryëk. ");
INSERT INTO cou_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pacënd tuŋ, Faraw̃o ỹa paƴehnëlehnëhni vambilaƴo va fop do gë vicër vëvë Esipët va. Ga tëkini më tëfëtanëkëhni huɗakery hudëw̃u ha, ɓare ahnë ƴëtëlohna ile pëhnëtanëk ỹa. ");
INSERT INTO cou_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Awa asankaf vële yëɗaɗëhawo Faraw̃o ỹa ile ceɗ ỹa më teɓak wanës ŋa ntehn: «Ahnaw̃, ñaɗëfu hnësu dol ile ryënkwëɓuho ỹa. ");
INSERT INTO cou_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ante ntavëkino g'asankaf vëwul mburu va do g'ami, cëɗentuhëfuno hnë kaso asankaf vëyëka vëlëw̃ hu hna. ");
INSERT INTO cou_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Fuhnë vëhi tak ndakeryëɓunëho hn'umëɗ tac fo, huɗakery fu ha nëmpëlëko. ");
INSERT INTO cou_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ajar aramp Ebëre yentiko gë fuhnë kaso hna, umë ryokuŋëhnëɗëhawo asankaf vëyëka kaso ỹa. Tëfëtanëhnëɓunëhawo huɗakery fu ha do pëƴakëfuno ale-wo-le ile pëhnëtanëk hudëw̃u ha. ");
INSERT INTO cou_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Awa, fop gante pëƴakëfuno ka ntiyako: ami, mbokaryiɓu ɗoku mën hna, do aỹëntaw̃ a kaŋik.» ");
INSERT INTO cou_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Awa Faraw̃o ỹa më ntehnëk njinëhni Yosef kaso hna. Njinëhnëlehni ñap caniji kaso hna; më karëtik, tac nkwëcëti viỹi va do njoyi vëhni Faraw̃o hna. ");
INSERT INTO cou_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Arac më ntehnëka: «Huɗakery ryakeryëɓu, do ahnë kolëna nësëhno ile pëhnëtanëk ỹa. Ɓare nkwëryëɓu ga nësëɗe wëjë huɗakery hunte fëƴayiru ha, njëtëru ile pëhnëtanëk ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosef më ntëkwaka Faraw̃o ỹa: «Gena ami, W̃ënu ŋa hoɗ nësëhni ile pëhnëtanëk ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Awa Faraw̃o ỹa më ntehnëka aki Yosef: «Huɗakery mën hna, tëfary sën Nil hna kahnëɓuho. ");
INSERT INTO cou_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Umë hnuɓuhëhni wuhni mbëɗ gë wuhi wuhonah wuwámah ga ndanëtajëɗëni sën hna, pëgwëlehnëni ndavëndëni dël ɓë tëfary sën ŋa. ");
INSERT INTO cou_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tac wuhni wuw̃eh do wusamah mbëɗ gë wuhi (7) wuhaw̃ary ndanëtagëlehnini sën hna, njini hn'ile nkeni wuhonah wuwámah; camëniho ɗus, koɓëri nulëw̃ëhni hna Esipët hna fop gë wurac ki. ");
INSERT INTO cou_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Awa më kohnënihëhni wuhonah wuwamah w̃a. ");
INSERT INTO cou_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Do ante kohnënihëhniwo ŋa, ƴëtëɗelohna iñë kohnëni, wëla tac nkoniho camëni gë koɓëri ka. Hnë wati rac nëgaɓuho. ");
INSERT INTO cou_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Tac më vokëɓu ryakeryu: nuɗëfuho waƴënt vantimp mbëɗ gë waki (7) hnë uriry ryampo fo cantëko, ntëw̃ëko ɗus do nkwamëko. ");
INSERT INTO cou_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tac, waƴënt mbëɗ gë waki (7) wakaw̃ary, wante kankënëk sël vë wula ŋa, më cantëgëk. ");
INSERT INTO cou_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Awa waƴënt wakankah ŋa më kohnëk wadëw̃ah wagwamah ŋa. Pëƴaɓuhëhni waŋi fop vambilaƴo vi, ɓare wëla aryampo hnë vëhni kolëna nësëhno ile pëhnëtanëɗ ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosef më ntëkwaka Faraw̃o ỹa: «Huɗakery wuhi hu w̃i iñë ryampo fo pëhnëtanëk. W̃ënu ŋa fëƴaki koyëna ile ñaɗ nti ỹa. ");
INSERT INTO cou_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Wuhni wuhonah mbëɗ gë wuhi w̃a (7) gë waƴënt wagwamah vantimp mbëɗ gë waki ŋa (7), wabëhn mbëɗ gë waki (7) pëhnëtanëk. Awa huɗakery huɗampo fo ye. ");
INSERT INTO cou_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Wuhni wusamah mbëɗ gë wuhi (7) wuỹëntaw̃ w̃a gë waƴënt mbëɗ gë waki (7) wante kankënëk sël vë wula ŋa fëna, wabëhn mbëɗ gë waki (7) pëhnëtanëk, ɓare wabëhn wakwëhn inte yeɗ. ");
INSERT INTO cou_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Awa Faraw̃o, gante ntehnakëmi ki: W̃ënu ŋa fëƴaki koyëna ile ñaɗ nti ỹa. ");
INSERT INTO cou_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Wabëhn mbëɗ gë waki (7) wante yejëk ŋi roka ỹa njivëɗ ɗus Esipët li fop. ");
INSERT INTO cou_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tac, nkeɗ wabëhn mbëɗ gë waki (7) inte, do goɗena ndënkwëtande wabëhn mbëɗ gë waki (7) wante njivahnëko roka ŋa; inte ŋa ñoñ tavëɗina nkal li. ");
INSERT INTO cou_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Soŋe inte ŋaƴah tac, goɗena ndënkwëtande roka le yivëko hn'inkal hna. ");
INSERT INTO cou_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Do ge nuru ga ndakeryëru iỹi sifa huɗakery hutac fo wahwënta wahi, W̃ënu ŋa fëhnak do ɓiỹëɗina ntiɗ. ");
INSERT INTO cou_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Awa tame, tëhnaryehna ale hwëhnak hakili, satëk do ahwëtehnahna nkal iŋi. ");
INSERT INTO cou_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Naw̃ëndëryihni fëna vahnë. Vahnë vërac rëkëɗ mbarëpëndëni ivëryëna hn'ile-wo-le varëpik hnë wabëhn mbëɗ gë waki wante njivahnëɗ roka ŋi fop. ");
INSERT INTO cou_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Mbarëpëɗëni roka yaɓah hnë wabëhn mbëɗ gë waki (7) wante yejëk ŋi. Pehnëɗëni g'uw̃ac hu hnë vandank, wahnaw̃ hna fop. ");
INSERT INTO cou_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Koyëna vahnë va fop kwëhnaɗëni ile tokëɗëni hnë wabëhn mbëɗ gë waki (7) inte hna fop. Antë inte ŋa përëkan nkal iŋa.» ");
INSERT INTO cou_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iỹi siyab Yosef, Faraw̃o ỹa caŋahnëkawo gë vësankaf vëlëw̃u per. ");
INSERT INTO cou_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Awa Faraw̃o ỹa më ntehnëkëhni: «Aỹi asan pëɓëka Iƴir W̃ënu ŋa. Koɗen bi nuỹayina ale lëbëka?» ");
INSERT INTO cou_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Awa më ntehnëka Yosef: «W̃ënu ŋa njëtëndanëki iỹin fop, awa ahnë koɗina kwëhna hakili do cat ntëbi wëjë. ");
INSERT INTO cou_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wëjë yeɗ nkaf nkal mën iŋi, do ɓulunda mën ỹi fop maw̃ëndënihi. Wëla ami dënk, uw̃ac Faraw̃o ỹa fo lëbahnëɗëmi.» ");
INSERT INTO cou_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraw̃o ỹa më mbok ntehnëka Yosef: «Awa, tame njëɗami aye nkaf nkal mën iŋi fop.» ");
INSERT INTO cou_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Do Faraw̃o ỹa më ndënëtak anënk ucankaf ntëw̃u ŋa ndënëka Yosef; më cuɗëka viỹi vësankaf do ñaba gëb hna wanjere sanu. ");
INSERT INTO cou_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tac, më kaƴëndëka saret higëna lëw̃u hna ile pehnëhniko ale ỹak rëhaka ỹa, do vële ryënkwaryëkëhniwo va ndekaɗëniho: «Kërënaryin nkaw̃ hna!» Koyëna njëɗakawo Faraw̃o ỹa Yosef ucankaf uŋa Esipët hna fop. ");
INSERT INTO cou_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraw̃o ỹa më mbok ntehnëka kat Yosef: «Faraw̃o ỹa yeɓu. Ɓare ge gena wëjë w̃aw̃ëk, ahnë ƴelëɗina rufa ỹa ma kërëcët fary ỹa nkal li fop.» ");
INSERT INTO cou_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraw̃o ỹa më njëɗaka Yosef uw̃ac haw̃ary, Tësafënat-Paneya, do njëɗahna ñëla Asënat, aryagu Potifera, asëna wasaɗëha avë inaw̃ nte w̃acik On ŋa. Koɓëri tac Yosef nkwayëtako nkal Esipët ŋa fop. ");
INSERT INTO cou_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosef wabëhn wafëhw warar (30) kwëhnako ante pëgwëko ndokuŋëhnënda Faraw̃o ỹa. Më kërënaka Faraw̃o ỹa do nkwayëta nkal iŋa fop. ");
INSERT INTO cou_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Hnë wabëhn mbëɗ gë waki (7) uvetak hna, roka ỹa njivëɗëho dus. ");
INSERT INTO cou_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosef mbarëpëko roka yaɓah Esipët hna, hnë wabëhn watac. Ndanëko vankol vacankaf hna roka le varëpiko wahaỹ hna. ");
INSERT INTO cou_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mbarëpëko roka yaɓah ɗus; njaɓëko ntëbi nkërëƴal nte ye itëfary wov, koɗelohna mboki ndëkwi, kaɓi njaɓëko ɗëcët. ");
INSERT INTO cou_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ani gë tëkahnindo inte ŋa, Asënat, asëvalu Yosef, vucan vuki nagëko. ");
INSERT INTO cou_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef Manase macëkawo fandënkwëryënkw fa, kaɓi umë lehnëko: «W̃ënu ŋa ndënkwehnëko ambër mën ŋa fop do gë fop tere rëm mën ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Efërayim macëkawo fakigëna fa, kaɓi umë lehnëko: «W̃ënu ŋa njëɗakow̃ëhni vutah hn'inkal nte haỹëhnahnëɓuho hna.» ");
INSERT INTO cou_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Wabëhn wante njivahnëko roka Esipët ŋa puko. ");
INSERT INTO cou_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Awa pëgwëlehn wabëhn mbëɗ gë waki (7) inte ŋa, gante pëƴahnëko Yosef ka. Inte ŋa campëko wayal hna fop, ɓare Esipët hna nkeho roka. ");
INSERT INTO cou_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ante pëgwëniho vëvë Esipët korotëndëni inte ŋa, ndekandënihawo Faraw̃o ỹa njëɗahni ile tokëɗëni. Arac më ntëkwakëhni ɓulunda ỹa fop: «Tëƴëryina Yosef do diryin ile ntehnëɗëhu ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ante tënkëko inte ŋa nkal hna fop Yosef më piɗëtehnëk fop vandank va do nkwafëndëhni roka ỹa vëvë Esipët va. Inte ŋa nkoko nkwënand kat Esipët hna. ");
INSERT INTO cou_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wayal hna fop, vahnë va njijëɗëniho soŋe daw̃ roka vëhni Yosef hna, kaɓi inte ŋa mbërendëhëhniwo vahnë va gante-wo-gante. ");
INSERT INTO cou_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ga njëtak Sakob roka wafëɗe Esipët hna, më ntehnëkëhni viju: «Soŋe ye ỹëw̃ërun ani ayëkëlëndu? ");
INSERT INTO cou_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Njëtaɓu nkehëhna roka Esipët hna. Ƴiryin alëw̃aju, soŋe antë cëmin inte.» ");
INSERT INTO cou_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Awa vicëru pëhw Yosef va njilehnëni gë Esipët ntëw̃ajëni roka ỹa. ");
INSERT INTO cou_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sakob tavëlawohna aheryu Yosef, Besame njinti, kaɓi nahaɗëho: «Antë nkeja iñë w̃eh.» ");
INSERT INTO cou_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Viju Sakob va tëkëlehnëni Esipët hna gë vahnë vëhaw̃ary vële yintiko lëw̃a roka, kaɓi inte ŋa nkeho gante-wo-gante Kanan hna fëna. ");
INSERT INTO cou_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosef yeho asankaf avë nkal ŋa fop. Umë wafëɗëhëhniwo roka ỹa vahnë va fop. Vicëru tëkëlehnini ndëkwëhnëni haryënkw lëw̃u wayëka w̃a nkal hna. ");
INSERT INTO cou_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef nundëhni tuŋ vicëru, njavëtëlehnëhni, ɓare ndënkwehnakëhniwo do ŋañënahnëhni tëƴëhni: «Ne nkejërun?» Më ntëkwaniha: «Kanan yejëɓun, lëw̃a roka yijëɓun.» ");
INSERT INTO cou_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Koyëna njavëtëkëhniwo Yosef vicëru, ɓare vëhni vëyavëtëlawohna. ");
INSERT INTO cou_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Awa Yosef më ndëkwëtak huɗakery hunte ndakeryëko ha soŋe lëw̃ hni ha më ntehnëkëhni: «Vëyëkëtehna yerun! Njijërun soŋe ayëtu ile nkok kwëhnana fanka nkal iŋi.» ");
INSERT INTO cou_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Më ntëkwaniha: «Hali, Ahwëhn fu, ndëwa roka fo yijëɓun. ");
INSERT INTO cou_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Fuhnë fop vutah asan aryampo fo yeɓun. Vahnë vësatah yeɓun, gelëfuhna vëyëkëtehna.» ");
INSERT INTO cou_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosef më ntëkwakëhni: «Gena toña! Njijërun soŋe ayëtu hnë cape nte nkok kwëhnana fanka nkal iŋi.» ");
INSERT INTO cou_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Më ntëkwani: «Vucan pëhw gë vuki (12) yeɓunëho, vutah asan aryampo fo yeɓun, hn'inkal Kanan hna matiɓun: fatëkwa fa gë rëm fu ỹa nkohëni do aryampo gona.» ");
INSERT INTO cou_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ɓare më ntehnëkëhni: «Ile hnësëɓu ỹa dihëtëɗa: vëyëkëtehna yerun. ");
INSERT INTO cou_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Njëtëɗëfu ge toña hnësëɗun: ntëkëɓu g'intaw̃ary Faraw̃o ŋa, cahnëɗiluhna nkal li ge gena arëkwa hun a rëkik ani. ");
INSERT INTO cou_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Paƴëryina aryampo hnë w̃uhnë njinëhna arëkwa hun a, hara vëỹëntaw̃ va kaso hna nkoɗëni. Koyëna njëkëɗe wanës hun ŋa ge toña hnësëɗun. Ge gena toña, g'intaw̃ary Faraw̃o ŋa, vëyëkëtehna yerun.» ");
INSERT INTO cou_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yosef më cëɗehnëkëhni vicëru wafac warar. ");
INSERT INTO cou_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Hnë fac rarëna hna, më ntehnëkëhni: «Ami ntakëɗëho gë W̃ënu ŋa. Awa, ge ñaɗiluhna asëmu, wëli ile lehnëɗëmu aliwu ỹa. ");
INSERT INTO cou_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ge vahnë vële hnësëɗ toña yerun, maw̃ëryin aryampo hnë w̃uhnë nko kaso li; vëỹëntaw̃ va njonëhnënihëhni roka ỹa vëvë watere hun vële njok inte va. ");
INSERT INTO cou_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tac, ƴonëhninowa arëkwa hun a. Koyëna njëtëɗëfu toña hnësëɗun do cëmëɗiluhna.» Vicëru Yosef maw̃ëlehnëni ntini koyëna. ");
INSERT INTO cou_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tac ntehnëlëɗëniho: «Soŋe ile liyinëka ahery fu ỹa finiŋahninëkëfu: nuyinëko yiw̃ëhnah lëw̃u w̃a, ante këlaɗëhëfuno ŋa, do nëpayilënawohna. Soŋe rac yehahninëk fuhnë dënk tame hnë iỹi yiw̃ëhnah.» ");
INSERT INTO cou_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Riben më ntëkwakëhni: «Pëƴalunohna bi: antë aliwuna iỹi sifa w̃eh faŋi fatah! Ɓare nëpalunow̃ohna. Tame cosanden soŋe cëm dëw̃u ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Vëyëtëlohna Yosef nkwëryëɗëho wante nësëɗëniho ŋa kaɓi ahnë rëkëtëlehnëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Awa Yosef më ŋaw̃ëtakëhni do kond. Tac mboka ɗarël lëw̃ hni hna pëƴahni Simeỹo tavëɗ kaso hna do ñabehna tase lëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosef më ntehnëkëhni vëryokuŋ vëlëw̃u va pëɓënëhnënihëhni roka ỹa wësaku walëw̃ hni hna, do mbokaryi koryi lëw̃ hni ỹa ale-wo-le saku lëw̃u hna do fëna njëɗayini ile valëhëɗëhëhni soŋe uyas w̃a. Do koyëna ntinëhniniho. ");
INSERT INTO cou_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Më ndiɓëndënihëhni roka ỹa wafali walëw̃ hni w̃a njilehnëni. ");
INSERT INTO cou_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ante tëryaniho hn'ile ndakëɗëni hna, aryampo hnë vëhni më pëtëk saku lëw̃u ỹa soŋe njëɗahna ile tokëɗ fali falëw̃u fa, do nuko koryi lëw̃u ỹa saku hna. ");
INSERT INTO cou_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Më ndekak ntehnëhni vëỹëntaw̃ va: «Nurun! Mbësayiɓu koryi mën ỹa! Ani nke, saku mën li!» Pëmpëhnahnëkëhniwo ɗus do ntakëhni. Më tëƴëlëɗëni: «Ye la ntikëfu aki W̃ënu ŋi?» ");
INSERT INTO cou_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ante tëkëniho Kanan vëhni rëm hni, Sakob, më pëƴaniha fop ile yejëkëhni ỹa. ");
INSERT INTO cou_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Vëhni lehnëko: «Asan ale ye asankaf avë Esipët ỹa njapënanëkëfuno. Vëyëkëtehna yeɓun ntehnëkëfuno. ");
INSERT INTO cou_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Awa, më lëkwaɓunëha: “Gelëfuhna vëyëkëtehna, ɓare vësatah yeɓun. ");
INSERT INTO cou_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Pëhw gë vëhi yeɓunëho, vucan rëm ryampo fo; aryampo gona do fatëkwa fa gë rëm fu ỹa nkohëni hn'inkal Kanan hna.” ");
INSERT INTO cou_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","«Asan arac më ntehnëkëfu: “Ge vahnë vële hnësëɗ toña yerun, maw̃ëryin aryampo hnë w̃uhnë nko hnani. Vëỹëntaw̃ va njonëhnënihëhni roka ỹa vëvë watere hun vële njok inte va. ");
INSERT INTO cou_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tac ƴonëhninowa arëkwa hun a. Njëtëɗëfu koyëna toña hnësëɗun, do geluhna vëyëkëtehna. Awa tac mbësaɗëmuna aỹënta hun aỹi do tavëɗëmu ayasëlehnëndu nkal li gante ñaɗun ka.”» ");
INSERT INTO cou_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ante njëpëtëniho roka ỹa hnë wësaku walëw̃ hni hna, ale-wo-le hnë vëhni tëkatëko fakufa koryi lëw̃u fa gë koryi per, do ga nuni koryi lëw̃ hni rac, ntakëkëhniwo gë rëm hni Sakob per. ");
INSERT INTO cou_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Awa rëm hni Sakob më ntehnëkëhni: «Ñaɗun antë woryaryëw̃ëhni vutah mën va: Yosef gona; Simeỹo nulëw̃ahna, do ñaɗun ahnufëhnunow̃a Besame! Ami nkeɗ iỹin fop!» ");
INSERT INTO cou_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Riben më ntehnëka: «Kwëtehnandew̃a ami, mëncënaniɗëmina. Ge mëncënanilinahna, ndaw̃ëɗuhëhni vijë mën vëhi vi!» ");
INSERT INTO cou_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ɓare Sakob më ntëkwak: «Hali, ajë mën aỹi ƴiɗina gë w̃uhnë. Acëru cëmëk, umë fo woryaryëɓu fëmba hnëmu fa. Ge uw̃eh yehëka nkaw̃ hna, cëmëɗëfu ntavah soŋe hun ỹa gante cërëɓu ki.» ");
INSERT INTO cou_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Inte ŋa g'ahaw̃ary mbërehnëɗëhëhniwo vahnë va hn'inkal Kanan hna. ");
INSERT INTO cou_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Awa tere Sakob ỹa, ga puhnëni roka ile ntëw̃ajëniho viju Esipët hna, Sakob më ntehnëkëhni: «Ɓokëryin ayiwu alëw̃aju roka toƴe.» ");
INSERT INTO cou_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuɗa më ntëkwaka: «Asankaf Esipët ỹa nësëhnëkëfuno wapacëk, ɓokëɗilëfuhna hahnëfu haryënkw lëw̃u ge arëkwa fu ỹa ƴintina. ");
INSERT INTO cou_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ge maw̃ëru arava Besame yofuna, njiɗëfun lëw̃ajëfu roka ỹa. ");
INSERT INTO cou_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ɓare ge ŋwëỹëryaruha, ƴiɗilëfuhna, kaɓi asan a më lehnëkëfuno, ɓokëɗilëfuhna hahnëfu haryënkw lëw̃u ge arëkwafu ỹa ƴintina.» ");
INSERT INTO cou_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Sakob më ntehnëkëhni: «Soŋe ye lëntahnërunëho aki afëƴawuna aỹi asan kwëhnarunëha ahery ale wok hnani?» ");
INSERT INTO cou_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Më ntëkwaniha: «Umë rëƴëkëfuno waƴaɓah, soŋe lëw̃ fu do gë soŋe tere fu. “Rëmun ỹa, nkok bi? Kwëhnarunëha bi fakery fakaw̃ary?” Ile tëƴëkëfuno ỹa fo lëkwaɓunëho. Ƴëtëlëfunohna ntehnëɗëhëfu: “Ƴojëna arëkwahuna.”» ");
INSERT INTO cou_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuɗa më ntehnëk: «Apa, maw̃ëry arava Besame yow̃a. Tëfëka yifu, ge ñaɗelënëhna cëmin, wëjë, gë fuhnë do gë vutah fu va. ");
INSERT INTO cou_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kahnëndaɓu yewu ankaf soŋe lëw̃u ỹa. Ami yeɗ ale w̃enëka haryënkw hu ɗuniỹa mën hna fop ge mëncënanilinahna. ");
INSERT INTO cou_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Do ge ɓiỹakëndilëfuhna ani, njikëndëɓun vokajëfu wahwënta wahi.» ");
INSERT INTO cou_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Awa rëm hni më ntehnëkëhni: «Kaɓi koyëna nke, diryin aki: taw̃ëryin wësaku hun hna vifërën vivë nkal dëw̃ fu va ayonëhnuna asan arac. ");
INSERT INTO cou_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ɓokaryëryin koryi le rëkatërun wësaku hun hna. Mpëd ale raw̃ëk aỹi dina mpër. Ƴoryin fëna koryi haw̃ary. ");
INSERT INTO cou_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tame, ƴoryina ahery hun aỹi avokawu g'asankaf avë Esipët. ");
INSERT INTO cou_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Araɓi W̃ën Hwëhn Fanka Fop ŋa ntihna kaỹëhnahna gë w̃uhnë do tavihni Simeỹo gë Besame aw̃ënceryiwuni. Ge ami ye, araɓi wow̃ fatah këm, ge koyëna tëfëko!» ");
INSERT INTO cou_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Awa viju Sakob va më nufëni waɓuña ŋa gë koryi haw̃ary ỹa. Njilehnëni gë Besame Esipët hna do njini tufëhnani vëhni Yosef hna. ");
INSERT INTO cou_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosef, ga nuka Besame gë vëhni, më ntehnëka ale yeho asankaf vëryokuŋ vëvë tere lëw̃u va: «Ƴiryeryëryihni vëỹi ỹal mën hna, ɗaw̃ehnëryehna icaw̃ do ahnëgehna, kaɓi vëỹi g'ami tokëɗëfun g'anent ga.» ");
INSERT INTO cou_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Asan a më ntik ile ntehnëkawo Yosef ỹa, njiryeryëkëhniwo viju Sakob va tere Yosef hna. ");
INSERT INTO cou_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ante ntehniniho tënkëni tere ŋa, ntakëkëhniwo. Ntehnëlëɗëniho: «Soŋe koryi ile vokaryiko hnë wasaku fu ỹa ye ante njijinëko ryënkwëryënkw ŋa. Njoɗënihëfu soŋe njohahnënihëfu ntinihëfu vëramp do nufënihëhni wafali fu w̃i.» ");
INSERT INTO cou_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Më tëhaniha ankaf vëryokuŋ vëvë tere Yosef va rënka tere hna, ");
INSERT INTO cou_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ntehnëniha: «Këlayiru tavëndifu, asankaf: ndënkwëɓunëho yijëfu hwënta ryampo lëw̃a roka ani. ");
INSERT INTO cou_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Awa wamënca ŋa, ga tëkëɓun hn'ile ndakëɗëfunëho hna piɗëtëɓunëho wësaku fu w̃a, do ale-wo-le tëkatëko koryi ỹa saku lëw̃u hna, gante nkeho koryi le law̃ahnëɓunëho roka ka dënk. Awa mbokaryiɓun tame, ");
INSERT INTO cou_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","do njojëɓun koryi haw̃ary law̃ahnëfu roka ỹa. Ƴëtëlëfuhna bi mo raw̃ëko koryi ỹa wësaku fu hna!» ");
INSERT INTO cou_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ɓare ankaf vëryokuŋ vëvë tere Yosef va më ntëkwak: «Ñëw̃ëryin ƴam, antë ntaku. W̃ënu hun ŋa ye, W̃ën rëmun ŋa, kwëtëhnëku koryi ỹi wësaku hun hna; koryi hun ỹa teɓaɓuho.» Tac, tavëlehna Simeỹo. ");
INSERT INTO cou_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Asan a ndënëlehnëhni tere Yosef hna. Më njonëhnikëhni w̃ënka nkuyëtahnëni wapary ŋa do njëɗayini wafali w̃a ile tokëɗëni. ");
INSERT INTO cou_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Më pëhwëtëni waɓuña ŋa napatëndëniha Yosef tëki g'anent ga. ");
INSERT INTO cou_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tëkind tuŋ Yosef tere hna, më njëɗaniha waɓuña wadëw̃ hni ŋa, tac ndëkwëhnëni haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosef më tëƴëkëhni bi hak nkoni, tac më nkwënëk: «Hak nkok rëmun lafah ale hnësëhnërunëhow̃a ỹa? Nkontik bi?» ");
INSERT INTO cou_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Më ntëkwaniha nkotëni ndëkwëhnëni haryënkw lëw̃u: «Aryokuŋëhn hu ỹa, rëm fu ỹa, nkontik do ki fo nkok.» ");
INSERT INTO cou_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tac Yosef më nuka Besame, aheryu ỹa, aju hnëmu. Më tëƴëk: «Nësëhnërunëhow̃o soŋe arëkwa hun a. Umë bi ye aỹi?» Më nkwënëk: «Araɓi W̃ënu ŋa ndëwani, fatah mën!» ");
INSERT INTO cou_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosef njiw̃ëhnahnëkawo ɗus ante nukawo aheryu Besame ŋa, do wankwën ŋa tëmpëkawo vinkër hna. Cahnëlehn ñap do nji cery ntëw̃u hna soŋe ko. ");
INSERT INTO cou_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tac më nkwëñajëk do cahnëlehni. Nduñënako do ntehn nëhëti roka ỹa. ");
INSERT INTO cou_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosef hnë taɓali minu nëhëtëhniko, hara vicëru g'aheryu hnë taɓali haw̃ary nkeniho. Vëvë Esipët vële w̃acehnaryiko ỹalu va fëna minëhni tokëɗëniho, kaɓi vëhoɗilohna tokëlahnëni gë Wa-ebëre: namu ikwëtahn dëw̃ hni ŋa mbañëko. ");
INSERT INTO cou_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosef gë vicëru g'aheryu paɓëlëniho. Gante mbaỹëlëni ka cariniho, aryënkwëryënkw a hafo arëkwa hna. Njëkëlëɗëniho g'ufëmpëhnahnah. ");
INSERT INTO cou_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosef më nëhëtehnëhnëkëhni hnë vanëhëta vante yeho taɓali lëw̃u va. Më nëhëtehnëhnëka Besame uhnëhët ule fëɓëk ntëbi wahwënta imbëɗ wëɓa vicëru ŋa. Do ceniho uñen ƴaɓah gë Yosef. ");
INSERT INTO cou_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ga mbiỹëk, Yosef më ntehnëka ankaf vëryokuŋ vëvë tere lëw̃u va: «Pëɓënëry wësaku viỹë vahnë, ƴëɗaryihni roka yaɓah ile koɗëni njoni. Taw̃aryiry fëna koryi ỹa wësaku hni hna. ");
INSERT INTO cou_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Hnë saku ale ỹak vak hna taw̃ëɗu koryi ỹa do ñërya mën nte ryëhwarik koryi ŋa fëna.» Asan a më ntik ile ntehnëkawo Yosef ỹa. ");
INSERT INTO cou_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ga tëk pac, tavëlehnini njini viju Sakob gë wafali walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Cahnëlehnëni naw̃ hna, ɓare vëỹaw̃ënëlohna ten ɗus ante ntehnëkawo Yosef ankaf vëryokuŋ vëvë tere lëw̃u va: «Tëfëlehnëryihni vëỹi vahnë arëkahni. Tëƴëryihni: “Ntinëhnirun ufërën awa soŋe ye sosahnërun uw̃eh? ");
INSERT INTO cou_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Soŋe ye lerun ñërya koryi nte cehand do cihnand ale ryokuŋëhnëɗëfu ỹa? Uw̃eh sankaf ye ile lirun ỹi!”» ");
INSERT INTO cou_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Asan a më tëkakëhni do ntehnëhni watac. ");
INSERT INTO cou_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Më ntëkwani: «Asankaf, hak koɗu alehnëfu aki? Muk koɗilëfuhna lifu iñë gë iỹi ki! ");
INSERT INTO cou_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mbokaryiɓun koryi le rëkatëɓunëho hnë wësaku fu Kanan hna. Awa soŋe ye leɗëfun koryi ma sanu tere ale ryokuŋëhnëɗu ỹa? ");
INSERT INTO cou_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ge tëkatik aŋi ñërya hnë saku aryampo hnë fuhnë, ndaw̃i! Do fuhnë dënk nkeɗëfun vëramp hu.» ");
INSERT INTO cou_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Asan a më ntëkwak: «Awa, dinëfu gante nësërun ki. Ɓare hnë ale tëkatëɗe ỹa, umë fo yeɗ aramp mën a; vëỹëntaw̃ va afaya nkeɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Më cëlëndëni ale-wo-le ñap saku lëw̃u ỹa do piɗëtëni. ");
INSERT INTO cou_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Asan a më njëkëk fop wësaku w̃a pëgw hnë va ale sërëhnëkëhni hna do tëkwahn fatoƴ fa. Më tëkatëk ñërya ŋa hnë saku Besame hna. ");
INSERT INTO cou_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Awa vicëru më cëfëhnëkëhni hafo citëni viỹi vilëw̃ hni va do mbokaryëni ndiɓëndënihëhni wafali w̃a wësaku w̃a tac mbokani g'inaw̃. ");
INSERT INTO cou_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Awa ga tëkëni Yuɗa gë vicëru do gë vëheryu vëhni Yosef hna, Yosef hnam fo nkoko. Më ndëkwëhnëni wayëka w̃a nkal hna haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef më ntehnëkëhni: «Soŋe ye lirun iỹin? Ƴëtëluhna bi asan g'ami ki kwëhnaɓu fanka soŋe yëtu fop?» ");
INSERT INTO cou_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuɗa më teɓak wanës ŋa ntehn: «Asankaf, ñoñ koɗilëfuhna alëkwayi. Ñoñ gena ile hoɗ tufahn nufëlëfuhna. Ɓare W̃ënu ŋa rufahnëk ile w̃enëɓun ỹa, awa vëramp hu yeɗëfun g'ale yokëh ñërya ŋi per.» ");
INSERT INTO cou_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosef më ntehnëkëhni: «Hali, koɗa liwu koyëna. Ale yokëh aỹi fo yeɗ aramp mën. Ɓare w̃uhnë mëncëryin ƴam gë vëhni rëmun.» ");
INSERT INTO cou_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuɗa më tëhaka Yosef do ntehn: «Këlami asankaf, njëtëɓu këñëlantun gë Faraw̃o ỹa, ɓare maw̃ëryanërye vok hnësu kat, hara davëlihna g'ami. ");
INSERT INTO cou_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ante ndënkwëɓunëho yijëfu ŋa, tëƴëruhëfuno bi nkoryaryëɓunëha rëm gë ahery ahaw̃ary. ");
INSERT INTO cou_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Më lëkwayiru: “Nkoryaryëɓunëha rëm lafah lëw̃ fu ỹa, gë ahery aryampo, ale nagëhnika hn'untaf ntëw̃u hna. Rëm fu ỹa umë ñak ñaɗ ɗus, kaɓi fatah fatac fo wok fëmba hnëmu fa; aju aỹëntaw̃ a cëmëk.” ");
INSERT INTO cou_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Më lehnëruhëfu: “Ƴonëhninowa hnuw̃a.” ");
INSERT INTO cou_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Më fëƴayiru: “Fatah fa koɗina ŋaw̃ëtahna rëmu; ge ŋaw̃ëtaka, cëmëɗ.” ");
INSERT INTO cou_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɓare më lehnëruhëfu: “Ge ahery hun a tëfëlëntijina gë fuhnë ɓokëɗilëfuhna hahnëfu haryënkw hu.” ");
INSERT INTO cou_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«Awa ga mbokaɓun vëhni rëm fu hna, aryokuŋëhn hu ỹa, më fëƴaɓunëha wante lehnëruhëfu ŋa. ");
INSERT INTO cou_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ga mbiỹëk më ntehnëkëfu vok yijëfu law̃ëfu le rokëɗe. ");
INSERT INTO cou_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Më lehnëɓunëha: “Koɗilëfuhna yifu, ge gena ahery fu ỹa rëfëlëntik. Ge tëfëlëntina, asankaf avë nkal ỹa dëkwajëɗilëfu hna.” ");
INSERT INTO cou_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«Rëm fu ỹa më ntëkwakëfu: “Njëtërun ɗus, asëval mën a Rasel vucan vuki fo nagëhnëkow̃ëhni. ");
INSERT INTO cou_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Aryampo hnë vutac njik; ntiyahnëko intaw̃ ŋañah rokëka, kaɓi ɓokëla hnuw̃a, ");
INSERT INTO cou_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","do aỹandu ahnufëhnunow̃a faŋi fëna! Gante cërëɓu ki ge w̃eh yejëk a, ntiɗunëho ntavah nte ryaw̃ëɗëho.” ");
INSERT INTO cou_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Awa tame, asankaf, koɗa w̃ëncu vëhni rëm mën hna hara ƴolëw̃ahna fatah fi. Ntaw̃ary rëm mën ŋa fatah li nke. ");
INSERT INTO cou_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Cëmëɗ ge mëncëntina. Awa fuhnë yeɗ vële ryaw̃ëka g'antavah va hn'untaf ntëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Do kat, pëƴahnëɓu ami ye ankaf fatah fi haryënkw rëm mën hna; ntehnëɓuha: “Ge mënceryilëw̃a hna, ami yeɗ ale lëntahnëki ỹa kwëlëkwël.” ");
INSERT INTO cou_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Këlami, maw̃ëryanërye wow̃ ami ryokuŋëhnëndi had aramp, hnëmpëtëw̃a fatah fi, soŋe mëncëntahni gë vicëru vëỹëntaw̃ vi. ");
INSERT INTO cou_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Koɗa muk vokawu gë vëhni rëm mën hara tëfëlëlëfuhna gë fatah fi. Koɗa ryuñënaw̃ hnuw̃a rëm mën ỹa hnë horot le ỹaɗ nkehna ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Awa Yosef koɗilohna nko nduñëna haryënkw vële hwëhnëkawo va; më ntehnëkëhni cahnëni. Koyëna umë fo woko gë vicëru g'aheryu ante tufëhnakëhniwo bi mo nke ŋa. ");
INSERT INTO cou_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ɓare koɗëho ɗus hafo vële canëko va nkwëryëɗënihawo, do wakasëk watac tëkëko hafo cery inaw̃ Faraw̃o hna. ");
INSERT INTO cou_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosef më ntehnëkëhni vicëru g'aheryu: «Ami ye, Yosef! Rëm fu ỹa nkok bi?» Ɓare vëhni vëhoɗilohna ntëkwaniha, ntakëkëhniwo ɗus g'umë. ");
INSERT INTO cou_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Awa Yosef më ntehnëkëhni: «Tëhajëno.» Më tëhaniha. Yosef më mbok ntehnëkëhni: «Ami ye, Yosef, ahery hun ale wafërunëho soŋe yoyiwu Esipët hna. ");
INSERT INTO cou_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tame, antë pëɓu yiw̃ëhnah do antë ahniralu kaɓi aki nkwafërunëho. W̃ënu ŋa ryënkwehniko ani, soŋe holahnu fehëtu. ");
INSERT INTO cou_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Wëli, inte ŋa nuỹak wabëhn waki (2) nkal li do nkojëk wabëhn mbëɗ (5) uyam g'iɓarëp geɗina. ");
INSERT INTO cou_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","W̃ënu ŋa ryënkwehniko hn'iŋi nkal, ahwëhnahnuni hnënk do awontiwu; pehët cankaf ye. ");
INSERT INTO cou_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","«Awa gena w̃uhnë sañëtiko ani, W̃ënu ŋa ye. Do umë fëna liko yewu asankaf aryënkwëryënkw ale ỹak hwëhnak nafa ava Faraw̃o ỹa avë Esipët aỹi: ami ye nkaf acery inaw̃ Faraw̃o ŋa do ye fëna asankaf inkal Esipët ŋa fop. ");
INSERT INTO cou_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Tame, ƴiryin ñap alehnuna apa: “Ajë hu Yosef më lehnëk: W̃ënu ŋa naw̃ëndëko hn'inkal Esipët hna fop. Ƴij ỹal mën hna hara ɓiỹëlihna. ");
INSERT INTO cou_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Hnë resiỹo Gosen hna ntëɗëɗun gë vutah hu va, gë vërah hni, wape hu ŋa, wuhnankal hu w̃a, wuhni hu w̃a do fop ile hwëhnëru ỹa. Koyëna ɗarël mën nkeɗu. ");
INSERT INTO cou_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ami njëɗaɗëmi ile valëɗëhi ỹa fop, wëjë, tere hu ỹa, do gë wusaw̃ hu w̃a, soŋe antë nkoji iñë, kaɓi ani gë wabëhn mbëɗ (5) inte ŋa nkoɗ.”» ");
INSERT INTO cou_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yosef më nkwënëk: «Do wëli: nuɗun w̃uhnë dënk, do ahery mën aỹi Besame fëna nuɗ, paryi nke ami Yosef hnësëhnëɗëhu. ");
INSERT INTO cou_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Awa ƴiryin afëƴawuna apa fop nafa le hwëhnaɓu hnë Esipët ỹa, do pëƴaryina fop le hnurun ỹa. Tac ƴojëna ñap ani.» ");
INSERT INTO cou_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yosef më muryaka Besame, aheryu, pëgwëlehn kond; Besame fëna koɗëho. ");
INSERT INTO cou_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yosef muryakëhniwo fëna vicëru kotënd ɗus. Ga ndëcëk umë, vëhni fop nësëlëɗëniho g'umë. ");
INSERT INTO cou_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ga njëtayik cery inaw̃ Faraw̃o hna vicëru g'aheryu Yosef va tëkëni Esipët hna, Faraw̃o ỹa gë vësankaf vële rëhakawo va natëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraw̃o ỹa më ntehnëka Yosef: «Dehnëryihni vicër hu g'ahery hu ndiɓëndënihëhni wafali walëw̃ hni w̃a do mëncëni gë Kanan, ");
INSERT INTO cou_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","soŋe njinëhnëniha rëm hni gë watere wadëw̃ hni ŋa njojënihëhni ani. Hnë resiỹo le ỹak vetak hnë Esipët hna njëɗaɗëfuhëhni ntëɗëni, do ile ỹak fërënak hnë Esipët ỹa rëkëɗ tokëndëni. ");
INSERT INTO cou_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ntehnëɗuhëhni fëna nufëni wasaret Esipët li njohahninihëhni vësëval hni, vutah hni do gë rëm hni. ");
INSERT INTO cou_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tëfëlahna njahnani soŋe viỹë vile tavëhëɗëni hnam va. Kaɓi, hnë resiỹo le ỹak vetak hnë Esipët hna njijëɗëni ntëɗëni.» ");
INSERT INTO cou_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Viju Sakob va më ntini ile ntehniniho ỹa. Yosef më njëɗakëhni wasaret w̃a gante ntehnëkawo Faraw̃o ka, tac gë vile valëhëɗëhëhni hn'ankaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Më mbuñakëhni vëhni fop ale-wo-le viỹi viwamah. Ɓare Besame, viỹi imbëɗ (5) mbuñakawo gë waŋëc koryi wakeme watar (300). ");
INSERT INTO cou_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Më njëɗanahnëka rëmu wafali pëhw (10) wale ryiɓëndik viỹë vifërën vivë Esipët, gë wafali ipëhw (10) wale ryiɓëndik roka, vamburu do gë vile rokëɗe soŋe uyas lëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yosef më ntehnëkëhni antë nkwajëlëhëndëni nkaw̃ hna. Tac koyalëni. ");
INSERT INTO cou_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Matëlehnëni Esipët hna mëncëni gë Kanan do tëkëni vëhni rëm hni Sakob hna. ");
INSERT INTO cou_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Më pëƴaniha: «Yosef cëmëna! Do umë ye asankaf Esipët ỹa fop.» Cëmëkawo mbahn iŋa, ɓare koɗilohna kwëtahnëhni. ");
INSERT INTO cou_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Më tëfëtanëniha fop ile nësëko Yosef ỹa. Tac Sakob më nuk wasaret wale njëɗanahnëko Yosef njohahni w̃a. Awa nkelehn had ale sëmëko njënat. ");
INSERT INTO cou_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Do më ntehnëk: «Ha, pacëko: ajë mën a Yosef cëmëna ten. Afo yiwu hnuw̃a ani gë sëmahnëndu ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Sakob kahnëtalehn gë fop ile kwëhnëko ỹa. Ga tëkëk Berëseba, më ntinëhnëka saɗëha W̃ën rëmu Isak ỹa. ");
INSERT INTO cou_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Hn'umëɗ tac, W̃ënu ŋa nësëhnëkawo wati nte ndakëko wakwëɗ ŋa. Macëkawo: «Sakob! Sakob!» Më ntëkwaka: «Mëtaɓu, nëpaɗëmi.» ");
INSERT INTO cou_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","W̃ënu ŋa më ntehnëka: «W̃ën rëmuh ŋa yeɓu. Antë ntaki ayi gë Esipët, kaɓi hnam, vutah vërah hu va njaɓëɗëni hafo nkeni ɓulunda sankaf. ");
INSERT INTO cou_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ami dënk lapëhnaɗëhi, do mbokaryiɗëmi fëna. Ge cëmëru, Yosef paɓëɗ iñas hu ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Awa Sakob matëlehn Berëseba hna. Viju njonihawo gë vutah hni do gë vësëval hni hnë wasaret wale njëɗanahnëko Faraw̃o ỹa soŋe uyas w̃a. ");
INSERT INTO cou_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Njonihëhniwo fëna wusaw̃ wulëw̃ hni w̃a do gë fop ile kwëhnaniho hn'inkal Kanan ỹa do njini gë Esipët, Sakob gë tere lëw̃u ỹa fop. ");
INSERT INTO cou_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Koyëna njiko Sakob gë Esipët gë vëlëw̃u va fop: vutahu gë vërah hni. ");
INSERT INTO cou_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Wëlin wamac vutah Sakob, nte w̃aciko Isërayel, vële yiko Esipët va: fandënkwëryënkw fa Riben yeho, ");
INSERT INTO cou_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","do vutah Riben va, vëhni ye: Enok gë Palu gë Hesëron do gë Karëmi. ");
INSERT INTO cou_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Vutah Simeỹo va, vëhni ye: Yemuwel gë Yamin gë Ohad gë Yakin gë Sohar do gë Sawul, aju asëval avë Kanan ỹa. ");
INSERT INTO cou_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Vutah Levi va, vëhni ye: Gerëson gë Kehat do gë Merari. ");
INSERT INTO cou_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Vutah Yuɗa va, vëhni ye: Er gë Onan gë Sela gë Peres do gë Sera. Er gë Onan hn'inkal Kanan hna cëmëniho. Peres vutah vuki kwëhnako: Hesëron gë Hamul. ");
INSERT INTO cou_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Vutah Isakar va, vëhni ye: Tola gë Puva gë Yasub do gë Simëron. ");
INSERT INTO cou_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Vutah Sabilon va, vëhni ye: Sered gë Elon do gë Yahëlel. ");
INSERT INTO cou_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Vëhni yeho vutah Leya gë Sakob vunte hnagiko Mesopotami gë vërah hni. Nagënihawo fëna facëval: Dina maciko. Viju gë vëryagu wafëhw warar gë vërar (33) nkeniho fop. ");
INSERT INTO cou_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Vutah Gad va, vëhni ye: Sëfon gë Hagi gë Suni gë Esëbon gë Eri gë Arodi do gë Areli. ");
INSERT INTO cou_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Vutah Aser va, vëhni ye: Yimëna gë Yisëva gë Yisevi gë Beriya do g'ahery hni facëval fa Sera. Beriya vucan vuki nagëko: Heber gë Malëkiyel. ");
INSERT INTO cou_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Vuŋi vutah yeho vunte nagëhnëkawo Silëpa Sakob va, aryokuŋ asëval ale njëɗakawo Laban aryagu ỹa Leya. Ipëhw g'imbëɗ gë fandaw̃ (16) nkeniho. ");
INSERT INTO cou_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Viju Rasel, asëvalu Sakob va, vëhni ye: Yosef gë Besame. ");
INSERT INTO cou_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Esipët hna Yosef vutah vuki nuỹanihëhniwo g'asëvalu Asënat, aryagu Potifera, asëna wasaɗëha avë inaw̃ On ỹa: Manase gë Efërayim yeho. ");
INSERT INTO cou_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Vutah Besame va, vëhni ye: Bela gë Beker gë Asëbel gë Gera gë Naman gë Ehi gë Ros gë Mupim gë Hupim do gë Arëd. ");
INSERT INTO cou_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Vëỹi yeho vutah vunte nagëhnëka Rasel Sakob gë vërah hni va; vutah pëhw gë vunah (14) nkeniho. ");
INSERT INTO cou_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Aju Dan ỹa: Husim yeho. ");
INSERT INTO cou_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Viju Nefëtali va, vëhni ye: Yasiyel gë Guni gë Yeser do gë Silem. ");
INSERT INTO cou_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Vëỹi yeho vutah gë vërah hni mbëɗ gë vuki (7) vumba Bila gë Sakob va, aryokuŋ asëval ale njëɗakawo Laban aryagu ỹa Rasel. ");
INSERT INTO cou_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Vëvë tere Sakob, vële yiko Esipët do nagëko umë dënk va, nkeniho vahnë wafëhw mbëɗ gë ryaw̃ g'imbëɗ g'aryaw̃ (66) fop ka ỹa. Nkentiniho fëna vësëval viju va. ");
INSERT INTO cou_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gë vutah vuki vumba Yosef vunte hnagiko Esipët va. Fop vëvë tere Sakob vële lëɗëko hnë Esipët va nkeniho vahnë wafëhw imbëɗ gë wahi (70). ");
INSERT INTO cou_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Sakob, nte w̃acëɗeho fëna Isërayel, më paƴëka Yuɗa ndënkwah vëhni Yosef hna soŋe pëhwëtanëhnëhëndëhni itëk iŋa hnë resiỹo Gosen hna. Ga tëkëni, Sakob gë tere lëw̃u ỹa, Gosen hna, ");
INSERT INTO cou_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef më kaƴëk saret lëw̃u ỹa do kacahna rëmu. Nunda tuŋ rëmu, muryalehna do koɗëho hafo mbiỹ nkot muryahna. ");
INSERT INTO cou_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Awa Sakob më ntehnëka: «Wëla sëmu tame mena, kaɓi mbokëmi hnuỹi do cëmëlihna!» ");
INSERT INTO cou_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosef më ntehnëkëhni vicëru, g'aheryu, do gë vëỹëntaw̃ vëvë tere rëmu va: «Njiɗëfu fëƴaw̃a Faraw̃o ỹa, vicër mën va, g'ahery mën do gë fop tere rëm mën le yeho Kanan ỹa tëkini. ");
INSERT INTO cou_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Pëƴaɗëfuha vëhwëɗ wusaw̃ yerun, do njojërunëhëhni wape gë wuhnankal, gë wuhni hun w̃a do gë fop ile hwëhnarun ỹa. ");
INSERT INTO cou_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ge Faraw̃o ỹa macehnëku do tëƴu bi ye ye ɗoku hun ỹa, ");
INSERT INTO cou_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","dëkwaryina vëhwëɗ wusaw̃ yerun koɓëri ante nkorunëho vutah ŋa hafo gaki, gante ntiɗëniho vacërakëlo hun ka. Koyëna maw̃ëryanëɗerun alëɗu hnë resiỹo Gosen hna, kaɓi vëvë Esipët va ñew̃ënihëhni vëhwëɗ wusaw̃ va fop.» ");
INSERT INTO cou_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Awa Yosef më njik pëƴahna Faraw̃o ỹa ntehna: «Rëm mën ỹa gë vicër mën va do g'ahery mën a tëkini. Kanan matini gë wape wadëw̃ hni ŋa gë wuhnankal w̃a gë wuhni w̃a do gë fop ile kwëhnani ỹa. Tame hnë resiỹo Gosen hna nkeni.» ");
INSERT INTO cou_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tac Yosef më nufëkëhni vicëru imbëɗ (5) va tufa Faraw̃o ỹa. ");
INSERT INTO cou_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Arac më tëƴëkëhni: «Ye ye ɗoku hun ỹa?» Më ntëkwaniha: «Faraw̃o ỹa, vëhwëɗ wusaw̃ yeɓun gë vacërakëlo fu ka. ");
INSERT INTO cou_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hn'inkal Kanan hna, inte ŋa njaɓëk ɗus hafo gona ile tokëɗëni wusaw̃ fu w̃a. Soŋe umë yijëɓun lëɗëntifu ani. Maw̃ëryanëryifu lëɗëntifu hnë resiỹo Gosen hna.» ");
INSERT INTO cou_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraw̃o ỹa më ntehnëka Yosef: «Kaɓi tame rëmuh gë vicër hu do g'ahery hu njijëni ɗarël hu, ");
INSERT INTO cou_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","inkal Esipët ŋi fop hnë vák hu nke. Ƴëɗaryihni ntëɗëni hn'ile ỹak përënak nkal Esipët hna. Koɗëni ntëɗëni hnë resiỹo Gosen hna. Do ge kamahnëruhëhni hnë vëhni vële ỹak holëk ikwëɗ, kwëtehnahnëryihni wusaw̃ mën w̃a dënk.» ");
INSERT INTO cou_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yosef njokawo fëna rëmu vëhni Faraw̃o hna tufëndëlehnëhni. Sakob nkaỹëkawo Faraw̃o ỹa g'untënah, ");
INSERT INTO cou_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","do Faraw̃o ỹa më tëƴëka: «Wabëhn waƴëhw hwëhnaru?» ");
INSERT INTO cou_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Sakob më ntëkwaka: «Wabëhn keme gë wafëhw warar ye (130) ga nkwërëtalehnahnëɗëfu hn'inkal gë inkal. Wabëhn mën ŋa ndëcëk ñap, do korotëɓu. Nuỹala ten wabëhn wante nuỹaniho vacërakëlo mën vële wërëtalehnëɗëho gë ami ki va.» ");
INSERT INTO cou_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Sakob më mbok nkaỹëka kat Faraw̃o ỹa do cahn cery inaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Awa Yosef më njëɗaka rëmu gë vicëru do g'aheryu ntëɗëni hnë nkal nte ỹak fërënak Esipët ŋa, hnë resiỹo Ramëses hna, gante ntehnëkawo Faraw̃o ka. Më njëɗakëhni inkal nte kwëhnëɗëni vëhni. ");
INSERT INTO cou_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Më njëɗakëhni ile rëkëɗ tokëndëni vëhni rëmu gë vicëru g'aheryu, ale-wo-le gante tëkwëk tere lëw̃u ka. ");
INSERT INTO cou_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Inte ŋa njaɓëko hafo ile rokëɗe golohna inkal hna fop. Esipët hna gë Kanan hna, vahnë va camëniho ɗus soŋe inte ŋa. ");
INSERT INTO cou_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosef mbarëpëko fop koryi vëvë Esipët va do gë vëvë Kanan va ile ntaw̃andëniho roka ỹa do maruŋehn hnë cery inaw̃ Faraw̃o hna. ");
INSERT INTO cou_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ante nkok gona koryi Esipët hna gë Kanan hna per, vëvë Esipët va më njini ntehnëniha Yosef: «Ƴëɗaryifu ile rokëɗëfun. Ñaɗu bi sëmëfu ayëkatëndëfu, kaɓi goryaryëlëfuhna koryi?» ");
INSERT INTO cou_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef më ntëkwak: «Ge goryeryëluhna koryi, ƴëɗaryinow̃ëhni wusaw̃ hun w̃i, do ami, njëɗaɗëmu ile rokëɗe.» ");
INSERT INTO cou_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Awa më njojënihëhni wusaw̃ wulëw̃ hni w̃a njëɗaniha Yosef: wafahnac w̃a gë wape ŋa gë wuhnankal w̃a gë wuhni w̃a do gë wafali w̃a. Yosef më njëɗakëhni roka ỹa. Bëhn rac njëɗakëhniwo ile tokëɗëni, nkwëcëtëlëni gë wusaw̃ wulëw̃ hni w̃a fop. ");
INSERT INTO cou_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Bëhn le ryaviko hna, më mbokajëni ntehnëniha Yosef: «Asankaf, koɗelihna asow̃i soŋe afëƴayi goryaryëlëfuhna koryi do wëjë hwëhnëkëhni tame wusaw̃ fu w̃i. Ñoñ goryaryëlëfuhna le hoɗeru alehni njëɗaɗeru. Vimbahn fu vi fo woryaryëɓun gë wayal fu w̃i. ");
INSERT INTO cou_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ñaɗu bi sëmëfu ayëkatëndëfu do ravëfu wayal fu w̃i? Daw̃ëryifu gë wayal walaw̃ëfu w̃i do ayëɗafu ile rokëɗëfun. Nkeɗëfun vëramp Faraw̃o ỹa do umë hwëhnëɗ wayal fu w̃i. Ñaɗilëfuhna sëmëfu. Ƴëɗaryifu wanëɗa holahnëfu woryaryëfu walaw̃ary fu w̃a do hara wayal fu w̃i gena fëk.» ");
INSERT INTO cou_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yosef më ntaw̃ëhnëka Faraw̃o ỹa fop wayal wavë Esipët w̃a, kaɓi inte ŋa nkwënako do avë Esipët-wo nkwafëɗëho kaỹ dëw̃u ŋa. Koyëna, nkal Esipët ŋa fop Faraw̃o ỹa hwëhnëko ");
INSERT INTO cou_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","do Yosef vëramp ntikëhniwo fop vëvë Esipët va. ");
INSERT INTO cou_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Wayal vësëna wasaɗëha va fo nkoko daw̃ëna Yosef, kaɓi nkeho sariya le kahnëndëko Faraw̃o ỹa soŋe lëw̃ hni ỹa. Ile ndemaɗëhëhniwo Faraw̃o ỹa tokëɗëniho, umë nkoniho vëwafahnëna wayal walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef më ntehnëkëhni ɓulunda ỹa: «Awa, ntaw̃ëhnëɓuha Faraw̃o ỹa wayal hun w̃a gë w̃uhnë per. Tame njëɗaɗëmu uhnëɗa ule hnaɗëɗun wëhaỹ hna. ");
INSERT INTO cou_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ɓare njëɗaɗunëha Faraw̃o ỹa ivëryëna-wo hnë ile varëpërun hna. Ile wok ỹa w̃uhnë hwëhnëɗ. Rac rëkëɗun ahnaɗëndu do arokëndu, w̃uhnë gë vutah hun va do gë vële lëɗëlantun va.» ");
INSERT INTO cou_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Më ntëkwaniha: «Pehëtëɗëhëfu cëm iŋa. Kaɓi kwëhnaru nëf ŋa gë fuhnë, maw̃ëɓun yefu vëramp Faraw̃o ỹa.» ");
INSERT INTO cou_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Awa Yosef më kahnëndëk sariya le wok hafo dol: Esipët hna, ivëryëna-wo hnë ile varëpik hna Faraw̃o ỹa hwëhnëk. Wayal vësëna wasaɗëha va fo nkoko kwëhnëna Faraw̃o ỹa. ");
INSERT INTO cou_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ɓulunda Isërayel ỹa Esipët hna ntëɗëniho, resiỹo Gosen hna. Nuỹaniho hnapul, nagëlëniho do njaɓëni ɗus. ");
INSERT INTO cou_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sakob ntiko wabëhn pëhw g'imbëɗ gë waki (17) Esipët hna. Wabëhn keme gë wafëhw wahnah g'imbëɗ gë waki (147) nuỹako fop ka ỹa cëmat. ");
INSERT INTO cou_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ante nkëhnëko cëm ŋa, më macëka aju Yosef do ntehna: «Ge ñaɗuho, tufërye iña hu ŋa do gë kahnënda hu ŋa: kuyëtëry vák hu ỹi mbuf mën li, alëkëhno alehn ɓañëɗilihohna Esipët li. ");
INSERT INTO cou_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ge cëmëɓu, njoɗu iñas mën ŋa ayi ahwët ƴag vacërakëlo mën hna.» Yosef më ntëkwak: «Ntiɗëfu ile rëƴëruho ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Sakob më mbok ntehnëka: «Dëkëhnërye.» Yosef më ntëkëhnëka. Awa Sakob më tënkwëk do camehn. ");
INSERT INTO cou_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ga ndëcëk watac, më pëƴayik Yosef ntehni rëmu tesëk. Më njini gë viju vëhi va, Manase gë Efërayim. ");
INSERT INTO cou_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ante pëƴayiko Sakob ntehni aju ỹa, Yosef, njijëk njëka, më njaw̃ënak mat ntaña pad dëw̃u hna ");
INSERT INTO cou_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","tac ntehna Yosef: «W̃ën Hwëhn Fanka Fop ŋa karyëtahnëkowo Lus hna, hn'inkal Kanan hna do ndëwakowo. ");
INSERT INTO cou_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Umë lehnëkowo: “Njëɗaɗëmini vutah vujaɓah soŋe lihahni rëm kore waɓulunda. Njëɗaɗëfuhëhni iŋi nkal vutah hu va kwëhnëni kwëlëkwël.”» ");
INSERT INTO cou_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sakob më nkwënëk: «Vutah vuki vuntëw̃ hu vunte hnagik Esipët yihahnëryindu ỹa, had vutah mën nkeni. Efërayim gë Manase ami hwëhnëkëhni had gante kwëhnëɓuhëhni vëhni Riben gë Simeỹo ki. ");
INSERT INTO cou_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ɓare vële vokëɗeru ahnagëhnihni va, wëjë woɗ ahwëhnëhni. Hn'inkal vicër hni hna nuỹaɗëni sah intëw̃ dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ante matiɓuho Mesopotami ŋa, hara tëk iŋa yeɓuho Efërata hn'inkal Kanan hna, cëmëko hnëmuh Rasel nkaw̃ hna. Më vañëɓuha hnam, tëfary nkaw̃ hna.» Efërata w̃ac lëw̃u w̃a tame Betëlem ye. ");
INSERT INTO cou_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Hnë wati rac nukëhniwo Sakob viju Yosef va do tëƴ: «Vëhni mo ye vëỹi?» ");
INSERT INTO cou_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef më ntëkwak: «Vijë mën vële njëɗakow̃ëhni W̃ën ani Esipët va ye.» Rëmu më mbok ntehnëk: «Tahëndihni ɗarël mën ryëwanëw̃ëhni.» ");
INSERT INTO cou_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Sakob cërëko ɗus do golohna nund ɗus. Awa Yosef më tahëndëkëhni viju. Sakob më muryakëhni do mbucëhni. ");
INSERT INTO cou_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tac më ntehnëka Yosef: «Diyantow̃ohna mbokëɗëmi hnuỹi, ɓare wëli W̃ënu ŋa maw̃ëryanëko hnuw̃ëhni wëla vutah hu va.» ");
INSERT INTO cou_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Awa Yosef më nufëkëhni vërahu va, wavuf rëmu hna, do ndëkwëhn yëka ỹa nkal hna. ");
INSERT INTO cou_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tac pëlahni viju wëɓák ŋa: Efërayim, nte yeho g'irëhw lëw̃u ŋa, g'irahahn Sakob nkeho do Manase nte yeho g'irahahn lëw̃u ŋa, g'irëhw Sakob nkeho. Më mbok tahëndëkëhni kat rëm sankaf lëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ɓare Sakob më nëmpëndëlehnëk wëɓák ŋa: më tindëk vák rëhw lëw̃u ỹa hn'ankaf Efërayim hna mama nkehahnëko umë fante ỹak vak fa, do vák rahahn lëw̃u ỹa hn'ankaf Manase nte yeho fandënkwëryënkw fa. ");
INSERT INTO cou_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Do wëli gante ndëwanëkawo Sakob Yosef ka: «O W̃ën, wëjë ye W̃ën hunte cëmbëɗëniho vëhni rëm mën sankaf Abëraham gë rëm mën Isak ỹa, W̃ën hunte heryëɗëho koɓëri ga nagahniɓu, ");
INSERT INTO cou_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","mëleka le fehëtëko hnë fop wameh hna yeru fëna: tëƴëɗëmi aryëwanëhni vuŋi vutah. Araɓi soŋe lëw̃ hni ỹa ryënkwëtandefu ami gë rëm sankaf mën ỹa Abëraham do gë rëm mën Isak fëna! Araɓi nuỹanihëhni vutah vujaɓah ɗus gante-wo-gante nkal li!» ");
INSERT INTO cou_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ga nuk Yosef rëmu hn'ankaf Efërayim hna tindëk vák rëhw lëw̃u ỹa, më pëmpëhnahnëka; më pëlak vák rëmu ỹa soŋe tindët hn'ankaf Efërayim hna do tind hnë mba Manase hna, ntehn: ");
INSERT INTO cou_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","«Hali, apa, mpaỹëmpaỹaki. Aỹi ye fandënkwëryënkw fa. Tindëryehna umë vák rëhw hu ỹi.» ");
INSERT INTO cou_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ɓare rëmu ŋwëỹëko do ntehna: «Njëtëɓu, ajë mën, njëtëɓu. Vutah Manase va fëna ɓulunda yaɓah yeɗ. Ɓare aheryu lëbëɗëha umë do vutah vunte hnagëɗe hnë umë va ntiɗëni ɓulunda yaɓah.» ");
INSERT INTO cou_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hnë fac rac, aki njëɗakëhniwo ɗëwara lëw̃u ỹa: «Ɓulunda Isërayel ỹa, gë wamac hun ŋa rëkëɗëni ndëwahnëndëni. Rëkëɗ ntehnëndëni: “Araɓi W̃ënu ŋa kwëhna nëf soŋe hun ỹa gante kwëhnako soŋe Efërayim gë Manase ka!”» Sakob koyëna ndënkwëndëkawo Efërayim ten tac acëru Manase. ");
INSERT INTO cou_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tac më ntehnëka Yosef: «Ɓiỹëɗina cëmëɗëfu, ɓare W̃ënu ŋa gë w̃uhnë nkeɗun do mbokaryëɗëhu g'inkal vacërakëlo hun hna. ");
INSERT INTO cou_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wëjë yëɗaɗëfu sah le lëbëk va vicër hu g'ahery hu ỹa, njëɗaɗëmi resiỹo Sisem le reɓëɓuhëhni Wa-amor gë sëlame mën ỹi do gë uŋwary mën ŋi.» ");
INSERT INTO cou_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Sakob macëkëhniwo viju do ntehnëhni: «Ɓarëpëlin ñaɗëfu fëƴaw̃u ile yeɗëhu haryënkw ỹa. ");
INSERT INTO cou_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«“Ɓarëpëlin do ahnëpaw̃u, vutah mën, nëparyino ami, rëmun, Isërayel. ");
INSERT INTO cou_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Wëjë, Riben, wëjë ye ajë mën aryënkwëryënkw a, ale ryënkwëɓuho hnagu ante nkoko njaɓo fanka ŋa. Wëjë lëbëkëhni vëhery hu vi untënah ŋa gë fanka fa; ");
INSERT INTO cou_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","had sën le w̃acëk yeru. Ɓare goɗila ale ỹak njaɓëk nafa ỹa, kaɓi cëfëhnanëruho aryaku pad mën hna g'asëval mën aryampo. ");
INSERT INTO cou_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeỹo gë Levi ndanko fo nkeni: nkwëryëlëni soŋe ntini uw̃eh. ");
INSERT INTO cou_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ɓare gentandela ile pëhnani ỹi, ƴantëɗela pankël dëw̃ hni ŋa. Kaɓi hnë ntavah ntëw̃ hni hna ndaw̃ënihëhni vahnë do hnë nëh ntëw̃ hni hna ntëpëtënihëhni wuhni w̃a vënkahn wapary ŋa. ");
INSERT INTO cou_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Araɓi ntavah ntëw̃ hni ŋa ndëwani w̃eh, ntavah ƴapah ɗëcët ŋa. Campehnëɗëfuhëhni vële hnagëɗe hnë vëhni va Isërayel hna, campehnëɗëfuhëhni nkal hna fop. ");
INSERT INTO cou_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuɗa, vicër hu gë vëhery hu njëw̃ëɗëni icëmb hu ŋa. Cikëɗuhëhni vëỹew̃ hu va arënkwëndëhni forosima, do vicër hu gë vëhery hu va dënk ndëkwëhnëɗëni haryënkw hu. ");
INSERT INTO cou_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ha, ajë mën, Yuɗa, had fambësëhn fante rokëka intaw̃ do vokaɗ gë ryëka lëw̃u nkeru. Paryi had vësëhn ile lañaɗ do ryakëɗ nkeru. Mo hoɗ matëndi forosima? ");
INSERT INTO cou_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Fanka ucankaf fa hnë tere Yuɗa hna nkoɗ. Ryoko vësankaf ỹa hnë vák vële hnagëɗe hnë umë hna nkoɗ, hafo tëki ale hwëhnëk paryi ỹa, ale maw̃ëhnëɗëni ɓulunda ỹa. ");
INSERT INTO cou_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Hn'ikaỹ waresen hna pokëɗëha fali falëw̃u fa, fapali fa hnë fasëc resen le ỹak yivëk hna; uñen hna ndagëɗ viỹi vilëw̃u va, cuɗ cankaf ntëw̃u ŋa w̃ënka waresen wavëntah hna. ");
INSERT INTO cou_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Uñen ƴaɓah ŋa ntancënëɗëha vinkër va do wambël waƴaɓah ŋa njerënëɗëha wabeñ ŋa. ");
INSERT INTO cou_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabilon tëfary wov hna ntëɗëɗ, le nke hahna wasisikulu hna. Inkal dëw̃u ŋa njiɗ hafo Sidon. ");
INSERT INTO cou_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar fali fayaw̃ah ye, yëbëlan wakece le liyik wamir waki ndakëɗ. ");
INSERT INTO cou_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kamahnëko ỹëw̃a fërën ye, do nkal nëŋah ye. Awa më maw̃ëk ndiɓëndënde waryiɓ w̃a, ɗoku vëramp maw̃ako. ");
INSERT INTO cou_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan naw̃ëndëhëhni ɓulunda lëw̃u ỹa gë wahnënk wavë Isërayel w̃i fop. ");
INSERT INTO cou_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan had lën vankaw̃ nke, had lën ỹañah hnë tëfary nkaw̃: lën ỹa ŋarëɗëha pahnac ŋa hwër hna do ale haƴëka ỹa njoɗ. ");
INSERT INTO cou_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ahwëhn W̃ën, kwëtahnëɓu pehëtëɗëho! ");
INSERT INTO cou_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, ge pëgwëniha wabandi ŋa, mëtaryëɗëhëhni do tëfëlehnëɗëhëhni. ");
INSERT INTO cou_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Hn'inkal Aser hna nkwamëɗ ɗus roka ỹa, nkal dëw̃u hna ntëw̃ëɗ roka le ñaɗëni vëhnaw̃ ỹa. ");
INSERT INTO cou_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nefëtali had incaw̃ nte yaryëlend afaya nke do hnagëɗëhëhni vutah vunkwamah. ");
INSERT INTO cou_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosef had atëh nte lëw̃ëɗ fëhnëk hnë tëfary garyëla nke. Wahni walëw̃u w̃a cëpëk kece kaỹ iŋa. ");
INSERT INTO cou_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Vësan fëgwëka, do lahëka gë wëca. ");
INSERT INTO cou_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ɓare njaw̃ënëk ɗus uŋwary ntëw̃u ŋa, wahnil walëw̃u w̃a gë wëɓák ŋa ñënkalahna. Gë fanka W̃ën yaw̃ah Sakob fa, ahery vahnë, itaka Isërayel. ");
INSERT INTO cou_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Araɓi W̃ën rëmuh hunte ryemaɗëhi ha, Hwëhn Fanka le ryëwanëɗëhi ỹa, njëɗayi rëv fërën, gë w̃ënka wante yalëɗ nkal li, gë vutah vuƴaɓah do gë wusaw̃ wuyaɓah. ");
INSERT INTO cou_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Waɗëwara rëmuh ŋa ntëbëk ɗus wëla waɗëwara wahuŋ wale yeho koɓëri w̃i. Ntëbëk hnapul vukuŋ vumb koɓëri vi. Araɓi ɗëwara dëw̃u ŋa pëlahna Yosef, ale ye asankaf vicëru g'aheryu ỹa! ");
INSERT INTO cou_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Besame had ỹin ỹañah nke. G'acahnëfëɗ ga, intaw̃ tokëɗ, do g'anëka ga cahëlehnëɗ ile wok ỹa.”» ");
INSERT INTO cou_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Vëỹi fop liko wahnënk pëhw gë wahi (12) Isërayel w̃a. Waŋi ntehnëkëhniwo rëm hni, ante nësëhnëɗëhëhniwo rëkwa ŋa. Ale-wo-le ndëwara minu ndëwanëkawo. ");
INSERT INTO cou_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Tac Sakob më ntehnëkëhni aki: «Ge cëmëɓu, kwëtëryino hn'iƴag vacërakëlo mën hna, iƴag nte ye hn'ikaỹ Efëron avë ɓulunda Het ỹa, ");
INSERT INTO cou_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makëpela hna, ɗarël Mamëre hna hn'inkal Kanan hna. Abëraham ntaw̃ëko iŋi kaỹ vëhni Efëron hna soŋe ƴag iŋi kwëhn umë. ");
INSERT INTO cou_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hnam mbañiniho g'asëvalu Sara, tac Isak fëna g'asëvalu Rebeka. Do ami dënk hnam mbañëɓuha Leya. ");
INSERT INTO cou_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kaỹ iŋa gë ƴag nte yeho hnam ŋa ɓulunda Het hna ntaw̃iko.» ");
INSERT INTO cou_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ga puhnak Sakob nësëhn tëkwa vërahu ŋa, më mbokak ndak, tac njilehn tëkëhëhni vacërakëlow̃u va cëm hna. ");
INSERT INTO cou_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Awa, Yosef më nëñëlëk vëhni rëmu hna gë wankwën wadëw̃u ŋa do muryahna. ");
INSERT INTO cou_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Tac ntehnëhni vëryokuŋ pëhwëtëniha rëmu. Awa vërac më pëhwëtëniha Isërayel ");
INSERT INTO cou_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","wafac wafëhw wahnah (40) kaɓi koyëna tëfëka cuci ñas iŋa gë wagu wanëŋah soŋe antë përëka. Vëvë Esipët va, wafac wafëhw mbëɗ gë wahi (70) kwëyënihawo Sakob. ");
INSERT INTO cou_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ga ndëcëk wakwëy ŋa, Yosef më ntehnëkëhni vële rëhakawo Faraw̃o va: «Ge ñaɗunëho, ɗemaryino afëƴanëhnunow̃a waŋi wanës Faraw̃o ỹa: ");
INSERT INTO cou_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Rëm mën ỹa ntëkehnëkow̃o cëmahnënd ỹa soŋe yiwu vañëw̃a hn'inkal Kanan hna, hn'iƴag nte ntiyako hna. Awa maw̃ëryanërye tame yiwu vañëw̃a, tac mbokajëɗëfu.”» ");
INSERT INTO cou_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraw̃o ỹa maw̃ëryanëhnëka Yosef nji mbañehna rëmu gante ntehnëko ka. ");
INSERT INTO cou_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yosef kahnëtalehn g'iɓañ rëmu; fop vësankaf va lapëhnakawo, vële ryokuŋëɗëho hnë cery inaw̃ Faraw̃o hna gë vële rëhakawo Faraw̃o va do gë vicër vëvë Esipët va fop, ");
INSERT INTO cou_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","gë tere lëw̃u ỹa fop gë fop vicëru g'aheryu do gë vëvë tere rëmu vëỹëntaw̃ va. Vutah vutoƴ va fo raviko hnë resiỹo Gosen hna. ");
INSERT INTO cou_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Vëhwëhn wasaret gë vëyaryary wafahnac lapëhnakawo; kore sankaf ɗus yeho. ");
INSERT INTO cou_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tëkëlehnëni hn'idap nte w̃acëɗe Atad hna gë cape pëhna lav sën Yurëdan ka. Hnam më ntinëhnëniha wakwëy wacankaf Sakob do njahnaɗëniho ɗus. Yosef koko soŋe icëm rëmu ŋa wafac mbëɗ gë wahi (7). ");
INSERT INTO cou_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Vëvë Kanan vële lëɗëko hnë resiỹo rac va ga nuni wakwëy watac më ntehnëni: «Wakwëy wacankaf Esipët ye!» Soŋe rac macahnëɗe cape pëhna lav sën Yurëdan rac Abel-Misërayim, umë fëhnëtanëk «Wakwëy Esipët». ");
INSERT INTO cou_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Koyëna viju Sakob ntiniho ile ntehnëkëhniwo rëm hni ntini ỹa: ");
INSERT INTO cou_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","njoniho iñas dëw̃u ŋa hn'inkal Kanan hna do kwëtëni hn'iƴag ɓë kaỹ Makëpela ŋa, ɗarël Mamëre hna. Abëraham ntaw̃ëko iŋi kaỹ vëhni Efëron avë ɓulunda Het ỹa soŋe ƴag iŋi kwëhn umë. ");
INSERT INTO cou_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef ga kwëtëk iñas rëmu ŋa ƴag hna, më mbokani gë vële lapëhnajëkëhniwo soŋe iɓañ rëmu va fop gë Esipët. ");
INSERT INTO cou_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ga ndëcëk wakwëy Sakob ŋa, vicëru Yosef më ntehnëlëni: «Tame kaɓi rëm fu ỹa cëmëk, Yosef koɗ nkwëcagëfu fop wameh wante liyinëka ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Awa më paƴehnëni pëƴayi Yosef aki: «Ani gë cëmahnënd rëm fu ỹa, aki ntehnëkëfuno: ");
INSERT INTO cou_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Pëƴanëndinow̃a Yosef: ‘Kaỹëhnandiỹi gë vicër hu, aravëhnëhni idënt ŋaƴah nte ntini ŋa, wameh wante ntinihi ŋa fop.’” Awa, maw̃ëry aravëhnëfu ile lëntahniru ỹa, fuhnë vële sëmbëɗëha W̃ën ryampo fo gë rëm fu ỹi.» Yosef pëgwëlehn kond ga pëƴayik waŋi. ");
INSERT INTO cou_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tac vicëru njilehnini vëhni dënk tëkatëniha, njoni haryënkw lëw̃u do ntehnëniha: «Vëramp hu yeɓun.» ");
INSERT INTO cou_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ɓare Yosef më ntëkwakëhni: «Antë ntaku. Gela W̃ën. ");
INSERT INTO cou_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ñaɗunëho aliwuno w̃eh, ɓare W̃ënu ŋa nkwëcëtëk w̃eh w̃a g'ifërën, maw̃ëk pehët walaw̃ary vahnë vëyaɓah, gante nuɗun dol ki. ");
INSERT INTO cou_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tame antë nkehahnahnu iñë: paɓëɗëmu w̃uhnë gë watere hun ŋi.» Gë waŋi wanës wanëŋah njamënëko wasakahn walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Koyëna Yosef gë tere rëmu ỹa Esipët hna nkoniho. Yosef wabëhn keme g'ipëhw (110) nuỹako. ");
INSERT INTO cou_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nuɗëhëhniwo ga nagëlëɗëni vutah aju Efërayim va gë vutah vërah vuntëw̃ hni va. Do nufëkëhniwo kwëɗëhni vutah vunte nagëko Makir aju Manase va. ");
INSERT INTO cou_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Fac ryampo Yosef më ntehnëkëhni vicëru g'aheryu: «Ɓiỹëɗina cëmëɗëfu, ɓare pacëko W̃ënu ŋa ndemaɗëhu. Matëndëɗëhu Esipët li soŋe njowu hn'inkal nte ntehnëkëhniwo vëhni Abëraham gë Isak do gë Sakob njëɗaɗëhëhni hna. ");
INSERT INTO cou_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Awa ge W̃ënu ŋa ntinëhnëku rac, dëkëndino alehnuno njoryaryëɗun iñas mën ŋa.» ");
INSERT INTO cou_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosef wabëhn keme g'ipëhw (110) nuỹako cëmat Esipët hna. Më sucik iñas dëw̃u ŋa gë wagu wanëŋah soŋe antë përëka, do kwëti hnë kesu itaka.");
INSERT INTO cou_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wëlin wamac vacërakëlo Yesu Këris ale hnagiko hnënk ahnaw̃ ale w̃aciko David, do David, umë dënk, hnë hnënk acërakëlo fu Abëraham hna nagiko. ");
INSERT INTO cou_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abëraham yeho rëm Isak ỹa. Isak yeho rëm Sakob ỹa. Sakob yeho rëm Yuɗa gë vëheryu. ");
INSERT INTO cou_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuɗa yeho rëm vëhni Peres gë Sera, hnëm hni ỹa Tamar yeho. Peres yeho rëm Hesëron ỹa. Hesëron yeho rëm Ram ỹa. ");
INSERT INTO cou_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram yeho rëm Aminadab ỹa. Aminadab yeho rëm Nason. Nason yeho rëm Salëma. ");
INSERT INTO cou_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salëma yeho rëm Bos, hnëmu ỹa Rahab yeho. Bos yeho rëm Obed, hnëmu ỹa Rit yeho. Obed yeho rëm Yese ");
INSERT INTO cou_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ale yeho rëm ahnaw̃ ale w̃aciko David ỹa. David yeho rëm Salomo ỹa, hnëmu ỹa Uri ryënkwëkawo ñëla. ");
INSERT INTO cou_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo yeho rëm Robowam ỹa. Robowam yeho rëm Abiya ỹa. Abiya yeho rëm Asa. ");
INSERT INTO cou_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yeho rëm Yosafat ỹa. Yosafat yeho rëm Yoram ỹa. Yoram yeho rëm Osiyas ỹa. ");
INSERT INTO cou_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas yeho rëm Yotam ỹa. Yotam yeho rëm Akas ỹa. Akas yeho rëm Esekiyas ỹa. ");
INSERT INTO cou_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas yeho rëm Manase ỹa. Manase yeho rëm Amon ỹa. Amon yeho rëm Yosiyas ỹa. ");
INSERT INTO cou_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyas yeho rëm Yekoniya gë vëheryu va wati nte pëlayiniho njoyini vëvë Isërayel Babilon hna. ");
INSERT INTO cou_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ante ndëcëk watac ŋa, Yekoniya yeho rëm Salatiyel. Salatiyel yeho rëm Sorobabel ỹa. ");
INSERT INTO cou_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel yeho rëm Abihud ỹa. Abihud yeho rëm Eliyakim. Eliyakim yeho rëm Asor. ");
INSERT INTO cou_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor yeho rëm Sadok. Sadok yeho rëm Akim. Akim yeho rëm Eliwud. ");
INSERT INTO cou_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwud yeho rëm Eliyasar. Eliyasar yeho rëm Matan. Matan yeho rëm Sakob. ");
INSERT INTO cou_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sakob yeho rëm Yosef, asanu Mari, hnëm Yesu ale w̃acëɗe Këris, Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Umë fop kore vacërakëlo pëhw gë wahnah yeho pëgw hnë mba Abëraham hna hafo David, pëhw gë wahnah mba David hna hafo nte njoyiniho vëvë Isërayel Babilon hna, do pëhw gë wahnah hnë iƴo tac hafo mba Arëhnayik hna. ");
INSERT INTO cou_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wëlin itëfëta soŋe hnagi Yesu Këris. Hnëmu ỹa, Mari, Yosef hwëhnëkawo; ɓare ñëlahnënda ỹa, gë fanka Iƴir Ipacah ŋa ndonkëko. ");
INSERT INTO cou_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef ale hwëhnëkawo ỹa, asan asatah yeho ɓare ñaɗilohna cëfëhnaỹehna ɓulunda hna; awa më pëhnak tava hara ƴëtayina. ");
INSERT INTO cou_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wati nte nahaɗëho watac ŋa, mëleka Ahwëhn a më karyëtahnëka hnë huɗakery do ntehna: «Yosef, fatah fante hnagik hnë hnënk David, ntë ntaki aỹëla Mari, ƴëtëry gë fanka Iƴir Ipacah fa ndonkëk. ");
INSERT INTO cou_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Facan nagëɗ. Yesu w̃acëɗuha, kaɓi umë fehëtëɗëhëhni ɓulunda lëw̃u ỹa hnë wameh wadëw̃ hni hna.» ");
INSERT INTO cou_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ỹinë fop nkeɗ ntiyahn wanës Ahwëhn wante nësehnëkawo kila Esayi ŋa: ");
INSERT INTO cou_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Fandag fante wok ƴëtëna vësan va ndonkëɗ do facan nagëɗ. Emaniyel macëɗe, umë fëhnëtanëɗ: W̃ënu ŋa gë fuhnë nkentik.» ");
INSERT INTO cou_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosef, ga nëgak, më ntik ile ntehnëkawo mëleka Ahwëhn ỹa: ñëlëka asëvalu Mari. ");
INSERT INTO cou_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɓare vëvankëlohna ipad g'umë afo naga aju do Yosef, Yesu macëkawo. ");
INSERT INTO cou_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu nkol Betëlem nagiko hnë nkal Yuɗe hna, wati nte nkeho Eroɗ ahnaw̃ ŋa. Ga nagik, vëyët wahol matëniho cape pëhna lav, njini hafo Yerusalem. ");
INSERT INTO cou_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ga tëkëni hnam më tëƴëni: «Ne nkeha ahnaw̃ wasëwif, ale hnagik takahn ỹa? Nuɓun kol nte rufahnëɗ nagik ŋa ga matik gë cape pëhna lav, do njijëɓun sëmbëfuna.» ");
INSERT INTO cou_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eroɗ ahnaw̃ a ga njëtak, umë pëmpëhnahnëkawo ɗus do gë vëvë Yerusalem va fop. ");
INSERT INTO cou_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Më macehnëkëhni fop vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va do tëƴëhni: «Ne ntehnëk Vikerëh va nagëɗe Arëhnayik a?» ");
INSERT INTO cou_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Më ntëkwaniha: «Betëlem, hnë nkal Yuɗe hna nagëɗe. Wëlin ile kerëk kila ỹa: ");
INSERT INTO cou_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«“Do wëjë Betëlem, antë ntiyahni gelihna nkol nte ñak mbak nafa ɓë Yuɗe.” Kwëhnaru nafa kaɓi hnë wëjë cahniɗ asankaf ale yeɗ had ahery ɓulunda mën ỹa, Isërayel.» ");
INSERT INTO cou_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Awa Eroɗ më macehnëkëhni ƴëmëƴëm fo vëyët wahol va tëƴëhni pëƴaniha bi iỹëhne wati cahnik ikol iŋa. ");
INSERT INTO cou_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tac paƴëhni gë Betëlem, ntehnëhni: «Ƴiryin arëƴalu wapacëk soŋe fatah fa; do ge nurunëha, ƴijën ayëtëndanuno soŋe ami fëna yiwu sëmbëntijiw̃a.» ");
INSERT INTO cou_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Vëyët va nëpaniho fop wanës ahnaw̃ w̃a, tac njilehnëni. Awa mbok nulehnëni kol nte sahniko gë cape pëhna lav ŋa. Ndënkwëhnëkëhniwo do ga tëkëk le nke fatah hna, tëryalehn. ");
INSERT INTO cou_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Vëyët va, ga nuni kol iŋa tëryak, pëɓëlehnëhni uhnatah sankaf. ");
INSERT INTO cou_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Më tënkëni tere hna do tëkatëniha fatah fa gë hnëmu, Mari. Awa më ndëkwëhnëni soŋe cëmbëniha fatah fa; tac më piɗëtëni wakufa wadëw̃ hni ŋa do njëɗëniha sanu, iɗuɗ, do gë ɗatikola hambah le w̃acik mir. ");
INSERT INTO cou_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tac, W̃ënu ŋa më pëƴakëhni hnë huɗakery antë mbokani gë vëhni Eroɗ; awa më tëfëni nkaw̃ kaw̃ary soŋe mëncëni gë ỹal hni. ");
INSERT INTO cou_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ga mëncëni vëyët va, mëleka Ahwëhn a më tufëhnaka Yosef hnë huɗakery do ntehna: «Matëry, nufëryehna fatah fi gë hnëmu do garyëryin hnë nkal Esipët hna. Ñëw̃ëryin hnam hafo ge ntehnëmi avokaju kaɓi Eroɗ njijëɗ njëkëlehna fatah fi soŋe ndaw̃ehna.» ");
INSERT INTO cou_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Awa Yosef më matëk hnë umëɗ tac dënk, nufa fatah fa gë hnëmu, do nkaryëni Esipët. ");
INSERT INTO cou_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hnam ñëw̃ëniho hafo cëm Eroɗ. Umë ntiyako nkehahn wante nësehnëkawo Ahwëhn W̃ënu ŋa hnë w̃ës kila hna: «Macëɓuha fatah mën fa soŋe cahn Esipët hna.» ");
INSERT INTO cou_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ante njëtëko Eroɗ vëyët va tokaniha, ntavëkawo ɗus, më ntehnëk ndaw̃ini fop vutah vucan va, Betëlem hna do gë vankol vante hwërëkawo va fop, fop vucan vunte hwëhnak wabëhn waki va hafo gëɗ; wabëhn vutah ŋa, gë wati le pacënëhnënihawo Eroɗ vëyët wahol va soŋe icahn ikol ŋa caŋëniho. ");
INSERT INTO cou_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Awa ntiyako wante nësëko kila le w̃aciko Seremi ỹa: ");
INSERT INTO cou_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Kopa wëryëɗe hn'ankol Rama hna, wako do gë iƴahna cankaf: Rasel hwëyëɗëhëhni vutah vuntëw̃u va; ŋwëỹëɗ mbosëvosehni, kaɓi cëmëni.» ");
INSERT INTO cou_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ga cëmëk Eroɗ, mëleka Ahwëhn a më tufëhnaka Yosef hnë huɗakery, Esipët hna. ");
INSERT INTO cou_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Do ntehna: «Matëry nufëryehna fatah fa gë hnëmu do avokawu g'inkal Isërayel, kaɓi vële yëkëlehnëɗëho ndaw̃ehnëniha fatah fa cëmëni.» ");
INSERT INTO cou_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Awa Yosef më matëk, nufa fatah fa gë hnëmu do mbokani g'inkal Isërayel. ");
INSERT INTO cou_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɓare Yosef njëtako ale w̃acik Arëselawos hnufëko ucankaf rëmu Eroɗ ŋa Yuɗe hna, awa më ntakëka soŋe mboka hnam. Ahwëhn a më mbok nësëhnëka hnë huɗakery, do njilehn hnë resiỹo vë Galile hna. ");
INSERT INTO cou_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ntëɗ hn'ankol nte w̃acik Nasaret. Koyëna nkeho ntiyahn wanës kila ŋa: «Avë Nasaret macëɗe.» ");
INSERT INTO cou_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hnë ƴamani rac, cahnëko San Ayary a hnë wula Yuɗe hna do karaŋëɗëhëhniwo vahnë va. ");
INSERT INTO cou_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ntehnëɗëhëhniwo: «Gwëcëtaryin vankeya va: Inaw̃ W̃ënu ŋa tëhajëk!» ");
INSERT INTO cou_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Soŋe San ỹa nësëɗëho kila le w̃aciko Esayi ỹa ante ntehnëko: «Ahnë ryekaɗ wula hna: “Pëhwëtëryin nkaw̃ Ahwëhn a, dinëndina vankaw̃ vacatah ɗus!”» ");
INSERT INTO cou_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","San viỹi vile liyik gë wëñahn yonkomb ntiyaɗëho do ryil uyand ñëbaɗëho; vampul gë wadëj tokëɗëho. ");
INSERT INTO cou_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vahnë vëvë Yerusalem va gë vëvë Yuɗe va fop do gë vëvë resiỹo le kakëni vë tëfary sën Yurëdan hna fop, njiɗëniho ỹalu hna. ");
INSERT INTO cou_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Putaɗëniho wameh wante ntini ŋa tase vahnë fop do San njaryëɗëhëhniwo sën hna. ");
INSERT INTO cou_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","San nuko wafarise gë wasaduse wayaɓah njijëɗëniho ỹalu hna soŋe njaryëhni; awa më ntehnëkëhni: «W̃uhnë, merun had walën wayapah! Mo lehnëku yarya ỹi fo koɗ pehëtu ntavah cankaf W̃ën nte yejëk ŋi? ");
INSERT INTO cou_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diryindën viỹë vifërën. Koyëna tufahnëɗun paryi nkwëcëtarun vankeya va! ");
INSERT INTO cou_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ant'ahnahandu: “Rëm sankaf fu ỹa, Abëraham ye”, had watac gwërënkeɗ afehëtahniwu. Pëƴaɗëmu: W̃ënu ŋa koɗ dënk nti waỹi wëraka vutah Abëraham! ");
INSERT INTO cou_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rasëhn ỹa pëhwëtak ŋos vatëh va vënkahn hna: Atëh nte-wo-nte wok dëw̃ëɗina wadëw̃el wapërën ŋa ŋosëɗe do ntabi gë hwëɗëh. ");
INSERT INTO cou_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Ami, gë w̃ënka njaryëɗëmu soŋe tufahnahni nkwëcëtarun vankeya hun va. Ale rëfiɗëho ỹa, umë lëbëko: catëla dënk faryëtahnëw̃a wapary ŋa. Umë, g'Iƴir Ipacah do gë hwëɗëh njaryëɗëhu. ");
INSERT INTO cou_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iɓëryew̃ iŋa mënkwëk paryahn soŋe pitëndëlehnahn waŋëc ŋa gë vaparyel va. Ndanëɗ waŋëc ŋa ndank ntëw̃u hna, ɓare vaparyel va pëɗëɗ hnë hwëɗëh hunte wok ɗipëɗina muk.» ");
INSERT INTO cou_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Awa Yesu matiko Galile hna nji Yurëdan vëhni San hna, soŋe njaryi. ");
INSERT INTO cou_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ɓare San ŋwëỹëɗëho, ntehn: «ami rëfëka ayaryo, ɓare wëjë yijëk hnë ỹal mën soŋe yaryi!» ");
INSERT INTO cou_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu më ntëkwaka: «Maw̃ëry nke koyëna ỹi wati, kaɓi koyëna ntiyaɗ fop ile tëƴëk W̃ënu ŋa.» Awa San më maw̃ëk. ");
INSERT INTO cou_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu njaryënde tuŋ, mëƴëtak w̃ënka hna. Hnë wati rac dënk, ambin ŋa piɗëtalehn do nulehn Iƴir W̃ënu ŋa ga cëlëndajëɗ hnë umë; gë fah mëntëlëniho. ");
INSERT INTO cou_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tac kopa vë g'ambin nkwëryëlehni ga ntehnëɗ: «Aỹi Ajë mën ale ỹahnëɓu ɗus a ye; g'umë nëŋëko ɗus.» ");
INSERT INTO cou_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ga ndëcëk watac Iƴir Ipacah iŋa më njoka Yesu gë wula soŋe Sintani nji njëkëhnahna menehna. ");
INSERT INTO cou_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hnam, Yesu cuŋëko g'anent gë g'umëɗ hafo wafac wafëhw wahnah (40). Awa tac më njoka inte ɗus. ");
INSERT INTO cou_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wati rac Sintani, aw̃enehn a, më tëhaka do ntehn: «Ge Aju W̃ën ỹa yeru dehnëryehna waỹi wëraka mbaca mburu.» ");
INSERT INTO cou_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu më ntëkwaka: «Vikerëh W̃ën va pëƴahnëk: “Ahnë gena roka fo valëɗëha, ɓare mbalëɗëha fëna gë fop wanës wante pëƴahnëɗ W̃ënu ŋa.”» ");
INSERT INTO cou_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Awa Sintani më njoka Yerusalem, naw̃ cëvah hna, tindëka cëmët Cery W̃ën Cankaf hna ");
INSERT INTO cou_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","do ntehna: «Ge Aju W̃ën ỹa yeru, dëɗary gëɗ; gena bi Vikerëh va pëƴahnëk: «“W̃ënu ŋa ntehnëɗëhëhni wamëleka wadëw̃u ŋa njakënihi kehahnënihi ant'aw̃ëw̃ itaka”?» ");
INSERT INTO cou_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu më ntëkwaka: «Vikerëh va pëƴahnëk fëna: “Nt'ayëkëhnahna Ahwëhn a W̃ën hu ŋa.”» ");
INSERT INTO cou_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sintani më mbok njoka kat Yesu hn'ikuŋ ƴihnah ɗus, tufëka fop wahnaw̃ wavë ɗuniỹa w̃i gë hnapul lëw̃u per, ");
INSERT INTO cou_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","do ntehna: «Njëɗaɗëmi ỹinë fop ge ndëkwëhnëru haryëŋwk mën soŋe asëmbo.» ");
INSERT INTO cou_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Awa Yesu më ntehnëka: «Ŋaw̃ëtarye Sintani! Vikerëh va më lehnëk kat: “Ɗëkwëhnëhnëryehna Ahwëhn a W̃ënu ŋa; umë fo rëfëka aryokuŋëhna.”» ");
INSERT INTO cou_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Awa Sintani tavëlehna taŋ Yesu do nji. Awa wamëleka njilehnini vëhni Yesu hna do paɓënihawo. ");
INSERT INTO cou_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ga mbiỹëk toƴe Yesu njëtako San Ayary a cëɗik, awa më njik hnë Galile hna. ");
INSERT INTO cou_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaret hna nɗëcëtako, nji ntëɗ Kaperënaỹum, nkol nte yeho ɗarël lant vë Galile hna, hn'inkal Sabilon do gë Nefëtali hna. ");
INSERT INTO cou_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Koyëna ntiyako wanës kila Esayi ŋa ante ntehnëko: ");
INSERT INTO cou_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«W̃uhnë vëvë inkal Sabilon gë Nefëtali, tëfary lant Galile ŋa gë cape ñëntaw̃ sën Yurëdan ka, w̃uhnë vëvë Galile, inkal nte njaɓahnëni vële wok vëyena wasëwif! ");
INSERT INTO cou_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","W̃uhnë vële ye hn'umëhwëry hna nuɗun humpen cankaf! W̃uhnë vële lëɗëk hnë mëhwëry icëm hna, humpen ha penëɗëhu!» ");
INSERT INTO cou_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Koɓëri tac, Yesu pëgwëko karaŋëndëhni vahnë va ntehnëndëhni: «Gwëcëtaryin vankeya va: Naw̃ W̃ënu ŋa tëhajëk.» ");
INSERT INTO cou_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu lant sankaf le w̃acik Galile ỹa tëfaryëɗëho, ante nukëhniwo vësan vëhi vële yeho vëfëla wuwis: Simo, nte w̃acëɗeho Piyer, do gë aheryu Andëre. Waryeƴ ntoŋëɗëniho lant hna pëlahnënihëhni wuwis. ");
INSERT INTO cou_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu më ntehnëkëhni: «Tëfino do ntiɗëmu vëfëla vahnë.» ");
INSERT INTO cou_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tavëlehnëni taŋ waryeƴ w̃a tëfëlehnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ante mbok njik ŋaw̃ët toƴe ŋa më mbok nukëhni kat vahnë vëhi, Sak g'aheryu San; viju Sebede yeho. Kulu lëw̃ hni hna nkeniho gë rëm hni, waryeƴ wale pëlandeni wuwis w̃a pëhwëtëɗëniho. Yesu më macëkëhni tëfëlehnëniha. ");
INSERT INTO cou_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tavëlehnëni taŋ kulu ỹa do gë rëm hni tëfëlehnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu njasëlendëho Galile hna fop, karaŋëɗëhëhniwo vahnë va vacery vacaliŋa wasëwif, Wanës Wakasëk waɓë Naw̃ ambin ŋa pëƴahnëɗëho do njërënëɗëhëhniwo vahnë va fop wates wadëw̃ hni ŋa gë warey walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Itëfëta soŋe lëw̃u ỹa nkwëryëɗeho hn'inkal Siri hna fop do njinenëhniɗehëhniw̃o fop vële resëko wates wanëmpëlah ma hwëhnako waɗëñah wanëmpëlah: vële pëlaniho waƴine, vële ntiɗëho haƴo do gë vële reyëko, do njërënëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kore sankaf rëfëlendëhawo; Galile matiɗëniho gë resiỹo Wahnaw̃ Pëhw gë Yerusalem gë Yuɗe do gë resiỹo le ye gë cape ñëntaw̃ sën Yurëdan. ");
INSERT INTO cou_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ga nukëhni Yesu kore ỹa, më kaƴëk hn'ikuŋ ntaña do vahnë va më njijëni ɗarël lëw̃u. ");
INSERT INTO cou_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Awa pëgwëlehn karaŋëndëhni aki: ");
INSERT INTO cou_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mbetani, vële yavëtëk mbalëkëhni uryema W̃ën kaɓi Inaw̃ ambin ŋa vëhni hwëhnëk! ");
INSERT INTO cou_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbetani vële yahnaɗ va, kaɓi W̃ënu ŋa mbosëvosehnëɗëhëhni ");
INSERT INTO cou_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbetani vële vanaɗ va, kaɓi W̃ën njëɗaɗëhëhni nkal iŋa fop! ");
INSERT INTO cou_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbetani vële njok inte gë w̃ënka soŋe usatah w̃a, kaɓi W̃ënu ŋa pihnëndanëɗëhëhni! ");
INSERT INTO cou_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbetani vële kaỹëhnahnëɗ gë vëỹënta hni va, kaɓi W̃ënu ŋa kaỹëhnahnëɗëha gë vëhni! ");
INSERT INTO cou_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbetani vële pacëk vintaw̃ary va, kaɓi nuɗëniha W̃ënu ŋa! ");
INSERT INTO cou_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbetani vële ryemaɗëhëhni vahnë va nuỹani ƴam ỹa, kaɓi W̃ënu ŋa vërahu rëkëɗ macëndëhni! ");
INSERT INTO cou_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbetani vële liɗe këm fo va kaɓi ile satëk ntiɗëni; Inaw̃ ambin ŋa vëhni hwëhnëk! ");
INSERT INTO cou_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mbetarun w̃uhnë nte njew̃ëɗerun, mbërehnëɗerun, ntehnëɗerun sifa wanës wameh-wo va kaɓi ami hwëtahnërun. ");
INSERT INTO cou_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tisëryiw̃u, natëryiw̃u, kaɓi icos cankaf hnapëɗëhu ambin hna. Ɗënkwëtaryin, koyëna mbërehniniho wakila waɓ koɓëri ŋa fëna.» ");
INSERT INTO cou_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu më mbok ntehnëk: «W̃uhnë ye waŋiry ɗuniỹa ŋa. Ɓare ge waŋiry ŋa gona ŋañ, hak koɗe mbokaryi ŋañëni? Gona kwëhna nafa; ntoŋëɗe g'ipër, do vahnë va njasahnëɗëni. ");
INSERT INTO cou_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«W̃uhnë ye humpen ɗuniỹa ha. Inaw̃ nte vëryik ƴaŋ hn'ikuŋ ŋa koɗena cow̃i. ");
INSERT INTO cou_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pëɗëɗena lampu do cow̃i sëñ, ɓare kaŋëɗe ƴaŋ pëtënëhnahnëhni vële ye cery va. ");
INSERT INTO cou_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Koyëna tëfëka pëtënd humpen hun ha hnë vahnë hna, nuhahnëni ifërën le liɗun ỹa do cëmbahnëniha Rëm hun le ye g'ambin ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu më mbok ntehnëk kat: «Antë ntiyahnu itëkwehn sariya Moyis do g'ile kerëni wakila ŋa yijëɓu. Ƴijëla soŋe rëkwehnu, ɓare soŋe fadënu yijëɓu. ");
INSERT INTO cou_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Toña ỹa fëƴaɗëmu: gante-wo mbiỹëk ambin ŋi g'inkal iŋi, ñoñ ŋaỹëtëɗena sariya hna, la fakerëh fante ỹak vak. Nkoɗ hafo hale padëɗ fop. ");
INSERT INTO cou_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Soŋe umë ye, ale ỹaỹëtëk facariya fante ỹak vak hnë waŋi do karaŋëhni vëỹëntaw̃ va ntintini koyëna ỹa, ahnë arac yeɗ ale ỹak vak ỹa hnë Naw̃ ambin hna. Ɓare ale w̃aw̃ëhnëk do karaŋëhni vëỹëntaw̃ va, naỹëɗ Naw̃ ambin hna. ");
INSERT INTO cou_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Toña ỹa fëƴaɗëmu: ge icat dëw̃ hun iŋa dëbëna mba vëharaŋ sariya vi do gë wafarise w̃i, koɗiluhna arënku Naw̃ ambin hna.» ");
INSERT INTO cou_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu më mbok ntehnëk kat: «Njëtarun ntehniniho vacërakëlo fu va: “Nt'aryaw̃a ahnë wakwëhn ampër; ahnë ale-wo-le ryaw̃ëka aỹëntaw̃ a, tëfëka njoyi karyënkw ahitiŋ hna.” ");
INSERT INTO cou_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ɓare ami ntehnëɗëmu: ge ahnë ntavëka g'aỹëntaw̃u ỹa, tëfëka njoyi haryënkw ahitiŋ hna; ale lehnëka aỹëntaw̃u ỹa: “Fufafu yeru!” tëfëka kitiŋi Mbara Vëhitiŋ hna; ale lehnëka: “Ahnënkwah yeru!” ahnë arac tëfëka ntabi hnë hwëɗëh janáma hna. ");
INSERT INTO cou_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Ge awa ñaɗu ayëɗahna W̃ënu ŋa hn'ile cënaɗe saɗëha hna, do hnam aryënkwëtat aỹënta hu ỹa kwëhnak ile lavëka gë wëjë, ");
INSERT INTO cou_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tavëry ile ỹakëndu ayëɗahn ỹa hn'ile cënaɗe saɗëha hna, ayi ten asaŋëndaniw̃u g'aỹënta hu arac; tac g'avokaj asëna saɗëha hu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ge hn'ile akitiŋëɗerun hna nkorun ayindu g'ale rakëlëku ỹa, diry fere ñap asaŋëndanu g'umë hnë wati le worun hn'ankaw̃ ỹa. Ge gena umë, koɗ pëlayehnëhi hnë ahitiŋ hna, do ahitiŋ a njëɗahnëɗëhi gë vësankaf do vëhni cëɗëɗënihi gë kaso. ");
INSERT INTO cou_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Toña ỹa fëƴaɗëmi: cahnëɗila hnam muk, hara cosahnëlihna ɗalasi le wonanëruha ỹa! ");
INSERT INTO cou_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Njëtarun fëna ntehniko: “Nt'ayëkëlehna asëval ahaw̃ary.” ");
INSERT INTO cou_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ɓare ami ntehnëɗëmu: asan ale-wo-le yëkëka asëval ale nkok ñëlëna ỹa hafo naha soŋe ndakëni, arac ndakëni g'asëval arac ntaw̃ary dëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Awa age nkër hu ŋa ỹaɗ ntiyehni uw̃eh, dokëtary aloŋ ŋaw̃ët: ntihëtaỹi iñë ryampo fecek mbahn hu hna g'ile ntabik mbahn hu ŋa fop hnë hwëɗëh janáma. ");
INSERT INTO cou_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Do ge soŋe vák hu rëhw ỹa ñaɗ ntiyehni uw̃eh, dëpëtary aloŋ ŋaw̃ët: ntihëtaỹi iñë ryampo fecek mbahn hu hna g'ile ntabik mbahn hu ŋa fop hnë hwëɗëh janáma. ");
INSERT INTO cou_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Njëtarun ntehniko fëna: “Ale vambëka asëvalu ỹa tëfëka njëɗahna kayëte nte rufahnëɗ mbambik.” ");
INSERT INTO cou_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ɓare ami ntehnëɗëmu: asan ale-wo-le vambëka asëvalu ỹa, hara pëlalehnëlihna g'asan ahaw̃ary, arac liyendëha ile mbañëk W̃ënu ŋa ge mbok ñëli; do ale ỹëlëka asëval ale mbambëk asan ahaw̃ary ntik ndakëntal nte ye had asëval ale nkok ñëlëna ndakëɗëni. ");
INSERT INTO cou_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Njëtarun fëna ntehniniho vacërakëlo fu va: “Nt'arav ile lëkëru haryënkw Ahwëhn hna, ɓare diry le lëkëru ali ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ɓare ami, ntehnëɗëmu: nt'alëku muk! Nt'alëkahnu ambin ŋa, kaɓi hnam nke laña W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nt'alëkahnu nkal iŋi, kaɓi umë ye sëɓa wapary W̃ënu ŋa. Nt'alëkahnu Yerusalem, kaɓi inaw̃ ahnaw̃ asankaf a ye. ");
INSERT INTO cou_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nt'alëkahn dënk vankaf hu vi, kaɓi koɗila ayerëna ma avahnëna wëla imul ɗampo dëw̃ hu ŋa. ");
INSERT INTO cou_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ge ha ye, dehnëryin, “Ha” ge hali ye, dehnëryin “Hali”. Dëk nte-wo-nte wënërun ŋa gë Sintani matiɗ. ");
INSERT INTO cou_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Njëtarun ntehniko: “Ge inkër lokëtëruha ahnë, inkër lokëtëgëɗeru do ge beñ wubëruha ahnë beñ wubëgëɗeru.” ");
INSERT INTO cou_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ɓare ami ntehnëɗëmu nt'awëcaguna ale liku uw̃eh a. Ge ahnë foryëki uham rëhw w̃a, ƴëɗaryehna poryëgi rahahn w̃a fëna. ");
INSERT INTO cou_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ge ahnë ñaɗ njoyi hnë kitiŋa teɓahni facuɗ fatoƴ fa, taveryëryehna njoryary cankaf ŋa fëna. ");
INSERT INTO cou_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ge ahnë forosiŋëɗëhi ayas kilometër ryampo, ƴasëryin g'umë soŋe wakilometër waki. ");
INSERT INTO cou_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ƴëɗaryehna ale w̃untaki iñë ỹa, do ant'aw̃anja ale rëƴëki inav. ");
INSERT INTO cou_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Njëtarun ntehniko: “Ŋahnëryehna aỹënta hu ỹa, do ñew̃ëryehna ale wok ŋahnëlihna ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɓare ami, ntehnëɗëmu: ŋahnëryinëhni vële ỹew̃ëku va do muntanëryinëhni vële liɗëhu këm fo va. ");
INSERT INTO cou_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ge koyëna ntiɗun, tufahnëɗun vutah Rëm hun le ye g'ambin va yerun. Umë canëhniɗëhëhni ulav lëw̃u w̃a, vahnë vëw̃en va do gë vëfërën va do tëvëhnëndëhni vahnë vësatah va gë vële wok vësatëna per. ");
INSERT INTO cou_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ge vële ỹahnëku fo ỹahnërun, soŋe ye hnapëɗun icos W̃ën, ide-wo-de? Wëla vëỹew̃ik va ntiɗëni koyëna! ");
INSERT INTO cou_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ge vëỹënta hun fo yaỹëɗun, ifërën ɗëcët bi lirun koyëna? Wëla vële wok vëyëtëlahna W̃ën va ntiɗëni koyëna. ");
INSERT INTO cou_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Awa kwëhnaryin iŋahn padah gante kwëhnak Rëmun le ye g'ambin ki!» ");
INSERT INTO cou_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ant'alindu tase vahnë ile tëƴëk sariya W̃ënu ŋa, soŋe ahamahnahniwu; ge koyëna ntiɗun, nuỹaɗiluhna icos Rëmun le ye g'ambin ỹa. ");
INSERT INTO cou_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Awa ge njëɗëɗunëhëhni vëhaỹëhnah va iñë, nt'aliwu ahamahniwu, gante nkeni vële rufëhnaɗ le-wo-le: ntiɗëni koyëna soŋe cëmbahnëndeni. Toña ỹa fëƴaɗëmu: vëhni atëk nuỹani icos dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ɓare ge vák rëhw hu ỹa njëɗaɗëhëhni vëhaỹëhnah va iñë, vák rahahn hu ỹa tëfëlahna njët, ");
INSERT INTO cou_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","nkohahn sow̃ik ile liɗu ỹa. Ge koyëna ntiɗu, W̃ënu ŋa, Rëmuh ỹa, hnuɗ ile liɗu wandëm ŋa do cosëɗëhi.» ");
INSERT INTO cou_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ge njëfaɗunëha W̃ënu ŋa, ant'arëfëtalahnënduni vahnë vële ỹahnëk tufëhna vi: vëhni, nëŋahnëkëhni iƴëfa wënkahn vacaliŋa hna do hnë le-wo-le rëkëɗe nundeni. Toña ỹa fëƴaɗëmu: vëhni tëk nuỹani icos dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɓare wëjë, ge ñaɗu ayëfahna W̃ënu ŋa, tënkëry cery hu hna, afiɗ rënka ỹa do ayëfahna Rëmuh le ye ỹëw̃a sow̃ak dënk hna; do Rëmuh le hnuɗ le liɗu le cow̃aru ỹa, cosëɗëhi. ");
INSERT INTO cou_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ge njëfaɗun nt'arëfëtalahnënduni vële wok vëyëtëlahna W̃ën vi, vëỹaw̃ënkah vi vële njehëk kwëlëkwël wanës wante wok kwëhnahna nafa: ntiyahnëkëhni W̃ënu ŋa maw̃ëndëhëhni ge njaɓënëni wanës ŋa. ");
INSERT INTO cou_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nt'arëfëtalahnënduni. W̃ënu ŋa, Rëm hun ỹa tëk njët le valëku ỹa, ani g'arëƴahnënduna ỹa. ");
INSERT INTO cou_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wëlin gante tëfëka ayëfandu ka: «“Rëm fu le ye g'ambin, Araɓi vahnë va fop njavëtëni W̃ën Hupacah yeru. ");
INSERT INTO cou_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Araɓi naw̃ hu ŋa njij. Araɓi ale-wo-le ỹa nti nkal li ile ỹaɗu ỹa gante ntiɗe hn'ambin ki. ");
INSERT INTO cou_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ƴëɗëryifu fac-wo-fac le rokëɗëfun. ");
INSERT INTO cou_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tavëndifu ile lëntëɓun ỹa gante tavëhnëɓunëhëhni, fuhnë fëna, vële lëntahnëkëfu ki. ");
INSERT INTO cou_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Do nt'aravëfu yëkëhnahnifu, ɓare ŋaw̃ëtëndifuna Aw̃enehna. Wëjë hwëhnëk ucankaf uŋa gë fanka fa do gë icëmb iŋa kwëlëkwël. Amina.” ");
INSERT INTO cou_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ha, toña ye, ge tavëntunëhëhni vëỹënta hun va wameh wante ntinihu ŋa, Rëmun le ye g'ambin ỹa fëna tavëndëhu. ");
INSERT INTO cou_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ɓare ge tavëndilunihna vëỹënta hun va, Rëmun fëna tavëndiluhna wameh wante lirun ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ge cuŋëɗun, ant'aỹañënu wayëka w̃a had gante ntiɗëni vële hnaỹënaɗ ki: mbacëɗëni wayëka w̃a soŋe vahnë va fop njëtahnëni cuŋëni. Toña ỹa fëƴaɗëmu: vëhni tëk nuỹani icos dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ɓare wëjë, ge cuŋëru, gwëñary do asirëta nkaf ŋa, ");
INSERT INTO cou_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","soŋe ntë njëtëni vahnë va cuŋëru. Rëmuh le wok nuɗena ỹi umë nuɗ le liɗu wandëm ŋi do cosëɗëhi.» ");
INSERT INTO cou_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Nt'avarëpu hnapul hnë iỹi ɗuniỹa, le përëkanëɗëni vamaỹ gë le rokëɗ waryëhwëra, ma le koɗëni nteni vële va. ");
INSERT INTO cou_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɓare ɓarëparyin hnapul ambin hna, le nkoni wayena vamaỹ ma le rokëɗ waryëhwëra soŋe përëkanahnëni, do hn'ile nkoni wayena vële ntehahnëni. ");
INSERT INTO cou_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ƴëtëryin le nke hnapul hun hna, nkeɗ iña hun iŋa kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Vinkër va ye lampu mbahn ŋa. Ge nuɗu wapacëk mbahn hu ŋa fop kwëhnaɗ humpen. ");
INSERT INTO cou_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ɓare ge vinkër va përënalihna, mbahn hu ŋa fop hn'umëhwëry nkeɗ. Awa ge humpen nte rëfakëha nke hnë wëjë ŋa mëhwëry mbacak, mëhwëry tac mbahnëɗ ɗus! ");
INSERT INTO cou_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ahnë koɗina njohalëhni vahnë vëhi gë ntaw̃ary dëw̃u ŋa fop: caŋëɗëni g'aryampo do ŋahnëɗëha; ñew̃ëɗëha aỹëntaw̃ a do njafa. Koɗiluhna ayohaluna W̃ënu ŋa do ayohalu fëna koryi ndampo fo.» ");
INSERT INTO cou_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Paŋare umë lehnandëmu: nt'ahnahandu ile rokëɗun ma vile liyaɗun. Gena bi uwám yaɓëk gë roka do mbahn iŋi yaɓëk fëna gë viỹi vi? ");
INSERT INTO cou_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ƴëkëryinëhni wusëry w̃i: wahnaɗëɗina, wavarëpëɗina fëna, waryanëɗina iroka hnë vandank, ɓare Rëmun le ye g'ambin ỹi ndavëɗëhëhni. Kas w̃uhnë vële lëbëkëhni nafa wusëry w̃i dinëhnëɗiluhna bi ntëbini vëhni ɗus? ");
INSERT INTO cou_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ge ahnë hnë w̃uhnë nahaɗ uryëñah lëw̃u w̃a koɗ bi koyëna nkwën iƴary wafac walëw̃u w̃a? ");
INSERT INTO cou_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Do ye hnahaɗun fëna soŋe viỹi vile liyaɗun? Ƴëkëryin gante pëhnëɗ wapëtel waɓë fëk ki: ɗokuŋëɗina, ɓahnëɗina wafand. ");
INSERT INTO cou_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ɓare la ahnaw̃ a Salomo, g'uvetak lëw̃u w̃a fop, nuỹalohna viỹi viwamah had ufëtel ryampo gë watac ki. ");
INSERT INTO cou_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","W̃ënu ŋa koyëna cuɗëɗëha idël nte ye dol ani do acahn ntoŋi gë hwëɗëh. Ge umë toña ye, kas w̃uhnë cuɗëɗëhu ntëbi dël iŋi! Kwëtahn hun iŋa ƴaɓëna! ");
INSERT INTO cou_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Awa ntë nkehahnahnu alehnëndu: “Ye rokëɗen, ye seɗen, ye liyaɗen?” ");
INSERT INTO cou_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vële wok vëyëtëlahna W̃ën va vëraɗ kwëlëkwël soŋe virac fop. Ɓare w̃uhnë, Rëm hun le ye g'ambin ỹa njëtëk mbalëku virac fop. ");
INSERT INTO cou_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Awa, ɓëraryin iƴëkëlehn Naw̃ W̃ënu ŋa ten do gë ile satahnëka ỹa, tac njëɗaɗëhu fëna le valëku ỹa fop. ");
INSERT INTO cou_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Antë nkehahnahnu soŋe acahn: acahn ỹa nkehahnahnëɗëha g'umë dënk. Ambër nte yijëɗ fac-wo-fac ŋa gwër nke soŋe fac ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu më ntehnëk kat: «Nt'ahitiŋu nkeya vëỹënta hu va soŋe W̃ënu ŋa antë kitiŋu w̃uhnë fëna. ");
INSERT INTO cou_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ƴëtëryin ɗus, W̃ënu ŋa kitiŋëɗëhu gante kitiŋëɗunëhëhni vëỹënta hun ka, g'añëŋa nte ỹaŋëhnahnëɗunëhëhni vahnë ŋa ñaŋëhnahnëgëɗëhu W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Soŋe ye yëkëɗu ivëɗ le ye hnë inkër aỹënta hu hna, do hara kamahnëlihna bërëh bële yehi hnë inkër hu hna? ");
INSERT INTO cou_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hak koɗu alehna aỹënta hu ỹa: “Napërye lihëti ivëɗ le yehi nkër hu ỹi” hara bërëh yehi inkër hu hna? ");
INSERT INTO cou_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wëjë, ale ntiyahnëk catëru alëbëhni vëỹëntaw̃, dihëtary ten bërëh bële yehi inkër hu ỹi tac nuɗu ɗus alihëtahna aỹënta hu ỹi ivëɗ le yeha nkër dëw̃u ỹi. ");
INSERT INTO cou_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Nt'ayëɗawuni ile sëvak ỹa waɓe, kaɓi ge njëɗarunëhëhni cahëtanëhnëɗënihu ŋarënihu; nt'aloŋu wanjere hun wakwëhn nafa had sanikona ŋa haryënkw vampëhëmpëh hna, kaɓi ge ntoŋëntunëhëhni nkëñëɗëni do nihëɗ.» ");
INSERT INTO cou_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu më mbok ntehnëk kat: «Tëƴëryindën njëɗaɗerun, ƴëkëlehnëryindën nuɗun, ɓankëryindën rënka ỹa piɗëtënderun. ");
INSERT INTO cou_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paryi pëƴaɗëmu, ale-wo-le rëƴëka njëɗaɗe, ale yëkëlehnëka nuɗ do piɗëtëhnëɗe rënka ỹa ale vankëɗ a. ");
INSERT INTO cou_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nke bi hnë w̃uhnë ahnë ale yëɗaɗëha fatahu itaka ge mburu tëƴëka, ");
INSERT INTO cou_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ma lën ge igis tëƴëka? ");
INSERT INTO cou_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mama mehantun, ɓare viỹë vëfërën yëɗaɗunëhëhni vutah hun va. Do kas Rëmun le ye g'ambin ỹi njëɗaɗëhëhni viỹë vëfërën vële rëƴëɗëha va! ");
INSERT INTO cou_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Fop ile ỹaɗun ntinëhnënihu vahnë ỹa, dinëhnëryinëhni w̃uhnë fëna: irac ye ile karaŋëɗ sariya Moyis ỹa gë vëkayëte wakila ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Tënkëryin rënka suyah hna. Vëyaɓah rënka yankah hna tënkëɗëni do nkaw̃ nkwankah ŋa tëfëɗëni ɓare g'iɓëv njiryeryëɗ. ");
INSERT INTO cou_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Rënka suyah ỹa g'ankaw̃ ntakah tëfi ŋa g'uwám usër njiryeryëɗ; vële hnuɗ va vëyaɓëna.» ");
INSERT INTO cou_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesu më mbok ntehnëk kat: «Keharyinëhni vële wok wayena wakila paryi. Njijëɗëni hnë w̃uhnë ntiyajëɗëni had wape, ɓare ɓambery lëw̃ hni waỹin waƴapah ye. ");
INSERT INTO cou_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Njavëtëɗunëhëhni ge nurun ile ntiɗëni ỹa. Gena bi waresen w̃a kwëcëɗena hnë wadëmpëhn do wanuỹ ŋa fëna kwëcëɗena hnë dël imeh. ");
INSERT INTO cou_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Atëh përën wadëw̃el wapërën ntëw̃ëɗ do atëh meh wadëw̃el wameh ntëw̃ëɗ. ");
INSERT INTO cou_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Atëh përën koɗina ntëw̃ wadëw̃el wameh, atëh meh fëna koɗina ntëw̃ wadëw̃el wapërën. ");
INSERT INTO cou_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Atëh nte-wo-nte woɗ dëw̃ëna wadëw̃el wapërën ŋa, ŋosëɗe ntabi gë hwëɗëh. ");
INSERT INTO cou_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ha, koyëna dënk njavëtëɗunëhëhni wakila vëw̃ër ŋa ge nurun ile ntiɗëni ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesu më mbok ntehnëk kat: «Lakënde vahnë va macëndëniho: “Ahwëhn, Ahwëhn” gena soŋe umë rënkëndahnëɗëhëhni Naw̃ ambin hna; vële liɗ le ñaɗ Rëm mën le ye g'ambin va fo rënkëɗ. ");
INSERT INTO cou_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hnë fac le kitiŋëɗëha W̃ën ɗuniỹa hna vëyaɓah ntehnëɗëniho: “Ahwëhn, Ahwëhn, gena bi toña, g'uw̃ac hu w̃a pëƴahnëɗëfunëho wanës W̃ënu ŋa; g'uw̃ac hu w̃a ntaɗëfunëhëhniwo waƴine ŋa; g'uw̃ac hu w̃a ntiɗëfunëho vifëmpëhnahnah viyaɓah?” ");
INSERT INTO cou_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Awa ntehnëɗëfuhëhni: “Koɓëri ƴëtëluhna! Ŋaw̃ëtaryino, w̃uhnë vële wok ɗiɗiluhna le ñaɗ Rëm mën a!”» ");
INSERT INTO cou_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu më mbok ntehnëk kat: «Ale-wo-le wëryëk wanës wante hnësëɗëfu takahn ŋi do nti watac arac aritah ye: nke had ale vëryëk cery ntëw̃u gë sima. ");
INSERT INTO cou_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Rëv ỹa tëvëk, wasën w̃a macëk, sël sankaf ỹa cëlëk, ɓare këfëna cery tac, kaɓi gë sima mbëryik. ");
INSERT INTO cou_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɓare ale wëryëk wanës wante hnësëɗëfu takan ŋi do dil watac, arac ahnënkwah ye: nke had ale vëryëk cery ntëw̃u g'inkal fo. ");
INSERT INTO cou_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Rëv ỹa tëvëk, wasën w̃a macëk, sël sankaf ỹa cëlëk këfëlehn cery tac do nih fop.» ");
INSERT INTO cou_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ga puhnak Yesu wante nësëɗëho ŋa, vahnë va fop pëmpëhnahnëkëhniwo gante karaŋëɗëhëhniwo ka. ");
INSERT INTO cou_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gelohna gë vëharaŋ sariya vëlëw̃ hni ka, ɓare g'ucankaf karaŋëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ante cëlëɗëho Yesu kuŋ hna kore sankaf rëfëlehnëɗëhawo. ");
INSERT INTO cou_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Awa asan ahwëhn ambiỹ tëhalehn a, ndëkwëhn karyënkw lëw̃u do ntehna: «Ahwëhn, ge ñaɗu, koɗu ayërëno, afacënëlehno.» ");
INSERT INTO cou_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu më njelëk vák ỹa ñaka do ntehna: «Ñaɗëfu: Pacëry!» Taŋ njërëlehn. ");
INSERT INTO cou_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tac Yesu më ntehnëka: «Nëpary ɗus: nt'afëƴahna ỹin la aryampo, ɓare ƴiry njëki asëna wasaɗëha ỹa, do canëry saɗëha le kerëko Moyis canënde ỹa. Koyëna vahnë va fop njëtëɗëni pacëru.» ");
INSERT INTO cou_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wati nte tënkëɗëho Yesu Kaperënaỹum ŋa, Kapiten vë Rom rëhakawo soŋe muntahna ndemahna. ");
INSERT INTO cou_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Më lehnëkawo: «Ahwëhn, aryokuŋ mën a ndakëk tere hna, koɗina mat, mbërak ɗus.» ");
INSERT INTO cou_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu më ntëkwaka: «Njiɗëfu yërënëw̃a.» ");
INSERT INTO cou_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kapiten ỹa më ntehnëk: «Ahwëhn, catëla soŋe arënkahn tere mën hna. La ki fo nësëru njërëɗ. ");
INSERT INTO cou_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ami dënk, vële lëbëko ucankaf a w̃aw̃ëndëɓu do kwëhnaɓuhëhni wasoɗaɗe wale w̃aw̃ëndëho fëna. Ge ntehnëɓuha aryampo nji, njiɗ. Ge ntehnëɓuha aỹëntaw̃ njij, njijëɗ. Do ge ntehnëɓuha aramp mën a fëna nti iñë, ntiɗ.» ");
INSERT INTO cou_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ga nkwëryëk wanës watac, pëmpëhnahnëkawo më ntehnëkëhni vële rëfëlehnëɗëhawo va: «Toña ỹa fëƴaɗëmu: nulëw̃ahna hnë ɓulunda vëvë Isërayel hna ale njaɓëk ikwëtahn g'aỹi ki. ");
INSERT INTO cou_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paryi pëƴaɗëmu: vahnë vëyaɓah matiɗëni vacape hna fop, ntañalandëni gë Abëraham gë Isak do gë Sakob Naw̃ ambin hna soŋe ambënt ŋa. ");
INSERT INTO cou_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ɓare vële rëfëkawo nkentini Naw̃ va canëɗeni g'ipër le mbahnëk hna, hnam rëkëɗ kondëni do cemëlehnandëni wabeñ ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tac Yesu më ntehnëka kapiten ỹa: «Ɓokary gë ỹal hu! Araɓi W̃ënu ŋa ntinëhni ile hwëtahnëru ỹi!» Do aryokuŋëhn kapiten ỹa njërëko hnë wati rac dënk. ");
INSERT INTO cou_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tac Yesu njiko tere Piyer hna më tëkatëka hnëmu asëvalu Piyer ga ndakëk; mbahn iŋa njakëkawo. ");
INSERT INTO cou_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Umë ñakëka vák ỹa do yak mbahn w̃a tavëlehna taŋ. Asëval a matëlehn njohala. ");
INSERT INTO cou_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ante nëkak ŋa, njonëhnijikëhniwo Yesu kore sankaf vahnë vële pëlani waƴine. Gë wanës wadëw̃u ŋa fo ntaɗëhëhniwo waƴine ŋa do njërënëɗëhëhniwo fëna vëres va fop. ");
INSERT INTO cou_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Koyëna ntiyako wanës kila le w̃aciko Esayi ỹa: «Nufëk ile horotehnëɗëhëfu ỹa; ndiɓëk wates wadëw̃ fu ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ante nukëhniwo Yesu fop kore le hwërëka ỹa më ntehnëkëhni vërëfal vëlëw̃u va ntëmpëtani gë cape ñëntaw̃ lant ka. ");
INSERT INTO cou_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hnë wati rac Aharaŋ sariya aryampo më tëhaka do ntehna: «Aharaŋ, tëfëlehnëɗëmi hn'ile-wo-le njiɗu hna.» ");
INSERT INTO cou_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu më ntëkwaka: «Vuntadaw̃ va kwëhnani wahatëh wale njinëgandëni do wusëry w̃a wahof; ɓare Ajë Ahn'a kwëhnana ỹëw̃a le njinëgaɗ.» ");
INSERT INTO cou_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ahaw̃ary kat arac arëfal Yesu yeho, më ntehnëgëka: «Ahwëhn, ƴëɗërye yiwu ten hnapu hafo Apa cëm tac do gë yiju rëfëlehnëndi.» ");
INSERT INTO cou_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu më ntëkwaka: «Tëfe do tavëryihni vësëm va mbañënihëhni vësëm vëlëw̃ hni va.» ");
INSERT INTO cou_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tac Yesu më kaƴëk kulu sankaf hna do vërëfal vëlëw̃u va më kaƴëntini. ");
INSERT INTO cou_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Taŋ sël sankaf matëlehn lant hna, cëlënd hafo wavonkëlo w̃ënka ŋa ñand tëmp kulu ỹa. Wati rac Yesu wakwëɗ ndakëko. ");
INSERT INTO cou_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Awa vërëfal va më tëhaniha nëgëtëniha ndekatëndëni: «Ahwëhn, pehëtëryifu! Cëm iŋa yeyinëk!» ");
INSERT INTO cou_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Më ntëkwakëhni: «Soŋe ye ntakëku? Gante mbak kwëtahn hun ka!» Matëlehn, ŋañëna sël ỹa gë wavonkëlo w̃ënka ŋa, tëryalehn fop nkelehn yamah sankaf. ");
INSERT INTO cou_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vëhni fop pëmpëhnahnëkëhniwo më ntehnëɗëni: «Mo ga ye awa aỹi asan? La sël ỹa gë w̃ënka ŋa maw̃ëhnëɗëniha!» ");
INSERT INTO cou_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ante tëkëko Yesu hnë nkal vëvë Gadara hna, gë cape ñëntaw̃ lant ŋa, vësan vëhi vële pëlaniho waƴine më cahnini wayag hna njijëndëni pankëlëni. Ŋaƴëniho ɗus, soŋe rac ahnë ɗëkëɗilohna mbok tëf nkaw̃ tac. ");
INSERT INTO cou_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pëgwëlehnëni ndekandëni: «Ajë W̃ën, ye ye yëbëlan fu? Ahorotehnëfu bi yijëru ani gë tëkahnënd wati kitiŋ ŋa?» ");
INSERT INTO cou_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hara kore vampëhëmpëh ryavëɗëho ŋaw̃ët toƴe. ");
INSERT INTO cou_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Awa waƴine ŋa më muntaniha Yesu aki: «Ge ñaɗu alafu, cañëtëryifu hnë vaŋi vampëhëmpëh!» ");
INSERT INTO cou_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Më ntehnëkëhni: «Ƴiryin!» Më cahnënihëhni vësan vëhi va njini tënkënihëhni vampëhëmpëh va. Taŋ kore vampëhëmpëh na fop pëtalehnëhni vambëŋ kuŋ hna njini ntëbani lant hna do cëmëlehnëni fop. ");
INSERT INTO cou_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vëhery vampëhëmpëh va njilehnëni g'igary fo g'ankol do gë le kwëtëɗeni vampëhëmpëh hna pëƴahnini fop le nuni ỹa do g'ile yehëhni vësan vële pëlaniho waƴine va. ");
INSERT INTO cou_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Vahnë vëvë nkol va fop cahnëniho njini pankëlëni gë Yesu. Koɓëri ga nuniha këlaniha cahn resiỹo lëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ga matëk hnam Yesu më kaƴëk kulu sankaf hna do ntëmpëta nji g'inkol ntëw̃u. ");
INSERT INTO cou_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ga tëkëk hnam vahnë më njinenëhniniha asan ale ye vorovoro hnë ƴala ndakëko. Yesu ga nuk ikwëtahn nte kwëhnani soŋe lëw̃u vële yojëkawo va, më ntehnëka aresa: «Ɗuñënary, fatah mën! Tavëhnëmi wameh hu ŋa!» ");
INSERT INTO cou_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Awa vëharaŋ sariya vëryampo më nahaɗëni: «Aỹi asan W̃ënu ŋa njew̃ëɗ!» ");
INSERT INTO cou_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu njëtëko le nahaɗëni ỹa, më ntehnëkëhni: «Soŋe ye hwëhnarun viŋi vinahan vimeh? ");
INSERT INTO cou_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lehnuw̃a aỹi asan: “Wameh hu ŋa tavëhnëmi”, ma: “Matëry do ƴasëry” ryampo bi ỹak hnëŋëk nësi hnë waŋi? ");
INSERT INTO cou_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Awa ñaɗëfu ayëtu: Ajë Ahn'a kwëhnak fanka nkal li tavëhna ahnë wameh.» Tac më ntehnëka asan ale yeho vorovoro ỹa: «Matëry, nufëry ƴala hu ỹa aw̃ënc gë ỹal hu!» ");
INSERT INTO cou_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Asan a matëlehn nuf ƴala lëw̃u ỹa do mënc gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kore ỹa ga nuni watac, pëmpëhnahnëkëhniwo do cëmbëɗënihaw̃o W̃ënu ŋa soŋe le njëɗakëhni vahnë va iỹi sifa w̃ëka. ");
INSERT INTO cou_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu matëko hnam njind do nuhna asan ale w̃acik Matiye hnë biro le cosahnëɗe ỹatëtanke hna ntañako. Më ntehnëka: «Tëfe!» Matiye matëlehn do tëfëlehnënda. ");
INSERT INTO cou_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tac, Yesu gë vërëfal vëlëw̃u va roka tokëlandëniho tere Matiye hna gë vërëf ỹatëtanke vëyaɓah do gë vëw̃eh vëhaw̃ary. ");
INSERT INTO cou_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wafarise w̃a ga nuni watac më ntehnënihëhni vërëfal Yesu va: «Soŋe ye tokëntëɗe aharaŋ hun aỹi gë vërëf ỹatëtanke vi do gë vew̃eh vi?» ");
INSERT INTO cou_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu nkwëryëkëhniwo më ntehnëk: «Vëres va valëkëhni g'ayërën, gena vële wok vëresëna. ");
INSERT INTO cou_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ƴiryin aỹëŋawu ile pëhnëtanëɗ waŋi wanës W̃ën: “Ipërëna ŋa fecehnëko, gena saɗëha wusaw̃.” Ƴëtëryin vëw̃en yijëɓu w̃acu, gena vësatah.» ");
INSERT INTO cou_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Awa vërëfalSan Ayary a më tëhaniha Yesu do tëƴëniha: «Fuhnë gë wafarise w̃i njehëkëfu cuŋ iŋa, awa soŋe ye vërëfal hu vi vësuŋëɗina?» ");
INSERT INTO cou_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Më ntëkwakëhni: «Naharun bi vële faƴehnik ambënt va koɗëni kwëhnani uyiw̃ëhnah wati le nkelahnëni g'ale ỹëlëɗ a? Koɗina nke watac! Ɓare wati yejëk ntihëtëndeniha ale ỹëlëɗ a; awa wati rac vërëfal mën va rëkëɗ cuŋëntëndeni. ");
INSERT INTO cou_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Ahnë kaɗëɗina ankwëỹ pand kasëk, nte wok kwëỹana ten, hn'ipand cër; ge gena umë, ankwëỹ pand kasëk iŋa, ge ndagik, kwëỹaɗ do citëɗ pand cër iŋa do hatëh ha njankëɗ ɗus. ");
INSERT INTO cou_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Taw̃ëɗena fëna uñen kasëk hnë waryëpët wasër; ge gena umë waryëpët w̃a tënkëɗ, përëkaɗ do uñen uŋa ndehëtaɗ. Ɓare uñen kasëk ŋa hnë waryëpët wëhasëk taw̃ëɗe do koyëna ñoñ përëkaɗina.» ");
INSERT INTO cou_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wati nte nësëndëhëhniwo Yesu waŋi ŋa, asankaf wasëwif rëkiko, ndëkwëhn haryënkw lëw̃u do ntehna: «Aryag mën a cëmëk tamëki; ɓare ƴij aỹaka do matëɗ.» ");
INSERT INTO cou_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu më matëni gë vërëfal vëlëw̃u va do tëfëlehnëniha asankaf arac. ");
INSERT INTO cou_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Awa ga njiɗëni, asëval ale resëko njiɗëho sat koɓëri hnë wabëhn pëhw gë waki, rëhakawo Yesu kamëhni do ñak wacëmët cuɗ ntëw̃u ŋa ");
INSERT INTO cou_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kaɓi ntehnaɗëho: «Lakënde viỹi vilëw̃u vi fo ỹakakëndëɓu, njërakëndëɓu.» ");
INSERT INTO cou_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ante ñakëk ŋa Yesu më cahëtak do ntehna: «Ƴaw̃ënary, aryag mën! Ikwëtahn hu ŋa njërënëki.» Do hnë wati rac dënk asëval a njërëko. ");
INSERT INTO cou_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tac Yesu tëkëko hnë tere asankaf wasëwif hna. Ga nukëhni vële yëw̃ëɗ ge ahnë cëmëk va do gë vële yahnaɗëho va, ");
INSERT INTO cou_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","më ntehnëk: «Cahnëryin hnani, fandag fi cëmëna, wakwëɗ fo ndakëk.» Ɓare njafaŋëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ga canënihëhni kore ỹa g'ipër, Yesu tënkëko cery hna, pëlahna fandag fa vák ỹa do matëlehn. ");
INSERT INTO cou_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wëkasëk watac campëko resiỹo hna fop. ");
INSERT INTO cou_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hnë wati nte matëko Yesu hnam njind ŋa, vumëp vuki rëfëlendëhawo ndekatëndëni: «Hey! Ajë David, kaỹëhnahnëryiỹi gë fuhnë!» ");
INSERT INTO cou_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga tëkëk tere hna, vumëp va më tëhaniha do më tëƴëkëhni: «Ntiyahnëku bi koɗëfu liwu ile rëƴëɗun ỹa?» Më ntëkwaniha: «Ha, Aharaŋ.» ");
INSERT INTO cou_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Awa më ñakëkëhni vinkër va do ntehn: «Araɓi W̃ënu ŋa maw̃ëryahnu ile ỹaɗun ỹa kaɓi kwëtahnërunëho!» ");
INSERT INTO cou_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Do vinkër vidëw hni va kolëko nund. Tac më ŋañënahnëkëhni ntehnëhni: «Nëparyin ɗus, la aryampo tëfëlahna njëta waŋi.» ");
INSERT INTO cou_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ɓare njiniho nësëndëni soŋe Yesu ỹa hnë resiỹo rac hna fop. ");
INSERT INTO cou_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wati le cahnëɗëniho vumëp ŋa, Yesu njonëhnijikawo kumim kaɓi ƴine fëlakawo. ");
INSERT INTO cou_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu canënda tuŋ ƴine ỹa, kumim rac pëgwëlehn nësënd. Kore ỹa fop pëmpëhnahnëkëhniwo ɗus do nësëndëni: «Koɓëri nulëfuhna ỹi sifa iñë Isërayel li!» ");
INSERT INTO cou_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ɓare wafarise w̃a ntehnëɗëniho: «Asankaf waƴine ŋa yëɗaɗëha aỹi asan fanka canahnëndëhni waŋi waƴine!» ");
INSERT INTO cou_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hnë wati rac Yesu njiɗëho wahnaw̃ gë vankol hna fop; karaŋëɗëhëhniwo vahnë va vacery vacaliŋa vantëw̃ hni hna, pëƴahnëɗëho Wanës Wakasëk Naw̃ ŋa do njërënëɗëhëhniwo fop vëres gë vëreyah va. ");
INSERT INTO cou_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kaỹëhnahnëkawo ɗus gë wakore wade nuɗëho ŋa: mbëraniho do cilëtaniho; nkeniho had wape wante wok wahwëhnana ale heryëɗëhëhni. ");
INSERT INTO cou_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Awa më ntëhnëkëhni vërëfal vëlëw̃u va: «Ɓarëp roka yaɓah yehëhna, ɓare vëryokuŋ va vëyaɓëna. ");
INSERT INTO cou_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Awa muntaryina ahwëhn kaỹ a nkwënihni vëhaw̃ary.» ");
INSERT INTO cou_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ga puk watac Yesu macëkëhniwo vërëfal pëhw gë vëhi vëlëw̃u va do njëɗahni imëk ntandënihëhni waƴine do njërënëndënihëhni fop vëres va gë vëreyah va. ");
INSERT INTO cou_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wëlin wamac wadëw̃ hni ŋa: aryënkwëryënkw a umë ye Simo, nte w̃acëɗe Piyer g'aheryu Andëre gë viju Sebede, Sak gë San ");
INSERT INTO cou_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","gë Filip gë Barëtelemi gë Toma gë Matiye arëf ỹatëtanke ỹa gë Sak ajë Alëfe gë Tade; ");
INSERT INTO cou_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","gë Simo Ahahnëndak a gë Yuɗa Isëkariyot ale yeɗ aroka Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tac, Yesu paƴëkëhni ɗoku vësan pëhw gë vëhi va, gë ỹi siyab: «Keharyin waresiỹo wale ntëɗahnëni vële wok vëyena wasëwif va do nt'arënku la inaw̃ ɗampo Samari hna, ");
INSERT INTO cou_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ɓare ƴiryin gë cape ɓulunda Isërayel vëhni vële ye had vupe vunte sëvëk. ");
INSERT INTO cou_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nkaw̃ hna, pëƴahënëhni vahnë va Naw̃ ambin ŋa tëhajëk, ");
INSERT INTO cou_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ƴërënëryinëhni vëres va gë vëhwëhn ambiỹ per, matëndëryinëhni vësëm va, daryinëhni waƴine ŋa. Kifo nuỹarun daw̃ëluhna, w̃uhnë fëna ƴëɗahnëryin ki fo. ");
INSERT INTO cou_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nt'ayoyawu la uỹëc koryi ryampo; ");
INSERT INTO cou_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nt'ayowu kufa soŋe uyas w̃a; la acuɗ akaw̃ary ma wapary wakaw̃ary, la ryoko, kaɓi aryokuŋ a njëɗaɗe le valëɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ge tëkërun hn'inaw̃ ma hn'ankol, ƴëkëlehnëryin bi mo fëhwëtak soŋe kacaw̃u do ñëw̃ëryin ỹalu hna fo hafo aw̃atu hnam. ");
INSERT INTO cou_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ge tënkërun hnë tere dehnëryin: “Araɓi ƴam ỹa nke gë w̃uhnë.” ");
INSERT INTO cou_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ge vële lëɗëk hnë tere rac va kacanihu, araɓi ɗëwara hun ŋa cël ỹal hni hna, ge gwër nuỹani nke. Ge gena umë, araɓi iɗëwara hun ŋa mboka gë ỹalun. ");
INSERT INTO cou_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ge, hnë tere ma nkol hna fop, ŋwëỹik kacaɗeluhna ma nëpayiluhna, kërënaryin hnam do ɓankaryin ivëɗ wapary hun ŋa. ");
INSERT INTO cou_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Toña ỹa fëƴaɗëmu: hnë fac kiti hna, vële lëɗëk Sodom gë Gomor va vëyapënanëɗena ɗus gë vëvë iŋi nkol ki. ");
INSERT INTO cou_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Nëparyin! Paƴëɗëmu had wape wante wok wayëtëna ỹaƴah fagant waỹin. Awa titënaryin do ahnëŋu. ");
INSERT INTO cou_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Keharyinëhni vahnë va kaɓi kitiŋëɗënihu do ntampëɗënihu vacaliŋa vantëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Njiryeryëɗerun haryënkw hnë waguverëner hna gë vëhnaw̃ hna soŋe lëmën, waseɗe mën yeɗun haryënkw lëw̃ hni, vëhni gë waɓulunda wadëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ge njiryeryirun vakitiŋa hna antë nkehahnahnu soŋe le hnësëɗun ma gante tëfëka ahnësu: wanës wante rëfëka ahnësu ŋa njëɗaɗëhu W̃ënu ŋa wati rac. ");
INSERT INTO cou_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ha, gena w̃uhnë rëkëɗ ahnësëndu, ɓare Iƴir Rëmun ŋa rëkëɗ nësënd hnë w̃uhnë. ");
INSERT INTO cou_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Hnë wati rac, vële vankëk rëm gë hnëm njëɗahnëlëɗëni soŋe ndaw̃ini; warëm w̃a koyëna ntiɗënihëhni vutah vuntëw̃ hni va do vutah va ñew̃ëɗënihëhni vële hnagëkëhni va do ndaw̃ehnëɗënihëhni. ");
INSERT INTO cou_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vahnë va fop ñew̃ëɗënihu soŋe lëmën. Ɓare ale yaw̃ënaɗ hafo pu ỹa, W̃ënu ŋa pehëtëɗëha. ");
INSERT INTO cou_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ge këm fo ntiɗerun hn'inaw̃, garyëryin hn'ikaw̃ary. Toña ỹa fëƴaɗëmu: nkoɗun afëƴahnëndu wanës W̃ënu ŋa hnë wahnaw̃ wavë Isërayel hna fop hafo Ajë Ahn'a ɓokaj. ");
INSERT INTO cou_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Fakaraŋ fante lëbëka aharaŋ alëw̃u gena do aryokuŋ ale lëbëka ale ndokuŋëhnëɗ gena. ");
INSERT INTO cou_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Caŋëk ge fakaraŋ fa nke had aharaŋ alëw̃u ỹa do aryokuŋ a nke had ale ndokuŋënd a. Ge asankaf tere ỹa Belësebul macëɗe, awa vëvë tere lëw̃u va fëna koyëna macëɗeni!» ");
INSERT INTO cou_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Gante-wo nke ka, ntë ntaku gë vahnë va. Fop le sow̃ik ỹa cow̃ëtëɗe, do fop le ye sëvah ỹa njëtëɗe. ");
INSERT INTO cou_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ile hnësëhnëɗëmu g'umëɗ ỹa, tëfëtaryin ge pacëk; ile ỹakëñakënderun ỹa, ɗekaryin ƴaŋ. ");
INSERT INTO cou_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Antë ntakuni vële ryaw̃ëɗ imbahn ɓare hara wahoɗina ndaw̃ëni ntaw̃ary ŋa; dakëryiw̃una W̃ënu ŋa umë ale hoɗ ntab mbahn iŋa g'intaw̃ary iŋa per janáma hna. ");
INSERT INTO cou_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gena bi nkwafëɗeni vuñer vuki gë uỹëc koryi ryampo? Ɓare la fëndampo hnë vutac ƴojëɗina nkal li hara W̃ënu ŋa Rëm hun ỹa ƴëtëna. ");
INSERT INTO cou_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ge w̃uhnë ye, la mul ɓë vankaf hun ŋi ndëkwëk. ");
INSERT INTO cou_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Awa ntë ntaku: w̃uhnë lëbëkëhni nafa ỹa kore vuñer vuƴaɓah! ");
INSERT INTO cou_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ale-wo-le hnësëk ɓulunda hna ami hwëhnëka, nësëɗëfu ami fëna haryënkw Rëm mën le ye g'ambin ỹa ami hwëhnëka aỹi; ");
INSERT INTO cou_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ɓare ale-wo-le hnësëk ɓulunda hna kwëhnëlëw̃ahna, nësëɗëfu ami fëna haryënkw Rëm mën le ye g'ambin ỹa kwëhnëlëw̃ahna.» ");
INSERT INTO cou_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ant'ahnahawu ƴam yiryeryiɓu ɗuniỹa li: gena rac, uw̃ët ye. ");
INSERT INTO cou_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wasaŋëɗina ajë gë rëmu, aryag gë hnëmu, asëval gë hnëm asanu; ");
INSERT INTO cou_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","do vëỹew̃ ahnë va, vëvë tere lëw̃u va dënk yeɗ. ");
INSERT INTO cou_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Awa ale ỹahnëka rëmu ma hnëmu hafo lëbiwu ami, ahnë arac gena gwër nke arëfal mën; ale ỹahnëka aju ma aryagu hafo lëbiwu, ahnë arac gena gwër soŋe lëmën ỹa. ");
INSERT INTO cou_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ale wok maw̃ana tëfëndo hafo paki cëm hna kërëwa gena gwër nke arëfal mën. ");
INSERT INTO cou_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ale ỹaɗ ỹi ɗuniỹa ỹi cëmëɗ, ɓare ale wok kwëtahnëna nëf ỹi ɗuniỹa, soŋe lëmën ỹa, nkoryaryëɗ ntaw̃ary dëw̃u ŋa hafo araƴen hna.» ");
INSERT INTO cou_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ale-wo-le hacaku ỹa kacako; ale-wo-le hacako ỹa kacaka ale faƴiko ỹa. ");
INSERT INTO cou_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ale-wo-le hacaka kila W̃ën kaɓi kila ye, nuỹaɗ icos nte kwëtëhnik kila ỹa; do ale hacaka asatah a kaɓi asatah ye, nuỹaɗ icos nte kwëtëhnik asatah ŋa. ");
INSERT INTO cou_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Toña ỹa fëƴaɗëmu: ale yëɗaka la w̃ënka waƴamah fo ale ỹak vak hnë vërëfal mën hna kaɓi arëfal mën ye nuỹaɗ icos dëw̃u ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ante puhnako Yesu siyab vërëfal pëhw gë vëhi vëlëw̃u ŋa, njiko soŋe karaŋëhni vahnë va do nësëhnëhni wanës W̃ënu ŋa vankol vambë hnam hna. ");
INSERT INTO cou_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","San Ayary a, nte woko le cëɗiko hna, nkwëryëko le ntiɗëho Këris ỹa. Awa më paƴëkëhni vëryampo hnë vërëfal vëlëw̃u hna ");
INSERT INTO cou_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tëƴëryina Yesu: «Arëhnayik ale ỹaɗ njija bi yeru ma ahaw̃ary rëfëkëfu hnapëfu?» ");
INSERT INTO cou_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu më ntëkwakëhni: «Ƴiryin afëƴawuna San ile wëryëɗun do g'ile hnuɗun ỹa: ");
INSERT INTO cou_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","vumëp va nuɗëni, vële raɗëɗ va gona taɗëndëni, vëhwëhn ambiỹ va ƴër ŋa njërënëɗeni, vëryëŋënkah va nkwëryëɗëni, vësëm va ɓëhn ŋa mbëhnëndanëɗeni do Wanës Wakasëk ŋa pëƴaɗeni vëhaỹëhnah va. ");
INSERT INTO cou_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbetak ale woɗ tavëna ikwëtahn dëmën ŋa!» ");
INSERT INTO cou_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ante njini vërëfal San ŋa, Yesu më nësëndëhëhni kore ỹa soŋe San ntehnënd: «Ye yirunëho ayëkiwu wula hna? Ale wok kwëhnana nafa had idël ɓë tëfary sën nte ñënkëlend sël bi? ");
INSERT INTO cou_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Awa ye yirunëho ayëkiwu? Ale suɗak viỹi viwamah bi? Vële suɗaɗ viỹi viwamah va vacery vëhnaw̃ hna nkeni. ");
INSERT INTO cou_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Awa, ye lë yirunëho ayëkiwu? Kila bi? Ha, ntehnëɗëmu ntëbik dënk kila. ");
INSERT INTO cou_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Soŋe San nësëɗ Vikerëh va ante ntehnëko W̃ënu ŋa: “Cañëtëryiɗëfuha afaƴ mën a haryënkw hu pëhwëtëhni nkaw̃ ŋa.” ");
INSERT INTO cou_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Toña ỹa fëƴaɗëmu: koɓëri nagina ale lëbëka San Ayary a; ɓare ale ỹak mbak nafa Naw̃ ambin hna umë lëbëka San. ");
INSERT INTO cou_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Koɓëri wati nte pëƴahnëɗëho San wanës W̃ënu ŋa hafo gaki, ale-wo-le ntiɗ fere fop tënkahn Inaw̃ Ambin hna; vële varikaŋëk va fo hamënaɗ soŋe tënkëni. ");
INSERT INTO cou_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Wakila ŋa fop pëƴahnëni Naw̃ W̃ënu ŋa. Sariya Moyis ỹa fëna pëƴahnëk. Tac San fëna pëƴahnëko. ");
INSERT INTO cou_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Do ge ñaɗun aw̃aw̃u, San ye Eli, asan ale ntehnëniho wakila mbokajëɗ ŋa. ");
INSERT INTO cou_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesu më mbok ntehnëk: «Mo hoɗëfu w̃ëntëndëlehnëw̃ëhni vëỹi vahnë? Vutah vunte lañak le nëhëɗëni mëntëlëni, vundampo ndekahnatëndënihëhni vuñëntaw̃ va: ");
INSERT INTO cou_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Njëw̃ëhnirun hnëw̃ sampace, gaw̃ëluhna sampace! Njëw̃ëhnirun hnëw̃ wakwëy, gaw̃ëluhna wakwëy!” ");
INSERT INTO cou_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","San njijëko, tokëɗilohna roka fërën, ceɗilohna uñen do vahnë va caŋahnëlëliwohna, ntehnëɗëniho soŋe umë: “Ƴine fëlaka!” ");
INSERT INTO cou_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tac Ajë Ahn'a njijëk, tokëɗ, ceɗ do ntehnëɗëniho soŋe umë: “Ƴëkëryina aỹi asan, roka gë use ñen fo nahaɗ, do lawo vërëf ỹatëtanke ye do gë vëw̃en!” Ɓare vële rëfëk uyët va njavëtëɗëni W̃ënu ŋa catëk.» ");
INSERT INTO cou_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Awa Yesu pëgwëlehn ŋañënahnëndëhni vahnë vëvë vankol vante ñako ntihahn vifëmpëhnahnah viyaɓah vilëw̃u va, kaɓi hnam vëwëcëtëlohna vankeya vantëw̃ hni va. Më ntehnëk: ");
INSERT INTO cou_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Meku w̃uhnë vëvë nkol mbë Korasin gë mbë Betësayida vi! Ỹal hun hna ntik W̃ënu ŋa viỹë vifëmpëhnahnah va gena Tir gë Sidon. Ge hnam ntikënd viỹë virac, vëvë hnam vi mbiỹëk ga nkwëcëtakëndëni vankeya vantëw̃ hni va. Cuɗakëndëni viỹi icëm do nëvakëndëni iɓëhn vimbahn hna tufëhnahnëni gante njiw̃ëhnëni ka soŋe ile ntiɗëniho koɓëri ŋa. ");
INSERT INTO cou_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Soŋe umë fëƴaɗëmu, fac kiti hna vëvë Tir gë Sidon vëyapënanëhnëɗena ɗus gë w̃uhnë ki. ");
INSERT INTO cou_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","W̃uhnë vëvë Kaperënaỹum ntiyahnëku bi njihnëɗerun hafo ambin hn'ani? Geɗina koyëna. Ñoƴëɗerun hafo janáma hna. Ge vifëmpëhnahnah vile liyik ỹal hun va Sodom ntikënde, naw̃ tac nkokënd hafo dol. ");
INSERT INTO cou_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Soŋe umë fëƴaɗëmu, fac kiti hna vahnë vëvë Sodom va vëyapënanëhnëɗena gë w̃uhnë ki.» ");
INSERT INTO cou_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wati rac, Yesu ntehnëko: «Apa, Ahwëhn ambin g'inkal, camehnëmi gante njëtëndanëruhëhni vële ye had vutah ile sow̃ëntuhëhni vëhwëhn hakili g'uyët. ");
INSERT INTO cou_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ha, Apa, ntiru koyëna kaɓi irac ỹaɗu.» ");
INSERT INTO cou_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu më mbok ntehnëk: «Rëm mën ỹa njëɗako fop. Ahnë ƴëtëlohna ami, Aj'a, ge gena Rëm mën ỹa. Ahnë ƴëtëlahna Rëm mën ỹa ge gena ami, Aju ỹa do vahnë vële rëhnaɓu rufëw̃ëhni Rëm mën va.» ");
INSERT INTO cou_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ƴijën ỹal mën hna w̃uhnë fop vële ntënëk iɗiɓ vi do njëɗaɗëmu ntaw̃ëla ŋa. ");
INSERT INTO cou_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nufëryin sug lëmën ỹa yaŋëndu, koyëna nuỹaɗun yam ỹa soŋe walaw̃ary hun hna dënk. Dakëla yentiwu do ntaw̃ary iŋa pacëko. ");
INSERT INTO cou_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sug le lehnëmu ahnufu ỹi dakëna ndiɓi do iɗiɓ nte yëɗaɗëmu ŋa dënëna.» ");
INSERT INTO cou_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ga mbiỹëk toƴe, Yesu gë vërëfal vëlëw̃u va hnë wëhaỹ vantimp ndëcëtaɗëniho fac ntaw̃ëla. Vërëfal va inte yokëhniwo; pëgwëlehnëni nkubëndëni vantimp va do cemëndëni. ");
INSERT INTO cou_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wafarise wëryampo, ga nuni watac, më ntehnëniha Yesu: «Ƴëkëry, vërëfal hu va ile nkok maw̃ëryana sariya fu hnë fac ntaw̃ëla hna ntiɗëni!» ");
INSERT INTO cou_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu më ntëkwakëhni: «Karaŋëluhna bi ile ntiko David umë dënk gë vërëfëlëntaw̃u va hnë fac ryampo nte njokëhniwo inte ŋa? ");
INSERT INTO cou_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tënkëko cery W̃ën hna, nuf mburu nte kwëtëhniko W̃ënu ŋa, do tokëni umë gë vërëfëlëntaw̃u; hara, sariya fu ỹa maw̃ëryanëlëhniwohna tokëni: vësëna wasaɗëha fo maw̃ëryanëko. ");
INSERT INTO cou_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma karaŋëluhna bi ile kerëko Moyis ỹa: la hnë fac ntaw̃ëla hna, vësëna wasaɗëha ndokuŋëɗëniho Cery W̃ën Cankaf hna? Koyëna vëlënënëɗilohna sariya ntaw̃ëla ŋa, ɓare ahnë dehnëlëhniwohna menëni? ");
INSERT INTO cou_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Awa, paryi pëƴaɗëmu: nkehëhna hnani ile lëbëk Cery W̃ën Cankaf ŋi! ");
INSERT INTO cou_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gena bi W̃ënu ŋa lehnëk Vikerëh hna: “Ipërëna ŋa fecehnëko, gena saɗëha wusaw̃?” Ge paryi njëtakëndun ile pëhnëtanëɗ ỹa, kitiŋakëndilunihna vële wok vëw̃enëna. ");
INSERT INTO cou_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ƴëtëryin, Ajë Ahn'a umë ye Ahwëhn fac ntaw̃ëla ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu matëko hnam nji hnë caliŋa ntëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nkeho hnam asan ale cëmëko vák. Wafarise w̃a ñaɗëniho nuỹani ile pëƴahnëɗëni menëk Yesu pëlahni; soŋe rac më tëƴëniha: «Sariya fu ỹa maw̃ëryak bi njërëni ahnë hnë fac ntaw̃ëla?» ");
INSERT INTO cou_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu më ntëkwakëhni: «Ge aryampo hnë w̃uhnë, kwëhnaka ife ryampo fo do ife rac ntëba hnë hatëh hatëw̃ah hnë fac ntaw̃ëla hna, ƴiɗina bi ntabëtehn? ");
INSERT INTO cou_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Do, ahnë ƴaɓëlahna bi ɗus nafa ntëbi ife? Awa, sariya fu ỹa maw̃ëryak ntinëhni ahnë ifërën hnë fac ntaw̃ëla hna.» ");
INSERT INTO cou_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Awa Yesu më ntehnëka asan a: «Ƴeli vák hu ỹi.» Umë njelëk do mbokalehna fërën fo gë ỹëntaw̃ ka. ");
INSERT INTO cou_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tac, wafarise w̃a cahnëlehnëni nësëlini bi hak ntiɗëni ndaw̃ehnahnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Awa, Yesu, ga njëtak ile ñaɗëniho ntini wafarise w̃a, më kërënak hnam do kore sankaf rëfëlehnëkaw̃o. Njërënëkëhniw̃o vëres va fop, ");
INSERT INTO cou_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ɓare ŋañënahnëkëhniwo ntehnëhni antë pëƴahnëni bi mo ye. ");
INSERT INTO cou_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Koyëna nkeho ntiyahn wanës wante nësëko W̃ënu ŋa hnë w̃ës kila le w̃aciko Esayi ỹa: ");
INSERT INTO cou_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Wëliho aryokuŋëhn mën ale rëhnaɓu ỹa, ale ỹaɗëfu ɗus. Umë fëɓënëɗëfu iƴir mën ŋa do pëƴaɗëhëhni waƴamani ŋa gante ntiɗëfu ka catahnëni. ");
INSERT INTO cou_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Conkëntëɗena g'ahnë, ɗekaɗina, nësëɗina soŋe tufëhnahn. ");
INSERT INTO cou_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pakacëɗina hn'ile fëgwëk wubëɗ; ɗipehnëɗina lampu le wok pëtëɗina ɗus. Koyëna rëkëɗ ntind hafo urumpak w̃a pu; ");
INSERT INTO cou_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","do waɓulunda ŋi fop umë tamahnëɗëni.» ");
INSERT INTO cou_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Fac ryampo, Yesu njonëhnijikawo asan ale w̃ëpëko do wok koɗina nës kaɓi ƴine fëlakawo. Yesu njërënëkawo asan arac, hafo nund do nësënd. ");
INSERT INTO cou_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kore ỹa pëmpëhnahnëkëhniwo do fop ntehnëɗëniho: «Aỹi gena bi Ajë David ale hnapëɗeho ỹa?» ");
INSERT INTO cou_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wafarise w̃a ga nkwëryëni, më ntehnëni: «Aỹi asan ntaɗëhëhni waƴine ŋa, kaɓi Belësebul asankaf waƴine ỹa yëɗaɗëha fanka ntaɗëndahnëhni!» ");
INSERT INTO cou_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ɓare Yesu njëtëko nahan dëw̃ hni ŋa, awa më ntehnëkëhni: «Ge vële vankëk inaw̃ mëtëɗëni vëhni fo, naw̃ tac campëɗ, do ge vële vankëk ankol ma tere fëna mëtëɗëni, ankol tac ma tere rac campëɗ. ");
INSERT INTO cou_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Do ge Sintani ntaɗ le kwëhnëk umë ỹa dënk, umë fo w̃ëtëryaɗ; awa ucankaf ntëw̃u ŋa hak koɗ nko kahn? ");
INSERT INTO cou_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ntehnërun ntaɗëfuhëhni waƴine ŋa kaɓi Belësebul yëɗako imëk iŋa; vërëfal hun vi lë, mo yëɗakëhni imëk ntahahnëndënihëhni? Tufahnëɗëni vëhni dënk kwëhnaluhna toña! ");
INSERT INTO cou_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɓare ge g'Iƴir W̃ënu ŋa ntaɗëfuhëhni waƴine ŋi, umë tufahnëɗ Inaw̃ W̃ënu ŋa tëkik ỹal hun hna. ");
INSERT INTO cou_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Ahnë koɗina tënk hnë tere asan ahwëhn fanka do nuf hnapul lëw̃u ỹa, ge ñabëlahna ten asan arac; ɓare ge ñabëka koɗ nuf le-wo-le tere lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Ale wok gentina gë ami ỹa aỹew̃ mën ye; do ale wok ɗemaɗilohna varëpëw̃ëhni vahnë va campehnëɗëhëhni. ");
INSERT INTO cou_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Soŋe umë ye pëƴaɗëmu: vahnë va koɗe tavëhnini soŋe wameh-wo do soŋe waƴew̃ wante njew̃ëniha W̃ënu ŋa; ɓare ale yew̃ëk Iƴir Ipacah iŋa tavëhnëɗena. ");
INSERT INTO cou_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Do fëna, ale-wo-le hnësëɗ wanës wameh soŋe mën, Ajë Ahn'a, koɗe tavëhni; ɓare ge ahnë nësëk wanës wameh soŋe Iƴir Ipacah iŋa tavëhnëɗena hnë ɗuniỹa vë gaki ỹi gë vë le yejëk per.» ");
INSERT INTO cou_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Atëh përën wadëw̃el wapërën ntëw̃ëɗ do atëh meh wadëw̃el wameh ntëw̃ëɗ. Atëh ŋa wadëw̃el wante ntëw̃ëk ŋa njavëtahnëɗe. ");
INSERT INTO cou_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","W̃uhnë wafarise w̃i, njapërun had walën! Hak koɗun ahnësëndu viỹë vifërën do hara merun? W̃ës ỹa ile fëɓëk ntaw̃ary ỹa nësëɗ. ");
INSERT INTO cou_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ahnë afërën a viỹë vifërën vile fëɓëka ntaw̃ary dëw̃u va canëɗ; ahnë aw̃eh a viỹë viw̃eh vile fëɓëka ntaw̃ary dëw̃u va canëɗ. ");
INSERT INTO cou_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pëƴaɗëmu: fac kiti hna, vahnë va njavëtëɗëni tase W̃ënu ŋa fop wanës wakwëhn nafa këm wante nësëɗëniho ŋa. ");
INSERT INTO cou_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ƴëtëry, gë wanës wante hnësëru ŋa kitiŋëɗëhi W̃ënu ŋa do pëƴahnëɗ ge menëru ma menëlihna.» ");
INSERT INTO cou_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Awa vëharaŋ sariya vëryampo do gë wafarise wëryampo më ntehnëniha Yesu: «Aharaŋ, ñaɗëfun alinëhnëfu hnufu dahëse fëmpëhnahnah.» ");
INSERT INTO cou_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu më ntëkwakëhni gë aŋi nësa: «Vahnë vële ye vëw̃eh do wok vëhahnëndana soŋe W̃ën vi, dahëse tëƴëɗëni, ɓare sifa dahëse le yehawo kila le w̃aciko Yonas ỹi fo nuỹaɗëni. ");
INSERT INTO cou_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndampo fo nke gante ndakëko Yonas wafac warar hn'iɗonk igis cankaf ki, koyëna ndakëɗ Ajë Ahn'a fëna wafac warar ɓambery nkal hna tac mbëhnëɗ. ");
INSERT INTO cou_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Fac kitiŋ hna vëvë Niniv va nkentëɗeni gë vëvë gaki vi, do tufahnëɗëni vahnë vëvë gaki vi ntëntëni. Vëvë Niniv va vëhni nkwëcëtani vankeya va ante nkwëryëniho wanës Yonas ŋa do nkehëhna hnani ale lëbëka Yonas ɓare w̃uhnë gwëcëtaluhna vankeya va. ");
INSERT INTO cou_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Do fëna, fac le kitiŋëɗëhëhni W̃ënu ŋa vahnë va, asëval ale hnaw̃ëko hn'inkal Saba nkentëɗe gë vahnë vëvë gaki vi, do tufahnëɗ vahnë vëvë gaki vi ntëntëni. Umë le tëkwik nkal hna matik njij nëpa usery Salomo w̃a do nkehëhna hnani ale lëbëka Salomo ɓare nëpaɗilunahna! ");
INSERT INTO cou_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ge ƴine ntayik hnë ahnë, le nkeho cery ntëw̃u hna, njiɗ njasëlehnënd wëwac wahankah hna njëkëlehnënd hn'ile ñëw̃ëɗ. Ge nuỹana, ntehnaɗ: ");
INSERT INTO cou_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Mbokaɗëfu cery mën hn'ile matiɓu hna.” Awa njiɗ tëkata asan a had cery nte facik, fëhwëtik hafo njiv. ");
INSERT INTO cou_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Taŋ njiɗ njojëhni waƴine ntaw̃u mbëɗ gë waki wante lëbëka wayap, njijëni ñëw̃ëni hnam. Tac horot ahnë arac ỹa ntëbëɗe gë koɓëri ka. Do koyëna fëna nkeɗ soŋe vahnë vëw̃eh vëvë dol vi.» ");
INSERT INTO cou_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nkoko nësëhnëndëhni kore ỹa, ante tëkiniho hnëmu gë vëheryu ŋa. G'ipër ñëw̃ëniho do ñaɗëniho nësëhnëniha. ");
INSERT INTO cou_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ahnë më ntehnëka Yesu: «Nëpary, hnëmuh gë vëhery hu për hna ñëw̃ëni do ñaɗëni nësëhnënihi.» ");
INSERT INTO cou_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu më ntëkwaka ahnë arac: «Mo ye hnëm mën ỹa do gë vëhery mën va?» ");
INSERT INTO cou_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tac më tufakëhni kore le yeho hnam ỹa do ntehn: «Ƴëkëryin, hnëm mën ỹa gë vëhery mën va ani nkeni. ");
INSERT INTO cou_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vële liɗ le ñaɗ W̃ën le ye g'ambin ỹa vëhni ye vëhery mën va gë hnëm mën ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Fac rac, Yesu cahnëko tere hna nji ntaña tëfary lant hna soŋe karaŋ vahnë. ");
INSERT INTO cou_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kore sankaf varëpëlëko caharaɓ lëw̃u, hafo kaƴ hnë kulu do ntaña. Kore ỹa tëfary lant hna kahnëniho. ");
INSERT INTO cou_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Viỹë viyaɓah nësëndëhëhniwo gë wahnës waɗindaryindan ntehnëndëhni: «Fac ryampo asan yiko hnë kaỹ dëw̃u hna ipahn uhnëɗa. ");
INSERT INTO cou_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ga pahnëɗ, waŋëc wëɗampo nkaw̃ hna njoko: wusëry më njini kohnëni fop. ");
INSERT INTO cou_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wëɗampo nkal kwëhn wëraka njoko le nkok ƴaɓëna inkal. Waŋëc ŋa pëhnëlehn taŋ kaɓi nkal iŋa tëw̃ëlohna. ");
INSERT INTO cou_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ulav w̃a ga njakëk pëɗëlehn waƴor ŋa: kankëlehn kaɓi kwëhnalohna vënkahn. ");
INSERT INTO cou_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waŋëc wëɗampo wadëmpëhn njoko. Wadëmpëhn ŋa naỹëko ndaw̃ëlehn hnëɗa w̃a. ");
INSERT INTO cou_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɓare waŋëc wëɗampo nkal përën hna njoko do nkeho hnë watac waɗe lëw̃ëko: wëɗampo waŋëc keme (100) ntëw̃ëko, wañëntaw̃ ŋa wafëhw mbëɗ gë ryaw̃ (60) do wakaw̃ary kat wafëhw warar (30).» ");
INSERT INTO cou_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu më nkwënëk: «Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Awa vërëfal va tëhalehnëniha Yesu do tëƴëniha: «Soŋe ye hnësënduhëhni gë wahnës waɗindaryindan?» ");
INSERT INTO cou_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Më ntëkwakëhni: «W̃uhnë njëɗayirun ayëtu viỹë vivë Naw̃ ambin hna le sow̃ak, ɓare vëhni vëyëɗayina. ");
INSERT INTO cou_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ale wëryëk wapacëk a nkwënëhnëɗe uyët w̃a, do kobëɗëha; ɓare ale wok gwëryëna ỹa teɓëɗe la ile njëtëk ỹa. ");
INSERT INTO cou_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wëlin soŋe ile hnësëhnandëɓuhëhni gë wahnës waɗindaryindan: Njëkëɗëni hara vëhnuɗina do nkwëryëɗëni hara vëyëtëɗina. ");
INSERT INTO cou_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Koyëna ile nësëko W̃ënu ŋa hnë w̃ës kila Esayi ỹa ntiyaɗ hnë vëhni: «“Nkwëryëɗun ɗus, ɓare ƴëtëɗiluhna; njëkëɗun ɗus, ɓare nuɗiluhna. ");
INSERT INTO cou_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iỹi ɓulunda kambënëni vankaf va soŋe antë nkwëryëɗëni; ciŋani vanëf va do ndëmëni, soŋe vanëf vantëw̃ hni va antë nkwëryënd do antë vinkër vidëw̃ hni va nund, wahakili walëw̃ hni w̃a antë njëtënd; më nkoni vëwëcëtaɗina vankeya vantëw̃ hni va soŋe yërënahnëw̃ëhni.” ");
INSERT INTO cou_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mbetarun w̃uhnë kaɓi vinkër hun va nuɗ do vanëf hun va nkwëryëɗ! ");
INSERT INTO cou_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Paryi pëƴaɗëmu: wakila waƴaɓah gë vësatah vëhaw̃ary vëyaɓah va ñaɗëniho nuni do nkwëryëni ile hnuɗun do wëryëɗun ỹi, ɓare vëhnulohna do vëwëryëlohna fëna.» ");
INSERT INTO cou_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu më mbok ntehn: «Awa w̃uhnë, nëparyin ile pëhnëtanëk uw̃i hnës uryindaryindan ahnaɗ uhnëɗa w̃a. ");
INSERT INTO cou_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vële wëryëɗ ga nësëɗe soŋe naw̃ do vëyëtëna bi ye nësëɗ, had tëfary nkaw̃ nkeni le njoɗ uhnëɗa hna: Sintani njijëɗ teɓa fop ile fahnik walaw̃ary walëw̃ hni ỹa. ");
INSERT INTO cou_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Vëryampo had nkal kwëhn wëraka nkeni le njoɗ uhnëɗa hna: nkwëryëndëni wanës ŋa tuŋ maw̃ëɗëni taŋ g'uhnatah. ");
INSERT INTO cou_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ɓare vëravëɗina kwëhna vënkahn hnë vëhni, ikwëtahn dëw̃ hni ŋa ɓëyëɗina. Awa ge ryëñah w̃a tëkëhnikëhni ma ge mbërehnini soŋe wanës W̃ënu ŋa, tavëɗëni taŋ kwëtahn dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Vëhaw̃ary kat had hn'ile nke wadëmpëhn nkeni: nkwëryëɗëni wanës ŋa, ɓare nahan iỹi ɗuniỹa ŋa do gë wëɓal soŋe hnapul ỹa ndaw̃ëɗ wanës ŋa, do ñoñ ƴojëɗina ifërën hnë vëhni. ");
INSERT INTO cou_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɓare vëryampo had inkal përën nkeni: nkwëryëɗëni wanës ŋa do njëtëɗëni ile pëhnëtanëɗ ỹa; watac yojëk ifërën hnë vëhni had vatëh vante lëw̃ëko vëndampo keme (100), vañëntaw̃ wafëhw mbëɗ gë ryaw̃ (60) do vakaw̃ary kat wafëhw warar (30).» ");
INSERT INTO cou_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nësëhnëkëhniwo uhnës uryindaryindan haw̃ary: «Naw̃ ambin ŋa gë ỹin mëntëlëni: ahnë hnaɗëko uhnëɗa fërën kaỹ dëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Umëɗ ndampo, wati nte ndakëniho vahnë fop ŋa, ale ỹew̃ëka ahwëhn kaỹ tac a më njijëk naɗ idël meh hn'ikaỹ tac, njilehn. ");
INSERT INTO cou_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ga pëhnëk uhnëɗa w̃a do ntëw̃, dël meh iŋa fëna cahnëntiko. ");
INSERT INTO cou_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Vëryokuŋ ahwëhn kaỹ va njilehnëni ntehnëniha: “Ahwëhn, gena bi uhnëɗa fërën hnaɗëruho kaỹ hu hna? Awa ne matik idël meh iŋi?” ");
INSERT INTO cou_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Më ntëkwakëhni: “Aỹew̃ mën lik rac.” «Vëryokuŋ va më tëƴëniha: “Awa, ñaɗu bi yifu lihëtëfu dël meh iŋi?” ");
INSERT INTO cou_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Më ntëkwakëhni: “Hali, ge ntihëtëɗun dakëna ayëcaryu uhnëɗa w̃a. ");
INSERT INTO cou_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tavëryin, naỹëlahnëni hafo uhác hna. Hnë wati rac, ntehnëɗëfuhëhni vëhác va ntihëtëni ten dël meh ŋi do ñabëni wavap wavap soŋe pëɗi, tac ndanëni roka ỹa ndank mën hna.”» ");
INSERT INTO cou_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu nësëhnëkëhniwo uhnës uryindaryindan haw̃ary kat: «Naw̃ ambin ŋa g'uỹëc atëh mutarëd mëntëlëni, ule nufëk ahnë pahnëk hnë sarëɗiŋ lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Uỹëc rac ỹak vak waŋëc hna fop; ɓare ge pëhnëk, urac ỹak hnaỹëk vatëh vamb sarëɗiŋ hna fop: naỹëɗ hafo gwër kofahnëni wusëry w̃a hnë wahni walëw̃u hna.» ");
INSERT INTO cou_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu nësëhnëkëhniwo uhnës uryindaryindan haw̃ary: «Naw̃ ambin ŋa mëntëlëni gë levir le nufëk asëval nëgw gë upih ƴaɓah, tac cis fop.» ");
INSERT INTO cou_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu gë wahnës waɗindaryindan nësëndëhëhniwo kore ỹa watac fop; nësëndilëhniwohna hara wahnës waɗindaryindan gentina. ");
INSERT INTO cou_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Koyëna ntiyako wanës wante nësëko kila ỹa: «Gë wahnës waɗindaryindan rëkëɗëfu hnësëndu, do pëƴahnëɗëfu viỹë vile sow̃ik koɓëri ante ntiyiko ɗuniỹa ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Awa Yesu tavëkëhniwo kore ỹa nji gë tere. Vërëfal vëlëw̃u va më tëhaniha do tëƴëniha: «Gabëryifu uhnës uryindaryindan idël meh mbë kaỹ ŋi.» ");
INSERT INTO cou_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu më ntëkwakëhni aki: «Ale hnaɗëɗ uhnëɗa fërën w̃a, Ajë Ahn'a yeho; ");
INSERT INTO cou_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kaỹ iŋa ɗuniỹa ỹi ye; uhnëɗa fërën w̃a vële ye Naw̃ W̃ënu va ye; dël meh iŋa vëhni ye vële kwëhnëk Sintani va; ");
INSERT INTO cou_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","aỹew̃ ale hnaɗëɗ dël meh iŋa Sintani ye; uhác w̃a, wapuya ɗuniỹa ŋa ye; do vëhác va wamëleka ŋa ye. ");
INSERT INTO cou_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Gante ntihëtëɗe idël meh do ntabi hnë hwëɗëh ki, koyëna ntiɗeni vëw̃en va wapuya ɗuniỹa hna. ");
INSERT INTO cou_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ajë Ahn'a paƴiɗëhëhni wamëleka wadëw̃u ŋa, ntihëtëɗënihëhni Naw̃ dëw̃u hna fop vële sanëkëhni vëỹënta hni hn'ikwëtahn va do gë fop vële wok vëw̃aw̃ëhnëɗilahna W̃ënu ŋa, ");
INSERT INTO cou_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","do ntabëɗënihëhni hnë hwëɗëh hucankaf janáma hna; hnam rëkëɗ kondëni do cemëlehnandëni wabeñ ŋa. ");
INSERT INTO cou_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ɓare, vësatah va rëkëɗëni pëtëndëni had lepera hnë Naw̃ Rëm lëw̃ hni hna. Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu më mbok ntehn: «Naw̃ ambin ŋa gë hnapul le sow̃ik hn'ikaỹ mëntëlëni. Ge ahnë nuk hnapul rac cow̃ëɗ g'ahaw̃ary. Natëɗëha hafo nji nkwaf fop ile kwëhnak ỹa do mbokaj ntaw̃ kaỹ tac. ");
INSERT INTO cou_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Do fëna Naw̃ ambin ŋa gë sanikona wamah le yëkëlehnëɗ awaf mëntëlëni. ");
INSERT INTO cou_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ge nuk uryampo ule hwëhnak nafa ntëbi sanu, njiɗ nkwaf fop le kwëhnak ỹa do mbokaj ntaw̃ sanikona rac.» ");
INSERT INTO cou_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu më mbok ntehn: «Naw̃ ambin ŋa gë ỹin mëntëlëni fëna: waryeƴët loŋëɗe hnë lant do fëlaɗëhëhni sifa wuwis-wo. ");
INSERT INTO cou_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ge pëɓëni wuwis w̃a vëfëla va ndoɗëni gë vambëŋ lant, tac ntañani tahnënihëhni: wufërën w̃a hnë kankel kwëtëɗënihëhni do ntoŋënihëhni wule wok wahwëhnana nafa w̃a. ");
INSERT INTO cou_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Koyëna nkeɗ wapuya ɗuniỹa ŋa: wamëleka ŋa njijëɗëni pitëndëlehnënihëhni vëw̃en va gë vësatah va. ");
INSERT INTO cou_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Vëwen va hnë hwëɗëh hucankaf janáma hna ntoŋëɗënihëhni; hnam rëkëɗ kondëni do cemëlehnandëni wabeñ ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu tëƴëkëhniwo: «Nkwëryërun bi waŋi fop?» Më ntëkwaniha: «Ha». ");
INSERT INTO cou_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Awa më ntehnëkëhni: «Koyëna nkeɗ ge aharaŋ sariya nke fëna arëfal Naw̃ ambin ŋa. Ahnë arac mëntëlëni g'ahwëhn hnapul ale hnufiɗ hnë hnapul lëw̃u hna vihasëk gë visër.» ");
INSERT INTO cou_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ga puhnak Yesu nanta waỹi wahnës waɗindaryindan w̃a, më njik ");
INSERT INTO cou_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hnë naw̃ nte naỹahnëko hna. Pëgwëlehn karaŋëndëhni caliŋa mbë hnam hna do fop vële yeho hnam va pëmpëhnahnëkëhniwo ɗus. Ntehnëɗëniho: «Ne nufik uw̃i uyët? Hak kolahnëk ntind viỹë vifëmpëhnahnah? ");
INSERT INTO cou_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Gena bi umë ye fatah afak vacery ỹa? Gena bi Mari ye hnëmu ỹa? Sak gë Yosef gë Simo do gë Yuɗ gena bi vëhni ye vëheryu va? ");
INSERT INTO cou_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Do vëheryu vësëval va gena bi fop ỹal fu li nkeni? Ne nufik awa ỹin fop?» ");
INSERT INTO cou_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Do rac w̃emaỹehnëkëhniwo soŋe kwëtahnëniha. Awa Yesu më ntehnëkëhni: «Kila ntënënik gante-wo-gante ɓare gena hn'ile nagik hna do kas tere lëw̃u hna.» ");
INSERT INTO cou_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Awa Yesu toƴe fo ntiko hnam vifëmpëhnahnah va kaɓi vëhwëtahnëlawohna. ");
INSERT INTO cou_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hnë ƴamani rac, Eroɗ, nte hnaw̃ëko Galile ŋa, nkwëryëko ga nësëɗe soŋe Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Më ntehnëkëhni vëryokuŋ vëlëw̃u va: «San Ayary a ye: mbëhnik! Soŋe umë kwëhnahnëk fanka ntihahnënd viỹë vifëmpëhnahnah.» ");
INSERT INTO cou_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eroɗ nësëko koyëna kaɓi umë lehnëko pëlayi San, ñabi, cëɗi do ndaw̃ehna. Wëlin itëfëta icëm San Ayary a: Eroɗ cëɗehnahnëkawo soŋe Erodiyaɗ asëvalu Filip, aheryu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ntiko koyëna kaɓi ñëlëkawo gë Erodiyaɗ do San ntehnëɗëhawo: «Sariya ỹa maw̃ëryana aỹëla asëval ahery hu ỹa!» ");
INSERT INTO cou_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroɗ ñaɗëho ndaw̃ehna San, ɓare nkehahnahnëkawo gë ɓulunda ỹa, kaɓi vëhni fop kila ntinihawo San. ");
INSERT INTO cou_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Koyëna nkeho hafo fac le nagahniko Eroɗ ỹa mbok tëkik, aryagu Erodiyaɗ nkaw̃ëɗëho haryënkw vële faƴehniko hna. Eroɗ nëŋëkawo ɗus ");
INSERT INTO cou_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hafo ntëkëhna ntehn njëɗaɗëha fop le tëƴëɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gë siyab hnëmu ha më ntehnëka: «Ƴëɗarye ankaf San Ayary a hnë fëɗa mpan!» ");
INSERT INTO cou_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ahnaw̃ a Eroɗ njamëlehn; ɓare soŋe idëk dëw̃u tase vëfaƴ vëlëw̃u ŋa, më ntehnëk njëɗayi le tëƴëk ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Paƴehnëlehn ntëpëtiji nkaf San ŋa kaso hna. ");
INSERT INTO cou_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Më yojik ifëɗa hna njëɗayi fandag fa, do umë njëɗahna hnëmu. ");
INSERT INTO cou_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tac, vërëfal San va më njini nufëni ñas iŋa mbañëni; tac njilehnëni pëƴaniha Yesu ile liyak ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ga nkwëryëk waŋi wakasëk, më matëni hnam gë vërëfal vëlëw̃u va, kaƴëni kulu hna, njini minëhni fo le njirëk. Ɓare vahnë va njëtaniho, awa më cahnëni vankol vantëw̃ hni hna tëfëlehnëniha gë wapary ŋa fo. ");
INSERT INTO cou_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ga cëlëk Yesu kulu hna, nutëhni kore sankaf rac, kaỹëhnahnëkawo ɗus gë vahnë vërac do pëgwëlehn njërënëndëhni vële resëko va. ");
INSERT INTO cou_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","G'anëka ga vërëfal vëlëw̃u va më tëhaniha ntehnëniha: «Mëɗëk do hnani fëk fo ye. Koyaryihni vëỹi vahnë njini vankol hna ntëw̃ani ile tokëɗëni!» ");
INSERT INTO cou_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Më ntëkwakëhni: «Lakënde vëyina: ƴëɗaryinëhni w̃uhnë dënk ile tokëɗëni ỹa!» ");
INSERT INTO cou_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Më ntehnëniha: «Ɓare vamburu mbëɗ g'uwis wuhi fo hwëhnaɓun.» ");
INSERT INTO cou_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Më ntehnëkëhni: «Ƴinenëhnino». ");
INSERT INTO cou_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tac, ntehnëhni kore ỹa ntañani dël hna do nuf vamburu mbëɗ va gë wuwis wuhi w̃a, kaŋëk g'ambin do camehna W̃ënu ŋa soŋe ỹi rokëtok. Nkubëlehnëk vamburu va njëɗahni vërëfal vëlëw̃u va, do vëhni cahëlehnënihëhni kore ỹa. ");
INSERT INTO cou_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ale-wo-le tokëko hafo pihn. Vërëfal va vëkankel pëhw gë vaki vapëɓah mbarëpëniho vankubel vante tesëniho va. ");
INSERT INTO cou_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vële rokëko va tëkëniho vësan wawuli mbëɗ (5,000), hara vësëval va gë vutah va vëryëkwaryina. ");
INSERT INTO cou_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Paco, Yesu kaƴëndëlehnëhni vërëfal va kulu hna ndënkwëhnëhëniha gë cape ñëntaw̃ lant ka, wati nte koyaɗëhëhniwo umë dënk kore ŋa. ");
INSERT INTO cou_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ga koyakëhni, më kaƴëk hn'ikuŋ soŋe ƴëfa. Ga nëkak, minu fo nkeho hnam. ");
INSERT INTO cou_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hnë mpëd atac, kulu ỹa tëko ŋaw̃ëta vambëŋ va do wavonkëlo w̃ënka ŋa pankëlëɗëniho kaɓi, gante matiɗ, sël paɓëniho. ");
INSERT INTO cou_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ga nkëhnëk pac, Yesu gë vërëfal vëlëw̃u njiɗëho njasëhatënd w̃ënka hna. ");
INSERT INTO cou_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ante nuniha ga njasiɗ w̃ënka hna, ntakëkëhniwo ɗus do ndekaɗëniho: «Ahnënkwël ye!» ");
INSERT INTO cou_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu më nësëhnëkëhni taŋ: «Ƴaw̃ënaryin! Ami Yesu ye! Antë ntaku!» ");
INSERT INTO cou_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Awa, Piyer më teɓak wanës ŋa do ntehna: «Ahwëhn, ge paryi wëjë ye, dehnërye yiryiw̃u w̃ënka li.» ");
INSERT INTO cou_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu më ntehnëka: «Ƴij!» Piyer cëlëlehn kulu hna pëgw njasënd ƴaŋ w̃ënka hna njind gë vëhni Yesu. ");
INSERT INTO cou_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ɓare ga kamahnëk sël ỹa njaw̃ëk, më ntakëka, pëgwëlehn nkëƴand w̃ënka hna do ndekak: «Ahwëhn, pehëtërye!» ");
INSERT INTO cou_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Taŋ, Yesu njelëlehn vák ỹa, pëlahna do ntehna: «Wëjë, mbaki ikwëtahn! Soŋe ye wajëlehnaru?» ");
INSERT INTO cou_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tac, kaƴëlehnëni vëhni vëhi tak kulu hna do sël ỹa tëryalehn. ");
INSERT INTO cou_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Awa vërëfal va fop ndëkwëhnëlehnëni haryënkw Yesu do ntehnëniha: «Paryi nke Ajë W̃ënu ŋa yeru!» ");
INSERT INTO cou_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tëkëlehnëni hnë vambëŋ lant vamb nkal Senesaret hna. Ga ntëmpëtani lant ỹa Yesu gë vërëfal vëlëw̃u va, tënkëlehnëni hn'inkal ɓë resiỹo Senesaret hna. ");
INSERT INTO cou_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vahnë vëvë hnam va njavëtënihawo Yesu do pëƴahnëniho gante-wo-gante tëkik ỹal hni hna, do njonehnijikëhniwo vëres va fop. ");
INSERT INTO cou_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Këlaɗënihawo tavëhni ñakëhni wëla wacëmët cuɗ cankaf ntëw̃u ŋa fo do fop vële ỹakëko va njërëniho. ");
INSERT INTO cou_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fac ryanko, wafarise gë vëharaŋ sariya w̃atiko Yerusalem njini tëƴëniha Yesu: ");
INSERT INTO cou_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Soŋe ye vërëfal hu vi nkoni vëlënënëɗina wënamu wante taveryënihëfu vacërakëlo fu ŋi? Vëhni vëỹuhnaɗina wëɓák ŋa tokahnëndëni gante nke namu fu ka.» ");
INSERT INTO cou_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu më ntëkwakëhni: «W̃uhnë lë, soŋe ye worun dënënëluhna vakwëɗa W̃ënu va, ɓare wënamu hun dënk liɗun? ");
INSERT INTO cou_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","W̃ënu ŋa dehnëna bi: “Dënënëryihni vëhni rëmuh gë hnëmuh”, do fëna “Ale lehnëka rëmu ma hnëmu wameh a tëfëka ndaw̃i”? ");
INSERT INTO cou_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ɓare w̃uhnë, ntehnëɗunëhëhni vahnë va ahnë koɗ ntehnëhni vële hnagëka va: “Ile rëfëkawo yëɗaw̃u ryemahnu ỹa saɗëha le pehnëhnik W̃ënu w̃aruŋëɓu.” ");
INSERT INTO cou_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Awa ge aki nke vahnë va gona mbalëhni ntënënënihëhni vële hnagëkëhni va. Koyëna ntihëtëɗun wanës W̃ënu ŋa soŋe namu lëw̃ hun ỹi! ");
INSERT INTO cou_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","W̃uhnë vëw̃ër! Kila Esayi toña kwëhnako ante nësehnëkawo W̃ënu ŋa soŋe lëw̃ hun ŋa aki: ");
INSERT INTO cou_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«“Iỹi ɓulunda gë wanës ŋi fo ntënënëɗëniho, ɓare wasakahn walëw̃ hni hna ŋaw̃ëtaniho. ");
INSERT INTO cou_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Icëmb dëw̃ hni ŋa, kwëhnana nafa kaɓi gena wanës mën ŋa karaŋëɗënihëhni vahnë va ɓare wënamu wadëw̃ hni fo ye.”» ");
INSERT INTO cou_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tac Yesu më ntehnëkëhni kore ỹa fop: «Nëparyin do gwëryëryin ỹin: ");
INSERT INTO cou_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gena ile rënkëɗ hnë w̃ës ahnë ỹa ronkënëɗëha, ɓare ile sahniɗ w̃ës lëw̃u ỹa, umë ye ile ronkënëɗëha ahn'a.» ");
INSERT INTO cou_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Awa vërëfal va më tëhaniha Yesu tëƴëniha: «Njëtëru bi wafarise w̃a ntavëkëhni gë wëjë soŋe wanës wante hnësëru ŋi?» ");
INSERT INTO cou_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Umë ntëkwakëhni: «Atëh nte-wo-nte nkok pëlëna Rëm mën le ye g'ambin ỹi nkëcëɗe. ");
INSERT INTO cou_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tavëryinëhni: vumëp vunte hahëɗ vumëpëntahni ye! Do ge mëp kahëɗëha mëp ñëntaw̃, njoɗëni vëhni vëhi tak hnë hatëh.» ");
INSERT INTO cou_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Awa Piyer më ntehnëka Yesu: «Gabëryifu bi ye pëhnëtanëk waŋi wanës soŋe ronk.» ");
INSERT INTO cou_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu më ntëkwak: «W̃uhnë fëna, gwëryëɗiluhna bi ha gaki? ");
INSERT INTO cou_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ƴëtëluhna bi le-wo-le rënkëk w̃ës ahnë ỹa ndëcëɗ iɗonk dëw̃u hna tac cahnëɗ mbahn dëw̃u hna? ");
INSERT INTO cou_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ɓare ile sahnik w̃ës ỹa ntaw̃ary hna matik, do rac ronkënëɗëha ahn'a. ");
INSERT INTO cou_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ɓambery ntaw̃ary ahnë hna matiɗ vinahan vimeh vinte liyehnëɗëhëhni ndaw̃ëndënihëhni vahnë, njëkëlehnëndënihëhni vësëval vëhaw̃ary, do ntindëni ndakëntal nte mbañëk W̃ën, ntehnëndëni, mërëndëni, do nësëndëni wameh vëỹënta hni. ");
INSERT INTO cou_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wëlin ile ronkënëɗëha ahnë ỹa! Ɓare itok hara ñuhnalihna wëɓák gante nke namu ka, umë tonkënëɗilahna ahnë.» ");
INSERT INTO cou_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tac, Yesu më matëk hnam nji hnë vankol vante ye caharaɓ Tir gë Sidon hna. ");
INSERT INTO cou_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hnë wati rac, asëval ale lëɗëko hnë resiỹo rac më njijëk ɗarël lëw̃u. Arac ɓulunda vële w̃acëɗe Kanan hna kwëhnaryiko. Pëgwëlehn ndekand: «Ahwëhn Aju David, kaỹëhnahnëryiỹi g'ami! Aryag mën a ƴine fëlaka do mbërak ɗus!» ");
INSERT INTO cou_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ɓare Yesu la ñoñ dëkwalawohna. Awa vërëfal vëlëw̃u va më tëhaniha ntehnëniha: «Daryehna aỹi asëval! Njankëɗëhëfu tëfëlehnatëndëfu.» ");
INSERT INTO cou_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu më ntëkwaka asëval a: «W̃ënu ŋa soŋe vëvë Isërayel fo paƴiko, vële ye had wape wante sëvëk.» ");
INSERT INTO cou_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɓare asëval a tëhakawo ndëkwëhn haryënkw lëw̃u do ntehn: «Ahwëhn, ɗemarye!» ");
INSERT INTO cou_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu më ntëkwaka: «Ƴivëna nufi roka vutah va këfëhnini vumbe vi.» ");
INSERT INTO cou_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Asëval a më ntëkwaka: «Ahwëhn, toña hwëhnaru. Ɓare vumbe va ile yoɗ toka roka vële hwëhnëkëhni hna tokëɗëni.» ");
INSERT INTO cou_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Awa Yesu më ntëkwaka: «Kwëtahnëhu ŋa njaɓëk! W̃ënu ŋa ntiɗ ile ỹaɗu ỹa.» Do aryagu njërëlehn wati rac dënk. ");
INSERT INTO cou_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tac, Yesu matëko hnam nji tëfary lant Galile hna. Umë kaƴëk hn'ikuŋ do ntaña. ");
INSERT INTO cou_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wakore waƴaɓah më njijëni ỹalu hna. Më njojënihëhni vële raɗëɗ, vumëp, vëreyah, wakumim, gë vëres vëhaw̃ary vëyaɓah. Haryënkw Yesu kwëtëɗënihëhniwo, do njërënëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vahnë va pëmpëhnahnëkëhniwo ante nunihëhniwo wakumim ŋa ga nësëɗëni, vëreyah va njërëniniho, vële raɗëɗ va njasëɗëniho g'afërën do vumëp va nuɗëniho g'afërën. Do pëgwëlehnëni cëmbëndëniha W̃ën Isërayel ỹa. ");
INSERT INTO cou_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tac Yesu macëkëhniwo vërëfal vëlëw̃u va ntehnëhni: «Kaỹëhnahnëkow̃ëhni vëỹi vahnë. Wëlin wafac warar yelahnëɓun do ñoñ vëhwëhnana ile tokëɗëni. Ñaɗa hoyaw̃ëhni g'inte fo soŋe antë njohëni g'ankaw̃.» ");
INSERT INTO cou_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Vërëfal va më tëƴëniha: «Hnë iỹi fëk, ne koɗëfun hnuỹafu ile ryavahnëfuni hafo pihnëni kore gë iỹi ki?» ");
INSERT INTO cou_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu më tëƴëkëhni: «Vamburu vajëhw hwëhnarun?» Umë ntëkwani: «Mbëɗ gë vaki, do gë vunkis.» ");
INSERT INTO cou_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Awa, më ntehnëkëhni vahnë va ntañani nkal hna. ");
INSERT INTO cou_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tac më nufëk vamburu mbëɗ gë vaki va, camehnëka W̃ënu ŋa, nkubëlehnëk do njëɗahni vërëfal vëlëw̃u va, cahëlehnënihëhni vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ale-wo-le tokëko hafo pihn. Vërëfal va mbarëpëniho vëkankel vapëɓah mbëɗ gë vaki vankubel vante woko va. ");
INSERT INTO cou_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vële rokëko va vësan wawuli wahnah yeho, hara vëryëkwaryina vësëval va gë vutah va. ");
INSERT INTO cou_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ga koyakëhni kore ỹa, Yesu kaƴëko kulu hna njind gë resiỹo Magadan. ");
INSERT INTO cou_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ga mbiỹëk toƴe, wafarise gë wasaduse tëhanihaw̃o Yesu soŋe tëndëhnëniha urënd. Tëƴënihawo ntinëhnëhni dahëse le rufahnëɗ paryi nke W̃ënu ŋa faƴika. ");
INSERT INTO cou_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ɓare Yesu më ntëkwakëhni aki: «Ge ambin ŋa mbëntëk g'anëka ga, ntehnëɗun: “Acahn tëvëɗina.” ");
INSERT INTO cou_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Do ge ambin ŋa mbëntëk koɓëri fo g'acahnëfëɗ ga, ntehnëɗun: “Tëvëɗ dol.” Koɗun ayëtu ile liyaɗ ỹa ge njëkërun ambin ŋa, ɓare koɗiluhna ayëtu vile liyaɗ hnë iỹi wati ỹi, bi ye pëhnëtanëɗ! ");
INSERT INTO cou_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Vahnë vëvë gaki vi, vële ye vëw̃eh do wok vëhahnëndana soŋe W̃ën vi, dahëse tëƴëɗëni, ɓare sifa dahëse ile yehawo kila le w̃aciko Yonas fo nuỹaɗëni.» Tac Yesu më tavëkëhni nji. ");
INSERT INTO cou_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Awa Yesu kaƴëniho gë vërëfal vëlëw̃u va kulu hna, soŋe ndanëni gë cape ñëntaw̃ lant ka. Ante njiɗëniho ŋa vërëfal va më kamahnëni wayoyana ile tokëɗëni. ");
INSERT INTO cou_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Wati rac, Yesu më ntehnëkëhni: «Diryin wajira! Keharyin levirwafarise w̃a do gë wasaduse w̃a.» ");
INSERT INTO cou_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Vërëfal va pëgwëlehnëni nësëlëndëni: «Kaɓi ƴojilënëhna vamburu më nësëɗ aki.» ");
INSERT INTO cou_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu njëtëko wante nësëlëɗëni ŋa, awa më ntehnëkëhni: «W̃uhnë, mbaku kwëtahn iŋa! Soŋe ye liyahnëku paŋare vamburu vante ryënkwirun nësëndëmu! ");
INSERT INTO cou_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gwëryëluhna ha gaki? Ɗënkwëtaɗiluhna bi vamburu mbëɗ vante cehëlehniniho vësan wawuli mbëɗ va do gë fop vëkankel vankubel vante varëpërunëho va? ");
INSERT INTO cou_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Do ɗënkwëtaɗiluhna bi vamburu mbëɗ gë vaki vante cehëlehniniho vësan wawuli wahnah va do fop vëkankel vankubel vante varëpërunëho va? ");
INSERT INTO cou_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hak nkorun gwëryantuhna nësëndiluhna soŋe vamburu ante ntehnakëndëmu ahehawu levir wafarise w̃a do gë wasaduse w̃a?» ");
INSERT INTO cou_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Awa vërëfal va nkwëryëlehnëni nësëndilëhniwohna soŋe levir le lihande mburu, ɓare ile karaŋëɗëni wafarise do gë wasaduse ntehnëɗëhëhniwo kehani. ");
INSERT INTO cou_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tac Yesu njiko hnë resiỹo Sesare Filip hna. Më tëƴëkëhni vërëfal vëlëw̃u va: «Vahnë va, mo ntehnëni yeɓu, ami Ajë Ahn'a?» ");
INSERT INTO cou_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Më ntëkwani: «Vëryampo, vëhni lehnëɗ San Ayary a yeru, vëhaw̃ary Eli yeru, do vëhaw̃ary kat, Seremi yeru ma kila haw̃ary.» ");
INSERT INTO cou_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu më mbok tëƴëkëhni: «W̃uhnë lë, mo lehnërun yeɓu?» ");
INSERT INTO cou_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Piyer më ntëkwaka: «Arëhnayik a yeru, Ajë W̃ën paryi ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Awa Yesu më ntehnëka: «Nëfaki, Simo aju San; gena ahnë yëtëndanëki iỹi toña, ɓare Rëm mën ile ye g'ambin ỹa ye. ");
INSERT INTO cou_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Awa, ami, ntehnëɗëmi, Piyer (ile fëhnëtanëk “taka”) yeru, do hn'itaka tac mbëryëɗëfu cery sali mën ŋa. La icëm iŋa koɗina njaw̃ëna haryënkw hu. ");
INSERT INTO cou_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Njëɗaɗëmi visëɗëta Inaw̃ ambin ŋa: le-wo-le vañëɗu nkal li mbañëɗe ambin hna; le-wo-le w̃aw̃ëryaɗu nkal li maw̃ëryaɗe ambin hna.» ");
INSERT INTO cou_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tac Yesu më ŋañënahnëkëhni vërëfal vëlëw̃u va antë pëƴaniha ahnë umë ye Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tëk pëgw wati rac, Yesu pëgwëlehn nësëhnëndëhni wapacëk vërëfal vëlëw̃u va ntehnënd: «Afo yiwu gë Yerusalem. Hnam, vicër va gë vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va korotehnëɗëniho ɗus hafo ndaw̃ehnëniho do, fac rarëna hna, mbëhnëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Awa Piyer më canaryëka do pëgwëlehna niranda: «Hali, Ahwëhn, W̃ënu ŋa keryëɗëhi! Watac geɗilihna muk!» ");
INSERT INTO cou_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ɓare Yesu më cahëtak do ntehna Piyer: «Ŋaw̃ëtarye, Sintani! Memaỹenduho! Nahaɗila had W̃ënu ŋa ɓare had vahnë.» ");
INSERT INTO cou_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tac Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Ge ahnë ñaɗ tëfëlehnëndo, ntë nko nahand soŋe lëw̃u dënk, afo ndiɓ kërëwa lëw̃u ỹa tëfatëndo. ");
INSERT INTO cou_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ale ỹaɗ ỹi ɗuniỹa ỹi cëmëɗ, ɓare ale wok kwëtahnëna nëf ỹi ɗuniỹa, soŋe lëmën ỹa, nkoryaryëɗ ntaw̃ary dëw̃u ŋa hafo araƴen hna. ");
INSERT INTO cou_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ye hnëfaɗëha ahnë ge nuỹak ɗuniỹa ỹi fop tac cëvehn ntaw̃ary dëw̃u ŋa? Ye koɗ njëɗahn mbësahni ntaw̃ary dëw̃u ŋa? ");
INSERT INTO cou_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ha ntehnëɗëmu, Ajë Ahn'a njijëɗ gë wamëleka wadëw̃u ŋa hnë icëmb Rëmu hna. Awa ale-wo-le ile ntiɗëho ỹa mbësaɗe. ");
INSERT INTO cou_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Toña ỹa fëƴaɗëmu: Vëryampo hnë vële ye hnani vi vësëmëɗina hara vëhnulahna Ajë Ahn'a ga njijëɗ had ahnaw̃.» ");
INSERT INTO cou_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ga ndëcëk wafac mbëɗ gë ryaw̃, Yesu më njokëhni vëhni Piyer gë Sak gë San, aheryu Sak, do njiryeryëhni hn'ikuŋ ƴihnah le nkeniho vëhni fo. ");
INSERT INTO cou_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hnam Yesu më mbacik tase lëw̃ hni; yëka lëw̃u ỹa pëtëɗëho had ulav do viỹi vilëw̃u va njerëko had humpen. ");
INSERT INTO cou_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taŋ vërëfal vërar va nulehnënihëhni vëhni Moyis gë Eli ga nësëlëɗëni gë Yesu. ");
INSERT INTO cou_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Awa Piyer më ntehnëka Yesu: «Ahwëhn, njivëk nkeyin hnani. Ge ñaɗu, ntiɗëfu wasank watar: ryampo wëjë, Moyis ryampo, Eli ryampo.» ");
INSERT INTO cou_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nkoko nësënd tëket aŋar ntancah cankëhni, do kopa wëryiko ŋar hna: «Aỹi Ajë mën ye ale ỹahnëɓu ɗus; g'umë natëɗëho. Umë rëfëka ahnëpawu!» ");
INSERT INTO cou_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Vërëfal va ga nkwëryëni kopa rac, ntakëkëhniwo ɗus ndëkwëhnëlehnëni wayëka w̃a nkal li. ");
INSERT INTO cou_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Awa Yesu më tëhakëhni, ñakëhni do ntehnëhni: «Matëryin! Antë ntaku.» ");
INSERT INTO cou_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Awa më matëndani ɓare vëhnulawohna ahnë ge gena Yesu fo. ");
INSERT INTO cou_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ante cëliɗëniho kuŋ ŋa Yesu më ntehnëkëhni: «Nt'afëƴawuna ahnë ile hnurun ỹi hafo Ajë Ahn'a mbëhni vësëm hna.» ");
INSERT INTO cou_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tac vërëfal va më tëƴëniha Yesu: «Soŋe ye ntehnëɗëni vëharaŋ sariya vi, afo Eli njij ten?» ");
INSERT INTO cou_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Umë ntëkwakëhni: «Afo Eli njij ten soŋe mbokary caŋ fop. ");
INSERT INTO cou_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ɓare ami pëƴaɗëmu: Eli tëko njij, ɓare vahnë va vëyavëtëlawohna. Awa umë ntiniha gante ñaɗëni ka. Koyëna korotehnëɗëniha vahnë vërac Ajë Ahn'a fëna.» ");
INSERT INTO cou_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Awa vërëfal va njëtëlehnëni soŋe San Ayary a nësëndëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ante tëkëniho hn'ile nkeni kore hna, asan rëhakawo Yesu ndëkwëhn haryënkw lëw̃u ");
INSERT INTO cou_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","do ntehna: «Aharaŋ, kaỹëhnanëryiỹi g'ajë mën aỹi. Haƴo fëlaka do njoɗ kwëlëkwël hnë hwëɗëh ma hnë w̃ënka. ");
INSERT INTO cou_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Njiryeryëɓuha vërëfal hu hna ɓare vëw̃ëkëna njërënëniha.» ");
INSERT INTO cou_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu më ntëkwak: «W̃uhnë, vahnë vëhwëhn kwëtahn këm do vërumpak yerun! Hafo guve tëfëko nko ñëw̃ëlahnin gë w̃uhnë? Afo guve tëfëko voku ryuñënanëhnu? Ƴinenëhninow̃a fatah fi ani.» ");
INSERT INTO cou_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Më njojëniha. Awa Yesu më ŋañënahnëka ƴine ỹa do ƴine rac cahnëlehna fatah fa, do fatah fa njërëlehn taŋ. ");
INSERT INTO cou_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tac vërëfal va, më cahëtaryëniha Yesu do tëƴëniha: «Soŋe ye woɓun mëkëlëfunahna lafuna iỹi ƴine?» ");
INSERT INTO cou_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu më ntëkwakëhni: «Kaɓi ikwëtahn hun iŋa mbak ɗus. Toña ỹa fëƴaɗëmu: ge lakënde ikwëtahn inte vak had uỹëc mutarëd fo hwëhnakëndun, ntehnakëndun iŋi kuŋ: “Pakëtary aỹi hnani”, do pakëtakënd. Ñoñ tesakëndiluhna.  ");
INSERT INTO cou_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɓare g'imunta do g'icuŋ fo koɗe ntayi ỹi sifa ƴine.» ");
INSERT INTO cou_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Fac ryampo, ante nkeniho vërëfal va fop Galile hna gë Yesu, më ntehnëkëhni: «Ajë Ahn'a njëɗahnëɗëniha vahnë va. ");
INSERT INTO cou_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Vërac ndaw̃ehnëɗëniha; ɓare, fac rarëna hna, mbëhnëɗ.» Vërëfal va, ga nkwëryëni watac, pëɓëlehnëni yiwëhnah sankaf. ");
INSERT INTO cou_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ante tëkëniho Yesu gë vërëfal vëlëw̃u Kaperënaỹum ŋa, vële rebaɗëho ỹatëtanke Cery W̃ën Cankaf va tëhanihawo Piyer do ntehnëniha: «Aharaŋ hun aỹi cosahnëɗina bi ỹatëtanke Cery W̃ën Cankaf hna?» ");
INSERT INTO cou_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer më ntëkwak: «Cosahnëɗ». Wati nte tënkëɗëho Piyer tere ŋa, Yesu ryënkwëko teɓa wanës ŋa ntehn: «Ye hnaharu, Simo? Mo rëfëka cosëhni vëhnaw̃ vëvë ɗuniỹa vi ỹatëtanke ỹa? Vëvë watere wadëw̃ hni va bi ma vëỹëntaw̃ va ye?» ");
INSERT INTO cou_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer më ntëkwak: «Vëỹëntaw̃ va ye.» Yesu më ntehnëka: «Awa vëvë watere vëhnaw̃ va vësosahnëɗina. ");
INSERT INTO cou_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɓare, ñaɗilëfuhna lavëndanëfuni vahnë va. Awa, ƴiryeyi lant hna, aloŋ ɗoli ỹa, igis ɗënkwëryënkw nte fëlaɗu ŋa ƴavëndëryehna w̃ës ỹa: tëkatëɗu uỹëc koryi le yeɗ gwër cosahnahni ỹatëtanke mën ỹa gë lëw̃ hu per; ƴoj asosahn.» ");
INSERT INTO cou_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wati rac, vërëfal va tëhanihawo Yesu tëƴëniha: «Mo lëbëkëhni nafa vëỹëntaw̃ va Naw̃ ambin hna?» ");
INSERT INTO cou_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu më macëka fatah fatoƴ, kwëta fagant lëw̃ hni ");
INSERT INTO cou_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","do ntehn: «Toña ỹa fëƴaɗëmu: ge gwëcëtaluhna ayewu had vutah, tënkëɗiluhna muk Naw̃ ambin hna. ");
INSERT INTO cou_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ale ỹak njaɓëk nafa Naw̃ ambin hna umë ye ale vanaɗ soŋe nke had faŋi fatah. ");
INSERT INTO cou_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ale hacaka la fatah fëndampo gë faŋi ki soŋe lëmën ỹa, kacako ami dënk.» ");
INSERT INTO cou_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesu më mbok ntehnëk: «Age ahnë ravëtehnëka ikwëtahn iŋa wëla fatoƴ fëndampo hnë vunte hwëtahnëko vi, pecek soŋe lëw̃u ỹa ñabi bëraka do ntoŋi hnë igu lant. ");
INSERT INTO cou_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Meka ỹi ɗuniỹa le ravëtehnëɗëhëhni vahnë ikwëtahn iŋa! Nkeɗ kwëlëkwël vile rëkëɗ tavëtehnëndëhni ikwëtahn iŋa, ɓare ale lik watac ỹa w̃eh sankaf hnapëɗëha! ");
INSERT INTO cou_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Awa ge vák hu ma fary hu ravëtendëhi ikwëtahn iŋa, dëpëtary; pecek arënk ɗuniỹa le wok puɗina hna gë vák ryampo ma gë fary ryampo g'ile woryaryëru waki tak do alabi gë janáma, hnë hwëɗëh hunte wok ɗipëɗina muk. ");
INSERT INTO cou_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Do ge inkër hu ŋa ravëtendëhi ikwëtahn iŋa, dokëtary; pecek arënk ɗuniỹa le wok puɗina hna g'inkër ɗampo g'ile woryaryëru viki tak do alabi gë janáma.» ");
INSERT INTO cou_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu më mbok ntehn: «Keharyin ayafaŋuna la fëndampo hnë vuŋi vutoƴ; ha, paryi pëƴaɗëmu, wamëleka waɗëw̃ hni ŋa haryënkw Rëm mën le ye g'ambin hna nkeni kwëlëkwël.  ");
INSERT INTO cou_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ƴëtëryin, Ajë Ahn'a njijëk pehëtëhni vële sëvëko va. ");
INSERT INTO cou_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ye hnahaɗun hnë waŋi: ahnë kwëhnakëhni wape keme do ryampo hnë watac cëvat. Tavëɗilëhnihna bi wañëntaw̃ w̃a fop le keryëɗëhëhni hna njihahn njëkëlehna ile sëvëk ỹa? ");
INSERT INTO cou_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ge nujëka, paryi pëƴaɗëmu natëɗëha g'ife rac ntëbini wafëhw imbëɗ gë wahnah g'imbëɗ gë wahnah (99) wañëntaw̃ wante woko wasëvëna w̃a. ");
INSERT INTO cou_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ndampo fo nke, Rëmun le ye g'ambin ỹi ñaɗina la fëndampo hnë vuŋi cëv.» ");
INSERT INTO cou_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu më mbok ntehnëk: «Ge aỹënta hu ntëntahnëki, macëryehna ayewu w̃uhnë vëhi fo afëƴahna ile ntiki ỹa. Ge nëpaki, pehëtëruha aỹënta hu. ");
INSERT INTO cou_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɓare, ge ŋwëỹëk nëpaɗilihna, ƴoryehna ahnë aryampo ma vëhi alihahn gante nësëk Vikerëh ka: “Gë vahnë vëhi ma vërar kitiŋëɗe le yelëku ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ge ŋwëỹëk nëpaɗilëhnihna vëhni fëna, pëƴahnëry mbara vële hwëtahnëka va; do ge ŋwëỹëk nëpaɗina mbara tac, pëlaryina had arëf ỹatëtanke do gë vahnë vëhaw̃ary vële wok vëhwëtahnëna. ");
INSERT INTO cou_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Toña ỹa fëƴaɗëmu: le-wo-le vañëɗun nkal li mbañëɗe ambin hna; le-wo-le w̃aw̃ëryaɗun nkal li maw̃ëryaɗe ambin hna. ");
INSERT INTO cou_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Pëƴaɗëmu fëna, ge vëhi hnë w̃uhnë nkal li maw̃alëni tëƴëni le-wo-le ỹa hn'imunta, Rëm mën le ye g'ambin ỹi ntinëhnëɗëhëhni. ");
INSERT INTO cou_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paryi nke, hn'ile mbarëni vahnë vëhi ma vërar soŋe w̃ac mën, fagant lëw̃ hni nkeɗëfu.» ");
INSERT INTO cou_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Awa Piyer më tëhaka Yesu do tëƴa: «Ahwëhn, wahwënta wayëhw rëfëka ravëhnëw̃a aỹënta mën a ge tavëɗina dëntahn mën iŋa? Hafo wahwënta mbëɗ gë wahi bi?» ");
INSERT INTO cou_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ntëkwakawo: «Hali, dehnëɗila hafo wahwënta mbëɗ gë wahi, ɓare hafo ntëbi dënk wahwënta wafëhw mbëɗ gë wahi wahwënta mbëɗ gë wahi (70×7) ");
INSERT INTO cou_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Awa, wëli uhnës uryindaryindan soŋe Inaw̃ ambin ŋa: Fac ryampo ahnaw̃ fëhnako tëƴëhni vëryokuŋ vëlëw̃u va koryi le navehnëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Umë ndënkwëk tëƴëka asan ale wonanëkawo koryi yaɓah ɗus. ");
INSERT INTO cou_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Asan arac kwëhnalohna ile mbësahnand koryi rac; awa ahnaw̃ a më ntehnëk nkwafini g'asëvalu gë vutahu do g'ile kwëhnak ỹa fop, cosahnahn koyëna nav iŋa. ");
INSERT INTO cou_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Awa asan a më ndëkwëhnëk haryënkw ahnaw̃ a, këlahna do ntehna: “Ɗuñënanëhnërye, cosëɗëmi fop!” ");
INSERT INTO cou_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ahnaw̃ a më kaỹëhnahnëka: më tavëhnëka nav iŋa do tava nji. ");
INSERT INTO cou_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ɓare ga cahnëk asan arac, pankëlëlehnëni ale ndokuŋëlahnëɗëniho do wonanëkawo koryi toƴe. Paco pëlaka nahëka do ntehna: “Cosërye le wonanëruho ỹa!” ");
INSERT INTO cou_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Ale ndokuŋëlandëni ỹa më njok haryënkw lëw̃u do këlahna aki: “Ɗuñënanëhnërye, cosëɗëmi!” ");
INSERT INTO cou_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Ɓare aỹëntaw̃ a më ŋwëỹëk; më cëɗehnëka hafo mbësahna nav iŋa. ");
INSERT INTO cou_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vëryokuŋ vëỹëntaw̃ va, ga nuni ile ryëcëtak ỹa, njiw̃ëhnahnëkëhniwo ɗus më njini pëƴaniha ahnaw̃ a fop. ");
INSERT INTO cou_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Awa arac më macehnëka asan a do ntehna: “Wëjë! Aryokuŋ ayapah yeru! Tavëhnëmi nav iŋa fop kaɓi këlaruho ravëhni. ");
INSERT INTO cou_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tëfakilahna bi, wëjë fëna, kaỹëhnahnina aryokuŋënta hu ỹi, gante kaỹëhnahnëko gë wëjë ki?” ");
INSERT INTO cou_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ahnaw̃ a ntavëkawo ɗus awa më njëɗahnëka aryokuŋ a ntind ɗoku forosima hafo cosa nav iŋa fop.» ");
INSERT INTO cou_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Do Yesu më nkwënëk: «Koyëna ntiɗëha Rëm mën le ye g'ambin ỹi ale-wo-le wok tavëndilahna aỹëntaw̃u ỹa g'intaw̃ary fop.» ");
INSERT INTO cou_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ga puhnak Yesu wante nësëɗëho ŋa, më matëk Galile hna nji cape ndampo mbë Yuɗe nte yeho gë cape ñëntaw̃ sën Yurëdan ŋa. ");
INSERT INTO cou_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kore sankaf rëfëlendëhawo do njërënëɗëhëhniwo vëres vëlëw̃ hni va. ");
INSERT INTO cou_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Awa wafarise wëryampo më tëhaniha, më tëƴëniha soŋe tëndëhnëniha urënd: «Sariya fu ỹa maw̃ëryanëka bi asan mbamba asëvalu soŋe toña le-wo-le ỹa?» ");
INSERT INTO cou_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Më ntëkwak: «Ƴëtëluhna bi ile nësëk Vikerëh ỹa? “Wapëgwa hna, ale lik fop ỹa ntikëhni asan g'asëval”, ");
INSERT INTO cou_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","tac më ntehnëk: “Soŋe umë ye asan a tavëɗëhëhni rëmu gë hnëmu nkeni g'asëvalu fo, do vëhni vëhi tak aryampo fo nkeɗëni.” ");
INSERT INTO cou_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Koyëna, vëwona vëhi ɓare ahnë aryampo fo ye. Awa ahnë antë pitëndëlehn ile mbarëpëlehnëk W̃ën.» ");
INSERT INTO cou_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wafarise w̃a më tëƴëniha: «Awa soŋe ye ntehnëk Moyis sariya hna, ge asan a mbambëka asëvalu ỹa, kerëhna kayëte nte rufahnëɗ mbambëka?» ");
INSERT INTO cou_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu më ntëkwak: «Moyis maw̃ëryanëku avambënduni vësëval hun kaɓi vankaf va kambëku. Ɓare wapëgwa hna gelohna koyëna. ");
INSERT INTO cou_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pëƴaɗëmu: ge asan mbambëka hara pëlalentëhnihna g'asan ahaw̃ary, do ñëla asëval ahaw̃ary, asan arac ntik le mbañëk W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vërëfal vëlëw̃u va më ntehnëniha: «Ge aki nke yëbëlan asan g'asëval, ant'avëra aỹël fecek.» ");
INSERT INTO cou_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu më ntëkwakëhni: «Vësan va fop vëw̃ëkëɗina maw̃ëni waŋi wanës, vële njëɗaɗ W̃ën fere va fo w̃ëkëɗ. ");
INSERT INTO cou_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vëỹi viyaɓah w̃emaỹendëhëhni vësan va ñëlëni: soŋe vëryampo, koɓëri nte nagini ŋa nke; vëhaw̃ary, vëhni vahnë va likëhni; do vëryampo ŋwëỹëɗëni soŋe ntihahnëndëni ɗoku Inaw̃ ambin ŋa ye. Araɓi ale hoɗ maw̃ iŋi karaŋ maw̃!» ");
INSERT INTO cou_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Fac ryampo vahnë yinenëhnikawo Yesu vutah soŋe tindëhni wëɓák ŋa do ndëwahni, ɓare vërëfal va niranihëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Awa Yesu më ntehnëk: «Tavëryinëhni vutah va njijëni ỹal mën hna, nt'aw̃emaỹehnuni! Vële ye had vëhni va hwëhnëk Naw̃ ambin ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Awa më tindëkëhni wëɓák ŋa tac njilehn. ");
INSERT INTO cou_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Awa jar rëhakawo Yesu do tëƴa: «Aharaŋ, ye rëfëko liwu fërën rënkahnu uwám usër hna?» ");
INSERT INTO cou_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu më ntëkwaka: «Ye rëƴëɗuho soŋe ile fërënak? Ahnë aryampo fo ye afërën a. Ge ñaɗu arënk uwám usër hna maw̃ëhnëry vakwëɗa W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jar ŋa më tëƴëk: «Vaŋëhne?» Yesu më ntëkwaka: «Nt'aryaw̃a ahnë; nt'ayëkëlehna asëval ahaw̃ary; nt'ale; nt'aye seɗe wamër; ");
INSERT INTO cou_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","dënënëryihni vëhni rëmuh gë hnëmuh; ŋahnëryehna aỹënta hu ỹa had wëjë dënk.» ");
INSERT INTO cou_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jar ŋa më ntehnëka: «Maw̃ëhnëɓu vaŋi vakwëɗa fop. Ye rëfëko voku liwu kat?» ");
INSERT INTO cou_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu më ntehnëka: «Ge ñaɗu aye afadah haryënkw W̃ën hna, ƴiry awaf ile hwëhnaru ỹa do ayëɗahni koryi ỹa vëhaỹëhnah va; koyëna nuỹaɗu hnapul yaɓah ambin hna. Tac ƴij arëfëlehnëndo.» ");
INSERT INTO cou_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɓare jar ŋa, ga nkwëryëk watac, njiko ayamah fo kaɓi hnapul yaɓah kwëhnako. ");
INSERT INTO cou_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Awa Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Toña ỹa fëƴaɗëmu: ntakëk avetak tënk Naw̃ Ambin hna. ");
INSERT INTO cou_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ha, paryi pëƴaɗëmu: itënk yonkomb hnë hatëh sirehn ỹak hnëŋëk g'itënk avetak Inaw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Vërëfal va, ga nkwëryëni waŋi wanës, pëmpëhnahnëkëhniwo ɗus më ntehnëɗëni: «Mo ye awa ale hoɗe pehëti ỹa?» ");
INSERT INTO cou_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu më njëkëkëhni do ntehnëhni: «Vahnë va vëhoɗina pehëtahni, ɓare W̃ënu ŋa koɗ nti fop.» ");
INSERT INTO cou_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Awa Piyer më ntehnëka: «Nëpary, fuhnë tavëɓun fop soŋe arëfëlehnahnënde. Awa ye hnuỹaɗëfun, fuhnë?» ");
INSERT INTO cou_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu më ntehnëkëhni: «Toña ỹa fëƴaɗëmu: ge Ajë Ahn'a ntañak hnë tinki sëmbik lëw̃u hna ɗuniỹa hasëk hna, w̃uhnë pëhw gë vëhi vële rëfëlehnikow̃o vi fëna, ntañaɗun hnë watinki vësankaf soŋe ahitiŋuni wahnënk pëhw gë wahi wavë Isërayel w̃i. ");
INSERT INTO cou_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Do fop vële ravëɗ soŋe mën watere wadëw̃ hni ma vicër hni, vëhery hni, warëm hni, wahnëm hni, vërah hni, wëhaỹ walëw̃ hni, nuỹaɗëni ntëbi wahwënta keme do nuỹaɗëni sah ɗuniỹa le wok puɗina ỹa. ");
INSERT INTO cou_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɓare vëyaɓah hnë vële ye gaki vëryënkwëryënkw vi, vërëkwa yeɗ do vëyaɓah hnë vële ye gaki vërëkwa vi vëryënkwëryënkw yeɗ.» ");
INSERT INTO cou_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu më mbok ntehnëk: «Awa, wëli ile mëntëndëlendeni Naw̃ ambin ŋa: Fac ryampo, ahwëhn kaỹ a sahnëko koɓëri fo g'acahnëfëɗ ga soŋe njëkëlehnahni vëryokuŋ kaỹ waresen lëw̃u. ");
INSERT INTO cou_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Umë maw̃alëni gë vëryokuŋ va cosëhni soŋe ɗoku fac ryampo, tac cañëtëlehnëhni njini ndokuŋini kaỹ a. ");
INSERT INTO cou_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Hnë wëwati mbëɗ gë wahnah hna, më mbok cahnëk do mbok nuhni vëhaw̃ary ỹëw̃a hna hara ñoñ vëliɗilohna. ");
INSERT INTO cou_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Më ntehnëkëhni: “Ƴiryin w̃uhnë fëna aryokuŋëntiwu kaỹ mën hna do cosëɗëmu icos caŋah.” ");
INSERT INTO cou_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Njilehnëni. «Më mbok cahnëk kat lav a nkaf hna, tac hnë wëwati warar g'anent hna, do mbok nti koyëna fo. ");
INSERT INTO cou_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hnë wëwati mbëɗ g'anëka hna kat më mbok cahnëk do mbok tëkatëhni vahnë vëhaw̃ary kat ga ñëŋëwëni ỹëw̃a hna. Më tëƴëkëhni: “Soŋe ye ỹëw̃ëɗun hnani fac ỹa fop ñoñ ɗokuŋëɗiluhna?” ");
INSERT INTO cou_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Më ntëkwaniha: “Kaɓi ahnë nufëlëfuhna ryokuŋëhnëfuna.” «Më ntehnëkëhni: “Awa ƴiryin w̃uhnë fëna aryokuŋëntijiwu kaỹ mën hna.” ");
INSERT INTO cou_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«G'anëka ga, ahwëhn kaỹ iŋa më ntehnëka asankaf vëryokuŋ vëlëw̃u va: “Macëryihni vële ryokuŋëhnëko vi asosëhni. Vële rëkwahnik vi ryënkwëhnahnëɗu do tëkwahnëni vëryënkwëryënkw vi.” ");
INSERT INTO cou_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Vële fëgwëko ɗoku hnë wëwati mbëɗ g'anëka ga më njijëni cosini ale-wo-le soŋe ɗoku fac ỹa. ");
INSERT INTO cou_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ga tëkëk icos vële ryënkwëko nufini ɗoku va, ntiyahnëkëhniwo cosëɗeni ntëbini vërëkwa vi; ɓare vëhni fëna ale-wo-le soŋe ɗoku fac ỹa fo cosiko. ");
INSERT INTO cou_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ga teɓani, mëhnaɗëniho ");
INSERT INTO cou_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ntehnëndëni: “Vëỹi vëryokuŋ rëkwahnik. Soŋe wati ryampo fo ndokuŋëni; asosaryëlehnëhni gante cosëruhëfu, fuhnë vële ryuñënak ambër hn'ulav fac ỹa fop ka!” ");
INSERT INTO cou_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Ɓare ahwëhn kaỹ iŋa më ntëkwaka aryampo hnë vëhni: “Lawo, ñoñ dëntantihna. Maw̃alakena bi sosi soŋe ɗoku fac ỹa? ");
INSERT INTO cou_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nufëry cos hu ŋa do ayi. Ami nëŋëk sosëwëhni vële rëkwahnik vi gante cosëmi ki. ");
INSERT INTO cou_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Koɗa bi liwu gante ñaɗëfu ka hnapul mën ỹa? Ma kaɓi kwëhnaɓu anëf soŋe rac bi ỹew̃aryëruho?”» ");
INSERT INTO cou_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Do Yesu më nkwënëk: «Koyëna vërëkwa vi yeɗ vëryënkwëryënkw, do vëryënkwëryënkw vi yeɗ vërëkwa va.» ");
INSERT INTO cou_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Yerusalem njiɗëho. Më canaryëkëhniwo vërëfal pëhw gë vëhi va do ntehnëhni njasatëndëni: ");
INSERT INTO cou_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Nëparyin, gë Yerusalem njiɗen, Ajë Ahn'a njëɗaɗeniha vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va do vëhni nkwëryëlëɗëni soŋe ndaw̃ehnëniha ");
INSERT INTO cou_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","do njëɗaɗeniha vële wok vëyena wasëwif. Vërac njafaŋëɗëniha, ntampëɗëniha tac pakëɗëniha hnë kërëwa. Do hnë fac rarëna hna, mbëhnëɗ vësëm hna.» ");
INSERT INTO cou_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Awa asëvalu Sebede gë viju vëhi va tëhanihawo Yesu; asëval a më ndëkwëhnëk soŋe tëƴa Yesu ndemahna. ");
INSERT INTO cou_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu më tëƴëka: «Ye ỹaɗu?» Më ntëkwaka: «Maw̃ëryanëryihni vijë mën vëhi vi ntañani naw̃ ucankaf hu hna aryampo g'irëhw hu, aỹëntaw̃ a g'irahahn hu.» ");
INSERT INTO cou_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu më ntehnëkëhni: «Ƴëtëluhna ile rëƴëɗun ỹa. Koɗun bi asewu ankëlëw̃a tëmpah horot nte ỹaɗëfu sew̃u ŋa?» Më ntëkwaniha: «Koɗëfun.» ");
INSERT INTO cou_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu më ntehnëkëhni: «Ha, ceɗun nkëlëw̃a mën ŋa. Ɓare gena ami fëhnaɗ soŋe ale lañaɗ g'irëhw mën ma g'irahahn mën, Rëm mën ỹa fëhnaɗ. Vële pëhwëtëhnëk va njëɗaɗ.» ");
INSERT INTO cou_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vërëfal pëhw vëỹëntaw̃ va, ga nkwëryëni watac, ntavëkëhniwo gë viju Sebede vëhi vërac. ");
INSERT INTO cou_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Awa Yesu më macëkëhni vëhni fop do ntehnëhni: «Njëtërun vële ye vësankaf ɗuniỹa vi nɗëcëtëni ucankaf ntëw̃ hni ŋa, do vëryëndah va tufahnëɗëni fanka falëw̃ hni fa. ");
INSERT INTO cou_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ɓare tëfëlahna nke koyëna yëbëlan hun. Ale-wo-le ỹaɗ naỹ hnë w̃uhnë ỹa, tëfëka nke aryokuŋëhn hun, ");
INSERT INTO cou_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","do ale-wo-le ỹaɗ nke aryënkwëryënkw a, tëfëka nke aramp hun. ");
INSERT INTO cou_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndampo fo nke soŋe Ajë Ahn'a: ƴijëna soŋe ndokuŋëhni, ɓare had aryokuŋëhn vahnë njijëk do njëɗahn ntaw̃ary dëw̃u ŋa pehëtahnëhni vahnë vëyaɓah.» ");
INSERT INTO cou_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu, ante cahnëɗëniho gë vërëfal vëlëw̃u Seriko ŋa, kore sankaf rëfëlehnëɗëhawo. ");
INSERT INTO cou_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Vumëp vuki lañako tëfary nkaw̃ hna, më nkwëryëni Yesu ryëcëɗ. Awa pëgwëlehnëni ndekandëni: «Aharaŋ, Aju David, kaỹëhnahnëryiỹi gë fuhnë!» ");
INSERT INTO cou_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kore ỹa niraɗënihëhniwo ndemëhnani, ɓare tac nkwënëniho waɗeka ŋa: «Aharaŋ, Aju David, kaỹëhnahnëryiỹi gë fuhnë!» ");
INSERT INTO cou_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu më kahnëk, macëkëhni do tëƴëhni: «Ye ỹaɗun linëhnu?» ");
INSERT INTO cou_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Më ntëkwaniha: «Aharaŋ, hnundëfu ỹaɗëfun.» ");
INSERT INTO cou_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Më kaỹëhnahnëka gë vëhni do më ñakëkëhni vinkër va; taŋ mbokalehn nundëni, do tëfëlehnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ante tëhaniho Yesu gë vërëfal vëlëw̃u Yerusalem ŋa, tëkëniho ankol Betëfase hna, hn'ikuŋ nte w̃acik Oliviye. Awa më paƴëkëhni vërëfal vëhi haryënkw ntehnëhni: ");
INSERT INTO cou_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Ƴiryin hn'ankol nte ye haryënkw hun ŋi. Tëkatëlehnëɗunëha fali fasëval ga pokik, do fatah fantëw̃u fa g'umë nkeɗëni. Pëtinëhni ayonëhniwunow̃ëhni. ");
INSERT INTO cou_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ge ahnë ntehnëku iñë dëkwaryina: “Ahwëhn a valëka.” Tavëɗerun ayojuni.» ");
INSERT INTO cou_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Umë nkeɗ padahn wanës wante nësëko kila ŋa: ");
INSERT INTO cou_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Dehnëryinëhni naw̃ Siỹo ŋa: Ƴëkëryina ahnaw̃ hun a gë ỹal hun njijëɗ hara naỹënajëɗina, hnë fali fasëval kaƴik, hnë fapali.» ");
INSERT INTO cou_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Awa vërëfal va njiniho do ntini fop ile ntehnëkëhniwo Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Umë njojëniha fali fa gë fapali fa, tindënihëhni vacuɗ vantëw̃ hni va, tac Yesu kaƴa. ");
INSERT INTO cou_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Vahnë vëyaɓah ntanëɗëniho vacuɗ vantëw̃ hni va nkaw̃ hna njitënd; vëryampo warund ntanëɗëni nkaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Vële ryënkwaryëkawo do vële rëfëɗëhawo va ndekaɗëniho: «Osana! Aju David, ɗemaryifu! Araɓi Ahwëhn a W̃ënu ŋa njëɗa ale yijëɗ g'uw̃ac lëw̃u w̃a! Cëmbëɗeru W̃ën hunte sëpëk fop!» ");
INSERT INTO cou_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ga tënkëk Yerusalem hna, ɓulunda ỹa fop ñënkaniho. Tëƴëɗëniho: «Mo ga ye aỹi asan?» ");
INSERT INTO cou_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vële rëfëɗëhawo Yesu va më ntëkwani: «Kila le w̃acik Yesu ỹa ye vë nkol mbë Nasaret, mbë resiỹo Galile hna.» ");
INSERT INTO cou_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu tënkëko selele Cery W̃ën Cankaf hna do ntahni fop vële wafëɗëho do law̃ëɗëho hnam va; këfëko wataɓali vëwëcët koryi do gë watinki vëwaf wëfah va. ");
INSERT INTO cou_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tac më ntehnëkëhni: «Vikerëh W̃ën va më lehnëk: “Acery mën ŋa, Cery iƴëfa macëɗe”, ɓare w̃uhnë sow̃a vële lirun!» ");
INSERT INTO cou_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wati rac, vumëp gë vële raɗëɗ rëhakawo Yesu Cery hna do njërënëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va, ga nuni viỹë vifëmpëhnahnah vile ntiko Yesu va, do ga nunihëhniwo fëna vutah va ndekaɗëniho Cery W̃ën hna: «Osana, cëmbiru Aju David!» më ntavëkëhni ɗus. ");
INSERT INTO cou_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Awa më ntehnëniha Yesu: «Nkwëryëɗu bi ile nësëɗëni ỹa?» Më ntëkwakëhni: «Ha. Koɓëri karaŋëluhna bi waŋi wanës Vikerëh hna: «“Ntiru hafo la vutah vutoƴ va gë vumbava va cëmbëndënihi.”» ");
INSERT INTO cou_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tac Yesu tavëlehnëhni cahn nkol hna nji Betani le ndakëko hna. ");
INSERT INTO cou_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Awa, ga pacëk g'acahnëfëɗ ga, hara Yesu gë Inaw̃ mbokajëɗëho, më njoka inte. ");
INSERT INTO cou_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Më nuk atëh nte w̃acik nuỹ tëfary nkaw̃ hna; më tëhak ɓare yaryef fo tëkatëko. Awa më ntehnëka tëh ŋa: «Ɓokëɗila alëw̃ muk!» Taŋ tëh ŋa kankëlehn fop. ");
INSERT INTO cou_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vërëfal Yesu va, ga nuni watac, pëmpëhnahnëkëhniwo. Më tëƴëniha: «Hak kankahnëk aŋ'atëh taŋ aki?» ");
INSERT INTO cou_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Më ntëkwakëhni: «Toña ỹa fëƴaɗëmu: ge kwëhnarun kwëtahn do ge gwajëlehnaɗiluhna, koɗun aliwu ile liɓuha atëh ŋi. Koɗun dënk alehnuna iŋi kuŋ: “Matëry ani, ayi alëba wov hna”, do rac ntiyaɗ. ");
INSERT INTO cou_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ge kwëhnarun kwëtahn iŋa nuỹaɗun le-wo-le rëƴërun hn'iƴëfa hna.» ");
INSERT INTO cou_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tac Yesu tënkëko selele Cery W̃ën Cankaf hna pëgwëlehn karaŋëndëhni vahnë va; vësankaf vësëna wasaɗëha va gë vicër ɓulunda wasëwif va më tëhaniha tëƴëniha: «Gë iŋëhne fanka ntiɗu vëỹin? Mo lehnëki alind?» ");
INSERT INTO cou_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Më ntëkwakëhni: «Ami fëna tëƴëɗëmu iñë ryampo. Dëkwaryino, tac, pëƴaɗëmu fanka fale lihahnëɗëfu vëỹin va. ");
INSERT INTO cou_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mo faƴikawo San njaryënd? W̃ënu ŋa bi ma vahnë va yeho?» Pëgwëniho nkwajëlëɗëni vëhni fo ntehnëndëni: «Ge ntëkwayinëk: “W̃ënu ŋa faƴikawo”, tëƴëɗëhëfu bi soŋe ye woyinëk kwëtahnilënahna? ");
INSERT INTO cou_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɓare ge ntehninëk: “Vahnë va faƴikawo”, tëfëka ntakëfu gë kore ỹi, kaɓi vëhni fop kwëtahnëniho San kila yeho.» ");
INSERT INTO cou_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Awa më ntëkwaniha Yesu: «Ƴëtëlëfuhna.» Awa, më ntehnëkëhni: «Pëƴaɗiluhna, ami fëna, gë fanka fale lihahnëɗëfu vëỹin va.» ");
INSERT INTO cou_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu më mbok ntehnëk: «Ye hnaharun gë waŋi? Nkeho asan ale hwëhnakëhniwo vutah vucan vuki. Më tëƴëka fandënkwëryënkw fa ntehna: “Ajë mën, ƴirye dol aryokuŋi kaỹ hna.” ");
INSERT INTO cou_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","«Më ntëkwaka: “Hali, ñaɗa yiwu.” Ɓare, ga mbiỹëk toƴe, nkwëcëtëko nahan dëw̃u ŋa do nji g'ikaỹ. ");
INSERT INTO cou_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Rëm ỹa më mbok tëƴëka koyëna fo aju aỹëntaw̃ a. Arac më ntëkwak: “Awa, apa, njiɗëfu”, ɓare ƴilohna. ");
INSERT INTO cou_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Awa tëƴëɗëmu: Mo lik hnë vëỹi ile ñaɗ rëm hni ỹa?» Më ntëkwaniha: «Aryënkwëryënkw aỹi ye.» Awa Yesu më ntehnëkëhni: «Toña ỹa fëƴaɗëmu: vërëf ỹatëtanke va gë vësëval vële wafëɗ vankaf vantëw̃ hni va vëhni ryënkwëndëhu hnë Inaw̃ W̃ën hna. ");
INSERT INTO cou_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ntehnëɗëmu waŋi kaɓi San Ayary a njijëko tufu nkaw̃ catah ŋa do kwëtahnëlunahna; ɓare vërëf ỹatëtanke va gë vësëval vële wafëɗ vankaf vantëw̃ hni va kwëtahnënihawo. Do la gante nurun watac ka gwëcëtëluhna vankeya hun va ahwëtahnahnuna.» ");
INSERT INTO cou_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu më mbok ntehnëk: «Nëparyin uhnës uryindaryindan haw̃ary: Nkeho asan ale fëlëko kaỹ waresen. Më keceyëk do nkab hatëh ŋwëỹehnahnënde waresen w̃a do pël iɗe nte rëkëɗe njaw̃ahnënde kaỹ iŋa. Tac, më kwëtehnahnëkëhni kaỹ iŋa vëyam njilehn uyas. ");
INSERT INTO cou_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wati nte mbarëpëɗe uhnëɗa ŋa, më paƴëkëhni vëryokuŋ vëlëw̃u va vëyam hna soŋe njëɗaniha sah lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","«Awa vëyam va më pëlanihëhni vëryokuŋ ahwëhn kaỹ va, ndafëniha aryampo, aỹëntaw̃ a ndaw̃ëniha, ararëna ỹa ntutëniha gë wëraka. ");
INSERT INTO cou_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ahwëhn kaỹ iŋa më mbok paƴëkëhni vëhaw̃ary ntëbini vële ryënkwëko njini va, ɓare vëyam va koyëna fo mboko ntinihëhni. ");
INSERT INTO cou_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Awa më paƴëka aju ỹa dënk ntehna: “Kwëhnaɗëni untënah g'ajë mën aỹi!” ");
INSERT INTO cou_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Ɓare vëyam va, ga nuniha ajë ahwëhn kaỹ iŋa, më ntehnëlëni: “Wëliho ale lëw̃ëɗ a! Ƴinëfu, ndaw̃ina, tac kaỹ iŋi fuhnë hwëhnëɗen!” ");
INSERT INTO cou_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Awa umë pëlaniha, canëniha kaỹ hna ndaw̃ëlehnëniha.» ");
INSERT INTO cou_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tac Yesu më tëƴëkëhni: «Ge ahwëhn kaỹ iŋa mbokajëk, hak ntiɗëhëhni vëỹi vëyam?» ");
INSERT INTO cou_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Më ntëkwaniha: «Ndaw̃ehnëɗëhëhni iɗaw̃ meh vëỹi vëyam vëyapah do njëɗahni kaỹ iŋa vëhaw̃ary vële rëkëɗ njëɗandëniha sah lëw̃u ỹa hnë wati le-wo-le mbarëpëɗëni hna.» ");
INSERT INTO cou_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tac Yesu më ntehnëkëhni: «Koɓëri karaŋëluhna bi ile nësëk Vikerëh vi? «“Itaka inte cañëtaniho vëvëry vacery va vacak ye tame inte mbëryahnëk W̃ënu ŋa cery ntëw̃u ŋa fop. Ahwëhn a lik umë do nkwamëk ɗus njëki!”» ");
INSERT INTO cou_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tac më nkwënëk: «Soŋe rac pëƴaɗëmu: Naw̃ W̃ënu ŋa teɓëɗerun, njëɗayini ɓulunda le linëndëha ɗoku fërën.  ");
INSERT INTO cou_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ale-wo-le yoɗ hn'iŋi taka ỹa nihëɗ taŋ; ɓare ge taka ŋi ahnë njohahnëk, ŋwëỹehnëɗëha nke ivëɗ fo.» ");
INSERT INTO cou_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Vësankaf vësëna wasaɗëha va gë wafarise w̃a nkwëryëniho wahnës waɗindaryindan Yesu w̃a do njëtëniho vëhni ntehnëɗ. ");
INSERT INTO cou_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Awa më njëkëlehnaɗëni fere pëlahnëniha, ɓare ntakëkëhniwo gë kore ỹa kaɓi kila ntinihawo. ");
INSERT INTO cou_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu gë wahnës waɗindaryindan mboko nësëhnëndëhni vële hnëpaɗëhawo va ntehnatënd: ");
INSERT INTO cou_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Wëlin ile mëntëlëni Inaw̃ ambin ŋa: Ahnaw̃ Asankaf nëgehnëko roka iñël aju. ");
INSERT INTO cou_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Më ntehnëkëhni vëryokuŋ vëlëw̃u va njini macinihëhni vële faƴehnik roka va, ɓare vëỹaɗilohna njijëni. ");
INSERT INTO cou_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Më mbok paƴëkëhni kat vëryokuŋ vëhaw̃ary njini ntehnënihëhni vële faƴehnik va: “Wëli ile ntehnëk Ahnaw̃ a: ‘Tame roka ỹa puhnayik, vacët mën wuhniryah w̃a ryaw̃ik. Ƴijën roka iñël ỹa. Fop puhnayik!’” ");
INSERT INTO cou_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","«Ɓare vële faƴehniko va vëhnëpalëhniwohna vëfaƴik va; njilehnëni wëɓal wadëw̃ hni, vëryampo kaỹ dëw̃ hni, vëhaw̃ary igwaf dëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Vëỹëntaw̃ va më pëlanihëhni vëryokuŋ Ahnaw̃ a ntinihëhni këm fo do ndaw̃ënihëhni. ");
INSERT INTO cou_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Awa Ahnaw̃ a më ntavëka ɗus; më paƴëkëhni wasoɗaɗe walëw̃u w̃a njini ndaw̃ënihëhni vëỹi vëryaw̃ vahnë do pëɗëni nkol dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tac më ntehnëkëhni vëryokuŋ vëlëw̃u va: “Roka iñël ŋa puhnayik, ɓare vële faƴehnik va tëfëlëhnihna tokëni. ");
INSERT INTO cou_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Awa ƴiryin gë vankaw̃ awaciwuni vële fankëlëɗun va fop njijëni roka ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vëryokuŋ va më njini gë vankaw̃ macinihëhni fop vële pankëlëɗëniho va, vëli w̃eh gë vëli fërën per; koyëna acery nte rokande roka iñël ŋa pëɓëlehnëni vahnë va. ");
INSERT INTO cou_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ahnaw̃ a, ga tënkëk njëkëhni vële yijëk roka va, nuka asan ale wok diyana viỹi ambënt. ");
INSERT INTO cou_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Më tëƴëka: “Lawo, soŋe ye rënkiru ani viỹi ambënt këm?” Ɓare asan a ñoñ koɗilohna ntëkwa. ");
INSERT INTO cou_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Awa Ahnaw̃ a më ntehnëkëhni vëryokuŋ vëlëw̃u va: “Ñabëryina wëɓák ŋi gë wapary ŋi do aloŋuna g'ipër, gë umëhwëry. Hnam rëkëɗ kond do cemëlehnand wabeñ ŋi.”» ");
INSERT INTO cou_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu më nkwënëk: «Vëyaɓah macini, ɓare vëyaɓëna vële rëhnayik va.» ");
INSERT INTO cou_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ga mbiỹëk toƴe wafarise wëryampo njilehnëni mbarëlëni nësëlëni gante ntiɗëni pëlahnëniha Yesu gë wanës wadëw̃u ŋa dënk. ");
INSERT INTO cou_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Më paƴënihëhni vërëfal vëlëw̃ hni vëryampo do gë vëryaw̃ vële nkeniho gë Eroɗ va njini ntehnëniha Yesu: «Aharaŋ, njëtëɓun catëru. Toña ye karaŋëɗuhëhni vahnë va nkaw̃ W̃ënu ŋa; dakëlihna gë le nahaɗëni vëỹëntaw̃ do dëbëndëlehnëɗilihëhnihna vahnë va. ");
INSERT INTO cou_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Awa pëƴaryifu ile hnaharu: sariya fu ỹa maw̃ëryak bi ma maw̃ëryana cosi ỹatëtanke ỹa asankaf a, Sesar?» ");
INSERT INTO cou_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ɓare Yesu njëtëko nahan meh dëw̃ hni ŋa, më ntehnëkëhni: «W̃uhnë, vëroka vahnë, soŋe ye rëndëndunëho urënd? ");
INSERT INTO cou_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tufëryino koryi le sosande ỹatëtanke ỹa.» Më tufëniha uỹëc koryi. ");
INSERT INTO cou_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Më tëƴëkëhni: «Yëka mo g'uw̃ac mo liyik koryi li?» ");
INSERT INTO cou_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Më ntëkwani: «Cesar ye.» Më ntehnëkëhni: «Awa cosëryina Sesar ile kwëhnëk ỹa, do W̃ënu ŋa fëna ile kwëhnëk ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ga nkwëryëni iŋi dëkwa, pëmpëhnahnëlehnëkëhniwo. Tac tavëlehnëniha Yesu njilehnëni. ");
INSERT INTO cou_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hnë fac rac fo, wasaduse wëryampo rëhakawo Yesu. (Vëhni hnësëɗëho vësëm va vëvëhnëɗina.) Më ntehnëniha: ");
INSERT INTO cou_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Aharaŋ, gena bi Moyis nësëko: “Ge asan ỹëlëk, do cëm hara tavëna vutah, aheryu ntëw̃ëɗëha asëval a soŋe nagëhnahna acëru vutah.” ");
INSERT INTO cou_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Awa ỹal fu hna nkeniho vësan mbëɗ gë vëhi vële vankëk rëm gë hnëm. Aryënkwëryënkw a ñëlëko do cëm hara tavëna vutah do tavarya koyëna asëvalu ỹa aheryu. ");
INSERT INTO cou_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ahigëna ỹa fëna koyëna nkehawo, tac ararëna ỹa do gë fop mbëɗ gë vëhi va. ");
INSERT INTO cou_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga puni vëhni fop, asëval a fëna cëmëgëlehn. ");
INSERT INTO cou_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Awa, ge vësëm va mbëhnëni, mo yeɗ asan aỹi asëval hnë vëỹi vësan mbëɗ gë vëhi vi, kaɓi vëhni fop ñëlënihawo?» ");
INSERT INTO cou_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu më ntëkwakëhni: «W̃uhnë mpaỹëmpaỹaɗëhu kaɓi ƴëtëluhna Vikerëh va gë fanka W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ge vësëm va mbëhnëni, vësan va gë vësëval va vëvokëɗina ñëlëlëni, ɓare had wamëleka nkeɗëni ambin hna. ");
INSERT INTO cou_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Koɓëri karaŋëluhna bi, ile ntehnëku W̃ën soŋe iɓëhn vësëm ŋa? Umë lehnëk: ");
INSERT INTO cou_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“W̃ën Abëraham ŋa yeɓu gë W̃ën Isak do gë W̃ën Sakob.”» Yesu më nkwënëk: «W̃ënu ŋa, gena W̃ën vësëm, W̃ën vële wok vësëmëna ye.» ");
INSERT INTO cou_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Vële hnëpaɗëhawo va fop pëmpëhnahnëkëhniwo gë sifa karëŋa nte karaŋëɗëhëhniwo ŋa. ");
INSERT INTO cou_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ante kamahnëniho wafarise w̃a Yesu ndënëkëhni wasaduse w̃a, mbarëniho. ");
INSERT INTO cou_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aharaŋ sariya aryampo hnë vëhni ñaɗëho tëndëhna urënd; awa më tëhaka do tëƴa: ");
INSERT INTO cou_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Aharaŋ, aŋëhne kwëɗa ỹak hnëfak sariya hna fop?» ");
INSERT INTO cou_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu më ntëkwaka: «“Ŋahnëryehna Ahwëhn a W̃ën hu ŋa gë sakahn hu fop, g'intaw̃ary hu ŋa fop, gë hakili hu ỹa fop.” ");
INSERT INTO cou_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aŋi ye ante hnaỹëk do ỹak yaɓëka nafa ŋa. ");
INSERT INTO cou_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Do wëli kigëna ŋa, ante këñëlahnëni gë ndënkwëryënkw ŋa: “Ŋahnëryehna aỹënta hu ỹa had wëjë dënk.” ");
INSERT INTO cou_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sariya Moyis ỹa fop gë wade karaŋëɗënihëhniwo vahnë wakila ŋa fop hnë vaŋi vakwëɗa vaki nke.» ");
INSERT INTO cou_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wafarise w̃a ga mbarëni, Yesu më tëƴëkëhni: ");
INSERT INTO cou_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ye hnaharun soŋe Arëhnayik a? Aju mo ye?» Më ntëkwaniha: «Aju David ye.» ");
INSERT INTO cou_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Më tëƴëkëhni: «Awa soŋe ye David, ante nësehnëkawo Iƴir Ipacah iŋa, macëkawo “Ahwëhn” ntehn: ");
INSERT INTO cou_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«“Ahwëhn a W̃ënu ŋa umë lehnëkawo Ahwëhn mën a: ƴij alaña g'irëhw mën, hafo hale këfëɗëfuhëhni vële ỹew̃ëki va haryënkw hu.” ");
INSERT INTO cou_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ge David “Ahwëhn” macëka, awa hak koɗ Arëhnayik nke aju David?» ");
INSERT INTO cou_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Awa wafarise warac, wëla aryampo hnë vëhni kolëlohna ntëkwahna iñë do, tëk pëgw hnë fac rac, ahnë ɓokëlohna ndëk tëƴa iñë. ");
INSERT INTO cou_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Awa Yesu më ntehnëkëhni kore ỹa fop gë vërëfal vëlëw̃u va: ");
INSERT INTO cou_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Vëharaŋ sariya Moyis va gë wafarise w̃a ye vëyabahn sariya va. ");
INSERT INTO cou_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Awa tëfëka aw̃aw̃ëhnuni do aliwu ile ntehnëɗënihu ỹa fop; ɓare ant'alindu ile ntiɗëni ỹa, kaɓi vëliɗina ile nësëhnëɗënihu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Waryiɓ walënah, walakah ndiɓi mbarëpëɗëni, do ndiɓëndëɗënihëhni vahnë va; ɓare vëhni dënk ñoñ vëliɗina ndemahnënihëhni. ");
INSERT INTO cou_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Ile ntiɗëni ỹa fop, nuhahnënihëhni vahnë va ntiɗëni. Ƴëkëryin gante naỹëk ka Wanës W̃ën wante ñëbaɗëni wayëka hna gë wahnil hna! Ƴëkëryin fëna gante njaryëk ka ỹaw̃ar yale rëfëɗe wacëmët viỹi vilëw̃ hni soŋe tufëhnahnëndëni kahnëndani soŋe W̃ënu ŋa! ");
INSERT INTO cou_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ñaɗëni daña hnë wëlaña walënah hna hn'ile tokëɗe roka sankaf hna do ñaɗëni fëna wëlaña wale rëkëɗe nuhahnëndeni vacaliŋa hna; ");
INSERT INTO cou_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ñaɗëni nkaỹëndeni g'untënah waỹëw̃a ɓulunda hna do macëndeni “Aharaŋ Asankaf”. ");
INSERT INTO cou_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Ɓare w̃uhnë, ant'aliwu aw̃acëndewu “Aharaŋ Asankaf”, kaɓi hnënk yerun w̃uhnë fop do Aharaŋ Asankaf aryampo fo hwëhnarun. ");
INSERT INTO cou_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ant'aw̃acuna ahnë hnë w̃uhnë “Apa”, kaɓi aryampo fo ye Rëmun ỹa, umë ye g'ambin. ");
INSERT INTO cou_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ant'aliwu fëna aw̃acëndewu “Aharaŋ”, kaɓi Aharaŋ aryampo fo hwëhnarun, umë ye Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ale ỹak hnaỹëk hnë w̃uhnë ỹa rëfëka nke aryokuŋëhn hun a. ");
INSERT INTO cou_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ale hnaỹënaka mbanëɗe, ɓare ale vanaka naỹënëɗe.» ");
INSERT INTO cou_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tac Yesu më ntehnëkëhni vëharaŋ sariya va gë wafarise w̃a: «Meku w̃uhnë, vëroka vahnë! Piɗëntunëhëhni rënka Naw̃ ambin ŋa vahnë va; tënkëɗiluhna w̃uhnë do tavëɗilunëhnihna tënkëni vële ỹaɗ va. ");
INSERT INTO cou_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Nufëndunëhëhni vësëval vële cëmaryëk vësan va, vësay, ile kwëhnani ỹa fop do fëna njëfaɗun iƴëfa ƴaryah ntehnani catërun. Soŋe umë ye w̃uhnë hitiŋënde kiti le ỹak yapëk ỹa! ");
INSERT INTO cou_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Njasëlehnëɗun gante-wo-gante nkal li gë walant li ahnuỹahnënduna aryampo ale hwëtahnëku, do ge nuỹarunëha ntiɗunëha tëfa tënk gë janáma hafo ntëbu w̃uhnë wahwënta wahi. ");
INSERT INTO cou_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Meku w̃uhnë, vumëp vunte hahëɗ vahnë! Ntehnëɗun: “Ge ahnë ntëkahnëk Cery W̃ën Cankaf ŋa, umë gena ñoñ; ɓare ge sanu vë Cery W̃ën Cankaf ỹi ntëkahnëk, tëfëka nti ile ntehnëk ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nënkwërun do mëpërun! Sanu ỹi gë Cery W̃ën Cankaf nte sëvëndanëk sanu ŋi, ye ỹak yaɓëka nafa ỹa? ");
INSERT INTO cou_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ntehnëɗun fëna: “Ge ntëkahnëk mahëhnu hn'ile cënaɗe saɗëha hna, umë gena tana; ɓare ge ile sënahnik ỹa ntëkahnëk, tëfëka nti ile ntëkëk ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vumëp yerun! Ye ỹak nëfak: saɗëha ỹa ma hn'ile cënayik saɗëha hna ile sëvëndanëɗëha ỹa? ");
INSERT INTO cou_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ƴëtëryin iỹin: ale lëkahnëk hn'ile cënaɗe saɗëha hna, ntëkahnëk fop vile ye hnam va. ");
INSERT INTO cou_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ale lëkahnëk Cery W̃ën Cankaf ŋa, ntëkahnëk Cery W̃ën Cankaf ŋa gë W̃ënu ŋa per. ");
INSERT INTO cou_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ale lëkahnëk ambin ŋa, ntëkahnëk tinki W̃ënu ŋa gë W̃ënu ŋa per. ");
INSERT INTO cou_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Njëɗaɗunëha W̃ënu ŋa ỹëŋa hwëhn pëhw-wo ile varëpërun ỹa, hafo gë sifa yaryef yale-wo-yale rokëɗe ỹa fop, ɓare maw̃ëndiluhna ile ỹak hnëfak sariya hna, gante nke usatah gë kaỹëhnahn do g'ikwëtahn ŋa. Umë ye ile rëfakëha aliwu ỹa, hara ɗënkwëluhna fëna ƴëɗahn ỹëŋa hwëhn pëhw-wo ile varëpëɗun ỹa. ");
INSERT INTO cou_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vumëp vunte hahëɗ vahnë! Tarëɗun ile seɗun ỹa alihëtahnuna fanku, ɓare kohnëɗunëha yonkomb! ");
INSERT INTO cou_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Për hna vahnë vëfërën yerun ɓare ɓambery, ule fëɓëku g'iña idëb vahnë. Ile liɗun ỹa nke had ahnë ale facënëɗ hamëhni fo nkëlëw̃a ŋa gë humpan uŋa do nko tonk ɓambery ỹa. ");
INSERT INTO cou_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farise w̃ëpah! Pacënëryin ɓambery ankëlëw̃a ŋa tac për iŋa fëna pacëɗ. ");
INSERT INTO cou_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Gë wayag wale yerënik liyak had nkwamëk për iŋa mëntëlërun, ɓare ɓambery ỹa waỹëc vësëm fëɓëk do gë sifa viyëlah-wo. ");
INSERT INTO cou_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Koyëna nkehu w̃uhnë fëna për iŋa, tufëhnaɗun catërun, ɓare ɓambery ỹa vëroka vahnë yerun do dënënëluhna sariya ỹa. ");
INSERT INTO cou_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Meku w̃uhnë, vëharaŋ sariya vi gë wafarise w̃i, vëroka vahnë! Mbëryëndunëhëhni wakila ŋa wayag walëw̃ëri w̃a, gwamënëndunëhëhni vële satëk va wayag walëw̃ hni w̃a, ");
INSERT INTO cou_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","do ntehnëɗun: “Ge wati vacërakëlo hu ỹa yentahnëkëndeɓunëho ɗemakëndilëfunihna ndaw̃ënihëhni wakila ŋa.” ");
INSERT INTO cou_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Koyëna, njavëtërun w̃uhnë dënk vutah vële ryaw̃ëkëhni wakila ŋa yerun. ");
INSERT INTO cou_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Awa tëfëryin soŋe afuhnawu ile pëgwëniho warëmun ỹa! ");
INSERT INTO cou_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Walën yerun, pëɓëku wanto ŋa, hak ñaɗun ahehawu hara dabiluhna gë janáma fac kiti hna? ");
INSERT INTO cou_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Soŋe umë pëƴaɗëmu, cañëtëhniɗëmuni wakila do vëyët do gë vëharaŋ paryi. Ndaw̃ëɗunëhëhni vëryampo, vëỹëntaw̃ va afakuni hnë wakërëwa, do ntampëɗunëhëhni vëhaw̃ary kat vacaliŋa hun hna do rëkëɗun arëfëlehnënduni hnë wahnaw̃ hna fop. ");
INSERT INTO cou_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Koyëna w̃uhnë cosëɗ W̃ënu ŋa soŋe ile ndaw̃ini vahnë vële wok vëlina w̃eh va tëk pëgw iɗaw̃ Abel hna hafo vëhni Sakari hna, aju Barasi, ale ryaw̃ërun yëbëlan ỹëw̃a sëvah hna g'ile cënaɗe saɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Toña ỹa fëƴaɗëmu: W̃ënu ŋa piniŋëɗëhëhni vahnë vëvë dol va soŋe waŋi fop!» ");
INSERT INTO cou_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu më mbok ntehnëhni: «W̃uhnë vëvë Yerusalem vi, w̃uhnë vële ryaw̃ëɗëhëhni wakila, ndaw̃ëɗunëhëhni gë wëraka vële paƴëhnikuni W̃ënu va! Gante ñaɗëfuho ɗus varëpu ɗarël mën had cale nte varëpëkëhni vutahu hnë vampaw̃ vantëw̃u, ɓare maw̃ëluhna! ");
INSERT INTO cou_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Awa wëli, W̃ënu ŋa tavëɗ cery hun ŋa. ");
INSERT INTO cou_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ha, pëƴaɗëmu ɓokëɗiluhna ahnuwuno hafo wati nte ntehnëɗun: “Araɓi Ahwëhn a W̃ënu ŋa njëɗa ale yijëɗ g'uw̃ac lëw̃u w̃a!”» ");
INSERT INTO cou_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu cahnëko Cery W̃ën Cankaf hna do, ante njiɗëho ŋa, vërëfal vëlëw̃u va më tëhaniha soŋe tufahnëniha vacery vante yeho caharaɓ selele Cery W̃ën Cankaf hna. ");
INSERT INTO cou_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Awa Yesu më ntehnëkëhni: «Nurun iỹin fop? Toña ỹa fëƴaɗëmu: la itaka ɗampo goɗina tinda hnani hn'iñëntaw̃; fop nihëɗe.» ");
INSERT INTO cou_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ga ndëcëk watac, Yesu hn'ikuŋ Oliviye hna njiko ntañako. Vërëfal vëlëw̃u va më tëhaniha do tëƴëniha: «Guve ntiyaɗ waŋi, do ile yeɗ dahëse iɓoka hu ŋa do gë wapuya ɗuniỹa ŋa?» ");
INSERT INTO cou_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Më ntëkwakëhni: «Kwëtëryin hakili, ant'aravu arokayiwu! ");
INSERT INTO cou_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vahnë vëyaɓah njijëɗëni mëcani uw̃ac mën w̃a do ntehnëndëni: “Arëhnayik a yeɓu!” do tokaɗënihëhni vahnë vëyaɓah. ");
INSERT INTO cou_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nkwëryëɗun ga mëtëɗe ɗarël hun do gë wakasëk soŋe wamët waɓë ŋaw̃ët ŋa. Antë ntaku: watac afo ntiya, ɓare geɗina ten wapuya iỹi ɗuniỹa. ");
INSERT INTO cou_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɓulunda rëkëɗ mëtëndëni gë ɓulunda ỹëntaw̃, do ahnaw̃ pëgwëɗëha ahnaw̃ aỹëntaw̃; nkeɗ ñënka nkal hnë waresiỹo wayaɓah, do g'inte ŋa. ");
INSERT INTO cou_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nkeɗ had lav ɗonk hnag ryënkwëryënkw. ");
INSERT INTO cou_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Hnë wati rac, vahnë va mbërehnëɗënihu do ndaw̃ëɗënihu. Waɓulunda ŋa fop ñew̃ëɗënihu soŋe lëmën. ");
INSERT INTO cou_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Vëyaɓah tavëɗëni kwëtahn iŋa; rëkëɗ tokalëndëni do ñew̃ëlëɗëni. ");
INSERT INTO cou_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wakila vëw̃ër vëyaɓah sahnëɗ do tokaɗënihëhni vahnë vëyaɓah. ");
INSERT INTO cou_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wameh ŋa campëɗ hafo iña vahnë vëyaɓah goɗina. ");
INSERT INTO cou_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ɓare ale yaw̃ënaɗ hafo pu ỹa, W̃ënu ŋa pehëtëɗëha. ");
INSERT INTO cou_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wanës Wakasëk Naw̃ iŋi pëƴahnëɗe ɗuniỹa li fop, waɓulunda ŋa fop nkwëryëɗëni. Tac tëkiɗ wapuya ɗuniỹa ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu më mbok ntehnëk: «Fac ỹa tëkiɗ hn'ile nuɗun ỹëw̃a sëvah hna le w̃acëɗe “Iñë hayah ɗëcët ỹa” le nësëɗëho kila le w̃aciko Daniyel ỹa. Araɓi ale haraŋëɗa nkwëry ɗus waŋi! ");
INSERT INTO cou_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Awa vële yeɗ Yuɗe va tëfëɗëha nkaryëni gë wahuŋ: ");
INSERT INTO cou_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ale yeɗ ƴaŋ cery ntëw̃u ŋa, tëfëlahna cëli njij nuf viỹë vilëw̃u va ɓambery ani gë nkaryahnënd; ");
INSERT INTO cou_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","do ale ye hn'ikaỹ ŋa tëfëlahna mënc gë ỹalu soŋe njoj cuɗ cankaf ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mekëhni vësëval vëryonkah va gë vële yëw̃ëndëɗëhëhni vutah vuntëw̃ hni va hnë wafac warac! ");
INSERT INTO cou_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ƴëfaryina W̃ënu ŋa soŋe ant'ayaryu hnë wafac wale tëvëɗ gë fanka ma hnë fac ntaw̃ëla hna! ");
INSERT INTO cou_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hnë wati rac njaɓëɗ ɗus ambër ŋa, ntëbi vante yeho koɓëri nte pëgwëko ɗuniỹa hafo gaki ŋi, do ɓokëɗina nke muk sifa mbër tac. ");
INSERT INTO cou_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ge W̃ënu ŋa pëhnakëndilohna ŋaỹët waỹi wafac, ahnë gokëndina. Ɓare ŋaỹëtëɗ soŋe vahnë vële tëhnak va. ");
INSERT INTO cou_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Awa ge ahnë ntehnëku: “Ƴëkëryina, Arëhnayik a ani nke!” ma: “Hnani nke!” nt'aw̃aw̃u, ");
INSERT INTO cou_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","kaɓi vële wok vëyena vërëhnayik paryi gë wakila paryi sahnëɗ. Tëkëɗ ntindëni vifëmpëhnahnah visankaf gë wëdahëse wacankaf tokahnënihëhni vahnë va, hafo tokaryënihëhni la vële tëhnak W̃ën va, ge kokënd nke. ");
INSERT INTO cou_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nëparyin! Pëƴamu koɓëri fo. ");
INSERT INTO cou_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Awa ge ntehnirun: “Ƴëkëryin, Arëhnayik a wula hna nke!” nt'ayiwu. Ma ge ntehnirun: “Ƴëkëryin, hnani cow̃ak!” nt'aw̃aw̃u. ");
INSERT INTO cou_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Itëk Ajë Ahn'a nkeɗ had mbilëbilëk ambin hn'ani penëlehn ɗuniỹa ỹi fop. ");
INSERT INTO cou_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hnë le nke ibël hna, hnam mbarëpëlëɗëni wahuy w̃a.» ");
INSERT INTO cou_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu më mbok ntehnëk: «Ge ndëcëk wafac ambër atac, ulav w̃a kuyëɗ taŋ, tac lepera w̃a ɓokëɗina ntanc, wahol w̃a njojëɗ do fanka favë g'ambin fa ñënkaɗ. ");
INSERT INTO cou_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Awa, dahëse Ajë Ahn'a cahnëɗ ambin hna; ɓulunda vahnë vëvë nkal vi fop njahnaɗëni, nuɗëniha Ajë Ahn'a ga tëkiɗ vëŋar hna mati g'ambin gë fanka do gë icëmb cankaf. ");
INSERT INTO cou_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lënkw sankaf ỹa ntënkwëɗe do paƴëɗëhëhni wamëleka wadëw̃u ŋa hnë vacape vanah vambë nkal vi, mbarëpiɗënihëhni vële tëhnak va.» ");
INSERT INTO cou_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Gwëryëryin ile karaŋëɗ anuỹ ŋi: ge tëk nëp tuŋ njëtëɗun wati hasëk ỹa tëhajëk. ");
INSERT INTO cou_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ndampo fo nke, ge nurun vëỹin fop, ƴëtëryin wati iɓoka Ajë Ahn'a tëhajëk, ɓëỹëɗina ntiyaɗ. ");
INSERT INTO cou_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Toña ỹa fëƴaɗëmu: ỹi ƴamani ɗëcëɗina hara diyana vëỹin fop. ");
INSERT INTO cou_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ambin ŋi g'inkal iŋi ndëcëɗ, ɓare wanës mën ŋi ɗëcëɗina muk.» ");
INSERT INTO cou_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ahnë ƴëtëna bi guve tëkiɗ fac ma wati le ntiyaɗ vëỹin ỹa, la wamëleka waɓ g'ambin ŋi gë Aj'a dënk vëyëtëna; Rëm ỹa fo yëtëk. ");
INSERT INTO cou_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Fac ile njihahniɗ Ajë Ahn'a nkeɗ had gë ƴamani rëm fu sankaf, Nowe, ka. ");
INSERT INTO cou_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wati rac, tëkahnindo uw̃ac sankaf w̃a, vahnë va tokëɗëniho do ceɗëniho, ñëlëlëɗëniho do njëɗahnëɗënihëhniwo vëryag hni va ñëlini, hafo fac le tënkahnëko Nowe hnë sisikulu hna; ");
INSERT INTO cou_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ñoñ vëyëtalohna hafo uw̃ac sankaf w̃a tëki do njokëhniwo vëhni fop. Vahnë va koyëna mbokëɗ ntindëni ante njijëɗ Ajë Ahn'a. ");
INSERT INTO cou_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wati rac, vësan vëhi yeɗ kaỹ hna: njoɗëha aryampo do tava aỹëntaw̃ a. ");
INSERT INTO cou_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vësëval vëhi rëkëɗ ndaw̃ëndëni ryëw̃a: njoɗëha aryampo do tava aỹëntaw̃ a. ");
INSERT INTO cou_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Awa nt'ahnamawu, kaɓi ƴëtëluhna bi iỹëhne fac njijëɗ Ahwëhn hun a. ");
INSERT INTO cou_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ƴëtëryin ɗus waŋi: ge ahwëhn tere ỹa njëtakënd wati le njijëɗ g'umëɗ ga ale ỹa, ɗakakëndina wakwëɗ do tavakëndilahna tënk tere lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Soŋe umë ye, pëhwëtaryin w̃uhnë fëna, kaɓi Ajë Ahn'a tëkiɗ hnë wati le worun nahaluhna.» ");
INSERT INTO cou_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu më mbok ntehnëk: «Mo ga ye aryokuŋ ale hahnëndak do ritëk a? Umë ye ale hwëtehnahnikëhni vëryokuŋëntaw̃u va fop ntehni: “Ƴëɗaryindëhni vëryokuŋënta hu vi roka ỹa hnë wati le rëfëka hna.” ");
INSERT INTO cou_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nëfaka aỹi aryokuŋ ge ahwëhn tere ỹa mëncik do tëkata ga ntiɗ ɗoku lëw̃u ỹa! ");
INSERT INTO cou_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Toña ỹa fëƴaɗëmu: ahwëhn tere ỹa kwëtehnahnëɗëha hnapul lëw̃u ỹa fop. ");
INSERT INTO cou_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ɓare ge aryokuŋ aw̃eh ye, ntehnaɗ ahwëhn tere ỹa mëncënkajëɗina, ");
INSERT INTO cou_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","do pëgwëlehn ndafëndëhni vëryokuŋëntaw̃u va do tokëlahnëndëni, celahnëndëni gë vëryëw̃! ");
INSERT INTO cou_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Awa ahwëhn tere ỹa mënciɗ hnë fac le nkok ƴëkaɗilahna aryokuŋ arac, hnë wati le nkok ƴëtëna; ");
INSERT INTO cou_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ndafëɗëha ɗaf ntavah gante ntiɗëni vële hnësëɗ ile nkoni waliɗina ỹa, hn'ile koɗe do cemëlehnaɗe wabeñ hna.» ");
INSERT INTO cou_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu më mbok ntehn: «Awa Inaw̃ ambin ŋa g'iỹi uhnës uryindaryindan mëntëlëɗëni: vëryag pëhw nufëni walampu walëw̃ hni cahnëni kacahnëniha ale ỹëlëɗ. ");
INSERT INTO cou_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hnë vërac, imbëɗ nënkwëniho do imbëɗ titëni. ");
INSERT INTO cou_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vëhnënkwah va njoniho walampu walëw̃ hni w̃a, ɓare vëfehnalohna wagu ŋa. ");
INSERT INTO cou_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ɓare vëritah va njoyaniho walampu gë wasëleku wagu ŋa pehnani. ");
INSERT INTO cou_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Awa ale ỹëlëɗ a ndëcajëɗëhawo; vëryag va më njokëhni wakwëɗ ndakëlehnëni. ");
INSERT INTO cou_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ante ndëcak ŋa, më wëryik waɗeka: “He w̃uhnë! Ale ỹëlëɗ a nkejëk! Cahnëryin ahacawuna!” ");
INSERT INTO cou_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Awa vëryag pëhw va nëgalehnëni pëgwëni pëhwëtëndëni walampu walëw̃ hni w̃a. ");
INSERT INTO cou_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vëhnënkwah va më tëƴënihëhni vëritah va: “Ƴëɗëryinëfu wagu hun ỹi, kaɓi walampu walëw̃ fu w̃i ɗipiŋa nke!” ");
INSERT INTO cou_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«Vëritah va më ntëkwanihëhni: “Hali, kaɓi geɗilëfuhna gwër fuhnë fop. Ƴiryin alëw̃aju gë vëwaf.” ");
INSERT INTO cou_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Awa, vëhnënkwah va njilehnëni ntëw̃ajëni wagu ŋa. Hnë wati rac tëkiko ale ỹëlëɗ a. Imbëɗ vële fëhwëtako va tënkëntëlehnini g'umë cery nte ñëland hna cëɗëlehni rënka ỹa. ");
INSERT INTO cou_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Ga mbiỹëk, vëryag vëỹëntaw̃ va tëkiniho do ndekandëni: “Ahwëhn, Ahwëhn, piɗëtëndifu!” ");
INSERT INTO cou_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Ɓare ahwëhn a më ntëkwakëhni: “Toña ỹa fëƴaɗëmu, ƴëtëluhna.”» ");
INSERT INTO cou_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu, më nkwënëk: «Awa kwëtëryin hakili, kaɓi ƴëtëluhna fac ỹa gë wati le mbokahniɗ Ajë Ahn'a.» ");
INSERT INTO cou_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu më mbok ntehnëk: «Inaw̃ W̃ënu ŋa g'iỹi uhnës uryindaryindan mëntëlëni kat: asan ñaɗ nji uyas do macëɗëhëhni vëryokuŋ vëlëw̃u va, kwëtehnahnëhni hnapul lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aryampo waŋëc sanu wakeme mbëɗ njëɗakawo, aỹëntaw̃ a wakeme waki, ararëna ỹa keme, ale-wo-le ile mëkëɗ ndokuŋahn ỹa. Tac njilehn g'uyas. ");
INSERT INTO cou_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aryokuŋ ale yëɗayiko waŋëc sanu wakeme mbëɗ ỹa njilehn taŋ nkwafahnënd igwaf koryi rac do nuỹa waŋëc sanu wakeme mbëɗ wakaw̃ary. ");
INSERT INTO cou_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ale yëɗayiko waŋëc wakeme waki ỹa fëna koyëna ntiko do nuỹa waŋëc wakeme waki wakaw̃ary. ");
INSERT INTO cou_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ɓare ale yëɗayiko waŋëc keme ỹa, njiko nkab mbañ hnam koryi rac. ");
INSERT INTO cou_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ga mbiỹëk, ale ndokuŋëhnëɗëniho vëỹi vëryokuŋ a mënciko, më tëƴëkëhni pëƴaniha soŋe koryi le kwëtehnahnëkëhniwo ỹa. ");
INSERT INTO cou_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ale yëɗayiko waŋëc sanu wakeme mbëɗ ỹa, më tëhajëk do tufahn waŋëc wakeme mbëɗ wañëntaw̃ ŋa ntehn: “Ahwëhn tere waŋëc wakeme mbëɗ yëɗaruhow̃o. Nuỹaɓu waŋëc wakeme mbëɗ wakaw̃ary: wëli.” ");
INSERT INTO cou_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Arac më ntehnëka: “Njivëk, aryokuŋ afërën do ale facënak yeru. Pacënaru hnë viỹë viroƴ hna, soŋe umë kwëtehnandëmi viyaɓah va. Ƴij cehëli hnatah mën w̃a!” ");
INSERT INTO cou_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Tac aryokuŋ ale yëɗayiko waŋëc wakeme waki ỹa tëhagiko do ntehn: “Ahwëhn tere, waŋëc wakeme waki yëɗaruhow̃o. Nuỹaɓu wakeme waki wañëntaw̃: wëli.” ");
INSERT INTO cou_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Arac më ntehnëka: “Aryokuŋ afërën do ale facënak yeru. Pacënaru hnë viỹë viroƴ hna, soŋe umë kwëtehnandëmi viyaɓah va. Ƴij cehëli hnatah mën w̃a!” ");
INSERT INTO cou_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Rëkwa ỹa, aryokuŋ ale yëɗayiko waŋëc keme ỹa më tëhagik do ntehn: “Ahwëhn tere, njëtëɓuho asan ayapah yeru: kácëɗu hn'ile nkoru naɗëlihna, mbarëpëɗu hn'ile nkoru pahnëlihna ñoñ. ");
INSERT INTO cou_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ntakëkow̃o gë wëjë, më yiɓu vañu koryi hu ỹa. Wëli ile hwëhnëru ỹa.” ");
INSERT INTO cou_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Arac më ntëkwaka: “Aryokuŋ aw̃eh yeru do këmaru! Njëtëruho kacëɗëfu hn'ile nkoɓu naɗëla, mbarëpëɗëfu hn'ile nkoɓu pahnëla ñoñ? ");
INSERT INTO cou_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Awa tëfëkawo ahwët koryi mën ỹa hnë bank. Ge mënciɓu kokëndeɓu wënëhniw̃ ge mbiɗëfu.” Tac më ntehnëkëhni vële nkeniho va: ");
INSERT INTO cou_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Teɓëryina waŋëc sanu keme ŋi do ayëɗawuna ale hwëhnak waŋëc wëli ỹi. ");
INSERT INTO cou_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Koyëna nke, ale wëryëk wapacëk a nkwënëhnëɗe uyët w̃a, do kobëɗëha; ɓare ale wok gwëryëna ỹa, teɓëɗe la ile njëtëk ỹa. ");
INSERT INTO cou_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ge aỹi fufafu ye, doŋëryina g'ipër hn'umëhwëry hna, hn'ile koɗe do cemëlehnaɗe wabeñ hna.”» ");
INSERT INTO cou_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu më mbok ntehnëk: «Ge Ajë Ahn'a njijëk had ahnaw̃ hnë icëmb dëw̃u hna gë wamëleka ŋa fop, ntañaɗ hnë tinki Naw̃ dëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fop waɓulunda waɓë nkal ŋi mbarëpëlëɗëni haryënkw lëw̃u do pitëndëlendëhëhni vahnë va gante pitëndëlendëhëhni ahery wape g'uhnankal ki; ");
INSERT INTO cou_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","G'irëhw lëw̃u kwëtëɗëhëhni vësatah va, vëw̃en va g'irahahn. ");
INSERT INTO cou_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Awa ahnaw̃ a ntehnëɗëhëhni vële yeɗ g'irëhw lëw̃u va: “Ƴijën, w̃uhnë vële ndëwanëk Rëm mën vi! Kwëhnëryin Naw̃ nte pëhwëtëhnëkuno koɓëri ante ntiɗëho ɗuniỹa ŋa! ");
INSERT INTO cou_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndëwanirun kaɓi njokowo inte ŋa do njëɗarunëhow̃o roku; njokowo w̃ënka ŋa do njëɗarunëhow̃o siyaw̃; ahneh yeɓuho do kacarunëhowo ỹal hun hna; ");
INSERT INTO cou_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ŋas fo yeɓuho do cuɗërunëhow̃o; tesëɓuho do paɓërunëhow̃o; cëɗiɓuho do njijëɗunëho ayëkiw̃uno.” ");
INSERT INTO cou_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Awa vësatah va tëƴëɗëniha: “Ahwëhn, guve nuyiruho ga njoki inte do ayëɗayi arok, ma ga njoki w̃ënka do ayëɗayi asiya? ");
INSERT INTO cou_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Guve nuyiruho ga nkeru ahneh do ahacayi watere fu hna, ma ga nkeru ŋas fo do asuɗi? ");
INSERT INTO cou_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Guve nuyiruho ga tesëru, ma ga cëɗiru, do yiryiɓun ayëkiji?” ");
INSERT INTO cou_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Ahnaw̃ a ntëkwaɗëhëhni: “Toña ỹa fëƴaɗëmu: ante-wo-nte ntinëhnërunëha aỹënta mën wëla ale ỹak vak ỹa, ami linëhnërun.” ");
INSERT INTO cou_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Tac ahnaw̃ a ntehnëɗëhëhni vële yeɗëha g'irahahn va: “Ŋaw̃ëtaryino, w̃uhnë vële ndëwanëk W̃ën w̃eh vi! Ƴiryin gë hwëɗëh hunte wok ɗipëɗina muk, hunte pëɗëhnik Sintani gë wamëleka wadëw̃u ŋa! ");
INSERT INTO cou_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Njokowo inte ŋa do ƴëɗalunohna roku; njokowo w̃ënka ŋa do ƴëɗalunohna siyaw̃; ");
INSERT INTO cou_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ahneh yeɓuho do kacalunow̃ohna; ŋas fo yeɓuho do cuɗëlunow̃ohna; tesëɓuho do cëɗiɓuho do paɓëlunow̃ohna.” ");
INSERT INTO cou_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Awa vëhni fëna tëƴëɗëniha ahnaw̃ a: “Ahwëhn, guve nuyiruho ga njoki inte, njoki w̃ënka, nkeruho ahneh, nkeruho ŋas fo, tesëruho, ma cëɗiruho do nkoyiruho ɗemayilihna?” ");
INSERT INTO cou_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ahnaw̃ a ntëkwaɗëhëhni: “Toña ỹa fëƴaɗëmu: ante-wo-nte nkorunëho dinëhnëlunahna aỹënta mën wëla ale ỹak vak a, dinëhnëlunohna ami fëna.” ");
INSERT INTO cou_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Koyëna njiɗun gë horot le wok puɗina hara vësatah va gë ɗuniỹa le wok puɗina njiɗëni.» ");
INSERT INTO cou_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ante puhnako Yesu karaŋ vërëfal vëlëwu va waŋi fop ŋa, më ntehnëkëhni: ");
INSERT INTO cou_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Njëtërun wafac wahi wojëk nkehahn ambënt Pak ŋa. Wati rac, Ajë Ahn'a njëɗahnëɗe soŋe paki hnë kërëwa.» ");
INSERT INTO cou_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Awa vësankaf vësëna wasaɗëha va gë vicër ɓulunda wasëwif va, tere Kayif asankaf vësëna wasaɗëha hna mbarëniho; ");
INSERT INTO cou_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","më maw̃alëni pëlaniha Yesu ƴëm-ƴëm fo do ndaw̃ehnëniha. ");
INSERT INTO cou_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Më ntehnëni: «Koɗelënëhna ntiyin watac hnë wati ambënt hna, ge gena umë ɓulunda ỹa dakëna ŋañënani.» ");
INSERT INTO cou_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani nkeho, tere Simo ale hwëhnako mbiỹ ŋa. ");
INSERT INTO cou_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Asëval më tëhaka gë sëleku ɗatikola hambah ntaw̃i: umë turëka ɗatikola rac Yesu nkaf li wati nte ntañaniho hn'ile tokëɗe roka hna. ");
INSERT INTO cou_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vërëfal va ga nuni watac, ntavëkëhniwo më ntehnëni: «Soŋe ye përëkanëk iỹi ɗatikola? ");
INSERT INTO cou_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kokënde nkwafi gë koryi yaɓah njëɗayini koryi ỹa vëhaỹëhnah va!» ");
INSERT INTO cou_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu njëtëko koyëna nësëɗëni më ntehnëkëhni: «Soŋe ye ryëñanërunëha aỹi asëval? Ile ntinëhnëko iỹi njivëk. ");
INSERT INTO cou_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nkelandun kwëlëkwël vëhaỹëhnah va; ɓare ami, gelandelënëhna kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Turëk iỹi ɗatikola mbahn mën li pëhwëtanëhnahno iɓañ iŋa. ");
INSERT INTO cou_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Toña ỹa fëƴaɗëmu: hn'ile-wo-le pëƴahnëɗe Wanës Wakasëk ŋa ɗuniỹa li fop, tëfëtaɗe ile ntik asëval aỹi fëna do ndënkwëtaɗe.» ");
INSERT INTO cou_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Awa aryampo vërëfal Pëhw gë Vëhi, ale w̃aciko Yuɗa Isëkariyot, njiko vësankaf vësëna wasaɗëha hna ");
INSERT INTO cou_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","do ntehnëhni: «Ye sosëɗunëho ge njëɗamuna Yesu?» Awa vërac më ndëkwëni waŋëc wafëhw warar koryi. ");
INSERT INTO cou_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tëk pëgw wati rac Yuɗa pëgwëlehn njëkëlehnand fere fale rëfëka njëɗahnëhni Yesu fa. ");
INSERT INTO cou_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hnë fac ryënkwëryënkw ambënt mburu kwëhn levir këm hna, vërëfal va tëƴënihawo Yesu: «Ne ñaɗu yifu afëhwëtanëhni roka Pak ỹa?» ");
INSERT INTO cou_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Awa Yesu më ntëkwakëhni: «Ƴiryin naw̃ hna hnë vëhni ahod alehnuna: “Ahwëhn a më lehnëk: Wati mën ỹa tëkëk; ỹal hu hna ntiɗëfun Pak ỹa gë vërëfal mën va.”» ");
INSERT INTO cou_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vërëfal va më ntini ile ntehnëkëhniwo Yesu ỹa do pëhwëtani soŋe roka ỹa. ");
INSERT INTO cou_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ga nëkak, Yesu gë vërëfal Pëhw gë Vëhi va ntañaniho. ");
INSERT INTO cou_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wati nte tokëɗëniho ŋa, Yesu më ntehnëkëhni: «Toña ỹa fëƴaɗëmu: aryampo hnë w̃uhnë tokaɗëho.» ");
INSERT INTO cou_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vërëfal va njamëlehnëni pëgwëlehnëni ntehnëndëniha aryampo aryampo: «Ahwëhn, ami bi ye?» ");
INSERT INTO cou_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu më ntëkwakëhni: «Ale labëlandëɓun mburu nëhëta ỹa, umë rokaɗëho. ");
INSERT INTO cou_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ajë Ahn'a cëmëɗ, gante nësëk Vikerëh soŋe lëw̃u ka; ɓare horot sankaf nuỹaɗ ale rokaɗëha Ajë Ahn'a! Antë mbërayi nagi fecekëndëho asan arac!» ");
INSERT INTO cou_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuɗa, ale rokaɗëha ỹa, më teɓak wanës ŋa do tëƴa Yesu: «Aharaŋ Asankaf, ami bi ye?» Yesu më ntëkwaka: «Wëjë hnësëk.» ");
INSERT INTO cou_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wati roka hna, Yesu nufëko mburu ŋa do, ga camehnëka W̃ënu ŋa, më nkubëlehnëk njëɗahni vërëfal vëlëwu va, ntehnëhni: «Nufëryin aroku iỹin, mbahn mën iŋa ye.» ");
INSERT INTO cou_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tac mbok nuf nkëlëw̃a uñen waresen ŋa do, ga mbok camehna W̃ënu ŋa, më mbok njëɗakëhni ntehnëhni: «Ceryin, w̃uhnë fop, ");
INSERT INTO cou_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kaɓi uŋi ñen sat mën ye, sat mën ile ỹabahnik kwëtëla gë W̃ënu ŋa do ryehëtik soŋe vahnë vëyaɓah tavëhnahnini wameh ŋa. ");
INSERT INTO cou_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pëƴaɗëmu: tëk pëgw gaki, ɓokëɗa sewu uñen waresen hafo hale ceɗen uñen kasëk mbë Naw̃ Rëm mën hna.» ");
INSERT INTO cou_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Njëw̃ëlehnëni wahnëw̃ ambënt ŋa. Tac njilehnëni hn'ikuŋ nte w̃acik Oliviye hna. ");
INSERT INTO cou_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Awa Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Hnë uŋi mëɗ dënk tavëɗunëho w̃uhnë fop, had gante kerik ka: «“Ndaw̃ëɗëfuha aheryëherya ỹa, do wape ŋa campëɗëni.”» ");
INSERT INTO cou_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesu më nkwënëk: «Ɓare ge mbëhnëɓu, njiɗëfu hnapëhëndu Galile hna.» ");
INSERT INTO cou_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyer më teɓak wanës ŋa ntehna: «Lakënde ntehni vëỹëntaw̃ vi fop tavënihi, ami tavëɗila muk.» ");
INSERT INTO cou_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmi: hnë uŋi mëɗ dënk, ani gë tarahnënd cale ŋa, ntehnëɗu wahwënta warar ƴëtëlihohna.» ");
INSERT INTO cou_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer më ntehnëka: «Dehnëɗa muk ƴëtëlihna, wëla ntehni tëfëka cëmëlahni gë wëjë.» Do vërëfal vëỹëntaw̃ va fop koyëna nësëniho. ");
INSERT INTO cou_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Awa Yesu gë vërëfal vëlëw̃u va më tëkëni ile macik Setësemane hna do më ntehnëkëhni: «Dañaryin ani yiwu yëfaju hnani.» ");
INSERT INTO cou_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tac më njokëhni vëhni Piyer gë viju vëhi Sebede. Pëgwëlehn njëtand ikaỹëhnahn g'ufëmpëhnahnah w̃a. ");
INSERT INTO cou_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Awa më ntehnëkëhni: «Ntaw̃ary mën iŋa pëɓëka yiw̃ëhnah sankaf ɗus hafo yewu had ale sëmëk. Ñëw̃ëryin ani do ɗuñënaryin ant'aryaku wakwëɗ.» ");
INSERT INTO cou_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tac më njik ŋaw̃ët toƴe, njok nkal li koɓalehn do njëfa aki: «Apa, ge koɗ nke ŋaw̃ëtënde antë tëkëhne iỹi horot. Ɓare ant'ali ile ỹaɗëfu ami, diry ile ỹaɗu wëjë ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Më mbokajëk ile nkeni vërëfal vërar hna do tëkatëhni ga ndakëni wakwëɗ. Më ntehnëka Piyer: «Mëkëlihna aryuñëna wëla wati ryampo fo hara ɗakëlihna? ");
INSERT INTO cou_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nt'aryaku wakwëɗ, njëfaryin soŋe gante koɗun ayaw̃ënahnu ge njëkëhnahnëɗerun. Paryi nke, ahnë ñaɗ ntind yivah yaɓah, ɓare mbahn iŋa kwëhnana fanka.» ");
INSERT INTO cou_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Më mbok ŋaw̃ëtak higëna ỹa do mbok njëfa aki: «Apa, ge iỹi horot koɗena ntihëti hara gelohna, araɓi iña hu ŋa ntiya!» ");
INSERT INTO cou_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Më mbok mbokajëk kat gë vërëfal vëlëw̃u mbok tëkatëlehnëhni ga ndakëni wakwëɗ. Vëhoɗilohna mbok ŋesëni. ");
INSERT INTO cou_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu më tavëkëhni, ŋaw̃ëtak do mbok njëfa rarëna ỹa tëfëtatënd wanës watac fo. ");
INSERT INTO cou_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tac më mbok mbokajëk ɗarël vëlëw̃u hna ntehnëhni: «Nkorun aryaku do ayinëgandu? Ƴëkëryin, wati ỹa tëkëk do Ajë Ahn'a njëɗaɗeniha vëw̃en va. ");
INSERT INTO cou_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Matëryin, njiyin! Ƴëkëryina, ale yëɗahnëɗëho ỹa tëhajëɗëho.» ");
INSERT INTO cou_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu nkoko nësënd ante tëkiko Yuɗa ŋa, aryampo yeho hnë vërëfal Pëhw gë Vëhi vëlëw̃u hna. Kore vahnë vële w̃ënkëko wasëlame do gë waryoko nkejëniho. Vësankaf vësëna wasaɗëha gë vicër ɓulunda wasëwif w̃a faƴikëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuɗa, ale yëɗaɗëhëhni Yesu ỹa, nkabëkëhniwo kore rac ile ntiɗ ỹa ntehn: «Asan ale vucëɗëfu ỹa, umë ye Yesu ŋa. Pëlaryina.» ");
INSERT INTO cou_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuɗa tëhalehna taŋ Yesu ntehna: «Aharaŋ, nkaỹëmi!» Tac mbucëlehna. ");
INSERT INTO cou_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu më ntëkwaka: «Lawo, ile yijëru ali ỹa diry ñap.» Awa vëỹëntaw̃ va nëñëlëhnëlehnëniha Yesu pëlaniha. ");
INSERT INTO cou_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aryampo hnë vële nkelahnëniho Yesu va, më ndorik sëlame lëw̃u ỹa, taw̃ëka aryokuŋ asëna wasaɗëha asankaf a ntëpëtëlehna nëf ŋa. ");
INSERT INTO cou_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Awa Yesu më ntehnëka: «Ɓokaryëry afëhw sëlame hu ỹi uval lëw̃u hna, kaɓi vële hnufaɗ sëlame va fop, gë sëlame ndaw̃ëɗeni. ");
INSERT INTO cou_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ƴëtëlihna bi kokëndëɓu w̃ac w̃a Apa njij ndemaw̃o do taŋ njëɗanahnekëndëhow̃ëhni wakore pëhw gë waki wamëleka ŋa? ");
INSERT INTO cou_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ɓare ge koyëna nkekënd, hak nkehahnakënd le nësëk vikerëh ỹa? Më lehnëk iỹin koyëna tëfëka nke.» ");
INSERT INTO cou_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tac Yesu më ntehnëkëhni kore ỹa: «Gë wasëlame do gë waryoko bi tëfakëha ayinëhniwuno, afëlawuno had bandi yeɓu? Fac-wo-fac ntañaɗëfuho Cery W̃ën Cankaf hna soŋe haraŋëndëwëhni vahnë va, ɓare pëlalunow̃ohna. ");
INSERT INTO cou_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ɓare waŋi fop tëkik soŋe ntiyahn wanës Vikerëh wakila ŋa.» Awa vërëfal va tavëlehnëniha nkaryëni. ");
INSERT INTO cou_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vële fëlakawo Yesu va njolehnëniha vëhni Kayif, asëna wasaɗëha asankaf hna, hn'ile mbarëniho vëharaŋ sariya do gë vicër hna. ");
INSERT INTO cou_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer tëfëlendëhawo Yesu ŋaw̃ët, hafo selele tere asëna wasaɗëha hna. Tënkëko selele tere hna do ntañanti gë vëyëka va njëkahn bi hak puɗ. ");
INSERT INTO cou_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Vësankaf vësëna wasaɗëha va gë Mbara Vëhitiŋ va fop njëkëlehnëɗëniho fere, wëla nke wamër, soŋe ndaw̃ehnahnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɓare vëhnuỹalohna, mama mërahnënihawo vahnë vëyaɓah. Ɓare vahnë vëhi yijëko ");
INSERT INTO cou_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","do ntehnëni: «Aỹi asan më lehnëk: “Koɗëfu hnihu Cery W̃ën Cankaf ŋi do vokaryu vëryu hnë wafac warar.”» ");
INSERT INTO cou_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Asëna wasaɗëha asankaf a më matëk do tëƴa Yesu: «Dëkwaɗila bi ile ntehnëɗënihi vëỹi vahnë ỹi?» ");
INSERT INTO cou_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɓare Yesu ndemëhnako. Awa asëna wasaɗëha asankaf a më ntehnëka: «Tëƴëɗëmi alëkëhnëfu g'uw̃ac W̃ën paryi ỹa, bi Arëhnayik a yeru, Aju W̃ënu ŋa?» ");
INSERT INTO cou_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu më ntëkwaka: «Wëjë hnësëk. Ɓare pëƴaɗëmu w̃uhnë fop tëk pëgw do nuɗunëha Ajë Ahn'a ntañaɗ g'irëhw W̃ën Hwëhn Fanka Fop; do nuɗunëha fëna ga njijëɗ vëŋar vamb g'ambin hna.» ");
INSERT INTO cou_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Awa asëna wasaɗëha asankaf a më citëk viỹi vilëw̃u va do ntehn: «Njew̃ëka W̃ënu ŋa! Gona mbalëfu waseɗe! Nkwëryërun gante njew̃ëka W̃ën ka. ");
INSERT INTO cou_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ye hnaharun?» Umë ntëkwaniha: «Menëk, tëfëka ndaw̃i.» ");
INSERT INTO cou_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Awa më tëpahnëniha yëka li do nkwëƴëniha. Vëryampo poryëɗënihawo ");
INSERT INTO cou_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ntehnatëndëniha: «Ƴëtëry, wëjë Arëhnayik a, pëƴaryifu bi mo ryafëki!» ");
INSERT INTO cou_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hnë wati rac Piyer për hna ntañako selele hna. Asëval aryokuŋ më tëhaka ntehna: «Wëjë fëna, gë Yesu nkentiruho, asan avë Galile ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ɓare njahëtako tase vahnë fop ntehn: «Ƴëtëla bi ye ỹaɗu ahnës.» ");
INSERT INTO cou_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tac njilehn gë cape rënka selele. Aryokuŋ aỹëntaw̃ asëval më mbok nuka do ntehnëhni vële yeho hnam va: «Aỹi gë Yesu mbë Nasaret nkentiko.» ");
INSERT INTO cou_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer më mbok njahëtak ntehn: «Lëk, ƴëtëlëw̃ahna aỹi asan.» ");
INSERT INTO cou_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ga mbiỹëk toƴe, vële yeho hnam va më tëhaniha Piyer ntehnëniha: «Paryi nke, wëjë fëna gë vëỹi nkentiruho: nësa hu ŋi rufarëɗ le nkejëru hna.» ");
INSERT INTO cou_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Awa Piyer pëgwëlehn ntëkënd: «Araɓi W̃ënu ŋa kwëɗo age mërëɗëfu! Lëk ƴëtëlëw̃ahna aỹi asan!» Wati rac dënk, tarëlehn cale ŋa, ");
INSERT INTO cou_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyer ndënkwëtalehn ile ntehnëkawo Yesu ỹa: «Tarahnënd cale ŋa, ntehnëɗu wahwënta warar ƴëtëlihohna.» Awa cahnëlehn kond ɗus. ");
INSERT INTO cou_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Koɓëri fo g'acahnëfëɗ ga, fop vësankaf vësëna wasaɗëha va gë vicër ɓulunda wasëwif va pëhnaniho ndampo fo ndaw̃ehnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Më ñabehnëniha, njoniha, njëɗaniha Pilat, guverëner ỹa. ");
INSERT INTO cou_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuɗa, ale rokakawo Yesu ỹa, nuko nkwëryëlëni soŋe ndaw̃ehnëniha Yesu. Awa curako ɗus ile ntik ỹa, tac mëncënanëlehnëhni vësankaf vësëna wasaɗëha va gë vicër va waŋëc wafëhw warar koryi ỹa. ");
INSERT INTO cou_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Më ntehnëkëhni: «Ntiɓu iw̃eh soŋe ile yëɗahnëɓuha ndaw̃i ale wok dina ñoñ!» Ɓare më ntëkwaniha: «Gena wadëw̃ fu, wadëw̃ hu fo ye!» ");
INSERT INTO cou_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuɗa më ntoŋëk koryi ỹa Cery W̃ën Cankaf hna canëlehn; tac më njik këŋak soŋe ndëwa. ");
INSERT INTO cou_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vësankaf vësëna va më mbarëpëni koryi ỹa do ntehnëni: «Sariya fu ỹa maw̃ëryana kwëtëlehnini iỹi koryi gë hnapul Cery W̃ënu ŋa, kaɓi sat law̃ahnik.» ");
INSERT INTO cou_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ga maw̃alëni, më ntaw̃ahnëni koryi rac kaỹ aỹahan ŋa soŋe ntini wayag vëhneh. ");
INSERT INTO cou_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Soŋe rac macahnëɗe kaỹ tac «Kaỹ wasat» hafo iỹi wati. ");
INSERT INTO cou_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Koyëna ntiyako wanës kila ile w̃aciko Seremi ỹa: «Më nufëni waŋëc wafëhw warar koryi ỹa —koryi ile maw̃alëniho vëvë Isërayel cosahnëni soŋe lëw̃u— ");
INSERT INTO cou_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","canëni ntaw̃ahnëni kaỹ aỹahan ŋa, gante ntehnëkawo Ahwëhn ka.» ");
INSERT INTO cou_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu haryënkw guverëner hna kahnëk. Arac tëƴëɗëha: «Ahnaw̃ wasëwif ỹa bi yeru?» Yesu më ntëkwaka: «Wëjë hnësëk.» ");
INSERT INTO cou_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tac vësankaf vësëna wasaɗëha va gë vicër va, ante nësëɗëniho ile ntik ỹa, Yesu ñoñ dëkwalohna. ");
INSERT INTO cou_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Awa Pilat më ntehnëka: «Gwëryëɗila bi wante ntehnëɗënihi ŋi fop?» ");
INSERT INTO cou_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ɓare Yesu la ñoñ dëkwalawohna, afo guverëner ỹa pëmpëhnahna ɗus. ");
INSERT INTO cou_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hn'ambënt Pak-wo, guverëner ỹa njehëkawo tava aramp aryampo, ale ñaɗëni ɓulunda ỹa. ");
INSERT INTO cou_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hara wati rac, ale w̃aciko Yesu Barabas sëɗiko hnam. ");
INSERT INTO cou_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Awa Pilat më tëƴëkëhni ɓulunda le varëlëko hnam ỹa: «Mo ỹaɗun ravëhnuna: Yesu Barabas bi ma Yesu nte w̃acëɗe Arëhnayik a?» ");
INSERT INTO cou_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat njëtëko ɗus g'iñew̃ary njëɗayikawo Yesu. ");
INSERT INTO cou_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wati nte nkeho Pilat kitiŋa hna, asëvalu më paƴehnik aki: «Nt'ayentahni wëɓa aỹi asan ale wok ñoñ dina ỹi, kaɓi hnë uŋi mëɗ korotakëɓu hnë hudakery soŋe lëw̃u ỹa.» ");
INSERT INTO cou_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɓare vësankaf vësëna wasaɗëha va gë vicër va më cënkwënihëhni kore ỹa tëƴëni tavi Barabas do Yesu ndaw̃i. ");
INSERT INTO cou_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Guverëner ỹa më mbok teɓak wanës ŋa soŋe tëƴëhni: «Mo ỹaɗun hnë vëỹi vëhi ravëhnuna?» Më ntëkwani: «Barabas ỹaɗëfun.» ");
INSERT INTO cou_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat më tëƴëkëhni: «Awa hak ntiɗëfuha Yesu nte w̃acëɗe Arëhnayik a?» Më ntëkwani vëhni fop: «Pakehnëryena hnë kërëwa!» ");
INSERT INTO cou_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat më mbok tëƴëkëhni: «Iỹëhne w̃eh ntik?» Ɓare pëgwëlehnëni mbok ndekandëni gë fanka: «Pakehnëryena hnë kërëwa!» ");
INSERT INTO cou_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat ga nuk ñoñ mëkëɗina, ɓare ŋañëna ŋa nkwënaɗëho, më nufëk w̃ënka, ñuhna tase vahnë fop do ntehn: «Gena ami yeɗ ankaf icëm aỹi asan! Wadëw̃ hun ye!» ");
INSERT INTO cou_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kore ỹa fop më ntëkwani: «Araɓi wameh soŋe cëm dëw̃u ŋa nkefu fuhnë gë vutah vuntëw̃ fu va!» ");
INSERT INTO cou_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Awa Pilat më tavëka Barabas do ntampehna Yesu tac njëɗahnëlehna paki hnë kërëwa. ");
INSERT INTO cou_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wasoɗaɗe Pilat w̃a më njoniha Yesu vëhni guverëner hna do wasoɗaɗe w̃a fop kwërënihaw̃o. ");
INSERT INTO cou_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Më cuɗëtëniha viỹi vilëw̃u va do cuɗëniha acuɗ cankaf mbëntah. ");
INSERT INTO cou_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tac më mbahnëhnëniha apënkw kwëhn wadëmpëhn, pënkwëlehnëniha do mënkwëndëniha fandoko vák rëhw hna. Tac ndëkwëhnëndëni haryënkw lëw̃u njafaŋëndëniha ntehnëndëniha: «Nkaỹiru, Ahnaw̃ Wasëwif!» ");
INSERT INTO cou_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Do tëpahnëndëniha do nufëni fandoko fa ntankahnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ante puhnani ƴafaŋ dëw̃u ŋa, më cuɗëtëniha cuɗ mbëntah ŋa, mbokaryëniha viỹi vilëw̃u va do njoniha soŋe pakëniha hnë kërëwa. ");
INSERT INTO cou_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ante cahnëɗëniho naw̃ hna, më pankëlëni g'asan avë Siren ale w̃aciko Simo; wasoɗaɗe w̃a më porosiŋëniha ndiɓ kërëwa Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Më tëkëni hn'ile macik Golëgota hna, umë fëhnëtanëɗ «Hëloƴoƴ». ");
INSERT INTO cou_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hnam, më njëɗaniha Yesu uñen ŋañah; ga njëkëk maw̃ëlohna ce. ");
INSERT INTO cou_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pakëlehnëniha kërëwa do njëlëniho wanjël njëtahnëni bi mo hwëhnëɗ viỹi vilëw̃u va. ");
INSERT INTO cou_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tac ntañalehnëni hnam njëkandëniha. ");
INSERT INTO cou_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Më pakëni ƴaŋ nkaf ntëw̃u hna vikerëh vinte fëƴahnëɗ soŋe ile pakahnik ỹa: «Aỹi Yesu ye, ahnaw̃ wasëwif w̃a.» ");
INSERT INTO cou_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Awa wabandi waki pakëlehniniho gë Yesu, aryampo g'irëhw do aỹëntaw̃ a g'irahahn. ");
INSERT INTO cou_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vële ryëcëɗëho cape tac va nkëlënkëlaɗëniho do njew̃ëndëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ntehnëɗënihawo: «Wëjë ale lehnëko koɗu ahnih Cery W̃ën Cankaf ŋa do avokary avëry hnë wafac warar, pehëtary wëjë dënk, ge Ajë W̃ënu ŋa yeru, cëlëry kërëwa hna!» ");
INSERT INTO cou_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Vësankaf vësëna wasaɗëha va fëna gë vëharaŋ sariya va do gë vicër va njafaŋëɗënihawo ntehnëndëniha: ");
INSERT INTO cou_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Pehëtëkëhni vahnë vëhaw̃ary, ɓare koɗina pehëta umë dënk! Ge paryi ahnaw̃ Isërayel ỹa ye araɓi cëli tame kërëwa hna tac kwëtahnëɗëfunëha. ");
INSERT INTO cou_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","W̃ënu ŋa kwëtahnëk do pëƴahnëk: “Ami ye Ajë W̃ënu ŋa.” Awa ƴëkënëfu, ge W̃ënu ŋa ñaɗëha, pehëta tame!» ");
INSERT INTO cou_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wabandi wante pakëlehniniho ŋa, vëhni fëna koyëna njew̃ëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lav a nkaf hna nkeho, mëhwëryëlehn fop nkal ŋa hafo hnë wëwati warar g'anent ga. ");
INSERT INTO cou_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ɗarël hnë wëwati warar hna, Yesu ndekako gë fanka: «Eli, Eli, lëma sabakëtani?» Umë fëhnëtanëɗ: «W̃ën mën, W̃ën mën, soŋe ye ravëruho?» ");
INSERT INTO cou_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Vëryampo hnë vële yeho hnam va nkwëryënihawo më ndekani ntehnëni: «Eli macëɗ!» ");
INSERT INTO cou_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aryampo hnë vëhni nkaryëlehn nuf ankwëỹ koƴ hn'uñen ŋañah. Tac, cob hn'usëmët ryoko do njelëhna Yesu soŋe ce. ");
INSERT INTO cou_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɓare vëỹëntaw̃ va më ntehnëni: «Napëryin, nuɗen ge Eli njijëɗ pehëta!» ");
INSERT INTO cou_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu më mbok ndekak gë fanka cëmëlehn. ");
INSERT INTO cou_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wati rac, ipand ɗëndah nte fokiko ɓambery Cery W̃ën Cankaf ŋa citako fagant pëgw ƴaŋ afo gëɗ. Nkal iŋa ñënkalehn, wëraka w̃a nihëko fagant, ");
INSERT INTO cou_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","wayag w̃a piɗëtalehn do vële hwëtahnëk vëyaɓah njënëniho. ");
INSERT INTO cou_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ga mbëhnëk Yesu cahnëlehnëni wayag hna do tënkëni Yerusalem hna, hn'inaw̃ cëvah hna; hnam vahnë vëyaɓah nunihëhniwo. ");
INSERT INTO cou_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Asankaf wasoɗaɗe wavë Rom w̃a gë wasoɗaɗe wale yëkaɗëhawo Yesu ỹa per, nuniho gante ñënkak nkal ka do g'ile liyako ỹa fop; awa ntakëlehnëhni ɗus, ntehnëlehnëni: «Paryi nke, aỹi Ajë W̃ën ỹa yeho!» ");
INSERT INTO cou_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vësëval vëyaɓah yentiko hnam do yëkëɗëhawo ŋaw̃ët: koɓëri Galile tëfëlehninihawo Yesu ndokuŋëhnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Hnë vëhni, nkentiniho hnam: Mari mbë Magëdala gë Mari hnëmu Sak gë Yosef, do gë hnëm hni viju Sebede. ");
INSERT INTO cou_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ante nëkako ŋa, asan avetak avë inaw̃ Arimasi tëkiko. Yosef maciko do arëfal Yesu yeho, umë fëna. ");
INSERT INTO cou_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Njiko tëƴa Pilat iñas Yesu ŋa. Awa Pilat më ntehnëkëhni vahnë va njëɗaniha. ");
INSERT INTO cou_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Arac më nufëk përyëka g'iƴarëh kasëk ");
INSERT INTO cou_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","do nji ndëna hn'iƴag dëw̃u nte nkabehnëko hn'itaka. Tac më këryiŋëtëk taka konah piɗahn rënka ỹa njilehn. ");
INSERT INTO cou_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari mbë Magëdala gë Mari ñëntaw̃ ŋa hnam nkentiniho; haryënkw ƴag hna ntañaniho. ");
INSERT INTO cou_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ga pacëk, hnë fac le rëfëka ile fëhwëtahnëɗe ntaw̃ëla ŋa, vësankaf vësëna wasaɗëha va gë wafarise w̃a njiniho ndampo fo vëhni Pilat hna ");
INSERT INTO cou_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","do ntehnëniha: «Ahwëhn nkal, ndënkwëtaɓun, ale rokaɗëhëhniw̃o vahn'aỹi më lehnëko, ante nkoko cëmëna ŋa: “Hnë wafac warar mbëhnëɗëfu.” ");
INSERT INTO cou_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Awa, maw̃ëryin ahwëtehnahnu iƴag iŋi hafo hnë wafac warar hna. Ge gena umë, vërëfal vëlëw̃u va njijëɗëni nteni ñas iŋa tac pëƴahnëni ɓulunda hna: “Mbëhnëk vësëm hna.” Wati rac, wamër watëkwa ŋi lëbëɗëha waɗënkwëryënkw ŋa.» ");
INSERT INTO cou_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat më ntehnëkëhni: «Wëlihëhni wasoɗaɗe w̃a soŋe njëkandëhni. Ƴiryin do diryin njëkande ƴag iŋa gante caŋahnëku ka.» ");
INSERT INTO cou_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Njilehnëni njëkandëni ƴag iŋa: më mbëryëni taka nte fiɗahniko rënka ŋa kahnëndëlehnënihëhni vëyëka va. ");
INSERT INTO cou_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ante ndëcëk fac ntaw̃ëla ŋa, gë dimasi ỹa wakëwak fo, Mari mbë Magëdala gë Mari ñëntaw̃ ŋa njiniho njëkini ƴag iŋa. ");
INSERT INTO cou_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nkal iŋa ñënkalehn taŋ gë fanka: mëleka Ahwëhn a cëlëlehni g'ambin, njij këryiŋët taka cankaf iŋa cape ndampo ntañalehn ƴaŋ. ");
INSERT INTO cou_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Had ambin wilëbilëk nkeho do cuɗ cankaf jah ɗus cuɗako. ");
INSERT INTO cou_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vëyëka va ntakëkëhniwo mbalëndëni ki fo; had vësëm nkeniho. ");
INSERT INTO cou_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mëleka ỹa më ntehnëkëhni vësëval va: «Antë ntaku, njëtëɓu Yesu yëkëlendun, ale fakiko kërëwa hna. ");
INSERT INTO cou_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gena hnani, W̃ënu ŋa mbëhnëndanëka gante nësëko ka. Ƴijën ayëku hn'ile kwëtiko hna. ");
INSERT INTO cou_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ƴiryin ñap afëƴawuni vërëfal vëlëw̃u va: “Mbëhnëndanik, tame njiɗ napëhëndu Galile hna; hnam nuɗunëha.” Umë ỹakëndëɓu fëƴaw̃u.» ");
INSERT INTO cou_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Matëlehnëni ñap ƴag hna ga ntakah do g'uhnatah sankaf, nkaryëni pëƴanihëhni vërëfal Yesu va wakasëk watac. ");
INSERT INTO cou_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesu njilehn pankëlëni do ntehnëhni: «Nkaỹëmu!» Tëhalehnëniha, pëlaniha wapary ŋi cëmbatëndëniha. ");
INSERT INTO cou_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Awa Yesu më ntehnëkëhni: «Antë ntaku. Ƴiryin afëƴawuni vëỹënta mën va njini Galile hna: hnam nuɗëniho.» ");
INSERT INTO cou_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wati nte njiɗëniho ŋa, wasoɗaɗe wëryampo wale yëkaɗëho ƴag ŋa mbokajëniho naw̃ hna pëƴanihëhni vësankaf vësëna wasaɗëha va fop ile liyak ỹa. ");
INSERT INTO cou_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Vësankaf vësëna wasaɗëha va më mbarëni gë vicër va: ga nkwëryëlëni më njëɗanihëhni wasoɗaɗe w̃a koryi yaɓah ");
INSERT INTO cou_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","do ntehnënihëhni: «Pëƴahnëɗun, vërëfal vëlëw̃u va yijëk g'umëɗ ga, hnë wati nte ndakërunëho wakwëɗ ŋa, nteni iñas iŋa. ");
INSERT INTO cou_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Do ge guverëner ỹa njëtak njëtëɓun gante nësëndëɓunëha ka do ntiɗëfun fere hara ñoñ diluhna.» ");
INSERT INTO cou_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wasoɗaɗe w̃a më teɓani koryi ỹa do ntini gante nkabini ka. Koyëna, campëko waŋi wanës wasëwif hna, hafo hnë fac vë dol ỹi. ");
INSERT INTO cou_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vërëfal pëhw g'aryaw̃ va njilehnëni gë Galile, hn'ikuŋ nte nkabëkëhniwo Yesu hna. ");
INSERT INTO cou_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ante nunihawo ŋa, cëmbënihawo; ɓare vëryampo hnë vëhni nkwajëlehnaɗëniho. ");
INSERT INTO cou_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu tëhakëhniwo do ntehnëhni: «Ucankaf ŋa fop njëɗayiɓu ambin hna do gë nkal li. ");
INSERT INTO cou_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awa ƴiryin hnë vahnë vëvë nkal vi fop do aliwuni vërëfal mën; ƴaryëryinëhni g'uw̃ac Rëm, g'Ajë do g'Iƴir Ipacah iŋa, ");
INSERT INTO cou_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","do karaŋëryinëhni maw̃ëhnëni fop ile lehnëmu ỹa. Do ƴëtëryin: gë w̃uhnë nkentëɗeɓu fac-wo-fac hafo wapuya ɗuniỹa hna.»");
INSERT INTO cou_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ani pëgwëk Wanës Wakasëk wante hnësëɗ soŋe Yesu Këris, Ajë W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aki pëgwëk gante nësëɗ hnë kayëte kila Esayi hna: «W̃ënu ŋa më lehnëk soŋe Arëhnayik a: “Cañëtëryiɗëfuha afaƴ mën a haryënkw hu pëhwëtëhni nkaw̃ ŋa.” ");
INSERT INTO cou_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nëparyin! Asan ryekaɗ wula hna, më lehnëɗ: pëhwëtëryin nkaw̃ Ahwëhn a, dinëndina vankaw̃ vacatah ɗus!» ");
INSERT INTO cou_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Awa, koyëna San Ayary a njiko wula hna ɗarël sën Yurëdan hna; njaryëɗëhëhniwo vahnë va ntehnatëndëhni: «Gwëcëtaryin vankeya va do ayaryiwu; W̃ënu ŋa tavëhnahnu wameh hun ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vële lëɗëk resiỹo vë Yuɗe va do gë vëvë inaw̃ Yerusalem va fop njiɗëniho vëhni San hna; putaɗëniho tase ɓulunda hna wameh wante ntini ŋa do San njaryëɗëhëhniwo hnë sën Yurëdan hna. ");
INSERT INTO cou_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Umë viỹi vile liyik gë wëñahn yonkomb ntiyaɗëho do ryil uyand ñëbaɗëho sah hna; vampul tokëɗëho do gë wadëj. ");
INSERT INTO cou_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pëƴaɗëhëhniwo kore ỹa: «Ale rëfiɗëho ỹa umë lëbëko; catëla dënk fëtahnu viỹëba wapary wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ami, hnë w̃ënka njaryëɗëmu, ɓare umë, g'Iƴir Ipacah W̃ënu ŋa njaryëɗëhu.» ");
INSERT INTO cou_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hara, hnë wati rac, Yesu Nasaret matiko, ankol ambë resiỹo Galile hna do San njaryëkawo sën hna. ");
INSERT INTO cou_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ante mëƴëtaɗëho Yesu w̃ënka ŋa, nuko taŋ ambin ŋa ga piɗëtaɗ do Iƴir Ipacah iŋa cëlëlehni hnë umë; gë fah mëntëlëniho. ");
INSERT INTO cou_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tac kopa vë g'ambin nkwëryëlehni ga ntehnëɗ: «Ajë mën ale ỹaɗëfu ɗus a yeru; gë wëjë nëŋëko ɗus.» ");
INSERT INTO cou_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga ndëcëk watac, Iƴir iŋa më cañëtëka taŋ Yesu wula hna. ");
INSERT INTO cou_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wafac wafëhw wahnah ñëw̃ëko wula hna, do njëkëhnahnëkawo Sintani menehna hnam. Gë wulaw̃ w̃a nkelahnëniho do wamëleka ŋa paɓënihawo. ");
INSERT INTO cou_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ante pëlayiko San ŋa, Yesu njiko Galile. Karaŋëɗëhëhniwo vahnë va Wanës Wakasëk W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ntehnëɗëho: «Wati ỹa tëkëk, Naw̃ W̃ënu ŋa tëhajëk; gwëcëtaryin vankeya hun va do kwëtahnëryin Wanës Wakasëk ŋa!» ");
INSERT INTO cou_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Fac ryampo, Yesu tëfary lant sankaf Galile hna njasëɗëho ante nukëhniwo vëfëla wuwis vëhi ŋa, Simo g'aheryu Andëre. Waryeƴët ntoŋëɗëniho lant hna pëlahnënihëhni wuwis. ");
INSERT INTO cou_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu më ntehnëkëhni: «Tëfino do ntiɗëmu vëfëla vahnë.» ");
INSERT INTO cou_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tavëlehnëni taŋ waryeƴ waheheya uw̃is w̃a tëfëlehnëndëniha. ");
INSERT INTO cou_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu më mbok njik ŋaw̃ët toƴe do më mbok nukëhni kat vëhni Sak g'aheryu San, viju Sebede vële yeho kulu lëw̃ hni hna. Waryeƴ walëw̃ hni w̃a pëhwëtëɗëniho. ");
INSERT INTO cou_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nundëhni tuŋ macëlehnëhni; tavëlehnëniha rëm hni, Sebede, kulu hna gë vëryokuŋ va, do tëfëlehnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu gë vërëfal vëlëw̃u va njiniho naw̃ Kaperënaỹum hna. Fac ntaw̃ëla wasëwif hna, Yesu tënkëko caliŋa hna do pëgw karaŋëndëhni vahnë va. ");
INSERT INTO cou_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vële hnëpaɗëhawo va pëmpëhnahnëkëhniwo gante karaŋëɗëhëhniwo ka, kaɓi gelohna gante karaŋëɗënihëhni vëharaŋ sariya ka; umë, g'ucankaf karaŋëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hnë wati rac dënk asan ale pëlako ƴine tënkëko caliŋa ntëw̃ hni hna do ndekako: ");
INSERT INTO cou_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ye ye yëbëlan fu, Yesu mbë Nasaret? Afërëkanëfu bi yijëru? Njëtëɓu ɗus ale yeru ỹa: Afacah ale paƴik W̃ën ỹa yeru!» ");
INSERT INTO cou_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu më ŋañënahnëka ƴine ỹa ntehna: «Ɗemëhnary do cahnëryehna aỹi asan!» ");
INSERT INTO cou_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ƴine ỹa më ñënkëka asan a gë fanka do më cahnëka ndekatënd ɗus. ");
INSERT INTO cou_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vahnë va fop pëmpëhnahnëkëhniwo ɗus do tëƴëlëndëniho: «Ye ga ye iŋi karaŋ kasëk nte yëɗahnik g'ucankaf ŋi? Aỹi asan wëla waƴine ŋa ntehnëɗëhëhni ntini iñë do maw̃ëndëniha!» ");
INSERT INTO cou_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Awa, pëgwiko taŋ nësënde soŋe Yesu ỹa resiỹo Galile hna fop. ");
INSERT INTO cou_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ante cahnëniho caliŋa hna Yesu njiniho gë Simo gë Andëre tere lëw̃ hni hna do Sak gë San fëna njintiniho. ");
INSERT INTO cou_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hara, hnëmu asëvalu Simo ndakëko, kaɓi mbahn iŋi njakëkawo; ga tëkëk Yesu, më pëƴaniha soŋe lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu më tëhaka, pëlaka vák ỹi, matëndëlehna. Yak mbahn w̃a tavëlehna do pëgwëlehn nëhëtëhnëndëhni. ");
INSERT INTO cou_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","G'anëka ga, ga njok lav a, vahnë va njinenëhniɗënihawo Yesu vële resëko va fop do gë vële pëlaniho waƴine. ");
INSERT INTO cou_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vahnë vëvë naw̃ va fop haryënkw rënka tere hna mbarëpëlëniho. ");
INSERT INTO cou_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu njërënëkëhniwo vëyaɓah vële resëko sifa wates wanëmpëlah do ntakëhniwo fëna waƴine waƴaɓah. Tavëlëhniwohna waƴine ŋa nësëni, kaɓi vëhni njëtëniho bi mo nke. ");
INSERT INTO cou_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wakëwak fo, Yesu matëko cahn naw̃ hna, nji ñëw̃ hn'ile njirëk, do hnam njëfaɗëho. ");
INSERT INTO cou_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simo gë vërëfëlëntaw̃u njilehnëni njëkëlehniniha; ");
INSERT INTO cou_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ga nuniha, më ntehnëniha: «Vahnë va fop njëkëlehnëɗënihi.» ");
INSERT INTO cou_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu më ntëkwakëhni: «Ƴinëfu sëñ haw̃ary, hnë vankol vamb ɗarël vi. Tëfëko fëƴahnu hnam fëna Wanës Wakasëk ŋa, kaɓi soŋe umë yijëɓu.» ");
INSERT INTO cou_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Do njilehnëni hnë Galile hna fop; pëƴaɗëhëhniwo Wanës Wakasëk ŋa vacaliŋa vamb resiỹo va do ntaɗëhëhniwo waƴine ŋa. ");
INSERT INTO cou_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ahwëhn mbiỹ ŋa më njijëk haryënkw Yesu ndëkwëhnëk do muntahna ntehna: «Ge ñaɗu, koɗu ayërëno, afacënëlehno.» ");
INSERT INTO cou_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu më kaỹëhnahnëka g'umë; më njelëk vák ỹa, ñaka do ntehna: «Ñaɗëfu: Pacëry!» ");
INSERT INTO cou_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taŋ, ambiỹ ŋa tavëlehna do pacënëlehni. ");
INSERT INTO cou_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Awa, Yesu më ŋañënahnëka, cañëta, ntehna: ");
INSERT INTO cou_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Nëpary ɗus, ant'afëƴahna ahnë waŋi; ƴiry njëki asëna wasaɗëha ỹa, do canëry saɗëha le kerëk Moyis ntinde ỹa. Koyëna vahnë va fop njëtëɗëni pacëru.» ");
INSERT INTO cou_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Asan a njiko, ɓare pëgwëko pëƴahnënd ile-wo-le hna ile yeha ỹa. Soŋe rac Yesu koɗilohna mbok tënk wahnaw̃ hna gante ñaɗ ka; hnë wëwac wayirah hna ñëw̃ëɗëho. Do vahnë va njijëɗëniho ỹalu hna matindëni gante-wo-gante. ");
INSERT INTO cou_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga ndëcëk wafac, Yesu më mbok njik Kaperënaỹum, do njëtayiko tere hna nke. ");
INSERT INTO cou_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kore vahnë varëpëlëko hnam, hafo golohna igwac wëla për hna rënka tere hna. Yesu Wanës Wakasëk ŋa pëƴaɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vësan tëkëlehnini, njonëhniniha Yesu ale ye vorovoro ndiɓini vësan vëhnah. ");
INSERT INTO cou_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ɓare wahoɗilohna tufëniha Yesu, vahnë va pëɓëniho. Awa më kaƴëni tëjëtëni ile rëjahnik cery ŋa ɓaƴ hn'ile nkeho Yesu hna; më cëlëndëniha ale yeho vorovoro ryakëko uway hna hatëh hante ntiniho hna. ");
INSERT INTO cou_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga nuk Yesu kwëtahn vëỹi vësan ŋa, më ntehnëka ale ye vorovoro ỹa: «Ajë mën, wameh hu ŋa tavëhniru.» ");
INSERT INTO cou_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Awa vëharaŋ sariya vëryampo, vële lañako hnam va, nahaɗëniho: ");
INSERT INTO cou_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Soŋe ye nësëɗ aỹi asan aki? W̃ënu ŋa njew̃ëɗ! Mo hoɗ tavëhn wameh? W̃ënu ŋa fo hoɗ!» ");
INSERT INTO cou_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu njëtëko taŋ itoñaŋ dëw̃ hni ŋa, më ntehnëkëhni: «Soŋe ye hnahaɗun aki? ");
INSERT INTO cou_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ge ntehnëɓu: “Wameh hu ŋa tavëhniru”, ma ge ntehnëɓu, “Matëry, ahnuf uway hu w̃a, ayas?” ryampo bi ỹak hnëŋëk nësi hnë waŋi? ");
INSERT INTO cou_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ɓare ñaɗëfu ayëtu: Ajë Ahn'a kwëhnak fanka tavëhna ahnë wameh ɗuniỹa li.» Awa Yesu më ntehnëka ale ye vorovoro ỹa: ");
INSERT INTO cou_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ami ntehnëɗëmi, matëry, nufëry uway hu w̃a aw̃ënc!» ");
INSERT INTO cou_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Matëlehn taŋ, nuf uway lëw̃u w̃a, cahnëlehn tase vahnë va fop. Soŋe umë, pëmpëhnahnëkëhniwo ɗus; umë cëmbëɗëniha W̃ënu ŋa ntehnëndëni: «Koɓëri nulëfuhna g'iỹin ki!» ");
INSERT INTO cou_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu gë tëfary lant sankaf Galile ka mboko nji. Vahnë vëyaɓah yihahniɗëhawo do karaŋëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga ndëcëɗ, më nuka Levi, aju Alëfe, ga ntañak biro hn'ile cosahnëɗe ỹatëtanke hna. Yesu më ntehnëka: «Tëfe!» Levi matëlehn, tëfa. ");
INSERT INTO cou_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tac Yesu tokëko roka tere Levi hna. Vërëf ỹatëtanke vëyaɓah gë vëw̃en tokëlandëniho do gë vërëfal vëlëw̃u va, kaɓi njaɓëniho sifa vahnë vërac hnë vële rëfalëɗëhawo hna. ");
INSERT INTO cou_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Vëharaŋ sariya vële yentiko gë wafarise va nunihawo Yesu ga tokëlandëni gë vëỹi vahnë fop, më tëƴënihëhni vërëfal vëlëw̃u va: «Soŋe ye tokëlahnëɗëni gë vërëf ỹatëtanke do gë vëw̃en vi?» ");
INSERT INTO cou_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu nkwëryëkëhniwo, më ntehnëkëhni: «Vële wok vëresëna va ɓalëlëhnihna g'ayërën, vëres va valëkëhni. Ƴijëla w̃acëw̃ëhni vële satëk, ɓare vëw̃en yijëɓu w̃acu.» ");
INSERT INTO cou_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Fac ryampo, vërëfalSan Ayary va gë wafarise w̃a cuŋëniho. Awa vahnë më njijëni tëƴëniha Yesu: «Soŋe ye cuŋëɗëni vërëfal San Ayary vi gë wafarise w̃i, do vërëfal hu vi vësuŋëɗina?» ");
INSERT INTO cou_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu më ntëkwakëhni: «Ntiyahnëku bi vëfaƴ iñël va koɗëni cuŋëni wati nte nkelahnëni g'ale ỹëlëɗ a? Koɗina nke koyëna! Wahoɗina cuŋëni ge g'ale ỹëlëɗ a nkolahnëni. ");
INSERT INTO cou_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɓare wati yejëk ile nufëhnandeniha ale ỹëlëɗ a; fac rac cuŋëɗëni. ");
INSERT INTO cou_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Ahnë kaɗëɗina ankwëỹ pand kasëk, nte wok kwëỹana ten, hn'ipand cër; ge gena më, ankwëỹ pand kasëk iŋa, ge ndagik, kwëỹaɗ do citëɗ pand cër iŋa do hatëh ha njankëɗ ɗus. ");
INSERT INTO cou_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ahnë taw̃ëɗina fëna uñen kasëk hnë waryëpët wasër; ge gena umë, uñen uŋa tënkenëɗ waryëpët w̃a: uñen uŋa ndehëtaɗ, waryëpët w̃a fëna përëkaɗ. Uñen kasëk uŋa hnë waryëpët wëhasëk taw̃ëɗe!» ");
INSERT INTO cou_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Hnë fac ntaw̃ëla ndampo, Yesu wëhaỹ ndëcëtaɗëniho gë vërëfal vëlëw̃u va. Ga njasëɗëni, vërëfal vëlëw̃u va pëgwëlehnëni nkubëndëni vantimp va do cemëndëni. ");
INSERT INTO cou_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wafarise wale yeho hnam w̃a, më tëƴëniha Yesu: «Ƴëkëry, soŋe ye ntiɗëni vërëfal hu vi ile nkok maw̃ëryana sariya fu ỹa ntiyi hnë fac ntaw̃ëla hna?» ");
INSERT INTO cou_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu më ntëkwakëhni: «Koɓëri karaŋëluhna bi ile ntiko David hnë fac ryampo ante mbalëkëhniwo do inte yokëhniwo, umë dënk gë vërëfëlëntaw̃u va? ");
INSERT INTO cou_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tënkëko cery W̃ën hna do tok mburu nte kwëtëhniko W̃ënu ŋa. Abiyatar yeho asëna wasaɗëha asankaf a wati rac. Sariya fu ỹa vësëna wasaɗëha va fo maw̃ëryanëko tokëni vamburu vatac, ɓare David nufëko do njëɗahni fëna vërëfëlëntaw̃u va.» ");
INSERT INTO cou_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu më mbok ntehnëkëhni kat: «Ntaw̃ëla ŋa soŋe ahn'a liyik; ahn'a diyina soŋe ntaw̃ëla. ");
INSERT INTO cou_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Soŋe umë, Ajë Ahn'a dënk ye Ahwëhn wëla fac ntaw̃ëla ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Fac ryampo, Yesu mboko tënk caliŋa hna. Asan ale cëmëko vák yeho hnam. ");
INSERT INTO cou_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wafarise w̃a njëkëɗënihaw̃o ɗus Yesu bi njërënëɗëha hnë fac ntaw̃ëla hna, kaɓi ñaɗëniho nuỹani ile pëƴahnëɗëni menëk pëlahni. ");
INSERT INTO cou_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu më ntehnëka asan ale cëmëko vák ỹa: «Matëry, ahahn fagant.» ");
INSERT INTO cou_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tac më tëƴëkëhni: «Ye ntehnëk sariya fu ỹa? Ntiyi ufërën hnë fac ntaw̃ëla hna ma uw̃eh? Afehëta ahnë icëm ma aryaw̃a?» Waỹaɗilohna ntëkwani. ");
INSERT INTO cou_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu njëkëkëhniwo vëhni fop ga ntavah do njiw̃ëhnahnëkawo fëna kaɓi ŋwëỹëni vëhwëtahnëɗina. Awa më ntehnëka asan a: «Ƴeli vák hu ỹi.» Njelëlehn do vák ỹa mbokalehna fërën fo. ");
INSERT INTO cou_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wafarise w̃a cahnëlehnëni caliŋa hna njini mbarëni gë wëlawo ahnaw̃ w̃a Eroɗ soŋe nësëlëni bi hak koɗëni ndaw̃ehnahnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu gë vërëfal vëlëw̃u va njiniho gë cape lant Galile ka do kore sankaf rëfëlehnëkaw̃o. Vahnë vërac Galile gë Yuɗe matiniho, ");
INSERT INTO cou_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","do gë Yerusalem, gë resiỹo Idumeya, gë resiỹo ile ye gë cape ñëntaw̃ Yurëdan ka do gë caharaɓ Tir gë Sidon. Wakore watac vëhni Yesu njijëniho, kaɓi njëtaniho ile ntiɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Awa Yesu më tëƴëkëhni vërëfal vëlëw̃u va njonëhniniha kulu kaƴ hnam kaɓi kore ỹa peñëlëɗëniho caharaɓ lëw̃u: ");
INSERT INTO cou_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","njërënëkëhniwo vahnë vëyaɓah, awa vëres va fop cëñëlëɗëniho soŋe ñakëniha vëhni fëna. ");
INSERT INTO cou_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Do ge vële pëlani waƴine va nunihawo, ndëkwëhnëɗëni haryënkw lëw̃u do ndekandëni: «Ajë W̃ënu ŋa yeru!» ");
INSERT INTO cou_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɓare Yesu ŋañënahnëɗëhëhniwo ntehnëndëhni ntë pëƴahnëni bi mo nke. ");
INSERT INTO cou_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kaƴëko hn'ikuŋ, macëkëhni vële tëhnako njijëni le nkeho hna do njiniho. ");
INSERT INTO cou_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Koyëna tahnëkëhniwo Pëhw gë Vëhi va do macëhni vëfaƴik soŋe tëfëlëndëni g'umë do paƴëndëhni pëƴahnëndëni Wanës Wakasëk ŋa, ");
INSERT INTO cou_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","do g'imëk ntandënihëhni waƴine ŋa. ");
INSERT INTO cou_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wëlihëhni Pëhw gë Vëhi va: Simo nte macëko Yesu Piyer; ");
INSERT INTO cou_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","gë Sak, g'aheryu San, vëhni vëhi tak viju Sebede yeho. Yesu Bowanerëges macëkëhniwo. Umë fëhnëtanëɗ «vësan vële mëntëlëni g'ufarat»; ");
INSERT INTO cou_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andëre, gë Filip, gë Barëtelemi, gë Matiye, gë Toma, gë Sak aju Alëfe, gë Tade, gë Simo ale hahnëndak soŋe nkal dëw̃ hni ŋa Kanan, ");
INSERT INTO cou_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","do gë Yuɗa Isëkariyot, ale yeɗ aroka Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tac Yesu më mbokak gë tere. Umë gë vërëfal vëlëw̃u va wahoɗilohna tokëni roka ỹa kaɓi hnam fëna vahnë vëyaɓah varëlëko. ");
INSERT INTO cou_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Vëvë tere lëw̃u va, ga njëtani watac, kahnëtalehnëni soŋe nji nufiniha, kaɓi ntehnëɗëniho: «Cenaka!» ");
INSERT INTO cou_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vëharaŋ sariya vële w̃atiko Yerusalem va ntehnëɗëniho: «Asankaf ƴine le w̃acik Belësebul ỹa fëlaka!» do kat: «Iỹi ƴine yëɗaɗëha fanka canahnëndëhni waŋi waƴine!» ");
INSERT INTO cou_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Awa Yesu më macëkëhni nësëhnëkëhni g'iŋi mëntëndëlehn: «Sintani hak koɗ cëna umë dënk? ");
INSERT INTO cou_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ge vële vankëk inaw̃ mëtëɗëni vëhni fo, naw̃ tac goɗina kahn; ");
INSERT INTO cou_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","do ge vële vankëk tere mëtëɗëni vëhni fo tere rac goɗina kahn. ");
INSERT INTO cou_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Awa ge Sintani mëtëryaɗ umë fo, ge ucankaf ntëw̃u ŋa gona mbank, goɗina nko kahn, tëkwëɗ. ");
INSERT INTO cou_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ahnë koɗina tënk hnë tere asan ahwëhn fanka do nuf hnapul lëw̃u ỹa, ge ñabëlahna ten asan ahwëhn fanka arac; ge ñabëka, koɗ nuf le-wo-le ỹa tere lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Toña ỹa fëƴaɗëmu: vahnë va, koɗe tavëhnini wameh wadëw̃ hni ŋa fop gë waƴew̃ wante njew̃ëɗëniha W̃ënu ŋa fop. ");
INSERT INTO cou_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɓare ale yew̃ëɗëha Iƴir Ipacah iŋa tavëhnëɗena muk, uw̃i w̃eh dihëtëɗena.» ");
INSERT INTO cou_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nësëhnëkëhniw̃o koyëna kaɓi vëhni lehnëɗëho: «Gë ƴine nkeni.» ");
INSERT INTO cou_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hnëmu Yesu gë vëheryu tëkëlehnini; ñëw̃ëni për hna do paƴëniha ahnë macehna. ");
INSERT INTO cou_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vahnë vëyaɓah lañako caharaɓ Yesu, më ntehnik: «Nëpary, hnëmuh gë vëhery hu për hna nkeni, macëɗënihi.» ");
INSERT INTO cou_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu më ntëkwakëhni: «Mo ye hnëm mën ỹa do gë vëhery mën va?» ");
INSERT INTO cou_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tac më njëkëkëhni vële lañako caharaɓ lëw̃u va do ntehn: «Ƴëkëryin, hnëm mën ỹa gë vëhery mën va ani nkeni. ");
INSERT INTO cou_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vële liɗ ile ñaɗ W̃ënu ŋa vëhni ye hnëm mën ỹa gë vëhery mën va.» ");
INSERT INTO cou_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu mboko pëgw karaŋëndëhni tëfary lant Galile hna. Kaƴëko hnë kulu ile yeho lant hna, ntaña kaɓi kore sankaf varëpëlëko caharaɓ lëw̃u. Ɗarël w̃ënka hna ñëw̃ëniho ");
INSERT INTO cou_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","do Yesu gë wahnës waɗindaryindan karaŋëɗëhëhniwo viỹë viyaɓah; hn'ikaraŋ dëw̃u hna ntehnëɗëhëhniw̃o: ");
INSERT INTO cou_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Nëparyin! Fac ryampo asan yiko ipahn uhnëɗa kaỹ dëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wati nte pahnëɗëho waŋëc ŋa, wëɗampo nkaw̃ hna njoko: wusëry w̃a më njijëni kohnëni. ");
INSERT INTO cou_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wëɗampo wëraka njoko ile nkok ƴaɓëna nkal. Waŋëc ŋa pëhnëlehn taŋ kaɓi nkal iŋa tëw̃ëlohna. ");
INSERT INTO cou_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ulav w̃a, ga njakëk, më kankënëk waƴor ŋa, kaɓi vënkahn va ƴaɓëlawohna. ");
INSERT INTO cou_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waŋëc wëɗampo hnë wadëmpëhn njoko. Wadëmpëhn ŋa më naỹëk do ndaw̃ uhnëɗa w̃a, ñoñ dëw̃ëlohna. ");
INSERT INTO cou_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɓare waŋëc wëɗampo nkal përën hna njoko; pëhnëko, naỹ do ntëw̃: wëɗampo waŋëc wafëhw warar (30), wakaw̃ary wafëhw imbëɗ g'iryaw̃ (60), do wakaw̃ary kat keme (100).» ");
INSERT INTO cou_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu më mbok ntehnëkëhni: «Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Vële rëfëlehnëɗëhawo kwëlëkwël va do gë vëfaƴik pëhw gë vëhi va, ga nkeni vëhni fo gë Yesu, më tëƴëniha soŋe wahnës waɗindaryindan w̃a. ");
INSERT INTO cou_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Më ntëkwakëhni: «Nuỹarun w̃uhnë uyët ile sow̃iko, hnësëɗ soŋe Naw̃ W̃ënu ŋa, ɓare vëỹëntaw̃ vi had uhnës uryindaryindan fo nkwëryëɗëni, ");
INSERT INTO cou_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","do koyëna: «“Koɗ njëkëni ɗus, ɓare hara wahnuɗina paryi, koɗ nkwëryëni ɗus ɓare hara ñoñ wayëtëna paryi, ge gena umë mbokajakëndëni gë W̃ën do W̃ënu ŋa tavëhnakëndëhëhni wameh wadëw̃ hni ŋa!”» ");
INSERT INTO cou_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tac Yesu më ntehnëkëhni: «Ƴëtëluhna ile ye uw̃i uhnës uryindaryindan? Awa hak koɗun ayëtu wahnës waɗindaryindan waỹëntaw̃ w̃a fop? ");
INSERT INTO cou_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ayam a wanës W̃ënu ŋa pahnëɗ. ");
INSERT INTO cou_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vëryampo had nkaw̃ nkeni le njoɗ wanës hna: ge tëk nkwëryëni, Sintani tëkiɗ teɓëhni wanës wante fahnik hnë vëhni ŋa. ");
INSERT INTO cou_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vëryampo had nkal kwëhn wëraka nkeni: nkwëryëɗëni wanës ŋa do g'uhnatah maw̃aɗëni. ");
INSERT INTO cou_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ɓare waravëɗina kwëhna vënkahn hnë vëhni, toƴe fo kwëtahnëɗëni. Ge ryëñah w̃a tëkëhnikëhni ma ge mbërehnini soŋe wanës W̃ënu ŋa, tavëɗëni taŋ kwëtahn iŋa. ");
INSERT INTO cou_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vëryampo kat nkeni had uhnëɗa ule yoɗ wadëmpëhn, umë ye vële wëryëɗ wanës, ");
INSERT INTO cou_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɓare wëɓal ỹi ɗuniỹa ŋa, iɓora hnapul ŋa, do g'iña ile-wo-le ŋa tënkëɗëhëhni, ndaw̃ëɗëni wanës ŋa do ñoñ dëw̃ëɗina. ");
INSERT INTO cou_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓare vëryampo, hn'inkal përën hna teɓaɗëni wanës ŋa: nkwëryëɗëni wanës ŋa, kwëtahnëɗëni do nkeni had ile lëw̃ëɗ, wëɗampo wafëhw warar (30), wañëntaw̃ wafëhw mbëɗ gë ryaw̃ (60), do wakaw̃ary kat keme (100).» ");
INSERT INTO cou_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tac Yesu më mbok ntehnëkëhni: «Ahnë pëɗëɗ bi lampu tac koɓ g'ancëhn ma kuyët hn'ipad? Gena bi kaŋëɗe ƴaŋ? ");
INSERT INTO cou_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ile sow̃ik ỹa fop tufahnëɗe, do ile sow̃iko hn'umëhwëry ŋa fop njoɗe humpen hna. ");
INSERT INTO cou_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu më mbok ntehnëkëhni kat: «Kwëtahnëryin nëf ile wëryëɗun ỹa! W̃ënu ŋa ñaŋëndëhu g'añëŋa nte ỹaŋahnëɗun w̃uhnë dënk ŋa do nkwënëɗëhu kat. ");
INSERT INTO cou_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaɓi ale hwëhnak ỹa nkwënënde; ɓare ale wok kwëhnana ỹa teɓëɗe wëla toƴe ile liyahnëka tëk nuỹa ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu më mbok ntehnëk kat: «Wëlin g'ile mëntëlëni Inaw̃ W̃ënu ŋa: asan fahnëɗ uhnëɗa kaỹ dëw̃u hna, ");
INSERT INTO cou_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","tac fac-wo-fac ndakënd g'umëɗ ga, matënd g'acahnëfëɗ ga. Waŋëc ŋa pëhnëɗ do naỹ hara ƴëtëna g'ante pëhnahnëk hafo naỹ ka. ");
INSERT INTO cou_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nkal iŋa, umë dënk fëhnëndanëɗ uhnëɗa w̃a: waƴor ŋa ten, tac uyat w̃a, do tëkwahn idaf waŋëc ŋa. ");
INSERT INTO cou_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Puhnand tuŋ waŋëc ŋa daf ŋa, asan a pëgwëlehn ndokuŋënd g'ikáca dëw̃u ŋa, kaɓi wati uhác w̃a rëkëk.» ");
INSERT INTO cou_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu më mbok ntehnëkëhni kat: «Ye hoɗen mëntëndëlehnin Inaw̃ W̃ënu ŋa? Gë iỹëhne uhnës uryindaryindan koɗen nkabahnin? ");
INSERT INTO cou_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","G'uỹëc atëh mutarëd mëntëlëni; ge pahnik, uỹëc rac ye ule ỹak vak w̃a waɓë ɗuniỹa li fop, ");
INSERT INTO cou_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ɓare ge naɗik naỹëɗ hafo ntëb wanëɗa wante ye sarëɗiŋ ŋa fop. Cantëɗ wahni wahnaỹah hafo wusëry w̃a koɗëni kofëndëni cën dëw̃u hna.» ");
INSERT INTO cou_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Koyëna karaŋëɗëhëhniwo Yesu g'iỹi sifa wahnës waɗindaryindan; gante koɗëni nkwëryëni ka nësëhnëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nësëhnëɗilëhniwohna hara gena gë uhnës uryindaryindan; ɓare ante nkeniho gë vërëfal vëlëw̃u va fo, wahnës waɗindaryindan w̃a fop nkabëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hnë fac rac ga nëkak, Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Ɗanëtanëfu gë cape ñëntaw̃ lant haɗi.» ");
INSERT INTO cou_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Më koyanihëhni kore ỹa; vërëfal va më njoniha Yesu hnë kulu le nkehahnëko hna. (Awa, kaɓi Yesu hnë kulu tëko nke, më koyanihëhni kore ỹa do pëgwëni ndanëtandëni.) Wakulu wakaw̃ary tëfëlëniho. ");
INSERT INTO cou_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tac sël sankaf pëgwëlehn cëlënd ɗus, wavonkëlo w̃ënka ŋa njohandëho kulu ỹa, hafo pëgw tëmpënd hnam w̃ënka ŋa. ");
INSERT INTO cou_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu haw̃ëhni kulu hna ndakëko wakwëɗ. Awa vërëfal vëlëw̃u va më nëgëtëniha ndekatëndëni: «Aharaŋ, cëm iŋa yeyinëk: kwëtahnëlihëfuhna bi nëf?» ");
INSERT INTO cou_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu, nëgalehn, ŋañënahna sël ỹa do ntehna lant ỹa: «Ñëw̃ëry ƴam! Ɗemëhnary!» Sël ỹa tëryalehn do njamëlehn fop. ");
INSERT INTO cou_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tac Yesu më ntehnëkëhni: «Soŋe ye ntakëku aki? Soŋe ye worun kwëhnaluhna kwëtahn?» ");
INSERT INTO cou_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓare vërëfal va ntakëkëhniwo ɗus, më ntehnëlëni: «Mo ga ye awa aỹi asan? Wëla sël ỹa gë wavonkëlo w̃ënka ŋa maw̃ëhnëɗëniha!» ");
INSERT INTO cou_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tëkëlehnëni gë cape ñëntaw̃ lant Galile ka, hn'inkal ɓulunda Gerasen hna. ");
INSERT INTO cou_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ga cëlëk Yesu kulu hna, asan cahnëlehni wayag hna, njijënd pankëlëni. Asan arac ƴine fëlakawo ");
INSERT INTO cou_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","do wayag hna ntëɗëko. Ahnë koɗilohna mbok ñaba, wëla gë vankënca; ");
INSERT INTO cou_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ñabëɗeho kwëlëkwël wapary ŋa gë wame waryëhwëra do wëɓák ŋa gë vankënca, ɓare nkubëɗëho waryëhwëra w̃a do mbëkëtëɗëho vankënca va. Ahnë mëkëɗilawohna tërya. ");
INSERT INTO cou_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndekaɗëho wayag hna do gë wahuŋ wale yeho tëfary lant hna g'umëɗ gë g'anent hara tëryëɗina, do cërehnaɗëho gë wëraka w̃a. ");
INSERT INTO cou_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Më nuka Yesu ŋaw̃ët; awa më nkaryëk nji ndëkwëhn haryënkw lëw̃u, ");
INSERT INTO cou_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","do ndeka gë fanka: «Ye ye yëbëlan fu, Yesu, Ajë W̃ën Hunte Sëpëk Fop? Këlami g'uw̃ac W̃ënu ŋa antë aliwo uw̃eh!» ");
INSERT INTO cou_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Asan a nësëko rac kaɓi Yesu tëko ntehna ƴine ỹa: «Cahnëryehna aỹi asan!» ");
INSERT INTO cou_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tac më tëƴëka: «Hak maciru?» Ƴine ỹa më ntëkwaka: «W̃ac mën w̃a “Njaɓëɓun” ye, kaɓi vëyaɓah yeɓun.» ");
INSERT INTO cou_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Do më këlaka antë canëhni nkal hna. ");
INSERT INTO cou_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kore sankaf vampëhëmpëh ryavëɗëho hnam, ɗarël kuŋ hna. ");
INSERT INTO cou_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Waƴine ŋa më këlaniha Yesu ntehnëni: «Cañëtëryifu rënkëfuni vaŋi vampëhëmpëh!» ");
INSERT INTO cou_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu më maw̃ëryanëkëhni. Awa waƴine ŋa cahnëlehnëniha asan a do njini tënkënihëhni vampëhëmpëh va. Hara kore vatac nkëhnëko tëkëni wawuli wahi (2,000) vampëhëmpëh. Nëñëlëlehnëni vampamb kuŋ hna njini ntëbani lant hna do cëmëlehnëni fop. ");
INSERT INTO cou_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vësan vële heryëɗëhëhniwo vampëhëmpëh va, nkaryëlehnëni nji pëƴahnëni watac naw̃ hna do gë wëhaỹ hna. Vahnë va njilehnini njëkëni ile liyak ỹa. ");
INSERT INTO cou_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tëkëlehnini hn'ile nkeho Yesu hna do nuniha asan ale pëlaniho kore waƴine ỹa: ntañako, ntiyako viỹi do hakili ỹa mbokakawo fërën fo. Ntakëlehnëhni. ");
INSERT INTO cou_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vële yantiko fop va më tëfëtanënihëhni ile yeha asan ale pëlaniho waƴine ỹa gë kore vampëhëmpëh ỹa. ");
INSERT INTO cou_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Awa, pëgwëlehnëni këlandëniha Yesu cahn resiỹo lëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wati nte kaƴëɗëho Yesu kulu ŋa asan ale yërënik a më tëƴëka maw̃ëryana tëfëlënti g'umë. ");
INSERT INTO cou_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ɓare Yesu maw̃ëryanëlawohna, më lehnëkawo: «Ɓokary gë ɓulunda hu, do afëƴahn fop ifërën ile ntinëhnëki Ahwëhn a kaɓi kaỹëhnahnëka gë wëjë.» ");
INSERT INTO cou_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Awa asan a njilehn pëgw pëƴahnënd hnë Wahnaw̃ Pëhw hna fop ile ntinëhnëkawo Yesu ỹa; do fop vële wëryëɗëhawo va pëɓëkëhniwo fëmpëhnahnah w̃a. ");
INSERT INTO cou_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu mbokako gë kulu ỹa gë cape ñëntaw̃ lant ka. Ga tëkëk hnam, kore sankaf varëpëlëko caharaɓ lëw̃u; ante nkeho tëfary w̃ënka ŋa, ");
INSERT INTO cou_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","tëkëlehni asankaf caliŋa ale w̃aciko Yayërus. Më nuka Yesu, ndëkwëhnëlehn haryënkw lëw̃u ");
INSERT INTO cou_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","do këlahna ɗus ntehna: «Këlami, fandag mën fa cëm iŋa nke. Ƴij arinda wëɓák ŋi afehëtahna!» ");
INSERT INTO cou_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu njilehnëni g'umë. Kore sankaf lapëhnakawo do peñëɗënihawo vacape va fop. ");
INSERT INTO cou_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hara asëval yentiko hnam ale njiɗëho sat koɓëri hnë wabëhn pëhw gë waki. ");
INSERT INTO cou_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Njiko hnë vëyehn vëyaɓah, ƴehna ŋa mbërehnëkawo ɗus, fop canëko koryi lëw̃u ỹa, ɓare ñoñ ɗemalawohna; nuko nkwënanda res w̃a. ");
INSERT INTO cou_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nkwëryëko ga nësëɗe soŋe Yesu ỹa. Awa më njijëk kamëhni lëw̃u kore hna ñak cuɗ Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ntehnaɗëho: «Wëla cuɗ ntëw̃u ŋa fo ỹakakëndëɓu njërakëndëɓu.» ");
INSERT INTO cou_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ga ñakëk, sat ỹa tëryalehna taŋ do njëtalehn njërëk res lëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wati rac dënk, Yesu njëtalehn fanka sahnëka. Më cahëtak gë kore tëƴëhni: «Mo ỹakëk cuɗ mën ŋa?» ");
INSERT INTO cou_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vërëfal vëlëw̃u va më ntëkwaniha: «Nuru kore ỹa peñëɗënihi gante-wo-gante, do arëƴënd: mo ỹakëko?» ");
INSERT INTO cou_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɓare Yesu njëkëkëhniwo caharaɓ lëw̃u, nuhahna ale lik watac a. ");
INSERT INTO cou_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Asëval a mbalëɗëho ntakah ŋa kaɓi njëtëko ile yehawo ỹa; awa më njijëk ndëkwëhn haryënkw Yesu do pëƴahna toña ỹa fop. ");
INSERT INTO cou_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu më ntehnëka: «Aryag mën, kwëtahn hu ŋa njërënëki. Ƴiryeyi gë ƴam do ures hu w̃a ɓokaniɗilihna.» ");
INSERT INTO cou_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Koyëna nkoko nësënd Yesu tëketëni vëfaƴik matini gë tere Yayërus do ntehnëniha: «Aryag hu gona. Ɓokawo avërehna Aharaŋ a.» ");
INSERT INTO cou_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ɓare Yesu kwëtahnëlohna nëf wanës wadëw̃ hni ŋa më ntehnëka Yayërus: «Antë ntaki, kwëtahnëry tuŋ.» ");
INSERT INTO cou_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Maw̃ëryanëlawohna ahnë ntapëhnahna gë tere Yayërus ge gena Piyer, do Sak g'aheryu San. ");
INSERT INTO cou_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tëkëlehnëni tere hna, Yesu nkwëryëko wëñaw̃ waƴaɓah, vëryampo koɗëniho, vëỹëntaw̃ va ndekaɗëniho. ");
INSERT INTO cou_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Më tënkëk tere hna do ntehnëhni: «Soŋe ye ỹaw̃ërun aki? Fandag fi cëmëna, wakwëɗ fo ndakëk.» ");
INSERT INTO cou_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓare njafaŋëɗënihawo. Awa më canëkëhni vëhni fop, nkoni rëmu fandag fa gë hnëmu do gë vërëfal vërar vëlëw̃u va do tënkëni cery nte nkehahnëko fandag hna. ");
INSERT INTO cou_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Më pëlaka vák ỹa do ntehna: «Talita Kum!» (Umë fëhnëtanëɗ: «Ntehnëɗëmi: Fandag, matëry!») ");
INSERT INTO cou_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Fandag fa matëlehn taŋ, pëgwëlehn njasënd (kaɓi wabëhn 12 kwëhnako). Wati nte nuniho cëmëna ŋa, pëmpëhnahnëkëhniwo ɗus. ");
INSERT INTO cou_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ɓare Yesu më ŋañënahnëkëhni ntehnëhni antë pëƴaniha ahnë; tac më ntehnëkëhni: «Ƴëɗaryina ile tokëɗ.» ");
INSERT INTO cou_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu matëko hnam nji hn'ankol nte naỹahnëko hna; vërëfal vëlëw̃u va ntapëhnanihawo. ");
INSERT INTO cou_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hnë fac ntaw̃ëla hna pëgwëlehn karaŋëndëhni caliŋa hna; vahnë vëyaɓah hnëpaɗëhawo do pëmpëhnahnëkëhniwo ɗus. Ntehnëɗëniho: «Ne ñëŋak iỹin? Ye ga ye yasery ule kwëhnak w̃i, do hak kolahnëk ntind uw̃i fëmpëhnahnah? ");
INSERT INTO cou_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Gena bi umë ye ali vacery va, aju Mari, acëru Sak, Yose, Yuɗ, do gë Simo? Vëheryu vësëval va vëlëɗëntina bi ani gë fuhnë?» Vëlënënëlaw̃ohna. ");
INSERT INTO cou_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Awa Yesu më ntehnëkëhni: «Kila ntënënik gante-wo-gante, ɓare gena nkol nte naỹahnëk hna, hnënk lëw̃u ỹa vëlënënëɗilahna, gë vëvë tere lëw̃u va per.» ");
INSERT INTO cou_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu kolëlohna nti hnam wëla fëmpëhnahnah ryampo, ge gena vëres vëryampo fo tindëko wëɓák ŋa do njërënëhni. ");
INSERT INTO cou_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Do pëmpëhnahnëkawo kaɓi vahnë vëvë nkol tac vi vëhwëtahnëna. Tac Yesu njiko karaŋëndëhni vankol vamb caharaɓ hna fop. ");
INSERT INTO cou_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Më macëkëhni Pëhw gë Vëhi va paƴëkëhni vëhi vëhi. Njëɗakëhniwo fanka g'ucankaf ntandënihëhni waƴine ŋa ");
INSERT INTO cou_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","do ntehnëkëhniwo aki: «Ant'ayoyawu ñoñ ge njiɗun, ge gena ryoko ryampo; ant'ayoyawu ile rokëɗun, kufa, koryi wakufa hun hna. ");
INSERT INTO cou_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Përyaryin wapary, ɓare ant'ayoyawu acuɗ kaw̃ary.» ");
INSERT INTO cou_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Më mbok ntehnëkëhni kat: «Ge tëkërun hn'inaw̃, ñëw̃ëryin hnë tere ile hacanderun hna fo hafo hale matëɗun hnam. ");
INSERT INTO cou_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ge vahnë vëvë naw̃ va ŋwëỹëni vëhacaɗiluhna ma vëhnëpaɗiluhna, cahnëryin hnam do avankatëndu ivëɗ vë wapary hun ỹa: umë njëtëɗëni vëlina fërën do W̃ënu ŋa nëŋëlahna gë vëhni.» ");
INSERT INTO cou_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pëhw gë Vëhi va më njini karaŋëndënihëhni vahnë va soŋe nkwëcëtani vankeya vantëw̃ hni va. ");
INSERT INTO cou_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ntaɗënihëhniw̃o waƴine waƴaɓah do njërënëɗënihëhniw̃o vëres vëyaɓah turatëndënihëhni wagu ŋa vankaf hna. ");
INSERT INTO cou_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ahnaw̃ a Eroɗ Antipas nkwëryëko ga nësëɗe soŋe Yesu ỹa, kaɓi w̃ac lëw̃u w̃a campëko gante-wo-gante. Vëryampo ntehnëɗëniho: «San Ayary a vëhnik! Soŋe umë kwëhnahnëk fanka ntihahnëɗ viỹë vifëmpëhnahnah.» ");
INSERT INTO cou_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vëhaw̃ary ntehnëɗëniho: «Kila Eli ye.» Vëhaw̃ary kat ntehnëɗëniho: «Kila le w̃ëntëlëk gë waɓë koɓëri ŋa ye.» ");
INSERT INTO cou_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eroɗ, ga nkwëryëk wante rëfëtaɗeho ŋa fop, më ntehnak: «San Ayary a ye! Ntëpëtehnëɓuha nkaf ŋa ɓare mbëhnik!» ");
INSERT INTO cou_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eroɗ pëlayehnëkawo San, ñabi, do cëɗëlehni soŋe Erodiyaɗ. Eroɗ ñëlëkawo mama nkehahnëko asëval aheryu Filip ");
INSERT INTO cou_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","do San ntehnëɗëhawo Eroɗ: «Sariya ỹa maw̃ëryana aỹëla asëval ahery hu ỹa!» ");
INSERT INTO cou_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Soŋe rac Erodiyaɗ ntavëkawo ɗus gë San do ñaɗëho ndaw̃ehna, ɓare koɗilohna ");
INSERT INTO cou_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kaɓi Eroɗ ntakëkawo g'umë; njëtëko asan asatah do asëvah ye do keryëɗëhawo. Ge nëpaɗëhawo, nëŋandëhawo igwëry wanës wadëw̃u ŋa ɓare ƴëtëlohna ile ntiɗ. ");
INSERT INTO cou_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ɓare hnë fac le ntihandëho ambënt fac ile nagahniko ỹa, Erodiyaɗ nuỹako fere fafërën ndaw̃ehnahna San. Fac rac Eroɗ ambënt cankaf ntiko, paƴehnëkëhniwo vësankaf vëvë ucankaf ntëw̃u ŋa, vësankaf wasoɗaɗe w̃a, do gë vëvë karyënkw Galile va. ");
INSERT INTO cou_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aryagu Erodiyaɗ tënkëko hn'ile nkeniho hna do nkaw̃ëhnëhni; Eroɗ gë vële macehnëko va per nëŋëkëhniwo gë fandag fa. Awa Eroɗ më ntehnëka fandag fa: «Tëƴërye ile-wo-le ỹaɗu ỹa, njëɗaɗëmi.» ");
INSERT INTO cou_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Njiko dënk hafo ntëkëhna aki: «Lëk njëɗaɗëmi lakënde ntehni cape ndampo inaw̃ mën iŋi rëƴëruho.» ");
INSERT INTO cou_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Fandag fa më cahnëk nji tëƴehna hnëmu: «Ye rëfëko rëƴu?» Hnëmu më ntëkwaka: «Nkaf San Ayary a.» ");
INSERT INTO cou_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fandag fa ntëfëlehn mboka gante nkeni ahnaw̃ gë vële macehnëko ka ntehna: «Ñaɗëfu ayëɗaw̃o tameki nkaf San Ayary a hn'ifëɗa mpan!» ");
INSERT INTO cou_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ahnaw̃ a njamëlehnëko; ɓare koɗilohna ŋwëỹëryana, kaɓi ntëkëko tase vële macehnëko va. ");
INSERT INTO cou_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Paƴëlehna taŋ soɗaɗe lëw̃u ryampo ntehna: «Ƴoj nkaf San Ayary a.» Soɗaɗe ỹa njilehn kaso hna ntëpëtehna San nkaf ŋa. ");
INSERT INTO cou_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tac njoj hn'ifëɗa njëɗahna fandag fa, do fatac njëɗaga hnëmu. ");
INSERT INTO cou_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vërëfal San va, ante njëtani watac ŋa, më njini nufëni ñas iŋa kwëtëni hn'iƴag. ");
INSERT INTO cou_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vëfaƴik va, ga mbokajëni vëhni Yesu hna, më pëƴaniha fop ile ntijëniho do karaŋinihëhniwo vahnë va. ");
INSERT INTO cou_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu më ntehnëkëhni: «Njijën, njiyin hn'ile njirëk soŋe ayinëgawu toƴe.» Kaɓi njaɓëniho vahnë vële yijëɗëho do yiɗëho va; Yesu gë vërëfal vëlëw̃u va wëla roka vëhoɗilohna tokëni. ");
INSERT INTO cou_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Awa më njini gë kulu hn'ile njirëk hna. ");
INSERT INTO cou_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɓare vahnë vëyaɓah nunihëhniwo ga njiɗëni do njëtëniho gante njiɗëni ka; më matëni vankol hna fop, nkaryëni gë wapary fo hafo ndënkwëhnënihëhni vëhni Yesu gë vërëfal vëlëw̃u va hnë ỹëw̃a le njihandëniho hna. ");
INSERT INTO cou_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ante cëlëko Yesu kulu hna do nutëhni kore sankaf vahnë vërac, kaỹëhnahnëkawo ɗus gë vahnë vërac, kaɓi had kore wape wante wok wahwëhnana ahekery mëntëlëniho. Pëgwëlehn karaŋëndëhni viỹë viyaɓah. ");
INSERT INTO cou_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","G'anëka ga vërëfal va më tëhaniha Yesu ntehnëniha: «Tëk mëɗ do hnani fëk fo ye. ");
INSERT INTO cou_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Koyaryihni vëỹi vahnë njini gë vankol vante ye caharaɓ vi ntëw̃ajëni ile tokëɗëni.» ");
INSERT INTO cou_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu më ntëkwakëhni: «Ƴëɗaryinëhni w̃uhnë dënk ile tokëɗëni ỹa!» Më tëƴëniha: «Ñaɗu bi yifu sanëfu koryi yaɓah law̃ahnifu vamburu yëɗafuni tokëni?» ");
INSERT INTO cou_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu më tëƴëkëhni: «Vamburu vajëhw hwëhnarun? Ƴiryin ayëku.» Umë njëkëni do ntehnëniha: «Vamburu mbëɗ g'uwis wuhi.» ");
INSERT INTO cou_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Awa Yesu më ntehnëkëhni dañëndëryinëhni vahnë va kore kore. ");
INSERT INTO cou_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vahnë va më ntañani keme keme do gë wafëhw imbëɗ, wafëhw imbëɗ. ");
INSERT INTO cou_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tac Yesu më nufëk vamburu mbëɗ va g'uwis wuhi w̃a, kaŋëk g'ambin do camehna W̃ënu ŋa soŋe iỹi rokëtok. Më nkubëlehnëk vamburu va njëɗahni vërëfal va cahëlehnënihëhni vahnë va do cahëlehnënihëhni fëna wuwis wuhi w̃a vëhni fop. ");
INSERT INTO cou_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ale-wo-le tokëko hafo pihn. ");
INSERT INTO cou_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vërëfal va njoniho vankubel vamburu va g'uwis wule tesëniho w̃a pëɓ vëkankel pëhw gë vaki. ");
INSERT INTO cou_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hnë vële rokëko hna vësan wawuli mbëɗ (5,000) yeho. ");
INSERT INTO cou_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tac Yesu kaƴëndëlehnëhni vërëfal vëlëw̃u va kulu hna ndënkwahëhniha gë cape ñëntaw̃ lant mbë ankol Betësayida ŋa. Hnë wati rac koyaɗëhëhniwo ɓulunda ỹa umë dënk. ");
INSERT INTO cou_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ante koyakëhniw̃o ŋa, Yesu njiko hn'ikuŋ soŋe njëfa. ");
INSERT INTO cou_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ga nëkak, kulu ỹa fagant lant hna nkeho, do Yesu umë fo woko nkal hna. ");
INSERT INTO cou_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Më nuk vërëfal vëlëw̃u va mbëraniho ƴiryery kulu ŋa ɗus, kaɓi sël ỹa pankëlëɗëniho; awa g'ankëhn fac ŋa, më njiɗ gante nkeni njasëhatënd ƴaŋ w̃ënka hna, do ñaɗëho ndëcëhni. ");
INSERT INTO cou_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ante nunihawo ga njasiɗ ƴaŋ w̃ënka hna, ntiyahnëkëhniwo ahnënkwël ye do më ndekaɗëni. ");
INSERT INTO cou_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vëhni fop nuɗënihawo do ntakëkëhniwo. Ɓare wati rac taŋ, Yesu më lehnëkëhniwo: «Ƴaw̃ënaryin! Ami Yesu ye; antë ntaku!» ");
INSERT INTO cou_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tac kaƴëlehn kulu hna, ɗarël lëw̃ hni, do sël ỹa tëryalehn. Vërëfal va pëmpëhnahnëlehnëhni ɗus, ");
INSERT INTO cou_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kaɓi ñoñ vëwëryëlohna ile ryëcëtako ante cahëlehnëko Yesu vamburu va: wahakili walëw̃ hni w̃a koɗilohna njët rac, ntëbëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ga ntëmpëtani lant ỹa Yesu gë vërëfal vëlëw̃u va, tënkëlehnëni hn'inkal ɓë resiỹo Senesaret hna. ");
INSERT INTO cou_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kulu hna cëlëɗëniho, njavëtatëniha taŋ va Yesu. ");
INSERT INTO cou_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vahnë va nkaryiniho nkal hna fop do njinenëhniɗënihawo vëres hnë waƴala, le-wo-le nkwëryëniho nke hna. ");
INSERT INTO cou_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hn'ile-wo-le njiɗëho Yesu hna, wahnaw̃ hna ma vankol hna, vahnë va njonëhnëɗënihaw̃o vëres vëlëw̃ hni va kwëtëndënihëhni waỹëw̃a ɓulunda hna do këlaɗënihaw̃o tavëhni ñakëhni wëla wacëmët cuɗ cankaf ntëw̃u ŋa fo; fop vële ỹakëko va njërëniho. ");
INSERT INTO cou_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wafarise gë vëharaŋ sariya vëryampo Yerusalem matiniho njijëni kwërëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kamahnëniho vërëfal vëryampo Yesu va gë wëɓák wante wok pacëna tokëɗëniho roka ỹa, (më lehnëɗe waỹuhnana gante maw̃ëryak namu ka). ");
INSERT INTO cou_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kaɓi wafarise w̃a gë wasëwif waỹëntaw̃ w̃a fop ntënënëniho wënamu wante taveryënihëhniw̃o vacërakëlo va: vërokëɗilohna hara waỹuhnana wëɓák ŋa hafo pacëhni ");
INSERT INTO cou_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","do ge matiniho gë saha, vërokëɗina hara vëfacënana ten. Ntënënëniho ɗus fëna wënamu wakaw̃ary, gante tëfëka ndagi vanëhëta, wapoti, do gë vapeƴa ka do gë wafad w̃a. ");
INSERT INTO cou_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Awa wafarise w̃a gë vëharaŋ sariya va më tëƴëniha Yesu: «Soŋe ye nkoni vërëfal hu vi vëlënënëɗina wënamu vacërakëlo fu va, tokëɗëni gë wëɓák wante wok pacëna?» ");
INSERT INTO cou_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu më ntëkwakëhni: «Vahnë vële hnësëɗ ile nkoni vëliɗina yerun! Kila Esayi toña kwëhnako ante nësehnëkawo W̃ënu ŋa soŋe lëw̃ hun ỹa. Aki kerëko: «“W̃ënu ŋa më lehnëk: ‘Iỹi ɓulunda gë wanës ŋi fo ntënënëɗëniho, ɓare wasakahn walëw̃ hni hna ŋaw̃ëtaniho. ");
INSERT INTO cou_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Icëmb nte cëmbëɗëniho ŋa kwëhnana nafa, kaɓi ile karaŋëɗënihëhni vahnë ỹa, gena ikaraŋ mën, ɓare ile karaŋëni vahnë fo ye.’” ");
INSERT INTO cou_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tavërun vakwëɗa W̃ënu va alënënahnu wënamu wante kahnëndëni vahnë.» ");
INSERT INTO cou_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tac më nkwënëk: «Kolërun ɗus aravu vakwëɗa W̃ënu va ahahnëndahnu namu lëw̃ hun dënk! ");
INSERT INTO cou_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wëlin ile ỹaɗëfu hnësu ỹa: Moyis më lehnëko: “Dënënëryihni vëhni rëmuh gë hnëmuh”, do fëna, “Ale lehnëka rëmu ma hnëmu wameh a tëfëka ndaw̃i.” ");
INSERT INTO cou_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ɓare w̃uhnë, karaŋëɗunëhëhni vahnë va: ge ahnë ntehnëka rëmu ma hnëmu: “Ile-wo-le wëkakëndëɓu yëɗayi ỹa ‘korëban’ ye.” Umë fëhnëtanëɗ: “Ile fehnik ntinëhnahni W̃ën saɗëha.” ");
INSERT INTO cou_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Koyëna tavëtentunëhëhni ntini ile ntehnëk sariya W̃ënu ŋa, alënëna rëmuh gë hnëmuh; ");
INSERT INTO cou_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ntihëtëɗun ile karaŋëɗ wanës W̃ënu ỹa gë namu le haraŋëɗunëhëhni ỹi. Do ntiɗun viỹë vihaw̃ary viyaɓah vile w̃ëntëlëk gë virac ki.» ");
INSERT INTO cou_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tac Yesu më mbok macëkëhni kore ỹa do ntehnëhni: «Nëparyino w̃uhnë fop, do awëryu: ");
INSERT INTO cou_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","iñë le tokëɗ ahnë koɗina tonkëna haryënkw W̃ën hna. Ɓare ile hoɗ tonkëna ỹa, umë ye ile sahnëɗ hnë umë ỹa. ");
INSERT INTO cou_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nëparyin ɗus ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ante tavëkëhniwo kore tënk tere ŋa, vërëfal vëlëw̃u va tëƴënihawo bi ye pëhnëtanëɗ wanës wadëw̃u ŋi. ");
INSERT INTO cou_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Awa më ntëkwakëhni: «W̃uhnë fëna, gwëryëɗiluhna bi? Gwëryëɗiluhna bi fop ile tokëɗ ahnë koɗina tonkëna haryënkw W̃ën hna ");
INSERT INTO cou_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kaɓi umë tënkëɗina ntaw̃ary dëw̃u hna, ɗonk dëw̃u hna tënkëɗ tac cahnëɗ mbahn dëw̃u hna?» (Gë waŋi wanës pëƴahnëɗëho Yesu koɗe toki ile-wo-le ỹa.) ");
INSERT INTO cou_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Umë mbok ntehnëk: «Ile sahnëɗ hnë ahnë ỹa umë ronkënëɗëha. ");
INSERT INTO cou_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaɓi ɓambery ntaw̃ary ahnë hna matiɗ vinahan vimeh vinte liyehnëɗëhëhni vahnë ndakëndëni hara vëyëlëlëna, ule, uryaw̃ ahnë. ");
INSERT INTO cou_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Njëkëlehnëɗëni ndakëntal meh vësan ma vësëval vële ỹëlëk do ỹëlik, iña le nkok kwëhnëna, njapënand, tokand vahnë, kwëhna nkeya meh, iñew̃ary, ntehnëndëhni wameh vëỹëntaw̃, naỹënand, do nënkw. ");
INSERT INTO cou_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Viỹë viw̃eh fop ɓambery ahnë hna cahniɗ do umë ronkënëɗëha.» ");
INSERT INTO cou_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu matëko hnam nji resiỹo Tir hna. Tënkëko le ñaɗëho ñëw̃ hna do ñaɗilohna njëti hnam nke, ɓare koɗilohna cow̃a. ");
INSERT INTO cou_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Asëval ale hwëhnakawo fandag fante pëlako ƴine wëryëko ga nësëɗe soŋe Yesu, njilehni taŋ hn'ile nkeho hna ndëkwëhn haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Asëval arac gelohna sëwif, hnë Fenisi mbë Siri hna nagiko. Muntaɗëhawo Yesu ntana ƴine ỹa aryagu hna. ");
INSERT INTO cou_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu më ntehnëka: «Tavëryihni tokëni ten vutah vi hafo pihnëni, kaɓi ƴivëna nufi roka vutah ỹa këfëhnini vumbe vi.» ");
INSERT INTO cou_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Asëval a më ntëkwaka: «Ɓare, Aharaŋ, la vumbe vi tokëɗëni ile këfëɗëni vutah ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Awa Yesu më ntehnëka: «Ha, toña hwëhnaru. Soŋe iŋi dëkwa, koɗu aw̃ënc gë ỹal hu: ƴine ỹa cahnëka aryag hu.» ");
INSERT INTO cou_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mëncëlehn nji tëkata aryagu ga ndakëk hn'ipad: ƴine ỹa cahnëkawo. ");
INSERT INTO cou_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tac Yesu matëlehn resiỹo Tir hna, tëf Sidon mboka gë cape lant Galile, tëfëlehn hnë resiỹo Wahnaw̃ Pëhw hna. ");
INSERT INTO cou_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Më njinenëhnijika asan kumim soŋe tinda wëɓák ŋa. ");
INSERT INTO cou_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Awa Yesu më pitaryëka umë fo, ŋaw̃ëtarya kore ỹa; më ndënëka watufa ŋa aryëŋënkaha vanëf hna do cëkëna vák ỹa gë wato ŋa ñakahna ryëw̃ ỹa. ");
INSERT INTO cou_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tac më kaŋëk g'ambin, njënëk bë sankaf do ntehna asan a: «Efata», umë fëhnëtanëɗ: «Piɗëtary!» ");
INSERT INTO cou_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Piɗëtalehna asan a vanëf va, ryëw̃ ỹa fëna pëtalehna do pëgwëlehn catënënd wanës ŋa. ");
INSERT INTO cou_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ntehnëkëhniwo antë pëƴahnëni; ɓare ante-wo-nte mbañëhnëɗëhëhniw̃o ŋa, vahnë va atac rëkëɗëniho campehnëndëni g'ahaw̃ary wanës ŋa. ");
INSERT INTO cou_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vahnë va pëmpëhnahnëkëhniwo ɗëcët; ntehnëɗëniho: «Ile ntiɗ ỹa fop caŋëk ɗus! Vëryëŋënkah va dënk nkwëryëndanëɗëhëhni do nësëndanëɗëhëhni vële wok vëhoɗina nësëni va!» ");
INSERT INTO cou_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hnë wati rac kore yaɓah voko mbarëpëlëni, do ñoñ golohna ile tokëɗëni. Yesu më macëkëhni vërëfal vëlëw̃u va ntehnëhni: ");
INSERT INTO cou_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Kaỹëhnahnëkow̃ëhni vëỹi vahnë, kaɓi wëli wafac warar yelahnëɓun do ñoñ vëworyaryëna ile tokëɗëni. ");
INSERT INTO cou_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ge koyaɓuhëhni mëncëni hara ñoñ vërokëna, mbërahëɗëni nkaw̃ hna, kaɓi vëyaɓah hnë vëhni ŋaw̃ët matini.» ");
INSERT INTO cou_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vërëfal vëlëw̃u va më ntëkwaniha: «Ne koɗen nuỹanëhninëhni ile tokëɗëni hafo pihnëni, hnë ỹi fëk?» ");
INSERT INTO cou_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu më tëƴëkëhni: «Vamburu vajëhw hwëhnarun?» Më ntëkwaniha: «Mbëɗ gë vaki.» ");
INSERT INTO cou_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Awa më ntehnëkëhni kore ỹa ntañani nkal hna. Tac më nufëk vamburu mbëɗ gë vaki va, camehnëka W̃ënu ŋa, nkubëlehnëk njëɗahni vërëfal vëlëw̃u va do vëhni, cahëlehnënihëhni vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kwëhnanihëhni fëna li vunkis toƴe. Yesu camehnëka W̃ënu ŋa soŋe vutac do ntehnëhni vërëfal vëlëw̃u va cahëlehnaryënihëhni. ");
INSERT INTO cou_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ale-wo-le tokëko afo pihn. Vërëfal va njoniho vankubel vante tesëniho va vëkankel mbëɗ gë vaki vapëɓah. ");
INSERT INTO cou_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hara vële rokëko va tëkëniho wawuli wahnah. Tac Yesu më koyakëhni mëncëni, ");
INSERT INTO cou_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kaƴëlehn taŋ kulu hna njini gë vërëfal vëlëw̃u va resiỹo Dalëmanuta hna. ");
INSERT INTO cou_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wafarise tëkëlehnëni do pëgwëni nkwajëlëndëni gë Yesu kaɓi menehnëniha njëkëhnahnëɗëniho. Umë tëƴëniha tufahn gë dahëse fëmpëhnahnah g'ambin matik. ");
INSERT INTO cou_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu më njënëk bë sankaf do ntehn: «Soŋe ye tëƴëɗëni vahnë vëvë gaki vi dahëse ile fëmpëhnahnëk? Toña ỹa fëƴaɗëmu: wëla dahëse ryampo wayëɗaɗena!» ");
INSERT INTO cou_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tac tavëlehnëhni do kaƴ kulu hna nji gë cape ñëntaw̃ mbë lant ŋa. ");
INSERT INTO cou_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vërëfal va ndënkwëniho njoni vamburu, ndampo fo kwëhnaniho kulu hna. ");
INSERT INTO cou_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu më ntehnëkëhni: «Diryin wajira! Keharyin levirwafarise w̃a do gë va Eroɗ ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vërëfal va pëgwëlehnëni nkwajëlëndëni vëhni fo kaɓi ntiyahnëkëhniw̃o ile nkoni vëhwëhnana vamburu ỹa ntehnëɗëhëhniw̃o koyëna Yesu. ");
INSERT INTO cou_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu njëtëko ile nkwajëlëɗëni ỹa, më ntehnëkëhni: «Soŋe ye wajëlëɗun kaɓi kwëhnaluhna vamburu? Nuɗiluhna bi ten? Gwëryëɗiluhna bi ten? Ndëpaku bi wahakili w̃i? ");
INSERT INTO cou_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kwëhnarun vinkër, nuɗiluhna bi? Kwëhnarun vanëf, gwëryëɗiluhna bi? Ɗënkwëtaɗiluhna bi ");
INSERT INTO cou_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ante nkubëlehnëɓuho vamburu mbëɗ soŋe vahnë wawuli mbëɗ ŋa vatesel vante yorunëho va, vëkankel vajëhw fëɓëko?» Më ntëkwaniha: «Pëhw gë vaki». ");
INSERT INTO cou_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mboko tëƴëhni: «Do nte nkubëlehnëɓuho vamburu mbëɗ gë vaki soŋe vahnë wawuli wahnah ŋa, vatesel vante yorunëho va, vëkankel vajëhw fëɓëko?» Më ntëkwani: «Mbëɗ gë vaki.» ");
INSERT INTO cou_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Awa Yesu më mbok ntehnëkëhni: «Do ha gaki gwëryëɗiluhna?» ");
INSERT INTO cou_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu gë vërëfal vëlëw̃u va tëkëniho Betësayida hna; hnam, më njonëhnijika mëp do këlayi ñaka. ");
INSERT INTO cou_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu më pëlaka mëp uŋa vák ỹi kaha cahnarya nkol hna. Tac më tëpahnëka vinkër va, tinda wëɓák ŋa do tëƴa: «Koɗu bi ahnu iñë?» ");
INSERT INTO cou_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mëp uŋa më matëndëk nkaf ŋa, njëk, do ntehn: «Vahnë hnuɗëfu, had vatëh nuɗëfuhëhni, ɓare njasëɗëni.» ");
INSERT INTO cou_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu më tindëka wëɓák ŋa kat mëp uŋa vinkër hna; arac më ŋesëk ɗus: njërëniko, nuɗëho wapacëk ile-wo-le ỹa. ");
INSERT INTO cou_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Awa Yesu më koyaka mënc gë ỹalu do ntehna: «Antë arënk tameki nkol hna.» ");
INSERT INTO cou_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tac Yesu gë vërëfal vëlëw̃u va njilehnëni gë vankol vante rëhak Sesare Filip hna. Nkaw̃ hna Yesu më tëƴëkëhni: «Vahnë va, mo ntehnëni yeɓu?» ");
INSERT INTO cou_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Më ntëkwaniha: «Vëryampo, vëhni lehnëɗ San Ayary a yeru, vëhaw̃ary Eli yeru, do vëhaw̃ary kat, aryampo wakila hna yeru.» ");
INSERT INTO cou_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu më mbok tëƴëkëhni: «W̃uhnë lë, mo lehnërun yeɓu?» Piyer më ntëkwaka: «Wëjë, Këris, Arëhnayik a yeru.» ");
INSERT INTO cou_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Awa, Yesu më ŋañënahnëkëhni antë pëƴaniha ahnë. ");
INSERT INTO cou_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tac Yesu pëgwëlehn karaŋëndëhni aki vërëfal vëlëw̃u va: «Ajë Ahn'a afo korot ɗus; vicër ɓulunda va gë vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va ŋwëỹëɗëniha; ndaw̃ehnëniha do fac rarëna hna mbëhnëɗ.» ");
INSERT INTO cou_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Watac wapacëk pëƴaɗëhëhniwo. Awa Piyer më canaryëka pëgwëlehn niranda. ");
INSERT INTO cou_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu më cahëtak, njëkëkëhni vërëfal vëlëw̃u va fop do ŋañënahna Piyer ntehna: «Ŋaw̃ëtarye, Sintani, kaɓi nahaɗila had W̃ënu ŋa, ɓare had vahnë.» ");
INSERT INTO cou_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tac Yesu më macëkëhni kore ỹa gë vërëfal vëlëw̃u va ntehnëhni: «Ge ahnë ñaɗ tëfëlehnëndo, antë nko nahand soŋe lëw̃u dënk, afo ndiɓ kërëwa lëw̃u ỹa tëfatëndo. ");
INSERT INTO cou_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ale ỹaɗ iỹi ɗuniỹa cëmëɗ, ɓare ale wok kwëtahnëna nëf iỹi ɗuniỹa nkoryaryëɗ ntaw̃ary dëw̃u ŋa, soŋe lëmën do gë Wanës Wakasëk ŋa, ntaw̃ary dëw̃u ŋa nkoɗ hafo araƴen hna. ");
INSERT INTO cou_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ye nëfaɗëha ahn'a ge umë hwëhnëk ɗuniỹa ỹi fop, tac cëvehn ntaw̃ary dëw̃u ŋa? ");
INSERT INTO cou_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ye koɗ njëɗahn mbësahni ntaw̃ary dëw̃u ŋa? ");
INSERT INTO cou_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ge ahnë cëfëhnëka g'ami do gë wanës mën ŋa haryënkw vahnë vëvë dol vi, vële wok vësatëna do wok vawëtahnëlahna W̃ën vi, awa Ajë Ahn'a fëna cëfëhnëɗëha g'umë, ge njijëk hn'idanc Rëm hna do gë wamëleka wapacah ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu më mbok ntehnëkëhni: «Toña ỹa fëƴaɗëmu; vëryampo hnë vële ye hnani vi vësëmëɗina hara vëhnuna Naw̃ W̃ënu ŋa ga njijëk gë fanka.» ");
INSERT INTO cou_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ga ndëcëk wafac mbëɗ gë ryaw̃, Yesu më njokëhni vëhni Piyer, Sak do gë San do njiryeryëhni hn'ikuŋ ƴihnah hn'ile nkeniho vëhni fo. Yesu më mbacik tase lëw̃ hni; ");
INSERT INTO cou_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","viỹi vilëw̃u va njerëko ɗus had humpen, hnë ɗuniỹa li ahnë gena ale hoɗ njerën iñë koyëna. ");
INSERT INTO cou_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Vërëfal vërar va nulehnënihëhni taŋ Eli gë Moyis ga nësëlëɗëni gë Yesu. ");
INSERT INTO cou_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Awa Piyer më ntehnëka Yesu: «Aharaŋ, njivëk nkeyin ani. Ntiɗëfun wasank watar: ryampo wëjë, Moyis ryampo, Eli ryampo.» ");
INSERT INTO cou_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ƴëtëlohna ile nësëɗ, kaɓi umë gë vërëfëlëntaw̃u va ntakëkëhniw̃o ɗëcët. ");
INSERT INTO cou_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aŋar njilehni cankëhni g'icën dëw̃u ŋa, do nkwëryëlehnëni kopa ŋar hna ntehn: «Aỹi Ajë mën ye ale ỹahnëɓu ɗus. Umë rëfëka ahnëpawu!» ");
INSERT INTO cou_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Vërëfal va njëkëlehnëni taŋ caharaɓ lëw̃ hni, ɓare golohna nundëniha ahnë, Yesu fo wontiko gë vëhni. ");
INSERT INTO cou_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ante cëliɗëniho kuŋ ŋa, Yesu më ntehnëkëhni antë pëƴaniha ahnë ile nuni ỹa hafo Ajë Ahn'a mbëhn hnë vësëm hna. ");
INSERT INTO cou_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Maw̃ëniho wanës watac, ɓare tëƴëlëɗëniho: «Ye pëhnëtanëɗ “iɓëhn hnë vësëm”?» ");
INSERT INTO cou_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tac më tëƴëniha Yesu: «Soŋe ye ntehnëɗëni vëharaŋ sariya vi, Eli yijëɗ ten?» ");
INSERT INTO cou_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Umë ntëkwakëhni: «Eli rëfëka njij ten mbokahn caŋ fop. Ɓare, ge toña ye, soŋe ye pëƴahnëɗ Vikerëh va fëna Ajë Ahn'a korotëɗ ɗus do ntiɗe g'iñew̃? ");
INSERT INTO cou_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ɓare ami pëƴaɗëmu: Eli tëko njij, do vahnë va ntinihawo gante ñaɗëni ka, gante pëƴahnëk vikerëh soŋe lëw̃u ka.» ");
INSERT INTO cou_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ga tëkëni hn'ile nkeniho vërëfal vëỹëntaw̃ hna, nunihëhniwo kore yaɓah ɗus ga kwërënihëhni do vëharaŋ sariya va conkëɗëniho. ");
INSERT INTO cou_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vahnë va nundëniha tuŋ Yesu, pëmpëhnahnëlehnëhni, nkaryëlehnëni nkaỹëniha. ");
INSERT INTO cou_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu më tëƴëkëhni: «Ye sonkëɗun gë vëỹi?» ");
INSERT INTO cou_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Asan aryampo kore hna më ntëkwaka: «Aharaŋ, njinenëhnimina ajë mën a, kaɓi ƴine fëlaka, umë w̃emaỹendëha koɗina nës. ");
INSERT INTO cou_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iỹi ƴine këfëɗëha hn'ile-wo-le hna, iguhnuhn rëkëɗ cahnënda w̃ës li, cemëlehnand wabeñ ŋi, do mbahn iŋi kankëɗëha. Tëƴëɓuhëhni vërëfal hu vi ntaniha iỹi ƴine, ɓare vëw̃ëkëlahna.» ");
INSERT INTO cou_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu më ntehnëkëhni: «Vahnë vëhwëhn kwëtahn këm yerun! Hafo guve tëfëko ñëw̃ëlahnin do ryuñënanëhnu? Ƴinenëhninow̃a fatah fi.» ");
INSERT INTO cou_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Awa më njinenëhnijika. Ƴine ỹa nunda tuŋ Yesu, më ñënkëka fatah fa gë fanka; fatac njolehn këryiŋëtand do guhnuhn iŋa cahniɗëhawo w̃ës hna. ");
INSERT INTO cou_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu më tëƴëka rëm fatah fa: «Koɓëri guve pëgwëka?» Më ntëkwak: «Koɓëri nte nkoko fatoƴ fo ŋa pëgwëkawo. ");
INSERT INTO cou_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wati ryaw̃ ƴine ỹa cañëtëɗëhawo hnë hwëɗëh ma hnë w̃ënka soŋe ndaw̃a. Kaỹëhnandiỹi gë fuhnë ayij aryemafu, ge koɗu!» ");
INSERT INTO cou_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu më ntëkwaka: «Ge koɗëfu? Fop koɗ nke soŋe ale hwëtahnëka.» ");
INSERT INTO cou_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rëm fatah fa ndekalehn taŋ: «Kwëtahnëɓu, ɓare ɗemarye, kaɓi kwëtahn iŋa nkojëko!» ");
INSERT INTO cou_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu nuko kore ỹa nkaryiɗëniho ỹal hni hna. Më ŋañënahnëka ƴine ỹa ntehna: «Ƴine ile w̃emaỹehnëɗ vahnë nësëni do nkwëryëni, ntehnëɗëmi: cahnëryehna faŋi fatah do nt'avoka vokanehna muk!» ");
INSERT INTO cou_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ƴine ỹa më ndekak do ñënka fatah fa gë fanka, cahnëlehna taŋ. Fatah fa njamëlehn had cëmëk, do vahnë vëyaɓah ntehnëɗëniho: «Cëmëk.» ");
INSERT INTO cou_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ɓare Yesu më pëlaka vák ỹa, matëndëka fatah fa do fatah fa kahnëlehn. ");
INSERT INTO cou_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ante tënkëko Yesu tere hna, nketëni gë vërëfal vëlëw̃u va fo, më tëƴëniha: «Soŋe ye woɓun mëkëlëfunahna lafuna iỹi ƴine?» ");
INSERT INTO cou_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu më ntëkwakëhni: «G'iƴëfa fo koɗe ntayini iỹi sifa waƴine.» ");
INSERT INTO cou_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Më matëni hnam tëfëni Galile. Yesu ñaɗilohna njëti hn'ile nkeho hna. ");
INSERT INTO cou_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Vërëfal vëlëw̃u va karaŋëɗëho aki: «Ajë Ahn'a njëɗaɗeniha vahnë va, vërac ndaw̃ehnëɗëniha; do ge ntik wafac warar mbëhnëɗ vësëm hna.» ");
INSERT INTO cou_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ɓare vërëfal va vëyëtëlohna bi ye pëhnëtanëk wanës watac do ntakëkëhniwo soŋe tëƴëniha. ");
INSERT INTO cou_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tëkëlehnëni Kaperënaỹum hna. Ante tënkëniho tere hna, Yesu më tëƴëkëhni vërëfal vëlëw̃u va: «Ye wajëlekëndun nkaw̃ hna?» ");
INSERT INTO cou_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɓare vëlëkwalohna, kaɓi nkaw̃ hna nkwajëliniho njëtahnëni bi mo lëbëkëhni vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Awa Yesu më ntañak, macëkëhni Pëhw gë Vëhi va do ntehnëhni: «Ge ahnë ñaɗ nke aryënkwëryënkw, tëfëka nke arëkwa vahnë fop do aryokuŋëhn vahnë fop.» ");
INSERT INTO cou_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tac më nufëka fatah fatoƴ kahnëndëka fagant lëw̃ hni; muryaka do ntehnëhni: ");
INSERT INTO cou_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ale hacaka g'uw̃ac mën w̃a fatah gë faŋi ki, kacako ami dënk; do ale hacako ỹa, gena ami fo kacak, ɓare kacaka fëna ale faƴiko ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","San më ntehnëka Yesu: «Aharaŋ, nuɓunëhawo asan ale laɗëhëhniwo waƴine g'uw̃ac lëw̃ hu w̃a, do ñaɗëfunëho ravëtehnëfuna, kaɓi gentina gë fuhnë.» ");
INSERT INTO cou_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ɓare Yesu më ntëkwaka: «Nt'aravëtehnuna, kaɓi ahnë koɗina nti dahëse fëmpëhnahnah g'uw̃ac mën w̃a tac nës taŋ wameh mën. ");
INSERT INTO cou_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ale wok ñew̃ëlëfuhna ỹa ndemaɗëhëfu. ");
INSERT INTO cou_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Do ale yëɗaɗëhu asiyawu w̃ënka kaɓi Arëhnayik a hwëhnëku, toña ỹa fëƴaɗëmu: nuỹaɗ cos dëw̃u ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ɓare ge ahnë ravëtehnëka kwëtahn iŋa wëla fatoƴ fëndampo hnë vunte hwëtahnëko vi, pecek bëraka gëb li tac ntabi hnë wov. ");
INSERT INTO cou_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ge vák hu ỹi liyehnëɗëhi uw̃eh, dëpëtary; pecek arënk ɗuniỹa le wok puɗina hna g'ivák iryampo g'ile woryaryëru waki tak do alabi gë janáma, hnë hwëɗëh hunte wok ɗipëɗina. ");
INSERT INTO cou_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hnam, “vancëhn vante rokëɗ mbahn va wasëmëɗina do hwëɗëh ha ɗipëɗina muk.” ");
INSERT INTO cou_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ge fary hu ỹa liyehnëɗëhi uw̃eh, dëpëtary; pecek arënk ɗuniỹa le wok puɗina hna g'ifary ryampo g'ile woryaryëru waki tak do alabi gë janáma. ");
INSERT INTO cou_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hnam, “vancëhn vante rokëɗ mbahn va wasëmëɗina do hwëɗëh ha ɗipëɗina muk.” ");
INSERT INTO cou_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Do ge inkër hu ŋa liyehnëɗëhi uw̃eh, dokëtary; pecek arënk Naw̃ W̃ën hna g'inkër ɗampo g'ile woryaryëru viki tak do alabi gë janáma. ");
INSERT INTO cou_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hnam, «“vancëhn vante rokëɗ mbahn va wasëmëɗina do hwëɗëh ha ɗipëɗina muk.” ");
INSERT INTO cou_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kaɓi, ale-wo-le hwëɗëh pihëɗe gante pihëɗe waŋiry hnë roka ki. ");
INSERT INTO cou_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Waŋiry ŋa iñë fërën ye; ɓare ge gona ŋañ, hak koɗe mbokaryi ŋañëni? Kwëhnaryin waŋiry hnë w̃uhnë dënk do ayewu ƴam gë vëỹënta hun va.» ");
INSERT INTO cou_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu matëko hnam nji hn'inkal Yuɗe hna, nte ye gë cape ñëntaw̃ Yurëdan ka. Kore vahnë va më mbok mbarëlëni kat ɗarël lëw̃u do pëgwëlehn karaŋëndëhni, gante njehëka ka. ");
INSERT INTO cou_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wafarise wëryampo më tëhaniha soŋe tëndëhnëniha urënd. Tëƴënihawo: «Sariya fu ỹa maw̃ëryanëka bi asan mbamba asëval alëw̃u?» ");
INSERT INTO cou_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu më ntëkwakëhni g'iŋi tëƴ: «Ye ntehnëkuno Moyis alindu?» ");
INSERT INTO cou_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Më ntehnëni: «Moyis maw̃ëryanëka asan a ker kayëte nte rufahnëɗ mbambëka asëval alëw̃u ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Awa Yesu më ntehnëkëhni: «Moyis kerëhnëku aŋa kwëɗa kaɓi vankaf va kambëku. ");
INSERT INTO cou_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Vikerëh va më lehnëk, wapëgwa hna, ante ntiko W̃ën fop ŋa: “Ntikëhni asan g'asëval.” ");
INSERT INTO cou_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Soŋe umë ye, asan a tavëɗëhëhni rëmu gë hnëmu nkeni g'asëvalu fo, ");
INSERT INTO cou_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","do vëhni vëhi tak aryampo fo nkeɗëni.” Koyëna, vëwona vëhi ɓare ahnë aryampo fo ye. ");
INSERT INTO cou_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Awa ahnë antë pitëndëlehn ile mbarëpëlehnëk W̃ën ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ga mbokani gë tere, vërëfal va më tëƴëniha Yesu soŋe watac. ");
INSERT INTO cou_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Më ntëkwakëhni: «Ge ahnë mbambëka asëvalu do ñëla ahaw̃ary, ntik ile mbañëk W̃ënu ŋa, ");
INSERT INTO cou_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","do age Asëval a tavëka asanu ñëla asan ahaw̃ary ntik ile mbañëk W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vahnë yinenëhnikawo Yesu vutah soŋe tindëhni wëɓák wadëw̃u ŋa ndëwahni, ɓare vërëfal vëlëw̃u va niranihëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu, ga nuk watac, më ntavëka do ntehnëhni vërëfal va: «Tavëryinëhni vutah va njijëni ỹal mën hna! Ant'aw̃emaỹehnuni, kaɓi Naw̃ W̃ënu ŋa vële ye had vëhni va hwëhnëk. ");
INSERT INTO cou_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Toña ỹa fëƴaɗëmu: ale wok maw̃ëlahna W̃ënu ŋa had gante maw̃ëhnëɗëhëhni fatah rëmu gë hnëmu ka tënkëɗina muk Naw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tac, më muryakëhni vutah va, tindëhni wëɓák wadëw̃u ŋa ale-wo-le ndëwanëhni. ");
INSERT INTO cou_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wati nte ñaɗëho nji Yesu ŋa, asan më nkaryëk ndënkwëhn do tëƴa: «Aharaŋ afërën, ye rëfëko liwu rënkahnu uwám usër hna?» ");
INSERT INTO cou_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu më ntëkwaka: «Soŋe ye w̃acëɗuho afërën? Ahnë afërën gena ge gena W̃ënu ŋa fo. ");
INSERT INTO cou_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Njëtëru bi vakwëɗa va: “Ant'aryaw̃a ahnë; ant'ayëkëlehna asëval ahaw̃ary; ant'ale; ant'aye seɗe wamër; ant'avorahna ahnë ahnufahn ile kwëhnak ỹa; dënënëryihni vëhni rëmuh gë hnëmuh.”» ");
INSERT INTO cou_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Asan a më ntëkwaka: «Aharaŋ, vaŋi vakwëɗa fop maw̃ëhnëɓu koɓëri utah mën hna.» ");
INSERT INTO cou_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu më njëkëka g'iŋahn do ntehna: «Iñë ryampo wojëki: ƴiryeyi awaf fop ile hwëhnaru ỹa do ayëɗahni koryi ỹa vëhaỹëhnah va, koyëna nuỹaɗu hnapul yaɓah ambin hna. Tac ƴij arëfëlehnëndo ami fo.» ");
INSERT INTO cou_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Asan a, ga nkwëryëk watac, mbacëlehn yëka ỹa do njilehn ayamah fo kaɓi hnapul yaɓah kwëhnako. ");
INSERT INTO cou_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu më njëkëkëhni vërëfal vëlëw̃u vële hwërëkawo va do ntehn: «Ntakëk vëvetak tënkëni Naw̃ W̃ën hna!» ");
INSERT INTO cou_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vërëfal va pëmpëhnahnëkëhniwo gë wanës watac, ɓare Yesu më mbok ntehnëkëhni kat: «Wëlawo mën, ntakëk ɗus tënk Naw̃ W̃ën hna! ");
INSERT INTO cou_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Itënk yonkomb hnë hatëh sirehn, ỹak hnëŋëk g'itënk avetak Inaw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vërëfal va pëmpëhnahnëkëhniwo g'ahaw̃ary, do tëƴëlëɗëniho: «Mo ye awa ale hoɗe pehëti ỹa?» ");
INSERT INTO cou_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu më njëkëkëhni do ntehnëhni: «Vahnë va vëhoɗina, ɓare W̃ënu ŋa koɗ, kaɓi W̃ënu ŋa koɗ nti fop.» ");
INSERT INTO cou_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Awa Piyer më ntehnëka: «Nëpary, fuhnë tavëɓun fop soŋe arëfëlehnahnënde.» ");
INSERT INTO cou_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmu: ge ahnë tavëk fop soŋe lëmën gë soŋe Wanës Wakasëk ŋa tere lëw̃u ỹa, ma vëheryu, vicëru, hnëmu, rëmu, vërahu, wëhaỹ walëw̃u, ");
INSERT INTO cou_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","awa ahnë arac nuỹaɗ wahwënta keme ntëbi ile kwëhnako hnë iỹi ɗuniỹa: watere, vëhery, vicër, wahnëm, warëm, vutah do gë wëhaỹ, gë horot fëna; nuỹaɗ ɗuniỹa ile wok puɗina wati le yejëk ỹi. ");
INSERT INTO cou_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɓare vahnë vëyaɓah hnë vële ye gaki vëryënkwëryënkw vi vërëkwa yeɗ, do vële ye gaki vërëkwa vi yeɗ vëryënkwëryënkw.» ");
INSERT INTO cou_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ndënkwaryëkëhniwo vërëfal vëlëw̃u va njindëni Yerusalem. Vërëfal va pëmpëhnahnëkëhniwo, do vële lapëhnaɗëhëhniwo va ntakëkëhniwo. Yesu më mbok canaryëkëhni vërëfal Pëhw gë Vëhi vëlëw̃u va pëgwëlehn nësëhnëndëhni, ile ỹaɗ nkehna hara ɓëỹëna ỹa. ");
INSERT INTO cou_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Më lehnëkëhniwo: «Nëparyin, gë Yerusalem njiɗen, ile njëɗaɗeniha Ajë Ahn'a vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va. Cëɗendëniha soŋe ndaw̃i do njëɗahnëɗëniha hnë vële wok vëyena wasëwif. ");
INSERT INTO cou_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Vërac njafaŋëɗëniha, tëpandëniha, ntampehnëɗëniha do ndaw̃ehnëniha. Ge ntik wafac warar mbëhnëɗ vësëm hna.» ");
INSERT INTO cou_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Awa, Sak gë San, viju Sebede, më njijëni vëhni Yesu hna, tëƴëniha: «Aharaŋ, ñaɗëfun alinëhnëfu ile rëƴëɗeru ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu më tëƴëkëhni: «Ye ỹaɗun linëhnu?» ");
INSERT INTO cou_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Më ntëkwaniha: «Maw̃ëryanëryifu yefu ɗarël hu ante nkeɗu hn'inaw̃ le naw̃ëɗu hna, aryampo g'irëhw aỹëntaw̃ a g'irahahn.» ");
INSERT INTO cou_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu më ntëkwakëhni: «Ƴëtëluhna ile rëƴëɗun ỹi. Koɗun bi asewu nkëlëw̃a tëmpah horot le ỹaɗëfu sewu ỹi, ma ayaryiwu yary horot ile ỹaɗeɓu yaryiwu ỹi?» ");
INSERT INTO cou_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Më ntëkwaniha: «Koɗëfun.» Yesu më ntehnëkëhni: «Ha, ceɗun nkëlëw̃a nte ỹaɗëfu sewu ŋi do njaryëɗerun yary ile ỹaɗeɓu yaryiw̃u ỹi. ");
INSERT INTO cou_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ɓare gena ami rëhnaɗ ale rëfëka ntaña g'irëhw mën ma g'irahahn mën; waỹi waỹëw̃a, vële pëhwëtëhnëk W̃ën va hwëhnëk.» ");
INSERT INTO cou_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vërëfal pëhw vëỹëntaw̃ va, ga nkwëryëni watac, ntavëkëhniwo gë viju Sebede. ");
INSERT INTO cou_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Awa Yesu më macëkëhni vëhni fop ntehnëhni: «Njëtërun, vële hnuɗe had vësankaf ɗuniỹa vi, nɗëcëtëni ucankaf ntëw̃ hni ŋa, do vëryëndah va tufahnëɗëni fanka falëw̃ hni fa. ");
INSERT INTO cou_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ɓare geɗina koyëna yëbëlan hun. Ale-wo-le ỹaɗ naỹ hnë w̃uhnë ỹa, tëfëka nke aryokuŋëhn hun, ");
INSERT INTO cou_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","do ge ahnë ñaɗ nke aryënkwëryënkw hnë w̃uhnë, tëfëka nke aramp vahnë fop. ");
INSERT INTO cou_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kaɓi Ajë Ahn'a ƴijëna umë dënk soŋe ndokuŋëhni, ɓare had aryokuŋëhn vahnë njijëk do njëɗahn ntaw̃ary dëw̃u ŋa pehëtahnëhni vahnë vëyaɓah.» ");
INSERT INTO cou_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu gë vërëfal vëlëw̃u va tëkëlehnëni Seriko hna. Tac, ante cahnëɗëniho naw̃ hna gë kore sankaf, mëp, nte w̃acik Barëtemi, aju Timawus, lañako tëfary nkaw̃ hna muntand. ");
INSERT INTO cou_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga nkwëryëk Yesu mbë Nasaret ryëcëɗ, pëgwëlehn ndekand: «Yesu, Aju David, kaỹëhnahnëryiỹi g'ami!» ");
INSERT INTO cou_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vëyaɓah niraɗënihawo ndemëhna, ɓare umë nkwënëko ɗeka ŋa: «Aju David kaỹëhnahnëryiỹi g'ami!» ");
INSERT INTO cou_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kahnëlehn do ntehn: «Macëryina.» Macëlehnëniha mëp uŋa ntehnëniha: «Ƴaw̃ënary, matëry, macëɗëhi.» ");
INSERT INTO cou_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Awa mëp uŋa ntoŋëlehn cuɗ cankaf ntëw̃u ŋa, ntoŋa kahn do nji gante nke Yesu. ");
INSERT INTO cou_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu më tëƴëka: «Ye ỹaɗu linëhnu?» Mëp uŋa më ntëkwaka: «Ahwëhn, voka hnundu ỹaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu më ntehnëka: «Ƴiryeyi, kwëtahn hu ŋa njërënëki.» Taŋ mbokalehn nund, tëfëlehnëlehna Yesu nkaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ante njiɗëniho Yesu gë vërëfal vëlëw̃u Yerusalem ŋa tëkëniho kuŋ nte w̃acik Oliviye, ɗarël vankol Betëfase gë Betani hna. Yesu më paƴëkëhni vërëfal vëhi haryënkw ntehnëhni: ");
INSERT INTO cou_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Ƴiryin hn'ankol nte ye haryënkw hun ŋi. Ge tëkërun tuŋ, tëkatëɗunëha fapali ga pokik, fante woyik kaƴina ten, pëtina, ayojuna. ");
INSERT INTO cou_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ge ahnë tëƴëku: “Soŋe ye liɗun rac”, dehnëryina: “Ahwëhn a valëka, ɓare mbokaryiɗëha hara ɓëỹëna.”» ");
INSERT INTO cou_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Awa njilehnëni tëkatëniha fapali për hna, nkaw̃ hna, ga pokik hnë rënka tere. Pëtëlehniniha. ");
INSERT INTO cou_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vëryampo hnë vële yeho hnam va më tëƴënihëhni: «Ye liɗun aki? Soŋe ye fëtërunëha faŋi fapali?» ");
INSERT INTO cou_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Më ntëkwanihëhni ile ntehnëkëhniwo Yesu ỹa, do tavëlehnini njini. ");
INSERT INTO cou_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Njonëhnëniha fapali fa Yesu; tindëniha vacuɗ vantëw̃ hni va fapali fa, tac Yesu kaƴa. ");
INSERT INTO cou_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vahnë vëyaɓah ntanëɗëniho vacuɗ vantëw̃ hni va nkaw̃ hna njitënd do vëryampo, yaryef yale nkubiniho fëk ỹa ntanëndënihawo. ");
INSERT INTO cou_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vële tëfëlëniho va fop ndekaɗëniho: «Osana! W̃ën, ɗemaryifu! Araɓi W̃ënu ŋa njëɗa ale yijëɗ g'uw̃ac Ahwëhn a! ");
INSERT INTO cou_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Araɓi W̃ënu ŋa njëɗa naw̃ nte yejëk ŋi, naw̃ David rëm fu ỹa! Ɗemaryifu, W̃ën Hunte Sëpëk Fop! Osana!» ");
INSERT INTO cou_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu tëkëko Yerusalem hna do nji selele Cery W̃ën Cankaf hna. Ga njëkëk hn'ile-wo-le hna toƴe caharaɓ lëw̃u, njilehnëni Betani gë Pëhw gë Vëhi va, kaɓi tëko mëɗ. ");
INSERT INTO cou_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga pacëk, wati nte cahnëɗëniho Betani ŋa, Yesu inte yokawo. ");
INSERT INTO cou_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Më nuk ŋaw̃ët anuỹ nte hnëpëko, njilehn njëk bi tëkatëɗ ga ntëw̃ëk; ɓare ga tëkëk yaryef fo tëkatëko, kaɓi tëkëlohna ten wati nte ntëw̃ahnëɗ wanuỹ ŋa. ");
INSERT INTO cou_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Awa Yesu më ntehnëk anuỹ ŋa: «Ɓokëɗila alëw̃ muk!» Vërëfal vëlëw̃u va nkwëryëniho wanës watac. ");
INSERT INTO cou_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Awa tëkëlehnëni Yerusalem hna. Yesu tënkëko selele Cery W̃ën Cankaf hna pëgwëlehn ntandëhni vële wafëɗëho do law̃ëɗëho va; këfëko wataɓali vëwëcët koryi do gë watinki vëwaf wëfah va, ");
INSERT INTO cou_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","do wëla aryampo tavëlawohna njo ñoñ Cery W̃ën Cankaf hna. ");
INSERT INTO cou_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tac më karaŋëkëhni aki: «Gena bi vikerëh hna W̃ënu ŋa më lehnëk: «“Cery mën ŋa, Cery iƴëfa soŋe ɓulunda fop macëɗe”?» Do nkwënëko: «Ɓare w̃uhnë sow̃a vële lirun!» ");
INSERT INTO cou_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va njëtaniho watac do njëkëlehnaɗëniho fere ndaw̃ehnahnëniha Yesu; ɓare ntakëkëhniwo g'umë kaɓi kore ỹa fop nëŋahnëkëhniwo gante karaŋëɗëhëhniwo ka. ");
INSERT INTO cou_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga nëkak Yesu gë vërëfal vëlëw̃u va cahnëniho naw̃ hna. ");
INSERT INTO cou_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga pacëk koɓëri fo, ante ndëcëɗëniho nkaw̃ ŋa, nuniho anuỹ ŋa kankëko fop hafo vënkahn hna. ");
INSERT INTO cou_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyer më ndënkwëtak ile liyako ỹa më ntehnëka Yesu: «Aharaŋ, ƴëkëry anuỹ nte ryëwanëruho antë mbok tok ahnë muk ŋa, kankëk fop.» ");
INSERT INTO cou_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Awa Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Kwëtahnëryina W̃ënu ŋa! ");
INSERT INTO cou_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Toña ỹa fëƴaɗëmu, ge ahnë ntehnëka iŋi kuŋ: “Matëry ani ayi alëba wov hna”, ge gwajëlehnaɗina ntaw̃ary dëw̃u hna, ɓare kwëtahn ile nësëɗ ỹa ntiyaɗ, awa watac ntiyaryëɗëha. ");
INSERT INTO cou_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Soŋe umë, lehnandëmu; ge muntaɗun soŋe arëƴu iñë, kwëtahnëryin paryi nuỹaɗun do irac njëɗaɗerun. ");
INSERT INTO cou_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ge muntaɗun, hara ahnë lavëkuna, tavëhnëryina, do tavëhnahnu Rëmun ile ye g'ambin ỹi fëna ile w̃enërun ỹa. ");
INSERT INTO cou_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ɓare ge tavëhnëɗilunëhnihna vëỹëntaw̃ va, Rëmun ile ye g'ambin ỹi fëna tavënhnëɗiluhna wameh hun ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu gë vërëfal vëlëw̃u va mboko mbokani gë Yerusalem. Wati nte njasëlehnëɗëho Yesu selele Cery W̃ën Cankaf hna, vësankaf vësëna wasaɗëha va, vëharaŋ sariya va gë vicër va më tëhaniha. ");
INSERT INTO cou_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tëƴëniha: «Gë fanka iỹëhne ntiɗu vëỹin? Mo lehnëki alind?» ");
INSERT INTO cou_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu më ntëkwakëhni: «Iñë ryampo fo rëƴëɗëmu; ge ntëkwarunëho, awa pëƴaɗëmu fanka fale lihahnëɗëfu vëỹin va. ");
INSERT INTO cou_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mo faƴikawo San njaryënd? W̃ënu ŋa bi ye ma vahnë va ye? Dëkwaryino.» ");
INSERT INTO cou_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pëgwëlehnëni nkwajëlëndëni vëhni fo ntehnëndëni: «Ge ntëkwayinëk: “W̃ënu ŋa faƴikawo”, tëƴëɗëhëfu bi soŋe ye woyinëk kwëtahnilënahna? ");
INSERT INTO cou_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɓare ge ntëkwayinëk: “Vahnë va faƴikawo...”» Ntakëkëhniwo gë kore ỹa, kaɓi vahnë va fop nahaniho San kila paryi yeho. ");
INSERT INTO cou_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Awa më ntëkwaniha Yesu: «Ƴëtëlëfuhna.» Yesu më ntehnëkëhni: «Ami fëna pëƴaɗiluhna sifa fanka fale lihahnëɗëfu vëỹin va.» ");
INSERT INTO cou_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tac Yesu pëgwëlehn nësëhnëndëhni gë wahnës waɗindaryindan: «Nkeho asan ale fëlëko kaỹ waresen, do kece, tac mbëry ile rëkëɗe ŋwëỹehnahnënde waresen w̃a do pël iɗe nte rëkëɗe njaw̃ahnënde kaỹ iŋa. Tac, kwëtehnahnëkëhni vëyam njilehn uyas. ");
INSERT INTO cou_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wati ɓarëp hna, më paƴëka aryokuŋ a alëw̃u aryampo nji vëyam hna njëɗajëniha sah lëw̃u w̃a hn'ile mbarëpëni hna. ");
INSERT INTO cou_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɓare vëyam va më pëlaniha aryokuŋ a, ndafëniha, ntalehnëniha wëɓák fo. ");
INSERT INTO cou_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Awa ahwëhn kaỹ a më paƴëka aryokuŋ ahaw̃ary; arac më ndafëniha nkaf hna do njew̃ëniha. ");
INSERT INTO cou_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ahwëhn kaỹ a më mbok paƴëka kat ahaw̃ary; arac, më ndaw̃ëniha. Do koyëna ntinihëhniwo vëhaw̃ary vëyaɓah: ndafënihëhni vëryampo, vëỹëntaw̃ va ndaw̃ënihëhni. ");
INSERT INTO cou_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Ahwëhn kaỹ a asan aryampo fo nkoryaryëko: aju ale ñaɗ ɗus a yeho. Më paƴëka aju rëkwa ỹa gë vëyam kaɓi ntehnëko: “Ntënënëɗëniha ajë mën aỹi.” ");
INSERT INTO cou_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Ɓare vëyam va më ntehnëlëni: “Wëliho ale lëw̃ëɗ a! Ƴinëfu, ndaw̃ina, tac fuhnë hwëhnëɗen kaỹ iŋi!” ");
INSERT INTO cou_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Më pëlaniha aju ahwëhn kaỹ iŋa, ndaw̃ëniha do canëniha kaỹ hna.» ");
INSERT INTO cou_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Awa Yesu më tëƴëkëhni: «Hak ntiɗëhëhni ahwëhn kaỹ iŋi? Njijëɗ umë dënk ndaw̃ëhni vëyam vi do kwëtehnahnëhni vëyam vëhaw̃ary. ");
INSERT INTO cou_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Karaŋëluhna bi waŋi wanës W̃ën? «“Itaka inte cañëtaniho vëvëry vacery ŋa vacak ye tame inte mbëryahnëk W̃ënu ŋa cery ntëw̃u ŋa fop. ");
INSERT INTO cou_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ahwëhn a lik umë do nkwamëk ɗus njëki!”» ");
INSERT INTO cou_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Vësankaf wasëwif va njëkëlehnaɗëniho fere pëlahnëniha Yesu, kaɓi waŋi wanës vëhni ntehnëɗëho. Ɓare ntakëkëhniwo gë kore ỹa; awa më tavëniha njilehnëni. ");
INSERT INTO cou_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wafarise wëryampo gë wëlawo Eroɗ w̃a faƴiko vëhni Yesu hna nji pëlajëniha gë wanës wadëw̃u ŋa dënk. ");
INSERT INTO cou_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Më njijëni ntehnëniha: «Aharaŋ, njëtëɓun toña ỹa hnësëɗu; kwëtahnëlihna nëf ile nke ahnë do dënënëɗila ahnë kaɓi aryëndah ye, ɓare njasa nte ñaɗ W̃ënu ŋa haraŋëɗuhëhni. Pëƴaryifu, sariya fu ỹa maw̃ëryak bi ma maw̃ëryana cosi ỹatëtanke ỹa asankaf a, Sesar? Tëfëkëfu bi sosëfuna?» ");
INSERT INTO cou_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɓare Yesu njëtëko cow̃ëni ile nahani paryi ỹa; më ntehnëkëhni: «Soŋe ye rëndëndunëho urënd? Ƴonëhnino uỹëc koryi, ñaɗëfu hnuw̃u.» ");
INSERT INTO cou_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Më njëɗaniha. Awa, Yesu më tëƴëkëhni: «Yëka mo g'uw̃ac mo liyik koryi li?» Më ntëkwaniha: «Sesar ye.» ");
INSERT INTO cou_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Më ntehnëkëhni: «Ɓësaryina Sesar ile kwëhnëk ỹa do W̃ënu ŋa ile kwëhnëk ỹa.» Idëkwa dëw̃u ŋa pëmpëhnahnëkëhniwo ɗus. ");
INSERT INTO cou_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wasaduse njilehnini vëhni Yesu hna. (Vëhni lehnëɗëho vësëm va vëvëhnëɗina.) Më tëƴëniha aki: ");
INSERT INTO cou_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Aharaŋ, Moyis njëɗakëfu aŋ'akwëɗa: “Ge asan ỹëlëk, do cëm hara tavëna vutah, aheryu ntëw̃ëɗëha asëval a soŋe nagëhnahna acëru vutah.” ");
INSERT INTO cou_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Awa, nkeho hwënta ryampo, vësan mbëɗ gë vëhi vële vankëko rëm gë hnëm. Aryënkwëryënkw a ñëlëko do cëm hara tavëna vutah. ");
INSERT INTO cou_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ahigëna ỹa ñëlëgëkawo asëval arac, do cëmëg hara tavëna vutah umë fëna. Koyëna nkehawo ararëna ỹa fëna, ");
INSERT INTO cou_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","do mbëɗ gë vëhi va fop ñëlënihawo asëval a rac do cëmëni hara vëravëhna vutah. Ga puni vëhni fop, asëval a fëna cëmëgëlehn. ");
INSERT INTO cou_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hnë wati ɓëhn hna, ge matëni vësëm va, mo hwëhnëɗëha awa asëval aỹi? Kaɓi mbëɗ gë vëhi vi fop ñëlënihawo!» ");
INSERT INTO cou_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu më ntëkwakëhni: «Mpaỹëmpaỹaɗëhu, do njëtërun bi soŋe ye ye? Kaɓi ƴëtëluhna vikerëh va do ƴëtëluhna fëna fanka W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ge vësëm va mbëhnëni, vësan va gë vësëval va vëvokëɗina ñëlëlëni, had wamëleka waɓ g'ambin ki nkeɗëni. ");
INSERT INTO cou_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɓare soŋe vële vëhnëɗ va, koɓëri karaŋëluhna bi kayëte nte kerëk Moyis nte hnësëɗ soŋe fatëh fante ỹagëɗëho fa? W̃ënu ŋa më lehnëkawo Moyis: “W̃ën Abëraham ŋa yeɓu, W̃ën Isak, do gë W̃ën Sakob.”» ");
INSERT INTO cou_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yesu më nkwënëk: «W̃ënu ŋa W̃ën vële wok vësëmëna ye, gena W̃ën vësëm; mpaỹëmpaỹaku ɗus.» ");
INSERT INTO cou_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aharaŋ sariya wëryëkëhniwo ga nkwajëlëɗëni. Njëtëko toña ỹa ntëkwakëhniwo Yesu wasaduse w̃a; më tëhaka do tëƴa: «Aŋëhne kwëɗa W̃ën ỹak hnëfak?» ");
INSERT INTO cou_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu më ntëkwaka: «Wëli akwëɗa nte ỹak hnëfak ŋa: “Nëpary, Isërayel, Ahwëhn a W̃ën fu, umë fo ye Ahwëhn. ");
INSERT INTO cou_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋahnëryehna Ahwëhn a W̃ën hu ŋa gë sakahn hu fop, g'intaw̃ary hu ŋa fop, gë hakili ỹa fop, do gë fanka hu fa fop.” ");
INSERT INTO cou_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Do wëli kigëna ŋa: “Ŋahnëryehna had wëjë dënk.” Gena vakwëɗa vante ỹak hnëfak lëbëka vaŋi.» ");
INSERT INTO cou_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Awa aharaŋ sariya ỹa më ntehnëka Yesu: «Njivëk ɗus, Aharaŋ. Ile lëkwaru ỹa toña ye: Ahwëhn a fo ye W̃ënu ŋa, W̃ënu hukaw̃ary gena, ge gena umë. ");
INSERT INTO cou_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Awa ale-wo-le tëfëka ŋahna W̃ënu ŋa gë sakahn lëw̃u fop, gë hakili lëw̃u fop, do gë fanka falëw̃u fop; do tëfëka ŋahna aỹëntaw̃u ỹa had umë dënk. Umë njivëk ɗus ntëbi sifa wasaɗëha wale-wo-le canëhnëɗe W̃ënu ŋa do gë w̃ësaw̃ ule ndaw̃ëhnëɗehëhni w̃i.» ");
INSERT INTO cou_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu njëtëko gë hakili ntëkwako; awa më ntehnëka: «Ŋaw̃ëtalihna Naw̃ W̃ënu ŋa.» Ga ndëcëk watac ahnë ɗëkëlohna mbok tëƴa iñë. ");
INSERT INTO cou_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu karaŋëɗëhëhniwo vahnë va Cery W̃ën Cankaf hna më tëƴëk iŋi tëƴ: «Hak koɗ ntehnëni vëharaŋ sariya vi Arëhnayik a Aju David ye? ");
INSERT INTO cou_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kaɓi David umë dënk lehnëko ante pëɓëkawo Iƴir Ipacah iŋa: «“Ahwëhn a W̃ënu ŋa më lehnëka Ahwëhn mën a: Ƴij alaña g'irëhw mën, hafo hale këfëɗëfuhëhni vële ỹew̃ëki va haryënkw hu.” ");
INSERT INTO cou_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David umë dënk “Ahwëhn” macëɗëha: awa hak koɗ nke Arëhnayik a fëna aju David?» Kore yaɓah hnëpaɗëhawo Yesu g'uhnatah. ");
INSERT INTO cou_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wëlin ile karaŋëɗëhëhniwo ỹa: «Keharyinëhni vëharaŋ sariya vi, vëhni vële nëŋahnëk gwërëtalehn gë vacuɗ vajaryah do ỹaɗ nkaỹëndeni g'untënah waỹëw̃a ɓulunda hna; ");
INSERT INTO cou_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tëhnaɗëni wëlaña wale rëkëɗe nuhahnëndeni vacaliŋa hna do gë wëlaña vahnë vëlënah hn'ile tokëɗe roka sankaf hna. ");
INSERT INTO cou_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Fop teɓëɗënihëhni vësëval vële cëmaryëk vësan va ile kwëhnani ỹa, do taŋ njëfaɗëni iƴëfa ƴaryah kamahnahnini. Gë wayap kitiŋëɗeni ntëbini vahnë vëỹëntaw̃ vi fop.» ");
INSERT INTO cou_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ɗarël hn'ile kwëtëɗe uyëɗahn vë Cery W̃ën Cankaf hna ntañako, do njëkëɗëho bi hak kwëtëɗëni vahnë va koryi ỹa. Vëvetak vëyaɓah koryi yaɓah kwëtëɗëniho. ");
INSERT INTO cou_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Asëval ahaỹëhnah ale cëmaryëk asan më tëkik do kwët vuŋëc vuki vunte wok ƴaɓëlahna nafa. ");
INSERT INTO cou_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Awa Yesu më macëkëhni vërëfal vëlëw̃u va do ntehnëhni: «Toña ỹa fëƴaɗëmu, aỹi asëval ahaỹëhnah, uyëɗahn lëw̃u ule kwëtëk w̃a yaɓëk ntëbi va vëỹëntaw̃ w̃i fop. ");
INSERT INTO cou_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaɓi vëỹëntaw̃ vi fop koryi ule wok ɓalëlëhnihna kwëtëni; ɓare umë, hn'uhaỹëhnah lëw̃u hna, njëɗahnëk le kwëhnak ỹa fop, ile rëfakëha kwëta soŋe lëw̃u ỹa dënk.» ");
INSERT INTO cou_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ante cahnëɗëho Yesu Cery W̃ën Cankaf ŋa, aryampo vërëfal vëlëw̃u hna më ntehnëka: «Aharaŋ, ƴëkëry! Wëraka wasankaf w̃a nkwamëk ka! Acery ŋa naỹëk ɗus!» ");
INSERT INTO cou_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu më ntëkwaka: «Gena nuɗu bi vaŋi vacery vacankaf? Wëla itaka ɗampo goɗina tinda hn'iñëntaw̃; fop nihëɗe.» ");
INSERT INTO cou_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu hn'ikuŋ Oliviye hna ntañako, paɓat gë Acery W̃ën Cankaf. Piyer, gë Sak, gë San, do gë Andëre fo nkeniho, më tëƴëniha: ");
INSERT INTO cou_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Pëƴaryifu bi guve ntiyaɗ watac do ye yeɗ dahëse le rufahnëɗ ante ntiyahnëɗ vëỹin fop ŋa.» ");
INSERT INTO cou_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Awa Yesu pëgwëlehn ntehnëndëhni: «Kwëtëryin hakili, ant'aravu arokayiwu! ");
INSERT INTO cou_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vahnë vëyaɓah njijëɗëni mëcani uw̃ac mën w̃a do ntehnëndëni vërëhnayik ye! Tokaɗënihëhni vahnë vëyaɓah. ");
INSERT INTO cou_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ge nkwëryëɗun ga nësëɗe soŋe wamët nkal g'inkal ɗarël hun do gë wakasëk soŋe wamët waɓë ŋaw̃ët ŋa, antë ntaku; watac afo ntiya, ɓare geɗina ten wapuya ỹi ɗuniỹa ŋa. ");
INSERT INTO cou_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɓulunda rëkëɗ mëtëndëni gë ɓulunda ỹëntaw̃, do ahnaw̃ pëgwëɗëha ahnaw̃ aỹëntaw̃; nkeɗ iñënka nkal hnë waresiỹo wayaɓah, do g'inte ŋa. Nkeɗ had lav iɗonk hnag ryënkwëryënkw. ");
INSERT INTO cou_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ɓare w̃uhnë, diryin wajira! Kaɓi vahnë va njiryeryëɗënihu Mbara Vëhitiŋ hna; ndafëɗerun vacaliŋa hna. Njiryeryëɗerun haryënkw hnë waguverëner hna gë vëhnaw̃ hna soŋe lëmën, waseɗe mën yeɗun haryënkw lëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Afo Wanës Wakasëk ŋa pëƴayini waɓulunda ŋa fop ten. ");
INSERT INTO cou_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Age pëlayirun soŋe ayiryeryiwu vakitiŋa hna, antë nkehahnahnu ile rëfëka ahnësu; nësëryin wanës wante njëɗaɗëhu W̃ën wati rac ŋa, kaɓi geɗina w̃uhnë rëkëɗ ahnësëndu ɓare Iƴir Ipacah iŋa rëkëɗ nësënd. ");
INSERT INTO cou_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Vële vankëk rëm gë hnëm njëɗahnëlëɗëni soŋe ndaw̃ini, do warëm w̃a fëna koyëna ntiɗënihëhni vutah vuntëw̃ hni va; vutah va ñew̃ëɗënihëhni vële hnagëkëhni va do ndaw̃ehnëɗënihëhni. ");
INSERT INTO cou_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vahnë va fop ñew̃ëɗënihu soŋe lëmën. Ɓare ale yaw̃ënaɗ hafo pu ỹa, W̃ënu ŋa pehëtëɗëha.» ");
INSERT INTO cou_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ge nuɗun ile w̃acëɗe “Iñë hayah ɗëcët ỹa”, hn'ile nkok tëfëlahna nke hna (araɓi ale haraŋëɗa nkwëry waŋi!), awa vële yeɗ Yuɗe va tëfëɗëha nkaryëni gë wahuŋ; ");
INSERT INTO cou_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ale yeɗ ƴaŋ cery ntëw̃u hna, ge cëlik, tëfëlahna tënk soŋe nuf iñë ɓambery; ");
INSERT INTO cou_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","do ale ye hn'ikaỹ hna tëfëlahna mënc gë ỹalu soŋe njoj cuɗ cankaf ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mekëhni vësëval vëryonkah va gë vële yëw̃ëndëɗëhëhni vutah vuntëw̃ hni va hnë wafac warac! ");
INSERT INTO cou_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Muntaryina W̃ënu ŋa antë tëki hnë wafac wale tëvëɗ gë fanka hna! ");
INSERT INTO cou_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kaɓi hnë wafac warac, mbër ŋa njaɓëɗ ɗus ntëbi vambër vante yeɗëho koɓëri wapëgwa ɗuniỹa vi, ante ntiko W̃ën fop ŋa, hafo gaki, do ɓokëɗina nke sifa rac muk. ");
INSERT INTO cou_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ge ŋaỹëtakëndina Ahwëhn a W̃ënu ŋa waỹi wafac ahnë gokëndina, ɓare ŋaỹëtëk soŋe vahnë vële tëhnak pehëtëni va. ");
INSERT INTO cou_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Awa ge ahnë ntehnëku: “Ƴëkëryina, ale tëhnak W̃ën ỹa ani nke, Arëhnayik a!” ma: “Ƴëkëryina, hnani nke!” nt'ahwëtahnu. ");
INSERT INTO cou_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaɓi, vërëhnayik gë wakila vële wok wayena paryi cahnëɗëni; rëkëɗ ntindëni vifëmpëhnahnah gë wëdahëse tokahnënihëhni vële tëhnak W̃ën va ge kokënd nke. ");
INSERT INTO cou_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Awa w̃uhnë, diryin wajira! Pëƴamu fop koɓëri fo.» ");
INSERT INTO cou_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Tac, ge ndëcëk wafac ambër warac, «“lav w̃a kuyëɗ, lepera w̃a ɓokëɗina ntanc, ");
INSERT INTO cou_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wahol w̃a njojëɗ, do wëfanka wale ye g'ambin w̃a ñënkaɗ.” ");
INSERT INTO cou_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Awa nuɗe Ajë Ahn'a, ga tëkiɗ vëŋar hna, gë fanka do gë icëmb cankaf. ");
INSERT INTO cou_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Paƴëɗëhëhni wamëleka wadëw̃u ŋa mbarëpinihëhni vële tëhnak va vacape vanah vamb nkal vi.» ");
INSERT INTO cou_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Nkwëryëryin le karaŋëɗ anuỹ ŋi: ge tëk nëp tuŋ njëtëɗun wati hasëk ỹa tëhajëk. ");
INSERT INTO cou_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ndampo fo nke, ge nurun vëỹin fop ga tëkiɗ, wati ỹa tëhajëk, ntiyaɗ. ");
INSERT INTO cou_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Toña ỹa fëƴaɗëmu: vahnë vëvë gaki vi vësëmëɗina fop hara diyana vëỹin fop. ");
INSERT INTO cou_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ambin ŋi g'inkal iŋi goɗina, ɓare wanës mën ŋi nkoɗ kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ahnë ƴëtëna bi guve tëkiɗ fac ma wati le ntiyaɗ vëỹin ỹa, wëla wamëleka waɓ g'ambin ŋi gë Aj'a dënk; Rëm ỹa fo yëtëk. ");
INSERT INTO cou_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Diryin wajira! Nt'ahnamawu, kaɓi ƴëtëluhna bi guve tëkiɗ wati ỹa. ");
INSERT INTO cou_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nkeɗ had asan yik uyas: ge matëk tere hna, taveryëɗëhëhni fop vëryokuŋ vëlëw̃u va, njëɗaɗëha ale-wo-le ɗoku minu ile rëkëɗ ndokuŋënd do ntehna ayëka rënka ỹa nt'ahnama. ");
INSERT INTO cou_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Awa nt'ahnamawu, kaɓi ƴëtëluhna bi guve mënciɗ Ahwëhn tere ỹa: mpëd g'anëka ga nkeɗ, ma gandëcak ga, ma tara cale ŋa, ma g'acahnëfëɗ ga. ");
INSERT INTO cou_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Antë mënci hnë wati le worun nahaluhna do njij tëkatu ga namarun. ");
INSERT INTO cou_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ile hnësëhnëɗëmu ani ỹi, hnësëhnëɗëfuhëhni vahnë va fop: ant'ahnamawu!» ");
INSERT INTO cou_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Awa wafac wahi wojëko nkehahn ambënt Pak ŋa do g'ambënt nte rokande mburu kwëhn levir këm ŋa. Vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va njëkëlendëniho tokaniha Yesu pëlaniha hara ɓulunda ỹa wayëtëna, ndaw̃ehnëniha. ");
INSERT INTO cou_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ntehnëlëɗëniho: «Koɗelënëhna ntiyin watac hnë wati ambënt hna, ge gena më ɓulunda ỹa dakëna ŋañënani.» ");
INSERT INTO cou_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Betani nkeho, tere Simo ale hwëhnako mbiỹ ŋa. Wati nte tokëɗëniho roka ŋa, asëval tënkëlehni gë sëleku ɗatikola hambah ntaw̃i le lihahnik narëd paryi. Më poɗëtëk do tura Yesu nkaf hna. ");
INSERT INTO cou_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Awa vëryampo hnë vële yentiko hnam va më ntavëkëhni ɗus, pëgwëlehnëni nësëlehnandëni vëhni fo: «Soŋe ye përëkanëk iỹi ɗatikola? ");
INSERT INTO cou_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kokënde nkwafi gë koryi yaɓah ɗus tac njëɗini koryi ỹa vëhaỹëhnah va!» Awa më ŋañënahnëniha asëval a. ");
INSERT INTO cou_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ɓare Yesu më ntehnëkëhni: «Tavëryina ƴam. Soŋe ye ryëñanërunëha? Ile ntinëhnëko ỹi njivëk. ");
INSERT INTO cou_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nkelahnëɗun kwëlëkwël vëhaỹëhnah va do wati-wo-wati ỹaɗun ỹa koɗun alinëhnuni ifërën; ɓare ami, gelahnëɗelënëhna kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ntik ile mëkëk ỹa: koɓëri fo turëko ɗatikola ỹa mbahn li pëhwëtanëhnahno iɓañ iŋa. ");
INSERT INTO cou_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Toña ỹa fëƴaɗëmu: hn'ile-wo-le pëƴahnëɗe Wanës Wakasëk ŋa ɗuniỹa li fop, tëfëtaɗe fëna ile ntik aỹi asëval do ndënkwëtaɗe.» ");
INSERT INTO cou_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Awa Yuɗa Isëkariyot, aryampo vërëfal Pëhw gë Vëhi hna, njiko nësëlini gë vësankaf vësëna wasaɗëha va gante tëfëka njëɗahni Yesu ka. ");
INSERT INTO cou_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vëhni, nëŋëkëhniwo ɗus ante nkwëryëniho watac ŋa, më ntehnëniha cosëɗëniha koryi. Yuɗa pëgwëlehn njëkëlehnand fere fale rëfëka njëɗahnëhni Yesu fa. ");
INSERT INTO cou_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Fac ryënkwëryënkw ambënt mburu kwëhn levir këm hna, hnë fac ile ndaw̃ahnëɗeni vupe soŋe roka Pak ỹa, vërëfal va më tëƴëniha Yesu: «Ne ñaɗu yifu afëhwëtanëhni roka Pak ỹa?» ");
INSERT INTO cou_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Më paƴëkëhni vëhi ntehnëhni: «Ƴiryin naw̃ hna, nuɗunëha asan ale ryiɓëk unkwahn w̃ënka. Tëfëlehnëryina. ");
INSERT INTO cou_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hn'ile tënkëɗ hna, dehnëryina ahwëhn tere ỹa: “Aharaŋ a tëƴëɗëhi: ‘Ne nke acery ante rokandëɓun roka Pak ỹa gë vërëfal mën va?’” ");
INSERT INTO cou_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tufëɗëhu cery cankaf ƴaŋ etas hna nte fëhwëtik g'ile valëɗëhu ỹa fop. Hnam pëhwëtaɗun soŋe roka ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Vërëfal va njilehnëni g'inaw̃; tëkatëni fop gante ntehnëkëhniwo Yesu ka, pëhwëtani soŋe roka ỹa. ");
INSERT INTO cou_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","G'anëka ga Yesu gë Pëhw gë Vëhi va tëkëlehnëni. ");
INSERT INTO cou_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wati nte tokëɗëniho roka taɓali hna, Yesu më ntehnëkëhni: «Toña ỹa fëƴaɗëmu: aryampo hnë w̃uhnë, ale rokëlandëɓun, tokaɗëho.» ");
INSERT INTO cou_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vërëfal va fop njamëlehnëni, pëgwëlehnëni tëƴëndëniha aryampo aryampo: «Ami bi ye?» ");
INSERT INTO cou_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu më ntëkwakëhni: «Aryampo ye hnë w̃uhnë Pëhw gë Vëhi vi, ale labëlandëɓun mburu ŋa hnëhët li. ");
INSERT INTO cou_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ajë Ahn'a cëmëɗ, gante nësëk vikerëh soŋe lëw̃u ka; ɓare horot sankaf nuỹaɗ ale rokaɗëha Ajë Ahn'a! Antë mbërayi nagi feceko asan arac!» ");
INSERT INTO cou_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wati roka hna Yesu më nufëk mburu ŋa, do më nkubëlehnëk njëɗahni vërëfal vëlëw̃u va, ntehnëhni: «Tokëryin, mbahn mën iŋa ye.» ");
INSERT INTO cou_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Më mbok nufëk nkëlëw̃a uñen waresen ŋa, camehna W̃ënu ŋa, do njëɗahni ceni vëhni fop. ");
INSERT INTO cou_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu më ntehnëkëhni: «Sat mën le ỹabahnik kwëtëla gë W̃ënu ŋa ye do ryehëtik soŋe vahnë vëyaɓah. ");
INSERT INTO cou_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Toña ỹa fëƴaɗëmu: ɓokëɗa sewu muk uñen waresen hafo fac le sahandëɓu ñen kasëk Naw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Njëw̃ëlehnëni wahnëw̃ ambënt ŋa tac njilehnëni hn'ikuŋ nte w̃acik Oliviye ŋa. ");
INSERT INTO cou_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «W̃uhnë fop tavëɗunëho kaɓi karaŋëɗe vikerëh hna: «“Ndaw̃ëɗëfuha aheryëherya, do wape ŋa campëɗëni.”» ");
INSERT INTO cou_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yesu më nkwënëk: «Ɓare ge mbëhnëɓu, njiɗëfu hnapëhëndu Galile hna.» ");
INSERT INTO cou_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyer më ntehnëka: «Lakënde tavënihi vëỹëntaw̃ vi fop, ami tavëɗila.» ");
INSERT INTO cou_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Awa Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmi: dol, hnë uŋi mëɗ dënk, ani gë tarahnënd cale ŋa wahwënta wahi, njahëtaɗu wahwënta warar ƴëtëlihohna.» ");
INSERT INTO cou_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɓare Piyer më njaw̃ënëko g'ahaw̃ary wanës wadëw̃u ŋa ntehn: «Ƴahëtaɗa muk, wëla ntehni tëfëka sëmëntiwu gë wëjë.» Vërëfal vëỹëntaw̃ va fop koyëna nësëniho. ");
INSERT INTO cou_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu gë vërëfal vëlëw̃u va tëkëlehnëni hn'ile macik Setësemane, më ntehnëkëhni: «Dañaryin ani hafo yiwu w̃untaju.» ");
INSERT INTO cou_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tac më njokëhni Piyer, gë Sak, do gë San. Pëgwëlehn njëtand yiw̃ëhnah g'ufëmpëhnahnah w̃a. ");
INSERT INTO cou_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Më ntehnëkëhni: «Ntaw̃ary mën iŋa pëɓëka yiw̃ëhnah sankaf ɗus hafo yewu had ale sëmëk; ñëw̃ëryin ani do ɗuñënaryin ant aryaku wakwëɗ.» ");
INSERT INTO cou_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu më njik ŋaw̃ët toƴe, njok nkal li koɓalehn do njëfa aki araɓi W̃ënu ŋa ŋaw̃ëtëhna, ge koɗ nke, iỹi wati horot. ");
INSERT INTO cou_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ntehnëɗëho: «Apa, Rëm mën, koɗu ali ile-wo-le ỹa; ŋaw̃ëtënde antë tëkëhne iỹi horot. Ɓare ant'ali ile ỹaɗëfu ami, diry ile ỹaɗu wëjë ỹa.» ");
INSERT INTO cou_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tac më mbokajëk hnë vërëfal vërar hna do nji tëkatëhni ga ndakëni wakwëɗ. Më ntehnëka Piyer: «Simo, ndakëru? Mëkëlihna aryuñëna wëla wati ryampo fo hara ɗakëlihna? ");
INSERT INTO cou_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ant'ahnamaw̃u do njëfaryin soŋe gante koɗun ayaw̃ënahnu ge njëkëhnahnëɗerun. Ahnë ñaɗ ntind yivah yaɓah, ɓare mbahn iŋa kwëhnana fanka.» ");
INSERT INTO cou_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Umë mbok ŋaw̃ëtak mbok njëfa gante ndënkwakëh njëfa ka. ");
INSERT INTO cou_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tac më mbok mbokajëk vërëfal hna do mbok tëkatëhni ga ndakëni wakwëɗ; wahoɗilohna mbok ŋesëni. Do wayëtëlohna ile ntëkwaɗëniha. ");
INSERT INTO cou_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ante mbokajëk rarëna ŋa, më ntehnëkëhni: «Nkorun aryaku do njinëgaɗun? Puk! Wati ỹa tëkëk. Ƴëkëryin, Ajë Ahn'a njëɗaɗeniha vëw̃en va. ");
INSERT INTO cou_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Matëryin, njiyin! Ƴëkëryina, ale yëɗahnëɗëho ỹa tëhajëɗëho!» ");
INSERT INTO cou_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu nkoko nësënd ante tëkiko taŋ Yuɗa ŋa, aryampo hnë Pëhw gë Vëhi hna. Gë kore vële yoko viw̃ëta, wasëlame gë waryoko nkeniho. Vësankaf vësëna wasaɗëha va faƴikëhniwo gë vëharaŋ sariya va do gë vicër va. ");
INSERT INTO cou_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuɗa, ale yëɗahnëɗëhawo Yesu ỹa, nkabëkëhniwo kore rac dahëse ile ntiɗ ỹa: «Asan ale vucëɗëfu ỹa, umë ye. Pëlaryina, ayowuna, do ayëkanduna ɗus.» ");
INSERT INTO cou_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuɗa tëkind tuŋ, tëhalehna Yesu do nkaỹa: «Aharaŋ!» Tac mbucëlehna. ");
INSERT INTO cou_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Awa vële nkejëniho va nëñëlëhnëlehnëniha Yesu pëlaniha. ");
INSERT INTO cou_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aryampo hnë vële nkeniho gë Yesu va më pëhwëtëk sëlame lëw̃u ỹa, do taw̃a aryokuŋ asëna wasaɗëha asankaf a ntëpëtëlehna nëf ŋa. ");
INSERT INTO cou_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu më tëƴëkëhni: «Gë wasëlame do gë waryoko bi tëfakëha ayinëhniwuno afëlawuno had bandi yeɓu? ");
INSERT INTO cou_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Fac-wo-fac nkelandenëho do karaŋëɗëfuhëhniwo vahnë va Cery W̃ën Cankaf hna, pëlalunow̃ohna. Ɓare ntiyaɗ nkehahn ile nësëk vikerëh va.» ");
INSERT INTO cou_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Awa vërëfal va fop tavëlehnëniha nkaryëni. ");
INSERT INTO cou_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jar rëfëlendëhawo Yesu, pand fo kurako. Njawëriko pëlayi, ");
INSERT INTO cou_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɓare tavëko pand iŋa nkaryëlehn ŋas fo. ");
INSERT INTO cou_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Më njoniha Yesu gë tere asëna wasaɗëha asankaf a. Hnam mbarëlëniho fop vësankaf vësëna wasaɗëha va, vicër va do gë vëharaŋ sariya va. ");
INSERT INTO cou_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer ŋaw̃ët tëfëɗëhawo Yesu, tënkëlehn selele tere asëna wasaɗëha asankaf hna. Hnam, gë vëyëka va ntañantiko njerantëɗeho hwëɗëh hna. ");
INSERT INTO cou_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vësankaf vësëna va gë vëhitiŋ vëvë Mbara Vëhitiŋ va fop njëkëlehnëɗëniho ceɗeya meh nte ndaw̃ehnahnëɗëniha Yesu, ɓare vëhnuỹalohna. ");
INSERT INTO cou_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vahnë vëyaɓah mërahnëɗënihawo, ɓare wanës wadëw̃ hni ŋa nëmpëlëko. ");
INSERT INTO cou_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Awa vëryampo më matëni mërahnëniha aki: ");
INSERT INTO cou_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nkwëryëɓunëhawo ga nësëɗ: “Nihëɗëfu ŋa Cery W̃ën Cankaf nte mbëryëni vahnë ŋi, do vokaryu vëryu kaw̃ary hnë wafac warar ante woɗ gena ɗoku vahnë.”» ");
INSERT INTO cou_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ɓare wëla hnë watac, wanës wadëw̃ hni ŋa nëmpëlëko. ");
INSERT INTO cou_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Awa asëna wasaɗëha asankaf a më matëk tëƴa Yesu: «Dëkwaɗila bi ile ntehnëɗënihi vëỹi vahnë?» ");
INSERT INTO cou_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu ñoñ dëkwaɗilohna. Asëna wasaɗëha asankaf a më mbok tëƴëka: «Arëhnayik a bi yeru, Ajë W̃ën hunte sëmbëɗëfun hi?» ");
INSERT INTO cou_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu më ntëkwaka: «Umë yeɓu, w̃uhnë fop nuɗunëha Ajë Ahn'a ntañaɗ g'irëhw W̃ën Hwëhn Fanka Fop; nuɗunëha fëna ga njijëɗ vëŋar vamb g'ambin hna.» ");
INSERT INTO cou_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Awa asëna wasaɗëha asankaf a më citëk viỹi vilëw̃u va do ntehn: «Gona mbalëfu gë waseɗe! ");
INSERT INTO cou_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nkwëryërun waƴew̃ wante njew̃ik W̃ënu ŋa. Hak ntehnërun?» Vëhni fop ntehnëlehnëni menëk, tëfëka ndaw̃i. ");
INSERT INTO cou_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vëryampo hnë vëhni pëgwëlehnëni tëpahnëndëniha Yesu, cankëniha yëka ỹi nkwëƴatëndëniha do ntehnëndëniha: «Ƴëtëry, kaɓi kila yeru, pëƴaryifu bi mo ryafëki!» Vëyëka va nufëlehnëniha Yesu poryëndëniha. ");
INSERT INTO cou_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyer gëɗ selele hna nkoko ante tëkiko asëval aryokuŋ ava asëna wasaɗëha asankaf a. ");
INSERT INTO cou_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nukawo Piyer ga njerantëɗe, më njëkëka ɗus, do ntehna: «Wëjë fëna gë Yesu nkentiruho, asan avë Nasaret aỹi.» ");
INSERT INTO cou_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ɓare Piyer nambehnakawo Yesu ntehn: «Ƴëtëla bi ye ỹaɗu ahnës, gwëryëɗa.» Tac më matëk selele hna nji rënka hna do icale tarëlehn. ");
INSERT INTO cou_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɓare aryokuŋ a më mbok nuka do mbok ntehna tase vële yeho hnam va: «Aỹi asan, aryampo hnë vëhni ye!» ");
INSERT INTO cou_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyer mboko nambehnahna kat. Ga mbiỹëk toƴe, vële yeho hnam va më ntehnëniha Piyer: «Paryi nke, aryampo hnë vëhni yeru, kaɓi wëjë fëna avë resiỹo Galile yeru.» ");
INSERT INTO cou_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Awa Piyer ndekalehn: «Araɓi W̃ënu ŋa ntiwo w̃eh ge mërëɗëfu! Lëk, ƴëtëlëw̃ahna asan ale lehnëɗun aỹi.» ");
INSERT INTO cou_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wati rac dënk, cale ŋa tarëlehn higëna ỹa, Piyer ndënkwëtalehn ile ntehnëkawo Yesu ỹa: «Tarahnënd cale ŋa wahwënta wahi, njahëtaɗëho wahwënta warar ƴëtëlihohna.» Awa pëgwëlehn kond ɗus. ");
INSERT INTO cou_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vësankaf vësëna wasaɗëha va, gë vicër va, gë vëharaŋ sariya va, do gë vëvë Mbara Vëhitiŋ va fop, mbarëniho koɓëri fo g'acahnëfëɗ ga soŋe nkwajëlëni. Më ñabehnëniha Yesu, njiryeryëniha njëɗaniha Pilat. ");
INSERT INTO cou_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Arac më tëƴëka: «Ahnaw̃ wasëwif w̃a bi yeru?» Yesu më ntëkwaka: «Wëjë hnësëk.» ");
INSERT INTO cou_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vësankaf vësëna wasaɗëha va viỹë viyaɓah mërahnëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Awa Pilat më mbok tëƴëka: «Ñoñ dëkwaɗila bi? Nkwëryëɗu wante pëƴahnëɗëni soŋe lëw̃ hu ŋa!» ");
INSERT INTO cou_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ɓare Yesu ñoñ golohna ntëkwand, hafo Pilat pëmpëhnahna. ");
INSERT INTO cou_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hn'ambënt Pak-wo, Pilat tavëɗëhawo aramp aryampo, ale tëƴëni ɓulunda ỹa. ");
INSERT INTO cou_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hara asan, ale w̃acik Barabas, sëɗaryiko kaso hna gë vële ryaw̃ëkawo ahn'a ante ŋañënaniho soŋe nkwëcëtini vësankaf ŋa. ");
INSERT INTO cou_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kore ỹa njilehnëni vëhni Pilat hna do pëgwëni vëhni fop tëƴëndëniha ile rëk maw̃ëryanëɗëhëhni hn'ambënt Pak hna. ");
INSERT INTO cou_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat më ntëkwakëhni: «Ñaɗun bi ravëhnuna ahnaw̃ wasëwif aỹi?» ");
INSERT INTO cou_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kaɓi Pilat njëtëko ɗus, g'iñew̃ary njinenëhninihawo Yesu vësankaf vësëna wasaɗëha vi. ");
INSERT INTO cou_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɓare vësankaf vësëna va peñëɗënihëhniwo kore ỹa ntehnëni: «Tavëndifuna Barabas.» ");
INSERT INTO cou_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat më mbok tëƴëkëhni kat kore ỹa: «Ye ỹaɗun liwuw̃a ale w̃acëɗun Ahnaw̃ Wasëwif aỹi?» ");
INSERT INTO cou_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Më ntëkwaniha ndekatëndëni: «Pakëryehna hnë kërëwa!» ");
INSERT INTO cou_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat më tëƴëkëhni: «Awa iỹëhne w̃eh ntik?» Ɓare mboko ndekani ɗus g'ahaw̃ary: «Pakëryehna hnë kërëwa!» ");
INSERT INTO cou_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat ñaɗëho nëŋehnëhni ɓulunda ỹa, më tavëka Barabas; ga ntampëniha Yesu, më njëɗakëhni wasoɗaɗe w̃a pakëniha hnë kërëwa. ");
INSERT INTO cou_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wasoɗaɗe w̃a më njoniha Yesu ɓambery tere guverëner hna, do macënihëhni wasoɗaɗe ntahni w̃a fop. ");
INSERT INTO cou_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cuɗëniha cuɗ mbëntah, do mbahnëni apënkw wadëmpëhn, pënkwëlehnëniha. ");
INSERT INTO cou_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tac pëgwëlehnëni njafaŋëndëniha ntehnëndëniha: «Nkaỹiru, Ahnaw̃ Wasëwif!» ");
INSERT INTO cou_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ntankëɗënihawo, tëpahnëndëniha do ndëkwëhnëndëni haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ante puhnani ƴafaŋ dëw̃u ŋa, më cuɗëtëniha cuɗ mbëntah ŋa, mbokaryëniha viỹi vilëw̃u va do njoniha soŋe pakëniha hnë kërëwa. ");
INSERT INTO cou_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hara asan, ale w̃acik Simo, avë Siren, w̃ënciɗëho kaỹ. Rëm hni vëhni Alekësandër do gë Rufus yeho. Cape tac ndëcëɗëho do wasoɗaɗe w̃a më porosiŋëniha ndiɓ kërëwa Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Më njiryeryëniha Yesu hn'ile macik Golëgota; umë fëhnëtanëɗ «Kuŋ Hëloƴoƴ». ");
INSERT INTO cou_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ñaɗëniho njëɗaniha uñen nte hnaw̃ëlehnik gë ɗatikola ile w̃acik mir, ɓare Yesu më ŋwëỹëk. ");
INSERT INTO cou_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tac pakëlehnëniha hnë kërëwa do pitëndëlehnëniho viỹi vilëw̃u va do njëlëniho wanjël njëtahnëni bi mo hwëhnëɗ. ");
INSERT INTO cou_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cahnëfëɗ fo woko ante pakënihawo ŋa. ");
INSERT INTO cou_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aki keriko do pakiko ƴaŋ lëw̃u njëtahnënde soŋe ile ndaw̃ahnik ỹa: «Ahnaw̃ Wasëwif w̃a». ");
INSERT INTO cou_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wabandi waki fëna pakaryiniho hnam ɗarël Yesu, aryampo g'irëhw, aỹëntaw̃ a g'irahahn. ");
INSERT INTO cou_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Koyëna ntiyako Vikerëh vinte fëƴahnëko: «Had vëw̃en va ntiryaryiko.» ");
INSERT INTO cou_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vële ryëcëɗ va nkëlënkëlaɗëniho njew̃atëndëniha, ntehnëndëni: «Hey! Wëjë ale lehnëko koɗu ahnih Cery W̃ën Cankaf ŋa do avokary avëry hnë wafac warar, ");
INSERT INTO cou_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","pehëtary wëjë dënk, cëli kërëwa hna!» ");
INSERT INTO cou_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vësankaf vësëna wasaɗëha va fëna gë vëharaŋ sariya va njafaŋëɗënihawo ntehnëlëndëni: «Pehëtëkëhni vahnë vëhaw̃ary ɓare koɗina pehëta umë dënk! ");
INSERT INTO cou_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Araɓi Arëhnayik a, ahnaw̃ Isërayel a, cël tameki kërëwa hna! Ge nuɓun rac, awa kwëtahnëɗëfunëha.» Vële pakëlehniniho gë Yesu va fëna njew̃ëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lav a nkaf li nkeho, kuyëlehn nkal hna fop hafo hnë wëwati warar g'anent hna. ");
INSERT INTO cou_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wati rarëna hna Yesu më ndekak gë fanka: «Eloyi, Eloyi, lëma sabakëtani?» Umë fëhnëtanëɗ: «W̃ën mën, W̃ën mën, soŋe ye ravëruho?» ");
INSERT INTO cou_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vëryampo hnë vële yeho hnam va, ga nkwëryëni, më ntehnëni: «Nëparyin, Eli macëɗ!» ");
INSERT INTO cou_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aryampo hnë vëhni më nkaryëk koƴ ankwëỹ hn'uñen ŋañah do cob hnë ryoko, tac njelëhnëlehna Yesu soŋe ce do ntehnëhni vële nkeni va: «Napëryin, nuɗen ge Eli njijëɗ cëlënda kërëwa li!» ");
INSERT INTO cou_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tac Yesu më ndekak gë fanka cëmëlehn. ");
INSERT INTO cou_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ipand ɗëndah, inte fokiko haryënkw ỹëw̃a le ỹak sëvak Cery W̃ën Cankaf hna, citako fagant pëgw ƴaŋ hafo gëɗ. ");
INSERT INTO cou_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kapiten vë Rom, le hahnëko haryënkw Yesu ỹa, nuko gante cëmëko ka më ntehnëk: «Paryi nke, aỹi asan Ajë W̃ën yeho!» ");
INSERT INTO cou_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vësëval vëryampo yeho hnam, vëhni fënali ŋaw̃ët njëkëɗënihawo. Hnë vërac, nkentiniho vëhni Mari mbë Magëdala, gë Salome, gë Mari hnëmu Sak toƴe do gë Yose. ");
INSERT INTO cou_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tëfëlehnëɗënihawo Yesu ante nkeniho Galile ŋa do ndokuŋëhnëɗënihawo. Nkentiniho fëna hnam vësëval vëyaɓah vëhaw̃ary vële njijëniho gë Yesu Yerusalem hna. ");
INSERT INTO cou_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","G'anëka ga, Yosef mbë Arimasi tëkiko. Umë ahitiŋ yentiko ale lënënik Mbara Kitiŋa hna, do itëk Naw̃ W̃ënu ŋa napëntëɗeho umë fëna. Fac pëhwëta ntaw̃ëla ŋa yeho, ɓëỹëɗilohna fac ntaw̃ëla ŋa pëgwëɗëho. Soŋe rac ndëkahnëko Yosef nji tëƴa Pilat iñas Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat pëmpëhnahnëkawo ante njëtako Yesu tëk cëm ŋa. Më macehnëka kapiten ỹa tëƴa bi paryi nke. ");
INSERT INTO cou_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ga pëƴahnëk, kapiten ỹa, paryi nke, Pilat më maw̃ëryanëka Yosef nuf ñas iŋa. ");
INSERT INTO cou_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosef më ntaw̃ëk ƴarëh, cëlëndëk ñas iŋa kërëwa hna, përyëk hnë ƴarëh do ndën hn'iƴag nte yabiko hn'ikuŋ. Tac këryiŋët bëraka piɗahn rënka ƴag iŋa. ");
INSERT INTO cou_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari mbë Magëdala gë Mari hnëmu Yose njëkëɗëniho bi ne ndënëɗe ñas Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga ndëcëko fac ntaw̃ëla ŋa, Mari mbë Magëdala, gë Salome, gë Mari hnëmu Sak më ntaw̃ëni ɗatikola soŋe nji ntini ñas Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gë dimasi ỹa koɓëri fo, ante pëhnëk lav ŋa, njilehnëni ƴag hna. ");
INSERT INTO cou_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ntehnëlëɗëniho vëhni fo: «Mo yiɗ këryiŋëtëhnëfu taka nte fiɗahnik rënka ƴag ŋi?» ");
INSERT INTO cou_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ɓare ante tëkëniho ŋa nuniho taka cankaf iŋa këryiŋëtiko cape ndampo. ");
INSERT INTO cou_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Awa tënkëlehnëni ƴag hna do më nuniha ajar ga ntañak hnam g'irëhw; viỹi vile yerëko had ambin wilëbilëk ntiyako. Vësëval va më pëmpëhnahnëkëhni, ");
INSERT INTO cou_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ɓare jar ŋa më ntehnëkëhni: «Antë pëmpëhnahnu; Yesu mbë Nasaret yëkëlehnëɗun, ale fakiko ỹa; W̃ënu ŋa mbëhnëndanëka, gena hnani. Ƴëkëryin, wëli hn'ile kwëtiko hna. ");
INSERT INTO cou_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tame ƴiryin afëƴawuna Piyer gë vërëfal vëỹëntaw̃ va: “Njiɗ napëhëndu Galile hna; hnam nuɗunëha, gante ntehnëkuno ka.”» ");
INSERT INTO cou_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Awa vësëval va cahnëlehnëni g'igary fo ŋaw̃ëtani ƴag iŋa, kaɓi mbalëɗëniho ntakah ŋa. Do ñoñ wafëƴalawohna ahnë, kaɓi ntakëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ga mbëhnëk, koɓëri fo g'acahnëfëɗ ga gë dimasi ỹa, Yesu vëhni Mari mbë Magëdala hna tufëhnako ten, ale ntanëhnëko waƴine mbëɗ gë waki ŋa. ");
INSERT INTO cou_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Umë njik pëƴakëhni vële nkeniho gë Yesu va. Hara vahnë vërac njëwëhnëniho do koɗëniho. ");
INSERT INTO cou_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ɓare ga nkwëryëniha ga nësëɗ: «Yesu mbëhnëk, nuɓuha!» vëhwëtahnëlawohna. ");
INSERT INTO cou_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tac, vërëfal vëhi yiɗëho gë vunkol vutoƴ. Yesu më mbok tufëhnak g'ankeya nte nkok ƴavëtëɗena ten. ");
INSERT INTO cou_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vërëfal vëhi va më mbokani pëƴanihëhni vëỹëntaw̃ va, ɓare vëhni fëna vëhwëtahnëlëhniwohna. ");
INSERT INTO cou_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tac, ga ndëcëk watac fop, Yesu më mbok tufëhnak kat vërëfal pëhw g'aryaw̃ hna wati ante tokëɗëniho roka ŋa; ŋañënahnëkëhniwo soŋe ile nkoni vëhwëtahnëna ỹa do g'ikamb vankaf vantëw̃ hni ŋa, kaɓi vëw̃aw̃ëhnëliwohna vële hnukawo ga mbëhnëk va. ");
INSERT INTO cou_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Më ntehnëkëhni: «Ƴiryin ɗuniỹa li fop afëƴawuni vahnë va Wanës Wakasëk ŋa. ");
INSERT INTO cou_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ale-wo-le hwëtahnëɗ do njaryi ỹa pehëtëɗe; ɓare ale woɗ kwëtahnëna ỹa cëɗëɗe. ");
INSERT INTO cou_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wëlin dahëse ile njavëtahnëɗeni vële hwëtahnëk va: ntaɗënihëhni waƴine ŋa g'uw̃ac mën w̃a; nësëɗëni vanësa wakaw̃ary; ");
INSERT INTO cou_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ge pëlaɗënihëhni walën ma ge ceɗëni wanto wante ryaw̃ëɗ ñoñ diɗilëhnihna; tindëɗënihëhni wëɓák ŋa vëres va do vërac njërëɗëni.» ");
INSERT INTO cou_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ante nësëhnëɗëhëhniwo koyëna ŋa, Ahwëhn a Yesu nufiko nkal li njoyi g'ambin do ntaña g'irëhw W̃ën. ");
INSERT INTO cou_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vërëfal va campëlehnëni gante-wo-gante soŋe pëƴahnëni Wanës Wakasëk ŋa. Ahwëhn a ndemaɗëhëhniwo hnë ɗoku rac gë wëdahëse wapëmpëhnahnah wante ntiɗëniho ŋa do tufahnëɗëho wanës ŋa toña ye.");
INSERT INTO cou_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aỹënta mën Alënah Tewofil, vahnë vëyaɓah njëkëlehnëni njëtëni do kerëni ile ye toña ỹa fop hn'ile ryëcëtako fagant fu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Koɓëri wapëgwa hna vële yeho waseɗe waŋi fop va hwëtehnahniko pëƴahnëni wanës W̃ënu ŋa do awa vëhni fëƴakëfu fop ile liyako ỹa. ");
INSERT INTO cou_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Soŋe umë ye, Alënah Tewofil, ante njëkëlehnëɓu wapacëk ami fëna, caŋahnëko herëhni waŋi fop ile liyako koɓëri wapëgwa hna hafo hn'ile puko hna, ");
INSERT INTO cou_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aholahn ahwëtahn karaŋ inte haraŋiruho ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wati ante nkeho Eroɗ ahnaw̃ Yuɗe ŋa, nkeho hnam asëna wasaɗëha ale w̃aciko Sakari. Hnë kore vësëna vëva Abiya hna kwëhnaryiko. Asëvalu, Elisabet maciko. Umë fëna hnënk asëna asankaf ale w̃aciko Aron hna kwëhnaryiko. ");
INSERT INTO cou_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Catëniho vëhni vëhi tak haryënkw W̃ën hna, maw̃ëhnëniho sariya ỹa gë fop ile tëƴëk Ahwëhn a. ");
INSERT INTO cou_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Vëhwëhnalawohna fatah, kaɓi Elisabet nagëɗilohna do tëko ntafëni vëhni vëhi tak. ");
INSERT INTO cou_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Fac ryampo, Sakari ɗoku vësëna wasaɗëha ỹa ntiɗëho Cery W̃ën Cankaf hna, kaɓi agwën kore lëw̃u ỹa yeho. ");
INSERT INTO cou_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ntiniho gante nke namu vësëna wasaɗëha ka soŋe tëhnahni ahnë do tëhnayiko Sakari tënk ỹëw̃a sëvah Ahwëhn hna nji pëɗ ɗuɗ iŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wati nte pëɗëɗe ɗuɗ iŋa, fop ɓulunda ỹa g'ipër njëfaɗëniho. ");
INSERT INTO cou_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mëleka Ahwëhn a cahnahnikawo Sakari: gë farëhw hn'ile cënaɗe saɗëha hn'ile pëɗëɗe ɗuɗ iŋa ñëw̃ëko. ");
INSERT INTO cou_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakari ga nuka, ntaɗëlehna ntaw̃ary iŋa do ntaka ɗus. ");
INSERT INTO cou_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɓare mëleka ỹa më ntehnëka: «Antë ntaki, Sakari; W̃ënu ŋa nkwëryëk wayëfa hu w̃a. Elisabet, asëval hu, nagëhnëɗëhina fatah facan fante w̃acëɗu San. ");
INSERT INTO cou_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Natëɗëhi ɗus soŋe lëw̃u ỹa; njaɓëɗëni fëna vële natëntëɗe va kaɓi nagik. ");
INSERT INTO cou_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aryokuŋëhn Ahwëhn asankaf yeɗ. Ceɗina muk ile ryëw̃ënëɗ. Koɓëri ɗonk hnëmu hna pëɓëɗëha Iƴir Ipacah iŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mbokaryiɗëhëhni vutah Isërayel va Ahwëhn hna W̃ën hudëw̃ hni ha. ");
INSERT INTO cou_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Umë ryënkwëhniɗëha Ahwëhn a. Gë Iƴir inte yëɗakawo fanka kila Eli fa njijëɗ soŋe konjëlehnëhni warëm w̃a gë vutah vuntëw̃ hni va do vële wok vëlënënëɗilahna W̃ën va mbokaryini kwëhnani hakili satah. Karaŋëɗëhëhni ɓulunda le fëhwëtaɗ itëk Ahwëhn a.» ");
INSERT INTO cou_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Awa Sakari më tëƴëka mëleka ỹa: «Hak njëtëɗëfu waŋi toña ye? Ntafëɓu do asëval mën aỹi fëna ntafëk!» ");
INSERT INTO cou_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mëleka ỹa më ntëkwaka: «Ami, Gabëriyel yeɓu, ale hahnëɗ haryënkw W̃ën hna soŋe ryokuŋëhnëndëw̃a; paƴiko yiju yonëhniỹi waŋi wanës wakasëk wapërën. ");
INSERT INTO cou_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ile hnësëɓu ỹi ntiyaɗ ge wati ỹa tëkëk. Ɓare maw̃ëlihna; soŋe rac koɗila avok ahnës hafo hale ntiyaɗ watac.» Mëleka ỹa koyëna nësëhnëkawo Sakari. ");
INSERT INTO cou_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hnë wati rac, kore ỹa napëɗënihaw̃o Sakari do pëmpëhnahnëkëhniwo, kaɓi mbiỹëhëɗëho ɓambery ỹëw̃a sëvah hna. ");
INSERT INTO cou_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ga cahnik, koɗilohna nësëhnëhni do vahnë va njëtëniho iñë le w̃atik gë W̃ën nuk ỹëw̃a sëvah hna. Tëk pëgw fac rac, koɗilohna mbok nës, aki fo ndëkwanëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tac ga puk wafac wale rëfëkawo Sakari ndokuŋ hnë Cery W̃ën Cankaf hna, më mëncëk gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ga ndëcëk watac fop, Elisabet, asëvalu ndonkëko do hnë wadepera mbëɗ cahnëɗilohna tere hna. Ntehnaɗëho: ");
INSERT INTO cou_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Wëlin ile ntinëhnëko Ahwëhn a! Maw̃ëk ntihëto ile sëfëhnëɗëhow̃o tase vahnë fop ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hn'ulepera hwëhn mbëɗ gë ryaw̃ hn'iɗonk Elisabet hna, W̃ënu ŋa paƴëkawo mëleka Gabëriyel gë resiỹo vë Galile, hn'ankol nte w̃acëɗe Nasaret hna, ");
INSERT INTO cou_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","hn'aryag ale woko ƴëtëna vësan; Mari maciko. Asan ale w̃acik Yosef hwëhnëkawo do yentiko hnë hnënk Ahnaw̃ David. ");
INSERT INTO cou_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mëleka ỹa tënkëko ỹalu hna do ntehna: «Natëryiỹi Mari! Ahwëhn a ñaɗ ntinëhni iñë fërën, gë wëjë nkerun.» ");
INSERT INTO cou_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari pëmpëhnahnëkawo ɗus wanës mëleka ŋi; më tëƴak bi ye pëhnëtanëk iỹi simpaỹi. ");
INSERT INTO cou_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Awa mëleka ỹa më ntehnëka: «Antë ntaki Mari, kaɓi W̃ënu ŋa ñaɗëhi. ");
INSERT INTO cou_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ndonkëɗu do ahnaga facan fante w̃acëɗu Yesu. ");
INSERT INTO cou_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ale hwëhnak nafa yeɗ do rëkëɗe macënde Ajë W̃ën Hunte Sëpëk Fop. Ahwëhn a W̃ënu ŋa ntiɗëha ahnaw̃ asankaf gante ntikawo David rëmu sankaf ka, ");
INSERT INTO cou_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","do umë yeɗ ahnaw̃ vutah Isërayel va kwëlëkwël, ucankaf ntëw̃u ŋa puɗina.» ");
INSERT INTO cou_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari më ntëƴëka mëleka ỹa: «Hak lë koɗ nke watac, kaɓi ƴëtëla vësan?» ");
INSERT INTO cou_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mëleka ỹa më ntëkwaka: «Iƴir Ipacah iŋa njijëɗ hnë wëjë do fanka W̃ën Hunte Sëpëk Fop ŋa cankëɗëhi had icën. Soŋe rac macahnëɗe fatah fapacah fante hnagëɗu fa, Ajë W̃ën. ");
INSERT INTO cou_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elisabet mbaỹëhu, umë fëna, facan nagëɗ mama ntafahnëk; umë ale lehnëɗeho nagëɗina ỹa, lepera hwëhn mbëɗ gë ryaw̃ w̃a nkehahnëk. ");
INSERT INTO cou_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ƴëtëry, ñoñ gena ile nkok koɗina nti W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Awa Mari më ntehnëk: «Aryokuŋëhn Ahwëhn a yeɓu; araɓi fop nkewo gante nësëru ki.» Awa mëleka ỹa njilehn. ");
INSERT INTO cou_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hnë wafac warac, Mari pëhwëtalehn g'uỹankahnah nji hn'ankol nte ye hnë wahuŋ hnë resiỹo Yuɗe hna. ");
INSERT INTO cou_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ante tëkëko hnam ŋa, tënkëko tere Sakari hna do nkaỹa Elisabet. ");
INSERT INTO cou_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wati nte nkwëryëko arac simpaỹi Mari ha, fatah fa ñënkakawo hn'iɗonk hna gë fanka. Wati rac dënk, Elisabet pëɓëlehna Iƴir Ipacah iŋa ");
INSERT INTO cou_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","do ndeka gë fanka: «W̃ënu ŋa ntinëhnëki viỹë vifërën ntëbini vësëval va fop do ntinëhnëka fëna fatah fante hnagëɗu fa! ");
INSERT INTO cou_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mo ga yeɓu ami, nehahniɗëho hnëmu Ahwëhn mën aki? ");
INSERT INTO cou_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ante nkwëryëɓu simpaỹi hu ha, fatah fa ñënkak uhnatah ɗonk mën hna. ");
INSERT INTO cou_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mbetaru kaɓi kwëtahnëruha Ahwëhn a ntiɗ ile pëƴaki ỹa!» ");
INSERT INTO cou_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Awa Mari më ntehnëk: «Ntaw̃ary mën iŋa fop naỹënëɗëha Ahwëhn a, ");
INSERT INTO cou_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","sakahn mën ha pëɓëka uhnatah soŋe W̃ënu ŋa, afehët mën a; ");
INSERT INTO cou_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kaɓi ndënkwëtako, ami ale wok kwëhnala nafa ỹi. Tëk pëgw gaki, vahnë vëvë ɗuniỹa vi fop rëkëɗ macëndëniho ale ñaɗ W̃ën, ");
INSERT INTO cou_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kaɓi W̃ënu ŋa, Ayaw̃ah a, ntinëhnëko viỹë vifëmpëhnahnah visankaf. W̃ac lëw̃u w̃a ỹak lënënik ɗus. ");
INSERT INTO cou_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kaỹëhnandëha gë vanjeh vaƴaɓah vante lënënëɗëha gë antakah va. ");
INSERT INTO cou_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ntik ɗoku sankaf gë fanka vák lëw̃u ỹa: Campehnëkëhni vële hnaỹënaɗ va. ");
INSERT INTO cou_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Këfëkëhni vësankaf va ucankaf ntëw̃ hni hna, do matëndëɗëhëhni vële vanaɗ va. ");
INSERT INTO cou_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Njëɗakëhni vetak sankaf vële njoko inte va, do ntahni vëvetak va wëɓák fo. ");
INSERT INTO cou_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Njijëk ndemahni ɓulunda Isërayel ỹa, vëryokuŋ vëlëw̃u va: ɗënkwëna tufa Abëraham gë vutah vuntëw̃u va, kaỹëhnahn dëw̃u ŋa ");
INSERT INTO cou_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwëlëkwël, gante ntehnëkëhniwo vacërakëlo fu ka.» ");
INSERT INTO cou_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari koyëna puhnako hnëw̃ lëw̃u ỹa. Umë vëhni Elisabet hna ñëw̃ëko ile rëkëk wadepera watar, tac mëncëk gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wati nte nagand Elisabet ŋa tëkëko, më nagëka facan. ");
INSERT INTO cou_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Koyëna vësaryëntaw̃u gë hnënk lëw̃u ỹa njëtaniho Ahwëhn a kaỹëhnahnëka ɗus g'umë, awa më natëntikëhni vëhni fëna. ");
INSERT INTO cou_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hnë fac hwëhn mbëɗ gë warar hna, më njijëni soŋe kácehnëniha fatah fa gante nkeho namu lëw̃ hni ka; Sakari ñaɗëniho macëniha vahnë va, w̃ac rëmu w̃a. ");
INSERT INTO cou_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hnëmu më ntehnëk: «Hali, San macëɗe.» ");
INSERT INTO cou_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vahnë va më ntehnëniha: «Ɓare, kwëhnalihahna la aryampo hnënk hu hna ale w̃acik koyëna!» ");
INSERT INTO cou_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Awa më ndëkwanëniha rëm ỹa tëƴëniha bi hak ñaɗ maci fatah fantëw̃u fa. ");
INSERT INTO cou_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakari më tëƴëk iñë ile herande do umë kerëk: «W̃ac lëw̃u ỹa San ye.» Vëhni fop pëmpëhnahnëlehnëhni. ");
INSERT INTO cou_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Taŋ Sakari kolëlehn mbok nësënd, pëgwëlehn ndekand, cëmbënda W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Awa vësaryëntaw̃u va fop pëmpëhnahnëkëhniwo, do fop hn'ankol nte ye hnë wahuŋ hnë resiỹo Yuɗe hna tëfëtaɗeho watac. ");
INSERT INTO cou_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Fop vële wëryëko ga tëfëtaɗe watac va nahaɗëniho do tëƴaɗëniho: «Awa ye ga nkeɗ faŋi fatah?» Nuniho fanka Ahwëhn fa g'umë nkeniho. ");
INSERT INTO cou_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hnë wati rac, Sakari, rëmu fatah fa, pëɓëkawo Iƴir Ipacah iŋa, pëgwëlehn nësënd wanës W̃ën ntehnënd: ");
INSERT INTO cou_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Araɓi Ahwëhn a W̃ën ɓulunda vëvë Isërayel va cëmbi, kaɓi njijëk paɓëhni ɓulunda lëw̃u ỹa do pëhwëtëk fop soŋe pehëtëhni: ");
INSERT INTO cou_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Canëhnikëfuna Afehët ahwëhn fanka, hnë hnënk David aryokuŋ alëw̃u hna, ");
INSERT INTO cou_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","wakila ŋa mbiỹëk ga pëƴahnëniho watac, ");
INSERT INTO cou_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","më lehnëko pehëtëɗëhëfu hnë vële ỹaɗ ntinihëfu wameh va do gë hn'imëk vële ỹew̃ëkëfu va fop. ");
INSERT INTO cou_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Koyëna tufahnëk dol kaỹëhnahn nte kwëhnako soŋe vacërakëlo fu ŋa do ɗënkwëna kwëtëla nte ntiko gë vëhni ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ha, ntik ile ntëkëhnëkawo rëm fu ỹa Abëraham: ");
INSERT INTO cou_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ŋaw̃ëtëɗëhëfu hnë vële ỹew̃ëkëfu hna kolahnin ndokuŋëhnëndena ntakah këm, ");
INSERT INTO cou_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nkehahnin vahnë vële ỹahnëka do catin haryënkw lëw̃u hnë wafac ɗuniỹa lëw̃ fu hna fop.» ");
INSERT INTO cou_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","«Do wëjë, fatah mën, kila W̃ën Hunte Sëpëk Fop yeɗu: ndënkwëhnëɗuha Ahwëhn a afëhwëtëhnëhënda nkaw̃ ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Do koyëna njëtëndanëɗuhëhni ɓulunda lëw̃u ỹa njijëɗ pehëtëhni g'itavëhn wameh wadëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Toña ye, W̃ënu ŋa Ahwëhn fu ỹa kaỹëhnahnëɗëha ɗus: Nke had lav ule fëhniɗ do penifu g'ambin, ");
INSERT INTO cou_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","soŋe penahnëhni vële ye hnë umëhwëry do gë hnë icën icëm hna, ƴasaryahnëfu hn'ankaw̃ ƴam hna.» Sakari koyëna puhnako wanës wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Fatah fa naỹëɗëho do hakili lëw̃u ỹa nkwënaɗëho. Hnë wula ntëɗëko hafo hale pëgwëko ɗoku lëw̃u ỹa hnë ɓulunda vahnë vëvë Isërayel hna. ");
INSERT INTO cou_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hnë wati rac, Sesar Ogis, Ahwëhn Nkal a, ntehnëko kerini vahnë vëvë nkal va fop. ");
INSERT INTO cou_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Vaker vatac yeho vandënkwëryënkw va do wati rac Kiriniyus yeho guverëner vë Siri ỹa. ");
INSERT INTO cou_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Vahnë va fop njiɗëniho keraryini, ale-wo-ale nkol ntëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Awa Yosef, umë fëna, matëko nkol Nasaret nte ye hnë resiỹo Galile hna, soŋe nji hn'ankol Betëlem nte ye hnë resiỹo Yuɗe hna, hn'ile nagiko ahnaw̃ a David, kaɓi hnënk David hna nkentiko. ");
INSERT INTO cou_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Njokawo Mari, ale kwëhnëko ỹa, keraryijini njiɗëniho, do Mari g'iɗonk nkeho. ");
INSERT INTO cou_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wati nte nkeniho Betëlem ŋa, fac hnag ỹa tëkëlehni. ");
INSERT INTO cou_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Më nagëka facan, fatah fandënkwëryënkw fantëw̃u fa yeho. Më përyëka gë ƴarëh do ntana hn'ile kwëtëndeni wusaw̃ uryav hna, kaɓi vëhnuỹalohna igwac cery vëhneh hna. ");
INSERT INTO cou_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hnë resiỹo rac dënk, nkeniho vëhery wape vële ryakëɗëho gë wëhaỹ soŋe njëkandënihëhni wape wadëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mëleka Ahwëhn a më karyëtahnikëhni taŋ do icëmb Ahwëhn a kwërëlehnëhni gë humpen hucankaf. Vëhery wape va më ntakëkëhni ɗus. ");
INSERT INTO cou_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Awa mëleka ỹa më ntehnëkëhni: «Antë ntaku! Wanës wakasëk wapërën yinenëhniɗëmu wante hnatëɗëhëhni fop ɓulunda ỹi. ");
INSERT INTO cou_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hn'uŋi mëɗ, hn'ankol David hna, nagëhnirunëha Afehët; Arëhnayik a ye, Ahwëhn a. ");
INSERT INTO cou_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Do wëli dahëse ile yavëtahnëɗunëha ỹa: tëkatëɗunëha fatah ga përyik g'iƴarëh do ntani hn'ile kwëtëndeni wusaw̃ uryav hna.» ");
INSERT INTO cou_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ga nësëk watac, kore wamëleka wakaw̃ary wante w̃atik g'ambin karyëtajëniho fëna taŋ, cëmbëndëniha W̃ënu ŋa ntehnëndëni: ");
INSERT INTO cou_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Cëmbënëfuna W̃ën Hunte Sëpëk Fop, do vële ñaɗ va araɓi nuỹani ƴam ỹa ɗuniỹa li!» ");
INSERT INTO cou_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ante mbokani wamëleka g'ambin ŋa, vëhery wape va më ntehnëlëni: «Awa ƴinëfu tameki hafo Betëlem hna: afo nuyin ile liyak hnam ỹa, ile njëtëndanëkëfu Ahwëhn aỹi.» ");
INSERT INTO cou_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Njilehnëni ñap tëkatëniha Mari gë Yosef, do gë fatah fatoƴ fa ga ndakëk hn'ile kwëtëndeni wusaw̃ ryav hna. ");
INSERT INTO cou_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ga nuniha, më tëfëtani ile ntehnëkëhniwo mëleka ỹa soŋe faŋi fatah fatoƴ fa. ");
INSERT INTO cou_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Fop vële wëryëkëhniwo vëhery wape va pëmpëhnahnëkëhniwo gë wanës wante nësëɗëniho ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ɓare ge Mari ye, waŋi fop hakili hna kwëtaɗëho do nahaɗëho. ");
INSERT INTO cou_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tac vëhery wape va mbokalehnëni gë wëhaỹ naỹënëhatëndëniha W̃ënu ŋa do cëmbëndëniha soŋe ile nkwëryëni do nuni ỹa fop; fop gante nësëhnëkëhniwo mëleka ka nkeho. ");
INSERT INTO cou_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ante nuỹako fatah fa wafac mbëɗ gë warar ŋa, fac ile kácahnëɗe ỹa yeho; hnë fac rac maciko Yesu, w̃ac ile nkabahnëko mëleka hara hnëmu ɗonkëna ten ỹa. ");
INSERT INTO cou_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wati ile rëfëkawo ntini Mari gë Yosef saɗëha pacëna ŋa rëkiko, gante ntehnëk sariya Moyis ka. Awa më njini Yerusalem Cery W̃ën Cankaf hna do njoniha fatah fa cehihna Ahwëhn a, ");
INSERT INTO cou_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kaɓi keriko fëna sariya Ahwëhn hna: «Facan fandënkwëryënkw fante wo hnagik fa Ahwëhn a sahëɗeha.» ");
INSERT INTO cou_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tëfëkawo fëna canëni saɗëha le tëƴëk sariya Ahwëhn a: «Walagi wahi ma vupah vuki.» ");
INSERT INTO cou_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yerusalem hna nkeho asan ale w̃aciko Simeỹo. Asan arac catëko do ntënënëɗëhawo W̃ënu ŋa do napëɗëhawo ale rëfëkawo njij pehëtëhni vëvë Isërayel va. Iƴir Ipacah iŋa g'umë nkeniho ");
INSERT INTO cou_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","do njëtëndanëkawo cëmëɗina hara nulahna Arëhnayik ale paƴiɗ Ahwëhn a W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Awa Simeỹo, Iƴir Ipacah iŋa hnësëndëhawo, njiko Cery W̃ën Cankaf hna. Wati rac dënk vële hnagëka Yesu va njiryejënihawo soŋe ntini ile tëƴëk sariya soŋe lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeỹo, ga nuka, njakëkawo do camehna W̃ënu ŋa ntehn: ");
INSERT INTO cou_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Tame, Ahwëhn, ntiru ile hnësënhëruhow̃o ỹa: Awa koɗu arava aryokuŋëhn hu ỹa cëm ƴam. ");
INSERT INTO cou_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nuɓuha gë vinkër mën vi dënk afehët ale faƴiru ỹa, ");
INSERT INTO cou_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","umë ye ale fëhwëtëru soŋe waɓulunda ỹa fop: ");
INSERT INTO cou_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","humpen hunte liɗ ayëti wahnënk ɗuniỹa li fop ye do umë yeɗ icëmb vëvë Isërayel, ɓulunda hu ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Vële hnagëka Yesu va pëmpëhnahnëkëhniwo gë wanës wante nësëɗëho Simeỹo soŋe lëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeỹo ndëwakëhniwo tac ntehna Mari, hnëmu Yesu: «W̃ënu ŋa tëhnaka fatah hu fi, këfahnëhni vëyaɓah do matëndëni vëryampo hnë Isërayel hna. Dahëse W̃ën yeɗ, ɓare vahnë va ŋwëỹëhnëɗëniha. ");
INSERT INTO cou_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Koyëna njëtëɗe vinahan vicow̃ak hnë vahnë vëyaɓah. Do wëjë, Mari, horot ỹa cëhëɗëhi ntaw̃ary iŋi had sëlame.» ");
INSERT INTO cou_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nkeho fëna kila asëval; Ana maciko. Rëmu Fanuwel maciko do hnë hnënk Aser hna nkentiko. Ana ntafëko ɗus. Wabëhn mbëɗ gë waki ntilahnëniho g'asan ale ỹëlëkawo hn'undag ntëw̃u hna tac asanu cëmëko. ");
INSERT INTO cou_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Asan këm fo nkoko hafo nuỹa wabëhn wafëhw imbëɗ gë warar gë wahnah (84). Cahnëɗilohna Cery W̃ën Cankaf hna do ntiỹaɗëho sali W̃ënu ŋa g'umëɗ gë g'anent: cuŋëɗëho do njëfaɗëho. ");
INSERT INTO cou_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hnë wati rac dënk tëhantikëhniwo do pëgwëlehn camehnënda W̃ënu ŋa. Do nësëndëhëhniwo soŋe fatah fa fop vële hnapëɗëho ipeh Yerusalem va. ");
INSERT INTO cou_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Vële hnagëka Yesu va, ga puhnani idi ile tëƴëk sariya Ahwëhn a, më mëncëni gë Galile nkol ntëw̃ hni hna, Nasaret. ");
INSERT INTO cou_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesu naỹëɗëho do njaw̃ëɗëho, usery lëw̃u ỹa nkwënaɗëho do W̃ënu ŋa tufahnëɗëho iña dëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bëhn-wo-bëhn vële hnagëka Yesu va njiɗëniho Yerusalem soŋe ambënt Pak ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ante nuỹako Yesu wabëhn pëhw gë waki ŋa, më njoryaryëniha gante nke namu ambënt tac ka. ");
INSERT INTO cou_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ante puk ambënt ŋa, mëncëɗëniho, ɓare Yesu Yerusalem hna nkoko do rëmu gë hnëmu vëyëtëlohna. ");
INSERT INTO cou_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ntiyahnëkëhniwo gë vërëfal hni nkentiko do fac ỹa fop njasëniho. Awa pëgwëlehnëni njëkëlehnëndëniha hnë wahnënk walëw̃ hni hna do gë wëlawo walëw̃ hni hna, ");
INSERT INTO cou_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ɓare vëhnulawohna. Mbokalehnëni gë Yerusalem nkotëni njëkëlehnëhëndëniha. ");
INSERT INTO cou_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hnë fac rarëna hna, më nuniha Cery W̃ën Cankaf hna. Fagant vëharaŋ sariya hna ntañako, nëpaɗëhëhniwo do tëƴëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fop vële wëryëɗëhawo va pëmpëhnahnëkëhniwo gante kwëhnako hakili ka do wante ntëkwaɗëho ŋa. ");
INSERT INTO cou_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Vëhni, rëmu gë hnëmu, ante nuniha ŋa, pëmpëhnahnëkëhniwo ɗus. Hnëmu më ntehnëka: «Ajë mën, soŋe ye liruhëfu aki? Rëmuh g'ami ndëñakëɓun ɗus ayëkëlehnatënde.» ");
INSERT INTO cou_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Më ntëkwakëhni: «Soŋe ye ga yëkëlehnëɗunëho? Ƴëtëluhna bi tëfëko yewu cery Rëm mën hna?» ");
INSERT INTO cou_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɓare vëyëtëlohna ile ntehnëɗëhëhniwo ỹa. ");
INSERT INTO cou_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu mëncëntëlehni gë Nasaret do nkoko ntënënëndëhni. Wante liyak ŋi fop, hnëmu hakili hna kwëtako. ");
INSERT INTO cou_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Awa Yesu hakili ỹa nkwënaɗëhawo, naỹëɗëho do nkeya ntëw̃u ŋa nëŋahnëkawo W̃ënu ŋa gë vahnë va. ");
INSERT INTO cou_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awa hnë bëhn le nuỹahnëko Tiber wabëhn pëhw g'imbëɗ (15) ga nkehahnëko Ahnaw̃ fop vankal vante kwëhnëko Rom va, Pos Pilat yeho guverëner vë Yuɗe ỹa, Eroɗ hnaw̃ëko hnë resiỹo Galile hna do aheryu, ale w̃aciko Filip ỹa, umë hnaw̃ëndiko hnë resiỹo Iture hna gë Tërakonitis hna, Lisaniyas yeho guverëner vë Abilen ỹa, ");
INSERT INTO cou_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","do Anas gë Kayif yeho vësankaf vësëna wasaɗëha va. Hnë wati rac nuỹako San, aju Sakari, wanës W̃ënu ŋa wula hna. ");
INSERT INTO cou_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tac ndapëko inkal ɓë sën sankaf Yurëdan hna fop ntehnatëndëhni vahnë va: «Gwëcëtaryin vankeya va, ayaryiwu do W̃ënu ŋa tavëndëhu wameh hun ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Koyëna ntiyako ile kerëko kila ile w̃aciko Esayi ỹa kayëte ntëw̃u hna: «Nëparyin! Asan ryekaɗ wula hna, më lehnëɗ: “Pëhwëtëryin nkaw̃ Ahwëhn a, dinëndina vankaw̃ vacatah ɗus! ");
INSERT INTO cou_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vankëɗ va gë wahuŋ w̃a fop këñëndëlehnëɗe; vankaw̃ vatumpak va catënëɗe, vankaw̃ vapërëkak va fop pëhwëtëɗe. ");
INSERT INTO cou_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Do vahnë va fop nuɗëni ipeh inte w̃atik hnë W̃ën.”» ");
INSERT INTO cou_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kore vahnë yijëko vëhni San hna soŋe njaryëhni. Ntehnëɗëhëhniwo: «W̃uhnë, merun had walën wayapah! Mo lehnëku yaryi ỹi fo koɗ pehëtu ntavah cankaf W̃ën nte yejëk ŋi. ");
INSERT INTO cou_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Atëh përën wadëw̃el wapërën ntëw̃ëɗ; diryindën viỹë vifërën arufahnahnu nkwëcëtarun vankeya va! Ant'ahnahandu: “Rëm sankaf fu ỹa, Abëraham ye”, had watac nkwërënkeɗ afehëtahniwu. Pëƴaɗëmu: W̃ënu ŋa koɗ dënk nti waỹi wëraka vutah Abëraham! ");
INSERT INTO cou_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Rasëhn ỹa pëhwëtak ŋos vatëh va koɓëri vënkahn hna: Atëh nte-wo-nte wok dëw̃ëɗina wadëw̃el wapërën ŋa ŋosëɗe do ntabi gë hwëɗëh.» ");
INSERT INTO cou_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Vahnë va tëƴëɗënihawo: «Ye rëfëkëfu lifu?» ");
INSERT INTO cou_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Më ntëkwakëhni: «Ale hwëhnak vacuɗ vaki tëfëka njëɗa ndampo ale wok kwëhnana do ale hwëhnak rokëtok tëfëka cehahn.» ");
INSERT INTO cou_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Vërëf ỹatëtanke fëna njijëniho njaryaryini. Më tëƴëniha: «Aharaŋ, fuhnë lë, ye rëfëkëfu lifu?» ");
INSERT INTO cou_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Më ntëkwakëhni: «Ant'asosehnuni vahnë va ntëbi ile lehnirun arëƴuni ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wasoɗaɗe fëna tëƴëntinihawo: «Fuhnë lë, ye rëfëkëfu lifu?» Më ntëkwakëhni: «Ant'ahnufu koryi ahnë gë fanka ma gë wamërahn, ɓare cosë hun iŋa nkewu gwër.» ");
INSERT INTO cou_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓulunda ỹa napëɗënihawo Arëhnayik a: ale-wo-le tëƴaɗëho bi San ye? ");
INSERT INTO cou_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awa San më ntehnëkëhni vëhni fop: «Ami, gë w̃ënka njaryëɗëmu; ɓare ale yejëk a umë lëbëko: catëla dënk fëtahnu viỹëba wapary wadëw̃u ŋa. Umë, g'Iƴir Ipacah do gë hwëɗëh njaryëɗëhu. ");
INSERT INTO cou_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Vák hna mënkwëk ɓëryew̃ iŋa pitëndëlehnahn waŋëc ŋa gë vaparyel va. Ndanëɗ waŋëc ŋa ndank ntëw̃u hna, ɓare vaparyel va pëɗëɗ hnë hwëɗëh hunte wok ɗipëɗina muk.» ");
INSERT INTO cou_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","San nkabëɗëhëhniwo ɓulunda ỹa waƴaɓah wakaw̃ary do pëƴaɗëhëhniwo Wanës Wakasëk ŋa. ");
INSERT INTO cou_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hnë wati rac, San nirakawo fëna Eroɗ ale hnaw̃ëko Galile ỹa, kaɓi Eroɗ asëval acëru ỹa ñëlëko —Erodiyaɗ maciko— do kaɓi ntiko fëna viw̃eh viyaɓah vihaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tac Eroɗ mboko nti w̃eh haw̃ary kat: cëɗehnëkawo San. ");
INSERT INTO cou_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","San, ga njaryëkëhni vahnë va fop, njaryëkawo Yesu fëna. Tac, wati nte njëfaɗëho Yesu ŋa, ambin ŋa piɗëtako, ");
INSERT INTO cou_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iƴir Ipacah iŋa cëlëlehni hnë umë; gë fah mëntëlëniho. Tac kopa vë g'ambin nkwëryëlehni ga ntehnëɗ: «Ajë mën ale ỹaɗëfu ɗus a yeru; gë wëjë nëŋëko ɗus.» ");
INSERT INTO cou_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu mpëd tëkëkawo wabëhn wafëhw warar (30) ante pëgwëko ɗoku lëw̃u ŋa. Vahnë va fatah Yosef ntinihawo, ale nagëko Heli ỹa, ");
INSERT INTO cou_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nte nagëko Matat, Matat nte nagëko Levi, Levi nte nagëko Melëki, Melëki nte nagëko Yanayi, Yanayi nte nagëko Yosef, ");
INSERT INTO cou_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef nte nagëko Matatiyas, Matatiyas nte nagëko Amos, Amos nte nagëko Nawum, Nawum nte nagëko Hesëli, Hesëli nte nagëko Nagayi, ");
INSERT INTO cou_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi nte nagëko Mat, Mat nte nagëko Matatiyas, Matatiyas nte nagëko Semeyin, Semeyin nte nagëko Yosek, Yosek nte nagëko Yoda, ");
INSERT INTO cou_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda nte nagëko Yowanan, Yowanan nte nagëko Resa, Resa nte nagëko Sorobabel, Sorobabel nte nagëko Salatiyel, Salatiyel nte nagëko Neri, ");
INSERT INTO cou_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nte nagëko Melëki, Melëki nte nagëko Adi, Adi nte nagëko Kosam, Kosam nte nagëko Elëmadam, Elëmadam nte nagëko Er, ");
INSERT INTO cou_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nte nagëko Yesu, Yesu nte nagëko Eliyeser, Eliyeser nte nagëko Yorim, Yorim nte nagëko Matat, Matat nte nagëko Levi, ");
INSERT INTO cou_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi nte nagëko Simeỹo, Simeỹo nte nagëko Yuɗa, Yuɗa nte nagëko Yosef, Yosef nte nagëko Yonam, Yonam nte nagëko Eliyakim, ");
INSERT INTO cou_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim nte nagëko Meleya, Meleya nte nagëko Mena, Mena nte nagëko Matata, Matata nte nagëko Natan, Natan nte nagëko David, ");
INSERT INTO cou_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David nte nagëko Yese, Yese nte nagëko Yobed, Yobed nte nagëko Bos, Bos nte nagëko Sala, Sala nte nagëko Nason, ");
INSERT INTO cou_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nte nagëko Aminadab, Aminadab nte nagëko Adëmin, Adëmin nte nagëko Arëni, Arëni nte nagëko Hesëron, Hesëron nte nagëko Peres, Peres nte nagëko Yuɗa, ");
INSERT INTO cou_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuɗa nte nagëko Sakob, Sakob nte nagëko Isak, Isak nte nagëko Abëraham, Abëraham nte nagëko Tara, Tara nte nagëko Nakor, ");
INSERT INTO cou_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor nte nagëko Seruk, Seruk nte nagëko Ragawo, Ragawo nte nagëko Falek, Falek nte nagëko Eber, Eber nte nagëko Sala, ");
INSERT INTO cou_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nte nagëko Kayënam, Kayënam nte nagëko Arafakad, Arafakad nte nagëko Sem, Sem nte nagëko Nowe, Nowe nte nagëko Lamek, ");
INSERT INTO cou_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nte nagëko Matusala, Matusala nte nagëko Enok, Enok nte nagëko Yarët, Yarët nte nagëko Malëlel, Malëlel nte nagëko Kayënam, ");
INSERT INTO cou_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayënam nte nagëko Enos, Enos nte nagëko Set, Set nte nagëko Adam, ajë W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu g'Iƴir Ipacah pëɓah mbokajëɗëho gë sën, le w̃acik Yurëdan ka, njolehna Ƴir iŋa wula hna. ");
INSERT INTO cou_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hnam njëkëhnahnëɗëhawo Sintani menehna. Ñoñ tokëɗilohna hnë wafac wafëhw wahnah. Ga ndëcëk, umë njoka inte ɗus. ");
INSERT INTO cou_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Awa, Sintani më ntehnëka: «Ge paryi Ajë W̃ën yeru, dehnëryehna iŋi taka mbaca mburu.» ");
INSERT INTO cou_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu më ntëkwaka: «Vikerëh W̃ën va pëƴahnëk, “Ahnë gena roka fo valëɗëha ñëw̃ahn ɗuniỹa li.”» ");
INSERT INTO cou_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tac Sintani më mbok njoka hn'ile ñak njihnëk, tufëka fop wahnaw̃ wavë ɗuniỹa w̃i hwënta ryampo fo. ");
INSERT INTO cou_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tac ntehna: «Njëɗaɗëmi fop ucankaf gë hnapul gë icëmb waỹi wahnaw̃ fop. Iỹin fop nuỹaɓu do koɗëfu yëɗaw̃a ale ỹaɗëfu. ");
INSERT INTO cou_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Age ndëkwëhnëru haryënkw mën soŋe asëmbo, fop wëjë hwëhnëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu më ntëkwaka: «Vikerëh va pëƴahnëk: “Ɗëkwëhnëhnëryehna Ahwëhn a W̃ënu ŋa do umë fo rëfëka aryokuŋëhnënd.”» ");
INSERT INTO cou_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tac Sintani më njoka Yerusalem, tindëka cëmët Cery W̃ën Cankaf hna do ntehna: «Age Ajë W̃ënu ŋa yeru, dëɗary gëɗ, ");
INSERT INTO cou_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kaɓi Vikerëh va pëƴahnëk: «“W̃ënu ŋa ntehnëɗëhëhni wamëleka wadëw̃u ŋa keryëndënihi.” ");
INSERT INTO cou_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","«Tac: “Njakëndënihi wëɓák wadëw̃ hni hna kehahnënihi ant'aw̃ëw̃ taka.”» ");
INSERT INTO cou_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu më ntëkwaka: «Vikerëh va pëƴahnëk: “Ant'ayëkëhnahna Ahwëhn a W̃ën hu ŋa.”» ");
INSERT INTO cou_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sintani, ga puhnak ƴëkëhnahn menehna Yesu ŋa fop, ŋaw̃ëtalehna hafo nkaw̃ kaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu mbokako Galile. Iƴir Ipacah iŋa njëɗaɗëhawo fanka ntihahn fop ile ntiɗëho ỹa. Koyëna w̃ac lëw̃u w̃a campëko vankol hna fop. ");
INSERT INTO cou_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Karaŋëɗëhëhniwo vahnë va vacaliŋa wasëwif hna do vahnë va fop cëkwaryëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Fac ryampo, Yesu më njik nkol nte w̃aciko Nasaret hn'ile kwëɗiko hna. Fac ntaw̃ëla wasëwif hna, më tënkëk caliŋa hna gante njehëka ka. Matëko karaŋ Vikerëh va. ");
INSERT INTO cou_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Umë njëɗayik kayëte nte kerëko kila le w̃aciko Esayi. Piɗëtëk do tëkat hn'ile kerik: ");
INSERT INTO cou_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Iƴir Ahwëhn a hnë ami nke, umë rëhnako, soŋe yonëhnëw̃ëhni vëhaỹëhnah va Wanës Wakasëk ŋa; paƴiko fëƴaw̃ëhni vëramp va tavëɗeni, vumëp va nuɗëni, vële vërehnik va nkeɗëni afaya lëw̃ hni, ");
INSERT INTO cou_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pëƴaɗëmu bëhn le pehëtahnëɗëhëhni Ahwëhn a ɓulunda lëw̃u ỹa tëkik.» ");
INSERT INTO cou_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ga puhnak karaŋ iŋa, Yesu më piɗëk Vikerëh va mbësahna ale hwëtëɗa do ntaña. Fop vële yeho caliŋa va ntaŋënihawo. ");
INSERT INTO cou_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pëgwëlehn ntehnëndëhni: «Dol vikerëh vinte haraŋëɓu vi ntiyak wati le hnëpaɗunëho ỹi dënk.» ");
INSERT INTO cou_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vahnë va fop nësëɗëniho wanës wapërën Yesu do pëmpëhnahnëkëhniwo ɗus wanës waɓënak wade nësëɗëho ŋa do ntehnëɗëniho: «Ɓare aỹi gena bi aju Yosef?» ");
INSERT INTO cou_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu më ntehnëkëhni: «Pacahnëko ndënkwëtehnëɗunëho ile nësëɗëni vëyaɓah: “Ayërën, ƴërënary wëjë dënk.” Ntehnëɗunëho fëna: “Njëtaɓun fop ile liru Kaperënaỹum ỹa. Diry gë rac ki ani fëna hnë nkol ntëw hu li dënk kaɓi ani naỹëru.”» ");
INSERT INTO cou_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tac më nkwënëk: «Toña ỹa fëƴaɗëmu: wëla kila ryampo dënënëɗena nkol nte naỹahnëk. ");
INSERT INTO cou_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Paryi pëƴaɗëmu, ƴamani kila le w̃aciko Eli ỹa, njaɓëniho vësëval vële cëmaryëko vësan Isërayel hna. Wati rac nkoko gona tëvënd hnë wabëhn watar gë fagant bëhn do inte cankaf yeho nkal hna fop. ");
INSERT INTO cou_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɓare W̃ënu ŋa paƴëlawohna Eli wëla hnë aryampo hnë vësëval wasëwif vërac, ɓare hnë aryampo fo paƴëkawo ale lëɗëko Sarëpëta hnë nkol cankaf mbë Sidon hna. ");
INSERT INTO cou_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nkeniho, ƴamani kila Elise ỹa fëna vëhwëhn vambiỹ vëyaɓah Isërayel hna. Ɓare wëla aryampo hnë vërac hna ƴërënilohna ge gena avë Siri ale w̃aciko Naman ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ga nkwëryëni watac, vële yeho caliŋa va pëɓëlehnëkëhniwo ntavah. ");
INSERT INTO cou_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Matëlehnëni canëniha nkol hna njoniha ƴaŋ vampamb kuŋ nte vëryahniko nkol ŋa soŋe cañëtëniha njo gëɗ. ");
INSERT INTO cou_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ɓare Yesu më ndëcëk fagant lëw̃ hni nji nkaw̃ ntëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu cëlëndako Kaperënaỹum, nkol mbë Galile. Vahnë karaŋëɗëho fac ntaw̃ëla hna ");
INSERT INTO cou_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","do pëmpëhnahnëkëhniwo gante karaŋëɗëhëhniwo ka, kaɓi g'ucankaf nësëɗëho. ");
INSERT INTO cou_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Caliŋa hna nkeho ale pëlako ƴine w̃eh. Umë ndekak gë fanka ntehn: ");
INSERT INTO cou_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Yesu vë Nasaret, ye ye yëbëlan fu? Afërëkanëfu bi yijëru? Njëtëɓu ɗus bi mo yeru: Afacah ale paƴik W̃ënu ŋa yeru!» ");
INSERT INTO cou_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu më ŋañënahnëka ntehna: «Ɗemëhnary do cahnëryehna aỹi asan.» Awa, ƴine ỹa këfëlehna asan a tase vahnë fop, cahnëlehna hara dilahna w̃eh. ");
INSERT INTO cou_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vële hnuko umë va fop ŋaƴëkëhniwo do ntehnëlëndëni: «Iỹëhne sifa wanës ye ye waŋi?» Ntehnëɗëhëhni waƴine ŋa g'ucankaf do gë fanka: «Cahnëryehna!» do cahnëɗ. ");
INSERT INTO cou_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Koyëna w̃ac Yesu ỹa campëko caharaɓ vankol hna fop. ");
INSERT INTO cou_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tac Yesu cahnëko caliŋa hna nji tere asan ale w̃aciko Simo. Awa hnëmu asëvalu Simo tesëko, mbahn iŋi njakëkawo ɗus. Umë muntaniha Yesu ndemahna. ");
INSERT INTO cou_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Më njik cëpëka ŋañënahna res w̃a do res w̃a cahnëlehna. Wati rac dënk matëlehn asëval a pëgw nëhëtëhnëndëni. ");
INSERT INTO cou_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wati le njoɗëho lav w̃a, fop vële hwëhnakëhniwo vëres, sifa wates wanëmpëlah, njinenëhnijikëhniwo Yesu, tindëɗëhëhniwo wëɓák wadëw̃u ŋa vëhni fop soŋe njërënahnëhni do njërëniho. ");
INSERT INTO cou_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Waƴine fëna sahnëɗëhëhniwo vëyaɓah ndekatëndëni: «Ajë W̃ën yeru». Ɓare Yesu ŋañënahnëɗëhëhniwo soŋe ndemëhnani kaɓi njëtëniho vëhni umë ye Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wakëwak fo Yesu cahnëko nji hn'ile njirëk. Kore ỹa njëkëlehnëɗënihawo. Ga nuniha ñaɗëniho nkonti gë vëhni, antë nji tavëhni. ");
INSERT INTO cou_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɓare Yesu më ntehnëkëhni: «Vankol vañëntaw̃ hna fëna tëfëko fëƴahnu Wanës WakasëkNaw̃ W̃ënu ŋa; soŋe umë paƴiko.» ");
INSERT INTO cou_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pëƴaɗëhëhniwo fëna vacaliŋa vamb vankol wasëwif hna. ");
INSERT INTO cou_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Fac ryampo, Yesu kahnëko vambamb lant sankaf Senesaret hna do peñëlëɗëniho kore ỹa caharaɓ lëw̃u soŋe nëpani wanës W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Umë nuk wakulu waki tëfary hna. Vëfëla wuwis va cëlëniho ndagëndëni waryeƴ wale pëlahnëɗeni uwis. ");
INSERT INTO cou_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kaƴëlehn hnë kulu ryampo le kwëhnëko Simo, më tëƴëka ŋaw̃ëta vambëŋ va toƴe. Yesu ntañalehn kulu hna pëgw karaŋëndëhni kore ỹa. ");
INSERT INTO cou_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ga puhnak wanës ŋa, më ntehnëka Simo: «Njiryeryëry kulu ỹi hn'ile ñak tëw̃ëk w̃ënka ŋi toƴe. Tac wëjë gë vërëfal hu vi alabu waryeƴ w̃i afëlahnuni wuwis.» ");
INSERT INTO cou_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo më ntëkwaka: «Asankaf, ga mbër nkwayankëtalehnëkëfu, ñoñ pëlalëfuhna. Ɓare, kaɓi ntehnëruho labu, ntabëɗëfu.» ");
INSERT INTO cou_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ntabëlehnëni, pëlanihëhni wuwis wuyaɓah hafo waryeƴ w̃a pëgw mbëkëtand. ");
INSERT INTO cou_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Më njelanihëhni vërëfal hni vëvë kulu ỹëntaw̃ va njijëni ndemanihëhni. Vëhni më njijëni do pëɓënëniho wakulu waki tak wuwis w̃a hafo ñand tëmpani. ");
INSERT INTO cou_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simo Piyer, ga nuk watac, umë ndëkwëhnëk karyënkw Yesu do ntehna: «Ahwëhn, ŋaw̃ëtarye kaɓi asan aw̃en yeɓu.» ");
INSERT INTO cou_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simo gë vële nkeniho va, fop pëmpëhnahnëkëhniwo do ntakëni, kaɓi pëlanihëhniwo wuwis uyaɓah urac. ");
INSERT INTO cou_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Koyëna nkehëhniwo fëna Sak gë San, viju Sebede vële mbankëniho ɗoku Simo va. Yesu më ntehnëka Simo: «Antë ntaki. Tëk pëgw ỹi wati vahnë rëkëɗu afëland.» ");
INSERT INTO cou_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mbokaryëlehnëni wakulu ŋa vambëŋ hna, tavëlehnëni fop tëfëlehnëndëniha. ");
INSERT INTO cou_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ante nkeho Yesu hn'ankol ndanko, njijëko asan ale yeho mbiỹ fo. Arac, ga nuka Yesu, më ndëkwëhnëk karyënkw lëw̃u yëka ỹi nkal li do muntahna ntehna: «Ahwëhn, ge ñaɗu koɗu ayërëno, afacënëlehno.» ");
INSERT INTO cou_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu më njelëk vák ỹa ñaka do ntëkwahna: «Ñaɗëfu: Pacëry!» Wati rac dënk mbiỹ dëw̃u ŋa ntavëka. ");
INSERT INTO cou_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu më ntehnëka: «Antë afëƴahna ahnë waŋi, ɓare ƴiry njëki asëna wasaɗëha ỹa do canëry saɗëha soŋe ƴërën hu ŋa ile kerëko Moyis ntinde ỹa. Koyëna vahnë va njëtëɗëni pacëru.» ");
INSERT INTO cou_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mama ntehnëkawo asan a antë pëƴahn, w̃ac lëw̃u w̃a campëɗëho g'ahaw̃ary, ɓulunda varëpëlëɗëho nkwëryëndëniha do njërënëndeni wates wadëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ɓare Yesu umë pitaɗëho hn'ile njihnëk njëfand. ");
INSERT INTO cou_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Fac ryampo, Yesu karaŋëɗëhëhniwo vahnë. Wafarise gë vëharaŋ sariya Moyis va lañantiko hnam. Fop vunkol vumb Galile, Yuɗe do g'inaw̃ Yerusalem matiniho. Fanka W̃ën fa gë Yesu nkeho, njërënahnëhni vëres. ");
INSERT INTO cou_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tac vësan rëkiko vële ryiɓika hnë ƴala ares ale yeho vorovoro. Ñaɗëniho ndënëniha, kwëtëniha haryënkw Yesu ");
INSERT INTO cou_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ɓare vëhnuỹalohna fere; vahnë va pëɓëniho. Awa umë kaƴëni ƴaŋ cery hna ntihëtëni vile rëjahnik va, do cëlëndëniha gë ƴala per tase vahnë fop haryënkw Yesu. ");
INSERT INTO cou_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ga nuk Yesu kwëtahn dëw̃ hni ŋa më ntehnëka ares a: «Lawo, wameh hu ŋa tavëhniru.» ");
INSERT INTO cou_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Vëharaŋ sariya Moyis va gë wafarise w̃a më nahaɗëni ntehnëndëni: «Mo ga dënk ye aỹi asan ale yew̃ëɗëha W̃ënu ŋa? Mo hoɗ tavëhn wameh ŋa? W̃ënu ŋa fo hoɗ!» ");
INSERT INTO cou_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ɓare Yesu njëtëko vinahan vidëw̃ hni va, më ntehnëkëhni: «Soŋe ye hnahaɗun koyëna? ");
INSERT INTO cou_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ge ntehnëɓu: “Wameh hu ŋa tavëhniru”, ma ge ntehnëɓu, “Matëry do ƴasëry?” ryampo bi ỹak hnëŋëk nësi hnë waŋi? ");
INSERT INTO cou_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ɓare ñaɗëfu ayëtu Ajë Ahn'a kwëhnak fanka tavëhn wameh ɗuniỹa li.» Awa më ntehnëka ares a: «Ami ntehnëɗëmi, matëry, ahnuf ƴala hu ỹi, aw̃ënc gë ỹal hu.» ");
INSERT INTO cou_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Matëlehn taŋ asan a tase vahnë fop, nuf ƴala le ndakahnakëh ỹa, mënc cëmbëhatënda W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kore ỹa fop pëmpëhnahnëkëhniwo më cëmbëɗëniha W̃ënu ŋa. Ntakëhni do nësëlëndëni: «Nuɓun dol viỹë vile nkok nahaɗina ahnë.» ");
INSERT INTO cou_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ga ndëcëk rac, Yesu cahnëko më nuka arëf ỹatëtanke, ale w̃aciko Levi, laña lëw̃u hna. Yesu më ntehnëka: «Tëfe!» ");
INSERT INTO cou_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi matëlehn, tav fop, tëfëlehna. ");
INSERT INTO cou_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tac Levi më ntëvaka lëv sankaf tere lëw̃u hna. Vërëf ỹatëtanke vëyaɓah gë vëhaw̃ary ntañalahnëniho rok roka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wafarise w̃a gë vëharaŋ sariya va mëhnaɗëniho soŋe rac. Më ntehnëɗënihëhni vërëfal Yesu va: «Soŋe ye rokëlahnëɗun, selahnëɗun gë vërëf ỹatëtanke do gë vëw̃en vi?» ");
INSERT INTO cou_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu më ntëkwakëhni: «Vële wok vëresëna va ɓalëlëhnihna g'ayërën; vëres va mbalëk. ");
INSERT INTO cou_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ƴijëla w̃acëw̃ëhni vësatah; mac vëw̃en yijëɓu soŋe nkwëcëtahnëni vankeya vantëw̃ hni va.» ");
INSERT INTO cou_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tac wafarise w̃a ntehnënihawo Yesu: «VërëfalSan Ayary a gë vëlëw̃ fu va cuŋëɗëni kwëlëkwël do njëfaɗëni, ɓare vërëfal hu vi vëhni tokëɗëni do ceɗëni kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu më ntëkwakëhni: «Koɗena cuŋëndanini vëfaƴ iñël va antë tokëni wati nte nkelahnëni g'ale ỹëlëk a; ");
INSERT INTO cou_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","wati yejëk ile nufëhnahnëɗeniha ale ỹëlëɗ a: wafac warac cuŋëɗëni vërëfal mën va.» ");
INSERT INTO cou_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tac Yesu më mëntëndëlehnëk: «Ahnë citëɗina cuɗ kasëk pëhwëtahn cuɗ cër. Ge gena umë përëkanëɗ kasëk ŋa do citel ŋa tëfëlandina g'icër ŋa. ");
INSERT INTO cou_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ahnë taw̃ëɗina ñen kasëk ŋa hnë waryëpët wasër; ge gena umë, ñen kasëk ŋa përëkanëɗ waryëpët wale wok gona talënd w̃a; ñen ŋa tënkenëɗ do waryëpët w̃a përëkaɗ. ");
INSERT INTO cou_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɓare tëfëka taw̃i ñen kasëk hnë waryëpët wahasëk. ");
INSERT INTO cou_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ale sek uñen ucër ñaɗina kasëk. Ntehnëɗ ucër uŋi gwërënkeha.» ");
INSERT INTO cou_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hnë fac ntaw̃ëla hna Yesu gë vërëfal vëlëw̃u va nɗëcëtaɗëniho wëhaỹ wale lafëk vantimp. Vërëfal va pëgwëlehnëni nkubëndëni vantimp va, ŋwëỹehnëni wëɓák wadëw̃ hni hna, cemëni waŋëc ŋa. ");
INSERT INTO cou_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wafarise wëryampo wale yeho hnam w̃a më ntehnënihëhni: «Soŋe ye liɗun le nkok maw̃ëryana sariya fu ỹa ntiyi hnë fac ntaw̃ëla hna?» ");
INSERT INTO cou_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu më ntëkwakëhni: «Karaŋëluhna bi ile ntiko David fac ryampo ante njokëhniwo inte, umë gë vërëfëlëntaw̃u va? ");
INSERT INTO cou_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gena bi tënkëko cery W̃ën hna, nuf mburu ante kwëtëhniko W̃ënu ŋa, tok do njëɗahni vërëfëlëntaw̃u va? Hara sariya fu ỹa, vësëna wasaɗëha fo maw̃ëryanëko tokëni.» ");
INSERT INTO cou_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu mboko nkwën kat: «Ajë Ahn'a umë ye ahwëhn fac ntaw̃ëla ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Fac ntaw̃ëla kaw̃ary, Yesu tënkëko caliŋa hna karaŋëndëhni vahnë va. Nkeho hnam asan ale cëmëko vák rëhw ỹi. ");
INSERT INTO cou_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vëharaŋ sariya va gë wafarise w̃a njëkëɗënihawo Yesu bi njërënëɗëha ahnë hnë fac ntaw̃ëla hna nuỹahnëni ile pëƴahnëɗëni menëk pëlahni. ");
INSERT INTO cou_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ɓare njëtëko vinahan vidëw̃ hni va. Më ntehnëka asan ale cëmëko vák ỹa: «Matëry, ahahn fagant.» Asan a matëlehn kahn. ");
INSERT INTO cou_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tac Yesu më ntehnëkëhni: «Tëƴëɗëmu: Ye ntehnëk sariya fu ỹa? Ntiyi ufërën fac ntaw̃ëla ma uw̃eh? Afehëta ahnë icëm ma aryaw̃a?» ");
INSERT INTO cou_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Më njëkëkëhni fop tac ntehna asan a: «Ƴeli vák hu ỹi.» Më njelëk do vák ỹa mbokalehna fërën fo. ");
INSERT INTO cou_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Awa vëharaŋ sariya va gë wafarise w̃a ntavëkëhniw̃o ɗus soŋe rac. Më nkwajëlëɗëni bi hak tëfëka ntiniha Yesu. ");
INSERT INTO cou_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wati rac Yesu kaƴëko hn'ikuŋ njëfahna W̃ënu ŋa; mëɗ uŋa fop njëfako. ");
INSERT INTO cou_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ga pacëk, më macëkëhni vërëfal vëlëw̃u va tëhnakëhni pëhw gë vëhi do macëhni vëfaƴik. ");
INSERT INTO cou_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Vëhni ye: Simo, ale macëko Piyer, g'aheryu Andëre, ale nkeni rëm gë hnëm; Sak gë San; Filip gë Barëtelemi; ");
INSERT INTO cou_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye gë Toma; Sak aju Alëfe gë Simo nte w̃acëɗeho Ahahnëndak a; ");
INSERT INTO cou_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuɗa aju Sak gë Yuɗa Isëkariyot, ale yeɗ aroka Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu më cëlini kuŋ hna gë vërëfal vëlëw̃u va do tëryani hnë igwac inte këñëlahnëk nkal iŋa. Nkeniho hnam kore sankaf vërëfal vëlëw̃u. Nkentiniho fëna hnam vahnë vëyaɓah vëhaw̃ary: vahnë vëvë vankol Yerusalem gë vankol Yuɗe hna fop, gë wahnaw̃ wavë tëfary wov w̃a, Tir gë Sidon. ");
INSERT INTO cou_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nëpaniha njijëniho do njërënëhni wates wadëw̃ hni. Njërënëkëhniw̃o fëna vële pëlaniho waƴine. ");
INSERT INTO cou_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vahnë va fop ñaɗëniho ñakëniha, kaɓi fanka sahnëɗëhaw̃o njërënëɗëhëhniw̃o fop. ");
INSERT INTO cou_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu njëkëkëhniwo vërëfal vëlëw̃u va do ntehn: Mbetarun w̃uhnë vële haỹëhnëk kaɓi Inaw̃ W̃ënu ŋa w̃uhnë hwëhnëk! ");
INSERT INTO cou_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbetarun w̃uhnë vële njok inte gaki vi, kaɓi fac yejëk pihnëɗun ɗus. Mbetarun vële hoɗ gaki vi kaɓi fac yejëk ndasëɗun. ");
INSERT INTO cou_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mbetarun ge vahnë va ñew̃ënihu, ge ntaɗënihu, njew̃ëɗënihu, ntehnëɗënihu merun kaɓi kwëtahnërunëha Ajë Ahn'a. ");
INSERT INTO cou_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Natëryiw̃u ge vahnë va aki ntiɗënihu kaɓi icos sankaf hnapëɗëhu ambin hna. Vacërakëlo hni va fëna aki ntiɗënihëhniwo wakila W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Meku w̃uhnë vële vetak vi kaɓi rëkërun ahnuỹaw̃u hnëŋah hun ỹa. ");
INSERT INTO cou_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Meku w̃uhnë vële fihnëk gaki vi kaɓi inte ŋa njoɗëhu. Meku w̃uhnë vële ryasëɗ gaki vi kaɓi uyiw̃ëhnah hna nkeɗun do koɗun. ");
INSERT INTO cou_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Meku w̃uhnë ge vahnë va fop wapërën hun nësëɗëni, kaɓi vacërakëlo hni va fëna aki ntiɗënihëhniw̃o vëw̃ër vële w̃ëcaɗëho wakila va. ");
INSERT INTO cou_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu mbok nës kat: «W̃uhnë vële wëryëɗëho vi, lehnëɗëfu: ŋahnëryinëhni vële wok vëỹaɗiluhna va, dinëhnëryinëhni ufërën vële ỹew̃ëku va. ");
INSERT INTO cou_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɗëwanëhnëryinëhni ufërën vële ryëwanëhnëɗëhu uw̃eh va do ayëfanëhnënduni vële liɗëhu uw̃eh va. ");
INSERT INTO cou_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ge ahnë njew̃ëki tavëryehna mbok njew̃i hara gwëcagëlihahna; ge ahnë teɓëki cuɗ cankaf ŋa taveryëryehna njoryary fatoƴ fa fëna. ");
INSERT INTO cou_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ƴëɗaryehna ale-wo-le w̃untaki iñë, do ge ahnë nufëhnëki iñë ile hwëhnëru, ant'aryëñana. ");
INSERT INTO cou_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dinëhnëryinëhni vahnë va ile ỹaɗun ntinëhnënihu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Ge vële ỹahnëku fo ỹahnërun mo sëkwaryëɗëhu? Wëla vëw̃en va ŋahnënihëhni vële ỹahnëkëhni va. ");
INSERT INTO cou_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Fëna ge vële linëhnëɗëhu fërën fo linëhnëɗun fërën, mo sëkwaryëɗëhu? Vëw̃en va fëna ntiɗëni koyëna. ");
INSERT INTO cou_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ge navehnëɗunëhëhni vële liyahnëku mbësaɗënihu va fo, soŋe ye hnapëɗun icëkwary? Vëw̃en va fëna navehnëɗënihëhni vëw̃en ntahni soŋe mbësanihëhni ile navehnënihëhni ỹa fo. ");
INSERT INTO cou_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɓare ant'aliwu koyëna. Ŋahnëryinëhni vële ỹew̃ëku va, dinëhnëryinëhni fërën do ahnavehnëndu hara nahaluhna avësayiw̃u. Koyëna cos hun ŋa njaɓëɗ do tufahnëɗun vutah W̃ën Hunte Sëpëk Fop yerun. Përënak umë dënk gë vahnë vële wok vësamehnëɗina muk va. ");
INSERT INTO cou_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ƴaɓëryiw̃u ipërëna gante njaɓëka Rëmun përën aki. ");
INSERT INTO cou_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ant'ahitiŋu nkeya aỹënta hun do kitiŋëɗeluhna w̃uhnë fëna; ant'ahoƴawuna aỹënta hun do koƴaɗeluhna w̃uhnë fëna; tavëhnëryinëhni vëỹënta hun va do tavëhnëɗerun w̃uhnë fëna. ");
INSERT INTO cou_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ƴëɗahnëryin do njëɗëɗerun w̃uhnë fëna; taw̃ëhnëɗerun ñaŋëh nte soryik do ñënkëlehni ndehëtand ki fo; ga ñëŋa ante ỹaŋëhnahnëɗunëhëhni vahnë ŋa ñaŋënahnëɗerun w̃uhnë dënk.» ");
INSERT INTO cou_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu mboko mëntëndëlehnëhni: «Umëp koɗina kaha mëp ntaw̃u hara vëyona hnë hatëh vëhni vëhi tak. ");
INSERT INTO cou_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Fakaraŋ fante lëbëka aharaŋ alëw̃u gena; ɓare fakaraŋ fante haraŋëk hafo puhna had aharaŋ alëw̃u nkeɗ. ");
INSERT INTO cou_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Soŋe ye yëkëɗu ivëɗ le ye inkër aỹënta hu do hara kamantihna bërëh bële yehi nkër hu hna? ");
INSERT INTO cou_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wëjë, ale wok nuɗila bërëh bële yehi nkër hu hna, hak koɗu alehna aỹënta hu ỹa: “Aỹënta mën, napërye lihëti ivëɗ le yehi nkër li”? Wëjë, ale ntiyahnëk catëru alëbëhni vëỹëntaw̃, dihëtary ten bërëh bële yehi nkër hu hna tac nuɗu ɗus alihëtahn ivëɗ le ye nkër aỹënta hu ỹi. ");
INSERT INTO cou_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Atëh përën dëw̃ëɗina viw̃eh, atëh meh fëna dëw̃ëɗina vifërën. ");
INSERT INTO cou_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atëh-wo-tëh njavëtëtëɗe gë vantëw̃el vantëw̃u va: kwëcëɗena wanuỹ hnë idël imeh, kwëcëɗena fëna waresen hnë wadëmpëhn. ");
INSERT INTO cou_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ahnë afërën ifërën nësëɗ kaɓi umë fëɓëka ntaw̃ary dëw̃u hna; ahnë aw̃eh uw̃eh nësëɗ kaɓi umë fëɓëka ntaw̃ary dëw̃u hna. Kaɓi w̃ës ale-wo-le ile fëɓëk ntaw̃ary dëw̃u ỹa nësëɗ. ");
INSERT INTO cou_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Soŋe ye w̃acëɗunëho: “Ahwëhn, Ahwëhn”, do diɗiluhna ile lehnëɗëmu ỹa? ");
INSERT INTO cou_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ale-wo-le yijëk ỹal mën a do nëpa wanës mën ŋa nti ile hnësëɗëfu ỹa, ");
INSERT INTO cou_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","had ale vëryëk cery njaw̃ah nke: nkabëɗ hafo tëw̃ën ɗus tac pëgwëlehn ɓëry iŋa. Ge tëkik uw̃ac w̃ënka sën ŋa përëkanëɗilahna, kaɓi ɓëry ƴaw̃ah mbëryik. ");
INSERT INTO cou_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɓare ale-wo-le hnëpaɗ wanës mën ŋa do diɗina ile hnësëɗëfu ỹa had ale vëryëk cery nte wok njaw̃ëna nke. Ga macëk w̃ënka sën ŋa hafo cery tac njoɗ taŋ: përëkalehn fop.» ");
INSERT INTO cou_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ga puhnak Yesu ile ñaɗëho nës ỹa fop tase ɓulunda hna, më njik nkol nte w̃acik Kaperënaỹum. ");
INSERT INTO cou_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nkeho hnam kapiten wasoɗaɗe wavë Rom ale hwëhnakawo aryokuŋ ale ñaɗëho ɗus. Aryokuŋ arac tesëko hafo ñand cëm. ");
INSERT INTO cou_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kapiten ỹa nkwëryëko wëɓa Yesu ŋa, më paƴëkëhni vicër wasëwif njini tëƴëniha njij njërëna ares alëw̃u ỹi. ");
INSERT INTO cou_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Vicër va, ga tëkëni ɗarël Yesu, më muntaɗëniha ndemahni ntehnatëndëniha: «Aỹi asan tëfëka aryemahna! ");
INSERT INTO cou_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ŋahnëkëhni ɓulunda fu ỹa do umë vëryehnëk cery caliŋa fu ŋi.» ");
INSERT INTO cou_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu më tëfëlëni gë vëhni. Ga nkëhnëk tëkëni tere hna, Kapiten ỹa më paƴikëhni wëlawow̃u ntehnëniha Yesu: «Ahwëhn, ant'avërehnaj, tëfëlohna arënk tere mën hna. ");
INSERT INTO cou_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Soŋe umë woɓu maw̃ëhnëla fëna hacaryi ỹi ami dënk. Wëla ki fo nësëru aryokuŋ mën aỹi njërëɗ. ");
INSERT INTO cou_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ami dënk, vële lëbëko ucankaf va w̃aw̃ëhnëɗëfu do kwëhnaɓuhëhni wasoɗaɗe wale w̃aw̃ëhnëɗëho fëna. Njëtëɓu rac kaɓi ge ntehnëɓuha aryampo: “Ƴiryey!” njiɗ; ge ntehnëɓuha aỹëntaw̃: “Ƴij!” njijëɗ; do ge ntehnëɓuha aryokuŋ mën a: “Diry aki!” ntiɗ. Awa wëjë, aki fo nësëɗu!» ");
INSERT INTO cou_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu, ga nkwëryëk watac, më pëmpëhnahnëka gë kapiten ỹa. Më cahëtak gë kore le rëfëɗëhawo ỹa, ntehnëhni: «Paryi pëƴaɗëmu: koɓëri nula iỹi sifa kwëtahn wëla hnë aryampo wasëwif hna.» ");
INSERT INTO cou_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Vële paƴiko kapiten va, ga mbokani gë tere, tëkatënihawo aryokuŋ a njërëk. ");
INSERT INTO cou_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu më mbok njik nkol nte w̃acik Nayin do vërëfal vëlëw̃u va gë vahnë vëyaɓah vëhaw̃ary tëfëlëɗëniho. ");
INSERT INTO cou_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wati nte tëkëɗëho nkol ŋa njiryeryëɗeho asëm iɓañ: facan fatac fo kwëhnako hnëmu. Asëval, ale cëmaryëk asan, hnagëkawo. Vahnë vëyaɓah vëvë nkol va tëfëlëniho. ");
INSERT INTO cou_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesu, ga nuka asëval arac, më kaỹëhnahnëka ɗus g'umë, më ntehnëka: «Ɓok aho!» ");
INSERT INTO cou_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu më tëhak ñak pad nte njohahnik asëm a; vële yoka va kahnëlehnëni. Më ntehnëka asëm a: «Jar, ntehnëɗëmi, matëry!» ");
INSERT INTO cou_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Asëm a matëlehn ntaña, pëgw nësënd. Tac Yesu më mbësaka hnëmu. ");
INSERT INTO cou_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vahnë va fop ntakëkëhniwo; umë cëmbëɗëniha W̃ënu ŋa ntehnatëndëni: «Kila sankaf rëkik ỹal fu li! W̃ënu ŋa njijëk ndemahni ɓulunda lëw̃u ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hnë nkal Yuɗe hna fop gë wayal waỹëntaw̃ wavë caharaɓ w̃a nësëɗeho ile ntiko Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","VërëfalSan va më tëfëtanëniha fop ile ryëcëtako ỹa ");
INSERT INTO cou_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","do San më macëkëhni vëhi hnë vëhni. Paƴëkëhni g'Ahwëhn tëƴëniha: «Arëhnayik W̃ën ale yijëɗ ỹa bi yeru ma ahaw̃ary hnapëɗëfun?» ");
INSERT INTO cou_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ga tëkëni vëhni Yesu hna, më ntehnëniha: «San Ayary a faƴikëfu arëƴi: “Arëhnayik ale yijëɗ ỹa bi yeru ma ahaw̃ary hnapëɗëfun?”» ");
INSERT INTO cou_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wati rac dënk, Yesu njërënëɗëhëhniwo vëres vëyaɓah wates wadëw̃ hni do ntandëhni waƴine, mëpëtëndëhni vumëp vëyaɓah. ");
INSERT INTO cou_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tac më ntëkwakëhni vëfaƴ San va: «Ƴiryin afëƴawuna San ile hnurun do wëryërun ỹa: vumëp va nuɗëni, vëreyah va njasëɗëni, vëhwëhn mbiỹ va njërënini, vëryëŋënkah va nkwëryëɗëni, vësëm va mbëhnëni, Wanës Wakasëk ŋa pëƴaɗeni vëhaỹëhnah va. ");
INSERT INTO cou_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nëfaka ale woɗ tavëna ikwëtahn dëmën ŋa!» ");
INSERT INTO cou_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ga mbokani vëfaƴ va, Yesu më nësëndëhëhni kore ỹa soŋe San ntehnënd: «Ye yirunëho ayëkiwu wula hna? Ale wok kwëhnana nafa had idël mbë tëfary sën nte ñënkëlend sël bi? ");
INSERT INTO cou_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Awa, ye yirunëho ayëkiwu? Ale suɗak viỹi viwamah bi? Vële suɗaɗ viwamah va do njaɓëk hnapul, cery naw̃ asankaf hna nkeni. ");
INSERT INTO cou_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Awa, kila bi yirunëho ayëkiwu? Ha, ntehnëɗëmu ntëbik dënk kila. ");
INSERT INTO cou_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kaɓi soŋe San nësëɗ Vikerëh va ante ntehnëko W̃ënu ŋa: « “Cañëtëryiɗëfuha afaƴ mën a haryënkw hu pëhwëtëhni nkaw̃ ŋa.”» ");
INSERT INTO cou_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu më mbok ntehnëk: «Pëƴaɗëmu, koɓëri nagina ale lëbëka San. Ɓare ha gaki ale ỹak mbak nafa Naw̃ W̃ën hna lëbëka.» ");
INSERT INTO cou_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓulunda ỹa fop gë vërëf ỹatëtanke va nëpaɗënihawo San do maw̃ëniho njaryëhni kaɓi njavëtëniho W̃ënu ŋa catëk. ");
INSERT INTO cou_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ɓare wafarise w̃a gë vëharaŋ sariya va ŋwëỹëniho ile ñaɗëho W̃ën ntini ỹa: ŋwëỹëniho vëwëcëtëɗina vankeya vantëw̃ hni va do ŋwëỹëniho fëna ƴaryëɗilëhnihna San. ");
INSERT INTO cou_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu më nkwënëk: «Mo hoɗëfu w̃ëntëndëlehnëw̃ëhni vëỹi vahnë? ");
INSERT INTO cou_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vutah vunte lañak hn'ile nëhëɗëni mëntëlëni, vundampo ndekahnatëndënihëhni vuñëntaw̃ va: «“Njëw̃ëhnirun hnëw̃ sampace, gaw̃ëluhna sampace! Njëw̃ëhnirun hnëw̃ wakwëy, gaw̃ëluhna wakwëy!” ");
INSERT INTO cou_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Nësëɗëfu koyëna kaɓi San njijëko, tokëɗilohna roka fërën, ceɗilohna uñen, ntehnëɗunëho: “Ƴine fëlaka!” ");
INSERT INTO cou_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tac Ajë Ahn'a njijëk, tokëɗ, ceɗ do ntehnërun: “Ƴëkëryina aỹi asan; use gë rok roka fo nahaɗ, lawo vërëf ỹatëtanke ye do gë vëw̃en!” ");
INSERT INTO cou_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ɓare vële rëfëk uyët va njavëtëɗëni W̃ënu ŋa catëk.» ");
INSERT INTO cou_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farise ryampo w̃acëkawo Yesu nji tokëni roka tere lëw̃u hna. Yesu njik ỹalu hna do ntañako roka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ankol tac asëval yeho ale yavëtiko liko wameh waƴaɓah. Ante njëtako Yesu tere farise hna tokëntëɗeho roka umë njojëk sëleku ɗatikola hambah ntaw̃i. ");
INSERT INTO cou_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Njijëk ñëw̃ kamëhni wapary Yesu; kond cëkënatënda wapary Yesu ŋa gë wankwën wadëw̃u ŋa; tac pëhwëcëka g'imul dëw̃u ŋa, mbucëɗëha wapary ŋa do tura ɗatikola ỹa. ");
INSERT INTO cou_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ale w̃acëkawo Yesu roka ỹa, ga nuk watac, nahako: «Ge paryi kila yekënd aỹi asan njëtakënd, bi mo ye aỹi asëval ale ỹakëɗëha do ile nke ỹa: asëval ale yavëtiko liko wameh waƴaɓah ye.» ");
INSERT INTO cou_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Awa Yesu ntehnëlehna farise ỹa: «Simo, iñë ỹaɗëmi lehni.» Simo më ntëkwaka: «Aharaŋ, nësëry.» ");
INSERT INTO cou_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Awa, Yesu më ntehnëka: «Vësan vëhi yeho vële wonanëkawo koryi ale hnavehnand. Aryampo wawuli mbëɗ nkonanëkaw̃o. Aỹënta w̃a wakeme mbëɗ. ");
INSERT INTO cou_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɓare vëhnuỹalohna ile mbësaɗëniha. Më tavëhnëkëhni vëhni vëhi tak nav iŋa. Aỹëhne ỹahnëɗëha ɗus vëỹi vahnë vëhi vële ravëhnik vi?» ");
INSERT INTO cou_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo më ntëkwak: «Ntiyahnëko, ale ravëhnik koryi yaɓah, aỹi ye.» Yesu më ntehnëka: «Toña hwëhnaru.» ");
INSERT INTO cou_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tac më cahëtak g'asëval do ntehna Simo: «Nuruha aỹi asëval? Tënkëɓu tere hu hna ƴëɗalihohna w̃ënka wuyëtahnu wapary ŋi; ɓare umë nkuyëtëko gë wankwën wadëw̃u ŋa do pëhwëco g'imul dëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kacalihohna avuco; ɓare koɓëri ga tënkahnekëɓu umë tëryëna ɓuc wapary mën. ");
INSERT INTO cou_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñoñ turëlihohna nkaf li; ɓare umë turëko ɗatikola hambahë ntaw̃i wapary li. ");
INSERT INTO cou_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Soŋe umë pëƴaɗëmi: wameh waƴaɓah wante ntiko ŋa ntavëhnik. Ɓare ale ravëhnik toƴe fo, toƴe fo tufahnëɗ iña ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Awa, Yesu më ntehnëka asëval a: «Wameh hu ŋa tavëhniru.» ");
INSERT INTO cou_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vële tokëlahnëɗëniho Yesu va më nahaɗëni: «Mo ga ye aỹi asan ndëkënak dënk tavëhn wameh?» ");
INSERT INTO cou_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tac, Yesu më ntehnëka asëval a: «Kwëtahn hu ŋa pehëtëki, araɓi ayi ƴam!» ");
INSERT INTO cou_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ga mbiỹëk toƴe Yesu njiɗëho wahnaw̃ hna gë vankol hna. Pëƴahnëɗëho gante-wo-gante Wanës Wakasëk ŋa W̃ënu ŋa hnaw̃ëk. Gë pëhw gë vëhi va nkeniho. ");
INSERT INTO cou_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nkentiniho fënali vësëval vële lanëhnikëhniwo waƴine do njërënini wates wadëw̃ hni: Mari nte w̃aciko Mari avë nkol Magëdala (ale lanëhnikëhniwo waƴine mbëɗ gë waki); ");
INSERT INTO cou_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aryampo, Sanë maciko (Asanu, Susa maciko; umë yeho asankaf vëryokuŋ vëvë tere Eroɗ va); aỹëntaw̃ a, Susan maciko, do gë vësëval viyaɓah vëhaw̃ary vële yëɗahnëɗëho hnapul lëw̃ hni ndemahnëniha Yesu gë vërëfal vëlëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kore yaɓah yijëɗëho vëhni Yesu hna, matindëni vankol hna fop. Më nantanëhnëkëhni uw̃i uhnës uryindaryindan: ");
INSERT INTO cou_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ayam yeho. Ayam arac njiko ipahn uhnëɗa kaỹ dëw̃u hna. Wati le pahnëɗëho ỹa waŋëc wëɗampo fagant nkaw̃ hna njoko. Nkëñiko do wusëry w̃a kohnëniho fop. ");
INSERT INTO cou_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wëɗampo, nkal kwëhn wëraka njoko. Ante pëhnëko ŋa kankëlehnëko kaɓi wëraka yeho gëɗ, cëkëlohna ɗus. ");
INSERT INTO cou_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wëɗampo, fagant wadëmpëhn njoko do gë wadëmpëhn ŋa pëhnëlahnëniho. Umë ryaw̃ëkawo. ");
INSERT INTO cou_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wëɗampo, nkal përën hna njoko. Waŋëc ŋa pëhnëlehn ule-wo-le, ntëw̃ëko ɗus.» Tac Yesu më nkwënëk gë fanka: «Nëparyin ɗus, ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vërëfal va më tëƴëniha Yesu bi ye nësëɗ? ");
INSERT INTO cou_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Më ntëkwakëhni: «Maw̃ëryanirun ayëtu visow̃ik Inaw̃ W̃ën va, ɓare vëỹëntaw̃ vi wahnës waɗindaryindan w̃i fo nkwëryëɗëni. «“Koɗ njëkëni hara vëhnuɗina, koɗ nkwëryëni, ɓare hara vëyëtëna ile hnësik.” ");
INSERT INTO cou_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Wëlin ile nësëɗ uw̃i uhnës uryindaryindan ỹa: Uhnëɗa w̃a, umë ye wanës W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vëryampo, had fagant nkaw̃ nkeni hn'ile njoɗ waŋëc: nkwëryëɗëni, ɓare Sintani njijëɗ teɓëhni wanës ŋa walaw̃ary walëw̃ hni hna soŋe antë kwëtahnëni do pehëtini. ");
INSERT INTO cou_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Vëryampo, had nkal kwëhn wëraka nkeni: nkwëryëɗëni wanës ŋa do g'uhnatah maw̃aɗëni. Ɓare vëhwëtaɗina hafo mbiỹ kaɓi vëravëɗina wanës ŋa kwëhna vënkahn walaw̃ary walëw̃ hni hna. Ge waɗëñah ŋa tëkik tavëɗëni. ");
INSERT INTO cou_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Uhnëɗa ule yoɗ wadëmpëhn hna, umë ye vële wëryëɗ wanës do ravëhëɗ g'ankaw̃ tëfahnëni wëɓal wadëw̃ hni, uvetak do hnëŋah ntaw̃ary iỹi ɗuniỹa. Umë dëw̃ëɗina. ");
INSERT INTO cou_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Uhnëɗa ule yoɗ nkal përën ŋa umë ye vële hnëpaɗ wanës do hwëtaɗ ntaw̃ary pacah, nte hamënaɗ kwëlëkwël hafo ntëw̃ ɗus.» ");
INSERT INTO cou_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu nkwënëko: «Ahnë pëɗëɗina lampu tac koɓ ma kuyët hn'ipad. Ge pëɗik kaŋëɗe ƴaŋ pëtënëhnahnëhni vële rënkiɗ va. ");
INSERT INTO cou_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ile-wo-le sow̃ik ỹa nuɗe, ile-wo-le sow̃ik ỹa njëtëɗe do kwëtëɗe humpen hna. ");
INSERT INTO cou_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pëcëtaryin ɗus gante nëpaɗun wanës ki! Kaɓi ale hwëhnak ỹa nkwënënde, ɓare ale wok kwëhnana ỹa teɓëɗe wëla toƴe ile liyahnëka tëk nuỹa ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hnëmu Yesu gë vëheryu njijëniho njëkëniha, ɓare vëholëlohna tëhaniha kaɓi vahnë va njaɓëniho. ");
INSERT INTO cou_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Më pëƴayik Yesu: «Hnëmuh gë vëhery hu, për hna nkeni. Ñaɗëni nunihi.» ");
INSERT INTO cou_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ɓare Yesu më ntëkwakëhni: «Vële wëryëɗ wanës W̃ënu va do liɗ ile tëyëk ỹa vëhni ye hnëm mën ỹa gë vëhery mën va.» ");
INSERT INTO cou_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Fac ryampo, Yesu gë vërëfal vëlëw̃u va kaƴëniho hnë kulu sankaf do ntehnëhni: «Ɗanëtanëfu gë cape ñëntaw̃ lant haɗi.» Njilehnëni. ");
INSERT INTO cou_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ga njiɗëni, Yesu ndakëko wakwëɗ. Pëgwëlehn cëlënd sël hwëhn fanka hafo ñënkëɗ lant ỹa. W̃ënka ŋa tëmpëlehn kulu hna hafo ñand nkëƴa. ");
INSERT INTO cou_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Vërëfal va tëhalehnëniha Yesu nëgëtëniha ntehnëni: «Aharaŋ, Aharaŋ, cëm iŋa yeyinëk!» Yesu nëgalehn, ŋañënahna w̃ënka ŋa gë sël ỹa do gë wavonkëlo w̃ënka ŋa. Sël ỹa tëryalehn, njamëlehn fop. ");
INSERT INTO cou_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu më ntehnëkëhni: «Ne nke ikwëtahn hun ŋa?» Vëhni ntakëkëhniwo, pëmpëhnahnëkëhniwo, ntehnëlëndëni: «Mo ye awa aỹi asan? Wëla sël ỹa gë w̃ënka ŋa ntehnëɗëhëhni ile ñaɗ ntini do maw̃ëhnëɗëniha!» ");
INSERT INTO cou_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu gë vërëfal vëlëw̃u va tëkëlehnëni nkal ɓulunda Gerasen hna, nte ye cape ñëntaw̃ lant paɓëlëni gë Galile. ");
INSERT INTO cou_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu, ga cëlëk kulu hna, Asan avë naw̃ tac yijëɗëho pankëlëni. Asan arac gë waƴine nkeniho. Mbiỹëlahnëniho diyaɗilohna viỹi do dëɗëlohna hnë tere, ɓare hnë wayag ntëɗëko. ");
INSERT INTO cou_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ga nuka Yesu, umë ndekak ndëkwëhnëlehn karyënkw lëw̃u ntehn: «Ye ye yëbëlan fu Yesu, Ajë W̃ën Hunte Sëpëk Fop? Muntami, nt'aliwo w̃eh!» ");
INSERT INTO cou_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Asan a nësëk watac kaɓi Yesu ntehnëkawo ƴine ỹa cahna. Ƴine rac pëlaɗëhawo kwëlëkwël asan arac; ñabëɗeho wëɓák ŋi gë wapary ŋi gë vankënca antë nji, ɓare mbëkëtëɗëho viỹëba va do ƴine ỹa yoɗëhawo gante njirëk. ");
INSERT INTO cou_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu më tëƴëka: «Hak maciru?» Ƴine ỹa më ntëkwaka: «W̃ac mën w̃a “Njaɓëɓun” ye.» Nësëko koyëna kaɓi waƴine waƴaɓah fëlakawo asan arac. ");
INSERT INTO cou_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Waƴine watac muntaɗënihawo Yesu antë cañëtëhni ga nkëɗ hatëh hatëw̃ah. ");
INSERT INTO cou_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Awa, kore sankaf vampëhëmpëh ryavëɗëho hnam vambamb kuŋ hna. Waƴine ŋa më muntaniha Yesu maw̃ëryanëhni tënkënihëhni vampëhëmpëh vatac. Më maw̃ëryanëkëhni. ");
INSERT INTO cou_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Waƴine ŋa cahnëlehnëniha asan a njini tënkënihëhni vampëhëmpëh va cëpëtalehnëni kuŋ hna njini ntëbani lant hna cëmëlehnëni fop. ");
INSERT INTO cou_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vëhery vampëhëmpëh va, ga nuni ile ryëcëtako ỹa, ntakëlehnëhni më nkaryëni pëƴahnini watac gë vankol do gë wëhaỹ. ");
INSERT INTO cou_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Vahnë va njijëniho njëkëni ile ryëcëtak ỹa. Ga tëkini ɗarël Yesu më tëkatëniha asan ale cahnëni waƴine ŋa: haryënkw Yesu ntañako, ntiyako viỹë do hakili ỹa mbokakawo fërën fo. Ntakëlehnëhni taŋ. ");
INSERT INTO cou_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vële hnuko ile ryëcëtako ỹa fop më pëƴanihëhni vëỹëntaw̃ va gante njërënik asan ka. ");
INSERT INTO cou_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tac vëvë vankol va fop më ntehnëniha Yesu cahn nkol ntëw̃ hni hna, kaɓi ntakëkëhni ɗus. Yesu më kaƴëk kulu hna ñand nji. ");
INSERT INTO cou_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ale cahnëniho waƴine ŋa më muntaka tava tëfëlënti gë vëhni ɓare Yesu më paƴëka ntehna: ");
INSERT INTO cou_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ɓokary gë ỹal hu do afëƴahn fop ile ntinëhnëki W̃ënu ŋa.» Awa asan a njilehn do pëƴahn naw̃ hna fop ile ntinëhnëkawo Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ga mbokak Yesu gë cape ñëntaw̃ mbë lant ŋa, vahnë va fop napëɗënihawo, do ga tëkik kacanihawo. ");
INSERT INTO cou_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wati rac tëkiko asan ale w̃aciko Yayërus. Asankaf caliŋa ỹa yeho. Ndëkwëhnëko karyënkw Yesu do këlahna nji ỹalu. ");
INSERT INTO cou_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Fatah facëval fëndampo fo kwëhnako, wabëhn pëhw gë waki kwëhnako. Tesëko ɗus hafo ñand cëm. Wati nte njiɗëho Yesu ŋa kore ỹa peñëlëɗëniho caharaɓ lëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nkeho hnam asëval ale njiɗëho sat koɓëri hnë wabëhn pëhw gë waki. Canëko fop ile kwëhnako ỹa vëyehn hna, ɓare wëla aryampo kolëlohna njërëna. ");
INSERT INTO cou_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Umë tëhaka Yesu kamëhni, ñak sëmët cuɗ ntëw̃u ŋa. Tëryalehna taŋ ƴi sat ŋa. ");
INSERT INTO cou_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu më tëƴëk: «Mo ỹakëko?» Njahëtalehnëni fop, Piyer më ntehnëka: «Aharaŋ, fop ñakëɗënihi. Kore ỹa kwërënihi do peñëlëɗëni vacape va fop.» ");
INSERT INTO cou_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɓare Yesu më ntehnëk: «Ahnë ỹakëko wakwëhn ampër njërahn, kaɓi njëtaɓu fanka sahnëko.» ");
INSERT INTO cou_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Asëval a, ga njëtëk koɗina cow̃a, më njijëk mbalatënd ndëkwëhn karyënkw Yesu. Më pëƴahnëk tase vahnë fop soŋe ile ñakahnëka ỹa do gante njërëk taŋ ka. ");
INSERT INTO cou_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu më ntehnëka: «Aryag mën, kwëtahn hu ŋa njërënëki. Araɓi ayi gë ƴam.» ");
INSERT INTO cou_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wati nte nësëɗëho Yesu watac ŋa, ahnë rëkiko mati gë tere asankaf caliŋa ỹa ntehna: «Yayërus, aryag hu cëmëk. Ɓokawo avërehna Aharaŋ a.» ");
INSERT INTO cou_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu, ga nkwëryëk, më ntehnëka Yayërus: «Antë ntaki, kwëtahnëry tuŋ, do njërëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ga tëkëni tere hna Yesu, Piyer, San, gë Sak, do rëmu gë hnëmu fandag fa fo maw̃ëko tënkëni. ");
INSERT INTO cou_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vahnë va fop koɗëniho njahnandëni soŋe fandag fa. Awa, Yesu më ntehnëk: «Mboka howu, cëmëna, wakwëɗ fo ndakëk.» ");
INSERT INTO cou_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓare njafaŋëɗënihawo, kaɓi njëtëniho cëmëk. ");
INSERT INTO cou_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu më pëlaka fandag fa vák ỹi do maca: «Fandag, matëry!» ");
INSERT INTO cou_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Njënëlehn taŋ matëlehn. Yesu më ntehnëkëhni rëmu gë hnëmu: «Ƴëɗaryina ile tokëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pëmpëhnahnëkëhniwo ɗus vëhni. Ɓare Yesu më ntehnëkëhni antë pëƴahnëni watac. ");
INSERT INTO cou_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu mbarëkëhniwo vërëfal pëhw gë vëhi va njëɗakëhni fanka g'ucankaf ida waƴine fop do g'iƴërën vëres. ");
INSERT INTO cou_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tac paƴëkëhni pëƴahnëni W̃ënu ŋa hnaw̃ëk do njërënëndënihëhni vëres. ");
INSERT INTO cou_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Më ntehnëkëhni: «Ge njiɗun ant'ayowu ñoñ: ryoko, kufa, rokëtok, koryi, do ant'ayowu viỹi vile hnëmpëtahnëɗun. ");
INSERT INTO cou_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ge tëkërun hnë tere, ñëw̃ëryin hnam fo hafo hale ndëcalëɗun nkol kaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ge dëvayiluhna hnë nkol tac, ɗëcalëryin avankatëndu ivëɗ wapary hun ŋa. Umë njëtëɗëni vëlinahna fërën do W̃ënu ŋa nëŋëlahna gë vëhni.» ");
INSERT INTO cou_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Vërëfal va njilehnëni, tëfëni nkol g'ankol, pëƴahnëni Wanës Wakasëk ŋa do njërënëndënihëhni vëres gante-wo-gante. ");
INSERT INTO cou_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wati rac, Eroɗ, asankaf avë Galile ỹa, ga nkwëryëk wanës wante ryëcëtaɗ ŋa fop, ƴëtëlohna ile nahaɗ, kaɓi vëryampo ntehnëɗëniho: «San Ayary a vëhnik.» ");
INSERT INTO cou_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vëhaw̃ary ntehnëɗëniho: «Eli vokajëk.» Vëhaw̃ary kat ntehnëɗëniho: «Aryampo wakila waɓë koɓëri ŋa vëhnik.» ");
INSERT INTO cou_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eroɗ nahaɗëho watac, më ntehnëk: «Ɓare San ami dënk lëpëtehnëka nkaf ŋa. Mo ye asan ale liɗ iỹi sifa viỹë vifërën vile hnësëɗe vi?» do njëkëlendëho nuhna Yesu, njëtëlëni. ");
INSERT INTO cou_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Vëfaƴik va mbokajëniho do pëƴaniha Yesu ile ntijëni ỹa fop. Më njokëhni, gë cape nkol nte w̃acik Betësayida. Vëhni fo yeho hnam. ");
INSERT INTO cou_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ɓare vahnë va njëtaniho hn'ile nkeni hna më tëfalëlehnënihëhni. Yesu kacakëhniwo nësëhnëndëhni soŋe ucankaf Naw̃ W̃ënu ŋa do njërënëɗëhëhniwo vële ỹaɗëho va. ");
INSERT INTO cou_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","G'anëka ga vërëfal pëhw gë vëhi va më tëhaniha Yesu ntehnëniha: «Koyaryihni kore ỹi njini gë vankol vamb caharaɓ hëɗi koɗëni njëkëlehnani ile tokëɗëni gë hn'ile ndakëɗëni kaɓi hnë fëk nkeyinëk.» ");
INSERT INTO cou_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ɓare Yesu më ntëkwakëhni: «Ƴëɗaryinëhni w̃uhnë dënk ile tokëɗëni ỹa!» Më ntëkwani: «Vamburu mbëɗ fo hwëhnaɓun g'uwis wuhi. Afo ge njiɓun law̃ëhnifuni ỹi kore fop?» ");
INSERT INTO cou_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mpëd wawuli mbëɗ nkeniho hnam vësan va. Yesu më ntehnëkëhni vërëfal va: «Dehnëryinëhni ntañani kore kore, wafëhw imbëɗ (50), wafëhw imbëɗ (50).» ");
INSERT INTO cou_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Vërëfal va maw̃ëlehnëni ntañëndënihëhni vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu më nufëk vamburu mbëɗ va g'uwis wuhi w̃a. Kaŋëk g'ambin, camehna W̃ënu ŋa soŋe iỹi rokëtok. Tac, nkubëlehnëk do njëɗahni vërëfal va, cahëlehnënihëhni ɓulunda ỹa. ");
INSERT INTO cou_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ale-wo-le tokëko hafo pihn; tac vëkankel pëhw gë vaki mbarëpëniho vamburu vante woko va g'uwis w̃a. ");
INSERT INTO cou_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Fac ryampo Yesu cahët njëfaɗëho. Vërëfal vëlëw̃u va hnam nkentiniho. Më tëƴëkëhni: «Vahnë va, mo ntehnëni yeɓu?» ");
INSERT INTO cou_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Më ntëkwani: «Vëryampo, vëhni lehnëɗ San Ayary a yeru, vëhaw̃ary Eli yeru, do vëhaw̃ary kat, kila vë koɓëri ile vëhnik vësëm hna yeru.» ");
INSERT INTO cou_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu më mbok tëƴëkëhni: «W̃uhnë lë mo lehnërun yeɓu?» Piyer më ntëkwaka: «Këris ỹa yeru, Arëhnayik W̃ën ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu më ŋañënahnëkëhni ntehnëhni: «Ant'afëƴawuna ñoñ ahnë.» ");
INSERT INTO cou_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Më nkwënëk: «Ajë Ahn'a afo korot ɗus; vicër va gë vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va ŋwëỹëɗëniha. Ndaw̃ehnëniha, do fac rarëna hna mbëhnëɗ vësëm hna.» ");
INSERT INTO cou_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tac Yesu më ntehnëkëhni fop: «Ge ahnë ñaɗ tëfëlehnëndo antë nko nahand soŋe lëw̃u dënk, afo ndiɓ kërëwa lëw̃u ỹa fac-wo-fac tëfatëndo. ");
INSERT INTO cou_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ale ỹaɗ iỹi ɗuniỹa ỹi cëmëɗ, ɓare ale wok kwëtahnëna nëf iỹi ɗuniỹa, soŋe lëmën ỹa, nkoryaryëɗ ntaw̃ary dëw̃u ŋa hafo araƴen hna. ");
INSERT INTO cou_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ye nëfaɗëha ahnë ge nuỹak ɗuniỹa ỹi fop tac cëvehn ntaw̃ary dëw̃u ŋa? ");
INSERT INTO cou_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ge ahnë cëfëhnëka g'ami, gë wanës mën ŋa, awa Ajë Ahn'a fëna cëfëhnëɗëha g'ahnë arac, ge mbokajëk g'idanc dëw̃u ŋa fop gë hn'idanc Rëm hna do g'idanc wamëleka wadëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Toña fëƴaɗëmu: Vëryampo hnë vële ye hnani vi vësëmëɗina hara vëhnuhnahna Naw̃ W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wafac mbëɗ ge wahi ryëcëko ga nësëk watac, Yesu kaƴëɗëho hn'ikuŋ soŋe njëfa. Umë njokëhni vëhni Piyer, gë San do gë Sak. ");
INSERT INTO cou_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wati ante njëfaɗëho Yesu ŋa, yëka lëw̃u ỹa mbaciko, do viỹi vilëw̃u va njerëko had ambin wilëbilëk. ");
INSERT INTO cou_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Vësan vëhi nësëlëɗëniho g'umë. Wakila waɓë koɓëri ŋa yeho, Moyis gë Eli. ");
INSERT INTO cou_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Idanc W̃ënu ŋa penëkëhniwo. Gë Yesu nësëlëɗëniho gante puhnaɗ ɗoku lëw̃u ỹa cëmahnënd Yerusalem hna. ");
INSERT INTO cou_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyer gë vërëfëlëntaw̃u wakwëɗ yokëhniwo ɗus. Ga tisëkëhni, nuniho idanc Yesu ŋa do gë vësan vëhi vële nkeniho va. ");
INSERT INTO cou_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wati ante ñaɗëniho pitëlëni Yesu gë vësan vërac va, Piyer më ntehnëka: «Aharaŋ, njivëk nkeyin hnani. Ntiɗëfun wasank watar: ryampo wëjë, Moyis ryampo, Eli ryampo.» Ɓare Piyer aki fo nësarëɗëho. Ƴëtëlohna ile nësëɗ. ");
INSERT INTO cou_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wati ante nësëɗëho Piyer koyëna ŋa, aŋar njilehni cankëhni. Ante tënkëɗëniho ŋar ŋa vërëfal Yesu va ntakëkëhniwo ɗus, ");
INSERT INTO cou_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","do nkwëryëlehnëni kopa ŋar hna ntehn: «Aỹi Ajë mën ye ale ỹahnëɓu ɗus; umë rëhnaɓu. Umë rëfëka ahnëpawu!» ");
INSERT INTO cou_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wanës ŋa, ga tëryak, Yesu fo woko nunde. Vërëfal va ndemëhnaniho do, hnë wafac warac, ahnë vëfëƴalawohna ile nuniho ỹa. ");
INSERT INTO cou_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ga pacëk cëlëniho kuŋ hna do kore sankaf hacakawo Yesu. ");
INSERT INTO cou_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kore hna, asan ryekaɗëho: «Aharaŋ, këlami, ƴërënëryehna ajë mën aỹi; umë fo hwëhnaɓu! ");
INSERT INTO cou_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kwëlëkwël, ƴine fëlaɗëha do ndekayehnëɗëha taŋ, ñënkëɗëha gë fanka, iguhnuhn rëkëɗ cahnënda w̃ës li. Mbërendëha ɗus do tavënkaɗilahna. ");
INSERT INTO cou_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tëƴëɓuhëhni vërëfal hu va ntaniha iỹi ƴine, ɓare vëw̃ëkëlahna.» ");
INSERT INTO cou_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu më ntehnëk: «W̃uhnë vahnë vëhwëhn kwëtahn këm do vërumpak yerun! Hafo guve tëfëko ñëw̃ëlahnin do ryuñënanëhnu?» Tac më ntehnëka asan arac: «Ƴinenëhninow̃a ajë hu ani!» ");
INSERT INTO cou_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wati ante tëhajëɗëho fatah ŋa, ƴine ỹa këfëkawo ñënkëlehn gë fanka. Ɓare Yesu ŋañënahnëkawo ƴine ỹa, njërëlehn fatah fa do mbësahna rëmu. ");
INSERT INTO cou_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vahnë va fop pëmpëhnahnëkëhniwo. Ntehnëɗëniho: «Paryi nke W̃ënu ŋa naỹëk!» Ante nkoniho nësëndëni ile ntiɗëho Yesu ỹa fop, më ntehnëkëhni vërëfal vëlëw̃u va: ");
INSERT INTO cou_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Nëparyin ɗus aryënkwëtahnëndu ile ỹaɗëmu lehnu ỹi. Ajë Ahn'a njëɗaɗeniha vahnë va do ntiɗëniha gante ñaɗëni ka.» ");
INSERT INTO cou_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ɓare vërëfal va vëyëtëlohna ile nësëɗëho ỹa, pacënëhnëliwohna, vëhnulohna ile nësëɗëho. Vëryëkëlohna fëna tëƴëniha: «Ye ỹaɗu ahnës?» ");
INSERT INTO cou_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Vërëfal va nkwajëlëɗëniho njëtahnëni bi mo lëbëkëhni vëỹëntaw̃ va? ");
INSERT INTO cou_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu njëtëko nahan dëw̃ hni ŋa. Umë macëka fatah kahnëndëka ɗarël lëw̃u ");
INSERT INTO cou_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","do më ntehnëkëhni: «Ale hacaka fatah gë faŋi ki soŋe lëmën, kacako ami dënk; do ale hacako kacaka fëna ale faƴiko ỹa. Koyëna ale ñak mbak nafa hnë w̃uhnë ỹa, umë ye ale lëbëku ɗus ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Awa, San më teɓak wanës ŋa ntehn: «Aharaŋ, nuɓunëhawo asan ale laɗëhëhniwo waƴine g'uw̃ac hu, njëkëhnahnëɓunëho ravëtehnëfuna, kaɓi gentina gë fuhnë.» ");
INSERT INTO cou_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu më ntëkwaka: «Ant'aravëtehnuna kaɓi ale wok ñew̃ëluhna ỹa ndemaɗëhu.» ");
INSERT INTO cou_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tac kahnëndako Yesu nji Yerusalem kaɓi wati ile rëfëkawo ntihëti ɗuniỹa li ỹa, mboka g'ambin ŋa, rëhajëko. ");
INSERT INTO cou_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Më paƴëkëhni vahnë karyënkw lëw̃u. Vërac më njini tëkëni hn'ankol ndampo ambë Samari soŋe pëhwëtani tëk dëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɓare vëvë ankol tac va vëw̃aw̃ëlaw̃ohna kaɓi Yerusalem njiɗëho. ");
INSERT INTO cou_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","San, gë Sak, vërëfal Yesu va, ga nuni koyëna nke, më ntehnëniha: «Ahwëhn, ge ñaɗu, ntehnëɗëfunëha hwëɗëh ha cëli g'ambin pëɗëhni hafo mbëvëni vëỹi vahnë!» ");
INSERT INTO cou_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ɓare Yesu më cahëtanëkëhni ŋañënahnëkëhni ntehnëhni: «Ƴëtëluhna bi iŋëhne ƴir yëɗaɗëhu iỹi sifa nahan! Ajë Ahn'a ƴijëna ryaw̃ vahnë, pehët dëw̃ hni njijëk.» ");
INSERT INTO cou_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Njilehnëni hn'ankol kaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ante njiɗëniho ŋa, asan aryampo lehnëkawo Yesu: «Tëfëlehnëɗëmi hn'ile-wo-le njiɗu hna.» ");
INSERT INTO cou_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu më ntehnëka: «Vuntadaw̃ va kwëhnani wahatëh wale njinëgahnëɗëni do wusëry w̃a kwëhnani wahof, ɓare Ajë Ahn'a kwëhnana hn'ile njinëgaɗ.» ");
INSERT INTO cou_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu më ntehnëka aỹëntaw̃: «Tëfe.» Ɓare asan a më ntëkwak: «Ahwëhn, ƴëɗërye yiwu ten hnapu hafo Apa cëm tac do gë yiju rëfëlehnëndi.» ");
INSERT INTO cou_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu më ntëkwaka: «Tavëryihni vësëm va mbañënihëhni vësëm vëlëw̃ hni va! Ɓare wëjë, ƴiry afëƴahn Naw̃ W̃ënu ŋa!» ");
INSERT INTO cou_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ahaw̃ary kat më ntehnëka Yesu: «Ahwëhn, tëfëɗëmi ɓare ƴëɗërye ten yiwu tere mën hna rëƴëw̃ëhni hafo maw̃ëni rëfëlehnëndi.» ");
INSERT INTO cou_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu më ntëkwaka: «Ale ryokuŋëɗ had asan ale yaryëɗ yary ntaŋat iñë kamëhni, arac mëkëɗina ndokuŋ ɗoku fërën soŋe Naw̃ W̃ënu ŋa, kwëhnana ỹëw̃a hnam.» ");
INSERT INTO cou_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ga ndëcëk wafac, Ahwëhn a më mbok tahnëkëhni vërëfal wafëhw imbëɗ gë wahi gë vëhi (72). Paƴëkëhni vëhi vëhi karyënkw lëw̃u, vankol hna fop gë hn'ile tëfëka nji umë hna dënk. ");
INSERT INTO cou_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Më ntehnëkëhni: «Ɓarëp roka yaɓah yehëhna, ɓare vëryokuŋ va vëyaɓëna. Muntaryina ahwëhn kaỹ a nkwënihni vëhaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ƴiryin! Paƴëɗëmu had vupe vunte wok wëyëtëna ỹaƴah fagant waỹin. ");
INSERT INTO cou_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ant'ayowu koryi, kufa viỹi hun, wapary wante hnëmpëtahnëɗun. Ant'ahahnu nkaw̃ hna simpaỹi vahnë. ");
INSERT INTO cou_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Ge tënkërun hna tere dehnëryin ten: “Araɓi ƴam ỹa nke hnë ỹi tere.” ");
INSERT INTO cou_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ge ahwëhn ƴam nke hnë tere rac ɗëwan hun iŋa nuỹaɗ; ge gena më ƴam ỹa gë ỹal hun mbokajëɗ. ");
INSERT INTO cou_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ge ahnë kacaku, ñëw̃ëryin tere rac tokëryin, ceryin ile yëɗayirun ỹa, kaɓi aryokuŋ tëfëka cosi. Ant'aryapu watere. ");
INSERT INTO cou_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Nkol nte-wo-nte rëkahnëɗun ŋa kacatënihu vëvë nkol tac va, tokëryin ile-wo-le njëɗanihu ỹa. ");
INSERT INTO cou_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ƴërënëryinëhni vëres vële yehëhna hnam va do dehnëryinëhni vëhni fop: “Tame Naw̃ W̃ënu ŋa tëhajëku!” ");
INSERT INTO cou_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ɓare ge tëkërun hn'ankol ŋwëỹatëni vëvë hnam va vëhacaɗiluhna, njiryin gë waỹëw̃a walëw̃ hni alehnuni vahnë va fop: ");
INSERT INTO cou_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Caw̃ëhnëɗerun wëla ivëɗ vëỹal hun ile ỹëmakëfu wapary fu ŋi pitëlahnin. Ƴëtëryin ɗus: Naw̃ W̃ënu ŋa tëhajëk.” ");
INSERT INTO cou_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Paryi pëƴaɗëmu: Fac kiti hna vëvë Sodom vi vëyapënanëhnëɗena ɗus gë vëvë iŋi nkol ki. ");
INSERT INTO cou_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Meku w̃uhnë vëvë nkol mbë Korasin gë mbë Betësayida vi! Ỹal hun hna ntik W̃ënu ŋa viỹë vifëmpëhnahnah va dina Tir gë Sidon. Ge hnam ntikënd viỹë virac, vëvë hnam vi mbiỹëk ga nkwëcëtakëndëni vankeya vantëw̃ hni va. Cuɗakëndëni viỹi icëm do nëvakëndëni iɓëhn vimbahn hna tufahnahnëni gante njiw̃ëhnëni ka soŋe ile ntiɗëniho koɓëri ŋa. ");
INSERT INTO cou_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Soŋe umë ye fac kiti hna, vëvë Tir gë Sidon vëyapënanëhnëɗena ɗus gë w̃uhnë ki. Piniŋ hun iŋa yaw̃ëɗ ntëbi dëw̃ hni ŋa. ");
INSERT INTO cou_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","W̃uhnë vëvë Kaperënaỹum ntiyahnëku bi njihnëɗerun hafo ambin hn'ani? Geɗina koyëna. Ñoƴëɗerun hafo janáma hna.» ");
INSERT INTO cou_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu më mbok ntehnëkëhni vërëfal vëlëw̃u va: «Ale hnëpaku nëpako, ale w̃ëỹëku ŋwëỹëko, ale w̃ëỹëko ŋwëỹëka ale faƴiko ỹa fëna.» ");
INSERT INTO cou_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vërëfal wafëhw mbëɗ gë wahi gë vëhi va mbokajëniho g'uhnatah fëɓah. Umë ntehnëniha Yesu: «Ahwëhn, wëla waƴine ŋa maw̃ëhnëɗënihëfu ge ntehnëɗëfunëhëhni g'uw̃ac hu!» ");
INSERT INTO cou_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu më ntëkwakëhni: «Ha, ante mëkërunëhëhniwo waƴine ŋa nkeho had Sintani hnuɗëfuho yojëɗ g'ambin had kol vëkëtak. ");
INSERT INTO cou_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nëparyin: njëɗamu imëk ayëñënduni walën gë wafawëry do aw̃ëkuna Sintani; ñoñ gena ile hoɗ ntiw̃u w̃eh. ");
INSERT INTO cou_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɓare antë natu ile maw̃ëhnëɗënihu waƴine ŋi. Ile herik wamac hun ambin hna ŋi rëfëka natu ɗus.» ");
INSERT INTO cou_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wati rac dënk Iƴir Ipacah iŋa pëɓënëkawo Yesu uhnatah më ndekak: «Apa, Ahwëhn ambin g'inkal, camehnëmi gante njëtëndanëruhëhni vële ye had vutah ile sow̃ëhnëruhëhni vëhwëhn hakili g'uyët. Ha, Apa, ntiru koyëna kaɓi irac ỹaɗu.» ");
INSERT INTO cou_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tac Yesu më ntehnëkëhni vahnë va: «Rëm mën ỹa njëɗëko fop. Ahnë ƴëtëlahna Aj'a, ge gena Rëm ỹa. Ahnë ƴëtëlahna Rëm mën ỹa ge gena ami, Aju ỹa do gë vahnë vële rëhnaɓu rufëwuhni Rëm mën va.» ");
INSERT INTO cou_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tac Yesu më cahëtak gë vërëfal vëlëw̃u ka do më ntehnëkëhni vëhni fo: «Mbetarun w̃uhnë vële hnuɗ ile hnuɗun ỹi! ");
INSERT INTO cou_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kaɓi paryi pëƴaɗëmu, wakila waƴaɓah gë vëhnaw̃ vëyaɓah wavë koɓëri w̃a ñaɗëniho nuni do nkwëryëni ile hnuɗun do wëryëɗun ỹi, ɓare vëhnulohna do vëwëryëlohna fëna.» ");
INSERT INTO cou_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Asan ale yëtëk ɗus sariya matëlehn ntehna Yesu, tëndëhna urënd: «Aharaŋ, ye rëfëko liwu rënkahnu uwám usër hna?» ");
INSERT INTO cou_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu më ntëkwaka: «Ye herik sariya fu hna? Hak nkwëryëɗu?» ");
INSERT INTO cou_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Asan a më ntëkwaka: «Ŋahnëryehna Ahwëhn a W̃ën hu ŋa gë sakahn hu ỹa fop, g'intaw̃ary hu fop, gë fanka hu fa fop, do gë hakili hu ỹa fop do ŋahnëryehna aỹënta hu had wëjë dënk.» ");
INSERT INTO cou_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu më ntehnëka: «Toña lëkwaru. Diry watac tënkëɗu araƴen hna.» ");
INSERT INTO cou_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɓare aharaŋ sariya ỹa ñaɗëho tufahn catëk. Më tëƴëka Yesu: «Mo lë ye aỹënta mën a?» ");
INSERT INTO cou_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu më ntëkwaka gë uhnës uryindaryindan, ntehna: «Nkeho asan ale w̃atiko naw̃ ɓë Yerusalem cëlëndand g'ankol mbë Seriko. Më kasëniha vële teɓëniha fop ile njoko ỹa gë vëỹi vële ntiyako va, ndafëniha had cëm, tavëlehnëniha, njini. ");
INSERT INTO cou_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hara, nkehëhna asëna wasaɗëha wasëwif ale sëlëndagiɗëho nkaw̃ tac, më cahnahnëka. Ga nuka asan ale sërehnik a, më ndarëka njilehn. ");
INSERT INTO cou_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ahnë ahaw̃ary ale ryokuŋëɗëho hnë Acery W̃ën Cankaf hna fëna tëfëgëlehni nkaw̃ tac. Ga nugëka, ndarëgëlehna nji, umë fëna. ");
INSERT INTO cou_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Avë nkal Samari, vële ñëw̃ëni wasëwif, tëfëgëlehni umë fëna nkaw̃ tac hafo tëki ale sërehnik hna. Ɓare nunda tuŋ kaỹëhnahnëlehna ɗus g'umë. ");
INSERT INTO cou_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Më tëhaka, njehnëka gë vëlo hn'ile cërehnikëhna tëmpëlehna. Tac kaƴëndëka fali falëw̃u hna njohna cery vëhneh hna, hn'ile njiko njehna ɗus. ");
INSERT INTO cou_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Fac le rëfiko ỹa më canëk koryi, njëɗahna ahwëhn cery a ntehna: “Paɓëryehna aỹi asan. Ile-wo-le wënëɗu ayehnahna ỹa mbokajëɗëfu vësaỹi ami dënk.”» ");
INSERT INTO cou_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Awa, Yesu më tëƴëka asan a: «Hnë vëỹi vërar mo liyahnëki ye aỹënta ale ryafika ỹi?» ");
INSERT INTO cou_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Asan a më ntëkwak: «Ale haỹëhnahnëka ỹi ye.» Yesu më ntehnëka: «Ƴirye wëjë fëna ali koyëna!» ");
INSERT INTO cou_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu nkok njind gë vërëfal vëlëw̃u va, tëkatëni hnë nkol. Asëval, ale w̃acik Marët, hacakawo tere lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mari maciko aheryu ỹa. Mari ntañako ɗarël Yesu nëpanda wante nësëɗ ŋa. ");
INSERT INTO cou_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ɓare Marët njaɓëkawo ɗoku ỹa. Më njik ɗarël vëhni Yesu hna ntehna: «Ahwëhn, gehahnahnëlihna bi ahery mën a taveryëko ɗoku ỹa fop; dehnëryehna ndemaw̃o!» ");
INSERT INTO cou_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu më ntëkwak: «Marët, Marët, ndëñëru do njaɓëki nahan iŋa, ");
INSERT INTO cou_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ɓare ryampo fo ye ile rëfëka ỹa. Mari rac tëhnak do tavëtehnëɗena muk.» ");
INSERT INTO cou_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Fac ryampo caliŋëɗëho Yesu sëñ. Ga puhnak arëfal aryampo alëw̃u më ntehnëka: «Ahwëhn, ñaŋëndëryifu gante njëfaɗe, had gante ñaŋëndëkëhni San Ayary a vërëfal vëlëw̃u ki.» ");
INSERT INTO cou_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu më ntehnëkëhni: «Ge njëfaɗun, dehnëryin: “Apa, araɓi vahnë va fop njavëtëni W̃ën husëvah yeru; araɓi naw̃ hu ŋa njij. ");
INSERT INTO cou_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ƴëɗëryifu fac-wo-fac ile rokëɗëfun. ");
INSERT INTO cou_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tavëhnëryifu ile w̃enëɓun ỹa kaɓi tavëhnëɗëfunëhëhni fop vële lëntahnëɗëhëfu va. Ant'aw̃aw̃ aravëfu yëkëhnahnifu gë wameh.”» ");
INSERT INTO cou_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu më mbok ntehnëkëhni kat: «Mpëd aryampo hnë w̃uhnë hwëhnaka lawo do nji g'andëcak ga ntehna: “Lawo, ñëgëhnërye ile rokëɗe. ");
INSERT INTO cou_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Lawo mën yiɗ uyas sabik tameki tere mën hna do ñoñ kwëhnala ile yëɗaɗëfuha tok.” ");
INSERT INTO cou_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Ntiyahnëki bi lawo hu ỹa ntëkwajëɗëhi ɓambery cery hna: “Tavërye ƴam! Tëkëɓu fiɗu rënka ỹa. Ami gë vutah mën va ndakëɓun. Koɗa w̃atu yëɗaỹi ile rokëɗe.”» ");
INSERT INTO cou_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu më mbok ntehnëkëhni: «Pëƴaɗëmu, wëla matëna njëɗahna soŋe ile nkeni lawo ỹi, matëɗ njëɗahna fop ile valëka ỹa kaɓi ñaɗina cëfëhna. ");
INSERT INTO cou_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Awa, umë lehnahnëɗëmu ami: Tëƴëryindën njëɗaɗerun, ƴëkëlehnëryindën nuɗun, ɓankëryindën rënka ỹa piɗëtëhnëɗerun. ");
INSERT INTO cou_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Paryi pëƴaɗëmu, ale-wo-le rëƴëka njëɗaɗe, ale yëkëlehnëka nuɗ do piɗëtëhnëɗe rënka ỹa ale vankëɗ a. ");
INSERT INTO cou_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Naharyin ge aryampo hnë w̃uhnë hwëhnaka fatah muntata igis, lën bi njëɗaɗëha? ");
INSERT INTO cou_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma ge inihn muntaka, fawëry bi njëɗaɗëha? ");
INSERT INTO cou_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mama w̃uhnë mehahnërun ɓare viỹë vifërën yëɗaɗunëhëhni vutah hun va do kas Rëm ile ye g'ambin ỹi njëɗaɗëhëhni Iƴir Ipacah iŋa vële rëƴëɗëha va!» Koyëna karaŋëkëhniwo Yesu vërëfal vëlëw̃u va iƴëfa ŋa. ");
INSERT INTO cou_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Fac ryampo Yesu ƴine ntaɗëho hn'asan. Ƴine rac liɗëhawo asan a koɗina nës. Ga ntaka ƴine ỹa ahnë arac, asan a pëgwëlehn nësënd do kore ỹa pëmpëhnahnëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ɓare vëryampo kore hna ntehnëɗëniho: «Asankaf waƴine, ale w̃acik Belësebul, yëɗaɗëha imëk ntahnëndëhni waŋi waƴine!» ");
INSERT INTO cou_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vëryampo ñaɗëniho njëkëhnahnëniha: më tëƴëniha tufahn dahëse vë g'ambin fëmpëhnahnah ile rufahnëɗ paryi nke W̃ënu ŋa faƴika. ");
INSERT INTO cou_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ɓare Yesu njëtëko nahan dëw̃ hni ŋa. Më ntehnëkëhni: «Ge vële vankëk inaw̃ mëtëɗëni vëhni fo, naw̃ tac campëɗ, do ge vële vankëk tere fëna mëtëɗëni, tere rac campëɗ. ");
INSERT INTO cou_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Awa, ge Sintani mëtëɗëni g'ucankaf ntëw̃u ŋa hak koɗ nko kahn ucankaf tac? Tëkwëɗ! Hara ntehnërun fëna g'imëk Belësebul ntaɗëfuhëhni waƴine ŋi. ");
INSERT INTO cou_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ge Belësebul yëɗako imëk iŋa, awa, vahnë hun vële lantëɗehëhni waƴine ŋi, mo yëɗakëhni imëk ntahahnëɗënihëni? Tufahnëɗëni vëhni dënk kwëhnaluhna toña! ");
INSERT INTO cou_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ge paryi g'imëk W̃ënu ŋa ntaɗëfuhëhni waƴine ŋi, paryi nke fëna Inaw̃ W̃ënu ŋa tëkik ỹal hun hna. ");
INSERT INTO cou_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Ge asan, ale njaɓëk imëk gë viw̃ëta, njëkaɗ tere lëw̃u ỹa, hnapul lëw̃u ỹa ahnë nufëɗina. ");
INSERT INTO cou_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ɓare ge ale lëbëka fanka rëkik, do mëka, awa teɓëɗëha viw̃ëta vile tamahnëko va do cahahnëɗ ile nufëhnëka ỹa fop. ");
INSERT INTO cou_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Ale wok gentina gë ami ỹa aỹew̃ mën ye; do ale wok ɗemaɗilohna varëpëw̃ëhni vahnë ỹa campehnëɗëhëhni.» ");
INSERT INTO cou_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu mboko nës: «Ge ƴine ntayik hnë ahnë, hn'ile nkeho cery ntëw̃u hna, njiɗ njasëlehnënd wëwac wahankah hna njëkëlehnand hn'ile ñëw̃ëɗ. Ge nuỹana, ntehnaɗ: “Awa mbokaɗëfu cery mën hn'ile matiɓu hna”, ");
INSERT INTO cou_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","do ge tëkatëka asan a had cery nte facënik, fëhwëtik hafo njiv. ");
INSERT INTO cou_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Njiɗ njojëhni waƴine ntaw̃u mbëɗ gë wahi wante lëbëka wayap, njijëni ñëw̃ëni hnam. Tac horot ahnë arac ỹa ntëbëɗe gë koɓëri ka.» ");
INSERT INTO cou_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ante nësëɗëho Yesu watac ŋa, asëval aryampo më ndekajëk ɓambery kore hna ntehna: «Asëval ale ryonkëki do yiw̃ëndëki ỹa ndëwanik!» ");
INSERT INTO cou_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu më ntëkwaka: «Tëfakëha ahnës: “Ndëwanini vële hnëpaɗ wanës W̃ënu ŋa do ntindëni watac va.”» ");
INSERT INTO cou_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Vahnë vëyaɓah yijëɗëho caharaɓ Yesu, më ntehnëɗëhëhni: «Vahnë vëvë gaki vi meni. Dahëse vë g'ambin fëmpëhnahnah tëƴëɗëni ɓare vëhnuỹaɗina. Sifa dahëse ile yehawo kila ile w̃aciko Yonas ỹi fo nuỹaɗëni. ");
INSERT INTO cou_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonas yeho dahëse vëvë nkol Niniv va do Ajë Ahn'a yegëɗ dahëse soŋe vahnë vëvë gaki vi. ");
INSERT INTO cou_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Do fëna, fac ile kitiŋëɗëhëhni W̃ënu ŋa vahnë va, asëval ale hnaw̃ëko hn'inkal Saba nkentëɗe gë vahnë vëvë gaki vi, do tufahnëɗ vahnë vëvë gaki vi ntëntëni. Umë hn'ile tëkwik nkal hna matik njij nëpa usery Salomo w̃a do nkehëhna hnani ale lëbëka Salomo ɓare nëpaɗilunahna! ");
INSERT INTO cou_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Fac kitiŋ hna vëvë Niniv va nkentëɗeni gë vëvë gaki vi, do tufahnëɗëhni vahnë vëvë gaki vi ntëntëni. Vëvë Niniv va vëhni nkwëcëtani vankeya va ante nkwëryëniho wanës Yonas ŋa do nkehëhna hnani ale lëbëka Yonas ɓare w̃uhnë gwëcëtaluhna vankeya va.» ");
INSERT INTO cou_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu mboko nës: «Ahnë pëɗëɗina lampu soŋe cow̃ ma koɓ g'ancëhn. Ƴaŋ kaŋëɗe pëtënëhnahnëhni vële rënkiɗ va. ");
INSERT INTO cou_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Vinkër hu va ye lampu mbahn hu ŋa. Ge nuɗu wapacëk mbahn hu ŋa fop kwëhnaɗ humpen. Ɓare ge nuɗila wapacëk mbahn hu ŋa hn'umëhwëry nkeɗ. ");
INSERT INTO cou_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Awa nahary ɗus ayëtahn humpen hunte hwëhnaru ŋi bi gena umëhwëry. ");
INSERT INTO cou_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ge mbahn hu ŋa fop kwëhnak humpen, kwëhnana cape nte w̃ëhwëryëka, had gë lampu peniru fop nkeɗëhi.» ");
INSERT INTO cou_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ga puhnak Yesu wanës ŋa, farise ryampo më macëka nji tokëni roka tere lëw̃u hna. Yesu tënkëko tere hna ntañalehn hn'ile tokëɗe hna. ");
INSERT INTO cou_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farise ỹa pëmpëhnahnëkawo g'umë ante kamahnëko pacënana wëɓák ŋa gante nke namu lëw̃ hni ka do ntañat roka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Awa, më ntehnëka Ahwëhn a Yesu: «W̃uhnë wafarise w̃i, pacënëɗun kamëhni ankëlëw̃a ŋa gë mpan ŋa ɓare ɓambery walaw̃ary hun hna ule gë li wameh fo fëɓëku. ");
INSERT INTO cou_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nënkwërun! Gena bi W̃ënu ŋa lik kamëhni gë ɓambery per? ");
INSERT INTO cou_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ƴëɗaryinëhni vëhaỹëhnah va uyivah ule ye ɓambery vanëhëta hun va fop, tac pacëɗun fop. ");
INSERT INTO cou_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Meku w̃uhnë wafarise w̃i! Njëɗaɗunëha W̃ënu ŋa ỹëŋa hwëhn pëhw-wo ile varëpërun ỹa, hafo gë sifa yaryef yale-wo-yale rokëɗe do gë vihnëga sifa-wo, ɓare kwëtahnëluhna nëf icat g'iña W̃ënu ŋa: umë ye ile rëfakëha aliwu ỹa, hara ɗënkwëluhna fëna ƴëɗahn ỹëŋa hwëhn pëhw-wo ile varëpërun ỹa. ");
INSERT INTO cou_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Meku w̃uhnë wafarise w̃i! Wëlaña wale hnuhanderun ỹaɗun vacaliŋa hna do ñaɗun ayaỹiwu g'untënah waỹëw̃a ɓulunda hna. ");
INSERT INTO cou_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Meku w̃uhnë! Had wayag wale yasande do wok kamahnëɗena nkerun!» ");
INSERT INTO cou_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aharaŋ sariya aryampo më ntehnëka Yesu: «Aharaŋ, gante nësëɗu ki njew̃ëɗuhëfu fuhnë fëna!» ");
INSERT INTO cou_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu më ntëkwaka: «Meku w̃uhnë fëna, vëharaŋ sariya vi! Njahëndehnëɗunëhëhni vahnë va lënah, do wëla rufa ỹi ƴelaɗiluhna aryemahnuni ɗiɓ iŋi. ");
INSERT INTO cou_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Meku w̃uhnë! Mbëryëɗun nkwam wayag wakila wante ndaw̃ëniho vicër hun ŋa! ");
INSERT INTO cou_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Koyëna tufahnëɗun njëtërun do caŋahnëku ile ntini ỹa. Ha, vicër hun va ndaw̃ënihëhni wakila ŋa do w̃uhnë avëryu wayag walëw̃ hni w̃a! ");
INSERT INTO cou_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Soŋe umë ntehnahnëk W̃ënu ŋa g'uyët lëw̃u w̃a: “Paƴëɗëfuhëhni wakila ŋa gë vëfëƴahn wanës mën va. Ndaw̃ëɗënihëhni vëryaw̃, vëỹëntaw̃ va mbërehnëɗënihëhni.” ");
INSERT INTO cou_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Koɓëri wapëgwa ɗuniỹa hna ndaw̃ënihëhni wakila waƴaɓah do vahnë vëvë gaki vi kitiŋëɗ W̃ënu ŋa had vëhni dënk ryaw̃ëkëhni vahnë vërac. ");
INSERT INTO cou_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel yeho ale ryënkwiko ndaw̃i ỹa hafo arëkwa ỹa, Sakari. Umë selele Cery W̃ën Cankaf hna ndaw̃iko yëbëlan hn'ile cënaɗe saɗëha hna gë Cery W̃ën Cankaf ŋa hn'ile ñak cëvak hna. Ha, pëƴaɗëmu W̃ënu ŋa kitiŋëɗëhëhni vahnë vëvë gaki vi soŋe waŋi fop! ");
INSERT INTO cou_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Meku ɗus w̃uhnë, vëharaŋ sariya vi! Nkëɗërun nkaw̃ nte njëtande W̃ënu ŋa. Tondaɗiluhna w̃uhnë dënk nkaw̃ tac, do memaỹehnëɗunëhëhni vële ỹaɗ tondani va, vëhoɗina ndëcëni!» ");
INSERT INTO cou_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ga cahnëk Yesu tere hna, vëharaŋ sariya va gë wafarise w̃a ntavëkëhniwo ɗus g'umë, më tëƴëɗëniha waƴaɓah. ");
INSERT INTO cou_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Warënd tëndëhnëɗënihawo, ñaɗëniho nës iñë ile koɗëni ntehnëni ntëntëk gena toña nuỹahnëni ile nësëɗëni menëk pëlahnëniha. ");
INSERT INTO cou_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wati rac vahnë wawuli wayaɓah hwërako caharaɓ Yesu. Aki fo nkëñëlëɗëniho kaɓi njaɓëniho ɗus. Yesu më pëgwëk ntehnëɗëhëhni ten vërëfal vëlëw̃u va: «Keharyin levirwafarise ỹa: namu lëw̃ hni ỹa, nës ile nkoni vëliɗina ye. ");
INSERT INTO cou_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pëƴaɗëmu, ile-wo-le sow̃ik ỹa nuɗe do ile sëvak ỹa njëtëɗe. ");
INSERT INTO cou_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ile-wo-le hnësëɗun g'umëɗ ỹa, nkwëryëɗe ge pacëk do ile-wo-le ỹakëỹakëhnërunëha ahnë hn'acery piɗik hna ndekaɗe ɓulunda hna. ");
INSERT INTO cou_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ntehnëɗëmu w̃uhnë, wëlawo mën: antë ntakuni vële ryaw̃ëɗ mbahn do hara vëhoɗina ntini ile lëbëk umë. ");
INSERT INTO cou_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pëƴaɗëmuna ale rëfëka ntakuna ỹa: dakëryiw̃una W̃ënu ŋa, umë ale ye ge ndaw̃ëk mbahn koɗ ntabu gë janáma. Ha, toña hnësëhnëɗëmu, umë rëfëka ntakuna! ");
INSERT INTO cou_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Gena bi nkwafëɗeni vuñer mbëɗ gë koryi toƴe fo? Ɓare W̃ënu ŋa ɗënkwëlahna wëla fëndampo hnë vutac. ");
INSERT INTO cou_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wëla mul ɓë vankaf hun ŋi ndëkwëk. Ñoñ antë ntaku: w̃uhnë lëbëkëhni nafa ỹa kore vuñer vujaɓah! ");
INSERT INTO cou_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Pëƴaɗëmu, ale-wo-le hnësëk ɓulunda hna ami hwëhnëka, ami Ajë Ahn'a fëna nësëɗëfu karyënkw wamëleka W̃ën hna, ami hwëhnëka aỹi; ");
INSERT INTO cou_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ɓare ge ahnë nësëk ɓulunda hna kwëhnëlëw̃ahna, ami, Ajë Ahn'a fëna nësëɗëfu karyënkw wamëleka hna, kwëhnëlëw̃ahna. ");
INSERT INTO cou_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ale-wo-le hnësëɗ wanës wameh soŋe ami, Ajë Ahn'a, koɗe tavëhni; ɓare ge Iƴir Ipacah iŋa njew̃ëk mahwëhnu koɗena tavëhni. ");
INSERT INTO cou_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Ge njiryeryirun soŋe ahitiŋiwu vacaliŋa wasëwif hna, ma vësankaf hna, antë nkehahnahnu g'ile lëkwaɗun, ");
INSERT INTO cou_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kaɓi Iƴir Ipacah iŋa karaŋëɗëhu hnë wati le rëfëka hna ile hnësëɗun ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hnë wati rac dënk, nkeho ɓulunda hna ale lehnëkawo Yesu: «Aharaŋ, dehnëryehna acër mën a caho ile lëw̃ëɓun ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu më ntëkwaka: «Lawo, ami bi hwëtik ahitiŋ hun ma asahëlehnëhun?» ");
INSERT INTO cou_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tac më ntehnëkëhni fop: «Gasery, keharyin ayëkëlehnëndu kantëm njaɓu viỹë kaɓi uwám ahnë gena hn'ile kwëhnak hna, lakënde mbeta ɗus.» ");
INSERT INTO cou_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu tëfëtanëlehnëhni iỹi uhnës uryindaryindan: «Asan avetak yeho. Kwëhnako wëhaỹ wale lëw̃ëko ɗus vantimp. ");
INSERT INTO cou_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nahaɗëho do tëƴaɗëho: “Bi ye liɗëfu? Kwëhnala igwac ryanahnu vantimp mën vi fop.” ");
INSERT INTO cou_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Më ntehnak: “Awa, wëli ile liɗëfu ỹa; ntihëtëɗëfu vandank mën vi tac vokaryu liwu vante hnaỹëk ɗus. Hnam kwëtëɗëfu vantimp mën va gë vile hwëhnaɓu va fop. ");
INSERT INTO cou_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tac ntehnëɗëfuha ntaw̃ary mën iŋa: ‘Ntaw̃ary mën, kwëtaru ani hnapul yaɓah soŋe wabëhn waƴaɓah; ƴinëgary, tokëry, cery do nëhëry!’” ");
INSERT INTO cou_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Ɓare W̃ënu ŋa më ntehnëka: “Ahnënkwah! Uŋi mëɗ dënk mbiɗe ntaw̃ary hu ŋi. Awa, mo lëw̃ëɗ? Gena bi, hnapul ile varëpëru ỹi, ahnë ahaw̃ary rokëɗ?”» ");
INSERT INTO cou_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu më nkwënëk: «Koyëna nkeɗëha ale varëpëɗ hnapul soŋe umë fo ỹa do ɓetana viỹë W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tac Yesu umë ntehnëkëhni vërëfal vëlëw̃u va: «Soŋe umë lehnahnëɗëmu: Ant'ahnahandu ile rokëɗun ma viỹi vile liyaɗun. ");
INSERT INTO cou_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gena bi uwám yaɓëk gë roka do mbahn iŋa yaɓëk fëna gë viỹi vi? ");
INSERT INTO cou_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ƴëkëryinëhni wusëry w̃i: wahnaɗëɗina, wavarëpëɗina fëna, wafehnaɗina, wahwëhnana vandank, ɓare W̃ënu ŋa ndavëɗëhëhni. Kas w̃uhnë vële lëbëkëhni nafa wusëry w̃i dinëndiluhna bi ntëbini vëhni ɗus? ");
INSERT INTO cou_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ge ahnë hnë w̃uhnë nahaɗ uryëñah lëw̃u w̃a koɗ bi koyëna nkwën iƴary wafac walëw̃u w̃a? ");
INSERT INTO cou_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ge koɗiluhna aliwu wëla viỹë viroƴ virac soŋe ye ryëñëɗun viỹëntaw̃ hna? ");
INSERT INTO cou_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Ƴëkëryin gante pëhnëɗ wapëtel waɓë fëk ki: ɗokuŋëɗina do ɓahnëɗina wafand. Ɓare wëla ahnaw̃ a Salomo, g'uvetak lëw̃u w̃a fop, nuỹalohna viỹi viwamah had ufëtel ryampo gë watac ki. ");
INSERT INTO cou_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","W̃ënu ŋa koyëna cuɗëɗëha idël nte ye dol ani do acahn ntoŋi gë hwëɗëh. Ge umë toña ye, kas w̃uhnë cuɗëɗëhu ntëbi dël iŋi! Ikwëtahn hun iŋa ƴaɓëna! ");
INSERT INTO cou_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ant'avërandu soŋe ile rokëɗun g'ile seɗun fo do ant'aryëñu. ");
INSERT INTO cou_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ỹin fop vële wok vëyëtëlahna W̃ën va vëraɗ kwëlëkwël soŋe rac. Ɓare w̃uhnë kwëhnarunëha rëm ile yëtëk mbalëku. ");
INSERT INTO cou_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ƴëkëlehnëryin Naw̃ dëw̃u ŋa tac njëɗaɗëhu fëna ile valëku ỹa fop.» ");
INSERT INTO cou_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Antë ntaku, w̃uhnë fakore fatoƴ wape! Rëmun hnatah lëw̃u ye njëɗaw̃u Naw̃ iŋa. ");
INSERT INTO cou_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gwafëryin ile hwëhnarun ỹa ayëɗawuni vëhaỹëhnah va koryi ỹa. Age ntirun koyëna mbarëpaɗun hnapul ile wok përëkaɗina, had ɗarël W̃ën hna kwëtarun mbin hna. Hnam puɗina. Vële va vëhoɗina tëkënëni, do vamaỹ va wahoɗina përëkanëni. ");
INSERT INTO cou_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hn'ile nke hnapul hun hna, nkeɗ iña hun iŋa kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Këbënaryin do afëɗu walampu hun w̃a kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tëfëka ayewu had ale hnapëɗëha ale ndokuŋënd ge mëncik iñël do ge tëkik mbankat rënka ỹa piɗëtëhna taŋ. ");
INSERT INTO cou_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbetani vëryokuŋ vële tëkatëɗ ale ndokuŋëhnëɗëni ỹa hara vëryakëna wakwëɗ! Toña fëƴaɗëmu: ahwëhn tere arac pëhwëtaɗ soŋe nëhëtëhnëhni, ntehnëɗëhëhni ntañani hn'ile tokëɗe hna do nëhëtëhnëhni umë dënk roka ỹa tokëni. ");
INSERT INTO cou_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Age fagant hn'umëɗ hna ma kob gë fac mëncik do njij tëkatëhni vëryakëna wakwëɗ vërac, mbetani! ");
INSERT INTO cou_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ƴëtëryin ɗus waŋi: ge ahwëhn tere ỹa njëtakënd wati le njijëɗ ale ỹa, tavakëndilahna tënk tere lëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pëhwëtaryin w̃uhnë fëna, kaɓi Ajë Ahn'a tëkiɗ hnë wati ile worun nahaluhna.» ");
INSERT INTO cou_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyer më tëƴëka Yesu: «Ahwëhn, fuhnë fo bi hnantanëhnëru iỹi uhnës uryindaryindan ma vahnë vi fop ye?» ");
INSERT INTO cou_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ahwëhn a më ntëkwaka: «Mo ga ye aryokuŋ, ale hahnëndak do ritëka? Ahwëhn a kwëtehnahnëɗëha vëryokuŋ vëỹëntaw̃ va fop, ƴëɗahnëhni sah lëw̃ hni roka wati ile rëfëka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mbetak aỹi aryokuŋ ge ahwëhn tere ỹa mëncik do tëkata ga ntiɗ ɗoku lëw̃u ỹa! ");
INSERT INTO cou_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Toña ỹa fëƴaɗëmu: ahwëhn tere ỹa kwëtehnahnëɗëha hnapul lëw̃u ỹa fop. ");
INSERT INTO cou_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ɓare ge aryokuŋ arac a ntehnaɗ ahwëhn tere ỹa mëncënkajëɗina, do pëgwëlehn ndafëndëhni vëryokuŋ va vësan gë vësëval per, tokënd do cend hafo ndëw̃ënd njakaryëɗëha! ");
INSERT INTO cou_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Awa, ahwëhn tere ỹa mënciɗ hnë fac ile nkok ƴëkaɗilahna aryokuŋ arac, wati le nkok ƴëtëna, ndafëɗëha ɗaf ntavah do gante ntiɗeni vële wok vëwëtahnëlahna W̃ën ka ntiɗëha. ");
INSERT INTO cou_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Aryokuŋ ale yëtëk ile ñaɗ ahwëhn tere ỹa do pëhwëtana nti rac ndafëɗe ɗus. ");
INSERT INTO cou_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Do ale wok ƴëtëna ile ñaɗ ahwëhn tere ỹa do nti ile rëfëka ndafahni, toƴe fo ndafëɗe. Ge ahnë yaɓah nuỹak, yaɓah tëƴëɗe; ale hwëtehnahnik yaɓah tëƴëɗe ntëbi waỹëntaw̃ w̃a. ");
INSERT INTO cou_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Njijëɓu ɗuniỹa li soŋe yondu hwëɗëh hnani. Ñankahnëko pëla taŋ! ");
INSERT INTO cou_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","W̃ënu ŋa ñaɗ njaryehno do ndëñëɓu ɗus ani gë nkehahnënd ỹa! ");
INSERT INTO cou_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ntiyahnëku bi njijëɓu ɗuniỹa li soŋe yoju ƴam? Hali, pëƴaɗëmu pitëndëlehn yijëɓu. ");
INSERT INTO cou_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pëgw dol, ge vahnë mbëɗ mbankëni tere, vërar va takëlëɗëhëhni gë vëhi va, do vëhi va takëlëɗëhëhni gë vërar va. ");
INSERT INTO cou_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rëm ỹa vësaŋëɗina g'aju do aj'a vësaŋëɗina gë rëmu; hnëm ỹa vësaŋëɗina g'aryagu do aryag a vësaŋëɗina gë hnëmu; hnëm jar ŋa vësaŋëɗina g'asëval aju do asëval a gë hnëm asanu.» ");
INSERT INTO cou_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu nkoko nësëhnëndëni kore ỹa, ge nuni ambin ŋa ga mbahnik, ntehnëɗëni taŋ tëvëɗ, gë paryi tëvëɗ. ");
INSERT INTO cou_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ge nuni sël le w̃atiɗ gë cape rëhw gë pëhna lav ka ga cëlëɗ ntehnëɗëni njakëɗ, gë paryi njakëɗ. ");
INSERT INTO cou_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","«W̃uhnë vële wok ñaɗiluhna toña! Mëkëɗun awëryu ile liyaɗ nkal li gë g'ambin; awa soŋe ye ye gwëryëɗiluhna wati ile ye gaki ỹi? ");
INSERT INTO cou_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Soŋe ye pitëndëlehnëɗiluhna w̃uhnë dënk ile satëk? ");
INSERT INTO cou_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Age takëlëku g'ahnë njiryeryatëndi hn'ahitiŋ hna diry fere awëryëlu nkaw̃ hna. Age gena umë njoɗëhi hn'ahitiŋ hna do ahiti ŋa njëɗahnëɗëhi asëɗi. ");
INSERT INTO cou_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tac pëƴaɗëmu ge koyëna nkehu cahnëɗiluhna hnam ge gena cosahnërun nav iŋa hafo pu.» ");
INSERT INTO cou_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wati rac, vahnë yijëko tëfëtanëhnëniha Yesu gante ndaw̃ehnëkëhniw̃o Pilat, asankaf nkal, vëvë nkal Galile ka wati nte cënaɗëniho saɗëha W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu më ntëkwakëhni: «Naharun bi vëỹi ndaw̃ini aki kaɓi vëhni liɗëho wameh wacankaf ntëbini vëỹëntaw̃ vi fop? ");
INSERT INTO cou_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pëƴaɗëmu, gena koyëna! Do ge gwëcëtaluhna vankeya va fop, cëmëɗun gë vëhni ki. ");
INSERT INTO cou_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Vahnë pëhw g'imbëɗ gë vërar vële njohahnëko cery jihnah Silowe hna do cëmëlehnëni, ntiyahnëku bi vëhni liɗëho wameh ntëbini vëỹëntaw̃ vëvë Yerusalem vi fop? ");
INSERT INTO cou_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pëƴaɗëmu, gena koyëna do, ge gwëcëtaluhna vankeya va gë vëhni ki, cëmëɗun fop.» ");
INSERT INTO cou_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tac Yesu më hnantanëhnëkëhni iỹi uhnës uryindaryindan: «Anuỹ yeho hnë sarëɗiŋ. Asan ale hnaɗëko atëh tac ỹa njijëko kwëc, ɓare tëkatëlohna ga ntëw̃ëk. ");
INSERT INTO cou_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Awa më ntehnëka aryokuŋ a lëw̃u ỹa: “Nuru! Wabëhn watar ye ga pëlahnëɓu aŋi anuỹ do dëw̃ëɗina. Awa, ŋosëry! Nula nafa ile kwëhnak hn'ani.” ");
INSERT INTO cou_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Aryokuŋ a më ntëkwaka: “Tavëry hnëw̃ël fo; nkabëɗëfu caharaɓ dëp iŋi do hovu ile wufëɗëha. ");
INSERT INTO cou_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mpëd ntëw̃ëɗ bëhn. Ge dëw̃ëna, ŋosëɗëfu.”» ");
INSERT INTO cou_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Hnë fac ntaw̃ëla Yesu karaŋëɗëhëhniwo vahnë hnë caliŋa wasëwif hna. ");
INSERT INTO cou_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Asëval ares yentiko hnam, ƴine huƴëkawo. Hnë wabëhn pëhw g'imbëɗ gë watar koɗilohna catëna. ");
INSERT INTO cou_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu, ga nuka asëval arac, më macëka njij do ntehna: «Asëval, ntihëtik urey hu w̃a.» ");
INSERT INTO cou_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ante nësëɗëho ŋa tindëkawo wëɓák ŋa asëval a matëndalehn taŋ, pëgw cëmbënda W̃ënu ŋa! ");
INSERT INTO cou_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɓare asankaf caliŋa ỹa ntavëkawo ɗus gë Yesu kaɓi fac ntaw̃ëla njërënëkawo ahnë. Më ntehnëkëhni kore ỹa: «Wafac mbëɗ gë ryaw̃ ye wale rëfëka ndokuŋahni w̃a; ƴijën ayërëniwu wafac warac hara gena fac ntaw̃ëla!» ");
INSERT INTO cou_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɓare Ahwëhn a më ntëkwaka: «W̃uhnë vële wok diɗiluhna ile lehnëɗunëhëhni vëỹëntaw̃ ntini, ale-wo-le pokëtëɗilahna bi ryahni lëw̃u ma fali njohna pëɗehna w̃ënka wëla hnë fac ntaw̃ëla hna? ");
INSERT INTO cou_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gena bi koɓëri wabëhn pëhw g'imbëɗ gë warar, aỹi asëval, ale yentik hnënk Abëraham, pëlak Sintani? Tëfëlahna bi ntihëti ures lëw̃u w̃a hnë fac ntaw̃ëla?» ");
INSERT INTO cou_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ante nësëɗëho Yesu watac ŋa vëỹew̃ vëlëw̃u va cëfëhnëlehnëkëhniwo. Ɓare vëỹëntaw̃ vëvë kore va fop natëkëhniwo gë ɗoku wamah ile ntiɗëho ỹa. ");
INSERT INTO cou_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tac Yesu më ntehnëk: «Ye mëntëlëni Naw̃ W̃ënu ŋa? Ye hoɗëfu w̃ëntëndëlehnëw̃ëhni? ");
INSERT INTO cou_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uỹëc tëh mutarëd mëntëlëni, ule pahnëk asan hnë sarëɗiŋ lëw̃u: pëhnëɗ, naỹ, nke had ankëhn, wusëry w̃a koɗ kofëni hnam. ");
INSERT INTO cou_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","«Ye hoɗëfu voku w̃ëntëlehnëw̃ëhni Naw̃ W̃ënu ŋa? ");
INSERT INTO cou_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nke had levir ile nufëk asëval nëgw gë farin fayaɓah, tac cis fop.» ");
INSERT INTO cou_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu Yerusalem nkoko njind karaŋëhatëndëhni vahnë va vankol vacankaf hna gë vatoƴ hna per. ");
INSERT INTO cou_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ahnë më tëƴëka: «Ahwëhn, njaɓëɗëni bi vële fehëtëɗe va?» Yesu më ntehnëkëhni fop: ");
INSERT INTO cou_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Kamënaryin arënku rënka suyah hna; pëƴaɗëmu, vëyaɓah njëkëlehnëɗëni tënkëni hnë rënka rac ɓare vëhoɗina. ");
INSERT INTO cou_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Age ahwëhn tere ỹa cëɗëk rënka ỹa, awotu g'ipër, tëkëɗun avankëndu alehnatëndu: “Ahwëhn, piɗëtëndifu!” «Ɓare ntëkwaɗëhu: “Ƴëtëla bi vëhni mo yerun!” ");
INSERT INTO cou_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Awa ntehnëɗunëha: “Gena bi tokëlahninëk do celahninëk? Karaŋëruhëhni vahnë va wëwac vankol fu hna.” ");
INSERT INTO cou_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Mbokëɗ ntehnu fëna: “Ƴëtëla bi ne nkejërun. Tavëryino, w̃uhnë vële wok vësatëna vi, w̃enëɗ vi fop!” ");
INSERT INTO cou_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Hnam rëkëɗ kondëni do cemëlehnandëni wabeñ ŋa, ge nurunëhëhni vëhni Abëraham gë Isak, Sakob do gë wakila ŋa fop Naw̃ W̃ën hna aravatewu w̃uhnë g'ipër! ");
INSERT INTO cou_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Matiɗëni vahnë va vacape vanah tak. Ntañaɗëni laña lëw̃ hni hna Naw̃ W̃ën hna soŋe ambënt ŋa. ");
INSERT INTO cou_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Vële ye gaki vërëkwa vi yeɗ vëryënkwëryënkw va do vëryampo hnë vële ye vëryënkwëryënkw vi yeɗ vërëkwa.» ");
INSERT INTO cou_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wati rac dënk wafarise wëryampo tëhanihawo Yesu ntehnëniha: «Ƴiryeyi, ŋaw̃ëtary ani; Eroɗ ñaɗ ndaw̃i.» ");
INSERT INTO cou_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu më ntëkwakëhni: «Ƴiryin alehnëhnunow̃a aỹi, avora vahnë ye had ỹin: “Dol g'acahn waƴine laɗëfu do yërënëɗëw̃ëhni vahnë, fac rarëna hna puhnaɗëfu ɗoku mën ỹa.” ");
INSERT INTO cou_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ɓare dol, g'acahn do gë yini tëfëko ryëcalu kaɓi kila ỹa Yerusalem rëfëka nji soŋe ndaw̃i. ");
INSERT INTO cou_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«W̃uhnë vëvë Yerusalem vi, w̃uhnë vële ryaw̃ëɗëhëhni wakila do ryaw̃ëɗëhëhni gë wëraka vële paƴik W̃ën ỹal hun va! Gante ñaɗëfuho ɗus varëpu ɗarël mën had cale nte varëpëkëhni vutahu vampaw̃ vantëw̃u, ɓare maw̃ëluhna. ");
INSERT INTO cou_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Awa wëli W̃ënu ŋa tavëɗ cery hun ŋa: pëƴaɗëmu ɓokëɗiluhna ahnuwuno hafo wati nte ntehnëɗun: “Araɓi W̃ënu ŋa njëɗa ale yijëɗ g'uw̃ac Ahwëhn a!”» ");
INSERT INTO cou_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hnë fac ntaw̃ëla hna Yesu njiko hnë tere asankaf wafarise rok roka. Vële yeho hnam va njëkëɗënihawo Yesu gë hakili. ");
INSERT INTO cou_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Asan ale cënkëk mbahn iŋi fop hahnëko haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu më tëƴëkëhni vëharaŋ sariya va gë wafarise w̃a: «Sariya fu ỹa maw̃ëryak bi, ma mbañëk bi njërëni ahnë fac ntaw̃ëla hna?» ");
INSERT INTO cou_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɓare vëlëkwalohna. Yesu më ñakëka njërënëlehna aresa do ntehnëlehna mënc. ");
INSERT INTO cou_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tac më ntehnëkëhni: «Ge aryampo hnë w̃uhnë ntëbaryëka aju ma ryahni hnë kolomba, dabëtiɗilahna bi taŋ wëlakënde nke fac ntaw̃ëla?» ");
INSERT INTO cou_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Vëholëlohna ntëkwani wanës watac fëna. ");
INSERT INTO cou_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu kamahnëko vëhneh va tëhnaɗëni wëlaña wale ỹak hnëfak w̃a. Awa më nësëhnëkëhni waŋi: ");
INSERT INTO cou_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Age ahnë macehnëk rok roka ambënt cankaf, ant'ayi alaña ile ỹak hnëfak. Koɗ nke ale lëbëki ntënah faƴehnaryik. ");
INSERT INTO cou_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ale w̃acehnëku w̃uhnë ỹa koɗ njij ntehni: “Ƴëɗaryehna aỹi iỹi laña.” Awa, g'usëfëhnah fo matëɗu ayi alaña hafo laña rëkwa hna. ");
INSERT INTO cou_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Age ahnë macehnëki, ƴirye alaña laña rëkwa hna. Koyëna ge tëkik ale w̃acehnëki ỹa, mpëd koɗ ntehni: “Lawo, ƴij alaña laña hnëfak li.” Untënah hu ŋa yeɗ koyëna tase vële lañalahnërun va fop. ");
INSERT INTO cou_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pëƴaɗëmu, ale-wo-le hnaỹënaka mbanëɗe, do ale vanaka naỹënëɗe.» ");
INSERT INTO cou_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tac Yesu më ntehnëka ale w̃acëkëhniwo ỹa: «Age macehnëɗu roka vë g'anent ma vë g'anëka, ant'aw̃acëhni wëlawo hu ma vëhery hu, hnënk hu ma vësaryënt hu vëvetak, kaɓi koɗ macëgënihi vëhni fëna do cosënihi ile yëɗaruhëhniwo ỹa. ");
INSERT INTO cou_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ɓare ge macehnëɗu roka ambënt, macëryihni vëhaỹëhnah, vële nkojëk iñë ryampo mbahn hna, vële raɗëɗ do gë vumëp. ");
INSERT INTO cou_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Koyëna nëfaɗëhi, kaɓi vëhoɗina mbësanihi. W̃ënu ŋa vësaɗëhi ntëbi ile yëɗaruhëhni ỹa ante mbëhnëɗëni vële satëk va.» ");
INSERT INTO cou_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ga nkwëryëni watac aryampo hnë vële ntañalahnëniho hna më ntehnëka Yesu: «Mbëtak ale hnuỹaɗ laña Naw̃ W̃ën hna!» ");
INSERT INTO cou_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu më ntëkwaka gë iỹi uhnës uryindaryindan: «Asan w̃acehnëkëhniwo vahnë vëyaɓah roka ambënt cankaf. ");
INSERT INTO cou_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ga puhnayik roka ỹa më paƴëka aryokuŋ a macihni vëfaƴ va: “Ƴijën, puhnayik.” ");
INSERT INTO cou_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Ɓare vëfaƴ va fop muntaɗëniho tavëhnini, vëhoɗina njini roka. Asan a aryampo më ntehnëka aryokuŋ a: “Kaỹ law̃ëɓu takan, umë ñaɗëfu yëkiwu; muntami tavënde.” ");
INSERT INTO cou_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Aỹëntaw̃ më ntehnëka: “Waper wuhni mbëɗ law̃ëɓu, vëhni yiɗëfu yëkëhnahnu; muntami tavënde.” ");
INSERT INTO cou_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Ahaw̃ary kat më ntehnëk: “Takan ñëlëɓu, umë woɓu koɗa yihahnu.” ");
INSERT INTO cou_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Aryokuŋ a më mbokak g'ale ndokuŋënd pëƴahna fop wade ntëkwajik ŋa. Awa ahwëhn tere ỹa ntavëkawo ɗus ntehnëlehna aryokuŋ alëw̃u ỹa: “Ƴiryeyi ñap waỹëw̃a hna gë vankaw̃ vambë nkol vi, ayojëhni vëhaỹëhnah va gë vële ye vorovoro va, vumëp va do gë vële raɗëɗ va.” ");
INSERT INTO cou_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ga mbiỹëk toƴe, aryokuŋ a më njijëk ntehna ahwëhn tere ỹa: “Ntiɓu ile lehnakuho ỹa ɓare ha gaki nkok vilaña va.” ");
INSERT INTO cou_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Ahwëhn tere ỹa më mbok ntehnëka aryokuŋ a lëw̃u ỹa: “Ƴiryeyi vankaw̃ wëhaỹ hna gë fop haryënkw wakece ŋa do ali fere ayojëhni vële fankëlëɗun va fop njijëni, pëɓahn tere mën ỹi. ");
INSERT INTO cou_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Toña ỹa fëƴaɗëmu, wëla aryampo hnë vële ryënkwakëɓu w̃acu vi tokëɗina roka mën ỹi!”» ");
INSERT INTO cou_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesu nkoko njind do kore yaɓah rëfëɗëhawo. Më cahëtak ntehnëhni fop: ");
INSERT INTO cou_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ale yijëɗ ỹal mën, ami rëfëka ŋahno ntëbi rëmu, hnëmu, asëvalu, vutahu, vëheryu, vicëru, ntëbi umë dënk. Ge gena umë, koɗina nke arëfal mën. ");
INSERT INTO cou_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ale wok maw̃ana tëfëndo hafo paki cëm hnë kërëwa hna koɗina nke arëfal mën. ");
INSERT INTO cou_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Ge aryampo hnë w̃uhnë ñaɗ mbëry cery cankaf njihnah dañaɗina bi njëk ten koryi lëw̃u ỹa bi gwër puhnand ɗoku ỹa! ");
INSERT INTO cou_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ge aki fo pëgwëk mëkëna puhna vële hnuɗ va tëkëɗ ndasëhnëɗëniha. ");
INSERT INTO cou_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","«Ntehnëɗe: “Aỹi asan pëgwëk mbëryënd ɓare mëkëna puhna ɗoku ỹa!” ");
INSERT INTO cou_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ndampo fo nke ge ahnaw̃ njinëhniɗëha ahnaw̃antawu uw̃ët, kwëhnatëhni vësan wawuli pëhw (10,000) do aỹëntaw̃ a njijatënd gë vësan wawuli wafëhw wahi (20,000). Dañaɗina bi ten njëk bi koɗ mëtëni? ");
INSERT INTO cou_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ge koɗina, paƴëɗëhëhni vahnë ahnaw̃antawu hna, wati ante nkok ŋaw̃ëk ŋa, nkwëryëlëni antë mëtëni.» ");
INSERT INTO cou_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Awa, më ntehnëk Yesu: «Koyëna nke: wëla aryampo hnë w̃uhnë koɗina nke arëfal mën ge maw̃ëna tav ile kwëhnak ỹa fop. ");
INSERT INTO cou_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Waŋiry ŋa iñë fërën ye, ɓare ge gona ŋañ, hak koɗe mbokaryi ŋañëni; nkufahni nkal iŋi ma uhnëɗa w̃a? ");
INSERT INTO cou_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nafa goryaryëɗina waŋiry wante wok gona ŋañ; canëɗe. Nëparyin ɗus ge kwëhnarun vanëf awëryahnu!» ");
INSERT INTO cou_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vërëf ỹatëtanke gë vahnë vëw̃eh vëhaw̃ary tëhaɗënihawo Yesu soŋe nëpaniha. ");
INSERT INTO cou_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wafarise w̃a gë vëharaŋ sariya va umë mëhnaɗëni ntehnëndëni: «Aỹi asan maw̃ëk kacahni vëli wameh do tokëlahnëndëni gë vëhni!» ");
INSERT INTO cou_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Awa Yesu më nësëhnëkëhni aki: ");
INSERT INTO cou_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Hnë w̃uhnë, ge ahnë kwëhnakëhni wape keme do cëvaryata ryampo, tavëɗilihna bi wañëntaw̃ ŋa fop hn'ile keryëɗëhëhni hna njihahn njëkëlehna ile sëvëk ỹa hafo nuja? ");
INSERT INTO cou_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Do ge nujëka natiɗëha, ndafiɗëha vankus hna mënceryehn. ");
INSERT INTO cou_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Age tëkëk tere lëw̃u hna macëɗëhëhni wëlawow̃u w̃a gë vësaryëntaw̃u va fop do ntehnëhni: “Ƴijën nëhin kaɓi nujëɓuha ife mën ile sëvëko ỹa!” ");
INSERT INTO cou_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Paryi pëƴaɗëmu, ambin hna fëna koyëna dënk nkeɗ: ge ali wameh aryampo fo nkwëcëtak vankeya va, uhnatah w̃a njaɓëɗ ɗus hn'ambin hna ntëbini vësatah vëyaɓah vële nkok ɓalëna gwëcët vankeya vantëw̃ hni.» ");
INSERT INTO cou_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu më mbok ntehnëk: «Ge asëval hwëhnak waŋëc koryi ipëhw, cëvaryata uryampo, pëɗëɗina bi lampu ỹa, pahëc cery ŋa do njëhër wajira fo hafo nu? ");
INSERT INTO cou_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Do ge nuk, macëɗëhëhni wëlawow̃u w̃a gë vësaryëntaw̃u va ntehnëhni: “Nëhënëfu kaɓi nuɓu uỹëc koryi ule hnambëɓuho w̃a!” ");
INSERT INTO cou_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Toña ỹa fëƴaɗëmu, ge aw̃en aryampo fo nkwëcëtak vankeya vameh vantëw̃u va wamëleka W̃ënu ŋa natëɗëhëhni ɗus.» ");
INSERT INTO cou_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu më mbok ntehnëk: «Asan hwëhnakëhniwo vutah vucan vuki. ");
INSERT INTO cou_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fatoƴ fa më ntehnëka rëmu: “Apa, ƴëɗarye hnapul ile lëw̃ ɗëfu ỹa.” Awa rëm ỹa më cahëlehnëkëhni vutahu hnapul lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Hnë wafac toƴe, fatah fatoƴ fa më nkwafëk ile ceharyiko ỹa, njilehn hn'inkal ŋaw̃ah ɗus gë koryi lëw̃u ỹa fop. Umë njik tokëk koryi lëw̃u ỹa hnam hafo puhn. ");
INSERT INTO cou_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ga puhnëk koryi ỹa, inte cankaf yeho nkal tac, pëgwëlehn njëkëlehnand ile rëfëka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Njilehn ndokuŋëhnënda asan avë nkal tac. Asan arac, umë njoka gë wëhaỹ walëw̃u njëkandëhni vampëhëmpëh. ");
INSERT INTO cou_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Fatah fa ñaɗëho ɗus pihnënanti wëla g'uryav vampëhëmpëh w̃a fo, ɓare ahnë ƴëɗaɗilawohna. ");
INSERT INTO cou_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Awa ndënkwëtalehn ntehna: “Vëryokuŋ Apa va fop tokëɗëni gante ñaɗëni ka ɓare ami, inte ỹaɗ ndaw̃o ani! ");
INSERT INTO cou_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mbokaɗëfu gë vëhni Apa lehnëw̃a: ‘Apa, ntëntahnëɓuha W̃ënu ŋa do ntëntahnëmi wëjë fëna. ");
INSERT INTO cou_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gona tëfo yewu fatah hu. Pëlarye had aryampo gë vëryokuŋ hu ki.’” ");
INSERT INTO cou_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kahnëtalehn mbokand gë vëhni rëmu. Fatah fa nkoko ŋaw̃ tëkahn tere hna nujata rëmu ỹa ga njijëɗ, umë kaỹëhnahnëka ɗus g'aju do nkary kacahna g'uhnatah. ");
INSERT INTO cou_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","«Tac fatah fa më ntehnëka rëmu: “Apa, ntëntahnëɓuha W̃ënu ŋa do ntëntahnëmi wëjë fëna. Gona tëfo yewu fatah hu.” ");
INSERT INTO cou_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Ɓare rëmu më ntekëhni taŋ vëryokuŋ vëlëw̃u va: “Dëfëryin ayoju acuɗ ante ỹak wamëk ŋa asuɗuna ajë mën aỹi; diryina nënk fëmbak hna, do afaryuna wapary. ");
INSERT INTO cou_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ƴojëna fañihni fante ỹak hniryëkëfa aryaw̃una; tokinëhna ntihahnina ambënt. ");
INSERT INTO cou_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aỹi ajë mën had ale sëmëk nkeho do tame mbëhnik, cëvëko do nuɓuha.” Pëgwëlehnëni ambënt ŋa. ");
INSERT INTO cou_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Wati rac, fatah fandënkwëryënkw asan arac fa g'ikaỹ nkeho. Ga mënciɗ tëhat tere ỹa, umë nkwëryëkëhni vahnë ga nkaw̃ëɗëni. ");
INSERT INTO cou_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Më macëka aryokuŋ aryampo tëƴa bi ye ye tere hna. ");
INSERT INTO cou_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aryokuŋ a më ntëkwaka: “Ahery hu w̃ëncik, rëmuh më ndaw̃ëhnëka fañihni fante hniryëk fa, kaɓi ƴam fo mëncik.” ");
INSERT INTO cou_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Ntavëlehna fatah fandënkwëryënkw fa do ŋwëỹëko tënkëɗina tere hna. Rëmu më cahnik muntahna tënk. ");
INSERT INTO cou_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ɓare umë ntëkwaka: “Nëpary, Apa, wabëhn waƴaɓah ye koɓëri ga ndokuŋëhnahnëɗëmi, hara gwajëhnëlihna wëla uhnës ryampo. Ɓare wëla fanankal ƴëɗalihow̃ahna lihahnëfuna ambënt gë wëlawo mën w̃a. ");
INSERT INTO cou_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aỹi ajë hu ale w̃ëncik aỹi, umë gë vësëval tokëni koryi hu ỹa fop ɓare umë ryaw̃ëhnëruha fañihni faniryah fa alinëhnahna ambënt!” ");
INSERT INTO cou_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Rëmu më ntëkwaka: “Fatah mën, wëjë g'ami nkelahnik kwëlëkwël, do fop ile hwëhnëɓu ỹa wëjë hwëhnëk. ");
INSERT INTO cou_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tëfëka natëfu ntiyin ambënt kaɓi aỹi ahery hu, ale w̃ëncik aỹi, had ale sëmëk nkeho, mbëhnaryëkow̃a, cëvëko do nuyik.”» ");
INSERT INTO cou_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tac Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Ahwëhn hnapul yaɓah yeho. Asan arac hwëhnakawo aryokuŋ ale kwëtahnëko ɗus. Fac ryampo umë njijik pëƴayik: “Aryokuŋ hu ỹa përëkanëɗ hnapul hu ỹa fop.” ");
INSERT INTO cou_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Asan a më macëka aryokuŋ a ntehna: “Awa, ye wëryëɗëfu hnësëɗe soŋe hu? Pëƴarye gante ndokuŋahnëru hnapul mën ka: koɗila awo aye aryokuŋ mën.” ");
INSERT INTO cou_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Aryokuŋ a më ntehnak: “Ale ryokuŋëhnëɗefu ỹa daŋa nkeho. Hak ga ntiyaɗëfu? Age ntehnëɓu yiwu ƴam, kwëhnala fanka. Age ntehnëɓu fëna yiwu w̃unta, cëfëndëho. ");
INSERT INTO cou_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Njëtëɓu ile liɗëfu ỹa wëla layiwu ɗoku li nuỹaɗëfu hn'ile ñëw̃ëɗëfu!” ");
INSERT INTO cou_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Umë macëkëhni aryampo aryampo fop vële hnavëkawo ale ndokuŋënd va. Më ntehnëka aryënkwëryënkw a: “Waƴëhw wonanëruha ale ryokuŋëhnëɗëfu aỹi?”» ");
INSERT INTO cou_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Asan a më ntëkwak: “Wabiɗo keme (100) wacankaf wagu wonanëɓuha.”» «Aryokuŋ a më ntehnëka: “Wëlin kayëte nav hu ŋa. Dañary ñap aher wafëhw imbëɗ (50).”» ");
INSERT INTO cou_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Më mbok ntehnëka ahaw̃ary: “Wëjë lë, waƴëhw wonanëruha?”» «Më ntëkwak: “Wësaku keme (100) vantimp.”» «Aryokuŋ a më ntehnëka: “Wëlin kayëte nav hu ŋa; kerëry wafëhw mbëɗ gë warar (80).”» Koyëna ntikëhniwo fop. ");
INSERT INTO cou_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Awa, ahwëhn hnapul a, ga nuko gante kamënako ka, nësëko wapërën soŋe warit aỹi aryokuŋ a mama tokahnëkawo. Toña ỹa fëƴaɗëmu, vële faɓëk vëỹi ỹi ɗuniỹa vi fo ỹak ritëk yëbëlan lëw̃ hni ntëbënihëhni vëvë hnë humpen W̃ën vi. Vëvë hnë humpen W̃ën vi vëyëtëna gante nkeɗëni gë iỹi ɗuniỹa.» ");
INSERT INTO cou_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Ami ntehnëɗëmu: Ƴëɗahnëryindën iỹi hnapul vë ɗuniỹa ile rokaɗ gante tëfëka ka. Koyëna, ge puryaryëku, W̃ënu ŋa kacaɗëhu tere lëw̃u hna do nuỹaɗunëhëhni wëlawo. ");
INSERT INTO cou_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Ale facënak viỹë vile ỹak vak hna pacënaɗ visankaf hna fëna; ale ronkënak viỹë vile ỹak vak hna tonkënaɗ visankaf hna fëna. ");
INSERT INTO cou_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Awa, ge pacënaluhna hnë hnapul vë ɗuniỹa li, W̃ënu ŋa kwëtehnahnëɗëhu bi hnapul paryi ỹa? ");
INSERT INTO cou_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Do ge pacënaluhna hnapul vëỹëntaw̃ hna W̃ënu ŋa njëɗaɗëhu bi hnapul ile hwëhnërun paryi ỹa? ");
INSERT INTO cou_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ahnë koɗina njohalëhni vahnë vëhi gë ntaw̃ary dëw̃u ŋa fop: caŋëɗëni g'aryampo do ŋahnëɗëha; ñew̃ëɗëha aỹëntaw̃ a do njafa. Koɗiluhna ayohaluna W̃ënu ŋa do ayohalu fëna koryi ndampo fo.» ");
INSERT INTO cou_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wafarise, wale wëryëko waŋi wanës fop ŋa, njafaŋëɗënihawo Yesu, kaɓi koryi ỹa yeho lawo lëw̃ hni ỹa. ");
INSERT INTO cou_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu më ntehnëkëhni: «W̃uhnë ntiyaɗun had vësatah tase vahnë hna, ɓare W̃ënu ŋa njëtëk ile ye ntaw̃ary hun hna. Toña ỹa fëƴaɗëmu, ile naỹënëni vahnë ỹa W̃ënu ŋa ñaɗina rac. ");
INSERT INTO cou_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Sariya Moyis ỹa gë vëkayëte wakila va kwëhnako fanka hafo ante tëkiko San Ayary a do koɓëri tac, pëƴahniko Wanës Wakasëk itëk Naw̃ W̃ënu ŋa do ale-wo-le ntiɗ fere fop tënkahn. ");
INSERT INTO cou_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dehnëla sariya ỹa goryeryëna fanka. Ambin ŋi g'inkal iŋi yancëk nambi gë fakerëh fëndampo fatiƴ famb sariya cëvëɗina muk. ");
INSERT INTO cou_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Sariya ỹa tufahnëɗ, ale vambëka asëvalu do ñëla ahaw̃ary ntik ile mbañëk W̃ënu ŋa, do ale ỹëlëka asëval ale mbambëka asan ahaw̃ary ntik ile mbañëk W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Awa Yesu nantanëhnëkëhniwo iỹi uhnës uryindaryindan: «Asan avetak yeho. Asan arac viỹi viwamah ntiyaɗëho vilakah ntaw̃i do tokëɗëho had ambënt ye tere lëw̃u hna fac-wo-fac. ");
INSERT INTO cou_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Asan ahaỹëhnah yeho fëna, Lasar maciko. Rënka tere avetak hna ntanëɗeho, wahajëhn fo nkehawo mbahn iŋi fop. ");
INSERT INTO cou_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Vacaw̃el ile tokëɗëho avetak va ñaɗëho ɗus tok; ɓare ñoñ ƴëɗaɗelohna. Ile ỹak siyamëk ỹa waɓe ŋa fo yijëɗëho ndaỹëndëniha wahajëhn w̃a. ");
INSERT INTO cou_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Awa, fac ryampo ahaỹëhnah a cëmëko do wamëleka ŋa më njoniha ɗarël vëhni Abëraham hna. Tac avetak a fëna cëmëko, më mbañik, ");
INSERT INTO cou_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","janáma hna ntabiko, hnam korotëɗëho ɗus. Ga njëkalend më nuka ŋaw̃ët Abëraham gë Lasar ga kakëni. ");
INSERT INTO cou_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Avetak a pëgwëlehn ndekand: “Apa Abëraham, kaỹëhnahnëryiỹi g'ami! Paƴehna Lasar koƴi wëla sëmët irufa lëw̃u ỹi fo w̃ënka hna njij njamënahno ryëw̃ ỹi, korotëɗëfu ɗus hnë huŋi hwëɗëh.” ");
INSERT INTO cou_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ɓare Abëraham më ntëkwaka: “Fatah mën, ɗënkwëtary fop ile ỹaɗuho ỹa nuỹaruho ante nkoruho cëmëlihna ŋa, ɓare Lasar mbër ŋa nuỹako umë. Tame, ani mbosëvosehnëɗe wako wadëw̃u hna, hara wëjë mbër ŋa yehahnëru. ");
INSERT INTO cou_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Do fëna hatëh hacankaf yehëhna yëbëlan fu soŋe vële ỹaɗ njiryini va vëhoɗina, do koɗena ndaniji fëna hatëh hi njihahniji hn'ile nkeɓun li.” ");
INSERT INTO cou_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Avetak a umë ntehnëka: “Apa, këlami, paƴëryehna awa Lasar tere apa hna. ");
INSERT INTO cou_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vukery imbëɗ hwëhnaɓu hnam. Nji njëtëndanëhni soŋe antë njijëni vëhni fëna hnë iỹi ỹëw̃a hwëhn mbër.” ");
INSERT INTO cou_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Abëraham më ntëkwaka: “Vikerëh Moyis gë wakila ŋa ye ile yëtëndanëɗëhëhni vëhery hu va: araɓi nëpanihëhni do maw̃ëhnëndënihëhni!” ");
INSERT INTO cou_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Avetak a më ntehnëk: “Umë geɗina gwër, Apa Abëraham. Ɓare ge ahnë mbëhnëk vësëm hna nji tëkatëhni, nkwëcëtaɗëni vankeya va.” ");
INSERT INTO cou_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Ɓare Abëraham më ntëkwaka: “Vëhnëpana vikerëh Moyis va wakila ŋa; gena ge ahnë vëhnëk vësëm hna maw̃ëhnëɗëni.”» ");
INSERT INTO cou_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu më lenëkëhniwo vërëfal vëlëw̃u va: «Nkeɗ kwëlëkwël ile rëkëɗ ntiyehnëndëhni vahnë va wameh. Ɓare meka ale liyehnëka aỹëntaw̃u wameh! ");
INSERT INTO cou_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Soŋe sifa ahnë arac pecek nkwaki bëraka gëb li tac ntabi hnë wov, ani gë ntiyehnahnënda ahnë wameh lakënde fatah W̃ën fëndampo fo.» ");
INSERT INTO cou_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yesu më mbok ntehnëk: «Keharyin ɗus! «Ge aỹënta hu ntëntahnëki niraryehna; ge maw̃ëk ntëntëk do nkwëcëta vankeya va tavëhnëryehna. ");
INSERT INTO cou_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Lakënde ntëntahni wahwënta mbëɗ gë wahi fac hna do nte-wo-nte ŋa mbokaj ntehni: “Tavëhnërye, ntëntëɓu”, tavëhnëryehna.» ");
INSERT INTO cou_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tac vëfaƴik va ntehnënihawo Ahwëhn a: «Gwënëry ikwëtahn dëw̃ fu ŋa!» ");
INSERT INTO cou_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ahwëhn a më ntëkwakëhni: «Ge kwëhnarun ikwëtahn nte vak had uỹëc mutarëd, koɗun alehnuna aŋ'atëh, “Gëcary ani ayi afëla wov hna”, do maw̃ëndëhu.» ");
INSERT INTO cou_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu më mbok ntehnëk: «Ge ahnë hnë w̃uhnë kwëhnaka aramp ale yamëɗ wëhaỹ ma heryëɗëhëhni wusaw̃, gena bi dehnëɗilahna ge mëncik: “Ƴij alaña arok roka ỹa.” ");
INSERT INTO cou_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ɓare ntehnëɗëha: “Ge pëhwëtaru ahnëgëhno roku do sewu, tac g'arok g'ase, wëjë fëna.” ");
INSERT INTO cou_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tëfëlahna camehni aramp arac kaɓi ɗoku lëw̃u ỹa fo ntik. ");
INSERT INTO cou_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Koyëna nke soŋe hun ỹa fëna, ge ntirun fop ile ntehnëku W̃ën ỹa, dehnëryin: “Vëryokuŋ fo yeɓun vële wok vëwonëhnanina iñë. Ɗoku lëw̃ fu ỹa fo liɓun.”» ");
INSERT INTO cou_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ante nkoko njind Yesu Yerusalem ŋa, yëbëlan resiỹo Samari gë Galile tëfëko. ");
INSERT INTO cou_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ante ntënkëɗëho ankol ŋa tëhanihawo vëhwëhn ambiỹ ipëhw. Umë kahnëni ŋaw̃ët ");
INSERT INTO cou_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pëgwëlehnëni këlandëniha ndekandëni: «Yesu, Asankaf, kaỹëhnahnëryiỹi gë fuhnë!» ");
INSERT INTO cou_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu, ga nukëhni, më ntehnëkëhni: «Ƴiryin njëkënihu vësëna wasaɗëha va.» Wati nte njiɗëniho ŋa, njërëniho. ");
INSERT INTO cou_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aryampo hnë vëhni, ga nuk njërëk, mbokajëko ndekajatënd icëmb W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ga tëkik ɗarël Yesu, ndënkwëhnëlehn haryënkw lëw̃u yëka ỹi nkal li, do camehnënda. Asan arac avë Samari yeho. ");
INSERT INTO cou_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu më ntehnëka: «Gena bi pëhw iŋa fop yërënik? Ne nkehëhni mbëɗ gë vëhnah vëỹëntaw̃ va? ");
INSERT INTO cou_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Vëhnahana bi mbokajëni camehnëniha W̃ënu ŋa? Ahneh ale wok gena sëwif, aỹi fo vokajëk?» ");
INSERT INTO cou_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tac Yesu më ntehnëka asan a: «Matëry, ayi; kwëtahnëhu ŋa njërënëki.» ");
INSERT INTO cou_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fac ryampo wafarise w̃a tëƴënihawo Yesu bi guve tëkiɗ Naw̃ W̃ënu ŋa. Umë ntëkwakëhni: «Naw̃ W̃ënu ŋa ƴijëɗina had iñë ile hnuɗe. ");
INSERT INTO cou_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dehnëɗena: “Ani nke”, ma “Hnani nke”, ami pëƴaɗëmu, Naw̃ W̃ënu ŋa hnë w̃uhnë tëk nke lakënde nuɗiluhna.» ");
INSERT INTO cou_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tac më ntekëhni vërëfal va: «Wati yejëk ile përëɗëhu ahnuw̃una Ajë Ahn'a wëla fac ryampo fo, ɓare nuɗilunahna. ");
INSERT INTO cou_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ntehnëɗerun: “Ani nke!” ma “Hnani nke!” Ant'aw̃aw̃u, ant'arëfuni. ");
INSERT INTO cou_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ƴëtëryin, fac Ajë Ahn'a, ge tëkik, nkeɗ had mbilëbilik ambin hn'ani penëlehn ɗuniỹa ỹi fop. ");
INSERT INTO cou_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ɓare afo korot ten ɗus, do vahnë vëvë dol vi ŋwëỹëɗëniha. ");
INSERT INTO cou_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Wafac wale njihahniɗ Ajë Ahn'a nkeɗ had gë ƴamani rëm fu sankaf, Nowe, ka. ");
INSERT INTO cou_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Vahnë va tokëɗëniho, ceɗëniho, ñëlëlëɗëniho, do njëɗahnëɗënihëhniwo vëryag hni va ñëlini, hafo fac hn'ile tënkahnëko Nowe sisikulu hna. Awa w̃ac sankaf yijëko nkal hna ndaw̃ëhni fop. ");
INSERT INTO cou_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Nkeho fëna had ƴamani Lot ỹa: vahnë va tokëɗëniho, ceɗëniho, ntaw̃ëɗëniho do nkwafëɗëniho, njamëɗëniho do mbëryëɗëniho watere, ");
INSERT INTO cou_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","hafo fac hn'ile cahnëko Lot Sodom hna: W̃ënu ŋa tëviko g'ambin rëv hwëɗëh do gë wëraka hwëɗëh ndaw̃ëkëhniwo vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«Koyëna nkeɗ fac le tufëhnaɗ Ajë Ahn'a: vahnë va ɗoku lëw̃ hni fo ntiɗëni, vëfëhwëtaɗina ikaca mën. ");
INSERT INTO cou_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Fac rac ale yeɗ karyënkw cery ntëw̃u ŋa, antë tënk ɓambery nuf viỹë vilëw̃u; do ale ye hn'ikaỹ dëw̃u ỹa fëna antë mënc gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ndënkwëtaryin ile yehawo asëval Lot ỹa. ");
INSERT INTO cou_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ale ỹaɗ iỹi ɗuniỹa ỹa cëmëɗ, ɓare ale wok kwëtahnëna nëf iỹi ɗuniỹa ỹa pehëtaɗ umë dënk. ");
INSERT INTO cou_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Pëƴaɗëmu, hnë umëɗ tac vahnë vëhi ryakëɗ hn'ipad ndampo fo; nufëɗe aryampo do tavi aỹëntaw̃ a. ");
INSERT INTO cou_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vësëval vëhi rëkëɗ ndaw̃ëndëni ryëw̃a ndampo fo; nufëɗe aryampo do tavi aỹëntaw̃ a. ");
INSERT INTO cou_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vësan vëhi yeɗ hn'ikaỹ; nufëɗe aryampo do tavi aỹëntaw̃ a.» ");
INSERT INTO cou_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Vërëfal va më tëƴëniha: «Ahwëhn, ne nkeɗ watac?» Yesu më ntëkwakëhni: «Hn'ile nkeɗ waỹas hna mbarëpëlëɗëni wahuy w̃a.» ");
INSERT INTO cou_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu më mbok nësëhnëkëhni kat vërëfal vëlëw̃u va tufahnëhni tëfëkëhni njëfandëni kwëlëkwël hara vësilëtana: ");
INSERT INTO cou_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Nkeho hn'ankol ndampo ahitiŋ ale woko dakëɗilahna gë W̃ënu ŋa do dënënëɗilëhniwohna vahnë va. ");
INSERT INTO cou_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nkeho fëna hn'ankol tac asëval ale cëmaryëko asan. Asëval arac njiɗëho kwëlëkwël ahitiŋ hna ntehnënda kitiŋëhni g'ale nkelëkëhni ỹa. ");
INSERT INTO cou_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","«Ahitiŋ a ŋwëỹëɗëho kwëlëkwël, tac më ntehnak: “Dakëɗilohna gë W̃ënu ŋa do dënënëɗëw̃ëhnihna vahnë va, ");
INSERT INTO cou_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ɓare kaɓi aỹi asëval mbërehnëko, kitiŋëɗëfuhëhni, soŋe antë mbok njij njankëndo gë wanës.”» ");
INSERT INTO cou_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tac Ahwëhn a më mbok ntehnëk: «Nëparyin wante nësëk ahitiŋ ayapah arac! ");
INSERT INTO cou_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Awa, W̃ënu ŋa lë gwëcanëɗilihna bi vële kwëhnëk va age muntaɗëniha g'umëɗ gë g'anent? Ɗemankëɗilihna bi? ");
INSERT INTO cou_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pëƴaɗëmu, nkwëcanëɗëhëhni wati le rëfëka ỹa. Ɓare ge Ajë Ahn'a mbokajëk tëkatëɗëhëhni bi vële hwëtahnëka nkal li?» ");
INSERT INTO cou_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu mboko nanta iỹi uhnës uryindaryindan soŋe vële ntiyahnëk satëk do yafëkëhni vëỹëntaw̃ va fop: ");
INSERT INTO cou_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nkeho farise g'arëf ỹatëtanke. Vësan vërac tënkëniho Cery W̃ën Cankaf hna imunta. ");
INSERT INTO cou_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farise ỹa më kahnëk muntaɗ cahët minu fo ntehnënd: “W̃ën, camehnëmi gante nkoɓu gela gë vëỹëntaw̃ ki, vële leɗ vëỹi vahnë, w̃ek do yëkëlehnëɗ vësëval vëhaw̃ary; ha, camehnëmi gante nkoɓu gela g'aỹi arëf ỹatëtanke ki. ");
INSERT INTO cou_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cuŋëɗëfu wahwënta wahi wafac mbëɗ gë wahi hna, do njëɗahnëɗëfu Cery W̃ën Cankaf hna hwëhn pëhw hn'ile-wo-le hnuỹaɓu hna.” ");
INSERT INTO cou_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Arëf ỹatëtanke ỹa, umë, kamëhni kahnëko ŋaw̃ët mbankatënd sakahnëha do ɗëkëɗilohna kaŋ g'ambin ntehnënd: “W̃ën, kaỹëhnahnëryiỹi g'ami, aravëhno kaɓi aw̃en yeɓu.”» ");
INSERT INTO cou_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu më mbok ntehnëk: «Paryi pëƴaɗëmu, W̃ënu ŋa arëf ỹatëtanke ỹi, ntehnëko satëk, gena farise ỹi. Ale-wo-le hnaỹënaka mbanëɗe ɓare ale vanaka naỹënëɗe.» ");
INSERT INTO cou_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vahnë yinenëhnikawo Yesu wëla vutah vutoƴ va tindëhni wëɓák wadëw̃u ŋa ndëwahni. Vërëfal va, ga nuni rac, më niranihëhni. ");
INSERT INTO cou_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɓare Yesu më tahëndakëhni vutah va do ntehn: «Tavëryinëhni njijëni vutah va, ant'aw̃emaỹehnuni, kaɓi Naw̃ W̃ënu ŋa vële ye had vëhni va hwëhnëk. ");
INSERT INTO cou_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Toña ỹa fëƴaɗëmu, ale wok maw̃ëhnëlahna W̃ënu ŋa had gante maw̃ëndëhëhni fatah rëmu gë hnëmu ka tënkëɗina muk Naw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hnë wati rac, asankaf wasëwif rëƴëkawo Yesu: «Aharaŋ afërën, ye rëfëko liwu rënkahnu uwám usër hna?» ");
INSERT INTO cou_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu më ntëkwaka: «Soŋe ye w̃acëɗuho afërën? Ahnë afërën gena ge gena W̃ënu ŋa fo. ");
INSERT INTO cou_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Soŋe ile rëƴëru ỹi, gena njëtëru bi vakwëɗa va? “Ant'aryaw̃a ahnë; ant'ayëkëlehna asëval ahaw̃ary; ant'ale; ant'aye seɗe wamër; dënënëryihni rëmuh gë hnëmuh.”» ");
INSERT INTO cou_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Asan a më ntëkwaka: «Vaŋi vakwëɗa fop maw̃ëhnëɓu koɓëri utah mën hna.» ");
INSERT INTO cou_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu, ga nkwëryëk wanës watac, më ntehnëka: «Awa, iñë ryampo wojëki: ƴiry awaf fop ile hwëhnaru ỹa do ayëɗahni koryi ỹa vëhaỹëhnah va, koyëna nuỹaɗu hnapul yaɓah ambin hna. Tac ƴij arëfëlehnëndo ami fo.» ");
INSERT INTO cou_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ɓare asan a, ga nkwëryëk wante ntehnëka Yesu ŋa, njamëlehnëko kaɓi mbetako ɗus. ");
INSERT INTO cou_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu, ga nuka gante njamëk ka, më ntehnëk: «Ntakëk vëvetak tënkëni Naw̃ W̃ën hna! ");
INSERT INTO cou_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Itënk yonkomb hnë hatëh sirehn ỹak hnëŋëk g'itënk avetak Inaw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Vële hnëpaɗëhawo va më ntehnëni: «Mo ye awa ale hoɗe pehëti ỹa?» ");
INSERT INTO cou_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu më ntëkwakëhni: «Vahnë va vëhoɗina, ɓare W̃ënu ŋa koɗ.» ");
INSERT INTO cou_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Awa, Piyer më ntehnëka Yesu: «Nëpary, tavëɓun ile hwëhnaɓun ỹa fop soŋe arëfëlehnënde.» ");
INSERT INTO cou_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmu: ge ahnë tavëk tere lëw̃u, asëvalu, vëheryu, do vicëru, rëmu gë hnëmu gë vutahu soŋe Naw̃ W̃ënu ŋa, ");
INSERT INTO cou_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nuỹaɗ ntëbi ile kwëhnako koɓëri ỹa do nuỹaɗ ɗuniỹa ile wok puɗina wati ile yejëk ỹi.» ");
INSERT INTO cou_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu canaryëkëhniwo vërëfal pëhw gë vëhi va do ntehnëhni: «Nëparyin, gë Yerusalem njiɗen. Hnam ntiyaɗ fop ile kerëni wakila soŋe Ajë Ahn'a. ");
INSERT INTO cou_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Njëɗahnëɗëniha vële wok vëyena wasëwif, njafaŋëɗëniha, njew̃ëɗëniha, tëpahnëɗëniha, ");
INSERT INTO cou_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ntampëɗëniha, tac ndaw̃ëɗëniha; do fac rarëna hna mbëhnëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ɓare ñoñ vëyëtëlohna ile nësëɗ; cow̃iniho ile ye wanës watac ỹa do wanës Yesu watac ntëbëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ante tëhaɗëho Yesu nkol Seriko ŋa, umëp lañako w̃untaɗëho ɗarël nkaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ga nkwëryëk wëñaw̃ kore le ryëcëɗëho umë tëƴëk bi ye ye. ");
INSERT INTO cou_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Më pëƴayik: «Yesu vë Nasaret ryëcëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Awa, më ndekak: «Yesu, Aju David, kaỹëhnahnëryiỹi g'ami!» ");
INSERT INTO cou_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vële ryënkwëko va më niraniha ndemëhna, ɓare tac nkwënëk waɗeka ŋa: «Aju David, kaỹëhnahnëryiỹi g'ami!» ");
INSERT INTO cou_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu kahnëko, më ntehnëk njinenëhnijihna umëp uŋa. Ga tëkaryijik, Yesu më tëƴëka: ");
INSERT INTO cou_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ye ỹaɗu linëhni?» Umë ntëkwak: «Ahwëhn, vok hnundu ỹaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu më ntehnëka: «Araɓi avoka ahnund; kwëtahn hu ŋa pehëtëki.» ");
INSERT INTO cou_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Taŋ, mbokalehn nund do tëfëlehnënda Yesu cëmbatënda W̃ënu ŋa. Kore ỹa fop nuniho watac do cëmbëntëndenihawo W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu tënkëko Seriko hna do ndëcëɗëho nkol hna. ");
INSERT INTO cou_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Asan ale w̃acik Yase yeho hnam. Asankaf vërëf ỹatëtanke yeho do mbetako ɗus. ");
INSERT INTO cou_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ñaɗëho nuhna ale w̃acëɗe Yesu ỹa ɓare koɗilohna kaɓi ƴihnëlohna do vahnë va njaɓëniho haryënkw lëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Awa, umë nkaryëk karyënkw gë nkaw̃ ante tëfëɗ Yesu, kaƴ hnë tëh soŋe nuhna. ");
INSERT INTO cou_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ga tëkëk Yesu ɓaƴ hnam më kaŋaka do ntehna: «Cëli ñap, Yase: dol ỹal hu hna njinëgaɗëfu.» ");
INSERT INTO cou_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yase cëlëlehni ñap njohna Yesu g'uhnatah gë tere lëw̃u. ");
INSERT INTO cou_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ga nuni watac, fop ntavëkëhniwo, më ñakëñakëɗëni nësëndëni wëɓa Yesu: «Tere ale liɗ wameh cëlahnëk aỹi asan.» ");
INSERT INTO cou_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ga tëkëni tere hna, Yase kahnëko haryënkw Ahwëhn a ntehna: «Nëpary, Ahwëhn, njëɗaɗëfuhëhni cape ndampo hnapul mën ỹa vëhaỹëhnah va, do ge nufëhnëɓuha ahnë koryi ɗëcët, mbësaɗëfuha wahwënta wahnah g'ile hnufëhnëɓuha ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu më ntehnëk: «Dol W̃ënu ŋa pehëtëkëhni vëvë iỹi tere vi, paryi nke, aỹi asan fëna fatah Abëraham ye. ");
INSERT INTO cou_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pëƴaɗëmu, Ajë Ahn'a njijëk njëkëlehnëhni do pehëtëhni vële sëvëko va.» ");
INSERT INTO cou_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu më mbok nantanëkëhni uhnës uryindaryindan soŋe vële wëryëko takan wanës watac va kaɓi tëhako Yerusalem do ntiyahnëkëhniwo vahnë va tameki tëkiɗ Naw̃ W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wëlin ile nësëko ỹa: «Asan yeho ale hnagiko hnë tere lënah, nji hn'inkal ŋaw̃ah, soŋe nji naw̃ëndi; tac do wavokaj. ");
INSERT INTO cou_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Njihahnënd ỹa umë macëkëhni vëryokuŋ ipëhw vëlëw̃u va, njëɗakëhni ale-wo-le uỹëc sanu hwëhn nafa yaɓah do ntehnëhni: “Ɗokuŋandin iỹi hnapul hafo vokaju.” ");
INSERT INTO cou_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Ñew̃ënihawo ɗus asan arac; umë paƴënihëhni vëfaƴ kamëhni lëw̃u pëƴahnëni: “Ñaɗilëfunahna aỹi asan naw̃ëhnëfu nkal fu li.” ");
INSERT INTO cou_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ɓare rëkëk naw̃ëndi. Tac më mbokajëk nkal dëw̃u hna do macehnëhni vëryokuŋ vëlëw̃u vële njëɗako koryi va: ñaɗëho njët bi hak ndokuŋahnëni ale-wo-le. ");
INSERT INTO cou_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Aryënkwëryënkw a më njijëk ntehn: “Ahwëhn, uỹëc sanu ule yëɗaruhow̃o w̃a nagëk waŋëc pëhw.” ");
INSERT INTO cou_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ahnaw̃ a më ntehnëka: “Njivëk, aryokuŋ afërën yeru; kaɓi pacënaru viỹë viroƴ hna, ntiɗëmi asankaf hnë vankol ipëhw.” ");
INSERT INTO cou_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ahigëna ỹa më njijëk ntehn: “Ahwëhn, uỹëc sanu hu w̃a waŋëc imbëɗ nagëk.” ");
INSERT INTO cou_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Ahnaw̃ më ntehnëka: “Awa, wëjë asankaf vankol imbëɗ liɗëmi.” ");
INSERT INTO cou_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Aryokuŋ ahaw̃ary më njijëk ntehn: “Ahwëhn, wëli uỹëc sanu hu w̃a; hnë fankwëỹ ipand kwëtëɓuho. ");
INSERT INTO cou_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ntakëkow̃o gë wëjë kaɓi njapëru: nufëɗu ile woru kwëtëlihna do kacëɗu ile woru naɗëlihna.” ");
INSERT INTO cou_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Ahnaw̃ a më ntehnëka: “Aryokuŋ aw̃eh yeru, wante hnësëru ŋi hwëɗandëmi. Ntehnëru njëtëruho njapëɓu, nufëɗëfu ile woɓu kwëtëla do kwëcëɗëfu ile woɓu naɗëla. ");
INSERT INTO cou_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Awa, ge koyëna nke, soŋe ye woru kwëtëlihna koryi mën ỹa hnë bank? Ge mënciɓu kokëndeɓu wënëhniwu ge mbiɗëfu.” ");
INSERT INTO cou_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Tac më ntehnëkëhni vële yeho hnam va fop: “Teɓëryina ayëɗawuna ale hwëhnak waŋëc sanu pëhw aỹi.” ");
INSERT INTO cou_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Umë ntëkwaniha: “Ahwëhn, umë njaɓëka, tëk kwëhna waŋëc ipëhw!” ");
INSERT INTO cou_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Toña ỹa fëƴaɗëmu, ale hwëhnak ỹa nkwënënde, ɓare ale wok kwëhnana ỹa, teɓëɗe wëla ile liyahnëka rëkëk nuỹa ỹa. ");
INSERT INTO cou_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Awa, soŋe vële wok vëỹaɗina yenëhnëw̃ëhni ahnaw̃ vi ƴojënëhni ani aryaw̃uni tase mën.» ");
INSERT INTO cou_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ga nësëk koyëna, Yesu kahnëtako ndënkwëhnëhni vahnë va nkaw̃ hna njindëni Yerusalem. ");
INSERT INTO cou_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ante tëhako nkol Betëfase gë nkol Betani, ɗarël Kuŋ Oliviye hna, umë paƴëkëhni vërëfal vëhi haryënkw, ");
INSERT INTO cou_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","më lehnëkëhniwo: «Ƴiryin hn'ankol ante ye haryënkw ŋi. Age tëkërun tëkatëɗunëha, ga pokik, fapali fante wok koɓëri kaƴina. Pëtina ayojuna ani.» ");
INSERT INTO cou_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Age ahnë tëƴëku bi soŋe ye fëtëɗunëha, dehnëryina Ahwëhn a valëka. ");
INSERT INTO cou_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Vërëfal va njilehnëni do tëkatëni fop gante ntehnëkëhniwo Yesu ka. ");
INSERT INTO cou_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wati ante pëtëɗënihawo fapali ŋa vële hwëhnëka va më tëƴënihëhni: «Soŋe ye fëtëɗunëha fapali fi?» ");
INSERT INTO cou_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Umë ntëkwani: «Ahwëhn a valëka.» ");
INSERT INTO cou_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tac më njonëhnëniha fapali fa Yesu, tindëniha vacuɗ vantëw̃ hni va kaƴëndëlehnëniha hnam Yesu, ");
INSERT INTO cou_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","kore ỹa ntanëndënihawo Yesu vacuɗ vantëw̃ hni va nkaw̃ hna njitënd. ");
INSERT INTO cou_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ante tëhaɗëniho Yerusalem ŋa, gë cape cëpëta Kuŋ Oliviye ŋa, kore vërëfal ỹa fop pëɓëkëhniwo uhnatah w̃a, pëgwëlehnëni ndekandëni cëmbëndëniha W̃ënu ŋa kaɓi viỹë vifëmpëhnahnah viyaɓah nuniho. ");
INSERT INTO cou_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ntehnëɗëniho: «Araɓi Ahwëhn a W̃ënu ŋa njëɗa ale yijëɗ naw̃ g'uw̃ac lëw̃u w̃a! Araɓi ƴam ỹa nke hn'ambin hna do W̃ën Hunte Sëpëk Fop ŋa cëmbi!» ");
INSERT INTO cou_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wafarise wëryampo yentiko kore hna më ntehnëniha Yesu: «Aharaŋ, dehnëryihni vërëfal hu vi ndemëhnani.» ");
INSERT INTO cou_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu më ntëkwakëhni: «Pëƴaɗëmu, ge ndemëhnani, wëraka w̃i ndekaɗ cëmb mën iŋa!» ");
INSERT INTO cou_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu, ante tëhako nut naw̃ Yerusalem ŋa, konëhnëɗëhawo, ");
INSERT INTO cou_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ntehnatënd: «Yerusalem, kaỹëhnahnëko gë wëjë. Age njëtakëndu ile liɗu ahnuỹahn ƴam ỹa, wëla dol fo, njivakëndëhi. Ɓare umë tame cow̃iru! ");
INSERT INTO cou_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wafac yenëhniki vëỹew̃ hu va mbëryëɗëni hëƴa kece hu hna tënkëhnahnënihi. Kwërëɗënihi caharaɓ do ñaƴëɗënihi vacape va fop. ");
INSERT INTO cou_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mbëvendënihi fop, wëjë gë ɓulunda lëw̃ hu ỹa, vëravëndilihna wëla itaka ɗampo nko tinda hnë ỹëntaw̃. Ỹin fop nkeɗ kaɓi ƴavëtëlihna wati ile njijëk W̃ënu ndemaỹi ỹa!» ");
INSERT INTO cou_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu tënkëko selele Cery W̃ën Cankaf hna pëgwëlehn ntandëhni vëwaf vële yeho hnam va. ");
INSERT INTO cou_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ntehnëɗëhëhniwo: «Vikerëh W̃ënu va më lek: “Cery mën ŋa Cery iƴëfa macëɗe.” Ɓare w̃uhnë, sow̃a vële lirun!» ");
INSERT INTO cou_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu karaŋëɗëhëhniwo fac-wo-fac Cery W̃ën Cankaf hna. Vësankaf vësëna wasaɗëha va, gë vëharaŋ sariya va do gë vëvë karyënkw ɓulunda va fop njëkëlehnëɗëniho ndaw̃ehnëniha. ");
INSERT INTO cou_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ɓare vëyëtëlohna bi hak ntiɗëni pëlahnëniha, kaɓi ɓulunda ỹa fop nkok nëpanda kwëlëkwël, umë fo ndilaniho. ");
INSERT INTO cou_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Fac ryampo, Yesu karaŋëɗëhëhniwo ɓulunda ỹa Cery W̃ën Cankaf hna do pëƴaɗëhëhniwo Wanës Wakasëk ŋa. Vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va do gë vicër va tëhanihawo ");
INSERT INTO cou_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","do tëƴëniha: «Pëƴaryifu, bi g'iỹëhne fanka ntiɗu vëỹin, mo lehnëki alind?» ");
INSERT INTO cou_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu më ntëkwakëhni: «Ami fëna tëƴëɗëmu iñë ryampo. Pëƴaryino, ");
INSERT INTO cou_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mo faƴikawo San njaryënd? W̃ënu ŋa bi ye ma bi vahnë va faƴikawo?» ");
INSERT INTO cou_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɓare pëgwëniho nkwajëlëndëni vëhni fo ntehnëlëndëni, ge ntëkwayinëka W̃ënu ŋa faƴikawo, tëƴëɗëhëfu, soŋe ye woyinëk kwëtahnilënahna? ");
INSERT INTO cou_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ge ntehninëk, vahnë va faƴikawo, ɓulunda ỹa fop ntutëɗënihëfu gë wëraka soŋe ndaw̃ënihëfu, kaɓi kwëtahnëni San kila yeho. ");
INSERT INTO cou_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Awa më ntëkwaniha: «Ƴëtëlëfuhna bi mo faƴikawo njaryënd.» ");
INSERT INTO cou_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu më ntëkwakëhni: «Awa njivëk, ami fëna pëƴaɗiluhna fanka fale lihandëɓu vëỹin va.» ");
INSERT INTO cou_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tac, Yesu pëgwëlehn nantanëhnëɗëhni ɓulunda ỹa uhnës uryindaryindan: «Nkeho asan ale fëlëko ikaỹ waresen do kwëtehnahnëhni vëyam njilehn uyas ule viỹëɗ. ");
INSERT INTO cou_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ante tëkëk wati ile kwëcëɗe waresen ŋa, më paƴëka aryokuŋ hnë vëyam hna soŋe njëɗaniha sah lëw̃u ỹa hnë waresen wale mbarëpëni hna. Ɓare vëyam va ndafënihaw̃o ale faƴiko ỹa ntalehnëniha wëɓák fo. ");
INSERT INTO cou_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ahwëhn kaỹ a mboko paƴa ahaw̃ary kat, ɓare vëyam va mbok ndafëniha umë fëna, njew̃ëniha ntalehnëniha wëɓák fo. ");
INSERT INTO cou_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mboko paƴa kat aryokuŋ ararëna alëw̃u ỹa; arac më cërehnëniha do canëniha g'ipër. ");
INSERT INTO cou_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Awa ahwëhn kaỹ a më ntehnak: “Ye rëfëko liwu? Paƴëɗëfuha ajë mën ale ỹahnëɓu ɗus aỹi: ntiyahnëko umë ntënënëɗëniha.” ");
INSERT INTO cou_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Aju njiko hnam, ɓare vëyam va, ga nuniha, ntehnëlëɗëniho vëhni fo: “Wëliho ale lëw̃ëɗ ikaỹ iŋi. Ɗaw̃ënëfuna, kwëhnahnin.” ");
INSERT INTO cou_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tac canëlehnëniha kaỹ hna do ndaw̃ëniha. Awa tëƴëɗëmu: Ye ntiɗëhëhni ahwëhn kaỹ ŋa vëyam va? ");
INSERT INTO cou_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pëƴaɗëmu njijëɗ ndaw̃ëhni vëỹi vëyam do njëɗahni kaỹ iŋi vëhaw̃ary.» Vahnë va, ga nkwëryëni wanës watac, më ntehnëni: «Araɓi W̃ënu ŋa antë maw̃ waŋi muk!» ");
INSERT INTO cou_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ɓare Yesu ntaŋëkëhniwo do ntehnëhni: «Ye pëhnëtanëk waŋi wanës waɓë vikerëh ŋi: “Itaka inte cañëtaniho vëvëry vacery ŋa vacak ye tame inte mbëryahnëk W̃ënu ŋa cery ntëw̃u ŋa fop”? ");
INSERT INTO cou_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ale-wo-le yoɗ hn'iŋi taka ỹa nihëɗ do ge taka ŋi ahnë njohahnëk, ivëɗ fo ntiɗëha.» ");
INSERT INTO cou_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vëharaŋ sariya va gë vësankaf vësëna wasaɗëha va njëkëlehnëɗëniho pëlaniha Yesu hnë wati rac dënk, kaɓi njëtëniho soŋe lëw̃ hni nantahnëko iỹi uhnës uryindaryindan, ɓare ntakëkëhniwo gë ɓulunda ỹa. ");
INSERT INTO cou_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pëgwëlehnëni njëkandëniha Yesu. Soŋe watac, cañëtëlehnënihëhni vahnë vële liyako had vëfërën ye. Vahnë vërac ñaɗëniho pëlaniha Yesu hn'urënd gë wanës wadëw̃u ŋa, nuỹahnëni fere njëɗanahnëniha gë vësankaf. ");
INSERT INTO cou_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Më ntehnëniha aki: «Aharaŋ, njëtëɓun ile hnësëɗu do haraŋëɗu ỹa caŋëk; Kwëtahnëlihna nëf ile nke ahnë, ɓare toña ỹa fo haraŋëɗuhëhni vahnë va. ");
INSERT INTO cou_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Awa pëƴaryifu, sariya fu ỹa fuhnë wasëwif maw̃ëryak bi ma maw̃ëryana cosi ỹatëtanke ỹa asankaf a, Sesar?» ");
INSERT INTO cou_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ɓare Yesu njavëtëko urënd lëw̃ hni w̃a më ntehnëkëhni: ");
INSERT INTO cou_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Tufëryino ỹëc koryi.» Ga tufëniha, awa më tëƴëkëhni yëka mo g'uw̃ac mo liyik koryi li? Më ntëkwaniha: «Sesar.» ");
INSERT INTO cou_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Më ntehnëkëhni: «Awa ɓësaryina Sesar ile kwëhnëk ỹa, do W̃ënu ŋa ile kwëhnëk ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Vëhoɗilohna pëlaniha hnë wanës wante ntëkwaɗëho tase ɓulunda ŋa. Pëmpëhnahnëkëhniwo ɗus ndemëhnalehnëni. ");
INSERT INTO cou_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Vahnë vëvë Saduse rëhakawo Yesu. (Vëhni lehnëɗëho vësëm va vëvëhnëɗina.) ");
INSERT INTO cou_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aki ntehnënihawo: «Aharaŋ, Moyis njëɗakëfu aŋ'akwëɗa: “Age asan ỹëlëk, do cëm hara kwëhnana vutah, aheryu ntëw̃ëɗëha asëval a soŋe nagëhnahna acëru vutah.” ");
INSERT INTO cou_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Awa, nkeho hwënta ryampo vësan mbëɗ gë vëhi vële vankëko rëm gë hnëm. Aryënkwëryënkw a ñëlëko do cëm hara tavëna vutah. ");
INSERT INTO cou_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ahigëna ỹa ñëlëgëkawo asëval a do cëm umë fëna hara tavëna vutah, ");
INSERT INTO cou_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tac ararëna ỹa. Koyëna nkehëhniw̃o mbëɗ gë vëhi va fop, cëmëniho hara vëravëlëlihna vutah. ");
INSERT INTO cou_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tac, asëval a fëna cëmëgëlehn. ");
INSERT INTO cou_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Awa, mo hwëhnëɗëha asëval aỹi hnë fac ile mbëhnahnëɗëni vësëm hna kaɓi mbëɗ gë vëhi vi fop ñëlënihawo?» ");
INSERT INTO cou_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu më ntëkwakëhni: «Vësan gë vësëval iỹi ɗuniỹa vi ñëlëlëɗëni; ");
INSERT INTO cou_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ɓare vësan gë vësëval vële hitiŋik catëni tëfëka mbëhnëni vësëm hna do nkentini ɗuniỹa ile yejëk. Hnam vëỹëlëlëɗina. ");
INSERT INTO cou_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vëhoɗina mbok cëmëni: gë wamëleka ki nkeɗëni. Iɓëhn inte mbëhnëɗëni ŋa rufahnëɗ vutah W̃ën paryi ye. ");
INSERT INTO cou_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyis pëƴahnëk wapacëk vësëm va mbëhnëɗëni. Hnë vikerëh vinte hnësëndëhawo Ahwëhn a haryënkw fatëh fante ỹagëɗ hna, Moyis macëkawo “W̃ën Abëraham, W̃ën Isak, do gë W̃ën Sakob.” ");
INSERT INTO cou_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Awa, W̃ënu ŋa gena W̃ën vësëm. W̃ën vële wok vësëmëna ye, kaɓi vutah vuntëw̃u va fop mbëhnëɗëni.» ");
INSERT INTO cou_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Awa, vëharaŋ sariya vëryampo më teɓani wanës ŋa do ntehnëniha: «Toña hnësëru, Aharaŋ.» ");
INSERT INTO cou_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Do vëryëkëɗilohna mbok tëƴëniha wakaw̃ary. ");
INSERT INTO cou_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu më ntehnëkëhni: «Hak koɗe ntehni Arëhnayik a Aju David ye? ");
INSERT INTO cou_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David hnësëk Kayëte Wahnëw̃ hna: «Ahwëhn a W̃ënu ŋa më lehnëka Ahwëhn mën a: Ƴij alaña g'irëhw mën, ");
INSERT INTO cou_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hafo hale këfëɗëfuhëhni vële ỹew̃ëki va haryënkw hu. ");
INSERT INTO cou_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Awa, age David “Ahwëhn” macëɗëha, hak koɗ Arëhnayik a fëna nke aju David?» ");
INSERT INTO cou_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ante nëpaɗënihawo Yesu kore ŋa, ntehnëkëhniwo vërëfal vëlëw̃u va: ");
INSERT INTO cou_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Keharyinëhni vëharaŋ sariya vi. Vëhni nëŋahnëkëhni gwërëtalehn gë vacuɗ vajaryah do ỹaɗ nkaỹëndeni g'untënah waỹëw̃a ɓulunda hna; tëhnaɗëni wëlaña wale rëkëɗe nuhahnëndeni vacaliŋa hna do gë wëlaña vahnë vëlënah hn'ile tokëɗe roka sankaf hna. ");
INSERT INTO cou_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Teɓëɗënihëhni vësëval vële cëmaryëk vësan va fop ile kwëhnani ỹa, do taŋ munta ƴaryah muntaɗëni, ntehnahni vahnë vëfërën ye. Soŋe umë, W̃ënu ŋa kwëɗëɗëhëhni ntëbini vëỹëntaw̃ vi fop.» ");
INSERT INTO cou_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu njëkëko caharaɓ lëw̃u do nukëhniwo vëvetak hwëtëɗëho uyëɗahn lëw̃ hni hn'ile kwëtëɗeho Cery W̃ën Cankaf hna. ");
INSERT INTO cou_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nukawo fëna asëval, ale cëmaryëk asan, ahaỹëhnah ɗus, ga kwëtëɗ vuŋëc vuki koryi vunte wok ƴaɓëlahna nafa. ");
INSERT INTO cou_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu më ntehnëk: «Toña ỹa fëƴaɗëmu: ile kwëtëk asëval aỹi yaɓëk ntëbini vëỹëntaw̃ vi fop, ");
INSERT INTO cou_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kaɓi vëỹëntaw̃ vi fop njëɗahnëni koryi ile wok ɓalëlëhnihna, ɓare umë, hn'uhaỹëhnah lëw̃u hna, njëɗahnëk le kwëhnak ỹa fop ile rëfëkawo kwëta soŋe lëw̃u ỹa dënk.» ");
INSERT INTO cou_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tac vëryampo nësëɗëniho soŋe Cery W̃ën Cankaf ŋa ntehnëndëni: «Nkwamëk, gë wëraka wawamah walëw̃u w̃i gë vile wamënahnik vi!» ");
INSERT INTO cou_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesu më ntëkwakëhni: «Pëƴaɗëmu, ile hnuɗun ỹi, wafac yejëk le nkoɗ gona ani wëla itaka ɗampo tinda hn'iñëntaw̃; fop nihëɗe.» ");
INSERT INTO cou_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Më tëƴëniha: «Aharaŋ, awa guve ntiyaɗ watac? Ye yeɗ dahëse ile rufahnëɗ ante tëkiɗ vëỹin ŋa?» ");
INSERT INTO cou_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu më ntëkwakëhni: «Kwëtëryin hakili, ant'aw̃aw̃u arokayiwu. Vahnë vëyaɓah njijëɗëni mëcani uw̃ac mën do ntehnëndëni vërëhnayik ye do wati ỹa tëkik, ɓare ant'arëfuni. ");
INSERT INTO cou_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ge nkwëryëɗun ga nësëɗe soŋe wamët nkal g'inkal, gë inkal inte ỹañënak, antë ntaku; afo watac tëki ten, ɓare geɗina tameki wapuya iỹi ɗuniỹa.» ");
INSERT INTO cou_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tac më nkwënëk: «Ɓulunda rëkëɗ mëtëndëni gë ɓulunda ỹëntaw̃, do ahnaw̃ pëgwëɗëha ahnaw̃ aỹëntaw̃; ");
INSERT INTO cou_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nkeɗ iñënka nkal hnë waresiỹo wayaɓah, do g'inte ŋa. Nkeɗ fëna viỹë viỹaƴah ambin hna do vahnë va ntakëɗëhëhni ɗus. ");
INSERT INTO cou_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ɓare tëkahnind waŋi fop, pëlaɗerun, korotehnëɗerun, njëɗahnëɗerun soŋe ahitiŋiwu vacaliŋa hna do cëɗëɗerun. Wati rac njiryeryëɗerun hnë vëhnaw̃ do gë waguverëner soŋe lëmën. ");
INSERT INTO cou_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Awa wati rac nkeɗun waseɗe mën. ");
INSERT INTO cou_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kwëtaryin watac vankaf hna: ant'afëhwëtawu ile rëfëka ahnësu, ");
INSERT INTO cou_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kaɓi ami dënk njëɗaɗëmu hakili, vële ỹew̃ëku va, vëhoɗina nkwajëni. ");
INSERT INTO cou_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wëla vële hnagëku va dënk tokaɗënihu vëhitiŋ hna gë vële vankërun tere, wahnënk hun do gë wëlawo hun, vëryampo hnë w̃uhnë ndaw̃ëɗeni. ");
INSERT INTO cou_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vahnë va fop ñew̃ëɗënihu soŋe lëmën. ");
INSERT INTO cou_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ɓare wëla imul ndampo iɓë nkaf hun cëvëɗina.» ");
INSERT INTO cou_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ƴaw̃ënaryin: koyëna pehëtëɗun ntaw̃ary hun iŋa. ");
INSERT INTO cou_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu më nkwënëk ntehn: «Ante nuɗun Yerusalem ga kwërëɗëni wasoɗaɗe ŋa, njëtëɗun, wati rac, ɓiỹëɗina nihëɗe. ");
INSERT INTO cou_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Awa, vële yeɗ Yuɗe va tëfëka nkaryëni gë wahuŋ, vële yeɗ ɓambery Yerusalem va tëfëka ŋaw̃ëtani, do vële yeɗ wëhaỹ va tëfëlahna mëncini g'ankol. ");
INSERT INTO cou_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wafac wale korotehnëɗëhëhni W̃ënu ŋa vahnë va yeɗ, ile ntiyaɗ fop ile nësëk Vikerëh ỹa. ");
INSERT INTO cou_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mekëhni vësëval vëryonkah va gë vële yëw̃ëndëɗëhëhni vutah vuntëw̃ hni vahnë wafac warac! Horot sankaf yeɗ hn'iŋi nkal kaɓi ntavah W̃ënu ŋa cëliɗ hnë ɓulunda rac. ");
INSERT INTO cou_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gë sëlame ndaw̃ëɗeni, vëramp njoɗeni wayal hna fop. Vahnë vële wok vëyena wasëwif w̃a nihëɗëni Yerusalem hafo ante puɗ wati le maw̃ëryanini ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ulav hna, ulepera hna do gë wahol hna nuɗe wëdahëse gë viỹë vifëmpëhnahnah do nkal li wahnënk w̃i fop mpaỹëmpaỹaɗëhëhni do pëmpëhnahnëɗëhëhni ɗus soŋe wëñaw̃ gë fanka wavonkëlo w̃ënka ŋi. ");
INSERT INTO cou_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wati rac vahnë va cëmëɗëni ntakah ge nahani iỹaƴah ile ỹaɗ ntiya nkal ỹa. Pëƴaɗëmu, W̃ënu ŋa ñënkëɗ fop ile ye g'ambin ỹa. ");
INSERT INTO cou_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tac nuɗe Ajë Ahn'a ga tëkiɗ hn'aŋar, gë fanka do gë icëmb cankaf. ");
INSERT INTO cou_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ge vëỹin pëgwëk ntiyand, matëndaryin do ahaŋu, kaɓi pehët hun iŋa tëhajëk.» ");
INSERT INTO cou_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tac Yesu më njëɗahnëk iŋi mëntëndëlehn: «Ƴëkëryin anuỹ iŋi gë vatëh vañëntaw̃ vi fop: ");
INSERT INTO cou_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ge nurun ga pëgwëk nëpënd, njëtëɗun wati hasëk ỹa tëhajëk. ");
INSERT INTO cou_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ndampo fo nke, ge nurun vëỹin fop ga tëkiɗ, ƴëtëryin Naw̃ W̃ënu ŋa tëhajëk. ");
INSERT INTO cou_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Toña ỹa fëƴaɗëmu: vahnë vëvë gaki vi vësëmëɗina fop hara diyana vëỹin fop. ");
INSERT INTO cou_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ambin ŋi g'inkal iŋi goɗina, ɓare wanës mën ŋi nkoɗ kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Diryin wajira: ant'afaɓu li vambënt fo, g'uryëw̃, ma ahnahandu soŋe waɗëñah ỹi ɗuniỹa; ge gena umë, fac ile njihahniɗ Ajë Ahnë naŋëtëɗëhu, ");
INSERT INTO cou_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","had urënd: pëƴaɗëmu, pëlaɗëhëhni fop vële lëɗëk nkal vi. ");
INSERT INTO cou_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ant'ahnamawu! Ƴëfaryindën kwëlëkwël! Koyëna nuỹaɗun fanka ayaw̃ënahnu hnë fop ile rëkiɗ hna do aholu arufëhnawu haryënkw Ajë Ahnë hna.» ");
INSERT INTO cou_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","G'anent ga, Yesu karaŋëɗëhëhniwo vahnë va Cery W̃ën Cankaf hna, do g'anëka ga, hn'ikuŋ nte w̃acik Oliviye hna njiɗëho ndakind. ");
INSERT INTO cou_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Do ɓulunda ỹa fop koɓëri fo g'acahnëfëɗ ga njijëɗëniho Cery W̃ën Cankaf hna soŋe nëpandëniha. ");
INSERT INTO cou_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ambënt mburu kwëhn levir këm, ante w̃acaryik Pak ŋa fëna, tëhajëko. ");
INSERT INTO cou_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va njëkëlendëniho ndaw̃ehnëniha Yesu, ɓare ntakëkëhniwo gë ɓulunda ỹa antë ŋañënani. ");
INSERT INTO cou_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Awa Sintani tënkëkawo Yuɗa, nte w̃acëɗeho Isëkariyot ŋa, ale yentiko hnë vërëfal Pëhw gë Vëhi hna. ");
INSERT INTO cou_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuɗa njiko nësëlini gë vësankaf vësëna wasaɗëha va do gë vëvë karyënkw Cery W̃ën Cankaf va gante tëfëka njëɗahni Yesu ka. ");
INSERT INTO cou_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nëŋëkëhniwo ɗus do më ntehnëniha cosëɗëniha koryi. ");
INSERT INTO cou_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuɗa mawëlehn do pëgwëlehn njëkëlehnand fere fale rëfëka njëɗahnëhni Yesu hara ɓulunda ỹa vëyëtana. ");
INSERT INTO cou_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tëkiko wati ambënt mburu kwëhn levir këm ŋa do hale ndaw̃ëɗeni vupe soŋe roka Pak ỹa. ");
INSERT INTO cou_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Awa Yesu më paƴëkëhni Piyer gë San ntehnëhni: «Ƴiryin afëhwëtanëhnëhëndunëfu roka Pak ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Më ntëkwaniha: «Ne ñaɗu fëhwëtafu?» ");
INSERT INTO cou_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Më ntëkwakëhni: «Nëparyin: ge tëkërun naw̃ hna, nuɗunëha asan ale ryiɓëk unkwahn w̃ënka. Tëfëlehnëryina hafo tere hn'ile tënkëɗ hna. ");
INSERT INTO cou_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ntehnëɗunëha ale hwëhnëk tere ỹa: “Aharaŋ a tëƴëɗëhi: ‘Ne nke cery nte rokahnëɗëfun roka Pak ỹa gë vërëfal mën va?’” ");
INSERT INTO cou_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tufëɗëhu cery cankaf ƴaŋ etas hna g'ile valëɗëhu ỹa fop. Hnam pëhwëtaɗun soŋe roka ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Awa njilehnëni, tëkatëni fop gante ntehnëkëhniwo Yesu ka do pëhwëtani soŋe roka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wati ỹa, ga tëkëk, Yesu gë vëfaƴik vëlëw̃u va mbarëpëlëniho soŋe roka ỹa. ");
INSERT INTO cou_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Më ntehnëkëhni: «Ñaɗëfuho ɗus tokëlahnini ỹi roka Pak gë w̃uhnë ani gë horotahnëndu ỹa! ");
INSERT INTO cou_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Toña ỹa fëƴaɗëmu dol, ɓokëɗa roku muk iỹi roka hafo hale padëɗ nafa iỹi roka ŋa Naw̃ W̃ën hna.» ");
INSERT INTO cou_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Awa, më nufëk nkëlëw̃a uñen, camehnëka W̃ënu ŋa do ntehnëhni: «Nufëryin aŋi nkëlëw̃a, asehëlu w̃uhnë fop. ");
INSERT INTO cou_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pëƴaɗëmu, tëk pëgw iỹi wati, ɓokëɗa sewu uñen waresen hafo tëki Inaw̃ W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tac më mbok nufëk mburu, camehnëka W̃ënu ŋa, do më nkubëlehnëk njëɗahni ntehnëhni: «Iỹin mbahn mën ŋa ye nte yëɗahnik soŋe hun ŋa. Diryindën aki, aryënkwëtahnënduno.» ");
INSERT INTO cou_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ga tokëni, Yesu më mbok njëɗakëhni aŋi nkëlëw̃a ñen, do ntehnëhni: «Aŋi nkëlëw̃a ñen sat mën ile ryehëtëɗe soŋe lëw̃ hun ỹa ye do ỹabahnik kwëtëla kasëk nte ntik W̃ën ɓulunda lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ɓare nëparyin: ale rokaɗëho ỹa ani nke, tokëlandëɓun! ");
INSERT INTO cou_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ajë Ahn'a cëmëɗ gante pëhnak W̃ën ka ɓare ale rokaɗëha ỹa korotëɗ ɗus!» ");
INSERT INTO cou_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Awa pëgwëlehnëni tëƴëlëndëni bi mo ye hnë vëhni ale ỹaɗ nti rac a. ");
INSERT INTO cou_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tac vërëfal va pëgwëlehnëni nkwajëlëndëni njëtahnëni bi mo ye ale lëbëkëhni nafa vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Awa, Yesu më ntehnëkëhni: «Vëhnaw̃ vëvë ɗuniỹa vi ndëcëtëni cankaf ntëw̃ hni ŋa, do vële hwëhnak fanka ucankaf va mëcaɗëni “vëli fërën”. ");
INSERT INTO cou_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ɓare w̃uhnë, ant'aliwu had vëhni! Ale ỹak hnaỹëk a tëfëka nke had umë ỹak vak hnë w̃uhnë, do ale ryokuŋehnëɗëhëhni vëỹëntaw̃ va nke had aryokuŋ. ");
INSERT INTO cou_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Awa mo ye ale ñak njaɓëk nafa ỹa? Ale rokëɗ roka ỹi gë ale hnëhëtëɗ aỹi? Gena bi ale rokëɗ roka ỹi? Ha, ɓare ami had ale hnëhëtëɗ nkeɓu fagant lëw̃ hun! ");
INSERT INTO cou_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","W̃uhnë, g'ami nkentirunëho kwëlëkwël hn'uryëñah mën hna fop, ");
INSERT INTO cou_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","do gante njëɗako ucankaf rëm mën ki, koyëna njëɗaɗëmu ami fëna: ");
INSERT INTO cou_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tëkëɗena tokënden do celahnënden Naw̃ hna, do ntañaɗun hnë watinki vësankaf soŋe ahitiŋuni wahnënk pëhw gë wahi wavë Isërayel w̃i.» ");
INSERT INTO cou_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu më ntehnëka Simo Piyer: «Simo, Simo, nëpary: Sintani këlaka W̃ënu ŋa maw̃ëryana kolahn paryi gante paryëɗe pitëndëlehnahni vantimp gë vaparyel ki. ");
INSERT INTO cou_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɓare ami, muntanëmi, soŋe antë ntihëtaỹi kwëtahn iŋa kwëlëkwël. Do wëjë, ge mbokajëru gë ỹal mën ƴaw̃ënëryihni vëỹënta hu va.» ");
INSERT INTO cou_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer më ntëkwaka: «Ahwëhn, pëhwëtaɓu wëlakënde ntehni sëɗaryiwu gë wëjë do sëmëntiwu gë wëjë.» ");
INSERT INTO cou_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu më ntëkwaka: «Pëƴaɗëmi, Piyer, hnë uŋi mëɗ dënk, ani gë tarahnënd cale ŋa, njahëtaɗu wahwënta warar ƴëtëlihohna.» ");
INSERT INTO cou_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tac Yesu më ntehnëkëhni: «Ante paƴëmuno koryi këm, kufa këm, wapary wante hnëpëtandun këm ŋa, iñë bi wojëkuno?» Më ntëkwani: «Ñoñ gojëlëfunohna.» ");
INSERT INTO cou_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Awa më ntehnëkëhni: «Ɓare tame, ale hwëhnak koryi tëfëka nuf, ale hwëhnak kufa tëfëka nuf, do ale wok kwëhnana sëlame tëfëka nkwaf cuɗ cankaf ntëw̃u ŋa ntëw̃ahn ryampo. ");
INSERT INTO cou_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pëƴaɗëmu, afo ntiya ile nësëk Vikerëh soŋe lëmën ỹa. Më lehnëk: “Aw̃en ntiryaryëniha vahnë va.” Ha, soŋe lëmën ỹa ɓiỹëɗina, fop padëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Vërëfal va më ntehnëniha: «Ahwëhn, wëli wasëlame wahi.» Yesu më ntëkwakëhni: «Gwër nke.» ");
INSERT INTO cou_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu më cahnëk do nji hn'ikuŋ nte w̃acik Oliviye hna, gante njehëka ka. Vërëfal vëlëw̃u va më ntapëhnaniha. ");
INSERT INTO cou_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ga tëkëni hnam, më ntehnëkëhni: «Ƴëfaryin kwëlëkwël soŋe gante koɗun ayaw̃ënahnu ge njëkëhnahnëɗerun.» ");
INSERT INTO cou_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tac më ŋaw̃ëtakëhni toƴe, ndëkwëhnëk do njëfa aki: ");
INSERT INTO cou_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Apa, ge ñaɗu, ŋaw̃ëtënde antë tëkëhne iỹi horot. Ɓare ant'ali ile ỹaɗëfu, diry ile ỹaɗu wëjë ỹa.» ");
INSERT INTO cou_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Awa mëleka vë g'ambin ỹa cëlëlehni njij njaw̃ënaỹehna. ");
INSERT INTO cou_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nkwënëko njëfa ŋa g'ahaw̃ary kaɓi njiw̃ëhnëko ɗus hafo ŋacëŋac ntëw̃ ŋa nke had sat yatëɗ. ");
INSERT INTO cou_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ante puhnak njëfa ŋa, më matëk, mboka gë vërëfal vëlëw̃u do nji tëkatëhni ga ndakëni wakwëɗ, kaɓi njiw̃ëhnahnëkëhniwo ɗëcët g'umë. ");
INSERT INTO cou_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Më ntehnëkëhni: «Hak koɗun aryaku wakwëɗ? Matëryin ayëfawu soŋe gante koɗun ayaw̃ënawu ge njëkëhnahnëɗerun.» ");
INSERT INTO cou_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nkoko nësënd tëketëni kore vahnë. Yuɗa aryampo vërëfal Pëhw gë Vëhi hna ryënkwaryikëhniwo. Më tëhaka Yesu soŋe mbuca. ");
INSERT INTO cou_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɓare Yesu më ntehnëka: «Yuɗa, gante mbucëɗe ale hnëŋëlërun bi tokaɗuha Ajë Ahn'a?» ");
INSERT INTO cou_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vële tëfëlëniho Yesu va, ga nuni ile ỹaɗ ntiya ỹa, më tëƴëniha: «Ahwëhn, raw̃ahnëfu bi wasëlame fu w̃i?» ");
INSERT INTO cou_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Do aryampo hnë vëhni taw̃ëlehna aryokuŋ asëna wasaɗëha asankaf a ntëpëtëlehna nëf tëhw ŋi. ");
INSERT INTO cou_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ɓare Yesu më ntehnëk: «Tavëryin! Gwër nke.» Do më ñakëka asan arac nëf ŋa njërënëlehna. ");
INSERT INTO cou_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tac Yesu më ntehnëkëhni vësankaf vësëna va, vësankaf vëyëka Cery W̃ën Cankaf va, do gë vicër vële yijëko pëlaniha va: «Gë wasëlame do gë waryoko bi tëfakëha ayinëhniwuno, afëlawuno had bandi yeɓu? ");
INSERT INTO cou_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Fac-wo-fac Cery W̃ën Cankaf hna nkelahnëɗenëho do ƴëkëlehnëluhna afëlawuno, ɓare iỹi wati w̃uhnë hwëhnëk gë fanka umëhwëry fa, Sintani hwëhnëk.» ");
INSERT INTO cou_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Awa pëlalehnëniha Yesu njiryeryëniha ndënëniha tere asëna wasaɗëha asankaf hna. Piyer ŋaw̃ët tëfëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hwëɗëh fëɗiko fagant selele hna, Piyer ntañantëlehni gë vële yeraɗëho hnam va. ");
INSERT INTO cou_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Asëval aryokuŋ më nuka Piyer ga ntañantik ɗarël hwëɗëh hna; më ntaŋëka do ntehna: «Asan ale lañak aỹi gë Yesu nkentiko!» ");
INSERT INTO cou_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ɓare Piyer njahëtako ntehna: «Hali, ƴëtëlëw̃ahna.» ");
INSERT INTO cou_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ga mbiỹëk toƴe, ahnë ahaw̃ary më nuka do ntehn: «Wëjë fëna, arëfal Yesu yentiru!» Ɓare Piyer më ntëkwaka asan arac: «Hali, gena toña.» ");
INSERT INTO cou_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ga mbok mbiỹ, ahaw̃ary kat më mbok ntehnëgëk: «Lëk, aỹi asan gë Yesu nkentiko, kaɓi umë fëna avë Galile ye.» ");
INSERT INTO cou_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɓare Piyer më ntëkwak: «Ƴëtëla bi ye ỹaɗu ahnës, wëjë.» Ani gë patahnënd wanës ŋa dënk tarëlehn cale ŋa. ");
INSERT INTO cou_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ahwëhn a Yesu më cahëtak ntaŋëka Piyer. Awa Piyer ndënkwëtalehn ile ntehnëkawo Ahwëhn a: «Tarahnënd cale ŋa uŋi mëɗ njahëtaɗu wahwënta warar ƴëtëlihohna.» ");
INSERT INTO cou_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Awa Piyer cahnëlehn kond ɗus. ");
INSERT INTO cou_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vësan vële yëkaɗëhawo Yesu va pëgwëniho njafaŋëndëniha do ndafëndëniha. ");
INSERT INTO cou_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Më cankëniha yëka ỹi do tëƴëniha: «Awa, kaɓi kila yeru, pëƴaryifu bi mo ryafëki?» ");
INSERT INTO cou_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nkoniho njew̃ëndëniha wakaw̃ary waƴaɓah menahnëniha w̃ac. ");
INSERT INTO cou_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ga pacëk, vicër vëvë ɓulunda wasëwif va, vësankaf vësëna wasaɗëha va do gë vëharaŋ sariya va mbarëniho. Më ntehnëni njoji Yesu Mbara Vëhitiŋ vëlëw̃ hni hna, ");
INSERT INTO cou_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","do, ga tëkaryijik, më tëƴëniha: «Arëhnayik a bi yeru? Pëƴaryifu!» Yesu më ntëkwakëhni: «Ge pëƴamu njëtëɓu maw̃ëndilunohna, ");
INSERT INTO cou_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","do ge tëƴëmu iñë, dëkwaɗilunohna. ");
INSERT INTO cou_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ɓare, ƴëtëryin, tëk pëgw gaki Ajë Ahn'a ntañaɗ g'irëhw W̃ën Hwëhn Fanka Fop.» ");
INSERT INTO cou_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Vëhni fop ntehnëlehnëniha: «Awa wëjë ye Aju W̃ënu ŋa?» Më ntëkwakëhni: «W̃uhnë dënk hnësëk umë yeɓu.» ");
INSERT INTO cou_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Awa më ntehnëlëni: «Gona mbalëfu seɗe: nkwëryinëk fuhnë dënk wanës wadëw̃u ŋa!» ");
INSERT INTO cou_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tac matëlehnëni vëhni fop njiryeryëniha Yesu vëhni guverëner ile w̃aciko Pilat ỹa. ");
INSERT INTO cou_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hnam, pëgwëlehnëni mërahnëndëniha ntehnëndëni: «Tëkatëɓunëha aỹi asan ga përëkanëɗëhëhni ɓulunda lëw̃ fu ỹa: më lehnëkëhni antë cosëniha ahnaw̃ a, Sesar, ỹatëtanke ỹa do umë lehnëk fëna umë dënk ye Arëhnayik a, ahnaw̃ a.» ");
INSERT INTO cou_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Awa Pilat më tëƴëka: «Ahnaw̃ wasëwif w̃a bi yeru?» Yesu më ntëkwaka: «Wëjë hnësëk.» ");
INSERT INTO cou_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Awa Pilat më ntehnëkëhni vësankaf vësëna wasaɗëha va gë kore ỹa: «Nula w̃eh ile ntik aỹi asan.» ");
INSERT INTO cou_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɓare më njaw̃ënëni wanës wadëw̃ hni ŋa ntehnëni: «Përëkanëɗëhëhni ɓulunda ỹa gante koɗëni ŋañënahnëni g'ikaraŋ dëw̃u ŋa. Hnë resiỹo Galile hna pëgwik, ndapëlehni Yuɗe ỹi fop, tame njijëk hafo Yerusalem li.» ");
INSERT INTO cou_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat, ga nkwëryëk wanës watac, më tëƴëk: «Aỹi asan avë Galile bi ye?» ");
INSERT INTO cou_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ntëkwanihawo, ha, Yesu avë Galile ye. Resiỹo rac Eroɗ hnaw̃ëko. Awa kaɓi Eroɗ Yerusalem hna nkeho hnë wafac warac, Pilat më ntehnëk njiryeryi Yesu ỹalu hna. ");
INSERT INTO cou_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eroɗ natëkawo ɗus ante nukawo Yesu ŋa kaɓi nkwëryëɗëho ga nësëɗe soŋe lëw̃u ỹa do mbiỹëk ante ñaɗëho nuhna ŋa, ntiyahnëkawo nuɗëha ga ntiɗ dahëse fëmpëhnahnah. ");
INSERT INTO cou_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tëƴëkawo waƴaɓah, ɓare Yesu dëkwaɗilawohna ñoñ. ");
INSERT INTO cou_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vësankaf vësëna wasaɗëha va gë vëharaŋ sariya va hnam nkeniho mërandënihawo Yesu g'iŋañëna. ");
INSERT INTO cou_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tac Eroɗ gë wasoɗaɗe walëw̃u w̃a nëhandënihawo njafaŋatëndëniha Yesu. Më cuɗëniha viỹi vifërën had ahnaw̃ do Eroɗ mbokaryehnëkawo gë vëhni Pilat. ");
INSERT INTO cou_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eroɗ gë Pilat vëhnëŋëlëlohna koɓëri ŋa, ɓare fac rac, lawo nkeniho. ");
INSERT INTO cou_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat më mbarëkëhni vësankaf vësëna wasaɗëha va, vësankaf vëhitiŋ va do gë ɓulunda ỹa, ");
INSERT INTO cou_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","do ntehnëhni: «Njinenëhnirunëhow̃a aỹi asan alehnuno ɓulunda ỹa përëkanëɗ. Tëƴëɓuha tase lëw̃ hun do ñoñ nula nkeya meh ante lehnërun ntik ŋa. ");
INSERT INTO cou_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eroɗ fëna ñoñ nuna ile menëk, kaɓi mbokënanikëfuna. Awa pacëk, aỹi asan ñoñ dina ile rëfëka ndaw̃ahni. ");
INSERT INTO cou_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ntampendëɓuha tac ravëlehnëw̃a.»  ");
INSERT INTO cou_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hn'ambënt Pak-wo, gante nkeho namu lëw̃ hni ka, Pilat tëfëkawo tavëhnëhni aramp aryampo. ");
INSERT INTO cou_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɓare pëgwëlehnëni ndekandëni vëhni fop ndampo fo: «Ɗaw̃ehnëɗehn aỹi asan! Tavëhnëryifuna Barabas!» ");
INSERT INTO cou_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tac, hnë vahnë vële ỹañënako hna nkentiko hafo daw̃i ahnë. Soŋe rac cëɗahniko. ");
INSERT INTO cou_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kaɓi Pilat ñaɗëho tava Yesu, më mbok tëƴëkëhni kat. ");
INSERT INTO cou_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ɓare vahnë va ndekaɗëniho: «Pakëryehna hnë kërëwa, pakëryehna hnë kërëwa!» ");
INSERT INTO cou_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat më mbok teɓak wanës ŋa rarëna ỹa do ntehnëhni: «Aỹi asan, uweh hwëhn ye ntik? Ñoñ nula hnë umë ile rëfëka ndaw̃ahni. Ntampehnëɗëfuha tac do gë ravëw̃a.» ");
INSERT INTO cou_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ɓare nkoniho ndekandëni gë fanka Yesu paki hnë kërëwa, do waɗeka wadëw̃ hni ŋa mëkëkawo Pilat: ");
INSERT INTO cou_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","më pëhnak maw̃ëhnëhni ile tëƴëɗëni ỹa. ");
INSERT INTO cou_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Më tavëka asan ale tëƴëɗëniho ỹa, ale sëɗiko soŋe ryaw̃ ahnë ante ŋañënaniho ŋa, do njëɗahni wasoɗaɗe w̃a Yesu soŋe ntiniha gante ñaɗëni ka. ");
INSERT INTO cou_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ante njiryeryëɗënihawo Yesu ŋa, pankëlëniho gë Simo, asan avë Siren. Wehaỹ mënciɗëho. Wasoɗaɗe w̃a më pëlaniha ndiɓëndëniha kërëwa ỹa tëfaryinda Yesu kamëhni. ");
INSERT INTO cou_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kore sankaf rëfëɗëhawo Yesu, gë vësëval vële hoɗëho do yahnaɗëho soŋe lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Më cahëtahnëkëhni do ntehnëhni: «Vësëval vëvë Yerusalem, antë ahonëhnuno! Koryin soŋe lëw̃un gë vutah hun ");
INSERT INTO cou_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","kaɓi wati yejëk ile lehnëɗe: “Mbetani vësëval vële wok vëhnagëɗina va, wok koɓëri vëhnagëna do wok koɓëri vëyëw̃ëndëna va!” ");
INSERT INTO cou_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Awa vahnë va rëkëɗ ntehnëndëni wahuŋ w̃i: “Ƴohahninëfu!” Do gë vukuŋ vi: “Cow̃ëryinëfu!” ");
INSERT INTO cou_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pëƴaɗëmu, ge aki ntiyik atëh cëkah ŋa, hak lë ntiɗe kankah ŋa?» ");
INSERT INTO cou_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Njoryaryinihëhniwo fëna vësan vëhi, vëw̃en, soŋe ndaw̃aryini gë Yesu. ");
INSERT INTO cou_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ante tëkëniho hn'ile macik «Kuŋ Hëloƴoƴ» hna wasoɗaɗe w̃a pakënihawo Yesu kërëwa hna do pakaryënihëhniwo fëna wabandi waki, aryampo g'irëhw lëw̃u, aỹëntaw̃ a g'irahahn. ");
INSERT INTO cou_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Awa Yesu më ntehnëk: «Apa, tavëhnëryihni, kaɓi vëyëtëna ile ntiɗëni.» Tac wasoɗaɗe w̃a njëlëniho wanjël njëtahnëni bi mo hwëhnëɗ cuɗ Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓulunda ỹa hnam nkeniho njëkëndënihawo. Vësankaf wasëwif va njafaŋëɗënihawo ntehnëndëni: «Pehëtëkëhni vahnë vëhaw̃ary; ge paryi ale tëhnak W̃ën ỹa ye, pehëta umë dënk!» ");
INSERT INTO cou_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wasoɗaɗe w̃a fëna njafaŋëɗënihawo, tëhaɗënihawo njelëhnëndëniha uñen ŋañah ");
INSERT INTO cou_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","do ntehnëɗënihawo: «Ge paryi ahnaw̃ wasëwif ỹa yeru pehëtary wëjë dënk!» ");
INSERT INTO cou_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Awa ƴaŋ lëw̃u ỹa, iỹin heriko: «Aỹi ye Ahnaw̃ Wasëwif w̃a.» ");
INSERT INTO cou_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aw̃en aryampo ale fakaryiko ỹa më njew̃ëka ntehna: «Gelihna bi Arëhnayik a? Pehëtary wëjë dënk do afehëtaryëfu!» ");
INSERT INTO cou_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɓare aỹëntaw̃ a më ŋañënahnëka ntehna: «Dakëlinahna dënk bi W̃ënu ŋa wëjë ale sëmëɗ hnë kërëwa ndampo fo g'umë? ");
INSERT INTO cou_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Fuhnë iỹin caŋëkëfu, kaɓi ile liyik ỹa sosikëfu, ɓare umë ñoñ dina w̃eh.» ");
INSERT INTO cou_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tac më nkwënëk: «Yesu, ɗënkwëtarye ante nkeɗu ahnaw̃ ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmi: dol g'ami nkeɗe araƴen hna.» ");
INSERT INTO cou_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nkëhnëko tëk lav a nkaf li do kuyëko taŋ: kuyëko nkal hna fop hafo hnë wëwati warar g'anent hna. Wati rac dënk, ipand ɗëndah, inte fokiko haryënkw ỹëw̃a le ỹak sëvak Cery W̃ën Cankaf hna, citako fagant. ");
INSERT INTO cou_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu më ndekak gë fanka: «Apa, kwëtehnahnëmi ntaw̃ary mën iŋa.» Ante nësëk waŋi ŋa, cëmëlehn. ");
INSERT INTO cou_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kapiten le yeho hnam ỹa, ga nuk ile liyak ỹa, më cëmbëka W̃ënu ŋa do ntehn: «Paryi nke, aỹi asan catëko!» ");
INSERT INTO cou_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kore le yijëko njantini ile ye ỹa, nuniho ile liyako ỹa. Awa mbokalehnëni gë ỹal hni g'uyiw̃ëhnah sankaf. ");
INSERT INTO cou_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wëlawo Yesu w̃a fop, gë vësëval vële lapëhnajëkawo koɓëri Galile va, ŋaw̃ët ñëw̃ëniho njëkatëndëni ile ryëcëtaɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Asan ale w̃aciko Yosef yeho hnam. Avë nkol wasëwif nte w̃acik Arimasi yeho. Ahitiŋ yentiko umë fëna, kitiŋa wasëwif cankaf hna. Përënako do catëko do napëɗëho Naw̃ W̃ënu ŋa. Maw̃ëlohna ile pëhnaniho vëhitiŋ do ntiniho ỹa. ");
INSERT INTO cou_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Njiko vëhni Pilat hna do tëƴa iñas Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tac më cëlëndëk ñas iŋa kërëwa hna, përyëk hn'iƴarëh do ndën hn'iƴag nte yabiko hn'ikuŋ, iƴag kasëk. ");
INSERT INTO cou_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Araƴima yeho do fac ntaw̃ëla ŋa pëgw ŋa nkeho. ");
INSERT INTO cou_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vësëval vële lapëhnajëkawo Yesu koɓëri Galile va njintiniho gë Yosef, do njëkëniho ƴag iŋa nuniho gante kwëtiko iñas Yesu ka. ");
INSERT INTO cou_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tac mbokalehnëni g'ankol pëhwëtëni wagu gë ɗatikola soŋe ñas iŋa. Fac ntaw̃ëla hna, më njinëgani gante ntehnëk sariya Moyis ka. ");
INSERT INTO cou_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gë dimasi ỹa wakëwak fo vësëval va g'iƴag njiryeryëɗëniho wagu wante liyik ɗatikola ile pëhwëtëniho ỹa. ");
INSERT INTO cou_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Umë tëkatëni taka cankaf ŋa këryiŋëtiko cape ndampo ƴag iŋa piɗëtako. ");
INSERT INTO cou_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tënkëlehnëni, ɓare vërëkatëlohna iñas Ahwëhn a Yesu. ");
INSERT INTO cou_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Vëyëtëlohna ile nahaɗëni. Paco tëkëlehnini vësan vëhi vële liyako viỹi vile yerëko had ambin wilëbilëk. ");
INSERT INTO cou_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vësëval va ntakëkëhniwo më ndëkwëhnëni wayëka w̃a nkal hna. Vësan va më ntehnënihëhni: «Soŋe ye yëkëlehnëɗunëha hnë vësëm ale wok cëmëna? ");
INSERT INTO cou_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gena ani, mbëhnëk. Ɗënkwëtaryin ile nësëhnëkuno ante nkoko hnë resiỹo Galile hna: ");
INSERT INTO cou_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","afo Ajë Ahn'a njëɗayiniha vëw̃en va, paki hnë kërëwa do fac rarëna hna mbëhnëɗ.» ");
INSERT INTO cou_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tac ndënkwëtalehnëni wanës Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vësëval va cahnëlehnëni ƴag hna njini pëƴanihëhni watac fop vërëfal pëhw g'aryaw̃ va gë vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mari mbë Magëdala yeho gë Yowana do gë Mari, hnëmu Sak do vësëval vëhaw̃ary vële njiniho va fop tëfëtanënihëhniwo watac vëfaƴik va. ");
INSERT INTO cou_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vërac ntiyahnëkëhniwo vësëval vi ki fo nësarëɗëni, do vëhwëtahnëliwohna. ");
INSERT INTO cou_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ɓare Piyer matëko nkary g'iƴag. Ga tëkëk më nkuryak, ɓare ñoñ nulohna ge gena ile përyahniko ñas ŋa fo woko hnam. Tac mëncëlehn gë ỹalu afëmpëhnahnah fo soŋe ile liyak ỹa. ");
INSERT INTO cou_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Fac rac dënk, vërëfal vëhi yiɗëho hn'ankol nte w̃acik Emawus. Soŋe wawati wahi yasëɗu arëkarënd hnam ge matëru Yerusalem. ");
INSERT INTO cou_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Soŋe wade ryëcëtak ŋa fop nësëlëɗëniho. ");
INSERT INTO cou_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wati nte nësëlëɗëniho do nkwajëlëndëniho ŋa Yesu më tëhajëkëhni tëfëlëntik gë vëhni. ");
INSERT INTO cou_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nuɗënihawo, ɓare iñë w̃emaỹendëhëhniwo njavëtëniha. ");
INSERT INTO cou_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu më tëƴëkëhni: «Ye wajëlëɗun ayasatëndu?» Umë kahnëni do njamëlehnëni g'uhaỹëhnah w̃a. ");
INSERT INTO cou_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aryampo hnë vëhni, Këlewopas maciko, më ntëkwaka: «Wëjë fo bi ye ale yijëk Yerusalem li do wok ƴëtëna ile liyak ỹa hnë waỹi wafac?» ");
INSERT INTO cou_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu më tëƴëkëhni: «Ye liyak?» Umë ntëkwaniha: «Ile yeha Yesu mbë Nasaret ỹa liyak. Kila hwëhn fanka yeho: ntik viỹë vifëmpëhnahnah do wanës wadëw̃u ŋa kwëhnako fanka haryënkw W̃ën hna gë ɓulunda ỹa fop. ");
INSERT INTO cou_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vësankaf vësëna wasaɗëha fu va gë vëvë karyënkw ɓulunda va njëɗahnëniha soŋe kitiŋi ndaw̃i do pakëniha hnë kërëwa. ");
INSERT INTO cou_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Fuhnë kwëtahnëɓunëho umë ye ale rëfëkawo pehëtëhni vëvë Isërayel va hnë vële ỹew̃ëkëhni hna, do kat gë watac fop, dol nke fac rarëna ỹa ga cëmahnëk. ");
INSERT INTO cou_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɓare g'umë fop nkeni vësëval vëryampo vëvë kore fu va fëmpëhnahnëndanëkëfu ɗus. Wakëwak ỹa dol njikëni ƴag hna ");
INSERT INTO cou_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɓare vërëkatëna ñas dëw̃u ŋa. Më mbokajëni pëƴahnëni wamëleka sankëtahnakëhëhni do pëƴanihëhni mbëhnëk. ");
INSERT INTO cou_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vërëfëlënta fu vëryampo njikëni ƴag hna do tëkatëni fop gante nësakëni vësëval ka, do vëhni fëna vëhnuna ñas Yesu ŋa.» ");
INSERT INTO cou_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Awa Yesu më ntekëhni: «E w̃uhnë, vële wok kwëhnaluhna hakili, do wasakahn hun w̃a ƴancëna kwëtahn ile pëƴahnëni wakila ŋa! ");
INSERT INTO cou_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tëfëlawohna bi korot aki Arëhnayik a tënkahnënd icëmb dëw̃u hna?» ");
INSERT INTO cou_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tac më nkabëkëhni ile herik Vikerëh vipacah hna fop soŋe lëw̃u ỹa, pëgw vëkayëte Moyis hna do gë vëkayëte wakila wañëntaw̃ hna fop. ");
INSERT INTO cou_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ante tëhaniho nkol nte njihahnëɗëniho ŋa, Yesu më ntik had ñaɗ ndëcal. ");
INSERT INTO cou_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ɓare ŋwëỹëryanihawo ntehnëniha: «Gontëryi gë fuhnë! Lav a ƴo ŋa nke.» Awa tënkëntëlehni nkol hna nkonti gë vëhni. ");
INSERT INTO cou_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ga kwërani hn'ile tokëɗe roka hna, Yesu nufëk mburu ŋa, camehna W̃ënu ŋa, tac nkubëlehnëk, njëɗahni. ");
INSERT INTO cou_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Awa ile w̃emaỹendëhëhniwo njavëtëniha Yesu ỹa ntihëtiniho njavëtëlehnëniha taŋ, ɓare njavëtëndëniha tuŋ nambëlehnëniha. ");
INSERT INTO cou_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Umë ntehnëlëni: «Gena bi njamakëhëfu sakahn fu w̃a ante nësëhnakëndëhëfu nkaw̃ hna do pacënëhnatëndëfu Vikerëh va?» ");
INSERT INTO cou_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Matëlehnëni taŋ mbokani Yerusalem. Më tëkatënihëhni vërëfal pëhw g'aryaw̃ va ga mbarëni gë vërëfëlënta hni va, ");
INSERT INTO cou_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ntehnënihëhniwo vërëfal vëhi va: «Paryi nke Ahwëhn a mbëhnëk! Simo nuka!» ");
INSERT INTO cou_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Do vëhni fëna më tëfëtanëhninihëhni ile yekëhëhni nkaw̃ ỹa do gante njavëtahnënihawo Yesu ka wati nte nkubëlehnëɗëho mburu ŋa. ");
INSERT INTO cou_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nkoniho nësëndëni tëket taŋ Yesu fagant lëw̃ hni do ntehnëhni: «Araɓi ƴam ỹa nke gë w̃uhnë!» ");
INSERT INTO cou_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Umë mbalëni do ntakëhni ɗus: ntiyahnëkëhniwo ƴine nuni. ");
INSERT INTO cou_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu më tëƴëkëhni: «Soŋe ye valërun? Soŋe ye wajëlehnaɗun? ");
INSERT INTO cou_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ƴëkëryin wëɓák mën ŋi gë wapary mën ŋi: paryi ami ye! Ñakëryino ayëku: ƴine kwëhnana imbahn gë waỹëc, ɓare ami kwëhnaɓu, nurun!» ");
INSERT INTO cou_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ante nësëhnëkëhni watac ŋa, më tufëkëhni wëɓák ŋa gë wapary wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vërëfal va natëkëhniwo do pëmpëhnahnëhni ɗus, vëw̃ëkëlohna ten kwëtahnëni. Awa Yesu më tëƴëkëhni: «Kwëhnarun bi hnani ile rokëɗe?» ");
INSERT INTO cou_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Më njëɗaniha nkubel igis ɓëlik. ");
INSERT INTO cou_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Më teɓaka do cema tase lëw̃ hni. ");
INSERT INTO cou_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tac mbok ntehnëhni: «Gena bi, ante nkolahninëko ŋa, pëƴaɗëmuno: ile herik soŋe mën sariya Moyis hna, vëkayëte wakila hna do gë Wahnëw̃ hna, watac fop tëfëkawo ntiya.» ");
INSERT INTO cou_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Awa Yesu më piɗëtëkëhni wahakili w̃a nkwëryahnëni Vikerëh vipacah va. ");
INSERT INTO cou_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Do më ntehnëkëhni: «Wëlin ile herik ỹa: Arëhnayik a tëfëka korot, tac fac rarëna hna mbëhnëɗ, ");
INSERT INTO cou_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","do tëfëka karaŋini vahnë va g'uw̃ac lëw̃u w̃a ɗuniỹa li fop, pëgw Yerusalem: ntehnëɗeni vahnë va nkwëcëtani vankeya va do soŋe W̃ënu ŋa tavëhnahnëhni wameh ŋa. ");
INSERT INTO cou_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Waseɗe soŋe watac fop yerun. ");
INSERT INTO cou_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Do ami njëɗanahniɗëmu ile ntehnëk rëm mën njëɗahnëɗ ỹa, Iƴir Ipacah iŋa ye. Awa goryin naw̃ li hafo pëɓënu fanka lëw̃u fa.» ");
INSERT INTO cou_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tac Yesu më cahnaryëkëhni vërëfal va naw̃ hna, njiryeryëhni ɗarël Betani. Hnam umë njelëk wëɓák ŋa g'ambin do ndëwakëhni. ");
INSERT INTO cou_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wati nte ndëwanëɗëhëhniwo ŋa, pitël iŋa pitëlëɗëniho gë vëhni kaƴ g'ambin ɗarël W̃ën hna. ");
INSERT INTO cou_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vëhni, cëmbënihawo do mbokalehnëni Yerusalem, vëhnatah fo. ");
INSERT INTO cou_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hnam, Cery W̃ën Cankaf hna nkeɗëniho kwëlëkwël do cëmbëndëniha W̃ënu ŋa.");
INSERT INTO cou_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wapëgwa hna, ale ye Wanës ŋa tëko nke. Gë W̃ënu ŋa nkeniho, do W̃ënu ŋa yeho umë dënk. ");
INSERT INTO cou_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ha, umë wapëgwa hna gë W̃ënu ŋa nkeniho. ");
INSERT INTO cou_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","W̃ënu ŋa g'umë ntik le-wo-le ỹa; ñoñ diyina hnë vile liyik hna fop hamëhni lëw̃u. ");
INSERT INTO cou_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hnë umë nkeho uwám paryi w̃a, uwám urac yeho humpen vahnë ŋa. ");
INSERT INTO cou_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Humpen ha pëtëɗ hn'umëhwëry hna, do mëhwëry uŋa ɗipehnëlahna. ");
INSERT INTO cou_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cahnëko asan ale paƴiko W̃ënu ŋa, San Ayary a maciko. ");
INSERT INTO cou_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Njijëko soŋe nke seɗe humpen ha, do gë ceɗeya ntëw̃u ŋa vahnë va fop nkwëryahnëni do kwëtahnahnëni. ");
INSERT INTO cou_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gena umë dënk yeho humpen ha, ɓare nke seɗe humpen paƴijiko. ");
INSERT INTO cou_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huŋi humpen yeho humpen paryi ha, hunte yijëɗ ɗuniỹa li pena ale-wo-le ỹa. ");
INSERT INTO cou_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Umë, hnë ɗuniỹa li tëko nke, do g'umë ntiyiko ɗuniỹa ỹi, ɓare ɗuniỹa ỹi ƴavëtëlahna. ");
INSERT INTO cou_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Njijëk hnë ɓulunda lëw̃u hna, ɓare ɓulunda lëw̃u ỹa vëhacalahna. ");
INSERT INTO cou_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ɓare ale-wo-le hacaka do hwëtahnëka ỹa njëɗaka imëk nke fatah W̃ën. ");
INSERT INTO cou_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gena ile nagini hn'iɗonk asëval, ma g'iña ahnë ỹi, ɓare kaɓi W̃ënu ŋa likëhni nkeni vërahu. ");
INSERT INTO cou_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wanës ŋa mbacako ahnë do gë fuhnë ntëɗëntiko. Ipërëna ŋa njaɓëkawo gë toña ỹa. Njavëtëɓun inaỹ dëw̃u ŋa, inaỹ nte nuỹak kaɓi Ajë Ryamboli Rëm ỹa ye. ");
INSERT INTO cou_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","San ceɗeya ntëw̃u hna pëƴahnëko ɓulunda hna: «Wëliho ale hnësëndëmuno ante ntehnëɗëfuho: ale rëfiɗëho ỹa ndënkwëhniko kaɓi rëko nke yehahnëndu ami ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuỹaɓun fop hn'iƴaɓ kaỹëhnahn dëw̃u hna viỹë vifërën do vifërën kat. ");
INSERT INTO cou_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ha, W̃ënu ŋa vëhni Moyis tëfaryëk njëɗafu sariya ỹa, do kaỹëhnahn iŋa gë toña fadah ỹa vëhni Yesu Këris padënëk W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wëla aryampo nulahna W̃ënu ŋa, ge gena Ajë Ryamboli, ale ye W̃ënu ŋa fëna. Umë ye ɗarël Rëm hna do njëtëndanëkëfuna. ");
INSERT INTO cou_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Vësankaf wasëwif va Yerusalem hna paƴinihëhniwo vësëna wasaɗëha va, gë Walevi w̃a, soŋe njini tëƴëniha San bi mo nke. Wëlin ceɗeya ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Më ntëkwakëhni tase vahnë fop hara ñoñ cow̃ëlëhniwohna: «Gela Arëhnayik a.» ");
INSERT INTO cou_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Më mbok tëƴëniha: «Awa mo yeru? Eli bi yeru?» Më ntëkwakëhni: «Hali, gela Eli.» Më mbok tëƴëniha: «Kila ỹa bi yeru?» Më mbok ntëkwakëhni: «Hali.» ");
INSERT INTO cou_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Awa më tëƴëniha: «Mo lë yeru? Afo yifu hnësëhnëfuni vële faƴikëfu va iñë. Wëjë, mo yeru lehnëru?» ");
INSERT INTO cou_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Më ntëkwak: «Ami ye “ale nësahnëɗ kila le w̃acik Esayi ryekaɗ wula hna: ‘dinëhnëryina vankaw̃ vacatah ɗus Ahwëhn a!’”» ");
INSERT INTO cou_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nkentiniho wafarise hnë vële faƴiko vëhni San va. ");
INSERT INTO cou_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Më mbok tëƴëniha kat: «Ge gelihna Arëhnayik a, Eli, ma Kila ỹa, awa soŋe ye yaryëɗuhëhni vahnë va?» ");
INSERT INTO cou_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Më ntëkwakëhni: «Ami, gë w̃ënka njaryëɗëfu, ɓare nkehëhna hnë w̃uhnë ale worun ƴëtëluhna nafa lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Umë rëfiɗëho, ɓare catëla dënk fëtahnu viỹëba wapary wadëw̃u va.» ");
INSERT INTO cou_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Watac fop Betani le ye ɗarël sën Yurëdan hna ntiyako, hn'ile njaryëɗëhëhniwo San vahnë hna. ");
INSERT INTO cou_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ga pacëk, San më nuka Yesu ga njijëɗ gë ỹalu, më ntehnëk: «Wëliho Fape W̃ën fante lihëtëɗ wameh ɗuniỹa fa. ");
INSERT INTO cou_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Soŋe lëw̃u ỹa hnësëndëmuno ante ntehnëɗëfuho: “Asan rëfiɗëho, umë lëbëko kaɓi umë yeho rëkahnindu ỹa.” ");
INSERT INTO cou_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ami fëna ƴëtëlëwohna, ɓare ge njijëɓu yaryëndu gë w̃ënka, soŋe liwu njëtëniha ɓulunda Isërayel ỹa ye.» ");
INSERT INTO cou_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","San më mbok ntehnëk kat: «Nuɓu Iƴir W̃ënu ŋa ga cëliɗ g'ambin had fah njij ntëɗ hnë umë. ");
INSERT INTO cou_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ƴëtëlëw̃ohna ten bi mo ye, ɓare W̃ënu ŋa sañëtiko yaryëndu gë w̃ënka, umë lehnëkowo: “Nuɗu Iƴir iŋa ga cëliɗ do njij hnë asan; umë rëkëɗ njaryënd g'Iƴir Ipacah iŋa.”» ");
INSERT INTO cou_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","San më nkwënëk: «Nuɓu rac do seɗe yeɓu: aỹi asan Aju W̃ënu ŋa ye.» ");
INSERT INTO cou_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ga pacëk, San hnam fo nkoko, gë vëhi hnë vërëfal vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Më nuka Yesu ga ndëcëɗ, më ntehnëk: «Wëliho Fape W̃ën fa!» ");
INSERT INTO cou_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vërëfal vëhi va, ga nkwëryëni wanës San watac, më tëfëlehnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Umë më cahëtak do nuhni ga tëfëlehnëɗëniha, më ntehnëkëhni: «Ye ỹaɗun?» Më ntëkwani: «Rabi, (umë fëhnëtanëɗ Aharaŋ), ne ntëɗëru?» ");
INSERT INTO cou_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Më ntëkwakëhni: «Ƴijën, nuɗun.» Awa njilehnëni do nuni hn'ile ntëɗëk hna. Nkëhnëko tëk wawati wahnah g'anent do g'umë ñëw̃ëlahnëniho hn'ile wojëko hnë fac ỹa. ");
INSERT INTO cou_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aryampo hnë vërëfal vëhi San vërac, Andëre yeho, aheryu Simo Piyer. ");
INSERT INTO cou_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Më njik ten vëhni acëru Simo hna do ntehna: «Nuɓunëha Arëhnayik a.» Umë ye fëna Këris ỹa. ");
INSERT INTO cou_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Do njolehna hn'ile nke Yesu hna. Yesu më njëkëka gë yasery do ntehna: «Simo aju San yeru. Awa Sefas rëkëɗeru aw̃acënde.» Umë fëhnëtanëɗ «Piyer» gë wanës wagërek ŋa. (Umë ye «Itaka»). ");
INSERT INTO cou_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ga pacëk, Yesu pëhnako nji Galile. Më nuka asan ale w̃aciko Filip do ntehna: «Tëfe!» ");
INSERT INTO cou_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Awa Filip tac nkol ndampo fo nkeniho gë vëhni Andëre gë Piyer. Betësayida maciko. ");
INSERT INTO cou_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip, umë fëna, më njik tëkata asan ale w̃aciko Natanayel do ntehna: «Nuɓunëha ale ntehnëɗëho Moyis hnë kayëte sariya hna, do wakila ŋa fëna pëƴahnëni soŋe lëw̃u ỹa. Yesu ye, aju Yosef, mbë nkol Nasaret ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel më ntëkwaka: «Mbë Nasaret? Iñë fërën koɗ bi mati Nasaret?» Filip më ntëkwaka: «Ƴij, nuɗu wëjë dënk.» ");
INSERT INTO cou_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu, ga nuka Natanayel ga njijëɗ, më ntehnëk: «Wëliho avë Isërayel paryi ỹa, asan ahwëhn wamër këm ye.» ");
INSERT INTO cou_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel më tëƴëka: «Hak njëtahnëruho?» Yesu më ntëkwaka: «Ani gë macahnëndi Filip ỹa, ante nkeku kuyët anuỹ ŋa, nukëmi.» ");
INSERT INTO cou_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Awa Natanayel më ntëkwaka: «Wëjë, Aharaŋ, wëjë ye Aju W̃ënu ŋa, ahnaw̃ vëvë Isërayel va!» ");
INSERT INTO cou_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu më ntëkwaka: «Ile lehnëmi nukëmi kuyët anuỹ ŋi bi hwëtahnantuho? Nuɗu viỹë vifëmpëhnahnah ntëbi viỹë!» ");
INSERT INTO cou_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Do më nkwënëk: «Toña ỹa fëƴaɗëmu: nuɗun ambin ŋa ga piɗëtak do wamëleka W̃ënu ŋa ga kaƴëndëni do cëlindëni gë fere Ajë Ahn'a!» ");
INSERT INTO cou_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Fac rarëna hna, ambënt iñël yeho nkol Kana, resiỹo Galile hna. Hnëmu Yesu hnam nkentiko. ");
INSERT INTO cou_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu fëna paƴehnaryiniho iñël tac gë vërëfal vëlëw̃u va do njintiniho. ");
INSERT INTO cou_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hara uñen uŋa pëgwëko pund. Awa, hnëmu Yesu më ntehnëka: «Vëworyaryëna uñen.» ");
INSERT INTO cou_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu më ntëkwaka: «Asëval, ye ye yëbëlan fu? Wati mën ile lihandëɓu iñë ỹa tëkëna ten.» ");
INSERT INTO cou_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Awa hnëmu më ntehnëkëhni vëryokuŋ vële yeho hnam va: «Diryin fop ile ntehnëɗëhu ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nkeho hnam vunkwahn wëraka mbëɗ g'undaw̃ vunte taw̃ahnëɗëniho wasëwif w̃a w̃ënka, wante ñuhnandëni gante nke namu lëw̃ hni ka. Koɗëho taw̃ yëbëlan walitër wafëhw imbëɗ gë warar (80) ma keme gë wafëhw wahi (120). ");
INSERT INTO cou_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu më ntehnëkëhni vëryokuŋ va: «Tëmpënëryin hnë vuŋi vunkwahn w̃ënka.» Do më taw̃ëni hafo wafiw̃ hna. ");
INSERT INTO cou_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Awa Yesu më ntehnëkëhni: «Tame ñëryëryin, ayinehnuna ale sahëlenda.» Më ntini koyëna. ");
INSERT INTO cou_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Arac më njëkëk do wëli w̃ënka ŋa mbacako uñen. Ƴëtëlohna bi ne matik uŋi ñen, hara vëryokuŋ va njëtëniho, kaɓi vëhni ỹiryëko w̃ënka ŋa. Taŋ më macehnëka ale ỹëlëɗëho ỹa ");
INSERT INTO cou_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","do ntehna: «Vahnë va fop uñen nte ỹak fërënak ŋa cehëlehnëɗëni ten, do ge vahnë va ndëw̃ëni, tac do gë yëɗayini unte wok përënana ɗus ŋa. Ɓare wëjë, kwëtëru unte ỹak fërënak ŋa hafo iỹi wati! Caŋëk!» ");
INSERT INTO cou_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Koyëna ntiko Yesu dahëse fëmpëhnahnah ryënkwëryënkw ỹa. Watac Kana mbë Galile hna ntiyako. Koyëna tufahnëko inaỹ dëw̃u ŋa do vërëfal vëlëw̃u va kwëtahnënihawo g'ahaw̃ary. ");
INSERT INTO cou_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ga ndëcëk watac, Yesu më njini Kaperënaỹum gë hnëmu, gë vëheryu, do gë vërëfal vëlëw̃u va, ɓare wafac fo ñëw̃ëlahnëniho hnam. ");
INSERT INTO cou_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wati le ntihandëni wasëwif ambënt Pak ŋa rëhajëko do Yesu më njik gë Yerusalem. ");
INSERT INTO cou_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tëkatëkëhniwo selele Cery W̃ën Cankaf hna vëwaf wuhni, gë wape, gë wëfah do gë vëwëcët koryi vële ryokuŋëɗëho wataɓali wadëw̃ hni hna. ");
INSERT INTO cou_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Awa Yesu më nufëk ryeƴët, nti wus, do ntahni fop selele Cery W̃ën Cankaf hna, gë wape ŋa, do gë wuhni w̃a, do pat wataɓali vëwëcët koryi va hafo koryi ỹa campëlehn. ");
INSERT INTO cou_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tac ntehnëhni vëwaf wëfah va: «Dihëtëryin iỹin fop ani! Cery Rëm mën ŋa ye. Ɓok aliwu cery vëwaf!» ");
INSERT INTO cou_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Awa vërëfal va ndënkwëtalehnëni waŋi wanës Vikerëh: «Iña inte hwëhnaɓu soŋe Cery hu ŋa, E W̃ën, iña tac nke hnë ami përëkanëɗëho gante përëkanëɗëha uñen ahnë ka.» ");
INSERT INTO cou_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Awa vësankaf wasëwif va më tëƴëniha Yesu: «Iỹëhne dahëse fëmpëhnahnah hoɗu ali arufahnëfu kwëhnaru fanka alihahnënd aki?» ");
INSERT INTO cou_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu më ntëkwakëhni: «Këfëryin aŋa Cery W̃ën, do hnë wafac warar, mbokaryëɗëfu w̃atëndu.» ");
INSERT INTO cou_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Më ntehnëniha: «Wabëhn wafëhw wahnah g'imbëɗ g'iryaw̃ (46) vëryëɓun aŋ'acery, ɓare wëjë hnë wafac warar mbëryëɗu?» ");
INSERT INTO cou_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ɓare «Cery W̃ën», nte nësëɗëho Yesu ŋa, imbahn dëw̃u ŋa dënk yeho. ");
INSERT INTO cou_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ga mbiỹëk, ante matëko Yesu vësëm hna, vërëfal vëlëw̃u va ndënkwëtaniho nësëko watac, do kwëtahnëniho Vikerëh va do gë wanës wante nësëko Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ante nkeho Yesu Yerusalem ŋa, hnë wati ambënt Pak hna, vahnë vëyaɓah kwëtahnënihawo kaɓi nuniho wëdahëse wapëmpëhnahnah wante ntiɗëho ŋa. ");
INSERT INTO cou_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ɓare Yesu pacahnëlawohna gë vëhni, kaɓi njëtëkëhniwo ɗus vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ahnë koɗilohna njëtëndana iñë ile nkok ƴëtëna kaɓi njëtëko ile yehëhna vintaw̃ary vahnë ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hnë wafac warac, nkeho hnam asan ale w̃aciko Nikodem; asankaf wasëwif yeho do farise yeho. ");
INSERT INTO cou_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Asan arac yiko hn'umëɗ ndampo tëkata Yesu do ntehna: «Aharaŋ, njëtëɓun W̃ënu ŋa faƴiki ayij aharaŋëfu kaɓi ahnë koɗina nti wëdahëse wapëmpëhnahnah gë wante liɗu ki ge W̃ënu ŋa gena gë umë.» ");
INSERT INTO cou_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmi: ahnë koɗina nu Naw̃ W̃ënu ŋa ge nagina g'ahaw̃ary.» ");
INSERT INTO cou_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem më tëƴëka: «Hak koɗe nagi ahnë g'ahaw̃ary ge tëk cër? Koɗ bi mboka ɗonk hnëmu hna do mbok nagi higëna?» ");
INSERT INTO cou_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu më ntëkwaka: «Toña ỹa fëƴaɗëmi: ahnë koɗina tënk Naw̃ W̃ën hna ge nagina hnë w̃ënka do hn'Iƴir Ipacah hna. ");
INSERT INTO cou_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ale nagëk ahnë, ahnë ye. Ale hnagik hn'Iƴir Ipacah hna, iƴir ye. ");
INSERT INTO cou_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Awa antë pëmpëhnahni ge ntehnëmi: “Tëfëku ahnagiwu g'ahaw̃ary w̃uhnë fop.” ");
INSERT INTO cou_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sël ỹa cëlëɗ cape nte ñaɗ hna, nkwëryëɗu wëñaw̃ wadëw̃u ŋa, ɓare ƴëtëɗila bi ne matiɗ, ma bi ne njiɗ. Koyëna nke soŋe fop vële hnagëɗe hn'Iƴir Ipacah va.» ");
INSERT INTO cou_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem më mbok tëƴëk: «Hak koɗ nke watac?» ");
INSERT INTO cou_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu më ntëkwaka: «Wëjë ye ale haraŋëɗëhëhni ɓulunda Isërayel ỹa, do ƴëtëlihna waŋi? ");
INSERT INTO cou_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Toña ỹa fëƴaɗëmi: ile yëtëɓun hnësëɗëfun. Ha, waseɗe ile hnuɓun yeɓun, ɓare maw̃ëɗiluhna uceɗeya ntëw̃ fu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ge nësëndëmu viỹë vile ye nkal vi do kwëtandiluhna hak koɗun ahwëtahnu ge nësëɗëfu viỹë vile ye g'ambin va? ");
INSERT INTO cou_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ahnë kaƴëna g'ambin. Ami fo, Ajë Ahn'a, sëlik hatac! ");
INSERT INTO cou_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hnë wula hna, Moyis pakëkawo ƴaŋ hnë rëh lën ryëhwëra ỹa. Do koyëna njelëɗ Ajë Ahn'a fëna ");
INSERT INTO cou_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","soŋe fop vële hwëtahnëɗëha va tënkëni taŋ hnë uwám ule wok puɗina hna. ");
INSERT INTO cou_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Ha, W̃ënu ŋa ŋahnëkëhni ɗus vahnë vëvë ɗuniỹa hafo njëɗahna had saɗëha Ajë ryamboli lëw̃u ỹi, ɗanko vële hwëtahnëɗëha va antë tënkëni muk janáma ɓare nuỹani taŋ uwám ule wok puɗina. ");
INSERT INTO cou_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","W̃ënu ŋa paƴilahna Aju ɗuniỹa li soŋe piniŋëhni vahnë vëvë ɗuniỹa vi, ɓare paƴika soŋe pehëtini g'umë. ");
INSERT INTO cou_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ale hwëtahnëka Aju W̃ënu ŋa piniŋëɗena; ɓare ale wok kwëtahnëlahna ỹa tëk kitiŋi piniŋëɗe, kaɓi kwëtahnëlahna ryamboli W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Do wëli soŋe ile piniŋand W̃ënu ŋa: humpen ha njijëk ɗuniỹa li, ɓare vahnë va umëhwëry fecehnëkëhni, kaɓi vankeya vantëw̃ hni va ƴivëna. ");
INSERT INTO cou_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ale liɗ wameh a ñew̃ëk humpen ha do ŋaw̃ëtak, kaɓi ntakëka antë nuyi nkeya meh ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɓare ale w̃aw̃ëhnëk toña ỹa, umë njijëɗ humpen hna, nuhahni wapacëk nkeya përën ntëw̃u nte ntiɗ gë fanka W̃ënu fa.» ");
INSERT INTO cou_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ga ndëcëk wafac, Yesu gë vërëfal vëlëw̃u va matëniho naw̃ Yerusalem hna njini njasëlehnëni resiỹo Yuɗe hna; wafac fo ñëwëlahnëniho hnam gë vëhni do njaryëɗëhëhniwo vahnë va. ");
INSERT INTO cou_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","San, umë fëna, Enon hna njaryëɗëhëhniwo, ɗarël Salim hna. Hnam njaɓëko w̃ënka ŋa, do vahnë vëyaɓah njijëɗëniho njaryëndeni. ");
INSERT INTO cou_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wati rac, San cëɗilohna ten. ");
INSERT INTO cou_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Awa vërëfal San vëryampo pëgwëlehnëni conkëndëni gë sëwif ryampo soŋe namu ipacëna ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Njilehnëni tëkatëniha San do ntehnëniha: «Aharaŋ, ndënkwëtaɗuha bi asan ale yerunëho gë cape ñëntaw̃ sën Yurëdan ka, ale yenëhnëruho seɗe ỹa? Tame njaryëɗ do vahnë va fop gë ỹalu njiɗëni!» ");
INSERT INTO cou_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","San më ntëkwakëhni: «W̃ënu ŋa fo hoɗ nti nke koyëna soŋe ahnë. ");
INSERT INTO cou_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Waseɗe yerun w̃uhnë dënk soŋe ile hnësëɗëfuho ỹa: “Gela Arëhnayik a, ɓare paƴijiɓu haryënkw lëw̃u.” ");
INSERT INTO cou_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","«Asëval ale yëlika, asanu ỹa hwëhnëka. Ge lawo asan a ye, umë kahnëɗ ɗarël lëw̃u do nëpanda; kopa lëw̃u ỹa natëndanëɗëha ɗus. Koyëna nke uhnatah lëmën w̃a soŋe Yesu ỹa: padëko! ");
INSERT INTO cou_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Umë rëfëka nkwënënda nafa ỹa, do ami ŋaỹëtando.» ");
INSERT INTO cou_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ale w̃atik g'ambin a, umë sëpëkëhni vahnë va fop. Ale ye ɗuniỹa li, ɗuniỹa ỹi hwëhnëka do vëỹi vëvë ɗuniỹa vi nësëɗ. Ɓare umë, ale w̃atik g'ambin a, umë sëpëkëhni vahnë vëvë ɗuniỹa vi fop. ");
INSERT INTO cou_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Seɗe ile nkwëryëk g'ile nuk ye, ɓare ahnë maw̃ëɗina ceɗeya ntëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ge ahnë w̃aw̃ëk ceɗeya ntëw̃u ŋa, tufahnëɗ maw̃ëk W̃ënu ŋa toña nësëɗ. ");
INSERT INTO cou_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Paryi nke, ale paƴik W̃ënu ŋa wanës W̃ënu ŋa dënk nësëɗ, kaɓi W̃ënu ŋa pëɓënëɗëha ɗus Iƴir dëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Rëm ỹa ñaɗëha Aju ỹa do njëɗaɗëha fanka fayaɓah hnë ile-wo-le hna. ");
INSERT INTO cou_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ale hwëtahnëka Ajë Ahn'a tëk tënk uwám ule wok puɗina hna: ale w̃ëỹëk kwëtandilahna ỹa tënkëɗina, W̃ënu ŋa nkoɗ ntava g'umë.» ");
INSERT INTO cou_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wafarise w̃a nkwëryëniho, ga nësëɗe Yesu ntiɗëhëhniwo vahnë va vërëfal do njaryëɗëhëhniwo ntëbi San. ");
INSERT INTO cou_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ɓare ile ye toña ỹa, Yesu umë dënk ƴaryëɗilohna; vërëfal vëlëw̃u va yaryëɗëhëhniwo.) Ante njëtako Yesu watac ŋa, ");
INSERT INTO cou_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","më matëk Yuɗe hna do mboka Galile. ");
INSERT INTO cou_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Awa tëfëkawo tëf resiỹo Samari hna. ");
INSERT INTO cou_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Më tëkëk ɗarël hnë fankol fante w̃acik Sikar nte wok ŋaw̃ëlëna g'ikaỹ nte njëɗakawo Sakob aju Yosef ŋa. ");
INSERT INTO cou_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hnam nkeho kolomba Sakob ỹa. Yesu, mbërako uyas w̃a, më ntañak tëfary kolomba hna. Lav a nkëhnëko tëk nkaf hna. ");
INSERT INTO cou_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wati nte ntañako hnam ŋa, asëval avë Samari më njijëk ỹëry w̃ënka. (Hara vërëfal Yesu va g'inaw̃ njiniho ntëw̃ajëni ile tokëɗëni.) Awa, Yesu më ntehnëka: «Ƴëɗërye siyaw̃.» ");
INSERT INTO cou_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Asëval a më ntehnëka Yesu: «Ɓare wëjë, sëwif yeru do ami, avë Samari yeɓu! Hak ndëkëru awa arëƴo asiya?» Ntehnëkawo koyëna kaɓi wasëwif w̃a kehaɗënihëhniw̃o vëvë Samari va. ");
INSERT INTO cou_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu më ntëkwaka: «Ge njëtakëndu ile ñaɗ njëɗi W̃ënu ŋa, do bi mo ye ale w̃untaɗëhi w̃ënka ciya ỹi, wëjë w̃untakëndëha do njëɗakëndëhi w̃ënka wante yëɗand sël ntaw̃ary paryi ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Asëval a më ntëkwak: «Ɓare wëjë, kwëhnalihna ỹirya do kolomba ỹi tëw̃ëk! Ne ñëryiɗu w̃ënka hu ŋi? ");
INSERT INTO cou_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ntiyahnëki bi wëjë lëbëka rëm fu ỹa Sakob? Umë yabëhnëkëfu iỹi kolomba; cek umë dënk. Vërahu do gë wusaw̃ wulëw̃u w̃a fëna ceni.» ");
INSERT INTO cou_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu më mbok ntehnëka: «Ale seɗ waŋi w̃ënka ỹa mbokëɗ njohna kat, ");
INSERT INTO cou_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ɓare ale sek w̃ënka wante yëɗaɗëfuha ŋa ɓokëɗina njohna muk kaɓi w̃ënka wante yëɗaɗëfuha ŋa mbacaɗ hnë umë haƴalin hante wok tëryaɗina, yalëɗ do yoɗëha hafo uwám ule wok puɗina muk.» ");
INSERT INTO cou_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Asëval a më ntehnëka: «Awa, ƴëɗërye w̃ënka watac soŋe antë mbok njow̃o do antë voku yiju hnani ỹëry w̃ënka.» ");
INSERT INTO cou_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu më ntehnëka: «Ƴinëndehna asan hu.» ");
INSERT INTO cou_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Asëval a më ntëkwaka: «Ñëlila.» Do Yesu më ntehnëka: «Ha, ile hnësëru ỹi, koyëna nke: ");
INSERT INTO cou_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vësan imbëɗ ỹëlëkino, do asan ale yerun gaki ỹi gena asan hu. Toña ỹa hnësëru.» ");
INSERT INTO cou_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Asëval a më ntehnëka: «Njavëtëɓu kila yeru. ");
INSERT INTO cou_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pëƴarye: mo hwëhnak toña? Warëm fu w̃a hn'iŋi kuŋ cëmbëɗënihawo W̃ënu ŋa, ɓare w̃uhnë, wasëwif w̃i, w̃uhnë lehnëk Yerusalem tëfëka cëmbi.» ");
INSERT INTO cou_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu më ntëkwaka: «Kwëtahnërye, wati yejëk, ge cëmbëɗe Rëm ỹa, kwëhnaɗina nafa cëmbi hn'iŋi kuŋ ma Yerusalem. ");
INSERT INTO cou_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","W̃uhnë, ntehnërun W̃ënu ŋa sëmbëɗun ɓare ƴëtëlunahna. Fuhnë, njëtëɓunëha, kaɓi Afehët a hnë ɓulunda wasëwif hna nkejëk. ");
INSERT INTO cou_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ɓare wati yejëk, do tëk tëki, hn'ile rëkëɗ cëmbëndëniha vësëmb paryi va Rëm ỹa g'Iƴir iŋa do gë toña ỹa. Rëm ỹa, vahnë vële sëmbëɗëha koyëna va njëkëlehnëɗ. ");
INSERT INTO cou_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","W̃ënu ŋa iƴir ye do vële sëmbëɗëha va tëfëka cëmbëndëniha g'Iƴir iŋa do gë toña ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Asëval a më ntehnëka: «Njëtëɓu, Arëhnayik, ale w̃acëɗe Këris ỹa, njijëɗ. Ge njijëk, nkabëɗëhëfu fop.» ");
INSERT INTO cou_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu më ntëkwaka: «Ami dënk ye.» ");
INSERT INTO cou_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wati rac, vërëfal va mbokalehnini. Pëmpëhnahnëkëhniwo ɗus ante nunihawo Yesu ga nësëlëɗëni g'asëval a. Ɓare wëla aryampo hnë vëhni ɗëkëlohna tëƴa bi ye ñaɗ ma bi soŋe ye nësëlëɗëni g'asëval aỹi. ");
INSERT INTO cou_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Awa asëval a tavëlehn hnam unkwahn uŋa, mboka g'ankol, do pëgwëlehn pëƴahnënd: ");
INSERT INTO cou_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ƴijën ayëkuna asan ale fëƴako fop ile liɓu ỹa. Mpëd koɗ nke Arëhnayik a?» ");
INSERT INTO cou_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Awa, vahnë va cahnëlehnëni naw̃ hna njini hn'ile nkeho Yesu hna. ");
INSERT INTO cou_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hnë wati rac vërëfal va ndëñanënihawo Yesu, ntehnëndëniha: «Aharaŋ, tokëry iñë!» ");
INSERT INTO cou_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ɓare më ntëkwakëhni: «Kwëhnaɓu roka ile worun ƴëtëluhna.» ");
INSERT INTO cou_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Awa vërëfal va tëƴëlëɗëniho bi ahnë yonëhnika ile tokëɗ. ");
INSERT INTO cou_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu më ntehnëkëhni: «Roka mën ỹa, liwu iña ale faƴiko ỹa ye do ryokuŋu hafo fadënu ile kwëtehnahnëko ỹa. ");
INSERT INTO cou_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gena bi ntehnëɗun: “Ani gë wadepera wahnah ɓarëp roka ỹa yeɗ”? Awa ami ntehnëɗëmu, ƴëkëryinëhni ɗus vahnë va caharaɓ lëw̃un: had kaỹ dafah tëk nkeni do napëɗëni mbarëpini! ");
INSERT INTO cou_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ale varëpëɗa nuỹaɗ tame icos dëw̃u ŋa do mbarëpëɗëhëhni vahnë va soŋe uwám ule wok puɗina ỹa; koyëna, ale hnaɗëɗ a g'ale varëpëɗ a natëɗëhëhni ndampo fo. ");
INSERT INTO cou_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Waŋi wanës, toña ye: “Ahnë naɗëɗ, ahaw̃ary mbarëp.” ");
INSERT INTO cou_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Paƴëmu avarëpu hn'ikaỹ nte worun ɗokuŋëluhna. Vëhaw̃ary ryokuŋëk do w̃uhnë hnuỹak nafa ɗoku lëw̃ hni ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vëvë Samari vëyaɓah kwëtahnënihawo Yesu kaɓi asëval a pëƴakëhniwo: «Ile liɓu ỹa fop pëƴako.» ");
INSERT INTO cou_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Soŋe umë ye, ante tëkëniho vëvë Samari va hn'ile nkeho Yesu hna, muntanihawo nkonti gë vëhni, do wafac wahi ntintiko hnam. ");
INSERT INTO cou_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Soŋe wante nësëndëhëhniwo umë dënk ŋa, vële hwëtahnëka va nkwënaniho iƴaɓ iŋa; ");
INSERT INTO cou_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","do ntehnënihawo asëval a: «Kwëtahnëɓun, gena soŋe ile hnësëhnëruhëfu ỹi fo, ɓare kaɓi nkwëryëɓunëha fuhnë dënk do njëtëɓun tame paryi nke Afehët ɗuniỹa ỹa ye.» ");
INSERT INTO cou_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ga ntik wafac wahi warac hnam, Yesu më mbokak gë Galile. ");
INSERT INTO cou_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Umë dënk hnësëko: «Kila dënënëɗena hn'inkal nte nagahnik hna.» ");
INSERT INTO cou_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɓare wati nte tëkëko Galile ŋa, vahnë va fop kacanihawo, kaɓi vëhni fëna njintiniho ambënt Pak ŋa gë Yerusalem, do nuniho fop vifëmpëhnahnah vile ntiko hn'ambënt tac va. ");
INSERT INTO cou_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu mbokalehn tëf Kana vë Galile hna, hn'ile mbacëko w̃ënka uñen hna. Hara, nkeho hnam asankaf ale tesaryëko aju ỹa ɗus Kaperënaỹum hna. ");
INSERT INTO cou_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ga njëtak asan arac Yesu matiko Yuɗe hna mboka Galile, më njik hn'ile nkeho hna do këlahna nji njërënëhna aju, ale ỹaɗëho cëm a. ");
INSERT INTO cou_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu më ntehnëka: «W̃uhnë, ŋwëyëɗun kwëtahnëɗiluhna ge nuluhna wëdahëse gë vifëmpëhnahnah!» ");
INSERT INTO cou_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɓare asankaf a më ntëkwaka: «Ahwëhn, ƴij ñap ani gë cëmahnënd fatah mën fa.» ");
INSERT INTO cou_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu më ntehnëka: «Mëncëry gë ỹal hu, ajë hu njërëk.» Asan arac më kwëtahnëk wanës Yesu ŋa do mëncëlehn. ");
INSERT INTO cou_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hn'ankaw̃ mënc hna, vëryokuŋ vëlëw̃u va njijëɗëniho pankëlëni do pëƴaniha: «Ajë hu njërëk!» ");
INSERT INTO cou_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Më tëƴëkëhni bi iỹëhne wati pecekawo. Më ntëkwaniha: «Ỹëhno nke hnë wati ryampo g'anent hna tavëkawo ures huji ha.» ");
INSERT INTO cou_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Awa Rëm ỹa kamahnëko aju njërëko hnë wati le ntehnahnëkawo Yesu hna dënk: «Ajë hu njërëk». Koɓëri tac kwëtahnënihawo Yesu, umë gë vëvë tere lëw̃u va fop. ");
INSERT INTO cou_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dahëse fëmpëhnahnah rac yeho higëna ile ntiko Yesu ỹa, ante matëko Yuɗe mboka Galile ŋa. ");
INSERT INTO cou_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ga ndëcëk watac, Yesu njiko Yerusalem soŋe njanti ambënt wasëwif ŋa. ");
INSERT INTO cou_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hara, hn'inaw̃ tac, ɗarël rënka le w̃acëɗeho Rënka Wape ŋa, nkeho kosa le hwëhnako vinder vicankaf imbëɗ; Betësata macëɗeho gë wanës Wa-ebëre ŋa. ");
INSERT INTO cou_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kuyët vinder vitac, kore vëres ryakëko hnam: vumëp, gë vële raɗëɗ, do gë vële ye vorovoro. W̃ënka ŋa napëɗëniho ñënka: ");
INSERT INTO cou_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","mëleka ryampo Ahwëhn a lëbaɗëho hnë pisin rac wati wati do ñënkëɗëho w̃ënka ŋa. W̃ënka ŋa, ge ñënkako, ale-wo-le ryënkwëɗëho ntëba ỹa, njërëɗëho ures lëw̃u w̃a gante-wo-gante tesëko ka. ");
INSERT INTO cou_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nkentiko hnam asan ale resëko koɓëri wabëhn wafëhw warar g'imbëɗ gë warar (38). ");
INSERT INTO cou_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu nukawo ga ndakëk; njëtëko mbiỹëk ga nkeho koyëna, më tëƴëka: «Ñaɗu bi ayërëni?» ");
INSERT INTO cou_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aresa më ntëkwaka: «Aharaŋ, ge pëgwëk ñënkand w̃ënka ŋa, kwëhnala ale labëɗëho. Wati nte rëkëɗëfu yawërëndu yiwu ŋa, ahaw̃ary ryënkwëndëho ntëba.» ");
INSERT INTO cou_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu më ntehnëka: «Awa, matëry, ahnuf uway hu w̃a ayas.» ");
INSERT INTO cou_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hnë wati rac taŋ, asan a njërënëlehni. Më nufëk way lëw̃u w̃a njasënd. Watac hnë fac ntaw̃ëla ntiyako. ");
INSERT INTO cou_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Awa vësankaf wasëwif va më ntehnëniha asan ale yërëniko takan ỹa: «Ntaw̃ëla ŋa ye, tëfëlahna ayo uway hu w̃i.» ");
INSERT INTO cou_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Më ntëkwakëhni: «Ale yërënëko ỹa më lehnëko hnufu uway mën w̃i do yasu.» ");
INSERT INTO cou_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Awa më tëƴëniha: «Mo lehnëki koyëna?» ");
INSERT INTO cou_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ɓare asan ale yërëniko ỹa ƴëtëlohna bi mo yërënëka, do koɗilohna tufahna kaɓi Yesu tënkëkëhniwo kore ile yeho hnam ỹa. ");
INSERT INTO cou_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ga mbiỹëk toƴe, Yesu më nuka asan a Cery W̃ën Cankaf hna, më ntehnëka: «Wëlin njërëniru. Tame diry hakili ant'avoka w̃en, soŋe ant'ahnuỹa ures ule lëbëk ule yërëniru w̃i.» ");
INSERT INTO cou_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tac asan a më njik pëƴakëhni vësankaf wasëwif va Yesu yërënëka. ");
INSERT INTO cou_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Awa vësankaf wasëwif va pëgwëlehnëni nësëɗëni wameh soŋe Yesu kaɓi hnë fac ntaw̃ëla njërënëkawo ahnë. ");
INSERT INTO cou_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu më ntëkwakëhni: «Rëm mën ỹa ɗoku hna nke hafo gaki, ami fëna tëfëko yewu ɗoku hna.» ");
INSERT INTO cou_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Soŋe wanës watac kat, vësankaf wasëwif va njëkëlehnëɗëniho g'ahaw̃ary fere fale ndaw̃ehnahnëniha Yesu. Gena soŋe ile ntik ile mbañëk sariya lëw̃ hni ỹi fo, ɓare mboko ntehn kat W̃ënu ŋa ye Rëmu paryi ỹa do koyëna këñëndëlehnaɗëho gë W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu më mbok ntehnëkëhni vësankaf wasëwif va: «Toña ỹa fëƴaɗëmu: Aj'a ñoñ koɗina nti umë fo; ile nuɗ ntiɗ Rëmu ỹa fo koɗ nti. Ile-wo-le ntiɗ Rëm ỹa, Aj'a fëna ntiɗ, ");
INSERT INTO cou_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kaɓi Rëm ỹa ñaɗëha Aju ỹa do tufëɗëha fop ile ntiɗ umë dënk ỹa. Tufëɗëha nti waɗoku wanaỹah wante worun koɓëri nuluhna do pëmpëhnahnëɗëhu w̃uhnë fop. ");
INSERT INTO cou_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gante mbëhnëndanëɗëhëhni Rëm vësëm ki, koyëna Aju, umë fëna, mbëhnëndanëɗëhëhni vële ñaɗ va. ");
INSERT INTO cou_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Do kat, gena Rëm ỹa hitiŋëɗëhëhni vahnë va; Aju ỹa njëɗak ucankaf kitiŋ ŋa fop, ");
INSERT INTO cou_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","soŋe vahnë va fop ntënënahnëndëniha Aju gante ntënënëɗëniha Rëm ka. Ale wok dënënëlahna Aj'a, dënënëlahna Rëm le faƴika ỹa. ");
INSERT INTO cou_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Toña ỹa fëƴaɗëmu: ale hnëpaɗ wanës mën ŋa, do kwëtahna ale faƴiko ỹa, tëk nuỹa iỹi wati uwám usër w̃a do W̃ënu ŋa kitiŋëɗilahna; gona hn'ankaw̃ ante yoɗ hnë icëm ŋa ɓare hn'ankaw̃ nte yoɗ ambin hna nke. ");
INSERT INTO cou_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Toña ỹa fëƴaɗëmu: Wati yejëk, do tëk tëki hnani, ile nkwëryëɗëni vësëm va, kopa Aju W̃ënu ŋa, do fop vële wëryëɗëha va hn'ankaw̃ nte yoɗ uwám usër hna nkeni. ");
INSERT INTO cou_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndampo fo nke, gante nke Rëm haƴalin sël ntaw̃ary, uwám paryi ki, koyëna njëɗaka Aju fëna nke haƴalin uwám rac. ");
INSERT INTO cou_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Do kaɓi Ajë Ahn'a ye, njëɗaka fanka kitiŋahnëndëhni vahnë va fop. ");
INSERT INTO cou_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Antë pëmpëhnahnu: wati yejëk ile nkwëryëɗëni fop vësëm va kopa Ajë Ahn'a ");
INSERT INTO cou_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","do mbëhnëɗëni: vële lik fërën va mbëhnëɗëni soŋe tënkëni hnë uwám usër hna, ɓare vële lik wameh va mbëhnëɗëni soŋe cëɗini janáma hna. ");
INSERT INTO cou_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Soŋe lëmën ỹa ñoñ koɗa liwu ami dënk; gante nkabëko Rëm ka fo kitiŋëɗëhëfu, do kiti mën ỹa catëk, kaɓi ƴëkëlehnëɗa liwu ile ỹaɗëfu ami dënk, ɓare liwu ile ñaɗ Rëm mën le faƴiko ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu më mbok ntehnëk: «Ge ami fo rëkakënd hnësandu soŋe lëmën ỹa, wanës mën ŋa kwëhnakëndina nafa. ");
INSERT INTO cou_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɓare kwëhnaɓuha seɗe haw̃ary ale hnësëndëho, Rëm mën ỹa ye, do paryi pëƴaɗëmu wanës wadëw̃u ŋa toña ye. ");
INSERT INTO cou_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Paƴërunëhëhni vahnë njini pëcëtajëni vëhni San hna do nësëhnëkëhniwo ile ye toña ỹa. ");
INSERT INTO cou_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Toña ye, ami, ɓalëlohna g'ahnë nkenëhno seɗe, ɓare nësëɗëfu watac soŋe w̃uhnë, afehëtahniwu. ");
INSERT INTO cou_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ha, San paryi had lampu fëɗik nkeho pëtënahn; do w̃uhnë, wëwati toƴe fo w̃aw̃ërunëho natu hnë humpen hudëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Do ami, kwëhnaɓuha seɗe le lëbëka nafa San: umë ye liwu ile ntehnëko Rëm mën liwu hafo pad ỹa ye. Ha, ile liɗëfu ỹi rufahnëɗ wapacëk Rëm ỹa faƴiko. ");
INSERT INTO cou_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Do kat, Rëm mën le faƴiko ỹi dënk, nkenëhnëko seɗe. Ɓare koɓëri gwëryëluhna kopa lëw̃u ỹa, ma ahnuwu yëka lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kwëtahnëlunahna ale paƴik ỹa; umë rufahnëɗ wanës wadëw̃u ŋa gena hnë w̃uhnë. ");
INSERT INTO cou_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Karaŋëɗun gë hakili Vikerëh va, kaɓi ntiyahnëku nuỹaɗun hnam uwám ule wok puɗina. Hara, vitac ye vinte hnësëɗ soŋe mën va! ");
INSERT INTO cou_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ɓare wëli: ñaɗiluhna ayiju ỹal mën hna. Awa nuỹaɗiluhna uwám ule wok puɗina w̃a. ");
INSERT INTO cou_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ƴëkëlehnëla cëkwaryëniho vahnë. ");
INSERT INTO cou_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ha, njëtëmu: kwëhnaluhna iña W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","G'uw̃ac Rëm mën w̃a njijëɓu, do kacaɗilunohna. Ɓare ge ahaw̃ary yijëk g'uw̃ac lëw̃u w̃a dënk, kacaɗunëha! ");
INSERT INTO cou_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ñaɗun asëkwaryëlëndu, do ƴëkëlehnëɗiluhna icëkwary inte w̃atik hnë W̃ën huɗampo hna. Awa, hak lë koɗun ahwëtahnuno? ");
INSERT INTO cou_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Antë ntiyahnu ami fëƴahnëɗ ile w̃enërun haryënkw Rëm mën hna; Moyis hwëtahnërun ɓare umë fëƴahnëɗ. ");
INSERT INTO cou_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ge paryi kwëtahnakëndunëhawo, kwëtahnakëndunëho ami fëna, kaɓi soŋe lëmën ỹa nësëk hnë kayëte ntëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ge kwëtahnëluhna ile kerëk ỹa, awa hak koɗun ahwëtahnu wanës mën ŋa?» ");
INSERT INTO cou_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ga ndëcëk watac, Yesu më ndanëk gë cape ñëntaw̃ lant Galile ka, (lant rac w̃acëɗe fëna Tiberiyad). ");
INSERT INTO cou_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kore yaɓah rëfëlendëhawo, kaɓi nuniho wëdahëse wapëmpëhnahnah wante ntiɗëho njërënahnëndëhni vëres ŋa. ");
INSERT INTO cou_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Soŋe rac njihahnëniho Yesu gë vërëfal vëlëw̃u va kaƴëni hn'ikuŋ ntañani hnam. ");
INSERT INTO cou_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pak ỹa, ambënt wasëwif ŋa, tëhajëko. ");
INSERT INTO cou_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu njëkalehnëko caharaɓ lëw̃u do nuhni kore yaɓah ga njijëɗëni ỹalu hna. Awa më tëƴëka Filip: «Ne koɗen ntaw̃ijin vamburu vajaɓah soŋe ndavahninëhni vëỹi vahnë fop?» ");
INSERT INTO cou_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tëƴëkawo koyëna soŋe njëkëhnahna Filip, ɓare, toña ỹa, tëko njët ile ntiɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip më ntëkwaka: «Wëla gë koryi yaɓah ɗëcët, geɗilëfuhna gwër ntaw̃ahnin vamburu vante koɗ ale-wo-le nuỹa fantëpëtel fatoƴ.» ");
INSERT INTO cou_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Arëfal ahaw̃ary, Andëre, aheryu Simo Piyer, më ntehnëka: ");
INSERT INTO cou_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Fatah facan yehëhna ani fante hwëhnak vamburu mbëɗ g'uwis wuhi. Ɓare yega nëfaɗëhëhni kore yaɓah gë iỹi ki?» ");
INSERT INTO cou_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Awa Yesu më ntehnëk: «Dehnëryinëhni vahnë vi fop ntañani.» Dël iŋa njaɓëko hnam do kore ỹa ntañalehnëni nkal hna. Vësan vële yeho hnam va nkëhnëko tëkëni wawuli mbëɗ (5,000). ");
INSERT INTO cou_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Awa Yesu më nufëk vamburu va, camehna W̃ënu ŋa, tac cahëlehnëhni vële lañako nkal va. Njëɗakëhniwo fëna wuwis w̃a, gante ñaɗëni ka. ");
INSERT INTO cou_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ga tokëni hafo pihnëni, Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Ɓarëpëryin vankubel vante wok va, soŋe antë përëka ñoñ.» ");
INSERT INTO cou_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Më mbarëpëni pëɓ vëkankel pëhw gë vaki vankubel vamburu mbëɗ vante rokiko va. ");
INSERT INTO cou_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ante nuniho vëỹi vahnë dahëse fëmpëhnahnah rac ile ntiko Yesu ỹi, më ntehnëni: «Paryi nke, aỹi asan ye kila ile rëfëkawo njij ɗuniỹa ỹa!» ");
INSERT INTO cou_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ɓare Yesu njëtako njijëɗëni nufëniha forosima soŋe ntiniha ahnaw̃, awa më mbok pitak kat umë fo nji g'ikuŋ. ");
INSERT INTO cou_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ante nëkak ŋa, vërëfal Yesu va më cëpëtani gë lant. ");
INSERT INTO cou_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kaƴëni hnë kulu pëgwëlehnëni ndanëtandëni gë cape Kaperënaỹum. Tëko mëɗ do Yesu tëkalëhniwohna ten. ");
INSERT INTO cou_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sël sankaf pëgwëlehn cëlënd, do lant ỹa ñënkaɗëho ɗus. ");
INSERT INTO cou_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Vërëfal va tëko njini ile rëkëk soŋe wakilo mbëɗ ma mbëɗ gë ryaw̃ (5 ma 6) uyas ante nunihawo Yesu ga njasëɗ ƴaŋ w̃ënka hna tëhatënd kulu lëw̃ hni ỹa. Ntakëlehnëhni, ");
INSERT INTO cou_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ɓare Yesu më ntehnëkëhni: «Ami, Yesu ye, antë ntaku!» ");
INSERT INTO cou_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Awa, ñaɗëniho kaƴëndëniha kulu hna, ɓare, hnë wati rac dënk, ñakëlehnëni nkal iŋa gë cape nte njiɗëniho ka. ");
INSERT INTO cou_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ga pacëk, kore le woko gë cape ñëntaw̃ lant ŋa njëtëniho kulu ryampo fo yeho hnam do Yesu tëfëlëntilohna gë vërëfal vëlëw̃u va, ɓare vërac vëhni fo yiko. ");
INSERT INTO cou_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tac wakulu wakaw̃ary w̃atiko hn'inaw̃ Tiberiyad hna, tëkini ɗarël hn'ile camehnëkawo Ahwëhn a W̃ënu ŋa soŋe rokëtok ile ndavahninihëhniwo kore ỹa. ");
INSERT INTO cou_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ante njëtëniho vahnë va Yesu gë vërëfal vëlëw̃u va vëwolohna hnam ŋa, kaƴëlehnëni hnë wakulu watac njini Kaperënaỹum, njëkëlehniniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Vahnë va, ga tëkatëniha Yesu gë cape ñëntaw̃ lant ka, më tëƴëniha: «Aharaŋ, guve njijëru ani?» ");
INSERT INTO cou_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu më ntëkwakëhni: «Toña ỹa fëƴaɗëmu: ge njëkëlehnëɗunëho, gena kaɓi nkwëryërun ile pëhnëtanëɗ wëdahëse wapëmpëhnahnah wadëmën ŋi, ɓare kaɓi tokërun mburu do pihnërun, soŋe umë yëkëlehnahnëɗunëho. ");
INSERT INTO cou_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Antë aryokuŋëndu soŋe rokëtok ile fërëkaɗ, ɓare soŋe rokëtok ile viỹëɗ, fihnëndanëɗ do yoɗ hafo uwám usër hna. Rac, ami, Ajë Ahn'a njëɗaɗëmu, kaɓi ami yenëhnëka W̃ënu ŋa Rëm ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Amboko tëƴëniha: «Awa ye rëfëkëfu lifu ryokuŋahnëfu waɗoku wante ñaɗ W̃ënu ŋa?» ");
INSERT INTO cou_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu më ntëkwakëhni: «Ɗoku ile ñaɗ W̃ën aliwu ỹa, umë ye: ahwëtahnuna ale paƴik ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Më tëƴëniha: «Iỹëhne dahëse fëmpëhnahnah hoɗu arufëfu soŋe ahwëtahnahni? Iỹëhne ɗoku liɗu tasefu? ");
INSERT INTO cou_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wati nte nɗëcëtaɗëniho vacërakëlo fu va wula hna, tokëniho man ỹa, gante nësëɗ Vikerëh ki: njëɗaɗëhëhniwo tokëni roka ile w̃atiko g'ambin ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu më ntëkwakëhni: «Toña ỹa fëƴaɗëmu: gena Moyis yëɗaɗëhuno roka vë g'ambin ỹa; Rëm mën ỹa yëɗaɗëhu ile ye roka vë g'ambin paryi ỹa. ");
INSERT INTO cou_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Paryi nke, roka ile w̃atik W̃ën ỹa, ale sëliɗ g'ambin a ye do pihnëndanëɗ do njoɗ hafo ambin hna.» ");
INSERT INTO cou_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Awa më ntehnëniha: «Aharaŋ, ƴëɗaryindëfu kwëlëkwël roka rac.» ");
INSERT INTO cou_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu më ntehnëkëhni: «Ami ye roka ile fihnëndanëɗ do yoɗ hafo ambin hna. Ale yijëk ỹal mën a inte ƴoɗilahna, ale hwëtahnëko ỹa w̃ënka ƴoɗilahna muk. ");
INSERT INTO cou_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ɓare tëkëmu fëƴawu, wëla gante nurunëho ami gë wëdahëse wapëmpëhnahnah wante liɓu ki, kwëtahnëɗilunohna. ");
INSERT INTO cou_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Fop vële njëɗaɗëhow̃ëhni Rëm va njijëɗëni ỹal mën hna, do daɗëw̃ahna muk ale yijëɗ ỹal mën a. ");
INSERT INTO cou_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ƴëtëryin ge cëliɓu g'ambin, gena liwu ile hnëŋëko, ɓare ryokuŋu ile ñaɗ ale faƴiko ỹa ye. ");
INSERT INTO cou_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wëlin ile ñaɗ ale faƴiko ỹa: heryëwëhni fop vële njëɗakow̃ëhni va do wëla aryampo antë cëv, do vëhnëndanëw̃ëhni fac rëkwa hna. ");
INSERT INTO cou_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ha, umë ye iña Rëm mën ŋa: fop vële yavëtëɗëho ami, Aju ỹa, do kwëtahnëniho va, nuỹani uwám ule wok puɗina, do ami, mbëhnëndanëɗëfuhëhni hnë fac rëkwa hna.» ");
INSERT INTO cou_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Awa wasëwif w̃a ñakëñakëɗëniho soŋe Yesu ỹa, kaɓi ntehnëko: «Ami ye roka ile sëlik g'ambin ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ntehnëɗëniho: «Gena bi Yesu aju Yosef ye? Njëtëɓunëhëhni ɗus rëmu gë hnëmu! Hak lë koɗ ntehn g'ambin cëlik?» ");
INSERT INTO cou_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu më ntëkwakëhni: «Tavëryin ñakëñak aki. ");
INSERT INTO cou_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ahnë koɗina njij hnë ỹal mën ge Rëm ale faƴiko ỹa ƴiryejëlahna, do ale-wo-le yijëk ỹalë mën a, mbëhnëndanëɗëfuha fac rëkwa hna. ");
INSERT INTO cou_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vikerëh wakila hna koɗun aharaŋu ỹin: “W̃ënu ŋa karaŋëɗëhëhni vëhni fop.” Ahnë ale-wo-le hnëpaka Rëm ỹa do maw̃a karaŋ dëw̃u ŋa njijëɗ ỹal mën hna. ");
INSERT INTO cou_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wëla ahnë aryampo nulahna Rëm ỹa ge gena ale w̃atik W̃ën hna, umë nuka. ");
INSERT INTO cou_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Toña ỹa fëƴaɗëmu: ale hwëtahnëk a nuỹaɗ uwám ule wok puɗina. ");
INSERT INTO cou_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","«Roka ile fihnënëɗ do yoɗ hafo uwám usër hna yeɓu. ");
INSERT INTO cou_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vacërakëlo hun va tokëniho man ỹa wula hna ɓare rac memaỹehnëlëhnihna cëmëni. ");
INSERT INTO cou_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ɓare wëli roka ile sëlik g'ambin ỹa, ge ahnë tokëk cëmëɗina. ");
INSERT INTO cou_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ami ye roka ile yënëɗ, ile sëlik g'ambin ỹa: ge ahnë tokëk roka rac, cëmëɗina muk. Roka ile yëɗahnëɗëfu soŋe vahnë va pihnëni do njohni hafo uwám usër hna, mbahn mën iŋa dënk ye.» ");
INSERT INTO cou_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Soŋe wanës watac, wasëwif w̃a nkwajëlëɗëniho ɗus, ntehnëndëni: «Aỹi asan, hak koɗ njëɗafu mbahn dëw̃u ŋa tokin?» ");
INSERT INTO cou_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Awa Yesu më ntehnëkëhni: «Toña ỹa fëƴaɗëmu: ge tokëluhna imbahn Ajë Ahn'a do ge celuhna sat lëw̃u ỹa, pihnëɗiluhna do ƴoɗiluhna hafo uwám usër hna. ");
INSERT INTO cou_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ale rokëk mbahn mën iŋa do sek sat mën ỹa pihnëɗ do ami, mbëhnëndanëɗëfuha fac rëkwa hna. ");
INSERT INTO cou_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ha, mbahn mën iŋa pihnëndanëɗ paryi do sat mën ỹa mërëndanëɗ paryi. ");
INSERT INTO cou_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ale rokëk mbahn mën do sek sat mën ỹa hnë ami nkoɗ, do ami, hnë umë nkoɗëfu. ");
INSERT INTO cou_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Rëm le faƴiko ỹa, umë ye haƴalin sël ntaw̃ary, uwám paryi ỹa. Njëɗaɗëho sël rac, vële ryavik g'imbahn mën va, vëhni fëna, koyëna nuỹaɗëni sël ntaw̃ary paryi ŋa. ");
INSERT INTO cou_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Awa ami ye roka ile sëlik g'ambin ỹa. Gena ndampo gë ile tokëni vacërakëlo hun ỹi; vëhni, cëmëni; ɓare ale rokëɗ iỹi roka ỹa nuỹaɗ uwám ule wok puɗina.» ");
INSERT INTO cou_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Koyëna nësëko Yesu ante karaŋëɗëhëhniwo vahnë hnë caliŋa mbë Kaperënaỹum ŋa. ");
INSERT INTO cou_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ante nkwëryënihawo Yesu ŋa, vëyaɓah vërëfal vëlëw̃u hna më ntehnëni: «Waŋi wanës ntakëk nëpayi! Mo hoɗ maw̃?» ");
INSERT INTO cou_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu njëtëko vërëfal vëlëw̃u va mëhnaɗëniho soŋe wanës watac. Soŋe umë ntehnahnëkëhniwo: «Waŋi wanës ntavëku bi? ");
INSERT INTO cou_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ye lë hnahaɗun awa ge nurunëha Ajë Ahn'a ga kaƴëɗ hn'ile nkeho koɓëri hna? ");
INSERT INTO cou_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iƴir W̃ënu ŋa ye haƴalin sël ntaw̃ary, uwám paryi w̃a; ahn'a umë fo ñoñ mëkëɗina nti tënkahn uwám usër hna. Wanës wante hnësëhnëmu ŋi Iƴir hna matik do yëɗahnëɗ sël ntaw̃ary rac. ");
INSERT INTO cou_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ɓare vëryampo hnë w̃uhnë vëhwëtahnëna.» Paryi nke, Yesu njëtëkëhniwo koɓëri wapëgwa hna vële wok vëhwëtahnëna va do njëtëkawo fëna ale rokaɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Më nkwënëk: «Wëlin soŋe umë lehnandëmu ahnë koɗina njij ỹal mën hna ge Rëm ỹa ƴëɗalow̃ahna.» ");
INSERT INTO cou_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Soŋe rac, vërëfal vëlëwu vëyaɓah pitaniho do wawolohna tëfëndëniha. ");
INSERT INTO cou_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Awa Yesu më cahëtak gë cape Pëhw gë Vëhi va, do tëƴëhni: «W̃uhnë lë, ñaɗiluhna bi ayintiwu gë vëỹi?» ");
INSERT INTO cou_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Piyer më ntëkwaka: «Ahwëhn, vëhni mo njiɗëfun? Kwëhnaru wanës wante yëɗahnëɗ uwám ule wok puɗina. ");
INSERT INTO cou_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Fuhnë, hnë wëjë kwëtëɓun kwëtahnëfu ŋa fop do njëtëɓun Asëvah a yeru, ale paƴik W̃ënu ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu më ntëkwakëhni: «Gena bi ami rëhnaku, w̃uhnë Pëhw gë Vëhi vi fop? Ɓare aryampo hnë w̃uhnë, aryokuŋ Sintani ye!» ");
INSERT INTO cou_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wanës watac, soŋe Yuɗa nësëɗëho, aju Simo Isëkariyot, aryampo hnë Pëhw gë Vëhi hna, ale rokaɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ante ndëcëk watac ŋa, Yesu njasëlendëho karaŋëndëhni vahnë va Galile hna; ñaɗilohna njasëlehnënd Yuɗe hna, kaɓi vësankaf wasëwif va njëkëlendëniho ndaw̃ehnëniha. ");
INSERT INTO cou_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hara ambënt wasëwif ante w̃acik Wasank ŋa tëhajëko. ");
INSERT INTO cou_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Awa vëheryu më ñankëɗëniha nji: «Soŋe ye ƴiɗila Yuɗe? Koyëna hnam fëna vërëfal hu va nuhahnëni waɗoku wapërën wante liɗu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ge ahnë ñaɗ njëti, cow̃aɗina ntitënd ɗoku lëw̃u ỹa. Kaɓi ntiɗu viỹë vihnaỹah gë vëỹi ki, diry nuni vahnë va fop.» ");
INSERT INTO cou_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Vëheryu nësëɗëniho koyëna kaɓi vëhni fëna vëhwëtahnëlawohna. ");
INSERT INTO cou_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu më ntëkwakëhni: «Wati mën ỹa tëkëna ten. Ɓare w̃uhnë, wati-wo-wati njivëk. ");
INSERT INTO cou_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɗuniỹa ỹi kwëhnana toña ñew̃u; ɓare ami, ñew̃ëko kaɓi pëƴahnëɗëfu ile ntiɗ ỹa mek. ");
INSERT INTO cou_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ƴiryin, w̃uhnë, g'ambënt; ami, ƴiɗa ten kaɓi wati mën ỹa tëkina.» ");
INSERT INTO cou_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ante ntehnëkëhniwo koyëna ŋa, umë, Galile hna nkoko ten. ");
INSERT INTO cou_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ɓare ante njiniho vëheryu g'ambënt ŋa, njiko umë fëna, ɓare tufëhnalohna hnë ahnë. ");
INSERT INTO cou_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hnë wati ambënt hna, vësankaf wasëwif va njëkëlehnëɗënihawo do tëƴëɗëniho: «Awa, ne nkeha asan arac?» ");
INSERT INTO cou_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kore hna vëryampo nkwajëlëɗëniho ɗus soŋe lëw̃u ỹa. Vëryampo ntehnëɗëniho: «Ale liɗ fërën ye.» Vëỹëntaw̃ va ntehnëɗëniho: «Hali, vahnë va tokaɗ.» ");
INSERT INTO cou_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ɓare, kaɓi ntakëkëhniwo gë vësankaf wasëwif va, ahnë ɗëkëɗilohna nës hafo nkwëryi soŋe lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yesu tënkëko Cery W̃ën Cankaf hna fagant wafac ambënt hna do karaŋëɗëhëhniwo vahnë va. ");
INSERT INTO cou_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wasëwif w̃a pëmpëhnahnëkëhniwo do tëƴaɗëniho: «Hak njëtahnëk aki Vikerëh vi, do koɓëri karaŋëna?» ");
INSERT INTO cou_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu më ntëkwakëhni: «Fop ile haraŋëɗëfuhëhni vahnë ỹi gena karaŋ mën; hnë ale faƴiko hna matik fop. ");
INSERT INTO cou_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ale hahnëndak nti ile ñaɗ W̃ënu ỹa njëtëɗ ge ile haraŋëɗëfuhëhni vahnë ỹa W̃ën hna matiɗ, ma ge hakili mën hna dënk matiɗ. ");
INSERT INTO cou_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ale hnësëɗ soŋe w̃ac lëw̃u ỹa, naỹëna nkaf ntëw̃u njëkëlehnëɗ. Ɓare ge ahnë njëkëlehnëɗ naỹën uw̃ac ale faƴika ỹa, ahnë asatah ye, do wamër gena hnë umë. ");
INSERT INTO cou_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyis njëɗaku sariya ỹa, ɓare wëla aryampo hnë w̃uhnë diɗina ile ntehnëk ỹa! Soŋe ye yëkëlehnëɗun aryaw̃uno?» ");
INSERT INTO cou_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kore ỹa më ntëkwaniha: «Ƴine hwëhnaru! Mo yëkëlehnëɗ ndaw̃i?» ");
INSERT INTO cou_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu më mbok ntehnëkëhni: «Iñë ryampo fo liɓu do wëli w̃uhnë fop pëmpëhnahnëku! ");
INSERT INTO cou_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyis ntehnëku ahácënduni vutah vucan va (paryi nke, gena umë fëgwëko, ɓare warëm fu vëryënkwëryënkw va fëgwëhnahnëko) do kácëɗunëha ahnë wëla hnë fac ntaw̃ëla. ");
INSERT INTO cou_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Awa, ge kácik fatah facan hnë fac ntaw̃ëla hna, menëɗina sariya Moyis ỹa, soŋe ye ntavëku g'ami kaɓi ahnë yërënëɓu fop hnë fac ntaw̃ëla? ");
INSERT INTO cou_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tavëryin kitiŋ ile worun ƴëtëluhna. Kitiŋëryindën gante nke toña ka.» ");
INSERT INTO cou_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Awa, vëryampo vëvë Yerusalem va nësëɗëniho soŋe Yesu ỹa: «Gena bi aỹi yëkëlehnakënde ndaw̃ehni? ");
INSERT INTO cou_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ƴëkëryina: tase vahnë fop nësëɗ do ñoñ dehnëɗena! Mpëd, paryi njavëtëniha vësankaf fu vi umë ye Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɓare Arëhnayik a, ge njijëɗ, ahnë ƴëtëɗina bi ne nkejëk; do aỹi asan, njëtëɓun hn'ile nkejëk hna.» ");
INSERT INTO cou_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Awa Yesu, ante karaŋëɗëhëhniwo vahnë va hnë selele Cery W̃ën Cankaf hna, më ndekak: «Paryi bi njëtërunëho do njëtërun bi ne matiɓu? Gena ami fëhnak yiju. Ale satëk faƴiko ɓare ƴëtëlunahna. ");
INSERT INTO cou_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ami, njëtëɓuha, kaɓi ỹalu hna matiɓu, do umë faƴiko.» ");
INSERT INTO cou_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Awa, soŋe wanës watac, vëyaɓah ñaɗëniho pëlaniha, ɓare ahnë pëlalawohna, kaɓi wati lëw̃u ỹa tëkëlohna ten. ");
INSERT INTO cou_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɓare vahnë vëyaɓah ɓulunda hna kwëtahnënihawo. Ntehnëɗëniho: «Ge Arëhnayik a tëkik, ntiɗ bi wëdahëse wafëmpëhnahnah ntëbi wante tëk ntik aỹi asan ŋi?» ");
INSERT INTO cou_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wafarise w̃a nkwëryëniho ile ñakëñakëɗëniho kore soŋe Yesu ỹa. Awa vësankaf vësëna wasaɗëha va gë wafarise w̃a më paƴënihëhni vëyëka Cery W̃ën Cankaf va njini pëlajëniha. ");
INSERT INTO cou_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu më ntehnëk: «Nkolahnëɗen ten toƴe. Tac mbokaɗëfu hn'ale faƴiko hna. ");
INSERT INTO cou_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wati rac rëkëɗun ayëkëlehnënduno ɓare nuɗilunohna; kaɓi koɗiluhna ayiwu w̃uhnë hn'ile nkeɗëfu ami hna.» ");
INSERT INTO cou_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wasëwif wale hnëpaɗëhawo va më tëƴëlëɗëni: «Ne ga ñaɗ nji hn'ile nkoɗen nuyilënahna hna? Wasëwif wale sampëk hnë vële wok vëyena wasëwif hna bi ñaɗ nji? Mpëd ñaɗ nji karaŋëhni vële wok vëyena wasëwif va fëna? ");
INSERT INTO cou_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ye ga pëhnëtanëɗ waŋi wanës: “Njëkëlehnëɗunëho do nuɗilunohna, kaɓi koɗiluhna ayiwu w̃uhnë hn'ile nkeɗëfu ami hna”?» ");
INSERT INTO cou_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fac le ỹak hwëhnak nafa ambënt hna yeho fac rëkwa ỹa. Fac rac, Yesu më kahnëk haryënkw kore ỹa, do ndeka: «Ge ahnë njoka w̃ënka, njij ỹal mën hna do ciya. ");
INSERT INTO cou_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ge ahnë kwëtahnëko, ahnë arac nkeɗ gante nësëk Vikerëh ka: “W̃ënka waƴaɓah wante njëɗahnëɗ sël ntaw̃ary, uwám paryi ŋa njaliɗ hnë umë.”» ");
INSERT INTO cou_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Yesu soŋe Iƴir nte nuỹaɗëni vële hwëtahnëka va nësëɗëho. Wati rac, Ƴir iŋa ƴëɗahnilohna ten, kaɓi Yesu matëndilohna ten hafo tëk laña hnëfak lëw̃u hna.) ");
INSERT INTO cou_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kore hna, vëyaɓah hnë vële wëryëko wanës watac va ntehnëɗëniho: «Paryi nke, aỹi asan ye kila le hnapëɗeho ỹa!» ");
INSERT INTO cou_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vëryampo ntehnëɗëniho: «Arëhnayik a ye!» Ɓare, vëryampo më ntëkwani: «Arëhnayik a koɗ bi mati Galile? ");
INSERT INTO cou_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gena bi Vikerëh va ntehnëk Arëhnayik a avë hnënk Ahnaw̃ David yeɗ do Betëlem nagëɗe, ankol David hna dënk?» ");
INSERT INTO cou_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Koyëna ɓulunda ỹa nahan dëw̃ hni ŋa nëmpëlëko g'ahaw̃ary soŋe Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vëryampo hnë vëhni ñaɗëniho pëlayi, ɓare ahnë ɗëkëlohna pëlahna. ");
INSERT INTO cou_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Vëyëka Cery W̃ën Cankaf va mbokalehnini g'ante nkeni vësankaf vësëna wasaɗëha gë wafarise ka. Vërac më tëƴënihëhni: «Soŋe ye worun ƴojëlunahna Yesu?» ");
INSERT INTO cou_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Më ntëkwani: «Koɓëri ahnë nësëna g'umë ki!» ");
INSERT INTO cou_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wafarise w̃a më ntëkwani: «Ye! Maw̃ërun w̃uhnë fëna arokayiwu? ");
INSERT INTO cou_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Koɓëri bi nurunëha asankaf aryampo ma farise aryampo ale hwëtahnëka? ");
INSERT INTO cou_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hali! Vahnë vële wok vëyëtëna sariya Moyis va fo hwëtahnëka. Vëhni, vëryëwanina!» ");
INSERT INTO cou_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem yeho farise aryampo ale yentiko hnam ỹa. Ɓiỹëna ɗus umë yiko vëhni Yesu hna. Umë ntehnëkëhni vëỹëntaw̃ va: ");
INSERT INTO cou_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Awa, sariya fu ỹa maw̃ëryak bi tame kitiŋi ahnë ndaw̃i hara gwëryina ten do hara ƴëtina uw̃eh ule ntik w̃a?» ");
INSERT INTO cou_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Më ntëkwaniha: «Avë Galile bi yeru, wëjë fëna? Ƴëkëry Vikerëh va do nuɗu wëla kila ryampo matiɗina muk Galile.» ");
INSERT INTO cou_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tac, pitëlëlehnëni ale-wo-le mënc gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu njiko hn'ikuŋ inte w̃acik Oliviye. ");
INSERT INTO cou_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ga pacëk, wakëwak fo, mbokako selele Cery W̃ën Cankaf hna do vahnë va fop tëhanihawo; awa më ntañak do karaŋëɗëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Taŋ, vëharaŋ sariya va gë wafarise w̃a tëkaryëlehniniha asëval ale naŋëtëlehniniho g'asan. Kwëtëniha haryënkw vahnë fop. ");
INSERT INTO cou_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Më ntehnëniha Yesu: «Aharaŋ, aỹi asëval g'asan naŋëtëlehnini hnë wati nte ndakakëndëni ŋa dënk. ");
INSERT INTO cou_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hara, sariya hna, Moyis më lehnëkëfu ntutini gë wëraka hafo cëmëni iỹi sifa vësëval. Wëjë lë, ye ye kiti hu ỹa hnë waŋi?» ");
INSERT INTO cou_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Hn'iŋi tëƴ, urënd tëndëhnëɗënihawo, nuỹahnëni ile ntehnëɗëni menëk.) Yesu dëkwalohna, tënkwëko do pëgw kerënd g'irufa ỹa nkal hna. ");
INSERT INTO cou_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kaɓi nkoniho tëƴëndëniha, awa Yesu më matëndak do ntehnëhni: «Ale wok koɓëri menëna hnë w̃uhnë ỹa ndënkw ntuta.» ");
INSERT INTO cou_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tac më mbok tënkwëk do mbok kerënd kat nkal hna. ");
INSERT INTO cou_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ga nkwëryëni wanës watac, njilehnëni aryampo aryampo, vicër va ryënkwëko ten. Tavëlehnëniha Yesu g'asëval a fo hnam. ");
INSERT INTO cou_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Awa Yesu më matëndak do ntehna: «Awa ne nkehëhni vële yojakëhi va? Ahnë gena bi ale hitiŋëki hafo cëm hna?» ");
INSERT INTO cou_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Asëval a më ntëkwak: «Aharaŋ, ahnë gena ale hitiŋëko.» Awa Yesu më ntehnëka: «Ami fëna kitiŋëɗilihna. Ƴiry, do ant'avoka w̃en.» ");
INSERT INTO cou_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu mboko nës kat kore hna: «Ami ye humpen ɗuniỹa ha. Ale rëfëɗëho ỹa ƴasëɗina hn'umëhwëry: nuỹaɗ humpen hunte ryënëɗ uwám usër hna.» ");
INSERT INTO cou_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Soŋe rac wafarise w̃a më ntehnëniha: «Wëjë dënk hnësaɗ; wanës hu ŋa kwëhnana nafa.» ");
INSERT INTO cou_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu më ntëkwakëhni: «Ha, ami dënk hnësaɗ: ɓare wanës mën ŋa kwëhnak nafa, kaɓi ami njëtëɓu hn'ile matiɓu hna do hn'ile njiɗëfu hna, ɓare w̃uhnë ƴëtëluhna hn'ile matiɓu hna gë hn'ile njiɗëfu hna. ");
INSERT INTO cou_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","W̃uhnë, ile hnuɗun fo hitiŋëɗun; ami, kitiŋëɗa ahnë. ");
INSERT INTO cou_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ɓare, ge kitiŋëɗëhëfu, kiti mën ỹa catëɗ, kaɓi gena ami fo hitiŋëɗ, Rëm ale faƴiko ỹa g'ami nkeɓun. ");
INSERT INTO cou_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kerina bi sariya hun hna, ge waseɗe wahi nësëni wanës watac fo, wanës watac toña ye? ");
INSERT INTO cou_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Awa ami, ami dënk ye seɗe mën ỹa, do Rëm ale faƴiko ỹa fëna nkenëhnëko seɗe.» ");
INSERT INTO cou_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Awa më tëƴëniha: «Ne nkeha rëmuh ỹa?» Yesu më ntëkwak: «Paryi ƴëtëlunohna do paryi ƴëtëlunahna Rëm mën ỹa fëna. Ge njëtakëndunëho, njëtakëndunëha Rëm mën ỹa fëna.» ");
INSERT INTO cou_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu, ante karaŋëɗëhëhniwo hnë selele Cery W̃ën Cankaf hna nësëko koyëna ɗarël hn'ile kwëtëɗeho wayëɗ hna. Ahnë ƴëkëhnahnëlohna pëlahna, kaɓi wati lëw̃u ỹa tëkëlohna ten. ");
INSERT INTO cou_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu më mbok ntehnëkëhni kat: «Njiɗëfu do njëkëlehnëɗunëho, ɓare gë wameh hun ŋa cëmëɗun. Koɗiluhna ayiwu hn'ile njiɗëfu hna.» ");
INSERT INTO cou_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wasëwif w̃a më ntehnëlëni: «Ndëwa bi ñaɗ, kaɓi ntehnëɗ: “Koɗiluhna ayiwu hn'ile njiɗëfu hna”?» ");
INSERT INTO cou_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu më ntehnëkëhni: «W̃uhnë vëvë gëɗ yerun, ɓare ami avë g'ambin yeɓu. Iỹi ɗuniỹa hwëhnëku, ɓare ami kwëhnëlohna iỹi ɗuniỹa. ");
INSERT INTO cou_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Soŋe umë lehnahnëmu: “Gë wameh hun ŋa cëmëɗun.” Ha, ge kwëtahnëluhna “Ami ye” gë wameh hun ŋa cëmëɗun.» ");
INSERT INTO cou_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Awa më tëƴëniha: «Mo yeru?» Yesu më ntëkwakëhni: «Kwëlëkwël pëƴaɗëmuno koɓëri wapëgwa hna. ");
INSERT INTO cou_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Soŋe hun ỹa, njaɓëk vile hokëndëɓu hnësu hitiŋahnu. Ale faƴiko ỹa ahwëhn toña ye, do ile fëƴaɗëmu hnë ɗuniỹa ỹi ỹalu hna ñëŋajëɓu.» ");
INSERT INTO cou_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Vëwëryëɗilohna Yesu soŋe Rëm ỹa nësëndëhëhniwo. ");
INSERT INTO cou_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Awa më mbok ntehnëkëhni: «Ge njelërunëha Ajë Ahn'a, njavëtëɗun “Ale ye ỹa yeɓu”, njavëtëɗun ñoñ diɗa g'ufër mën: ile karaŋëko Rëm ỹa fo hnësëɗëfu. ");
INSERT INTO cou_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ha, ale faƴiko ỹa g'ami nkeɓun; tavëlohna ami fo, kaɓi ile ñaɗ ỹa liɗëfu kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wati nte nësëɗëho Yesu aki ŋa vëyaɓah kwëtahnënihawo. ");
INSERT INTO cou_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Awa Yesu më ntehnëkëhni wasëwif wale lehnëko kwëtahnëniha va: «Ge maw̃ëhnëɗun fac-wo-fac wanës mën ŋa koyëna tufahnëɗun vërëfal mën paryi yerun. ");
INSERT INTO cou_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Koyëna njëtakëndun toña ỹa do toña ỹa ntikëndëhu vahnë vële ye afaya.» ");
INSERT INTO cou_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Më ntëkwaniha: «Fuhnë, Abëraham hwëhnëkëfu, koɓëri gelëfuhna muk vëramp ahnë. Hak koɗu alehn: “Nkekëndun afaya”?» ");
INSERT INTO cou_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu më ntëkwakëhni: «Toña ỹa fëƴaɗëmu: Ale-wo-ale liɗ wameh a, aramp wameh ye. ");
INSERT INTO cou_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hara aramp geɗina kwëlëkwël avë tere, ɓare aju ahwëhn tere ỹa avë tere kwëlëkwël ye. ");
INSERT INTO cou_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ge Aju W̃ën ỹa lik ayewu afaya, awa paryi nke afaya yeɗun. ");
INSERT INTO cou_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Njëtëɓu hnënk yerun gë Abëraham. Ɓare soŋe ile yëkëlehnëɗun aryaw̃uno ỹi, umë rufahnëɗ ŋwëỹërun wanës mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ami, ile hnuɓu vëhni Rëm mën ỹa hnësëɗëfu. Do w̃uhnë, ile wëryërun rëm hun hna liɗun.» ");
INSERT INTO cou_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Më ntëkwaniha: «Fuhnë, rëm fu ỹa, Abëraham ye.» Yesu ntehnëkëhniwo: «Ge paryi vutah Abëraham yekëndun, ile ntiɗëho ỹa rëkakëndun alindu. ");
INSERT INTO cou_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ɓare mama pëƴahnëmu toña ile ỹëŋajëɓu W̃ën ỹa, njëkëlehnëɗun aryaw̃uno. Abëraham ñoñ dina ile w̃ëntëlëk gë iỹin ki! ");
INSERT INTO cou_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","W̃uhnë, ile ntiɗ rëmun ỹa dënk liɗun.» Më ntëkwaniha: «Gelëfuhna vësëval vële wafëɗ vankaf vantëw̃ hni. Rëm ryampo fo hwëhnaɓun: W̃ënu ŋa ye!» ");
INSERT INTO cou_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu më ntehnëkëhni: «Ge paryi W̃ënu ŋa yekënd Rëm hun ỹa, rëkakëndun aỹanduno, kaɓi W̃ën hna matiɓu do soŋe lëw̃u ỹa yijëɓu hnë fagant hun hna. Ƴijëla soŋe lëmën dënk, umë faƴiko. ");
INSERT INTO cou_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Soŋe ye ye gwëryëɗiluhna ile lehnëɗëmu ỹa? Umë ye kaɓi mëkëɗiluhna ahnëpawu wanës mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Rëmun ỹa, Sintani ye, do ile ñaɗ ỹa liɗun. Koɓëri wapëgwa hna aryaw̃ vahnë ye: kahnëɗina muk hnë toña, kaɓi toña gena hnë umë. Ge mërëɗ, g'anësa ntëw̃u ŋa rëkëɗ nësënd, kaɓi aw̃ër ye, paryi nke umë ye rëm wamër ỹa. ");
INSERT INTO cou_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɓare ami, toña ỹa hnësëɗëfu. Soŋe umë ye kwëtahnëɗilunohna. ");
INSERT INTO cou_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mo hnë w̃uhnë hoɗ tufahn menëɓu iñë ryampo? Ge nësëɗëfu toña ỹa, soŋe ye kwëtahnëɗilunohna? ");
INSERT INTO cou_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ge W̃ënu ŋa hwëhnëku nëpaɗun wanës wadëw̃u ŋa. Ge nëpaɗiluhna, kaɓi kwëhnëluhna ye.» ");
INSERT INTO cou_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wasëwif w̃a më tëƴëniha Yesu: «Kwëhnalëfuhna bi toña lehnëfu avë Samari yeru do gë ƴine nkerun?» ");
INSERT INTO cou_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu më ntëkwak: «Gelëfuhna gë ƴine. Rëm mën ỹa lënënëɗëfu, ɓare w̃uhnë, ŋwëỹërun dënënëɗilunohna. ");
INSERT INTO cou_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ami, ƴëkëlehnëla icëmb soŋe lëmën dënk. Ahaw̃ary yëkëlehnëɗëho do umë hitiŋëɗ gante caŋëk ka. ");
INSERT INTO cou_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Toña ỹa fëƴaɗëmu: ale lënënëk wanës mën ŋa cëmëɗina muk.» ");
INSERT INTO cou_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wasëwif w̃a më ntehnëniha: «Tame, pacëkëfu gë ƴine nkerun. Abëraham cëmëk, wakila ŋa fëna, do wëjë, alehn: “Ale lënënëk wanës mën ŋa cëmëɗina muk.” ");
INSERT INTO cou_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wëjë bi lëbëka Rëm ỹa, Abëraham, nte sëmëk? Do cëmëni fop wakila ŋa fëna! Mo liyahnëki yeru?» ");
INSERT INTO cou_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu më ntëkwak: «Ge ami dënk rëkakënd sëmbandu, icëmb mën iŋa kwëhnakëndina nafa. Ale sëmbëɗëho ỹa, Rëm mën ỹa ye, umë dënk lehnëɗun ye W̃ën hun ŋa. ");
INSERT INTO cou_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ƴëtëlunahna, ɓare ami njëtëɓuha. Ge ntehnakëndëɓu ƴëtëlëw̃ahna, aw̃ër yekëndëɓu, had w̃uhnë. Ɓare njëtëɓuha do ntënënëɗëfu wanës wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abëraham, Rëm sankaf hun ỹa, natëkawo ɗus kaɓi njëtëko tëkiɗëfu. Nuko fac lëmën ỹa do natëkawo.» ");
INSERT INTO cou_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Awa wasëwif w̃a më mbokëni ntehnëniha: «Kwëhnalihna ten wabëhn wafëhw imbëɗ (50) do alehn nuruha Abëraham!» ");
INSERT INTO cou_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu më ntëkwakëhni: «Toña ỹa fëƴaɗëmu: ani gë nagahnënde Abëraham ỹa, “Ami Ye.”» ");
INSERT INTO cou_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ga nkwëryëni watac, mbankëpëɗëniho wëraka ntutahnëniha, ɓare Yesu më cow̃ak do cahnëlehn selele Cery W̃ën Cankaf hna. ");
INSERT INTO cou_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Awa, hn'ankaw̃ hna, Yesu nukawo asan ale hnagiko mëp. ");
INSERT INTO cou_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vërëfal vëlëw̃u va më tëƴëniha aki: «Aharaŋ, soŋe ye nagik aỹi asan mëp? Soŋe wameh wadëw̃u ŋa dënk bi ye ma wameh vële hnagëka ŋa ye?» ");
INSERT INTO cou_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu më ntëkwak: «Gena soŋe wameh wadëw̃u ŋa, gena fëna wëɓa vële hnagëka ŋa; mëpëk soŋe vahnë va fop nuhahnëni ile mëkëɗ nti W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tëfëkëfu ntiyin waɗoku ale faƴiko ỹa ante nkok mëɗëna ten ŋi. Mëɗ uŋa tëhajëk, hn'ile nkoɗ kolëna ahnë mbok ndokuŋ. ");
INSERT INTO cou_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wati nte yeɗëfu ɗuniỹa ỹi fop, humpen ɗuniỹa ha yeɓu.» ");
INSERT INTO cou_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ga nësëk watac, Yesu më tëpëk nkal hna do nëgw nkal iŋa gë wato wadëw̃u ŋa, do mbërya inkal tac mëp uŋa vinkër hna. ");
INSERT INTO cou_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tac ntehna: «Ƴiryeyi awëñaj pisin le w̃acëɗe Silowe ỹa.» Uw̃i w̃ac «Ale Faƴik» pëhnëtanëɗ. Umëp uŋa njilehn nkwëñaj, do mëpëtako mbokajatënd! ");
INSERT INTO cou_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vësaryëntaw̃u gë vële hnuɗëhawo kwëlëkwël ga muntaɗ va më ntehnëni: «Gena bi aỹi asan lañaɗëho kwëlëkwël muntand?» ");
INSERT INTO cou_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vëryampo ntehnëɗëniho: «Umë dënk ye.» Vëhaw̃ary më nkwajëni: «Ale mëntëlëni fo ye.» Ɓare umë, më ntehnëk: «Paryi, ami dënk ye.» ");
INSERT INTO cou_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Awa më tëƴik: «Hak ntiru ahnuhahnënd?» ");
INSERT INTO cou_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Më ntëkwakëhni: «Asan ale w̃acik Yesu ỹa sëkënakëh toƴe nkal iŋi, mbëryo vinkër li do ntehno: “Ƴiryeyi Silowe hna awëñaj.” Më yiɓu, wëñaju do, taŋ hnulehnu wapacëk!» ");
INSERT INTO cou_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Më tëƴëniha: «Ne nkeha Yesu tac?» Më ntëkwakëhni: «Ƴëtëla.» ");
INSERT INTO cou_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Më njoniha asan ale w̃ëpëko ỹa gë wafarise. ");
INSERT INTO cou_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hara, hnë fac ntaw̃ëla cëkënëko Yesu nkal iŋa mëpëtahna vinkër va. ");
INSERT INTO cou_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Awa wafarise w̃a më tëƴëniha vëhni fëna, hak kolahnëk nund. Më ntehnëkëhni: «Nkal cëkah liyiɓuho vinkër li, më wëñaɓu, do tame nuɗëfu.» ");
INSERT INTO cou_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wafarise wëryampo më ntehnëni: «Ale lik iỹin ỹa matina W̃ën hna, kaɓi dënënëɗina ntaw̃ëla ŋa.» Ɓare vëhaw̃ary më ntëkwani: «Hak koɗ ahnë aw̃en nti iỹi sifa wëdahëse wafëmpëhnahnah?» Wanës wadëw̃ hni ŋa nëmpëlëko. ");
INSERT INTO cou_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Awa më mbok tëƴëniha kat ale w̃ëpëko ỹa: «Wëjë lë, ye hnësëru soŋe lëw̃u ỹa kaɓi vinkër hu va mëpëtëk?» Më ntëkwakëhni: «Kila ye.» ");
INSERT INTO cou_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ɓare, wasëwif w̃a ŋwëỹëniho kwëtahnëni paryi aỹi asan mëpëko do tame nuɗ. Soŋe rac macahnënihëhniwo vële hnagëka va. ");
INSERT INTO cou_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Më tëƴënihëhni: «Aỹi asan paryi bi ajë hun ye? Umëp bi nagik paryi? Ge toña ye, hak ntik awa nuhahnëɗ tame?» ");
INSERT INTO cou_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Vële hnagëka va më ntëkwani: «Njëtëɓun ajë fu ỹa ye do mëp nagik. ");
INSERT INTO cou_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ɓare ƴëtëlëfuhna bi ye liyak nuhahnëɗ tame do ƴëtëlëfuhna fëna bi mo w̃ëpëtëka. Tëƴëryina: naỹëk, koɗ ntëkwa umë dënk!» ");
INSERT INTO cou_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Vële hnagëka asan va nësëniho koyëna kaɓi ntakëkëhniwo gë vësankaf wasëwif va: njëtëniho vëhni tëko pëhnani ntanihëhni caliŋa hna fop vële hwëtahnëɗ Yesu ye Arëhnayik a. ");
INSERT INTO cou_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Soŋe rac ntëkwahnëniho vële hnagëka mëp va: «Tëƴëryina umë dënk, naỹëk, koɗ ntëkwa!» ");
INSERT INTO cou_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Awa wafarise w̃a më mbok macehnëniha kat asan ale w̃ëpëko ỹa do ntehnëniha: «Dënënëryehna W̃ënu ŋa ahnës toña ỹa. Njëtëɓun fuhnë asan arac aw̃en ye.» ");
INSERT INTO cou_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Më ntëkwak: «Ƴëtëla bi aw̃en ye ma hali. Ɓare njëtëɓu iñë ryampo: mëpëɓuho do tame nuɗëfu.» ");
INSERT INTO cou_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Më mbokëni tëƴëniha: «Ye ntiki? Hak njërënëki?» ");
INSERT INTO cou_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Më ntëkwakëhni: «Nësëhnëmu, ɓare nëpalunohna. Soŋe ye ỹaɗun avok awëryuno kat? Ñaɗun bi mpëd, w̃uhnë fëna, ayentiwu vërëfal aỹi asan?» ");
INSERT INTO cou_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Awa pëgwëlehnëni njew̃ëndëniha do ntehnëni: «Wëjë, arëfal aỹi asan yeru! Fuhnë, vërëfal Moyis yeɓun. ");
INSERT INTO cou_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Njëtëɓun W̃ënu ŋa nësëhnëkawo Moyis, ɓare aỹi asan, ƴëtëlëfuhna dënk bi ne matik!» ");
INSERT INTO cou_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Asan a më ntëkwakëhni: «Umë fëmpëhnahnah ye: njërënëko do ƴëtëluhna, w̃uhnë, hn'ile matik hna! ");
INSERT INTO cou_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Fuhnë fop, njëtinëk W̃ënu ŋa nëpaɗilëhnihna vëw̃en va, ɓare ge ahnë ntënënëɗëha do nti ile ñaɗ ỹa, nëpaɗëha. ");
INSERT INTO cou_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Koɓëri gwëryina ga nësëɗe ahnë mëpëtëka ale hnagik mëp. ");
INSERT INTO cou_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aỹi asan, ge matekëndina W̃ën hna, ñoñ kokëndina nti.» ");
INSERT INTO cou_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Umë ntëkwaniha: «Wameh fo yeru koɓëri nte nagiru ŋa do aỹand aharaŋëfu!» Ntalehnëniha caliŋa hna. ");
INSERT INTO cou_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu njëtako ntaniha asan a, më njëkëlehnëka do tëƴa: «Kwëtahnëruha bi Ajë Ahn'a?» ");
INSERT INTO cou_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Asan a më ntëkwaka: «Aharaŋ, pëƴarye bi mo ye soŋe holahnu hwëtahnuw̃a.» ");
INSERT INTO cou_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu më ntehnëka: «Nuɗuha gë vinkër hu vi. Umë dënk hnësëndëhi iỹi wati.» ");
INSERT INTO cou_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Asan a më ntehnëka: «Ahwëhn, kwëtahnëmi.» Ndëkwëhnëlehn haryënkw Yesu do cëmba. ");
INSERT INTO cou_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tac Yesu më ntehnëk: «Soŋe tufahn ale-wo-le ile nke ỹa yijëɓu hnë iỹi ɗuniỹa. Koyëna vële wok vëhnuɗina va nuhahnëni do vële hnuɗ va nkeni had vumëp.» ");
INSERT INTO cou_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wafarise, wale yeho ɗarël lëw̃u w̃a, nkwëryëniho wanës wadëw̃u ŋa do më tëƴëniha: «Awa, vumëp bi yeɓun, fuhnë fëna?» ");
INSERT INTO cou_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu më ntëkwakëhni: «Ge vumëp yekëndun, dehnakëndena menërun. Ɓare wëli: ntehnërun nuɗun. Soŋe rac wameh hun ŋa hnë w̃uhnë nkok.» ");
INSERT INTO cou_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu mboko ntehn kat: «Toña ỹa fëƴaɗëmu: ge kwëhnaru kece wape do ge ahnë kaƴëk cape ndampo tënkëna hnë rënka hna, ahnë arac ale ye do bandi. ");
INSERT INTO cou_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ale rënkëk rënka ỹa, umë ye aheryëherya wape ŋa. ");
INSERT INTO cou_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ayëka kece ỹa piɗëtëhnëɗëha aheryëherya ỹa rënka ỹa do wape ŋa nëpaɗëni kopa lëw̃u ỹa. Macëɗëhëhni wape wadëw̃u ŋa ile-wo-le w̃ac lëw̃u w̃a do canëhni. ");
INSERT INTO cou_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ge canëkëhni fop wante kwëhnëk ŋa, gë vëhni rëkëɗ njasëntënde do tëfëlëɗëni, kaɓi njëtëni kopa lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Muk warëfëlendilahna ale nkoni wayëtëna; nkaryëɗëniha ŋaw̃ët, kaɓi wayëtëna kopa lëw̃u ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu uŋi mëntëndëlehn nësëhnëkëhniwo vahnë va fop, ɓare vëyëtëlohna ile nësëɗëho ỹa. ");
INSERT INTO cou_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Awa më mbok ntehnëk: «Toña ỹa fëƴaɗëmu: ami ye rënka kece wape ŋa. ");
INSERT INTO cou_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Fop vële ryënkwëhnikow̃o vi vële ye do wabandi do wape ŋa wahnëpalëhnihna. ");
INSERT INTO cou_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ami ye rënka ỹa. Ale rëfëk ỹal mën tënkahn ỹa pehëtëɗe. Koyëna koɗ tënkënd do cahnënd gante ñaɗ ka, do nuỹaɗ ile tokëɗ. ");
INSERT INTO cou_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ale ỹa, ule fo njijëɗ, iɗaw̃ do përëkan. Ami, njijëɓu soŋe nuỹahnëni vahnë va sël ntaw̃ary, uwám paryi w̃a, do njaɓëhni. ");
INSERT INTO cou_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ami, aheryëherya afërën a yeɓu. Aheryëherya afërën a pëhwëtak njëɗahn ntaw̃ary dëw̃u ŋa soŋe wape wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ale sosëɗe koryi soŋe keryahnënd herya do kwëhnëlihna umë dënk wape ŋa, umë gena aheryëherya paryi: ge nuka ỹin ỹa, ga njijëɗ, tavëɗëhëhni nkary. Awa ỹin ỹa tënkëɗëhëhni wape ŋa pëlahni wëɗampo do wañëntaw̃ ŋa campëɗëni. ");
INSERT INTO cou_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aỹi asan, koyëna ntiɗ kaɓi cosik ntihahn ɗoku rac do nafa wahwëhnana wape mën ŋa soŋe lëw̃u. ");
INSERT INTO cou_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Ami, aheryëherya afërën a yeɓu. Njëtëɓuhëhni wape mën ŋa do wape mën ŋa njëtëniho, ");
INSERT INTO cou_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","had gante njëtëko Rëm ki do njëtëɓuha Rëm ki. Njëɗahnëɗëfu ntaw̃ary mën ŋa soŋe wape mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kwëhnaɓuhëhni kat wape wakaw̃ary wante wok wayentina kece li. Tëfëko watac fëna yojëw̃ëhni; nëpaɗëni kopa mën ỹa, do koyëna kore ryampo fo nkeɗëni g'aheryëherya aryampo fo. ");
INSERT INTO cou_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ge Rëm ỹa ŋahnëɗëho, kaɓi njëɗahnëɗëfu ntaw̃ary mën iŋa ye. Njëɗahnëɗëfu ɓare mbiɗëfu fëna. ");
INSERT INTO cou_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ahnë koɗina nufëhno ntaw̃ary iŋi, ɓare g'uhnatah njëɗahnëɗëfu. Mëkëɗëfu yëɗahnu do mëkëɗëfu viwu kat. Umë ye ile ntehnëko Rëm mën liwu ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nahan wasëwif w̃a mboko nëmpël kat soŋe wanës watac. ");
INSERT INTO cou_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vëyaɓah hnë vëhni ntehnëɗënihawo: «Gë ƴine nkeni! Cenaka! Soŋe ye hnëpaɗunëha?» ");
INSERT INTO cou_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Vëryampo më ntëkwani: «Ale nkeni gë ƴine nësëɗina aki; ƴine koɗ bi mëpëta ahnë?» ");
INSERT INTO cou_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wati huji yeho do ntiɗeho Yerusalem hna ambënt nte ryënkwëtahnëɗeho ante pëhwëtiko Cery W̃ën Cankaf ŋa. ");
INSERT INTO cou_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu nkentiko do nder cankaf nte w̃acik Salomo hna njasëlehnëɗëho. ");
INSERT INTO cou_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Awa wasëwif w̃a më kwërëniha do ntehnëniha: «Hafo guve ntihëtëɗuhëfu hn'ufëmpëhnahnah hna? Ge Arëhnayik a yeru pacënëhnëryifu.» ");
INSERT INTO cou_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu më ntëkwakëhni: «Tëkëmu fëƴawu, ɓare kwëtahnëluhna. Nurun waɗoku wante liɗëfu g'uw̃ac Rëm mën ŋa; watac ye seɗe mën ỹa. ");
INSERT INTO cou_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɓare kwëtahnëɗiluhna kaɓi gentiluhna kore wape mën hna. ");
INSERT INTO cou_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wape mën ŋa nëpaɗëni kopa mën ỹa; njëtëɓuhëhni do tëfëlehnëɗëniho. ");
INSERT INTO cou_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Njëɗaɗëfuhëhni uwám ule wok puɗina ỹa: wasëvëɗina muk do ahnë koɗina teɓow̃ëhni. ");
INSERT INTO cou_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Rëm mën ale yëɗakow̃ëhni ỹa hnaỹëk lëbëk fop, do ahnë koɗina nufëhni gë fanka hnë umë. ");
INSERT INTO cou_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ami gë Rëm ỹa, aryampo fo yeɓun.» ");
INSERT INTO cou_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tac fëna kat, wasëwif w̃a, ga nkwëryëni watac, më mbok nufani wëraka ndaw̃ahnëniha. ");
INSERT INTO cou_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Awa Yesu më ntehnëkëhni: «Ntiɓu tase hun viỹë vifërën viyaɓah gë fanka Rëm ỹa, soŋe iỹëhne hnë watac ỹaɗun aryaw̃ahnuno gë wëraka?» ");
INSERT INTO cou_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wasëwif w̃a më ntëkwaniha: «Gena iñë fërën ile liru ỹaɗeru aryaw̃ahni, ɓare kaɓi W̃ënu ŋa yew̃ëɗu. Wëjë ahnë fo yeru, do aỹand aliya W̃ën!» ");
INSERT INTO cou_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu më ntëkwakëhni: «Kerina bi Vikerëh hun hna: Ami, Ahwëhn a, ntehnëɗëmu: “Wamën yerun”? ");
INSERT INTO cou_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Njëtinëk koɗena ntihëti hn'ile nësik Vikerëh W̃ënu hna. Awa Vikerëh hun hna W̃ënu ŋa “wamën” macëkëhni vële ntehnëɗ va. ");
INSERT INTO cou_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Do ami, Rëm ỹa tëhnako paƴe ɗuniỹa li. Awa hak koɗun alehnu W̃ënu ŋa yew̃ëɗëfu ge pëƴahnëɓu Aju W̃ënu ŋa yeɓu? ");
INSERT INTO cou_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ge diɗa ɗoku Rëm mën ỹa, ant'ahwëtahnuno. ");
INSERT INTO cou_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ɓare ge ntiɗëfu, wëla kwëtahnëlunohna, maw̃ëryin ahwëtahnu wëla waɗoku mën ŋi fo. Koyëna njavëtëɗun, pëgw dol hafo kwëlëkwël, Rëm ỹa hnë ami nke do ami hnë umë nkeɓu.» ");
INSERT INTO cou_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Soŋe rac, vësankaf wasëwif va mboko njëkëlehnëndëni pëlaniha, ɓare pehëkëhniwo. ");
INSERT INTO cou_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ga ndëcëk watac, Yesu më mbok njik gë cape ñëntaw̃ mbë sën Yurëdan ka, hn'ile pëgwëko njaryënd San hna dënk. Hnam ñëw̃ëko. ");
INSERT INTO cou_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vahnë vëyaɓah njijëniho ỹalu hna. Ntehnëɗëniho: «San wëla dahëse fëmpëhnahnah ryampo dilohna, ɓare fop ile nësëɗëho soŋe aỹi asan ỹa toña ye.» ");
INSERT INTO cou_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Do vëyaɓah hnam kwëtahnënihawo Yesu. ");
INSERT INTO cou_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Hn'ankol Betani hna ntëɗëniho Mari g'aheryu Marët, do g'ahery hni Lasar. (Mari yeho asëval ale rurëkawo Ahwëhn a ɗatikola ỹa wapary hna do pëhwëca g'imul dëw̃u ŋa.) Awa Lasar, aheryu, tesëko. ");
INSERT INTO cou_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Vësëval vëhi vërac më paƴëniha ahnë nji ntehna Yesu: «Ahwëhn, lawo hu ale ỹaru aỹand a, tesëk.» ");
INSERT INTO cou_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu, ga njëtak watac, më ntehnëk: «Uw̃i res gena ɗaw̃ iŋi fo ndaw̃ëɗëha, umë cëmbahnëɗe W̃ënu ŋa fëna, tufahnëɗ inaỹ dëw̃u ŋa do koyëna tufahnëɗe inaỹ Ajë W̃ën ỹa fëna.» ");
INSERT INTO cou_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hara Yesu ñaɗëhawo Marët, gë Mari, do g'ahery hni Lasar. ");
INSERT INTO cou_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɓare ante njëtako Lasar tesëk ŋa, wafac wahi mboko ñëw̃ hn'ile nkeho hna. ");
INSERT INTO cou_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tac më ntehnëkëhni vërëfal vëlëw̃u va: «Ɓokanëfu gë Yuɗe.» ");
INSERT INTO cou_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vërëfal va më ntëkwaniha: «Aharaŋ, ɓiỹëna ga njëkëlehnëɗënihino vëvë Yuɗe va ndaw̃ënihi gë wëraka, do tame ñaɗu avoka hatac?» ");
INSERT INTO cou_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu më ntehnëkëhni: «Gena bi wëwati pëhw gë wahi ye facë hna? Ge ahnë njasëɗ g'anent, gëw̃ëɗina, kaɓi nuɗ wapacëk gë humpen ɗuniỹa hi. ");
INSERT INTO cou_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɓare ge g'umëɗ ga njasëɗ, nkëw̃ëɗ, kaɓi humpen gena hnë ahnë arac.» ");
INSERT INTO cou_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ante nësëk watac ŋa, Yesu më nkwënëk: «Lawo fu ỹa Lasar wakwëɗ ndakëk, ɓare njiɗëfu hnëgëtëw̃a.» ");
INSERT INTO cou_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vërëfal va më ntëkwani: «Ahwëhn, ge ndakëk, ƴër iŋa njërëɗ.» ");
INSERT INTO cou_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu Lasar cëmëk ñaɗëho nës, ɓare vërëfal va ntiyahnëkëhniwo ryak wakwëɗ paryi nësëɗ. ");
INSERT INTO cou_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Awa Yesu më nësëhnëkëhni wapacëk: «Lasar cëmëk, ");
INSERT INTO cou_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","do natëko soŋe hun ỹa kaɓi gelëw̃ohna hnam g'umë wati rac. Koyëna kwëtahn hun ŋa njaw̃ëɗ. Awa tame ƴinëfu ỹalu hna.» ");
INSERT INTO cou_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tac Toma, ale w̃acëɗe Asëp a, më ntehnëkëhni vërëfal vëỹëntaw̃ va: «Ƴinëfu, fuhnë fëna, soŋe cëmëntinëfu g'umë!» ");
INSERT INTO cou_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ante tëkëko Yesu ŋa, njëtëko Lasar nuỹak wafac wahnah ƴag hna. ");
INSERT INTO cou_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yëbëlan Betani gë Yerusalem tëkëlohna uyas wakilo watar, ");
INSERT INTO cou_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","do wasëwif wayaɓah njijëniho vëhni Marët gë Mari hna soŋe simpaỹ icëm ahery hni ŋa. ");
INSERT INTO cou_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marët, ga njëtak Yesu nkejëk, më njik pankëlëni, ɓare Mari tere hna nkoko. ");
INSERT INTO cou_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marët më ntehnëka Yesu: «Ahwëhn, ge hnani nkekënduho ahery mën a cëmakëndina. ");
INSERT INTO cou_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ɓare njëtëɓu wëla gaki W̃ënu ŋa maw̃ëryanëɗëhi fop ile rëƴëɗuha ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu më ntehnëka: «Ahery hu matëɗ cëm hna.» ");
INSERT INTO cou_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marët më ntëkwaka: «Njëtëɓu ɗus, mbëhnëɗ fac rëkwa hna, ante rëkëɗ mbëhnëndëni fop vësëm ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu më ntehnëka: «Ami dënk ye iɓëhn iŋa do sël ntaw̃ary, uwám paryi w̃a. Ale hwëtahnëko ỹa mbëhnëɗ wëla cëm. ");
INSERT INTO cou_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Do ale-wo-le hwëhnak sël ntaw̃ary, uwám paryi w̃a do kwëtahno goɗina cëm hna. Kwëtahnëru bi waŋi?» ");
INSERT INTO cou_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marët më ntëkwaka: «Ha, Ahwëhn, kwëtahnëɓu Arëhnayik a yeru, Ajë W̃ën, ale rëfëkawo njij ɗuniỹa hna.» ");
INSERT INTO cou_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marët, ga nësëk watac, njilehn macehna aheryu Mari, canarya ntehna: «Aharaŋ a ani nke, do macëɗëhi.» ");
INSERT INTO cou_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari, ga nkwëryëk watac, matëlehn nkary gë vëhni Yesu. ");
INSERT INTO cou_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hara tënkëlohna ten nkol hna: hn'ile pankëlëniho gë Marët hna nkoko. ");
INSERT INTO cou_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vële nkeniho gë Mari tere hna, yijëko simpaỹ icëm va, nunihawo ga matëk cahn nkary. Më tëfëlehnëniha, ntiyahnëkëhniwo g'iƴag njiɗ wako ŋa. ");
INSERT INTO cou_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari tëkëko hn'ile nkeho Yesu hna. Nunda tuŋ, njolehn haryënkw lëw̃u do ntehna: «Ahwëhn, ge ani nkekëndu ahery mën a cëmakëndina.» ");
INSERT INTO cou_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ga nukëhni Yesu koɗëniho gë vële njijëniho va, njakëkawo sakahnëha ɗus. ");
INSERT INTO cou_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Më tëƴëkëhni: «Ne kwëtërunëha?» Më ntëkwaniha: «Ahwëhn, ƴij, nuɗu.» ");
INSERT INTO cou_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu pëgwëlehn kond. ");
INSERT INTO cou_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Awa vahnë va ntehnëlehnëni: «Ƴëkëryin gante ñaɗëhawo ka!» ");
INSERT INTO cou_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Vëryampo hnë vëhni ntehnëɗëniho: «Umë ale w̃ëpëtëkëhni vumëp, kokëndina bi memaỹehn icëm Lasar ŋa?» ");
INSERT INTO cou_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu mboko njaka sakahnëha ɗus. Më njik ƴag hna. Hara iƴag nte yabiko hn'itaka yeho, rënka ỹa taka konah fiɗahniko. ");
INSERT INTO cou_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ntehnëko: «Dihëtëryin taka ŋi.» Awa Marët, acëru asëm a, më ntehnëka: «Ahwëhn, tëfëka tehënd tame, kaɓi tëkëk wafac wahnah ga kwëtahnik ani.» ");
INSERT INTO cou_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu më ntëkwaka: «Dehnëlihna bi ge kwëtahnëru nuɗu inaỹ W̃ënu ŋa?» ");
INSERT INTO cou_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Awa ntihëtëlehni taka ŋa. Yesu më kaŋëk g'ambin, do ntehn: «Apa, camehnëmi kaɓi nëpaɗuho. ");
INSERT INTO cou_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ami, njëtëɓu nëpaɗuho kwëlëkwël, ɓare soŋe vële hwërëko vi hnësandëɓu aki, kwëtahnahnëni wëjë faƴiko.» ");
INSERT INTO cou_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ante nësëk watac ŋa, më ndekak gë fanka: «Lasar, cahni!» ");
INSERT INTO cou_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Awa asëma cahnëlehni ƴag hna. Wapary ŋa gë wëɓák ŋa përyiko, yëka ỹa tëmpiko. Yesu më ntehnëkëhni vële yeho hnam va: «Përyëtëryina do aravuna nji.» ");
INSERT INTO cou_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ga nuni ile ntiko Yesu ỹa, vëyaɓah hnë vële yijëko vëhni Mari va kwëtahnënihawo. ");
INSERT INTO cou_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ɓare vëryampo hnë vëhni njiniho pëƴanihëhni wafarise w̃a ile ntiko Yesu ỹa. ");
INSERT INTO cou_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Awa vësankaf vësëna wasaɗëha va gë wafarise w̃a mbarënihëhniwo Mbara Vëhitiŋ va do ntehnënihëhni: «Ye liɗen? Aỹi asan vifëmpëhnahnah viyaɓah ntiɗ. ");
INSERT INTO cou_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ge tavinëka ntind aki, vahnë va fop umë kwëtahnëɗëni. Awa vëvë Rom va njijëɗëni nihëni Cery W̃ën Cankaf fu ŋi gë ɓulunda fu ỹi!» ");
INSERT INTO cou_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aryampo hnë vëhni, ale w̃aciko Kayif, do yeho asëna asankaf a bëhn rac, më teɓak wanës ŋa ntehnëhni: «Ñoñ gwëryëɗiluhna! ");
INSERT INTO cou_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ye fecek: cëm ahnë aryampo soŋe ɓulunda ỹi fop ma tavi nihi ɓulunda ỹi fop?» ");
INSERT INTO cou_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hara ile nësëɗëho ỹa matiɗilohna hnë umë; ɓare kaɓi umë yeho asëna wasaɗëha asankaf a bëhn rac, umë nësehnahnëkawo W̃ënu ŋa ntehn Yesu tëfëka cëm soŋe ɓulunda lëw̃u ỹa. ");
INSERT INTO cou_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Do gena soŋe ɓulunda lëw̃u ỹi fo tëfëkawo cëm, ɓare soŋe mbarëpahnini fëna fop vutah W̃ën vunte sampëk ɗuniỹa vi nkeni ɓulunda ryampo fo. ");
INSERT INTO cou_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Awa, koɓëri hnë fac rac pëhnaniho vësankaf wasëwif va ndaw̃ehnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Soŋe rac tavahnëko Yesu ƴasëlehn ɓulunda wasëwif hna, nji hnë resiỹo ỹëntaw̃ vë wula hna, hn'ankol nte w̃aciko Efërayim. Hnam ñëw̃ëniho gë vërëfal vëlëw̃u va. ");
INSERT INTO cou_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wati ambënt Pak ŋa tëhajëko. Soŋe rac, vahnë vëyaɓah vëvë vankol vambë caharaɓ va njiɗëniho Yerusalem soŋe pacënajëni tëkahnënd mbënt tac. ");
INSERT INTO cou_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Awa njëkëlehnëɗënihawo Yesu do tëƴëlëɗëniho vëhni fo, selele Cery W̃ën Cankaf hna: «Paryi nke gena bi ƴijëɗina ambënt ŋi? Ye hnaharun?» ");
INSERT INTO cou_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nësëɗëniho koyëna kaɓi vësankaf vësëna wasaɗëha va gë wafarise w̃a ntehnëniho ge ahnë njëtëk hn'ile nke Yesu hna, tëfëka pëƴahni soŋe pëlayi. ");
INSERT INTO cou_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wafac mbëɗ gë ryampo wojëko tëkahnind Pak ỹa. Yesu njiko Betani hn'ile ntëɗëko Lasar hna, ale mbëhnëndanëko ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hnam, më ntëvayik. Marët ryokuŋëɗëho ile ntëvayiko ỹa. Lasar gë vële tokëlahnëɗëniho Yesu va nkentiko. ");
INSERT INTO cou_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Awa Mari më nufëk sëleku ɗatikola hambah ntaw̃i, ile lihahnik narëd paryi, më turëka Yesu wapary hna, tac pëhwëca g'imul dëw̃u ŋa. Cery ŋa fop ɗatikola rac fo rehëɗëho. ");
INSERT INTO cou_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuɗa Isëkariyot, aryampo vërëfal Yesu hna, ale rokaɗëha ỹa, më ntehnëk: ");
INSERT INTO cou_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Soŋe ye woyinëk gwafilënëhna iỹi ɗatikola gë koryi yaɓah do njëɗayini koryi rac vëhaỹëhnah va?» ");
INSERT INTO cou_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gena bi kaɓi kwëtahnëkëhni nëf vëhaỹëhnah va nësëɗëho koyëna, ɓare kaɓi ale yeho. Umë w̃aruŋëɗëho hwëta koryi ỹa do nufaɗëho ile hwëtëɗeho hnam ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu më ntehnëk: «Tavëryina ƴam! Kwëtëhnëko iỹi ɗatikola pëhwëtanëhnahno soŋe fac ile vañandeɓu ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nkelandun kwëlëkwël vëhaỹëhnah va; ɓare ami, gelandelënëhna kwëlëkwël.» ");
INSERT INTO cou_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ga njëtayik Yesu Betani hna nkeho, wasëwif wayaɓah njiniho njëkiniha do njëkiniha fëna Lasar nte mbëhnëndanëko ŋa. ");
INSERT INTO cou_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Awa vësankaf vësëna wasaɗëha va më pëhnani ndaw̃ehnëniha Lasar fëna, gë Yesu ka, ");
INSERT INTO cou_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kaɓi, soŋe lëw̃u ỹa, wasëwif wayaɓah tavënihëhni vëhni do kwëtahnëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ga pacëk, kore yaɓah yeho Yerusalem hna soŋe ambënt Pak ŋa. Më yëtayik Yesu nkejëk. ");
INSERT INTO cou_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Awa vahnë va më nufëni yaryef vapëmb kacaniha do ndekandëni: «Osana! Cëmbik W̃ën! Araɓi W̃ënu ŋa njëɗa ale yijëɗ g'uw̃ac Ahwëhn a! Araɓi W̃ënu ŋa njëɗa ahnaw̃ Isërayel a!» ");
INSERT INTO cou_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu fapali tëkatëko, më kaƴëka, gante pëƴahnëk Vikerëh ka: ");
INSERT INTO cou_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Antë ntaki, naw̃ Siỹo, kaɓi ahnaw̃ hu ỹa nkejëk ƴaŋ fapali.» ");
INSERT INTO cou_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hnë wati rac, vërëfal vëlëw̃u va vëyëtëlohna bi ye pëhnëtanëɗ waŋi wanës; ɓare ante tufahnëko Yesu inaỹ dëw̃u ŋa, më ndënkwëtani vëỹin keriko soŋe lëw̃u ỹa do ntinëhniko ile heriko ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Fop vële nkeniho gë Yesu ante macëkawo Lasar cahni ƴag hna, mbëhnëndana ŋa, tëfëtaɗëniho ile nuniho ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Soŋe rac njijëɗëniho kore ỹa ỹalu hna, kaɓi dahëse fëmpëhnahnah rac ntiko. ");
INSERT INTO cou_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Awa wafarise w̃a më ntehnëlëɗëni: «Nurun, ñoñ mëkëɗelënëhna: vahnë va fop umë fo tëfëlehnëɗëni!» ");
INSERT INTO cou_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hnë vële yijëko Yerusalem soŋe cëmbëniha W̃ën hn'ambënt hna, nkentiniho fëna vële wok vëyena wasëwif. ");
INSERT INTO cou_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Vërac më tëhaniha Filip, nte yeho avë nkol Betësayida mbë resiỹo Galile, do tëƴëniha: «Ñaɗëfun hnufuna Yesu.» ");
INSERT INTO cou_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip më njik pëƴahna Andëre, tac vëhni vëhi tak njilehnëni pëƴaniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Umë, më ntehnëk: «Wati ỹa tëkëk le tënkëɗ Ajë Ahn'a hn'inaỹ dëw̃u hna. ");
INSERT INTO cou_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Toña ỹa fëƴaɗëmu: uỹëc antimp ule hnaɗik w̃a ge cëmëna, ỹëc ryampo fo woɗ, ɓare ge cëmëk, ntëw̃ëɗ waŋëc waƴaɓah. ");
INSERT INTO cou_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ale ỹaɗ iỹi ɗuniỹa ỹi cëmëɗ, ɓare ale wok kwëtahnëna nëf iỹi ɗuniỹa ỹa nkoryaryëɗ ntaw̃ary dëw̃u ŋa hafo uwám usër hna. ");
INSERT INTO cou_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ge ahnë kahnëndak ndokuŋëhnëndo, araɓi tëfëndo. Hn'ile nkeɗëfu hna, aryokuŋ mën a fëna hnam nkeɗ. Do ge ahnë ndokuŋëhnëɗëho, Rëm mën ỹa ntënënëɗëha.» ");
INSERT INTO cou_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu më mbok nkwënëk: «Tame hn'ile nkeɓu li, ndëñëɓu; ƴëtëla ile hnahaɗëfu. Lehnu bi: Apa, pehëtërye hnë iỹi wati horot? Ɓare soŋe iỹi wati yijëɓu. ");
INSERT INTO cou_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Apa, tufahnëry inaỹ hu ŋa.» Awa, kopa nkwëryëlehni mati g'ambin: «Tëkëɓu rufahnu icëmb mën iŋa do mbokëɗëfu rufahnu kat.» ");
INSERT INTO cou_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Vahnë vële yeho hnam va, do wëryëko kopa va, vëryampo ntehnëɗëniho farat lëhak. Vëhaw̃ary ntehnëɗëniho mëleka hnësëhnëka takan. ");
INSERT INTO cou_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu më ntehnëkëhni: «Gena soŋe lëmën nësëk iỹi kopa, ɓare soŋe lëw̃ hun ye. ");
INSERT INTO cou_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tame nke wati ile kitiŋande iỹi ɗuniỹa ỹa. Ha, tame ntaɗe Sintani, ale w̃ëkëk iỹi ɗuniỹa ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Do ami, ge njeliɓu vahnë va fop tëhaɗëniho.» ");
INSERT INTO cou_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Gë wanës watac, tufahnëɗëho Yesu sifa cëm nte ñaɗ cëm ŋa. ");
INSERT INTO cou_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Vahnë va më ntëkwaniha: «Sariya ỹa karaŋëkëfu Arëhnayik a cëmëɗina. Awa, hak koɗu alehn Ajë Ahn'a njelëɗe? Mo ye aỹi Ajë Ahnë?» ");
INSERT INTO cou_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Awa Yesu më ntëkwakëhni: «Humpen ha gë w̃uhnë nkok ten, soŋe wëwati toƴe: ƴasëryin wati nte kwëhnarun humpen ha, soŋe antë umëhwëry ŋa memaỹehnu; ale yasëɗ hn'umëhwëry hna ƴëtëna hn'ile njiɗ. ");
INSERT INTO cou_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Awa kwëtahnëryin humpen ha wati nte kwëhnarun ŋa, ayehahnu w̃uhnë dënk vutah humpen.» Ante nësëko watac ŋa, Yesu njiko, cow̃akëhniwo. ");
INSERT INTO cou_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu ntiko wëdahëse waƴaɓah tase lëw̃ hni, ɓare vahnë va vëhwëtahnëlawohna. ");
INSERT INTO cou_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Koyëna ntiyaɗëho wanës kila le w̃aciko Esayi ỹa ante nësëko: «Ahwëhn, mo hwëtahnëk wanës fu ŋa? Mo tufëk Ahwëhn a fanka falëw̃u fa?» ");
INSERT INTO cou_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Esayi mboko pëƴahn kat, soŋe vële wok vëhwëtahnëɗina va, ntehn: ");
INSERT INTO cou_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«W̃ënu ŋa mëpëndanëkëhni, antë nundëni; piɗëkëhni wahakili w̃a, antë nkwëryëndëni walaw̃ary walëw̃ hni hna; soŋe rac vëhoɗina cahëtani gë ỹalu do koɗina njërënëhni.» ");
INSERT INTO cou_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Soŋe Yesu ỹa nësëko Esayi kaɓi nuko inaỹ dëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wëla hnë vësankaf wasëwif hna dënk, vëyaɓah kwëtahnënihawo Yesu; ɓare vëryëkëɗilohna tufahnëni, kaɓi ntakëkëhniwo gë wafarise w̃a antë ntanihëhni caliŋa hna. ");
INSERT INTO cou_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paryi nke cëkwary vahnë fecehnëkëhniwo gë cëkwary mba W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ndekako: «Ge ahnë kwëtahnëko, gena ami fo kwëtahnëk, ɓare kwëtahnëka ale faƴiko ỹa fëna. ");
INSERT INTO cou_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ge ahnë nuko, nuka ale faƴiko ỹa fëna. ");
INSERT INTO cou_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ami had humpen njijëɓu ɗuniỹa li, soŋe ale-wo-le hwëtahnëko ỹa antë nko hn'umëhwëry hna. ");
INSERT INTO cou_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Ge ahnë nkwëryëk wanës mën ŋa do dil ile hnësëɓu ỹa, gena ami hitiŋëɗëha, kaɓi gena had ahitiŋ vahnë labëw̃ëhni hnë janáma yijëɓu, fehëtëw̃ëhni yijëɓu. ");
INSERT INTO cou_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Awa ale w̃ëỹëko do yafëk wanës mën ŋa tëk nuỹahna ahitiŋ alëw̃u ỹa: waŋi wanës wante hnësëɗëfu ŋi dënk ye; kitiŋëɗëha ntaba janáma fac rëkwa hna. ");
INSERT INTO cou_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ƴëtëryin, gena fër mën hnësëɓu: Rëm, le faƴiko ỹa, umë dënk yëɗako ile rëfëko hnësu do haraŋëw̃ëhni vahnë ỹa. ");
INSERT INTO cou_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Do njëtëɓu ɗus: ikaraŋ vahnë nte kwëtehnahnëko Rëm ŋa ryënëɗ uwám usër hna. Awa ile hnësëɗëfu ỹi, ile ntehnëko Rëm mën ỹa fo ye.» ");
INSERT INTO cou_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Fac rëkwa ỹa yeho tëkahnind fac ambënt Pak ŋa. Yesu njëtëko wati ile matëɗ ɗuniỹa mboka gë vëhni Rëmu ỹa tëkëk. Ñaɗëhëhniwo vëlëw̃u va vële ye ɗuniỹa vi do ñaɗëhëhni hafo hn'ile tëkwëk hna. ");
INSERT INTO cou_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu gë vërëfal vëlëw̃u va roka Pak ỹa tokëɗëniho. Sintani tëko tënka Yuɗa, aju Simo Isëkariyot, soŋe tokahna Yesu do njëɗahna. ");
INSERT INTO cou_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu njëtëko Rëm ỹa fop njëɗaka, ỹalu hna matiko do hnam mbokaɗ. ");
INSERT INTO cou_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Më matëk hn'ile tokëɗëniho hna, cuɗëta cuɗ cankaf ŋa do nuf ipand pala. ");
INSERT INTO cou_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tac kota w̃ënka hn'ancëhn, pëgwëlehn gwëyëtëndëhni vërëfal vëlëw̃u va wakwër ŋa, do pëhwëcëndëhni g'ipand nte palako ŋa. ");
INSERT INTO cou_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ga tëkëk vëhni Simo Piyer hna, më ntehnëka: «Ahwëhn, wëjë bi ỹaɗ awëyëto ami wakwër ŋi?» ");
INSERT INTO cou_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu më ntëkwaka: «Ile liɗëfu ỹa, nkwëryëɗila gaki, ɓare ge mbiỹëk toƴe nkwëryëɗu.» ");
INSERT INTO cou_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer më ntëkwaka: «Hali! gwëyëtëɗilihohna muk!» Yesu më ntehnëka: «Ge gwëyëtëlihna goɗila arëfal mën.» ");
INSERT INTO cou_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simo Piyer më ntehnëka: «Awa, Ahwëhn, ant'awëyëto wakwër ŋi fo, ɓare wëɓák ŋi g'ankaf per!» ");
INSERT INTO cou_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu më ntehnëka: «Ale yaryak a pacëka mbahn iŋa fop, wakwër ŋi fo gwëyëtaɗ. W̃uhnë, pacërun ɓare gena w̃uhnë fop.» ");
INSERT INTO cou_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hara Yesu njëtëkawo ɗus ale rokaɗëha ỹa. Soŋe rac ntehnahnëko: «Gena w̃uhnë fop facëk.» ");
INSERT INTO cou_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ga puhnakëhni gwëyët wakwër ŋa, Yesu më mbokëryak cuɗ ntëw̃u ŋa, mboka ntaña. Awa më ntehnëkëhni: «Njëtërun bi ile limu ỹi? ");
INSERT INTO cou_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Macëɗunëho “Aharaŋ” do “Ahwëhn”, do toña hwëhnarun, kaɓi umë yeɓu. ");
INSERT INTO cou_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Awa, ge ami, Ahwëhn a do gë Aharaŋ a, gwëyëtëmu wakwër ŋa, w̃uhnë fëna tëfëku awëyëtëlu. ");
INSERT INTO cou_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dahëse yëɗamu alihahnëndu w̃uhnë fënali gante ntinëhnëmu ki. ");
INSERT INTO cou_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Toña ỹa fëƴaɗëmu: aryokuŋ dëbëlahna ale ndokuŋënda do ale faƴik dëbëlahna ale faƴëka ỹa. ");
INSERT INTO cou_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tame njëtërun waŋi; nëfaɗëhu ge ntirun koyëna. ");
INSERT INTO cou_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Gena w̃uhnë fop lehnëɗëfu; njëtëɓuhëhni ɗus vële rëhnaɓu va. Ɓare afo waŋi wanës Vikerëh ntiya: “Ale sehëlëɓun mburu mën ŋa ñew̃ëko tame.” ");
INSERT INTO cou_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«Pëƴaɗëmu watac tame, ani gë tëkahnind, koyëna ahwëtahnahnu ge tëkik “ale ye ỹa yeɓu”. ");
INSERT INTO cou_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Toña ỹa fëƴaɗëmu: ale-wo-le hacaka ale faƴëɓu ỹa kacako ami fëna; do ale-wo-le hacako ỹa, kacaka ale faƴiko ỹa fëna.» ");
INSERT INTO cou_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ga nësëk watac, Yesu ndëñëko më ntehnëk: «Toña ỹa fëƴaɗëmu: aryampo hnë w̃uhnë tokaɗëho.» ");
INSERT INTO cou_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vërëfal va më njëkëlëni, hara vëyëtëna wëla toƴe ale ntehnëɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Arëfal ale ñaɗëho Yesu ɗus ỹa ɗarël lëw̃u ntañako hn'ile tokëɗëniho hna. ");
INSERT INTO cou_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simo Piyer më ndëkwanëka arëfal arac tëƴa Yesu bi soŋe mo nësëɗ. ");
INSERT INTO cou_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Awa arëfal a më tankak gë cape Yesu do tëƴa: «Ahwëhn, mo ye?» ");
INSERT INTO cou_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu më ntëkwaka: «Koƴëɗëfu mburu ŋi nëhët li: ale yëɗaɗëfu ỹa, umë ye.» Awa Yesu më nufëk mburu ŋa, koƴëk, do njëɗahna Yuɗa, aju Simo Isëkariyot. ");
INSERT INTO cou_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Teɓand tuŋ Yuɗa mburu ŋa, Sintani tënkëlehna. Awa Yesu më ntehnëka: «Ile ỹaɗu ali ỹa, diry ñap!» ");
INSERT INTO cou_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wëla aryampo hnë vële ntañalahnëniho va ƴëtëlohna bi soŋe ye ntehnëka koyëna. ");
INSERT INTO cou_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kaɓi Yuɗa hwëtëɗëho koryi ỹa, vëryampo ntiyahnëkëhniwo Yesu nji ntaw̃i ile valëɗëhëhni soŋe mbënt ŋa ntehnëɗëha, ma nji njëɗahni iñë vëhaỹëhnah va. ");
INSERT INTO cou_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Awa Yuɗa më teɓak mburu ŋa cahnëlehn taŋ. Mëɗëko. ");
INSERT INTO cou_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ante cahnëk Yuɗa ŋa, Yesu më ntehnëk: «Tame Ajë Ahn'a tufahnëɗ inaỹ dëw̃u ŋa do inaỹ W̃ënu ŋa tufahnëɗe hnë umë ");
INSERT INTO cou_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ge inaỹ W̃ënu ŋa tufahnëɗe hnë umë awa W̃ënu ŋa tufahnëɗ inaỹ Ajë Ahn'a hnë umë, do ntiɗ umë, ɓiỹëɗina. ");
INSERT INTO cou_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","«Vutah mën, wëwati toƴe fo wolahnëɗen. Rëkëɗun ayëkëlehnënduno, ɓare ntehnëɗëmu tame ile lehnëɓuhëhni vësankaf wasëwif va: koɗiluhna ayiwu hn'ile njiɗëfu hna. ");
INSERT INTO cou_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","«Njëɗaɗëmu akwëɗa kasëk: ŋahnëlëryin. Afo aỹahnëlu gante ŋahnëmu ki. ");
INSERT INTO cou_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ge ŋahnëlërun, awa vahnë va fop njëtëɗëni vërëfal mën yerun.» ");
INSERT INTO cou_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Piyer më tëƴëka: «Ahwëhn, ne njiɗu?» Yesu më ntëkwaka: «Koɗila arëfo tame hn'ile njiɗëfu hna, ɓare tëfëɗuho hnam fac ryaw̃.» ");
INSERT INTO cou_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer më ntehnëka: «Ahwëhn, soŋe ye ye koɗa rëfi tame? Pëhwëtaɓu sëmu soŋe lëw̃ hu ỹa!» ");
INSERT INTO cou_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu më ntëkwaka: «Paryi bi pëhwëtaru asëm soŋe lëmën ỹa? Awa ami, pëƴaɗëmi toña ỹa: hnë uŋi mëɗ dënk, ani gë tarahnënd cale ŋa, njahëtaɗu wahwënta warar ƴëtëlihohna.» ");
INSERT INTO cou_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tac Yesu më ntehnëkëhni vërëfal vëlëw̃u va: «Antë aryëñu. Kwëtahnëryina W̃ënu ŋa do kwëtahnëryino ami fëna. ");
INSERT INTO cou_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hnë tere Rëm mën hna, vacery va njaɓëk ɗus do njiɗëfu fëhwëtëhnu hn'ile ntëɗëɗun hna. Ge gekëndina toña, nësëhnakëndiluhna koyëna. ");
INSERT INTO cou_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Do ge njiɓu fëhwëtëhniwu ỹëw̃a ỹa, mbokajëɗëfu yowu, ayentahniw̃u w̃uhnë fëna hn'ile nkeɓu hna. ");
INSERT INTO cou_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Njëtërun nkaw̃ nte yiɗ hn'ile njiɗëfu hna.» ");
INSERT INTO cou_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma më ntehnëka: «Ahwëhn, ƴëtëlëfuhna hn'ile njiɗu hna. Hak koɗëfun yëtëfu nkaw̃ ŋa?» ");
INSERT INTO cou_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu më ntëkwaka: «Ami ye nkaw̃ ŋa, toña ỹa do gë haƴalin sël ntaw̃ary, uwám paryi w̃a. Koɗena tëki Rëm hna, ge gena hnë ami tëfik. ");
INSERT INTO cou_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ge njëtërunëho njëtërunëha Rëm mën ỹa fëna. Ƴëtëryin tëkërun ayëtuna, do nurunëha fëna.» ");
INSERT INTO cou_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip më ntehnëka: «Ahwëhn, tufëryifuna Rëm ỹa do gwër nkeɗëhëfu.» ");
INSERT INTO cou_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu më ntëkwaka: «Mbiỹëk ga nkelahninëk gë w̃uhnë do ƴëtëlihohna ten, Filip? Ale hnuko ỹa, nuka Rëm ỹa. Awa soŋe ye lehnëɗu: “Tufëryifuna Rëm ỹa”? ");
INSERT INTO cou_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kwëtahnëlihna bi Rëm ỹa g'ami aryampo yeɓun? Wanës wante hnësëhnëɗëmu w̃uhnë ŋi matiɗina hnë ami. Rëm ỹa lëɗëk hnë ami umë dënk liɗ waɗoku wadëw̃u ŋa. ");
INSERT INTO cou_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kwëtahnëryino ge ntehnëɗëmu: Rëm ỹa gë ami aryampo fo yeɓun. Ma, ge ntakahnëku, awa kwëtahnëryin wëla soŋe le hnurun waɗoku mën ŋi fo. ");
INSERT INTO cou_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Toña ỹa fëƴaɗëmu: ale hwëtahnëko ỹa, umë fëna ntiɗ viỹë vifëmpëhnahnah gë vile liɗëfu ki. Ntiɗ dënk wante ỹak hnaỹëk, kaɓi gë Rëm ka njiɗëfu. ");
INSERT INTO cou_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Do ntiɗëfu fop ile rëƴëɗun g'uw̃ac mën ỹa, soŋe nuhahni inaỹ Rëm ŋa Aju hna. ");
INSERT INTO cou_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ge tëƴërunëho iñë g'uw̃ac mën w̃a, ntiɗëfu. ");
INSERT INTO cou_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ge ñaɗunëho ntënënëɗun vakwëɗa mën va. ");
INSERT INTO cou_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tëƴëɗëfuha Rëm ỹa do njëɗanahniɗëhuna ahaw̃ary njij ndemawu, soŋe nkehahn kwëlëkwël gë w̃uhnë. ");
INSERT INTO cou_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Umë ye ale rufahnëɗ Iƴir toña ŋa. Ɗuniỹa ỹi koɗina kacahna, kaɓi koɗina nuhna ma njëta. Ɓare w̃uhnë, njëtërunëha kaɓi gë umë aryampo yerun do hnë w̃uhnë nkeɗ kwëlëkwël. ");
INSERT INTO cou_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tavëɗiluhna w̃uhnë fo had vukëryëm; mbokajëɗëfu ɗarël hun. ");
INSERT INTO cou_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɓiỹëɗina ɗuniỹa ỹi ɓokëɗina nuwo, ɓare w̃uhnë, mbokëɗun ahnuwuno, kaɓi mbëhnëɗëfu do w̃uhnë mbëhnëɗun. ");
INSERT INTO cou_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Fac rac, njëtëɗun Rëm ỹa g'ami aryampo fo yeɓun, w̃uhnë gë ami aryampo fo yeyinëk fëna. ");
INSERT INTO cou_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ale yaw̃ënëk vakwëɗa mën va do ntind ile nësëk ỹa, umë ye ale ỹaɗëho ỹa. Rëm mën ỹa ŋahnëɗëha ale ỹahnëɗëho ỹa; ŋahnëɗëfuha ami fëna do tufëhnaɗëfuha.» ");
INSERT INTO cou_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuɗ (gena Yuɗa Isëkariyot) më tëƴëka: «Ahwëhn, soŋe ye rufëhnaɗuhëfu fuhnë fo hara gena ɗuniỹa ỹi?» ");
INSERT INTO cou_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu më ntëkwaka: «Ale ỹaɗëho ỹa ntënënëɗ ile hnësëɗëfu ỹa. Rëm mën ỹa ŋahnëɗëha; do njijëɗëfun lëɗëfu ỹalu hna. ");
INSERT INTO cou_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ale wok ñaɗilohna ỹa dënënëɗina wanës mën ŋa. Ile wëryëɗun hnësëɗëfu ỹi matiɗina ỹalë mën, ɓare Rëm mën le faƴiko hna matiɗ. ");
INSERT INTO cou_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Wati nte nkolahninëk ten ŋi pëƴamu waŋi. ");
INSERT INTO cou_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tac Iƴir Ipacah nte paƴiɗ Rëm g'uw̃ac mën ŋa, yijëɗ ndemawu. Karaŋëɗëhu fop do ndënkwëtendëhu fop ile hnësëhnëɗëmu ỹi. ");
INSERT INTO cou_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ƴam ỹa ravëhnëɗëmu, ƴam mën ỹa yëɗaɗëmu. Gena gante njëɗahnëɗ ɗuniỹa ki njëɗaɗëmu. Antë aryëñu, antë ntaku. ");
INSERT INTO cou_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","«Nkwëryërunëho ga pëƴamu: “Njiɗëfu, ɓare mbokajëɗëfu ỹalun hna.” Ge ŋahnërunëho, natëɗëhu soŋe ile yëtërun Rëm hna njiɗëfu, kaɓi Rëm ỹa hnaỹëk ntëbo ami. ");
INSERT INTO cou_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gaki pëƴaɗëmu, ani gë tëkahnind vëỹin, soŋe ge tëkik ahwëtahnahnuno. ");
INSERT INTO cou_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ɓokëɗa hnësëhnu yaɓah, kaɓi ale w̃ëkëk iỹi ɗuniỹa ỹa nkejëk. Kwëhnana fanka g'ami, ");
INSERT INTO cou_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ɓare afo ɗuniỹa ỹa njët ñaɗëfuha Rëm ỹa do gante ntehnëko rëm mën ka ntiɗëfu. Matëryin, njiyin!» ");
INSERT INTO cou_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu mboko ntehn: «Ami ye atëh resen paryi ŋa do Rëm mën ỹa ye ayam a. ");
INSERT INTO cou_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ntihëtëɗ hni le-wo-le ye hnë ami wok dëw̃ëɗina ỹa, do hni le-wo-le lëw̃ëɗ ỹa parëɗe pacënahn ntëw̃ahn g'ahaw̃ary. ");
INSERT INTO cou_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","W̃uhnë, tëkërun afacu had hni le farik: karaŋ nte haraŋëmu ŋa facënëku. ");
INSERT INTO cou_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Goryin hnë ami, gante nkeɓu hnë w̃uhnë ki. Hni atëh koɗina ntëw̃ umë fo, ge gona tëh hna. Ndampo fo nke, koɗiluhna alëw̃u ge goluhna hnë ami. ");
INSERT INTO cou_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ami ye atëh ŋa, w̃uhnë ye wahni w̃a. Ale wok kwëlëkwël hnë ami, do wowu kwëlëkwël hnë umë, ntëw̃ëɗ ɗus. Hamëhni mën ñoñ koɗiluhna aliwu fërën. ");
INSERT INTO cou_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ale wok gena hnë ami kwëlëkwël ỹa canëɗe g'ipër, had hni lihëtik, do kankëɗ; sifa warac mbarëpëɗe ntabi gë hwëɗëh, do ŋagëɗ. ");
INSERT INTO cou_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ge hnë ami nkorun kwëlëkwël do wanës mën ŋa nko hnë w̃uhnë, tëƴëryin ile ỹaɗun ỹa do ntiɗëfu. ");
INSERT INTO cou_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ge ntëw̃ërun ɗus tufahnëɗun vërëfal mën paryi va yerun. Rac ye ile rufahnëɗ inaỹ Rëm mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Gante ŋahnëɗëho Rëm mën ka, koyëna ŋahnëɗëmu ami fëna. Goryin iŋahn mën hna. ");
INSERT INTO cou_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ge maw̃ërun vakwëɗa mën va, iŋahn mën hna nkorun, gante maw̃ëɓu ami vakwëɗa Rëm mën ki do nkoɓu hn'iŋahn dëw̃u ki. ");
INSERT INTO cou_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Pëƴamu waŋi hnatah mën w̃a nkehahn hnë w̃uhnë do hnatah hun w̃a padahn. ");
INSERT INTO cou_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wëlin kwëɗa mën ŋa: ŋahnëlëryin gante ŋahnëmu ki. ");
INSERT INTO cou_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iŋahn nte ỹak hnaỹëk ante koɗ tufahn ahnë ŋa, umë ye, cëm soŋe wëlawo walëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wëlawo mën yerun ge ntiɗun ile lehnëmu ỹa. ");
INSERT INTO cou_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ɓokëɗa w̃acu vëryokuŋëhn mën, kaɓi aryokuŋ a ƴëtëna ile ntiɗ ale ndokuŋëhnëɗa. Tame, lawo w̃acëɗëmu, soŋe umë ye njëtëndanëmu fop ile ỹëŋajëɓu vëhni Rëm mën ỹa. ");
INSERT INTO cou_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gena w̃uhnë rëhnako, ami rëhnaku; paƴëmu ayiwu aliwu viỹë vifërën, viỹë vile vëỹëɗ. Awa, Rëm ỹa ntinëndëhu fop ile rëƴëɗunëha g'uw̃ac mën w̃a. ");
INSERT INTO cou_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ha, ile lehnëɗëmu ỹa, aỹahnëlu ye.» ");
INSERT INTO cou_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu më mbok nkwënëk: «Ge ɗuniỹa ỹi ñew̃ëku ƴëtëryin ami ndënkwëk ñew̃ëk. ");
INSERT INTO cou_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ge ɗuniỹa ỹi hwëhnakëndëhu, ŋahnakëndëhu kaɓi umë hwëhnëku. Ɓare tëhnamu do canëmu ɗuniỹa hna, do gona kwëhnu ɗuniỹa ỹi. Soŋe umë ñew̃ahnëku ɗuniỹa ỹi. ");
INSERT INTO cou_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ndënkwëtaɗun bi ile lehnëmuno ỹa: “Aryokuŋ dëbëlahna ale ndokuŋëhnëɗa.” Ge vahnë va korotehnëniho, koroteyehnëɗënihu w̃uhnë fëna; ge maw̃ëni wanës mën ŋa, maw̃ëɗëni wanës hun ŋa fëna. ");
INSERT INTO cou_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Soŋe lëmën korotehnandënihu koyëna, kaɓi vëyëtëlahna ale faƴiko ỹa. ");
INSERT INTO cou_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ge ƴijakënda do ge nësëhnakëndëw̃ëhnihna vëlehnakëndena menëni. Ɓare gena koyëna. Awa tëfëka maw̃ani w̃eh le ntini ỹa. ");
INSERT INTO cou_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ale ỹew̃ëko ỹa, ñew̃ëka Rëm mën ỹa fëna. ");
INSERT INTO cou_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vëlehnakëndena menëni ge dikënda tase lëw̃ hni waɗoku wante nkok koɓëri ahnë ahaw̃ary dina. Ɓare gena koyëna. Awa, wëla gante nuni ɗoku mën ki, ñew̃ënihëfu, ami gë Rëm mën ỹa. ");
INSERT INTO cou_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɓare watac tëkiɗ ntiyahn wanës wante herik Vikerëh vidëw̃ hni ŋa: “Ñew̃ëniho toña këm fo.” ");
INSERT INTO cou_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Ale rëfëka ndemawu ỹa njijëɗ: Iƴir nte rufahnëɗ toña ỹa ye. Rëm mën hna matiɗ, cañëtëhniɗëmuna do njijëɗ nkenëhno seɗe. ");
INSERT INTO cou_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Do w̃uhnë fëna, nkenëhnëɗunëho seɗe, kaɓi g'ami nkentirunëho koɓëri wapëgwa hna.» ");
INSERT INTO cou_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Pëƴamu watac soŋe antë aravu kwëtahn hun ŋa. ");
INSERT INTO cou_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ntaɗerun vacaliŋa hna. Do dënk, wati yejëk vële ryaw̃ëɗëhu va ntiyahnëɗëhëhni W̃ënu ŋa ndokuŋëhnëɗëni koyëna. ");
INSERT INTO cou_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ntiɗëni viỹë virac kaɓi vëyëtëlahna Rëm ỹa, vëyëtëlohna ami fëna. ");
INSERT INTO cou_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pëƴamu waŋi soŋe, ge wati ỹa tëkëk, aryënkwëtahnu pëƴamuno.» Yesu më mbok nkwënëk: «Pëƴalunohna waŋi koɓëri wapëgwa hna, kaɓi nkolahninëko. ");
INSERT INTO cou_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tame ƴiŋa yeɓu ɗarël hnë ale faƴikow̃o hna do wëla aryampo hnë w̃uhnë tëƴëlohna hn'ile njiɗëfu hna. ");
INSERT INTO cou_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Uyiw̃ëhnah w̃a pëɓëlehnëku kaɓi koyëna nësëhnëmu. ");
INSERT INTO cou_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Toña ỹa fëƴaɗëmu: yiwu fecek soŋe lëw̃ hun. Ge ƴila, ale rëfëka faƴiw̃ njij ndemawu ỹa ƴijëɗina, ɓare ge njiɓu paƴiɗëfuha. ");
INSERT INTO cou_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iƴir Ipacah ŋa njëtëndanëɗëhëhni vahnë vëvë iỹi ɗuniỹa vi toña ỹa soŋe wameh ŋa, soŋe ile satëk ỹa do soŋe ikitiŋ W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Soŋe wameh ŋa tufëɗëhëhni vëhwëtahnëlohna; ");
INSERT INTO cou_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","soŋe satah ỹa tufëɗëhëhni ƴiŋa yeɓu gë Rëm ka, do ɓokëɗiluhna ahnuwuno; ");
INSERT INTO cou_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","soŋe kitiŋ ŋa tufëɗëhëhni ale w̃ëkëk iỹi ɗuniỹa ỹa tëk kitiŋi. ");
INSERT INTO cou_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Nkoryaryëɓu viỹë viyaɓah vile rëfëka hnësëhnu, ɓare mëkëɗiluhna awëryu gaki. ");
INSERT INTO cou_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ge njijëk Iƴir toña ŋa, karaŋëɗëhu ayëtu toña ỹa fop. Gena g'uw̃ac lëw̃u rëkëɗ nësëhnëndu, ɓare fop ile nkwëryëɗ ỹa rëkëɗ nësënd do pëƴaɗëhu ile rëfëka ntiya ỹa. ");
INSERT INTO cou_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nuỹaɗ uyët ule hwëhnaɓu w̃a do pëƴaɗëhu koyëna tufahnëɗ inaỹ mën iŋa. ");
INSERT INTO cou_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fop ile kwëhnak Rëm mën ỹa kwëhnëntiɓu. Soŋe umë lehnahnëɓu Iƴir iŋa nuỹaɗ uyët ule hwëhnaɓu, ami ỹa, do pëƴaɗëhu.» ");
INSERT INTO cou_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu më mbok nkwënëk: «Ani gë wëwati toƴe ɓokëɗiluhna ahnuwuno, tac kat wëwati toƴe mbokëɗun ahnuwuno.» ");
INSERT INTO cou_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Awa vërëfal vëlëw̃u vëryampo ntehnëlëɗëniho: «Ye ga ye waŋi wanës? Ntehnëɗëhëfu ani gë wëwati toƴe ɓokëɗilëfuhna hnufuna, tac kat wëwati toƴe mbokëɗëfun hnufuna do ntehnëk fëna kaɓi Rëm hna njiɗ ye. ");
INSERT INTO cou_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ye ga ye iỹin “ani gë wëwati toƴe” ile nësëɗ ỹi? Ƴëtëlëfuhna bi ye ñaɗ nës.» ");
INSERT INTO cou_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu më njëtak tëƴëniha ñaɗëni. Awa më ntehnëkëhni: «Pëƴamu: ani gë wëwati toƴe ɓokëɗiluhna ahnuwuno, tac kat wëwati toƴe mbokëɗun ahnuwuno. Soŋe watac bi rëƴëlëɗun? ");
INSERT INTO cou_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Toña ỹa fëƴaɗëmu: rëkëɗun ahondu do ayahnandu hara ɗuniỹa ỹi hnatah hna nkeɗ. Uyiw̃ëhnah hna nkeɗun, ɓare uyiw̃ëhnah lëw̃un w̃a mbacaɗ hnatah. ");
INSERT INTO cou_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ge asëval nagëɗ, uyiw̃ëhnah hna nkeɗ kaɓi wati horot lëw̃u ỹa rëkik ỹalu hna, ɓare ge fatah fa nagik, ndënkwëɗ horot ỹa kaɓi natëɗëha soŋe ile nagik fatah hnë ɗuniỹa ỹi. ");
INSERT INTO cou_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ndampo fo nke, tame uyiw̃ëhnah hna nkerun, w̃uhnë fëna; ɓare mbokëɗen nulin, awa wati rac ntaw̃ary hun ŋa pëɓëɗëha hnatah rac ahnë koɗina ntihëtu. ");
INSERT INTO cou_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ge tëkik fac rac, ɓokëɗiluhna arëƴuno iñë. Toña ỹa fëƴaɗëmu: Rëm ỹa njëɗaɗëhu fop ile rëƴëɗunëha g'uw̃ac mën w̃a. ");
INSERT INTO cou_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hafo iỹi wati, ñoñ tëƴëluhna ten g'uw̃ac mën. Tëƴëryindën do nuỹaɗun, do koyëna hnatah hun w̃a padëɗ.» ");
INSERT INTO cou_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu më mbok nkwënëk: «Gë wahnës waɗindaryindan nësëhnëmu waŋi fop. Wati yejëk hn'ile nkoɗëmu ɓokëla hnësëhnu aki, ɓare nësëhnëɗëmu wapacëk soŋe Rëm mën ỹa. ");
INSERT INTO cou_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Fac rac, g'uw̃ac mën w̃a tëƴëɗunëha Rëm mën ỹa ile valëɗëhu ỹa do njëɗaɗëhu; dehnëɗiluhna ami rëfëka w̃untanëhnuna Rëm ỹa soŋe lëw̃un. ");
INSERT INTO cou_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Rëm ỹa umë dënk ñaɗëhu kaɓi ñaɗunëho do kwëtahnërun ỹalu hna matiɓu. ");
INSERT INTO cou_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ha, Rëm hna matiɓu do rëkiwu ɗuniỹa li. Tame matëɗëfu ɗuniỹa li do vokawu Rëm hna.» ");
INSERT INTO cou_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Awa vërëfal vëlëw̃u va më ntehnëniha: «Wëli, tame pacënëɗu wanës ŋa, nësëɗiliya gë wahnës waɗindaryindan. ");
INSERT INTO cou_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tame njëtëɓun njëtëru fop do ɓalëlihna ahnap ahnësëhni. Soŋe umë hwëtahnahnëɓun gë W̃ën matiru.» ");
INSERT INTO cou_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu më tëƴëkëhni: «Kwëtahnërun tame? ");
INSERT INTO cou_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ƴëtëryin, tametame ki campëɗun w̃uhnë fop, ale-wo-le mbokaɗ gë ỹalu do ami fo ravëɗun. Ɓare, gela ami fo paryi, kaɓi Rëm mën ỹa g'ami nkeɓun. ");
INSERT INTO cou_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«Nësëhnëmu waŋi fop soŋe ge hnë ami nkorun, ahnuỹawu ƴam ỹa. Korotëɗun ɗuniỹa li, ɓare ƴaw̃ënaryin! Mëkëɓu ɗuniỹa ỹi!» ");
INSERT INTO cou_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ante nësëk Yesu koyëna ŋa, më kaŋëk g'ambin do ntehn: «Rëm, wati ỹa tëkëk. Tufahnëry inaỹ Ajë hu ỹa, soŋe umë fëna tufahnahn inaỹ hu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Njëɗaruha ucankaf hnë vahnë vëvë ɗuniỹa hna fop, soŋe njëɗahni uwám ule wok puɗina vële hwëtehnahnëruha va. ");
INSERT INTO cou_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ye ga ye uwám ule wok puɗina? Umë ye ayëti wëjë ale ye wëjë fo W̃ën paryi, do yëtiwu ami, Yesu Këris, nte faƴiru ŋi. ");
INSERT INTO cou_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tufahnëfu naỹ hu ŋa nkal li, g'ipadën ɗoku ile yëɗaruhowo liwu ỹa. ");
INSERT INTO cou_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Awa tame, Apa, tufahnëry inaỹ inte hwëhnaɓuho ɗarël hu ani gë ntihahnënde ɗuniỹa ỹi. ");
INSERT INTO cou_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Antiɓu njëtënihi vële hnufëru hnë ɗuniỹa do ahwëtehnahnow̃ëhni va. Wëjë hwëhnëkëhni; ami kwëtehnahnëruhow̃ëhni, do maw̃ëni wanës hu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Njëtëni tame fop ile yëɗaruho ỹa ỹal hu hna matik, ");
INSERT INTO cou_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kaɓi pëƴaɓuhëhni wanës wante yëɗaruho ŋa do kacani. Njavëtëni paryi nke, ỹal hu hna matiɓu do kwëtahnëni paƴiruho. ");
INSERT INTO cou_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Soŋe lëw̃ hni w̃untaɗëmi. Muntaɗila soŋe ɗuniỹa ỹi, ɓare soŋe vële hwëtehnahnëruhow̃ëhni va, kaɓi wëjë hwëhnëkëhni. ");
INSERT INTO cou_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Fop ile hwëhnaɓu ỹa wëjë hwëhnëk do fop ile hwëhnaru ỹa ami hwëhnëk; do inaỹ mën ŋa hnë vankeya vapërën vantëw̃ hni hna tufëhnaɗ. ");
INSERT INTO cou_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tame tavëɗëfu ɗuniỹa ỹi, ɓare vëhni, ɗuniỹa hna nkoɗëni; ami, gë ỹal hu njiryiɗëfu. Apa facah, keryëryihni gë fanka w̃ac hu ile yëɗaruho ỹi, nkehahnëni aryampo fo gante nkeyik wëjë g'ami ki. ");
INSERT INTO cou_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Koɓëri ante nkeɓunëho gë vëhni ŋa, keryëɗëfuhëhniwo gë fanka, w̃ac hu ile yëɗaruho ỹa. Keryëɓuhëhni do wëla aryampo hnë vëhni cëvëna ge gena ale rëfëkawo cëv, soŋe ntiyahn Vikerëh va. ");
INSERT INTO cou_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Tame gë ỹal hu njiryiɗëfu. Nësëɗëfu vëỹin wati nte nkoɓu ɗuniỹa ŋi, kwëhnahnëni hnë vëhni dënk hnatah mën w̃a, hnatah fadah. ");
INSERT INTO cou_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pëƴaɓuhëhni wanës hu ŋa, do ɗuniỹa ỹa ñew̃ëkëhni kaɓi gena umë hwëhnëkëhni, gante nkok kwëhnëlohna ami ki. ");
INSERT INTO cou_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Muntaɗila alihëtëhni ɗuniỹa li, ɓare aheryëndëhni hnë viỹë Sintani hna. ");
INSERT INTO cou_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɗuniỹa ỹi kwëhnëlëhnihna, gante nkok kwëhnëlohna ami ɗuniỹa ki. ");
INSERT INTO cou_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Diry ahwëhnëhni wëjë fo, gë toña ỹa; wanës hu ŋa ye toña ỹa. ");
INSERT INTO cou_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Paƴëɓuhëhni ɗuniỹa hna gante paƴiruho hnë ɗuniỹa ki. ");
INSERT INTO cou_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Njëɗëmi nkaf mën ŋa soŋe lëw̃ hni ỹa, njëɗahnahnëni vëhni fëna vankaf vantëw̃ hni va hnë wëjë fo gë toña ỹa. ");
INSERT INTO cou_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Gena vëhni fo w̃untanëhnëɗëfu, ɓare fëna vële hwëtahnëɗëho ami hnë wanës wante pëƴahnëɗëni hna. ");
INSERT INTO cou_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Apa, muntaɗëfu soŋe fop nkehahnëni ndampo fo, nkentahnini gë fuhnë, gante nkeru wëjë hnë ami do ami nkeɓu hnë wëjë ki soŋe njëtahn ɗuniỹa ỹi paƴiruho. ");
INSERT INTO cou_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Njëɗaɓuhëhni inaỹ nte yëɗaruho ŋa, nkehahnëni aryampo fo gante nkeyik wëjë g'ami aryampo ki. ");
INSERT INTO cou_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hnë vëhni hna nkeɓu, hnë ami nkeru. Koyëna paryi nkeɗëni aryampo fo, soŋe njavëtahn ɗuniỹa ỹi paƴiruho do ñaɗuhëhni gante ñaɗuho ki. ");
INSERT INTO cou_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Apa, njëɗaruhow̃ëhni do ñaɗëfu nkeni hn'ile nkeɗëfu hna, nuhahnëni inaỹ mën iŋa. Njëɗaruho inaỹ iŋa kaɓi, ntihahnënde ten ɗuniỹa ỹi, ñaɗuhowo. ");
INSERT INTO cou_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Apa satah, ɗuniỹa ỹi ƴëtëlihna, ɓare ami njëtëmi do vëỹi njavëtëni paƴiruho. ");
INSERT INTO cou_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ntiɓu njëtënihi, vëhni, do ntiɗëfu kat njëtënihi g'ahaw̃ary, soŋe iŋahn nte hwëhnaru soŋe lëmën ŋi nkehahn hnë vëhni do yehahnu ami fëna hnë vëhni.» ");
INSERT INTO cou_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ante puhnak munta koyëna ŋa, Yesu njilehnëni gë vërëfal vëlëw̃u va gë cape ñëntaw̃ nkëɗ garyëla w̃ënka Sedëron ka. Tënkëlehnëni hnë sarëɗiŋ ile yeho hnam ỹa. ");
INSERT INTO cou_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hara Yuɗa, ale rokaɗëha ỹa, njëtëko ɗus sarëɗiŋ rac, kaɓi Yesu gë vërëfal vëlëw̃u va njiɗëniho hnam wati wati. ");
INSERT INTO cou_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Awa Yuɗa ndënkwaryëlehnëhni kore wasoɗaɗe w̃a gë vëyëka Cery W̃ën Cankaf va, vële njëɗanihawo vësankaf vësëna wasaɗëha va do gë wafarise w̃a, do tëkëni hnë sarëɗiŋ rac. Vësan vërac, viw̃ëta njoyaniho gë walampu do gë ile pëtehnahnëɗëniho. ");
INSERT INTO cou_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, umë ale yëtëko fop ile rëfëka nkehna ỹa, më kacakëhni do tëƴëhni: «Mo yëkëlehnëɗun?» ");
INSERT INTO cou_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Më ntëkwaniha: «Yesu mbë Nasaret.» Yesu më ntehnëkëhni: «Ami ye.» Fagant lëw̃ hni kahnëko Yuɗa, ale rokaɗëha ỹa. ");
INSERT INTO cou_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hnë wati nte ntehnëkëhniwo Yesu: «Ami ye», karëcalehnëni njoni nkal hna. ");
INSERT INTO cou_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu më mbok tëƴëkëhni kat: «Mo yëkëlehnëɗun?» Më mbok ntëkwani: «Yesu mbë Nasaret.» ");
INSERT INTO cou_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu më ntëkwakëhni: «Pëƴamu, ami ye. Kaɓi ami yinëhnirun, tavëryinëhni vëỹëntaw̃ vi njini.» ");
INSERT INTO cou_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Koyëna ntiyako wanës wante nësëko ŋa: «Rëm, wëla aryampo cëvaryëlow̃ahna vële hwëtehnahnëruhow̃ëhni hna.») ");
INSERT INTO cou_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wati rac Simo Piyer sëlame kwëhnako, pëhwëtëlehn, taw̃ahna dëpët nëf tëhw ŋa aryokuŋ asëna wasaɗëha asankaf a. Aryokuŋ arac, Malëkus maciko. ");
INSERT INTO cou_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Awa Yesu më ntehnëka Piyer: «Ɓokaryëry afëhw sëlame hu ỹi. Tëfëlohna bi sewu nkëlëw̃a tëmpah horot nte ñaryaryëɗëho Rëm mën ỹa?» ");
INSERT INTO cou_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Awa kore wasoɗaɗe w̃a gë asankaf a lëw̃ hni ỹa do gë vëyëka vësankaf wasëwif va pëlalehnëniha Yesu ñabëniha ");
INSERT INTO cou_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","do njiryeryëniha ten vëhni Anas hna, ayëlaw̃u Kayif, ale yeho asëna wasaɗëha asankaf a hnë bëhn rac. ");
INSERT INTO cou_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hara, Kayif tac yabëkëhniwo vësankaf wasëwif va pecek soŋe lëw̃ hni, cëm asan aryampo soŋe ɓulunda ỹi fop. ");
INSERT INTO cou_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Piyer gë arëfal aỹëntaw̃ tëfëlendënihawo Yesu. Arëfal aỹëntaw̃ arac njëtëlëniho gë asëna wasaɗëha asankaf a, do tënkëntiko ndampo fo gë Yesu selele vë ɓambery tere asëna wasaɗëha asankaf hna. ");
INSERT INTO cou_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyer, umë, për nkoko, ɗarël rënka hna. Awa arëfal aỹëntaw̃ a, ale njëtëlëniho g'asëna ỹa, më cahnik nësëhna asëval ale yëkaɗëho rënka ỹa, do ndëna Piyer. ");
INSERT INTO cou_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Awa asëval ale yëkaɗëho rënka ỹa më ntehnëka Piyer: «Gelihna bi, wëjë fëna, arëfal aỹi asan?» Më ntëkwaka: «Hali, gela.» ");
INSERT INTO cou_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hara vëryokuŋ va gë vëyëka va pëɗëniho hwëɗëh njerahnëndëni kaɓi huji ha njoko. Piyer fëna hnam njerantëɗeho. ");
INSERT INTO cou_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Awa asëna wasaɗëha asankaf a më tëƴëka Yesu soŋe vërëfal vëlëw̃u va gë karaŋ inte karaŋëɗëhëhniwo vahnë ŋa. ");
INSERT INTO cou_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu më ntëkwaka: «Hnë tase vahnë fop nësëɗëfuho. Kwëlëkwël karaŋëɗëfuhëhniwo vahnë va vacaliŋa hna do gë selele Cery W̃ën Cankaf hna, hn'ile mbarëpëlëɗëniho vahnë fop hna. Cow̃ëla muk wanës mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Soŋe ye rëƴëɗuho? Tëƴëryihni vële hnëpaɗëhowo va gante nësëndëɓuhëhniwo ka. Vëhni, njëtëni ɗus ile hnësëndëɓuhëhniwo ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ga nësëk watac, aryampo hnë vëyëka vële hahnëko ɗarël lëw̃u va më poryëka do ntehna: «Aki bi ntëkwaɗuha asëna wasaɗëha asankaf a?» ");
INSERT INTO cou_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu më ntëkwaka: «Ge këm fo nësëɓu, tufahnëry. Ɓare ge ile hnësëɓu ỹa toña ye, soŋe ye ryafëɗuho?» ");
INSERT INTO cou_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tac Anas më njëɗahnëka, hara nkok ñabi, njoyi vëhni Kayif hna, asëna wasaɗëha asankaf a. ");
INSERT INTO cou_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Hnë wati rac, Simo Piyer hwëɗëh hna nkoko njerantënde. Awa ahnë më tëƴëka: «Gelihna bi, wëjë fëna, aryampo hnë vërëfal aỹi asan vi?» Piyer mboko njahëta ntehn: «Hali, gela.» ");
INSERT INTO cou_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aryokuŋ ava asëna wasaɗëha asankaf, ale nkeniho hnënk g'asan ale ntëpëtëko Piyer nëf ŋa, më tëƴëka: «Nukila bi g'aỹi asan sarëɗiŋ hna?» ");
INSERT INTO cou_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyer më mbok njahëtak kat do taŋ pëgwëlehn tarënd cale. ");
INSERT INTO cou_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tac më nufik Yesu vëhni Kayif hna njiryeryi tere guverëner ale w̃aciko Pilat ỹa. Koɓëri fo nkeho g'acahnëfëɗ ga. Vële yokawo va vërënkëlohna vëhni dënk cery naw̃ hna, soŋe antë tonkënëni kaɓi ñaɗëniho tokëntini roka Pak ỹa. ");
INSERT INTO cou_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Soŋe rac cahnahnëko Pilat tëkatëhni për hna do tëƴëhni: «Iỹëhne w̃eh lehnërun ntik aỹi asan?» ");
INSERT INTO cou_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Më ntëkwaniha: «Ge dikëndina w̃eh ƴinenëhnekëndelihahna.» ");
INSERT INTO cou_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Awa Pilat më ntehnëkëhni: «Nufëryina ahitiŋun a w̃uhnë dënk gante nke sariya hun ka.» Ɓare më ntëkwani: «Kwëhnalëfuhna fanka hitiŋëfuna ahnë ndaw̃i.» ");
INSERT INTO cou_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ile nësëni vësankaf wasëwif ỹi, umë lik wanës wante nësëko Yesu soŋe sifa cëm nte rëfëka cëm ŋa ntiyaɗ. ");
INSERT INTO cou_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Awa Pilat më mbokak tënk cery hna do ntehnëko njoji Yesu, tëƴa: «Ahnaw̃ wasëwif w̃a bi yeru?» ");
INSERT INTO cou_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu më ntëkwaka: «Wëjë dënk bi hnahak wante hnësëru ŋi, ma vahnë hnësëhniki soŋe lëmën ỹa?» ");
INSERT INTO cou_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat më ntëkwak: «Sëwif bi yeɓu, ami? Ɓulunda hu ỹa dënk gë vësankaf vësëna wasaɗëha va yiryejëki ỹal mën li. Ye liru?» ");
INSERT INTO cou_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu më ntëkwaka: «Inaw̃ mën iŋa kwëhnina hnë iỹi ɗuniỹa. Ge hnë iỹi ɗuniỹa kwëhnakënde, vëryokuŋ mën va mëtëntakëndeni memaỹehnahnëni antë yëɗahniwu hnë vësankaf wasëwif. Ɓare hali, paryi nke Inaw̃ mën iŋa gena hnani.» ");
INSERT INTO cou_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat më ntehnëka: «Awa paryi ahnaw̃ bi yeru?» Yesu më ntëkwak: «Wëjë hnësëk: ahnaw̃ yeɓu! Nagiɓu do njijëɓu ɗuniỹa li soŋe yenëhnëw̃a toña ỹa seɗe. Ale kwëhnëk toña ỹa nëpaɗ ile hnësëɗëfu ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat më tëƴëka «Ye ga ye toña ỹa?» Pilat, ga nësëk waŋi, më mbok cahnëk kat tëkatëhni wasëwif w̃a për hna do ntehnëhni: «Ñoñ nula ile rëfëka ndaw̃ëhni aỹi asan. ");
INSERT INTO cou_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gante nke namu hun ka, tavëndëmuna aramp aryampo hn'ambënt Pak-wo. Awa ñaɗun bi ravëhnuna ahnaw̃ wasëwif aỹi?» ");
INSERT INTO cou_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Më ntëkwaniha ndekatëndëni: «Hali! Gena umë! Barabas ỹaɗëfun!» Hara, Barabas tac bandi yeho. ");
INSERT INTO cou_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Awa Pilat më ntehnëk njoyi Yesu do ntampi. ");
INSERT INTO cou_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wasoɗaɗe w̃a më mbahnëni apënkw wahnënkët wakwëhn wadëmpëhn do pënkwëniha; cuɗënihawo fëna cuɗ cankaf mbëntah. ");
INSERT INTO cou_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tëhaɗënihawo ntehnëndëniha: «Nkaỹiru, Ahnaw̃ Wasëwif!» Do poryëɗënihawo. ");
INSERT INTO cou_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat mboko cahn kat do ntehnëhni vësankaf wasëwif va: «Awa, canëhniɗëmuna, ayëtahnu ñoñ nula ile ntik rëfëka ndaw̃ahni aỹi asan.» ");
INSERT INTO cou_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Awa Yesu më cahnik, nkoryaryat apënkw wadëmpëhn ŋa do g'acuɗ mbëntah ŋa. Pilat më ntehnëkëhni: «Wëliho asan a!» ");
INSERT INTO cou_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ga nuniha, vësankaf vësëna wasaɗëha va gë vëyëka Cery W̃ën Cankaf va pëgwëlehnëni ndekandëni ntehnëndëni: «Pakehnëryehna hnë kërëwa! Pakehnëryehna hnë kërëwa!» Pilat më ntehnëkëhni: «Nufëryina w̃uhnë dënk afakuna hnë kërëwa. Ami, ñoñ nula ile menëk koɗe ndaw̃ahni.» ");
INSERT INTO cou_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Vësankaf wasëwif va më ntëkwaniha: «Kwëhnaɓun sariya, do gante nke sariya rac ka, tëfëka cëm, kaɓi Ajë W̃ën ntik nkaf ntëw̃u ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wanës watac ntakënakawo ɗus Pilat. ");
INSERT INTO cou_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Më mbokak tënk cery hna do tëƴa Yesu: «Avë ne yeru?» Ɓare Yesu ñoñ dëkwalawohna. ");
INSERT INTO cou_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Awa Pilat më ntehnëka: «Ami w̃ëỹëru dëkwaɗilihohna? Ƴëtëlihna bi nkwëhnaɓu fanka soŋe ravi ma fakehni hnë kërëwa?» ");
INSERT INTO cou_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu më ntëkwaka: «Wëla fanka kwëhnakëndila hnë ami ge W̃ënu ŋa maw̃ëryanakëndilihna. Soŋe umë ye, asan ale yëɗahnëko ỹal hu ỹa w̃enëk ɗus gë wëjë.» ");
INSERT INTO cou_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tëk pëgw hnë wati rac, Pilat njëkëlehnaɗëho fere tavahna Yesu, ɓare vësankaf wasëwif va ndekaɗëniho g'ahaw̃ary: «Ge tavëruha aỹi asan, gelihna lawo Sesar! Ale-wo-le liyak ahnaw̃ a, aỹew̃ Sesar ye!» ");
INSERT INTO cou_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat, ga nkwëryëk watac, më ntehnëk cani Yesu g'ipër, do umë ntaña tinki kitiŋa hna, hnë ile macëɗe «Ỹëw̃a Wëraka», (umë w̃acëɗe «Gabata» gë wanës Wa-ebëre ŋa). ");
INSERT INTO cou_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Fac le fëhwëtande ambënt Pak ŋa yeho, fagant anent ŋa. Pilat më ntehnëkëhni wasëwif w̃a: «Wëliho ahnaw̃ hun a!» ");
INSERT INTO cou_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɓare pëgwëlehnëni ndekandëni: «Araɓi cëm! Araɓi cëm! Pakehnëryehna hnë kërëwa!» Pilat më ntehnëkëhni: «Ahnaw̃ hun a ye: tëfëko bi fakehnëw̃a hnë kërëwa?» Vësankaf vësëna wasaɗëha va më ntëkwani: «Kwëhnalëfunahna ahnaw̃ ahaw̃ary ge gena Sesar.» ");
INSERT INTO cou_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Awa Pilat më njëɗakëhni Yesu soŋe paki hnë kërëwa. Awa më nufëniha Yesu. ");
INSERT INTO cou_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ndiɓëndik kërëwa lëw̃u ỹa dënk, cahnary naw̃ hna njiryery hnë ỹëw̃a hn'ile macëɗe «Kuŋ Hëloƴoƴ». «Golëgota» macëɗeho fëna gë wanës Wa-ebëre ŋa. ");
INSERT INTO cou_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hnam pakënihawo hnë kërëwa umë gë vëhi vëỹëntaw̃, aryampo g'irëhw, aỹëntaw̃ a g'irahahn do kërëwa Yesu ỹa yeho fagant. ");
INSERT INTO cou_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat ntehnëko fënali keri do paki kërëwa Yesu hna; aki keriko: «Yesu mbë Nasaret, ahnaw̃ wasëwif.» ");
INSERT INTO cou_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gë wanës Wa-ebëre, gë walaten, do gë wagërek keriko, do kaɓi hn'ile pakiko Yesu hna ɗarël naw̃ hna nkeho, wasëwif wayaɓah karaŋëniho. ");
INSERT INTO cou_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Awa vësankaf vësëna wasaɗëha wasëwif w̃a më ntehnëniha Pilat: «Tëfëlahna aher ahnaw̃ wasëwif. Tëfëka aher aỹi asan më lehnëk, ahnaw̃ wasëwif ỹa ye.» ");
INSERT INTO cou_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat më ntëkwak: «Ile herëɓu ỹa woɗ keri.» ");
INSERT INTO cou_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ante pakëniha wasoɗaɗe w̃a Yesu kërëwa hna, më nufëni viỹi vilëw̃u va cahëlehnëni wësah wahnah, sah ryampo ale-wo-le hnë vëhni. Cuɗ ŋa fo woko. Kwëhnalohna tëfëh do nkaf ndampo fo vahniko pëgw ƴaŋ hafo gëɗ. ");
INSERT INTO cou_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wasoɗaɗe w̃a ntehnëlëniho: «Antë citin aŋi cuɗ, ɓare ƴëlënëfu wanjël njëtahnin bi mo hwëhnëɗ.» Koyëna ntiyako wanës Vikerëh vinte hnësëko: «Cehëlëni viỹi mën va do njëlëni wanjël njëtahnëni bi mo hwëhnëɗ cuɗ mën ŋa.» Koyëna dënk ntiniho wasoɗaɗe w̃a. ");
INSERT INTO cou_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ɗarël kërëwa Yesu hna kahnëko hnëmu, g'aheryu hnëmu, gë Mari asëvalu Këlopas do gë Mari mbë Magëdala. ");
INSERT INTO cou_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ga nuka hnëmu do, ɗarël lëw̃u, arëfal ale ŋahnëko ɗus ỹa, Yesu më ntehnëka hnëmu: «Asëval, wëliho ajë hu ỹa.» ");
INSERT INTO cou_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tac më ntehnëka arëfal a: «Wëliho hnëmuh ỹa.» Tëk pëgw hnë wati rac, arëfal a njolehna hnëmu Yesu gë ỹalu. ");
INSERT INTO cou_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu njëtëko tame fop ile paƴijiko ntiya padëk do nkehahn ile nësëko Vikerëh ỹa më ntehnëk: «W̃ënka yoko.» ");
INSERT INTO cou_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ɗarël hnam nkeho peƴa tëmpah uñen ŋañah. Wasoɗaɗe w̃a më koƴëni ankwëỹ, cobëni ryoko atëh nte w̃acik isop do njelëhnëniha ce. ");
INSERT INTO cou_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tac Yesu, ga mbucëk uñen ŋa, më ntehnëk: «Fop padëk!» Tac, tënkwëlehn do cëm. ");
INSERT INTO cou_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kaɓi fac ile fëhwëtande fac ntaw̃ëla ỹa yeho, do kat ntaw̃ëla tac yaɓëkawo nafa ỹa, vësankaf wasëwif va vëỹaɗilohna ñas iŋa nko kërëwa hna hnë fac ntaw̃ëla hna. Awa më njini muntaniha Pilat nkubehnëhni wahohnënk w̃a vële fakiko va do ntihëtehn waỹas w̃a. ");
INSERT INTO cou_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Awa wasoɗaɗe w̃a më nkubëniha aryënkwëryënkw ale pakëlehniniho gë Yesu ỹa, tac ahigëna ỹa. ");
INSERT INTO cou_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ga tëkëhnëniha Yesu, tëkatënihawo ga tëk cëm, awa vëwubëlawohna wahwër w̃a. ");
INSERT INTO cou_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ɓare soɗaɗe ryampo më cëhëka wajiy ŋa gë sori lëw̃u ỹa, do cahnëlehna sat gë w̃ënka. ");
INSERT INTO cou_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ale hnësëk waŋi ỹa, nukëhniwo gë vinkër vidëw̃u va dënk, do wanës wadëw̃u ŋa toña ye. Njëtëk wapacëk toña ye do nësëɗ soŋe, w̃uhnë fëna, ahwëtahnahnuna Yesu. ");
INSERT INTO cou_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Awa ile liyak ỹi gante nësëko Vikerëh ka nke: «Wëla ỹëc ryampo gubëɗena.» ");
INSERT INTO cou_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Do kat, Vikerëh vikaw̃ary më lehnëk: «Nuɗe ale sëhika.» ");
INSERT INTO cou_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ga ndëcëk watac, Yosef, nte yeho avë nkol Arimasi, njiko tëƴa Pilat maw̃ëryana nuf ñas Yesu ŋa. Arëfal Yesu yeho, umë fëna, ɓare cow̃ëko kaɓi ntakëkawo gë vësankaf wasëwif va. Pilat më maw̃ëryanëka. Awa Yosef më njik nuf ñas Yesu ŋa. ");
INSERT INTO cou_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem fëna njiko. Hara umë yiko hwënta ryampo vëhni Yesu hna g'umëɗ. Awa njoko ile rëkëk wakilo wafëhw warar ɗatikola mir ile hnaw̃ëlehniko gë fatëh alowes. ");
INSERT INTO cou_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vëhni vëhi nufëlehnëni ñas Yesu ŋa, përyëni gë viỹi vile fëryande iñas, ntini wagu ɗatikola ŋa, gante nke namu wasëwif ka. ");
INSERT INTO cou_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hn'ile pakiko Yesu hna, sarëɗiŋ yeho hnam, do hnë sarëɗiŋ rac nkeho hnam iƴag kasëk nte woyiko koɓëri kwëtahnina iñas. ");
INSERT INTO cou_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kaɓi anëka nte pëhwëtandëni wasëwif fac ntaw̃ëla ŋa yeho, do kaɓi ŋaw̃ëlohna, më ndënëni iñas Yesu ŋa hnam. ");
INSERT INTO cou_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wakëwak fo gë dimasi ỹa, ante nkoko mëhwëry ŋa, Mari mbë Magëdala njiko ƴag hna. Më nuk taka nte fiɗahniko rënka ƴag iŋa piɗëtiko. ");
INSERT INTO cou_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Awa më nkaryëk nji tëkatëhni Simo Piyer gë arëfal aỹëntaw̃ a, ale ñako ŋahn Yesu ɗus ỹa, do pëƴahni: «Iñas Ahwëhn a nufik ƴag hna do ƴëtëlëfuhna bi ne kwëtik.» ");
INSERT INTO cou_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Awa Piyer g'arëfal aỹëntaw̃ a më njini g'iƴag. ");
INSERT INTO cou_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vëhni vëhi tak nkaryëɗëniho, ɓare arëfal aỹëntaw̃ a ndëcëkawo Piyer do ndënkw tëk ƴag hna. ");
INSERT INTO cou_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɓare tënkëlohna. Mëkëko do nkuryako. Nuko ile fëryahniko ñas ỹa fo woko hnam. ");
INSERT INTO cou_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simo Piyer, nte rëfiɗëhawo ŋa, tëkëgiko, tënkëlehn taŋ ƴag hna. Nuko fënali ile fëryahniko ñas ŋa, ");
INSERT INTO cou_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","do g'ile tëmpahniko nkaf Yesu ŋa. Gelohna ndampo fo gë ile fëryahniko iñas ŋa, ɓare minu pëỹiko. ");
INSERT INTO cou_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Awa, arëfal aỹëntaw̃, ale ryënkwëko tëk ỹa, më tënkëgëk. Nuko do kwëtahnëko. ");
INSERT INTO cou_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hafo hnë wati rac vërëfal va vëwëryëlohna ten Yesu tëfëka mbëhn vësëm hna, gante pëƴahnëko Vikerëh ka. ");
INSERT INTO cou_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Awa vërëfal vëhi va mbokalehnëni hn'ile cëlëniho hna. ");
INSERT INTO cou_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hnë wati rac, Mari për hna kahnëko ɗarël ƴag hna, do koɗëho. Gë wako wadëw̃u ŋa, më mëkëk, nkurya ƴag iŋa ");
INSERT INTO cou_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","do nukëhniwo wamëleka waki wante liyak viỹi viyah, ga ntañani hn'ile kwëtiko ñas Yesu hna, aryampo hn'ile nkeho nkaf hna do ỹëntaw̃ ỹa gë wakwër. ");
INSERT INTO cou_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Më tëƴëniha: «Asëval, soŋe ye hoɗu?» Më ntëkwakëhni: «Ahwëhn mën a nufik, do ƴëtëla bi ne kwëtik.» ");
INSERT INTO cou_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ante nësëk koyëna ŋa, më njëkak do nulehna Yesu ga kahnëk hnam, ɓare ƴëtëlohna umë ye. ");
INSERT INTO cou_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu më tëƴëka: «Asëval, ye hoɗu? Mo yëkëlehnëɗu?» Më ntiyahnëka bi ayam sarëɗiŋ ỹa ye; më ntehnëka: «Ge wëjë hnufëka, pëƴarye bi ne kwëtëruha, soŋe yiwu vijëw̃a.» ");
INSERT INTO cou_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu më macëka: «Mari!» Mari më cahëtak gë cape ntëw̃u do ndeka gë wanës Wa-ebëre ŋa: «Raboni!» Umë fëhnëtanëɗ «Aharaŋ». ");
INSERT INTO cou_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu më ntehnëka: «Ɓokawo afëlawo, kaɓi ɓokala haƴu ten gë vëhni Rëm mën ka. Ƴiryeyi afëƴanëhnow̃ëhni vëỹënta mën va: gë vëhni Rëm mën kaƴëɗëfu, ale ye Rëmun fëna; gë vëhni W̃ën mën, ale ye W̃ën hun fëna.» ");
INSERT INTO cou_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Awa Mari mbë Magëdala njilehn vërëfal hna do pëƴahni: «Nuɓuha Ahwëhn a!» Pëƴakëhniwo fëna ile ntehnëkawo ỹa. ");
INSERT INTO cou_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hnë dimasi rac dënk, g'anëka ga, vërëfal va hnë cery nkeniho do cëɗëniho warënka w̃a, kaɓi ntakëkëhniwo gë vësankaf wasëwif va. Yesu më njijëk fagant lëw̃ hni do ntehnëhni: «Araɓi ƴam ỹa nke gë w̃uhnë!» ");
INSERT INTO cou_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ante nësëk koyëna ŋa, më tufëkëhni wëɓák wadëw̃u wante pakiko ŋa gë wajiy ŋa. Vërëfal va më pëɓëkëhni hnatah kaɓi nuɗëniha Ahwëhn a. ");
INSERT INTO cou_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu më mbok ntehnëkëhni kat: «Araɓi ƴam ỹa nke gë w̃uhnë! Gante paƴiko Rëm ki, paƴëɗëmu ami fëna.» ");
INSERT INTO cou_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ante nësëk watac ŋa, më cëlëkëhni do ntehnëhni: «Maw̃ëryina Iƴir Ipacah ŋa. ");
INSERT INTO cou_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Vahnë vële ravëndun wameh wadëw̃ hni va, tavëhnëɗeni, do vële w̃ëỹëndun tavëhn va vëravëhnëɗena.» ");
INSERT INTO cou_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aryampo hnë vërëfal pëhw gë vëhi hna gentilohna gë vëhni ante njijëko Yesu ŋa. Toma yeho, umë w̃acëɗeho fënali Asëp. ");
INSERT INTO cou_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vërëfal vëỹëntaw̃ va më ntehnëniha: «Nuɓunëha Ahwëhn a.» Toma më ntëkwakëhni: «Ge nula vapakel wapont va wëɓák wadëw̃u hna, do ge ñakëla g'irufa mën ỹi hn'ile nkeho wapont hna do vák mën ỹi wajiy wante cëhiko hna, maw̃ëɗa muk.» ");
INSERT INTO cou_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ga ndëcëk wafac mbëɗ gë warar, vërëfal Yesu va mboko nkeni cery hna. Fac rac, Toma gë vëhni nkentiko. Warënka w̃a mboko cëɗëni ɓare Yesu më njijëk kahn fagant lëw̃ hni, do ntehnëhni: «Araɓi ƴam ỹa nke gë w̃uhnë!» ");
INSERT INTO cou_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tac më ntehnëka Toma: «Ñakërye gë rufa hu ỹi ani, ƴëkëry wëɓák mën ŋi; ƴeli vák hu ỹi aỹak wajiy mën ŋi. Tavëry gwaj ŋa do ahwëtahno!» ");
INSERT INTO cou_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma më ntëkwaka: «Ahwëhn mën yeru do W̃ën mën!» ");
INSERT INTO cou_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu më ntehnëka: «Kaɓi nuruho soŋe rac hwëtahnëru? Mbetani vële hwëtahnëɗ hara vëhnuna va!» ");
INSERT INTO cou_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu mboko nti, tase vërëfal vëlëw̃u hna, wëdahëse wapëmpëhnahnah wakaw̃ary waƴaɓah wante wok tëfëtayina hnë aŋi kayëte. ");
INSERT INTO cou_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɓare ile yehëhna ỹi, kerik soŋe ahwëtahnahnu Yesu ye Arëhnayik a, Aju W̃ënu ŋa, do ge kwëtahnërunëha, nuỹaɗun sël ntaw̃ary, uwám pary w̃a, g'uw̃ac lëw̃u w̃a. ");
INSERT INTO cou_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ga ndëcëk rac, Yesu mboko tufëhnahni vërëfal vëlëw̃u va, tëfary lant Tiberiyad hna. Wëlin gante tufëhnakëhniwo ka: ");
INSERT INTO cou_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ndampo fo nkeniho, vëhni: Simo Piyer, gë Toma nte w̃acëɗeho Asëp a, Natanayel mbë Kana vë Galile, Viju Sebede, do gë vërëfal vëhi vëỹëntaw̃ va. ");
INSERT INTO cou_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo Piyer më ntehnëkëhni: «Gë fëla wuwis njiɗëfu.» Më ntëkwaniha: «Fuhnë fëna, njintëɗeɓun.» Awa njilehnëni kaƴëni kulu hna, ɓare ñoñ vëfëlalohna umëɗ tac. ");
INSERT INTO cou_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ante pëgwëko pacënd ŋa, tëkiko Yesu, tëfary w̃ënka hna kahnëko. Ɓare vërëfal va vëyëtëlohna umë ye. ");
INSERT INTO cou_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Awa Yesu më tëƴëkëhni: «Vërah mën, pëlarunëhëhni bi wuwis?» Më ntëkwaniha: «Hali». ");
INSERT INTO cou_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Më ntehnëkëhni: «Dabëryin waryeƴ w̃i gë cape rëhw kulu haɗi do pëlaɗunëhëhni.» Awa ntabëlehnëni waryeƴ w̃a, do vëhoɗilohna ntabëtini, kaɓi wuwis w̃a pëɓëniho. ");
INSERT INTO cou_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Awa arëfal ale ŋahnëɗëho Yesu ɗus ỹa më ntehnëka Simo Piyer: «Ahwëhn a ye!» Ga nkwëryëk wanës watac, «Ahwëhn a ye», Piyer më mbokëryak cuɗa cuɗ nte cuɗëtako ŋa do ntëba w̃ënka hna. ");
INSERT INTO cou_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Vërëfal vëỹëntaw̃ va më kegëtani ndotëndëni waryeƴ wafëɓah wuwis w̃a: vëỹaw̃ëlohna vambëŋ va, soŋe wametër keme fo ŋaw̃ëtaniho. ");
INSERT INTO cou_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tëkëndëni tuŋ vambëŋ hna, më nuni hwëɗëh g'uwis ga mbëlëɗeni do gë vamburu. ");
INSERT INTO cou_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu më ntehnëkëhni: «Ƴojënëhni wuryampo hnë wuwis wule fëlarun takan w̃i.» ");
INSERT INTO cou_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simo Piyer kaƴëlehn kulu hna ndoj waryeƴ w̃a nkal hna. Wuwis wusankaf wule fëɓëko w̃a, keme gë wafëhw imbëɗ do gë warar (153) nkeniho do, mama njaɓahnëniho ɗus, waryeƴ w̃a ɓëkëtalohna. ");
INSERT INTO cou_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu më ntehnëkëhni: «Ƴijën tokin.» Wëla arëfal aryampo ɗëkëlohna tëƴa: «Mo yeru?» Njëtëniho Ahwëhn a ye. ");
INSERT INTO cou_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu më tëhak, nuf mburu ŋa do cahëlehnëhni, tac wuwis w̃a fëna. ");
INSERT INTO cou_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Rarëna ỹa tufëhnakëhniwo Yesu vërëfal vëlëw̃u va, koɓëri ga mbëhnahnëko. ");
INSERT INTO cou_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ga puhnani tok iŋa, Yesu më tëƴëka Simo Piyer: «Simo, aju San, ŋahnëruho bi alëbëhni vëỹi?» Më ntëkwaka: «Ha, Ahwëhn, njëtëru, ŋahnëmi.» Yesu më ntehnëka: «Ɗavëryihni vupe mën va.» ");
INSERT INTO cou_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tac më mbok tëƴëka higëna ỹa: «Simo, aju San, ŋahnëruho bi?» Më ntëkwaka: «Ha, Ahwëhn, njëtëru ŋahnëmi.» Yesu më ntehnëka: «Paɓëryihni wape mën ŋa.» ");
INSERT INTO cou_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu më mbok tëƴëka rarëna ỹa: «Simo, aju San, ŋahnëruho bi?» Piyer njamëlehn kaɓi rarëna ỹa tëƴëkawo Yesu bi ŋahnëka. Më ntëkwaka: «Ahwëhn, njëtëru fop; njëtëru ŋahnëmi!» Yesu më ntehnëka: «Ɗavëryihni wape mën ŋa. ");
INSERT INTO cou_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","«Toña ỹa fëƴaɗëmi: ante nkoruho jar ŋa, wëjë dënk ỹëbaɗëho ryil ỹa do njiɗuho hn'ile ñaɗuho hna, ɓare ge ntafëru, njelëɗu wëɓák ŋi, ahaw̃ary ỹabëɗëhi do njiryeryëɗëhi hn'ile nkoru ñaɗila ayi hna.» ");
INSERT INTO cou_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Hara, gë wanës watac, Yesu tufahnëɗëho sifa cëm nte cëmëɗ Piyer tufahnahn inaỹ W̃ënu ŋa.) Ante nësëk watac ŋa më kwënëk: «Tëfe!» ");
INSERT INTO cou_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer më cahëtak do nuhna arëfal ale ñako ŋahn Yesu ɗus ỹa; hamëhni tëfiɗëhëhniwo. Arëfal arac rankako gë cape Yesu ante tokëɗëniho roka ŋa do tëƴa: «Ahwëhn, mo ye ale rokaɗëhi ỹa?» ");
INSERT INTO cou_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer nukawo, më ntehnëka Yesu: «Ahwëhn, aỹi lë, ye yeɗëha?» ");
INSERT INTO cou_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu më ntëkwaka: «Ge ñaɗa cëm hafo vokaju, ye yentahniki? Wëjë, tëfe!» ");
INSERT INTO cou_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Awa wanës watac campëlehn hnë vëhery vële hwëtahnëk hna; ntehnëɗeho, arëfal arac cëmëɗina. Ɓare Yesu dehnëlohna cëmëɗina, umë lehnëko ge ñaɗina cëm hafo mbokaj, ye yentahnika? ");
INSERT INTO cou_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Arëfal arac dënk hnësëk had seɗe do herëk watac. Njëtëɓun ceɗeya dëw̃u ŋa toña ye. ");
INSERT INTO cou_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu mboko nti viyaɓah vihaw̃ary. Ge kerakënde fop, ntiyahnëko tëkëlakëndina ɗuniỹa li vëkayëte vante herakënde va.");
INSERT INTO cou_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Aỹënta mën Tewofil, kayëte ndënkwëryënkw mën hna nësëɓuho fop ile pëgwëko ntind Yesu do karaŋëndëhëni vahnë ỹa ");
INSERT INTO cou_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hafo hnë fac le nufiko nji g'ambin ỹa. Ani gë kaƴahnënd ỹa, umë nkabëkëhni gë fanka Iƴir Ipacah ŋa vële tëhnako had vëfaƴik va ile rëfëka ntini ỹa. ");
INSERT INTO cou_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vëhni, ante mbëhnëko ŋa, Yesu tufëhnakëhniwo do tufëkëhniwo yaɓah njëtahnëni paryi nke mbëhnëk. Hnë wafac wafëhw wahnah tufëhnakëhniwo do nësëhnëhni soŋe Inaw̃ W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Fac ryampo, wati nte mbarëniho ŋa, më ntehnëkëhni: «Ant'aỹaw̃ëtawu Yerusalem; napëryin ile ntehnëko Rëm njëɗaɗëhu ỹa, umë ye uyëɗ ule fëƴamuno w̃a. ");
INSERT INTO cou_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","San gë w̃ënka njaryëɗëho, ɓare w̃uhnë, ani gë wafac toƴe, g'Iƴir Ipacah iŋa njaryëɗerun.» ");
INSERT INTO cou_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ante mbarëniho vëfaƴik va gë Yesu, më tëƴëniha: «Ahwëhn, iỹi wati bi mbësaɗuhëhni naw̃ iŋa ɓulunda Isërayel ỹa?» ");
INSERT INTO cou_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Më ntëkwakëhni: «Rëm ỹa fo yëtëk ante ntiyaɗ vëỹin ŋa; w̃uhnë maw̃ëryaniluhna ayëtu wati ma ƴamani ile ntiyahnëɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɓare ƴëtëryin iỹin: Iƴir Ipacah iŋa cëliɗ hnë w̃uhnë do nuỹaɗun fanka falëw̃u fa do waseɗe mën yeɗun Yerusalem hna, Yuɗe hna fop do gë Samari hna, do hafo hn'ile tëkwik ɗuniỹa hna.» ");
INSERT INTO cou_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu, ga nësëk watac, nufiko g'ambin, do njëkëɗënihawo vëhni fop; tac aŋar cankëlehna hafo nambëniha. ");
INSERT INTO cou_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nkoniho ntaŋëniha Yesu g'ambin wati nte ŋaw̃ëtahëɗëho ŋa, tëketëni vësan vëhi vële suɗak viỹi viyah haryënkw lëw̃ hni do ntehnënihëhni: ");
INSERT INTO cou_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Vësan vëvë Galile, soŋe ye ỹëw̃ërun aki ayëkëndu ambin ŋi? Asan ale w̃acëɗun Yesu ỹa, hnufëhnirunëha nji g'ambin do koyëna mbokajëɗ.» ");
INSERT INTO cou_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Awa vëfaƴik va matëlehnëni Kuŋ Oliviye hna mbokani Yerusalem. Yëbëlan Kuŋ Oliviye ŋa gë Yerusalem tëkëko kilo uyas gë toƴe. ");
INSERT INTO cou_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tëkëndëni tuŋ, kaƴëlehnëni ƴaŋ etas hna, hnë cery ante rëkëniho nkehahnëndëni ŋa. Wëlin wamac vële yeho hnam va: Piyer, gë San, gë Sak, gë Andëre, gë Filip, gë Toma, gë Barëtelemi, gë Matiye, gë Sak aju Alëfe, gë Simo nte w̃acëɗeho Ahahnëndak, do gë Yuɗa aju Sak. ");
INSERT INTO cou_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mawalëniho mbarëlëndëni kwëlëkwël soŋe ƴëfa gë Mari hnëmu Yesu, gë vësëval vëryampo, do gë vëheryu Yesu. ");
INSERT INTO cou_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Fac ryampo, ante mbarëɗëniho ŋa, Piyer matëko tase vële hwëtahnëk hna vële rëkëko mpëd keme gë wafëhw wahi (120), do ntehnëhni: ");
INSERT INTO cou_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Vëỹënta mën, ile fëƴahnik Vikerëh hna, watac tëfëkawo ntiya. Iƴir Ipacah iŋa pëƴahnëk koɓëri fo w̃ës David hna soŋe Yuɗa nte ryënkwaryëkëhniwo vële fëlaka Yesu va. ");
INSERT INTO cou_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aỹi asan, aryampo hnë fuhnë yentiko, do ɗoku rac fo hwëtehnahninëkëfuno. ");
INSERT INTO cou_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","«Kaỹ law̃ahniko koryi ile cosiko soŋe iƴëɗahn Yesu ŋa. Hnam njoko, hafo tënka ɗonk iŋi, cahnëlehna wabeỹ ŋa. ");
INSERT INTO cou_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vahnë vële lëɗëk Yerusalem va fop njëtaniho watac: soŋe umë w̃acahnik iŋi kaỹ gë wanës wadëw̃ hni ŋa: “Akëlëdama.” Umë fëhnëtanëɗ: “Ikaỹ Wasat.”» ");
INSERT INTO cou_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyer më mbok ntehnëk: «Wëlin ile herik Kayëte Wahnëw̃ hna soŋe Yuɗa ỹa: «“Araɓi tere lëw̃u ỹa tavi, ahnë antë ntëɗahn kwëlëkwël.” Mbok keri fëna: “Araɓi ahaw̃ary nuf ɗoku lëw̃u ile njëɗakawo W̃ënu ŋa.” ");
INSERT INTO cou_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tëfëka tëhnayina aryampo hnë vële lapëhnaɗëhëfuno gante-wo-gante, ante njasëlehëɗenëho gë Yesu Ahwëhn a, ");
INSERT INTO cou_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","koɓëri ante njaryëkawo San Yesu hafo ante nufëhninëkëfuna nji g'ambin. Asan a rac nkentëɗe koyëna seɗe gë fuhnë, iɓëhn dëw̃u ŋa.» ");
INSERT INTO cou_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Awa, ga nësëk watac Piyer më tahnënihëhni vësan vëhi: Matiyas, gë Yosef, nte w̃acëɗeho Barësabas, (w̃ëcako fëna Yusëtis). ");
INSERT INTO cou_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Awa vële hwëtahnëk va më njëfani aki: «Wëjë, Ahwëhn, njëtëru iña vahnë ŋa fop; tufëryifuna bi mo rëhnaru hnë vëỹi vësan vëhi ");
INSERT INTO cou_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Soŋe nke afaƴik nëmpëta Yuɗa nte yik gë ỹëw̃a ile rëfëka.» ");
INSERT INTO cou_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tac njëlëniho wanjël njëtahnëni bi mo yeɗ. Awa, më tufahnëk Matiyas ye. Nkwënëlehnëniha vëfaƴik pëhw g'aryaw̃ hna. ");
INSERT INTO cou_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ga tëkik fac Pantëkot ỹa, vële hwëtahnëk va sëñ ryampo fo mbarëlëniho. ");
INSERT INTO cou_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Taŋ wëñaw̃ matëlehni g'ambin. Nkeho had wëñaw̃ sël hwëhn fanka, do pëɓëlehn hnë tere le ntañahnëniho hna. ");
INSERT INTO cou_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wati rac dënk, nulehnëni waryëw̃ wale w̃ëntëlëk gë humpen hwëɗëh. Pitëlëlehn tindahni ale-wo-le nkaf hna vëhni fop. ");
INSERT INTO cou_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pëɓëlehnëhni taŋ vëhni fop Iƴir Ipacah iŋa, pëgwëlehnëni nësëndëni vanësa vakaw̃ary, ale-wo-le gante njëɗaɗëhawo Iƴir Ipacah nësënd ka. ");
INSERT INTO cou_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hara, wati rac, wasëwif wale w̃atiko ɗuniỹa ỹi fop, Yerusalem hna nkeniho; ntënënëɗënihawo W̃ënu ŋa. ");
INSERT INTO cou_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ga nkwëryik wëñaw̃ watac, më mbarëpëlëni. Pëmpëhnahnëkëhniwo ɗus vëhni fop, kaɓi ale-wo-le hnë vëhni nkwëryëɗëhëhniwo ga nësëɗëni wanës wadëw̃u ŋa dënk. ");
INSERT INTO cou_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pëmpëhnahnëkëhniwo ɗëcët do ntehnëɗëniho: «Vëỹi vahnë vële hnësëɗ vi, vëyena bi fop vëvë Galile? ");
INSERT INTO cou_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Awa, hak kolahnëɓun wëryëndëfuni, ga nësëɗëni ale-wo-le wanës wante yëw̃ëɓun ŋa? ");
INSERT INTO cou_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vëryampo hnë fuhnë Parët matiniho, gë Medi, gë Elam; nkeniho vële lëɗëko Mesopotami, do gë vëvë Yuɗe, gë Kapaɗos, gë Pon, do gë Asi; ");
INSERT INTO cou_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","gë vëvë Fërisi, gë vëvë Pampëfili, gë Esipët, do gë waresiỹo Libi ile ye ɗarël ankol Siren; do gë vële w̃atik Rom, ");
INSERT INTO cou_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","gë vëvë Këret, do gë vëvë Araɓi; vëryampo wasëwif naginiho, do vëryampo caliŋëniho caliŋa wasëwif. Nkwëryëɗëfunëhëhni fuhnë fop, ale-wo-le gë nësa ntëw̃u ŋa, ga nësëɗëni soŋe waɗoku wapërën wade ntiɗ W̃ënu ŋa!» ");
INSERT INTO cou_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Vëhni fop pëmpëhnahnëkëhniwo ɗus do vëyëtëlohna ile nahaɗëni; ntehnëlëɗëniho vëhni fop: «Ye ga ye iỹin?» ");
INSERT INTO cou_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ɓare vëryampo njafaŋëɗënihëhniwo vële hwëtahnëk va ntehnëndëni: «Vëỹi uñen ndëw̃ëni!» ");
INSERT INTO cou_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Awa Piyer gë vëfaƴik pëhw g'aryaw̃ va kahnëniho do ndekahnëhni kore ỹa: «Nëparyino ɗus, vëỹënta mën wasëwif do gë fop w̃uhnë vële ye Yerusalem vi: gwëryëryin ile ryëcëtaɗ ỹa. ");
INSERT INTO cou_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nahaɗun vëỹi ndëw̃ëni ɓare vëryëw̃ëna! Cahnëfëɗ fo wok do sëwif ceɗina muk iỹi wati! ");
INSERT INTO cou_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iỹin haw̃ary ye, ile nësëko kila ile w̃aciko Sowel ỹa: ");
INSERT INTO cou_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«W̃ënu ŋa më lehnëko: “Wëlin ile rëkiɗ ỹa: wafac warëkwa hna: campehnëɗëfu Iƴir mën iŋa vahnë hna fop; vijë hun gë vëryag hun va nësëɗëni wanës W̃ënu ŋa had wakila, tufëɗëfuhëhni vëjar hun va do gë vicër va viỹë gë huɗakery. ");
INSERT INTO cou_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ha, campehnëɗëfu Iƴir mën iŋa vëryokuŋ mën hna, vësan gë vësëval, hnë wafac warac, do rëkëɗ nësëndëni wanës W̃ënu ŋa had wakila. ");
INSERT INTO cou_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ntiɗëfu viỹë vifëmpëhnahnah ƴaŋ, ambin hna, do gë wëdahëse hnani gëɗ nkal li: umë yeɗ wasat gë hwëɗëh do gë vëŋar hwëcic, ");
INSERT INTO cou_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","do ulav w̃a kuyëɗ do ulepera w̃a mbëntëɗ had wasat. Umë fop nkeɗ tëkahnind fac Ahwëhn a, fac sankaf ryëwayik hn'ile mbokahniɗ rac. ");
INSERT INTO cou_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Do pehëtëɗëhëhni fop vële w̃ëcaɗëha va.” ");
INSE