﻿USE sofia;
DROP TABLE IF EXISTS sofia.cotNT_vpl;
CREATE TABLE cotNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cotNT_vpl WRITE;
INSERT INTO cotNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imaicaquea nontioncacoguequeroqueate ipajiguetagueti paesatinipaequitica choviquijianaquerica Jesoquirishito, ichoviquini Taavini aisa ichoviquini Averaameni. ");
INSERT INTO cotNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iriraquea Averaameni irijanincari Ishaaco. Irira Ishaaconi irijanincari Jacovo. Irira Jacovoni irijanincari Joraa aisa iriguentijeguijiate. ");
INSERT INTO cotNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Irira Joraani yoacaaquero Tamare, irijanintacari Parese aisa Tsara. Irira Pareseni irijanincari Eserome. Irira Eseromeni irijanincari Arame. ");
INSERT INTO cotNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Irira Arameni irijanincari Aminaravo. Irira Aminaravoni irijanincari Naasone. Irira Naasoneni irijanincari Saramoni. ");
INSERT INTO cotNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Irira Saramonini irijanincari Voose. Oratica iriniro opajita Iraava. Irira Vooseni irijanincari Overi. Oratica iriniro opajita Iroti. Irira Overini irijanincari Isai. ");
INSERT INTO cotNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Irira Isaini irijanincari majirontatsica Taavi. Irira majirontatsica Taavini irijanincari Saromoni. Oratica iriniro Saromonini iroguenti imanquigavetanica Oriashi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Irira Saromonini irijanincari Irovoame. Irira Irovoameni irijanincari Aviashi. Irira Aviashini irijanincari Asa. ");
INSERT INTO cotNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Irira Asani irijanincari Josapate. Irira Josapateni irijanincari Jorame. Irira Jorameni ichoviquivaetanaqueri Oshiashi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Irira Oshiashini irijanincari Jotame. Irira Jotameni irijanincari Acashi. Irira Acashini irijanincari Esequia. ");
INSERT INTO cotNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Irira Esequiani irijanincari Manaseshi. Irira Manaseshini irijanincari Amoni. Irira Amonini irijanincari Joshiashi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Irira Joshiashini ichoviquivaetanaqueri Jeconiashi aisa iriguentijeguijiate coramaniqui icoraquecoraqueitashiquerigueti coaretajia Vavironiaquitica yashintajiacarigueti maasano ishiraerijia yaajitanaqueri Vavironiaqui oshequi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iroompa iriraquea Jeconiashini irijanincari Saratieri. Irira Saratierini ichoviquivaetanaqueri Sorovaveri. ");
INSERT INTO cotNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Irira Sorovaverini irijanincari Aviote. Irira Avioteni irijanincari Eriaquime. Irira Eriaquimeni irijanincari Asoro. ");
INSERT INTO cotNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Irira Asoroni irijanincari Saroco. Irira Saroconi irijanincari Aquimo. Irira Aquimoni irijanincari Eriote. ");
INSERT INTO cotNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Irira Erioteni irijanincari Eriasare. Irira Eriasareni irijanincari Matani. Irira Matanini irijanincari Jacovo. ");
INSERT INTO cotNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Irira Jacovoni irijanincari Jose manquigataroca Maria. Iroatimpa iroguenti iriniro Jesoshi icantajiqueca aisa Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Maasano tioncacojianquitsica ipajiguetagueti ocaniqui icaravaeque 14 ipariapanajanta ichoocaquegueti Averaameni yarejevaecaroquea ichoocaquegueti Taavini. Ariquea iquempejiaca aisa icarajiaque 14 maasano tioncacojianquitsica ipajiguetagueti ipariapanajantaroquea ichoocaquegueti Taavini icaravaeque yaajitanaquerigueti Vavironiaqui. Iroompaquea ari iquempejiaca aisa icarajiaque 14 maasano tioncacojianquitsica ipajiguetagueti ipariapanajantaroquea yaajitanaquerigueti Vavironiaqui icaravaeque ichoocaquegueti Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Imaicaquea nontsavetacotantaqueriqueate Jesoquirishito queroca ocotacani iroaqueragueti ivoaquegueti. Coramaniquea ochoocaque manquigarentsi pajitatsica Maria. Iriguentiquea cashiacaro shirampari pajitatsica Jose. Iroompaquea tequeratatirajatari quisho irogueroji ichoocatashica irijanite, iriguentiquea choocatacaaqueri Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iriraquea Jose inintaveca irovashiantajerome, iriguentiquea comajamajatanquitsica, cotanquitsiquea ipintsatacocaroquea jero teeca irinintantempaji inquenquetsatacoqueroquea iroguipashiventajaquero, manaqueate iquenquejavetanacaquea irovashiantashitajemparo intati, aatoqueate icanti taa opajita irovashiantantanajemparoca. ");
INSERT INTO cotNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cotanquitsiquea irooquea iquenquejavetanacaquea imaica, yonigaapojacariquea irashivantite Amajirote iguimaanequi, icanqueri: “Jose, ichoviquitanaqueca Taavini, aato pitsaroacagaro pimanquigatemparo Maria. Aritarite iriraquea irijanite choocatanquitsica intsompogui iriguentiquea choocatacaaqueriquea Ishire Aapani Irioshi, irootaquequeate ichoocatantacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Oncoajicatapojaquegueti irivoaquegueti pimpajitsitempari Jesoshi, irioriji iriotaquequea meshiajiaquerineca igonorojia aatonijite icatsimatimentiritsiquea Aapani Irioshi icovaeguishecagueti.” ");
INSERT INTO cotNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ariquea oquejetaca imaica cameetsanijite onetsanamajaquempanijite icanqueca Amajirote paesatoniqui icantashirentaquerigueti tsavetantatsicani, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ora majinaro ontsaraquitashitanaquempa, ariquea inchoocataquequea irijanite. Iriatimpa impajijiteri Emanoere” (ocanquequea: “Iconoajiacaji Aapani Irioshi”). ");
INSERT INTO cotNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iroompaquea ipityaquirejanaji Jose iquemisanqueriqueate irashivantite Amajirote, iroompa ariquea yoanaque yaaquitiroquea Maria itsipatanacaro itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Cotanquitsiquea teequea quisho irogueroji arejevaetaca ivoaquegueti irijanite opariacaca. Ariquea ipajiqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oraquea ivoaquegueti Jesoshi Verenequi Joreaqui chooca imajirojiate Joreajiaquitica pajitatsica Erorishi. Iroompaquea icoraquecoraqueitaquequea Jerosarequi shiramparipae icantajitica maagopae savicaventajiguirica impoquirojite intsatantajiaquempaca taaca opajitapae. Iriatimpajia iquenaquenaipojaque isotoguigueti catsirincaiteri. Oraquea yarejerejeipojacagueti ");
INSERT INTO cotNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","icoacojiapojiriquea choocajiatsica ocaniqui icanqueri: —¿Querocaquea ichoocaqueni oraniqui imajirote joriojia voanquitsica? Namenajiaqueriqueate irimpoquirote isotoashitapojacaquea ontaniqui isotoguigueti catsirincaiteri notsatantajiacaca voaque, nocoraquecoraqueitantajiacaca nogueroventajiaquempariquea noshineventajiaquitempariqueate. ");
INSERT INTO cotNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Iroompaqueate iquemavaquegueti majirontatsica Erorishi, ariquea ishoshoguitevaetanacaquea, ariqueate iquempejianaca maasanojia choocajiatsica Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Incajaranquiguitetanaquegueti, iriatimpa icajemacaantajiaqueriquea maasano saserorotejia anaantajianquitsica aisa tsatacaajiguirica joriojia itioncacotanaqueca Moishishini coramani, icoacojiaqueriquea queroca oraniqui irivoaque Quirishitotanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iriatimpajia icanquequea: —Iroguenti irivoaque ontaniqui Verenequi Joreaqui, ariquea icanque tsavetantatsica itioncacotaquerogueti coramani icanquerica Aapani Irioshi, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Aviatimpa Verene choocatatsica iguepatsitequi Joraani, aatoquea anajaiguimpi otsipapae guinteninintsi iguintenijiagueti oshequi Joreaquitica, irisotoampojempitarite majirontanquitsineca peanquitsineca Imajirote maasanojia ishiraerijia nashintajiacaca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ariqueate Erorishi santicoji yoaquero icajemacaantsitari maagopae, teequeate quericaca incamanque. Yarejerejeipojacagueti icoacojiavaqueriquea icantajiavaqueri: —¿Querocaquea savincaguiteri pamenantajiacari isotoampojacaca impoquiro? ");
INSERT INTO cotNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iroompaquea iquemavaquegueti icamantaquerigueti itigarancajiaqueriquea Verenequi icantajiavaqueri: —Iintsijate poajianaque pamenamajaguequiterijate, iroompa pamenajiaquerigueti pincoraquetajeja pincamantajiapojajenaja cameetsanijite noanaquenijite naatimpa noguerovenquitempariqueate noshinevenquitempari. ");
INSERT INTO cotNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Irooquea iquemajiaquerigueti yoayoaitanaquequea Verenequi. Iriraquea impoquiro yamenajiaqueca iroaqueragueti ontaniqui iguinteniqui ijivaqueriquea iroompaquea iquishojencatapojiquea otampaticataquegueti tsovironaquiqui ichoocatacotantacaca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oraquea yamenajiajirigueti impoquiro, ariquea icohicoitanaca ishinejianaca icanca. ");
INSERT INTO cotNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iroompaquea yarejerejeipojacarogueti tsovironaqui iquijaquijaitanaquequea intsompogui inejajiapojiriquea Jesoshi, otsipatacari Maria, iriniro. Igueroventajiapojacariquea ishineventajiapojacari. Iroompaquea itanarejacoguetapojiro yamajiaquenerica yojocajiaqueneri ooro, casancavaneri, aisa otsipa casancari icantajitica mira. ");
INSERT INTO cotNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iroompaquea imaajiaquegueti icamantajiqueri iguimaanequi aatonijite yoayoaitanajitsiquea Erorishiqui, irootaquequea iquenapitsatantajianajarica otsipaqui quenavoquirontsi, yoayoaitanaji iguinteniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iroompaquea yoayoaitanajigueti iriatimpajia, iriraquea irashivantite Amajirote yonigaapojacari Jose iguimaanequi, icantiriquea: —Iintsija imaica pincatianaqueja paanaqueriquea chaajaniquitirajaca aisa iriniro poanaqueshiatsi pishianaqueshiatsi ontaniqui osamani Ejepitoniqui. Pinchoocateja ontaniqui aapojajempaguetiquea noncantantajempica pincoraquetantajempaca, iramenacaantaguequeritari majirontatsica Erorishi irimetojacaanqueriniji. ");
INSERT INTO cotNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ariqueate icatiapanajanta, yaanaqueriquea chaajaniquitirajaca aisa iriniro, yoanincanaquequea pitsecariqui yoayoaitanaque Ejepitoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ichoocaguitiniquea ontaniqui aapojaguetiquea imetojanajigueti Erorishi. Ariquea iquempejiaca imaica cameetsanijite onetsanamajaquempanijite icanqueca Aapani Irioshi coramaniqui itioncacaaquerica tsavetantatsica icanque: “Ichoocavetaca Irijani Ejepitoqui, nocajemajiri.” ");
INSERT INTO cotNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Iroompaquea iriraquea Erorishi yamenaquegueti teequea incoraquejiaje maagopae icatsimatsitanacaquea, ariquea itigarancajiaqueri coaretajia irimetojajiaqueriquea maasano chaajaniquirijia guinteninijianquitsica Verenequi irioca aisa guinteninijianquitsica irooshiguetanquitsica, interoncajiaqueriquea maasano iriaqueraca voaguetanquitsica irarejevaequempariquea incaravaequeriquea ajagantsitacojiananquitsica mavite. Iroguentiquea ipampiatsitaqueri icantajiaqueca maagopae ivoantacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ariquea iquempejiaca imaica inetsanajitaquero itioncacotanaqueca coramani tsavetantatsica Jeremiashini, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Iquemajiquero ontaniqui Iramaqui ocajemavaequequea, ocantacoguitani iraaguitani, iroguenti ochoviquijiani Iraquereni, iraacoguitiriniquea irijanijiate. Tee oninteji iroguishinejajitajero, teetari inchoocajiajeji irijanijiate.” ");
INSERT INTO cotNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ocoramanitapojaquegueti imetojanajigueti Erorishi, iriraquea irashivantite Amajirote yonigaapojajari Jose iguimaanequi ontaniqui Ejepitoqui, ");
INSERT INTO cotNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","icanti: “Iintsijate imaica pincatianaje paanaquerija chaajaniquitirajaca aisa iriniro, poanajequea ontaniqui Ishiraeriqui, metojanajitari nintajiavetanquitsica irimetojajiaquerimequea.” ");
INSERT INTO cotNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ariquea icatianaja, yaanajiri chaajaniquitirajaca aisa iriniro, yoanaji Ishiraeriqui. ");
INSERT INTO cotNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cotanquitsiquea iquemacoqueriquea Arequerao irijanite Erorishini ipejaaquea majirontatsica Joreaqui iquempetajari iririni, ariqueate icotanaca itsaroanaquequea teequea irininteji iroanajequea ontaniqui. Iroompaquea icamantajitiri iguimaanequi aatoniji yoanaji ontaniqui, irootaquequea yoantanajaca Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yarejetapojajaroquea ontaniqui ichoocatantapojajaro guinteninintsi icantajitica Nasare. Ariquea iquejetaquerogueti imaica onetsanatanaca icantaguetaqueca tsavetantajiatsica, icanquequea: “Incantajiteri Nasarequitica.” ");
INSERT INTO cotNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aapojacagueti savincaguiteri yoanaquequea Joanca Viñacajatantatsica itsavetantavaequequea ontaniqui oquitamampororoitapojaquegueti Joreaqui, ");
INSERT INTO cotNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","icanque: “Pincantashitatijaianaquempaja povashiantajianaquerojate pipeacaaguishetaca, irooshipojitarite aapojaquempaquea irimajirontaquempa acaniqui Inquitequitica.” ");
INSERT INTO cotNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iriraquea Joanca iriotaque itsavetacotaqueca tsavetantatsica Isaiashini coramani, icanquequea: “Inquenquetsataquequea oquitamampororoitapojigueti iririjencani, incanquequea: ‘Pinetsanatashijiavaquempari Amajirote inquenantapojempaca, pintanarejagueteneri iguenavoquiropae ontampaticapoquitantanaquempaca.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Iroguenti iquitsaataca Joanca quitsaarentsi ipeacaajitacaca imae cameyo, aisa ichompimashitacotacariquea imeshinatsa. Iriguentiquea ishecataca quejevetarica shapipiiquiti aisa earotoja. ");
INSERT INTO cotNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iroompaquea yoayoaitashitanaqueri icaramirincavaetanaquequea caquintejia guinteninitantaroca Jerosarequi, iriguentijiaca itsipajia Joreaquitica, iriguentijiaca aisa irooshitacojiacaroca ojaaquiniqui pajitatsica Jororane. ");
INSERT INTO cotNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Irooqueate iquemajiapojaquerigueti, ariqueate icohicoitanaca itsaveacojianaqueroquea maasanopae igovaeguisherejia, ariquea iviñacajajiaqueriquea Joanca Jororanequi. ");
INSERT INTO cotNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ariquea icoraquejiavetaca oshequini pariseojia, aisa saroseojia iviñacajatantaquegueti. Cotanquitsiquea yamenajiavaquerigueti, icantajiavaqueri: “¡Quejejiaquempiquea irijanijiate sanatari! ¿Taate cantajiaquempi picoraquecoraqueitantacaca ocaniqui noviñacajajiaquempiquea aatonijite icatsimajiguimpiquea Aapani Irioshi oncoramanitapojajegueti incatsimatimentajiaquerigueti maasano igovaeguisherejia? ");
INSERT INTO cotNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iintsijate pinquempetajemparo inchato oitsoquitananquitsica cameetsa, pinetsanamajajianaquempaja iramenajiaquempinijite maasano arimajaca picantashitatijaianaja povashiantajianajiro pantaguishejiavetacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aatoja picantajigui: ‘Aatoqueate icatsimajigana Aapani Irioshi, naroguentitari ichoviquijiani Averaameni.’ Pamenajigueroja oratica mapiporoqui. Irininquegueti Aapani Irioshi iragavejaquequeate impeacaajiajemparoquea ichoviquivaejianaqueca Averaameni. ");
INSERT INTO cotNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jac, yaajitiro poshontyo, itsitijitanaquero inchaquijitaquero ovari maasano inchato teeca oncameetsateji oitsoqui, ariquea intajaiquero paamariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Naatimpa iroguenti nantaque noviñacajatantajiaquempiro oja iramenantajiquemparoca arimajaca picantashitatijaianaca povashiantajianajiroquea pipeacaaguishetacaca, cotanquitsiquea incoraquepoje impoitapojenaneca caaviji yanaaquenaquea yagavejamajati. Ooshiatsi, aatotarite noquempejitaritsiquea iriatimpa nompeaquempame amiquerineca aitanaquerineca igaviguitire. Iriatimpa inquempetacaantaquemparo iroviñacajatantajiaquempiri Ishire Aapani Irioshi aisa paamari. ");
INSERT INTO cotNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Incoraquepojaquegueti iroashiguetapojempariquea queri tsaroventamajacarica. Inquempetanaquemparoquea aguerogueti oitsoqui, asagorejitemparo, ampishoncavaqueroquea oncoraquejencaquegueti chovigajenca, aanaqueroquea osagoma, oveguiseanaquempa oitsoqui. Aguijaavaqueroquea shimatoqui anquempoguijitemparoquea. Oraquea osagoma antaitemparoquea. Ariquea inquempetaquempaquea Amajirote incapiocajiapojaqueriquea tsaroventamajacarica intsipatsipaitanajempari jenoqui ichoocatigueti Aapani Irioshi. Iriraquea teeca intsaroventajiguempariji intigarancaqueriquea camorecariqui teeca ontsivacavaete, incoquempaniquea irantsipevaejiaquempaquea.” ");
INSERT INTO cotNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iroompaquea iquenapojaque Jesoshi Garireaqui yoanaque Jororanequi ichoocaquegueti Joanca cameetsaniji iriviñacajatavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cotanquitsiquea teequea irinintavetempaji Joanca iriviñacajateri, icantavaqueri: —Cameetsa aviguenti viñacajapojenane naatimpa. ¿Arimajampa picoraquetashiquena naatimpa noviñacajatempi? ");
INSERT INTO cotNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Icanque Jesoshi: —Aritaquequeate onquejetaquempaja imaica cameetsanijite anetsanajiaqueronijite maasano ininqueca Aapani Irioshi. Ariquea icanquequea Joanca: —Iintsijate. ");
INSERT INTO cotNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ariquea iviñacajataqueri. Iroompaquea yarejepojajatigaro Jesoshi otsapijaqui, ariqueate ocotanaca otanarejanacaqueate inquite, yameniriqueate yampiguiricashipojacariquea Ishire Aapani Irioshi iquejetapojacariquea emoreni. Yagatapojaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iroompaquea iquenquetsajencajitanaque jenoqui inquitequi, icanque: —Iricatica irio Irijani nopintsamajatacaca, noshineventamajatacari. ");
INSERT INTO cotNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iroompa iriraquea Ishire Aapani Irioshi yaanaqueriquea Jesoshi osamani oquitamampororoitapojaquegueti cameetsanijite iramenamajaquerinijite imajirote ampatsini arica iragavejaque irantacaaqueri teeca irininteji Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ariquea ichoocaque oraniqui 40 savincaguiteri, teequea irishecatempaji. Arimpa itaseamajatanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ariquea iquempejipojacari irira nintatsica incovaeguishetacaante, icantiriquea: —Iintsija arimajagueti aviguentica Irijanite Irioshi iintsijate pincanteroja ocatica mapi ompeanaquempata pan pishecataquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cotanquitsiquea Jesoshi icantiriquea: —Choocatarite otioncacocagueti ocanque: ‘Teequea aparo ontampishitacaanteji isheca caquinte, jero aisa maasano icanqueca Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iroompaquea ariquea yaanaqueriquea Jerosarequi, oratica guinteninintsi yashincaca Aapani Irioshi, icatiacaapojacariqueate teemporoqui itsaroventantajitarica Aapani Irioshi ochoviinatapojacagueti ocaravaequequea jenoqui ocanca, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Iintsija arimajagueti aviguentica Irijanite Irioshi, iintsijate pisapocanaquejate isaviji, ocanquetari itioncacojiquerogueti ocanque: ‘Intigarancajiaquempiri Irioshi irashivantijitete, quisho iroaroaitanaquempi.’ ‘Irajiricanaquempiquea irantsomajanaquempi aatonijite pitsitincapojaro mapi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Icantsitanaca Jesoshi icanqueriquea: —Cotanquitsiquea choocatarite itioncacojiquerogueti aisa ocanquequea: ‘Aatoquea pamenantaritsi Majirontamajatatsica Pirioshite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iroompaquea yaanaqueriquea otsempiqui jmm agasataanquitsica yonigaaguetaqueri maasanopae quepatsi yashincaca majirontaguetatsica aisa maasanopae yashintajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Icanqueriquea: —Ariguetija poguerovenquena pintsarovenquena, nojocaguetaquempiroquea maasanopae pamenaguetaqueca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Icantsitanajaquea Jesoshi aisa icanqueri: —Pijatequetiroshine, Satanashi, choocatarite otioncacagueti ocanquequea: ‘Pintsaroventaquemparija Majirontamajatatsica Pirioshite, aparoqueate iriguenti pimajirontamajaquempa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ariquea yoanaji imajirote ampatsini. Irioquea coraquecoraqueitajatsi irashivantijitete Aapani Irioshi yamitacojiapojajiri. ");
INSERT INTO cotNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iroompaquea iriraquea Jesoshi iquemacoquerigueti Joanca isantanatacojitaqueri, yoanajiquea Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Cotanquitsiquea teequea inchoocatantajemparoji Nasare, iroguentiquea yoantanaja Caperenao iriguintenitapojajemparo. Oraquea Caperenao iroguenti ochoocaque otsapijaqui iniromotijaqui. Iroatimpa iroguenti ochoocaque iguintenijiacagueti ichoviquijianaqueca Savoroone aisa Nepetari. ");
INSERT INTO cotNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ariquea iquejetaca imaica cameetsanijite irinetsanajiqueronijite itioncacotanaqueca tsavetantatsica Isaiashini coramani, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Oraquea iguepatsite Savoroone aisa iguepatsite Nepetari, choocatanquitsica intatiqueroqui Jororane, iquenaquenaitantajiacaroquea yoayoaitantapinicarogueti inirojani quentijani: Garirea ichoocatantajiacaca oshequini teeca irijorijoigueji. ");
INSERT INTO cotNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Irirajia pitsecacojiavetanquitsica inejajiaquero tsirencari tsirencavaetanquitsica; irirajia guinteninijianquitsica otsimancacojiavetacarigueti metojagantsi otsirencaguitetacojiaqueri tsirencari.” ");
INSERT INTO cotNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ariquea iparianacaro Jesoshi itsavetantavaetaque, icanque: —Pincantashitatijaianajempaja povashiantajianajerojate pipeacaaguishetacaca, irooshipojitarite aapojaquempaquea irimajirontaquempa acaniqui Inquitequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iroompaquea yoanaquequea Jesoshi oraniqui ishitaravijatanacaro otaravijaqui iniromotija Garirea. Inejajiapojiriquea Shimo (icantajitica aisa Peerero) itsipatacari iriguentijeguite pajitatsica Antirishi, tarajajiaquequea, irootaquequeate isavicaventajiguiquea iriatimpajia. Ariquea icantiri: ");
INSERT INTO cotNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Jame poguijaguijaitanaquenajate, imaicaquea irioquea pimpitsocashijianaquempa caquintejia, nagavejacaajiaquempiquea pinquejetacaajiajempari shima panquitacojiguirigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iroompaquea iriatimpajia yojocapanajantiroquea imantsatsitepae yoguijaguijaitanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yoayoaivetanaca tiijacoñaji ontaniqui irioquea yamenapojiquea Santiago aisa iriguentijeguite pajitatsica Joanca savisaviitaque quenajarontsiqui inetsanajiaqueroqueate imantsatsitepae. Itsipatsipaicari iriri pajitatsica Severeo. Iroompaquea iriraquea Jesoshi icanqueriquea Santiago aisa Joanca: —Jame poguijaguijaitanaquenaja. ");
INSERT INTO cotNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Taampina yojocajianaqueroquea quenajarontsi aisa iriri, yoguijaguijaitanaqueriquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iroompaquea yoanaquequea Jesoshi itsitacaguitejanaquero Garirea itsatacaantavaetanaque shinagogapaequi icapiocantajiacaca joriojia, itsavetantaquero Quenquetsatsarentsi Oganejencatatsica icantajiaqueri quero icotani imajirontagueti Aapani Irioshi. Aisa yogueshiguequeriqueate oshequini joquijiguetanquitsica aaguequerigueti cantashitatiajencaguetanquitsica ashinoncajagantsipae, aisa catsijianquitsica, jac peamajajianajaqueate. ");
INSERT INTO cotNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iroompaquea irirajia guinteninijianquitsica osamanipaequitica Shiriaqui iquemacojianaquerigueti yogueshitantaguetanaque jero yamajiapojaqueneriquea maasano ashinoncajajianquitsica. Iriatimpajia iroguenti icantashitatiaguecaquea icanca iconoaca yatsipevaetani oshequi. Itsipa iroguenti imetojapinitaquiti icantapinitaquiti tinquininini, itsipapae teeca ironquempaji, cotanquitsiquea iriatimpa yogueshiguetajiriquea maasanopae. Aisa yoguisotoacoventajiajiri ishaquiajiacarigueti ampatsinipae. ");
INSERT INTO cotNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iroompaquea yoguijaguijaitanaqueriquea icaramirincavaequequea caquintejia quenaquenaitapojanquitsica Garireaqui, Tecaporishiqui, Jerosarequi, Joreaqui irooca aisa quenaquenaitapojanquitsica intatiquero Jororane, icaramirincajiaque. ");
INSERT INTO cotNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iroompaquea yamenajiaquerigueti Jesoshi maasano capiocaventajiacarica icaramirincavaequequea oraniqui, itoncoanaque isavicaquequea niganquitantanaqui, ariquea iquempejijiapojacari itsatacaanejia iquemisantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ariquea itsatacajaiaqueri icantajiaqueri: ");
INSERT INTO cotNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Caavijiquea irishinevaequempa maasano tsatanquitsica ishirequi tee iragavejamajatempaji, iriguentitari intsipajiaquempa Inquitequitica imajirontagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Caavijiquea irishinevaequempa maasano shimampojancajianquitsica, iroguishinejajiaqueriquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Caavijiquea irishinevaequempa maasano teeca iraventacojiguempaji, irojocajitaqueneritari maasano quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Caavijiquea irishinevaequempa maasano nintamajajiatsica incomajamajajiaquempa inquejetemparigueti taseatsica aisa miretatsica, iragavejacajaiqueritari irinetsanajiguero ininqueca quejetaca inquemempagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Caavijiquea irishinevaequempa maasano pintsatacotantajiatsica, impintsatacojitaquemparitari. ");
INSERT INTO cotNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Caavijiquea irishinevaequempa maasano comajashirentajiatsica, iriojiatari amenerineca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Caavijiquea irishinevaequempa maasano gameetsantajiajerineca igonorojia, incantacojiqueritari: ‘Iriojia irijanijiate Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Caavijiquea irishinevaequempa maasano irantsipetacaajiquemparigueti incatsimatimentajiquerigueti incomajamajaquempagueti, iriguentitari intsipajiaquempa Inquitequitica imajirontagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Caavijiquea pishinevaejiaquempa pamenajiaquegueti incantaguishejiaquempi, incatsimacatsimajiaquempigueti, aisa intsojeventajiaquempigueti iramenajiaquempigueti pitsaroventajiaquenaquea naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pamenajiaquegueti inquejejiaquempigueti imaica pishinevaetanaquempaja, pitsajiaque incavintsajamajataquempiquea Aapani Irioshi oncoramanitapojajegueti ontaniqui inquitequi. Ariqueate iquempejitaqueri tsavetantajiatsica choocajiatsica coramanipaequitica yatsipetacaajiacari catsimajiaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Aviatimpajia conoajigarica quepatsiquitica piquempejiacaro incachoane. Cotanquitsiquea ariguetija omasancategueti, ¿querocampate incojitajeroni incachoanetantajitajemparo? Aatoquea inintajitajiro, manaquea impishoncajiqueroquea intati, iragatigatijitaquero intati. ");
INSERT INTO cotNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aisa aviatimpajia quempejiaquempi tsivotacojiguirica maasano caquintejia. Pamenajiguirotarite oratica tsovironaquipae impeacajaitemparogueti otsempiqui incapiocajiterogueti oshequiavaetanaque oncanquempa, ¿arimpate aatoquea yamenajitirotsi? Iramenajiqueroquea, onconijavaeque. ");
INSERT INTO cotNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ariquea iquejetaca aisa tsivorentsi itsivojitirigueti teetarite ariquea iroguivotacojiteriji chomoqui, iroguenti yoguisavicacojitiri jenoquijaniqui cameetsanijite intsivotanaquenerinijite maasano choocajianquitsica tsovironaquiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ariqueate pinquempejiaquempa aviatimpajia pincomajamajajiaquempaja pimpeacaajiaquemparo cameetsaguetatsica cameetsanijite iramenajiaquempigueti maasano, ariquea irishineventamajajianaquemparinijite Piri choocatatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aato pijijiguitsi iroguenti nocoraquetashitaque novashiantacaajempiro piquemisantirogueti itioncacotanaqueca Moishishini irooca aisa itioncacotanaqueca tsavetantajiatsica coramani, teetarite irooquea noncoraquetashiteji, iroguentiquea nocoraquetashitaque onetsanamajaquempaniji maasanopae icantajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Arimajaca noncamantaquempi: aatotagueti opeitsita inquite aisa quepatsi, aatoquea opegatsi apaitsoquijaniqui Itioncacaantaqueca Aapani Irioshi, onetsanamajatanaquempaquea maasanopae icanqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Quericaca teeca irinetsanamajateroji maasanopae icanqueca Aapani Irioshi, aisa intsatacaajiaqueriquea itsipapae inquejejianaquempa iriatimpajia, oncoramanitapojajegueti irisavijisavijitapojajequea inquitequi imajirontacagueti Aapani Irioshi, itsipajia iranaantapojequea. Cotanquitsiquea iriraquea netsanamajaqueroneca, aisa intsatacaajiaqueriquea itsipapae inquempejianaquempa iriatimpa irinetsanamajajianaqueroquea, caaviji iranaavaepojaje ontaniqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nocantantajiaquempica imaica aatogueti picomajamajajiga, aatogueti panaacojiguiri tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa pariseojia, icomajamampeajiacagueti, aatotarite pagavejitsi pinquijanaque imajirontagueti Inquitequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Pitsajiaqueroquea icantajitiri pivaesatinite: ‘Aatoja pimetojanti, maasano metojantajianquitsineca irantsipetacaimentajiquempari yantaqueca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Cotanquitsiquea naatimpa noncantajiaquempi quericaca catsimataquerineca igonoro inquejetacaajitaquempariquea iriatimpa oncoramanitapojajegueti irantsipetacaimentajiquempari yantaqueca. Aisa quericaca cantaquerineca igonoro: ‘Aviatimpa tee pintsatimateji’, irajaitanaqueriquea majirontatsicaqui incatsimajitaqueriquea. Cotanquitsiquea iriraquea cantaquerineca itsipa: ‘¡Aviguenti covaeguisheri!’, shoshoh itsigatsi camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Irootaquequea nocantantajiaquempica poapoaitanaquegueti teemporoqui itsaroventantajitarica Aapani Irioshi paanaquegueti pivira pijitorejacaantaquenerigueti aretarequi, ariquea taampinagueti pinquenquejapojaquerogueti pincanque: ‘Choocatari icatsimatimenquenaca nogonoro’, aatotajate pijitorejacaantiritsijate. ");
INSERT INTO cotNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Manaquea pojoquijipanajanteritaja oneguitapojacagueti aretare, poapanajantetaja pogameetsatapanajanteritaquea pigonoro. Iroompa ariquea poashitanajeriqueate pivira pijitorejacaantaqueneriquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Incatsimaquempigueti pigonoro irinintavequempagueti iraanaquempiquea jivatatsicaqui irisantanatacotacaanquempi, pinquenquetsatacaanajerija quenavoquirontsiqui pogameetsatanajeri taampina aatonijite yaguimpi. Arigueti iraanaquempi jivatatsicaqui joesequi iriotaque cajemaquerineca coareta, iriraquea coareta manaquea iraapanajantempiquea irisantanatacotsitempi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Arimajaquea aatogueti povegaramajatajiri catsimataquempica maasanopae paacotaquerica, aatoquea yoguipaquijajimpitsi santanatacoquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Aviatimpajia pitsajiaquerotarite icantajitaquero paesatoniqui: ‘Aatoja poashitirotsi manquigarentsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Cotanquitsiquea naatimpa noncantajiaquempi quericaca nevequemparoneca manquigarentsi, quejecaquea yoashitaquero, iquenquejaquerotarite yamenaquerogueti. ");
INSERT INTO cotNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nonquejetacaajiaquempiroquea imaica: arigueti oncovaeguishetacaaquempi poquijamajaca pinquitsorejaaquempa pimpishoncaquero. Cameetsavaequequeate pimpishoncaquerogueti covaeguishetacaaquempica pinetsanatimentanajempanijite. Aatoguetitarite pipishonquiro jatanatsitarite oncovaeguishetacaajempi, iroompa pimetojanajegueti impishoncajitaquempiqueate camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aisa iroogueti covaeguishetacaaquempine pacomajaca ariqueate pincarataquero pimpishonquitsitemparo. Cameetsavaequequeate pimpishoncaquerogueti covaeguishetacaaquempica pinetsanatimentanajempanijite. Aatoguetitarite pipishonquiro jatanatsitarite oncovaeguishetacaajempi, iroompa pimetojanajegueti impishoncajitaquempiqueate camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aisa icantajitironi paesatoniqui: ‘Quericaca nintanquitsineca irovashiantanajero imanquigare, irojocaqueneroja paperi oncanque: “Imaica novashiantajiro nomanquigavetacaca.” ’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Cotanquitsiquea naatimpa noncantajiaquempi quericaca ovashiantaqueroneca imanquigare apaniro oaquerica, arigueti omanquigatajempagueti itsipa jac icovaeguishetacaacaro, omanquigatajatarite itsipa teeca irio omanquigaremajaca. Ariquea iquejetaca quericaca manquigataquemparoneca yovashiantajitica jac icovaeguishetaca. ");
INSERT INTO cotNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Aisa pitsajiaquerotarite icantajitaqueri paesatoniqui: ‘Aatoja pitsojega. Aato picantashita intati: “Incatsimatimentenarota Aapani Irioshi aatogueti nonetsanatiro nocanqueca.” Arigueti pincantero, pinetsanamajateroja maasano picanqueca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Cotanquitsiquea naatimpa noncantajiaquempi aatoja pitsojeimatatsi aatonijite oavaetanaque pinintajiguitsi pincantajigue: ‘Incatsimatimentenarota Aapani Irioshi aatogueti nonetsanatiro nocanqueca.’ Aisa aatoja piquenquetsatacojiguirotsija inquite, aato picantajiguitsi: ‘Nontsojeaquempagueti ompeguempata inquite’, iroguentitarite imajirontamento isavicantacaca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ari oquejetaca quepatsi, aatoja piquenquetsatacojiguirotsi, aato picantajiguitsi: ‘Nontsojeaquempagueti ompeguempata quepatsi’, iroguentitari ivanqueguititacaca. Aisa aatoja piquenquetsatacojiguirotsija Jerosare, aato picantajiguitsi: ‘Nontsojeaquempagueti ompeguempata Jerosare’, iriguentitari ashincaro Majirontamajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aisa aatoja picantajigui: ‘Nontsojeaquempagueti nonquitamaromaetanajeta’, teetarite pagavejajigueji aviatimpajia pinquitamaromaejigueroji irooca pinquisaamaetacaajero apamaerotica pimae. ");
INSERT INTO cotNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aatoja piquejetacaajigarotsi, manaquea pincantajigue: ‘Jeeje’, irooca manaquea pincantajigue: ‘Tee’. Oraquea iroguentica pinquenquetsatacojiaque quejeguetacaroca imaica cameetsanijite inquemisantajiaquempinijite itsipapae, manaquea oquenantapojacari ampatsini icantajitica covaeguisheri. ");
INSERT INTO cotNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Aviatimpajia pitsajiaquerotarite icantajitiro paesatoniqui: ‘Quericaca tyaquisaatantanquitsineca ariqueate inquejetacaajitaquempariquea iriatimpa intyaquisajaitaqueri. Aisa quericaca jararejitsiquerineca iraji, ariqueate inquejetacaajitaquempariquea iriatimpa irijararejitajiqueriquea iraji.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Cotanquitsiquea naatimpa noncantajiaquempi aatoja pipigajigaritsija catsimataquempineca. Quericaca capojaquempineca pivoroqui pimpitsocanaquempaja inquejetacaaquemparo otsipavoroqui. ");
INSERT INTO cotNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Choocagueti nintanquitsineca iraanaquempi jivatatsicaqui iraitsiquempironiji piitsaare intsompoguitica, pishinetsitempariqueate aisa piitsaare jenoquitanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Choocagueti aanaquempineca iromperaquempigueti incanquempi: ‘Pinquijanaquenaroja ontaniqui’, poavaetanaquequea panaavaetanaqueroquea icanquempica poavaequiteneriquea osamani. ");
INSERT INTO cotNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Quericagueti amanaquempineca taaca opajita, pojocaqueneriquea. Aisa quericaca cantaquempica: ‘Pojoquenaja ocatica, noguipiajatempirotari coajica’, aato pipitsocapitsatari. ");
INSERT INTO cotNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Piquemajiaquero icantajiqueca: ‘Pimpintsataquemparija pigonoro pincavintsajaquerijate, pisemaquempari catsimataquempica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Cotanquitsiquea naatimpa noncantajiaquempi pimpintsataquemparija catsimajiaquempica. Aisa pamanacoventajiaquerija maasano atsipetacaajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pinquejejiaquempaquea imaica pinquempetimentajiaquempariniji Piri choocatatsica inquitequi. Quempeca iriatimpa ivoreguirigueti catsirincaiteri cameetsanijite irivoreacojiaquerinijite maasano caquintejiatsica, irioca cameetsajiatsica aisa teeca incameetsajigueji. Ariqueate oquejetaca incani iroatimpa itejiniri maasano, comajamajajiatsica aisa covaeguishejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Noncantajiaquempi aparogueti iriatimpa pincavintsajajiaque cavintsajimpica, ¿arimpate irishineventsiquempiro Aapani Irioshi? Ariquea iquempejiga imaica amatavijantajiatsica capiocapinijiguinirica majirontatsica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ari oquejetaca aparogueti iriatimpa pinquenquetsatacaajiavaque pigonorojia, ¿arimpate panajaiaqueri itsipapae? Ariquea iquempejiga imaica irirajia teeca intsaroventajiguempariji Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pincomajamajajianaquempaja pinquempejianaquemparija Piri choocatatsica inquitequi icomajamajatacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Aatotarite mana picavintsajantantajigui iramenajiaquempiniji caquintejia. Pinquempejiaquempagueti imaica aatotarite ishineventajiguimpitsi Piri choocatatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pimpintsatacojiaquemparigueti teeca irashintempaji pojocajiaquenerigueti icoguitejacojiacaca, aatoja picamantiritsija pigonorojia aatonijite piquejejigaritsi tsaroventamampeajiatsica intati. Iriatimpajia iroguenti isemetacaantajiaque shinagogapaequi acapiocantapinicaca irooca aisa oraniqui quenavoquirontsipaequi cameetsanijite irishineventajiaquemparinijite igonorojia, cotanquitsiquea imaica noncantajiaquempi aatotarite ishineventajigaritsi Aapani Irioshi quempejiguiroca imaica, iriguenti shineventajiacari igonorojia amenajiaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pojocajiaquenerigueti quericaca coguitejacojianquitsica aatotarite quericaca picamantitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Santicoguitenija pojocaqueneri. Iroompaquea iramenajiaquempigueti Aapani Irioshi picavintsajamajatantaque, irioquea shineventajiaquempineca, ariquea pamenacojiaquempaja oncoramanitapojajegueti ontaniqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pamanajiaquerigueti Aapani Irioshi aatoja piquempejigari tsaroventamampeajianquitsica intati yamanamampeajiacari. Iriatimpajia iroguentiquea inintavintsajiaque incatintiijiaque shinagogapaequi irooca aisa oquenavoquiguecagueti yamanamampeajiacari cameetsanijite iramenajiaquerinijite igonorojia. Irirajia quejejianquitsica imaica aatotarite ishineventaritsi Aapani Irioshi. Aparoquea shineventajiaquemparine amenajiaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cotanquitsiquea pamanerigueti Aapani Irioshi poanaqueja pinquijanaquequea pitsovironaquitequi pashitacotanaquempa aparo, ariquea pamanaqueriqueate. Iriatimpa yamenaquempiquea aparo pichoocaque pamanaquerigueti, inquemaquempiquea irishineventaquempi, ari incavintsajaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pamanerigueti Aapani Irioshi, aatoja pamanavijitiri intati vero vero vero, aatonijite piquejejigaritsi teeca intsajigueriji Aapani Irioshi. Ijiqueji inquemisantavaqueri arigueti incantacoguitempani vero vero vero. ");
INSERT INTO cotNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aatojate piquempejigaritsi iriatimpajia, itsatsitacarotari Aapani Irioshi maasano picoguitejacocaca tequeratatirajagueti pamaneriji. ");
INSERT INTO cotNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pamanajiguerigueti mana pinquempejiaquempaja imaica, pincantajiaque: ‘Aapani choocatatsica inquitequi, noninque intsaroventamajajiaquempiquea maasano caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Caacateja pimajirontamajapojaquempa. Noninquequea irinetsanamajajiqueroja ocaniqui quepatsiqui maasanopae pininqueca aviatimpa, onquejetantaquempaca inetsanamajajiquerogueti ontaniqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pojocaquenaja imaica noshecatapinijiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimpeacotsitajenaroja nogovaeguishere, quejetaca naatimpajia nopeacotsijiajari antaguetaqueroca teeca oncameetsateji. ");
INSERT INTO cotNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aato pishinejiganarotsi oncoraquetashijiaquena aatoca notampishitashiti nocoguishetatsi. Manaquea noninque pintampishitacaamajajiaquenaja aatonijite yagavejajana ampatsini incovaeguishetacajaena.’ ");
INSERT INTO cotNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Arigueti pimpeacotsijiajempari yantaqueca caquinte, ariquea inquempetaquempaquea Piri choocatatsica inquitequi impeacotsitajempiroquea maasanopae pantaguishevetacaca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cotanquitsiquea aatogueti pipeacotsijigaritsi yantaguishejiaqueca caquinte, aatotarite ipeacotsijiajimpirotsi Piri pantaguishejiaqueca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ariguetijate pisanticotaquitero pisheca cameetsanijite pisavicavenquerinijite Aapani Irioshi, aatoja pishimampojancamampeajiaja intati, aatonijite piquempejigariquea tsaroventamampeacarica. Iriatimpajia iroguenti ishimampojancamampeajiaca intati iramenajiquerinijite isanticoquitiro isheca. Cotanquitsiquea irirajia quempejianquitsica imaica aatotarite ishineventaritsi Aapani Irioshi, aparoquea shineventajiaquemparine amenajiaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cotanquitsiquea aviatimpajia pisanticotaquiterogueti pisheca cameetsanijite pamaneri Aapani Irioshi, pinquishijiaquempaquea, aisa pinquivavorojiaquempaja, ");
INSERT INTO cotNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aatonijite itsajiguimpitsi pigonorojia pisanticotaquitiro pisheca. Irioquea amenajiaquempine Piri teeca iramenajiteriji. Iriatimpa yamenajiaquempi pichoocatigueti apaniro, ariquea irishineventajiaquempiquea iroguishinejajiaquempi ariquea pamenacojiaquempa oncoramanitapojajegueti ontaniqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aatojate iroguenti pishineventajiatsi pashintajiaquempa ocaniqui quepatsiqui, onconoagaranquempaqueate irishecaguetaquemparo shecaguetaroca, otsipapae oyogueguetanaque ompomatsatanaquempa, otsipapae inquijaguetanaque aitsitantatsica iraitsiguetaquempiro. ");
INSERT INTO cotNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iroguenti pishineventamajajiaquempaja maasanopae inintaguetica Aapani Irioshi cameetsanijite incavintsajamajajiaquempinijite iroguishinejajiaquempiniji oncoramanitapojajegueti ontaniqui inquitequi. Ontaniquiquea ontaniqui aato ichoocati shecaguetaroca pashintaguecaca, aatoquea oyogueti, aato yaitsijitajimpiro. ");
INSERT INTO cotNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aritarite taaca opajita pishineventamajataca manaquea pisavicaventaguitironi piquenquejaguitironi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Poquija oquempevecaro otsivore pitsino. Arigueti oncameetsate poquija, pamenamajate, onquempetaquemparo otsivoguitemajatigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aatogueti ocameetsati poquija, aato pamenantamajataro, onquempetaquemparo pipitsecacotigueti maasanotsino. Ari oquempetaca, arigueti ompitsecanaque tsivoshirentaquempimeca, pimpitsecacomajatatiguenimaja. ");
INSERT INTO cotNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tee inchoocateji agavejanquitsineca irantavaetaqueneri mavite ashintaquemparica. Manaquea irisemaneguintaquempari aparo, iriraquea itsipa impintsataquempari, irooca inquemisantamajataqueri aparo, itsipaquea intsojencaneguintaqueri. Aato pagaveji pantaqueneri Aapani Irioshi inintaguetica, iroogueti pisavicaventaque pajaarantavaequempa quejetaca irooquea ashintaquempi ajaararontsi. ");
INSERT INTO cotNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Imaicaquea noncanquempi: aatoja pishoshoventajigaro pisheca irooca pimirajiaquempaca choocatacaajempineca, aisa aatoja pishoshoventajigaroquea pinquitsaajiaquempaca. Oraquea pishire anijacajaiguimpica ¿teempa anagueroji pisheca? Aisa pitsino ¿teempa anagueroji quitsaarentsipae? ");
INSERT INTO cotNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pamenajiguiriquea araguetatsica, teequea irivintyacavetempaji, aisa teequea onchoocavetempajiquea incapiocantaquemparoca isheca iroaroaitapinijigue iraapinijiaquequea irishecajiaquempaca, cotanquitsiquea Piri inquitequitica yojocapinijiaqueneriquea ishecajiacaca. Aviatimpajia ¿teempa panaamajajigueriji iriatimpajia? ");
INSERT INTO cotNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Arigueti pishoshoguiteventavequemparo pigatsantsare ¿arimpa pagavejaque pincatsantsatanaje niganqui meetero? ");
INSERT INTO cotNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Iroosacanica ¿queroca ococani pishoshoguiteventajiacaroquea pinquitsaajiaquempaca? Pamenajiguirotarite ocatica ovempenaquipae inchiquiojiquea otsoroashiguecaquea iroatimpa, teequea oncatsiquejiavetempaji aantaquemparomeca oitsaare, aisa teequea onquiricajiavetempaji, ");
INSERT INTO cotNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ariqueate ocameetsamajavioti anaavaequequea ocanca ocameetsavaeque, anaaguequeroquea quitsaarentsi cameetsamorenaguetatsica coramanitica iquitsaajiacaca majirontatsica Saromonini caavijica anaaque ocameetsamorenamajataquequea. ");
INSERT INTO cotNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Quempeca ocatica ovempenaquipae oporencanaque poren icameetsatacaaguetaqueroquea Aapani Irioshi, cotanquitsiquea osaitequera taampina oshimpeguiricanaque shimpeguiririri, irajaiqueroquea intajaiquero. ¡Aviatimpajiaquea caaviji irojocajiaquempiquea pinquitsaajiaquempaca, caavijitari panajaiaqueroquea ovempenaquipae! Cotanquitsiquea aviatimpajia teequea paventamajatempariji, manaquea pishoshoventajiaca taaca opajitapae. ");
INSERT INTO cotNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Noncantantajiaquempica aatoja pishoshoguiteventajigarotsija pincantajiaque: ‘¿Querocashiatsi noshecataquempaca? ¿Taate nomirajeca? ¿Querocaquea naajeroquea nonquitsaatajempaca?’ ");
INSERT INTO cotNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iriguentiquea quempejiguiroquea imaica irirajia teeca intsaroventajiguempariji, ishoshoventajiacaroquea taaca opajitapae, irootaquequeate isavicaventajiaquequea iriatimpajia. Cotanquitsiquea aviatimpajia aatojate piquejejiguirotsija imaica, choocatarite Piri inquitequitica. Iriatimpa itsataque maasanopae picoguitejacojiacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aviatimpajiampani pinintamajajigue pimajirontamajatanaquempari Aapani Irioshi pishineventajiaquemparoja pisavicaventajiaquerojate maasanopae inintaguequeca iriatimpa, ariquea iriatimpa irojocajiaquempiquea maasanopae picoguitejacojiacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aatojate pishoshoventajigarotsijate pincantajiaque: ‘¿Querocate noncotaquempani osaitequera?’ Ococaniquea savincaguiteriqui chooca taaca opajita manapitsajiaquempineca pinquenquejacoqueca. Osavincaguitevetanajempagueti otsipapae choocatatsineca pinquenquejacojiajeca. ");
INSERT INTO cotNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Pamenitaquerigueti yantaguishetaqueca itsipa aato piquenquejitsi: ‘Teequea incameetsateji, icovaeguishetaca’, aatonijite iquejetacaajitimpi aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Irooriji querocaca pinquenquejacotsiterica itsipa, ariquea inquempetacaajitaquempi aviatimpajia. Querocagueti pincotsiterini itsipa ariquea inquejetacaajitaquempi aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“¿Querocaquea picocani pamenantacarica itijaarojaniqui pigonoro cotanquitsi tee pinquenquejacoteroji inchapoa poquijaqui pashi aviatimpa? ");
INSERT INTO cotNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Arimpate pagavejaquempa pincanqueri pigonoro: ‘Iintsija nonquitsoajempiro pitijaaro’, choocatirajagueti inchapoa poquijaqui pashi aviatimpa? ");
INSERT INTO cotNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cameetsatamampeatsica, iroquetitarite pijivatavaque pinquitsoavajerota inchapoa jocaaquempica aviatimpa, ariquea pamenamajatanaje pinquitsoimentajenerinijite tijaataquerica pigonoro. ");
INSERT INTO cotNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Aatoja pojoquiniri shiishi querocaca yashincaca Aapani Irioshi. Oquempetaca aisa aatoja pipishonquiniri chanchopae piveererate vegaramajatanquitsica. Pinquempetaquempagueti mana iragatigatiivaequero, ariquea impitsocashiitsitempi aviatimpa inteshireteshirejaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pamanajigueri Aapani Irioshi taaca opajita picoguitejacojiacaca, ariquea iriatimpa irojocajiaquempiro. Pamenagueteroja taaca opajita, ari pamenapojero. Aisa pintinquiapojerogueti sotomorontsi, ari irashirejacojiquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aritarite iriraquea amanantatsica irojocajiqueneri. Iriraquea amenaguetatsica iramenapoje. Aisa iriraquea tinquiguiroca sotomorontsi irashirejacojiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Arimpate pinquempejiaquempa aviatimpajia iramanempigueti pirijanite pan arimpate paitsitenempari mapi pojoquitenempari? ");
INSERT INTO cotNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Iriogueti iramanempi shima, ¿arimpate paitsitenempari pojoquitenempari camaarini? ");
INSERT INTO cotNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Avirovetaca covaeguishejiatsica pitsajiaque pojocajiguiniri pirijanijiate taaca opajitapae cameetsaripae, iriompate Piri choocatatsica inquitequi caaviji irojocajiaquempiquea cameetsaguetatsica pamanajiaquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Taaca opajitapae pantajigue pincavintsajajigueri itsipajia, pinquejetacaguemparo pininquegueti incavintsajaquempi aviatimpa. Irootarite ocanque itioncacotanaqueca Moishishini aisa itsipajia tsavetantajiguiroca icanquerica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pinquijantajianaquemparoja sotomorontsi chaamorojaniquitica. Choocatarite otsipa sotomorontsi iniromorojeguini ocanca aisa quenavoquirontsi iniropoquivaetaque ocanca oavoquivaetananquitsica isaviqui camorecariqui. Iroguentiquea iquijaquijaitantacaca icaramirincavaeque caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cotanquitsiquea oraquea sotomorontsi chaamorojaniquitica aisa quenavoquirontsi orijanipoquijaniquitica mana oquenavoquitanaca anijagantsiqui. Teemajaca incaramirincateji nejaqueroneca. ");
INSERT INTO cotNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Inchiquiojitaja yamatavijajiguimpitsi tsavetacotamampeajiacarica Aapani Irioshi, inquitsaatsijiavequempari imae oveja, cotanquitsiquea intsompogui iriguentijia lobo catsimari. ");
INSERT INTO cotNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aviatimpajia pamenamajajiavaquero yantajiaqueca pintsatantajiavaquemparica quero icocani iriatimpa. ¿Arimpate iraantajitemparo ovaitsoqui samerento? Aato yaantajitaro. ¿Arimpate iraantajitemparo igo poronqueto? Aatoquea. ");
INSERT INTO cotNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ariqueate oquejetaca, maasanopae inchato cameetsaguetatsica oncameetsasovenatanaque. Oraquea inchato teeca oncameetsateji, irootaque ochoocatantaca osovena teeca oncameetsateji. ");
INSERT INTO cotNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Oraqueate inchato cameetsatatsica aato agaveji ochoocatantaro osovena teeca oncameetsateji. Aisa oratica inchato teeca oncameetsateji, aatoquea agaveji ochoocatantaro osovena cameetsatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Maasanopae panquirentsi teeca oncameetsateji osovenapae inchaquitsitemparoquea iraanaquero intaitemparoquea. ");
INSERT INTO cotNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ariquea iquempejiaca caquintejia, pamenitsijiaqueri yantajiaqueca pintsatantajiaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aatotarite maasano iquijaquijaiti imajirontagueti Inquitequitica cantajiaquenaneca: ‘Nomajirote, Nomajirote.’ Iriguentiquea quijaquijaitananquitsine irirajia maasano netsanamajajiaqueroca inintaguetica Aapani choocatatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oraqueate aapojempagueti oratica savincaguiteri, incaramirincavaetanaquequea cantajiavetanaquenaneca: ‘Nomajirote, Nomajirote, notsavetantajiaquempi, aisa naventashijiacari pivajiro noguisotoaguetajiniri ishaquiajiavecaca ampatsini, aisa nonigaantajiaqueroquea oacaantantatsica intati nocantajiaque aviguenti agavejacaaquena.’ ");
INSERT INTO cotNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cotanquitsiquea naatimpa noncantajiaqueri: ‘Teequeate nontsajiguempiji, poapoaitanaquequea osamani maasano aviatimpajia antajiguiroca covaeguisherentsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Imaicaquea noncantajiaquempi quericagueti quemisantaquenaneca netsanamajataqueroneca nocanqueca ari inquempetaquempari quenquejamajatatsica vinchajiroca itsovironaquite shiratantapiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iroompaquea otejavetanaca incani amaravetanaca ojaaquiniqui, ochovigaguitevaetanaquequea jeoc jeoc jeoc, cotanquitsiquea teequea agavejeroji osoveanaqueroji, oquishomajataquetari shiratantapi ochoocatantacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Iriraquea quemavetavaquenaneca cotanquitsiquea teequea irinetsanateroji nocanqueca, manaquea iquempetacari teeca inquenquejamajateji peacaavetacaroca itsovironaquite impanequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iroompaquea otejavetanaca incani, amaranaque ojaaquiniqui, ochovigaguitevaetanaquequea jeoc jeoc jeoc, ariqueate ocotanaca osoveanacaquea itsovironaquite, ocantavaeti soven.” ");
INSERT INTO cotNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iroompaquea iteroncanajirogueti Jesoshi itsavetantaquerogueti, yamenamenaitanaquequea intati maasano quemisantajiaquerica, ");
INSERT INTO cotNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yamenajiaqueritari itsatacajaiaquerigueti choocaquea iragavejane, teequea inquempejiguempariji tsatacaantajiguiroca itioncacotanaqueca Moishishini. ");
INSERT INTO cotNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iroompaquea yoguirincanaja Jesoshi otapiqui, ariquea isaquiritsaeventajianacari icaramirincavaeque caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Icoraquepojaquequea aparo avejancari iguerovempojacari icanqueri: —Nomajirote, arigueti pininque, pagavejaque piveajena. ");
INSERT INTO cotNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iriraquea Jesoshi icantajempequitanaca ipamitsitari, icanqueri: —Jeeje, noninque. ¡Pimpeanajempaja! Iroompaqueate icanquitiguiri jac ipeanaja yavejancavejancaacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iroompaquea icantavajiri Jesoshi: —Aatojate picamantitsija. Iriguenti poimotanaque saserorote ponigaapojemparija, paanajenerija viratsipae pinetsanaqueroja icanqueca Moishishini cameetsanijite iramenamajaquempinijite, ariquea incanquempi peanajimpi intsajiaquempinijite maasano peamajatanajimpi. ");
INSERT INTO cotNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iroompaquea yoanaque Jesoshi Caperenaoqui. Ariquea yarejetapojacaroquea yameniriquea icoraquepojaque aparo Iromaquitica. Iriatimpa iriguenti imajironcaca 100 igoaretajiate. Iroompaquea icampojiri: ");
INSERT INTO cotNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Nomajirote, inorijaguitani nashincaca notsovironaquitequi, teetari ironquempaji, yatsipevaetaca. ");
INSERT INTO cotNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Icanqueri Jesoshi: —Iroosacanica noanaque nogueshitajateri. ");
INSERT INTO cotNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Icanquequea imajirote coaretajia: —Nomajirote, aatotarite piquijitsitanarotsi notsovironaquite, notsaquetarite panaamajataquenaquea. Pincantajaniquiqueja impeapanajantempaquea nashincaca. ");
INSERT INTO cotNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Quejetaca naatimpa ichoocaveca tigarancanaca, ariqueate ichoocaque nashi nogoaretajiate notigarancajiguica. Noncanterigueti: ‘Pijate’, ari iroanaque. Itsipaquea noncanterigueti: ‘Caacate’, incoraquetaque. Aisa ichoocaque nashincaca taaca opaji nomperacarica iquemisanquenaquea. ");
INSERT INTO cotNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Irooquea iquemavaquerigueti Jesoshi icanqueca yamenanaque intati, icantajiguiri oguijaguijaiquerica: —Arimaja noncanquempi, teequea namenimagueteji aparo acaniqui Ishiraeriqui inquejetempariji irica itsamajatigueti nagavejamajati, iquemisantamajataque. ");
INSERT INTO cotNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Noncanquempiquea irimajirontaquempagueti Inquitequitica, ariquea incoraquecoraqueipoje caquintejia irisaquiritsaevaepojaque inquenaquenaipoje jmm osamanipaequitica isotoguigueti catsirincaiteri, itsipajia inquenajiapoje iquijigueti catsirincaiteri, intsipajiapojempariquea Averaameni, Ishaaconi aisa Jacovoni irishecajiaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Cotanquitsiquea irirajia joriojia inintajiavecaca Aapani Irioshi iroaroaitanaqueme aatotarite yoajiguiquea, manaquea intigarancajiqueriquea osamani ocanquegueti manquimanquimanqui. Ontaniquiquea ontaniqui incoquempanija iriraaguitempani irantsicayajijianaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iroompaquea ipitsocashitanacari imajirote coaretajia icanqueri: —Poanajeja, pitsaquetarite nagavejamajati nogueshitajeri pashincaca, imaica impeanajempa. Irooquea icanquitigui Jesoshi jac peanaja. ");
INSERT INTO cotNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iroompaquea yoanaque Jesoshi itsovironaquitequi Peerero, yamenapojiroquea ivaguirote Peerero, ashinoncajaca onorijaca ocatsirincavaeque. ");
INSERT INTO cotNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yaavacopojaquero ariqueate ocotanaca opeanaja ogatsirincare, ariquea ocatianaja ojocacojiajiniri irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iroompaquea opitsecanaquegueti yamajiapojiniri Jesoshi icarajiavaetaque ishaquiajiacaca ampatsini. Irooquea icantaquitigui Jesoshi ariquea icohicoitanaca ampatsinipae yovashiantajianajiri ishaquiajiavecaca. Aisa yogueshiguetajiri maasano ashinoncajaguetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ari icanque paesatoniqui tsavetantatsica Isaiashini itsavetacotantaquerigueti icanque: “Yaitanacajiro agavejavetacajica, aisa yogueshiguetajaji ojoquijijiacagueti.” ");
INSERT INTO cotNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iroompaquea yameniriquea Jesoshi icaramirincavaeque capiocaventajiapojacarica, icantajiguiri itsatacaanejia: —Jaame amontemonteitanaquempaja intatiqueroqui. ");
INSERT INTO cotNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ariquea icoraquepoji tsatacaantiroca itioncacotanaqueca Moishishini, icanqueri Jesoshi: —Tsatacaantantatsica, noninque noncoguitempani noguijaguitempini querocagueti poanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Icanque Jesoshi: —Iriraquea zorro chooca imoro iquijantacaca. Ariquea iquempejiaca tsimeripae chooca imencoshi, cotanquitsiquea iriraquea Irijanite Caquinte teequeate onchoocateji itsovironaquite irimaantaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iroompaquea icanque aparo itsatacaane: —Nomajirote, nonintaveca noguijaguitempini, cotanquitsiquea iroquetita nonquitatanajeritaja aapani. ");
INSERT INTO cotNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Icanque Jesoshi: —Poguijatanaquenaja. Pishineteri metojari ashincarica inquitatajaterita metojari. ");
INSERT INTO cotNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ariqueate itetanajaroquea Jesoshi quenajarontsi itsipatsipaitanacari itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Incajaranquiguitetanaquegueti ochovigaguitetapojiquea inirojencatapojaque choviga jeoc jeoc jeoc, otamacojatanaque iniromotija oshaguishaguivaetanaqueroquea quenajarontsi. Iriraquea Jesoshi yojocanacani tin. ");
INSERT INTO cotNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Itsaroajianaque itsatacaanejia itinajitsitari icanqueri: —¡Nomajirote, paavaquenashiatsi ojocajatempanishiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iriatimpa icantajiguiri: —¿Quero ocotacani pitsaroantajianacaca? ¡Tequerata pintsamajajiguenaji nagavejamajati! Icatiitsitanaca iquenquetsatacaitaro choviga icanquero: —Pimpejaencatanajempaja. Icantsitaro aisa iniromotija: —Pinchopecajatanajempaja. Ari ocotanaja osanticojencatanaji choviga, ari oquempetanaja iniromotija ochopecajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iriatimpajia yamenamenaitanaque intati icantajianaque: —¿Taashia ipaji irica? Jerompate oquemisantamajataqueriquea choviga aisa iniromotija. ");
INSERT INTO cotNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Oraquea yarejetapojacagueti Jesoshi intatiqueroqui, iguepatsitequi Gararaquitica icoraquejiapoji mavite caquinte ishaquiajiacaca ampatsini. Iriatimpajia iroguenti iquenaquenaipoji imperitamoroqui yojoquijitantapinijitarica metojatsica. Icatsimamajajiaque itsaroacaamajajitacari, caarica ipampoquivoquitantajitaro quenavoquirontsi oatsica ichoocajiaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iroompaquea icajemitsijianaca icantajigui: —Jesoshi Irijanite Irioshi, ¿queroquea pincojiguenani? ¿Iroocajate picoraquetashitaque pantsipetacaajiaquena imaica tequeratanicate arejetempaji nantsipetantajiaquempaca? ");
INSERT INTO cotNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ariqueate ichoocajiaque oraniqui oshequi chancho, ishecajiaca, icarajiavaequequea icanca. ");
INSERT INTO cotNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Irirajia ampatsini shaquiajiacarica icantajiaqueri Jesoshi: —Poguisotoajiaquenagueti, iintsija noashijianaquerita irinta chanchojia, noshaquiajiapojemparita. ");
INSERT INTO cotNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Icanque Jesoshi: —Intsiquetirote poapoaitanaque. Icampanajanta isotosotoitapanajanti yovashiantajianaqueri ishaquiajiavecaca, irioquea yoashijiavetanaca chancho. Iroompa ishaquiajiavetapojacari ariqueate icohicoitanaca ishiajianaca ojeguironcapojacagueti itanquiretanquireitanaque yojocajajiapojaca, icampojaca teron maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ariqueate yamenajiavaquerigueti quempoguijajiguirica itsaroajianaque, ishiashiaitanaca yoayoaitanaque iguintenijiacagueti icamantajiapojiri igonorojia yojocajajiacagueti chancho. Aisa itsavetantajiapojaqueriquea queroquea icohicoitanacani ishaquiajiavetapojacarigueti ampatsinipae. ");
INSERT INTO cotNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iquemitsitaquea iriatimpajia yoayoaitanaquequea ontaniqui ichoocaquegueti Jesoshi, icantajiajiri iroanaje irovashiantsitanajeri iguepatsite. ");
INSERT INTO cotNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iroompaquea itetanajaquea Jesoshi quenajarontsiqui imontejacotanaja yoanaji iguintenicagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ariquea icoraquejiapojiquea itsipapae caquintejia yamacojiapojaqueri teeca ironquempaji, yaajianaqueneriquea Jesoshi irogueshitajeri. Iriraquea Jesoshi itsajiavaqueri yaventajiapojacari irogueshitajeriniji, icantantacarica teeca ironquempaji: —Irijani, pishinevaetempaja. Jac shetacotajimpi maasanopae pipeacaaguishevecaca. ");
INSERT INTO cotNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ariquea ichoocajiaque oraniqui tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iquemajiavaquerigueti icanqueca imaica, iquenquejajianaque intati: “Manatari iquejemanatanacari Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Cotanquitsiquea Jesoshi itsajiavaqueriquea iquenquejajiaqueca icantsijigari: —¿Queroquea picopicoitanacani piquenquejajianaquequea teeca oncameetsateji? ");
INSERT INTO cotNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Querocampate caavijica anaaque mananquitsica? ¿Iroocaja nocantaquerigueti: ‘Jac shetacotajimpi maasanopae picovaeguishevetacaca, aatoquea iquenquejacaajimpiro Aapani Irioshi’, iroocaja noncanqueri: ‘Pincatianaje panijitanaje’? ");
INSERT INTO cotNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Imaicaquea namenacaajiaquempiroquea yagavejaque ocaniqui quepatsiqui irira Irijanite Caquinte irishetacoitajeri ipeacaaguishevecaca caquinte. Iroompaquea ipitsocashitanacari teeca ironquempaji icanqueri: —Pincatianaje, paanajero pinorijancaca, poanaje pitsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ariqueate icotanaja icatiapanajanta yoanajiquea itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oraquea yamenajiavaquerigueti maasano omporoguijajianquitsica itsaroajianaque, ariquea ishineventajianacari Aapani Irioshi, yamenajiaquetari mana yagavejacaajiaqueri caquintepae ironigaantajiaquero oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iroompaquea yoanaque Jesoshi icantanaca oraniqui yamenapojiri aparo capiocapinitinirica majirontatsica imentaquipae. Ipajita Mateo. Iriatimpa iroguenti isavicaque ontaniqui ipashicatsarajitirogueti yoguijajiavaqueri avisavisaitatsica ivegaratacaajiavaqueri imentaquitsite maasano aajiananquitsica irajaararopae irooca taaca opajitapae. Iroompaquea iriraquea Jesoshi icampojiri: —Jameja, poguijatanaquena. Iriatimpa icatiapanajanta yoanaque yoguijatanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ariquea Jesoshi yoanaque itsovironaquitequi ishecajiaca itsipatsipaitanacari itsatacaanejia, jerijia itsipajia capiocapinijiguinirica majirontatsica imentaquipae, jeri aisa itsipajia covaeguishejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Iriraquea pariseojia yamenajiaquerigueti Jesoshi itsipatsipaitacarigueti ishecajiacagueti, icanqueriquea itsatacaanejia: —¿Quero icocani irira tsatacaajiguimpica ishecatacojiacari capiocapinijiguinirica majirontatsica imentaquipae, jeri aisa itsipapae covaeguishejiatsica? ");
INSERT INTO cotNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Oraquea iquemavaquegueti Jesoshi icantajiguiri: —Iriraquea teeca irashinoncajempaji teetarite incoguitejacotempariji aavintantatsica. Iriguenti coguitejacojigari ashinoncajajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Poapoaitanaje pinquenquejajiaqueroja pintsajiaqueronijite icanqueca Aapani Irioshi icanquegueti: ‘Caaviji anaaque nonintamajaque pimpintsatacotantajiguempaja, anaaqueroquea pijitorejajiguenarigueti viratsipae pintaashiquenarigueti.’ Teetarite irioquea noncoraquetashiteji teeca incovaeguishejiguempaji noncajemajiaqueri, iriguenti nocoraquetashijiaque covaeguishejiatsica noncajemajiaqueriquea cameetsanijite incantashitatijaianajempanijite irovashiantanajeronijite ipeacaaguishevecaca. ");
INSERT INTO cotNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iroompaquea icoraquecoraqueipojaque itsatacaanejia Joanca Viñacajatantatsica icantajiapojaqueri Jesoshi: —¿Quero ococani naatimpajia aisa pariseojia nosanticotapinijiguiquea teequea noshecajiguempaji, cotanquitsiquea iriraquea pitsatacaanejia teetarite ariquea inquempejiguempaji imaica? ");
INSERT INTO cotNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iroompaquea iquejetacaaca Jesoshi icanque: —Pinquenquejeroja inchoocategueti iriaqueraca manquigatanquitsineca incajemajiaqueriquea itsipavijijiaca irishecatacaajiaquempari, ¿arimpate aatompate ishecajiga? Irishecashecaitanaquempaquea, itsipatsipaitacaritarite cajemajiaquerica shinejiacaquea. Cotanquitsiquea oraqueate aapojempagueti incatsimatantajitaquemparica irajaitanaqueriquea osamani, ariquea iroguenti irisanticotantajitemparoca isheca, irishimampojancacojianaquempari. ");
INSERT INTO cotNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Aatoquea ocameetsati oncotatemparogueti quitsaarentsiqui iroquetishitequitica incotatantajivetaquemparo iroaqueramorenatica quitsaarentsi. Irajaquitsijivetemparoquea ariqueate oncotanaquempani ontsiñotsiñomorenatanaquequea arimpaquea omperejanaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aisa ari onquempetaquemparoquea iroguijaatantajitaquemparogueti vinoja iroaquerajatica oncachotapoje iroguijaatantajivetaquemparogueti imeshinanaquiqui iriquetinica oroameshinatananquitsica. Oncachojamajavetanaquempagueti oshimoajavetanaquempa, ariquea oncotanaquempa aravoavetaquitempa imeshina, intyaquisanaque oshacojaatanaquempaquea vinoja, aisa impomatsataquempaquea imeshina imperejanaque. Jero caaviji ocameetsavaeque impijaatantajitaquemparoquea iriaquerameshinari cameetsanijite aatonijite opomatsajata vinoja, aisa aatonijite ipomatsatatsi imeshina.” ");
INSERT INTO cotNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Choocatiraja quenquetsatanatsitiraja Jesoshi, icoraquepojaque aparo jivatatsica, iguerovempojacari icanqueri: —Iroaquerasano metojananquitsi norijanite. Jaame pimpamitaquitenaro ontancorejanajenijite. ");
INSERT INTO cotNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iroompaquea icatiapanajanta Jesoshi yoguijatanaqueri itsovironaquitequi itsipatsipaitanacari itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ariquea ochoocaque aisa oraniqui manquigarentsi ashinoncaavaetanquitsica ososoajavaetini coramani, ariquea ocaratacovaetanaqueni 12 ajagantsiteni. Iroatimpa ojocavaetapoja quempeji ocoraquetashipojiri itaquiqui ochagatsaequitsitavaqueri ocaramagotapojaquegueti irogataamagoro. ");
INSERT INTO cotNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Oquenquejitsitanacaquea incajaranqui ocanque: “Iroguenti nonchagatsivetaquempari irogataamagoro nompeanajempaquea.” ");
INSERT INTO cotNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iroompaquea ipitsocanaca Jesoshi yameniroquea icanquero: —Orijani, pishinevaetempaja. Irooriji pavenquenatarite naatimpa, irootari piveantanajaca. Icanquitiguiro jac peamajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iroompa yarejetapojaca Jesoshi iquijapoji itsovironaquitequi jivatatsica, yamenajiapojiri covijiatsica covijiaque. Irirajia iraacojiaqueroca metojatsica iraajiaca icajemajiaque. Icantajiapojaqueri: ");
INSERT INTO cotNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Pijajiavajeta. Teetarite ometojeji, mana omaaque intati. Ariqueate icojianaca ishirontimentajianacari. ");
INSERT INTO cotNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Irooquea yoguisotojaiaquerigueti iquijitsitanaca intsompogui yaavacopojaqueroquea. Ariqueate ocotanaca otancorejanaja ocatianaja. ");
INSERT INTO cotNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iroompaquea ari maasano choocajiatsica oraniqui osamanipaequitica iquemacojiaqueri itancorejajiroquea irorijanite jivatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iroompaquea yoanajigueti Jesoshi yoguijaguijaitanajiri mavite shamponcajari icajemacovaetavaqueri icanqueri: —¡Ichoviquini Taavini, pimpintsatacogajoitenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ariqueate yarejetapojaca Jesoshi tsovironaquiqui iquijitsitanaca intsompogui. Irirajia shamponcajari guijaguijaitanaquerica iquempejiquempejiipojiri. Icantavaqueri Jesoshi: —¿Pitsaquenampa nagavejaque nantero oca? Icantajianaque: —Jeeje, Nomajirote, pagavejaque. ");
INSERT INTO cotNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ariquea ipamitsitari iroquijaqui icantajiguiri: —Pitsaquenatari nagavejaque, ari nonetsanatanaquempiro. ");
INSERT INTO cotNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ariqueate icojianaja yamenajianaji. Iroompaquea Jesoshi icantimentajiavajiri icantiriquea: —Shoshoh inchiquiojitajate pitsavetampojirotsija. ");
INSERT INTO cotNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cotanquitsiquea yoayoaitanajigueti jatanatsi itsavetantaguetanaqueriquea querocagueti ontaniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Incajaranquiguitetanaquitiguiquea icoraquecoraqueipojaque itsipapae yamajiapojaqueriquea macanari ishaquiacaca ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Irooquea yoguisotoaquerigueti Jesoshi ampatsini, ariqueate icotanaja iquenquetsatanaji macanari. Yamenamenaitanaquequea intati maasano icantajianaque: —Teetarite irinejajigueteroji quejeguetacaroca ocatica ocaniqui Ishiraeriqui. ");
INSERT INTO cotNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cotanquitsiquea irirajia pariseojia icantajiaque: —Iriguentiquea agavejacaaqueriquea imajirote ampatsinijia yagavejantacaca yoguisotoajiaqueri ampatsinipae shaquiajiavecarica caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iroompaquea yoanaque Jesoshi yoantanacaroquea oraniqui itsitacaguetanaqueroquea ocapiocaguetagueti tsovironaquipae. Itsatacaantaguetanaquequea shinagogapaequi icapiocantapinitacaca joriojia itsavetantaquero Quenquetsatsarentsi Oganejencatatsica icantajiaqueri quero icotani imajirontagueti Aapani Irioshi. Aisa yogueshijiajiri maasano ashinoncajajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Oraquea yamenajiaquerigueti maasano caquintejia ipintsatacojianacari oshequi, yamenajiaqueriquea yatsipevaejiaca taaca opajitapae, ishimampojancajiaca, mana iquempejiacari oveja teeca inchoocateji quempoguijirica. ");
INSERT INTO cotNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iroompaquea icantajiguiri itsatacaanejia: —Arimajaquea chooca icaramirincavaeque nintajianquitsica irimeshiajiaqueriquea, cotanquitsiquea teemajaca iroshequiamajateji tsatacaajiaquerineca cameetsanijite irimeshiimentajiquerinijite. Iroguenti iquempejiacaroquea osampatigueti tirigoitsoqui iniroteji teemajaca iroshequiamajateji aviguitaqueroneca. ");
INSERT INTO cotNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Irootaquequeate imaica noncantantajiaquempica pamanajiaquerija Aapani Irioshi pincantajiaqueri intigarancajiaqueri tsatacaajiaquerineca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iroompaquea icajemajiaqueriquea Jesoshi itsatacaanejia carajianquitsica 12, yagavejacaajiaqueriquea ironigaitsijiaquempariquea ishaquiajiacaca ampatsinipae, aisa irogueshijiaqueriquea aajiaquerica cantashitatiaguetanquitsica ashinoncajagantsipae aisa joquijirentsipae. ");
INSERT INTO cotNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iriatimpajia carajianquitsica 12 ipeacajaiacari itigarancanejia. Iroguenti ipajijiga: Shimo (icantajitica aisa Peerero) aisa Antirishi (iriguentijeguite Peerero); Santiago irijanite Severeo, aisa Joanca iriguentijeguite Santiago; ");
INSERT INTO cotNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jeripe aisa Varitorome; Tomashi aisa Mateo (capiocapinitinirica majirontatsica imentaquipae); Santiago (irijanite Arejeo) aisa Tareo; ");
INSERT INTO cotNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Shimo (icantajitica “Serote”) aisa Jorashi Ishicariote, aacaanquerineca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ariquea itigarancajiaqueri Jesoshi irirajia carajianquitsica 12, itsatacajaiavaqueri icanque: “Aatoja poapoaitashijiguiri teeca irijorijoigueji pintsatacaajiaqueri. Irirajia Samariaquitica aatoja piquijajiguitsi ontaniqui iguintenijiagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iriguenti poimojianaque maasano ishiraerijia, iroguentiquea iquempejiacari oveja peajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Imaica poajianaqueja pintsavetantimojianaquerija pincantajiaquerija: ‘Irooshipojaque aapojaquempaquea irimajirontaquempa acaniqui Inquitequitica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pogueshiguetaquerija avejancaguetatsica iriguentijiaca aisa itsipapae ashinoncajajiatsica. Pintancorejaguetajerija metojaguetanquitsica, aisa poguisotojaijaenerija ishaquiajiacaca ampatsinipae, cotanquitsiquea aatoja pivegaratacaajigaritsija, quejecaquea naatimpa teequea novegaratacajaiguempiji nagavejacaajiaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aatoja paajiguitsija pimentaquitsite; ");
INSERT INTO cotNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","aatoja paajiguiquea pitsaratote, iroguenti paajianaque apamorenaro piitsaare piquitsaatacaca, aisa pigaviguitire picavijiacaca; aatoja paajiguitsi pigotiro; icantajitirotari cameetsavaeque irojocajiqueneriquea catsiquetatsica irishecaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Querocagueti oraniqui parejerejeipojaquempagueti pincoaguetapojaqueri cavintsajantatsica aavaquempineca cameetsa, irioquea pimaimojiaque irosati arejetapojajempagueti poantajianajempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Poajianaquegueti itsovironaquitequi pinquijajiapojegueti pincantajiaqueriquea: ‘Noninque incavintsajajiaquempiquea Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Irishineventajiavaquempigueti, irioquea shineventajiaquemparine Aapani Irioshi incavintsajajiaqueriquea. Oraquea aatogueti ishineventajiguimpitsi, aatoquea ishineventajigaritsi Aapani Irioshi aato icavintsajajiguiri, aparoquea incavintsajajiaquempiquea aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oraqueate querocagueti poapoaitanaqueni oraniqui, aatogueti ishineventajiavajimpi, poapoaitanajeja, cotanquitsiquea iroquetitaja pantecamajatanaqueroja quepatsivane pagatiquitsitapojaquerigueti iroonijite iramenantajiaquempaca manaquea yantaque teeca oncameetsateji. ");
INSERT INTO cotNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Arimajaquea oncoramanitapojajegueti arejetapojajempagueti incatsimatantaquemparica Aapani Irioshi, caaviji incatsimamajajiaqueriquea irirajia teeca irishineventajiavajempiji, anaamajataqueroquea incatsimamajajiaquerigueti guintenijiavetanquitsica coramaniquitica Soromaqui aisa Gomoraqui. ");
INSERT INTO cotNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Imaicaquea nontigarancajiaquempiquea, onquejevetaquempa intigarancajiterigueti ovejapae inconoitempari lobopae catsimari. Iroguenti pinquempejiaquempari casantonqueni itsatigueti, cotanquitsiquea aatoja paashitantajiatsi, aisa aatoja pipigatsatantajiatsija, iroguenti pinquempejiaquemparija emoreni. ");
INSERT INTO cotNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pagamajajiaquemparija caquintejia; irajaianaquempi icapiocajiacagueti jivajiatsica incatsimatacaantajiaquempiquea, impasatacaantajiaquempi agompiaquitempi shinagogapaequi icapiocantapinijiacaca pigonorojia. ");
INSERT INTO cotNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aatoquea aparo ocatica. Irajaianaquempiquea aisa iramajirorequi, jeri aisa majirontajiatsicaqui, incatsimatacaantajiaquempiquea irooriji poguijatacotaquena naatimpa. Ariquea pintsavetantimojianaqueriquea iriatimpajia, iriguentijia aisa maasano teeca irijorijoigueji, pintsavetacojiaquenaja naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Oraquea irajaianaquempigueti majirontajiatsicaqui aatoja pishoshoguitetatsi, aatoja piquenquejajigui: ‘¿Querocaca noncanqueni?’ Inquenquejacaajiaquempirotari Aapani Irioshi cameetsanijite pintsajiaquenijite querocaca pincanque. ");
INSERT INTO cotNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aatoquea inchiquiojitaja piquenquetsajigui aviatimpajia, irioquea quenquejacaajiaquempironeca Ishire Aapani Irioshi choocashirentajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Inconoagaranquempaquea iraacaantajiaqueri iriguentijeguijiate irashimajaca igonoromajaca irimetojacaantajiaqueri, itsipaquea iraacaantajiaqueriquea irijanijiate. Ariqueate inquejejiaquempaquea itsipa iraacaantajiaqueri iriri irimetojacaantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Maasanopae irisemaneguintimentajiaquempiroquea novajiro pitsaroventajiaquenagueti, cotanquitsiquea quericaca atsipetacovaetanquitsineca aatogueti yovashiantirotsi itsarovenquenagueti arejevaequempa irimetojanaje, irioquea iriguenti irajaitanaje inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Querocagueti irantsipetacaajiaquempigueti oshequi, poapoaitanaquequea pishiashiaitanaquequea. Arimajaca noncantajiaquempi tequeratagueti pintsitacaguitejajigueroji maasanopae iguintenipaequi ishiraerijia pintsavetantimojianaqueri, incoraquetajate Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Iriraquea itsatacajaitica teetarite iranagueriji tsatacaguirica. Ariquea iquejetaca yashintajitaca teetarite iranagueriji ashincarica. ");
INSERT INTO cotNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aisa iriraquea itsatacajaitica ariquea inquejetaquemparija tsatacaguirica. Ariquea iquempetaca yashintajitaca, ariquea inquempetaquemparija ashincarica. Quempeca naatimpa Pimajirote ariqueate icantajiquenaquea Veeresevo, ogashia aviatimpajia caaviji irogaajitaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Irootaquequea noncantantajiaquempica aatoja pitsaroacaajigaritsi caquinte, irooriji maasanopae isenacajivetacaca imaica oncoramanitapojajegueti intsajitaqueroquea. Ariquea oquejetaca maasanopae itsitijiguevetacaca imaica, oncoramanitapojajegueti ironigaantajitaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Taaca opajitapae nocanquempica pitsecariqui, pintsavetanteroquea savincaguiteriqui. Taaca opajita nocantajiaquempica inchiquioji piguempitaqui, iririjencaniquea pintsavetantero sotsiqui omencotapojacagueti pitsovironaquitequi ovancaitoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aatoja pitsaroacaajigaritsi nintajianquitsineca irimetojajiaquempiquea. Iriatimpajia irimetojajiaquempigueti, iroguentiquea metojananquitsine pitsino, cotanquitsiquea aatotarite yagavejajiguirotsi irimetojajiaqueroquea pishire. Iriguentiquea pintsaroacaamajaquempaja Aapani Irioshi, apatirotarite icocani iriatimpa yagavejiquea incanque querica metojanquitsineca, iroompaquea iragavejaque intigarancaqueroquea ishire camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Arimpate teequea pamenajigueriji tsimeripae ari ivegarataca mavite tsimeri apamentaquitiro imentaqui? Cotanquitsiquea aatoquea yomposa aparo quepatsiqui aatogueti irio nintatsine Piri. ");
INSERT INTO cotNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Quejetacaquea pimaejia, ariqueate itsatiroquea apamaeropae. ");
INSERT INTO cotNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Irootaquequea noncantantajiaquempica aatoja pitsaroajiguitsijate, caavijitarite panajaiaqueriquea tsimeripae. ");
INSERT INTO cotNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Quericaca cantamajaqueroneca itsaroventamajataquena incamantajiaquerigueti caquintejia, ariqueate nonquejetaquempaquea naatimpa oncoramanitapojajegueti, noncanque: ‘Naroguenti ashincari’, inquemavaquenaquea Aapani choocatatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Cotanquitsiquea quericaca cantaquerineca caquinte: ‘Teetarite nontsaroventempariji Jesoshi’, ariqueate nonquejetaquempaquea naatimpa oncoramanitapojajegueti, noncanquequea: ‘Teequea naroguenti ashintemparine’, inquemavaquenaquea Aapani choocatatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Aato pijijiguitsi irooquea nocoraquetashique noncantajiaqueri maasano quepatsiquitica inquemavacaajiaquempa iraavacaajiaquempa. Teetarite irooquea noncoraquetashiteji, iroguentiquea nocoraquetashique ompampiatantanaquemparoquea intsinampirejavacaajianaquempa, incatsimajitanaqueriquea tsaroventaquenaneca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iriraquea irijanite incatsimatanaqueriquea iriri. Oratica orijanite oncatsimatanaqueroquea iniro. Aisa oratica imanquigatacaca irijanite oncatsimatanaqueroquea ovaguirote. ");
INSERT INTO cotNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ariqueate onquejetanaquempaquea, inchoocajiaque quemisantajiaquenaneca incatsimajiaqueriquea ijijiguica. ");
INSERT INTO cotNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aatotarite nompeguiritsi notsatacaane quericaca caavijica ipintsamajatari iriri, iriniro, aatomajaca naatimpa ipintsamajatana. Aisa aatotarite nopeguiritsi notsatacaane quericaca caavijica ipintsamajatariquea irijanite, irorijanite, aatomajaca naatimpa ipintsamajatana. ");
INSERT INTO cotNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ariquea nonquejetaquempa aisa aatotarite nopeguiritsi notsatacaane quericaca teeca irininteji iraanontanaquempa ivoatsite irompajacotantajitaquemparica irantsipeventavaetena iroguijatacotantanaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Quericaca teeca irininteji irantsipeventenaji irooca irimetojavenquena, manaquea impeaquempa; cotanquitsiquea iriraquea teeca irinintimateji irantaguetaquequea taaca opajita inintaguequeca iriatimpa iroguenti irininque irantsipevenquena irooca irimetojavenquena, irioquea iriguenti incoguitempani inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Taacagueti aajiavaquempineca shineventajiavaquempineca naroguenti ishinevenca, ariquea iquejetaca quericaca shineventaquenaneca naatimpa, iriguenti ishinevenca aisa tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Quericaca aavaquerineca tsavetacotirica Aapani Irioshi inquemisantaquerigueti yamenaquegueti iriguenti tigarancaqueriquea Aapani Irioshi, iriatimpa irishineventaquempariquea incavintsajaqueriquea inquempetacaaquempari icavintsajaquerigueti irira tsavetacotaquerica. Ariquea inquempetacaajitaquempari quericaca aavaquerineca comajamajatatsica iramenaquerigueti icomajamajataca, irishineventamajaquempariquea Aapani Irioshi incavintsajaqueriquea inquempetacaaquempariquea icavintsajaquerigueti comajamajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ariquea iquejetaca quericaca cavintsajaquerineca chaajaniquiri teeca iranaantavaeteji iramenaquerigueti yoguijatacotanaquena, iroguentigueti irojocavetaquenempari catsincajari irimiraqueca, arimaja aato opeapitsatari iramenacotajempaca.” ");
INSERT INTO cotNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iroompaquea iteroncaquerogueti Jesoshi itsatacajaiaquerigueti itsatacaanejia carajianquitsica 12, yoanaque osamanipaequi ocapiocaguetacagueti tsovironaquipae itsavetantavaeque, itsatacaantavaetaque. ");
INSERT INTO cotNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iriraquea Joanca choocatiraja isantanatacojitaqueri. Iroompaquea icamantajitaquerigueti itsavetantavaetaque Quirishito, aisa yogueshiguetaqueri icaramirincavaetaque ashinoncajajianquitsica, itigarancajiaqueriquea Joanca mavite itsatacaanejia incoacojiaquiteriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Icantajiapojiri: —¿Aviguentica noguijajiavecaca? ¿Irooca noncantacoguitempani noguijajiaguiterini itsipa incoraquetaque? ");
INSERT INTO cotNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iriraquea Jesoshi icantajiguiri: —Imaicaquea poapoaitanaje pincamantajiapojajerija Joanca maasanopae pamenaguequitica aisa piquemajiaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iriraquea shamponcajajiavetatsica yamenamenaitanaji. Iriraquea teeca iranijijiavetempaji yanijijianaji. Ariquea iquejejiaca avejancaripae ipejaianaja. Iriraquea teeca inquemajiavetempaji iquemajianaji. Aisa iriraquea metojaguetatsica itancorejajianaji. Iriraquea coguitejacojianquitsica imaica itsavetantimojiqueriquea itsatacajaiqueri Quenquetsatsarentsi Oganejencatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Caavijiquea irishinevaequempa quericaca incantacoguitempani intsaroventamajataquena, quericaca caarica ovashiantajana. ");
INSERT INTO cotNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ariquea yoayoaitanajigueti itigarancajiaqueca Joanca iquenquetsavaetanaquequea Jesoshi iquenquetsatacoqueri Joanca, icantajiguiri maasano: “¿Taacaquea poapoaitashitaquiti ontaniqui oquitamampororoitapojaquegueti? ¿Arimpate irooquea poapoaitashitaquiti pamenajiaquitiro savorovana ojeonquirogueti choviga, ariquea oaquiti oaquiti? ");
INSERT INTO cotNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ariquea taaquea poashijiaquiti? ¿Iriocaja poashijiaquiti pamenajiaquitiri caquinte quitsaataroca shipetamorenaro quitsaarentsi? Pitsajiaquequea maasano quitsaataroca shipetamorenaro quitsaarentsi manaquea isavisaviiti itsovironaquitequi majirontatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Iroosacanica ¿taaquea poapoaitashitaquiti? ¿Iriocaja poapoaitashitaquiti pamenajiaquitiri tsavetantaquerica Aapani Irioshi? Jeejeguitatsi, iriotaque, cotanquitsiquea iriatimpa caaviji yanaaguequeri itsipajia tsavetantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iriotaque itioncacojiqueca coramani iquenquetsatacaaquerigueti Aapani Irioshi Irijanite, icanqueri: ‘Ari nontigarancaqueri iriquetica oananquitsineca, intsavetacotempi. Irio camantajiaquerineca igonorojia queroca pinquenanaqueni irinetsanatashitantajiavaquempica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Arimajaca noncantajiaquempica: maasanopae caquintejia teetarite inchoocatimateji aparo anaaquerineca Joanca Viñacajatantatsica, cotanquitsiquea maasano majirontajiacarica Inquitequitica, irirajia teeca iranaajencavaevetempaji, caavijiquea icavintsajamajajiaqueri, oquejevetaca yanaajiaqueri Joanca. ");
INSERT INTO cotNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Coramaniquea iroaqueragueti iparianacarogueti Joanca Viñacajatantatsica itsavetantavaequerogueti arejevaecaroquea imaica, iriraquea catsimatantajiatsica icatsimatimentajiaqueriquea maasano tsavetacojiguirica Inquitequitica quero icotani imajirontagueti, teetarite irinintajigueji inquemisantajiteriji aatonijite quericaca peguiritsi Aapani Irioshi Imajirote. ");
INSERT INTO cotNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maasano tsavetantajiatsica itsavetacojiaqueri Aapani Irioshi coramani arejevaecaroquea ichoocaquegueti Joanca Viñacajatantatsica. Ariquea iquempetaca Moishishini iriatimpa itioncacotaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iriraquea Joanca iriotaquequea tsavetantatsica Iriashini piquemacojiaqueca incoraquetaque. Arigueti pinintajiaque pinquemisantajiavaquero nocanquempica, pinquemajiavaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Choocagueti piguempita pinquemantavaquempaca, pinquemeja. ");
INSERT INTO cotNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Quero icojigani caquintejia choocajianquitsica imaica? ¿Taa ipaji iquempejiaca? Iriguenti iquempejiaca chaajaniquitirajaca irisavisaviitaquegueti tsovijaguiteriqui irantanavijitempagueti, iroompa ari incatsimatavacaajianaquempa incanquequea: ");
INSERT INTO cotNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nocovitimojiavequempiquea teequea pintsamarojigueji. Ariquea namashaitimojiavetaquempi amashairentsi yamashaijitica ishimampojancajitagueti teequea pirajaiguempaji.’ ");
INSERT INTO cotNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ariqueate piquempejiaca aviatimpajia. Icoraquevetaca Joanca teequea irishecatempaji ishecapinitaca igonorojia, aisa teequea irimirimatemparoji cachojaro, manaquea picantacojiaqueriquea: ‘Ishaquiacari ampatsini.’ ");
INSERT INTO cotNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ariquea imaica icoraquevetaca irira Irijanite Caquinte, ishecataca iriatimpa, imiraca, ariqueate picantajiaque: ‘Iriguenti shecajanti, iriguenti shinquitatsica, aisa iriguenti itsipavijijiapojaca covaeguishejiatsica aisa capiocapinijiguinirica majirontatsica imentaquipae.’ Cotanquitsi onconijavaetanaque itsatica tsamajatatsica amenajiaquerogueti quero ococani yantaguetaqueca.” ");
INSERT INTO cotNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iroompaquea Jesoshi icantomajitsijigari ipeacaimojiavecaca oshequini oacaantantatsica intati, yamenajiaqueritarite teequea incantashitatijaiguempaji intsaroventajiguempariji Aapani Irioshi, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia guintenijiatsica Corashiniqui! ¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia guintenijiatsica Vetsairaqui! Pamenajiavecaroquea nonigaimojiavequempica oacaantantatsica intati, cotanquitsiquea teequea pinintajigueji pincantashitatijaianajempa povashiantajianajeroji picovaeguishejiacagueti. Iriraquea guintenijiavetatsica coramani Tiroqui aisa Shironequi iriome amenajiguerome, incantashitatijaianaquempamequea inquitsaajiaquemparome jiriquiquijiporoquiro, aisa irigachoncaguinajiaquemparomequea cachopoquiri ironigaantaquempanijite ishimampojancajiaca yamenajiaque icovaeguishejiaca, incantashitatijaianajempamequea. ");
INSERT INTO cotNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Cotanquitsiquea noncanquempiquea aviatimpajia arejetapojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, caaviji irogaamajajiaquempi anaamajaqueroquea incatsimajiaquerigueti Tirojiaquitica aisa Shironejiaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aviatimpajia guintenijiatsica Caperenaoqui paventacojiaca. ¿Pamenajiaca ariji poapoaitanaque jenoqui inquitequi? ¡Aatotarite! Manaquea poapoaivaetanaque isaviji Areshiqui. Arimequeate impeacaajiaquemparome oacaantantatsica intati coramani ontaniqui Soromaniqui onquempetaquemparomequea nopeacaimojiaquempica aviatimpajia imaica, aatomequeate iteroncajiguirimequeate maasano, choocatatsimequea iguinteni iriguintenijitemparomequea imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Irootaquequea noncantantajiaquempica oncoramanitapojajegueti aapojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, caaviji incatsimamajajiaquempiquea aviatimpajia, anaavaequeroquea incatsimajiaquerigueti Soromajiaquitica.” ");
INSERT INTO cotNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iroompaquea icanque Jesoshi: “Aapani Majirontamajatatsica, aviguenti majirontacojiacarica maasano inquitequitica aisa quepatsiquitica. Noshinevenquempiquea nocanca, pitsititapitsajiaqueritari tsajiatsica teequea ponigaajigueriji querocaca picotani aviatimpa. Iriguentiquea ponigaajiaque teeca intsajigueji. ");
INSERT INTO cotNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oquempetantacaca imaica, irootari pininque aviatimpa.” ");
INSERT INTO cotNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iroompaquea icantajiguiri maasano: “Yojocaguetaquenaroquea Aapani maasanopae, aisa yagavejacaamajaquena maasanopae. Teequea quericaca tsamajatatsineca querocaca icotani Irijanite Aapani Irioshi, apatiroti tsatanquitsi Aapani. Aisa teequea quericaca tsamajatatsineca querocaca icotani Aapani, apatiroti tsatanquitsi Irijanite aisa irirajia inintacajaiaqueca Irijanite intsatacaajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Caacate naatimpaqui maasano aviatimpajia magoshirentajiatsica atsipejianquitsica cameetsanijite nomagorejacaajiaquempinijite. ");
INSERT INTO cotNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pinatavaquero novoatsite, pintsatavaquero nontsatacaaquempica, naroguentitari atsipetacotatsica teetarite naventacotimatempaji. Ariquea pamenapojero pimagorejashirentajiaque. ");
INSERT INTO cotNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Teequea omanempaji novoatsite nojocaquempica, pijoncavaetaque nonatacaaquempica.” ");
INSERT INTO cotNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ariquea arejetapojacagueti savincaguiteri imagorejantajitaca yoanaquequea Jesoshi icantanaca tirigomashiqui, itsipatsipaitanacari itsatacaanejia. Iriatimpajia itaseajianaque ishireguipanajanti tirigoitsoqui ishecajiacaroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ariquea yamenajiaquerigueti pariseojia icantsijigariquea Jesoshi: —¡Pamenajiguerija! Yaajianaquequea pitsatacaanejia tirigoitsoqui imaica savincaguiteri imagorejantajitaca, icantimentantajitirotarite irantantajitemparo. Cotanquitsiquea iriatimpa icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","—¿Arimpate teequea pampatsajavantacojigueroji aviatimpajia itioncacojitaquerigueti Taavini coramani ocanquegueti itaseanaque iriatimpa aisa itsipajianacaca, teequeate onchoocatimajaniquiteji taampaquea irishecajiaquempaca? ");
INSERT INTO cotNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iquijitsitanacaquea itsovironaquitequi Aapani Irioshi ishecatsitaroquea pan icantimentantajitica irishecajitemparogueti, manaquea yojoquijitaquero oraniqui shitaponcarontsiqui cameetsanijite iramenaqueronijite Aapani Irioshi. Iriguenti shecataroquea saserorotejia, irioqueate cantanquitsica Aapani Irioshi. Cotanquitsiquea iriraquea Taavini ishecatacaroquea, aisa yojocajiaqueneriquea itsipatsipaitacaca. ");
INSERT INTO cotNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Arimpate teequeate pampatsajavanteroji aisa itioncacotanaqueca Moishishini ocanquegueti iriraquea saserorotejia antajiguinirica teemporoqui itsaroventantajitarica Aapani Irioshi yantantajigaroquea savincaguiteri imagorejantajitaca, cotanquitsiquea teequea irooquea impeacajaiguempaji covaeguisherentsi? ");
INSERT INTO cotNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Imaicaquea noncamantajiaquempiquea chooca acaniqui caavijica anaaqueroquea teemporo itsaroventantajitarica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aviatimpajia teetarite pinquemajiguerojiquea itioncacojitaquerogueti cantatsica: ‘Caaviji anaaque nonintaquequea pimpintsatacotantajiaquempa, anaaqueroquea pijitorejajiaquenarigueti viratsipae pintajaiaquenarigueti.’ Pinquemajiavaqueromegueti ocatica, aatomequea pijijiguime ipeacaaguishejiaquero covaeguisherentsi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iriraquea Irijanite Caquinte iriguentiquea cantatsica queroca icantimentantajitica irantantajitemparogueti savincaguiteriqui imagorejantajitaca, aisa querocaquea teeca incantimentantajiteroji. ");
INSERT INTO cotNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Incajaranquivaetanaquegueti yoanaque Jesoshi shinagogaqui icapiocantapinijiacaca joriojia iquijanaquequea intsompoguiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ariquea ichoocaque oraniqui aparo chompevacovetatsica. Irirajia catsimajiaquerica Jesoshi yamenajiaquequea querocaca incanque cameetsanijite intsaveacojiaquerinijite incatsimatacaantajiaqueri, icoacotantajiacarica icanqueriquea: —¿Cameetsavaequempa irogueshitantajitaquempariquea caquinte savincaguiteri imagorejantajitaca? ");
INSERT INTO cotNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Icanqueriquea: —Choocagueti ashintanquitsica irovejate arigueti intanquirejantanaquemparo aparo omoroqui savincaguiteri imagorejantajitaca, ¿arimpate aato yoashitiri irajaateri? ");
INSERT INTO cotNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iriompaqueate caquinte caaviji ipintsatacojitari, caavijitarite yanaaqueri oveja. Irootaquequea imaica cameetsavaeque incavintsajantantajiquemparoja savincaguiteri imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jero ipitsocashitanacariquea chompevacovetatsica icanqueri: —Pincantavacotempaja. Iroompate icantavacovetanaquitiga ariquea icotanaja iraco jac peamajatanaja quempemajatanaja otsipapaco. ");
INSERT INTO cotNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ariquea yamenajiavaquerigueti pariseojia yogueshitajirigueti, isotosotoitapanajanti ariquea isariimanatanacari Jesoshi irimetojacaantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Irooquea itsatavaquegueti Jesoshi isariimanajianacari irimetojacaantajiaqueri, yoanaquequea, ariquea yoguijaguijaitanaqueri icaramirincavaeque caquintejia. Iriatimpa yogueshiguetajiri maasano ashinoncajajiatsica, ");
INSERT INTO cotNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","cotanquitsiquea icantimentajiaqueriquea aatonijite itsavetacojiguiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Oraquea iquejetacagueti imaica onetsanatacaquea icanqueca Isaiashini coramani itioncacoquerogueti icanqueca Aapani Irioshi, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jeeri irira notigaranquica nonintacaaqueca. Nopintsamajacari, aisa noshinevencari. Nontigaranquimoqueriquea Noshire inchoocashirentapojeri. Iriatimpa incamantajiaqueriquea maasano caquinteguetatsica querocaca cameetsaripae, aisa querocaca teeca oncameetsateji. ");
INSERT INTO cotNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aatotarite icatsimatanti, aisa aatotarite itampishijencatanti, aato iquemajitiri quenavoquirontsipaequi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aato ijararejiro ovi chacopi otaporejavetanacagueti, aato itsivaquiro otsa tsivorentsi chaavogajaniquitanquitsica, arejevaetemparoquea irinetsanamajatantanaquemparoca maasano, irooquea anaantananquitsine tampaticatanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iriotaque iroguijajiavaqueca caquinteguetatsica, iraventajiaquemparo ivajiro.” ");
INSERT INTO cotNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iroompaquea yaajitanaqueneriquea Jesoshi aparo caquinte ishaquiacaca ampatsini, ishamponcajataque aisa imacanataque, teequea inquenquetsateji. Iriatimpa ariquea yamenacajairi, aisa inijacajairi macanari. ");
INSERT INTO cotNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yamenamenaitanaquequea intati maasano, icantajigui: “Iriocajate Ichoviquini Taavini.” ");
INSERT INTO cotNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Irooquea iquemajiaquerigueti pariseojia icantajiaqueca, iriatimpajia icanquequea: “Iriguentisa shaquiacari Veeresevo imajirote ampatsinijia. Iriotaquequea agavejacaaquerica yoguisotoantaguetacanarica ishaquiajiacaca ampatsinipae.” ");
INSERT INTO cotNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cotanquitsiquea itsatavaqueroquea Jesoshi iquenquejajiaqueca, icanqueriquea: “Inchoocategueti caquinte incapiocajiaqueriquea igonorojia impeaquempaquea imajirote, iroompaquea arigueti impariajianaquemparo incatsimatavacaajiaquempa, ariquea intsinampirejavacaajianaquempaquea irishiapitsajianaqueri imajirote, aparo inchoocataje, aato ichoocataji quericampa iromperatajempaca. Ariquea iquempejiaca tsipatsipaitacarica ijijiguica, arigueti incatsimatavacaajiaquempaquea, ariquea incohincoitanaquempa intsinampirejavacaajianaquempaquea, aatotarite iconoavacajaijaa. ");
INSERT INTO cotNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ariquea iquejetaca Satanashi, ¿arimpate intigarancajempa iriatimpa iroguisotoaquempa? Inquempetaquempagueti imaica irisatica guisotoajatsine, ¿arimpate iragavejaque incoguitempani impeaquempaquea imajirote maasano ampatsinijia? ");
INSERT INTO cotNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aviatimpajia iroguenti picantajiaquena: ‘Iriguentisa shaquiacari Veeresevo’, nagavejantacarica noguisotoantsijiajarica ishaquiajiavecaca ampatsinipae. Iriomegueti agavejacaaquename Veeresevo, ¿ariquea quericampate agavejacaajiaqueriquea pigonorojia yoguisotoantsijiajarica ishaquiajiacaca ampatsini? Irootaquequea itsatantajitacaroca manatarite picomica aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cotanquitsiquea iriguenti agavejacaaquenaqueate Ishire Aapani Irioshi noguisotoantsijiajarica ishaquiajiacaca ampatsinipae, irooquea pintsatantajiavaquempaca jac imajirontapojaca Irioshimajaca acaniqui aviatimpajiaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Imaica noninque noncoacojiguempija: ¿Queroquea incojitaquerini incatsimajitaquerigueti caavijica itampishiti iraitsijiguetanaqueriquea aatogueti iroquetita iroishojitaqueri? Oraqueate iroquetigueti iroishotsijitaquemparigueti, ariquea iroguenti iraitsijiqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Iriraquea teeca irishineventavaquenaji, manaquea icatsimataquena; aisa iriraquea teeca intsipatenaji nocapiocantaquegueti, iroguenti yoguivorocantaque. ");
INSERT INTO cotNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ariquea noncantajiguempi imaica, taaca impeacaajiaquempaca caquinte covaeguisherentsi irooca incantaguishevaeque taaca opajitapae, iriraquea Aapani Irioshi iragavejaquequea irishetacotajeri aatoquea iquenquejacaajiri, cotanquitsiquea iriraquea cantaguishetacoquerineca Ishire Aapani Irioshi aatoquea ishetacojitiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ariquea oquempeca quericaca cantaguishetacoquerineca Irijanite Caquinte iragavejaquequea Aapani Irioshi irishetacotajeri, cotanquitsiquea iriraquea cantaguishetacoquerineca Ishire Aapani Irioshi, irioquea iriguenti aatoquea ishetacojitiri, aato imaica ocaniqui quepatsiqui aisa aatoquea oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pamenaquerogueti inchato cameetsatatsica, pintsaque cameetsataquequea osovenapae. Aisa pamenaquerogueti inchato teeca oncameetsateji, pintsaque tee oncameetsateji osovena. Iroguentitarite itsatantajitaroca inchato, yamenajitiro osovena. ");
INSERT INTO cotNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Quejejiaquempiquea irijanijiate sanatari, ¿queroquea pincojiaquempani pincantajigueronijite cameetsaripae?, aviguentijiatarite covaeguishejiatsica. Maasanotari iquenquejacojiguetica irootaquequea iquenquetsatacojiguetica. ");
INSERT INTO cotNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ariquea iquempetaca caquinte comajamajatatsica iroguenti iquenquetsatacoguetaque cameetsaripae, irootari iquenquejacoguetaque. Iriraquea teeca incomajamajatempaji iroguenti iquenquetsaguishetaque taaca opajitapae, irootarite iquenquejacoguetaque iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Noncantajiaquempiquea, oraquea aapojajempagueti incatsimatantajitaquemparica covaeguishejiatsica, inquenquejacaajitaqueri maasanopae iquenquetsaguishejiaqueca intati. ");
INSERT INTO cotNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aritarite cameetsarica picantaguetica, irishinevenquempiquea. Cotanquitsiquea teegueti oncameetsateji picantaguetica, incantajitaquempi: ‘Imaica pantsipeventaquemparo.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ariquea icoraquetashijiapojaqueri Jesoshi pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, icanqueriquea: —Tsatacaantantatsica, nonintajiaque ponigaajiguenaro oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Icanqueriquea Jesoshi: —Aviatimpajia otiavaejiaquempiquea covaeguisherentsi, teequea quisho poajigueriji Irioshimajaca, pinintantajiavetacaca nonigaajiaquempirome oacaantantatsica intati, cotanquitsiquea aatoquea nonigaajiguimpirotsi. Iroguentiquea nonigaajiaquempi otsipa, onquempetaquemparoquea iquejetacaajitacarigueti tsavetantatsicani Jonashini coramani. ");
INSERT INTO cotNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Piquemacojiaqueriquea Jonashini iniaquerigueti quejevetarica iririjegui quiterinqueni ariquea icaratacovaetanaquequea 3 savincaguiteri ontaniqui imotijaqui. Ariquea inquejetaquempaquea oncoramanitapojajegueti irira Irijanite Caquinte incaratacovaetanaque 3 savincaguiteri intsompogui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Oncoramanitapojajegueti aapojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, iriraquea Ninivejiaquitica incatintiitsitanaquempaquea intsavetacotsijiaquempiroquea pantaguishejiaqueca. Maasanotari Ninivejiaquitica iquemisantajiaqueriquea Jonashini itsavetantimojiaquerigueti, ishimampojancajianaca yamenajiacagueti ipeacaaguishejiacagueti covaeguisherentsi, ariquea icantashitatijaianaca. Cotanquitsiquea imaica icoraquevetapojaca caavijica anaavaequerica Jonashini, teequea pinquemisantajiavaqueriji. ");
INSERT INTO cotNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ariqueate onquejetaquempaquea aisa oncoramanitapojajegueti oraquea imajirojiate Savajiaquitica oncatiitsitanaquempaquea ontsavetacotsijiaquempiro pantaguishequeca aviatimpajia choocajianquitsica imaica. Coramanitari ocoraquetashivaequeri Saromonini oquemisanqueriquea itsatacaaquerogueti, oquenavaetapojaque jmm osamani oquemacoquerigueti itsamajati. Cotanquitsiquea imaica icoraquevetapojaca caavijica anaavaequerica Saromonini, teequea pinquemisantajiavaqueriji. ");
INSERT INTO cotNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Oraquea irovashiantanajerigueti ampatsini iriraquea ishaquiavetacaca, iroanaque ontaniqui oquitamampororoitapojigueti irinintavequempa irimagorejavaequeme. Cotanquitsiquea iroompa iramenavetapojaquemparo querocampa inchoocateni oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Inquenquejitsitanaquemparoquea incanque: ‘Noantanajemparota notsovironaquite nosotoantavetanacaca.’ Ari incoraquevetajempa iramenapojajeri ishaquiavetacaca quempeca tsovironaqui ipishijitirogueti inetsanajitirogueti, cajaraguitejisano oncanquempa tecatsi choocatantemparone. ");
INSERT INTO cotNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ariquea iroanaque iraaquiteri itsipajia 7 ampatsini caavijica igajaiaca. Iroompaquea irishaquiajiapojempari irira ishaquiavetacaca iroaqueragueti, ariquea iriatimpa ari incotanajempa arimpa irogaamajatanajempa. Ari onquejetimojiaquempariquea covaeguishejiatsica choocajianquitsica imaica.” ");
INSERT INTO cotNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Choocatiraja iquenquetsatacaajiaquerigueti Jesoshi omporoguijajianquitsica, ocoraquepoji iriniro aisa iriguentijeguijiate icatintiitapojaca sotsiqui, inintajiavetaca inquenquetsatacaajiaquerime. ");
INSERT INTO cotNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iroompaquea icamantajiqueriquea Jesoshi icantajitiri: —Coraquetaque piniro aisa piguentijeguijiate, ichoocapoji sotsiqui, inintajiaque inquenquetsatacaajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Cotanquitsiquea iriatimpa icanqueri camanquerica: —¿Taa opaji iinani? ¿Taa ipaji iguentijeguijia? ");
INSERT INTO cotNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iroompaquea ipitsocashijianacari itsatacaanejia, ijicojiaqueriquea icanque: —Jeeri iricajia nopeajiaqueca iinani aisa iguentijeguipae. ");
INSERT INTO cotNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Quericaca netsanamajatiroca inintaguetica Aapani choocatatsica inquitequi, iriotaque nopejaiaque iguentijeguipae, tsiojipae, iinanipae. ");
INSERT INTO cotNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iroompaquea oraticaquea savincaguiteri isotoanaji Jesoshi tsovironaquiqui, yoanaque otsapijaqui iniromotija, isavicapoji. ");
INSERT INTO cotNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yomporoguijaventajiapojacariquea icaramirincavaetanaque caquintejia, ariquea itetanajaquea quenajarontsiqui isavicaque. Maasano omporoguijajianquitsica isavisaviiquequea ocaratsapijaquiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iroompaquea itsatacaajiaqueri iquempetacaaguetacaroquea taaca opajitapae, icanqueriquea: “Yoanaque aparo caquinte impishoncaguitero oitsoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ipishoncavoncaquitanaqueroquea tacororo tacororo, itsitacaguetanaquero. Oconoagarancaqueate asacaraaguetanaca quenavoquirontsiqui, iroompaquea isavisaviitashipojiroquea tsimeripae ishecajiapojacaro. ");
INSERT INTO cotNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Otsipa oconoagaranca asacaraanaca mapiporoquiqui, taampina otsoroavetanaca, teemajaca onchoocamajatenica quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iroompaquea icatsirincaguitevetanaca catsirincaiteri, itsianaqueroquea oshimpeguiricanaque ometojanaque, teetarite oamajateji ovarishitsa isaviqui, ojocaavaquerotarite mapi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oconoacaquea otsipapae asacaraanaca ochoocaquegueti ovarishitsa samerento. Iroompaquea otsoroitsivetanaca, arimpaquea otsoroitsitanacaquea samerento iroatimpa otsincoanaqueroquea ometojanaquero. ");
INSERT INTO cotNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Otsipa oconoacaquea asacaraaguetanaca ocameetsaguitetaquegueti quepatsiqui, otsoroanaquequea otaganaanaca ochoocatanaque opitsaraquiacotanacaqueate oitsoqui, oconoacaquea ochoocaque 100, otsipa 60, otsipa ochoocaque 30. ");
INSERT INTO cotNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Choocagueti piguempita pinquemantavaquempaca, pinquemeja.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iroompaquea iquempejiquempejiipojacari itsatacaanejia icantiriquea: “¿Queroquea ococani pitsatacajaiaquerigueti caquintejia piquejetacaacanari intati?” ");
INSERT INTO cotNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iriatimpa icanqueriquea: “Imaica ininque Inquitequitica pintsajiaqueroquea aviatimpajia queroquea icotani imajirontagueti iriatimpa, cotanquitsiquea iriatimpajiaquea aatoquea itsajiguirotsi. Teetarite intsajiteroji paesatoniqui, aviguentiquea tsajiaquerone imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Quericaca choocatanquitsica itsataqueca, inquimoguenquejanetacaamajaqueri, oavaetanaque intsamajatanaque. Cotanquitsiquea quericaca teeca onchoocateji itsataqueca, capichaguenquejanejaniquitanquitsica choocavecarica iraapitsatsijiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irootaquequea noquejetantajiacarica imaica notsatacajaiaquerigueti iriatimpajia manaquea noquejetacaacaroquea maasanopae. Iriatimpajiaquea yamenamenaivetanacatari, cotanquitsiquea tee irinejeji; iquemajiavetacaquea, cotanquitsiquea tee inquemajiavaqueroji, tee intsajiavaqueroji. ");
INSERT INTO cotNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iquejejiacagueti imaica, onetsanatanacaquea icantaqueca Isaiashini coramani, icanque: ‘Pinquemajiavequempaquea, cotanquitsiquea aato piquemajiavajirotsi. Pamenajiavequempaquea, cotanquitsiquea aato pitsatimajiavajirotsi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iquishoshirentanaquetarite iricajia. Oraquea iguempita tee inquemamajatantajemparo, aisa imatsivocajataque, aatonijite inejantajiajarotsi iroquija, aatoniji iquemantajiajarotsi iguempita, aatoniji itsajigui ishirequi aatoniji ipitsocashijigana nogueshishirentantajiajemparica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Cotanquitsiquea aviatimpajia caaviji icavintsajamajajiaquempi Aapani Irioshi pamenantajiacaroca maasanopae pamenajiaqueca imaica, aisa piquemajiaquena notsatacajaiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Arimajaca noncantajiaquempica, ichoocajiavetaca oshequini tsavetantajiatsica aisa comajamajajianquitsica inintajiavetaca iramenajiaqueromequea pamenajiaqueca aviatimpajia imaica, cotanquitsiquea teequea iramenajigueroji. Aisa inintajiavetaca inquemajiaqueromequea piquemajiaqueca aviatimpajia, cotanquitsiquea teequea inquemajigueroji. ");
INSERT INTO cotNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Imaica iintsija pinquemisantajiavaquenaja noncamantaquempigueti taaca opajita noquempetacaaca incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oraquea oitsoqui asacaraaguitananquitsica quenavoquirontsiqui iriguenti noquejetacaajiacaquea caquinte quemisantajiavetacaroca Iguenquetsatsare Aapani Irioshi itsavetacojitirogueti, cotanquitsi tee intsajiavaqueroji. Itsatacajaivecariquea queroquea incojiaquempani impejaiaquerigueti Aapani Irioshi Imajirote, cotanquitsiquea iroompaqueate icoraquetashiqueriquea ampatsini ipeacotacaacariquea maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Oraquea asacaraaguiguetananquitsica mapiporoquiqui iriguenti ogomarojiaquequea quemisantajiavetavacaroca Iguenquetsatsare Aapani Irioshi ishineventajiavetavacaroquea, ");
INSERT INTO cotNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","cotanquitsiquea teemajaca inquemisantamajateroji, jero ipeacotantajianajaroca taampina. Iroompaquea ocoraquetashiqueriquea atsipetagantsi, irooca icatsimatimentajiqueriquea Iguenquetsatsare Aapani Irioshi, ariqueate icohicoitanaca yovashiantajianajiroquea, iquejejianaja iroaqueragueti tequeratagueti intsaroventimatempariji. ");
INSERT INTO cotNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oraquea asacaraaguiguetananquitsica samerentoqui iriguenti noquempetacaajiaca quemajiavetacaroca Iguenquetsatsare Aapani Irioshi iquemajiavetavacaroqueate, cotanquitsiquea iroompa irooqueate aisa iquenquejajiavajiroquea maasanopae choocaguetatsica quepatsiquitica. Ariquea iriatimpajiaquea teequea inquenquejajiajeroji Iguenquetsatsare Aapani Irioshi, iroguentiquea iquenquejajianaji incarajiavaequeroquea yashintaguecaca. Querocampate incojiaquempani intsaroventamajajiaquemparigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Cotanquitsiquea oraquea asacaraaguiguetananquitsica ocameetsaguitetaquegueti quepatsi iriguenti ogomarojiaque quemisantajiavaqueroca Iguenquetsatsare Aapani Irioshi, ariquea itsaroventamajatacariquea iriatimpa. Ariquea ichoocajiaque cameetsa, iquempejiacaroquea oitsoqui choocatananquitsica oitsoqui 100, itsipa iquempejiacaroquea oitsoqui choocatananquitsica 60, itsipa iquempejiacaroquea choocatananquitsica 30.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ariquea iquejetacaajiacanari Jesoshi otsipa, icanqueri: “Imaica irooquea nonquempetacaaquemparo quero icotani imajirontagueti Inquitequitica. Yoanaque caquinte ipishoncavoncaquitanaqueroquea tirigo cameetsaitsoquiri iniganquitejirequi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iroompa imaajianajigueti maasano, yananincaquitiquea itsipa catsimataquerica ipishoncavoncaquitapanajantiro tojari quempevetaroca tirigo itsitacavaetanaqueroquea oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Iroompaquea otsoroavetanaca tirigo, arimpaqueate otsoroitsitanaca tojari iroatimpa omoncarajanacaroquea. Oraquea ochoocatanaquegueti oitsoqui tirigo, yamenajiqueroquea manasacanica oconoacaroquea tojari. ");
INSERT INTO cotNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Irirajia amijiguirica yamenitsijigaroquea icoraquejiapojaque icantajiapojiri ashintaroca: ‘Nomajirote, arimpate namenajiaque iroguenti pipishoncavoncaquitaque tirigomajaca. ¿Imaicaquea querocaquea oquenapojini tojari?’ ");
INSERT INTO cotNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Icantiriquea iriatimpa: ‘Ooshiatsi, iriocajate quempequeroquea catsimataquenaca.’ Icantajianaque amijiguirica: ‘¿Ari pininque noanoaitanaque nontsopajajiajatero?’ ");
INSERT INTO cotNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Icanquequea iriatimpa: ‘Aatota, pitsipatacaantajigarotsishiatsi tirigomajaca. ");
INSERT INTO cotNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ariquea ococaniquea osampatanaquegueti, ariquea nontigaranquitsijiguempariquea aviguijiaqueroneca ariquea intsopajitsitemparoquea tojari iroishovativaequeroquea intaitsijiguemparoquea. Iroompa irooquea irajaiaquequea tirigomajaca intariajiaqueroquea tsovironaquiqui itariantajitaroca tirigoitsoqui.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iroompaquea iquejetacaajiacanari otsipa, icanque: “Imaica nontsavetacotaqueroquea queroquea icotani imajirontagueti Inquitequitica, ariquea nonquempetacaaquempiro oitsoqui moshitaasa ivintyacajitirogueti iniganquitejirequi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iroatimpa caaviji anaaque ochaamirijaquijaniquivaeque, cotanquitsiquea ontsoroanaquegueti inirojempetanaquequea anaaguequeroquea otsipapae panquirentsipae chaamirijaquitatsica oitsoqui. Ontsegotsegoatanaquempaquea onquempetanajemparoquea inchato, inchoocatantajianaquemparoquea tsimeripae.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iroompaquea iquejetacaajiacanari otsipa, icanquequea: “Imaicaquea nontsavetacotanaqueroquea queroquea icoqueroni Inquitequitica imajirontagueti, ariqueate nonquempetacaaquemparo anempoacaguiroca pan. Pamenirotarite manquigarentsi ompeacaguemparogueti pan, aaquequea apamontiinaro tirigovane, ariquea onconoanquemparo anempoacaguiroca, ariquea oncotanaquempa anempoacaanaquero maasanose.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ariquea iquejejiaqueri Jesoshi imaica maasano itsatacaajiaquerica caquintejia, mana iquempetacaajiacanari. Teetarite intsatacaajigueriji intati, taaca opajitapae ininqueca intsatacaajiaqueriquea, iroguenti iquejetacaaguetacaroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Oraquea iquempetaquerogueti imaica iroguenti onetsanatanaca itioncacotanaqueca tsavetantatsicani coramani, icanquequea: “Nonquenquetsatacaajiaquerigueti, iroguenti nonquejetacaaguetaquemparoquea taaca opajita. Nontsavetantaguequero taaca opajita iroquetinica itsitijiguevecaca paesatoniqui iroaqueraguetiquea ipeacajaicarogueti quepatsi arejevaetapojaroquea imaica.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ariquea iquenquetsatacaajiavajiri Jesoshi capiocaventajiacarica, yoanaji tsovironaquiqui iquijapojaque. Iriraquea itsatacaanejia iquempejiquempejiipojiri icanqueriquea: —Nonintajiaque poguisotoguenaroja incajaranquitica piquempetacaajiacanarogueti tojari conoacaroca tirigo. ");
INSERT INTO cotNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Icanque Jesoshi: —Iriraquea pishoncavoncaquitaqueroca tirigo cameetsaitsoquiri iriguenti Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Oraquea niganquiteji, iroguenti maasanopae quepatsi iguintenitantajiacaca caquinteguetananquitsica. Oraquea cameetsaitsoquitatsica, iroguenti quejecari caquintejia peajiaquerica Aapani Irioshi Imajirote. Oraquea tojari, iroguenti quejecari caquintejia irashijia ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iriraquea catsimatantatsica pishoncavoncaquiqueroca tojari, iriguenti imajirote ampatsinijia. Oraquea nocanquegueti irajaiquerogueti tirigoitsoqui, iroguenti notsavetacotantaque onteroncanajempagueti quepatsi. Irirajia aajiaqueroneca iriguentijia irashivantijitete Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Imaicaquea pamenajiaquerogueti itsopajajiquerogueti tojari itajaiquerogueti, ariquea onquempetaquempa oncoramanitapojajegueti onteroncanaquempagueti quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iriraquea Irijanite Caquinte intigarancajiaqueri irashivantijitete, incapiocajiaqueriquea covaeguishetacaajiacarica itsipajia, irirajia aisa maasano peacaaguishejiacaroca covaeguisherentsi, aatoniji iconoajiajari majirontajiacarica, ");
INSERT INTO cotNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","impishoncajiaqueriquea camorecariqui. Oraniquiquea oraniqui incoquempaniquea iriraaguitempani irantsicayajijiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ariquea irirajia comajamajatanquitsica iroaroaitanaque ichoocatigueti Aapani Irioshi imajirontagueti, inquempejianaquempariquea catsirincaiteri itsirencashimpoquirerejigueti. Choocagueti piguempita pinquemantavaquempaca, pinquemeja. ");
INSERT INTO cotNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Imaica nontsavetanqueroquea queroquea icotani imajirontagueti Inquitequitica, ariqueate nonquempetacaaquempariquea ooro itsitijitirigueti iquitajitirigueti quepatsiqui. Ariquea yamenapojaquerigueti itsipa caquinte, iquitatsitanajariquea. Ishinevaetanaca yojocantaguetaqueroquea maasanopae yashintaguecaca yaancaroquea imentaquipae. Iroompaquea yoanaque ivegarataqueroquea quepatsi ichoocatantacaca ooro. ");
INSERT INTO cotNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Oraquea imajirontagueti Inquitequitica iroguenti oquempetacari jocantaguetiroca taaca opajita. Iriatimpa yoanaque yamenaguetaquequea peerera vegaramajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ariqueate yamenapojaqueroquea apaitsoquitiro caavijica anaaguequeroquea oquitasaancorerencavaeque, ovegaramajavaeca oshequi. Yojocantaguetaqueroquea maasanopae yashintaguecaca yaantaguecaroquea imentaquipae ivegaratantaguetacaroca oratica peerera. ");
INSERT INTO cotNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Imaicaquea nontsavetacotantaqueroquea queroquea icotani imajirontagueti Inquitequitica, iroguenti nonquempetacaaquemparoquea yanquitacotantajitarigueti shimaguetatsica iniromotijaqui, inoshicacotaqueriquea icantashitatiaguecaquea oshequini. ");
INSERT INTO cotNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Itseraiquitatigaroquea yaitsitajaroquea yaajitanaqueroquea imparaguequi. Ariquea isavisaviitanaque ashincaroca imantsatsite icoguiaguetaqueriquea cameetsaguetatsica itejiavaqueriquea cantiripaequi. Iriraquea teeca incameetsateji manaquea ipishoncaguetavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ariquea onquempetanaquempaquea oncoramanitapojajegueti onteroncaguetanaquempagueti quepatsi, incoraquecoraqueipoje irashivantijitete Aapani Irioshi incapiocajiaqueriquea comajamajajianquitsica iroashijiaquempariquea maasano covaeguishejiatsica, ");
INSERT INTO cotNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","impishoncajiaqueriquea camorecariqui. Ontaniquiquea ontaniqui incoquempaniquea iriraaguitempani irantsicayajijiaquempa.” ");
INSERT INTO cotNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Icanque Jesoshi: —¿Ari piquemajiaquero maasano nocantajiaquempica? Iriatimpajia icanqueriquea: —Jeeje, Nomajirote. ");
INSERT INTO cotNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Icantiriquea: —Maasano tsatacaantajiguiroca itioncacotanaqueca Moishishini itsatacaamajajitaquerigueti queroquea icotani imajirontagueti Inquitequitica, inquempejiaquempariquea ashintaroca tsovironaqui icapiocantaguetaquerogueti yashintaguetacaca. Iragavejaque iraaguetaquero cameetsaguetatsica choocatatsica intsompogui, iroquetinicapae aisa iroaqueraguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ariquea iteroncanaquerogueti Jesoshi iquempetacaaguetacarogueti, yoanajiquea. ");
INSERT INTO cotNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yarejetapojacagueti iguinteniqui itsatacaantapojaji ontaniqui shinagogaqui icapiocantapinijiacaca joriojia. Yamenamenaitanaquequea intati maasano quemisantajiavaquerica, icantajiaque: —¿Queroquea oquenapojini maasanopae ocatica itsatica iricatica? ¿Taaquea agavejacaaqueri yagavejantacaca yonigaantaguequeroquea oacaantantatsica intati? ");
INSERT INTO cotNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Teecajate irioquea irijanite caripintero choocatatsica aguintenijiagueti? Oraquea iriniro iroguenti Maria. Iriraquea iriguentijeguijiate iriguenti Santiago, Jose, Shimo aisa Jorashi. ");
INSERT INTO cotNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ariquea oquempejiaca itsijoitepae iroatimpajia iroguenti oguintenijiaca ocaniqui. ¿Queroquea oquenapojini itsatica aisa iragavejane? ");
INSERT INTO cotNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ariquea teequea irinintajigueji inquemisantajigueriji, iroguenti icatsimajiaqueri, cotanquitsiquea Jesoshi icanqueriquea: —Iriraquea tsavetantiroca icanquerica Aapani Irioshi ishineventajitavajari querocagueti yoanaqueni osamani, cotanquitsiquea ichoocavecagueti iguinteniqui aisa itsovironaquitequi, teequea irishineventajitempariji, teequea inquemisantajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ariquea teemajaca ironigaantaguetajeroji oraniqui oacaantantatsica intati, teetarite inquemisantajigueriji, manaquea iquenquejajiaque: “Caaricaja.” ");
INSERT INTO cotNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iroompaquea iriraquea Erorishi imajirojiate Garireaquitica iquemacoqueriquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ariquea icantajiaqueri amijiguirica: —Iriguentiquea Joancani Viñacajatantatsica nometojacaantaqueca. Tancorejanajishiatsi, jero iquejetampojajaroca imaica yagavejamajatantacaca yonigaantaguequeroquea oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Oraquea chapinqui iriraquea Erorishi yaacaantaqueri Joanca yoishotacaanqueriquea cavorejatsariqui, isantanatacotacaantaqueri, irooriji yamenaquequea icantomajimentavecari Eroriashi yaapitsaquerigueti iriguentijeguite pajitatsica Jeripe. ");
INSERT INTO cotNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Iriraquea Joanca icanqueriquea Erorishi: “Teetarite oncameetsateji paapitsaquerigueti imanquigare piguentijeguite.” ");
INSERT INTO cotNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Irootaquequea inintantavetacaca Erorishi irimetojacaantaquerimequea, cotanquitsiquea itsaroacaajiacariquea maasano choocajianquitsica oraniqui, yamenajiaqueriquea iriguenti tsavetantatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iroompaquea aapojacagueti isavincaguiterite Erorishi icajemajiaqueriquea itsipavijijiacaca irishecatimojiaquempariquea. Ariqueate ishecashecaica, oquijitsipojacaquea orijanite Eroriashi otsamaropojaquequea opitsopitsovaetanacaquea ocanca. Ishineventsitanacaro Erorishi, ");
INSERT INTO cotNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","icanqueroquea: —Imaica noncanquempi arimajaca nojocaquempiroquea taaca opajita pamanaquenaca, aatotarite namatavijimpitsi. Incatsimatimentenarota Aapani Irioshi aatogueti nonetsanatiro nocanqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Otsatacaitsitaroquea iniro, ariquea ocampojajiri Erorishi: —Pojocacotsitenaro acaniqui iguito Joanca Viñacajatantatsica shimencoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ariquea icotanaca iriatimpa ishimampojancanaca, cotanquitsiquea iroorijite icanqueroquea, aisa iquemajiaqueriquea maasano icajemajiaqueca, irootarite icantantacaca: —Iroosacanicate intsiquetirote. ");
INSERT INTO cotNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Itigaranquitsitariquea coareta ichoocaquegueti Joanca isantanatacotacagueti irijitorejaquiteri iraacotanaqueneroquea iguito. ");
INSERT INTO cotNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ariquea yaacotanaqueneroqueate yojocacopojaquenero, irooqueate jocacotavaqueneroquea iniro. ");
INSERT INTO cotNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iroompaquea iquemacojiaqueriquea itsatacaanejia Joanca, icoraquetashijiajiri yaajianajiro itsino iquitajiajiro. Ariqueate yoayoaitanaji icamantajiaquitiri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iroompaquea iriraquea Jesoshi iquemacoquerigueti Joanca imetojacaantajiquerigueti, yoanaque osamani teegueti inchoocateji caquinte, iriguenti itsipatsipaitanaca itsatacaanejia, iquenajatantajianacaroquea quenajarontsi. Cotanquitsiquea iquemacojiaqueriquea choocajiatsica oraniqui guinteninintsipaequi, yoguijaguijaitanaqueriquea yanijinijiitanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iroompaquea yarejerejeipojaca yoncotsinampijaatacojiapojaca. Irooquea iterejavetanaca Jesoshi yamenajiapojiriquea icaramirincavaequequea caquintejia, ipintsatacojianacari maasano. Yogueshiguetajiri maasano ashinoncajajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Imaicaquea ijaguitevaetanaji catsirincaiteri, iriraquea itsatacaanejia icantajiguiri: —Jac ijaguitevaetanaji catsirincaiteri. Ocaniquiquea ocaniqui teequea quericaca choocatatsineca, iroosacanica pintigarancajiajerija maasano irirajia iroaroaitanajetaja ontaniqui guinteninintsipaequi cameetsanijite irivegarajiaquenijite isheca irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Cotanquitsiquea Jesoshi icantajiguiri: —¿Taaquea opaji iroashitantemparoca? Pojocajigueneri aviatimpajia irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iriatimpajia icantajiguiri: —Teequea anejeroji taampate nojocajiaquenerica. Ariguenti ocarataque 5 pan, iriraquea shima mavipaquite icarataque. ");
INSERT INTO cotNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Icanque Jesoshi: —Iintsijate pojocajiguenarojate. ");
INSERT INTO cotNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ariquea icanqueriquea maasano irisavisaviitaquequea cataromashiqui. Iriatimpajia isavisaviitaquequea, ariquea yaaqueroquea Jesoshi maasano 5 pan aisa mavipaquite shima, ipaguitetanaquero inquite yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea icotarejaqueroquea pan, yojocajiaqueneriquea itsatacaanejia, iriatimpajia yojocajiavaqueneriquea maasano. Ariquea iquempetacaacari shima iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ariquea ishecajiaca maasano, iquemajianaca. Iroompa iriraquea itsatacaanejia icapiocajiajiro choocatajatsica, itejiajiro cantiriqui tseraiquipae, ocaratacovaetaji 12. ");
INSERT INTO cotNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Maasano shecajianquitsica icaramirincavaeque arica 5,000. Cotanquitsiquea iriguenti itsajitaquequea shiramparijia quenquevarijia, teetarite intsajiteroji manquigarentsijia aisa chaajaniquirijia. ");
INSERT INTO cotNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iroompaquea icantajiguiri Jesoshi itsatacaanejia: —Pintepinteitanajempajate quenajarontsiqui pijivajivaitanajejate pimontejacojianajempaquea intatiqueroqui. Naatimpa aatotaquea nocoraquetsitaja, nonquenquetsatacaajiavajerita irirajia iroaroaitanajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iroompaquea yoayoaitanajigueti maasano, iriatimpa itoncoanaque otsempiqui iramaneri Iriri, apatiroquea yoanaquequea. Ariquea opitsecanaquegueti apaniro ichoocaque. ");
INSERT INTO cotNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Iriraquea itsatacaanejia javaetanajiquea niganquijaqui ontaniqui. Oraquea iniromotija otamacojatanaquequeate oshequi, oshaguishaguivaetanaqueroqueate quenajarontsi joac joac, ochovigajencapojiqueate choviga jeoc jeoc, oguipiguipiacojiaqueriqueate. ");
INSERT INTO cotNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ariquea irooshipojajigueti osavincaguitetanaje, icoraquepojaji Jesoshi, yanijijatapojiro jenoquija iniromotija. ");
INSERT INTO cotNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iriraquea itsatacaanejia yamenitsijigariquea yanijijatapojiro jenoquija itsaroajianaque, icajemajianaquequea: —¡Jeerishiatsi sashinti! ");
INSERT INTO cotNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Icantsitanaca Jesoshi: —Pintampishishirentajianaque. Naroguenti, aatoquea pitsaroajiguitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Icantiriquea Peerero: —Nomajirote, aviguentica, pincajemenashiatsi nagaticajatashitanajempita ojenoquijaarequi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Icantiriquea Jesoshi: —Caacatequetirote. Yanijirejanaque Peerero yagaticajatsivetanacaroquea iroanaqueme ichoocaquegueti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cotanquitsiquea yamenavaqueroquea ochovigajencapojiquea itsaroitsitanaca, ariqueate icotanaca itsitijaatanaque, icajemitsitanaca: —¡Nomajirote, paavajenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Itaampinatsitanacaquea icantajempequitanaca Jesoshi, yaitsitavajariquea iracoqui, icanqueriquea: —¡Teemajaca pintsateji arimajaca nagavejavaeti! ¿Querocaquea ococani pitsaroancaca? ");
INSERT INTO cotNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Irooquea itehiteitanajatiga quenajarontsiqui jac opeanaja choviga. ");
INSERT INTO cotNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Maasano choocajianquitsica quenajarontsiqui igueroventajianacari Jesoshi, icanqueriquea: —Arimajaca aviguenti Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Imontejacojianajaquea yarejejiapojajaro Jenesarequi. ");
INSERT INTO cotNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Irirajia choocajiatsica oraniqui yamenajiavaquerigueti iriguenti Jesoshi, ishiashiaitanacaquea icamantajiavacaanaca itsitacaguitejajianaqueroquea iguintenijiagueti. Yaajianaqueneri maasano ashinoncajajianquitsica irogueshiguetajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iroompaquea iriatimpajia icantapojiri: —Intsishiatsi, Nomajirote, noninque inchagatsijivetavaquempiro oshipaquijaniqui piitsaare. Maasanopaetari chagatsijiaquerica ipeaguetanaja. ");
INSERT INTO cotNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iroompaquea icoraquecoraqueipoji pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, iquenaquenaipoji Jerosarequi, icantajiguiri: ");
INSERT INTO cotNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Queroquea icohicoitacani pitsatacaanejia teeca irinetsanatantajiguemparoji maasanopae icantajianaqueca avaesatiniteni? Mana ishecajiacaquea intati teequea inquivacomajatempaji. ");
INSERT INTO cotNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iriraquea Jesoshi icanqueriquea: —¿Queroquea picojiacani aviatimpajia teeca irooquea pinetsanatantajiguempaji icanqueca Aapani Irioshi, iroguenti pinintajiaque pinetsanajiaquequea icantajianaqueca pivaesatiniteni? ");
INSERT INTO cotNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Icantavetacaquea Aapani Irioshi: ‘Pinquemisantamajajiaquerijate piri aisa piniro, aatoquea pipigatsajigaritsija.’ Icanque aisa: ‘Iriraquea tsavejencatirica iriri irooca iriniro irimetojitajitempari.’ ");
INSERT INTO cotNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Cotanquitsiquea aviatimpajia manaquea picantashitatijaiacaroquea. Pinquenquejejate imaica, choocajia irijanintajiatsica coguitejacojianquitsica icantajiavecariquea irijanite incavintsajajiaquerime irojocajiaquenerime icoguitejacojiacaca, cotanquitsiquea aviatimpajia manaquea picantajiaquequea cameetsavaeque incanqueriquea: ‘Aatoquea nagaveji nojocajiguimpirotsi pamanajiaquenaca, irooriji maasanopae nashintaguecaca nashintacaajari Aapani Irioshi’, ");
INSERT INTO cotNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ariquea aatoquea yojoquiniri. Oraquea piquempejiacagueti imaica iroguentiquea povashiantajianaquero icanqueca Aapani Irioshi, irooquea poguijaguijaitanaque icantajianaqueca pivaesatiniteni. ");
INSERT INTO cotNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Cameetsatamampeajiatsica! Itampaticamajataqueroquea tsavetantatsica Isaiashini itioncacojianaquempigueti coramani icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iricatica caquintejia ishinetseraventamampeaquena, cotanquitsiquea manaquea ichoocashirentavaetaque osamani. ");
INSERT INTO cotNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Itsaroventamampeajiavetaquenaquea, cotanquitsiquea itsatacaantajiguica iroguenti icantajiguica caquintejia irinetsanajiqueca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iroompaquea icajemajiaqueriquea maasano, icapiocajiaqueriquea, icantajiguiri: —Pinquemisantamajajiavaquenaja, pintsajiavaquero noncamanquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oraquea quijanquitsica ivagantequi caquinte teequea irooquea covaeguisheshirenterineca. Oraquea sotoanquitsineca ivagantequi, irootaquequea covaeguisheterineca. ");
INSERT INTO cotNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ariquea iquempejiquempejiitapojiriquea itsatacaanejia, icanqueriquea: —¿Pamenajiavaquerimpa pariseojia itijerequivorojianaca iquemajiaquempigueti picanquerigueti imaica? ");
INSERT INTO cotNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Icanque Jesoshi: —Maasanopae panquirentsi teeca irioquea vintyaquerone Aapani Irioshi inquitequitica intsopajajiqueroquea oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Imaica ariquea iquejejiaca irirajia pariseojia, iquempejiacari shamponcajatatsica irancatsavacojiaquerigueti irapishamponcajariteni. Oraquea inquempetaquempagueti imaica mavite shamponcajari irancatsatavacaajiaquempagueti iroaroaitegueti, mavitequea intanquiretanquireitanaque ocogarajacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Icantsitanaca Peerero: —Iintsijate poguisotoguenaroja pitsavetacotaqueca incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Icanque Jesoshi: —¡Arisacanica piquempejiacaquea aviatimpajia tequerata pinquemajiguenaji! ");
INSERT INTO cotNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Arimpate teequea pinquemajiguenaji nocantajiaquempica? Nocanque maasanopae ishecajiguetacaca manaquea oanaque itsicotoqui, ariquea irishitacojitajero. ");
INSERT INTO cotNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cotanquitsiquea maasanopae iquenquetsaguishejitaqueca oquenantapojacaro shiretsi, irootaquetari iquenquejaguishejitica. Irootaquequea covaeguishetantanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ariquea oquenapoji ishirequi taaca opajitapae covaeguisherentsipae, iquenquejaguishejiaquero taaca opajitapae coguisherentsipae, imetojantajigui, yoashijiguiro manquigarentsi manquigajiatsica aisa tequeratatirajaca irimanquigajitemparoji, yaitsitantajigui, itsojeventantajiga, iquenquetsatacoguishetantajigui. ");
INSERT INTO cotNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Maasanopae ocatica ipeacaaguishejiguetacaca irooquea iroguenti ocovaeguishetanti, cotanquitsiquea pishecajiaquempagueti aatogueti piquivacoveta teequea oncovaeguishetanteji. ");
INSERT INTO cotNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iroompaquea yoanaque Jesoshi irooshitacoquero Tiro aisa Shirone. ");
INSERT INTO cotNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ariquea ocoraquepojiquea aparo manquigarentsi ichoviquijianaqueca choocajiavetatsica Canaanequi, ocanquequea: —¡Nomajirote, Ichoviquitanaqueca Taavini, pincavintsajenashiatsi! Chooca norijanite ishaquiacaca ampatsini atsipevaecaquea oshequi. ");
INSERT INTO cotNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cotanquitsiquea iriraquea Jesoshi teequea incanteji, manaquea isanticotanaque. Ariquea iquempejiquempejiipojiri itsatacaanejia, icantajiaqueri: —Intsijate pinquemisanteroja cameetsanijite oanajenijite, manaqueate oguijaguijaipojacaji ocajemavaepoji. ");
INSERT INTO cotNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Icanque Jesoshi: —Iroguenti itigaranquimentaquenaquea Aapani Irioshi noncoraquetashijiaqueri ishiraerijia, noncavintsajajiaqueri quejejiacarica oveja peajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cotanquitsiquea iroatimpa arimpaquea oquempejitapojari ogueroventanacari, ocanque: —¡Nomajirote, iintsishiatsi pincavintsajacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Cotanquitsiquea Jesoshi icanqueroquea: —Teequea oncameetsateji aapitsateri chaajaniquirijia isheca, ojoquitenempari ishiishitepae. ");
INSERT INTO cotNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iroatimpa ocanque: —Arimajaca, Nomajirote, cotanquitsiquea shiishi iramenacojiaquerigueti irishecajiaquempagueti virajiacarica iroguijavaqueroquea isaviji shitaponcarontsiqui irishecatsopequiguetavaquemparoquea otsopequi ontanquirejaguetanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Icantsitaroquea Jesoshi: —Iroosacanica, manquigarentsi, pitsamajataque nagavejaque nogueshitajero porijanite, imaica nonetsanataquempiro pamanaquenaca. Iroompa icanquitiguiro opeapanajanta. ");
INSERT INTO cotNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iroompaquea yoanaji Jesoshi icantanacaquea otaravijatapojacagueti iniromotija Garirea. Coajicaquea itoncoanaque niganquitantanaqui ariquea isavicaque oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ariquea yoayoaitashitanaqueri icaramirincavaetanaque caquintejia yaajianaqueneriquea teeca iranijimajateji, shamponcajaripae, macanaripae, teeca ironcavacotempaji, aisa oshequini ashinoncajajiatsica ocantashitatiajencaguecaquea ashinoncajarentsi. Yojoquijijiapojiniri iguitiqui Jesoshi. Iriatimpa yogueshiguetavajiriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iriraquea capiocajianquitsica yamenamenaitanaquequea intati, yamenajiaquetarite iquenquetsajianajiquea macanaripae teeca inquenquetsajiavetempaji, yoncavacojianajaquea teeca ironcavacovetempaji, yanijimajatanajiquea teeca iranijimajavetempaji, aisa yamenajianaji shamponcajavetanquitsica. Ariqueate icohicoitanaca ishineventamajatanacari Aapani Irioshi cavintsajajiaquerica ishiraerijia. ");
INSERT INTO cotNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iroompaquea icajemajiaqueriquea Jesoshi itsatacaanejia icantajiguiri: —Nopintsatacojianacariquea irirajia, namenajiaqueriquea isavicaventajiaquenaquea ocaniqui 3 savincaguiteri, niganquiquea iteroncacojianacaquea ishecajia. Imaicaquea imaica teequea onchoocateji taaquea irishecajiaquempaca. Teetarite noninteji nontigarancajiaqueriquea iroaroaitanaje itsovironaquitequi itaseajiaquetari, aajiavaqueritsi itase quenavoquirontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iroompaquea icantajiguiri itsatacaanejia: —¡Ooo icaramirincavaequequea! ¿Querocampate naajiaqueroni pan nojocajiaquenerica irishecajiaquempaca maasano inquemantajianaquempacate? Ocaniquiquea teequea quericaca guintenitantemparone. ");
INSERT INTO cotNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Icanqueri Jesoshi: —¿Querocaquea ocarashequiaqueni pan choocatanquitsica? Icantajiguiri: —Ocarati 7. Chooca aisa ishantyoriqui shima tee iroshequiamajateji. ");
INSERT INTO cotNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ariquea Jesoshi icantajiaqueriquea maasanojia irisavisaviitaquequea quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yajiricajiaquero pan caratanquitsica 7 aisa shima, yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea icotarejaqueroquea pan aisa shima yojocajiaqueneri itsatacaanejia, irioqueate jocajiavaqueneriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ishecajiacaquea maasano, iquemajianaca. Oraquea choocatapojajatsica iteguetajiroquea itsatacaanejia cantiriqui, ocaratacovaetaji 7. ");
INSERT INTO cotNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maasanojia shecajianquitsica icaramirincavaeque 4,000. Iriguentitarite itsajique shiramparijia, teequea intsajiteroji manquigarentsijia aisa chaajaniquirijia. ");
INSERT INTO cotNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iroompaquea Jesoshi itigarancajiajiri iroaroaitanajeta. Iriatimpa itetanaja quenajarontsiqui, itsipatsipaitanajari itsatacaanejia yoajianaquequea irooshitacoquero Magarara. ");
INSERT INTO cotNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ariquea icoraquecoraqueitashipojiriquea Jesoshi pariseojia aisa saroseojia iramenantajiguempari, icantantajiapojacarica ironigaajiaqueri oacaantantatsica intati onquenantapojemparoja ontaniqui jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Cotanquitsiquea iriatimpa icanqueriquea: —Aviatimpajia pamenajiguirogueti ocamachoncaguitetigueti itsaparoncaguitetigueti catsirincaiteri manaqueate picantajigui: ‘Osaitequeraquea oncameetsaguitetamanaquequea, camachoncaguitevaequetarite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Oraquea arigueti oncamachoncaguitetamanaquequea picantajigui: ‘Imaicaquea aatotarite ocameetsaguiteti, mampiroguitevaetaquequea, aisa seevaequetarite.’ Pitsajiavetacaro arigueti oncameetsaguitetaque aricampate aatocaja ocameetsaguiteti, cotanquitsiquea teequea pintsajigueji queroquea ocotacani oquempetantacaca imaica pinejajiavetacarogueti taaca opajitapae oacaantantatsica intati teeca iramenajiteji coramani. ");
INSERT INTO cotNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aviatimpajia otiavaetaquempiquea covaeguisherentsi, pinintantajiacaca namenacajaiaquempiro oacaantantatsica intati, cotanquitsiquea aatoquea namenacajaiguimpirotsi. Iroguentiquea namenacajaiaquempi otsipa onquempetaquemparoquea iquejetacaajitacarigueti Jonashi coramani. Ariquea itsinampirejajianajiri, yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iroompaquea yoayoaitanaquequea itsatacaanejia Jesoshi imontemonteitanajaquea intatiqueroqui, ipeacojianajaroquea pan irajaianaqueme irishecajiaquempameca. ");
INSERT INTO cotNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iroompaquea iriraquea Jesoshi icanqueriquea: —Aviatimpajia, inchiquiojitaja pishecatacojigarotsi anempoacaguiroca pan irashijia pariseojia aisa saroseojia. ");
INSERT INTO cotNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Irooquea iquemajiavaquegueti iquenquetsatavacaajianaca, icanquequea: —Manatarite yamenajiacajiquea teetarite ameji pan, jero icantantajiacaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iriraquea Jesoshi yamenajiavaquerigueti iquenquetsatavacaajianaca, icantsitariquea: —¡Teemajaca pintsamajajigueji arimaja nagavejamajati! ¿Queroquea ococani piquenquetsatacotantajiacaroca pan, picanquequea manatarite namenaquempi teequea pameji pan? ");
INSERT INTO cotNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Arimpate tequerata pintsajigueji? ¿Arimpate teequea pinquenquejajigueroji pan ocaravecaquea 5, nocotarejaguequero noshecatacaajiacari 5,000 shiramparijia? Ariquea picapiocajiajiro choocatapojajatsica oshequiacovaetaji cantiripaequi. ¿Arimpate pipeacojiajaroquea? ");
INSERT INTO cotNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aisa ¿arimpate teequea pinquenquejajigueroji ocaravecaquea pan 7, nocotarejaguequeroquea noshecatacaajiacari 4,000 shiramparijia? Ariquea picapiocajiajiroquea choocatapojajatsica oshequiacovaetaji cantiripaequi. ¿Arimpate pipeacojianajaro? ");
INSERT INTO cotNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Oraquea nocantajiaquempigueti: ‘Inchiquiojitaja pishecatacojigarotsija anempoacaguiroca pan irashijia pariseojia aisa saroseojia’, ¿queroquea ococani teeca pintsajiavaqueroji teequea irooquea noncantacoteji pan? ");
INSERT INTO cotNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ariquea itsajiaque itsatacaanejia teequea irooquea incantacoteji anempoacaguiroca pan, iroguentiquea iquempetacaacaro itsatacaantajiguica pariseojia aisa saroseojia aatonijite iquemisantajiguiritsi itsatacaantajiguigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iroompaquea yoanaquequea Jesoshi icantanacaroquea oraniqui irooshitacocarogueti guinteninintsi pajitatsica Sesarea Piripo. Ariquea icanqueriquea itsatacaanejia: —¿Queroquea icanqueni caquintejia? ¿Taa ipaji iricatica Irijanite Caquinte? ");
INSERT INTO cotNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iriatimpajia icantajiguiri: —Iconoagarantajiaca icantacojiaquempi: ‘Iriguenti Joancani Viñacajatantatsica.’ Itsipa cantajiananquitsica: ‘Iriguenti Iriashini.’ Itsipaquea cantajiananquitsica: ‘Iriguenti Jeremiashini, teegueti irio, iriguenticaja itsipa tsavetantatsicani paesatinica, itancorejanajishiatsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ariquea icantajiguiri: —Aviatimpajia, ¿quero picantajiguini? ¿Taa nonaque naatimpa? ");
INSERT INTO cotNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Icantsitanaca Shimo Peerero: —Aviguenti Quirishitotatsica, Irijanite Aapani Irioshi anijatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Icanqueriquea Jesoshi: —Pishinetaca, Shimo, irijanite Jonashi, teetarite irioquea caquintejia tsatacaajiguempirone ocatica picantaquenaca imaica. Iriguenti tsatacaaquempiro Aapani inquitequitica, icavintsajaquempitari. ");
INSERT INTO cotNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ariquea noncanquempi naatimpa: aviguenti Peerero, Mapi, ariquea ocatica shiratantapiqui novinchajacotantemparo notsovironaquite cantacotaquerica maasano quemisantajiaquenaneca. Aatoquea agavejajiguiri osotomoro Areshi ichoocaquegueti metojatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Onquempevetaquempaquea nojocaquempi yavi iyavirejantajitaroca sotomorontsi inquijantajitempaca imajirontagueti Inquitequitica; taaca opajita picantimentaquerica choocatanquitsica acaniqui quepatsiqui, inquejetaquempa Aapani inquitequitica incantimentantaqueroquea; aisa taaca opajita pishineteneri choocatanquitsica acaniqui quepatsiqui, inquejetaquempaquea Aapani inquitequitica irishineteneri. ");
INSERT INTO cotNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ariquea Jesoshi icantajiaqueriquea itsatacaanejia aatonijite itsavetantajiguiritsi incanquequea iriguenti Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iroompaquea Jesoshi iparianacaroquea itsatacajaiaqueriquea itsatacaanejia iroanaque Jerosarequi irantsipetacajaiaquempariquea jivajiatsica, irirajia saserorotejia anaantajianquitsica, irirajia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, iroompaquea ari irimetojajiqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri impochatanaje. ");
INSERT INTO cotNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iriraquea Peerero itsipatanacari tiijacoñaji icantomajitavetari, icantiriquea: —¡Aato, Nomajirote! ¡Aatotari avishimatimpi! ");
INSERT INTO cotNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Cotanquitsiquea ipitsocanaca Jesoshi icantsitari Peerero: —¡Poanaqueshinete, Satanashi! Piticaavetaquena, teetarite irooquea pinquenquejamajate inintaguetica Aapani Irioshi, iroguenti piquenquejaguetaquequea iquenquejaguetica caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ariquea Jesoshi icanqueriquea itsatacaanejia: —Quericaca nintanquitsineca iroguijatacoquena irovashiantanaqueroja inintashiguevetacaca iriatimpa, irinatashitapiniquempa inchapoa irompajacotantajiquemparica, mananiji iroguijatacoquena. ");
INSERT INTO cotNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Quericaca teeca irininteji irantsipeventena irooca irimetojavenquena, manaquea impeaquempa; cotanquitsiquea iriraquea atsipevenquenaneca irooca irimetojavenquena, incoquempaniquea inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Arigueti inchoocavetaquempa agavejanquitsineca irashinquemparo maasanopae quepatsipaequitica, cotanquitsiquea oncoramanitapojajegueti irimetojaquegueti arigueti impeaquempa camorecariqui, ¿arimpate agavejaque irajaararo aavajeri? Aatoquea agavejitsi. Irashintaguevequemparoqueate maasanopae, cotanquitsiquea aatotarite yagaveji irivegaraventavaquempa aatonijite yoguitsi camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Oraquea incoraquetajategueti Irijanite Caquinte iroganejencapojajempaquea, iroguentiquea iroganejencare Iriri. Oraquea incoraquetajategueti intsipatsipaiquempariquea irashivantijitete, iroguishinejajiapojajeri maasano netsanajiguiroca inintaguetica, irioquea teeca inquemisantajigueri manaquea incatsimatimentajiapojajeri irantsipetacaajiaquempari. ");
INSERT INTO cotNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Noncanquempija arimajaguitatsi iconoagarantaca catintiitimojiaquenaca imaica, aato imetoji tequeratagueti irameneri irira Irijanite Caquinte irimajirontapojaquempagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iroompaquea anaavaetanacaguetiquea 6 savincaguiteri iriraquea Jesoshi yoanaquequea ontaniqui otsempiqui yagatsonquivaetanaquequea osamani. Iriguentiquea itsipatsipaitanaca Peerero, Santiago aisa iriguentijeguite Santiago pajitatsica Joanca. Tee inchoocateji itsipajia. ");
INSERT INTO cotNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iroompaquea taampina iriatimpajia yamenitsijigari Jesoshi icantashitatiimojianacariquea. Ariquea icotanaca itsirencashimpoquirerejanaquequea ivoroqui quempetanacaquea itsirencashimpoquirerejigueti catsirincaiteri, aisa iitsaarequi oquitamaromajatanaquequea ocanca. ");
INSERT INTO cotNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yamenitsijigariquea Moishishini aisa Iriashini iquenquetsatacaajiaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Irira Peerero icanqueriquea Jesoshi: —Nomajirote, cameetsavaeque achoocajiaque ocaniqui. Pininquegueti nompeacaguempaja 3 catisetarentsi, aparo pashinquempa aviatimpa, aparo irashinquempa Moishishi, otsipaquea irashintaquempa Iriashi. ");
INSERT INTO cotNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Quenquetsavetanatsi omanacojiapojajiri mararo quitamaromajatanquitsica, ariquea iquenquetsajencajitanaque omararosecanquegueti icanque: —Iricatica irio Irijani, nopintsatacaca, noshineventamajatacari. Pinquemisantamajajiguerija. ");
INSERT INTO cotNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iquemitsijigariquea ariqueate icohicoitanaca itsarotsaroitanaque ipatapataitanaca. ");
INSERT INTO cotNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Cotanquitsiquea Jesoshi iquempejiquempejiipojiri ichagajiaqueriquea icanque: —Pincatintiijianaje, aatoquea pitsaroajigui. ");
INSERT INTO cotNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yamenitsijiavetanaja aisa teequea anejeriji incatintiitaje, aparoquea icatiaja Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ariquea icoraquecoraqueitaji yoguirincajiaja, iriraquea Jesoshi icanqueriquea: —Aatotaja quericaca picamantitsi oratica pamenajiaqueca imaica. Intancorejanajegueti Irijanite Caquinte irimetojavetaquempagueti, ariquea pintsavetacotsijiguemparoquea. ");
INSERT INTO cotNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iriraquea itsatacaanejia icoacotaqueri, icantajiguiri: —¿Quero ocotacani icantantacaca tsatacaantajiguiroca itioncacotanaqueca Moishishini icantajiaquegueti iriquetitaquea coraquetajatsine Iriashini? ");
INSERT INTO cotNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Icanqueri Jesoshi: —Arimaja iriquetitaquea coraquetajatsine Iriashini, irinetsanaguequeroquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Imaica noncantajiaquempiquea jac icoraquequiti Iriashini, cotanquitsiquea teequea intsajiteriji, manaqueate yantaguishejitaqueri maasano inintajitaqueca. Ariquea inquempetacaajitaquempariquea Irijanite Caquinte irantsipetacajaiquempari. ");
INSERT INTO cotNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ariquea itsajiapojaque itsatacaanejia iriosacanica itsavetacotaque Joanca Viñacajatantatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iroompaquea yarejerejeipojacaquea ichoocajiaquegueti caquintejia icapiocajiacagueti. Icoraquetashipojiri Jesoshi aparo shirampari, iguerovempojacari icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nomajirote, pimpintsatacotenarishiatsi nirijanite imetojapinitaquiti icantapinitaquiti tinquininini, yatsipevaetaca. Itsiatsiavaetanacaqueate paamariqui, aisa iticajaticajavaetaca ojaaquiniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namajiavetacanariquea pitsatacaanejia irogueshitajerimequea, cotanquitsiquea teequeate iragavejajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Icanque Jesoshi: —¡Arisa picomirincajiga teequea paventemparoji iragavejane Aapani Irioshi, iroguentiquea picovaeguishejiga! ¿Querocaquea oncarashequiavaeteni nosavicaventajiaquempi? ¿Queroca oncarashequiavaeteni nantsipetacojiaquempi? Iroosacanica iintsijate pamajiaquerijate ocaniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iroompaquea icantomajitari Jesoshi ampatsini, ariquea icotanaca isotoapanajanti, ari ipeanaja chaajaniquiri ishaquiavecaca. ");
INSERT INTO cotNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Coajica iriraquea itsatacaanejia icoraquetashijiapojiriquea Jesoshi apaniro, icanqueriquea: —¿Queroquea ococani naatimpajia teeca nagavejajigueji noguisotoitajigueriji? ");
INSERT INTO cotNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Icanque Jesoshi: —Iroorijite tee paventajiguemparoji nagavejane. Arimaja noncanquempi, arigueti pavenquitiguemparo capichaji, ariquea pagavejajiaqueroquea pincantajiaquero oratica otsempi: ‘Pogaanaquempajate poanaquequea osamani’, ogaanaquempaquea. Aatotarite taaca opaji manapitsajiguimpitsi arimajacagueti paventamajatanaquemparogueti nagavejane. ");
INSERT INTO cotNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Cotanquitsiquea ampatsinipae quejecarica irintatica, aato isotogui aatogueti pamanamajatiri Aapani Irioshi, aisa aatogueti pisanticotiro pisheca. ");
INSERT INTO cotNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iroompaquea Jesoshi itsipatsipaitanacari itsatacaanejia yoayoaitanaquequea oraniqui Garireaqui, itsatacajaiaqueriquea icanque: —Iriraquea Irijanite Caquinte iraacaantajiqueri iraajiavaqueri caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ariquea irimetojajiaqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri irovochantajitajeri. Ariquea iquemajiavaquerigueti ishimampojancajianaca oshequi. ");
INSERT INTO cotNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ariquea yarejerejeipojacagueti Jesoshi aisa itsatacaanejia Caperenaoqui, icoraquejiapojaquequea capioquirica imentaquipae ashiquea teemporo, icoacojiapojaqueri Peerero, icanqueriquea: —Iriraquea tsatacaajiguimpica ¿teempa irivegaratapiniteri capioquirica imentaquipae ashiquea teemporo? ");
INSERT INTO cotNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Icanque Peerero: —Jeejeguitatsi ivegaratapinitiri. Iquijavetanaquitiga intsompogui tsovironaquiqui ichoocaquegueti Jesoshi, iriquetiquea quenquetsatacaavaqueri, icanqueriquea: —Shimo, ¿queroquea piquenquejaque aviatimpa? Iriraquea majirontajiatsica choocajiatsica acaniqui quepatsiqui ¿queri irivegaratacaaquempaca imentaquitsite? ¿Irioca irijanijiate, irioca itsipajia? ");
INSERT INTO cotNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Icanque Peerero: —Iriguentiquea irivegaratacajaiaquempaca itsipajia. Icanque Jesoshi: —Iroosacanica teesacanica irioqueate irivegaratacaajiguempaji irijanijiate. ");
INSERT INTO cotNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Cotanquitsiquea aatimpajia aatonijite icatsimatashitaji, poanaque iniromotijaqui pojocatsajataquiteja, iroompaquea iriraquea iriquetica paaque pintisavancaqueritaquea paitsitavaqueriquea imentaqui cavorejatatsica choocatanquitsica ivagantequi, pamajiaqueneriquea capioquirica imentaquipae ashiquea teemporo, pojocajiapojaqueneri. Irarejequemparo ivegaratacaaquenaca naatimpa aisa aviatimpa avegaratimentajiaquempaniji. ");
INSERT INTO cotNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iroompaquea iquempejiquempejiipojiri itsatacaanejia Jesoshi icantajiaqueriquea: —¿Quericaca anaantamajatanquitsineca irimajirontaquempagueti Inquitequitica? ");
INSERT INTO cotNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iriatimpa icajemitsitaquea aparo chaajaniquiri yogatiitsitariquea niganquiqui ichoocajiaquegueti, ");
INSERT INTO cotNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","icantajiaqueriquea: —Arimajaca noncantajiaquempica: aatogueti picantashitatijaijaa pishirequi pinquempejiajempariquea chaajaniquirijia, aatotarite pagavejitsi pinquijanaque imajirontagueti Inquitequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taacagueti quempetajemparineca iricatica chaajaniquiri teeca inquenquejeroji iranaimanatantaque, irioquea iriguenti caaviji iranaaque irimajirontaquempagueti Inquitequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aisa quericaca shineventavaquemparine chaajaniquiri quempecarica iricatica iroorijite nonintacaantaquero naatimpa, quempecaqueate naroguentica ishineventavaca. ");
INSERT INTO cotNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Taacagueti covaeguishetacaaquemparineca aparo chaajaniquiri quejejiacarica iricajia tsaroventaquenaneca, incatsimamajajitaqueriquea oshequi. Iroquetitamequea intsatotacojiquenerime itsanoqui iniroshimentapiri itononcantajitaca ariquea irajaitanaquerimequea impishoncajajiquerime osaanajavaetaquegueti inirojani quentijani. ");
INSERT INTO cotNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Imaicashiatsi irantsipevaejiguempanishiatsi maasano choocajiatsica acaniqui quepatsiqui, inchoocajiaquetarite nintajianquitsineca incovaeguishetacaantajiaquempaquea! Ariquea onquejetanaquempaquea imaica, cotanquitsiquea caavijiquea irantsipemajajiaquempaquea quempejiaqueroneca imaica, incatsimamajajiqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nonquejetacaajiaquempiroquea imaica: arigueti oncovaeguishetacaaquempi paco irooca piguiti, ariquea pincarataqueroquea pimpishonquitemparo. Cameetsavaequequeate pimpishoncaquerogueti covaeguishetacaaquempica pinetsanatimentanajempanijite. Aatoguetitarite pipishonquiro jatanatsitarite oncovaeguishetacaajempi, iroompa pimetojanajegueti impishoncajitaquempiqueate camorecariqui aatoca otsivaquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aisa iroogueti covaeguishetacaaquempine poquija pinquitsorejaaquempa pimpishoncaquero. Cameetsavaequequeate pimpishoncaquerogueti covaeguishetacaaquempica pinetsanatimentanajempanijite. Aatoguetitarite pipishonquiro jatanatsitarite oncovaeguishetacaajempi, iroompa pimetojanajegueti impishoncajitaquempiqueate camorecariqui aatoca otsivaquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aatoja pitsojenquiritsija irirajia chaajaniquiri, choocajiatarite irashivantijitete Aapani Irioshi quempoguijajiaquerica. Iriatimpajia icocaniquea ichoocajiaque ontaniqui quempeji Aapani Irioshi choocatatsica jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Irootaquequea icoraquetantacaca Irijanite Caquinte, iraajiajateri peajiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Queroquea piquenquejajiaque aviatimpajia? Inchoocategueti aparo caquinte iriviraquempaquea 100 irovejajiate iroompaquea impeaquempaquea aparo, ¿arimpate aatompate yojocajianajiri maasano irovejate iroanaquequea iramenaguetajateri peanquitsica? ");
INSERT INTO cotNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ariquea iraajerigueti caaviji irishinevenquempariquea, anaavaequeroquea ishineventajiacarigueti maasano 99 teeca impeavetempaji. ");
INSERT INTO cotNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ariquea iquempetacaquea Piri inquitequitica, teetarite irininteji impeaquempaquea aparo quejejiacarica irirajia chaajaniquiri. ");
INSERT INTO cotNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Querocagueti incoquempini papitsaroventarite poanaquequea pinquenquetsatacaapojeri apaniroja, pincamanqueriquea querocagueti icoquempini. Iriatimpa inquemaquempigueti jac pivetsinantajiri. ");
INSERT INTO cotNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Oraquea aatogueti iquemimpitsi, pintsipatanaquempariquea aparo arica mavite papitsaroventarite cameetsanijite inquemajiavaquempinijite iriatimpa, aisa intsajiaquenijite arimajaca pininquequea pivetsinantajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cotanquitsiquea aatogueti iquemimpitsi, poanaquequea icapiocajiacagueti tsaroventajiatsica pincamantajigueriquea, incantomajajiaqueriquea. Aatogueti iquemiritsi iriatimpajia, manaquea pinquempetacaajiaquempari teeca intsaroventempariji Aapani Irioshi irioca capioquinirica majirontatsica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Arimaja noncantajiaquempi: taaca opajita picantimentaquerica choocatanquitsica acaniqui quepatsiqui, inquejetaquempa Aapani inquitequitica incantimentantaqueroquea; aisa taaca opajita pishineteneri choocatanquitsica acaniqui quepatsiqui, inquejetaquempaquea Aapani inquitequitica irishineteneri. ");
INSERT INTO cotNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Noncantajiaquempi aisa: arigueti pincarate mavite acaniqui quepatsiqui, arigueti onquempetavacaguempa pinquenquejaqueca, iroompa pincoacotaqueri Aapani inquitequitica, ari irimataquempiro. ");
INSERT INTO cotNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Querocagueti incapiocaventajiaquenagueti, mavitegueti inchoocajiavetaquempa irooca mavitepae, ariqueate nonchoocatimojiaqueriquea naatimpa.” ");
INSERT INTO cotNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iroompaquea iquempejipojari Peerero, icanqueri: —Nomajirote, ¿querocaquea oncarashequigueni nompeacotajemparo querocagueti incoquenani napitsaroventarite? ¿Ari oncaravaete 7? ");
INSERT INTO cotNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Icanqueriquea Jesoshi: —Aatoqueate ocaratapojitsi 7, manaquea oncaravaetequea 70 x 7 pimpeacotajemparo. ");
INSERT INTO cotNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Imaicaquea noninque nontsatacaajiaquempiro quero icotani imajirontagueti Inquitequitica, manaquea nonquempetacaaquempari majirontatsica cajemacaantajiaquerineca itigarancajiguica caarica jocavetajanari, incantajiaqueri irivegarajiajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Irooquea iparianacaroquea icajemacaantajiaqueri, yamajitaqueneri aparo jocajenerinemeca oshequini imentaquitsite caravaetatsica 10,000 tarentopae. ");
INSERT INTO cotNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cotanquitsiquea iriatimpa teequea inchoocateji taampaquea irivegaratantajemparica, irootaquetari icantacaantantacarica majirontatsica irojocantajiqueri intsipatacaantsitempariquea imanquigare aisa irijanijiate, maasanopae yashintaguecaca, iraantajiajemparoquea imentaquipae cameetsanijite irivegaratimentajerinijite. ");
INSERT INTO cotNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cotanquitsiquea iriatimpa igueroventsitanacari, icanqueriquea: ‘Pimpintsatacogajoitenashiatsi, poguijacoquempatajate oncoramanitapojajegueti novegaratajempiroquea maasano imentaqui nojocajempimeca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iriraquea majirontatsica ipintsatacotanacariquea icanqueriquea: ‘Iroosacanica aritaquequea ococa, aatoquea pivegaratajanatsi.’ Yoguipaquijitajari. ");
INSERT INTO cotNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cotanquitsiquea yoanajigueti itonquivojajariquea igonoro aacovecarica, icaravetaca 100 tenario irojocajenerimeca. Yaitsitanacariquea icatiquitsitari itsanoqui, icanqueriquea: ‘¡Pivegaratenashinete paacovequenaca!’ ");
INSERT INTO cotNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Iriatimpa igueroventsivetanacari icanqueri: ‘Pimpintsatacogajoitenashiatsi, oncoramanitapojajegueti novegaratajempitarite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cotanquitsiquea iriatimpa teequea impintsatacotempariji, manaquea yaacaanqueriquea isantanatacotacaantsitari inchoocaguiteni arejevaetapojempa irivegaratajeri yaacovecarica. ");
INSERT INTO cotNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ariquea yamenajiaqueriquea igonorojia, ishimampojancajianaca yoayoaitanaque icamantajiaquitiri majirontatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iquemitsitaquea icajemacaantsitari aacovecarica icanqueriquea: ‘Isaashimpi. Naatimpa manaquea nopeacotajimpiro maasanopae pojocaquenameca, irooriji picantanaquena: Pimpintsatacogajoitenashiatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Arimequeate pinquempetacaaquemparimequea aacovequempica aviatimpa, pimpintsatacojiaquemparimequeate iriatimpa, pinquempetaquename naatimpa nopintsatacotimpigueti.’ ");
INSERT INTO cotNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Icatsimatsitanacaquea icantacaantaqueri irantsipetacajaiaquempari arejevaepojajempa irovegaratajeriquea maasanopae yaacovecarica.” ");
INSERT INTO cotNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iteroncanaquerogueti Jesoshi itsavetanquerogueti icanque: —Ariqueate inquejetacaajiaquempiquea Aapani inquitequitica aatogueti pipintsatacojigariquea pigonorojia pimpeacomajaquemparogueti querocagueti icojiaquempini. ");
INSERT INTO cotNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iroompaquea iteroncanajirogueti Jesoshi itsavetantaquerogueti, isotoantanacaro Garirea, yoanaquequea Joreaqui intatiqueroqui Jororanequi. ");
INSERT INTO cotNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yoguijaguijaitanaqueriquea oshequini caquintejia. Ontaniquiquea yogueshitajiriquea maasano ashinoncajajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ariquea iconoagarantajiaca pariseojia choocajiatsica oraniqui icoraquecoraqueipojiquea icoacojiapojiri iramenajiaqueri querocaca incanqueni iriatimpa, icantajiapojaqueri: —¿Cameetsavaequempa irovashiantajero shirampari imanquigare onchoocaquegueti taaca opajita teeca irinintamajateroji? ");
INSERT INTO cotNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iriatimpa icanqueriquea: —¿Arimpate teequea pampatsajavanteroji itioncacojiquerogueti paesatoniqui ocanque iroaqueragueti ipeacaacarigueti Aapani Irioshi caquinte ipeacaitsitariquea shirampari aisa manquigarentsi? ");
INSERT INTO cotNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iroompaquea icanquequea: ‘Irootaquequea imaica shirampari intsinampirejanaqueriqueate iriri aisa iriniro, quisho iroamajataquero imanquigare, apatsinoroquea incantanajempa. Ariquea iroaqueragueti tequeratagueti irimanquigatemparoji, mavite icarajiavetaca, ariquea imanquigacarogueti ariqueate icojianaca tee irimavitetajempaji, quempetanajaqueate apatsinoronica icantaja.’ ");
INSERT INTO cotNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Irootaquequea noncantantajiaquempica iriraquea shirampari manquigataquemparoneca manquigarentsi aatoquea yovashiantiroquea, teetarite irimavitetajeji, quempeca apatirotiquea icantaja, yamenaqueriquea Aapani Irioshi imanquigacarogueti teetarite oncameetsateji irovashiantaqueroquea, incoquempanija irimanquigamajataquemparoquea. ");
INSERT INTO cotNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iriatimpajia icantajiaqueri: —Iroosacanica, ¿queroquea ococaniqueate icanquegueti Moishishini arigueti irovashiantanajero shirampari imanquigare, irojoquitenemparojate paperi otioncacagueti yovashianquero, ariquea intigaranquitsitemparo oanaje? ");
INSERT INTO cotNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Icanque Jesoshi: —Iriraquea Moishishini manatarite yamenajiaquempiquea piquishoshirentanaque jero iquejetacaantajiaquempirocaquea imaica itioncajiaquempiroquea. Cotanquitsiquea iroaqueragueti ipeacaacarigueti Aapani Irioshi caquinte, teequea inquempeteroji imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Noncanquempiquea naatimpa, aparogueti oaquempi pimanquigare aatoquea povashiantirotsijate. Povashiantanaquerogueti iroompaquea pimanquigatajempagueti otsipa manquigarentsi, manaquea picovaeguisheca. ");
INSERT INTO cotNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iriraquea itsatacaanejia icanqueriquea: —Iroosacanica omanavaetacaquea oshequi amanquigatemparogueti manquigarentsi. Aatosacanica amanquigatarotsi. ");
INSERT INTO cotNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iriraquea Jesoshi icanqueriquea: —Teetarite iragavejajigueji maasanojia inquemisanteroji nocantajiaquempica, imaicaquea iriguentiquea quemisantajiaqueroneca yagavejacaajiaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Choocajiatarite iconoagarantajiaca teequea iragavejajigueji irijanintajiguempaji, ari icoca ivoaquegueti. Aisa chooca itsipa iroguenti ipeacaajicari eonoco aatoniji irijaninta. Aisa choocaquea itsipapae iroguenti itampishitashijiaqueroquea ipeaca majinari cameetsanijite irisavicaventamajajiaqueronijite irashipae Majirontamajatatsica Inquitequitica. Quericaca agavejanquitsineca intsamajaqueroquea nocantajiaquempica imaica iintsijate intsaterojate. ");
INSERT INTO cotNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iroompaquea icoraquecoraqueitaquequea itsipapae yamajiapojiniriquea Jesoshi chaajaniquiripae impamijiavaqueriniji iramanacoventajiaqueriquea. Iriraquea itsatacaanejia yamenajiavaquerigueti yamajiapojirigueti icantomajavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Icantsitariquea Jesoshi: —Ariotaquetsija incoraquetetate chaajaniquirijia naatimpaqui, aatoquea pojocaavaca, ishineventajiacaritarite Inquitequitica irimajirontacotaquempari quenquejajiatsica quempecarica iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iroompaquea ipamijiaqueriquea yamanacoventajiaqueri. Ariquea iriatimpa yoanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oraquea yoanaquegueti Jesoshi icoraquetashipojiriquea aparo caquinte, icantapojaqueri: —Tsatacaantantatsica cameetsari, ¿queroquea noncoquempani cameetsanijite noncoguitempaninijite nonchoocaguiteni? ¿Taa opajita cameetsatanquitsineca nompeacaguempaca? ");
INSERT INTO cotNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Icanqueri Jesoshi: —¿Queroquea ococani picantantaquenaca ‘cameetsari’? Aparotari ichoocati cameetsatatsica. Cotanquitsiquea pininqueguetiquea poanaque ichoocatigueti Aapani Irioshi pincoguitempaniniji pinchoocaguiteni, pinetsanamajateroja maasanopae itioncacotanaqueca Moishishini coramanitica. ");
INSERT INTO cotNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Icanque iriatimpa: —¿Querocate? Icanque Jesoshi: —Irootaquequea cantanquitsica: ‘Aatoja pimetojanti, aatoja poashitiro manquigarentsi, aatoja paitsitanti, aatoja pitsojeventantatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pinquenquejacameetsatacoquerija piri aisa piniro, aisa pimpintsataquemparija pigonoro pinquejetacaajempa pipintsatagueti aviatimpa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Icantsitari iriatimpa: —Arimajaca noquempetacaquea imaica nonetsanamajaqueroquea maasano. ¿Imaicaquea choocampate otsipa nonetsanateca? ");
INSERT INTO cotNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Icanqueriquea Jesoshi: —Pininquegueti pinetsanamajaqueroquea inintaguetica Aapani Irioshi, poanaquequea pojocantaguetanaquero pashintaguecaca paantaquemparoquea imentaquipae pojocajiaqueneri coguitejacojianquitsica, pinquejetaquerogueti onchoocataje oganejencaro shinetacajaempineca ontaniqui inquitequi. Ariquea pincoraquetajeja poguijatanaquena. ");
INSERT INTO cotNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iquemitsitaquea icanquerica ishimampojancavaetanaca, ariqueate yoanaji, iriguentitari ajaarantavaetatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iroompaquea ipitsocashitariquea Jesoshi itsatacaanejia icanqueriquea: —Iroomajaca noncantajiaquempica, omanapitsamajataquempari ajaarantavaetatsica inquijanaque imajirontagueti Inquitequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Noncantsijiajempi aisa. ¿Arimpate iragavejaque cameyo inquijanaquequea itepoquiqui quisaatonquiri irisotoanaqueriquea antaqueronta? Aatotarite yagavejitsi. Iriompaqueate ajaarantavaetatsica caaviji anaaquero omanapitsataquempari inquijanaque imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iquemitsijigari itsatacaanejia arimpaqueate yamenamenaitanaque intati, icantajigui: —Iroosacanica, ¿quericampate agavejanquitsineca iraavajempa? ");
INSERT INTO cotNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yamenajianaqueriquea Jesoshi, icanqueriquea: —Iriraquea caquinte teequea iragavejeroji, cotanquitsiquea Aapani Irioshi yagavejaquero maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Icantsitanaca Peerero: —Nomajirote, naatimpajia novashiantajianaqueroquea maasanopae nashintavecaca, noguijaguijaitanaquempi. Imaicaquea ¿taaca irojocajiaquenaca Aapani Irioshi? ");
INSERT INTO cotNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Icantajiguiri Jesoshi: —Iroomajaca noncantajiaquempica, oraquea iriaqueratacaajitajerogueti maasanopae, irira Irijanite Caquinte irisavicapojero imajirontamento oganejencatatsica irimajirontamajapojempa. Aviatimpajia guijaguijaitanaquenaca imaica pintsipajianaquenaquea pisavisaviiqueroquea majirontamentontsipaequi oncarataque 12. Iroompaquea pincantajiaque querocaca incojitaquerini ichoviquijianaqueca irijanijiate Ishiraeri, icarajiaque iriatimpajia aisa 12. ");
INSERT INTO cotNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aisa iriraquea maasano ovashiantajianaqueroca itsovironaquitepae, irioca iriguentijeguitepae, itsijoitepae, iriniro, iriri, irijanijiate, irooca iniganquitejire, iroguijaguijaitanaquenaniji, irojocajiqueneriquea otsipa caavijica anaaqueroneca yashintavecaca oshequijamajatanaquequea; taaca opajita yovashiantanaqueca apatiroca irojocajitajeneriquea otsipapae 100. Aisa incoguitempaniquea inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Icaramirincavaequequea yamenajivetacaca imaica yanaantavaeque, cotanquitsiquea oncoramanitapojajegueti aatoquea yanaantajitsi. Aisa icaramirincavaeque teeca iranaanteji imaica, oncoramanitapojajegueti iranaantavaetanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Imaica nontsavetacotaqueroquea quero icotani Inquitequitica imajirontagueti, iroguenti nonquempetacaaquemparo ashintatsica iniganquitejire. Iriatimpa iroguenti yoguiniquea pitsecatirajagueti iraaquiteriquea shiacojiatsica irishiacojiaqueneri irovaitsoquimashite. ");
INSERT INTO cotNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ariquea yamenajiapojiriquea icantajiguiri: ‘Poapoaitanaquequea pishiacojiaquitenarojate ovaitsoqui, iroompaquea inquijanajegueti catsirincaiteri novegarajiaquempiquea aparo tenario.’ Iriatimpajia icanquequea cameetsavaequequea. Jero itigarancajiaqueriquea iroaroaitanaque irovaitsoquimashitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iroompa ijenoquivaepojigueti catsirincaiteri icoraquetajiquea yojocantajiguetirogueti taaca opajitapae irajaatequea itsipajia shiacotanquitsineca. Yamenajiapojiri itsipajia, savisaviitaquequea intati, teequea irantajigueji. ");
INSERT INTO cotNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Icantajiguiri: ‘Poapoaitanaquequea aviatimpajia aisa, pishiacojiaquiteja noniganquitejirequi, novegarajiaquempiquea cameetsa.’ Ariquea yoayoaitanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iroompaquea itampaticatanaquegueti catsirincaiteri yoitsitanajaquea aisa iramenaguetaquitequeate itsipajia shiacotanquitsineca. Ariquea iquempetacaajaroquea ijaguitetanajigueti, yaitajata itsipajia. ");
INSERT INTO cotNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iroompaquea irooshipojigueti inquijanaje catsirincaiteri, yoitsitanajaquea aisa yamenajiapojiriquea itsipajia, teequea irantajigueji, icantajiguiri: ‘¿Queroquea ococani pisavisaviitashicaquea intati, teequea pantajigueji?’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Icantajiguiri: ‘Tee inchoocatenica shiacotacaajiguenaneca.’ Iriatimpaquea icantajiguiri: ‘Iroosacanica poapoaitanaquequea aviatimpajia pishiacojiaquequea noniganquitejirequi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Iroompaquea itsaparoncaguitetanaquegueti icanqueriquea shiacotacaajiaquerica: ‘Imaica pincajemajiguerija shiacojianquitsica pivegarajiaqueriquea pintsitacajiaqueri, pimpariajianaquempari impoipoiitanquitsica parejetacaapanajantempari iriquetica coraquecoraqueitanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iroompaquea icoraquecoraqueipoji coraquejianquitsica irooshipojigueti inquijanaje catsirincaiteri. Iquejetavacaajiaca maasano ivegarajiaquerigueti, yojocajiaqueneri aparo tenario. ");
INSERT INTO cotNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iroompaquea icoraquecoraqueipojiquea iriquetica shiacomajatanquitsica, iriatimpajia yamenajiguiriquea ijiqueji iranaacaajiaqueriji irivegaramajajiaqueri. Cotanquitsiquea manaquea iquejetacaajiacari ivegarajiaquerigueti, yojocajiaqueneri aparo tenario. ");
INSERT INTO cotNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Irooquea yamenajiaquerigueti teequea iranaacaajigueriji irivegaramajajigueriji, ariqueate icohicoitanaca icantimanajianaqueri ashincaroca iniganquitejire. ");
INSERT INTO cotNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Icantajiguiri: ‘Irirajia impoipoiitanquitsica capichajaniquiquea ishiacotaque, cotanquitsiquea pivegarajiaqueri quempeca pivegarajiaquenagueti naatimpajia atsipejianquitsica noshiacoguitini catsirincaiteriqui narejevaeca imaica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cotanquitsiquea irira ashincaroca icanqueri aparo shiacotanquitsica: ‘Nogonoro, teequea namatavijempiji. ¿Arimpate teequea pincanteji cameetsavaeque incajaranqui nocanquempigueti novegarataquempi aparo tenario? ");
INSERT INTO cotNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Poanajequea paanajeri yojocaquempica. Naroguentiquea cantaquerica irivegarajiqueriquea impoipoiivetanquitsica ishiacoquegueti iquempetacaajiaquempiriquea aviatimpa ivegarajitaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Naroguentitari ashincari nomentaquitsite. ¿Arimpa aato nagaveji nojoquiniritsi quericaca noninqueca? ¿Aricaja picatsimatacotsitaquenaro pamenaquegueti iriguenti nocavintsajaque itsipa?’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Irootaquetarite noncantantajiaquempica imaica choocajia iramenajivequempaca imaica yanaavaequequea, cotanquitsiquea oncoramanitapojajegueti aatoquea yanaantajiajitsi. Iriraquea teeca iranaantajigueji imaica, irioquea anaamajatantanquitsineca oncoramanitapojajegueti.” ");
INSERT INTO cotNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iroompaquea yoanaquequea Jesoshi Jerosarequi itoncotoncoitanaque, icajemitsitari iriatimpaqui itsatacaanejia carajianquitsica 12, icantajiguiri: ");
INSERT INTO cotNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Imaicaquea atoncotoncoitanaque oahoaitanaque Jerosarequi. Ontaniquiquea ontaniqui arejerejeipojaquempagueti manaquea iraacaantajiqueri irira Irijanite Caquinte, irajaitanaqueri ichoocajiaquegueti saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iriatimpajia incanquequea: ‘Iintsishiatsi irimetojajiterini.’ ");
INSERT INTO cotNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ariquea irajaitanaqueriquea ichoocajiguigueti teeca irijorijoigueji cameetsanijite irantanaguishevaequerinijite, aisa impasapasajiaqueri agompiaquitempari, ariquea irompajacojiaqueri coroshiqui, cotanquitsiquea aapojajempagueti 3 savincaguiteri impochatanaje. ");
INSERT INTO cotNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iroompaquea ocoraquepojiquea imanquigare Severeo otsipatsipaitapojacari irijanijiate, oguerovempojacariquea Jesoshi oncamanqueriniji oninqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Icanqueroquea: —¿Taa opaji pininque? Iroatimpa ocanque: —Aapojajempagueti pimpeaquempagueti Imajirojiate maasano, noninque poguisavisaviitaquenari irirajia irijani irisenampijajiaquempi, aparo savicanquitsinequea pitincamijempequiqui, iriraquea itsipa irisavicaque pishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Cotanquitsiquea Jesoshi icanque: —Teequea pintsajigueroji ocatica pinintavecaca. ¿Arimpate pagavejajiaquequea aviatimpajia pimiraquero nomiraqueca naatimpa? Iriatimpajia icantajiguiri: —Jeejeguitatsi nagavejaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Icantajiguiri Jesoshi: —Pitampaticamajataquero pimiraqueroquea nomiraquempaca naatimpa, cotanquitsiquea teequea naatimpa cantanquitsineca quericaca senampijaquenaneca savicanquitsineca notincamijempequiqui aisa noshinampijempequiqui. Iriguentiquea cantanquitsi Aapani Irioshi paesatoniqui iroaqueragueti. ");
INSERT INTO cotNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ariquea iquemajiavaquegueti itsipajia 10 itsatacaanejia itijerequijianaqueri Santiago aisa Joanca. ");
INSERT INTO cotNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Cotanquitsiquea Jesoshi icajemajiaqueriquea icanqueriquea: —Pitsajiguiritarite iriraquea ipejaiaqueca imajirojiate teeca irijorijoigueji manaquea yatsanavaecari igonorojia, ariquea iquempejiaca iramajirorejia yomperaperaicari irashijia. ");
INSERT INTO cotNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cotanquitsiquea aviatimpajia aatoquea piquejejiga. Ariguenti quericaca nintanquitsine iranaantimojiaquempi, impeitsitempaja amijiaquempineca. ");
INSERT INTO cotNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Quericaca nintanquitsine irijivatante, impeitsitempaja iromperare maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Quempeca Irijanite Caquinte teequea irooquea incoraquetashiteji iramijitavaqueri, iroguenti icoraquetashitaque incavintsajantapoje, aisa irimetojaventsitempariquea maasanojia, onquejevequempaquea irivegaraventajiajeneri irisotoimentajianajeniji santanatacojiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ariquea Jesoshi itsipatanacariquea itsatacaanejia iquenaquenaipoji Jericoqui iroaroaitanaque Jerosarequi, itirorencaventajianacari caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ariquea oraniqui isavicajiaquequea mavite shamponcajari ocaravoquitapojigueti quenavoquirontsi. Irooquea iquemacojiavaquerigueti Jesoshi coraquetapoji icajemitsijianacaquea icanqueri: —¡Nomajirote, Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Irira choocajianquitsica icantomajajiaqueriquea icantsijiavetari irisanticotanaquenijite, cotanquitsiquea iriatimpajia arimpate icajemamajatsijianaca: —¡Nomajirote, Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Icatiapojacaquea Jesoshi icajemajiaqueri icanqueri: —¿Taaquea pinintajiaque? ");
INSERT INTO cotNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Iriatimpajia icantajiguiri: —Nomajirote, nonintajiaque nompityaquirejajianaje. ");
INSERT INTO cotNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ipintsatacojianacariquea Jesoshi ipamijiaqueriquea iroquijaqui. Ariquea icojianaja inejajianaji, yoguijaguijaitanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iroompaquea irooshipojigueti irarejerejeipojemparo Jerosare, yarejerejeipojajaroquea Vetepaje Orivotsempiqui. Iroompaquea iriraquea Jesoshi itigarancajiaqueriquea mavite itsatacaane icantajiavaqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Poanaquequea ontaniqui quempeji guinteninintsiqui, pamenajiapojeroquea oraniqui aparo aashino shiticacoca itsipatacaantajicaro irijanigantirenajaniqui. Pishiticarejacojiaqueri pamajiaquenari. ");
INSERT INTO cotNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Choocagueti cantaquempineca, aviatimpajia pincantajigue: ‘Iriguenti coacotacari Amajirote, taampinatari iroguipiajiajempiri.’ ");
INSERT INTO cotNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ariquea oquejetantacaca imaica onetsanatanaquempaniji icanqueca tsavetantatsica coramani itioncacaajiquerigueti, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pincantajiguerija guintenijiatsica Shionequi: ‘Pamenajigueja, coraquetapoji Pimajirote aviatimpaqui, iriatimpa iriguenti caavijica imativicamajataca, manaquea iquenantapojacari aashino, irijanigantirenajaniqui aashino, irijanite quijaviriniquitatsica ajaararontsi.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iroompaquea yoayoaitanaquequea itsatacaanejia inetsanatsitaroquea icanquerica Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yaajianaqueroquea aashino aisa irijanigantirenajaniqui, ipashicamititsajiaqueneri iitsaarepaequi, isaviquitsitanacariquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yoayoitanaquequea icaramirincavaetanaque caquintejia, iconoagarantajiaca imaroncaashijiavaqueri iitsaare quenavoquirontsiqui, itsipapaequea aavashijiavanquitsica ovashi imaroncaavoquitashijiavaqueriquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iriraquea iriquetica oahoaitananquitsica aisa irirajia guijaguijaitaquerica icajemajianaque, icanque: —¡Caaviji yoganejencamajataca irira Ichoviquitanaqueca majirontatsica Taavini! —¡Intsishiatsi irishineventajiquempari iriratica coraquetapojatsica itigarancaqueca Majirontamajatatsica! —¡Caaviji yoganejencamajataca Aapani Irioshi choocatatsica jenoqui! ");
INSERT INTO cotNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ariquea iquijanaquegueti Jerosarequi, ishiamirincajiapojaca choocajianquitsica. Iconoagarantajiaca icoacojiapojiri itsipajiacaca icanqueriquea: —¿Taa ipajita iricatica? ");
INSERT INTO cotNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iriatimpajia icanquequea: —Iriguenti Jesoshi tsavetantatsica quenapojatsica Nasarequi Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ariquea Jesoshi iquijanaque oniganquirequi oticaacoroqui teemporo itsaroventantajitarica Aapani Irioshi yamenajiapojiri jocantantaguetirica viratsipae aisa vegaratantajiguirica. Yoguivorocajiapojaqueriquea maasanojia, aisa yapitaquiaguequeroquea ishitaponcaropae yojoquijitantacarica imentaquitsite guipiantajiguirica imentaquipae. Iquejetsiguetaroquea aisa isavisaviitantacaca jocantajiguirica emorenipae. ");
INSERT INTO cotNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Icantajiguiri: —¿Arimpate tee ontionquempaji: ‘Oratica notsovironaquite incantacojitero iroguenti ashi incoraquetantapinijitempaca iramanajiaquenaniji’? Cotanquitsiquea aviatimpajia manaquea pipeacajaiacaro imoro itsititantaca aitsitantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iroompaquea ocaniqui oniganquirequi oticaacoroqui teemporo icoraquetashijiapojiri shamponcajarijia aisa teeca iranijimajateji. Iriatimpa ipityaquirejaguetajiri teeca iramenajiavetempaji, aisa yanijitacaamajatajiri teeca iranijimajajiavetempaji. ");
INSERT INTO cotNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iriraquea saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini icatsimamajajianaque yamenajiavaquerigueti yonigaantaguequeroquea oacaantantatsica intati, aisa iquemajiaquerigueti chaajaniquiripae icajemitsijianaca oniganquirequi teemporo, icantajiaque: —¡Caaviji yoganejencamajataca irira Ichoviquitanaqueca majirontatsica Taavini! ");
INSERT INTO cotNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ariquea iriatimpajia icantajiguiri: —¿Arimpate teequea pinquemajigueriji irirajia chaajaniquiripae icajemajiaquegueti? Iriraquea Jesoshi icantajiguiri: —Jeejeguitatsi, noquemaque, cotanquitsiquea ¿arimpate teequea pampatsajavantacojigueroji ocanquegueti: ‘Pinintacaajiaqueri chaajaniquiripae aisa igantagatirajaca yatsoti intsaroventajiaquempi’? ");
INSERT INTO cotNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ariquea yojocajianajiri isotosotoitanajiro Jerosare, yoayoaitanaque Vetaniaqui, ariquea imaapojaji oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iroompaquea osavincaguitetamanaquegueti icoraquecoraqueitaji Jerosarequi. Iriraquea Jesoshi ariquea itaseapoji. ");
INSERT INTO cotNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ariquea yamenacovetapojacaro iguera ocaravoquitapojigueti quenavoquirontsi, ariquea yoapanajanti iramenamajapanajanteroquea choocaca osovena, cotanquitsiquea yarejevepojacaroquea quempeji tee onchoocateji, iroguentini ovana. Icantsitaroquea: —Imaicaquea imaica aatotarite ochoocatimataji pisovena. Ariquea ocotanaca osampirocanaquequea ometojanaque. ");
INSERT INTO cotNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Irooquea yamenajiavaquerogueti itsatacaanejia yamenamenaitanaquequea intati, icanqueriquea: —¿Queroquea ococani picanquitiguiro ometojanaque? ");
INSERT INTO cotNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iriraquea Jesoshi icanqueriquea: —Iroomajaca noncanquempica, arigueti paventamajataquemparigueti Aapani Irioshi pintsamajajiaquegueti arimajaca yagavejamajati, aatogueti pinquenquejimatirotsijate: ‘Aatoca yagaveji Aapani Irioshi’, ariquea pagavejajiaquequea pinquempejiaquena naatimpa nosampirocaquerogueti iguera. Cotanquitsiquea teequea aparoquea ocatica. Aisa pagavejajiaque pincantajiguero ocatica otsempi: ‘Poanaquetsija pojocajatempa inirojaniqui quentijani’, oapanajantequea ojocajapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Maasano taaca opajita pamanajiaquerica Aapani Irioshi, arigueti paventamajajiaquempari, onetsanaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iroompaquea yarejetapojaca Jesoshi teemporoqui iquijapojaquero oniganquirequi oticaacoroqui itsatacaantapojaque. Incajaranquiguitetanaquegueti icoraquecoraqueitashipojaqueriquea saserorotejia anaantajianquitsica aisa jivajiguirica joriojia, icanqueriquea: —¿Taaquea cantaquempi piquempetancaroca imaica poguivorocantajiacarica jocantantajiatsica? ¿Taampate tigarancaquempiquea? ");
INSERT INTO cotNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iriraquea Jesoshi icanqueri: —Intsija naatimpa noncoacotempi. Poguisotoaquenarogueti, ariquea nonquempetsitempa naatimpa noncamanquempiquea queri tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iviñacajatantigueti Joancani, ¿queroquea oquenapojini? ¿Irooca oquenantapojaca inquite? ¿Irioca oquenantapojaca caquintejia? Irooquea iquemajiavaquerigueti iquenquetsatavacaajianaca icantajigui: —¿Querocate ancoterini? Ancantsivetemparigueti oquenantapojaca inquite, iriatimpa incantanaque: ‘Iroosacanica ¿queroquea ococani teeca pinquemisantantajiguempariji?’ ");
INSERT INTO cotNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Cotanquitsiquea ariguetija ancantsivetempari oquenantapojaca caquintejia, atsaroacaajiacariquea caquintejia, maasanopaetari icanque irira Joancani iriguenti tsavetantatsica itigarancaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jero icantantajiacarica: —Teetari nontsajiguenica. Ariquea iriatimpa icanqueriquea: —Iroosacanica, ariquea nonquejetaquempaquea naatimpa, aatoquea nocamantimpitsi quericaca tigarancaquenaca naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iroompaquea Jesoshi icanqueriquea: —¿Queroquea pincanqueni pinquenquejerogueti noncantajiaquempica imaica? Ichoocati caquinte choocatatsica mavite irijanite. Iroompaquea icanqueri parianquitsica: ‘Irijani, poanaque pishiacoquiteta ovaitsoquimashiqui.’ ");
INSERT INTO cotNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Iriatimpa icanque: ‘Aatoquea noguitsi’, cotanquitsiquea iroompaquea iquenquejanaquero yoanaque ishiacoquiti. ");
INSERT INTO cotNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Iroompaquea yoashitanaqueri itsipa irijanite, ariquea iquejetacaacari iriatimpa, itigarancavetacari irishiacote. Iriatimpa manaquea icantaveca: ‘Intsija nonquejetaquempa’, cotanquitsiquea teequea irogueji. ");
INSERT INTO cotNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Imaicaquea pincantajiguena, ¿querica quemisantavaquerica iriri? Iriatimpajia icanquequea: —Iriguenti parianquitsica. Ariquea Jesoshi icantajiguiri: —Iroomajaca noncanquempica, iriraquea capiocajiguinirica majirontatsica imentaquitsite aisa manquigarentsijia cantatsatantaguetatsica yanaajiaquempiquea iquemisantajiaque, iriquetiquea quijaquijaitananquitsine imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pinquenquejeja, icoraquetashijiavequempiquea Joancani Viñacajatantatsica itsatacaajiavetaquempiquea queroquea pincojiaquempani pincomajamajajiaquempagueti, cotanquitsiquea aviatimpajia teequea pinquemisantajigueriji. Iriraquea capiocapinijiguinirica majirontatsica imentaquipae, iriguentiquea quemisantajiaquerica. Ariquea oquejetaca cantatsatantaguetatsica. Aviatimpajia pamenajiavecariquea cotanquitsiquea teequea pinintajigueji pincantashitatijaianaquempa povashiantajianaquero pigovaeguishere pinquemisantajianaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Iintsija pinquemisantajiavaqueroja nonquejetacaajiaquemparogueti otsipa. Ichoocataque aparo caquinte yashinca iguepatsite. Ariquea imiataqueroquea ovaitsoqui itantotacotaqueroquea. Aisa ipeacaashicaroquea yagaticantajitaroca ovaitsoqui osotoajatantanaquempaca ovaja, aisa ipeacaacaroquea irisavicantaquempaca jenoqui amenaqueroneca cameetsanijite iramenamajaqueronijite aatonijite yaajitirotsi. Iroompaquea icajemajiaqueri itsipapae irishiacojiaqueneriquea. Oraquea onchoocatanaquegueti irojocagarantajiaqueneriquea iriatimpa. Iroompaquea yoavaetanaquequea jmm osamani. ");
INSERT INTO cotNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ocoramanivaetapojiquea aapojajagueti osampatantanajempaca ovaitsoqui itigarancajiavecari irashijia iramanajiajaterime irojocagarantajiajenerime. ");
INSERT INTO cotNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cotanquitsiquea iriraquea shiacojiaqueroca manaquea icatsimajiaqueri aparo itavatavaavaequeri, iriraquea itsipa imetojajiaqueri. Iriraquea itsipatapojatsica manaquea itsinatsinavaequeri mapiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iroompaquea iriraquea ashincaroca ovaitsoquimashi itigarancajiavecari itsipajia irashijia, yanaajiaqueriquea iriquetica itigarancajiavecaca. Cotanquitsiquea iriraquea shiacojiatsica ariquea iquempetacaajiavacari iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Iroompaquea icanquequea: ‘Iriocajate nontigarancaquequea nirijanite, irioca intsaroacaajiavaquempa.’ Ariquea itigaranquitsitari. ");
INSERT INTO cotNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cotanquitsiquea iriatimpajia yamenajiavaqueriquea icoraquetapojaquegueti, iquenquetsatavacaajianaca icanque: ‘Jeeri irintatica ashinquemparoneca maasanopae irimetojanajegueti iriri. Jaamequetiroshiatsi ametojajiaqueri cameetsanijite aatimpajia ashintamajatajemparonijite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Iroompaquea yarejevepojaca yaitsijianacari yaajianaqueri acaqueroca otantotacotacagueti ovaitsoquimashi, imetojitsitari. ");
INSERT INTO cotNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Oraquea incoraquetajegueti ashintamajataroca ovaitsoquimashi, ¿querocaca incojiapojaquerini irirajia shiacojiatsica?” ");
INSERT INTO cotNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iriatimpajia icanqueriquea: —Irimetojajiaqueri interoncajiaqueri maasanojia, aatotarite ipintsatacojigaritsi. Iroompaquea incajemajiaquequea itsipajia quempoguijajenerineca iniganquitejire. Ariquea onchoocatanajegueti ovaitsoqui iriatimpajia irojocagarantajiajeneri. ");
INSERT INTO cotNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Icanqueriquea Jesoshi: —¿Arimpate teequea pampatsajavantacojigueroji Itioncacaantaqueca Aapani Irioshi coramani? Ariquea ocanque: ‘Oraquea ogota mapi teeca irishineventajiavetempaji peacaajiacaroca mapipanco, opeanacaquea anaantamajatanquitsica quishotacaaqueroca. Iriraquea Aapani Irioshi ipeacajaaroquea. Amenajiaqueroquea aatimpajia oganejencani.’ ");
INSERT INTO cotNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Irootaquequea nocantantajiaquempica aatotari piconoajiajari Aapani Irioshi imajirontagueti, itsipapae caquinte incajemajiaje quemisantamajajiaquerineca, iriatimpajia iriguentiquea peajiaquenerica Imajirojiate. ");
INSERT INTO cotNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Quericaca omposaquemparoneca ocatica mapi incampojemparo jarare jarare, cotanquitsiquea quericaca ontsinacaqueca ompitsarepitsarejatanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Irooquea iquemajiavaquerigueti saserorotejia anaantajianquitsica aisa pariseojia iquejetacaajiacanarica Jesoshi, itsajiaquequea iriguenti itsavetacojiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ariquea icatsimajianaque inintajiaveca iraacaantajiaqueri, cotanquitsiquea itsaroacaajiacari igonorojia. Iriatimpajia yamenajiaqueriquea Jesoshi iriguenti tsavetantatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iroompaquea Jesoshi iquempetacaacaroquea imajirontagueti Aapani Irioshi, icanque: ");
INSERT INTO cotNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Imaicaquea imaica nontsatacaajiaquempiro quero icotani Inquitequitica imajirontagueti. Iroguenti iquempetacariquea majirontatsica itiacaantaquequea taaca opajitapae isheca icajemitsijigari igonorojia irishecatacaajiaquempari irishineventajiaquempariquea irijanite irimanquigaquempagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Iroompaquea itigarancajiaqueriquea irashijia incantajiaquiteri coraquecoraqueitanquitsineca, cotanquitsiquea iriatimpajia teequea irinintajigueji incoraquecoraqueite. ");
INSERT INTO cotNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ariquea itigaranquitsitaja itsipapae icantajiavaqueriquea: ‘Imaica pincantajiavaqueri: “Icajemajiaquempi inetsanamajaqueroquea taaca opajitapae shecatsipae.” Nojitorejacaantajiaqueriquea nogaapironcaarinitepae aisa irijanigantirenajaniquipae quejimajatanquitsica, imaica netsanagueca maasanopae. Pincamanteri incoraquecoraqueique taampina irishecatacojiaquitena.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cotanquitsiquea irirajia icajemavecaca teequea inquemisantajiavaqueriji, manaquea yoayoaitanaque querocagueti. Aparo oananquitsi iniganquitejirequi, itsipa oananquitsica irojocantagueteroquea irajaararo. ");
INSERT INTO cotNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iroompaquea itsipapae yaajiavaqueri itigarancajiaqueca majirontatsica itavatavaavaetavaqueri imetojajiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ariquea icatsimamajatanaque majirontatsica itigaranquitsijigariquea igoaretajiate irimetojajiaquiteri metojantajiatsica, intaitemparo itsovironaquitepae. ");
INSERT INTO cotNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Iroompaquea icanqueriquea irashijia: ‘Jac netsanavetacaquea maasanopae cameetsanijite irimanquigaquempanijite irijani, cotanquitsiquea iriatimpajia nocajemajiavetacaca teequea incameetsajigueji, manaquea iquemavetaca, imaicaquea aatoquea icoraquetitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imaicaquea manaquea poajianaque quenavoquirontsipaequi pincajemajiaquiteriquea maasano quericaca pintonquivotonquivoiquempaca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ariquea yoayoaitanaquequea icapiocajiaqueriquea cameetsajianquitsica aisa teeca incameetsajigueji. Iriatimpajia icoraquecoraqueipojiquea iquijaquijaitapojaque yomporoguijavaetapojacaro itsovironaquite. ");
INSERT INTO cotNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ariquea iquijitapojacaquea majirontatsica iramenajiaquiteriquea icajemajiaqueca. Ipitsoquitsivetanaca yamenitsitari aparo teeca inquitsaatemparoji quitsaarentsi quempetaroca iquitsaajiacaca igonorojia yojocajiquenerica cameetsanijite intsipatsipaiquemparinijite iriaqueraca manquigatanquitsineca. ");
INSERT INTO cotNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Icanqueriquea: ‘Notsipavijitaca, ¿queroquea picocani piquijapoji intati teequea pinquitsaatemparoji quitsaarentsi quempetaroca iquitsaajiacaca pigonorojia?’ Cotanquitsiquea iriatimpa imativicanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Iroompaquea ipitsocashijigari irashijia icanqueriquea: ‘Poishojigueri iguitiqui aisa iracoqui, paajianaqueriquea pimpishoncajiaquiteri sotsiqui opitsecaquegueti pintsipatsipaitacaantaquitempari iraajianquitsica atsicayajijianquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Icaramirincavaequequea icajemajivecaca, cotanquitsiquea irirajia icoguiaguetaqueca teequea iroshequiamajateji.” ");
INSERT INTO cotNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iroompaquea iriraquea pariseojia yoayoaitanaji iquemavacaajiaca incoraquetashijiaqueriquea Jesoshi incomitacaajiaquempari cameetsanijite onchoocaquenijite incanqueca ompampiatantapojempaca incatsimatacaantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iroompaquea iriatimpajia itigarancagarantajiaque itsatacaane aisa shinevencarica Erorishi iroaroaitanaquequea incoacojiaquiteri. Iroompaquea yarejerejeipojaca icanqueriquea: —Tsatacaantantatsica, notsajiaquequea aviatimpa teequea pamatavijanteji. Oraquea pitsatacaantigueti tampatica poaquero picamanqueriquea maasanopae queroquea incojiaquempani irinetsanajigueroniji inintaguetica Aapani Irioshi. Tee inchoocateji quericaca pagamajaquempaca, aisa teequea pintsaroacaguempariji caquinte, irioca anaantavetanquitsica, irioca teeca iranaanteji. ");
INSERT INTO cotNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pitsatirotarite icanqueca majirontatsica Sesa icanquegueti maasanojia jorio irojocagarantapinijiaqueneri imentaquipae. Imaicaquea ¿queroca pincanteni? ¿Cameetsampa nojocajiaqueneri, arica tee oncameetsateji? ");
INSERT INTO cotNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Cotanquitsiquea Jesoshi itsatavaqueroquea manasacanica iquenquejaguishejiaque intati, irootari icantantacarica: —Cameetsatamampeajiatsica, ¿queroquea ocotacani pincomitacaaquename? ");
INSERT INTO cotNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Iintsijate pamaquenarija apamentaquiro imentaqui icanqueca Sesa ajocapinitenerica, nameneritate. Iriatimpajia yojoquitajianariquea tenariomentaqui, ");
INSERT INTO cotNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","icantsitariquea: —¿Taa ipajita iricatica ivaantorijiqueca? ¿Taaquea ashintaro ivajiro tioncanquitsica? ");
INSERT INTO cotNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Icanqueri: —Iriguenti majirontatsica Sesa. Icantsitariquea: —Iroosacanica, pojocajiajenerijate Sesa yashincaca iriatimpa pinetsanatimenqueroniji icanqueca, aisa pinquejetacaajiaquempariquea Aapani Irioshi pinetsanamajajiaqueroja maasanopae icantaguequeca. ");
INSERT INTO cotNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iquemajiavaquerogueti icantajiaquerica, ariquea icohicoitanaca yamenamenaitanaque intati, ariquea yoayoaitanaji. ");
INSERT INTO cotNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iroompaquea incajaranquiguitetanaquegueti irioqueate oahoaitanajatsi saroseojia iramenajiaquiteriquea Jesoshi. Iriatimpajia iriguentiquea cantajianquitsica aatoquea itancoretancoreitajitsi metojatsica. Icantajiapojaqueri: ");
INSERT INTO cotNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tsatacaantantatsica, iriraquea Moishishini itioncanaque coramaniqui paperiqui icanque inchoocaquegueti caquinte teeca irijanintempaji, aapojempagueti irimetojanajegueti irojocapanajantero imanquigare, choocaguetiquea iriguentijeguite irioquea manquigatajemparone irijanintacajaemparoquea quejetaja irioca irijanintajari metojanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Coramaniquea ichoocataquequea aparo nogonoro irijanintacaquea 7. Iriraquea parianquitsica imanquigavetacaroquea manquigarentsi, cotanquitsiquea niganquiquea imetojaque teequea irijanintacaguemparoji. Iroompaquea irioquea manquigavetajaro itsipa oguijatirica. ");
INSERT INTO cotNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ariquea iquejetajaquea iriatimpa imetojanaji, teequea irijanintacaguemparoji. Ariquea iquejetacaquea itsipa niganquitanquitsica, arimpate iteroncanacaquea maasano imanquigajiavetacarogueti, teequea irijanintacajaiguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ariquea ometojitsitanaca iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Imaica, iintsija pincantajiguenaja, oraquea oncoramanitapojajegueti intancoretancoreitanajegueti maasano metojajiavetanquitsica, ¿quericaca manquigamajatajemparoneca? Maasanotari imanquigajiavecaroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Icanqueriquea Jesoshi: —Aviatimpajia manaquea picomijiaca, teetarite pintsajigueroji queroca ocanqueni Itioncacaantaqueca Aapani Irioshi coramani, aisa teequea pintsajigueroji yagavejica iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oncoramanitapojajegueti intancoretancoreitanajegueti maasano metojajiavetanquitsica, aatoquea quericaca manquigatajatsineca, aisa manquigarentsi aatotarite yojocantajitajirotsi irimanquigajitajemparo, manatarite inquempejianajempariquea irashivantijitete Aapani Irioshi choocajiatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Imaicaquea aviatimpajia manaquea picanque aatosa itancoretancoreititsi metojaguevetatsica. ¿Arimpate teequea pampatsajavantacojigueroji icantsitaquempica Aapani Irioshi paesatoniqui, icanquegueti: ");
INSERT INTO cotNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Naroguenti Irioshimajate Averaame, Ishaaco aisa Jacovo’? Teequea irio Irioshite metojatsica, iriguentiquea Irioshite anijatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Irooquea iquemajiavaquerigueti maasano itsatacaajiaquerigueti imaica, mana yamenamenaitanaque intati. ");
INSERT INTO cotNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iroompaquea iriraquea pariseojia iquemacojiaquerigueti Jesoshi imajeretacaajiaquerigueti saroseojia, yoayoaitashitanaqueriquea iriatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aparo pariseo tsamajavetaroca itioncacotanaqueca Moishishini, icoacopojiri iramenantaquempariniji, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tsatacaantantatsica, oraticapae icantacaanqueca Aapani Irioshi irinetsanajite ¿querocate anaantamajatatsica? ");
INSERT INTO cotNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iriraquea Jesoshi icanque: —‘Pimpintsamajataquemparija Majirontamajatatsica Pirioshite, pampaniromajatanaqueri, pimpintsashirentamajaquempari, pimpintsaguenquejanemajatanaquempari.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Caavijiquea anaaque ocameetsamajataque irinetsanamajajiqueroquea ocatica, anaaguequero maasanopae icantacaantaqueca Aapani Irioshi irinetsanajique. ");
INSERT INTO cotNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Oraquea mavitetapojatsica oquejevecaro, ocanque: ‘Pimpintsataquemparija pigonoro pinquejetacaajempa pipintsatagueti aviatimpa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ocaticaquea mavite icantacaantacajica anetsanajigue irootaquetari oquenantapojaca maasano otsipapae itioncacoguetaqueca Moishishini aisa itsipajia tsavetantajiaqueroca icanquerica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Choocatirajagueti pariseojia, iriraquea Jesoshi icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Queroquea pincanqueni aviatimpajia? ¿Quericaca choviquiquerica Quirishitotatsica? Iriatimpajia icanqueriquea: —Iriguentiquea choviquiqueri Taavini. ");
INSERT INTO cotNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iriraquea Jesoshi icanqueri: —Iroosacanica, paesatoniqui iquenquejacaaquerigueti Ishire Aapani Irioshi Taavini, ¿queroquea ocotacani iriraquea Taavini ipeantacarica Quirishitotatsica Imajirote? Icanquetari: ");
INSERT INTO cotNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iriraquea Majirontatsica Aapani Irioshi icanqueri Nomajirote: Pisaviquetaja pisenampijaquenaja notincamijempequiqui pintsipataquenaquea arejevaetanaquempa nagavejajiaquerigueti maasano catsimajiaquempica, onquejevequemparo povanquegontatsitempari.’ ");
INSERT INTO cotNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iriraquea Taavini icanqueri: ‘Nomajirote’, ¿querocaca incoquempani inchoviquitanaqueri? ");
INSERT INTO cotNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Teequeate inchoocatimateji aparo agavejanquitsineca iroguisotoajiavaqueneri, ariquea oparianaca teequea quericaca coacotajerineca, manaquea imajerejianaque. ");
INSERT INTO cotNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iroompaquea Jesoshi iquenquetsatacaajiaqueriquea capiocajianquitsica aisa itsatacaanejia icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iriraquea pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, iriojiaquea oguisotojaiguiroca itioncacotanaqueca Moishishini. ");
INSERT INTO cotNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nocantantajiaquempica intsishiatsi pinquemisantamajajigueri pinetsanamajajigueroquea maasanopae itsatacaajiaquempica, cotanquitsiquea aatoja piquempejigaritsi iriatimpajia. Manaquea itsatacaantajiaquequea intati, cotanquitsiquea teequea irinetsanamajajigueroji. ");
INSERT INTO cotNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Oquejetaca yoishotacojitinirigueti itsipajia inirochonquiina tenamajatatsica iquijachonquiinatacaajitaqueri, iriatimpa ejempaco, teequea irininteji inquije. ");
INSERT INTO cotNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Maasano yantajiaqueca yantajiaqueroquea cameetsaniji iramenimentajiqueriniji. Ariquea yamatsaetacojiacaroquea onaqui ivancaqui yoguijaancaroca itioncacotanaqueca Moishishini, ipeacaitaroquea catsantsanaqui. Ariquea iquempejiaqueroquea aisa imaatacojiacaroquea inaraqui. Oraquea yamanajiaquerigueti Aapani Irioshi iroguenti iquitsaajiaca catsantsajepaquipae. ");
INSERT INTO cotNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oraquea icajemajitirigueti ishecajiacagueti iroguenti inintajiguiquea iroguisavisaviiqueriquea intsipatsipaitacaanquempariquea anaantajiatsica, aisa yoayoaitapinijiguigueti tsovironaquiqui icapiocantapinijigaca inintajiaquequea iroguisavisaviitaqueri intsipatsipaitacaanquempariquea caavijica yanaajiaque. ");
INSERT INTO cotNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aisa yoayoaitanaquegueti oraniqui yojocantantajitirogueti taaca opajitapae inintajiaquequea inquenquetsatacajaitavaqueri incantavaqueri: ‘Tsatacaantantatsica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Cotanquitsiquea aviatimpajia aatoquea pinintajiguitsi incantajiquempi: ‘Tsatacaantantatsica’, choocatarite aparoquea Tsatacaantantatsica tsatacaajiaquempica. Maasano aviatimpajia mana piquejetavacaajiaca, quejejiaquempi iguentijeguijia. ");
INSERT INTO cotNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ocaniquiquea ocaniqui quepatsiqui aatoquea ichoocatimatitsi pijitashitempaca: ‘Aapani’, choocatarite aparo Piri, ichoocati inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aisa aatoquea pinintimatitsi incantajiquempi: ‘Nomajironcaca’, choocatarite aparo Pimajirote, irira Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iriraquea nintanquitsineca iranaaque manaquea iramitacotanquequea. ");
INSERT INTO cotNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aritarite irira quenquejacotajatsineca: ‘Nanaajiaqueri itsipajia’, manaquea iroguipashiventajaqueriquea Aapani Irioshi oncoramanitapojajegueti, iriraquea teeca iranaanteji iroguenti irishinevenquempariquea iranaacaavaequeri. ");
INSERT INTO cotNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Quejevecaquea, pashiterogueti sotomorontsi inquijantajitaquempameca nintajianquitsica irimajirontaquempari Inquitequitica. Aviatimpajiaquea teequeate pinquijeji, manaquea piticaantavaque aatoniji iquijaquijaiti nintajiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Manatarite pamatavijajiaqueroquea metojacoguetatsica piteroncapitsajiaqueroquea ashincaca. Aisa pamanajiaquerigueti Aapani Irioshi picaratsantsatacaavaevetacaro iramenajitaquempiniji. Nocantantajiaquempica aviatimpajia caaviji panaamajajiaque incatsimamajajiaquempiquea oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Aviatimpajia pitsitacaguitejavaetanaqueroquea quepatsi aisa inirojani quentijani pinquemisantacaajiaqueriniji aparo caquinte inquempejianaquempiquea aviatimpajia. Oraquea iquemisantajiaquempigueti caavijiquea igaanacaqueate icovaeguishetanacaquea yanaajiaquempiquea aviatimpajia. Irootaquequea iroantajianaquempaca camorecariqui quejejiaquempi aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia, pitsatacaantajiavecaquea cotanquitsiquea teequea pintsatimajigueji! Mana piquejejiacari shamponcajari nigaavetaquemparica itsipa queroquea inquenanaque. Iroguenti picantajiaquequea: ‘Taaca opaji ancantajiaque iroocajate anquenquetsatacojiaque teemporo ancanque: “Nontsojeaquempagueti ompeguempata teemporo”, iroompa aatogueti anetsanatiroquea acanqueca cameetsataquequea. Cotanquitsiquea iriogueti anquenquetsatacotaquequea ooro choocatatsica teemporoqui, ari anetsanamajaqueroja, aatoquea acantashitatiimatarotsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Quishoguinari pinajiaque! Shamponcajataquempi pishirequi. ¿Querocampate anaatsica: iriocajate ooro choocatancaroca teemporo, iroocajate teemporo yashintantavajarica Aapani Irioshi? Irooriji anaavaeque teemporo. ");
INSERT INTO cotNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ariquea picanquequea aisa: ‘Taaca opaji ancantajiaque iroocajate anquenquetsatacojiaquequea aretare itaantajitarica viratsipae yaajiguinirigueti Aapani Irioshi ancantajiaquegueti: “Nontsojeaquempagueti ompeguempata aretare”, iroompa aatogueti anetsanatiro acanqueca cameetsataquequea. Cotanquitsiquea iriogueti anquenquetsatacojiaque viratsi ogataanquitsica aretarequi, ari anetsanamajaqueroja, aatoquea acantashitatiimatarotsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Shamponcajari pinajiaque! ¿Querocampate anaatsica: iriocajate viratsi, iroocajate aretare yashintantavajarica Aapani Irioshi? Irooriji anaavaeque aretare. ");
INSERT INTO cotNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iriraquea quenquetsatacotiroca aretare, teequea aparo inquenquetsatacoteroji iroatimpa, iquenquetsatacoqueriquea aisa viratsi ogataancaroca. ");
INSERT INTO cotNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ariquea iquejetacaquea iriraquea quenquetsatacotirocaquea teemporo, teequea aparo inquenquetsatacoteroji teemporo, iquenquetsatacotsitariquea iriatimpa aisa Aapani Irioshi choocatancaroca. ");
INSERT INTO cotNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aisa quericaca quenquetsatacotiroca inquite ichoocatigueti Aapani Irioshi irooquea iquenquetsatacotsitaqueri ishitaponcaroquea Aapani Irioshi Imajirojiate maasano, aisa iriguenti iquenquetsatacoquequea Aapani Irioshi savicantaroca. ");
INSERT INTO cotNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Pojocagarantapinijiguiniri Aapani Irioshi pashintaguecaca: pashintajigagueti 10 ovanajaniqui icantajitica menta, irooca oitsoquijaniqui anishi, irooca comino, pinetsanaqueroquea pojocapinijiguiniri aparo. Cameetsavetaca, cotanquitsiquea povashiantanajiro caavijica anaaquequea itsatacajaiaquempica tioncarentsiqui, jero inintamajataqueca: tampatica poaqueneri maasano caquinteguetatsica, pimpintsatacotantempaja, aisa paventamajaguitemparini Aapani Irioshi. Cameetsavaeque pojocagarantajiaqueneriquea Aapani Irioshi pashincaca, cotanquitsiquea aatomesano pipeacojigarome otsipapae icantajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Quempevaequempiquea shamponcajari tsatacaavetanacarica itsipa queroquea inquenacaanaquerime. Quempecaquea pitsicajatacovetacari tsiitojaniqui, iriraquea cameyo, pinijacoqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Piquejejiacari quiviroca otaqui chotarontsi irooca perato, cotanquitsiquea intsompoguirequi jac cantaitevaequequea, oshatecaquempitari covaeguisherentsi, manaquea paitsitantaguetaque, mana picoaguetaquero pinintaguetica aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Aviatimpajia pariseojia quejequempiquea shamponcajari! Iroquetita pinquivaquero intsompoguirequi chotarontsi irooca perato ariquea aato ocantaitetajitsi aisa otaquiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Manatarite piquempejiacaroquea yoguijaantajitarica metojatsica, manaquea ipantantajitacaro quitamarori cameetsanijite iramenajiqueronijite ocameetsavaeque. Cotanquitsiquea intsompoguirequi chomisaaniquea iriguentiquea tseraiquicaroquea itonqui metojatsica icojotonquipiotanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ariqueate piquempejiacaquea aviatimpajia iroguenti picameetsatamampeajiaca intati cameetsanijite iramenajiaquempinijite caquintejia, cotanquitsiquea intsompogui pishirejiaqui mana pishatecanajiro amatavijagantsi aisa covaeguisherentsi. ");
INSERT INTO cotNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa aviatimpajia pariseojia, cameetsatamampeajiatsica! Iroguentiquea pipeacaashijiacanariquea inquenquejacotantajitajemparica tsavetantajiatsica metojajianquitsica coramanipaequitica, aisa pinetsanajiaqueneriquea yoguijaantajitarica comajamajajiatsica metojajianquitsica cameetsanijite inquenquejacojitajerinijite. ");
INSERT INTO cotNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ariquea picanquequea: ‘Arimequea nonchoocateme coramani ichoocatigueti choviquivaejianaquenaca aatomequea namijiguirime imetojajiaquerigueti tsavetantajiatsica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Oraqueate piquempejiaquerogueti imaica aviguenti quempetacaantanquitsi, picantajiaquetarite aviguentijia ichoviquivaejianaqueca metojajiaquerica, ari piquejejiacari. ");
INSERT INTO cotNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Iroosacanica pinteroncamajateroja ipariaguishecaca choviquivaejianaquempica! ");
INSERT INTO cotNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Quempevaequempi camaarini! ¡Quejejiaquempiquea irijanijiate sanatari! ¿Quero pincojiaquempani aatonijite pitsijaigatsi camorecariqui? ");
INSERT INTO cotNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Irootaquequea nontigaranquimotantajiaquempirica tsavetantajiguiroca icanquerica Aapani Irioshi, itsipajia caavijica itsajigui, itsipajia tsatacaantajiatsica. Cotanquitsiquea ari pimetojagarantajigueri pompajacogarantajigueri, itsipapae pintavatavajaigueri shinagogapaequi picapiocantapinijiacaca, pincatsimatashijianaquempari pimpatimajianaqueriquea iguintenipaequi. ");
INSERT INTO cotNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pinintacaajiaqueri irimetojajiaque comajamajajiatsica irootaquequea incatsimatimentantaquempiroca Aapani Irioshi quejetacaquea aviatimpajia quejetacaantajiaqueriquea imetojantajicarica tsaroventamajajigarica Aapani Irioshi coramanitica, iriquetinicaquea ipariajitacaca comajatatsica Averini icaratacaajivaequeriquea Sacarianiqui irijanite Verequiashini. Iriraquea Sacariani manaquea imetojajitaqueriquea ontaniqui oniganquirequi oticaacoroqui teemporo ichoocavetacagueti acaqueroca aretare itaantajitarica viratsipae. ");
INSERT INTO cotNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Arimajacaquea noncantajiaquempica, imaicashiatsi incatsimatimentajiaquempironishiatsi Aapani Irioshi aviatimpajia choocajianquitsica imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerosarequitica, Jerosarequitica, pimetojajiguiriquea tsavetantajiatsica, aisa pitsinatsinavaetaqueriquea itigaranquimojiavetaquempica Aapani Irioshi intsavetantimojiaquempiro Iguenquetsatsare! Pamenajiguiroquea chaapa osaavantajiguigueti orijanijiate, nonintaguevetacaquea naatimpa nonquempetacaajiaquempimequea maasano aviatimpajia noncapiocajiaquempimequeate pintsaroventajiaquena, cotanquitsiquea aviatimpajia teequea pinintajigueji. ");
INSERT INTO cotNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Imaicaquea imaica aatoquea ichoocatimojiajimpi Aapani Irioshi, aparoquea pinchoocajiaje. ");
INSERT INTO cotNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nocantajiaquempiquea imaica aatoquea pamenajiajana arejevaetapojajempaquea aapojajempagueti pincantajianaquetaquea: ‘¡Iintsishiatsi irishineventajiquempari iriratica coraquetapojatsica itigarancaqueca Majirontamajatatsica!’ ” ");
INSERT INTO cotNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ariquea isotoanajirogueti Jesoshi oticaacoroqui teemporo iroavaetanaje, iquempejiquempejiipojiriquea itsatacaanejia yamenacaaguequeri teemporo aisa tsipaguetacaroca. ");
INSERT INTO cotNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cotanquitsiquea iriraquea Jesoshi icantajiguiri: —¿Arite pamenajiaquero maasanopae ocatica? Iroomajatari noncanquempica, aatoquea ochoocatajitsi aparo mapi ogataajatsineca, maasanopae irisoveacomajajitaquero. ");
INSERT INTO cotNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iroompaquea isavicaquegueti Jesoshi Orivotsempiqui, ariquea iquempejiquempejiipojari itsatacaanejia, icantajiapojiri: —Nonintajiaque pintsatacaguena quero oncarateni onetsanatantaquempaca incajaranquitica picanquegueti irasacaraajitaquero. ¿Taa opaji nontsatantajiavajemparoca pincoraquetantapojajempaca aisa onteroncantaguetanaquempaca quepatsi? ");
INSERT INTO cotNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iriraquea Jesoshi icantajiguiri: —Shoshoh yamatavijajitimpitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Incoraquecoraqueitaquetari oshequini pinajajiaquenaneca cantajianquitsineca: ‘Naroguenti Quirishito’, ariquea iramatavijajiaqueri incaramirincatashivaetanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aisa pinquemacojiaqueriquea itsipajia irashimirintavacaajianaquempa quempeji, aisa itsipajia otsipapaequi guinteninintsipaequi, cotanquitsiquea aviatimpajia aatoquea pitsaroajiguitsi. Aritarite onquempetanaquempaquea imaica, cotanquitsiquea aatotaquea arejetsitatsi onteroncantaguetanaquempaca quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Iriraquea guintenijianquitsica otsipapaequi quepatsi iroaroaitashijianaqueriquea osamanipaequitica, ariquea irashimirintavacaajiaquempa. Ariquea inquempejiaquempa majirontajiatsica inchoocagarantajiaque intigarancajiaqueri igoaretajiate iroaroaitashijianaqueriquea itsipa majirontatsica irashimirintavacaajiaquempa. Irantsipevaejitaquemparoquea tasetsijencapae, aisa omoguecaguetanaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Onquempeguetanaquempagueti imaica mana oparianaca intati irantsipevaetantajitaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ariquea irajaiquempiquea iraanaquempi incatsimatacaantajiaquempiquea irimetojacaantajiaquempi. Maasanopae caquinteguetatsica irisemimentajiaquempiroquea novajiro pitsaroventajiaquenagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inconoagarantajiaquempaquea tsaroventajiavequenaneca irovashiantajianajero aato itsaroventajiajana, iroguenti iraacaantajianaqueriquea itsipavijivetacaca, irisemavacaajianaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Irisotoaguetanaquequea amatavijantanquitsineca incantamampeajiaquempaquea: ‘Notsavetantiro Iguenquetsatsare Aapani Irioshi’, cotanquitsiquea iriatimpajia manaquea iramatavijajianaqueri oshequini. ");
INSERT INTO cotNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oncantatiaguishevaetanaquempaquea oratica covaeguisherentsi, aato ipintsatantamajatanaja oshequini caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Cotanquitsiquea quericaca atsipetacovaetanquitsineca aatogueti yovashiantirotsi itsarovenquenagueti arejevaequempa irimetojanaje, irioquea iriguenti irajaitanaje inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Intsitacaguitejavaetanaquero quepatsi intsavetantajitanaqueroquea quero icotani Aapani Irioshi imajirontagueti. Ariquea inquempejiaquempaquea imaica cameetsanijite inquemacojiaquero maasano caquinteguetatsica, ariquea onteroncapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Iriraquea tsavetantatsica Iranierini coramani itioncacotaqueriquea covaeguishetaqueroneca teemporo oncoramanitapojajegueti. (Quericaca apatsajavanqueroneca ocatica pinquenquejamajateroja pintsatimenqueroniji.) Imaica aviatimpajia pamenajiavaquerigueti inchoocatantapojaquemparogueti iteemporote Aapani Irioshi, ");
INSERT INTO cotNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pincampojeja jaran maasano Joreajiaquitica pishiashiaitapanajantejate otsempiguecagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Quericaca choocatanquitsineca sotsiqui omencotapojacagueti itsovironaquitequi ovancaitoqui, aatoquea yaguijitapanajanti iraaguepanajantero taaca opajitapae choocatanquitsica intsompogui. ");
INSERT INTO cotNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Quericaca choocatanquitsineca iniganquitejirequi, aatoquea yoapanajanti itsovironaquitequi iraapanajantero otsipa iitsaare. ");
INSERT INTO cotNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ooshiatsi manquigarentsijia tsaraquijianquitsineca, aisa atsojianquitsineca, caaviji antsipemajajiaquempaquea! ");
INSERT INTO cotNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aviatimpajia pamanacoventajiaquempaquea aatonijite pishiamirincatantajigarotsi sharacaguiteriqui irooca aisa savincaguiteriqui imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Caavijitari irantsipevaejitaquempa anaavaequero maasanopae yatsipejitacaca iroaqueragueti ipeacaaguecarogueti Aapani Irioshi quepatsi arejevaeca imaica. Aisa aatoquea yamenimajitajirotsi oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aatomegueti icaratacaapojirome Amajirote oratica savincaguiteripae irantsipetantajiavetaquempaca interoncamajajiaquempamequea caquintejia. Cotanquitsiquea ipintsatacotacari icoguiajiaqueca, incaratacaantapojaquenemparica. ");
INSERT INTO cotNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Quericaca cantajiaquempineca: ‘Jeeri iricatica Quirishitotatsica’, irooca incanquempi: ‘Ichoocaque ontaniqui’, aatoquea piquemisantajiguiritsija. ");
INSERT INTO cotNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Incoraquecoraqueitaquequea tsavetantamampejaigatsica amatavijantajianquitsineca incanquequea: ‘Naroguentiquea Quirishitotatsica.’ Itsipaquea cantajianquitsineca: ‘Naroguentiquea tsavetantiroca icanquenaca Aapani Irioshi.’ Aisa ironigaanqueroquea oacaantantatsica intati cameetsanijite iramatavijajianaquerinijite oshequini. Inquejetacaajitsivetempariquea icoguiajiaqueca Aapani Irioshi, cotanquitsiquea aatoquea yagavejiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jero, nocamantsivaequempiro maasano ocatica imaica tequeratagueti arejepojempa. ");
INSERT INTO cotNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Incanquempigueti: ‘Jeeri irintatica oquitamampororoitapojigueti’, aatoquea poapoaititsi pamenamenaiquiteri. Aisa incanquempigueti: ‘Chooca oraniqui intsompoguiqui’, aatoquea piquemisantajiguiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Onquempetaquempaquea pamenajiguirogueti careti queroca ococani ocantigueti timemec, teequea capichajaniqui ontimemequeji, maasanoquea ontimemecaguitevaequero. Ariquea inquempetapojajempa irira Irijanite Caquinte incoraquepojajegueti, maasanojia iramenamajajiavajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Quempecaquea metojatsica querocagueti oraniqui yojoquijicagueti yamenajiqueriquea sheetyaoni irarampejashijiapojeri. ");
INSERT INTO cotNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Irooquea oncaraguijanaquegueti atsipevaerentsi impitsecajencatanaque catsirincaiteri, taai aato iquitasetaji. Iriraquea impoquiropae irasacaraaguetanaquempaquea. Irimoguecanaquempaquea choocaguetanquitsica jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ariquea iramenajitavaquero ontaniqui inquitequi intsatantajitavaquemparoca irooshimajapoji incoraquepojaque irira Irijanite Caquinte. Ariquea irishimampojancajianaquempa maasano caquinteguetatsica quepatsipaequitica iriraajianaquempa. Ariquea iramenajiavaqueri Irijanite Caquinte incoraquetantapojajemparo mararo, iragavejavaetapojempa iranaajiaqueriquea maasano, iroganejencavaetapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iroompaquea intivojiqueroquea tivorentsi intigarancajiaqueriquea irashivantijitete iroaroaitanaquequea intsitacaguitejajiaquitero maasanopae quepatsi incapiocajiaqueriquea icoguiajiaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Imaica pintsajiavaqueroja nontsatacaajiaquempica, nonquempetacaaquempiroja iguera. Iroaquerasano etsocorevanatanaque pitsajiaquequea irooshipojaji ajagantsipojaje. ");
INSERT INTO cotNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ariquea onquempetanaquempaquea oncoramanitapojajegueti pamenaguetavajerogueti onquempetanajempagueti maasanopae notsatacajaianaquempica imaica, irooquea pintsatantajiavajempa irooshipojishiatsi incoraquepojaje Irijanite Caquinte, quejetaca catiapojaca sotomorontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Arimajaca noncantajiaquempica, maasanopae ocatica nocantajiaquempica imaica onetsanamajatanaquempaquea tequeratagueti interoncajiguempaji maasano choocajianquitsineca omparianaquempagueti notsavetantsitacaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Oraquea inquite aisa quepatsi ompeaquempa, cotanquitsiquea oraquea nocantaguequeca aato opegatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Teequea inchoocateji tsatatsineca querocaca savincaguiteri onetsanatantaquempaca, tee intsajiteji quero incarateni catsirincaiteri. Irirajia ashivantijite inquitequitica tee intsajigueji, ariquea iquempetaca Irijanite Aapani Irioshi teequea intsateji. Aparoquea icocani Aapani Irioshi iriatimpa itsaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Oraquea incoraquetajategueti Irijanite Caquinte onquempetajemparoquea ichoocavecagueti Noeni coramani. ");
INSERT INTO cotNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tequeratagueti onanquempaji anaantaguetaquemparoca maasanopae quepatsi, ishecajiaca caquintejia, imirajiaca, imanquigajiaca, yojocantajiaqueroquea irorijanijiate omanquigajiaquempaquea, arejevaeca savincaguiteri iquijaquijaitantacaca Noeni iguenajaroqui icantajitica aareca. ");
INSERT INTO cotNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iroompaquea ocomitajajiapojiri anancari ocataroajianaqueri. Ariquea onquempetaquempa oncoramanitapojajegueti incoraquetapojajegueti irira Irijanite Caquinte, manatarite incomirejajiapojeri. ");
INSERT INTO cotNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Inchoocajiaque mavite caquinte iniganquitejirequi, aparo irajaitanaque, iriraquea itsipa irojocajitanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ariquea onquempejiaquempaquea mavite manquigarentsi osavicajiaque ontoncajiaque, aparo irajaitanaquero, oraquea otsipa irojocajitanaquero. ");
INSERT INTO cotNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Irootaquequea noncantantajiaquempica pincoquempanija poguijajiavajerija Pimajirote, teetarite pintsajigueji querocaca incoraquetantajempaca. ");
INSERT INTO cotNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iintsijate pinquenquejajiguerojate, inchoocategueti itsipa ashintanquitsineca itsovironaquite intsatemegueti querocaca incoraquetantaquempaca aitsitantatsica, ¿arimpate irimaaque? ¡Aatotarite imaguitsi! Manaquea intinajaventaguiteroni irajaararo aatonijite yaitsijitiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Irootaquequea noncantantajiaquempica pincoquempanija pincomajamajajiaquempa poguijaguiterini incoraquetajegueti irira Irijanite Caquinte, iroorijite incoraquetantajemparo pijijiaqueca aatoca icoraquetantaro. ");
INSERT INTO cotNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Querija quempequemparineca imaica yashintacaca irira tsatatsica quemisantamajatirica ashincarica? Pameneja inchoocategueti ashincarica caquinte iroompaquea iroanaquegueti osamani, incantanaqueri aparo yashincaca: ‘Pinquempoguijajiajeri maasano nashintajiacaca, pojocapinijiaquenerija ishecajia.’ ");
INSERT INTO cotNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Oraquea incoraquepojajegueti iramenapojajerigueti inetsanamajatajiro icantanaquerica, arimpaquea irishineventamajatanaquempariquea. Arimajaca noncanquempi, incampojajeri: ‘Imaica noninquequea pamenaguetaqueroquea maasanopae nashincaca.’ Ariquea iriatimpa irishinevaetanaquempaquea oshequi. ");
INSERT INTO cotNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Cotanquitsiquea iriogueti teeca inquemisanteji, aatoquea yoguijiritsi ashincarica manatarite incanque: ‘Aatotajate icoraquetsitaja’, ");
INSERT INTO cotNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ariquea imparianaquemparo incatsimajianaqueriquea quejejiacarica yashintajitacaca, inconoajiaquempariquea shinquitatsica manaquea irisavicaventaguiteroni irishecaguitempani, aisa irishinquiguitempani. ");
INSERT INTO cotNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cotanquitsiquea taampina incoraquetimopojajeri ashincarica incomirejapojempari, ");
INSERT INTO cotNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","incatsimamajapojajeri oshequi, intsipatacaantajiaquempariquea quemisantamampeajiatsica intati, ontaniquiquea iriraaguitempani irantsicayajijiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Imaica nonquejetacaaquemparoquea quero oncoquempani irimajirontaquempagueti Inquitequitica aapojempagueti notsavetantsitacaca. Manaquea onquempejiaquemparo 10 manquigarentsijia iroaqueraca quenquevaroguetananquitsi. Iroatimpajia amajiaque otsivorepae oahoaitanaque ontonquivotonquivoiquempari manquigatanquitsineca. ");
INSERT INTO cotNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ocarajiaque 5 teeca onquenquejamajajigueji, otsipa 5 quenquejamajajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Iroatimpajia teeca onquenquejamajajigueji amajiaveca otsivorepae, cotanquitsiquea teetarite aajianaqueji ashitite oganencajatantanaquemparica coajica interoncanaquempagueti. ");
INSERT INTO cotNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Oraquea quenquejamajajianquitsica iroguenti amajiaque itsipataco. ");
INSERT INTO cotNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iroompaquea oguijaveguitarini teetatarite incoraquetsitempaji manquigatanquitsineca, ocantanaca pochoquini ojocajianacani tin. ");
INSERT INTO cotNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Iroompaquea onianquiitevaetapojaquegueti oquemitsitariquea icajemajencajitaque: ‘¡Coraquetapojaque manquigatanquitsineca, poapoaiteshiatsi pintonquivojajiavaquempariquea!’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ariquea ocojianaca ocatiajianaca maasano aitsijiavetanaca otsivorepae. ");
INSERT INTO cotNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oraquea teeca onquenquejitsitempariji ashiti ocantsivetaroquea quenquejajianquitsica: ‘Pojocagajoitenashiatsi capichajaji pashitite irootapojishiatsi nontsivacacotenishiatsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Cotanquitsiquea iroatimpajia ocanqueroquea: ‘Aatoshinete nojoquimpitsi. Arigueti nojocajiavequempigueti manaquea anteroncajatacotsijianaquempaja taampina maasano. Poapoaitanaquequea pivegarajiapanajante pashi aviatimpa itsipajato.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cotanquitsiquea irooquea oahoaivetanaca ovegarajiapanajante jac arejetapojaca manquigatanquitsineca. Oraquea quenquejamajajianquitsica amajianquitsica ashitite oquijaquijaitanaque intsompoguiqui otsipatsipaitanacari irishineventajiaquemparigueti, ariquea ocotanaca yashimajajitajiro ashitacorontsi. ");
INSERT INTO cotNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ariquea ocoraquecoraqueitsivepojaca otsipavecaca, ocanquequea: ‘¡Nomajirote, nomajirote, intsija pintanarejacotenashiatsi!’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Cotanquitsiquea iriatimpa icantajiguiro: ‘Teetarite nontsamajajiguempiji cameetsanijite nontanarejacojiaquempinijite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Irootaquequea imaica noncantantajiaquempica pincoquempaniquea pincomajamajajiaquempaja, teetarite pintsajigueji querocaca incoraquetantapojajempaca Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Imaica nonquempetacaaquemparoquea imajirontagueti Inquitequitica, manaquea nonquempetacaaquempari caquinte ashintajiacarica caraquisequitirica imentaqui. Irooshipoji iroanaquequea otsipaqui quepatsi icajemajiaqueri irashijia irojocajianaqueneri imentaquipae iroganencajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iriraquea aparo yojoquitanariquea 5 imontiina imentaqui. Iriraquea itsipa yojocaqueneri mavimontiinate. Iriraquea mavitevaetapojatsica yojocaqueneri apamontiinaro. Itsaqueritari maasano yashintajiacaca queri agavejamajatanquitsineca aisa teeca iragavejamajateji. Ariquea yoavaetanaque jmm osamani. ");
INSERT INTO cotNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iriraquea yojocanaquenerica 5 imontiina yoganencajiriquea itsipa 5 imontiina. ");
INSERT INTO cotNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ariquea iquempetacari itsipa yojocanaquenerica mavimontiinate, yoganencajiri itsipa mavimontiinate. ");
INSERT INTO cotNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cotanquitsiquea iriraqueate yojocanaquenerica apamontiinaro, manaquea yoanaque iquisocashitaqueri quepatsiqui yoguijaitari. ");
INSERT INTO cotNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ocoramanivaetapojaji anaanaaguetanaca oshequini taai icoraquepojaji ashintajiacarica icantajiapojiri: ‘Jameja amenajiajeri imentaqui querocaca icaramontiinatanaqueni.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iriraquea yojocanaquenerica 5 imontiina yojoquitsitajanariquea, itsipatacaantacari itsipa 5 imontiina imentaquipae yaancarica, icanqueriquea: ‘Nomajirote, ari pojocavetanaquena 5 imontiina, jeri iricatica itsipa 5 imontiina naantajarica pimentaquitsite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iriraquea ashincarica icanqueri: ‘Cameetsavaeque, pinetsanamajaqueroquea nocanquempica, piquemisantamajataquena. Pinetsanatavaquerotari nocantavequempica capichajaniqui, imaicaquea aviguenti quempoguijenarone oavaetanaque. Pincoraquetequetiro ashinevaejiaquempa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Iriraquea itsipa yojocanaquenerica mavimontiinate yojoquitsitajanariquea, itsipatacaantacari itsipa mavimontiinate imentaquipae yaancarica, icanqueriquea: ‘Nomajirote, ari pojocavetanaquena mavimontiinate, jeri iricatica itsipa mavimontiinate naantajarica pimentaquitsite.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iriraquea ashincarica icanqueri: ‘Cameetsavaeque, pinetsanamajaqueroquea nocanquempica, piquemisantamajataquena. Pinetsanatavaquerotari nocantavequempica capichajaniqui, imaicaquea aviguenti quempoguijenarone oavaetanaque. Pincoraquetequetiro ashinevaejiaquempa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Iriraquea mavitevaepojatsica yojocanaquenerica apamontiinaro icanqueri ashincarica: ‘Nomajirote, namenimpiquea aviguenti teequea pimpintsatacotantempaji, aisa aviguenti caavijica patsipetacaantavaetaca pishiacotacaantigueti paanquempaca caraquisequi imentaqui. Aisa manaquea poganencaqueri imentaqui intati teequea pishiacotimenteriji. ");
INSERT INTO cotNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Irootaquequea notsaroacaanquempica noantanacaca noquitatantacarica pimentaquitsitepae quepatsiqui. Imaica jeri iricatica pimentaquitsitepae.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iriraquea ashincarica imentaquitsite icanqueri: ‘Teequea pincantempaji, aviguenti peratatsica. Iroosacanica pitsaquena natsipetacaantavaetaca noshiacotacaantigueti naanquempaca caraquisequi imentaqui, aisa manaquea noganencaqueri imentaqui intati teequea noshiacotimenteriji. ");
INSERT INTO cotNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Querocaquea ocotacani teequea pojoqueneriji nomentaquijiatsite quempoquijantaguetirica paantajemparimequeate itsipajia, iroompaquea nocoraquevetajagueti imaica pojocavajenarimequea?’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ipitsocashijigariquea choocajianquitsica oraniqui icanqueri: ‘Paapitsaterishiatsi iricatica apamontiinaro imentaqui nojocavecanarica pojocajigueneri oganencaquerica 5 imontiina. ");
INSERT INTO cotNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Caavijitari irojocamajajiqueneri quericaca ganencamajataquerica, cotanquitsiquea iriraquea teeca irashintamajatempaji, capichajitica yashintaveca iraacaitsijitaquempariquea. ");
INSERT INTO cotNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Imaica iricatica nashincaca teeca inquemisantenaji paajianaqueriquea pimpishoncajiaquiteri sotsiqui opitsecaquegueti intsipatsipaitaquempariquea iraajianquitsica atsicayajijianquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Oncoramanitapojajegueti incoraquetajegueti Irijanite Caquinte iroganejencavaetapojempa intsipatsipaitaquempari irashivantijitete Aapani Irioshi, irisavicapojero imajirontamento oganejencari irimajirontamajapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Intirorencaventajianaquempari maasano caquinteguetatsica. Iriatimpa iromporoguijashiguequempari inquempetacaajiaquempari quempoguijirica oveja yomporoguijashiguetarigueti irovejate aisa igaaverate. ");
INSERT INTO cotNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iromporoguijashitaquempari ovejajia itincamijempequiqui, aisa caaverajia iromporoguijashitaquempari ishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Iriraquea Majirontatsica incantajiaqueri choocajianquitsica itincamijempequiqui: ‘Caacate, aviatimpajia icavintsajamajajiaqueca Aapani. Pashintajiaquemparoquea maasanopae ipeacaajiaquempica paesatoniqui iroaqueragueti ipeacaacarogueti quepatsi, aviatimpajia inintacaajiaquempiro incavintsajajiaquempiquea. ");
INSERT INTO cotNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iroorijite natsipevaetacarogueti notase aviatimpajia pojocajiaquenaquea noshecatacaca. Nomirevaetigueti pojocajiaquenaquea nomiracaca. Noquenaguetanaquegueti teequea pintsajiavetenaji, picajemajiavaquenaquea pitsovironaquitequi nomaimojiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Teequea onchoocavetempaji nonquitsaaquempaca, aviatimpajia pojoquitanaroquea noquitsaacaca. Nojoquijicagueti aviatimpajia pipintsatacojiaquenaquea pamenajiaquitana. Aisa isantanatacojitanagueti picoraquejiajati.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iroompaquea iriraquea comajamajajianquitsica icanqueriquea: ‘Nomajirote, ¿querocate namenajiaquempini pitaseaqueni nojocajiaquempi pisheca? ¿Querocate namenajiaquempini pimirequeni nojocajiaquempi pimiracaca? ");
INSERT INTO cotNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Querocate namenajiaquempini piquenaguetanaqueni nocajemajiaquempini pimaimojiaquena? ¿Querocate namenajiaquempini picajaratsinotigueti nojocajiaquempi piquitsaacaca? ");
INSERT INTO cotNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Querocate namenajiaquempini pojoquijicagueti, aisa isantanatacojitaquempigueti noanoaitaquiti namenajiajatimpi?’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Cotanquitsiquea icanquequea Majirontatsica: ‘Arimajaca noncanquempi, pipintsatacojiacarigueti aparo iricatica niguentijeguite teeca iranaanteji, quempeca naroguentica pipintsatacotaca.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aisa icanqueriquea yomporoguijajiaqueca ishinampijempequiqui: ‘Imaica aviatimpajia icatsimajiaqueca Aapani, poapoaitanaque ontaniqui camorecariqui aatoca otsivaquitsi ipeacaashijicarica Satanashi aisa ashivantinirojite quemisantaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Natsipevaecarogueti notase teequea pojocajiguenaji noshecajiaquempaca. Nomiretigueti teequea pojocajiguenaji nomiraqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Noquenaguetanaquegueti teequea pincajemajiguenaji pitsovironaquitequi nomaimojiguempiji. Teegueti onchoocateji noitsaare teequea pojocajiguenaji nonquitsaaquempaca. Nojoquijicagueti, aisa isantanatacojitanagueti, teequea pimpintsatacojiguenaji pincoraquetashijiguenaji.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iriatimpajia incanqueriquea: ‘Nomajirote, ¿querocate namenajiaquempini pitaseaquegueti, irooca pimirequeni, aisa piquenaguetanaquegueti, irooca picajaratsinoquegueti, irooca pojoquijicagueti, aisa isantanatacojiquempigueti, teequea nompintsatacojiguempiji?’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iriatimpa incantajigueriquea: ‘Arimajaca noncantajiaquempi, teetari pimpintsatacojiguempariji iricaticajia teeca iranaanteji, quempeca naroguentica teeca pimpintsatacojiguempaji.’ ");
INSERT INTO cotNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Maasano irirajia iroaroaitanaquequea camorecariqui irantsipeventaguitemparoni igovaeguishere. Cotanquitsiquea iriraquea netsanajiguiroca inintica Aapani manaquea iroaroaitanaque inquitequi, incoguitempani iranijaguiteni.” ");
INSERT INTO cotNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iteroncaquerogueti Jesoshi itsatacajaiaquerigueti itsatacaanejia, icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Aviatimpajia pitsajiaque mavitetapojaque savincaguiteri aapojempaca Paashicoa. Irooquea iraacaantantajitaquemparica Irijanite Caquinte irompajacojiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ariquea icapiocajiaca itsoviaguiteritequi Caipashi maasano saserorotejia anaantajianquitsica, tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa jivajiguirica joriojia. Iriraquea Caipashi iriguenti saserorote anaantamajatanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ariquea oraniqui iquemavacaajiaca iramatavijajiaqueriquea Jesoshi iraacaantajiaqueri irimetojacaantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Cotanquitsiquea icantajiaque: —Oraquea anaanajempagueti Paashicoa ariquea aacaantajiaqueri. Imaicaquea imaica aatotaja aacaantajiguiritsi aatonijite icatsimatacojianaqueritsi maasano capiocaventajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iroompaquea yoanaque Jesoshi Vetaniaqui itsovironaquitequi Shimo icantajitica Avejancavetatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ichoocaquegueti ontaniqui ocoraquetashipojiri manquigarentsi amacoqueri poncajajatatsica vegaramajatatsica. Iroguenti yoguijaantajicaro chovintyoriqui ipeacaajitaca mapi icantajitica aravasetero. Isavicaquegueti Jesoshi ishecajiaca, iroatimpa oquempejitapojacari oshaguitsitantapojacari ishinquireguishiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iriraquea itsatacaanejia irooquea yamenajiavaquerogueti ariquea icohicoitanaca icatsimajianaque, icantavacaajianaca: —¿Querocaquea? Opomatsajatacashiatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Arimesanoja irojocantajiquerome iraantajiquemparo imentaqui incaraquisequivaeque irojocajiquenerimequea coguitejacojianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Cotanquitsiquea Jesoshi irooquea iquemajiavaquerigueti icantsitariquea: —Ariotaqueshiatsi ococani pasereajiguirotsi. Cameetsavaeque oshaguitanquenaro. ");
INSERT INTO cotNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iriraquea coguitejacojianquitsica icancaniquea pintsipatsipaitajempari, cotanquitsiquea naatimpa aatotarite picocani pitsipatsipaitajanatsi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Oraquea oshaguitsinotsiquenagueti manquigarentsi, manaquea onetsanatsitacaro irojoquijijitajatenagueti nometojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Imaica noncamanquempiquea arimaja querocagueti intsavetantajiqueroni Quenquetsatsarentsi Oganejencatatsica maasanopae quepatsipaequi, ariquea intsavetantajiqueroquea ocatica manquigarentsi oshaguiquenagueti cameetsanijite inquenquejacotimentajitajeronijite iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iroompa iriraquea itsatacaane Jesoshi pajitatsica Jorashi Ishicariote yoanaque iramenajiaquiteri saserorotejia anaantajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Icantajiapojiri: —¿Queroca incaravaequeni imentaqui povegarajiaquenaquea naacaantantajiaquempirica Jesoshi? Iriatimpajia yojocajiaqueneriquea 30 peratamentaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iroompaquea yoanajiquea ariquea ipariapojaro iquenquejanaquero querocaca incoquerini iraacaanquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Iroompaquea aapojacagueti savincaguiteri pariantajaroca savincaguiteripae ishecatantajitaroca pan teeca onconoguemparoji anempoacaanaqueroneca, iriraquea itsatacaanejia icoraquetashijiapojiri Jesoshi icanqueri: —¿Querocaquea pininqueni nonetsanajiaquempironi maasanopae cameetsanijite ashecajiaquempanijite coajica ashineventajiaquemparo Paashicoa? ");
INSERT INTO cotNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iriatimpa icanqueri: —Pijateja, poapoaitanaque shirampariqui Jerosarequi pincantajiapojerija: ‘Iriraquea Tsatacaantantatsica icanque: Irootapoji arejetapojempa nocoraquetashitaqueca, irootaquequea nonintantacaca noshecatacaajiaquempariquea notsatacaanejia pitsovironaquitequi noshineventajiajemparo Paashicoa.’ ");
INSERT INTO cotNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ariquea yoayoaitanaque itsatacaanejia itampaticamajajiaqueroquea icantajiavaquerica Jesoshi, inetsanajiaqueroquea maasanopae irishecajiaquempaca irishineventajiaquemparoniji Paashicoa. ");
INSERT INTO cotNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iroompaquea opitsecaguitetanajigueti iriraquea Jesoshi itsipatsipaitanacari itsatacaanejia carajianquitsica 12, ipimerequijajiapojaca shitaponcarontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ariquea ishecajiacagueti icanqueriquea Jesoshi: —Imaica noncamantaquempi, iconoaquempiquea aviatimpajia aparo aacaantenaneca. ");
INSERT INTO cotNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ariquea icohicoitanaca itsatacaanejia ishimampojancajianaca, yacayacaitanaque: —Nomajirote, ¿naroguentimpa aacaanquempineca? ");
INSERT INTO cotNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Icanque Jesoshi: —Iriguenti aacaanquenaneca tsipavacoquenaca notsiantancarogueti pan shovaoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aritarite ontampaticamajatanaque ocanqueca tioncanquitsica coramani itsavetacotsijicarigueti Irijanite Caquinte, cotanquitsiquea ¡irantsipevaetempanishiatsi irira aacaanquerineca! Aatomesano ivoguime iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Icantsitanacaquea Jorashi aacaanquerineca: —Tsatacaantantatsica, ¿naroguentimpa aacaanquempineca? Icanqueri Jesoshi: —Aviguentitari cantanquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iroompaquea ishecajiacagueti, yaaqueroquea Jesoshi pan, yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea icotarejitsitaroquea yojocajiaqueneri itsatacaanejia, icantiriquea: —Paajiavaqueja pishecajiavaquemparo. Iroguenti notsino. ");
INSERT INTO cotNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iroompa yaacoqueroquea chovintyoriqui, yamanajiri aisa Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea yojocacojiaqueneriquea itsatacaanejia, icantiri: —Jero pimirajiavaquemparoja, maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iroguentiquea noriraja sotojaatananquitsineca nometojaventajiaquerigueti caramirincavaetananquitsineca impeacotajemparonijite Aapani Irioshi igovaeguisherejia. Ocantacoqueroquea iroaqueraro paaquito. ");
INSERT INTO cotNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Imaica noncanquempiquea, aatoquea nomirajaro vinoja arejevaetapojempa amiramiraitajemparo iroaquerajaro oncoramanitapojajegueti impeaquempagueti Aapani Imajirojiate maasano. ");
INSERT INTO cotNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iroompaquea iteroncajianaquerogueti yamashaiventajiaquerigueti Aapani Irioshi, isotosotoitanaji yoayoaitanaque Orivotsempiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ariquea icanqueri Jesoshi: —Ocatica pitsecanquitsica maasano aviatimpajia pimpashiventacaajiaquenaquea pojocajiapanajantena. Aritarite ocanque Itioncacaantaqueca Aapani Irioshi coramani, ocanque: ‘Aapojempagueti nometojaqueri quempoguijirica oveja. Iriraquea ovejajia imporocajencatesano maasano.’ ");
INSERT INTO cotNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cotanquitsiquea iroompaquea nontancorejanajegueti naroquetiquea jivatanaquempine noanaquequea Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Icanquequea Peerero: —Impashiventacaajiavetanaquempiquea maasanopae irojocajocaivetanaquempi, cotanquitsi naatimpa aatotarite nojoquimatimpitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Cotanquitsiquea Jesoshi icanqueri: —Noncamanquempiquea, coajica tequeratagueti irinijeji chaapa, pomanacoquenaquea 3. ");
INSERT INTO cotNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Icantsitanaca Peerero: —Ariguetija intsipatacaantajitenajate irimetojajiquena irimetojajiquenaquea, cotanquitsiquea aatotarite nomanacotimpitsi. Ariquea iquempejiaquero maasano itsatacaanejia icantajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iroompaquea yoayoaitanaquequea Jetsemaniqui. Irooquea yarejerejeipojacagueti iriraquea Jesoshi icanqueri itsatacaanejia: —Pisavisaviitetaja ocaniqui, naatimpa noanaquetajate ontaniqui namanaquiterita Aapani. ");
INSERT INTO cotNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iriguenti itsipatsipaitanaca Peerero aisa mavite irijanite Severeo. Ariquea ishimampojancavaetanacaquea Jesoshi, yatsipeshirentavaeca. ");
INSERT INTO cotNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Icanqueriquea: —Noshimampojancavaetatiganimaja irooshipojishiatsi ometojavaetenanishiatsi, picancanija ocaniqui pintinajaventajiaquena. ");
INSERT INTO cotNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iriatimpa yoanaque tiijacoñajisano ontaniqui igueroncasetapojaca yamananaqueriquea Iriri icanque: —Aapani, nonintavecaquea paapitsatenarojate nantsipequempaca, cotanquitsiquea teequea nonintenica onetsanaquempa nonintica naatimpa, iroguentiquea pinintica aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ariquea yoanaji ichoocajiaquegueti itsatacaanejia, yamenajiapojiri yojocanacani tin. Icantapojiri Peerero: —¿Arimpate teequea pagavejajigueji osamanicoñaji pintinajajigueji pintsipajiaquename? ");
INSERT INTO cotNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pintinaje, aatoquea pimaajiguitsi. Pamanacoventajiaquempaja aatonijite ocovaeguishetacaajianaquempitsi covaeguisherentsi. Aviatimpajia pinintajiaveca pishirequi pinetsanamajajiaquero inintaguetica Aapani Irioshi, cotanquitsiquea teetarite pintampishijigueji pitsinoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ariquea yoitsitanaja aisa yamanajiri Iriri, icanqueri: “Aapani, aatogueti agaveji opega aatoniji natsipetaro, iintsija onetsanaquempa pininqueca.” ");
INSERT INTO cotNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ariquea icoraquevetapojaja aisa yamenajiapojiri yojocajianacani aisa tin, otiavaetanacaritari pochoquirentsi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yojoquitsijianajariquea aisa, yoitsitanaja aisa yamanajiri Iriri, irootaque icanquitirica incajaranquitica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iroompaquea iteroncanaquerogueti yamanaquerigueti, icoraquetapojaji ichoocajiaquegueti itsatacaanejia, icantajiapojajiri: —Arisacanica picantacoguitani maaguitatsimpi magorejajianaquempi. Arejetapojaca iraacaantantajitaquemparica Irijanite Caquinte irimetojajiaqueri covaeguishejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pincatintiitanaque, jamequetiro, jac coraquetapojishiatsi aacaanquenaneca. ");
INSERT INTO cotNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Quenquetsatanatsitiraja Jesoshi, yarejetapojaca Jorashi, irioveca itsatacaane carajiavetanquitsica 12. Yamamirincatapojaqueri caquintejia itigarancajiaqueca saserorotejia anaantajianquitsica aisa jivajiguirica joriojia, yamashijiapojiri itsaampitsantsameniritepae aisa inchaquiji. ");
INSERT INTO cotNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iriraquea Jorashi, aacaanquerineca Jesoshi, itsatacaitanacari iroaqueragueti, icanqueri: —Quericaca nonintavorotapojaqueca, iriotaquequea pinintajiaqueca, paajianaqueriqueate. ");
INSERT INTO cotNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iroompaquea yarejetapojatiga iquempejitapojacari Jesoshi, icantapojiri: —Tsatacaantantatsica, arisa pichoocataji. Ariquea inintavorotsitari. ");
INSERT INTO cotNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Icantsitariquea Jesoshi: —Notsipavijitaca, iintsijate pinetsanaterote picoraquetashiqueca. Iroompaquea iriraquea tsipatsipaitanacarica Jorashi iquempejiquempejiipojiri Jesoshi, yaitsitapojacari yajiriquitsitari. ");
INSERT INTO cotNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Cotanquitsiquea chooca aparo itsipatacaca Jesoshi yaitsitanacaroquea itsaampitsantsamenirite, itsopajitaro, iguempitarejitsitari yashintacaca saserorote anaantamajatanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Cotanquitsiquea Jesoshi icanqueriquea: —Poguijaajerojate pitsaampitsantsamenirite. Quericaca avencaroca itsaampitsantsamenirite manaquea irimetojantsijitempariquea tsaampitsantsameniri. ");
INSERT INTO cotNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Arimpate tee pintsateji naromegueti nintanquitsineme noncantanaquerime Aapani intigaranquimojiaquenarimequea irashivantijitete incaramirincavaeque incanquempa irompejianaquenamequeate? ");
INSERT INTO cotNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Cotanquitsiquea arimegueti nonquempetacaaquemparomequea imaica, ¿querocaquea oncoquempani onetsanatantanaquempaca Itioncacaantaqueca Aapani Irioshi coramani otsavetacotsiquenagueti onquempetaquempa imaica? ");
INSERT INTO cotNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iroompaquea Jesoshi ipitsocashijigari capiocajianquitsica, icanqueriquea: —¿Arimpate naroguenti catsimari aapitsatantatsica pamashitantajiaquenaca tsaampitsantsameniripae aisa inchaquiji paimentajianaquenanijite? Nocantacoguitanitari savincaguiteriqui notsipaguitimpini aviatimpajia ontaniqui oniganquirequi oticaacoroqui teemporo notsatacaantaguitini, teequea paajiguenaji. ");
INSERT INTO cotNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Cotanquitsiquea oquejetantanacaca imaica cameetsaniji onetsanamajatanaquempaniji itioncacojiaqueca tsavetantatsicani coramaniqui itsavetacotsijiaquenagueti. Iroompaquea maasano itsatacaanejia, itsinampirejajianaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Irirajia aajiaquerica Jesoshi yaajianaqueriquea Caipashiniqui. Iriatimpa iriguenti saserorote anaantamajatanquitsica. Ariquea ichoocajiaque oraniqui tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa jivajiguirica joriojia, icapiocajiaca. ");
INSERT INTO cotNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Iriraquea Peerero yoguijatacovetanacari cotanquitsiquea impoivaetapojaque. Oraquea yarejetapojacarogueti pampatejijaniquiqui itsovironaquitequi saserorote anaantamajatanquitsica, iquijapojaque otantoqui, yamenajiapojiri coaretajia quempoguijajiguiroca teemporo, savisaviitaque oraniqui. Ariquea isavicapoji iriatimpa iramenacotimentavaqueriniji Jesoshi querocaca incojitaquerini. ");
INSERT INTO cotNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iriraquea saserorotejia anaantajianquitsica itsipajiacari maasano majirontajiatsica icajemacaantajiaqueri itsipapae tsojeventajiaquemparineca Jesoshi cameetsanijite onchoocaquenijite ompampiatantapojempaca irimetojantajitaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Icoraquecoraqueivetapojaca yoshequiavetaca tsojeventajiaquemparineca, cotanquitsiquea irooquea icanque irooquea icanque, querocampate incojiaquerini, teenicate onchoocatenica. Iroompaquea icoraquecoraqueipoji mavite, ");
INSERT INTO cotNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","icanquequea: —Naatimpajia noquemajiaqueri icanque: ‘Naatimpa nagavejaque nosoveaquero iteemporote Aapani Irioshi, ariquea nompeacaitajemparo, ontrespojajegueti savincaguiteri nontsitacantajemparo.’ ");
INSERT INTO cotNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ariquea icatiitsitanaca saserorote anaantamajatanquitsica, icanqueriquea Jesoshi: —¿Aatompa paquiri? ¿Taaquea opajita ocatica icantacojiaquempica iricajia? ");
INSERT INTO cotNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Cotanquitsiquea Jesoshi teequea incanteji. Icantsitajari aisa: —Aatotarite pamatagatsi, inquemavaquempitari Aapani Irioshi anijatsica. Iintsijate pincamantenajate arimajagueti aviguentica Quirishitotatsica, Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Icantsitanacaqueate Jesoshi: —Pitampaticataquero. Jero aisa noncamantajiaquempi: oncoramanitapojajegueti pamenajiaqueriquea Irijanite Caquinte irisavicaque itincamijempequiqui Agavejamajatatsica. Aisa pamenajiavajeri inquenapojaje mararoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ariqueate icotanaca icatsimatanaque saserorote anaantamajatanquitsica, iperejitsitanacaroquea iitsaare sarararara, icanque: —Iricatica manaquea iquejemanatanacariquea Aapani Irioshi. ¿Arimpate ancoguimenquempari itsipapae cantacoquerineca? Jac piquemajiaquerishinete iquejemanatanacarigueti Aapani Irioshi imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Iintsija ¿querocaca pincantajigueni aviatimpajia? Iriatimpajia icanquequea: —Iquempetacaantaca, irimetojetashinete. ");
INSERT INTO cotNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iroompaquea iquishoquishoavaetaqueriquea ivoroqui, icapocapovaetaqueri, aisa yapatompatovaequeri, ");
INSERT INTO cotNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","icantajiaqueriquea: —¡Iintsijate, Quirishitotatsica, pintsatavaqueja taaquea capojaquempi! ");
INSERT INTO cotNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iriraquea Peerero choocatiraja ichoocaque ontaniqui pampatejijaniquiqui. Iroompaquea ocoraquepojaque aparo yomperajitaca ocanque: —Aviatimpa aisa itsipapinitimpi Jesoshi Garireaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yomanacotanacaquea, icanquero: —Tee notsatsitavaquempiroji. Iquemitsijigariquea maasano choocajianquitsica oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ariquea yogaitsivetanaja ontaniqui sotomorontsiqui amenitsitajariquea aisa otsipa manquigarentsi, ocantsijigariquea choocajianquitsica oraniqui: —Iricatica irio itsipavijire Jesoshi Nasarequitica. ");
INSERT INTO cotNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yomanacotsitajaroquea, icanque: —¡Teequea nontsateriji irintatica! Namataacagueti incatsimatimentenarotashia Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Incajaranquiguitetanajatigui iquempejiquempejiipojiri choocajianquitsica oraniqui, icantapojaqueriquea Peerero: —Arimajaca piquejegonoroncari noquemitajiavaquempirotari piquenquetsaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iriraquea Peerero icantsitanaja aisa: —¡Nocanqueshinete tee nontsatimateriji! Namataacagueti incatsimatimentenarotashia Aapani Irioshi. Icanquitigui, inijanaquequea chaapa. ");
INSERT INTO cotNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iquenquejitsitanacaroquea Peerero icanquerica Jesoshi incajaranquitica: “Tequeratagueti irinijeji chaapa, pomanacoquenaquea 3.” Icatiitsitapanajantaquea isotoapanajanti, iraitsitanacaquea ishimampojancamajatanaca. ");
INSERT INTO cotNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iroompaquea osavincaguitetanajigueti maasano saserorotejia anaantajianquitsica aisa jivajiguirica joriojia iquemavacaajiaca querocaca incojiaquerini Jesoshi irimetojacaantajiaquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iroompaquea yoishojianaqueri, yaajianaqueneriquea Pontsio Pirato yojocajiapojaqueneri. Iriatimpa iriguenti itigarancane Sesa, quejemajirovetacarica. ");
INSERT INTO cotNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ariquea iriraquea Jorashi, aacaanquerica Jesoshi, itsaquegueti arimajaca irimetojacaanqueri, ishimampojancaca iquenquejitsitanacaro: “Aatomesanoja naacaantirime”, yoanaquequea ichoocajiaquegueti saserorotejia anaantajianquitsica aisa jivajiguirica joriojia, irojocajiajenerimequea iriratica 30 peratamentaqui, ");
INSERT INTO cotNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","icantajiavepojari: —Nocovaeguishemajataca, naacaantaqueritari teeca incovaeguishetimatempaji, imaicanishiatsi irimetojajiterinishiatsi. Cotanquitsiquea iriatimpajia icantajiavaqueri: —Jmm. Avirosate quempetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ipishoncamirijaquipanajantiri intati imentaquitsite oraniqui intsompoguiqui teemporoqui, isotoapanajanti. Yoanaque itsatotsita. ");
INSERT INTO cotNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Iriraquea saserorotejia anaantajianquitsica icapiocamirijaquitajiri, icanquequea: —Icantimentantajitirotari anconoavoncaquitavajerigueti yamajiaqueca itsipapae yojocajitinirica Aapani Irioshi, iriotaquetari ivegaratsitantacarica irimetojaquenijite. ");
INSERT INTO cotNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iroompaquea iquemavacaajiaca irivegaratantajiajemparoquea quepatsi pajitatsica Iguepatsite Peacaaguetaroca Chomopae cameetsanijite onchoocaquenijite inquitatantajitapinitemparica quenaquenaitapojanquitsineca osamanipaequi. ");
INSERT INTO cotNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Irootaquequea opariantanacaca oratica quepatsi opajitancaca Irajantsiguite arejevaecaquea imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Oquejetacagueti imaica, onetsanamajatanaca icanqueca coramani tsavetantatsica Jeremiashini, icanque: “Iriraquea ishiraerijia iquemavacaajiaca irojocajiaqueneri aacaanquerineca 30 peratamentaqui, ariquea yaajiaqueri iriratica imentaquipae ");
INSERT INTO cotNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ivegaratantajiacaroca quepatsi pajitatsica Iguepatsite Peacaaguetaroca Chomopae, irootaquetari icanquenaca Nomajirote.” ");
INSERT INTO cotNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iriraquea Jesoshi icatiimotapojacari quejemajirovetatsica, icoacotavaqueri: —¿Arimajaca aviguenti Imajirote jorio? Icanque Jesoshi: —Tampatica poaquero. ");
INSERT INTO cotNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Oraquea itsojeventajiacarigueti saserorotejia anaantajianquitsica aisa jivajiguirica joriojia, teequea incanteji Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Icanqueriquea Pirato: —¿Arimpate teequea pinquemavaqueroji icantacojiaquempica? ");
INSERT INTO cotNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Cotanquitsiquea Jesoshi tee incantimateji, jero yamenantanacaca quejemajirovetatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Icantacoguitani aapojajagueti Paashicoa, iriraquea quejemajirovetatsica yoguipaquijajiri aparo isantanatacotimentajiquerica ipeacaaguishetacaca, quericaca inintajiaqueca igonorojia iroguipaquijaje. ");
INSERT INTO cotNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ariquea ichoocaque oraniqui aparo santanatacotanquitsica pajitatsica Varavashi, itsitacaguitejacovaetanaca oraniqui iquemacojitiri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iroompaquea yamenajiaquerigueti Pirato yomporoguijaventavaetapojacari, icanqueriquea: —¿Querica pinintajiaqueca noguipaquijajempiri? ¿Irioca Varavashi, irioca Jesoshi icantajitica Quirishito? ");
INSERT INTO cotNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Itsaquerotari iriatimpa iroguenti icatsimatacojiqueriquea yamenajiquerigueti iriguenti yomporoguijaventajica, irootaquequea yamantajiacarica iriatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Choocatiraja isaviquiquea Pirato ontaniqui icantomajantapiniquegueti, otigaranquitsitari imanquigare camanquiterineca: —Aatoja querocaca picotirini iriratica teeca impeacaimatempaji. Natsipevaeca noguimaacotacarigueti incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Cotanquitsiquea iriraquea saserorotejia anaantajianquitsica aisa jivajiguirica joriojia itsatacajaiaqueriquea maasano, incanqueri: —Irioquea poguipaquijaje Varavashi, iriraquea Jesoshi pimetojacaanteritsijate. ");
INSERT INTO cotNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Icanquequea quejemajirovetatsica: —¿Quericate pinintamajajiaqueca noguipaquijajeca? ¿Irioca Varavashi, iriocaja Jesoshi? Icajemitsijianacaquea: —¡Varavashi! ");
INSERT INTO cotNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Icanqueriquea Pirato: —Iroosacanica, ¿querocampate noncoquerini iricatica Jesoshi icantajitica Quirishito? Icajemitsijianacaquea aisa maasano: —¡Pompajacoteri! ");
INSERT INTO cotNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Icanqueriquea Pirato: —¿Taampate ipeacaaca? Icajemamajajianaji: —¡Pompajacoterishine! ");
INSERT INTO cotNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Iroompaquea yamenavaquerogueti Pirato icantacoguitani icajemaguitini, querocampate incojiavajerini, ariquea icajemacaanque oja iquivavacotimojiacari maasano, icanquequea: —Irimetojajiquerigueti imaica, teequea naatimpa quejetatsineca. Aviguentijia quejejianquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Maasanopae icajemajianaquequea: —Aritaque nonquejetempata, naatimpajia quejejianquitsineca aisa nirijanijiate, naatimpajiaquea metojacaantajiaquerineca. ");
INSERT INTO cotNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ariquea iquemajiaquerigueti Pirato yoguipaquijajiajiniri Varavashi. Ariquea icantacaantsitariquea Jesoshi impasajitaqueri, irajaitanaqueri irompajacojiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iriraquea igoaretajiate quejemajirovetatsica yaajianaqueri Jesoshi intsompoguiqui imapipancotequi, icantajitiro “Peretorio”, ariquea icajemacaantajiaqueriquea maasano irapicoaretajiate, yomporoguijaventajiacariquea. ");
INSERT INTO cotNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iroompaquea isapoquitsijigari iitsaare, iquitsaatantajiacari otsipa quitsaarentsi quityoncamorenari. ");
INSERT INTO cotNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yaajiaquequea tseitseiaro, ipeacajaiacanari iramatsaero, yamatsaetsitari. Aisa yajiricacaajiaqueri savoroquiji itincamijempequiqui, iroompaquea igueroventajianacari ishiroshirontimentajianacariquea, icanqueri: —¡Iricashia Imajirote jorio! ");
INSERT INTO cotNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iquishoquishoavaequeri, yaapitsatsijiajari savoroquiji itavatavaatsitantari iguitoqui. ");
INSERT INTO cotNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iroompaquea iteroncajajianaquerogueti ishiroshirontimentavaecarigueti, isapocarejajiri quityoncamorenari, irooquea iquitsaatantajari iitsaare, yaajianaqueri irompajacojiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oraquea yoayoaitanaquegueti irompajacojiaqueri, itonquivojajiavacari aparo Shirenequitica pajitatsica Shimo. Iriraquea coaretajia icantajiavaqueri irinatashitanaqueriquea Jesoshi igoroshite. ");
INSERT INTO cotNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ariquea yarejerejeitacaquea Gorogotaniqui, (ocanquequea, “Ochoocatigueti Shocoitontsi”). ");
INSERT INTO cotNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yojocajiavetacanari vinoja iconoajatantajicaro ishincanajato, yatsirecajavequitaro intati, teequea irimiremparoji. ");
INSERT INTO cotNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iroompaquea iteroncajiaqueroguetiquea yompajacojiaquerigueti, iriraquea coaretajia ipegavijijiaca intsajiaquenijite quericaca ashinquemparoneca iquitsaaguevecaca. ");
INSERT INTO cotNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ariquea isavisaviique oraniqui yamenajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ojenoquipojaquegueti ishinquireguishipojacagueti ipatacajitaqueroquea ogota itioncajiquero ocanque: “Iriguenti Jesoshi, Imajirote jorio.” ");
INSERT INTO cotNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aisa itsipatacaantajicariquea mavite aitsitantatsica yompajacojitaqueri, aparo yogatiacojiqueri itincamijempequiqui, iriraquea itsipa iroguenti yogatiacojiqueri ishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iriraquea avisavisaitanquitsica oraniqui inijashinatacari icantajianaque chaguito chaguito, ");
INSERT INTO cotNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","icantajiaqueriquea: —Arimpate picanque: ‘Nosoveaqueroquea iteemporote Aapani Irioshi, ariquea nompeacaitajemparo, nontsitacajero 3 savincaguiteri.’ Imaicaquea iintsija pompetanaquempajate. Arimajagueti aviguenti Irijanite Aapani Irioshi, pintsopajacotanajempaja paguijitapojaje. ");
INSERT INTO cotNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ariquea iquempejiaca saserorotejia anaantajianquitsica itsipatsipaicari tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa jivajiguirica joriojia, ishiroshirontimentavaetacari icantavacaajiaca: ");
INSERT INTO cotNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Arimpate yompeguetacari itsipapae, cotanquitsi teequea iragavejempaji irompetacotanaquempa iriatimpa. Iriovetaca Amajirojiate ishiraerijia, iintsija intsopajacotanajempaja coroshiqui iraguijipojaje, antsatantaquemparica ariquea antsaroventajianaquempari. ");
INSERT INTO cotNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yaventaguitarinitarite Aapani Irioshi, iintsijate irompetemparija imaica arimajagueti ipintsacari, icanquetarite: ‘Naroguenti Irijanite Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iquejequejeitanaca aisa itsipatacaantajicarica yompajacojitaquerigueti, icantacantaguishevaetaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Iroompaquea itampaticavepojaca catsirincaiteri, ocantanaque pitsec maasano quepatsi, arejetacovaeca ijaguitetanajigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ariqueate icotanaca iririjencavaetanaque Jesoshi, icanque: “Elí, Elí, ¿lama sabactani?” (Oncanquequea: “Aapani Irioshi, Aapani Irioshi, ¿queroquea ococani pojocantanaquenaca?”) ");
INSERT INTO cotNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iconoajiaca choocajianquitsica oraniqui irooquea iquemajiavaquerigueti icantajianaque: —Icajemaqueri tsavetantatsica Iriashini. ");
INSERT INTO cotNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ishiitsitanaca aparo, yaanaquequea atsimijicajatiroca oja, iticajatsitaro vinoja cachonerontoquijajaro, yoguitinajacotsivetanari savoroquijiqui irantsimijicajatavaquerome. ");
INSERT INTO cotNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Cotanquitsiquea itsipajia icanqueriquea: —Iintsijate amenajiavaqueritaja incoraquetashipojeri Iriashini iroguisoaancajeri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ariquea icajemanaji aisa Jesoshi iririjencavaetanaque, ariquea yoguipaquijapanajantiro ishire metoc. ");
INSERT INTO cotNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Irooquea imetojanaquitigui, ariqueate ocotanaca operejanaque omorena ticaamorenatanquitsica teemporoqui jocagatsica aatonijite iquijajitirotsi intsompoguiremajacaqui. Opecotarejanaque tampaticaquea niganquisano ocantanaque sarararararara, oquenapojiquea jenoqui arejevaetacaquea isavi. Omoguequitanacaquea quepatsi moguec moguec moguec, otsecaguetanaquequea mapitsentseina. ");
INSERT INTO cotNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ariquea ocoguetanacaquea omoroguetanaca iquitajiguetirigueti metojaripae, itancoretancoreitanaque icaramirincavaeque igomajamajarejia Aapani Irioshi metojajiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ariquea isotosotoitantanajaro omoropae, iroompaquea ipochatanajigueti Jesoshi, yoayoaitanaque iriatimpajia Jerosarequi, oratica guinteninintsi yashincaca Aapani Irioshi, yamenajiavajiri icaramirincavaeque choocajianquitsica oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iriraquea imajirojiate coaretajia aisa itsipatsipaitashijiacaca yamenajiavajirigueti Jesoshi, yamenajiavaquerogueti omoguecaguetanaquegueti, aisa otsipapae cantashitatiaguetanquitsica, itsarotsaroitsitanacaquea, icantajiaque: —Arimajaca iriguenti Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ariquea ochoocajiaque oraniqui omporoguijaca manquigarentsijia oguijaguijaiquerica Jesoshi iquenapojigueti Garireaqui amitacojiaqueriniji. Iroatimpajia manaquea ochoocajiaque tiijaicoñajisano ontaniqui amenamenaiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ariquea ochoocajiaque aisa oraniqui Maria Magararaquitica, oraquea otsipa Maria iriniro Santiago aisa Jose, oraquea aisa iriniro irijanijiate Severeo. ");
INSERT INTO cotNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iroompaquea ijaguitemajatanajigueti, icoraquepoji aparo ajaarantatsica pajitatsica Jose quenampojaroca Arimatea. Ari iquejeca iriatimpa ipeanaca itsatacaane Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iriatimpa yoashitanaqueriquea Pirato, icanqueriquea ininque irajaitanajero itsino Jesoshi. Iriraquea Pirato icantacaantsitari irojocajitajeneri. ");
INSERT INTO cotNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ariquea yaanajiro Jose itsino Jesoshi, yampiguiricacotantanacari iniromorena shipetari teeca oncantaiteteji ipeacaajitaca irino. ");
INSERT INTO cotNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Iroompaquea yaanajiri yojoquijitajiri imperitamoroqui iroaqueramorotica iqueecacaanontacaca mapichonquiinaqui irojoquijitantajitajemparica iriatimpa irimetojaquegueti. Ariquea itigaritashitantacari inirotsentseina mapi, iticaacotantapanajantari, yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ariquea ochoocajiaque oraniqui Maria Magararaquitica aisa otsipa Maria osavisaviique oraniqui itampaticatacotaquegueti yojoquijitajirigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iroompaquea osavincaguitetanaquegueti imagorejantajitaca, iriraquea saserorotejia anaantajianquitsica aisa pariseojia yoayoaitanaquequea iramenajiajateri Pirato. ");
INSERT INTO cotNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Icantajiapojiri: —Nomajirote, noquenquejajiajiroquea icanqueca irintatica amatavijantatsica anijatirajagueti, icanquequea: ‘Aapojajempagueti 3 savincaguiteri nompochatanajequea.’ ");
INSERT INTO cotNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Irootaquequea noncantantaquempica, iintsija pintigaranquequea coaretajia inquempoguijamajajiaqueri yojoquijitantajicarica avisanaquegueti 3 savincaguiteri, aatonijite icoraquetashijiguiritsi itsatacaanejia iraajiajateri, iroompa incantajigueri maasano jac pochatanaji. Ariguetiquea inquempejiaquempagueti imaica ocatica tsojetsi caaviji anaavaequero otsipa yamatavijantaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Iriraquea Pirato icanqueri: —Iroosacanica iintsijate, jeri irirajia coaretajia, poapoaitanaquequea pinquempoguijamajajiaquerija aviatimpajia querocaca pincojiaqueroni yojoquijitantajicarica. ");
INSERT INTO cotNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iriatimpajia yoayoaitanaque yojoquijijitaquerigueti Jesoshi, iseyotsitaro mapi yashatirijacotantajicarica, ariquea icantajiaqueri coaretajia inquempoguijamajaqueroja aatonijite quericaca coraquetashitimatiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ariquea anaanacagueti imagorejantajitaca, osavincaguitetamanaji pariapojajaroca semana, oraquea Maria Magararaquitica aisa otsipa Maria oahoaitanaquequea amenajiajatero yojoquijitantajitacarica. ");
INSERT INTO cotNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Oraquea tequeratagueti arejerejeitempaji, omoguecanaquequea quepatsi moguec moguec moguec, icoraquepoji irashivantite Amajirote iquenapojiquea inquitequi. Itigaritapojiro mapi iticaacotantajivetacarica Jesoshi, isavicapojiro. ");
INSERT INTO cotNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Itsirencavaequequea icanca quempevaecaquea careti. Oratica iitsaare quitamaromajatatiguinimaja quempetacaqueate oquitamarotigueti sharaca. ");
INSERT INTO cotNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Irirajia coaretajia irooquea yamenajiavaquerigueti ariquea icohicoitanaca itsaroamajajianaque yompioncajianaca pion, pion, pion, itejatejaitanaquequea ijatacojiaquiti. ");
INSERT INTO cotNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Iroompaquea arejerejeivetapojaca manquigarentsi, icantajiguiro irashivantite Aapani Irioshi: —Aatotarite pitsaroajiguitsi. Notsaquequea iriguenti pamenaguetaje Jesoshi yompajacojivecaca. ");
INSERT INTO cotNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Cotanquitsiquea teequea inchoocatajeji acaniqui, pochatanaji, aritarite icanque iriatimpa tequeratagueti irimetojeji. Intsijate caacatejate pameneroja yojoquijijivecarigueti. ");
INSERT INTO cotNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pishintsijianajeja pincamantapojerija itsatacaanejia pincantajigue: ‘Jac pochatanajishiatsi. Imaica iroanaquequea Garireaqui, iriquetiquea oananquitsine. Pamenajiapojajeri ontaniqui.’ Irootaque nocamantaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Irooquea oquemajiavaquerigueti otsaroajianaquequea, cotanquitsiquea oshinejianaca aisa. Ocampanajantatigui tapoc oshintsijianaji oncamantapojaqueri itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iroompaquea itonquivojajiavacaro Jesoshi quenavoquirontsiqui icantajiavaquero: —¿Choocampi? Oquempejiquempejiitanacari ajiricaguititsitari otsaroventanacari. ");
INSERT INTO cotNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Icantajiaqueroquea Jesoshi: —Aatoquea pitsaroguitsi. Poapoaitanaquequea pincamanqueri iguentijeguipae iroaroaitanaque Garireaqui. Ontaniquiquea ari iramenajiapojajena. ");
INSERT INTO cotNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Irooquea oahoaitanaquegueti manquigarentsijia, iconoagarantajiaca coaretajia quempoguijajiavetacarica Jesoshi manaquea yoayoaitanaquequea Jerosarequi, icamantajiapojiri saserorotejia anaantajianquitsica maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iriatimpajia icapiocajiaca itsipatsipaitacari jivajiguirica joriojia, iquemavacaajiaca, yojocajiaqueneri coaretajia caraquisequi imentaqui, ");
INSERT INTO cotNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","icantajiavaqueri: —Aviatimpajia iroguenti pincanque: ‘Oraquea opitsecanaquegueti naatimpajia nomaajianaque, iroompaquea icoraquetashijiaqueri itsatacaanejia yaajiapanajantiri.’ ");
INSERT INTO cotNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Arigueti inquemegueti quejemajirovetatsica noshinetacaajiaquempari aatonijite querocaca icotimajiguimpitsi. ");
INSERT INTO cotNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iriraquea coaretajia yaajianaqueriquea imentaqui, yoayoaitanaque inetsanajiaquero icanquerica. Ariquea iquemacojiaquero maasano joriojia itsavetantavecaca, otsitacaguitejacovaetanacari, ocantacoguitani arejevaetaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ariquea yoayoaitanaquequea Garireaqui itsatacaanejia carajianquitsica 11, yoayoaitanaque otsempiqui icanquerica Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ariquea yamenajiapojirigueti, itsaroventajianacari, cotanquitsiquea iconoagarantacaquea iquenquejashirentajianaque: “Iriocaja.” ");
INSERT INTO cotNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Cotanquitsiquea Jesoshi iquempejiquempejiipojiri, icanqueriquea: —Icanquenaquea Aapani Irioshi paesatoniqui: ‘Imaicaquea aviatimpa aviguenti agavejaguetaqueroneca maasanopae inquitepaequitica aisa quepatsipaequitica.’ ");
INSERT INTO cotNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irootaquequea imaica nocantantajiaquempica poapoaitanaque pintsavetantimojianaquerija maasano caquinteguetatsica, pintsaroventacaajianaquemparijate cameetsanijite impejaianaquempanijite notsatacaanejia. Ariqueate piviñacajajiaqueri ivajiroqui Aapani aisa Irijanite aisa Ishire. ");
INSERT INTO cotNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pintsatacaajiaqueri inquemisantamajajiaquero maasanopae nocanquempica irinetsanamajajiaqueronijite. Noncoquempaniquea nontsipamajataquempi oavaetanaque savincaguiteriqui arejevaequemparoquea onteroncanajempagueti quepatsi.");
INSERT INTO cotNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jero oparianaca Quenquetsatsarentsi Oganejencamajatatsica tsavetacotaquerica Jesoquirishito Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iriraquea tsavetantatsica Isaiashini itioncacotaqueroquea paesatoniqui icanqueca Aapani Irioshi iquenquetsatacaaquerigueti Irijanite, icanqueriquea: “Ari nontigarancaqueri iriquetica oananquitsineca, intsavetacotempi. Irio camantajiaquerineca igonorojia querocagueti pinquenanaqueni irinetsanatashitantajiavaquempica.” ");
INSERT INTO cotNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Inquenquetsataquequea oquitamampororoitapojaquegueti iririjencani, incanquequea: ‘Pinetsanatashijiavaquempari Amajirote inquenantapojempaca, pintanarejagueteneri iguenavoquiropae ontampaticapoquitantanaquempaca.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iroompaquea iriraquea Joanca Viñacajatantatsica yoanaquequea ontaniqui oquitamampororoitapojaquegueti iviñacajatantavaequequea, aisa itsavetantavaequequea icanque: “Pincantashitatijaianajempa povashiantajianajero pipeacaaguishejiavecaca, piviñacajajianaquempaquea aatonijite icatsimatimentajiguimpiroquea Aapani Irioshi maasanopae pigovaeguisherejia, manaqueate irishetajempiroquea.” ");
INSERT INTO cotNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Icaramirincatashivaetanaqueriquea Joreajiaquitica aisa Jerosarejiaquitica. Irooquea iquemajiapojirigueti ariquea icohicoitanaca itsaveacojianaqueroquea maasanopae igovaeguisherejia, ariquea iviñacajajiaqueriquea Jororanequi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iroguenti iquitsaataca Joanca quitsaarentsi ipeacaajitacaca imae cameyo, aisa ichompimashitacocariquea imeshinatsa. Iriguentiquea ishecataca quejevetarica shapipiiquiti aisa earotoja. ");
INSERT INTO cotNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ariquea itsavetantajianaqueri icanqueriquea: —Irooshipojiquea incoraquepojaque impoitapojenaneca. Iriatimpa caaviji yanaaquenaquea yagavejamajati. Aatotarite noquempetimataritsi iriatimpa nompeaquempame amiquerineca nosavincanaqueme noishorejacoquerime igaviguitire, caavijitari yanaamajaquena. ");
INSERT INTO cotNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naatimpa iroguenti nantaque noviñacajatantajiaquempiro oja, cotanquitsiquea iriatimpa inquempetacaantaquemparo iroviñacajatantajiaquempiri Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ariquea isotoantanacaroquea Jesoshi Nasare choocatatsica Garireaqui, icampojaca ichoocaquegueti Joanca, ariquea iviñacajatavaqueri Jororanequi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ariquea yarejevetapojajaro Jesoshi otsapijapojacagueti, yameniroquea otanarejanacaquea inquite yampiguiricashipojacariquea Ishire Aapani Irioshi iquejetapojacari emoreni. ");
INSERT INTO cotNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iroompaquea iquenquetsajencajitanaque jenoqui inquitequi, icanque: —Aviguentiquea Irijani nopintsamajatacaca, noshineventamajataquempiquea aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iroompa iriraquea Ishire Aapani Irioshi yaanaqueriquea Jesoshi osamani oquitamampororoitapojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ariquea ichoocaquitiquea oraniqui 40 savincaguiteri iconoicari shecatantaguetatsica. Iriraquea Satanashi icoraquetashiqueriquea yasereseretaqueriquea yamenantavetacari inintavecaquea irantacaaquerime teeca irininteji Aapani Irioshi, cotanquitsiquea teetarite iragavejeriji. Iroompaquea irioquea coraquecoraqueitashipojajiri irashivantijitete Aapani Irioshi yamijiapojajiri. ");
INSERT INTO cotNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ariquea isantanatacojitaquerigueti Joanca, yoanaque Jesoshi Garireaqui itsavetantavaetaqueroquea Quenquetsatsarentsi Oganejencamajatatsica tsatacaacajica quero icocani Aapani Irioshi imajirontagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Icanque: —Imaicaquea aapojaca irinetsanatantaquemparoca Aapani Irioshi icantaqueca coramani, irooshipoji irimajirontapojempa. Povashiantajianajeroja covaeguisherentsi pincantashitatiajianajempa, aisa pinquemisantajigueroja Quenquetsatsarentsi Oganejencamajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ariquea icantanacaquea Jesoshi oraniqui ishitaravijatanacaro otsapijaqui iniromotija Garirea jmm. Inejajiapojiriquea Shimo aisa iriguentijeguite pajitatsica Antirishi tarajajianatsiquea, irootaquequea isavicaventajiaquequea iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Icantajiapojaqueri Jesoshi: —Jame poguijaguijaitanaquenajate, imaicaquea irioquea pimpitsocashijianaquempa caquintejia, nagavejacaajiaquempiquea pinquejetacaajiajempari shima panquitacojiguirigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ariquea iriatimpajia yojocapanajantiroquea imantsatsitepae yoguijaguijaitanaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yoayoaivetanacaquea tiijacoñaji ontaniqui irioqueate yamenapoji Santiago aisa iriguentijeguite pajitatsica Joanca savisaviitaque quenajarontsiqui inetsanajiaqueroqueate imantsatsitepae. Itsipatsipaitacari iriri pajitatsica Severeo. ");
INSERT INTO cotNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ariquea iriraquea Jesoshi icampojiriquea Santiago aisa Joanca: —Jaame poguijaguijaitanaquenaja. Iriatimpajia yoguijaguijaitanaqueriquea Jesoshi, yojocanaqueriquea iriri quenajarontsiqui, itsipajiajari amijiaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ariquea yoayoaitanaque Caperenaoqui. Oraquea aapojacagueti savincaguiteri imagorejantajitaca yoanaque Jesoshi shinagogaqui icapiocantajiacaca joriojia iparianacaroquea itsatacaantanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iquemajiavaqueriguetiquea maasanopae yamenamenaitanaquequea intati, yamenajiaqueritari itsatacaajiaquerigueti choocaquea iragavejane, teequea inquempejiguempariji tsatacaantajiguiroca itioncacotanaqueca Moishishini. ");
INSERT INTO cotNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ariquea ichoocaque oraniqui ishinagogatequi aparo shirampari ishaquiacaca ampatsini, ariquea iriatimpa icajemaque icanque: ");
INSERT INTO cotNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Ariotaqueshiatsi, Jesoshi Nasarequitica! ¿Querocaquea pincojiaquenani? ¿Irooquea picoraquetashique pinteroncajiaquena? Notsaquempiquea aviguenti Iriomajaca irashi Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Icantanaquequea Jesoshi: —¡Pisanticote! ¡Pisotoanajeri! ");
INSERT INTO cotNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Irooquea iquemaquerigueti ampatsini ariquea icotanaqueri ishaquiacaca icantavaetanaquequea tinquinini, tinquinini tinquinini. Iroompaquea icajemapanajanti ampatsini ¡jeeee! isotoanajiri. ");
INSERT INTO cotNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Maasanojia yamenamenaitanaquequea intati icoacotavacaajianaca: —¿Taashia opaji ocatica? Ocantashitatiacatarite itsatacaantapojica, choocaquea iragavejane. Icantaquerigueti ampatsinipae, ari iquemisantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iroompaquea maasanojia guinteniguinteniitanquitsica Garireaqui iquemacojiaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ariquea isotosotoitanajigueti shinagogaqui, yoanaque Jesoshi itsovironaquitequi Shimo aisa Antirishi, itsipatsipaitanacari Santiago aisa Joanca. ");
INSERT INTO cotNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Oraquea ivaguirotemajaca Shimo ocatsirincavaetaquequea ojoquijica intsompoguiqui. Irooqueate yarejetapojacagueti Jesoshi icamantajitavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iriatimpa iquempejipojaro yacatsavacopojiroquea yogatiitaro. Ariquea ocopanajantaquea opeanaja taampina. Ariquea ojocacojiajiniriquea irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ariquea itsoguenancanajigueti catsirincaiteri yamajiapojiniriquea Jesoshi maasano joquijijianquitsica iriguentica aisa ishaquiajiacaca ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Maasano guintenijianquitsica oraniqui icaramirincavaequequea sotomorontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iriraquea Jesoshi yogueshiguetajiriquea cantashitatiajencatashiguecarica joquijirentsipae, aisa yoguisotojaijainiri ishaquiajiacaca ampatsinipae. Iriraquea ampatsinijia itsajiavaqueriquea, jero Jesoshi icantantajiavacarica: —Aatoja pitsavetacotantajiapojanatsijate. ");
INSERT INTO cotNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Osavincaguitetanajigueti ogantagatiraja opitsepitseiti, icatianacaquea Jesoshi, yoanaque ontaniqui osamani, yamanaqueriqueate Iriri. ");
INSERT INTO cotNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Incajaranquitanaquitiguiquea yoanaque Shimo incoaguetajeriquea itsipatsipaitanacari itsipavijitaca. ");
INSERT INTO cotNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ariquea yamenajiapojajiri icantajiapojiri: —Maasanojia icoaguetajimpi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cotanquitsiquea iriatimpa icanqueriquea: —Jaame ontaniqui irooshiguetapojigueti iguintenipaequi nontsatacajaiaqueri, irootaquequea nocoraquetashique. ");
INSERT INTO cotNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yoanaquequea Jesoshi itsitacanaqueroquea maasanopae Garireaqui itsavetantaguetanaqueroquea shinagogapaequi icapiocantajiacaca joriojia, aisa yoguisotojaijainiri ishaquiajiacaca ampatsinipae. ");
INSERT INTO cotNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ariquea icoraquepojiquea aparo avejancari. Iguerovempojari icanqueriquea: —Nomajirote, arigueti pininque, pagavejaque piveajena navejancavejancaacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ipintsatacotanacariquea Jesoshi, icantajempequitanaca ipamitsitari, icanqueri: —Jeeje, noninque. ¡Pimpeanajempaja! ");
INSERT INTO cotNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Irooqueate icanquitiguiri jac peanaja yavejancavejancaavecagueti, caramajatanaji. ");
INSERT INTO cotNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ariquea itigarancajiriquea Jesoshi, cotanquitsiquea icantavajiri: ");
INSERT INTO cotNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Aatoja picamantitsi. Iriguentiquea poimotanaque saserorote ponigaapojempariquea, paanajenerija viratsipae, pinetsanaqueroja icantaqueca Moishishini cameetsanijite iramenamajaquempinijite, ariquea incanquempi peanajimpi, intsajiaquempinijite maasano peamajatajimpi. ");
INSERT INTO cotNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cotanquitsiquea iriatimpa yoanaquequea icamantajiaqueriquea maasano yogueshitajirigueti Jesoshi. Irootari caarica yoantanta Jesoshi ontaniqui iguintenijiacagueti caquintejia. Manaquea iquenaguetanaque osamanipaequi teeca iriguintenijiguempaji, cotanquitsiquea yoayoaitashivaetanaqueri osamanipaequitica iramenajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iroompaquea ocaraguitejavaetanaquegueti yoanajiquea Jesoshi Caperenaoqui. Maasanojia iquemacojiaqueriquea ariquea ichoocaque oraniqui tsovironaquiqui imaantapinitacaca. ");
INSERT INTO cotNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Irooquea iquemacojiaquerigueti yoayoaitanaque yomporoguijaventanacariqueate oraniqui intsompoguiqui aisa sotsiqui. Querocampate incojiaquempani inquijaquijaiquegueti itsipapae, jocajajiavaecaquea icaramirincavaequequea igonorojia. Iriatimpa itsavetantajiaqueneri Quenquetsatsarentsimajaca. ");
INSERT INTO cotNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ariquea icoraquecoraqueiquequea 4 shiramparijia yamacojiapojaqueri teeca ironquempaji. ");
INSERT INTO cotNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yarejejiavetapojaca iriguenti poncaquini icanca, querocampate incotacajaianaquemparini inquijacaantajianaquemparicate intsompoguiqui ichoocaquegueti Jesoshi. Yataitaiitanaquequea jenoqui sotsiqui ocantamencotacagueti, imorotsitaroquea itampaticatacotaquegueti Jesoshi ivaritsantsajacojiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iriraquea Jesoshi yamenajiavaquerigueti yaventajiapojacari irogueshitajeriniji, icanqueriquea teeca ironquempaji: —Irijani, jac shetacotajimpi maasano pipeacaaguishevecaca. ");
INSERT INTO cotNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ariquea ichoocajiaque oraniqui tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iriatimpajia iquenquejajianaque intati: ");
INSERT INTO cotNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Querocaquea icocani icanquegueti imaica? Manatari iquejemanatanacari Aapani Irioshi. ¿Arimpate choocampate itsipa agavejanquitsineca irishetsitantaqueroquea covaeguisherentsi? Aparotarite agavejatsi Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Cotanquitsiquea Jesoshi itsajiavaqueriquea iquenquejajiaqueca, icantsijigari: —¿Querocaquea picojianacani piquenquejajianaquequea piquejejiaqueroquea imaica? ");
INSERT INTO cotNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Querocampate caavijica anaaque mananquitsica? ¿Iroocajate noncantaquerigueti teeca ironquempaji: ‘Jac shetacotajimpi maasano pipeacaaguishevecaca’, iroocajate noncantaquitigueri: ‘Pincatianaje, paanajeroquea pinorijancaca, panijitanaje?’ ");
INSERT INTO cotNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Imaica namenacaajiaquempiroquea yagavejaque ocaniqui quepatsiqui irira Irijanite Caquinte irishetacoitajeri ipeacaaguishevecaca caquinte. Iroompaquea ipitsocashitanacari teeca ironquempaji icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Iintsija noncanquempiquea pincatianaje, paanajero pinorijancaca, poanaje pitsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ariqueate icotanaca icatiapanajanta, yaanajiroquea inorijancaca isotoanaji yoanaji. Yamenajiavajiriquea maasano, yamenamenaitanaquequea intati ishineventajiacariquea Aapani Irioshi, icantajigui: —Teequea namenimajigueroji onquempequemparoquea ocatica. ");
INSERT INTO cotNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ariquea yoanaji aisa Jesoshi otsapijapojagueti iniromotija. Irooquea yomporoguijaventajianacariquea icaramirincavaetanaquequea caquintejia, itsatacaajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iroompaquea yoanaji yamenapojiri irijanite Arejeo pajitatsica Irevi savicaquequea ontaniqui ipashicatsarajitirogueti, yoguijajiavaqueri avisavisaitatsica ivegaratacaajiavaqueri imentaquitsite maasanopae aajiananquitsica irajaararopae irooca taaca opajitapae, iriguentitarite capiocapinitinirica majirontatsica imentaquipae. Iroompaquea iriraquea Jesoshi icampojiri: —Jameja, poguijatanaquena. Iriatimpa icatiitsitapanajanta yoanaque yoguijatanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ariquea Jesoshi yoanaque itsovironaquitequi ishecatacaqueate, itsipatsipaitacariquea itsatacaanejia, jerijia itsipapae oshequini capiocapinijiguinirica majirontatsica imentaquipae, jeri aisa itsipapae covaeguishetatsica. Icaramirincavaequetari icanca oguijaguijaitanaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iriraquea pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini yamenajiaquerigueti Jesoshi ishecajiacagueti itsipajiacari covaeguishejiatsica aisa capiocapinijiguinirica majirontatsica imentaquipae, icanqueriquea itsatacaanejia: —¿Quero icocani irira tsatacaajiguimpica ishecatacojiacari capiocapinijiguinirica majirontatsica imentaquipae, jeri aisa itsipapae covaeguishejiatsica? ");
INSERT INTO cotNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Oraquea iquemaquegueti Jesoshi icantajiguiri: —Iriraquea teeca irashinoncajempaji teetarite incoguitejacotempariji aavintantatsica. Iriguenti coguitejacojigari ashinoncajajiatsica. Ariqueate noquejetaca naatimpa teequea irioquea noncoraquetashiteji teeca incovaeguishejiguempaji noncajemajiaqueri, iriguenti nocoraquetashijiaque covaeguishejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ariquea iriraquea itsatacaanejia Joanca aisa irashijia pariseojia yoguipaquijajiaqueroquea isheca teetaquea irishecatsitajempaquea. Iroompaquea iconoagarantaca yoayoaitanaque icantajiapojaqueri Jesoshi: —Iriraquea itsatacaanejia Joanca aisa irashijia pariseojia yoguipaquijapinijiaqueroquea isheca, cotanquitsiquea pashijia pitsatacaguica teequea inquejejiguempariji iriatimpajia. ¿Querocaquea icojiacani? ");
INSERT INTO cotNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iroompaquea iquejetacaanca Jesoshi icanque: —Pinquenquejeroja inchoocategueti iriaqueraca manquigatanquitsineca incajemajiaqueriquea itsipavijijiaca irishecatacaajiaquempariquea, ¿arimpate aatompate ishecajiatsi? Irishecajiaquempaquea, itsipatsipaitacaritarite cajemajiaquerica shinejiacaquea. ");
INSERT INTO cotNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Cotanquitsiquea oraquea aapojajempagueti incatsimatantajitaquemparica irajaitanaqueri osamani, ariquea iroguenti irisanticotantajitemparoca isheca, irishimampojancacojianaquempari. ");
INSERT INTO cotNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Aatoquea ocameetsati oncotatemparogueti quitsaarentsiqui iroquetishitequitica incotatantajivetaquemparo iroaqueramorenatica quitsaarentsi. Irajaquitsijivetemparoquea ariqueate oncotanaquempani ontsiñotsiñomorenatanaquequea arimpaquea omperejanaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aisa ari onquempetaquemparoquea iroguijaatantajitaquemparogueti vinoja iroaquerajatica oncachotapoje iroguijaatantajivetaquemparogueti imeshinanaquiqui iriquetinica oroameshinatananquitsica. Oncachojamajavetanaquempagueti oshimoajavetanaquempa, ariquea oncotanaquempa aravoavetaquitempa imeshina, intyaquisanaque oshacojaatanaquempaquea vinoja, aisa impomatsataquempaquea imeshina imperejanaque. Jero caaviji ocameetsavaeque impijaatantajitaquemparoquea iriaquerameshinari cameetsanijite aatonijite opomatsajata vinoja, aisa aatonijite ipomatsatatsi imeshina.” ");
INSERT INTO cotNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iroompaquea aapojajagueti savincaguiteri imagorejantajitaca yoanaque Jesoshi icantanaca tirigomashiqui itsipatsipaitanacari itsatacaanejia. Iriatimpajia ishireguipanajanti tirigoitsoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Icanqueriquea pariseojia: —Pamenajiguerija. ¿Quero ocotacani yaajianaquequea tirigoitsoqui imaica savincaguiteri imagorejantajitaca? Icantimentantajitirotarite irantantajitemparo. ");
INSERT INTO cotNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yacanaqueriquea: —¿Arimpate teequea pampatsajavantacojigueroji aviatimpajia itioncacojitaquerigueti Taavini coramani ocanquegueti itaseanaque iriatimpa aisa itsipajianacaca, teequea onchoocatimajaniquiteji taampaquea irishecajiaquempaca? ");
INSERT INTO cotNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iquijitsitanaca itsovironaquitequi Aapani Irioshi ichoocatigueti saserorote anaantamajatanquitsica Aviatare ishecatacaroquea pan icantimentantajitica irishecajitemparogueti, manaquea yojoquijitaquero oraniqui shitaponcarontsiqui cameetsanijite iramenaqueronijite Aapani Irioshi. Iriguentiquea shecajiaquemparoneca saserorotejia, iriotaquequea cantanquitsica Aapani Irioshi. Cotanquitsiquea iriraquea Taavini ishecatsitaroquea, aisa yojocajiaqueneriquea itsipatsipaitacaca. ");
INSERT INTO cotNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aisa icanque Jesoshi: —Oraquea savincaguiteri imagorejantajitaca manaquea ipeacaimentajicanari caquinte, iriraquea caquinte teequea impeacaimentajitenemparo iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iriraquea Irijanite Caquinte iriguentiquea cantanquitsica queroca icantimentantajitica irantantajitemparogueti savincaguiteri imagorejantajitaca, aisa querocaquea teeca incantimentantajiteroji. ");
INSERT INTO cotNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ariquea yoanaji aisa Jesoshi shinagogaqui icapiocantajiacaca joriojia, iquijapoji intsompoguiqui. Ariquea ichoocaque oraniqui chompevacotanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ariquea irirajia omporoguijajianquitsica yamenamajajiaqueriquea Jesoshi iramenajiaquequea arica irogueshitajeri savincaguiteriqui imagorejantajitaca cameetsanijite intsaveacotantajiaquerinijite incatsimatacaantajiaquerinijite. ");
INSERT INTO cotNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Cotanquitsiquea Jesoshi yamenapojaqueriquea chompevacotanquitsica icanqueri: —Iintsija pincatigueja iramenajiaquempinijite maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ariquea icanqueriquea maasanopae: —Imaica iintsija pincantajiguenajate querocaquea icanque Moishishini coramaniqui. ¿Taaquea irantantajitemparoca savincaguiteriqui imagorejantajitaca? ¿Ariquea icanque impeacaantajitemparo cameetsa, irooca irantantajitemparo covaeguisherentsi? ¿Ariquea icanque aavajeri agonoro aatoniji imetoji, irooca icanque ametojaqueri? Cotanquitsiquea iriatimpajia teequea querocaca incanteji, iquemisantajianaquequea maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iriraquea Jesoshi yamenamenaiquerigueti maasano icatsimatsitanacaquea, aisa ishimampojancacojianacariquea, yamenajiaquerigueti mana iquishoshirentanaquequea. Iroompaquea ipitsocashitariquea chompevacotanquitsica icanqueri: —Pincantavacotempaja. Irooquea icantavacovetanaquitiga ariquea ocotanaca iraco jac peamajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iroompaquea isotosotoitanaji pariseojia yoayoaitanaji iramenajiaquiteri shineventajigacarica Erorishi. Irooquea yamenajiavaquerigueti icapiocajiaca isariimanatanacari Jesoshi irimetojacaantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iriraquea Jesoshi yoanaque otsapijapojacagueti iniromotijaqui itsipatsipaitanacari itsatacaanejia. Itirorencaventajianacari aisa icaramirincavaequequea Garireaquitica aisa Joreaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Iquemacojiaqueriquea yonigaantaguequeroqueate oacaantantatsica intati icoraquecoraqueiquequea iramenajiaquiteri, iquenaquenagarantajiapoji Jerosarequi aisa Iromeaqui. Itsipapae iquenajiapojiquea intatiqueroqui Jororanequi. Itsipapae quenaquenaitapojatsica Tiroqui aisa Shironequi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iriraquea Jesoshi irooquea yamenavaquegueti yomporoguijaventajiapojacari icantajiaqueri itsatacaanejia irajaiajateneriquea quenajarontsi iroajiaqueneriquea quempeji otsapijapojacagueti intehinteitantajianaquempaca aatonijite itsinacajiguiritsi omporoguijaventajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yomporoguijaventajiapojacari icaramirincavaeque joquijijianquitsica itaviavacaajianacaquea icanca inintajiaque inquempejiquempejiiquempariquea impamijiapojaquerinijite, yamenajiaquequea yogueshiguetajiriquea icaramirincavaeque itsipapae. ");
INSERT INTO cotNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iroompaquea irirajiaquea ampatsinipae yamenajiaquerigueti Jesoshi yogueroventsitanacariquea icajemajianaque icanque: —¡Aviatimpa aviguenti Irijanite Irioshi! ");
INSERT INTO cotNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Cotanquitsiquea Jesoshi icantimentajiaqueriquea aatonijite itsavetacojiguiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iroompaquea Jesoshi yoanaquequea otsempiqui icajemajiaqueriquea inintacajaiaqueca. Oraquea yoayoaitanaquegueti iriatimpaqui ");
INSERT INTO cotNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","yaaquequea 12 intsipatsipaiquempaca, aisa intigarancajiaqueca intsavetantavaetaquequea irootaquequea ipajitantajiacarica itigarancanejia. ");
INSERT INTO cotNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ariquea yagavejacaajiaqueriquea iroguisotojaijaeneri ishaquiajiacaca ampatsinipae. ");
INSERT INTO cotNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Maasanoquea yaajiaqueca manaquea ipajijiaca: Shimo (ipajitajica Peerero); ");
INSERT INTO cotNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago irijanite Severeo, aisa Joanca iriguentijeguite Santiago (ipajijiajiri mavite Voaneregueshi, oncanquequea “quempejiaca careti”); ");
INSERT INTO cotNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antirishi, Jeripe, Varitorome, Mateo, Tomashi, Santiago (irijanite Arejeo); Tareo, Shimo (icantajitica “Serote”), aisa ");
INSERT INTO cotNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jorashi Ishicariote, aacaanquerineca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ariquea yoanajigueti Jesoshi tsovironaquiqui, yomporoguijaventajianacari icaramirincavaequequea caquintejia, querocampate incojiaquempani irishecajiaquempa iriatimpa aisa itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chooca cantajianquitsica: “Jac itsavigavaetanaque.” Iquemacojiaquerigueti ijitanejia icoraquejiaquequea irajaiajaterime. ");
INSERT INTO cotNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Icoraquejiaquequea aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, iquenajiapojaque Jerosarequi iramenajiaqueriquea Jesoshi. Iriatimpajia icanquequea: “Iriguentisa shaquiacari Veeresevo imajirote ampatsinijia. Iriotaquequea agavejacaaquerica yoguisotoantaguetacanarica ishaquiajiacaca ampatsinipae.” ");
INSERT INTO cotNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iriraquea Jesoshi icapiocajiaqueriquea maasano itsatacaajiaqueriquea iquejetacaacanari, icanqueri: “¿Arimpate intigarancajempa Satanashi iriatimpa iroguisotoaquempaquea? ");
INSERT INTO cotNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ariqueate inquempetaquempari inchoocategueti caquinte incapiocajiaqueriquea igonorojia impeaquempaquea imajirote. Iroompaquea irira igapiocane impariajianaquemparogueti incatsimatavacaajianaquempa, aatoquea ichoocagantsijiajitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ariquea iquempejiaca tsipatsipaitacarica ijitanejia, iriatimpajiagueti apigarancashitavacaajianajatsineca incatsimatavacaajiaquempaquea, ariquea incohincoitanaquempa intsinampirejavacaajianaquempa aatoquea iconoavacajaiajatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ariquea iquempetaca Satanashi iriatimpa. ¿Arimpaquea querocaquea incoquempani iriatimpagueti apigarancavacaajiajatsineca incatsimatavacaajiajempagueti igonorojia ampatsinipae? Interoncajiaquerigueti igonoro apatiroquea inchoocataje. ¿Ariquea quericampate iromperatajempaca? ");
INSERT INTO cotNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Inquempetempaquea inchoocategueti itsipa caquinte irininquegueti inquijashitanaqueriquea itsovironaquitequi catsimarimajaca iraagarantsiqueriquea, iroquetitaqueate iroishotapojeri cameetsanijite iraagarantsiquerinijite. Oraquea aatotagueti yoishotiritsi aatoquea yagavejitsi iraagarantsiqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nontsatacaamajaquempiroquea imaica taacagueti impeacaaguishejiaquempa caquinte covaeguisherentsi irooca inquenquetsaguishevaeque taaca opajita, iriraquea Aapani Irioshi iragavejaquequea irishetacotajeri aatoquea iquenquejacaajiri. ");
INSERT INTO cotNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Cotanquitsiquea iriraquea cantaguishetacoquerineca Ishire Aapani Irioshi, aatoja ishetacojitiritsi, incoguitempani irantsipevenquemparo.” ");
INSERT INTO cotNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Icantantajiacarica imaica, yamenaquequea icantajiaqueri: “Iriguentiquea shaquiacari ampatsini.” ");
INSERT INTO cotNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ariquea ocoraquetaque iriniro Jesoshi aisa iriguentijeguitepae, icatintiitapojaca sotsiqui, ariquea icajemacaantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iriraquea savisaviitanquitsica anquitsaecarica Jesoshi icanqueriquea: —Coraquetaque piniro aisa piguentijeguitepae, ichoocapoji sotsiqui, inintajiaque iramenajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iriatimpa icanqueri: —¿Querocate iinani, aisa quericate niguentijeguitepae? ");
INSERT INTO cotNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ariquea yamenitajianacariquea maasanojia savisaviitanquitsica anquitsaecarica icanque: —Jeeri irirajia nopeajiaqueca iinani aisa niguentijeguitepae. ");
INSERT INTO cotNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quericaca netsanamajatiroca inintaguetica Aapani Irioshi, iriotaque nopejaiaque iguentijeguipae, tsiojipae, iinanipae. ");
INSERT INTO cotNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ariquea Jesoshi yoanaji aisa otsapijapojacagueti iniromotijaqui itsatacaantavaetajiquea. Icapiocajiapojaquea icaramirincavaeque caquintejia yomporoguijaventajiapojacariquea, itirorencajianacaquea icanca, itetantanacaroca Jesoshi quenajarontsi isavicaque. Maasanojia omporoguijajianquitsica ichoocajiaque otsapijapojacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ariquea itsatacaajiaqueri iquempetacaaguetacaroquea taaca opajitapae, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iintsijate piquemisantajiavaquenajate. Yoanaque aparo caquinte impishoncaguitero oitsoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ipishoncavoncaquitanaqueroquea tacororo tacororo itsitacaguetanaquero. Oconoagarancaquea asacaraaguetanaca quenavoquirontsiqui, iroompaquea isavisaviitashipojiroquea tsimeripae ishecajiapojacaro. ");
INSERT INTO cotNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Otsipa oconoagaranca asacaraanaca mapiporoquiqui, taampina otsoroitsivetanaca, teemajaca onchoocamajatenica quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iroompaquea icatsirincaguitevetanaca catsirincaiteri itsianaqueroquea oshimpeguiricanaquequea ometojanaque, teetarite oamajateji ovarishitsa isaviqui, ojocaavaquerotarite mapi. ");
INSERT INTO cotNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oconoacaquea otsipapae asacaraaguetanaca ochoocaquegueti ovarishitsa samerento. Ariquea otsoroavetanaca ariqueate otsoroitsitanacaquea samerento iroatimpa otsincoanajiroquea ometojanaji, teequea onchoocateji oitsoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oconoacaquea otsipapae asacaraanaca ocameetsaguitetaquegueti quepatsi, otsoroanaquequea otaganaanaca ochoocatanaque opitsaraquiacotanacaqueate oitsoqui, oconoaca ochoocaque 30, otsipa 60, otsipa ochoocaquequea 100.” ");
INSERT INTO cotNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iroompaquea icanqueriquea: “Choocagueti piguempita pinquemantavaquempaca, pinquemeja.” ");
INSERT INTO cotNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ariquea yoayoaitanajiquea maasanopae, aparoquea icantaja Jesoshi itsipatsipaitajariquea itsatacaanejia, aisa itsipa oguijaguijaiquerica. Iriatimpajia icanqueriquea: —¿Taaquea opajita piquempetacaaguetacaca incajaranqui? ");
INSERT INTO cotNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iriatimpa icanqueriquea: —Aviguentijia tsajiaquerone imaica queroquea icotani Aapani Irioshi imajirontagueti, teetari ironigaantajivetemparoji paesatoniqui. Iriraquea itsipajia manaquea nonquejetacaaguetaquenempari maasanopae, ");
INSERT INTO cotNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","cameetsanijite iramenamenaivetanaquempaquea, cotanquitsiquea aato oconijatimotiri; Inquemaquemaivetanaquempaquea aisa, cotanquitsiquea aato itsajiavaquerotsi, aatoquea ipitsocashijigana noshetacotsitajerime igovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Icanqueriquea aisa: —¿Teempate pinquemajiavaqueroquea ocatica noquejetacaacaca incajaranqui? Iroosacanica, ¿querocampate pincojiaquempani pinquemajiaquerogueti ogonoropae nonquejetacaaguetaquemparogueti? ");
INSERT INTO cotNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iriraquea oananquitsica impishoncaguite iriguenti quempecaroca tsavetantiroca Iguenquetsatsare Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iconoajiaca caquintejia iroguenti iquempejiacaroquea oitsoqui asacaraaguiguetananquitsica quenavoquirontsiqui. Iquemisantajiaqueroquea Iguenquetsatsare Aapani Irioshi, cotanquitsiquea icoraquetashiqueriquea Satanashi ipeacotacajaijaari maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iconoajiaca itsipa iroguenti iquempejiacaroquea oitsoqui asacaraaguetananquitsica mapiporoquiqui teemajaca onchoocamajateji ogamiguitere quepatsi. Iquemajiaqueroquea Iguenquetsatsare Aapani Irioshi ishineventamajajiavetavacaroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cotanquitsiquea teequea inquemisantamajateroji, mana iquejetacaro panquirentsi teeca onquijamajateji ovarishitsa, jero ipeacojianajaroquea taampina. Iroompaquea otiavaetanacari atsipetagantsi, irooca icatsimatimentajiqueriquea Iguenquetsatsare Aapani Irioshi ariquea icohicoitanaja yovashiantajianajiroquea itsaroventavecaca. ");
INSERT INTO cotNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Itsipa iroguenti iquempejiacaroquea oitsoqui asacaraaguetananquitsica samerentoqui. Iquemisantajiavecaroquea Iguenquetsatsare Aapani Irioshi, ");
INSERT INTO cotNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","cotanquitsiquea irooqueate itsipatavajiroquea iquenquejajiavajiroquea maasanopae choocaguetatsica quepatsipaequitica, aisa ishineventajiavajari imentaquitsite irooca aisa taaca opajitapae ajaararontsipae. Teequeate inquenquejacojiajeroji Iguenquetsatsare Aapani Irioshi, iroguentiquea iquenquejajiaquequea irajaarantajiaquempaquea. Querocampate incojiaquempani intsaroventamajajiaquemparigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Cotanquitsiquea chooca itsipa iconoagarantajiaca iroguenti iquempejiacaro asacaraaguetananquitsica ocamiguitetapojigueti quepatsi. Iquemisantajiavaqueroquea Iguenquetsatsare Aapani Irioshi, yaajiavaqueroquea, iroompaquea arimpaqueate iquemisantamajaguitironi. Iconoagarantajiacaquea ichoocajiaque cameetsa iquempejiacaroquea tsoroananquitsica choocatananquitsica oitsoqui 30. Itsipa iquempejiacaroquea choocatananquitsica 60. Itsipa caavijica yanaaque ichoocamajajiaque cameetsa iquempejiacaroquea choocatananquitsica oitsoqui 100. ");
INSERT INTO cotNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Icanqueriquea aisa: —Oraquea itsivojitirigueti tsivorentsi ¿arimpate isasaviacojitiriquea chomoqui? ¿Arimpate yoguisavicacojitiriquea osevatatacagueti shitamencontsi imaantajitaca? Teequeate. Iroguentiquea yoguisavicacojitiriquea jenoquijaniqui cameetsanijite intsivotacojiaquerinijite maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ariquea oquempetaca taaca opajitapae senacaguetanquitsica imaica oncoramanitapojajegueti ironigaantajiqueroquea. Aisa taaca opajitapae teeca intsajiteroji imaica oncoramanitapojajegueti intsajiqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Choocagueti piguempita pinquemantavaquempaca, pinquemeja. ");
INSERT INTO cotNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Icanqueriquea aisa: —Pinquenquejamajajigueroja piquemajiavaqueca. Querocagueti pincotsiterini itsipa ariquea inquejetacaajitaquempi aviatimpajia, ariquea iranaacaavaequempiro. ");
INSERT INTO cotNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quericaca tsatavaqueroneca icantajiquerica intsatacaajitaqueriquea otsipapae. Quericaca teeca irininteji intsatavaquero, iraapitsatsijitavaqueriquea itsavecaca. ");
INSERT INTO cotNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Icanqueriquea aisa: —Imaica nontsatacaamajataquempiroquea aisa queroquea icota imajirontagueti Aapani Irioshi, iroguenti oquejetacaroquea tirigoitsoqui. Yoanaquequea aparo caquinte ipishoncavoncaquitanaqueroquea tacororororo tacorororo itsitacaguetanaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Oraquea iteroncanaquerogueti yoanaji itsovironaquitequi, iroompaquea opitsecanaji imaanaji, osavincaguitetanajigueti ipityaquirejanaji. Ocaraguitejavaetanaquegueti savincaguiteri otseequitanaquequea otsoroanaque, cotanquitsiquea iriatimpa teequea intsatavaqueroji querocaca ocotanacani otsoroanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Inchiquiojiquea otsoroanaquequea quepatsiqui, ochoocatanaquequea oguiji, ariquea agataganajanaca ochoocatanaque oitsoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oraqueate osamparijencatanaquegueti yoanaquequea pishoncavoncaquitanaqueroca ipesacoqueroquea yaanaquero sampamiriaquitananquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Icanqueriquea aisa: —¿Imaicaquea taaca oquejetacaroquea imajirontagueti Aapani Irioshi? ¿Taaca nonquempetacaajemparo? ");
INSERT INTO cotNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ariquea nonquempetacaajemparoquea oitsoqui moshitaasa. Oraquea oitsoqui moshitaasa caaviji anaaque chaamirijaquijaniquivaequequea anaaguequeroquea otsipapae oitsoqui ivintyacajitica quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Cotanquitsiquea ivintyacajitirogueti otsoroanaque agajempejanaca ocanca anaaguequeroquea otsipapae panquirentsipae chaamirijaquijaniquitatsica oitsoqui. Otsegotsegoatanaca oquempetanajaroquea inchato, itsimampeantajiajaro tsimeripae. ");
INSERT INTO cotNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ariquea iquejejiaqueriquea imaica Jesoshi itsatacajaiaquerigueti Iguenquetsatsare Aapani Irioshi iquempetacaaguecaroquea taaca opajitapae, maasanopae yagavejajiavaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Teequea intsatacaajigueriji intati, taaca ininqueca intsatacaajiaqueri iquempetacaaguecaroquea. Cotanquitsiquea irioca choocatajatsi itsatacaanejia yoguisotoamajataqueneri maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iroompaquea itsaparoncaguitetanajigueti icanqueriquea itsatacaanejia: —Iintsija jaame intatiqueroqui. ");
INSERT INTO cotNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iquenquetsatacaajianajiriquea omporoguijajianquitsica, itaquiajatacojianajiri itsatacaanejia icocaniquea itetaca. Itsipajia oguijaguijaitacotanaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Incajaranquiguitetanaquegueti ochovigaguitetapojaquequea choviga jeoc jeoc jeoc, ariquea ocotanaca ovorevoreatanaca otserajatanaqueroquea oja quenajarontsiqui irooshivetapojaca ontamorencanaquempamequea. ");
INSERT INTO cotNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iriraquea Jesoshi yojocanacaniquea tin ovataquipojacagueti itiinatacaroquea tiinarentsi. Itinaitariquea icanqueri: —Tsatacaantantatsica, ¿arimpate teequea pintsateji irooshipojishiatsi ojocajajiguempanishiatsi? ");
INSERT INTO cotNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Icatiitsitanacaquea icanquero choviga: —Pimpejaencatanajempaja. Icantsitaroquea aisa iniromotija vorevoreatanquitsica icanquero: —Pinchopecajatanajempaja. Ari ocotanaja opeanaja choviga, ari oquempetaca iniromotija ochopecajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ariquea icanqueriquea itsatacaanejia: —¿Quero ocotacani pitsaroantanacaca? ¿Arimpate tequeratampate pintsamajajiguena nagavejamajati? ");
INSERT INTO cotNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Arimpaquea itsaroamajajianaquequea icantavacaajianaca: —¿Taa ipaji iricatica? Jero oquemisantamajatancarica choviga aisa iniromotija. ");
INSERT INTO cotNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ariquea yarejerejeipojacaquea intatiqueroqui itsinampijaatacojiapojacaquea iguepatsitequi Gararaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Irooquea yanijirejavetanaca Jesoshi yameniri icoraquepoji aparo caquinte ishaquiacariquea ampatsini, iquenapojiroquea imperitamoroqui yojoquijitantapinijitarica metojatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ariqueate iguinteniguitaniquea oraniqui. Teequea quericaca agavejimatajerineca iroishoteri, teetari agavejeriji cavorejatsari. ");
INSERT INTO cotNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yoishotantajivecari cavorejatsariqui iguitiqui aisa iracoqui itsatitsativaetaqueroquea itsinatsinavaequeroquea pioquire, pioquire, pioquire, otsatitsatiavaetanacaquea cacaaporoquijaniqui. Teequeate quericaca agavejimaterineca. ");
INSERT INTO cotNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Icocaniquea yanijivijiti savincaguiteriqui aisa pitsecariqui. Yoavaeguetanaquequea otsempipaequi aisa imperitamoroqui yojoquijitantapinijitarica metojatsica, icajemamajatatiguinimaja jeeee. Yaitsitaroquea mapi tsaampiri itotsitaquea quitente quitente quitente. ");
INSERT INTO cotNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Irooqueate yamenacotsitavacarigueti Jesoshi ishiashitanacariquea quempeji iguerovempojacari. ");
INSERT INTO cotNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Iririjencavaeque icanqueri: —¿Querocaquea pincoquenani, Jesoshi Irijanite Irioshimajaca Anaantamajatatsica? Iintsijate aatoja patsipetacaanatsijate. ¡Pimpintsatacogajoitenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Icantantacaroca ocatica irooriji icanqueri Jesoshi ampatsini: —¡Pisotogue, ampatsini, povashianteriqueate iricatica! ");
INSERT INTO cotNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ariquea icanqueri Jesoshi: —¿Querocaquea pipajitani? Icanque iriatimpa: —Nopajita Caramirincatatsica, nocaramirincavaequetari. ");
INSERT INTO cotNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yapijipijitaqueri icantiri: —Iintsija aatojate pitigarancajianatsijate osamani. ");
INSERT INTO cotNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ariquea ichoocajiaque chancho oraniqui otapiqui ishecajiaca, icaramirincavaeque icanca. ");
INSERT INTO cotNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iquenquetsatsitanacaquea ampatsini icanqueri: —Iintsija ariguentiquea pintigarancajiaquenaquea noshaquiajiaquempariquea chanchojia. ");
INSERT INTO cotNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iriraquea Jesoshi icanqueriquea: —Intsiquetirote poapoaitanaque. Yovashiampanajantiri ishaquiavecaca irioqueate yoashiyoashiivetanacari chanchojia. Irooquea ishaquishaquiivetapojacari, ariquea icohicoitanaca isaquiritsaevaetanaque ojeguironcapojacagueti yanoyanoitanaca itanquiretanquireitanaque yojocajajiapojaca, iteroncajiaca maasano. Maasanojia icarajiaque 2,000. ");
INSERT INTO cotNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Irooquea yamenajiavaqueriguetiquea quempoguijirica itsaroajianaque ishiashiaitanaca yoayoaitanaji icamantajiapojiri ontaniqui iguintenijiacagueti itsitacaguetapojiroqueate, iquemacotantajiacarica choocajiatsica acaniqui aisa choocajiatsica quempejipaequi. Isotosotoitanaque iramenajiaque taa opajita. ");
INSERT INTO cotNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yoayoaitanaquequea ichoocaquegueti Jesoshi, iroompaquea yarejerejeipojaca yamenajiapojiriquea ishaquiavecaca ampatsini savicaji quitsaataja quenquejanaji quempemajatanaja iroaqueragueti, ariquea icohicoitanaca itsaroajianaque. ");
INSERT INTO cotNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Iriraquea amenajiaqueroca maasanopae icamantajiavaqueriquea querocaca icoqueriniquea iroaqueragueti yoguisotojainirigueti shaquiavecarica caquinte, aisa querocaca icoquerini itigarancajiaquerigueti ishaquiajiavetacarigueti chanchojia yojocajajiacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iroompaqueate iquemajiaquitiguiquea itsavetantajiaquerigueti, iriatimpajia yamanamanaiqueriquea Jesoshi iroanajeniji irovashiantsitanajeriniji iguepatsite. ");
INSERT INTO cotNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Irooquea itetanajaquea Jesoshi quenajarontsiqui iroanaje, iriraquea ishaquiavecaca ampatsini icanqueri ininque intsipatanaquempari. ");
INSERT INTO cotNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Cotanquitsiquea Jesoshi tee irishineteriji, mana icanqueri intati: —Poanaje pitsovironaquitequi, pigonoroqui, pincamantapojajerija pintsavetampojajeroquea maasano queroquea icoquempini Aapani Irioshi ipintsatacotajimpigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iriatimpa yoanajiquea iparianacaro itsavetantaqueroquea oraniqui guinteninintsipaequi Tecaporishiqui, yoguisotojaiapojaqueneri ipintsatacotacarigueti Jesoshi. Maasanoquea mana yamenamenaitanaque intati. ");
INSERT INTO cotNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ariquea imontejacotanaja Jesoshi intatiqueroqui yomporoguijaventapojacari icaramirincavaeque caquintejia, ariquea ichoocapoji oraniqui otsapijapojacagueti iniromotijaqui. ");
INSERT INTO cotNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iroompaquea icoraquepojaque shirampari pajitatsica Jairo. Iriatimpa iriguenti jivatanquitsica shinagogaqui icapiocantajiacaca joriojia. Ariquea yamenapojirigueti Jesoshi igueroventapojacari, ");
INSERT INTO cotNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","icampojiri: —Irooshipoji ometoje norijanite. Jaameshiatsi pimpamitaquitenaroshiatsi ompeanajempanijite onchoocatajeniji. ");
INSERT INTO cotNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iriraquea Jesoshi yoanaque yoguijatanaqueriquea, ariquea yoguijaguijaitanaqueriquea icaramirincavaeque caquintejia itirorencaventajianacariquea oraniqui itsinacajianaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ariquea ochoocaque aisa oraniqui aparo manquigarentsi ashinoncaavaetanquitsica ososoajavaetini coramani, ariquea ocaratacovaetanaqueni 12 ajagantsiteni. ");
INSERT INTO cotNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atsipevaecaqueate yaavintanavecaroqueate aavintantatsica teequea ompeajempaji arimpaquea ogatsitanaca, niganquiquea oteroncamajatanaqueriquea omentaquitsite, ejempacotia oanaca. ");
INSERT INTO cotNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oquemacoqueriquea Jesoshi oanaquequeate ontaniqui ichoocaquegueti iriatimpa oconoajianacari, oquempejitanacariquea ocoraquetashipojiri itaquiqui ochagatsaequitsitavaqueri ivanquemaero. ");
INSERT INTO cotNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Oquenquejitsitanacaquea incajaranqui ocanque: “Iroguenti nonchagatsivetaquempari ivanquemaero nompeanajempaquea.” ");
INSERT INTO cotNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Irooquea ochagataquitiguiroquea ariquea ocotanaja osanticojatapojaji ososoajare, oquematsinotavaca jac peamajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iriraquea Jesoshi itsatavaqueroquea ipeantajaro iragavejane ipitsocanacaquea yamenamenaiqueri omporoguijaventajiacarica icanqueriquea: —¿Taaquea chagatsitaquenaro novanquemaero? ");
INSERT INTO cotNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Icantajianaque itsatacaanejia: —Pamenavecaqueate itsinacajianaquempi, pogaavacaquea picanque: ‘¿Taaquea chagatacoquena?’ ");
INSERT INTO cotNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iriatimpa yamenamenaitanaque taaca chagatacoquerica. ");
INSERT INTO cotNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iroatimpa otsaroamajatanaquequea ompioncavaetanaca, otsatavajitari peamajataja. Ojocavaetapojaca iriatimpaqui ogueroventapojacari ocamanqueriquea maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iriatimpa icanqueroquea: —Orijani, irooriji pavenquenatarite naatimpa, irootari piveantanajaca. Imaicaquea poanaje, pishinevaetajempa aatotarite apijitajimpi aisa. ");
INSERT INTO cotNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iroompaquea quenquetsatatsitiraja Jesoshi icoraquecoraqueipoji itsipapae, iquenajiapoji itsovironaquitequi jivatanquitsica shinagogaqui, icampojiri: —Jac metojaque porijanite, ariotapojaque pasereajiritsi Tsatacaantantatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Cotanquitsiquea Jesoshi iquemaquerigueti, ipitsocashitari jivatanquitsica shinagogaqui icanqueri: —Aato pitsaroguitsi. Mana paventanaquena naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tee iroguishinejeri itsipajia iroguijaguijaitanaqueri, iriguentiquea itsipatsipaitanaca Peerero, Santiago aisa iriguentijeguite Santiago pajitatsica Joanca. ");
INSERT INTO cotNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oraquea yarejerejeitapojajagueti itsovironaquitequi jivatanquitsica shinagogaqui yamenapojiri ampenejencavaejiaca iraajiaca cajemajiaque oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iquijanaquequea intsompoguiqui icantajiapojiri: —¿Taampa opajita piraantajiacaca picajemantacaca? Teetarite ometojenica, mana omaaque intati. ");
INSERT INTO cotNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ariquea icohicoitanaca ishirontimentajianacari. Ariquea yoguisotosotoitajiri maasano sotsiqui, iriguentiquea itsipataja jivatatsica aisa imanquigare, iriguentijia aisa itsatacaanepae itsipatsipaitacaca incajaranqui, iquijaquijaitanaquequea ojoquijicagueti irorijanite. ");
INSERT INTO cotNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yacatsavacoquero icanqueroquea: —Talitha, cumi —ocanquequea: “Chaajaniquitirajaca, noncanquempi, pincatianaje”. ");
INSERT INTO cotNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Irooquea icantaquitigui ariquea ocotanaja otancorejanaji ocatianaja anijivijitaji. Iroatimpa arejetacaro 12 ajagantsite. Iriatimpajia yamenamenaitanaquequea intati. ");
INSERT INTO cotNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Cotanquitsiquea Jesoshi icantajiguiri aatoquea icamantitsi. Icantsitari aisa irojocajiaquenero oshecatajempata. ");
INSERT INTO cotNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ariquea yoanaji Jesoshi iguinteniqui, itsipatsipaitanajari itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aapojajagueti savincaguiteri imagorejantajitaca yoanaque shinagogaqui icapiocantajiacaca iparianacaroquea itsatacaantanaque. Iriraquea quemajiavaquerica yamenajianaquequea intati icantajianaque: —¿Queroquea oquenapojini maasanopae ocatica iquejetantacaca iricatica? ¿Taa opajita ocatica itsatica ganejencaro yojocajiquenerica? ¿Quero ococani yagavejancaca yonigaantaguequeroquea oacaantantatsica intati? ");
INSERT INTO cotNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Teecajate irioquea iricatica caripintero, irijanincaca Maria? Iriraquea iriguentijeguitepae iriguenti Santiago, Jose, Jorashi aisa Shimo. Ariquea oquempejiaca itsijoitepae iroatimpajia aisa oguintenijiaca acaniqui, amenamajajiguiroquea aatimpajia. Ariquea teequea irinintajigueji inquemisantajiaqueriji, iroguenti icatsimajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Cotanquitsiquea Jesoshi icantajiaqueri: —Iriraquea tsavetantiroca icanquerica Aapani Irioshi ishineventajitavajari querocagueti yoanaqueni osamani, cotanquitsiquea ichoocavecagueti iguinteniqui, teequea irishineventajitempariji, aisa teequea inquemisantajigueriji ijitanejia aisa guinteninitimotacarica itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ariquea teemajaca ironigaantajeroji oacaantantatsica intati oraniqui iguintenivetacagueti. Manaquea ipamijiaqueriquea aparopae ashinoncajajianquitsica, yogueshijiajiri. ");
INSERT INTO cotNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ariquea yamenanaque intati, yamenaque teequea inquemisantajiajeriji, manaquea icantajiaque: “Caaricaja.” Ariquea Jesoshi yoayoaguetaquequea irooshipojigueti oraniqui iguintenijiacagueti itsatacaantavaetaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ariquea icajemaqueriquea itsatacaane carajianquitsica 12, itigarancajiaqueriquea iroaroaitanaque intsipatavacaanaquempa mavite mavite, yagavejacaajiaqueriquea iragavejajiaqueri ampatsinipae. ");
INSERT INTO cotNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Icantajiavaqueriquea: “Aato paimatitsi. Aatoja paajiguitsi pitsaratote, pisheca aisa pimentaquitsite. Iroguentiquea pigotiro. ");
INSERT INTO cotNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pincaviguitijianaquempaja, cotanquitsiquea aatoquea paajiguitsija mavite piitsaare, iroguentiqueate piquitsaajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Querocagueti oraniqui poapoaitanaqueni incajemajiavaquempigueti pimaanaque itsovironaquitequi, poapoaitanaquequea pincoquempaniquea pimaimojiaqueri arejevaetapojajempa savincaguiteri poapoaitantanajempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Oraquea querocagueti poapoaitanaqueni oraniqui aatoguetiquea ishineventajiguimpitsi, taampina poapoaitanaque, cotanquitsiquea iroquetitaja pantecamajatanaqueroja quepatsivane pagatiquitsitapojaquerigueti, iroonijite iramenantajiaquempanijite iroguenti yantaguishejiaqueroquea covaeguisherentsi, teetarite irajaiavaquempiji irishineventajiavaquempiji. Arimajaquea oncoramanitapojajegueti arejetapojajempagueti incatsimatantaquemparica Aapani Irioshi, caaviji incatsimamajajiaqueriquea irirajia teeca irishineventajiavajempiji, anaamajataqueroquea incatsimamajajiaquerigueti guintenijiavetanquitsica coramaniquitica Soromaqui aisa Gomoraqui.” ");
INSERT INTO cotNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iriatimpajia yoayoaitanaquequea itsavetantajianaque, icantajiaqueri maasano irovashiantajianaqueroja maasanopae covaeguisherentsi ipeacaaguishevaetacaca incantashitatijaianajempa. ");
INSERT INTO cotNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yoguisotoajiaqueriquea oshequi ampatsinipae, aisa ipantantajiacari orejiqui oshequi joquijiripae, ipeajianaja. ");
INSERT INTO cotNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Maasano iquemacojiaqueriquea Jesoshi, jero iquemacotantacarica majirontatsica Erorishi iriatimpa. Chooca cantajianquitsica: “Tancorejanajishiatsi Joancani Viñacajatantatsica, jero yagavejamajatantacaca yonigaantaguequeroquea oacaantantatsica intati.” ");
INSERT INTO cotNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Itsipaquea cantanquitsica: “Iriguentiquea coramaniquitica tsavetantatsicani pajitatsica Iriashini.” Itsipapae cantanquitsica: “Iriguentiquea tsavetantatsica, quejecarica irirajia tsavetantajiatsicani coramanipaequitica.” ");
INSERT INTO cotNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oraquea iquemajiaquerigueti Erorishi icantajiaquegueti imaica, icanque iriatimpa: —Iriguentiquea Joancani nojitorejacaanqueca, tancorejanajishiatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Oraquea chapinqui iriraquea Erorishi yaacaantaqueri Joancani, yoishotacaanqueriquea cavorejatsariqui, isantanatacotacaanqueri, irooriji yamenaquequea icantomajimentavecari Eroriashi yaapitsaquerigueti iriguentijeguite pajitatsica Jeripe. ");
INSERT INTO cotNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Iriraquea Joanca icanqueriquea Erorishi: “Tee ari incojitempaji paapitsaquerigueti imanquigare piguentijeguite.” ");
INSERT INTO cotNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Oraquea Eroriashi ariquea ocatsimatanaqueriquea Joanca onintaveca irimetojaitsijiquemparimequea, cotanquitsiquea querocampate oncoquerini. ");
INSERT INTO cotNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Itsaroacaacaritarite Erorishi itsaquequea iriguentiquea cameetsari, iriguenti igomajamajare Aapani Irioshi, jero yamenamajatantacarica aatonijite queroca icojitirini. Oraquea itsavetantavaetigueti Joanca inintanirovecaro, cotanquitsiquea tee intsateji querocampate incoquempani. ");
INSERT INTO cotNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iroompaquea aapojatiga savincaguiteri ometojacaantantaquemparica. Iroguentiquea aapoja isavincaguiterite Erorishi. Iriatimpa itiacaantaguetaquequea taaca opajitapae shecatsipae, ariquea icajemajiaqueriquea imajirojiate joriojia, aisa imajirojiate coaretajia, aisa anaantajiatsica guintenijiatsica oraniqui Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ariquea ishecajiaca, oquijapojiquea orijanite Eroriashi otsamaropoji opitsopitsovaetanacaqueate. Irooquea yamenaquerogueti Erorishi aisa maasanopae itsipatsipaitacaca ishecajiacagueti, ishineventajiacaroquea. Iroompaquea icanquero: —Imaicaja pamanenajate taaca pininqueca, naatimpa nojoquitsitempiroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Icantsitajaro aisa: —Imaica noncanquempi arimajaca nojocaquempiroquea taaca pamanaquenaca, aatotarite namatavijimpitsi. Quempetaca pamanenagueti nojocagaranquempiro nashintaguecaca, nontincavirejitempiroquea niganqui. Incatsimatimentenarota Aapani Irioshi aatogueti nonetsanatiro nocanqueca. ");
INSERT INTO cotNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Osotoapanajanti oanaquequea ocantapojaquero iniro: —Iinani, ¿taaquea opaji namanaqueri? Iroatimpa ocanqueroquea: —Iroguentiquea pamanaqueri iguito Joanca Viñacajatantatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iroatimpa oitsitanacaquea oquijitsitanaja ichoocaquegueti majirontatsica Erorishi, ocanqueriquea: —Iroguenti noninque pojocacotsitenaro imaica iguito Joanca Viñacajatantatsica shimencoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ariquea icotanaca iriatimpa ishimampojancanaca, cotanquitsiquea iroorijite icanqueroquea, aisa iquemajiaqueri maasanopae icajemajiaqueca, tee irinintenica incantero: “Aato.” ");
INSERT INTO cotNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Irootarite itigaranquitsitantacarica coareta iroanaque ontaniqui isantanatacojitaquerigueti Joanca iramacoqueroquea iguito. ");
INSERT INTO cotNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yoanaquequea ijitorejaquitiri santanaqui iroompaquea yamacoquenero yojocacopojaquenero, irooqueate oguipitsocacoqueneroquea iniro. ");
INSERT INTO cotNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oraquea iquemacojiaquerigueti itsatacaanejia Joanca, icoraquetashijiajiri yaajianajiro itsino iquitajiajiro. ");
INSERT INTO cotNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iroompaquea icoraquecoraqueitaji itigarancanejia Jesoshi itsipatsipaipojajari icamampojiri maasanopae yantaguetaquitica ontaniqui aisa maasanopae itsatacaantaguetaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cotanquitsiquea coraquecoraqueitanatsiquea icaramirincavaeque caquintejia, itsipapae yoayoaitanaji, teequeate iragavejajiguempaji Jesoshi irishecajiguempaji. Irootaquequea icantantacarica Jesoshi itigarancanejia: —Jame ontaniqui osamani teegueti inchoocateji caquinte, pimagoremagoreipojaquequea. Aviguentijia nontsipatsipaitanaquempaca, aatojate yoayoaititsija itsipapae. ");
INSERT INTO cotNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ariquea Jesoshi itsipatsipaitanacari itehiteitanacaquea quenajarontsiqui yoayoaitanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cotanquitsiquea irooquea yoayoaivetanacaquea yamenajiavaqueriquea itsipa caquintejia itsajiavaqueri. Yoayoaitanaquequea iriatimpajia, aisa yanijijianaque iriquetica arejerejeitanquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iroompaquea itsinampijaatacojiapojaca. Irooquea yanijirejavetanaca Jesoshi yamenajiapojiriquea icaramirincajiaque caquintejia, ipintsatacojianacariquea maasano, yamenajiaqueriquea aparo yapintajiaca yatsipevaejiacaqueate quempejiaca oveja teeca inchoocateji quempoguijajiguerineca, ariquea iparianacaroquea itsatacaaguetapojiri. ");
INSERT INTO cotNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Imaicaquea ijaguitevaetanaji catsirincaiteri, iquempejiquempejiitanacariquea itsatacaanejia icanqueri: —Jac jaguitevaetanaji catsirincaiteri. Ocaniquiquea ocaniqui teequea quericaca choocatatsineca, ");
INSERT INTO cotNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","iroosacanica pintigarancajiajeri maasano irirajia iroaroaitanajetajate ontaniqui guinteninintsipaequi irooshitacoguetanquitsica cameetsanijite irivegarajiaquenijite ishecajia irishecajiaquempanijite. Ocaniquiquea ocaniqui teetarite onchoocateji taaqueate irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Cotanquitsiquea Jesoshi icanqueriquea: —Pojocajigueneritsija aviatimpajia irishecajiaquempaca. Iriatimpajia icanqueriquea: —¿Arimpate pininque noanoaitanaque novegarajiaquiteneri irashijia maasano irishecajiaquempaca? Ovegaravaecatari 200 tenario. ");
INSERT INTO cotNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ariquea icanqueriquea Jesoshi: —¿Quero ocarashequiaque pan pashijia? Iintsija poapoaitanaque pamenajiaquiterojate querocaca ocarashequiavaeque. Ariquea yoayoaitanaquequea yamenajiaquitiro, iroompaquea icoraquecoraqueitaji icantajiapojiri: —Chooca 5, aisa shima mavipaquite. ");
INSERT INTO cotNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Icanqueriquea Jesoshi: —Iintsija pincantajigueriquea maasano irisavisaviitaquequea janamaroncaroqui cataro, ariquea pomporoguijaguequeriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iriatimpajia isavisaviiquequea iconoajiaca yomporoguijajiaca 100, itsipapae icarajiaque 50. ");
INSERT INTO cotNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iroompaquea iriraquea Jesoshi yajiricajiaquero pan caratanquitsica 5 aisa mavipaquite shima, ipaguitetanaqueroquea inquite yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea icotarejaquero pan, yojocajiaqueneri itsatacaanejia, irioquea gaavaqueneri yojocajiavaqueneri maasano. Ariquea iquempetacaacariquea shima iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ariquea ishecajiaca maasano iquemajianaca. ");
INSERT INTO cotNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iroompaquea iriraquea itsatacaanejia icapiocajiajiro choocatajatsica pan aisa shima, itetajiro cantiriqui tseraiquipae ocaratacovaetaji 12. ");
INSERT INTO cotNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Icaramirincajiaque 5,000 shiramparijia quenquevarijia shecajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ariquea itigarancajiaqueriquea Jesoshi itsatacaanejia icantajianajiri intejianajempaquea quenajarontsiqui irijivajianaje irimontejacojianajempaquea intatiqueroqui Vetsairaqui. Icantanajiri capiocajianquitsica iroaroaitanaje. ");
INSERT INTO cotNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ariquea yoayoaitanajiquea maasano, iriatimpa yoanaquequea otsempiqui iramaneri Iriri. ");
INSERT INTO cotNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Oraquea opitsecanajigueti iriraquea itsatacaanejia niganquijatacovaetanajiquea. Ichoocaque Jesoshi apaniro quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iriatimpa yamenacotsijiavacariquea ipanquenanajiacaro ivetincajajiavaquero imagojianaquequea, ochovigaguitevaetanaquetari choviga jeoc jeoc, oguipiguipiacovaetanaqueriquea. Iroompaquea omancharejaguitetanajatiga savincaguiteri icoraquepoji yanijijatapojiro jenoquija iniromotijaqui iravisajianaquerime. ");
INSERT INTO cotNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Iriraquea itsatacaanejia yamenitsijiavacariquea yanijijatapojiro ojenoquijaare, ijiqueriji sashinti, icajemajianaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maasanoquea yamenajiaqueri itsaroajianaque, cotanquitsiquea iriatimpa icanqueriquea: —Pintampishishirentajianaque. Naroguenti, aatoquea pitsaroajiguitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ariquea itetanaja iconoapojajari, ariquea ocotanaja choviga jac santiconi. Iriatimpajia yamenamenaitanaquequea intati. ");
INSERT INTO cotNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yamenajiavecaroqueate incajaranquiqui yoshequiaquerogueti pan, cotanquitsiquea teequea intsajigueji queroquea icocaniquea iriatimpa yagavejavaequeguetiquea maasanopae, manaquea iquishoshirentanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iroompaquea imontejacojianajaquea intatiqueroqui yarejejiapojajaro Jenesarequi, yagatacojiapojaji. ");
INSERT INTO cotNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yanijirejajianaquequea, maasanojia itsajiavaqueriquea iriguenti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jero yoayoaitantajianacaca ishiashiaitanacaquea itsitacaguitejavaetanaquero yaacojiaquitiri ashinoncajajianquitsica, yaajianaqueneriquea irogueshiguetajeri. ");
INSERT INTO cotNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Querocagueti oraniqui iquenaguetanaque Jesoshi guinteninintsipaequi chaajaniquiguetanquitsica, iniroguetanquitsica, jero aisa iniganquitejirepaequi, yaacotsijitanacariquea ashinoncajaguetanquitsica yoguisavicajiqueri oraniqui quenavoquirontsiqui. Icantajiavaqueri: —Intsishiatsi, Nomajirote, noninque inchagatsijivetavaquempiro oshipaquijaniquiqui piitsaare. Maasanopaetari chagatsijiaquerica ipeaguetanaja. ");
INSERT INTO cotNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Iroompaquea icoraquecoraqueiquequea pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, iquenaquenaipojiquea Jerosarequi, icapiocaventajiapojacari Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yamenajiapojiriquea itsatacaanejia iconoagarantajiacaquea teequea irinetsanajigueroji yamejiacaca, mana ishecashecaica intati teequea inquivacomajajiguempaji, yamenajiavecaroquea ocoguishequeri yajiricajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Irirajia pariseojia aisa maasanopae itsipajia joriojia yoguijatacojiaqueriquea choviquijianaquerica, aatogueti iquivacomajataquea aatojate ishecajiatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aisa yoayoaitigueti yojocantaguetirogueti taaca opajitapae ishecajiguetacaca icoraquecoraqueitaji iquivaquivaitapoja. Aatogueti iquivaquivaitatsi, aatoquea ishecashecaitatsi. Aisa taaca opajitapae yoguijatacojiaqueri choviquijianaquerica coramani, iquivajiguiroquea ichovintyoriquitepae, igatsantsanaquiritepae, cavorejanaquiripae, aisa inorijantacaca.) ");
INSERT INTO cotNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iroompaquea iriraquea pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini icanqueriquea Jesoshi: —¿Querocaquea icojiacani pitsatacaanejia teequea iroguijatacojigueriji choviquijianacajica inquivacomajajiaquempa? Mana ishecatacojiacaroquea iraco ocoguishejiaquerigueti yajiricajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iriatimpa icanqueriquea: —Itampaticamajataqueroquea tsavetantatsica Isaiashini itioncacojianaquempigueti coramani aviatimpajia cameetsatamampeajiatsica, icanquequea: ‘Iricatica caquintejia ishinetseraventavequena, cotanquitsiquea manaquea ichoocashirentavaetaque osamani. ");
INSERT INTO cotNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Itsaroventamampeajiavetaquenaquea, cotanquitsiquea itsatacaantajiguica iroguenti icantajiguica caquintejia irinetsanajiqueca.’ ");
INSERT INTO cotNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aviatimpajia pojocajianajiroquea icanqueca Aapani Irioshi, iroguentiquea quisho poamajajiaque itsatacaantajiguica choviquijianaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Icanqueriquea aisa: —Caavijiquea piticaarejajiaquero icanqueca Aapani Irioshi cameetsanijite poguijatacojiajeronijite pamejigaca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pamenamajajiavecaroquea icanqueca Moishishini: ‘Pinquemisantamajajiaquerijate piri aisa piniro, aatoquea pipigatsajigaritsija.’ Icanque aisa: ‘Iriraquea tsavejencatirica iriri irooca iriniro irimetojitsijitempari.’ ");
INSERT INTO cotNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Cotanquitsiquea aviatimpajia manaquea picantashitatijaiaqueroquea, picantapinijiaque cameetsavaeque shirampari incanqueri iriri irooca iriniro: ‘Aatoquea nagavejitsi nojocaquempi picoguitejacoqueca, irooriji maasanopae nojocaquempimeca iroguentiquea corova.’ (Oraquea corova ocanque: ‘Nojocashiquenemparica Aapani Irioshi’). ");
INSERT INTO cotNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Incanquerigueti iroguenti corova, aviatimpajia picanquequea aatoja yojoquiniritsija iriri irooca iriniro, aatoja icavintsajajiguiri. ");
INSERT INTO cotNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Piquempejiaquerogueti imaica iroguentiquea povashiantajianaquero icanqueca Aapani Irioshi, irooquea poguijatacojianaque itsatacaantajiaqueca pivaesatiniteni. Cotanquitsiquea teetarite aparoquea onchoocateji ocatica, pantajiaquequea otsipapae quejecaroca. ");
INSERT INTO cotNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ariquea icajemajiaqueri aisa maasanopae, icapiocajiaqueriquea icanqueri: —Pinquemisantamajajiavaquenaja maasano aviatimpajia, pintsajiavaquero noncamanquempica. ");
INSERT INTO cotNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Taaca opajitapae sotsiquitica quijanquitsineca ivagantequi caquinte aatoquea ocovaeguisheshirentiri. Oraquea sotoanquitsineca iriatimpaqui, irootaquequea covaeguisheterineca. ");
INSERT INTO cotNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Choocagueti piguempita pinquemantavaquempaca, pinquemeja. ");
INSERT INTO cotNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ariquea yojocapanajantiri maasano iquijanaquequea tsovironaquiqui. Iriraquea itsatacaanejia icanqueriquea: —¿Taaquea piquempetacaaca incajaranqui? ");
INSERT INTO cotNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iriatimpa icanqueriquea: —¿Teetarite pinquemajiguenaji aviatimpajia aisa? ¿Arimpate teesacanica pinquemajiguenaji nocanquegueti taaca opajitapae sotsiquitica quijanquitsineca ivagantequi caquinte aatotarite ocovaeguishetiritsi? ");
INSERT INTO cotNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Teetarite ariquea ogueji shecatsi shiretsiqui, manaquea otehoteitapojaca tsicotontsiqui mana irishitacojitajero. Iroguentiquea icantajiaqueri imaica cameetsanijite intsajiaquenijite maasanopae ishecajiguetacaca teetarite oncovaeguishetacaanteji. ");
INSERT INTO cotNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Icanqueriquea aisa: —Oraquea sotoapojirica caquinte, irootaquequea covaeguishetaquerica. ");
INSERT INTO cotNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Oraquea intsompoguiqui shiretsiqui ariqueate oquenapoji taaca opajitapae covaeguisherentsipae: iquenquejaguishejigui, yoashijiguiro manquigarentsi tequeratatirajaca irimanquigajitemparo, yaitsitantajigui, imetojantajigui, yoashijiguiro manquigarentsijia imanquigajitacaca, ");
INSERT INTO cotNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","inintsiguetiriquea yashintaguecaca itsipapae, isavicaventajiguiro covaeguisherentsi, yamatavijantajigui, teequea irinejashitemparoji manquigarentsi, icatsimatimentiriquea igonoropae yamenaqueguetiquea caaviji yagavejavaequequea, iquenquetsaguishetantajigui, yaventacojiacaquea, teequea intsajigueji incomajamajajiguempaji. ");
INSERT INTO cotNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maasanopae ocatica ipeacaaguishejiguetacaca manaquea oquenapojiquea shiretsiqui, irootaquequea covaeguishetantanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ariquea yoanajiquea Jesoshi irooshitacoquero Tiro aisa Shirone ariquea iquijapoji tsovironaquiqui, teequea irinintavetempaji inquemacojiterime, cotanquitsiquea teequea iragavejeji iromanacotempaji. ");
INSERT INTO cotNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ariquea ochoocaque aparo manquigarentsi choocatanquitsica orijanite tequeratatiraja onquenquevaroteji, ishaquiacaroquea ampatsini. Iroompaqueate oquemacoquerigueti Jesoshi oanaquequea amenavaqueri. Ocoraquepojiquea ogueroventapojacari. ");
INSERT INTO cotNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Oraquea manquigarentsi iroguentiquea guiriego, ovoguiquea Shiropenishiaqui. Ocantapojaqueri iroguisotoacoventajero orijanite ishaquiacaca ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Cotanquitsiquea Jesoshi icanqueroquea: —Iriquetitaquea shecamajatanquitsine chaajaniquipaetirajaca. Teequea oncameetsateji aapitsateri chaajaniquirijia isheca, ojoquitenempari ishiishitepae. ");
INSERT INTO cotNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Iroatimpa ocanqueriquea: —Arimajaca, Nomajirote, cotanquitsiquea shiishi iramenajiguerigueti irishecajiguempagueti chaajaniquiripae iroguijavaqueroquea isaviji shitaponcarontsiqui irishecatsopequiguetavaquemparoquea otsopequi. ");
INSERT INTO cotNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iriatimpa icanqueroquea: —Pitampaticamajataqueroquea. Imaica iintsijate poanaje, jac sotoanajiquea ampatsini shaquiavecaroca porijanite. ");
INSERT INTO cotNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Oanajiquea, arejevepojaja otsovironaquitequi amenapojajiroquea orijanite norijaca omencorequi omaantacaca, teequea irishaquiajemparojiquea ampatsini, jac sotoanajiquea. ");
INSERT INTO cotNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yoanajiquea Jesoshi isotoantanajaroquea ichoocaquegueti irooshitacoquero Tiro, icantanajaquea Shironequi aisa Tecaporishiqui, yarejevaetajaquea iniromotijaqui Garirea. ");
INSERT INTO cotNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iroompaquea yaajianaqueneriquea shirampari carenisamaitori, aisa teeca inquenquetsamajavetempaji, icantajiaqueri impamijiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iriraquea Jesoshi itsipatanacariquea tiijai teegueti inchoocajigueji tirorencashijiacarica, ariquea yoguijaachapaquitsitaro iguempitaqui, aisa ijavachapaquitsita ichagatsiqueri inenequi. ");
INSERT INTO cotNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ariquea ipaguitetanaquero inquitequi yaajencataquiti icanqueri: “¡Efata!” (oncanquequea: “¡Pishepirejanajempa!”) ");
INSERT INTO cotNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Irooquea icanquerigueti ariquea icotanaja ishepirejacotanaja, aisa itsirecarejanenetanaja iquenquetsamajatanaji. ");
INSERT INTO cotNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iroompaquea icantajiavecari Jesoshi maasano: “Aatoja picamantitsi.” Cotanquitsiquea arimpate itsavetantajianaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yamenamenaitanaquequea intati maasano icantajianaque: “Maasanoquea yantaqueca cameetsavaeque, iquemacajaiaqueriquea teeca inquemavetempaji aisa inijacajairiquea macanavetatsica.” ");
INSERT INTO cotNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iroompaquea yomporoguijaventajiapojacariquea Jesoshi icaramirincavaeque caquintejia, icocaniquea isavicaventajiaqueri, niganquiquea iteroncacojianaca ishecajia, taampate irishecajiaquempaca. Ariquea icajemajiaqueriquea itsatacaanejia icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nopintsatacojianacariquea irirajia, namenaquequeate isavicaventajiaquenaquea ocaniqui 3 savincaguiteri, niganquiquea iteroncacojianaca ishecajia. Imaicaquea imaica teequea onchoocateji taampaqueate irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Arigueti nontigarancajiavetajempari iroaroaitanaje itsovironaquitequi aajiavaquerinishiatsi itaseane quenavoquirontsiqui, iconoagarantajiacaquea iquenaquenaivaepoji jmm osamani. ");
INSERT INTO cotNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iroompaquea icanqueriquea itsatacaanejia: —Ocaniquiquea teequea quericaca guintenitantemparone. ¿Ariquea querocampate iraajiqueroquea ocaniqui pan irojocajiaquenerica irishecajiaquempaca maasano inquemantajianaquempacate? ");
INSERT INTO cotNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Icanqueriquea iriatimpa: —¿Querocaquea ocarashequiaqueni pan choocatanquitsica? Icanqueriquea: —Ocarati 7. ");
INSERT INTO cotNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iroompaquea Jesoshi icantajiaqueri maasano irisavisaviitaquequea quepatsiqui. Yajiricajiaquero pan caratanquitsica 7, icantacovenquero: “Arioteesa.” Ariquea icotarejaqueroquea yojocajiaqueneri itsatacaanejia, irioqueate jocajiavaqueneriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ariquea chooca aisa mavipaquijaniquipaete shima. Iriraquea Jesoshi icantacovenqueri: “Arioteesa”, iroompaquea icantajiaqueri itsatacaanejia irojocajiaqueneriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ishecajiacaquea maasanojia, iquemajianaca. Oraquea choocatapojajatsica iteguetajiroquea itsatacaanejia cantiriqui, ocaratacovaetaji 7. ");
INSERT INTO cotNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maasano shiramparijia shecajianquitsica icaramirincavaeque 4,000. Iroompaquea Jesoshi itigarancajiajiri iroaroaitanajeta. ");
INSERT INTO cotNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iriatimpa itetanajaro quenajarontsi, itsipatsipaitanajari itsatacaanejia, yoajianaquequea irooshitacoquero Tarimanota. ");
INSERT INTO cotNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ariquea icoraquecoraqueitashipojiriquea pariseojia iramenantajiguempari, icantantajiapojacarica ironigaajiaqueri oacaantantatsica intati onquenantapojemparoja ontaniqui jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iriraquea Jesoshi yaajencataquitiquea icanque: —¿Querocaquea icojiacani choocajiatsica imaica inintantajiacaca ironigaajiqueri oacaantantatsica intati? Arimaja noncantajiaquempi aatotari nonigaajiguiniritsi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ariquea itsinampirejajianajiri, itetanajaroquea quenajarontsiqui, imontemonteitanajaquea intatiqueroqui. ");
INSERT INTO cotNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Irirajia itsatacaanejia ipeacojianacaroquea pan irajaianaqueme irishecajiaquempameca, aparoca ochoocaque quenajarontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iriraquea Jesoshi icanquequea: —Aviatimpajia inchiquiojitaja pishecatacojigarotsi anempoacaguiroca pan irashijia pariseojia aisa Erorishi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Irooquea iquemajiavaquerogueti iquenquetsatavacaajianaca, icanque: —Manatarite yamenajiacajiquea teetarite ameji pan, jero icantantajiacaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iriraquea Jesoshi yamenajiavaquerigueti iquenquetsatavacaajianaca, icantsitariquea: —¿Querocaquea ococani piquenquetsatacotantajiacaroca pan, picanquequea manatarite namenaquempi teequea pameji pan? ¿Arimpate tequerata pinquemajigueji? ¿Tequerata pintsajigueji? ¿Ari quishoshirentajiaquempi? ");
INSERT INTO cotNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ochoocavecaquea poquijajia, ¿teequea pamenantajiguemparoji? Aisa piguempita, ochoocajiavecaquea ¿teequea pinquemantajiguemparoji? ¿Teequea pinquenquejajiajeji? ");
INSERT INTO cotNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nocotarejaguequerogueti 5 pan, noshecatacaajiacari 5,000 shiramparijia, ariquea picapiocajiajiroquea choocatajatsica, ¿querocaquea ocarashequiavaetajini cantiripae pitseraiquijiajiro? Iriatimpajia icanquequea: —Ocaratacovaetaji 12. ");
INSERT INTO cotNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Oquejetacaquea aisa ocaratacovecagueti pan 7, nocotarejaguequeneri 4,000 shirampari, iroompaquea pavijiguetajirogueti choocatajatsica, ¿querocaca ocarashequiavaetajini cantiripae pitseraiquijiajiro? Icanqueriquea: —Ocaratacotaji 7. ");
INSERT INTO cotNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ariquea Jesoshi icanqueriquea: —¿Tequeratampate pinquemajigueji? ");
INSERT INTO cotNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ariquea yarejerejeitapojaca Vetsairaqui. Yamajitapojiniri shamponcajari, icantajitapojiri impamiteri. ");
INSERT INTO cotNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iriraquea Jesoshi yacatsavacotapanajantiri shamponcajari itsipatanacari ocaraguepojigueti tsovironaquipae. Iquishoajatsitari iroquijaqui, imavitepacotashitanacari ipamitaqueri icanqueriquea: —¿Ari pamenaji? ");
INSERT INTO cotNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yamenaveca icanque: —Namenaguevecari caquintejia, iquempejiavecaro inchato, cotanquitsi yanijinijiitanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iquejetsitajariquea aisa imavitepacotashitanajari ipamijaquitsitajari iroquijaqui, iroompa icampanajanta jac amenamajatanaji, peamajatanaja, conijamajatanaji maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ariquea Jesoshi itigarancajiri itsovironaquitequi icantavaqueri: —Aatoja poapanajantitsi guinteninintsiqui, picamantacotanatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ariquea yoanaquequea Jesoshi guinteninintsipaequi irooshitacoguetaqueroca guinteninintsi pajitatsica Sesarea Piripo, itsipatsipaitanacari itsatacaanejia. Oraquea quenavoquirontsiqui icoacojiaqueri: —¿Taa ipaji ijijiaquena caquintejia? ¿Quero icantajiguini? ");
INSERT INTO cotNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iriatimpajia icanqueri: —Iconoagarantajiaca icantacojiaquempi: ‘Iriguenti Joancani Viñacajatantatsica.’ Itsipa cantajiananquitsica: ‘Iriguenti Iriashini.’ Itsipaquea cantajiananquitsica: ‘Iriguenti itsipa tsavetantatsicani.’ ");
INSERT INTO cotNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ariquea icanqueriquea: —Aviatimpajia, ¿quero picantajiguini? ¿Taa nonaque naatimpa? Icantsitanaca Peerero: —Aviguenti Quirishitotatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Icanqueriquea: —Aatojate picamantacotanatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ariquea Jesoshi iparianacaroquea itsatacajaiaqueriquea itsatacaanejia irantsipevaequempaquea irira Irijanite Caquinte. Irimanintajiaqueriquea jivajiatsica, saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini. Ariquea irimetojajiqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri impochatanaje. ");
INSERT INTO cotNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yoguiconejamajataqueneri. Irooquea iquemaquegueti Peerero itsipatanacari tiijai icantomajitsivetari. ");
INSERT INTO cotNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Cotanquitsiquea Jesoshi ipitsocanaca yamenanaqueri itsatacaanejia, ariquea icantomajitsitari Peerero, icantsitari: —¡Poanaqueshinete, Satanashi! Teetarite pinquenquejacomajateroji inintaguequeca Aapani Irioshi, iroguentiquea piquenquejacoguequequea iquenquejaguetica caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ariquea icajemajiajiri omporoguijajianquitsica oraniqui aisa itsatacaanejia icanqueriquea: —Quericaca nintanquitsineca iroguijatacoquena irovashiantanaqueroja inintashiguevetacaca iriatimpa, irinatashitapiniquempa inchapoa irompajacotantajiquemparica, mananiji iroguijatacoquena. ");
INSERT INTO cotNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Quericaca teeca irininteji irantsipeventena irooca irimetojavenquena, manaquea impeaquempa; cotanquitsiquea iriraquea atsipevenquenaneca aisa irantsipevenquemparogueti Quenquetsatsarentsi Oganejencatatsica tsavetantaquenaca irooca irimetojavenquenaquea, incoquempaniquea inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Arigueti inchoocavetaquempa agavejanquitsineca irashinquemparo maasanopae quepatsipaequitica, cotanquitsiquea oncoramanitapojajegueti irimetojanajegueti arigueti impeaquempa camorecariqui, ¿arimpate agavejaque irajaararo aavajeri? Aatoquea agavejitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Irashintamajavequemparoquea maasanopae, cotanquitsiquea aatoquea yagavejitsi irivegaraventavaquempa aatonijite yoguitsi camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Quericaca pashiventacaaquenaneca naatimpa aisa nocantaguequeca inchoocatimojiaquerigueti caquintejia caarica quisho oamajatiri Irioshimajaca, irirajia covaeguisherijia, ari inquejetaquempaquea irira Irijanite Caquinte impashiventacaapojaquempariquea iriatimpa oncoramanitapojajegueti incoraquetajegueti. Iroganejencapojajempaquea, inquempetapojajempari Iriri, intsipatsipaitapojajempari ashivantijite comajashirentanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aisa icanqueriquea: —Noncanquempija arimajaguitatsi iconoagarantaca catintiitimojiaquenaca imaica, aato imetoji tequeratagueti iramene quero icotani Aapani Irioshi imajirontagueti, ironigaimojiaqueriquea iragavejane. ");
INSERT INTO cotNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ariquea anaanajagueti 6 savincaguiteri iriraquea Jesoshi yoanaque ontaniqui otsempiqui yagatsonquivaetanaquequea osamani. Iriguentiquea itsipatsipaitanaca Peerero, Santiago aisa Joanca. Tee inchoocateji itsipajia. Iroompaquea taampina iriatimpajia yamenitsijigariquea Jesoshi icantashitatiimojianacariquea. ");
INSERT INTO cotNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ariquea ocotanaca iitsaare ocavorejatanaquequea ocantashitatianaca tsiren oquitamaromajatanaquequea ocanca quempetacaqueate oquitamarotigueti sharaca, teequea iramenimajiteroji quitsaarentsi oguitamaroca yajacajitirogueti acaniqui quepatsiqui onquempetaquemparo iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yamenitsijigari Iriashini aisa Moishishini itsipatsipaitacari Jesoshi iquenquetsatavacaajiaca. ");
INSERT INTO cotNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Irira Peerero icanqueriquea Jesoshi: —Tsatacaantantatsica, cameetsavaeque achoocajiaque ocaniqui. Intsishiatsi nompeacaguempaja 3 catisetarentsi, aparo pashinquempa aviatimpa, aparo irashinquempa Moishishi, otsipaquea irashinquempa Iriashi. ");
INSERT INTO cotNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Teetarite intsateji querocaca incanquemeca, mana itsaroajianaquetari. ");
INSERT INTO cotNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iroompaquea omararotacojiapojajiri, ariquea iquenquetsajencajitanaque omararosecanquegueti icanque: —Iricatica irio Irijani, nopintsamajatacaca. Pinquemisantamajajiguerija. ");
INSERT INTO cotNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ariquea yamenitsijiavetaja aisa cajaraguiteni, aparo icatiaja Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ariquea icoraquecoraqueitaji yoguirincajiaja, iriraquea Jesoshi icanqueriquea: —Aatotaja quericaca picamantitsi oratica pamenajiaqueca imaica. Intancorejanajegueti Irijanite Caquinte irimetojavetaquempagueti, ariquea pintsavetacotsijiguemparoquea. ");
INSERT INTO cotNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iriatimpajia teequea quericaca incamanteji, manaquea icantavacaajiaca: —¿Oraquea icanquegueti: ‘intancorejanajegueti Irijanite Caquinte irimetojavetaquempagueti’, taaquea icantacotaque? ");
INSERT INTO cotNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ariquea icoacotsijijaari Jesoshi: —¿Quero ocotacani icantantacaca tsatacaantajiguiroca itioncacotanaqueca Moishishini icantajiaquegueti iriquetitaquea coraquetajatsine Iriashini? ");
INSERT INTO cotNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iriatimpa icanquequea: —Arimajaca ocanque Itioncacaantaqueca Aapani Irioshi iriquetitaquea coraquetajatsine Iriashini, irinetsanaguequeroquea maasano. Cotanquitsiquea oraquea itioncacojiquerigueti Irijanite Caquinte, ¿queroquea ococani ocanquegueti irantsipevaequempaquea, aisa incatsimajiqueriquea? ");
INSERT INTO cotNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Imaica noncamanquempi jac icoraquetaquiti Iriashini, cotanquitsiquea mana yantaguishejitaqueri maasano inintajitaqueca. Ariquea ocanque Itioncacaantaqueca Aapani Irioshi coramani itsavetsijitaroni. ");
INSERT INTO cotNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ariquea yarejerejeipojaja ichoocajiaquegueti itsipajia itsatacaanejia, yamenajiapojajiri yomporoguijaventajari, aisa ichoocajiaque oraniqui tsatacaantajiguiroca itioncacotanaqueca Moishishini itsipatsipaicariquea iquenquetsatavacaajiaca, irooquea icanque irooquea icanque. ");
INSERT INTO cotNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yamenitsijiavajariquea icoraquepojaji Jesoshi ariquea icojianaca yamenamenaitanaquequea intati. Maasanojia itacorojaianaca iquenquetsatacaajiavajiri. ");
INSERT INTO cotNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iriatimpa icanqueriquea: —¿Taaquea piquenquetsaventajiaqueca? ");
INSERT INTO cotNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iquenquetsatanaquequea aparo, icanqueri: —Tsatacaantantatsica, namavequempiri irijani ishaquiacaca ampatsini, imacanatacaaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Querocagueti ichoocaqueni yaacotapojaquerigueti ariquea ipijempejacaacari ishimotyonajavaetanaque, yatsicayajitanaca, iroompaquea aratsiquijini. Nocantajiavecari pitsatacaanejia iroguisotojaiaquerime, cotanquitsiquea teequea iragavejajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Icantanaquequea Jesoshi: —¡Arisa picomirincajiga teequea paventemparoji iragavejane Aapani Irioshi! ¿Querocaquea oncarashequiavaeteni nosavicaventajiaquempi? ¿Queroca oncarashequiavaeteni nantsipetacojiaquempiquea? Iroosacanica iintsija pamajiaquenarijate ocaniqui. ");
INSERT INTO cotNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yaajianaqueneriquea. Iriraquea ampatsini yamenavaquerigueti Jesoshi, ariquea icotanaca icantacaanaqueri tinquininini, ariquea itejanaquequea isavi quepatsiqui, itigaritigarivaetanaca tigaririri tigariri, ishimotyonajavaetanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iriraquea Jesoshi icanqueriquea iriri: —¿Querocaquea ocaratanaqueni yajagantsitacotaca ishaquiacarigueti ampatsini? Iriatimpa icanque: —Jac yoshequiacovaetanaquequea, ishaquiitsitacaritarite coramani chaajaniquitirajagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oconoaca manaquea yomposacaacariquea paamaripoquiqui, oconoaca yomposacaacari ojaaquiniqui irimetojaquerime. Imaicaquea arigueti pagavejaque aviatimpa, iintsija pimpintsatacojiguenashiatsi pamitacotenarishiatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Icanqueriquea Jesoshi: —¿Queroquea ococani picanquenaquea: ‘Arigueti pagavejaque’? Quericaca aventamajaquemparineca Aapani Irioshi iragavejaqueroquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iririjencavaetanaque iriri chaajaniquiri, icanque: —Naventavecariqueate. Pagavejacaguenaja naventamajataquemparinijite. ");
INSERT INTO cotNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ariquea Jesoshi yamenajiavaquerigueti ishiashiaitashipojacari icaramirincavaeque caquintejia, icantomajitsitari ampatsini, icanqueri: —Aviguenti cotacaacari, teeca inquemantempaji aisa teeca inquenquetsatantempaji. Imaicaquea noncanquempi pisotoanajerijate, povashiantanajerija iricatica, aatoquea picoraquetimatajitsi pishaquiajempari. ");
INSERT INTO cotNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iriraquea ampatsini ariquea icotanaca icajemanaquequea jeeee, icantacaanaqueri tinquininini, isotoapanajantiri yovashiantanajiri joquijitsantsataca quempeniquea imetojaque, iconoajiacaquea icantantajiacaca: —Metojaque. ");
INSERT INTO cotNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Cotanquitsiquea Jesoshi yacatsavacoqueriquea yoguitinajaqueri, ariquea icotanaja icatianaja. ");
INSERT INTO cotNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ariquea yoanaji Jesoshi tsovironaquiqui, itsipatsipaitanajari itsatacaanejia, iriguenti choocajiajatsi, icoacotsijiapojajari: —¿Querote ococani naatimpajia caarica nagavejantajigari noguisotoitajigueriji? ");
INSERT INTO cotNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iriatimpa icanqueriquea: —Iriraquea ampatsini quempecarica imaica aatogueti iroquetitaquea pamanajiguiritsi Aapani Irioshi aisa aatogueti pisanticotiro pisheca, aatoquea pagavejimajiguitsi poguisotojaiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ariquea yoanaji Jesoshi icantanaca Garireaqui. Teequea irininteji iramenajitavaqueri, ");
INSERT INTO cotNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ininquetarite intsatacaajiaqueriquea itsatacaanejia. Ariquea itsatacajaiaqueriquea, icanqueriquea: —Iriraquea Irijanite Caquinte iraacaantajiqueri, irajaiavaqueri caquintejia, ariquea irimetojajiaqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri intancorejanaje. ");
INSERT INTO cotNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iriatimpajia teequea intsajiavaqueroji icanqueca, cotanquitsiquea omintsaroanaqueri incoacojiaquerime taa opaji icanque. ");
INSERT INTO cotNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oraquea yarejerejeipojacagueti Caperenaoqui yoayoaitanaquequea tsovironaquiqui, iroompaquea irira Jesoshi icanqueri itsatacaanejia: —¿Taa opajita picantavaque picantavaque incajaranquitica quenavoquirontsiqui? ");
INSERT INTO cotNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Cotanquitsiquea iriatimpajia imativicajianaque, yamenajiaquequea iroguenti icantavaque icantavaque quericaca caavijica yanaantaque. ");
INSERT INTO cotNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iriraquea Jesoshi isavicanaquequea, icajemajiaqueri itsatacaanejia carajianquitsica 12, icanqueriquea: —Quericagueti nintanquitsineca iranaantaque aato yaventacotatsi, inchiquioji iriatimpa iramijiaqueriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ariquea yaitsitaquea aparo chaajaniquitanquitsica yogatiimojiaqueriquea itsatacaanejia, ariquea yatsomaitsitari icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Quericaca shineventavaquemparine chaajaniquiri quempecarica iricatica iroorijite nonintacaantaquero naatimpa, quempecaqueate naroguentica ishineventavaca. Quericaca shineventavaquenane naatimpa, aatoquea aparo naatimpa ishineventavaca, irioquea aisa irishineventavaquempa tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ariquea icanqueri Joanca: —Tsatacaantantatsica, chapinquiqui namenajiaqueriquea aparo yoguisotoaqueriquea ampatsini, iroguentiquea yaventashicari pivajiro. Cotanquitsiquea naatimpajia nocantimentajiaqueriquea, namenajiaqueriqueate teetarite intsipatsipaitajinica. ");
INSERT INTO cotNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Icanquequea Jesoshi: —Imaica aatotarite picantimentajiguiritsi. Quericagueti pamenajiaqueca avenquemparoneca novajiro ironigaantaquerogueti oacaantantatsica intati, iriatimpa aatoquea taampina itsipatavajirotsi incantimanatavajenaquea. ");
INSERT INTO cotNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Quericacatari teeca incatsimataji iroguenti itsipatacaji. ");
INSERT INTO cotNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Quericaca cavintsajaquempine jocacotaquempine oja pimiraqueca iroorijite nonintacaantaquero naatimpa, inquenquejaquegueti: ‘Irioriji irashi Quirishito’, arimaja aato opeapitsatari irinejacotajempa. ");
INSERT INTO cotNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Taacagueti covaeguishetacaaquemparineca aparo chaajaniquiri quejejiacarica iricajia tsaroventaquenaneca, incatsimatimentamajajitaqueriquea. Irootaquequea nontsatacaantajiaquempiroca aatonijite iquejejitiritsi imaica, iroquetitamequea intsatotacojiquenerime itsanoqui iniroshimentapiri itononcantajitaca, irajaitanaqueriquea impishoncajatsijitempariquea inirojaniqui quentijani. ");
INSERT INTO cotNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nonquejetacaajiaquempiroquea imaica: arigueti oncovaeguishetacaaquempi paco, pincaratsitemparoquea. Cameetsavetaca pimpeaquempa tsatiavacori pichoocatigueti acaniqui quepatsiqui, aatoniji mavitepacotirajampigueti ipishoncajitimpi camorecariqui aatoca otsivaquitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ontaniquiquea aato imetojitsi igueni aisa aato otsivaquitsi paamari. ");
INSERT INTO cotNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aisa iroogueti covaeguishetacaaquempine piguiti, pincaratsitemparoquea. Cameetsavetaca pimpeaquempa tsatiaguitiri pichoocatigueti acaniqui quepatsiqui, aatoniji maviteguititirajampigueti ipishoncajitimpi camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ontaniquiquea aato imetojitsi igueni aisa aato otsivaquitsi paamari. ");
INSERT INTO cotNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aisa iroogueti covaeguishetacaaquempine poquija, pintaguirorejaatsitempa. Cameetsavetacaquea apaoquivetaquempi pinquijapojajegueti imajirontagueti Aapani Irioshi, aatoniji mavioquivetimpigueti impishoncajitaquempi camorecariqui. ");
INSERT INTO cotNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ontaniquiquea aato imetojitsi igueni aisa aato otsivaquitsi paamari. ");
INSERT INTO cotNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maasanojiaquea osocapojempari paamari, quejetaca icachoanejitirigueti viratsi imetojajitinirigueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Oraquea incachoanepane cameetsavaeque, cotanquitsiquea ariguetija omasancategueti, ¿querocampate incojitajeroni incachoanetantajitajemparo? Pinquejetemparoja incachoanepane cameetsatatsica, aisa pinconoavacaamajaquempaja.” ");
INSERT INTO cotNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ariquea isotoanaque Jesoshi, yoanaquequea Joreaqui aisa intatiqueroqui Jororane. Iroompaquea yarejetapojacagueti yomporoguijajiavempojacariquea aisa icaramirincavaeque caquintejia. Ariquea itsatacajaiaqueri iquempetapiniquerogueti. ");
INSERT INTO cotNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ariquea iconoagarantajiacaquea pariseojia icoraquecoraqueipojaque icoacojiapojaqueri iramenantajiaquempariniji, icantajiapojaqueri: —¿Arite icantimentantajitiro irovashianterogueti shirampari imanquigare? ");
INSERT INTO cotNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iriatimpa icanqueriquea: —¿Querocampate icanqueni Moishishini itioncacotanaquerogueti? ");
INSERT INTO cotNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iriatimpajia icanquequea: —Iriraquea Moishishini ishinetsitari arigueti irovashiantanajero shirampari imanquigare, irojoquitenemparojate paperi otioncacagueti yovashianquero, ariquea intigaranquitsitemparo oanaje. ");
INSERT INTO cotNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Icanque Jesoshi: —Iriraquea Moishishini manatarite yamenajiaquempiquea quishoshirentavaequempi, jero iquejetacaanquempiroca imaica itioncanquempiroca. ");
INSERT INTO cotNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cotanquitsiquea iroaqueragueti ipeacaaguecariguetiquea Aapani Irioshi maasanopae, ‘ipeacaacariquea shirampari aisa manquigarentsi.’ ");
INSERT INTO cotNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Irootaquequea imaica shirampari intsinampirejanaqueriqueate iriri aisa iriniro, quisho iroamajataquero imanquigare, ");
INSERT INTO cotNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","apatsinoroquea incantanajempa. Ariquea iroaqueraguetiquea tequeratagueti irimanquigatemparoji, mavite icarajiavetaca, ariquea imanquigacarogueti ariqueate icojianaca tee irimavitetajeji, quempetanajaqueate apatsinoronica icantaja.’ ");
INSERT INTO cotNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jeroquea imaica oraquea itsipatacaantacaca Aapani Irioshi, aatojate itsiparejajiro caquinte. ");
INSERT INTO cotNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ariquea yoayoaitanaji tsovironaquiqui icoacomajajiaqueriquea itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iriatimpa icanqueriquea: —Quericaca ovashianqueroneca imanquigare manquigatajemparoneca otsipa, manaquea icovaeguisheca yaimentacocaro iroquetica. ");
INSERT INTO cotNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ariquea oquempetaca, iroogueti manquigarentsi ovashiantanaquerineca manquigataroca manquigatajemparineca itsipa, manaquea aimentacari. ");
INSERT INTO cotNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iroompaquea icoraquecoraqueitaquequea itsipapae yamajiapojiniriquea Jesoshi chaajaniquiripae impamijiavaqueriniji. Iriraquea itsatacaanejia yamenajiavaquerigueti yamajiaquenerigueti, icantomajavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cotanquitsiquea yamenaquegueti Jesoshi, osemacaaquitari icanqueriquea: —Ariotaquetsija incoraquetetate chaajaniquirijia naatimpaqui, aatoquea pojocaavaca, ishineventajiacaritarite Aapani inquitequitica irimajirontacotaquempari quenquejajiatsica quempecarica iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iroomajaca noncantajiaquempica: quericaca nintanquitsineca impejaeri Aapani Irioshi Imajirote inquempetajempariquea chaajaniquitirajaca. Oraquea aatogueti iquempetaritsi, aatotarite iconoapojajari maasano peajiaquerica Imajirote. ");
INSERT INTO cotNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iroompaquea inajiaqueriquea chaajaniquiripae, ipamijiaqueri yamanacoventajiaqueri incavintsajamajajiaquerinijite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Oraquea yoanajigueti Jesoshi yameniri icoraquepoji irira caquinte ishiashitapojacariquea iguerovempojacari icanqueri: —Tsatacaantantatsica cameetsari, ¿queroquea noncoquempani cameetsanijite noncoguitempaninijite nonchoocaguiteni? ");
INSERT INTO cotNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Icanqueri Jesoshi: —¿Queroquea ococani picantantaquenaca ‘cameetsari’? Teequea inchoocateji cameetsari, aparo icoca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pitsaqueroquea maasanopae itioncacotanaqueca Moishishini, ocanquequea: ‘Aatoja pimetojanti, aatoja poashitiro manquigarentsi, aatoja paitsitanti, aatoja pitsojeacotantimatatsi, aatoja pamatavijantitsi, pinquenquejacameetsatacoquerija piri aisa piniro.’ ");
INSERT INTO cotNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iriatimpa icanqueri: —Tsatacaantantatsica, aritarite noquempetaca imaica, noparianacaroquea nonetsanamajatanaqueroquea maasano nochaajaniquipojigueti narejevaecaro imaica. ");
INSERT INTO cotNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yamenitsitanacariquea Jesoshi ipintsatacotanacariquea icanqueri: —Imaica apanivani poanaquequea pojocantaguetanaqueroquea maasanopae pashintaguecaca, paantajiaquemparoquea imentaquipae pojocajiaqueneri coguitejacojianquitsica, pinquejetaquerogueti onchoocataje oganejencaro shinetacajaempineca ontaniqui inquitequi. Ariquea pincoraquetajeja poguijatanaquena. ");
INSERT INTO cotNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iquemitsitaroquea icanquerica ariquea ocotanaca otsimeteitacaanaqueri, ariqueate yoanaji, ishimampojancavaetanacaquea, iriguentitari ajaarantavaetatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iriraquea Jesoshi yamenajiaqueriquea maasanopae, ariquea icantajiguiri itsatacaanejia: —¡Omanapitsamajataquempariquea ajaarantavaetatsica inquijanaque imajirontagueti Aapani Irioshi! ");
INSERT INTO cotNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Irooquea iquemajiaquerogueti icanqueca, yamenamenaitanaquequea intati itsatacaanejia. Yapijitajiroquea Jesoshi icanque: —Nirijanijiate, omanapitsamajataquempari inquijanaque imajirontagueti Aapani Irioshi iriraquea aventaroca irajaararo. ");
INSERT INTO cotNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","¿Arimpate iragavejaquequea cameyo inquijanaquequea itepoquiqui quisaatonquiri irisotoanaqueriquea antaqueronta? Aatoquea yagavejitsi. Iriompaquea ajaarantavaetatsica caaviji anaaquero omanapitsataquempari inquijanaque imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iquemitsijigari itsatacaanejia arimpaqueate yamenamenaitanaque intati, icantavacaajiaca: —Iroosacanica, ¿quericampate agavejanquitsineca iraavajempa? ");
INSERT INTO cotNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yamenajianaqueriquea Jesoshi icanqueriquea: —Iriraquea caquinte teequea iragavejeroji, iriguentiquea Aapani Irioshi agavejatsi, yagavejaquerotari maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iroompaquea icantanaque Peerero: —Nomajirote, naatimpajia novashiantajianaqueroquea maasanopae nashintaguecaca, noguijaguijaitanaquempi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Icanque Jesoshi: —Iroomajaca noncantajiaquempica, quericaca vashiantajianaqueroneca itsovironaquite, irioca iriguentijeguitepae, itsijoitepae, iriniro, iriri, irijanijiate, irooca iniganquitejire, cameetsanijite irisavicavenqueroquea notigaranquimenquerica intsavetantimojianaqueriquea itsipapae intsatacaajiaqueriquea Quenquetsatsarentsi Oganejencatatsica, ");
INSERT INTO cotNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","irojocajitajeneriquea otsipa itsovironaquite ocaniqui quepatsiqui oshequiavaequequea aricaca oncaravaequequea 100, aisa inchoocajiaque itsipapae iriguentijeguitepae, itsijoitepae, iriniropae, irijanijiate, iniganquitejire. Cotanquitsiquea incatsimatimentajiqueri iramenajiquerigueti itsarovenquenaquea. Oncoramanitapojajegueti incoguitempaniquea iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Icaramirincavaequequea yamenajivetacaca imaica yanaantavaeque, cotanquitsiquea oncoramanitapojajegueti aatoquea yanaantajitsi. Aisa icaramirincavaeque teeca iranaanteji imaica, oncoramanitapojajegueti iranaantavaetanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ariquea iriatimpajia ishivoquishivoquiitanacaroquea quenavoquirontsi itoncotoncoitanaque iroaroaitanaquequea Jerosarequi. Iriquetitaquea oananquitsi Jesoshi, iriraquea itsatacaanejia yoguijaguijaipojiri, yamenamenaitanaquequea intati. Itsipajia guijajianaquerica itsaroajianaquequea. Ariquea yapijitajiro Jesoshi itsipajianajari tiijacoñaji itsatacaanejia carajianquitsica 12, ariquea iparianacaro icamanqueri querocaca incojiquerini ontaniqui Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Icanqueriquea: “Imaicaquea antoncotoncoitanaque oahoaitanaque Jerosarequi. Ontaniquiquea ontaniqui arejerejeiquempagueti manaquea iraacaantajiqueri irira Irijanite Caquinte, irajaitanaqueri ichoocajiaquegueti saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iriatimpajia incanquequea: ‘Iintsishiatsi irimetojajiterini.’ Ariquea irajaitanaqueriquea ichoocajiaquegueti teeca irijorijoigueji irimetojacaanqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iriatimpajia irantanaguishevaequeri, inquishoquishoavaequeri, aisa impasapasaiqueri agompiaquitempari. Ariquea irimetojajiaqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri intancorejanaje.” ");
INSERT INTO cotNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ariquea iquempejiquempejiipojiriquea Santiago aisa Joanca, irijanijiate Severeo, icanqueriquea: —Tsatacaantantatsica, nonintajiaque pinetsanamajajiaqueroquea noncantajiaquempica imaica. ");
INSERT INTO cotNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iriatimpa icanqueriquea: —¿Taate opajita pinintajiaque nantempica? ");
INSERT INTO cotNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Icantajiaqueri: —Aapojajempagueti pimpeaquempagueti Imajirojiate maasano, nonintajiavecaquea poguisavisaviitaquena nosenampijajiaquempi, aparo savicanquitsineca pitincamijempequiqui, aparo pishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Cotanquitsiquea Jesoshi icanqueriquea: —Teequea pintsajigueroji ocatica pinintavecaca. ¿Arimpate pagavejajiaquequea aviatimpajia pimire nomiraquempaca naatimpa? ¿Arimpate pagavejajiaque poviñacajatacaantantaquemparo noviñacajatacaantantaquempaca naatimpa? ");
INSERT INTO cotNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iriatimpajia icanqueriquea: —Jeejeguitatsi nagavejaquempa. Icanqueriquea Jesoshi: —Pitampaticamajataquero pimiraqueroquea nomiraquempaca naatimpa, arimaja poviñacajatacaantantaquemparo noviñacajatacaantantaquempaca naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Cotanquitsiquea teequea naatimpa cantatsineca quericaca senampijaquenaneca savicanquitsineca notincamijempequiqui aisa noshinampijempequiqui. Iriguentiquea cantanquitsica Aapani Irioshi paesatoniqui iroaqueragueti. ");
INSERT INTO cotNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ariquea iquemajiavaquegueti itsipajia 10 itsatacaanejia itijerequijianaqueri Santiago aisa Joanca. ");
INSERT INTO cotNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cotanquitsiquea Jesoshi icajemajiaqueriquea icanqueriquea: —Pitsajiguiritarite iriraquea ipejaiaqueca imajirojiate teeca irijorijoigueji manaquea yatsanavaecari igonorojia, ariquea iquempejiaca iramajirorejia yomperaperacari irashijia. ");
INSERT INTO cotNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cotanquitsiquea aviatimpajia aatoquea piquejejiga. Ariguenti quericaca nintanquitsineca iranaantimojiaquempi, impeitsitempaja amijiguempineca. ");
INSERT INTO cotNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Quericaca nintanquitsineca irijivatante, impeitsitempaja iromperare maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quempecaquea Irijanite Caquinte teequea irooquea incoraquetashiteji iramijitavaqueri, iroguenti icoraquetashique incavintsajantapoje, aisa irimetojaventsitempariquea maasanojia, onquejevequempaquea irivegaraventajiajeneri irisotoimentajianajeniji santanatacojiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iroompaquea yarejetapojacaroquea Jesoshi Jericoqui, itsipatsipaitapojacariquea itsatacaane. Oraquea yoanajiguetiquea arimpaqueate yoshequiavaetanaquequea oguijaguijaitanaquerica. Ariquea oraniqui ocaravoquitapojigueti quenavoquirontsi isavicaque shamponcajari pajitatsica Varitimeo, iriguentiquea irijanite Timeo. Iriatimpaquea iroguenti isavicaventi yamanantagueti imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Irooquea iquemacoquerigueti coraquetapojishiatsi Jesoshi Nasarequitica, icajemitsitanacaquea iririjencatanaque, icanque: —¡Jesoshii, Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Icantomajajiaqueriquea oshequini, icantsijiavetari irisanticotanaque, cotanquitsiquea iriatimpa arimpaqueate icajemamajatanaquequea: —¡Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Icatiapojacaquea Jesoshi icanque: —Iintsijate pincajemerijate. Icajemitsitari shamponcajari icanqueriquea: —Iintsija, imaica pishinevaetanajempaja, pincatianaje, icajemaquempiqueate. ");
INSERT INTO cotNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Icatiitsitanaca ipishoncapanajantiroquea isavotacaca ishiashitanacariquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Icantavaqueri Jesoshi: —¿Taa opaji pininque nantaquempiro? Icanti shamponcajari: —Tsatacaantantatsica, noninque namenaje. ");
INSERT INTO cotNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Icanqueriquea Jesoshi: —Iintsija poanaje, pitsaquetarite nagavejaque namenacaajempi, paventantaquenaca, irootaquequea pamenantanajaca. Ariquea icotanaca amenaji, yoguijatanajiri quenavoquirontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iroompaquea irooshipojigueti irarejerejeipojemparo Jerosare, yarejerejeipojajaroquea Vetepaje aisa Vetania Orivotsempiqui. Ariquea iriraquea Jesoshi itigarancajiaqueriquea mavite itsatacaane icantajiavaqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Poanaquequea ontaniqui quempeji guinteninintsiqui, ariquea pamenajiapojeri aparo aashino irijanigantirenajaniqui shiticacotaca, tequeratatirajaquea irishiashiavijitacotantajitempariji. Pishiticarejacojianaqueri pamajiaquenarija. ");
INSERT INTO cotNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Choocagueti cantajiaquempineca: ‘¿Querocampate pincojiaquerini?’ Aviatimpajia pincantajigueri: ‘Iriguenti coacotacari Amajirote, taampinatari iroguipijaempiri.’ ");
INSERT INTO cotNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ariquea yoayoaitanaquequea yamenajiapojiriquea shiticacotaca tsovironaquiqui sotomorontsiqui ocaravoquitapojigueti quenavoquirontsi, ariquea ishiticarejacojiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iriraquea choocajianquitsica oraniqui icanqueriquea: —¿Querocaqueate pincojiguerini? ¿Taaquea pishiticarejacotancarica aashinogantirenajaniqui? ");
INSERT INTO cotNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Icantanaqueriquea iriatimpajia icantajiavaquerica Jesoshi, ariquea ishinejiaqueneri iraajianaqueneri. ");
INSERT INTO cotNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ariquea yaajianaqueriquea yamajiaqueneriquea Jesoshi, ipashicamititsajiaqueneri iitsaarepaequi, iriatimpa isavicantanacari ishiacotantanacariquea. ");
INSERT INTO cotNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Irirajia tirorencaventajiacarica iconoagarantajiacaquea yovemaroncaashijiavaqueri iitsaare quenavoquirontsiqui, itsipapae aavashijiavanquitsica ovashi ivemaroncaashijiavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Irirajia iriquetica oahoaitananquitsica aisa irirajia guijaguijaitaquerica icajemajianaque, icanque: —¡Caaviji yoganejencamajataca! —¡Intsishiatsi irishineventajiquempari iricatica coraquetapojatsica itigarancaqueca Majirontamajatatsica! ");
INSERT INTO cotNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—¡Ari incoquempani irishineventajiquempariquea iricatica peanquitsineca Amajirojiate inquempetajempariquea Taavini ipeavecagueti coramani imajirojiate choviquijianacajica! —¡Caaviji yoganejencamajataca Aapani Irioshi choocatatsica jenoqui! ");
INSERT INTO cotNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ariquea yarejetacaroquea Jerosarequi, yoanaquequea teemporoqui itsaroventantajitarica Aapani Irioshi, yamenaguepojiroqueate itsitacaguetapojiroquea. Iroompaquea incajaranquiguitetanaquitigui isotoanaji yoanaji Vetaniaqui, itsipatsipaitanajari itsatacaanejia carajianquitsica 12, javaetanaji catsirincaiteri tsaparoncaguitetanaja. ");
INSERT INTO cotNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ariquea osavincaguitetanajigueti isotoanajirogueti Vetania, itaseapojiquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yamenacotsitapojacaroqueate iguera choocatanquitsica ovana, irootaquequea yoantapanajantaca iramenamajapanajanteroquea choocaca osovena, cotanquitsiquea iquempejivetapojacaroquea quempeji teequea anejeroji, iroguentini ovana. Tequeratatarite arejetempaji ochoocatantaca osovena. ");
INSERT INTO cotNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Icantsitaroquea: —Imaicaquea imaica aatoquea ishecatimajitajarotsi pisovena. Iquemajiaqueriquea itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ariquea yarejerejeitaca Jerosarequi, iquijanaque Jesoshi oniganquirequi oticaacoroqui teemporo itsaroventantajitarica Aapani Irioshi, yamenajiapojiriquea jocantantaguetirica viratsipae intsompogui oniganquirequi aisa vegaratantajiguirica. Yoguivorocajiapojaqueriquea maasanojia, aisa yapitaquiaguequeroquea ishitaponcaropae yojoquijitantarica imentaquitsite guipiantajiguirica imentaquipae. Iquejetsiguetaroquea aisa isavisaviitantacaca jocantajiguirica emorenipae. ");
INSERT INTO cotNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Icantimentajiaqueriquea maasano aatotarite iquijacaantajianacaro oniganquirequi teemporo irajaianaquero irajaararopae iravisacaantajianaquemparo antaqueronta. ");
INSERT INTO cotNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ariquea itsatacajaiaqueriquea icanqueriquea: —¿Arimpate tee ontionquempaji: ‘Oratica notsovironaquite incantacojitero iroguenti ashi incoraquetantapinijitempaca caquinteguetatsica iramanajiaquenaniji’? Cotanquitsiquea aviatimpajia manaquea pipeacajaiacaro imoro itsititantaca aitsitantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iroompaquea iquemacojiaquerigueti saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini inintajiavecaquea irimetojajiaquerime, cotanquitsiquea querocampate incojiaquerini, itsaroacaajiacariquea, yamenajiaqueri yomporoguijaventajiacari maasanopae yamenamenaitanaquequea intati ishineventajianacari itsatacaantavaequegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ariquea opitsecajencatanajigueti, yoanaji Jesoshi, isotoanaquero Jerosare. ");
INSERT INTO cotNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Osavincaguitetanajigueti yoayoaitanaji, yamenacojianajiro iguera jac sampirocani metojamajataque maasano ovaritsa. ");
INSERT INTO cotNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iriraquea Peerero iquenquejitanajaro chapinquitica, icanque: —Tsatacaantantatsica, iintsija pameneroja intati ontatica iguera picantaqueroquea chapinquiqui aatonijite ochoocatajitsi osovena, imaicaquea metojaque. ");
INSERT INTO cotNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Icanque Jesoshi: —Paventaventaitemparijate Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iroomajacaquea noncantajiaquempica, quericaca cantaqueroneca ocatica otsempi: ‘Poanaquetsija pojocajatempa inirojaniqui quentijani’, aatogueti iquenquejaveta: ‘Arica’, iroguenti iraventamajaquempariquea Aapani Irioshi, ariquea oanaquequea ojocajapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jero imaica nocantantajiaquempica, taaca opajita pamanajajiaquerica Aapani Irioshi pamanajiaquerigueti, paventamajaquemparija pintsamajajiaqueja arimajaca irojocajiaquempi, ari oncotanaquempa. ");
INSERT INTO cotNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Oraquea pamanajiguerigueti Aapani Irioshi, choocagueti picatsimajiaqueca, iroquetitaquea pimpeacojiajempari taaca opajita icatsimatacaaquempica cameetsanijite irishinevenquempinijite Piri choocatatsica inquitequi irishetajempironijite pipeacaaguishejiacaca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Cotanquitsiquea aatoguetija pipeacojiajaritsi ipeacaajiacaca catsimatacaaquempica, aatoquea ishetajirotsi Aapani Irioshi choocatatsica inquitequi pipeacaaguishejiacaca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ariquea yarejerejeitapojajaro Jerosare, iriraquea Jesoshi iquijanaquequea intsompogui oniganquirequi teemporo yanijivijitaque. Incajaranquiguitetanaquegueti icoraquecoraqueitashipojaqueri saserorotejia anaantajianquitsica, itsipatsipaicariquea tsatacaantajiguiroca itioncacotanaqueca Moishishini, icoraquejiaquequea aisa jivajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Icantajiapojaqueri: —¿Taaquea cantaquempi piquempetancaroca imaica poguivorocantajiacarica jocantantajiatsica? ¿Taampate tigarancaquempiquea? ");
INSERT INTO cotNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iriraquea Jesoshi icanqueri: —Iintsija naatimpa noncoacotempi. Poguisotoaquenarogueti, ariquea nonquempetsitempa naatimpa noncamanquempiquea queri tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iviñacajatantigueti Joancani, ¿queroquea oquenapojini? ¿Irooca oquenantapojaca inquite? ¿Irioca oquenantapojaca caquintejia? Iintsija pincamantena. ");
INSERT INTO cotNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Irooquea iquemajiavaquegueti iquenquetsatavacaajianaca icantajianaque: —¿Querote ancoterini? Ancantsivetemparigueti oquenantapojaca inquite, iriatimpa incantanaque: ‘Iroosacanica ¿queroquea ococani teeca pinquemisantantajiguempariji?’ ");
INSERT INTO cotNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Cotanquitsiquea ariguetija ancantsivetempari oquenantapojaca caquintejia...? Manatari itsaroacaajiacariquea omporoguijajianquitsica, maasanopaetari icanque irira Joancani iriguenti tsavetantatsica itigarancaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jero icantantajiacarica Jesoshi: —Teetari nontsajiguenica. Ariquea Jesoshi icantajiaqueri: —Iroosacanica, ariquea nonquejetaquempaquea naatimpa, aatoquea nocamantimpitsi quericaca tigarancaquenaca naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ariquea Jesoshi iquempetacaacotacanari icanqueriquea: —Ichoocaque aparo caquinte yashincaquea iguepatsite. Iroompaquea imiamaroncaqueroquea ovaitsoqui, itantotacoqueroquea. Iqueecashiqueroquea yagaticantajitaroca ovaitsoqui osotoajatantanaquempaca ovaja, ipeacaitsitaroquea irisavicantaquempaca jenoqui quempoguijaqueroneca cameetsanijite iramenamajaqueronijite aatonijite yaajiguetirotsi. Iroompaquea icajemajiaqueri itsipapae irishiacojiaqueneriquea. Oraquea onchoocatanaquegueti irojocagarantajiaqueneri iriatimpa. Ariquea yoavaetanaquequea jmm osamani. ");
INSERT INTO cotNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ocoramanivaetapojigueti aapojajagueti osamparipiotantanacaca ovaitsoqui itigarancavecari aparo yashincaca iramanajiajateriquea irojocagarantajiajenerime iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cotanquitsiquea iriraquea shiacojiaqueroca manaquea yaajiavaqueri itavatavaajiaqueri itigarancajiajiri ejempaco. ");
INSERT INTO cotNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ariquea irira ashincaroca itigaranquitsitaja itsipa. Iriatimpa iroguenti iquirajashitequitacaajiavaqueri icantaguishejiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Itigarancavetaja itsipa, ariquea imetojajiavaqueri. Iroompaquea itigaranquitsivetaja itsipapae oshequini. Iconoagarantacaqueate itavatavaajiavaqueri, itsipapae imetojajiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Iriguenti choocatajatsi irijanite ipintsamajatacaca. Ariquea itigaranquitsitari iriatimpa, icanque: ‘Iriocampa nirijanite, iriguentiquea irajaitavaque cameetsa, inquemisantajiavaqueri.’ ");
INSERT INTO cotNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Cotanquitsiquea iriatimpajia irooquea yamenavaquerigueti icoraquepojigueti iquenquetsatavacaajianaca icanquequea: ‘Jeeri irintatica ashinquemparoneca maasanopae irimetojanajegueti iriri. Jamequetiroshiatsi ametojajiavaqueri cameetsanijite aatimpajia ashintamajatajemparoneca.’ ");
INSERT INTO cotNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iroompa yarejevepojaca yaajiavaqueriquea imetojajiaqueri, ipishoncavaequitiri antaqueronta otantotacocagueti ovaitsoquimashi. ");
INSERT INTO cotNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Imaica querocaca incojiaquerini ashincaroca iguepatsite? Manaqueate iroashijiaquiteriquea irimetojajiaquiteri, itsipapaequeate incajemajiaje quempoguijitajerineca iniganquitejire. ");
INSERT INTO cotNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Arimpate teequea pampatsajavantacojigueroquea Itioncacaantaqueca Aapani Irioshi coramaniqui? Ariqueate ocanquequea imaica: ‘Oraquea ogota mapi teeca irishineventajiavetempaji peacaajiacaroca mapipanco, opeanacaquea anaantamajatanquitsica quishotacaaqueroca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iriraquea Aapani Irioshi ipeacajaaroquea. Amenajiaqueroquea aatimpajia oganejencani.’ ” ");
INSERT INTO cotNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iriatimpajia inintajiaveca iraacaantajiaquerimequea, iquemajiavaqueritari iriguenti iquejetacaajiaca, cotanquitsiquea itsaroacaajiacariquea omporoguijajianquitsica, jero yoayoaitantajianacaca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Iriraquea pariseojia itigarancagarantajiaquequea itsatacaane aisa shinevencarica Erorishi iroaroaitanaque ichoocaquegueti Jesoshi incomitacaajiaquempari cameetsanijite onchoocaquenijite incanqueca ompampiatantapojempaca incatsimatacaantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iriatimpajia yoayoaitanaquequea icantajiapojiri: —Tsatacaantantatsica, notsajiaque aviatimpa teetarite pamataguempaji. Tee inchoocateji quericaca pagamajaquempaca, aisa teequea pintsaroacaguempariji caquinte, irioca anaantavetanquitsica, irioca teeca iranaanteji. Pitsatacaantigueti tampatica poaquero picamanquerigueti queroquea incojiaquempani irinetsanajigueroniji inintaguetica Aapani Irioshi. Aviatimpa pitsatiroqueate icanqueca majirontatsica Sesa icanquegueti maasanojia joriojia irojocagarantapinijiaqueneri imentaquipae. Imaica ¿queroca pincanteni? ¿Cameetsampa nojocajiaqueneri, aricaca tee oncameetsateji? ");
INSERT INTO cotNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Ariquea nojocajiaqueneriquea, aricaca aato nojoquiniritsi? Cotanquitsiquea Jesoshi itsatavaqueroquea teequea cameetsa incantajigueji, manaquea ishinetamampeajiacaqueate intati, irootari icantantacarica: —¿Quero ococani pinintantajiacaca pincomitacaajiaquename? Iintsija pojocajiguenarijate apamentaquiro tenario nameneritate. ");
INSERT INTO cotNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iriatimpajia yojocajiaqueneriquea. Iroompaquea icanqueriquea: —¿Taa ipajita iricatica ivaantorijiqueca? ¿Taaquea ashintaro ivajiro tioncanquitsica? Icanqueriquea: —Iriguenti majirontatsica Sesa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Icantsijigari Jesoshi: —Iroosacanica, pojocajiajenerijate Sesa yashincaca iriatimpa pinetsanatimenqueroniji icanqueca, aisa pinquejetacaajiaquempariquea Aapani Irioshi, pinetsanamajajiaqueroja maasanopae icantaguequeca. Iquemajiavaquerogueti icantajiaquerica, ariquea yamenamenaitanaque intati. ");
INSERT INTO cotNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Iroompaquea irioquea oahoaitananquitsica saroseojia iramenajiaquiteriquea Jesoshi. Iriatimpajia iriguentiquea cantajiatsica aatoquea itancoretancoreitanajitsi metojatsica. Icantajiapojaqueri: ");
INSERT INTO cotNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tsatacaantantatsica, iriraquea Moishishini itioncanaque coramani paperiqui icanque inchoocaquegueti caquinte teeca irijanintempaji, aapojempagueti irimetojanajegueti irojocapanajantero imanquigare, choocaguetiquea iriguentijeguite irioquea manquigatajemparone irijanintacajaemparoquea quempetaja irioca irijanintajari metojanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Coramani ichoocaque aparo nogonoro irijanintacaquea 7. Iriraquea parianquitsica imanquigavetacaroquea manquigarentsi, cotanquitsiquea niganquiquea imetojaque teequea irijanintacaguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iroompaquea irioquea manquigavetajaro itsipa oguijatirica. Ariquea iquempetaja iriatimpa, imetojanaji teequea irijanintacaguemparoji. Ariquea iquempetaja itsipa niganquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Arimpaquea iteroncanaca maasano imanquigajiavecarogueti, teequea irijanintacajaiguemparoji. Ariquea ometojitsitanaja iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Imaica, iintsija pincantenaja, oraqueate oncoramanitapojajegueti intancoretancoreitanajegueti maasano metojatsica, ¿quericaca manquigamajatajemparoneca? Maasanotari imanquigajiavecaroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Icanqueri Jesoshi: —Aviatimpajia manaquea picomijiaca, teetarite pintsajigueroji querocaca ocanqueni Itioncacaantaqueca Aapani Irioshi coramani, aisa teequea pintsajigueroji yagavejica iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Oncoramanitapojajegueti intancoretancoreitanajegueti maasanopae metojatsica, aatoquea quericaca manquigatajatsineca, aisa manquigarentsi aatoquea yojocantajitajirotsi irimanquigajitajemparo, manatarite inquempejianajempariquea irashivantijitete Aapani Irioshi choocajiatsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Imaica aviatimpajia iroguentiquea picanque aatoquea itancoretancoreititsi metojaripae. ¿Arimpate teequea pampatsajavantacojigueroji itioncacotanaqueca Moishishini coramani iquenquetsataquegueti Aapani Irioshi maequitatsicaqui? Icanqueriquea: ‘Naroguenti Irioshimajate Averaame, Ishaaco aisa Jacovo.’ ");
INSERT INTO cotNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Teequea irio Irioshite metojatsica, iriguentiquea Irioshite anijatsica. Aviatimpajia iroguenti picomimajajiaca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ariquea icoraquepojaque aparo tsatacaantiroca itioncacotanaqueca Moishishini, iquemapojaqueri iquenquetsatavacaajiaca. Yamenaquequea itampaticamajataqueroquea Jesoshi itsatacaaquerigueti saroseojia, ariquea icanqueriquea iriatimpa: —Oraticapae icantacaantica Aapani Irioshi irinetsanajite ¿querocate anaantamajatatsica? ");
INSERT INTO cotNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iriraquea Jesoshi icanqueriquea: —Oraquea caavijica anaaque icantacaantica irinetsanajite iroguenti cantatsica: ‘Pinquemisantamajatenajate, ishiraerijia. Iriraquea Arioshite Majirontamajatatsica, iriguenti apaniromajaca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pimpintsamajataquemparija Majirontamajatatsica Pirioshite, pampaniromajatanaquerija, pimpintsashirentamajaquempari, pimpintsaguenquejanemajatanaquempari, pintampishiventamajaqueneri irooriji pipintsamajatacari.’ ");
INSERT INTO cotNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oraquea mavitetapojatsica iroguentiquea cantanquitsica: ‘Pimpintsataquemparija pigonoro pinquejetacaajempa pipintsatagueti aviatimpa.’ Teetarite onchoocateji otsipa icantacaantaqueca anaaqueroca ocatica mavite. ");
INSERT INTO cotNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iriraquea tsatacaantiroca itioncacotanaqueca Moishishini icanque: —Tsatacaantantatsica, arimajaca pinetsanamajaqueroquea, iriraquea Irioshimajaca iriguentiquea aparomajaca, teequea inchoocateji itsipa. ");
INSERT INTO cotNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ampintsamajaquempariquea ampanirontamajatanaqueri iriatimpa, ampintsaguenquejanemajatanaquempari, ampintsashirentamajatanaquempari, antampishiventamajaqueneri. Aisa ampintsamajaquempari agonoro anquejetacaajempa apintsatagueti aatimpa. Irootaquequea inintamajataque Aapani Irioshi, anaaqueroquea antaajiguenerigueti viratsipae maasanomontiina irooca aisa ajocajiguenerigueti Aapani Irioshi taaca opajitapae. ");
INSERT INTO cotNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iriraquea Jesoshi yamenaquerigueti iquenquejamajaquero itampaticamajataqueroquea yoaquero, icanque: —Irooshipojishiatsi pimajirontamajaquempari Aapani Irioshi. Ariquea icantajiaquiti mariric, ariquea oparianaca teequea quericaca coacotajerineca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Oraquea itsatacaantanajigueti Jesoshi oniganquirequi teemporo icanque: —Iriraquea tsatacaantajiguiroca itioncacotanaqueca Moishishini icanquequea: ‘Iriraquea Quirishitotatsica iriguenti ichoviquini Taavini.’ ¿Querocaquea ococani icantantajiacaroca? ");
INSERT INTO cotNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Coramanitari Ishire Aapani Irioshi iquenquejacaaquerigueti Taavini icanque: ‘Iriraquea Majirontatsica Aapani Irioshi icanqueriquea Nomajirote: Pisaviquetaja pisenampijaquenaja notincamijempequiqui, pintsipataquenaquea arejevaetanaquempa nagavejajiaquerigueti maasano catsimajiaquempica, onquejevequemparo povanquegontatsitempari.’ ");
INSERT INTO cotNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Iriraquea Taavini iriotaquequea cantaquerica: ‘Nomajirote’, ¿queroquea incoquempani inchoviquitanaqueri? Icaramirincavaetanaquequea omporoguijaventacarica, iquemajiavaquerigueti ishinejianaca. ");
INSERT INTO cotNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ariquea itsatacaantanajigueti Jesoshi icanque: —Inchiquiojitaja poguijaguijaitacotiritsijate tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iroguenti ishineventajiaca inquitsaajerontajiaquemparo ontiasearo cameetsanijite irisemeque. Aisa yoayoaitapinique ontaniqui yojocantajiguetirogueti taaca opajitapae ajaararontsipae inintajiaque inquenquetsatacaajitavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Icoguitani yoapinijiguigueti shinagogaqui icapiocantapinijiacaca, inintajiaquequea iroguisavicajitavaqueri intsipatsipaipojempariquea anaantajiatsica. Ariquea iquejejiacaquea aisa icapiocajiacagueti irishecajiaquempaquea, inintajiaque iroguisavicajitavaqueriquea intsipatacaantajiquempariquea anaantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aisa yamatavimatavivaetaqueroquea metojacoropae iteroncamajatsitaqueroquea ashintaguecaca. Aisa yamanamampeajiacariquea Aapani Irioshi teetaquea irisanticotsitempaji, isemejiaque intati. Iriatimpajia caaviji iranaajiaquequea incatsimamajajitaqueri oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ariquea yoanaquequea Jesoshi isavicaque tampatica ochoocaquegueti itetantajitarica imentaquipae yojocajiquenerica Aapani Irioshi. Yamenajiavaqueriquea maasano yojocajiaquegueti imentaquitsite. Iconoajiaca ashintajianquitsica yojocamajataquequea oshequini. ");
INSERT INTO cotNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iroompaquea ocoraquepojiquea aparo metojacoro, teequea ashintempaji, otepojiri iroatimpa mavimentaquitejaniqui omentaquitsite. ");
INSERT INTO cotNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yamenaqueroquea Jesoshi icajemajiaqueriquea itsatacaanejia icanqueriquea: —Arimajaca ocatica metojacoro teeca ashintempaji yamenaqueroquea Aapani Irioshi otetaquequea oshequini, anajaiaqueriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iriatimpajia yaagarantavajiri imentaquitsite, yashintavaevetacatari, cotanquitsiquea iroatimpa teeca ashintamajavetempaji manaquea aacaajaniquicari maasano ashincaca ovegaratantajempameca osheca. ");
INSERT INTO cotNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ariquea isotoanajiroquea Jesoshi intsompogui oniganquirequi teemporo, icanquequea aparo itsatacaane: —Tsatacaantantatsica, pameneroja inirotsentseina mapipae ipeacaantajitaroca. ¡Cameetsavaequequea mapipancopae! ");
INSERT INTO cotNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Cotanquitsiquea iriraquea Jesoshi icanqueri: —¿Arite pamenajiaquero maasanopae ocatica? Aatoquea ochoocatajitsi aparo mapi ogataajatsineca, maasanopae irisoveacomajajitaquero. ");
INSERT INTO cotNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ariquea yoayoaitanaquequea Orivotsempiqui otampaticatacoqueroquea teemporoqui, ariquea isavicaque Jesoshi oraniqui. Iroompaquea iriraquea Peerero, Santiago, Joanca, Antirishi iquempejiquempejiipojacariquea, icantajiapojiri: ");
INSERT INTO cotNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Pincamantena, ¿querocate oncarateni irisovejaiqueroni? Irooshipojegueti onetsanatantaquempaca, ¿taa opaji nontsatantajiavaquemparoca? ");
INSERT INTO cotNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iriraquea Jesoshi icanqueriquea: “Shoshoh yamatavijajitimpitsija. ");
INSERT INTO cotNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Incoraquecoraqueitaquetari oshequini pinajajiaquenaneca cantajianquitsineca: ‘Naroguenti’, ariquea iramatavijajiaqueri incaramirincatashivaetanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pinquemacojiavaquerigueti irashimirintavacaajianaquempaquea quempeji, aisa otsipapaequi quepatsi, aatoquea pitsaroajiguitsi. Aritarite onquejetanaquempaquea imaica, cotanquitsiquea aatotaja arejetsitatsi onteroncantanaquempaca maasanopae quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iriraquea guintenijianquitsica otsipapaequi quepatsi iroaroaitashijianaqueriquea osamanipaequitica, ariquea irashimirintavacaajiaquempa. Ariquea inquempejiaquempaquea majirontajiatsica inchoocagarantajiaque intigarancajiaqueri igoaretajiate iroaroaitashijianaqueriquea itsipa majirontatsica irashimirintavacaajiaquempa. Aisa omoguecaguetanaquempaquea. Irantsipevaejitaquemparoquea tasetsijencapae. Onquejeguetanaquempagueti imaica mana oparianaca intati irantsipevaetantajitaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pagamajaguitempani. Irajaianaquempiquea icapiocajiacagueti jivajiatsica incatsimatacaantajiaquempiquea, impasatacaantajiaquempi agompiaquitempi shinagogapaequi icapiocantapinijiacaca pigonorojia. Aisa irajaianaquempiquea quejemajirojiavetatsicaqui, aisa majirontajiatsicaqui. Ariquea aviatimpajia pintsavetantimojianaqueri pintsavetacotantajiaquenaqueate naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iroquetitaquea intsavetacojiqueroquea Quenquetsatsarentsimajaca Oganejencatatsica intsitacacovaetanaquempariquea maasanopae caquinteguetatsica, ariquea onteroncapojajempa. ");
INSERT INTO cotNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Oraquea iraacaantajiquempigueti irajaianaquempigueti majirontajiatsicaqui aatoquea pishoshoguiteta aatoquea piquenquejajigui pincantajigue: ‘¿Querocaca noncanque nompetanaquempagueti coajica?’ Poapoaitanaquegueti iriatimpajiaqui aatoquea inchiquioji piquenquetsatashijiaquempa aviatimpajia, iriguenti quenquejacaajiaquempironeca Ishire Aapani Irioshi cameetsanijite pintsajiaquenijite querocaca pincanque. ");
INSERT INTO cotNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Inconoagaranquempaquea iraacaantajiaqueri iriguentijeguitepae irashimajaca igonoromajaca irimetojacaantajiaqueri. Ariquea inquejejiaquempaquea irijanintajiatsica irimetojacaantajiaqueriquea irijanijiate. Itsipaquea incatsimajianaqueri iriri iriniro irimetojacaantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maasanopae irisemaneguintimentajiaquempiroquea novajiro pitsaroventajiaquenagueti, cotanquitsiquea quericaca atsipetacovaetanquitsineca aatogueti yovashiantirotsi itsarovenquenagueti arejevaequempa irimetojanaje, irioquea iriguenti irajaitanaje inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Oraquea pamenajiaquerigueti iriraquea covaeguishetaqueroneca teemporo incatianquemparogueti ontaniqui icantimentajitirigueti incatigue (quericaca apatsajavanqueroneca ocatica pinquenquejamajateroja pintsatimenqueroniji), ariquea inchoocaquegueti ontaniqui pintampinajiapanajantejate maasanopae Joreaquitica pishiashiaitapanajantejate otsempitsempiacagueti. ");
INSERT INTO cotNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Quericaca choocatanquitsineca sotsiqui omencotapojacagueti itsovironaquitequi ovancaitoqui, aatoquea yaguijitapanajanti, aato iquiji iraaguepanajantero taaca opajitapae choocatanquitsica intsompogui. ");
INSERT INTO cotNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Quericaca choocatanquitsineca iniganquitejirequi, aatoquea ipiapanajanti iraapanajantero iitsaare. ");
INSERT INTO cotNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ooshiatsi manquigarentsijia tsaraquijianquitsineca, aisa atsomijianquitsineca, caaviji antsipemajajiaquempaquea! ");
INSERT INTO cotNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aviatimpajia pamanacoventajiguempaja aatonijite otampaticatirotsi oncatsincaguitemajategueti. ");
INSERT INTO cotNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Caavijitari irantsipejitaquempa anaavaequero maasanopae yatsipejiguetacaca iroaqueragueti ipeacaacarogueti Aapani Irioshi quepatsi arejevaequemparoquea imaica. Aisa aatoquea yamenajitajirotsi oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aatomegueti icaratacaapojirome Amajirote oratica savincaguiteripae irantsipetantajiavetaquempaca interoncamajajiaquempamequea caquintejia. Cotanquitsiquea ipintsatacotacari icoguiajiaqueca, icaratacaantapojacanarica. ");
INSERT INTO cotNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Quericaca cantajiaquempineca: ‘Jeeri iricatica Quirishitotatsica’, irooca incanquempi: ‘Ichoocaque ontaniqui’, aatoquea piquemisantajiguiritsija. ");
INSERT INTO cotNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Incoraquecoraqueitaquequea tsavetantamampejaigatsica amatavijantajianquitsineca incanquequea: ‘Naroguentiquea Quirishitotatsica.’ Itsipaquea cantajianquitsineca: ‘Naroguentiquea tsavetantiroca icanquenaca Aapani Irioshi.’ Aisa ironigaanqueroquea oacaantantatsica intati cameetsanijite iramatavijajianaquerinijite oshequini. Inquejetacaajitsivetempariquea icoguiajiaqueca Aapani Irioshi, cotanquitsiquea aatoquea yagavejiritsi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pagamajaventajiguempaja, nocamantsiquempiquea imaica maasano ocatica tequeratagueti arejepojempa. ");
INSERT INTO cotNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Iroompaquea oncaraguijanaquegueti atsipevaerentsi impitsecajencatanaque catsirincaiteri, taai aato iquitasetaji. ");
INSERT INTO cotNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iriraquea impoquiropae irasacaraaguetanaquempa. Irimoguecanaquempaquea choocaguetanquitsica jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iroompaquea iramenajitavaqueriquea Irijanite Caquinte incoraquetapojajegueti incoraquetantapojajempa mararoqui, iragavejavaetapojempa iranaajiaqueriquea maasano, iroganejencavaetapojempa. ");
INSERT INTO cotNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ariquea intigarancajiaqueriquea irashivantijitete iroaroaitanaquequea intsitacaguitejajiaquitero quepatsi aisa inquite, incapiocajiaqueriquea icoguiajiaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Imaica pintsajiavaqueroja nontsatacaajiaquempica, nonquempetacaaquempiroja iguera. Iroaquerasano etsocorevanatanaque pitsajiaquequea irooshipojaji ajagantsipojaje. ");
INSERT INTO cotNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ariquea onquempetajempaquea oncoramanitapojajegueti pamenajiavajerogueti onquempetanajempagueti notsatacajaianaquempica imaica, irooquea pintsatantajiavajempa irooshipojajishiatsi incoraquetajate Irijanite Caquinte, quejetaca catiapojaca sotomorontsiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Arimajaca noncantajiaquempica, maasanopae ocatica nocantajiaquempica imaica onetsanamajatanaquempaquea tequeratagueti interoncajiguempaji maasano choocajianquitsineca omparianaquempagueti notsavetantsitacaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Oraquea inquite aisa quepatsi ompeaquempa, cotanquitsiquea oraquea nocantaguequeca aato opegatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Teequea inchoocateji tsatatsineca querocaca savincaguiteri onetsanatantaquempaca, tee aisa intsajiteji quero incarateni catsirincaiteri. Irirajia ashivantijite inquitequitica tee intsajigueji, ariquea iquempetaca Irijanite Aapani Irioshi teequea intsateji. Aparoquea icocani Aapani Irioshi iriatimpa itsaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pagamajavajemparija. Pincoguitempaniquea poguijajiavajeri, aisa pamanaguiterini Aapani Irioshi, teetarite pintsajigueji querocaca aantapojempaca oratica savincaguiteri. ");
INSERT INTO cotNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Onquempetaquemparoquea iroguegueti caquinte osamani, irojocajianajeri irashijia incantajianajeriquea maasanojia taaca opajita irisavicaventajiajeneri. Incanteri yashincaca quempoguijiroca sotomorontsi incantacoguitempani iramenaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Irootaquequea noncantantaquempica aviatimpajia, pincoquempaniquea poguijamajaguiterini, teetari pintsajigueji querocaca incoraquetantajatempaca ashincaroca tsovironaqui. Aisa teequea pintsajigueji aricaca incoraquetaje ompitsecajencaguitetanajegueti, irooca nianquiite, irooca irinijanajegueti chaapa, irooca osavincaguitetanajegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taampinaquea incomirejapojajempiquea, inchiquiojitaja yamenajiapojajimpitsijate teequea poguijajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oraquea nocantajiaquempica aviatimpajia, irooquea nocantajiaqueriquea aisa maasanojia: Pagamajajiaquempaja.” ");
INSERT INTO cotNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ariquea iriraquea saserorotejia anaantajianquitsica itsipajiacari tsatacaantajiguiroca itioncacotanaqueca Moishishini yamenajiavaquerogueti mavitetapoji savincaguiteri arejetantapojempaca Paashicoa, aisa savincaguiteripae ishecatantajitaroca pan teeca inconoantajitemparo anempoacaanaqueroneca, iquenquejajianaque queroquea incoquempani iraacaantajiaquerinijite Jesoshi irimetojacaantajiaqueri, cotanquitsiquea teequea irininteji inquemacojitaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Icanquequea: —Oraquea anaanajempagueti Paashicoa, ariquea aacaantajiaqueri. Imaicaquea imaica aatotaja aacaantajiguiritsijate aatonijite icatsimatacojianaqueritsijate maasano omporoguijaventajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ariquea yoanaque Jesoshi Vetaniaqui itsovironaquitequi Shimo icantajitica Avejancavetatsica. Isavisaviitaquequea ishecajiacaqueate, ariquea ocoraquepoji manquigarentsi amacopojiri casancajencajari vegaramajatatsica, ipeacaantajitaroquea naarero, tee inconoajatantajitemparoji otsipaja. Iroguenti yoguijaantajicaro chovintyoriqui ipeacaajitaca mapi icantajitica aravasetero. Amapojaquerogueti iriatimpaqui otsanorejacotsitaroquea oshaguitantsitariquea ishinquireguishiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iconoagarantajiacaquea savisaviitanquitsica oraniqui icatsimajianaquequea iquenquetsatavacaajianaca icanquequea: —¿Querocaquea? Opomatsajatacashiatsi casancajencajari. ");
INSERT INTO cotNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ovegaravaecaqueate anaanaquero 300 tenario. Arimesano irojocantajiquerome aanquemparome imentaqui irojocajitaquenerimequea coguitejacojianquitsica. Ariquea icatsimajiaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Cotanquitsiquea Jesoshi irooquea iquemajiavaquerigueti icantsijigariquea: —Iintsija ariotaquetsijate, aatoquea pasereajiguirotsi, cameetsavaequequea oshaguitanquenaro. ");
INSERT INTO cotNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iriraquea coguitejacojiatsica icoguitanitarite pintsipajiajempariquea, pinintajiaquegueti pincavintsajajiaqueri pincavintsajajiaqueriqueate, cotanquitsiquea naatimpatarite aatoquea picoguitani pitsipajiajanatsi. ");
INSERT INTO cotNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Imaica iroatimpa onetsanaquero agavejaqueca, oshaguitsinotantaquenaro casancajencajari ashi irojoquijijitajatenagueti nometojanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Imaica noncamanquempiquea arimaja querocagueti intsavetantajiqueroni Quenquetsatsarentsi Oganejencatatsica maasanopae quepatsipaequi, ariquea intsavetantajiqueroquea ocatica manquigarentsi oshaguiquenagueti cameetsanijite inquenquejacotimentajitajeronijite iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ariquea yoanaque Jorashi Ishicariote iramenajiaquiteriquea saserorotejia anaantajianquitsica incantajiaquiteri ininquequea iraacaantaqueri Jesoshi. Irioveca itsatacaane carajianquitsica 12. ");
INSERT INTO cotNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iriatimpajia ishinejianacaquea icanqueriquea irojocajiaqueneri imentaquipae. Iriraquea Jorashi yoanaji, iroompa ariquea iquenquejanaquequea queroca incoquerini iraacaantaquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ariquea aapojaca savincaguiteri pariantajaroca savincaguiteripae ishecatantajitaroca pan teeca onconoguemparoji anempoacaaqueroneca, irooquea aisa ijitorejantajitarica ovejajaniqui irishecajiaquempaca inquenquejacojiaqueroquea Paashicoa. Iriraquea itsatacaanejia Jesoshi icanqueriquea: —¿Querocaquea pininqueni nonetsanajiaquempironi maasanopae cameetsanijite ashecajiaquempanijite coajica ashineventajiaquemparo Paashicoa? ");
INSERT INTO cotNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ariquea iriatimpa itigarancajiaqueriquea mavite itsatacaane icantajiavaqueri: —Poapoaitanaquequea Jerosarequi, pintonquivojajiavaquempari shirampari iramacopojaquerogueti ijatsite, irioquea poguijaguijaitanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Querocagueti inquijanaqueni oraniqui ariquea pinquijaquijaitanaquequea aviatimpajia, pincantajiapojeriquea ashincaroca itsovironaquite: ‘Iriraquea Tsatacaantantatsica icanque: ¿Querocaqueate oraniqui noshecajiaquempani coajica nontsipatsipaiquempari notsatacaanejia nonquenquejacojiaqueroquea Paashicoa?’ ");
INSERT INTO cotNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iriatimpa intsipatsipaitanaquempiquea oshitamencotacagueti jenoqui, irijicojiaquempiroquea otantotacagueti caguitejeguinica, jac netsanaguecaquea maasanopae. Ariquea oraniqui pinetsanamajajiaqueroquea maasanopae ashecajiaquempagueti coajica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yoayoaitanaquequea itsatacaanejia, yarejerejeica Jerosarequi, ariquea yamenajiapojiroquea maasano quejemajataca icantajiavaquerica Jesoshi incajaranqui. Ariquea inetsanajiaqueroquea maasanopae irishecajiaquempaca irishineventajiaquemparoniji Paashicoa. ");
INSERT INTO cotNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iroompaquea opitsecaguitetanaquegueti yoanaque Jesoshi Jerosarequi, itsipatsipaitanacariquea itsatacaanejia carajianquitsica 12. ");
INSERT INTO cotNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ariquea ipimerequijajiapojaca shitaponcarontsiqui ishecajiaca. Icanque Jesoshi: —Imaica noncamanquempi, iconoaquempiquea aviatimpajia aparo aacaantenaneca, ishecatimotaquena. ");
INSERT INTO cotNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ariquea icohicoitanaca itsatacaanejia ishimampojancajianaca, yacayacaitanaque: —¿Naroguenticampa aacaanquempineca? ");
INSERT INTO cotNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iriraquea Jesoshi icanqueriquea: —Iriguenti aacaanquenaneca notsatacaane conoavetaquempica aviatimpajia 12, iriguentiquea tsipavacoquenaca notsiantancarogueti pan shovaoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aritarite ontampaticamajatanaque ocanqueca tioncanquitsica coramani itsavetacotsijicarigueti Irijanite Caquinte, cotanquitsiquea ¡irantsipevaetempanishiatsi irira aacaanquerineca! Aatomesano ivoguime iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iroompaquea ishecajiacagueti, yaitsitaroquea Jesoshi pan, yamanaqueriquea Aapani Irioshi, icantacovenquero: “Arioteesaa.” Ariquea icotarejaqueroquea yojocajiaqueneriquea itsatacaanejia icanqueriquea: —Paajiavaqueja. Iroguenti notsino. ");
INSERT INTO cotNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iroompaquea incajaranquiguitetanaquegueti yaacoquero chovintyoriqui, yamanajiriquea aisa Aapani Irioshi, icantacovenquero: “Arioteesaa.” Ariquea yojocacojiaqueneriquea itsatacaanejia, imirajiavaca maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Icanqueriquea: —Iroguentiquea noriraja sotojaatananquitsineca nometojaventajiaquerigueti caramirincavaetananquitsineca. Ocantacoqueroquea iroaqueraro paaquito. ");
INSERT INTO cotNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Imaica noncanquempiquea, aatoquea nomirajaro vinoja arejevaetapojempa nomirajemparo iroaquerajaro impeaquempagueti Aapani Irioshi Imajirojiate maasano. ");
INSERT INTO cotNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iroompaquea iteroncajianaquerogueti yamashaiventajiaquerigueti Aapani Irioshi, isotosotoitanaji yoayoaitanaque Orivotsempiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ariquea icanqueri Jesoshi: —Ocatica pitsecanquitsica maasano aviatimpajia pimpashiventacaajiaquenaquea pojocajiapanajantena. Otioncacatari ocanque: ‘Aapojempagueti nometojaqueri quempoguijirica oveja. Iriraquea ovejajia imporocajencatesano maasano.’ ");
INSERT INTO cotNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cotanquitsiquea nontancorejanajegueti naroquetiquea jivatanaquempine noanaquequea Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Icanquequea Peerero: —Impashiventacaajiavetanaquempiquea maasanopae irojocajocaivetanaquempi, cotanquitsiquea naatimpa aatotarite nojoquimatimpitsi. ");
INSERT INTO cotNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Cotanquitsiquea Jesoshi icanqueri: —Noncamanquempiquea, coajica tequeratagueti omavitetempaji irinijeji chaapa, pomanacoquenaquea 3. ");
INSERT INTO cotNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Cotanquitsiquea arimpaquea icantamajatanaque Peerero: —Ariguetija intsipatacaantajitenajate irimetojajitena, irimetojajiquenaquea, cotanquitsiquea aatoquea nomanacotimpitsi. Ariquea iquejejiaquero maasano icantajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ariquea yoayoaitanaquequea Jetsemaniqui. Irooquea yarejerejeipojacagueti iriraquea Jesoshi icanqueri itsatacaanejia: —Pisavisaviitetaja ocaniqui, naatimpa namanaquiterija Aapani. ");
INSERT INTO cotNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iriguenti itsipatsipaitanaca Peerero, Santiago, Joanca. Iriatimpa ishimampojancavaetanacaquea yatsipeshirentavaeca. ");
INSERT INTO cotNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Incajaranquiguitetanaquegueti icanqueriquea: —Noshimampojancavaetatiganimaja irooshipojishiatsi ometojavaetenanishiatsi, picancanija ocaniqui pintinajaventajiaquena. ");
INSERT INTO cotNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iriatimpa yoanaque tiijai ontaniqui itigueroasetanaca quepatsiqui, yamanaqueriquea Iriri ininquegueti impejaeneri maasanopae irantsipetaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Oraquea yamanaquerigueti icanqueriquea: —Aapani, pagavejaquequea maasanopae. Imaica nonintaveca paapitsatenarojate nantsipequempaca, cotanquitsiquea teequea nonintenica onetsanaquempa nonintica naatimpa, iroguentiquea pinintica aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ariquea yoanaji incajaranquiqui ichoocajiaquegueti itsatacaanejia, yamenajiapojiri maajiaque. Icantapojiri Peerero: —Shimo, ¿pojocanacaniquea tin? ¿Arimpate teequea pagavejajigueji osamanicoñaji pintinajajigueji? ");
INSERT INTO cotNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pintinaje, aatoquea pimaajiguitsi. Pamanacoventajiguempaja aatonijite ocovaeguishetacaajianaquempitsi covaeguisherentsi. Aviatimpajia pinintajiavecaqueate pishirequi pinetsanamajajiaquero inintaguetica Aapani Irioshi, cotanquitsiquea teetarite pintampishijigueji pitsinoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ariquea yoanaji aisa yamanajiri Iriri oquejetajaro icanquerica incajaranquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iroompaquea icoraquevetaja aisa yamenajiapojiri yojocajianacani tin aisa, otiavaetanacaritari pochoquirentsi. Ipashiventavaetanacaquea, cotanquitsiquea tee intsajigueji querocampate incantajiaquerini. ");
INSERT INTO cotNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yoanaji aisa, iroompaquea icoraquevetaja, ariquea icantajiapojajiri: —Arisacanica picantacoguitani maaguitatsimpi magorejajianaquempi. Imaica ariotapoji, arejetapojaca iraacaantantajitaquemparica Irijanite Caquinte irimetojajiaqueri covaeguishejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pincatintiitanaque, jamequetiro, jac coraquetapojishiatsi aacaanquenaneca. ");
INSERT INTO cotNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Quenquetsatanatsitiraja Jesoshi, icoraquetapoji Jorashi, irioveca itsatacaane iriojiaveca carajiavetanquitsica 12. Itsipatsipaitapojacari icaramirincavaequequea caquintejia, yamashijiapojiri itsaampitsantsameniritepae aisa inchaquiji. Iriguentijia tigarancajiaqueri saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa jivajiguirica joriojia. ");
INSERT INTO cotNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iriraquea Jorashi, aacaanquerineca Jesoshi, itsatacaaitsitanacari, icanqueriquea: —Quericaca nonintavorotapojaqueca, iriotaquequea pinintajiaqueca, paitajiguempari paajianaqueriqueate inchiquiojitaja poguishiguiritsijate. ");
INSERT INTO cotNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iroompaquea yarejetapojatiga iquempejitapojacari Jesoshi, icantapojiri: —¡Tsatacaantantatsica! Ariquea inintavorotsitari. ");
INSERT INTO cotNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ariquea iriatimpajia yaitsijiapojacari yajiricajiapojiri. ");
INSERT INTO cotNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cotanquitsiquea chooca aparo itsipatacaca Jesoshi yaitsitanacaroquea itsaampitsantsamenirite, itsopajitaro, iguempitarejitsitari yashintacaca saserorote anaantamajatanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iquenquetsatanaque Jesoshi icantajiguiri coraquetashijiaquerica: —¿Arimpate naroguenti catsimari aapitsatantatsica pamashitantajiaquenaca pitsaampitsantsamenirite aisa inchaquiji paimentajianaquenanijite? ");
INSERT INTO cotNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nocantacoguitani savincaguiteriqui notsipatsipaitaquempiquea aviatimpajia ontaniqui oniganquirequi teemporo notsatacaantavaeguitini, teequea ari paajiguenaji, cotanquitsiquea oquempetantanacaca imaica cameetsaniji onetsanamajatanaquempaniji itioncacojiaqueca tsavetantatsicani coramaniqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iroompaquea iporocajencajianaque maasano itsatacaanejia itsinampirejajianaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cotanquitsiquea chooca itsipa tequeratatirajaca inquenquevarimajate yoguijavetanacari, manaquea isavotacaroquea aramaroncajaro. Yaajiavecari, ");
INSERT INTO cotNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ipotequitsitanaca tancoren, ishiapanajanta cajaratsinoni. ");
INSERT INTO cotNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ariquea yaajianaqueriquea Jesoshi ichoocaquegueti saserorote anaantamajatanquitsica. Ariquea icoraquecoraqueipoji yomporoguijajiapojaca saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, irirajia aisa jivajiguirica joriojia. ");
INSERT INTO cotNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iriraquea Peerero yoguijatacovetanacari cotanquitsiquea impoivaetapojaque. Oraquea yarejetapojacarogueti pampatejijaniquiqui itsovironaquitequi saserorote anaantamajatanquitsica, iquijapojaque otantoqui, yamenapojiri coaretajia itajiaque. Ariquea iconoajiapojacari isavicapoji itatapojaque. ");
INSERT INTO cotNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iriraquea saserorotejia anaantajianquitsica itsipajiacari maasano majirontajiatsica capiocajianquitsica icajemacaantajiaqueriquea itsipapae intsojeventajiaquempari Jesoshi cameetsanijite onchoocaquenijite ompampiatantapojempaca irimetojantajitaquemparica, cotanquitsiquea tee onchoocateji. ");
INSERT INTO cotNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Itsojeventajiacariquea oshequini, irooquea icanque irooquea icanque, cotanquitsiquea querocampate incojiaquempani iriatimpajia teequea inquemavacaajiguempaji. ");
INSERT INTO cotNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iconoagarantajiaca itsipapae icatintiitanaca itsojeventajiacari, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Naatimpajia noquemajiaqueriquea icanquegueti: ‘Nosoveguero ocatica teemporo ipeacaacaca caquinte, nompeacaajempa otsipa aatoca ipeacaaja caquinte, ontrespojajegueti savincaguiteri nontsitacantajemparo.’ ");
INSERT INTO cotNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Icantaveca imaica, cotanquitsiquea itsipapae cantashitatiavacaro. ");
INSERT INTO cotNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ariquea icatiitsitanaca saserorote anaantamajatanquitsica icanqueriquea Jesoshi: —¿Aatompa paquiri? ¿Taaquea opajita ocatica icantacojiaquempica iricajia? ");
INSERT INTO cotNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Cotanquitsiquea Jesoshi teequea incanteji, teequea iranqueriji. Ariquea icoacotsitajari aisa, icanqueri: —¿Arimajampa aviguentica Quirishitotatsica, Irijanite Itsaroventajitaca? ");
INSERT INTO cotNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Icanquequea Jesoshi: —Naroguentiguitatsi. Oncoramanitapojajegueti pamenajiaqueriquea Irijanite Caquinte irisavicaque itincamijempequiqui Agavejamajatatsica. Aisa pamenajiavajeri inquenapojaje mararoqui. ");
INSERT INTO cotNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ariquea icotanaca icatsimatanaque saserorote anaantamajatanquitsica iperejitsitaroquea iitsaare sarararara, icanque: —¿Arimpate ancoguimenquempari itsipapae cantacoquerineca? ");
INSERT INTO cotNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jac piquemajiaquerishinete iquejemanatanacarigueti Aapani Irioshi imaica. Iintsija ¿querocaca pincantajigueni aviatimpajia? Maasanoquea icantajigui iquempetacaanca irimetojajiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iconoajiaca iquishoquishoavaequeriquea. Iponaajiaqueriquea icapocapovaequeriquea, icantajiavaqueri: —Iintsijate pintsatavaqueja taaquea capojaquempi. Iriraquea coaretajia yapatompatoncavaequeri. ");
INSERT INTO cotNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Iriraquea Peerero ichoocaque oraniqui isavi pampatejijaniquiqui. Iroompaquea ocoraquepoji aparo iromperare saserorote anaantamajatanquitsica, ");
INSERT INTO cotNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","amenapojiri Peerero itataque, amenamajatanaqueriquea sorererere, ariquea ocanqueri: —Aviatimpa aisa itsipapinitimpi Jesoshi Nasarequitica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Cotanquitsiquea yomanacotsitanacaquea, icanquero: —Tee notsatsitavaquempiroji. Teequea nonquemeji querocaca picanqueni. Isotoanaque iquijanajiro oaguitetanaquegueti osotomorotapojacagueti. Ariquea oraniqui icatiaca, iroompa inijanaque chaapa. ");
INSERT INTO cotNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Amenitsitajariquea aisa omperarentsi ocantajiguiri choocajianquitsica oraniqui, ocanque: —Iricatica irio itsipavijire Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Cotanquitsiquea yomanacotsitanaja Peerero. Iroompaquea incajaranquiguitetanaquitigui icantajiguiri choocajianquitsica oraniqui: —Arimajaca pitsipatari, aviguenti Garireaquitica. ");
INSERT INTO cotNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iriraquea Peerero icantsitanaja aisa: —¡Nocanqueshinete tee nontsatimateriji iricatica piquenquetsatacojiaqueca! Namataacagueti incatsimatimentenaronishiatsi Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iroompaquea icanquitigui, inijanajiquea chaapa. Iquenquejitsitanacaroquea Peerero icanquerica Jesoshi incajaranquitica icanqueri: “Coajica tequeratagueti omavitetempaji irinijeji chaapa pomanacoquenaquea 3.” Ariquea icotanaca iraitsitanacaquea. ");
INSERT INTO cotNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Osavincaguitetanajigueti icapiocajiaca saserorotejia anaantajianquitsica, aisa jivajiguirica joriojia, aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa maasano imajirotepae joriojia. Iquemavacaajiaca querocaca incojiaquerini Jesoshi. Ariquea yoishojianaqueri, yaajianaqueneriquea Pirato, yojocajiapojaqueneri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Iriatimpa icoacoqueriquea icanqueri: —¿Arimajaca aviguenti Imajirote jorio? Icanque Jesoshi: —Tampatica poaquero. ");
INSERT INTO cotNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Cotanquitsiquea iriraquea saserorotejia anaantajianquitsica arimpaquea itsojeventajianacari. ");
INSERT INTO cotNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iriraquea Pirato icantsitajari aisa icanqueri: —¿Aatompa paquiri? Pinquemavaqueroja maasano icantacoguetaquempica. ");
INSERT INTO cotNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Cotanquitsiquea Jesoshi teequea incantimateji, jero yamenantanacaca Pirato intati. ");
INSERT INTO cotNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Icantacoguitani aapojajagueti Paashicoa, iriraquea Pirato yametapinitaca yoguipaquijajiri aparo isantanatacotimentajiquerica ipeacaaguishetacaca, quericaca inintajiaqueca igonorojia iroguipaquijaje. ");
INSERT INTO cotNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ichoocaque aparo shirampari ipajita Varavashi, iroguenti isantanatacotimentajiqueri imetojantaquegueti itsipatacaantajicari itsipapae itsipatashijiacaca imetojantajiaquegueti, iroguenti inintajiaveca iroguisotoajiajerime majirontatsica. ");
INSERT INTO cotNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Icaramirincavaequequea oraniqui joriojia, ariquea iconoagarantajiaca yoayoaitanaque Piratoqui icantajiapojaqueri irantajeneri yametapinicaca. ");
INSERT INTO cotNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iriatimpa icantavaqueri: —¿Irioquea pinintajiaque noguipaquijajempiri Imajirote jorio? ");
INSERT INTO cotNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iriatimpa itsaque irirajia saserorotejia anaantajianquitsica manaquea icatsimatimentajiaqueriquea Jesoshi yamenajiaquegueti iriguenti yomporoguijaventajiaca, irootaquequea yaantajitanacarica iriatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Cotanquitsiquea iriraquea saserorotejia anaantajianquitsica itsatacajaiaqueri omporoguijajianquitsica icantajiaqueri: —Iintsija pincantejate: ‘Iriompaqueate poguipaquijaje Varavashi.’ ");
INSERT INTO cotNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iriraquea Pirato icanqueriquea: —Arisacanica imaica ¿querocaca noncoquerini irica picanqueca Imajirote jorio? ");
INSERT INTO cotNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iriatimpajia icajemitsijianaca: —¡Pompajacoteri! ");
INSERT INTO cotNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Icanqueri Pirato: —¿Taampate ipeacaaca? Icajemamajajianaji: —¡Pompajacoterishine! ");
INSERT INTO cotNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Iriraquea Pirato inintaquequeate iroguishinejajiaqueriquea omporoguijajianquitsica, yoguipaquijajiajiniri Varavashi. Ariquea icantacaantsitariquea Jesoshi intavaajitaqueri, irajaitanaqueri irompajacojiqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iriraquea coaretajia yaajianaqueriquea intsompoguiqui pampatejijaniquiqui imapipancotequi Pirato, icantajitiro “Peretorio”, ariquea icajemacaantajiaqueri maasano irapicoaretajiate. ");
INSERT INTO cotNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ariquea iquitsaatantajiacari otsipa quitsaarentsi camachoncamorenari. Yaajiaque tseitseiaro, ipeacaashijiacanari iramatsaero, yamatsaetsitari. ");
INSERT INTO cotNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ariquea ishiroshirontimentavaecari icanqueriquea: —¡Iricashia Imajirote jorio! ");
INSERT INTO cotNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Itavatavaavaetaqueriquea iguitoqui savoroquijiqui, iquishoquishoavaequeri, igueroventajiacari iquempetacaajiacari ishineventajitarigueti majirontamajatatsica, manaquea ishiroshirontimentavaecariquea intati. ");
INSERT INTO cotNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iroompaquea iteroncajianaquerogueti ishiroshirontimentavaecarigueti, isapocajiri camachoncamorenari, irooquea iquitsaatantajari iitsaare, yaajianaqueri irompajacojiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chooca aparo Shirenequitica ipajita Shimo, iriri Arijantero aisa Iropo. Yavisanaque iquenavaetapoji ontaniqui niganquitejipaequi. Icantajiavaqueri coaretajia irinatashitanaqueriquea Jesoshi igoroshite. ");
INSERT INTO cotNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ariquea yaavaetanaqueriquea Jesoshi ontaniqui osamani opajitaquea Gorogota, (ocanquequea: “Ochoocatigueti Shocoitontsi”). ");
INSERT INTO cotNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yojocajivecanariquea vinoja iconoantajicaro mira, cotanquitsiquea teequea irimiremparoji. ");
INSERT INTO cotNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iriraquea coaretajia yompajacojiaqueri. Ariquea ipegavijijiaca intsajiaquenijite quericaca ashinquemparoneca iquitsaaguevecaca. ");
INSERT INTO cotNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oraquea yompajacojiaquerigueti iroaquerasano ijenoquivaepoji catsirincaiteri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Oraquea itioncacojiquerogueti taate imetojimentajiqueri ocanque: “Iriguenti Imajirote jorio.” ");
INSERT INTO cotNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Itsipatacaantajicari mavite aitsitantatsica yompajacojitaqueriquea, aparo yogatiacojiqueri itincamijempequiqui, iriraquea itsipa iroguenti yogatiacojiqueri ishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Oraquea oquejetacagueti imaica iroguenti irinetsanajiqueroquea itioncacojiquerogueti coramaniqui ocanque: “Itsipatacaantajicari covaeguishetatsica.” ");
INSERT INTO cotNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iriraquea avisavisaitanquitsica oraniqui inijashinatacari icantajianaque chaguito chaguito, icanqueriquea: —¡Arisacanica querocampate imaica! Arimpate picanque: ‘Nosoveaqueroquea iteemporote Aapani Irioshi, ariquea nompeacaitajemparo, nontsitacajero 3 savincaguiteri.’ ");
INSERT INTO cotNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iintsijate pompetanaquempajate imaica, pintsoparejacotanajempajate coroshiqui paguijitapojaje. ");
INSERT INTO cotNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ariquea iquempejiaca saserorotejia anaantajianquitsica itsipajiacari tsatacaantajiguiroca itioncacotanaqueca Moishishini ishiroshirontimentavaecari, iquenquetsatavacaajiaca icanqueriquea: —Yamijiaqueri itsipapae yompetacoguetacari, cotanquitsi teequea iragavejempaji irompetacotanaquempa iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iriovetaca Quirishitotanquitsica Amajirojiate ishiraerijia, iintsija intsopajacotanajempaja coroshiqui iraguijipojaje, amenajiaquerinijite antsatimenqueriniji antsaroventimentajiaquempari. Iquejetsijianaca itsipatacaantajicarica yompajacojitaquerigueti, icantacantaguishevaetaqueri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iroompaquea itampaticavepojaca catsirincaiteri, ocantanaque pitsec maasano quepatsi, arejetacovaeca ijaguitetanajigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ariquea icotanaca iririjencavaetanaque Jesoshi icanque: “Eloi, Eloi, ¿lama sabactani?” (Ocanque: “Aapani Irioshi, Aapani Irioshi, ¿queroquea ococani pojocantanaquenaca?”) ");
INSERT INTO cotNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iconoagarantajiacaquea choocajianquitsica oraniqui irooquea iquemajiavaquegueti icantajianaque: —Pinquemerija, icajemaqueri tsavetantatsica Iriashini. ");
INSERT INTO cotNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ishiitsitanaca aparo, yaanaquequea atsimijicajatiroca oja, iticajatsitaroquea vinoja cachonerontoquijajaro, yogajenocacoqueneriquea savoroquijiqui irantsimijicajatacaaquerime. Icanque: —Iintsijate pamenerijate, amenajiavaqueritaja incoraquetashipojeri Iriashini irogaguijitajeri. ");
INSERT INTO cotNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iroompaquea icajemapanajanti Jesoshi iririjencavaetanaque, ariquea imetojanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Irooquea imetojanaquitigui, ariquea ocotanaca operejanaque omorena ticaamorenatanquitsica teemporoqui jocagatsica aatonijite iquijajitirotsi intsompoguiremajacaqui. Opecotarejanaque tampaticaquea niganquisano ocantanaque sarararararara, oquenapojiquea jenoqui arejevaetacaquea isavi. ");
INSERT INTO cotNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iriraquea imajironcaca 100 igoaretajiate Iromaquitica icatiaca oraniqui itampaticatacotaqueri Jesoshi. Oraquea iquemavaquerigueti icajemanaquegueti, aisa yamenavaquerigueti quero icotanacani imetojanaquegueti, icanque: —Arimajaca iriguenti Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aisa ariquea ochoocajiaque manquigarentsijia tiijacoñajisano ontaniqui, amenajiaqueriquea Jesoshi. Oconoacaroquea Maria Magararaquitica, Sarome, aisa Maria iriniro Jose aisa Santiago guijapojirica. ");
INSERT INTO cotNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iroguentijiatari oguijajiaquerica yanijivaetigueti Garireaqui, amitacojiaqueriquea. Aisa ariquea ochoocajiaque oraniqui otsipapae ocaramirincavaeque manquigarentsijia tsipatsipaitacarica iroaqueragueti icoraquetaquegueti Jesoshi Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ariquea ijaguitemajatanaji. Oratica savincaguiteri iroguenti inetsanatantajiacaca joriojia maasanopae incoguitejacojiaquempaca osavincaguitetanaquegueti aapojajempaca imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iriraquea Jose Arimateaquitica, iriguenti anaantatsica iguejemajirore joriojia, itsipajiacari imajirotepae icapiocapinijiacagueti. Yoguijaqueriquea Aapani Irioshi impeaquempagueti Imajirojiate maasanojia. Iriatimpa teequea intsarogueji, yoashitanaqueriquea Pirato icanqueriquea ininque irajaitanajero itsino Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Cotanquitsiquea Pirato iquemaquegueti metojaque Jesoshi yamenanaquequea intati. Icajemacaanqueriquea imajirote coaretajia icoacojiaqueriquea arimajaca metojaque. ");
INSERT INTO cotNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iquemavaquerogueti icanquerica coareta, iriraquea Pirato ishinetsitacanari Jose iraanajero itsino. ");
INSERT INTO cotNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Irootarite yoantanacaca Jose ivegarataquitiquea iniromorena shipetari. Iroompa yoanaque itsopajacotajatiri, yampiguiricantajiacari, yaanajiriquea ontaniqui yojoquijitajatiri imperitamoroqui imorotashijitirigueti metojatsica. Itigaritashitantacari iniroshimentapiri mapi, iticaacotantacari. ");
INSERT INTO cotNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Oraquea Maria Magararaquitica aisa Maria iriniro Jose amenacojiaqueriquea yojoquijitajirigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ariquea opitsecanajigueti savincaguiteriqui imagorejantajitaca, oraquea Maria Magararaquitica otsipatanacaroquea Sarome aisa Maria iriniro Santiago oahoaitanaque ovegarajiaquitiquea poncajencajaripae, oahoaitanaqueniji oshaguitantajiaquitemparime Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Iroompa osavincaguitetamanaque pariapojajaroca semana, iroaqueragueti isotoapojajigueti catsirincaiteri oahoaitanaquequea ontaniqui yojoquijitajirigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oraquea oahoaitanaquegueti quenavoquirontsiqui ocanque: —¿Taaquea tigaritajerone mapi iticaacotantajivecarica imperitamoroqui? ");
INSERT INTO cotNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Inirojeguimajaca ocanca, cotanquitsiquea arejerejeivetapojaca amenajiapojiro oo jac yoguishirincajiqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oquijaquijaipoji intsompoguiqui imperitamoroqui, amenajiapojiriquea shirampari iriaqueraca quenquevaritananquitsica, isavicaque otincamijempequiqui, quitamarovaeque iitsaare. Ariquea ocojianaca otsarotsaroitanaque. ");
INSERT INTO cotNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Cotanquitsiquea iriatimpa icanqueroquea: —Aatoquea pitsaroajiguitsi. Imaica aviatimpajia picoajiavecariquea Jesoshi Nasarequitica yompajacojivecaca, cotanquitsiquea imaica jac pochatanaji. Teequea inchoocatajeji ocaniqui. Iintsijate pamenerojate intati yojoquijijivecarigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Imaica poapoaitanaquegueti pincamantajiapojerija Peerero aisa maasano itsatacaanejia pincanqueriquea: ‘Iroanaquequea Jesoshi Garireaqui, iriquetiquea oananquitsine. Pamenajiapojajeri ontaniqui. Aritarite icantajianaquempi tequeratagueti irimetojeji.’ ");
INSERT INTO cotNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Osotosotoitapanajanti oshiashiaitanaca ompioncajianacaquea mana oajianaque intati. Teequea oncamantapojeji irooriji otsaroajianaque. ");
INSERT INTO cotNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Oraquea ipochatanajigueti Jesoshi iroaqueragueti osavincaguitetamanaji pariapojajaroca semana, iroqueti yonigaaja Maria Magararaquitica yoguisotoacoventajiaqueca 7 ampatsini ishaquiavecarogueti. ");
INSERT INTO cotNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iroatimpa oanaque ocamantajiavetapojari maasano itsipavetacaca. Amenajiapojiri iraacojiaqueri ishimampojancajianaca. ");
INSERT INTO cotNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cotanquitsiquea iquemajiavetavacarogueti ocanquegueti anijanaji Jesoshi, amenajiri, teequea inquemisantajigueroji. ");
INSERT INTO cotNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Iroompaquea Jesoshi irioquea yonigaaja mavite itsatacaane yoayoaitanaquegueti ishivoquijiavetanacaro quenavoquirontsiqui niganquitejipaequi, cotanquitsiquea manaquea icantashitatiimojiacari. ");
INSERT INTO cotNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iroompa iriatimpajia icantacantaitanaja Jerosarequi icamantajiavetapojajari itsipajia, cotanquitsiquea teequea inquemisantajigueriji iriatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iroompaquea ishecajiacagueti itsatacaanejia carajianquitsica 11, yonigaimojiajariquea Jesoshi. Ariquea icantomajajiaqueri yamenaquegueti manaquea iquishoshirentavaetanaque, teetarite inquemisantajigueriji cantajiavecarica amenajiavecarica ipochatanajigueti. ");
INSERT INTO cotNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iroompaquea icanqueriquea: —Poapoaitanaquequea pintsitacaguitejavaetanaqueroquea maasano quepatsi, pintsavetanteroquea Quenquetsatsarentsi Oganejencatatsica pintsavetantimojiaqueriquea maasano caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Taacagueti quemisantajiavaqueroneca aisa iriviñacajatacaantajianaquempa irishetacojiqueriquea iraantajitavaquemparica aatoniji yogui camorecariqui, cotanquitsiquea quericaca aatoca iquemisantirotsi, manaquea incatsimatimentajiqueri igovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iriraquea aventaquenaneca manaquea iramenajitaqueri iroguisotoaguetaqueriquea ampatsinipae shaquiajiacarica caquinte, iraventashitaquemparigueti novajiro, aisa inquenquetsatantajiaquemparoquea otsipapae quenquetsatsarentsipae teeca intsajiavetemparoji. ");
INSERT INTO cotNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Irajiricajiavequempari camaarini, aisa arigueti irojocajivequenempari quepigatatsica irimirajiavequemparoquea, aatoquea aanaqueri. Aisa impamijiaqueri joquijiguetatsica, impeaguetanajempaquea. ");
INSERT INTO cotNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iroompaquea iteroncanaquerogueti Amajirote Jesoshi iquenquetsatacaajianajirigueti itsatacaanejia, yatsomajanaja yoanaji jenoqui inquitequi isenampijapojajari Aapani Irioshi isavicapojaji itincamijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iriatimpajia yoayoaitanaque itsavetantajianaque itsitacaguitejavaetanaquero guinteninintsipae. Iriraquea Amajirote yamijiaqueriquea yagavejacaajiaqueri yonigaantajiaquero oacaantantatsica intati cameetsanijite intsajiaquenijite iriratica itsavetantimojiaqueca teequea iramatavijajigueriji.");
INSERT INTO cotNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Icarajiaquequea oshequi panquenapanquenaicaroca itioncacojiaquero maasano aquemacojiaqueca acaniqui aguinteniguetacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Itioncajiaqueroquea itsatacaajiaquenaca irirajia amenamajajiaqueroca maasano oparianacagueti arejevaetanacaro imaica, iriojiaquea tsavetantaqueroca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naatimpaquea napatsajavantaqueroquea noteroncamajaqueroqueate maasanopae, aisa nocoacomajaguetaqueriquea tsavetantaqueroca. Imaicaquea, Teopiro, namenaqueroquea cameetsataque nontioncaquempiquea nontsatacaamajaquempiroquea maasanopae, nonetsanamajaquero, ");
INSERT INTO cotNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pintsaquenijite teetarite iramatavijajiguempiji tsatacaajiaquempiroca, iroomajacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Coramani, imajirontagueti Erorishini Joreaqui, ichoocaquequea saserorote pajitatsica Sacaria. Ariquea yantavaetapiniquegueti teemporoqui itsaroventantajitarica Aapani Irioshi, teetarite aparoquea irantavaetequeate Sacaria iriguentiquea itsipajiaca ichoviquijianaqueca itsipajiacaca Aviashini coramani. Choocaquea imanquigare opajitaquea Erisaveti. Oquempetacariquea iroguentiquea ichoviquitanaqueca Aaroni. ");
INSERT INTO cotNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iriraqueate Aapani Irioshi yamenaqueriquea Sacaria aisa Erisaveti icomajamajajiaca, inetsanamajajiaqueroquea maasanopae icanquerica Amajirote itioncacojiquerogueti coramani. Teetarite inchoocateji agavejanquitsineca incanque: “Tee irinetsanamajateroji.” ");
INSERT INTO cotNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iriraquea Sacaria aisa imanquigare jac quenquevarimajajianaji, teequea inchoocatejiquea irijanite, teetarite irijanintimatempajiqueate Erisaveti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iroompaquea aapojajaqueate savincaguiteri yoayoaitantanacaca Sacaria aisa irirajia itsipajiacaca irantajigueneriquea teemporoqui itsaroventantajitarica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Igamejigaroquea isaserorotejiate jorio impegavijijiaquempa cameetsanijite intsajiaquenijite taaca opajitaquea irantajiaquequea aparopae irantajiaqueca. Iroompaquea yarejerejeipojacaquea teemporoqui icoguiajiaqueroqueate, iroompaquea iriguentiquea otampaticatanaquequea Sacaria inquijaquenijite intsompogui intaaqueneriquea Aapani Irioshi casancavaneri. ");
INSERT INTO cotNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iroompaqueate aapojacaguetiquea capichajaniquinivani intaaqueneriquea, iquijanaquequea intsompogui. Maasano omporoguijajianquitsica ichoocaquequea sotsiqui yamanajiaqueriqueate Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Icatiacaqueate Sacaria intsompogui itaaguequeneriquea, yamenitsitariquea irashivantite Amajirote catiacaqueate ocaratapojiguetiquea aretare itaantajitaroca casancavaneri ocantanacagueti itincamijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yamenitsitariqueate ariquea icotanacani itsaroitsitanacaquea yamenanaquequeate intati. ");
INSERT INTO cotNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Cotanquitsi icantiri ashivanti: —Sacaria, aatoquea pitsaroguitsi, iquemaquempiqueate Aapani Irioshi pamanaquerigueti. Pimanquigare Erisaveti ovojaempiri pirijanite. Pimpajiteri Joanca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aviatimpaquea oshequi pishinevenquempari, aisa irishinejiaquempaquea oshequi caquintejia inquemacojiaquerigueti voaque. ");
INSERT INTO cotNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Irishineventamajaquempariquea Amajirote. Aatoqueate imirimataroqueate vinoja aisa otsipapae cachojaguetatsica. Choocatirajagueti inchoocaque omotijaqui iriniro inchoocamajaqueriqueate Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iroompaquea intsaroventacaajiaquempariqueate igonorojia ichoviquijianaqueca Ishiraeri cameetsanijite intsaroventajiaquemparinijite Aapani Irioshi ashincarica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iriraquea pirijanite inquejetaquempariquea iriratica tsavetantatsica Iriashini, inchoocamajaqueriqueate Ishire Aapani Irioshi choocaquerica Iriashini paesatoniqui, iragavejacaaqueriquea quejetacaquea yagavejacaaquerigueti. Iriatimpa manaqueate irijivaqueriquea Amajirote intsatacaajiaqueriquea igonorojia irivetsinantajiavaquerita shiramparijia irijanijiate. Irirajiaquea teeca inquemisanteji intsatacaajiaqueriquea incomajamajajiaquempa cameetsanijite irinetsanatashitimentajiavaquemparinijite Amajirote incoraquepojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Icantiri Sacaria: —¿Queroquea noncoquempani nontsamajatantaquemparoca ocatica picanquenaca? Jac quenquevarimajatanajanatarite, aisa nomanquigare jac quenquevaromajatanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ariqueate icanqueriquea ashivanti: —Naroguentiquea Gaviriero, catiimotarica Aapani Irioshi. Itigarancaquenaquea nonquenquetsatacaaquempiniji noncamanquempi ocatica oguishinejantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cotanquitsiquea imaica teetarite pinquemisantavaquenaji, aatoqueate pagavejaja piquenquetsatajitsi arejevaetaquempa irivoajegueti pirijanite. Coajicaquea aapojacagueti onetsanatantanaquempaca nocanquempica ariquea pinquenquetsatanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Irirajia omporoguijajianquitsica sotsiqui yoguijaveguitarini teequea irisotojaeji Sacaria, iquenquejajiaquequea: “¿Quero ocotacani osamani ichoocatantacaca intsompogui teemporoqui?” ");
INSERT INTO cotNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iroompaquea isotoavetapojajagueti teequea iragavejajempa inquenquetsataje. Yamenajiavaquerigueti itsajianaque chooca yamenaqueca intsompoguiqui teemporoqui. Iriatimpaquea teetarite inquenquetsatajequea, manaqueate ijicojicotapojiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iroompaquea aapojajaguetiquea savincaguiteri iteroncantanajaroca yantaguetaquenerigueti Aapani Irioshi, yoanajiquea itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ariquea oaque Erisaveti, imanquigare Sacaria, cotanquitsiquea ocancaniquea otsovironaquitequi 5 taai, teequeate onigaantajempaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ocanquequea: “¡Caavijiqueate icavintsajamajaquenaquea Nomajirote! Ipintsatacotaquenaqueate aatoniji yoguipashiventajana nogonoropae incantajiaque: ‘Aricajate icatsimaqueroquea Aapani Irioshi jeroqueate teeca irijanintantempaji.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Iroompaquea aapojacagueti 6 otaaite otsaraquitanaquegueti Erisaveti, iriraquea Aapani Irioshi ariquea itigaranquitsitariquea irashivantite pajitatsica Gaviriero iroanaquequea Nasarequi Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Aritaquequea ochoocatiquea oraniqui manquigarentsi pajitatsica Maria. Iroguenti majinaro iroaquera oquenquevarotanaque. Chooca cashiacaroca ipajitaquea Jose irooshivetapojaca irimanquigatemparoquea. Iriguentiquea ichoviquini Taavini imajirote joriojia coramaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Iroompaquea iquijapoji ashivanti otsovironaquitequi, icantapojaqueroquea: —¡Pishinetempa, aviguenti ishineventamajatacaca Aapani Irioshi! Itsipataquempi Amajirote. Icavintsajamajataquempi, anaaquero icavintsajajiaquerogueti otsipapae manquigarentsi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oquemitsitariquea ariquea ocotanaca otsaroanaque oquenquejanaque: “¿Querocaca icanque?” ");
INSERT INTO cotNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Icanqueroquea ashivanti: —Maria, aatoquea pitsaroguitsi, icavintsajamajataquempiquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Imaicaquea irooshipojiquea inchoocapojempi pirijanite. Oncoajicaguitepojeguetiquea irivoaquegueti pimpajitsitempariquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Caavijiquea iranaantaquequea iroganejencamajaquempaqueate iranaajiaqueriqueate maasano. Incantajiqueriqueate Irijanite Aapani Irioshi Anaantamajatatsica. Iriraquea Amajirote Aapani Irioshi impeacaaquempari majirontatsica inquejetajempariquea Taavini choviquitaquerica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Impeaquempaquea Imajirojiate ichoviquijianaqueca Jacovoni, incoguitempaniquea irimajirontaquempa, aatoquea opejaa imajirontagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Cotanquitsiquea ocanqueri Maria ashivanti: —¿Querocaquea oncotanaquempani picanquenaca? Tequeratatirajatarite quisho iroguenaji shirampari. ");
INSERT INTO cotNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Icanqueroquea ashivanti: —Incoraquetaquequea Ishire Aapani Irioshi aviatimpaqui. Iriraqueate Irioshimajaca Anaantamajatatsica iragavejacaaquempitarite. Iriraquea pirijanite voanquitsineca aatotarite icovaeguishetimatatsi, incantajiqueriqueate Irijanite Irioshimajaca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Quejetacaquea pijitica Erisaveti jac quenquevarovaevetanajaquea, aisa icantajivetaroquea tee agavejempaji orijanintempaji, choocaquequea imaica irijanite, imaicaquea tsaraquitanaquequea icaratacotanaquequea yarejetapojacaroquea 6 otaaite. ");
INSERT INTO cotNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yagavejaquequeate Aapani Irioshi maasanopae, teequeate taaca opajitaquea manapitsatimatemparineca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iroatimpaquea ocanquequea: —Iintsija. Ariquea inquempetacaaquenaquea Aapani Irioshi maasanopae picantaquenaca. Naroguentiquea yashincaca. Ariquea yoanaji ashivanti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ariqueate onetsanatanacaquea Maria otaampinatanaque oanaquequea guinteninintsiqui Joreaqui otsempitsempiapojacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Arejetapojaca oquijapojiquea itsovironaquitequi Sacaria amenapojiroquea Erisaveti, oquenquetsatacaapojaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Oquemitsitaroqueate Erisaveti ocantapojaqueca Maria, ariquea icotanaca imoguecanaquequea irijanite omotijaqui, ichoocamajaqueroqueate Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Oquenquetsatsitanacaquea ocarajencavaetanaquequea ocanque: —Aviguentiquea icavintsajamajataque Aapani Irioshi. Maasano manquigarentsi icavintsajaqueroquea, cotanquitsiquea aviatimpa caavijiqueate anaaquero ipintsamajataquempi. Ariquea iquejetacaquea pirijanite voanquitsineca caavijiqueate icavintsajamajataqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Ariotesaa, ocoraquetaquequea onejaquitana iriniro Nomajirote! ");
INSERT INTO cotNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jeroquea noquemaquempigueti piquenquetsatapojaquegueti ariquea icotanacaquea nirijanite ishinevaetanacaquea imoguecanaque nomotijaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Icavintsajaquempiqueate Aapani Irioshi piquemisantavaqueritari, pitsaquequea irinetsanaqueroquea maasanopae itsatacaaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ariquea ocanquequea Maria: “Noquenquetsashirentanaquequea noshirequi nocanquequea: ‘Caaviji yoganejencamajata Nomajirote.’ ");
INSERT INTO cotNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Noshinevaecaquea noshirequi, noshinevencariquea Aapani Irioshi meshijaanaca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yamenaquenatari naroguentiquea yashincaca teetarite nashintempajiquea ipintsatacotantaquenaca. Irosatiquea imaica maasano choocajianquitsineca ocaniqui quepatsiqui incantajiaquequea: ‘Caavijiquea icavintsajamajataquero Aapani Irioshi’, ");
INSERT INTO cotNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","iroorijite iriraquea Agavejamajatatsica yantaquena oganejencaguetatsica. Saanca onaque ivajiro Iriomajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Icocaniquea ipintsatacojiacaji maasano pincatsajiguirica. Ariqueate iquejetacaajiacariquea avaesatiniteni, manaquea oavaetanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yonigaaqueroqueate yagavejica yantaguetaquequea oacaantantatsica intati. Yoguivorocajiaqueriquea aventacojiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yoguisotoajiaqueriquea majirontajiatsica. Iriraqueate teeca irimajirontempaji yanaacaajiavajiri. ");
INSERT INTO cotNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iriraqueate taseajiatsica yojocajiaqueneriquea cameetsaripae. Iriraqueate ashintavaetatsica ejempacotia yoajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yamitacomajajiaqueriquea ishiraerijia, iriguentitarite irashimajaca. Iquenquejajiaqueriquea icocaniquea ipintsatacomajajiacari. ");
INSERT INTO cotNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Icanqueritarite choviquijianacajica paesatoniqui: ‘Nococaniqueate nompintsatacoquempariquea Averaame aisa maasano inchoviquitanaqueca.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oraqueate Maria ochoocaquequea otsovironaquitequi Erisaveti aapojajagueti 3 taai, iroompaquea oanajiqueate ochoocatigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ocoajicaguitetapojajigueti arejetapojacaquea ovoantajemparica Erisaveti, ovoacotajiqueate iriguenti shirampari. ");
INSERT INTO cotNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oshinevaetanacaqueate ocanca. Ariqueate iquemacojiaquerogueti maasano irooshiguetanquitsica aisa ojiguetica caaviji icavintsajamajaquero Aapani Irioshi, ishinejianacaquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Iroompaquea aapojajagueti 8 savincaguiteri icoraquecoraqueitaquequea intotsaiquitacaantajiaquero ichonquimashi chaajaniquitirajaca. Inintajiavecaquea impajijiaquerimequea Sacaria iraacotsiquerime iriri. ");
INSERT INTO cotNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cotanquitsiquea iriniro ocanquequea: —Aato, ariguentiquea impajiquempa Joanca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iriatimpajia icantajianaquequea: —¿Oo querocaquea ococani? Tee inchoocatenicate pijiguetica pajitatsica Joanca. ");
INSERT INTO cotNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ariquea ijicojiqueriquea Sacaria incanquequea ininqueca impajiquempa irijanite. ");
INSERT INTO cotNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ariqueate iriatimpa ijicotsitaroquea inchapataquiqui intioncanquemparoqueate, yojocajiqueneriquea intioncanquemparoca, itionquitaquea: “Ipajita Joanca.” Mana yoayoaitanaquequea intati maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iroompaqueate itionquitsitarogueti, ariquea icotanajaqueate iquenquetsatanajiquea, ishinevencariqueate Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ariquea iquemacojiaquerogueti maasano quempejitacoguecaroca yamenajianaquequeate intati. Ariquea iquejejianacaquea maasano choocajiatsica otsempipaequi Joreaniqui iquenquetsatacojiaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Maasano quemacojiaquericaqueate iquenquejajianaquequea icantavacaajianacaquea: “¿Querocacaquea incotanaquempani irira chaajaniquiri oncoajicatapojajegueti?” Yamenajiaquetarite icavintsajamajataqueriquea Amajirote. ");
INSERT INTO cotNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iriraquea Sacaria iriri chaajaniquiri ichoocamajaqueriqueate Ishire Aapani Irioshi, iquenquejacaaqueriquea icanquequea: ");
INSERT INTO cotNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Caavijiquea yoganejencavaeca Amajirote Irioshimajaca ashintajiacajica aatimpajia ichoviquijianaqueca Ishiraeri. Icoraquetashijiacajitari irajaiavajajiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Itigaranquimojiacajiquea Meshiantatsica agavejamajatatsica, irioquea ichoviquitanaqueca Taavini netsanapinitinirica ininqueca coramani. ");
INSERT INTO cotNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Irootaquequea icantsitacaca paesatoniqui iquenquejacaajiaquerigueti comajamajajiatsica tsavetacojiaqueroca icantaquerica. ");
INSERT INTO cotNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Inchoocavetaquempaquea iroshequiavaetaquequea catsimajiacajica aisa semaneguintajiacajica, cotanquitsiquea irompejiacajiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iquenquejajiaqueritari maasano avaesatinite ipintsatacojiacariquea, iquenquejacoguitironi ivaaquitote oganejencatatsica icantajiaquerica irinetsanajiaqueneri. ");
INSERT INTO cotNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aapani Irioshi icantaqueriquea avaesatinite Averaameni coramaniqui icantamajaqueriquea ");
INSERT INTO cotNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","irompejiacajiquea inchoocajiaquegueti catsimajiacajineca aatonijite atsaroimati antsaroventajiaquemparigueti anetsanajiaqueroniji inintacaajiacajica, ");
INSERT INTO cotNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ancomajamajajiaquempaquea, anetsanashirentimojiaquempari maasano savincaguiteriqui anijatirajajigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aisa aviatimpa, irijani, incantacojiquempiquea: ‘Irioquea tsavetacotantirica Aapani Irioshi Anaantamajatatsica’, aviguentitarite jivaquerineca Amajirote, pincamantajiaqueriquea ishiraerijia irinetsanatsijiaquempaquea iroguijajiavaqueri Amajirote incoraquepojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aisa pintsatacaajiaqueriquea intsajianaquenijite queroquea incojiaquempani irimeshiantajitaquemparica aatonijite iquenquejacaguiriquea Aapani Irioshi maasanopae igovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ipintsatacomajajiacajitarite Aapani Irioshi intigarancantaquemparica irira quenapojatsica inquitequi quempevetarica catsirincaiteri isotoguigueti, ");
INSERT INTO cotNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","irisavincaguitetacojiaqueriquea pitsecacojianquitsica, irirajia guintenijianquitsica otsimancacojiavetacarigueti metojagantsi. Intsatacaajiacaji queroquea ancojiaquempani aatoniji ashoshoguiteta mana anchoocajiaque cameetsa.” ");
INSERT INTO cotNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ariquea iquenquevaritanaquequea chaajaniquiri, itampishishirentanaquequea. Ariguenti ichoocaguitini osamani oquitamampororoipojigueti irosati yonigaampojaca ipariitanacaroquea itsatacaajiaqueri ishiraerijia. ");
INSERT INTO cotNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ariqueate chaajaniquitirajaguetiquea Joanca icanquequea majirontatsica Sesa Aogoshito intioncacojiaquempaquea maasano caquintejia guinteninintsipaequi intsatantaquemparica quero icarataqueni maasano, ");
INSERT INTO cotNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","teetarite intioncacotempanica coramaniqui. Iroaqueratarite intioncacotaquempaquea imaica ipeacagueti Shirenio quejemajirovetacarica Sesa irinetsanaguequeneriquea maasano ontaniqui Shiriaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iroompaquea yoayoaitanaquequea maasano querocagueti ichoocajiavetagueti choviquijianaquerica coramani, intioncacojiaquempaqueate. ");
INSERT INTO cotNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iriraquea Jose iquenapojaque Nasarequi Garireaqui, itoncotoncoguetanaque Joreaqui, yoanaquequea iguinteniqui Taavini, opajita Verene, iriotarite choviquitanaquerica coramani, irio ivaesatiniteni. ");
INSERT INTO cotNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yoanaque ontaniqui intioncacotempaniji, itsipatanacaroquea Maria icashiacaca irimanquigaquempaca, tsaraquitaquequeate. ");
INSERT INTO cotNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ariquea yarejevepojacagueti Verenequi aapojacaquea ovoacotantajempaca Maria. ");
INSERT INTO cotNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ovoaqueriquea opariacaca. Ampiguiricacotantacariqueate paañoqui, ojoquijitantacariquea ishecatantaca viratsi, teetarite onchoocavetempaji querocampate irimaapojeni tsovironaquiqui imaantapinijitacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ontaniquiquea irooshiquegueti Verene ochoocaquegueti cataromashi ichoocajiaquequea quempoguijajiguirica oveja itinajaventajiacariquea irovejajiate. ");
INSERT INTO cotNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ariqueate yamenitsitari catiaca irashivantite Amajirote. Itsirencacotantajiapojacariquea iroganejencare Amajirote, itsaroamajajianaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Cotanquitsiquea icantajiguiri ashivanti: —Aato pitsaroajiguitsi. Iroguentiquea nocoraquetantacaca noncamanquempiquea shinetacaajiaquempineca pishinemajatantajianaquempaca aviatimpajia aisa maasano pigonorojia. ");
INSERT INTO cotNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ontaniquiquea ontaniqui Verenequi ichoocavetagueti Taavini coramaniqui voaquequea Meshiajiaquempineca, iriotaque Quirishito Amajirote. ");
INSERT INTO cotNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Imaicaquea poapoaitanaquegueti pamenajiapojaqueriquea ampiguiricacotacaquea paañoqui yojoquijicaquea ishecatantaca viratsi. Irootaquequea pintsatantaquempaca teetarite namatavijajiguempiji. ");
INSERT INTO cotNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Taampina iconijatsitapoja iriatimpaqui itsipapae inquitequitica catintiijiacaquea icarapiovaetaque. Ishineventajiacariquea Aapani Irioshi icantajigui: ");
INSERT INTO cotNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ontaniquiqueate jenoqui incantajiqueriqueate: ‘Caavijiquea yoganejencamajata Aapani Irioshi.’ Acaniquiquea quepatsiqui inchoocajiaquequea cameetsa maasano incavintsajajiaqueca Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ariqueate yoayoaitanajigueti irashivantijitete Aapani Irioshi jenoqui inquitequi, iquenquetsatavacaajianacaquea iriatimpajia icantajigui: —Jamequetishiatsi oahoaitanaque Verenequi amenajiaquiteriqueate itsatacajaianacajica. ");
INSERT INTO cotNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yoayoaitanaquequea, itaampinatanaque yarejerejeipojaca yamenajiapojiroquea Maria aisa Jose jeri aisa chaajaniquiri joquijitaca, yojoquijitantacaroquea ishecatantaca viratsipae. ");
INSERT INTO cotNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iroompaqueate yamenajiapojirigueti itsavetantajiapojaqueroquea maasanopae icamanquerica irashivantite Aapani Irioshi irashi chaajaniquitirajaca. ");
INSERT INTO cotNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Maasano quemajiavaquerica itsavetantajiaquerogueti yamenajianaquequeate intati. ");
INSERT INTO cotNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Oraquea Maria ococaniquea oquenquejaguitironiquea maasanopae, teetarite ompeacotemparoji. ");
INSERT INTO cotNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ariquea yoayoaitanajiquea quempoguijajiguirica oveja, ishineventajianacariquea Aapani Irioshi, yamenajiaquequeate onetsanatanacaquea maasanopae icantajiaquerica irashivantijitete Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ariqueate yarejetacotapojacarogueti savincaguiteri 8 itotsaiquijiqueriquea ichonquimashi irijanite Maria. Ipajijiqueriquea Jesoshi, aritarite icanquero irashivantite Aapani Irioshi itsatacaaquitirogueti tequeratagueti inchoocatimateji. ");
INSERT INTO cotNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ariquea iriraquea Jose aisa Maria inetsanaqueroquea ocanqueca itioncacotanaqueca Moishishini, jeroquea arejetapojajagueti savincaguiteri incantantajiaquemparica saserorote: “Cameetsatanajimpi imaica aatoniji picovaetajiro teemporo itsaroventantajitarica Aapani Irioshi”, yoanaquequea Jose aisa Maria Jerosarequi yaajianaqueriquea Jesoshi teemporoqui incanquequea: “Jeri irica irijani.” ");
INSERT INTO cotNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ariquea iquejetacaajiacaroquea imaica cameetsanijite irinetsanatimentajiaqueronijite Itioncacaantaqueca Amajirote coramanitica ocanquequea: “Maasano iriquetica pipariacaca pirijanincaca pojocajeneriquea Amajirote irashintajempariniji.” ");
INSERT INTO cotNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yoayoaitanaquequea yaajianaquequea viratsi yojocajiaqueneriquea saserorote intajaiaqueneriquea Aapani Irioshi, irinetsanajiaqueroniji Itioncacaantaqueca Amajirote ocanquegueti irojocajiaqueneriquea “mavite jeento irioca mavite emoreni iriaqueraca quimoponatananquitsica.” ");
INSERT INTO cotNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oraniquiquea Jerosarequi choocaquea aparo tsaroventamajatarica Aapani Irioshi, ipajitaquea Shimeone. Icomajamajatacaquea. Yoguijaguitiniquea coramaniqui incoraquetaquequea Meshiantanquitsineca shinetacaajiajemparineca ishimampojancajiacagueti maasano ishiraerijia. Iriguentiquea choocaqueri Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iriotaquequea cantaquerica aatotagueti yameniri incoraquequegueti Meshiantanquitsineca intigarancaqueca Aapani Irioshi, aatotajate imetojita. ");
INSERT INTO cotNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Irira Ishire Aapani Irioshi itigaranquitariquea Shimeone iroanajequea teemporoqui, iquijapojajiquea otantotacagueti. Ariquea ichoocaque icoraquejiaquegueti Jose aisa Maria yamajiaquerigueti Jesoshi irinetsanataqueronijite itioncacotanaqueca Moishishini coramanitica. ");
INSERT INTO cotNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Iriraquea Shimeone yamenavaquerigueti Jesoshi yaitsitariquea yatsomajitsitari ishineventanacariquea Aapani Irioshi icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Imaicaquea, Nomajirote, jac netsanatapojaca picanquenaca coramanitica. Pininquegueti nometojaque imaica naatimpa paajanire, cameetsavaeque. ");
INSERT INTO cotNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Imaicatari nonejaqueri noquijaqui meshiantanquitsineca pitigarancaqueca, ");
INSERT INTO cotNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","pinetsanatimojiaquerica maasano caquinteguetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Intsirencacoshirentajiaqueriquea teeca iriojia joriojia intsajiaquenijite queroquea incojiaquempani irimeshiantajitaquemparica. Inquemacojiaquerigueti irishinevaejiaquempaquea, irishineventajitaquempariquea ishiraerijia pashintajaca.” ");
INSERT INTO cotNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ariquea iquemavaquerigueti Jose aisa iriniro Jesoshi iquenquetsatacoquerigueti yamenajianaquequeate intati. ");
INSERT INTO cotNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iriraquea Shimeone yamanacoventajiaqueriqueate icanquequea incavintsajamajajiaqueriquea Aapani Irioshi, ariquea icanqueroquea Maria iriniro Jesoshi: —Pamenequea quero incotanaquempani iricatica, irio iromposantajiaquempaca oshequini Ishiraeriqui, irio aisa incatiantajianajempaca itsipajia oshequini. Ironigaantaqueroquea inintaqueca Aapani Irioshi, cotanquitsiquea inchoocagarantajiaquequea oshequini manintaquerineca, ");
INSERT INTO cotNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","onconijavaetantanaquempaca iquenquejajiaqueca. Maasanopaequea ocatica manaqueate oshimampojancacaaquempiquea aviatimpa, manaquea onquejevequemparo irisatajajitempigueti osotoatsantsamenivaeque. ");
INSERT INTO cotNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ariquea ochoocaquequea oraniqui aparoquea manquigarentsi tsavetantiroca icanqueroca Aapani Irioshi opajitaquea Aana, iroguentiquea irorijanite Panoerini ichoviquitanaqueca Ashereni coramanitica. Iroatimpaquea oquenquevarovaetini coramani. Oraqueate iroaqueragueti oquenquevarotanaquegueti imanquigajivecaroquea, ariquea anaanajaguetiquea 7 ajagantsini imetojaquequea manquigavecaroca. ");
INSERT INTO cotNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Imaicaquea ochoocatashitajaquea ocaravaetanaque 84 ajagantsini. Ocoguitaniquea ochoocapiniquequea teemporoqui. Osanticopiniqueroquea osheca teequea oshecatajempaji cameetsanijite osavicavenquerinijite Aapani Irioshi amanaqueriquea savincaguiteriqui aisa pitsecariqui. ");
INSERT INTO cotNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Irooqueate amenavaquerigueti Jesoshi yamajiquerigueti ocoraquepojiqueate ocanqueriquea Aapani Irioshi: —¡Ariotesaa, cameetsavaeque! Ariquea otsavetacotantaqueriquea ocantajiaqueriquea maasano oguijajiaquerica incoraqueque ompetajemparoneca Jerosare. ");
INSERT INTO cotNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iroompaquea Jose aisa Maria iteroncajianaquerogueti inetsanajiaquerogueti maasanopae Itioncacaantaqueca Aapani Irioshi icampojajaqueate Garireaqui, yoayoaitanaquequea iguintenicagueti Nasarequi. ");
INSERT INTO cotNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iriraquea Jesoshi arimpa ijatiriquea iquenquevaritanaque itampishitanaquequea, aisa itsamajati iquenquejamajatanaque. Caavijiquea icavintsajamajataqueri Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Icantacoguitani iriri aisa iriniro aapojajagueti savincaguiteri Paashicoa yoayoaitapiniquequea Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iroompaquea yajagantsitacocagueti Jesoshi 12 irajagantsite, aapojajagueti aisa Paashicoa, ariquea itsipatanacari. ");
INSERT INTO cotNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iroompaquea anaanajaguetiquea Paashicoa icantajianajagueti, iriraquea Jesoshi chaajaniquitirajagueti ichoocatajiquea oraniqui Jerosarequi. Cotanquitsiquea Jose aisa iriniro Jesoshi teequea intsajigueji, ");
INSERT INTO cotNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","yamenajiaquequea ariji yoguijaguijaitanajiriquea igonorojia. Ariquea opitsecavetanajagueti yamenaguevetajari tee anejeriji, itsitacaguevecaroquea oraniqui icoacotsivetariquea ijiguetica aisa itsipatsipaicaca, ");
INSERT INTO cotNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","teequea iramenajigueriji, tee anejeriji. Osavincaguitevetanacagueti yoayoaitajatiquea Jerosarequi iramenaguetapanajanteritaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ocarataque 3 savincaguiteri yamenaguetajiri, ariquea yamenapojajiri quijaque otantotacagueti teemporo, savicaquequea iconoajiacariquea tsatacaantajiguiroca itioncacotanaqueca Moishishini coramanitica, iquemisantajiavaqueriquea icoacotantavaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iriatimpajia icoacotsimajavetariquea manamajaguetanquitsica, cotanquitsiquea iriatimpa yoguisotoajiavaqueneriquea. Maasano quemajiavaquerica yamenamenaitanaquequea intati, yamenajiaqueriqueate caaviji itsamajati. ");
INSERT INTO cotNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oraquea Maria aisa Jose yamenapojajirigueti yamenajianaquequea intati. Ariquea ocanqueriquea iriniro: —¿Taaquea, irijani, piquejetantajiaquenaca imaica? Namenaguevetajimpiqueate naatimpa aisa piri notsitacaguevecaroqueate, tee anejempiji, ocantavaetaquitanaquea tsarorec. ");
INSERT INTO cotNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iriraquea Jesoshi icanqueroquea: —¿Queroquea ococani pitsitacavaetantavetanacaroca pamenajiaquenaquea? ¿Arimpate tee pintsateji iroguentiquea nosavicaventamajaque inintaguetica Aapani? ");
INSERT INTO cotNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cotanquitsiquea iriatimpajia teequea intsajigueji taacaquea icanqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ariqueate itsipatsipaitanajariquea Nasarequi. Iriatimpaquea icocaniquea iquemisantamajatiriquea iriri aisa iriniro. Iroatimpaquea ococaniquea oquenquejacoqueroquea maasanopae icanqueca, teequea ompeacotemparoji. ");
INSERT INTO cotNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iriraquea Jesoshi arimpaquea iquenquevaritanaque, aisa arimpaquea itsamajatanaque. Iriraquea Aapani Irioshi ishinevencariquea, aisa caquintejia maasano ishineventajiacariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Coramani imajirontaca Tiverio Sesa Iromaqui. Iroompa ovegaratacagueti 15 ajagantsini imajirontacagueti, choocaquea iramajirore pajitatsica Pontsio Pirato itigarancaqueca irinetsanajiaqueneriniji Joreaquitica. Iriraquea Erorishi iriguentiquea netsanajiguirica Garireaquitica. Choocaquea iriguentijeguite pajitatsica Jeripe, iriatimpaquea iriguentiquea netsanajiguirica Itoreaquitica aisa Teraconitequitica. Iriraquea netsanatantatsica ontaniqui Aviriniaqui ariguenti ipajica Irisaniashi. ");
INSERT INTO cotNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aisa choocaquea mavite saserorote anaantamajatanquitsica. Aparoquea ipajitaquea Anashi, iriraquea itsipa ipajita Caipashi. Iriraquea Joanca, irijanite Sacaria, choocaquea ontaniqui, ichoocaquequea osamani oquitamampororoitapojigueti. Ariquea iquenquetsatacaaqueri Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iquemaquerigueti Joanca yoanaquequea icantanacaroquea Jororanequi, itsitacavaejianaqueriqueate choocajiatsica oraniqui, itsavetantavaetanaqueroqueate icantajiguiriquea: “Pincantashitatijaianajempa povashiantajianajero pipeacaaguishejiavecaca, piviñacajajianaquempaquea aatonijite icatsimatimentajiguimpiroquea Aapani Irioshi maasanopae pigovaeguisherejia, manaqueate irishetajempiroquea.” ");
INSERT INTO cotNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aritarite itionquicaroquea Isaiashini coramani icanquequea: “Inquenquetsataquequea oquitamampororoitapojigueti iririjencani, incanquequea: ‘Pinetsanatashijiavaquempari Amajirote inquenantapojempaca, pintanarejagueteneri iguenavoquiropae ontampaticapoquitantanaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Querocacaquea oquichovitoquiaguecagueti intijajiquero cameetsanijite ovepampajantanajempaca. Oraquea otsempiguetatsica aisa otsonquiinapae irivepampajajiguequero. Oraticaquea quenavoquirontsi ticopoquiguetanquitsica ontampaticavoquitanaque. Irooqueate quenavoquirontsi quichovitoquiaguetanquitsica irivevajajiguetaqueroqueate. ");
INSERT INTO cotNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ariquea iramenajiaque maasano caquinte quero icota Aapani Irioshi imeshiantigueti.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oraqueate yoayoaitanaquegueti tirorerere caquintejia iriviñacajajigueriquea Joanca, iriatimpa icantajiavaqueriquea: “¡Quejejiaquempiquea irijanijiate sanatari! Pitsanirovetacaquea. ¿Taate cantajiaquempi picoraquecoraqueitantacaca acaniqui noviñacajajiaquempiquea aatonijite icatsimajiguimpiquea Aapani Irioshi oncoramanitapojajegueti incatsimatimentajiaquerigueti maasano igovaeguisherejia? ");
INSERT INTO cotNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iintsija pinetsanamajajianaquempaja iramenajiaquempinijite maasano arimajaca picantashitatijaianaja povashiantajianajiro picovaeguishevetacaca, pintsaroventamajatanajemparija Aapani Irioshi. Imaica aatoja picantajigui: ‘Aatoqueate icatsimajigana Aapani Irioshi, naroguentitari ichoviquijiani Averaameni.’ Pamenajigueroja oratica mapiporoqui. Irininquegueti Aapani Irioshi iragavejaquequeate impeacaajiaquemparoquea ichoviquivaejianaqueca Averaameni. ");
INSERT INTO cotNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jac, yaajitiro poshontyo, itsitijitanaquero inchaquijitaquero ovari maasano inchato teeca oncameetsateji oitsoqui, ariquea intajaiquero paamariqui.” ");
INSERT INTO cotNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iriatimpajia icantsijigariquea: —¿Querocaquea noncojiaquempani? ");
INSERT INTO cotNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Icantiriquea Joanca: —Choocagueti ashintanquitsica mavite iitsaare irojocagaranqueneriquea quericaca teeca inchoocatacoteji. Aisa quericaca choocatacotanquitsica isheca irojocaqueneriquea teeca inchoocatacoteji. ");
INSERT INTO cotNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ariquea ichoocajiaquequea oraniqui capiocapinijiguinirica majirontatsica imentaquipae, iroguentiquea icoraquetashijiaque iriatimpajia aisa incampojeriquea Joanca iriviñacajajiaqueri. Iquemajiaquerigueti iquenquetsavaequegueti Joanca icantsitanacaquea iriatimpajia: —Tsatacaantantatsica, naatimpajia, ¿querocaquea noncojiaquempani? ");
INSERT INTO cotNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Icantsijigariquea: —Imaicaquea aviatimpajia aatoja poganaajiguiniriquea pigonorojia, iroguenti paajiaque intati icanqueca majirontatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ariquea icoacojiaqueriqueate coaretapae aisa icantsijigariquea: —Naatimpajia, ¿querocaquea noncojiaquempani? Icantajiguiriquea Joanca: —Aviatimpajia aatoqueate paapitsajiguiritsi taaca opajitapae yashincaca itsipapae aisa aatoquea picantajiguiri: ‘Aatogueti pojocanaro noninqueca noncatsimaquempiquea.’ Aatoja pamanantajigui imentaquipae itsipa, aatoja picantitsi: ‘Aatogueti pojocana nontsojevenquempiquea incatsimaquempiquea majirontatsica.’ Iriraquea imentaquitsite ivegaraquempica majirontatsica ariotapojaquequea, aatoquea pinintajiguitsi itsipapae. ");
INSERT INTO cotNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Irirajiaquea maasano capiocajianquitsica oraniqui ariquea icojianaca inintamajajianaquequea intsamajajiaqueri Joanca iriocajate Quirishitotatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Cotanquitsiquea Joanca icantajiguiriquea maasano: “Naatimpa iroguenti nantaque noviñacajatantajiaquempiro oja iramenantajiquemparoca arimajaca picantashitatijaianaca povashiantajianajiroquea pipeacaaguishetacaca, cotanquitsiquea incoraquepoje impoitapojenaneca caaviji yanaaquenaquea yagavejamajati. Ooshiatsi, aatotarite noquempejitaritsiquea iriatimpa nompeaquempame amiquerineca noishorejacoquerimeca igaviguitire. Iriatimpa inquempetacaantaquemparo iroviñacajatantajiaquempiri Ishire Aapani Irioshi aisa paamari. ");
INSERT INTO cotNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Incoraquepojaquegueti iroashiguetapojempariquea queri tsaroventamajacarica. Inquempetanaquemparoquea aguerogueti oitsoqui, asagorejitemparo, ampishoncavaqueroquea oncoraquejencaquegueti chovigajenca, aanaqueroquea osagoma, onchoocatashitanaquempa oitsoqui. Aguijaavaqueroquea shimatoqui anquempoguijitemparoquea. Oraquea osagoma antaitemparoquea. Ariquea inquempetaquempaquea Amajirote incapiocajiapojaqueriquea tsaroventamajacarica intsipatsipaitanajempari jenoqui ichoocatigueti Aapani Irioshi. Iriraquea teeca intsaroventajiguempariji intigarancaqueriquea camorecariqui teeca ontsivacavaete, incoquempaniquea irantsipevaejiaquempaquea.” ");
INSERT INTO cotNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ariquea iquejetacaquea imaica Joanca icamantajiaqueri maasano quero incojiaquempani, oshequi icamantaguetaqueri, itsavetacotimojiaqueri Quenquetsatsarentsi Oganejencatatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aisa icantomajaqueriquea majirontatsica Erorishi, yamenaqueriquea yaapitsaqueriqueate iriguentijeguite imanquigare pajitatsicaquea Eroriashi. Teetarite aparoquea onchoocateji ocatica. Icantimentaguequeriquea aisa taaca opajitapae icovaeguisheguetacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ariquea yogaavaetanaca Erorishi, yogavitaquero oca: isantanatacotsitariquea Joanca. ");
INSERT INTO cotNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Oraqueate tequerataguetiquea irisantanatacojiteriji Joanca, choocatirajaquea iviñacajatantaguitiniquea, ariquea iviñacajatacaantajiaca oshequini caquintejia, ariquea iquejetacaquea aisa Jesoshi iviñacajatacaantacaquea iriatimpa. Ariquea iriraquea Jesoshi yamanaqueriquea Iriri. Iroompaquea yamanaquitiguiriquea otanarejanacaquea inquite ");
INSERT INTO cotNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","yamenajitavaqueriquea Ishire Aapani Irioshi iquempetapojacariquea emoreni yampiguiricashipojacariquea iriatimpaqui. Ariquea iquenquetsajencajitanaque jenoqui inquitequi, icanque: —Aviguentiquea Irijani nopintsamajatacaca, noshineventamajataquempiquea aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ariquea yajagantsitacotanaquequea Jesoshi 30 ajagantsini iparianacarogueti itsatacaantaque. Ijijitaquejiquea iriojiquea irijanintamajatari Jose, cotanquitsiquea iriguentiquea choviquitanaqueri Eri. ");
INSERT INTO cotNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Iriraquea Erini iriguenti irijanite Matate. Irira Matateni iriguenti irijanite Irevi. Irira Irevini iriguenti irijanite Merequi. Irira Merequini iriguenti irijanite Jana. Irira Janani iriguenti irijanite Jose. ");
INSERT INTO cotNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Irira Joseni iriguenti irijanite Matatiashi. Irira Matatiashini iriguenti irijanite Amoshi. Irira Amoshini iriguenti irijanite Naomo. Irira Naomoni iriguenti irijanite Eseri. Irira Eserini iriguenti irijanite Nagai. ");
INSERT INTO cotNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Irira Nagaini iriguenti irijanite Maati. Irira Maatini iriguenti irijanite Matatiashi. Irira Matatiashini iriguenti irijanite Semei. Irira Semeini iriguenti irijanite Joseco. Irira Joseconi iriguenti irijanite Jora. ");
INSERT INTO cotNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Irira Jorani iriguenti irijanite Joanani. Irira Joananini iriguenti irijanite Iresa. Irira Iresani iriguenti irijanite Sorovaveri. Irira Sorovaverini iriguenti irijanite Saratieri. Irira Saratierini iriguenti irijanite Neri. ");
INSERT INTO cotNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Irira Nerini iriguenti irijanite Merequi. Irira Merequini iriguenti irijanite Ari. Irira Arini iriguenti irijanite Cosame. Irira Cosameni iriguenti irijanite Erimarami. Irira Erimaramini iriguenti irijanite Eri. ");
INSERT INTO cotNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Irira Erini iriguenti irijanite Josoe. Irira Josoeni iriguenti irijanite Eriesere. Irira Eriesereni iriguenti irijanite Jorimo. Irira Jorimoni iriguenti irijanite Matate. ");
INSERT INTO cotNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Irira Matateni iriguenti irijanite Irevi. Irira Irevini iriguenti irijanite Shimeone. Irira Shimeoneni iriguenti irijanite Joraa. Irira Joraani iriguenti irijanite Joname. Irira Jonameni iriguenti irijanite Eriaquime. ");
INSERT INTO cotNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Irira Eriaquimeni iriguenti irijanite Merea. Irira Mereani iriguenti irijanite Mena. Irira Menani iriguenti irijanite Matata. Irira Matatani iriguenti irijanite Natani. ");
INSERT INTO cotNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Irira Natanini iriguenti irijanite Taavi. Irira Taavini iriguenti irijanite Isai. Irira Isaini iriguenti irijanite Overi. Irira Overini iriguenti irijanite Voose. Irira Vooseni iriguenti irijanite Saramoni. Irira Saramonini iriguenti irijanite Naasone. ");
INSERT INTO cotNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Irira Naasoneni iriguenti irijanite Aminaravo. Irira Aminaravoni iriguenti irijanite Arame. Irira Arameni iriguenti irijanite Eserome. Irira Eseromeni iriguenti irijanite Parese. Irira Pareseni iriguenti irijanite Joraa. ");
INSERT INTO cotNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Irira Joraani iriguenti irijanite Jacovo. Irira Jacovoni iriguenti irijanite Ishaaco. Irira Ishaaconi iriguenti irijanite Averaame. Irira Averaameni iriguenti irijanite Tare. Irira Tareni iriguenti irijanite Nacori. ");
INSERT INTO cotNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Irira Nacorini iriguenti irijanite Serogui. Irira Seroguini iriguenti irijanite Iragao. Irira Iragaoni iriguenti irijanite Peregui. Irira Pereguini iriguenti irijanite Evere. Irira Evereni iriguenti irijanite Shera. ");
INSERT INTO cotNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Irira Sherani iriguenti irijanite Cainane. Irira Cainaneni iriguenti irijanite Arepaquisare. Irira Arepaquisareni iriguenti irijanite Sheme. Irira Shemeni iriguenti irijanite Noe. Irira Noeni iriguenti irijanite Irameco. ");
INSERT INTO cotNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Irira Irameconi iriguenti irijanite Matosare. Irira Matosareni iriguenti irijanite Enoco. Irira Enoconi iriguenti irijanite Jarete. Irira Jareteni iriguenti irijanite Maarareere. Irira Maarareereni iriguenti irijanite Cainane. ");
INSERT INTO cotNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Irira Cainaneni iriguenti irijanite Enoshi. Irira Enoshini iriguenti irijanite Sete. Irira Seteni iriguenti irijanite Arai. Irira Araini iriguenti irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oraquea iroaqueragueti iviñacajatacaantacagueti Jesoshi Jororaneniqui ichoocamajapojaqueriqueate Ishire Aapani Irioshi, yaanaqueriquea ontaniqui oquitamampororoitapojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ariquea icoraquetashiqueriquea imajirote ampatsini yasereseretaqueriquea yamenantavetacari inintavecaquea irantacaaquerime teeca irininteji Aapani Irioshi. Ariquea ichoocaque Jesoshi oraniqui oavaetanaquequea 40 savincaguiteri, teequea irishecatempaji. Ogatsimajatanaqueri itase. ");
INSERT INTO cotNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iroompaquea icantaqueriquea ampatsini: —Iintsija arimajagueti aviguentica Irijanite Irioshi iintsijate pincanteroja ocatica mapi ompeanaquempata pan pishecataquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Cotanquitsiquea Jesoshi icanqueriquea: —Choocatarite otioncacocagueti ocanquequea: ‘Teequea aparo ontampishitacaanteji isheca caquinte, jero aisa maasano icanqueca Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iroompaquea yaanaqueriquea jmm agasataanquitsica yonigaaguetaqueri maasanopae quepatsi yashincaca majirontaguetatsica aisa maasanopae yashintajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Icanqueriquea: —Iintsija nompeacaitsitempiquea imajirojiate maasano, nojocaquempiquea maasano yashintajiacaca. Aritarite maasanopae ocatica pamenaguequeca iroguentitari nashi. Naatimpaquea nagavejaque nojocaqueneri quericaca nonintacaaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ariguetija piguerovenquena pintsarovenquena, pashintaguetaquemparoquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Icantsitanajaquea Jesoshi aisa icanqueri: —Choocatarite otioncacagueti ocanquequea: ‘Pintsaroventaquemparija Majirontamajatatsica Pirioshite, aparoqueate iriguenti pimajirontamajaquempa.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iroompaquea ariquea yaanaqueriquea Jerosarequi icatiacaapojacariqueate teemporoqui itsaroventantajitarica Aapani Irioshi ochoviinatapojacagueti ocaravaequequea jenoqui ocanca, icanqueriquea: —Iintsija arimajagueti aviguentica Irijanite Irioshi, iintsijate pisapocanaque isaviji, ");
INSERT INTO cotNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ocanquetarite itioncacojiquerogueti ocanque: ‘Intigarancajiaquempiriquea Irioshi irashivantijitete, quisho iroaroaitanaquempi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Irajiricanaquempiquea irantsomajanaquempi aatonijite pitsitincapojaro mapi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Icantsitanacaquea Jesoshi icanqueriquea: —Cotanquitsiquea choocatarite itioncacojiquerogueti aisa ocanquequea: ‘Aatoquea pamenantaritsi Majirontamajatatsica Pirioshite.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ariquea iriraquea imajirote ampatsini iteroncaquerogueti maasano yamenantavetacarigueti, itsinampirejavetajatari. ");
INSERT INTO cotNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iroompaquea yoanajiqueate Jesoshi Garireaqui. Ariquea ichoocamajaqueriquea Ishire Aapani Irioshi yagavejacaaqueriquea, ariquea iquemacojiaqueriquea maasano choocajiatsica oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Itsatacaantaguetanaquequea shinagogapaequi icapiocantapinijiacaca joriojia, ishineventajianacariquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ariquea yoanaquequea Jesoshi Nasarequi iquenquevaritaquegueti coramani. Iroompaquea aapojajagueti savincaguiteri imagorejantajitaca yoanaquequea shinagogaqui icapiocantapinijiacaca joriojia, iquijapojaquequea, ariqueate icotaniquea iriatimpa yoampinicaroqueate savincaguiteri imagorejantajitaca. Ariquea icatiacaquea irampatsajavantaquero Iguenquetsatsare Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yojocajiqueneriquea paperi itioncanaqueca tsavetantatsica Isaiashini coramaniqui. Yaitsitaroquea iponarejitaro yapatsajavantaqueroquea yamenaguequeroquea otioncacagueti ocanquegueti: ");
INSERT INTO cotNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ichoocaquenaqueate Ishire Amajirote, iroorijite inintacaaquenaquea nontsavetantavaetanaqueneriqueate maasano coguitejacojianquitsica, nontsatacaantaquemparica Quenquetsatsarentsi Oganejencatatsica. Itigarancaquenaquea nontsavetantavaejianaqueneriqueate maasano yaajivecaca nontsatacaantaquemparicaquea queroquea incojiaquempani cameetsanijite iroguipaquijajitajerinijite. Itigarancaquenaquea namenacajaiajerinijite shamponcajaguetatsica, nompejiaquempariquea icatsimacatsimajitica. ");
INSERT INTO cotNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nontsatacaajiaqueriquea noncanquequea: ‘Imaicaquea aapojacaquea incavintsajamajatantaquempica Aapani Irioshi.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iroompaquea iteroncanaquitiguiroquea yapatsajavantaquerogueti yampiguiricajiroquea yojocajiniri jocaquenerica incajaranqui, isavicanaquequea. Maasanoquea choocajianquitsica shinagogaqui yamenamenaitanaqueriquea sorerere. ");
INSERT INTO cotNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ariquea iquenquetsatanaquequea icanquequea: —Imaicaquea onetsanatimojiaquempi ocatica Tioncarentsi piquemajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Maasanoquea iquenquetsatacotaquerigueti Jesoshi, ishinevencariqueate, yamenajianaquequea intati, yamenajiaqueroquea cameetsavaequequea icantaguetaqueca, cotanquitsiquea icantavacaajianacaquea: —Nojiquerisacanica irio irijanite Jose. ");
INSERT INTO cotNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Icantajiguiriquea: —Arimaja pincantajiaquena: ‘Aavintantatsica, paavintajempaqueate avisati.’ Aisa pincantajiaquena: ‘Maasanopae noquemacojiaquero pantaguetaqueca Caperenaoniqui iintsijate pantagueteroquea aisa imaica acaniqui piguinteniqui.’ ");
INSERT INTO cotNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Icantsitanajaquea aisa icanquequea: —Arimajaquea noncantamajajiaquempiquea iriraquea tsavetantiroca icanquerica Aapani Irioshi aatoquea ishineventajitari iguinteniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Piquemacojiaqueroqueate paesatoniqui choocatirajagueti Iriashini teequeate ontejimatajeji incani anaavaetanacaquea 3 ajagantsini aisa 6 taai. Itaseajianaquequea maasano Ishiraeriqui. Ochoocavetacaquea oshequiavaeveca metojacoropae Ishiraeriqui, ");
INSERT INTO cotNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","cotanquitsiquea itigarancaquerigueti Aapani Irioshi Iriashini teetarite irooquea intigarancaqueneriji, ariguentiquea itigarancaqueri Sarepetaqui irooshitacoqueroquea Shirone, iroimotanaqueroquea otsipaquea metojacoro teeca iro igonoromajaca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aisa coramani choocatirajaguetiquea tsavetantatsica Eriseoni ichoocajiavecaquea yoshequiavaeveca avejancarijia Ishiraeriqui, cotanquitsiquea teequeate impeaguetempaji aparo, iriguentiquea pejaatsi aparo Shiriaquitica pajitatsica Naamanini. ");
INSERT INTO cotNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Irooqueate iquemaquemaitavaquitiguiquea capiocajianquitsica icatsimamajajianaquequea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Icatintiijianacaquea yoguisotoitsitariquea yaajianaqueri tiijacoñajiquea oraniqui ocaratapojigueti ocapiocagueti tsovironaquipae. Yaajiavetanacariqueate ocogarajapojacagueti intanquirejitsitemparimequea, iroguentiquea ocapiocacagueti itsovironaquitepae otsempiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cotanquitsiquea iriatimpaquea iquenaguijianaqueriquea niganquiqui yomporoguijajiacagueti, yoapanajanti. ");
INSERT INTO cotNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iroompaquea yoanajiquea Jesoshi Caperenaoqui, iroguenti guinteninintsi choocatanquitsica Garireaqui. Arejetapojaguetiquea savincaguiteri imagorejantajitaca yoanaquequea shinagogaqui icapiocantapinijiacaca joriojia itsatacaantaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iquemajiaquerogueti itsatacaantaqueca mana yamenamenaitanaquequea intati, agavejavaequetari icanqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ariquea ichoocaque oraniqui shinagogaqui aparoquea ishaquiacaca ampatsini, icajemavaequequeate iririjencani: ");
INSERT INTO cotNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ariotaqueshiatsi, Jesoshi Nasarequitica! ¿Queroquea pincojiaquenani naatimpajia? ¿Irooquea picoraquetashique pinteroncajiaquena? Notsatavaquempiquea aviguenti Iriomajaca irashi Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Icantanaquequea Jesoshi: —¡Pisanticote! Pisotoanajeri. Irooquea iquemaquitiguiriquea ampatsini ariquea icotanaca yoguitejanaqueri ishaquiacaca, iquenapanajantiquea isotoapanajanti yovashiantanajiriquea, teequea queroca incotajeri. ");
INSERT INTO cotNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Maasanojia mana yoayoaitanaque intati, iquenquetsatavacaajianaca: —¿Quero ococani iquejequerogueti? ¡Icantaquitiguiri iquemisanqueriquea ampatsinipae, isotoapanajanti! ¡Caavijitari imajirontamajaca! ¡Caavijiquea yagavejamajati! ");
INSERT INTO cotNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iroompaquea maasanopae choocajiatsica oraniqui iquemacojiaqueriqueate Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ariqueate isotoanajiqueate Jesoshi shinagogaqui icapiocajiacagueti, yoanaquequea itsovironaquitequi Shimo. Oraqueate ivaguirote Shimo ashinoncajavaecaquea ocatsirincavaeque. Icamantajitavaqueriquea Jesoshi irogueshitajero. ");
INSERT INTO cotNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yoanaquequea iroatimpaqui icanaanacaquea iquenquetsatacaaqueroquea joquijirentsi yoguisotoajiroquea. Iroatimpaquea ariquea ocotanaja osavogatanaji. Ariquea ocatianaja ojocacojiajiniri irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oraquea itsaparoncaguitetanajigueti icoraquecoraqueitaquequea maasano ashinoncajacojiatsica ocantashitatiajencaguecaquea ashinoncajagantsipae, yaajianaqueneriquea Jesoshi irogueshiguetajeri. Ipamijiavaqueriquea, ipeaguetanajaquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iconoagarancaquea mana ishaquiajiacari ampatsini. Yoguisotojaijainirigueti yoguisotosotoitajiri icajemavaetanaquequea icanqueri: —Aviguenti Irijanite Irioshi. Cotanquitsiquea Jesoshi icantimentajiaqueriquea inquenquetsajiaje, irioriji itsajiaque iriguenti Quirishito Meshiantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Osavincaguitetanajigueti yoanaquequea Jesoshi oraniqui teegueti inchoocateji caquinte, cotanquitsiquea icoajiaqueriquea caquintejia ariquea yarejetacovaejiacari ichoocaquegueti. Inintajiavetacaquea iraajiavaquerime aatonijite yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Cotanquitsiquea iriatimpa icantajiguiriquea: —Noanaquetarite noncamantajiaqueriquea aisa choocajianquitsica otsipapaequi guinteninintsi, nontsavetantaquero Quenquetsatsarentsi Oganejencatatsica nontsatacajaiaqueri quero icotani imajirontagueti Aapani Irioshi, irootaquequea itigaranquimenquenaquea Aapani. ");
INSERT INTO cotNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iroompaquea yoanaquequea Joreaqui itsavetantanaqueroquea shinagogapaequi icapiocapinijiagueti joriojia. ");
INSERT INTO cotNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ariqueate yoanaquequea Jesoshi otsapijaqui iniromotija pajitatsica Jenesare. Itirorencaventajianacariquea caquintejia, itsinacajianaqueri Jesoshi. Inintajiaquequeate inquemisantajiaqueriquea itsavetantaquerogueti Iguenquetsatsare Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ariquea yameniroquea Jesoshi mavite quenajarontsi ogataaguetaca. Igataajiaqueroqueate ashincaroca, yaguijijianaquequea yajacajiajiroqueate imantsatsite. ");
INSERT INTO cotNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iroompaquea itetanajaquea Jesoshi iguenajaroqui Shimo icanqueriquea iraimatanajerota niganquijacoñaji. Isavicaquequea itsatacaajiaqueriquea irirajia omporoguijajianquitsica otsapijaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ariquea iteroncanaquerogueti iquenquetsataquegueti icanqueriquea Shimo: —Jaameja ontaniqui osaanajataquegueti panquitacotantajiguempari shima pimantsatsite. ");
INSERT INTO cotNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Icanquequea Shimo: —Tsatacaantantatsica, nanquitacoveguitarini incajaranqui pitsecariqui nocantacoveguitaniquea aapojaja osavincaguitetanaji, teequeate naimajigueji. Cotanquitsiquea imaicaquea aviguenti cantanquitsi, intsishiatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Irooquea yojocajajiaqueroquea inoshicajatsijiavetaroquea taaja itseraiquivaecaroqueate shimapae icanca, niganquiqueate otsatitsatiavetanaca imantsatsite. ");
INSERT INTO cotNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ariquea yacocovaetanaquequea vacoc vacoc icajemaguitetsijigariquea mavinaquitanquitsica quenajarontsi iramitacojiaquerinijite. Yoayoaitanaquequea yamitacojiaqueriquea yaajiaquequea itseraiquivaequeri mavinaquite quenajarontsiqui, tsitijaatacovaeca. ");
INSERT INTO cotNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Iriraquea Shimo Peerero yamenaquerigueti caaviji yagavejamajati Jesoshi, igueroventsitariquea icanqueri: —Nomajirote, cameetsa poanaje, aato pitsipatanatsi, naroguentiquea covaeguishetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Itsaroanaquequeate iriatimpa irisatijiaquea itsipatsipaicaca yamenajiaquequeate yaajiaquequea icarapiovaetaquequea shimapae. ");
INSERT INTO cotNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iriguentiquea itsipatsipaitacaquea irijanitepae Severeo ipajitaquea Santiago, iriraquea itsipa ipajitaquea Joanca. Itsaroajianaquequea iriatimpajia aisa, cotanquitsiquea Jesoshi icanqueriquea Shimo: —Aatoquea pitsaroguitsi. Imaicaquea irioquea pimpitsocashijianaquempa caquintejia, pinquejetacaajiajempari shima panquitacojiguirigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iroompaquea itsinampijaatacojianajaquea igataapanajantiro iguenajaropae, itariapanajantiroquea maasanopae, yoayoaitanaji yoguijaguijaitanaqueriquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ariquea ichoocaquegueti Jesoshi ocapiocacagueti tsovironaquipae, icoraquepojiquea avejancari. Yamenapojaquerigueti Jesoshi iguerovempojacari yarejevaetaquita ivancaqui isavi, icanqueriquea: —Nomajirote, arigueti pininque, pagavejaque piveajena navejancavejancaacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iriraquea Jesoshi icantajempequitanaca ipamitsitari, icanqueri: —Jeeje, noninque. ¡Pimpeanajempaja! Irooqueate icanquitiguiri jac peanaja yavejancavejancaacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ariquea icantavajiriquea Jesoshi: —Aatoquea picamantitsi. Iriguentiquea poimotanaque saserorote ponigaapojempariquea, paanajenerija viratsipae, pinetsanaqueroja icantaqueca Moishishini cameetsanijite iramenamajaquempinijite, ariquea incanquempi peanajimpi, intsajiaquempinijite maasano peamajatajimpi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Cotanquitsiquea arimpaqueate iquemacomajajianaqueriquea Jesoshi, itirorencashijianacariquea oshequini inquemisantajiaqueri intsavetantaquegueti, aisa impeaguetajeriquea irashinoncajanejia. ");
INSERT INTO cotNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Cotanquitsiquea Jesoshi yoapiniti osamani teegueti inchoocatimateji caquinte iramananaqueriquea Iriri. ");
INSERT INTO cotNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iroompaquea itsatacaantaqueguetiquea Jesoshi, ariquea ichoocajiaquequea oraniqui isavisaviique pariseojia irisatijiaquea tsatacaantajiguiroca itioncacotanaqueca Moishishini quenajiapojatsicaquea Jerosarequi aisa guinteninintsipaequi Garireaqui aisa Joreaqui. Iriraquea Jesoshi yogueshijiaqueriquea ashinoncajajiatsica, iriguentiquea agavejacaaqueriquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ariqueate icoraquecoraqueipoji itsipapae caquinte yamacojiapojaqueriquea teeca ironquempaji iraajianaqueneriqueate intsompogui ichoocaquegueti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cotanquitsiquea querocampa inquenacaajiaqueri inquijacaantajianaquemparicate, omporoguijajiacaquea tirorererere caquintejia. Yataitaiitanaquequea jenoqui sotsiqui ocantamencotacagueti itsopajaguequero ogotapae ivichajajiguequeca quepatsi, ishimatarejitaro, yoguisoroncacojiaqueriquea teeca ironquempaji itampaticatacotaquegueti ichoocataquegueti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iriraquea Jesoshi itsajiavaqueri yaventajiapojacari irogueshitajeriniji, icanqueriquea teeca ironquempaji: —Shirampari, jac shetacotajimpi maasano pipeacaaguishevecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iriraquea tsatacaantajiguiroca itioncacotanaqueca Moishishini, irirajia pariseojia iquenquejajianaque intati: “¿Taate ipaji irira quejemanatacarica Aapani Irioshi? ¿Ooqueate choocampaca itsipa agavejanquitsineca irishetaqueroqueate covaeguisherentsi? Aparoqueate yagavejaque Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Cotanquitsiquea Jesoshi itsajiavaqueriquea iquenquejajiaqueca icantsijigariquea: —¿Queroquea picopicoitanacani piquenquejajianaquequea piquejejiaqueroquea imaica? ");
INSERT INTO cotNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Querocampate caavijica anaaque mananquitsica? ¿Iroocajate noncantaquerigueti teeca ironquempaji: ‘Jac shetacotajimpi maasano pipeacaaguishevecaca’, iroocajate noncantaquitigueri: ‘Pincatianaje panijitanaje?’ ");
INSERT INTO cotNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Imaicaquea namenacaajiaquempiroquea yagavejaquequea acaniqui quepatsiqui irira Irijanite Caquinte irishetacoitajeri ipeacaaguishevecaca caquinte. Irooquea icantanaquitigui ipitsocashitari teeca ironquempaji icanqueriquea: —Iintsija noncanquempiquea pincatianaje, paanajero pinorijancaca, poanaje pitsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Irooquea icantaquitiguiriquea icampanajantaquea icatiapanajanta, yaanajiroqueate inorijancaca yoanaji itsovironaquitequi, ishineventamajatanacariquea Aapani Irioshi, icanquequea: “Ariotesaa, Aapani, poganejencamajata.” Maasanojia yamenajiavajiriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yamenamenaitanaquequeate intati ishineventamajajianacariquea Aapani Irioshi iriatimpajia aisa, itsaroamajajianaquequea icantajigui: —Imaica ocatica savincaguiteri amenantajiacaroca oganejencatatsica teeca iramenajiteroji. ");
INSERT INTO cotNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ariqueate isotoanajiquea Jesoshi icantanaja ontaniqui yamenapojaqueriquea aparo capiocapinitinirica majirontatsica imentaquipae. Ipajitaquea Irevi. Isavicaquequea ipashicatsarajitirogueti yoguijajiavaqueri avisavisaitatsica ivegaratacaajiavaqueriqueate imentaquitsite maasano aajiananquitsica irajaararopae aisa taaca opajitapae. Ariquea icanqueriquea: —Jameja, poguijatanaquena. ");
INSERT INTO cotNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ariquea yovashiantaguetanaqueroquea Irevi maasanopae, icatiitsitanaca, yoguijatanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Iroompaquea itiacaanquequeate Irevi taaca opajitapae, icajemaqueriqueate Jesoshi irishecaquempa itsovironaquitequi. Icajemacaantaguequeri itsipapae oshequini capiocapinijiguinirica majirontatsica imentaquipae, itsipapae caquinte, irishinevenquempari Jesoshi. Itsipatsipaicaca ishecajiaca. ");
INSERT INTO cotNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Cotanquitsiquea iriraquea pariseojia itsipatsipaicari tsatacaantajiguiroca itioncacotanaqueca Moishishini, icantajiaqueri itsatacaane Jesoshi: —¿Querocaquea picojiacaniquea pishecajiacagueti pitsipatsipaitantacarica capiocapinijiguinirica majirontatsica imentaquipae aisa itsipajia covaeguishetatsica? ");
INSERT INTO cotNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Icantanaquequea Jesoshi: —Iriraquea teeca irashinoncajempaji teetarite incoguitejacotempariji aavintantatsica. Iriguenti coguitejacojigari ashinoncajajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ariqueate noquejetacaquea naatimpa teequea irioquea noncoraquetashiteji teeca incovaeguishejiguempaji noncajemajiaqueri incantashitatijaianajempaja, iriguenti nocoraquetashijiaque covaeguishejiatsica noncajemajiaqueriquea cameetsanijite incantashitatijaianajempanijite irovashiantanajeronijite ipeacaaguishevecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iroompaquea icantajitaqueri Jesoshi: —Iriraquea itsatacaanejia Joanca aisa irashijia pariseojia yoguipaquijapinijiaqueroquea isheca teetaquea irishecatsitajempaquea cameetsanijite incantacoguitempaniquea iramanajiaqueriquea Aapani Irioshi. Cotanquitsiquea pashijia pitsatacaguica ¿querocaquea icojiacani teequea inquejejiguempariji iriatimpajia, manaqueate icantacoguitaniquea ishecaguitani, imiraguitani? ");
INSERT INTO cotNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iroompaquea iquempetacaanca Jesoshi icanque: —Pinquenquejeja inchoocateguetiquea iriaqueraca manquigatanquitsineca incajemajiaqueriquea itsipavijijiaca irishecajiaquempa, ¿arimpaqueate aatompate ishecajiga? Irishecajiaquempaquea, itsipajiacaritarite cajemajiaquerica, shinejiacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Cotanquitsiquea oraqueate aapojempagueti incatsimatantajitaquemparica irajaitanaqueri osamani, ariquea iroguenti iroguipaquijantajiaquemparoca isheca, irishimampojancacojianaquempari. ");
INSERT INTO cotNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ariqueate Jesoshi iquejetacaajiacanariquea aisa icanque: —Aato agaveji atotashitaro iroaqueraro quitsaarentsi capichaji ampatacanquemparo iroquetishitequinica quitsaarentsi. Anquejevetaquempagueti imaica antovetaquemparogueti iroaqueraro, ompomatsaquempaquea. Oratica aavetacaca capichaji ompatacamataquivetaquempa, aato ocameetsamajati, aatotari oquejetaro. ");
INSERT INTO cotNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aisa aritarite onquejetaquempaquea iroguijaatantajitaquemparogueti vinoja iroaquerajatica oncachotapoje iroguijaatantajivetaquemparogueti imeshinanaquiqui iriquetinica. Oroameshinatanaquetari, oncachojamajavetanaquempagueti oshimoajavetanaquempaquea, ariquea oncotanaquempa aravoavetaquitempa imeshina, ariquea intyaquisanaque oshacojaatanaquempaquea vinoja, aisa impomatsataquempaquea imeshina. ");
INSERT INTO cotNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jeroquea caavijiquea ocameetsataque: oraquea vinoja iroaquerajatica iroguentiquea iroguijaatantajiquemparo iriaquerameshinari cameetsanijite aatonijite opomatsajata vinoja, aisa aatonijite ipomatsata imeshina. ");
INSERT INTO cotNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aisa quericacaquea miraroca vinoja iroquetijaca teequea irinintajeroji iroaquerajaca, manaqueate icanquequea: ‘Oraticaquea iroquetica irooquea cameetsajamajatanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iroompaquea aapojajagueti savincaguiteri imagorejantajitaca yoanaquequea Jesoshi icantanaca tirigomashiqui, itsipatsipaitanacari itsatacaanejia. Irooquea icantajianacaguetiquea oraniqui ishireguipanajanti tirigoitsoqui isagorejajiaqueroquea ishecajiacaro. ");
INSERT INTO cotNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iroompaqueate yamenajiaquegueti pariseojia icantsijigariquea: —¿Quero ocotacani paajianaquequea tirigoitsoqui? Imaicatarite iroguentiquea savincaguiteri imagorejantajitaca icantimentantajitirotarite irantantajitemparo. ");
INSERT INTO cotNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Icantanaquequea Jesoshi: —¿Arimpate teequea pampatsajavantacotimajigueroji aviatimpajia itioncacojitaquerigueti Taavini coramani ocanquegueti itaseanaque iriatimpa aisa itsipajianacaca, teequeate onchoocatimajaniquiteji taampaquea irishecajiaquempaca? ");
INSERT INTO cotNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iquijitsitanacaqueate itsovironaquitequi Aapani Irioshi ishecatacaroquea pan icantimentantajitica irishecajitemparogueti, manaquea yojoquijitaquero oraniqui shitaponcarontsiqui cameetsanijite iramenaqueronijite Aapani Irioshi. Iriguentiquea shecataroquea saserorotejia, iriotaquequea cantaqueroqueate Aapani Irioshi. Cotanquitsiquea iriraquea Taavini ishecatacaroquea, aisa yojocajiaqueneriquea itsipatsipaitacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Icanquequea aisa: —Iriraquea Irijanite Caquinte iriguentiquea cantatsica queroca icantimentantajitica irantantajitemparogueti savincaguiteri imagorejantajitaca, aisa querocaquea teeca incantimentantajiteroji. ");
INSERT INTO cotNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Iroompaquea aapojajaqueate otsipaquea savincaguiteri imagorejantajitaca yoanaquequea Jesoshi shinagogaqui icapiocantajiacaca joriojia itsatacaantaquequea. Ariquea ichoocaque oraniqui chompevacotantacaroca itincamijempequiqui, teequea iragavejempajiquea impacorejempaji. ");
INSERT INTO cotNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iriraquea tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa pariseojia yamenamajataqueriqueate Jesoshi iramenajiaqueriquea arica impeajeriqueate savincaguiteriqui imagorejantajitaca intsavetantimenquerinijite incantajigue ipeacaaca teeca oncameetsateji ipeajiriquea chompevacori savincaguiteriqui imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Cotanquitsiquea Jesoshi itsataquequea iquenquejajiaqueca. Icantsitariquea chompevacovetanquitsica: —Iintsijate pincatigue iramenajiaquempinijite maasano. Icatiitsitanacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ariquea icantajiguiri Jesoshi: —Iintsija noncoacojiguempi. ¿Querocaquea icanque Moishishini coramani? ¿Taaca irantantajitempaca savincaguiteriqui imagorejantajitaca? ¿Ariquea icanque impeacaantajitemparo cameetsa, irooca irantantajitaquemparoquea covaeguisherentsi? ¿Ari icanque aavajeri agonoro aatoniji imetoji, irooca icanque ametojaqueri? ");
INSERT INTO cotNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ariqueate yamenaqueriquea maasano capiocaventajiacarica icanqueriquea chompevacovetanquitsica: —Pincantavacotempaja. Irooquea icantavacovetanaquitiga ariquea icotanaja iraco jac peamajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cotanquitsiquea iriatimpajia icatsimamajajianaquequea icanca, iquenquetsatavacaajianacaquea querocaca incojiaquerini Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Otsipa savincaguiteri yoanaquequea Jesoshi otsempiqui iramaneriquea Aapani Irioshi. Yamanaqueriquea icantacoguitani osavincaguitetanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Osavincaguitetanajigueti icajemajiaqueriquea itsatacaanejia iriatimpaqui. Ariquea icoraquejiaquegueti icoguiaque 12, ipeacaajiacari itigarancane. ");
INSERT INTO cotNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Maasano yaajiaqueca ariqueate ipajijiacaquea: Shimo (ipajitajica Peerero), Antirishi (iriguentijeguite Shimo), Santiago, Joanca, Jeripe, Varitorome, ");
INSERT INTO cotNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomashi, Santiago (irijanite Arejeo), Shimo (icantajitica “Serote”), ");
INSERT INTO cotNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jorashi (irijanite Santiago) aisa Jorashi Ishicariote (aacaanquerineca Jesoshi oncoramanitanajegueti). ");
INSERT INTO cotNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ariquea yoguirincajaquea Jesoshi itsipatsipaitajariquea itsatacaanejia isavisaviipojaji opiguitejacagueti. Yomporoguijaventajianacariquea itsipapae itsatacaanejia yoshequiavaequequea aisa itsipapae quenaquenaitapojatsica osamani Joreaqui aisa Jerosarequi aisa quenajiapojatsica otsapijaguetapojacaguetiquea Tiroqui aisa Shirone. Iroguentiquea icoraquetashijiaquequea inquemisantajiaqueriquea Jesoshi intsavetantaquegueti aisa cameetsaniji irogueshitimentajeriniji yojoquijiguetacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iriraquea ishaquiaguetacaca ampatsinipae yoguisotoaguetajiniriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Maasanopae inintajiaquequea inchagajiaqueriquea, yamenajiaqueriquea yagavejamajati, yogueshiguetajiriqueate maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iroompaquea yamenajiguiriquea Jesoshi itsatacaane icantajiguiriquea: “Caavijiquea pishinevaejiaquempa aviatimpajia coguitejacojianquitsica, pimajirontajiacaritarite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Caavijiquea pishinevaejiaquempa aviatimpajia taseajianquitsica imaica, pinquemajiaquempatari. Caavijiquea pishinevaejiaquempa aviatimpajia iraajianquitsica imaica, iroguishinejajiaquempitari Aapani Irioshi pishirontajiaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Caavijiquea pishinejianaquempaquea aviatimpajia irisemajitempigueti iramenajiaquempigueti pitsaroventajiacari irira Irijanite Caquinte. Aricaquea aatoquea inintajigui pinconoajiaquempari manaqueate incantaguishejianaquempi aisa incantacojiaquempi: ‘Iriguenti covaeguishemajatanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Iriraquea choviquijianaquerica ariquea iquejejiaqueriquea tsavetantajiguinirica Aapani Irioshi coramanipaequitica icatsimajiaqueriquea. Ariquea aviatimpajia pamenajiaquegueti inquejejiaquempigueti imaica pishinejianaquempaquea, pishinemajajianaquempa, pitsajiaquequea caaviji iroguishinejamajaquempiquea Aapani Irioshi oncoramanitapojajegueti ontaniqui inquitequi, ipeacaajiaquempirotari irojocajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Cotanquitsiquea imaicashiatsi pantsipevaejiguempa aviatimpajia ajaarantajiatsica! Aatotarite querica guishinejajimpitsi oncoramanitapojajegueti, iroorijite pishinetsicaquea imaica, pishineventavecaroquea pashintaguecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Imaicashiatsi pantsipevaejiguempa aviatimpajia quemajianquitsica imaica, pintaseajigue! Imaica pijique: ‘Teetarite taaca noncoguitejacojiguempaji.’ Oncoramanitapojajegueti pinquenquejajiavetanaquemparoquea pinintajianaquequea incavintsajajiaquempiqueate Aapani Irioshi, cotanquitsiquea aatoquea ichoocatimati amijiajempineca. ¡Imaicashiatsi pantsipevaejiguempa aviatimpajia shirontajiatsica imaica, pishinevencaroqueate maasanopae quepatsipaequitica! Oncoramanitapojajegueti pishimampojancajiaquempaquea pirajaiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Imaicashiatsi pantsipevaejiguempa aviatimpajia irishineventajiaquempigueti maasano! Ariqueate iquejejiacariquea paesatinijianacarica ishineventajiacari tsavetantajiatsica amataajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Imaicaquea aviatimpajia quemisantajiaquenaca noncantajiaquempiquea aisa. Pimpintsajiaquempariquea catsimajiaquempica aisa pincavintsajajiaqueriquea semaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Irirajia cantavetaquempica: ‘¡Shoo poanaque camorecariqui!’, manaquea pinquenquetsatacaaqueriquea cameetsa, pincanqueri: ‘Noninque pinchoocajiaque cameetsa.’ Pamanacoventajiaqueriquea quenquetsaguishetacovequempica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Inchoocaquegueti capojaquempineca pivoroqui pimpitsoquempaqueate acaquerocatica otsipavoro inquejetacaitemparoquea iroatimpa. Inchoocaquegueti aapitsataquempironeca piitsaare, irinintsitaquempirogueti otsipa intsompoguitica piitsaare, pojoquitenempari. ");
INSERT INTO cotNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Inchoocaquegueti amanaquempironeca taaca opajitapae, pojocaqueneriqueate. Inchoocaquegueti aapitsaquempironeca pashincaca, aatoquea picantajiri: ‘Pojocajenaroja.’ ");
INSERT INTO cotNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pincavintsajajiguerija itsipajia, pinquejetacaguemparo pininquegueti incavintsajaquempi aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Managueti irioca pimpintsajiguempa pintsajiguimpica aviatimpajia, ¿arimpa irooquea irishinevenquempi Aapani Irioshi? Ariqueate icojiga aisa coguishejiatsica, itsajiguirotari impintsataquempari pintsatarica iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Managueti irioca pincavintsajajigue cavintsajajiaquempica aviatimpajia, ¿arimpa irooquea irishinevenquempi Aapani Irioshi? Ariquea icojiga aisa coguishejiatsica, itsajiguirotari incavintsajaqueri cavintsajirica iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aisa arigueti pojocaqueneri pigonoro yamanaquempica iramanaquempigueti iroguipijaempica coajica, cameetsavaeque. Cotanquitsiquea managueti irioca pojoquene quejetacaajiajempineca ¿arimpa irooquea irishinevenquempi Aapani Irioshi? Ariqueate icojiga aisa coguishejiatsica, yojocajiguiniri igonoro cameetsaniji inquejetacaajempari iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Cotanquitsiquea aviatimpajia noncantajiaquempiquea pimpintsajiaquempariquea catsimajiaquempica, pincavintsajantaquequea, aisa pojocaquenerigueti cantaquempica iroguipiajempiro, aatoquea poguijacojiaja inquejetacaajempi. Pinquejejiaquempagueti imaica, incavintsajamajajianaquempiquea Aapani Irioshi Anaantamajatatsica aisa pinquejejiaquempariquea iriatimpa, icavintsajajiaqueritari teeca inquenquejacojigueriji aisa covaeguishetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pimpintsatacotantajiguempaquea, pinquejejiaquempariquea Piri Irioshimajaca ipintsatacotantamajatagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Pamenitaquerigueti yantaguishetaqueca itsipa aato piquenquejitsi: ‘Teequea incameetsateji, icovaeguishetaca’, ariquea aato iquejetacaajitimpi aviatimpa. Aatoquea pinintitsi incatsimatimenteri Aapani Irioshi covaeguishetanquitsica, ariquea aato iquejetacaajitimpi aviatimpa. Pimpeacotsitajempari itsipajia, ariquea inquejetacaajitaquempi aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pincavintsajantamajajigue, ariquea inquejetacaajitaquempiquea aviatimpa. Incavintsajamajajiquempiquea, onquejetaquempa incavintsajamajaquempigueti intseraiquimajataquempiro pishimatotequi irivinacamajatavaquero irantecacotavaquero irosati osocaguitanaquempa. Quericaca caavijica iranaaque incavintsajantamajataque, caavijiqueate incavintsajajiqueriquea iriatimpa, cotanquitsiquea iriraquea arica igoca icavintsajanquequea, ariqueate inquejetacaajitaquempari iriatimpa ariquea igotaquempa incavintsajajiqueriquea.” ");
INSERT INTO cotNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ariqueate iquenquetsatanajiquea Jesoshi iquenquetsatacotaqueriquea tsatacaantantatsica, icanquequea: “¿Arimpaqueate iragavejaque shamponcajari iraanaqueri itsipa shamponcajari ironigaantaque? ¿Aatompaquea itanquiretanquireitanaque mavite ocogarajapojacagueti? ");
INSERT INTO cotNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iriraquea itsatacaajitica, teequea iranagueriji tsatacaguirica, cotanquitsiquea arigueti intsitacacaaguetaqueri intsatacaaquerigueti irooquea inquejetantanaquemparica iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Querocaquea picocani pamenantacarica itijaarojaniqui pigonoro cotanquitsi tee pinquenquejacoteroji inchapoa poquijaqui pashi aviatimpa? ");
INSERT INTO cotNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aatogueti pameniro inchapoa poquijaqui pashi aviatimpa, ¿arimpate pagavejaquempa pincanqueri pigonoro: ‘Iintsija, iguentijegui, nonquitsoajempiro pitijaaro’? Cameetsatamampeatsica, iroquetitarite pijivatavaque pinquitsoavajerota inchapoa poquijaqui pashi aviatimpa, ariquea pamenamajatanaje pinquitsoimentajenerinijite tijaataquerica pigonoro. ");
INSERT INTO cotNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Maasano inchatopae choocatatsica osovena ishecajitaca aatoquea agavejitsi onchoocaque osovena teeca irishecajitemparoji. Ari oquejetaca inchatopae choocatatsica osovena teeca irishecajitemparoji, aatoquea agavejitsi onchoocaque osovena ishecajiguetaca. ");
INSERT INTO cotNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Maasanopae inchato iroguenti itsatantajitaroca osovena. Iguerasovena teequea onchoocatantemparoji samerento. Aisa ovaitsoqui teequea onchoocatantemparoji poronqueto. ");
INSERT INTO cotNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ariquea iquempetaca caquinte comajamajatatsica iroguenti iquenquetsatacoguetaque cameetsaripae, irootari iquenquejacoguetaque. Iriraquea teeca incomajamajatempaji iroguenti iquenquetsaguishetaque taaca opajitapae, irootarite iquenquejacoguetaque iriatimpa. Maasanopaetari iquenquejacojiguetica irootaquequea iquenquetsatacojiguetica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Querocaquea picojiacani picantajiaquenaqueate intati: ‘Nomajirote, Nomajirote’, cotanquitsiquea teetarite pinetsanajiavaqueroji nocantajiavequempica? ");
INSERT INTO cotNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Imaicaquea noncantajiaquempiquea queri iquejetaca iriraquea quericaca coraquetashiquenaca iquemisantaquenaquea ariquea inetsanamajaquero nocantaquerica. ");
INSERT INTO cotNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Manaqueate iquejetacariquea caquinte vinchajiroca itsovironaquite. Iqueequitaroquea yoavaequeroquea jmm isavi imontsitajacotantacaro shiratantapi. Ariquea ivinchajavaquero. Iroompaquea amaravepojacaquea oja anaacotanaqueroqueate itsovironaquite otampishijavaetanaquequea ocanca, cotanquitsiquea teequea agueroji, ocatiavaecaqueate isaviqui imontsitajacotantacarotari mapi oquishomajatantacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iriraquea quemavetavacaroca nocanqueca cotanquitsiquea teequea irinetsanateroji manaqueate iquejetanacari itsipa ipeacaacaqueate itsovironaquite teequea iroguijaamajateroji isavi, querocampaquea onquishotanquempaca. Iroompaquea amaranaquegueti oja anaacotanaquero itsovironaquite, otampishijatanaque osoveanaquero, jac aapanajantiro, oteroncamajatanaquero oanaquero.” ");
INSERT INTO cotNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iteroncanaqueroguetiquea Jesoshi itsatacaajiaquerigueti yoanajiquea Caperenaoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ariquea ichoocati oraniqui coareta Iromaquitica. Iriatimpa iriguentiquea imajironcaca 100 igoaretajiate. Yojoquijivaecaquea yashincaca caavijica ipintsamajatacaca, iroovepojaca irimetojeme. ");
INSERT INTO cotNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Irootaquequea iquemacotantaquerigueti Jesoshi itigarancaqueriquea iramajirorejia joriojia incamanquiteri incoraquequeniji irogueshitajeri yashincaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Iroompaquea yoayoaitanaquequea icantajiapojaqueriquea Jesoshi: —Nonintamajajiaque poanaque pogueshitajateneri yashincaca imajirojiate coaretajia, caavijitari icameetsati ashintantanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ipintsamajajiacajitari aatimpajia joriojia, yantacaantaquenaro shinagoga nocapiocantapinijiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ariquea yoanaquequea Jesoshi yoguijaguijaitanaqueriquea. Yaajiavetanacaro quempeji tsovironaquiqui itonquivojajiavacari itsipavijijiacaca imajirojiate coaretajia. Iriatimpa iroguentiquea itigarancajiaqueri intonquivojajiavaquempari incantajiavaqueri: —Itigarancajiaquena notsipavijitaca icanquempi: ‘Nomajirote, aatoquea patsipeventanaqueate pincoraquetashivaequena notsovironaquitequi. Aatotarite piquijitsitanarotsi notsovironaquite, notsaquetarite panaamajataquenaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Irootaquequea nopashiventantacaca naatimpa inchiquioji noanaque nonquenquetsatacaajiaquitempi. Pincantajaniquiqueja impeapanajantempaquea nashincaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quejetaca naatimpa ichoocaveca tigarancanaca, ariqueate ichoocaque nashi nogoaretajiate notigarancajiguica. Quericaca noninqueca nontigarancaqueca inquemisantaquenaquea iroanaque. Itsipaquea nocajemirigueti icoraquetaque. Aisa ichoocaque nashincaca taaca opaji nomperacarica iquemisanquenaquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Irooquea iquemavaquerigueti Jesoshi icanqueca yamenanaque intati. Ipitsocashijianacariquea maasano oguijaguijaiquerica icantajiguiriquea: —Noncanquempiquea, choocavetaca oshequini quemisantajiaquenaca acaniqui Ishiraeriqui, cotanquitsiquea teequea namenimagueteji aparo inquejetempariji irica itsamajatigueti nagavejamajati. ");
INSERT INTO cotNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ariquea irirajia itigarancajiaqueca imajirojiate coaretajia icoraquecoraqueivetajaquea tsovironaquiqui yamenavepojajariquea jac peamajatanaja yashincaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iroompa yoanaque Jesoshi guinteninintsiqui icantajitica Naine, yoguijaguijaitanaqueriquea itsatacaanejia aisa oshequi caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ariquea yaavetapojacaroquea quempeji osotomoro otantotacojiacagueti tsovironaquipae, yamacojipojiri metojatsica inquitajiajateri. Iriguentiquea irijanite metojacoro, aparoqueate icocaniquea iriatimpa irijanincaca. Icantaventajianaqueroquea tirorererere caquinte oguijaguijaitanaqueroca irijanincarica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ipintsatacotanacaroquea Amajirote yamenaquerogueti iraaca, icanqueroquea: —Aato piraga. ");
INSERT INTO cotNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yoashitanaqueroquea yamancarica ipamitsitaro. Ariquea icatintiitapojacaquea natacojiaquerica. Ariquea icanqueriquea Jesoshi metojanquitsica iriaqueraca quenquevaritananquitsi: —Shirampari, noncanquempiquea pintinajanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ariquea isavicanaji metojavetanquitsica iquenquetsatanajiquea. Yojocajiniroquea iriniro. ");
INSERT INTO cotNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yamenaqueguetiquea maasano yogueshitajirigueti yoayoaitanaque intati, aisa ishineventajianacariquea Aapani Irioshi. Icantajiaquequea: —Icoraquetimojiacaji tsavetantatsica anaamajatantatsica. Iquenquejacojiacajiquea Aapani Irioshi, icavintsajajiacaji aatimpajia yashincaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iroompaquea maasanopae choocajiatsica Joreaqui aisa irooshitacoguetanquitsica iquemacojiaqueriquea Jesoshi itancorejajiri metojavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ariquea irirajia itsatacaanejia Joanca icamantajiaqueriquea yantaguetaqueca Jesoshi. Ariquea icajemaqueriquea mavite, ");
INSERT INTO cotNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","itigarancaqueri incoacojiaquiteri Jesoshi: “¿Aviguentica noguijajiavecaca? ¿Irooca noncantacoguitempani noguijajiaguiterini itsipa incoraquetaque?” ");
INSERT INTO cotNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ariqueate yoayoaitanaquequea yarejerejeipojaca ichoocaquegueti Jesoshi icantajiapojaqueriquea: —Itigarancajiaquenaquea Joanca Viñacajatantatsica noncoacojiaquempiquea: ‘¿Aviguentica noguijajiavecaca? ¿Irooca noncantacoguitempani noguijajiaguiterini itsipa incoraquetaque?’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oraqueate yarejetapojacagueti yamenacojiapojaqueriquea yogueshiguetajiri oshequini ashinoncajaguetatsica iconoagarantajiaca aajiaqueri joquijirentsi anaaguetatsica. Iriraquea ishaquiaguetacaca ampatsinipae yoguisotoaguetajiniriquea. Aisa yamenacaajiajiri shamponcajavetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ariquea icantajiguiriquea Jesoshi: —Imaicaquea poapoaitanaje pincamantajiapojajerija Joanca maasanopae pamenaguetaqueca aisa piquemaguetaqueca. Iriraquea shamponcajajiavetatsica yamenamenaitanaji. Iriraquea teeca iranijijiavetempaji yanijijianaji. Ariquea iquejejiaca avejancaripae ipejaianaja. Iriraquea teeca inquemajiavetempaji iquemajianaji. Aisa iriraquea metojaguetatsica itancorejajianaji. Iriraquea coguitejacojianquitsica imaica itsavetantimojiqueriquea itsatacajaiqueri Quenquetsatsarentsi Oganejencatatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Caavijiquea irishinevaetaquempa quericaca incantacoguitempani intsaroventamajataquena aatoca yovashiantajana. ");
INSERT INTO cotNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ariquea yoayoaitanajigueti itigarancajiaqueca Joanca iquenquetsavaetaquequea Jesoshi iquenquetsatacoqueri Joanca, icantajiguiri maasano: “¿Taacaquea poapoaitashitaquiti ontaniqui oquitamampororoitapojigueti? ¿Arimpa irooquea poapoaitashitaquiti pamenajiaquitiro savorovana ojeonquirogueti choviga, ariquea oaquiti oaquiti? ");
INSERT INTO cotNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ariquea taaquea poashijiaquiti? ¿Iriocaja poashijiaquiti pamenajiaquitiri caquinte quitsaatatsica shipetamorenaro quitsaarentsi? Pitsajiaquequea maasano quitsaatatsica shipetamorenaro quitsaarentsi manaquea isavisaviiti itsovironaquitequi majirontatsica, icantacoguitaniquea isavicaventiro taaca opajitapae ishinevencaca iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iroosacanica ¿taaquea poashitaquitiquea? ¿Iriocaja poashijiaquiti pamenajiaquitiri tsavetantaquerica Aapani Irioshi? Jeejeguitatsi, iriotaque, cotanquitsiquea iriatimpa caaviji yanaaguequeri itsipajia tsavetantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iriotaque itioncacojiqueca coramani iquenquetsatacaaquerigueti Aapani Irioshi Irijanite, icanqueri: ‘Ari nontigarancaqueri iriquetica oananquitsineca intsavetacotempi. Irio camantajiaquerineca igonorojia queroca pinquenanaqueni irinetsanatashitantajiavaquempica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Imaica noncantajiaquempi: maasanopae caquintejia teetarite inchoocatimateji aparo anaaquerineca Joanca, cotanquitsiquea maasano majirontajiacarica Aapani Irioshi, irirajia teeca iranaajencavaevetempaji, caavijiquea icavintsajamajajiaqueri, oquejevetaca yanaajiaqueri Joanca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Maasano caquintejia quemajiavaquerica Joanca itsatacaantigueti icantajiaqueri iriviñacajajiaqueri, yamenajiaqueritarite icantamajati Aapani Irioshi icantaquegueti iriguentijia covaeguishejiatsica. Ariquea iquejejiacaquea irirajia capiocapinijiguinirica majirontatsica imentaquipae iviñacajatacaantajiacaquea iriatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Irirampani pariseojia itsipatacariquea tsatacaantajiguiroca itioncacotanaqueca Moishishini teequea irishineteriji iriviñacajajigueri Joanca. Inintavetacaquea Aapani Irioshi incavintsajajiaqueri, cotanquitsi iriatimpajia teequea irinintajigueji inquemisantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Quero icojigani caquintejia choocajianquitsica imaica? ¿Taa ipaji iquempejiaca? ");
INSERT INTO cotNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iriguentiquea iquempejiaca chaajaniquitirajaca irisavisaviitaquegueti tsoviaguiteriqui irantanavijitempagueti iroompa ari incatsimatavacaajianaquempa incantajiaquequea: ‘Nocovitimojiavequempiquea teequea pintsamarojianaque. Ariquea namashaitimojiavetaquempi amashairentsi yamashaijitica ishimampojancajitagueti teequea pirajaiguempaji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ariqueate piquempejiaca aviatimpajia. Icoraquevetaca Joanca Viñacajatantatsica teequea irishecatempaji ishecapinitaca igonorojia, aisa teequea irimirimatemparoji cachojaro, manaquea picantacojiaqueriquea: ‘Ishaquiacari ampatsini.’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ariquea imaica icoraquevetaca irira Irijanite Caquinte, ishecataca iriatimpa, imiraca, ariqueate picantajiaque: ‘Iriguenti shecajanti, iriguenti shinquitatsica, aisa iriguenti itsipavijijiapojaca covaeguishejiatsica aisa capiocapinijiguinirica majirontatsica imentaquipae.’ ");
INSERT INTO cotNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Cotanquitsi onconijavaetanaque itsatica tsamajatatsica amenajiaquegueti quero ococani yantaguetaqueca.” ");
INSERT INTO cotNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ichoocaque pariseo icajemaqueriquea Jesoshi irishecatacaaquempari itsovironaquitequi. Ariquea yoanaquequea Jesoshi iquijapoji ipimerequijapojaca shitaponcarontsiqui irishecajiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ochoocaque manquigarentsi quempevaetatsica, ariquea oguintenica quempeji. Ariquea oquemacoquerigueti Jesoshi yoanaque irishecatempa itsovironaquitequi pariseo, oanaque aanaquequeate casancajencajari yoguijaantajicaro chovintyoriqui ipeacaajitaca mapi icantajitica aravasetero. ");
INSERT INTO cotNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iroompaquea arejetapojaca ichoocaquegueti Jesoshi ocatiapojaca igontatapojacagueti, iraanaca oparijaatanaquequea ojaquija oshaguitsitariquea iguitiqui. Ariquea osheguititantajariquea omae, onintaguititanaqueriquea, aisa oshaguiguititantacari casancajencajari. ");
INSERT INTO cotNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ariquea yamenaquerogueti pariseo cajemaquerica Jesoshi itsovironaquitequi iquenquejanaque: “Arimajagueti iriogueti tsavetantatsica intsatsitavaquempa taaqueate pamipojiri, intsaque queroca ococani, intsatavaquequea iroguenti quempevaetatsica.” ");
INSERT INTO cotNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iroompaquea icantanaquequea Jesoshi icanqueri pariseo: —Shimo, chooca noncanquempica. Icanqueriquea: —Iintsijate, Tsatacaantantatsica, pincantenaja. ");
INSERT INTO cotNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Icanqueriquea Jesoshi: —Chooca mavite shirampari, yaacoqueri imentaquitsite jocavaquenerica, icanqueriquea: ‘Oncoajicatapojajegueti poguipiajatenaja.’ Aparoquea yaacoqueri 500 tenario. Iriraquea itsipa ariguenti yaacoqueri 50. ");
INSERT INTO cotNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cotanquitsiquea iriatimpajia ocoajicavepojaja aavetapojaja iroguipiantajenemparimeca teequea inchoocatajeji imentaquitsitejia querocampaquea irajaiajeri irivegaratantajemparica. Ariquea icantajiriquea: ‘Ompeashitanajempaquea intati.’ Imaicaquea iintsija pincanquena ¿queri pintsamajaquemparineca? ");
INSERT INTO cotNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Icanqueriquea Shimo: —Iriocajate ipeacomajacaca. Icanqueriquea Jesoshi: —Pitampaticamajataquero. ");
INSERT INTO cotNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ariqueate ipitsocavetanaca yamenanaquero manquigarentsi, icanqueriquea Shimo: —¿Ari pamenaquero ocatica manquigarentsi? Noquijavepojaca pitsovironaquitequi teetari pojocavaquena pijatsite najacaguititaquempame. Iroatimpa ajacaguititanquenaro ojaquija, osheguititantajanaroquea omae. ");
INSERT INTO cotNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aisa teequea pinintavorotenaji, cotanquitsiquea iroatimpa onintaguitiquenaquea incajaranqui arejevaeca imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Teetarite pimpantantenaroji orejiqui noguitoqui, cotanquitsiquea iroatimpaquea oshaguiguititaquenaquea casancajencajari. ");
INSERT INTO cotNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Irootaquequea imaica noncanquempi ocovaeguishevecaroqueate taaca opajitapae, cotanquitsiquea imaica shetajaqueate maasanopae, irooriji opintsamajataquena. Cotanquitsiquea iriraquea irishetsijitaqueca capichaji ipeacaaguishetacaca, capichajaniqui impintsatantavequempa. ");
INSERT INTO cotNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iroompaquea icantsitaroquea manquigarentsi: —Imaicaquea shetanajaquea picovaeguishevetacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ariquea irirajia icajemajiqueca itsipatsipaicaca ishecajiacagueti icantavacaajianacaquea: —¿Taashia ipajita iricatica shetsitantaqueroca covaeguisherentsi? ");
INSERT INTO cotNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Cotanquitsiquea Jesoshi icantsitaroquea aisa: —Imaicaquea meshiajimpi irooriji pavempojana. Poanaje pishinevaequempa. ");
INSERT INTO cotNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iroompaquea iquenaquenaguetanaquequea Jesoshi guinteninintsipaequi ichoocajiguigueti oshequini caquintejia aisa guinteninintsipaequi teegueti iroshequiamajateji, itsavetantaquero Quenquetsatsarentsi Oganejencatatsica icantajiaqueri quero icotani imajirontagueti Aapani Irioshi. Itsipatsipaitanacari itsatacaanejia carajianquitsica 12. ");
INSERT INTO cotNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aisa oguijaguijaitanaqueriquea manquigarentsijia yoguisotoacoventajiajica ishaquiajiavecarogueti ampatsini, aisa yogueshijiajica ashinoncajajiavecagueti. Ariquea ochoocaque Maria icantajitica Magararaquitica yoguisotoacovenqueca ishaquiavetacarogueti 7 ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Otsipatsipaicaro Sosana aisa Joana, imanquigare Cosa iramajirore Erorishi. Oahoaitanaquequea aisa otsipapae manquigarentsijia. Iroatimpajia amiqueriqueate Jesoshi ojocajiaqueneriquea omentaquitsite cameetsanijite irivegaratantaquempaca taaca icoguitejacocaca. ");
INSERT INTO cotNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ariqueate icoraquecoraqueitaque caquintejia icaramirincavaeque, iquenaquenaitapojaque guinteninintsipaequi yomporoguijaventajiapojacari Jesoshi. Iroompaquea iriatimpa iquejetacaacanari, icantajiguiri: ");
INSERT INTO cotNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yoanaque aparo caquinte impishoncaguitero oitsoqui. Ipishoncavoncaquitanaqueroquea tacororo tacororo, itsitacaguetanaquero. Oconoagarancaqueate asacaraaguiguetanaca quenavoquirontsiqui, ariquea yagatigatiiquero, iroompaquea isavisaviitashipojiroquea tsimeripae ishecajiapojacaro. ");
INSERT INTO cotNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Otsipa oconoagaranca asacaraanaca mapiporoquiqui, taampina otsoroavetanaca cotanquitsiquea oshimpeguiricanaque ometojanaji, pirijaguitevaetaquetarite quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oconoacaquea otsipapae asacaraanaca ochoocaquegueti ovarishitsa samerento. Otsoroavetanacaquea oquenanaquequea otsoroitsitanacaquea samerento iroatimpa otsincoanaqueroquea ometojanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Otsipapae oconoacaquea asacaraanaca ocameetsaguitequegueti quepatsi, otsoroanaquequea otaganaanaca ochoocatanaque opitsaraquiacotanacaqueate oitsoqui, oconoacaquea ochoocaque 100.” Irooquea iquejetaquerogueti Jesoshi imaica iquenquetsatanajiquea iririjenca icanquequea: “Choocagueti piguempita pinquemantavaquempaca, pinquemeja.” ");
INSERT INTO cotNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iroompaquea icoacojiavaqueri itsatacaanejia taa opajita oquejetaca itsavetanqueca incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iriatimpaquea icantajiguiri: “Imaicaquea ininque Aapani Irioshi pintsajiaquero aviatimpajia queroquea icotani imajirontagueti iriatimpa. Teetarite intsajiteroji paesatoniqui, aviguentiquea tsajiaquerone imaica. Oraqueate notsatacajaiaquerigueti itsipapae manaquea noquejetacaacaroquea maasanopae, manaquea iramenamenaivetanaquempaquea, cotanquitsiquea aato inejajiguitsi; inquemajiavequempaqueate, cotanquitsiquea aato itsajiavaquerotsi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Imaicaquea nontsatacaajiaquempiquea taaca opajitapae noquejetacaaca. Oraticaquea oitsoqui iroguentiquea noquejetacaacaro itsavetantajitirogueti Iguenquetsatsare Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oraticaquea asacaraaguitananquitsica quenavoquirontsiqui iriguentiquea noquejetacaaca caquinte quemajiavetavacaroca Iguenquetsatsare Aapani Irioshi, cotanquitsiquea iroompaquea icoraquetashiqueriquea ampatsini ipeacotacaacari maasanopae aatonijite iquemisantajirotsi imeshiajitiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Oraticaquea asacaraaguitananquitsica mapiporoquiqui iriguentiquea noquejetacaaca caquinte quemajiavetavacaroca Iguenquetsatsare Aapani Irioshi ishineventajiavetavacaroquea shine, cotanquitsiquea teequea intsamajateroji, tee inquenquejamajateroji, mana iquejetacaro panquirentsi teeca onquijamajateji ovaritsa. Iquemisantajiavetaquita cotanquitsiquea ocoraquetashiquerigueti atsipetagantsi ariquea icotanaca yovashiantanajiroquea itsaroventane. ");
INSERT INTO cotNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oraticaquea asacaraaguitananquitsica ochoocaquegueti samerento, iriguentiquea quejecaroca caquinte quemajiavetacaroca Iguenquetsatsare Aapani Irioshi. Cotanquitsiquea ariqueate iquenquejajiavajiroqueate taaca opajitapae ishoshoventajijaaro, ishinevencariquea imentaquitsite aisa taaca inintajigui iriatimpa. Irooquea anaanaquero Quenquetsatsarentsi iquemavetacaca, iquejetacaroquea panquirentsi caarica oitsoquitatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Cotanquitsiquea oraticaquea asacaraaguitananquitsica ocameetsaguitetaquegueti quepatsi, iriguentiquea quejecaroca caquinte tampaticatiroca netsanamajatiroca cameetsaguetatsica. Iriatimpajia iquemisantamajatavaqueroquea Iguenquetsatsare Aapani Irioshi, ipampiamajaqueroquea, iroompaquea arimpaqueate ipampiatsimajatanacaroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Oraquea itsivojitirigueti tsivorentsi teequea ari iriguivotacojiteriji chomoqui. Aisa teetarite ariquea iroguisavicacojiteriji isaviquea omencoqui imaantajitaca. Iroguentiquea yoguisavicacojitiriquea jenoquijaniqui cameetsanijite intsivoguitetanaquenerinijite maasano quijaquijaitanquitsica oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ariquea oquejetacaquea taaca opajitapae senacaguetatsica imaica, oncoramanitapojajegueti ironigaantajiquero. Aisa taaca opajitapae teeca intsajiteroji imaica, oncoramanitapojajegueti intsajitaqueroqueate, aatotarite osenaquimatajatsiqueate. ");
INSERT INTO cotNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Irootaquequea imaica pinquenquejamajateja quero pincoquempani pinquemisantamajatantaquempaca. Quericaca tsatavaqueroneca icantajiquerica intsatacaajitaqueriquea otsipapae. Quericaca teeca irininteji intsatavaquero, iraapitsatsijitavaqueriquea ijivetaca itsaque.” ");
INSERT INTO cotNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ariqueate ocoraquetaquequea iriniro Jesoshi aisa iriguentijeguitepae tsovironaquiqui ichoocaquegueti iriatimpa, cotanquitsiquea teequeate iragavejajigueji inquijaquijaiteji intsompogui, yojocajajiacatarite yoshequiavaequequea caquinte. ");
INSERT INTO cotNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ariquea icamantajiqueriquea Jesoshi icantajitiri: —Coraquetaque piniro aisa piguentijeguitepae. Chooca sotsiqui, inintajiaque iramenajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Cotanquitsiquea icanquequea: —Maasano quemisantajiavaqueroca Iguenquetsatsare Aapani Irioshi aisa netsanajiavaqueroca, iriotaque nopejaiaque iinanijia aisa iguentijeguijia. ");
INSERT INTO cotNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iroompaquea yoanaquequea Jesoshi iniromotijaqui itetanacaroquea quenajarontsi itsipatsipaitanacariquea itsatacaane icanqueriquea: —Jameja intatiqueroqui. Ariqueate yoayoaitanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iquenajatacojianaquegueti imaaquequea Jesoshi quenajarontsiqui. Iroompaquea ochovigaguitevaepojiquea inirojencatapojaque choviga jeoc jeoc jeoc jeoc, ariqueate ocotanaca ovorevoreatanaca otserajatanacaquea oja quenajarontsiqui iroovepojaca ontsitijaatanaqueme. ");
INSERT INTO cotNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ishiashijianacariquea Jesoshi itinaitari icantsijigari: —¡Tsatacaantantatsica! ¡Tsatacaantantatsica! ¡Ojocajajiguempani! Itinajitsitanacaquea Jesoshi iquenquetsatacaaquero choviga icanquero: —Pimpejaencatanajempaja. Icantsitaroquea aisa iniromotija vorevoreatananquitsica icanqueroquea: —Pinchopecajatanajempaja. Ari ocotanaja osanticojencatanaji choviga, ari oquempetanaja iniromotija ochopecajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iroompaquea icantsijigariquea itsatacaane: —¿Quero ocotaca caarica pitsatantajigana nagavejamajati? Cotanquitsiquea iriatimpajia itsaroamajajianaquequea yamenamenaitanaque intati icantavacaajianacaquea: —¿Taashia ipaji irica? Icantaquitiguiro choviga aisa iniromotija oquemisanqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iroompaquea yarejerejeitapojacaro iguepatsitequi Gararaquitica otampaticatacomajataquero quepatsi Garirea. ");
INSERT INTO cotNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Irooquea yaguijivetanacaquea Jesoshi yameniriquea icoraquepoji shirampari choocatatsica ocaniqui. Ishaquiajiacariquea ampatsini, yajagantsitacovaetanaquequea teequea inquitsaatajempaji, aisa teequea inchoocateji tsovironaquiqui ariguentiquea ichoocati imperitamoroqui yojoquijitantapinijitarica metojaripae. ");
INSERT INTO cotNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Querocaguetiquea savincaguiteri ishoncacoguitevaetanaqueri. Yaajitapinivecari yoishotantajivetacari cavorejatsariqui iracoqui aisa iguitiqui, yamenamajajiavecari, cotanquitsiquea teetarite iragavejajiteriji. Icaratsarejaguetaqueroquea ocanca, ishiashiatacaaguitarini ampatsini ontaniqui teeca inchoocateji caquinte. Ariquea yamenavaquerigueti Jesoshi iguerotashitapojacari icajemanaquequea: —¿Querocaquea pincoquenani, Jesoshi Irijanite Irioshimajaca Anaantamajatatsica? Iintsijate aatoqueate patsipetacaavaetana. ¡Pimpintsatacogajoitenashiatsi! Icantantacaroca ocatica irooriji icanqueri Jesoshi ampatsini irisotoanaje irovashiantanajeri. ");
INSERT INTO cotNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iroompaquea icanqueriquea Jesoshi: —¿Querocaquea pipajitani? Icanque iriatimpa: —Nopajita Caramirincatatsica. Icantantacarica: “Nopajita Caramirincatatsica”, irooriji yoshequiavaeque ampatsini shaquiajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iriatimpajia icantajiaqueriquea Jesoshi aatonijite itigarancajiguiritsi oagantavaetananquitsica jmm isaviji. ");
INSERT INTO cotNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cotanquitsiquea ontaniqui otapiqui choocaquea chancho icarapiovaeque, ishecajiaca. Iroompaquea irirajia ampatsini icantajianaqueriquea Jesoshi iroashijianaquerita chancho inchoocajiapojaqueriniji. Iriatimpaquea icantsijigariquea: —Intsiquetirote poapoaitanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Icampanajanta isotosotoitapanajanti ampatsini yovashiantajianaqueri ishaquiavetacaca, irioquea yoashijiavetanaca chancho. Iroompa ishaquiajiavetapojacari ariquea icohicoitanaca ishiajianaca ocogarajacagueti itanquireajianaque yojocajajiapojaca, icampojaca teron maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Irooquea yamenajiavaquerigueti quempoguijajiguirica chancho itsaroajianaquequea ishiashiaitanaca yoayoaitanaque itsavetantajiapojaqueroquea ontaniqui ichoocajiguigueti itsitacavaepojiroquea, iquemacotantajiacarica choocajiatsica acaniqui aisa choocajiatsica quempejipaequi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yoayoaitanaquequea iramenajiaquiteriquea. Ariquea yarejerejeipojacaro ichoocaquegueti Jesoshi yamenajiapojiriquea ishaquiajiavecaca ampatsinipae savicaji iquempejitacocari iquemisantajiri. Quitsaataja quenquejanaji. Itsarotsaroitanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iriraquea amenajiaquerica yoguisotojainirigueti itsatacaajiavaqueri querocaca icoquerini yonigaitsijiacarigueti ishaquiavecarigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ariquea maasano choocajiatsica Gararaqui itsaroacaamajajianacari Jesoshi yamanamanaitantacarica irovashiantajianajeriniji. Ariquea itetanajaro quenajarontsi iquenajatacotanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ariquea iriratica isotoanaqueca ampatsinipae icantavetacari ininque intsipataquempari, cotanquitsiquea Jesoshi itigarancaqueri, icanqueri: ");
INSERT INTO cotNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Poanaje pitsovironaquitequi, pintsavetampojajeroquea maasano queroquea icoquempini Aapani Irioshi. Iriatimpa yoanajiquea yoguisotojaiapojaqueneri maasano choocajiatsica oraniqui ipintsatacotacarigueti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ocoajicatapojajigueti icoraquetajiquea Jesoshi, yagatanaji intatiqueroqui. Maasanopae yaajiavaqueri ishineventajiavacari, iroorijite icocani yoguijaguijaitavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iroompaquea icoraquepoji shirampari ipajitaquea Jairo. Iriatimpa iriguenti jivatanquitsica shinagogaqui icapiocantajiacaca joriojia. Ariquea yamenapojirigueti Jesoshi itaampinatashipojiriquea iguerovempojacari icanqueriquea iroanaquequea itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Irooshipoji ometojaque irorijanite irapatiroritsite. Ocaratacotaque 12 ajagantsite. Ariquea yoanaquegueti Jesoshi yoguijaguijaitanaqueriquea icarajiavaeque caquintejia icantavaetanaque tirorererere oraniqui iroovepojaca irivinacajianaquerimequea. ");
INSERT INTO cotNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ariquea ochoocaque aisa manquigarentsi ashinoncaavaetanquitsica ososoajavaetini coramani, ariqueate ocaratacovaetanaqueni 12 ajagantsiteni. Yaavintanajivetacaroquea teequea inchoocatenica agavejanquitsineca iroveajero, niganquiquea oteroncamajatanaqueri omentaquitsite, ejempacotia oanaca. ");
INSERT INTO cotNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Imaicaquea ocoraquetaque oquenashipojaqueri Jesoshi itaquiqui ochagatsaequitsitavaqueri ocaramagotapojaquegueti irogataamagoro. Irooquea ochagatacotaquitiguiri jac osanticojatanaji ososoajare. ");
INSERT INTO cotNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Icantanaquequea Jesoshi: —¿Taaquea chagatacoquena? Icantajianaquequea maasano: —Tee, jmm. Cotanquitsiquea icantsitanacaquea Peerero aisa itsipatsipaitacaca icantajiguiri: —Tsatacaantantatsica, pamenavecaqueate itsinacajianaquempi itatsintatsiitanaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Cotanquitsiquea Jesoshi arimpaqueate icantanaquequea: —Choocaguitatsi chagatacoquenaca, notsatavaquetari ocantapanajantana shirec nagavejane osotoanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iroatimpa amenavaquerogueti tee agaveji omanacotempaji, ocoraquepojaquequea iriatimpaqui ompioncanacaqueate pion, pion, pion, oguerovempojacariquea. Maasano iquemajiaqueroquea ocamanquerigueti taaquea opaji ochagatimenqueri, aisa ocamanqueriquea ocanque: —Iroompaqueate nochagatacoquempigueti jac osanticojatanaji noriraja. ");
INSERT INTO cotNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iriatimpa icanqueroquea: —Orijani, irooriji pavenquenatarite naatimpa, irootari piveantanajaca. Imaicaquea poanaje pishinevaequempa. ");
INSERT INTO cotNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iroompaquea quenquetsatatsitiraja Jesoshi icoraquepoji itsipa, iquenapoji itsovironaquitequi Jairo, jivatanquitsica shinagogaqui, icanqueriquea: —Jac metojaque porijanite, ariotapojaque pasereguiritsi Tsatacaantantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Cotanquitsiquea Jesoshi iquemaqueriquea, icanqueri Jairo: —Aato pitsaroguitsi. Mana paventanaquena naatimpa, ariquea ompeanajempa. ");
INSERT INTO cotNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ariquea yarejetapojacagueti itsovironaquitequi icanque aatoquea iquijitsi itsipa, iriguenti itsipatsipaitanaca Peerero, Joanca, Santiago, iri joquijitanquitsica aisa iniro, iquijaquijaitanaquequea intsompogui. ");
INSERT INTO cotNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Manaquea icatintiijiaca sotsiqui itsipajia iraacojiaqueroquea metojatsica cajemajiaque icanca, cotanquitsiquea Jesoshi icantajiapanajantiriquea: —Aato piraajiga, teetari ometojeji, manatarite omaaque intati. ");
INSERT INTO cotNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Cotanquitsiquea ishirontimentajianacari, itsajiaquetari metojamajataque. ");
INSERT INTO cotNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iriraquea Jesoshi yaavacopojaquero, iririjencatanaque icanqueroquea: —Chaajaniquitirajaca, pincatianaje. ");
INSERT INTO cotNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ariquea opiapojaja oshire, ocatianaja. Iroompaquea icanque Jesoshi irojocajiaquenero oshecatajempata. ");
INSERT INTO cotNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Manaquea yamenamenaitanaque intati iri aisa iniro, cotanquitsiquea Jesoshi icantajiguiri aatoquea icamantitsi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ariquea icajemajiaqueriquea Jesoshi itsatacaane carajianquitsica 12, icapiocajiaqueriquea yagavejacaajiaqueri iroguisotoaguetaqueri maasano ampatsinipae aisa irogueshiguetajeri joquijiguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Itigarancajiaqueriquea intsavetantimojianaqueri maasano intsatacaajianaqueri quero icocani imajirontagueti Aapani Irioshi. Icantajiaqueriquea aisa irogueshiguetajeriquea joquijiguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Icantajiavaqueriquea: —Aatoquea paimatitsi. Aatoquea paguirotsi pigotiro, pitsarate, pisheca, aisa pimentaquitsite. Aatoquea paguirotsi mavite piitsaare, iroguentiquea oratica piquitsaacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Querocagueti oraniqui poapoaitanaqueni incajemavaquempigueti pimaaque itsovironaquitequi, poapoaitanaquequea pimaaque. Picocaniquea pimaimotaqueriquea arejetapojajempa poapoaitantanajempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Oraqueate aatogueti quericaca aavaquempineca, poapoaitanaquequea, cotanquitsiquea iroquetitaquea pantecamajatanaqueroja quepatsivane pagatiquitsitapojaquerigueti, iroonijite iramenantajiaquempaca manaquea yantaque teeca oncameetsateji teetarite iraavaquempi irishineventajiavaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iroompaquea yoayoaitanaquequea itsitacavaetanaquero querocagueti oraniqui ichoocajiguigueti caquintejia, itsavetantimojianaqueriquea Quenquetsatsarentsi Oganejencatatsica. Aisa yogueshiguetanajiri joquijiguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ariquea iriraquea majirontatsica Erorishi iquemacoquerogueti maasanopae yantaguetaqueca Jesoshi, yamenanaquequea intati querocampa incanque, choocatari cantajianquitsica: “Tancorejanajishia Joancani Viñacajatantatsica.” ");
INSERT INTO cotNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Itsipaqueate cantajianquitsi: “Iriocajate coraquetajatsiquea tsavetantatsicani Iriashini coramaniticani.” Itsipapaequeate cantajianquitsica: “Jac pochatanaji itsipa tsavetantatsica coramaniticani.” ");
INSERT INTO cotNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Cotanquitsiquea icanquequea Erorishi: —Irirampani Joancani nojitorejacaanqueriquea naatimpa. ¿Taampaqueate imaica irira noquemacoqueca icamantacojitirini? Ariquea inintaveca iramenaquerime. ");
INSERT INTO cotNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ocoajicatapojigueti icoraquecoraqueitaji itigarancaqueca Jesoshi icamantaguetapojiri maasanopae yantaguetaquitica. Iquemajiavaqueriquea Jesoshi, itsipatsipaitanacariquea osamani irooshitigueti guinteninintsi icantajitica Vetsaira. ");
INSERT INTO cotNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cotanquitsiquea ari iquemacojiquerigueti yoayoaitanaque isaquiritsaevaetanaque caquinte yoguijaguijaiqueriquea. Iriraquea Jesoshi ishineventajiavacari itsavetantimojiaqueri icamantajiaqueri quero icocani imajirontagueti Aapani Irioshi, aisa yogueshiguetajiriquea ashinoncajajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iroompaquea ijaguitevaetanajigueti catsirincaiteri iquempejiquempejiitanacariquea itsatacaane icantajiguiri: —Poguipaquijajiajeri maasano irirajia iroaroaitanajeta ontaniqui guinteninintsipaequi irooshitacoguetanquitsica cameetsanijite irimagorejajiaquequea aisa irivegarajiaque isheca irishecajiaquempanijite. Ocaniquiquea ocaniqui tee anejeronica querocampa irishecajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Cotanquitsiquea Jesoshi icantajiguiriquea: —Pojocajigueneri aviatimpajia irishecajiaquempaca. Yacajianaque icantajiguiriquea: —Tee anejeroji querocampa nojocajiaquenerica. Iroguentinivani 5 pan, iriraquea shima mavipaquite icarati. ¿Querocaquea noncojiaquempa? ¿Ari nagavejajiaque noanoaitanaque novegarajiaquiteneriquea irashijia maasano irishecajiaquempaca? ");
INSERT INTO cotNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Icantantajiacaca imaica yamenajiaquequea iriguentipioniquea tirorererere caquintejia, icarajiavaetaquequea aricaquea 5,000 shiramparijia. Cotanquitsiquea Jesoshi icantajiguiri itsatacaanejia: —Poguisavicajigueri, poashiguequempari arica incarajiaquequea 50 irisavisaviitaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ariquea iquempejiaqueriquea, yoguisavicaguequeri maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iroompaquea iriraquea Jesoshi yaitaroquea 5 pan aisa mavipaquite shima, yajiricaqueriquea, ipaguitetanaquero inquite yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Iroompaquea icotarejaguequeroquea pan, yojocajiaqueneriquea itsatacaane, iriatimpajia yojocajiavaqueneriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ishecajiacaquea maasano, iquemajianaca. Ariquea iriraquea itsatacaane yaaguetajiroquea choocatajatsica, itetajiroquea cantiriqui tseraiquipae ocaratacovaequequea 12. ");
INSERT INTO cotNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Querocagueti savincaguiteri ichoocaque Jesoshi yamanaqueriquea Iriri, iriguentiquea itsipajiaca itsatacaanejia. Ariquea icoacojiaqueri icanque: —¿Taa ipaji ijijiaquena caquintejia? ¿Quero icantajiguini? ");
INSERT INTO cotNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iriatimpajia icantajiguiriquea: —Iconoagarantajiaca icantacojiaquempi: ‘Iriguenti Joancani Viñacajatantatsica.’ Itsipa cantajiananquitsi: ‘Iriguenti Iriashini.’ Itsipaquea cantajiananquitsi: ‘Iriguenti itsipa tsavetantatsicani paesatinica, tancorejanajishiatsi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ariquea icantajiguiriquea: —Aviatimpajia, ¿quero picantajiguini? ¿Taa nonaque naatimpa? Icantsitanacaquea Peerero: —Aviguenti Quirishitotatsica itigarancaqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Icantajiguiriquea: —Aatojate picamantitsi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Icantanaquequea aisa: —Irantsipevaequempaquea irira Irijanite Caquinte. Irimanintajiaqueriquea jivajiatsica, saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini. Ariquea irimetojajiqueriquea, cotanquitsiquea aapojajempagueti 3 savincaguiteri impochatanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ariquea icantajiguiriquea maasano: —Quericaca nintanquitsineca iroguijatacoquena irovashiantanaqueroja inintashiguevetacaca iriatimpa, maasanopae osavincaguitetegueti irinatashitapiniquempa inchapoa irompajacotantajiquemparica, mananiji iroguijatacoquena. ");
INSERT INTO cotNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Quericaca teeca irininteji irantsipeventena irooca irimetojavenquena, manaquea impeaquempa; cotanquitsiquea iriraquea atsipevenquenaneca irooca irimetojavenquena, incoquempaniquea inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Arigueti inchoocavetaquempa agavejanquitsineca irashinquemparo maasanopae quepatsipaequitica, cotanquitsiquea oncoramanitapojajegueti irimetojanaquegueti arigueti impeaquempa camorecariqui, ¿arimpate agavejaque irajaararo aavajeri? Aatoquea agavejitsi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Quericaca pashiventacaaquenaneca naatimpa aisa nocantaguequeca, ariqueate inquejetaquempaquea irira Irijanite Caquinte impashiventacaapojaquempariquea iriatimpa oncoramanitapojajegueti incoraquetajegueti. Iroganejencapojajempaquea, inquempetapojajempari Iriri aisa irashivantijitete comajashirentanquitsica yoganejencajiacagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Noncanquempija arimajaguitatsi iconoagarantaca catintiitimojiaquenaca imaica, aato imetoji tequeratagueti iramene quero icotani Aapani Irioshi imajirontagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iroompaquea anaavaetanajagueti arica 8 savincaguiteri yoanaquequea otsempiqui iramanajeriquea Iriri, itsipatsipaitanacari Peerero, Joanca, Santiago. ");
INSERT INTO cotNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ariquea yamanaquerigueti Iriri taampinaquea icantashitatianaca ivoroqui, ariquea ocotanaca iitsaare ocavorejatanaque ocantanaquequea tsiren oquitamaromajatanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ariquea iconijajianaque mavite shirampari, itsipajiacariquea Jesoshi iquenquetsatavacaajiaca. Iriotaque Moishishini aisa Iriashini. ");
INSERT INTO cotNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Icavorejamajatanaquequea icantajianaquequea tsiren. Iroguentiquea iquenquetsatacojiaque irimetojaque Jesoshi Jerosarequi onetsanatantaquempaca itioncacojiquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Iriraquea Peerero aisa itsipatsipaitacaca manaquea ipochoquipochoquiitanaque, cotanquitsiquea opeamajatanacagueti yamenitsijigariquea Jesoshi cavorejavaequequea cantavaeque tsiren itsipatsipaitacari Moishishini aisa Iriashini. ");
INSERT INTO cotNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iroompaquea itsinampirejajitanajatiguiri Jesoshi icantsitanacaquea Peerero: —Tsatacaantantatsica, cameetsavaeque achoocajiaque ocaniqui. Intsishiatsi nompeacaguempaja 3 catisetarentsi, aparo pashinquempa aviatimpa, aparo irashintaquempa Moishishi, otsipaquea irashintaquempa Iriashi. Cotanquitsiquea irira Peerero tee intsatavajeroji icantavecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Quenquetsavetanatsi omanacojiapojajiri mararo, itsarotsaroitanaque yamenaquequea omanacojianajiri. ");
INSERT INTO cotNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ariquea iquenquetsajencajitanaque omararosecanquegueti icanquequea: —Iricatica irio Irijani, nopintsamajatacaca. Pinquemisantamajajiguerija. ");
INSERT INTO cotNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ariquea opeanacagueti iquenquetsataquegueti yamenitsijiavetajari Jesoshi aparo icatiaja. Ariquea yoayoaitanajiquea imajerejiapoji teequea incamantapojajeji iroaqueragueti yamenavecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Osavincaguitetanajigueti icoraquetaji Jesoshi aisa itsatacaane iquenaquenaipojaji otsempiqui. Ariqueate yoayoaitanaquequea oshequini caquinte itonquivotonquivoitavajari. ");
INSERT INTO cotNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ariquea iquenquetsatanaquequea aparo irijencavaetanaque icanca, icanqueriquea Jesoshi: —Tsatacaantantatsica, iintsija pamenerija nirijanite, apatiroti icancaquea iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ishaquiacaritari ampatsini icajemamajatacaaqueri aisa icantacaaqueri tinquininini, ishimotyonajatanaquequea icanca. Icocaniquea yatsipetacaaguitarini, tee irinintenica iroguipaquijajeri. ");
INSERT INTO cotNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nocantajiavecariquea pitsatacaane iroguisotojaiaquerime, cotanquitsiquea teequea iragavejajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Icantanaquequea Jesoshi: —¡Arisa picomirincajiga teequea paventemparoji iragavejane Aapani Irioshi, ariguentiquea picovaeguishejiga! ¿Querocaquea oncarashequiavaeteni nosavicaventajiaquempi? ¿Queroca oncarashequiavaeteni nantsipetacojiaquempi? Ipitsocashitanacari iriri icanqueriquea: —Pamaquenarijate acaniqui pirijanite. ");
INSERT INTO cotNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cotanquitsiquea irooquea yaavetanacanarigueti, iriraquea ampatsini yoguitejanaqueri isavi quepatsiqui icantacaanaqueri tinquininini. Cotanquitsiquea icantomajitsitari Jesoshi, yoguisotoitari, ariquea icotanaja chaajaniquiri jac peamajatanaja. Yojoquitajanariquea iriri. ");
INSERT INTO cotNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Maasanopae yoayoaitanaque intati, yamenaquequeate yagavejamajati Aapani Irioshi. Icojiacaniquea quenquejajianatsitiraja iquenquejacojianaquerogueti ipeacaaguecaca Jesoshi, iquenquetsatanaquequea iriatimpa icantajiguiri itsatacaane: ");
INSERT INTO cotNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Imaicaquea pinquemisantamajatavaqueroja noncanquempica. Iriraquea Irijanite Caquinte iraacaantajiqueriquea iraajiavaqueri caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cotanquitsiquea iriatimpajia teequea intsatavaquero taaca icantaqueca, omanapitsajiacariquea. Cotanquitsiquea omintsaroanaqueri incoacojiaquerime taa opaji icanque. ");
INSERT INTO cotNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iroompaquea ipariajianacaro itsatacaane iquenquetsatavacaajiaca iquenquejacojiaca quericaca anaamajatantanquitsine, irooquea icanque, irooquea icanque. ");
INSERT INTO cotNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Cotanquitsiquea Jesoshi itsaqueroquea maasanopae iquenquejajiaqueca. Ariquea yaaquequea aparo chaajaniquiri isenampijacari. ");
INSERT INTO cotNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Icantajiguiriquea: —Quericaca aavaquerine shineventavaquemparine chaajaniquiri quempecarica iricatica iroorijite nonintacaantaquero naatimpa, quempecaqueate naroguentica ishineventavaca. Quericaca shineventavaquenane naatimpa, irioquea aisa irishineventavaquempa tigarancaquenaca. Taacagueti cavintsajantamajatantanquitsine incavintsajamajatanaqueriquea teeca iranaanteji, irioquea iriguenti caaviji yanaantavaeque. ");
INSERT INTO cotNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ariquea icanqueriquea Joanca: —Tsatacaantantatsica, chapinqui namenajiaqueriquea aparo yoguisotoaqueriquea ampatsini, iroguentiquea yaventashicari pivajiro. Cotanquitsiquea naatimpajia nocantimentsitariquea, namenaque tee intsipatacaji. ");
INSERT INTO cotNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Icanquequea Jesoshi: —Imaicaquea aatoquea picantimentiri, maasanotari teeca incatsimajiacaji iroguenti itsipatacaji. ");
INSERT INTO cotNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Irooshipojigueti iroantanajempaca Jesoshi jenoqui inquitequi itampishitashitanaquero iroanaque Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Itigarancajiaqueri iriquetita oananquitsineca incamantanquequea coraquetapoji Jesoshi. Iriatimpajia yoayoaitanaquequea irinetsanaguequeneri, iquijaquijaivetapojaca apatiroca guinteninintsi ichoocatantajiacaca Samariaquitica. ");
INSERT INTO cotNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Cotanquitsiquea iriatimpajia yamenamenaiquegueti ariguenti iroaroaitanaque Jerosarequi, teequea irinintajigueji iraajiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iriraquea itsatacaane pajitatsica Santiago aisa Joanca yamenaquegueti teequea iraajiavaqueriji, icantajiguiriquea Jesoshi: —Nomajirote, ¿ari pininque noncantajiaque asacaraaquempa paamari jenoqui inquitequi ampevoquijajiaqueri onteroncamajaqueri? ");
INSERT INTO cotNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ipitsocashijigari Jesoshi icantomajajiaqueri, icanti: —Tee pintsateji quero icocani Ishire ashintajiaquempica; ");
INSERT INTO cotNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","teenicate iroonica incoraquetantempa Irijanite Caquinte interoncaguetaqueri caquinte, iroguentiquea icoraquetantacaca iraajiavajeri. Iroompaquea yoayoaitanaquequea otsipaqui guinteninintsi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ariquea ishivoquishivoquiitanacaro quenavoquirontsi, icoraquepojaque shirampari icampojiri Jesoshi: —Nomajirote, noninque noncoguitempani noguijaguitempini querocagueti poanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Icanquequea Jesoshi: —Iriraquea zorro chooca imoro iquijantacaca. Ariquea iquempejiaca tsimeripae chooca imencoshi, cotanquitsiquea iriraquea Irijanite Caquinte teequeate onchoocateji itsovironaquite irimaantaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ariquea icanqueriquea itsipa: —Jameja poguijaguitenani. Cotanquitsiquea iriatimpa icanquequea: —Nomajirote, iroquetita nonquitatanajeritaja aapani. ");
INSERT INTO cotNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Icanquequea Jesoshi: —Iriraquea metojashirentari irio quitatajerine metojari. Aviatimpa poanaque pintsavetantaqueroquea quero icotani imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Icantanaquequea itsipa: —Nomajirote, iintsija naatimpa noguijaguitempini, cotanquitsiquea iroquetita pishinetena noapanajanteta notsovironaquitequi noncamantantaguetapanajanteta. ");
INSERT INTO cotNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Cotanquitsiquea Jesoshi icanqueriquea: —Quericaca parianaquemparoneca inquitencavatsatacaantempari igaapironcaarite quepatsiqui, arigueti iramenamenatanaque itaquitapojacagueti, aato otampaticati iquitencaqueca. Ari iquejetaca quericaca parianaquemparoneca iroguijatacotena, arigueti iramenamenatajaterogueti iquejeveguitanigueti coramani, aatoquea yagaveji inetsanamajatiro inintacaavecarica Aapani Irioshi, teetarite irimajirontamajatemparinica. ");
INSERT INTO cotNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Coajicaquea iriraquea Amajirote icoguiaguetaqueri itsipapae itsatacaanejia carajianquitsica 72, itigarancajiaqueriquea irijivajivaitanaqueri intsipatavacaanaquempa mavite mavite, intsitacaguitejavaetanaquero guinteninintsipae querocagueti iroanaqueni iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iroompaquea icantajiavaqueri: “Choocaquea oshequini coguitejajianquitsica irimeshiajiaqueri, cotanquitsiquea teemajacaquea iroshequigueji tsatacaajiaquerineca cameetsanijite irimeshiimentajiquerinijite. Manatarite iquejejiacaroquea osampatigueti tirigoitsoqui ocaraguitetacovaeque catejieguini teemajacaquea iroshequiamajateji aviitaqueroneca. Irootaquequea imaica nocamantantajiaquempica pamanajiaqueriquea Aapani Irioshi intigarancajiaque tsatacaajiaquerineca. ");
INSERT INTO cotNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Poajianaquequea aviatimpajia. Iroguentiquea nontigarancajiaquempiquea inchoocajiaquegueti catsimatantajiatsica irantsipetacaavaequempiquea quempecaquea irioca notigarancaquequea irijanigantirenajaniqui oveja iroanaquequeate yomporoguijagueti lobopae shecatarica oveja. ");
INSERT INTO cotNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aatoquea paajiguitsi pitsaratote, aisa pitetantarica pimentaquitsite, aisa aatoquea paajiguitsi itsipapae pigaviguitire. Aatoquea pisavicaguetanaquequea quenavoquirontsiqui pinquenquetsatavacaajianaquempa pintsipatsipaiquempariquea quericaca pintonquivojajiapojaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Querocaguetiquea oraniqui incajemajiavaquempi pimaajianaque itsovironaquitequi pinquijaquijaitanaquegueti intsompogui iroquetitaquea pincantajiaqueri: ‘Noninquequea incavintsajamajajiaquempi Aapani Irioshi maasano choocajianquitsica pitsovironaquitequi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Irishinevaetanaquempagueti iriatimpa irininquegueti incavintsajamajaqueriquea Aapani Irioshi, ariquea inquejetaquempaquea Aapani Irioshi incavintsajamajataqueriquea. Cotanquitsiquea aatogueti ininti, aatoquea icavintsajiritsi Aapani Irioshi, aviguentiquea incavintsajajiaque. ");
INSERT INTO cotNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Irishineventajiavaquempigueti pincoquempanija pimaimojiaqueri aapojempagueti poapoaitantanajempaca, aatoquea pigajaiatsi. Pishecajiaquemparoquea taaca opajitapae irojocajiaquempica, aisa pimirajiaqueroquea imirajiacaca iriatimpajia. Icantajitiroquea cameetsavaeque irivegarajiqueriquea catsiquetatsica. Jeroquea cameetsavaeque irojocajiaquempiquea maasanopae picoguitejacojiacaca, poimojianaqueritarite pitsavetantimojiaqueritarite. ");
INSERT INTO cotNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Querocaguetiquea oraniqui poapoaitanaque, incajemajiavaquempigueti pishecajianaquempaquea pishecatavaquemparoquea taaca opaji yojocacojiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pogueshiguetajeriquea ashinoncaaguetatsica, aisa pincantajiaqueriquea maasano: ‘Irooshitapoji irimajirontaquempa Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Cotanquitsiquea querocagueti poapoaitanaque aatogueti icajemimpi, pinquenaquenaitanaquequea quenavoquirontsiqui icanquegueti tirorererere caquintejia pincantajianaqueja: ");
INSERT INTO cotNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Noshegontamajajianaqueroquea quepatsivane nagatiquitsitapojaquempica iroonijite pintsajiaquenijite manaquea pipeacajaiaca covaeguisherentsi teetarite pishineventajiavaquenaji. Cotanquitsiquea noninque pintsajiaque irooshipojaquequea irimajirontaquempaquea Aapani Irioshi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pitsajigui coramaniqui icatsimajiaqueriquea Aapani Irioshi Soromaquitica yapevoquijajiaqueriquea iteroncajiaqueriquea. Imaica noncantajiaquempiquea aavaepojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, caaviji irigaajiaqueri teeca irinintajigueji inquemisantajiaquempiji, anaamajataquero irantsipejiaquempaca Soromaquitica. ");
INSERT INTO cotNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Imaicashiatsi patsipevaetempanishiatsi aviatimpajia guintenijiatsica Corashiniqui! ¡Imaicashiatsi patsipevaetempanishiatsi aviatimpajia guintenijiatsica Vetsairaqui! Pamenajiavecaroquea nonigaimojiavequempica oacaantantatsica intati, cotanquitsiquea teequea pinintajigueji pincantashitatijaianajempa povashiantajianajeroji picovaeguishejiacagueti. Iriraquea guintenijiavetatsica coramani Tiroqui aisa Shironequi iriome amenajiguerome, incantashitatijaianaquempamequea inquitsaajiaquemparome jiriquiquijiporoquiro, aisa irigachoncaguinajiaquemparomequea cachopoquiri ironigaantaquempanijite ishimampojancajiaca yamenajiaque icovaeguishejiaca, incantashitatijaianajempamequea. ");
INSERT INTO cotNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cotanquitsiquea aviatimpajia arejetapojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, caaviji irogaamajajiaquempi anaamajaqueroquea incatsimajiaquerigueti Tiroquitica aisa Shironequitica. ");
INSERT INTO cotNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aviatimpajia guintenijiatsica Caperenaoqui paventacojiaca. ¿Ari pijitaque poapoaitanaque jenoqui inquitequi? ¡Aatotarite! Manaquea poapoaivaetanaque isaviji Areshiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Notsatacaanejia, quericaca quemisantamajatavaquempineca aviatimpa, naroguenti iquemisantamajatavaque. Quericaca manintaquempineca aviatimpa, naroguenti imanintaque. Quericaca manintaquenaneca naatimpa, iriguenti imanintaque tigarancaquenaca.” ");
INSERT INTO cotNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ocoajicaguitevaetanaquequea icoraquecoraqueitaji irirajia 72 itigarancajiaqueca, ishinejiapojajaquea icantajiguiri: —Nomajirote, iquemisantajianaque ampatsinipae, noguisotoantajiacari pagavejica naventajiacarogueti pivajiro. ");
INSERT INTO cotNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Icantajiguiri Jesoshi: —Jeejeguitatsi arimajaca namenaqueriquea Satanashi yagavejajitaqueri yasacaraantanacaro inquite iquejetanacaro careti. ");
INSERT INTO cotNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naatimpa nagavejacaajiaquempi pagaticajiaqueriquea camaarini aisa oseroticona. Aisa pagavejajiaqueriquea ampatsini catsimatantanquitsica agavejavetanquitsica, aatoquea querocaca icojiguimpiniquea. ");
INSERT INTO cotNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cotanquitsiquea noncantajiaquempi, aatoquea irooquea pishineventajiatsi pamenajiaquegueti pagavejajiaqueriquea ampatsinipae. Iroguentiquea pishinejiaquempaquea pamenajiaque tioncacojiaquempiqueate jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iroompaquea ariquea icotanaca Jesoshi ishinemajatanaca icanca, yoguishinejaqueriquea Ishire Aapani Irioshi, icanquequea: “Aapani Majirontamajatatsica, aviguenti majirontacojiacarica maasano inquitequitica aisa quepatsiquitica. Noshinevenquempiquea nocanca, pitsititapitsajiaqueritari tsajiatsica teequea ponigaajigueriji querocaca picotani aviatimpa. Iriguentiquea ponigaajiaque teeca intsajigueji. Ari oquempetantacaca imaica, Aapani, irootari pininque aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Yojocaguetaquenaroquea Aapani maasanopae, aisa yagavejacaamajaquena maasanopae. Teequea quericaca tsamajatatsineca querocaca icotani Irijanite Aapani Irioshi, apatiroti tsatanquitsi Aapani. Aisa teequea quericaca tsamajatatsineca querocaca icotani Aapani, apatiroti tsatanquitsi Irijanite aisa irirajia inintacajaiaqueca Irijanite intsatacaajiaqueri.” ");
INSERT INTO cotNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Irioquea ipitsocashitanaca itsatacaanejia icanqueri: “Icavintsajamajajiaquempiquea Aapani Irioshi pamenantajiacaroca maasanopae pamenajiaqueca imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nocantajiaquempi ichoocajiaveca oshequiniquea majirontajiatsica aisa tsavetantajiguiroca icanquerica Aapani Irioshi inintajiaveca iramenajiaquerome pamenajiaqueca aviatimpajia imaica, cotanquitsiquea teetarite iramenimajigueroji. Aisa inintajiaveca inquemajiaqueroquea piquemajiaqueca, cotanquitsiquea teequea inquemeroji.” ");
INSERT INTO cotNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iroompaquea icatiitsitanaca aparo tsatacaantiroca itioncacotanaqueca Moishishini, icoacoqueriquea Jesoshi inintavetaca iramenantempari. Ariquea icanqueri: —Tsatacaantantatsica, ¿querocaquea noncoquempani imaica iranijacaantajenacate Aapani Irioshi cameetsanijite nonchoocaguiteni? ");
INSERT INTO cotNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Icanqueriquea Jesoshi; —¿Querocaquea ocanqueni itioncacotanaqueca Moishishini? Papatsajavantirogueti, ¿querocaquea ocanqueni? ");
INSERT INTO cotNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Icanquequea iriatimpa: —Manatarite ocanque: ‘Pimpintsamajataquemparija Majirontamajatatsica Pirioshite, pampaniromajatanaqueri, pimpintsashirentamajaquempari, pintampishiventamajaqueneri irooriji pipintsamajatacari, pimpintsaguenquejanemajatanaquempari.’ Aisa ‘Pimpintsataquemparija pigonoro pinquejetacaajempa pipintsatagueti aviatimpa.’ ");
INSERT INTO cotNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Icanqueriquea Jesoshi: —Pitampaticamajataqueroquea. Pincoquempagueti pinetsanamajaquerogueti ocanqueca, ariquea iranijacaajempi Aapani Irioshi pinchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cotanquitsiquea iriatimpa inintaque irompetanaquempa, icoacotsitariquea otsipa icanqueriquea: —¿Querimpate nogonoro? ");
INSERT INTO cotNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Icantsitariquea Jesoshi: —Aparo jorio yoavetanacaquea Jericoqui iquenavepojaca Jerosarequi. Cotanquitsiquea ariquea yarejevecaro niganquipoqui yaavaqueriqueate aitsitantajiatsica yaitsimajataqueriquea maasanopae aisa iquitsaacaca yoajiaqueriquea ejempaco, itavatavaaqueri semic semic semic, yamenajiguiquea ijiqueji metojanaque yoguipaquijapanajantiri. ");
INSERT INTO cotNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iroompaquea yoanaquequea oraniqui aparo saserorote iquenapojiroquea iriatimpa aisa Jerosarequi, yamenavetanacari itomicapitsapanajantiri tiijacoñaji oraniqui, yoanajiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aisa icoraquepoji oraniqui aparo irevita amijiguirica saserorotejia, ariquea iquempetacaquea iriatimpa yamenavetanacari itomicapitsapanajantiri. ");
INSERT INTO cotNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cotanquitsiquea icoraquepoji aparo Samariaquitica yamenitsipojacariquea ipintsatacotanacari. ");
INSERT INTO cotNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ishiashitanacari yaanaquequea ashiti aisa vinoja yaavintasetsiqueriquea imaaguequeri. Iroompaquea igataitsitariquea iraashinotequi quijavecarica iriatimpa, itsipatanacari tsovironaquiqui imaantajitaca oahoaitatsica oraniqui. Iquempoguijaqueriquea yojocaguequeneri icoguitejacoguecaca. ");
INSERT INTO cotNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iroompaquea osavincaguitetanaquegueti aisa, yaitsitanaca mavite tenario yojocaqueneriquea ashincaroca itsovironaquite icanqueriquea: ‘Jeri iricatica imentaqui novegaratanquempica pamenamajatajerija iricatica. Aatogueti yarejetaqueate imentaqui oncoajicatanajegueti novegaratapojajempi noncoraquetajegueti.’ Ariquea yoanajiquea Samariaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Imaicaquea imaica iintsija pincanquenaquea, ¿querica peamajaquerica igonoro yaajiaqueca aitsitantajiatsica? ");
INSERT INTO cotNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Icanque iriatimpa: —Iriguenti iricatica pintsatacocarica. Icanqueriquea Jesoshi: —Iroosacanica imaica ariquea pinquempequempa aviatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Arimpaquea yoavaetanaquequea Jesoshi, iroompaquea yarejevaeca ichoocajiguigueti itsipapae. Ariquea ochoocatiquea oraniqui manquigarentsi opajitaquea Marita, ocajemaqueriquea otsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Chooca oguetyote opajitaquea Maria. Iroatimpa osavicaventavaqueriquea Jesoshi oquemisantamajatavaqueri itsavetantaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Cotanquitsiquea oraquea Marita oshoshoguitevencaroquea antaguequeca. Iroompaquea oashitsitanacariquea Jesoshi ocanqueriquea: —Nomajirote, pamenashicaroquea intati iguetyo teequea amitacotenaji, aparo nantaveguitaroni maasanopae, teequea querocaca pincanteroji. Iintsijate pincanteroja amitacotenata. ");
INSERT INTO cotNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Icantsitaroquea Jesoshi: —Marita, iroguentiquea piquenquejacogueque taaca opajitapae pishoshovencaroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cotanquitsiquea chooca aparo caavijica anaaquequea irinintamajajiteca. Irootaquequea ocoguiavaqueca imaica Maria. Aatoquea ichoocati quericaca jocaavaqueroneca. ");
INSERT INTO cotNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ariquea otsipa savincaguiteri yoanaque Jesoshi iramaneriquea iriri. Iroompaquea iteroncanaquitiguiroquea, icantanaque aparo itsatacaane: —Nomajirote, iintsija pintsatacaajiguenaja quero noncoqueroni namanerigueti Aapani Irioshi, pinquejetacaguemparoja itsatacaaquerigueti Joanca itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Icantajiguiri Jesoshi: —Pamanajiaquerigueti Aapani Irioshi, jero pinquejetacaguemparo: ‘Aapani choocatatsica inquitequi, noninque intsaroventamajajiaquempiquea maasano caquinte. Caacateja pimajirontamajapojempa. Noninquequea irinetsanamajajiqueroja ocaniqui quepatsiqui maasanopae pininqueca aviatimpa, onquejetantaquempaca inetsanamajajiquerogueti ontaniqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pojocaquenaja imaica noshecatapinijiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimpeacotsitajenaroja nogovaeguishere, aritarite noquempetaca naatimpa nopeacotsitajari ipeacaavecaca atsipetacaavetaquenaca. Aato pishinejiganarotsi oncoraquetashiquena aatoca notampishitashiti. Manaquea noninque pintampishitacaamajajiaquenaja aatonijite yagavejajana ampatsini incovaeguishetacajaena.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iroompaquea icantajiguiri aisa: —Pinquenquejeroja, arigueti poanincanaquegueti itsovironaquitequi pitsipavijitaca nianquiite pincajemacotapojaqueri: ‘Anianishi, pojoquenashiatsi 3 pan, ");
INSERT INTO cotNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","iriaquerasanoquea arejetapojatsi nogonoro, teetari onchoocatenica nojocavaquenerica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ariquea irancanaquequea iriatimpa ontaniqui intsompoguiqui incanquempiquea: ‘Jaashinete pasereganatsi, ashitacojianajanatarite, maajianajanaqueate maasano. Aatoquea nagaveji nojoquimpitsi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aatoquea yojocavetimpitsi, cotanquitsiquea pincantacoguitempanigueti pamanaguiterini incatiitanaquempaquea irojocaquitempi maasanopae picoguitejacocaca. Cotanquitsiquea aatoquea iro yojoquimentimpi ipeaquempigueti itsipavijitacaca, iroguentiquea irojoquimenquempi picantacoguitani pamanaguitirini. ");
INSERT INTO cotNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Irootaquetari noncantantajiaquempica: pamanaguiterini Aapani Irioshi taaca picoguitejacojiacaca, ariquea iriatimpa irojocajiaquempiro. Pamenagueteroja taaca opajita, ari pamenapojero. Aisa pintinquiapojerogueti sotomorontsi, ari irashirejacoquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aritarite iriraquea amanantatsica irojocajiqueneri. Iriraquea amenaguetatsica iramenapoje. Aisa iriraquea tinquiguiroca sotomorontsi irashirejacojiqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Arimpate piquempejiga aviatimpajia iramanempigueti pirijanite pan, paitsitenempari mapi pojoquitenempari? ¿Arimpate iramanempigueti pirijanite shima, paitsitenempari camaarini pojoquitenempari? ");
INSERT INTO cotNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iriogueti iramanaquempi iitsoqui, ¿paitsitenempari pojoquitenempari oseroticona? ");
INSERT INTO cotNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Quempevecaquea aviatimpajia, picoguishejiavecaquea, cotanquitsi pojocajiguiniriquea pirijanijiate taaca opajitapae cameetsaguetatsica yamanajiaquempica, iriompate Aapani Irioshi choocatatsica inquitequi caaviji intigaranquimojiaqueri Ishire inchoocajiapojaqueri maasano amanajiaquerineca.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iroompaquea Jesoshi yoguisotoaqueriquea ampatsini macanari, irooquea isotoanajigueti ampatsini iquenquetsatanaji shirampari macanavetanquitsica. Yamenamenaitanaquequea intati maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Cotanquitsiquea iconoagaranca manaquea icantajianaque: “Iriguentiquea shaquiacari Veeresevo imajirote ampatsinijia. Iriotaquequea agavejacaaquerica yoguisotoantaguetacanarica ishaquiajiacaca ampatsinipae.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ariquea iconoagarancaqueate itsipapae inintajiaque iramenanquempari icantantajiacarica: “Iintsija pamenacaajiguenaroja otsipa oacaantantatsica intati onquenantapojaquemparo inquite.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cotanquitsiquea iriatimpa itsatavaquero iquenquejajiaqueca icantajiguiri: “Inchoocategueti caquinte incapiocajiaqueriquea igonorojia impeaquempaquea imajirote, iroompaquea arigueti impariajiaquemparo incatsimatavacaajianaquempa, ariquea intsinampirejavacaajianaquempa, aatotari itsipatavacaaja, aato imajirontajiajari. Ariquea iquempejiaca tsipatsipaitarica ijijiguica, arigueti incatsimatavacaajianaquempaquea, ariquea incojianaquempaquea intsinampirejavacaajianaquempaquea, aatotarite iconoavacajaijaa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ariquea iquejetaca Satanashi iriatimpa, ¿arimpate queroquea incoquempani incatsimatavacaajempagueti igonorojia ampatsinijia? Aato iconoavacaaja, aato imajirontajitajari. Manaquea noncantajiaquempi imaica notsaque picantajiaque: ‘Iriguenti shaquiacari Veeresevo agavejacaaquerica yoguisotoitantajijaarica ishaquiaguevecaca ampatsinipae.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iriomegueti agavejacaaquename Veeresevo, ¿ariquea taaquea agavejacaajiaqueri oguijatacoquempica aviatimpa yoguisotoitantajijaarica ishaquiajiavetacaca ampatsinipae? Irootaquequea itsatantajitacaroca manatarite picomica aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cotanquitsiquea iriguenti agavejacaaquena Aapani Irioshi noguisotoitantajijaarica ampatsinipae, irooquea pintsatantajiaquempaca jac imajirontapojaca Irioshimajaca acaniqui aviatimpajiaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Iriraquea ampatsini manaquea iquempecariquea caquinte tampishitatsica choocatatsica ishiquiripite, igotsirote, maasanopae iticaancaca, iquempoguijamajatsitaroquea itsovironaquite, aatoquea quericaca agavejerineca iraitsijiteri. ");
INSERT INTO cotNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Cotanquitsiquea incoraquetegueti itsipa caavijica yanaaqueri, irioquea iriguenti iragavejaque iraitsiqueri maasanopae yaventaguevecaca irashinquemparoquea maasanopae yashintaguevecaca, irojoquitenempariquea quericaca inintacaaqueca iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Iriraquea teeca irishineventavaquenaji, manaquea icatsimaquena; aisa iriraquea teeca intsipatenaji nocapiocantaquegueti, iroguenti yoguivorocantaque. ");
INSERT INTO cotNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Oraquea irovashiantanajerigueti ampatsini iriraquea ishaquiavetacaca, iroanaque ontaniqui oquitamampororoitapojigueti irinintavequempa irimagorejavaequeme. Cotanquitsiquea iroompa iramenavetapojaquemparo querocampa inchoocateni oraniqui. Inquenquejitsitanaquemparoquea incanque: ‘Noantanajemparota notsovironaquiteni nosotoantavetanacaca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ari incoraquevetajempa iramenapojajeri ishaquiavetacaca quempeca tsovironaqui ipishijitirogueti inetsanajitirogueti, cajaraguitejisano oncanquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ariquea iroanaque iraaquiteri itsipajia 7 ampatsini caavijica igajaiaca. Iroompaquea irishaquiajiapojajempari irira ishaquiavecaca iroaqueragueti, ariquea iriatimpa ari incotanajempa arimpa irogaamajatanajempa.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iroompaquea choocatirajagueti iquenquetsavaetaque Jesoshi ocajemitsitanacaquea aparo manquigarentsi tsipajiacarica omporoguijajianquitsica, ocanque: —¡Icavintsajamajajiqueroquea piniro irijaninquempica atsomitimpica! ");
INSERT INTO cotNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Cotanquitsiquea iriatimpa icanquequea: —Iriompaqueate icavintsajamajajique quemajiavaqueroca Iguenquetsatsare Aapani Irioshi netsanamajajiaqueroca. ");
INSERT INTO cotNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iroompaquea arimpaquea yomporoguijaventavaetapojacari Jesoshi, yanquitacojiapojiri icanca, iroompaquea itsatacaajiaqueriquea, icanque: “Aviatimpajia otiavaetaquempiquea covaeguisherentsi, pinintantajiacaca namenacaajiaquempirome oacaantantatsica intati, cotanquitsiquea aatoquea nonigaguimpirotsi. Iroguentiquea nonigaajiaquempi otsipa onquempequemparoquea iquejejiquerigueti tsavetantatsica Jonashini coramani. ");
INSERT INTO cotNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Piquemacojiguiritarite Jonashini coramaniqui. Aapani Irioshi manatarite yamenacaajiaqueriquea Ninivequitica intsajiaquenijite arimajaca iriguenti tigarancaqueri. Ariquea inquempetaquempaquea irira Irijanite Caquinte, manaquea inquejetacaaquempari Aapani Irioshi Jonashini cameetsanijite pintsajiaquenijite aviatimpajia iriotaque itigarancaque aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Oncoramaniguitevaepojajegueti aapojajempagueti incatsimatantajiaquemparica Aapani Irioshi maasano teeca intsaroventajiguempariji, oraqueate imajirojiate Savaquitica oncatiitsitanaquempaquea ontsavetacotsitaquempiro pantaguishequeca aviatimpajia choocajianquitsica imaica. Coramanitari ocoraquetashivaequeri Saromonini oquemisanqueriquea itsatacaaquerogueti, oquenavaetapojiquea jmm osamani oquemacoquerigueti itsamajati. Cotanquitsiquea imaica icoraquevetapojaca caavijica anaavaequerica Saromonini, teequea pinquemisantajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ariquea inquempejiaquempa aisa Ninivequitica incatintiitsitanaquempaquea oncoramanitapojajegueti incatsimatantajiaquemparica Aapani Irioshi maasanojia teeca intsaroventajiguempari, intsavetacotantsitaquempiroquea pantaguishejiaqueca. Maasanotari Ninivequitica iquemisantajiaqueriquea Jonashini itsavetantimojiaquerigueti, ishimampojancajianaca yamenajiacagueti ipeacaaguishejiacagueti covaeguisherentsi, ariquea icantashitatijaianaca. Cotanquitsiquea imaica icoraquevetapojaca caavijica anaavaequerica Jonashini, teequea pinquemisantajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Oraquea itsivojitirigueti tsivorentsi, teequea ariquea intsitijiteriji, aisa teequea irisasaviacojiteriji chomoqui, ariguenti yoguisavicacojitiri jenoquijaniqui, cameetsanijite intsivoguitetanaquenerinijite maasano quijaquijaitanquitsica oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Poquija oquempevecaro otsivore pitsino. Arigueti oncameetsate poquija, pamenamajate, onquempetaquemparo otsivoguitemajatigueti. Aatogueti ocameetsati poquija, aato pamenantamajataro, onquempetaquemparo pipitsecacotigueti maasanotsino. ");
INSERT INTO cotNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pamenamajateroja quero ocotaca piquenquejaguetaqueca. Inchiquiojitsi pijitirotsi cameetsa piquenquejavetacaca, pijitirotsi oquempetacaro tsivoguitetanquitsica, pamenitsivetemparoquea coajica manaquea ocanque pitsec. ");
INSERT INTO cotNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Arigueti ocameetsataque maasano piquenquejaqueca, onquempetaquemparogueti tsivoguitetanquitsica teeca ompitsequimateji, ari pamenamajataqueroquea maasano, onquempetimotaquempi itsivotacoquempigueti tsivorentsi, pintsatavaqueroquea inintacaaquempica Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iroompaquea iteroncanaquitiguiroquea iquenquetsavaequegueti Jesoshi, icantanaque aparo pariseo icajemitsitanacariquea irishecatimoquempari. Iroompaquea yoanaque iquijanaque ipimerequijapojaca shitaponcarontsiqui irishecajiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Cotanquitsiquea yamenitsitanacaquea intati cajemaquerica yamenaqueriquea ishecatacaquea intati teequea inquivavacotempaji inquempejiaquempariji iriatimpajia iquivavacomajataca irooshipojigueti irishecajiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Cotanquitsiquea Amajirote icanqueriquea: —Aviatimpajia pariseojia mana piquempejiacari quiviroca otaqui chotarontsi aisa perato, oraquea intsompoguiqui ooquea cantaitevaequequea. Ari piquejejiaca, mana pinetsanatamampeajiaca intati, cotanquitsi caaviji paitsitantagueti, otsitacashirentavaetaquempi pigovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Teequea pinquenquejajigueji! ¿Arimpate teequea pintsajigueji iriraquea peacaacaroca itsino caquinte irioquea peacaacaroca ishire aisa? ");
INSERT INTO cotNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cotanquitsiquea pinetsanashirentajianaquempaja, pimpintsatacotantajiaquempaja, arigueti pinquempequero, saancavaequequea oncanquempa maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia pariseojia! Taaca opajitapae pashincaca irooca ovanajaniqui menta, irooca quejevecaroca sanconca, irooca otsipapae taaca opajitapae pivintyacajiguica pitsipatacaantajigaroca pisheca pojocagarantaqueneriquea Aapani Irioshi, cotanquitsiquea pipeacojiacaroquea icantajiavequempica: tampatica poaqueneri maasano caquinteguetatsica aisa pimpintsamajajiaquempariquea Aapani Irioshi. Cameetsavaeque pojocagarantajiaqueneriquea Aapani Irioshi pashincaca, cotanquitsiquea aatomesano pipeacojigarome ogonoropae icanqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia pariseojia! Picantacoguitaniquea poapoaitapiniquegueti tsovironaquiqui picapiocantapinijiacaca aviatimpajia pinintajiaque pisavisaviitaque pitsipatsipaitacari caavijica yanaajencavaeque. Aisa poapoaitigueti ontaniqui yojocantajiguetirogueti ajaararontsipae taaca opajitapae, pinintajiaque inquenquetsatacaajiavaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia cameetsatamampeajiatsica! Iroguenti piquempejiacaro yoguijaantajitarica metojatsica coramanitica iroompaquea mana omaperincanaja. Yoapinijiqueroquea yagatigativaequeroquea, iroorijite maperincanajatari teeca iramenantajitajemparoji.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iroompaquea icantsitanaca aparo tsatacaantiroca itioncacotanaqueca Moishishini icanque: —Tsatacaantantatsica, noquemajiavaquempi piquenquetsataquegueti imaica, picantimanajianaquenaquea naatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Cotanquitsiquea Jesoshi icanqueriquea: —¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia aisa, tsatacaantajiguiroca itioncacotanaqueca Moishishini! Poguijatacaantamajatacariquea caquintejia manamajatanquitsica pitsatacajaiaqueriquea taaca opajitapae irinetsanamajataqueca irishineventaquemparinijite Aapani Irioshi, cotanquitsiquea aviatimpajia teequeate pinetsanatimajigueroji. ");
INSERT INTO cotNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia! Iroguentiquea pipeacaashijiacanariquea inquenquejacotantajiquemparica tsavetantatsica metojajianquitsica coramanitica imetojajiaqueca choviquijianaquempica. Cotanquitsiquea manatarite pinetsanatamampeajiacaroquea intati, teequea ariquea ontampaticateji pishineventamajatempariji. ");
INSERT INTO cotNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oraquea pipeacajaiacanarigueti, ponigaantajiacaca mana pamenajiaquero cameetsavaeque imetojajiaquerigueti. Iriatimpajia imetojajiaqueritarite coramaniqui, imaica aviatimpajia pipeacaashijiacanariquea inquenquejacotantajitajemparica cameetsanijite aatonijite omanatsi yoguijaajiquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Paesatoniqui itsatsitacaroquea Aapani Irioshi, irootaquequea icantantacaca: ‘Nontigarancavequenempariquea tsavetantiroca nocanqueca aisa itsipapae notigarancanejia, cotanquitsiquea inconoagaranquempaquea irimetojaqueri, itsipapae irooca irantsipetacajaiquempariquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Oncoramanivaetapojajegueti incatsimajiaquempiquea Aapani Irioshi aviatimpajia choocajianquitsica imaica, inquenquejacaajiaquempiroquea imetojajiquerigueti tsavetantatsica iroaqueragueti ipeacajaicarogueti quepatsi arejevaetajemparo imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iriraquea iriquetica imetojajique iriguenti Averi. Iriraquea impoimajatananquitsica iriguenti Sacariani imetojajiqueriquea teemporoqui itsaroventantajitarica Aapani Irioshi ichoocavecaquea araquerora aretarequi itaantajitarica viratsipae. Irootaquequea nocantantajiaquempica imaica arimajaca incatsimamajajiaquempiquea aviatimpajia choocajianquitsica imaica inquenquejacaajiaquempiroquea maasano imetojajiguequeca, quejetacaquea aviguentijia metojajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Imaicashiatsi pantsipevaetempanishiatsi aviatimpajia tsatacaantajiguiroca itioncacotanaqueca Moishishini! Piquejevecariquea aitsitantavetajaroca yavi iyavitantajitaroca sotomorontsi, teequea inquijeji iriatimpa, aisa teetari irishineteriji nintavetanquitsica inquijaquijaitanaqueme. Pitsajiavecaroquea Iguenquetsatsare Aapani Irioshi, cotanquitsiquea teetarite pinintajigueji pintsamajajiguero aviatimpajia, aisa piticaacojiaqueritari itsipapae nintajiavetanquitsica intsajigue.” ");
INSERT INTO cotNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iroompaquea isotoanajigueti icatsimamajajianaqueriquea pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, ariquea icoacojiaqueriquea taaca opajitapae ");
INSERT INTO cotNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","iramenanquempaca querocaca incanque cameetsanijite intsojeventajiaquemparinijite incatsimatacaantajiaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iroompaquea icaramirincavaetanaquequea jmm caquintejia icantajianaquequea tirorererere icanca itsinacajianacaquea. Iriraquea Jesoshi icantajiguiriquea itsatacaanejia: “Inchiquiojitaja piquempejigaritsija pariseojia, manaquea icameetsatamampeaca intati, aisa itsaroventamampeajiaca. Iquempetacaro anempoacaanaqueroca pan ose, anempoanaquempa maasanose. Shooshoh paajencatsitiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maasanopae yomanajivecaca imaica yamatavijantigueti oncoramanitapojajegueti intsajitaqueroquea. Ariquea oquejetaca maasanopae isenacajiguevetacaca imaica, oncoramanitapojajegueti ironigaantajiqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Irootaquequea imaica nocantantajiaquempica, maasanopae picantaguetaqueca pitsecariqui pomanavecaca imaica, oncoramanitapojajegueti incantajiteroquea savincaguiteriqui, intsajianaqueroquea maasano. Aisa maasano pinchiquiojijencavetaquempa iguempitaqui pigonoro intsompogui pitsovironaquitequi, oncoramanitapojajegueti intsavetantajitero sotsiqui omencotapojacagueti pitsovironaquitequi ovancaitoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Imaicaquea nocantajiaquempiquea aviatimpajia notsipajiacaca, aatoquea pitsaroacaajigaritsi nintajianquitsica irimetojajiaquempi. Iriatimpajia arigueti irimetojajiaquempi iroguenti metojanquitsine pitsino, cotanquitsiquea aato yagavejirotsi irimetojajiaqueroquea pishire. ");
INSERT INTO cotNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cotanquitsiquea naatimpa nontsatacaajiaquempiquea querica pintsaroacaajiaquempaca: irioquea pintsaroacaamajaquempaquea Aapani Irioshi, aparo icanca iriatimpa yagavejamajaque incanquegueti quericaca metojanquitsineca ariquea iragavejaquequea intigarancaqueroquea ishire camorecariqui. Arimajaca irioquea pintsaroacaamajaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Arimpaquea teequea pamenajiguiri tsimeripae ariguenti ivegaraca 5 tsimeri mavimentaquitequea imentaqui? Cotanquitsiquea Aapani Irioshi tee inchoocateji impeacotempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Quempecaquea pimaejia, ariqueate itsaqueroquea apamaeropae. Irootaquequea nocantantajiaquempica aatoquea pitsaroajigui, caaviji panajaiaqueriquea tsimeripae. ");
INSERT INTO cotNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Imaicaquea noncantajiaquempiquea: quericaca cantamajaqueroneca itsaroventamajataquena incamantajiaquerigueti caquintejia, ariqueate inquempetaquempa irira Irijanite Caquinte oncoramanitapojajegueti, incanquequea: ‘Naroguenti ashincari’, inquemajiaqueriquea maasano irashivantijitete Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Cotanquitsiquea quericaca cantaquerineca caquinte: ‘Teetarite nontsaroventempariji Jesoshi’, ariqueate inquempetaquempaquea Irijanite Caquinte oncoramanitapojajegueti, incanquequea: ‘Teequea naroguenti ashintemparine’, inquemajiaquenaquea maasano irashivantijitete Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Quericaca cantaguishevetaquemparineca irira Irijanite Caquinte iragavejaque Aapani Irioshi irishetacotajeriquea, cotanquitsiquea iriraquea cantaguishetacoquerineca Ishire Aapani Irioshi, irioquea iriguenti aatoquea ishetacojitiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Oraqueate arigueti irajaitanaquempigueti shinagogaqui icapiocantapinijiacaca irooca ichoocatigueti jivatatsica joese irioca majirontajiatsica, aatoquea pishoshoguiteta piquenquejajiguiroquea querocaca pincanqueca pinquenquetsatacoventaquempagueti. Aatoquea picanti: ‘¿Querocaca noncanqueni?’, ");
INSERT INTO cotNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","aapojaquempatari inquenquejacaajiaquempi Ishire Aapani Irioshi cameetsanijite pintsajiaquequea querocaca pincanqueca.” ");
INSERT INTO cotNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iroompaquea icantanaque aparo caquinte tsipatsipaitacarica omporoguijajianquitsica icanqueriquea Jesoshi: —Tsatacaantantatsica, iintsija pincanteri iguentijegui irojocagarantaquenaroquea yojoquimojianajanaca aapanini imetojanajigueti. Imashitsatapitsataquenaroquea nashintagarantaquemparome. ");
INSERT INTO cotNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Cotanquitsiquea Jesoshi icanqueriquea: —¿Narompate jivatatsica joese cameetsanijite nonquenquetsatacaaquempiri irojocagarantajempiro? ");
INSERT INTO cotNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ariquea icantajiguiri maasano: —Shooshoh pinintajiguitsija pajaarantajiaquempaquea. Pajaarantajiavequempaquea, ¿arimpate irooquea anijacaajiaquempineca? ");
INSERT INTO cotNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ariquea iquempetacaanacariquea ajaarantavaetatsica, icanque: “Ichoocati caquinte ajaarantavaetatsica. Yashintamajataca iguepatsite ivintyacacaantaqueroquea tirigoitsoqui, iroompaquea ochoocatanaquequea ooquea jmmtacovaequequea teetarite oncapichaguiteteji. ");
INSERT INTO cotNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ocoramanivaetanaquequea anaavaeguetanaqueroquea oratica icapiocantaroca querompaquea incapiocajeroni, icanque: ‘¿Querocaquea noncotajeroni? Anaanaaguetanaqueroquea nocapiocantaroca. Imaica ¿querocaca noncapiocajeroni?’ ");
INSERT INTO cotNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ariquea iquenquejanaqueroquea icanque: ‘Imaicaquea notsaquequea querocaca noncapiocajeroni. Nosoveacaanquerota nocapiocantavetaroca nantacaantaguetajequea otsipapae iniropaequea cameetsanijite arejetajempanijite maasanopae noncapiocantaguetajemparonijite notirigoitsoquite aisa maasanopae najaararopae. ");
INSERT INTO cotNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iroompaquea noshinevaequempaquea noncanque: Imaicaquea choocatacovaetanaquenaquea oshequiavaeque, aatotaquea oteronquitajatsi oncaratacovaetanaquequea ajagantsini, aatoquea taaca nocoguitejacotimataja. Imaicaquea imaica nomagorejaguiteniquea, noshecaguitempani, nomiraguiteniquea, noshinevaeguitempani noncanquempa.’ ");
INSERT INTO cotNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Cotanquitsiquea Aapani Irioshi icanqueriquea: ‘Teequea pintsatimateji aviatimpa. Imaica pimetojaque ompitsecanaquegueti, povashiantaguetanaqueroquea maasanopae pashintaguecaca. ¿Taaca ashintajemparone?’ ");
INSERT INTO cotNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ariquea iquempeca imaica maasano iriratica nintatsica manaquea irajaarantavaequempa intati, cotanquitsiquea iriraquea Aapani Irioshi yamenaqueriquea quempecaquea teeca irashintempaji capichaji.” ");
INSERT INTO cotNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iroompaquea Jesoshi icantajiguiri itsatacaanejia: “Imaicaquea noncanquempi: aatoja pishoshoventajigaro pishecajia choocatacaajempineca, aisa aatoja pishoshoventajigaroquea pinquitsaajiaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Oraquea pishire anijacajaiguimpica yagavejaquequea Aapani Irioshi ichoocatacaaquempiroquea, iroompaquea pisheca caaviji irojocajiaquempiquea. Ariquea oquempecaquea pinquitsaajiaquempaca, yagavejaquequea Aapani Irioshi ichoocatacaaqueroquea pitsino, iroompaquea pinquitsaajiaquempaca caaviji irojocajiaquempiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pamenajiguiriquea cogonti, teequea irivintyacavetempaji, aisa teequea onchoocavetempajiquea incapiocantemparoca isheca iroaroaitapinijigue iraapinijiaquequea irishecajiaquempaca, cotanquitsiquea Aapani Irioshi yojocapinijiaqueneriquea ishecajiacaca. ¡Aviatimpajia caaviji irojocajiaquempiquea pishecajia pishecajiaquempaca, caaviji panajaiaqueriquea araguetatsica! ");
INSERT INTO cotNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Arigueti pishoshoguiteventavequemparo pigatsantsare ¿arimpa pagavejaque pincatsantsatanaje niganqui meetero? ");
INSERT INTO cotNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iroosacanica teequea pagavejajigueji teemajaca omanamajatempaji, ¿queroquea ococani pishoshoventantajiacaroca caavijica omanapitsajiaquempiquea? ");
INSERT INTO cotNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pamenajiguiroguetiquea ocatica ovempenaquipae inchiquiojiquea otsoroashiguetacaqueate iroatimpa, teequea oncatsiquejiavetempajiquea aantaquemparomeca oitsaare, aisa teequea onquiricajiavetempaji, jac ocameetsamajaquequea anaavaequequea ocanca ocameetsavaeque, anaaguequeroquea quitsaarentsi cameetsamorenaguetatsica coramanitica iquitsaajiacaca majirontatsica Saromonini caavijica anaaque ocameetsamorenataquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Quempeca ocatica ovempenaquipae oporencanaque poren icameetsatacaaguequeroquea Aapani Irioshi, cotanquitsiquea osaitequeraquea taampina oshimpeguiricanaque shimpeguiririri, irajaiqueroquea intajaiquero. ¡Aviatimpajiaquea caaviji irojocajiaquempiquea pinquitsaajiaquempaca, caavijitari panajaiaqueroqueate ovempenaquipae! Cotanquitsiquea aviatimpajia teequea paventamajatempariji, manaquea pishoshoventajiaca taaca opajitapae. ");
INSERT INTO cotNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Irootaquequea imaica nocantantajiaquempica: aatoquea pishoshoventajigaroquea pishecajiaquempaca irooca pimirajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Iriguentiquea quempejiguiroquea imaica irirajia teeca intsaroventajiguempariji, ishoshoventajiacaroquea taaca opajitapae, irootaquequea isavicaventajiaquequea iriatimpajia. Cotanquitsiquea aviatimpajia aatojate piquejejiguirotsija imaica, choocatarite Piri inquitequitica. Iriatimpa itsaquequea maasanopae picoguitejacojiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aviatimpajiampani pinintamajajigue pimajirontamajatanaquempari Aapani Irioshi, ariquea iriatimpa irojocajiaquempiquea maasanopae picoguitejacojiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Aatotarite pitsaroajigui, novejajiate. Teequea pincaramirincajiavetempaji, cotanquitsiquea Piri choocatatsica jenoqui inintacaajiaquempi pimajirontajiapojempari aisa impeacaavajempi majirontajiatsica imajirontagueti iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pojocantajiaqueroquea pashintaguecaca, paanquemparoquea imentaquipae, pojocajiaqueneriquea coguitejacojianquitsica. Pinquejetaquempagueti ariquea irojocajiaquempiquea Aapani Irioshi cameetsamajaguetanquitsica ontaniqui inquitequi, onquejevetaquempaquea pinteterigueti imentaquipae tsaratoqui aatoca oshitequirejitsi, aatotari oteroncatsi irojocajiaquempica ontaniqui inquitequi, aatoquea ichoocati aitsitantatsica, aisa aato ichoocati shecaguetaroca quitsaarentsi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aritarite taaca opajita pishineventamajataca manaquea pisavicaventaguitironi piquenquejaguitironi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Aviatimpajia pinquempejiaquemparija yashintajitaca yoguijaguijaitirigueti ashincarica yoguigueti irameneri manquigatanquitsineca. Inetsanatashijiavacariquea incoraquetantajempaca, iquitsaajiaca, itsivojiaqueriquea tsivorentsi yoguijaguijaiqueriquea incajemapojaje intanarejacojiavaqueriquea taampina. ");
INSERT INTO cotNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Irishinejiaquempaquea irirajia yashintajitacaca tinajajianquitsica guijajiavajirica ashincarica incoraquepojajegueti. Noncantamajaquempiquea inquitsaatashipojajempariqueate iroguisavicajiapojaqueri shitaponcarontsiqui irojocajiapojaqueneriquea isheca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Incoraquevequempaquea nianquiitequi irooca osavincaguitetamanaquegueti cotanquitsiquea iramenajiapojajerigueti irashijia tinajajianatsi, irishinejiaquempaquea yashintajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Iintsija pinquenquejajiguerojate, inchoocategueti itsipa choocatanquitsineca itsovironaquite, intsatemegueti querocaca incoraquetantaquempaca aitsitantatsica, ¿arimpate ari irimaaque? ¡Aatoquea! Manaquea intinajavenqueroquea irajaararo aatonijite iquijashitsijitiri iraitsijitaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Irootaquequea nocantantajiaquempica: pincoguitempanija pincomajamajajiaquempaja poguijajiavajeri irira Irijanite Caquinte incoraquepojaje. Aatoguetiquea piquenquejamajajiguirotsi inchiquiojitaja icomirejajiapojajimpitsija.” ");
INSERT INTO cotNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Icantsitanaca Peerero: —Nomajirote, piquejetacaacarogueti imaica ¿ari aparo pitsatacaajiaquena naatimpajia? ¿Arica maasano caquintejia pitsatacaajiaqueri? ");
INSERT INTO cotNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Icanque Amajirote: “Imaicaquea iintsija pinquenquejajigueriquea yashintajicaca tsatatsica quemisantamajatirica ashincarica. Pameneja inchoocategueti ashincarica irashijia, iroompaquea iroanaquequea osamani, incanqueriquea aparo yashincaca irinetsanaguetajeneriquea maasanopae irashijia, icancani irojocajiaqueneriquea ishecajia. ");
INSERT INTO cotNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Irishinevaequempaquea yashincaca incoraquepojajegueti ashintarica arigueti iramenapojajeriquea inetsanamajaguetajiro icantanaquerica, arimpaquea irishineventamajatanaquempariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Arimajaquea incanqueri: ‘Imaica noninquequea pamenaguetaquenaro maasanopae nashincaca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Cotanquitsiquea aatogueti yoguijiri ashincarica manaquea incanque: ‘Aatota icoraquetsita’, ariquea imparianaquemparoquea incatsimajiaqueriquea irashijia shiramparijia irooca manquigarentsijia intavatavaaitaqueriquea. Manaquea irisavicaventaguiteroni irishecaguitempani, irimiraguiteni, irishinquiguitempani. ");
INSERT INTO cotNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cotanquitsiquea taampina incoraquetapojaje ashincarica savincaguiteriqui teeca intsateji, incomirejapojajempari incatsimacatsimavaequeriquea oshequi, intsipatsipaitacaanquempari maasanojia teeca inquemisantajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Iriraquea yashintajitaca tsatatsica inintacaavecarica ashincarica, cotanquitsiquea teequea inquemisanteriji, aisa teeca irinetsanatempaji incoraquepojajegueti, intavatavaavaequeriquea oshequi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Cotanquitsiquea iriraquea yashintajitaca teeca intsateji inintavecaca ashincarica, impeacaaguevequemparoquea teeca irininteji ashincarica, aatomajaca itavatavaajitiri, teetarite intsatenica. Quericacaquea itsatacaamajajiqueca, inintajitiroquea inquempetaquempaquea iriatimpa inquempetacaamajaquemparoquea querocagueti icojitaquerini itsatacajaiquerigueti. Quericaca yojocamajajitica oshequi, inintajitiroquea irojocamajajitajeneriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Naatimpa nocoraquetaquequea cameetsanijite nontsitacapojaqueroniji paamari acaniqui quepatsiqui. Nonintamajaveca osamimincajencatsiquempame. ");
INSERT INTO cotNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Imaica nantsipevaequempaquea. ¡Noshimampojancavaetanaca nocanca, irooshipojitari aapojaquempa! ");
INSERT INTO cotNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pijiqueji irooquea nocoraquetashique noncanqueriquea maasano quepatsiquitica inquemavacaajiaquempa iraavacaajiaquempaquea? Teetarite irooquea noncoraquetashiteji, iroguentiquea nocoraquetashique ompampiatantanaquemparoca intsinampirejavacaajianaquempa, incatsimajitanaqueriquea tsaroventaquenaneca. ");
INSERT INTO cotNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jeroquea imaica inchoocajiaque caquintejia tsovironaquiqui, incarajiaque apavacoro, cotanquitsi mavitetanquitsica incatsimajiaqueri itsipajia, ari intsinampirejavacaajianaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iriraquea shirampari incatsimaqueriquea irijanite, iriraquea irijanite incatsimaqueriquea iriri. Oraquea imanquigare oncatsimaqueroquea orijanite aisa ovataguero, oraquea orijanite oncatsimaqueroquea iniro, ariquea onquempetaquempaquea ovataguero iroatimpa oncatsimaqueroquea ovaguirote.” ");
INSERT INTO cotNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iroompaquea icantajiguiri maasano: “Oraqueate pamenajiguirogueti opoasecantigueti mararo oraquea iquijigueti catsirincaiteri picantajiaquequea: ‘Imaicashia ontejapojenishiatsi incani’, ariquea otejapojiqueate. ");
INSERT INTO cotNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aisa ochovigaguitetigueti oquenajencatapojigueti quirincaqui picantajiaque: ‘Imaicashia oncatsirincaguitetanaquenishia’, ariquea ocatsirincaguitetanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Mana picameetsatamampeajiaca intati! Aviatimpajia pitsajiaveca pamenaguitevetarogueti arica ontejaque arica aato, irooca aisa pitsajiavecaroquea querocaca oncameetsaguitetantanajempaca, cotanquitsiquea ¿quero ococani teeca pintsatantajiguempaji queroca ococani yonigaimojiavequempiroquea Aapani Irioshi maasanopae pamenajiaqueca imaica? ");
INSERT INTO cotNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Queroquea picojiacani aviatimpajia caarica pinintantajiga pintsajiguequea taaca opaji cameetsaguetanquitsica? ");
INSERT INTO cotNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Incatsimataquempigueti pigonoro irinintavequempagueti iraanaquempiquea jivatatsicaqui irisantanatacotacaanquempi, pinquenquetsatacaaguetanaquerija quenavoquirontsiqui pishinetacaajemparinijite aatoniji yaguimpitsi. Ontaniqui iraanaquempigueti jivatatsicaqui iriotarite cajemaquerineca coareta. Iriraquea coareta manaquea iraapanajantempiquea irisantanatacotsitempi. ");
INSERT INTO cotNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Noncanquempiquea, aatogueti povegaramajatajiri catsimataquempica maasanopae paacotaquerica aatotarite yoguipaquijajimpitsi santanatacotaquempica.” ");
INSERT INTO cotNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iroompaquea icoraquecoraqueipojiquea itsipapae icamantajiapojiriquea Jesoshi icantajiguiri: —Iriraquea Pirato imetojacaantajiaqueriquea Garireaquitica ontaniqui ijitorejajitinirigueti Aapani Irioshi viratsipae, ochovivincajatanaquequea iriraja oconoajatanacaroquea iriraja ivirapae ijitorejajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Icantsijigariquea Jesoshi: —¿Ari pijiqueji caaviji yogaamajajiacaquea icovaeguishemajaca iriatimpajia Garireaquitica yanaajiaqueriquea igonorojia, jero iquempetacaajicariquea imaica? Teequea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naatimpa noncantajiaquempiquea aviatimpajia aisa: aatogueti pishimampojancaventajigaro pigovaeguishere aisa aatogueti picantashitatijaijaa, manaquea pinteroncajiaquempa oncoramanitapojajegueti, pinquempejiaquempariquea iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Iroompaquea aisa piquemacojiaqueriquea Jerosarequitica osoveimojiacari imapipancote inirochoviina coramani ontaniqui Shiroequi. Otsinacajiaqueriquea, imetojajiavaeque 18. ¿Ari pijiqueji caaviji yanaajiaque icoguishejiaca iriatimpajia yanaajiaqueriquea igonoropae choocajiatsica Jerosarequi? Teequeate. ");
INSERT INTO cotNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Noncantajiaquempi aviatimpajia aisa: aatogueti picantashitatijaijaa, pinteroncamajaquempaquea pinquempejiaquempariquea iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iroompaquea iquempetacaajiacanariquea Jesoshi icanque: “Ichoocati aparo caquinte ivintyacaqueroquea aparo iguera iniganquitejirequi, ariquea yoapiniquequea iramenapiniquero choocatapojicaca osovena, cotanquitsiquea yoavetanacaquea teequea anejeroji. ");
INSERT INTO cotNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Icantsitariquea shiacotiroca: ‘Iintsija pinquenquejeroja. Nocoraquetashitironiquea coramani, imaica ariquea omavitevaepoji ajagantsini tequerataqueate onchoocateji osovena. Pinchaquiteroshine, mana onchoocatashiguitempani intati.’ ");
INSERT INTO cotNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Cotanquitsiquea iriatimpa icanqueriquea: ‘Iintsija ariotaqueta. Imaicaquea imaica nonqueecavanetashitajeroquea noaviotacotajerota itigaqui viratsi. ");
INSERT INTO cotNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iroompaquea ajagantsitapojajegueti onchoocatajegueti osovena, cameetsavaeque; aatogueti ochoocatitsi, ariquea pinchaquitsitemparoquea.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iroompaquea aapojacagueti savincaguiteri imagorejantajitaca itsatacaantavaetaquequea Jesoshi shinagogaqui icapiocantapinijiacaca joriojia. ");
INSERT INTO cotNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ariquea ochoocaque oraniqui aparo manquigarentsi ocantacoguitani omititsajancaguitini, aapojaca 18 ajagantsini teequea ompejaempaji, iroorijite ishaquiacaroqueate ampatsini imititsajancacaaqueroquea, querocampate oncotajempani ontampaticatantanajempacate. ");
INSERT INTO cotNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Oraquea yamenaquerogueti Jesoshi icajemaqueroquea icanqueroquea: —Manquigarentsi, imaicaquea jac peajimpiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ariquea ipamitsitavacaroquea, ariquea ocotanaja otampaticatanaji oquenquetsatanaque oshinevencariquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Cotanquitsiquea iriraquea jivatanquitsica shinagogaqui, yamenaquerigueti Jesoshi yoveantajaroquea savincaguiteriqui imagorejantajitaca, icatsimatsitanaca, icantajiguiri omporoguijajianquitsica: —Ocaratiquea 6 savincaguiteri irantantajitempaca, irooqueate pincoraquetantapinijiaquempaca cameetsanijite irovejaiajempinijite. Aatoquea irooquea picoraquetantajiga savincaguiteri imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Icantsitanacaquea Amajirote, icantiri: —Cameetsatamampeajiatsica, piquempetaquea aviatimpajia, aapojajagueti savincaguiteri imagorejantajitaca pishiticarejacojiguiri pigaapironcaarite aisa paashinote, paajianaqueriquea pojocajiaqueneri oja, imirajiacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iroompaqueate ocatica manquigarentsi ichoviquitanaqueca Averaame yagavejaqueroquea Satanashi arejevaeca 18 ajagantsini, quejetacaquea yoishotacotaquero, ¿arimpate tee oncameetsateji iroishorejacotantajitemparo savincaguiteri imagorejantajitaca? ");
INSERT INTO cotNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iquejetacaacarogueti Jesoshi imaica, ipashiventajianaca maasano catsimajiavecarica. Cotanquitsiquea itsipajia caquinte ishinejianaca oshequi yamenajiaquerigueti Jesoshi ipeacaaguecaca oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iroompaquea icanque Jesoshi: “¿Imaicaquea taaca opaji quempetaca imajirontagueti Aapani Irioshi? ¿Querocaca nonquempetacaaquemparoquea? ");
INSERT INTO cotNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iroguenti nonquempetacaaquemparoquea oitsoqui moshitaasa ivintyacajitirogueti niganquitejiqui, chaajaniqui onavetaca, cotanquitsiquea otsoroanaquequea agashimpojanacaquea otsegotsegoatanacaquea oquempetanajaroqueate inchato, ichoocatantajiacaroquea tsimeripae.” ");
INSERT INTO cotNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iroompaquea icanque aisa: “¿Querocaca nonquempetacaaquemparoquea imajirontagueti Aapani Irioshi? ");
INSERT INTO cotNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ariquea nonquempetacaaquemparoquea anempoacaguiroca pan. Pamenirotarite manquigarentsi ompeacaguemparogueti pan, aaquequea apamontiinaro tirigovane, ariquea onconoanquemparo anempoacaguiroca, ariquea oncotanaquempa anempoacaanaquero maasanose.” ");
INSERT INTO cotNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iroompaquea arimpaquea yoanaquequea Jesoshi Jerosarequi, iquenavaetanaquequea ichoocajiguigueti caquintejia, itsatacaajianaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chooca aparo icoacotaqueriquea, icanqueri: —Nomajirote, ¿teequea iroshequigueji meshiajianquitsineca? Iroompaquea iquempetacaacaroquea Jesoshi querocaca ancojiaquempani oahoaitantanaquempaca ichoocatigueti Aapani Irioshi, icantajiaqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Pimpanquenaguitemparoniquea pinquijaquijaitantanaquemparoniji sotomorontsi chaamorojaniquitatsica. Noncantamajaquempiquea inchoocajiavequempaquea oshequini nintajiavetanquitsineca inquijaquijaitantanaquemparo, cotanquitsiquea aatoquea yagavejajiga iquijaquijaitiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Oncoramanitapojajegueti incatianaquequeate ashincaroca itsovironaquite irashiteroquea sotomorontsi. Aviatimpajia teeca pinquijaquijaiteji pincatintiijiaque sotsiqui pintinquiitavetemparoquea ashitacorontsi pincajemajiavetanaquempaquea: ‘Nomajirotee, pintanarejacojiguenatsija.’ Cotanquitsiquea iriatimpa incantsijiguempi: ‘¿Querompate piquenajiapojini aviatimpajia? Teequea nontsajiguempiji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pincantsijiavetanaquempaquea: ‘Noconoajiguimpi ashecajiacagueti aisa amirajiacagueti, aisa aviatimpa pitsatacaantavaeque quenavoquirontsiqui noguinteniqui nocaramirincavaequegueti.’ ");
INSERT INTO cotNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Cotanquitsiquea iriatimpa arimpaquea incantajianaquempiquea: ‘Teequea nontsajiguempiji. Tee nontsateji quero piquenapojini. Poapoaitanaquequea osamani maasano aviatimpajia antaguishejiguiroca covaeguisherentsi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ariquea piraajianaquempaquea pantsicajiaqueroqueate paji pamenajiaquerigueti Averaameni, Ishaaconi, Jacovoni aisa itsipapae tsavetantajiatsica iconoajiapojacariqueate Aapani Irioshi ontaniqui imajirontagueti, aviatimpajia manaquea impishoncajiaquempiquea osamani. ");
INSERT INTO cotNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Incoraquecoraquejiaque inquenaquenaivaepojaquequea jmm osamani oshequini otsipapaequi quepatsi irishinemajajiaquempaquea inconoajiaquempariquea Aapani Irioshi irisavicajiaque irishecajiaquempa. Inquenaquenaivaepojaquequea isotoguigueti catsirincaiteri, itsipapae inquenaquenaivaepojaquequea iquijigueti catsirincaiteri, itsipapae quirinca, itsipapae inquenaquenaivaepojaquequea catonco. ");
INSERT INTO cotNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Irirajia teeca iranaantimajigueji imaica acaniqui quepatsiqui, inconoagaranquempaquea iranaampojaque. Irirajia anaantajianquitsica imaica inconoagaranquempaquea aatoquea yanaantimajiaji, maasanoquea iranaajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iroompaquea incajaranquiguitetanaquitigui icoraquecoraqueipojiquea pariseojia icantajiapojaqueri Jesoshi: —Poanaqueshia otsipaqui quepatsi, ininquetari Erorishi irimetojacaantempi. ");
INSERT INTO cotNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Cotanquitsiquea iriatimpa icantajiguiri: —Poapoaitanajiquea pincamantajiapojajerija irinta amatavijantatsica, pincanqueri: ‘Iintsija pameneja, imaicaquea imaica choocatirajana nonigaaquempariquea ampatsinipae aisa nogueshiguetajeri ashinoncajaguetatsica. Ariquea nonquempetaquempaquea osaitequera, aisa otsipa savincaguiteri, teetarite oshequiavaeteji savincaguiteri nonteroncaguetanajeroquea nocoraquetashitaqueca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cotanquitsiquea imaica arimpaqueate antanatsinaqueate, nonquejetacaajemparoqueate aisa osaitequera, ontsipavepojaquempaquea osaitequera nonquejetacaitajemparoquea aisa. Irootari Jerosarequi imetojantajicari oshequi tsavetantajiaqueroca icanquerica Aapani Irioshi. ¿Arimpate irimetojavaete otsipaqui? ");
INSERT INTO cotNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerosarequitica, Jerosarequitica, pimetojajiguiriquea tsavetantajiatsica, aisa pitsinatsinavaetaqueriquea itigaranquimojiavequempica Aapani Irioshi intsavetantimojiaquempiro Iguenquetsatsare! Pamenajiguiroquea chaapa osaavantajiguirigueti irijanijiate, nonintaguevetacaquea naatimpa nonquempetacaajiaquempimequea maasano aviatimpajia noncapiocajiajempimequeate pintsaroventajiaquena, cotanquitsiquea aviatimpajia teequea pinintajigueji. ");
INSERT INTO cotNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Imaicaquea imaica aatoquea ichoocatimojiajimpi Aapani Irioshi, aparoquea pinchoocajiaje. Noncantajiaquempiquea imaica aatoquea pamenajiajana arejevaetapojajempaquea aapojajempagueti pincantajianaquetaquea: ‘¡Iintsishiatsi irishineventajiquempari iriratica coraquetapojatsica itigarancaqueca Majirontamajatatsica!’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Iroompaquea aapojacagueti savincaguiteri imagorejantajitaca yoanaquequea Jesoshi ishecatacaquea itsovironaquitequi pariseo anaantatsica. Itsipajia pariseojia yamenamajaqueriquea querocaca incoquempani. ");
INSERT INTO cotNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ariquea ichoocaque oraniqui iriatimpaqui aparo eereheereatatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iroompaquea icantanaque Jesoshi icoacojiaqueriquea tsatacaantajiguiroca itioncacotanaqueca Moishishini aisa pariseojia, icantajiguiri: —¿Cameetsataque ampeantajempari joquijitatsica savincaguiteriqui imagorejantajitaca, arica teeca oncameetsateji? ");
INSERT INTO cotNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Cotanquitsiquea iriatimpajia imajerejianaquequea. Iroompaquea Jesoshi yajiricapojaqueri eereheereatatsica yoveajiriquea, icanqueri iroanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iroompaquea icantsijigariquea aisa pariseojia: —¿Arimpaquea aviatimpajia, intanquirejegueti omoroqui pirijanite irioca pigaapironcaarite savincaguiteriqui imagorejantajitaca, arimpa aato paajiajatiri? ¿Arimpate ari poguijajiaquequea anaanajempata imagorejantajitaca ariquea paajiajateriqueate? ");
INSERT INTO cotNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Manaquea imajerejianaquequea, teequea intserarejimajigueji capichaji. ");
INSERT INTO cotNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iroompaquea iriraquea Jesoshi yamenajiaqueriquea maasano icajemajiqueca irishecajiaquempa iroguenti inintamajajiaquequea irisavisaviitapojaque quempeji irisenampijapojaquempari cajemajiaquerica, irishineventamajajitaquempariniji iranaampojaqueniji. Ariquea itsatacajaiaqueriquea icantajiguiri: ");
INSERT INTO cotNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Incajemaquempigueti iriaqueraca manquigatanquitsica pishecatimoquemparigueti irishinevenquemparogueti imanquigatantacaca, aatoquea pisavicampojacaro irisavicantapojaquempaca anaantatsica. Aricagueti incoraquepojaque itsipapae anaaquempica, ");
INSERT INTO cotNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iroompa iriraquea cajemajiaquempica incoraquepojaquegueti incanquempiquea: ‘Iintsija tiijaitatsija iricatica.’ Ariquea ovashiventajanaquempiquea, iroompa pintsenterejapanajante pisavicampojajemparoquea isavicantapinitaca teeca iranaanteji. ");
INSERT INTO cotNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arigueti incajemaquempi, iroguentiquea pisavicampojempa itiinatapinitagueti teeca iranaanteji, cameetsanijite inquijapojegueti cajemaquempica iramenapojempiquea incantapojempinijite: ‘Notsipavijitaca, caacateja acaniqui pisavicampojemparoquea itiinatantajiaca anaantatsica.’ Iroompaquea inquemajiaquegueti tsipatsipaitaquempica shitaponcarontsiqui intsajianaquequea aviguenti ishineventamajataca cajemaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iriraquea aventacotatsineca iroguipashiventajiqueriquea. Iriraquea teeca iraventacotempaji iranaacaajitaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ariquea iquenquetsataji Jesoshi, icanqueriquea cajemaquerica: —Pintiacaantegueti pisheca pincajemantegueti aatoquea iriguenti pincajemapinique pitsipavijitaca, irioca piguentijeguijiate, irioca pijiguetica, irioca ajaarantatsica choocajianquitsica quempeji pitsovironaquitequi. Arigueti pincajemajiaqueri iriatimpajia, inquejetacaajempi incajemajiajempiquea aviatimpa pishecatimotajatempariquea iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Iriompate pincajemajiaque teeca irashintempaji, iriojiaca chompeguijiri, iriguentijiaca teeca iranijimajateji, iriguentijiaca aisa shamponcajari. ");
INSERT INTO cotNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ariquea pishinemajatanaquempaquea oavaetanaque, aatotarite yagavejajiguiquea inquejetacaajiajempiquea iriatimpajia, cotanquitsiquea oncoramanitapojajegueti inquejetacaajiaquempiquea Aapani Irioshi intancoretancoreitanajegueti irirajia iramenajiaqueca quempeca teeca incovaeguishetimatempaji. ");
INSERT INTO cotNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chooca aparo savicanquitsica shitaponcarontsiqui irooquea iquemaquerigueti Jesoshi icantaquegueti icantsitanaca: —Irishinevaetanaquempaquea irirajia shecajianquitsineca ontaniqui imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ariquea icantanaque Jesoshi, iquejetacaajiacanari, icanque: —Ichoocaque shirampari ininque incajemantaque, iroompaquea icamantacaantajiaqueri maasano incajemaqueriquea irishecatimojiaquitempari incaramirincavaequequea jmm. ");
INSERT INTO cotNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Coajica itiacaanquequeate taaca opajitapae isheca, iroompaquea oposatanaquegueti itigaranquitsitariquea yashincaca irishiashiguequiteriquea incanqueri: ‘Caacateshiatsi, netsanaguetacaquea maasano.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Cotanquitsiquea maasanoquea icantacantaitanaque: ‘Aato nagaveji noguitsi.’ Aparo icanque: ‘Iroaquerasano narejetapojaja novegaraquitiroquea quepatsi, noanaquequea namenajatero. Pincavintsajacotena, aato picantana.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Itsipaqueate cantananquitsi: ‘Iroaquerasano narejetapojaja novegaraquitiriquea 10 caapironcaari, noanaquequea namenajateri nontsatimenqueniji arimajaca yagavejajiaque inquitencavatsataque. Pincavintsajacotena, aato picantana.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iriraquea itsipa icanque: ‘Iroaquerasanotarite nomanquigacaro manquigarentsi, aato nagaveji noguitsi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ariquea icoraquetaji yashintajitaca icamantapojajiriquea ashincarica. Icatsimatsitanaca iriatimpa icanque: ‘Iroosacanica poanaquequeate ontaniqui ocapiocaguecagueti tsovironaqui, pintsitacavaetanaqueroquea maasanopae quenavoquirontsipaequi, pintsipatsipaiquempariquea teeca irashintajiguempa, iriguentijiaca chompeguijiri, iriguentijiaca teeca iranijimajateji, irioca aisa shamponcajari, incoraquecoraqueique irishecatacojiaquenaquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Osamaniguitevaepojigueti icoraquetaji yashincaca icantapojiriquea: ‘Jac naajiaquitiriquea, cotanquitsiquea tequerataquea intsitacajiguemparoji shitaponcarontsiqui.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Icantanaque ashincarica: ‘Iroosacanica pijateja poanaje irooquea pishivoquitantaguetanaquemparoquea quenavoquirontsipaequi tequerataca poantemparoji pamenantaguetapanajantemparija maasano choocajianquitsica oraniqui, pintsipatsipaitanaquemparija incantavaetanaquetaquea tirorerere notsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Noncamanquempiquea, irirajia iriquetica nocajemacaantaguevetacaca aatoja ishecatimataro ocatica nonetsanavetacanarica.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iroompaquea ishivoquitanacaroquea Jesoshi quenavoquirontsi itacororoaventajianacari caquintejia. Iroompaquea ipitsocashijianacariquea icantajiguiri: ");
INSERT INTO cotNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taacagueti nintanquitsineca impeamajataquempa notsatacaamajare, incantacoguitempaniquea impintsamajataquena anaimentanaqueroniji ipintsajigarigueti irijanintajigarica, irooca imanquigare, irijanijiate, irorijanijiate, irioca iriguentijeguitepae, irooca itsijoitepae. Ariquea onquempetaquempa aisa anaaqueroniji ipintsatagueti iriatimpa. Oraqueate aatogueti iquempetacagaro imaica, aatotarite yagavejitsi impeaquempaquea notsatacaane. ");
INSERT INTO cotNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ariquea iquejetacaquea aisa quericaca teeca irininteji irinatanontanaquempa ivoatsite irompajacotantajitaquemparica irantsipeventavaetena iroguijatacotantanaquenaca, aatoquea yagavejitsi impeamajataquempa notsatacaane. ");
INSERT INTO cotNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Taacagueti nintanquitsineca impeacaaquemparoquea mapipanco inirochoviina, iroquetitaquea inquenquejamajaquero quero incaraquisequitaqueni imentaquitsite intsitacanquemparoniji. ");
INSERT INTO cotNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Oraquea aatogueti iroquetitaquea iquenquejirotsi managueti impeacaashiquemparoquea intati, niganquiquea interoncacopojempaquea, aato itsitaquirotsi, arica irishirontimentajiquempari iramenitsijiquerigueti manaquea capichajaniqui yogatiaguetaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Incantajigue: ‘Iriatimpa ipeacaaguevecaroquea, teequea iragavejeroji interonqueroji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Arigueti inchoocaque majirontatsica ashintanquitsica 10,000 coareta iroaroaitanaquequea irashimirintavacaguempaquea itsipa majirontatsicaqui ashintanquitsica 20,000 igoaretate, ¿arimpate aatoquea iroquetitaquea iquenqueji arica iragavejajiaqueriquea, arica aatoca yagavejajitiri? Inquenquejanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ariquea iramenanaquegueti aatoquea yagavejiritsi, intigaranquitsitempariquea cantajiajerineca, intonquivojajiavaquempariquea caavijica yanaajiaqueri, iramenajiaqueriquea arica iragavejajiaqueri irivetsinantajiavajeri. ");
INSERT INTO cotNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Arimpaqueate oquejetacaquea imaica quericagueti teeca irininteji irovashiantaguetanaqueroquea maasanopae yashincaca, aatoquea ipeamajataquea notsatacaane. ");
INSERT INTO cotNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Oraquea incachoanepane cameetsavaeque, cotanquitsiquea ariguetija omasancategueti, ¿querocampate incojitajeroni incachoanetantajitajemparo? ");
INSERT INTO cotNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Teequea oncameetsateji onconoaquemparogueti quepatsi, aisa teequea oncameetsateji pinconoanquemparogueti camishitequi poaviotantaquemparoquea panquirentsi. Manaquea impishoncajitaqueroquea intati. Choocagueti piguempita pinquemantavaquempaca, pinquemeja.” ");
INSERT INTO cotNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iroompaquea icoraquecoraquetashijiaqueriquea Jesoshi maasano capiocapinijiguinirica majirontatsica imentaquipae aisa itsipajia covaeguishejiatsica, iroguentiquea icoraquecoraquetashijiaque inquemisantajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iroompaquea yamenajiavaquerigueti pariseojia aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, ariquea iquenquetsatacoguishejiaqueri Jesoshi, icantajigui: —Iintsija pameneri. ¿Quericaquea icocani irintatica iconoconoipojacariquea covaeguishejiatsica ishecatacojiapojacari? ");
INSERT INTO cotNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iroompaquea icantanaque Jesoshi iquempetacaaca icanque: ");
INSERT INTO cotNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pameneja aviatimpajia, pashinquempagueti 100 oveja paajianaqueriquea oraniqui cataromashiqui irishecajiaquempaquea, ariquea impeaquempagueti aparo, ¿arimpate aatoquea pitsinampirejajianaqueri igonorojia, poanaquequeate pamenaguetajateriquea, pincantacoguitempani paantajatemparicajate? ");
INSERT INTO cotNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Arigueti paajaterigueti pantsomajanajeri paanajeri pishinevaetanajempaquea oshequi. ");
INSERT INTO cotNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Iroompaquea parejetapojajempagueti pitsovironaquitequi pincajemajiapojajeriquea pitsipavijijiaca irioca irooshitacoguetaquempica pincantajiaqueriquea: ‘Jaameja ashinejiaquempaquea, naajatiritarite novejate peavetanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Imaicaquea noncantajiaquempi ariquea inquejetempaquea inchoocategueti aparo covaeguishetanquitsica irovashianterogueti ipeacaaguishevecaca covaeguisherentsi ariquea incantashitatianajempaquea, irishineventamajajitanaquempariqueate oshequi ontaniqui jenoqui inquitequi, anaavaetanaqueroquea ishineventajiacarigueti 99 comajamajajianquitsica teeca incoguitejacojiajempaji incantashitatijaiguempaji. ");
INSERT INTO cotNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nonquempetacaajiaquempiro otsipa. Iroguentica ashinquempaquea aparo manquigarentsi 10 omentaquitsite vegaravaetatsica, ariquea impeaquempagueti aparoshimentaqui ¿arimpate aatompate otsivotiquea tsivorentsi ompishitacotsitajempariqueate oncoamajatajeriquea aajerinijite? ");
INSERT INTO cotNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Arigueti aajerigueti, oncajemajiaqueroqueate otsipavijijiaca irosati irooshitacoguetanquitsica oncantajigueroquea: ‘Jaameja ashinejiguempa, naajiriqueate nomentaquitsite peavetanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Imaicaquea noncantajiaquempiquea ariquea iquejejiacaquea irashivantijitete Aapani Irioshi ishinejiaca oshequi yamenajiguigueti icantashitatijaiaca aparo covaeguishetatsica.” ");
INSERT INTO cotNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iroompaquea icanquequea Jesoshi aisa: “Ichoocatiquea aparo shirampari, chooca irijanite mavite. ");
INSERT INTO cotNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iroompaquea iriraquea ichoviqui icanqueriquea iriri: ‘Aapani, iintsijate pojoquenarojate imaica maasanopae nashinquempaca naatimpa oncoramanitapojajegueti pimetojanajegueti.’ Iriraquea iriri yojocajiaqueneriquea mavite maasanopae otampaticaguequerica. ");
INSERT INTO cotNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Iroompaquea oquempejipojajigueti savincaguiteri iriraquea ichoviqui yaaguetanaqueriquea maasanopae imentaquitsite, yoavaetanaquequea osamani ontaniqui otsipaqui quepatsiqui, ariquea oraniqui ipeacaaguishetapojacaroquea taaca opajitapae, ipomatsaqueriquea imentaquitsite, iteroncamajaqueriquea oraniqui, cajaraguitenisano yoaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ocoajicaguitevaetanaquegueti iteroncamajaquerigueti maasano imentaquitsite, oteronquitsitanacaquea isheca otsitacaguitejanacaroquea oraniqui, querocampaquea irajaeroquea irishecatajempaca, yatsipevaecaroshia itase. ");
INSERT INTO cotNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Coajica yoanaquequea yamanapojiri guintenitaroca ocaniqui iramipojeriquea iraaquenijite imentaquitsite. Iriatimpa itigarancaqueriquea inquempoguijaqueneri ichanchotepae. ");
INSERT INTO cotNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ariqueate itaseaguetapoji icanca iroovetanacaquea irishecatanaquempamequea osagoma yojocajitinirica chancho inquemanaquempanijite teenica onchoocatimateji irojoquimajiteneriji irishecaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Iroompaquea iquenquejitsitanacaroquea icanque: ‘Iriraquea amitirica aapani ishecajiaca icanca, iquemajianaca teequea interoncamajajigueroji. Naatimpa acaniqui imaicashia aanaquena notase. ");
INSERT INTO cotNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iintsija noanajequeate aapaniqui noncampojajeriquea: Aapanii, yamenaquenaquea Aapani Irioshi inquitequitica nopeacaaguishevaecaquea covaeguisherentsi, aisa aviatimpa noguipashivenquempiquea, noteroncamajatanaqueriquea maasanopae pojocaguevequenaca, nopomatsaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Imaicaquea ooquea aatocaqueate picantajana irijani, manaqueate pinquempetacaajena amitimpica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Iroompaquea yoanajiquea yarejevaepoja itsovironaquitequi iriri. Irooqueate yamenacotsitavajarigueti icoraquepojajigueti ipintsatacotanacariquea oshequi, ishiashitanacariquea itonquivojavacari, yaavajiriquea yavitsanoitavajiri inintavorotavajiri. ");
INSERT INTO cotNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iroompaquea icantanaquequea iriatimpa: ‘Aapanii, yamenaquenaqueate Aapani Irioshi inquitequitica nopeacaaguishevaecaqueate covaeguisherentsi, aisa aviatimpa noguipashivenquempiquea, noteroncamajatanaqueriquea maasanopae pojocaguevequenaca, nopomatsaqueriquea. Imaicaquea ooqueate aatocaquea picantajana irijani.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Cotanquitsiquea iriri icantajiguiri irashijia: ‘Poapoaitanaquequea paaquite quitsaarentsi caavijica anaaque ocameetsamajataquequea, pinquitsaajiaqueri, aisa pasatecaqueneri maachapaquirentsi ichapaquiqui, aisa pincaviguitijiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Paajiaquiteja caapironcaari irijanigantirenajaniqui quejitanquitsica, pijitorejitempariquea. ¡Jaame ashecajiaquempaquea ashinejiaquempaquea! ");
INSERT INTO cotNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Coraquetajitarite irijani, iroaquerasanoquea namenajiri arimegueti irimetojaquemegueti. Ipeamajavetacatarite, imaicaquea imaica amenajiajiriquea.’ Iroompaquea ishecajiacaquea ishinemajajiacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Iriraquea iriquetica ariguenti ichoocaque niganquitejiqui. Iroompaquea icoraquevetapojaca iquemajiapojiri soncajiatsica yoshequiavaeque, aisa itsamarojiaque. ");
INSERT INTO cotNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iroompaquea icajemaquequea aparo yashincaca icoacojiaqueriquea icanqueri: ‘¿Taaquea opaji oraniqui?’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Iriatimpa icanqueriquea: ‘Iroguenti icoraquetajiquea piguentijeguite. Imaicaquea ijitorejacaanqueriquea piri irijanigantirenajaniqui caapironcaari quejitanquitsica, cameetsatari yarejetaja.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ariquea icotanaca icatsimatanaquequea iriatimpa, teequea irininteji inquije tsovironaquiqui. Irooquea iquemacoquerigueti iriri, isotoanaquequea yoanaque inquenquetsatacaaqueriquea inquijapojenijite. ");
INSERT INTO cotNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cotanquitsiquea iriatimpa ari icanqueriquea: ‘Pameneja, pitsataquequea aviatimpa naatimpa nocantacoguitaniqueate namiguitimpiniquea, teequeate nomperatimotempiji, teequea ari pojoquimatenaji aparo caavera irijanijaniqui noncajemajiaquerimequea notsipavijijiaca noshecatacaajiaquemparime noshinejiaquempame. ");
INSERT INTO cotNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cotanquitsiquea imaicaquea icoraquetajigueti pirijanite teronquitanaquempirica pimentaquitsite ipomatsatacaantacaroquea manquigarentsijia cantatsatantaguetatsica, paitsitanacaquea pijitorejacaantsitariquea irijanigantirenajaniqui caapironcaari quejitanquitsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Icantsitanacariquea iriri: ‘Irijani, aviatimpa ariqueate pichoocaque naatimpaqui. Maasanopae nashintaguecaca iroguenti pashi aviatimpa aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cotanquitsiquea imaica cameetsavaeque ashecajiaquempaquea ashinejiaquempaquea, coraquetajitarite piguentijeguite, iroaqueraqueate nojiqueji ariqueate metojaque, ipeamajavecaquea, imaicaquea imaica coraquetaji amenajiajiri.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iroompaquea Jesoshi icantajiguiri aisa itsatacaanejia: “Ichoocaque aparo ajaarantatsica, chooca itigaranquica amenaguetinirica maasanopae yashintaguecaca. Iroompaquea icamantajiqueriquea ipomatsaguetaqueroqueate yashintaguecaca, opeaguetaca. ");
INSERT INTO cotNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iroompaquea icajemaqueriquea icanqueriquea: ‘¿Arimajaca pipomatsatsiguequenaro? Iintsijate pojoquenarojate pivaperipanate pitioncacoguequerogueti maasanopae, namenerota queroquea picoqueroni, aatotarite pamitacotajanaqueate.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ariquea iquenquejanaque itigaranquica: ‘¿Querocaquea noncoquempani imaica? Aatotarite namitacotajiriqueate, ¿quericaquea namitacogajoitajeca? Teetarite nontampishiteji, ¿queroquea noncoquempani noshiacoquegueti? Nopashivencaquea namanapiniquerigueti itsipapae irojocashitapiniquena intati.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iroompaquea incajaranquiniquea icanque: ‘Imaicaquea notsaquequea querocaca noncoquempani cameetsanijite inchoocaquenijite aavajenaneca jocaquenaneca nosheca coajica intigarancaquenagueti jivatanaca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ariquea yoanaque icajemajiaqueriquea aacoquerica jivatirica, aparopaetaquea icajemaque. Iriraquea iriquetica icajemaqueca icanqueriquea: ‘¿Querocaca icarashequiguini paacoqueri jivatanaca?’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yacanaqueriquea iriatimpa, icanque: ‘Iriguenti naacoquequea ashiti icaratacovaeque 100 chomoqui.’ Iroompaquea icanqueriquea: ‘Jero ocatica pivaperipanate pitioncacotancarica coramanitica paacoquerigueti. Imaica iintsija caacatequetirote taampina pintioncajeroquea acaniqui pincantashitatiajemparoquea ariguentiquea incarataje pojocaje 50.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iroompaquea icajemitsitaquea itsipa iquempetaqueriquea iriatimpa icanqueriquea: ‘¿Querocaquea ocarashequiavaequeni paacoquerigueti jivatanaca?’ Iriatimpa icanque: ‘Iroguenti naacoque tirigoitsoqui ocaratacovaeque 1,000 inirojeguiqui cantiriqui.’ Ariquea icanqueriquea: ‘Jero ocatica pivaperipanate pitioncacotancaroca coramanitica paacoquerigueti. Imaica iintsijate caacatejate pintioncajeroquea ocatica pincantashitatiajemparoquea oncaratanajequea pojocajeca 800.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Iroompaquea iriraquea jivatirica itsaquegueti iquejetaquerogueti imaica, yamenanaquequeate intati, icanque: ‘Caaviji itsaveca iriraquea amatavijantanquitsica.’ Irirajia quepatsiquitica choocajianquitsica imaica itsamajavecaquea querocaca incojiaquerini igonorojia cameetsanijite iragavejacojiaqueronijite taaca inintajiaqueca, yanaajiaqueriquea tsirencacoshirentajianquitsica, teemajaca intsamajajigueroji. ");
INSERT INTO cotNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cotanquitsiquea imaica naatimpa noncantajiaquempi: inchoocajiaquegueti pashintaguecaca acaniqui ichoocajiguigueti covaeguishejiatsica pincavintsajajiaqueriquea coguitejacojianquitsica cameetsanijite inquempetacaajiaquempinijite, ariguentiquea pimetojajianaquegueti povashiantaguetanaqueroquea maasanopae pashijia irajaiavajempinijite iriatimpajia ontaniqui jenoqui tsovironaquiqui aatoca oteronquimataja. ");
INSERT INTO cotNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Quericaca quempoguijamajaqueroneca irojocajitenerigueti capichaji, inquejetacaavajemparoquea aisa irojocajiquenerigueti oshequi, inquempoguijamajatavaqueroquea irinetsanamajaquero inintacaajitaquerica. Iriraquea aatoca iquempoguijamajatiro irojocajivequenemparigueti capichaji irooca iraitsiguetavaqueri capichaji, inquejetaquempaquea aisa irinintajivetempagueti inquempoguijaqueneri oshequi, aato iquempoguijamajatirotsi irooca iraitsiguetavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cotanquitsiquea aatogueti piquempoguijamajatirotsi ajaararontsi choocaguetatsica acaniqui quepatsiqui, ¿arimpa irojocajitaquempiroquea iroomajaca caavijica anaaquero? ");
INSERT INTO cotNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ariquea oquempetacaquea aatogueti piquempoguijamajatsitiri yashintaguetacaca itsipa, irooca paitsiguetavaqueri, ¿taashia jocajempirone pashinquempameca aviatimpa? ");
INSERT INTO cotNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tee inchoocateji agavejanquitsineca irantavaetaqueneri mavite ashintaquemparica. Manaquea irisemaneguintaquempari aparo, iriraquea itsipa impintsataquempari, irooca inquemisantamajataqueri aparo, itsipaquea intsojencaneguintaqueri. Aato pagaveji pantaqueneri Aapani Irioshi inintaguetica, iroogueti pisavicaventaque pajaarantavaequempa quejetaca irooquea ashintaquempi ajaararontsi.” ");
INSERT INTO cotNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Iroompaquea irirajia pariseojia choocajianquitsica oraniqui irooquea iquemajiaquerigueti Jesoshi, ariqueate icohicoitanaca ishiroshirontimentavaecari, iriguentijiatari nintamajajiguirica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Icantsijigariquea Jesoshi: “Aviatimpajia aviguentijia peamampeajiatsica netsanamampeajiatsica irishineventajiaquempiniji caquintejia, cotanquitsiquea Aapani Irioshi yamenashirentajiaquempi. Iriatimpa teequea irishineventemparoji ishineventajiacaca caquintejia, manaquea yatsitsiimanatacaro. ");
INSERT INTO cotNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ochoocaqueni coramaniqui itioncacotanaqueca Moishishini aisa tsavetantajiatsica, arejevaetacaquea ichoocaquegueti Joancani, ariquea imaica itsavetantajitanaqueroquea Quenquetsatsarentsi Oganejencatatsica quero icotani imajirontagueti Aapani Irioshi. Icaramirincavaequequea nintamajajianquitsica iroanaque ichoocaquegueti, itampishiventamajaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Omanavaeca onteronquitsitempagueti quepatsi aisa inquite. Anaamajaquequea ompeguempagueti apaitsoquiro itioncacotanaqueca Moishishini, maasanotari onetsanamajaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Quericaca ovashianqueroneca imanquigare otsipaquea irimanquigatajempaquea, manaquea icovaeguisheca. Ariquea iquempetaca manquigatavajemparoneca manquigarentsi yovashiantajitica, manaqueate icoguisheca. ");
INSERT INTO cotNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ichoocaque aparo ajaarantatsica iquitsaamajataroquea quitsaarentsi aramampoaro ogameetsareni ocanca. Icantacoguitaniquea savincaguiteriqui ishecamajatacaquea taaca opajitapae, teequea taaca opaji incoguitejacotempaji. ");
INSERT INTO cotNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ichoocaque aisa aparo teeca irashintempaji, ipajita Irasaro. Iroguentini ishimoiriquire teetarite capichaji. Yamajiqueriquea yojoquijiqueri quepatsiqui sotomorontsiqui sotsiqui itsovironaquitequi ajaarantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yatsipevaecaroquea itase, inintavecaquea iroguijavaqueromequeate otsopequijaniqui ontanquirejaguetapoje shitaponcarontsiqui ishecatacagueti ajaarantatsica, irishecaquemparo. Icoraquecoraqueitashiqueri shiishi yaneronerovaequeriquea ishimoiriquitaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Iroompaquea imetojanaque Irasaro, iriraquea irashivantijitete Aapani Irioshi yaajianajiriquea ichoocaquegueti Averaameni. Ocoramanivaetapojajigueti imetojanajiquea ajaarantatsica, iquitajitajiriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yatsipevaetacaquea oshequi ontaniqui Areshiqui. Iroompaquea yamenacotajiriquea Averaameni osamani itsipatajariquea Irasaro. ");
INSERT INTO cotNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Icajemacotsitariquea icanqueriquea: ‘Aapanii Averaameni, pimpintsatacogajoitenashiatsi, pintigaranqueriquea Irasaro irorencachapaquitapanajantemparoquea ojaaquiniqui, incoraqueque intsincapojenaquea nonenequi, natsipevaecaquea acaniqui paamariqui.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Cotanquitsiquea Averaame icanqueriquea: ‘Irijani, pinquenquejajeroja coramaniqui tequeratagueti pimetoje, aviatimpa pishinevaeca oraniqui, teequea taaca opaji pincoguitejacotempaji. Iriraquea Irasaro yatsipevaeca icanca. Imaicaquea imaica irioqueate shinevaetajatsinequea ocaniqui, aviatimpaquea pantsipeguitempaniquea. ");
INSERT INTO cotNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aisa oquichatencanajavaecaqueate ontaniqui aviatimpaqui, taampaqueate agavejanquitsineca iroanaquequeate oraniqui. Ariquea iquempejiga choocajianquitsica oraniqui aatoquea yagavejajiga incoraquetaquequeate acaniqui, ¿querocaquea inquenaquenaiqueni?’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Yaquitsitanacaquea aisa ajaarantatsica icanqueriquea: ‘Iroosacanica imaica noninque pintigarancaqueriquea Irasaro itsovironaquitequi aapani. ");
INSERT INTO cotNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Choocajiatarite ontaniqui 5 iguentijeguijia. Intsatacajaiapojaqueriquea aatonijite icoraquecoraqueitiquea iriatimpajia aisa acaniqui irantsipevaequempaquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Icanqueriquea Averaameni: ‘Choocatarite itioncacotanaqueca Moishishini aisa tsavetantajiatsica, irooquea irampatsajavantajiaque inquemisantajiaque.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yaquitsitanajaqueate iriatimpa icanqueriquea: ‘Aato, aapani Averaame, cotanquitsiquea arigueti irogue metojatsica intsatacaajiaqueri, ariquea incantashitatijaianaquempaquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Cotanquitsiquea Averaameni icanque: ‘Aatogueti inintitsi irinetsanatashitemparo itioncacotanaqueca Moishishini aisa tsavetantajiatsica, ari inquejetacaavaquempari arigueti impochatimoteri metojatsica, aatotarite iquemisantiri.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iroompaquea icantajiguiri Jesoshi itsatacaanejia: “Ococaniquea onchoocaguiteni covaeguishetacaajiaquemparineca caquintejia, cotanquitsiquea ¡imaicashiatsi irantsipevaequempaquea quericaca covaeguishetacaaquemparineca itsipa, caaviji incatsimamajajiqueri! ");
INSERT INTO cotNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Quericaca covaeguishetacaaquemparineca aparo chaajaniquiri quejejiacarica iricajia, incatsimamajajiqueriquea oshequi. Iroquetitamequea intsatotacojiquenerimequea itsanoqui shimentapiri itononcantajitaca iroompaquea irajaitanaqueriquea impishoncajajiqueri inirojani quentijaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Inchiquiojitajate aviatimpajia. “Arigueti impeacaaguishetaquempa pigonoro taaca opajitapae, pincantomajajitsitempari. Inquemisantaquempigueti irovashiantaquerogueti ipeacaaguishetacaca pimpeacotajemparoja maasanopae, aatoquea piquenquejacaajiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Irooca aparo savincaguiteri querocagueti incoquempini irampijipijivetaquempiquea oshequi ooqueate, ooqueate, ooqueate, cotanquitsiquea inquenquejanajerogueti incantajempigueti: ‘Ariquea nococani naatimpa, imaica aatoquea noquempetimatajirotsi aisa’, iroosacanica aviatimpa pimpeacotajemparoja maasanopae, aatoquea piquenquejacaajiritsi.” ");
INSERT INTO cotNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Irirajia itigarancanejia icantajiguiri Amajirote: —Notsajiavecaquea yagavejamajati Aapani Irioshi cotanquitsiquea imaica nonintajiaquequea pitsatacaamajajiaquena naventamajatantajianaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yacanaquequea iriatimpa icantajiguiri: —Arigueti pavenquitiguemparo capichaji iragavejane Aapani Irioshi, ariquea pagavejajiaquequea pincantaquitigueroquea ocatica inchato: ‘Iintsijate pintsopajanaquempaja, poanaquequea pincatiajatapojaque inirojaniqui quentijani’, pagavejajiaqueroqueate oanaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pameneja aviatimpajia, inchoocategueti aparo pashincaca iriaquerasanoquea arejetapojajatsi ishiacoguitini piniganquitejirequi, irooca iquempoguijaquempiriquea pigaapironcaarite, ¿arimpate paavajeriquea pincantavajeri: ‘Caacatequetija, pisavicapojaje acaniqui pishecatapojajempaquea’? Aatoshinete. ");
INSERT INTO cotNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manaqueate pincantajiavajeriquea: ‘Pintiapojajenaja nosheca, pinetsanaquempaja pojocacotsitenaroquea, noshecatavaquempa, nomiravaque. Coajica nonteroncanaquerogueti, ariquea pishecatsitajempaquea aviatimpa, pimiravajequea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Iroompaquea pinteroncanajerogueti ¿arimpate pincanqueri: ‘¡Ooshia! Noshinevaecaquea namenaquempigueti pinetsanaqueroquea nocanquempica’? Aatotarite picantiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aviatimpajia pinquempejiaquempaquea, pinetsanamajajiaquerogueti maasano icantajiaquempica Aapani Irioshi, manaquea pincantajiaque: ‘Naroguentijia yashintajitaca, teequea onchoocatimateji naventacojiaquempameca, manaquea nonetsanajiaquero intati inintacaajiaquenaca ashinquenaca.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iroompaquea yoanaquequea Jesoshi Jerosarequi, yoantanacaroquea ocaraguetapojigueti Samaria aisa Garirea. ");
INSERT INTO cotNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ariquea yarejetapojacaroquea ichoocajiguigueti itsipapae, itonquivojajiavacari avejancaguetatsica icarataque 10, cotanquitsiquea teequeate inquempejiquempejiitempariji manaqueate ichoocajiaque tiijai. ");
INSERT INTO cotNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Icajemajianaquequea: —¡Jesoshii, Tsatacaantantatsica, pimpintsatacogajoitenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iquemajiaqueriguetiquea Jesoshi icantajiguiri: —Poapoaitanaquequea ponigaajiguempariquea saserorotejia. Yoayoaitanaquequea, ariquea tequeratatiraja incajaranquiguiteteji ariquea icohicoitanaca ipeaguetanajaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iroompaquea ichoocaque aparo yamenaquegueti ipeanajaqueate, icoraquetajiquea ishinevempojacariquea Aapani Irioshi inirojencaqueate icanca, icanque: —Caaviji yagavejamajatiquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iguerovempojacariquea Jesoshi itaquivopojacaquea quepatsiqui yonigaantantacaca arimajaca ishineventamajatacari. Icanqueri: —Arioteesaa —yamenajitarite yovejairi. Iriatimpa iriguenti Samariaquitica. ");
INSERT INTO cotNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Icanque Jesoshi: —¿Arimpate teequea maasano impejaiguempaji carajianquitsica 10? Jeroquea aparo coraquetajatsi. ¿Quericampate itsipajia 9 imaica? ");
INSERT INTO cotNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iricaticaquea iricatica iriguenti teeca irioquea jorio coraquetajatsica ishineventavaetapojacari Aapani Irioshi. ¿Arimpate aparo ichoocaque iriatimpa? ");
INSERT INTO cotNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iroompaquea ipitsocashitanacariquea iriatimpa icanqueriquea: —Pincatianaje poanaje. Pavempojana naatimpa, pitsaquetari nagavejaque nompejaempi, jeroqueate pipeantanajaca. ");
INSERT INTO cotNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Iriraquea pariseojia icoacojiaqueriquea Jesoshi icantiriquea: —¿Querocaqueate impariantanaquemparoca Aapani Irioshi incapiocantajiajajica impeaquempaqueate Amajiromajate acaniqui quepatsiqui? Icanque iriatimpa: —Aatoquea quericaca amenimatiroca imaica, teetarite iramenajiteroji. ");
INSERT INTO cotNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aisa aatoquea quericaca agavejatsineca incanque: ‘Jeroquea ocatica’, irooca incanque: ‘Jero ontatica.’ Jac imajirontacatarite Aapani Irioshi imaica aviatimpajiaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ariquea icantiriquea itsatacaanejia: —Aapojempaquea pinintantajiavetaquempaca pinejerome apajencaro savincaguiteri ironigaimojiaquempimeca Irijanite Caquinte, cotanquitsiquea aato pinejiro. ");
INSERT INTO cotNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Inchoocatanaquequea cantanquitsineca: ‘Jeri ocaniqui’, irooca incanque: ‘Jeri ontaniqui’, cotanquitsiquea aatoquea poapoaititsi. Incantajiavetaquempiquea: ‘Jameshiatsi’, aatoquea poguijatiritsi. ");
INSERT INTO cotNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pamenajiguiroquea careti querocaquea ococani otimemequigueti, teequea capichajaniqui ontimemecaguiteteji, maasanoquea otimemecaguitevaetanaqueroqueate. Ariquea inquempetaquempaquea Irijanite Caquinte incoraquetajegueti, maasanoquea iramenamenaitavajeriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Cotanquitsiquea iroquetitaquea irantsipevaequemparoquea taaca opajita, incatsimajitaqueriquea incantajiquequeate: ‘Teetarite irioquea agamajajiavetacaca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ariqueate incoraquetajegueti irira Irijanite Caquinte onquempetajemparoquea ichoocavetanigueti Noeni. ");
INSERT INTO cotNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ariquea iriatimpajia manaquea ishecajiaca, imirajiaca, imanquigajiaca, aisa yojocantajiaqueroquea irorijanijiate imanquigajitacaroquea, teequea intsatimajigueji irooshipoji interoncajiaquempaquea. Ariquea niganqui aapojacaquea savincaguiteri iquijantanacaca Noeni intsompoguiqui quenajarontsiqui, iroompaquea otejanaquequeate incani, amaranaquequea, anaacoguetanaqueriqueate maasanopae, iteroncajiaca yojocajajiaca. ");
INSERT INTO cotNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ariquea oquejetaca aisa ichoocavetanigueti Iroteni. Ariquea iquempejiacaquea iriatimpajia ishecajiaca imirajiaca, ivegarajiaquequea yojocantaguetaquequea, ivintyacajiaque, aisa ipeacaajiacaquea tsovironaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Cotanquitsiquea aapojacaguetiquea savincaguiteri isotoantanacaroca Iroteni Soromaqui, yasacaraashiqueriquea Aapani Irioshi paamari oconoacaroquea asopiri oquenapojiquea jenoqui inquitequi, otsiajiaqueriquea maasano Soromaquitica, oteroncamajajiaqueriquea, teetarite inchoocatimajiaje aparo. ");
INSERT INTO cotNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ariqueate onquempetajempaquea ironigaantapojajempagueti Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Oratica savincaguiteri quericaca choocatanquitsineca sotsiqui omencotapojacagueti itsovironaquitequi ovancaitoqui, choocagueti yashintaguecaca intsompogui, aatoquea yaguijitapanajanti iraaguepanajantero. ");
INSERT INTO cotNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pinquenquejajiajerojate imanquigare Iroteni aatonijite piquempejigarotsi iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quericaca teeca irininteji irantsipevenquenaquea irooca irimetojavenquenaquea, manaquea impeaquempa; cotanquitsiquea iriraquea atsipevenquenaneca irooca irimetojavenquenaquea, irioquea iriguenti incoquempaniquea inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Imaicaquea noncantajiaquempi: oraquea noncoraquepojajegueti intsipatavacaaquempa mavite irinorijajiaquempa, aparo irajaitanaque, iriraquea itsipa irojocajitanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ariquea onquempejiaquempaquea mavite manquigarentsi ontsipatavacaaquempa ontsinacaguijiaque, aparo irajaitanaque, oraquea otsipa irojocajitanaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ariquea inquempejiaquempaquea aisa mavite shirampari intsipatavacaaquempa niganquitejiqui, aparo irajaitanaque, iriraquea itsipa irojocajitanaqueri.” ");
INSERT INTO cotNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iquemajiavaquerigueti icanqueca icoacojiaqueri icantiriquea: —Nomajirote, ¿querocaquea onchoocaqueni? Icantiriquea iriatimpa: —Querocagueti irojoquijiquempani metojatsica, aritaque oraniqui intirorencashijiapojempari sheetyaoni. ");
INSERT INTO cotNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iriraquea Jesoshi ininque intsatacaajiaqueriquea iramanajiaqueri Aapani Irioshi incantacoguitempaniquea aato ipega. Iquejetacaajiacanariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Icanque: “Ichoocaque aparo jivatatsica joese teeca intsaroacaguempariji Aapani Irioshi, aisa teeca impintsatacotempariji caquinte. ");
INSERT INTO cotNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ariquea ochoocaque aisa oraniqui aparo metojacoro. Iroatimpa ocantacoguitaniquea oashipiniqueri jivatatsica ocanqueriquea: ‘Pompetacotenashiatsi, chooca catsimatashitaquenaca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Iroaqueragueti teetarite irinintavetempaji inquemisantero, cotanquitsiquea coajica iquenquejapojiroquea icanque: ‘Teetarite nontsaroacaavetempariji Aapani Irioshi aisa teequea nompintsatacotempariji caquinte, ");
INSERT INTO cotNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","cotanquitsiquea ococaniqueate ocoraquetashiquenaquea asereavaequena. Imaicaquea imaica nonquemisanqueroqueate nompetanaquemparo aatonijite asereajanatsi, nocatsimatirotsi.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iroompaquea icanque Amajirote: “Pinquemero icanqueca jivatatsica teeca incameetsateji. ");
INSERT INTO cotNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iriompaquea Aapani Irioshi caaviji irompejiaquempariquea icoguiajiaqueca amanajiguirica cantacoguitatsica. ¿Arimpate aatoquea yamitacojiguiriquea? ¿Arimpate incantapiniqueri: ‘Aatota’? ");
INSERT INTO cotNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Noncanquempiquea irompetsitempariquea taampina. Cotanquitsiquea oraquea incoraquepojajegueti irira Irijanite Caquinte, ¿ari iramenajiapojajeri acaniqui quepatsiqui tsaroventamajajigarica?” ");
INSERT INTO cotNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iroompaquea Jesoshi iquempetacaajiacariquea irirajia aventacotatsica amenajiavetanquitsica yanaajiaqueri igonorojia itsaroventajiacarigueti Aapani Irioshi, icanque: ");
INSERT INTO cotNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mavite shirampari yoayoaitanaquequea teemporoqui itsaroventantajitarica Aapani Irioshi iramanajiaqueriquea. Aparo iriguenti pariseo, iriraquea itsipa iriguenti capiocapinitinirica majirontatsica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iriraquea pariseo icatiapojacaqueate yamanamampeacariquea Aapani Irioshi icanque: ‘Irioshimajaca, noshineventamajataquempiquea oshequi, pagavejacaaquenaqueate, teetarite nonquejetempariji itsipapae, ipeacaaguishetacaqueate taaca opajitapae covaeguisherentsi, iconoacaqueate yaitsitantaguequequeate, itsipa icantatsatacotantaque manquigarentsiqui. Teequeate nonquempejiguempariji irintatica capiocapinitinirica majirontatsica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nocantacoguitani aapojajagueti 3 savincaguiteri nosanticotaquiti teequea noshecatempaji nonquenquejamajaquempiniji. Aisa nojocagaranquempiquea taaca opajitapae nashincaca iroaquerapaetica. Naaquegueti 10, nojocajempi aparo.’ ");
INSERT INTO cotNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Cotanquitsiquea iriraquea capiocapinitinirica majirontatsica imentaquipae icatiapojaca oraniqui irooshipojigueti sotomorontsi. Ipashivenca, teequea iramenimateji jenoqui inquitequi, ariguentiquea itinquitinquineguintanaca yonigaantantacaca ishimampojancavaeca, icanque: ‘¡Irioshimajaca, pimpintsatacotenashiatsi, naroguentiquea covaeguishetatsica!’ ");
INSERT INTO cotNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Imaicaquea noncamantajiaquempi iriraquea capiocapinitinirica majirontatsica imentaquipae irioquea iriguenti ishinevenca Aapani Irioshi, ariquea yoanajigueti itsovironaquitequi meshiacaquea. Cotanquitsiquea iriraquea pariseo teetari irisheteneriji, maasanotari aventacotatsica iroguipashivenqueriqueate Aapani Irioshi oncoramanivaetapojajegueti. Maasanoquea teeca iraventacotempaji caaviji iranaacaajeriqueate Aapani Irioshi oncoramanitapojajegueti.” ");
INSERT INTO cotNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iroompaquea icoraquecoraqueitaquequea itsipapae yamajiapojiniriquea Jesoshi chaajaniquiripae impamijiavaqueriniji. Iriraquea itsatacaanejia yamenajiavaquerigueti yamajiapojirigueti icantomajavaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Cotanquitsiquea Jesoshi icajemajiaqueri chaajaniquiripae, icanque: —Ariotaquetsija incoraquetetate chaajaniquiripae naatimpaqui, aatoquea pojocaavaca, ishineventajiacaritarite Aapani inquitequitica irimajirontacotaquempari quenquejajiatsica quempecarica iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iroomajaca noncantajiaquempica: quericaca nintanquitsineca impejaeri Aapani Irioshi Imajirote inquempetajempariquea chaajaniquitirajaca. Oraquea aatogueti iquempetaritsi, aatotarite iconoapojajari maasano peajiaquerica Imajirote. ");
INSERT INTO cotNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iroompaquea icoraquepoji aparo majirontatsica icanqueriquea Jesoshi: —Tsatacaantantatsica cameetsari, ¿queroquea noncoquempani cameetsanijite noncoguitempaninijite nonchoocaguiteni? ");
INSERT INTO cotNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Icanqueri Jesoshi: —¿Queroquea ococani picantantaquenaca ‘cameetsari’? Teequea inchoocateji cameetsari, aparo icoca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pitsaqueroqueate maasanopae itioncacotanaqueca Moishishini, ocanque: ‘Aatoja poashitirotsi manquigarentsi, aatoja pimetojantitsi, aatoja paitsitantitsi, aatoja pitsojeacotantimatatsi, pinquenquejacameetsatacotaquerija piri aisa piniro.’ ");
INSERT INTO cotNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iriatimpa icanqueri: —Arimajaca noquempetacaquea imaica noparianacaro nonetsanamajatanaqueroquea maasano nochaajaniquipojigueti narejevaecaro imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iquemaqueguetiquea Jesoshi icanqueriquea: —Imaica apanivani poanaquequea pojocantaguetanaqueroquea maasanopae pashintaguecaca, paantaquemparoquea imentaquipae pojocajianaqueneri coguitejacojianquitsica, pinquejetaquerogueti onchoocataje oganejencaro shinetacajaempineca ontaniqui inquitequi. Ariquea pincoraquetajeja poguijatanaquena. ");
INSERT INTO cotNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cotanquitsiquea iquemitsitaquea icanquerica ariquea icotanaca ishimampojancavaetanacaquea, iriguentitari ajaarantavaetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iriraquea Jesoshi yamenavaquerigueti ishimampojancanacagueti icanque: —¡Omanapitsamajataquempariquea ajaarantavaetatsica inquijanaque imajirontagueti Aapani Irioshi! ");
INSERT INTO cotNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","¿Arimpate iragavejaque cameyo inquijanaquequea itepoquiqui quisaatonquiri irisotoanaqueriquea antaqueronta? Aatotarite yagavejitsi. Iriompaquea ajaarantavaetatsica caaviji anaaquero omanapitsataquempari inquijanaque imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ariquea irirajia quemajiaquerica icantajigui: —Iroosacanica, ¿quericampate agavejanquitsineca iraacotacaantavaquempa? ");
INSERT INTO cotNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iriraquea Jesoshi icantiriquea: —Oraquea teeca iragavejeji caquinte, iriraquea Aapani Irioshi yagavejaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Iroompaquea icantanaque Peerero: —Nomajirote, naatimpajia novashiantaguetanaqueroquea maasanopae nashintaguecaca noguijaguijaitanaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Icanque Jesoshi: —Iroomajaca noncantajiaquempica, quericaca jocanaqueroneca itsovironaquite, irooca imanquigare, irioca iriguentijeguitepae, itsijoitepae, iriri, iriniro, irioca irijanijiate, irorijanijiate, cameetsanijite irimajirontamajaquempari Aapani Irioshi, ");
INSERT INTO cotNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ariquea irojocajiqueneriquea otsipapae acaniqui quepatsiqui, caaviji anaavaetanaquero yashintavecaca, ariquea oncoramanitapojajegueti incoguitempaniquea iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iroompaquea icajemajiaqueriquea iriatimpaqui itsatacaanejia carajianquitsica 12, icantiriquea: “Imaicaquea oajianaque Jerosarequi, onetsanaguetanaquempaquea maasanopae itioncacotaqueca tsavetantajiatsica coramaniqui itioncacojiaquerigueti Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iraacaantajiqueri irajaitanaqueriquea ichoocajiaquegueti teeca irijorijoigueji, irantanaguishevaequeriquea, incantaguishejiaqueri, inquishoquishoavaequeri. ");
INSERT INTO cotNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iroompaquea impasapasajiaqueri agompiaquitempari ariquea irimetojajiaqueri, cotanquitsiquea aapojajempagueti 3 savincaguiteri intancorejanaje.” ");
INSERT INTO cotNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cotanquitsiquea iriatimpajia teequea intsatimajigueji taaca opaji icantacotaque, teetarite inquemajigueriji. Queroquea incojiaquempani intsatantajiaquempaca, omanapitsajiacaritari. ");
INSERT INTO cotNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Irooshipojaji irarejetajemparoquea Jesoshi Jericoqui, chooca shamponcajari isavicaque ocaravoquitaquegueti yamanantaguetaque imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iquemajiavaquerigueti yavisavisaitanaquegueti oshequini caquintejia icoacotsitariquea, icanque: —¿Taaqueate opajita? ");
INSERT INTO cotNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Icamantsijitariquea icantajiqueri iriguenti coraquetapojatsi Jesoshi Nasarequitica. ");
INSERT INTO cotNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Icajemitsimajatanaca: —¡Jesoshii, Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Irirajia jivajivaitapojirica Jesoshi icantavetariquea irisanticotanaquenijite, cotanquitsiquea iriatimpa arimpaqueate icajemitsimajatanacaquea: —¡Jesoshii, Ichoviquitanaqueca Taavini, pimpintsatacotenashiatsi! ");
INSERT INTO cotNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iriraquea Jesoshi ariquea icatiapojaca icanque iramajiqueriquea. Iroompaquea yamajiqueriquea quempeji, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Taaquea pininque? Icantanaquequea iriatimpa: —Nomajirote, noninque namenanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Icanqueriquea Jesoshi: —¡Intsija pamenanajeja! Pitsaquequeate nagavejaque namenacaajempi, paventantaquenaca, irootaquequea pamenantanajaca. ");
INSERT INTO cotNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Irooqueate icantaquitiguiri ariquea icotanaja yamenanaji, ariquea yoanajiquea yoguijatanaqueri, ishineventavaetanacariquea Aapani Irioshi oshequi, icanque: —Caaviji yoganejencamajata Aapani Irioshi. Ariquea iquempejianaca maasano amenamenaitavaquerica ishineventajianacariquea Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iroompaquea yarejetapojaca Jesoshi Jericoqui icantanacaroquea ocapiocagueti tsovironaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ariquea ichoocataque oraniqui aparo ajaarantatsica ipajitaquea Saqueo. Iriguenti jivajiguirica capiocapinijiguinirica majirontatsica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iriatimpa iquemacoquerigueti Jesoshi ininquequea iramenaqueri, cotanquitsiquea querocampate incoquempani iramenaquerigueti, yomporoguijaventavaetanacariqueate itsipapae igonorojia yojocaajiaqueriquea, iriguentitarite chaamorintejaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ishiitsitanacaquea tiijacoñaji oraniqui querocagueti iroanaqueniquea Jesoshi, yataitsitanacaquea inchatoqui cameetsanijite iramenavaquerinijite. ");
INSERT INTO cotNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iroompaquea yarejetapojacarogueti Jesoshi ichoocaquegueti ipivancajanacaquea jenoqui, icanqueriquea: —Saqueo, paguijitapojequea. Aviguentiquea nomaimoque. ");
INSERT INTO cotNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Isoaanquitsipojacaquea ishinetanaca itsipatanacariquea Jesoshi itsovironaquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yamenajiavaquerigueti maasano yoanaquegueti icantimanajianaqueriquea icantavacaajianacaquea: —Querocaqueate icocani Jesoshi icantanacaquea irimaacotapojaqueriquea itsovironaquitequi covaeguishetatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oraqueate ichoocajiaquegueti itsovironaquitequi icatiitsitanacaquea Saqueo icanqueriquea Amajirote: —Iintsija pamene, Nomajirote. Maasanopae nashintaguecaca naatimpa nojocagarantajiaqueneriquea teeca irashintajiguempaji, nojocavajeneriquea niganqui. Quericaca ivegaracagueti imentaqui namatavijaquerica itsipa, imaicaquea imaica nojocajeneriquea, cotanquitsiquea nanaacaantajempariquea nojocajiajeneriquea. Ivegaracagueti aparo imentaqui namatavijaquerica, nojocajeneriquea oshequi 4. Ivegaracagueti 10, nojocajeneriquea 40. ");
INSERT INTO cotNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iriraquea Jesoshi icanqueriquea: —Imaicaquea imeshiajitiriquea choocatantajigaroca ocaniqui tsovironaquiqui, irooriji iquempetanajari Averaameni choviquitanaquerica, ariquea iquempetajariquea iriatimpa itsaroventarigueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Irootaquequea icoraquetantacaca Irijanite Caquinte, iramenaguetajateri peajiavetanquitsica iraajiajateri. ");
INSERT INTO cotNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iriraquea omporoguijavencarica Jesoshi iquemisantajiaqueriquea iquenquetsatacaaquerigueti Saqueo, itsajiaquetarite irooshipoji irarejepojaquempa Jerosarequi, iquenquejajiaquequea ijiqueji irooquea yoashitanaque impeaquempaqueate imajirojiate, ijijiaqueji irooshipoji irimajirontapojempa Aapani Irioshi ocaniqui quepatsiqui. Cotanquitsiquea iriatimpa irooriji itsaque, ariquea iquejetacaaca, ");
INSERT INTO cotNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","icanque: “Ichoocaque aparo anaantatsica, ariquea iroavaetanaquequea osamani ontaniqui otsipaqui quepatsiqui ichoocatigueti majirontamajatatsica cameetsanijite impeacaavajemparinijite irimajirontacaavajempari, aapojajempagueti incoraquetaje ichoocatigueti ari irimajirontapojempa. ");
INSERT INTO cotNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Irootapojigueti iroanaque, icajemajiaqueriquea 10 iromperarepae yashintajiacaca, yojocajianaqueneriquea maasano apashimentaquiro icantajitica mina, icantajiaqueriquea: ‘Jeri iricatica imentaqui nojocajianaquempica poganencajerija, inchiquiojitarite pamenajiaquequea aviatimpajia querocaca pincojiaquerini paantajiajempariquea itsipa, ariquea noncoraquepojajegueti namenajiapojajempiquea querocaca incarashequianaqueniquea paajiajeca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cotanquitsiquea iriraquea igonorojia teequeate irinintajigueriji, isemajiacari, itigarancajiaqueriquea itsipajia incamantajiaquiteri peacaajiaquemparineca majirontatsineca, incanqueriquea: ‘Teetarite nonintajigueji impeaquempaqueate irira nomajirojiate.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Cotanquitsiquea arimpaqueate ipeacaajicariquea majirontatsica, iroompaquea icoraquetaji ichoocatigueti. Ariquea yarejetapojaja icajemajiapojajiri irashijia yojoquimojianaqueneca imentaquitsite iramenapojajeriquea querocaca icarashequianaqueni yaajiaqueca itsipapae. ");
INSERT INTO cotNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ariquea icoraquepojiquea aparo icanqueriquea: ‘Nomajirote, iriraquea pimentaquitsite pojocanaquenaca apamentaquitiro mina icaraveca, imaica naaji itsipapae, icaravaeque 10 naajica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Icanqueriquea iriatimpa: ‘Cameetsavaequequea, nomperare, pinetsanaqueroquea ocatica capichaji nocantanaquempica. Imaicaquea nompeacaaquempija imajirojiate choocajiatsica 10 guinteninintsipaequi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ariquea icoraquepojiquea itsipa icantapojaqueri: ‘Nomajirote, iriraquea pimentaquitsite pojocanaquenaca apamentaquitiro mina icaraveca, imaicaquea naaji itsipapae, icaravaeque 5 naajica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ariquea iquejetaqueriquea iriatimpa icanqueri: ‘Imaicaquea aviatimpa nompeacaaquempija imajirojiate choocajiatsica 5 guinteninintsipaequi.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Cotanquitsiquea itsipa icoraquevetapojaca icantapojaqueri: ‘Nomajirote, jeri iricatica pimentaquitsite. Nampiguiricacotsitajimpiriquea paañoqui noquempoguijajiri. ");
INSERT INTO cotNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Notsaroacaaquempitarite namenimpiquea aviguenti catsimatantatsica, paashiguecariquea imentaquipae intati teequea taaca opajita panteji, aisa paitsitantagueque teeca pashinquempaji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Icantanaquequea iriatimpa: ‘Aviroveca amitacovetanaca, cotanquitsi tee pincameetsateji. Inchiquiojiquea piquempetacaanca aviatimpa piquenquetsataquegueti imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Queroquea ococani teequea paanaqueriquea nomentaquitsite pojocaquenerime vegaratantatsica iraantajemparinijite itsipapae, iroompaquea pojocavajenarimequeate nocoraquevetajagueti imaica. Irooquea pamenanagueti naroguenti catsimatantatsica, naashiguecariqueate imentaquipae intati teequea taaca opajita nanteji, aisa naitsitantagueque teeca nashintempaji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iroompaquea icantajiguiri choocajianquitsica oraniqui: ‘Paapitsateriquetiro iricatica nomentaquitsite pojocajigueneriquea oganencajirica 10.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Cotanquitsiquea iriatimpajia icantiriquea: ‘Nomajirote choocatarite irashi 10.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yacanaquequeate iriatimpa icanque: ‘Noncanquempiquea quericaca aamajatanquitsica, caaviji irojocamajajitaqueneri, cotanquitsiquea iriraquea teeca irashintempajiquea, capichajaniquiquea yashincaca iraacaitsijiquempariqueate. ");
INSERT INTO cotNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Imaicaquea imaica irirajia catsimajiaquenaca teeca irinintajigueji nompeaquempaquea imajirojiate, pamajiaqueriquea ocaniqui pimetojajiaqueri.’ ” ");
INSERT INTO cotNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Coajica iteroncanaquerogueti Jesoshi iquenquetsavaetaquegueti iparianajaro iroanaquequea Jerosarequi, iriquetitaquea oananquitsi. Yagatsonquivaetanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iroompaquea irooshipojigueti irarejerejeitajempaquea Vetepajequi aisa Vetaniaqui irooshirooshitacotacaroquea Orivotsempi, itigarancaquequea mavite itsatacaane, icantajiavaqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Poanaquequea ontaniqui quempeji guinteninintsiqui, ariquea pamenajiapojeri oraniqui aparo aashino irijanigantirenajaniqui ishiticacojiqueca, tequerataqueate irishiashiavijitacotantajitempariji. Pishiticarejacojiaqueri pamajiaquenari. ");
INSERT INTO cotNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Choocagueti cantajiaquempineca: ‘¿Taaquea pishiticarejacotantacarica?’ aviatimpajia pincantajigueri: ‘Iriguenti coacotacari Amajirote.’ ");
INSERT INTO cotNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yoayoaitanaquequea ariquea yamenajiapojiri shiticacoca. ");
INSERT INTO cotNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Irooquea ishiticarejacojianaquerigueti icantajiguiriquea ashintajigarica: —¿Taaquea pishiticarejacotantacarica aashinogantirenajaniqui? ");
INSERT INTO cotNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iriatimpajia icantiriquea: —Iriguenti nintaqueri Amajirote. ");
INSERT INTO cotNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iroompaquea yaajianaqueriquea yamajiaqueneriquea Jesoshi. Isavomititsajiaqueriquea iitsaarepaequi cameetsanijite irisavicaquenijite. Ariquea yatsomajajiaqueriquea yoguisavicajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ariquea ishiacotanaca yoanaquequea. Irirajia omporoguijaventajiavacarica imaroncaashijiavaqueriquea iitsaarepaequi quenavoquirontsiqui ishivoquitantanacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oraquea irooshipojigueti oguirincacagueti Orivotsempiqui maasanopae quemisantajiaquerica isaquiriaventajianacariquea, ishinejianaca icanca, iririjencani yoanaquero ishineventajianacari Aapani Irioshi iroorijite iquenquejanaqueroquea yonigaantaguequeca Jesoshi oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Icantajigui: —¡Intsishiatsi irishineventajiquempari Amajirote coraquetapojatsica itigarancaqueca Majirontamajatatsica! —¡Oganejencaguitevaeca inquitequi! ¡Caaviji yoganejencamajataca Aapani Irioshi choocatatsica jenoqui! ");
INSERT INTO cotNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iroompaquea iconoagarancaqueate pariseojia choocajianquitsica oraniqui icantiriquea Jesoshi: —Tsatacaantantatsica, pincantomajeritsijate guijatacojiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Cotanquitsiquea Jesoshi icantiriquea: —Noncanquempiquea, arigueti irimajerejigue irirajia, irooqueate cajemajiananquitsineca mapi oshineventajianaquenaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iroompaquea yaapojaquerogueti quempeji yamenacopojiroquea Jerosare, iraacotsijigari choocatantajigaroca, ");
INSERT INTO cotNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","icanque: “¡Imaicaquea imaica choocatirajanagueti ocaniqui nonintaveca pintsajigueme quero pincojiaquempani aatonijite icatsimajiguimpitsi Aapani Irioshi! Cotanquitsiquea imaicatari omanapitsajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aapojajempagueti oncoramanitapojajegueti pantsipevaejiaquempaquea, incoraquecoraqueitashijiaquempiquea catsimajiaquempineca iranquitacojiapojaquempi intantotacojiapojaquempi irashimirintsitempiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Irampeguitejajiaqueroqueate maasanopae mapi ipeacaantajicaroca piguintenitantajiacaca, irimetojajiaquempiquea. Ontariavaetanaquempaquea isavi, aatoquea ogataavitajatsi apapiro. Onquejetaquempaquea irooriji aavepojaca icoraquetantaquitacaca Aapani Irioshi incavintsajajiaquitempimequea, cotanquitsiquea aviatimpajia teequea pintsajiavaqueroji.” ");
INSERT INTO cotNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iroompaquea yoanaquequea Jesoshi teemporoqui itsaroventantajitarica Aapani Irioshi iquijavepojacaro oniganquirequi oticaacoroqui, yamenajiapojiri jocantantajiaquequea, yoguivorocajiapojiriquea, ");
INSERT INTO cotNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","icantiriquea: —¿Arimpate tee ontionquempaji: ‘Oratica notsovironaquite incantacojitero iroguenti ashi incoraquetantapinijitempaca iramanajiaquenaniji’? Cotanquitsiquea aviatimpajia manaquea pipeacajaiacaro imoro itsititantaca aitsitantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ariquea icantacoguitani savincaguiteriqui itsatacaantaguitiniquea Jesoshi teemporoqui. Cotanquitsiquea irirajia saserorotejia anaantajianquitsica, irirajia tsatacaantajiguiroca itioncacotanaqueca Moishishini, aisa jivajiguirica caquintejia inintajiaveca irimetojacaanquerime. ");
INSERT INTO cotNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Cotanquitsiquea teequea iragavejajigueji querocampate incojiaquerini, maasanojia ishineventajiacariquea iquemisantajiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ariqueate itsatacaantavaequequea Jesoshi oniganquirequi teemporo, itsavetacotaquero Quenquetsatsarentsi Oganejencatatsica. Iroompaquea icoraquecoraqueipojiquea saserorotejia anaantajianquitsica, itsipatsipaicariquea tsatacaantajiguiroca itioncacotanaqueca Moishishini, icoraquejiaquequea aisa jivajiatsica, ");
INSERT INTO cotNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","icantajiapojaqueri: —Iintsija pincamantenajate. ¿Taaqueate cantaquempi pinquejetacaaqueroquea imaica poguivorocajiaqueriquea jocantantajiguirica viratsipae? ¿Taaquea tigarancaquempi? ");
INSERT INTO cotNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iriraquea Jesoshi icantiriquea: —Ochoocaque noncoacojiaquempica naatimpa. Iintsija pincamantajiguenaja: ");
INSERT INTO cotNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iviñacajatantigueti Joancani, ¿queroquea oquenapojini? ¿Irooca oquenantapojaca inquite? ¿Irioca oquenantapojaca caquintejia? ");
INSERT INTO cotNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Irooquea iquemajiavaquegueti iquenquetsatavacaajianaca icantajianaque: “¿Querote ancoterini? Ancantsivetemparigueti oquenantapojaca inquite, iriatimpa incantanaque: ‘Iroosacanica ¿queroquea ococani teeca pinquemisantantajiguempariji?’ ");
INSERT INTO cotNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Arigueticaja ancantajiavequempariquea iriguenti tigarancaqueri caquintejia, intsinatsinavaetacaji maasano omporoguijajianquitsica, maasanotari icantajiaque irira Joancani iriguenti tsavetantatsica itigarancaqueca Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jero icantantajiacaca: —Jmm, taaca tigarancaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ariquea iriatimpa icantiriquea: —Iroosacanica, ariqueate nonquejetaquempaquea naatimpa, aatoquea nocamantimpitsi quericaca tigarancaquenaca naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ariqueate iparianacaroquea Jesoshi iquenquetsatacaajianaqueriquea maasano, cotanquitsiquea manaquea iquejetacaajiacanari, icantiriquea: —Ichoocaque aparo caquinte imiashiaqueroquea ovaitsoqui itsitacancaroquea apamantanejiro iniganquitejire, iroguenti igomaroncaaque. Coajica icajemajiaqueriquea itsipapae irishiacojiaqueneriquea. Oraquea onchoocatanaquegueti, irojocagarantajiaqueneriquea iriatimpa. Iroompaquea yoavaetanaquequea osamani, ichoocaguitini ontaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ocoramanivaetapojigueti aapojajagueti osamparipiotantanacaca ovaitsoqui, itigarancavecariquea aparo itigaranquica iramanajiajateriquea irojocagarantajiajenerime iriatimpa, cotanquitsiquea iriatimpajia itavatavaajiavaqueriquea itigarancajiajiri intati, teequea irojocajiavajeneriji capichajaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iroompaquea iriraquea ashincaroca itigarancajiquea itsipa yashincaca. Ariquea iquejejiavaqueriquea iriatimpa, itavatavaajiavaqueriquea, icaveaqueri, itigarancajiri intati ejempaconi. ");
INSERT INTO cotNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ariquea itigaranquitsitajariquea aisa itsipa, cotanquitsiquea iquitenteatantavacariquea ipishoncaquitiri. ");
INSERT INTO cotNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Iroompaquea icantsitaquea ashincaroca iguepatsite icanque: ‘¿Querocaquea noncojiaquerini imaica? Iintsija iriompate iriguenti nontigarancaquequea irijani nopintsamajatacaca, iriocaqueate intsaroacaajiaquempaquea.’ ");
INSERT INTO cotNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Cotanquitsiquea iriatimpajia irooquea yamenajiavaquerigueti icoraquepojaquegueti iquenquetsatavacaajianaca icantajianaquequea: ‘Jeeri irintatica ashinquemparoneca maasanopae irimetojanajegueti iriri. Jamequetiroshiatsi ametojajiaqueriquea cameetsanijite aatimpajia ashintamajatajemparonijite.’ ");
INSERT INTO cotNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ariquea yaitsijianacari yaajianaqueri acaqueroca otantotacotacagueti ovaitsoquimashi, imetojitsitari. “¿Imaicaquea querocaquea incojiaquerini ashincaroca iguepatsite? ");
INSERT INTO cotNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Manaqueate iroashijiaquiteriquea irimetojajiaquiteri, itsipapae incajemajiaquequea quempoguijajenerineca iniganquitejire.” Iquemajiavaquerigueti icanqueca icantsijigariquea: —¡Oo, aatoquea! ");
INSERT INTO cotNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Cotanquitsiquea Jesoshi yamenajiaqueriquea icanque: —Iroosacanica, ¿taaquea ocantacoque Itioncacaantaqueca Aapani Irioshi ocanquegueti ocatica?: ‘Oraquea ogota mapi teeca irishineventajiavetempaji peacaajiacaroca mapipanco, opeanacaquea anaantamajatanquitsica quishotacaaqueroca.’ ");
INSERT INTO cotNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Quericaca omposaquemparoneca ocatica mapi incampojemparo jarare jarare, cotanquitsiquea quericaca ontsinacaqueca ompitsarepitsarejatanaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ariquea irirajia saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini irooquea iquemajiaquerigueti icanquegueti Jesoshi icatsimatsijianacaquea, inintajiaveca irajaianaquerime, iquemajiavaqueriqueate iriguentijia iquejetacaajiacaquea, cotanquitsiquea itsaroacaajiacari omporoguijajianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ariquea itigarancajiaqueriquea itsipapae iroaroaitanaque impeamampeajiaquempaquea arimajacaca inintamajajiaque intsajiaquequea, incoacojiaqueriquea Jesoshi iramenajiaqueri querocaca incanque, iroompaquea incanquerogueti taaca opajita, irooquea iroguinajiaquempaquea irajaianaqueneri iramajirore Sesa incatsimatacaantaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Irootaquequea icoacotantacarica icanqueri: —Tsatacaantantatsica, notsajiaquempiquea aviatimpa teetarite pamataguempajiquea, pitsatacaantaquegueti teequea quericaca pagamajempaquea, teequea pincanteji: ‘Inchiquiojitaja iquemajiguitsi itsipapae.’ Pitsatacaantigueti tampaticaquea poaquero picamanquerigueti queroquea incojiaquempani irinetsanajigueroniji inintaguetica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pitsatiroqueate icanqueca majirontatsica Sesa icanquegueti maasanojia jorio irojocagarantapinijiaqueneri imentaquipae. Imaicaquea ¿queroca pincanteni? ¿Cameetsampa nojocajiaqueneri, aricaca tee oncameetsateji? ");
INSERT INTO cotNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Cotanquitsiquea Jesoshi itsatavaqueroquea teequea cameetsa incantajigueji, manaquea ishinetamampeajiacaqueate intati, irootari icantantajiacarica: ");
INSERT INTO cotNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Iintsijate pamaquenarija apamentaquiro tenario, nameneritate. ¿Taa ipajita iricatica ivaantorijiqueca? ¿Taaquea ashintaro ivajiro tioncanquitsica? Icantiriquea: —Iriguenti majirontatsica Sesa. ");
INSERT INTO cotNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iroompaquea icanque iriatimpa: —Iroosacanica, pojocajiajenerijate Sesa yashincaca iriatimpa pinetsanatimenqueroniji icanqueca, aisa pinquejetacaajiaquempariquea Aapani Irioshi, pinetsanamajajiaqueroja maasanopae icantaguequeca. ");
INSERT INTO cotNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Teequea iragavejajigueji incomitsatacaguempariji. Icocani iquemajiaquerigueti maasano tampatica inetsanaquero. Ariqueate yamenamenaitanaquequea intati coacojiavecarica, yamenajiaqueriquea itsamajati, ariquea isanticosanticoitanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iroompaquea irioquea oahoaitananquitsica saroseojia iramenajiaquiteriquea Jesoshi. Iriatimpajia iriguentiquea cantajiatsica aatoquea itancorejajianaji metojajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Icantantajiapojacarica: —Tsatacaantantatsica, iriraquea Moishishini itioncanaque coramani paperiqui icanque inchoocaquegueti caquinte teeca irijanintempaji, aapojempagueti irimetojanaquegueti irojocapanajantero imanquigare, choocagueti iriguentijeguite irioquea manquigatajemparone irijanintacajaemparoquea quejetaja irioca irijanintajari metojanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Coramani ichoocaque aparo nogonoro irijanintacaquea 7. Iriraquea parianquitsica imanquigavetacaroquea manquigarentsi, cotanquitsiquea niganquiquea imetojaque teequea irijanintacaguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iroompaquea irioquea manquigavetajaro itsipa oguijatirica. Ariquea iquejetajaquea iriatimpa imetojanaji, teequea irijanintacaguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ariquea iquejetacaquea itsipa niganquitatsica, arimpate iteroncanacaquea maasano imanquigajiavetacarogueti, teequea irijanintacajaiguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ariquea ometojitsitanaca iroatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Imaica, iintsija pincantajiguenaja, oraquea oncoramanitapojajegueti intancoretancoreitanajegueti maasano metojajiavetanquitsica, ¿quericaca manquigamajatajemparoneca? Maasanotari imanquigajiavecaroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Icanqueriquea Jesoshi: —Imaicaquea imaica acaniqui imanquigajiaca shiramparijia, ariquea oquempetaca manquigarentsi yojocantajitiro irimanquigajitemparo. ");
INSERT INTO cotNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cotanquitsiquea irirajia ishetacojiqueca intancoretancoreitanajegueti oncoramanitapojajegueti, iroaroaitanaquegueti ichoocatigueti Aapani Irioshi, aatoquea quericaca manquigatajatsineca, aisa manquigarentsi aatoquea yojocantajitajirotsi irimanquigajitajemparo. ");
INSERT INTO cotNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aatotarite imetojimajiajitsi, jac tancoretancoreitanajitarite. Manaquea inquempejiajempari irashivantijitete Aapani Irioshi, aisa inquempejiajempari Aapani Irioshi teetarite iramenimateroji imetojane, jac ipeajiaqueri irijanijiate. ");
INSERT INTO cotNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Quejetacaquea itioncanaqueca Moishishini coramani itioncacotaqueroquea iquenquetsataquegueti Aapani Irioshi maequitatsicaqui, icanque: ‘Naroguenti Irioshimajate Averaame, Ishaaco aisa Jacovo.’ Irootaquequea itsatantajitacariquea Moishishini itsaquequea intancoretancoreitanaje metojajiavetanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Teequea irio Irioshite metojatsica, iriguentiquea Irioshite anijatsica. Aviatimpajia pamenajiavecari metojaque, cotanquitsiquea iriatimpa yamenaqueri maasano icocani yaniji. ");
INSERT INTO cotNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iroompaquea iconoagarantajiaca tsatacaantajiguiroca itioncacotanaqueca Moishishini icanqueri: —Tsatacaantantatsica, pitampaticamajataqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ariquea icarajianajiquea maasanojia teequea incoacojiajeriji otsipapae, yamenaqueriqueate teequea iragavejajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iroompaquea icanque Jesoshi: —¿Querocaquea ococani icantantajitacaca: ‘Iriraquea Quirishitotatsica iriguenti ichoviquini Taavini’? ");
INSERT INTO cotNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iriotaquequea cantanquitsica Taavini iriatimpa coramani itioncaquerogueti paperiqui pajitatsica Saremo, icanque: ‘Iriraquea Majirontatsica Aapani Irioshi icanqueri Nomajirote: Pisaviquetaja pisenampijaquenaja notincamijempequiqui, ");
INSERT INTO cotNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pintsipataquenaquea arejevaetanaquempa nagavejajiaquerigueti maasano catsimajiaquempica, onquejevequemparo povanquegontatsitempari.’ ");
INSERT INTO cotNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Iriraquea Taavini iriotaquequea cantaquerica: ‘Nomajirote’, ¿querocaca incoquempani inchoviquitanaqueri? ");
INSERT INTO cotNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maasano iquemisantajiaqueriquea Jesoshi icantajiaquerigueti itsatacaane, icanque: ");
INSERT INTO cotNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Inchiquiojitaja poguijaguijaitacotiritsijate tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iroguenti ishineventajiaca inquitsaajerontajiaquemparo ontiasearo cameetsanijite irisemeque. Aisa yoayoaitapinique ontaniqui yojocantajiguetirogueti taaca opajitapae ajaararontsipae inintajiaque inquenquetsatacaajitavaqueriquea. Icoguitani yoapinijiguigueti shinagogaqui icapiocantapinijiacaca, inintajiaquequea iroguisavicajitavaqueri intsipatsipaipojempariquea anaantajiatsica. Ariquea iquejejiacaquea aisa icapiocajiacagueti irishecajiaquempaquea, inintajiaque iroguisavicajitavaqueriquea intsipatacaantajiquempariquea anaantajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aisa yamatavimatavivaetaqueroquea metojacoropae iteroncamajatsitaqueroquea ashintaguecaca. Aisa yamanamampeajiacariquea Aapani Irioshi teetaquea irisanticotsitempaji, isemejiaque intati. Iriatimpajia caaviji iranaajiaque incatsimamajajitaqueri oncoramanitapojajegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ariqueate ichoocaque Jesoshi oraniqui teemporoqui ochoocaquegueti itetantajitarica imentaquipae yojocajiquenerica Aapani Irioshi. Iriatimpa yamenajiavaqueriquea ashintavaejiatsica yojocajiaquequeate imentaquitsite. ");
INSERT INTO cotNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iroompaquea yameniroquea aparo metojacoro, teetarite ashintempaji, otetsitariquea iroatimpa mavimentaquitejaniqui omentaquitsite. ");
INSERT INTO cotNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ariquea icanque: —Arimajaca ocatica metojacoro teeca ashintempaji yamenaqueroquea Aapani Irioshi otepojiri oshequi, anaitajiaqueri maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iriatimpajia yaagarantavajiri imentaquitsite, yashintavaevetacatari, cotanquitsiquea iroatimpa teeca ashintamajavetempaji manaquea aacaajaniquicari maasano ashincaca ovegaratantajempameca osheca. ");
INSERT INTO cotNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iconoagarancaquea iquenquetsaventajiaqueroquea teemporo itsaroventantajitarica Aapani Irioshi, yamenajiaqueroquea cameetsavaequequea ocanca. Ipeacaantajitaroquea mapi ogameetsareni. Aisa yojoquijitantajiguecaroquea otsipapae taaca opajitapae cameetsaguetatsica yojocajiguequenerica Aapani Irioshi. Iroompaquea icanque Jesoshi: ");
INSERT INTO cotNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ocaticaquea pamenajianaqueca imaica, ariquea arejetapojajempagueti savincaguiteri aatoquea ochoocatajitsi aparo mapi ogataajatsineca, maasanopae irisoveacomajajitaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iroompaquea icantajiguiri: —Tsatacaantantatsica, ¿querocate oncarateni irisovejaiqueroni? ¿Taa opaji nontsatantajiavaquemparoca? ");
INSERT INTO cotNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Icanque Jesoshi: “Shoshoh yamatavijajitimpitsija. Incoraquecoraqueitanaquetari oshequini pinajajiaquenaneca cantajianquitsineca: ‘Naroguenti.’ Itsipa incanque: ‘Irooshipoji aguempa.’ Cotanquitsiquea aviatimpajia aatoquea piquemisantajiguiritsijate. ");
INSERT INTO cotNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Iroompaquea pinquemacojiaqueriquea itsipapae irashimirintavacaajiaquempa. Itsipapae iroguisotoitsijiguempari imajirojiate. Cotanquitsiquea aatoquea pitsaroajiguitsi. Ariqueate onquempeguetanaquempaquea imaica, cotanquitsiquea aatota aitsita onteroncantaguetanajempaca quepatsi.” ");
INSERT INTO cotNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iroompaquea icantiriquea aisa: “Irirajia guintenijianquitsica otsipapaequi quepatsi iroaroaitashijianaqueriquea choocajiatsica osamanipaequitica, ariquea irashimirintavacaajiaquempa. Ariquea inquempejiaquempaquea majirontajiatsica inchoocagarantajiaque intigarancajiaqueri igoaretajiate iroaroaitashijianaqueriquea itsipapae majirontatsica irashimirintavacaajiaquempaquea irimetojavacaajiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Omoguecaguetanaquempaquea oshequi ooshiatsi. Irantsipevaejitaquemparoquea tasetsijencapae. Osotoajencavaetanaquequea ashinoncajarentsi, oncantashitatiajencavaetanaquempaquea oshequi querocagueti osotoajencaguetanaqueni. Iramenajitaquero caarica yamenajiti poneanquitsica inquitequi oncantashitatiaguitetanaquempa oncanquempa, omintsaroajianaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Cotanquitsiquea aatotaquea oquejeta imaica, aviquetijiaca incatsimajiaque irantsipetacaavaejiaquempiquea. Iraajianaquempiquea shinagogapaequi icapiocantapinijiacaca, incatsimatsijiguempi irisantanatacotacaantajiaquempiquea. Aisa iramenajiaquempigueti pitsaroventajiaquena irajaianaquempiquea ichoocaquegueti majirontajiatsica aisa jivajiatsica cameetsaniji incatsimatimentajiaquempiroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inquempejiaquempigueti imaica irajaianaquempigueti querocagueti oraniqui, ariquea pintsavetacojianaquenaqueate naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Cotanquitsiquea aatoquea piquenquejajiguiroquea pincantajigue: ‘¿Querocaca noncanqueca nompetanaquempagueti coajica irajaianaquenagueti incatsimajiaquenagueti?’ ");
INSERT INTO cotNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naroguenti quenquejacaajiaquempironeca cameetsanijite pintsajiaquenijite querocaca pincanqueca aatonijite yagavejitajiguimpirotsi, manaquea incatsimatashijiaquempiquea intati. ");
INSERT INTO cotNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cotanquitsiquea aviatimpajia pinconoagaranquempaquea iraacaantajiaquempi, inquejetsijianaquempiquea irijanintajiguimpica, piguentijeguijiate, pijiguetica aisa pitsipavijijiaca, pinconoagarantajiaquempa irimetojacaantajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Maasanopae irisemimentajiaquempiroquea novajiro pitsaroventajiaquenagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Arigueti irimetojaquempi, aatoquea opegatsi apamaero pimajeaniqui piguitoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pantsipevaetaquempagueti maasanopae ocatica, aatoquea povashiantajiguirotsi pitsaroventajiaquenagueti, pinquejetaquerogueti imaica pincoguitempani panijaguiteni jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Iroompaquea pamenajiavaquerogueti Jerosare iranquijatacojiapojajemparoquea coaretajia, irooquea pintsatantajiavaquempa irooshipoji onteroncaguetanaquempa maasanopae tsovironaquipae, irisoveajiaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Irirajia choocajianquitsineca Joreaqui irishiashiaitanaquetaja otsempipaequi. Irirajia choocajianquitsineca Jerosarequi irishiashiaitapanajantetaja osamani. Ariquea inquempejiaquempaquea choocajianquitsineca niganquitejiqui inchiquiojitaja yoayoaitapanajantitsija Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Inquejetaquempaja irooriji aapojaca incatsimatantajiaquemparica Aapani Irioshi, onetsanamajatanaquempaquea itioncacaanqueca paesatoniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ooshiatsi manquigarentsijia tsaraquijianquitsineca, aisa atsomijianquitsineca caaviji antsipemajajiaquempaquea, irantsipevaejiaquempatarite maasanojia choocajiatsica ocaniqui, incatsimamajajiqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Inconoagarantajiaquempaquea irimetojantajiquempari tsaampitsantsameniro. Itsipapae iraashijitanaquempari quepatsipaequi osamaniguetatsica. Iriatimpajia teeca irijorijoigueji quenaquenaitapojatsineca osamani iragavejantajiapojaque Jerosarequi irarejetacovaetapojemparo aapojempagueti incantantaquempaca Aapani Irioshi: ‘Imaicaquea ariotapojaque.’ ");
INSERT INTO cotNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ariqueate incantashitatijaianaquempaquea inquitepaequitica: irira catsirincaiteri, taai, impoquiropae. Iramenajitavaqueroquea teeca iramenajiteji coramani intsatantajitaquemparoca irooshipoji. Maasanopae choocajiatsica acaniqui quepatsiqui ariqueate incohincoitanaquempaquea intsaroamajajianaque inquemajiavaquerogueti ampenejencavaetanaquempaquea inirojani quentijani, ontamacoseajavaetanaquempaquea ochonquiinaja sooooo tsacon tsacon. Irishoshoguitejianaquempa caquinteguetatsica incantajianaquequea: ‘¡Imaicashiatsi querocampate oahoaitanaqueni!’ ");
INSERT INTO cotNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Caaviji intsaroamajajianaquequea, ojatacotacaaquiteri itsarore inquenquejacojianaquerogueti querocaca oncopojaquempani acaniqui quepatsiqui. Irimoguecanaquequea choocaguetanquitsica jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iroompaquea iramenajitavaqueriquea irira Irijanite Caquinte incoraquetapojajegueti inquenantapojajemparo mararo, iragavejavaetapojempa iranaajiaqueriquea maasano, iroganejencavaetapojempa. ");
INSERT INTO cotNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oraqueate pamenajiavajerogueti onquempetapojajempagueti imaica, pishinejianaquempaja, irooshipojitarite iraajiavajempi Aapani Irioshi patsipevaecagueti.” ");
INSERT INTO cotNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ariqueate iquempetacaacaroquea iguera, icanque: “Pamenajiguirogueti iguera irooca otsipapae inchato, ");
INSERT INTO cotNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ochoocatanajigueti ovana irooquea pitsatantajiavajaro irooshipojaji ajagantsitapojaje. ");
INSERT INTO cotNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ariquea onquempetanaquempaquea oncoramanitapojajegueti pamenajiavajerogueti onquempetanajempagueti notsatacajaianaquempica imaica, irooquea pintsatantajiavajempa irooshipoji irimajirontaquempa Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Arimajaca noncantajiaquempica, maasanopae ocatica nocantajiaquempica imaica onetsanamajatanaquempaquea tequeratagueti interoncajiguempaji maasano choocajianquitsineca omparianaquempagueti notsavetantsitacaca imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Oraquea inquite aisa quepatsi ompeaquempa, cotanquitsiquea oraquea nocantaguequeca aato opegatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Aviatimpajia inchiquiojitaja pisavicaventirotsijate taaca opajitapae covaeguisherentsipae, pishinquitatsija, pishoshoventajigarotsija taaca opajitapae. Pinquempejiaquempagueti imaica aatoquea pagavejajiguitsi pinquenquejajiaqueri irira Irijanite Caquinte incoraquetaje, iroompaquea manaquea incomirejajiapojajempiquea. ");
INSERT INTO cotNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Manaquea onquempetaquemparo ivaracajitigueti, teequea intsatsitapojemparoji. Ariqueate onquempetaquempaquea oncoramanitapojajegueti incoraquetapojajegueti irira Irijanite Caquinte, aatoquea itsatsijiga choocajiatsica acaniqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cotanquitsiquea aviatimpajia pincoquempanija poguijavajerija, aisa pincoquempanija pamanaguiterini Aapani Irioshi cameetsanijite pintampishitashiqueroniji maasanopae ocatica notsatacajaiaquempica imaica, aisa cameetsanijite pincatintiitimotaqueriniji Irijanite Caquinte incoraquetapojajegueti.” ");
INSERT INTO cotNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ariquea iquejetaqueroquea imaica icantacoguitani savincaguiteriqui itsatacaantaguitini teemporoqui itsaroventantajitarica Aapani Irioshi. Oraquea pitsecariqui manaqueate yoapiniquequea otsempiqui ipajijitica Orivotsempi. ");
INSERT INTO cotNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Icantacoguitaniquea pitsecaguitetirajagueti icoraquecoraqueipojaque maasano teemporoqui inquemisantajiaquerinijite intsavetantavaetaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Irooshipoji arejetempa savincaguiteri icantajitica Paashicoa ishecatantajitaroca pan teeca onconoguemparoji anempoacaguiroca. ");
INSERT INTO cotNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iriraquea saserorotejia anaantajianquitsica itsipajiacari tsatacaantajiguiroca itioncacotanaqueca Moishishini arimpaqueate iquenquejajianaque queroquea incoquempani iraacaanquerinijite Jesoshi irimetojacaantajiaquerinijite, cotanquitsiquea querocampaquea incojiaquerini, itsaroacaajiacariquea maasano omporoguijaventajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ariquea iriraquea Satanashi icoraquetashipojiri ishaquiapojacari Jorashi pajitatsica Ishicariote. Irioveca itsatacaane Jesoshi carajianquitsica 12. ");
INSERT INTO cotNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ariquea yoanaque inquenquetsatacaajigueri saserorotejia anaantajianquitsica aisa imajirojiate coaretajia quempoguijajiguiroca teemporo itsaroventantajitarica Aapani Irioshi. Ariquea itsipajiapojacari iquenquetsatavacaaca quero incoquempani Jorashi iraacaanquerinijite Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iquemajiavaquerigueti ishinejianaca, icanqueriquea irojocajiaqueneri imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iriatimpa ishinevaetanaca, ariquea yamenaguetanaque aatogueti ichoocajigui omporoguijavencarica, ariquea iraacaantsitempari. ");
INSERT INTO cotNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iroompaquea aapojacaquea savincaguiteri ishecatantajitaroca pan teeca onconoguemparoji anempoacaanaqueroneca, aisa ijitorejantajitarica ovejajaniqui ishecajitacaca iquenquejacojiguirogueti Paashicoa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iriraquea Jesoshi itigarancaqueriquea Peerero aisa Joanca icantavaqueri: —Poapoaitanaquequea pinetsanajiavaqueroquea maasanopae cameetsanijite ashecajiaquempanijite coajica anquenquejacojiajerogueti Paashicoa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Icantiriquea iriatimpajia: —¿Quero nonetsanajiaqueroni? ");
INSERT INTO cotNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Icanque Jesoshi: —Poapoaitanaquequea Jerosarequi, ariquea parejejiapojempagueti pintonquivojavaquempari aparo shirampari iramacopojaquerogueti ijatsite, irioquea poguijaguijaitanaque. Poapoaitanaque tsovironaquiqui querocagueti inquijapojeni. ");
INSERT INTO cotNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pincantajiapojerija ashincaroca itsovironaquite: ‘Iriraquea Tsatacaantantatsica icanque: ¿Querocaca oraniqui noshecajiaquempani coajica nontsipatsipaiquempari notsatacaanejia nonquenquejacojiaqueroquea Paashicoa?’ ");
INSERT INTO cotNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iriatimpa intsipatsipaitanaquempiquea oshitamencoacagueti jenoqui, irijicoguequempiroquea otantotacagueti caguitejeguinica, jac netsanaguecaquea maasanopae. Ariquea oraniqui pinetsanaguetaqueroquea maasanopae ashecajiaquempagueti coajica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iroompaquea yoayoaitanajiquea, ariquea yamenajiapojiroquea maasano quejemajataca icantajiavaquerica Jesoshi incajaranqui, ariquea oquejetaca. Ariquea oraniqui ipeacajaiacaro maasanopae irishecajiaquempaca irishineventajiaquemparoniji Paashicoa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ariquea opitsecaguitetanaquegueti icoraquepojaque Jesoshi itsipatsipaitanacariquea itigarancanejia, ipimerequijajiapojaca shitaponcarontsiqui irishecajiaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iroompaquea icanque Jesoshi: —Imaicaquea arejetapojaca ocatica Paashicoa nonintamajatantacaca nontsipatsipaitaquempi noshecatacaajiaquempiquea ashineventajiaquemparo tequeratagueti arejetempaji nantsipevaetaquempagueti nometojaque. ");
INSERT INTO cotNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Noncamantaquempitarite aatoquea noshecatantajarotsi, ariguenti noshecatajemparo onetsanamajatanaquempagueti ocatica maasanopae ocantacoqueca Paashicoa oncoramanitapojajegueti irimajirontaquempagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iroompaquea incajaranquiguitetanaquegueti yaacoquero chovintyoriqui, yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea yojocacojiaqueneriquea itigarancanejia icantiriquea: —Paajiavaquero pimiramiraitavaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Noncanquempitari aatoquea nomirajaro vinoja arejevaetapojempa nomirajemparo impeaquempagueti Aapani Irioshi Imajirojiate maasano. ");
INSERT INTO cotNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iroompaquea yaitsitaroquea pan, yamanajiri aisa Aapani Irioshi, icantaqueri: “Arioteesaa.” Ariquea icotarejitsitaroquea yojocajiaqueneri, icantiriquea: —Iroguenti notsino metojaventajiaquempineca. Pinquempepinijiaquempaquea imaica, pishecajiaquemparoja pinquenquejacojiaquenajate naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iroompaquea ariquea iquejetacaacaroquea otsipatacoro vinoja iteroncajianaquerogueti ishecajiacagueti, yaacotsitaroquea icantiriquea: —Ocatica vinoja iroguenti noriraja sotojaatashiquempineca. Ocantacoqueroquea iroaqueraro paaquito. ");
INSERT INTO cotNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iriraquea aacaanquenaneca chooca imaica ocaniqui itsipavacoquenaquea shitaponcarontsiqui ashecatantajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Irimetojaquetari irira Irijanite Caquinte, onetsanaquempaquea inintacaaquerica Aapani, cotanquitsiquea ¡ooshiatsi irantsipevaequempaquea irira aacaanquerineca! ");
INSERT INTO cotNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Icoacotavacaajianaca maasano: —¿Quericaqueate aacaanquerineca? ");
INSERT INTO cotNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iroompaquea iparipariitanacaroquea itsatacaanejia Jesoshi iquenquetsatavacaajiacaquea iquenquetsatacojianaquero arica chooca itsatacaane anaajiaquerica itsipajia. ");
INSERT INTO cotNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Cotanquitsiquea Jesoshi icantiriquea: —Iriraquea imajirojiate caquinteguetatsica teeca intsaroventempariji Aapani Irioshi iroguentiquea yatsanatantajiaca. Aisa iriraquea majirontajiatsica manaquea inintajiaque incantajiqueriquea caaviji icavintsajanti. ");
INSERT INTO cotNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Cotanquitsiquea aviatimpajia aatoquea piquejejiguirotsi imaica. Iriraquea anaantamajatatsica inquejetanajemparija teeca iranaanteji. Ariquea inquejetaquempaquea majirontatsica, inquempetanajemparija amitantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Queri anaamajatatsica? ¿Irioca savicatsica irishecatavaquempaquea intati shitaponcarontsiqui, irioca amitantatsica jocacotantiroca isheca? Iriotaquequea savicatsica shitaponcarontsiqui. Cotanquitsiquea naatimpa imaica nocoraquetaque acaniqui noquempetapojariquea amitantatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aviguentijia tsipajiaquenaca natsipevaecagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irootaquequea imaica nompeacaantajiaquempica majirontajiatsica, ariquea iquejetanaquenaquea naatimpa Aapani ipeacaaquenaquea imajirojiate maasanojia. ");
INSERT INTO cotNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Oncoramanitapojajegueti pintsipajiaquenaquea nomajirontagueti, pishecajiaquempa pimirajiaque noshitaponcaroqui, pisavisaviitantajiaquemparo isavicantaca majirontatsica cameetsanijite pincantajiaquerinijite queroquea incojitaquerini ishiraerijia ichoviquijianaqueca irijanijiate Jacovoni caravaetanquitsica 12. ");
INSERT INTO cotNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iroompaquea icanque Amajirote aisa: —Shimo, Shimo, irira Satanashi yamanaqueri Aapani irishinequeriniji inquempetacaajiaquempiniji aviatimpajia yatecacojitirogueti tirigoitsoqui, iramenantajiaquempiquea arimajacaca pitsaroventamajataquena. ");
INSERT INTO cotNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Cotanquitsiquea naatimpa namanacovenquempiquea aviatimpa aatonijite pipeacomajatanajarotsi pitsarovenquenagueti. Ariquea pimpeacovequitenaquea, cotanquitsiquea pincoraquetashitajenagueti, noninque pintampishitacaajiaqueriquea papitsaroventarijiate. ");
INSERT INTO cotNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Icanque Shimo: —Nomajirote, noanaquequea naatimpa quisho noacotantanaquempi, irisantanatacojiquempigueti inquejetacaajitsitenaquea naatimpa, aatoquea notsinampirejimpitsi. Irooca irimetojajiquempiquea inquejetacajaiquenaquea naatimpa aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Icanqueriquea Jesoshi: —Peerero, noncanquempiquea, coajica tequeratagueti irinijeji chaapa, pomanacoquenaquea 3. ");
INSERT INTO cotNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ariquea icantiriquea Jesoshi itsatacaanejia: —Oraqueate notigarancajiaquempigueti pitsavetantajiaquitigueti, nocantajiavaquempiquea: ‘Aatoquea paajiguitsi pitsaratote, aisa pitetantarica pimentaquitsite, aisa aatoquea paajiguitsi itsipapae pigaviguitire.’ Piquejetacagueti, ¿choocampate picoguitejacoqueca? Iriatimpajia icantiriquea: —Tee onchoocateji. ");
INSERT INTO cotNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ariquea icantiriquea: —Cotanquitsiquea imaica choocagueti pitsaratote paanaqueroja, aisa pitetantarica pimentaquitsite. Aatogueti ochoocati pitsaampitsantsamenirite pojocantanaqueroja piitsaare jenoquitica paantanaquemparoja pitsaampitsantsamenirite. ");
INSERT INTO cotNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Noncantajiaquempiquea irinetsanamajajiqueroquea ocanqueca Itioncacaantaqueca Aapani Irioshi cantacotsitaquenaca: ‘Intsipatacaantajiquempariquea covaeguishejigaroca covaeguisherentsi.’ Maasanopae itioncacotsijitaquena onetsanamajatanaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Icantiriquea iriatimpajia: —Jero, Nomajirote, mavite tsaampitsantsameniri. Icanque iriatimpa: —Ariotapojaque. ");
INSERT INTO cotNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iroompaquea yoanajiquea Jesoshi Orivotsempiqui, aritarite yoapinique oraniqui. Iriraquea itsatacaanejia yoguijaguijaitanaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ariquea yarejerejeipojaca icantiriquea: —Pamanacoventajiguempa aatonijite picovaeguishejigatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iroompaquea yoanaquequea tiijacoñajiquea ontaniqui yoguerotanaca yamananaqueriquea Iriri icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Aapani, pininquegueti paapitsatenarojate nantsipequempaca, cotanquitsiquea aatoquea iroguenti netsanatatsi nonintica naatimpa, iroguentiquea netsanatananquitsine pininqueca aviatimpa.” ");
INSERT INTO cotNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iroompaquea icoraquetashiqueriquea irashivantite Aapani Irioshi, iquenapojaque inquitequi itampishitacaapojaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yamenacotavacagueti yatsipemajatanaca, arimpaqueate yamanacoventanacaquea, imasavivaetanaque quempeni irajantsi, ochochorojanaque inirojapae isavi quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ariquea iteroncanajatiguiro yamanacovencagueti icatianajaqueate yoanaji itajencashijiapojiri itsatacaanejia, yamenajiapojiriquea maajiaque, omagotacaanaqueritari ishimampojancare. ");
INSERT INTO cotNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Icantiriquea: —¿Taate pimaantajiacaca? Pintinajajianaque pamanacoventajiguempaquea aatonijite aapojimpitsi covaeguishetacaanaquempineca. ");
INSERT INTO cotNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iroompaquea quenquetsatatsitiraja Jesoshi icoraquecoraqueipojaque caquintejia isaquiriaventajiapojacari. Iriraquea itsatacaane pajitatsica Jorashi ijivatapojiri. Yojocavaetapojaca quempeji irinintavorotashipojempari Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ariquea Jesoshi icantavaqueri: —Jorashi, ¿irootaquempa picoraquetantacaca paacaanqueri Irijanite Caquinte, pinintavorotantamampeacarica? ");
INSERT INTO cotNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Irirajia itsatacaanejia yamenajiavaquerigueti maasanojia coraquetashijiaquerica icantiriquea: —Nomajirote, ¿arite nompejianaquempiquea noncarajiavaqueri? ");
INSERT INTO cotNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aparo itsatacaane icaratavaqueri yashintacaca saserorote anaantamajatanquitsica, iguempitarejitsitari iguempita itincamijempequiquitica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Cotanquitsiquea Jesoshi icanque: —Ariotaquetsija icocani. Ipamitsitajariquea iguempitaqui, jac peamajatanaja. ");
INSERT INTO cotNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ariquea Jesoshi iquenquetsatacaajiaqueri saserorotejia anaantajianquitsica, imajirojiate igoaretatepae quempoguijajiguiroca teemporo, aisa jivajiatsica, maasanojia coraquetashijiaquerica aajiaquerineca, icantiriquea: —¿Arimpate naroguenti catsimari aapitsatantatsica pamashitantajiaquenaca pitsaampitsantsamenirite aisa inchaquiji? ");
INSERT INTO cotNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Oraquea noconoajiguimpigueti nocantacoguitaniquea oraniqui teemporoqui teequea querocaquea pincotimajiguenaji, cotanquitsiquea imaica manatarite aapojaca pagavejantajiaquenaca, iroguentitari iragavejantantaquempaca imajirote pitsecacojiatsica, jero piquejetantajiacaroca imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ariquea yajiricajiaqueri Jesoshi, yaanaqueriquea itsovironaquitequi saserorote anaantamajatanquitsica. Iriraquea Peerero yoguijatacovetanacari cotanquitsiquea impoivaetapojaque. ");
INSERT INTO cotNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ariquea oraniqui itsitacajiaque paamari niganqui pampatejijaniquiqui itsovironaquitequi, savisaviitaque itajiaque yanquitacojiacaroquea. Iriraquea Peerero iconoajiapojacari isavicapoji. ");
INSERT INTO cotNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iroompaquea amenaqueriquea aparo yashintajitaca itaquegueti, amenitsitanacariquea sorerere ocanque: —Iricatica aisa itsipatacari Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Cotanquitsiquea yomanacotsitanaca Peerero, icanque: —Manquigarentsi, teenicate nontsateriji. ");
INSERT INTO cotNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iroompaquea incajaranquiguitetanaquitigui itsipaquea amenaqueri icanqueri: —Avirotari aisa itsatacaane Jesoshi. Icantsitajaquea aisa Peerero: —¡Teeshinete! ");
INSERT INTO cotNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Iroompaquea incajaranquiguitevaetanaquegueti arimpaquea icantanaque itsipa: —Arimajaca itsipatacari, iriguentitarite Garireaquitica. ");
INSERT INTO cotNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Iriraquea Peerero icanque: —Tee nontsatsitempiro picantacotaqueca. Iroompaquea icantanaquitigui Peerero inijanaquequea chaapa. ");
INSERT INTO cotNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ipitsoquitsitanaca Amajirote yamenaquitiri Peerero, ariquea icotanaca iriatimpa iquenquejitanacaroquea icantaquerica Jesoshi incajaranquitica icanqueriquea: “Coajica tequeratagueti irinijeji chaapa pomanacoquenaquea 3.” ");
INSERT INTO cotNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Icatiitsitapanajantaquea isotoapanajanti, iraitsitanacaquea ishimampojancamajatanaca. ");
INSERT INTO cotNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iroompaquea maasano coaretajia quempoguijajiaquerica Jesoshi ishiroshirontimentavaecari, icapocapovaetaqueri, oshequi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iponaajiaqueriquea icapoitari icantajiavaqueri: —Iintsijate pintsatavaqueja taaquea capojaquempi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iquenquetsaguisheventajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iroompaquea osavincaguitetanaquegueti icapiocajiaca jivajiguirica joriojia, saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini, maasano. Iroompaquea icajemacaanqueriquea Jesoshi icoacojiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Icantiriquea: —Iintsija pincamanquena, ¿arimajaca aviguentica Quirishitotatsica? Icantiriquea iriatimpa: —Arigueti noncantavequempi: ‘Jeejeguitatsi’, aatotarite piquemisantajianatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ariquea noncoacojiavetempigueti, aatoquea picantajigui aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cotanquitsiquea imaica iriraquea Irijanite Caquinte irisavicaquequea itincamijempequiqui Aapani Irioshi Agavejamajatatsica, incoguitempani. ");
INSERT INTO cotNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Icantajiaqueriquea maasano: —Arisacanica ¿aviguentimpa Irijanite Aapani Irioshi? Icanque Jesoshi: —Naroguitatsi, aviguenti cantaqueroca. ");
INSERT INTO cotNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ariquea icantajianaque iriatimpajia: —Iroosacanica, imaica ¿arimpate ancajemacaanque itsipapae incamancajiquea querocaca icocani iricatica? Jac imaicaquea aquemajiaqueriqueate icantaquegueti iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jero maasanojia icatintiijianaca yoayoaitanaque yaajianaqueriquea Jesoshi Piratoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iroompaquea yarejerejeipojaca itsojeventajiapojacari, icanquequea: —Iricaticaquea noquemaqueri icantacantavaequeri nogonorojia itsatacajaiaqueriquea incatsimajiaqueri majirontatsica, aisa icanquequea: ‘Aatoquea pojocagarantajiguiniritsi majirontatsica Sesa pimentaquitsite.’ Aisa manaquea icanque: ‘Naroguentiquea Quirishito Majirontatsica.’ ");
INSERT INTO cotNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iriraquea Pirato icanqueriquea: —¿Arimajaca aviguenti Imajirote jorio? Icanquequea Jesoshi: —Tampatica poaquero. ");
INSERT INTO cotNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Icantsitariquea Pirato maasano saserorotejia anaantajianquitsica aisa maasano caquintejia: —Iricaticaquea naatimpa namenaqueriquea teequea taaca opaji impeacaimatempaji cameetsanijite incatsimatantajitaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Cotanquitsiquea iriatimpajia arimpaquea itampishijianaquequea icantajiaque: —Arimajaca icantacantajiaqueri maasano Joreaquitica itsatacajaianaqueriquea taaca opajitapae, icatsimatantajianacarica majirontajiatsica. Ipariapanajantaroquea Garireaqui, imaica ariqueate icoraquepojiquea acaniqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iroompaquea iquemaquegueti Pirato icantsijigariquea: —¿Irioca Garireaquitica? ");
INSERT INTO cotNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Irooquea icanquitiguiri: “Jeejeguitatsi, iriotaquequea”, itigaranquitsitari Erorishiqui, iriotaquetari netsanajiguirica Garireaquitica cotanquitsiquea ichoocapoji Jerosarequi imaica. ");
INSERT INTO cotNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Iriraquea Erorishi yamenavaquerigueti Jesoshi ishinevaevetanaca icanca inintavecaquea iramenaquerimequea coramani, iquemacotsicariquea iquenquetsatacojitaquerigueti, jero inintantacaca iramenaquerimequea cameetsanijite iramenacaajiaquerinijite oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Icoacoguevecariquea oshequini, cotanquitsiquea Jesoshi teequea incanteji. ");
INSERT INTO cotNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ariquea ichoocajiaquequea saserorotejia anaantajianquitsica aisa tsatacaantajiguiroca itioncacotanaqueca Moishishini. Iriatimpajia arimpaqueate itampishijianaque itsojeventajianacariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Iriraquea Erorishi aisa igoaretajiate ishiroshirontimentavaecari Jesoshi, iquejetacaamampeacari majirontatsica, iquitsaatantajiacariquea quitsaarentsi cameetsamorenamajatanquitsica quempetaroca iquitsaataca majirontatsica. Itigaranquitsitajari Piratoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ariquea ivetsinantavacaajiaca Pirato itsipatajari Erorishi, coramani iroguentiquea icatsimatavacaajiaveca. ");
INSERT INTO cotNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iroompaquea iriraquea Pirato icapiocajiaqueri saserorotejia anaantajianquitsica, jivajiguirica joriojia, aisa maasano caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Icantiriquea: —Aviatimpajia pamajiavetaquenari iricatica picantajiaqueca icantacantavaejianaqueri caquintejia icanqueriquea incatsimajianaqueriquea majirontatsica, cotanquitsiquea naatimpa imaica namenavecariquea teequea inquempeteroji picamantavetapojanaca, inchiquiojiqueate piquemajiaqueri aviatimpajia icantaqueca nocoacovecarigueti incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ariquea iquejetacaquea Erorishi iriatimpa yamenavecaquea teequea impeacaguempaji covaeguisherentsi, jero yoguipiantavajarica. Imaicaquea pamenajiaquequea teequea taaca opajita impeacaguempaji cameetsanijite irimetojaquenijite. ");
INSERT INTO cotNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nantsipetacaavaquemparita ariquea noguipaquijitajempariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Icanqueriquea imaica irooriji icantacoguitani aapojempagueti Paashicoa iriraquea Pirato iroguipaquijajeri aparo isantanatacotimentajiqueca igovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Cotanquitsiquea iquemajiaquegueti icanqueca Pirato, maasanojia icajemajianaque icanquequea: —¡Irimetojetashine! ¡Irioquea poguipaquijaje Varavashi! ");
INSERT INTO cotNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Iriraquea Varavashi iroguentiquea isantanatacotimentajiqueriquea itsipatsipaitacariquea itsipapae guisotoantanquitsinemeca majirontanquitsica Jerosarequi, aisa imetojantaquequea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Iriraquea Pirato inintaveca iroguipaquijajerimequea Jesoshi, icantsijiajariquea aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cotanquitsiquea iriatimpajia arimpaquea icajemajianaquequea: —¡Pompajacoteri! ¡Pompajacoteri! ");
INSERT INTO cotNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Icantsitajariquea aisa Pirato: —¿Taampate ipeacaaca? Nocoacotsivetariquea namenaqueroquea naatimpa teequea taaca opajita impeacaimatempaji cameetsanijite irimetojanquempaca. Nantsipetacaavaquemparita ariquea noguipaquijitajempariquea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Cotanquitsiquea iriatimpajia arimpaquea itampishijianaquequea icajemajianaquequea: —¡Pompajacoteri! ¡Pompajacoteri! Caavijiquea icajemamajajianaquequea, ari yagavejantajianaque. ");
INSERT INTO cotNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ariquea irira Pirato iquemisantajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ariquea yoguipaquijajiriquea iriraquea isantanatacojivecaca itsipajiacarigueti itsipapae guisotoantanquitsinemeca majirontanquitsica aisa imetojanquegueti, iriotaquetari inintajiaque iroguipaquijajitajeri. Irirampani Jesoshi, yojocajiaqueneriquea igoaretajiate irinetsanajiaqueronijite inintacaajiaquerica caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ariquea yoayoaitanaquequea yaajianaqueriquea Jesoshi irompajacojiaqueri. Itonquivojajiacari Shirenequitica pajitatsica Shimo, iquenavaetapoji ontaniqui niganquitejipaequi. Iriatimpajia yaajiavaqueriquea inatacaitsitariquea igoroshite Jesoshi, yoguijatacaaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Isaquiriaventajianacariquea oshequini caquintejia aisa manquigarentsijia ocaramirincavaeque ocanca, iraanajianacariquea oshimampojancacoventajianacari. ");
INSERT INTO cotNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Cotanquitsiquea Jesoshi yamenajiaqueroquea icanqueroquea: —Manquigarentsijia Jerosarequitica, aatoquea piraacojianatsi naatimpa, piraacojiaquempa aviatimpajia, aisa piraacotsitempari pirijanijiate. ");
INSERT INTO cotNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aapojajempaquea savincaguiteri incantantajitanaquempaca: ‘Iroguenti icavintsajamajataque Aapani Irioshi teeca onchoocatimajigueji irijanite, teetarite amenajigueriji irijanite, teequea antsomijigueriji.’ ");
INSERT INTO cotNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iroompaquea maasano incantajianaqueroquea otsempipae: ‘¡Pintirejanaque pintsinacajiguena!’ Incantajianaqueroquea aisa aatsonquiripae: ‘Poaviotacojiguenajate, pomanacojiaquenaja.’ ");
INSERT INTO cotNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iquempetacarogueti oratica inchato janatirajaca, ¿quero incojitaquero oroavoaro? ");
INSERT INTO cotNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aisa yaajitanaqueriquea mavite peacaaguishejianquitsica covaeguisherentsi irompajacojiqueriquea, itsipatacaantajiacari Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Iroompaquea yarejerejeipojacaroquea aatsonquiri icantajitica Shocoitontsi, ariquea oraniqui yompajacojiaqueriquea Jesoshi itsipatacaantajiacari irira peacaajianquitsica covaeguisherentsi, aparo yogatiacojiquequea itincamijempequiqui, iriraquea itsipa iroguenti yogatiacojiqueriquea ishinampijempequiqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Irooquea yompajacojitaquerigueti Jesoshi ariqueate icotanaca yamanacoventajianaqueriquea ompajacojiaquerica, icanque: —Aapani, pimpeacotsitajempari iquejejiaquenagueti imaica, teetarite intsajigueji. Ariquea iriraquea coaretajia ipegavijijiaca intsajiaquenijite taaca aaqueroneca iquitsaaguevecaca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ariquea ichoocajiaque oraniqui oshequini caquintejia, yamenajiaqueriquea Jesoshi. Iriraquea jivajiatsica ishiroshirontimentavaecari, icanqueriquea: —Yantashitacari yompetacoguetacari itsipajia, imaicaquea iriogueti Quirishitotatsica Icoguiaqueca Aapani Irioshi, iintsija irompetacotanaquempa. ");
INSERT INTO cotNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ariquea iquempejiaca coaretajia ishiroshirontimentavaecari, iquempejiquempejiitanacari yojocajiaqueneriquea vinoja cachonerontoquijajaro. ");
INSERT INTO cotNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aisa icantiriquea: —Aviguentica Imajirote jorio, iintsija pompetacotanaquempajate. ");
INSERT INTO cotNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ojenoquipojaquegueti ishinquireguishipojacagueti ipatacajitaqueroquea ogota itioncantajicaro iguenquetsatsarepaequi guiriego, Iromaquitica, evereo, ocanque: “Iriguenti Imajirote jorio.” ");
INSERT INTO cotNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iquenquetsatanaque aparo peacaanquitsica covaeguisherentsi itsipatacaantajicarica, icaveitariquea Jesoshi icanqueriquea: —Irootarite aviguentica Quirishitotatsica iintsija pompetacotanaquempajate aviatimpa, pinquejetacaitsitenaquea naatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Cotanquitsiquea icantomajitari itsipa icanqueriquea: —¿Arimpate teequea pintsaroacaguempariji Aapani Irioshi? ¡Pamenavecaqueate yompajacojiquempi itsipatacaantajiquempiri, pigaanacaquea piquejetanaca imaica! ");
INSERT INTO cotNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aatimpajia atsipejiacaquea apeacajaiaca covaeguisherentsi iquejetacaantantajitacajica imaica, cotanquitsiquea iriatimpa teequea taaca opajita impeacaguempaji, manaqueate yatsipetacaajitacari intati. ");
INSERT INTO cotNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ariquea ipitsocashitariqueate Jesoshi icanqueriquea: —Jesoshi, pinquenquejacotajenaja naatimpa pincoraquetajegueti pimajirontapojaquempagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Icanqueriquea Jesoshi: —Noncantamajataquempiquea ocatica savincaguiteri pintsipatapojaquenaquea paraisoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Oraqueate iquenquetsataqueguetiquea imaica jac tampaticapoji catsirincaiteri, opitsecanaquequeate maasanopae otsitacaguitejavaetanacaroquea oraniqui arejetacovaeca ijaguitetanajigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Teequea irivoreitsitajempaji catsirincaiteri. Iroompaquea oraquea omorena ticaamorenatanquitsica teemporoqui jocagatsica aatonijite iquijajitiro intsompoguiremajacaqui, ariquea opecotarejanaque tampaticaquea niganquisano ocantanaque sarararararara. ");
INSERT INTO cotNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iriraquea Jesoshi icajemapanajantiquea inirojencamajaca icanca, icanque: —Aapanii, paavajeroja noshire. Irooquea icanquegueti imaica, ariquea imetojanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iriraquea imajironcaca 100 igoaretajiate Iromaquitica yamenavaquerogueti maasanopae, ishineventavaetanacariquea Aapani Irioshi icanque: —Arimajaca irica irio comajamajatatsica, teequea taaca opaji impeacaimatempaji. ");
INSERT INTO cotNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Maasanojia choocajianquitsica oraniqui yamenamenaitavaquerogueti maasanopae, yoayoaitanajiquea itinquitinquineguintajianacaquea tin tin tin, ishimampojancavaejianacatari. ");
INSERT INTO cotNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cotanquitsiquea irirajia tsatirica Jesoshi aisa manquigarentsijia oguijaguijaiquerica iquenajiapojigueti Garireaqui icatintiijiaca tiijacoñajiquea oraniqui yamenamenaiqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ichoocaque aparo shirampari pajitatsica Jose yamajironcaca joriojia, itsipajiacari imajirotepae icapiocapinijiacagueti. Iriguenti pintsatantatsica comajamajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Tee inquejetempariji itsipapae majirontajiatsica cantanquitsica irimetoje Jesoshi. Iroguenti yoguijaqueriquea Aapani Irioshi impeaquempaquea irimajirontajiaquempaca maasanojia. Ariguentiquea iquenapoji guinteninintsiqui Arimatea choocatanquitsica Joreaqui. ");
INSERT INTO cotNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iriatimpa yoashitanaqueriquea Pirato, icanqueriquea ininque irajaitanajero itsino Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ariquea yoanaque itsopajarejacotajiriquea yampiguiricacotantajariquea iniromorena shipetari. Ariquea yaanajiriquea yojoquijitantajari imperitamoroqui, iroaquerasanoquea iqueecajitaquero mapichonquiinaqui, tequeratatiraja irojoquijitantajitempariji metojatsica. ");
INSERT INTO cotNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oraquea imetojantacaca Jesoshi iroguentiquea savincaguiteri inetsanatsitantaroca joriojia maasanopae tequeratagueti arejetempaji imagorejantajitaca, irooshipoji arejetapojemparo, iroorijite iquijanaji catsirincaiteri. ");
INSERT INTO cotNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oraquea manquigarentsijia quenaquenaitapojatsica Garireaqui oguijaguijaiquerica Jesoshi icoraquequegueti, oahoaitanaquequea amenajiaquitiro yojoquijivecarigueti, amenamajajiaqueriquea querocaca icojitaquerini ipitsantsajajiquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Iroompaquea ocoraquecoraqueitajiquea tsovironaquiqui onetsanapojajiroquea poncajaguetatsica iroguentiquea ontiritsinotantaquemparica Jesoshi. Ariquea omagorejajiaque savincaguiteriqui imagorejantajitaca onetsanajiaqueroquea icanqueca Moishishini itioncacotanaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Iroompaquea iroaqueragueti osavincaguitetamanaque parianajaroca semana oahoaitanaque manquigarentsijia ontaniqui yojoquijijitaquerigueti Jesoshi aajianaquequea poncajatsica onetsanajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ariquea arejerejeivetapojaca amenajiapojaqueroquea mapi ticaacotantajivecarica jac tigaritaca tanarejanaque. ");
INSERT INTO cotNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oquijaquijaivetanaca cajaraguiteni tee anejeriji impitsantsajajempaji Amajirote Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oquenquejapoji, teequea ontsateji quero ococani. Iroompaquea amenitsitariquea mavite shirampari cantacovaequequeate iitsaarequi tsirencavaetaquequea tsiren. ");
INSERT INTO cotNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ariqueate ocohocoitanaca otsaroamajatanaquequea oguerotsitanaca arejevaequitaro ovancaqui quepatsiqui. Iriatimpajia icanqueroquea: —¿Quero ococani pamenantaguetajatarica anijatsica acaniqui yojoquijipinijitirigueti metojaripae? ");
INSERT INTO cotNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Teequea anejeriji acaniqui, pochatanaji. Iintsijate pinquenquejajiajerojate icantajiaquempigueti ichoocavetacagueti ontaniqui Garireaqui, icantacotacaquea icanque: ");
INSERT INTO cotNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Iriraquea Irijanite Caquinte iraacaantajiqueriquea irajaiaqueriquea covaeguishejiatsica irompajacojiaqueri, iroompaquea aapojajempagueti 3 savincaguiteri impochatanaje.’ ");
INSERT INTO cotNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ariquea iroatimpajia oquenquejajianajiroquea icanqueca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Coajica ocoraquecoraqueitaji tsovironaquiqui ocamantajiapojiri itigarancanejia carajiajatsica 11, aisa itsipajia. ");
INSERT INTO cotNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oratica camantajiapojaquerica itigarancanejia iroguentijia Maria Magararaquitica, Joana aisa Maria iriniro Santiago aisa otsipapae otsipatsipaitanacaca. ");
INSERT INTO cotNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cotanquitsiquea iriatimpajia teequea inquemisantajigueroji. Yamenajiaquequea manacaja oquenquetsatamampeajiacaquea intati. ");
INSERT INTO cotNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Cotanquitsiquea Peerero icatiitsitanaca ishiamajatanaca yojoquijijitaquerigueti Jesoshi, yamenamorovepojacaro intsompoguiqui cajaraguiteniqueate, iroguentiquea yamenaguepoji omagopae yampiguiricacotantajivecarica. Ariquea yoanaji tsovironaquiqui, yamenanaquequea intati. ");
INSERT INTO cotNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iroompaquea coajica incajaranquiguitetanaquegueti yoajianaque mavite itsatacaane Emaoshiqui. Inquenantapojaquemparogueti Jerosare, arica ocarataque 11 quiromeetero. ");
INSERT INTO cotNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iroompaquea ari yoayoaitanaquequea quenavoquirontsiqui iquenquetsatavacaajianaca iquenquetsatacojianaqueri Jesoshi querocaca icojiquerini imetojajiquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Irooquea iquenquetsajianaquegueti, icoraquepojaque Jesoshi iriatimpa itsipatsipaitanacari yoayoaitanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yamenajiavecariqueate, cotanquitsiquea querocaquea icohicoitaquerini Aapani Irioshi aatonijite itsajiguitsi iriguentica Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ariquea icantiriquea Jesoshi: —¿Taaqueate piquenquetsatacojianaque imaica? Iriatimpajia icatintiitanaca ishimampojancajiacaquea. ");
INSERT INTO cotNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aparo ipajita Quereopashi, icanquequea: —¿Arimpate aparoquea picocani aviatimpa teequea pinquemacoteroji iquenquetsatacojiaqueca maasano ontaniqui Jerosarequi? ¿Querocaquea picocani aviatimpa aparo pichoocataji teequea pinquemacoteroji chapinquitica? ");
INSERT INTO cotNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iriatimpa icantsitariquea: —¿Taaqueate opajita chapinquitica? Icantiriquea: —Orate imetojaquegueti Jesoshi Nasarequitica. Iriatimpa iriguentiquea tsavetantatsica agavejamajatatsica nigaantaguequeroca oacaantantatsica intati, aisa itsamajati icanca itsatacaantaquegueti. Iriraquea Aapani Irioshi ishineventamajatacari oshequi, ariquea iquempejiaca maasanojia caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iroompaquea iriraquea saserorotejia anaantajianquitsica aisa amajirojiate yaajianaqueriquea yojocapojiniri incantacaantajiaqueriquea irimetojaque, ariquea yompajacotsitari. ");
INSERT INTO cotNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iroaqueragueti namenajiavecaquea ari irioji ompejiacajineca aatimpajia ishiraerijia aatonijite yashintajiajitsi itsipapae cameetsanijite anchoocajiajenijite intati. Imaicaquea yanaacovaetanaca 3 savincaguiteri imetojaque. ");
INSERT INTO cotNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Cotanquitsiquea oconoagarantajiaca manquigarentsijia notsipatsipaitacaca oahoaitanaque incajaranquini pitsecaguitetirajagueti amenajiajaterime yojoquijijivecarigueti, cotanquitsiquea teequea anejeriji. Iroompaquea ocoraquecoraqueitaji omintsaroajiaquenaquea ocamantajiapojanagueti amenajiaquerigueti irashivantijitete Aapani Irioshi icamanquerogueti jac pochatanaji. ");
INSERT INTO cotNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iroompaquea iconoagarantajiacaquea notsipajiacaca yoayoaitaquitiquea iriatimpajia yamenajiaquitiro, icantajiaque onetsanamajapojiroqueate teequea anejeriji Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iroompaquea icantiriquea Jesoshi: —¡Tequeratamajaca pintsatimajigueji! Teetari paitsitavaquemparoji maasano icantajiavecaca tsavetantajiguiroca icanquerica Aapani Irioshi coramanitica. ");
INSERT INTO cotNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Arimpaquea teequea incanteji iroquetitaquea irantsipevaequempaquea Quirishitotatsica maasano ocatica, coajica intsajitaqueri iriguenti Oganejencamajatatsica ariquea impeamajatanaquempaquea imajirote maasanojia? ");
INSERT INTO cotNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iroompaquea iparianacaroquea itsatacaajiaqueriquea maasanopae Itioncacaantaqueca Aapani Irioshi tsavetacotsitacarica iriatimpa, ipariapanajantaroquea itioncacotanaqueca Moishishini ariquea iquejeguetanaqueroquea aisa itioncacojianaqueca tsavetantajiatsica iriatimpajia, yoguisotojaiaqueneriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iroompaquea yarejerejeipojacaro Emaoshiniqui, yamenajiguiriquea Jesoshi arimpaquea iroanaqueme, ");
INSERT INTO cotNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","cotanquitsiquea yaajiavajiri icantiriquea: —Iintsija aatoja poguitsi. Noninque pimaimojianaquenaja naatimpajia, irootapojajitarite ompitsecanaje. Ariquea iquijaquijaitanaque intsompoguiqui itsipatsipaitanacari. ");
INSERT INTO cotNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ariquea isavisaviique shitaponcarontsiqui irishecajiaquempaquea. Iriatimpa yaitsitaroquea pan yamanaqueriquea Iriri ishinevencaroquea, ariquea icotarejaqueroquea yojocajiaqueneriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ariquea oquejevetaca iroaqueragueti ipityaquirejanaque, itsajianajiriquea iriguenti Jesoshi, cotanquitsiquea iriatimpa jac ipejaencatapitsatanajari. ");
INSERT INTO cotNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Icantavacaajianacaquea: —Arisacanica pinquenquejajero incajaranqui ontaniqui quenavoquirontsiqui iquenquetsatacaavacajigueti yoguisotoacajirogueti Itioncacaantaqueca Aapani Irioshi queroquea ocojianacajini ochagashirentajianacajiquea ashirejiaqui oshinetacaavaetanacaji. ");
INSERT INTO cotNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iroompaquea icaticatiitsitanaca yoayoaitanaji icantacantaitanaja Jerosarequi. Yamenajiapojajiri itigarancanejia Jesoshi carajianquitsica 11, omporoguijajiaca itsipatsipaitacari itsipapae. ");
INSERT INTO cotNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iriatimpajia icantavaqueri: —Arimajaca pochatanaji Amajirote, yonigaavetajari Shimo. ");
INSERT INTO cotNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ariquea icamantajiaqueriquea iriatimpajia aisa querocaquea icojiaquerini itsipatsipaitanacarigueti quenavoquirontsiqui teequea intsajigueriji, iroompaquea yamenajiajirigueti tsovironaquiqui icotarejaquerogueti pan, ariquea itsatantajiacarica iriguenti Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Choocatirajaquea quenquetsatavacaajianatsi, taampinaquea icatiimojiapojajari Jesoshi, icantajiapojajiri: —Pishinejianajempa. ");
INSERT INTO cotNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iriatimpajia itsaroajianaque oshequi itsaroacaajianacariquea yamenajiaqueriquea iriocaja sashinti. ");
INSERT INTO cotNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Cotanquitsiquea Jesoshi icantiriquea: —¿Taaca pitsaroacaimentajiaquena? ¿Quero ococani piquenquejajiaqueca imaica? ");
INSERT INTO cotNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iintsija pameneja intati nacoqui aisa noguitiqui yompajacojiquenagueti. Naroguentiquea. Pinchagajiguenaja pamenamajataquenanijite. Iriraquea sashinti teetarite onchoocateji itsino aisa itonqui, tee inquejetenaji naatimpa imaica pamenajiaquenagueti. ");
INSERT INTO cotNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Irooquea icantajiaquerigueti imaica yamenacaajiaqueriquea iracoqui aisa iguitiqui yompajacojitaquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cotanquitsiquea yamenajiaqueriquea tee iragavejajiajempaji inquenquejavajero, caavijitarite ishinemajajianaca yamenamenaitanaquequea intati, icantantacarica Jesoshi: —¿Chooca pisheca? ");
INSERT INTO cotNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ariquea yojoquitsitanariquea shima jocavoquiri. ");
INSERT INTO cotNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yaitsitariquea ishecatacari, yamenacojiaqueriquea maasanopae. ");
INSERT INTO cotNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ariquea icantiriquea: —Imaicaquea imaica maasanopae pamenajiaqueca irootaquequea notsatacajaiaquempica coramani choocatirajanagueti notsipatsipaitaquempigueti, nocanquegueti onetsanamajatanaquempaquea maasanopae itioncacoquenagueti Moishishini aisa itioncacojianaquenagueti tsavetantajiatsica aisa paperiqui Saremo itioncacotanaquenagueti Taavini. ");
INSERT INTO cotNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iroompaquea iriatimpa yagavejacaajiaqueriquea intsamajajianaqueronijite taaca opajitapae ocantacoqueca Itioncacaantaqueca Aapani Irioshi, icanqueriquea: ");
INSERT INTO cotNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Ariquea oquejetacaquea imaica itioncacojiquerogueti ocanque irantsipevaequempa Quirishitotatsica irimetojaque, cotanquitsiquea aapojempagueti 3 savincaguiteri impochatanaje. ");
INSERT INTO cotNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ariquea intigarancaqueri tsavetantajiatsica, intsavetantimojiaqueriquea maasano caquinteguetatsica incantajiaqueriquea irovashiantajianajero ipeacaaguishevecaca covaeguisherentsi incantashitatijaianajempaquea cameetsanijite irishetacojiajerinijite Aapani Irioshi aatonijite icatsimatimentiritsi icovaeguishejiacagueti. Ariquea omparianaquemparoquea Jerosarequi, onquejetaquempaquea imaica arejevaetanaquemparoquea ontsitacaguitejavaequemparoja maasanopae quepatsi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aviatimpajia pamenamajajiaqueroquea maasanopae, imaica aviatimpa tsavetantajiaqueroneca. ");
INSERT INTO cotNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naatimpa nontigaranquimojiaquempiriquea icantsitacaca Aapani intigarancanquimojiaquempi, cotanquitsiquea pinchoocajiguetaja acaniqui Jerosarequi aatota poapoaiti osamani. Poguijajiguetaja intigaranquimojiaquempiri Aapani agavejacaajiapojempineca poneanquitsineca jenoqui. ");
INSERT INTO cotNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iroompaquea Jesoshi itsipatsipaitanacari itsatacaanejia irooshipojigueti Vetaniaqui. Ariquea icantajempequitanaja iraco yamanacoventajianaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Irooquea iquejetanaquerogueti imaica yamanacoventajianaquerigueti yamenajiguiriquea yatsomajanaja yoanaque, yaajitanajiri jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Itsaroventajiavajari, coajica yoayoaitanaji Jerosarequi ishinejianaca icanca. ");
INSERT INTO cotNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Icantacoguitani yoayoaitapinijigui teemporoqui ishineventajiacari Aapani Irioshi.");
INSERT INTO cotNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iroaqueragueti igantaga ichoocataque Quenquetsatsarentsi. Irira Quenquetsatsarentsi itsipatacariqueate Aapani Irioshi. Irira Quenquetsatsarentsi, iriotaque Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Irio itsipatacaca Aapani Irioshi iroaqueragueti. ");
INSERT INTO cotNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iriotaquequeate peacaaguetacaro maasano choocaguetatsica. Tee onchoocatashitempajiqueate teeca impeacaguemparo iriatimpa, aisa aatomegueti ichoocatime iriatimpa aato ochoocaguetime. ");
INSERT INTO cotNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iriatimpa iriguentiqueate anijacaantantatsica, aisa iriratica anijacaantantatsica iriguentiquea tsirencacojiaquerica caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iriraquea Tsirencari itsirencaque pitsecariqui, cotanquitsi pitsecari tee agavejavajeriji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ariqueate ichoocatini caquinte itigarancaqueca Aapani Irioshi, ipajita Joanca. ");
INSERT INTO cotNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iroguentiqueate icoraquetashitaque intsavetanqueriqueate irira Tsirencari, cameetsanijite iraventajiavaquemparinijite maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iriraqueate Joanca teequeate irio Tsirencari, iroguenti icoraquetashitaque intsavetanqueri Tsirencari. ");
INSERT INTO cotNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Icoraquetapojaquequea quepatsiqui irira Tsirencarimajaca tsirencacojiaquerica maasano caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ichoocataque quepatsiqui, iriotaquequea peacaavetacaro quepatsi, cotanquitsiquea irirajia quepatsiquitica teequea intsajiavajeriji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Icoraquetantavetacaroquea quepatsi yashincaca iriatimpa, cotanquitsi irirajia yashintajiacaca teequeate irishineventajiavajempariji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Cotanquitsi maasano shineventajiavacarica, aventacaroca ivajiro, irio icantacojiaqueca cameetsa impeaquempa irijanijiate Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Oraqueate ipeacaajiacarigueti irijanijiate Aapani Irioshi teequea onquempetemparoji yoacaantigueti caquinte, aisa teequea onquempetemparoji inintigueti caquinte iroacaantaque, iriguentitari nintanquitsi Aapani Irioshi irijanintantaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iriraqueate icantajitica Quenquetsatsarentsi icaquintetapojaque iguintenitimojiapojacaji. Namenajiaqueriqueate yoganejencamajata, iriguentitarite Irijanite Aapani Irioshi apaniroquea icoca iriatimpa, caavijiquea icavintsajantavaetaque, aisa teequeate iramatavijanteji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iriraqueate Joanca itsavetacotaquerigueti iririjencani icanti: “Iriguentitarite irira noquenquetsatacotaqueca iroaqueragueti nocamantajiaquempiqueate nocanti: ‘Iriraqueate impoitapojenaneca yanaaquenaquea, iriquetitari choocatatsi.’ ” ");
INSERT INTO cotNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iriatimpaqueate caaviji icavintsajantamajati, icancani icavintsajapinijiacaji aatimpajia maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aritarite oraquea Cantacaantanentsi, irio Moishishini yojocacaitaquene, yogaaqueneri itsipajia; orampani cavintsajantamajatagantsi aisa iroomajatatsica, iriguentiquea Jesoquirishito amaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tecatsi nejimaterine Aapani Irioshi, cotanquitsi irira Irijanite apatirotica itsipamajatacaca itsatacaajiacajiqueate quero icotani Iriri. ");
INSERT INTO cotNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iriraqueate joriojia Jerosarequitica itigarancajiaqueriqueate saserorotejia jerijia aisa irevitapae incoacojiaqueri Joanca taaquea inaque. ");
INSERT INTO cotNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ariqueate teequeate iromanacotempaji iriatimpa, tampatica yoaquero icanquerica, icamantamajajiavaqueri icantajiguiri: —Tee naroguenti Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ariqueate yapijitajiriquea aisa icantajiguiriquea: —Iroosacanicate, ¿taampate aviguenti? ¿Aviguenticajate Iriashini? Icantiri: —Tee naro Iriashini. —¿Aviguenti irira tsavetantatsica nagamajajiavacaca? —Tee. ");
INSERT INTO cotNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ariqueate yapijitsitajariquea aisa icantajiguiriquea: —¿Taampate aviguenti? Iintsijate poguisotoguenaro noncamantantajiapojemparica tigarancaquenaca. ¿Querocagueti pincanqueni? Intsija pincamantacotempa. ");
INSERT INTO cotNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ariqueate icantajiaqueriqueate Joanca: —Naroguentiqueate quenquetsatatsica oquitamampororoipojaquegueti niririjencani, nocantapinitaquequea: ‘Pintanarejagueteneri iguenavoquiro Amajirote ontampaticapoquitantanaquempaca’, irootaquetari itioncaqueca tsavetantatsica Isaiashini coramani. ");
INSERT INTO cotNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Iriraqueate coacojiaquerica Joanca iriguentiquea tigarancajiaqueri pariseojia. ");
INSERT INTO cotNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ariqueate icantajiaquequea: —Iroosacanicate teesacanicate aviguenti Quirishito, tee aviguenti Iriashi, aisa teequeate aviguenti tsavetantatsica coraquetanquitsineca. ¿Queroqueate ocotacani piviñacajatantacarica agonorojia? ");
INSERT INTO cotNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Icanti Joanca: —Naatimpa noviñacajatantacaro oja, cotanquitsi choocaqueate conoaquempica teeca pintsajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iriguentitarite impoitapojenaneca, cotanquitsi iriqueti choocatatsi. Caaviji yanaaquenaquea, aatotarite noquempejitaritsiquea iriatimpa nompeaquempame amiquerineca noishorejacoquerime igaviguitire. ");
INSERT INTO cotNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Irirajiaqueate coacojiaquerica ariquea yoashijianaqueriqueate Vetaniaqui, choocatatsica intatiquero Jororanequi, aritari iviñacajatantaque Joanca oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ariqueate osavincaguitetanajigueti irira Joanca yamenavaqueriqueate Jesoshi icoraquepojaquegueti icanti: “Jeri irinta Irovejajaniquite Aapani Irioshi shejiaquenerineca iguempevaere caquintejia. ");
INSERT INTO cotNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iriotaquequeate notsavetantaqueca chapinqui, nocantiqueate: ‘Incoraquetaque shirampari impoitapojenaneca yanaaquenaquea, iriquetitari choocatatsi.’ ");
INSERT INTO cotNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naatimpaquea aisa teequea nontsavetempariji, cotanquitsi nocoraquetaque noviñacajatantaguetantacaro oja cameetsanijite intsajiaquerinijite maasano ishiraerijia.” ");
INSERT INTO cotNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ariqueate icanti aisa Joanca: “Namenavaqueri Ishire Aapani Irioshi iponeapojaca jenoqui inquitequi iquejetapojacari emoreni, yampiguiricashipojacariquea Jesoshi, ichoocapojiri. ");
INSERT INTO cotNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Iroaqueragueti tee nontsavetempariji, cotanquitsi iriraquea tigarancaquenaca noviñacajatantacaro oja icanquenaquea: ‘Quericaca pamenavaqueri irampiguiricashitapojempari Noshire inchoocapojeri, iriotaque viñacajatantacari Noshire.’ ");
INSERT INTO cotNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Namenamajatavaqueriqueate, irootaquequeate nocantantacaca iriguentiqueate Irijanite Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ariqueate osavincaguitetanajigueti iriraqueate Joanca ichoocataji oraniqui itsipajiacari mavite itsatacaane. ");
INSERT INTO cotNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iroompaqueate yamenavaqueri Jesoshi yavisanaque, icanti: —Jeri irinta Irovejajaniquite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iroompaqueate iquemajiavaquitiguiriqueate itsatacaane mavite ariqueate yoguijaguijaitanaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ipitsocanacaqueate Jesoshi yamenavaqueri yoguijaguijaipojaqueriqueate icantajiguiriquea: —¿Taate pininque? Iriatimpajia icantajiguiriquea: —Tsatacaantantatsica, ¿quero pichoocaqueni? ");
INSERT INTO cotNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Icanti Jesoshi: —Jameja pamenaquitero. Ariqueate yoajianaque yamenaquero, ariqueate isaviquimotapanajantiri oratica savincaguiteri, iroorijite tsaparoncaguitetanaja catsirincaiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Apaniroqueate quemavaquerica Joanca oguijatanaquerica Jesoshi, iriguenti Antirishi iriguentijeguite Shimo Peerero. ");
INSERT INTO cotNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ariqueate iriatimpa iroqueti yoaquiti icoaguequitiri iriguentijeguite, inejapojaqueriqueate icampojiri: —Nonejajiaqueri Meshiashi —ocantaque: “Quirishito.” ");
INSERT INTO cotNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ariqueate itsipatanacari ichoocaquegueti Jesoshi. Iroompa yamenavaquerigueti icantiri: —Aviguenti Shimo, irijanite Jonashi. Imaicaquea imaica pincantajempa Sepashi —ocanque: “Peerero”. ");
INSERT INTO cotNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Osavincaguitetanajiguetiqueate iroanaje Jesoshi Garireaqui. Ariquea inejaqueri Jeripe icantiriquea: —Poguijatanaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Iriraqueate Jeripe ari iguintenita Vetsairaqui iguintenitagueti Antirishi aisa Peerero. ");
INSERT INTO cotNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ariqueate irira Jeripe yoanaquequeate icoaguequitiri Natanaere, iroompaqueate inejapojatiguiri icantiri: —Nonejajiaqueriquea irira itioncacotanaqueca Moishishini coramani jerijia aisa itsipa tsavetantajiatsica. Iriguentiqueate Jesoshi Nasarequitica, irijanite Jose. ");
INSERT INTO cotNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Icantiriqueate Natanaere: —¿Choocampaca cameetsatatsica poneanquitsica Nasarequi? Icantiriqueate Jeripe: —Caacatejate pamene. ");
INSERT INTO cotNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iriraquea Jesoshi iroompaquea inejavaquitatiguiri icoraquepojaquegueti Natanaere iquenquetsatacotavaqueri icanti: —Jeri ishiraerimajaca. Iriatimpa tee iramatavijanteji. ");
INSERT INTO cotNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Icantiri Natanaere: —¿Queroquea picocani pitsatantavaquenaca? Icantiriqueate Jesoshi: —Nonejitsiquempiquea incajaranqui pitsimampeacarogueti iguera tequeratagueti incajemempiji Jeripe. ");
INSERT INTO cotNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ariqueate icantanaquequeate Natanaere: —Tsatacaantantatsica, aviguentiqueate Irijanite Aapani Irioshi, aviguentiqueate Imajirote ishiraerijia. ");
INSERT INTO cotNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Icantiri Jesoshi: —Piquemaquitatigana nocanquempigueti nonejaquempi pitsimampeacarogueti iguera ¿irootaquempa pitsatantapojacaroca picanquenaca imaica? Coajicaqueate pamenaguetavaqueroqueate otsipapae anaaqueroneca oca. ");
INSERT INTO cotNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ariqueate icantiri aisa Jesoshi: —Imaicaquea noncamantamajajiaquempi, coajicaqueate pamenajiavaqueroquea inquite ontanarejanaquempagueti. Iriraqueate irashivantijitete Aapani Irioshi iroaroaitanaque jenoqui, ariquea iraguijiguijitashitapojeri Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aapojacagueti 3 savincaguiteri ishineventajiacaro imanquigacagueti shirampari Canaaqui Garireaqui. Ariqueate ochoocataquequea oraniqui iriniro Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Icajemacaantajiqueriqueate Jesoshi jerijiaquea aisa itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ariqueate oteroncanacaqueate vinoja. Oraqueate iriniro Jesoshi oashitanaqueriquea ocamantaqueri ocantiri: —Teroncanaca vinoja. ");
INSERT INTO cotNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Cotanquitsiqueate Jesoshi icantiro: —¿Querocate ocotacani, manquigarentsi, picantantaquenaca naatimpa? Tequeratatirajanica aguempaji nonigaantaquempa. ");
INSERT INTO cotNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Cotanquitsiqueate iroatimpa ocantajiguiriqueate quitajatantiroca vinoja: —Pinetsanatavaqueroqueate taaca opaji incanquempica. ");
INSERT INTO cotNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ariqueate choocaqueate oraniqui 6 inirotsentseinapae chomo ipeacaantajitaroca mapi, iroguenti yamejiga iquivantapinijiacaca joriojia. Apaniropaequeate otserajaguetacaro oja arica 50 ritoro, arica 70. ");
INSERT INTO cotNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ariqueate Jesoshi icantajiguiriqueate quitajatantiroca vinoja: —Pishatecajaguetajero oja chomoqui. Ariqueate ishatecajaguetajiro opancojaguetanajaroquea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ariqueate icantajiguiriqueate: —Imaicaquea imaica pinquitajate capichaaji paacotanaqueneriquea vetsicacaantaqueroca ashecajiacagueti iramenanquemparoquea. Ariquea yaacojianaqueneri. ");
INSERT INTO cotNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yamenantavacaroqueate oja peananquitsica vinoja, teequeate intsateroji quero oponeacani. Iriguentijiaquea tsajiaqueroqueate quitajatantiroca, iriotari tserajajiaqueroca oja iroaqueragueti. Iroompaqueate imiraquitigaroqueate icajemaqueriqueate iriaqueraca manquigatananquitsica, ");
INSERT INTO cotNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","icantiri: —Iroorijite amejigaro iroquetica ajivajiguiro cameetsajamajatanquitsica vinoja, coajicaqueate iquemajianacagueti irooqueate iquitajaitaque teesaconaca oncameetsajamajateji. ¿Queroqueate picotacani aviatimpa teequeate ari pinquejetero imaica? Manaquea iroquetiquea pimirajiaca teesaconaca oncameetsajamajateji, irooquea pitsoteajiaca cameetsajamajatanquitsica. ");
INSERT INTO cotNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ocatica oacaantantatsica intati onigaantaqueroca iragavejane, iroguenti jivatanquitsica imapocaqueca Jesoshi, ipeacaacaroquea ontaniqui Canaaqui choocatatsica Garireaqui, yonigaantantacaroca iroganejencare, ariqueate iquemisantajiaqueri itsatacaanejia, yaventajianacari. ");
INSERT INTO cotNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ariquea yoanajiquea Caperenaoqui, itsipatanacaro iriniro, iriguentijeguitepae, jerijia aisa itsatacaanejia. Ariqueate ichoocajiaque oraniqui aparopae savincaguiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ariqueate oquempejipojigueti Paashicoa ishineventajiacaca joriojia, yoanaquequea Jesoshi Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ariqueate yoavetanacagueti teemporoqui itsaroventantajitarica Aapani Irioshi iriguentiqueate inejapoji jocantaguetirica caapironcaari aisa oveja jeriqueate aisa jocantaguetirica emoreni, ichoocajiaque oniganquirequi. Ariqueate ichoocajiaquequea aisa oguipiantaguetirica imentaquipae. ");
INSERT INTO cotNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iriraqueate Jesoshi yaanaque peatsa, yampitaguiquero ishincantajiacariqueate maasano, yoguivorocajiaqueriqueate yoguisotojaiaqueri itsipatacaantaguecariquea irovejatepae aisa igaapironcaarite. Ipishoncavoncaquitsiqueriqueate imentaquitsitepae oguipiantajiguirica imentaquipae, yapitaquiacoguequero ishitaponcaropae. ");
INSERT INTO cotNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ariqueate icantajiaqueriqueate jocantajiguirica emoreni: —Paajianajeri pemorenite ontaniqui sotsiqui. Ocaqueate itsovironaquite Aapani aatoqueate piquejetacagaro yojocantantajiguetirogueti ajaararontsi. ");
INSERT INTO cotNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iriraqueate itsatacaane ariqueate iquenquejajianaqueroqueate ocanqueca itioncacojiquerogueti ocanti: “Nontsaneamajaquemparoqueate pitsovironaquite incovaeguishejitaquerogueti, osemacaamajatanaquena.” ");
INSERT INTO cotNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Irirajia joriojia icantsijigariqueate: —¿Taaquea cantaquempi piquejetancaroca imaica? Irioca cantaquempi Aapani Irioshi iintsijate ponigaguenaroja oacaanaquenaneca intati irooquea nontsatantajiaquempaca iriguenti tigarancaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Icantiriqueate Jesoshi: —Iintsija pisoveguero ocatica teemporo, ariqueate aapojempagueti 3 savincaguiteri nontsitacajeroquea aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Icantajiguiriqueate joriojia: —Jmm aricampa, oraquea ocatica teemporo ariquea yatsipejiacaro yantajiguironi 46 ajagantsini. ¿Queroquea oncoquempani pintsitaquitsitantajemparoca aviatimpa 3 savincaguiteri? ");
INSERT INTO cotNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Cotanquitsiqueate oraquea icanquegueti “teemporo” mana icantacotaca iriatimpa iquejetacaaca intati, iroguentiquea icantacotaque itsino. ");
INSERT INTO cotNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Irootaquequeate irirajia itsatacaanejia yamenajiaquerogueti coajica ipochatanajigueti imetojavetacagueti iquenquejajianajiroqueate ocatica icanqueca iroaqueragueti, ariqueate itsajiaque arimaja ocantamajataque Itioncacaantaqueca Aapani Irioshi coramani aisa maasano icantajiaquerica Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ariqueate aapojacagueti Paashicoa choocatirajaqueate Jesoshi Jerosarequi, ariqueate oraniqui yantaguetaquero cameetsaguetatsica oacaantantanaque intati, yonigaajiaqueri yagavejica. Inejajiavaqueriquea irootaquequeate iquemisantantajianacarica oshequini, yaventajianacari. ");
INSERT INTO cotNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cotanquitsiqueate Jesoshi itsatavaqueriquea tee arimaja inquemisantamajateriji maasano, itsajiguiritari maasano caquintejiatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Teequeate incoguimentempaji incamantajitaqueri quero icojiacani, inchiquiojitsitari itsaque iriatimpa, itsamajatirotari maasano iquenquejajiaqueca caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Choocaqueate pariseo icantajitica Nicoremo, iriguenti majirontatsica tsipajiacarica itsipajia imajirojiate joriojia. ");
INSERT INTO cotNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iriatimpaqueate yoanincanaquequea tsiteniriqui irinejeri Jesoshi, ariquea icampojaqueri: —Tsatacaantantatsica, notsajiaquempi piponeaca Aapaniqui Irioshiqui pintsatacaajiaquenanijite, teenica inchoocateji agavejatsineca irantaque oacaantantatsica intati inquejetaquempiqueate aviatimpa aatogueti iriguenti tsipatari Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iriraqueate Jesoshi icantiri: —Imaica noncamantamajataquempi, quericaca aatogueti ivojai aisa, aato yagaveji inejiro imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Icantiri Nicoremo: —¿Querocampate incotanajempani quenquevari irivoantajempacate aisa? ¿Arimpate iragavejaque impianajero intsompogui omotijaqui iriniro irivoantajempacate? ");
INSERT INTO cotNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Icantiriqueate Jesoshi: —Imaicaquea noncamantamajaquempiquea, irira caarica voantaro oja, caarica aisa ivoashirentica Ishire Aapani Irioshi, aatoquea yagaveji iquiji imajirontagueti Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iriraquea ovoaqueca tsinotsi, tsinotsi inaque; iriraquea ivoaqueca Ishire Aapani Irioshi, shiretsi inaque. ");
INSERT INTO cotNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aatoquea poanaque intati nocamantaquempigueti: ‘Picoguimentaca pivojaijae.’ ");
INSERT INTO cotNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iriraquea choviga itampijataque querocagueti inintaque. Ariquea piquemavaqueri itampijatigueti ipojimajencatanaque, cotanquitsi teequea pintsateriji quero iquenajencatapoji aisa quero irojaencatanaqueni. Ariquea iquejetaca maasano ivoaqueca Ishire Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Icantsitanajariqueate aisa Nicoremo: —¿Queroquea ococani oca? ");
INSERT INTO cotNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Icantsitanajariqueate aisa Jesoshi: —Arivetacaquea aviguenti tsatacaajiguirica ishiraerijia ¿arimpate tee pintsateroji oca? ");
INSERT INTO cotNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Arimajaquea noncamantamajaquempi, manaquea nocamantajiavetaquempiro notsajiguica naatimpajia jeroquea aisa nonejaguetica, cotanquitsiquea aviatimpajia teequea pinquemisantajiavaqueroji notsatacaajiavequempica. ");
INSERT INTO cotNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Imaica nocamantajiavetaquempiqueate inejajiguetica acaniqui quepatsiqui, cotanquitsi teequeate pinquemisantajiavaquenaji. ¿Arimpate pinquemisantajiavaquena nonquenquetsatacaajiavequempirogueti choocaguetatsica inquitequi? ");
INSERT INTO cotNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Teequea inchoocateji oananquitsica jenoqui inquitequi, apaniro irira poneanquitsica inquitequi coraquetanquitsica isaviji. Irio nocantacotaque, Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Coramani iriraqueate Moishishini yogatiacotaqueriqueate quejevetarica camaarini ontaniqui oquitamampororoipojaquegueti. Ariqueate inquejetacaajitaqueri irira Irijanite Caquinte irogatiacojitaqueriquea coajica, ");
INSERT INTO cotNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aatoniji ipejaiga maasano aventajiaquemparineca, incoguitempani inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Aapani Irioshi caaviji ipintsamajatari maasano caquintejiatsica, irootaquequea ipantajiacarica Irijanite irapatiroritsite irimetojaventajiaqueri, aatonijite ipejaijaa maasano aventajiaquemparineca, incoguitempaniqueate iranijajiaje. ");
INSERT INTO cotNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Teenica irooquea intigaranquimenteri Irijanite acaniqui quepatsiqui incantacaantajiaqueriqueate caquintepae iroajianaque camorecariqui, iroguentiquea itigaranquimenqueri iraajiajateri. ");
INSERT INTO cotNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Quericaca aventaquemparineca aato icatsimatimentajitiri igovaeguishere, iriraqueate teeca iraventempariji irioquea icantacotsica Aapani incatsimatimentajiqueri igovaeguishere, teenica iraventemparoji ivajiro Irijanite Aapani Irioshi irapatiroritsite. ");
INSERT INTO cotNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jeroquea icantimentantajiacarica: icoraquevetaca Tsirencari quepatsiqui, cotanquitsiquea irirajia caquintejia iroguenti inintamajajianaque pitsecari, teequea irishineventajiavaquempariji Tsirencari, covaeguishetacatari yantajiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maasanotari antaguishejiguiroca quempevaerentsi isemamajajiacaro tsirencari, teequea incoraquetashitero aatoniji inejitajitiri yantaguishejiaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Cotanquitsi iriraquea comajamajatanquitsica icoraquetashitaquero tsirencari, cameetsanijite irinejitsijiqueriqueate yantaqueca intsajitaquerinijite iriguenti agavejacaaqueri Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ariqueate yoanaque Jesoshi Joreaqui itsipatsipaitanacariquea itsatacaanejia. Ariqueate ichoocajiaque oraniqui oshequi savincaguiteri iviñacajatantajiaquequea. ");
INSERT INTO cotNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ariqueate iquejetaca irira Joanca iviñacajatantaquequea Enonequi quempeji Sarime, choocatarite oshequi oja oraniqui. Icoraquetashipinijiaqueriqueate oshequi caquinte iviñacajajiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tequeratatirajatari irashitacojiteriji Joanca santanaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ariqueate irira itsatacaanejia Joanca itsipajiacari itsipa irapijorioteni iquenquetsatavacaaca iquenquetsatacotaquero ora taaca opajita caavijica osaancanti. ");
INSERT INTO cotNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ariqueate yoashijianaqueriquea Joanca icantajiguiri: —Tsatacaantantatsica, iriraqueate pitsipatacaca chapinqui ontaniqui intatiqueroqui Jororanequi pitsavetantaqueca imaica choocaquea iviñacajatantaque. Yoashijianaqueriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Icantajiguiriqueate Joanca: —Teequeate inchoocatimateji agavejanquitsineca inchiquioji aatogueti yagavejacaguiri irira choocatanquitsica inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aviguentiquea quemajiaquena nocamantaquempigueti teequeate naroguenti Quirishito, iroguentiquea itigaranquimenquena Aapani Irioshi nojivataqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pamenerija iriraqueate iriaqueraca manquigatanquitsica iriotaque ashintamajacaro imanquigare. Iriraquea itsipatacaca manaquea itsipatacari intati iquemisanqueriqueate iquenquetsaquegueti, ishinevencariquea intati. Ariquea noquejetaca naatimpa noshinevencariquea namenaquerigueti yoashijianaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Imaica arimaja oncotanaquempa iriatimpa arimpaquea iranaantamajatanaque, naatimpa aatosaconaquea nanaantaji. ");
INSERT INTO cotNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Iriraqueate poneanquitsica jenoqui yanaamajataqueri maasano. Iriraqueate quepatsiquitica iquejejiacariqueate igonorojia, manaqueate iquenquetsatacoguetaquero inejaguetica quepatsiqui. Iriraqueate poneanquitsica inquitequi yanaamajataqueri maasano, ");
INSERT INTO cotNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","iroguenti itsavetantagueque inejaguetica, iquemaguetica, cotanquitsiquea tee inquemisantajitavaqueroji itsavetantaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Cotanquitsiquea quericaca quemisantamajatavaqueroneca incanquequea arimajaquea icantamajataque Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aritarite iriraquea itigarancaqueca Aapani Irioshi iquenquetsataque icanqueca Aapani Irioshi, teenica intsaneguempariji Aapani Irioshi Ishire. ");
INSERT INTO cotNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aapani Irioshi ipintsamajatacari Irijanite, yojocaqueneriquea maasano choocaguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iriraquea aventacarica Irijanite Aapani Irioshi, yashintacaro anijagantsi coguitatsineca. Irirampani teeca irininteji inquemisanteri Irijanite Aapani Irioshi, aato yameniro anijagantsi, manaquea ocancani ochoocaqueri igatsimare Aapani Irioshi.” ");
INSERT INTO cotNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ariquea pariseojia iquemacojiaqueriqueate Jesoshi arimpa yoshequiaqueri itsatacaanejia, caavijiquea yanaantaque iviñacajatantaguetanaque, yanaanaqueriquea Joanca. ");
INSERT INTO cotNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Cotanquitsi teequea arimaja irio viñacajatantatsine Jesoshi, iriguentiquea viñacajatantanquitsiquea itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ariqueate iriraquea Jesoshi iroompaquea iquemacocagueti iquenquetsatacojiqueri, isotoantanajaro Jorea, yoanajiquea Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Oraquea yoanajigueti manaquea iquenanaji Samariaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oraniquiqueate Samariaqui yarejetapojacaro guinteninintsi icantajitica Shicare oquempejiquero quepatsi yashintavecaca Jacovoni coramani yojocanajinirica irijanite icantajitica Jose. ");
INSERT INTO cotNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ariqueate ochoocataque oraniqui oja iqueecacotinica Jacovoni. Imagotapojiqueate Jesoshi yanijitaquegueti quenavoquirontsiqui, ariqueate isavicapoji oraniqui. Tampaticapojaque catsirincaiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Iriraqueate itsatacaanejia yoajianaquequeate ochoocatigueti tsovironaquipae irivegarajigue irishecajiaquempaca. Iriraqueate Jesoshi inejatiguiro ocoraquepojaque manquigarentsi guintenitaroca oraniqui Samariaqui aajate oja, icantiroquea: —Pojoquenajate nomire. ");
INSERT INTO cotNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ocantiriquea manquigarentsi Samariaquitica: —Aviguentitari jorio, naatimpaquea naroguenti Samariaquitica. ¿Quero ocotacani pamanantaquenaca naatimpa oja pimire? (Iriraqueate joriojia imanintajiguiritari Samariaquitica.) ");
INSERT INTO cotNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Icantsitaroqueate Jesoshi: —Pintsaqueromegueti irojocaquempica Aapani Irioshi, aisa pintsaquerime amanaquempiroca imire, pamanaquerime iriatimpa, irojocaquempime oja anijacaantantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ocantiri manquigarentsi: —Teenica onchoocateji paajatanquemparoca, aisa ocatica oja ochoocavaetaque jmm isaviji. ¿Querocaquea paaqueroni oja anijacaantantatsica pojocaquenaca? ");
INSERT INTO cotNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Arimpate panaaqueri avaesatiniteni Jacovoni queecacotanaqueroca ocatica oja? Iroguentitari imirapinitaca iriatimpa, jerijia irijanijiate, jerijia aisa ivirapae. ");
INSERT INTO cotNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Icantiroquea Jesoshi: —Maasano miracaroca ocatica oja irimiretanajequeate aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Cotanquitsiquea iriraquea miraqueroneca oja nojocaquenerica naatimpa aatoquea imiretaji. Ocaticaquea oja nojocaquenerica ompeanajempa motojaaro omotoajashirentanaque ishirequi, onchoocatacaaqueri incoguitempaniniji iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ocantiriquea manquigarentsi: —Intsishia pojoquenaroja oratica oja nomirerota aatonijite nomiretaji, aatoniji nocoraquetaji acaniqui noncajapinitaje. ");
INSERT INTO cotNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ariqueate icantiroqueate Jesoshi: —Iintsija pincajemaquiterija manquigatimpica, pincoraquetajequea aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ocantiriqueate: —Teequeate inchoocateji manquigatanaca. Icantsitajaroquea Jesoshi: —Pitampaticataquero picanquegueti tee inchoocateji manquigatimpica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ichoocavetaca manquigavetimpica oshequi, ivegaravetaca 5. Iriraqueate pitsipatajaca imaica, teequea irio pimanquigare. Picantamajataque. ");
INSERT INTO cotNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ocantsitariquea manquigarentsi: —Nomajirote, nonejaquempi aviguenticajate tsavetantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Irirajia novaesatinite manaquea itsaroventapinijiacari Aapani Irioshi acaniqui otsempiqui. Aviatimpajia joriojia picantajiaque iroguenti Jerosare antsaroventantaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Icantiroquea Jesoshi: —Iintsijate, manquigarentsi, pinquemisantavaquenaja noncamantaquempigueti. Aapojempa savincaguiteri aatoquea pitsaroventajiajari Aapani Irioshi acaniqui otsempiqui, aato aisa Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aviatimpajia Samariaquitica teequea pintsajigueriji pitsaroventavetacaca, manaquea pitsaroventamampeajiacariquea intati. Naatimpajia joriojia notsajiguiri notsaroventacaca, aritarite irira Meshiantatsica, jorio inaque. ");
INSERT INTO cotNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cotanquitsiquea imaicaquea aapojaca savincaguiteri irira tsaroventamajajiacarica Aapani Irioshi intsaroventajiaquemparigueti onquenavaetanaque intsompogui ishirequi, intsaroventamajajiaquemparitari. Irootaquetari ininque Aapani inquejejiaquempa imaica intsaroventaquemparigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iriraqueate Aapani Irioshi shiretsi inaque. Quericacaquea tsaroventarica intsaroventajiaquempari ishirequi, aisa arimajaquea intsaroventamajajiaquempariquea. ");
INSERT INTO cotNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ocantiriquea manquigarentsi: —Notsaquequeate incoraqueque Meshiashi icantajitica Quirishito. Oraquea incoraquequegueti incamantamajajiaquenaquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ariquea icantiroquea Jesoshi: —Iriguentitari quenquetsatacaaquempica imaica, naroguentitari. ");
INSERT INTO cotNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ariqueate icoraquejiapojajiquea itsatacaanejia. Yamenajiapojaquerigueti iquenquetsatacaaquerogueti manquigarentsi mana yamenajianaque intati, cotanquitsiquea tecatsi cantapojerine: “¿Taa opaji pininque?” Tecatsi cantatsine: “¿Quero ocotacani piquenquetsatacaantacaroca?” ");
INSERT INTO cotNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iroompa iroatimpa ojoquijipanajantiroqueate intati icajantajitaroca oja, oanaquequeate ontaniqui oguinteniqui ocantajiapojaqueriqueate ogonorojia: ");
INSERT INTO cotNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Caacateshiatsi pamenajiaquiterija irinta caquinte, icanquenaqueate maasano nantaguishequeca. ¿Taaca ipaji? ¿Irioca Quirishito? ");
INSERT INTO cotNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ariqueate yoayoaitanaque yoguijaguijaitanaqueroqueate yamenapojiri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Irirajiaquea itsatacaanejia iroompaqueate yamenajiavaquerogueti oanaquegueti oncantajiaquiteri, icantajiguiriqueate Jesoshi: —Tsatacaantantatsica, pishecatempa. ");
INSERT INTO cotNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Icantiqueate iriatimpa: —Naatimpa choocatari nosheca teeca pintsajigueji aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iriatimpajia icantavacaajianacaquea: —¿Choocampa amaquenerica isheca? ");
INSERT INTO cotNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Cotanquitsiquea Jesoshi icantajiguiriquea: —Iroguenti nosheca nantaqueneriqueate ininqueca tigarancaquenaca, ariquea nonteroncaqueneri nonetsanamajaqueroquea maasano icanquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Picantajiaveca: ‘Cuatrotiraja taai osampatantanaquempaca oitsoqui iraviguijitaqueroqueate.’ Cotanquitsiqueate naatimpa noncantajiaquempiqueate iintsija pamene, pamenajigueroquea niganquitejirentsipae, jac sampatanaque oitsoqui, pajiniquea irajaitero. ");
INSERT INTO cotNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iriraqueate aguiroca oitsoqui irivegarajiqueriquea irishinevaequempanijite tsaquiroca intsipaquempariquea aguiroca. Iriguentitari quejecaroca oitsoqui irirajia iquemisantacaajitaqueca incoguitempaniniji inchoocaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Arimajaqueate icantamajajiqueroqueate: ‘Apaniroquea tsacaqueroca, itsipaquea aajeroneca.’ ");
INSERT INTO cotNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naatimpaqueate notigarancajiaquempi paajiaqueroqueate teeca aviro tsacajiguerone. Itsipaqueate tsacajiaqueroca, imaicaquea aviguentiquea aajiaquero yatsipeventajiacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ariquea oshequi Samariaquitica guintenitantaroca oratica guinteninintsi iquemisantajianaqueriquea Jesoshi iquemajiavaquerogueti manquigarentsi otsavetantaquerigueti, ocanti: “Icantaquena maasano nantaguetaqueca.” ");
INSERT INTO cotNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iroompa icoraquejiaquegueti Samariaquitica, inejajiapojaqueriquea icajemajiaqueri irimaimojiaqueri. Ariqueate yoanaque imaanaque mavite savincaguiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ariquea iquemisantajiaqueriquea ontaniqui itsipajia oshequi, iquemamajajiaqueritarite iquenquetsaquegueti iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ariqueate icantajiaqueroqueate manquigarentsi: —Noquemisantajiaque pitsavetantaquerigueti aviatimpa, cotanquitsi imaica caaviji noquemisantamajajiaque, inchiquiojitari noquemajiaqueri naatimpajia, ariquea notsatanaque arimajasacanicate iriguenti meshiajiaquerineca quepatsiquitica, iriguenti Quirishitotatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iroompa avisanaquitigui mavite savincaguiteri yogaanajaquea Jesoshi yoanaji Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Icantaquetarite iriatimpa Jesoshi, iriraqueate tsavetantatsica tee irishineventajitempariji iguinteniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iroompa yarejetapojatiga Garireaqui yaajiavaqueri cameetsa choocajiatsica oraniqui, yoajiaquititarite iriatimpajia aisa Jerosarequi yogavisajaiaquitirogueti Paashicoa, ariqueate yamenajiaqueri yantaguequeca oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ariqueate ipianajaquea Jesoshi Canaaqui Garireaqui oraniqui ipeacaacarogueti oja vinoja. Choocaqueate iramajirore majirontatsica iguintenitacaqueate Caperenaoqui, yojoquijicaquea irijanite. ");
INSERT INTO cotNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ariqueate iriatimpa iquemacotavaquerigueti Jesoshi arejetapoja Garireaqui iponeacaquea Joreaqui, yoanaquequea icantapojaqueri iroanaqueniji itsovironaquitequi irogueshitajeneriquea irijanite, pajiniquea irimetoje. ");
INSERT INTO cotNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iriraquea Jesoshi icantiri: —Aviatimpajia aatoguetiqueate pamenajigana nantaguetaquerogueti oacaantantatsica intati, aatoquea pitsaroventajigana. ");
INSERT INTO cotNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Icantiri iramajirore majirontatsica: —Nomajirote, caacateshiatsi pajini irimetoje irijani. ");
INSERT INTO cotNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Icantiriqueate Jesoshi: —Pimpianajequea imaica, anijatsi pirijanite. Iriatimpa iquemisanqueriqueate icanquerica, yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iroompaqueate yoanajigueti pajinigueti irarejetajempa itsovironaquitequi itonquivojajiavacariquea amitacojiguirica icantajiavajiriquea: —Anijatsi pirijanite. ");
INSERT INTO cotNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Icoacotavaqueri iriatimpa queroquea icarataqueni catsirincaiteri ipeantanajaca. Icantajiguiriqueate: —Chapinqui iroaqueragueti icononcanaja catsirincaiteri ari icotanaja isavogatanaji ipeanaja. ");
INSERT INTO cotNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ariquea iquenquejanaquero aritarite iroaqueragueti icononcanaja catsirincaiteri icantaquegueti Jesoshi: “anijatsi pirijanite.” Irootaquequea iquemisantantanacarica itsatantacaca iriomajaca, ariquea iquejejiaca aisa maasano conoajiacarica. ");
INSERT INTO cotNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ocaticaquea iroguenti mavitetapojatsica oacaantantatsica intati yonigaantaqueca Jesoshi iponeacagueti Joreaqui yoanajigueti Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ariquea irirajiaqueate joriojia icapiocajiacaqueate irogavisaajiajero otsipa savincaguiteri ishineventajiacaca, ariqueate yoanaque Jesoshi itoncoanaque Jerosarequi. ");
INSERT INTO cotNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oraniquiqueate Jerosarequi oquempejiquegueti osotomoro icantajitica Isotomoro Oveja ariqueate ochoocataque osamponaja, icantajitiro evereotsaqui Veteshita. Chooca oraniqui icatisetajiguetica tsovironaqui ovegarataca 5. ");
INSERT INTO cotNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Irootaquetari inorijantajiga oshequini caquinte joquijiguetanquitsica, shamponcajaripae, itsipajia teeca incatigueji, itsipajia magoviroshitatsica. Yoguijajiaqueroqueate omparencajatavajempata oja. ");
INSERT INTO cotNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Icoraquepiniquetari irashivantite Aapani Irioshi iparencajatapojiro, ariquea quericaca iriquetica quijaatanquitsica iquenapanajanti ipeanaja. ");
INSERT INTO cotNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Choocaqueate apaniro oraniqui yojoquijitani iriquetinica, teequea impejaempaji yajagantsitacovaetanacaqueate aavaetanacaqueate 38 ajagantsi. ");
INSERT INTO cotNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iriraqueate Jesoshi inejapojaqueriqueate norijaca, itsapojaqueri yajagantsitacovaetanaque coramani teequea impejaempa, icantantacarica: —¿Pininque pimpeanajempa? ");
INSERT INTO cotNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yacanaqueri joquijitanquitsica: —Nomajirote, teequea inchoocateji jocajatavaquenaneca oparencajatacagueti oja. Nopitsopitsovecaqueate naatimpa inchiquioji teequea nagavejempaji, manaqueate yanajaitanaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Icantiriqueate Jesoshi: —Iintsija pincatianaje pinatanajero pinorijantacaca, panijitanaje. ");
INSERT INTO cotNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Iroompaquea icanquitiguiri ariquea ipeanaja, inatanajiro inorijantacaca, yanijitanaji. Cotanquitsiqueate iroguentiquea savincaguiteri imagorejantajitaca, ");
INSERT INTO cotNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","icantantajiacacaqueate imajirojiate joriojia: —Imaicaqueate iroguenti savincaguiteri imagorejantajitaca, tee oncameetsateji pinatanajerogueti pinorijantacaca, icantimentantajitirotarite. ");
INSERT INTO cotNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Iriatimpa icantiriqueate: —Iriraquea ogueshitajanaca iriguenti cantaquena: ‘Pinatanajero pinorijantacaca, panijitanaje.’ ");
INSERT INTO cotNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ariqueate icantajiaqueriqueate: —¿Queriquea cantaquempica: ‘Pinatanajero pinorijantacaca, panijitanaje’? ");
INSERT INTO cotNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cotanquitsiquea iriatimpa teequea intsateriji queri ogueshitajirica, icapiocajiacatari, iriraquea Jesoshi jac yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ariquea Jesoshi inejapojajiri teemporoqui itsaroventantajitarica Aapani Irioshi icantiri: —Imaicaqueate peanajimpi, aatoquea papijitajiro aisa piquempevaetaja, aapojajimpitsi otsipa anaaqueroca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iriatimpa yoanaquequeate icamantajiaqueriquea imajirojiate joriojia, icantajiapojaqueriqueate: —Iriguenti ogueshitajana Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Irootaquequea icatsimatantajiacarica joriojia Jesoshi, inintajiavecaqueate irimetojajiaquerime, yamenajiaqueritarite iroguenti yogueshitantajari savincaguiteri imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Cotanquitsiqueate Jesoshi icantajiguiriquea: —Ari icoca Aapani irosati yantaguitini, ari noquejetacari naatimpa aisa, irosati nantaguitini. ");
INSERT INTO cotNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Irootaquequea arimpaquea icatsimamajatantajianacarica imajirojiate joriojia, inintamajajianaque irimetojajiaqueri, teenica aparo irogueshitantantemparo savincaguiteri imagorejantajitaca, manaqueate aisa iquejemanatanacari Aapani Irioshi icanquegueti iriguenti Iririmajaca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ariqueate icantajiguiriqueate Jesoshi: “Imaicaquea noncamantamajaquempiquea, iriraquea Irijanite Aapani Irioshi, oraqueate yantaqueca teequea inchiquioji irantashitemparo iriatimpa, iroguentiquea yantaque yamenacoquerica yantaguetica Iriri. Querocaca isavicaventica Iriri, irootaquequea isavicaventaque iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iriraquea Iriri ipintsamajatacaritari Irijanite, yonigaaguetaqueneri maasano yantaguetica. Ariquea ironigaaqueneri otsipapae anaaqueroneca pinejajiaqueca imaica, aviatimpajia pamenajianaquequea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aritarite quejetaca irira Aapani itancorejajiguiriqueate metojajiavetanquitsica, yanijacaajiajiri, ariqueate iquejetaca Irijanite, iranijacaajeriquea quericaca ininqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aisa irira Aapani tee irionica cantatsine queri irogashinoncajajiqueca, iriguentiquea Irijanite icanque incantacoqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ariquea iquejetaquero imaica cameetsaniji maasano irishineventamajajiaquempariniji Irijanite inquejetacaajiaquemparinijite ishineventajiacarigueti Iriri. Quericaca teeca irishineventajiguempariji Irijanite teequea irishineventajiguempariji Iriri tigarancaquerica. ");
INSERT INTO cotNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Imaicaquea noncamantamajajiaquempiquea, maasano inquemaquerogueti nocanqueca aisa inquemisanquerigueti tigarancaquenaca incoguitempaniquea inchoocaguiteni, aatoquea icatsimatimentajitiri igovaeguishere, manaquea yojocanajiro metojagantsi, yarejetapojaja anijagantsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aisaquea noncamantamajajiaquempiqueate, aapojempa savincaguiteri, jac aapojacatari imaica inquemantajiaquemparoca metojajiatsica icanqueca Irijanite Aapani Irioshi, ariqueate maasano quemisantajiaquerica iranijajianaje. ");
INSERT INTO cotNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iriraqueate Aapani yanijashitacatari intati, iriotari anijacaantantatsica. Ariquea inintacaaqueri Irijanite iquejetancarica yanijashitaca iriatimpa, aisa iriguenti anijacaantantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aisa icanqueriqueate iriotaque cantacotaquerine caquinte quero incojitaquerini, iriguentitari Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aatoquea pamenajianaque intati, aapojempatarite savincaguiteri inquemantajiaquemparica maasano iquitajivetacaca, ");
INSERT INTO cotNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ariquea incampanajante irisotoajianajequea. Iriraquea comajamajajianquitsica intancorejajianajequeate, iroajianaquequea jenoqui inquitequi, incoguitempani inchoocajiaje. Iriraquea teeca incomajamajajiguempaji intancorejajiavetanajempaquea manaqueate incatsimatimentajiqueriqueate igovaeguishere. ");
INSERT INTO cotNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Teequeate nantashitempajiqueate inchiquiojitsita. Querocaca icanquenaca Aapani, irooqueate nocanque naatimpa, aisa notampaticamajataquero maasano nocanqueca, teenicate iroguenti noncoraquetashite nantaquero querocaca noninqueca naatimpa, iroguentiqueate nocoraquetashique nantaqueroquea maasano inintaguetica Aapani tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Oraquea apanirome nontsavetanquempamequea naatimpa arimequea pincantajiaqueme: ‘Aatoquea noquemisantiri, irisati tsavetacotajatsi.’ ");
INSERT INTO cotNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Cotanquitsiqueate choocaqueate itsipa tsavetantaquenaca. Naatimpa notsataque arimaja icantamajataque itsavetacotaquenagueti, teequea iramataguempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pitigarancaquerigueti coacoquerineca Joanca, iriatimpa tampatica yoavaquero itsavetanquero iroomajatatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Cotanquitsi itsavetacojitaquenagueti, teequea iro noshineventavacaca oratica poneanquitsica caquintequi, manatari noquenquejacaaquempirotari itsavetacotaquenagueti Joanca cameetsaniji pimeshiajiaquempaniji. ");
INSERT INTO cotNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iriraquea Joanca iquejevecari tsivorentsi morecanquitsica itsivotaquequeate. Aviatimpajia iro pinintajiaquequea pishineventapanajantaro itsivotacojiaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cotanquitsiquea chooca tsavetantaquenaca anaaqueroca itsavetanquenagueti Joanca. Oraquea nantaguetaquerogueti icanquenaca Aapani, caavijiquea anaantaque pintsatimentajiaqueronijite arimajaquea iriguenti tigarancaquena Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ariquea iquejetaca Aapani tigarancaquenaca itsavetantaquenaquea iriatimpa, cotanquitsiquea aviatimpajia teequea pinquemajigueroji icanqueca, aisa teequea pinejajigueriji quero icotani. ");
INSERT INTO cotNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ariquea oquejetaca iguenquetsatsare teequea onchoocamajateji pishirequi, teetarite pinquemisantajiavaqueriji itigarancaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aviatimpajia papatsajavantapinijiavecaroquea Itioncacaantaqueca Aapani Irioshi pijijiaqueroji irooqueate anijacaajiajempine pincoguitempaniniji panijaguiteni. Iroguentiquea tsavetantaquenaca naatimpa, ");
INSERT INTO cotNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","cotanquitsiquea tee pinintajigueji pincoraquejigue naatimpaqui panijantajiajempaca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Tee naashitemparoji irishineventajiaquena caquinte, ");
INSERT INTO cotNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","cotanquitsi notsajiaquempi aviatimpajia, tee pimpintsajiguempariji Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naatimpa iriguenti tigarancavetaquena Aapani, aviatimpajia teequea paajiavaquena. Cotanquitsiquea incoraquequegueti itsipa teeca intigarancajiteriji inchiquiogueti iriatimpa incoraquetashiquempa, irioquea paajiavaque. ");
INSERT INTO cotNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Manatari piquenquejajiaque pishineventavacaajiaquempa intati, teequeate iroguenti pinquenquejajigue irishineventajiaquempi Irioshimajaca apatiroti icota. Piquejejiacagueti imaica ¿quero pincojiaquempani pinquemisantajigue? ");
INSERT INTO cotNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aato piquenquejajigui pijijiaqueji noncamantaqueriquea Aapani teegueti pinquemisantajigueji. Choocaquea itsipa camanquerineca, iriguenti Moishishini paventamajajiavetacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Oraqueate pinquemisantamajajiaquerime Moishishini, pinquemisantajiaquename naatimpa aisa, naroguentitari itioncacotaque. ");
INSERT INTO cotNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Teenica pinquemisantajigueroji itioncavecaca, ¿arimpate pinquemisantajiaquero nocanquempica naatimpa?” ");
INSERT INTO cotNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ariqueate Jesoshi imontejacojianaca intatiquero iniromotijaqui icantajitica Garirea, icantajitiro aisa Tiveriashi. ");
INSERT INTO cotNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Choocaqueate oshequini caquinte guijaguijaitapiniquerica, yamenajiaqueritarite yonigaantaguequerogueti oacaantantatsica intati yogueshijiajirigueti joquijiguetatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iriraquea Jesoshi yoanaque otsempiqui itsipatsipaitanacari itsatacaanejia, isavicajiapoji ontaniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irooshipojaque aantapojempaca savincaguiteri Paashicoa ishineventajigaca joriojia. ");
INSERT INTO cotNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ariqueate Jesoshi yamenajiavaquerigueti icoraquecoraqueipoji oshequini caquinte, icantiriquea Jeripe: —¿Queroquea avegarajiaqueni pan ashecatacaajiaquemparica maasano iricajia? ");
INSERT INTO cotNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Manaqueate icanquegueti Jesoshi imaica iramenaque queroqueate incante Jeripe, cotanquitsiqueate iriatimpa itsaquequea queroquea iraaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Iriraqueate Jeripe icantiri: —Jmm arigueti avegarajiavetaquempagueti oshequi pan vegaratanquitsica 200 tenario, aato otsitacari irishecajiaquempa apaniropae capichaji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ariqueate icantanaquequeate itsipa itsatacaane Jesoshi icantajitica Antirishi, iriguentijeguite Shimo Peerero, icantiri: ");
INSERT INTO cotNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Jeri irica chaajaniquitirajaca yamaque ovegarataca 5 pan ipeacaantajitaca oitsoqui sevara, jeri aisa mavipaquite ishimate, cotanquitsi yoshequiamajatatiguinimaja caquinte, ¿arimpate intsitacajiaquempari? ");
INSERT INTO cotNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iriraquea Jesoshi icantiquea: —Iintsijate pincantajigueriqueate maasano irisavisaviitaque. Oraniquiquea chooca oshequi cataroshi. Ariquea isavicajiaque maasano. Iriraqueate shiramparijia jmm icarajiavaetaque 5,000. ");
INSERT INTO cotNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ariqueate Jesoshi yaaqueroquea pan yajiricaquero, yamanaqueriquea Aapani Irioshi, icantaqueri: “Arioteesaa.” Yojocajiavaqueneriquea maasano savisaviitanquitsica. Ariqueate iquejetacaacari shima yojocajiaqueneri querocaca ininqueni. ");
INSERT INTO cotNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iroompa iquemapojacagueti icantajiguiriquea Jesoshi itsatacaanejia: —Paaguetajeroquea choocaguetajatsica aatoniji opomatsata capichaji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yaaguetajiroquea iteguetajiro cantiriqui. Ochoocavetacaquea 5 pan, jeroquea imaica iquemajianacarogueti maasano ochoocataji otseraiquitanajaroquea ocarataji 12 cantiri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ariqueate yamenajiaquerogueti maasano yonigaanquerogueti Jesoshi oacaantantatsica intati yoshequiaquerogueti pan icantajianaquequea: —Arimajasacanica iriotaque tsavetantatsica aquemacoqueca coramani incoraquetaque quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cotanquitsiqueate Jesoshi itsataque inintajiavetacaquea irajaiaquerime impeacaajiaquemparime imajirote, itsinampirejajianajiri, apaniro yoanaji otsempiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ariqueate pajinigueti ompitsecanaque irirajia itsatacaanejia Jesoshi yagategateitanajiqueate omotijaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Itejiapojajaroquea quenajarontsi imontejacojianajaquea intatiquero iroaroaitanajequeate Caperenaoqui. Pitsecanajiquea, iriraqueate Jesoshi tequerata incoraquetajeji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ariqueate icampojiquea choviga jeoc jeoc jeoc jeoc itamacosejaatanaqueroquea. ");
INSERT INTO cotNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ariqueate yoacojianaque niganquija arica 5 irooca 6 quiromeetero, inejajiavajiri Jesoshi icoraquepojajiquea yanijijatapojiroquea jenoquija oja, icantajiaquitiquea neguic, itsaroajianaquequea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Cotanquitsiqueate iriatimpa icantajiguiriquea: —Naroguenti, aato pitsaroajigui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ariqueate iriatimpajia ishinejianaja intepojajempa, ariquea oquenapanajanti agapojaji otsapijaqui Caperenaoqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ariquea osavincaguitetanajigueti maasanoquea capiocaventajiacarica Jesoshi chapinqui iquenquejajianajiroquea yamenajiavajirigueti itsatacaanejia yoanajigueti teequea intsipajianajempari iriatimpa. Aisa teequea onchoocateji otsipa quenajarontsi, apatirotitari choocatanquitsi itehiteitanajaca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iroompa ocoraquepojaque otsipapae quenajarontsipae Tiveriashiquitica agaguetapojiqueate oquempejiquegueti ishecajiacarogueti pan, icantacoventaquerogueti Amajirote: “Arioteesaa.” ");
INSERT INTO cotNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ariqueate yamenajiaquegueti iriatimpajia tee inchoocateji Jesoshi irisati itsatacaanejia, itehiteitanaja yoayoaitanajiquea Caperenaoqui incoaguetajeri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ariqueate yarejerejeipojacagueti inejajiapojajiriquea Jesoshi icantajiapojiriquea: —Tsatacaantantatsica, ¿quero icaratini parejetaca acaniqui? ");
INSERT INTO cotNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Cotanquitsiqueate Jesoshi icantiri: —Imaicaquea noncamantamajajiaquempi teequeate iroguenti pincoimentajiguena pamenajiaquenagueti nonigaanquerogueti oacaantantatsica intati, iroguentiquea picoimentajiaquena pishecajiacaro pan piquemajianaca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aatoquea iroguenti pitampishiventamajajigui pisheca teroncanajatsineca, iroguentiquea pintampishiventamajajigue pisheca aatoca oteronca, oncoguitempani anijacajaempiquea. Irooquea irojocajiaquempica Irijanite Caquinte, iriotarite ijicotaqueca Aapani Irioshi, quejetaca iseyotaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iriatimpajiaqueate icantajiguiriquea: —¿Queroquea noncojiaquempani nontampishiventantajiaquemparoca inintacajaiaquenaca Aapani Irioshi? ");
INSERT INTO cotNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Icantajiguiriqueate Jesoshi: —Jeroquea inintacajaiaquempica Aapani Irioshi pintampishiventamajajiguero: paventamajajiguempari iriraquea itigarancaqueca, pinquemisantamajajianaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Icantajiguiriqueate: —¿Taa opajita ponigaajiaquenaca cameetsaniji namenajiaquerogueti nonquemisantajiaquempiniji? ¿Taa opaji pantaguetaque ponigaantaguetaque? ");
INSERT INTO cotNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Coramani ichoocajiavetacagueti avaesatinite ontaniquiqueate oquitamampororoipojaquegueti ishecajiacaroquea manaa. Oraquea itioncacojiquerogueti ocanti: ‘Yojocajiaqueneriqueate pan poneanquitsica jenoqui inquitequi.’ ");
INSERT INTO cotNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iriraquea Jesoshi icantajiguiriqueate: —Imaicaquea noncamantamajajiaquempiquea, teequeate irio Moishishini jocajiaquempiroca pan poneanquitsica jenoqui inquitequi, iriguentiquea Aapani jocajiaquempiroca iroomajaca panmajaca poneanquitsica jenoqui inquitequi. ");
INSERT INTO cotNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Oraqueate pan yojocaquempica Aapani Irioshi, irooqueate poneanquitsica jenoqui inquitequi anijacaajiaquerica quepatsiquitica. ");
INSERT INTO cotNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ariqueate icantajiaqueri: —Nomajirote, pincoguitempaniquea pojocapinijiaquenaro oratica pan. ");
INSERT INTO cotNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Icantiri Jesoshi: —Naroguentitari pan anijacaantantatsica. Irira coraquetashitaquenaneca aatoquea itaseimataji. Ariqueate inquejetaquempa aventaquenaneca, aatoquea imiretimataji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cotanquitsi nocamantajiavetaquempitari pamenajiavequenaquea teequeate pintsajiguenaji, tee paventajiguenaji pinquemisantajiguenaji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Maasano yojocaquenaca Aapani, incoraquetashitaquena; irira coraquetashitaquenaneca aato noguipiavaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Teenica iroguenti noncoraquetashite acaniqui quepatsiqui nantaque noninqueca naatimpa, mana noponeacagueti jenoqui inquitequi iroguentiquea nocoraquetashitaque nantaqueroquea ininqueca tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iroguenti ininque Aapani tigarancaquenaca aato noguipeguiri apaniro yojocaquenaca, manaquea novochantajiajeri intati aapojaquempagueti savincaguiteri vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ininquetari Aapani tigarancaquenaca incoguitempaniquea inchoocaque maasano amenajiaquerineca Irijanite, aventajiaquemparineca. Ariquea naatimpa novochantajiajeri aapojaquempagueti savincaguiteri vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ariquea icantimanajianaqueri joriojia iquemajiaquerigueti icanquegueti: “Naroguenti pan poneanquitsica jenoqui inquitequi.” ");
INSERT INTO cotNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Icantajiguiqueate: —¿Teecajate irio Jesoshi irijanite Jose? Atsajiguiritari iriri aisa iriniro. ¿Quero ococani icantantacaca ‘Noponeaca jenoqui inquitequi’? ");
INSERT INTO cotNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Icantsijigariquea Jesoshi: —Aato picantimanatantajigui picantavacaajiacagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aato icoraquetashitana caquinte aatogueti icajemashirentiri Aapani tigarancaquenaca. Ariquea naatimpa novochantajeri savincaguiteriqui vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ocanquetarite itioncajiaqueca tsavetantajiatsica ocanti: ‘Aapani Irioshi intsatacaajiaqueriquea maasano caquinte.’ Maasanoquea quemajiavaquerica Aapani, intsajiavaquerogueti icanqueca, incoraquetashiquena naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tee noncanteji imaica chooca nejaquerica Aapani. Apaniro irira poneanquitsica Aapaniqui Irioshiqui, irio nejaquerica Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nocamantamajajiaquempiquea quericaca avempojenaneca incoguitempaniquea inchoocataje, aatoquea imetojaji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naroguenti pan anijacaantantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Coramani ichoocajiavetacagueti pivaesatinite ontaniqui oquitamampororoipojigueti ishecajiavecaroqueate manaa, cotanquitsiquea imetojajiajiquea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Cotanquitsiqueate ocatica pan noquenquetsatacotaqueca naatimpa ariguenti oquenapoji jenoqui inquitequi, cameetsanijite quericaca shecaquemparoneca aatoquea imetojajitsi. ");
INSERT INTO cotNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naroguenti pan anijatsica poneanquitsica jenoqui inquitequi. Quericaca shecaquemparoneca ocatica pan incoguitempani iranijanaque. Ocatica pan nojocaquenerica, iroguenti notsino nojocajiaquenerica maasano caquintejiatsica cameetsanijite incoguitempaninijite iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ariqueate iquenquetsatavacaajianacaquea joriojia, icantajiaque: —¿Queroquea incoquempani iricatica irojocajiacajirogueti itsino ashecajiaquemparoquea? ");
INSERT INTO cotNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Icantajiguiriqueate Jesoshi: —Imaicaqueate noncamantamajajiaquempi aatogueti pishecatsitanaro notsino, aisa aatogueti pimiritajiganaro noriraja, aatoquea ochoocatimpi anijagantsi. ");
INSERT INTO cotNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quericacaquea shecaquemparoneca notsino aisa irimiraquerogueti noriraja onchoocapojeri anijagantsi coguitatsica, ariquea nontinaajeri naatimpa savincaguiteriqui vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Oraqueate notsino iroguentiquea iroomajaca ishecajitaca. Ariquea oquejetaca iroatimpa noriraja, iroguentiquea iroomajaca imirajitaca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Quericaca shecaquemparoneca notsino, aisa irimiraquerogueti noriraja incoguitempani inchoocaguitenani, naatimpaquea noncoguitempani nonchoocaguiterini. ");
INSERT INTO cotNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Itigarancaquenaquea Aapani anijatsica, ari nanijaque naatimpa irooriji yanijacaaquena Aapani. Ariquea inquejetaquempa quericaca shecaquenaneca naatimpa, nanijacajaeri. ");
INSERT INTO cotNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ocatica pan, iroguenti quenapojatsica jenoqui inquitequi. Teequea onquejetemparoji manaa ishecajiavecaca pivaesatinite imetojajianajiqueate. Quericaca shecaquemparoneca ocatica pan incoguitempaniqueate iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Maasanoquea ocatica icanqueca Jesoshi manaquea itsatacajaiaqueriquea shinagogaqui icapiocantapinijiacaca joriojia ontaniqui Caperenaoqui. ");
INSERT INTO cotNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iroompaqueate iquemajiavaquerogueti icanqueca Jesoshi imaica, ariquea iria oshequini oguijaguijaitanaquerica icantajianaque: —Manavaeca ocatica icanqueca. ¿Taampa quemisantavaquerone? ");
INSERT INTO cotNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ariqueate iriraquea Jesoshi itsatashitavacaro icantavacaajianacagueti icantimanataquerogueti icantavecarica, icantsiijaariquea: —¿Ari ocatsimatacajaianaquempi nocantajiaquempica? ");
INSERT INTO cotNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iroosacanica, ¿querocaca pincojiaquempa pamenajiaquerigueti Irijanite Caquinte iroanajegueti jenoqui inquitequi ichoocatigueti coramani? ");
INSERT INTO cotNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Oraquea shiretsi, iroguenti anijacaantanquitsica, teequea agavejeji atsino. Ariquea oquejetaca nocantajiaquempica imaica, oquejetacaro shiretsi, iroguenti anijacaantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Cotanquitsiquea choocaquea piconoagarantajiaca teequeate pinquemisantajiguenaji. Iriraquea Jesoshi itsatsitacatari iroaqueragueti queri aato iquemisantajiguiri, aisa queri aacaanquerineca. ");
INSERT INTO cotNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ariquea icantiri: —Irootaquetari nocantantajiaquempica aato inchiquioji icoraquetashitana caquinte aatogueti yagavejacaguiri Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ariquea iconoagarantajianacaquea oguijaguijaivetanacarica Jesoshi yovashiantajianajiriquea teequea iroguijaguijaitajeriji. ");
INSERT INTO cotNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ariquea Jesoshi icoacojiaqueriquea itsatacaanejia vegarajianquitsica 12, icantajiguiriquea: —¿Pinintajiaque poajianaje aviatimpajia aisa? ");
INSERT INTO cotNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Cotanquitsiquea irira Shimo Peerero icantiri: —Nomajirote, ¿queriquea noashijianaqueca? Aviguentitari ashintaro quenquetsatsarentsi anijacaantantatsica noncoguitempaniniji nanijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Naatimpajia noquemisantajiaquempiquea, aisa notsajiaque aviguentiquea Quirishitotatsica, Irijanite Aapani Irioshi anijatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Icantajiguiriqueate Jesoshi: —¿Teempa narotaque coguiajiaquempica aviatimpajia carajianquitsica 12? Cotanquitsi chooca aparo piconoacaca, ampatsini inaque. ");
INSERT INTO cotNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Oraquea icanquegueti Jesoshi imaica iriguenti icantacoque Jorashi, irijanite Shimo Ishicariote, iriguentitarite aacaanquerineca coajica. Irioquea itsatacaane inaveca, cotanquitsi coajica yaacaanqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ariqueate iriraquea Jesoshi tee irininteji iroanaque Joreaqui, itsaquetari inintajiaque joriojia irimetojajiaqueri. Mana ichoocataji Garireaqui itsatacaantaque oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Quempejitapojaquetari ishineventajiacaca joriojia ipeacaantajigaroca tsovironaquijaniquipae iquenquejajiro iquenaquenaitanajigueti ivaesatinite oquitamampororoipojaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iriraqueate iriguentijeguitepae Jesoshi icantajiguiri: —Iintsijate poanaque Joreaqui pinquejetaquempaqueate imaica ponigaanqueroquea oacaantantatsica intati ariniji iramenajiaquempi pitsatacaanejia choocajianquitsica ontaniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Icoguitanitari quericaca nintanquitsica iramenajiaqueri, aato yomaniro yantaqueca. Imaicaquea aviatimpa, iroorijite pagavejaque ponigaanqueroqueate taaca opajitapae, iintsijate poanaque ponigaanquempa iramenajiaquempiniji maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ariqueate icojiacani iriguentijeguitepae aisa teequea intsamajajigueriji, irootaquequea icantantajiacarica imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Cotanquitsiqueate Jesoshi icantajiguiriquea: —Tequeratatirajatari aguempaji noantanaquempaca, cotanquitsiquea aviatimpajia cameetsaquea poajianaque querocagueti pinintajiaqueni. ");
INSERT INTO cotNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tee onchoocateji irisemaneguintimentajiguempica quepatsiquitica. Naatimpaquea irootari isemaneguintantajiaquenaca nocanquegueti yantaguetaqueca iroguenti covaeguisherentsi. ");
INSERT INTO cotNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Poajianaquequea aviatimpajia pintoncoajianaque incapiocaventajiaquemparogueti ishineventajitaca. Naatimpaquea aatota nogui, tequeratanicate aguempaji noantanaquempaca. ");
INSERT INTO cotNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Icantajiaquerigueti imaica, ari ichoocataji Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cotanquitsiqueate ariqueate yoayoaitanaquegueti iriguentijeguitepae impoitanajiquea yoanaque iriatimpa. Teequea ari intsipatsipaitempariji igonorojia, teenicate irininteji irinejajiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Iriraqueate imajirojiate joriojia icoaqueri Jerosarequi, icantajiaqueri capiocajianquitsica: —¿Quericampa? ");
INSERT INTO cotNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iquenquetsatacojiaqueriquea intati, choocaquea cantavanquitsica: “Iriguentiquea cameetsatatsica.” Itsipaqueate icantavaque: “Teequea incameetsateji, mana yamatavijaqueri caquinte intati.” ");
INSERT INTO cotNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Cotanquitsiquea inchiquioji iquenquetsatavacaajiacaquea teequea inconijajencateji, itsaroacaajiacaritarite joriojia majirontajiatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Oraqueate oniganquipojaquegueti ishineventajiacaca ariqueate itoncoanaque Jesoshi, yoanaquequea teemporoqui itsaroventantajitarica Aapani Irioshi, itsatacaantaquequea oraniqui oniganquirequi. ");
INSERT INTO cotNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ariqueate yamenajiaquerigueti joriojia yamenajianaquequea intati icantantajianacaca: —¿Queroquea icotacani itsatantacaroca taaca opajitapae? Teenicate intsatacaamajajiteriji. ");
INSERT INTO cotNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Cotanquitsiquea Jesoshi icantajiguiriquea: —Oraqueate notsatacaantaqueca imaica teequeate inchiquiojitsiquea nontsatashitemparoji naatimpa. Iriguentitari tsatacaaquenaro tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Quericacaquea nintanquitsineca irinetsanataqueroquea ininqueca Aapani Irioshi intsaquequea iriguenti tsatacaaquena, teequeate inchiquiojitsita naashitemparoji naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iriraqueate inchiquiojica aashitaroca intati iriatimpa manaquea ininquequea irishineventajitaquempari, cotanquitsiquea iriraquea nintanquitsica iriguentiqueate irishineventajitaquempa tigarancaquerica manaqueate itampaticataquero intati querocaca icanqueca, teequea iramataguempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Coramani Moishishini itioncajiaquempiro icanquerica Aapani Irioshi cameetsaniji pintsajiaquero, cotanquitsiqueate imaica aviatimpajia tee pinetsanajigueroji. ¿Quero ococani pinintantajiacaca pimetojajiaquenaquea?” ");
INSERT INTO cotNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ariqueate iquenquetsajianaquequea maasano icantajiguiriquea: —Ichoocaquempi ampatsini. ¿Quericate nintanquitsica irimetojaquempi? ");
INSERT INTO cotNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Icantiri Jesoshi: —Nonigaanqueroquea savincaguiteriqui imagorejantajitaca aparo teeca irinejajiteji, ariqueate oacaajianaquempi intati. ");
INSERT INTO cotNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iriraqueate Moishishini icanquequeate intotsaiquijiqueriquea ichonquimashi iriaqueraca voanquitsica aapojempagueti 8 savincaguiteri (cotanquitsiquea tee irio pariguemparone Moishishini, ogantagatari icotani pivaesatinijiate). Irootaquequea pitotantarica. Pitotsaiquitantajigui aisa savincaguiteriqui imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Imaica pitotsaiquitantajiguigueti savincaguiteriqui imagorejantajitaca cameetsanijite pinetsanajiaqueronijite icanqueca Moishishini, ¿queroquea ococa picatsimatimentantajiaquenaroca pamenajiaquenagueti nogueshimajatajirigueti joquijitanquitsica savincaguiteriqui imagorejantajitaca? ");
INSERT INTO cotNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aatoqueate taampina picantsiija yantajitaquero teeca oncameetsateji. Iroquetiquea pinquenquejamajajiaquequea iroguentica yantajitaque teeca oncameetsateji irooca cameetsari, iroompa tampatica pincanque. ");
INSERT INTO cotNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ariquea iconoagarantajiacaquea guintenijiatsica Jerosarequi icantajianaquequea intati: —¿Iriotaquempa inintajiqueca irimetojajiqueri? ");
INSERT INTO cotNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Queroqueate ocotacani imaica teequeate incantajiteriji icapiocaventajicarigueti iquenquetsataquegueti? Arica icantajianaque majirontajiatsica iriotaque Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Cotanquitsiquea atsajiaque queroquea iponeacani iricatica. Irirampani Quirishito incoraquetapojegueti, aatoquea itsajitiri quero iponeacani. ");
INSERT INTO cotNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iriraqueate Jesoshi choocatirajaquea itsatacaantaque teemporoqui oniganquirequi oticaacoro iririjencatanaquequea icanti: —Pitsajiaquenaquea, aisa pitsajiaque quero noponeaca. Teequea noncoraquetashitempaji inchiquioji, cotanquitsiquea iriomajacaquea irira tigarancaquenaca. Teequea pintsajigueriji aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Cotanquitsiquea naatimpa notsaqueriquea, aritarite noponeaca iriatimpaqui, aisa iriguentitarite tigarancaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ariqueate inintajiavecaquea irajaiaquerime, cotanquitsiquea tecatsi ajiriquerine, tequeratatirajatari aguempaji iraantajitaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cotanquitsiquea iquemisantajianaqueriquea oshequini caquinte, icantantajianacaca: —Incoraquequegueti Quirishito ¿arimpa iranaaqueri iricatica ironigaanquero teeca irinejajiteji? Iriotaque Quirishito. ");
INSERT INTO cotNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ariqueate irirajia pariseojia iquemajiavaquerigueti iquenquetsatacojiquerigueti Jesoshi ishineventajicari, ariqueate itsipatsipaicariquea saserorotejia anaantajianquitsica itigarancajiaqueriqueate coaretapae quempoguijajiguiroca teemporo irajaiaquiteriqueate. ");
INSERT INTO cotNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Cotanquitsiqueate Jesoshi icanti: —Capichajinivani nonconoajianajempi, ariquea noanaje ichoocatigueti tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ariquea pincoaguevetajena, aatoqueate pinejajijaana, aatotarite pagavejajigui poajianaque aviatimpajia querocagueti noanajeni naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ariqueate icojianaca joriojia iquenquetsatavacaajianacaqueate icanti: —¿Querocaquea iroanaqueni aatoca anejantajiajari? Aricaquea iroanaque inconoajiaquempariquea ontaniqui agonorojia varajajianquitsica conoajiacarica guiriegojia intsatacaajiaqueriquea iriatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Taaqueate opajita icantacoqueca icantantacaca: ‘Ariqueate pincoaguevetajena aatoquea pinejajijaana, aatotarite pagavejajigui poajianaque aviatimpajia querocagueti noanajeni naatimpa’? ");
INSERT INTO cotNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ariquea aapojaja savincaguiteri icaratantajianajaroca ishineventajiacaca. Ocatica savincaguiteri caaviji ishineventamajajigaro. Iriraquea Jesoshi icatianacaquea iquenquetsatanaquequea iririjencaniquea icanti: —Quericacaquea miretanquitsica incoraquetashiquenaja nojocaqueneri irimirapoje. ");
INSERT INTO cotNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Quericaca quemisantaquenaneca, ocantaquequea Tioncarentsimajaca, omotojaguiteni ishirequi oja anijacaantantatsica, onquempetanaquemparo iniroja oja. ");
INSERT INTO cotNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oraquea icanquegueti Jesoshi imaica iriguentiquea iquenquetsatacotaque Ishire Aapani Irioshi choocashirentajiaquerineca maasano tsaroventajiaquemparineca, tequeratatirajatari incoraqueteji Ishire Aapani Irioshi inchoocashirentantaquequeate, tequeratanicate irogajenocashitanajemparo Jesoshi iroganejencare. ");
INSERT INTO cotNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ariqueate iquemajiavaquerigueti maasano iconoagarantajiacaqueate icantajiaquequeate: —Arimajasacanicate iriguentiquea tsavetantatsica aguijajiavaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Itsipapaequeate cantajianquitsica: —Iriguentiqueate Quirishito. Cotanquitsiquea itsipapae cantajianquitsicaquea: —¿Arimpaquea imponeaquempa Quirishito Garireaqui? ");
INSERT INTO cotNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Teempa oncanteji Tioncarentsimajaca: iriraquea Quirishito irio inchoviquitanaqueca Taavini, imponeaquempa Verenequi, iguintenini Taavini? ");
INSERT INTO cotNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Irosatiquea tee inquemavacaimentempariji Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iconoagarantajiacaquea inintajiavecaquea irajaiaquerime, cotanquitsiqueate tecatsi ajiriquerine. ");
INSERT INTO cotNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ariqueate irirajiaquea coaretapae oajiavetananquitsica irajaiaquiterimequea ipiapiaitashitajaquea intati ichoocajiaquegueti pariseojia jerijia saserorotejia anaantajianquitsica. Iriatimpajiaquea icantajiavaqueriquea: —¿Quero ococani caarica pamantari? ");
INSERT INTO cotNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Iriatimpajiaquea icantajiguiriquea: —Iroorijite cameetsavaequetari iquenquetsataquegueti. Teequeate inchoocateji itsipa quempequemparineca iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Iriraquea pariseojia icantajiguiriquea: —¿Aricaja yamatavijajiaquempiquea aviatimpajia aisa? ");
INSERT INTO cotNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Irira majirontajiatsica teequea inquemisantajigueriji. Ariquea noquejejiaca naatimpajia pariseojia. ");
INSERT INTO cotNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Irirajia teeca intsajigueroji itioncanaquenica Moishishini iriguentiquea quemisantajiaquerica, cotanquitsiqueate incatsimajiaqueri Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ariqueate ichoocaque oraniqui Nicoremo oanincashitanaquerica Jesoshi chapinqui, iriguentitari pariseo. Iquenquetsatanaquequea icanti: ");
INSERT INTO cotNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Icantimentantajitirotari ancantsiquempagueti: ‘Chooca yantaguishequeca’, aatogueti iroqueti aquemiri inquenquetsaquegueti cameetsaniji antsatimenqueroniji taa opajita yantaque. Aritari ocanti otioncacotacagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Icantsiijaariquea iriatimpajia: —¿Avirocajate aisa Garireaquitica? Iintsijate pisavicaventamajatero Itioncacaantaqueca Aapani Irioshi, pamenaqueroquea tee oncanteji imponeaquempa tsavetantatsica Garireaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ariqueate yoayoaitanajiqueate itsovironaquitepaequi. ");
INSERT INTO cotNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Cotanquitsiquea irira Jesoshi yoanaque Orivotsempiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Osavincaguitetamanaquegueti yoanajiquea teemporoqui itsaroventantajitarica Aapani Irioshi. Ariqueate icapiocaventajianajari oshequi caquinte, ari isavicanaque itsatacajaiaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ariqueate irirajiaqueate tsatacaantajiguiroca itioncacotanaqueca Moishishini jerijia aisa pariseojia yamajiaqueroquea manquigarentsi yonigaacojicaroquea shirampari, yogatiajiapojaqueneriqueate niganqui icapiocajiacagueti, ");
INSERT INTO cotNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","icantajiguiriqueate Jesoshi: —Tsatacaantantatsica, ocaqueate ocatica manquigarentsi choocavecaqueate manquigataroca cotanquitsiquea inejacojitapojiro itsipa shirampari. ");
INSERT INTO cotNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Oratari itioncanaqueca Moishishini ocantini maasano manquigarentsi quejejianquitsica imaica intsinatsinajiqueroquea irimetojajiquero. Imaicaquea imaica aviatimpa, ¿queroqueate pincanteni? ");
INSERT INTO cotNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iriatimpajiaquea manaqueate icantajiaquequea imaica iramenajiaqueri querocaca incanteni iramenantajiaquempariniji incatsimatimentantajiaquemparica. Cotanquitsiquea Jesoshi imaroncanaca itioncantanacaroquea ichapaqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jatanatsi icoacojianaqueriquea, ariquea icatianaca icantajiguiri: —Quericacaquea teeca inquempevaetempaji iintsija iriquetiquea pariaquemparone intsinaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ariqueate imaronquitanaja aisa itioncanaji quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iroompaqueate iquemajiavaquerigueti icanquerigueti, ariquea yoaguetanaji. Iriquetiquea oajianajatsi quenquevarimajatanquitsica. Apanirota oaguetanajatsi ari iteroncajianaja maasano. Apanivaniquea ichoocataji Jesoshi itsipatajaroquea manquigarentsi irisatiquea aisa capiocaventajiacarica incajaranqui. ");
INSERT INTO cotNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ariqueate icatiavetanaja Jesoshi, yamenavetari cajaraguiteni, apaniroquea ocatiaca manquigarentsi, icantiro: —Manquigarentsi, ¿quero icantajianajani amajiavequempica? ¿Teequea inchoocateji catsimatimentempironeca pipeacaacaca? ");
INSERT INTO cotNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Iroatimpa ocantiri: —Tee, nomajirote. Tee inchoocateji. Ariqueate icantiro: —Ariquea nonquejetaquempa naatimpa, aatoqueate nocatsimatimentimpiro imaica. Imaicaquea poanaje, aatoquea piquempevaetaja aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ariqueate Jesoshi iquenquetsatanajiquea icantajiguiriquea: —Naroguenti Tsirencari tsirencacojiaquerica quepatsiquitica. Quericacaqueate guijatacotaquenaneca aatoquea ipitsecacotajitsi, naroguentitari tsirencacojiaquerine cameetsaniji incoguitempani inchoocataje. ");
INSERT INTO cotNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Irirajia pariseojia icantajiguiriquea: —Avisati tsavetacotajatsi. Tee ontampaticateji pitsavetacotacagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Cotanquitsiquea icantajiguiri Jesoshi: —Naroguentiquea tsavetacovetajatsi, cotanquitsiquea arimajaquea nocanque, teequeate namataguempaji. Notsaquequea quero noponeaca aisa quero noanajeni, cotanquitsiqueate aviatimpajia teequeate pintsajigueji quero noponeaca, aisa quero noanajeni coajica. ");
INSERT INTO cotNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aviatimpajia piquejejiacari caquinte cantacotashitantatsica intati, teequeate pintampaticamajateroji. Naatimpaquea teequea noncantashijiguempariji quericaca. ");
INSERT INTO cotNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cotanquitsiquea noncantacotantaquegueti, tampatica noaquero, irooriji tee noncantacotanteji naatimpa apaniro, nocarataque naatimpa jeri aisa Aapani tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Oraticatarite itioncajitaqueca pamenavecaca ocantiqueate omoncarajavacaaquempagueti icanqueca mavite cantacotaqueroneca inejajiaqueca, ari pintsaque tampatica yoaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jero imaica, noquenquetsatacotaca naatimpa, ari iquejetaca Aapani tigarancaquenaca iquenquetsatacotaquenaquea iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iriatimpajia icantajiguiriquea: —¿Queroqueate ichoocataqueni piri imaica? Icantajiguiriqueate Jesoshi: —Teenicate pintsajiguenaji naatimpa, ari iquejetaca teequeate pintsajigueriji Aapani. Arimegueti pintsajiaquename naatimpa, pintsajiaquerimequea iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Maasano icanquerica Jesoshi manaquea itsatacajaiaqueri teemporoqui, isavicapoji ochoocaquegueti yoguijaantajitarica imentaquipae yojocajiguinirica Aapani Irioshi. Cotanquitsiquea teequeate inchoocateji aaquerineca iraanaqueri irimetojajiqueri, tequeratanica arejetempanica iraantajitaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iroompa irira Jesoshi icantajiajiriquea aisa: —Naatimpaquea noanaje, ariquea pamenaguevetajena, cotanquitsiquea ogantagaquea onchoocaguiteni piguempevaere irosati pimetojacotaquero. Ontaniqui querocagueti noanajeni, aatoquea pagavejajigui poajianaque. ");
INSERT INTO cotNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Irirajiaquea imajirojiate joriojia icantajianaquequea: —¿Ari irimetojaquempa irisati, irootari icantantacaca aatoquea agavejajigui oajianaque querocagueti iroanaqueni? ");
INSERT INTO cotNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Cotanquitsiquea Jesoshi icantajiguiriquea: —Aviatimpajia aviguentijiaquea isavijiquitica, naatimpaquea ariguenti noponeaca jenoqui inquitequi. Aviatimpajiaquea aritari piguintenimajajiga acaniqui quepatsiqui, naatimpaquea teequea noguintenimajatempaji acaniqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Irootaquequea nocantantajiaquempica pimetojajianaque tequeratagueti oshetempaji piguempevaere. Aritarite aatogueti pitsamajatana narotaque, aisa aatogueti paventana, ogantagaquea onchoocaguiteni piguempevaere irosati pimetojacotaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iriatimpajia icantajiguiriqueate: —Jmm, ¿taampa avia? Icantiri Jesoshi: —Nocamantajiavetaquempitari iroaqueragueti. ");
INSERT INTO cotNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aisa chooca oshequini noncantacojiaquempica, cotanquitsiquea manaquea noncanque icanquenaca tigarancaquenaca. Iriatimpaquea inetsanamajaqueroquea icanqueca, teequea iramataguempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Cotanquitsiquea iriatimpajia teequeate intsajigueriji iriguentiquea iquenquetsatacotanaque Iriri. ");
INSERT INTO cotNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Irootaquequea icantantacarica Jesoshi: —Oraquea pogatiacojiaquerigueti irira Irijanite Caquinte, ari pintsaque narotaque. Aisa pintsajiaquequea teequea nanteji inchiquioji. Iroguentiquea nocanque querocaca itsatacaaquenaca Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Icoguitanitari itsipataquena tigarancaquenaca, teequea irojoquenaji apaniro, nocoguitanitarite nosavicavenqueroqueate ininqueca iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iquejequerogueti imaica iquenquetsataquegueti, iquemisantajianaqueriquea oshequini. ");
INSERT INTO cotNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ariqueate Jesoshi icantajiguiriquea irirajia joriojia quemisantajiaquerica: —Aviatimpajiaquea pincoguitempanigueti pinquemisantajianaquena nocantajiaquempica imaica, pimpeamajajiaquempaquea notsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pinquejejiaquempagueti imaica ariquea pintsamajajiavaquero iroomajatatsica, irooqueate oguipaquijacojiajempineca manaquea pinchoocatashijiajempa intati. ");
INSERT INTO cotNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chooca quenquetsajianquitsica icantsiijaariquea: —Naroguentijiatari ichoviquijianaqueca Averaameni. Teequea inchoocatimateji ashintajiganaca. ¿Queroquea ocotaca picantantacaca: ‘Pinchoocatashijiajempaquea intati’? ");
INSERT INTO cotNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Icantajiguiriqueate Jesoshi: —Noncamantamajajiguempija, maasano quempevaejiatsica teequea inchoocatashijiguempaji intati, agavejajiaqueritari quempevaerentsi, quejetaca ashintacari omperaperaatacari. ");
INSERT INTO cotNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pamenerijate aajanirentsi ivegarajitica teequeate inquejetempariji irijanite aajanitarica, teetari irio irijanite. Irinintaquegueti irojocaqueneri itsipa, irojocaqueneriqueate; cotanquitsiqueate irijanitemajaca aatoquea yojocantiri, incoguitempani inchoocaque. ");
INSERT INTO cotNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iroguipaquijacaajiajempirogueti Irijanite Aapani Irioshi agavejajiaquempigueti quempevaerentsi, arimajaquea pinchoocatashijiajempa intati. ");
INSERT INTO cotNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Notsaquequeate aviguentijiavetaca ichoviquijianaqueca Averaameni, cotanquitsiquea tee pinintajigueji pinquemisantajigueroji nocamantajiavetaquempica imaica, irootaquequea pinintantajiacaca pimetojajiguena. ");
INSERT INTO cotNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naatimpaquea manaquea nocantajiaquempiquea nonejaqueca notsipatacarigueti Aapani. Ariquea piquejejiaca aviatimpajia manaqueate pantajiaqueroquea querocaca icantajiaquempica piri. ");
INSERT INTO cotNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iriatimpajiaquea icantajiguiri: —Irio aapani Averaameni. Cotanquitsi Jesoshi icantiri: —Iriomeguetiqueate choviquijianaquempime Averaameni pinquejejiaquemparimequea iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Cotanquitsiquea teequea pinquejejiguempariji imaica. Nocamantajiavetaquempiqueate iroomajatatsica icanquenaca Aapani Irioshi, cotanquitsiquea aviatimpajia manaquea pinintajiaque pimetojajiaquena. Teequeate inquejeteroji Averaameni imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Aviatimpajia mana pisavicaventajiaquero isavicaventica piri. Iriatimpajia icantajiguiriquea: —¿Arimpa itsipa irijanintajigana? Iriguentitari irijanintajigana Aapani Irioshi apatiroti. ");
INSERT INTO cotNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Icantajiguiri Jesoshi: —Iriguentimequea irijanintajiaquempime Aapani Irioshi pimpintsajiaquenamequea, aritarite noponeaca iriatimpaqui, teenica inchiquioji noncoraquetashitempaji naatimpa, iriguentiquea tigarancaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Queroquea ocotacani teeca pintsatantajiavaquemparo nocantajiavequempica? Teequeate pinintajigueji pinquemisantajigueroji nocanqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Iriguentitari irijanintajiaquempi ampatsini, iriguentiquea ashintajiaquempi. Aviatimpajia iroguenti pinintajiaque pantajiaquequea inintaqueca iriatimpa. Iriatimpaquea iriguenti metojantatsica, irosati icocani coramani iroaqueragueti irosati imaica. Teequea incanteroji arimajatatsica, teequea irishineventemparoji. Itsojeacagueti, irootaque irashi, ari icocani iriatimpa, iriguenti tsojenti, iriguentiqueate oquenantapojaca tsojetsi. ");
INSERT INTO cotNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naatimpaquea nocantamajataque iroomajatatsica, irootaquequea teeca pinquemisantantajiguenaji. ");
INSERT INTO cotNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Arimpa chooca nantaqueca teeca oncameetsateji pincantacotsitantaquenaroca? Tee anejeroji. ¿Quero ocotacani imaica teeca pinquemisantantajiguenaji? Iroguentiquea nocanqueca arimajaca. ");
INSERT INTO cotNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iriraqueate yashintacaca Aapani Irioshi iquemisanqueroquea icanqueca. Cotanquitsi aviatimpajia teequea irio ashintajiguempine Aapani Irioshi, irootaque tee pinquemisantantajiguemparoji. ");
INSERT INTO cotNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ariqueate icantsiijaariquea joriojia: —Nocantamajataqueshine aviguenti Samariaquitica, aisa ichoocaquempi ampatsini. ");
INSERT INTO cotNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iriraquea Jesoshi icantiriquea: —Tee inchoocatimatenaji ampatsini. Naatimpaquea iroguentiquea noninque iramenantajiquemparica Aapani yoganejencavaetaca noquenquetsatacotancarica cameetsa, cotanquitsiquea aviatimpajia teequeate pinintajigueji pinquemisantajiguena, mana picantacantataquena intati. ");
INSERT INTO cotNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naatimpaquea teequea inchiquioji noninteji inquemisantajitena intsaroventajitena, cotanquitsiquea choocaquea nintacaanqueroca intsaroventajiquena. Irio cantanquitsine quero incotanaquempani maasano teeca intsaroventajiguena. ");
INSERT INTO cotNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Imaicaquea noncamantamajajiaquempiquea quericaca netsanataqueroneca nocantica aatoquea imetojimataji. ");
INSERT INTO cotNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Icantajiguiriqueate joriojia: —Notsamajajiaquero imaica arimaja ichoocaquempi ampatsini. Metojajianajitari Averaameni jerijiaquea maasano tsavetantajiatsica, cotanquitsi aviatimpa picanque: ‘Quericaca netsanataqueroneca nocantica aatoquea imetojimataji.’ ");
INSERT INTO cotNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Arimpate panaaqueri Averaameni choviquijianacajica? Iriatimpa metojajitari, ariqueate iquejejianaja tsavetantajiatsicani. ¿Taampa aviatimpa picantantacaca? ¿Taaquea pijiqueji? ");
INSERT INTO cotNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Icantajiguiriqueate Jesoshi: —Inchiquiojime narosatime quenquetsatacotajatsine cantajatsineme: ‘Caaviji noganejencamajata’, narosatime nintajatsine intsaroventajitena, aatome ocameetsati. Cotanquitsiquea iriguentiquea nintanquitsi Aapani picantajiavecaca aviatimpajia iriguenti pitsaroventajiga. Irio shineventaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Cotanquitsiquea teequea pintsajigueriji. Naatimpa arimaja notsaqueri. Oramequea noncanquemegueti tee nontsateriji, manamequea nontsojeaquempame nonquempejiaquempimequeate aviatimpajia. Cotanquitsiquea naatimpa arimaja notsaqueri, aisa noquemisantiri taaca icanquena. ");
INSERT INTO cotNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Coramani iriraquea Averaameni choviquijiaquempica ishinevaeca iquenquejaquegueti iramenaquero noncoraqueque, ariqueate yamenaquero ishinevaetanacaquea. ");
INSERT INTO cotNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ariquea icantajiguiri joriojia: —Tequerata pajagantsitacoteji 50 ajagantsi, ¿pinejirimpa Averaameni? ");
INSERT INTO cotNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Icanqueri Jesoshi: —Noncamantamajajiaquempi, tequeratagueti inchoocateji Averaameni, choocana naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ariqueate yaashijianaqueriquea mapi intsinacajiaquerime, cotanquitsiqueate Jesoshi ipeapitsajianajari, isotoantanajaro oticaacoro teemporo, yoanaji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ariqueate iquenanaquegueti oraniqui Jesoshi inejapojiriquea shirampari shamponcajari, yashitaque yoaquero iroaqueragueti ivoapoji tee irinejeji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iriraquea itsatacaanejia icantajiguiri: —Tsatacaantantatsica, ¿quero ocotacani ivoaquegueti ishamponcajatantacaca irica shirampari? Iriocaja quejejianquitsi iriri irooca iriniro iquempevaejiaca iquejetantanacaca irijanite, iriocaja quejetanquitsi iquempevaetaca irisati. ");
INSERT INTO cotNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Icantajiguiriqueate Jesoshi: —Teequea iroguentiquea quempetacaguemparine iguempevaere, aisa teequea iro quempetacaguemparine iguempevaerejia iriri irooca iriniro. Manaquea oquejetancaca imaica iramenimentajiqueroniji iragavejane Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ogantagatirajagueti osavincaguitetigueti nantaguiteroni inintacaaquenaca tigarancaquenaca. Pajinitari ompitsecanaje, tecatsi agavejanquitsine irantavaetantajemparo. ");
INSERT INTO cotNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Choocatirajanagueti acaniqui quepatsiqui, narotaque itsirencarite quepatsiquitica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ariquea icanquitigui imaica, iquishoaque quepatsiqui, yaaque capichaji yamirocaquero, ariquea itirijatantacariquea shamponcajari, icantiri: ");
INSERT INTO cotNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Iintsija pija pinquivajatajatempa omotijaqui icantajitica Shiroe —oncanque ovajiro “Itigarancajitica”. Iriatimpa yoanaque iquivajapojaca, ariquea icoraquevetajagueti jac nejanaji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Irirajiaquea iconoajigaca iguintenijigagueti jerijia aisa amenajiguirica isaviquigueti yamanantapiniquegueti imentaquipae icantajianaquequea: —¿Teempa irio irira savicapinitatsica amanantapinitatsica imentaquipae? ");
INSERT INTO cotNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iconoagarantajiacaqueate icantajiaquequea: —Jeejeguitatsi iriguenti. Itsipaquea cantajiananquitsi: —Tee, mana iquempevecari. Iriatimpa icantanaque: —Naroguenti. ");
INSERT INTO cotNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ariquea icantajiguiri: —¿Queroquea picotanajani pinejantanajaca? ");
INSERT INTO cotNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Iriatimpa icantajiguiri: —Iriraqueate icantajitica Jesoshi yamirocashitajana quepatsi, itirijatantajanaro, ariquea icanquena: ‘Pija pinquivajatajatempa omotijaqui Shiroe.’ Ariquea noanaque noquivajatapojatiga nonejanaji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iriatimpajia icantajiguiri: —¿Quericampa imaica? Icantiquea iriatimpa: —Jmm, tee nontsateji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ariqueate yaajitanaqueri shamponcajavetatsica ichoocajiaquegueti pariseojia. ");
INSERT INTO cotNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Oraqueate yamirocashitaquerigueti Jesoshi quepatsi inejacajairigueti iroguentiquea savincaguiteri imagorejantajitaca. ");
INSERT INTO cotNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Irootaquequea icoacotantajiacarica pariseojia quero icotajani inejantanajaca. Iriatimpaquea icantajiguiriquea: —Itirijatantajanaro cajashepatsari, ariquea noquivajataja, ari nonejanaji imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ariquea iconoagarantajiaca pariseojia icantajiaquequea: —Iriraquea quejequeroca imaica teequea iriguenti tigaranquerine Aapani Irioshi, yantantacarotari savincaguiteri imagorejantajitaca. Cotanquitsiquea itsipaquea cantananquitsica: —Iriomegueti quempevaetatsica, ¿arimpa iragavejaqueme ironigaanquero oacaajiacajica intati quejecaroca ocatica? Ariqueate tee inquemavacaajiajempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Irootaquequeate icoacotantajianajarica aisa shamponcajavetatsica, icantajiguiriquea: —¿Aviatimpa queroquea pincanteni? Avirotari inejacajai. Icanti: —Iriguentiqueate tsavetantiroca icanquerica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cotanquitsiquea irirajia joriojia teequea irinintajigueji incantajigueji inejacajairi shamponcajari icajemacaantantajiacarica iriri irosati iriniro icantajiguiriquea: ");
INSERT INTO cotNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Irio irica pirijanite picanqueca ivoaquegueti ishamponcajataque? ¿Queroquea icocani imaica inejantanajaca? ");
INSERT INTO cotNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yacanaqueri iriatimpa: —Notsaque iriotaque nirijanite, aritari icoca iroaqueragueti ivoaque ishamponcajataque. ");
INSERT INTO cotNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cotanquitsiquea teequea nontsateji quero icocani inejantanajaca imaica, aisa tee nontsateji queri nejacaajirica. Iintsijate pincoacoteri iriatimpa, quenquevaritari, inchiquiojitsitaquea incamantajiaquempi iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iriatimpajia mana icantantajiacaca intati imaica itsaroacaajiacaritari imajirojiate joriojia, icantajiaquetarite querica cantanquitsine Jesoshi iriguenti Quirishito incatsimatimentajiqueriquea aatoquea iquijaji shinagogaqui icapiocantapinijiacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Irootaquequea icantantacaca: “Iintsijate pincoacojigueri iriatimpa, quenquevaritari.” ");
INSERT INTO cotNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ariquea irirajiaquea coacojiaquerica icajemajiajiriqueate shamponcajavetatsica icantajiguiri: —Iriguentiquea pincanque yoganejencamajata Aapani Irioshi. Iriraqueate picanqueca incajaranqui notsajiaqueriquea iriguentiquea quempevaetatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Cotanquitsiquea iriatimpa icantajiguiriquea: —Jmm, tee nontsateji iriocampa quempevaetatsica, iroguentiquea notsaque iroaqueragueti noshamponcajavetaca, imaicaquea nejanajana. ");
INSERT INTO cotNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Icantsijigariquea aisa: —¿Queroquea icoquempini inejacaantajimpica? ");
INSERT INTO cotNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Icantsijigariquea iriatimpa: —Nocamantamajajiavetaquempiquea incajaranqui teequea pinquemajiguenaji. ¿Imaicaquea queroquea ococani pinintantajiacaca nampijitajero aisa noncamantajempiquea? ¿Ari pinintajiaque aviatimpajia aisa pimpejaiaquempa itsatacaanejia? ");
INSERT INTO cotNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ariqueate icatsimatsajiaqueriqueate icantajiguiriquea: —Aviatimpaquea aviguenti itsatacaane, naatimpajiaquea naroguentijiatarite oguijatacotajironica itsatacaantinica Moishishini. ");
INSERT INTO cotNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Notsajiaquetarite iriraqueate Aapani Irioshi iquenquetsatacaaqueri Moishishini, cotanquitsiqueate iriraqueate irica piquenquetsatacotaqueca imaica teequea nontsateriji queroca iponeacani. ");
INSERT INTO cotNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ariqueate iriatimpa icantajiguiriquea: —Arisacanicate. ¿Queroquea picojiacani aviatimpajia? Iriatimpaquea inejacajaanaquea, cotanquitsiquea teequea pintsajigueji quero iponeaca. ");
INSERT INTO cotNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Atsaqueritari iriraquea Aapani Irioshi aato iquemiri quempevaetatsica iramanerigueti. Iriguentiquea inquemaque tsaroventamajacarica antiroca ininqueca iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Irosati coramani tecatsi quemacoterine itsipa caquinte inquejetero imaica iragavejaque irinejacaajeri voacotiroca ishamponcajare. ");
INSERT INTO cotNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Irica noquenquetsatacotaqueca imaica aatomegueti irio tigaranquirime Aapani Irioshi aatome yagavejime inquejetacaaquemparome imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iriatimpajia icantajiguiriquea: —¿Oo querocaquea pincantempani pijiquejiquea pintsatacaajiguena naatimpajia? Irosati piquejetaca aviatimpa piquempevaemajatanaca. Ariquea icatsimamajajianaquequeate yoguisotoaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iriraqueate Jesoshi iquemacoquerigueti icatsimajitaqueri yoguisotoajitaqueri, yoanaque icoaguequeri. Ariqueate inejapojajiri icantiri: —¿Ari piquemisantaqueri aviatimpa Irijanite Caquinte? ¿Paventashirentacari? ");
INSERT INTO cotNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Icantiri iriatimpa: —Nomajirote, ¿quericaquea? Intsija pincamantena naventashirentantaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Icantiri Jesoshi: —Pinejaqueritari, iriotaque quenquetsatacaaquempica imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Icantiri: —Nomajirote, naventashirentaquempi. Ariqueate itigueroashitanacari itsarovencari. ");
INSERT INTO cotNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Icanti Jesoshi: —Iroguenti nocoraquetashique acaniqui quepatsiqui cameetsaniji incantacojiqueriniji caquintejia quero icocani, cameetsanijite irinejajiajeniji shamponcajavetatsica, irirampani nejajiavetanquitsica irishamponcajatanaje. ");
INSERT INTO cotNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ariqueate irirajia pariseojia choocajianquitsica oraniqui iquemajiaquerigueti icanquegueti imaica iconoagarantajiacaquea icantajiaqueriquea: —¿Arimpaquea naatimpajia noquejejiacari shamponcajari? ");
INSERT INTO cotNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Icantajiguiriquea Jesoshi: —Pinquejejiaquemparimegueti shamponcajari, aatomequea ochoocatajime piguempevaerejia, cotanquitsiqueate imaica picantajiavetacatarite: ‘Nonejaque’, irootaquequea ochoocatantajaca piguempevaerejia. ");
INSERT INTO cotNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Imaica noncamantamajajiaquempiquea quericaca ataitashitanaquerineca ontaniqui itantacojiquerigueti oveja aatogueti iquijantaro sotomorontsi iriguentiquea aitsitantatsica aisa aapitsatantatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cotanquitsiquea iriraquea quijanquemparoneca sotomorontsi iriguentiquea quempoguijirica irovejate. ");
INSERT INTO cotNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iriguentiquea irashirejavaquene timashitiroca sotomorontsi. Iriraquea irovejajiate iquemajiavajiri iquenquetsatigueti. Icajemajiaqueri irovejajiate apaniropae ivajiroqui, yaajianaqueri sotsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iroompa iteroncaquerigueti yoguisotosotoitaquerigueti maasano, yoanaque ijivatanaqueri. Iriraquea oveja yoguijaguijaitanaqueriqueate, itsajiguiritari iquenquetsatigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cotanquitsiquea aatoquea yoguijajiguiri itsipa teeca intsajigueriji, manaquea irishiashiaitapitsatanaqueri intati, aatotari itsajiguiri inquenquetsavetaquempagueti.” ");
INSERT INTO cotNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ari iquejetacaajiacari Jesoshi imaica, cotanquitsiquea iriatimpajia tee intsajigueji taa opajita iquejetacaacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Irootaque icantantacaca aisa Jesoshi: “Imaica noncamantamajajiaquempi, naroguenti irashitacoro oveja. ");
INSERT INTO cotNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Maasanoquea coraquejianquitsica tequeratagueti noncoraqueteji naatimpa iquejetacari aitsitantatsica aisa aapitsatantatsica, cotanquitsi tee inquemisantajigueriji oveja. ");
INSERT INTO cotNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naroguenti ashitacorontsi. Quericaca quijantanaquenaneca naatimpa inchoocapojaje cameetsa, inquijapojaque, irisotoanaque iramenapojero cataromashi. ");
INSERT INTO cotNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iriraqueate aitsitantatsica iroguentiquea icoraquetashitaque iraitsitante, irimetojante, impoguerejante, cotanquitsiquea naatimpa iroguentiquea nocoraquetashique iranijajianajeniji, iranijamajatatiguenimaja. ");
INSERT INTO cotNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Naroguenti cameetsari quempoguijamajajiguirica oveja. Iriraquea cameetsari quempoguijamajajiguirica oveja irimetojaventaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cotanquitsiqueate irira ivegarajitica intati inquempoguijantaquenemparica oveja, iramenavaquerigueti lobo incoraquequegueti, manaquea irishianaque intati irovashiantanaqueriquea oveja, teenica irio ashintemparine. Irira lobo iraashipojempari ovejapae, iroguivorocajencaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Irooquea ishiantanacaca shirampari, manatari ivegarajitiri intati, teetari impintsatempariji oveja. ");
INSERT INTO cotNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Naroguenti cameetsari quempoguijamajajiguirica oveja. Notsamajajiguiriquea novejajiate, ari iquejejigana iriatimpajia itsamajajigana, ");
INSERT INTO cotNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","quejecaquea itsamajatanagueti Aapani, ari noquejetaca naatimpa notsamajatiri. Ariquea aisa nometojaventajiaqueri novejatepae. ");
INSERT INTO cotNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chooca itsipapae novejatepae teeca intsipajiguempariji choocajianquitsica acaniqui tantontsiqui. Namajiaqueriquea iriatimpajia aisa. Inquemisantajiaquenaquea nonquenquetsatacaaquerigueti, apapioroquea incantanajempa, aparo quempoguijaquerine. ");
INSERT INTO cotNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Jeroquea ipintsatanquenaca Aapani, inchiquiojitatari nojocanaquero nanijane, cameetsanijite naavajero nanijanaje. ");
INSERT INTO cotNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tecatsi aapitsatenarone, inchiquiojita naatimpa nojocanaquero. Nagavejaque nojocanaquero, nagavejaque naavajero. Irootaque inintacaaquenaca Aapani nantero.” ");
INSERT INTO cotNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ariquea iquemajiavaquerigueti joriojia icanquegueti imaica, ariquea icojianaca tee inquemavacaajianajempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Icantajianaquequea oshequini: —¿Quero ococani piquemisantantajiavacarica? Manatarite ichoocaqueri ampatsini, aisa mana ishoncacotaca intati. ");
INSERT INTO cotNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Cotanquitsiquea icantajianaquequea itsipa: —Iriraquea ichoocaqueca ampatsini aato yagaveji iquejetacagaro iquenquetsataquegueti imaica. ¿Arimpa iragavejaque ampatsini iramenacaajeri shamponcajari? ");
INSERT INTO cotNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oraqueate ocatsincaguitepojajigueti iriraquea joriojia icapiocaventajiacaroquea ishineventajiacaca Jerosarequi iquenquejajiajiro inetsanajiajirogueti coramani ivaesatinite teemporo itsaroventantajitarica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iriraquea Jesoshi yanijitaquequea oraniqui sotsiqui teemporoqui oveshintsaacagueti iniropoapae ocajaratsencoataquegueti icantajitica Irashi Saromoni. ");
INSERT INTO cotNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iriraquea joriojia icapiocaventajiapojacariquea icantajiguiriquea: —Noguijajiavequempiquea coramani, tequerataquea pincamantajiguenaji. Aviguentimpate Quirishitotatsica iintsijate pincamantamajajiguena imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iriraquea Jesoshi icantajiguiriquea: —Nomajiavequempitari nocamantajiavetaquempiquea, teequea pinquemisantajiguenaji. Oraquea nantaguequeca ivajiroqui Aapani nintacaaquenaroca, irooquea tsatacaaquempica quero nocotacani. ");
INSERT INTO cotNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Cotanquitsiquea aviatimpajia tee pinquemisantajiguenaji, teenicaquea avironica novejate. ");
INSERT INTO cotNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Irirajiaquea nashijia novejatepae iquemisantajiganaquea noquenquetsataquegueti, naatimpaquea notsajiguiri, iriatimpaquea yoguijaguijaitana. ");
INSERT INTO cotNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nanijacaajiajeriquea mananiji incoguitempani inchoocajiaje, aato ipega camorecariqui. Aatoquea ichoocati aapitsaquenarineca. ");
INSERT INTO cotNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aapani jocaquenarica yanaajiaqueri maasano. Aatoquea ichoocati aapitsaquerineca. ");
INSERT INTO cotNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naatimpaquea aisa Aapani apaniro nocanca. ");
INSERT INTO cotNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ariquea irirajia joriojia yaitsijianaja aisa mapi intsinacajiaquerime. ");
INSERT INTO cotNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Cotanquitsiqueate Jesoshi icantajiguiriquea: —Naatimpaquea yagavejacaaquenaquea Aapani nonigaaguequempiroquea taaca opajitapae cameetsaguetatsica. Imaica, ¿querocampate pintsinaquimentajiaquenaca? ");
INSERT INTO cotNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Icantajiguiriquea joriojia: —Aato iroguenti notsinaquimentajiguimpi taaca opajita pantaguetaqueca cameetsaguetatsica, iroguenti piquejemanatacari Aapani Irioshi. Aviguentitari caquinte, cotanquitsiquea pipinajashicari iriatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Icantsiijaariquea Jesoshi: —¿Teempa oncanteji Itioncacaantaquempica Aapani Irioshi: ‘Nocanque naatimpa, aviguentijia irioshijiatsica’? ");
INSERT INTO cotNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Itsajitirotari maasano Itioncacaantaqueca Aapani Irioshi aatoquea acanti tee iroomajaca, aisa iriguentiquea cantanquitsi Aapani irirajiaquea itigarancajiaqueneca Iguenquetsatsare iriguenti irioshijiatsica. ");
INSERT INTO cotNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iriguentitari nintacaaquena itigarancantaquenaca acaniqui quepatsiqui, ¿queroqueate ococani picantantaquenaca ‘Pipinajashitacari Aapani Irioshi’, nocanquegueti: ‘Naroguenti Irijanite Aapani Irioshi’? ");
INSERT INTO cotNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aatomegueti nantirome yantaguetica Aapani, cameetsamequea aato piquemisantajigana. ");
INSERT INTO cotNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Cotanquitsiquea imaica nantaquerotarite. Aatogueti piquemisantajiavetana nocantajiaquempigueti imaica, pinquemisantajiguenaja pamenajiaquerogueti nantaguetaquerogueti cameetsaguetatsica pintsamajajiaqueniji ichoocaquena Aapani, aisa noquejetaca naatimpa nochoocaqueri Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inintajiavetajaquea aisa iraaquerime irajaianaquerime irimetojacaantajiaquerime, cotanquitsiquea iriatimpa ariquea isotoapitsajianajiri. ");
INSERT INTO cotNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ariqueate Jesoshi yoanajiqueate intatiqueroqui Jororanequi iviñacajatantaquegueti Joanca iroaqueragueti, ariquea ichoocapoji oraniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yoajianaquequea oshequini caquintepae iramenajiaqueri, icantajiguiquea: —Iriraquea Joanca teequea ironigaantavetemparoji oacaantantatsica intati, cotanquitsiquea itsavetacotaquerigueti iricatica, arimaja maasano icanqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ariquea itsaroventajianacariquea oraniqui oshequini. ");
INSERT INTO cotNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Choocaquea joquijitanquitsica icantajitica Irasaro. Iguintenitaquea Vetaniaqui, oguintenitagueti Maria aisa oguetyote icantajitica Marita. ");
INSERT INTO cotNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ocatica Maria, iroguentiquea shaguitantacarica Amajirote casancajari iguitiqui, ariqueate osheguititantacari omae. Irira Irasaro joquijitanquitsica, iriguenti ojariri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ariquea iroatimpajia otigarancaqueri camantaquerineca Jesoshi incanquiteri: —Nomajirote, joquijitaca pipintsamajatacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iriraquea Jesoshi iquemaquegueti icanti: —Oraquea joquijirentsi aaquerica teequea iro oncoraquetantempa ometojaqueriniji, manaquea iramenimentajitaqueroniji caaviji yagavejamajati Aapani Irioshi, aisa intsajitaqueroniji caaviji yagavejamajati Irijanite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iriraquea Jesoshi ipintsamajavetaro Marita aisa oguetyote jeri aisa Irasaro, ");
INSERT INTO cotNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","cotanquitsiqueate iquemacovetacarigueti yojoquijica teequea irogueji, manaqueate imaanaji mavite savincaguiteri ontaniqui ichoocaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iroompaquea icantajiguiri itsatacaanejia: —Jameja oajianaje Joreaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iriraquea itsatacaanejia icantajiguiriquea: —Tsatacaantantatsica, iroaquerasampate inintajiavecaquea joriojia intsinacajiaquempime ontaniqui. ¿Arimpate poanajetampate aisa? ");
INSERT INTO cotNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Icanque Jesoshi: —Isotoguigueti catsirincaiteri ¿teempa oncarate 12 hora osavincaguitetanaque tequeratagueti inquijaje? Quericaca anijitatsineca savincaguiteriqui aato itivata, inejantacarotari otsirencaguite quepatsiquitica. ");
INSERT INTO cotNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Cotanquitsiqueate quericaca anijitatsineca pitsecariqui intivataquempaquea, teenicate onchoocateji tsirencaguitetacotaquenerineca. ");
INSERT INTO cotNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Irosati icanque: —Iriraquea atsipavijitaca Irasaro maaquequea, cotanquitsiquea noanaque nontinajeriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iriatimpajia icantajiguiriquea: —Nomajirote, imaaquegueti iroveanajempaqueate. ");
INSERT INTO cotNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Oraqueate icanquegueti Jesoshi: “Maaquequea”, iroguentiquea iquenquetsatacotaque imetojane, cotanquitsiquea iriatimpajia teequea inquemajigueriji, manaqueate ijijiaqueji arimaja imaaque. ");
INSERT INTO cotNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ariquea icamantamajajiaqueriquea Jesoshi, icantajiguiri: —Metojanaque Irasaro. ");
INSERT INTO cotNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cameetsa teequea nonchoocatsitempaji naatimpa ontaniqui pintsaroventimentajiaquenanijite aviatimpajia pamenajiaquerogueti nantaqueca. Cotanquitsiqueate imaica jameja oajianaque iriatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iquenquetsatanaquequeate Tomashi icantajitica Tsipari icantiriquea itsipapae itsatacaanejia Jesoshi: —Iroosacanicate jamequetirote oajianaque aatimpajia aisa, anquempejianaquempari Jesoshi ametojajiaque. ");
INSERT INTO cotNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ariqueate yarejerejeipojacagueti iquemacopojaqueriqueate Jesoshi Irasaro icaratacotanaque 4 savincaguiteri yoguijaantajitacarica omoroqui imperita. ");
INSERT INTO cotNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Oraqueate Vetania oquempejiquero Jerosare, arica ocarataque 3 quiromeetero. ");
INSERT INTO cotNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ariqueate ichoocaque oraniqui Vetaniaqui oshequi joriojia coraquejianquitsica iroguishinejajiajeroquea Marita aisa Maria oshimampojancacocari ojariri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Oraqueate Marita oquemacotavaquerigueti Jesoshi coraquetapojaque, oanaquequea ontonquivojavaquempariniji, oraquea Maria teequea ogueji iroatimpa, mana ochoocaque tsovironaquiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ariquea ocantavaqueriquea Marita Jesoshi: —Nomajirote, arimegueti pinchoocaqueme acaniqui aatomequea imetojime jai. ");
INSERT INTO cotNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cotanquitsiquea imaica notsaque taaca opaji pincanqueri Aapani Irioshi, inquemisantavaquempiquea. ");
INSERT INTO cotNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Icantiroquea Jesoshi: —Impochatanaje pijariri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ocantiri Marita: —Jeejeguitatsi, notsaque impochatanajeguitatsi oncoramanitapojajegueti impochajianajegueti maasano metojajiavetatsica aapojaquempagueti savincaguiteri vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Icantiro Jesoshi: —Naroguentiquea tancorejantatsica, naroguentitari anijagantsi. Quericaca quemisantaquenaneca irimetojavequempagueti impochatanajequea. ");
INSERT INTO cotNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maasano anijajiatsica quemisantajiganaca, aato imetojamajatitsi. ¿Piquemisanquerompa ocatica? ");
INSERT INTO cotNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ocantiri: —Jeejeguitatsi, Nomajirote, noquemisanquempiqueate, notsaquetarite aviguentiquea Quirishito, Irijanite Aapani Irioshi, aviguentitarite icamantacojitica incoraquetaque acaniqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ariquea ocanquitigui imaica Marita, opianaja ocajemapojiro Maria oguetyote, inchiquioji oquenquetsatacaaqueroquea ocantiro: —Arejetapojaca Tsatacaantantatsica, icajemacaanquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ariquea oquemavaquerogueti ocatiapanajantaquea oanaque ichoocaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tequeratatirajatarite irarejetempaji Jesoshi ochoocaguetigueti tsovironaquipae, manaqueate ichoocapojaque ontaniqui iroaqueragueti otonquivojavacarigueti Marita. ");
INSERT INTO cotNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Irirajiaqueate joriojia tsipajiacaroca Maria tsovironaquiqui, oguishinejaqueroca, iroompaquea yamenavaquerogueti ocatiapanajanta osotoanaque yoguijaguijaitanaqueroquea, ijiquequeate ari oanaque ichoocataquegueti ojariri iraacopojajeri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ariquea arejetapojacagueti Maria ichoocaquegueti Jesoshi, onejapojaquerigueti otigueroashitapojacari iguitiqui, ocantiri: —Nomajirote, arimequea pinchoocaqueme acaniqui aatomequea imetojime jai. ");
INSERT INTO cotNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ariquea yamenavaquerogueti Jesoshi iraanaca Maria jerijiaquea aisa joriojia tsipajiacaroca, ariquea iria ishimampojancavaetanacaquea. ");
INSERT INTO cotNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ariquea icanti: —¿Quero pojoquijiquerini? Iriatimpajia icantajiguiriquea: —Nomajirote, jameja pamenaquiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iraaca Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Icantajianaquequea joriojia: —Pameneri, caaviji ipintsamajatari. ");
INSERT INTO cotNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Cotanquitsiqueate iconoagarantajianacaquea mana icantajianaque intati: —Yagavejaquetari inejacajairi shamponcajavetatsica, ¿teempa iragavejeji irogueshitavajerime iricatica aatoniji imetoji? ");
INSERT INTO cotNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Arimpa ishimampojancavaetanaca Jesoshi. Ariqueate yarejetapojacaroquea omorotacagueti imperita yoguijaantajicarica, iroguenti iticaacotantajicari inirotsentseina mapi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Icanti Jesoshi: —Pintanarejeroja mapi. Oquenquetsatanaquequeate Marita itsijoite metojanquitsica, ocantiquea: —Nomajirote, aricaja pojitanaque, yoguijaitsijicaritari chapinqui, icaratacovaetanaquetari 4 savincaguiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Icantiro Jesoshi: —¿Arimpa tee noncantempi incajaranqui pinquemisanquenagueti pamenaqueroquea iragavejane Aapani Irioshi? ");
INSERT INTO cotNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ariquea itanarejajiaquero mapi. Iriraquea Jesoshi yamenanaque jenoqui inquitequi icanti: —Ariotesa, Aapani, noshinevaetacaqueate piquemavaquenatarite. ");
INSERT INTO cotNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Notsaquetari irosati picoguitaniquea piquemaquena, cotanquitsiqueate nocanquegueti imaica, iroguenti inquemisantimentajiaquempinijite maasano iricajia catintiijianquitsica, intsajiaquenijite arimaja aviguenti tigarancaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iroompaquea icanquegueti imaica iririjencatanaquequea icajemanaquequea icanti: —Irasaro, pisotoapojaje. ");
INSERT INTO cotNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ari isotoapojaji metojavetanquitsica aguiaguiaatacari omagopae iracopaequi, iguitipaequi, maasano. Oraquea ivoroqui ipashicacaro paaño. Icanti Jesoshi: —Poishorejacoterijate iroanajeta. ");
INSERT INTO cotNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Irootaquequea iquemisantantajiacarica oshequi joriojia oananquitsica tsipajiacaroca Maria yamenajiaquerogueti yantaqueca Jesoshi, itsajiapojaque iriomajaca. ");
INSERT INTO cotNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Cotanquitsiquea iconoagarantajiacaquea manaquea yoajianaque icamantajiapojaqueriquea pariseojia taa opajita yantaque Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ariquea icapiocajiacaquea pariseojia itsipajiacariquea saserorotejia anaantajianquitsica jerijia itsipajia majirontajiatsica, icantajiguiquea: —¿Queroquea ancojiaquerini irintatica? Yantaguetaquetari oshequi oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aatoguetitari acantajigui manaquea inquemisantajianaqueri maasano, ariquea incoraquejiaque Iromaquitica irisoveaqueroquea teemporo itsaroventantajitarica Aapani Irioshi, irashintsijiapojacajiroquea aguepatsijiate iroguivorocajiacajiquea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ariquea ichoocaque saserorote anaantamajatanquitsica icantajitica Caipashi. Iriatimpaquea iquenquetsatanaquequea icanti: —Teequea pintsajigueji aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tee pinquenquejajigueji ocameetsamajataque apatiroti caquinte irimetojaventaqueri caquintejia, aatoniji ateroncajiga maasano aguinteniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ora icanquegueti imaica teequeate inchiquiojitsita inquenquejashitemparoji iriatimpa. Iriotaquetari saserorote anaantamajatanquitsica oratica ajagantsi, irootaquequeate iquejetacaantantacarica Aapani Irioshi icantacotaquerigueti Jesoshi irimetojaventajiaqueri maasano joriojia. ");
INSERT INTO cotNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Cotanquitsiquea aatoquea apaniro irimetojaventajiaqueri joriojia, irimetojaventaqueriqueate aisa maasano irijanijiate Aapani Irioshi guinteniguetatsica osamanipaequitica, incapiocajiaquerinijite apapioro incantanajempa. ");
INSERT INTO cotNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Irosatiquea isarijantajianacarica irimetojajiaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ariqueate iriatimpa teequea ironigaajiajempariji ichoocamajajiaquegueti joriojia, manaquea yoanaque guinteninintsiqui icantajitica Eperaine oquempejitigueti oquitamampororoipojigueti. Ariquea ichoocapojaji oraniqui itsipajiacariquea itsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pajiniquea aapojempa ishineventajiacaca joriojia icantajitica Paashicoa. Oshequiniquea quenaguetapojatsica querocagueti iguinteniguetani yoayoaitanaquequea Jerosarequi irinetsanamajajiaquempa tequeratagueti arejetempa Paashicoa, irootarite yamejigaca iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Icoaguequeriquea Jesoshi oraniqui. Ariquea ichoocajiaquegueti teemporoqui oniganquirequi icantavacaajiacaquea: —¿Quero pincanteni? ¿Arimpa incoraqueque imaica Paashicoaqui? ");
INSERT INTO cotNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Irirajia pariseojia jerijia saserorotejia anaantajianquitsica icantajiaqueritarite maasano: —Pitsaquegueti quero ichoocaqueni Jesoshi, pincoraqueque pincamantajiguena cameetsaniji naacaanqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ocaratapojaquegueti 6 savincaguiteri arejetantapojaquempaca Paashicoa, iriraquea Jesoshi yoanaquequea Vetaniaqui iguintenitagueti Irasaro metojavetanquitsica yovochantajica. ");
INSERT INTO cotNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ariquea oraniqui itijaiqueroquea irishecaquempaca Jesoshi, irishineventajiavaquempariquea. Oraquea Marita iroguenti amajiaqueneri. Iriraquea Irasaro ari ichoocaque oraniqui shitaponcarontsiqui iconoajiacari maasano tsipajiacarica Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ariquea ocoraquepojaquequea Maria amacotaquequea apanaquitiro vegaramajatanquitsica casancajencajatatsica ipeantajitaroca naarero, tee inconoajatantajitemparoji otsipaja. Oshaguitancariquea iguitiqui Jesoshi, iroompa oshetantavacariquea omae. Ariquea ocotanaca oponcajajencatanaquequea otsitacajencatanacaro tsovironaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ariqueate ichoocaque oraniqui Jorashi Ishicariote irijanite Shimo, iriguentiqueate itsatacaane Jesoshi amampivenquerineca coajica. ");
INSERT INTO cotNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Icanti: —¿Queroquea ocotacani teequea irojocantajiteroji? Iraantajiquemparome oshequi imentaquipae irooriji ovegaravaevetaca 300 tenario, irojocajitaquenerime coguitejacojianquitsica. ");
INSERT INTO cotNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Cotanquitsiquea teequea arimaja inquenquejamajateriji coguitejacojianquitsica, manaqueate icanquegueti imaica yamenaque iriguenti ajiricacotapiniquenerica imentaquitsitepae itsipajiacaca, ariquea yaagarantsitaqueriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Cotanquitsiqueate Jesoshi icantsitariquea: —Ari ocotaca, naroguentitarite otsotejatashitaca oshaguitanquenaca imaica, iroguijaajiquenatari omoroqui coajica nometojanaquegueti. ");
INSERT INTO cotNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iriraqueate coguitejacojiatsica icancanitarite intsipajiaquempi, naatimpaquea aatotari nocoguitani notsipajiguimpi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ariquea iquemacojiaquerigueti oshequini joriojia chooca Jesoshi Vetaniaqui, yoayoaitanaquequeate iramenajiaquiteri, cotanquitsiquea tee apaniro iroashijianaqueriquea iriatimpa, yoayoaitashitanaqueriquea aisa Irasaro yovochantajica Jesoshi imetojavetacagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ariqueate iquemavacaajianacaquea saserorotejia anaantajianquitsica irimetojacaantajiaqueri aisa Irasaro, ");
INSERT INTO cotNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yamenajiaquetarite irio iquemacojiaque oshequi joriojia yovashiantantajianajarica iriatimpajia teequea inquemisantajiajeriji, iriguentiquea iquemisantajianaque Jesoshi, yaventajianacari. ");
INSERT INTO cotNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Choocaquea oraniqui Jerosarequi oshequini coraquejianquitsica irishineventajiguemparo Paashicoa. Ariqueate osavincaguitetamanaquegueti iquemacojiavaqueriqueate Jesoshi coraquetaque. ");
INSERT INTO cotNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yaavashijianaquequea ovashi yoayoaitanaque itonquivojajiavacariquea icajemajianaquequea icantajigui: —¡Caaviji yoganejencamajataca! —¡Iintsishiatsi irishineventajiquempari iriratica coraquetapojatsica itigarancaqueca Majirontamajatatsica! ¡Iriotaque Imajirote ishiraerijia! ");
INSERT INTO cotNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iroompaquea irira Jesoshi inejapojaqueri iriaqueraca quimogantirenatananquitsica aashino yaaqueriquea isavicanaqueri, ariquea onetsanatanacaquea itioncacojiquerigueti ocanti: ");
INSERT INTO cotNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Aatoja pitsaroajigui aviatimpajia Shionequitica, coraquetapojaquetari pimajirote, ishiacotantapojari iriaqueraca quimogantirenatananquitsica aashino.” ");
INSERT INTO cotNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Cotanquitsiqueate irirajia itsatacaanejia tequerata intsajigueji irootaquequea netsanataqueroca itioncacojiquerigueti, cotanquitsiquea ariquea yogajenocashitanajarogueti Jesoshi iroganejencare ariquea iquenquejajianaqueroquea maasano yamenaguetaqueca ari itsajiapojaque: arimajasacanicate iriguenti oquenquetsatacotaque itioncacojiquerigueti, irootaquequea iquejetantajicarica imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Irirajiaquea amenajiaquerica Jesoshi yovochantajirigueti Irasaro icajemaquerigueti yoguijaajivecarigueti icamantajiaqueriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Irootaquequea yoayoaitantanacaca itonquivojajiavacariquea Jesoshi, iquemacojiaqueritari yantaquero oacaantantatsica intati. ");
INSERT INTO cotNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Irirajiaquea pariseojia icantavacaajianacaqueate: —Jeroquea nocantavequempi. ¿Queroquea ancojiaquempani imaica? Pamenajiguerija maasanojia yoguijajianaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yoagarantajianaquequeate aisa guiriegojia Jerosarequi irogavisaajiguero Paashicoa intsaroventajiguempari Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Iriatimpajia yoayoaitanaque ichoocaquegueti Jeripe poneanquitsica Vetsairaqui choocatantaroca Garireaqui, icantajiguiriquea: —Nonintajiaque nonejajiaqueri Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Iriraquea Jeripe yoanaque icamantapojiriquea Antirishi, ariquea itsipatanacari yoayoaitanaque icamantajiaqueriquea Jesoshi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iquenquetsatanaquequea Jesoshi, icantajiavaqueri: —Aapojacaquea ironigaantantajitaquemparoca iroganejencare Irijanite Caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Imaica noncamantamajajiaquempiquea, arigueti osacoroncaguite tirigoitsoqui quepatsiqui, aatogueti osampirocaguiti oitsoqui, aatoquea oshequigui, manaquea apaitsoquiro oncanquempa. Cotanquitsiquea osampirocaguitegueti ontsoroanaque oitsoquimajatanaque. ");
INSERT INTO cotNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ariquea iquempetaca imaica quericaca tsaroacaatsica iriatimpa teequea irinintimateji irantsipeventaquempari itsipa, icavintsajavecaquea cotanquitsiquea irimetojaque coajica. Cotanquitsiquea iriraquea teeca incavintsajempaji iriatimpa acaniqui quepatsiqui iroguenti iquenquejacotaqueri itsipa yatsipevencariquea, iriguentiquea incoguitempaniquea iranijaguiteni. ");
INSERT INTO cotNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Quericaca nintanquitsica irantaguequero nonintaguetica naatimpa, iroguijatacotenata. Querocagueti nonchoocaquegueti naatimpa, ari inchoocaque aisa iriatimpa notigaranquica. Iriraqueate antaguetiroca nonintaguetica naatimpa, irishinevenquempariquea Aapani incanqueriquea: ‘Cameetsavaetaquequea.’ ");
INSERT INTO cotNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Imaicaquea noshoshoguitevaetanacaquea, cotanquitsiquea ¿queroquea noncanteni? ¿Arimpa noncante: ‘Aapani, pincavintsajenashia aatoniji natsipeta nometojaque’? Aatoquea nocantiritsi, irootaquetarite nocoraquetashique, irootaque narejetantapojacaroca ocatica savincaguiteri. ");
INSERT INTO cotNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aapani, ponigaantero poganejencare irishineventajiaquemparoniji pivajiro.” Ariquea iquenquetsajitanaquequea ontaniqui jenoqui inquitequi icanti: “Nonigaantaquerotari noganejencare, coajicaquea nonigaantajero aisa.” ");
INSERT INTO cotNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ariquea iquemajiaquerigueti maasano catintiitanquitsica iconoagarantajiacaquea icantajianaque mana oseroroncaguitetanaque intati, cotanquitsiquea itsipa cantajiananquitsica: —Iriocaja quenquetsatanquitsi irashivantite Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iriraqueate Jesoshi icantajiguiriquea: —Tee iro inquenquetsatantempaji nonquemero naatimpa, iquenquetsatantacaca cameetsaniji pinquemajiaqueroniji aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Imaicaquea aapojaca incantantajitaquempaca quero incojitaquerini covaeguishejiatsica quepatsiquitica, aisa iroguisotoajiteri irira majirontavetanquitsica acaniqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Oraqueate irogatiacojitaquenagueti acaniqui quepatsiqui noncajemashirentajiaqueriquea maasano. ");
INSERT INTO cotNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Oraqueate icanquegueti imaica manaqueate itsavetantanaqueroquea quero incojitaqueri irimetojajiquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Irirajiaquea capiocaventajiacarica icantajiguiriquea: —Noquemajiaque itsatacajaitanagueti Itioncacaantaqueca Aapani Irioshi ocanti irira Quirishito incoguitempani inchoocaguiteni. Imaica ¿queroquea ocotacani picantantacaca irogatiacojitaqueri irira Irijanite Caquinte? ¿Queriquea imaica Irijanite Caquinte? ");
INSERT INTO cotNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iriraquea Jesoshi icantajiguiriquea: —Imaicaquea igantagatiraja ichoocatimojiaquempi Tsirencari, cotanquitsiquea capichajaniquinivani. Panijijiaquequea imaica igantagatirajagueti itsirenquimojiaquempi, tequeratagueti pimpitsecacojigueji. Iriraquea anijitatsica pitsecariqui teequea intsateji quero iquenanaqueni. ");
INSERT INTO cotNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nocantantaquempicaquea, pinquemisantajiguerija Tsirencari choocatirajagueti, pinquejetimentajianaquempariniji iriatimpa. Ariquea iquejequerogueti imaica Jesoshi iquenquetsataquegueti yoanaquequea, ipeapitsajianajari. ");
INSERT INTO cotNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iriraquea Jesoshi yantavecaquea maasanopae oacaantantatsica intati yamenacajaiavecariquea maasano, cotanquitsiquea iriatimpajia teequea intsajiavaqueriji, teequea inquemisantajiavaqueriji. ");
INSERT INTO cotNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iroguentiquea oquejetantanacaca imaica cameetsaniji onetsanatanaquempanijite itioncaqueca tsavetantatsica Isaiashini, ocantiquea: “Nomajirote, notsavetantajiavecaroquea picanqueca cotanquitsiquea ¿taa quemisantavaquero? Ponigaajiavetacari pagavejica cotanquitsiquea ¿taa tsatavaquero?” ");
INSERT INTO cotNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oquejetantanacaca imaica teequea iragavejajigueji inquemisantajigueji, iroorijite icanque Isaiashini aisa itioncaquerogueti icanti: ");
INSERT INTO cotNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Iriraquea Aapani Irioshi ishamponcajatacaajiaqueri, iquishoshirentacaanaqueri, aatonijite inejantajiajarotsi iroquija, aatoniji itsajigui ishirequi, aatoniji ipitsocashijigana nogueshishirentantajemparica.” ");
INSERT INTO cotNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iriraquea Isaiashini icanqueroquea ocatica imaica yamenaqueritarite Jesoshi caaviji yoganejencamajata irootaquequea itsavetacotantacarica. ");
INSERT INTO cotNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Oquempevecaquea imaica cotanquitsiquea ichoocajiaque oshequini caquintejia aisa imajirojiate cantajianquitsica Jesoshi iriguenti Quirishito Meshiantatsica, cotanquitsiquea inchiquiojiquea icantajiaque imaica itsaroacaajiacaritarite pariseojia icantimentajiguiritsiqueate inquijajianaquegueti shinagogaqui icapiocantapinijiacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Inintajiavetacatari irishineventajiaquemparime Aapani Irioshi, cotanquitsi iroguenti inintamajajiaque irio shineventajiaquemparine caquintepae. ");
INSERT INTO cotNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ariquea iquenquetsatanaquequea Jesoshi iririjencaquea icanti: “Maasano quemisantanaca teequea apaniro inquemisantena naatimpa, iriguenti iquemisantaque tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ariquea iquejetacaquea nejaquenaca, inejaqueriqueate aisa tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naroguenti Tsirencari, iroguenti nocoraquetashitaque quepatsiqui aatoniji ipitsecacotaji quericaca aventaquenaneca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Cotanquitsiqueate quericaca quemavetavaquenane aatogueti inetsanatiro nocanqueca aatoquea naroguenti cantatsi incatsimatimentajiteri igovaeguishere, teequea iro noncoraquetashite noncantacoteri caquintejiatsica incatsimatimentajiteri igovaeguishere, iroguentiquea nocoraquetashique naajiavajeri aatoniji ipega. ");
INSERT INTO cotNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Quericaca manintaquenaneca, teeca irininteji inquemisantero nocanqueca, choocaquea cantacaanquerineca: iroguentiquea nocanqueca noquenquetsavetacagueti. Irootaquetari cantacaanquerine aapojaquempagueti savincaguiteri vegaratapojaatsineca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Teenicaquea inchiquiojitsi naashitemparoji naatimpa maasano querocaca nocanqueca. Iriguentiqueate cantaquena Aapani tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Notsaquequea ora icantacaantaqueca Aapani, iroguenti anijacaantantatsica iranijantaguitempanica, irootaquequea noquejetantacaroca imaica: ora icanquenaca Aapani irootaque nocanque.” ");
INSERT INTO cotNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tequeratagueti aguempaji Paashicoa, itsaquequea Jesoshi aapojaca irojocantanajemparoca ocatica quepatsi iroanajequea Aapaniqui. Igantagaquea coramani ipintsajiacari yashintajiacaca acaniqui quepatsiqui, icoguitaniquea ipintsamajajianacari, irosati yonigaantamajataquero quero ocarataqueni ipintsamajatacari caquinte. ");
INSERT INTO cotNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Opitsecanajigueti ishecajiaca. Incajaranqui iquenquejacaaqueri ampatsini Jorashi Ishicariote, irijanite Shimo, iramampijaqueneri Jesoshi iraacaanqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Itsaquequea Jesoshi yagavejacaaqueri Aapani Irioshi maasano, itsaque iponeaca Aapaniqui Irioshiqui aisa iroanaje iriatimpaqui, ");
INSERT INTO cotNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","irootaquequea icatiantanacaca ishecajiacagueti, iquitsaarejanacaro iitsaare jenoquitanquitsica, yaaquero ishetantajitaca ishipitacaro. ");
INSERT INTO cotNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ariquea ishajataqueroquea oja vantejaqui, iquivaguitijiaqueriquea itsatacaanejia, isheguititantajiajari ishipitacaca. ");
INSERT INTO cotNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yarejetapojacarigueti Shimo Peerero, icantavaqueri: —Nomajirote, ¿aviguentimpa quivaguititenane naatimpa? ");
INSERT INTO cotNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Icantiriquea Jesoshi: —Tequeratanicate pintsateroji quero ocotacani noquejetancaroca imaica, cotanquitsiquea coajicaquea pintsapojero. ");
INSERT INTO cotNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Icantsitariquea Peerero: —¡Aatoja piquivaguititimatana naatimpa! Icantiquea Jesoshi: —Aatogueti noquivaguititimpi, aato nagaveji notsipatajimpi. ");
INSERT INTO cotNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ariquea icantiriquea Shimo Peerero: —Nomajirote, arisacanicate aatoqueate aparo piquivaguititana, pinquivacotaquenaquea, aisa pimaqueroquea noguito. ");
INSERT INTO cotNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Cotanquitsi Jesoshi icantiri: —Iriraquea cajatatsica mana inquivaguititajempa intati, ariquea onetsanatanaja maasano itsinoqui. Imaica aviatimpajia netsanajiavetaquempiquea, cotanquitsiquea teequea maasano pinetsanajiguempaji. ");
INSERT INTO cotNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Itsatsitacatari queri amampijaquenerineca aacaanquerineca, irootaquetari icantantacaca: “Teequea maasano pinetsanajiguempaji.” ");
INSERT INTO cotNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ariqueate iteroncaquerogueti iquivaguitijiaquerigueti iquitsaatanajaquea yovanquetacaca, yoanaji isavicapojaji shitaponcarontsiqui, icantajiguiriquea: —¿Pitsajiavaquerompate taa opaji noquejetacaacaca noquejejiaquempirogueti imaica? ");
INSERT INTO cotNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Aviatimpajiaquea iroguenti picantajigana: ‘Tsatacaantantatsica’, aisa picantajigana: ‘Nomajirote.’ Tampaticaquea poaquero, aritari nocota. ");
INSERT INTO cotNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arivetaca imaica naroguentivetacaquea tsatacaajiguimpica, aisa naroguentivetaca Pimajirote, cotanquitsiquea noquivaguitijiaquempiquea. Ari pinquejetacaajiajemparo aviatimpajia pinquivaguititavacaajiaquempaqueate. ");
INSERT INTO cotNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naatimpaquea manaqueate noquejetaquerogueti imaica cameetsaniji namenacajaiaquempironijite pimpampiatimenqueronijite aviatimpajia, pinquejejiaquenaquea naatimpa imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Noncamantamajajiaquempiquea irirajia aajanirentsi teequea iranagueriji aajanitarica. Ari iquejetaca itigarancajitica teequea iranagueriji tigarancaquerica. ");
INSERT INTO cotNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Imaica pintsajiaquerogueti ocatica nocantajiaquempica, pinquejejiavaquerogueti aviatimpajia, ariqueate pishinemajajianaquempaquea. ");
INSERT INTO cotNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Cotanquitsiqueate nocanquegueti imaica teequea nonquenquetsatacojiguempiji aviatimpajia maasano, notsamajajiguiritari nocoguiajiaqueca. Cotanquitsiqueate oquejetantanacaca imaica onetsanaquempaniji Itioncacaantaqueca Aapani Irioshi ocantigueti: ‘Iriraquea shecatacoquenaca icatsimatanaquena.’ ");
INSERT INTO cotNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nocamantsijiaquempiquea imaica tequeratagueti onetsanatempaji, cameetsaniji coajica onetsanaquempagueti pintsajiaquenanijite narotaque. ");
INSERT INTO cotNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Noncamantamajajiaquempiquea quericacaquea shineventavaquemparineca notigarancaqueca naroguentiquea ishineventavaca, aisa quericaca shineventavaquenaneca naatimpa iriguenti ishineventavaca tigarancaquenaca.” ");
INSERT INTO cotNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iroompa icanquitigui Jesoshi imaica, ariqueate icotanaca ishimampojancavaetanaca, ariquea icamantamajajianaqueri icantajiguiri: —Imaica noncamantamajajiaquempiquea, chooca aparo atsipajiacaca ocaniqui iraacaanquena. ");
INSERT INTO cotNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ariquea icojianaca itsatacaanejia yamenavacaajianaca, tee intsateji queri iquenquetsatacotaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iriraqueate itsatacaane ipintsamajataca Jesoshi choocaquea ipimerequijaca iquempejimajacari ishecajiacagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Iriraquea Shimo Peerero icanquiti guitoc incoacotimenqueriniji Jesoshi quericaca iquenquetsatacotaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ariqueate iriatimpa itsipamajatapojacariquea Jesoshi icantiri: —Nomajirote, ¿queri? ");
INSERT INTO cotNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Icantiri Jesoshi: —Imaica nojocajaquerogueti ocatica pan ashecajiacaca, quericaca nojocaqueneca iriotaque. Ariquea iquejetaquero yojocajaquero pan yojocaqueneriquea Jorashi Ishicariote irijanite Shimo. ");
INSERT INTO cotNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iroompaquea ishecataquitigaro ariquea icotanaca iquijanaqueriquea Satanashi. Iriraquea Jesoshi icantiri: —Oraquea piquenquejaqueca iintsija pantero taampina. ");
INSERT INTO cotNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Cotanquitsiquea itsipajia shecajianquitsica teequea intsajigueji quero ococani icantaquerigueti imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iconoagarantajiacaquea iquenquejajiaque arica Jesoshi icanqueri Jorashi iroanaque irovegarataquite irishecajiaquempaca Paashicoaqui, iroocampa irojocajigueneri imentaquipae coguitejacojianquitsica. Iriguentitari ajiricacojiguinirica imentaquitsitepae iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ariquea yagaquegueti ishecatacaro pan yojocaquenerica Jesoshi, ari isotoapanajanti. Pitsecanaque. ");
INSERT INTO cotNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iroompa yoanaquitigui Jorashi icantiquea Jesoshi: —Aapojacaquea irogajenocashitantanajaroca iroganejencare Irijanite Caquinte; irooquea irinejantajitaquemparoca iroganejencare Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ironigaanquerogueti iroganejencare Aapani Irioshi, ariqueate inquejetaquempa iriatimpa ironigaanqueroquea iroganejencare Irijanite Caquinte, taampinaquea ironigaanquero. ");
INSERT INTO cotNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Irijanijia, imaica aato osamani notsipamajajiajimpi. Ariquea pamenaguevetajenaquea, cotanquitsi noncamantajiaquempi aviatimpajia nocamantajiaquerica apijoriojiate: Aatoquea pagavejajigui poajigue querocagueti noanajeni naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Imaica noncamantajiaquempiqueate iroaqueratanquitsica pinetsanajiaqueca: pimpintsatavacajaiaquempaja. Pinquejejiguenaquea naatimpa nopintsamajajiaquempigueti, ariqueate pinquejejiguempa aviatimpajia aisa pimpintsatavacaamajajiaquempaja. ");
INSERT INTO cotNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pinquejejiaquempagueti imaica pimpintsatavacaamajajiaquempagueti irooquea intsatantajitaquempica aviguentijia notsatacaanejia. ");
INSERT INTO cotNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ariquea irira Shimo Peerero icantiri Jesoshi: —Nomajirote, ¿queroquea poanajeni? Iriatimpaquea icantiri: —Querocagueti noanaqueni naatimpa, aatoquea pagaveji poguijatana aviatimpa, cotanquitsiquea poguijatanajena coajica. ");
INSERT INTO cotNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iriatimpa icantiri: —Nomajirote, ¿queroquea ocotacani aatoca nagavejanta noguijatimpi noanaquequeate imaica? Naatimpaquea nometojavenquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iriraqueate Jesoshi icantiri: —¿Arimajampa pimetojavenquena? Imaicaquea noncamantamajaquempi, coajica tequeratagueti irinijeji chaapa pomanacoquenaquea 3. ");
INSERT INTO cotNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Aato pitsaroashirentajigui. Iriguenti pavenquempa Aapani Irioshi, aisa pavenquena naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ontaniqui itsovironaquitequi Aapani chooca oshequini piguintenitantapojajempaca. Oraqueate aatomegueti ochoocatime, noncantajiaquempimequeate. Imaicaqueate noanaje novetsicaguetapojempiro pinchoocatantajiapojajempaca aviatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ariquea noanajegueti novetsicaguetaquitempirota pinchoocatantajiapojempaca, nompiashijiaquempiqueate naajiajatempi poimentajianaquenijite pinchoocatantajiapojempaca ontaniqui naatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pitsajiaqueroquea quero noanaqueni, aisa pitsajiaquero quenavoquirontsi.” ");
INSERT INTO cotNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Icantiri Tomashi: —Nomajirote, tee nontsajiguenica quero poanaqueni, ¿querocampate noncojiaquempani nontsatantajiaquemparoca quenavoquirontsi? ");
INSERT INTO cotNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iriraqueate Jesoshi icantiri: —Naroguentitari quenavoquirontsi, aisa naroguenti arimajatatsica, aisa naroguenti anijagantsi. Teenicate iragavejajitempaji iroashijitanaqueri Aapani aatogueti iquenantanaquena naatimpa. ");
INSERT INTO cotNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pintsajiaquenamegueti naatimpa, pintsajiaquerimequea Aapani aisa. Aritaque imaica pitsajiaqueri, pinejajiaqueri. ");
INSERT INTO cotNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iquenquetsatsitanacaqueate Jeripe icantiri: —Nomajirote, iintsija ponigaajiguenari Piri, ariquea ovegarapojempa. ");
INSERT INTO cotNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Icantiriquea Jesoshi: —Jeripe, notsipatsijiavetaquempiquea coramanitacotapojimpiquea. ¿Tequeratatirajampa pintsatenaji? Maasanoquea nejaquenaca naatimpa inejaqueriquea aisa Aapani. Imaica ¿queroquea ocotacani picantantaquenaca: ‘Ponigaajiguenari Piri’? ");
INSERT INTO cotNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Teempa pintsateji naatimpa nochoocaqueri Aapani, iriatimpa Aapani ichoocatana? Maasanoquea nocantajiaquempica teequea inchiquioji naashitemparoji naatimpa, ichoocaguitanatari Aapani irootaquequeate maasano nantaqueca irioquea antaquero. ");
INSERT INTO cotNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pinquemisantajiaquenaja noncamantajiaquempigueti naatimpa nochoocaqueri Aapani, iriatimpa Aapani ichoocatana. Aatogueti piquemisantajiguiro nocanqueca, irooquea pinquemisantantaquenaca pamenajiaquerogueti nantaguetaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Imaica noncamantamajajiaquempiqueate quericaca quemisantaquenaneca inquejetaquenaquea naatimpa irantaguequequea nantaguetaqueca, aisa irantaguetaquequea otsipapae anaaqueroca nantaguetaqueca naatimpa, noanajetarite Aapaniqui. ");
INSERT INTO cotNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Taaca opajita pamanantaqueca novajiroqui, irootaque nantavaque nonigaanqueronijite yoganejencamajata Aapani intsaroventantajitanaquemparica. ");
INSERT INTO cotNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pamanaquenagueti novajiroqui, nonetsanatavaquempiro. ");
INSERT INTO cotNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Arigueti pipintsajiaquena, pinetsanajigueroquea nocantajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ariquea naatimpa namaneri Aapani intigarancaqueriquea itsipa Amitacotantatsica incoguitempaniniji intsipajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iriotaque Ishire Aapani Irioshi cantaqueroca iroomajatatsica. Itsipajia quepatsiquitica aatoquea yagaveja ishineventajiavajari, teenicate irinejajigueriji, teequea intsajigueriji. Cotanquitsiquea aviatimpajia pitsajiguiri, ichoocatimojiaquempitari ariquea inchoocashirentajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Aatoquea novashiantajiguimpi pinquejejiaquemparime metojacori, noncoraquetashijiajempitari. ");
INSERT INTO cotNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Capichajaniquinivani aato inejaijaana quepatsiquitica, cotanquitsiqueate aviatimpajia pinejajiajena. Iroorijite nanijaguitini naatimpa, ariquea panijaguiteni aviatimpajia aisa. ");
INSERT INTO cotNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aapojempagueti oratica savincaguiteri ari pintsajiaque arimaja nochoocataqueri Aapani, aviatimpajia pichoocajiaquena, naatimpaquea nochoocajiaquempiquea. ");
INSERT INTO cotNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iriraquea tsatavaqueroca nocantica netsanatiroca, iriotaque pintsataquenaca. Iriraquea Aapani impintsataquempariquea pintsataquenaca. Ariquea nonquejetaquempa naatimpa nompintsataquempariquea, aisa nonigaaqueriquea quero nocotani.” ");
INSERT INTO cotNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iquenquetsatanaquequeate itsipa Jorashi (teequea irio Ishicariote), icantiri Jesoshi: —Nomajirote, ¿queroquea ocotaca apaniro naatimpajia ponigaajiaquena quero picotani, itsipajia caquintejia aatoquea ponigagari? ");
INSERT INTO cotNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Icantiri Jesoshi: —Quericacaqueate pintsatanaca irinetsanataqueroquea nocantica. Iriraquea Aapani impintsataquempariquea. Naatimpa nontsipataquempariquea Aapani noncoraquetashijiaquerigueti noguintenitapojempa iriatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iriraquea teeca impintsatenaji teequeate irinetsanateroji nocantica. Teequea inchiquioji naashitemparo nocantajiaquempica imaica. Iriguentiquea cantaquena Aapani tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nocanquempiroquea ocatica imaica choocatirajanagueti notsipajiaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cotanquitsiquea intigarancaquerigueti Aapani Ishire, Amijiajempineca quejetajenaneca, intsatacaajiaquempiquea iriatimpa maasanopae, aisa inquenquejacaajiajempiroquea maasano nocantajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Imaica noshinetacaajianaquempiquea aatonijite pitsaroajigui, pinquejejianaquenaquea naatimpa noshinevaetanacagueti. Naatimpaquea teequea nonquejetempariji ishinetacaantagueti caquinteguetatsica. Aatoquea pishimampojancajiga, aisa aatoquea pitsarogui. ");
INSERT INTO cotNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Imaica piquemajiaqueroquea nocanquempigueti noanaje, coajicaquea noncoraquetashijiajempi. Arimajamequea pimpintsajiaquename pishinejianaquempamequea piquemajiaquerogueti nocanquegueti noanaje Aapaniqui, yanaaquenatari. ");
INSERT INTO cotNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nocamantajiaquempiquea imaica tequeratagueti arejetempaji noantanajempaca cameetsaniji coajica arejetapojempagueti pintsajiaqueniji arimajaquea nocamantamajajiaquempi irosatiquea pinquemisantajianaquena. ");
INSERT INTO cotNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Imaicaquea aato osamanitaji noquenquetsatacaajimpi, coraquetapojaquetarite irira majirontavetanquitsica acaniqui quepatsiqui. Aatoquea yagavejana, ");
INSERT INTO cotNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","cotanquitsiquea onquejetaquempaquea imaica cameetsanijite intsatimentajiaqueronijite maasano naatimpaquea nopintsamajatacariqueate Aapani, aisa nonetsanataqueroquea maasano icanquenaca. “Imaicaqueate pincatiajianaque, jamequetiro. ");
INSERT INTO cotNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Naatimpa noquejetacaro ovorentsamajaca ova. Iriraquea Aapani iquejetacari shiacotiroca. ");
INSERT INTO cotNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Irivatejatsaguetavaqueroquea maasano notsegotsa teeca onchoocatantemparoji oitsoquipae. Oraquea otsipapae pitsaraquijacotanquitsica manaquea irinetsanaguetavaquero intati intotacoguetavaquero cameetsanijite ompitsaraquijacotimentamajatanaquempanijite. ");
INSERT INTO cotNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Imaicaquea aviatimpajia netsanataquempiquea shejiacatari piguempevaere, iroguentiquea netsanajiaquempi quenquetsatsarentsi nocantajiaquempica. ");
INSERT INTO cotNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pincoguitempaniquea pintsipamajajiaquenaja, ariquea nonquejetaquempa naatimpa noncoguitempani nontsipamajajiaquempi. Pameneroja oratica otsegotsa ova aatogueti ogavitaro ovorentsa aatoquea ochoocati oitsoqui, aatotari ochoocatashita inchiquioji. Ariquea piquejejiaca aviatimpajia, aatogueti quisho poajigana, aatoquea pagavejajigui inchiquioji pinetsanajiguero inintaguetica Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Naatimpaquea quejequena ovorentsa, aviatimpajiaquea quejequempi otsegotsapae. Quericagueti tsipamajataquenaneca nontsipamajataquemparigueti irantaguequeroquea inintaguetica Aapani, inquejetanaquemparoquea otsegotsa pitsaraquijacotatsica. Arigueti pintsiparejanaquempa aatoquea pagaveji. ");
INSERT INTO cotNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iriraquea caarica tsipamajatana manaquea inquejetanaquemparo otsegotsapae ova icaratsajitaqueca impishoncajiguetavaqueroquea intati, ariqueate ompirijatanaque coajicaquea iravijiquero irojocajiquero paamariqui omorecanaquequea samimimimi. ");
INSERT INTO cotNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Imaica aviatimpajia pincoguitempanigueti pintsipamajajiaquena, aisa aatogueti pipeacojigaro notsatacajaiaquempica, pamanajiaqueriquea Aapani taaca opajita pinintaguequeca, ariquea irinetsanatavaquempiro. ");
INSERT INTO cotNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jeroquea irinejantajitaquemparoca iroganejencare Aapani: pimpitsaraquijacotaquempagueti pimpeantamajaquempaca notsatacaane. ");
INSERT INTO cotNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Naatimpaquea nopintsamajajiaquempiquea aviatimpajia, noquejetacari Aapani ipintsamajatanagueti. Imaica picancanija quisho poajiguena noncoguitempaninijite nompintsamajajianaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Naatimpaquea nonetsanatiroquea icanquenaca Aapani, ariqueate iriatimpa icoguitaniquea ipintsamajataquenaquea. Ariquea pinquejejiaquempa aviatimpajia pinetsanajiaquerogueti nocantajiaquempica, naatimpaquea noncoguitempaniquea nompintsamajajianaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Manaquea nocantajiaquempiquea imaica cameetsaniji noguishinejajiaquempiniji pishinemajajianaquempaniji. ");
INSERT INTO cotNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Jero ocatica noncantaquempica poguijajianaqueca: pimpintsatavacaajiaquempaja, pinquejejiaquena naatimpa nopintsajiaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Quericaca metojaventirica itsipavijimajajiaca iriotaque pintsamajatacarica. Tee iragavejeji itsipa iranaaquero ocatica. ");
INSERT INTO cotNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Arigueti pinetsanamajajianaquero nocantajiaquempica aviguentiquea notsipavijimajajiaca. ");
INSERT INTO cotNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Imaica teequea noncantajiajempiquea naajanirejia, iriraquea aajanirentsi teequea intsateroji maasano yantaguetica aajanitarica. Iroguentiquea nocantajiaquempi notsipavijijiaca, notsatacajaiaquempirotarite maasano icanquenaca Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Teequea aviroquea coguijaiguenane, naroguentiquea coguijaiaquempi. Mana nonintacaajiaquempi intati poajianaque pantaguetaquero cameetsaguetatsica pinquejetantajianaquemparoca pitsaraquijacotatsica sovenaguetatsica, aatoquea opega. Noninque pinquejejiaquero imaica cameetsanijite irinetsanatavaquempironiji Aapani pamanaquerica novajiroqui. ");
INSERT INTO cotNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jero noncantaquempica poguijajianaqueca: pimpintsatavacaajiaquempaja. ");
INSERT INTO cotNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pamenajiaquerigueti irisemaneguintajiaquempigueti quepatsiquitica pinquenquejajiajeroquea naroquetitari isemaneguintajiaca. ");
INSERT INTO cotNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pinquejejiaquemparime quepatsiquitica teeca inquemisantajiguenaji impintsajiaquempimequea, inquejetacaajiaquempimequea ipintsatavacaajigagueti iriatimpajia. Cotanquitsiquea nocoguiajiaquempi piconoajiavetacarigueti irooquea isemaneguintantajiaquempica, teetarite pinquempejiajempari iriatimpajia. ");
INSERT INTO cotNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pinquenquejajigueroja nocantajiaquempica incajaranqui nocanti: ‘Irirajia aajanirentsi teequea iranagueriji aajanitarica.’ Yatsipetacaajiaquenaquea naatimpa, ariquea inquejetacaajiaquempiquea aviatimpajia aisa irantsipetacajaiaquempiquea. Itsipajia iquemisantajiaqueroquea notsatacajaiaquerica, ariquea inquejejiaquempi aviatimpajia aisa inquemisantajiaquempiquea pintsatacaaquerigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ariquea inquejejiaquempiquea imaica incatsimatimentajiaquempiro piquemisantajiaquenagueti, teetari intsajigueriji tigarancaquenaca. ");
INSERT INTO cotNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aatomegueti nocoraquetime nontsatacajaiaqueriquea, aatomequea icatsimatimentajitirime ocatica yantaguishejiaqueca, cotanquitsiquea imaica nocoraquetaquetari notsatacajaiavetacaritari irootaquequea aatoquea yagavejajigui incantajiaquequea: ‘Tee nontsajiguenicate, noquejetantajiacaroca imaica.’ ");
INSERT INTO cotNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Maasanotari semaneguintajiganaca naatimpa isemaneguintajiacariquea aisa Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ariquea oquempetaca aisa aatomegueti namenacajaiguirime taaca opajitapae teeca irantajigueteji aatome iquejetacaantame, cotanquitsiqueate imaica yamenajiavecarotari nantaguetaqueca cotanquitsiquea arimpaquea isemaneguintajianaquena naatimpa aisa Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Oquejetantacaca imaica cameetsaniji onetsanatanaquempaniji ocantica itioncacaantajiaquenerica Aapani Irioshi, ocanti: ‘Mana isemashijiaquena intati.’ ");
INSERT INTO cotNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ariquea noncamanqueri Aapani intigarancaquempiri irira Amitacotantatsica, irioquea Ishire tsatacaajiaquempineca iroomajatatsica. Ariquea incoraquequegueti intsavetantaquenaquea. ");
INSERT INTO cotNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ari pinquejejiaquempa aviatimpajia pintsavetantajiaquenaquea, pitsipajiaquenatari iroaqueragueti noparianacarogueti notsatacaantigueti irosati imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Imaica nocantajiaquempiquea maasano ocatica aatonijite povashiantajianajiro piquemisantajiaquenagueti. ");
INSERT INTO cotNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Incantimentajiaquempirotari poavetanaquempagueti shinagogaqui icapiocantapinijiacaca, aisa aapojaquempagueti savincaguiteri irimetojajiaquempigueti irijique iro yantajiaque ininqueca Aapani Irioshi. ");
INSERT INTO cotNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inquempejiaqueroquea imaica teenica intsajiguerinica Aapani, aisa naatimpa tee intsajiguenaji. ");
INSERT INTO cotNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Manaquea nocamantajiaquempiroquea ocatica imaica cameetsaniji aapojaquempagueti coajica pinquenquejajiajeronijite nocamantsijiaquempitari coramani. Coramaniquea tee noncamantajiguempi, choocanatari notsipajiaquempi. ");
INSERT INTO cotNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Imaicaquea imaica noanajequea ichoocaquegueti tigarancaquenaca, cotanquitsiquea aviatimpajia teequea pincoacojiguenaji queroca noanajeni. ");
INSERT INTO cotNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Manaquea intati noshimampojancacaajiaquempiquea nocamantajiaquempigueti. ");
INSERT INTO cotNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cotanquitsiquea imaica noncamantamajajiaquempi ocameetsamajataquetari noanajegueti. Aatoguetitari nogui aatoquea icoraqueti irira Amitacotantatsica oguishinejajiajempineca, cotanquitsi noanajegueti nontigarancajiapojaquempiriquea. ");
INSERT INTO cotNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Oraquea incoraquepojaquegueti inquenquetsashirentacaajiaqueriquea caquintejia quepatsiquitica iramenajiaquempa manaquea iquempevaejiaca, aisa intsatacaajiaqueriquea quero icotani comajamajatatsica, jeroquea aisa intsajiaque incatsimajiaqueriquea Aapani Irioshi coajica maasano teeca inquemisantajigueriji. ");
INSERT INTO cotNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Inquenquetsashirentacaajiaqueriquea cameetsaniji intsajiaqueniji mana iquempevaejiaca, teenicaquea inquemisantajiguenaji. ");
INSERT INTO cotNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Intsatacaajiaqueriquea quero icotani comajamajatatsica, noncantanajempatari naatimpa Aapaniqui, aviatimpajiaquea aatoquea pinejajijaana. ");
INSERT INTO cotNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Intsatacaajiaqueriquea intsatimentajiaqueniji incatsimajiaqueriquea Aapani Irioshi coajica maasano teeca inquemisantajigueriji, imataquerotari icantacotsitacari irira majirontavetanquitsica acaniqui quepatsiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Choocaquea otsipapae oshequi noncamantajiaquempimeca, cotanquitsiquea aatoquea pagavejajiguironica imaica. ");
INSERT INTO cotNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Oraquea incoraquequegueti Ishire Aapani Irioshi tsatacaajiaquempironeca iroomajaca, intsatacajaiaquempiroquea maasano. Aatoquea inchiquioji iquenquejashitaro iriatimpa, iroguentiquea incamantajiaquempi iquemaqueca. Aisa intsatacajaiaquempiroquea quero oncoguetanaquempani coajica. ");
INSERT INTO cotNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iraagarantaque nocanqueca intsatacajaiaquempiroquea, irootaquequea ironigaantantaquemparoca noganejencare. ");
INSERT INTO cotNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Maasanoquea yashincaca Aapani irooquea nashi aisa, irooquea nocantantacaca irira Ishire iraagarantaque nocanqueca intsatacajaiaquempiro. ");
INSERT INTO cotNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Irooshipojaquequea imaica aatoquea pinejajijaana, osamaniguitepojaquegueti ariquea pinejajiajena aisa, noncantanajempatari Aapaniqui.” ");
INSERT INTO cotNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ariquea iconoagaranca itsatacaanejia iquenquetsatavacaajianaca icantajiaquequea: —¿Taa opaji oca icancajica icanquegueti irooshipojaque aato anejajiri, osamaniguitepojaquegueti ariquea anejajeri, manatari iroanaje Iririqui? ");
INSERT INTO cotNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Taa opaji icanquegueti ‘irooshipojaque’? Tee antsatavaqueroji iquenquetsatacotaqueca. ");
INSERT INTO cotNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iriraquea Jesoshi itsajiavaqueriquea inintajiavecaquea incoacoquerime, irootaquequea icantantajiacarica: —¿Iroompa picoacotimentajiaquero nocanquempigueti ‘irooshipojaquequea imaica aatoquea pinejajijaana, osamaniguitepojaquegueti ariquea pinejajiajena aisa’? ");
INSERT INTO cotNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Imaica noncamantamajajiaquempiquea aviatimpajia pishimampojancajianaquempaquea pirajaianaquempa intati, irirajiaquea teeca inquemisantajiguenaji irishinevaejianaquempaquea. Cotanquitsiquea aviatimpajia pishimampojancajiavetaquempa, coajicaquea pishinejianajempaquea. ");
INSERT INTO cotNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pinquenquejeroja oratica manquigarentsi oncatsitegueti oshimampojancanaquempaquea oquemavaquerotari ocatsitanaquerogueti, cotanquitsiquea ovoacotanajigueti teequea onquenquejajeroji ocatsivecagueti manaquea oshinevaetanaca intati, voajitari irijanite. ");
INSERT INTO cotNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ariquea piquejejiaca aviatimpajia imaica pishimampojancajiavequempaquea cotanquitsiquea naatimpa nonejajiajempiquea ariquea pishinevaejianajempa, aatoquea ichoocati agavejanquitsineca irishimampojancacajaijaempi. ");
INSERT INTO cotNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Oraquea onquejetaquempagueti imaica aatoquea picoacojiajana naatimpa. Noncamantamajataquempiquea taacaquea pamanajiaquerica Aapani novajiroqui irojocajiaquempiroquea. ");
INSERT INTO cotNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cotanquitsiquea imaica tequerata pamananteji novajiroqui. Iintsija pamanajigueri, irojocajiaquempiquea cameetsaniji pishinemajajianaquempaniji. ");
INSERT INTO cotNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Oraquea notsatacajaiaquempigueti manaquea noquejetacaajiaquempiro taaca opajitapae, cotanquitsiquea coajica aato noquejetacaaguetajimpiro, manaquea nontsavetacomajataqueri Aapani noguisotoamajajiaquempiroquea pintsamajatimentajiaqueniji. ");
INSERT INTO cotNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Onquejetaquempagueti imaica ariquea pamanante novajiroqui. Teequea ari noncanteji naroguenti amanacoventajiaquempine, ");
INSERT INTO cotNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ipintsamajajiaquempitari Aapani iriatimpa, yamenajiaquempitari pipintsamajajiaquenaquea naatimpa, aisa piquemisantajiavaqueroquea nocanquegueti mana noponeaca iriatimpaqui. ");
INSERT INTO cotNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Arimajatari noponeaca Aapaniqui nocoraquequequea acaniqui quepatsiqui, cotanquitsiquea imaica ariquea noanaje noncantanajempa Aapaniqui.” ");
INSERT INTO cotNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Irirajiaquea itsatacaanejia icantajiaqueriquea: —Imaicaquea picamantamajajiaquenaquea, teequea pinquejetacaaguetajemparoquea intati. ");
INSERT INTO cotNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Imaicaquea notsajiaquequea caaviji pitsamajatiro maasano, inchiquiojitari pitsatsitacaroquea iquenquejaguetica caquinte tequeratagueti incoacojiguempiji. Notsatantajiacaca manaquea piponeaca Aapaniqui Irioshiqui. ");
INSERT INTO cotNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iriraquea Jesoshi icantajianaqueriquea: —¿Iroosacanicate pitsajiaquenampate imaica? ");
INSERT INTO cotNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aapojempa savincaguiteri, jac aapojacatari imaica, pimporocantajianaquempaca poapoaitanaque querocagueti pojocajianaquenaquea apaniro, cotanquitsiquea aatoquea apaniro nochoocati, itsipataquenatari Aapani. ");
INSERT INTO cotNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nocamantajiaquempiroquea maasano ocatica pishinemajajianajempaniji paventamajajiaquenagueti. Ocaniqui quepatsiqui irantsipetacajaiquempiquea, cotanquitsiquea pishinemajajianaquempa, nanajaiaqueritari maasano quepatsiquitica. ");
INSERT INTO cotNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ariquea iteroncanaquerogueti Jesoshi iquenquetsatacaajiaquerigueti, yamenanaquequea jenoqui inquitequi icantiquea: “Aapani, aapojaca. Ponigaantaguetajero imaica iroganejencare Piri