﻿USE sofia;
DROP TABLE IF EXISTS sofia.copshc_vpl;
CREATE TABLE copshc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES copshc_vpl WRITE;
INSERT INTO copshc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ⲠϪⲰⲰⲘⲈ ⲘⲠⲈϪⲠⲞ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲠϢⲎⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ⲀⲂⲢⲀϨⲀⲘ ⲀϤϪⲠⲞ ⲚⲒⲤⲀⲀⲔ ⲒⲤⲀⲀⲔ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲀⲔⲰⲂ ⲒⲀⲔⲰⲂ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲞⲨⲆⲀⲤ ⲘⲚ ⲚⲈϤⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ⲒⲞⲨⲆⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲘⲪⲀⲢⲈⲤ ⲘⲚ ⲌⲀⲢⲀ ⲈⲂⲞⲖ ϨⲚ ⲐⲀⲘⲀⲢ ⲪⲀⲢⲈⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲈⲤⲢⲰⲘ. ⲈⲤⲢⲰⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲢⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ⲀⲢⲀⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲘⲒⲚⲀⲆⲀⲂ. ⲀⲘⲒⲚⲀⲆⲀⲂ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲚⲀⲀⲤⲤⲰⲚ ⲚⲀⲀⲤⲤⲰⲚ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲤⲀⲖⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ⲤⲀⲖⲘⲰⲚ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲂⲞⲈⲤ ⲈⲂⲞⲖ ϨⲚ ϨⲢⲀⲬⲀⲂ. ⲂⲞⲈⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲂⲎⲆ ⲈⲂⲞⲖ ϨⲚ ϨⲢⲞⲨⲐ. ⲒⲰⲂⲎⲆ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲈⲤⲤⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ⲒⲈⲤⲤⲀⲒ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲢⲢⲞ. ⲆⲀⲨⲈⲒⲆ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲤⲞⲖⲞⲘⲰⲚ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲘⲈ ⲚⲞⲨⲢⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ⲤⲞⲖⲞⲘⲰⲚ ⲆⲈ ⲀϤϪⲠⲞ ⲚϨⲢⲞⲂⲞⲀⲘ ϨⲢⲞⲂⲞⲀⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲂⲒⲀ ⲀⲂⲒⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲤⲀⲪ. ");
INSERT INTO copshc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ⲀⲤⲀⲪ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲤⲀⲪⲀⲦ ⲒⲰⲤⲀⲪⲀⲦ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲢⲀⲘ ⲒⲰⲢⲀⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲞⲌⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ⲞⲌⲈⲒⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲀⲐⲀⲘ. ⲒⲰⲚⲀⲐⲀⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲬⲀⲌ ⲀⲬⲀⲌ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲈⲌⲈⲔⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ⲈⲌⲈⲔⲈⲒⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲘⲘⲀⲚⲀⲤⲤⲎ ⲘⲀⲚⲀⲤⲤⲎ ⲆⲈ ⲀϤϪⲠⲞ ⲚϨⲀⲘⲰⲤ. ϨⲀⲘⲰⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲤⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ⲒⲰⲤⲒⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲈⲬⲞⲚⲒⲀⲤ ⲘⲚ ⲚⲈϤⲤⲚⲎⲨ ϨⲒ ⲠⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ⲚⲦⲂⲀⲂⲨⲖⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ⲘⲚⲚⲤⲀ ⲠⲠⲰⲰⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚⲦⲂⲀⲂⲨⲖⲰⲚ ⲒⲈⲬⲞⲚⲒⲀⲤ ⲀϤϪⲠⲞ ⲚⲤⲀⲖⲀⲐⲒⲎⲖ ⲤⲀⲖⲀⲐⲒⲎⲖ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲌⲞⲢⲞⲂⲀⲂⲈⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ⲌⲞⲢⲞⲂⲀⲂⲈⲖ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲂⲒⲞⲨⲆ ⲀⲂⲒⲞⲨⲆ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲈⲖⲒⲀⲔⲒⲘ. ⲈⲖⲒⲀⲔⲒⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲌⲰⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ⲀⲌⲰⲢⲀⲤ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲤⲀⲆⲰⲔ ⲤⲀⲆⲰⲔ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲀⲬⲈⲒⲘ ⲀⲬⲈⲒⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲈⲖⲒⲞⲨⲆ. ");
INSERT INTO copshc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ⲈⲖⲒⲞⲨⲆ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲈⲖⲈⲀⲌⲀⲢ ⲈⲖⲈⲀⲌⲀⲢ ⲆⲈ ⲀϤϪⲠⲞ ⲘⲘⲀⲦⲐⲀⲘ ⲘⲀⲦⲐⲀⲘ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ⲒⲀⲔⲰⲂ ⲆⲈ ⲀϤϪⲠⲞ ⲚⲒⲰⲤⲎⲪ ⲠϨⲀⲒ ⲘⲘⲀⲢⲒⲀ. ⲦⲀⲒ ⲚⲦⲀⲨϪⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ. ⲠⲀⲒ ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ⲄⲈⲚⲈⲀ ϬⲈ ⲚⲒⲘ ϪⲒⲚ ⲀⲂⲢⲀϨⲀⲘ ϢⲀ ⲈϨⲢⲀⲒ ⲈⲆⲀⲨⲈⲒⲆ ⲘⲚ ⲦⲀϤⲦⲈ ⲚⲄⲈⲚⲈⲀ. ⲀⲨⲰ ϪⲒⲚ ⲆⲀⲨⲈⲒⲆ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ⲚⲦⲂⲀⲂⲨⲖⲰⲚ ⲘⲚ ⲦⲀϤⲦⲈ ⲚⲄⲈⲚⲈⲀ. ⲀⲨⲰ ϪⲒⲚ ⲈⲠⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ⲚⲦⲂⲀⲂⲨⲖⲰⲚ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲚ ⲦⲀϤⲦⲈ ⲚⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ⲠⲈϪⲠⲞ ⲆⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲨⲦⲈⲒϨⲈ ⲠⲈ ⲚⲦⲈⲢⲞⲨϢⲠ ⲦⲞⲞⲦⲤ ⲚⲦⲈϤⲘⲀⲀⲨ ⲘⲀⲢⲒⲀ ⲚⲒⲰⲤⲎⲪ ⲈⲘⲠⲀⲦⲞⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲚⲈⲨⲈⲢⲎⲨ ⲀⲨϨⲈ ⲈⲢⲞⲤ ⲈⲤⲈⲈⲦ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲠⲚⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ⲒⲰⲤⲎⲪ ⲆⲈ ⲠⲈⲤϨⲀⲒ ⲈⲚⲈⲨⲆⲒⲔⲀⲒⲞⲤ ⲠⲈ. ⲀⲨⲰ ⲚⲈϤⲞⲨⲰϢ ⲀⲚ ⲈϮ ⲘⲠⲈⲤⲤⲞⲈⲒⲦ ⲀϤⲞⲨⲰϢ ⲈⲚⲞϪⲤ ⲈⲂⲞⲖ ⲚϪⲒⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ⲚⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲈϤⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ ⲈⲒⲤ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲀϤⲞⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲤⲎⲪ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲘⲠⲢⲢⲞ ϨⲞⲦⲈ ⲈϪⲒ ⲘⲘⲀⲢⲒⲀ ⲦⲈⲔⲤϨⲒⲘⲈ. ⲠⲈⲦⲞⲨⲚⲀϪⲠⲞϤ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ⲤⲚⲀϪⲠⲞ ⲆⲈ ⲚⲞⲨϢⲎⲢⲈ. ⲚⲄⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ⲚⲦⲞϤ ⲄⲀⲢ ⲠⲈⲦⲚⲀⲦⲞⲨϪⲞ ⲘⲠⲈϤⲖⲀⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ⲠⲀⲒ ⲆⲈ ⲦⲎⲢϤ ⲚⲦⲀϤϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲠϪⲞⲈⲒⲤ ϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ϪⲈ ⲈⲒⲤⲦⲠⲀⲢⲐⲈⲚⲞⲤ ⲚⲀⲰ ⲚⲤϪⲠⲞ ⲚⲞⲨϢⲎⲢⲈ ⲚⲤⲈⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲈⲘⲘⲀⲚⲞⲨⲎⲖ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲚϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲈϤⲚⲔⲞⲦⲔ ⲀϤⲈⲒⲢⲈ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦϤ ⲚϬⲒ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ. ⲀϤϪⲒ ⲘⲘⲀⲢⲒⲀ ⲦⲈϤⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ⲘⲠⲈϤⲤⲞⲨⲰⲚⲤ ϢⲀⲚⲦⲈⲤϪⲠⲞ ⲘⲠⲈⲤϢⲎⲢⲈ. ⲀϤⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲞⲨϪⲠⲞϤ ϨⲢⲀⲒ ϨⲚ ⲂⲎⲐⲖⲈⲈⲘ ⲚⲦⲈ ϮⲞⲨⲆⲀⲒⲀ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚϨⲎⲢⲰⲆⲎⲤ ⲠⲢⲢⲞ. ⲈⲒⲤ ϨⲈⲚⲘⲀⲄⲞⲤ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲘⲀⲚϢⲀ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲈⲨϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ϪⲈ ⲈϤⲦⲰⲚ ⲠⲢⲢⲞ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲚⲦⲀⲨϪⲠⲞϤ. ⲀⲚⲚⲀⲨ ⲄⲀⲢ ⲈⲠⲈϤⲤⲒⲞⲨ ϨⲚ ⲚⲈⲘⲀⲚϢⲀ ⲀⲚⲈⲒ ⲈⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲠⲢⲢⲞ. ⲀϤϢⲦⲞⲢⲦⲢ ⲈⲘⲀⲦⲈ ⲘⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲎⲢⲤ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ⲀϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲠⲖⲀⲞⲤ. ⲀϤϢⲒⲚⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ϪⲈ ⲈⲨⲚⲀϪⲠⲞ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲂⲎⲐⲖⲈⲈⲘ ⲚⲦⲈϮⲞⲨⲆⲀⲒⲀ. ⲈϤⲤⲎϨ ⲄⲀⲢ ⲚⲦⲈⲒϨⲈ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ϪⲈ ⲚⲦⲞ ϨⲰⲰⲦⲈ ⲂⲎⲐⲖⲈⲈⲘ ⲠⲔⲀϨ ⲚⲒⲞⲨⲆⲀ ⲚⲦⲈϪⲞⲖϨ ⲀⲚ ϨⲚ ⲚϨⲎⲄⲈⲘⲰⲚ ⲚⲒⲞⲨⲆⲀ. ϤⲚⲎⲨ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚϨⲎⲦⲈ ⲚϬⲒ ⲞⲨϨⲎⲄⲞⲨⲘⲈⲚⲞⲤ. ⲠⲀⲒ ⲈⲦⲚⲀⲘⲞⲞⲚⲈ ⲘⲠⲀⲖⲀⲞⲤ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ⲦⲞⲦⲈ ϨⲎⲢⲰⲆⲎⲤ ⲀϤⲘⲞⲨⲦⲈ ⲈⲘⲘⲀⲄⲞⲤ ⲚϪⲒⲞⲨⲈ ⲀϤϢⲒⲚⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲤⲀⲠⲈⲨⲞⲈⲒϢ ⲘⲠⲤⲒⲞⲨ ⲚⲦⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ⲀϤϪⲞⲞⲤⲈ ⲈϨⲢⲀⲒ ⲈⲂⲎⲐⲖⲈⲈⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲰⲔ ⲚⲦⲈⲦⲚ ϢⲒⲚⲈ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲦⲂⲈ ⲠϢⲎⲢⲈ ϢⲎⲘ. ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲦⲈⲦⲚϢⲀⲚϨⲈ ⲈⲢⲞϤ ⲘⲀⲦⲀⲘⲘⲞⲒ ϨⲰ ϪⲈⲔⲀⲀⲤ ⲈⲒⲈⲈⲒ ⲚⲦⲀⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲢⲞ ⲀⲨⲂⲰⲔ ⲀⲨⲰ ⲈⲒⲤⲠⲤⲒⲞⲨ ⲚⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ϨⲚ ⲚⲈⲘⲀⲚϢⲀ ⲀϤⲘⲞⲞϢⲈ ϨⲎⲦⲞⲨ ϢⲀⲚⲦⲈϤⲈⲒ ⲚϤⲀϨⲈⲢⲀⲦϤ ⲈϪⲘ ⲠⲘⲀ ⲈⲚⲈⲢⲈⲠϢⲎⲢⲈ ϢⲎⲘ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲤⲒⲞⲨ ⲀⲨⲢⲀϢⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲢⲀϢⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ⲀⲨⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ϢⲎⲘ ⲘⲚ ⲘⲀⲢⲒⲀ ⲦⲈϤⲘⲀⲀⲨ ⲀⲨⲠⲀϨⲦⲞⲨ ⲀⲨⲞⲨⲰϢⲦ ⲚⲀϤ ⲀⲨⲞⲨⲰⲚ ⲚⲚⲈⲨⲀϨⲰⲰⲢ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚϨⲈⲚⲆⲰⲢⲞⲚ ⲞⲨⲚⲞⲨⲂ ⲘⲚ ⲞⲨⲖⲒⲂⲀⲚⲞⲤ ⲘⲚ ⲞⲨϢⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ⲀⲨⲦⲞⲨⲚⲈⲒⲀⲦⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲈⲦⲘⲔⲞⲦⲞⲨ ϢⲀϨⲎⲢⲰⲆⲎⲤ. ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲔⲈϨⲒⲎ ⲀⲨⲀⲚⲀⲬⲰⲢⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈⲨⲬⲞⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲆⲈ ⲈⲒⲤⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲈⲒⲰⲤⲎⲪ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄϪⲒ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲚⲄⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲔⲎⲘⲈ ⲚⲄϢⲰⲠⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϢⲀⲚϮϪⲞⲞⲤ ⲚⲀⲔ. ϨⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲚⲀϢⲒⲚⲈ ⲚⲤⲀⲠϢⲎⲢⲈ ϢⲎⲘ ⲈⲦⲀⲔⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤϪⲒ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲚⲦⲈⲨϢⲎ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ⲚⲈϤϢⲞⲞⲠ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϢⲀⲚⲦⲈϨⲎⲢⲰⲆⲎⲤ ⲘⲞⲨ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲠϪⲞⲈⲒⲤ ϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲘⲞⲨⲦⲈ ⲈⲠⲀϢⲎⲢⲈ ⲈⲂⲞⲖ ϨⲚ ⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ⲦⲞⲦⲈ ϨⲎⲢⲰⲆⲎⲤ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ϪⲈ ⲀⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲘⲘⲀⲄⲞⲤ ⲀϤϬⲰⲚⲦ ⲈⲘⲀⲦⲈ ⲀϤϪⲞⲞⲨ ⲀϤⲘⲞⲨⲞⲨⲦ ⲚϢⲎⲢⲈ ϢⲎⲘ ⲚⲒⲘ ⲈⲦϨⲚ ⲂⲎⲐⲖⲈⲈⲘ ⲘⲚ ⲚⲈⲦϢⲞⲞⲠ ϨⲚ ⲚⲈⲤⲦⲞϢ ⲦⲎⲢⲞⲨ ϪⲒⲚⲢⲘⲠⲈ ⲤⲚⲦⲈ ⲈⲠⲈⲤⲎⲦ. ⲔⲀⲦⲀⲠⲈⲨⲞⲈⲒϢ ⲚⲦⲀⲨϨⲈⲦϨⲰⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲘⲘⲀⲄⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ⲦⲞⲦⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲒⲈⲢⲎⲘⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ϪⲈ ⲞⲨⲤⲘⲎ ⲀⲨⲤⲰⲦⲘ ⲈⲢⲞⲤ ϨⲚ ϨⲢⲀⲘⲘⲀ. ⲞⲨⲢⲒⲘⲈ ⲘⲚⲞⲨⲦⲞⲈⲒⲦ ⲈⲚⲀϢⲰϤ. ϨⲢⲀⲬⲎⲖ ⲈⲤⲢⲒⲘⲈ ⲈⲚⲈⲤϢⲎⲢⲈ ⲀⲨⲰ ⲘⲠⲈⲤⲞⲨⲰϢ ⲈⲤⲖⲤⲰⲖⲤ ϪⲈ ⲚⲚⲞⲨⲤ ⲀⲚ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ⲚⲦⲈⲢⲈϤⲘⲞⲨ ⲆⲈ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ. ⲈⲒⲤⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲈⲒⲰⲤⲎⲪ ϨⲚ ⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄϪⲒ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲚⲄⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲔⲀϨ ⲘⲠⲒⲤⲢⲀⲎⲖ. ⲀⲨⲘⲞⲨ ⲄⲀⲢ ⲚϬⲒ ⲚⲈⲦϢⲒⲚⲈ ⲚⲤⲀⲦⲈⲮⲨⲬⲎ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤϪⲒ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲔⲀϨ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ⲀϤⲤⲰⲦⲘ ⲆⲈ ϪⲈ ⲀⲢⲬⲎⲖⲀⲞⲤ ⲠⲈⲦⲞ ⲚⲢⲢⲞ ⲈϪⲚ ϮⲞⲨⲆⲀⲒⲀ ⲈⲠⲘⲀ ⲚϨⲎⲢⲰⲆⲎⲤ ⲠⲈϤⲈⲒⲰⲦ ⲀϤⲢϨⲞⲦⲈ ⲈⲂⲰⲔ ⲈⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲦⲞⲨⲚⲈⲒⲀⲦϤ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲈϨⲢⲀⲒ ⲈⲘⲘⲞⲞϢⲦⲈ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ⲀϤⲈⲒ ⲀϤⲞⲨⲰϨ ϨⲚ ⲞⲨⲠⲞⲖⲒⲤ ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲚⲀⲌⲀⲢⲈⲐ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ϨⲢⲀⲒ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ϨⲢⲀⲒ ϨⲘ ⲠϪⲀⲒⲈ ⲚϮⲞⲨⲆⲀⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲈⲦⲀⲚⲞⲒ. ⲀⲤϨⲰⲚ ⲄⲀⲢ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ⲠⲀⲒ ⲄⲀⲢ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲤⲘⲎ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϪⲀⲒⲈ ϪⲈ ⲤⲂⲦⲈⲦⲈϨⲒⲎ ⲘⲠϪⲞⲈⲒⲤ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲦⲚ ⲚⲚⲈϤⲘⲀ ⲚⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ⲚⲦⲞϤ ⲆⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲈⲢⲈⲦⲈϤϨⲂⲤⲰ ϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲚ ϨⲈⲚⲂⲰ ⲚϬⲀⲘⲞⲨⲖ. ⲈⲢⲈⲞⲨⲘⲞϪϨ ⲚϢⲀⲀⲢ ϬⲞⲞⲖⲈ ⲈⲦⲈϤϮⲠⲈ. ⲦⲈϤϨⲢⲈ ⲆⲈ ⲚⲈϨⲈⲚϢϪⲈ ⲚⲈ ⲘⲚⲞⲨⲈⲂⲒⲈ ϨⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ⲦⲞⲦⲈ ⲚⲈⲤⲚⲎⲨ ⲈⲂⲞⲖ ⲈⲢⲀⲦϤ ⲚϬⲒ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲎⲢⲤ. ⲘⲚ ϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲘⲠⲈⲒⲞⲢⲆⲀⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ⲈⲨϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ϨⲘ ⲠⲈⲒⲞⲢⲆⲀⲚⲎⲤ ⲠⲈⲒⲈⲢⲞ ⲈⲨⲈⲜⲞⲘⲞⲖⲞⲄⲈⲒ ⲚⲚⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈϨⲀϨ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲈⲨⲚⲎⲨ ⲈϪⲘ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲚⲈϪⲠⲞ ⲚⲚⲈϨⲂⲞⲨⲒ. ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲦⲤⲀⲂⲈ ⲦⲎⲨⲦⲚ ⲈⲠⲰⲦ ⲈⲂⲞⲖ ϨⲎⲦⲤ ⲚⲦⲞⲢⲄⲎ ⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ⲀⲢⲒⲢⲈ ϬⲈ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ ⲈϤⲘⲠϢⲀ ⲚⲦⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ⲚⲦⲈⲦⲚ ⲦⲘⲘⲈⲈⲨⲈ ⲈϪⲞⲞⲤ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ϪⲈ ⲞⲨⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲘⲠⲈⲚⲈⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ. ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϬⲞⲘ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲨⲚⲈⲤ ϨⲈⲚϢⲎⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲒⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ϪⲒⲚⲦⲈⲚⲞⲨ ⲆⲈ ⲠⲔⲈⲖⲈⲂⲒⲚ ⲔⲎ ϨⲀ ⲦⲚⲞⲨⲚⲈ ⲚⲚϢⲎⲚ. ϢⲎⲚ ϬⲈ ⲚⲒⲘ ⲈⲦⲈⲚϤⲚⲀⲈⲒⲢⲈ ⲀⲚ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ ⲈⲚⲀⲚⲞⲨϤ ⲤⲈⲚⲀⲔⲞⲞⲢⲈϤ ⲚⲤⲈⲚⲞϪϤ ⲈⲦⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ⲀⲚⲞⲔ ⲘⲈⲚ ⲈⲒⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲘⲞⲞⲨ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ⲠⲈⲦⲚⲎⲨ ⲆⲈ ϤϪⲞⲞⲢ ⲈⲢⲞⲒ ⲠⲀⲒ ⲚϮⲘⲠϢⲀ ⲀⲚ ⲚϤⲒ ϨⲀ ⲠⲈϤⲦⲞⲞⲨⲈ. ⲚⲦⲞϤ ⲠⲈⲦⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲠⲚⲀ ⲈϤⲞⲨⲀⲀⲂ ⲘⲚⲞⲨⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲈϤϨⲀ ϨⲚ ⲦⲈϤϬⲒϪ ⲈϤⲚⲀⲦⲂⲂⲞ ⲘⲠⲈϤϪⲚⲞⲞⲨ. ⲚϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲈϤⲤⲞⲨⲞ ⲈⲦⲀⲠⲞⲐⲎⲔⲎ. ⲠⲦⲰϨ ⲆⲈ ⲚϤⲢⲞⲔϨϤ ϨⲚ ⲞⲨⲤⲀⲦⲈ ⲈⲘⲈⲤⲰϢⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ⲦⲞⲦⲈ ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲒⲞⲢⲆⲀⲚⲎⲤ ϢⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲈⲦⲢⲈϤⲂⲀⲠⲦⲒⲌⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲔⲰⲖⲨ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲈⲦⲢⲬⲢⲒⲀ ⲚⲂⲀⲠⲦⲒⲌⲈ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲔ ⲀⲨⲰ ⲚⲦⲞⲔ ⲈⲦⲚⲎⲨ ϢⲀⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϬⲰ ⲦⲈⲚⲞⲨ ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲈⲦⲈϢϢⲈ ⲈⲢⲞⲚ ⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲒⲘ ⲦⲞⲦⲈ ⲀϤⲔⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ⲚⲦⲈⲢⲈϤⲂⲀⲠⲦⲒⲌⲈ ϬⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ϨⲘ ⲠⲘⲞⲞⲨ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨⲞⲨⲰⲚ ⲚϬⲒ ⲘⲠⲎⲨⲈ. ⲀϤⲚⲀⲨ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲈϤⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲚⲐⲈ ⲚⲞⲨϬⲢⲞⲞⲘⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲤⲘⲎ ⲈⲂⲞⲖ ϨⲚ ⲘⲠⲎⲨⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲘⲈⲢⲒⲦ ⲠⲈⲚⲦⲀⲠⲀⲞⲨⲰϢ ϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ⲦⲞⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲨϪⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲈⲢⲎⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲢⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ⲀϤⲚⲎⲤⲦⲈⲨⲈ ⲆⲈ ⲚϨⲘⲈ ⲚϨⲞⲞⲨ ⲘⲚ ϨⲘⲈ ⲚⲞⲨϢⲎ ⲘⲚⲚⲤⲰⲤ ⲀϤϨⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲈⲦⲠⲈⲒⲢⲀⲌⲈ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀϪⲒⲤ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲚⲈⲒⲰⲚⲈ ⲢⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲤⲎϨ ϪⲈ ⲚⲈⲢⲈⲠⲢⲰⲘⲈ ⲚⲀⲰⲚϨ ⲀⲚ ⲈⲞⲈⲒⲔ ⲘⲀⲨⲀⲀϤ ⲀⲖⲖⲀ ⲈϢⲀϪⲈ ⲚⲒⲘ ⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲦⲀⲠⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ⲦⲞⲦⲈ ⲀϤϪⲒ ⲘⲘⲞϤ ⲚϬⲒ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ ⲈⲦⲞⲨⲀⲀⲂ. ⲀϤⲦⲀϨⲞ ⲘⲘⲞϤ ⲈⲢⲀⲦϤ ⲈϪⲘ ⲠⲦⲎⲚϨ ⲘⲠⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲞϪⲔ ⲈⲠⲈⲤⲎⲦ ⲈϪⲘ ⲠⲈⲒⲘⲀ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ϤⲚⲀϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲂⲎⲎⲦⲔ. ⲚⲤⲈϤⲒ ⲘⲘⲞⲔ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈⲨϬⲒϪ ⲘⲎⲠⲞⲦⲈ ⲚⲄϪⲰⲢⲠ ⲈⲨⲰⲚⲈ ⲚⲦⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ⲠⲈϪⲀϤ ⲞⲚ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϤⲤⲎϨ ⲞⲚ ϪⲈ ⲚⲚⲈⲔⲠⲈⲒⲢⲀⲌⲈ ⲘⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲒⲦϤ ⲚϬⲒ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲦⲞⲞⲨ ⲈϤϪⲞⲤⲈ ⲈⲘⲀⲦⲈ. ⲀϤⲦⲞⲨⲞϤ ⲈⲘⲘⲚⲦⲢⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲘⲚ ⲠⲈⲨⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϮⲚⲀⲦⲀⲀⲨ ⲚⲀⲔ ⲈⲔϢⲀⲚⲠⲀϨⲦⲔ ⲚⲄⲞⲨⲰϢⲦ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲂⲰⲔ ⲠⲤⲀⲦⲀⲚⲀⲤ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ ⲠⲈⲦⲔⲈⲞⲨⲰϢⲦ ⲚⲀϤ. ⲀⲨⲰ ⲚⲦⲞϤ ⲘⲀⲨⲀⲀϤ ⲠⲈⲦⲔⲈϢⲘϢⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ⲦⲞⲦⲈ ⲀϤⲔⲀⲀϤ ⲚϬⲒ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲚⲀⲄⲄⲈⲖⲞⲤ ⲀⲨⲈⲒ ⲀⲨⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ⲀϤⲤⲰⲦⲘ ⲆⲈ ϪⲈ ⲀⲨⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ⲀϤⲔⲰ ⲚⲤⲰϤ ⲚⲚⲀⲌⲀⲢⲈⲐ. ⲀϤⲈⲒ ⲀϤⲞⲨⲰϨ ϨⲚ ⲔⲀⲠⲀⲢⲚⲀⲞⲨⲘ. ⲦⲀⲒ ⲈⲦϨⲀⲦⲚ ⲐⲀⲖⲀⲤⲤⲀ ϨⲚ ⲚⲦⲞϢ ⲚⲌⲀⲂⲞⲨⲖⲰⲚ ⲘⲚ ⲚⲈⲪⲐⲀⲖⲈⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ϪⲈ ⲠⲔⲀϨ ⲚⲌⲀⲂⲞⲨⲖⲰⲚ ⲠⲔⲀϨ ⲚⲈⲪⲐⲀⲖⲈⲒⲘ. ⲦⲈϨⲒⲎ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲠⲈⲔⲢⲞ ⲘⲠⲈⲒⲞⲢⲆⲀⲚⲎⲤ. ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲚⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ⲠⲖⲀⲞⲤ ⲈⲦϨⲘⲞⲞⲤ ϨⲘ ⲠⲔⲀⲔⲈ ⲀϤⲚⲀⲨ ⲈⲨⲚⲞϬ ⲚⲞⲨⲞⲈⲒⲚ. ⲚⲈⲦⲞⲨⲎϨ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲘⲚ ⲐⲀⲒⲂⲈⲤ ⲘⲠⲘⲞⲨ ⲠⲞⲨⲞⲈⲒⲚ ⲀϤϢⲀ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ϪⲒⲚⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲀⲢⲬⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲀϤⲰ ⲈϪⲞⲞⲤ. ϪⲈ ⲘⲈⲦⲀⲚⲞⲈⲒ ⲀⲤϨⲰⲚ ⲄⲀⲢ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ⲈϤⲘⲞⲞϢⲈ ⲆⲈ ϨⲀⲦⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀϤⲚⲀⲨ ⲈⲤⲞⲚ ⲤⲚⲀⲨ. ⲤⲒⲘⲰⲚ ⲠⲈⲦⲈ ϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲀⲚⲆⲢⲈⲀⲤ ⲠⲈϤⲤⲞⲚ ⲈⲨϨⲒϢⲚⲈ ⲈϨⲢⲀⲒ ⲈⲐⲀⲖⲀⲤⲤⲀ ϪⲈ ⲚⲈϨⲈⲚⲞⲨⲰϨⲈ ⲄⲀⲢ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲘⲎⲒⲦⲚ ⲞⲨⲈϨⲦⲎⲨⲦⲚ ⲚⲤⲰⲒ. ⲦⲀⲢⲦⲎⲨⲦⲚ ⲚⲞⲨⲰϨⲈ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲔⲰ ⲚⲚⲈⲨϢⲚⲎⲨ. ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ⲀϤⲘⲞⲞϢⲈ ⲆⲈ ⲞⲚ ⲈⲐⲎ ⲚⲔⲈⲔⲞⲨⲒ. ⲀϤⲚⲀⲨ ⲈⲔⲈⲤⲞⲚ ⲤⲚⲀⲨ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ϨⲢⲀⲒ ϨⲘ ⲠϪⲞⲒ ⲘⲚ ⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲠⲈⲨⲈⲒⲰⲦ ⲈⲨⲤⲞϤⲦⲈ ⲚⲚⲈⲨϢⲚⲎⲨ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲔⲰ ⲚⲚⲈⲨϢⲚⲎⲨ ⲘⲚ ⲠⲈⲨⲈⲒⲰⲦ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲦⲎⲢⲤ ⲈϤϮⲤⲂⲰ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲰ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲈϤⲢⲠⲀϨⲢⲈ ⲈϢⲰⲚⲈ ⲚⲒⲘ ϨⲒⲖⲞϪⲖϪ ⲚⲒⲘ ⲈⲦϨⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ⲠⲈϤⲤⲞⲈⲒⲦ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲨⲢⲒⲀ ⲦⲎⲢⲤ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲘⲞⲔϨ ϨⲚ ϨⲈⲚϢⲰⲚⲈ ⲈⲨϢⲞⲂⲈ ⲀⲨⲰ ⲈⲨϢⲞⲞⲠ ϨⲚ ϨⲈⲚⲦⲔⲀⲤ ⲘⲚ ⲚⲈⲦⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲘⲚ ⲚⲈⲦϨⲒⲦⲈ ⲘⲚ ⲚⲈⲦⲤⲎϬ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ⲀⲨⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲘⲚ ⲦⲆⲈⲔⲀⲠⲞⲖⲒⲤ ⲘⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲚ ϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲠⲈⲔⲢⲞ ⲘⲠⲈⲒⲞⲢⲆⲀⲚⲎⲤ . ");
INSERT INTO copshc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲘⲘⲎⲎϢⲈ ⲀϤⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲦⲞⲞⲨ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲘⲞⲞⲤ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ⲀϤⲞⲨⲰⲚ ⲈⲢⲰϤ ⲀϤϮⲤⲂⲰ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ϪⲈ ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚϨⲎⲔⲈ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϪⲈ ⲦⲰⲞⲨ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲢϨⲂⲂⲈ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲞⲨⲚⲀⲤⲠⲤⲰⲠⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲢⲘⲢⲀϢ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲚⲀⲔⲖⲎⲢⲞⲚⲞⲘⲈⲒ ⲘⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦϨⲔⲀⲈⲒⲦ ⲈⲦⲞⲂⲈ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲚⲀⲤⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲚⲀⲎⲦ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲞⲨⲚⲀⲚⲀ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ ϨⲘ ⲠⲈⲨϨⲎⲦ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲚⲀⲚⲀⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲢⲈϤⲢⲈⲒⲢⲎⲚⲎ ϪⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲞⲨⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ϪⲈ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲦⲀⲨⲠⲰⲦ ⲚⲤⲰⲞⲨ ⲈⲦⲂⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϪⲈ ⲦⲰⲞⲨ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ⲚⲀⲒⲀⲦⲦⲎⲨⲦⲚ ⲈⲨϢⲀⲚⲚⲈϬⲚⲈϬⲦⲎⲨⲦⲚ. ⲚⲤⲈⲠⲰⲦ ⲚⲤⲰⲦⲚ. ⲚⲤⲈϪⲈϨⲰⲂ ⲚⲒⲘ ⲈⲐⲞⲞⲨ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ⲈⲨϪⲒϬⲞⲖ ⲈⲢⲰⲦⲚ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ⲢⲀϢⲈ ⲚⲦⲈⲦⲚ ⲦⲈⲖⲎⲖ ϪⲈ ⲠⲈⲦⲚⲂⲈⲔⲈ ⲚⲀϢⲰϤ ϨⲢⲀⲒ ϨⲚ ⲘⲠⲎⲨⲈ. ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲚⲦⲀⲨⲠⲰⲦ ⲚⲤⲀⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦϨⲀⲦⲈⲦⲚϨⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ⲚⲦⲰⲦⲚ ⲠⲈ ⲠⲈϨⲘⲞⲨ ⲘⲠⲔⲀϨ ⲈⲢϢⲀⲚⲠⲈϨⲘⲞⲨ ⲆⲈ ⲂⲀⲀⲂⲈ ⲈⲨⲚⲀⲘⲞⲖϨϤ ⲚⲞⲨ. ⲘⲈϤⲢϢⲀⲨ ⲚⲖⲀⲀⲨ ⲚⲤⲀⲚⲞϪϤ ⲈⲂⲞⲖ ⲚⲤⲈϨⲞⲘϤ ϨⲒⲦⲚ ⲚⲈⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ⲚⲦⲰⲦⲚ ⲠⲈ ⲠⲞⲨⲞⲈⲒⲚ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲘⲚ ϢϬⲞⲘ ⲚⲞⲨⲠⲞⲖⲒⲤ ⲈϨⲰⲠ ⲈⲤⲔⲎ ⲈϨⲢⲀⲒ ϨⲒϪⲚ ⲞⲨⲦⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ⲞⲨⲆⲈ ⲘⲈⲨϪⲈⲢⲈⲞⲨϨⲎⲂⲤ ⲚⲤⲈⲔⲀⲀϤ ϨⲀⲞⲨϢⲒ. ⲀⲖⲖⲀ ⲚϢⲀⲨⲔⲀⲀϤ ϨⲒϪⲚ ⲦⲖⲨⲬⲚⲒⲀ ⲚϤⲢⲞⲨⲞⲈⲒⲚ ⲈⲚⲈⲦϢⲞⲞⲠ ⲦⲎⲢⲞⲨ ϨⲘ ⲠⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲀⲢⲈϤⲢⲞⲨⲞⲈⲒⲚ ⲚϬⲒ ⲠⲈⲦⲚⲞⲨⲞⲈⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲢⲰⲘⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲀⲨ ⲈⲚⲈⲦⲚϨⲂⲎⲨⲈ ⲈⲦⲚⲀⲚⲞⲨⲞⲨ ⲚⲤⲈϮⲈⲞⲞⲨ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ⲘⲠⲢⲰϢ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲈⲔⲀⲦⲀⲖⲨ ⲘⲠⲚⲞⲘⲞⲤ ⲎⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲚⲦⲀⲒⲈⲒ ⲀⲚ ⲈⲔⲀⲦⲀⲖⲨ ⲘⲘⲞⲞⲨ ⲀⲖⲖⲀ ⲈϪⲞⲔⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ϨⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ϢⲀⲚⲦⲈⲦⲠⲈ ⲠⲀⲢⲀⲄⲈ ⲘⲚ ⲠⲔⲀϨ ⲞⲨⲒⲰⲦⲀ ⲚⲞⲨⲰⲦ. ⲎⲞⲨϢⲰⲖϨ ⲚⲞⲨⲰⲦ ⲚⲚⲈⲨⲤⲈⲒⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ϢⲀⲚⲦⲞⲨϢⲰⲠⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ⲠⲈⲦⲚⲀⲂⲰⲖ ϬⲈ ⲈⲂⲞⲖ ⲚⲞⲨⲈⲒ ⲚⲚⲈⲒⲈⲚⲦⲞⲖⲎ ⲈⲦⲤⲞⲂⲔ ⲚϤϮⲤⲂⲰ ⲚⲚⲢⲰⲘⲈ ⲚⲦⲈⲒϨⲈ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲖⲀⲬⲒⲤⲦⲞⲤ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲠⲈⲦⲚⲀⲀⲀⲨ ⲆⲈ ⲀⲨⲰ ⲚϤϮⲤⲂⲰ ⲚϨⲎⲦⲞⲨ ⲠⲀⲒ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲚⲞϬ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲈⲤϢⲀⲚⲦⲘⲢϨⲞⲨⲞ ⲚϬⲒ ⲦⲈⲦⲚⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚϨⲞⲨⲞ ⲈⲦⲀ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲚⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲀⲨϪⲞⲞⲤ ⲚⲚⲀⲢⲬⲀⲒⲞⲤ ϪⲈ ⲚⲚⲈⲔϨⲰⲦⲂ. ⲠⲈⲦⲚⲀϨⲰⲦⲂ ⲆⲈ ϤⲞ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲦⲈⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲚⲞⲨϬⲤ ⲈⲠⲈϤⲤⲞⲚ ⲈⲒⲔⲎ ϤⲞ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲦⲈⲔⲢⲒⲤⲒⲤ. ⲠⲈⲦⲚⲀϪⲞⲞⲤ ⲘⲠⲈϤⲤⲞⲚ ϪⲈ ⲔϢⲞⲨⲈⲒⲦ ϤⲞ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ⲠⲈⲦⲚⲀϪⲞⲞⲤ ϪⲈ ⲠⲤⲞϬ ϤⲞ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ⲚⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲔϢⲀⲚⲈⲒ ⲈⲔⲚⲀⲦⲀⲖⲞ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ. ⲚⲄⲢⲠⲘⲈⲈⲨⲈ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲞⲨⲚⲦⲈⲠⲈⲔⲤⲞⲚ ⲞⲨϨⲰⲂ ⲈϨⲞⲨⲚ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ⲔⲰ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ϨⲒⲐⲎ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲚⲄⲂⲰⲔ ⲚϢⲞⲢⲠ ⲚⲄϨⲰⲦⲠ ⲘⲚ ⲠⲈⲔⲤⲞⲚ. ⲦⲞⲦⲈ ⲚⲄⲈⲒ ⲚⲄⲦⲀⲖⲞ ⲈϨⲢⲀⲒ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ϢⲰⲠⲈ ⲈⲔⲞⲨⲰⲰⲘⲈ ⲘⲘⲞⲔ ⲘⲚ ⲠⲈⲦϪⲒϨⲀⲠ ⲚⲘⲘⲀⲔ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲈⲚϨⲞⲤⲞⲚ ⲔϢⲞⲞⲠ ⲚⲘⲘⲀϤ ϨⲒⲦⲈϨⲒⲎ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲠⲈⲦϪⲒϨⲀⲠ ⲚⲘⲘⲀⲔ ⲦⲀⲀⲔ ⲈⲦⲞⲞⲦϤ ⲘⲠⲢⲈϤϮϨⲀⲠ ⲚⲦⲈⲠⲢⲈϤϮϨⲀⲠ ⲦⲀⲀⲔ ⲈⲦⲞⲞⲦϤ ⲘⲠϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲚⲤⲈⲚⲞϪⲔ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈⲔⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϢⲀⲚⲦⲈⲔϮ ⲘⲠϨⲀⲈ ⲚⲔⲞⲚⲆⲢⲀⲚⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲀⲨϪⲞⲞⲤ ϪⲈ ⲚⲚⲈⲔⲢⲚⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀϬⲰϢⲦ ⲚⲤⲀⲞⲨⲤϨⲒⲘⲈ ⲈⲈⲠⲈⲒⲐⲨⲘⲈⲒ ⲈⲢⲞⲤ. ⲀϤⲞⲨⲰ ⲈϤⲢⲚⲞⲈⲒⲔ ⲈⲢⲞⲤ ϨⲘ ⲠⲈϤϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ⲈϢϪⲈ ⲠⲈⲔⲂⲀⲖ ⲆⲈ ⲚⲞⲨⲚⲀⲘ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ⲠⲞⲢⲔϤ ⲚⲄⲚⲞϪϤ ⲚⲤⲀⲂⲞⲖ ⲘⲘⲞⲔ ⲤⲈⲢⲚⲞϤⲢⲈ ⲄⲀⲢ ⲚⲀⲔ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϨⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲞⲨⲀ ⲚⲚⲈⲔⲘⲈⲖⲞⲤ ⲚⲤⲈⲦⲘⲚⲞⲨϪⲈ ⲘⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ⲚⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ⲀⲨⲰ ⲈϢϪⲈ ⲦⲈⲔϬⲒϪ ⲚⲞⲨⲚⲀⲘ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ⲤⲞⲖⲠⲤ ⲚⲄⲚⲞϪⲤ ⲤⲀⲂⲞⲖ ⲘⲘⲞⲔ. ⲤⲈⲢⲚⲞϤⲢⲈ ⲄⲀⲢ ⲚⲀⲔ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϨⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲞⲨⲀ ⲚⲚⲈⲔⲘⲈⲖⲞⲤ. ⲚⲤⲈⲦⲘⲚⲞⲨϪⲈ ⲘⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈⲦⲄⲈϨⲈⲚⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ⲀⲨϪⲞⲞⲤ ⲆⲈ ϪⲈ ⲠⲈⲦⲚⲀⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲘⲀⲢⲈϤϮ ⲚⲀⲤ ⲚⲞⲨϪⲰⲰⲘⲈ ⲚⲦⲞⲨⲈⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲚⲀⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲀϪⲚϢⲀϪⲈ ⲘⲠⲞⲢⲚⲈⲒⲀ. ϤⲚⲀⲦⲢⲈⲨⲢⲚⲞⲈⲒⲔ ⲈⲢⲞⲤ. ⲀⲨⲰ ⲠⲈⲦⲚⲀϨⲘⲞⲞⲤ ⲘⲚⲞⲨⲈⲒ ⲈⲀⲠⲈⲤϨⲀⲒ ⲚⲞϪⲤ ⲈⲂⲞⲖ ϤⲞ ⲚⲚⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ⲞⲚ ϪⲈ ⲀⲨϪⲞⲞⲤ ϨⲚ ⲚⲀⲢⲬⲀⲒⲞⲤ ϪⲈ ⲚⲚⲈⲔⲰⲢⲔ ⲚⲚⲞⲨϪ ⲈⲔⲈϮ ⲆⲈ ⲚⲚⲈⲔⲀⲚⲀⲨϢ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲢⲰⲢⲔ ⲚⲖⲀⲀⲨ ⲘⲠⲢⲰⲢⲔ ⲚⲦⲠⲈ ϪⲈ ⲠⲈⲐⲢⲞⲚⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ⲞⲨⲆⲈ ⲘⲠⲢⲰⲢⲔ ⲘⲠⲔⲀϨ ϪⲈ ⲠϨⲨⲠⲞⲠⲞⲆⲒⲞⲚ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲠⲈ ⲞⲨⲆⲈ ⲘⲠⲢⲰⲢⲔ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϪⲈ ⲦⲠⲞⲖⲒⲤ ⲘⲠⲚⲞϬ ⲚⲢⲢⲞ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ⲞⲨⲆⲈ ⲘⲠⲢⲰⲢⲔ ⲚⲦⲈⲔⲀⲠⲈ ϪⲈ ⲘⲚ ϢϬⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲢⲈⲞⲨⲂⲰ ⲚⲞⲨⲰⲦ ⲞⲨⲂⲀϢ ⲎⲚϤⲔⲘⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ⲘⲀⲢⲈⲠⲈⲦⲚϢⲀϪⲈ ⲆⲈ ϢⲰⲠⲈ ⲚⲤⲈ ⲚⲤⲈ. ⲀⲨⲰ ⲘⲘⲞⲚⲚⲘⲘⲞⲚ. ⲠⲈϨⲞⲨⲞ ⲆⲈ ⲚⲚⲀⲒ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲠⲞⲚⲎⲢⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲀⲨϪⲞⲞⲤ ϪⲈ ⲞⲨⲂⲀⲖ ⲈⲠⲘⲀ ⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨⲂⲈ ⲈⲠⲘⲀ ⲚⲞⲨⲞϨⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲢⲀϨⲈⲢⲀⲦⲦⲎⲨⲦⲚ ⲞⲨⲂⲈ ⲠⲠⲈⲐⲞⲞⲨ ⲀⲖⲖⲀ ⲠⲈⲦⲚⲀⲢⲀϨⲦⲔ ⲈⲦⲈⲔⲞⲨⲞϬⲈ ⲚⲞⲨⲚⲀⲘ ⲔⲦⲞ ⲈⲢⲞϤ ⲚⲦⲔⲈⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ⲀⲨⲰ ⲠⲈⲦⲞⲨⲰϢ ⲈϪⲒϨⲀⲠ ⲚⲘⲘⲀⲔ ⲈϤⲒ ⲚⲦⲈⲔϢⲦⲎⲚ ⲔⲰ ⲈⲂⲞⲖ ⲚⲤⲰϤ ⲘⲠⲈⲔⲔⲈϨⲞⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ⲠⲈⲦⲚⲀⲔⲞⲞⲂⲈⲔ ⲚⲞⲨⲔⲞⲦ ⲂⲰⲔ ⲚⲘⲘⲀϤ ⲚⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ⲠⲈⲦⲀⲒⲦⲈⲒ ⲘⲘⲞⲔ ϮⲚⲀϤ. ⲀⲨⲰ ⲠⲈⲦⲞⲨⲰϢ ⲈϪⲒ ⲚⲦⲞⲞⲦⲔ ⲘⲠⲢⲔⲦⲞϤ ⲚⲤⲀⲂⲞⲖ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲀⲨϪⲞⲞⲤ ϪⲈ ⲈⲔⲈⲘⲈⲢⲈ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲚⲄⲘⲈⲤⲦⲈ ⲚⲈⲔϪⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲘⲈⲢⲈⲚⲈⲦⲚϪⲒⲚϪⲈⲈⲨⲈ. ⲚⲦⲈⲦⲚϢⲖⲎⲖ ⲈϪⲚ ⲚⲈⲦⲠⲎⲦ ⲚⲤⲀⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϢⲰⲠⲈ ⲚϢⲎⲢⲈ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ϪⲈ ϤⲦⲢⲈⲠⲈϤⲢⲎ ϢⲀ ⲈϪⲚ ⲚⲀⲄⲀⲐⲞⲤ ⲘⲚ ⲘⲠⲞⲚⲎⲢⲞⲤ. ⲀⲨⲰ ϤϨⲰⲞⲨ ⲈϪⲚ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲘⲚ ⲚⲢⲈϤϪⲒ ⲚϬⲞⲚⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ⲈⲦⲈⲦⲚϢⲀⲚⲘⲈⲢⲈ ⲚⲈⲦⲘⲈ ⲄⲀⲢ ⲘⲘⲰⲦⲚ ⲀϢ ⲠⲈ ⲠⲈⲦⲚⲂⲈⲔⲈ ⲈⲦⲈⲨⲚⲦⲎⲦⲚϤ. ⲚⲦⲈⲖⲰⲚⲎⲤ ⲚⲦⲞⲞⲨ ⲈⲒⲢⲈ ⲀⲚ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ⲀⲨⲰ ⲈⲦⲈⲦⲚϢⲀⲚⲀⲤⲠⲀⲌⲈ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ⲘⲘⲀⲦⲈ ⲞⲨ ⲠⲈ ⲠⲈϨⲞⲨⲞ ⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲚⲔⲈϨⲈⲐⲚⲞⲤ ⲚⲦⲞⲞⲨ ⲈⲒⲢⲈ ⲀⲚ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ϢⲰⲠⲈ ϬⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲖⲒⲞⲤ ⲚⲐⲈ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈⲈⲨⲦⲈⲖⲒⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ϮϨⲦⲎⲦⲚ ⲈⲠⲈⲦⲚϮ ⲈⲦⲘⲀⲀϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲢⲰⲘⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲀⲨ ⲈⲢⲰⲦⲚ. ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ⲘⲚ ⲦⲎⲦⲚⲂⲈⲔⲈ ⲘⲘⲀⲨ ⲚⲚⲀϨⲢⲘ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ϨⲞⲦⲀⲚ ϬⲈ ⲔϢⲀⲚⲈⲒⲢⲈ ⲚⲞⲨⲘⲚⲦⲚⲀ ⲘⲠⲢⲰϢ ⲈⲂⲞⲖ ϨⲀⲦⲈⲔϨⲎ ⲚⲐⲈ ⲈⲦⲈⲢⲈ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲈⲒⲢⲈ ⲘⲘⲞⲤ ϨⲢⲀⲒ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲚϨⲒⲢ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲒⲈⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲢⲰⲘⲈ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲨⲞⲨⲰ ⲈⲨϪⲒ ⲘⲠⲈⲨⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ⲚⲦⲞⲔ ⲆⲈ ⲈⲔⲈⲒⲢⲈ ⲚⲞⲨⲘⲚⲦⲚⲀ ⲘⲠⲢⲦⲢⲈⲦⲈⲔϨⲂⲞⲨⲢ ⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲢⲈ ⲦⲈⲔⲞⲨⲚⲀⲘ ⲈⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲦⲈⲔⲘⲚⲦⲚⲀ ϢⲰⲠⲈ ϨⲚ ⲞⲨⲠⲈⲐⲎⲠ ⲀⲨⲰ ⲠⲈⲔⲈⲒⲰⲦ ⲈⲦϬⲰϢⲦ ⲈⲢⲞⲔ ϨⲘ ⲠⲠⲈⲐⲎⲠ ϤⲚⲀⲦⲰⲰⲂⲈ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ⲈⲦⲈⲦⲚⲈⲒ ⲆⲈ ⲈⲦⲈⲦⲚⲀϢⲖⲎⲖ ⲚⲚⲈⲦⲚϢⲰⲠⲈ ⲚⲐⲈ ⲚⲚⲒϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ϪⲈ ⲤⲈⲘⲈ ⲚⲀϨⲈⲢⲀⲦⲞⲨ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲚ ⲚⲔⲖϪⲈ ⲚⲚⲈⲠⲖⲀⲦⲒⲀ ⲈϢⲖⲎⲖ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲨⲞⲨⲰ ⲈⲨϪⲒ ⲘⲠⲈⲨⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ⲚⲦⲞⲔ ⲆⲈ ⲈⲔⲚⲀϢⲖⲎⲖ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲔⲦⲀⲘⲒⲞⲚ ⲚⲄϢⲦⲀⲘ ⲘⲠⲈⲔⲢⲞ. ⲚⲄϢⲖⲎⲖ ⲈⲠⲈⲔⲈⲒⲰⲦ ⲈⲦϨⲘ ⲠⲠⲈⲐⲎⲠ. ⲀⲨⲰ ⲠⲈⲔⲈⲒⲰⲦ ⲈⲦϬⲰϢⲦ ⲈⲢⲞⲔ ϨⲘ ⲠⲠⲈⲐⲎⲠ ϤⲚⲀⲦⲰⲰⲂⲈ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ⲈⲦⲈⲦⲚϢⲖⲎⲖ ⲆⲈ ⲘⲠⲢⲢϨⲀϨ ⲚϢⲀϪⲈ ⲚⲐⲈ ⲚⲚⲒϨⲈⲐⲚⲒⲔⲞⲤ ⲈⲨⲘⲈⲈⲨⲈ ⲄⲀⲢ ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲨⲘⲚⲦϨⲀϨ ⲚϢⲀϪⲈ ⲈⲨⲚⲀⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ⲘⲠⲢⲈⲒⲚⲈ ϬⲈ ⲘⲘⲞⲨ. ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲤⲞⲞⲨⲚ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲘⲠⲈⲦⲈⲦⲚⲢⲬⲢⲒⲀ ⲘⲘⲞϤ ⲘⲠⲀⲦⲈⲦⲚⲀⲒⲦⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ⲦⲀⲒ ϬⲈ ⲦⲈ ⲐⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲀϢⲖⲎⲖ ⲘⲘⲞⲤ. ϪⲈ ⲠⲈⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲘⲀⲢⲈⲠⲈⲔⲢⲀⲚ ⲞⲨⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ⲦⲈⲔⲘⲚⲦⲢⲢⲞ ⲘⲀⲢⲈⲤⲈⲒ ⲠⲈⲔⲞⲨⲰϢ ⲘⲀⲢⲈϤϢⲰⲠⲈ. ⲚⲐⲈ ⲈⲦⲈϤ ϨⲚ ⲦⲠⲈ ⲘⲀⲢⲈϤϢⲰⲠⲈ ⲞⲚ ϨⲒϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ⲠⲈⲚⲞⲈⲒⲔ ⲈⲦⲚⲎⲨ ⲦⲀⲀϤ ⲚⲀⲚ ⲘⲠⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ⲔⲰ ⲚⲀⲚ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲢⲞⲚ. ⲚⲐⲈ ϨⲰⲰⲚ ⲞⲚ ⲈⲦⲈⲚⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲞⲨⲚⲦⲀⲚ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ⲚⲄⲦⲘϪⲒⲦⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ. ⲀⲖⲖⲀ ⲚⲄⲚⲀϨⲘⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲠⲞⲚⲎⲢⲞⲤ ϪⲈ ⲦⲰⲔ ⲦⲈ ⲦϬⲞⲘ ⲘⲚ ⲠⲈⲞⲞⲨ ϢⲀⲚⲒⲈⲚⲈϨ ϨⲀⲘⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ⲈⲦⲈⲦⲚϢⲀⲚⲔⲰ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ⲚⲚⲈⲨⲚⲞⲂⲈ ϤⲚⲀⲔⲰ ϨⲰⲰϤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ⲈⲦⲈⲦⲚⲦⲘⲔⲰ ⲆⲈ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ⲚⲚⲈⲨⲚⲞⲂⲈ ⲚϤⲚⲀⲔⲰ ⲚⲎⲦⲚ ⲀⲚ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ⲈⲦⲈⲦⲚⲚⲎⲤⲦⲈⲨⲈ ⲆⲈ ⲘⲠⲢϢⲰⲠⲈ ⲚⲐⲈ ⲚⲚⲒϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲈⲨⲞⲔⲘ ⲤⲈⲦⲀⲔⲞ ⲄⲀⲢ ⲚⲚⲈⲨϨⲞ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ⲈⲨⲚⲎⲤⲦⲈⲨⲈ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲨⲞⲨⲰ ⲈⲨϪⲒ ⲘⲠⲈⲨⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ⲚⲦⲞⲔ ⲆⲈ ⲈⲔⲚⲎⲤⲦⲈⲨⲈ ⲦⲰϨⲤ ⲚⲦⲈⲔⲀⲠⲈ ⲚⲄⲈⲒⲰ ⲘⲠⲈⲔϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲔⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ⲈⲔⲚⲎⲤⲦⲈⲨⲈ. ⲀⲖⲖⲀ ⲘⲠⲈⲔⲈⲒⲰⲦ ⲈⲦϨⲘ ⲠⲠⲈⲐⲎⲠ ⲀⲨⲰ ⲠⲈⲔⲈⲒⲰⲦ ⲈⲦϬⲰϢⲦ ⲈⲢⲞⲔ ϨⲘ ⲠⲠⲈⲐⲎⲠ ϤⲚⲀⲦⲰⲰⲂⲈ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ⲘⲠⲢⲤⲰⲞⲨϨ ⲚⲎⲦⲚ ⲈϨⲞⲨⲚ ⲚϨⲚⲀϨⲞ ϨⲒϪⲘ ⲠⲔⲀϨ. ⲠⲘⲀ ⲚϢⲀⲢⲈ ⲦϪⲞⲞⲖⲈⲤ ⲘⲚ ⲐⲞⲞⲖⲈ ⲦⲀⲔⲞ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲠⲘⲀ ⲚϢⲀⲢⲈ ⲚⲢⲈϤϪⲒⲞⲨⲈ ϢⲞϪⲦ ⲈⲢⲞϤ ⲚⲤⲈϪⲒⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ⲤⲰⲞⲨϨ ⲆⲈ ⲚⲎⲦⲚ ⲈϨⲞⲨⲚ ⲚϨⲚⲀϨⲞ ϨⲚ ⲦⲠⲈ. ⲠⲘⲀ ⲈⲦⲈⲘⲈⲢⲈϪⲞⲞⲖⲈⲤ ⲞⲨⲆⲈ ϨⲞⲞⲖⲈ ⲦⲀⲔⲞ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲠⲘⲀ ⲈⲦⲈⲘⲈⲢⲈⲢⲈϤϪⲒⲞⲨⲈ ϬⲰⲦϨ ⲈⲢⲞϤ ⲚⲤⲈϪⲒⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ⲠⲘⲀ ⲄⲀⲢ ⲈⲦⲈⲢⲈ ⲠⲈⲔⲀϨⲞ ⲚⲀϢⲰⲠⲈ ⲚϨⲎⲦϤ ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲈⲔⲔⲈϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ⲠϨⲎⲂⲤ ⲘⲠⲤⲰⲘⲀ ⲠⲈ ⲠⲂⲀⲖ. ⲈϢⲰⲠⲈ ⲆⲈ ⲠⲈⲔⲂⲀⲖ ⲞⲨϨⲀⲠⲖⲞⲨⲤ ⲠⲈ. ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲚⲀϢⲰⲠⲈ ⲈϤⲞ ⲚⲞⲨⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ⲈϢⲰⲠⲈ ⲆⲈ ⲠⲈⲔⲂⲀⲖ ⲞⲨⲠⲞⲚⲎⲢⲞⲤ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲚⲀϢⲰⲠⲈ ⲈϤⲞ ⲚⲔⲀⲔⲈ ⲈϢϪⲈ ⲠⲞⲨⲞⲈⲒⲚ ϬⲈ ⲈⲦⲚϨⲎⲦⲔ ⲞⲨⲔⲀⲔⲈ ⲠⲈ ⲠⲔⲀⲔⲈ ⲞⲨⲎⲢ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ⲘⲚϬⲞⲘ ⲚⲖⲀⲀⲨ ⲈⲢϨⲘϨⲀⲖ ⲚϪⲞⲈⲒⲤ ⲤⲚⲀⲨ ⲎⲄⲀⲢ ϤⲚⲀⲘⲈⲤⲦⲈ ⲞⲨⲀ ⲚϤⲘⲈⲢⲈ ⲞⲨⲀ ⲎⲚϤϬⲞⲖϪϤ ⲚⲞⲨⲀ ⲚϤⲔⲀⲦⲀⲪⲢⲞⲚⲈⲒ ⲘⲠⲔⲈⲞⲨⲀ ⲘⲚ ϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲢϨⲘϨⲀⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲠⲘⲀⲘⲰⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ⲈⲦⲂⲈⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ⲈⲦⲈⲦⲚⲮⲨⲬⲎ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲞⲨⲞⲘϤ ⲎⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲤⲞⲞϤ ⲞⲨⲦⲈ ⲠⲈⲦⲚⲤⲰⲘⲀ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲦⲀⲀϤ ϨⲒⲰⲦⲦⲎⲨⲦⲚ Ⲙ Ⲏ ⲦⲈⲮⲨⲬⲎ ⲞⲨⲞⲞⲦ ⲀⲚ ⲈⲦⲈϨⲢⲈ ⲀⲨⲰ ⲠⲤⲰⲘⲀ ⲈⲐⲂⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ϬⲰϢⲦ ⲈⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ϪⲈ ⲈⲤⲈϪⲞ ⲀⲚ ⲞⲨⲦⲈ ⲚⲤⲈⲰϨⲤ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲤⲰⲞⲨϨ ⲀⲚ ⲈϨⲞⲨⲚ ⲈⲀⲠⲞⲐⲎⲔⲎ ⲀⲨⲰ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲤⲀⲚϢ ⲘⲘⲞⲞⲨ ⲚⲦⲰⲦⲚ ϬⲈ ⲚϨⲞⲨⲞ ⲘⲎ ⲚⲦⲈⲦⲚ ϢⲞⲂⲈ ⲀⲚ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ⲚⲒⲘ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤϤⲒⲢⲞⲞⲨϢ ⲈⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲞⲨⲈϨⲞⲨⲘⲀϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤϢⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ⲀⲨⲰ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϤⲒⲢⲞⲞⲨϢ ϨⲀⲐⲂⲤⲰ ϬⲰϢⲦ ⲈⲚⲈⲔⲢⲒⲚⲞⲚ ⲚⲦⲤⲰϢⲈ ⲚⲐⲈ ⲈⲦⲞⲨⲀⲨⲜⲀⲚⲈ ⲘⲘⲞⲤ ϪⲈ ⲚⲤⲈϨⲒⲤⲈ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲢⲈⲒⲞⲠⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲆⲈ ⲤⲞⲖⲞⲘⲰⲚ ϨⲘ ⲠⲈϤⲈⲞⲞⲨ ⲦⲎⲢϤ ⲘⲠⲈϤϮ ϨⲒⲰⲰϤ ⲚⲐⲈ ⲚⲞⲨⲀ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ⲈϢϪⲈ ⲠⲈⲬⲞⲢⲦⲞⲤ ⲚⲦⲤⲰϢⲈ ⲈϤϢⲞⲞⲠ ⲘⲠⲞⲞⲨ ⲢⲀⲤⲦⲈ ⲈⲨⲚⲀⲚⲞϪϤ ⲈⲦⲈⲦⲢⲒⲢ. ⲠⲚⲞⲨⲦⲈ ϮϨⲒⲰⲰϤ ⲚⲦⲈⲒϨⲈ. ⲠⲞⲤⲞ ⲘⲀⲖⲖⲞⲚ ϨⲒⲰⲦⲦⲎⲨⲦⲚ ⲚⲀⲦⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ϬⲈ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲞⲨⲞⲘϤ. ⲎⲞⲨ ⲠⲈⲦⲚⲚⲀⲤⲞⲞϤ. ⲎⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲦⲀⲀϤ ϨⲒⲰⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚϨⲈⲐⲚⲞⲤ ⲚⲈⲦϢⲒⲚⲈ ⲚⲤⲰⲞⲨ. ϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲚϬⲒ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ϪⲈ ⲦⲈⲦⲚⲢⲬⲢⲒⲀ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ϢⲒⲚⲈ ⲆⲈ ⲚϢⲞⲢⲠ ⲚⲤⲀⲦⲈϤⲘⲚⲦⲢⲢⲞ ⲘⲚ ⲦⲈϤⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ⲀⲨⲰ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲈⲚⲀⲞⲨⲀϨⲞⲨ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ϬⲈ ⲈⲠⲈϤⲢⲀⲤⲦⲈ. ⲢⲀⲤⲦⲈ ⲄⲀⲢ ⲚⲀϤⲒⲢⲞⲞⲨϢ ϨⲀⲢⲞϤ. ϨⲰ ⲈⲠⲈϨⲞⲞⲨ ⲠⲈϨⲞⲞⲨ ⲈⲦⲈϤⲔⲀⲔⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ⲘⲠⲢⲔⲢⲒⲚⲈ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲨⲔⲢⲒⲚⲈ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ϨⲘ ⲠϨⲀⲠ ⲄⲀⲢ ⲈⲦⲈⲦⲚⲀϮϨⲀⲠ ⲚϨⲎⲦϤ ⲈⲨⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲰⲦⲚ ⲚϨⲎⲦϤ. ⲀⲨⲰ ϨⲘ ⲠϢⲒ ⲈⲦⲈⲦⲚⲀϢⲒ ⲘⲘⲞϤ ⲈⲨⲚⲀϢⲒ ⲚⲎⲦⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ⲀϨⲢⲞⲔ ⲆⲈ ⲔϬⲰϢⲦ ⲈⲠϪⲎ ⲈⲦ ϨⲘ ⲠⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ⲠⲤⲞⲒ ⲆⲈ ⲈⲦϨⲘ ⲠⲈⲔⲂⲀⲖ ⲚⲄⲚⲀⲨ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ⲎⲚⲀϢ ⲚϨⲈ ⲔⲚⲀϪⲞⲞⲤ ⲘⲠⲈⲔⲤⲞⲚ ϪⲈ ⲠⲀⲤⲞⲚ. ϬⲰ ⲦⲀⲚⲈϪⲠϪⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲂⲀⲖ ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲠⲤⲞⲒ ϨⲘ ⲠⲈⲔⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ⲠϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲚⲞⲨϪⲈ ⲚϢⲞⲢⲠ ⲘⲠⲤⲞⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲂⲀⲖ ⲀⲨⲰ ⲔⲚⲀⲚⲀⲨ ⲈⲂⲞⲖ ⲈⲚⲈϪⲠϪⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ⲘⲠⲢϮ ⲚⲚⲈⲦⲘⲠⲈⲦⲞⲨⲀⲀⲂ ⲚⲚⲈⲨϨⲞⲞⲢ ⲞⲨⲆⲈ ⲘⲠⲢⲚⲞⲨϪⲈ ⲚⲚⲈⲦⲚⲈⲚⲈⲘⲘⲈ ϨⲀⲢⲰⲞⲨ ⲚⲚⲈϢⲀⲨ ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈϨⲞⲘⲞⲨ ⲚⲚⲈⲨⲞⲨⲈⲢⲎⲦⲈ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲚⲤⲈⲠⲈϨⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ⲀⲒⲦⲈⲒ ⲦⲀⲢⲞⲨϮ ⲚⲎⲦⲚ. ϢⲒⲚⲈ ⲦⲀⲢⲈⲦⲈⲦⲚϬⲒⲚⲈ. ⲦⲰϨⲘ ⲦⲀⲢⲞⲨⲞⲨⲰⲚ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲀⲒⲦⲈⲒ ϤⲚⲀϪⲒ. ⲀⲨⲰ ⲠⲈⲦϢⲒⲚⲈ ϤⲚⲀϨⲈ ⲈⲞⲨⲞⲚ. ⲀⲨⲰ ⲠⲈⲦⲦⲰϨⲘ ⲤⲈⲚⲀⲞⲨⲰⲚ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ⲎⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϢⲎⲢⲈ ⲚⲀⲀⲒⲦⲈⲒ ⲘⲘⲞϤ ⲚⲞⲨⲞⲈⲒⲔ. ⲘⲎ ϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ⲎⲚϤⲀⲒⲦⲈⲒ ⲘⲘⲞϤ ⲚⲞⲨⲦⲎⲂⲦ. ⲘⲎ ϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨϨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ⲈϢϪⲈ ⲚⲦⲰⲦⲚ ϬⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲠⲞⲚⲎⲢⲞⲤ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲈϮ ⲚϨⲈⲚϮ ⲈⲚⲀⲚⲞⲨⲞⲨ ⲚⲚⲈⲦⲚϢⲎⲢⲈ. ⲠⲞⲤⲞ ⲘⲀⲖⲖⲞⲚ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ϤⲚⲀϮ ⲚϨⲈⲚⲀⲄⲀⲐⲞⲚ ⲚⲚⲈⲦⲀⲒⲦⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ϨⲰⲂ ϬⲈ ⲚⲒⲘ ⲈⲦⲈⲦⲚⲞⲨⲀϢⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲚⲢⲰⲘⲈ ⲀⲀⲨ ⲚⲎⲦⲚ. ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲀⲢⲒⲤⲞⲨ ⲚⲀⲨ ⲚⲦⲈⲒϨⲈ. ⲠⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲚⲞⲘⲞⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ⲂⲰⲔ ⲈϨⲞⲨⲚ ϨⲒⲦⲚ ⲦⲠⲨⲖⲎ ⲈⲦϬⲎⲨ. ϪⲈ ⲤⲞⲨⲞϢⲤ ⲚϬⲒ ⲦⲠⲨⲖⲎ ⲀⲨⲰ ⲤⲞⲨⲈⲤⲦⲰⲚ ⲚϬⲒ ⲦⲈϨⲒⲎ ⲈⲦϪⲒⲘⲞⲈⲒⲦ ⲈϨⲞⲨⲚ ⲈⲠⲦⲀⲔⲞ. ⲀⲨⲰ ϨⲀϨ ⲚⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ϨⲒⲦⲞⲞⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ϪⲈ ⲤϬⲎⲨ ⲆⲈ ⲚϬⲒ ⲦⲠⲨⲖⲎ ⲀⲨⲰ ⲤϨⲈϪϨⲰϪ ⲚϬⲒ ⲦⲈϨⲒⲎ ⲈⲦϪⲒⲘⲞⲈⲒⲦ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ. ⲀⲨⲰ ϨⲈⲚⲔⲞⲨⲒ ⲚⲈⲦⲚⲀϨⲈ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ϮϨⲦⲎⲦⲚ ⲆⲈ ⲈⲢⲰⲦⲚ ⲈⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ. ⲚⲀⲒ ⲈⲦⲚⲎⲨ ϢⲀⲢⲰⲦⲚ ϨⲚ ϨⲈⲚϨⲂⲤⲰ ⲚⲈⲤⲞⲞⲨ. ⲠⲈⲨϨⲞⲨⲚ ⲆⲈ ϨⲈⲚⲞⲨⲰⲚϢ ⲚⲢⲈϤⲦⲰⲢⲠ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲔⲀⲢⲠⲞⲤ ⲈⲦⲈⲦⲚⲀⲤⲞⲨⲰⲚⲞⲨ. ⲘⲎⲦⲒ ϢⲀⲨϪⲈⲈⲖⲈ ⲈⲖⲞⲞⲖⲈ ⲈⲂⲞⲖ ϨⲚ ϢⲞⲚⲦⲈ. ⲎϢⲀⲨⲔⲈⲦϤ ⲔⲚⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲀⲢⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚϢⲎⲚ ⲚⲒⲘ ⲈⲚⲀⲚⲞⲨϤ ⲚϢⲀϤⲦⲀⲨⲈ ⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈⲚⲀⲚⲞⲨϤ. ⲠϢⲎⲚ ⲆⲈ ⲈⲐⲞⲞⲨ ⲚϢⲀϤⲦⲀⲨⲈ ⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈϤϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ⲘⲚ ϢϬⲞⲘ ⲚⲞⲨϢⲎⲚ ⲈⲚⲀⲚⲞⲨϤ ⲈⲦⲀⲨⲈ ⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈϤϨⲞⲞⲨ. ⲞⲨⲆⲈ ϢⲎⲚ ⲈϤϨⲞⲞⲨ ⲈⲦⲀⲨⲈ ⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ϢⲎⲚ ϬⲈ ⲚⲒⲘ ⲈⲦⲈ ⲚϤⲚⲀⲦⲀⲨⲈ ⲔⲀⲢⲠⲞⲤ ⲀⲚ ⲈⲚⲀⲚⲞⲨϤ. ⲤⲈⲚⲀⲔⲞⲞⲢⲈϤ ⲚⲤⲈⲚⲞϪϤ ⲈⲦⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ⲀⲢⲀ ϬⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲔⲀⲢⲠⲞⲤ ⲈⲦⲈⲦⲚⲀⲤⲞⲨⲰⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲚ ⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲀⲒ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠϪⲞⲈⲒⲤ ⲠⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ⲀⲖⲖⲀ ⲠⲈⲦⲈⲒⲢⲈ ⲠⲈ ⲘⲠⲞⲨⲰϢ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ⲞⲨⲚϨⲀϨ ⲄⲀⲢ ⲚⲀϪⲞⲞⲤ ⲚⲀⲒ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠϪⲞⲈⲒⲤ ⲘⲎ ϨⲢⲀⲒ ⲀⲚ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲀⲚⲠⲢⲞⲪⲎⲦⲈⲨⲈ. ⲀⲨⲰ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲀⲚⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ. ⲘⲎ ϨⲢⲀⲒ ⲀⲚ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲀⲚⲢϨⲀϨ ⲚϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ⲀⲨⲰ ⲦⲞⲦⲈ ϮⲚⲀϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲚⲀⲨ ϪⲈ ⲘⲠⲈⲒⲤⲞⲨⲚⲦⲎⲨⲦⲚ ⲈⲚⲈϨ. ⲤⲀϨⲈⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ⲚⲈⲦⲢϨⲰⲂ ⲈⲦⲀⲚⲞⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ⲞⲨⲞⲚ ϬⲈ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲚⲀϢⲀϪⲈ ⲈⲦⲈⲚⲀⲒ ⲚⲈ ⲈϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ⲈϤⲚⲀⲈⲒⲚⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲚⲤⲀⲂⲈ. ⲠⲀⲒ ⲚⲦⲀϤⲔⲰⲦ ⲘⲠⲈϤⲎⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲠⲈⲦⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲚϬⲒ ⲠϨⲰⲞⲨ ⲀⲨⲈⲒ ⲚϬⲒ ⲚⲈⲒⲈⲢⲰⲞⲨ ⲀⲨⲚⲈⲒϤⲈ ⲚϬⲒ ⲚⲦⲎⲨ ⲀⲨϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲎⲒ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲰ ⲘⲠⲈϤϨⲈ ϪⲈ ⲚⲈϤⲦⲀϪⲢⲎⲨ ⲄⲀⲢ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲠⲈⲦⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲚⲀϢⲀϪⲈ ⲈⲦⲈⲚⲀⲒ ⲚⲈ ⲚϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀⲚ. ⲈϤⲚⲀⲈⲒⲚⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲚⲤⲞϬ. ⲠⲀⲒ ⲚⲦⲀϤⲔⲰⲦ ⲘⲠⲈϤⲎⲒ ϨⲒϪⲘ ⲠϢⲰ. ");
INSERT INTO copshc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲚϬⲒ ⲠϨⲰⲞⲨ ⲀⲨⲈⲒ ⲚϬⲒ ⲚⲈⲒⲈⲢⲰⲞⲨ ⲀⲨⲚⲈⲒϤⲈ ⲚϬⲒ ⲚⲦⲎⲨ ⲀⲨϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲎⲒ ⲈⲦⲘⲘⲀⲨ ⲀϤϨⲈ ⲀⲨⲰ ⲠⲈϤϨⲈ ⲚⲈϤⲞ ⲚⲞⲨⲚⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲰ ⲚⲚⲈⲒϢⲀϪⲈ. ⲀⲨⲢϢⲠⲎⲢⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ⲚⲈϤϮⲤⲂⲰ ⲄⲀⲢ ⲚⲀⲨ ⲠⲈ ϨⲰⲤ ⲈⲨⲚⲦϤⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ⲀⲨⲰ ⲚⲐⲈ ⲀⲚ ⲚⲚⲈⲨⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ⲈϤⲚⲎⲨ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ϨⲒⲠⲦⲞⲞⲨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲀ ⲈϤⲤⲞⲂϨ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲔϢⲀⲚⲞⲨⲰϢ ⲞⲨⲚϢϬⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲂⲂⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ⲀϤⲤⲞⲞⲨⲦⲚ ⲆⲈ ⲚⲦⲈϤϬⲒϪ ⲈⲂⲞⲖ ⲀϤϪⲰϨ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ⲦⲂⲂⲞ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲦⲂⲂⲞ ⲚϬⲒ ⲠⲈϤⲤⲰⲂϨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϬⲰϢⲦ ⲘⲠⲢϪⲞⲞⲤ ⲈⲖⲀⲀⲨ. ⲀⲖⲖⲀ ⲂⲰⲔ ⲚⲄⲦⲞⲨⲞⲔ ⲈⲠⲞⲨⲎⲎⲂ. ⲚⲄⲦⲀⲖⲞ ⲈϨⲢⲀⲒ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲔⲀⲦⲀⲐⲈ ⲚⲦⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲘⲰⲨⲤⲎⲤ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈϤⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲀϢⲎⲢⲈ ⲚⲎϪ ϨⲢⲀⲒ ϨⲘ ⲠⲀⲎⲒ ⲈϤⲤⲎϬ. ⲀⲨⲰ ⲈϤⲂⲀⲤⲀⲚⲒⲌⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲎⲨ ⲦⲀⲢⲠⲀϨⲢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚϮⲘⲠϢⲀ ⲀⲚ ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲈⲒ ⲈϨⲞⲨⲚ ϨⲀⲦⲀⲞⲨⲈϨⲤⲞⲒ. ⲀⲖⲖⲀ ⲀϪⲒⲤ ⲘⲘⲀⲦⲈ ϨⲘ ⲠϢⲀϪⲈ ⲀⲨⲰ ϤⲚⲀⲖⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ⲔⲀⲒ ⲄⲀⲢ ⲀⲚⲞⲔ ⲀⲚⲄⲞⲨⲢⲰⲘⲈ ⲈⲒϢⲞⲞⲠ ϨⲀⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲈⲢⲈϨⲈⲚⲘⲀⲦⲞⲒ ϢⲞⲞⲠ ϨⲀⲢⲀⲦ ϢⲀⲒϪⲞⲞⲤ ⲘⲠⲀⲒ ϪⲈ ⲂⲰⲔ ⲀⲨⲰ ϢⲀϤⲂⲰⲔ ⲀⲨⲰ ⲔⲈⲞⲨⲀ ϪⲈ ⲀⲘⲞⲨ ⲀⲨⲰ ⲚϤⲈⲒ ⲀⲨⲰ ⲠⲀϨⲘϨⲀⲖ ϪⲈ ⲀⲢⲒⲠⲀⲒ ⲚϤⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲢϢⲠⲎⲢⲈ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲚⲈⲦⲞⲨⲎϨ ⲚⲤⲰϤ. ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲈⲒϨⲈ ⲈⲠⲒⲤⲦⲒⲤ ⲚⲦⲈⲒϬⲞⲦ ⲚⲦⲚⲖⲀⲀⲨ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϨⲀϨ ⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲘⲀ ⲚϢⲀ ⲘⲚ ⲘⲘⲀⲚϨⲰⲦⲚ ⲚⲤⲈⲚⲞϪⲞⲨ ⲘⲚ ⲀⲂⲢⲀϨⲀⲘ ⲘⲚ ⲒⲤⲀⲀⲔ ⲘⲚ ⲒⲀⲔⲰⲂ ϨⲢⲀⲒ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ⲚϢⲎⲢⲈ ⲆⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲤⲈⲚⲀⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ⲈⲠⲔⲀⲔⲈ ⲈⲦϨⲒⲂⲞⲖ. ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ ⲘⲚ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ⲠⲈϪⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ϪⲈ ⲂⲰⲔ ⲚⲐⲈ ⲚⲦⲀⲔⲠⲒⲤⲦⲈⲨⲈ ⲘⲀⲢⲈⲤϢⲰⲠⲈ ⲚⲀⲔ. ⲀⲨⲰ ⲀϤⲖⲞ ⲚϬⲒ ⲠⲈϤϢⲎⲢⲈ ϪⲒⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ⲀϤⲈⲒ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ⲘⲠⲈⲦⲢⲞⲤ. ⲀϤⲚⲀⲨ ⲈⲦⲈϤϢⲰⲘⲈ ⲈⲤⲚⲎϪ ⲀⲨⲰ ⲈⲤϨⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ⲀϤϪⲰϨ ⲆⲈ ⲈⲦⲈⲤϬⲒϪ ⲀϤⲔⲀⲀⲤ ⲚϬⲒ ⲠⲈϨⲘⲞⲘ. ⲀⲤⲦⲰⲞⲨⲚ ⲀⲤⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚϨⲀϨ ⲈⲨⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ⲀϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ϨⲘ ⲠϢⲀϪⲈ. ⲀⲨⲰ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲘⲞⲔϨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞϤ ⲠⲈⲚⲦⲀϤϪⲒ ⲚⲚϢⲰⲚⲈ ⲀⲨⲰ ⲀϤⲦⲰⲞⲨⲚ ϨⲀⲚⲈⲚⲖⲞϪⲖⲈϪ. ");
INSERT INTO copshc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲨⲘⲎⲎϢⲈ ⲘⲠⲈϤⲔⲰⲦⲈ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲂⲰⲔ ⲈⲠⲈⲒⲔⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠⲤⲀϨ ⲦⲀⲞⲨⲀϨⲦ ⲚⲤⲰⲔ ⲈⲠⲘⲀ ⲈⲦⲈⲔⲚⲀⲂⲰⲔ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲂⲀϢⲞⲢ ⲞⲨⲚⲦⲀⲨ ⲚⲈⲨⲂⲎⲂ. ⲀⲨⲰ ⲚϨⲀⲖⲀⲀⲦⲈ ⲚⲦⲠⲈ ⲞⲨⲚⲦⲀⲨ ⲚⲈⲨⲘⲀϨ. ⲠϢⲎⲢⲈ ⲆⲈ ⲘⲠⲢⲰⲘⲈ ⲘⲚⲦϤⲘⲀ ⲚⲢⲈⲔⲦⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ⲔⲈⲞⲨⲀ ⲆⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲒ ⲚϢⲞⲢⲠ ⲦⲀⲂⲰⲔ ⲦⲀⲦⲰⲘⲤ ⲘⲠⲀⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ ⲚⲄⲔⲰ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲈⲦⲰⲘⲤ ⲚⲚⲈⲨⲢⲈϤⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ⲚⲦⲈⲢⲈϤⲀⲖⲈ ⲆⲈ ⲈⲠϪⲞⲒ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲚⲞϬ ⲚⲔⲘⲦⲞ ⲀϤϢⲰⲠⲈ ϨⲚ ⲐⲀⲖⲀⲤⲤⲀ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲠϪⲞⲒ ϨⲰⲂⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϨⲒⲘⲎ. ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤⲚⲔⲞⲦⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀⲨⲦⲞⲨⲚⲞⲤϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲀⲦⲀⲚϨⲞⲚ ϪⲈ ⲦⲚⲚⲀⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲢϨⲞⲦⲈ ⲚⲀⲦⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ. ⲦⲞⲦⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲚⲦⲎⲨ ⲘⲚ ⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ⲀⲤϢⲰⲠⲈ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲚϪⲀⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ⲚⲢⲰⲘⲈ ⲆⲈ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀϢ ⲘⲘⲒⲚⲈ ⲠⲈ ⲠⲀⲒ ϪⲈ ⲚⲦⲎⲨ ⲘⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲤⲰⲦⲘ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲠⲈⲔⲢⲞ ⲈⲦⲈⲬⲰⲢⲀ ⲚⲚⲄⲈⲢⲀⲌⲎⲚⲞⲤ. ⲀⲨⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲚϬⲒ ⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲈⲢⲈϨⲈⲚⲢⲈϤϢⲞⲞⲢ ϨⲒⲰⲞⲨ ⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲘϨⲀⲀⲨ ⲈⲨⲚⲀϢⲦ ⲈⲘⲀⲦⲈ. ϨⲰⲤⲦⲈ ⲈⲦⲘⲦⲢⲈⲖⲀⲀⲨ ⲈϢⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϨⲒⲎ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲔⲞⲨⲈϢⲞⲨ ⲚⲘⲘⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲀⲔⲈⲒ ⲈⲠⲈⲒⲘⲀ ⲈⲂⲀⲤⲀⲚⲒⲌⲈ ⲘⲘⲞⲚ ϨⲀⲐⲎ ⲘⲠⲈⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ⲚⲈⲨⲚⲞⲨⲀⲄⲈⲖⲎ ⲆⲈ ⲚⲢⲒⲢ ⲈⲚⲀϢⲰⲞⲨ ⲞⲨⲎⲨ ⲘⲘⲞⲞⲨ ⲈⲨⲘⲞⲞⲚⲈ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ⲚⲢⲈϤϢⲞⲞⲢ ⲆⲈ ⲀⲨⲤⲠⲤⲰⲠϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢϪⲈ ⲔⲚⲀⲚⲞϪⲚ ⲈⲂⲞⲖ ⲘⲀϪⲞⲞⲨⲚ ⲈϨⲞⲨⲚ ⲈⲦⲀⲄⲈⲖⲎ ⲚⲈϢⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲚⲈϢⲀⲨ ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲚϬⲒ ⲦⲀⲄⲈⲖⲎ ⲦⲎⲢⲤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦϢⲰⲘⲈ ⲈⲠⲈⲤⲎⲦ ⲈⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲰ ⲀⲨⲘⲞⲨ ϨⲢⲀⲒ ϨⲚ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ⲚⲈⲦⲘⲞⲞⲚⲈ ⲆⲈ ⲘⲘⲞⲞⲨ ⲀⲨⲠⲰⲦ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ. ⲀⲨϪⲰ ⲚϨⲰⲂ ⲚⲒⲘ ⲘⲚ ⲚⲀⲚⲈⲦⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲀⲤⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲰⲘⲚⲦ ⲈⲒⲎⲤⲞⲨⲤ. ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲀⲨⲤⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲦⲞϢ. ");
INSERT INTO copshc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ⲀϤⲀⲖⲈ ⲆⲈ ⲈⲠϪⲞⲒ ⲀϤϪⲒⲞⲞⲢ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈϤⲠⲞⲖⲒⲤ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲢⲰⲘⲈ ⲈϤⲤⲎϬ ⲈϤⲚⲎϪ ϨⲒϪⲚ ⲞⲨⲘⲀ ⲚⲚⲔⲞⲦⲔ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲦⲈⲨⲠⲒⲤⲦⲒⲤ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲤⲎϬ. ϪⲈ ⲦⲰⲔ ⲘⲘⲞⲔ ⲠⲀϢⲎⲢⲈ ⲚⲈⲔⲚⲞⲂⲈ ⲔⲎ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ⲀⲨⲰ ⲈⲒⲤϨⲞⲒⲚⲈ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲠⲈϪⲀⲨ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ. ϪⲈ ⲠⲀⲒ ⲈϤϪⲒⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤⲤⲞⲞⲨⲚ ⲚⲚⲈⲨⲘⲈⲈⲨⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲈϨⲈⲚⲠⲈⲐⲞⲞⲨ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ⲀϢ ⲄⲀⲢ ⲠⲈⲦⲘⲞⲦⲚ. ⲈϪⲞⲞⲤ ⲠⲈ ϪⲈ ⲚⲈⲔⲚⲞⲂⲈ ⲔⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ϪⲚⲈϪⲞⲞⲤ ⲠⲈ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ϪⲈⲔⲀⲀⲤ ⲆⲈ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ϪⲈ ⲞⲨⲚⲦⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲜⲞⲨⲤⲒⲀ ⲈϨⲢⲀⲒ ϨⲒϪⲘ ⲠⲔⲀϨ ⲈⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲤⲎϬ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄϤⲒ ⲘⲠⲈⲔϬⲖⲞϬ ⲚⲄⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲔⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ⲀⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲀⲨⲢϨⲞⲦⲈ ⲀⲨⲰ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲦⲀϤϮⲈⲜⲞⲨⲤⲒⲀ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲚⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲀⲢⲀⲄⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲚⲀⲨ ⲈⲨⲢⲰⲘⲈ ⲈϤϨⲘⲞⲞⲤ ϨⲒⲠⲈϤⲦⲈⲖⲰⲚⲒⲞⲚ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲘⲀⲐⲐⲀⲒⲞⲤ. ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤⲚⲎϪ ϨⲢⲀⲒ ϨⲘ ⲠⲈϤⲎⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲚⲈⲨⲚϨⲀϨ ⲚⲦⲈⲖⲰⲚⲎⲤ ϨⲒⲢⲈϤⲢⲚⲞⲂⲈ ⲈⲨⲚⲎⲨ ⲈⲨⲚⲞⲨϪⲈ ⲘⲘⲞⲞⲨ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ⲀⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲠⲈϪⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲠⲈⲦⲚⲤⲀϨ ⲞⲨⲰⲘ ⲘⲚ ⲚⲦⲈⲖⲰⲚⲎⲤ ⲀⲨⲰ ⲚⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲤⲰⲦⲘ ⲠⲈϪⲀϤ. ϪⲈ ⲚⲈⲦⲦⲎⲔ ⲀⲚ ⲚⲈⲦⲢⲬⲢⲒⲀ ⲘⲠⲤⲀⲈⲒⲚ. ⲀⲖⲖⲀ ⲚⲈⲦⲘⲞⲔϨ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ⲂⲰⲔ ⲆⲈ ⲚⲦⲈⲦⲚ ⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲒⲞⲨⲈϢⲞⲨⲚⲀ ⲈϨⲞⲨⲈⲞⲨⲐⲨⲤⲒⲀ. ⲚⲦⲀⲒⲈⲒ ⲄⲀⲢ ⲀⲚ ⲈⲦⲈϨⲘⲚⲆⲒⲔⲀⲒⲞⲤ. ⲀⲖⲖⲀ ⲚⲢⲈϤⲢⲚⲞⲂⲈ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ⲦⲞⲦⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲚⲞⲚ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲦⲚⲚⲎⲤⲦⲈⲨⲈ ⲚϨⲀϨ ⲚⲤⲞⲠ. ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲤⲈⲚⲎⲤⲦⲈⲨⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲎ ⲞⲨⲚϬⲞⲘ ⲚⲚⲈϢⲎⲢⲈ ⲘⲠⲘⲀ ⲦϢⲈⲖⲈⲈⲦ ⲈⲚⲎⲤⲦⲈⲨⲈ ⲈⲪⲞⲤⲞⲚ ⲠⲀⲦϢⲈⲖⲈⲈⲦ ϢⲞⲞⲠ ⲚⲘⲘⲀⲨ ⲤⲈⲚⲎⲨ ⲆⲈ ⲚϬⲒ ϨⲈⲚϨⲞⲞⲨ ϨⲞⲦⲀⲚ ⲈⲨϢⲀⲚϤⲒ ⲘⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲚⲦⲞⲞⲦⲞⲨ ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲎⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ⲘⲈⲢⲈⲖⲀⲀⲨ ϨⲒⲞⲨⲦⲞⲈⲒⲤ ⲚϢⲀⲒ ⲈⲨϢⲦⲎⲚ ⲘⲠⲖϬⲈ. ⲤⲚⲀϤⲒ ⲄⲀⲢ ⲘⲠⲈⲤⲔⲰⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϢⲦⲎⲚ ⲚϤϢⲰⲠⲈ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲘⲠⲰϨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ⲞⲨⲆⲈ ⲘⲈⲨⲚⲈϪⲘⲢⲒⲤ ⲈϨⲰⲦ ⲚⲀⲤ ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ϢⲀⲨⲠⲰϨ ⲚϬⲒ ⲚϨⲰⲦ ⲚⲦⲈⲠⲎⲢⲠ ⲠⲰⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲔⲈϨⲰⲦ ⲦⲀⲔⲞ ⲀⲖⲖⲀ ⲚϢⲀⲨⲚⲈϪⲎⲢⲠ ⲚⲂⲢⲢⲈ ⲈⲀⲤⲔⲞⲤ ⲚⲂⲢⲢⲈ ⲚⲤⲈϢⲰⲠⲈ ⲈⲨⲞⲨⲞϪ ⲘⲠⲈⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲞⲨ ⲚⲀⲨ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲀⲢⲬⲰⲚ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲦⲀϢⲈⲈⲢⲈ ⲘⲞⲨ ⲦⲈⲚⲞⲨ ⲀⲖⲖⲀ ⲀⲘⲞⲨ ⲚⲄⲦⲀⲖⲞ ⲚⲦⲈⲔϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ⲀⲨⲰ ⲤⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ⲈⲒⲤⲞⲨⲤϨⲒⲘⲈ ⲆⲈ ⲈⲢⲈⲠⲈⲤⲚⲞϤ ϢⲞⲞⲠ ϨⲀⲢⲞⲤ ⲘⲘⲚⲦⲤⲚⲞⲞⲨⲤⲈ ⲚⲢⲞⲘⲠⲈ. ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲠⲀϨⲞⲨ ⲘⲘⲞϤ ⲀⲤϪⲰϨ ⲈⲠⲦⲞⲠ ⲘⲠⲈϤϨⲞⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ⲚⲈⲤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϨⲢⲀⲒ ⲚϨⲎⲦⲤ. ϪⲈ ⲈⲒϢⲀⲚϪⲰϨ ⲘⲘⲀⲦⲈ ⲈⲠⲦⲞⲠ ⲚⲦⲈϤϢⲦⲎⲚ ϮⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲔⲞⲦϤ ⲀϤⲚⲀⲨ ⲈⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ. ϪⲈ ⲦⲰⲔ ⲘⲘⲞ ⲦⲀϢⲈⲈⲢⲈ ⲦⲞⲨⲠⲒⲤⲦⲒⲤ ⲦⲈ ⲚⲦⲀⲤⲚⲀϨⲘⲈ. ⲀⲨⲰ ⲀⲤⲞⲨϪⲀⲒ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ϪⲒⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ⲘⲠⲀⲢⲬⲰⲚ ⲀϤⲚⲀⲨ ⲈⲚⲢⲈϤϪⲞⲞⲨⲈ ⲘⲚ ⲠⲘⲎⲎϢⲈ ⲈⲨϢⲦⲢⲦⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲀⲬⲰⲢⲈⲒ ⲚⲎⲦⲚ ⲘⲠⲈⲤⲘⲞⲨ ⲄⲀⲢ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ. ⲀⲖⲖⲀ ⲈⲤⲚⲔⲞⲦⲔ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨⲤⲰⲂⲈ ⲚⲤⲰϤ ⲈⲨⲤⲞⲞⲨⲚ ϪⲈ ⲀⲤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ⲚⲦⲈⲢⲞⲨⲚⲞⲨϪⲈ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲘⲎⲎϢⲈ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲦⲈⲤϬⲒϪ. ⲀⲤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ⲠⲈϤⲤⲞⲈⲒⲦ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ⲈϤⲠⲀⲢⲀⲄⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ⲂⲖⲖⲈ ⲤⲚⲀⲨ ⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀ ⲚⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲂⲖⲖⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲒ ⲈⲢⲠⲀⲒ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ⲦⲞⲦⲈ ⲀϤϪⲰϨ ⲈⲚⲈⲨⲂⲀⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀⲦⲀⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ ⲘⲀⲢⲈⲤϢⲰⲠⲈ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ⲀⲨⲰ ⲀⲨⲞⲨⲰⲚ ⲚϬⲒ ⲚⲈⲨⲂⲀⲖ. ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲰϢⲦ ⲘⲠⲢⲦⲢⲈⲖⲀⲀⲨ ⲈⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲀⲨϮ ⲘⲠⲈϤⲤⲞⲈⲒⲦ ϨⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ⲈϤⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲘⲠⲞ ⲈⲢⲈⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲒⲰⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲘⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲀϤϢⲀϪⲈ ⲚϬⲒ ⲠⲈⲘⲠⲞ. ⲀⲨⲢϢⲠⲎⲢⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲞⲨⲞⲚ ⲚⲦⲈⲒϨⲈ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲚⲈϨ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲀⲢⲬⲰⲚ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ⲀⲨⲰ ⲀϤⲘⲞⲨϢⲦ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲘⲠⲞⲖⲒⲤ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚϮⲘⲈ ⲈϤϮⲤⲂⲰ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ. ⲀⲨⲰ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲈϤⲢⲠⲀϨⲢⲈ ⲈϢⲰⲚⲈ ⲚⲒⲘ ϨⲒⲖⲞϪⲖⲈϪ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲘⲘⲎⲎϢⲈ ⲀϤϢⲚϨⲦⲎϤ ϨⲀⲢⲞⲞⲨ ϪⲈ ⲚⲈⲨⲤⲔⲨⲖⲖⲈⲒ ⲠⲈ. ⲀⲨⲰ ⲚⲈⲨⲚⲎϪ ⲚⲐⲈ ⲚⲚⲒⲈⲤⲞⲞⲨ ⲈⲦⲈⲘⲚⲦⲞⲨϢⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲰϨⲤ ⲘⲈⲚ ⲚⲀϢⲰϤ. ⲚⲈⲢⲄⲀⲦⲎⲤ ⲆⲈ ⲤⲞⲂⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ⲤⲈⲠⲤⲠϪⲞⲈⲒⲤ ϬⲈ ⲘⲠⲰϨⲤ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲚⲈϪⲈⲢⲄⲀⲦⲎⲤ ⲈⲂⲞⲖ ⲈⲠⲈϤⲰϨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲠⲈϤⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ. ⲀϤϮ ⲚⲀⲨ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈⲚⲞⲨϪ ⲈⲂⲞⲖ ⲀⲨⲰ ⲈⲢⲠⲀϨⲢⲈ ⲈϢⲰⲚⲈ ⲚⲒⲘ ϨⲒⲖⲞϪⲖⲈϪ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ⲚⲀⲒ ⲆⲈ ⲚⲈ ⲚⲢⲀⲚ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲠϢⲞⲢⲠ ⲠⲈ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲀⲚⲆⲢⲈⲀⲤ ⲠⲈϤⲤⲞⲚ. ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲚ ⲂⲀⲢⲐⲞⲖⲞⲘⲀⲒⲞⲤ ⲐⲰⲘⲀⲤ ⲘⲚ ⲘⲀⲐⲐⲀⲒⲞⲤ ⲠⲦⲈⲖⲰⲚⲎⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲀⲖⲪⲀⲒⲞⲤ ⲘⲚ ⲐⲀⲆⲆⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ⲤⲒⲘⲰⲚ ⲠⲔⲀⲚⲀⲚⲒⲦⲎⲤ ⲘⲚ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ⲠⲈⲒⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤϪⲞⲞⲨⲤⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢⲂⲰⲔ ⲈϨⲒⲎ ⲚϨⲈⲐⲚⲞⲤ. ⲀⲨⲰ ⲘⲠⲢⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲞⲖⲒⲤ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ⲂⲰⲔ ⲆⲈ ⲚϨⲞⲨⲞ ϢⲀⲚⲈⲤⲞⲞⲨ ⲚⲦⲀⲨⲤⲰⲢⲘ ⲚⲦⲈⲠⲎⲒ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲆⲈ ⲦⲀϢⲈⲞⲈⲒϢ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲈⲦⲀⲚⲞⲒ. ⲀⲤϨⲰⲚ ⲄⲀⲢ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ⲚⲈⲦϢⲰⲚⲈ ⲀⲢⲒⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ ⲚⲈⲦⲤⲞⲂϨ ⲦⲂⲂⲞⲞⲨ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ⲀⲦⲈⲦⲚϪⲒ ⲚϪⲒⲚϪⲎ ϮⲚϪⲒⲚϪⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ⲘⲠⲢϪⲠⲞ ⲚⲎⲦⲚ ⲚⲞⲨⲚⲞⲨⲂ. ⲞⲨⲦⲈ ⲞⲨϨⲀⲦ. ⲞⲨⲆⲈ ϨⲞⲘⲚⲦ ϨⲚ ⲚⲈⲦⲚⲘⲞϪϨ. ");
INSERT INTO copshc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ⲞⲨⲦⲈ ⲠⲎⲢⲀ ⲈⲦⲈϨⲒⲎ ⲞⲨⲦⲈ ϢⲦⲎⲚ ⲤⲚⲦⲈ ⲞⲨⲦⲈ ⲞⲨⲦⲞⲞⲨⲈ ⲞⲨⲦⲈ ⲞⲨϬⲈⲢⲰⲂ ϤⲈⲘⲠϢⲀ ⲄⲀⲢ ⲚϬⲒ ⲠⲈⲢⲄⲀⲦⲎⲤ ⲚⲦⲈϤϨⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ⲦⲠⲞⲖⲒⲤ ⲆⲈ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ⲎⲠϮⲘⲈ. ϢⲒⲚⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲘⲠϢⲀ ⲚⲦⲈⲦⲚϬⲰ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϢⲀⲚⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ⲈⲦⲈⲦⲚⲂⲎⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲀⲤⲠⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲠⲎⲒ ⲘⲠϢⲀ ⲘⲀⲢⲈⲦⲈⲦⲚⲈⲒⲢⲎⲚⲎ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲈϢⲰⲠⲈ ⲆⲈ ⲚϤⲘⲠϢⲀ ⲀⲚ ⲘⲀⲢⲈⲦⲈⲦⲚⲈⲒⲢⲎⲚⲎ ⲔⲞⲦⲤ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ⲠⲈⲦⲈⲚϤⲚⲀϪⲒⲦⲎⲨⲦⲚ ⲆⲈ ⲀⲚ ⲀⲨⲰ ⲚϤⲦⲘⲤⲰⲦⲘ ⲈⲚⲈⲦⲚϢⲀϪⲈ ⲈⲦⲈⲦⲚⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲎⲒ ⲎⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ ⲎⲠϮⲘⲈ ⲚⲞⲨϨⲈ ⲈⲂⲞⲖ ⲘⲠϢⲞⲈⲒϢ ⲚⲚⲈⲦⲚⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲞⲨⲚⲞⲨⲘⲦⲞⲚ ⲚⲀϢⲰⲠⲈ ϨⲘ ⲠⲔⲀϨ ⲚⲤⲞⲆⲞⲘⲀ ⲘⲚ ⲄⲞⲘⲞⲢⲢⲀ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲨⲈⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮϪⲞⲞⲨ ⲘⲘⲰⲦⲚ ⲚⲐⲈ ⲚϨⲈⲚⲈⲤⲞⲞⲨ ϨⲚ ⲦⲘⲎⲦⲈ ⲚϨⲈⲚⲞⲨⲰⲚϢ. ϢⲰⲠⲈ ϬⲈ ⲚⲤⲀⲂⲈ ⲚⲐⲈ ⲚⲚϨⲞϤ ⲀⲨⲰ ⲚⲀⲔⲈⲢⲀⲒⲞⲤ ⲚⲐⲈ ⲚⲚⲒϬⲢⲞⲞⲘⲠⲈ . ");
INSERT INTO copshc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ϮϨⲦⲎⲦⲚ ⲆⲈ ⲈⲢⲰⲦⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲢⲰⲘⲈ. ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲄⲀⲢ ⲘⲘⲰⲦⲚ ⲈⲚⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲤⲈⲚⲀⲘⲀⲤⲦⲒⲄⲞⲨ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ⲚⲤⲈϪⲒⲦⲎⲨⲦⲚ ⲚⲚϨⲎⲄⲈⲘⲰⲚ ⲘⲚ ⲚⲢⲢⲰⲞⲨ ⲈⲦⲂⲎⲎⲦ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ ⲘⲚ ⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲨϢⲀⲚⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲰⲦⲚ ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ϪⲈ ⲚⲀϢ ⲚϨⲈ. ⲎⲈⲦⲈⲦⲚⲀϪⲞⲞⲤ ϪⲈ ⲞⲨ. ⲤⲈⲚⲀϮ ⲄⲀⲢ ⲚⲎⲦⲚ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲚⲀϪⲞⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ⲚⲦⲰⲦⲚ ⲄⲀⲢ ⲀⲚ ⲠⲈⲦϢⲀϪⲈ ⲀⲖⲖⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲠⲈⲦϢⲀϪⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ⲞⲨⲚⲞⲨⲤⲞⲚ ⲆⲈ ⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲠⲈϤⲤⲞⲚ ⲈⲠⲘⲞⲨ. ⲀⲨⲰ ⲞⲨⲈⲒⲰⲦ ⲘⲠⲈϤϢⲎⲢⲈ. ⲚⲦⲈⲚϢⲎⲢⲈ ⲦⲰⲞⲨⲚ ⲈϪⲚ ⲚⲈⲨⲈⲒⲞⲦⲈ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ⲚⲦⲈⲦⲚϢⲰⲠⲈ ⲈⲨⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲢⲰⲘⲈ ⲚⲒⲘ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ. ⲠⲈⲦⲚⲀϨⲨⲠⲞⲘⲈⲒⲚⲈ ⲆⲈ ϢⲀⲂⲞⲖ ⲠⲀⲒ ⲠⲈⲦⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲨϢⲀⲚⲠⲰⲦ ⲚⲤⲰⲦⲚ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ ⲠⲰⲦ ⲈϨⲢⲀⲒ ⲈⲔⲈⲞⲨⲈⲒ. ϨⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈⲦⲚϪⲰⲔ ⲈⲂⲞⲖ ⲚⲘⲠⲞⲖⲒⲤ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲘⲠⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ⲘⲚⲤⲂⲞⲨⲒ ⲄⲀⲢ ⲈϤⲞ ⲚⲚⲞϬ ⲈⲠⲈϤⲤⲀϨ. ⲞⲨⲦⲈ ⲘⲚ ϨⲘϨⲀⲖ ⲈϤϪⲞⲤⲈ ⲈϨⲞⲨⲈⲠⲈϤϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ϨⲰ ⲈⲠⲈⲤⲂⲞⲨⲒ ϪⲈ ⲈϤⲈϢⲰⲠⲈ ⲚⲐⲈ ⲘⲠⲈϤⲤⲀϨ. ⲀⲨⲰ ⲠϨⲘϨⲀⲖ ϪⲈ ⲈϤⲈϢⲰⲠⲈ ⲚⲐⲈ ⲘⲠⲈϤϪⲞⲈⲒⲤ. ⲈϢϪⲈ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲠϪⲞⲈⲒⲤ ϪⲈ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲞⲤⲞ ⲘⲀⲖⲖⲞⲚ ⲚⲈϤⲢⲘⲚⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ⲘⲠⲢⲢϨⲞⲦⲈ ϬⲈ ϨⲎⲦⲞⲨ. ⲘⲚ ⲖⲀⲀⲨ ⲄⲀⲢ ⲈϤϨⲞⲂⲤ ⲚⲤⲈⲚⲀϬⲞⲖⲠϤ ⲀⲚ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲈϤϨⲎⲠ ⲈⲚϤⲚⲀⲞⲨⲰⲚϨ ⲀⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲎⲦⲚ ϨⲘ ⲠⲔⲀⲔⲈ ⲀϪⲒϤ ϨⲘ ⲠⲞⲨⲞⲈⲒⲚ. ⲀⲨⲰ ⲠⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲦⲚⲘⲀⲀϪⲈ ⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ ϨⲒϪⲚ ⲚϪⲈⲚⲈⲠⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ⲘⲠⲢⲢϨⲞⲦⲈ ϨⲎⲦⲞⲨ ⲚⲚⲈⲦⲚⲀⲘⲞⲨⲞⲨⲦ ⲘⲠⲈⲦⲚⲤⲰⲘⲀ. ⲈⲘⲚϬⲞⲘ ⲆⲈ ⲘⲘⲞⲞⲨ ⲈⲘⲞⲨⲞⲨⲦ ⲚⲦⲈⲦⲚⲮⲨⲬⲎ. ⲀⲢⲒϨⲞⲦⲈ ⲆⲈ ⲚϨⲞⲨⲞ ϨⲎⲦϤ ⲘⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲦⲀⲔⲞ ⲚⲦⲈⲦⲚⲮⲨⲬⲎ ⲘⲚ ⲠⲈⲦⲚⲤⲰⲘⲀ ϨⲢⲀⲒ ϨⲚ ⲦⲄⲈϨⲈⲚⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ⲘⲎ ϪⲀϪ ⲤⲚⲀⲨ ⲚⲤⲈϮ ⲘⲘⲞⲞⲨ ⲀⲚ ⲈⲂⲞⲖ ϨⲀ ⲞⲨϨⲞⲂⲞⲖⲞⲤ. ⲀⲨⲰ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲚⲈϤϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ ⲀϪⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ⲚⲔⲈⲂⲰ ⲆⲈ ⲚⲦⲈⲦⲚⲀⲠⲈ ⲎⲠ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ⲘⲠⲢⲢϨⲞⲦⲈ ϬⲈ ϨⲎⲦⲞⲨ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚϢⲞⲂⲈ ⲈϨⲀϨ ⲚϪⲀϪ. ");
INSERT INTO copshc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ⲞⲨⲞⲚ ϬⲈ ⲚⲒⲘ ⲈⲦⲚⲀϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲚϨⲎⲦ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲢⲰⲘⲈ ϮⲚⲀϨⲞⲘⲞⲖⲞⲄⲈⲒ ϨⲰ ⲚϨⲎⲦϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ⲠⲈⲦⲚⲀⲀⲠⲀⲢⲚⲀ ⲆⲈ ⲘⲘⲞⲒ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲢⲰⲘⲈ. ϮⲚⲀⲀⲠⲀⲢⲚⲀ ϨⲰ ⲘⲘⲞϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ⲘⲠⲢⲰϢ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲈⲚⲞⲨϪⲈ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ. ⲚⲦⲀⲒⲈⲒ ⲀⲚ ⲈⲚⲞⲨϪⲈ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ. ⲀⲖⲖⲀ ⲈⲚⲞⲨϪⲈ ⲚⲞⲨⲤⲎϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ⲚⲦⲀⲒⲈⲒ ⲄⲀⲢ ⲈⲠⲰⲢϪ ⲚⲞⲨⲢⲰⲘⲈ ⲈⲠⲈϤⲈⲒⲰⲦ. ⲀⲨⲰ ⲞⲨϢⲈⲈⲢⲈ ⲈⲦⲈⲤⲘⲀⲀⲨ ⲀⲨⲰ ⲞⲨϢⲈⲖⲈⲈⲦ ⲈⲦⲈⲤϢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ⲚϪⲀϪⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲈ ⲚⲈϤⲢⲘⲚⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ⲠⲈⲦⲘⲈ ⲚⲈⲒⲰⲦ ⲎⲘⲀⲀⲨ ⲈϨⲞⲨⲈⲈⲢⲞⲒ ⲚϤⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ. ⲀⲨⲰ ⲠⲈⲦⲘⲈ ⲚϢⲎⲢⲈ ϨⲒϢⲈⲈⲢⲈ ⲈϨⲞⲨⲈⲈⲢⲞⲒ ⲚϤⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲚⲀϤⲒ ⲀⲚ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲚϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲚϤⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ⲠⲈⲚⲦⲀϤϨⲈ ⲈⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲤⲞⲢⲘⲈⲤ. ⲀⲨⲰ ⲠⲈⲚⲦⲀϤⲤⲰⲢⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲦⲂⲎⲎⲦ ϤⲚⲀϨⲈ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ⲠⲈⲦϢⲰⲠ ⲘⲘⲰⲦⲚ ⲈⲢⲞϤ ⲈϤϢⲰⲠ ⲘⲘⲞⲒ ⲈⲢⲞϤ. ⲀⲨⲰ ⲠⲈⲦϢⲰⲠ ⲘⲘⲞⲒ ⲈⲢⲞϤ ⲈϤϢⲰⲠ ⲈⲢⲞϤ ⲘⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ⲠⲈⲦϢⲰⲠ ⲈⲢⲞϤ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲠⲢⲀⲚ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ϤⲚⲀϪⲒ ⲘⲠⲂⲈⲔⲈ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ⲀⲨⲰ ⲠⲈⲦϢⲰⲠ ⲈⲢⲞϤ ⲚⲞⲨⲆⲒⲔⲀⲒⲞⲤ ⲈⲠⲢⲀⲚ ⲚⲞⲨⲆⲒⲔⲀⲒⲞⲤ ϤⲚⲀϪⲒ ⲘⲠⲂⲈⲔⲈ ⲘⲠⲆⲒⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲦⲤⲈⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ ⲚⲞⲨϪⲰ ⲘⲘⲞⲨ ⲚⲰⲢϢ ⲘⲘⲀⲦⲈ ⲈⲠⲢⲀⲚ ⲚⲞⲨⲘⲀⲐⲎⲦⲎⲤ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈϤⲤⲰⲢⲘ ⲘⲠⲈϤⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲰ ⲈϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲠⲈϤⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈϤϮⲤⲂⲰ ⲀⲨⲰ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲨⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ϨⲢⲀⲒ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ ⲈⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀϤϪⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦⲚⲎⲨ ϪⲈ ⲦⲀⲢⲈⲚϬⲰϢⲦ ϨⲎⲦϤ ⲚⲔⲈⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲚⲦⲈⲦⲚ ϪⲰ ⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲚⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲘⲚ ⲚⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ϪⲈ ⲚⲂⲖⲖⲈ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚϬⲀⲖⲈ ⲘⲞⲞϢⲈ ⲚⲈⲦⲤⲞⲂϨ ⲦⲂⲂⲞ ⲚⲀⲖ ⲤⲰⲦⲘ ⲚⲈⲘⲠⲞ ϢⲀϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲦⲰⲞⲨⲚ ⲚϨⲎⲔⲈ ⲤⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ⲀⲨⲰ ⲚⲀⲒⲀⲦϤ ⲘⲠⲈⲦⲈ ⲚϤⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲀⲚ ϨⲢⲀⲒ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ⲚⲦⲈⲢⲈⲚⲀⲒ ⲆⲈ ⲂⲰⲔ ⲀϤⲀⲢⲬⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϪⲞⲞⲤ ⲚⲘⲘⲎⲎϢⲈ ⲈⲦⲂⲈ ⲒⲰϨⲀⲚⲚⲎⲤ. ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲈⲢⲎⲘⲞⲤ ⲈⲚⲀⲨ ⲈⲞⲨ. ⲈⲨⲔⲀϢ ⲈⲢⲈⲠⲦⲎⲨ ⲔⲒⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ⲀⲖⲖⲀ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ. ⲈⲨⲢⲰⲘⲈ ⲈⲢⲈϨⲈⲚϨⲂⲤⲰ ⲈⲨϬⲎⲚ ⲦⲞ ϨⲒⲰⲰϤ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲚⲈⲦⲪⲞⲢⲈⲒ ⲚⲚϨⲂⲤⲰ ⲈⲨϬⲎⲚ ⲤⲈϨⲚⲚⲎⲒ ⲚⲚⲢⲢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ⲀⲖⲖⲀ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϨⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨϨⲞⲨⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ⲠⲀⲒ ⲄⲀⲢ ⲠⲈⲦⲤⲎϨ ⲈⲦⲂⲎⲎⲦϤ. ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮⲚⲀⲦⲚⲚⲞⲞⲨ ⲘⲠⲀⲀⲄⲄⲈⲖⲞⲤ ϨⲀⲦⲈⲔϨⲎ. ⲠⲀⲒ ⲈⲦⲚⲀⲤⲞϤⲦⲈ ⲚⲦⲈⲔϨⲒⲎ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲘⲠⲈϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲈϪⲠⲞ ⲚⲚⲈϨⲒⲞⲘⲈ ⲚϬⲒ ⲠⲈⲦⲞ ⲚⲚⲞϬ ⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ. ⲠⲔⲞⲨⲒ ⲆⲈ ⲈⲢⲞϤ ⲞⲨⲚⲞϬ ⲈⲢⲞϤ ⲠⲈ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ϪⲒⲚⲚⲈϨⲞⲞⲨ ⲆⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ϢⲀⲈϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲤⲈϪⲒ ⲘⲘⲞⲤ ⲚϬⲞⲚⲤ. ⲀⲨⲰ ⲚⲢⲈϤϪⲒⲚϬⲞⲚⲤ ⲦⲰⲢⲠ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲠⲚⲞⲘⲞⲤ ⲚⲦⲀⲨⲠⲢⲞⲪⲎⲦⲈⲨⲈ ϢⲀⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ⲀⲨⲰ ⲈϢϪⲈ ⲦⲈⲦⲚⲞⲨⲈϢϪⲒⲦϤ ⲚⲦⲞϤ ⲠⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ⲠⲈⲦⲈⲞⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ⲦⲈⲒⲄⲈⲚⲈⲀ ⲆⲈ ⲈⲒⲚⲀⲦⲚⲦⲰⲚⲤ ⲈⲚⲒⲘ. ⲈⲤⲦⲚⲦⲰⲚ ⲈϨⲈⲚϢⲎⲢⲈ ϢⲎⲘ ⲈⲨϨⲘⲞⲞⲤ ϨⲚ ⲚⲀⲄⲞⲢⲀ. ⲚⲀⲒ ⲈⲦⲘⲞⲨⲦⲈ ⲈⲚⲈⲨϢⲂⲈⲈⲢ ");
INSERT INTO copshc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲰ ⲈⲢⲰⲦⲚ ⲘⲠⲈⲦⲚϬⲞⲤϬⲤ. ⲀⲚⲦⲞⲈⲒⲦ ⲘⲠⲈⲦⲚⲚⲈϨⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ⲀϤⲈⲒ ⲄⲀⲢ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲞⲨⲆⲈ ⲚϤⲤⲰ ⲀⲚ. ⲠⲈϪⲀⲨ ϪⲈ ⲞⲨⲚⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲒⲰⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ⲀϤⲈⲒ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲞⲨⲰⲘ ⲀⲨⲰ ⲈϤⲤⲰ. ⲠⲈϪⲀⲨ ϪⲈ ⲈⲒⲤⲞⲨⲢⲰⲘⲈ ⲚⲢⲈϤⲞⲨⲰⲘ ⲀⲨⲰ ⲚⲢⲈϤⲤⲈⲎⲢⲠ ⲚϢⲂⲎⲢⲦⲈⲖⲰⲚⲎⲤ ϨⲒⲢⲈϤⲢⲚⲞⲂⲈ . ⲀⲨⲰ ⲀⲤⲦⲘⲀⲒⲞ ⲚϬⲒ ⲦⲤⲞⲪⲒⲀ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ⲦⲞⲦⲈ ⲀϤⲀⲢⲬⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲚⲞϬⲚⲈϬ ⲚⲘⲠⲞⲖⲒⲤ. ⲚⲀⲒ ⲚⲦⲀⲠⲈϨⲞⲨⲞ ⲚⲚⲈϤϬⲞⲘ ϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲘⲠⲞⲨⲘⲈⲦⲀⲚⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ϪⲈ ⲞⲨⲞⲒ ⲚⲎ ⲬⲞⲢⲀⲌⲈⲒⲚ. ⲞⲨⲞⲒ ⲚⲎ ⲂⲎⲆⲤⲀⲒⲆⲀ. ϪⲈ ⲈⲚⲈⲚⲦⲀⲚϬⲞⲘ ⲚⲦⲀⲨϢⲰⲠⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϢⲰⲠⲈ ϨⲚ ⲦⲨⲢⲞⲤ ⲘⲚ ⲤⲒⲆⲰⲚ ⲈϢϪⲈ ⲀⲨⲘⲈⲦⲀⲚⲞⲈⲒ ϨⲚ ⲞⲨϬⲞⲞⲨⲚⲈ ⲘⲚⲞⲨⲔⲢⲘⲈⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲞⲨⲚ ⲞⲨⲘⲦⲞⲚ ⲚⲀϢⲰⲠⲈ ⲚⲦⲨⲢⲞⲤ ⲘⲚ ⲤⲒⲆⲰⲚ ⲘⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲨⲈⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ⲚⲦⲞ ϨⲰⲰⲦⲈ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲘⲎ ⲦⲈⲚⲀϪⲒⲤⲈ ϢⲀ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ⲦⲈⲚⲀⲂⲰⲔ ⲈⲠⲈⲤⲎⲦ ϢⲀⲀⲘⲚⲦⲈ ϪⲈ ⲈⲚⲈⲚⲦⲀⲚϬⲞⲘ ⲚⲦⲀⲨϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲈ ϢⲰⲠⲈ ϨⲚ ⲤⲞⲆⲞⲘⲀ ⲘⲚ ⲄⲞⲘⲞⲢⲢⲀ ⲚⲈⲨⲚⲀϬⲰ ⲠⲈ ϢⲀⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲞⲨⲚⲞⲨⲘⲦⲞⲚ ⲚⲀϢⲰⲠⲈ ⲘⲠⲔⲀϨ ⲚⲤⲞⲆⲞⲘⲀ ⲘⲚ ⲄⲞⲘⲞⲢⲢⲀ ⲘⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲨⲈⲈⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ϨⲘⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲈⲜⲞⲘⲞⲖⲞⲄⲈⲒ ⲚⲀⲔ ⲠⲀⲈⲒⲰⲦ ⲠϪⲞⲈⲒⲤ ⲚⲦⲠⲈ ⲘⲚ ⲠⲔⲀϨ. ϪⲈ ⲚⲀⲒ ⲀⲔϨⲞⲠⲞⲨ ⲈⲚⲤⲞⲪⲞⲤ ⲘⲚ ⲚⲤⲀⲂⲈⲈⲨ ⲀⲔϬⲞⲖⲠⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲚϢⲎⲢⲈ ϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ⲀϨⲈ ⲠⲀⲈⲒⲰⲦ ϪⲈ ⲚⲦⲀⲤⲢⲀⲚⲀⲔ ⲚⲦⲈⲒϨⲈ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ⲀⲨϮ ⲚⲀⲒ ⲘⲠⲦⲎⲢϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲘⲠⲀⲈⲒⲰⲦ ⲀⲨⲰ ⲘⲚ ⲖⲀⲀⲨ ⲤⲞⲞⲨⲚ ⲘⲠϢⲎⲢⲈ ⲈⲒ ⲘⲎⲦⲒ ⲠⲈⲒⲰⲦ ⲞⲨⲆⲈ ⲘⲚ ⲖⲀⲀⲨ ⲤⲞⲞⲨⲚ ⲘⲠⲈⲒⲰⲦ ⲈⲒⲘⲎⲦⲒ ⲠϢⲎⲢⲈ ⲘⲚ ⲠⲈⲦⲈⲢⲈⲠϢⲎⲢⲈ ⲚⲀⲞⲨⲰϢ ⲈⲞⲨⲰϢ ⲈⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ⲀⲘⲎⲒⲦⲚ ϢⲀⲢⲞⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϨⲞⲤⲈ ⲀⲨⲰ ⲈⲦⲞⲦⲠ. ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀϮⲘⲦⲞⲚ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ϤⲒ ⲘⲠⲀⲚⲀϨⲂ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲎⲨⲦⲚ. ⲚⲦⲈⲦⲚ ⲈⲒⲘⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦ ϪⲈ ⲀⲚⲄⲞⲨⲢⲘⲢⲀϢ ⲀⲨⲰ ϮⲐⲂⲂⲒⲎⲨ ϨⲘ ⲠⲀϨⲎⲦ. ⲦⲀⲢⲈⲦⲈⲦⲚϨⲈ ⲈⲨⲘⲦⲞⲚ ⲚⲚⲈⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ⲠⲀⲚⲀϨⲂ ⲄⲀⲢ ⲚⲀϨⲖⲰϬϤ ⲀⲨⲰ ⲤⲀⲤⲰⲞⲨ ⲚϬⲒ ⲦⲀⲈⲦⲠⲰ. ");
INSERT INTO copshc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ϨⲘ ⲠⲈⲞⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲒⲦⲚ ⲘⲘⲀ ⲈⲦϪⲎⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϨⲔⲞ ⲀⲨⲀⲢⲬⲈⲒ ⲚⲦⲰⲖⲔ ⲚⲚϨⲘⲤ ⲈⲨⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲤⲈⲈⲒⲢⲈ ⲘⲠⲈⲦⲈⲘⲈϢϢⲈ ⲈⲀⲀϤ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲘⲠⲈⲦⲚⲞϢϤ ϪⲈ ⲚⲦⲀⲆⲀⲨⲈⲒⲆ ⲢⲞⲨ ⲚⲦⲈⲢⲈϤϨⲔⲞ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ⲚⲐⲈ ⲚⲦⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤⲞⲨⲰⲘ ⲚⲚⲞⲈⲒⲔ ⲚⲦⲈⲠⲢⲞⲐⲈⲤⲒⲤ. ⲚⲀⲒ ⲈⲦⲈⲘⲈϢϢⲈ ⲈⲢⲞϤ ⲈⲞⲨⲞⲘⲞⲨ ⲞⲨⲆⲈ ⲚⲈⲦⲚⲘⲘⲀϤ. ⲈⲒⲘⲎⲦⲒ ⲚⲞⲨⲎⲎⲂ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ⲎⲘⲠⲈⲦⲚⲞϢϤ ϨⲢⲀⲒ ϨⲘ ⲠⲚⲞⲘⲞⲤ ϪⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲞⲨⲎⲎⲂ ⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲢⲀⲒ ϨⲘ ⲠⲢⲠⲈ ⲀⲨⲰ ⲘⲚ ⲚⲞⲂⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲠⲈⲦⲞ ⲚⲚⲞϬ ⲈⲠⲢⲠⲈ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ⲈⲚⲈⲚⲦⲀⲦⲈⲦⲚⲈⲒⲘⲈ ⲆⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲒⲞⲨⲈϢⲞⲨⲚⲀ ⲈϨⲞⲨⲈⲞⲨⲐⲨⲤⲒⲀ. ⲚⲈⲦⲈⲦⲚⲀⲦϬⲀⲒⲞ ⲀⲚ ⲠⲈ ⲚⲚⲈⲦⲈⲘⲚⲚⲞⲂⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ⲠϪⲞⲈⲒⲤ ⲄⲀⲢ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ⲀϤⲠⲰⲰⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲢⲰⲘⲈ ⲈⲢⲈⲦⲈϤϬⲒϪ ϢⲞⲨⲰⲞⲨ ⲀⲨϪⲚⲞⲨϤ ⲈⲦⲂⲎⲎⲦϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈⲈⲜⲈⲤⲦⲈⲒ ⲈⲢⲠⲀϨⲢⲈ ⲈⲢⲞϤ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲔⲀⲦⲞⲒⲄⲞⲢⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲠⲈⲦⲚⲀⲔⲰ ⲚⲀϤ ⲚⲞⲨⲈⲤⲞⲞⲨ ⲚⲞⲨⲰⲦ ⲚⲦⲈⲠⲀⲒ ϨⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲨϨⲒⲈⲒⲦ ⲘⲎ ⲚϤⲚⲀⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲚ ⲚϤⲦⲞⲨⲚⲞⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ⲠⲢⲰⲘⲈ ϬⲈ ϢⲞⲂⲈ ⲚⲞⲨⲎⲢ ⲈⲠⲈⲤⲞⲞⲨ. ϨⲰⲤⲦⲈ ⲈⲜⲈⲤⲦⲈⲒ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲘⲠⲢⲰⲘⲈ ϪⲈ ⲤⲞⲞⲨⲦⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲔϬⲒϪ ⲚⲦⲞϤ ⲆⲈ ⲀϤⲤⲞⲨⲦⲰⲚⲤ ⲀⲤϢⲰⲠⲈ ⲈⲤⲞⲨⲞϪ ⲚⲐⲈ ⲚⲦⲔⲈⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲀⲨϪⲒϢⲞϪⲚⲈ ⲈⲢⲞϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲞⲨⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ. ⲀⲨⲰ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲨⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲠⲀϢⲎⲢⲈ ⲚⲦⲀⲒⲞⲨⲀϢϤ ⲠⲀⲘⲈⲢⲒⲦ ⲠⲈⲚⲦⲀⲦⲀⲮⲨⲬⲎ ⲞⲨⲰϢ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ϮⲚⲀⲔⲰ ⲘⲠⲀⲠⲚⲈⲨⲘⲀ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲚϤⲔⲰ ⲚⲞⲨⲔⲢⲒⲤⲒⲤ ⲚⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ⲚϤⲚⲀϮⲦⲰⲚ ⲀⲚ. ⲞⲨⲆⲈ ⲚϤⲚⲀⲰϢ ⲈⲂⲞⲖ ⲀⲚ. ⲘⲚ ⲖⲀⲀⲨ ⲚⲀⲤⲰⲦⲘ ⲈⲦⲈϤⲤⲘⲎ ϨⲚ ⲚⲈⲠⲖⲀⲦⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ⲞⲨⲔⲀϢ ⲈϤⲞⲨⲞϢϤ ⲚϤⲚⲀⲞⲨⲞϬⲠϤ ⲀⲚ. ⲀⲨⲰ ⲞⲨⲤⲞⲖ ⲈϤϨⲦⲘⲦⲰⲘ ⲚϤⲚⲀϪⲈⲚⲀϤ ⲀⲚ. ϢⲀⲚⲦⲈϤⲈⲒⲚⲈ ⲈⲂⲞⲖ ⲘⲠⲈϤϨⲀⲠ ϨⲚ ⲞⲨⲦⲀϪⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ⲚⲦⲈⲚϨⲈⲐⲚⲞⲤ ϨⲈⲖⲠⲒⲌⲈ ⲈⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ⲦⲞⲦⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲂⲖⲖⲈ ⲚⲘⲠⲞ ⲈⲢⲈⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲒⲰⲰϤ. ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞϤ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲠⲈⲘⲠⲞ ϢⲀϪⲈ ⲚϤⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ⲀⲨⲢϢⲠⲎⲢⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲦⲎⲢⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎⲦⲒ ⲠⲀⲒ ⲠⲈ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲠⲈϪⲀⲨ. ϪⲈ ⲚⲈⲢⲈⲠⲀⲒ ⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ⲀⲚ. ⲈⲒⲘⲎⲦⲒ ϨⲢⲀⲒ ϨⲚ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲀⲢⲬⲰⲚ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ⲈϤⲤⲞⲞⲨⲚ ⲆⲈ ⲚⲚⲈⲨⲘⲈⲈⲨⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲘⲚ ⲦⲈⲢⲞ ⲚⲒⲘ ⲈⲤϢⲀⲚⲠⲰϢ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ϢⲀⲤⲢϪⲀⲒⲈ. ⲀⲨⲰ ⲠⲞⲖⲒⲤ ⲚⲒⲘ ϨⲒⲎⲒ ⲚⲒⲘ ⲈϤϢⲀⲚⲠⲰϢ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲘⲈϤⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ⲈϢϪⲈ ⲠⲔⲈⲤⲀⲦⲀⲚⲀⲤ ⲈϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲒⲈ ⲀϤⲠⲰϢ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲚⲀϢ ϬⲈ ⲚϨⲈ ⲦⲈϤⲘⲚⲦⲢⲢⲞ ⲚⲀⲀϨⲈⲢⲀⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ⲀⲨⲰ ⲈϢϪⲈ ⲀⲚⲞⲔ ⲈⲒⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲚ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ ⲈⲈⲒⲈⲚⲈⲦⲚϢⲎⲢⲈ ⲈⲨⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲘ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲤⲈⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲚⲢⲈϤϮϨⲀⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ⲈϢϪⲈ ⲀⲚⲞⲔ ⲆⲈ ⲈⲒⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲒⲈ ⲀⲤⲠⲰϨ ⲈϨⲢⲀⲒ ⲈϪⲰⲦⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ⲎⲚⲒⲘ ⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠϪⲰⲰⲢⲈ ⲈⲦⲰⲢⲠ ⲚⲚⲈϤϨⲚⲀⲀⲨ ⲈⲒⲘⲎⲦⲒ ⲚϢⲞⲢⲠ ⲚϤⲘⲞⲨⲢ ⲘⲠϪⲰⲰⲢⲈ. ⲦⲞⲦⲈ ⲚϤⲦⲰⲢⲠ ⲘⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ⲠⲈⲦⲈⲚϤϢⲞⲞⲠ ⲚⲘⲘⲀⲒ ⲀⲚ ⲈϤϮ ⲞⲨⲂⲎⲒ. ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲤⲨⲚⲀⲄⲈ ⲚⲘⲘⲀⲒ ⲀⲚ ⲈϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ⲈⲦⲂⲈ ⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲞⲂⲈ ⲚⲒⲘ ϨⲒⲞⲨⲀ ⲚⲒⲘ ⲤⲈⲚⲀⲔⲀⲀⲨ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲚⲢⲰⲘⲈ. ⲠϪⲒⲞⲨⲀ ⲆⲈ ⲚⲦⲞϤ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲤⲈⲚⲀⲔⲀⲀϤ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ⲀⲨⲰ ⲠⲈⲦⲚⲀϪⲰ ⲚⲞⲨϢⲀϪⲈ ⲈϨⲞⲨⲚ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲔⲀⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ ⲠⲈⲦⲚⲀϪⲰ ⲆⲈ ⲚⲞⲨϢⲀϪⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲤⲈⲚⲀⲔⲀⲀⲤ ⲚⲀϤ ⲈⲂⲞⲖ ⲀⲚ ⲞⲨⲆⲈ ϨⲘ ⲠⲈⲒⲀⲒⲰⲚ ⲞⲨⲆⲈ ϨⲘ ⲠⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ⲎⲚⲦⲈⲦⲚ ⲈⲒⲢⲈ ⲘⲠϢⲎⲚ ⲈⲦⲚⲀⲚⲞⲨϤ ⲘⲚ ⲠⲈϤⲔⲀⲢⲠⲞⲤ ⲈⲦⲚⲀⲚⲞⲨϤ. ⲎⲚⲦⲈⲦⲚ ⲈⲒⲢⲈ ⲘⲠϢⲎⲚ ⲈⲐⲞⲞⲨ ⲘⲚ ⲠⲈϤⲔⲀⲢⲠⲞⲤ ⲈⲐⲞⲞⲨ. ⲈⲂⲞⲖ ⲄⲀⲢ ϨⲘ ⲠⲔⲀⲢⲠⲞⲤ ⲚϢⲀⲨⲤⲞⲨⲚⲠϢⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ⲚⲈϪⲠⲞ ⲚⲚⲈϨⲂⲞⲨⲒ. ⲚⲀϢ ⲚϨⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈϪⲈⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲀ ⲘⲠⲈⲐⲞⲞⲨ. ⲈⲂⲞⲖ ⲄⲀⲢ ϨⲘ ⲠⲈϨⲞⲨⲞ ⲘⲠϨⲎⲦ ⲈⲢⲈⲦⲦⲀⲠⲢⲞ ϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ⲠⲢⲰⲘⲈ ⲚⲀⲄⲀⲐⲞⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲀϨⲞ ⲈⲦⲚⲀⲚⲞⲨϤ ⲚϢⲀϤⲦⲀⲨⲞ ⲈⲂⲞⲖ ⲘⲠⲠⲈⲦⲚⲀⲚⲞⲨϤ. ⲀⲨⲰ ⲠⲢⲰⲘⲈ ⲘⲠⲞⲚⲎⲢⲞⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲀϨⲞ ⲈⲐⲞⲞⲨ ⲚϢⲀϤⲦⲀⲨⲞ ⲈⲂⲞⲖ ⲚⲘⲠⲈⲐⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϢⲀϪⲈ ⲚⲒⲘ ⲚⲀⲢⲄⲞⲚ ⲈⲦⲈⲢⲈ ⲚⲢⲰⲘⲈ ⲚⲀϪⲞⲞⲨ ⲤⲈⲚⲀϮⲖⲞⲄⲞⲤ ϨⲀⲢⲞⲞⲨ ⲘⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ⲈⲂⲞⲖ ⲄⲀⲢ ϨⲚ ⲚⲈⲔϢⲀϪⲈ ⲈⲨⲚⲀⲦⲘⲀⲒⲞⲔ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲔϢⲀϪⲈ ⲈⲨⲚⲀⲦϬⲀⲒⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ⲦⲞⲦⲈ ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲦⲚⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲨⲘⲀⲈⲒⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲄⲈⲚⲈⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲀⲨⲰ ⲚⲚⲞⲈⲒⲔ ⲤϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ ⲀⲨⲰ ⲚⲚⲈⲨϮⲘⲀⲈⲒⲚ ⲚⲀⲤ ⲈⲒⲘⲎⲦⲒ ⲠⲘⲀⲈⲒⲚ ⲚⲒⲰⲚⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ⲚⲐⲈ ⲄⲀⲢ ⲈⲚⲈⲢⲈⲒⲰⲚⲀⲤ ϢⲞⲞⲠ ⲚϨⲎⲦϤ ⲘⲠⲔⲎⲦⲞⲤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲘⲚ ϢⲞⲘⲦⲈ ⲚⲞⲨϢⲎ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀϢⲰⲠⲈ ⲘⲘⲞⲤ ϨⲘ ⲠϨⲎⲦ ⲘⲠⲔⲀϨ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲘⲚ ϢⲞⲘⲦⲈ ⲚⲞⲨϢⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ⲚⲢⲰⲘⲈ ⲚⲚⲒⲚⲈⲨⲎ ⲚⲀⲦⲰⲞⲨⲚ ϨⲚ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲘⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲚⲤⲈⲦϬⲀⲒⲞⲤ ϪⲈ ⲀⲨⲘⲈⲦⲀⲚⲞⲒ ⲈⲠⲦⲀϢⲈⲞⲈⲒϢ ⲚⲒⲰⲚⲀⲤ. ⲀⲨⲰ ⲈⲒⲤⲠⲈϨⲞⲨⲞ ⲈⲒⲰⲚⲀⲤ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ⲦⲢⲦⲢⲰ ⲘⲠⲢⲎⲤ ⲚⲀⲦⲰⲞⲨⲚ ϨⲚ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲘⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲚⲤⲦϬⲀⲒⲞⲤ ϪⲈ ⲀⲤⲈⲒ ϪⲒⲚⲈⲀⲢⲎϪϤ ⲘⲠⲔⲀϨ ⲈⲤⲰⲦⲘ ⲈⲦⲤⲞⲪⲒⲀ ⲚⲤⲞⲖⲞⲘⲰⲚ ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲠⲈϨⲞⲨⲞ ⲈⲤⲞⲖⲞⲘⲰⲚ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ϨⲞⲦⲀⲚ ⲆⲈ ⲠⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤϢⲀⲚⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲰⲘⲈ. ϢⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ϨⲈⲚⲘⲀ ⲈⲘⲚⲘⲞⲞⲨ ⲚϨⲎⲦⲞⲨ ⲈϤϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀ ⲚⲘⲦⲞⲚ. ⲀⲨⲰ ⲘⲈϤϨⲈ ⲈⲞⲨⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ⲦⲞⲦⲈ ϢⲀϤϪⲞⲞⲤ ϪⲈ ϮⲚⲀⲔⲦⲞⲒ ⲈⲠⲀⲎⲒ ⲠⲘⲀ ⲚⲦⲀⲒⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲈϤϢⲀⲚⲈⲒ ⲚϤϨⲈ ⲈⲢⲞϤ ⲈϤⲤⲀϨⲢ ⲀⲨⲰ ⲈϤⲦⲤⲀⲚⲎⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ⲦⲞⲦⲈ ϢⲀϤⲂⲰⲔ ⲚϤϪⲒ ⲚⲘⲘⲀϤ ⲚⲔⲈⲤⲀϢϤ ⲘⲠⲚⲈⲨⲘⲀ ⲈⲨϨⲞⲞⲨ ⲈⲢⲞϤ ⲚⲤⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲤⲈⲞⲨⲰϨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲐⲀⲎ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ϢⲰⲠⲈ ⲈⲤϨⲞⲞⲨ ⲈⲦⲈϤϨⲞⲨⲈⲒⲦⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ⲈⲦⲒ ⲆⲈ ⲈϤϢⲀϪⲈ ⲘⲚ ⲘⲘⲎⲎϢⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲦⲈϤⲘⲀⲀⲨ ⲘⲚ ⲚⲈϤⲤⲚⲎⲨ ⲚⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲠⲈ ϨⲒⲠⲤⲀⲘⲂⲞⲖ ⲈⲨϢⲒⲚⲈ ⲚⲤⲀϢⲀϪⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","— ");
INSERT INTO copshc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲘⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲚⲒⲘ ⲦⲈ ⲦⲀⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲒⲘ ⲚⲈ ⲚⲀⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ⲀϤⲤⲞⲨⲦⲚⲦⲈϤϬⲒϪ ⲈⲂⲞⲖ ⲈϪⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲦⲀⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲀⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ⲠⲈⲒⲦⲈⲒⲢⲈ ⲄⲀⲢ ⲘⲠⲞⲨⲰϢ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲞⲚ ⲀⲨⲰ ⲦⲀⲤⲰⲚⲈ ⲀⲨⲰ ⲦⲀⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲘ ⲠⲎⲒ ⲀϤϨⲘⲞⲞⲤ ϨⲀⲦⲚⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ⲀⲨⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈϤⲀⲖⲈ ⲈⲠϪⲞⲒ ⲚϤϨⲘⲞⲞⲤ. ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲦⲎⲢϤ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ⲠⲈ ϨⲒⲠⲈⲔⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϨⲘ ⲠϢⲀϪⲈ ϨⲒⲦⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦϪⲞ ⲈϪⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲞ. ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲀⲨϨⲈ ϨⲀⲦⲚⲦⲈϨⲒⲎ. ⲀⲨⲈⲒ ⲚϬⲒ ⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ⲀⲨⲞⲨⲞⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲘⲘⲀ ⲘⲠⲈⲦⲢⲀ. ⲠⲘⲀ ⲈⲦⲈⲘⲚⲔⲀϨ ⲈⲚⲀϢⲰϤ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨϮⲞⲨⲰ ϪⲈ ⲘⲚ ϨⲀϨ ⲚⲔⲀϨ ϨⲀⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ⲠⲢⲎ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲀ ⲀⲨⲢⲔⲀⲨⲘⲀ. ⲀⲨⲰ ⲈⲂⲞⲖ ϪⲈ ⲘⲚ ⲚⲞⲨⲚⲈ ⲘⲘⲞⲞⲨ ⲀⲨϢⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚϢⲞⲚⲦⲈ. ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲚϬⲒ ⲚϢⲞⲚⲦⲈ ⲀⲨⲞϬⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨϮⲔⲀⲢⲠⲞⲤ ⲞⲨⲀ ⲘⲈⲚ ⲀϤϮϢⲈ ⲞⲨⲀ ⲆⲈ ⲀϤϮⲤⲈ ⲔⲈⲦ ⲆⲈ ⲀϤϮⲘⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ⲠⲈⲦⲈⲞⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲔϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲎⲦⲚ ⲈⲈⲒⲘⲈ ⲈⲘⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ⲚⲎ ⲆⲈ ⲘⲠⲞⲨⲦⲀⲀⲤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ⲄⲀⲢ ⲤⲈⲚⲀϮ ⲚⲀϤ ⲚϤⲢϨⲞⲨⲞ. ⲀⲨⲰ ⲠⲈⲦⲈⲘⲚⲦⲀϤ ⲠⲔⲈⲦⲈⲨⲚⲦⲀϤ ⲤⲈⲚⲀϤⲒⲦϤ ⲚⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲒϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲈⲨⲈⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲤⲈⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲚ ⲀⲨⲰ ⲈⲨⲈⲤⲰⲦⲘ ⲚⲤⲈⲤⲰⲦⲘ ⲀⲚ ⲞⲨⲦⲈ ⲚⲤⲈⲚⲞⲈⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ⲤⲚⲀϪⲰⲔ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚϬⲒ ⲦⲈⲠⲢⲞⲪⲎⲦⲒⲀ ⲚⲎⲤⲀⲒⲀⲤ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲚ ⲞⲨⲤⲰⲦⲘ ⲦⲈⲦⲚⲚⲀⲤⲰⲦⲘ ⲚⲦⲈⲦⲚ ⲦⲘⲚⲞⲒ. ⲀⲨⲰ ϨⲚ ⲞⲨⲚⲀⲨ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲚⲦⲈⲦⲚ ⲦⲘⲈⲒⲰⲢϨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ⲀϤⲚϢⲞⲦ ⲄⲀⲢ ⲚϬⲒ ⲠϨⲎⲦ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲀⲨⲰ ⲀⲨⲤⲰⲦⲘ ϨⲚ ⲚⲈⲨⲘⲀⲀϪⲈ ϨⲚ ⲞⲨϨⲢⲞϢ ⲀⲨⲰ ⲀⲨϢⲦⲀⲘ ⲚⲚⲈⲨⲂⲀⲖ ϪⲈ ⲚⲚⲈⲨⲚⲀⲨ ϨⲚ ⲚⲈⲨⲂⲀⲖ ⲚⲤⲈⲤⲰⲦⲘ ϨⲘ ⲚⲈⲨⲘⲀⲀϪⲈ ⲚⲤⲈⲚⲞⲒ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲦⲀⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲚⲂⲀⲖ ϪⲈ ⲤⲈⲚⲀⲨ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲚⲈⲦⲚⲘⲀⲀϪⲈ ϪⲈ ⲤⲈⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ϨⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲀϨⲀϨ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲒⲆⲒⲔⲀⲒⲞⲤ ⲈⲠⲈⲒⲐⲨⲘⲈⲒ ⲈⲚⲀⲨ ⲈⲚⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲘⲠⲞⲨⲚⲀⲨ. ⲀⲨⲰ ⲈⲤⲰⲦⲘ ⲈⲢⲞⲒ ⲈⲚⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲘⲠⲞⲨⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ⲚⲦⲰⲦⲚ ⲆⲈ ⲤⲰⲦⲘ ⲈⲦⲠⲀⲢⲀⲂⲞⲖⲎ ⲘⲠⲈⲦϪⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲈⲚϤⲚⲞⲒ ⲘⲘⲞϤ ⲀⲚ ϢⲀϤⲈⲒ ⲚϬⲒ ⲠⲠⲞⲚⲎⲢⲞⲤ ⲚϤⲦⲰⲢⲠ ⲘⲠⲈⲚⲦⲀⲨϪⲞϤ ϨⲢⲀⲒ ϨⲘ ⲠⲈϤϨⲎⲦ. ⲠⲀⲒ ⲠⲈⲚⲦⲀⲨϪⲞϤ ϨⲀⲦⲚⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ⲠⲈⲚⲦⲀⲨϪⲞϤ ⲆⲈ ⲈϪⲚ ⲘⲘⲀ ⲘⲠⲈⲦⲢⲀ. ⲠⲀⲒ ⲠⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲈⲦϪⲒ ⲘⲘⲞϤ ⲚⲦⲈⲨⲚⲞⲨ ϨⲚ ⲞⲨⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ⲘⲚ ⲚⲞⲨⲚⲈ ⲆⲈ ϢⲞⲞⲠ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲀⲖⲖⲀ ⲞⲨⲠⲢⲞⲤⲞⲨⲞⲈⲒϢ ⲠⲈ ⲈⲢϢⲀⲚⲞⲨⲐⲖⲒⲮⲒⲤ ⲆⲈ ϢⲰⲠⲈ ⲎⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈⲦⲂⲈ ⲠϢⲀϪⲈ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀϤⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ⲠⲈⲚⲦⲀⲨϪⲞϤ ⲆⲈ ⲈϪⲚ ⲚϢⲞⲚⲦⲈ. ⲠⲀⲒ ⲠⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ. ⲈⲢⲈⲠⲢⲞⲞⲨϢ ⲘⲠⲈⲒⲀⲒⲰⲚ ⲘⲚ ⲦⲀⲠⲀⲦⲎ ⲚⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲰϬⲦ ⲘⲠϢⲀϪⲈ ⲈϤϢⲰⲠⲈ ⲀϪⲚⲔⲀⲢⲠⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ⲠⲈⲚⲦⲀⲨϪⲞϤ ⲆⲈ ⲈϪⲘ ⲠⲔⲀϨ ⲈⲦⲚⲀⲚⲞⲨϤ ⲠⲀⲒ ⲠⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲈⲦⲚⲞⲒ ⲘⲘⲞϤ ⲈϤϮⲔⲀⲢⲠⲞⲤ ⲞⲨⲀ ⲘⲈⲚ ⲈϤⲈⲒⲢⲈ ⲚϢⲈ ⲔⲈⲦ ⲆⲈ ⲚⲤⲈ ⲔⲈⲞⲨⲀ ⲆⲈ ⲘⲘⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ⲀϤⲔⲰ ⲚⲀⲨ ⲈϨⲢⲀⲒ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲈⲀϤϪⲞ ⲚⲞⲨϬⲢⲞϬ ⲈⲚⲀⲚⲞⲨϤ ϨⲢⲀⲒ ϨⲚ ⲦⲈϤⲤⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ϨⲘ ⲠⲦⲢⲈⲨⲚⲔⲞⲦⲔ ⲆⲈ ⲚϬⲒ ⲚⲢⲰⲘⲈ. ⲀϤⲈⲒ ⲚϬⲒ ⲠⲈϤϪⲀϪⲈ ⲀϤϪⲞ ⲚϨⲈⲚⲈⲚⲦⲎϬ ⲚⲦⲘⲎⲦⲈ ⲘⲠⲤⲞⲨⲞ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ⲚⲦⲈⲢⲈϤϮⲞⲨⲰ ⲆⲈ ⲚϬⲒ ⲠⲈⲬⲞⲢⲦⲞⲤ ⲀⲨⲰ ⲀϤⲈⲒⲢⲈ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ. ⲦⲞⲦⲈ ⲀⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲚⲦⲎϬ. ");
INSERT INTO copshc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲚϬⲒ ⲚϨⲘϨⲀⲖ ⲈⲠⲈⲨϪⲞⲈⲒⲤ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲎ ⲚⲞⲨϬⲢⲞϬ ⲈⲚⲀⲚⲞⲨϤ ⲀⲚ ⲠⲈⲚⲦⲀⲔϪⲞϤ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲔⲤⲰϢⲈ. ⲚⲦⲀϤϨⲈ ϬⲈ ⲈⲈⲚⲦⲎϬ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨϪⲀϪⲈ ⲚⲢⲰⲘⲈ ⲠⲈⲚⲦⲀϤⲈⲒⲢⲈ ⲘⲠⲀⲒ ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲔⲞⲨⲰϢ ϬⲈ ⲈⲦⲢⲈⲚⲂⲰⲔ ⲚⲦⲚⲤⲞⲞⲨϨⲞⲨ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲘⲞⲚ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲦⲚ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲦⲎϬ ⲚⲦⲈⲦⲚ ⲠⲰⲢⲔ ⲚⲘⲘⲀⲨ ⲘⲠⲔⲈⲤⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ⲀⲖⲰⲦⲚ ϨⲀⲢⲞⲞⲨ ⲚⲤⲈⲀⲒⲀⲒ ϨⲒⲞⲨⲤⲞⲠ ϢⲀⲠⲈⲨⲞⲈⲒϢ ⲘⲠⲰϨⲤ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲨⲞⲈⲒϢ ⲘⲠⲰϨⲤ ϮⲚⲀϪⲞⲞⲤ ⲚⲚⲀϪⲀⲒⲞϨⲤ ϪⲈ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚϢⲞⲢⲠ ⲚⲚⲈⲚⲦⲎϬ ⲚⲦⲈⲦⲚ ⲘⲞⲢⲞⲨ ⲚϨⲚϢⲞⲖ ⲈⲠⲢⲞⲔϨⲞⲨ ⲠⲈⲤⲞⲨⲞ ⲆⲈ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨϨϤ ⲈϨⲞⲨⲚ ⲈⲦⲀⲀⲠⲞⲐⲎⲔⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ⲀϤⲔⲰ ⲚⲀⲨ ⲞⲚ ⲈϨⲢⲀⲒ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲂⲖⲂⲒⲖⲈ ⲚϢⲖⲦⲎⲘ. ⲦⲀⲒ ⲈⲀⲨⲢⲰⲘⲈ ϪⲒⲦⲤ ⲀϤϪⲞ ⲘⲘⲞⲤ ϨⲢⲀⲒ ϨⲚ ⲦⲈϤⲤⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ⲦⲀⲒ ⲘⲈⲚ ⲈⲨⲔⲞⲨⲒ ⲦⲈ ⲈⲚⲈϬⲢⲞⲞϬ ⲦⲎⲢⲞⲨ ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲤϢⲀⲚⲀⲨⲜⲀⲚⲈ ϢⲀⲤⲢⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲞⲦⲈ ⲚⲤϢⲰⲠⲈ ⲈⲨⲚⲞϬ ⲚϢⲎⲚ ϨⲰⲤⲦⲈ ⲚⲤⲈⲈⲒ ⲚϬⲒ ⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ⲚⲤⲈⲞⲨⲰϨ ϨⲚ ⲚⲈⲤⲔⲖⲀⲆⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ⲀϤϪⲰ ⲚⲀⲨ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲐⲀⲂ ⲈⲀⲨⲤϨⲒⲘⲈ ϪⲒⲦϤ ⲀⲤϨⲞⲠϤ ϨⲚ ϢⲞⲘⲚⲦ ⲚϢⲒ ⲚⲚⲞⲈⲒⲦ ϢⲀⲚⲦⲈϤϪⲒⲐⲀⲂ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲘⲘⲎⲎϢⲈ. ⲀⲨⲰ ⲀϪⲘⲠⲀⲢⲀⲂⲞⲖⲎ ⲘⲠⲈϤϪⲈⲖⲀⲀⲨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲚⲀⲞⲨⲰⲚ ⲈⲢⲰⲒ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲦⲀϪⲰ ⲚⲚⲈⲦϨⲎⲠ ϪⲒⲚⲈⲠϢⲀⲤⲰⲚⲦ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ⲦⲞⲦⲈ ⲀϤⲔⲰ ⲚⲘⲘⲎⲎϢⲈ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲰⲖ ⲈⲢⲞⲚ ⲚⲦⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲚⲈⲚⲦⲎϬ ⲚⲦⲤⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦϪⲞ ⲘⲠⲈϬⲢⲞϬ ⲈⲦⲚⲀⲚⲞⲨϤ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ⲦⲤⲰϢⲈ ⲆⲈ ⲠⲈ ⲠⲔⲞⲤⲘⲞⲤ. ⲠⲈϬⲢⲞϬ ⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲈ ⲚϢⲎⲢⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ. ⲚⲈⲚⲦⲎϬ ⲆⲈ ⲚⲈ ⲚϢⲎⲢⲈ ⲘⲠⲠⲞⲚⲎⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ⲠϪⲀϪⲈ ⲚⲦⲀϤϪⲞⲞⲨ ⲠⲈ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ. ⲠⲰϨⲤ ⲆⲈ ⲠⲈ ⲦⲤⲨⲚⲦⲈⲖⲈⲒⲀ ⲘⲠⲀⲒⲰⲚ. ⲚϪⲀⲒⲞϨⲤ ⲆⲈ ⲚⲈ ⲚⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ⲚⲐⲈ ϬⲈ ⲚϢⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲈⲚⲦⲎϬ. ⲚⲤⲈⲢⲞⲔϨⲞⲨ ϨⲢⲀⲒ ϨⲚ ⲞⲨⲔⲰϨⲦ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ϨⲢⲀⲒ ϨⲚ ⲦⲤⲨⲚⲦⲈⲖⲈⲒⲀ ⲘⲠⲀⲒⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀϪⲞⲞⲨ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ. ⲚⲤⲈⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϤⲘⲚⲦⲢⲢⲞ ⲚⲚⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲦⲈⲒⲢⲈ ⲚⲦⲀⲚⲞⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ⲚⲤⲈⲚⲞϪⲞⲨ ⲈϨⲢⲀⲒ ⲈⲦⲈϨⲢⲰ ⲚⲤⲀⲦⲈ. ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ ⲀⲨⲰ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ⲦⲞⲦⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲤⲈⲚⲀⲢⲞⲨⲞⲈⲒⲚ ⲚⲐⲈ ⲘⲠⲢⲎ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲈⲨⲈⲒⲰⲦ. ⲠⲈⲦⲈⲞⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲀϨⲞ ⲈϤϨⲎⲠ ϨⲚ ⲦⲤⲰϢⲈ ⲠⲀⲒ ⲚⲦⲀⲞⲨⲢⲰⲘⲈ ϨⲈ ⲈⲢⲞϤ ⲀϤϨⲞⲠϤ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲢⲀϢⲈ. ϢⲀϤⲂⲰⲔ ⲚϤϮ ⲈⲂⲞⲖ ⲚⲚⲔⲀ ⲚⲒⲘ ⲈⲦϢⲞⲞⲠ ⲚⲀϤ ⲚϤϢⲰⲠ ⲚⲦⲤⲰϢⲈ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ⲠⲀⲖⲒⲚ ⲞⲚ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲈϢⲰⲦ ⲈϤϢⲒⲚⲈ ⲚⲤⲀϨⲈⲚⲰⲚⲈ ⲘⲘⲈ ⲈⲚⲀⲚⲞⲨⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ⲚⲦⲈⲢⲈϤϨⲈ ⲆⲈ ⲈⲨⲰⲚⲈ ⲘⲘⲈ ⲈⲚⲀϢⲈⲤⲞⲨⲚⲦϤ. ⲀϤⲂⲰⲔ ⲀϤϮ ⲈⲂⲞⲖ ⲚⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲚⲦⲀϤ ⲀϤϢⲞⲠϤ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲈⲨⲀⲂⲰ ⲈⲀⲨⲚⲞϪⲤ ⲈⲐⲀⲖⲀⲤⲤⲀ. ⲈⲀⲤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲄⲈⲚⲞⲤ ⲚⲒⲘ ⲚⲦⲎⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ⲦⲀⲒ ⲚⲦⲈⲢⲈⲤⲘⲞⲨϨ ⲀⲨⲈⲒⲚⲈ ⲘⲘⲞⲤ ⲈϨⲢⲀⲒ ⲀⲨⲰ ⲀⲨϨⲘⲞⲞⲤ ϨⲒⲠⲈⲔⲢⲞ ⲀⲨⲔⲰⲦϤ ⲚⲚⲈⲦⲚⲀⲚⲞⲨⲞⲨ ⲈⲚⲈⲨϨⲚⲀⲀⲨ ⲚⲈⲐⲞⲞⲨ ⲆⲈ ⲀⲨⲚⲞϪⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ϨⲢⲀⲒ ϨⲚ ⲦⲤⲨⲚⲦⲈⲖⲈⲒⲀ ⲘⲠⲀⲒⲰⲚ. ⲤⲈⲚⲎⲨ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲚⲤⲈⲠⲰⲢϪ ⲈⲂⲞⲖ ⲚⲘⲠⲞⲚⲎⲢⲞⲤ ⲚⲦⲘⲎⲦⲈ ⲚⲚⲆⲒⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ⲚⲤⲈⲚⲞⲨϪⲈ ⲘⲘⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈⲦⲈϨⲢⲰ ⲚⲤⲀⲦⲈ. ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ ⲀⲨⲰ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ⲀⲦⲈⲦⲚⲚⲞⲒ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ. ⲠⲈϪⲀⲨ ϪⲈ ⲀϨⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲒⲘ ⲈⲀϤϪⲒⲤⲂⲰ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈϤⲦⲚⲦⲰⲚ ⲈⲨⲢⲰⲘⲈ ⲚⲢⲘⲘⲀⲞ. ⲠⲀⲒ ⲈⲦⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲀϨⲞ ⲚϨⲈⲚⲂⲢⲢⲈ ⲘⲚ ϨⲈⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲰ ⲚⲚⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲀϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲈϤϮⲘⲈ ⲀϤϮⲤⲰ ⲚⲀⲨ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ. ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲨⲢϢⲠⲎⲢⲈ ⲚⲤⲈϪⲞⲞⲤ ϪⲈ ⲚⲦⲀⲠⲀⲒ ϨⲈ ⲈⲦⲈⲒⲤⲞⲪⲒⲀ ⲦⲰⲚ ⲘⲚ ⲚⲈⲒϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ⲘⲎ ⲘⲠⲀⲒ ⲀⲚ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠϨⲀϢⲈ. ⲘⲎ ⲚⲦⲈϤⲘⲀⲀⲨ ⲀⲚ ⲦⲈ ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲘⲀⲢⲒϨⲀⲘ ⲀⲨⲰ ⲚⲈϤⲤⲚⲎⲨ ⲠⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲘⲚ ⲒⲰⲤⲎⲤ ⲘⲚ ⲤⲒⲘⲰⲚ ⲘⲚ ⲒⲞⲨⲆⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ⲀⲨⲰ ⲚⲈϤⲤⲰⲚⲈ ⲚⲤⲒⲘⲰⲚ ⲘⲎ ⲚⲤⲈϢⲞⲞⲠ ⲀⲚ ⲦⲎⲢⲞⲨ ϨⲀⲦⲎⲚ. ⲚⲦⲀⲠⲀⲒ ϬⲈ ϨⲈ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ⲀⲨⲰ ⲚⲈⲨⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲚϨⲎⲦϤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲚ ⲠⲢⲞⲪⲎⲦⲎⲤ ⲤⲎϢ ⲈⲒ ⲘⲎⲦⲒ ϨⲢⲀⲒ ϨⲚ ⲠⲈϤϮⲘⲈ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲘ ⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ⲘⲠⲈϤⲢϨⲀϨ ⲚϬⲞⲘ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲦⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ϨⲘ ⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲤⲰⲦⲘ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲠⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈⲠⲤⲞⲈⲒⲦ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ⲠⲈϪⲀϤ ⲚⲚⲈϤϨⲘϨⲀⲖ. ϪⲈ ⲠⲀⲒ ⲠⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲈⲒϬⲞⲘ ⲈⲚⲈⲢⲄⲈⲒ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ϨⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ϨⲘ ⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤⲘⲞⲢϤ ⲀϤⲔⲰ ⲘⲘⲞϤ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ ⲈⲦⲂⲈ ϨⲎⲢⲰⲆⲒⲀⲤ ⲐⲒⲘⲈ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ⲚⲈⲢⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲄⲀⲢ ϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲞⲨⲔ ⲈⲜⲈⲤⲦⲈⲒ ⲚⲀⲔ ⲈϪⲒ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ⲀⲨⲰ ⲚⲈϤⲞⲨⲰϢ ⲈⲘⲞⲞⲨⲦϤ ⲀϤⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϪⲈ ⲈⲚⲈⲨϪⲒ ⲘⲘⲞϤ ⲠⲈ ϨⲰⲤ ⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲆⲈ ⲚϬⲒ ⲠϨⲞⲨⲘⲒⲤⲈ ⲚϨⲎⲢⲰⲆⲎⲤ ⲀⲤϬⲞⲤϬⲤ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ⲚϨⲎⲢⲰⲆⲒⲀⲤ ⲚⲦⲘⲎⲦⲈ. ⲀⲤⲢⲀⲚⲀϤ ⲚϨⲎⲢⲰⲆⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ⲀⲨⲰ ϨⲚ ⲞⲨⲀⲚⲀϢ ⲀϤϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲈϮ ⲚⲀⲤ ⲘⲠⲈⲦⲤⲚⲀⲀⲒⲦⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ⲚⲦⲞⲤ ⲆⲈ ⲀⲨⲦⲞⲨⲚⲈⲒⲀⲦⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲤⲘⲀⲀⲨ ⲠⲈϪⲀⲤ. ϪⲈ ⲘⲀ ⲚⲀⲒ ϨⲘ ⲠⲈⲒⲘⲀ ⲚⲦⲀⲠⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ϨⲒϪⲚ ⲞⲨⲠⲒⲚⲀⲜ. ");
INSERT INTO copshc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ⲀϤⲖⲨⲠⲈⲒ ⲚϬⲒ ⲠⲢⲢⲞ ⲈⲘⲀⲦⲈ. ⲈⲦⲂⲈ ⲚⲀⲚⲀⲨϢ ⲆⲈ ⲘⲚ ⲚⲈⲦⲚⲎϪ ⲚⲘⲘⲀϤ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϮ ⲘⲘⲞⲤ ⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ⲀϤϪⲞⲞⲨ ⲀϤϤⲒ ⲚⲦⲀⲠⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ⲀⲨⲈⲒⲚⲈ ⲘⲘⲞⲤ ϨⲒϪⲘ ⲠⲠⲒⲚⲀⲜ ⲀⲨⲦⲀⲀⲤ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ. ⲀⲤⲈⲒⲚⲈ ⲘⲘⲞⲤ ⲚⲦⲈⲤⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲀⲨϤⲒ ⲘⲠⲈϤⲤⲰⲘⲀ ⲀⲨⲦⲞⲘⲤϤ ⲀⲨⲈⲒ ⲀⲨϪⲒⲠⲞⲨⲰ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϨⲒⲞⲨϪⲞⲒ ⲈⲨⲘⲀ ⲚϪⲀⲒⲈ ⲘⲀⲨⲀⲀϤ. ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲠⲈⲌⲎ ⲈⲂⲞⲖ ϨⲚ ⲘⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲚⲀⲨ ⲈⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ. ⲀϤϢⲚϨⲦⲎϤ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀⲨⲰ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲚⲈⲦϢⲰⲚⲈ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲘⲀ ⲞⲨϪⲀⲒⲈ ⲠⲈ ⲀⲨⲰ ⲀⲠⲚⲀⲨ ⲞⲨⲈⲒⲚⲈ ⲔⲀⲘⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲂⲰⲔ ⲈⲚⲈⲦⲘⲈ ⲈⲦⲘⲠⲈⲨⲔⲰⲦⲈ ⲚⲤⲈϢⲰⲠ ⲚⲀⲨ ⲘⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲈⲦⲢⲈⲨⲂⲰⲔ. ⲚⲦⲰⲦⲚ ϮⲚⲀⲨ ⲈⲦⲢⲈⲨⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲘⲚ ⲦⲀⲚⲖⲀⲀⲨ ⲘⲠⲈⲒⲘⲀ ⲚⲤⲀϮⲞⲨ ⲚⲞⲈⲒⲔ ⲘⲚ ⲦⲎⲂⲦ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲨⲈⲒⲤⲞⲨ ⲚⲀⲒ ⲈⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲚⲘⲎⲎϢⲈ ⲚⲞϪⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲬⲞⲢⲦⲞⲤ ⲀϤϪⲒ ⲘⲠϮⲞⲨ ⲚⲞⲈⲒⲔ ⲘⲚ ⲠⲦⲎⲂⲦ ⲤⲚⲀⲨ. ⲀϤϤⲒⲈⲒⲀⲦϤ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲀϤⲠⲞϢⲞⲨ ⲀϤϮ ⲚⲚⲞⲈⲒⲔ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ⲀⲨⲞⲨⲰⲘ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨⲤⲈⲒ. ⲀⲨϤⲒ ⲚⲚⲖⲀⲔⲘ ⲚⲦⲀⲨⲤⲈⲈⲠⲈ ⲘⲚ ⲦⲤⲚⲞⲞⲨⲤ ⲚⲔⲞⲦ ⲈⲨⲘⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ⲚⲈⲦⲞⲨⲰⲘ ⲆⲈ ⲚⲈⲨⲚⲀⲢⲀϮⲞⲨ ⲚϢⲞ ⲚⲢⲰⲘⲈ ⲬⲰⲢⲒⲤ ϢⲎⲢⲈ ϢⲎⲘ ϨⲒⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲀⲚⲀⲄⲔⲀⲌⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀⲖⲈ ⲈⲠϪⲞⲒ. ⲀⲨⲰ ⲈⲢϢⲞⲢⲠ ⲈⲢⲞϤ ⲈⲠⲈⲔⲢⲞ ϢⲀⲚⲦⲈϤⲔⲰ ⲈⲂⲞⲖ ⲚⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ⲚⲦⲈⲢⲈϤⲔⲰ ⲆⲈ ⲈⲂⲞⲖ ⲚⲘⲘⲎⲎϢⲈ ⲀϤⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲦⲞⲞⲨ ⲘⲀⲨⲀⲀϤ ⲀϤϢⲖⲎⲖ. ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲚⲈϤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ⲠϪⲞⲒ ⲆⲈ ⲚⲈϤⲞⲨⲎⲨ ⲈⲂⲞⲖ ⲘⲠⲈⲔⲢⲞ ⲚⲞⲨⲘⲎⲎϢⲈ ⲚⲤⲦⲀⲆⲒⲞⲚ ⲈⲨⲘⲞⲨⲔϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚϨⲒⲘⲎ. ⲠⲦⲎⲨ ⲄⲀⲢ ⲚⲈϤϮ ⲞⲨⲂⲎⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ϨⲚ ⲦⲘⲈϨϤⲦⲞ ⲆⲈ ⲚⲞⲨⲎⲢϢⲈ ⲚⲦⲈⲨϢⲎ. ⲀϤⲈⲒ ϢⲀⲢⲞⲞⲨ ⲈϤⲘⲞⲞϢⲈ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲈϤⲘⲞⲞϢⲈ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨϢⲦⲞⲢⲦⲢ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲪⲀⲚⲦⲀⲤⲘⲀ ⲠⲈ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲐⲞⲦⲈ ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲔ ⲚϨⲎⲦ ⲀⲚⲞⲔ ⲠⲈ. ⲘⲠⲢⲢϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲒ ⲈⲦⲢⲀⲈⲒ ϢⲀⲢⲞⲔ ϨⲒϪⲚ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ. ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ϨⲘ ⲠϪⲞⲒ ⲀϤⲘⲞⲞϢⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲘⲘⲞⲞⲨ ⲀϤⲈⲒ ϢⲀ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ⲈϤⲚⲀⲨ ⲆⲈ ⲈⲠⲦⲎⲨ ⲀϤⲢϨⲞⲦⲈ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀⲢⲬⲈⲒ ⲚⲰⲘⲤ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲀⲦⲞⲨϪⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲤⲞⲞⲨⲦⲚ ⲚⲦⲈϤϬⲒϪ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠⲀⲦⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ ⲈⲦⲂⲈ ⲞⲨ ⲀⲔⲆⲒⲤⲆⲀⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ⲚⲦⲈⲢⲞⲨⲀⲖⲈ ⲆⲈ ⲈⲠϪⲞⲒ ⲀϤϬⲰ ⲚϬⲒ ⲠⲦⲎⲨ. ⲚⲦⲈⲨⲚⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ⲀⲨⲞⲨⲰϢⲦ ⲚⲀϤ ⲚϬⲒ ⲚⲈⲦϢⲞⲞⲠ ϨⲘ ⲠϪⲞⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲘⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ⲚⲦⲈⲢⲞⲨϪⲒⲞⲞⲢ ⲆⲈ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲈⲔⲢⲞ ⲚⲄⲈⲚⲚⲎⲌⲀⲢⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ⲀⲨⲤⲞⲨⲰⲚϤ ⲆⲈ ⲚϬⲒ ⲚⲢⲰⲘⲈ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲀⲨϪⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲘⲞⲔϨ. ");
INSERT INTO copshc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ⲀⲨⲰ ⲀⲨⲤⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲰϨ ⲘⲘⲀⲦⲈ ⲈⲠⲦⲞⲠ ⲘⲠⲈϤϨⲞⲈⲒⲦⲈ. ⲀⲨⲰ ⲚⲈⲚⲦⲀⲨϪⲰϨ ⲀⲨⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ⲦⲞⲦⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲈⲒ ⲈⲒⲎⲤⲞⲨⲤ ⲚϬⲒ ϨⲈⲚⲤⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ϨⲈⲚⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲨϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲤⲈⲠⲀⲢⲀⲂⲀ ⲚⲦⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ⲚⲤⲈⲈⲒⲰ ⲄⲀⲢ ⲀⲚ ⲚⲚⲈⲨϬⲒϪ ⲈⲨⲚⲀⲞⲨⲰⲘ ⲘⲠⲈⲨⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ϨⲰⲦⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲠⲀⲢⲀⲂⲀ ⲚⲦⲈⲚⲦⲞⲖⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲂⲈ ⲦⲈⲦⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲀϤϪⲞⲞⲤ ϪⲈ ⲘⲀⲦⲀⲒⲈⲠⲈⲔⲈⲒⲰⲦ ⲘⲚ ⲦⲈⲔⲘⲀⲀⲨ. ⲀⲨⲰ ⲠⲈⲦⲚⲀϪⲈⲠⲈⲐⲞⲞⲨ ⲚⲤⲀⲠⲈϤⲈⲒⲰⲦ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ϨⲚ ⲞⲨⲘⲞⲨ ⲘⲀⲢⲈϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲚⲀϪⲞⲞⲤ ⲘⲠⲈϤⲈⲒⲰⲦ ⲎⲦⲈϤⲘⲀⲀⲨ ϪⲈ ⲞⲨⲆⲰⲢⲞⲚ ⲠⲀⲒ ⲈⲦⲈⲔⲚⲀϮϨⲎⲨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ⲚⲈϤⲦⲀⲒⲞ ⲀⲚ ⲘⲠⲈϤⲈⲒⲰⲦ. ⲀⲦⲈⲦⲚⲦⲤⲦⲞ ⲈⲂⲞⲖ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲂⲈ ⲦⲈⲦⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲔⲀⲖⲰⲤ ⲀϤⲠⲢⲞⲪⲎⲦⲈⲨⲈ ϨⲀⲢⲰⲦⲚ ⲚϬⲒ ⲎⲤⲀⲒⲀⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲈϤⲦⲀⲒⲞ ⲘⲘⲞⲒ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲨⲤⲠⲞⲦⲞⲨ. ⲠⲈⲨϨⲎⲦ ⲆⲈ ⲞⲨⲎⲨ ⲚⲤⲀⲂⲞⲖ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ⲈⲨϢⲘϢⲈ ⲆⲈ ⲘⲘⲞⲒ ⲈⲠϪⲒⲚϪⲎ. ⲈⲨϮⲤⲂⲰ ⲚϨⲈⲚⲤⲂⲰ ⲚⲈⲚⲦⲞⲖⲎ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲠⲘⲎⲎϢⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲤⲰⲦⲘ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲚⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ⲘⲠⲈⲦⲂⲎⲔ ⲀⲚ ⲈϨⲞⲨⲚ ⲈⲦⲦⲀⲠⲢⲞ ⲠⲈⲦⲤⲰⲰϤ ⲘⲠⲢⲰⲘⲈ. ⲀⲖⲖⲀ ⲠⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲦⲀⲠⲢⲞ ⲠⲈⲦⲤⲰⲰϤ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ⲦⲞⲦⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲔⲤⲞⲞⲨⲚ ϪⲈ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲈⲚⲈⲒϢⲀϪⲈ ⲀⲨⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲦⲰϬⲈ ⲚⲒⲘ ⲈⲦⲘⲠⲈⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈⲦⲞϬϤ ϤⲚⲀⲠⲰⲢⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ⲀⲖⲰⲦⲚ ϨⲀⲢⲞⲞⲨ ϨⲈⲚϪⲀⲨⲘⲞⲈⲒⲦ ⲚⲂⲖⲖⲈ ⲚⲈ. ⲞⲨⲂⲖⲖⲈ ⲆⲈ ⲈϤϢⲀⲚϪⲒⲘⲞⲈⲒⲦ ϨⲎⲦϤ ⲚⲞⲨⲂⲖⲖⲈ ⲤⲈⲚⲀϨⲈ ⲈⲨϨⲒⲈⲒⲦ ⲘⲠⲈⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲂⲰⲖ ⲈⲢⲞⲚ ⲚⲦⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲘⲎ ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲦⲈⲦⲚ ϨⲈⲚⲀⲐⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ⲘⲎ ⲚⲦⲈⲦⲚ ⲚⲞⲒ ⲀⲚ ϪⲈ ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲦⲀⲠⲢⲞ. ⲚϢⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲎ ⲚⲤⲈⲦⲀⲨⲞϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲚⲈⲢⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ⲚⲈⲦⲚⲎⲨ ⲚⲦⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲦⲀⲠⲢⲞ. ⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ϨⲘ ⲠϨⲎⲦ. ⲚⲈⲦⲘⲘⲀⲨ ⲚⲈⲦⲤⲰⲰϤ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ⲈⲨⲚⲎⲨ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲘ ⲠϨⲎⲦ ⲚϬⲒ ⲘⲘⲞⲔⲘⲈⲔ ⲈⲐⲞⲞⲨ ϨⲈⲚϨⲰⲦⲂ ϨⲈⲚⲘⲚⲦⲚⲞⲈⲒⲔ ϨⲈⲚⲠⲞⲢⲚⲈⲒⲀ ϨⲈⲚϪⲒⲞⲨⲈ ϨⲈⲚⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲚⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ⲚⲀⲒ ⲚⲈⲦⲤⲰⲰϤ ⲘⲠⲢⲰⲘⲈ. ⲈⲞⲨⲰⲘ ⲆⲈ ⲘⲠⲈⲔⲈⲒⲀⲦⲞⲞⲦⲔ ⲚϤⲤⲰⲰϤ ⲀⲚ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲈϨⲢⲀⲒ ⲈⲘⲘⲞⲞϢⲈ ⲚⲦⲨⲢⲞⲤ ⲘⲚ ⲤⲒⲆⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲤϨⲒⲘⲈ ⲚⲬⲀ ⲚⲀⲚⲀⲒⲀ ⲀⲤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲦⲞϢ ⲈⲦⲘⲘⲀⲨ. ⲀⲤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀ ⲚⲀⲒ ⲠϪⲞⲈⲒⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲦⲀϢⲈⲈⲢⲈ ϨⲒⲦⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ⲚⲦⲞϤ ⲆⲈ ⲘⲠⲈϤⲞⲨⲰϢⲂ ⲚⲀⲤ ⲚⲞⲨϢⲀϪⲈ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲤⲠⲤⲰⲠϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲰ ⲘⲘⲞⲤ ⲈⲂⲞⲖ ϪⲈ ⲤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲒⲠⲀϨⲞⲨ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲞⲨⲦⲚⲚⲞⲞⲨⲦ ⲈⲖⲀⲀⲨ ⲈⲒ ⲘⲎⲦⲒ ⲚⲈⲤⲞⲞⲨ ⲚⲦⲀⲨⲤⲰⲢⲘ ⲚⲦⲈⲠⲎⲒ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ⲚⲦⲞⲤ ⲆⲈ ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲈⲤⲞⲨⲰϢⲦ ⲚⲀϤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲂⲞⲎⲐⲈⲒⲀ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲤ. ϪⲈ ⲚⲚⲀⲚⲞⲨⲤ ⲀⲚ ⲈϪⲒ ⲘⲠⲞⲈⲒⲔ ⲚⲚϢⲎⲢⲈ ⲈⲚⲞⲨϪⲈ ⲘⲘⲞϤ ⲚⲚⲈⲨϨⲞⲞⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ⲚⲦⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ. ⲚⲔⲈⲞⲨϨⲞⲞⲢ ϢⲀⲨⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲤⲢⲈϤⲢⲒⲂⲈ ⲈⲦϨⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲚⲚⲈⲨϪⲒⲤⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ⲦⲞⲦⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲤ. ϪⲈ ⲰⲦⲈⲤϨⲒⲘⲈ ⲞⲨⲚⲞϬ ⲦⲈ ⲦⲞⲨⲠⲒⲤⲦⲒⲤ ⲘⲀⲢⲈⲤϢⲰⲠⲈ ⲚⲎ ⲚⲐⲈ ⲈⲦⲈⲢⲞⲨⲀϢⲤ. ⲀⲨⲰ ⲀⲤⲖⲞ ⲚϬⲒ ⲦⲈⲤϢⲈⲈⲢⲈ ϪⲒⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ⲚⲦⲈⲢⲈϤⲠⲰⲰⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲒ ⲈϪⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲀϤⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲦⲞⲞⲨ. ⲀϤϨⲘⲞⲞⲤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ ⲈⲀⲨⲈⲒⲚⲈ ⲚⲘⲘⲀⲨ ⲚϨⲚⲂⲖⲖⲈ ⲘⲚ ϨⲈⲚϬⲀⲖⲈ ⲘⲚ ϨⲈⲚⲘⲠⲞ ⲘⲚ ϨⲈⲚϬⲀⲚⲀϨ ⲘⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲚⲀϢⲰⲞⲨ ⲀⲨⲚⲞϪⲞⲨ ϨⲀⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲚⲘⲎⲎϢⲈ ⲢϢⲠⲎⲢⲈ ⲈⲨⲚⲀⲨ ⲈⲚϬⲀⲖⲈ ⲈⲨⲘⲞⲞϢⲈ ⲘⲚ ⲚϬⲀⲚⲀϨ ⲈⲨⲦⲀⲖϬⲎⲨ ⲘⲚ ⲚⲈⲘⲠⲞ ⲈⲨϢⲀϪⲈ ⲘⲚ ⲚⲂⲖⲖⲈ ⲈⲨⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϮϢⲚϨⲦⲎⲒ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲒⲘⲎⲎϢⲈ ϪⲈ ⲈⲒⲤϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲤⲈϬⲈⲈⲦ ⲈⲢⲞⲒ ⲀⲨⲰ ⲘⲚ ⲦⲀⲨ ⲘⲘⲀⲨ ⲘⲠⲈⲦ ⲞⲨⲚⲀⲞⲨⲞⲘϤ ⲚϮⲞⲨⲰϢ ⲆⲈ ⲀⲚ ⲈⲔⲀⲀⲨ ⲈⲂⲞⲖ ⲈⲨϨⲔⲀⲈⲒⲦ ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈϢⲰⲤⲘ ϨⲢⲀⲒ ϨⲚ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ⲠⲈϪⲀⲨ ⲚⲀϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲚⲚⲀϨⲈ ⲈⲦⲈⲒⲀϢⲎ ⲚⲞⲈⲒⲔ ⲦⲰⲚ ϨⲘ ⲠⲈⲒϪⲀⲒⲈ ϨⲰⲤⲦⲈ ⲈⲦⲤⲒⲈⲞⲨⲘⲎⲎϢⲈ ⲚⲦⲈⲒϬⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲞⲨⲚⲞⲨⲎⲢ ⲚⲞⲈⲒⲔ ⲚⲦⲈⲦⲎⲨⲦⲚ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲀϢϤ ⲘⲚ ϨⲈⲚϢⲎⲘ ⲚⲦⲎⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ⲀϤⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲆⲈ ⲚⲘⲘⲎⲎϢⲈ ⲈⲦⲢⲈⲨⲚⲞϪⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ⲀϤϪⲒ ⲘⲠⲤⲀϢϤ ⲚⲞⲈⲒⲔ ⲘⲚ ⲚⲦⲎⲂⲦ ⲀϤϢⲠϨⲘⲞⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀϤⲠⲞϢⲞⲨ ⲀϤϮ ⲘⲘⲞⲞⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϮ ⲚⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ⲀⲨⲞⲨⲰⲘ ⲆⲈ ⲀⲨⲰ ⲀⲨⲤⲈⲒ ⲦⲎⲢⲞⲨ ⲀⲨϤⲒ ⲘⲠⲈϨⲞⲨⲞ ⲚⲚⲖⲀⲔⲘ ⲤⲀϢϤ ⲚⲂⲒⲢ ⲈⲨⲘⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ⲚⲈⲦⲞⲨⲰⲘ ⲆⲈ ⲚⲈⲨⲚⲀⲢⲀϤⲦⲞⲞⲨ ⲚϢⲞ ⲚⲢⲰⲘⲈ ⲬⲰⲢⲒⲤ ϢⲎⲢⲈ ϢⲎⲘ ϨⲒⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ⲚⲦⲈⲢⲈϤⲔⲰ ⲆⲈ ⲈⲂⲞⲖ ⲚⲘⲘⲎⲎϢⲈ ⲀϤⲀⲖⲈ ⲈⲠϪⲞⲒ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲚⲦⲰϢ ⲘⲘⲀⲄⲈⲆⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲈⲨϪⲚⲞⲨ ⲘⲘⲞϤ ⲈⲦⲞⲨⲞⲞⲨ ⲈⲨⲘⲀⲈⲒⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","— ");
INSERT INTO copshc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ϪⲈ ⲦⲄⲈⲚⲈⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲀⲨⲰ ⲚⲚⲞⲈⲒⲔ ⲤϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ ⲀⲨⲰ ⲚⲚⲈⲨϮⲘⲀⲈⲒⲚ ⲚⲀⲤ ⲚⲤⲀⲠⲘⲀⲈⲒⲚ ⲚⲒⲰⲚⲀⲤ ⲀϤⲔⲀⲀⲨ ⲆⲈ ⲚⲤⲰϤ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ⲀⲨⲈⲒ ⲆⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲠⲈⲔⲢⲞ ⲀⲨⲢⲠⲰⲂϢ ⲚϪⲒⲞⲈⲒⲔ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ϬⲰϢⲦ ⲚⲦⲈⲦⲚ ϮϨⲦⲎⲦⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲐⲀⲂ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨⲘⲈⲈⲨⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲚϪⲒⲞⲈⲒⲔ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲚⲀⲦⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ ϪⲈ ⲘⲠⲈⲦⲚϪⲒⲞⲈⲒⲔ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ⲈⲒⲈ ⲘⲠⲀⲦⲈⲦⲚⲚⲞⲒⲞⲨⲦⲈ ⲚⲦⲈⲦⲚ ⲢⲠⲘⲈⲈⲨⲈ ⲀⲚ ⲘⲠϮⲞⲨ ⲚⲞⲈⲒⲔ ⲘⲠϮⲞⲨ ⲚϢⲞ ⲚⲢⲰⲘⲈ. ⲀⲨⲰ ϪⲈ ⲀⲦⲈⲦⲚϪⲒⲞⲨⲎⲢ ⲚⲔⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ⲞⲨⲆⲈ ⲘⲠⲤⲀϢϤ ⲚⲞⲈⲒⲔ ⲘⲠⲈϤⲦⲞⲞⲨ ⲚϢⲞ. ⲀⲨⲰ ϪⲈ ⲀⲦⲈⲦⲚϪⲒⲞⲨⲎⲢ ⲚⲂⲒⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ⲚⲀϢ ⲚϨⲈ ⲦⲈⲦⲚⲚⲞⲒ ⲀⲚ ϪⲈ ⲚⲦⲀⲒϪⲞⲞⲤ ⲀⲚ ⲚⲎⲦⲚ ⲈⲦⲂⲈ ⲞⲈⲒⲔ. ϮϨⲦⲎⲦⲚ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲐⲀⲂ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ⲦⲞⲦⲈ ⲀⲨⲈⲒⲘⲈ ϪⲈ ⲚⲦⲀϤϪⲞⲞⲤ ⲀⲚ ⲚⲀⲨ ⲈⲦⲂⲈ ⲠⲈⲐⲀⲂ ⲚⲚⲞⲈⲒⲔ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲦⲈⲤⲂⲰ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲘⲘⲞⲞϢⲈ ⲚⲦⲔⲀⲒⲤⲀⲢⲒⲀ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ. ⲀϤϪⲚⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈⲚⲢⲰⲘⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ⲠⲈ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲒⲈⲢⲎⲘⲒⲀⲤ ⲠⲈ ⲎⲞⲨⲀ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ. ϪⲈ ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲀⲒⲀⲦⲔ ⲤⲒⲘⲰⲚ ⲂⲀⲢⲒⲰⲚⲀ ϪⲈ ⲚⲤⲀⲢⲜ ⲀⲚ ϨⲒⲤⲚⲞϤ ⲠⲈⲚⲦⲀϤϬⲈⲖⲠⲠⲀⲒ ⲚⲀⲔ ⲈⲂⲞⲖ. ⲀⲖⲖⲀ ⲠⲀⲈⲒⲰⲦ ⲠⲈ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ⲀⲚⲞⲔ ⲆⲈ ϨⲰ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ. ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲒⲠⲈⲦⲢⲀ ϮⲚⲀⲔⲰⲦ ⲚⲦⲀⲈⲔⲔⲖⲎⲤⲒⲀ ⲀⲨⲰ ⲘⲠⲨⲖⲎ ⲚⲀⲘⲚⲦⲈ ⲚⲀⲈϢϬⲘϬⲞⲘ ⲈⲢⲞⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ϮⲚⲀϮ ⲆⲈ ⲚⲀⲔ ⲚⲚϢⲞϢⲦ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲀⲨⲰ ⲠⲈⲦⲔⲚⲀⲘⲞⲢϤ ϨⲒϪⲘ ⲠⲔⲀϨ ϤⲚⲀϢⲰⲠⲈ ⲈϤⲘⲎⲢ ϨⲚ ⲘⲠⲎⲨⲈ. ⲀⲨⲰ ⲠⲈⲦⲔⲚⲀⲂⲞⲖϤ ϨⲒϪⲘ ⲠⲔⲀϨ ϤⲚⲀϢⲰⲠⲈ ⲈϤⲂⲎⲖ ϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ⲦⲞⲦⲈ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲨϪⲞⲞⲤ ⲈⲖⲀⲀⲨ ϪⲈ ⲚⲦⲞϤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ϪⲒⲚⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀϤⲀⲢⲬⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀⲘⲘⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚϤϢⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ⲀϤϢⲞⲠⲤ ⲚⲦⲞⲞⲦϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀϤⲀⲢⲬⲈⲒ ⲚⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲞⲨⲞϪ ⲠϪⲞⲈⲒⲤ ⲚⲚⲈⲠⲀⲒ ϢⲰⲠⲈ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲔⲞⲦϤ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲂⲰⲔ ⲈⲠⲀϨⲞⲨ ⲘⲘⲞⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲚⲦⲔⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲀⲒ ϪⲈ ⲚⲈⲔⲘⲈⲈⲨⲈ ⲀⲚ ⲈⲚⲀⲠⲚⲞⲨⲦⲈ ⲀⲖⲖⲀ ⲈⲚⲀⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ⲦⲞⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲈⲦⲞⲨⲰϢ ⲈⲈⲒ ⲈⲠⲀϨⲞⲨ ⲘⲘⲞⲒ ⲘⲀⲢⲈϤⲀⲠⲀⲢⲚⲀ ⲘⲘⲞϤ ⲚϤϤⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲄⲀⲢ ⲈⲦⲞⲨϪⲞ ⲚⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲤⲞⲢⲘⲈⲤ. ⲠⲈⲦⲚⲀⲤⲰⲢⲘ ⲆⲈ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲦⲂⲎⲎⲦ ϤⲚⲀϨⲈ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ⲈⲢⲈⲠⲢⲰⲘⲈ ⲄⲀⲢ ⲚⲀϮϨⲎⲨ ⲚⲞⲨ ⲈϤϢⲀⲚϮϨⲎⲨ ⲆⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲚϤϮⲞⲤⲈ ⲚⲦⲈϤⲮⲨⲬⲎ ⲎⲞⲨ ⲠⲈⲦⲈⲢⲈⲠⲢⲰⲘⲈ ⲚⲀⲦⲀⲀϤ ⲚϢⲂⲂⲒⲰ ⲚⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ⲠϢⲎⲢⲈ ⲄⲀⲢ ⲘⲠⲢⲰⲘⲈ ⲚⲎⲨ ϨⲘ ⲠⲈⲞⲞⲨ ⲘⲠⲈϤⲈⲒⲰⲦ ⲘⲚ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲚϤⲦⲰⲰⲂⲈ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲔⲀⲦⲀⲚⲈϤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ϨⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲈⲒⲘⲀ. ⲚⲀⲒ ⲚⲤⲈⲚⲀϪⲒϮⲠⲈ ⲀⲚ ⲘⲠⲘⲞⲨ ϢⲀⲚⲦⲞⲨⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲎⲨ ϨⲚ ⲦⲈϤⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ⲘⲚ ⲚⲤⲀⲤⲞⲞⲨ ⲆⲈ ⲚϨⲞⲞⲨ ⲀϤϪⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲀⲔⲰⲂⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲦⲞⲞⲨ ⲈϤϪⲞⲤⲈ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ⲀϤϢⲂⲦϤ ⲘⲠⲈⲨⲘⲦⲞ ⲈⲂⲞⲖ. ⲠⲈϤϨⲞ ⲀϤⲦⲀⲀⲦⲈ ⲚⲐⲈ ⲘⲠⲢⲎ. ⲀⲨⲰ ⲚⲈϤϨⲞⲒⲦⲈ ⲀⲨⲞⲨⲂⲀϢ ⲚⲐⲈ ⲘⲠⲞⲨⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨⲞⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ ⲚϬⲒ ⲘⲰⲨⲤⲎⲤ ⲘⲚ ϨⲎⲖⲈⲒⲀⲤ ⲈⲨϢⲀϪⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲚ ⲈⲦⲢⲈⲚϬⲰ ⲘⲠⲈⲒⲘⲀ ⲔⲞⲨⲰϢ ⲈⲦⲢⲈⲚⲦⲀⲘⲈⲒⲞ ⲘⲠⲈⲒⲘⲀ ⲚϢⲞⲘⲦⲈ ⲚⲤⲔⲨⲚⲎ ⲞⲨⲈⲒ ⲚⲀⲔ ⲞⲨⲈⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲈⲒ ⲚϨⲎⲖⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ⲈⲦⲒ ⲈϤϢⲀϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲔⲖⲞⲞⲖⲈ ⲚⲞⲨⲞⲈⲒⲚ ⲀⲤⲢϨⲀⲒⲂⲈⲤ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀⲨⲰ ⲈⲒⲤⲞⲨⲤⲘⲎ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲖⲞⲞⲖⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲘⲈⲢⲒⲦ ⲠⲈⲚⲦⲀⲠⲀⲞⲨⲰϢ ϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲤⲰⲦⲘ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲨϨⲞ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϪⲰϨ ⲈⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚ ⲘⲠⲢⲢϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ⲀⲨϤⲒ ⲆⲈ ⲚⲚⲈⲨⲂⲀⲖ ⲈϨⲢⲀⲒ ⲘⲠⲞⲨⲚⲀⲨ ⲈⲖⲀⲀⲨ ⲈⲒ ⲘⲎⲦⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ϨⲒⲠⲦⲞⲞⲨ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢϪⲰ ⲈⲖⲀⲀⲨ ⲘⲠϨⲞⲢⲀⲘⲀ ϢⲀⲚⲦⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϨⲢⲞⲞⲨ ϬⲈ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈ ϨⲎⲖⲈⲒⲀⲤ ⲈⲒ ⲚϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲘⲈⲚ ⲚⲎⲨ ⲚϤⲀⲠⲞⲔⲀⲐⲒⲤⲦⲀ ⲚϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀϨⲎⲖⲈⲒⲀⲤ ⲞⲨⲰ ⲈϤⲈⲒ ⲀⲨⲰ ⲘⲠⲞⲨⲤⲞⲨⲰⲚϤ. ⲀⲖⲖⲀ ⲀⲨⲈⲒⲢⲈ ⲚⲀϤ ⲚⲚⲈⲚⲦⲀⲨⲞⲨⲀϢⲞⲨ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲘⲠϢⲎⲢⲈ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲀϢⲠϨⲒⲤⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ⲦⲞⲦⲈ ⲀⲨⲈⲒⲘⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲨ ⲈⲦⲂⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ϢⲀⲠⲘⲎⲎϢⲈ ⲀⲨⲢⲰⲘⲈ ϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲈϤⲤⲞⲠⲤ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀ ⲘⲠⲀϢⲎⲢⲈ ϪⲈ ϤϨⲒⲦⲈ ⲀⲨⲰ ϤⲘⲞⲔϨ. ϨⲀϨ ⲄⲀⲢ ⲚⲤⲞⲠ ϢⲀϤϨⲈ ⲈϨⲢⲀⲒ ⲈⲠⲔⲰϨⲦ ⲀⲨⲰ ϨⲀϨ ⲚⲤⲞⲠ ⲈϨⲢⲀⲒ ⲈⲠⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ⲀⲒⲈⲒⲚⲈ ⲆⲈ ⲘⲘⲞϤ ⲚⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲘⲠⲞⲨⲈϢϬⲘϬⲞⲘ ⲈⲢⲠⲀϨⲢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲦⲄⲈⲚⲈⲀ ⲚⲀⲠⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲈⲦϬⲞⲞⲘⲈ ϢⲀⲦⲚⲀⲨ ϮⲚⲀϢⲰⲠⲈ ⲚⲘⲘⲎⲦⲚ. ϢⲀⲦⲚⲀⲨ ϮⲚⲀⲀⲚⲈⲒⲬⲈ ⲘⲘⲰⲦⲚ ⲀⲨⲈⲒⲤϤ ⲚⲀⲒ ⲈⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲚϬⲒ ⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ⲀⲠϢⲎⲢⲈ ϢⲎⲘ ⲖⲞ ϪⲒⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ⲦⲞⲦⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲒⲎⲤⲞⲨⲤ ⲚⲤⲀⲞⲨⲤⲀ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲚⲞⲚ ⲘⲠⲈⲚⲈϢϬⲘϬⲞⲘ ⲈⲚⲞϪϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲦⲈⲦⲚⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ ϨⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲠⲒⲤⲦⲒⲤ ⲘⲘⲀⲨ ⲚⲐⲈ ⲚⲞⲨⲂⲖⲂⲒⲖⲈ ⲚϢⲖⲦⲎⲘ ⲦⲈⲦⲚⲚⲀϪⲞⲞⲤ ⲘⲠⲈⲒⲦⲞⲞⲨ ϪⲈ ⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲀ ⲈⲠⲎ ⲚϤⲠⲰⲰⲚⲈ ⲚⲦⲈⲦⲘⲖⲀⲀⲨ ⲢⲀⲦϬⲞⲘ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","— ");
INSERT INTO copshc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ⲚⲤⲈⲘⲞⲞⲨⲦϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲖⲨⲠⲈⲒ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲀⲚⲈⲦϪⲒⲔⲒⲦⲈ ϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲠⲈⲦⲢⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲈⲢⲈ ⲠⲈⲦⲚⲤⲀϨ ϮⲦⲈϤⲔⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ⲠⲈϪⲀϤ ϪⲈ ϢⲰ. ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ⲀⲒⲎⲤⲞⲨⲤ ⲢϢⲞⲢⲠ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲀⲔ ⲤⲒⲘⲰⲚ. ⲚⲢⲢⲰⲞⲨ ⲚⲦⲈⲠⲔⲀϨ ⲈⲨϪⲒⲦⲈⲖⲞⲤ ⲚⲦⲚⲚⲒⲘ ⲎⲔⲨⲚⲤⲞⲤ. ⲈⲨϪⲒ ⲚⲦⲚⲚⲈⲨϢⲎⲢⲈ. ϪⲚⲈⲨϪⲒ ⲚⲦⲚⲚϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ⲚⲦⲈⲢⲈϤϪⲞⲞⲤ ⲆⲈ ϪⲈ ⲚⲦⲚⲚϢⲘⲘⲞ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈⲈⲒⲈϨⲈⲚⲢⲘϨⲈ ⲚⲈ ⲚϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ϪⲈⲔⲀⲀⲤ ⲆⲈ ⲚⲚⲈⲚⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲞⲨ ⲂⲰⲔ ⲈⲐⲀⲖⲀⲤⲤⲀ ⲚⲄⲚⲞⲨϪⲈ ⲚⲞⲨⲞⲒⲘⲈ ⲚⲄϤⲒ ⲘⲠⲦⲎⲂⲦ ⲈⲦⲚⲎⲨ ⲈϨⲢⲀⲒ ⲚϢⲞⲢⲠ ⲀⲨⲰ ⲈⲔϢⲀⲚⲞⲨⲰⲚ ⲈⲢⲰϤ ⲔⲚⲀϨⲈ ⲈⲨⲤⲀⲦⲈⲈⲢⲈ ϤⲒ ⲚⲦⲈⲦⲘⲘⲀⲨ ⲚⲄⲦⲀⲀⲤ ϨⲀⲢⲞⲒ ⲚⲘⲘⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲘⲘⲀⲐⲎⲦⲎⲤ ϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲒⲎⲤⲞⲨⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲀⲢⲀ ⲠⲈ ⲠⲚⲞϬ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲨϢⲎⲢⲈ ϢⲎⲘ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲒ ⲘⲎⲦⲒ ⲚⲦⲈⲦⲚⲔⲈⲦ ⲦⲎⲨⲦⲚ ⲚⲦⲈⲦⲚⲢ ⲐⲈ ⲚⲚⲈⲒϢⲎⲢⲈ ϢⲎⲘ ⲚⲚⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ⲠⲈⲦⲚⲀⲐⲂⲂⲒⲞϤ ⲆⲈ ⲚⲐⲈ ⲘⲠⲒϢⲎⲢⲈ ϢⲎⲘ. ⲠⲀⲒ ⲠⲈ ⲠⲚⲞϬ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ⲀⲨⲰ ⲠⲈⲦⲚⲀϢⲰⲠ ⲈⲢⲞϤ ⲚⲞⲨϢⲎⲢⲈ ϢⲎⲘ ⲚⲦⲈⲒϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲀⲢⲀⲚ ⲈϤϢⲰⲠ ⲘⲘⲞⲒ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ⲠⲈⲦⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲆⲈ ⲚⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲒ. ⲤⲈⲢⲚⲞϤⲢⲈ ⲚⲀϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲨⲢ ⲚⲞⲨⲰⲚⲈ ⲚⲤⲒⲔⲈ ⲈⲠⲈϤⲘⲀⲔϨ ⲚⲤⲈⲞⲘⲤϤ ϨⲢⲀⲒ ϨⲘ ⲠⲠⲈⲖⲀⲄⲞⲤ ⲚⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ⲞⲨⲞⲒ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ. ⲀⲚⲀⲄⲔⲎ ⲄⲀⲢ ⲈⲦⲢⲈⲚⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲈⲒ. ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲠⲈⲦⲈⲢⲈ ⲠⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ⲈϢϪⲈ ⲦⲈⲔϬⲒϪ ⲎⲦⲈⲔⲞⲨⲈⲢⲎⲦⲈ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ϢⲀⲀⲦⲤ ⲚⲄⲚⲞϪⲤ ⲚⲤⲀⲂⲞⲖ ⲘⲘⲞⲔ ⲚⲀⲚⲞⲨⲤ ⲄⲀⲢ ⲚⲀⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ ⲈⲔⲞ ⲚϬⲀⲖⲈ ⲎⲈⲔⲞ ⲚϬⲀⲚⲀϨ ⲎⲈⲢⲈⲦⲈⲔϬⲒϪ ⲤⲚⲦⲈ ⲘⲘⲞⲔ ⲎⲞⲨⲈⲢⲎⲦⲈ ⲤⲚⲦⲈ ⲚⲤⲈⲚⲞϪⲔ ⲈⲦⲤⲀⲦⲈ ⲚϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ⲀⲨⲰ ⲈϢϪⲈ ⲠⲈⲔⲂⲀⲖ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ⲠⲞⲢⲔϤ ⲚⲄⲚⲞϪϤ ⲚⲤⲀⲂⲞⲖ ⲘⲘⲞⲔ. ⲚⲀⲚⲞⲨⲤ ⲄⲀⲢ ⲚⲀⲔ ⲈⲢⲈⲞⲨⲂⲀⲖ ⲚⲞⲨⲰⲦ ⲘⲘⲞⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ ⲈϨⲞⲨⲈⲈⲢⲈⲂⲀⲖ ⲤⲚⲀⲨ ⲘⲘⲞⲔ ⲚⲤⲈⲚⲞϪⲔ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ⲚⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ϬⲰϢⲦ ⲘⲠⲢⲔⲀⲦⲀⲪⲢⲞⲚⲈⲒ ⲚⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ. ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲈⲨⲀⲄⲄⲈⲖⲞⲤ ϬⲰϢⲦ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲚ ⲘⲠⲎⲨⲈ ⲈⲠϨⲞ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","— ");
INSERT INTO copshc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲎⲦⲚ ⲈϢⲰⲠⲈ ⲞⲨⲢⲰⲘⲈ ⲈϤϢⲀⲚⲔⲰ ⲚⲀϤ ⲚϢⲈ ⲚⲈⲤⲞⲞⲨ ⲚⲦⲈⲞⲨⲀ ⲤⲰⲢⲘ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲘⲎ ⲚϤⲚⲀⲔⲰ ⲀⲚ ⲘⲠⲈⲒⲠⲤⲦⲀⲒⲞⲨⲮⲒⲤ ⲚⲈⲤⲞⲞⲨ ϨⲒϪⲚ ⲚⲦⲞⲞⲨ ⲚϤⲂⲰⲔ ⲚϤϢⲒⲚⲈ ⲚⲤⲀⲠⲈⲦⲤⲰⲢⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ⲀⲨⲰ ⲈⲤϢⲀⲚϢⲰⲠⲈ ⲚϤϨⲈ ⲈⲢⲞϤ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ϢⲀϤⲢⲀϢⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈϨⲞⲨⲈⲠⲈⲒⲠⲤⲦⲀⲒⲞⲨⲮⲒⲤ ⲈⲦⲘⲠⲞⲨⲤⲰⲢⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈϨⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲢϢⲀⲚⲠⲈⲔⲤⲞⲚ ⲢⲚⲞⲂⲈ ⲂⲰⲔ ⲚⲄϪⲠⲈⲒⲞϤ ⲞⲨⲦⲰⲔ ⲞⲨⲦⲰϤ ⲘⲀⲨⲀⲀⲔ. ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚⲤⲰⲦⲘ ⲚⲤⲰⲔ ⲀⲔϮϨⲎⲨ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚⲦⲘⲤⲰⲦⲘ ⲚⲤⲰⲔ ϪⲒ ⲚⲔⲈⲞⲨⲀ ⲚⲘⲘⲀⲔ. ⲎⲤⲚⲀⲨ. ϪⲈⲔⲀⲀⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲘⲘⲚⲦⲢⲈ ⲤⲚⲀⲨ ⲎϢⲞⲘⲚⲦ ⲈⲢⲈϢⲀϪⲈ ⲚⲒⲘ ⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚⲦⲘⲤⲰⲦⲘ ⲚⲤⲰⲞⲨ. ⲀϪⲒⲤ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚⲢⲀⲦⲤⲰⲦⲘ ⲚⲤⲀⲦⲔⲈⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲀⲢⲈϤϢⲰⲠⲈ ⲚⲀⲔ ⲚⲐⲈ ⲚⲞⲨϨⲈⲐⲚⲒⲔⲞⲤ ⲘⲚⲞⲨⲦⲈⲖⲰⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲚⲈⲦⲈⲦⲚⲀⲘⲞⲢⲞⲨ ϨⲒϪⲘ ⲠⲔⲀϨ ⲤⲈⲚⲀϢⲰⲠⲈ ⲈⲨⲘⲎⲢ ϨⲚ ⲘⲠⲎⲨⲈ. ⲀⲨⲰ ⲚⲈⲦⲈⲦⲚⲀⲂⲞⲖ ⲈⲂⲞⲖ ϨⲒ ϪⲘⲠⲔⲀϨ ⲤⲈⲚⲀϢⲰⲠⲈ ⲈⲨⲂⲎⲖ ϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ϨⲀⲘⲎⲚ ⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲈⲢϢⲀⲚⲤⲚⲀⲨ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϤⲒ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϨⲢⲀⲒ ϨⲒϪⲘ ⲠⲔⲀϨ. ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲞⲨⲚⲀⲀⲒⲦⲈⲒ ⲘⲘⲞⲞⲨ ⲤⲈⲚⲀϢⲰⲠⲈ ⲚⲀⲨ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ ⲘⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ⲠⲘⲀ ⲄⲀⲢ ⲈⲦⲈⲢⲈ ⲤⲚⲀⲨ. ⲎϢⲞⲘⲚⲦ ⲤⲞⲞⲨϨ ⲚϨⲎⲦϤ ϨⲘ ⲠⲀⲢⲀⲚ. ⲀⲚⲞⲔ ϮϢⲞⲞⲠ ⲚⲘⲘⲀⲨ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ⲦⲞⲦⲈ ⲀⲠⲈⲦⲢⲞⲤ ϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲢϢⲀⲚⲠⲀⲤⲞⲚ ⲢⲚⲞⲂⲈ ⲈⲢⲞⲒ ⲦⲀⲔⲰ ⲚⲀϤ ⲈⲂⲞⲖ ϢⲀⲞⲨⲎⲢ ⲚⲤⲞⲠ. ϢⲀⲤⲀϢϤ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲚϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲀⲚ ϪⲈ ϢⲀⲤⲀϢϤ ⲚⲤⲞⲠ. ⲀⲖⲖⲀ ϢⲀⲤⲀϢϤ ⲚϢϤⲈ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲢⲢⲞ ⲠⲀⲒ ⲚⲦⲀϤⲞⲨⲰϢ ⲈϤⲒⲰⲠ ⲘⲚ ⲚⲈϤϨⲘϨⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ⲚⲦⲈⲢⲈϤⲀⲢⲬⲈⲒ ⲆⲈ ⲚϤⲒⲰⲠ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲀ ⲈⲢⲈϨⲀϨ ⲚϬⲒ ⲚϬⲰⲢ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ⲈⲘⲚⲦⲀϤⲤⲈ ⲆⲈ ⲈⲦⲀⲀⲨ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲆⲈ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ⲈⲦⲢⲈⲨⲦⲀⲀϤ ⲈⲂⲞⲖ ⲘⲚ ⲦⲈϤⲤϨⲒⲘⲈ ⲘⲚ ⲚⲈϤϢⲎⲢⲈ. ⲘⲚ ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲚⲦⲀϤ ⲚϤⲦⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ⲀϤⲠⲀϨⲦϤ ⲆⲈ ⲚϬⲒ ⲠϨⲘϨⲀⲖ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ϨⲢⲞϢ ⲚϨⲎⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ⲦⲀⲦⲀⲀⲨ ⲚⲀⲔ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ⲀϤϢⲚϨⲦⲎϤ ⲆⲈ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠϨⲘϨⲀⲖ ⲀϤⲔⲰ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲀⲨⲰ ⲠⲈⲦⲈⲢⲞϤ ⲦⲎⲢϤ ⲀϤⲔⲀⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲀϤϨⲈ ⲈⲞⲨⲀ ⲚⲚⲈϤϢⲂⲎⲢϨⲘϨⲀⲖ ⲠⲀⲒ ⲈⲚⲈⲨⲚⲦⲀϤ ⲈⲢⲞϤ ⲚϢⲈ ⲚⲤⲀⲦⲈⲈⲢⲈ. ⲀϤⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀϤⲰϬⲦ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨⲠⲈⲦⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ⲀϤⲠⲀϨⲦϤ ⲆⲈ ⲚϬⲒ ⲠⲈϤϢⲂⲎⲢϨⲘϨⲀⲖ ⲀϤⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲞϢ ⲚϨⲎⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ⲦⲀⲦⲀⲀⲨ ⲚⲀⲔ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ⲚⲦⲞϤ ⲆⲈ ⲘⲠⲈϤⲞⲨⲰϢ. ⲀⲖⲖⲀ ⲀϤⲂⲰⲔ ⲀϤⲚⲞϪϤ ⲈⲠⲈϢⲦⲈⲔⲞ ϢⲀⲚⲦⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ⲀⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈϤϢⲂⲎⲢϨⲘϨⲀⲖ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ⲀⲨⲖⲨⲠⲈⲒ ⲈⲘⲀⲦⲈ. ⲀⲨⲈⲒ ⲀⲨϪⲰ ⲈⲠⲈⲨϪⲞⲈⲒⲤ ⲚϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀⲨϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ⲦⲞⲦⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϨⲘϨⲀⲖ ⲘⲠⲞⲚⲎⲢⲞⲤ. ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲢⲞⲔ ⲀⲒⲔⲀⲀⲨ ⲚⲀⲔ ⲈⲂⲞⲖ ⲈⲦⲂⲈ ϪⲈ ⲀⲔⲤⲠⲤⲰⲠⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ⲚⲈϢϢⲈ ⲚⲦⲞⲔ ⲀⲚ ⲈⲢⲞⲔ ⲠⲈ ⲈⲚⲀ ⲘⲠⲈⲔϢⲂⲎⲢϨⲘϨⲀⲖ ⲚⲐⲈ ϨⲰ ⲚⲦⲀⲒⲚⲀ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ⲀϤⲚⲞⲨϬⲤ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ⲀϤϮ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲂⲀⲌⲀⲚⲒⲤⲦⲎⲤ ϢⲀⲚⲦⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲈⲦⲈϤⲚⲀⲀⲀⲤ ⲚⲎⲦⲚ ⲚϬⲒ ⲠⲀⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲈⲢⲦⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲔⲰ ⲈⲂⲞⲖ ⲘⲠⲈϤⲤⲞⲚ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲚⲚⲈⲒϢⲀϪⲈ. ⲀϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲚⲦⲞϢ ⲚϮⲞⲨⲆⲀⲒⲀ ⲠⲈⲔⲢⲞ ⲘⲠⲈⲒⲞⲢⲆⲀⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈⲈⲜⲈⲤⲦⲈⲒ ⲘⲠⲢⲰⲘⲈ ⲈⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲔⲀⲦⲀⲀⲒⲦⲒⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲦⲚⲞϢϤ ϪⲈ ⲠⲈⲚⲦⲀϤⲤⲰⲚⲦ ϪⲒⲚⲚϢⲞⲢⲠ ⲚⲦⲀϤⲦⲀⲘⲈⲒⲈⲞⲨϨⲞⲞⲨⲦ ⲘⲚⲞⲨⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ⲀⲨⲰ ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲢⲰⲘⲈ ⲚⲀⲔⲀⲠⲈϤⲈⲒⲰⲦ ⲚⲤⲰϤ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲚϤⲦⲰϬⲈ ⲘⲘⲞϤ ⲈⲦⲈϤⲤϨⲒⲘⲈ ⲚⲤⲈϢⲰⲠⲈ ⲘⲠⲈⲤⲚⲀⲨ ⲈⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ϨⲰⲤⲦⲈ ϬⲈ ⲚⲤⲚⲀⲨ ⲀⲚ ⲚⲈ. ⲀⲖⲖⲀ ⲞⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ ⲦⲈ. ⲠⲈⲚⲦⲀⲠⲚⲞⲨⲦⲈ ϬⲈ ϢⲞⲚⲂⲈϤ ⲘⲠⲢⲦⲢⲈⲚⲢⲰⲘⲈ ⲠⲞⲢϪϤ. ");
INSERT INTO copshc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ϬⲈ ⲀⲘⲰⲨⲤⲎⲤ ϨⲰⲚ ⲈⲦⲞⲞⲦⲚ ⲈϮ ⲚⲀⲨ ⲚⲞⲨϪⲰⲰⲘⲈ ⲚⲦⲞⲨⲈⲒⲞ ⲈⲚⲞϪⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲦⲈⲦⲚⲘⲚⲦⲚⲀϢⲦϨⲎⲦ ⲀⲘⲰⲨⲤⲎⲤ ϮⲦⲈϨⲒⲎ ⲚⲎⲦⲚ ⲈⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚϨⲒⲞⲘⲈ ϪⲒⲚⲦⲈϨⲞⲨⲈⲒⲦⲈ ⲆⲈ ⲘⲠⲈⲤϢⲰⲠⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲚⲀⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲀϪⲚϢⲀϪⲈ ⲘⲠⲞⲢⲚⲈⲒⲀ ⲚϤϨⲘⲞⲞⲤ ⲘⲚ ⲔⲈⲞⲨⲈⲒ ϤⲞ ⲚⲚⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ⲠⲈϪⲀⲨ ⲚⲀϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈϢϪⲈ ⲦⲀⲒ ⲦⲈ ⲦⲈⲦⲒⲀ ⲘⲠⲢⲰⲘⲈ ⲘⲚ ⲦⲈϤⲤϨⲒⲘⲈ ⲚⲤⲢⲚⲞϤⲢⲈ ⲀⲚ ⲈϪⲒϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲀϤⲒ ϨⲀⲠⲈⲒϢⲀϪⲈ. ⲀⲖⲖⲀ ⲚⲈⲚⲦⲀⲨⲦⲀⲀϤ ⲚⲀⲨ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ⲞⲨⲚϨⲈⲚⲤⲒⲞⲨⲢ ⲄⲀⲢ ⲚⲦⲀⲨϪⲠⲞⲞⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ ⲚⲦⲈⲨⲘⲀⲀⲨ ⲚⲦⲈⲒϨⲈ ⲀⲨⲰ ⲞⲨⲚϨⲈⲚⲤⲒⲞⲨⲢ ⲚⲀⲒ ⲚⲦⲀⲨⲀⲀⲨ ⲚⲤⲒⲞⲨⲢ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲞⲨ ⲚⲚⲢⲰⲘⲈ ⲀⲨⲰ ⲞⲨⲚϨⲈⲚⲤⲒⲞⲨⲢ ⲚⲀⲒ ⲚⲦⲀⲨⲀⲀⲨ ⲚⲤⲒⲞⲨⲢ ⲘⲘⲒⲚ ⲘⲘⲞⲞⲨ ⲈⲦⲂⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈϤⲒ ⲘⲀⲢⲈϤϤⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ⲦⲞⲦⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚϨⲈⲚϢⲎⲢⲈ ϢⲎⲘ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲦⲀⲖⲈⲚⲈϤϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲚϤϢⲖⲎⲖ. ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲔⲀⲚϢⲎⲢⲈ ϢⲎⲘ ⲀⲨⲰ ⲘⲠⲢⲔⲰⲖⲨ ⲘⲘⲞⲞⲨ ⲈⲦⲢⲈⲨⲈⲒ ϢⲀⲢⲞⲒ. ⲦⲀⲚⲀⲒ ⲄⲀⲢ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ⲀϤⲦⲀⲖⲈⲚⲈϤϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ⲈⲒⲤⲞⲨⲀ ⲆⲈ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲚⲀⲄⲀⲐⲞⲤ ⲞⲨ ⲠⲈϮⲚⲀⲀⲀϤ ϪⲈⲔⲀⲀⲤ ⲈⲒⲈϪⲒ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀϨⲢⲞⲔ ⲔⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ϪⲈ ⲠⲀⲄⲀⲐⲞⲤ ⲘⲚ ⲀⲄⲀⲐⲞⲤ ⲚⲤⲀⲞⲨⲀ ⲠⲚⲞⲨⲦⲈ. ⲈϢⲰⲠⲈ ⲆⲈ ⲔⲞⲨⲰϢ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ ϨⲀⲢⲈϨ ⲈⲚⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀϢ ⲚⲈ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲚⲈⲔϨⲰⲦⲂ ⲚⲚⲈⲔⲢⲚⲞⲈⲒⲔ ⲚⲚⲈⲔϪⲒⲞⲨⲈ ⲚⲚⲈⲔⲢⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ. ");
INSERT INTO copshc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ⲈⲔⲈⲦⲀⲈⲒⲈ ⲠⲈⲔⲈⲒⲰⲦ ⲘⲚ ⲦⲈⲔⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲄⲘⲈⲢⲈ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲚⲦⲈⲔϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠϨⲢϢⲒⲢⲈ ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ϪⲒⲚⲈⲦⲀⲘⲚⲦⲔⲞⲨⲒ. ⲞⲨ ⲞⲚ ⲠⲈϮϢⲀⲀⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲈϢϪⲈ ⲔⲞⲨⲰϢ ⲈⲢⲦⲈⲖⲒⲞⲤ. ⲂⲰⲔ ⲚⲄϮ ⲈⲂⲞⲖ ⲚⲚⲈⲔϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ ⲚⲄⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ ⲚⲄⲔⲰ ⲚⲀⲔ ⲚⲞⲨⲀϨⲞ ϨⲢⲀⲒ ϨⲚ ⲘⲠⲎⲨⲈ ⲚⲄⲈⲒ ⲚⲄⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲠϨⲢϢⲒⲢⲈ ⲈⲠϢⲀϪⲈ ⲀϤⲂⲰⲔ ⲈϤⲖⲨⲠⲈⲒ. ⲈⲚⲈⲨⲚⲦⲀϤ ⲄⲀⲢ ⲘⲘⲀⲨ ⲚϨⲀϨ ⲚⲚⲔⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲤⲘⲞⲔϨ ⲈⲦⲢⲈⲚⲢⲘⲘⲀⲞ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ⲠⲀⲖⲒⲚ ⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲤⲘⲞⲦⲚ ⲈⲦⲢⲈⲞⲨϬⲀⲘⲞⲨⲖ ⲈⲒ ⲈϨⲞⲨⲚ ϨⲒⲦⲚ ⲦⲞⲨⲀⲦϤⲈ ⲚⲞⲨϨⲀⲘⲚⲦⲰⲠ ⲈϨⲞⲨⲈⲈⲦⲢⲈⲞⲨⲢⲘⲘⲀⲞ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈⲘⲀⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲈⲒⲈⲚⲒⲘ ⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲦϬⲞⲘ ⲚⲚⲀϨⲢⲚ ⲚⲈⲢⲰⲘⲈ ⲠⲈ ⲠⲀⲒ. ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲘⲚ ⲖⲀⲀⲨ ⲞⲚⲀⲦϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ⲦⲞⲦⲈ ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲚ ⲀⲚⲔⲀ ⲚⲔⲀ ⲚⲒⲘ ⲚⲤⲰⲚ ⲀⲚⲞⲨⲀϨⲚ ⲚⲤⲰⲔ ⲞⲨ ⲀⲢⲀ ⲠⲈⲦⲚⲀϢⲰⲠⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲈⲚⲦⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰⲒ ϨⲢⲀⲒ ϨⲘ ⲠⲈϪⲠⲞ ⲚⲔⲈⲤⲞⲠ ⲈϤϢⲀⲚϨⲘⲞⲞⲤ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲐⲢⲞⲚⲞⲤ ⲘⲠⲈϤⲈⲞⲞⲨ ⲦⲈⲦⲚⲀϨⲘⲞⲞⲤ ϨⲰⲦⲦⲎⲨⲦⲚ ϨⲒⲠⲈⲦⲚⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲐⲢⲞⲚⲞⲤ ⲚⲦⲈⲦⲚ ⲔⲢⲒⲚⲈ ⲚⲦⲘⲚⲦⲤⲚⲞⲞⲨⲤⲈ ⲘⲪⲨⲖⲎ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲦⲀϤⲔⲀⲎⲒ ⲚⲤⲰϤ ⲎⲤⲞⲚ ⲎⲤⲰⲚⲈ ⲎⲈⲒⲰⲦ ⲎⲘⲀⲀⲨ ⲎⲤϨⲒⲘⲈ ⲎϢⲎⲢⲈ ⲎⲤⲰϢⲈ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ ϤⲚⲀϪⲒⲦⲞⲨ ⲚϨⲀϨ ⲚⲔⲰⲂ ⲀⲨⲰ ⲚϤⲔⲖⲎⲢⲞⲚⲞⲘⲈⲒ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ⲞⲨⲚϨⲀϨ ⲆⲈ ⲚϢⲞⲢⲠ ⲚⲀⲢϨⲀⲈ. ⲀⲨⲰ ⲚⲦⲈⲚϨⲀⲈ ⲢϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ⲈⲤⲦⲚⲦⲰⲚ ⲄⲀⲢ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲢⲘⲘⲀⲞ. ⲠⲀⲒ ⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈϨⲦⲞⲞⲨⲈ ⲈⲐⲚⲈⲈⲢⲄⲀⲦⲎⲤ ⲈⲠⲈϤⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ⲀϤⲤⲘⲚⲦⲤ ⲆⲈ ⲘⲚ ⲚⲈⲢⲄⲀⲦⲎⲤ ⲈⲨⲤⲀⲦⲈⲈⲢⲈ ⲘⲠⲈϨⲞⲞⲨ ⲀϤϪⲞⲞⲨⲤⲈ ⲈⲠⲈϤⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲚⲀⲨ ⲚϪⲠϢⲞⲘⲦⲈ ⲀϤⲚⲀⲨ ⲈϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ϨⲚ ⲦⲀⲄⲞⲢⲀ ⲈⲨⲞⲨⲞⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ⲠⲈϪⲀϤ ⲚⲚⲔⲞⲞⲨⲈ. ϪⲈ ⲂⲰⲔ ϨⲰⲦⲦⲎⲨⲦⲚ ⲈⲠⲀⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀⲨⲰ ⲠⲈⲦⲘⲠϢⲀ ϮⲚⲀⲦⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲂⲰⲔ. ⲀϤⲈⲒ ⲆⲈ ⲞⲚ ⲈⲂⲞⲖ ⲘⲠⲚⲀⲨ ⲚϪⲠⲤⲞ ⲘⲚ ϪⲠⲮⲒⲦⲈ ⲀϤⲈⲒⲢⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲞⲚ ⲈⲂⲞⲖ ⲘⲠⲚⲀⲨ ⲚϪⲠⲘⲚⲦⲞⲨⲈ. ⲀϤⲚⲀⲨ ⲈϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲀϨⲈⲢⲀⲦⲦⲎⲨⲦⲚ ⲘⲠⲈⲒⲘⲀ ⲘⲠⲈϨⲞⲞⲨ ⲦⲎⲢϤ ⲈⲦⲈⲦⲚⲞⲨⲞⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲈⲂⲞⲖ ϪⲈ ⲘⲠⲈⲖⲀⲀⲨ ⲐⲚⲞⲚ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ϨⲰⲦⲦⲎⲨⲦⲚ ⲈⲠⲀⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ. ⲠⲈϪⲀϤ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲘⲠⲈϤⲈⲠⲒⲦⲢⲞⲠⲞⲤ. ϪⲈ ⲘⲞⲨⲦⲈ ⲈⲚⲈⲢⲄⲀⲦⲎⲤ ⲚⲄϮ ⲚⲀⲨ ⲘⲠⲈⲨⲂⲈⲔⲈ ⲈⲀⲔⲀⲢⲬⲈⲒ ϪⲒⲚⲚϨⲀⲈⲈⲨ ϢⲀⲚⲦⲈⲔⲠⲰϨ ⲈⲚϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ⲀⲨⲈⲒ ⲆⲈ ⲚϬⲒ ⲚⲀϪⲠⲘⲚⲦⲞⲨⲈ ⲀⲨϪⲒ ⲚⲞⲨⲤⲀⲦⲈⲈⲢⲈ ⲈⲠⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ⲀⲨⲈⲒ ϨⲰⲞⲨ ⲚϬⲒ ⲚϢⲞⲢⲠ ⲈⲨⲘⲈⲈⲨⲈ ϪⲈ ⲈⲨⲚⲀϪⲒ ⲚⲞⲨϨⲞⲨⲞ. ⲀⲨϪⲒ ϨⲰⲞⲨ ⲚⲞⲨⲤⲀⲦⲈⲈⲢⲈ ⲈⲠⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ⲚⲦⲈⲢⲞⲨϪⲒⲦⲤ ⲆⲈ ⲀⲨⲔⲢⲘⲢⲘ ⲈϨⲞⲨⲚ ⲈⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲒϨⲀⲈⲈⲨ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲞⲨⲰⲦ ⲦⲈⲚⲦⲀⲨⲀⲀⲤ ⲀⲨⲰ ⲀⲔϢⲀϢⲞⲨ ⲚⲘⲘⲀⲚ ⲚⲀⲒ ⲚⲦⲀⲨϤⲒ ⲘⲠⲂⲀⲢⲞⲤ ⲘⲠⲈϨⲞⲞⲨ ⲘⲚ ⲠⲔⲀⲨⲤⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲚⲞⲨⲀ ⲘⲘⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈϢⲂⲎⲢ ⲚϮϪⲒ ⲘⲘⲞⲔ ⲀⲚ ⲚϬⲞⲚⲤ. ⲘⲎ ⲚⲦⲀⲒⲤⲘⲚⲦⲤ ⲚⲘⲘⲀⲔ ⲀⲚ ⲈⲨⲤⲀⲦⲈⲈⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ϤⲒ ⲘⲠⲈⲦⲈⲠⲰⲔ ⲠⲈ ⲚⲄⲂⲰⲔ. ϮⲞⲨⲰϢ ⲆⲈ ⲀⲚⲞⲔ ⲈϮ ⲘⲠⲈⲒϨⲀⲈ ⲚⲦⲈⲔϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ⲎⲞⲨⲔ ⲈⲜⲈⲤⲦⲈⲒ ⲚⲀⲒ ⲈⲢⲠⲈϮⲞⲨⲀϢϤ ϨⲚ ⲚⲈⲦⲈⲚⲞⲨⲒ ⲚⲈ. ⲎⲈⲢⲈ ⲠⲈⲔⲂⲀⲖ ⲞⲘⲠⲞⲚⲎⲢⲞⲤ ϪⲈ ⲀⲚⲄⲞⲨⲀⲄⲀⲐⲞⲤ ⲀⲚⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲢⲈ ⲚϢⲞⲢⲠ ⲚⲀⲢϨⲀⲈ ⲚⲦⲈⲚϨⲀⲈ ⲢϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀϤϪⲒ ⲘⲠⲈϤⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲘⲀⲨⲀⲀⲨ. ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲦⲈϨⲒⲎ ⲠⲈϪⲀϤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲚⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨⲰ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲤⲈⲦϬⲀⲒⲞϤ ⲈⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ⲚⲤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲤⲰⲂⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲚⲤⲈⲘⲀⲤⲦⲒⲄⲞⲨ ⲘⲘⲞϤ ⲀⲨⲰ ⲚⲤⲈⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ⲦⲞⲦⲈ ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲦⲘⲀⲀⲨ ⲚⲚϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲘⲚ ⲚⲈⲤϢⲎⲢⲈ ⲈⲤⲞⲨⲰϢⲦ ⲚⲀϤ ⲀⲨⲰ ⲈⲤⲀⲒⲦⲈⲒ ⲚⲞⲨϨⲰⲂ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲈⲢⲞⲨⲈϢⲞⲨ ⲚⲦⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲀϪⲒⲤ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲠⲀϢⲎⲢⲈ ⲤⲚⲀⲨ ⲚⲀϨⲘⲞⲞⲤ ⲞⲨⲀ ϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞⲔ ⲀⲨⲰ ⲞⲨⲀ ϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞⲔ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲔⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲒⲦⲈⲒ ⲘⲘⲞϤ ⲞⲨⲚϢϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲤⲈⲠϪⲰ ⲈϮⲚⲀⲤⲞⲞϤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲀϪⲰ ⲘⲈⲚ ⲦⲈⲦⲚⲀⲤⲞⲞϤ. ⲠⲈϨⲘⲞⲞⲤ ⲆⲈ ϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ⲎϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞⲒ ⲘⲠⲰⲒ ⲀⲚ ⲠⲈ ⲈⲦⲀⲀϤ ⲀⲖⲖⲀ ⲠⲀⲚⲈⲚⲦⲀⲨⲤⲂⲦⲰⲦϤ ⲚⲀⲨ ⲚⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲘⲠⲀⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲠⲘⲎⲦ ⲀⲨⲀⲄⲀⲚⲀⲔⲦⲈⲒ ⲈⲦⲂⲈ ⲠⲤⲞⲚ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲚⲀⲢⲬⲰⲚ ⲚⲚϨⲈⲐⲚⲞⲤ ⲤⲈⲞ ⲚϪⲞⲈⲒⲤ ⲈⲢⲞⲞⲨ. ⲀⲨⲰ ⲚⲚⲞϬ ⲤⲈⲞ ⲚⲦⲈⲨⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ⲚⲦⲈⲒϨⲈ ⲚⲦⲰⲦⲚ ⲀⲚ ⲦⲈⲦϢⲞⲞⲠ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲀⲖⲖⲀ ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲈϢⲰⲠⲈ ⲚⲚⲞϬ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲚⲆⲒⲀⲔⲞⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲈϢⲰⲠⲈ ⲚϢⲞⲢⲠ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲚϨⲘϨⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ⲚⲐⲈ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲦⲀϤⲈⲒ ⲀⲚ ⲈⲦⲢⲈⲨⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀϤ. ⲀⲖⲖⲀ ⲈⲆⲒⲀⲔⲞⲚⲈⲒ. ⲀⲨⲰ ⲈϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲚⲤⲰⲦⲈ ϨⲀϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ⲈϤⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ϨⲒⲈⲢⲒⲬⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲂⲖⲖⲈ ⲤⲚⲀⲨ ⲈⲨϨⲘⲞⲞⲤ ϨⲀⲦⲚⲦⲈϨⲒⲎ. ⲀⲨⲤⲰⲦⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲠⲀⲢⲀⲄⲈ. ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀ ⲚⲀⲚ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲀⲨⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲔⲀⲢⲰⲞⲨ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀ ⲚⲀⲚ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ⲀϤⲀϨⲈⲢⲀⲦϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲞⲨⲈϢ ⲦⲢⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲞⲨⲰⲚ ⲚϬⲒ ⲚⲈⲚⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ⲀϤϢⲚϨⲦⲎϤ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϪⲰϨ ⲈⲚⲈⲨⲂⲀⲖ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ⲚⲦⲈⲢⲞⲨϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲂⲎⲆⲪⲀⲄⲎ ⲈⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ. ⲦⲞⲦⲈ ⲀϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲤⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒϮⲘⲈ ⲈⲦⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲦⲈⲦⲚⲀϨⲈ ⲈⲨⲈⲰ ⲈⲤⲘⲎⲢ ⲘⲚⲞⲨⲤⲎϬ ⲚⲘⲘⲀⲤ ⲂⲞⲖⲞⲨ ⲚⲦⲈⲦⲚ ⲚⲦⲞⲨ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ⲈⲢϢⲀⲚⲞⲨⲀ ⲆⲈ ϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ⲀϪⲒⲤ ϪⲈ ⲠⲈⲨϪⲞⲈⲒⲤ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲚⲀⲨ. ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ϤⲚⲀⲦⲚⲞⲞⲨⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ⲠⲀⲒ ⲆⲈ ⲦⲎⲢϤ ⲚⲦⲀϤϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ϪⲈ ⲀϪⲒⲤ ⲚⲦϢⲈⲈⲢⲈ ⲚⲤⲒⲰⲚ ϪⲈ ⲈⲒⲤ ⲠⲞⲨⲢⲢⲞ ⲚⲎⲨ ⲚⲈ. ⲞⲨⲢⲘⲢⲀϢ ⲠⲈ. ⲈϤⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲈⲰ ⲀⲨⲰ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲤⲎϬ ⲚϢⲎⲢⲈ ⲚϤⲀⲒⲚⲀϨⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ⲀⲨⲂⲰⲔ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲒⲢⲈ ⲔⲀⲦⲀⲐⲈ ⲚⲦⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ⲀⲨⲈⲒⲚⲈ ⲚⲦⲈⲰ ⲘⲚ ⲠⲤⲎϬ ⲀⲨⲦⲀⲖⲈ ⲚⲈⲨϨⲞⲒⲦⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀⲨⲰ ⲀϤⲦⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲈⲦⲚⲀϢⲰϤ. ⲀⲨⲠⲰⲢϢ ⲚⲚⲈⲨϨⲞⲒⲦⲈ ϨⲢⲀⲒ ϨⲚ ⲦⲈϨⲒⲎ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϢⲰⲰⲦ ⲚϨⲈⲚⲔⲖⲀⲆⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚϢⲎⲚ ⲈⲨⲠⲰⲢϢ ⲘⲘⲞⲞⲨ ϨⲢⲀⲒ ϨⲚ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲈⲦⲘⲞⲞϢⲈ ϨⲀⲦⲈϤϨⲎ ⲘⲚ ⲚⲈⲦⲞⲨⲎϨ ⲚⲤⲰϤ ⲚⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲤⲀⲚⲚⲀ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲈⲦⲚⲎⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲰⲤⲀⲚⲚⲀ ϨⲚ ⲚⲈⲦϪⲞⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲤⲚⲞⲈⲒⲚ ⲚϬⲒ ⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲒⲎⲤⲞⲨⲤ. ⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ ⲚⲦⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲢⲠⲈ ⲀϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϮ ⲈⲂⲞⲖ ⲘⲚ ⲚⲈⲦϢⲰⲠ ϨⲢⲀⲒ ϨⲘ ⲠⲢⲠⲈ. ⲚⲈⲦⲢⲀⲠⲈⲌⲀ ⲚⲚⲈⲦϪⲒⲔⲞⲖⲨⲘⲂⲞⲚ ⲀϤϢⲢϢⲰⲢⲞⲨ ⲘⲚ ⲚⲔⲀⲐⲈⲆⲢⲀ ⲚⲚⲈⲦϮ ⲈⲂⲞⲖ ⲚⲚⲈϬⲢⲞⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϤⲤⲎϨ ϪⲈ ⲠⲀⲎⲒ ⲈⲨⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲎⲒ ⲘⲠⲈϢⲖⲎⲖ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲀⲦⲈⲦⲚⲀⲀϤ ⲚⲤⲠⲞⲒⲖⲀⲒⲞⲚ ⲚⲤⲞⲞⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲈⲢⲞϤ ⲚⲂⲖⲖⲈ ⲘⲚ ⲚϬⲀⲖⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲢⲠⲈ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲚⲈϢⲠⲎⲢⲈ ⲚⲦⲀϤⲀⲀⲨ ⲀⲨⲰ ⲚϢⲎⲢⲈ ϢⲎⲘ ⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲤⲀⲚⲚⲀ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ⲀⲨⲀⲔⲀⲚⲀⲄⲦⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲔⲤⲰⲦⲘ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲢⲈⲚⲀⲒ ϪⲰ ⲘⲘⲞϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲤⲈ ⲘⲠⲈⲦⲚⲞϢϤ ⲈⲚⲈϨ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲚϢⲎⲢⲈ ⲔⲞⲨⲒ ⲘⲚ ⲚⲈⲦϪⲒⲈⲔⲒⲂⲈ ⲀⲔⲤⲞϤⲦⲈ ⲚⲞⲨⲤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ⲀϤⲔⲰ ⲆⲈ ⲘⲘⲞⲞⲨ ⲚⲤⲰϤ ⲀϤⲈⲒ ⲈⲠⲤⲀ ⲚⲂⲞⲖ ⲈⲦⲠⲞⲖⲒⲤ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲀϤϢⲰⲠⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ϨⲦⲞⲞⲨ ⲆⲈ ⲈϤⲚⲀⲔⲞⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ ⲀϤϨⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲨⲂⲰ ⲚⲔⲚⲦⲈ ϨⲒⲦⲈϨⲒⲎ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ⲘⲠⲈϤϨⲈ ⲈⲖⲀⲀⲨ ϨⲒⲰⲰⲤ ⲈⲒⲘⲎⲦⲒ ϨⲈⲚϬⲰⲂⲈ ⲘⲀⲨⲀⲀⲨ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲚⲚⲈ ⲔⲀⲢⲠⲞⲤ ϢⲰⲠⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲈ ϪⲒⲚⲦⲈⲚⲞⲨ ϢⲀ ⲈⲚⲈϨ. ⲀⲤϢⲞⲞⲨⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲚϬⲒ ⲦⲂⲰ ⲚⲔⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ⲀⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲀⲤϢⲞⲞⲨⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲚϬⲒ ⲦⲂⲰ ⲚⲔⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲠⲒⲤⲦⲒⲤ ⲘⲘⲀⲨ ⲀⲨⲰ ⲚⲦⲈⲦⲚⲦⲘⲢ ϨⲎⲦ ⲤⲚⲀⲨ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲦⲈⲦⲚⲀⲈⲒⲢⲈ ⲘⲠⲀⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲀⲖⲖⲀ ⲔⲀⲚ ⲈⲦⲈⲦⲚϢⲀⲚϪⲞⲞⲤ ⲘⲠⲈⲒⲦⲞⲞⲨ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲀⲖⲀⲤⲤⲀ ⲤⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ⲀⲨⲰ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲈⲦⲚⲀⲀⲒⲦⲈⲒ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲈϢⲖⲎⲖ ⲈⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲦⲈⲦⲚⲚⲀϪⲒⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲢⲠⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲈϤϮⲤⲂⲰ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲖⲀⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ ⲈⲔⲈⲒⲢⲈ ⲚⲚⲀⲒ ⲀⲨⲰ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤϮ ⲚⲀⲔ ⲚⲦⲈⲒⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϪⲚⲈⲦⲎⲨⲦⲚ ⲈⲨϢⲀϪⲈ ⲚⲞⲨⲰⲦ. ⲠⲀⲒ ⲈⲦⲈⲦⲚϢⲀⲚϪⲞⲞϤ ⲚⲀⲒ. ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲒⲈⲒⲢⲈ ⲚⲚⲀⲒ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠⲈ ϪⲚⲞⲨⲈⲂⲞⲖ ϨⲚ ⲚⲈⲢⲰⲘⲈ ⲠⲈ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲘⲈⲈⲨⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠⲈ ϤⲚⲀϪⲞⲞⲤ ⲚⲀⲚ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ϬⲈ ⲘⲠⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ⲈϢⲰⲠⲈ ϬⲈ ⲈⲚϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲚⲈⲢⲰⲘⲈ ⲠⲈⲦⲚⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲘⲎⲎϢⲈ. ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲢⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲦⲞⲞⲦⲞⲨ ϨⲰⲤ ⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ. ⲚⲦⲞϤ ⲆⲈ ϨⲰⲰϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲚⲞⲔ ϨⲰⲰⲦ ⲞⲚ ⲚϮⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ⲀⲚ ϪⲈ ⲈⲒⲈⲒⲢⲈ ⲚⲚⲀⲒ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲎⲦⲚ ⲞⲨⲢⲰⲘⲈ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚϢⲎⲢⲈ ⲤⲚⲀⲨ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲠϢⲞⲢⲠ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϢⲎⲢⲈ ⲂⲰⲔ ⲘⲠⲞⲞⲨ ⲚⲄⲢϨⲰⲂ ⲈⲠⲀⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲚⲞ. ⲘⲚⲚⲤⲰⲤ ⲀϤⲢϨⲦⲎϤ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲞⲚ ⲈⲠⲔⲈⲞⲨⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϨⲒⲚⲀⲒ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲚⲀⲂⲰⲔ ⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲘⲠⲈϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ⲚⲒⲘ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲘⲠⲈⲤⲚⲀⲨ ⲠⲈⲚⲦⲀϤⲈⲒⲢⲈ ⲘⲠⲞⲨⲰϢ ⲘⲠⲈϤⲈⲒⲰⲦ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠϢⲞⲢⲠ ⲠⲈ. ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲦⲈⲖⲰⲚⲎⲤ ⲘⲚ ⲘⲠⲞⲢⲚⲎ ⲤⲈⲞ ⲚϢⲞⲢⲠ ⲈⲢⲰⲦⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ⲀϤⲈⲒ ⲄⲀⲢ ϢⲀⲢⲰⲦⲚ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ϨⲚ ⲦⲈϨⲒⲎ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲚⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲘⲚ ⲘⲠⲞⲢⲚⲎ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲘⲚⲚⲤⲰⲤ ⲚⲦⲈⲢⲈⲦⲈⲦⲚⲚⲀⲨ ⲘⲠⲈⲦⲚⲢϨⲦⲎⲦⲚ ⲈⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ⲤⲰⲦⲘ ⲈⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲞⲨⲢⲰⲘⲈ ⲚⲢⲘⲘⲀⲞ ⲠⲈⲚⲦⲀϤⲦⲰϬⲈ ⲚⲞⲨⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀϤⲔⲦⲞ ⲈⲢⲞϤ ⲚⲞⲨϪⲞⲖϪⲖ. ⲀϤϢⲒⲔⲈ ⲚⲞⲨϨⲢⲰⲦ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲀϤⲔⲰⲦ ⲚⲞⲨⲠⲨⲢⲄⲞⲤ. ⲀϤϮ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦϤ ⲚϨⲈⲚⲞⲨⲈⲈⲒⲎ ⲀϤⲀⲠⲞⲆⲎⲘⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲈⲨⲞⲈⲒϢ ⲚⲚⲔⲀⲢⲠⲞⲤ ⲀϤϪⲞⲞⲨ ⲚⲚⲈϤϨⲘϨⲀⲖ ϢⲀⲚⲞⲨⲈⲈⲒⲎ ⲈϪⲒ ⲚⲚⲈϤⲔⲀⲢⲠⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ⲚⲞⲨⲈⲈⲒⲎ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲨϪⲒ ⲚⲚⲈϤϨⲘϨⲀⲖ ⲞⲨⲀ ⲘⲈⲚ ⲀⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ ⲔⲈⲞⲨⲀ ⲆⲈ ⲀⲨⲘⲞⲞⲨⲦϤ ⲔⲈⲞⲨⲀ ⲆⲈ ⲀⲨϨⲒⲰⲚⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲞⲞⲨ ⲚϨⲚⲔⲈϨⲘϨⲀⲖ ⲈⲚⲀϢⲰⲞⲨ ⲈⲚϢⲞⲢⲠ. ⲀⲨⲈⲒⲢⲈ ⲞⲚ ⲚⲀⲨ ⲔⲀⲦⲀⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ⲘⲚ ⲚⲤⲰⲤ ⲀϤϪⲞⲞⲨ ϢⲀⲢⲞⲞⲨ ⲘⲠⲈϤϢⲎⲢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲚⲀϢⲒⲠⲈ ϨⲎⲦϤ ⲘⲠⲀϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ⲚⲞⲨⲈⲈⲒⲎ ⲆⲈ ⲠⲈϪⲀⲨ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ. ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ. ⲀⲘⲎⲒⲦⲚ ⲚⲦⲈⲚⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ ⲚⲦⲚϪⲒ ⲚⲦⲈϤⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ⲀⲨϪⲒ ⲘⲘⲞϤ ⲀⲨⲚⲞⲨϪⲈ ⲆⲈ ⲘⲘⲞϤ ⲠⲂⲞⲖ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀⲨⲰ ⲀⲨⲘⲞⲞⲨⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ϨⲞⲦⲀⲚ ϬⲈ ⲈϤϢⲀⲚⲈⲒ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲈϤⲚⲀⲢⲞⲨ ⲚⲚⲞⲨⲈⲈⲒⲎ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲔⲀⲔⲒⲚ ⲔⲀⲔⲰⲤ ϤⲚⲀⲦⲀⲔⲞⲞⲨ. ⲀⲨⲰ ⲚϤϮ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚϨⲈⲚⲔⲈⲞⲨⲈⲈⲒⲎ. ⲚⲀⲒ ⲈⲦⲚⲀϮ ⲚⲀϤ ⲚⲚⲔⲀⲢⲠⲞⲤ ϨⲚ ⲚⲈⲨⲞⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲠⲈⲦⲚⲞϢϤ ⲈⲚⲈϨ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ϪⲈ ⲠⲰⲚⲈ ⲚⲦⲀⲨⲤⲦⲞϤ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲦⲔⲰⲦ ⲠⲀⲒ ⲀϤϢⲰⲠⲈ ⲈⲨⲀⲠⲈ ⲚⲔⲞⲞϨ ⲠⲀⲒ ⲚⲦⲀϤϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲞⲨϢⲠⲎⲢⲈ ⲠⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ⲈⲦⲂⲈ ⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲤⲈⲚⲀϤⲒ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲦⲈⲦⲎⲨⲦⲚ ⲚⲤⲈϮ ⲘⲘⲞⲤ ⲚⲞⲨϨⲈⲐⲚⲞⲤ ⲈϤⲈⲒⲢⲈ ⲚⲚⲈⲤⲔⲀⲢⲠⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ⲠⲈⲦⲚⲀϨⲈ ⲆⲈ ⲈϪⲘ ⲠⲈⲒⲰⲚⲈ ϤⲚⲀⲖⲰⲰⲤ ⲀⲨⲰ ⲠⲈⲦⲈⲢⲈ ⲠⲰⲚⲈ ⲚⲀϨⲈ ⲈϪⲰϤ ϤⲚⲀϢⲀϢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲚⲈϤⲠⲀⲢⲀⲂⲞⲖⲎ ⲀⲨⲈⲒⲘⲈ ϪⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲦⲂⲎⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ⲀⲨⲰ ⲈⲨϢⲒⲚⲈ ⲚⲤⲀⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨⲢϨⲞⲦⲈ ϨⲎⲦⲞⲨ ⲚⲘⲘⲎⲎϢⲈ. ⲈⲂⲞⲖ ϪⲈ ⲚⲈϤⲚⲦⲞⲞⲦⲞⲨ ϨⲰⲤ ⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϨⲒⲦⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ϪⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲢⲢⲞ. ⲠⲀⲒ ⲚⲦⲀϤⲈⲒⲢⲈ ⲚⲞⲨϢⲈⲖⲈⲈⲦ ⲘⲠⲈϤϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ⲀϤϪⲞⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲈϤϨⲘϨⲀⲖ ⲈⲦⲰϨⲘ ⲈⲚⲈⲦⲦⲀϨⲘ ⲈⲦϢⲈⲖⲈⲈⲦ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲞⲨⲰϢ ⲈⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲞⲞⲨ ⲚϨⲈⲚⲔⲈϨⲘϨⲀⲖ ⲈⲚⲀϢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϪⲒⲤ ⲚⲚⲈⲦⲦⲀϨⲘ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲠⲀⲀⲢⲒⲤⲦⲞⲚ ⲀⲒⲤⲂⲦⲰⲦϤ ⲚⲀⲘⲀⲤⲈ ⲘⲚ ⲚⲈⲦⲤⲀⲚⲀϢⲦ ⲤⲈϢⲀⲀⲦ ⲀⲨⲰ ⲚⲔⲀ ⲚⲒⲘ ⲤⲂⲦⲰⲦ ⲀⲘⲎⲒⲦⲚ ⲈⲦϢⲈⲖⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲀⲘⲈⲖⲈⲒ ⲀⲨⲂⲰⲔ. ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲈⲚⲈⲨϬⲞⲞⲘ. ⲔⲈⲞⲨⲀ ⲆⲈ ⲈⲦⲈϤⲈⲒⲈⲠϢⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ⲠⲔⲈⲤⲈⲈⲠⲈ ⲆⲈ ⲀⲨⲀⲘⲀϨⲦⲈ ⲚⲚⲈϤϨⲘϨⲀⲖ ⲀⲨⲤⲞⲤⲞⲨ ⲀⲨⲰ ⲀⲨⲘⲞⲞⲨⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ⲠⲢⲢⲞ ⲆⲈ ⲀϤⲚⲞⲨϬⲤ. ⲀⲨⲰ ⲀϤϪⲞⲞⲨ ⲚⲚⲈϤⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲀϤⲦⲀⲔⲞ ⲚⲚⲢⲈϤϨⲰⲦⲂ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲰ ⲀϤⲢⲰⲔϨ ⲚⲦⲈⲨⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤϨⲘϨⲀⲖ. ϪⲈ ⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ ⲘⲈⲚ ⲤⲂⲦⲰⲦ ⲚⲈⲦⲦⲀϨⲘ ⲆⲈ ⲚⲈⲨⲘⲠϢⲀ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ⲂⲰⲔ ϬⲈ ⲈⲂⲞⲖ ⲈⲘⲘⲀ ⲚⲘⲞⲞϢⲈ ⲚⲚⲈϨⲒⲞⲞⲨⲈ ⲚⲦⲈⲦⲚ ⲦⲰϨⲘ ⲚⲚⲈⲦⲈⲦⲚⲚⲀϨⲈ ⲈⲢⲞⲞⲨ ⲈⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ⲀⲨⲈⲒ ϬⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲚϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲈϨⲒⲞⲞⲨⲈ ⲀⲨϪⲒ ⲈϨⲞⲨⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲦⲀⲨϨⲈ ⲈⲢⲞⲞⲨ ⲠⲞⲚⲎⲢⲞⲤ ϨⲒⲀⲄⲀⲐⲞⲤ. ⲀϤⲘⲞⲨϨ ⲚϬⲒ ⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ ⲚⲚⲈⲦⲚⲎϪ. ");
INSERT INTO copshc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲢⲢⲞ ⲈⲚⲀⲨ ⲈⲚⲈⲦⲚⲎϪ. ⲀϤⲚⲀⲨ ⲈⲨⲢⲰⲘⲈ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲘⲚϨⲂⲤⲰ ϨⲒⲰⲰϤ ⲘⲘⲀ ⲚϢⲈⲖⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈϢⲂⲎⲢ ⲚⲀϢ ⲚϨⲈ ⲀⲔⲈⲒ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲘⲀ ⲈⲘⲚϨⲂⲤⲰ ϨⲒⲰⲰⲔ ⲘⲘⲀ ⲚϢⲈⲖⲈⲈⲦ. ⲚⲦⲞϤ ⲆⲈ ⲀⲢⲰϤ ⲦⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ⲠⲈϪⲀϤ ⲚϬⲒ ⲠⲢⲢⲞ ⲚⲚⲈⲦⲆⲒⲀⲔⲞⲚⲈⲒ ϪⲈ ⲘⲞⲨⲢ ⲚⲚⲈϤϬⲒϪ ⲘⲚ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲚⲦⲈⲦⲚ ⲚⲞⲨϪⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲈⲠⲔⲀⲔⲈ ⲈⲦϨⲒⲂⲞⲖ. ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ. ⲀⲨⲰ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ϨⲀϨ ⲄⲀⲢ ⲚⲈⲦⲦⲀϨⲘ ϨⲈⲚⲔⲞⲨⲒ ⲆⲈ ⲚⲈⲦⲤⲞⲦⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ⲦⲞⲦⲈ ⲀⲨⲂⲰⲔ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨϪⲒ ⲚⲞⲨϢⲞϪⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϬⲞⲠϤ ϨⲚ ⲞⲨϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ⲀⲨϪⲞⲞⲨ ⲚⲀϤ ⲚⲚⲈⲨⲘⲀⲐⲎⲦⲎⲤ ⲘⲚ ⲚϨⲎⲢⲰⲆⲒⲀⲚⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲔⲞⲨⲘⲈ ⲀⲨⲰ ⲦⲈϨⲒⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲔϮⲤⲂⲰ ⲚϨⲎⲦⲤ ϨⲚ ⲞⲨⲘⲈ ⲀⲨⲰ ⲘⲠⲈⲔⲢⲞⲞⲨϢ ⲀⲚ ⲠⲈ ϨⲀⲖⲀⲀⲨ ⲚⲈⲔϬⲰϢⲦ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲈϨⲞ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ⲀϪⲒⲤ ϬⲈ ⲚⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲀⲔ. ⲈⲜⲈⲤⲦⲈⲒ ⲈϮⲔⲨⲚⲤⲞⲤ ⲘⲠⲢⲢⲞ ϪⲚⲞⲨⲔ ⲈⲜⲈⲤⲦⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲈⲨⲠⲞⲚⲎⲢⲒⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞⲒ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ⲘⲀⲦⲞⲨⲞⲒ ⲈⲠⲚⲞⲘⲒⲤⲘⲀ ⲘⲠⲔⲨⲚⲤⲞⲤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲤⲀⲦⲈⲈⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲦⲀⲚⲒⲘ ⲦⲈ ⲦⲈⲒϨⲒⲔⲰⲚ ⲘⲚ ⲦⲈⲒⲈⲠⲈⲒⲄⲢⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲦⲀⲠⲢⲢⲞ ⲦⲈ. ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ Ϯ ϬⲈ ⲚⲚⲀⲠⲢⲢⲞ ⲘⲠⲢⲢⲞ. ⲀⲨⲰ ⲚⲀⲠⲚⲞⲨⲦⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨⲢϢⲠⲎⲢⲈ. ⲀⲨⲰ ⲀⲨⲔⲰ ⲘⲘⲞϤ ⲀⲨⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ϨⲘⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ⲚⲀⲒ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲀϢⲰⲠⲈ. ⲀⲨϪⲚⲞⲨϤ ⲆⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ. ⲀϤϪⲞⲞⲤ ⲚϬⲒ ⲘⲰⲨⲤⲎⲤ ϪⲈ ⲈϢⲰⲠⲈ ⲈⲢϢⲀⲚⲞⲨⲀ ⲘⲞⲨ ⲈⲘⲚⲦϤϢⲎⲢⲈ ⲘⲘⲀⲨ ⲈⲢⲈⲠⲈϤⲤⲞⲚ ϪⲒ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲚϤⲦⲞⲨⲚⲞⲤ ⲚⲞⲨⲤⲠⲈⲢⲘⲀ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ⲈⲚⲈⲨϢⲞⲞⲠ ⲆⲈ ϨⲀⲦⲎⲚ ⲠⲈ ⲚϬⲒ ⲤⲀϢϤ ⲚⲤⲞⲚ. ⲀⲨⲰ ⲠϢⲞⲢⲠ ⲀϤϪⲒϨⲒⲘⲈ ⲀϤⲘⲞⲨ ⲀⲨⲰ ⲈⲘⲚⲦϤϢⲎⲢⲈ ⲘⲘⲀⲨ ⲀϤⲔⲰ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ϨⲞⲘⲞⲒⲰⲤ ⲠⲘⲈϨⲤⲚⲀⲨ ⲀⲨⲰ ⲠⲘⲈϨϢⲞⲘⲚⲦ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲘⲈϨⲤⲀϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ⲘⲚⲚⲤⲰⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲤⲘⲞⲨ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ϨⲢⲀⲒ ϬⲈ ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲈⲤⲚⲀϢⲰⲠⲈ ⲚⲤϨⲒⲘⲈ ⲚⲚⲒⲘ ⲘⲠⲤⲀϢϤ. ⲀⲨϪⲒⲦⲤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲈⲦⲚⲠⲖⲀⲚⲀ ⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲚⲈⲄⲢⲀⲪⲎ. ⲞⲨⲦⲈ ⲦϬⲞⲘ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ϨⲢⲀⲒ ⲄⲀⲢ ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ⲞⲨⲦⲈ ⲘⲈⲨϪⲒⲤϨⲒⲘⲈ. ⲞⲨⲦⲈ ⲘⲈⲨϨⲘⲞⲞⲤ ⲘⲚ ϨⲀⲒ ⲀⲖⲖⲀ ⲈⲨⲚⲀϢⲰⲠⲈ ⲚⲐⲈ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲦϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ⲈⲦⲂⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲆⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ⲘⲠⲈⲦⲚⲰϢ ⲘⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲤⲀⲀⲔ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲀⲔⲰⲂ. ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲠⲀⲚⲈⲦⲞⲚϨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲀϤϢⲦⲘⲢⲰⲞⲨ ⲚⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲀⲨⲤⲰⲞⲨϨ ⲈⲚⲈⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ⲀϤϪⲚⲞⲨϤ ⲚϬⲒ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲞⲨⲚⲞⲘⲰⲆⲒⲆⲀⲤⲔⲀⲖⲞⲤ ⲈϤⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ϪⲈ ⲠⲤⲀϨ ⲀϢ ⲦⲈ ⲦⲚⲞϬ ⲚⲈⲚⲦⲞⲖⲎ ϨⲢⲀⲒ ϨⲘ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲔⲈⲘⲈⲢⲈⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈⲔϨⲎⲦ ⲦⲎⲢϤ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲔⲘⲈⲈⲨⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ⲦⲀⲒ ⲦⲈ ⲦⲚⲞϬ ⲀⲨⲰ ⲦϢⲞⲢⲠ ⲈⲚⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ⲦⲘⲈϨⲤⲚⲦⲈ ⲆⲈ ⲈⲦⲈⲒⲚⲈ ⲘⲘⲞⲤ ⲦⲈ ⲦⲀⲒ ϪⲈ ⲈⲔⲈⲘⲈⲢⲈ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲚⲦⲈⲔϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲨⲀϢⲈ ϨⲚ ⲦⲈⲒⲈⲚⲦⲞⲖⲎ ⲤⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ⲈⲨⲤⲞⲞⲨϨ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀϤϪⲚⲞⲨⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲎⲦⲚ ⲈⲦⲂⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠϢⲎⲢⲈ ⲚⲚⲒⲘ ⲠⲈ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲆⲀⲨⲈⲒⲆ ⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ϪⲈ ⲠⲈϪⲈⲠϪⲞⲈⲒⲤ ⲘⲠⲀϪⲞⲈⲒⲤ ϪⲈ ϨⲘ ⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ϢⲀⲚϮⲔⲰ ⲚⲚⲈⲔϪⲒⲚϪⲈⲈⲨⲈ ϨⲀⲠⲈⲤⲎⲦ ⲚⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ⲈϢϪⲈ ⲆⲀⲨⲈⲒⲆ ϬⲈ ⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀϢ ⲚϨⲈ ⲠⲈϤϢⲎⲢⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ⲀⲨⲰ ⲘⲠⲈⲖⲀⲀⲨ ϬⲘϬⲞⲘ ⲈⲞⲨⲞϢⲂⲈϤ ⲚⲞⲨϢⲀϪⲈ ⲞⲨⲦⲈ ⲘⲠⲈⲖⲀⲀⲨ ⲦⲞⲖⲘⲀ ϪⲒⲚⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈϪⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ⲦⲞⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲀϤϢⲀϪⲈ ⲘⲚ ⲘⲘⲎⲎϢⲈ ⲀⲨⲰ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϨⲘⲞⲞⲤ ϨⲒⲦⲔⲀⲐⲈⲆⲢⲀ ⲘⲘⲰⲨⲤⲎⲤ ⲚϬⲒ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲞⲨⲚⲀϪⲞⲞⲨ ⲚⲎⲦⲚ ⲀⲢⲒⲤⲞⲨ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲘⲠⲢⲈⲒⲢⲈ ⲆⲈ ⲚⲦⲞϤ ⲔⲀⲦⲀⲚⲈⲨϨⲂⲎⲨⲈ ⲤⲈϪⲰ ⲄⲀⲢ ⲀⲨⲰ ⲚⲤⲈⲈⲒⲢⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ⲤⲈⲘⲞⲨⲢ ⲆⲈ ⲚϨⲈⲚⲈⲦⲠⲰ ⲈⲨϨⲞⲢϢ ⲀⲨⲰ ⲈⲨⲘⲞⲔϨ ⲚϤⲒⲦⲞⲨ. ⲤⲈⲦⲀⲖⲞ ⲘⲘⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲚⲀϨⲂⲈ ⲚⲚⲈⲢⲰⲘⲈ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲤⲈⲞⲨⲰϢ ⲀⲚ ⲈⲔⲒⲘ ⲈⲢⲞⲞⲨ ⲚⲞⲨⲀ ⲚⲚⲈⲨⲦⲎⲎⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ϨⲰⲂ ⲆⲈ ⲚⲒⲘ ⲈⲦⲞⲨⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲚⲢⲰⲘⲈ ⲚⲀⲨ ⲈⲢⲞⲞⲨ. ⲤⲈⲞⲨⲰϢⲤ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲪⲨⲖⲀⲔⲦⲎⲢⲒⲞⲚ. ⲀⲨⲰ ⲤⲈⲔⲰ ⲚⲚⲈⲨⲦⲰⲦⲈ ⲈⲚⲀⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ⲤⲈⲘⲈ ⲆⲈ ⲚⲘⲘⲀ ⲚⲚⲞϪⲞⲨ ⲚϢⲞⲢⲠ ϨⲢⲀⲒ ϨⲚ ⲚⲆⲒⲠⲚⲞⲚ ⲀⲨⲰ ⲘⲘⲀ ⲚⲈϨⲘⲞⲞⲤ ⲚϢⲞⲢⲠ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ⲘⲚ ⲚⲀⲤⲠⲀⲤⲘⲞⲤ ϨⲢⲀⲒ ϨⲚ ⲚⲀⲄⲞⲢⲀ. ⲀⲨⲰ ⲈⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲢⲰⲘⲈ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ⲚⲦⲰⲦⲚ ⲆⲈ ⲘⲠⲢⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲰⲦⲚ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲞⲨⲀ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲚⲤⲀϨ. ⲚⲦⲰⲦⲚ ⲄⲀⲢ ⲦⲎⲢⲦⲚ ⲚⲦⲈⲦⲚ ϨⲚⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ⲀⲨⲰ ⲘⲠⲢⲘⲞⲨⲦⲈ ⲚⲎⲦⲚ ⲈⲈⲒⲰⲦ ϨⲢⲀⲒ ϨⲒϪⲘ ⲠⲔⲀϨ. ⲞⲨⲀ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ⲞⲨⲆⲈ ⲘⲠⲢⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲰⲦⲚ ϪⲈ ⲚⲢⲈϤϮⲤⲂⲰ. ⲞⲨⲀ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲚⲢⲈϤϮⲤⲂⲰ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ⲠⲚⲞϬ ⲆⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲚⲆⲒⲀⲔⲞⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ⲠⲈⲦⲚⲀϪⲒⲤⲈ ⲆⲈ ⲘⲘⲞϤ ⲤⲈⲚⲀⲐⲂⲂⲒⲞϤ. ⲀⲨⲰ ⲠⲈⲦⲚⲀⲐⲂⲂⲒⲞϤ ⲤⲈⲚⲀϪⲀⲤⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ⲞⲨⲞⲒ ⲆⲈ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ϪⲈ ⲦⲈⲦⲚϢⲦⲀⲘ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲢⲰⲘⲈ ⲚⲦⲰⲦⲚ ⲄⲀⲢ ⲚⲦⲈⲦⲚⲂⲎⲔ ⲀⲚ ⲈϨⲞⲨⲚ ⲞⲨⲆⲈ ⲚⲈⲦⲂⲎⲔ ⲈϨⲞⲨⲚ ⲚⲦⲈⲦⲚⲔⲰ ⲘⲘⲞⲞⲨ ⲀⲚ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","— ");
INSERT INTO copshc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ϪⲈ ⲦⲈⲦⲚⲘⲞⲨϢⲦ ⲚⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲘⲚ ⲠⲈⲦϢⲞⲨⲰⲞⲨ ⲈⲢⲞⲨⲀ ⲘⲠⲢⲞⲤⲨⲖⲎⲦⲞⲤ. ⲀⲨⲰ ⲈϤϢⲀⲚⲈⲒⲢⲈ ϢⲀⲦⲈⲦⲚⲀⲀϤ ⲚϢⲎⲢⲈ ⲚⲦⲄⲈϨⲈⲚⲚⲀ ⲈϤⲔⲎⲂ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲂⲖⲖⲈ ⲚϪⲀⲨⲘⲞⲈⲒⲦ. ⲚⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲚⲀⲰⲢⲔ ⲘⲠⲢⲠⲈ ⲞⲨⲖⲀⲀⲨ ⲠⲈ. ⲠⲈⲦⲚⲀⲰⲢⲔ ⲆⲈ ⲚⲦⲞϤ ⲘⲠⲚⲞⲨⲂ ⲘⲠⲢⲠⲈ ⲞⲨⲚⲞⲨⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ⲚⲤⲞϬ ⲀⲨⲰ ⲚⲂⲖⲖⲈ. ⲚⲒⲘ ⲄⲀⲢ ⲠⲈ ⲠⲚⲞϬ. ⲠⲚⲞⲨⲂ ⲠⲈ ϪⲚⲠⲢⲠⲈ ⲠⲈⲦⲦⲂⲂⲞ ⲘⲠⲚⲞⲨⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲰⲢⲔ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲞⲨⲖⲀⲀⲨ ⲠⲈ. ⲠⲈⲦⲚⲀⲰⲢⲔ ⲆⲈ ⲚⲦⲞϤ ⲘⲠⲆⲰⲢⲞⲚ ⲈⲦϨⲒϪⲰϤ ⲞⲨⲚⲞⲨⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ⲚⲤⲞϬ ⲀⲨⲰ ⲚⲂⲖⲖⲈ. ⲀϢ ⲄⲀⲢ ⲠⲈ ⲠⲚⲞϬ ⲠⲆⲰⲢⲞⲚ ⲠⲈ ϪⲚⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲠⲈⲦⲦⲂⲂⲞ ⲘⲠⲆⲰⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ⲠⲈⲦⲚⲀⲰⲢⲔ ϬⲈ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ϤⲰⲢⲔ ⲘⲘⲞϤ ⲀⲨⲰ ⲠⲈⲦⲞⲨⲎϨ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲰⲢⲔ ⲘⲠⲢⲠⲈ ϤⲰⲢⲔ ⲘⲘⲞϤ ⲀⲨⲰ ⲠⲈⲦⲞⲨⲎϨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲰⲢⲔ ⲚⲦⲠⲈ ϤⲰⲢⲔ ⲘⲠⲈⲐⲢⲞⲚⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲠⲈⲦϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ϪⲈ ⲦⲈⲦⲚϮ ⲘⲠⲢⲈⲘⲎⲦ ⲘⲠϨⲀϬⲒⲚ ⲚⲤⲦⲞⲒ ⲘⲚ ⲠⲈⲘⲒⲤⲈ ⲘⲚ ⲠⲦⲀⲠⲚ ⲚⲈⲦϨⲞⲢϢ ⲆⲈ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲀⲦⲈⲦⲚⲔⲀⲀⲨ ⲚⲤⲀⲦⲎⲨⲦⲚ ⲠϨⲀⲠ ⲘⲚ ⲠⲚⲀ ⲘⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲀⲒ ⲆⲈ ⲚⲈϢϢⲈ ⲈⲢⲰⲦⲚ ⲠⲈ ⲈⲀⲀⲨ ⲀⲨⲰ ⲚⲔⲞⲞⲨⲈ ⲈⲦⲘⲔⲀⲀⲨ ⲚⲤⲀⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ⲚⲂⲖⲖⲈ ⲚϪⲀⲨⲘⲞⲈⲒⲦ ⲚⲈⲦⲐⲖⲞ ⲈⲂⲞⲖ ⲚⲦϢⲞⲖⲘⲈⲤ ⲈⲦⲰⲘⲔ ⲘⲠϬⲀⲘⲞⲨⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ϪⲈ ⲦⲈⲦⲚⲦⲂⲂⲞ ⲘⲠⲤⲀⲘⲂⲞⲖ ⲘⲠⲀⲠⲞⲦ ⲘⲚ ⲠⲠⲒⲚⲀⲜ. ⲠⲈⲨϨⲞⲨⲚ ⲆⲈ ⲘⲈϨ ⲚⲦⲰⲢⲠ ϨⲒⲀⲔⲀⲐⲀⲢⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲠⲂⲖⲖⲈ ⲦⲂⲂⲞ ⲚϢⲞⲢⲠ ⲘⲠⲤⲀⲚϨⲞⲨⲚ ⲘⲠⲀⲠⲞⲦ ⲘⲚ ⲠⲠⲒⲚⲀⲜ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲠⲈⲨⲔⲈⲤⲀⲘⲂⲞⲖ ϢⲰⲠⲈ ⲈϤⲦⲂⲂⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ϪⲈ ⲦⲈⲦⲚⲞ ⲚⲐⲈ ⲚⲚⲒⲦⲀⲪⲞⲤ ⲈⲦϪⲎϨ. ⲚⲀⲒ ⲈⲚⲈⲤⲰⲞⲨ ⲘⲈⲚ ϨⲘ ⲠⲈⲨⲤⲀⲘⲂⲞⲖ ⲈⲢⲈⲠⲈⲨⲤⲀ ⲚϨⲞⲨⲚ ⲘⲈϨ ⲚⲔⲀⲤ ⲚⲔⲰⲰⲤ ϨⲒⲀⲔⲀⲐⲀⲢⲤⲒⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ⲦⲀⲒ ϨⲰⲦⲦⲎⲨⲦⲚ ⲦⲈ ⲦⲈⲦⲚϨⲈ. ϨⲒⲂⲞⲖ ⲘⲈⲚ ⲦⲈⲦⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ϨⲰⲤ ⲆⲒⲔⲀⲒⲞⲤ ⲠⲈⲦⲚⲤⲀⲚϨⲞⲨⲚ ⲆⲈ ⲘⲈϨ ⲚϨⲨⲠⲞⲔⲢⲒⲤⲒⲤ ϨⲒⲀⲚⲞⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ϪⲈ ⲦⲈⲦⲚⲔⲰⲦ ⲚⲚⲦⲀⲪⲞⲤ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲰ ⲦⲈⲦⲚⲦⲤⲀⲚⲞ ⲚⲘϨⲀⲀⲨ ⲚⲚⲆⲒⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈⲚϢⲞⲞⲠ ⲚⲚⲈϨⲞⲞⲨ ⲚⲚⲈⲒⲞⲦⲈ ⲚⲈⲚⲚⲀϢⲰⲠⲈ ⲀⲚ ⲚⲘⲘⲀⲨ ⲠⲈ ⲚⲔⲞⲒⲚⲰⲚⲞⲤ ⲈⲠⲈⲤⲚⲞϤ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ϨⲰⲤⲦⲈ ⲦⲈⲦⲚⲢⲘⲚⲦⲢⲈ ⲈⲢⲰⲦⲚ ϪⲈ ⲚⲦⲈⲦⲚ ⲚϢⲎⲢⲈ ⲚⲚⲈⲚⲦⲀⲨϨⲰⲦⲂ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲀⲦⲈⲦⲚϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠϢⲒ ⲚⲚⲈⲦⲚⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ⲚϨⲞϤ ⲚϢⲎⲢⲈ ⲚⲚⲈϨⲂⲰ. ⲚⲀϢ ⲚϨⲈ ⲦⲈⲦⲚⲀⲢⲂⲞⲖ ⲈⲦⲈⲔⲢⲒⲤⲒⲤ ⲚⲦⲄⲈϨⲈⲚⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮⲚⲀⲦⲚⲞⲞⲨ ϢⲀⲢⲰⲦⲚ ⲚϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲚ ϨⲈⲚⲤⲞⲪⲞⲤ ⲘⲚ ϨⲈⲚⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ⲚⲦⲈⲦⲚ ⲘⲞⲨⲞⲨⲦ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲤⲦⲀⲨⲢⲞⲨ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲘⲀⲤⲦⲒⲄⲞⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲦⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈⲦⲚ ⲠⲰⲦ ⲚⲤⲰⲞⲨ ϪⲒⲚⲈⲠⲞⲖⲒⲤ ⲈⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲎⲨⲦⲚ ⲚϬⲒ ⲤⲚⲞϤ ⲚⲒⲘ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲈⲀⲨⲠⲀϨⲦϤ ⲈⲂⲞⲖ ϨⲒ ϪⲘⲠⲔⲀϨ. ϪⲒⲚⲠⲈⲤⲚⲞϤ ⲚⲀⲂⲈⲖ ⲠⲆⲒⲔⲀⲒⲞⲤ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲈⲤⲚⲞϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲠϢⲎⲢⲈ ⲚⲂⲀⲢⲀⲬⲒⲀⲤ ⲠⲈⲚⲦⲀⲦⲈⲦⲚϨⲞⲦⲂⲈϤ ⲞⲨⲆⲈ ⲠⲢⲠⲈ ⲘⲚ ⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲎⲨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲈⲦϨⲰⲦⲂ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦϨⲒⲰⲚⲈ ⲈⲚⲈⲚⲦⲀⲨⲦⲚⲞⲞⲨⲤⲞⲨ ϢⲀⲢⲞⲤ. ϨⲀϨ ⲚⲤⲞⲠ ⲀⲒⲞⲨⲰϢ ⲈⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲞⲨϢⲎⲢⲈ ⲚⲐⲈ ⲚⲞⲨϨⲀⲖⲎⲦ ⲚϢⲀϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲈϤⲘⲀⲤ ϨⲀⲚⲈϤⲦⲎⲚϨ. ⲀⲨⲰ ⲘⲠⲈⲦⲚⲞⲨⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲠⲈⲦⲚⲎⲒ ⲔⲎ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲒ ϪⲒⲚⲦⲈⲚⲞⲨ ϢⲀⲚⲦⲈⲦⲚϪⲞⲞⲤ ϪⲈ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲈⲦⲚⲎⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲠⲈ ⲀϤⲂⲰⲔ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲞⲨⲞϤ ⲈⲠⲔⲰⲦ ⲘⲠⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲦⲈⲦⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲚⲚⲈⲨⲔⲀⲞⲨⲰⲚⲈ ϨⲒϪⲚ ⲞⲨⲰⲚⲈ ⲘⲠⲈⲒⲘⲀ ⲘⲠⲞⲨⲂⲞⲖϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ⲈϤϨⲘⲞⲞⲤ ⲆⲈ ϨⲒϪⲘ ⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲤⲀⲞⲨⲤⲀ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϪⲒⲤ ⲈⲢⲞⲚ ϪⲈ ⲈⲢⲈⲚⲀⲒ ⲚⲀϢⲰⲠⲈ ⲦⲚⲀⲨ ⲀⲨⲰ ⲞⲨ ⲠⲈ ⲠⲘⲀⲈⲒⲚ ⲚⲦⲈⲔⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲘⲚ ⲦⲤⲨⲚⲦⲈⲖⲈⲒⲀ ⲘⲠⲀⲒⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϬⲰϢⲦ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲞⲨⲀ ⲠⲖⲀⲚⲀ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ⲞⲨⲚϨⲀϨ ⲄⲀⲢ ⲚⲎⲨ ϨⲘ ⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲚⲤⲈⲠⲖⲀⲚⲀ ⲚϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ⲦⲈⲦⲚⲚⲀⲤⲰⲦⲘ ⲆⲈ ⲈϨⲈⲚⲠⲞⲖⲈⲘⲞⲤ ⲘⲚ ϨⲈⲚϨⲢⲞⲞⲨ ⲘⲠⲞⲖⲈⲘⲞⲤ ϬⲰϢⲦ ⲘⲠⲢϢⲦⲞⲢⲦⲢ ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲀⲖⲖⲀ ⲘⲠⲀⲦⲈⲐⲀⲎ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ⲞⲨⲚⲞⲨϨⲈⲐⲚⲞⲤ ⲄⲀⲢ ⲚⲀⲦⲰⲞⲨⲚ ⲈϪⲚ ⲞⲨϨⲈⲐⲚⲞⲤ. ⲀⲨⲰ ⲞⲨⲘⲚⲦⲢⲢⲞ ⲈϪⲚ ⲞⲨⲘⲚⲦⲢⲢⲞ. ⲚⲤⲈϢⲰⲠⲈ ⲚϬⲒ ϨⲈⲚϨⲈⲂⲰⲰⲚ ⲘⲚ ϨⲈⲚⲔⲘⲦⲞ ⲔⲀⲦⲀⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲦⲀⲢⲬⲎ ⲚⲚⲚⲀⲀⲔⲈ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲰⲦⲚ ⲈⲨⲐⲖⲒⲮⲒⲤ. ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲰⲦⲚ ⲚⲦⲈⲦⲚϢⲰⲠⲈ ⲘⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲚϬⲒ ϨⲀϨ. ⲚⲤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲚⲚⲈⲨⲈⲢⲎⲨ. ⲚⲤⲈⲘⲈⲤⲦⲈⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ⲚⲤⲈⲦⲰⲞⲨⲚ ⲚϬⲒ ϨⲀϨ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲚⲤⲈⲠⲖⲀⲚⲀ ⲚⲞⲨⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ϨⲘ ⲠⲦⲢⲈⲤⲀϢⲀⲒ ⲚϬⲒ ⲦⲀⲚⲞⲘⲒⲀ ⲤⲚⲀⲀⲢⲞϢ ⲚϬⲒ ⲦⲀⲄⲀⲠⲎ ⲚϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ⲠⲈⲦⲚⲀϨⲨⲠⲞⲘⲈⲒⲚⲈ ⲆⲈ ϢⲀⲂⲞⲖ ⲠⲀⲒ ⲠⲈⲦⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ⲚⲤⲈⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ϨⲢⲀⲒ ϨⲚ ⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ. ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ⲦⲞⲦⲈ ⲤⲚⲎⲨ ⲚϬⲒ ⲐⲀⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ϨⲞⲦⲀⲚ ⲆⲈ ⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲈⲦⲂⲞⲦⲈ ⲘⲠϢⲰϤ. ⲦⲈⲚⲦⲀⲨϪⲞⲞⲤ ϨⲒⲦⲚ ⲆⲀⲚⲒⲎⲖ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲤⲀϨⲈⲢⲀⲦⲤ ϨⲘ ⲠⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲠⲈⲦⲰϢ ⲘⲀⲢⲈϤⲚⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ⲦⲞⲦⲈ ⲚⲈⲦϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲘⲀⲢⲞⲨⲠⲰⲦ ⲈⲚⲦⲞⲨⲈⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ⲠⲈⲦϨⲒⲦϪⲈⲚⲈⲠⲰⲢ ⲘⲠⲢⲦⲢⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦⲈϤⲒ ⲚⲚⲈⲦϨⲘ ⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ⲀⲨⲰ ⲠⲈⲦϨⲚ ⲦⲤⲰϢⲈ ⲘⲠⲢⲦⲢⲈϤⲔⲞⲦϤ ⲈⲠⲀϨⲞⲨ ⲈϤⲒ ⲚⲦⲈϤϢⲦⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲈⲦⲈⲈⲦ ⲘⲚ ⲚⲈⲦⲤⲚⲔⲞ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ϢⲖⲎⲖ ⲆⲈ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲠⲈⲦⲚⲠⲰⲦ ϢⲰⲠⲈ ⲚⲦⲈⲠⲢⲰ ⲎⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ⲤⲚⲀϢⲰⲠⲈ ⲄⲀⲢ ⲘⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲚⲐⲖⲒⲮⲒⲤ ⲘⲠⲈⲞⲨⲞⲚ ⲚⲦⲈⲤϨⲈ ϢⲰⲠⲈ ϪⲒⲚⲦⲈϨⲞⲨⲈⲒⲦⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ϢⲀⲈϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ. ⲞⲨⲆⲈ ⲚⲚⲈⲤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ⲀⲨⲰ ⲚⲤⲀⲂⲎⲖ ϪⲈ ⲀⲨⲤⲂⲞⲔ ⲚϬⲒ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲤⲚⲀⲞⲨϪⲀⲒ ⲀⲚ ⲠⲈ ⲚϬⲒ ⲤⲀⲢⲜ ⲚⲒⲘ. ⲈⲦⲂⲈ ⲚⲤⲰⲦⲠ ⲆⲈ ⲤⲈⲚⲀⲤⲂⲞⲔ ⲚϬⲒ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ⲦⲞⲦⲈ ⲈⲢϢⲀⲚⲞⲨⲀ ϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲒⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲠⲈⲒⲘⲀ ⲎⲠⲀⲒ ⲘⲠⲢⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ⲤⲈⲚⲀⲦⲰⲞⲨⲚ ⲄⲀⲢ ⲚϬⲒ ϨⲀϨ ⲚⲬⲢⲎⲤⲦⲞⲤ ⲚⲚⲞⲨϪ ⲘⲚ ϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ. ⲚⲤⲈϮ ⲚϨⲚⲚⲞϬ ⲘⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ϨⲰⲤⲦⲈ ⲈϢϪⲈ ⲞⲨⲚϢϬⲞⲘ ⲈⲠⲖⲀⲚⲀ ⲚⲚⲀⲔⲈⲤⲰⲦⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲒϢⲢⲠϪⲞⲞⲨ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲨϢⲀⲚϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤϨⲘⲠϪⲀⲒⲈ ⲘⲠⲢⲈⲒ ⲈⲂⲞⲖ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤϨⲚⲚⲦⲀⲘⲒⲞⲚ ⲘⲠⲢⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ⲚⲐⲈ ⲄⲀⲢ ⲚⲦⲈϤⲢⲎϬⲈ ⲚϢⲀⲤⲈⲒ ⲈⲂⲞⲖ ϨⲚⲚⲈⲘⲀⲚϢⲀ ⲚⲤⲢⲞⲨⲞⲈⲒⲚ ϢⲀⲚⲘⲀⲚϨⲰⲦⲠ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ⲚⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ⲠⲘⲀ ⲈⲦⲈⲢⲈ ⲠⲤⲰⲘⲀ ⲚⲀϢⲰⲠⲈ ⲘⲘⲞϤ ⲈⲨⲚⲀⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲀⲈⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲘⲚⲚⲤⲀ ⲦⲈⲐⲖⲒⲮⲒⲤ ⲚⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲠⲢⲎ ⲚⲀϢⲰⲠⲈ ⲚⲔⲀⲔⲈ ⲀⲨⲰ ⲠⲞⲞϨ ⲚⲀϮ ⲀⲚ ⲘⲠⲈϤⲞⲨⲞⲈⲒⲚ ⲚⲤⲒⲞⲨ ⲤⲈⲚⲀϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚϬⲞⲘ ⲚⲘⲠⲎⲨⲈ ⲤⲈⲚⲀⲚⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ⲦⲞⲦⲈ ϤⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲘⲀⲈⲒⲚ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ⲀⲨⲰ ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲚϬⲒ ⲚⲈⲪⲨⲖⲎ ⲦⲎⲢⲞⲨ ⲘⲠⲔⲀϨ. ⲚⲤⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲎⲨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈⲔⲖⲞⲞⲖⲈ ⲚⲦⲠⲈ ⲘⲚⲞⲨϬⲞⲘ ⲀⲨⲰ ⲞⲨⲈⲞⲞⲨ ⲈⲚⲀϢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ⲚϤϪⲞⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲘⲚⲞⲨⲚⲞϬ ⲚϨⲢⲞⲞⲨ ⲚⲤⲀⲖⲠⲒⲄⲜ. ⲚⲤⲈⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲈϤⲤⲰⲦⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲦⲞⲨ ⲚⲦⲎⲨ. ⲀⲨⲰ ϪⲒⲚⲈⲀⲢⲎϪϤ ⲚⲘⲠⲎⲨⲈ ϢⲀⲀⲢⲎϪⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲈⲒⲘⲈ ⲈⲦⲠⲀⲢⲀⲂⲞⲖⲎ. ⲚⲐⲈ ⲄⲀⲢ ⲈⲢϢⲀⲚⲠⲈⲤⲔⲖⲀⲆⲞⲤ ϢⲰⲠⲈ ⲈϤⲖⲎⲔ ⲀⲨⲰ ⲚⲦⲈⲚⲈⲤϬⲰⲂⲈ ϮⲞⲨⲰ ϢⲀⲦⲈⲦⲚⲈⲒⲘⲈ ϪⲈ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ⲦⲀⲒ ϨⲰⲦⲦⲎⲨⲦⲚ ⲦⲈ ⲦⲈⲦⲚϨⲈ ϨⲞⲦⲀⲚ ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲒⲘⲈ ϪⲈ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲢⲚ ⲚⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈⲦⲈⲒⲄⲈⲚⲈⲀ ⲞⲨⲈⲒⲚⲈ ⲘⲠⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ⲦⲠⲈ ⲘⲚ ⲠⲔⲀϨ ⲚⲀⲠⲀⲢⲀⲄⲈ. ⲚⲀϢⲀϪⲈ ⲆⲈ ⲚⲀⲠⲀⲢⲀⲄⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ⲈⲦⲂⲈⲠⲈϨⲞⲞⲨ ⲆⲈ ⲘⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲘⲚ ⲖⲀⲀⲨ ⲤⲞⲞⲨⲚ. ⲞⲨⲆⲈ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲚⲘⲠⲎⲨⲈ ⲈⲒⲘⲎⲦⲒ ⲠⲈⲒⲰⲦ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ⲚⲐⲈ ⲄⲀⲢ ⲚⲚⲈϨⲞⲞⲨ ⲚⲚⲰϨⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲤⲚⲀϢⲰⲠⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ⲚⲐⲈ ⲄⲀⲢ ⲈⲚⲈⲨϢⲞⲞⲠ ⲘⲘⲞⲤ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ϨⲀⲐⲎ ⲘⲠⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲈⲨⲞⲨⲰⲘ ⲈⲨⲤⲰ ⲈⲨϪⲒϨⲒⲘⲈ ⲈⲨϨⲘⲞⲞⲤ ⲘⲚ ϨⲀⲒ ϢⲀⲠⲈϨⲞⲞⲨ ⲚⲦⲀⲚⲰϨⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲔⲒⲂⲰⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ⲀⲨⲰ ⲘⲠⲞⲨⲈⲒⲘⲈ ϢⲀⲚⲦⲈϤⲈⲒ ⲚϬⲒ ⲠⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲚϤϤⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲤⲚⲀϢⲰⲠⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ⲦⲞⲦⲈ ⲞⲨⲚⲤⲚⲀⲨ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲦⲤⲰϢⲈ. ⲚⲤⲈϪⲒⲞⲨⲀ ⲚⲤⲈⲖⲞ ϨⲀⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ⲤⲚⲦⲈ ⲈⲨⲚⲞⲨⲦ ϨⲚ ⲞⲨⲘⲎⲬⲀⲚⲎ ⲤⲈⲚⲀϪⲒⲞⲨⲈⲒ ⲚⲤⲈⲖⲞ ϨⲀⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ⲢⲞⲈⲒⲤ ϬⲈ ϪⲈ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲢⲈⲠϪⲞⲈⲒⲤ ⲚⲎⲨ ϨⲚ ⲀϢ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ⲦⲈⲦⲚⲈⲒⲘⲈ ⲆⲈ ⲈⲠⲀⲒ. ϪⲈ ⲈⲚⲈϤⲤⲞⲞⲨⲚ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠⲎⲒ ϪⲈ ⲈⲢⲈⲠⲢⲈϤϪⲒⲞⲨⲈ ⲚⲎⲨ ⲚⲀϢ ⲚⲞⲨⲎⲢϢⲈ. ⲚⲈϤⲚⲀⲢⲞⲈⲒⲤ ⲠⲈ ⲚϤⲦⲘⲔⲀⲀⲨ ⲈϬⲰⲦϨ ⲘⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ⲈⲦⲂⲈ ⲠⲀⲒ ϨⲰⲦⲦⲎⲨⲦⲚ ϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲤⲂⲦⲰⲦ. ϪⲈ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲚⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲈⲢⲞⲤ ⲀⲚ ⲈⲢⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ⲚⲒⲘ ⲀⲢⲀ ⲠⲈ ⲠⲠⲒⲤⲦⲞⲤ ⲚϨⲘϨⲀⲖ ⲀⲨⲰ ⲚⲤⲀⲂⲈ. ⲠⲀⲒ ⲚⲦⲀⲠⲈϤϪⲞⲈⲒⲤ ⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈϤϨⲘϨⲀⲖ ⲈϮ ⲚⲀⲨ ⲚⲦⲈϨⲢⲈ ⲘⲠⲈⲤⲞⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ⲚⲀⲒⲀⲦϤ ⲘⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲈⲢⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲚⲎⲨ ⲚϤϨⲈ ⲈⲢⲞϤ ⲈϤⲈⲒⲢⲈ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲚⲀⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚϪⲞⲞⲤ ⲚϬⲒ ⲠϨⲘϨⲀⲖ ⲈⲐⲞⲞⲨ ϨⲢⲀⲒ ϨⲘ ⲠⲈϤϨⲎⲦ. ϪⲈ ⲠⲀϪⲞⲈⲒⲤ ⲚⲀⲰⲤⲔ ⲈⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ⲚϤⲀⲢⲬⲈⲒ ⲚϨⲒⲞⲨⲈ ⲈⲚⲈϤϢⲂⲎⲢϨⲘϨⲀⲖ ⲚϤⲞⲨⲰⲘ ⲀⲨⲰ ⲚϤⲤⲰ ⲘⲚ ⲚⲈⲦⲦⲀϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ϤⲚⲎⲨ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ϨⲢⲀⲒ ϨⲚ ⲞⲨϨⲞⲞⲨ ⲈⲚϤϬⲰϢⲦ ϨⲎⲦϤ ⲀⲚ. ⲀⲨⲰ ϨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲈⲚϤⲤⲞⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ⲚϤⲠⲰϢ ⲘⲘⲞϤ ⲚϤⲔⲰ ⲚⲦⲈϤⲦⲞ ⲘⲚ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ ⲘⲚ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ⲦⲞⲦⲈ ⲤⲚⲀϢⲰⲠⲈ ⲈⲤⲦⲚⲦⲰⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ ⲈⲘⲎⲦⲈ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ. ⲚⲀⲒ ⲚⲦⲀⲨϪⲒ ⲚⲚⲈⲨⲖⲀⲘⲠⲀⲤ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲰⲘⲚⲦ ⲈⲠⲀⲦϢⲈⲖⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ϮⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲚⲈϨⲈⲚⲤⲞϬ ⲚⲈ ⲀⲨⲰ ϮⲚⲚⲈ ϨⲈⲚⲤⲀⲂⲈ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ⲚⲤⲞϬ ⲄⲀⲢ ⲀⲨϪⲒ ⲚⲚⲈⲨⲖⲀⲘⲠⲀⲤ ⲘⲠⲞⲨϪⲒⲚⲈϨ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ⲚⲤⲀⲂⲎ ⲆⲈ ⲀⲨϪⲒⲚⲈϨ ϨⲚ ⲚⲈⲨϨⲚⲀⲀⲨ ⲘⲚ ⲚⲈⲨⲖⲀⲘⲠⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ⲚⲦⲈⲢⲈϤⲰⲤⲔ ⲆⲈ ⲚϬⲒ ⲠⲀⲦϢⲈⲖⲈⲈⲦ. ⲀⲨϪⲒⲢⲈⲔⲢⲒⲔⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ϨⲚ ⲦⲠⲀϢⲈ ⲆⲈ ⲚⲦⲈⲨϢⲎ ⲈⲒⲤⲞⲨⲤⲘⲈ ⲀⲤϢⲰⲠⲈ ϪⲈ ⲈⲒⲤⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲀⲘⲎⲒⲦⲚ ⲈⲂⲞⲖ ⲈⲦⲰⲘⲚⲦ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ⲦⲞⲦⲈ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲚϬⲒ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲦⲤⲀⲚⲞ ⲚⲚⲈⲨⲖⲀⲘⲠⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ⲚⲤⲞϬ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲚⲤⲀⲂⲎ ϪⲈ ⲘⲀ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲚⲚⲈϨ. ϪⲈ ⲚⲈⲚⲖⲀⲘⲠⲀⲤ ⲚⲀϪⲈⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲚⲤⲀⲂⲎ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎⲠⲞⲦⲈ ⲚϤⲦⲘⲢⲰϢⲈ ⲈⲢⲞⲚ ⲚⲘⲘⲎⲦⲚ. ⲂⲰⲔ ⲚⲦⲞϤ ⲚⲚⲀϨⲢⲚ ⲚⲈⲦϮ ⲈⲂⲞⲖ ⲚⲦⲈⲦⲚϢⲰⲠ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ⲈⲨⲚⲀⲂⲰⲔ ⲆⲈ ⲈϢⲰⲠ ⲀϤⲈⲒ ⲚϬⲒ ⲠⲀⲦϢⲈⲖⲈⲈⲦ. ⲀⲨⲰ ⲚⲈⲦⲤⲂⲦⲰⲦ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲘⲘⲀϤ ⲈⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ ⲀⲨϢⲦⲀⲘ ⲘⲠⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲀⲨⲈⲒ ⲚϬⲒ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲞⲨⲰⲚ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲰⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ⲢⲞⲈⲒⲤ ϬⲈ ϪⲈ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲈϨⲞⲞⲨ ⲞⲨⲦⲈ ⲦⲈⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ⲚⲐⲈ ⲄⲀⲢ ⲚⲞⲨⲢⲰⲘⲈ ⲈϤⲚⲀⲀⲠⲞⲆⲎⲘⲈⲒ. ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤϨⲘϨⲀⲖ ⲀϤϮ ⲚⲀⲨ ⲚⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ⲞⲨⲀ ⲘⲈⲚ ⲀϤϮ ⲚⲀϤ ⲚϮⲞⲨ ⲚϬⲒ ⲚϬⲰⲢ ⲞⲨⲀ ⲆⲈ ⲀϤϮ ⲚⲀϤ ⲚⲤⲚⲀⲨ ⲞⲨⲀ ⲆⲈ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨⲀ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲔⲀⲦⲀⲦⲈϤϬⲞⲘ ⲀϤⲀⲠⲞⲆⲎⲘⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲂⲰⲔ ⲚϬⲒ ⲠⲈⲚⲦⲀϤϪⲒ ⲘⲠϮⲞⲨ ⲚϬⲒ ⲚϬⲰⲢ ⲀϤⲢϨⲰⲂ ⲚϨⲎⲦⲞⲨ ⲀϤϮϨⲎⲨ ⲚⲔⲈϮⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ϨⲞⲘⲞⲒⲰⲤ ⲠⲀⲠⲈⲤⲚⲀⲨ ⲀϤϮϨⲎⲨ ⲚⲔⲈⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ⲠⲈⲚⲦⲀϤϪⲒ ⲆⲈ ⲘⲠⲞⲨⲀ ⲀϤⲂⲰⲔ ⲀϤϢⲒⲔⲈ ϨⲘ ⲠⲔⲀϨ ⲀϤⲦⲰⲘⲤ ⲘⲠϨⲀⲦ ⲘⲠⲈϤϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ⲘⲚⲚⲤⲀ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲞⲨⲞⲈⲒϢ ⲀϤⲈⲒ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲚⲚϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲀϤϤⲒⲰⲠ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲈⲚⲦⲀϤϪⲒ ⲘⲠϮⲞⲨ ⲚϬⲒ ⲚϬⲰⲢ. ⲀϤⲈⲒⲚⲈ ⲚⲀϤ ⲚⲔⲈϮⲞⲨ ⲚϬⲒⲚϬⲰⲢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ϮⲞⲨ ⲚϬⲒ ⲚϬⲰⲢ ⲚⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲒϪⲠⲞ ⲚⲔⲈϮⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠϨⲘϨⲀⲖ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ⲘⲠⲒⲤⲦⲒⲤ. ⲈⲠⲈⲒⲆⲎ ⲚⲈⲔⲚϨⲞⲦ ⲚϨⲚⲔⲞⲨⲒ ϮⲚⲀⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞⲔ ⲈϪⲚ ϨⲀϨ. ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲢⲀϢⲈ ⲘⲠⲈⲔϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲀⲠϬⲒⲚϬⲰⲢ ⲤⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ϬⲒⲚϬⲰⲢ ⲤⲚⲀⲨ ⲚⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲒϮϨⲎⲨ ⲚⲔⲈⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠϨⲘϨⲀⲖ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ⲘⲠⲒⲤⲦⲞⲤ ⲈⲠⲈⲒⲆⲎ ⲚⲈⲔⲚϨⲞⲦ ⲚϨⲚⲔⲞⲨⲒ ϮⲚⲀⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞⲔ ⲈϪⲚ ϨⲀϨ. ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲢⲀϢⲈ ⲘⲠⲈⲔϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ⲀϤϮ ⲘⲠⲈϤⲞⲨⲞⲒ ϨⲰⲰϤ ⲚϬⲒ ⲠⲈⲚⲦⲀϤϪⲒ ⲘⲠϬⲒⲚϬⲰⲢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲒⲈⲒⲘⲈ ϪⲈ ⲚⲦⲔⲞⲨⲢⲰⲘⲈ ⲚⲤⲔⲖⲎⲢⲞⲤ ⲈⲔⲰϨⲤ ⲘⲠⲈⲦⲘⲠⲈⲔϪⲞϤ ⲀⲨⲰ ⲈⲔⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲘⲀ ⲈⲦⲘⲠⲈⲔϪⲰⲰⲢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ⲀⲒⲢϨⲞⲦⲈ ⲀⲒⲂⲰⲔ ⲀⲒϨⲰⲠ ⲘⲠⲈⲔϬⲒⲚϬⲰⲢ ϨⲘ ⲠⲔⲀϨ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤ ⲠⲈⲦⲈⲠⲰⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈϤϪⲞⲈⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϨⲘϨⲀⲖ ⲘⲠⲞⲚⲎⲢⲞⲤ ⲀⲨⲰ ⲚⲢⲈϤϪⲚⲀⲀⲨ. ⲈϢϪⲈ ⲔⲤⲞⲞⲨⲚ ϪⲈ ϮⲰϨⲤ ⲘⲠⲘⲀ ⲈⲦⲘⲠⲈⲒϪⲞϤ. ⲀⲨⲰ ϮⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲘⲀ ⲈⲦⲘⲠⲈⲒϪⲰⲰⲢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ⲚⲈϢϢⲈ ϬⲈ ⲈⲢⲞⲔ ⲠⲈ ⲈⲚⲞⲨϪⲈ ⲘⲠⲀϨⲀⲦ ⲚⲚⲈⲦⲢⲀⲠⲈⲌⲒⲦⲎⲤ. ⲀⲚⲞⲔ ⲆⲈ ⲚⲈⲒⲚⲀⲈⲒ ⲚⲦⲀϪⲒ ⲘⲠⲈⲦⲈⲠⲰⲒ ⲠⲈ ⲘⲚ ⲦⲈϤⲘⲎⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ϤⲒ ϬⲈ ⲚⲦⲞⲞⲦϤ ⲘⲠϬⲒⲚϬⲰⲢ ⲚⲦⲈⲦⲚ ⲦⲀⲀϤ ⲘⲠⲈⲦⲈⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲘⲎⲦ ⲚϬⲒⲚϬⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲈⲞⲨⲚⲦⲀϤ ⲤⲈⲚⲀϮ ⲚⲀϤ ⲀⲨⲰ ⲚϤⲢϨⲞⲨⲞ. ⲠⲈⲦⲈⲘⲚⲦⲀϤ ⲆⲈ ⲠⲔⲈⲈⲦⲚⲦⲀϤ ⲤⲈⲚⲀϤⲒⲦϤ ⲚⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ⲀⲨⲰ ⲠϨⲘϨⲀⲖ ⲚⲀⲦϢⲀⲨ ⲚⲦⲈⲦⲚ ⲚⲞⲨϪⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲈⲠⲔⲀⲔⲈ ⲈⲦϨⲀⲂⲞⲖ ⲈϤⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚϬⲒ ⲠⲢⲒⲘⲈ ⲀⲨⲰ ⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ϨⲞⲦⲀⲚ ⲆⲈ ⲈϤϢⲀⲚⲈⲒ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲈϤⲈⲞⲞⲨ ⲘⲚ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲘⲘⲀϤ. ⲦⲞⲦⲈ ϤⲚⲀϨⲘⲞⲞⲤ ⲈϪⲘ ⲠⲈⲐⲢⲞⲚⲞⲤ ⲘⲠⲈϤⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ⲚⲤⲈⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲚϤⲠⲰⲢϪ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲈⲢⲎⲨ ⲚⲐⲈ ⲚⲞⲨϢⲰⲤ ⲚϢⲀϤⲠⲰⲢϪ ⲚⲚⲈⲤⲞⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲂⲀⲀⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ⲚⲈⲤⲞⲞⲨ ⲘⲈⲚ ⲚϤⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞϤ. ⲚⲂⲀⲀⲘⲠⲈ ⲆⲈ ϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ⲦⲞⲦⲈ ϤⲚⲀϪⲞⲞⲤ ⲚϬⲒ ⲠⲢⲢⲞ ⲚⲚⲈⲦϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞϤ. ϪⲈ ⲀⲘⲎⲒⲦⲚ ⲚⲈⲦⲤⲘⲀⲘⲀⲀⲦ ⲚⲦⲈⲠⲀⲈⲒⲰⲦ. ⲚⲦⲈⲦⲚ ⲔⲖⲎⲢⲞⲚⲞⲘⲈⲒ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲚⲦⲀⲨⲤⲂⲦⲰⲦⲤ ⲚⲎⲦⲚ ϪⲒⲚⲈⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ⲀⲒϨⲔⲞ ⲄⲀⲢ ⲀⲦⲈⲦⲚⲦⲘⲞⲒ. ⲀⲒⲈⲒⲂⲈ ⲀⲦⲈⲦⲚⲦⲤⲞⲒ. ⲚⲈⲒⲞ ⲚϢⲘⲘⲞ ⲠⲈ ⲀⲦⲈⲦⲚϢⲞⲠⲦ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ⲚⲈⲒⲔⲎ ⲔⲀϨⲎⲨ ⲀⲦⲈⲦⲚϮ ϨⲒⲰⲰⲦ. ⲚⲈⲒϢⲰⲚⲈ ⲀⲦⲈⲦⲚϬⲘ ⲠⲀϢⲒⲚⲈ. ⲚⲈⲒϨⲘⲠⲈϢⲦⲈⲔⲞ ⲠⲈ ⲀⲦⲈⲦⲚⲈⲒ ϢⲀⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲦⲚⲀⲨ ⲈⲔϨⲔⲀⲈⲒⲦ ⲀⲚⲦⲘⲘⲞⲔ. ⲎⲈⲔⲞⲂⲈ ⲀⲚⲦⲤⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ⲚⲦⲀⲚⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲔ ⲦⲚⲀⲨ ⲈⲔⲞ ⲚϢⲘⲘⲞ ⲀⲚϢⲞⲠⲔ ⲈⲢⲞⲚ. ⲎⲈⲔⲔⲎ ⲔⲀϨⲎⲨ ⲀⲚϮ ϨⲒⲰⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ⲚⲦⲀⲚⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲔ ⲦⲚⲀⲨ ⲈⲔϢⲰⲚⲈ. ⲎⲈⲔϨⲘ ⲠⲈϢⲦⲈⲔⲞ ⲀⲚⲈⲒ ϢⲀⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ϤⲚⲀⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲢⲢⲞ ⲚϤϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲈⲪⲞⲤⲞⲚ ⲀⲦⲈⲦⲚⲀⲀⲤ ⲚⲞⲨⲀ ⲚⲚⲈⲒⲤⲚⲎⲨ ⲈⲦⲤⲞⲂⲔ ⲚⲦⲀⲦⲈⲦⲚⲀⲀⲤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ⲦⲞⲦⲈ ϤⲚⲀⲞⲨⲰϢⲂ ⲚϤϪⲞⲞⲤ ⲚⲚⲔⲞⲞⲨⲈ ⲈⲦϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞϤ. ϪⲈ ⲤⲀϨⲈⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ⲚⲈⲦⲤϨⲞⲨⲞⲢⲦ ⲈⲦⲤⲀⲦⲈ ⲚϢⲀ ⲈⲚⲈϨ ⲚⲦⲀⲨⲤⲂⲦⲰⲦⲤ ⲘⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲘⲚ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ⲀⲒϨⲔⲞ ⲄⲀⲢ ⲘⲠⲈⲦⲚⲦⲘⲞⲒ. ⲀⲒⲈⲒⲂⲈ ⲘⲠⲈⲦⲚⲦⲤⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ⲚⲈⲒⲞ ⲚϢⲘⲘⲞ ⲘⲠⲈⲦⲚϢⲞⲠⲦ ⲈⲢⲰⲦⲚ ⲚⲈⲒⲔⲎ ⲔⲀϨⲎⲨ ⲘⲠⲈⲦⲚϮ ϨⲒⲰⲰⲦ ⲚⲈⲒϢⲰⲚⲈ ⲀⲨⲰ ⲈⲒϨⲘⲠⲈϢⲦⲈⲔⲞ ⲘⲠⲈⲦⲚϬⲘⲠⲀϢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲞⲨⲰϢⲂ ϨⲰⲞⲨ ⲞⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲦⲚⲀⲨ ⲈⲔϨⲔⲀⲈⲒⲦ ⲎⲈⲔⲞⲂⲈ ⲎⲈⲔⲞ ⲚϢⲘⲘⲞ ⲎⲈⲔⲔⲎ ⲔⲀϨⲎⲨ ⲎⲈⲔϢⲰⲚⲈ ⲎⲈⲔϨⲘⲠⲈϢⲦⲈⲔⲞ ⲘⲠⲈⲚⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ⲦⲞⲦⲈ ϤⲚⲀⲞⲨⲰϢⲂ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲪⲞⲤⲞⲚ ⲘⲠⲈⲦⲚⲀⲀⲤ ⲚⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ ⲀⲚⲞⲔ ⲠⲈⲦⲘⲠⲈⲦⲚⲀⲀⲤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ⲚⲀⲒ ⲘⲈⲚ ⲤⲈⲚⲀⲂⲰⲔ ⲈⲨⲔⲞⲖⲀⲤⲒⲤ ⲚϢⲀ ⲈⲚⲈϨ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲆⲈ ⲚⲦⲞⲞⲨ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲰ ⲚⲚⲈⲒϢⲀϪⲈ ⲦⲎⲢⲞⲨ. ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲘⲚ ⲚⲤⲀϨⲞⲞⲨ ⲤⲚⲀⲨ ⲠⲠⲀⲤⲬⲀ ⲚⲀϢⲰⲠⲈ. ⲚⲤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲢⲈⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ⲦⲞⲦⲈ ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲠⲖⲀⲞⲤ ⲈϨⲞⲨⲚ ⲈⲦⲀⲨⲖⲎ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲔⲀⲒⲪⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ⲀⲨϪⲒϢⲞϪⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲀⲘⲀϨⲦⲈ ⲚⲒⲎⲤⲞⲨⲤ ϨⲚ ⲞⲨⲔⲢⲞϤ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ⲚⲈⲨϪⲰ ⲆⲈ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲀⲒ ϨⲘ ⲠϢⲀ ⲀⲚ. ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲞⲨϢⲦⲞⲢⲦⲢ ϢⲰⲠⲈ ϨⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲂⲎⲐⲀⲚⲒⲀ ϨⲘ ⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲤⲞⲂϨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨⲤϨⲒⲘⲈ ⲈⲢⲈⲞⲨϨⲚⲀⲀⲨ ⲚⲤⲞϬⲚ ⲚⲦⲞⲞⲦⲤ ⲈⲚⲀϢⲈⲤⲞⲨⲚⲦϤ. ⲀⲤⲠⲰϨⲦ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ ⲈϤⲚⲎϪ. ");
INSERT INTO copshc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲀⲄⲀⲚⲀⲔⲦⲈⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲨⲦⲀⲔⲈⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ⲚⲈⲨⲚϬⲞⲘ ⲄⲀⲢ ⲈⲦⲢⲈⲨϮⲠⲀⲒ ⲈⲂⲞⲖ ϨⲀϨⲀϨ ⲚⲤⲈⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϮϨⲒⲤⲈ ⲚⲦⲈⲒⲤϨⲒⲘⲈ. ⲞⲨϨⲰⲂ ⲄⲀⲢ ⲈⲚⲀⲚⲞⲨϤ ⲠⲈⲚⲦⲀⲤⲀⲀϤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ⲚⲞⲨⲞⲈⲒϢ ⲄⲀⲢ ⲚⲒⲘ ⲚϨⲎⲔⲈ ⲤⲈϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ. ⲀⲚⲞⲔ ⲆⲈ ⲚϮϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ ⲀⲚ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ⲦⲀⲒ ⲄⲀⲢ ⲚⲦⲀⲤⲚⲞⲨϪⲈ ⲘⲠⲈⲒⲤⲞϬⲚ ⲈϪⲘ ⲠⲀⲤⲰⲘⲀ ⲚⲦⲀⲤⲀⲀⲤ ⲈⲠⲔⲞⲞⲤⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚϨⲎⲦϤ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲤⲈⲚⲀϪⲰ ϨⲰⲰϤ ⲘⲠⲈⲚⲦⲀⲦⲀⲒ ⲀⲀϤ ⲈⲨⲢⲠⲘⲈⲈⲨⲈ ⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ⲦⲞⲦⲈ ⲀϤⲂⲰⲔ ⲚϬⲒ ⲞⲨⲀ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ϢⲀⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲞⲨⲈϢⲦⲀⲀϤ ⲚⲀⲒ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚⲎⲦⲚ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲤⲘⲚⲦⲤ ⲚⲘⲘⲀϤ ⲈⲘⲀⲀⲂ ⲚϨⲀⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ϪⲒⲚⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲚⲈϤϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲞⲈⲒϢ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ϨⲘⲠϢⲞⲢⲠ ⲆⲈ ⲚϨⲞⲞⲨ ⲘⲠⲠⲀⲤⲬⲀ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲒⲎⲤⲞⲨⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲔⲞⲨⲰϢ ⲈⲦⲢⲈⲚⲤⲂⲦⲈⲠⲠⲀⲤⲬⲀ ⲚⲀⲔ ⲦⲰⲚ ⲈⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲚⲚⲀϨⲢⲚ ⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲚⲦⲈⲦⲚϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈϪⲈⲠⲤⲀϨ. ϪⲈ ⲀⲠⲀⲞⲨⲞⲈⲒϢ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲒⲚⲀⲢⲠⲠⲀⲤⲬⲀ ϨⲀⲦⲎⲔ ⲘⲚ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ⲀⲨⲰ ⲀⲨⲈⲒⲢⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲔⲀⲦⲀⲐⲈ ⲚⲦⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲤⲞϤⲦⲈ ⲘⲠⲠⲀⲤⲬⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲚⲈϤⲚⲎϪ ⲘⲚ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ⲈⲨⲞⲨⲰⲘ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ⲀⲨⲰ ⲀⲨⲖⲨⲠⲈⲒ ⲈⲘⲀⲦⲈ. ⲀⲨⲀⲢⲬⲈⲒ ⲚϪⲞⲞⲤ ⲚⲀϤ ⲞⲨⲀ ⲞⲨⲀ ϪⲈ ⲈⲒ ⲘⲎⲦⲒ ⲀⲚⲞⲔ ⲠⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚⲦⲀϤⲤⲰⲠ ⲚⲦⲈϤϬⲒϪ ⲚⲘⲘⲀⲒ ϨⲚ ⲦϪⲎ ⲠⲀⲒ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ⲠϢⲎⲢⲈ ⲘⲈⲚ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲂⲰⲔ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ⲈⲦⲂⲎⲎⲦϤ. ⲞⲨⲞⲒ ⲆⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲠⲀⲒ ⲈⲦⲞⲨⲚⲀϮ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ⲚⲀⲚⲞⲨⲤ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲈⲘⲠⲞⲨϪⲠⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲘⲎⲦⲒ ⲀⲚⲞⲔ ⲠⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲚⲦⲀⲔϪⲞⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ⲈⲨⲞⲨⲰⲘ ⲆⲈ ⲀϤϪⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲞⲨⲞⲈⲒⲔ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲀϤⲠⲞϢϤ ⲀϤϮ ⲘⲘⲞϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϪⲒ ⲚⲦⲈⲦⲚⲞⲨⲰⲘ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ⲀϤϪⲒ ⲞⲚ ⲚⲞⲨⲀⲠⲞⲦ ⲀϤϢⲠϨⲘⲞⲦ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲀϤϮ ⲘⲘⲞϤ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲰ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ⲠⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲀⲤⲚⲞϤ ⲚⲦⲆⲒⲀⲐⲎⲔⲎ ⲚⲂⲢⲢⲈ. ⲠⲀⲒ ⲈⲦⲞⲨⲚⲀⲠⲀϨⲦϤ ⲈⲂⲞⲖ ϨⲀϨⲀϨ ⲈⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲀⲤⲰ ϪⲒⲚⲈⲦⲈⲚⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲄⲈⲚⲎⲘⲀ ⲚⲦⲈⲒⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ ϢⲀⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈϮⲚⲀⲤⲞⲞϤ ⲚⲘⲘⲎⲦⲚ ⲚⲂⲢⲢⲈ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲀⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ⲀⲨⲤⲘⲞⲨ ⲆⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲰⲦⲚ ⲦⲎⲢⲦⲚ ⲦⲈⲦⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲚϨⲎⲦ ϨⲚ ⲦⲈⲒⲞⲨϢⲎ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ϮⲚⲀⲢⲰϨⲦ ⲘⲠϢⲰⲤ ⲚⲤⲈϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲤⲞⲞⲨ ⲘⲠⲞϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ⲘⲚⲚⲤⲀ ⲦⲢⲀⲦⲰⲞⲨⲚ ⲆⲈ ϮⲚⲀⲢϢⲞⲢⲠⲈⲢⲰⲦⲚ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲈϢϪⲈ ⲤⲈⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲚϨⲎⲦⲔ ⲦⲎⲢⲞⲨ ⲀⲚⲞⲔ ⲆⲈ ⲚⲦⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲀⲚ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲦⲈⲒⲞⲨϢⲎ ⲘⲠⲀⲦⲈⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲔⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲞⲘⲚⲦ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲔⲀⲚ ⲈⲤϢⲀⲚϢⲰⲠⲈ ⲈⲦⲢⲀⲘⲞⲨ ⲚⲘⲘⲀⲔ ⲚϮⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲔ ⲀⲚ. ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲚⲈⲨϪⲰ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ⲦⲞⲦⲈ ⲀϤⲈⲒ ⲚⲘⲘⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲀⲒ ⲈⲨϬⲰⲘ ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲄⲈⲐⲤⲎⲘⲀⲚⲈⲒ. ⲠⲈϪⲀϤ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲘⲞⲞⲤ ⲘⲠⲈⲒⲘⲀ ϢⲀⲚϮⲂⲰⲔ ⲈⲠⲈⲒⲘⲀ ⲚⲦⲀϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ⲀϤϪⲒ ⲚⲘⲘⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲠϢⲎⲢⲈ ⲤⲚⲀⲨ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ. ⲀϤⲀⲢⲬⲈⲒ ⲚⲖⲨⲠⲈⲒ ⲀⲨⲰ ⲚⲦⲰⲔⲘ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲖⲨⲠⲈⲒ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲘⲞⲨ ϬⲰ ⲘⲠⲈⲒⲘⲀ ⲚⲦⲈⲦⲚⲢⲞⲈⲒⲤ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ⲀϤⲘⲞⲞϢⲈ ⲈⲐⲎ ⲚⲞⲨⲔⲞⲨⲒ ⲀϤⲠⲀϨⲦϤ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈϤϨⲞ ⲀϤϢⲖⲎⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲈⲒⲰⲦ ⲈϢϪⲈ ⲞⲨⲚϢϬⲞⲘ ⲘⲀⲢⲈⲠⲈⲒⲀⲠⲞⲦ ⲤⲀⲀⲦ ⲠⲖⲎⲚ ⲚⲐⲈ ⲀⲚ ⲀⲚⲞⲔ ⲈϮⲞⲨⲀϢⲤ ⲀⲖⲖⲀ ⲚⲦⲞⲔ ⲈⲦⲔⲞⲨⲀϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ⲀϤⲈⲒ ⲆⲈ ϢⲀⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲚⲔⲞⲦⲔ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲈⲦⲚⲈϢϬⲘϬⲞⲘ ⲈⲢⲞⲈⲒⲤ ⲚⲘⲘⲀⲒ ⲚⲞⲨⲞⲨⲚⲞⲨ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ⲢⲞⲈⲒⲤ ⲚⲦⲈⲦⲚϢⲖϨⲖ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ. ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲈⲚ ⲢⲞⲞⲨⲦ ⲦⲤⲀⲢⲜ ⲆⲈ ⲞⲨⲀⲤⲐⲈⲚⲎⲤ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲂⲰⲔ ⲘⲠⲘⲈϨⲤⲠⲤⲚⲀⲨ ⲀϤϢⲖⲎⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲈⲒⲰⲦ ⲈϢϪⲈ ⲘⲚϬⲞⲘ ⲈⲦⲢⲈⲠⲀⲒ ⲤⲀⲀⲦ ⲈⲒⲘⲎⲦⲒ Ⲛ ⲦⲀⲤⲞⲞϤ ⲈⲒⲈ ⲘⲀⲢⲈⲠⲈⲔⲞⲨⲰϢ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲈⲒ ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲚⲔⲞⲦⲔ. ⲚⲈⲨⲂⲀⲖ ⲄⲀⲢ ⲈⲚⲈⲨϨⲞⲢϢ. ");
INSERT INTO copshc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ⲀϤⲔⲰ ⲆⲈ ⲞⲚ ⲘⲘⲞⲞⲨ ⲀϤⲂⲰⲔ ⲀϤϢⲖⲎⲖ ⲘⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚⲤⲞⲠ ⲈϤϪⲰ ⲘⲠⲈⲒϢⲀϪⲈ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ⲦⲞⲦⲈ ⲀϤⲈⲒ ϢⲀⲘⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲔⲞⲦⲔ ϬⲈ ⲚⲎⲦⲚ ⲚⲦⲈⲦⲚⲘⲦⲞⲚ ⲘⲘⲰⲦⲚ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲄⲀⲢ ⲀⲤϨⲰⲚ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦⲞⲨⲚⲞⲨ ⲀⲨⲰ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲚϬⲒϪ ⲚⲚⲈⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ⲦⲞⲨⲚⲦⲎⲨⲦⲚ ⲘⲀⲢⲞⲚ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ⲀⲒⲦⲈⲒ ⲆⲈ ⲈϤϢⲀϪⲈ ⲈⲒⲤⲒⲞⲨⲆⲀⲤ. ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤⲈⲒ ⲀⲨⲰ ⲞⲨⲘⲎⲎϢⲈ ⲚⲘⲘⲀϤ ⲘⲚ ⲚⲈⲨⲤⲎϤⲈ ⲘⲚ ⲚⲈⲨϬⲈⲢⲞⲞⲂ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲆⲈ ⲘⲘⲞϤ ⲀϤϮ ⲚⲀⲨ ⲚⲞⲨⲘⲀⲈⲒⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈϮⲚⲀϮⲠⲈⲒ ⲈⲢⲰϤ ⲚⲦⲞϤ ⲠⲈ ⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀⲒⲢⲈ ϨⲢⲀⲂⲂⲈⲒ ⲀⲨⲰ ⲀϤϮⲠⲈⲒ ⲈⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈϢⲂⲎⲢ ⲠⲈⲚⲦⲀⲔⲈⲒ ⲈⲦⲂⲎⲎⲦϤ. ⲦⲞⲦⲈ ⲀⲨϮ ⲘⲠⲈⲨⲞⲨⲞⲒ ⲀⲨⲈⲒⲚⲈ ⲚⲚⲈⲨϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲒⲎⲤⲞⲨⲤ. ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ⲈⲒⲤⲞⲨⲀ ⲆⲈ ⲚⲚⲈⲦϢⲞⲞⲠ ⲘⲚ ⲒⲎⲤⲞⲨⲤ. ⲀϤⲤⲞⲞⲨⲦⲚ ⲚⲦⲈϤϬⲒϪ ⲈⲂⲞⲖ ⲀϤⲦⲰⲔⲘ ⲚⲦⲈϤⲤⲎϤⲈ ⲀϤⲢⲰϨⲦ ⲘⲠϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ⲀϤϤⲒ ⲈⲂⲞⲖ ⲘⲠⲈϤⲘⲀⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲞⲨϪⲈ ⲚⲦⲈⲔⲤⲎϤⲈ ⲈⲠⲈⲤⲔⲞⲈⲒϨ. ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲚⲦⲀⲨϪⲒⲤⲎϤⲈ ⲈⲨⲚⲀϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲎϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ⲎⲚⲄϪⲰ ⲘⲘⲞⲤ ⲀⲚ ϪⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲒ ⲈⲤⲈⲠⲤⲠⲀⲈⲒⲰⲦ ⲚϤⲦⲀϨⲞ ⲚⲀⲒ ⲈⲢⲀⲦⲞⲨ ⲦⲈⲚⲞⲨ ⲚϨⲞⲨⲞ ⲈⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲖⲈⲄⲈⲰⲚ ⲚⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ⲚⲀϢ ϬⲈ ⲚϨⲈ ⲈⲨⲚⲀϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲄⲢⲀⲪⲎ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲤϢⲰⲠⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲠⲈϪⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲘⲘⲎⲎϢⲈ. ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈϬⲞⲠⲦ ⲚⲐⲈ ⲚⲞⲨⲰϪ ⲘⲚ ⲚⲈⲦⲚⲤⲎϤⲈ ⲘⲚ ⲚⲈⲦⲚϬⲈⲢⲞⲞⲂ. ⲚⲈⲒϨⲘⲞⲞⲤ ⲘⲘⲎⲚⲈ ⲠⲈ ϨⲘ ⲠⲢⲠⲈ ⲈⲒϮⲤⲂⲰ ⲀⲨⲰ ⲘⲠⲈⲦⲚⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ⲠⲀⲒ ⲆⲈ ⲦⲎⲢϤ ⲚⲦⲀϤϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲄⲢⲀⲪⲎ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲦⲞⲦⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲀⲨⲔⲰ ⲘⲘⲞϤ ⲚⲤⲰⲞⲨ ⲀⲨⲠⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲀⲘⲀϨⲦⲈ ⲚⲒⲎⲤⲞⲨⲤ. ⲀⲨϪⲒ ⲘⲘⲞϤ ϢⲀⲔⲀⲒⲪⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲘⲀ ⲚⲦⲀⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈϤⲞⲨⲎϨ ⲚⲤⲰⲞⲨ ⲘⲠⲞⲨⲈ ϢⲀⲈϨⲞⲨⲚ ⲈⲦⲀⲨⲖⲎ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲚⲈϤϨⲘⲞⲞⲤ ⲘⲚ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲚⲀⲨ ⲈⲐⲀⲎ. ");
INSERT INTO copshc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲘⲚ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲦⲎⲢϤ ⲚⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲈϨⲞⲨⲚ ⲈⲒⲎⲤⲞⲨⲤ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ⲀⲨⲰ ⲘⲠⲞⲨϨⲈ ⲈⲞⲨⲞⲚ. ⲀϨⲀϨ ⲆⲈ ⲘⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲈⲒ ⲈϨⲞⲨⲚ. ⲘⲚ ⲚⲤⲰⲤ ⲆⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲚϬⲒ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲠⲀⲒ ϪⲞⲞⲤ ϪⲈ ⲞⲨⲚϢϬⲞⲘ ⲘⲘⲞⲒ ⲈⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲢⲠⲈ ⲈⲔⲞⲦϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ⲀϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲄⲚⲀϢⲀϪⲈ ⲀⲚ. ⲀϨⲢⲞⲞⲨ ⲚⲀⲒ ⲢⲘⲚⲦⲢⲈ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈϤⲔⲰ ⲚⲢⲰϤ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈ ϮⲦⲀⲢⲔⲞ ⲘⲘⲞⲔ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ ϪⲈⲔⲀⲀⲤ ⲈⲔⲈϪⲞⲞⲤ ⲚⲀⲚ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲚⲦⲀⲔϪⲞⲞⲤ. ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲒⲚⲦⲈⲚⲞⲨ ϪⲈ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤϨⲘⲞⲞⲤ ϨⲒⲞⲨⲚⲀⲘ ⲚⲦϬⲞⲘ. ⲀⲨⲰ ⲈϤⲚⲎⲨ ⲈϨⲢⲀⲒ ϨⲒϪⲚ ⲚⲈⲔⲖⲞⲞⲖⲈ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ⲦⲞⲦⲈ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤⲠⲰϨ ⲚⲚⲈϤϨⲞⲒⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤϪⲒⲞⲨⲀ ⲚⲦⲚⲢⲬⲢⲒⲀ ⲀⲚ ⲘⲘⲚⲦⲢⲈ ϪⲒⲚⲈⲦⲈⲚⲞⲨ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲈⲚⲞⲨ ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲠⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ⲞⲨ ⲠⲈⲦⲤⲆⲞⲔⲈⲒ ⲚⲎⲦⲚ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲞ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ⲦⲞⲦⲈ ⲀⲨⲚⲈϪⲠⲀϬⲤⲈ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲈϤϨⲞ ⲀⲨⲰ ⲀⲨϮⲔⲖⲮ ⲈϪⲰϤ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϮⲀⲀⲤ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ");
INSERT INTO copshc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲚⲀⲚ ⲦⲈⲚⲞⲨ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲢⲀϨⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈϤϨⲘⲞⲞⲤ ⲠⲈ ϨⲒⲠⲤⲀⲘⲂⲞⲖ ϨⲢⲀⲒ ϨⲚ ⲦⲀⲨⲖⲎ. ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨϨⲘϨⲀⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲞⲚ ⲚⲈⲔ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲄⲀⲖⲒⲖⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲢⲚⲀ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲢϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲐⲀⲈⲒⲦ ⲀⲤⲚⲀⲨ ⲈⲢⲞϤ ⲚϬⲒ ⲔⲈⲞⲨⲈⲒ ⲠⲈϪⲀⲤ ⲚⲚⲈⲦϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲠⲀⲒ ⲈⲚⲈϤϢⲞⲞⲠ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ⲠⲀⲖⲒⲚ ⲀϤⲀⲢⲚⲀ ⲈϤⲢⲀⲚⲀϢ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ⲘⲚⲚⲤⲀ ⲞⲨⲔⲞⲨⲒ ⲆⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲠⲈⲦⲢⲞⲤ ⲚϬⲒ ⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲚⲀⲘⲈ ⲚⲦⲔⲞⲨⲈⲂⲞⲖ ϨⲰⲰⲔ ⲚϨⲎⲦⲞⲨ. ⲔⲀⲒ ⲄⲀⲢ ⲦⲈⲔⲀⲤⲠⲈ ⲞⲨⲰⲚϨ ⲘⲘⲞⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ⲦⲞⲦⲈ ⲀϤⲀⲢⲬⲈⲒ ⲚⲰⲢⲔ ⲀⲨⲰ ⲈⲔⲀⲈⲨⲰ ⲈϨⲢⲀⲒ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲢⲰⲘⲈ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲠⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ⲀϤⲢⲠⲘⲈⲈⲨⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲘⲠϢⲀϪⲈ ⲚⲦⲀⲒⲎⲤⲞⲨⲤ ϪⲞⲞϤ. ϪⲈ ⲘⲠⲀⲦⲈⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲔⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲞⲘⲚⲦ ⲚⲤⲞⲠ. ⲀⲨⲰ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲢⲒⲘⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ⲚⲦⲈⲢⲈϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ. ⲀⲨϪⲒϢⲞϪⲚⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲖⲀⲞⲤ ϨⲰⲤⲦⲈ ⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ⲀⲨⲘⲞⲢϤ ⲆⲈ ⲀⲨⲚⲦϤ ⲀⲨⲦⲀⲀϤ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲠϨⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ⲦⲞⲦⲈ ⲀϤⲚⲀⲨ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ϪⲈ ⲀⲨⲦϬⲀⲒⲞϤ ⲀϤⲢϨⲦⲎϤ ⲀϤⲔⲦⲞ ⲘⲠⲘⲀⲀⲂ ⲚϨⲀⲦ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲢⲚⲞⲂⲈ ⲀⲒϮ ⲚⲞⲨⲤⲚⲞϤ ⲚⲆⲒⲔⲀⲒⲞⲤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲘⲚ ⲦⲀⲚϨⲰⲂ ⲚⲦⲞⲔ ⲈⲦⲢⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ⲀϤⲚⲞⲨϪⲈ ⲚⲚϨⲀⲦ ⲈϨⲞⲨⲚ ⲈⲠⲢⲠⲈ ⲀϤⲀⲚⲀⲬⲰⲢⲈⲒ ⲀϤⲂⲰⲔ ⲀϤⲞϬⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲨϪⲒ ⲚⲚϨⲀⲦ ⲠⲈϪⲀⲨ ϪⲈ ⲞⲨⲔ ⲈⲜⲈⲤⲦⲈⲒ ⲈⲚⲞϪⲞⲨ ⲈⲠⲔⲞⲢⲂⲀⲚⲞⲤ ⲈⲠⲈⲒⲆⲎ ⲞⲨⲀⲤⲞⲨ ⲚⲤⲚⲞϤ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ⲀⲨϪⲒ ⲆⲈ ⲚⲞⲨϢⲞϪⲚⲈ ⲀⲨϢⲰⲠ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲦⲤⲰϢⲈ ⲘⲠⲔⲈⲢⲀⲘⲈⲨⲤ ⲈⲦⲰⲘⲤ ⲚⲚϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲦⲤⲰϢⲈ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲦⲤⲰϢⲈ ⲘⲠⲈⲤⲚⲞϤ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ⲦⲞⲦⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲚ ⲒⲈⲢⲎⲘⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϪⲒ ⲘⲠⲘⲀⲀⲂ ⲚϨⲀⲦ ⲈⲦⲦⲒⲘⲎ ⲘⲠⲈⲦⲦⲀⲒⲎⲨ. ⲠⲀⲒ ⲚⲦⲀⲨϮ ϢⲀⲀⲢ ⲈⲢⲞϤ ϨⲒⲦⲚ ⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ⲀⲨϮ ⲘⲘⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈⲦⲤⲰϢⲈ ⲘⲠⲔⲈⲢⲀⲘⲈⲨⲤ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲚ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲀϨⲈⲢⲀⲦϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠϨⲎⲄⲈⲘⲰⲚ. ⲀϤϪⲚⲞⲨϤ ⲚϬⲒ ⲠϨⲎⲄⲈⲘⲰⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ϨⲘ ⲠⲦⲢⲈⲨⲔⲀⲦⲞⲒⲄⲞⲢⲈⲒ ⲆⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲈϤⲞⲨⲰϢⲂ ⲚⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲚⲄⲤⲰⲦⲘ ⲀⲚ ϪⲈ ⲤⲈⲢⲘⲚⲦⲢⲈ ⲈⲢⲞⲔ ⲚⲞⲨⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ⲚⲦⲞϤ ⲆⲈ ⲘⲠⲈϤⲞⲨⲰϢⲂ ⲚⲖⲀⲀⲨ ⲚϢⲀϪⲈ. ϨⲰⲤⲦⲈ ⲚϤⲢϢⲠⲎⲢⲈ ⲚϬⲒ ⲠϨⲎⲄⲈⲘⲰⲚ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ⲔⲀⲦⲀϢⲀ ⲆⲈ ⲚⲈϢⲀⲢⲈⲠϨⲎⲄⲈⲘⲰⲚ ⲔⲀⲞⲨⲀ ⲈⲂⲞⲖ ⲘⲠⲘⲎⲎϢⲈ ⲈϤⲘⲎⲢ ⲠⲈⲦⲈⲚⲈⲨⲞⲨⲀϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ⲚⲈⲨⲚⲦⲀⲨ ⲆⲈ ⲘⲘⲀⲨ ⲘⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲚⲞⲨⲀ ⲈϤⲘⲎⲢ ⲈϤⲞ ⲚⲤⲞⲈⲒⲦ. ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ⲈⲨⲤⲞⲞⲨϨ ⲆⲈ ⲈϨⲞⲨⲚ ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ. ϪⲈ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲦⲢⲀⲔⲀⲚⲒⲘ ⲚⲎⲦⲚ ⲈⲂⲞⲖ. ⲂⲀⲢⲀⲂⲂⲀⲤ ϪⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ⲚⲈϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲈⲦⲂⲈ ⲞⲨⲪⲐⲞⲚⲞⲤ ⲚⲦⲀⲨⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ⲈϤϨⲘⲞⲞⲤ ⲆⲈ ϨⲒⲠⲂⲎⲘⲀ ⲀⲤϪⲞⲞⲨ ϢⲀⲢⲞϤ ⲚϬⲒ ⲦⲈϤⲤϨⲒⲘⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲀϨⲰⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲆⲒⲔⲀⲒⲞⲤ. ⲀⲒϢⲠϨⲀϨ ⲄⲀⲢ ⲚϨⲒⲤⲈ ⲘⲠⲞⲞⲨ ϨⲚ ⲞⲨⲢⲀⲤⲞⲨ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲠⲈⲒⲐⲈ ⲘⲠⲘⲎⲎϢⲈ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲀⲒⲦⲈⲒ ⲚⲂⲀⲢⲀⲂⲂⲀⲤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠϨⲎⲄⲈⲘⲰⲚ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲦⲢⲀⲔⲀⲚⲒⲘ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲤⲚⲀⲨ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ⲠⲈϪⲀϤ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ. ϪⲈ ⲦⲀⲢⲞⲨ ϬⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲈϪⲀⲨ ⲦⲎⲢⲞⲨ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲄⲀⲢ ⲘⲠⲈⲐⲞⲞⲨ ⲠⲈⲚⲦⲀϤⲀⲀϤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲚⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲚϤⲚⲀϮϨⲎⲨ ⲚⲖⲀⲀⲨ ⲀⲚ. ⲀⲖⲖⲀ ⲈⲢⲈⲞⲨϢⲦⲞⲢⲦⲢ ⲚⲀϢⲰⲠⲈ ⲚϨⲞⲨⲞ. ϤϪⲒ ⲚⲞⲨⲘⲞⲞⲨ ⲀϤⲈⲒⲰ ⲚⲚⲈϤϬⲒϪ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲘⲎⲎϢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲚⲞϤ ⲘⲠⲈⲒⲢⲰⲘⲈ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲢⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈϤⲤⲚⲞϤ ϨⲒϪⲰⲚ ⲘⲚ ⲚⲈⲚϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ⲦⲞⲦⲈ ⲀϤⲔⲰ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲂⲀⲢⲀⲂⲂⲀⲤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲪⲢⲀⲄⲈⲖⲖⲞⲨ ⲘⲘⲞϤ ⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ⲦⲞⲦⲈ ⲘⲘⲀⲦⲞⲒ ⲘⲠϨⲎⲄⲈⲘⲰⲚ ⲚⲦⲈⲢⲞⲨϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲚⲦⲈⲤⲠⲈⲒⲢⲀ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ⲀⲨⲔⲰ ⲘⲘⲞϤ ⲔⲀϨⲎⲨ ⲀⲨϮ ϨⲒⲰⲰϤ ⲚⲞⲨⲬⲖⲀⲘⲨⲤ ⲚⲔⲞⲔⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ⲀⲨⲰ ⲀⲨϢⲰⲚⲦ ⲚⲞⲨⲔⲖⲞⲘ ⲈⲂⲞⲖ ϨⲚ ⲚϢⲞⲚⲦⲈ ⲀⲨⲦⲀⲖⲞ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ. ⲀⲨⲰ ⲞⲨⲔⲀϢ ϨⲚ ⲦⲈϤϬⲒϪ ⲚⲞⲨⲚⲀⲘ. ⲀⲨⲠⲀϨⲦⲞⲨ ⲆⲈ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ⲈⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀⲒⲢⲈ ⲠⲢⲢⲞ ⲚⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ⲀⲨⲚⲈϪⲠⲀϬⲤⲈ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀⲨϪⲒ ⲘⲠⲔⲀϢ ⲀⲨⲢⲰϨⲦ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ⲚⲦⲈⲢⲞⲨⲤⲰⲂⲈ ⲆⲈ ⲘⲘⲞϤ ⲀⲨⲔⲰ ⲘⲘⲞϤ ⲔⲀϨⲎⲨ ⲚⲦⲈⲬⲖⲀⲘⲨⲤ ⲀⲨϮ ϨⲒⲰⲰϤ ⲚⲚⲈϤϨⲞⲒⲦⲈ. ⲀⲨϪⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲈⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨϨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲔⲨⲢⲎⲚⲚⲀⲒⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ. ⲀⲨⲔⲰⲰⲂⲈ ⲘⲠⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϤⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲨⲘⲀ ⲚϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲄⲞⲖⲄⲞⲐⲀ ⲈⲦⲈⲠⲘⲀ ⲘⲠⲈⲔⲢⲀⲚⲒⲞⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨⲎⲢⲠ ⲈⲤⲞⲞϤ ⲈϤⲦⲎϨ ϨⲒⲤⲒϢⲈ. ⲚⲦⲈⲢⲈϤⲦⲞⲠϤ ⲆⲈ ⲘⲠⲈϤⲞⲨⲰϢ ⲈⲤⲞⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ⲚⲦⲈⲢⲞⲨⲤⲦⲀⲨⲢⲞⲨ ⲆⲈ ⲘⲘⲞϤ ⲀⲨⲠⲰϢ ⲚⲚⲈϤϨⲞⲒⲦⲈ ⲈϨⲢⲀⲨ ⲀⲨⲚⲈϪⲔⲖⲎⲢⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ⲀⲨⲰ ⲚⲈⲨϨⲘⲞⲞⲤ ⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞϤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ⲀⲨⲔⲰ ⲆⲈ ⲚⲦⲈϤⲀⲒⲦⲒⲀ ⲈⲤⲤⲎϨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲢⲢⲞ ⲚⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ⲦⲞⲦⲈ ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲚⲘⲘⲀϤ ⲚⲔⲈⲤⲞⲞⲚⲈ ⲤⲚⲀⲨ. ⲞⲨⲀ ϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞϤ ⲀⲨⲰ ⲞⲨⲀ ϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ⲚⲈⲦⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲚⲈⲨϪⲒⲞⲨⲀ ⲈⲢⲞϤ ⲈⲨⲔⲒⲘ ⲚⲚⲈⲨⲀⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ⲈⲨϪⲰ ⲘⲘⲞⲤ. ϪⲈ ⲠⲈⲦⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲢⲠⲈ ⲈⲦⲔⲰⲦ ⲘⲘⲞϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲘⲀⲦⲞⲨϪⲞⲔ. ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲒ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ϪⲈ ⲀϤⲦⲞⲨϪⲈϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲒⲈⲘⲚ ϢϬⲞⲘ ⲘⲘⲞϤ ⲈⲦⲞⲨϪⲞϤ. ⲠⲢⲢⲞ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲠⲈ ⲘⲀⲢⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲦⲈⲚⲞⲨ ϨⲒ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ⲈϢϪⲈ ⲀϤⲚⲀϨⲦⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲘⲀⲢⲈϤⲚⲀϨⲘⲈϤ ⲦⲈⲚⲞⲨ. ⲈϢϪⲈ ϤⲞⲨⲀϢϤ. ⲀϤϪⲞⲞⲤ ⲄⲀⲢ ϪⲈ ⲀⲚⲄⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ⲚⲔⲈⲤⲞⲞⲚⲈ ⲆⲈ ⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞⲞⲨ ⲚⲘⲘⲀϤ. ⲚⲈⲨϪⲰ ϨⲰⲞⲨ ⲘⲠⲀⲒ ⲈⲨⲚⲞϬⲚⲈϬ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ϪⲒⲚⲈⲠⲚⲀⲨ ⲆⲈ ⲚϪⲠⲤⲞ ⲘⲠⲈϨⲞⲞⲨ ⲞⲨⲔⲀⲔⲈ ⲀϤϢⲰⲠⲈ ⲈϨⲢⲀⲒ ϨⲒϪⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ ϢⲀⲠⲚⲀⲨ ⲚϪⲠⲮⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ϨⲘ ⲠⲚⲀⲨ ⲆⲈ ⲚϪⲠⲮⲒⲦⲈ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲖⲰⲈⲒ ⲈⲖⲰⲈⲒ. ⲖⲀⲘⲀ ⲤⲀⲂⲀⲔⲦⲀⲚⲈⲒ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀⲚⲞⲨⲦⲈ ⲠⲀⲚⲞⲨⲦⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲔⲔⲀⲀⲦ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ϨⲞⲒⲚⲈ ⲆⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈⲠⲀⲒ ⲘⲞⲨⲦⲈ ⲈϨⲎⲖⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ⲀⲞⲨⲀ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲠⲰⲦ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϪⲒ ⲚⲞⲨⲤⲠⲞⲄⲄⲞⲤ ⲀϤⲘⲀϨⲤ ⲚϨⲘϪ ⲀϤⲘⲞⲢⲈⲤ ⲈⲨⲔⲀϢ ⲀϤⲦⲤⲞ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ⲠⲔⲈⲤⲈⲈⲠⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲰ ⲚⲦⲚⲚⲀⲨ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲚⲎⲨ ⲈⲚⲞⲨϨⲘ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ. ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲀϤⲔⲰ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤ ⲠⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲘⲠⲢⲠⲈ ⲀϤⲠⲰϨ ϪⲒⲚⲦⲠⲈ ⲈⲠⲈⲤⲎⲦ ⲀϤⲢⲤⲚⲀⲨ ⲠⲔⲀϨ ⲀϤⲚⲞⲈⲒⲚ ⲀⲨⲰ ⲘⲠⲈⲦⲢⲀ ⲀⲨⲠⲰϨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ⲚⲈⲘϨⲀⲀⲨ ⲀⲨⲞⲨⲰⲚ ⲀⲨⲦⲰⲞⲨⲚ ⲚϬⲒ ϨⲀϨ ⲚⲤⲰⲘⲀ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ ⲚⲦⲀⲨⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲘϨⲀⲀⲨ. ⲘⲚⲚⲤⲀ ⲦⲢⲈⲨⲦⲰⲞⲨⲚ ⲆⲈ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲈⲦⲞⲨⲀⲀⲂ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲂⲞⲖ ⲚϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ⲈⲦϨⲀⲢⲈϨ ⲈⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲔⲘⲦⲞ ⲘⲚ ⲚⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲀⲨⲢϨⲞⲦⲈ ⲈⲘⲀⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲘⲈ ⲚⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ⲈⲚⲈⲨⲘⲘⲀⲨ ⲆⲈ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲚⲤϨⲒⲘⲈ ⲈⲨϬⲰϢⲦ ⲘⲠⲞⲨⲈ ⲚⲀⲒ ⲚⲦⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲨⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ⲚⲀⲒ ⲈⲨⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲦⲈ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲘⲚ ⲘⲀⲢⲒⲀ ⲦⲀⲒⲀⲔⲰⲂⲞⲤ. ⲘⲚ ⲦⲘⲀⲀⲨ ⲚⲒⲰⲤⲎ ⲀⲨⲰ ⲦⲘⲀⲀⲨ ⲚⲚϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲀϤⲈⲒ ⲚϬⲒ ⲞⲨⲢⲰⲘⲈ ⲚⲢⲘⲘⲀⲞ ⲈⲂⲞⲖ ϨⲚ ⲀⲢⲒⲘⲀⲐⲀⲒⲀ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ. ⲠⲀⲒ ⲈⲀϤⲘⲀⲐⲎⲦⲈⲨⲈ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲆⲈ ⲈⲠⲒⲖⲀⲦⲞⲤ. ⲀϤⲀⲒⲦⲈⲒ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ. ⲦⲞⲦⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲨⲦⲀⲀϤ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ⲀϤϪⲒ ⲆⲈ ⲘⲠⲤⲰⲘⲀ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲀϤⲔⲰⲰⲤ ⲘⲘⲞϤ ⲚⲞⲨⲤⲒⲚⲆⲰⲚ ⲈⲤⲢⲀϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ⲀϤⲔⲰ ⲘⲘⲞϤ ϨⲘ ⲠⲈϤⲘϨⲀⲀⲨ ⲚⲂⲢⲢⲈ ⲠⲀⲒ ⲚⲦⲀϤⲔⲈϨⲔⲰϨϤ ϨⲢⲀⲒ ϨⲚ ⲦⲠⲈⲦⲢⲀ. ⲀϤⲤⲔⲞⲢⲔⲢ ⲚⲞⲨⲚⲞϬ ⲚⲰⲚⲈ ⲈⲢⲘⲠⲢⲞ ⲘⲠⲈⲘϨⲀⲀⲨ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ⲈⲚⲈⲤⲘⲘⲀⲨ ⲆⲈ ⲚϬⲒ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ. ⲘⲚ ⲦⲔⲈⲘⲀⲢⲒⲀ ⲈⲨϨⲘⲞⲞⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲈⲦⲈ ⲘⲚⲚⲤⲀ ⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲠⲈ. ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲚⲢⲠⲘⲈⲈⲨⲈ ϪⲈ ⲠⲈⲒⲠⲖⲀⲚⲞⲤ ⲀϤϪⲞⲞⲤ ϪⲒⲚⲈϤⲞⲚϨ. ϪⲈ ϮⲚⲀⲦⲰⲞⲨⲚ ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ⲞⲨⲈϨⲤⲀϨⲚⲈ ϬⲈ ⲈⲦⲢⲈⲚⲰⲢϪ ⲘⲠⲦⲀⲪⲞⲤ ϢⲀⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈⲈⲒ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲤⲈϤⲒⲦϤ ⲚϪⲒⲞⲨⲈ ⲚⲤⲈϪⲞⲞⲤ ⲘⲠⲖⲀⲞⲤ ϪⲈ ⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲚⲦⲈⲐⲀⲎ ⲘⲠⲖⲀⲚⲎ ⲐⲞ ⲈⲦϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ. ϪⲈ ϪⲒ ⲚⲦⲔⲞⲨⲤⲦⲰⲆⲒⲀ ⲚⲦⲈⲦⲚⲂⲰⲔ ⲚⲦⲈⲦⲚⲞⲢϪϤ ⲚⲐⲈ ⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲂⲰⲔ ⲀⲨⲰⲢϪ ⲘⲠⲦⲀⲪⲞⲤ ⲈⲀⲨⲤⲪⲢⲀⲄⲒⲌⲈ ⲘⲠⲰⲚⲈ ⲘⲚ ⲦⲔⲞⲨⲤⲦⲰⲆⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ⲢⲞⲨϨⲈ ⲆⲈ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈϨⲦⲞⲞⲨⲈ ⲚⲤⲞⲨⲀ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ⲀⲤⲈⲒ ⲚϬⲒ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲘⲚ ⲦⲔⲈⲘⲀⲢⲒⲀ ⲈⲚⲀⲨ ⲈⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲤⲞⲨⲚⲞϬ ⲚⲔⲘⲦⲞ ⲀϤϢⲰⲠⲈ. ⲠⲀⲄⲄⲈⲖⲞⲤ ⲄⲀⲢ ⲘⲠϪⲞⲈⲒⲤ ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ϨⲚ ⲦⲠⲈ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲀϤⲤⲔⲞⲢⲔⲢ ⲘⲠⲰⲚⲈ. ⲀϤϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ⲠⲈϤⲈⲒⲚⲈ ⲆⲈ ⲚⲈϤⲞ ⲚⲐⲈ ⲚⲞⲨⲈⲂⲢⲎϬⲈ ⲀⲨⲰ ⲦⲈϤϨⲂⲤⲰ ⲚⲈⲤⲞⲨⲞⲂϢ ⲚⲐⲈ ⲚⲞⲨⲬⲒⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲦⲈϤϨⲞⲦⲈ ⲀⲨⲚⲞⲈⲒⲚ ⲚϬⲒ ⲚⲈⲦϨⲀⲢⲈϨ. ⲀⲨϢⲰⲠⲈ ⲚⲐⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲠⲈϪⲀϤ ⲚⲚⲈϨⲒⲞⲘⲈ ϪⲈ ⲚⲦⲰⲦⲚ ⲘⲠⲢⲢϨⲞⲦⲈ. ϮⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ⲚϤⲘⲠⲈⲒⲘⲀ ⲀⲚ ⲀϤⲦⲰⲞⲨⲚ ⲄⲀⲢ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀϤϪⲞⲞⲤ. ⲀⲘⲎⲒⲦⲚ ⲚⲦⲈⲦⲚⲚⲀⲨ ⲈⲠⲘⲀ ⲈⲚⲈϤⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ⲀⲨⲰ ⲚⲦⲈⲦⲚⲂⲰⲔ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲚⲦⲈⲦⲚϪⲞⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤⲚⲀⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲚ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲦⲈⲦⲚⲀⲚⲀⲨ ⲈⲢⲞϤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ⲀⲨⲂⲰⲔ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲘϨⲀⲀⲨ ⲀⲨⲠⲰⲦ ϨⲚ ⲞⲨϨⲞⲦⲈ ⲘⲚⲞⲨⲚⲞϬ ⲚⲢⲀϢⲈ ⲈϪⲒⲠⲞⲨⲰ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲒⲎⲤⲞⲨⲤⲒⲤ ⲀϤⲦⲰⲘⲚⲦ ⲈⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀⲒⲢⲀⲒⲦⲈ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲀⲨⲀⲘⲀϨⲦⲈ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲀⲨⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲂⲰⲔ ⲚⲦⲈⲦⲚϪⲒⲠⲞⲨⲰ ⲚⲚⲀⲤⲚⲎⲨ ϪⲈⲔⲀⲀⲤ ⲈⲨⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲨⲚⲀⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲞⲒ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ⲚⲦⲞⲞⲨ ⲆⲈ ⲈⲨⲂⲎⲔ ⲈⲒⲤϨⲞⲒⲚⲈ ⲚⲦⲔⲞⲨⲤⲦⲰⲆⲒⲀ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲀⲨϪⲒⲠⲞⲨⲰ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲚⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ⲀⲨⲤⲰⲞⲨϨ ⲆⲈ ⲈϨⲞⲨⲚ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ⲀⲨϪⲒ ⲚⲞⲨϢⲞϪⲚⲈ ⲀⲨϮ ⲚϨⲚⲚⲞϬ ⲚϨⲞⲘⲚⲦ ⲚⲘⲘⲀⲦⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϪⲒⲤ ϪⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲚⲦⲀⲨⲈⲒ ⲚⲦⲈⲨϢⲎ ⲀⲨϤⲒⲦϤ ⲚϪⲒⲞⲨⲈ ⲈⲚⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲨϢⲀⲚⲤⲈⲦⲘⲠⲀⲒ ⲚϬⲒ ⲠϨⲎⲄⲈⲘⲰⲚ ⲀⲚⲞⲚ ⲦⲚⲚⲀⲠⲈⲒⲐⲈ ⲘⲘⲞϤ ⲚⲦⲚⲢⲦⲎⲨⲦⲚ ⲚⲀⲦⲢⲞⲞⲨϢ. ");
INSERT INTO copshc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨϪⲒ ⲚⲚϨⲞⲘⲚⲦ ⲀⲨⲈⲒⲢⲈ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀⲨϮⲤⲂⲰ ⲚⲀⲨ. ⲠⲈⲒϢⲀϪⲈ ⲀϤϮⲤⲞⲈⲒⲦ ϨⲚ ⲚⲒⲞⲨⲆⲀⲒ ϢⲀⲈϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ⲠⲘⲚⲦⲞⲨⲈ ⲆⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈϨⲢⲀⲒ ⲈⲠⲦⲞⲞⲨ ⲚⲦⲀϤⲦⲀⲤⲤⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲀⲨⲞⲨⲰϢⲦ ⲚⲀϤ ϨⲞⲒⲚⲈ ⲆⲈ ⲀⲨⲆⲒⲤⲆⲀⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϮ ⲚⲀⲒ ⲚⲈⲜⲞⲨⲤⲒⲀ ⲚⲒⲘ ϨⲚ ⲦⲠⲈ. ⲀⲨⲰ ϨⲒϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ⲂⲰⲔ ϬⲈ ⲚⲦⲈⲦⲚϮⲤⲂⲰ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ⲚⲦⲈⲦⲚⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲞⲞⲨ ⲈⲠⲢⲀⲚ ⲘⲠⲈⲒⲰⲦ ⲘⲚ ⲠϢⲎⲢⲈ ⲘⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ⲈⲦⲈⲦⲚϮⲤⲂⲰ ⲚⲀⲨ ⲈϨⲀⲢⲈϨ ⲈϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀⲒϨⲞⲚⲞⲨ ⲈⲦⲈⲦⲎⲨⲦⲚ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ ⲚⲚⲈϨⲞⲞⲨ ⲦⲎⲢⲞⲨ ϢⲀⲈϨⲢⲀⲒ ⲈⲦⲤⲨⲚⲦⲈⲖⲈⲒⲀ ⲘⲠⲀⲒⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ⲦⲀⲢⲬⲎ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ⲔⲀⲦⲀ ⲠⲈⲦⲤⲎϨ ϨⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲀϪⲈⲨⲠⲀⲀⲄⲄⲈⲖⲞⲤ ϨⲒϨⲎ ⲘⲘⲞⲔ ⲚϤⲤⲂⲦⲈ ⲦⲈⲔϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ⲠⲈϨⲢⲞⲞⲨ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ ϪⲈ ⲤⲞⲨⲦⲚ ⲦⲈϨⲒⲎ ⲘⲠϪⲞⲈⲒⲤ ⲚⲦⲈⲦⲚ ⲤⲞⲨⲦⲚⲚⲈϤⲘⲞⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ⲀϤϢⲰⲠⲈ ⲆⲈ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ⲈϤϮⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲠϪⲀⲒⲈ ⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲚⲞⲨⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ⲈⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ⲀⲨⲰ ⲀⲤⲂⲰⲔ ⲚⲀϤ ⲈⲂⲞⲖ ⲚϬⲒ ⲦⲈⲬⲰⲢⲀ ⲦⲎⲢⲤ ⲚϮⲞⲨⲆⲀⲒⲀ ⲚⲘⲚⲀ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲎⲢⲞⲨ ⲀⲨϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲦⲞⲞⲦϤ ϨⲘ ⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲠⲒⲈⲢⲞ ⲈⲨⲈⲜⲞⲘⲞⲖⲞⲄⲒ ⲚⲚⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ⲀⲨⲰ ⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲈⲢⲈϨⲈⲚϤⲰ ⲚϬⲀⲘⲞⲨⲖ ⲦⲞ ϨⲒⲰⲰϤ ⲈⲢⲈⲞⲨⲘⲞϪ ⲚϢⲀⲀⲢ ⲘⲎⲢ ⲈⲦⲈϤϮⲠⲈ. ⲈϤⲞⲨⲈⲘϢϪⲈ ϨⲒⲈⲂⲒⲰ ⲚϨⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ⲀⲨⲰ ⲚⲈϤⲦⲀϢⲈⲞⲒϢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲚⲎⲨ ⲘⲚⲚⲤⲰⲈⲒ ⲚϬⲒ ⲠⲈⲦϪⲞⲞⲢ ⲈⲢⲞⲈⲒ ⲈⲀⲚⲄⲞⲨϨⲒⲔⲀⲚⲞⲤ ⲀⲚ ⲈⲠⲀϨⲦ ⲈⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲘⲞⲨⲤ ⲘⲠⲈϤⲦⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ⲀⲚⲞⲔ ⲀⲈⲒϮⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲎⲦⲚ ϨⲚ ⲞⲨⲘⲞⲞⲨ. ⲚⲦⲞϤ ⲆⲈ ⲈϤⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ⲀⲨⲰ ⲀⲤϢⲰⲠⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ ⲚⲦⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲰ ⲀϤϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ϨⲘ ⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲚⲦⲚⲒⲰϨⲀⲚⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈϤⲚⲎⲨ ⲈϨⲢⲀⲒ ⲘⲠⲘⲞⲞⲨ ⲀϤⲚⲀⲨ ⲈⲘⲠⲎⲨⲈ ⲈⲀⲨⲞⲨⲰⲚ ⲀⲨⲰ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈϤⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲈϪⲰϤ ⲚⲐⲈ ⲚⲞⲨϬⲢⲞⲞⲘⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ⲀⲨⲰ ⲞⲨⲤⲘⲎ ⲀⲤϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲘⲠⲎⲨⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲘⲈⲢⲒⲦ ⲈⲚⲦⲀⲠⲀⲞⲨⲰϢ ϢⲰⲠⲈ ⲚϨⲎⲦⲔ ");
INSERT INTO copshc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ⲀⲨⲰ ⲦⲈⲨⲚⲞⲨ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲀϤϪⲒⲦϤ ⲈⲂⲞⲖ ⲈⲦⲈⲢⲎⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ⲀⲨⲰ ⲚⲈϤϨⲚⲦⲈⲢⲎⲘⲞⲤ ⲚϨⲘⲈ ⲚϨⲞⲞⲨ ⲈⲢⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲈϤϢⲞⲞⲠ ⲘⲚ ⲚⲈⲐⲎⲢⲒⲞⲚ. ⲀⲨⲰ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲚⲈⲨⲆⲒⲀⲔⲞⲚⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ⲘⲚⲚⲤⲀⲚⲤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ϪⲈ ⲀⲠⲈⲨⲞⲒϢ ϪⲰⲔ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀⲤϨⲰⲚ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲈⲦⲀⲚⲞⲒ ⲚⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ϨⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ⲀⲨⲰ ⲈϤⲘⲞⲞϢⲈ ϨⲀⲦⲚⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀϤⲚⲀⲨ ⲈⲤⲒⲘⲰⲚ ⲚⲘⲀⲚⲆⲢⲈⲀⲤ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲈⲨⲚⲞⲨϪϢⲚⲈ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲚⲈϨⲈⲚⲞⲨⲰϨⲈ ⲄⲀⲢ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲈⲒⲚ ⲞⲨⲈϨⲦⲎⲨⲦⲚ ⲚⲤⲰⲈⲒ ⲀⲨⲰ ϮⲚⲀⲢⲦⲎⲨⲦⲚ ⲚⲞⲨⲰϨⲈ ⲚⲢⲈϤϬⲈⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲨⲔⲀⲚⲈⲨϢⲚⲎⲨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲘⲞⲞϢⲈ ⲈⲐⲎ ⲚⲞⲨⲔⲞⲨⲈⲒ ⲀϤⲚⲀⲨ ⲈⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ⲚⲦⲞⲞⲨ ϨⲰⲞⲨ ⲈⲨϨⲘⲠϪⲞⲈⲒ ⲈⲨⲤⲞⲂⲦⲈ ⲚⲚⲈⲨϢⲚⲎⲨ ");
INSERT INTO copshc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲀⲨⲔⲀⲠⲈⲨⲒⲰⲦ ⲌⲈⲂⲈⲆⲀⲒⲞⲤ ϨⲘ ⲠϪⲞⲈⲒ ⲘⲚⲚϪⲀⲒⲂⲈⲔⲈ ⲀⲨⲂⲰⲔ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ⲀⲨⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲀϤϮⲤⲂⲰ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ");
INSERT INTO copshc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈϪⲚ ⲦⲈϤⲤⲂⲰ ⲈϤϮⲤⲂⲰ ⲄⲀⲢ ⲚⲀⲨ ⲚⲐⲈ ⲀⲚ ⲈⲦⲞⲨϮⲤⲂⲰ ⲚϬⲒ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ϨⲰⲤⲈⲨⲚⲦϤⲦⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϨⲢⲞⲔ ⲚⲘⲘⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲚⲦⲀⲔⲈⲒ ⲈⲦⲀⲔⲞⲚ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞⲔ ϪⲈ ⲚⲦⲔⲚⲒⲘ ⲚⲦⲔⲠⲈⲦⲞⲨⲀⲀⲂ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲘⲢⲰⲔ ⲚⲄⲈⲒ ⲈⲂⲞⲖ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲢⲀϨⲦϤ ⲈⲠⲔⲀϨ ⲀⲨⲰ ⲀϤⲰϢ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚϨⲢⲞⲞⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ⲦⲎⲢⲞⲨ ϨⲰⲤⲦⲈ ⲚⲤⲈϢⲀϪⲈ ⲚⲘ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲀⲒ ⲈⲒⲤⲞⲨⲤⲂⲰ ⲂⲂⲢⲢⲈ ϨⲚ ⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲚⲔⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲨ ⲀⲨⲰ ⲤⲈⲤⲰⲦⲘ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ⲀⲠⲈϤⲤⲞⲈⲒⲦ ⲂⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲈⲨⲚⲞⲨ ϨⲘ ⲘⲀ ⲚⲒⲘ ⲘⲠⲔⲰⲦⲈ ⲦⲎⲢϤ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲚⲤⲒⲘⲰⲚ ⲘⲚⲀⲚⲆⲢⲈⲀⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ⲦϢⲰⲘⲈ ⲆⲈ ⲚⲤⲒⲘⲰⲚ ⲚⲈⲤⲚⲎϪ ⲈⲤϨⲎⲘ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨϢⲀϪⲈ ⲚⲘⲘⲀϤ ⲈⲦⲂⲎⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ⲀϤϮⲠⲈϤⲞⲨⲞⲈⲒ ⲆⲈ ⲈⲢⲞⲤ ⲀϤⲦⲞⲨⲚⲞⲤ ⲈⲀϤⲀⲘⲀϨⲦⲈ ⲚⲦⲈⲤϬⲒϪ ⲀⲨⲰ ⲠⲈϨⲘⲞⲘ ⲀϤⲖⲞ ϨⲒⲰⲰⲤ ⲀⲤⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲠⲈ ⲈⲢⲈⲠⲢⲎ ⲚⲀϨⲰⲦⲠ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲚⲈⲦⲘⲞⲔϨ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲦⲈⲢⲈⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ⲀⲨⲰ ⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲀⲤⲤⲰⲞⲨϨ ϨⲒⲢⲘⲠⲢⲞ ⲘⲠⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ⲀϤⲐⲈⲢⲀⲠⲞⲨ ⲚⲞⲨⲘⲎⲎϢⲈ ⲈⲨⲘⲞⲔϨ ⲚϢⲰⲚⲈ ⲈⲨϢⲞⲂⲈ ⲀⲨⲰ ⲞⲨⲘⲎⲎϢⲈ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲀϤⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ⲈⲘⲀϤⲔⲀⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈϢⲀϪⲈ ⲈⲂⲞⲖ ϪⲈ ⲈⲨⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ⲀⲨⲰ ϨⲦⲞⲞⲨ ⲈⲘⲀⲦⲈ ⲚⲦⲈⲢⲈϤⲦⲰⲞⲨⲚ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ⲈⲨⲘⲀ ⲚϪⲀⲒⲈ ⲀϤϢⲖⲎⲖ ⲘⲠⲚⲀⲨ ⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ⲀⲨⲰ ⲀⲨⲠⲰⲦ ⲈⲂⲞⲖ ⲚⲤⲰϤ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ⲀⲨⲦⲀϨⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲈⲔⲰⲦⲈ ⲚⲤⲰⲔ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲀⲢⲞⲚ ⲈⲔⲈⲘⲀ ⲈⲚⲔⲈⲦⲘⲘⲞ ⲈⲦϨⲎⲚ ⲈϨⲞⲨⲚ ϪⲈⲔⲀⲀⲤ ⲈⲒⲈⲔⲎⲢⲨⲤⲤⲈ ⲞⲚ ⲚϨⲎⲦⲞⲨ ⲚⲦⲀⲒⲈⲒ ⲄⲀⲢ ⲈⲂⲞⲖ ⲈⲠⲈⲒϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϤⲔⲎⲢⲨⲤⲤⲈ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲦⲎⲢⲤ ⲀⲨⲰ ⲚⲔⲈⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈϤⲚⲞⲨϪⲈ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ⲀⲨⲰ ⲀϤⲈⲒ ϢⲀⲢⲞϤ ⲚϬⲒ ⲞⲨⲢⲰⲘⲈ ⲈϤⲤⲞⲂϨ ⲈϤⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲔϢⲀⲚⲞⲨⲰϢ ⲔⲚⲀⲦⲂⲂⲞⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϢⲚϨⲦⲎϤ ⲀϤⲤⲞⲨⲦⲚⲦⲞⲞⲦϤ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀϤⲔⲰϨ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϮⲞⲨⲰϢ ⲦⲂⲂⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲠⲈϤⲤⲰⲂⲀϨ ⲖⲞ ϨⲒⲰⲰϤ ⲀϤⲦⲂⲂⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲈⲦⲞⲞⲦϤ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϪⲞⲞⲨϤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϬⲰϢⲦ ⲘⲠⲢϪⲞⲞⲤ ⲚⲖⲀⲀⲨ. ⲀⲖⲖⲀ ⲂⲰⲔ ⲚⲄⲦⲤⲀⲂⲞⲔ ⲈⲠⲞⲨⲎⲎⲂ ⲚⲄϪⲒ ⲈϨⲢⲀⲒ ⲈⲦⲂⲈ ⲠⲈⲔⲦⲂⲂⲞ ⲚⲚⲈⲚⲦⲀⲘⲰⲨⲤⲎⲤ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲞⲨ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀϤⲀⲢⲬⲈⲤⲐⲀⲒ ⲚⲦⲀϢⲈⲞⲒϢ ⲚϨⲀϨ ⲀⲨⲰ ⲈⲤⲢⲠϢⲀϪⲈ ϨⲰⲤⲦⲈ ⲚϤⲦⲘϬⲘϬⲞⲘ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲚⲞⲨⲰⲚϨ ⲀⲖⲖⲀ ⲚⲈϤϨⲚϨⲈⲚⲘⲀ ⲚϪⲀⲒⲈ ⲀⲨⲰ ⲚⲈⲨⲚⲎⲨ ⲈⲢⲀⲦϤ ⲈⲂⲞⲖ ϨⲘ ⲘⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ϨⲒϪⲚ ϨⲈⲚϨⲞⲞⲨ ⲀⲨⲤⲰⲦⲘ ϪⲈ ϤϨⲚⲞⲨⲎⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ⲀⲨⲰ ⲀⲨⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲈⲘⲀⲨ ϨⲰⲤⲦⲈ ⲚⲦⲈⲦⲚⲘⲈϢ ϨⲒⲢⲘⲠⲢⲞ ϢⲞⲠⲞⲨ. ⲀⲨⲰ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϨⲘ ⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ⲀⲨⲈⲒⲚⲈ ⲆⲈ ⲈⲢⲀⲦϤ ⲚⲞⲨⲢⲰⲘⲈ ⲈϤⲤⲎϬ ⲈⲢⲈϤⲦⲞⲞⲨ ⲚⲢⲰⲘⲈ ϤⲒ ϨⲀⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ⲀⲨⲰ ⲘⲠⲞⲨϢⲂⲰⲔ ⲚⲀϤ ⲈϨⲞⲨⲚ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ ⲀⲨϬⲈⲖⲠⲦⲞⲨⲈϨⲤⲞⲒ ⲈⲂⲞⲖ ⲘⲠⲘⲀ ⲈⲦϤⲚϨⲎⲦϤ ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϢⲞϪⲦ ⲀⲨⲬⲀⲖⲀ ⲘⲠⲈϬⲖⲞϬ ⲈⲠⲈⲤⲎⲦ ⲠⲈⲦⲈⲢⲈ ⲠⲈⲦⲤⲎϬ ⲚⲎϪ ϨⲒϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲦⲈⲨⲠⲒⲤⲦⲒⲤ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲤⲎϬ ϪⲈ ⲠⲀϢⲎⲢⲈ ⲤⲈⲚⲀⲔⲀⲚⲈⲔⲚⲞⲂⲈ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ⲚⲈⲨⲚϨⲞⲒⲚⲈ ⲆⲈ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ϨⲘⲞⲞⲤ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲨⲘⲞⲔⲘⲈⲔ ϨⲚ ⲚⲈⲨϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ϪⲈ ⲈⲦⲂⲈⲞⲨ ⲠⲀⲒ ϤϢⲀϪⲈ ϨⲒⲚⲀⲒ ⲈϤϪⲒⲞⲨⲀ ⲚⲒⲘ ⲠⲈⲦⲚⲀϢⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ ⲚⲤⲀⲠⲚⲞⲨⲦⲈ ⲘⲀⲞⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ϨⲘ ⲠⲈϤⲠⲚⲈⲨⲘⲀ ϪⲈ ⲤⲈⲘⲞⲔⲘⲈⲔ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈⲞⲨ ⲦⲈⲦⲚⲘⲈⲨⲈ ⲈⲚⲀⲒ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ⲀϢ ⲄⲀⲢ ⲠⲈⲦⲘⲞⲦⲚ ⲈϪⲞⲞⲤ ⲘⲠⲈⲦⲤⲎϬ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄϤⲒⲠⲈⲔϬⲖⲞϬ ⲚⲄⲘⲞⲞϢⲈ ϪⲚⲈϪⲞⲞⲤ ϪⲈ ⲤⲈⲚⲀⲔⲀⲚⲈⲔⲚⲞⲂⲈ ⲚⲀⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ϪⲈⲔⲀⲀⲤ ⲆⲈ ⲈⲦⲈⲦⲚⲈⲚⲀⲨ ϪⲈ ⲞⲨⲚⲦϤⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ ϨⲒϪⲘⲠⲔⲀϨ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲤⲎϬ ");
INSERT INTO copshc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ϪⲈ ⲦⲰⲞⲨⲚ ⲈⲒϪⲈⲢⲞⲔ ϤⲒ ⲘⲠⲈⲔϬⲖⲞϬ ⲂⲰⲔ ⲈⲠⲈⲔⲎⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ⲀⲨⲰ ⲀϤⲦⲰⲞⲨⲚ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲦⲀⲖⲈⲠⲈϤϬⲖⲞϬ ⲈϪⲰϤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲒ ⲐⲎ ⲘⲘⲞⲞⲨ ⲦⲎⲢⲞⲨ ϨⲰⲤⲦⲈ ⲚⲤⲈⲢϢⲠⲎⲢⲈ ⲦⲎⲢⲞⲨ ⲚⲤⲈϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲚⲚⲀⲨ ⲈⲞⲨⲞⲚ ⲈⲚⲈϨ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ⲀϤⲈⲒ ⲞⲚ ⲈⲂⲞⲖ ϨⲀⲦⲚⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲀⲨⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲀϤϮⲤⲂⲰ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ⲀⲨⲰ ⲈϤⲠⲀⲢⲀⲄⲈ ⲀϤⲚⲀⲨ ⲈⲖⲈⲞⲨⲈⲒ ⲠϢⲎⲢⲈ ⲚⲀⲖⲪⲀⲒⲞⲤ ⲈϤϨⲘⲞⲞⲤ ϨⲒⲠⲈϤⲦⲈⲖⲰⲚⲒⲞⲚ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ ⲀⲨⲰ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤⲚⲎϪ ϨⲘ ⲠⲈϤⲎⲈⲒ ⲀϨⲀϨ ⲚⲦⲈⲖⲰⲚⲎⲤ ϨⲒⲢⲈϤⲢⲚⲞⲂⲈ ⲚⲞϪⲞⲨ ⲚⲘⲒⲎⲤⲞⲨⲤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲨⲞϢ ⲄⲀⲢ. ⲀⲨⲰ ⲀⲨⲀϨⲞⲨ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ϪⲈ ϤⲞⲨⲰⲘ ⲚⲘⲚⲢⲈϤⲢⲚⲞⲂⲈ ⲀⲨⲰ ⲚⲦⲈⲖⲰⲚⲎⲤ ⲠⲈϪⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲦⲂⲈⲞⲨ ϤⲞⲨⲰⲘ ⲀⲨⲰ ϤⲤⲰ ⲚⲘⲚⲢⲈϤⲢⲚⲞⲂⲈ ⲀⲨⲰ ⲚⲦⲈⲖⲰⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲚϬⲒ ⲚⲈⲦⲦⲎⲔ ⲘⲠⲤⲀⲒⲚ ⲀⲖⲖⲀ ⲚⲈⲦϢⲞⲞⲠ ⲔⲀⲔⲰⲤ ⲚⲦⲀⲈⲒ ⲀⲚ ⲈⲦⲈϨⲘⲚⲆⲒⲔⲀⲒⲞⲤ ⲀⲖⲖⲀ ⲢⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ⲀⲨⲰ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲘⲚⲀ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲈⲨⲚⲎⲤⲦⲈⲨⲈ. ⲀⲨⲈⲒ ⲆⲈ ⲚⲀϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈⲞⲨ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀⲨⲰ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲤⲈⲚⲎⲤⲦⲈⲨⲈ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲤⲈⲚⲎⲤⲦⲈⲨⲈ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲘⲎ ⲞⲨⲚϬⲞⲘ ⲈⲦⲢⲈⲨⲚⲎⲤⲦⲈⲨⲈ ⲚϬⲒ ⲚϢⲎⲢⲈ ⲘⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ ϨⲞⲤⲞⲚ ⲈⲢⲈⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲚⲘⲘⲀⲨ. ϨⲞⲤⲞⲚ ⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲚⲘⲘⲀⲨ ⲚⲤⲈⲚⲀϢⲚⲎⲤⲦⲈⲨⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ⲞⲨⲚϨⲈⲚϨⲞⲞⲨ ⲆⲈ ⲚⲎⲨ ϨⲞⲦⲀⲚ ⲈⲨϢⲀⲚϤⲒ ⲚⲦⲞⲞⲦⲞⲨ ⲘⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲎ ⲤⲦⲈⲨⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ⲘⲈⲢⲈⲖⲀⲀⲨ ⲚⲈϪⲦⲞⲈⲒⲤ ⲚϢⲀⲈⲒ ⲈⲢⲚϢⲦⲎⲚ ⲘⲠⲖϬⲈ ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ⲦⲦⲞⲈⲒⲤ ⲚϢⲀⲒ ⲚⲀϤⲒⲠⲔⲰⲦⲈ ⲘⲘⲀⲨ ⲚⲦⲈϢⲦⲎⲚ ⲘⲠⲖϬⲈ ⲚⲤⲠⲰϨ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ⲀⲨⲰ ⲘⲈⲢⲈⲖⲀⲀⲨ ⲚⲈϪⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲈϨⲰⲦ ⲚⲀⲤ ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ⲠⲎⲢⲠ ⲚⲀⲠⲈϨⲚϨⲰⲦ ⲚⲦⲈⲠⲎⲢⲠ ⲠⲰⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲚϨⲰⲦ ⲦⲀⲔⲞ. ⲀⲖⲖⲀ ⲈϢⲀⲨⲚⲈϪⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲈϨⲰⲦ ⲂⲂⲢⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ⲀⲨⲰ ⲀⲤϢⲰⲠⲈ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲢⲈϤⲘⲞⲞϢⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲰϨⲈ ⲈⲦⲢⲎⲦ ⲀⲨⲰ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨⲘⲞⲞϢⲈ ⲀⲨⲀⲢⲬⲒⲦⲖⲔ ϨⲘⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ⲚⲈⲪⲀⲢⲢⲒⲤⲀⲒⲞⲤ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ϪⲈ ⲈⲨⲢⲞⲨ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ ⲈⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲠⲈⲦⲚⲞϢϤ ⲖⲀⲀⲨ ϪⲈ ⲚⲦⲀⲆⲀⲨⲈⲒⲆ ⲢⲞⲨ ⲚⲦⲈⲢⲈϤϨⲔⲞ ⲚⲦⲞϤ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲚⲞⲨⲦⲈ ϨⲒⲀⲂⲒⲀⲐⲀⲢ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲚⲞⲒⲔ ⲚⲦⲈⲠⲢⲞⲐⲈⲤⲒⲤ ⲀϤⲞⲨⲞⲘⲞⲨ ⲈⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ ⲚⲀϤ ⲈⲞⲨⲞⲘⲞⲨ ⲚⲤⲀⲚⲞⲨⲎⲎⲂ ⲀⲨⲰ ⲀϤϮ ⲚⲚⲔⲞⲞⲨⲈ ⲈⲦⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ⲠⲈϪⲀϤ ⲞⲚ ⲚⲀⲨ ϪⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲦⲀϤϢⲰⲠⲈ ⲈⲦⲂⲈ ⲠⲢⲰⲘⲈ. ⲀⲨⲰ ⲚⲦⲀⲠⲢⲰⲘⲈ ϢⲰⲠⲈ ⲀⲚ ⲈⲦⲂⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ϨⲰⲤⲦⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ ⲘⲠⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲞⲚ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲘⲘⲀⲨ ⲈⲢⲈⲦⲈϤϬⲒϪ ⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ⲀⲨⲰ ⲚⲈⲨⲠⲀⲢⲀⲦⲎⲢⲒ ⲈⲢⲞϤ ϪⲈ ⲈⲚⲈϤⲚⲀⲐⲈⲢⲀⲠⲞⲨ ⲘⲘⲞϤ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈ ⲈⲨⲈⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲘⲠⲢⲰⲘⲈ ⲈⲢⲈⲦⲈϤϬⲒϪ ⲘⲞⲞⲨⲦ ϪⲈ ⲦⲰⲞⲨⲚⲄ ⲀⲘⲞⲨ ⲈⲦⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲜⲈⲤⲦⲒ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ ϪⲚⲢⲠⲈⲐⲞⲞⲨ ⲈⲦⲀⲚϨⲈⲞⲨⲮⲨⲬⲎ ϪⲚⲈⲘⲞⲞⲨⲦⲤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲀⲢⲰⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀⲨ ϨⲚ ⲞⲨⲞⲢⲄⲎ ⲈϤⲘⲞⲔϨ ⲚϨⲎⲦ ⲈϪⲘⲠⲦⲰⲘ ⲚϨⲎⲦ ⲘⲠⲈⲨϨⲎⲦ ⲠⲈϪⲀϤ ⲘⲠⲢⲰⲘⲈ ϪⲈ ⲤⲞⲨⲦⲚⲦⲈⲔϬⲒϪ ⲈⲂⲞⲖ ⲀϤⲤⲞⲨⲦⲰⲚⲤ ⲀⲨⲰ ⲀⲤⲖⲞ ⲚϬⲒ ⲦⲈϤϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲨⲚⲞⲨ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲘⲚϨⲎⲢⲰⲆⲒⲀⲚⲞⲤ ⲀⲨϪⲒϢⲞϪⲚⲈ ⲈⲢⲞϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲦⲀⲔⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲀϤⲀⲚⲀⲬⲰⲢⲒ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲂⲞⲖ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ⲞⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚⲘϮⲞⲨⲆⲀⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ⲚⲘⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲔⲈⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϨⲚ ϮⲆⲞⲨⲘⲀⲒⲀ ⲘⲚ ⲠⲈⲔⲢⲞ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲚⲘⲠⲔⲰⲦⲈ ⲚⲦⲨⲢⲞⲤ ⲚⲘⲤⲒⲆⲰⲚ ⲈⲨⲤⲰⲦⲘ ⲈⲚⲈⲦϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀⲨⲈⲒ ϢⲀⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ⲀⲨⲰ ⲀϤϪⲞⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲢⲈϨⲈⲚⲈϪⲎⲨ ⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲢⲞϤ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ ϪⲈ ⲚⲈⲨⲐⲖⲒⲂⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ⲚⲀϢⲈ ⲚⲈⲚⲦⲀϤⲦⲀⲖϬⲞⲞⲨ ⲄⲀⲢ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲨϮⲠⲈⲨⲞⲒ ⲈⲢⲞϤ ϪⲈ ⲈⲨⲈϪⲰϨ ⲈⲢⲞϤ. ⲀⲨⲰ ⲚⲈⲦⲈⲘⲘⲀⲤⲦⲒⲄⲜ ϨⲒⲰⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ⲘⲚ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈⲨϢⲀⲚⲚⲀⲨ ⲈⲢⲞϤ ϢⲀⲨⲠⲀϨⲦⲞⲨ ϨⲀⲢⲀⲦϤ ⲚⲤⲈϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ⲀⲨⲰ ⲚⲈϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ⲈⲘⲀⲦⲈ ϪⲈ ⲚⲚⲈⲨⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲠⲦⲞⲞⲨ ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈⲦϤⲞⲨⲀϢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ⲀϤⲚⲈϨⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲀⲒ ⲚⲦⲀϤϮ ⲠⲒⲚⲞⲨ ⲚⲈⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϪⲈ ⲈⲨⲈϢⲰⲠⲈ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲚϤϪⲞⲞⲨⲤⲈ ⲈⲂⲞⲖ ⲈⲦⲀϢⲈⲞⲒϢ ");
INSERT INTO copshc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ⲚϤϮ ⲚⲀⲨ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲚⲈϪ ⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ⲀⲨⲰ ⲀϤⲦⲀϨⲞ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀⲨⲰ ⲤⲒⲘⲰⲚ ⲀϤϮⲞⲨⲢⲀⲚ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ⲀⲨⲰ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲎⲤ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ. ⲀϤϮϨⲈⲚⲢⲀⲚ ⲈⲢⲞⲞⲨ ϪⲈ ⲂⲞⲀⲚⲎⲢⲄⲈⲤ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲚϢⲎⲢⲈ ⲘⲠⲈϨⲢⲞⲨⲂⲂⲀⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ⲀⲨⲰ ⲀⲚⲆⲢⲈⲀⲤ ⲚⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲘⲂⲀⲢⲐⲞⲖⲞⲘⲀⲒⲞⲤ. ⲘⲚⲘⲀⲐⲀⲒⲞⲤ. ⲚⲘⲐⲰⲘⲀⲤ ⲀⲨⲰ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲀⲖⲪⲀⲒⲞⲤ ⲘⲚⲐⲀⲆⲆⲀⲒⲞⲤ ⲀⲨⲰ ⲤⲒⲘⲰⲚ ⲠⲔⲀⲚⲀⲚⲀⲒⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ⲚⲘⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ⲀⲨⲰ ⲀϤⲈⲒ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲀⲠⲘⲎⲎϢⲈ ⲞⲚ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ ϨⲰⲤⲦⲈ ⲚⲤⲈⲦⲘⲤⲢϤⲈ ⲈⲞⲨⲈⲘⲠⲈⲨⲞⲈⲒⲔ ");
INSERT INTO copshc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲈϤⲢⲰⲘⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲚⲈⲨϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲀⲠⲈϤϨⲎⲦ ⲠⲰϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ⲀⲨⲰ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲦⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ ⲚⲘⲘⲀϤ ⲀⲨⲰ ϨⲘ ⲠⲀⲢⲬⲰⲚ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈϤⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲢⲞⲞⲨ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ϤⲚⲀⲚⲈϪⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ⲀⲨⲰ ⲈⲢϢⲀⲚⲞⲨⲘⲚⲦⲢⲢⲞ ⲠⲰⲢϪ ⲈⲚⲈⲤⲈⲢⲎⲨⲚⲤⲚⲀϢⲀϨⲈ ⲀⲚ ⲈⲢⲀⲦⲤ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ⲀⲨⲰ ⲈⲢϢⲀⲚⲞⲨⲎⲈⲒ ⲠⲰⲢϪ ⲈⲚⲈϤⲈⲢⲎⲨ ⲚⲚⲈϢⲠⲎⲈⲒ ⲈⲦⲘⲘⲀⲨ ⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ⲀⲨⲰ ⲈϢϪⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲀϤⲦⲰⲞⲨⲚ ⲚⲦⲞϤ ⲈϪⲰϤ ⲀⲨⲰ ⲀϤⲠⲰⲢϪ ⲚⲚⲈϤⲈϢⲀϨⲈⲢⲀⲦϤ. ⲀⲖⲖⲀ ⲀⲦⲈϤϨⲀⲎ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ⲀⲖⲖⲀ ⲘⲚⲖⲀⲀⲨ ⲚⲀϢⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲘⲠϪⲰⲰⲢⲈ ⲚϤⲦⲰⲢⲠ ⲚⲚⲈϤϨⲚⲀⲞⲨ ⲈϤⲦⲘⲘⲞⲨⲢ ⲚϢⲞⲢⲠ ⲘⲠϪⲰⲰⲢ. ⲀⲨⲰ ⲦⲞⲦⲈ ⲚϤⲦⲰⲢⲠ ⲘⲠⲈϤⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲞⲂⲈ ⲚⲒⲘ ϨⲒⲞⲨⲀ ⲚⲒⲘ ⲈⲦⲞⲨⲚⲀϪⲞⲞⲨ ⲚϬⲒ ⲚϢⲎⲢⲈ ⲚⲢⲢⲰⲘⲈ ⲤⲈⲚⲀⲔⲀⲀⲨ ⲚⲀⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ⲠⲈⲦⲚⲀϪⲒⲞⲨⲀ ⲆⲈ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲘⲘⲚⲦϤⲔⲰ ⲈⲂⲞⲖ ϢⲀ ⲈⲚⲈϨ ⲀⲖⲖⲀ ϤϬⲎⲠ ⲈⲨⲚⲞⲂⲈ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ⲈⲂⲞⲖ ϪⲈ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ⲀⲨⲰ ⲀⲨⲈⲒ ⲚϬⲒ ⲦⲈϤⲘⲀⲀⲨ ⲘⲚ ⲚⲈϤⲤⲚⲎⲨⲀⲨⲀϨⲈⲢⲀⲦⲞⲨ ϨⲒⲂⲞⲖ ⲀⲨⲰ ⲀⲨϪⲞⲞⲨ ⲚⲀϤ ⲈϨⲞⲨⲚ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ⲀⲨⲰ ⲚⲈϤϨⲘⲞⲞⲤ ϨⲘ ⲠⲈϤⲔⲰⲦⲈ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲈⲒⲤⲦⲈⲔⲘⲀⲀⲨ ⲘⲚ ⲚⲈⲔⲤⲚⲎⲨ ⲤⲈⲔⲰⲦⲈ ⲚⲤⲰⲔ ϨⲒⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲚⲒⲘ ⲦⲈ ⲦⲀⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲒⲘ ⲚⲈ ⲚⲀⲤⲚⲎⲨ ");
INSERT INTO copshc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ⲀϤϬⲰϢⲦ ⲈⲚⲈⲦⲘⲠⲈϤⲔⲰⲦⲈ ⲈⲦϨⲘⲞⲞⲤ ϨⲀϨⲦⲎϤ. ⲠⲈϪⲀϤ ϪⲈ ⲈⲒⲤⲦⲀⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲀⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ⲠⲈⲦⲚⲀⲈⲒⲢⲈ ⲄⲀⲢ ⲘⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ. ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲞⲚ ⲀⲨⲰ ⲦⲀⲤⲰⲚⲈ ⲀⲨⲰ ⲦⲀⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ⲀϤⲀⲢⲬⲈⲤⲐⲀⲒ ⲞⲚ ⲈϮⲤⲂⲰ ϨⲀⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ⲀⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈϤⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲚϤϨⲘⲞⲞⲤ ϨⲚ ⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ϨⲒⲠⲈⲔⲢⲞ ⲚⲐⲀⲖⲀⲤⲤⲀ ");
INSERT INTO copshc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ⲀϤϮⲤⲂⲰ ⲆⲈ ⲚⲀⲨ ⲈⲘⲀⲦⲈ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϨⲚ ⲦⲈϤⲤⲂⲰ ");
INSERT INTO copshc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ϪⲈ ⲤⲰⲦⲘ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦϪⲞ ⲈⲦϪⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲞ ⲞⲨⲀ ⲘⲈⲚ ⲀϤϨⲈ ϨⲀⲦⲈⲦⲈϨⲒⲎ ⲀⲨⲰ ⲀⲨⲈⲒ ⲚϬⲒ ⲚϨⲀⲖⲀⲦⲈ ⲀⲨⲞⲘⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ⲔⲈⲨⲀ ⲆⲈ ⲀϤϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲠⲈⲦⲢⲀ ⲠⲘⲀ ⲈⲦⲈⲘⲘⲚϨⲀϨ ⲚⲔⲀϨ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨϮⲞⲨⲰ ⲈϨⲢⲀⲈⲒ ⲈⲦⲂⲈ ϪⲈⲘⲚϨⲀϨ ⲚⲔⲀϨ ϨⲀⲢⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲠⲢⲎ ϢⲀ ⲀⲨϨⲰϬⲂ ⲀⲨⲰ ⲈⲦⲂⲈ ϪⲈⲘⲠⲞⲨϪⲈⲚⲞⲨⲚⲈ ⲈⲂⲞⲖ ⲀⲨϢⲞⲞⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ⲔⲈⲨⲀ ⲀϤϨⲈ ⲈϨⲢⲀⲈⲒ ⲈϪⲚ ⲚϢⲞⲚⲦⲈ ⲀⲨⲰ ⲀⲨⲈⲒ ⲈϨⲢⲀⲈⲒ ⲚϬⲒ ⲚϢⲞⲚⲦⲈ ⲀⲨⲞϬⲦⲞⲨ ⲀⲨⲰ ⲘⲠⲞⲨϮⲔⲀⲢⲠⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ϨⲈⲚⲔⲞⲞⲨⲈ ⲀⲨϨⲈ ⲈϪⲘⲠⲔⲀϨ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲀⲨⲀⲨⲜⲀⲚⲈ ⲀⲨϮⲔⲀⲢⲠⲞⲤ ⲈⲘⲀⲀⲂ ⲀⲨⲰ ⲈⲤⲈ ⲀⲨⲰ ⲈϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲈⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ⲚⲦⲈⲢⲈϤⲔⲀ ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲀⲨϪⲚⲞⲨϤ ⲚϬⲒ ⲚⲈⲦⲚⲘⲘⲀϤ ⲚⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲀⲨϮ ⲚⲎⲦⲚ ⲘⲠⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲎ ⲆⲈ ⲈⲦϨⲒⲂⲞⲖ ⲈⲨⲚⲀϪⲒϨⲰⲂ ⲚⲒⲘ ⲈⲢⲞⲞⲨ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ϪⲈⲔⲀⲀⲤ ⲈⲨⲚⲀⲨ ⲈⲨⲈⲚⲀⲨ ⲀⲨⲰ ⲚⲤⲈⲦⲘⲚⲀⲨ ⲀⲨⲰ ⲈⲨⲤⲰⲦⲘ ⲈⲨⲈⲤⲰⲦⲘ ⲚⲤⲈⲦⲘⲚⲞⲈⲒ. ⲘⲎⲠⲰⲤ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲚⲤⲈⲔⲰ ⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ. ⲀⲨⲰ ⲠⲰⲤ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲦⲎⲢⲞⲨ ⲦⲈⲦⲚⲀⲤⲞⲨⲰⲚⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ⲠⲈⲦϪⲞ ⲈϤϪⲞ ⲘⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ⲚⲀⲒ ⲆⲈ ⲚⲈ ⲈⲦϨⲀⲦⲈⲦⲈϨⲒⲎ ⲘⲠⲘⲀ ⲈϢⲀⲨϪⲈⲠϢⲀϪⲈ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲈϢⲀⲨⲤⲰⲦⲘ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀϤⲈⲒ ⲚϬⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲚϤϤⲒⲠϢⲀϪⲈ ⲈⲚⲦⲀⲨϪⲞϤ ⲚϨⲎⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ⲀⲨⲰ ⲚⲀⲒ ϨⲰⲞⲨ ⲚⲈⲚⲦⲀⲨϪⲞⲞⲨ ϨⲒϪⲚ ⲘⲘⲀ ⲘⲠⲈⲦⲢⲀ ⲈϢⲀⲨⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀⲨϪⲒⲦϤ ϨⲚ ⲞⲨⲢⲀϢⲈ ");
INSERT INTO copshc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ⲘⲘⲚⲚⲞⲨⲚⲈ ⲆⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲀⲖⲖⲀ ϨⲚ ⲠⲢⲞⲤⲞⲨⲞⲈⲒϢ ⲚⲈ ⲈⲢϢⲀⲚⲞⲨⲐⲖⲒⲮⲒⲤ ⲆⲈ ϢⲰⲠⲈ ⲎⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈⲦⲂⲈ ⲠϢⲀϪⲈ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀⲨⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ⲀⲨⲰ ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈⲚⲦⲀⲨϪⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈⲚϢⲞⲚⲦⲈ ⲈⲦⲈⲚⲀⲒ ⲚⲈ ⲚⲦⲀⲨⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ⲀⲨⲰ ⲠⲢⲞⲞⲨϢ ⲘⲠⲀⲒⲰⲚ ⲚⲘⲦⲀⲠⲀⲦⲎ ⲚⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲀⲨⲰ ⲚⲔⲈⲈⲠⲒⲐⲨⲘⲒⲀ ⲈⲦⲂⲎⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ ⲤⲈⲰϬⲦ ⲘⲠϢⲀϪⲈ ⲀⲨⲰ ⲚϤϮⲔⲀⲢⲠⲞⲤ ⲀⲚ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ⲀⲨⲰ ⲚⲎ ⲚⲈ ⲚⲦⲀⲨϪⲞⲞⲨ ⲈϪⲘⲠⲔⲀϨ ⲈⲦⲚⲀⲚⲞⲨϤ ⲈⲨⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲤⲈϢⲰⲠ ⲘⲘⲞϤ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲤⲈⲦⲀⲨⲈⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲘⲀⲀⲂ ⲀⲨⲰ ϨⲚ ⲤⲈ ⲀⲨⲰ ϨⲚ ϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲘⲎ ⲈⲢⲈⲠϨⲎⲂⲤ ⲚⲀⲈⲒ ϪⲈ ⲈⲨⲈⲔⲀⲀϤ ϨⲀⲞⲨϢⲒ. ⲎϨⲀⲞⲨϬⲖⲞϬ ⲘⲎ ⲚⲈⲨⲚⲀⲔⲀⲀϤ ⲀⲚ ϨⲒϪⲚ ⲦⲖⲨⲬⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ⲘⲘⲚⲠⲈⲦϨⲞⲂⲤ ⲄⲀⲢ ⲈⲚⲤⲈⲚⲀϬⲞⲖⲠϤ ⲀⲚ ⲈⲂⲞⲖ. ⲞⲨⲆⲈ ⲘⲘⲚⲠⲈⲦϨⲎⲠ ⲈⲚϤⲚⲀⲞⲨⲰⲚϨ ⲀⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ⲠⲈⲦⲈⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ ");
INSERT INTO copshc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮϨⲦⲎⲦⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞϤ. ϨⲘ ⲠϢⲒ ⲈⲦⲈⲦⲚⲀϢⲒ ⲘⲘⲞϤ ⲤⲈⲚⲀϢⲒ ⲚⲎⲦⲚ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ⲠⲈⲦⲈⲨⲚⲦⲀϤ ⲄⲀⲢ ⲤⲈⲚⲀϮ ⲚⲀϤ. ⲀⲨⲰ ⲠⲈⲦⲈⲘⲚⲦⲀϤ ⲀⲨⲰ ⲠⲈⲦⲈⲨⲚⲦⲀϤⲤϤ ⲤⲈⲚⲀϤⲒⲦϤ ⲚⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲤⲞ ⲚⲐⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲈϤϢⲀⲚⲚⲞⲨϪⲈ ⲘⲠⲈϤϬⲢⲞϬ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ⲀⲨⲰ ⲚϤⲚⲔⲞⲦⲔ ⲚϤⲦⲰⲞⲨⲚ ⲚⲦⲈⲨϢⲎ ⲘⲚ ⲠⲈϨⲞⲞⲨ ϢⲀⲢⲈⲠⲈϬⲢⲞϬ ϮⲞⲨⲰ ⲚϤⲢⲚⲞϬ ⲈⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ⲚⲦⲞϤ ⲚⲐⲈ ⲠⲔⲀϨ ϢⲀϤϮⲞⲨⲰ ⲈϨⲢⲀⲈⲒ ⲘⲀⲨⲀⲀϤ ϢⲞⲢⲠ ⲘⲈⲚ ⲚⲞⲨⲬⲞⲢⲦⲞⲤ ⲘⲚⲚⲤⲰϤ ⲞⲨϨⲘⲤ ⲀⲨⲰ ⲞⲨⲤⲞⲨⲞ ⲈϤⲘⲈϨ ϨⲘ ⲠϨⲘⲤ ");
INSERT INTO copshc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ⲈⲢϢⲀⲚⲠⲔⲀⲢⲠⲞⲤ ⲆⲈ ⲠⲰϨ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀϤⲚⲠⲞϨⲤ ϪⲈ ⲀⲠⲦⲈ ⲘⲠⲰϨⲤ ϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲚⲀⲦⲚⲦⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲞⲨ. ⲎⲈⲚⲚⲀⲔⲀⲀⲤ ⲈϨⲢⲀⲒ ϨⲚ ⲀϢ ⲘⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ⲈⲚⲚⲀⲔⲀⲀⲤ ⲚⲐⲈ ⲚⲞⲨⲂⲖⲂⲒⲖⲈ ⲚϢⲖⲦⲘ ⲈⲨϢⲀⲚϪⲞⲤ ⲈϨⲢⲀⲒ ⲈⲠⲔⲀϨ ⲈⲤⲤⲞⲂⲔ ⲘⲈⲚ ⲈⲚⲈϬⲢⲰϬ ⲦⲎⲢⲞⲨ ⲈⲦϨⲒϪⲘⲠⲔⲀϨ ");
INSERT INTO copshc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ⲀⲨⲰ ⲈⲨϢⲀⲚϪⲞⲤ ϢⲀⲤⲈⲒ ⲈϨⲢⲀⲒ ⲚⲤϪⲒⲤⲈ ⲈⲚⲞⲨⲞⲞⲦⲈ ⲦⲎⲢⲞⲨ ⲚⲤⲦⲀⲨⲞ ⲈⲂⲞⲖ ⲚϨⲈⲚⲚⲞϬ ⲚⲔⲖⲀⲆⲞⲤ ϨⲰⲤⲦⲈ ⲚⲤⲈϢⲞⲨⲰϨ ϨⲀⲦⲈⲤϨⲀⲈⲒⲂⲈⲤ ⲚϬⲒ ⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ⲀⲨⲰ ϨⲚ ⲚⲀⲒⲤⲘⲞⲦ ⲘⲠⲀⲢⲀⲂⲞⲖⲎ ⲦⲎⲢⲞⲨ ⲚⲈϤϪⲰ ⲈⲢⲞⲞⲨ ⲘⲠϢⲀϪⲈ ⲔⲀⲦⲀⲐⲈ ⲈⲦⲞⲨⲚⲀϢⲤⲰⲦⲘ ");
INSERT INTO copshc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ⲀϪⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲆⲈ ⲘⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲚⲤⲀⲨⲤⲀ ⲆⲈ ϢⲀϤⲂⲞⲖⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲢⲈⲢⲞⲨϨⲈ ϢⲰⲠⲈ ϪⲈ ⲘⲀⲢⲞⲚ ⲈⲠⲒⲔⲢⲞ ");
INSERT INTO copshc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ⲀⲨⲔⲀⲠⲘⲎⲎϢⲈ ϬⲈ ⲀⲨⲦⲀⲖⲞϤ ⲈⲠϪⲞⲈⲒ ⲚⲐⲈ ⲈⲦϤⲚϨⲎⲦⲤ ⲀϨⲈⲚⲔⲈⲈϪⲎⲨ ⲤϬⲎⲢ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ⲀⲨⲰ ⲀⲨⲚⲞϬ ⲚϨⲀⲦⲎⲨ ϢⲰⲠⲈ ⲀⲚϨⲞⲈⲒⲘ ϤⲰϬⲈ ⲈⲠϪⲞⲈⲒ ϨⲰⲤⲦⲈ ⲈⲞⲘⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤϨⲒⲠⲀϨⲞⲨ ⲘⲠϪⲞⲈⲒ ⲈϤⲚⲔⲞⲦⲔ ϨⲒϪⲚ ⲞⲨϢⲞⲦ ⲀⲨⲰ ⲀⲨⲚⲈϨⲤⲈ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲠⲤⲀϨ ⲚⲄⲞ ⲀⲚ ⲠⲈ ⲢⲢⲞⲞⲨϢ ϪⲈ ⲦⲚⲚⲀⲘⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ⲀϤⲦⲰⲞⲨⲚϤ ⲆⲈ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲦⲎⲨ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲦⲈⲐⲀⲖⲀⲤⲤⲀ ϪⲈ ⲔⲀⲢⲰ ⲚⲦⲈϢⲦⲘⲢⲰ ⲀⲨⲰ ⲀⲠⲦⲎⲨ ϨⲢⲎϬ ⲀⲨⲚⲞϬ ⲚϪⲀⲘⲎ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲞ ⲚϬⲀⲂϨⲎⲦ ⲘⲠⲀⲦⲈⲦⲚⲔⲀⲠⲒⲤⲦⲒⲤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚϨⲞⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲞⲨⲀϢ ⲘⲘⲒⲚⲈ ⲠⲈ ⲠⲀⲒ ϪⲈ ⲠⲔⲈⲦⲎⲨ ⲚⲘⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲤⲰⲦⲘ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ⲀⲨⲰ ⲀⲨⲘⲞⲞϢⲈ ⲈⲠⲈⲔⲢⲞ ⲚⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲈⲦⲈⲬⲰⲢⲀ ⲚⲚⲄⲈⲢⲀⲤⲎⲚⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲪⲰϬⲈ ⲈⲠⲈⲔⲢⲞ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨⲢⲰⲘⲈ ⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲘϨⲀⲞⲨ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ⲈϤϢⲞⲞⲠ ϨⲚ ⲚⲈⲘϨⲀⲞⲨ ⲈⲘⲠⲈϢⲖⲀⲀⲨ ϬⲈ ϬⲘϬⲞⲘ ⲈⲘⲞⲢϤ ϨⲚ ϨⲀⲖⲨⲤⲒⲤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ϪⲈ ⲀⲨⲘⲞⲢϤ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲚϨⲈⲚⲠⲀⲒⲆⲈⲤ ⲚⲘϨⲈⲚϨⲀⲖⲨⲤⲒⲤ ⲀⲨⲰ ϢⲀϤⲤⲖⲠⲚϨⲀⲖⲨⲤⲒⲤ ⲚϤⲞⲨⲈϬⲠⲘⲠⲀⲒⲆⲈⲤ ⲈⲘⲠⲈϢⲖⲀⲀⲨ ϬⲘϬⲞⲘ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ⲀⲨⲰ ⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲚⲦⲈⲨϢⲎ ⲘⲚ ⲠⲈϨⲞⲞⲨ ⲚⲈϤϨⲚⲚⲈⲘϨⲀⲞⲨ ⲀⲨⲰ ϨⲚ ⲚⲦⲞⲨⲒⲎ ⲈϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ ϨⲚ ⲚⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ϨⲘ ⲠⲞⲨⲈ ⲀϤⲠⲰⲦ ⲀϤⲠⲀϨⲦϤ ϨⲀⲢⲀⲦϤ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ ");
INSERT INTO copshc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ⲀϤⲰϢ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚϨⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϨⲢⲞⲔ ⲚⲘⲘⲀⲒ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦϪⲞⲤⲈ ϮⲰⲢⲔ ⲈⲢⲞⲔ ⲘⲠⲚⲞⲨⲦⲈ. ϪⲈ ⲚⲚⲈⲔⲂⲀⲤⲀⲚⲒⲌⲈ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ⲚⲈⲢⲈⲒⲎⲤⲞⲨⲤ ⲄⲀⲢ ϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲘⲠⲢⲰⲘⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ⲀⲨⲰ ⲚⲈϤϪⲚⲞⲨ ⲘⲘⲞϤ ϪⲈ ⲚⲒⲘ ⲈⲢⲚⲦⲔ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲖⲈⲄⲒⲰⲚ ⲠⲈ ⲠⲢⲀⲚ ϪⲈ ⲦⲚϪⲔϨⲀϨ ");
INSERT INTO copshc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈⲘⲀⲦⲈ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈϤⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ⲚⲦⲈⲬⲰⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ⲚⲈⲤⲘⲠⲘⲀ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ϨⲀⲢⲀⲦϤ ⲘⲠⲦⲞⲞⲨ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲚⲀⲄⲈⲖⲎ ⲢⲢⲒⲢ ⲈⲨⲘⲞⲞⲚⲈ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϪⲞⲞⲨⲚ ⲈϨⲞⲨⲚ ⲈⲚⲈϢⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ ⲈⲦⲢⲈⲨⲂⲰⲔ ⲚⲦⲈⲢⲈ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲚⲈϢⲀⲨ ⲀⲨⲰ ⲀⲤⲢⲰϨⲦ ⲚϬⲒ ⲦⲀⲄⲈⲖⲎ ⲢⲢⲒⲢ ϨⲒϪⲚ ⲦϢⲰⲘⲈ ⲈⲠⲈⲬⲎⲦ ⲈⲨⲚⲀⲢϪⲞⲨⲰⲦ ⲚϢⲈ ⲀⲨⲘⲞⲨ ϨⲚ ⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ⲚⲈⲦⲘⲞⲞⲚⲈ ⲆⲈ ⲘⲘⲞⲞⲨ ⲀⲨⲠⲰⲦ ⲀⲨϪⲒⲠⲞⲨⲰ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ ⲘⲚⲚⲤⲰϢⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ⲀⲨⲈⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲚⲀⲨ ⲈⲠⲈⲦⲞ ⲚⲢⲈϤϢⲞⲞⲢ ⲈϤϨⲘⲞⲞⲤ ⲈϨⲢⲀⲈⲒ ⲈⲢⲈⲚⲈϤϨⲞⲈⲒⲦⲈ ϨⲒⲰⲰϤ ⲀⲨⲰ ⲈⲢⲈⲠⲈϤϨⲎⲦ ⲤⲘⲞⲚⲦ. ⲠⲈⲚⲦⲀⲖⲈⲄⲈⲰⲚ ϢⲰⲠⲈ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ⲚⲈⲚⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲀⲨⲦⲀⲞⲨⲞ ⲈⲢⲞⲞⲨ ⲚⲐⲈ ⲚⲦⲀⲤϢⲰⲠⲈ ⲘⲠⲈⲦⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲀⲨⲰ ⲈⲦⲂⲈ ⲚⲈϢⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ⲈⲦⲢⲈϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲦⲞϢ ");
INSERT INTO copshc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ⲀⲨⲰ ⲈϤⲚⲀⲦⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲀϤⲤⲈⲠⲤⲰⲠϤ ⲚϬⲒ ⲠⲈⲦⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲦⲢⲈϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ⲀⲨⲰ ⲘⲠϤⲔⲀⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲂⲰⲔ ⲈϨⲢⲀⲈⲒ ⲈⲠⲈⲔⲎⲈⲒ ϢⲀⲚⲈⲔⲢⲰⲘⲈ ⲚⲄⲦⲀⲞⲨⲞ ⲈⲢⲞⲞⲨ ⲚⲚⲈⲚⲦⲀⲠϪⲞⲈⲒⲤ ⲀⲀⲨ ⲚⲀⲔ ");
INSERT INTO copshc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ⲈⲀϤⲚⲀ ⲚⲀⲔ ⲀϤⲂⲰⲔ ⲆⲈ ⲀϤⲀⲢⲬⲈⲤⲐⲀⲒ ⲚⲦⲀϢⲈⲞⲈⲒϢ ϨⲚ ⲦⲆⲈⲔⲀⲠⲞⲖⲒⲤ ⲚⲚⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲀⲨ ⲚⲀϤ. ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ⲚⲦⲈⲢⲈϤϪⲒⲞⲞⲢ ⲈⲂⲞⲖ ϨⲘ ⲠϪⲞⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲒ ⲈⲠⲈⲔⲢⲞ. ⲀⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ. ⲚⲈϤϨⲀⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲆⲈ ");
INSERT INTO copshc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ⲀⲨⲰ ⲀϤⲈⲒ ⲚϬⲒ ⲞⲨⲀ ⲚⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲀⲈⲒⲢⲞⲤ. ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲀϤⲠⲀϨⲦϤ ϨⲀⲢⲀⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ⲀⲨⲰ ⲀϤⲤⲈⲠⲤⲰⲠϤ ⲈⲘⲀⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀϢⲈⲈⲢⲈ ⲘⲞⲔϨ ⲚϢⲰⲚⲈ ϪⲈⲔⲀⲀⲤ ϬⲈ ⲈⲔⲈⲈⲒ ⲚⲄⲔⲀⲦⲞⲞⲦⲔ ϨⲒϪⲰⲤ ϪⲈ ⲈⲤⲈⲖⲞ ⲚⲤⲰⲚϨ ");
INSERT INTO copshc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ⲀϤⲂⲰⲔ ⲆⲈ ⲚⲘⲘⲀϤ. ⲀⲨⲰ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲚⲈⲨⲐⲖⲒⲂⲈ ⲆⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ⲀⲨⲰ ⲞⲨⲤϨⲒⲘⲈ ⲈⲢⲈⲠⲈⲤⲚⲞϤ ϢⲞⲨⲞ ⲘⲘⲞⲤ ⲈⲒⲤⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲢⲢⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ⲀⲨⲰ ⲀⲤϢⲈⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲚⲦⲞⲞⲦⲞⲨ ⲚϨⲀϨ ⲚⲤⲀⲈⲒⲚ ⲀⲨⲰ ⲀⲤϪⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲨⲚⲦⲀⲤⲤⲈ ⲦⲎⲢⲞⲨ ⲈⲘⲠⲤⲘⲦⲞⲚ ⲖⲀⲀⲨ. ⲀⲖⲖⲀ ⲚⲦⲀⲤⲈⲒ ⲚⲐⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ⲚⲦⲈⲢⲈⲤⲤⲰⲦⲘ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲤⲞϢⲤ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲀⲤⲈⲒ ⲈⲠⲀϨⲞⲨ ⲘⲘⲞϤ ⲀⲤϪⲰϨ ⲈⲦⲈϤϢⲦⲎⲚ ");
INSERT INTO copshc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ⲀⲤϪⲞⲞⲤ ⲄⲀⲢ ϪⲈ ⲈⲒϢⲀⲚϪⲰϨ ⲈⲚⲈϤϨⲞⲒⲦⲈ ϮⲚⲀⲖⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲤϬⲰ ⲚϬⲒ ⲦⲠⲎⲄⲎ ⲘⲠⲈⲤⲤⲚⲞϤ. ⲀⲨⲰ ⲀⲤⲈⲒⲘⲈ ϨⲘ ⲠⲈⲤⲤⲰⲘⲀ ϪⲈ ⲀⲤⲖⲞ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲀⲤⲦⲒⲄⲜ ⲈⲦⲚⲘⲘⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲚⲦⲈⲨⲚⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲈⲦϬⲞⲘ ⲈⲚⲦⲀⲤⲈⲒ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲀϤⲔⲦⲞϤ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤϪⲰϨ ⲈⲚⲀϨⲞⲒⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ⲠⲈϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ⲔⲚⲀⲨ ⲈⲠⲘⲎⲎϢⲈ ⲈⲦⲐⲖⲒⲂⲈ ⲘⲘⲞⲔ ⲈⲦⲂⲈ ⲠⲀⲒ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤϪⲰϨ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ⲀϤⲔⲦⲈⲒⲀⲦϤ ⲆⲈ ⲈⲚⲀⲨ ⲈⲦⲈⲚⲦⲀⲤⲢⲠⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ⲦⲈⲤϨⲒⲘⲈ ⲆⲈ ⲀⲤⲢϨⲞⲦⲈ ⲀⲨⲰ ⲀⲤⲤⲦⲰⲦ ⲈⲤⲤⲞⲞⲨⲚ ⲘⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲘⲘⲞⲤ ⲀⲤⲈⲒ ⲀⲤⲠⲀϨⲦⲤ ϨⲀⲢⲀⲦϤ ⲀⲤⲦⲀⲞⲨⲞ ⲈⲢⲞϤ ⲚⲦⲘⲈ ⲦⲎⲢⲤ ");
INSERT INTO copshc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀϢⲈⲈⲢⲈ ⲦⲞⲨⲠⲒⲤⲦⲒⲤ ⲦⲈ ⲚⲦⲀⲤⲚⲀϨⲘⲈ ⲂⲰⲔ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ⲚⲦⲈⲖⲞ ⲈⲂⲞⲖ ϨⲚ ⲦⲞⲨⲘⲀⲤⲦⲒⲄⲜ. ");
INSERT INTO copshc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ⲈⲦⲒ ⲚⲦⲞϤ ⲈϤϢⲀϪⲈ. ⲀⲨⲈⲒ ⲚϬⲒ ⲚⲢⲰⲘⲈ ⲘⲠⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲦⲈⲔϢⲈⲈⲢⲈ ⲀⲤⲘⲞⲨ ⲈⲔⲚⲀϮϨⲞⲒ ϬⲈ ⲘⲠⲤⲀϨ ⲈⲦⲂⲈ ⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲈϤϪⲰ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲘⲠⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲠⲒⲤⲦⲈⲨⲈ ⲘⲘⲀⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ⲀⲨⲰ ⲘⲠϤⲔⲀⲖⲀⲀⲨ ⲈⲞⲨⲀϨϤ ⲚⲤⲰϤ. ⲚⲤⲀⲠⲈⲦⲢⲞⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ⲀⲨⲰ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲎⲈⲒ ⲘⲠⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀϤⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲈⲨϢⲦⲢⲦⲰⲢ ⲀⲨⲰ ⲈⲨⲢⲒⲘⲈ ⲈⲨⲞⲨⲚⲢⲞ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϢⲦⲢⲦⲰⲢ. ⲀⲨⲰ ⲦⲈⲦⲚⲢⲒⲘⲈ ⲈⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲘⲠⲤⲘⲞⲨ ⲀⲖⲖⲀ ⲈⲤⲚⲔⲞⲦⲔ ");
INSERT INTO copshc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ⲀⲨⲤⲰⲂⲈ ⲚⲤⲰϤ ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲀϤϪⲒⲠⲒⲰⲦ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲘⲚ ⲦⲈⲤⲘⲀⲀⲨ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲘⲀ ⲈⲦⲈⲢⲈⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀⲘⲀϨⲦⲈ ⲚⲦϬⲒϪ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀⲖⲈⲒⲐⲀ ⲔⲞⲨⲘ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲈⲈⲒϪⲈⲢⲞ ⲦⲰⲞⲨⲚⲈ ");
INSERT INTO copshc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲤⲦⲰⲞⲨⲚⲤ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲀⲤⲘⲞⲞϢⲈ ⲚⲈⲤϨⲘ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲄⲀⲢ ⲢⲢⲞⲘⲠⲈ ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲚⲞⲨⲚⲞϬ ⲚϢⲠⲎⲢⲈ ");
INSERT INTO copshc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ⲀϤϨⲰⲚ ⲆⲈ ⲈⲦⲞⲞⲦⲞⲨ ⲈⲘⲀⲦⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲖⲀⲀⲨ ⲈⲒⲘⲈ ⲈⲠⲀⲒ ⲀⲨⲰ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲨⲦⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈϤⲠⲞⲖⲒⲤ. ⲀⲨⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ⲚⲦⲈⲢⲈⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲆⲈ ϢⲰⲠⲈ ⲀϤⲀⲢⲬⲈⲤⲐⲀⲒ ⲚϮⲤⲂⲰ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲈⲨⲤⲰⲦⲘ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲀⲠⲀⲒ ϬⲚⲚⲀⲒ ⲦⲰⲚ. ⲀⲨⲰ ⲞⲨⲦⲈ ⲦⲀⲒⲤⲞⲪⲒⲀ ⲚⲦⲀⲨⲦⲀⲀⲤ ⲘⲠⲀⲒ. ⲀⲨⲰ ⲚⲈⲒϬⲞⲘ ⲚⲦⲈⲒϬⲞⲦ ⲈⲦⲈⲢⲈ ⲠⲀⲒ ⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ⲘⲠⲀⲒ ⲀⲘ ⲠⲈ ⲠϨⲀⲘϢⲈ ⲠϢⲎⲢⲈ ⲘⲘⲀⲢⲒⲀ. ⲀⲨⲰ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰⲤⲎ ⲚⲘⲒⲞⲨⲆⲀ ⲚⲘⲤⲒⲘⲰⲚ. ⲀⲨⲰ ⲚⲈϤⲤⲰⲚⲈ ⲚⲈⲨⲚⲠⲈⲈⲒⲘⲀ ⲀⲚ ϨⲀϨⲦⲎⲚ ⲀⲨⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲨ. ϪⲈ ⲘⲘⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲤⲎϢ ⲈⲒ ⲘⲎⲦⲒ ϨⲚ ⲦⲈϤⲠⲞⲖⲒⲤ ⲀⲨⲰ ϨⲚ ⲚⲈϤⲤⲨⲄⲄⲈⲚⲎⲤ ⲘⲚ ⲠⲈϤⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ⲘⲠϤⲢⲖⲀⲀⲨ ⲆⲈ ⲚϬⲞⲘ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲤⲀϨⲞⲈⲒⲚⲈ ⲈⲨϢⲰⲚⲈ ⲀϤⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲰⲞⲨ ⲀϤⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ⲀⲨⲰ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ⲈⲦⲂⲈ ⲦⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ⲚⲈϤⲔⲰⲦⲈ ⲆⲈ ⲠⲈ ⲈⲚⲈⲦⲘⲈ ⲈϤϮⲤⲂⲰ ");
INSERT INTO copshc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲈⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤⲀⲢⲬⲈⲤⲐⲀⲒ ⲚϪⲞⲞⲨⲤⲈ ⲤⲚⲀⲨ ⲤⲚⲀⲨ ⲀⲨⲰ ⲀϤϮ ⲚⲀⲨ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲈϨⲞⲨⲚ ⲈⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ⲀϤϨⲰⲚ ⲆⲈ ⲈⲦⲞⲞⲦⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨϤⲒⲖⲀⲀⲨ ⲚⲘⲘⲀⲨ ⲈⲦⲈϨⲒⲎ ⲚⲤⲀⲞⲨϬⲈⲢⲰⲂ ⲘⲘⲀⲦⲈ ⲞⲨⲆⲈ ⲞⲈⲒⲔ ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲞⲨⲆⲈ ϨⲞⲘⲚⲦ ⲈⲚⲈⲨⲘⲞϪϨ ");
INSERT INTO copshc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ⲀⲖⲖⲀ ⲈⲢⲈⲚⲈⲨⲤⲀⲚⲆⲀⲖⲒⲞⲚ ⲞⲦϨ ⲈⲢⲀⲦⲞⲨ. ⲞⲨⲆⲈ ⲚⲤⲈⲦⲘϮϢⲦⲎⲚ ⲤⲚⲦⲈ ϨⲒⲰⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲠⲎⲈⲒ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ϬⲰ ⲚϨⲎⲦϤ ϢⲀⲚⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ⲀⲨⲰ ⲠⲘⲀ ⲈⲦⲈⲚϤⲚⲀϢⲈⲠⲦⲎⲨⲦⲚ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲦⲘⲤⲰⲦⲘ ⲈⲢⲰⲦⲚ ⲈⲦⲈⲦⲚⲚⲀⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲞⲨϨⲈ ⲈⲂⲞⲖ ⲘⲠϢⲞⲈⲒϢ ⲈⲦϨⲀⲢⲞⲞⲨ ⲚⲚⲈⲦⲞⲨⲈⲢⲎⲦⲈ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲘⲞⲞϢⲈ ⲀⲨⲔⲎⲢⲨⲤⲤⲈ ϪⲈ ⲈⲨⲈⲘⲈⲦⲀⲚⲞⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ⲀⲨⲰ ϨⲀϨ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲀⲨⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ϨⲈⲚⲔⲈⲘⲎⲎϢⲈ ⲈⲨϢⲰⲚⲈ ⲀⲨⲦⲀϨⲤⲞⲨ ⲚⲚⲈϨ ⲀⲨⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ⲀⲨⲰ ⲀϤⲤⲰⲦⲘ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲠⲢⲢⲞ ⲀⲠⲈϤⲢⲀⲚ ⲄⲀⲢ ϮⲤⲞⲈⲒⲦ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈⲦϮⲂⲀⲠⲦⲒⲤⲘⲀ ⲀϤⲦⲰⲞⲨⲚ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲨⲰ ⲈⲦⲂⲈ ⲠⲀⲒ ⲚϬⲞⲘ ⲈⲚⲈⲢⲄⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ⲚⲐⲈ ⲚⲞⲨⲀ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲠⲈϪⲀϤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈ ⲚⲦⲀⲒϤⲒⲦⲈϤⲀⲠⲈ ⲚⲦⲞϤ ⲠⲈ ⲚⲦⲀϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ϨⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲀϤϪⲞⲞⲨ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤⲘⲞⲢϤ ⲀϤⲔⲀⲀϤ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ⲈⲦⲂⲈ ϨⲎⲢⲰⲆⲒⲀⲤ ⲐⲒⲘⲈ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ ⲈⲂⲞⲖ ϪⲈ ⲀϤϨⲘⲞⲞⲤ ⲚⲘⲘⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ⲒⲰϨⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚϨⲎⲢⲰⲆⲎⲤ ϪⲈ ⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ ⲚⲀⲔ ⲈϪⲒ ⲚⲐⲒⲘⲈ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ϨⲎⲢⲰⲆⲒⲀⲤ ⲆⲈ ⲚⲈⲤϬⲞⲚⲦ ⲈⲢⲞϤ. ⲀⲨⲰ ⲚⲈⲤⲞⲨⲰϢ ⲈⲘⲞⲞⲨⲦϤ ⲘⲠⲈⲤϬⲘϬⲞⲘ ⲆⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ϨⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲚⲈϤⲞ ⲚϨⲞⲦⲈ ϨⲎⲦϤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲈϤⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲠⲈ ⲈϤⲞⲨⲀⲀⲂ ⲀⲨⲰ ⲚⲈϤⲦⲘⲀⲒⲞ ⲘⲘⲞϤ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲈⲢⲞϤ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲀϤⲢϢⲠⲎⲢⲈ ⲀⲨⲰ ⲚⲈϤⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϤⲠⲒⲐⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ⲚⲦⲈⲢⲈⲞⲨϨⲞⲞⲨ ⲆⲈ ⲚⲢⲀⲚ ϢⲰⲠⲈ ⲈⲀϨⲎⲢⲰⲆⲎⲤ ϨⲘ ⲠⲈϤϨⲞⲨⲘⲒⲤⲈ ⲈⲢⲞⲨⲆⲒⲠⲚⲞⲚ ⲈⲚⲈϤⲘⲈⲄⲒⲤⲦⲀⲚⲞⲤ ⲀⲨⲰ ⲈⲚⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲘⲚⲚⲚⲞϬ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ⲀⲤⲈⲒ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ⲚϨⲎⲢⲰⲆⲒⲀⲤ ⲀⲤⲞⲢⲬⲈ ⲀⲤⲢⲀⲚⲀϤ ⲚϨⲎⲢⲰⲆⲎⲤ ⲘⲚ ⲚⲈⲦⲚⲎϪ. ⲠⲈⲢⲞ ⲆⲈ ⲀϤϪⲞⲞⲤ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ ϪⲈ ⲀⲒⲦⲒ ⲘⲘⲞⲒ ⲘⲠⲈⲦⲈⲞⲨⲀϢϤ ⲀⲨⲰ ϮⲚⲀⲦⲀⲀϤ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ⲀⲨⲰ ⲀϤϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲚⲀⲤ ϪⲈ ⲠⲈⲦⲈⲢⲀⲀⲒⲦⲒ ⲘⲘⲞⲒ ⲘⲘⲞϤ ϮⲚⲀⲦⲀⲀϤ ⲚⲈ ϢⲀⲦⲠⲀϢⲈ ⲚⲦⲀⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ⲚⲦⲈⲢⲈⲤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀⲤϪⲞⲞⲤ ⲚⲦⲈⲤⲘⲀⲀⲨ ϪⲈ ⲦⲀⲀⲒⲦⲒ ⲚⲞⲨ. ⲚⲦⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲈⲦⲒ ⲚⲦⲀⲠⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲦⲈⲨⲚⲞⲨ ϢⲀⲠⲈⲢⲞ ⲀⲤⲀⲒⲦⲒ ⲘⲘⲞϤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ϪⲈⲔⲀⲀⲤ ⲦⲈⲚⲞⲨ ⲈⲔⲈϮ ⲚⲀⲒ ϨⲒϪⲚ ⲞⲨⲠⲒⲚⲀⲜ ⲚⲦⲀⲠⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲘⲔⲀϨ ⲚϨⲎⲦ ⲚϬⲒ ⲠⲢⲢⲞ. ⲈⲦⲂⲈ ⲚⲀⲚⲀⲨϢ ⲘⲚ ⲚⲈⲦⲚⲎϪ ⲚⲘⲘⲀϤ ⲘⲠϤⲞⲨⲰϢ ⲈⲦⲤⲦⲞⲤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲠⲈⲢⲞ ⲀϤϪⲞⲞⲨ ⲚⲞⲨⲤⲠⲈⲔⲞⲨⲖⲀⲦⲰⲢ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀϤ ⲈⲦⲢⲈϤⲚⲦⲈϤⲀⲠⲈ. ⲀϤⲂⲰⲔ ⲆⲈ ⲀϤϤⲒⲦⲈϤⲀⲠⲈ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ⲀϤⲚⲦⲤ ϨⲒϪⲘ ⲠⲠⲒⲚⲀⲜ ⲀϤⲦⲀⲀⲤ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲆⲈ ⲀⲤⲦⲀⲀⲤ ⲚⲦⲈⲤⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ⲀⲨⲈⲒ ⲀⲨϤⲒⲠⲈϤⲤⲰⲘⲀ ⲀⲨⲔⲀⲀϤ ϨⲚ ⲞⲨⲘϨⲀⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲆⲈ ⲀⲨⲤⲰⲞⲨϨ ⲈⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲀⲨϪⲰ ⲀⲨⲦⲀⲨⲞ ⲈⲢⲞϤ ⲚⲚⲈⲚⲦⲀⲨⲀⲀⲨ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲚⲦⲀⲨⲀⲀⲨ ⲚⲤⲂⲰ ");
INSERT INTO copshc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲀⲘⲎⲒⲚ ⲚⲦⲰⲦⲚ ⲚⲤⲀⲨⲤⲀ ⲈⲨⲘⲀ ⲚϪⲀⲒⲈ ⲚⲦⲈⲦⲚⲘⲦⲞⲚ ⲘⲘⲰⲦⲚ ⲚⲞⲨⲔⲞⲨⲈⲒ ⲚⲈⲦⲚⲎⲨ ⲄⲀⲢ ⲀⲨⲰ ⲚⲈⲦⲂⲎⲔ ⲚⲈⲚⲀϢⲰⲞⲨ ⲈⲘⲀⲨⲔⲀⲀⲨ ⲈⲤⲢϤⲈ ⲈⲞⲨⲰⲘ ");
INSERT INTO copshc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ⲀⲨⲰ ⲀⲨⲦⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲀⲨⲂⲰⲔ ⲘⲀⲨⲀⲀⲨ ⲈⲨⲘⲀ ⲚϪⲀⲈⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ⲀϨⲀϨ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲈⲨⲂⲎⲔ ⲀⲨⲤⲞⲨⲰⲚⲞⲨ ⲀⲨⲰ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲘⲠⲞⲖⲒⲤ. ⲀⲨⲠⲰⲦ ⲈⲢⲀⲦⲞⲨ. ⲀⲨⲢϢⲞⲢⲠ ⲆⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲚⲀⲨ ⲈⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ. ⲀⲨⲰ ⲀϤϢⲚ ϨⲦⲎϤ ⲈϪⲰⲞⲨ ϪⲈ ⲚⲈⲨⲞ ⲚⲐⲈ ⲚϨⲈⲚⲈⲤⲞⲞⲨ ⲈⲘⲘⲚⲦⲞⲨ ϢⲰⲤ ϨⲒϪⲰⲞⲨ. ⲀⲨⲰ ⲀϤⲀⲢⲬⲒ ⲈϮⲤⲂⲰ ⲚⲀⲨ ⲈⲘⲀⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ⲚⲦⲈⲢⲈⲚⲀⲨ ⲆⲈ ϢⲈ. ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲈⲒ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲘⲀ ⲞⲨϪⲀⲒⲈ ⲠⲈ. ⲀⲨⲰ ⲎⲆⲎ ⲀⲚⲀⲨ ϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ⲔⲀⲀⲨ ⲈⲂⲞⲖ ϪⲈ ⲈⲨⲈⲂⲰⲔ ⲈⲚⲤⲰϢⲈ ⲈⲦϨⲘⲠⲈⲨⲔⲰⲦⲈ ⲘⲚ ⲚⲈⲦⲘⲈ ⲚⲤⲈⲦⲞⲞⲨ ⲚⲀⲨ ⲚⲚⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ϮⲚⲀⲨ ⲚⲦⲰⲦⲚ ⲈⲦⲢⲈⲨⲞⲨⲰⲘ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲘⲀⲢⲚⲂⲰⲔ ⲚⲦⲚⲦⲞⲞⲨ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚϢⲈ ⲚⲞⲈⲒⲔ ⲚⲦⲚⲦⲀⲀⲨ ⲚⲀⲨ ⲈⲞⲨⲰⲘ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ϪⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲞⲨⲎⲢ ⲚⲞⲈⲒⲔ ⲂⲰⲔ ⲚⲦⲈⲦⲚⲚⲀⲨ. ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒⲘⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϮⲞⲨ ⲘⲚⲦⲂⲦ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ⲀⲨⲰ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲨ ⲈⲦⲢⲈⲨⲚⲞϪⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲨⲞ ⲚⲀⲨⲎⲦ ⲀⲨⲎⲦ ⲈϪⲘⲠⲈⲬⲞⲢⲦⲞⲤ ⲈⲦⲞⲨⲈⲦⲞⲨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ⲀⲨⲰ ⲀⲨⲚⲞϪⲞⲨ ⲈⲨⲞ ⲚⲀⲨⲎⲦ ⲀⲨⲎⲦ ϢⲈ ϢⲈ ⲀⲨⲰ ⲦⲀⲈⲒⲞⲨ ⲦⲀⲈⲒⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ⲚⲦⲈⲢⲈϤϪⲒ ⲆⲈ ⲘⲠϮⲞⲨ ⲚⲞⲒⲔ ⲚⲘⲠⲦⲂⲦ ⲤⲚⲀⲨ ⲀϤϤⲒⲀⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲀϤⲠⲈϢⲚⲞⲈⲒⲔ ⲀϤⲦⲀⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈⲔⲀⲀⲨ ϨⲀⲢⲰⲞⲨ ⲠⲔⲈⲦⲂⲦ ⲤⲚⲀⲨ ⲀϤⲠⲞϢⲞⲨ ⲈϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ⲀⲨⲰ ⲀⲨⲞⲨⲰⲘ ⲦⲎⲢⲞⲨ ⲀⲨⲤⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ⲀⲨⲰ ⲀⲨϤⲒⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲔⲞⲦ ⲈⲨⲘⲈϨ ⲖⲖⲀⲔⲘ ⲀⲨϤⲒ ⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ⲚⲈⲚⲦⲀⲨⲞⲨⲰⲘ ⲆⲈ ⲚⲈⲨⲚⲀⲢⲀⲨϬⲒⲤⲦⲂⲀ ⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲀⲚⲀⲄⲔⲀⲌⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲀⲨⲰ ⲈⲢϢⲞⲢⲠ ⲈⲢⲞϤ ⲈⲠⲒⲔⲢⲞ ⲈⲂⲎⲐⲤⲀⲒⲆⲀ ϢⲀⲚⲦⲈϤⲔⲀⲠⲘⲎⲎϢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀⲠⲞⲤⲦⲀⲤⲤⲈ ⲚⲀⲨ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲦⲞⲞⲨ ⲈϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ⲚⲦⲈⲢⲈⲢⲞⲨϨⲈ ⲆⲈ ϢⲰⲠⲈ ⲚⲈⲢⲈⲠϪⲞⲈⲒ ϨⲚ ⲦⲘⲎⲦⲈ ⲚⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ⲚⲦⲞϤ ⲚⲈϤϨⲒⲠⲈⲔⲢⲞ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲞⲨ ⲈⲨϨⲞⲤⲈ ϨⲘ ⲠⲦⲢⲈⲨⲤϬⲎⲢ ⲠⲦⲎⲨ ⲄⲀⲢ ⲚⲈϤϮ ⲞⲨⲂⲎⲨ ϨⲘ ⲠⲘⲈϨϤⲦⲞⲞⲨ ⲚϢⲰⲠ ⲚⲦⲈⲨϢⲎ ⲀϤⲈⲒ ϢⲀⲢⲞⲞⲨ ⲈϤⲘⲞⲞϢⲈ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲰ ⲚⲈϤⲞⲨⲰϢ ⲈⲠⲀⲢⲀⲄⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ⲚⲦⲞⲞⲨ ⲚⲆⲈ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲘⲞⲞϢⲈ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲘⲈⲈⲨⲈ ϪⲈ ⲞⲨⲪⲀⲚⲦⲀⲤⲘⲀ ⲠⲈ. ⲀⲨⲰ ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ⲀⲨⲈⲒⲞⲢϨϤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ. ⲀⲨⲰ ⲀⲨϢⲦⲞⲢⲦⲢ. ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲔ ⲚϨⲎⲦ ⲀⲚⲞⲔ ⲠⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ⲀⲨⲰ ⲀϤⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲚⲘⲘⲀⲨ ⲀⲠⲦⲎⲨⲖⲞ ⲂⲂⲞⲖ. ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲈⲘⲀⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ⲘⲠⲞⲨⲚⲞⲈⲒ ⲄⲀⲢ ϨⲒⲚⲞⲈⲒⲔ. ⲀⲖⲖⲀ ⲚⲈⲢⲈⲠⲈⲨϨⲎⲦ ⲦⲎⲘ ");
INSERT INTO copshc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ⲚⲦⲈⲢⲞⲨⲘⲞⲞⲚⲈ ⲆⲈ ⲈⲠⲈⲔⲢⲞ ⲀⲨⲈⲒ ⲈⲄⲈⲚⲚⲎⲤⲀⲢⲈⲦ ");
INSERT INTO copshc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ⲚⲦⲈⲢⲞⲨⲠⲈ ⲆⲈ ⲈⲠⲈⲔⲢⲞ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲤⲞⲨⲰⲚϤ ");
INSERT INTO copshc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ⲀⲨⲰ ⲀⲨⲠⲰⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲦⲎⲢⲤ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲰ ⲀⲨⲀⲢⲬⲈⲒ ⲈⲈⲒⲚⲈ ϨⲒϪⲚ ⲚⲈⲦϬⲖⲰϬ ⲚⲚⲈⲦⲘⲞⲔϨ ϨⲚ ⲚⲈⲨϢⲰⲚⲈ ⲈⲠⲘⲀ ⲈϢⲀⲨⲤⲰⲦⲘ ϪⲈ ϤⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ⲀⲨⲰ ⲠⲘⲀ ⲈⲦϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲈϨⲈⲚϮⲘⲈ ⲎϨⲈⲚⲠⲞⲖⲒⲤ ⲎϨⲈⲚⲤⲰϢⲈ. ϢⲀⲨⲔⲀⲚⲈⲦϢⲰⲚⲈ ϨⲚ ⲚⲀⲄⲞⲢⲀ ⲚⲤⲈⲤⲈⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲰϨ ⲈⲠⲦⲞⲠ ⲚⲦⲈϤϢⲦⲎⲚ ⲀⲨⲰ ⲚⲈϢⲀⲨϪⲰϨ ⲈⲢⲞϤ ϢⲀⲨⲖⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ⲀⲨⲤⲰⲞⲨϨ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲰ ϨⲞⲒⲚⲈ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈϨⲞⲒⲚⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲤⲈⲞⲨⲰⲘ ⲘⲠⲈⲨⲞⲈⲒⲔ ⲈⲘⲠⲞⲨⲈⲒⲀⲦⲞⲞⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲄⲀⲢ ⲘⲚⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲨⲦⲘⲒⲀⲦⲞⲞⲦⲞⲨ ⲘⲀⲨⲞⲨⲰⲘ ⲈⲨⲀⲘⲀϨⲦⲈ ⲚⲦⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ⲀⲨⲰ ⲈⲨϢⲀⲚⲈⲒ ⲚⲦⲀⲄⲞⲢⲀ ⲈⲨⲦⲘϬⲈϢϬⲰϢⲞⲨ ⲘⲈⲨⲞⲨⲰⲘ. ⲀⲨⲰ ϨⲈⲚⲔⲈⲤⲘⲞⲦ ⲦⲎⲢⲞⲨ ⲈⲀⲨϪⲒⲦⲞⲨ ⲈⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲞⲨ ϨⲈⲚⲀⲠⲞⲦ ⲈϨⲞⲢⲠⲞⲨ ⲚⲘϨⲈⲚⲜⲈⲤⲦⲎⲤ ⲚⲘϨⲈⲚⲬⲀⲖⲔⲒⲚ ");
INSERT INTO copshc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲚⲤⲈⲘⲞⲞϢⲈ ⲀⲚ ⲔⲀⲦⲀⲦⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ⲀⲖⲖⲀ ⲤⲈⲞⲨⲰⲘ ⲘⲠⲈⲨⲞⲒⲔ ⲈⲢⲈⲦⲞⲞⲦⲞⲨ ⲦⲞⲖⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲔⲀⲖⲰⲤ ⲀⲎⲤⲀⲒⲀⲤ ⲠⲢⲞⲪⲎⲦⲈⲨⲈ ϨⲀⲢⲰⲦⲚ ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲚⲐⲈ ⲈⲦϤⲤⲎϨ ϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲦⲘⲀⲒⲞ ⲘⲘⲞⲒ ϨⲚ ⲚⲈϤⲤⲠⲞⲦⲞⲨ. ⲠⲈⲨϨⲎⲦ ⲆⲈ ⲞⲨⲎⲨ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ⲈⲨⲞⲨⲰϢⲦ ⲆⲈ ⲘⲘⲞⲒ ⲈⲠϪⲒⲚϪⲎ ⲈⲨϮⲤⲂⲰ ⲚϨⲈⲚⲤⲂⲞⲞⲨⲈ ⲚⲈⲚⲦⲞⲖⲎ ⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ⲈⲀⲦⲈⲦⲚⲔⲰ ⲚⲤⲰⲦⲚ ⲚⲦⲈⲚⲦⲞⲖⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲈⲦⲚⲀⲘⲀϨⲦⲈ ⲚⲘⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲢⲢⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲔⲀⲖⲰⲤ ⲦⲈⲦⲚⲀⲐⲈⲦⲒ ⲚⲦⲈⲚⲦⲞⲖⲎ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲈⲦⲈⲦⲚⲈϨⲀⲢⲈϨ ⲈⲦⲈⲦⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲀϤϪⲞⲞⲤ ϪⲈ ⲘⲀⲦⲀⲒⲈⲠⲈⲔⲈⲒⲰⲦ ⲚⲘⲦⲈⲔⲘⲀⲀⲨ ⲀⲨⲰ ⲠⲈⲦⲚⲀϪⲒϢⲀϪⲈ ⲈϤϨⲞⲞⲨ ⲚⲤⲀⲠⲈϤⲈⲒⲰⲦ ⲎⲦⲈϤⲘⲀⲀⲨ ϨⲚ ⲞⲨⲘⲞⲨ ⲘⲀⲢⲈϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢϢⲀⲚⲠⲢⲰⲘⲈ ϪⲞⲞⲤ ⲘⲠⲈϤⲈⲒⲰⲦ ⲎⲦⲈϤⲘⲀⲀⲨ ϪⲈ ⲔⲞⲢⲂⲀⲚ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϪⲈ ⲞⲨⲆⲰⲢⲞⲚ ⲠⲈ ⲈⲔϢⲀⲚϮϨⲎⲨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ⲘⲀⲦⲈⲦⲚⲔⲀⲀϤ ϬⲈ ⲈⲢⲖⲀⲀⲨ ⲚϨⲰⲂ ⲘⲠⲈϤⲈⲒⲰⲦ ⲎⲦⲈϤⲘⲀⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ⲈⲦⲈⲦⲚⲦⲤⲦⲞ ⲈⲂⲞⲖ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲦⲈⲦⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲀⲦⲈⲦⲚⲦⲀⲀⲤ ⲈⲦⲞⲞⲦⲞⲨ ⲀⲨⲰ ϨⲈⲚⲔⲈϨⲂⲎⲨⲈ ⲦⲎⲢⲞⲨ ⲈⲨⲦⲚⲦⲰⲚ ⲈⲚⲀⲒ ⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲞⲚ ⲈⲠⲘⲎⲎϢⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲤⲰⲦⲘ ⲈⲢⲞⲈⲒ ⲦⲎⲢⲦⲚ ⲚⲦⲈⲦⲚⲚⲞⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ⲘⲘⲚⲖⲀⲀⲨ ⲈϤⲘⲠⲂⲞⲖ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲈϤⲚⲀϢϪⲀϨⲘⲈϤ ⲀⲖⲖⲀ ⲚⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ⲘⲠⲢⲰⲘⲈ ⲚⲦⲞⲞⲨ ⲚⲈⲦϪⲰϨⲘ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","— ");
INSERT INTO copshc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲔⲀⲠⲘⲎⲎϢⲈ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲀⲨϪⲚⲞⲨϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲞ ⲚⲀⲦϨⲎⲦ ϨⲒⲚⲀⲒ. ⲚⲦⲈⲦⲚⲚⲞⲈⲒ ⲀⲚ ϪⲈ ⲚⲔⲀ ⲚⲒⲘ ⲈϤⲘⲠⲂⲞⲖ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲚϤⲚⲀϢϪⲀϨⲘⲈϤ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ⲈⲂⲞⲖ ϪⲈ ⲚⲈϤⲂⲎⲔ ⲀⲚ ⲈϨⲞⲨⲚ ⲈⲪⲎⲦ. ⲀⲖⲖⲀ ⲈϨⲢⲀⲒ ⲈⲐⲎ. ⲀⲨⲰ ϤⲂⲎⲔ ⲈⲂⲞⲖ ⲈⲠⲘⲀ ⲚⲢⲘⲎ ⲈϤⲔⲀⲐⲀⲢⲒⲌⲈ ⲚⲚϬⲒⲚⲞⲨⲞⲞⲘ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲢⲰⲘⲈ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈϢⲀϤϪⲀϨⲘ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ⲈϤⲚⲎⲨ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒ ϨⲞⲨⲚ ⲘⲠϨⲎⲦ ⲚⲢⲢⲰⲘⲈ ⲚϬⲒ ⲘⲘⲈⲨⲈ ⲈⲐⲞⲞⲨ ϨⲈⲚⲠⲞⲢⲚⲈⲒⲀ ϨⲈⲚϪⲒⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ϨⲈⲚϨⲰⲦⲂ ϨⲈⲚⲘⲚⲦⲚⲞⲈⲒⲔ. ϨⲈⲚⲘⲚⲦⲘⲀⲒ ⲦⲞ ⲚϨⲞⲨⲞ ϨⲈⲚⲠⲞⲚⲎⲢⲒⲀ ⲞⲨⲘⲚⲦⲢⲈϤϪⲰϨⲘ ⲞⲨⲂⲀⲖ ⲈϤϨⲞⲞⲨ ⲞⲨⲘⲚⲦⲢⲈϤϪⲒⲞⲨⲀ ⲞⲨⲘⲚⲦϪⲀⲤⲒϨⲎⲦ ⲞⲨⲘⲚⲦⲀⲦϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲐⲞⲞⲨ ⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒ ϨⲞⲨⲚ ⲈⲨϪⲰϨⲘ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ⲚⲦⲈⲢⲈϤⲠⲰⲰⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲚⲦⲞϢ ⲚⲦⲨⲢⲞⲤ ⲚⲘⲤⲒⲆⲰⲚ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲘⲠϤⲞⲨⲰϢ ⲈⲦⲢⲈⲖⲀⲀⲨ ⲈⲒⲘⲈ. ⲀⲨⲰ ⲘⲠⲈϤⲈϢϨⲰⲠ ");
INSERT INTO copshc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ⲀⲖⲖⲀ ⲚⲦⲈⲨⲚⲞⲨ ⲚⲦⲈⲢⲈⲤⲤⲰⲦⲘ ⲈⲦⲂⲎⲎⲦϤ ⲚϬⲒ ⲞⲨⲤϨⲒⲘⲈ ⲈⲨⲚⲦⲤⲞⲨϢⲈⲈⲢⲈ ⲘⲘⲀⲨ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲘⲘⲀⲤ ⲀⲤⲈⲒ ⲀⲤⲠⲀϨⲦⲤ ϨⲀⲢⲀⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ⲦⲈⲤϨⲒⲘⲈ ⲆⲈ ⲚⲈⲨϨⲈⲖⲖⲎⲚ ⲦⲈ ⲢⲢⲘⲦⲈⲪⲞⲒⲚⲒⲔⲎ ⲚⲦⲤⲨⲢⲒⲀ. ⲀⲨⲰ ⲀⲤⲤⲈⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲚⲈϪⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲒ ⲦⲈⲤϢⲈⲈⲢⲈ ");
INSERT INTO copshc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲤ ϪⲈ ⲔⲀⲚϢⲎⲢⲈ ⲈⲦⲢⲈⲨⲤⲈⲒ ⲚϢⲞⲢⲠ. ⲚⲚⲀⲚⲞⲨⲤ ⲄⲀⲢ ⲀⲚ ⲈϪⲒ ⲘⲠⲞⲈⲒⲔ ⲚⲚϢⲎⲢⲈ ⲈⲚⲞϪϤ ⲚⲚⲈⲨϨⲞⲞⲢ. ");
INSERT INTO copshc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ⲚⲦⲞⲤ ⲆⲈ ⲀⲤⲞⲨⲰϢⲂ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ. ⲚⲔⲈⲞⲨϨⲞⲞⲢ ϢⲀⲨⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲤⲢⲈϤⲢⲒϤⲈ ϨⲀⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲚⲚϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲂⲰⲔ ⲈⲦⲂⲈ ⲠⲈⲈⲒϢⲀϪⲈ ⲀⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲞⲨϢⲈⲈⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ⲚⲦⲈⲢⲈⲤⲂⲰⲔ ⲆⲈ ⲈⲠⲈⲤⲎⲒ ⲀⲤϨⲈ ⲈⲦⲈϢϢⲈⲈⲢⲈ ⲈⲤⲚⲎϪ ϨⲒⲠⲈϬⲖⲞϬ ⲈⲀⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲖⲞ ϨⲒⲰⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ⲚⲦⲈⲢⲈϤⲈⲒ ⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲦⲞϢ ⲚⲦⲨⲢⲞⲤ. ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲤⲒⲆⲰⲚ ⲈⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ϨⲚ ⲦⲘⲎⲦⲈ ⲚⲚⲦⲞϢ ⲚⲦⲆⲈⲔⲀⲠⲞⲖⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ⲀⲨⲰ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲀⲖ ⲚⲘⲠⲞ. ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ⲚⲦⲈⲢⲈϤⲚⲦϤ ⲆⲈ ⲈⲂⲞⲖ ⲞⲨⲦⲈⲠⲘⲎⲎϢⲈ. ⲀϤϪⲒⲦϤ ⲈⲨⲤⲀ ⲀϤⲚⲈϪⲚⲈϤⲦⲎⲎⲂⲈ ⲈϨⲞⲨⲚ ⲈⲚⲈϤⲘⲀⲀϪⲈ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲈϪⲦⲀϤ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀϤϪⲰϨ ⲈⲠⲈϤⲖⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϤⲒⲒⲀⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤⲀϢⲀϨⲞⲘ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲠⲪⲀⲐⲀ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲞⲨⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ⲀⲨⲰ ⲚⲈϤⲘⲀⲀϪⲈ ⲀⲨⲞⲨⲰⲚ ⲀⲨⲰ ⲀⲤⲞⲨⲰⲚ ⲚϬⲒ ⲦⲘⲢⲢⲈ ⲘⲠⲈϤⲖⲀⲤ ⲀϤϢⲀϪⲈ ⲔⲀⲖⲰⲤ ");
INSERT INTO copshc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ⲀⲨⲰ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲨϪⲞⲞⲤ ⲖⲖⲀⲀⲨ ϨⲞⲤⲞⲚ ⲆⲈ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲦⲞⲞⲨ ⲚϨⲞⲨⲞ ⲞⲚ ⲈⲨϮ ⲘⲠⲈϤⲤⲞⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ⲀⲨⲰ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ⲈⲘⲀⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀⲖⲰⲤ ϨⲰⲂ ⲚⲒⲘ ⲀϤⲀⲀⲨ ϨⲰⲤⲦⲈ ⲚϤⲦⲈⲚⲔⲈⲀⲖ ⲤⲰⲦⲘ ⲀⲨⲰ ⲚⲈⲘⲠⲞ ⲚϤⲦⲢⲈⲨϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲨⲚⲞⲨⲚⲞϬ ⲞⲚ ⲘⲘⲎⲎϢⲈ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲈⲘⲘⲚⲦⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ϪⲈ ϮϢⲚϨⲦⲎⲈⲒ ⲈϪⲘⲠⲘⲎⲎϢⲈ ϪⲈⲎⲆⲎ ⲈⲒⲤϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲤⲈⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲈⲒ ⲈⲢⲞⲈⲒ. ⲈⲘⲘⲚⲦⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ");
INSERT INTO copshc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ⲀⲨⲰ ⲈⲒϢⲀⲚⲔⲀⲀⲨ ⲈⲂⲞⲖ ⲈⲘⲠⲞⲨⲰⲘ ⲤⲈⲚⲀⲤⲰϢⲘ ϨⲚ ⲦⲈϨⲒⲎ ⲈⲨⲚϨⲞⲒⲚⲈ ⲚϨⲎⲦⲞⲨ ϢⲞⲞⲠ ϨⲘ ⲠⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲚⲀϢⲦⲤⲒⲈⲚⲀⲒ ⲚⲞⲈⲒⲔ ⲘⲠⲈⲒⲘⲀ ϨⲚ ⲞⲨϪⲀⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ⲀⲨⲰ ⲀϤϪⲚⲞⲨⲞⲨ ϪⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲞⲨⲎⲢ ⲘⲘⲀⲨ ⲚⲞⲈⲒⲔ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲤⲀϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ⲀⲨⲰ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦϤ ⲘⲠⲘⲎⲎϢⲈ ⲈⲦⲢⲈⲨⲚⲞϪⲞⲨ ϨⲒⲠⲈⲤⲎⲦ ⲀϤϪⲒ ⲆⲈ ⲘⲠⲤⲀϢϤ ⲚⲞⲈⲒⲔ ⲀϤϢⲠϨⲘⲞⲦ ⲈϪⲰⲞⲨ ⲀϤⲠⲞϢⲞⲨ ⲀⲨⲰ ⲀϤⲦⲀⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈⲔⲀⲀⲨ ϨⲀⲢⲰⲞⲨ. ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ ϨⲀⲢⲰϤ ⲘⲠⲘⲎⲎϢⲈ ⲚⲈⲨⲚⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ϨⲈⲚⲔⲈϢⲎⲘ ⲆⲈ ⲚⲦⲂⲦ ⲚⲦⲈⲢⲈϤⲤⲘⲞⲨ ⲆⲈ ⲈⲢⲞⲞⲨ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲔⲀⲚⲈⲈⲒⲔⲞⲞⲨⲈ ϨⲀⲢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ⲀⲨⲞⲨⲰⲘ ⲆⲈ ⲀⲨⲤⲒ ⲀⲨⲰ ⲀⲨϤⲒ ⲚⲖⲖⲀⲔⲘ. ⲈⲚⲦⲀⲨⲢϨⲞⲨⲞ ⲈⲨⲚⲀⲢⲤⲀϢϤ ⲂⲂⲒⲢ ");
INSERT INTO copshc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ⲚⲈⲨⲚⲀⲢϨⲘⲈ ⲆⲈ ⲚϢⲈ ⲀⲨⲰ ⲀϤⲔⲀⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲈϤⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲚⲤⲀ ⲚⲆⲀⲖⲘⲀⲚⲞⲨⲐⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ⲀⲨⲰ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲀⲢⲬⲈⲒ ⲈϮⲦⲰⲚ ⲚⲘⲘⲀϤ ⲈⲨⲔⲰⲦⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ ⲚⲦⲞⲞⲦϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀϢⲀϨⲞⲘ ϨⲘ ⲠⲈϤⲠⲚⲈⲨⲘⲀ ⲠⲈϪⲀϤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲈⲒⲄⲈⲚⲈⲀ ⲔⲰⲦⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲤⲈⲚⲀϮⲘⲀⲈⲒⲚ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲖⲞ ϨⲀⲢⲞⲞⲨ ⲀϤⲦⲀⲖⲈ ⲞⲚ ⲈⲠϪⲞⲈⲒ ⲀϤⲂⲰⲔ ⲈⲠⲒⲔⲢⲞ ");
INSERT INTO copshc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ⲀⲨⲰ ⲀⲨⲢⲠⲰⲂϢ ⲚϪⲒⲞⲈⲒⲔ ⲚⲀⲨ. ⲀⲨⲰ ⲚⲈⲘⲘⲚⲦⲀⲨ ⲘⲘⲀⲨ ⲚⲤⲀⲞⲨⲞⲈⲒⲔ ⲞⲨⲰⲦ ϨⲘ ⲠϪⲞⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ⲀⲨⲰ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲰϢⲦ ⲚⲦⲈⲦⲚϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ⲈⲠⲈⲐⲀⲂ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲠⲈⲐⲀⲂ ⲚϨⲎⲢⲰⲆⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ⲀⲨⲰ ⲀⲨⲘⲈⲔⲘⲞⲨⲔⲞⲨ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲘⲚⲦⲞⲨⲞⲈⲒⲔ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲘⲞⲔⲘⲈⲔ ϪⲈ ⲘⲘⲚⲦⲎⲦⲚⲞⲈⲒⲔ ⲘⲘⲀⲨ. ⲚⲦⲈⲦⲚⲚⲞⲈⲒ ⲀⲚ ⲞⲨⲆⲈ ⲚⲦⲈⲦⲚϮ ⲀⲚ ⲚϨⲦⲎⲦⲚ ⲠⲈⲦⲚϨⲎⲦ ⲦⲎⲘ ");
INSERT INTO copshc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ⲈⲢⲈⲚⲈⲦⲚⲂⲀⲖ ⲘⲘⲰⲦⲚ ⲚⲦⲈⲦⲚⲈⲒⲰⲢϨ ⲀⲚ. ⲀⲨⲰ ⲈⲢⲈⲚⲈⲦⲚⲘⲀⲀϪⲈ ⲘⲘⲰⲦⲚ ⲚⲦⲈⲦⲚⲤⲰⲦⲘ ⲀⲚ ⲀⲨⲰ ⲚⲦⲈⲦⲚⲢⲠⲘⲈⲨⲈ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ⲚⲦⲈⲢⲒⲠⲈϢϮⲞⲨ ⲚⲞⲈⲒⲔ ⲈⲠϬⲒⲤⲦⲂⲀ ⲢⲢⲰⲘⲈ. ⲀⲦⲈⲦⲚϤⲒⲞⲨⲎⲢ ⲚⲔⲞⲦ ⲈⲨⲘⲈϨ ⲖⲖⲀⲔⲘ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ⲚⲦⲈⲢⲒⲠⲰϢ ⲞⲚ ⲘⲠⲤⲀϢϤ ⲚⲞⲈⲒⲔ ⲈⲠⲈϨⲘⲈ ⲚϢⲈ ⲢⲢⲰⲘⲈ ⲀⲦⲈⲦⲚϤⲒⲞⲨⲎⲢ ⲂⲂⲒⲢ ⲈⲨⲘⲈϨ ⲖⲖⲀⲔⲘ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲀϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲰⲤ ϬⲈ ⲚⲦⲈⲦⲚⲚⲞⲈⲒⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ⲀⲨⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲂⲎⲆⲤⲀⲒⲆⲀⲚ ⲀⲨⲰ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚⲞⲨⲂⲖⲖⲈ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰϨ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀⲘⲀϨⲦⲈ ⲚⲦⲞⲞⲦϤ ⲘⲠⲂⲖⲖⲈ. ⲀϤⲚⲦϤ ⲈⲠⲂⲞⲖ ⲚⲦⲔⲰⲘⲎ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲈϪⲠⲀϬⲤⲈ ⲈϨⲞⲨⲚ ϨⲚ ⲚⲈϤⲂⲀⲖ ⲀϤⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲰϤ ⲀϤϪⲚⲞⲨϤ ⲆⲈ ϪⲈ ⲈⲔⲚⲀⲨ ⲈⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ⲚⲦⲈⲢⲈϤϤⲒⲒⲀⲦϤ ⲆⲈ ⲈϨⲢⲀⲒ ⲠⲈϪⲀϤ ϪⲈ ϮⲚⲀⲨ ⲈⲚⲢⲰⲘⲈ ⲈⲨⲘⲞⲞϢⲈ ⲚⲐⲈ ⲚϨⲈⲚϢⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ⲠⲀⲖⲒⲚ ⲀϤⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲚ ⲚⲈϤⲂⲀⲖ ⲀⲒⲀⲦϤ ⲤⲰⲦϤ ⲀϤⲈⲒⲰⲢϨ ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲚⲔⲀ ⲚⲒⲘ ⲔⲀⲖⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ⲀⲨⲰ ⲀϤϪⲞⲞⲨϤ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲎⲈⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲢⲂⲰⲔ ⲢⲰ ⲈϨⲞⲨⲚ ⲈⲦⲔⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲔⲰⲘⲎ ⲚⲦⲔⲈⲤⲀⲢⲒⲀ ⲚⲦⲈⲪⲒⲖⲒⲠⲠⲞⲤ. ⲀⲨⲰ ⲈϤϨⲚⲦⲈϨⲒⲎ ⲀϤϪⲚⲞⲨⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲈⲢⲈⲢⲢⲰⲘⲈ ϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲈⲒ ϪⲈ ⲀⲚⲄⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϨⲞⲒⲚⲈ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ. ϨⲈⲚⲔⲞⲞⲨⲈ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲞⲨⲀ ⲠⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ⲚⲦⲞϤ ⲆⲈ ⲀϤϪⲚⲞⲨⲞⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲆⲈ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲈⲒ ϪⲈ ⲀⲚⲄⲚⲒⲘ. ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ⲀⲨⲰ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈⲨϪⲞⲞⲤ ⲖⲖⲀⲀⲨ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ⲀⲨⲰ ⲀϤⲀⲢⲬⲒ ⲚⲦⲞⲨⲚⲈⲒⲀⲦⲞⲨ ⲈⲂⲞⲖ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲀϪⲠⲒϢⲈⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲚⲤⲈⲤⲦⲞϤ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ⲚⲤⲈⲘⲞⲞⲨⲦϤ. ⲀⲨⲰ ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲚϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ⲀⲨⲰ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲚⲈϤϪⲰ ⲘⲠϢⲀϪⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲀϤⲀⲢⲬⲈⲒ ⲚⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲔⲦⲞϤ ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲂⲰⲔ ⲈⲠⲀϨⲞⲨ ⲘⲘⲞⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲂⲞⲖ ϪⲈ ⲚⲄⲘⲈⲈⲨⲈ ⲀⲚ ⲈⲚⲀⲠⲚⲞⲨⲦⲈ ⲀⲖⲖⲀ ⲈⲚⲀⲚⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲘⲞⲨⲦⲈ ⲈⲠⲘⲎⲎϢⲈ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲞⲨⲰϢ ⲈⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲘⲀⲢⲈϤⲀⲢⲚⲀ ⲘⲘⲞϤ ⲚϤϤⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲚϤⲞⲨⲀϨϤ ⲚⲤⲰⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲄⲀⲢ ⲈⲚⲀϨⲘ ⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲤⲞⲢⲘⲈⲤ . ⲠⲈⲦⲚⲀⲤⲰⲢⲘ ⲆⲈ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲦⲂⲎⲎⲦ ⲘⲚ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϤⲚⲀⲦⲞⲨϪⲞⲤ . ");
INSERT INTO copshc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ⲞⲨ ⲄⲀⲢ ⲈⲦⲚⲀϮϨⲎⲨ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲢⲈϤϪⲠⲈⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲀⲨⲰ ⲚϤϮⲞⲤⲈ ⲚⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ⲀⲨⲰ ⲞⲨ ⲠⲈⲦⲈⲢⲈ ⲠⲢⲰⲘⲈ ⲚⲀⲦⲀⲀϤ ⲚϢⲂⲂⲒⲰ ϨⲀⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ⲠⲈⲦⲚⲀϮϢⲒⲠⲈ ⲄⲀⲢ ⲚⲀⲒ ⲘⲚ ⲚⲈⲦⲈⲚⲞⲨⲒ ⲚⲈ ϨⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲚⲚⲞⲈⲒⲔ. ⲀⲨⲰ ⲚⲢⲈϤⲢⲚⲞⲂⲈ. ⲠϢⲎⲢⲈ ϨⲰⲰϤ ⲘⲠⲢⲰⲘⲈ ⲚⲀϮϢⲒⲠⲈ ⲚⲀϤ ⲈϤϢⲀⲚⲈⲒ ϨⲘ ⲠⲈⲞⲞⲨ ⲘⲠⲈϤⲈⲒⲰⲦ ⲘⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲞⲨⲀⲀⲂ ");
INSERT INTO copshc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲈⲒⲘⲀ ⲈⲚⲤⲈⲚⲀϪⲒϮⲠⲈ ⲀⲚ ⲘⲠⲘⲞⲨ ϢⲀⲚⲦⲞⲨⲚⲀⲨ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲀⲤⲈⲒ ϨⲚ ⲞⲨϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ⲀⲨⲰ ⲘⲚⲚⲤⲀⲤⲞⲞⲨ ⲚϨⲞⲞⲨ ⲀϤϪⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤϪⲒⲦⲞⲨ ⲘⲘⲀⲨⲀⲀⲨ ⲈϪⲚ ⲞⲨⲦⲞⲞⲨ ⲈϤϪⲞⲤⲈ ⲀⲨⲰ ⲀϤϢⲂⲦϤ ϨⲒϨⲎ ⲘⲘⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ⲀⲨⲰ ⲚⲈϤϨⲞⲒⲦⲈ ⲀⲨⲘⲞⲨϨ ⲈⲀⲨⲞⲨⲂⲀϢ ⲈⲘⲀⲦⲈ. ⲈⲚⲚⲈϢⲞⲨⲢⲀϨⲦ ⲚⲦⲰϬⲤ ⲦⲢⲈⲨⲠⲒⲢⲈ ϨⲒⲚⲀⲒ ϨⲒϪⲘⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ⲀⲨⲰ ⲀϤⲞⲨⲰⲚϨ ⲈⲢⲞⲞⲨ ⲚϬⲒ ϨⲎⲖⲈⲒⲀⲤ ⲚⲘⲘⲰⲨⲤⲎⲤ ⲈⲨϢⲀϪⲈ ⲘⲚ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲚ ⲈⲦⲢⲈⲚϬⲰ ⲘⲠⲈⲒⲘⲀ. ⲦⲀⲢⲚⲦⲀⲘⲒⲞ ϬⲈ ⲚϢⲞⲘⲦⲈ ⲚⲤⲔⲎⲚⲎ ⲞⲨⲈⲒ ⲚⲀⲔ ⲀⲨⲰ ⲞⲨⲈⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲀⲨⲰ ⲞⲨⲈⲒ ⲚϨⲎⲖⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ⲚⲈϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈⲞⲨ. ⲀⲦϨⲞⲦⲈ ⲄⲀⲢ ϪⲒⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ⲀⲨⲰ ⲀⲨⲔⲖⲞⲞⲖⲈ ⲠⲰⲢϢ ⲈⲂⲞⲖ ⲈϪⲰⲞⲨ. ⲀⲨⲤⲘⲎ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲖⲞⲞⲖⲈ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲘⲈⲢⲒⲦ ⲤⲰⲦⲘ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ⲀⲨⲰ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲚⲦⲈⲢⲞⲨϤⲒⲀⲦⲞⲨ ⲈϨⲢⲀⲒ ⲘⲠⲞⲨⲚⲀⲨ ⲈⲔⲈⲖⲀⲀⲨ ⲚⲘⲘⲀⲨ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ϨⲒϪⲚ ⲠⲦⲞⲞⲨ. ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨⲦⲀⲨⲈ ⲚⲈⲚⲦⲀⲨⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲈⲖⲀⲀⲨ. ⲈⲒⲘⲎⲦⲒ ⲈⲢϢⲀⲚⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","— ");
INSERT INTO copshc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ⲀⲨⲰ ⲀⲨϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ϤⲚⲀϪⲠⲒⲈⲒ ⲚϢⲞⲢⲠ ");
INSERT INTO copshc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲘⲈⲚ ⲈϤϢⲀⲚⲈⲒ ϤⲚⲀϪⲈⲔϨⲰⲂ ⲚⲒⲘ ⲈⲂⲞⲖ ⲀⲨⲰ ⲠⲰⲤ ⲚⲦⲀⲨⲤϨⲀⲒ ⲈϪⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϢⲈⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲚⲤⲈⲤⲞϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲔⲈϨⲎⲖⲈⲒⲀⲤ ⲀϤⲈⲒ ⲀⲨⲰ ⲀⲨⲈⲒⲢⲈ ⲚⲀϤ ⲚⲚⲈⲚⲦⲀⲨⲞⲨⲀϢⲞⲨ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲨⲤϨⲀⲒ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲚⲀⲨ ⲈⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ϨⲘ ⲠⲈⲨⲔⲰⲦⲈ ⲀⲨⲰ ϨⲈⲚⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲨϮⲦⲰⲚ ⲚⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲈⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨϢⲦⲞⲢⲦⲢ ⲀⲨⲰ ⲀⲨⲠⲰⲦ ⲈⲢⲀⲦϤ ⲈⲀⲤⲠⲀⲌⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ⲀϤϪⲚⲞⲨⲞⲨ ⲆⲈ ϪⲈ ⲈⲦⲈⲦⲚϮⲦⲰⲚ ⲈⲦⲂⲈ ⲞⲨ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ⲀⲨⲰ ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲀⲒⲚⲠⲀϢⲎⲢⲈ ⲈⲢⲀⲦⲔ ⲈⲢⲈⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲘⲠⲞ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ⲀⲨⲰ ⲠⲘⲀ ⲈⲦϤⲚⲀⲦⲀϨⲞϤ ϢⲀϤⲢⲀϨⲦϤ ⲈⲠⲔⲀϨ ⲚϤⲦⲀⲨⲈⲤϨⲂⲎⲒⲦⲈ ⲈⲂⲞⲖ ⲚϤϨⲢⲀϪⲢⲈϪ ⲚⲚⲈϤⲞⲂϨⲈ ⲚϤⲦⲰⲤ. ⲀⲒϪⲞⲞⲤ ϬⲈ ⲚⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈⲚⲞϪϤ ⲈⲂⲞⲖ ⲀⲨⲰ ⲘⲠⲞⲨϢⲚⲞϪϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲰⲦⲄⲈⲚⲈⲀ ⲚⲀⲦⲚⲀϨⲦⲈ ϢⲀⲦⲚⲀⲨ ⲈⲒⲚⲀϢⲰⲠⲈ ⲚⲘⲘⲎⲦⲚ. ϢⲀⲦⲚⲀⲨ ⲈⲒⲚⲀⲀⲚⲈⲬⲈ ⲘⲘⲰⲦⲚ ⲀⲨⲈⲒⲤϤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ⲀⲨⲰ ⲀϤϪⲒⲦϤ ⲚⲀϤ. ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ. ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲢⲀϨⲦⲠⲢⲰⲘⲈ ⲈⲠⲔⲀϨ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲈ ⲀϤϨⲒⲦⲈ ϨⲒⲠⲈⲤⲎⲦ ⲈϤⲦⲀⲨⲈⲤⲂⲎⲒⲦⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ⲀϤϪⲚⲞⲨ ⲠⲈϤⲈⲒⲰⲦ ⲆⲈ ϪⲈ ⲈⲒⲤⲀⲞⲨⲎⲢ ⲚⲞⲨⲞⲈⲒϢ ϪⲒⲚⲦⲀⲠⲀⲈⲒ ⲦⲀϨⲞϤ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϪⲒⲚ ⲦⲈϤⲘⲚⲦⲔⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ⲀⲨⲰ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲀϤⲚⲞϪϤ ⲈⲠⲔⲰϨⲦ ⲀⲨⲰ ⲈⲠⲘⲞⲞⲨ ϪⲈ ⲈϤⲈⲘⲞⲞⲨⲦϤ. ⲀⲖⲖⲀ ⲂⲞⲎⲐⲈⲒ ⲈⲢⲞⲚ ϨⲘ ⲠⲈⲦⲔⲚⲀϢⲀⲀϤ ⲈⲔϢⲚϨⲦⲎⲔ ϨⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈϪⲞⲞⲤ ϪⲈ ⲠⲈⲦⲔⲚⲀϢⲀⲀϤ. ⲞⲨⲚϬⲞⲘ ⲈϨⲰⲂ ⲚⲒⲘ ⲘⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲒⲰⲦ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲠⲒⲤⲦⲈⲨⲈ ⲂⲞⲎⲐⲈⲒ ⲈⲦⲀⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲘⲎⲎϢⲈ ⲠⲎⲦ ⲈⲢⲀⲦϤ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲘⲠⲞ ⲀⲨⲰ ⲚⲀⲖ ⲀⲚⲞⲔ ⲠⲈ ⲈⲦⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲔ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚⲄⲦⲘⲔⲞⲦⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ⲚⲦⲈⲢⲈϤϪⲒϢⲔⲀⲔ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀϤⲢⲀϨⲦϤ ϨⲒⲠⲔⲀϨ. ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲘⲘⲞϤ. ⲀⲨⲰ ⲀϤⲢⲐⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ϨⲰⲤⲦⲈ ⲚⲦⲈⲞⲨⲘⲎⲎϢⲈ ϪⲞⲞⲤ ϪⲈ ⲀϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲦⲈϤϬⲒϪ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲀϤⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ. ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲚⲞⲨϤ ⲚⲤⲀⲨⲤⲀ. ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲚⲞⲚ ⲘⲠⲚⲈϢⲚⲞϪϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲠⲀⲒⲄⲈⲚⲞⲤ ⲘⲈⲨⲈϢⲚⲞϪϤ ⲈⲂⲞⲖ ⲈⲒⲘⲎⲦⲒ ϨⲘ ⲠⲈϢⲖⲎⲖ ⲚⲘⲦⲚⲎⲤⲦⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲀⲨⲰ ⲚⲈϤⲞⲨⲰϢ ⲀⲚ ⲈⲦⲢⲈⲖⲀⲀⲨ ⲈⲒⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ⲚⲈϤⲦⲤⲀⲂⲞ ⲄⲀⲢ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲦⲀⲀϤ ⲈϨⲢⲀⲒ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲢⲢⲰⲘⲈ ⲚⲤⲈⲘⲞⲨⲞⲨⲦϤ ⲀⲨⲰ ⲈϤϢⲀⲚⲘⲞⲨ ⲘⲘⲚⲚⲤⲀϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ϤⲚⲀⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ⲚⲦⲞⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲈⲒⲘⲈ ⲈⲠϢⲀϪⲈ ⲀⲨⲰ ⲚⲈⲨⲢϨⲞⲦⲈ ⲈϪⲚⲞⲨϤ ");
INSERT INTO copshc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ⲀⲨⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲔⲀⲠⲀⲢⲚⲀⲞⲨⲘ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲀϤϪⲚⲞⲨⲞⲨ ϪⲈ ⲈⲢⲈⲦⲚϢⲀϪⲈ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ϨⲚ ⲦⲈϨⲒⲎ ⲈⲦⲂⲈ ⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲀⲢⲰⲞⲨ ⲚⲈⲨϢⲀϪⲈ ⲄⲀⲢ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϨⲚ ⲦⲈϨⲒⲎ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲚⲞϬ ⲈⲦⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ⲚⲦⲈⲢⲈϤϨⲘⲞⲞⲤ ⲆⲈ ⲈϨⲢⲀⲈⲒ ⲀϤⲘⲞⲨⲦⲈ ⲈⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲞⲨⲰϢ ⲈⲢⲚⲞϬ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤⲚⲀⲢⲔⲞⲨⲒ ⲈⲞⲨⲞⲚ ⲚⲒⲘ. ⲀⲨⲰ ⲚϤⲆⲒⲀⲔⲞⲚⲒⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲒ ⲚⲞⲨϢⲎⲢⲈ ϢⲎⲘ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲔⲦⲈⲦⲞⲞⲦϤ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ϪⲈ ⲠⲈⲦⲚⲀϢⲰⲠ ⲈⲢⲞϤ ⲚⲞⲨⲀ ⲚⲐⲈ ⲚⲚⲒ ϢⲎⲢⲈ ϢⲎⲘ ϨⲘ ⲠⲀⲢⲀⲚ ⲀⲚⲞⲔ ⲠⲈⲦϤⲚⲀϢⲞⲠⲦ ⲈⲢⲞϤ. ⲀⲨⲰ ⲠⲈⲦⲚⲀϢⲞⲠⲦ ⲈⲢⲞϤ ⲚⲀⲚⲞⲔ ⲀⲚ ⲠⲈⲦϤⲚⲀϢⲞⲠⲦ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ⲠⲈϪⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲀⲚⲚⲀⲨ ⲈⲞⲨⲀ ⲈϤⲚⲈϪ ⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲀⲨⲰ ⲀⲚⲔⲰⲖⲨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϪⲈ ⲚϤⲘⲞⲞϢⲈ ⲀⲚ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲠⲢⲔⲰⲖⲨ ⲘⲘⲞϤ. ⲘⲘⲚⲖⲀⲀⲨ ⲄⲀⲢ ⲈϤⲚⲀⲈⲒⲢⲈ ⲚⲞⲨϬⲞⲘ ϨⲘ ⲠⲀⲢⲀⲚ ⲈϤⲚⲀϬⲘϬⲞⲘ ⲦⲀⲬⲨ ⲈϪⲈⲠⲀⲠⲈⲐⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ⲠⲈⲦⲈⲚϤϮ ⲄⲀⲢ ⲀⲚ ⲚⲘⲘⲀⲚ ⲈϤϮ ⲈϪⲰⲚ ");
INSERT INTO copshc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ⲠⲈⲦⲚⲀⲦⲤⲈ ⲦⲎⲚⲞⲨ ⲄⲀⲢ ⲚⲞⲨⲀⲠⲞⲦ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲀⲢⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ⲚⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚϤⲚⲀⲤⲰⲢⲘ ⲀⲚ ⲘⲠⲈϤⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲚⲞⲨⲀ ⲚⲚⲀⲒⲔⲞⲨⲈⲒ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲚⲀⲚⲞⲨⲤ ⲚⲀϤ ⲚϨⲞⲨⲞ ⲈⲚⲈⲨⲚⲞⲨⲰⲚⲈ ⲚⲤⲒⲔⲈ ⲀϢⲈ ⲈⲠⲈϤⲘⲀⲔϨ ⲚⲤⲈⲚⲞϪϤ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ ");
INSERT INTO copshc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ⲀⲨⲰ ⲈⲢϢⲀⲚⲦⲈⲔϬⲒϪ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ϢⲀⲀⲦⲤ ⲈⲂⲞⲖ ⲘⲘⲞⲔ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ ⲈⲔⲞ ⲚϬⲀⲚⲀϨ ⲈϨⲞⲨⲈⲢⲞⲤ ⲈⲢⲈϬⲒϪ ⲤⲚⲦⲈ ⲘⲘⲞⲔ ⲚⲄⲂⲰⲔ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ⲈⲦⲤⲀⲦⲈ ⲈⲘⲈⲤϪⲈⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","— ");
INSERT INTO copshc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ⲀⲨⲰ ⲈⲢϢⲀⲚ ⲦⲈⲔⲞⲨⲈⲢⲎⲦⲈ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ϢⲀⲀⲦⲤ ⲈⲂⲞⲖ ⲘⲘⲞⲔ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ ⲈⲔⲞ ⲚϬⲀⲖⲈ ⲈϨⲞⲨⲈⲢⲞⲤ ⲈⲢⲈⲞⲨⲈⲢⲎⲦⲈ ⲤⲚⲦⲈ ⲘⲘⲞⲔ ⲚⲤⲈⲚⲞϪⲔ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ");
INSERT INTO copshc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","— ");
INSERT INTO copshc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ⲀⲨⲰ ⲈⲢϢⲀⲚⲠⲈⲔⲂⲀⲖ ⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲞⲔ ⲠⲞⲢⲔϤ ⲚⲄⲚⲞϪϤ ⲈⲂⲞⲖ ⲘⲘⲞⲔ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲔ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲂⲀⲖ ⲞⲨⲰⲦ ⲈϨⲞⲨⲈⲢⲞⲤ ⲈⲢⲈⲂⲀⲖ ⲤⲚⲀⲨ ⲘⲘⲞⲔ ⲚⲤⲈⲚⲞϪⲔ ⲈⲦⲄⲈϨⲈⲚⲚⲀ ");
INSERT INTO copshc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ⲠⲘⲀ ⲈⲦⲈⲘⲠⲈⲨϤⲚⲦ ⲚⲀⲘⲞⲨ ⲀⲚ. ⲀⲨⲰ ⲦⲈⲨⲤⲀⲦⲈ ⲚⲤⲚⲀϪⲈⲚⲀ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲤⲈⲚⲀϪⲞⲔⲢⲞⲨ ϨⲚ ⲦⲤⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ⲚⲀⲚⲞⲨⲠⲈϨⲘⲞⲨ ⲈⲢϢⲀⲚⲠⲈϨⲘⲞⲨ ⲆⲈ ⲂⲀⲀⲂⲈ ⲈⲦⲈⲦⲚⲀϪⲞⲔⲢⲈϤ ϨⲚ ⲞⲨ. ⲔⲀϨⲘⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲚⲦⲈⲦⲚⲢⲈⲒⲢⲎⲚⲎ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲚⲦⲞϢ ⲚϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲠⲈⲔⲢⲞ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲀⲠⲘⲎⲎϢⲈ ⲞⲚ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲀⲨⲰ ⲔⲀⲦⲀⲐⲈ ⲈϢⲀϤⲀⲀⲤ ⲀϤϮⲤⲂⲰ ⲞⲚ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ⲀⲨϪⲚⲞⲨϤ - ϪⲈ ⲈⲚⲈⲈⲜⲈⲤⲦⲈⲒ ⲘⲠⲢⲰⲘⲈ ⲈⲚⲈϪⲦⲈϤⲤϨⲒⲘⲈ ⲈⲂⲞⲖ. ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈ ⲚⲦⲀⲘⲰⲨⲤⲎⲤ ϨⲞⲚϤ ⲈⲦⲞⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲀⲘⲰⲨⲤⲎⲤ ϮⲐⲈ ⲚⲀⲚ ⲈϮⲞⲨϪⲰⲰⲘⲈ ⲚⲀⲨ ⲚⲦⲞⲨⲒⲞ ⲀⲨⲰ ⲈⲚⲞϪⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲢⲞⲤ ⲠⲈⲦⲚⲚϢⲞⲦⲚϨⲎⲦ ⲀⲘⲰⲨⲤⲎⲤ ⲤⲈϨⲦⲈⲒⲈⲚⲦⲞⲖⲎ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ϪⲒⲚⲦⲈϨⲞⲨⲒⲦⲈ ⲆⲈ ⲘⲠϤⲤⲰⲚⲦ. ⲞⲨϨⲞⲞⲨⲦ ⲚⲘⲞⲨⲤϨⲒⲘⲈ ⲀϤⲦⲀⲘⲒⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲢⲈⲠⲢⲰⲘⲈ ⲚⲀⲔⲀⲠⲈϤⲈⲒⲰⲦ ⲚⲤⲰϤ ⲚⲘⲦⲈϤⲘⲀⲀⲨ ⲚϤⲦⲰϬⲈ ⲘⲘⲞϤ ⲈⲦⲈϤⲤϨⲒⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ⲚⲤⲈϢⲰⲠⲈ ⲘⲠⲈⲤⲚⲀⲨ ⲈⲨⲤⲀⲢⲜ ⲞⲨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ⲠⲈⲚⲦⲀⲠⲚⲞⲨⲦⲈ ϬⲈ ⲀⲀϤ ⲚⲞⲨⲀ ⲚⲞⲨⲰⲦ ⲘⲠⲢⲦⲢⲈⲢⲰⲘⲈ ⲠⲞⲢϪϤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲈⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲞⲚ ⲀⲨϪⲚⲞⲨϤ ⲈⲠⲀⲒϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲚⲀⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲚϤϨⲘⲞⲞⲤ ⲚⲘⲔⲈⲦⲈ ⲈϤⲢⲚⲞⲈⲒⲔ ⲈϪⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ⲚⲦⲞⲤ ϨⲰⲰⲤ ⲈⲤϢⲀⲚⲔⲀ ⲠⲈⲤϨⲀⲈⲒ ⲚⲤⲰⲤ ⲚⲤϨⲘⲞⲞⲤ ⲚⲘⲔⲈⲨⲀ ⲤⲢⲚⲞⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ⲀⲨⲰ ⲀⲨⲈⲒⲚⲈ ⲚⲀϤ ⲚϨⲈⲚϢⲎⲢⲈ ⲔⲞⲨⲒ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲰⲞⲨ. ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲚⲞϢⲠⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲀϤϬⲚⲀⲦ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲔⲀⲚϢⲎⲢⲈ ⲔⲞⲨⲒ ⲈⲦⲢⲈⲨⲈⲒ ⲚⲀⲒ ⲀⲨⲰ ⲘⲠⲢⲚⲞϢⲠⲞⲨ ⲦⲀϨⲞⲒⲚⲈ ⲄⲀⲢ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲈⲚϤⲚⲀϢⲰⲠ ⲀⲚ ⲈⲢⲞϤ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲐⲈ ⲚⲞⲨϢⲎⲢⲈ ⲔⲞⲨⲒ ⲚⲚⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϢⲈⲠϢⲰⲠⲞⲨ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲈⲀϤⲔⲀⲦⲞⲞⲦϤ ϨⲒϪⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲈϨⲒⲎ ⲀⲞⲨⲀ ⲠⲰⲦ ⲀϤⲠⲀϨⲦϤ ϨⲒϨⲎ ⲘⲘⲞϤ ⲀⲨⲰ ⲀϤϪⲚⲞⲨϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲚⲀⲄⲀⲐⲞⲤ ⲞⲨ ⲠⲈϮⲚⲀⲀⲀϤ ϪⲈ ⲈⲒⲈⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀϨⲢⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲒ ϪⲈ ⲠⲀⲄⲀⲐⲞⲤ ⲘⲘⲚⲀⲄⲀⲐⲞⲤ ⲚⲤⲀⲠⲚⲞⲨⲦⲈ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ⲚⲈⲚⲦⲞⲖⲎ ⲔⲤⲞⲞⲨⲚ ⲘⲘⲞⲞⲨ ϪⲈ ⲘⲠⲢϨⲰⲦⲂ ⲘⲠⲢⲢⲚⲞⲈⲒⲔ ⲘⲠⲢϪⲒⲞⲨⲈ ⲘⲠⲢⲢⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲘⲠⲢϤⲰϬⲈ ⲦⲘⲀⲈⲒⲈ ⲠⲈⲔⲈⲒⲰⲦ ⲚⲘⲦⲈⲔⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ϪⲒⲚⲦⲀⲘⲚⲦⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀϤⲘⲈⲢⲒⲦϤ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔϢⲀⲀⲦ ⲚⲔⲈϨⲰⲂ ⲂⲰⲔ ⲚⲈⲦⲈⲨⲚⲦⲀⲔⲤⲈⲦⲀⲀⲨ ⲈⲂⲞⲖ ⲚⲄⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ ⲚⲄⲔⲀⲞⲨⲀϨⲞ ⲚⲀⲔ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ⲚⲄⲈⲒ ⲚⲄⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲰⲔⲘ ⲈϪⲘⲠϢⲀϪⲈ ⲀϤⲂⲰⲔ ⲈϤⲘⲞⲔϨ ⲚϨⲎⲦ ⲚⲈⲚⲀϢⲈⲚϬⲞⲞⲘ ⲄⲀⲢ ⲈⲦⲈⲨⲚⲦⲀϤⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲢⲈϤⲔⲦⲈⲒⲀⲦϤ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϤⲘⲞⲔϨ ⲚⲚⲈⲦⲈⲨⲚⲦⲞⲨ ⲬⲢⲎⲘⲀ ⲘⲘⲀⲨ ⲈⲦⲢⲈⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϢⲦⲞⲢⲦⲢ ⲈϪⲚ ⲚⲈϤϢⲀϪⲈ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲞⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲚⲀϢⲎⲢⲈ ⲈⲦⲂⲈ ⲞⲨ ⲤⲘⲞⲔϨ ⲚⲀⲨ ⲈⲦⲢⲈⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ⲤⲘⲞⲦⲚ ⲈⲦⲢⲈⲞⲨϬⲀⲘⲞⲨⲖ ⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲞⲨⲀⲦϤⲈ ⲚⲞⲨϨⲀⲘ ⲚⲦⲰⲠ ⲈϨⲞⲨⲈⲞⲨⲢⲘⲘⲀⲞ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϢⲦⲞⲢⲦⲢ ⲈⲠⲈϨⲞⲨⲞ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲨⲰ ⲚⲒⲘ ⲠⲈ ⲈⲦⲚⲀϢⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲀϨⲦⲈⲚⲢⲰⲘⲈ ⲚⲚⲈϢⲠⲀⲒ ϢⲰⲠⲈ. ⲀⲖⲖⲀ ϨⲀⲦⲈⲠⲚⲞⲨⲦⲈ ⲀⲚ. ⲞⲨⲚϬⲞⲘ ⲄⲀⲢ ⲈϨⲰⲂ ⲚⲒⲘ ϨⲀⲦⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ⲀϤⲀⲢⲬⲒ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲈϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲚ ⲀⲚⲔⲀⲚⲔⲀ ⲚⲒⲘ ⲚⲤⲰⲚ ⲀⲨⲰ ⲀⲚⲞⲨⲀϨⲚ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲘⲘⲚⲖⲀⲀⲨ ⲈⲀϤⲔⲀⲎⲒ ⲚⲤⲰϤ. ⲎⲤⲞⲚ ⲎⲤⲰⲚⲈ ⲎⲘⲀⲀⲨ ⲎⲈⲒⲰⲦ ⲎϢⲎⲢⲈ ⲎⲤⲰϢⲈ ⲈⲦⲂⲎⲦ ⲀⲨⲰ ⲈⲦⲂⲈ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ⲈⲚϤⲚⲀϪⲒⲦⲞⲨ ⲀⲚ ⲚϢⲈ ⲚⲔⲰⲂ ⲦⲈⲚⲞⲨ ϨⲘ ⲠⲈⲒⲞⲨⲞⲈⲒϢ ϨⲈⲚⲎⲈⲒ ⲘⲚϨⲈⲚⲤⲞⲚ ⲘⲚϨⲈⲚⲤⲰⲚⲈ ⲚⲘϨⲈⲚⲘⲀⲀⲨ ⲚⲘϨⲈⲚϢⲎⲢⲈ ⲘⲚϨⲈⲚⲤⲰϢⲈ ϨⲒϨⲈⲚⲆⲒⲰⲄⲘⲞⲤ ⲀⲨⲰ ⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϨⲘ ⲠⲀⲒⲰⲚ ⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ⲞⲨⲚϨⲀϨ ⲆⲈ ⲚϢⲞⲢⲠ ⲚⲀⲢϨⲀⲈ ⲀⲨⲰ ⲚⲦⲈⲚϨⲀⲈⲞⲨ ⲢϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ⲚⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ϨⲚ ⲦⲈϨⲒⲎ ⲈⲨⲚⲀ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ϨⲒϨⲎ ⲘⲘⲞⲞⲨ ⲚⲈⲦⲞⲨⲎϨ ⲆⲈ ⲚⲤⲰϤ ⲀⲐⲞⲦⲈ ϪⲒⲦⲞⲨ ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲞⲚ ⲈⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤⲀⲢⲬⲒ ⲚϪⲰ ⲈⲢⲞⲞⲨ ⲚⲚⲈⲦⲚⲀϢⲰⲠⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲚⲚⲀ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨⲰ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲤⲈⲦϬⲀⲒⲞϤ ⲈⲠⲘⲞⲨ. ⲀⲨⲰ ⲤⲈⲚⲀⲦⲀⲀϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚϨⲈⲐⲚⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ⲚⲤⲈⲤⲰⲂⲈ ⲚⲤⲰϤ ⲚⲤⲈⲚϪⲦⲀϤ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ. ⲚⲤⲈⲘⲀⲤⲦⲒⲄⲞⲨ ⲘⲘⲞϤ ⲚⲤⲈⲘⲞⲞⲨⲦϤ. ⲀⲨⲰ ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ϤⲚⲀⲦⲰⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ⲀⲨⲰ ⲀⲨϮⲠⲈⲨⲞⲨⲞⲈⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲠϢⲎⲢⲈ ⲤⲚⲀⲨ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲦⲚⲞⲨⲰϢ ϪⲈⲔⲀⲀⲤ ⲠⲈⲦⲚⲀⲀⲒⲦⲒ ⲘⲘⲞⲔ ⲘⲘⲘⲞϤ ⲚⲄⲀⲀϤ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲞⲨⲀϢϤ ⲈⲦⲢⲀⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲘⲀ ⲚⲀⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲞⲨⲀ ⲘⲘⲞⲚ ϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞⲔ ⲀⲨⲰ ⲔⲈⲨⲀ ⲚⲤⲀϨⲂⲞⲨⲢ ⲘⲘⲞⲔ ϨⲘ ⲠⲈⲔⲈⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲦⲈⲦⲚⲀⲒⲦⲒ ⲚⲞⲨ. ⲠⲀⲠⲞⲦ ⲀⲚⲞⲔ ⲈϮⲚⲀⲤⲞⲞϤ. ⲦⲈⲦⲚⲚⲀϢⲤⲞⲞϤ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲈϮⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲚϨⲎⲦϤ ⲦⲈⲦⲚⲚⲀϢϪⲒⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲤⲈ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲀⲠⲞⲦ ⲘⲈⲚ ⲈϮⲚⲀⲤⲞⲞϤ ⲦⲈⲦⲚⲀⲤⲞⲞϤ. ⲀⲨⲰ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲈϮⲚⲀϪⲒⲦϤ ⲦⲈⲦⲚⲚⲀϪⲒⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ⲈϨⲘⲞⲞⲤ ⲆⲈ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ⲎⲤⲀϨⲂⲞⲨⲢ ⲘⲘⲞⲒ ⲘⲠⲰⲒ ⲀⲚ ⲠⲈ ⲈⲦⲀⲀϤ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈ ⲚⲦⲀⲨⲤⲂⲦⲰⲦϤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲚϬⲒ ⲠⲘⲎⲦ ⲀⲨⲀⲢⲬⲒ ⲚϬⲚⲀⲦ ⲈⲦⲂⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲚⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲞ ⲚⲀⲢⲬⲰⲚ ⲈⲚϨⲈⲐⲚⲞⲤ ⲤⲈⲞ ⲘⲠⲈⲨϪⲞⲈⲒⲤ ⲀⲨⲰ ⲚⲈⲨⲚⲞϬ ⲤⲈⲞ ⲚⲦⲈⲨⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ⲚⲦⲀⲒ ⲆⲈ ⲀⲚ ⲦⲈ ⲐⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲀⲖⲖⲀ ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲈⲢⲚⲞϬ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈϤⲚⲀⲆⲒⲀⲔⲞⲚⲒ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲞⲨⲰϢ ⲈⲢϢⲞⲢⲠ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲈϤⲚⲀⲢϨⲘϨⲀⲖ ⲚⲎⲦⲚ ⲦⲎⲢⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ⲔⲀⲒⲄⲀⲢ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲦⲀϤⲈⲒ ⲀⲚ ⲈⲦⲢⲈⲨⲆⲒⲀⲔⲞⲚⲒ ⲚⲀϤ ⲀⲖⲖⲀ ⲈⲦⲢⲈϤⲆⲒⲀⲔⲞⲚⲒ. ⲀⲨⲰ ⲚϤϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲚⲤⲰⲦⲈ ϨⲀⲞⲨⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ⲀⲨⲰ ⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ϨⲒⲈⲢⲒⲬⲰ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲞⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ. ⲂⲀⲢⲦⲒⲘⲀⲒⲞⲤ ⲈⲨⲂⲖⲖⲈ ⲠⲈ ⲠϢⲎⲢⲈ ⲚⲦⲒⲘⲀⲒⲞⲤ ⲚⲈϤϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ϨⲀⲦⲈⲦⲈϨⲒⲎ ⲈϤϪⲒⲘⲚⲦⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲠⲚⲀⲌⲀⲢⲀⲒⲞⲤ. ⲀϤⲀⲢⲬⲒ ⲚϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ⲚⲀ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ⲀⲨⲰ ⲀⲨⲚⲞϢⲠϤ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ϪⲈ ⲈϤⲈⲔⲀⲢⲰϤ ⲚⲦⲞϤ ⲆⲈ ⲚϨⲞⲨⲞ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲚⲀ ⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲀϨⲈⲢⲀⲦϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲨ ⲈⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ. ⲀⲨⲰ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲠⲂⲖⲖⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲦⲰⲔ ⲚϨⲎⲦ ⲦⲰⲞⲨⲚ ϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲚⲈϪⲚⲈϤϨⲞⲒⲦⲈ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲀϤⲦⲰⲞⲨⲚϤ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲈⲒ ⲈⲢⲀⲦϤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲔⲞⲨⲀϢϤ ⲈⲦⲢⲀⲀⲀϤ ⲚⲀⲔ. ⲠⲂⲖⲖⲈ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲞⲨⲚⲈⲒ ⲈⲒⲞⲨⲰϢ ⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲂⲰⲔ ⲦⲈⲔⲠⲒⲤⲦⲒⲤ ⲀⲤⲚⲀϨⲘⲈⲔ. ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲚⲀⲨ ⲈⲂⲞⲖ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ϨⲚ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲂⲎⲦⲪⲀⲄⲎ ⲘⲚⲂⲎⲐⲀⲚⲒⲀ. ϨⲀϨⲦⲈⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ ⲀϤϪⲈⲨⲤⲚⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲔⲰⲘⲎ ⲈⲦϨⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲈⲦⲚⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ⲦⲈⲦⲚⲚⲀϨⲈ ⲈⲨⲤⲎϬ ⲈϤⲘⲎⲢ ⲈⲘⲠⲀⲦⲈⲖⲀⲀⲨ ⲢⲢⲰⲘⲈ ϨⲘⲞⲞⲤ ϨⲒϪⲰϤ ⲂⲞⲖϤ ⲚⲦⲈⲦⲚⲚⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ⲀⲨⲰ ⲈⲢϢⲀⲚⲖⲀⲀⲨ ϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ϪⲈ ⲈⲦⲈⲦⲚⲚⲀⲢⲞⲨ ⲘⲠⲀⲒ ⲀϪⲒⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲦⲦⲀϨⲈ ⲚⲀϤ. ⲀⲨⲰ ⲞⲚ ⲚⲦⲈⲨⲚⲞⲨ ϤⲚⲀⲦⲚⲚⲞⲞⲨϤ ⲞⲚ ⲈⲠⲈⲒⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ⲀⲨⲂⲰⲔ ⲆⲈ ⲀⲨⲰ ⲀⲨϨⲈ ⲈⲠⲤⲎϬ ⲈϤⲘⲎⲢ ⲈⲨⲢⲞ ϨⲘ ⲪⲒⲢ ⲀⲨⲰ ⲀⲨⲂⲞⲖϤ ");
INSERT INTO copshc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ϨⲞⲒⲚⲈ ⲆⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ⲈⲦⲈⲦⲚⲢⲞⲨ ⲈⲦⲈⲦⲚⲂⲰⲖ ⲘⲠⲤⲎϬ. ");
INSERT INTO copshc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞⲤ ⲚⲀⲨ ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ⲀⲨⲚⲠⲤⲎϬ ⲆⲈ ⲈⲢⲀⲦϤ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲠⲢϢⲚⲈⲨϨⲞⲒⲦⲈ ϨⲒϪⲰϤ ⲀϤϨⲘⲞⲞⲤ ϨⲒϪⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ⲔⲈⲘⲎⲎϢⲈ ⲞⲚ ⲀⲨⲠⲢϢⲚⲈⲨϨⲞⲒⲦⲈ ϨⲚ ⲦⲈϨⲒⲎ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϢⲰⲰⲦ ⲚϨⲈⲚⲔⲖⲀⲆⲞⲤ ϨⲚ ⲚⲤⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ⲀⲨⲰ ⲚⲈⲦϨⲒϨⲎ ⲘⲘⲞϤ ⲘⲚ ⲚⲈⲦⲞⲨⲎϨ ⲚⲤⲰϤ. ⲚⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲰⲤⲀⲚⲚⲀ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲈⲦⲚⲎⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ⲤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲦⲘⲚⲦⲢⲢⲞ ⲈⲦⲚⲎⲨ ⲘⲠⲈⲚⲈⲒⲰⲦ ⲆⲀⲨⲈⲒⲆ. ⲰⲤⲀⲚⲚⲀ ϨⲚ ⲚⲈⲦϪⲞⲤⲈ ");
INSERT INTO copshc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲠⲈⲢⲠⲈ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲔⲦⲈⲒⲀⲦϤ ϨⲘ ⲠⲘⲀ ⲦⲎⲢϤ ⲈⲀⲢⲞⲨϨⲈ ⲎⲆⲎ ϢⲰⲠⲈ. ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲘⲚⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ⲀⲨⲰ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲚⲂⲎⲐⲀⲚⲒⲀ ⲀϤϨⲔⲞ ");
INSERT INTO copshc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲨⲂⲰ ⲚⲔⲚⲦⲈ ⲘⲠⲞⲨⲈ ⲈⲢⲈϨⲈⲚϬⲰⲂⲈ ϨⲒⲰⲰⲤ ⲀϤⲂⲰⲔ ⲈⲢⲀⲦⲤ ϪⲈ ⲘⲈϢⲀⲔ ⲈϤⲈϬⲚⲖⲀⲀⲨ ⲚϨⲎⲦⲤ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒ ⲘⲠϤϬⲚⲖⲀⲀⲨ ϨⲒⲰⲰⲤ ⲚⲤⲀϬⲰⲂⲈ ⲘⲘⲀⲦⲈ ⲚⲈⲠⲤⲎⲨ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲘⲠⲔⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲤ ϪⲈ ⲚⲚⲈⲖⲀⲀⲨ ϪⲒⲚ ⲘⲠⲈⲒⲚⲀⲨ ⲞⲨⲈⲘⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦⲈ. ⲀⲨⲰ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲨⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ⲀⲨⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ ⲀϤⲀⲢⲬⲈⲒ ⲚⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦϮ ⲈⲂⲞⲖ ⲘⲚ ⲚⲈⲦⲦⲞⲞⲨ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ⲚⲈⲦⲢⲀⲠⲈⲌⲀ ⲢⲢⲈϤϪⲒⲔⲞⲖⲨⲘⲂⲞⲚ. ⲀϤⲦⲀⲨⲞⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲀⲨⲰ ⲘⲘⲀ ⲚϨⲘⲞⲞⲤ ⲚⲚⲈⲦϮϬⲢⲞⲞⲘⲠⲈ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ⲈⲠϤⲔⲀⲖⲀⲀⲨ ⲈϪⲒⲤⲔⲈⲨⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ⲀⲨⲰ ⲚⲈϤϮⲤⲂⲰ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚϤⲤⲎϨ ⲀⲚ ϪⲈ ⲠⲀⲎⲒ ⲈⲨⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲎⲈⲒ ⲘⲠⲈϢⲖⲎⲖ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲀⲦⲈⲦⲚⲀⲀϤ ⲚⲤⲠⲎⲖⲀⲒⲞⲚ ⲚⲤⲞⲞⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ⲀⲨⲰ ⲀⲨⲤⲰⲦⲘ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲀⲨⲔⲰⲦⲈ ⲚⲤⲀⲐⲈ ⲘⲘⲞⲞⲨⲦϤ ⲚⲈⲨⲢϨⲞⲦⲈ ⲄⲀⲢ ϨⲎⲦϤ ⲠⲘⲎⲎϢⲈ ⲄⲀⲢ ⲦⲎⲢϤ ⲚⲈϤⲢϢⲠⲎⲢⲈ ⲈϪⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲢⲞⲨϨⲈ ϢⲰⲠⲈ ⲀϤⲢⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ⲚⲦⲈⲢⲞⲨⲠⲀⲢⲀⲄⲈ ⲆⲈ ϨⲦⲞⲞⲨ ⲀⲨⲚⲀⲨ ⲈⲦⲂⲚⲔⲚⲦⲈ ⲀⲤϢⲞⲞⲨⲈ ϪⲒⲚⲚⲈⲤⲚⲞⲨⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲢⲠⲘⲈⲈⲨⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲀⲚⲀⲨ ⲈⲦⲂⲚⲔⲚⲦⲈ ⲚⲦⲀⲔⲤϨⲞⲨⲰⲢⲤ ⲚⲦⲀⲤϢⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲔⲀⲦⲠⲒⲤⲦⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲚⲀϪⲞⲞⲤ ⲘⲠⲈⲒⲦⲞⲞⲨ ϪⲈ ⲠⲰⲰⲚⲈ ⲚⲄⲂⲰⲔ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲚϤⲦⲘⲢϨⲎⲦ ⲤⲚⲀⲨ ϨⲘ ⲠⲈϤϨⲎⲦ ⲀⲖⲖⲀ ⲚϤⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲠⲈⲦϤϪⲰ ⲘⲘⲞϤ ϤⲚⲀϢⲰⲠⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ⲈⲦⲂⲈ ⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲈⲦⲚⲚⲀϢⲖⲎⲖ ⲈⲢⲞⲞⲨ ⲈⲦⲈⲦⲚⲀⲒⲦⲒ ⲘⲘⲞⲞⲨ ⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲀⲦⲈⲦⲚϪⲒⲦⲞⲨ ⲀⲨⲰ ⲤⲈⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ⲀⲨⲰ ⲈⲦⲈⲦⲚϢⲀⲀϨⲈⲢⲀⲦ ⲦⲎⲚⲞⲨ ⲈϢⲖⲎⲖ ⲔⲰ ⲈⲂⲞⲖ ⲘⲠⲈⲦⲈⲨⲚⲦⲎⲦⲚϤ ⲈⲢⲰⲘⲈ. ϪⲈⲔⲀⲀⲤ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲈϤⲈⲔⲰ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","— ");
INSERT INTO copshc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ⲀⲨⲈⲒ ⲞⲚ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲈϤⲘⲞⲞϢⲈ ϨⲘ ⲠⲈⲢⲠⲈ. ⲀⲨϮⲠⲈⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲚⲀⲒ ⲈⲔⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ. ⲎⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤϮ ⲚⲀⲔ ⲚⲦⲈⲒⲈⲜⲞⲨⲤⲒⲀ ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲢⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϮⲚⲀϪⲚⲞⲨⲦⲚ ϨⲰ ⲈⲨϢⲀϪⲈ ⲀϪⲒϤ ⲈⲢⲞⲈⲒ ⲠⲈ. ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲈⲒⲢⲈ ⲚⲚⲀⲒ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠⲈ. ϪⲚⲞⲨⲈⲂⲞⲖ ϨⲚ ⲢⲢⲰⲘⲈ ⲀϪⲒⲤ ⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ⲀⲨⲰ ⲀⲨⲘⲈⲔⲘⲞⲨⲔⲞⲨ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠⲈ. ϤⲚⲀϪⲞⲞⲤ ⲚⲀⲚ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲘⲠⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ⲀⲖⲖⲀ ⲦⲀⲢⲚϪⲞⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲢⲢⲰⲘⲈ ⲚⲈⲨⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲘⲎⲎϢⲈ. ⲈⲢⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲚⲦⲞⲞⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲚⲦⲰⲤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ⲀⲨⲰ ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲚⲞⲔ ϨⲰ ⲚϮⲚⲀϪⲞⲞⲤ ⲀⲚ ⲚⲎⲦⲚ ϪⲈ ⲚⲀⲒ ⲈⲒⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ⲀⲨⲰ ⲀϤⲀⲢⲬⲈⲒ ⲚϪⲞⲞⲤ ⲚⲀⲨ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲠⲈ ⲚⲦⲀϤⲦⲰϬⲈ ⲚⲞⲨⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ⲀϤⲔⲦⲞ ⲈⲢⲞϤ ⲚⲞⲨϪⲞ ⲀϤϢⲀⲔⲦⲞⲨⲈⲒⲞⲘ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲀϤⲔⲰⲦ ⲚⲞⲨⲠⲨⲢⲄⲞⲤ ⲀϤⲦⲀⲀϤ ⲈⲦⲞⲞⲦⲞⲨ ⲚϨⲈⲚϬⲘⲎⲞⲨ ⲀϤⲀⲠⲞⲆⲎⲘⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ⲀⲨⲰ ⲀϤϪⲈⲨⲞⲨϨⲘϨⲀⲖ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲈϬⲘⲎⲞⲨ ϨⲘ ⲠⲔⲀⲒⲢⲞⲤ ⲚⲚⲔⲀⲢⲠⲞⲤ ϪⲈ ⲈϤⲈϪⲒ ⲚⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϬⲘⲎⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲚⲔⲀⲢⲠⲞⲤ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ ⲀⲨϪⲞⲞⲨϤ ⲈⲘⲠⲞⲨϮⲖⲀⲀⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ⲀϤϪⲈⲨⲔⲈϨⲘϨⲀⲖ ⲞⲚ ⲈⲢⲀⲦⲞⲨ. ⲠⲔⲈⲞⲨⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲘⲞⲞⲨⲦϤ. ⲀⲨⲰ ⲀⲨⲤⲞϢϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ⲀϤϪⲈⲨⲔⲈⲞⲨⲀ ⲀⲨⲰ ⲠⲔⲈⲦ ⲀⲨⲘⲞⲞⲨⲦϤ ⲘⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲦⲎⲢⲞⲨ ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲈⲨϨⲒⲞⲨⲈ ⲈⲢⲞⲞⲨ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲈⲨⲘⲞⲞⲨⲦ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ⲈⲦⲒ ⲚⲈⲨⲚⲦϤⲞⲨϢⲎⲢⲈ ⲘⲘⲀⲨ ⲘⲘⲈⲢⲒⲦ ⲀϤϪⲞⲞⲨϤ ⲈⲢⲀⲦⲞⲨ. ⲘⲚⲚⲤⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲚⲀϢⲒⲠⲈ ϨⲎⲦϤ ⲘⲠⲀϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ⲚⲈϬⲘⲎⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲨϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ. ⲀⲘⲎⲒⲦⲚ ⲚⲦⲚⲘⲞⲞⲨⲦϤ. ⲀⲨⲰ ⲦⲈⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ⲚⲀⲢⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ⲚⲦⲈⲢⲞⲨⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲘⲞϤ ⲀⲨⲘⲞⲞⲨⲦϤ ⲀⲨⲰ ⲀⲨⲚⲞϪϤ ⲈⲠⲂⲞⲖ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ⲞⲨ ⲠⲈⲦⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚⲀⲀⲀϤ. ϤⲚⲎⲨ ⲚϤⲦⲀⲔⲈⲚⲈϬⲘⲎⲨ ⲚϤϮ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚϨⲈⲚⲔⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ⲦⲈⲒⲄⲢⲀⲪⲎ ⲆⲈ ⲞⲚ ⲘⲠⲈⲦⲚⲞϢⲤ. ϪⲈ ⲠⲰⲚⲈ ⲚⲦⲀⲚⲈⲦⲔⲰⲦ ⲤⲦⲞϤ ⲈⲂⲞⲖ ⲀϤϢⲰⲠⲈ ⲈⲨⲀⲠⲈ ⲚⲔⲞⲞϨ. ");
INSERT INTO copshc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ⲚⲦⲀⲠⲀⲒ ϢⲰⲠⲈ ϨⲒⲦⲞⲞⲦϤ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲞⲨϢⲠⲎⲢⲈ ⲠⲈ ⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ⲀⲨⲞⲨⲰϢ ⲆⲈ ⲈⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲘⲎⲎϢⲈ. ⲀⲨⲈⲒⲘⲈ ⲄⲀⲢ ϪⲈ ⲚⲦⲀϤϪⲈ ⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲦⲂⲎⲎⲦⲞⲨ. ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲔⲀⲀϤ ⲀⲨⲂⲰⲔ ");
INSERT INTO copshc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ⲀⲨⲰ ⲀⲨϪⲈⲨϨⲞⲒⲚⲈ ⲈⲢⲀⲦϤ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚⲚϨⲎⲢⲰⲆⲒⲀⲚⲞⲤ ⲈⲦⲢⲈⲨϬⲞⲠϤ ϨⲚ ⲞⲨϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϮ ⲠⲈⲨⲞⲨⲞⲈⲒ ⲈⲢⲞϤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲔⲞⲨⲢⲘ ⲘⲘⲈ ⲀⲨⲰ ⲚⲄϨⲎϬⲈ ⲀⲚ ϨⲎⲦϤ ⲖⲖⲀⲀⲨ ⲚⲄϪⲒϨⲞ ⲄⲀⲢ ⲀⲚ ⲢⲢⲰⲘⲈ ⲀⲖⲖⲀ ϨⲚ ⲞⲨⲘⲈ ⲈⲔϮⲤⲂⲰ ⲚⲦⲈϨⲒⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲜⲈⲤⲦⲒ ⲈϮⲔⲎⲚⲤⲞⲤ ⲘⲠⲢⲢⲞ ϪⲚⲘⲘⲞⲚ ⲦⲀⲢⲚϮ ϪⲚⲘⲠⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ⲚⲦⲞϤ ⲆⲈ ⲈϤⲤⲞⲞⲨⲚ ⲚⲦⲈⲨϨⲨⲠⲞⲔⲢⲒⲤⲒⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞⲒ ⲀⲚⲒⲞⲨⲤⲀⲦⲈⲈⲢⲈ ⲚⲀⲒ ϪⲈ ⲈⲒⲈⲚⲀⲨ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ⲚⲦⲞⲞⲨ ⲆⲈ ⲤⲞⲨⲦⲰⲚⲤ ⲈⲢⲞϤ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲀⲚⲒⲘ ⲦⲈ ⲦⲈⲈⲒϨⲒⲔⲰⲚ ⲘⲚ ⲚⲈⲒⲤϨⲀⲒ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲦⲀⲠⲢⲢⲞ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϮⲚⲀⲠⲢⲢⲞ ϬⲈ ⲘⲠⲢⲢⲞ ⲀⲨⲰ ⲚⲀⲠⲚⲞⲨⲦⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ⲀⲨⲈⲒ ⲆⲈ ϢⲀⲢⲞϤ ⲚϬⲒ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲚⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲚⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲀϢⲰⲠⲈ. ⲀⲨⲰ ⲀⲨϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ϪⲈ ⲠⲤⲀϨ ⲘⲰⲨⲤⲎⲤ ⲀϤⲤϨⲀⲒ ⲚⲀⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲈⲢϢⲀⲚⲠⲤⲞⲚ ⲞⲨⲀ ⲘⲞⲨ ⲀⲨⲰ ⲚϤⲔⲀⲦⲈϤⲤϨⲒⲘⲈ ⲚϤⲦⲘⲔⲀϢⲎⲢⲈ ⲆⲈ ⲈⲢⲈⲠⲈϤⲤⲞⲚ ϪⲒⲦⲈϤⲤϨⲒⲘⲈ ⲚϤⲦⲞⲨⲚⲞⲤⲤⲠⲈⲢⲘⲀ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ⲚⲈⲨⲚⲤⲀϢϤ ⲆⲈ ⲚⲤⲞⲚ ⲀⲨⲰ ⲠϢⲞⲢⲠ ⲀϤϪⲒϨⲒⲘⲈ. ⲀⲨⲰ ⲀϤⲘⲞⲨ ⲘⲠϤⲔⲀⲤⲠⲈⲢⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ⲀⲨⲰ ⲠⲘⲈϨⲤⲚⲀⲨ ⲀϤϪⲒⲦⲤ ⲀⲨⲰ ⲀϤⲘⲞⲨ ⲈⲘⲠϤⲔⲀⲤⲠⲈⲢⲘⲀ. ⲀⲨⲰ ⲠⲘⲈϨϢⲞⲘⲚⲦ ϨⲞⲘⲞⲒⲰⲤ ");
INSERT INTO copshc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ϢⲀⲠⲘⲈϨⲤⲀϢϤ. ⲈⲘⲠⲈⲖⲀⲀⲨ ⲘⲘⲞⲞⲨ ⲔⲀⲤⲠⲈⲢⲘⲀ. ⲀⲨⲰ ⲦⲔⲈⲤϨⲒⲘⲈ ⲀⲤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϬⲈ ⲈⲤⲚⲀⲢⲤϨⲒⲘⲈ ⲚⲚⲒⲘ ⲘⲘⲞⲞⲨ. ⲠⲤⲀϢϤ ⲄⲀⲢ ⲀⲨϨⲘⲞⲞⲤ ⲚⲘⲘⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲚ ϬⲈ ⲈⲦⲈⲦⲚⲠⲖⲀⲚⲀ ⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲚⲈⲄⲢⲀⲪⲎ ⲞⲨⲆⲈ ⲦϬⲞⲘ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ⲈⲨϢⲀⲚⲦⲰⲞⲨⲚ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲞⲨⲦⲈ ⲚⲤⲈⲚⲀϪⲒϨⲒⲘⲈ ⲀⲚ. ⲞⲨⲦⲈ ⲚⲤⲈⲚⲀϪⲒϨⲀⲒ ⲀⲚ. ⲀⲖⲖⲀ ⲈⲨⲚⲀϬⲰ ⲚⲐⲈ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲦϨⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ⲈⲦⲂⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲆⲈ ϪⲈ ⲤⲈⲚⲀⲦⲰⲞⲨⲚ ⲘⲠⲈⲦⲚⲰϢ ϨⲘ ⲠϪⲰⲰⲘⲈ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲐⲈ ⲈⲚⲦⲀⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲤ ⲚⲀϤ ϨⲒⲠⲂⲀⲦⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲤⲀⲀⲔ ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ⲠⲚⲞⲨⲦⲈ ⲀⲚ ⲠⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲖⲖⲀ ⲚⲚⲈⲦⲞⲚϨ. ⲦⲈⲦⲚⲠⲖⲀⲚⲀ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨⲀ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲀϤⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲈⲨϮⲦⲰⲚ ⲈϤⲤⲞⲞⲨⲚ ϪⲈ ⲀϤⲢⲞⲨⲰ ⲚⲀⲨ ⲔⲀⲖⲰⲤ. ⲀϤϪⲚⲞⲨϤ ϪⲈ ⲀϢ ⲦⲈ ⲦϢⲞⲢⲠ ⲚⲈⲚⲦⲞⲖⲎ ⲈⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦϢⲞⲢⲠ ⲦⲈ ⲤⲰⲦⲘ ⲠⲒⲤⲢⲀⲎⲖ ⲠϪⲞⲈⲒⲤ ⲠⲈⲚⲚⲞⲨⲦⲈ ⲠϪⲞⲈⲒⲤ ⲞⲨⲀ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ⲀⲨⲰ ⲈⲔⲈⲘⲈⲢⲈⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔϨⲎⲦ ⲦⲎⲢϤ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲘⲈⲨⲈ ⲦⲎⲢϤ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔϬⲞⲘ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ⲦⲘⲈϨ ⲤⲚⲦⲈ ⲆⲈ ⲦⲈ ⲦⲀⲒ ⲈⲔⲈⲘⲈⲢⲈ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲚⲦⲈⲔϨⲈ. ⲘⲘⲚ ⲔⲈⲈⲚⲦⲞⲖⲎ ⲈⲚⲀⲀⲤ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϬⲒ ⲠⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠⲤⲀϨ ϨⲚ ⲞⲨⲘⲈ ⲀⲔϪⲞⲞⲤ ϪⲈ ⲞⲨⲀ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲘⲘⲚϬⲈ ⲂⲂⲖⲖⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ⲀⲨⲰ ⲈⲘⲈⲢⲒⲦϤ ϨⲘ ⲠϨⲎⲦ ⲦⲎⲢϤ ⲀⲨⲰ ϨⲚ ⲦⲘⲚⲦⲢⲘⲚϨⲎⲦ ⲦⲎⲢⲤ ⲀⲨⲰ ϨⲚ ⲦⲈⲔϬⲞⲘ ⲦⲎⲢⲤ ⲀⲨⲰ ⲈⲘⲈⲢⲈⲠⲈⲦϨⲒⲦⲞⲨⲰϤ ⲚⲦⲈϤϨⲈ ⲞⲨϨⲞⲨⲞ ⲠⲈ ⲈⲚⲞⲖⲞⲔⲀⲨⲦⲰⲘⲀ ⲦⲎⲢⲞⲨ ⲘⲚⲚⲐⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲢⲞϤ ϪⲈ ⲀϤⲢⲞⲨⲰ ϨⲀⲢⲰϤ ϨⲚ ⲞⲨⲘⲚⲦⲢⲘⲚϨⲎⲦ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲄⲞⲨⲎⲨ ⲀⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲘⲠⲈϢⲖⲀⲀⲨ ϬⲈ ⲦⲞⲖⲘⲀ ⲈϪⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϮⲤⲂⲰ ϨⲘ ⲠⲈⲢⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ⲚⲦⲞϤ ⲆⲀⲨⲈⲒⲆ ⲀϤϪⲞⲞⲤ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϪⲈ ⲠⲈϪⲈⲠϪⲞⲈⲒⲤ ⲘⲠⲀϪⲞⲈⲒⲤ ϪⲈ ϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ϢⲀⲚϮⲔⲰ ⲚⲚⲈⲔϪⲀϪⲈⲈⲨ ϨⲀⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ⲚⲦⲞϤ ⲆⲀⲨⲈⲒⲆ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ. ⲀⲨⲰ ⲚⲀϢ ⲚϨⲈ ⲠⲈϤϢⲎⲢⲈ ⲠⲈ. ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲈⲨⲤⲰⲦⲘ ⲈⲢⲞϤ ⲔⲀⲖⲰⲤ ");
INSERT INTO copshc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϨⲚ ⲦⲈϤⲤⲂⲰ. ϪⲈ ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲈⲦⲞⲨⲰϢ ⲈⲘⲞⲞϢⲈ ϨⲚ ϨⲈⲚⲤⲦⲞⲖⲎ ⲀⲨⲰ ⲈⲨⲈϢⲚⲀⲤⲠⲀⲤⲘⲞⲤ ϨⲚ ⲚⲀⲄⲞⲢⲀ ");
INSERT INTO copshc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ⲀⲨⲰ ⲘⲘⲀ ⲚϨⲘⲞⲞⲤ ⲈⲦϪⲞⲤⲈ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ. ⲀⲨⲰ ⲘⲘⲀ ⲚⲚⲞϪⲞⲨ ⲈⲦϪⲞⲤⲈ ϨⲚ ⲚⲆⲈⲒⲠⲚⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ⲈⲨⲞⲨⲰⲘ ⲚⲚⲎⲈⲒ ⲚⲚⲈⲬⲎⲢⲀ. ⲀⲨⲰ ϨⲚ ⲞⲨⲖⲞⲒϬⲈ ⲈⲨⲰⲤⲔ ⲈⲨϢⲖⲎⲖ. ⲚⲀⲒ ⲤⲈϪⲒ ⲚⲞⲨⲔⲢⲒⲘⲀ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲘⲞⲞⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ. ⲀϤϮϨⲦⲎϤ ϪⲈ ⲈⲢⲈⲠⲘⲎⲎϢⲈ ⲚⲈϪϨⲞⲘⲚⲦ ⲚⲀϢ ⲚϨⲈ ⲈⲠⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲀⲨⲰ ⲞⲨⲘⲎⲎϢⲈ ⲚⲢⲘⲘⲀⲞ ⲚⲈⲨⲚⲞⲨϪϨⲀϨ ⲈϨⲢⲀⲒ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ⲚⲦⲈⲢⲈⲤⲈⲒ ⲆⲈ ⲚϬⲒ ⲞⲨⲬⲎⲢⲀ ⲚϨⲎⲔⲈ ⲀⲤⲚⲞⲨϪⲈ ⲈϨⲢⲀⲒ ⲈⲢⲞϤ ⲖⲖⲈⲠⲦⲞⲚ ⲤⲚⲀⲨ ⲈⲦⲈⲞⲨⲔⲞⲆⲢⲀⲚⲦⲎⲤ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲒⲬⲎⲢⲀ ⲚϨⲎⲔⲈ ⲀⲤⲚⲞⲨϪⲈ ⲈⲠⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲈϨⲞⲨⲈ ⲚⲈⲦⲚⲞⲨϪⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲦⲀⲨⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϨⲞⲨⲞ ⲈⲦϢⲞⲞⲠ ⲚⲀⲨ. ⲦⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲈⲤϢⲰⲰⲦ ⲠⲈⲤⲂⲒⲞⲤ ⲦⲎⲢϤ ⲈⲦⲈⲨⲚⲦⲀⲤϤ ⲀⲤⲦⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ⲀⲨⲰ ⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ ⲠⲈϪⲈⲞⲨⲀ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲤⲀϨ ⲀⲚⲀⲨ ⲈⲚⲈⲒⲰⲚⲈ ϪⲈ ϨⲈⲚⲀϢ ⲚϨⲈ ⲚⲈ. ⲘⲚ ⲚⲈⲒⲔⲈⲔⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲄⲚⲀⲨ ⲀⲚ ⲈⲚⲈⲒⲚⲞϬ ⲚⲔⲰⲦ ⲚⲚⲈⲨⲔⲰ ⲘⲠⲈⲒⲘⲀ ⲚⲞⲨⲰⲚⲈ ⲈϪⲚ ⲞⲨⲰⲚⲈ ⲈⲘⲠⲞⲨⲂⲞⲖⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ⲀⲨⲰ ⲈϤϨⲘⲞⲞⲤ ϨⲒϪⲚ ⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲈⲢⲠⲈ. ⲀϤϪⲚⲞⲨϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲚⲀⲚⲆⲢⲈⲀⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ϪⲈ ⲀϪⲒⲤ ⲚⲀⲚ ϪⲈ ⲈⲢⲈⲚⲀⲒ ⲚⲀϢⲰⲠⲈ ⲦⲚⲀⲨ. ⲀⲨⲰ ⲞⲨ ⲠⲈ ⲠⲘⲀⲈⲒⲚ ⲈⲢϢⲀⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲞⲨ ⲈϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲀⲢⲬⲒ ⲚϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ϮϨⲦⲎⲦⲚ ⲘⲎⲠⲰⲤ ⲚⲦⲈⲖⲀⲀⲨ ⲠⲖⲀⲚⲀ ⲘⲘⲰⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ⲞⲨⲚϨⲀϨ ⲄⲀⲢ ⲚⲀⲈⲒ ϨⲘ ⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲰ ⲤⲈⲚⲀⲠⲖⲀⲚⲀ ⲚⲞⲨⲘⲎⲎϢⲈ ");
INSERT INTO copshc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ⲈⲦⲈⲦⲚϢⲀⲚⲤⲰⲦⲘ ⲆⲈ ⲈϨⲈⲚⲠⲞⲖⲈⲘⲞⲤ ⲚⲘϨⲈⲚϨⲢⲞⲨ ⲘⲠⲞⲖⲈⲘⲞⲤ ⲘⲠⲢϢⲦⲞⲢⲦⲢ ⲤⲈⲚⲀϪⲠⲒϢⲰⲠⲈ ⲀⲖⲖⲀ ⲘⲠⲀⲦⲈⲐⲀⲎⲚⲞⲨ ⲈϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ⲞⲨⲚⲞⲨϨⲈⲐⲚⲞⲤ ⲚⲀⲦⲰⲞⲨⲚ ⲈϪⲚ ⲞⲨϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲞⲨⲘⲚⲦⲢⲢⲞ ⲈϪⲚ ⲞⲨⲘⲚⲦⲢⲢⲞ ⲀⲨⲰ ⲞⲨⲚϨⲈⲚϨⲈⲂⲰⲰⲚ ⲚⲀϢⲰⲠⲈ. ⲚⲀⲒ ⲆⲈ ⲦⲀⲢⲬⲎ ⲦⲈ ⲚⲚⲚⲀⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ⲚⲦⲰⲦⲚ ⲆⲈ ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ. ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲄⲀⲢ ⲘⲘⲰⲦⲚ ⲈⲚⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲚⲤⲈϨⲒⲞⲨⲈ ⲈⲢⲰⲦⲚ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲤⲈϪⲒⲦⲎⲨⲦⲚ ⲈⲚϨⲎⲄⲈⲘⲰⲚ ⲘⲚ ⲚⲈⲢⲢⲰⲞⲨ ⲈⲦⲂⲎⲎⲦ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ ⲘⲚⲚⲔⲈϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ⲀⲨⲰ ⲤⲈⲚⲀϪⲠⲒⲔⲎⲢⲨⲤⲤⲈ ⲚϢⲞⲢⲠ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ⲀⲨⲰ ⲈⲨϢⲀⲚϪⲒ ⲦⲎⲚⲞⲨ ⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲰⲦⲚ ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚ ⲚⲀϪⲞⲞϤ ⲀⲖⲖⲀ ⲠⲈⲦⲞⲨⲚⲀⲦⲀⲀϤ ⲈⲦⲈⲦⲚⲦⲀⲠⲢⲞ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲠⲀⲒ ⲠⲈ ⲈⲦⲈⲦⲚⲚⲀϪⲞⲞϤ ⲚⲦⲰⲦⲚ ⲄⲀⲢ ⲀⲚ ⲚⲈⲦϢⲀϪⲈ ⲀⲖⲖⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲠⲈ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ⲀⲨⲰ ⲞⲨⲚⲞⲨⲤⲞⲚ ⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲚⲞⲨⲤⲞⲚ ⲈϨⲢⲀⲒ ⲈⲠⲘⲞⲨ. ⲀⲨⲰ ⲞⲨⲈⲒⲰⲦ ϤⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲚⲞⲨϢⲎⲢⲈ ⲚϢⲎⲢⲈ ⲚⲀⲦⲰⲞⲨⲚ ⲈϪⲚ ⲚⲈⲨⲈⲒⲞⲦⲈ ⲚⲤⲈⲘⲞⲞⲨⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ⲚⲦⲈⲦⲚϢⲰⲠⲈ ⲈⲢⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ ⲠⲈⲦⲚⲀϨⲨⲠⲞⲘⲒⲚⲈ ⲆⲈ ϢⲀⲂⲞⲖ ⲠⲀⲒ ⲠⲈⲦⲚⲀⲞⲨϪⲀⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲆⲈ ⲈⲦⲂⲞⲦⲈ ⲘⲠϢⲰϤ ⲈⲤⲀϨⲈⲢⲀⲦⲤ ⲘⲠⲘⲀ ⲈⲦⲈⲚϢϢⲈ ⲀⲚ. ⲠⲈⲦⲰϢ ⲘⲀⲢⲈϤⲚⲞⲒ ⲦⲞⲦⲈ ⲚⲈⲦϨⲚϮⲞⲨⲆⲀⲒⲀ ⲘⲀⲢⲞⲨⲠⲰⲦ ⲈⲚⲦⲞⲨⲒⲎ ");
INSERT INTO copshc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ⲠⲈⲦϨⲒϪⲈⲚⲈⲠⲰⲢ ⲘⲠⲢⲦⲢⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲆⲈ ⲘⲠⲢⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈϤⲒⲖⲀⲀⲨ ϨⲘ ⲠⲈϤⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ⲀⲨⲰ ⲠⲈⲦϨⲚⲦⲤⲰϢⲈ ⲘⲠⲢⲦⲢⲈϤⲔⲞⲦϤ ⲈⲠⲀϨⲞⲨ ⲈϤⲒⲠⲈϤϨⲞⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲈⲦⲈⲈⲦ ⲘⲚ ⲚⲈⲦⲦⲤⲚⲔⲞ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ϢⲖⲎⲖ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲠⲈⲦⲚⲠⲰⲦ ϢⲰⲠⲈ ⲚⲦⲈⲠⲢⲰ. ");
INSERT INTO copshc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ⲤⲈⲚⲀϢⲰⲠⲈ ⲄⲀⲢ ⲚϬⲒ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲞⲨⲐⲖⲒⲮⲒⲤ ⲦⲀⲒ ⲈⲦⲈⲘⲠⲈⲞⲨⲞⲚ ⲚⲦⲈⲤϬⲞⲦ ϢⲰⲠⲈ ϪⲒⲚⲦⲀⲢⲬⲎ ⲘⲠⲤⲰⲚⲦ ⲚⲦⲀⲠⲚⲞⲨⲦⲈ ⲤⲞⲚⲦϤ ϢⲀϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ ⲀⲨⲰ ⲘⲘⲚⲞⲨⲞⲚ ⲚⲦⲈⲤϬⲞⲦ ⲚⲀϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ⲀⲨⲰ ⲈⲚⲈⲘⲠⲈⲠϪⲞⲈⲒⲤ ⲦⲤⲂⲔⲈϨⲞⲞⲨ ⲚⲈⲘⲘⲚⲖⲀⲀⲨ ⲚⲤⲀⲢⲜ ⲚⲀⲰⲚϨ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲚⲤⲰⲦⲠ ⲚⲦⲀϤⲤⲞⲦⲠⲞⲨ ⲀϤⲦⲤⲂⲔⲈⲚⲈϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ⲀⲨⲰ ⲈⲢϢⲀⲚⲖⲀⲀⲨ ϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲒⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲠⲈⲒⲘⲀ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤϨⲚⲠⲒⲘⲀ ⲘⲠⲢⲠⲒⲤⲦⲈⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ⲤⲈⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲄⲀⲢ ⲚϬⲒ ϨⲈⲚⲬⲢⲒⲤⲦⲞⲤ ⲚⲚⲞⲨϪ ⲚⲘϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲚⲤⲈϮ ⲚϨⲈⲚⲘⲀⲒⲚ ⲚⲘϨⲈⲚϢⲠⲎⲢⲈ ⲈϢⲰⲠⲈ ⲈⲨⲚϬⲞⲘ ⲈⲠⲖⲀⲚⲀ ⲚⲚⲤⲰⲦⲠ ");
INSERT INTO copshc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ⲚⲦⲰⲦⲚ ⲆⲈ ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ⲀⲒϢⲢⲠϪⲰ ⲈⲢⲰⲦⲚ ⲚϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ⲀⲖⲖⲀ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲘⲚⲚⲤⲀ ⲦⲈⲐⲖⲒⲮⲒⲤ ⲈⲦⲘⲘⲀⲨ ⲠⲢⲎ ⲚⲀⲢⲈⲂⲎ. ⲀⲨⲰ ⲠⲞⲞϨ ⲚϤⲚⲀϮⲠⲈϤⲞⲨⲞⲒⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ⲀⲨⲰ ⲚⲤⲒⲞⲨ ⲤⲈⲚⲀϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ⲚϬⲞⲘ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲤⲈⲚⲀⲚⲞⲒⲚ ");
INSERT INTO copshc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ⲀⲨⲰ ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲎⲨ ϨⲚ ⲞⲨⲔⲖⲞⲞⲖⲈ ⲚⲘⲞⲨⲚⲞϬ ⲚϬⲞⲘ ⲀⲨⲰ ⲞⲨⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ⲀⲨⲰ ⲦⲞⲦⲈ ϤⲚⲀϪⲈⲨ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲚϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲈϤⲤⲰⲦⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲦⲞⲨⲦⲎⲨ. ϪⲒⲚϪⲰϤ ⲘⲠⲔⲀϨ ϢⲀϪⲰⲤ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ⲈⲂⲞⲖ ⲆⲈ ⲚⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ⲈⲦⲠⲀⲢⲀⲂⲞⲖⲎ. ⲈⲢϢⲀⲚⲠⲈⲤⲔⲖⲀⲆⲞⲤ ⲎⲆⲎ ⲖⲰⲔ ⲚⲦⲈⲚⲈⲤϬⲰⲂⲈ ϮⲞⲨⲰ ⲚϢⲀⲦⲈⲦⲚⲈⲒⲘⲈ ϪⲈ ⲀⲠϢⲰⲘ ϨⲰⲚ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ⲦⲀⲒ ϨⲰⲦⲦⲎⲨⲦⲚ ⲦⲈ ⲦⲈⲦⲚϨⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲨⲚⲀϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲚⲀⲒⲘⲈ ϪⲈ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ϨⲒⲢⲚⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈⲦⲈⲒⲄⲈⲚⲈⲀ ⲖⲞ ⲘⲘⲀⲨ ϢⲀⲚⲦⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ⲦⲠⲈ ⲚⲘⲠⲔⲀϨ ⲤⲈⲚⲀⲖⲞ ⲘⲘⲀⲨ ⲚⲀϢⲀϪⲈ ⲆⲈ ⲚⲤⲈⲚⲀⲖⲞ ⲘⲘⲀⲨ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ⲈⲦⲂⲈⲠⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲎⲦⲈⲨⲚⲞⲨ ⲘⲚⲖⲀⲀⲨ ⲤⲞⲞⲨⲚ ⲞⲨⲆⲈ ⲚⲀⲄⲄⲈⲖⲞⲤ ϨⲚ ⲦⲠⲈ. ⲞⲨⲆⲈ ⲠϢⲎⲢⲈ ⲚⲤⲀⲠⲈⲒⲰⲦ ⲘⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ϮϨⲦⲎⲦⲚ ⲚⲦⲈⲦⲚⲢⲞⲈⲒⲤ ⲀⲨⲰ ⲚⲦⲈⲦⲚϢⲖⲎⲖ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲀϢ ⲠⲈ ⲠⲈⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ⲚⲐⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲈϤⲚⲀⲀⲠⲞⲆⲎⲘⲈⲒ ⲈⲀϤⲔⲀⲠⲈϤⲎⲈⲒ ⲀⲨⲰ ⲀϤϮ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲚⲈϤϨⲘϨⲀⲖ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲈⲀϤϮ ⲚⲀϤ ⲘⲠⲈϤϨⲰⲂ. ⲀⲨⲰ ⲠⲈⲘⲚⲞⲨⲦ ⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲢⲞⲈⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ⲢⲞⲈⲒⲤ ϬⲈ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲈⲢⲈⲠϪⲞⲈⲒⲤ ⲘⲠⲎⲒ ⲚⲎⲨ ⲚⲀϢ ⲚⲚⲀⲨ ⲎⲢⲢⲞⲨϨⲈ ⲎϨⲚ ⲦⲠⲀϢⲈ ⲚⲦⲈⲨϢⲎ ⲎⲘⲠⲚⲀⲨ ⲈⲢⲈⲠⲀⲖⲈⲔⲦⲰⲢ ⲚⲀⲘⲞⲨⲦⲈ ⲎⲘⲠⲚⲀⲨ ⲚϨⲦⲞⲞⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ⲘⲎⲠⲰⲤ ⲚϤⲈⲒ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲚϤϨⲈ ⲈⲢⲰⲦⲚ ⲈⲦⲈⲦⲚⲞⲂϢ. ");
INSERT INTO copshc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲎⲦⲚ ϮϪⲰ ⲘⲘⲞϤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ϪⲈ ⲢⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ⲚⲈⲢⲈⲠⲠⲀⲤⲬⲀ ⲆⲈ ⲀⲨⲰ ⲠⲈϨⲞⲞⲨ ⲚⲚⲀⲐⲀⲂ. ⲚⲀϢⲰⲠⲈ ⲘⲘⲚⲚⲤⲀ ϨⲞⲞⲨ ⲤⲚⲀⲨ ⲀⲨⲰ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲈⲨⲔⲰⲦⲈ ⲚⲤⲀⲐⲈ ⲚϬⲞⲠϤ ϨⲚ ⲞⲨⲔⲢⲞϤ ⲚⲤⲈⲘⲞⲞⲨⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ⲀⲨϪⲞⲞⲤ ⲆⲈ ϪⲈ ϨⲘ ⲠϢⲀ ⲀⲚ ϪⲈ ⲚⲚⲈⲨϢⲦⲞⲢⲦⲢ ϢⲰⲠⲈ ϨⲘ ⲠⲖⲀⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ⲀⲨⲰ ⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲂⲎⲐⲀⲚⲒⲀ ⲈϤⲚⲎϪ ϨⲘ ⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲤⲞⲂϨ ⲀⲤⲈⲒ ⲚϬⲒ ⲞⲨⲤϨⲒⲘⲈ ⲈⲢⲈⲞⲨⲀⲖⲀⲂⲀⲤⲦⲢⲞⲚ ⲚⲤⲞϬⲚ ⲚⲦⲞⲞⲦⲤ ⲚⲚⲀⲢⲆⲞⲤ ⲈϤⲤⲞⲦⲠ ⲈⲚⲀϢⲈⲤⲞⲨⲚⲦⲤ ⲀⲤⲦⲀϨ ⲦⲀⲖⲀⲂⲀⲤⲦⲢⲞⲚ ⲆⲈ ⲀⲤⲠⲀϨⲦⲤ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ⲀϨⲞⲒⲚⲈ ⲆⲈ ϬⲚⲀⲦ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲠⲈⲒⲤⲞϬⲚ ⲀⲨⲦⲀⲔⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ⲚⲈⲨⲈϢⲦⲀⲀϤ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲀϨⲞⲨⲞ ⲈϢⲘⲦϢⲈ ⲚⲤⲀⲦⲈⲈⲢⲈ ⲚⲤⲈⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ. ⲀⲨⲰ ⲚⲈⲨϬⲞⲚⲦ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲖⲰⲦⲚ ϨⲀⲢⲞⲤ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲞⲨⲈϨϨⲒⲤⲈ ⲈⲢⲞⲤ ⲞⲨϨⲰⲂ ⲈⲚⲀⲚⲞⲨϤ ⲠⲈ ⲚⲦⲀⲤⲀⲀϤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ⲚϨⲎⲔⲈ ⲄⲀⲢ ⲚⲘⲘⲎⲦⲚ ⲞⲨⲞⲒϢ ⲚⲒⲘ ⲀⲨⲰ ⲈⲦⲈⲦⲚϢⲀⲚⲢ ϨⲚⲎⲦⲚ ⲈⲦⲈⲦⲚⲈϢ ⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲀⲨ ⲞⲨⲞⲒϢ ⲚⲒⲘ ⲀⲚⲞⲔ ⲆⲈ ⲚⲈⲒⲚⲀϬⲰ ⲀⲚ ⲚⲘⲘⲎⲦⲚ ⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ⲠⲈⲚⲦⲀϤⲢ ⲀⲦⲞⲞⲦⲤ ⲀⲤⲀⲀϤ ⲀⲤⲢϢⲞⲢⲠ ⲈⲦⲈϨⲤⲠⲀⲤⲰⲘⲀ ⲚⲤⲞϬⲚ ⲈⲠⲔⲞⲞⲤⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ϨⲀⲘⲎⲚ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲀϢⲈⲞⲒϢ ⲘⲠⲈⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚϨⲎⲦϤ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲤⲈⲚⲀϢⲀϪⲈ ⲈⲠⲈⲚⲦⲀⲦⲀⲒ ⲀⲀϤ ⲈⲨⲢⲠⲘⲈⲈⲨⲈ ⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ⲀⲨⲰ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲞⲨⲀ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤⲂⲰⲔ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈ ⲈϤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲀⲨⲢⲀϢⲈ ⲀⲨⲰ ⲀⲨⲈⲢⲎⲦ ⲚϨⲈⲚϨⲞⲘⲚⲦ ⲈⲦⲀⲀⲨ ⲚⲀϤ. ⲀⲨⲰ ⲀϤⲔⲰⲦⲈ ⲚⲤⲀⲞⲨⲈⲨⲔⲀⲒⲢⲒⲀ ⲈⲦⲂⲈ ⲐⲈ ⲚⲦⲀⲀϤ ⲈⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ⲀⲨⲰ ϨⲘ ⲠϢⲞⲢⲠ ⲚϨⲞⲞⲨ ⲚⲀⲦⲐⲀⲂ. ⲚⲦⲈⲢⲞⲨϢⲀⲀⲦ ⲠⲠⲀⲤⲬⲀ ⲠⲈϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ⲈⲔⲞⲨⲈϢⲦⲈⲚⲂⲰⲔ ⲈⲦⲰⲚ ⲈⲤⲂⲦⲈ ⲠⲠⲀⲤⲬⲀ ⲚⲀⲔ ϪⲈ ⲈⲔⲈⲞⲨⲞⲘϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ⲀϤϪⲈⲨ ⲤⲚⲀⲨ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ ⲀⲨⲰ ϤⲚⲀⲦⲰⲘⲚⲦ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲞⲨⲢⲰⲘⲈ ⲈⲢⲈⲞⲨϢⲞϢⲞⲨ ⲘⲘⲞⲞⲨ ϨⲒϪⲰϤ ⲞⲨⲀϨⲦⲎⲨⲚ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ⲀⲨⲰ ⲠⲘⲀ ⲈⲦϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲀϪⲒⲤ ⲘⲠϪⲞⲈⲒⲤ ⲘⲠⲎⲈⲒ ϪⲈ ⲠⲤⲀϨ ⲠⲈ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈⲠⲀⲘⲀ ⲚϬⲞⲒⲖⲈ ⲦⲰⲚ ⲠⲘⲀ ⲈϮⲚⲀⲞⲨⲰⲘ ⲠⲠⲀⲤⲬⲀ ⲘⲚⲚⲀⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ⲀⲨⲰ ⲚⲦⲞϤ ϤⲚⲀⲦⲤⲀⲂⲰⲦⲚ ⲈⲨⲚⲞϬ ⲘⲘⲀ ⲚⲦⲠⲈ ⲈϤⲠⲞⲢϢ ⲈϤⲤⲂⲦⲰⲦ ⲈⲦⲈⲦⲚⲚⲀⲤⲞⲂⲦⲈ ⲚⲀⲚ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ⲀⲨⲰ ⲀⲨⲘⲞⲞϢⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲂⲰⲔ ⲈⲦⲠⲞⲖⲒⲤ ⲀⲨϨⲈ ⲈⲠⲘⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲨ ⲀⲨⲰ ⲀⲨⲤⲞⲂⲦⲈ ⲘⲠⲠⲀⲤⲬⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ⲚⲦⲈⲢⲈⲢⲞⲨϨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀϤⲈⲒ ⲘⲚ ⲠⲈϤⲘⲚⲦⲤⲚⲞⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ⲀⲨⲰ ⲈⲨⲚⲎϪ ⲈⲨⲞⲨⲰⲘ ⲠⲈϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲚⲈⲦⲞⲨⲰⲘ ⲚⲘⲘⲀⲒ ⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ⲀⲨⲰ ⲀⲨⲀⲢⲬⲒ ⲚⲘⲔⲀϨ ⲚϨⲎⲦ ⲀⲨⲰ ⲈϪⲞⲞⲤ ⲚⲀϤ ⲞⲨⲀ ⲞⲨⲀ ϪⲈ ⲘⲎ ⲀⲚⲞⲔ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨⲀ ⲠⲈ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲠⲈⲦⲚⲀⲤⲠ ⲦⲞⲞⲦϤ ⲚⲘⲘⲀⲒ ϨⲚ ⲦϪⲎⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ϪⲈ ⲠϢⲎⲢⲈ ⲘⲈⲚ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲂⲰⲔ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀⲨⲤϨⲀⲒ ⲈⲦⲂⲎⲎⲦϤ. ⲞⲨⲞⲒ ⲆⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲠⲈⲦⲞⲨⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ⲚⲈⲚⲀⲚⲞⲨⲤ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲈⲘⲠⲞⲨϪⲠⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ⲀⲨⲰ ⲈⲨⲞⲨⲰⲘ ⲀϤϪⲒ ⲚⲞⲨⲞⲒⲔ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲀϤⲠⲞϢϤ ⲀⲨⲰ ⲀϤⲦⲀⲀϤ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϪⲒⲦϤ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲒ ⲚⲞⲨⲀⲠⲞⲦ ⲀϤϢⲠϨⲘⲞⲦ ⲈϪⲰϤ ⲀϤⲦⲀⲀϤ ⲚⲀⲨ ⲀⲨⲰ ⲀⲨⲤⲰ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲚⲞϤ ⲚⲦⲆⲒⲀⲐⲎⲔⲎ ⲈⲦⲞⲨⲚⲀⲠⲞⲚϤ ⲈⲂⲞⲖ ⲈϪⲚ ϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ϨⲀⲘⲎⲚ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲀⲤⲰ ϪⲒⲚ ⲘⲠⲈⲒⲚⲀⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲄⲈⲚⲎⲘⲀ ⲚⲦⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ ϢⲀⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ϨⲞⲦⲀⲚ ⲈⲒϢⲀⲚⲤⲞⲞϤ ⲈϤⲞ ⲂⲂⲢⲢⲈ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲤⲘⲞⲨ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ⲀⲨⲰ ⲠⲈϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲦⲎⲢⲦⲚ ⲦⲈⲦⲚⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ϪⲈ ϤⲤⲎϨ ϪⲈ ϮⲚⲀⲠⲀⲦⲀⲤⲤⲈ ⲘⲠϢⲰⲤ. ⲀⲨⲰ ⲚⲈⲤⲞⲞⲨ ⲤⲈⲚⲀϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ⲘⲚⲚⲤⲀ ⲦⲢⲀⲦⲰⲞⲨⲚ ⲆⲈ ϮⲚⲀⲢ ϢⲞⲢⲠ ⲈⲢⲰⲦⲚ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈϢϪⲈ ⲤⲈⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲦⲎⲢⲞⲨ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ⲠⲈϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲦⲞⲔ ⲘⲠⲞⲞⲨ ϨⲚ ⲦⲈⲒⲞⲨϢⲎ ⲈⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲚⲤⲈⲠⲤⲚⲀⲨ ⲔⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲘⲚⲦⲤⲰⲰⲠ ");
INSERT INTO copshc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲢϨⲀϨ ⲚϢⲀϪⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲤⲈⲒ ⲈⲦⲢⲀⲘⲞⲨ ⲚⲘⲘⲀⲔ ⲚϮⲚⲀⲀⲢⲚⲀ ⲘⲘⲞⲔ ⲀⲚ. ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲚⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲀⲨϪⲞⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ⲀⲨⲰ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲨϬⲰⲘ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲄⲈⲐⲤⲎⲘⲀⲚⲈⲒ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲘⲞⲞⲤ ⲚⲎⲦⲚ ⲘⲠⲈⲒⲘⲀ ϢⲀⲚϮϢⲖⲎⲖ ");
INSERT INTO copshc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ⲀⲨⲰ ⲀϤϪⲒ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚⲒⲀⲔⲰⲂⲞⲤ ⲘⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲀϤⲀⲢⲬⲒ ⲚϢⲦⲞⲢⲦⲢ ⲀⲨⲰ ⲈⲦⲰⲔⲘ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲖⲨⲠⲒ ϢⲀϨⲢⲀⲒ ⲈⲠⲘⲞⲨ ϬⲰ ⲚⲎⲦⲚ ⲘⲠⲈⲒⲘⲀ ⲚⲦⲈⲦⲚⲢⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈⲐⲎ ⲚⲞⲨⲔⲞⲨⲈⲒ. ⲀϤⲠⲀϨⲦϤ ⲈϪⲘⲠⲔⲀϨ ⲀϤϢⲖⲎⲖ. ϪⲈⲔⲀⲀⲤ ⲈϢⲰⲠⲈ ⲞⲨⲚϬⲞⲘ ⲚⲦⲈⲦⲈⲒⲞⲨⲚⲞⲨ ⲤⲀⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲂⲂⲀ ⲠⲒⲰⲦ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲔ ⲈϨⲰⲂ ⲚⲒⲘ ⲘⲀⲢⲈⲠⲈⲒⲀⲠⲞⲦ ⲤⲀⲀⲦ ⲀⲖⲖⲀ ⲚⲐⲈ ⲀⲚ ⲀⲚⲞⲔ ⲈϮⲞⲨⲀϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ⲀⲨⲰ ⲀϤⲈⲒ ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲞⲂϢ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲤⲒⲘⲰⲚ ⲈⲔⲚⲔⲞⲦⲔ ⲘⲠⲈⲔⲈϢⲢⲞⲈⲒⲤ ⲚⲞⲨⲞⲨⲚⲞⲨ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ⲢⲞⲈⲒⲤ ⲚⲦⲈⲦⲚϢⲖⲎⲖ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲈⲚ ⲢⲞⲞⲨⲦ ⲦⲤⲀⲢⲜ ⲞⲨⲀⲤⲐⲈⲚⲎⲤ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲞⲚ ⲀϤϢⲖⲎⲖ ⲈϤⲦⲀⲨⲞ ⲘⲠⲒϢⲀϪⲈ ⲚⲞⲨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ⲚⲦⲈⲢⲈϤⲈⲒ ⲞⲚ ϢⲀⲢⲞⲞⲨ ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲞⲂϢ. ⲚⲈⲢⲈⲚⲈⲨⲂⲀⲖ ⲄⲀⲢ ϨⲞⲢϢ ⲀⲨⲰ ⲚⲈⲨⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲨⲚⲀϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ⲀϤⲈⲒ ⲞⲚ ⲘⲠⲘⲈϨϢⲘⲦⲤⲰⲰⲠ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲔⲞⲦⲔ ⲦⲈⲚⲞⲨ ⲚⲦⲈⲦⲚⲘⲦⲞⲚ ⲘⲘⲰⲦⲚ ⲀⲠϨⲰⲂ ⲈⲒ ⲈⲂⲞⲖ ⲀⲦⲈⲨⲚⲞⲨ ⲈⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϨⲢⲀⲒ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲢⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ⲦⲞⲨⲚⲦⲎⲨⲦⲚ ⲘⲀⲢⲞⲚ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲒ ⲈϤϢⲀϪⲈ. ⲀϤⲈⲒ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲞⲨⲀ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲈⲢⲈⲞⲨⲘⲎⲎϢⲈ ⲚⲘⲘⲀϤ ⲚⲘϨⲈⲚⲤⲎϤⲈ ⲀⲨⲰ ϨⲈⲚϬⲈⲢⲰⲂ ⲚⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲆⲈ ⲘⲘⲞϤ ⲀϤϮ ⲚⲀⲨ ⲚⲞⲨⲘⲀⲒⲚ ϪⲈ ⲠⲈϮⲚⲀϮⲠⲒ ⲈⲢⲰϤ ⲚⲦⲞϤ ⲠⲈ ⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲚⲦⲈⲦⲚϪⲒⲦϤ ϨⲚ ⲞⲨⲰⲢϪ ");
INSERT INTO copshc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ — ϪⲈ ⲬⲀⲒⲢⲈ ϨⲢⲀⲂⲂⲈⲒ ⲀⲨⲰ ⲀϤϮⲠⲒ ⲈⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲚⲦⲞⲞⲦⲞⲨ ⲈϪⲰϤ ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ⲞⲨⲀ ⲆⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲀϤⲦⲈⲔⲘⲦⲈϤⲤⲎϤⲈ ⲀϤⲢⲈϨⲦⲠϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤⲤⲖⲠⲠⲈϤⲘⲀⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈϬⲞⲠⲦ ⲚⲐⲈ ⲚⲞⲨⲤⲞⲞⲚⲈ. ⲘⲚϨⲈⲚⲤⲎϤⲈ ⲀⲨⲰ ϨⲈⲚϬⲈⲢⲞⲞⲂ ");
INSERT INTO copshc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ⲚⲈⲒϨⲀϨⲦⲈⲦⲎⲨⲦⲚ ⲘⲘⲎⲚⲈ ϨⲘ ⲠⲈⲢⲠⲈ ⲈⲒϮⲤⲂⲰ ⲀⲨⲰ ⲘⲠⲈⲦⲚⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲒ ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲄⲢⲀⲪⲎ ");
INSERT INTO copshc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲔⲀⲀϤ ⲦⲎⲢⲞⲨ ⲀⲨⲠⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ⲞⲨϨⲢϢⲒⲢⲈ ⲆⲈ ⲚⲈϤⲞⲨⲎϨ ⲚⲤⲰϤ ⲈϤϬⲞⲞⲖⲈ ⲚⲞⲨⲤⲒⲚⲆⲰⲚ. ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲔⲀⲦⲤⲒⲚⲆⲰⲚ ⲈⲂⲞⲖ ⲚⲤⲰⲞⲨ ⲀϤⲠⲰⲦ ⲈϤⲔⲎⲔⲀϨⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ⲀⲨⲰ ⲀⲨϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲢⲀⲦϤ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲀⲨⲤⲰⲞⲨϨ ⲈⲢⲀⲦϤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ⲀⲨⲰ ⲠⲈⲦⲢⲞⲤ ⲚⲈϤⲞⲨⲎϨ ⲚⲤⲰϤ ⲘⲠⲞⲨⲈ. ϢⲀϨⲞⲨⲚ ⲈⲦⲀⲨⲖⲎ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ⲀⲨⲰ ⲚⲈϤϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ⲘⲚⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈϤⲐⲘⲞ ⲘⲘⲞϤ ϨⲀϨⲦⲈⲠⲔⲰϨⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲘⲚⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲦⲎⲢϤ ⲚⲈⲨⲔⲰⲦⲈ ⲚⲤⲀⲞⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲈϨⲞⲨⲚ ⲈⲒⲎⲤⲞⲨⲤ ⲈⲦⲢⲈⲨⲘⲞⲞⲨⲦϤ. ⲀⲨⲰ ⲘⲠⲞⲨϨⲈ ⲈⲞⲨⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ⲀⲨⲘⲎⲎϢⲈ ⲄⲀⲢ ⲢⲘⲚⲦⲢⲈ ⲈⲢⲞϤ ⲚⲚⲞⲨϪ ⲀⲨⲰ ⲚⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲈⲨϢⲎϢ ⲀⲚ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ϨⲞⲒⲚⲈ ⲆⲈ ⲀⲨⲦⲰⲞⲨⲚ ⲀⲨⲢⲘⲚⲦⲢⲈ ⲈⲢⲞϤ ⲚⲚⲞⲨϪ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲢⲠⲈ ⲘⲘⲞⲨⲚⲄ ⲚϬⲒϪ ⲀⲨⲰ ϮⲚⲀⲔⲈⲦ ⲔⲈⲞⲨⲀ ⲚⲀⲦⲘⲞⲨⲚⲄ ⲚϬⲒϪ ϨⲚ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ⲀⲨⲰ ϨⲒⲚⲀⲒ ⲞⲚ ⲦⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲈⲤⲤⲘⲞⲚⲦ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲀϤϪⲚⲈ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲄⲚⲀϢⲀϪⲈ ⲀⲚ ⲖⲀⲀⲨ ⲀϨⲢⲞⲞⲨ ⲚⲀⲒ ⲤⲈⲢⲘⲚⲦⲢⲈ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲔⲀⲢⲰϤ ⲀⲨⲰ ⲘⲠϤϢⲀϪⲈ ⲖⲀⲀⲨ. ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲞⲚ ⲀϤϪⲚⲞⲨϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲈⲦⲤⲘⲀⲘⲀⲀⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲰ ⲦⲈⲦⲚⲚⲀⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲚⲦϬⲞⲘ ⲀⲨⲰ ⲈϤⲚⲎⲨ ϨⲒϪⲚ ⲚⲈⲔⲖⲞⲞⲖⲈ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲨⲠⲈϨⲚⲈⲨϨⲞⲒⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϢ ⲚⲈ ⲚⲔⲈⲘⲚⲦⲢⲈ ⲈⲦⲚⲀϨⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲠⲞⲨⲀ ⲚⲦⲀϤϪⲞⲞϤ. ⲈⲤⲆⲞⲔⲒ ⲚⲎⲦⲚ ⲈⲞⲨ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲦϬⲀⲒⲞϤ ϪⲈ ϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ⲀⲨⲰ ⲀⲨⲀⲢⲬⲒ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲈⲚⲈϪⲦⲀϤ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀⲨⲰ ⲈϨⲂⲤⲠⲈϤϨⲞ ⲀⲨⲰ ⲈⲨϮⲔⲖⲮ ⲈϪⲰϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲚⲀⲚ. ⲀⲨⲰ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨϮⲀⲀⲤ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲈϤϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲈϤϨⲢⲀⲒ ϨⲚ ⲦⲀⲨⲖⲎ. ⲀⲤⲈⲒ ⲚϬⲒ ⲞⲨⲈⲒ ⲚⲚϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲤⲚⲀⲨ ⲈⲠⲈⲦⲢⲞⲤ ⲈϤⲐⲘⲞ ⲘⲘⲞϤ ⲀⲤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲚⲈⲔϢⲞⲞⲠ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲀⲢⲎⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲢⲚⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲦⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲘⲞϤ ⲞⲨⲆⲈ ⲚϮϬⲚ ⲈⲢⲈϪⲰ ⲘⲘⲞⲤ ⲀⲚ ϪⲈ ⲞⲨ ⲀⲨⲰ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈⲐⲀⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ⲦϨⲘϨⲀⲖ ⲆⲈ ⲚⲦⲈⲢⲈⲤⲚⲀⲨ ⲈⲢⲞϤ ⲠⲈϪⲀⲤ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϪⲈ ⲠⲀⲒ ⲞⲨⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ⲚⲦⲞϤ ⲆⲈ ⲞⲚ ⲀϤⲀⲢⲚⲀ ⲘⲘⲚⲚⲤⲀ ⲔⲈⲔⲞⲨⲒ ⲆⲈ ⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲠⲈϪⲀⲨ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲀⲖⲎⲐⲰⲤ ⲚⲦⲔⲞⲨⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ⲔⲀⲒ ⲄⲀⲢ ⲚⲦⲔⲞⲨⲄⲀⲖⲒⲖⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲢⲬⲒ ⲚⲔⲀⲈⲨⲰ ⲈϨⲢⲀⲒ ⲀⲨⲰ ⲈⲰⲢⲔ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲒⲢⲰⲘⲈ ⲈⲦⲈⲦⲚⲦⲀⲨⲞ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ⲀⲨⲰ ⲀⲠⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲘⲠⲘⲈϨⲤⲈⲠⲤⲚⲀⲨ. ⲀϤⲢⲠⲘⲈⲈⲨⲈ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲘⲠϢⲀϪⲈ ⲚⲐⲈ ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲚⲤⲈⲠⲤⲚⲀⲨ ⲔⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲘⲚⲦⲤⲰⲰⲠ ⲀⲨⲰ ⲀϤϨⲒⲦⲞⲞⲦϤ ⲀϤⲢⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ϨⲦⲞⲞⲨⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ⲀⲨϪⲒϢⲞϪⲚⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲦⲎⲢϤ ⲀⲨⲰ ⲀⲨⲤⲈⲚϨ ⲒⲎⲤⲞⲨⲤ ⲀⲨϪⲒⲦϤ ⲀⲨⲦⲀⲀϤ ⲈⲦⲞⲞⲦϤ ⲘⲠⲒⲖⲀⲦⲞⲤ . ");
INSERT INTO copshc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ⲀⲨⲰ ⲀⲠⲒⲖⲀⲦⲞⲤ ϪⲚⲞⲨϤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ⲀⲨⲰ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲞⲚ ⲀϤϪⲚⲞⲨϤ ϪⲈ ⲚⲄⲚⲀϢⲀϪⲈ ⲀⲚ ⲖⲀⲀⲨ. ⲀⲚⲀⲨ ϪⲈ ⲤⲈⲢⲘⲚⲦⲢⲈ ⲈⲢⲞⲔ ⲞⲨⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲠϤϢⲀϪⲈ ⲖⲀⲀⲨ. ϨⲰⲤⲦⲈ ⲚⲦⲈⲠⲒⲖⲀⲦⲞⲤ ⲢϢⲠⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ⲔⲀⲦⲀ ϢⲀ ⲆⲈ ϢⲀϤⲔⲰ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲞⲨⲀ ⲈϤϬⲎⲠ ⲠⲈⲦⲞⲨⲚⲀⲀⲒⲦⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ⲚⲈϤϬⲎⲠ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀ. ⲘⲚ ⲚⲈⲚⲦⲀⲨⲤⲦⲀⲤⲒⲀⲌⲈ. ⲚⲀⲒ ⲚⲦⲀⲨⲢⲪⲞⲚⲞⲤ ϨⲚ ⲦⲈⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲀϤⲀⲢⲬⲒ ⲚⲀⲒⲦⲒ ⲔⲀⲦⲀ ⲐⲈ ⲚϢⲀϤⲀⲀⲤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲦⲢⲀⲔⲰ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲘⲠⲈⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ⲚⲈϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲈⲦⲂⲈ ⲞⲨⲪⲐⲞⲚⲞⲤ ⲚⲦⲀⲨⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲨⲠⲒⲐⲈ ⲘⲠⲘⲎⲎϢⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲀⲒⲦⲒ ⲂⲂⲀⲢⲀⲂⲂⲀⲤ ⲈⲦⲢⲈϤⲔⲀⲀϤ ⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲞⲚ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲀϪⲒⲤ ⲚⲀⲒ ϪⲈ ⲦⲀⲢⲞⲨ ϬⲈ ⲘⲠⲈⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ⲚⲦⲞⲞⲨ ⲆⲈ ⲞⲚ ⲀⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲠⲈⲐⲞⲞⲮ ⲚⲦⲀϤⲀⲀϤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲀⲨϪⲒ ϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲢⲠⲒⲐⲈ ⲘⲠⲘⲎⲎϢⲈ ⲀϤⲔⲀⲂⲀⲢⲀⲂⲂⲀⲤ ⲚⲀⲨ ⲈⲂⲞⲖ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲪⲢⲀⲄⲈⲖⲖⲞⲨ ⲘⲘⲞϤ ⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲦⲢⲈⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ⲘⲘⲀⲦⲞⲒ ⲆⲈ ⲀⲨϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲦⲀⲨⲖⲎ ⲈⲦⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ⲠⲈ ⲀⲨⲰ ⲀⲨⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲚⲦⲈⲤⲠⲒⲢⲀ ⲦⲎⲢⲤ ");
INSERT INTO copshc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ⲀⲨⲰ ⲀⲨϮ ϨⲒⲰⲰϤ ⲚⲞⲨⲬⲖⲀⲘⲨⲤ ⲚϪⲎϬⲈ ⲀⲨⲰ ⲀⲨϢⲚⲦⲞⲨⲔⲖⲞⲘ ⲚϢⲞⲚⲦⲈ ⲀⲨⲔⲀⲀϤ ϨⲒϪⲰϤ ");
INSERT INTO copshc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ⲀⲨⲰ ⲀⲨⲀⲢⲬⲒ ⲚⲀⲤⲠⲀⲌⲈ ⲘⲘⲞϤ. ϪⲈ ⲬⲀⲒⲢⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ⲀⲨⲰ ⲀⲨϨⲒⲞⲨⲈ ⲘⲠⲔⲀϢ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ ⲀⲨⲚⲈϪⲦⲀϤ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ. ⲀⲨⲰ ⲀⲨⲔⲖϪⲚⲈⲨⲠⲀⲦ ϨⲒϨⲎ ⲘⲘⲞϤ ⲀⲨⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ⲚⲦⲈⲢⲞⲨⲰ ⲆⲈ ⲈⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲀⲨⲔⲀⲀϤ ⲔⲀϨⲎⲨ ⲚⲦⲈⲬⲖⲀⲘⲨⲤ ⲚϪⲎϬⲈ. ⲀⲨϮⲚⲈϤϨⲞⲒⲦⲈ ϨⲒⲰⲰϤ ⲀⲨⲰ ⲀⲨⲚⲦϤ ⲈⲂⲞⲖ ϪⲈ ⲈⲨⲈⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ⲀⲨⲔⲈϤⲈ ⲞⲨⲀ ⲆⲈ ⲈϤⲘⲞⲞϢⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ ⲠⲔⲨⲢⲎⲚⲀⲒⲞⲤ ⲈϤⲚⲎⲨ ⲈϨⲢⲀⲒ ϨⲚ ⲦⲤⲰϢⲈ ⲠⲒⲰⲦ ⲚⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲘⲚϨⲢⲞⲨⲪⲞⲤ ϪⲈ ⲈϤⲈϤⲒ ⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ⲀⲨⲰ ⲀϤⲚⲦϤ ⲈϨⲢⲀⲒ ⲈⲠⲘⲀ ϪⲈ ⲄⲞⲖⲄⲞⲐⲀ ⲠⲀⲒ ⲈϢⲀⲨϨⲈⲢⲘⲎⲚⲈⲨⲈ ⲘⲘⲞϤ ϪⲈ ⲠⲦⲞⲠⲞⲤ ⲘⲠⲈⲔⲢⲀⲚⲒⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ⲀⲨⲰ ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨⲎⲢⲠ ⲈϤⲘⲞϪⲦ ϨⲒϢⲀⲖ. ⲚⲦⲞϤ ⲆⲈ ⲘⲠϤϪⲒⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲆⲈ ⲘⲘⲞϤ. ⲀⲨⲰ ⲀⲨⲠⲈϢ ⲚⲈϤϨⲞⲒⲦⲈ ⲈϨⲢⲀⲨ ⲀⲨⲚⲈϪ ⲔⲖⲎⲢⲞⲤ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲈⲢⲈⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲀϤⲒⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ⲚⲈⲠⲚⲀⲨ ⲆⲈ ⲠⲈ ⲚϪⲠϢⲞⲘⲦⲈ ⲀⲨⲰ ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ⲚⲈⲢⲈ ⲦⲈϤⲀⲒⲦⲒⲀ ⲆⲈ ⲤⲎϨ ϨⲒϪⲰϤ ϪⲈ ⲠⲈⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ⲀⲨⲰ ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲚⲘⲘⲀϤ ⲚⲤⲞⲞⲚⲈ ⲤⲚⲀⲨ ⲞⲨⲀ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲀⲨⲰ ⲞⲨⲀ ⲚⲤⲀϨⲂⲞⲨⲢ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","— ");
INSERT INTO copshc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ⲚⲈⲦⲘⲞⲞϢⲈ ⲆⲈ ⲚⲈⲨϪⲒⲞⲨⲀ ⲈⲢⲞϤ ⲈⲨⲔⲒⲘ ⲚⲚⲈⲨⲀⲠⲎⲨⲈ ⲚⲤⲰϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀ ⲠⲈⲦⲚⲀⲂⲖ ⲠⲈⲢⲠⲈ ⲈⲂⲞⲖ ⲚϤⲔⲞⲦϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲒϪⲚ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲚⲄⲚⲀϨⲘⲈⲔ ");
INSERT INTO copshc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ϨⲒⲞⲘⲞⲒⲰⲤ ⲚⲔⲈⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲨⲤⲰⲂⲈ ⲚⲤⲰϤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈ ⲚⲦⲀϤⲚⲀϨⲘⲞⲨ ⲚⲦⲞϤ ⲆⲈ ⲚϤⲚⲀϢⲚⲀϨⲘⲈϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲢⲞ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲘⲀⲢⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲦⲈⲚⲞⲨ ϨⲒϪⲚ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ϪⲈ ⲈⲚⲈⲚⲀⲨ ⲚⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲀⲨⲰ ⲚⲔⲈⲤⲞⲞⲚⲈ ⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞⲞⲨ ⲚⲘⲘⲀϤ ⲀⲨⲚⲈϬⲚⲞⲨϬϤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ⲚⲦⲈⲢⲈⲠⲚⲀⲨ ⲆⲈ ⲚϪⲠ ⲤⲞ ϢⲰⲠⲈ ⲀⲨⲔⲀⲔⲈ ϢⲰⲠⲈ ϨⲒϪⲚ ⲠⲔⲀϨ ⲦⲎⲢϤ ϢⲀⲠⲚⲀⲨ ⲚϪⲠ ⲤⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ⲀⲨⲰ ⲘⲠⲚⲀⲨ ⲚϪⲠ ⲮⲒⲦⲈ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲞⲨⲚⲞϬ ⲚϨⲢⲞⲞⲨ ϪⲈ ⲈⲖⲰⲈⲒ ⲈⲖⲰⲈⲒ ⲖⲀⲘⲀ ⲤⲀⲬⲐⲀⲚⲈⲒ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϢⲀⲨϨⲈⲢⲘⲈⲚⲈⲨⲈ ⲘⲘⲞϤ ϪⲈ ⲠⲀⲚⲞⲨⲦⲈ ⲠⲀⲚⲞⲨⲦⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲔⲔⲀⲀⲦ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ⲀⲨⲰ ϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲠⲈϪⲀⲨ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤⲘⲞⲨⲦⲈ ⲈϨⲎⲖⲈⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ⲀⲞⲨⲀ ⲆⲈ ⲠⲰⲦ ⲀϤⲘⲀϨⲞⲨⲤⲠⲞⲄⲄⲞⲤ ⲚϨⲘϪ ⲀϤⲔⲀⲀⲤ ϨⲒϪⲚ ⲞⲨⲔⲀϢ ⲀϤⲦⲤⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲰ ⲚⲦⲚⲚⲀⲨ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲚⲀⲈⲒ ⲈⲚⲦϤ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲞⲨϪ ⲞⲨⲚⲞϬ ⲚϨⲢⲞⲞⲨ ⲀϤϮ ⲠⲈⲠⲚⲈⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ⲀⲨⲰ ⲠⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲘⲠⲈⲢⲠⲈ ⲀϤⲠⲰϨ ⲀϤⲢⲤⲚⲀⲨ ϪⲒⲚⲦⲠⲈ ⲈⲠⲈⲤⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲠⲔⲈⲚⲦⲨⲢⲒⲰⲚ ⲠⲈⲦⲀϨⲈⲢⲀⲦϤ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ϪⲈ ⲀϤⲔⲀ ⲠⲈⲦⲎⲨ ⲒⲚⲀⲒ. ⲠⲈϪⲀϤ ϪⲈ ⲀⲖⲎⲐⲰⲤ ⲠⲈⲒⲢⲰⲘⲈ ⲞⲨϢⲎⲢⲈ ⲠⲈ ⲚⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ⲚⲈⲨⲚϨⲈⲚϨⲒⲞⲘⲈ ⲆⲈ ⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲞⲨⲈ ⲈⲨϬⲰϢⲦ ⲈⲤⲚϨⲎⲦⲞⲨ ⲚϬⲒ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲀⲨⲰ ⲘⲀⲢⲒⲀ ⲦⲀⲠⲔⲞⲨⲈⲒ ⲚⲒⲀⲔⲰⲂⲞⲤ. ⲀⲨⲰ ⲦⲘⲀⲀⲨ ⲚⲒⲰⲤⲎ ⲘⲚⲤⲀⲖⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ⲚⲀⲒ ⲚⲦⲀⲨⲀϨⲞⲨ ⲚⲤⲰϤ ϪⲒⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲨⲆⲒⲀⲔⲞⲚⲒ ⲚⲀϤ ⲀⲨⲰ ϨⲈⲚⲔⲈϨⲒⲞⲘⲈ ⲦⲎⲢⲞⲨ ⲈⲀⲨⲈⲒ ⲚⲘⲘⲀϤ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲢⲞⲨϨⲈ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϪⲈ ⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϨⲀⲦⲈϨⲎ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ⲀϤⲈⲒ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲠⲈⲂⲞⲖ ϨⲚ ⲀⲢⲒⲘⲀⲐⲀⲒⲞⲤ ⲈⲨⲢⲘⲘⲀⲞ ⲠⲈ ⲂⲂⲞⲨⲖⲈⲨⲦⲎⲤ ⲚⲦⲞϤ ϨⲰⲰϤ ⲈϤϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦⲤ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤⲦⲞⲖⲘⲀ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲀⲒⲦⲒ ⲘⲘⲞϤ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲀϤⲢϢⲠⲎⲢⲈ ϪⲈ ⲈⲚⲈⲎⲆⲎ ⲀϤⲘⲞⲨ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲘⲞⲨⲦⲈ ⲈⲠⲔⲈⲚⲦⲨⲢⲒⲰⲚ ⲀϤϪⲚⲞⲨϤ ϪⲈ ⲈⲚⲈⲀϤⲰⲤⲔ ϪⲒⲚⲦⲀϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲚⲦⲞⲞⲦϤ ⲘⲠⲔⲈⲚⲦⲨⲢⲒⲰⲚ ⲀϤⲬⲀⲢⲒⲌⲈ ⲚⲒⲰⲤⲎⲪ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ⲀⲨⲰ ⲀϤϢⲈⲠ ⲞⲨⲤⲒⲚⲆⲰⲚ ⲀϤⲘⲠⲤⲰⲘⲀ ⲈⲠⲈⲤⲎⲦ ⲀϤϬⲖⲘⲖⲰⲘϤ ϨⲚ ⲦⲤⲒⲚⲆⲰⲚ. ⲀϤⲔⲀⲀϤ ϨⲘ ⲠⲈϤⲘϨⲀⲀⲨ ⲈⲀⲨϢⲈⲦϢⲰⲦϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈⲦⲢⲀ ⲀⲨⲰ ⲀⲨⲤⲔⲢⲔⲢⲞⲨⲰⲚⲈ ⲈⲢⲘⲠⲈⲘϨⲀⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ⲘⲀⲢⲒⲀ ⲆⲈ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲀⲨⲰ ⲘⲀⲢⲒⲀ ⲦⲀ ⲒⲰⲤⲎ ⲚⲈⲨⲚⲀⲨ ⲈⲠⲘⲀ ⲚⲦⲀⲨⲔⲀⲀϤ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲞⲨⲈⲒⲚⲈ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲀⲨⲰ ⲘⲀⲢⲒⲀ ⲦⲀⲒⲀⲔⲰⲂⲞⲤ ⲘⲚⲤⲀⲖⲰⲘⲎ ⲀⲨϢⲈⲠϨⲈⲚϨⲎⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲈⲒ ⲚⲤⲈⲦⲀϨⲤϤ ");
INSERT INTO copshc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ⲀⲨⲰ ϨⲦⲞⲞⲨ ⲈⲘⲀⲦⲈ ⲘⲠⲞⲨⲀ ⲚⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲈⲘϨⲀⲞⲨ ⲈⲀⲠⲢⲎϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲚⲀϤⲒⲠⲰⲚⲈ ⲈⲂⲞⲖ ϨⲒ ⲢⲰϤ ⲘⲠⲈⲘϨⲀⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ⲚⲦⲈⲢⲞⲨϤⲒⲀⲦⲞⲨ ⲆⲈ ⲈϨⲢⲀⲒ ⲀⲨⲚⲀⲨ ⲈⲠⲰⲚⲈ ⲈⲀⲨϤⲒⲦϤ ⲘⲘⲀⲨ ⲚⲈⲨⲚⲞϬ ⲄⲀⲢ ⲠⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲘϨⲀⲞⲨ ⲀⲨⲚⲀⲨ ⲈⲨϨⲢϢⲒⲢⲈ ⲈϤϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞϤ ⲈϤϬⲞⲞⲖⲈ ⲚⲞⲨⲤⲦⲞⲖⲎ ⲚⲞⲨⲰⲂϢ. ⲀⲨⲰ ⲀⲐⲞⲦⲈ ϪⲒⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ⲚⲦⲞϤ ⲆⲈ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲈⲦⲈⲦⲚⲔⲰⲦⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲀⲢⲎⲚⲞⲤ ⲠⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲀϤⲦⲰⲞⲨⲚϤ ⲚϤϨⲘⲠⲈⲒⲘⲀ ⲀⲚ. ⲀⲚⲀⲨ ⲈⲠⲘⲀ ⲚⲦⲀⲨⲔⲀⲀϤ ⲚϨⲎⲦϤ ");
INSERT INTO copshc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ⲀⲖⲖⲀ ⲂⲰⲔ ⲚⲦⲈⲦⲚϪⲞⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲘⲚⲠⲔⲈⲠⲈⲦⲢⲞⲤ ϪⲈ ϤⲚⲀⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲚ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲈⲦⲈⲦⲚⲚⲀⲚⲀⲨ ⲈⲢⲞϤ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲔⲀⲦⲀⲐⲈ ⲚⲦⲀϤϪⲞⲞⲤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲘϨⲀⲞⲨ ⲀⲨⲠⲰⲦ ⲚⲈⲢⲈⲞⲨϨⲞⲦⲈ ⲄⲀⲢ ⲚⲘⲘⲀⲨ. ⲀⲨⲰ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ⲘⲠⲞⲨϪⲈⲖⲀⲀⲨ ⲆⲈ ⲚϢⲀϪⲈ ⲈⲖⲀⲀⲨ ⲚⲈⲨⲢϨⲞⲦⲈ ⲄⲀⲢ. ");
INSERT INTO copshc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ⲦⲈⲦⲘⲘⲀⲨ ⲆⲈ ⲀⲤⲂⲰⲔ ⲀⲤⲦⲀⲘⲘⲈ ⲚⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲚⲘⲘⲀϤ ⲈⲨⲢ ϨⲂⲂⲈ ⲀⲨⲰ ⲈⲨⲢⲒⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ⲚⲦⲞⲞⲨ ⲆⲈ ϨⲰⲞⲨ ⲞⲚ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ϪⲈ ϤⲞⲚϨ ⲀⲨⲰ ϪⲈ ⲀⲤⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲢⲀⲦⲚⲀϨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲤⲚⲀⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲈⲨⲘⲞⲞϢⲈ ⲀϤⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲔⲈⲘⲞⲢⲪⲎ ⲈⲨⲂⲎⲔ ⲈⲦⲤⲰϢⲈ ");
INSERT INTO copshc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ⲚⲈⲦⲘⲘⲀⲨ ϨⲰⲞⲨ ⲞⲚ ⲀⲨⲂⲰⲔ ⲀⲨⲦⲀⲘⲈ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲞⲨⲦⲈ ⲞⲚ ⲘⲠⲞⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲚⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ⲘⲚⲚⲤⲰⲤ ⲈⲨⲚⲎϪ ⲚⲦⲞⲞⲨ ⲘⲠⲘⲚⲦⲞⲨⲈ ⲀϤⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀϤⲚⲞϬⲚⲈϬ ⲚⲦⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ⲘⲚⲦⲈⲨⲘⲚⲦⲚⲀϢⲦ ϨⲎⲦ. ϪⲈ ⲘⲠⲞⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲈⲚⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈⲀϤⲦⲰⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲚⲦⲈⲦⲚⲦⲀϢⲈ ⲞⲈⲒϢ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲤⲰⲚⲦ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ⲚⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲚϤϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ϤⲚⲀⲞⲨϪⲀⲒ. ⲠⲈⲦⲈⲚϤⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲆⲈ ⲀⲚ ⲤⲈⲚⲀⲦϬⲀⲒⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ⲚⲈⲒⲘⲀⲈⲒⲚ ⲆⲈ ⲚⲀⲞⲨⲰϨ ⲈⲚⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲤⲈⲚⲀⲚⲈϪ ⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲢⲀⲚ. ⲤⲈⲚⲀϢⲀϪⲈ ϨⲚ ⲚⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ⲤⲈⲚⲀϤⲒ ⲚⲚϨⲞϤ ϨⲚ ⲚⲈⲨϬⲒϪ ⲔⲀⲚⲈⲨϢⲀⲚⲤⲰ ⲚⲞⲨⲠⲀϨⲢⲈ ⲘⲘⲞⲨ ⲚⲤⲚⲀⲢ ⲂⲞⲞⲚⲈ ⲚⲀⲨ ⲀⲚ ⲤⲈⲚⲀⲦⲀⲖⲈ ⲦⲞⲞⲦⲞⲨ ⲈϪⲚ ⲚⲈⲦϢⲰⲚⲈ ⲚⲤⲈⲘⲦⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲚⲚⲤⲀ ⲦⲢⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨⲀⲨϤⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ⲚⲦⲞⲞⲨ ⲆⲈ ϨⲰⲞⲨ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲀⲨⲦⲀϢⲈ ⲞⲈⲒϢ ϨⲘⲘⲀ ⲚⲒⲘ ⲈⲢⲈⲠϪⲞⲈⲒⲤ ϮⲚⲦⲞⲞⲦⲞⲨ. ⲀⲨⲰ ⲈϤⲦⲀϪⲢⲞ ⲘⲠϢⲀϪⲈ ϨⲒⲦⲚ ⲘⲘⲀⲈⲒⲚ ⲈⲦⲞⲨⲎϨ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ⲈⲠⲈⲒⲆⲎ ⲀϨⲀϨ ϨⲒⲦⲞⲞⲦⲞⲨ ⲈⲤϨⲀⲒ ⲚⲚϢⲀϪⲈ ⲈⲦⲂⲈ ⲚⲈϨⲂⲎⲨⲈ ⲈⲚⲦⲀⲨⲦⲰⲦ ⲚϨⲎⲦ ϨⲢⲀⲈⲒ ⲚϨⲎⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ⲈⲦⲞⲞⲦⲚ ⲚϬⲒ ⲚⲈⲚⲦⲀⲨⲚⲀⲨ ϨⲚ ⲚⲈⲨⲂⲀⲖ ϪⲒⲚⲚϢⲞⲢⲠ ⲈⲀⲨϢⲰⲠⲈ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲘⲠϢⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ⲀⲒⲢϨⲚⲀⲒ ⲆⲈ ϨⲰ ⲈⲀⲒⲞⲨⲀϨⲦ ⲚⲤⲀϨⲰⲂ ⲚⲒⲘ ϪⲒⲚⲚϢⲞⲢⲠ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲦⲢⲀⲤϨⲀⲒⲤⲞⲨ ⲚⲀⲔ ⲞⲨⲀ ⲞⲨⲀ ⲔⲢⲀⲦⲒⲤⲦⲈ ⲐⲈⲞⲪⲒⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲒⲘⲈ ⲈⲠⲰⲢϪ ⲚⲚϢⲀϪⲈ ⲈⲚⲦⲀⲨⲔⲀⲐⲎⲔⲒ ⲘⲘⲞⲔ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ⲀϤϢⲰⲠⲈ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚϨⲎⲢⲰⲆⲎⲤ ⲠⲢⲢⲞ ⲚϮⲞⲨⲆⲀⲒⲀ ⲚϬⲒ ⲞⲨⲎⲎⲂ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲌⲀⲬⲀⲢⲒⲀⲤ ⲈϤⲎⲠ ⲈⲚⲈϨⲞⲞⲨ ⲚⲀⲂⲒⲀ. ⲈⲨⲚⲦϤⲞⲨⲤϨⲒⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲚϢⲈⲈⲢⲈ ⲚⲀⲀⲢⲰⲚ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲈⲖⲒⲤⲀⲂⲈⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ⲚⲈⲨϢⲞⲞⲠ ⲆⲈ ⲠⲈ ⲘⲠⲈⲤⲚⲀⲨ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨⲘⲞⲞϢⲈ ϨⲚ ⲚⲈⲚⲦⲞⲖⲎ ⲦⲎⲢⲞⲨ ⲚⲘⲚⲆⲒⲔⲀⲒⲰⲘⲀ ⲘⲠϪⲞⲈⲒⲤ ⲈⲨⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ⲀⲨⲰ ⲚⲈⲘⲘⲚⲦⲞⲨϢⲎⲢⲈ ⲘⲘⲀⲨ ⲠⲈ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲞⲨⲀϬⲢⲎⲚ ⲦⲈ ⲈⲖⲒⲤⲀⲂⲈⲦ. ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲘⲠⲈⲤⲚⲀⲨ ⲚⲈⲀⲨⲀⲒⲀⲈⲒ ⲠⲈ ϨⲚ ⲚⲈⲨϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤϢⲘϢⲈ ϨⲚ ⲦⲦⲀⲜⲒⲤ ⲚⲚⲈϤϨⲞⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ⲔⲀⲦⲀⲠⲤⲰⲚⲦ ⲚⲦⲘⲚⲦⲞⲨⲎⲎⲂ. ⲀⲤⲢ ⲈⲦⲰϤ ⲈⲦⲀⲖⲈϢⲞⲨϨⲎⲚⲈ ⲈϨⲢⲀⲈⲒ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ⲀⲨⲰ ⲚⲈⲢⲈⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲘⲠⲖⲀⲞⲤ ϢⲖⲎⲖ ⲘⲠⲤⲀ ⲚⲂⲞⲖ ⲘⲠⲚⲀⲨ ⲘⲠϢⲞⲨϨⲎⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ⲞⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎ ⲢⲒⲞⲚ ⲘⲠϢⲞⲨϨⲎⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ⲀϤϢⲦⲞⲢⲦⲢ ⲆⲈ ⲚϬⲒ ⲌⲀⲬⲀⲢⲒⲀⲤ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲀⲨⲰ ⲀⲨϨⲞⲦⲈ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ⲠⲈϪⲈⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲌⲀⲬⲀⲢⲒⲀⲤ. ϪⲈ ⲀⲨⲤⲰⲦⲘ ⲈⲠⲈⲔⲤⲞⲠⲤ. ⲀⲨⲰ ⲦⲈⲔⲤϨⲒⲘⲈ ⲈⲖⲒⲤⲀⲂⲈⲦ ⲤⲚⲀϪⲠⲞ ⲚⲀⲔ ⲚⲞⲨϢⲎⲢⲈ ⲀⲨⲰ ⲔⲚⲀⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ⲞⲨⲚⲞⲨⲢⲀϢⲈ ⲚⲀϢⲰⲠⲈ ⲚⲀⲔ ⲚⲘⲞⲨⲦⲈⲖⲎⲖ ⲀⲨⲰ ⲞⲨⲚϨⲀϨ ⲚⲀⲢⲀϢⲈ ⲈϪⲘⲠⲈϤϪⲠⲞ ");
INSERT INTO copshc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ϤⲚⲀⲢⲞⲨⲚⲞϬ ⲄⲀⲢ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲚⲚⲈϤⲤⲈⲎⲢⲠ ϨⲒⲤⲒⲔⲈⲢⲀ. ⲀⲨⲰ ϤⲚⲀⲘⲞⲨϨ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ϪⲒⲚⲈϤϨⲚϨⲎⲦⲤ ⲚⲦⲈϤⲘⲀⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ⲀⲨⲰ ϤⲚⲀⲔⲦⲈ ⲞⲨⲘⲎⲎϢⲈ ⲚⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲈⲠϪⲞⲈⲒⲤ ⲠⲈⲨⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ⲀⲨⲰ ⲚⲦⲞϤ ϤⲚⲀⲘⲞⲞϢⲈ ϨⲀⲦⲈϤϨⲎ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲘⲦϬⲞⲘ ⲚϨⲎⲖⲈⲒⲀⲤ ⲈⲔⲦⲞ ⲚⲚϨⲎⲦ ⲚⲚⲒⲞⲦⲈ ⲈⲚⲈⲨϢⲎⲢⲈ ⲀⲨⲰ ⲚⲀⲦⲤⲰⲦⲘ ϨⲚ ⲦⲘⲚⲦⲢⲘⲚϨⲎⲦ ⲚⲚⲆⲒⲔⲀⲒⲞⲤ. ⲈⲤⲞⲂⲦⲈ ⲚⲞⲨⲖⲀⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲈϤⲤⲂⲦⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ⲀⲨⲰ ⲠⲈϪⲈⲌⲀⲬⲀⲢⲒⲀⲤ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ. ϪⲈ ϨⲚ ⲞⲨ ϮⲚⲀⲒⲘⲈ ⲈⲠⲀⲒ ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒⲢϨⲖⲖⲞ ⲀⲨⲰ ⲦⲀⲤϨⲒⲘⲈ ⲀⲤⲀⲒⲀⲈⲒ ϨⲚ ⲚⲈⲤϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲄⲀⲂⲢⲒⲎⲖ ⲠⲈⲦⲀϨⲈⲢⲀⲦϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲀⲨⲦⲚⲚⲞⲞⲨⲦ ⲈϢⲀϪⲈ ⲚⲘⲘⲀⲔ ⲀⲨⲰ ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲚⲀⲔ ⲚⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲔⲈϢⲰⲠⲈ ⲈⲔⲔⲰ ⲢⲢⲰⲔ ⲈⲘⲘⲚϬⲞⲘ ⲘⲘⲞⲔ ⲈϢⲀϪⲈ ϢⲀⲠⲈϨⲞⲞⲨ ⲈⲦⲈⲢⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲈ ⲈⲦⲂⲈ ϪⲈⲘⲠⲔⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲀϢⲀϪⲈ. ⲚⲀⲒ ⲈⲦⲚⲀϪⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ⲠⲖⲀⲞⲤ ⲆⲈ ⲚⲈϤϬⲰϢⲦ ϨⲎⲦϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲠⲈ ⲀⲨⲰ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ⲚⲦⲈⲢⲈϤⲰⲤⲔ ϨⲘ ⲠⲈⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠϤⲈϢϬⲘϬⲞⲘ ⲈϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲀⲨⲰ ⲀⲨⲈⲒⲘⲈ ϪⲈ ⲚⲦⲀϤⲚⲀⲨ ⲈⲨϬⲰⲖⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ. ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤϪⲰⲢⲘ ⲞⲨⲂⲎⲨ ⲠⲈ ⲀⲨⲰ ⲀϤϬⲰ ⲈϤⲞ ⲚⲘⲠⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈⲚⲈϨⲞⲞⲨ ⲘⲠⲈϤϢⲘϢⲈ ϪⲰⲔ ⲈⲂⲞⲖ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ⲘⲚⲚⲤⲀ ⲚⲈⲒϨⲞⲞⲨ ⲆⲈ ⲀⲤⲰⲰ ⲚϬⲒ ⲈⲖⲒⲤⲀⲂⲈⲦ ⲦⲈϤⲤϨⲒⲘⲈ. ⲀⲨⲰ ⲀⲤϨⲞⲠⲤ ⲚϮⲞⲨ ⲚⲈⲂⲞⲦ ⲈⲤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀⲠϪⲞⲈⲒⲤ ⲀⲀⲤ ⲚⲀⲒ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲚⲦⲀϤϬⲰϢⲦ ⲈϤⲒ ⲘⲠⲀⲚⲞϬⲚⲈϬ ϨⲚ ⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ϨⲘ ⲠⲘⲈϨⲤⲞⲞⲨ ⲆⲈ ⲚⲈⲂⲞⲦ ⲀⲨϪⲞⲞⲨ ⲚⲄⲀⲂⲢⲒⲎⲖ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲈⲨⲠⲞⲖⲒⲤ ⲚⲦⲈ ⲦⲄⲀⲖⲒⲖⲀⲒ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copshc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ϢⲀⲞⲨⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲀⲨϢⲠⲦⲞⲞⲦⲤ ⲚⲞⲨϨⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ ⲈⲂⲞⲖ ϨⲘ ⲠⲎⲒ ⲚⲆⲀⲨⲈⲒⲆ. ⲀⲨⲰ ⲠⲢⲀⲚ ⲚⲦⲠⲀⲢⲐⲈⲚⲞⲤ ⲠⲈ ⲘⲀⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲚⲀⲤ ⲈϨⲞⲨⲚ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲬⲀⲒⲢⲈ ⲦⲈⲚⲦⲀⲤϬⲚϨⲘⲞⲦ ⲠϪⲞⲈⲒⲤ ⲚⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ⲚⲦⲞⲤ ⲆⲈ ⲀⲤϢⲦⲞⲢⲦⲢ ⲈϪⲘⲠϢⲀϪⲈ. ⲀⲨⲰ ⲚⲈⲤⲘⲞⲔⲘⲈⲔ ⲘⲘⲞⲤ ϪⲈ ϪⲈ ⲞⲨⲀϢ ⲘⲘⲒⲚⲈ ⲠⲈ ⲠⲈⲒⲀⲤⲠⲀⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ⲠⲈϪⲈⲠⲀⲄⲄⲈⲖⲞⲤ ⲚⲀⲤ. ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲘⲀⲢⲒⲀ. ⲀϬⲒⲚⲈ ⲄⲀⲢ ⲚⲞⲨϨⲘⲞⲦ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲈⲚⲀⲰⲰ ⲚⲦⲈϪⲠⲞ ⲚⲞⲨϢⲎⲢⲈ ⲚⲦⲈⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ⲠⲀⲒ ϤⲚⲀϢⲰⲠⲈ ⲚⲞⲨⲚⲞϬ ⲀⲨⲰ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲈⲦϪⲞⲤⲈ. ⲠϪⲞⲈⲒⲤ ⲠⲚⲞⲨⲦⲈ ⲚⲀϮ ⲚⲀϤ ⲘⲠⲈⲐⲢⲞⲚⲞⲤ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲈϤⲈⲒⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ⲀⲨⲰ ϤⲚⲀⲢⲢⲢⲞ ⲈϪⲘⲠⲎⲒ ⲚⲒⲀⲔⲰⲂ ϢⲀⲚⲒⲈⲚⲈϨ. ⲀⲨⲰ ⲘⲘⲚϨⲀⲎ ⲚⲀϢⲰⲠⲈ ⲚⲦⲈϤⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ⲠⲈϪⲈⲘⲀⲢⲒⲀ ⲆⲈ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲠⲀⲒ ⲚⲀϢⲰⲠⲈ ⲈⲘⲠⲒⲤⲞⲨⲚϨⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲠⲈⲦⲚⲎⲨ ⲈϨⲢⲀⲈⲒ ⲈϪⲰ ⲀⲨⲰ ⲦϬⲞⲘ ⲚⲦⲈⲠⲈⲦϪⲞⲤⲈ ⲠⲈⲦⲚⲀⲢϨⲀⲒⲂⲈⲤ ⲈⲢⲞ ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲈⲦⲈⲚⲀϪⲠⲞϤ ⲈϤⲞⲨⲀⲀⲂ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ⲀⲨⲰ ⲈⲒⲤⲈⲖⲒⲤⲀⲂⲈⲦ ⲦⲞⲨⲤⲨⲄⲄⲈⲚⲎⲤ ⲚⲦⲞⲤ ϨⲰⲰⲤ ⲞⲚ ⲀⲤⲰⲰ ⲚⲞⲨϢⲎⲢⲈ ϨⲚ ⲦⲈⲤⲘⲚⲦϨⲖⲖⲰ ⲀⲨⲰ ⲠⲈⲤⲘⲈϨⲤⲞⲞⲨ ⲚⲈⲂⲞⲦ ⲠⲈ ⲠⲀⲒ ⲦⲀⲒ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲦⲀϬⲢⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ϪⲈ ⲚⲚⲈⲖⲀⲀⲨ ⲚϢⲀϪⲈ ⲢⲀⲦϬⲞⲘⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ⲠⲈϪⲀⲤ ⲆⲈ ⲚϬⲒ ⲘⲀⲢⲒⲀ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲄ ⲐⲘϨⲀⲖ ⲘⲠϪⲞⲈⲒⲤ ⲘⲀⲢⲈⲤϢⲰⲠⲈ ⲚⲀⲈⲒ ⲔⲀⲦⲀ ⲠⲈⲔϢⲀϪⲈ . ⲀⲨⲰ ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ⲀⲤⲦⲰⲞⲨⲚⲤ ⲆⲈ ⲚϬⲒ ⲘⲀⲢⲒⲀ ϨⲚ ⲚⲈⲒϨⲞⲞⲨ ⲀⲤⲂⲰⲔ ⲈⲦⲞⲢⲒⲚⲎ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲈⲦⲠⲞⲖⲒⲤ ⲚϮⲞⲨⲆⲀⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ⲀⲤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲀⲤⲀⲤⲠⲀⲌⲈ ⲚⲈⲖⲒⲤⲀⲂⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ⲀⲨⲰ ⲀⲤϢⲰⲠⲈ ⲚⲦⲈⲢⲈⲈⲖⲒⲤⲀⲂⲈⲦ ⲤⲰⲦⲘ ⲈⲠⲀⲤⲠⲀⲤⲘⲞⲤ ⲘⲘⲀⲢⲒⲀ ⲀⲠϢⲎⲢⲈ ϢⲎⲘ ⲔⲒⲘ ϨⲢⲀⲒ ⲚϨⲎⲦⲤ. ⲀⲨⲰ ⲀⲈⲖⲒⲤⲀⲂⲈⲦ ⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ");
INSERT INTO copshc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ⲀⲤϤⲒϨⲢⲀⲤ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲠⲈϪⲀⲤ ϪⲈ. ⲦⲈⲤⲘⲀⲘⲀⲀⲦ ⲚⲦⲞ ϨⲚ ⲚⲈϨⲒⲞⲘⲈ ⲀⲨⲰ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲔⲀⲢⲠⲞⲤ ⲚϨⲎⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ϪⲈ ⲀⲚⲄⲚⲒⲘ ⲀⲚⲞⲔ ϪⲈ ⲈⲢⲈⲦⲘⲀⲀⲨ ⲘⲠⲀϪⲞⲈⲒⲤ ⲈⲒ ⲈⲢⲀⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲄⲀⲢ ⲚⲦⲈⲢⲈⲦⲈⲤⲘⲎ ⲘⲠⲞⲨⲀⲤⲠⲀⲤⲘⲞⲤ ⲦⲀϨⲈⲚⲀⲘⲀⲀϪⲈ. ⲀⲠϢⲎⲢⲈ ϢⲎⲘ ⲔⲒⲘ ϨⲚ ⲞⲨⲦⲈⲖⲎⲖ ⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ⲀⲨⲰ ⲚⲀⲒⲀⲦⲤ ⲚⲦⲈⲚⲦⲀⲤⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲞⲨⲚⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚⲀϢⲰⲠⲈ ⲚⲚⲈⲚⲦⲀⲨϪⲞⲞⲨ ⲚⲀⲤ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ⲀⲨⲰ ⲠⲈϪⲈⲘⲀⲢⲒⲀ ϪⲈ ⲦⲀⲮⲨⲬⲎ ϪⲒⲤⲈ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ⲀⲠⲀⲠⲚⲈⲨⲘⲀ ⲦⲈⲖⲎⲖ ⲈϪⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲤⲰⲦⲎⲢ ");
INSERT INTO copshc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ϪⲈ ⲀϤϬⲰϢⲦ ⲈϨⲢⲀⲒ ⲈϪⲘⲠⲈⲐⲂⲂⲒⲞ ⲚⲦⲈϤϨⲘϨⲀⲖ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲄⲀⲢ ϪⲒⲚⲦⲈⲚⲞⲨ ⲤⲈⲚⲀⲦⲘⲀⲒⲞ ⲚϬⲒ ⲄⲈⲚⲈⲀ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ϪⲈ ⲀϤⲒⲢⲈ ⲚⲀⲒ ⲚϨⲈⲚⲘⲚⲦⲚⲞϬ ⲚϬⲒ ⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ. ⲀⲨⲰ ⲠⲈϤⲢⲀⲚ ⲞⲨⲀⲀⲂ ");
INSERT INTO copshc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ⲠⲈϤⲚⲀ ϪⲒⲚⲞⲨϪⲰⲘ ϢⲀⲨϪⲰⲘ ⲈϪⲚ ⲚⲈⲦⲢϨⲞⲦⲈ ϨⲎⲦϤ ");
INSERT INTO copshc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ⲀϤⲈⲒⲢⲈ ⲚⲞⲨϬⲞⲘ ϨⲘ ⲠⲈϤϬⲂⲞⲒ ⲀϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲚⲚϪⲀⲤⲒϨⲎⲦ ϨⲘ ⲠⲘⲈⲈⲨⲈ ⲚⲚⲈⲨϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ⲀϤϢⲞⲢϢⲢ ⲚⲚⲒⲆⲨⲚⲀⲤⲦⲎⲤ ϨⲒⲚⲈⲨⲐⲢⲞⲚⲞⲤ. ⲀϤϪⲒⲤⲈ ⲚⲚⲈⲦⲐⲂⲂⲒⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ⲀϤⲦⲤⲒⲈ ⲚⲈⲦϨⲔⲀⲒⲦ ⲚⲀⲄⲀⲐⲞⲚ ⲀϤϪⲈⲨⲢⲢⲘⲘⲀⲞ ⲈⲨϢⲞⲨⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ⲀϤϮⲦⲞⲞⲦϤ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲠⲈϤϨⲘϨⲀⲖ ⲈⲢⲠⲘⲈⲈⲨⲈ ⲘⲠⲚⲀⲀ ");
INSERT INTO copshc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀϤϢⲀϪⲈ ⲘⲚ ⲚⲈⲚⲒⲞⲦⲈ ⲀⲂⲢⲀϨⲀⲘ ⲘⲚ ⲠⲈϤⲤⲠⲈⲢⲘⲀ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ⲘⲀⲢⲒⲀ ⲆⲈ ⲀⲤϬⲰ ϨⲀϨⲦⲎⲤ ⲚϢⲞⲘⲚⲦ ⲚⲈⲂⲞⲦ ⲀⲨⲰ ⲀⲤⲔⲞⲦⲤ ⲈϨⲢⲀⲒ ⲈⲠⲈⲤⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ⲀⲠⲈⲨⲞⲒϢ ⲆⲈ ϪⲰⲔ ⲈⲂⲞⲖ ⲚⲈⲖⲒⲤⲀⲂⲈⲦ ⲈⲦⲢⲈⲤⲘⲒⲤⲈ ⲀⲨⲰ ⲀⲤϪⲠⲞ ⲚⲞⲨϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲈⲤⲢⲘⲢⲀⲨⲎ ⲘⲚ ⲚⲈⲤⲢⲘⲢⲀⲒⲦⲈ ϪⲈ ⲀⲠϪⲞⲈⲒⲤ ⲦⲀϢⲈⲠⲈϤⲚⲀ ⲚⲘⲘⲀⲤ ⲀⲨⲰ ⲀⲨⲢⲀϢⲈ ⲚⲘⲘⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲘⲈϨϢⲘⲞⲨⲚ ⲚϨⲞⲞⲨ ⲀⲨⲈⲒ ⲈⲨⲚⲀⲤⲂⲂⲈ ⲠϢⲎⲢⲈ ϢⲎⲘ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ⲘⲠⲢⲀⲚ ⲘⲠⲈϤⲒⲰⲦ ϪⲈ ⲌⲀⲬⲀⲢⲒⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ⲀⲦⲈϤⲘⲀⲀⲨ ⲆⲈ ⲞⲨⲰϢⲂ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲈⲨⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲀⲤ ϪⲈ. ⲘⲘⲚⲖⲀⲀⲨ ϨⲚ ⲦⲞⲨⲢⲀⲒⲦⲈ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ⲘⲠⲈⲒⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ⲚⲈⲨϪⲰⲢⲘ ⲆⲈ ⲞⲨⲂⲈ ⲠⲈϤⲒⲰⲦ ϪⲈ ⲈⲔⲞⲨⲈϢⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ⲀϤⲀⲒⲦⲒ ⲆⲈ ⲚⲞⲨⲠⲒⲚⲀⲔⲒⲤ ⲀϤⲤϨⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈ ⲠⲈϤⲢⲀⲚ. ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ⲀⲢⲰϤ ⲆⲈ ⲞⲨⲰⲚ ⲚⲦⲈⲨⲚⲞⲨ ⲘⲚ ⲠⲈϤⲖⲀⲤ ⲀϤϢⲀϪⲈ ⲈϤⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ⲀⲨϨⲞⲦⲈ ⲆⲈ ϢⲰⲠⲈ ⲈϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲘ ⲠⲈⲨⲔⲰⲦⲈ. ⲀⲨⲰ ϨⲚ ⲦⲞⲢⲒⲚⲎ ⲦⲎⲢⲤ ⲚϮⲞⲨⲆⲀⲒⲀ ⲚⲈⲨϢⲀϪⲈ ⲠⲈ ⲚⲚⲈⲒϢⲀϪⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ⲀⲚⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲦⲎⲢⲞⲨ ⲔⲀⲀⲨ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲈⲢⲈⲠⲈⲒϢⲎⲢⲈ ϢⲎⲘ ⲚⲀⲢⲞⲨ ⲔⲀⲒⲄⲀⲢ ⲦϬⲒϪ ⲘⲠϪⲞⲈⲒⲤ ⲚⲈⲤϢⲞⲞⲠ ⲚⲘⲘⲀϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ⲀⲌⲀⲬⲀⲢⲒⲀⲤ ⲆⲈ ⲠⲈϤⲒⲰⲦ ⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲀϤⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ϪⲈ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲚⲞⲨⲦⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ϪⲈⲀϤϬⲘⲠⲈϤϢⲒⲚⲈ ⲀⲨⲰ ⲀϤⲒⲢⲈ ⲚⲞⲨⲤⲰⲦⲈ ⲘⲠⲈϤⲖⲀⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ⲀϤⲦⲞⲨⲚⲞⲤ ⲚⲞⲨⲦⲀⲠ ⲚⲞⲨϪⲀⲒ ⲚⲀⲚ ϨⲘ ⲠⲎⲒ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲈϤϨⲘϨⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤϢⲀϪⲈ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲞⲨⲀⲀⲂ ϪⲒⲚⲈⲚⲈϨ ");
INSERT INTO copshc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ⲚⲞⲨⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲚϪⲀϪⲈ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲦϬⲒϪ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲘⲞⲤⲦⲈ ⲘⲘⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ⲈⲈⲒⲢⲈ ⲚⲞⲨⲚⲀ ⲘⲚ ⲚⲈⲚⲒⲞⲦⲈ ⲈⲢⲠⲘⲈⲈⲨⲈ ⲚⲦⲈϤⲆⲒⲀⲐⲎⲔⲎ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ⲠⲀⲚⲀϢ ⲚⲦⲀϤⲰⲢⲔ ⲘⲘⲞϤ ⲚⲚⲀⲂⲢⲀϨⲀⲘ ⲠⲈⲚⲒⲰⲦ. ⲈϮⲐⲈ ⲚⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ⲀϪⲚϨⲞⲦⲈ ⲈⲀⲚⲚⲞⲨϨⲘ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲚϪⲀϪⲈ ⲈϢⲘϢⲈ ⲚⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ϨⲚ ⲞⲨⲞⲨⲞⲠ ⲚⲘⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲚϨⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ⲚⲦⲞⲔ ⲆⲈ ϨⲰⲰⲔ ⲠⲀϢⲎⲢⲈ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ ϪⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲠⲈⲦϪⲞⲤⲈ ⲔⲚⲀⲘⲞⲞϢⲈ ⲄⲀⲢ ϨⲀⲐⲎ ⲘⲠϪⲞⲈⲒⲤ ⲈⲤⲞⲂⲦⲈ ⲚⲚⲈϤϨⲒⲞⲞⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ⲈϮ ⲚⲞⲨⲤⲞⲞⲨⲚ ⲚⲞⲨϪⲀⲒ ⲘⲠⲈϤⲖⲀⲞⲤ ϨⲘ ⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲚⲞⲂⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ⲈⲦⲂⲈ ⲦⲘⲚⲦϢⲀⲚϨⲦⲎϤ ⲘⲠⲚⲀⲀ ⲘⲠⲈⲚⲚⲞⲨⲦⲈ ϨⲚ ⲚⲈⲦϤⲚⲀϬⲘ ⲠⲈⲚϢⲒⲚⲈ ⲚϨⲎⲦⲞⲨ ⲚϬⲒ ⲠⲞⲨⲞⲈⲒⲚ ⲈⲂⲞⲖ ϨⲘ ⲠϪⲒⲤⲈ ");
INSERT INTO copshc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ⲈⲢⲞⲨⲞⲈⲒⲚ ⲈⲚⲈⲦϨⲘ ⲠⲔⲀⲔⲈ ⲘⲚ ⲚⲈⲦϨⲘⲞⲞⲤ ϨⲚ ⲐⲀⲒⲂⲈⲤ ⲘⲠⲘⲞⲨ. ⲈⲤⲞⲞⲨⲦⲚ ⲚⲚⲈⲚⲞⲨⲈⲢⲎⲦⲈ ⲈⲦⲈϨⲒⲎ ⲚϮⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ⲠϢⲎⲢⲈ ⲆⲈ ϢⲎⲘ ⲀϤⲀⲨⲜⲀⲚⲈ ⲀⲨⲰ ⲀϤϬⲘϬⲞⲘ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲚⲈϤϢⲞⲞⲠ ⲆⲈ ⲠⲈ ϨⲚ ⲚϪⲀⲒⲈ ϢⲀⲠⲈϨⲞⲞⲨ ⲘⲠⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲆⲞⲄⲘⲀ ⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲢⲞ ⲀⲄⲞⲨⲤⲦⲞⲤ ⲈⲦⲢⲈⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ ⲤϨⲀⲒⲤ ⲚⲤⲀⲚⲈⲤⲦⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ⲦⲀⲒ ⲦⲈ ⲦϢⲞⲢⲠ ⲚⲀⲠⲞⲄⲢⲀⲪⲎ ⲈⲚⲦⲀⲤϢⲰⲠⲈ. ⲈⲢⲈⲔⲨⲢⲒⲚⲞⲤ ⲞⲚϨⲎⲄⲈⲘⲰⲚ ⲈⲦⲤⲨⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ⲀⲨⲰ ⲚⲈⲨⲂⲎⲔ ⲦⲎⲢⲞⲨ ⲠⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲈⲤϨⲀⲒϤ ⲚⲤⲀ ⲦⲈϤⲠⲞⲖⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ⲀϤⲂⲰⲔ ϨⲰⲰϤ ⲈϨⲢⲀⲒ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ ⲦⲠⲞⲖⲒⲤ ⲚϮⲞⲨⲆⲀⲒⲀ ⲈⲦⲠⲞⲖⲈⲒⲤ ⲚⲆⲀⲨⲈⲒⲆ ⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲂⲎⲐⲖⲈⲈⲘ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲎⲒ ⲚⲘⲦⲠⲀⲦⲢⲒⲀ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ⲈⲦⲢⲈϤⲦⲀⲀϤ ⲈϨⲞⲨⲚ ⲚⲘⲘⲀⲢⲒⲀ ⲦⲈⲦⲈ ⲢⲈⲦⲞⲞⲦⲤ ϢⲎⲠ ⲚⲀϤ ⲈⲤⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲨϢⲰⲠⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲤϨⲞⲞⲨ ⲈⲦⲢⲈⲤⲘⲒⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ⲀⲤϪⲠⲞ ⲘⲠⲈⲤϢⲎⲢⲈ ⲠⲈⲤϢⲢⲠⲘⲘⲒⲤⲈ ⲀⲤϬⲞⲞⲖⲈϤ ⲚϨⲈⲚⲦⲞⲈⲒⲤ ⲀⲤϪⲦⲞϤ ϨⲚ ⲞⲨⲞⲘϤ ϪⲈ ⲚⲈⲘⲘⲚⲘⲀ ϢⲞⲞⲠ ⲚⲀⲨ ϨⲘ ⲠⲘⲀ ⲚϬⲞⲒⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ⲚⲈⲨⲚϨⲈⲚϢⲞⲞⲤ ⲆⲈ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲨϢⲞⲞⲠ ϨⲚ ⲦⲤⲰϢⲈ ⲈⲨⲀⲢⲈϨ ϨⲚ ⲞⲨⲢϢⲈ ⲚⲦⲈⲨϢⲎ ⲈⲠⲈⲨⲞϨⲈ ⲚⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀⲠⲈⲞⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ⲢⲞⲨⲞⲈⲒⲚ ⲈⲢⲞⲞⲨ ⲀⲨⲢϨⲞⲦⲈ ⲚⲞⲨⲚⲞϬ ⲚϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ⲠⲈϪⲈ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲚⲀⲨ ϪⲈ. ⲘⲠⲢⲢϨⲞⲦⲈ. ⲈⲒⲤ ϨⲎⲦⲈ ⲄⲀⲢ ϮⲚⲀⲦⲀϢⲈⲞⲈⲒϢ ⲚⲎⲦⲚ ⲚⲞⲨⲚⲞϬ ⲢⲢⲀϢⲈ ⲠⲀⲒ ⲈⲦⲚⲀϢⲰⲠⲈ ⲘⲠⲖⲀⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ϪⲈ ⲀⲨϪⲠⲞ ⲚⲎⲦⲚ ⲘⲠⲞⲞⲨ ⲘⲠⲤⲰⲦⲎⲢ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϪⲞⲈⲒⲤ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ⲀⲨⲰ ⲞⲨⲘⲀⲈⲒⲚ ⲚⲎⲦⲚ ⲠⲈ ⲠⲀⲒ ⲦⲈⲦⲚⲀϨⲈ ⲈⲨϢⲎⲢⲈ ϢⲎⲘ ⲈϤϬⲞⲞⲖⲈ ⲚϨⲈⲚⲦⲞⲈⲒⲤ ⲈϤⲔⲎ ϨⲚ ⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ⲀⲨϢⲰⲠⲈ ⲆⲈ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲚⲘⲠⲀⲄⲄⲈⲖⲞⲤ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲚⲦⲈⲤⲦⲢⲀⲦⲒⲀ ⲚⲦⲠⲈ ⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ϪⲈ. ⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲚⲈⲦϪⲞⲤⲈ ⲀⲨⲰ ϮⲢⲎⲚⲎ ϨⲒϪⲚ ⲠⲔⲀϨ ϨⲚ ⲢⲢⲰⲘⲈ ⲘⲠⲈϤⲞⲨⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈⲚⲀⲄⲄⲈⲖⲞⲤ ⲂⲰⲔ ⲈϨⲢⲀⲒ ϨⲒⲦⲞⲞⲦⲞⲨ ⲈⲦⲠⲈ. ⲚⲈⲢⲈⲚϢⲞⲞⲤ ϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ϪⲈ ⲘⲀⲢⲚⲂⲰⲔ ϢⲀⲂⲎⲐⲖⲈⲈⲘ ⲚⲦⲚⲚⲀⲨ ⲈⲠⲈⲒϢⲀϪⲈ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲈⲚⲦⲀⲠϪⲞⲈⲒⲤ ⲞⲨⲞⲚϨϤ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ⲀⲨϬⲈⲠⲎ ⲆⲈ ⲀⲨⲈⲒ ⲀⲨϨⲈ ⲈⲘⲀⲢⲒⲀ ⲚⲘⲒⲰⲤⲎⲪ ⲚⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲈϤⲔⲎ ϨⲚ ⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲀⲨⲈⲒⲘⲈ ⲈⲠϢⲀϪⲈ ⲈⲚⲦⲀⲨϪⲞⲞϤ ⲚⲀⲨ ⲈⲦⲂⲈ ⲠϢⲎⲢⲈ ϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈϪⲚ ⲚⲈⲚⲦⲀⲚϢⲞⲞⲤ ϪⲞⲞⲨ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲈⲤϨⲀⲢⲈϨ ⲈⲚⲈⲒϢⲀϪⲈ ⲦⲎⲢⲞⲨ ⲠⲈ ⲈⲤⲔⲰ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲈⲤϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲚϬⲒ ⲚϢⲞⲞⲤ ⲈⲨϮⲈⲞⲞⲨ ⲀⲨⲰ ⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ⲈϪⲚ ⲚⲈⲚⲦⲀⲨⲤⲞⲦⲘⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨⲚⲀⲨ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲨϪⲞⲞⲤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ⲚⲦⲈⲢⲈϢⲘⲞⲨⲚ ⲆⲈ ⲚϨⲞⲞⲨ ϪⲰⲔ ⲈⲂⲞⲖ ⲈⲦⲢⲈⲨⲤⲂⲂⲎⲦϤ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲦⲀⲀϤ ⲈⲢⲞϤ ⲈⲘⲠⲀⲦⲤⲰⲰ ⲘⲘⲞϤ ϨⲚ ⲐⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈϨⲞⲞⲨ ⲘⲠⲈⲨⲦⲂⲂⲞ ⲔⲀⲦⲀⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲀⲨϪⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲐⲒⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲘⲠϪⲞⲈⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ϪⲈ ϨⲞⲞⲨⲦ ⲚⲒⲘ ⲈⲦⲚⲀⲞⲨⲰⲚ ⲈⲦⲞⲞⲦⲈ ⲈⲨⲈⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲞⲨⲀⲀⲂ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ⲀⲨⲰ ⲈϮ ⲚⲞⲨⲐⲨⲤⲒⲀ ⲔⲀⲦⲀ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲠϪⲞⲈⲒⲤ. ϪⲈ ⲞⲨⲤⲞⲈⲒϢ ⲚϬⲢⲘⲠϢⲀⲚ ⲎⲘⲀⲤ ⲤⲚⲀⲨ ⲚϬⲢⲞⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲠⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲨⲘⲈⲰⲚ. ⲀⲨⲰ ⲠⲈⲒⲢⲰⲘⲈ ⲚⲈⲨⲆⲒⲔⲀⲒⲞⲤ ⲠⲈ ⲢⲢⲈϤϢⲘϢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈϤϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦϤ ⲘⲠⲤⲞⲖⲤⲖ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲈⲨⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ϢⲞⲞⲠ ⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ⲈⲀⲨⲦⲀⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϪⲈ ⲚϤⲚⲀⲘⲞⲨ ⲀⲚ ⲈⲘⲠϤⲚⲀⲨ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ⲀⲨⲰ ⲀϤⲈⲒ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲠⲈⲢⲠⲈ ϨⲘ ⲠⲦⲢⲈⲚⲈⲒⲞⲦⲈ ⲆⲈ ϪⲒ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲈϨⲞⲨⲚ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲢⲈⲨⲈⲒⲢⲈ ⲘⲠⲤⲰⲚⲦ ⲘⲠⲚⲞⲘⲞⲤ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ⲚⲦⲞϤ ⲆⲈ ⲀϤϪⲒⲦϤ ⲈⲠⲈϤϨⲀⲘⲎⲢ ⲀϤⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ⲠⲈϪⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ϪⲈ. ⲦⲈⲚⲞⲨ ⲔⲚⲀⲔⲰ ⲈⲂⲞⲖ ⲘⲠⲈⲔϨⲘϨⲀⲖ ⲠϪⲞⲈⲒⲤ ⲔⲀⲦⲀⲠⲈⲔϢⲀϪⲈ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ ");
INSERT INTO copshc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ϪⲈ ⲀⲚⲀⲂⲀⲖ ⲚⲀⲨ ⲈⲠⲈⲔⲞⲨϪⲀⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ⲠⲀⲒ ⲈⲚⲦⲀⲔⲤⲂⲦⲰⲦϤ ⲘⲠⲈⲔⲦⲞ ⲈⲂⲞⲖ ⲚⲖⲖⲀⲞⲤ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ⲠⲞⲨⲞⲈⲒⲚ ⲈⲨϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲚϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲈⲔⲖⲀⲞⲤ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ⲠⲈϤⲈⲒⲰⲦ ⲆⲈ ⲚⲘⲦⲈϤⲘⲀⲀⲨ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ⲈϪⲚ ⲚⲈⲦⲞⲨϪⲰ ⲘⲘⲞⲞⲨ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ⲀⲤⲨⲘⲈⲰⲚ ⲆⲈ ⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲠⲈϪⲀϤ ⲘⲘⲀⲢⲒⲀ ⲦⲈϤⲘⲀⲀⲨ ϪⲈ ⲈⲒⲤⲠⲀⲒ ⲔⲎ ⲈϨⲢⲀⲈⲒ ⲈⲨϨⲈ ⲚⲘⲞⲨⲦⲰⲞⲨⲚ ⲚϨⲀϨ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ ⲀⲨⲰ ⲈⲨⲘⲀⲈⲒⲚ ⲈⲨⲰϨⲘ ϨⲒⲰⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ⲚⲦⲞ ⲆⲈ ⲞⲨⲚⲞⲨⲤⲎϤⲈ ⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲞⲨⲮⲨⲬⲎ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚϬⲒ ⲘⲘⲞⲔⲘⲈⲔ ⲚϨⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ⲚⲈⲨⲚ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲦⲒⲤ ⲆⲈ ϪⲈ ⲀⲚⲚⲀ ⲦϢⲈⲈⲢⲈ ⲘⲪⲀⲚⲞⲨⲎⲖ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲪⲨⲖⲎ ⲚⲀⲤⲎⲢ ⲦⲀⲒ ⲆⲈ ⲀⲤⲀⲒⲀⲒ ϨⲚ ϨⲈⲚϨⲞⲞⲨ ⲈⲚⲀϢⲰⲞⲨ ⲈⲀⲤⲢⲤⲀϢϤⲈ ⲢⲢⲞⲘⲠⲈ ⲘⲚ ⲠⲈⲤϨⲀⲒ ϪⲒⲚ ⲦⲈⲤⲘⲚⲦⲢⲞⲞⲨⲚⲈ ");
INSERT INTO copshc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ⲀⲨⲰ ⲀⲤⲢⲬⲎⲢⲀ ϢⲀⲦⲤⲢϨⲘⲈⲚⲈⲦⲀϤⲦⲈ ⲢⲢⲞⲘⲠⲈ. ⲦⲀⲒ ⲆⲈ ⲘⲈⲤⲤⲚⲠⲈⲢⲠⲈ ⲈⲂⲞⲖ ⲈⲤϢⲘϢⲈ ⲘⲠⲈϨⲞⲞⲨ ⲚⲘⲦⲈⲨϢⲎ ϨⲚ ϨⲈⲚⲚⲎⲤⲦⲒⲀ ⲚⲘϨⲈⲚⲤⲞⲠⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲤⲀϨⲈⲢⲀⲦⲤ ⲀⲤⲈⲜϨⲞⲘⲞⲖⲞⲄⲒ ⲘⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲚⲈⲤϢⲀϪⲈ ⲚⲘⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦϤ ⲘⲠⲤⲰⲦⲈ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ⲚⲦⲈⲢⲞⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ϨⲰⲂ ⲚⲒⲘ ⲔⲀⲦⲀⲠⲚⲞⲘⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲔⲞⲦⲞⲨ ⲈϨⲢⲀⲒ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲦⲈⲨⲠⲞⲖⲈⲒⲤ ⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copshc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ⲠϢⲎⲢⲈ ⲆⲈ ϢⲎⲘ ⲚⲈⲀϤⲀⲒⲀⲈⲒ ⲀⲨⲰ ⲚⲈϤϬⲘϬⲞⲘ ⲈϤⲘⲈϨ ⲚⲦⲤⲞⲪⲒⲀ ⲈⲢⲈⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ϨⲒϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ⲚⲈⲢⲈⲚⲈϤⲒⲞⲦⲈ ⲆⲈ ⲂⲎⲔ ⲠⲈ ⲦⲢⲢⲞⲘⲠⲈ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲠϢⲀ ⲘⲠⲠⲀⲤⲬⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ⲚⲦⲈⲢⲈϤⲢⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲆⲈ ⲢⲢⲞⲘⲠⲈ ⲈⲨⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲔⲀⲦⲀⲠⲤⲰⲚⲦ ⲘⲠϢⲀⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚⲚⲈϨⲞⲞⲨ ϨⲘ ⲠⲦⲢⲈⲨⲔⲞⲦⲞⲨ ⲀϤϬⲰ ⲚϬⲒ ⲠϢⲎⲢⲈ ϢⲎⲘ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲘⲠⲞⲨⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲚⲈϤⲒⲞⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ⲈⲨⲘⲈⲨⲈ ϪⲈ ϤϨⲚⲦⲈϨⲒⲎ ⲚⲘⲘⲀⲨ. ⲚⲦⲈⲢⲞⲨⲢⲞⲨϨⲞⲞⲨ ⲆⲈ ⲘⲘⲞⲞϢⲈ ⲀⲨϢⲒⲚⲈ ⲚⲤⲰϤ ϨⲚ ⲚⲈⲨⲤⲨⲄⲄⲈⲚⲎⲤ ⲘⲚ ⲚⲈⲦⲤⲞⲞⲨⲚ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲦⲘϨⲈ ⲈⲢⲞϤ ⲀⲨⲔⲞⲦⲞⲨ ⲈϨⲢⲀⲈⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲨϢⲒⲚⲈ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲚⲚⲤⲀϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲀⲨϨⲈ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲢⲠⲈ ⲈϤϨⲘⲞⲞⲤ ⲚⲦⲘⲎⲦⲈ ⲚⲚⲤⲀϨ ⲈϤⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲈϤϪⲚⲞⲨ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚϬⲒ ⲚⲈⲦⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϪⲚ ⲚⲈϤⲘⲚⲦⲤⲀⲂⲈ ⲘⲚ ⲚⲈϤϬⲒⲚⲞⲨⲰϢⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲀⲨⲢϢⲠⲎⲢⲈ. ⲠⲈϪⲈ ⲦⲈϤⲘⲀⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲀϢⲎⲢⲈ ⲚⲦⲀⲔⲢⲞⲨ ⲚⲀⲚ ϨⲒⲚⲀⲒ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ⲘⲚ ⲠⲈⲔⲒⲰⲦ ⲈⲚⲘⲞⲔϨ ⲚϨⲎⲦ ⲈⲚϢⲒⲚⲈ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲒ. ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲀϬⲰ ϨⲚ ⲚⲀⲠⲀⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ⲚⲦⲞⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲒⲘⲈ ⲈⲠϢⲀϪⲈ ⲈⲚⲦⲀϤϪⲞⲞϤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ⲀϤⲈⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲚⲘⲘⲀⲨ ⲈϨⲢⲀⲒ ⲈⲚⲀⲌⲀⲢⲈⲐ ⲀⲨⲰ ⲚⲈϤⲤⲰⲦⲘ ⲚⲤⲰⲞⲨ. ⲦⲈϤⲘⲀⲀⲨ ⲆⲈ ⲚⲈⲤϨⲀⲢⲈϨ ⲈⲚⲈⲒϢⲀϪⲈ ⲦⲎⲢⲞⲨ ⲠⲈ ϨⲘ ⲠⲈⲤϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈϤⲠⲢⲞⲔⲞⲠⲦⲈ ϨⲚ ⲦⲤⲞⲪⲒⲀ ⲚⲘⲐⲎⲖⲒⲔⲒⲀ ⲚⲘⲦⲈⲬⲀⲢⲒⲤ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲘ ⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ϨⲚ ⲤⲠⲘⲚⲦⲎ ⲆⲈ ⲚⲐⲎⲄⲈⲘⲞⲚⲒⲀ ⲚⲦⲒⲂⲈⲢⲒⲞⲤ ⲔⲀⲒⲤⲀⲢ ⲈϤⲞ ⲚϨⲎⲄⲈⲘⲰⲚ ⲈϪⲚ ϮⲞⲨⲆⲀⲒⲀ ⲚϬⲒ ⲠⲞⲚⲦⲒⲞⲤ ⲠⲒⲖⲀⲦⲞⲤ ⲈⲢⲈϨⲎⲢⲰⲆⲎⲤ ⲞⲚⲦⲈⲦⲢⲀⲢⲬⲎⲤ ⲈϪⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲢⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ ⲞⲚⲦⲈⲦⲢⲀⲢⲬⲎⲤ ⲈϪⲚ ϮⲦⲞⲨⲢⲀⲒⲀⲤ ⲚⲘ ⲦⲈⲦⲈⲦⲢⲀⲬⲰⲚⲒⲦⲒⲆⲞⲤ ⲚⲬⲰⲢⲀ ⲚⲘⲖⲨⲤⲀⲚⲒⲀⲤ ⲈϤⲞ ⲚⲦⲈⲦⲢⲀⲢⲬⲎⲤ ⲈⲦⲀⲂⲒⲖⲎⲚⲎ ");
INSERT INTO copshc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ϨⲒⲀⲚⲚⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲘⲔⲀⲒⲪⲀⲤ. ⲀⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲰⲠⲈ ϢⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲠϢⲎⲢⲈ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ⲀϤⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲚⲞⲨⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ⲈⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ⲚⲐⲈ ⲈⲦⲤⲎϨ ϨⲘ ⲠϪⲰⲘⲈ ⲚⲚϢⲀϪⲈ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲦⲈⲤⲘⲎ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϪⲀⲒⲈ ϪⲈ ⲤⲞⲂⲦⲈ ⲚⲦⲈϨⲒⲎ ⲘⲠϪⲞⲈⲒⲤ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲦⲚ ⲚⲚⲈϤⲘⲀ ⲘⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ⲈⲒⲀ ⲚⲒⲘ ⲚⲒⲘ ⲚⲀⲘⲞⲨϨ ⲚⲦⲈⲦⲞⲞⲨ ⲚⲒⲘ ϨⲒⲤⲒⲂⲦ ⲚⲒⲘ ⲐⲂⲂⲒⲞ ⲀⲨⲰ ⲚⲈⲦϬⲞⲞⲘⲈ ⲚⲀϢⲰⲠⲈ ⲈⲨⲤⲞⲨⲦⲰⲚ ⲘⲚ ⲚⲈⲦⲚⲀϢⲦ ⲈϨⲈⲚϨⲒⲞⲞⲨⲈ ⲈⲨⲤⲖⲈϬⲖⲰϬ ");
INSERT INTO copshc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ⲀⲨⲰ ⲠⲈⲞⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ⲚⲀⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈⲤⲀⲢⲜ ⲚⲒⲘ ⲚⲀⲨ ⲈⲠⲈⲨϪⲀⲒ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ⲚⲈϤϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲠⲈ ⲚⲘⲘⲎⲎϢⲈ ⲈⲦⲚⲎⲞⲨ ⲈⲂⲀⲠⲦⲒⲌⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ϪⲈ ⲚⲈϪⲠⲞ ⲚⲚⲈϨϤⲞⲨⲒ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲦⲀⲘⲰⲦⲚ ⲈⲠⲰⲦ ⲈⲂⲞⲖ ϨⲎⲦⲤ ⲚⲦⲞⲢⲄⲎ ⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ⲀⲢⲒϨⲈⲚⲔⲀⲢⲠⲞⲤ ϬⲈ ⲈⲨⲘⲠϢⲀ ⲚⲦⲈⲦⲚⲘⲈⲦⲀⲚⲞⲒⲀ ⲚⲦⲈⲦⲚⲦⲘⲀⲢⲬⲒ ⲈϪⲞⲞⲤ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϪⲈ ⲞⲨⲚⲦⲀⲚ ⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϬⲞⲘ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲨⲚⲈⲤϢⲎⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲒⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ϪⲒⲚⲦⲈⲚⲞⲨ ⲆⲈ ⲠⲔⲈⲖⲈⲂⲒⲚ ⲔⲎ ϨⲀⲦⲚⲞⲨⲚⲈ ⲚⲚϢⲎⲚ. ϢⲎⲚ ⲚⲒⲘ ⲈⲦⲈⲚϤⲚⲀϮⲔⲀⲢⲠⲞⲤ ⲀⲚ ⲈⲚⲀⲚⲞⲨϤ. ⲤⲈⲚⲀⲔⲞⲞⲢⲈϤ ⲚⲤⲈⲚⲞϪϤ ⲈⲠⲔⲰϨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ⲀⲚⲘⲎⲎϢⲈ ⲆⲈ ϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀⲀⲀϤ ϪⲈⲔⲀⲀⲤ ⲈⲚⲈⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲈⲞⲨⲚⲦⲀϤ ϢⲦⲎⲚ ⲤⲚⲦⲈ ⲘⲀⲢⲈϤϮⲞⲨⲈⲒ ⲘⲠⲈⲦⲈⲘⲘⲚⲦⲀϤ. ⲀⲨⲰ ⲠⲈⲦⲈⲞⲨⲚⲦϤⲞⲒⲔ ⲘⲀⲢⲈϤⲒⲢⲈ ⲞⲚ ϨⲒⲚⲀⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ⲀϨⲈⲚⲔⲈⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲈⲒ ⲈϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲘⲠⲢⲢⲖⲀⲀⲨ ⲚϨⲞⲨⲞ ⲠⲀⲢⲀⲠⲈⲚⲦⲀⲨⲦⲞϢϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ⲚϬⲒ ⲚⲈⲦⲞ ⲘⲘⲀⲦⲞⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ϨⲰⲰⲚ ⲞⲚ ⲠⲈⲦⲚⲚⲀⲀⲀϤ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲠⲢⲆⲒⲀⲤⲒ ⲈⲖⲀⲀⲨ ⲀⲨⲰ ⲘⲠⲢϨⲒⲖⲀ ⲈⲖⲀⲀⲨ. ⲚⲦⲈⲦⲚϨⲰ ⲈⲢⲰⲦⲚ ⲈⲚⲈⲦⲚⲞⲮⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ⲈⲢⲈⲠⲖⲀⲞⲤ ⲆⲈ ϬⲰϢⲦ ⲈⲂⲞⲖ ⲈⲨⲘⲈⲨⲈ ⲦⲎⲢⲞⲨ ϨⲚ ⲚⲈⲨϨⲎⲦ ⲈⲦⲂⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ϪⲈ ⲘⲈϢⲀⲔ ⲚⲦⲞϤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲈⲒⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲘⲞⲞⲨ ϤⲚⲎⲨ ⲆⲈ ⲚϬⲒ ⲠⲈⲦϪⲞⲞⲢ ⲈⲢⲞⲒ ⲠⲀⲒ ⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲂⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲘⲞⲨⲤ ⲘⲠⲈϤⲦⲞⲞⲨⲈ ⲚⲦⲞϤ ⲠⲈⲦⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲚⲘⲞⲨⲔⲰϨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲈϤϨⲀ ϨⲚ ⲦⲈϤϬⲒϪ ⲈⲦⲂⲂⲞ ⲘⲠⲈϤϪⲚⲞⲞⲨ ⲈⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲈϤⲤⲞⲨⲞ ⲈⲦⲈϤⲀⲠⲞⲐⲎⲔⲎ ⲠⲦⲰϨ ⲆⲈ ⲚϤⲢⲞⲔϨϤ ϨⲚ ⲞⲨⲤⲀⲦⲈ ⲈⲘⲈⲤⲰϢⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ϨⲚ ϨⲈⲚⲔⲈⲘⲎⲎϢⲈ ⲆⲈ ⲈⲚⲀϢⲰⲞⲨ ⲚϢⲀϪⲈ ⲚⲈϤⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞⲞⲨ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ϨⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲠⲦⲈⲦⲢⲀⲢⲬⲎⲤ ⲈⲨϪⲠⲒⲞ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲈⲦⲂⲈ ϨⲎⲢⲰⲆⲒⲀⲤ ⲐⲒⲘⲈ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ ⲀⲨⲰ ⲈⲦⲂⲈ ϨⲰⲂ ⲚⲒⲘ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲈⲦⲀϨⲎⲢⲰⲆⲎⲤ ⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ⲀϤⲞⲨⲈϨⲠⲈⲒⲔⲈ ⲈϪⲚ ⲚⲈϤⲔⲞⲞⲨⲈ ⲦⲎⲢⲞⲨ ⲀϤⲈⲦⲠⲒⲰϨⲀⲚⲚⲎⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ϪⲒ. ⲀϤϢⲖⲎⲖ ⲀⲦⲠⲈ ⲞⲨⲰⲚ ");
INSERT INTO copshc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈϪⲰϤ ϨⲚ ⲞⲨⲤⲘⲞⲦ ⲚⲤⲰⲘⲀ ⲚⲐⲈ ⲚⲞⲨϬⲢⲞⲞⲘⲠⲈ. ⲀⲨⲰ ⲀⲨⲤⲘⲎ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲘⲈⲢⲒⲦ ⲈⲚⲦⲀⲒⲞⲨⲰϢ ⲚϨⲎⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈϤϨⲘⲘⲀⲀⲂⲈ ⲢⲢⲞⲘⲠⲈ ⲠⲈ ⲈⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ ⲠⲈⲈ ⲚⲐⲈ ⲈⲦⲞⲨⲘⲈⲈⲨⲈ ⲈⲢⲞϤ. ⲠϢⲎⲢⲈ ⲚϨⲎⲖⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ⲠϢⲎⲢⲈ ⲘⲘⲀⲦⲐⲀⲦ ⲠϢⲎⲢⲈ ⲖⲖⲈⲨⲈⲒ ⲠϢⲎⲢⲈ ⲘⲘⲈⲖⲬⲈⲒ ⲠϢⲎⲢⲈ ⲚⲒⲀⲚⲚⲀⲒ ⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ. ");
INSERT INTO copshc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ⲠϢⲎⲢⲈ ⲘⲘⲀⲐⲐⲀⲐⲒⲀⲤ ⲠϢⲎⲢⲈ ⲚϨⲀⲘⲰⲤ ⲠϢⲎⲢⲈ ⲚⲚⲀⲞⲨⲘ ⲠϢⲎⲢⲈ ⲚⲚⲈⲤⲖⲒ ⲠϢⲎⲢⲈ ⲚⲀⲄⲄⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ⲠϢⲎⲢⲈ ⲘⲘⲀⲀⲐ ⲠϢⲎⲢⲈ ⲘⲘⲀⲦⲦⲀⲐⲒⲀⲤ ⲠϢⲎⲢⲈ ⲚⲤⲈⲘⲈⲈⲒⲚ ⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲬ ⲠϢⲎⲢⲈ ⲚⲒⲰⲆⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ⲠϢⲎⲢⲈ ⲚⲒⲰⲀⲚⲚⲀⲚ ⲠϢⲎⲢⲈ ⲚϨⲢⲎⲤⲀ ⲠϢϨⲢⲈ ⲚⲌⲞⲢⲞⲂⲀⲂⲈⲖ ⲠϢⲎⲢⲈ ⲚⲤⲀⲖⲀⲐⲒⲎⲖ ⲠϢⲎⲢⲈ ⲚⲎⲢⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ⲠϢⲎⲢⲈ ⲘⲘⲈⲖⲬⲈⲒ ⲠϢⲎⲢⲈ ⲚⲀⲆⲈⲒ ⲠϢⲎⲢⲈ ⲚⲔⲰⲤⲀⲘ ⲠϢⲎⲢⲈ ⲚⲈⲖⲘⲀⲆⲀⲆ ⲠϢⲎⲢⲈ ⲚⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ⲠϢⲎⲢⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲚⲈⲖⲒⲈⲌⲈⲢ ⲠϢⲎⲢⲈ ⲚⲒⲰⲢⲈⲒⲘ ⲠϢⲎⲢⲈ ⲘⲀⲐⲐⲀⲦ ⲠϢⲎⲢⲈ ⲖⲖⲈⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ⲠϢⲎⲢⲈ ⲚⲤⲨⲘⲈⲰⲚ ⲠϢⲎⲢⲈ ⲚⲒⲞⲨⲆⲀ ⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ ⲠϢⲎⲢⲈ ⲚⲒⲰⲀⲚⲚⲀⲘ ⲠϢⲎⲢⲈ ⲚⲈⲖⲒⲀⲔⲈⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ⲠϢⲎⲢⲈ ⲘⲘⲈⲖⲈⲀ ⲠϢⲎⲢⲈ ⲘⲘⲈⲚⲚⲀ ⲠϢⲎⲢⲈ ⲘⲘⲀⲦⲦⲀⲐⲀ ⲠϢⲎⲢⲈ ⲚⲚⲀⲐⲀⲘ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ⲠϢⲎⲢⲈ ⲚⲒⲈⲤⲤⲀⲒ ⲠϢⲎⲢⲈ ⲚⲒⲰⲂⲎⲆ ⲠϢⲎⲢⲈ ⲂⲂⲞⲈⲤ ⲠϢⲎⲢⲈ ⲚⲤⲀⲖⲀ ⲠϢⲎⲢⲈ ⲚⲚⲀⲀⲤⲤⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ⲠϢⲎⲢⲈ ⲚⲀⲆⲀⲘ ⲠϢⲎⲢⲈ ⲚⲀⲆⲀⲘⲈⲒⲚ ⲠϢⲎⲢⲈ ⲚⲚⲀⲢⲚⲒ ⲠϢⲎⲢⲈ ⲚⲚⲈⲤⲢⲰⲘ ⲠϢⲎⲢⲈ ⲘⲪⲀⲢⲈⲤ ⲠϢⲎⲢⲈ ⲚⲒⲞⲨⲆⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ⲠϢⲎⲢⲈ ⲚⲒⲀⲔⲰⲂ ⲠϢⲎⲢⲈ ⲚⲒⲤⲀⲀⲔ ⲠϢⲎⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲠϢⲎⲢⲈ ⲚⲐⲀⲢⲢⲀ ⲠϢⲎⲢⲈ ⲚⲀⲬⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ⲠϢⲎⲢⲈ ⲚⲤⲈⲢⲞⲨⲬ ⲠϢⲎⲢⲈ ⲚϨⲢⲎⲄⲀⲨ ⲠϢⲎⲢⲈ ⲘⲪⲀⲖⲈⲔ ⲠϢⲎⲢⲈ ⲚϨⲈⲂⲈⲢ ⲠϢⲎⲢⲈ ⲚⲤⲀⲖⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ⲠϢⲎⲢⲈ ⲚⲔⲀⲒⲚⲀⲘ ⲠϢⲎⲢⲈ ⲚⲀⲢⲪⲀⲜⲀⲆ ⲠϢⲎⲢⲈ ⲚⲤⲎⲘ ⲠϢⲎⲢⲈ ⲚⲚⲰϨⲈ ⲠϢⲎⲢⲈ ⲖⲖⲀⲘⲈⲬ. ");
INSERT INTO copshc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ⲠϢⲎⲢⲈ ⲘⲘⲀⲐⲞⲨⲤⲀⲖⲀ ⲠϢⲎⲢⲈ ⲚⲈⲚⲰⲬ ⲠϢⲎⲢⲈ ⲚⲒⲀⲢⲈⲦ ⲠϢⲎⲢⲈ ⲘⲘⲀⲖⲈⲎⲖ ⲠϢⲎⲢⲈ ⲚⲔⲀⲒⲚⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ⲠϢⲎⲢⲈ ⲚⲈⲚⲰⲤ ⲠϢⲎⲢⲈ ⲚⲤⲎⲐ ⲠϢⲎⲢⲈ ⲚⲀⲆⲀⲘ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲀϤⲔⲞⲦϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲈϤⲘⲞⲞϢⲈ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϨⲒⲦⲈⲢⲎⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ⲚϨⲘⲈ ⲚϨⲞⲞⲨ ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ϨⲒⲦⲚ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲀⲨⲰ ⲘⲠϤⲞⲨⲈⲘⲖⲀⲀⲨ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ⲚⲦⲈⲢⲞⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲀϤϨⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ⲠⲈϪⲈ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲚⲀϤ ϪⲈ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀϪⲒⲤ ⲘⲠⲈⲒⲰⲚⲈ ϪⲈ ⲈϤⲈⲢⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ϤⲤⲎϨ ϪⲈ ⲚⲈⲢⲈⲠⲢⲰⲘⲈ ⲚⲀⲰⲚϨ ⲀⲚ ⲈⲠⲞⲈⲒⲔ ⲘⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ⲀϤϪⲒⲦϤ ⲆⲈ ⲈϨⲢⲀⲈⲒ ⲀϤⲦⲞⲨⲞϤ ⲈⲘⲘⲚⲦⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲚⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ϨⲚ ⲞⲨⲤⲦⲒⲄⲘⲎ ⲚⲞⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ⲠⲈϪⲈ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ. ϮϮ ⲚⲀⲔ ⲚⲦⲈⲒⲈⲜⲞⲨⲤⲒⲀ ⲦⲎⲢⲤ ⲘⲚ ⲠⲈⲨⲈⲞⲞⲨ ϪⲈ ⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲀⲈⲒ ⲀⲨⲰ ϢⲀⲒⲦⲀⲀⲤ ⲘⲠⲈϮⲞⲨⲀϢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ⲚⲦⲞⲔ ϬⲈ ⲈⲔϢⲀⲚⲞⲨⲰϢⲦ ⲘⲠⲀⲘⲦⲞ ⲈⲂⲞⲖ ⲤⲚⲀϢⲰⲠⲈ ⲚⲀⲔ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲤⲎϨ ϪⲈ ⲈⲔⲚⲀⲞⲨⲰϢⲦ ⲘⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲈⲔⲚⲀϢⲘϢⲈ ⲚⲀϤ ⲞⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ⲀϤⲚⲦϤ ⲆⲈ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲈϪⲚ ⲠⲦⲚϨ ⲘⲠⲈⲢⲠⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ϤⲞϬⲔ ⲈⲠⲈⲤⲎⲦ ϨⲒϪⲚ ⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ϤⲚⲀϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲂⲎⲎⲦⲔ ⲈⲦⲢⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ⲀⲨⲰ ⲚⲤⲈϤⲒⲦⲔ ⲈϪⲚ ⲚⲈⲨϬⲒϪ ⲘⲎⲠⲞⲦⲈ ⲚⲄϪⲰⲢⲠ ⲈⲨⲰⲚⲈ ⲚⲦⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲨϪⲞⲞⲤ ϪⲈ ⲚⲚⲈⲔⲠⲈⲒⲢⲀⲌⲈ ⲘⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ⲚⲦⲈⲢⲈϤϪⲈⲔ ⲠⲈⲒⲢⲀⲤⲘⲞⲤ ⲆⲈ ⲚⲒⲘ ⲈⲂⲞⲖ. ⲀⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲤⲀϨⲰⲰϤ ⲈⲂⲞⲖ ⲘⲘⲞϤ ϢⲀⲞⲨⲞⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ⲀⲨⲰ ⲀϤⲔⲞⲦϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲦϬⲞⲘ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲠⲤⲞⲒⲦ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤϮⲤⲂⲰ ⲠⲈ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲢⲈⲢⲰⲘⲈ ⲚⲒⲘ ϮⲈⲞⲞⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ⲀϤⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲚⲀⲌⲀⲢⲈⲐ ⲠⲘⲀ ⲈⲚⲦⲀⲨⲤⲀⲚⲞⲨϢϤ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲔⲀⲦⲀⲠⲈϤⲤⲰⲚⲦ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲈⲰϢ ");
INSERT INTO copshc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ⲀⲨⲰ ⲀⲨϮ ⲚⲀϤ ⲘⲠϪⲰⲰⲘⲈ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲀϤⲞⲨⲰⲚ ⲆⲈ ⲘⲠϪⲰⲰⲘⲈ ⲀϤϨⲈ ⲈⲠⲘⲀ ⲈⲦⲤⲎϨ. ");
INSERT INTO copshc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠϪⲞⲈⲒⲤ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀϤⲦⲀϨⲤⲦ ⲀϤⲦⲚⲚⲞⲞⲨⲦ ⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲚϨⲎⲔⲈ ⲈⲦⲀϢⲈⲞⲒϢ ⲚⲞⲨⲔⲰ ⲈⲂⲞⲖ ⲚⲀⲒⲬⲘⲀⲖⲰⲦⲞⲤ ⲚⲘⲞⲨⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲂⲂⲖⲖⲈ. ⲈϪⲞⲞⲨ ⲚⲚⲈⲦⲞⲨⲞϢϤ ⲚⲞⲨⲔⲰ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲆⲈ ⲚⲦⲈⲢⲞⲘⲠⲈ ⲘⲠϪⲞⲈⲒⲤ ⲈⲦϢⲎⲠ. ");
INSERT INTO copshc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ⲀϤⲔⲂⲠϪⲰⲰⲘⲈ ⲆⲈ ⲀϤⲦⲀⲀϤ ⲘⲠϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀϤϨⲘⲞⲞⲤ. ⲀⲨⲰ ⲚⲈⲢⲈⲂⲂⲀⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϨⲚⲦⲤⲨⲚⲀⲄⲰⲄⲎ ϬⲰϢⲦ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ⲀϤⲀⲢⲬⲒ ⲆⲈ ⲚϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ⲘⲠⲞⲞⲨ ⲀⲦⲈⲒⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲚⲘⲀⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ⲀⲨⲰ ⲚⲈⲢⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲢⲘⲚⲦⲢⲈ ⲚⲘⲘⲀϤ ⲈⲨⲢϢⲠⲎⲢⲈ ⲚⲚϢⲀϪⲈ ⲚⲦⲈⲬⲀⲢⲒⲤ ⲚⲀⲒ ⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲢⲰϤ. ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ ⲀⲚ ⲠⲈ ⲠⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲠⲀⲚⲦⲰⲤ ⲦⲈⲦⲚⲀϪⲰ ⲚⲀⲒ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲠⲤⲀⲈⲒⲚ ⲀⲢⲒⲠⲀϨⲢⲈ ⲈⲢⲞⲔ. ⲚⲈⲚⲦⲀⲚⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ϪⲈ ⲀⲨϢⲰⲠⲈ ϨⲚ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ⲀⲢⲒⲤⲞⲨ ϨⲰⲞⲨ ϨⲘ ⲠⲈⲒⲘⲀ ϨⲘ ⲠⲈⲔϮⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ⲠⲈϪⲀϤ ⲆⲈ. ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲚⲖⲀⲀⲨ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ϢⲎⲠ ϨⲘ ⲠⲈϤϮⲘⲈ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ϨⲚ ⲞⲨⲘⲈ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲈⲨⲚϨⲀϨ ⲚⲬⲎⲢⲀ ⲠⲈ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚϨⲎⲖⲈⲒⲀⲤ ⲚⲦⲈⲢⲈⲦⲠⲈ ϢⲦⲀⲘ ⲚϢⲞⲘⲦⲈ ⲢⲢⲞⲘⲠⲈ ⲚⲘⲤⲞⲞⲨ ⲚⲈⲂⲞⲦ ⲚⲦⲈⲢⲈⲞⲨⲚⲞϬ ⲚϨⲈⲂⲰⲰⲚ ϢⲰⲠⲈ ϨⲒϪⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ⲀⲨⲰ ⲘⲠⲞⲨϪⲈⲨ ϨⲎⲖⲈⲒⲀⲤ ϢⲀⲖⲀⲀⲨ ⲘⲘⲞⲞⲨ. ⲈⲒⲘⲎⲦⲒ ⲈⲤⲀⲢⲈⲠⲦⲀ ⲚⲦⲈⲦⲤⲒⲆⲰⲚⲒⲀ ϢⲀⲞⲨⲤϨⲒⲘⲈ ⲚⲬⲎⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ⲀⲨⲰ ⲚⲈⲨⲚϨⲀϨ ⲈⲨⲤⲞⲂⲀϨ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ. ϨⲒⲈⲖⲒⲤⲤⲀⲒⲞⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲰ ⲘⲠⲈⲖⲀⲀⲨ ⲘⲘⲞⲞⲨ ⲦⲂⲂⲞ ⲚⲤⲀⲚⲀⲒⲘⲀⲚ ⲠⲤⲨⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ⲀⲨⲘⲞⲨϨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚϬⲰⲚⲦ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲨⲤⲰⲦⲘ ⲈⲚⲀⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ⲀⲨⲰ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲀⲨⲚⲞϪϤ ⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲈⲒⲤ ⲀⲨⲚⲦϤ ϢⲀⲠⲔⲞⲞϨ ⲘⲠⲦⲞⲞⲨ ⲈⲦⲈⲢⲈ ⲦⲈⲨⲠⲞⲖⲈⲒⲤ ⲔⲎⲦ ϨⲒϪⲰϤ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲨⲚⲞϪϤ ⲈⲂⲞⲖ ⲚϪⲞϤⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ⲀϤⲈⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲦⲠⲞⲖⲈⲒⲤ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲀⲨⲰ ⲚⲈϤϮⲤⲂⲰ ⲠⲈ ϨⲚ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲤⲂⲰ ϪⲈ ⲚⲈⲢⲈⲠⲈϤϢⲀϪⲈ ϢⲞⲞⲠ ⲠⲈ ϨⲚ ⲞⲨⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ⲀⲨⲰ ⲚⲈⲞⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲠⲈ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ");
INSERT INTO copshc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ϪⲈ ⲀϨⲢⲞⲔ ⲚⲘⲘⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲢⲘⲚⲀⲌⲀⲢⲈⲐ ⲀⲔⲒ ⲈⲦⲀⲔⲞⲚ. ϮⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲔⲚⲒⲘ ⲚⲦⲔⲠⲈⲦⲞⲨⲀⲀⲂ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲘ ⲢⲢⲰⲔ ⲚⲄⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ⲀϤⲚⲞⲨϪⲈ ⲆⲈ ⲘⲘⲞϤ ⲚϬⲒ ⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲦⲘⲎⲦⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲈⲘⲠϤⲂⲂⲖⲀⲠⲦⲈ ⲘⲘⲞϤ ⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ⲀⲨϢⲦⲞⲢⲦⲢ ⲆⲈ ϢⲰⲠⲈ ⲈϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲨϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲈⲒϢⲀϪⲈ ϪⲈ ϨⲚ ⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲚⲘⲞⲨϬⲞⲘ ⲈϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲤⲈⲚⲎⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ⲀⲠⲤⲞⲈⲒⲦ ⲆⲈ ⲘⲞⲞϢⲈ ⲈⲦⲂⲎⲎⲦϤ ϨⲘ ⲘⲀ ⲚⲒⲘ ⲚⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ. ⲦϢⲰⲘⲈ ⲆⲈ ⲚⲤⲒⲘⲰⲚ ⲚⲈⲨⲚⲞⲨⲚⲞϬ ⲚϨⲘⲞⲘ ϨⲒⲰⲰⲤ ⲠⲈ. ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ⲈⲦⲂⲎⲦⲤ ");
INSERT INTO copshc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲒϪⲰⲤ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲈϨⲘⲞⲘ ⲀϤⲔⲀⲀⲤ. ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲤⲦⲰⲞⲨⲚⲤ ⲀⲤⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ⲈⲢⲈⲠⲢⲎ ⲆⲈ ⲚⲀϨⲰⲦⲠ. ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈⲨⲚⲦⲞⲨⲢⲰⲘⲈ ⲈϤϢⲰⲚⲈ ϨⲚ ϨⲈⲚϢⲰⲚⲈ ⲈⲨϢⲞⲂⲈ ⲀⲨⲚⲦⲞⲨ ⲚⲀϤ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲦⲀⲖⲈⲦⲞⲞⲦϤ ⲈϪⲘ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ ⲀϤⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ⲚⲈⲢⲈⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲆⲈ ⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲚ ϨⲀϨ ⲠⲈ ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲚⲈϤⲀⲒⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ⲈⲚϤⲔⲰ ⲘⲘⲞⲞⲨ ⲀⲚ ⲈϢⲀϪⲈ ϪⲈ ⲚⲈⲨⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲞϤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ⲚⲦⲈⲢⲈϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲂⲰⲔ ⲈⲨⲘⲀ ⲚϪⲀⲒⲈ. ⲚⲈⲢⲈⲘⲘⲎⲎϢⲈ ⲆⲈ ϢⲒⲚⲈ ⲚⲤⲰϤ ⲠⲈ ⲀⲨⲈⲒ ϢⲀⲢⲞϤ ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲈⲦⲘⲂⲰⲔ ⲈⲔⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲀⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲚⲔⲈⲠⲞⲖⲈⲒⲤ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨⲦ ⲄⲀⲢ ⲈⲠⲈⲒϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ⲚⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲆⲈ ⲠⲈ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚϮⲞⲨⲆⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲘⲘⲎⲎϢⲈ ϢⲞⲨⲞ ⲈϪⲰϤ ⲚⲤⲈⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ⲠⲈ ϨⲀⲦⲚⲦⲖⲒⲘⲚⲎ ⲚⲄⲈⲚⲚⲎⲌⲀⲢⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ⲀϤⲚⲀⲨ ⲆⲈ ⲈϪⲞⲒ ⲤⲚⲀⲨ ⲈⲨⲘⲞⲞⲚⲈ ϨⲀⲦⲚ ⲦⲖⲒⲘⲚⲎ ⲚⲈⲀⲚⲞⲨⲰϨⲈ ⲆⲈ ⲠⲈ ⲠⲈ ⲈϨⲢⲀⲒ ϨⲒⲰⲞⲨ ⲈⲨⲒⲰ ⲚⲚⲈⲨϢⲚⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ⲀϤⲀⲖⲈ ⲆⲈ ⲈⲨⲀ ⲚⲚϪⲞⲒ ⲈⲠⲀⲤⲒⲘⲰⲚ ⲠⲈ. ⲀϤϪⲞⲞⲤ ⲚⲀϤ ⲈⲦⲢⲈϤϨⲒⲚⲈ ⲈⲂⲞⲖ ⲘⲠⲈⲔⲢⲞ ⲚⲞⲨⲔⲞⲨⲒ. ⲀϤϨⲘⲞⲞⲤ ⲆⲈ ϨⲒⲠϪⲞⲈⲒ ⲀϤϮⲤⲂⲰ ⲚⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ⲚⲦⲈⲢⲈϤⲞⲨⲰ ⲆⲈ ⲈϤϢⲀϪⲈ ⲠⲈϪⲀϤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲔⲦⲈⲦⲎⲨⲦⲚ ⲈⲦⲚⲞⲨⲦ ⲚⲦⲈⲦⲚⲬⲀⲖⲀ ⲚⲚⲈϢⲚⲎⲞⲨ ⲈϬⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ⲀⲤⲒⲘⲰⲚ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲀⲚϢⲈⲠϨⲒⲤⲈ ϨⲚ ⲦⲈⲨϢⲎ ⲦⲎⲢⲤ ⲘⲠⲚϬⲈⲠⲖⲀⲀⲨ ⲈⲦⲂⲈ ⲠⲈⲔϢⲀϪⲈ ⲆⲈ ϮⲚⲀⲬⲀⲖⲀ ⲚⲚⲈϢⲚⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ⲚⲦⲈⲢⲞⲨⲢⲠⲀⲒ ⲆⲈ ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲞⲨⲘⲎⲎϢⲈ ⲚⲦⲂⲦ ⲈⲚⲀϢⲰϤ. ⲚⲈⲢⲈⲚⲈϢⲚⲎⲞⲨ ⲆⲈ ⲚⲀⲠⲰϨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ⲀⲨϪⲰⲢⲘ ⲆⲈ ⲞⲨⲂⲈ ⲚⲈⲨⲔⲈϢⲂⲈⲈⲢ ⲈⲦϨⲒⲠⲔⲈϪⲞⲒ ⲈⲦⲢⲈⲨⲈⲒ ⲚⲤⲈϮⲦⲞⲞⲦⲞⲨ ⲚⲘⲘⲀⲨ. ⲀⲨⲈⲒ ⲆⲈ ⲀⲨⲘⲈϨⲠϪⲞⲈⲒ ⲤⲚⲀⲨ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲨⲰⲘⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲠⲀⲒ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲀϤⲠⲀϨⲦϤ ϨⲀⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲀϨⲰⲔ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ϪⲈ ⲀⲚⲄⲞⲨⲢⲰⲘⲈ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ⲚⲈⲀⲨϨⲞⲦⲈ ⲄⲀⲢ ⲦⲀϨⲞϤ ⲚⲘⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲘⲘⲀϤ ⲈϪⲚ ⲦⲤⲞⲞⲨϨⲤ ⲚⲚⲦⲂⲦ ⲈⲚⲦⲀⲨϬⲞⲠⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲠⲔⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲚϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲚⲎ ⲈⲚⲈⲨⲞ ⲚⲔⲞⲒⲚⲰⲚⲞⲤ ⲚⲘⲤⲒⲘⲰⲚ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ϪⲒⲚⲦⲈⲚⲞⲨ ⲄⲀⲢ ⲔⲚⲀϢⲰⲠⲈ ⲈⲔϬⲈⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ⲀⲨⲘⲀⲚⲈⲚⲈϪⲎⲨ ⲆⲈ ⲈⲠⲈⲔⲢⲞ ⲀⲨⲔⲀⲚⲔⲀ ⲚⲒⲘ ⲚⲤⲰⲞⲨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤϨⲚⲞⲨⲈⲒ ⲚⲘⲠⲞⲖⲒⲤ ⲈⲒⲤⲞⲨⲢⲰⲘⲈ ⲈϤⲘⲈϨ ⲚⲤⲰⲂⲀϨ ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲠⲀϨⲦϤ ⲚⲀϤ ⲈϪⲘⲠⲈϤϨⲞ ⲀϤⲤⲈⲠⲤⲰⲠϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲔϢⲀⲚⲞⲨⲰϢ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲂⲂⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ⲀϤⲤⲞⲨⲦⲚⲦⲈϤϬⲒϪ ⲆⲈ ⲈⲂⲞⲖ ⲀϤϪⲰϨ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ⲦⲂⲂⲞ. ⲀⲨⲰ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲀⲠⲤⲰⲂⲀϨ ⲔⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲚⲀϤ ϪⲈ ⲘⲠⲢϪⲞⲞⲤ ⲈⲖⲀⲀⲨ ⲀⲖⲖⲀ ⲂⲰⲔ ⲚⲄⲦⲞⲨⲞⲔ ⲈⲠⲞⲨⲎⲎⲂ ⲚⲄⲦⲀⲖⲞ ⲈϨⲢⲀⲒ ϨⲀⲠⲈⲔⲦⲂⲂⲞ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲘⲰⲨⲤⲎⲤ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ⲚⲈⲢⲈⲠϢⲀϪⲈ ⲆⲈ ⲘⲞⲞϢⲈ ⲈⲦⲂⲎⲎⲦϤ ⲀⲨⲰ ⲚⲈⲢⲈⲘⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲤⲰⲦⲘ ⲈⲢⲞϤ ⲀⲨⲰ ⲈⲦⲀⲖϬⲞⲞⲨ ϨⲚ ⲚⲈⲨϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤⲤⲒϨⲈ ⲘⲘⲞϤ ⲠⲈ ⲈϨⲈⲚⲘⲀ ⲚϪⲀⲒⲈ ⲈϤϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤϮⲤⲂⲰ ϨⲚ ⲞⲨϨⲞⲞⲨ ⲈⲢⲈ ϨⲈⲚⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϨⲘⲞⲞⲤ ⲚⲘ ϨⲈⲚⲚⲞⲘⲞⲆⲒⲆⲀⲤⲔⲀⲖⲞⲤ ⲚⲀⲒ ⲈⲚⲦⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲘⲈ ⲚⲒⲘ ⲚⲦⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲚⲘϮⲞⲨⲆⲀⲒⲀ ⲚⲘⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲚⲈⲢⲈⲦϬⲞⲘ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ϢⲞⲞⲠ ⲠⲈ ⲈⲦⲢⲈϤⲦⲀⲖϬⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ⲈⲒⲤϨⲈⲚⲢⲰⲘⲈ ⲆⲈ ⲀⲨⲚⲞⲨⲢⲰⲘⲈ ⲈϤⲤⲎϬ ϨⲒϪⲚ ⲞⲨⲘⲀ ⲚⲄⲔⲞⲦⲔ ⲀⲨⲰ ⲚⲈⲨϢⲒⲚⲈ ⲠⲈ ⲚⲤⲀϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲔⲀⲀϤ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ⲘⲠⲞⲨϨⲈ ⲆⲈ ⲈⲦⲈϨⲒⲎ ⲚϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦϪⲈⲚⲈⲠⲰⲢ ⲀⲨⲬⲀⲖⲀ ⲘⲘⲞϤ ⲈⲠⲈⲤⲎⲦ ϨⲒⲦⲚ ⲚⲔⲈⲢⲀⲘⲞⲤ ⲘⲚ ⲠⲈϬⲖⲞϬ ⲈⲦⲈⲨⲘⲎⲦⲈ ⲘⲠⲈⲨⲦⲞ ⲈⲂⲞⲖ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲦⲈⲨⲠⲒⲤⲦⲒⲤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲢⲰⲘⲈ ⲚⲈⲔⲚⲞⲂⲈ ⲔⲎ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ⲀⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲆⲈ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲀⲢⲬⲒ ⲘⲘⲞⲔⲘⲈⲔ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲚⲒⲘ ⲠⲈ ⲠⲀⲒ ⲈⲦϪⲒⲞⲨⲀ. ⲚⲒⲘ ⲠⲈⲦⲈⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲚⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ ⲚⲤⲀⲠⲚⲞⲨⲦⲈ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲒⲘⲈ ⲈⲚⲈⲨⲘⲞⲔⲘⲈⲔ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲘⲈⲈⲨⲈ ϨⲚ ⲈⲦⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ⲀϢ ⲄⲀⲢ ⲠⲈⲦⲘⲞⲦⲚ ϪⲞⲞⲤ ⲠⲈ ϪⲈ ⲚⲈⲔⲚⲞⲂⲈ ⲔⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ϪⲈⲚϪⲞⲞⲤ ⲠⲈϪⲈⲦⲰⲞⲨⲚ ⲚⲄⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ϪⲈ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ϪⲈ ⲞⲨⲚⲦⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲜⲞⲨⲤⲒⲀ ϨⲒϪⲚ ⲠⲔⲀϨ ⲈⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ. ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲤⲎϬ ϪⲈ. ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲦⲰⲞⲨⲚ ⲚⲄϤⲒ ⲘⲠⲈⲔϬⲖⲞϬ ⲚⲄⲂⲰⲔ ⲈⲠⲈⲔⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲘⲠⲈⲨⲘⲦⲞ ⲈⲂⲞⲖ ⲀϤϤⲒ ⲘⲠⲈϤϬⲖⲞϬ ⲀϤⲂⲰⲔ ⲈⲠⲈϤⲎⲒ ⲈϤϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲘⲞⲨϨ ⲚϨⲞⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈϨⲈⲚϢⲠⲎⲢⲈ ⲘⲠⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲚⲀⲨ ⲈⲨⲦⲈⲖⲰⲚⲎⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲖⲈⲨⲈⲒ ⲈϤϨⲘⲞⲞⲤ ϨⲒⲠⲈϤⲦⲈⲖⲰⲚⲒⲞⲚ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ⲀϤⲔⲀⲚⲔⲀ ⲆⲈ ⲚⲒⲘ ⲚⲤⲰϤ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ⲀⲨⲰ ⲀⲖⲈⲨⲈⲒ ⲢⲞⲨⲚⲞϬ ⲚϢⲞⲠⲤ ⲈⲢⲞϤ ϨⲘ ⲠⲈϤⲎⲒ. ⲚⲈⲨⲚⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲚⲦⲈⲖⲰⲚⲎⲤ ⲚⲘϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲘⲘⲀⲨ ⲈⲨⲚⲎϪ. ");
INSERT INTO copshc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ⲀⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲔⲢⲘⲢⲘ ⲈϨⲞⲨⲚ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲞⲨⲰⲘ ⲀⲨⲰ ⲦⲈⲦⲚⲤⲰ ⲚⲘⲚⲦⲈⲖⲰⲚⲎⲤ ⲀⲨⲰ ⲢⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲚⲈⲦⲦⲎⲔ ⲚⲤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲘⲠⲤⲀⲈⲒⲚ. ⲀⲖⲖⲀ ⲚⲈⲦⲘⲞⲔϨ ⲚⲈⲦⲢⲬⲢⲒⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ⲚⲦⲀⲒⲈⲒ ⲀⲚ ⲈⲦⲈϨⲘⲚⲆⲒⲔⲀⲒⲞⲤ. ⲀⲖⲖⲀ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲤⲈⲚⲎⲤⲦⲈⲨⲈ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲀⲨⲰ ⲤⲈϢⲖⲎⲖ ⲚⲦⲞⲞⲨ ⲚⲘⲚⲀ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ⲚⲞⲨⲔ ⲆⲈ ⲞⲨⲰⲘ ⲀⲨⲰ ⲤⲈⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ⲠⲈϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲘⲎ ⲞⲨⲚϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲦⲢⲈⲚϢⲎⲢⲈ ⲘⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ ⲚⲎⲤⲦⲈⲨⲈ ⲈⲢⲈ ⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ⲞⲨⲚϨⲈⲚϨⲞⲞⲨ ⲆⲈ ⲚⲎⲞⲨ ⲈⲨⲚⲀϤⲒ ⲘⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲚⲦⲞⲞⲦⲞⲨ. ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲎⲤⲦⲈⲨⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ⲀϤϪⲰ ⲆⲈ ⲚⲀⲨ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ. ϪⲈ ⲘⲈⲢⲈⲖⲀⲀⲨ ⲤⲖⲠⲞⲨⲦⲞⲒⲤ ϨⲒⲞⲨϢⲦⲎⲚ ⲚϢⲀⲒ ⲚϤⲦⲞⲢⲠⲤ ⲈⲨϢⲦⲎⲚ ⲘⲠⲖϬⲈ. ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ϤⲚⲀⲠⲀϨⲦⲔⲈϢⲦⲎⲚ ⲚϢⲀⲒ ⲚⲦⲈⲦⲘⲦⲦⲞⲒⲤ ⲚϢⲀⲒ ⲢϢⲀⲨ ⲈⲦⲠⲖϬⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ⲀⲨⲰ ⲘⲈⲢⲈⲖⲀⲀⲨ ⲚⲞⲨϪⲈ ⲚⲞⲨⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲈϨⲈⲚϨⲰⲦ ⲚⲀⲤ ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ϢⲀⲢⲈⲠⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲠⲈϨⲚϨⲰⲦ ⲚϤⲠⲰⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲔⲈϨⲰⲦ ⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ⲀⲖⲖⲀ ⲈϢⲀⲨⲚⲈϪⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲈϨⲈⲚϨⲰⲦ ⲂⲂⲢⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ⲘⲈⲢⲈⲖⲀⲀⲨ ⲆⲈ ⲞⲨⲈϢⲎⲢⲠ ⲂⲂⲢⲢⲈ ⲈϤⲤⲈⲢⲠ ⲀⲤ. ϢⲀϤϪⲞⲞⲤ ⲄⲀⲢ ϪⲈ ⲚⲈϤⲢⲠⲈⲢⲠ ⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲘⲘⲀ ⲈⲦϪⲎⲨ ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϬⲰⲚϬ ⲚⲚϨⲘⲤ ⲀⲨⲤⲈϨⲤⲰϨⲞⲨ ⲚⲚⲈⲨϬⲒϪ ⲀⲨⲞⲨⲰⲘ ");
INSERT INTO copshc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ⲠⲈϪⲈϨⲞⲒⲚⲈ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲒⲢⲈ ⲘⲠⲈⲦⲈⲘⲈϢϢⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲘⲠⲈⲦⲚⲈϢⲠⲀⲒ ⲈⲀⲆⲀⲨⲈⲒⲆ ⲀⲀϤ ⲚⲦⲈⲢⲈϤϨⲔⲞ ⲚⲦⲞϤ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ϪⲈ ⲚⲚⲀϢ ⲚϨⲈ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤϪⲒ ⲚⲚⲚⲞⲈⲒⲔ ⲚⲦⲈⲠⲢⲞⲐⲈⲤⲒⲤ ⲀϤⲞⲨⲞⲘⲞⲨ ⲀⲨⲰ ⲀϤϮ ⲚⲚⲈⲦⲚⲘⲘⲀϤ ⲚⲀⲒ ⲈⲦⲈⲘⲈϢϢⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲞⲘⲞⲨ ⲈⲒⲘⲎⲦⲒ ⲞⲨⲎⲎⲂ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲚϤϮⲤⲂⲰ ⲀⲨⲰ ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲘⲘⲀⲨ ⲠⲈ ⲈⲢⲈⲦⲈϤϬⲒϪ ⲚⲞⲨⲚⲀⲘ ϢⲞⲨⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ⲚⲈⲨⲠⲀⲢⲀⲦⲎⲢⲒ ⲆⲈ ⲈⲢⲞϤ ⲠⲈ ⲚϬⲒ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲚⲈⲚⲈⲚϤⲚⲀⲢⲠⲀϨⲢⲈ ⲈⲢⲞϤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈ ⲈⲨⲈϨⲈ ⲈⲐⲈ ⲚⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤⲤⲞⲞⲨⲚ ⲚⲚⲈⲨⲘⲞⲔⲘⲈⲔ ⲠⲈϪⲀϤ ⲆⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲈⲢⲈⲦⲈϤϬⲒϪ ϢⲞⲨⲰⲞⲨ ϪⲈ ⲦⲰⲞⲨⲚ ⲀϨⲈⲢⲀⲦⲔ ⲚⲦⲘⲎⲦⲈ ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲀϤⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ϮⲚⲀϪⲚⲈ ⲦⲎⲞⲨⲦⲚ ϪⲈ ⲈⲚⲈⲈⲜⲈⲤⲦⲒ ⲈⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈⲚⲈⲢⲠⲈⲐⲞⲞⲨ. ⲈⲦⲞⲨϪⲈⲞⲨⲮⲨⲬⲎ ϪⲈⲚⲈⲦⲀⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ⲀϤⲔⲦⲈⲒⲀⲦϤ ⲆⲈ ⲚϨⲎⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲞⲨⲦⲚⲦⲈⲔϬⲒϪ ⲈⲂⲞⲖ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲤⲞⲨⲦⲰⲚⲤ. ⲀⲨⲰ ⲀⲦⲈϤϬⲒϪ ⲖⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲘⲞⲨϨ ⲘⲘⲚⲦⲀⲐⲎⲦ ⲀⲨⲘⲈⲔⲘⲞⲨⲔⲞⲨ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲈⲚⲚⲀⲢ ⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲚⲈⲒϨⲞⲞⲨ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲦⲞⲞⲨ ⲈϢⲖⲎⲖ ⲀⲨⲰ ⲚⲈϤⲞ ⲚⲞⲨϢⲎ ⲢⲢⲞⲈⲒⲤ ⲠⲈ ϨⲘ ⲠⲈϢⲖⲎⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ⲀⲨⲰ ⲚⲦⲈⲢⲈϨⲦⲞⲞⲨⲈ ϢⲰⲠⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲤⲈⲦⲠ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲀⲒ ⲈⲚⲦⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ⲤⲒⲘⲰⲚ ⲠⲈⲚⲦⲀⲨϮⲢⲒⲚϤ ⲈⲠⲈⲦⲢⲞⲤ ⲚⲘⲀⲚⲆⲢⲈⲀⲤ ⲠⲈϤⲤⲞⲚ. ⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ. ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲘⲂⲀⲢⲐⲞⲖⲞⲘⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ⲚⲘⲘⲀⲐⲐⲀⲒⲞⲤ ⲚⲘⲐⲰⲘⲀⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲚⲀⲖⲪⲀⲒⲞⲤ ⲚⲘⲤⲒⲘⲰⲚ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲌⲎⲖⲰⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ⲚⲘⲒⲞⲨⲆⲀⲤ ⲠϢⲎⲢⲈ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲠⲀⲒ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲘⲠⲢⲞⲆⲞⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ⲀϤⲈⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲚⲘⲘⲀⲨ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲒⲞⲨⲘⲀ ⲈϤⲞⲨⲞϢⲤ. ⲀⲨⲰ ⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲘⲞⲨⲘⲎⲎϢⲈ ⲈϤⲞϢ ⲚⲦⲈⲠⲖⲀⲞⲤ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲚⲘⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲘⲦⲠⲀⲢϨⲀⲖⲒⲀ ⲚⲦⲨⲢⲞⲤ ⲚⲘⲤⲒⲆⲰⲚ ");
INSERT INTO copshc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ⲚⲀⲒ ⲈⲚⲦⲀⲨⲈⲒ ⲈⲤⲰⲦⲘ ⲈⲢⲞϤ ⲀⲨⲰ ⲈⲦⲀⲖϬⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨϢⲰⲚⲈ ⲀⲨⲰ ⲚⲈⲦⲘⲞⲔϨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲀⲨⲦⲀⲖϬⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲦⲎⲢϤ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲀϪⲰϨ ⲈⲢⲞϤ ⲠⲈ ϪⲈ ⲚⲈⲢⲈⲞⲨϬⲞⲘ ⲚⲎⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲈⲤⲦⲀⲖϬⲞ ⲘⲘⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ⲚⲦⲞϤ ⲆⲈ ⲀϤϤⲒⲀⲦϤ ⲈϨⲢⲀⲒ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ϪⲈ. ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚϨⲎⲔⲈ ϪⲈ ⲦⲰⲞⲨ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲚⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ⲚⲀⲒⲀⲦⲦⲎⲨⲦⲚ ⲚⲈⲦϨⲔⲀⲈⲒⲦ ⲦⲈⲚⲞⲨ ϪⲈ ⲦⲈⲦⲚⲀⲤⲈⲒ. ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲢⲒⲘⲈ ⲦⲈⲚⲞⲨ ϪⲈ ⲤⲈⲚⲀⲤⲰⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ⲚⲀⲒⲀⲦⲦⲎⲞⲨⲦⲚ ⲈⲢϢⲀⲚⲢⲰⲘⲈ ⲚⲒⲘ ⲘⲈⲤⲦⲰⲦⲚ ⲚⲤⲈⲠⲢϪⲦⲎⲞⲨⲦⲚ ⲈⲂⲞⲖ. ⲚⲤⲈⲚⲞϬⲚⲈϬ ⲘⲘⲰⲦⲚ ⲚⲤⲈⲦⲤⲦⲈ ⲠⲈⲦⲚⲢⲀⲚ ⲈⲂⲞⲖ ϨⲰⲤⲠⲞⲚⲎⲢⲞⲤ ⲈⲦⲂⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ⲢⲀϢⲈ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲦⲚⲦⲈⲖⲎⲖ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲠⲈⲦⲚⲂⲈⲔⲈ ϤⲚⲀϢⲰⲠⲈ ⲈⲚⲀϢⲰϤ ϨⲚ ⲦⲠⲈ. ⲚⲈⲢⲈⲚⲈⲨⲒⲞⲦⲈ ⲄⲀⲢ ⲈⲒⲢⲈ ⲠⲈ ϨⲒⲚⲀⲈⲒ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲢⲢⲘⲘⲀⲞ ϪⲈ ⲀⲦⲈⲦⲚϪⲒ ⲘⲠⲈⲦⲚⲘⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲦⲤⲎⲞⲨ ⲦⲈⲚⲞⲨ ϪⲈ ⲦⲈⲦⲚⲀϨⲔⲞ. ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲦⲤⲰⲂⲈ ⲦⲈⲚⲞⲨ ϪⲈ ⲦⲈⲦⲚⲀⲢϨⲎⲂⲈ ⲚⲦⲈⲦⲚⲢⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲈⲢϢⲀⲚⲢⲢⲰⲘⲈ ⲦⲎⲢⲞⲨ ⲦⲀⲒⲈⲦⲎⲞⲨⲦⲚ. ⲚⲈⲨⲈⲒⲢⲈ ⲄⲀⲢ ⲚⲦⲈⲒϨⲈ ⲠⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ. ");
INSERT INTO copshc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲚⲈⲦⲤⲰⲦⲘ ⲈⲢⲞⲒ ϪⲈ ⲘⲈⲢⲈⲚⲈⲦⲚϪⲒϪⲈⲞⲨ ⲀⲢⲒⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲚⲈⲦⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ⲤⲘⲞⲨ ⲈⲚⲈⲦⲤⲀϨⲞⲨ ⲘⲘⲰⲦⲚ. ϢⲖⲎⲖ ⲈϪⲚ ⲚⲈⲦⲠⲎⲦ ⲚⲤⲰⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ⲠⲈⲦⲚⲀⲢⲀϨⲦⲔ ⲈⲦⲈⲔⲞⲨⲞϬⲈ ⲔⲦⲞ ⲈⲢⲞϤ ⲚⲦⲔⲈⲞⲨⲈⲒ. ⲀⲨⲰ ⲔⲀⲦⲈⲔϢⲦⲎⲚ ⲈⲂⲞⲖ ⲚⲤⲀⲠⲈⲦϤⲒ ⲘⲠⲈⲔϨⲞⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ϮⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲀⲒⲦⲒ ⲘⲘⲞⲔ. ⲀⲨⲰ ⲚⲄⲦⲘⲦⲈⲤⲠⲈⲦϤⲒ ⲚⲚⲈⲦⲈⲚⲞⲨⲔ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ⲀⲨⲰ ⲚⲐⲈ ⲈⲦⲈⲦⲚⲞⲨⲈ ϢⲦⲢⲈⲢⲢⲰⲘⲈ ⲀⲀⲤ ⲚⲎⲦⲚ. ⲀⲢⲒⲤ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ⲀⲨⲰ ⲈϢϪⲈ ⲦⲈⲦⲚⲘⲈ ⲚⲚⲈⲦⲘⲈ ⲘⲘⲰⲦⲚ ⲀϢ ⲠⲈ ⲠⲈⲦⲚϨⲘⲞⲦ ⲔⲀⲒⲄⲀⲢ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ⲤⲈⲘⲈ ⲚⲚⲈⲦⲘⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ⲀⲨⲰ ⲈⲦⲈⲦⲚϢⲀⲢ ⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲚⲈϮⲢⲈ ⲚⲎⲦⲚ. ⲀϢ ⲠⲈ ⲠⲈⲦⲚϨⲘⲞⲦ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ϨⲰⲞⲨ ⲈⲒⲢⲈ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ⲈⲦⲈⲦⲚϢⲀⲚϮ ⲈⲘⲎⲤⲈ ⲚⲚⲈⲦⲈⲦⲚϨⲈⲖⲠⲒⲌⲈ ⲈϪⲒ ⲚⲦⲞⲞⲦⲞⲨ. ⲀϢ ⲠⲈ ⲠⲈⲦⲚϨⲘⲞⲦ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ϨⲰⲞⲨ ϮⲚⲢⲢⲈϤⲢⲚⲞⲂⲈ ϪⲈ ⲈⲨⲈϪⲒ ⲘⲠⲈⲨⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ⲠⲖⲎⲚ ⲘⲈⲢⲈⲚⲈⲦⲚϪⲒϪⲈⲞⲨ ⲚⲦⲈⲦⲚ ⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲦⲈⲦⲚ ϮⲈⲘⲎⲤⲈ ⲈⲚⲦⲈⲦⲚⲔⲰ ⲚϨⲦⲎⲦⲚ ⲀⲚ ⲈϪⲒⲖⲀⲀⲨ. ⲀⲨⲰ ⲠⲈⲦⲚⲂⲈⲔⲈ ⲚⲀϢⲰⲠⲈ ⲈⲚⲀϢⲰϤ ⲚⲦⲈⲦⲚϢⲰⲠⲈ ⲚϢⲎⲢⲈ ⲘⲠⲈⲦϪⲞⲤⲈ ϪⲈ ⲚⲦⲞϤ ⲞⲨⲬⲢⲎⲤⲦⲞⲤ ⲠⲈ ⲈϪⲚ ⲚⲈⲦⲈⲘⲈⲨϢⲠϨⲘⲞⲦ ⲚⲘⲘⲠⲞⲚⲎⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ϢⲰⲠⲈ ⲚϢⲀⲚϨⲦⲎϤ ϪⲈ ⲞⲨϢⲀⲚϨⲦⲎϤ ⲠⲈ ⲠⲈⲦⲚⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ⲘⲠⲢⲔⲢⲒⲚⲈ ϪⲈ ⲚⲚⲈⲨⲔⲢⲒⲚⲈ ⲘⲘⲰⲦⲚ. ⲘⲠⲢⲦϬⲀⲒⲞ ϪⲈ ⲚⲚⲈⲨⲦϬⲀⲒⲈⲦⲎⲨⲦⲚ. ⲔⲰ ⲈⲂⲞⲖ ⲦⲀⲢⲞⲨⲔⲰ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ϮⲦⲀⲢⲞⲨϮ ⲚⲎⲦⲚ ⲚⲞⲨϢⲒ ⲈⲚⲀⲚⲞⲨϤ ⲈϤⲦⲈϬⲦⲰϬ ⲈϤⲚⲈϨⲚⲞⲨϨ ⲈϤⲠⲎⲚ ⲈⲂⲞⲖ ⲤⲈⲚⲀⲦⲀⲀϤ ⲈⲔⲞⲨⲚⲦ ⲦⲎⲞⲨⲦⲚ. ϨⲘ ⲠϢⲒ ⲄⲀⲢ ⲈⲦⲈⲦⲚⲀϢⲒ ⲘⲘⲞϤ ⲈⲨⲚⲀϢⲒ ⲚⲎⲦⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ⲀϤϪⲰ ⲆⲈ ⲚⲀⲨ ⲞⲚ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ. ϪⲈ ⲘⲎ ⲞⲨⲚϬⲞⲘ ⲚⲞⲨⲂⲖⲖⲈ ⲈϪⲒⲘⲞⲈⲒⲦ ϨⲎⲦϤ ⲚⲞⲨⲂⲖⲖⲈ ⲘⲎ ⲚⲤⲈⲚⲀϨⲈ ⲀⲚ ⲈⲨϨⲒⲈⲒⲦ ⲘⲠⲈⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ⲘⲘⲚⲤⲂⲞⲨⲒ ⲈϤϪⲞⲤⲈ ⲈⲠⲈϤⲤⲀϨ. ⲘⲀⲢⲈⲞⲨⲞⲚ ⲚⲒⲘ ϢⲰⲠⲈ ⲈϤⲤⲂⲦⲰⲦ ⲚⲐⲈ ⲘⲠⲈϤⲤⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ⲀϨⲢⲞⲔ ⲆⲈ ⲔϬⲰϢⲦ ⲈⲠϪⲎ ⲈⲦϨⲘ ⲠⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ⲠⲤⲞⲒ ⲆⲈ ⲈⲦϨⲘⲠⲈⲔⲂⲀⲖ ⲈⲚⲄⲚⲀⲨ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ⲎⲚⲀϢ ⲚϨⲈ ⲔⲚⲀϪⲞⲞⲤ ⲘⲠⲈⲔⲤⲞⲚ ϪⲈ ⲠⲀⲤⲞⲚ ϬⲰ ⲦⲀⲚⲈϪⲠϪⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲂⲀⲖ ⲈⲚⲄⲚⲀⲨ ⲀⲚ ⲈⲠⲤⲞⲒ ⲈⲦϨⲘ ⲠⲈⲔⲂⲀⲖ. ⲪⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲚⲈϪⲠⲤⲞⲒ ⲚϢⲞⲢⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲂⲀⲖ ⲦⲀⲢⲈⲔⲚⲀⲨ ⲈⲂⲞⲖ ⲈⲚⲈϪⲠϪⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ⲘⲘⲚϢⲎⲚ ⲄⲀⲢ ⲈⲚⲀⲚⲞⲨϤ ⲚⲀⲦⲀⲨⲈⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈϤϨⲞⲞⲨ. ⲞⲨⲆⲈ ⲘⲘⲚϢⲎⲚ ⲈϤϨⲞⲞⲨ ⲚⲀⲦⲀⲨⲈⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲈⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ⲈϢⲀⲨⲤⲞⲨⲚ ⲠϢⲎⲚ ⲄⲀⲢ ⲠϢⲎⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲔⲀⲢⲠⲞⲤ. ⲘⲈⲨⲔⲈⲦϤⲔⲚⲦⲈ ⲈⲂⲞⲖ ϨⲚ ϢⲞⲚⲦⲈ. ⲞⲨⲆⲈ ⲘⲈⲨϪⲈⲖⲈ ⲈⲖⲞⲞⲖⲈ ⲈⲂⲞⲖ ϨⲚ ⲂⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ⲈϢⲀⲢⲈⲠⲢⲰⲘⲈ ⲚⲀⲄⲀⲐⲞⲤ ⲦⲀⲨⲈⲀⲄⲀⲐⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲀϨⲞ ⲘⲠⲈϤϨⲎⲦ ⲈⲦⲚⲀⲚⲞⲨϤ. ⲀⲨⲰ ⲈϢⲀⲢⲈⲠⲢⲰⲘⲈ ⲘⲠⲞⲚⲎⲢⲞⲤ ⲦⲀⲨⲈⲠⲞⲚⲎⲢⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤⲀϨⲞ ⲘⲠⲞⲚⲎⲢⲞⲚ. ⲈⲂⲞⲖ ⲄⲀⲢ ϨⲘ ⲠⲈϨⲞⲨⲞ ⲘⲠϨⲎⲦ ⲈϢⲀⲢⲈⲦⲦⲀⲠⲢⲞ ϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠϪⲞⲈⲒⲤ ⲈⲚⲦⲈⲦⲚⲈⲒⲢⲈ ⲀⲚ ⲘⲠⲈϮϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲎⲨ ϢⲀⲢⲞⲒ ⲈⲦⲤⲰⲦⲘ ⲈⲚⲀϢⲀϪⲈ ⲈϮⲢⲈ ⲘⲘⲞⲞⲨ ϮⲚⲀⲦⲀⲘⲰⲦⲚ ϪⲈ ⲈϤⲦⲚⲦⲰⲚ ⲈⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ⲈϤⲦⲚⲦⲰⲚ ⲈⲨⲢⲰⲘⲈ ⲈϤⲔⲰⲦ ⲚⲞⲨⲎⲒ ⲠⲀⲒ ⲈⲚⲦⲀϤϬⲰϪⲈ ⲀⲨⲰ ⲀϤϢⲒⲔⲈ ⲀϤⲤⲘⲒⲚⲈ ⲚⲦⲤⲚⲦⲈ ⲈϪⲚ ⲦⲠⲈⲦⲢⲀ. ⲚⲦⲈⲢⲈⲦⲈⲘⲎⲢⲈ ⲆⲈ ϢⲰⲠⲈ ⲀⲠⲒⲈⲢⲞ ϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈϨⲘⲠⲎⲒ ⲈⲦⲘⲘⲀⲨ ⲘⲠϤⲈϢϬⲘϬⲞⲘ ⲈⲢⲞϤ ϪⲈ ⲚⲈϤⲔⲎⲦ ⲔⲀⲖⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ⲠⲈⲦⲤⲰⲦⲘ ⲆⲈ ⲈⲢⲞⲞⲨ ⲈⲚϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀⲚ. ⲈϤⲦⲚⲦⲰⲚ ⲈⲨⲢⲰⲘⲈ ⲈⲀϤⲔⲰⲦ ⲘⲠⲈϤⲎⲒ ⲈϪⲘⲠⲔⲀϨ ⲚⲞⲨⲈϢⲚⲤⲚⲦⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲚⲦⲀⲠⲒⲈⲢⲞ ϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀϤϨⲈ ⲠϨⲈ ⲘⲠⲎⲒ ⲈⲦⲘⲘⲀⲨ ⲀϤϢⲰⲠⲈ ⲚⲞⲨⲚⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ⲈⲠⲈⲒⲆⲎ ⲀϤϪⲈⲔ ⲚⲈϤϢⲀϪⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲈⲘⲘⲀⲀϪⲈ ⲘⲠⲖⲀⲞⲤ. ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ");
INSERT INTO copshc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ⲚⲈⲢⲈⲠϨⲘϨⲀⲖ ⲆⲈ ⲚⲞⲨϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲘⲞⲔϨ ⲠⲈ ⲈϤⲚⲀⲘⲞⲨ ⲠⲀⲒ ⲆⲈ ⲚⲈϤⲦⲀⲒⲎⲨ ⲚⲦⲞⲞⲦϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ⲀϤⲤⲰⲦⲘ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲀϤϪⲞⲞⲨ ⲚϨⲈⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲚⲒⲞⲨⲆⲀⲒ ϢⲀⲢⲞϤ ⲈⲨⲤⲞⲠⲤ ⲘⲘⲞϤ. ϪⲈ ⲈϤⲈⲈⲒ ⲚϤⲦⲞⲨϪⲈ ⲠⲈϤϨⲘϨⲀⲖ ");
INSERT INTO copshc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒ ϢⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ϨⲚ ⲞⲨⲤⲠⲞⲨⲆⲎ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲘⲠϢⲀ ⲚϬⲒ ⲠⲈⲦⲔⲚⲀⲢⲠⲀⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ϤⲘⲈ ⲄⲀⲢ ⲘⲠⲈⲚϨⲈⲐⲚⲞⲤ. ⲀⲨⲰ ⲚⲦⲞϤ ⲠⲈⲚⲦⲀϤⲔⲰⲦ ⲚⲀⲚ ⲚⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲂⲰⲔ ⲚⲘⲘⲀⲨ ⲈⲘⲠⲀⲦϤϨⲰⲚ ⲆⲈ ⲈⲠⲎⲒ ⲀⲪⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲦⲚⲚⲞⲞⲨ ⲚⲚⲈϤϢⲂⲈⲈⲢ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲢⲤⲔⲨⲖⲖⲈⲒ ⲚϮⲘⲠϢⲀ ⲄⲀⲢ ⲀⲚ ⲈⲦⲢⲈⲔⲈⲒ ⲈϨⲞⲨⲚ ϨⲀⲦⲀⲞⲨⲈϨⲤⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ⲈⲦⲂⲈ ⲠⲀⲒ ⲢⲰ ⲘⲠⲒⲀⲀⲦ ⲚⲘⲠϢⲀ ⲈⲈⲒ ϢⲀⲢⲞⲔ. ⲀⲖⲖⲀ ⲀϪⲒⲤ ⲘⲘⲀⲦⲈ ⲘⲠϢⲀϪⲈ ϪⲈ ⲘⲀⲢⲈ ⲠⲀϨⲘϨⲀⲖ ⲖⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ⲔⲀⲒⲄⲀⲢ ⲀⲚⲞⲔ ⲀⲚⲄⲞⲨⲢⲰⲘⲈ ⲈⲒϢⲞⲞⲠ ϨⲀⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲈⲨⲚϨⲈⲚⲘⲀⲦⲞⲒ ϨⲀⲢⲀⲦ ϢⲀⲒϪⲞⲞⲤ ⲘⲠⲀⲒ ϪⲈ ⲂⲰⲔ ⲀⲨⲰ ϢⲀϤⲂⲰⲔ. ⲀⲨⲰ ⲚⲔⲈⲞⲨⲀ ϪⲈⲀⲘⲞⲨ. ⲀⲨⲰ ϢⲀϤⲈⲒ ⲀⲨⲰ ⲘⲠⲀϨⲘϨⲀⲖ ϪⲈ ⲀⲢⲒⲠⲀⲒ ⲚϤⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲤⲰⲦⲘ ⲈⲚⲀⲈⲒ ⲀϤⲢϢⲠⲎⲢⲈ ⲘⲘⲞϤ ⲀϤⲔⲞⲦϤ ⲈⲚⲈⲦⲞⲨⲎϨ ⲚⲤⲰϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲆⲈ ⲘⲠⲒϨⲈ ⲈⲠⲒⲤⲦⲒⲤ ⲚⲦⲈⲒϬⲞⲦ ϨⲘ ⲠⲔⲈⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ⲀⲚⲈⲚⲦⲀⲨϪⲞⲞⲨⲤⲞⲨ ⲆⲈ ⲔⲞⲦⲞⲨ ⲈⲠⲎⲒ ⲀⲨϨⲈ ⲈⲠϨⲘϨⲀⲖ ⲈⲀϤⲘⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲘⲚⲚⲤⲰⲤ ⲀϤⲂⲰⲔ ⲈⲨⲠⲞⲖⲈⲒⲤ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲚⲀⲈⲒⲚ ⲈⲢⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲘⲞⲞϢⲈ ⲚⲘⲘⲀϤ ⲚⲘⲠⲘⲎⲎϢⲈ ⲈⲦⲚⲀϢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲦⲠⲨⲖⲎ ⲚⲦⲠⲞⲖⲈⲒⲤ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲨⲚⲞⲨⲀ ⲈⲂⲞⲖ ⲈϤⲘⲞⲞⲨⲦ ⲞⲨϢⲎⲢⲈ ⲞⲨⲰⲦ ⲚⲦⲈⲦⲈϤⲘⲀⲀⲨ. ⲚⲦⲞⲤ ⲆⲈ ⲚⲈⲞⲨⲬⲎⲢⲀ ⲦⲈ. ⲚⲈⲞⲨⲚⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲚⲦⲈⲦⲠⲞⲖⲈⲒⲤ ⲚⲘⲘⲀⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ⲀⲠϪⲞⲈⲒⲤ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞⲤ ⲀϤϢⲚϨⲦⲎϤ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ. ⲘⲠⲢⲢⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲆⲈ ⲀϤϪⲰϨ ⲈⲠⲈϬⲖⲞϬ. ⲚⲈⲦϤⲒ ⲆⲈ ϨⲀⲢⲞϤ ⲀⲨⲀϨⲈⲢⲀⲦⲞⲨ. ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϨⲢϢⲒⲢⲈ ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲦⲰⲞⲨⲚⲄ. ");
INSERT INTO copshc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ⲀⲠⲈⲦⲘⲞⲞⲨⲦ ⲆⲈ ϨⲘⲞⲞⲤ ⲀϤⲀⲢⲬⲒ ⲚϢⲀϪⲈ ⲀϤⲦⲀⲀϤ ⲚⲦⲈϤⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ⲀⲐⲞⲦⲈ ⲆⲈ ϪⲒⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨⲚⲞϬ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲰⲞⲨⲚ ⲚϨⲎⲦⲚ. ⲀⲨⲰ ϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ϬⲘⲠϢⲒⲚⲈ ⲘⲠⲈϤⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ⲀⲠϢⲀϪⲈ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲦⲎⲢⲤ ⲈⲦⲂⲎⲦϤ. ⲚⲘⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ⲀⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲦⲀⲘⲞϤ ⲈⲦⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ. ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲞⲨⲦⲈ ⲈⲤⲚⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ⲀϤϪⲞⲞⲨⲤⲈ ϢⲀⲠϪⲞⲈⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦⲚⲎⲞⲨ ϪⲈⲈⲚⲚⲀϬⲰϢⲦ ϨⲎⲦϤ ⲚⲔⲈⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ⲚⲦⲈⲢⲈⲢⲢⲰⲘⲈ ⲆⲈ ⲈⲒ ϢⲀⲢⲞϤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲚ ϢⲀⲢⲞⲔ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦⲚⲎⲞⲨ ϪⲈⲈⲚⲚⲀϬⲰϢⲦ ϨⲎⲦϤ ⲚⲔⲈⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲀϤⲦⲀⲖϬⲈ ⲞⲨⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨϢⲰⲚⲈ ⲘⲚ ⲚⲈⲨⲘⲀⲤⲦⲒⲚⲄⲜ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲞⲨⲘⲎⲎϢⲈ ⲂⲂⲖⲖⲈ ⲀϤⲬⲀⲢⲒⲌⲈ ⲚⲀⲨ ⲘⲠⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲂⲰⲔ ⲚⲦⲈⲦⲚϪⲒⲠⲞⲨⲰ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲚⲈⲚⲦⲀⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲚⲈⲚⲦⲀⲦⲈⲦⲚⲤⲞⲦⲘⲞⲨ ϪⲈ ⲚⲂⲖⲖⲈⲈⲨ ⲚⲀⲨ ⲈⲂⲞⲖ. ⲚϬⲀⲖⲈⲈⲨ ⲘⲞⲞϢⲈ. ⲚⲈⲦⲤⲞⲂϨ ⲦⲂⲂⲞ. ⲚⲀⲖ ⲤⲰⲦⲘ. ⲚⲈⲦⲘⲞⲞⲨⲦ ⲦⲰⲞⲨⲚ. ⲚϨⲎⲔⲈ ⲤⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ⲀⲨⲰ ⲚⲀⲒⲀⲦϤ ⲘⲠⲈⲦⲈ ⲚϤⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲀⲚ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲆⲈ ⲚϬⲒ ⲚϤⲀⲒϢⲒⲚⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲀϤⲀⲢⲬⲒ ⲚϪⲞⲞⲤ ⲚⲘⲘⲎⲎϢⲈ ⲈⲦⲂⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲈⲢⲎⲘⲞⲤ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲨⲔⲀϢ ⲈⲢⲈⲠⲦⲎⲨ ⲔⲒⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ⲀⲖⲖⲀ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ. ⲈⲨⲢⲰⲘⲈ ⲈⲢⲈϨⲈⲚϨⲂⲤⲰ ⲈⲨϬⲎⲚ ⲦⲞ ϨⲒⲰⲰϤ ⲈⲒⲤⲚⲈⲦϨⲚⲚϨⲂⲤⲰ ⲈⲦⲦⲀⲈⲒⲎⲨ ⲘⲚ ⲚⲈⲦⲢⲨⲪⲎ ϨⲚ ⲚⲎⲒ ⲚⲚⲈⲢⲢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ⲀⲖⲖⲀ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ⲈϨⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨϨⲞⲨⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ⲠⲀⲒ ⲠⲈⲦⲤⲎϨ ⲈⲦⲂⲎⲦϤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲀⲦⲚⲚⲞⲞⲨ ⲘⲠⲀⲀⲄⲄⲈⲖⲞⲤ ϨⲀⲦⲈⲔϨⲎ ⲠⲀⲒ ⲈⲦⲚⲀⲤⲞⲨⲦⲚ ⲦⲈⲔϨⲒⲎ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲚⲠⲈⲦⲞ ⲚⲚⲞϬ ⲈⲒⲰϨⲀⲚⲚⲎⲤ ϨⲚ ⲚⲈϪⲠⲞ ⲚⲚⲈϨⲒⲞⲘⲈ. ⲠⲔⲞⲨⲒ ⲆⲈ ⲈⲢⲞϤ ⲠⲚⲞϬ ⲈⲢⲞϤ ⲠⲈ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ⲠⲖⲀⲞⲤ ⲆⲈ ⲦⲎⲢϤ ⲚⲘⲚⲦⲈⲖⲰⲚⲎⲤ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲀⲨⲦⲀⲒⲈⲠⲚⲞⲨⲦⲈ ϪⲈ ⲀⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ϨⲘ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲚⲘⲚⲚⲞⲘⲒⲔⲞⲤ ⲀⲨⲀⲐⲈⲦⲒ ⲘⲠϢⲞϪⲚⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲘⲠⲞⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ⲈⲒⲚⲀⲦⲞⲚⲦⲚ ⲚⲢⲰⲘⲈ ϬⲈ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ ⲈⲚⲒⲘ ⲀⲨⲰ ⲈⲨⲒⲚⲈ ⲚⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ⲈⲨⲦⲚⲦⲰⲚ ⲈϨⲈⲚϢⲎⲢⲈ ϢⲎⲘ ⲈⲨϨⲘⲞⲞⲤ ϨⲒⲦⲀⲄⲞⲢⲀ ⲈⲨⲘⲞⲨⲦⲈ ⲈϨⲞⲨⲚ ⲈⲚⲈⲨϢⲂⲈⲈⲢ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲰ ⲈⲢⲰⲦⲚ ⲘⲠⲈⲦⲚϬⲞⲤϬⲤ ⲀⲚⲦⲞⲒⲦ ⲘⲠⲈⲦⲚⲢⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ⲈⲒ ⲈⲚϤⲞⲨⲈⲘⲞⲈⲒⲔ ⲀⲚ ⲈⲚϤⲤⲈⲎⲢⲠ ⲀⲚ ⲠⲈϪⲎⲦⲚ ϪⲈ ⲞⲨⲚ ⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲒⲰⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ⲀⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲒ ⲈϤⲞⲨⲰⲘ ⲈϤⲤⲰ ⲠⲈϪⲎⲦⲚ ϪⲈ ⲒⲤⲞⲨⲢⲰⲘⲈ ⲢⲢⲈϤⲞⲨⲰⲘ ⲀⲨⲰ ⲢⲢⲈϤⲤⲈⲎⲢⲠ ⲚϢⲂⲎⲢ ⲚⲦⲈⲖⲰⲚⲎⲤ ϨⲒⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ⲀⲦⲤⲞⲪⲒⲀ ⲦⲘⲀⲒⲞ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲤϢⲎⲢⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ⲀⲞⲨⲀ ⲆⲈ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲤⲈⲠⲤⲰⲠϤ ϪⲈ ⲈϤⲈⲞⲨⲰⲘ ⲚⲘⲘⲀϤ ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀϤⲚⲞϪϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ⲈⲒⲤⲞⲨⲤϨⲒⲘⲈ ⲆⲈ ⲈⲤϨⲚⲦⲠⲞⲖⲈⲒⲤ ⲈⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲦⲈ. ⲀⲤⲈⲒⲘⲈ ϪⲈ ϤⲚⲎϪ ϨⲘ ⲠⲎⲒ ⲘⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ⲀⲤϪⲒ ⲚⲞⲨⲀⲖⲀⲂⲀⲤⲦⲢⲞⲚ ⲚⲤⲞϬⲚ ");
INSERT INTO copshc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ⲀⲤⲀϨⲈⲢⲀⲦⲤ ϨⲒⲠⲀϨⲞⲨ ⲘⲘⲞϤ ϨⲀⲢⲀⲦϤ ⲈⲤⲢⲒⲘⲈ ⲀⲤⲀⲢⲬⲒ ⲚϨⲢⲠⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲚⲚⲈⲤⲢⲘⲒⲞⲞⲨⲈ ⲈⲀⲤϤⲞⲦⲞⲨ ⲘⲠϤⲰ ⲚⲦⲈⲤⲀⲠⲈ. ⲀⲤϢⲰⲠⲈ ⲈⲤϮⲠⲒ ⲈⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲈⲤⲦⲰϨⲤ ⲘⲘⲞⲞⲨ ⲘⲠⲤⲞϬⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ⲀϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲚⲦⲀϤⲦⲀϨⲘⲈϤ ⲠⲈϪⲀϤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ⲠⲀⲒ ⲚⲈϤⲚⲀⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲦⲈ ⲀⲨⲰ ⲞⲨⲀϢ ⲘⲘⲒⲚⲈ ⲦⲈ ⲦⲈⲤϨⲒⲘⲈ ⲈⲦϪⲰϨ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲚϮⲞⲨϢⲀϪⲈ ⲈϪⲞⲞϤ ⲚⲀⲔ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲤⲀϨ ⲀϪⲒϤ. ");
INSERT INTO copshc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ⲚⲈⲨⲚⲦⲈ ⲞⲨⲆⲀⲚⲒⲤⲦⲎⲤ ⲈⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲠⲈ. ⲚⲈⲨⲚⲦϤϮⲞⲨ ⲚϢⲈ ⲚⲤⲀⲦⲈⲈⲢⲈ ⲈⲨⲀ ⲈⲨⲚⲦϤⲦⲀⲒⲞⲨ ⲈⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ⲈⲘⲘⲚⲦⲀⲨ ⲆⲈ ⲈϮ ⲀϤⲔⲀⲀϤ ⲚⲀⲨ ⲈⲂⲞⲖ ⲘⲠⲈⲤⲚⲀⲨ ⲚⲒⲘ ϬⲈ ⲘⲘⲞⲞⲨ ⲠⲈⲦⲚⲀⲘⲈⲢⲒⲦϤ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ⲀⲤⲒⲘⲰⲚ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ ϮⲘⲈⲈⲨⲈ ϪⲈ ⲠⲈⲚⲦⲀϤⲔⲀ ⲠⲈϨⲞⲨⲞ ϬⲈ ⲚⲀϤ ⲈⲂⲞⲖ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲔⲔⲢⲒⲚⲈ ϨⲚ ⲞⲨⲤⲞⲞⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ⲀϤⲔⲞⲦϤ ⲆⲈ ⲈⲦⲈⲤϨⲒⲘⲈ ⲠⲈϪⲀϤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲔⲚⲀⲨ ⲈⲦⲈⲒⲤϨⲒⲘⲈ. ⲀⲒⲈⲒ ⲈϨⲞⲨⲚ ⲈⲠⲈⲔⲎⲒ ⲘⲠⲔϮⲘⲞⲞⲨ ⲚⲀⲒ ⲈⲒⲀⲢⲀⲦ ⲚⲦⲞⲤ ⲆⲈ ⲀⲤϨⲢⲠⲚⲀⲞⲨⲈⲢⲎⲦⲈ ⲚⲚⲈⲤⲢⲘⲒⲞⲞⲨⲈ ⲈⲀⲤϤⲞⲦⲞⲨ ⲘⲠⲈⲤϤⲰ. ");
INSERT INTO copshc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ⲘⲠⲔϮⲠⲒ ⲈⲢⲰⲒ. ⲦⲀⲒ ⲆⲈ ϪⲒⲚⲦⲀⲒⲈⲒ ⲈϨⲞⲨⲚ ⲘⲠⲤⲖⲞ ⲈⲤϮⲠⲒ ⲈⲚⲀⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ⲘⲠⲔⲦⲈϨⲤ ⲦⲀⲀⲠⲈ ⲚⲚⲈϨ ⲦⲀⲒ ⲆⲈ ⲀⲤⲦⲈϨⲤ ⲚⲀⲞⲨⲈⲢⲎⲦⲈ ⲚⲤⲞϬⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ⲈⲦⲂⲈ ⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲈⲤⲚⲞⲂⲈ ⲈⲦⲚⲀϢⲰⲞⲨ ⲔⲎ ⲚⲀⲤ ⲈⲂⲞⲖ ϪⲈ ⲀⲤⲘⲈ ⲈⲘⲀⲦⲈ. ⲠⲈϢⲀⲨⲔⲀ ⲞⲨⲔⲞⲨⲒ ⲆⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϢⲀϤⲘⲈ ⲚⲞⲨⲔⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲤ. ϪⲈ ⲚⲞⲨⲚⲞⲂⲈ ⲔⲎ ⲚⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ⲀⲨⲀⲢⲬⲒ ⲚϬⲒ ⲚⲈⲦⲚⲎϪ ⲚⲘⲘⲀϤ. ⲈϪⲞⲞⲤ ϨⲘ ⲠⲈⲨϨⲎⲦ. ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲀⲒ ⲈⲦⲔⲀⲚⲞⲂⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲦⲈⲤϨⲒⲘⲈ ϪⲈ ⲦⲞⲨⲠⲒⲤⲦⲒⲤ ⲦⲈⲚⲦⲀⲤⲚⲀϨⲘⲈ ⲂⲰⲔ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲚⲚⲤⲰⲤ ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤⲘⲞⲞϢⲈ ⲔⲀⲦⲀⲠⲞⲖⲈⲒⲤ ⲀⲨⲰ ⲔⲀⲦⲀϮⲘⲈ ⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲈϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲢⲈⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ⲚⲘϨⲈⲚⲔⲈϨⲒⲞⲘⲈ ⲚⲀⲒ ⲈⲚⲦⲀϤⲦⲀⲖϬⲞⲞⲨ ϨⲚ ⲚⲈⲨⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲘⲚ ⲚⲈⲨϢⲰⲚⲈ. ⲘⲀⲢⲒⲀ ⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲦⲀⲒ ⲈⲚⲦⲀⲤⲀϢϤ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ ");
INSERT INTO copshc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ⲚⲘⲒⲰϨⲀⲚⲚⲀ ⲐⲒⲘⲈ ⲚⲬⲞⲨⲌⲀ ⲠⲈⲠⲒⲦⲢⲞⲠⲞⲤ ⲚϨⲎⲢⲰⲆⲎⲤ ⲚⲘⲤⲞⲨⲤⲀⲚⲚⲀ ⲀⲨⲰ ϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲚⲀϢⲰⲞⲨ ⲚⲀⲒ ⲈⲚⲈⲨⲆⲒⲀⲔⲞⲚⲈⲒ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ⲈⲢⲈⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲤⲰⲞⲨϨ ⲈⲚⲀϢⲰϤ. ⲘⲚ ⲚⲈⲦⲚⲎⲞⲨ ϢⲀⲢⲞϤ ⲔⲀⲦⲀⲠⲞⲖⲈⲒⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϨⲒⲦⲚ ⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ϪⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦϪⲞ ⲈⲦϪⲈⲠⲈϤϬⲢⲞϬ. ⲀⲨⲰ ϨⲘ ⲠⲦⲢⲈϤϪⲞ. ⲀϨⲞⲒⲚⲈ ϨⲈ ϨⲀⲦⲚⲦⲈϨⲒⲎ ⲀⲨϨⲞⲘⲞⲨ ⲀⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ⲞⲨⲞⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ⲀϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϨⲈ ⲈϪⲚ ⲘⲠⲈⲦⲢⲀ ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲢⲰⲦ ⲀⲨϢⲞⲞⲨⲈ ϪⲈ ⲘⲘⲚⲀϬⲂⲈⲤ ϨⲀⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϨⲈ ⲈⲦⲘⲎⲦⲈ ⲚⲚϢⲞⲚⲦⲈ ⲀⲨⲰ ⲚⲦⲈⲢⲈⲚϢⲞⲚⲦⲈ ⲢⲰⲦ ⲀⲨⲞϬⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨϨⲈ ⲈϪⲘⲠⲔⲀϨ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲢⲰⲦ ⲀⲨⲦⲀⲨⲈⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲚϢⲈ ⲚⲔⲰⲂ. ⲚⲀⲈⲒ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲞⲨ ⲚⲈϤⲘⲞⲨⲦⲈ ⲠⲈ ϪⲈ ⲠⲈⲦⲈⲨⲚⲦϤⲘⲀⲀϪⲈ ⲘⲘⲀⲨ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ϪⲚⲞⲨϤ ϪⲈ ⲞⲨ ⲦⲈ ⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲎⲦⲚ ⲈⲈⲒⲘⲈ ⲈⲠⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲒϢⲀϪⲈ ⲆⲈ ⲚⲘⲠⲔⲈⲤⲈⲈⲠⲈ ϨⲚ ϨⲈⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲀⲨ ⲚⲚⲈⲨⲒⲰⲢϨ ⲀⲨⲰ ⲈⲨⲤⲰⲦⲘ ⲚⲚⲈⲨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ⲦⲀⲒ ⲆⲈ ⲦⲈ ⲦⲠⲀⲢⲀⲂⲞⲖⲎ. ⲠⲈϬⲢⲞϬ ⲠⲈ ⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ⲚⲈⲦϨⲀⲦⲚ ⲦⲈϨⲒⲎ ⲆⲈ ⲚⲈ ⲚⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲘⲚⲚⲤⲰⲤ ⲈϢⲀⲢⲈ ⲠⲠⲞⲚⲎⲢⲞⲤ ⲈⲒ ⲚϤϤⲒ ⲘⲠϢⲀϪⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲨϨⲎⲦ ϪⲈ ⲚⲚⲈⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲤⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ⲚⲈⲦϨⲒϪⲚ ⲦⲠⲈⲦⲢⲀ ⲆⲈ ⲚⲈ ⲚⲀⲈⲒ ⲈϢⲀⲨⲤⲰⲦⲘ ⲚⲤⲈϢⲈⲠⲠϢⲀϪⲈ ⲈⲢⲞⲞⲨ ϨⲚ ⲞⲨⲢⲀϢⲈ. ⲚⲀⲈⲒ ⲆⲈ ⲘⲘⲚⲦⲞⲨⲚⲞⲨⲚⲈ ⲘⲘⲀⲨ ⲈϢⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲠⲢⲞⲤⲞⲨⲞⲈⲒϢ. ϨⲚ ⲞⲨⲞⲈⲒϢ ⲆⲈ ⲘⲠⲈⲒⲢⲀⲤⲘⲞⲤ ϢⲀⲨⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ⲚⲈⲚⲦⲀⲨϨⲈ ⲆⲈ ⲈϪⲚ ⲚϢⲞⲚⲦⲈ ⲚⲈ ⲚⲀⲒ ⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲈⲦⲘⲞⲞϢⲈ ϨⲚ ⲚⲢⲞⲞⲨϢ ⲚⲘⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲚⲘⲚϨⲎⲆⲞⲚⲎ ⲚⲦⲈⲠⲂⲒⲞⲤ ⲈⲨⲰϬⲦ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲈⲚⲤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ⲚⲈⲦϨⲒϪⲘⲠⲔⲀϨ ⲆⲈ ⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲈ ⲚⲀⲒ ⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ϨⲚ ⲞⲨϨⲎⲦ ⲈⲚⲀⲚⲞⲨϤ ⲚⲀⲄⲀⲐⲞⲤ ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨϮⲔⲀⲢⲠⲞⲤ ϨⲚ ⲞⲨϨⲨⲠⲞⲘⲞⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ⲘⲈⲢⲈⲖⲀⲀⲨ ϪⲈⲢⲈⲞⲨϨⲎⲂⲤ ⲚϤϨⲞⲂⲤϤ ⲚⲞⲨϨⲚⲀⲀⲨ ⲎⲚϤⲔⲀⲀϤ ϨⲀ ⲞⲨϬⲖⲞϬ. ⲀⲖⲖⲀ ⲈϢⲀϤⲔⲀⲀϤ ⲈϪⲚ ⲦⲖⲨⲬⲚⲒⲀ. ϪⲈ ⲈⲢⲈⲚⲈⲦⲂⲎⲔ ⲈϨⲞⲨⲚ ⲚⲀⲨ ⲈⲠⲞⲨⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ⲘⲘⲚⲖⲀⲀⲨ ⲄⲀⲢ ⲈϤϨⲎⲠ ⲈⲚϤⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲀⲚ. ⲀⲨⲰ ⲘⲘⲚⲖⲀⲀⲨ ⲈϤϨⲞⲂⲤ ⲈⲚⲤⲈⲚⲀⲈⲒⲘⲈ ⲈⲢⲞϤ ⲀⲚ ⲚϤⲈⲒ ⲈⲠⲞⲨⲞⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ϮϨⲦⲎⲦⲚ ϬⲈ ϪⲈ ⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲚⲀϢ ⲚϨⲈ. ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ⲄⲀⲢ ⲤⲈⲚⲀϮ ⲚⲀϤ ⲀⲨⲰ ⲠⲈⲦⲈⲘⲚⲦⲀϤ. ⲠⲈⲦϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚⲦⲀⲒ ⲤϤ ⲤⲈⲚⲀϤⲒⲦϤ ⲚⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ⲀⲦⲈϤⲘⲀⲀⲨ ⲆⲈ ⲈⲒ ϢⲀⲢⲞϤ ⲘⲚ ⲚⲈϤⲤⲚⲎⲨ ⲘⲠⲞⲨⲈϢϬⲘϬⲞⲘ ⲈⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ⲀⲨϪⲒⲠⲞⲨⲰ ⲆⲈ ⲚⲀϤ ϪⲈ ⲦⲈⲔⲘⲀⲀⲨ ⲘⲚ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲀϨⲈⲢⲀⲦⲞⲨ ϨⲒⲠⲤⲀ ⲂⲂⲞⲖ ⲈⲨⲞⲨⲈϢ ⲚⲀⲨ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲦⲀⲘⲀⲀⲨ ⲚⲘ ⲚⲀⲤⲚⲎⲨ ⲚⲈ ⲚⲀⲒ ⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲈϮⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲞⲨϨⲞⲞⲨ ⲈⲀϤⲦⲀⲖⲈ ⲈⲨϪⲞⲒ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲀⲢⲞⲚ ⲈⲠⲈⲔⲢⲞ ⲚⲦⲖⲒⲘⲚⲎ. ⲀⲨⲰ ⲀⲨⲢϨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ⲈⲨⲢϨⲰⲦ ⲆⲈ ⲀϤⲰⲂϢ. ⲀⲨⲦⲢⲰⲘ ⲚⲦⲎⲨ ⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲦⲖⲒⲘⲚⲎ ⲀⲨϢⲦⲞⲢⲦⲢ ⲆⲈ ⲀⲨⲰ ⲀⲨϬⲒⲚⲆⲨⲚⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲈⲢⲞϤ ⲀⲨⲦⲞⲨⲚⲞⲤϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲠⲤⲀϨ ⲦⲚⲚⲀⲦⲀⲔⲞ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲦⲎⲞⲨ ⲚⲘⲪⲞⲈⲒⲘ ⲘⲠⲘⲞⲞⲨ ⲀϤⲖⲞ ⲀⲨϪⲀⲘⲎ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲈⲤⲦⲰⲚ ⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ. ⲈⲨⲢϨⲞⲦⲈ ⲆⲈ ⲀⲨⲰ ⲈⲨⲢϢⲠⲎⲢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲚⲒⲘ ϬⲈ ⲚⲦⲞϤ ⲠⲈ ⲠⲀⲒ ϪⲈ ϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲚⲦⲎⲨ ⲚⲘⲠⲘⲞⲞⲨ ⲤⲈⲤⲰⲦⲘ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ⲀⲨⲤϬⲎⲢ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲦⲈⲬⲰⲢⲀ ⲚⲚⲄⲈⲢⲀⲌⲎⲚⲞⲤ ⲈⲦⲈⲦⲀⲒ ⲦⲈⲈⲦⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲠⲈⲔⲢⲞ ⲀⲨⲢⲰⲘⲈ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲞⲖⲈⲒⲤ ⲈⲨⲚ ϨⲈⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲒⲰⲰϤ. ⲈⲀϤⲢⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲈⲒϢ ⲈⲘⲠϤϮϨⲞⲒⲦⲈ ϨⲒⲰⲰϤ ⲀⲨⲰ ⲈⲘⲠϤⲞⲨⲰϨ ϨⲚ ⲎⲈⲒ ⲀⲖⲖⲀ ⲈϤϨⲚⲚⲈⲘϨⲀⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲀϤⲠⲀϨⲦϤ ϨⲀⲢⲀⲦϤ ⲠⲈϪⲀϤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ϪⲈ ⲈⲔⲞⲨⲈϢⲞⲨ ⲚⲘⲘⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦϪⲞⲤⲈ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ⲘⲠⲢⲂⲀⲤⲀⲚⲒⲌⲈ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ⲀϤⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲄⲀⲢ ⲚⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲰⲘⲈ. ⲚⲈⲀϤⲢ ϨⲈⲚⲚⲞϬ ⲄⲀⲢ ⲚⲞⲨⲞⲈⲒϢ ⲈϢⲀϤⲦⲞⲢⲠϤ ⲚⲈϢⲀⲨⲘⲞⲢϤ ⲆⲈ ⲠⲈ ϨⲚ ϨⲈⲚϨⲀⲖⲨⲤⲒⲤ ⲚⲘϨⲈⲚⲒⲚⲈ ⲚϨⲞⲘⲚⲦ ⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞϤ. ⲀⲨⲰ ϢⲀϤⲠⲰϨ ⲚⲘⲘⲢⲢⲈ ⲚⲤⲈϪⲒⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈϨⲈⲚⲘⲀ ⲚϪⲀⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ϪⲚⲞⲨϤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲈⲔⲢⲀⲚ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲖⲈⲄⲈⲰⲚ ϪⲈ ⲀϨⲀϨ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ϪⲈ ⲚⲚⲈϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲨ ⲈⲂⲰⲔ ⲈⲠⲚⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ⲚⲈⲞⲨⲚ ⲞⲨⲀⲄⲈⲖⲎ ⲆⲈ ⲢⲢⲒⲢ ⲘⲘⲀⲨ ⲠⲈ ⲈⲚⲀϢⲰⲤ ⲈⲨⲘⲞⲞⲚⲈ ⲘⲘⲞⲤ ϨⲒⲠⲦⲞⲞⲨ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ϪⲈ ⲈϤⲈⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲀⲨ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲘⲘⲀⲨ. ⲀⲨⲰ ⲀϤⲔⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ⲀⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲰⲘⲈ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲚⲢⲒⲢ. ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲆⲈ ⲚϬⲒ ⲦⲀⲄⲈⲖⲎ ⲈϪⲚ ⲦϢⲰⲘⲈ ⲈⲠⲈⲤⲎⲦ ⲈⲦⲖⲒⲘⲚⲎ ⲀⲨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ⲀⲚⲈⲦⲘⲞⲞⲚⲈ ⲆⲈ ⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲀⲨⲠⲰⲦ ⲀⲨϪⲒⲠⲞⲨⲰ ⲈⲦⲠⲞⲖⲈⲒⲤ ⲀⲨⲰ ⲈⲚⲤⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ⲀⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ⲀⲨⲈⲒ ϢⲀⲒⲎⲤⲞⲨⲤ ⲀⲨϨⲈ ⲈⲠⲢⲰⲘⲈ ⲈϤϨⲘⲞⲞⲤ ⲠⲀⲒ ⲈⲚⲦⲀ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲈⲢⲈⲚⲈϤϨⲞⲒⲦⲈ ϨⲒⲰⲰϤ ⲈⲢⲈⲠⲈϤϨⲎⲦ ⲤⲘⲞⲚⲦ ⲈϤϨⲘⲞⲞⲤ ϨⲀⲦⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲒⲤ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ⲀⲚⲈⲚⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲦⲀⲘⲞⲞⲨ ⲈⲐⲈ ⲈⲚⲦⲀⲠⲈⲦⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲞⲨϪⲀⲒ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲚⲚⲄⲈⲢⲀⲌⲎⲚⲞⲤ ⲈⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ϪⲈ ⲀⲨⲚⲞϬ ⲚϨⲞⲦⲈ ⲦⲀϨⲞⲞⲨ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲖⲈ ⲈⲨϪⲞⲒ ⲀϤⲔⲦⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ⲚⲈⲢⲈⲠⲢⲰⲘⲈ ⲆⲈ ⲈⲚⲦⲀ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲦⲰⲂϨ ⲘⲘⲞϤ ⲈⲦⲢⲈϤⲘⲞⲞϢⲈ ⲚⲘⲘⲀϤ. ⲀϤⲔⲀⲀϤ ⲆⲈ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ϪⲈ ⲔⲞⲦⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲔⲎⲈⲒ ⲚⲄϪⲰ ⲚⲚⲈⲚⲦⲀⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ⲚⲀⲔ. ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲞⲖⲈⲒⲤ ⲦⲎⲢⲤ ⲈϤⲦⲀϢⲈⲞⲒϢ ⲚⲚⲈⲚⲦⲀⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ϨⲘ ⲠⲦⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲔⲞⲦϤ ⲀⲠⲘⲎⲎϢⲈ ϢⲞⲠϤ ⲈⲢⲞⲞⲨ ⲚⲈⲨϬⲰϢⲦ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲠⲈ ⲈⲂⲞⲖ ϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲀⲨⲢⲰⲘⲈ ⲈⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲒⲀⲈⲒⲢⲞⲤ ⲈⲠⲀⲢⲬⲰⲚ ⲠⲈ ⲚⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ⲀϤⲠⲀϨⲦϤ ϨⲀⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲀϤⲤⲈⲠⲤⲰⲠϤ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ");
INSERT INTO copshc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ϪⲈ ⲈⲚⲈⲞⲨⲚⲦϤ ⲞⲨϢⲈⲈⲢⲈ ⲞⲨⲰⲦ ⲈⲤⲚⲀⲢ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲢⲢⲞⲘⲠⲈ. ⲦⲀⲒ ⲆⲈ ⲚⲈⲤⲚⲈⲤⲚⲀⲘⲞⲨ. ⲈϤⲂⲎⲔ ⲆⲈ ⲀⲠⲘⲎⲎϢⲈ ϨⲈϪϨⲰϪϤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ⲈⲒⲤⲞⲨⲤϨⲒⲘⲈ ⲆⲈ ⲈⲢⲈⲠⲈⲤⲚⲞϤ ϨⲀⲢⲞⲤ ⲘⲘⲚⲦⲤⲚⲞⲞⲨⲤⲈ ⲢⲢⲞⲘⲠⲈ ⲦⲀⲒ ⲈⲘⲠⲈⲖⲀⲀⲨ ⲈϢϬⲘϬⲞⲘ ⲈⲦⲀⲖϬⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ⲀⲤϮⲠⲈⲤⲞⲨⲞⲒ ⲈⲠⲀϨⲞⲨ ⲘⲘⲞϤ ⲀⲤϪⲰϨ ⲈⲚⲦⲰⲦⲈ ⲚⲦⲈϤϢⲦⲎⲚ ⲀⲨⲰ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲀⲠⲈⲤⲚⲞϤ ϬⲰ ⲈϤϢⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤϪⲰϨ ⲈⲢⲞⲒ ⲚⲦⲈⲢⲞⲨϪⲞⲞⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ϪⲈ ⲚⲀⲚⲞⲚ ⲀⲚ ⲚⲈ ⲠⲈϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲘⲘⲎⲎϢⲈ ⲚⲈⲦϨⲞϪϨⲈϪ ⲘⲘⲞⲔ ⲈⲦⲐⲖⲒⲂⲈ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲨϪⲰϨ ⲈⲢⲞⲒ ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒⲈⲒⲘⲈ ⲈⲨϬⲞⲘ ⲈⲀⲤⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ⲀⲤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ϪⲈ ⲘⲠⲈⲠϨⲰⲂ ϨⲰⲠ ⲀⲤⲈⲒ ⲈⲤⲤⲦⲰⲦ ⲀⲤⲠⲀϨⲦⲤ ⲚⲀϤ ⲀⲤⲦⲀⲘⲞϤ ϪⲈ ⲚⲦⲀⲤϪⲰϨ ⲈⲢⲞϤ ⲈⲦⲂⲈ ⲞⲨ ⲚϨⲰⲂ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ. ⲀⲨⲰ ⲈⲐⲈ ⲈⲚⲦⲀⲤⲖⲞ ⲚⲦⲈⲨⲚⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀϢⲈⲈⲢⲈ ⲦⲞⲨⲠⲒⲤⲦⲒⲤ ⲦⲈⲚⲦⲀⲤⲚⲀϨⲘⲈ ⲂⲰⲔ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ⲈⲦⲒ ⲆⲈ ⲈϤϢⲀϪⲈ ⲀϤⲈⲒ ⲚϬⲒ ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲀⲠⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲦⲈⲔϢⲈⲈⲢⲈ ⲘⲞⲨ ⲘⲠⲢⲤⲔⲨⲖⲖⲈⲒ ϬⲈ ⲘⲠⲤⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲤⲰⲦⲘ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ. ⲘⲞⲚⲞⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲤⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲠⲎⲒ ⲘⲠϤⲔⲀⲖⲀⲀⲨ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲘⲘⲀϤ ⲚⲤⲀⲠⲈⲦⲢⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲠⲒⲰⲦ ⲚⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲚⲘⲦⲈⲤⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ⲚⲈⲨⲢⲒⲘⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲚⲈⲨⲚⲈϨⲠⲈ ⲠⲈ ⲈⲢⲞⲤ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲢⲢⲒⲘⲈ. ⲘⲠⲤⲘⲞⲨ ⲄⲀⲢ ⲀⲖⲖⲀ ⲈⲤⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ⲀⲨⲤⲰⲂⲈ ⲆⲈ ⲚⲤⲰϤ ⲈⲨⲤⲞⲞⲨⲚ ϪⲈ ⲀⲤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲚⲈϪⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲂⲞⲖ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲦⲈⲤϬⲒϪ ⲀϤⲘⲞⲨⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦϢⲈⲈⲢⲈ ϢⲎⲘ ⲦⲰⲞⲨⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ⲀⲠⲈⲤⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲔⲞⲦϤ ⲈⲢⲞⲤ ⲀⲤⲦⲰⲞⲨⲚ ⲚⲦⲈⲨⲚⲞⲨ. ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲨϮ ⲚⲀⲤ ⲈⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲚϬⲒ ⲚⲈⲤⲒⲞⲦⲈ ⲚⲦⲞϤ ⲆⲈ ⲀϤⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲚⲀⲨ ⲈⲦⲘϪⲈ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲖⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲀϤϮ ⲚⲀⲨ ⲚⲞⲨϬⲞⲘ ⲚⲘⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲈϪⲚ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲈⲦⲢⲈⲨⲢⲠⲀϨⲢⲈ ⲈⲚϢⲰⲚⲈ ");
INSERT INTO copshc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ⲀϤϪⲞⲞⲨⲤⲈ ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲈⲦⲀⲖϬⲈ ⲚⲈⲦϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲘⲠⲢϤⲒⲖⲀⲀⲨ ⲈⲦⲈϨⲒⲎ ⲞⲨⲆⲈ ϬⲈⲢⲰⲂ ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲞⲨⲆⲈ ⲞⲈⲒⲔ ⲞⲨⲆⲈ ϨⲞⲘⲚⲦ ⲞⲨⲆⲈ ⲈⲢⲈϢⲦⲎⲚ ⲤⲚⲦⲈ ϨⲒⲰⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ⲠⲎⲒ ⲆⲈ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ϬⲰ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲀⲘⲎⲒⲦⲚ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ⲚⲈⲦⲈⲚⲤⲈⲚⲀϢⲈⲠ ⲦⲎⲞⲨⲦⲚ ⲈⲢⲞⲞⲨ ⲀⲚ ⲈⲦⲈⲦⲚⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ ⲚⲈϨⲠϢⲞⲒϢ ⲚⲚⲈⲦⲚⲞⲨⲈⲢⲎⲦⲈ ⲈϪⲰⲞⲨ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲈⲨⲘⲞⲞϢⲈ ⲠⲈ ⲔⲀⲦⲀϮⲘⲈ ⲈⲨⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲀⲨⲰ ⲈⲨⲢⲠⲀϨⲢⲈ ϨⲘ ⲘⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ⲀϨⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲠⲦⲈⲦⲢⲀⲢⲬⲎⲤ ⲤⲰⲦⲘ ⲈⲚⲈⲦϢⲰⲠⲈ ⲦⲎⲢⲞⲨ ⲀϤⲀⲠⲞⲢⲒ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲨⲚϨⲞⲒⲚⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ⲈⲂⲞⲖ ⲆⲈ ϨⲒⲦⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈⲚⲦⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ϨⲒⲦⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲞⲨⲀ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲀⲢⲬⲀⲒⲞⲚ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲚⲦⲀⲒϤⲒ ⲚⲦⲀⲠⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲒⲘ ⲆⲈ ⲠⲈ ⲠⲀⲒ ⲈϮⲤⲰⲦⲘ ⲚⲚⲀⲒ ⲈⲦⲂⲎⲦϤ. ⲀⲨⲰ ⲚⲈϤϢⲒⲚⲈ ⲚⲤⲀⲚⲀⲨ ⲈⲢⲞϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ⲀⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲆⲈ ⲔⲞⲦⲞⲨ ⲀⲨϪⲰ ⲚⲀϤ ⲚⲚⲈⲚⲦⲀⲨⲀⲀⲨ. ⲀϤϪⲒⲦⲞⲨ ⲆⲈ ⲀϤⲤⲈϨⲦϤ ⲚⲤⲀⲞⲨⲤⲀ ⲈⲨⲠⲞⲖⲈⲒⲤ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲂⲎⲆⲤⲀⲒⲆⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲀⲨⲒⲘⲈ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲀϤϢⲞⲠⲞⲨ ⲆⲈ ⲈⲢⲞϤ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲚⲈⲦⲢⲬⲢⲒⲀ ⲚϪⲒⲠⲀϨⲢⲈ ⲀϤⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ⲚⲈⲀⲠⲈϨⲞⲞⲨ ⲆⲈ ⲀⲢⲬⲒ ⲚⲞⲨⲈⲒⲚⲈ. ⲀⲨϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲔⲀⲘⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ϪⲈ ⲈⲨⲈⲂⲰⲔ ⲈⲚϮⲘⲈ ⲈⲦⲘⲠⲈⲨⲔⲰⲦⲈ ⲚⲘⲚⲤⲰϢⲈ ⲚⲤⲈⲘⲦⲞⲚ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲚⲤⲈϨⲈ ⲈϨⲢⲈ ϪⲈ ⲤⲈϨⲚⲞⲨⲘⲀ ⲚϪⲀⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲀ ⲚⲀⲨ ⲚⲦⲰⲦⲚ ⲚⲤⲈⲞⲨⲰⲘ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲘⲘⲚⲦⲚϨⲞⲨⲞ ⲈϮⲞⲨ ⲚⲚⲞⲒⲔ ⲘⲠⲈⲒⲘⲀ ⲚⲘⲦⲂⲦ ⲤⲚⲀⲨ. ⲒⲘⲎⲦⲒ ⲚⲦⲚⲂⲰⲔ ⲀⲚⲞⲚ ⲚⲦⲚϢⲰⲠ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲦⲎⲢϤ ⲘⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ⲚⲈⲨⲚⲀⲢⲀϮⲞⲨ ⲄⲀⲢ ⲚϢⲞ ⲢⲢⲰⲘⲈ ⲠⲈ. ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲘⲀⲢⲞⲨⲚⲞϪⲞⲨ ⲤⲎⲚⲈ ⲤⲎⲚⲈ ⲚⲀⲚⲦⲀⲒⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ⲀⲨⲀⲀⲤ ⲆⲈ ϨⲒⲚⲀⲈⲒ ⲀⲨⲦⲢⲈⲨⲚⲞϪⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ⲀϤϪⲒ ⲘⲠϮⲞⲨ ⲆⲈ ⲚⲚⲞⲒⲔ ⲚⲘⲠⲦⲂⲦ ⲤⲚⲀⲨ ⲀϤϤⲒⲀⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲀϤⲠⲞϢⲞⲨ ⲀϤⲦⲀⲀⲨ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲔⲰ ϨⲀⲢⲰⲞⲨ ⲘⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ⲀⲨⲞⲨⲰⲘ ⲀⲨⲤⲒ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨϤⲒ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲞⲞⲨⲤ ⲚⲔⲞⲦ ⲖⲖⲀⲔⲘ ⲈⲀⲨⲢϨⲞⲨⲞ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤϨⲚⲞⲨⲘⲀ ⲘⲀⲨⲀⲀϤ ⲈϤϢⲖⲎⲖ ⲈⲢⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲘⲘⲀϤ. ⲀϤϪⲚⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲈⲢⲈⲘⲘⲎⲎϢⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈϨⲞⲒⲚⲈ ⲘⲈⲚ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲂⲀⲠⲦⲒⲤⲦⲎⲤ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ϨⲎⲖⲈⲒⲀⲤ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲒⲈⲢⲎⲘⲒⲀⲤ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲞⲨⲀ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲀⲢⲬⲀⲒⲞⲤ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄⲚⲒⲘ. ⲀⲠⲈⲦⲢⲞⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ. ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲀϤⲠⲀⲢⲀⲄⲄⲒⲖⲈ ϪⲈ ⲘⲠⲢϪⲈⲠⲀⲒ ⲈⲖⲀⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ϢⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲚⲤⲈⲦⲤⲦⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲘ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲤⲈⲘⲞⲞⲨⲦϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲞⲨⲞⲚ ⲚⲒⲘ. ϪⲈ ⲠⲈⲦⲞⲨⲰϢ ⲈⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲘⲀⲢⲈϤⲀⲢⲚⲀ ⲘⲘⲞϤ ⲚϤϤⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲘⲘⲎⲚⲈ ⲚϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ⲠⲈⲦⲚⲀⲞⲨⲈϢ ⲦⲈϤⲮⲨⲬⲎ ⲄⲀⲢ ⲈⲦⲀⲚϨⲞⲤ ϤⲚⲀⲤⲞⲢⲘⲈⲤ ⲀⲨⲰ ⲠⲈⲦⲚⲀⲤⲰⲢⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲦⲂⲎⲦ ϤⲚⲀⲦⲀⲚϨⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ⲈⲢⲈⲠⲢⲰⲘⲈ ⲄⲀⲢ ⲚⲀϮϨⲎⲞⲨ ⲚⲞⲨ ⲈϤϢⲀⲚϮϨⲎⲞⲨ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ. ⲚϤⲤⲞⲢⲘⲈϤ ⲆⲈ ϨⲰⲰϤ ⲎⲚϤϮⲞⲤⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ⲠⲈⲦⲚⲀϮϢⲒⲠⲈ ⲄⲀⲢ ⲚⲀⲒ ⲚⲘⲚⲀϢⲀϪⲈ. ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀϮϢⲒⲠⲈ ⲘⲠⲀⲒ ⲈϤϢⲀⲚⲈⲒ ϨⲘ ⲠⲈϤⲈⲞⲞⲨ ⲚⲘⲠⲀ ⲠⲈϤⲒⲰⲦ ⲚⲘⲠⲀ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϨⲚ ⲞⲨⲘⲈ ϪⲈ ⲞⲨⲚϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲈⲒⲘⲀ ⲈⲚⲚⲈⲨϪⲒϮ ⲠⲈ ⲘⲠⲘⲞⲨ ϢⲀⲚⲦⲞⲨⲚⲀⲨ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲚⲚⲤⲀ ⲚⲈⲒϢⲀϪⲈ ⲚⲚⲀϢⲘⲞⲨⲚ ⲚϨⲞⲞⲨ ⲀϤϪⲒ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲘⲒⲀⲔⲰⲂⲞⲤ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲦⲞⲞⲨ ⲈϢⲖⲎⲖ ");
INSERT INTO copshc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤϢⲖⲎⲖ ⲀⲠⲒⲚⲈ ⲘⲠⲈϤϨⲞ ⲢⲔⲈⲨⲀ. ⲀⲨⲰ ⲀⲦⲈϤϨⲂⲤⲰ ⲞⲨⲂⲀϢ ⲈⲤⲦⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲚⲈⲢⲈⲢⲰⲘⲈ ⲤⲚⲀⲨ ϢⲀϪⲈ ⲚⲘⲘⲀϤ. ⲈⲦⲈⲚⲀⲒ ⲚⲈ ⲘⲰⲨⲤⲎⲤ ⲚⲘϨⲎⲖⲈⲒⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ⲚⲀⲒ ⲈⲚⲦⲀⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲞⲞⲨ. ⲚⲀⲒ ⲈⲚⲦⲀⲨϪⲰ ⲚⲦⲈϤϨⲒⲎ ⲦⲀⲒ ⲈⲦϤⲚⲀϪⲞⲔⲤ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ⲚⲈⲨϨⲞⲢϢ ⲠⲈ ϨⲀⲪⲒⲚⲎⲂ. ⲀⲨⲢⲞⲈⲒⲤ ⲆⲈ ⲀⲨⲚⲀⲨ ⲈⲠⲈϤⲈⲞⲞⲨ ⲀⲨⲰ ⲠⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲨⲠⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲠⲈϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲚⲀϨⲢⲚ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲤⲀϨ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲚ ⲈⲦⲢⲈⲚϢⲰⲠⲈ ⲘⲠⲈⲒⲘⲀ ⲦⲀⲢⲚⲦⲀⲘⲒⲞⲚϢⲞⲘⲦⲈ ⲚⲤⲔⲎⲚⲎ ⲞⲨⲈⲒ ⲚⲀⲔ ⲞⲨⲈⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲈⲒ ⲚϨⲎⲖⲈⲒⲀⲤ ⲈⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲦϤϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ⲚⲀⲒ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲞⲨ ⲀⲨⲔⲖⲞⲞⲖⲈ ϢⲰⲠⲈ ⲀⲤⲢϨⲀⲒⲂⲈⲤ ⲈⲢⲞⲞⲨ. ⲀⲨⲢϨⲞⲦⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲚ ⲈⲦⲘⲘⲀⲨ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲈⲔⲖⲞⲞⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ⲀⲨⲤⲘⲎ ⲆⲈ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲖⲞⲞⲖⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲈⲦⲤⲞⲦⲠ. ⲤⲰⲦⲘ ⲚⲤⲰϤ. ϨⲘ ⲠⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ⲦⲈⲤⲘⲎ ⲆⲈ ϢⲰⲠⲈ ⲀⲨϨⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲘⲀⲨⲀⲀϤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲀⲢⲰⲞⲨ ⲀⲨⲰ ⲘⲠⲞⲨⲦⲀⲘⲈⲖⲀⲀⲨ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲖⲀⲀⲨ ⲚⲚⲈⲚⲦⲀⲨⲚⲀⲨ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲈⲨⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲒⲠⲦⲞⲞⲨ. ⲀⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲀⲨⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠⲤⲀϨ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ϬⲰϢⲦ ⲈϪⲚ ⲠⲀϢⲎⲢⲈ ϪⲈ ⲞⲨϢⲢⲞⲨⲰⲦ ⲚⲀⲒ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϢⲀⲢⲈⲞⲨⲠⲚⲈⲨⲘⲀ ⲦⲀϨⲞϤ ⲚϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲈϤϨⲒⲦⲈ ⲘⲘⲞϤ ⲚϤⲦⲀⲨⲈ ⲤϨⲂⲀⲒⲦⲈ. ⲘⲞⲄⲒⲤ ⲈϤϢⲀⲚⲤⲀϨⲰϤ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲈϤϢⲀⲚⲦⲚⲚⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ⲀⲒⲤⲈⲠⲤ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈⲚⲞϪϤ ⲈⲈⲂⲞⲖ ⲘⲠⲞⲨⲈϢϬⲘϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ Ⲱ ⲦⲄⲈⲚⲈⲀ ⲚⲀⲠⲒⲤⲦⲞⲤ ⲈⲦϬⲞⲞⲘⲈ ϢⲀⲦⲚⲀⲨ ϮⲚⲀϢⲰⲠⲈ ⲚⲘⲘⲎⲦⲚ ϢⲀⲦⲚⲀⲨ ϮⲚⲀⲀⲚⲈⲬ ⲈⲘⲘⲰⲦⲚ ⲀⲨⲠⲈⲔϢⲎⲢⲈ ⲚⲀⲒ ⲈⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ⲈⲦⲒ ⲆⲈ ⲈϤϮ ⲘⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀϤⲢⲀϨⲦϤ ⲚϬⲒ ⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲀϤϨⲒⲦⲈ ⲘⲘⲞϤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲀϤⲦⲀⲖϬⲈⲠϢⲎⲢⲈ ϢⲎⲘ ⲀϤⲦⲀⲀϤ ⲘⲠⲈϤⲒⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈϪⲚ ⲦⲘⲚⲦⲚⲞϬ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲨⲢϢⲠⲎⲢⲈ ⲈϪⲚ ⲚⲈⲦϤⲒⲢⲈ ⲘⲘⲞⲞⲨ. ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ϪⲈ. ⲔⲀⲚⲈⲒϢⲀϪⲈ ⲦⲎⲢⲞⲨ ϨⲚ ⲚⲈⲦⲚⲘⲀⲀϪⲈ ⲤⲈⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲄⲀⲢ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲢⲀⲦⲤⲞⲞⲨⲚ ⲈⲠⲈⲒϢⲀϪⲈ ⲀⲨⲰ ⲚⲈϤϨⲞⲂⲤ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲚⲈⲨⲒⲘⲈ ⲈⲢⲞϤ. ⲀⲨⲢϨⲞⲦⲈ ⲈϪⲚⲞⲨϤ ⲈⲦⲂⲈ ⲠⲈⲒϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ⲀⲨⲘⲞⲔⲘⲈⲔ ⲆⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲚⲞϬ ⲈⲦⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤⲤⲞⲞⲨⲚ ⲘⲠⲘⲞⲔⲘⲈⲔ ⲘⲠⲈⲨϨⲎⲦ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲞⲨϢⲎⲢⲈ ϢⲎⲘ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϨⲀϨⲦⲎϤ ");
INSERT INTO copshc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲈⲦⲚⲀϢⲈⲠ ⲠⲈⲒϢⲎⲢⲈ ϢⲎⲘ ⲈⲢⲞϤ ⲈϪⲘ ⲠⲀⲢⲀⲚ ⲈϤϢⲰⲠ ⲘⲘⲞⲒ ⲈⲢⲞϤ ⲀⲨⲰ ⲠⲈⲦⲚⲀϢⲞⲠⲦ ⲈⲢⲞϤ ⲈϤϢⲰⲠ ⲈⲢⲞϤ ⲘⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ ⲠⲔⲞⲨⲒ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲦⲎⲢⲦⲚ ⲠⲀⲒ ⲠⲈ ⲠⲚⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ ⲠⲤⲀϨ ⲀⲚⲚⲀⲨ ⲈⲨⲀ ⲈϤⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲀⲚⲔⲰⲖⲨ ⲘⲘⲞϤ ϪⲈ ⲚϤⲞⲨⲎϨ ⲀⲚ ⲚⲤⲰⲔ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲢⲔⲰⲖⲨ. ⲠⲈⲦⲈⲚϤϮ ⲄⲀⲢ ⲀⲚ ⲚⲘⲘⲎⲦⲚ ⲈϤϮ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲚⲈϨⲞⲞⲨ ⲚⲦⲈϤⲀⲚⲀⲖⲨⲘⲮⲒⲤ ϪⲰⲔ ⲈⲂⲞⲖ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲦⲀϪⲢⲈⲠⲈϤϨⲞ ⲈⲂⲰⲔ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ⲀϤϪⲞⲞⲨ ⲆⲈ ⲚϨⲈⲚϤⲀⲒϢⲒⲚⲈ ϨⲀⲦⲈϤϨⲎ. ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲨϮⲘⲈ ⲚⲦⲈⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲈⲤⲞⲂⲦⲈ ⲚⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ⲀⲨⲰ ⲘⲠⲞⲨϢⲞⲠϤ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲈⲢⲈⲦⲈϤⲢⲀⲔⲦⲤ ⲂⲎⲔ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ⲀⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲀⲨ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲘⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲔⲞⲨⲰϢ ⲈⲦⲢⲈⲚϪⲞⲞⲤ ⲚⲦⲈⲞⲨⲔⲰϨⲦ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚϤϤⲞⲦⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ⲀϤⲔⲞⲦϤ ⲆⲈ ⲀϤⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ⲀϤⲂⲰⲔ ⲈⲔⲈϮⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ϨⲒⲦⲈϨⲒⲎ. ⲠⲈϪⲈⲞⲨⲀ ⲚⲀϤ ϪⲈ ϮⲚⲀⲞⲨⲀϨⲦ ⲚⲤⲰⲔ ⲈⲠⲘⲀ ⲈⲦⲔⲚⲀⲂⲰⲔ ⲈⲢⲞϤ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ϪⲈ ⲞⲨⲚⲦⲈ ⲂⲂⲀϢⲞⲞⲢ ⲚⲈⲨⲂⲎⲂ ⲀⲨⲰ ⲞⲨⲚⲦⲈⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ⲚⲈⲨⲘⲀϨ. ⲠϢⲎⲢⲈ ⲆⲈ ⲘⲠⲢⲰⲘⲈ ⲘⲘⲚⲦϤⲘⲀ ⲢⲢⲈⲔⲦⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲔⲈⲞⲨⲀ ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲔⲀⲀⲦ ⲚϢⲞⲢⲠ ⲦⲀⲂⲰⲔ ⲦⲀⲦⲰⲘⲤ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲖⲞⲔ ϨⲀⲚⲈⲦⲘⲞⲞⲨⲦ ⲈⲦⲰⲘⲤ ⲚⲚⲈⲨⲢⲈϤⲘⲞⲞⲨⲦ ⲚⲦⲞⲔ ⲆⲈ ⲂⲰⲔ ⲦⲀϢⲈⲞⲒϢ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ⲠⲈϪⲈⲔⲈⲨⲀ ⲆⲈ ϪⲈ ⲦⲀⲞⲨⲀϨⲦ ⲚⲤⲰⲔ ⲠϪⲞⲈⲒⲤ ⲔⲀⲀⲦ ⲚϢⲞⲢⲠ ⲦⲀⲂⲰⲔ ⲦⲀⲀⲠⲞⲦⲀⲤⲤⲈ ⲚⲚⲀⲠⲀⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ. ⲘⲈⲢⲈⲖⲀⲀⲨ ⲦⲀⲖⲈⲦⲞⲞⲦϤ ⲈϪⲚ ⲞⲨϨⲂⲂⲈ ⲚϤϬⲰϢⲦ ⲈⲠⲀϨⲞⲨ ⲚϤⲤⲞⲞⲨⲦⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ⲘⲚⲚⲤⲀⲚⲀⲒ ⲀⲠϪⲞⲈⲒⲤ ⲤⲈⲦⲠⲔⲈϢϤⲈ ⲤⲚⲞⲞⲨⲤ ⲀϤϪⲞⲞⲨⲤⲈ ⲤⲚⲀⲨ ⲤⲚⲀⲨ ϨⲀⲦⲈϤϨⲎ ⲈⲠⲞⲖⲒⲤ ⲚⲒⲘ ⲚⲘⲘⲀ ⲚⲒⲘ ⲈⲦϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲠⲰϨⲤ ⲘⲈⲚ ⲚⲀϢⲰϤ ⲚⲈⲢⲄⲀⲦⲎⲤ ⲆⲈ ⲤⲂⲔⲎⲠⲈ. ⲤⲈⲠⲤⲠϪⲞⲈⲒⲤ ⲆⲈ ⲘⲠⲰϨⲤ ϪⲈ ⲈϤⲈⲚⲈϪ ⲈⲢⲄⲀⲦⲎⲤ ⲈⲂⲞⲖ ⲈⲠⲈϤⲰϨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ⲂⲰⲔ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮϪⲞⲞⲨ ⲘⲘⲰⲦⲚ ⲚⲐⲈ ⲚϨⲈⲚϨⲒⲈⲒⲂ ⲚⲦⲘⲎⲦⲈ ⲚϨⲈⲚⲞⲨⲰⲚϢ. ");
INSERT INTO copshc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ⲘⲠⲢϤⲒⲦⲰⲰⲘⲈ ⲞⲨⲆⲈ ⲠⲎⲢⲀ. ⲞⲨⲆⲈ ⲦⲞⲞⲨⲈ. ⲀⲨⲰ ⲘⲠⲢⲀⲤⲠⲀⲌⲈ ⲖⲖⲀⲀⲨ ϨⲒⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ⲠⲎⲒ ⲆⲈ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲀϪⲒⲤ ⲚϢⲞⲢⲠ ϪⲈ ϮⲢⲎⲚⲎ ⲘⲠⲈⲒⲎⲒ ");
INSERT INTO copshc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲞⲨⲚϢⲎⲢⲈ ⲚⲈⲒⲢⲎⲚⲎ ⲘⲘⲀⲨ ⲈⲢⲈ ⲦⲈⲦⲚⲈⲒⲢⲎⲚⲎ ⲘⲦⲞⲚ ⲘⲘⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈϢⲰⲠⲈ ⲆⲈ ⲘⲘⲞⲚ ⲈⲤⲈⲔⲞⲦⲤ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ⲈⲦⲈⲦⲚⲈϬⲰ ⲆⲈ ϨⲚ ⲞⲨⲎⲒ ⲚⲞⲨⲰⲦ ⲈⲦⲈⲦⲚⲞⲨⲰⲘ ⲀⲨⲰ ⲈⲦⲈⲦⲚⲤⲰ ⲚⲦⲞⲞⲦⲞⲨ. ⲠⲈⲢⲄⲀⲦⲎⲤ ⲄⲀⲢ ⲘⲠϢⲀ ⲘⲠⲈϤⲂⲈⲔⲈ. ⲘⲠⲢⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲎⲒ ⲈⲨⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ⲦⲠⲞⲖⲈⲒⲤ ⲆⲈ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ⲚⲤⲈϢⲈⲠⲦⲎⲨⲦⲚ ⲈⲢⲞⲞⲨ ⲞⲨⲰⲘ ⲚⲚⲈⲦⲞⲨⲚⲀⲔⲀⲀⲨ ϨⲀⲢⲰⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲦⲀⲖϬⲈⲚⲈⲦϢⲰⲚⲈ ⲚϨⲎⲦⲤ. ⲚⲦⲈⲦⲚϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ⲀⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ϨⲰⲚ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ⲦⲠⲞⲖⲈⲒⲤ ⲆⲈ ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ⲚⲤⲈⲦⲘϢⲈⲠⲦⲎⲨⲦⲚ ⲈⲢⲞⲞⲨ. ⲀⲘⲎⲒⲦⲚ ⲈⲂⲞⲖ ⲈⲚⲈⲤⲠⲖⲀⲦⲒⲀ ⲚⲦⲈⲦⲚϪⲞⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ϪⲈ ⲠⲔⲈϢⲞⲒϢ ⲈⲚⲦⲀϤⲦⲰϬⲈ ⲈⲚⲈⲚⲞⲨⲈⲢⲎⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲦⲚⲠⲞⲖⲈⲒⲤ. ⲦⲚϤⲰⲦⲈ ⲘⲘⲞϤ ⲚⲎⲦⲚ. ⲠⲖⲎⲚ ⲈⲒⲘⲈ ⲈⲠⲀⲒ ϪⲈ ⲀⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ϨⲰⲚ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲤⲈⲚⲀϨⲢⲞϢ ⲚϨⲎⲦ ⲈϪⲚ ⲤⲞⲆⲞⲘⲀ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈϨⲞⲨⲈⲦⲠⲞⲖⲈⲒⲤ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ⲞⲨⲞⲒ ⲚⲈ ⲬⲞⲢⲀⲌⲈⲒⲚ. ⲞⲨⲞⲒ ⲚⲈ ⲂⲎⲆⲤⲀⲒⲆⲀ. ϪⲈ ⲈⲚⲈ ⲚⲦⲀⲚϬⲞⲘ ⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϢⲰⲠⲈ ϨⲚ ⲦⲨⲢⲞⲤ ⲚⲘⲤⲒⲆⲰⲚ ⲈϢϪⲈ ⲀⲨϨⲘⲞⲞⲤ ϨⲚ ⲞⲨϬⲞⲞⲨⲚⲈ ⲚⲘⲞⲨⲔⲢⲘⲈⲤ ⲈⲨⲘⲈⲦⲀⲚⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ⲠⲖⲎⲚ ⲤⲈⲚⲀⲀⲚⲈⲬⲈ ⲚⲦⲨⲢⲞⲤ ⲚⲘⲤⲒⲆⲰⲚ ϨⲚ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲨⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ⲚⲦⲞ ϨⲰⲰⲦⲈ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲘⲎ ⲦⲈⲚⲀϪⲒⲤⲈ ϢⲀϨⲢⲀⲒ ⲈⲦⲠⲈ. ⲤⲈⲚⲀⲚⲦⲈ ϢⲀⲀⲘⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ⲠⲈⲦⲤⲰⲦⲘ ⲈⲢⲰⲦⲚ ⲈϤⲤⲰⲦⲘ ⲈⲢⲞⲒ ⲀⲨⲰ ⲠⲈⲦⲀⲐⲈⲦⲒ ⲘⲘⲰⲦⲚ. ⲈϤⲀⲐⲈⲦⲒ ⲘⲘⲞⲒ. ⲠⲈⲦⲀⲐⲈⲦⲒ ⲆⲈ ⲘⲘⲞⲒ ⲈϤⲀⲐⲈⲦⲒ ⲘⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲚϬⲒ ⲠⲈϢϤⲈⲤⲚⲞⲞⲨⲤ ϨⲚ ⲞⲨⲢⲀϢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲔⲈⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲤⲈϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲀⲚ ϨⲘ ⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲚⲈⲒⲚⲀⲨ ⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲐⲈ ⲚⲞⲨⲂⲢⲎϬⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲒϮ ⲚⲎⲦⲚ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲈϨⲰⲘ ⲈϪⲚ ⲚϨⲞϤ ⲚⲘⲞⲨⲞⲞϨⲈ ⲀⲨⲰ ⲈϪⲚ ⲦϬⲞⲘ ⲦⲎⲢⲤ ⲘⲠϪⲀϪⲈ ⲚⲦⲈⲦⲘⲖⲀⲀⲨ ϪⲒⲦⲎⲨⲦⲚ ⲚϬⲞⲚⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ⲠⲖⲎⲚ ⲘⲠⲢⲢⲀϢⲈ ϨⲘ ⲠⲀⲒ ϪⲈ ⲚⲈⲠⲚⲈⲨⲘⲀ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲎⲦⲚ. ⲢⲀϢⲈ ⲆⲈ ⲚⲦⲞϤ ϪⲈ ⲚⲈⲦⲚⲢⲀⲚ ⲤⲎϨ ϨⲚ ⲘⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀϤⲦⲈⲖⲎⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲠⲈϪⲀϤ ϪⲈ ϮⲈⲜⲞⲘⲞⲖⲞⲄⲒ ⲚⲀⲔ ⲠⲀⲒⲰⲦ ⲠϪⲞⲈⲒⲤ ⲚⲦⲠⲈ ⲚⲘⲠⲔⲀϨ ϪⲈ ⲀⲔϨⲈⲠⲚⲀⲒ ⲈⲚⲤⲞⲪⲞⲤ ⲚⲘⲚⲤⲀⲂⲈ ⲀⲔϬⲞⲖⲠⲞⲨ ⲈⲂⲞⲖ ⲈϨⲈⲚϢⲎⲢⲈ ϢⲎⲘ ⲀϨⲈ ⲠⲀⲒⲰⲦ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀⲤⲢⲀⲚⲀⲔ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ⲀⲨϮ ⲚⲀⲒ ⲚϨⲰⲂ ⲚⲒⲘ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲘⲘⲚⲖⲀⲀⲨ ⲤⲞⲞⲨⲚ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠϢⲎⲢⲈ ⲚⲤⲀⲠⲒⲰⲦ ⲎⲚⲒⲘ ⲠⲈ ⲠⲒⲰⲦ ⲚⲤⲀⲠϢⲎⲢⲈ. ⲀⲨⲰ ⲠⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲚⲀⲞⲨⲀϢϤ ϢⲀϤϬⲰⲖⲠ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ⲀϤⲔⲞⲦϤ ⲆⲈ ⲈⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲤⲀⲞⲨⲤⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲚⲀⲒⲀⲦⲞⲨ ⲚⲂⲂⲀⲖ ⲈⲦⲚⲀⲨ ⲈⲚⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀϨⲀϨ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲒⲢⲢⲞ ⲞⲨⲈϢ ⲚⲀⲨ ⲈⲚⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲘⲠⲞⲨⲚⲀⲨ. ⲀⲨⲰ ⲈⲤⲰⲦⲘ ⲈⲢⲞⲒ ⲈⲚⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲘⲠⲞⲨⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ⲈⲒⲤⲞⲨⲚⲞⲘⲒⲔⲞⲤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲈϤⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲈⲒⲚⲀⲢⲞⲨ ⲦⲀⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲤⲎϨ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲈⲔⲰϢ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲈⲔⲈⲘⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲔⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈⲔϨⲎⲦ ⲦⲎⲢϤ ⲚⲘⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲚⲘⲦⲈⲔϬⲞⲘ ⲦⲎⲢⲤ ⲘⲚ ⲚⲈⲔⲘⲈⲈⲨⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲚⲦⲈⲔϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ. ⲀⲔⲞⲨⲰϢⲂ ϨⲚ ⲞⲨⲤⲞⲞⲨⲦⲚ ⲀⲢⲒⲠⲀⲒ ⲀⲨⲰ ⲔⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ⲚⲦⲞϤ ⲆⲈ ⲈϤⲞⲨⲈϢ ⲦⲘⲀⲒⲞϤ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲈⲦϨⲒⲦⲞⲨⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲞⲨⲢⲰⲘⲈ ⲠⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲒⲈⲢⲒⲬⲰ. ⲀϤⲈⲒ ⲈⲦⲞⲞⲦⲞⲨ ⲚϨⲈⲚⲘⲀ ⲚⲤⲞⲞⲚⲈ ⲚⲀⲒ ⲆⲈ ⲀⲨⲔⲀⲀϤ ⲔⲀϨⲎⲞⲨ ⲀⲨϪϤϨⲈⲚⲤⲀϢ ⲀⲨⲂⲰⲔ ⲀⲨⲔⲀⲀϤ ⲈϤⲞ ⲘⲠϢⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ϨⲚ ⲞⲨϢⲤⲚⲈ ⲆⲈ ⲀⲨⲞⲨⲎⲎⲂ ⲈⲒ ⲈⲠⲈⲤⲎⲦ ϨⲒⲦⲈϨⲒⲎ ⲈⲦⲘⲘⲀⲨ ⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤⲤⲀⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ϨⲞⲘⲞⲒⲰⲤ ⲞⲚ ⲞⲨⲖⲈⲨⲈⲦⲎⲤ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈϪⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤⲤⲀⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ⲀⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲆⲈ ⲈϤⲘⲞⲞϢⲈ ⲈⲒ ⲈϪⲰϤ ⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤϢⲚϨⲦⲎϤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ⲀϤϮⲠⲈϤⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀϤⲘⲞⲨⲢ ⲚⲚⲈϤⲤⲀϢ ⲀϤⲠⲰϨⲦ ⲚⲞⲨⲚⲈϨ ⲈϪⲰⲞⲨ ⲚⲘⲞⲨⲎⲢⲠ ⲀϤⲦⲀⲖⲞϤ ⲈϪⲚ ⲠⲈϤⲦⲂⲚⲎ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲀϤⲚⲦϤ ⲈⲨⲠⲀⲚⲦⲞⲬⲒⲞⲚ ⲀϤϤⲒⲠⲈϤⲢⲞⲞⲨϢ. ");
INSERT INTO copshc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲀϤϮϤⲔⲎⲦⲈ ⲘⲠⲠⲀⲚⲦⲞⲬⲈⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ϤⲒⲠⲈϤⲢⲞⲞⲨϢ ⲀⲨⲰ ⲠⲈⲦⲔⲚⲀϪⲞϤ ⲈⲂⲞⲖ ⲈⲢⲞϤ. ⲈⲒϢⲀⲚⲔⲦⲞⲒ ϮⲚⲀⲦⲀⲀϤ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ⲚⲒⲘ ⲘⲠⲈⲒϢⲞⲘⲚⲦ ⲚⲚⲀϨⲢⲀⲔ ⲠⲈⲚⲦⲀϤⲢ ⲠⲈⲦϨⲒⲦⲞⲨⲰϤ ⲘⲠⲈⲚⲦⲀϤⲈⲒ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲤⲞⲞⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈⲚⲦⲀϤⲢⲠⲚⲀ ⲚⲘⲘⲀϤ ⲠⲈ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲂⲰⲔ ϨⲰⲰⲔ ⲚⲄⲈⲒⲢⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ϨⲘ ⲠⲦⲢⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ⲚⲦⲞϤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲨϮⲘⲈ ⲀⲨⲤϨⲒⲘⲈ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲘⲀⲢⲐⲀ ϢⲞⲠϤ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ⲚⲈⲞⲨⲚⲦⲤ ⲞⲨⲤⲰⲚⲈ ⲆⲈ ⲠⲈ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲘⲀⲢⲒⲀ. ⲦⲀⲒ ⲆⲈ ⲀⲤϨⲘⲞⲞⲤ ϨⲀⲦⲚ ⲞⲨⲈⲢⲎⲦⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀⲤⲤⲰⲦⲘ ⲈⲠⲈϤϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ⲘⲀⲢⲐⲀ ⲆⲈ ⲚⲈⲤⲠⲈⲢⲒⲤⲠⲀ ⲠⲈ ⲈⲨⲚⲞϬ ⲚⲆⲒⲀⲔⲞⲚⲒⲀ. ⲀⲤⲀϨⲈⲢⲀⲦⲤ ⲈϪⲰϤ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲈⲔⲢⲞⲞⲨϢ ⲀⲚ ⲠⲈ ϪⲈ ⲀⲦⲀⲤⲰⲚⲈ ⲔⲀⲀⲦ ⲘⲀⲨⲀⲀⲦ ⲈⲒⲆⲒⲀⲔⲞⲚⲒ. ⲀϪⲒⲤ ϬⲈ ⲚⲀⲤ ϪⲈⲔⲀⲀⲤ ⲈⲤⲈⲠⲰϢⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ⲀⲠϪⲞⲈⲒⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲚⲀⲤ ⲠⲈϪⲀϤ ϪⲈ. ⲘⲀⲢⲐⲀ ⲘⲀⲢⲐⲀ ⲦⲈϤⲒⲢⲞⲞⲨϢ ϨⲀϨⲀϨ ⲀⲨⲰ ⲦⲈϢⲦⲢⲦⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ⲞⲨⲀ ⲆⲈ ⲠⲈⲦⲞⲨⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ⲘⲀⲢⲒⲀ ⲄⲀⲢ ⲀⲤⲤⲈⲦⲠ ⲦⲦⲞ ⲚⲀⲤ ⲈⲦⲚⲀⲚⲞⲨⲤ ⲦⲀⲒ ⲈⲚⲤⲈⲚⲀϤⲒⲦⲤ ⲚⲦⲞⲞⲦⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤϨⲚⲞⲨⲘⲀ ⲈϤϢⲖⲎⲖ ⲚⲦⲈⲢⲈϤⲞⲨⲰ ⲠⲈϪⲈⲞⲨⲀ ⲚⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲀⲦⲤⲀⲂⲞⲚ ⲈϢⲖⲎⲖ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲦⲤⲀⲂⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲈⲦⲚⲀϢⲖⲎⲖ ⲀϪⲒⲤ ϪⲈ ⲠⲈⲚⲒⲰⲦ ⲈⲦϨⲚ ⲘⲠⲎⲨⲈ ⲘⲀⲢⲈⲠⲈⲔⲢⲀⲚ ⲞⲨⲞⲠ ⲘⲀⲢⲈⲦⲈⲔⲘⲚⲦⲢⲢⲞ ⲈⲒ. ⲘⲀⲢⲈⲠⲈⲔⲞⲨⲰϢ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ⲠⲈⲚⲞⲒⲔ ⲈⲦⲚⲎⲞⲨ ⲦⲀⲀϤ ⲚⲀⲚ ⲘⲘⲎⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ⲔⲀⲚⲈⲚⲚⲞⲂⲈ ⲚⲀⲚ ⲔⲀⲒⲄⲀⲢ ⲀⲚⲞⲚ ⲦⲚⲔⲰ ⲈⲂⲞⲖ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈⲞⲨⲚⲦⲀⲚ ⲈⲢⲞϤ. ⲀⲨⲰ ⲘⲠⲢϪⲒⲦⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲚⲒⲘ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲠⲈⲦⲚⲀⲔⲀ ⲞⲨϢⲂⲎⲢ ⲚⲀϤ ⲚϤⲂⲰⲔ ϢⲀⲢⲞϤ ⲚⲦⲠⲀϢⲈ ⲚⲦⲈⲨϢⲎ ⲚϤϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈϢⲂⲎⲢ ⲘⲀ ⲚⲀⲒ ⲚϢⲞⲘⲚⲦ ⲚⲚⲞⲒⲔ ⲈⲠⲈⲨϢⲀⲠ ");
INSERT INTO copshc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ⲈⲠⲒⲆⲎ ⲀⲨϢⲂⲎⲢ ⲈⲒ ϢⲀⲢⲞⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϨⲒⲎ ⲀⲨⲰ ⲘⲘⲚϮ ⲠⲈϮⲚⲀⲔⲀⲀϤ ϨⲀⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ⲠⲈⲦⲘⲘⲀⲨ ⲆⲈ ⲚϤⲞⲨⲰϢⲂ ⲘⲠⲤⲀ ⲚϨⲞⲨⲚ ⲚϤϪⲞⲞⲤ ϪⲈ ⲘⲠⲢⲞⲨⲈϨϨⲒⲤⲈ ⲈⲢⲞⲒ ⲀⲒⲞⲨⲰ ⲄⲀⲢ ⲈⲒϢⲦⲀⲘ ⲘⲠⲀⲢⲞ ⲀⲨⲰ ⲚⲀϢⲎⲢⲈ ϨⲒⲠⲈϬⲖⲞϬ ⲚⲘⲘⲀⲒ ⲘⲘⲚϬⲞⲘ ⲘⲘⲞⲒ ⲈⲦⲰⲞⲨⲚ ⲈϮ ⲚⲀⲔ ");
INSERT INTO copshc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈϢϪⲈ ⲚϤⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ ⲈϮ ⲚⲀϤ ϪⲈ ⲠⲈϤϢⲂⲎⲢ ⲠⲈ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲦⲈϤⲘⲚⲦⲖⲀϬ ϤⲚⲀⲦⲰⲞⲨⲚ ⲚϤϮ ⲚⲀϤ ⲘⲠⲈⲦϤⲀϨⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ⲀⲚⲞⲔ ϨⲰ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲒⲦⲒ ⲦⲀⲢⲞⲨϮ ⲚⲎⲦⲚ. ϢⲒⲚⲈ ⲦⲀⲢⲈⲦⲈⲦⲚϬⲒⲚⲈ. ⲦⲰϨⲘ ⲦⲀⲢⲞⲨⲰⲚ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲀⲒⲦⲒ ϤⲚⲀϪⲒ. ⲀⲨⲰ ⲠⲈⲦϢⲒⲚⲈ ϤⲚⲀϬⲒⲚⲈ. ⲀⲨⲰ ⲠⲈⲦⲦⲰϨⲘ ⲤⲈⲚⲀⲞⲨⲰⲚ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ⲚⲒⲘ ⲆⲈ ⲚϨⲎⲦⲦⲎⲞⲨⲦⲚ ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϢⲎⲢⲈ ⲚⲀⲀⲒⲦⲒ ⲘⲘⲞϤ ⲚⲞⲨⲦⲂⲦ. ⲘⲎ ⲈⲠⲘⲀ ⲚⲞⲨⲦⲂⲦ ⲈϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨϨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ⲎⲚϤⲀⲒⲦⲒ ⲘⲘⲞϤ ⲚⲞⲨⲤⲞⲞⲨϨⲈ ⲘⲎ ⲈϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨⲞⲞϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ⲈϢϪⲈ ⲚⲦⲰⲦⲚ ϬⲈ ⲈⲚⲦⲈⲦⲚ ϨⲈⲚⲠⲞⲚⲎⲢⲞⲤ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲚϮⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲚⲈⲦⲚϢⲎⲢⲈ. ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲠⲈⲦⲚⲒⲰⲦ ϤⲚⲀϮ ⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲈⲦⲀⲒⲦⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ⲚⲈϤⲚⲞⲨϪⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲘⲈϤϢⲀϪⲈ. ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲠⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲒ ⲈⲂⲞⲖ. ⲀϤϢⲀϪⲈ ⲚϬⲒ ⲠⲈⲘⲠⲞ ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ⲠⲈϪⲈϨⲞⲒⲚⲈ ⲆⲈ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲈϤⲚⲈϪ ⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲀⲢⲬⲰⲚ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲈⲨⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ ⲚⲦⲞⲞⲦϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ⲚⲦⲞϤ ⲆⲈ ⲈϤⲤⲞⲞⲨⲚ ⲚⲚⲈⲨⲘⲈⲨⲈ ⲚϨⲎⲦ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲘⲚⲦⲢⲢⲞ ⲚⲒⲘ ⲈⲤϢⲀⲚⲠⲰϢ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ϢⲀⲤⲢϪⲀⲒⲈ. ⲀⲨⲰ ⲞⲨⲎⲒ ⲈϪⲚ ⲞⲨⲎⲒ ϢⲀϤϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ⲈϢϪⲈ ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ϨⲰⲰϤ ⲠⲰϢ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲚⲀϢ ⲚϨⲈ ⲦⲈϤⲘⲚⲦⲢⲢⲞ ⲚⲀⲀϨⲈⲢⲀⲦⲤ. ϪⲈ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ⲈϢϪⲈ ⲀⲚⲞⲔ ⲈⲒⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ϨⲚ ⲂⲈⲈⲖⲌⲈⲂⲞⲨⲖ. ⲈⲒⲈⲈⲢⲈ ⲚⲈⲦⲚϢⲎⲢⲈ ⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲘ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲤⲈⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲢⲢⲈϤϮϨⲀⲠ. ");
INSERT INTO copshc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ⲈϢϪⲈ ⲀⲚⲞⲔ ⲆⲈ ⲈⲒⲚⲈϪ ⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲦⲎⲎⲂⲈ ⲚⲦⲈⲠⲚⲞⲨⲦⲈ ⲈⲒⲈ ⲀⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲰϨ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ⲈⲢϢⲀⲚ ⲠⲈⲦϪⲞⲞⲢ ⲆⲈ ϨⲀⲢⲈϨ ⲈⲦⲈϤⲀⲨⲖⲎ ⲈϤϨⲎⲔ. ⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ⲈⲢϢⲀⲚ ⲠⲈⲦϪⲞⲞⲢ ⲆⲈ ⲈⲢⲞϤ ⲈⲒ ⲚϤϪⲢⲞ ⲈⲢⲞϤ. ϤⲚⲀϤⲒ ⲚⲦⲈϤⲠⲀⲚϨⲞⲠⲖⲒⲀ ⲈⲦϤⲔⲰ ⲚϨⲦⲎϤ ⲈⲢⲞⲤ ⲀⲨⲰ ϤⲚⲀⲤⲰⲢ ⲚⲚⲈϤϢⲰⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ⲠⲈⲦⲈⲚϤⲚⲘⲘⲀⲒ ⲀⲚ ⲈϤϮ ⲞⲨⲂⲎⲒ. ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲤⲨⲚⲀⲄⲈ ⲚⲘⲘⲀⲒ ⲀⲚ ⲈϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ϨⲞⲦⲀⲚ ⲆⲈ ⲠⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤϢⲀⲚⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲰⲘⲈ. ϢⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ϨⲈⲚⲘⲀ ⲈⲘⲘⲚⲘⲞⲞⲨ ⲚϨⲎⲦⲞⲨ ⲈϤϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀ ⲚⲘⲦⲞⲚ ⲀⲨⲰ ⲈϤⲦⲘϬⲒⲚⲈ ⲦⲞⲦⲈ ϢⲀϤϪⲞⲞⲤ ϪⲈ ϮⲚⲀⲔⲦⲞⲒ ⲈⲠⲀⲎⲒ ⲈⲠⲘⲀ ⲈⲚⲦⲀⲒⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ⲈϤϢⲀⲚⲈⲒ ⲆⲈ ϢⲀϤϨⲈ ⲈⲢⲞϤ ⲈϤⲤⲀϨⲢ ⲈϤⲦⲤⲀⲘⲒⲎⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ⲦⲞⲦⲈ ϢⲀϤⲂⲰⲔ ⲚϤϪⲒ ⲚⲔⲈⲤⲀϢϤ ⲘⲠⲚⲈⲨⲘⲀ ⲈⲨϨⲞⲞⲨ ⲈⲢⲞϤ ⲚⲤⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲤⲈⲞⲨⲰϨ ⲚϨⲎⲦϤ ⲚⲦⲈⲚϨⲀⲈⲞⲨ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲐⲞ ⲈⲚⲈϤϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤϪⲈⲚⲀⲒ ⲀⲨⲤϨⲒⲘⲈ ϤⲒϨⲢⲀⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ. ⲚⲀⲒⲀⲦⲤ ⲚⲐⲎ ⲈⲚⲦⲀⲤϤⲒ ϨⲀⲢⲞⲔ ⲘⲚ ⲚⲈⲔⲒⲂⲈ ⲚⲀⲈⲒ ⲈⲚⲦⲀⲔϪⲒ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ. ⲚⲀⲒⲀⲦⲞⲨ ⲚϨⲞⲨⲞ ⲚⲚⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ⲈⲢⲈⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲤⲰⲞⲨϨ ⲈⲢⲞϤ ⲀϤⲀⲢⲬⲒ ⲚϪⲞⲞⲤ ϪⲈ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲞⲨⲄⲈⲚⲈⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲦⲈ. ϢϢⲒⲚⲈ ⲚⲤⲀⲞⲨⲘⲀⲈⲒⲚ. ⲀⲨⲰ ⲚⲚⲈⲨⲦⲀ ⲚⲀⲤ ⲘⲀⲈⲒⲚ ⲚⲤⲀⲠⲘⲀⲈⲒⲚ ⲚⲒⲰⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ⲔⲀⲦⲀⲐⲈ ⲄⲀⲢ ⲈⲚⲦⲀⲒⲰⲚⲀⲤ ϢⲰⲠⲈ ⲘⲘⲀⲈⲒⲚ ⲚⲢⲢⲰⲘⲈ ⲚⲚⲒⲚⲈⲨⲎ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲒⲢⲈ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ⲦⲢⲢⲰ ⲘⲠⲢⲎⲤ ⲚⲀⲦⲰⲞⲨⲚ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ ⲚⲘⲚⲢⲰⲘⲈ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ ⲚⲤⲦϬⲀⲒⲞⲞⲨ ϪⲈ ⲀⲤⲒ ϪⲒⲚⲀⲢⲎϪϤ ⲘⲠⲔⲀϨ ⲈⲤⲰⲦⲘ ⲈⲦⲤⲞⲪⲒⲀ ⲚⲤⲞⲖⲞⲘⲰⲚ ⲀⲨⲰ ⲈⲒⲤⲠⲈϨⲞⲨⲞ ⲈⲤⲞⲖⲞⲘⲰⲚ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ⲢⲢⲰⲘⲈ ⲚⲚⲒⲚⲈⲨⲎ ⲚⲀⲦⲰⲞⲨⲚ ϨⲚ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲚⲘⲦⲈⲒⲄⲈⲚⲈⲀ ⲚⲤⲈⲦϬⲀⲒⲞⲤ ϪⲈ ⲀⲨⲘⲈⲦⲀⲚⲞⲒ ⲈⲠⲦⲀϢⲈⲞⲈⲒϢ ⲚⲒⲰⲚⲀ ⲈⲒⲤⲠⲈϨⲞⲨⲞ ⲈⲒⲰⲚⲀ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ⲘⲈⲢⲈⲖⲀⲀⲨ ϪⲈⲢⲈϨⲎⲂⲤ ⲚϤⲔⲀⲀϤ ϨⲚ ⲞⲨⲒ ⲚϨⲰⲠ. ⲀⲖⲖⲀ ⲈϢⲀϤⲔⲀⲀϤ ⲈϪⲚ ⲦⲖⲨⲬⲚⲒⲀ ϪⲈ ⲈⲢⲈⲚⲈⲦⲂⲎⲔ ⲈϨⲞⲨⲚ ⲚⲀⲨ ⲈⲠⲞⲨⲞⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ⲠϨⲎⲂⲤ ⲘⲠⲤⲰⲘⲀ ⲠⲈ ⲠⲂⲀⲖ ⲈϢⲰⲠⲈ ⲞⲨϨⲀⲠⲖⲞⲨⲤ ⲠⲈ ⲠⲈⲔⲂⲀⲖ ⲈⲒⲈⲞⲨⲞⲒⲚ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈϢⲰⲠⲈ ⲆⲈ ⲞⲨⲠⲞⲚⲎⲢⲞⲤ ⲠⲈ ⲠⲈⲔⲂⲀⲖ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲚⲀϢⲰⲠⲈ ⲈϤⲞ ⲚⲔⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ϬⲰϢⲦ ϬⲈ ϪⲈ ⲘⲈϢⲀⲔ ⲠⲞⲨⲞⲒⲚ ⲈⲦⲚϨⲎⲦⲔ ⲞⲨⲔⲀⲔⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ⲈϢϪⲈ ⲞⲨⲞⲒⲚ ϬⲈ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈⲘⲘⲚⲖⲀⲀⲨ ⲘⲘⲈⲢⲞⲤ ⲚⲔⲀⲔⲈ ⲚϨⲎⲦϤ ϤⲚⲀϢⲰⲠⲈ ⲞⲨⲞⲒⲚ ⲦⲎⲢϤ ⲚⲐⲈ ⲈϢⲀⲢⲈⲪⲎⲂⲤ ⲢⲞⲨⲞⲒⲚ ⲈⲢⲞⲔ ϨⲘ ⲠⲈϤϢⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ϨⲘⲠⲦⲢⲈϤϢⲀϪⲈ ⲆⲈ ⲀⲨⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲤⲈⲠⲤⲰⲠϤ ϪⲈ ⲈϤⲈⲞⲨⲰⲘ ⲚⲘⲘⲀϤ. ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲀϤⲚⲞϪϤ. ");
INSERT INTO copshc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ⲚⲦⲈⲢⲈⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲚⲀⲨ ⲀϤⲢϢⲠⲎⲢⲈ ϪⲈ ⲘⲠϤϨⲞⲢⲠϤ ⲚϢⲞⲢⲠ ⲈⲘⲠⲀⲦϤⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ. ⲦⲈⲚⲞⲨ ⲚⲦⲰⲦⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲦⲈⲦⲚⲦⲂⲂⲞ ⲘⲠⲤⲀⲂⲂⲞⲖ ⲘⲠⲀⲠⲞⲦ ⲚⲘⲠⲠⲒⲚⲀⲜ. ⲠⲈⲦⲚⲤⲀ ⲚϨⲞⲨⲚ ⲆⲈ ⲘⲈϨ ⲚⲦⲰⲢⲠ ϨⲒ ⲀⲔⲀⲐⲀⲢⲤⲒⲀ. ⲚⲀⲐⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ⲘⲎ ⲠⲈⲚⲦⲀϤⲦⲀⲘⲒⲈ ⲠⲤⲀⲂⲂⲞⲖ. ⲚⲦⲞϤ ⲀⲚ ⲠⲈⲚⲦⲀϤⲦⲀⲘⲒⲈ ⲠⲤⲀ ⲚϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ⲠⲖⲎⲚ ⲚⲐⲈ ⲈⲚⲦⲀⲤϢⲰⲠⲈ ϮⲘⲚⲦⲚⲀ ⲀⲨⲰ ⲒⲤϨⲎⲎⲦⲈ ⲤⲈⲞⲨⲀⲀⲂ ⲚⲎⲦⲚ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ⲀⲖⲖⲀ ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲦⲈⲦⲚϮ ⲘⲠⲢⲈⲘⲎⲦ ⲘⲪⲀϬⲒⲚⲚⲤⲦⲞⲒ ⲚⲘⲠⲂⲀϢⲞⲨϢ ⲚⲘⲞⲨⲞⲞⲦⲈ ⲚⲒⲘ ⲦⲈⲦⲚⲔⲰ ⲚⲤⲰⲦⲚ ⲘⲠϨⲀⲠ ⲚⲘⲦⲀⲄⲀⲠⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀⲒ ⲆⲈ ⲈϢϢⲈ ⲈⲀⲀⲨ ⲈⲦⲘⲔⲀ ⲚⲈⲒⲔⲞⲞⲨⲈ ⲚⲤⲀⲦⲎⲞⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲦⲈⲦⲚⲘⲈ ⲚⲘⲘⲀ ⲚⲈϨⲘⲞⲞⲤ ⲚϢⲞⲢⲠ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲰ ⲚⲀⲤⲠⲀⲤⲘⲞⲤ ϨⲚ ⲚⲀⲄⲞⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲞ ⲚⲐⲈ ⲚⲚⲒⲘϨⲀⲞⲨ ⲈⲦⲈⲚⲤⲈⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲀⲚ ⲈⲢⲈⲢⲢⲰⲘⲈ ⲘⲞⲞϢⲈ ϨⲒϪⲰⲞⲨ ⲈⲚⲤⲈⲤⲞⲞⲨⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ⲀⲞⲨⲀ ⲆⲈ ⲚⲚⲚⲞⲘⲒⲔⲞⲤ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ. ⲠⲤⲀϨ ⲚⲀⲒ ⲈⲔϪⲰ ⲘⲘⲞⲞⲨ. ⲔⲤⲰϢ ϨⲰⲰⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲚⲞⲘⲒⲔⲞⲤ ⲞⲨⲞⲒ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲦⲀⲖⲞ ⲚϨⲈⲚⲈⲦⲠⲰ ⲈⲨϨⲞⲢϢ ⲈϪⲚ ⲢⲢⲰⲘⲈ ⲈⲚⲦⲈⲦⲚϪⲰϨ ⲀⲚ ⲈⲚⲈⲦⲠⲰ ⲞⲨⲀ ⲚⲚⲈⲦⲚⲦⲎⲎⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲔⲰⲦ ⲚⲚⲈⲘϨⲀⲞⲨ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲦⲚⲈⲒⲞⲦⲈ ⲆⲈ ⲚⲈⲚⲦⲀⲨⲘⲞⲞⲨⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ⲈⲒⲈⲦⲈⲦⲚⲢ ⲘⲚⲦⲢⲈ ⲀⲨⲰ ⲦⲈⲦⲚⲤⲨⲚⲈⲨⲆⲞϬⲒ ⲈⲚⲈϨⲂⲎⲨⲈ ⲚⲚⲈⲦⲚⲒⲞⲦⲈ ϪⲈ ⲚⲦⲞⲞⲨ ⲘⲈⲚ ⲀⲨⲘⲞⲞⲨⲦⲞⲨ ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚⲔⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲦⲔⲈⲤⲞⲪⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲤ ϪⲈ ϮⲚⲀϪⲞⲞⲨ ⲚⲀⲨ ⲚϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲘϨⲈⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲀⲨⲰ ⲚⲤⲈⲆⲒⲰⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ϪⲈ ⲈⲨⲈϢⲒⲚⲈ ⲚⲤⲀⲠⲈⲤⲚⲞϤ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲈⲚⲦⲀⲨⲠⲀϨⲦϤ ⲈⲂⲞⲖ ϪⲒⲚⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ϪⲒⲚⲠⲈⲤⲚⲞϤ ⲚⲀⲂⲈⲖ ϢⲀⲠⲈⲤⲚⲞϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲠϢⲎⲢⲈ ⲂⲂⲀⲢⲀⲬⲒⲀⲤ. ⲠⲈⲚⲦⲀⲨⲦⲀⲔⲞϤ ⲚⲦⲘⲎⲦⲈ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲚⲘⲠⲎⲒ. ⲤⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲤⲈⲚⲀϢⲒⲚⲈ ⲚⲤⲰϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲚⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ⲞⲨⲞⲒ ⲚⲎⲦⲚ ⲚⲚⲞⲘⲒⲔⲞⲤ ϪⲈ ⲀⲦⲈⲦⲚϤⲒ ⲘⲠϢⲞϢⲦ ⲘⲠⲤⲞⲞⲨⲚ ⲘⲠⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲀⲨⲰ ⲘⲠⲈⲦⲚⲔⲀ ⲚⲈⲦⲂⲎⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲢⲬⲒ ⲚⲚⲞⲨϬⲤ ⲈⲢⲞϤ. ⲈⲦⲢⲈϤⲔⲀⲢⲰϤ ⲈⲦⲂⲈϨⲀϨ ");
INSERT INTO copshc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ⲈⲦⲂⲈϨⲀϨ ⲈⲨϬⲰⲢϬ ⲈⲢⲞϤ ⲈϬⲞⲠϤ ⲚⲞⲨϢⲀϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ϨⲘ ⲠⲦⲢⲈⲚⲈⲦⲂⲀ ⲆⲈ ⲘⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲨϨⲰⲘ ⲚⲚⲈⲨⲈⲢⲎⲞⲨ ⲀϤⲀⲢⲬⲒ ⲚϢⲀϪⲈ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚϢⲞⲢⲠ ϪⲈ ϨⲀⲢⲈϨ ⲈⲢⲰⲦⲚ ⲈⲦⲂⲈ ⲠⲈⲐⲀⲂ ⲈⲦⲈⲦⲀⲒ ⲦⲈ ⲐⲨⲠⲞⲔⲢⲒⲤⲒⲤ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ⲘⲘⲚⲖⲀⲀⲨ ⲆⲈ ⲈϤϨⲞⲂⲤ ⲈⲚϤⲚⲀϬⲰⲖⲠ ⲈⲂⲞⲖ ⲀⲚ ⲀⲨⲰ ⲈϤϨⲎⲠ ⲈⲚⲤⲈⲚⲀⲒⲘⲈ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲈⲚⲦⲀⲦⲈⲦⲚϪⲞⲞⲨ ϨⲘ ⲠⲔⲀⲔⲈ ⲤⲈⲚⲀⲤⲞⲦⲘⲞⲨ ϨⲘ ⲠⲞⲨⲞⲒⲚ. ⲀⲨⲰ ⲠⲈⲚⲦⲀⲦⲈⲦⲚϪⲞⲞⲤ ⲈⲠⲈⲨⲘⲀⲀϪⲈ ϨⲚ ⲚⲦⲀⲘⲒⲞⲚ. ⲤⲈⲚⲀⲦⲀϢⲈⲞⲒϢ ⲘⲘⲞϤ ϨⲒϪⲚ ⲚϪⲈⲚⲈⲠⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲚⲀϢⲂⲈⲈⲢ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ϨⲎⲦⲞⲨ ⲚⲚⲈⲦⲚⲀⲘⲞⲨⲞⲨⲦ ⲘⲠⲈⲦⲚⲤⲰⲘⲀ. ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲈⲘⲘⲚⲦⲞⲨ ϨⲞⲨⲈⲠⲀⲒ ⲈⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ϮⲚⲀⲦⲀⲘⲈ ⲦⲎⲞⲨⲦⲚ ⲆⲈ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲈⲦⲚⲀⲢϨⲞⲦⲈ ϨⲎⲦϤ. ⲀⲢⲒϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲈⲦⲈⲞⲨⲚⲦϤⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ⲘⲚⲚⲤⲀ ⲘⲞⲨⲞⲨⲦⲦⲎⲨⲦⲚ ⲈⲚⲈϪⲦⲎⲞⲨⲦⲚ ⲈⲦⲄⲈϨⲈⲚⲚⲀ. ϨⲀⲒⲞ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲢⲒϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ⲘⲎ ⲚⲤⲈϮ ⲈⲂⲞⲖ ⲀⲚ ⲚϮⲞⲨ ⲚϪⲀϪ ϨⲀϨⲞⲂⲞⲖⲞⲤ ⲤⲚⲀⲨ ⲀⲨⲰ ⲚⲤⲈⲞⲂϢ ⲀⲚ ⲈⲨⲀ ⲘⲘⲞⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ⲀⲖⲖⲀ ⲚⲔⲈϤⲰ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲦⲚⲀⲠⲈ ⲎⲠ. ⲘⲠⲢⲢϨⲞⲦⲈ ⲦⲈⲦⲚϢⲞⲂⲈ ⲈϨⲀϨ ⲚϪⲀϪ ");
INSERT INTO copshc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀϨⲞⲘⲞⲖⲞⲄⲒ ⲘⲘⲞⲒ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲢⲢⲰⲘⲈ. ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀϨⲞⲘⲞⲖⲞⲄⲒ ⲚϨⲎⲦϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ⲠⲈⲦⲚⲀⲀⲢⲚⲀ ⲆⲈ ⲘⲘⲞⲒ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲢⲢⲰⲘⲈ ⲤⲈⲚⲀⲀⲢⲚⲀ ⲘⲘⲞϤ ⲘⲠⲈⲘⲦⲞ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀϪⲰ ⲚⲞⲨϢⲀϪⲈ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲤⲈⲚⲀⲔⲀⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ ⲠⲈⲦⲚⲀϪⲒⲞⲨⲀ ⲆⲈ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲤⲈⲚⲀⲔⲰ ⲀⲚ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲨϢⲀⲚϪⲒ ⲦⲎⲞⲨⲦⲚ ⲈϨⲞⲨⲚ ⲚⲚⲀϨⲢⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲘⲚⲚⲀⲢⲬⲎ ⲚⲘⲚⲚⲈⲜⲞⲨⲤⲒⲀ. ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ϪⲈ ⲈⲦⲈⲦⲚⲀϪⲞⲞⲤ ϪⲈ ⲞⲨ ⲎⲈⲦⲈⲦⲚⲀⲢⲀϢ ⲚϨⲈ. ⲎϪⲈ ⲈⲦⲈⲦⲚⲀⲞⲨⲞϢⲂⲞⲨ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ⲠⲈⲠⲚⲈⲨⲘⲀ ⲄⲀⲢ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲀⲦⲤⲀⲂⲈⲦⲎⲨⲦⲚ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲈⲦⲈⲦⲚⲀϪⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ⲠⲈϪⲈⲞⲨⲀ ⲆⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ϪⲈ. ⲠⲤⲀϨ. ⲀϪⲒⲤ ⲘⲠⲀⲤⲞⲚ ⲚϤⲠⲈϢⲦⲈⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ⲈϪⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ. ⲠⲢⲰⲘⲈ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞⲒ ⲚⲔⲢⲒⲦⲎⲤ ⲀⲨⲰ ⲢⲢⲈϤⲠⲰϢ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ. ϮϨⲦⲎⲦⲚ ⲀⲨⲰ ϨⲀⲢⲈϨ ⲈⲢⲰⲦⲚ ⲈϤⲰϬⲈ ⲚⲒⲘ ϪⲈ ⲈⲢϢⲀⲚⲚⲈⲚⲔⲀ ⲀϢⲀⲒ ⲚⲞⲨⲀ ⲈϤⲚⲀϨⲈ ⲈⲠⲈϤⲰⲚϨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ⲀϤϪⲰ ⲆⲈ ⲚⲀⲨ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲞⲨⲢⲰⲘⲈ ⲢⲢⲘⲘⲀⲞ ⲠⲈⲚⲦⲀⲦⲈϤⲬⲰⲢⲀ ⲞⲨⲰⲰⲖⲈ ");
INSERT INTO copshc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ⲈⲀϤⲘⲈⲔⲘⲞⲨⲔϤ ⲆⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲈⲒⲚⲀⲢⲞⲨ ϪⲈ ⲘⲚϮ ⲘⲀ ⲚⲤⲈⲨϨ ⲚⲀⲔⲀⲢⲠⲞⲤ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ϮⲚⲀⲢⲠⲀⲒ. ϮⲚⲀϢⲞⲢϢⲢ ⲚⲀⲀⲠⲞⲐⲎⲔⲎ ⲚⲦⲀⲔⲞⲦⲞⲨ ⲚϨⲈⲚⲚⲞϬ ⲦⲀⲤⲰⲞⲨϨ ⲈⲢⲞⲞⲨ ⲘⲠⲤⲞⲨⲞ ⲦⲎⲢϤ ⲚⲘⲚⲀⲀⲄⲀⲐⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ⲦⲀϪⲞⲞⲤ ⲚⲦⲀⲮⲨⲬⲎ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲞⲨⲚⲦⲈϨⲀϨ ⲘⲘⲀⲨ ⲚⲀⲄⲀⲐⲞⲚ ⲈⲨⲔⲎ ⲚⲈ ⲈϨⲢⲀⲒ ⲚϨⲀϨ ⲢⲢⲞⲘⲠ ⲘⲦⲞⲚ ⲘⲘⲞ ⲞⲨⲰⲘ ⲤⲰ ⲈⲨⲪⲢⲀⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ⲠⲈϪⲈⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠⲀⲐⲎⲦ ⲤⲈⲚⲀϤⲒ ⲚⲦⲈⲔⲮⲨⲬⲎ ⲚⲦⲈⲒⲞⲨϢⲎ ⲚⲦⲞⲞⲦⲔ ⲚⲈⲚⲦⲀⲔⲤⲂⲦⲰⲦⲞⲨ ⲆⲈ ⲈⲨⲚⲀϢⲰⲠⲈ ⲚⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲈⲦⲤⲰⲞⲨϨ ⲚⲀϤ ⲈϨⲞⲨⲚ ⲈⲚϤⲞ ⲀⲚ ⲢⲢⲘⲘⲀⲞ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ⲈⲦⲈⲦⲚⲮⲨⲬⲎ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲞⲨⲞⲘϤ. ⲞⲨⲆⲈ ⲠⲈⲦⲚⲤⲰⲘⲀ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲦⲀⲀϤ ϨⲒⲰⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ϪⲈ ⲦⲈⲦⲚⲮⲨⲬⲎ ⲞⲨⲞⲞⲦ ⲈⲦⲈϨⲢⲈ ⲀⲨⲰ ⲠⲤⲰⲘⲀ ⲈⲦϨⲂⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ϬⲰϢⲦ ⲈⲚⲀⲂⲞⲔⲈ ϪⲈ ⲚⲤⲈϪⲞ ⲀⲚ ⲚⲤⲈⲰϨⲤ ⲀⲚ ⲈⲘⲘⲚⲦⲞⲨⲦⲀⲘⲒⲞⲚ ⲘⲘⲀⲨ ⲞⲨⲆⲈ ⲀⲠⲞⲐⲎⲔⲎ ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲤⲀⲀⲚϢ ⲘⲘⲞⲞⲨ. ⲚⲦⲰⲦⲚ ϬⲈ ⲦⲈⲦⲚϢⲞⲂⲈ ⲈⲚϨⲀⲖⲀⲦⲈ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ⲚⲒⲘ ⲆⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲈϤϤⲒⲢⲞⲞⲨϢ ⲠⲈⲦⲈⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲨⲈϨⲞⲨⲘⲀϨⲈ ⲈⲦⲈϤϢⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ⲈϢϪⲈ ⲘⲘⲚϬⲞⲘ ϬⲈ ⲘⲘⲰⲦⲚ ⲈⲨⲔⲞⲨⲈⲒ. ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚϤⲒⲢⲞⲞⲨϢ ⲈⲠⲔⲈⲤⲈⲈⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ϮϨⲦⲎⲦⲚ ⲈⲚⲈⲔⲢⲒⲚⲞⲚ ⲚⲐⲈ ⲈⲦⲞⲨⲀⲒⲀⲈⲒ ⲘⲘⲞⲤ ⲈⲚⲤⲈϨⲒⲤⲈ ⲀⲚ ⲈⲚⲤⲈⲰⲦϨ ⲀⲚ. ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲈⲤⲞⲖⲞⲘⲰⲚ ϨⲘ ⲠⲈϤⲈⲞⲞⲨ ⲦⲎⲢϤ ϮϨⲒⲰⲰϤ ⲚⲐⲈ ⲚⲞⲨⲀ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ⲈϢϪⲈ ⲠⲈⲬⲞⲢⲦⲞⲤ ⲈⲦϨⲚ ⲦⲤⲰϢⲈ ⲘⲠⲞⲞⲨ ⲢⲀⲤⲦⲈ ⲈⲨⲚⲀⲚⲞϪϤ ⲈⲦⲈⲦⲢⲒⲢ ⲠⲚⲞⲨⲦⲈ ϮϨⲒⲰⲰϤ ⲚⲦⲈⲒϨⲈ. ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ϨⲒⲰⲦⲦⲎⲨⲦⲚ ⲚⲀⲦⲔⲞⲨⲒ ⲘⲠⲒⲤⲦⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ⲘⲠⲢϢⲒⲚⲈ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲞⲨⲞⲘϤ. ⲎⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲤⲞⲞϤ. ⲘⲠⲢϤⲒⲢⲞⲞⲨϢ ");
INSERT INTO copshc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ϪⲈ ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚϨⲈⲐⲚⲞⲤ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲚⲈⲦϢⲒⲚⲈ ⲚⲤⲰⲞⲨ. ⲠⲈⲦⲚⲒⲰⲦ ⲆⲈ ⲤⲞⲞⲨⲚ ϪⲈ ⲦⲈⲦⲚⲢⲬⲢⲒⲀ ⲚⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ⲠⲖⲎⲚ ϢⲒⲚⲈ ⲚⲦⲞϤ ⲚⲤⲀ ⲦⲈϤⲘⲚⲦⲢⲢⲞ ⲀⲨⲰ ⲚⲀⲒ ⲤⲈⲚⲀⲞⲨⲀϨⲞⲨ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ⲘⲠⲢⲢϨⲞⲦⲈ ⲠⲔⲞⲨⲒ ⲚⲞϨⲈ ϪⲈ ⲠⲈⲦⲚⲒⲰⲦ ⲞⲨⲈϢϮ ⲚⲎⲦⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ϮⲚⲈⲦⲚⲚⲔⲀ ⲈⲂⲞⲖ ⲦⲀⲀⲨ ⲘⲘⲚⲦⲚⲀ ⲘⲀⲦⲀⲘⲒⲞ ⲚⲎⲦⲚ ⲚϨⲈⲚⲦⲰⲰⲘⲈ ⲈⲚⲤⲈⲚⲀⲢⲀⲤ ⲀⲚ ⲚⲘⲞⲨⲀϨⲞ ⲚⲀⲦⲰϪⲚ ϨⲚ ⲘⲠⲎⲨⲈ ⲠⲘⲀ ⲈⲦⲈ ⲘⲈⲢⲈ ⲠⲈϤϪⲒⲞⲨⲈ ϨⲰⲚ ⲈⲢⲞϤ ⲀⲨⲰ ⲘⲈⲢⲈϪⲞⲞⲖⲈⲤ ⲦⲀⲔⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ⲠⲘⲀ ⲄⲀⲢ ⲈⲦⲈⲢⲈ ⲠⲈⲦⲚⲀϨⲞ ⲚⲀϢⲰⲠⲈ ⲘⲘⲞϤ ⲈⲢⲈⲠⲈⲦⲚϨⲎⲦ ⲚⲀϢⲰⲠⲈ ϨⲒⲰⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ⲘⲀⲢⲈⲚⲈⲦⲚϮⲠⲈ ϢⲰⲠⲈ ⲈⲨⲘⲎⲢ ⲈⲢⲈⲚⲈⲦⲚϨⲎⲂⲤ ⲘⲞⲨϨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ⲚⲦⲈⲦⲚⲢⲐⲈ ⲚⲚⲒⲢⲰⲘⲈ ⲈⲦϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦϤ ⲘⲠⲈⲨϪⲞⲈⲒⲤ ϪⲈ ⲈϤⲚⲀϬⲰⲖⲠ ⲦⲚⲀⲨ ϨⲘ ⲠⲘⲀ ⲚϢⲈⲖⲈⲈⲦ. ϪⲈⲔⲀⲀⲤ ⲈϤϢⲀⲚⲈⲒ ⲚϤⲦⲰϨⲘ ⲈⲨⲈⲞⲨⲰⲚ ⲚⲀϤ ⲚⲦⲈⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲚⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲈⲨϪⲞⲈⲒⲤ ⲚⲎⲞⲨ ⲚϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲢⲞⲒⲤ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϤⲚⲀⲘⲞⲢϤ ⲚϤⲦⲢⲈⲨⲚⲞϪⲞⲨ ⲚϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲰⲞⲨ ⲈϤⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ⲔⲀⲚ ⲈϤϢⲀⲚⲈⲒ ϨⲚ ⲦⲘⲈϨⲤⲚⲦⲈ ⲚⲞⲨⲢϢⲈ ⲎⲦⲘⲈϨϢⲞⲘⲦⲈ ⲚϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲒⲢⲈ ϨⲒⲚⲀⲒ ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ⲦⲈⲦⲚⲒⲘⲈ ⲆⲈ ⲈⲠⲀⲒ ϪⲈ ⲈⲚⲈϤⲤⲞⲞⲨⲚ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠⲎⲒ ϪⲈ ⲈⲢⲈⲠⲢⲈϤϪⲒⲞⲨⲈ ⲚⲎⲞⲨ ⲚⲀϢ ⲚⲞⲨⲚⲞⲨ ⲚⲈϤⲚⲀⲔⲀⲀⲨ ⲀⲚ ⲈϬⲰⲦϨ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ⲚⲦⲰⲦⲚ ϨⲰⲦⲦⲎⲨⲦⲚ ϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲤⲂⲦⲰⲦ ϪⲈ ⲈⲢⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲎⲞⲨ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ⲠⲈϪⲈⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲔϪⲰ ⲚⲀⲚ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈⲚⲈⲔϪⲰ ⲘⲘⲞⲤ ⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲚⲒⲘ ⲀⲢⲀ ⲠⲈ ⲠⲠⲒⲤⲦⲞⲤ ⲚⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲤⲀⲂⲈ ⲈⲦⲈⲢⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲚⲀⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞϤ ⲈϪⲚ ⲚⲈϤϨⲘϨⲀⲖ ⲈϮ ⲚⲀⲨ ⲚⲦⲈϨⲢⲈ ⲘⲠⲈⲤⲞⲨⲞⲒϢ ");
INSERT INTO copshc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ⲚⲀⲒⲀⲦϤ ⲘⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲚⲎⲞⲨ ⲚϤϨⲈ ⲈⲢⲞϤ ⲈϤⲒⲢⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ⲚⲀⲘⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϤⲚⲀⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞϤ ⲈϪⲚ ⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ⲈϤϢⲀⲚϪⲞⲞⲤ ⲆⲈ ⲚϬⲒ ⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ϨⲘ ⲠⲈϤϨⲎⲦ ϪⲈ ⲠⲀϪⲞⲈⲒⲤ ⲚⲀⲰⲤⲔ ⲈⲈⲒ ⲚϤⲀⲢⲬⲒ ⲚϨⲒⲞⲨⲈ ⲈⲚϨⲘϨⲘϨⲀⲖ ⲚⲘⲚϨⲘϨⲀⲖ ⲚⲤϨⲒⲘⲈ ⲚϤⲞⲨⲰⲘ ⲚϤⲤⲰ ⲚϤϮϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ϤⲚⲎⲞⲨ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲘⲠϨⲘϨⲀⲖ ⲈⲦⲘⲘⲀⲨ ϨⲚ ⲞⲨϨⲞⲞⲨ ⲈⲚϤⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲀⲨⲰ ϨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲈⲚϤⲒⲘⲈ ⲈⲢⲞⲤ ⲀⲚ ⲚϤⲠⲞϢϤ ⲚϤⲔⲀⲦⲈϤⲦⲞ ⲚⲘⲚⲚⲀⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ⲠϨⲘϨⲀⲖ ⲆⲈ ⲈⲚⲦⲀϤⲒⲘⲈ ⲈⲠⲞⲨⲰϢ ⲘⲠⲈϤϪⲞⲈⲒⲤ ⲈⲘⲠϤⲤⲞⲂⲦⲈ ⲎⲈⲘⲠϤⲒⲢⲈ ⲔⲀⲦⲀⲠⲈϤⲞⲨⲰϢ ϤⲚⲀϪⲒ ⲚϨⲈⲚⲚⲞϬ ⲚⲤⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ⲠⲈⲦⲈⲘⲠϤⲒⲘⲈ ⲆⲈ ⲈⲀϤⲢⲠⲈⲘⲠϢⲀ ⲚϨⲈⲚⲤⲎϢⲈ ⲈⲨⲚⲀϪⲚⲀϤ ϨⲈⲚⲔⲞⲨⲒ. ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲘ ⲈⲚⲦⲀⲨϮ ⲚⲀϤ ⲚϨⲞⲨⲞ ⲤⲈⲚⲀϢⲒⲚⲈ ⲚⲤⲀϨⲞⲨⲞ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ⲀⲨⲰ ⲠⲈⲚⲦⲀⲨϬⲀⲖⲈϨⲀϨ ⲈⲢⲞϤ ⲤⲈⲚⲀϢⲀⲦϤ ⲚϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ⲚⲦⲀⲒⲈⲒ ⲈⲚⲞⲨϪⲈ ⲚⲞⲨⲔⲰϨⲦ ⲈϨⲢⲀⲒ ⲈϪⲘⲠⲔⲀϨ ⲀⲨⲰ ⲞⲨ ⲠⲈϮⲞⲨⲀϢϤ ⲈⲦⲢⲈϤϪⲈⲢⲞ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ⲞⲨⲚⲦⲀⲒ ⲞⲨⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲀⲨ ⲈⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲞϤ ϮϬⲎⲠ ϢⲀⲚⲦϤϪⲰⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ⲈⲦⲈⲦⲚⲘⲈⲨⲈ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲈϮ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲘⲠⲔⲀϨ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲞⲚ. ⲀⲖⲖⲀ ⲞⲨⲠⲰⲢϪ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ϪⲒⲚⲦⲈⲚⲞⲨ ⲄⲀⲢ ⲞⲨⲚϮⲞⲨ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲞⲨⲎⲒ ⲚⲞⲨⲰⲦ ⲈⲨⲠⲎϢ ϢⲞⲘⲚⲦ ⲈϪⲚ ⲤⲚⲀⲨ ⲤⲚⲀⲨ ⲈϪⲚ ϢⲞⲘⲚⲦ ");
INSERT INTO copshc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ⲞⲨⲚⲞⲨⲒⲰⲦ ⲚⲀⲠⲰϢ ⲘⲚ ⲠⲈϤϢⲎⲢⲈ ⲀⲨⲰ ⲞⲨϢⲎⲢⲈ ⲚⲘⲠⲈϤⲒⲰⲦ ⲞⲨⲘⲀⲀⲨ ⲘⲘⲦⲈⲤϢⲈⲈⲢⲈ ⲞⲨϢⲈⲈⲢⲈ ⲚⲘⲦⲈⲤⲘⲀⲀⲨ ⲞⲨϢⲰⲘⲈ ⲚⲘⲦⲈⲤϢⲈⲖⲈⲈⲦ ⲞⲨϢⲈⲖⲈⲈⲦ ⲚⲘⲦⲈⲤϢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲘⲘⲎⲎϢⲈ ϪⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲈⲨⲔⲖⲞⲞⲖⲈ ⲀⲤⲈⲒ ⲈϨⲢⲀⲒ ϨⲒⲠⲈⲘⲚⲦ. ϢⲀⲦⲈⲦⲚϪⲞⲞⲤ ⲚⲦⲈⲨⲚⲞⲨ ϪⲈ ⲠϨⲰⲞⲨ ⲚⲀϢⲰⲠⲈ ⲀⲨⲰ ϢⲀⲤϢⲰⲠⲈ ϨⲒⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ⲀⲨⲰ ⲈⲢϢⲀⲚⲠⲦⲞⲨⲢⲎⲤ ⲈⲒ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲚⲞⲨⲔⲀⲨⲤⲰⲚ ⲚⲀϢⲰⲠⲈ. ⲀⲨⲰ ϢⲀϤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ. ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲚⲆⲞϬⲒⲘⲀⲌⲈ ⲘⲠϨⲞ ⲚⲦⲠⲈ ⲚⲘⲠⲔⲀϨ. ⲈⲦⲂⲈ ⲞⲨ ⲆⲈ ⲚⲦⲞϤ ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲆⲞϬⲒⲘⲀⲌⲈ ⲘⲠⲈⲒⲞⲨⲞⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ⲀϨⲢⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚⲔⲢⲒⲚⲈ ⲀⲚ ⲘⲠⲈⲦⲈϢϢⲈ ⲘⲘⲒⲚ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ⲚⲐⲈ ⲄⲀⲢ ⲈⲔⲘⲞⲞϢⲈ ⲘⲚ ⲠⲈⲦϪⲒϨⲀⲠ ⲞⲨⲂⲎⲔ ⲈϤϨⲒⲦⲈϨⲒⲎ ⲘⲀⲦϤⲐⲈ ⲘⲠⲰⲖϬ ⲚⲘⲘⲀⲔ ⲘⲎⲠⲰⲤ ⲚϤⲤⲰⲔ ⲘⲘⲞⲔ ⲈⲨⲢⲈϤϮϨⲀⲠ ⲚⲦⲈⲠⲢⲈϤϮϨⲀⲠ ⲦⲀⲀⲔ ⲈⲦⲞⲞⲦϤ ⲘⲠⲈⲠⲢⲀⲔⲦⲰⲢ ⲚⲦⲈⲠⲈⲠⲢⲀⲔⲦⲰⲢ ⲚⲞϪⲔ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈⲔⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈⲘⲠⲔϮ ⲘⲠⲈⲔϨⲀⲈ ⲖⲖⲈⲠⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲨⲚϨⲞⲒⲚⲈ ⲠⲈ ⲦⲀⲘⲞ ⲘⲘⲞϤ ⲈⲦⲂⲈ ⲚⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲚⲀⲒ ⲈⲚⲦⲀ ⲠⲒⲖⲀⲦⲞⲤ ⲦⲈϨⲠⲈⲨⲤⲚⲞϤ ⲘⲚ ⲚⲈⲨⲐⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲈⲦⲈⲦⲚⲘⲈⲨⲈ ϪⲈ ⲚⲈⲒⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲚⲦⲀⲨⲢⲚⲞⲂⲈ ⲠⲀⲢⲀⲚⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲦⲎⲢⲞⲨ ϪⲈ ⲀⲨϢⲈⲠⲚⲈⲒϨⲒⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲞⲚ. ⲀⲖⲖⲀ ⲈⲦⲈⲦⲚⲦⲘⲘⲈⲦⲀⲚⲞⲒ. ⲦⲈⲦⲚⲀⲦⲀⲔⲞ ⲦⲎⲢⲦⲚ ⲚⲦⲈⲨϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ⲎⲠⲒⲘⲚⲦϢⲘⲎⲚ ⲈⲚⲦⲀⲠⲠⲨⲢⲄⲞⲤ ϨⲈ ⲈϪⲰⲞⲨ ϨⲚ ⲤⲒⲖⲰϨⲀⲘ ⲀϤⲘⲞⲞⲨⲦⲞⲨ. ⲈⲦⲈⲦⲚⲘⲈⲨⲈ ϪⲈ ⲞⲨⲚⲚⲞⲂⲈ ⲈⲢⲞⲞⲨ ⲠⲀⲢⲀⲢⲢⲰⲘⲈ ⲦⲎⲢⲞⲨ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲞⲚ. ⲀⲖⲖⲀ ⲈⲦⲈⲦⲚⲦⲘⲘⲈⲦⲀⲚⲞⲒ ⲦⲈⲦⲚⲀⲦⲀⲔⲞ ⲦⲎⲢⲦⲚ ⲚⲦⲈⲨϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ⲀϤϪⲰ ⲆⲈ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲈⲚⲈⲞⲨⲚⲦⲈⲞⲨⲀ ⲞⲨⲂⲰ ⲚⲔⲚⲦⲈ ⲈⲤϪⲎⲞⲨ ϨⲘ ⲠⲈϤⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀϤⲈⲒ ⲆⲈ ⲀϤϢⲒⲚⲈ ⲚⲤⲀⲠⲈⲤⲔⲀⲢⲠⲞⲤ ⲘⲠϤϨⲈ ⲈⲞⲨⲞⲚ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲀϨⲢⲘ ⲠⲈϬⲘⲈ ϪⲈ. ⲈⲒⲤϢⲞⲘⲦⲈ ⲢⲢⲞⲘⲠⲈ ⲈⲒⲚⲎⲞⲨ ⲈⲒϢⲒⲚⲈ ⲚⲤⲀⲔⲀⲢⲠⲞⲤ ϨⲚ ϮⲂⲰ ⲚⲔⲚⲦⲈ ⲀⲨⲰ ⲚϮϨⲎⲨ ⲈⲨⲞⲚ ⲀⲚϢⲀⲀⲦⲤ ϬⲈ ⲈⲦⲂⲈ ⲞⲨ ⲤⲞⲨⲰⲤϤ ⲘⲠⲔⲈⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲀⲖⲞⲔ ϨⲀⲢⲞⲤ ⲚⲦⲈⲒⲔⲈⲢⲞⲘⲠⲈ ϢⲀⲚϮϬⲢⲎ ⲘⲠⲈⲤⲔⲰⲦⲈ ⲦⲀϮⲘⲈϨⲢⲞ ⲚⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ⲈϢⲰⲠⲈ ⲘⲈⲚ ⲈⲤϢⲀⲚⲦⲀⲨⲈⲔⲀⲢⲠⲞⲤ ⲈⲂⲞⲖ ⲚⲦⲔⲈⲢⲞⲘⲠⲈ. ⲀⲔⲔⲀⲀⲤ. ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ⲀⲔϢⲀⲀⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ⲚⲈϤϮⲤⲂⲰ ⲆⲈ ⲠⲈ ϨⲚ ⲞⲨⲈⲒ ⲚⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ⲀⲨⲰ ⲈⲒⲤⲞⲨⲤϨⲒⲘⲈ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚϢⲰⲚⲈ ⲚⲘⲘⲀⲤ ⲘⲘⲚⲦϢⲘⲎⲚⲈ ⲢⲢⲞⲘⲠⲈ ⲈⲤⲞⲖⲈⲔ ⲈⲘⲘⲚϬⲞⲘ ⲘⲘⲞⲤ ⲈϤⲒϪⲰⲤ ⲈϨⲢⲀⲒ ⲈⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞⲤ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲦⲈⲔⲎ ⲈⲂⲞⲖ ϨⲘ ⲠⲞⲨϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ⲀϤⲦⲀⲖⲞ ⲆⲈ ⲚⲦⲈϤϬⲒϪ ⲈϪⲰⲤ ⲀⲤⲦⲰⲞⲨⲚ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲰ ⲚⲈⲤϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ⲀⲠⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲈϤⲀⲄⲀⲚⲀⲔⲦⲒ ϪⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲢⲠⲀϨⲢⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲘⲘⲎⲎϢⲈ ϪⲈ ⲤⲞⲞⲨ ⲚϨⲞⲞⲨ ⲚⲈⲦⲈϢϢⲈ ⲈⲢϨⲰⲂ ⲚϨⲎⲦⲞⲨ. ⲀⲘϨⲒⲦⲚ ϬⲈ ⲚϨⲎⲦⲞⲨ ⲚⲦⲈⲦⲚ ϪⲒⲠⲀϨⲢⲈ ⲚⲦⲈⲦⲚⲦⲘⲈⲒ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ⲀⲠϪⲞⲈⲒⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲚϨⲨⲠⲞⲔⲢⲒⲦⲎⲤ ⲘⲎ ⲘⲈⲢⲈⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲰⲦⲚ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲂⲖⲠⲈϤⲘⲀⲤⲈ ⲈⲂⲞⲖ ⲎⲠⲈϤⲒⲰ ϨⲘ ⲠⲈϤⲞⲨⲞⲘϤ ⲚϤϪⲒⲦϤ ⲚϤⲦⲤⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ⲦⲀⲒ ⲆⲈ ⲈⲦϢⲈⲈⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲦⲈ ⲈⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲘⲞⲢⲤ ⲒⲤⲘⲚⲦϢⲘⲎⲚⲈ ⲢⲢⲞⲘⲠⲈ ⲚϢϢⲈ ⲀⲚ ⲈⲂⲞⲖⲤ ⲚⲦⲈⲒⲘⲢⲢⲈ ⲘⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ⲈϤϪⲰ ⲆⲈ ⲚⲚⲀⲒ ⲀⲨϪⲒ ϢⲒⲠⲈ ⲦⲎⲢⲞⲨ ⲚϬⲒ ⲚⲈⲦϮ ⲞⲨⲂⲎϤ ⲀⲨⲰ ⲀⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲢⲀϢⲈ ⲈϪⲚ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲦⲀⲒⲎⲞⲨ ⲈⲦϤⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ⲠⲈϪⲀϤ ϬⲈ ϪⲈ ⲈⲢⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲚⲦⲰⲚ ⲈⲞⲨ. ⲀⲨⲰ ⲈⲒⲚⲀⲦⲚⲦⲰⲚⲤ ⲈⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ⲈⲤⲦⲚⲦⲰⲚ ⲈⲨⲂⲖⲂⲒⲖⲈ ⲚϢⲖⲦⲘ ⲈⲀⲨⲢⲰⲘⲈ ϪⲒⲦⲤ ⲀϤⲚⲞϪⲤ ⲈⲦⲈϤϢⲚⲎ. ⲀⲤⲀⲒⲀⲈⲒ ⲀⲤⲢⲞⲨϢⲎⲚ ⲀⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ ⲞⲨⲰϨ ϨⲀⲚⲈⲤⲔⲖⲀⲆⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ⲠⲈϪⲀϤ ⲞⲚ ϪⲈ ⲈⲒⲚⲀⲦⲚⲦⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ⲈⲤⲦⲚⲦⲰⲚ ⲈⲨⲐⲀⲂ ⲈⲀⲨⲤϨⲒⲘⲈ ϪⲒⲦϤ ⲀⲤⲚⲞϪϤ ⲈϢⲞⲘⲚⲦ ⲚϢⲒ ⲚⲚⲞⲒⲦ ϢⲀⲚⲦϤϪⲒⲐⲀⲂ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ⲚⲈϤⲘⲞⲞϢⲈ ⲆⲈ ⲔⲀⲦⲀⲠⲞⲖⲒⲤ ⲀⲨⲰ ⲔⲀⲦⲀϮⲘⲈ ⲈϤϮⲤⲂⲰ ⲈϤⲂⲎⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚϨⲈⲚⲔⲞⲨⲒ ⲚⲈⲦⲚⲀⲞⲨϪⲀⲒ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ⲀⲄⲰⲚⲒⲌⲈ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ϨⲒⲦⲚ ⲦⲠⲨⲖⲎ ⲈⲦϬⲎⲞⲨ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚϨⲀϨ ⲚⲀϢⲒⲚⲈ ⲚⲤⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲤⲈⲦⲘⲈϢϬⲘϬⲞⲘ ");
INSERT INTO copshc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ⲈϤϢⲀⲚⲠϨⲚⲦⲰⲞⲨⲚ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲚϤϢⲦⲀⲘ ⲘⲠⲢⲞ ⲦⲈⲦⲚⲀⲀⲢⲬⲒ ⲚⲦⲰϨⲘ ⲈⲠⲢⲞ ⲈⲦⲈⲦⲚⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ϨⲒⲂⲞⲖ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲀⲨⲰⲚ ⲚⲀⲚ. ϤⲚⲀⲞⲨⲰϢⲂ ⲆⲈ ⲚϤϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲰⲦⲚ ⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ⲦⲞⲦⲈ ⲦⲈⲦⲚⲀⲀⲢⲬⲒ ⲚϪⲞⲞⲤ ϪⲈ ⲀⲚⲞⲨⲰⲘ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀⲚⲤⲰ ⲀⲔϮⲤⲂⲰ ⲚⲀⲚ ϨⲚ ⲚⲈⲚⲠⲖⲀⲦⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ⲀⲨⲰ ϤⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲰⲦⲚ ⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲦⲰⲚ ⲤⲀϨⲈⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ⲚⲈⲢⲄⲀⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲘⲠϪⲒ ⲚϬⲞⲚⲤ ");
INSERT INTO copshc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ⲈⲢⲈⲠⲢⲒⲘⲈ ⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲚⲘⲠϬⲀϨϬϨ ⲚⲚⲞⲂϨⲈ. ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲈⲀⲂⲢⲀϨⲀⲘ ⲚⲘ ⲒⲤⲀⲀⲔ ⲚⲘ ⲒⲀⲔⲰⲂ ⲚⲘ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨⲚⲞⲨϪⲈ ⲆⲈ ⲘⲘⲰⲦⲚ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ⲤⲈⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲢⲢⲀϢⲀ ⲚⲘⲢⲢⲀϨⲰⲦⲠ ⲚⲘⲠⲈⲘϨⲒⲦ ⲚⲘⲠⲢⲎⲤ ⲚⲤⲈⲚⲞϪⲞⲨ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲚϨⲀⲈ ⲚⲀⲢϢⲞⲢⲠ ⲚⲦⲈⲚϢⲞⲢⲠ ⲢϨⲀⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀϨⲈⲚⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϮⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲰⲔ ⲈⲂⲞⲖ ⲚⲄⲖⲞ ϨⲘ ⲠⲈⲒⲘⲀ ϪⲈ ϨⲎⲢⲰⲆⲎⲤ ⲞⲨⲈϢⲘⲞⲞⲨⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲂⲰⲔ ⲀϪⲒⲤ ⲚⲦⲈⲒⲂⲀϢⲞⲢ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲈϪⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲂⲞⲖ. ⲀⲨⲰ ϮⲈⲒⲢⲈ ⲚϨⲈⲚⲦⲀⲖϬⲞ ⲘⲠⲞⲞⲨ ⲚⲘⲢⲀⲤⲦⲈ ⲀⲨⲰ ϮⲚⲀϪⲰⲔ ⲚⲤⲀⲢⲀⲤⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ⲠⲖⲎⲚ ϨⲀⲠⲤ ⲈⲦⲢⲀⲢⲠⲞⲞⲨ ⲚⲘⲢⲀⲤⲦⲈ ⲦⲀⲂⲰⲔ ⲚⲤⲀⲢⲀⲤⲦⲈ ϪⲈ ⲚⲤⲦⲞ ⲀⲚ ⲈⲦⲢⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲞⲨ ⲠⲂⲞⲖ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲈⲦⲘⲞⲨⲞⲨⲦ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦϨⲒⲰⲚⲈ ⲈⲚⲈⲚⲦⲀⲨⲦⲀⲨⲞⲞⲨ ϢⲀⲢⲞⲤ. ϨⲀϨ ⲚⲤⲞⲠ ⲀⲒⲞⲨⲈϢ ⲤⲈⲨϨⲚⲞⲨϢⲎⲢⲈ ⲈϨⲞⲨⲚ ⲚⲐⲈ ⲚⲞⲨϨⲀⲖⲎⲦ ⲈϢⲀϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲈϤⲘⲀⲤ ϨⲀⲚⲈϤⲦⲚϨ ⲀⲨⲰ ⲘⲠⲈⲦⲚⲞⲨⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲤⲈⲚⲀⲔⲀⲠⲈⲦⲚⲎⲒ ⲈⲢⲰⲦⲚ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲒ ϢⲀⲚⲦⲈⲦⲚϪⲞⲞⲤ ϪⲈ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲈⲦⲚⲎⲞⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲞⲨⲀⲢⲬⲰⲚ ⲘⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲨⲘⲞⲈⲒⲔ ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨⲠⲀⲢⲀⲦⲎⲢⲒ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲚϨⲨⲆⲢⲰⲠⲒⲔⲞⲤ ϨⲀⲦⲈϤϨⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲚⲚⲞⲘⲒⲔⲞⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲜⲈⲤⲦⲒ ⲈⲢⲠⲀϨⲢⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈⲚⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲀⲢⲰⲞⲨ ⲀϤⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲘⲞϤ ⲀϤⲦⲀⲖϬⲞϤ ⲀϤⲔⲀⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲒⲘ ⲚϨⲎⲦⲦⲎⲞⲨⲦⲚ ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϢⲎⲢⲈ ⲎⲠⲈϤⲘⲀⲤⲈ ⲚⲀϨⲈ ⲈⲨϢⲰⲦⲈ ⲈⲚϤⲚⲀⲚⲦϤ ⲀⲚ ⲈϨⲢⲀⲒ ⲚⲦⲈⲨⲚⲞⲨ ⲘⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ⲀⲨⲰ ⲘⲠⲞⲨϬⲘϬⲞⲘ ⲈⲞⲨⲞϢⲂⲈϤ ⲚⲚⲀϨⲢⲚ ⲚⲀⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ⲀϤϪⲰ ⲆⲈ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲚⲀϨⲢⲚ ⲚⲈⲦⲦⲀϨⲘ ⲈϤⲚⲀⲨ ⲈⲐⲈ ⲈⲦⲞⲨⲤⲰⲦⲠ ⲚⲀⲨ ⲚⲘⲘⲀ ⲚⲚⲞϪⲞⲨ ⲚⲦⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ϪⲈ. ϨⲞⲦⲀⲚ ⲈⲢϢⲀⲚⲞⲨⲀ ⲦⲀϨⲘⲈⲔ ⲘⲠⲢⲚⲞϪⲔ ⲚⲦⲠⲈ ⲘⲎⲠⲞⲦⲈ ⲀϤⲦⲀϨⲘⲞⲨⲀ ⲈϤⲦⲀⲒⲎⲨ ⲈⲢⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ⲚϤⲈⲒ ⲚϬⲒ ⲠⲈⲚⲦⲀϤⲦⲀϨⲘⲈⲔ ⲚⲘⲘⲀϤ ⲚϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ ⲚϤϪⲞⲞⲤ ⲚⲀⲔ ϪⲈ ⲔⲀⲠⲘⲀ ⲘⲠⲀⲒ. ⲦⲞⲦⲈ ⲔⲚⲀⲀⲢⲬⲒ ϨⲚ ⲞⲨϢⲒⲠⲈ ⲈϪⲒ ⲘⲠⲘⲀ ⲚϨⲀⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ⲀⲖⲖⲀ ⲈⲨϢⲀⲚⲦⲀϨⲘⲈⲔ ⲂⲰⲔ ⲚⲄⲚⲞϪⲔ ⲘⲠⲘⲀ ⲚϨⲀⲈ. ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀⲚ ⲠⲈⲚⲦⲀϤⲦⲀϨⲘⲈⲔ ⲈⲒ ⲚϤϪⲞⲞⲤ ⲚⲀⲔ ϪⲈ ⲠⲈϢⲂⲎⲢ ⲞⲖⲈⲔ ⲈϨⲢⲀⲒ ⲈⲠϪⲒⲤⲈ. ⲦⲞⲦⲈ ⲞⲨⲚⲞⲨⲈⲞⲞⲨ ⲚⲀϢⲰⲠⲈ ⲚⲀⲔ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲎϪ ⲚⲘⲘⲀⲔ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϪⲒⲤⲈ ⲘⲘⲞϤ ⲤⲈⲚⲀⲐⲂⲂⲒⲞϤ. ⲀⲨⲰ ⲠⲈⲦⲐⲂⲂⲒⲞ ⲘⲘⲞϤ ⲤⲈⲚⲀϪⲀⲤⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ⲠⲈϪⲀϤ ⲞⲚ ⲘⲠⲈⲚⲦⲀϤⲦⲀϨⲘⲈϤ ϪⲈ ⲈⲔϢⲀⲚⲢ ⲞⲨⲀⲢⲒⲤⲦⲞⲚ ⲎⲞⲨⲆⲈⲒⲠⲚⲞⲚ ⲘⲠⲢⲘⲞⲨⲦⲈ ⲈⲚⲈⲔϢⲂⲈⲈⲢ ⲞⲨⲆⲈ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲞⲨⲆⲈ ⲚⲈⲔⲤⲨⲄⲄⲈⲚⲎⲤ ⲞⲨⲆⲈ ⲢⲢⲘⲘⲀⲞ ⲈⲦϨⲒⲦⲞⲨⲰⲔ ⲘⲎⲠⲞⲦⲈ ϨⲰⲞⲨ ⲚⲤⲈⲦⲀϨⲘⲈⲔ ⲚⲦⲈⲞⲨⲦⲞⲨⲒⲞ ϢⲰⲠⲈ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ⲀⲖⲖⲀ ⲈⲔϢⲀⲚⲢ ⲞⲨϢⲞⲠⲤ ⲦⲈϨⲘ ⲚϨⲎⲔⲈ ⲘⲚ ⲚⲈⲦⲘⲞⲔϨ ⲚⲘⲚϬⲀⲖⲈ ⲚⲘⲚⲂⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ⲀⲨⲰ ⲔⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲔⲀⲢⲒⲞⲤ ϪⲈ ⲘⲘⲚⲦⲀⲨ ⲘⲘⲀⲨ ⲈⲦⲰⲰⲂⲈ ⲚⲀⲔ. ⲤⲈⲚⲀⲦⲞⲞⲂⲞⲨ ⲄⲀⲢ ⲚⲀⲔ ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲆⲒⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ⲞⲨⲀ ⲆⲈ ⲈϤⲚⲎϪ ⲚⲘⲘⲀϤ ⲀϤⲤⲰⲦⲘ ⲈⲚⲀⲒ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲚⲀⲒⲀⲦϤ ⲘⲠⲈⲦⲚⲀⲞⲨⲰⲘ ⲚⲞⲨⲞⲒⲔ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲞⲨⲢⲰⲘⲈ ⲠⲈ ⲚⲦⲀϤⲢⲞⲨⲚⲞϬ ⲚⲆⲒⲠⲚⲞⲚ ⲀⲨⲰ ⲀϤⲦⲈϨⲘ ⲞⲨⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ⲀϤϪⲞⲞⲨ ⲆⲈ ⲘⲠⲈϤϨⲘϨⲀⲖ ⲘⲠⲚⲀⲨ ⲘⲠⲆⲈⲒⲠⲚⲞⲚ ⲈϪⲞⲞⲤ ⲚⲚⲈⲦⲦⲀϨⲘ ϪⲈ ⲀⲘϨⲒⲦⲚ ϪⲈ ⲀⲚⲔⲀ ⲚⲒⲘ ⲤⲞⲂⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ⲀⲨⲀⲢⲬⲒ ⲆⲈ ϨⲒⲞⲨⲤⲞⲠ ⲦⲎⲢⲞⲨ ⲈⲠⲀⲢⲀⲒⲦⲒ. ⲠⲈϪⲈⲠϢⲞⲢⲠ ⲚⲀϤ ϪⲈ ⲀⲒϢⲈⲠⲞⲨⲤⲰϢⲈ ϮⲚⲀϪⲠⲒⲂⲰⲔ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲢⲞⲤ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ⲔⲀⲀⲦ ⲚⲦⲞⲞⲦⲔ ϨⲰⲤⲈⲒⲠⲀⲢⲀⲒⲦⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ⲠⲈϪⲈⲠⲔⲈⲨⲀ ⲆⲈ ⲚⲀϤ ϪⲈ ⲀⲒϢⲈⲠϮⲞⲨ ⲚⲤⲞⲒϢ ⲚⲈϨⲈ ϮⲚⲀⲂⲰⲔ ⲦⲀϪⲞⲚⲦⲞⲨ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ⲔⲀⲀⲦ ⲚⲦⲞⲞⲦⲔ ϨⲰⲤⲈⲒⲠⲀⲢⲀⲒⲦⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ⲠⲈϪⲈⲠⲔⲈⲞⲨⲀ ⲆⲈ ϪⲈ. ⲀⲒϨⲘⲞⲞⲤ ⲚⲘⲞⲨⲤϨⲒⲘⲈ ⲈⲦⲂⲈ ϪⲈⲘⲘⲚϢϬⲞⲘ ⲘⲘⲞⲒ ⲈⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ⲀⲠϨⲘϨⲀⲖ ⲆⲈ ⲈⲒ ⲀϤϪⲰ ⲚⲚⲀⲒ ⲈⲠⲈϤϪⲞⲈⲒⲤ ⲦⲞⲦⲈ ⲀⲠϪⲞⲈⲒⲤ ⲚⲞⲨϬⲤ ⲠⲈϪⲀϤ ⲘⲠⲈϤϨⲘϨⲀⲖ ϪⲈ ⲂⲰⲔ ⲈⲂⲞⲖ ϬⲈⲠⲎ ⲈⲚⲈⲠⲖⲀⲦⲒⲀ ⲚⲘⲚϨⲒⲢ ⲚⲘⲘⲠⲞⲖⲒⲤ ⲚⲔⲚⲚϨⲎⲔⲈ ⲈϨⲞⲨⲚ ⲚⲘⲚⲈⲦⲘⲞⲔϨ ⲚⲘⲚⲂⲖⲖⲈ ⲚⲘⲚϬⲀⲖⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ⲠⲈϪⲈⲠϨⲘϨⲀⲖ ⲆⲈ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲀⲠⲈⲚⲦⲀⲔϪⲞⲞϤ ϢⲰⲠⲈ ⲀⲨⲰ ⲞⲚ ⲞⲨⲘⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ⲠⲈϪⲈⲠϪⲞⲈⲒⲤ ⲘⲠϨⲘϨⲀⲖ ϪⲈ ⲂⲰⲔ ⲈⲂⲞⲖ ⲈⲚⲈϨⲒⲞⲞⲨⲈ ⲚⲘⲘⲀ ⲘⲘⲞⲞϢⲈ ⲚⲄⲀⲚⲀⲄⲔⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲈⲈⲒ ⲈϨⲞⲨⲚ ϪⲈ ⲈⲢⲈⲠⲀⲎⲒ ⲘⲞⲨϨ ");
INSERT INTO copshc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲚⲖⲀⲀⲨ ⲚⲚⲈⲦⲦⲀϨⲘ ⲚⲀϪⲒϮⲠⲈ ⲘⲠⲀⲆⲈⲒⲠⲚⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ⲚⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ⲚⲘⲘⲀϤ ⲠⲈ ⲚϬⲒ ϨⲈⲚⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ. ⲀϤⲔⲞⲦϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ϪⲈ ⲠⲈⲦⲚⲎⲞⲨ ϢⲀⲢⲞⲒ ⲈⲚϤⲘⲞⲤⲦⲈ ⲀⲚ ⲘⲠⲈϤⲒⲰⲦ ⲚⲘⲦⲈϤⲘⲀⲀⲨ ⲚⲘⲦⲈϤⲤϨⲒⲘⲈ ⲘⲚ ⲚⲈϤϢⲎⲢⲈ ⲘⲚ ⲚⲈϤⲤⲚⲎⲞⲨ ⲘⲚ ⲚⲈϤⲤⲰⲚⲈ ⲈⲦⲒ ⲆⲈ ⲦⲈϤⲔⲈⲮⲨⲬⲎ ⲘⲘⲚϢϬⲞⲘ ⲈⲦⲢⲈϤⲢⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲚⲀϤⲒ ⲀⲚ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲘⲘⲎⲚⲈ ⲚϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲘⲘⲚϢϬⲞⲘ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲀⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ⲚⲒⲘ ⲄⲀⲢ ⲘⲘⲰⲦⲚ ⲈϤⲞⲨⲈϢⲔⲈⲦ ⲞⲨⲠⲨⲢⲄⲞⲤ ⲘⲎ ⲚϤⲚⲀϨⲘⲞⲞⲤ ⲀⲚ ⲚϢⲞⲢⲠ ⲚϤϤⲒⲠⲰⲠ ⲚⲦⲈϤⲦⲀⲠⲀⲚⲎ ϪⲈ ⲞⲨⲚⲦⲀϤ ⲈϪⲞⲔϤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈϤⲤⲘⲚⲤⲚⲦⲈ ⲚϤⲦⲘϬⲘϬⲞⲘ ⲈϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲨ ⲈⲢⲞϤ ⲤⲰⲂⲈ ⲚⲤⲰϤ ");
INSERT INTO copshc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲠⲈⲒⲢⲰⲘⲈ ⲀⲢⲬⲒ ⲚⲔⲰⲦ ⲘⲠϤⲈϢϬⲘϬⲞⲘ ⲈϪⲞⲔϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ⲎⲚⲒⲘ ⲚⲢⲢⲞ ⲈϤⲚⲀⲂⲰⲔ ⲈⲘⲒϢⲈ ⲚⲘⲔⲈⲢⲢⲞ ⲘⲎ ⲚϤⲚⲀϨⲘⲞⲞⲤ ⲀⲚ ⲚϢⲞⲢⲠ ⲚϤϪⲒϢⲞϪⲚⲈ ϪⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲦⲰⲘⲦ ϨⲚ ⲞⲨⲦⲂⲀ ⲈⲠⲈⲦⲚⲎⲞⲨ ⲈϪⲰϤ ⲚⲘⲦⲂⲀ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ⲈⲦⲒ ⲈϤⲘⲠⲞⲨⲈ ϤⲚⲀϪⲞⲞⲨ ⲚϨⲈⲚϤⲀⲒϢⲒⲚⲈ ⲈϤⲤⲞⲠⲤ ϪⲈ ⲀⲢⲒⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ⲦⲀⲒ ϬⲈ ⲦⲈ ⲐⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈⲚϤⲚⲀⲀⲠⲞⲦⲀⲤⲤⲈ ⲀⲚ ⲚⲚⲈϤϨⲨⲠⲀⲢⲬ ⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ⲘⲘⲚϢϬⲞⲘ ⲘⲘⲞϤ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲀⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ⲚⲀⲚⲞⲨⲠⲈϨⲘⲞⲨ ⲆⲈ ⲈⲢϢⲀⲚⲠⲔⲈϨⲘⲞⲨ ⲆⲈ ⲂⲀⲀⲂⲈ ⲈⲨⲚⲀⲘⲞⲖϨϤ ⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ⲘⲈϤⲢϢⲀⲨ ⲈⲠⲔⲀϨ ⲞⲨⲦⲈ ⲈⲦⲔⲞⲠⲢⲒⲀ ⲈϢⲀⲨⲚⲞϪϤ ⲈⲂⲞⲖ. ⲠⲈⲦⲈⲞⲨⲚ ⲘⲀⲀϪⲈ ⲘⲘⲞϤ ⲈⲤⲰⲦⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ⲚⲈⲢⲈⲚⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲘⲢⲢⲈϤⲢⲚⲞⲂⲈ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲈⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ⲚⲈⲨⲔⲢⲘⲢⲘ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠⲀⲒ ϢⲈⲠⲢⲈϤⲢⲚⲞⲂⲈ ⲈⲢⲞϤ ⲀⲨⲰ ϤⲞⲨⲰⲘ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ⲀϤϪⲰ ⲆⲈ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ϪⲈ. ⲚⲒⲘ ⲢⲢⲰⲘⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ϢⲈ ⲚⲈⲤⲞⲞⲨ ⲀⲨⲰ ⲈϤϢⲀⲚⲤⲈⲢⲘ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲘⲎ ⲚϤⲚⲀⲔⲀ ⲠⲒⲠⲤⲦⲀⲒⲞⲨⲮⲒⲤ ⲀⲚ ϨⲒⲠϪⲀⲒⲈ ⲚϤⲂⲰⲔ ⲚϤϢⲒⲚⲈ ⲚⲤⲀⲠⲒⲞⲨⲀ ϢⲀⲚⲦϤϨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ⲀⲨⲰ ⲈϤϢⲀⲚϨⲈ ⲈⲢⲞϤ ϢⲀϤⲦⲀⲖⲞϤ ⲈϪⲚ ⲚⲈϤⲚⲀϨⲂⲈ ⲈϤⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ⲈϤϢⲀⲚⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲠⲎⲒ ϢⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤϢⲂⲈⲈⲢ ⲘⲚ ⲚⲈⲦϨⲒⲦⲞⲨⲰϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲢⲀϢⲈ ⲚⲘⲘⲀⲒ ϪⲈ ⲀⲒϨⲈ ⲈⲠⲀⲈⲤⲞⲞⲨ ⲈⲚⲦⲀϤⲤⲰⲢⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϢⲀⲢⲈⲞⲨⲢⲀϢⲈ ⲚⲦⲈⲒϨⲈ ϢⲰⲠⲈ ⲈϪⲚ ⲞⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲈϤϢⲀⲚⲘⲈⲦⲀⲚⲞⲒ. ⲈϨⲞⲨⲈ ⲠⲒⲠⲤⲦⲀⲒⲞⲨⲮⲒⲤ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲚⲀⲒ ⲈⲦⲈⲚⲤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ⲎⲚⲒⲘ ⲚⲤϨⲒⲘⲈ ⲈⲨⲚⲦⲤⲘⲎⲦⲈ ⲚⲆⲢⲀⲬⲘⲎ ⲚⲤⲤⲈⲢⲘⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲘⲎ ⲚⲤⲚⲀϪⲈⲢⲈⲠϨⲎⲂⲤ ⲀⲚ ⲚⲤⲤⲈϨⲢⲠⲎⲒ ⲚⲤϢⲒⲚⲈ ϨⲚ ⲞⲨⲰⲢϪ ϢⲀⲚⲦⲤϨⲈ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ⲀⲨⲰ ⲈⲤϢⲀⲚϨⲈ ⲈⲢⲞⲤ ϢⲀⲤⲘⲞⲨⲦⲈ ⲈⲚⲈⲤϢⲂⲈⲈⲢ ⲘⲚ ⲚⲈⲦϨⲒⲦⲞⲨⲰⲤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲢⲀϢⲈ ⲚⲘⲘⲀⲒ ϪⲈ ⲀⲒϨⲈ ⲈⲦⲀⲆⲢⲀⲬⲘⲎ ⲈⲚⲦⲀⲒⲤⲞⲢⲘⲈⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϢⲀⲢⲈⲞⲨⲢⲀϢⲈ ϢⲰⲠⲈ ⲚⲦⲈⲒϨⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈϪⲚ ⲞⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲈϤϢⲀⲚⲘⲈⲦⲀⲚⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ϢⲎⲢⲈ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ⲠⲈϪⲈⲠⲔⲞⲨⲒ ⲚϨⲎⲦⲞⲨ ⲘⲠⲈϤⲒⲰⲦ ϪⲈ ⲠⲀⲒⲰⲦ ⲘⲀ ⲚⲀⲒ ⲘⲠⲀⲘⲈⲢⲞⲤ ⲈⲦⲦⲀϨⲞ ⲘⲘⲞⲒ ϨⲚ ⲦⲞⲨⲤⲒⲀ. ⲀϤⲠⲰϢ ⲆⲈ ⲈϪⲰⲞⲨ ⲚⲚⲈϤⲚⲔⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ⲈⲘⲠⲀⲦⲈϨⲀϨ ⲆⲈ ⲚϨⲞⲞⲨ ⲞⲨⲒⲚⲈ ⲀⲠⲔⲞⲨⲒ ⲚϢⲎⲢⲈ ⲤⲈⲨϨ ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲚⲦⲀϤⲤ ⲀϤⲀⲠⲞⲆⲎⲘⲒ ⲈⲨⲬⲰⲢⲀ ⲈⲤⲞⲨⲎⲞⲨ ⲀϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚⲦⲈϤⲞⲨⲤⲒⲀ ⲈϤⲘⲞⲞϢⲈ ϨⲚ ⲞⲨⲘⲚⲦϢⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ⲚⲦⲈⲢⲈϤϪⲈⲢⲈ ⲚⲔⲀ ⲆⲈ ⲚⲒⲘ ⲈⲂⲞⲖ ⲀⲨⲚⲞϬ ⲚϨⲈⲂⲰⲰⲚ ϢⲰⲠⲈ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲈⲦⲘⲘⲀⲨ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲢⲬⲒ ⲚϢⲰⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ⲀϤⲂⲰⲔ ⲀϤⲦⲞϬϤ ⲈⲨⲀ ⲚⲢⲢⲘⲚϮⲘⲈ ⲚⲦⲈⲬⲰⲢⲀ ⲈⲦⲘⲘⲀⲨ. ⲀϤϪⲞⲞⲨϤ ⲈⲦⲈϤⲤⲰϢⲈ ⲈⲘⲞⲞⲚⲈ ⲚϨⲈⲚⲢⲒⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ⲀⲨⲰ ⲚⲈϤⲈⲠⲒⲐⲨⲘⲒ ⲈⲤⲒ ⲈⲂⲞⲖ ϨⲚ ⲚϬⲀⲢⲀⲦⲈ ⲈⲦⲈ ⲢⲈⲢⲢⲒⲢ ⲞⲨⲰⲘ ⲘⲘⲞⲞⲨ ⲈⲘⲘⲚⲖⲀⲀⲨ ϮⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ⲀϤⲘⲈⲔⲘⲞⲨⲔϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲚⲞⲨⲎⲢ ⲚϪⲀⲒⲂⲈⲔⲈ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲤⲎⲞⲨ ⲘⲠⲞⲒⲔ ⲀⲚⲞⲔ ⲆⲈ ⲈⲒⲚⲀⲘⲞⲨ ⲘⲠⲈⲒⲘⲀ ϨⲀ ⲠⲈϨⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ϮⲚⲀⲦⲰⲞⲨⲚ ⲦⲀⲂⲰⲔ ϢⲀⲠⲀⲒⲰⲦ ⲚⲦⲀϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲀⲒⲢⲚⲞⲂⲈ ⲈⲦⲠⲈ ⲀⲨⲰ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ⲚϮⲘⲠϢⲀ ⲀⲚ ϪⲒⲚⲦⲈⲚⲞⲨ ⲈⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ϪⲈ ⲠⲈⲔϢⲎⲢⲈ ⲀⲀⲦ ⲚⲐⲈ ⲞⲨⲀ ⲚⲚⲈⲒϪⲀⲒ ⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲀϤⲈⲒ ϢⲀ ⲠⲈϤⲒⲰⲦ ⲈⲦⲒ ⲆⲈ ⲈϤⲘⲠⲞⲨⲈ ⲀⲠⲈϤⲒⲰⲦ ⲚⲀⲨ ⲈⲢⲞϤ ⲀϤϢⲚϨⲦⲎϤ ⲈϨⲢⲀⲈⲒ ⲈϪⲰϤ. ⲀϤⲠⲰⲦ ⲀϤⲠⲀϨⲦϤ ⲈϪⲚ ⲠⲈϤⲘⲀⲔϨ ⲀϤϮⲠⲒ ⲈⲢⲰϤ ");
INSERT INTO copshc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ⲠⲈϪⲈⲠⲈϤϢⲎⲢⲈ ⲆⲈ ⲚⲀϤ ϪⲈ. ⲠⲀⲒⲰⲦ ⲀⲒⲢⲚⲞⲂⲈ ⲈⲦⲠⲈ ⲀⲨⲰ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ. ⲚϮⲘⲠϢⲀ ⲀⲚ ϪⲒⲚⲦⲈⲚⲞⲨ ⲈⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ϪⲈ ⲠⲈⲔϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ⲠⲈϪⲈⲠⲒⲰⲦ ⲆⲈ ⲚⲚⲈϤϨⲘϨⲀⲖ ϪⲈ ϬⲈⲠⲎ ⲀⲚⲒⲚⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲤⲦⲞⲖⲎ ⲈⲦⲚⲀⲚⲞⲨⲤ ⲚⲦⲈⲦⲚⲦⲀⲀⲤ ϨⲒⲰⲰϤ. ⲚⲦⲈⲦⲚϮ ⲚⲞⲨⲜⲞⲨⲢ ⲈⲦⲈϤϬⲒϪ ⲀⲨⲰ ⲞⲨⲦⲞⲞⲨⲈ ⲈⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ⲚⲦⲈⲦⲚⲘⲠⲘⲀⲤⲈ ⲈⲦⲤⲀⲚⲀϢⲦ ⲚⲦⲈⲦⲚϢⲀⲀⲦϤ ⲚⲦⲈⲦⲚⲞⲨⲰⲘ ⲚⲦⲈⲦⲚⲈⲨⲪⲢⲀⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ϪⲈ ⲠⲀϢⲎⲢⲈ ⲠⲀⲒ ⲈⲚⲈϤⲘⲞⲞⲨⲦ ⲠⲈ ⲀϤⲰⲚϨ. ⲚⲈϤⲤⲞⲢⲘ ⲠⲈ ⲀⲒϨⲈ ⲈⲢⲞϤ. ⲀⲨⲀⲢⲬⲒ ⲆⲈ ⲚⲈⲨⲪⲢⲀⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ⲚⲈⲢⲈⲠⲈϤⲚⲞϬ ⲆⲈ ⲚϢⲎⲢⲈ ⲠⲈ ϨⲚ ⲦⲤⲰϢⲈ. ⲈϤⲚⲎⲞⲨ ⲆⲈ ⲈϨⲢⲀⲒ ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ. ⲀϤⲤⲰⲦⲘ ⲈⲨⲤⲨⲘⲪⲰⲚⲒⲀ ⲚⲘⲞⲨⲬⲞⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ⲀϤⲘⲞⲨⲦⲈ ⲈⲨⲀ ⲚⲚϨⲘϨⲀⲖ ⲀϤϪⲚⲞⲨϤ ϪⲈ ⲞⲨ ⲚⲈ ⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈⲔⲤⲞⲚ ⲠⲈⲚⲦⲀϤⲈⲒ ⲀⲠⲈⲔⲒⲰⲦ ϢⲰⲰⲦ ⲈⲢⲞϤ ⲘⲠⲘⲀⲤⲈ ⲈⲦⲤⲀⲚⲀϢⲦ ϪⲈ ⲀϤϨⲈ ⲈⲢⲞϤ ⲈϤⲞⲨⲞϪ. ");
INSERT INTO copshc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ⲀϤⲚⲞⲨϬⲤ ⲆⲈ ⲘⲠϤⲞⲨⲰϢ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ. ⲀⲠⲈϤⲒⲰⲦ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ⲀϤⲤⲈⲠⲤⲰⲠϤ. ");
INSERT INTO copshc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲘⲠⲈϤⲒⲰⲦ ϪⲈ ⲒⲤⲞⲨⲘⲎⲎϢⲈ ⲢⲢⲞⲘⲠⲈ ϮⲞ ⲚⲀⲔ ⲚϨⲘϨⲀⲖ ⲘⲠⲒⲔⲰ ⲚⲤⲰⲒ ⲈⲚⲈϨ ⲞⲨⲈⲒ ⲚⲚⲈⲚⲦⲞⲖⲎ ⲚⲦⲞⲞⲦⲔ ⲀⲨⲰ ⲘⲠⲔϮ ⲚⲀⲒ ⲈⲚⲈϨ ⲚⲞⲨⲘⲀⲤ ⲂⲂⲀⲀⲘⲠⲈ ⲈⲦⲢⲀⲈⲨⲪⲢⲀⲚⲈ ⲚⲘⲚⲀϢⲂⲈⲈⲢ. ");
INSERT INTO copshc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ⲚⲦⲈⲢⲈⲠⲈⲔϢⲎⲢⲈ ⲆⲈ ⲈⲒ ⲠⲀⲒ ⲈⲚⲦⲀϤⲞⲨⲰⲘ ⲚⲚⲈⲔⲚⲔⲀ ⲚⲘⲘⲠⲞⲢⲚⲞⲤ ⲀⲔϢⲰⲰⲦ ⲈⲢⲞϤ ⲘⲠⲘⲀⲤⲈ ⲈⲦⲤⲀⲚⲀϢⲦ ");
INSERT INTO copshc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲠⲀϢⲎⲢⲈ ⲚⲦⲞⲔ ⲔϢⲞⲞⲠ ⲚⲘⲘⲀⲒ ⲞⲨⲞⲒϢ ⲚⲒⲘ ⲀⲨⲰ ⲚⲞⲨⲒ ⲦⲎⲢⲞⲨ ⲚⲞⲨⲔ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ϢϢⲈ ⲆⲈ ⲈⲢⲞⲚ ⲈⲦⲢⲈⲚⲢⲀϢⲈ ⲚⲦⲚⲈⲨⲪⲢⲀⲚⲈ ϪⲈ ⲠⲈⲔⲤⲞⲚ ⲠⲀⲒ ⲈⲚⲈϤⲘⲞⲞⲨⲦ ⲠⲈ ⲀϤⲰⲚϨ ⲚⲈϤⲤⲞⲢⲘ ⲠⲈ ⲀⲒϨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲢⲢⲘⲘⲀⲞ ⲈⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲀⲨⲦⲀⲀϤ ⲆⲈ ⲚϢⲦⲞⲨⲎⲦ ϪⲈ ϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲚⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ");
INSERT INTO copshc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲀⲒ ⲈϮⲤⲰⲦⲘ ⲘⲘⲞϤ ⲈⲦⲂⲎⲦⲔ. ⲀⲨⲠⲰⲠ ⲚⲀⲒ ⲚⲦⲈⲔⲞⲒⲔⲞⲚⲞⲘⲒⲀ ⲘⲘⲚϢϬⲞⲘ ⲄⲀⲢ ϪⲒⲚⲦⲈⲚⲞⲨ ⲈⲦⲢⲈⲔⲞⲒⲔⲞⲚⲞⲘⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ⲠⲈϪⲈⲠⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲆⲈ ϨⲘ ⲠⲈϤϨⲎⲦ ϪⲈ ⲈⲒⲚⲀⲢⲞⲨ ϪⲈ ⲠⲀϪⲞⲈⲒⲤ ⲚⲀϤⲒ ⲚⲦⲞⲒⲔⲞⲚⲞⲘⲒⲀ ⲚⲦⲞⲞⲦ ⲘⲘⲚϢϬⲞⲘ ⲘⲘⲞⲒ ⲈϬⲢⲎ ⲀⲨⲰ ϮϢⲒⲠⲈ ⲈⲦⲰⲂⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ⲀⲒⲈⲒⲘⲈ ϪⲈ ⲈⲒⲚⲀⲢⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲨϢⲀⲚϤⲒⲦ ϨⲚ ⲦⲞⲒⲔⲞⲚⲞⲘⲒⲀ. ⲈⲨⲈϪⲒⲦ ⲈϨⲞⲨⲚ ⲈⲚⲈⲨⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲚⲈⲦⲈⲞⲨⲚⲦⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲈⲢⲞⲞⲨ. ⲠⲈϪⲀϤ ⲘⲠϢⲞⲢⲠ ϪⲈ ⲞⲨⲚⲦⲈ ⲠⲀϪⲞⲈⲒⲤ ⲞⲨⲎⲢ ⲈⲢⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϢⲈ ⲂⲂⲀⲦⲞⲤ ⲚⲚⲈϨ. ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϪⲒⲠⲈⲔⲤϨⲀⲒ ⲚⲄϨⲘⲞⲞⲤ ϬⲈⲠⲎ ⲚⲄⲤϨⲀⲒ ⲈⲦⲀⲒⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ⲘⲘⲚⲚⲤⲰⲤ ⲠⲈϪⲀϤ ⲚⲔⲈⲞⲨⲀ ϪⲈ ⲚⲦⲞⲔ ⲞⲨⲚⲞⲨⲎⲢ ⲈⲢⲞⲔ. ⲠⲈϪⲀϤ ϪⲈ ϢⲈ ⲚⲔⲞⲢⲞⲤ ⲚⲤⲞⲨⲞ. ⲠⲈϪⲀϤ ϪⲈ ϪⲒⲠⲈⲔⲤϨⲀⲒ ⲚⲄⲤϨⲀⲒ ⲈϨⲘⲈⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ⲀⲠϪⲞⲈⲒⲤ ⲆⲈ ⲈⲠⲀⲒⲚⲞⲨ ⲘⲠⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲘⲠϪⲒⲚϬⲞⲚⲤ ϪⲈ ⲀϤⲈⲒⲢⲈ ϨⲚ ⲞⲨⲘⲚⲦⲢⲘ ⲚϨⲎⲦ ϪⲈ ϨⲈⲚⲤⲀⲂⲈ ⲚⲈ ⲚϢⲎⲢⲈ ⲘⲠⲈⲒⲀⲒⲰⲚ ⲈϨⲞⲨⲈⲚϢⲎⲢⲈ ⲘⲠⲞⲨⲞⲒⲚ ⲈⲦⲈⲨⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ⲀⲚⲞⲔ ϨⲰ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ. ⲔⲀϨⲈⲚϢⲂⲎⲢ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲘⲘⲰⲚⲀⲤ ⲚⲦⲀⲆⲒⲔⲒⲀ ϪⲈⲔⲀⲀⲤ ⲈϤϢⲀⲚⲰϪⲚ. ⲈⲨⲈϪⲒⲦⲎⲨⲦⲚ ⲈϨⲞⲨⲚ ⲈⲚⲈⲤⲔⲎⲚⲎ ⲚϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ⲠⲠⲒⲤⲦⲞⲤ ϨⲚ ⲞⲨⲔⲞⲨⲒ ⲞⲨⲠⲒⲤⲦⲞⲤ ⲞⲚ ⲠⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲀⲨⲰ ⲠⲀⲆⲒⲔⲞⲤ ϨⲚ ⲞⲨⲔⲞⲨⲒ ⲞⲨⲀⲆⲒⲔⲞⲤ ⲞⲚ ⲠⲈ ϨⲚ ⲞⲨⲚⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ⲈϢϪⲈ ⲘⲠⲈⲦⲚϢⲰⲠⲈ ϬⲈ ⲘⲠⲒⲤⲦⲞⲤ ϨⲘ ⲠⲀⲘⲘⲰⲚⲀⲤ ⲚⲀⲆⲒⲔⲞⲤ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲦⲀⲚϨⲈⲦ ⲦⲎⲞⲨⲦⲚ ⲈⲠⲈⲦⲈϨⲰⲰϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ⲀⲨⲰ ⲈϢϪⲈ ⲘⲠⲈⲦⲚⲢⲠⲒⲤⲦⲞⲤ ϨⲘ ⲠⲈⲦⲈⲘⲠⲰⲦⲚ ⲀⲚ ⲠⲈ. ⲚⲒⲘ ⲠⲈⲦⲚⲀϮ ⲚⲎⲦⲚ ⲘⲠⲈⲦⲈⲠⲰⲦⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ⲘⲘⲚϢϬⲞⲘ ⲖⲖⲀⲀⲨ ⲈⲢϨⲘϨⲀⲖ ⲚϪⲞⲈⲒⲤ ⲤⲚⲀⲨ ⲎⲄⲀⲢ ϤⲚⲀⲘⲈⲤⲦⲈⲞⲨⲀ ⲚϤⲘⲈⲢⲈⲞⲨⲀ ⲎⲚϤⲀⲚⲈⲬⲈⲞⲨⲀ ⲚϤⲔⲀⲦⲀⲪⲢⲞⲚⲒⲞⲨⲀ ⲘⲘⲚϢϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲦⲢⲈⲦⲚⲢ ϨⲘϨⲀⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲘⲠⲀⲘⲘⲰⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ⲀⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲤⲰⲦⲘ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈϨⲈⲚⲘⲀⲒϨⲞⲘⲚⲦ ⲚⲈ. ⲀⲨⲔⲰⲘϢ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲈⲦⲦⲘⲀⲒⲞ ⲘⲘⲰⲦⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲢⲢⲰⲘⲈ. ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲤⲞⲞⲨⲚ ⲚⲚⲈⲦⲚϨⲎⲦ ϪⲈ ⲦⲘⲚⲦϪⲀⲤⲒϨⲎⲦ ⲈⲦϨⲚⲢⲢⲰⲘⲈ. ⲞⲨⲂⲞⲦⲈ ⲦⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲦⲀⲨⲠⲰϨ ϢⲀⲒⲰϨⲀⲚⲚⲎⲤ. ϪⲒⲚⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲤⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ϪⲒ ⲘⲘⲞϤ ⲚϬⲞⲚⲤ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ⲤⲘⲞⲦⲚ ⲆⲈ ⲈⲦⲢⲈⲦⲠⲈ ⲚⲘⲠⲔⲀϨ ⲠⲀⲢⲀⲄⲈ ⲎⲈⲦⲢⲈⲞⲨϢⲰⲖϨ ⲚⲞⲨⲰⲦ ϨⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲚⲈϪ ⲦⲈϤⲤϨⲒⲘⲈ ⲈⲂⲞⲖ ⲚϤϨⲘⲞⲞⲤ ⲚⲘⲔⲈⲨⲈⲒ ϤⲞ ⲚⲚⲞⲈⲒⲔ. ⲀⲨⲰ ⲠⲈⲦⲚⲀϨⲘⲞⲞⲤ ⲚⲘⲔⲈⲨⲈⲒ ⲈⲀⲠⲈⲤϨⲀⲒ ⲚⲞϪⲤ ⲈⲂⲞⲖ. ϤⲞ ⲚⲚⲞⲈⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ⲚⲈⲨⲚⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲢⲢⲘⲘⲀⲞ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲚⲒⲚⲈⲨⲎ ⲈϢⲀϤϮ ϨⲒⲰⲰϤ ⲚⲞⲨϪⲎϬⲈ ⲚⲘⲞⲨϢⲚⲤ ⲈϤⲈⲨⲪⲢⲀⲚⲈ ⲘⲘⲎⲚⲈ ⲔⲀⲖⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ⲚⲈⲨⲚⲞⲨϨⲎⲔⲈ ⲆⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲈϤⲚⲎϪ ϨⲚ ⲦⲈϤϨⲀⲒⲦ ⲈϤⲞ ⲚⲤⲀϢ ");
INSERT INTO copshc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ⲈϤⲈⲠⲒⲐⲨⲘⲒ ⲈⲤⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϢⲀⲨϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲘⲠⲢⲘⲘⲀⲞ. ⲀⲖⲖⲀ ⲚⲔⲈⲞⲨϨⲞⲞⲢ ϢⲀⲨⲈⲒ ⲚⲤⲈⲖⲰϪϨ ⲚⲚⲈϤⲤⲀϢ. ");
INSERT INTO copshc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲠϨⲎⲔⲈ ⲘⲞⲨ ⲚⲤⲈϪⲒⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲔⲞⲨⲚϤ ⲚⲀⲂⲢⲀϨⲀⲘ ⲀⲠⲔⲈⲢⲘⲘⲀⲞ ⲆⲈ ⲘⲞⲨ ⲀⲨⲦⲞⲘⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ⲀϤϤⲒⲀⲦϤ ⲆⲈ ⲈϨⲢⲀⲒ ϨⲚ ⲀⲘⲚⲦⲈ ⲈϤϢⲞⲞⲠ ϨⲚ ϨⲈⲚⲂⲀⲤⲀⲚⲞⲤ ⲀϤⲚⲀⲨ ⲈⲀⲂⲢⲀϨⲀⲘ ⲘⲠⲞⲨⲈ. ⲀⲨⲰ ⲖⲀⲌⲀⲢⲞⲤ ϨⲚ ⲔⲞⲨⲚϤ ");
INSERT INTO copshc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ ⲚⲀ ⲚⲀⲒ. ⲘⲀⲦⲚⲚⲈⲨ ⲖⲀⲌⲀⲢⲞⲤ ⲚϤⲤⲈⲠϨⲦⲎϤ ⲘⲠⲈϤⲦⲎⲎⲂⲈ ⲘⲘⲞⲞⲨ ⲚϤⲔⲂⲈⲠⲀⲖⲀⲤ ϪⲈ ϮⲘⲞⲔϨ ⲀⲚⲞⲔ ϨⲘ ⲠⲈⲒⲔⲰϨⲦ. ");
INSERT INTO copshc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ⲠⲈϪⲈⲀⲂⲢⲀϨⲀⲘ ⲆⲈ ϪⲈ ⲠⲀϢⲎⲢⲈ ⲀⲢⲒⲠⲘⲈⲈⲨⲈ ϪⲈ ⲀⲔϪⲒ ⲚⲚⲈⲔⲀⲄⲀⲐⲞⲚ ϨⲘ ⲠⲈⲔⲰⲚⲀϨ ⲀⲨⲰ ⲖⲀⲌⲀⲢⲞⲤ ϨⲰⲰϤ ϨⲚ ϨⲈⲚⲠⲈⲐⲞⲞⲨ ⲦⲈⲚⲞⲨ ⲆⲈ ⲤⲈⲤⲞⲖⲤⲖ ⲘⲘⲞϤ ⲘⲠⲈⲒⲘⲀ ⲚⲦⲞⲔ ⲆⲈ ⲤⲈⲘⲞⲨⲔϨ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ⲘⲚⲚⲤⲀⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲞⲨⲚⲞⲨⲚⲞϬ ⲚⲬⲀⲤⲘⲀ ⲦⲀϪⲢⲎⲞⲨ ϨⲚ ⲦⲈⲚⲘⲎⲦⲈ ϨⲒⲞⲨⲤⲞⲠ ϪⲈⲔⲀⲀⲤ ⲚⲈⲦⲞⲨⲰϢ ⲈϪⲒⲞⲞⲢ ⲘⲠⲈⲒⲘⲀ ϢⲀⲢⲰⲦⲚ ⲚⲚⲈⲨⲈϢϬⲘϬⲞⲘ. ⲞⲨⲆⲈ ⲚⲚⲈⲨⲈϢϪⲒⲞⲞⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈ ⲦⲎⲞⲨⲦⲚ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ϮⲤⲞⲠⲤ ⲚⲦⲞⲞⲨⲚ ⲘⲘⲞⲔ ⲠⲀⲒⲰⲦ ϪⲈ ⲈⲔⲈϪⲞⲞⲨϤ ⲈⲠⲎⲒ ⲘⲠⲀⲒⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ⲞⲨⲚϮϮⲞⲨ ⲄⲀⲢ ⲚⲤⲞⲚ ϪⲈ ⲈϤⲈⲢⲘⲚⲦⲢⲈ ⲚⲀⲨ ϪⲈ ⲚⲚⲈⲨⲈⲒ ϨⲰⲞⲨ ⲈⲠⲈⲒⲘⲀ ⲂⲂⲀⲤⲀⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ⲠⲈϪⲈⲀⲂⲢⲀϨⲀⲘ ⲆⲈ ⲚⲀϤ ϪⲈ ⲞⲨⲚⲦⲞⲨⲘⲰⲨⲤⲎⲤ ⲘⲘⲀⲨ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲀⲢⲞⲨⲤⲰⲦⲘ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ ⲠⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ. ⲀⲖⲖⲀ ⲈⲢϢⲀⲚⲞⲨⲀ ⲂⲰⲔ ϢⲀⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲤⲈⲚⲀⲘⲈⲦⲀⲚⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲈϢϪⲈ ⲚⲤⲈⲚⲀⲤⲰⲦⲘ ⲀⲚ ⲚⲤⲀ ⲘⲰⲨⲤⲎⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲒⲈ ⲈⲢϢⲀⲚⲞⲨⲀ ⲞⲚ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲤⲈⲚⲀⲤⲰⲦⲘ ⲚⲤⲰϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ. ⲤⲘⲞⲔϨ ⲈⲦⲢⲈ ⲚⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲦⲘⲈⲒ. ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲠⲈⲦϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ⲚⲀⲚⲞⲨⲤ ⲚⲀϤ ⲈⲚⲈⲞⲨⲚⲞⲨⲰⲚⲈ ⲚⲤⲒⲔⲈ ⲘⲎⲢ ⲈⲠⲈϤⲘⲀⲔϨ ⲚⲤⲈⲚⲞϪϤ ⲈⲐⲀⲖⲀⲤⲤⲀ. ⲈϨⲞⲨⲈ ⲦⲢⲈϤⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲞⲨⲀ ⲚⲚⲈⲒⲔⲞⲨⲒ ");
INSERT INTO copshc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ. ⲈⲢϢⲀⲚⲠⲈⲔⲤⲞⲚ ⲢⲚⲞⲂⲈ ⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ. ⲀⲨⲰ ⲈϤϢⲀⲚⲘⲈⲦⲀⲚⲞⲒ ⲔⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ⲔⲀⲚ ⲈϤϢⲀⲚⲢⲚⲞⲂⲈ ⲈⲢⲞⲔ ⲚⲤⲀϢϤ ⲚⲤⲞⲠ ⲘⲠⲈϨⲞⲞⲨ ⲚϤⲔⲞⲦϤ ⲈⲢⲞⲔ ⲚⲤⲀϢϤ ⲚⲤⲞⲠ ⲘⲠⲈϨⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲘⲈⲦⲀⲚⲞⲒ. ⲈⲔⲈⲔⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ⲠⲈϪⲈⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ϪⲈ ⲞⲨⲈϨⲠⲒⲤⲦⲒⲤ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ⲠⲈϪⲈⲠϪⲞⲈⲒⲤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲈⲚⲈⲞⲨⲚⲦⲎ ⲦⲚⲠⲒⲤⲦⲒⲤ ⲘⲘⲀⲨ ⲚⲀⲠϢⲀⲨ ⲚⲞⲨⲂⲖⲂⲒⲖⲈ ⲚϢⲖⲦⲘ ⲚⲈⲦⲈⲦⲚⲀϪⲞⲞⲤ ⲚⲦⲈⲒⲚⲞⲨϨⲈ ϪⲈ ⲠⲰⲢϪ ⲚⲦⲈⲦⲰϬⲈ ϨⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲚⲤⲤⲰⲦⲘ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ⲚⲒⲘ ⲆⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨϨⲘϨⲀⲖ ⲈϤⲤⲔⲀⲒ ⲎⲈϤⲘⲞⲞⲚⲈ ⲈϤⲚⲎⲞⲨ ⲈϨⲢⲀⲒ ϨⲚ ⲦⲤⲰϢⲈ ⲚϤϪⲞⲞⲤ ⲚⲀϤ ⲚⲦⲈⲨⲚⲞⲨ ϪⲈ ⲘⲞⲞϢⲈ ⲚⲄⲚⲞϪⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ⲘⲎ ⲈϢⲀϤϪⲞⲞⲤ ⲀⲚ ⲚⲀϤ ϪⲈ ⲤⲞⲂⲦⲈ ⲘⲠⲈϮⲚⲀⲞⲨⲞⲘϤ. ⲚⲄⲘⲞⲢⲔ ⲚⲄⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲈⲒ ϢⲀⲚϮⲞⲨⲰⲘ ⲚⲦⲀⲤⲰ. ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲚⲄⲞⲨⲰⲘ ⲚⲄⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ⲘⲎ ⲞⲨⲚⲦⲈⲠϨⲘϨⲀⲖ ϨⲘⲞⲦ ϪⲈ ⲀϤⲢⲚⲈⲚⲦⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲞⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ⲦⲀⲒ ⲦⲈ ⲦⲈⲦⲚϨⲈ ϨⲰⲦⲦⲎⲞⲨⲦⲚ. ⲈⲦⲈⲦⲚϢⲀⲚⲢϨⲰⲂ ⲚⲒⲘ ⲈⲚⲦⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲞⲨ ⲚⲎⲦⲚ ⲀϪⲒⲤ ϪⲈ ⲀⲚⲚϨⲈⲚϨⲘϨⲀⲖ ⲚⲀⲦϢⲀⲨ ⲠⲈⲦⲈⲢⲞⲚ ⲈⲀⲀϤ ⲠⲈⲚⲦⲀⲚⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤⲘⲞⲞϢⲈ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲚⲈϤⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲠⲈ ϨⲒⲦⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲚⲘⲦⲄⲀⲖⲒⲖⲀⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ⲈϤⲂⲎⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲨϮⲘⲈ ⲀⲘⲎⲦ ⲢⲢⲰⲘⲈ ⲈⲨⲤⲞⲂⲀϨ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲚⲀⲒ ⲆⲈ ⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲞⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ⲈⲨϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲤⲀϨ ⲚⲀ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲂⲰⲔ ⲘⲀⲦⲞⲨⲰⲦⲚ ⲈⲚⲞⲨⲎⲎⲂ. ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈⲨⲂⲎⲔ ⲀⲨⲦⲂⲂⲞ ");
INSERT INTO copshc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ⲚⲦⲈⲢⲈⲞⲨⲀ ⲆⲈ ⲚϨⲎⲦⲞⲨ ⲚⲀⲨ ϪⲈ ⲀϤⲦⲂⲂⲞ ⲀϤⲔⲞⲦϤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲈϤϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ⲀϤⲠⲀϨⲦϤ ϨⲀ ⲢⲀⲦϤ ⲈϪⲚ ⲠⲈϤϨⲞ ⲈϤϢⲠ ϨⲘⲞⲦ ⲚⲦⲞⲞⲦϤ ⲚⲦⲞϤ ⲆⲈ ⲚⲈ ⲞⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ⲀⲒⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ. ⲘⲎ ⲘⲠⲈⲠⲒⲘⲎⲦ ⲦⲂⲂⲞ. ⲈϤⲦⲰⲚ ⲠⲔⲈⲮⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ⲘⲠⲞⲨϨⲈ ⲈⲢⲞⲞⲨ ⲈⲦⲢⲈⲨⲔⲞⲦⲞⲨ ⲈϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲒⲘⲎⲦⲒ ⲠⲒϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ⲚⲦⲈⲢⲞⲨϪⲚⲞⲨϤ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲈⲢⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲎⲨ ⲦⲚⲀⲨ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲈⲢⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲎⲞⲨ ⲀⲚ ϨⲚ ⲞⲨϮϨⲦⲎϤ. ");
INSERT INTO copshc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ⲞⲨⲦⲈ ⲚⲚⲈⲨⲚⲀϪⲞⲞⲤ ⲀⲚ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲘⲠⲈⲒⲘⲀ. ⲎⲠⲎ. ⲈⲒⲤ ⲦⲘⲚⲦⲢⲢⲞ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲦⲚⲤⲀ ⲚϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲞⲨⲚϨⲈⲚϨⲞⲞⲨ ⲚⲎⲞⲨ ⲈⲦⲈⲦⲚⲀⲈⲠⲒⲐⲨⲘⲒ ⲈⲚⲀⲨ ⲈⲨϨⲞⲞⲨ ϨⲚ ⲚⲀⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲦⲈⲦⲚⲦⲘⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ⲚⲤⲈϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲒⲤϨⲎⲎⲦⲈ ϤⲘⲠⲈⲒⲘⲀ ⲎϨⲘ ⲠⲀⲒ ⲘⲠⲢⲠⲰⲦ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ⲚⲐⲈ ⲄⲀⲢ ⲚⲦⲈⲂⲢⲎϬⲈ ⲈϢⲀⲤⲢⲞⲨⲞⲒⲚ ϨⲀⲦⲠⲈ ⲚⲤⲢⲞⲨⲞⲒⲚ ⲈϪⲘⲠⲔⲀϨ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ϨⲀⲠⲤ ⲆⲈ ⲚϢⲞⲢⲠ ⲈⲦⲢⲈϤϢⲈⲠϨⲀϨ ⲚϨⲒⲤⲈ ⲚⲤⲈⲦⲤⲦⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲤϢⲰⲠⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚⲚⲰϨⲈ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ⲚⲐⲈ ⲄⲀⲢ ⲈⲚⲦⲀⲤϢⲰⲠⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚⲚⲰϨⲈ ⲈⲐⲀⲎ ⲘⲠⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲈⲨⲞⲨⲰⲘ ⲈⲨⲤⲰ ⲈⲨϪⲒϨⲒⲘⲈ ⲈⲨϨⲘⲞⲞⲤ ⲚⲘϨⲀⲒ ϢⲀⲠⲈϨⲞⲞⲨ ⲈⲚⲦⲀⲚⲰϨⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦϬⲒⲂⲰⲦⲞⲤ ⲀⲠⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲈⲒ ⲀϤⲦⲀⲔⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ⲀⲨⲰ ⲞⲚ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲤϢⲰⲠⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲖⲖⲰⲦ ⲈⲨⲞⲨⲰⲘ ⲈⲨⲤⲰ ⲈⲨϢⲰⲠ ⲈⲨϮ ⲈⲂⲞⲖ ⲈⲨⲦⲰϬⲈ ⲈⲨⲔⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ⲘⲠⲈϨⲞⲞⲨ ⲆⲈ ⲈⲚⲦⲀⲖⲰⲦ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲤⲞⲆⲞⲘⲀ ⲀⲨⲔⲰϨⲦ ϨⲰⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲘⲞⲨⲐⲎⲚ ⲀϤⲦⲀⲔⲈⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲀϢⲰⲠⲈ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲨⲰⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲠⲈⲦϨⲒϪⲈⲚⲈⲠⲰⲢ ⲈⲢⲈⲚⲈϤϨⲚⲀⲀⲨ ϨⲘ ⲠⲈϤⲎⲒ. ⲘⲠⲢⲦⲢⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈϤⲒⲦⲞⲨ. ⲀⲨⲰ ⲠⲈⲦϨⲚ ⲦⲤⲰϢⲈ ⲘⲠⲢⲦⲢⲈϤⲔⲞⲦϤ ⲈⲠⲀϨⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ⲀⲢⲒⲠⲘⲈⲈⲨⲈ ⲚⲐⲒⲘⲈ ⲖⲖⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ⲠⲈⲦⲚⲀϢⲒⲚⲈ ⲚⲤⲀⲦⲀⲚϨⲈ ⲦⲈϤⲮⲨⲬⲎ. ϤⲚⲀⲤⲞⲢⲘⲈⲤ. ⲠⲈⲦⲚⲀⲤⲞⲢⲘⲈⲤ ϤⲚⲀⲦⲀⲚϨⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϨⲚ ⲦⲈⲒⲞⲨϢⲎ ⲞⲨⲚⲤⲚⲀⲨ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲞⲨϬⲖⲞϬ ⲚⲞⲨⲰⲦ ⲤⲈⲚⲀϪⲒⲞⲨⲀ ⲚⲤⲈⲔⲀⲞⲨⲀ ");
INSERT INTO copshc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ⲞⲨⲚⲤⲚⲦⲈ ⲚⲀϢⲰⲠⲈ ⲈⲨⲚⲞⲨⲦ ϨⲒⲞⲨⲤⲞⲠ ⲤⲈⲚⲀϪⲒⲞⲨⲈⲒ ⲚⲤⲈⲔⲀⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","— ");
INSERT INTO copshc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲚⲀϤ ϪⲈ ⲈⲦⲰⲚ ⲠϪⲞⲈⲒⲤ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲠⲘⲀ ⲈⲦⲈⲢⲈ ⲠⲤⲰⲘⲀ ⲚⲀϢⲰⲠⲈ ⲘⲘⲞϤ ⲈⲢⲈⲚⲀⲈⲦⲞⲤ ⲚⲀⲤⲰⲞⲨϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ⲀϤϪⲰ ⲆⲈ ⲚⲀⲨ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲦⲂⲈ ϪⲈ ϢϢⲈ ⲈϢⲖⲎⲖ ⲞⲨⲞⲒϢ ⲚⲒⲘ ⲈⲦⲘⲈⲄⲔⲀ ϬⲒ ");
INSERT INTO copshc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲚⲈⲨⲚ ⲞⲨⲔⲢⲒⲦⲎⲤ ϨⲚ ⲞⲨⲠⲞⲖⲒⲤ ⲈⲚϤⲢϨⲞⲦⲈ ⲀⲚ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲈⲚϤϢⲒⲠⲈ ⲀⲚ ϨⲎⲦϤ ⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ⲚⲈⲨⲚ ⲞⲨⲬⲎⲢⲀ ⲆⲈ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ ⲈⲤⲚⲎⲞⲨ ϢⲀⲢⲞϤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲀⲢⲒ ⲠⲀϨⲀⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦϪⲒ ϨⲀⲠ ⲞⲨⲂⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ⲀⲨⲰ ⲘⲠϤⲞⲨⲰϢ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲒϢ. ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲠⲈϪⲀϤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ϪⲈ. ⲈϢϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚϮⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲀⲚ ⲀⲨⲰ ⲚϮϢⲒⲠⲈ ⲀⲚ ϨⲎⲦϤ ⲢⲢⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲦⲈⲒⲬⲎⲢⲀ ⲞⲨⲈϨ ϨⲒⲤⲈ ⲈⲢⲞⲒ ϮⲚⲀⲢ ⲠⲈⲤϨⲀⲠ ϪⲈ ⲚⲚⲈⲤϢⲰⲠⲈ ⲈⲤⲚⲎⲞⲨ ϢⲀⲂⲞⲖ ⲚⲤϮ ϨⲒⲤⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ϪⲈ. ⲤⲰⲦⲘ ϪⲈ ⲚⲦⲀⲠⲈⲔⲢⲒⲦⲎⲤ ⲚⲦⲀⲆⲒⲔⲒⲀ ϪⲈ ⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ⲈⲒⲈ ⲠⲚⲞⲨⲦⲈ ϬⲈ ⲚⲀⲢ ⲠϨⲀⲠ ⲀⲚ ⲚⲚⲈϤⲤⲰⲦⲠ ⲈⲦⲰϢ ⲈϨⲢⲀⲒ ⲈⲢⲞϤ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲚⲘ ⲦⲈⲨϢⲎ ⲀⲨⲰ ⲚϤϨⲢⲞϢ ⲚϨⲎⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϤⲚⲀⲢ ⲠⲈⲨϨⲀⲠ ϨⲚ ⲞⲨϬⲈⲠⲎ. ⲠⲖⲎⲚ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲎⲨ ⲚϤϨⲈ ⲈⲦⲠⲒⲤⲦⲒⲤ ϨⲒϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ⲀϤϪⲰ ⲆⲈ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϨⲞⲒⲚⲈ ⲈⲨⲔⲰ ⲚϨⲦⲎⲨ ⲈⲢⲞⲞⲨ ⲞⲨⲀⲀⲦⲞⲨ ϪⲈ ϨⲈⲚⲆⲒⲔⲀⲒⲞⲤ ⲚⲈ ⲀⲨⲰ ⲈⲨⲤⲰϢϤ ⲘⲠⲔⲈⲤⲈⲈⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ϪⲈ ⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲚⲈⲚⲦⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲢⲠⲈ ⲈϢⲖⲎⲖ. ⲞⲨⲀ ⲆⲈ ⲈⲨⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲠⲈ ⲠⲔⲈⲞⲨⲀ ⲆⲈ ⲞⲨⲦⲈⲖⲰⲚⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ⲀⲠⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲀϨⲈⲢⲀⲦϤ ⲀϤϪⲈ ⲚⲀⲒ ⲈϤϢⲖⲎⲖ ϪⲈ ⲠⲚⲞⲨⲦⲈ ϮϢⲠϨⲘⲞⲦ ⲚⲦⲞⲞⲦⲔ ϪⲈ ⲚϮⲞ ⲀⲚ ⲚⲐⲈ ⲘⲠⲔⲈⲤⲈⲈⲠⲈ ⲚⲢⲢⲰⲘⲈ ⲢⲢⲈϤⲦⲰⲢⲠ ⲢⲢⲈϤϪⲒ ⲚϬⲞⲚⲤ ⲚⲚⲞⲒⲔ ⲎⲚⲐⲈ ⲘⲠⲒⲔⲈⲦⲈⲖⲰⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ϮⲚⲎⲤⲦⲈⲨⲈ ⲚⲤⲞⲠ ⲤⲚⲀⲨ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ. ϮϮ ⲘⲠⲢⲈⲘⲎⲦ ⲚⲚⲈϮϪⲠⲞ ⲘⲘⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ⲀⲠⲔⲈⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲀϤⲀϨⲈⲢⲀⲦϤ ⲘⲠⲞⲨⲈ ⲞⲨⲦⲈ ⲘⲠϤⲞⲨⲈϢ ϤⲒⲚⲈϤⲂⲀⲖ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀⲖⲖⲀ ⲀϤϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈϨⲚ ⲦⲈϤⲘⲈⲤⲐⲎⲦ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲔⲰ ⲈⲂⲞⲖ ⲚⲀⲒ ⲀⲚⲞⲔ ⲠⲒⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲠⲀⲒ ⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲠⲈϤⲎⲒ ⲈϤⲦⲘⲀⲒⲎⲞⲨ ⲈϨⲞⲨⲈ ⲠⲎ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϪⲒⲤⲈ ⲘⲘⲞϤ ⲤⲈⲚⲀⲐⲂⲂⲒⲞϤ ⲠⲈⲦⲚⲀⲐⲂⲂⲈⲒⲞ ⲆⲈ ⲘⲘⲞϤ. ⲤⲈⲚⲀϪⲀⲤⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ⲀⲨⲈⲒⲚⲈ ⲆⲈ ⲚⲀϤ ⲚϨⲈⲚϢⲎⲢⲈ ϢⲎⲘ ϪⲈ ⲈϤⲈϪⲰϨ ⲈⲢⲞⲞⲨ. ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲈⲠⲒⲦⲒⲘⲀ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀ ⲚϢⲎⲢⲈ ϢⲎⲘ ⲚⲤⲈⲈⲒ ⲈⲢⲀⲦ ⲀⲨⲰ ⲘⲠⲢⲔⲰⲖⲨ ⲘⲘⲞⲞⲨ. ⲦⲀ ⲚⲀⲒ ⲄⲀⲢ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲈ ⲚϤⲚⲀϢⲈⲠ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲢⲞϤ ⲀⲚ ϨⲰⲤ ϢⲎⲢⲈ ϢⲎⲘ. ⲚⲚⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ⲀⲨⲀⲢⲬⲰⲚ ⲆⲈ ϪⲚⲞⲨϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠⲤⲀϨ ⲚⲀⲄⲀⲐⲞⲤ ⲈⲒⲚⲀⲢ ⲞⲨ ⲦⲀⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ");
INSERT INTO copshc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ. ⲀϨⲢⲞⲔ ⲔⲘⲞⲨⲦⲈ ⲞⲨⲂⲎⲒ ϪⲈ ⲠⲀⲄⲀⲐⲞⲤ ⲘⲘⲚ ⲀⲄⲀⲐⲞⲤ ⲚⲤⲀ ⲞⲨⲀ ⲈⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ⲔⲤⲞⲞⲨⲚ ⲚⲚⲈⲚⲦⲞⲖⲎ ⲘⲠⲢⲢⲚⲞⲒⲔ ⲘⲠⲢϨⲰⲦⲂ ⲘⲠⲢϨⲰϤⲦ ⲘⲠⲢⲢⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲘⲀⲦⲀⲒⲈ ⲠⲈⲔⲒⲰⲦ ⲚⲘ ⲦⲈⲔⲘⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ϪⲒⲚ ⲦⲀⲘⲚⲦⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲈⲨⲀ ⲠⲈⲦⲔϢⲀⲀⲦ ⲘⲘⲞϤ. ϮⲚⲄⲔⲀ ⲚⲒⲘ ⲈⲂⲞⲖ ⲈⲦⲚⲦⲀⲔ ⲚⲄⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ ⲚⲄⲔⲰ ⲚⲀⲔ ⲚⲞⲨⲀϨⲞ ϨⲚ ⲘⲠⲎⲨⲈ ⲚⲄⲈⲒ ⲚⲄⲞⲨⲀϨⲔ ⲚⲤⲰⲒ ");
INSERT INTO copshc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲤⲈⲦⲘ ⲚⲀⲒ ⲀϤⲖⲨⲠⲒ ⲚⲈⲨⲢⲘⲘⲀⲞ ⲄⲀⲢ ⲈⲘⲀⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ϪⲈ. ⲀⲚⲀⲨ ⲈⲐⲈ ⲈⲦⲤⲘⲞⲔϨ ⲈⲦⲢⲈ ⲚⲈⲦⲈⲨⲚⲦⲞⲨⲬⲢⲎⲘⲀ ⲘⲘⲀⲨ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ⲤⲘⲞⲦⲚ ⲄⲀⲢ ⲈⲦⲢⲈ ⲞⲨϬⲀⲘⲞⲨⲖ ⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲞⲨⲀⲦϤⲈ ⲚⲞⲨϨⲀⲘ ⲚⲦⲰⲠ ⲈϨⲞⲨⲈ ⲞⲨⲢⲘⲘⲀⲞ ⲚϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ⲠⲈϪⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈⲦⲤⲰⲦⲘ ϪⲈ ⲚⲒⲘ ⲚⲦⲞⲞⲨⲚ ⲚⲈⲦⲚⲀϢⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲚⲀⲦϬⲞⲘ ⲚⲚⲀϨⲢⲚ ⲢⲢⲰⲘⲈ ⲞⲨⲚ ϬⲞⲘ ⲈⲢⲞⲞⲨ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲚ ⲀⲚⲔⲰ ⲚⲤⲰⲚ ⲚⲚⲈⲦⲈⲚⲞⲨⲚ ⲚⲈ ⲀⲚⲞⲨⲀϨⲚ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲚ ⲖⲀⲀⲨ ⲈⲀϤⲔⲀ ⲎⲒ ⲚⲤⲰϤ ⲎⲤϨⲒⲘⲈ ⲎⲤⲞⲚ ⲎⲚⲈϤⲒⲞⲦⲈ ⲎⲚⲈϤϢⲎⲢⲈ ⲈⲦⲂⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ⲈⲚϤⲚⲀϪⲒⲦⲞⲨ ⲀⲚ ⲚⲤⲀϢϤ ⲚⲔⲰⲂ ϨⲘ ⲠⲈⲒⲞⲨⲞⲒϢ ⲀⲨⲰ ⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϨⲘ ⲠⲀⲒⲰⲚ ⲈⲦⲚⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ⲀϤϪⲒ ⲆⲈ ⲘⲠⲘⲦⲤⲚⲞⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲦⲈ ⲚⲈⲦⲤⲎϨ ⲦⲎⲢⲞⲨ ϨⲒⲦⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ⲤⲈⲚⲀⲦⲀⲀϤ ⲄⲀⲢ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲤⲰⲂⲈ ⲘⲘⲞϤ. ⲚⲤⲈⲤⲞϢϤ. ⲚⲤⲈⲚⲈϪ ⲠⲀϬⲤⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ⲚⲤⲈⲘⲀⲤⲦⲒⲄⲞⲨ ⲘⲘⲞϤ ⲚⲤⲈⲘⲞⲞⲨⲦϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ⲚⲦⲞⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲒⲘⲈ ⲈⲖⲀⲀⲨ ⲚⲚⲀⲒ ⲀⲨⲰ ⲚⲈⲢⲈ ⲠⲈⲒϢⲀϪⲈ ϨⲎⲠ ⲈⲢⲞⲞⲨ ⲠⲈ ⲈⲘⲠⲞⲨⲤⲞⲨⲚ ⲚⲈⲦϤϪⲰ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈϨⲒⲈⲢⲒⲬⲰ ⲚⲈⲨⲚ ⲞⲨⲂⲖⲖⲈ ⲠⲈ ϨⲘ ⲞⲞⲤ ϨⲀⲦⲚ ⲦⲈϨⲒⲎ ⲈϤⲦⲰⲂⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲈⲠⲘⲎⲎϢⲈ ⲀϤϢⲒⲚⲈ ϪⲈ ⲞⲨ ⲠⲈⲦϢⲞⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ⲀⲨⲦⲀⲘⲞϤ ⲆⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲄⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ⲀϤϪⲒ ϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲒⲎⲤⲞⲨⲤ ⲠϢⲠⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲚⲀ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ⲀⲚⲈⲦⲘⲞⲞϢⲈ ⲆⲈ ⲈⲐⲎ ⲈⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ϪⲈ ⲈϤⲈⲔⲀ ⲢⲰϤ ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲚϨⲞⲨⲞ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲚⲀ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲀϨⲈⲢⲀⲦϤ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲨⲚⲦϤ ⲚⲀϤ ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲀϤϪⲚⲞⲨϤ ");
INSERT INTO copshc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ϪⲈ ⲞⲨ ⲠⲈⲦⲔⲞⲨⲈϢ ⲦⲢⲀⲀⲀϤ ⲚⲀⲔ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲈⲒⲈⲚⲀⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ⲈⲂⲞⲖ ⲦⲈⲔⲠⲒⲤⲦⲒⲤ ⲦⲈⲚⲦⲀⲤⲚⲀϨⲘⲈⲔ ");
INSERT INTO copshc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ ⲈϤϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀⲨ ⲀⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲀϤⲘⲞⲨϢⲦ ⲚϨⲒⲈⲢⲒⲬⲰ ");
INSERT INTO copshc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲈⲒⲤ ⲞⲨⲢⲰⲘⲈ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲌⲀⲔⲬⲀⲒⲞⲤ ⲚⲦⲞϤ ⲆⲈ ⲚⲈⲨⲀⲢⲬ ⲒⲦⲈⲖⲰⲚⲎⲤ ⲠⲈ ⲢⲢⲘⲘⲀⲞ ");
INSERT INTO copshc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ⲈϤϢⲒⲚⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ. ⲀⲨⲰ ⲘⲠϤϬⲘϬⲞⲘ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ ϪⲈ ⲚⲈ ⲞⲨⲔⲞⲨⲒ ⲠⲈ ϨⲚ ⲦⲈϤϬⲞⲦ ");
INSERT INTO copshc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ⲀϤⲠⲰⲦ ⲆⲈ ⲈⲐⲎ ⲀϤⲦⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲚⲞⲨϨⲈ ϪⲈ ⲈϤⲈⲚⲀⲨ ⲈⲢⲞϤ ϪⲈ ⲚⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ⲀϤⲈⲒ ⲆⲈ ⲈⲠⲘⲀ ⲀϤϤⲒⲀⲦϤ ⲈϨⲢⲀⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲌⲀⲔⲬⲀⲒⲞⲤ ϬⲈⲠⲎ ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲀϢⲰⲠⲈ ϨⲘ ⲠⲈⲔⲎⲒ ⲘⲠⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ⲀϤϬⲈⲠⲎ ⲆⲈ ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲀϤϢⲞⲠϤ ⲈⲢⲞϤ ⲈϤⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ⲀⲨⲚⲀⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲔⲢⲘⲢⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲀϤϬⲞⲒⲖⲈ ⲈⲨⲢⲰⲘⲈ ⲢⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ⲀⲌⲀⲔⲬⲀⲒⲞⲤ ⲆⲈ ⲀϨⲈⲢⲀⲦϤ ⲠⲈϪⲀϤ ⲘⲠϪⲞⲈⲒⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮϮ ⲠϪⲞⲈⲒⲤ ⲚⲦⲠⲀϢⲈ ⲚⲚⲀϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲚⲚϨⲎⲔⲈ ⲀⲨⲰ ⲠⲈⲚⲦⲀⲒϮ ϢⲦⲞⲨⲎⲦ ⲈⲢⲞϤ ⲚⲦⲈ ⲞⲨⲀ. ϮⲚⲀⲦⲀⲀϤ ⲚϤⲦⲞⲨ ⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲀⲨⲞⲨϪⲀⲒ ϢⲰⲠⲈ ϨⲘ ⲠⲈⲒⲎⲒ ⲘⲠⲞⲞⲨ ⲔⲀⲦⲀⲐⲈ ϪⲈ ⲞⲨϢⲎⲢⲈ ϨⲰⲰϤ ⲠⲈ ⲚⲦⲈ ⲀⲂⲢⲀϨⲀⲘ ");
INSERT INTO copshc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ⲚⲦⲀ ⲠϢⲎⲢⲈ ⲄⲀⲢ ⲘⲠⲢⲰⲘⲈ ⲈⲒ ⲈϢⲒⲚⲈ ⲈⲦⲀⲚϨⲈ ⲠⲈⲦⲤⲞⲢⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ⲈⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀϤⲞⲨⲰϨ ⲈⲦⲞⲞⲦϤ ⲀϤϪⲰ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲈⲚⲈⲨϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲚⲈⲨⲘⲈⲈⲨⲈ ⲠⲈ ϪⲈ ⲈⲢⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ⲠⲈϪⲀϤ ϬⲈ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲚⲈⲨⲄⲈⲚⲎⲤ ⲠⲈⲚⲦⲀϤⲂⲰⲔ ⲈⲨⲬⲰⲢⲀ ⲈⲤⲞⲨⲎⲨ ⲈϪⲒ ⲚⲀϤ ⲚⲞⲨⲘⲚⲦⲢⲢⲞ ⲈⲔⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲘⲎⲦ ⲚϨⲘϨⲀⲖ ⲚⲦⲞⲞⲦϤ ⲀϤϮ ⲚⲀⲨ ⲘⲘⲎⲦ ⲚⲘⲚⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲢⲒ ϨⲰⲂ ϢⲀⲚϮⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ⲚⲈⲢⲈ ⲚⲈϤⲢⲘ ⲚϮⲘⲈ ⲆⲈ ⲘⲞⲤⲦⲈ ⲘⲘⲞϤ ⲠⲈ. ⲀⲨϪⲞⲞⲨ ⲆⲈ ⲚⲞⲨⲠⲢⲈⲤⲂⲒⲀ ϨⲒ ⲠⲀϨⲞⲨ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲚⲞⲨⲈϢⲠⲀⲒ ⲀⲚ ⲈⲦⲢⲈϤⲢⲢⲢⲞ ⲈϪⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤⲈⲒ ⲈⲀϤϪⲒ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲀϤϪⲞⲞⲤ ⲈⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲚⲀϤ ⲈⲚⲒϨⲘϨⲀⲖ ⲚⲀⲒ ⲈⲚⲦⲀϤϮ ⲚⲀⲨ ⲘⲠϨⲀⲦ ϪⲈ ⲈϤⲈⲈⲒⲘⲈ ϪⲈ ⲚⲦⲀⲨⲢⲞⲨ ⲚϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ⲀⲠϢⲞⲢⲠ ⲆⲈ ⲈⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲦⲈⲔⲘⲚⲀ ϪⲠⲈ ⲘⲎⲦ ⲚⲘⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠϨⲘϨⲀⲖ ⲚⲀⲄⲀⲐⲞⲤ ϪⲈ ⲀⲔⲢ ⲠⲒⲤⲦⲞⲤ ϨⲚ ⲞⲨⲔⲞⲨⲒ. ϢⲰⲠⲈ ⲈⲨⲚⲦⲔ ⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ⲈϪⲚ ⲘⲎⲦⲈ ⲘⲠⲞⲖⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ⲀⲠⲘⲈϨ ⲤⲚⲀⲨ ⲈⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲀⲦⲈⲔⲘⲚⲀ ⲢϮⲞⲨ ⲚⲘⲚⲀ ");
INSERT INTO copshc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ⲠⲈϪⲀϤ ⲆⲈ ⲘⲠⲔⲈ ϪⲈ ⲚⲦⲞⲔ ϨⲰⲰⲔ ϢⲰⲠⲈ ⲈϪⲚ ϮⲘⲠⲞⲖⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ⲀⲠⲔⲈⲞⲨⲀ ⲆⲈ ⲈⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲦⲈⲔⲘⲚⲀ ⲈⲚⲈⲤ ⲚⲦⲞⲞⲦ ⲤⲔⲎ ϨⲚ ⲞⲨⲤⲞⲨⲆⲀⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ⲚⲈⲒⲢϨⲞⲦⲈ ⲄⲀⲢ ϨⲎⲦⲔ ϪⲈ ⲚⲦⲔ ⲞⲨⲢⲰⲘⲈ ⲚⲚⲀⲨⲤⲦⲎⲢⲞⲤ ⲈⲔϤⲒ ⲘⲠⲈⲦⲈ ⲘⲠⲔⲔⲀⲀϤ ⲈϨⲢⲀⲒ ⲈⲔⲰϨⲤ ⲘⲠⲈⲦⲈⲘⲠⲔϪⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲈⲒⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲔ ϨⲚ ⲢⲰⲔ ⲠⲠⲞⲚⲎⲢⲞⲤ ⲚϨⲘϨⲀⲖ ⲈϢϪⲈ ⲔⲤⲞⲞⲨⲚ ϪⲈ ⲀⲚⲄ ⲞⲨⲢⲰⲘⲈ ⲚⲀⲨⲤⲦⲎⲢⲞⲤ ⲈⲒϤⲒ ⲘⲠⲈⲦⲈ ⲘⲠⲒⲔⲀⲀϤ ⲈϨⲢⲀⲒ ⲈⲒⲰϨⲤ ⲘⲠⲈⲦⲈ ⲘⲠⲒϪⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ⲈⲦⲂⲈ ⲞⲨ ⲘⲠⲔϮ ⲘⲠⲀϨⲀⲦ ⲈⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲦⲀⲈⲒ ⲦⲀϪⲒⲦϤ ⲚⲘ ⲦⲈϤⲘⲎⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϪⲈ ϤⲒ ⲚⲦⲈⲘⲚⲀ ⲚⲦⲞⲞⲦϤ ⲚⲦⲈⲦⲚ ⲦⲀⲀⲤ ⲘⲠⲀ ⲠⲘⲎⲦ ⲚⲘⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲞⲨⲚⲦϤ ⲘⲎⲦ ⲚⲘⲚⲀ ");
INSERT INTO copshc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ. ϪⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ⲤⲈⲚⲀϮ ⲚⲀϤ ⲠⲈⲦⲈ ⲘⲘⲚⲦⲀϤ ⲆⲈ ⲤⲈⲚⲀϤⲒ ⲚⲦⲞⲞⲦϤ ⲘⲠⲔⲈ ⲈⲦⲈ ⲞⲨⲚⲦⲀϤⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ⲠⲖⲎⲚ ⲚⲀϪⲒϪⲈⲞⲨ ⲚⲀⲒ ⲈⲦⲈ ⲘⲠⲞⲨⲰϢ ⲈⲦⲢⲀⲢⲢⲢⲞ ⲈϪⲰⲞⲨ ⲀⲚⲒⲤⲞⲨ ⲈⲠⲈⲒⲘⲀ ⲔⲞⲚⲤⲞⲨ ⲘⲠⲀⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲆⲈ ⲀϤⲘⲞⲞϢⲈ ϨⲀ ⲦⲈⲨϨⲎ ⲈϤⲂⲎⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲂⲎⲆⲪⲀⲔⲎ ⲚⲘ ⲂⲀⲐⲀⲚⲒⲀ ⲈⲠⲦⲞⲞⲨ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲀ ⲚϪⲞⲈⲒⲦ ⲀϤϪⲞⲞⲨ ⲚⲤⲚⲀⲨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲰⲔ ⲈⲠⲈⲒϮⲘⲈ ⲈⲦⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ. ⲈⲦⲈⲦⲚⲀⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲦⲈⲦⲚⲀϨⲈ ⲈⲨⲤⲎϬ ⲈϤⲘⲎⲢ ⲠⲀⲒ ⲈⲘⲠⲈ ⲖⲀⲀⲨ ⲢⲢⲰⲘⲈ ⲀⲖⲈ ⲈⲢⲞϤ ⲈⲚⲈϨ ⲂⲞⲖϤ ⲚⲦⲈⲦⲚ ⲚⲦϤ ");
INSERT INTO copshc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ⲈⲢϢⲀⲚⲞⲨⲀ ⲆⲈ ϪⲚⲞⲨⲦⲚ ϪⲈ ϪⲈⲞⲨ ⲦⲈⲦⲚⲂⲰⲖ ⲘⲘⲞϤ. ⲀϪⲒⲤ ϪⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲠⲈⲦⲢⲬⲢⲒⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ⲀⲨⲂⲰⲔ ⲆⲈ ⲚϬⲒ ⲚⲈⲚⲦⲀⲨϪⲞⲞⲨⲤⲈ ⲀⲨϨⲈ ⲈⲢⲞⲤ ⲚⲐⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ⲈⲨⲂⲰⲖ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲤⲎϬ ⲠⲈϪⲈ ⲚⲈϤϪⲒⲤⲞⲞⲨⲈ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲂⲰⲖ ⲘⲠⲤⲎϬ ");
INSERT INTO copshc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲠⲈⲦⲢⲬⲢⲒⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ⲀⲨⲚⲦϤ ⲆⲈ ϢⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲠⲰⲢϢ ⲚⲚⲈⲨϨⲞⲒ ⲦⲈ ⲈϪⲘ ⲠⲤⲎϬ ⲀⲨⲦⲀⲖⲈ ⲒⲎⲤⲞⲨⲤ ⲈϪⲰϤ ");
INSERT INTO copshc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ⲀⲨⲠⲰⲢϢ ⲚⲚⲈⲨϨⲞⲒⲦⲈ ϨⲒ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲒ ⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ. ⲀϤⲀⲢⲬⲒ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨⲢⲀϢⲈ ⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲈⲦⲂⲈ ⲚϬⲞⲘ ⲦⲎⲢⲞⲨ ⲈⲚⲦⲀⲨⲚⲀⲨ ⲈⲢⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲢⲢⲞ ⲈⲦⲚⲎⲞⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ. ϮⲢⲎⲚⲎ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ⲠⲈⲞⲞⲨ ϨⲚ ⲚⲈⲦϪⲞⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ⲠⲈϪⲈ ϨⲞⲒⲚⲈ ⲚⲀϤ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ϪⲈ ⲠⲤⲀϨ. ⲈⲠⲒⲦⲒⲘⲀ ⲚⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲢϢⲀⲚ ⲚⲀⲒ ⲔⲀ ⲢⲰⲞⲨ. ⲚⲈⲒⲰⲚⲈ ⲚⲀϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϤⲚⲀⲨ ⲈⲦⲠⲞⲖⲒⲤ ⲀϤⲢⲒⲘⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲤ ");
INSERT INTO copshc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈ ⲚⲦⲀⲒⲘⲈ ϨⲰⲰⲦⲈ ϨⲘ ⲠⲞⲞⲨ ⲚϨⲞⲞⲨ ⲈⲚⲈⲦϢⲞⲞⲠ ⲚⲈ ⲈⲨⲈⲒⲢⲎⲚⲎ ⲦⲈⲚⲞⲨ ⲆⲈ ⲀⲨϨⲰⲠ ⲈⲚⲞⲨⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ϪⲈ ⲞⲨⲚ ϨⲈⲚϨⲞⲞⲨ ⲚⲎⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲰ ⲚⲦⲈ ⲚⲞⲨϪⲀϪⲈ ⲔⲦⲈ ⲞⲨϢⲰⲖϨ ⲈⲢⲞ ⲚⲤⲈⲞⲦⲠⲈ ⲈϨⲞⲨⲚ ⲚⲤⲀ ⲤⲀ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ⲚⲤⲈⲢⲀϨⲦⲈ ⲈⲠⲔⲀϨ ⲀⲨⲰ ⲚⲞⲨϢⲎⲢⲈ ⲚϨⲎⲦⲈ. ⲚⲤⲈⲦⲘⲔⲀ ⲞⲨⲰⲚⲈ ϨⲒϪⲚ ⲞⲨⲰⲚⲈ ⲚϨⲎⲦⲈ ⲈⲂⲞⲖ ϪⲈ ⲘⲠⲈⲤⲞⲨⲚ ⲠⲈⲨⲞⲈⲒϢ ⲘⲠⲞⲨϬⲘ ⲠϢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ ⲀϤⲀⲢⲬⲒ ⲚⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦϮ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ϤⲤⲎϨ ϪⲈ ⲠⲀⲎⲒ ⲚⲀϢⲰⲠⲈ ⲚⲚⲎⲒ ⲚϢⲖⲎⲖ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚⲒⲢⲈ ⲘⲘⲞϤ ⲚⲤⲠⲎⲖⲀⲒⲞⲚ ⲚⲤⲞⲞⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ⲚⲈϤϮⲤⲂⲰ ⲆⲈ ⲘⲘⲎⲚⲈ ⲠⲈ ϨⲘ ⲠⲈⲢⲠⲈ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲀ ⲘⲞⲞⲨⲦϤ ⲚⲘ ⲚⲚⲞϬ ⲘⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ⲀⲨⲰ ⲘⲠⲞⲨϬⲚ ⲚⲈⲨⲚⲀⲢ ⲞⲨ ⲚⲀϤ ⲚⲈⲢⲈ ⲠⲖⲀⲞⲤ ⲄⲀⲢ ⲦⲎⲢϤ ⲢⲀϢⲈ ⲠⲈ ⲈⲨⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲞⲨϨⲞⲞⲨ ⲈϤϮⲤⲂⲰ ⲘⲠⲖⲀⲞⲤ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ⲈϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲀⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲒ ⲈϪⲰϤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲀϪⲒⲤ ⲚⲀⲚ ϪⲈ ⲈⲔⲈⲒⲢⲈ ⲚⲚⲀⲒ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ. ⲎⲚⲒⲘ ⲠⲈⲚⲦⲀϤϮ ⲚⲀⲔ ⲚⲦⲈⲒⲈⲜⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ. ϮⲚⲀϪⲚⲞⲨⲦⲚ ϨⲰ ⲈⲨϢⲀϪⲈ ⲈⲦⲈⲦⲚϢⲀⲚϪⲞⲞϤ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈⲈ ⲠⲈ ϪⲈ ⲚⲞⲨⲈⲂⲞⲖ ϨⲚ ⲢⲢⲰⲘⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲘⲈⲔⲘⲞⲨⲔⲞⲨ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚϢⲀϪⲞⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈⲈ ⲠⲈ ϤⲚⲀϪⲞⲞⲤ ⲚⲀⲚ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ϬⲈ ⲘⲠⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ⲈⲚϢⲀϪⲞⲞⲤ ⲆⲈ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲢⲢⲰⲘⲈ ⲠⲈ. ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀϨⲒⲰⲚⲈ ⲈⲢⲞⲚ ⲤⲈⲠⲒⲐⲈ ⲄⲀⲢ ϨⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀⲨ ϪⲈ. ⲀⲚⲞⲔ ϨⲰ ⲚϮⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ⲀⲚ ϪⲈ ϨⲚ ⲀϢ ⲚⲈⲜⲞⲨⲤⲒⲀ ⲈⲒⲈⲒⲢⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ⲀϤⲀⲢⲬⲒ ⲆⲈ ⲚϪⲰ ⲘⲠⲖⲀⲞⲤ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲠⲈⲚⲦⲀϤⲦⲰϬⲈ ⲚⲞⲨⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀϤⲦⲀⲀⲀϤ ⲚϨⲈⲚⲞⲨⲈⲒⲎ ⲀϤⲀⲠⲞⲆⲎⲘⲈⲒ ⲚϨⲈⲚⲚⲞϬ ⲚⲞⲨⲞⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ϨⲘ ⲠⲈⲨⲞⲈⲒϢ ⲆⲈ ⲚⲚⲔⲀⲢⲠⲞⲤ ⲀϤϪⲈⲨ ⲞⲨϨⲘϨⲀⲖ ⲚⲞⲨⲈⲒⲎ ϪⲈ ⲈⲨⲈϮ ⲚⲀϤ ϨⲘ ⲠⲔⲀⲢⲠⲞⲤ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ. ⲚⲞⲨⲈⲒⲎ ⲆⲈ ⲀⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ ⲀⲨϪⲚⲀϤ ⲈϤϢⲞⲨⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ⲀⲨⲰ ⲀϤⲞⲨⲰϨ ⲈⲦⲞⲞⲦϤ ⲈϪⲞⲞⲨ ⲚⲔⲈϨⲘϨⲀⲖ ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϨⲒⲞⲨⲈ ⲈⲠⲔⲈⲞⲨⲀ ⲀⲨⲤⲞϢϤ ⲀⲨϪⲞⲞⲨϤ ⲈϤϢⲞⲨⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ⲀϤⲞⲨⲰϨ ⲈⲦⲞⲞⲦϤ ⲈϪⲞⲞⲨ ⲘⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲖϨ ⲠⲈⲒⲔⲈⲦ ⲀⲨⲚⲞϪϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ϪⲈ ⲈⲒⲚⲀⲢ ⲞⲨ ϮⲚⲀϪⲞⲞⲨ ⲘⲠⲀϢⲎⲢⲈ ⲘⲘⲈⲢⲒⲦ ⲘⲈϢⲀⲔ ⲈⲨⲈϢⲒⲠⲈ ϨⲎⲦϤ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ⲀⲚⲞⲨⲈⲒⲎ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨϢⲞϪⲚⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲘⲀⲢⲚⲘⲞⲞⲨⲦϤ ϪⲈ ⲈⲢⲈ ⲦⲈⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ϢⲰⲠⲈ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ⲀⲨⲚⲞϪϤ ⲆⲈ ⲈⲂⲞⲖ ⲠⲂⲞⲖ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲀⲨⲘⲞⲞⲨⲦϤ. ⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ϬⲈ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚⲀⲢ ⲞⲨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ϤⲚⲎⲨ ⲚϤⲦⲀⲔⲈ ⲚⲞⲨⲈⲒⲎ ⲚϤϮ ⲘⲠⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚϨⲈⲚⲔⲞⲞⲨⲈ. ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲚⲚⲈⲤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ⲚⲦⲞϤ ⲆⲈ ⲀϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲞⲨ ⲚⲦⲞⲞⲨⲚ ⲠⲈ ⲠⲀⲒ ⲈⲦⲤⲎϨ ϪⲈ ⲠⲰⲚⲈ ⲈⲚⲦⲀ ⲚⲈⲦⲔⲰⲦ ⲤⲦⲞϤ ⲈⲂⲞⲖ ⲠⲀⲒ ⲀϤϢⲰⲠⲈ ⲈⲨⲀⲠⲈ ⲚⲔⲞⲞϨ. ");
INSERT INTO copshc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀϤϨⲈ ⲈϪⲘ ⲠⲈⲒⲰⲚⲈ ⲈⲦⲘⲘⲀⲨ. ϤⲚⲀⲖⲰⲰⲤ. ⲠⲈⲦϤⲚⲀϨⲈ ⲆⲈ ⲈϪⲰϤ ϤⲚⲀϢⲀϢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ⲀⲨϢⲒⲚⲈ ⲆⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲚ ⲚⲈⲨϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈϬⲞⲠϤ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲖⲀⲞⲤ. ⲀⲨⲒⲘⲈ ⲄⲀⲢ ϪⲈ ⲚⲦⲀϤϪⲰ ⲈⲢⲞⲞⲨ ⲚⲦⲈⲒⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ⲀⲨⲠⲀⲢⲀⲦⲎⲢⲒ ⲆⲈ ⲀⲨϪⲞⲞⲨ ⲚϨⲈⲚⲢⲈϤϬ ⲰⲢϬ ⲈϨⲨⲠⲞⲔⲢⲒⲚⲈ. ϪⲈ ⲚⲈ ϨⲈⲚⲆⲒⲔⲀⲒⲞⲤ ⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϬⲞⲠϤ ⲚⲞⲨϢⲀϪⲈ ⲈⲦⲢⲈⲨⲦⲀⲀϤ ⲈⲦⲀⲢⲬⲎ ⲚⲘ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲘⲪⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲔϢⲀϪⲈ ϨⲚ ⲞⲨⲤⲞⲞⲨⲦⲚ ⲀⲨⲰ ⲔϮⲤⲂⲰ ⲈⲘⲈⲔϪⲒ ϨⲞ ⲀⲖⲖⲀ ⲈⲔϮⲤⲂⲰ ϨⲚ ⲦⲈϨⲒⲎ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ⲈⲜⲈⲤⲦⲒ ⲚⲀⲚ ⲈϮⲪⲞⲢⲞⲤ ⲘⲠⲢⲢⲞ ϪⲈⲚ ⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ⲀϤⲒⲘⲈ ⲆⲈ ⲈⲦⲈⲨⲠⲀⲚⲞⲨⲢⲄⲒⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ϪⲈ ⲘⲀⲦⲤⲀⲂⲞⲒ ⲈⲨⲤⲀⲦⲈⲈⲢⲈ ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲦⲞⲨⲞϤ ⲠⲈϪⲀϤ ϪⲈ ⲠϨⲞ ⲚⲚⲒⲘ ⲦⲈⲦϨⲒⲰⲰⲤ ⲘⲚ ⲚⲈⲤϨⲀⲒ ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲀⲠⲢⲢⲞ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. Ϯ ⲚⲦⲞⲞⲨⲚ ⲚⲚⲀ ⲠⲢⲢⲞ ⲘⲠⲢⲢⲞ. ⲀⲨⲰ ⲚⲀⲠⲚⲞⲨⲦⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ⲀⲨⲰ ⲘⲠⲞⲨⲈϢϬⲘϬⲞⲘ ⲈϬⲞⲠϤ ⲚⲞⲨϢⲀϪⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲖⲀⲞⲤ ⲀⲨⲢϢⲠⲎⲢⲈ ⲆⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈϤϢⲀϪⲈ ⲀⲨⲔⲀ ⲢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲚⲀⲒ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲀϢⲰⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ϪⲈ ⲠⲤⲀϨ ⲀⲘⲰⲨⲤⲎⲤ ⲤⲀϨϤ ⲚⲀⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲈⲢϢⲀⲚ ⲠⲤⲞⲚ ⲞⲨⲀ ⲘⲞⲨ ⲈⲨⲚⲦϤ ⲤϨⲒⲘⲈ ⲘⲘⲀⲨ ⲠⲀⲒ ⲆⲈ ⲈⲨⲀⲦϢⲎⲢⲈ ⲠⲈ ⲈⲢⲈ ⲠⲈϤⲤⲞⲚ ϪⲒ ⲦⲈϤⲤϨⲒⲘⲈ ⲚϤⲦⲞⲨⲚⲞⲤ ⲚⲞⲨⲤⲠⲈⲢⲘⲀ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ⲚⲈⲨⲚ ⲤⲀϢϤ ⲆⲈ ⲚⲤⲞⲚ. ⲀⲠϢⲞⲢⲠ ϪⲒ ϨⲒⲘⲈ ⲀϤⲘⲞⲨ. ⲈϤⲞ ⲚⲀⲦϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ⲀⲨⲰ ⲀⲠⲘⲈϨ ⲤⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ⲚⲘ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ϪⲒⲦⲤ. ϨⲰⲤ ⲀⲨⲦⲰⲤ ⲆⲈ ⲘⲠⲤⲀϢϤ ⲘⲠⲞⲨⲔⲀ ϢⲎⲢⲈ ⲀⲨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ⲘⲚⲚⲤⲰⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲤⲘⲞⲨ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲆⲈ ⲈⲤⲚⲀⲢϨⲒⲘⲈ ⲚⲚⲒⲘ ⲘⲘⲞⲞⲨ. ⲀⲠⲤⲀϢϤ ⲄⲀⲢ ϪⲒⲦⲤ ⲚⲤϨⲒⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ. ⲚϢⲎⲢⲈ ⲘⲠⲈⲒⲀⲒⲰⲚ ⲤⲈϪⲒ ϨⲒⲘⲈ ⲤⲈϨⲘⲞⲞⲤ ⲚⲘ ϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ⲚⲈⲚⲦⲀⲨⲔⲀⲦⲀⲜⲒⲞⲨ ⲆⲈ ⲘⲘⲞⲞⲨ ⲈϪⲒ ⲘⲠⲀⲒⲰⲚ ⲈⲦⲘⲘⲀⲨ ⲚⲘ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲞⲨⲆⲈ ⲘⲈⲨϪⲒ ϨⲒⲘⲈ ⲞⲨⲆⲈ ⲘⲈⲨϨⲘⲞⲞⲤ ⲚⲘ ϨⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ⲞⲨⲆⲈ ⲄⲀⲢ ⲚⲤⲈⲚⲀϢ ⲘⲞⲨ ⲀⲚ ϪⲒⲚ ⲦⲈⲚⲞⲨ. ϨⲈⲚϨⲒⲤⲀⲄⲄⲈⲖⲞⲤ ⲄⲀⲢ ⲚⲈ ϨⲈⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲈ. ⲀⲨⲰ ⲚϢⲎⲢⲈ ⲚⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ⲈⲦⲂⲈ ϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲆⲈ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲘⲰⲨⲤⲎⲤ ⲞⲚ ϪⲞⲞⲤ ϨⲒ ⲠⲂⲀⲦⲞⲤ ⲚⲐⲈ ⲈϢⲀⲨϪⲞⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲤⲀⲀⲔ ⲠⲚⲞⲨⲦⲈ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲠⲀ ⲚⲈⲦⲞⲚϨ ⲠⲈ. ⲤⲈⲞⲚϨ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ⲀϨⲞⲒⲚⲈ ⲆⲈ ⲞⲨⲰϢⲂ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲤⲀϨ ⲔⲀⲖⲰⲤ ⲀⲔϪⲞⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ⲘⲠⲞⲨⲦⲞⲖⲘⲀ ⲄⲀⲢ ⲘⲚⲚⲤⲰⲤ ⲈϪⲚ ⲞⲨϤ ⲈⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲚⲆⲀⲨⲈⲒⲆ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ⲚⲦⲞϤ ⲄⲀⲢ ⲆⲀⲨⲈⲒⲆ ϢⲀϤϪⲞⲞⲤ ϨⲘ ⲠϪⲰⲰⲘⲈ ⲚⲚⲈⲮⲀⲖⲘⲞⲤ. ϪⲈ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲀϪⲞⲈⲒⲤ ϪⲈ ϨⲘ ⲞⲞⲤ ϨⲒ ⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ϢⲀⲚϮⲔⲰ ⲚⲚⲈⲔϪⲀϪⲈ ⲚϨⲨⲠⲞⲠⲞⲆⲒⲞⲚ ⲚⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ⲆⲀⲨⲈⲒⲆ ϬⲈ ⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲀϪⲞⲈⲒⲤ ⲚⲀϢ ⲚϨⲈ ⲠⲈϤϢⲎⲢⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ⲚⲈⲢⲈ ⲠⲖⲀⲞⲤ ⲆⲈ ⲦⲎⲢϤ ⲤⲰⲦⲘ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ϪⲈ ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ⲈⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲀⲒ ⲈⲦⲞⲨⲈϢ ⲘⲞⲞϢⲈ ϨⲚ ϨⲈⲚⲤⲦⲞⲖⲎ ⲈⲦⲘⲈ ⲚⲚⲀⲤⲠⲀⲤⲘⲞⲤ ϨⲚ ⲚⲀⲄⲞⲢⲀ ⲀⲨⲰ ⲘⲘⲀ ⲚⲈϨⲘⲞⲞⲤ ⲚϢⲞⲢⲠ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲘ ⲚⲘⲀ ⲚⲚⲞϪⲞⲨ ⲚϢⲞⲢⲠ ϨⲚ ⲚⲆⲈⲒⲠⲚⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ⲚⲀⲒ ⲈⲦⲞⲨⲰⲘ ⲚⲚⲎⲒ ⲚⲚⲈⲬⲎⲢⲀ. ⲀⲨⲰ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲖⲞⲒϬⲈ ⲈⲨϢⲖⲎⲖ ⲚⲀⲒ ⲚⲀϪⲒ ⲚⲞⲨⲔⲢⲒⲘⲀ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ⲀϤϤⲒⲀⲦϤ ⲆⲈ ⲈϨⲢⲀⲒ ⲀϤⲚⲀⲨ ⲈⲚⲢⲘⲘⲀⲞ ⲈⲨⲚⲞⲨϪⲈ ⲚⲚⲈⲨⲆⲰⲢⲞⲚ ⲈⲠⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲨⲬⲎⲢⲀ ⲚϨⲎⲔⲈ ⲈⲤⲚⲞⲨϪⲈ ⲈⲘⲀⲨ ⲖⲖⲈⲠⲦⲞⲚ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲘⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲒⲬⲎⲢⲀ ⲚϨⲎⲔⲈ ⲀⲤⲚⲞⲨϪⲈ ⲈϨⲞⲨⲈⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ⲚⲦⲀ ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲈϪ ⲚⲈⲨⲆⲰⲢⲞⲚ ϨⲘ ⲠⲈⲦⲢϨⲞⲨⲞ ⲈⲢⲞⲞⲨ ⲦⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤϢⲰⲰⲦ ⲠⲈⲦⲚⲦⲀⲤ ⲦⲎⲢϤ ⲀⲤⲚⲞϪϤ. ");
INSERT INTO copshc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ⲀⲨⲰ ⲚⲈⲨⲚ ϨⲞⲒⲚⲈ ϪⲰ ⲘⲘⲞⲤ ⲈⲦⲂⲈ ⲠⲈⲢⲠⲈ ϪⲈ ⲚⲈϤⲔⲞⲤⲘⲒ ϨⲚ ϨⲈⲚⲰⲚⲈ ⲈⲚⲀⲚⲞⲨⲞⲨ ⲚⲘ ϨⲈⲚⲀⲚⲀⲐⲈⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ⲠⲈϪⲀϤ ϪⲈ. ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲞⲨⲚ ϨⲈⲚϨⲞⲞⲨ ⲚⲎⲨ ⲈⲚⲤⲈⲚⲀⲔⲀ ⲞⲨⲰⲚⲈ ⲀⲚ ϨⲒϪⲚ ⲞⲨⲰⲚⲈ ⲘⲠⲈⲒⲘⲀ ⲈⲘⲠⲞⲨⲂⲞⲖϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲤⲀϨ. ⲈⲢⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲈ ⲦⲚⲀⲨ ⲀⲨⲰ ⲞⲨ ⲠⲈ ⲠⲘⲀⲈⲒⲚ ⲈⲢⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϬⲰϢⲦ ⲘⲠⲢⲠⲖⲀⲚⲀ ⲞⲨⲚ ϨⲀϨ ⲄⲀⲢ ⲚⲎⲨ ϨⲘ ⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲰ ⲀⲠⲈⲨⲞⲒϢ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲘⲠⲢⲞⲨⲈϨ ⲦⲎⲨⲦⲚ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ⲈⲦⲈⲦⲚϢⲀⲚⲤⲰⲦⲘ ⲆⲈ ⲈϨⲈⲚⲠⲞⲖⲈⲘⲞⲤ ⲚⲘ ϨⲈⲚϢⲦⲞⲢⲦⲢ ⲘⲠⲢⲢϨⲞⲦⲈ. ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲈ ⲚⲀⲒ ϢⲰⲠⲈ ⲚϢⲞⲢⲠ ⲀⲖⲖⲀ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲚ ⲈⲢⲈ ⲐⲀⲎ ⲚⲀϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲞⲨⲚ ⲞⲨϨⲈⲐⲚⲞⲤ ⲚⲀⲦⲰⲞⲨⲚ ⲈϪⲚ ⲞⲨϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲞⲨⲘⲚⲦⲢⲢⲞ ⲈϪⲚ ⲞⲨⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ϨⲈⲚⲚⲞϬ ⲚⲔⲘⲚⲦⲞ ⲚⲘ ϨⲈⲚϨⲔⲞ ⲔⲀⲦⲀ ⲘⲀ. ⲀⲨⲰ ⲞⲨⲚ ϨⲈⲚⲖⲞⲒⲘⲞⲤ ⲚⲀϢⲰⲠⲈ. ⲞⲨⲚ ϨⲈⲚϨⲞⲦⲈ ⲚⲘ ϨⲈⲚⲚⲞϬ ⲘⲘⲀⲒⲚⲀϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ϨⲀⲐⲎ ⲆⲈ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲈⲚⲀϬⲈⲠ ⲦⲎⲞⲨⲦⲚ ⲤⲈⲚⲀⲆⲒⲰⲔⲈ ⲘⲘⲰⲦⲚ ⲈⲨϮ ⲘⲘⲰⲦⲚ ⲈⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲚ ⲚⲈϢⲦⲈⲔⲰⲞⲨ ⲈⲨϪⲒ ⲘⲘⲰⲦⲚ ⲈⲚⲈⲢⲢⲰⲞⲨ ⲚⲘ ⲚϨⲎⲄⲈⲘⲰⲚ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ⲤⲚⲀϢⲰⲠⲈ ⲆⲈ ⲚⲎⲦⲚ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ⲔⲀⲀⲤ ϬⲈ ϨⲘ ⲠⲈⲦⲚϨⲎⲦ ⲈⲦⲘⲘⲈⲖⲈⲦⲀ ⲈⲀⲠⲞⲖⲞⲄⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ⲀⲚⲞⲔ ⲄⲀⲢ ϮⲚⲀϮ ⲚⲎⲦⲚ ⲚⲞⲨⲦⲀⲠⲢⲞ ⲚⲘ ⲞⲨⲤⲞⲪⲒⲀ ⲦⲀⲒ ⲈⲚⲤⲈⲚⲀϢϬⲘϬⲞⲘ ⲀⲚ ⲈϮ ⲎⲈⲞⲨⲰϨⲘ ⲞⲨⲂⲎⲤ ⲚϬⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϮ ⲞⲨⲂⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ⲤⲈⲚⲀϮ ⲦⲎⲞⲨⲦⲚ ⲆⲈ ϨⲒⲦⲚ ⲚⲈⲦⲚⲒⲞⲦⲈ ⲘⲚ ⲚⲈⲦⲚⲤⲚⲎⲞⲨ. ⲘⲚ ⲚⲈⲦⲚⲤⲨⲄⲄⲈⲚⲎⲤ ⲘⲚ ⲚⲈⲦⲚϢⲂⲈⲈⲢ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲈⲨⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ ϨⲒⲦⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ⲀⲨⲰ ⲚⲚⲈⲨϤⲰ ϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲦⲚⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ϨⲚ ⲦⲈⲦⲚϨⲨⲠⲞⲘⲞⲚⲎ ⲆⲈ ⲈⲦⲈⲦⲚⲀϪⲠⲞ ⲚⲎⲦⲚ ⲚⲚⲈⲦⲚⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ⲆⲈ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲢⲈ ⲘⲘⲀⲦⲞⲒ ⲔⲰⲦⲈ ⲈⲢⲞⲤ. ⲦⲞⲦⲈ ⲒⲘⲈ ϪⲈ ⲀⲠⲈⲤϢⲰϤ ϨⲰⲚ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ⲦⲞⲦⲈ ⲚⲈⲦϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲘⲀⲢⲞⲨⲠⲰⲦ ⲈⲚⲦⲞⲨⲒⲎ. ⲀⲨⲰ ⲚⲈⲦϨⲚ ⲦⲈⲤⲘⲎⲦⲈ ⲘⲀⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ. ⲀⲨⲰ ⲚⲈⲦϨⲚ ⲚⲈⲬⲰⲢⲀ ⲘⲠⲢⲦⲢⲈⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ϪⲈ ⲚⲀⲒ ⲄⲀⲢ ⲚⲈ ⲚⲈϨⲞⲞⲨ ⲘⲠϪⲒ ⲔⲂⲀ ⲈⲦⲢⲈ ⲚⲈⲦⲤⲎϨ ⲦⲎⲢⲞⲨ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲈⲦⲈⲈⲦ ⲘⲚ ⲚⲈⲦⲤⲚⲔⲞ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ⲤⲚⲀϢⲰⲠⲈ ⲄⲀⲢ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲚⲀⲚⲀⲄⲔⲎ ϨⲒϪⲘ ⲠⲔⲀϨ ⲀⲨⲰ ⲞⲨⲚⲞϬ ⲚⲞⲢⲄⲎ ⲘⲠⲒⲖⲀⲦⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ⲚⲤⲈϨⲈ ϨⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲦⲤⲎϤⲈ. ⲀⲨⲰ ⲤⲈⲚⲀⲀⲒⲬⲘⲀⲖⲰⲦⲒⲌⲈ ⲘⲘⲞⲞⲨ ⲈⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ⲚⲦⲈ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϢⲰⲠⲈ ⲈⲢⲈ ⲚϨⲈⲐⲚⲞⲤ ⲘⲞⲞϢⲈ ⲚϨⲎⲦⲤ ϢⲀⲚⲦⲈ ⲚⲞⲨⲞⲒϢ ⲚⲚϨⲈⲐⲚⲞⲤ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ⲀⲨⲰ ⲤⲈⲚⲀϢⲰⲠⲈ ⲚϬⲒ ϨⲈⲚⲘⲀⲒⲚ ϨⲘ ⲠⲢⲎ ⲚⲘ ⲠⲞⲞϨ ⲚⲘ ⲚⲤⲒⲞⲨ. ⲀⲨⲰ ⲠⲤⲰⲞⲨϨ ⲚⲚϨⲈⲐⲚⲞⲤ ϨⲒϪⲘ ⲠⲔⲀϨ ϨⲚ ⲦⲀⲠⲞⲢⲒⲀ ⲘⲠⲈϨⲢⲞⲞⲨ ⲚⲘⲠⲔⲒⲘ ⲚⲐⲀⲖⲀⲤⲤⲀ ");
INSERT INTO copshc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ⲈⲢⲈ ⲢⲢⲰⲘⲈ ⲔⲰ ⲚⲦⲞⲞⲦⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲐⲞⲦⲈ ⲘⲚ ⲚⲈⲦⲞⲨϬⲰϢⲦ ϨⲎⲦⲞⲨ ⲈⲦⲚⲎⲞⲨ ⲈϪⲚ ⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲚϬⲞⲘ ⲄⲀⲢ ⲚⲘ ⲠⲎⲞⲨⲈ ⲚⲀⲔⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲎⲞⲨ ϨⲚ ⲞⲨⲔⲖⲞⲞⲖⲈ ⲚⲘ ⲞⲨϬⲞⲘ ⲀⲨⲰ ⲞⲨⲈⲞⲞⲨ ⲈⲚⲀϢⲰϤ ");
INSERT INTO copshc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ⲈⲢⲈ ⲚⲀⲒ ⲆⲈ ⲚⲀⲀⲢⲬⲒ ⲚϢⲰⲠⲈ ϬⲰϢⲦ ⲚⲦⲈⲦⲚ ϤⲒ ϪⲰⲦⲚ ⲈϨⲢⲀⲒ ϪⲈ ⲀⲠⲈⲦⲚⲤⲰⲦⲈ ϨⲰⲚ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ⲀϤϪⲰ ⲆⲈ ⲚⲀⲨ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲀⲚⲀⲨ ⲈⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲚⲘ ⲚϢⲎⲚ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ϨⲞⲦⲀⲚ ⲈⲨϢⲀⲚϮⲞⲨⲰ ⲎⲆⲎ ⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲦⲚ ⲦⲈⲦⲚⲒⲘⲈ ϪⲈ ⲀⲠϢⲰⲘ ϨⲰⲚ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲈⲚⲀⲒ ⲈⲨϢⲰⲠⲈ ⲈⲒⲘⲈ ϪⲈ ⲀⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ϨⲰⲚ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲈ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲞⲨⲈⲒⲚⲈ ⲈⲘⲠⲞⲨϢⲰⲠⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ⲦⲠⲈ ⲚⲘ ⲠⲔⲀϨ ⲚⲀⲤⲒⲚⲈ ⲚⲀϢⲀϪⲈ ⲆⲈ ⲚⲤⲈⲚⲀⲤⲒⲚⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈ ⲠⲈⲦⲚϨⲎⲦ ϨⲢⲞϢ ϨⲚ ⲞⲨⲤⲒ ⲚⲘ ⲞⲨϮϨⲈ. ⲚⲘ ϨⲈⲚⲢⲞⲞⲨϢ ⲚⲦⲈ ⲠⲂⲒⲞⲤ. ⲚⲦⲈ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲒ ⲈϪⲰⲦⲚ ϨⲚ ⲞⲨϢⲠ ⲚϢⲰⲠ ");
INSERT INTO copshc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ⲚⲐⲈ ⲚⲞⲨⲠⲀϢ. ϤⲚⲎⲞⲨ ⲄⲀⲢ ⲈϪⲚ ⲚⲈⲦϨⲘⲞⲞⲤ ϨⲒϪⲚ ⲠϨⲞ ⲘⲠⲔⲀϨ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ⲢⲞⲈⲒⲤ ⲆⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲚⲦⲈⲦⲚ ⲤⲞⲠⲤ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϢϬⲘϬⲞⲘ ⲈⲢⲂⲞⲖ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲚⲀϢⲰⲠⲈ ⲀⲨⲰ ⲈⲀϨⲈⲢⲀⲦ ⲦⲎⲞⲨⲦⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ⲚⲈϤϮⲤⲂⲰ ⲆⲈ ⲘⲘⲈⲈⲢⲈ ⲠⲈ ϨⲘ ⲠⲈⲢⲠⲈ. ⲈϤⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲰⲢⲀϨ ⲈϤϢⲰⲠⲈ ϨⲘ ⲠⲦⲞⲞⲨ ⲈⲦⲈ ϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲀ ⲚϪⲞⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ⲀⲨⲰ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲈϤϢⲰⲢⲠ ⲘⲘⲞϤ ⲈⲢⲀⲦϤ ⲠⲈ ϨⲘ ⲠⲈⲢⲠⲈ ⲈⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ⲀϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠϢⲀ ⲚⲀⲐⲀⲂ ⲠⲈⲦⲈ ϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲠⲀⲤⲬⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ⲀⲨⲰ ⲀⲨϢⲒⲚⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲚⲤⲀ ⲐⲈ ⲚⲦⲀⲔⲞϤ. ⲚⲈⲨⲢϨⲞⲦⲈ ⲄⲀⲢ ϨⲎⲦϤ ⲘⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲆⲈ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲒⲞⲨⲆⲀⲤ ⲠⲈⲦⲈ ϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲈⲨⲀ ⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲦⲎⲠⲈ ⲠⲈ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ⲀϤⲂⲰⲔ ⲆⲈ ⲀϤϪⲰ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲚⲐⲈ ⲘⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ⲀⲨⲰ ⲀⲨⲢⲀϢⲈ ⲀⲨⲤⲘⲚⲦⲤ ⲚⲘⲘⲀϤ ⲈϮ ⲚⲀϤ ⲚϨⲈⲚϨⲞⲘⲚⲦ ");
INSERT INTO copshc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ⲀϤⲈⲜⲞⲘⲞⲖⲞⲄⲒ. ⲀϤϢⲒⲚⲈ ⲚⲤⲀ ⲞⲨⲞⲒϢ ⲘⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚⲀⲨ ⲀϪⲚ ⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ⲀⲠⲈϨⲞⲞⲨ ⲆⲈ ⲚⲀⲐⲀⲂ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲠⲀⲒ ⲈⲦⲎⲠ ⲈϢⲈⲦⲠ ⲠⲀⲤⲬⲀ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ⲀϤϪⲞⲞⲨ ⲆⲈ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲘ ⲒⲰϨⲀⲚⲚⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ. ⲂⲰⲔ ⲚⲦⲈⲦⲚ ⲤⲞⲂⲦⲈ ⲚⲀⲚ ⲘⲠⲠⲀⲤⲬⲀ ϪⲈ ⲈⲚⲈⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲈⲔⲞⲨⲈϢ ⲦⲢⲈⲚⲤⲞⲂⲦⲈ ⲚⲀⲔ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲈⲒⲠⲞⲖⲒⲤ ⲞⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲚⲀⲦⲰⲘⲚⲦ ⲈⲢⲰⲦⲚ ⲈⲢⲈ ⲞⲨϢⲞϢⲞⲨ ⲘⲘⲞⲞⲨ ϨⲒϪⲰϤ ⲞⲨⲀϨ ⲦⲎⲨⲦⲚ ⲚⲤⲰϤ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲈⲦϤⲚⲀ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ⲚⲦⲈⲦⲚ ϪⲞⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲘⲠⲎⲒ. ϪⲈ ⲠⲤⲀϨ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲈⲢⲈ ⲠⲀⲘⲀ ⲚϬⲞⲒⲖⲈ ⲦⲰⲚ ⲠⲘⲀ ⲈϮⲚⲀⲞⲨⲰⲘ ⲘⲠⲠⲀⲤⲬⲀ ⲚϨⲎⲦϤ ⲚⲘ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ⲀⲨⲰ ⲠⲈⲦⲘⲘⲀⲨ ⲚⲀⲦⲤⲀⲂⲰⲦⲚ ⲈⲨⲚⲞϬ ⲘⲘⲀ ⲚⲦⲠⲈ ⲈϤⲠⲞⲢϢ ⲤⲂⲦⲰⲦϤ ⲚⲀⲒ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ⲀⲨⲂⲰⲔ ⲆⲈ ⲀⲨϨⲈ ⲈⲢⲞϤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲨ ⲀⲨⲤⲞⲂⲦⲈ ⲘⲠⲠⲀⲤⲬⲀ ");
INSERT INTO copshc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲦⲈⲨⲚⲞⲨ ϢⲰⲠⲈ ⲀϤⲚⲞϪϤ ⲚⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ϨⲚ ⲞⲨⲈⲠⲒⲐⲨⲘⲒⲀ ⲀⲒⲈⲠⲒⲐⲨⲘⲒ ⲈⲨⲰⲘ ⲘⲠⲈⲒⲠⲀⲤⲬⲀ ϢⲚⲘ ⲚⲘⲘⲎⲦⲚ ⲈⲘⲠⲀϮⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲀⲞⲨⲞⲘϤ ϢⲀⲚⲦϤϪⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ⲀϤϪⲒ ⲆⲈ ⲚⲞⲨⲀⲠⲞⲦ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϪⲒ ⲠⲀⲒ ⲚⲦⲈⲦⲚ ⲠⲞϢϤ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲚⲀⲤⲰ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲄⲈⲚⲎⲘⲀ ⲚⲦⲈⲒⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ ϢⲀⲚⲦⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ⲀⲨⲰ ⲀϤϪⲒ ⲚⲞⲨⲞⲒⲔ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲀϤⲠⲞϢϤ ⲀϤⲦⲀⲀϤ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲀⲀϤ ϨⲀⲢⲰⲦⲚ. ⲀⲢⲒ ⲠⲀⲒ ⲈⲠⲀⲢⲠⲘⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ⲀⲨⲰ ⲠⲀⲠⲞⲦ ⲞⲚ ⲘⲘⲚⲚⲤⲀ ⲦⲢⲈⲨⲞⲨⲰⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲒⲀⲠⲞⲦ ⲦⲈ ⲦⲆⲒⲀⲐⲎⲔⲎ ⲂⲂⲢⲢⲈ ⲠⲈ ϨⲘ ⲠⲀⲤⲚⲞϤ ⲠⲀⲒ ⲈⲦⲞⲨⲚⲀⲠⲀϨⲦϤ ⲈⲂⲞⲖ ϨⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ⲠⲖⲎⲚ ⲈⲒⲤ ⲦϬⲒϪ ⲘⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ ϨⲒ ⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ϪⲈ ⲠϢⲎⲢⲈ ⲘⲈⲚ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲂⲰⲔ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ⲚⲀϤ. ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲞⲨⲚⲀⲦⲀⲀϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲀⲢⲬⲒ ⲚⲤⲨⲚⲌⲎⲦⲒ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲚⲒⲘ ⲚϨⲎⲦⲞⲨ ⲠⲈⲦⲚⲀⲢ ⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ⲀϤϢⲰⲠⲈ ⲆⲈ ⲚϬⲒ ⲞⲨϮⲦⲰⲚ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲚⲒⲘ ⲘⲘⲞⲞⲨ ⲠⲈ ⲠⲚⲞϬ ");
INSERT INTO copshc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲈⲢⲢⲰⲞⲨ ⲚⲚϨⲈⲐⲚⲞⲤ ⲤⲈⲞ ⲘⲠⲈⲨϪⲞⲈⲒⲤ ⲀⲨⲰ ⲚⲈⲦⲞ ⲚϪⲞⲈⲒⲤ ⲈⲢⲞⲞⲨ ⲤⲈⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ϪⲈ ⲢⲢⲈϤⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲒϨⲈ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲠⲚⲞϬ ⲈⲦⲚϨⲎⲦ ⲦⲎⲞⲨⲦⲚ ⲘⲀⲢⲈϤⲢ ⲐⲈ ⲘⲠⲔⲞⲨⲒ ⲀⲨⲰ ⲠⲈⲦϨⲒϪⲰⲦⲚ ⲚⲐⲈ ⲘⲠⲈⲦⲆⲒⲀⲔⲞⲚⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈ ⲠⲚⲞϬ ⲠⲈⲦⲚⲎϪ ⲠⲈ ϪⲈ ⲘⲠⲈⲦⲆⲒⲀⲔⲞⲚⲒ ⲠⲈ. ⲘⲎ ⲘⲠⲈⲦⲚⲎϪ ⲀⲚ ⲠⲈ ⲀⲚⲞⲔ ⲆⲈ ⲈⲒϨⲚ ⲦⲈⲦⲚⲘⲎⲦⲈ ⲚⲐⲈ ⲘⲠⲈⲦⲆⲒⲀⲔⲞⲚⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲈⲚⲦⲀⲨϨⲨⲠⲞⲘⲒⲚⲈ ⲚⲘⲘⲀⲒ ϨⲚ ⲚⲀⲠⲈⲒⲢⲀⲤⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ⲀⲚⲞⲔ ϨⲰ ϮⲤⲘⲒⲚⲈ ⲘⲘⲞⲤ ⲚⲘⲘⲎⲦⲚ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ⲤⲘⲒⲚⲈ ⲘⲘⲞⲤ ⲚⲘⲘⲀⲒ ⲚⲞⲨⲘⲚⲦⲢⲢⲞ ");
INSERT INTO copshc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ϪⲈ ⲈⲦⲈⲦⲚⲈⲞⲨⲰⲘ ⲚⲦⲈⲦⲚ ⲤⲰ ϨⲒϪⲚ ⲦⲀⲦⲢⲀⲠⲈⲌⲀ ϨⲚ ⲦⲀⲘⲚⲦⲢⲢⲞ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ϨⲘ ⲞⲞⲤ ϨⲒϪⲚ ⲚⲈⲐⲢⲞⲚⲞⲤ ⲚⲦⲈⲦⲚ ⲔⲢⲒⲚⲈ ⲚⲦⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲪⲨⲖⲎ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ⲤⲒⲘⲰⲚ ⲤⲒⲘⲰⲚ ⲈⲒⲤ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲀϤⲀⲒⲦⲒ ⲘⲘⲰⲦⲚ ⲈⲤⲈⲔⲦ ⲦⲎⲞⲨⲦⲚ ⲚⲐⲈ ⲘⲠⲈⲤⲞⲨⲞ ");
INSERT INTO copshc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲤⲞⲠⲤ ⲈϪⲰⲔ ϪⲈ ⲚⲚⲈⲦⲈⲔⲠⲒⲤⲦⲒⲤ ⲰϪⲚ. ⲚⲦⲞⲔ ⲆⲈ ϨⲰⲰⲔ ⲔⲞⲦⲔ ⲚⲄⲦⲀϪⲢⲈ ⲚⲈⲔⲤⲚⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ. ϮⲤⲂⲦⲰⲦ ⲚⲘⲘⲀⲔ ⲈⲈⲒ ⲈⲠⲈϢⲦⲈⲔⲞ ⲀⲨⲰ ⲈⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲠⲈⲦⲢⲈ ϪⲈ ⲚⲚⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲘⲠⲞⲞⲨ ϢⲀⲚⲦⲔⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲘⲚⲦ ⲤⲰⲰⲠ. ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲈⲢⲒϪⲈⲨ ⲦⲎⲞⲨⲦⲚ ⲀϪⲚ ⲦⲰⲰⲘⲈ ϨⲒ ⲠⲎⲢⲀ ϨⲒ ⲦⲞⲞⲨⲈ ⲘⲎ ⲀⲦⲈⲦⲚϢⲰⲰⲦ ⲖⲖⲀⲀⲨ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ. ⲀⲖⲖⲀ ⲦⲈⲚⲞⲨ ⲠⲈⲦⲈ ⲞⲨⲚⲦϤ ⲦⲰⲰⲘⲈ ⲘⲀⲢⲈϤϤⲒ ϨⲞⲘⲞⲒⲰⲤ ⲠⲈⲦⲈ ⲞⲨⲚⲦϤ ⲞⲨⲠⲎⲢⲀ ⲀⲨⲰ ⲠⲈⲦ ⲈⲘⲘⲚⲦⲀϤ. ⲘⲀⲢⲈ ϤϮ ⲦⲈϤϢⲦⲎⲚ ⲈⲂⲞⲖ ⲚϤⲦⲈⲨ ⲞⲨⲤⲎϤⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲀⲒ ⲈⲦⲤⲎϨ ⲈⲦⲂⲎⲎⲦ ϨⲀⲠⲤ ⲈⲦⲢⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϨⲎⲦ ϪⲈ ⲀⲨⲞⲠⲦ ⲚⲘⲚⲚⲀⲚⲞⲘⲞⲤ. ⲔⲀⲒⲄⲀⲢ ⲀⲠⲈⲦⲎⲠ ⲈⲢⲞⲒ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲒⲤ ⲤⲎϤⲈ ⲤⲚⲦⲈ ⲘⲠⲈⲒⲘⲀ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲤⲈⲢⲰϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀϤⲂⲰⲔ ⲔⲀⲦⲀ ⲠⲈϤⲤⲰⲚⲦ ⲈⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲒⲦ ⲀⲨⲞⲨⲀϨⲞⲨ ⲆⲈ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈϪⲘ ⲠⲘⲀ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϢⲖⲎⲖ ⲈⲦⲘⲦⲢⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲈ ⲘⲘⲞⲞⲨ ⲚⲀⲠⲚⲞⲨϪⲈ ⲚⲞⲨⲰⲚⲈ ⲀϤⲔⲖϪ ⲚⲈϤⲠⲀⲦ ");
INSERT INTO copshc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ⲈϢϪⲈ ⲔⲞⲨⲰϢ ⲘⲀⲢⲈ ⲠⲈⲒⲀⲠⲞⲦ ⲤⲀⲀⲦ ⲠⲖⲎⲚ ⲘⲀⲢⲈ ⲠⲈⲔⲞⲨⲰϢ ϢⲰⲠⲈ ⲘⲠⲰⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","— ");
INSERT INTO copshc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","— ");
INSERT INTO copshc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲈϤϢⲖⲎⲖ ⲀϤⲈⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲚⲔⲞⲦⲔ ⲈⲂⲞⲖ ⲚⲦⲖⲨⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲔⲞⲦⲔ ⲦⲰⲞⲨⲚ ϢⲖⲎⲖ ϪⲈ ⲚⲚⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ⲈⲦⲒ ⲆⲈ ⲈϤϢⲀϪⲈ ⲈⲒⲤ ⲞⲨⲘⲎⲎϢⲈ ⲀϤⲈⲒ ⲈⲢⲈ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲒⲞⲨⲆⲀⲤ ⲈⲨⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲠⲈ ⲈϤⲘⲞⲞϢⲈ ϨⲎⲦⲞⲨ. ⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲒⲎⲤⲞⲨⲤ ⲈϮⲠⲒ ⲈⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ. ⲒⲞⲨⲆⲀ ϨⲚ ⲞⲨⲠⲒ ⲈⲔⲚⲀϮⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ⲀⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈⲦⲘⲠⲈϤⲔⲰⲦⲈ ⲈⲚⲈⲦⲚⲀϢⲰⲠⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ. ⲠϪⲞⲈⲒⲤ ⲦⲀⲢⲚϨⲒⲞⲨⲈ ⲚⲦⲤⲎϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ⲀⲨⲰ ⲀⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲢⲰϨⲦ ⲘⲠϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤϤⲒ ⲠⲈϤⲘⲀⲀϪⲈ ⲈⲂⲞⲖ ⲚⲞⲨⲚⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϬⲰ ⲦⲈⲚⲞⲨ. ⲀϤϪⲰϨ ⲆⲈ ⲈⲠⲈϤⲘⲀⲀϪⲈ ⲀϤⲦⲀⲖϬ ⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲦⲚⲎⲨ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲚⲘ ⲚⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲘⲠⲈⲢⲠⲈ ⲚⲘ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ϪⲈ ⲈϢϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲂⲞⲖ ⲚⲤⲀⲞⲨⲰϪ ⲚⲘ ⲚⲈⲦⲚⲤⲎϤⲈ ⲚⲘ ⲚⲈⲦⲚϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ⲘⲘⲎⲚⲈ ⲈⲒϨⲘ ⲠⲈⲢⲠⲈ ⲘⲠⲈⲦⲚⲚ ⲚⲈⲦⲚϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ. ⲀⲖⲖⲀ ⲦⲀⲒ ⲦⲈ ⲦⲈⲦⲚⲞⲨⲚⲞⲨ ⲚⲘ ⲦⲈⲦⲚⲈⲜⲞⲨⲤⲒⲀ ⲠⲔⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨⲚⲦϤ ⲀⲨϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈϤⲞⲨⲎϨ ⲚⲤⲰϤ ⲘⲠⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ⲚⲦⲈⲢⲈⲨϪⲈⲢⲈⲨ ϢⲀϨ ⲆⲈ ⲈⲢⲞⲞⲨ ⲚⲦⲘⲎⲦⲈ ⲚⲦⲀⲨⲖⲎ ⲀⲨϨⲘⲞⲞⲤ ⲀⲠⲈⲦⲢⲞⲤ ϨⲘ ⲞⲞⲤ ⲚⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ⲚⲦⲈⲢⲈⲨϨⲘϨⲀⲖ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞϤ ⲈϤϨⲘⲞⲞⲤ ϨⲀⲦⲚ ⲠⲔⲰϨⲦ ⲀⲤⲒⲰⲢⲘ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲠⲈϪⲀⲤ ϪⲈ. ⲚⲈⲢⲈ ⲠⲈⲒⲔⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲀⲢⲚⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲘⲞϤ ⲦⲈⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ⲘⲚⲚⲤⲀ ⲞⲨⲔⲞⲨⲒ ⲆⲈ ⲀⲔⲈⲨⲀ ⲚⲀⲨ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ϪⲈ. ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲚⲦⲔ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠⲢⲰⲘⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲀⲞⲨⲚⲞⲨ ⲞⲨⲒⲚⲈ. ⲀⲔⲈⲨⲀ ⲦⲰⲔ ⲈϨⲞⲨⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲚ ⲞⲨⲘⲈ ⲚⲈⲢⲈ ⲠⲀⲒ ⲚⲘⲘⲀϤ ⲠⲈ. ⲔⲀⲒ ⲄⲀⲢ ⲞⲨⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠⲢⲰⲘⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲔϪⲈ ⲞⲨ. ⲀⲨⲰ ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲒ ⲈϤϢⲀϪⲈ ⲀⲠⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ⲀⲠϪⲞⲈⲒⲤ ⲆⲈ ⲔⲞⲦϤ ⲀϤϬⲰϢⲦ ⲈⲠⲈⲦⲢⲞⲤ ⲀⲠⲈⲦⲢⲞⲤ ⲢⲠⲘⲈⲨⲈ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲚⲐⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ϪⲈ ⲈⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲘⲠⲞⲞⲨ. ⲔⲚⲀⲀⲠⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲘⲦ ⲤⲰⲰⲠ. ");
INSERT INTO copshc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲀϤⲢⲒⲘⲈ ϨⲚ ⲞⲨⲤⲒϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ⲢⲢⲰⲘⲈ ⲆⲈ ⲈⲦⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲈⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ⲀⲨϨⲂⲤ ⲠⲈϤϨⲞ ⲀⲨϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲚⲀⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲢⲀϨⲦⲔ ");
INSERT INTO copshc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲚⲔⲈⲘⲎⲎϢⲈ ⲚϢⲀϪⲈ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲈⲨϪⲒⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ⲚⲦⲈⲢⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲖⲀⲞⲤ ⲚⲘ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲀⲨϪⲒⲦϤ ⲈⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀϪⲒⲤ ⲚⲀⲚ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲈⲒϢⲀⲚϪⲞⲞⲤ ⲚⲎⲦⲚ ⲚⲚⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ⲈϢⲰⲠⲈ ⲆⲈ ⲞⲚ ⲈⲒϢⲀⲚϪⲚⲞⲨⲦⲚ ⲚⲚⲈⲦⲚⲞⲨⲰϢⲂ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀϢⲰⲠⲈ ⲈϤϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲚⲦϬⲞⲘ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ⲠⲈϪⲀⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲈⲚⲢⲬⲢⲒⲀ ϬⲈ ⲘⲘⲚⲦⲢⲈ ⲈⲢ ⲞⲨ ⲀⲚⲞⲚ ⲄⲀⲢ ⲀⲚⲤⲰⲦⲘ ⲈⲂⲞⲖ ϨⲚ ⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ⲀⲨⲰ ⲀⲨⲦⲰⲞⲨⲚ ⲚϬⲒ ⲠⲘⲎⲎⲎϢⲈ ⲦⲎⲢϤ ⲀⲨⲚⲦϤ ⲈⲢⲀⲦϤ ⲘⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ⲀⲨⲀⲢⲬⲒ ⲆⲈ ⲚⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϨⲈ ⲈⲠⲀⲒ ⲈϤϢⲦⲞⲢⲦⲢ ⲘⲠⲈⲚϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲈϤⲔⲰⲖⲨ ⲈϮϢⲰⲘ ⲘⲠⲢⲢⲞ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄ ⲠⲢⲢⲞ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ⲀⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ϪⲚⲞⲨϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲘⲠⲘⲎⲎϢⲈ ϪⲈ ⲚϮϬⲚ ⲖⲀⲀⲨ ⲀⲚ ⲚⲚⲞⲂⲈ ϨⲘ ⲠⲈⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲦⲰⲔ ⲈϨⲞⲨⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤϢⲦⲞⲢⲦⲢ ⲘⲠⲖⲀⲞⲤ ⲈϤϮⲤⲂⲰ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲦⲎⲢⲤ. ⲈⲀϤⲀⲢⲬⲒ ϪⲒⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ϢⲀ ϨⲢⲀⲒ ⲈⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ϪⲈ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀϤϢⲒⲚⲈ ϪⲈ ⲞⲨⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲠⲈ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲒⲘⲈ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲚϨⲎⲢⲰⲆⲎⲤ ⲠⲈ ⲀϤϪⲞⲞⲨϤ ϢⲀ ϨⲎⲢⲰⲆⲎⲤ ⲈϤϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲰⲰϤ ϨⲚ ⲚⲈⲒϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ⲚⲦⲈⲢⲈ ϨⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲢⲀϢⲈ ⲈⲘⲀⲦⲈ ⲚⲈϤⲞⲨⲈϢ ⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲞϤ ⲠⲈ ϨⲒⲦⲚ ϨⲈⲚⲚⲞϬ ⲚⲞⲨⲞⲒϢ ϪⲈ ⲚⲈϤⲤⲰⲦⲘ ⲈⲦⲂⲎⲎ ⲦϤ ⲀⲨⲰ ⲚⲈϤϨⲈⲖⲠⲒⲌⲈ ⲈⲚⲀⲨ ⲈⲨⲘⲀⲈⲒⲚ ⲈϤⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ⲀϤϪⲚⲞⲨϤ ⲆⲈ ϨⲚ ϨⲈⲚⲘⲎⲎϢⲈ ⲚϢⲀϪⲈ ⲚⲦⲞϤ ⲆⲈ ⲘⲠϤⲞⲨⲰϢⲂⲈϤ ⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ⲚⲈⲨⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ⲠⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈⲨⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ⲀϨⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲤⲞϢϤ ⲘⲚ ⲚⲈϤⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲀⲨⲰ ⲀⲨⲤⲰⲂⲈ ⲘⲘⲞϤ ⲀⲨϬⲞⲞⲖⲈϤ ⲚⲞⲨϨⲂⲤⲰ ⲈⲤⲞⲨⲞⲂⲈϢ ⲀⲨϪⲞⲞⲨϤ ⲘⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ⲀⲨⲢϢⲂⲎⲢ ⲈⲚⲈⲨⲈⲢⲎⲞⲨ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲚⲘ ⲠⲒⲖⲀⲦⲞⲤ. ⲚⲈⲨϢⲞⲞⲠ ⲄⲀⲢ ⲠⲈ ϨⲚ ⲞⲨⲘⲚⲦϪⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ⲀⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲘⲞⲨⲦⲈ ⲈⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲘⲚⲚⲀⲢⲬⲰⲚ ⲚⲘ ⲠⲖⲀⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ. ⲀⲦⲈⲦⲚⲒⲚⲈ ⲚⲀⲒ ⲘⲠⲈⲒⲢⲰⲘⲈ ϨⲰⲤ ⲈϤϢⲦⲞⲢⲦⲢ ⲘⲠⲖⲀⲞⲤ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲆⲈ ⲀⲒⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲒϨⲈ ⲈⲖⲀⲀⲨ ⲚⲚⲞⲂⲈ ⲚϨⲎⲦϤ ⲚⲀⲒ ⲈⲦⲈⲦⲚⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ⲀⲖⲖⲀ ⲘⲠⲈ ⲠⲔⲈϨⲎⲢⲰⲆⲎⲤ ϨⲈ ⲈⲞⲨⲞⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲀϤⲦⲚⲚⲞⲞⲨϤ ⲄⲀⲢ ⲚⲀⲚ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲘⲠϤⲢ ⲖⲀⲀⲨ ⲈϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ϮⲚⲀⲠⲀⲒⲆⲈⲨⲈ ϬⲈ ⲘⲘⲞϤ ⲦⲀⲔⲀⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","— ");
INSERT INTO copshc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ⲀⲨϪⲒϢⲔⲀⲔ ⲆⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲒ ⲠⲀⲒ. ⲔⲰ ⲚⲀⲚ ⲈⲂⲞⲖ ⲂⲂⲀⲢⲀⲂⲂⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ⲠⲀⲒ ⲈⲚⲦⲀⲨⲚⲞϪϤ ⲈⲠⲈϢⲦⲈⲔⲞ ⲈⲦⲂⲈ ⲞⲨⲤⲦⲀⲤⲒⲤ ⲈⲀⲤϢⲰⲠⲈ ϨⲚ ⲦⲠⲞⲖⲈⲒⲤ ⲚⲘⲞⲨϨⲰⲦⲂ. ");
INSERT INTO copshc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ⲀⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲞⲚ ϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤⲞⲨⲰϢ ⲈⲔⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲘⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚⲤⲞⲠ. ϪⲈ ⲞⲨ ⲄⲀⲢ ⲠⲈ ⲠⲠⲈⲐⲞⲞⲨ ⲈⲚⲦⲀ ⲠⲀⲒ ⲀⲀϤ ⲘⲠⲒϨⲈ ⲈⲖⲀⲀⲨ ⲘⲘⲞⲨ ⲈⲢⲞϤ. ϮⲚⲀⲠⲀⲒⲆⲈⲨⲈ ϬⲈ ⲘⲘⲞϤ ⲦⲀⲔⲀⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲘⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ϨⲈⲚⲚⲞϬ ⲚⲤⲘⲎ ⲈⲨⲀⲒⲦⲒ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ⲀⲨⲰ ⲚⲈⲢⲈ ⲚⲈⲨⲤⲘⲎ ϬⲘϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ⲀⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲔⲢⲒⲚⲈ ⲈⲈⲒⲢⲈ ⲘⲠⲈⲨⲀⲒⲦⲎⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ⲀϤⲔⲰ ⲈⲂⲞⲖ ⲘⲠⲈⲚⲦⲀⲨⲚⲞϪϤ ⲈⲠⲈϢⲦⲈⲔⲞ ⲈⲦⲂⲈ ⲦⲈⲤⲦⲀⲤⲒⲤ ⲚⲘ ⲪⲰⲦⲂ ⲠⲈⲦⲈ ⲚⲈⲨⲀⲒⲦⲒ ⲘⲘⲞϤ. ⲀϤϮ ⲆⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲨⲞⲨⲰϢ ");
INSERT INTO copshc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ⲀⲨⲰ ⲈⲨϪⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲀⲨⲀⲘⲀϨⲦⲈ ⲚⲞⲨⲔⲨⲢⲎⲚⲀⲒⲞⲤ ϪⲈ ⲤⲒⲘⲰⲚ. ⲈϤⲚⲎⲞⲨ ⲈϨⲢⲀⲒ ϨⲚ ⲦⲤⲰϢⲈ ⲀⲨⲦⲀⲖⲈ ⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲈϪⲰϤ ⲈϤⲒⲦϤ ϨⲒ ⲠⲀϨⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ⲚⲈⲢⲈ ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲘⲠⲖⲀⲞⲤ ⲞⲨⲎϨ ⲚⲤⲰϤ ⲘⲚ ⲚⲈϨⲒⲞⲘⲈ ⲚⲀⲒ ⲈⲚⲈⲨⲚⲈϨⲠⲈ ⲠⲈ ⲀⲨⲰ ⲚⲈⲨⲦⲞⲒⲦ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ⲀⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲔⲞⲦϤ ⲈⲠⲀϨⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚϢⲈⲈⲢⲈ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲠⲢⲢⲒⲘⲈ ⲚⲀⲒ. ⲠⲖⲎⲚ ⲢⲒⲘⲈ ⲚⲦⲞϤ ⲚⲎⲦⲚ ⲘⲚ ⲚⲈⲦⲚϢⲎⲢⲈ ");
INSERT INTO copshc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲞⲨⲚ ϨⲈⲚϨⲞⲞⲨ ⲚⲎⲞⲨ ⲚⲤⲈϪⲞⲞⲤ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲀϬ ⲢⲎⲚ. ⲚⲘ ⲚϨⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲘⲒⲤⲈ ⲘⲚ ⲚⲈⲔⲒⲂⲈ ⲈⲦⲈ ⲘⲠⲞⲨⲦⲤⲚⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲀⲢⲬⲒ ⲚϪⲞⲞⲤ ⲚⲚⲦⲞⲞⲨ ϪⲈ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲚ ⲀⲨⲰ ⲚⲤⲒⲂⲈⲦ ϪⲈ ϨⲞⲂⲤⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ϪⲈ ⲈϢϪⲈ ⲤⲈⲈⲒⲢⲈ ⲚⲚⲀⲒ ϨⲘ ⲠϢⲈ ⲈⲦⲞⲨⲰⲦ ⲈⲈⲒⲈ ⲞⲨ ⲠⲈⲦⲚⲀϢⲰⲠⲈ ϨⲘ ⲠⲈⲦϢⲞⲨⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ⲀⲨⲚ ⲔⲈⲤⲞⲞⲚⲈ ⲆⲈ ⲤⲚⲀⲨ ⲈⲂⲞⲖ ⲈⲘⲞⲞⲨⲦⲞⲨ ⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈϪⲘ ⲠⲘⲀ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲔⲢⲀⲚⲒⲞⲚ ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚⲘ ⲘⲀⲨ ⲚⲘ ⲠⲔⲈⲤⲞⲞⲚⲈ ⲤⲚⲀⲨ. ⲞⲨⲀ ⲘⲈⲚ ϨⲒ ⲞⲨⲚⲀⲘ ⲘⲘⲞϤ. ⲞⲨⲀ ⲆⲈ ϨⲒϨⲂⲞⲨⲢ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ⲀⲨⲠⲰϢ ⲚⲚⲈϤϨⲞⲒⲦⲈ ⲀⲨⲰ ⲀⲨⲚⲈϪ ⲔⲖⲎⲢⲞⲤ ⲈϪⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ⲀⲨⲰ ⲚⲈⲢⲈ ⲠⲖⲀⲞⲤ ⲠⲈ ⲀϨⲈⲢⲀⲦϤ ⲈⲨⲚⲀⲨ ⲠⲈ ⲀⲚⲔⲈⲀⲢⲬⲰⲚ ⲆⲈ ⲔⲰⲘϢ ⲚⲤⲰϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤⲦⲞⲨϪⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲘⲀⲢⲈϤⲦⲞⲨϪⲞϤ ⲈϢϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲤⲰⲦⲠ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ⲀⲚⲔⲈⲘⲀⲦⲞⲒ ⲆⲈ ⲤⲰⲂⲈ ⲚⲤⲰϤ ⲈⲨϮ ⲘⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲚⲘ ⲞⲨϨⲘϪ ");
INSERT INTO copshc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲀⲦⲞⲨϪⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ⲚⲈⲨⲚⲞⲨⲈⲠⲒⲄⲢⲀⲪⲎ ⲆⲈ ϨⲒϪⲰϤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ⲚⲈⲨⲚ ⲞⲨⲀ ⲆⲈ ⲚⲚⲤⲞⲞⲚⲈ ⲈⲦⲀϢⲈ ϪⲒⲞⲨⲀ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲰⲤ ϪⲈ. ⲘⲎ ⲚⲦⲞⲔ ⲀⲚ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲘⲀⲦⲞⲨϪⲞⲔ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ⲀⲠⲔⲈⲞⲨⲀ ⲆⲈ ⲞⲨⲰϢⲂ ⲈϤⲀⲒⲠⲒⲦⲒⲘⲀ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲚⲔⲢϨⲞⲦⲈ ⲚⲦⲞⲔ ⲀⲚ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲈⲚϢⲞⲞⲠ ⲘⲠⲈⲒⲔⲢⲒⲘⲀ ⲞⲨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ⲀⲚⲞⲚ ⲄⲀⲢ ⲆⲒⲔⲀⲒⲰⲤ ⲠⲈⲘⲠϢⲀ ⲄⲀⲢ ⲚⲚⲈⲚⲦⲀⲚⲀⲀⲨ ⲠⲈⲦⲚⲚⲀϪⲒ ⲘⲘⲞϤ ⲠⲀⲒ ⲆⲈ ⲘⲠϤⲢ ⲖⲀⲀⲨ ⲚϨⲰⲂ ⲈⲘⲈϢϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ⲀⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲢⲒⲠⲀⲘⲈⲨⲈ ⲠϪⲞⲈⲒⲤ ⲈⲔϢⲀⲚⲈⲒ ϨⲚ ⲦⲈⲔⲘⲚⲦⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ. ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲘⲠⲞⲞⲨ ϪⲈ ⲔⲚⲀϢⲰⲠⲈ ⲚⲘⲘⲀⲒ ϨⲘ ⲠⲠⲀⲢⲀⲆⲈⲒⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ⲚⲈ ⲠⲚⲀⲨ ⲆⲈ ⲚϪⲠ ⲠⲤⲞ ⲠⲈ. ⲀⲨⲔⲀⲔⲈ ϢⲰⲠⲈ ⲈϪⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ ϢⲀ ϪⲠ ⲮⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ⲈⲢⲈ ⲠⲢⲎ ⲆⲈ ⲚⲀϨⲰⲦⲠ. ⲀⲠⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲘⲠⲈⲢⲠⲈ ⲠⲰϨ ϨⲒ ⲦⲈϤⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ⲀⲒⲎⲤⲞⲨⲤ ϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ϮϮ ⲘⲠⲀⲠⲚⲈⲨⲘⲀ ⲈⲚⲈⲔϬⲒϪ. ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲀϤⲔⲀ ⲠⲦⲎⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ⲀⲪⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲀϤϮ ⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲚⲦⲰⲤ ⲚⲈ ⲞⲨⲆⲒⲔⲀⲒⲞⲤ ⲠⲈ ⲠⲈⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ⲀⲨⲰ ⲘⲘⲎⲎϢⲈ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲚⲀⲨ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲚⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲀⲨϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈⲚⲈⲨⲘⲈⲤⲐⲎⲦ ⲀⲨⲰ ⲀⲨⲔⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ⲚⲈⲢⲈ ⲚⲈⲦⲤⲞⲞⲨⲚ ⲆⲈ ⲘⲘⲞϤ ⲦⲎⲢⲞⲨ ⲠⲈ ⲀϨⲈⲢⲀⲦⲞⲨ ⲘⲠⲞⲨⲈ ⲘⲚ ⲚⲈϨⲒⲞⲘⲈ ⲈⲚⲈⲨⲞⲨⲎϨ ⲚⲤⲰϤ ϪⲒⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲨⲚⲀⲨ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ⲈⲒⲤ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ ⲈⲨⲂⲞⲨⲖⲈⲨⲦⲎⲤ ⲠⲈ ⲢⲢⲰⲘⲈ ⲚⲀⲄⲀⲐⲞⲤ ⲚⲆⲒⲔⲀⲒⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ⲠⲀⲒ ⲈⲚϤϤⲒ ⲀⲚ ⲚⲘ ⲠⲈⲨϢⲞϪⲚⲈ ⲀⲨⲰ ⲠⲈⲨϨⲰⲂ ⲈⲨⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲀⲢⲒⲘⲀⲐⲀⲒⲀ ⲦⲠⲞⲖⲒⲤ ⲚⲒⲞⲨⲆⲀⲒ. ⲠⲀⲒ ⲈⲚⲈϤϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦⲤ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ⲠⲀⲒ ϬⲈ ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲈⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲀⲒⲦⲒ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ⲀϤⲚⲦϤ ⲈⲠⲈⲤⲎⲦ ⲀϤⲔⲞⲞⲤϤ ϨⲚ ⲞⲨⲤⲒⲚⲆⲰⲚ ⲀϤⲔⲀⲀϤ ϨⲚ ⲞⲨⲘϨⲀⲞⲨ ⲈⲀⲨⲔⲈϨⲔⲰϨϤ ⲈⲘⲠⲞⲨⲔⲀ ⲖⲀⲀⲨ ⲚϨⲎⲦϤ ⲈⲚⲈϨ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲔⲀⲀϤ ⲆⲈ ⲀⲨⲞⲨⲈϨ ⲞⲨⲰⲚⲈ ⲈⲢⲚ ⲦⲦⲀⲠⲢⲞ ⲘⲠⲈⲘϨⲀⲞⲨ. ⲠⲀⲒ ⲈⲚⲈ ⲘⲞⲄⲒⲤ ⲈⲚⲈⲢⲈ ϢϪⲞⲨⲰⲦ ⲢⲢⲰⲘⲈ ⲚⲀϢ ⲤⲔⲢⲔⲰⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ⲚⲈ ⲠⲈϨⲞⲞⲨ ⲆⲈ ⲠⲈ ⲚⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲈϨⲦⲞⲞⲨⲈ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ⲀⲚⲈϨⲒⲞⲘⲈ ⲆⲈ ⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚⲀⲈⲒ ⲈⲚⲦⲀⲨⲈⲒ ⲚⲘⲘⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈⲨⲚⲀⲨ ⲈⲠⲈⲘϨⲀⲞⲨ ⲚⲘ ⲐⲈ ⲈⲚⲦⲀϤⲔⲀ ⲠⲈϤⲤⲰⲘⲀ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲀⲨⲤⲞⲂⲦⲈ ⲚϨⲈⲚϨⲎⲚⲈ ⲚⲘ ϨⲈⲚⲤⲦⲞ. ⲀⲨⲰ ⲀⲨϬⲰ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲔⲀⲦⲀ ⲦⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ⲚⲤⲞⲨⲀ ⲆⲈ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈϨⲦⲞⲞⲨⲈ ⲚϢⲰⲢⲠ ⲀⲨⲈⲒ ⲈⲠⲈⲘϨⲀⲞⲨ ⲈⲢⲈⲚ ϨⲎⲚⲈ ⲚⲦⲞⲞⲦⲞⲨ ⲈⲚⲦⲀⲨⲤⲂⲦⲰⲦⲞⲨ ⲚⲘ ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲘⲘⲀⲨ. ⲚⲈⲨⲘⲈⲨⲈ ⲆⲈ ⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲚⲒⲘ ⲀⲢⲀ ⲠⲈⲦⲚⲀⲤⲔⲞⲢⲔⲢ ⲚⲀⲚ ⲘⲠⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲀⲨϨⲈ ⲈⲠⲰⲚⲈ ⲈⲀⲨⲤⲔⲢⲔⲰⲢϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲘϨⲀⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ⲀⲨⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲘⲠⲞⲨϨⲈ ⲈⲠⲤⲰⲘⲀ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲨϢⲦⲞⲢⲦⲢ ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲒⲤ ⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲀⲨⲈⲒ ⲈϪⲰⲞⲨ ϨⲚ ϨⲈⲚϨⲂⲤⲰ ⲈⲨⲢⲞⲨⲞⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ⲚⲦⲈⲢⲞⲨⲢϨⲞⲦⲈ ⲆⲈ ⲀⲨⲠⲀϨⲦ ϪⲰⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈϪⲘ ⲠⲔⲀϨ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ. ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲀ ⲠⲈⲦⲞⲚϨ ⲘⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ⲚϤⲘⲠⲈⲒⲘⲀ ⲀⲚ ⲀⲖⲖⲀ ⲀϤⲦⲰⲞⲨⲚ ⲀⲢⲒⲠⲘⲈⲨⲈ ⲚⲐⲈ ⲈⲚⲦⲀϤϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ϪⲒⲚ ⲈϤϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲨⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲞⲞⲦⲞⲨ ⲚϨⲈⲚⲢⲰⲘⲈ ⲢⲢⲈϤⲢⲚⲞⲂⲈ ⲚⲤⲈⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ⲀⲨⲰ ⲀⲨⲢⲠⲘⲈⲈⲨⲈ ⲚⲚⲈϤϢⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ⲀⲨⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲘϨⲀⲞⲨ ⲀⲨϪⲈ ⲚⲀⲒ ⲈⲠⲘⲚⲦⲞⲨⲈ ⲚⲘ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ⲚⲈ ⲘⲀⲢⲒⲀ ⲆⲈ ⲦⲈ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲚⲘ ⲒⲰϨⲀⲚⲚⲀ ⲚⲘ ⲘⲀⲢⲒⲀ ⲦⲀ ⲒⲀⲔⲰⲂⲞⲤ ⲀⲨⲰ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲈⲦⲚⲘⲘⲀⲨ. ⲚⲈⲨϪⲰ ⲆⲈ ⲚⲚⲀⲒ ⲠⲈ ⲈⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ⲀⲨⲢⲐⲈ ⲚⲚⲒϨⲰⲂ ⲚⲤⲰⲂⲈ ⲘⲠⲈⲨⲘⲦⲞ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲒϢⲀϪⲈ ⲀⲨⲰ ⲘⲠⲞⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ⲀⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲦⲰⲞⲨⲚ ⲀϤⲂⲰⲔ ⲈⲠⲈⲘϨⲀⲞⲨ ⲀϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲀϤⲚⲀⲨ ⲈⲚⲈϨⲂⲰⲰⲤ ⲚⲤⲀ ⲞⲨⲤⲀ ⲀϤⲂⲰⲔ ⲆⲈ ⲈϤⲢⲘⲞⲒϨⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲘⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ⲀⲨⲰ ⲈⲒⲤ ⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲈⲨⲘⲞⲞϢⲈ ⲈⲨϮⲘⲈ ⲘⲠⲈⲒϨⲞⲞⲨ ⲚⲞⲨⲰⲦ ⲈϤⲞⲨⲎⲞⲨ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲤⲈ ⲚⲤⲦⲀⲆⲒⲞⲚ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲘⲘⲀⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎ ⲞⲨ ⲈⲦⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲚⲦⲀⲨϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈⲨϢⲀϪⲈ ⲀⲨⲰ ⲚⲤⲈⲤⲨⲚⲌⲎⲦⲒ ⲀⲒⲎⲤⲞⲨⲤ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ ⲀϤⲘⲞⲞϢⲈ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ⲚⲈⲨⲀⲘⲀϨⲦⲈ ⲆⲈ ⲚⲚⲈⲨⲂⲀⲖ ⲈⲦⲘⲤⲞⲨⲰⲚϤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨ ⲚⲈ ⲚⲈⲒϢⲀϪⲈ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲞⲨ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲞⲨ ⲈⲦⲈⲦⲚⲘⲞⲞϢⲈ. ⲀⲨⲰ ⲀⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲈⲨⲞⲔⲘ. ");
INSERT INTO copshc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ⲀⲞⲨⲀ ⲆⲈ ⲚϨⲎⲦⲞⲨ ⲞⲨⲰϢⲂ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲔⲖⲈⲞⲠⲀⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ. ⲚⲦⲞⲔ ⲘⲀⲨⲀⲀⲔ ⲈⲔⲞ ⲚϢⲘⲘⲞ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲘⲠⲔⲒⲘⲈ ⲈⲚⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲚϨⲎⲦⲤ ⲚⲚⲈⲒϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲀϢ ⲚⲈ ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲀⲒ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲆⲨⲚⲀⲦⲞⲤ ϨⲘ ⲪⲰⲂ ⲚⲘ ⲠϢⲀϪⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲘ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ");
INSERT INTO copshc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ⲈⲀⲨⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲘ ⲚⲚⲀⲢⲬⲰⲚ ⲈⲨϨⲀⲠ ⲚⲦⲈ ⲠⲘⲞⲨ ⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ⲀⲚⲞⲚ ⲆⲈ ⲈⲚϨⲈⲖⲠⲒⲌⲈ ϪⲈ ⲚⲦⲞϤ ⲠⲈⲦⲚⲀⲤⲰⲦⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲀⲖⲖⲀ ⲂⲂⲖⲖⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲠⲞⲞⲨ ϪⲒⲚⲦⲀ ⲚⲀⲒ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ⲀϨⲈⲚⲔⲈⲤϨⲒⲘⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲚ ⲠⲈϢⲤ ⲠⲈⲚϨⲎⲦ ⲈⲀⲨⲂⲰⲔ ⲈϨⲦⲞⲞⲨⲈ ⲈⲠⲈⲘϨⲀⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ⲘⲠⲞⲨϨⲈ ⲈⲠⲈϤⲤⲰⲘⲀ ⲀⲨⲈⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈⲨⲞⲠⲦⲀⲤⲒⲀ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲚⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ϪⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀⲨⲰ ⲀϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲚⲘⲘⲀⲚ ⲂⲰⲔ ⲈⲠⲈⲘϨⲀⲞⲨ ⲀⲨϨⲈ ⲈⲢⲞϤ ϨⲒⲚⲀⲒ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀ ⲚⲈϨⲒⲞⲘⲈ ϪⲞⲞⲤ. ⲚⲦⲞϤ ⲆⲈ ⲘⲠⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ");
INSERT INTO copshc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ. Ⲱ ⲚⲀⲚⲞⲎⲦⲞⲤ ⲀⲨⲰ ⲚⲈⲦⲞⲤⲔ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲈⲠⲒⲤⲦⲈⲨⲈ ⲈϨⲰⲂ ⲚⲒⲘ ⲈⲚⲦⲀ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ⲘⲎ ϨⲀⲠⲤ ⲀⲚ ⲈⲦⲢⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϢⲈⲠⲚⲀⲒ ⲀⲨⲰ ⲚϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈϤⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ⲀϤⲀⲢⲬⲒ ⲆⲈ ϪⲒⲚ ⲘⲰⲨⲤⲎⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲈⲂⲰⲖ ⲈⲢⲞⲞⲨ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ⲀⲨⲰ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠϮⲘⲈ ⲈⲦⲞⲨⲚⲀⲂⲰⲔ ⲈⲢⲞϤ. ⲚⲦⲞϤ ⲆⲈ ⲀϤϨⲒⲦⲞⲞⲦϤ ⲈⲞⲨⲈ ⲘⲘⲞⲞⲨ ⲈϤⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲰ ⲚⲘⲘⲀⲚ ϪⲈ ⲠⲚⲀⲨ ⲢⲢⲞⲨϨⲈ ⲠⲈ ⲀⲨⲰ ⲀⲠⲈϨⲞⲞⲨ ⲢⲒⲔⲈ. ⲀϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲀϤϬⲰ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤⲚⲞϪϤ ⲚⲘⲘⲀⲨ ⲀϤϪⲒ ⲚⲞⲨⲞⲒⲔ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ. ⲀϤⲠⲞϢϤ ⲀϤⲦⲀⲀϤ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲚⲈⲨⲂⲀⲖ ⲞⲨⲰⲚ ⲀⲨⲤⲞⲨⲰⲚϤ. ⲚⲦⲞϤ ⲆⲈ ⲀϤϨⲞⲠϤ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ. ⲈⲒⲈ ⲚⲈⲢⲈ ⲠⲈⲚϨⲎⲦ ϨⲞⲂⲤ ⲈⲢⲞⲚ ⲀⲚ ⲠⲈ ⲚⲐⲈ ⲈⲚⲦⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲚ ϨⲒ ⲦⲈϨⲒⲎ ⲈϤⲂⲰⲖ ⲈⲢⲞⲚ ⲚⲚⲈⲄⲢⲀⲪⲎ ");
INSERT INTO copshc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ⲀⲨⲰ ⲀⲨⲦⲰⲞⲨⲚ ⲈⲨⲖⲨⲠⲒ. ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨϨⲈ ⲈⲠⲘⲚⲦⲞⲨⲈ ⲈⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ. ⲞⲚⲦⲰⲤ ⲀⲠϪⲞⲈⲒⲤ ⲦⲰⲞⲨⲚ ⲀⲨⲰ ⲀϤⲞⲨⲰⲚϨ ⲈⲤⲒⲘⲰⲚ ");
INSERT INTO copshc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ⲀⲨϪⲰ ϨⲰⲞⲨ ⲚⲚⲈⲦⲀⲨϢⲰⲠⲈ ϨⲒ ⲦⲈϨⲒⲎ. ⲀⲨⲰ ⲚⲐⲈ ⲈⲚⲦⲀϤⲞⲨⲰⲚϨ ⲈⲢⲞⲞⲨ ϨⲘ ⲠⲠⲰϢ ⲘⲠⲞⲒⲔ. ");
INSERT INTO copshc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ⲈⲨϪⲰ ⲆⲈ ⲚⲚⲀⲒ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϮⲢⲎⲚⲎ ⲚⲎⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ⲚⲦⲈⲢⲞⲨϢⲦⲞⲢⲦⲢ ⲆⲈ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ⲈⲨⲘⲈⲨⲈ ϪⲈ ⲚⲈⲨⲚⲀⲨ ⲈⲨⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ. ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϢⲦⲢⲦⲰⲢ ⲀⲨⲰ ⲈⲦⲂⲈ ⲞⲨ ⲞⲨⲚ ϨⲈⲚⲘⲈⲨⲈ ⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲠⲈⲦⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ⲀⲚⲀⲨ ⲈⲚⲀϬⲒϪ ⲚⲘ ⲚⲀⲨⲈⲢⲎⲦⲈ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ϬⲞⲘϬⲘ ⲈⲢⲞⲒ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ϪⲈ ⲘⲘⲚⲦⲈ ⲠⲚⲈⲨⲘⲀ ⲔⲀⲤ ϨⲒ ⲤⲀⲢⲜ ⲔⲀⲦⲀⲐⲈ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲈⲨⲚ ⲞⲨⲞⲚ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲀⲨⲦⲞⲨⲞⲞⲨ ⲈⲚⲈϤϬⲒϪ ⲘⲚ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ⲈⲦⲒ ⲆⲈ ⲈⲨⲀⲠⲒⲤⲦⲒ ⲈⲂⲞⲖ ⲘⲠⲢⲀϢⲈ ⲀⲨⲰ ⲈⲨⲢϢⲠⲎⲢⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲖⲀⲀⲨ ⲚϬⲒ ⲚⲞⲨⲰⲘ ⲘⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨϢⲀⲀⲦⲈ ⲚⲦⲂⲦ ⲈⲤϬⲎϬ. ");
INSERT INTO copshc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ⲀϤϪⲒⲦⲤ ⲀϤⲞⲨⲞⲘⲤ ⲘⲠⲈⲨⲘⲦⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ. ⲚⲀⲒ ⲚⲈ ⲚⲀϢⲀϪⲈ ⲈⲚⲦⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲒⲚ ⲈⲒϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲚⲈⲦⲤⲎϨ ⲦⲎⲢⲞⲨ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲘ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲰ ⲚⲈⲮⲀⲖⲘⲞⲤ ⲈⲦⲂⲎⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ⲦⲞⲦⲈ ⲀϤⲞⲨⲰⲚ ⲘⲠⲈⲨϨⲎⲦ ⲈⲦⲢⲈⲨⲤⲞⲨⲰⲚϤ ⲀⲨⲰ ⲈⲦⲢⲈⲨⲒⲘⲈ ⲈⲚⲈⲄⲢⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲤⲎϨ ⲈⲦⲢⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲀⲤ ⲀⲨⲰ ⲚϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ⲚⲤⲈⲦⲀϢⲈⲞⲒϢ ⲚⲞⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲈϤⲢⲀⲚ ⲈⲨⲔⲀ ⲚⲞⲂⲈ ⲈⲂⲞⲖ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲦⲚⲀⲢⲬⲒ ϪⲒⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ⲚⲦⲰⲦⲚ ⲚⲈⲦⲞ ⲘⲘⲚⲦⲢⲈ ⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲦⲚⲚⲞⲞⲨ ⲘⲠⲈⲢⲎⲦ ⲘⲠⲒⲰⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲦⲚ. ⲚⲦⲰⲦⲚ ⲆⲈ ϨⲘ ⲞⲞⲤ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ ϢⲀⲚⲦⲈⲦⲚϮ ϨⲒⲰⲦ ⲦⲎⲞⲨⲦⲚ ⲚⲞⲨϬⲞⲘ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ⲀϤⲚⲦⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ϢⲀ ⲂⲎⲐⲀⲚⲒⲀ. ⲀϤϤⲒ ⲚⲈϤϬⲒϪ ⲈϨⲢⲀⲒ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲦⲢⲈϤⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲀϤⲞⲨⲈ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ⲀⲨⲞⲨⲰϢⲦ ϨⲰⲞⲨ ⲘⲘⲞϤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲚ ⲞⲨⲚⲞϬ ⲢⲢⲀϢⲈ ");
INSERT INTO copshc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ⲀⲨⲰ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ϨⲘ ⲠⲈⲢⲠⲈ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ ⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ϨⲚ ⲦⲈϨⲞⲨⲈⲒⲦⲈ ⲚⲈϤϢⲞⲞⲠ ⲚϬⲒ ⲠϢⲀϪⲈ ⲀⲨⲰ ⲠϢⲀϪⲈ ⲚⲈϤϢⲞⲞⲠ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲚⲈⲨⲚⲞⲨⲦⲈ ⲠⲈ ⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ⲠⲀⲒ ϨⲚ ⲦⲈϨⲞⲨⲈⲒⲦⲈ ⲚⲈϤϢⲞⲞⲠ ϨⲀⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ⲚⲦⲀⲠⲦⲎⲢϤ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ ⲀⲨⲰ ⲀϪⲚⲦϤ ⲘⲠⲈⲖⲀⲀⲨ ϢⲰⲠⲈ. ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲠⲈ ⲠⲰⲚϨ. ⲀⲨⲰ ⲠⲰⲚϨ ⲠⲈ ⲠⲞⲨⲞⲒⲚ ⲚⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ⲀⲨⲰ ⲠⲞⲨⲞⲒⲚ ϤⲢⲞⲨⲞⲒⲚ ϨⲘ ⲠⲔⲀⲔⲈ ⲀⲨⲰ ⲘⲠⲈ ⲠⲔⲀⲔⲈ ⲦⲀϨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ⲀϤϢⲰⲠⲈ ⲚϬⲒ ⲞⲨⲢⲰⲘⲈ ⲈⲀⲨⲦⲚⲚⲞⲞⲨϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ⲠⲀⲒ ⲀϤⲈⲒ ⲈⲨⲘⲚⲦⲘⲚⲦⲢⲈ ϪⲈ ⲈϤⲈⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲈ ⲠⲞⲨⲞⲈⲒⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ⲚⲈⲠ ⲈⲦⲘⲘⲀⲨ ⲀⲚ ⲠⲈ ⲠⲞⲨⲞⲒⲚ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲚⲦⲞϤ ⲈϤⲈⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲈ ⲠⲞⲨⲞⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ⲠⲞⲨⲞⲒⲚ ⲘⲘⲈⲈ ⲈⲦⲢⲞⲨⲞⲒⲚ ⲈⲢⲰⲘⲈ ⲚⲒⲘ ⲠⲈ ⲈϤⲚⲎⲨ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ⲚⲈϤϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲠⲈ ⲀⲨⲰ ⲚⲦⲀⲠⲔⲞⲤⲘⲞⲤ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ ⲀⲨⲰ ⲘⲠⲈⲠⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲰⲚϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ⲀϤⲒ ϢⲀⲚⲈⲦⲈⲚⲞⲨϤ ⲚⲈ ⲀⲨⲰ ⲘⲠⲈⲚⲈⲦⲈⲚⲞⲨϤ ⲚⲈ ϪⲒⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ⲚⲈⲚⲦⲀⲨϪⲒⲦϤ ⲆⲈ ⲀϤϮ ⲚⲀⲨ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲚϢⲎⲢⲈ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ⲚⲀⲒ ⲈⲚϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ⲚⲈ ⲚⲞⲨⲰϢ ⲚⲤⲚⲞϤ ϨⲒ ⲤⲀⲢⲜ ⲞⲨⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲞⲨⲰϢ ⲚⲢⲢⲰⲘⲈ ⲀⲖⲖⲀ ⲚⲦⲀⲨϪⲠⲞⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ⲀⲨⲰ ⲠϢⲀϪⲈ ⲀϤⲢⲤⲀⲢⲜ ⲀϤⲞⲨⲰϨ ⲚⲘⲘⲀⲚ ⲀⲨⲰ ⲀⲚⲚⲀⲨ ⲈⲠⲈϤⲈⲞⲞⲨ ⲚⲐⲈ ⲘⲠⲈⲞⲞⲨ ⲚⲞⲨϢⲎⲢⲈ ⲚⲞⲨⲰⲦ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϤⲈⲒⲰⲦ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲚⲬⲀⲢⲒⲤ ϨⲒ ⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ⲒⲰϨⲀⲚⲚⲎⲤ ϤⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲎⲎⲦϤ ⲀⲨⲰ ϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲚⲦⲀⲒϪⲞⲞⲤ ⲈⲦⲂⲎⲎⲦϤ ϪⲈ ⲠⲈⲦⲚⲎⲨ ⲘⲚⲚⲤⲰⲈⲒ ⲀϤϢⲰⲠⲈ ϨⲀ ⲦⲀϨⲎ ϪⲈ ⲚⲈϤⲞ ⲚϢⲞⲢⲠ ⲈⲢⲞⲒ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ϪⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϤϪⲰⲔ ⲀⲚⲞⲚ ⲦⲎⲢⲚ ⲚⲦⲀⲚϪⲒ ⲚⲞⲨⲰⲚϨ ⲀⲨⲰ ⲞⲨⲬⲀⲢⲒⲤ ⲈⲠⲘⲀ ⲚⲞⲨⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ϪⲈ ⲠⲚⲞⲘⲞⲤ ⲚⲦⲀⲨⲦⲀⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲘⲰⲨⲤⲎⲤ. ⲦⲈⲬⲀⲢⲒⲤ ϨⲰⲰⲤ ⲀⲨⲰ ⲦⲘⲈ ⲚⲦⲀⲤϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲖⲀⲀⲨ ⲚⲀⲨ ⲈⲢⲞϤ ⲈⲚⲈϨ. ⲠⲚⲞⲨⲦⲈ ⲠϢⲎⲢⲈ ⲚⲞⲨⲰⲦ ⲠⲈⲦϢⲞⲞⲠ ϨⲚ ⲔⲞⲨⲚϤ ⲘⲠⲈϤⲈⲒⲰⲦ Ⲡ ⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲚⲦⲀϤϢⲀϪⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲦⲈⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲚⲚⲞⲞⲨ ϢⲀⲢⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚϨⲈⲚⲞⲨⲎⲎⲂ ⲚⲘ ϨⲈⲚⲖⲈⲨⲈⲒⲦⲎⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲚⲞⲨϤ ϪⲈ ⲚⲦⲔⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ⲀⲨⲰ ⲀϤϨⲞⲘⲞⲖⲞⲄⲒ ⲀⲨⲰ ⲘⲠϤⲀⲢⲚⲀ ϪⲈ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ⲀⲨϪⲚⲞⲨϤ ⲆⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ϨⲎⲖⲈⲒⲀⲤ ⲀⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲰ ⲀϤⲞⲨⲰϢⲂ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ⲠⲈϪⲀⲨ ϪⲈ ⲚⲦⲞⲔ ϬⲈ ⲚⲦⲔ ⲚⲒⲘ ϪⲈⲔⲀⲀⲤ ⲈⲚⲈϪⲒⲠⲞⲨⲰ ⲚⲚⲈⲚⲦⲀⲨⲦⲀ ⲞⲨⲞⲚ. ⲈⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲈⲦⲂⲎⲎⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ⲠⲈϪⲀϤ. ϪⲈ ⲀⲚⲞⲔ ⲦⲈ ⲦⲈⲤⲘⲎ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϪⲀⲒⲈ ϪⲈ ⲤⲞⲞⲨⲦⲚ ⲚⲦⲈϨⲒⲎ ⲘⲠϪⲞⲈⲒⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚϬⲒ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ⲀⲨⲰ ⲀⲨⲦⲚⲚⲈⲨϨⲞⲒⲚⲈ ϢⲀⲢⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ⲀⲨϪⲚⲞⲨϤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ϬⲈ ⲔⲂⲀⲠⲦⲒⲌⲈ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲀⲚ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲆⲈ ϨⲎⲖⲈⲒⲀⲤ ⲞⲨⲆⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲀⲚⲞⲔ ⲈⲒⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲘⲞⲞⲨ. ϤⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲦⲚⲘⲎⲦⲈ ⲠⲀⲒ ⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ⲠⲈⲦⲚⲎⲨ ⲘⲚⲚⲤⲰⲈⲒ ⲠⲀⲒ ⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲚⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲘⲞⲨⲤ ⲘⲠⲈϤⲦⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ⲚⲀⲒ ⲀⲨϢⲰⲠⲈ ϨⲚ ⲂⲎⲐⲀⲢⲀⲂⲀ ⲘⲠⲒⲔⲢⲞ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲘⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲂⲀⲠⲦⲒⲌⲈ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲀϤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲚⲎⲨ ϢⲀⲢⲞϤ ⲀⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲈⲒⲤ ⲠⲈϨⲒⲈⲒⲂ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲚⲀϤⲒ ⲘⲠⲚⲞⲂⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ⲠⲀⲒ ⲠⲈ ⲚⲦⲀⲒϪⲞⲞⲤ ⲈⲦⲂⲎⲎⲦϤ. ϪⲈ ⲞⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲚⲎⲨ ϨⲒ ⲠⲀϨⲞⲨ ⲘⲘⲞⲞⲒ ⲈⲀϤϢⲰⲠⲈ ϨⲀ ⲦⲀϨⲎ ϪⲈ ⲚⲈϤⲞ ⲚϢⲞⲢⲠ ⲈⲢⲞⲒ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ⲀⲚⲞⲔ ϨⲰ ⲚⲈⲒⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲢⲀⲎⲖ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒⲈⲒ ⲀⲚⲞⲔ ⲈⲒⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲞⲨⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ⲀⲨⲰ ⲀϤⲢ ⲘⲚⲦⲢⲈ ⲚϬⲒ ⲒⲰϨⲀⲚⲚⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲈⲒⲚⲀⲨ ⲈⲠⲈⲠⲚⲀ ⲈϤⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲐⲈ ⲚⲞⲨϬⲢⲞⲞⲘⲠⲈ ⲀⲨⲰ ⲀϤⲞⲨⲰϨ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ⲀⲚⲞⲔ ϨⲰ ⲚⲈⲒⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ ⲈⲂⲀⲠⲦⲒⲌⲈ ϨⲘ ⲠⲘⲞⲞⲨ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲒ ϪⲈ ⲠⲈⲦⲔⲚⲀⲚⲀⲨ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈϤⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲈϤϬⲈⲈⲦ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲠⲀⲒ ⲠⲈⲦⲚⲀⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲚⲘ ⲞⲨⲔⲰϨⲦ ");
INSERT INTO copshc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ⲀⲨⲰ ⲀⲚⲞⲔ ⲀⲚⲀⲨ ⲀⲨⲰ ⲀⲒⲢⲘⲚⲦⲢⲈ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲤⲰⲦⲠ ⲚϢⲎⲢⲈ ⲚⲦⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲞⲚ ⲚⲈⲢⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲀϨⲈⲢⲀⲦϤ ⲀⲨⲰ ⲤⲚⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲈϤⲘⲞⲞϢⲈ ⲠⲈϪⲀϤ. ϪⲈ ⲈⲒⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈϨⲒⲈⲒⲂ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ⲀⲠⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲤⲚⲀⲨ ⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϤϢⲀϪⲈ ⲀⲨⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ⲚⲦⲈⲢⲈϤⲔⲞⲦϤ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲈⲨⲞⲨⲎϨ ⲚⲤⲰϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲦⲈⲦⲚϢⲒ ⲚⲈ ⲚⲤⲀⲞⲨ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲠⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲤⲀϨ ⲈⲔⲞⲨⲎϨ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲘⲎⲈⲒⲦⲚ ⲀⲨⲰ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲀⲨⲈⲒ ϬⲈ ⲀⲨⲚⲀⲨ ϪⲈ ⲈϤⲞⲨⲎϨ ⲦⲰⲚ ⲀⲨⲰ ⲀⲨϢⲰⲠⲈ ϨⲀ ϨⲦⲎϤ ⲘⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲈ ⲠⲚⲀⲨ ⲚϪⲠ ⲘⲎⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ⲀⲚⲆⲢⲈⲀⲤ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲈ ⲞⲨⲀ ⲠⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲚⲀⲨ ⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲀⲨⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ⲠⲀⲒ ⲀϤϨⲈ ⲈⲠⲈϤⲤⲞⲚ ⲤⲒⲘⲰⲚ ⲚϢⲞⲢⲠ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲀⲚϨⲈ ⲈⲘⲈⲤⲤⲒⲀⲤ ⲠⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ⲀⲨⲰ ⲀϤⲚⲦϤ ⲈⲢⲀⲦϤ ⲚⲒⲎⲤⲞⲨⲤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲠⲈϪⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲤⲒⲘⲰⲚ ⲠϢⲎⲢⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲦⲞⲔ ⲈⲨⲈⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ ϪⲈ ⲔⲎⲪⲀ ⲠⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲀϤⲞⲨⲰϢ ⲈⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲰ ⲀϤϨⲈ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲚⲈⲨⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲂⲎⲆⲤⲀⲒⲆⲀ ⲦⲠⲞⲖⲒⲤ ⲚⲀⲚⲆⲢⲈⲀⲤ ⲘⲚ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ⲀⲪⲒⲖⲒⲠⲠⲞⲤ ϨⲈ ⲈⲚⲀⲐⲀⲚⲀⲎⲖ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠⲈⲚⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲤϨⲀⲒ ⲈⲦⲂⲎⲎⲦϤ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲚϨⲈ ⲈⲢⲞϤ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ ⲠⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copshc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ⲠⲈϪⲈ ⲚⲀⲐⲀⲚⲀⲎⲖ ⲚⲀϤ. ϪⲈ ⲈⲢⲈϢ ⲞⲨⲀⲄⲀⲐⲞⲚ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ ⲠⲈϪⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲚⲄⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ⲀⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ⲈⲚⲀⲐⲀⲚⲀⲎⲖ ⲈϤⲚⲎⲨ ϢⲀⲢⲞϤ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲈⲦⲂⲎⲎⲦϤ. ϪⲈ ⲈⲒⲤ ⲞⲨⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲚⲀⲘⲈ ⲈⲘⲘⲚⲔⲢⲞϤ ⲚϨⲎⲦϤ ");
INSERT INTO copshc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ⲠⲈϪⲈ ⲚⲀⲐⲀⲚⲀⲎⲖ ⲚⲀϤ. ϪⲈ ⲈⲔⲤⲞⲞⲨⲚ ⲘⲘⲞⲒ ⲦⲰⲚ. ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲘⲠⲀⲦⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ ⲚϨⲞⲨⲚ ϨⲀ ⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲀⲚⲀⲨ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ⲀⲚⲀⲐⲀⲚⲀⲎⲖ ⲞⲨⲰϢⲂ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲚⲦⲞⲔ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲈⲂⲞⲖ ϪⲈ ⲀⲒϪⲞⲞⲤ ⲚⲀⲔ ϪⲈ ⲀⲚⲀⲨ ⲈⲢⲞⲔ ⲚϨⲞⲨⲚ ϨⲀⲦⲂⲰ ⲚⲔⲚⲦⲈ ⲀⲔⲠⲒⲤⲦⲈⲨⲈ. ⲔⲚⲀⲚⲀⲨ ⲈⲚⲈⲦⲚⲀⲀⲀⲨ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲈⲦⲠⲈ ⲈⲤⲞⲨⲎⲚ ⲀⲨⲰ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨⲚⲀ ⲈϨⲢⲀⲒ ⲀⲨⲰ ⲈⲨⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲈϪⲘ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ⲀⲨⲰ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲀⲨϢⲈⲖⲈⲈⲦ ϢⲰⲠⲈ ϨⲚ ⲔⲀⲚⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲰ ⲚⲈⲢⲈ ⲦⲘⲀⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ⲀⲨⲦⲰϨⲘ ⲆⲈ ϨⲰⲰϤ ⲚⲒⲎⲤⲞⲨⲤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦϢⲈⲖⲈⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϢⲰⲰⲦ ⲚⲎⲢⲠ. ⲠⲈϪⲈ ⲦⲘⲀⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ϪⲈ ⲘⲘⲚⲦⲞⲨ ⲎⲢⲠ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲈⲢⲈⲞⲨⲈϢⲞⲨ ⲚⲘⲘⲀⲒ ⲘⲠⲀⲦⲈⲦⲀⲞⲨⲚⲞⲨ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ⲠⲈϪⲈ ⲦⲈϤⲘⲀⲀⲨ ⲚⲚⲈⲦⲞⲨⲰⲦϨ. ϪⲈ ⲠⲈⲦϤⲚⲀϪⲞⲞϤ ⲚⲎⲦⲚ ⲀⲢⲒϤ. ");
INSERT INTO copshc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ⲚⲈⲨⲚ ⲤⲞ ⲆⲈ ⲚϨⲨⲆⲢⲒⲀ ⲚⲰⲚⲈ ⲈⲨⲔⲎ ⲈϨⲢⲀⲈⲒ ⲘⲘⲀⲨ ⲔⲀⲦⲀ ⲠⲦⲂⲂⲞ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲢⲈ ⲦⲞⲨⲈⲒ ⲦⲞⲨⲈⲒ ϢⲰⲠ ⲘⲘⲈⲦⲢⲎⲦⲎⲤ ⲤⲚⲀⲨ ⲎϢⲞⲘⲚⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ⲘⲈϨ ⲚϨⲨⲆⲢⲒⲀ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ⲀⲨⲘⲀϨⲞⲨ ⲈⲂⲞⲖ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲞⲨⲰⲦϨ ⲦⲈⲚⲞⲨ ⲚⲦⲈⲦⲚ ⲈⲒⲚⲈ ⲘⲠⲀⲢⲬⲒⲦⲢⲒⲔⲖⲒⲚⲞⲤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ⲚⲦⲈⲢⲈ ⲠⲀⲢⲬⲒⲦⲢⲒⲔⲖⲒⲚⲞⲤ ⲆⲈ ⲦⲰⲠⲈ ⲘⲠⲘⲞⲞⲨ ⲈⲀϤⲢ ⲎⲢⲠ ⲀⲨⲰ ⲚⲈϤⲤⲞⲞⲨⲚ ⲀⲚ ⲠⲈ ϪⲈ ⲞⲨ ⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ⲚⲢⲈϤⲞⲨⲰⲦϨ ⲆⲈ ⲚⲦⲞⲞⲨ ⲈⲚⲦⲀⲨⲘⲈϨ ⲘⲘⲞⲞⲨ ⲚⲈⲨⲤⲞⲞⲨⲚ ⲠⲈ. ⲀⲠⲀⲢⲬⲒⲦⲢⲒⲔⲖⲒⲚⲞⲤ ⲘⲞⲨⲦⲈ ⲈⲠⲀ ⲦϢⲈⲖⲈⲈⲦ ");
INSERT INTO copshc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲢⲰⲘⲈ ⲚⲒⲘ ⲈϢⲀⲨⲔⲀ ⲠⲎⲢⲠ ⲈϨⲢⲀⲒ ⲈⲦⲚⲀⲚⲞⲨϤ ⲚϢⲞⲢⲠ ⲀⲨⲰ ⲈⲨϢⲀⲚϮ ϨⲈ ϢⲀⲨⲔⲀ ⲠⲈⲦϬⲞϪⲂ. ⲚⲦⲞⲔ ⲆⲈ ⲀⲔⲀⲢⲈϨ ⲈⲠⲎⲢⲠ ⲈⲦⲚⲀⲚⲞⲨϤ ϢⲀ ϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ⲠⲀⲒ ⲠⲈ ⲠϢⲞⲢⲠ ⲘⲘⲀⲒⲚ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲀϤ ϨⲚ ⲔⲀⲚⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲰ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈϤⲈⲞⲞⲨ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ⲘⲚⲚⲤⲀ ⲠⲀⲒ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲚⲦⲞϤ ⲚⲘ ⲦⲈϤⲘⲀⲀⲨ ⲀⲨⲰ ⲚⲈϤⲤⲚⲎⲨ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲀⲨϬⲰ ⲘⲘⲀⲨ ⲚϨⲈⲚⲔⲞⲨⲈⲒ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ⲚⲈϤϨⲎⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲠⲀⲤⲬⲀ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲨⲰ ⲀⲒⲎⲤⲞⲨⲤ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ⲀϤϨⲈ ⲈⲢⲞⲞⲨ ϨⲘ ⲠⲈⲢⲠⲈ ⲈⲨϮ ⲈϨⲈ ⲈⲂⲞⲖ ⲀⲨⲰ ϬⲢⲞⲞⲘⲠⲈ ⲀⲨⲰ ⲚⲈⲦⲢⲀⲠⲈⲌⲒⲦⲎⲤ ⲈⲨϨⲘⲞⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ⲀⲨⲰ ⲀϤⲦⲀⲘⲒⲈ ⲞⲨⲘⲀⲤⲦⲒⲄⲜ ⲈⲂⲞⲖ ϨⲚ ϨⲈⲚⲚⲞⲨϨ ⲀϤⲚⲈϪ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ⲚⲈⲤⲞⲞⲨ ⲘⲚ ⲚⲈϨⲞⲞⲨ ⲀⲨⲰ ⲀϤⲠⲰϨⲦ ⲈⲂⲞⲖ ⲚⲚϨⲞⲘⲚⲦ ⲚⲢⲢⲈϤϪⲒ ⲔⲞⲖⲨⲘⲂⲞⲚ ⲀⲨⲰ ⲀϤϢⲞⲢϢⲢ ⲚⲚⲈⲨⲦⲢⲀⲠⲈⲌⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ⲠⲈϪⲀϤ ⲚⲚⲈⲦϮ ⲈⲂⲞⲖ ⲚⲚⲈϬⲢⲞⲞⲘⲠⲈ. ϪⲈ ϤⲒ ⲚⲀⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲀ. ⲘⲠⲢⲈⲒⲢⲈ ⲘⲠⲎⲈⲒ ⲘⲠⲀⲈⲒⲰⲦ ⲚⲎⲈⲒ ⲘⲘⲀ ⲚⲈϢⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ⲀⲨⲢ ⲠⲘⲈⲈⲨⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϤⲤⲎϨ ϪⲈ ⲠⲔⲰϨ ⲘⲠⲈⲔⲎⲈⲒ ⲚⲀⲞⲨⲞⲘⲚⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ⲀⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲞⲨ ⲘⲘⲀⲈⲒⲚ ⲠⲈⲦⲔⲦⲤⲀⲂⲞ ⲘⲘⲞⲚ ⲈⲢⲞϤ ϪⲈ ⲔⲈⲒⲢⲈ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲢⲠⲈ ⲀⲨⲰ ϮⲚⲀⲦⲞⲨⲚⲞⲤϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ⲠⲈϪⲀⲨ ϬⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲀⲨⲢ ϨⲘⲈⲦⲀⲤⲈ ⲢⲢⲞⲘⲠⲈ ⲈⲨⲔⲰⲦ ⲘⲠⲈⲒⲢⲠⲈ. ⲀⲨⲰ ⲚⲦⲞⲔ ⲔⲚⲀⲦⲞⲨⲚⲞⲤϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲦⲂⲈ ⲠⲈⲢⲠⲈ ⲘⲠⲈϤⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ⲚⲦⲈⲢⲈϤⲦⲰⲞⲨⲚϤ ϬⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲀⲨⲢ ⲠⲘⲈⲈⲨⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲚⲈϤϪⲰ ⲘⲘⲞϤ ⲀⲨⲰ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲦⲈⲄⲢⲀⲪⲎ ⲚⲘ ⲠϢⲀϪⲈ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ⲈϤϢⲞⲞⲠ ⲆⲈ ϨⲢⲀⲒ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲠϢⲀ ⲘⲠⲠⲀⲤⲬⲀ. ⲀⲨⲘⲎⲎϢⲈ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈϤⲢⲀⲚ ⲈⲨⲚⲀⲨ ⲈⲘⲘⲀⲒⲚ ⲈⲚⲈϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ⲚⲦⲞϤ ⲆⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲈϤⲦⲀⲚϨⲞⲨⲦ ⲘⲘⲞϤ ⲀⲚ ⲚⲘⲘⲀⲨ ⲈⲦⲂⲈ ϪⲈ ⲚⲈϤⲤⲞⲞⲨⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ⲀⲨⲰ ⲚϤⲢⲬⲢⲒⲀ ⲀⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲞⲨⲀ ⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲈ ⲢⲰⲘⲈ. ⲚⲦⲞϤ ⲄⲀⲢ ⲚⲈϤⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈⲦϨⲘ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲈⲨⲀⲢⲬⲰⲚ ⲚⲒⲞⲨⲆⲀⲒ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ⲠⲀⲒ ⲀϤⲈⲒ ϢⲀⲢⲞϤ ⲚⲦⲈⲨϢⲎ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲔ ⲞⲨⲤⲀϨ ⲈⲀⲔⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲘⲘⲚ ϢϬⲞⲘ ⲄⲀⲢ ⲖⲖⲀⲀⲨ ⲈⲢⲚⲈⲒⲘⲀⲒⲚ ⲈⲦⲔⲈⲒⲢⲈ ⲚⲦⲞⲔ ⲘⲘⲞⲞⲨ ⲈⲒ ⲘⲎⲦⲒ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ϢⲞⲞⲠ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲈⲨⲦⲘϪⲠⲈ ⲞⲨⲀ ⲚⲔⲈⲤⲞⲠ. ⲘⲘⲚ ϬⲞⲘ ⲘⲘⲞϤ ⲈⲚⲀⲨ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ⲠⲈϪⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲤⲈⲚⲀϪⲠⲈ ⲠⲢⲰⲘⲈ ⲚⲔⲈⲤⲞⲠ ⲈⲀϤⲢϨⲖⲖⲞ. ⲘⲎ ⲞⲨⲚ ϢϬⲞⲘ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈϨⲎⲦⲤ ⲚⲦⲈϤⲘⲀⲀⲨ ⲚⲔⲈⲤⲞⲠ ⲚⲤⲈϪⲠⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲈⲨⲦⲘϪⲠⲈ ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲘⲞⲞⲨ ⲚⲘ ⲞⲨⲠⲚⲈⲨⲘⲀ. ⲘⲚ ϬⲞⲘ ⲘⲘⲞϤ ⲈⲈⲒ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ⲠⲈⲚⲦⲀⲨϪⲠⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲀⲢⲜ. ⲞⲨⲤⲀⲢⲜ ⲠⲈ. ⲀⲨⲰ ⲠⲈⲚⲦⲀⲨϪⲠⲞϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ⲘⲠⲢⲢϢⲠⲎⲢⲈ ϪⲈ ⲀⲒϪⲞⲞⲤ ⲚⲀⲔ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲨϪⲠⲈ ⲦⲎⲨⲦⲚ ⲚⲔⲈⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲒϤⲈ ⲈⲠⲘⲀ ⲈⲦϤⲞⲨⲀϢϤ ⲀⲨⲰ ⲔⲤⲰⲦⲘ ⲈⲦⲈϤⲤⲘⲎ. ⲀⲖⲖⲀ ⲚⲄⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲀϤⲈⲒ ⲦⲰⲚ ⲎⲈϤⲚⲀ ⲈⲦⲰⲚ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀⲨϪⲠⲞϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ⲀⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲈⲢⲈϢ ⲚⲀⲒ ⲚⲀϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲤⲀϨ ⲘⲠⲒⲤⲢⲀⲎⲖ. ⲀⲨⲰ ⲚⲄⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲠⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲠⲈⲦⲚϪⲰ ⲘⲘⲞϤ ⲀⲨⲰ ⲠⲈⲦⲚⲚⲀⲨ ⲈⲢⲞϤ ⲠⲈⲦⲚⲢⲘⲚⲦⲢⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ϪⲒ ⲀⲚ ⲚⲦⲈⲚⲘⲚⲦⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ⲈϢϪⲈ ⲀⲈⲒϪⲰ ⲚⲎⲦⲚ ⲚⲚⲀ ⲠⲔⲀϨ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ. ⲚⲀϢ ⲚϨⲈ ⲈⲒϢⲀⲚϪⲰ ⲈⲢⲰⲦⲚ ⲚⲚⲀ ⲦⲠⲈ ⲦⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ⲀⲨⲰ ⲘⲠⲈ ⲖⲀⲀⲨ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲈⲒⲘⲎⲦⲒ ⲠⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲘⲰⲨⲤⲎⲤ ϪⲒⲤⲈ ⲘⲠϨⲞϤ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲨϪⲈⲤⲦ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ϪⲈⲔⲀⲀⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈϤⲈⲔⲰ ⲚⲀϤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲘⲈⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ. ϨⲰⲤⲦⲈ ⲠⲈϤϢⲎⲢⲈ ⲚⲞⲨⲰⲦ ⲀϤⲦⲀⲀϤ ϪⲈⲔⲀⲀⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲚⲚⲈϤϨⲈ ⲈⲂⲞⲖ ⲀⲖⲖⲀ ⲈϤⲈϪⲒ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲦⲚⲚⲈⲨ ⲠⲈϤϢⲎⲢⲈ ⲀⲚ ⲈⲠⲔⲞⲤⲘⲞⲤ ϪⲈ ⲈϤⲈⲔⲢⲒⲚⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲠⲔⲞⲤⲘⲞⲤ ⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲚⲤⲈⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲀⲚ. ⲠⲈⲦⲈ ⲚϤⲠⲒⲤⲦⲈⲨⲈ ⲆⲈ ⲀⲚ ⲎⲆⲎ ⲀⲨⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ϪⲈ ⲘⲠϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲢⲀⲚ ⲘⲠϢⲎⲢⲈ ⲚⲞⲨⲰⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ⲦⲀⲒ ⲆⲈ ⲦⲈ ⲦⲈⲔⲢⲒⲤⲒⲤ ϪⲈ ⲀⲠⲞⲨⲞⲒⲚ ⲈⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ ⲀⲨⲰ ⲀⲚⲢⲰⲘⲈ ⲘⲈⲢⲈ ⲠⲔⲀⲔⲈ ⲈϨⲞⲨⲈ ⲠⲞⲨⲞⲒⲚ. ⲚⲈⲢⲈ ⲚⲈⲨϨⲂⲎⲨⲈ ⲄⲀⲢ ϨⲞⲞⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲒⲢⲈ ⲚⲘⲠⲈⲐⲞⲞⲨ ϤⲘⲞⲤⲦⲈ ⲘⲠⲞⲨⲞⲒⲚ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨϪⲠⲒⲈ ⲚⲈϤϨⲂⲎⲨⲈ ϪⲈ ⲤⲈϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ⲠⲈⲦⲒⲢⲈ ⲚⲦⲞϤ ⲚⲦⲘⲈ ϢⲀϤⲈⲒ ϢⲀ ⲠⲞⲨⲞⲒⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲚⲈϤϨⲂⲎⲨⲈ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϪⲈ ⲚⲦⲀϤⲀⲀⲨ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲠⲔⲀϨ ⲚϮⲞⲨⲆⲀⲒⲀ ⲀⲨⲰ ⲚⲈϤⲘⲘⲀⲨ ⲠⲈ ⲚⲘⲘⲀⲨ ⲈϤⲂⲀⲠⲦⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ⲚⲈⲢⲈ ⲠⲔⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲆⲈ ⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲀⲒⲚⲰⲚ ϨⲀⲦⲚ ⲤⲀⲖⲈⲒⲘ ϪⲈ ⲚⲈⲨⲚϨⲀϨ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲰ ⲚⲈⲨⲚⲎⲨ ⲠⲈ ⲈⲨϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ⲚⲈ ⲘⲠⲀⲦⲞⲨⲚⲈϪ ⲒⲰϨⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲠⲈ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ⲀⲨⲌⲎⲦⲎⲤⲒⲤ ϬⲈ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲘ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲈⲦⲂⲈ ⲠⲦⲂⲂⲞ ");
INSERT INTO copshc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ⲀⲨⲈⲒ ϢⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲠⲎ ⲈⲦⲈ ⲚⲈϤϢⲞⲞⲠ ⲚⲘⲘⲀⲔ ϨⲒ ⲠⲒⲔⲢⲞ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲠⲀⲒ ⲚⲦⲞⲔ ⲈⲚⲦⲀⲔⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞϤ ⲈⲒⲤ ϨⲎⲎⲠⲈ ⲚⲦⲞϤ ϤⲂⲀⲠⲦⲒⲌⲈ ⲀⲨⲰ ϤⲢϨⲀϨ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲎⲨ ⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲚ ϢϬⲞⲘ ⲘⲠⲢⲰⲘⲈ ⲈϪⲒ ⲖⲀⲀⲨ ϨⲀⲢⲞϤ ⲞⲨⲀⲀϤ ⲈⲒ ⲘⲎⲦⲒ ⲚⲤⲈⲦⲀⲀⲤ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲢⲘⲚⲦⲢⲈ ⲚⲀⲒ ϪⲈ ⲀⲒϪⲞⲞⲤ ϪⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ϪⲈ ⲚⲦⲀⲨⲦⲀⲞⲨⲞⲈⲒ ϨⲀ ⲐⲎ ⲘⲠ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ⲠⲈⲦⲈⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲦϢⲈⲖⲈⲈⲦ ⲚⲦⲞϤ ⲠⲈ ⲠⲀⲦϢⲈⲖⲈⲈⲦ ⲠⲈϢⲂⲎⲢ ⲆⲈ ⲘⲠⲀ ⲦϢⲈⲖⲈⲈⲦ ⲈⲦⲀϨⲈⲢⲀⲦϤ ⲀⲨⲰ ⲈⲦⲤⲰⲦⲘ ⲈⲢⲞϤ ϨⲚ ⲞⲨⲢⲀϢⲈ ϤⲢⲀϢⲈ ⲈⲦⲂⲈ ⲦⲈⲤⲘⲎ ⲘⲠⲀ ⲦϢⲈⲖⲈⲈⲦ ⲠⲀⲢⲀϢⲈ ϬⲈ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ϨⲀⲠⲤ ⲈⲦⲢⲈⲠ ⲈⲦⲘⲘⲀⲨ ϪⲒⲤⲈ. ⲀⲚⲞⲔ ⲆⲈ ⲈⲦⲢⲀⲐⲂⲂⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ⲠⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ϤϨⲒϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ. ⲠⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲠⲈ ⲀⲨⲰ ⲈϤϢⲀϪⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ. ⲠⲈⲚⲦⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ⲠⲈⲚⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲰ ⲀϤⲤⲞⲦⲘⲈϤ ϤⲢⲘⲚⲦⲢⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲘⲘⲚ ⲖⲀⲀⲨ ϪⲒ ⲚⲦⲈϤⲘⲚⲦⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ⲠⲈⲚⲦⲀϤϪⲒ ⲆⲈ ⲚⲦⲈϤⲘⲚⲦⲘⲚⲦⲢⲈ ⲀϤⲤⲪⲢⲀⲄⲒⲌⲈ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲘⲈ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ⲠⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲦⲚⲚⲞⲞⲨϤ ⲈϤϪⲰ ⲚⲚϢⲀϪⲈ ϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ Ϯ ⲀⲚ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ϨⲚ ⲞⲨϢⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ⲠⲒⲰⲦ ⲘⲈ ⲘⲠϢⲎⲢⲈ ⲀⲨⲰ ⲀϤϮ ⲚⲔⲀ ⲚⲒⲘ ⲈϨⲢⲀⲒ ⲈⲦⲈϤϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϢⲎⲢⲈ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲠⲈⲦⲈ ⲚϤⲠⲒⲤⲦⲈⲨⲈ ⲆⲈ ⲀⲚ ⲈⲠϢⲎⲢⲈ ⲚϤⲚⲀⲚⲀⲨ ⲀⲚ ⲈⲠⲰⲚϨ ⲀⲖⲖⲀ ⲦⲞⲢⲄⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀϬⲰ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ⲚⲦⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ϬⲈ ⲈⲒⲘⲈ ϪⲈ ⲀⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲤⲰⲦⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲢϨⲀϨ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ϤⲂⲀⲠⲦⲒⲌⲈ ⲈϨⲞⲨⲈⲒⲰϨⲀⲚⲚⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ⲔⲀⲒⲦⲞⲒ ⲒⲎⲤⲞⲨⲤ ⲀⲚ ⲠⲈ ⲚⲈϤⲂⲀⲠⲦⲒⲌⲈ ⲀⲖⲖⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ⲀϤⲔⲰ ⲚⲤⲰϤ ⲚϮⲞⲨⲆⲀⲒⲀ ⲀϤⲂⲰⲔ ⲞⲚ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ⲚⲈ ϨⲀⲠⲤ ⲆⲈ ⲠⲈ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ⲀϤⲈⲒ ϬⲈ ⲈⲨⲠⲞⲖⲒⲤ ⲚⲦⲈ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲤⲨⲬⲀⲢ ϨⲀⲦⲘ ⲠϬⲰⲘ ⲈⲚⲦⲀ ⲒⲀⲔⲰⲂ ⲦⲀⲀϤ ⲚⲒⲰⲤⲎⲪ ⲠⲈϤϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ⲚⲈⲨⲚ ⲞⲨⲠⲎⲄⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚⲦⲈ ⲒⲀⲔⲰⲂ. ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲦⲈⲢⲈϤϨⲒⲤⲈ ⲈϤⲘⲞⲞϢⲈ ϨⲒ ⲦⲈϨⲒⲎ ⲀϤϨⲘⲞⲞⲤ ⲚⲦⲈⲒϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲠⲎⲄⲎ. ⲚⲈ ⲠⲚⲀⲨ ⲚϪⲠⲤⲞ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ⲀⲨⲤϨⲒⲘⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲘⲈϨⲘ ⲞⲞⲨ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲀⲨⲈⲒⲤ ⲦⲀⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲄⲀⲢ ⲚⲈ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲞⲖⲒⲤ ⲈϢⲰⲠ ⲚⲀⲨ ⲘⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ⲠⲈϪⲀⲤ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ϪⲈ ⲚⲦⲞⲔ ⲚⲦⲔ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲚⲀϢ ⲚϨⲈ ⲔⲞⲨⲈϢⲤⲰ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ ⲈⲀⲚⲄ ⲞⲨⲤϨⲒⲘⲈ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲘⲈⲢⲈⲚⲒⲞⲨⲆⲀⲒ ⲄⲀⲢ ⲦⲰϨ ⲚⲘⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲤ. ϪⲈ ⲚⲈⲢⲈⲤⲞⲞⲨⲚ ⲚⲦⲆⲰⲢⲈⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ϪⲈ ⲚⲒⲘ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲈ ϪⲈ ⲀⲨⲈⲒⲤ ⲦⲀⲤⲰ. ⲚⲦⲞ ⲚⲈⲢⲈⲚⲀⲀⲒⲦⲒ ⲘⲘⲞϤ ⲠⲈ ⲚϤϮ ⲚⲈ ⲚⲞⲨⲘⲞⲞⲨ ⲈϤⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ⲠⲈϪⲀⲤ ⲚⲀϤ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲚ ⲔⲀⲆⲞⲤ ⲚⲦⲞⲞⲦⲔ ⲀⲨⲰ ⲦϢⲰⲦⲈ ϢⲞⲔϨ. ⲈⲨⲚⲦⲀⲔ ϬⲈ ⲘⲘⲀⲨ ⲈⲂⲞⲖ ⲦⲰⲚ ⲘⲠⲘⲞⲞⲨ ⲈⲦⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ⲘⲎ ⲚⲦⲞⲔ ⲈⲚⲀⲀⲔ ⲈⲠⲈⲚⲈⲒⲰⲦ ⲒⲀⲔⲰⲂ ⲠⲀⲒ ⲈⲚⲦⲀϤϮ ⲚⲀⲚ ⲚⲦϢⲰⲦⲈ. ⲀⲨⲰ ⲚⲦⲞϤ ⲀϤⲤⲰ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ ⲘⲚ ⲚⲈϤϢⲎⲢⲈ ⲘⲚ ⲚⲈϤⲦⲂⲚⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲤ. ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲞⲞⲨ ϤⲚⲀⲈⲒⲂⲈ ⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ⲠⲈⲦⲤⲰ ⲆⲈ ⲚⲦⲞϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲞⲞⲨ ⲠⲀⲒ ⲀⲚⲞⲔ ⲈϮⲚⲀⲦⲀⲀϤ ⲚⲀϤ. ⲚⲚⲈϤⲈⲒⲂⲈ ϢⲀ ⲈⲚⲈϨ. ⲀⲖⲖⲀ ⲠⲘⲞⲞⲨ ⲈϮⲚⲀⲦⲀⲀϤ ⲚⲀϤ ϤⲚⲀϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲚⲞⲨⲠⲎⲄⲎ ⲘⲘⲞⲞⲨ ⲈϤϤⲰϬⲈ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ⲠⲈϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ. ⲘⲀ ⲚⲀⲒ ⲘⲠⲈⲒⲘⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲀⲈⲒ ⲂⲈ ⲀⲨⲰ ⲈⲚⲚⲀⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲈⲈⲒⲘⲀ ⲈⲘⲈϨ ⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ⲠⲈϪⲀϤ ⲚⲀⲤ. ϪⲈ ⲂⲰⲔ ⲘⲞⲨⲦⲈ ⲈⲠⲞⲨϨⲀⲈⲒ ⲚⲦⲈⲈⲒ ⲈⲠⲈⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ⲀⲦⲈⲤϨⲒⲘⲈ ⲞⲨⲰϢⲂ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲚϮ ϨⲀⲈⲒ ⲘⲘⲀⲨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲀϪⲞⲞⲤ ϪⲈ ⲘⲚϮ ϨⲀⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ⲀϪⲒ ϮⲞⲨ ⲄⲀⲢ ⲚϨⲀⲈⲒ ⲀⲨⲰ ⲞⲚ ⲦⲈⲚⲞⲨ ⲠⲈⲦⲈⲨⲚⲦⲈⲈϤ ⲘⲠⲞⲨϨⲀⲒ ⲀⲚ ⲠⲈ. ⲠⲀⲒ ⲞⲨⲘⲈ ⲠⲈ ⲚⲦⲀϪⲞⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ⲠⲈϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ϮⲚⲀⲨ ϪⲈ ⲚⲦⲞⲔ ⲚⲦⲔ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ⲚⲦⲀ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲞⲨⲰϢⲦ ϨⲒϪⲚ ⲠⲈⲒⲦⲞⲞⲨ. ⲀⲨⲰ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈ ⲠⲘⲀ ⲈⲦϢⲈ ⲈⲞⲨⲰϢⲦ ⲚϨⲎⲦϤ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲀⲒ ⲦⲈⲤϨⲒⲘⲈ ϪⲈ ⲞⲨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲎⲨ ⲈⲚⲦⲈⲚⲀⲞⲨⲰϢⲦ ⲀⲚ ⲘⲠⲒⲰⲦ ⲞⲨⲦⲈ ϨⲘ ⲠⲈⲈⲒⲦⲞⲞⲨ ⲞⲨⲦⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲞⲨⲰϢⲦ ⲘⲠⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ⲀⲚⲞⲚ ⲆⲈ ⲈⲚⲞⲨⲰϢⲦ ⲘⲠⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲠⲞⲨϪⲀⲒ ⲈϤϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ⲀⲖⲖⲀ ⲤⲚⲎⲨ ⲚϬⲒ ⲞⲨⲞⲨⲚⲞⲨ ⲈⲦⲈ ⲦⲀⲒ ⲦⲈ ⲈⲢⲈ ⲚⲢⲈϤⲞⲨⲰϢⲦ ⲘⲈⲚ ⲚⲀⲞⲨⲰϢⲦ ⲘⲠⲒⲰⲦ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲘ ⲞⲨⲘⲈ. ⲈⲢⲈ ⲠⲈⲒⲰⲦ ⲄⲀⲢ ϢⲒⲚⲈ ⲚⲤⲀ ϨⲞⲒⲚⲈ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲈⲨⲚⲀⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ⲞⲨⲠⲚⲈⲨⲘⲀ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲚⲈⲦⲚⲀⲞⲨⲰϢⲦ ⲚⲀϤ ϢϢⲈ ⲈⲢⲞⲞⲨ ⲈⲞⲨⲰϢⲦ ⲚⲀϤ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲘⲞⲨⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ⲠⲈϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲚⲀϤ ϪⲈ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲘⲈⲤⲤⲒⲀⲤ ⲚⲎⲨ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲢϢⲀⲚⲠ ⲈⲦⲘⲘⲀⲨ ⲈⲒ ϤⲚⲀⲦⲀⲘⲞⲚ ⲈϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲈⲒ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲚⲈⲨⲢϢⲠⲎⲢⲈ ϪⲈ ⲚⲈϤϢⲀϪⲈ ⲚⲘⲞⲨⲤϨⲒⲘⲈ. ⲘⲠⲈ ⲖⲀⲀⲨ ⲘⲈⲚⲦⲞⲒ ϪⲞⲞⲤ ϪⲈ ⲈⲔϢⲒⲚⲈ ⲚⲤⲀ ⲞⲨⲎⲀϨⲢⲞⲔ ⲔϢⲀϪⲈ ⲚⲘⲘⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ⲀⲦⲈⲤϨⲒⲘⲈ ⲔⲰ ⲚⲦⲈⲤϨⲨⲆⲢⲒⲀ ⲀⲨⲰ ⲀⲤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲠⲈϪⲀⲤ ⲚⲢⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ϪⲈ ⲀⲘⲎⲈⲒⲦⲚ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ⲈⲨⲢⲰⲘⲈ ⲈⲀϤϪⲰ ⲈⲢⲞⲒ ⲚϨⲰⲂ ⲚⲒⲘ ⲈⲚⲦⲀⲒⲀⲀⲨ. ⲘⲎⲦⲒ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ⲚⲈⲨⲚⲎⲨ ϬⲈ ⲈⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ ⲈⲨⲚⲎⲨ ϢⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ϨⲚ ⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲤⲈⲠⲤⲰⲠϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲚⲦⲀⲒ ⲘⲘⲀⲨ ⲚⲞⲨϨⲢⲈ ⲈⲨⲞⲘⲤ ⲦⲀⲒ ⲚⲦⲰⲦⲚ ⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϬⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ. ϪⲈ ⲘⲎ ⲚⲦⲀ ⲞⲨⲀ ⲈⲒⲚⲈ ⲚⲀϤ ⲈⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ⲦⲀϨⲢⲈ ⲀⲚⲞⲔ ⲦⲈ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈⲈⲒⲢⲈ ⲘⲠⲞⲨⲰϢ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ ⲀⲨⲰ ⲦⲀϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲈϤϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ⲘⲎ ⲚⲦⲰⲦⲚ ⲀⲚ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲈϤⲦⲞⲞⲨ ⲚⲈⲂⲞⲦ ⲚⲈ ⲚⲦⲈⲠⲰϨⲤ ⲈⲒ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϤⲒ ⲚⲈⲦⲚⲂⲀⲖ ⲈϨⲢⲀⲒ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ⲈⲚⲈⲬⲰⲢⲀ ϪⲈ ⲎⲆⲎ ⲀⲨⲞⲨⲂⲀϢ ⲈⲞϨⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ⲠⲈⲦⲰϨⲤ ⲚⲀϪⲒ ⲞⲨⲂⲈⲔⲈ ⲀⲨⲰ ⲚϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϪⲈⲔⲀⲀⲤ ⲠⲈⲦϪⲞ ⲘⲚ ⲠⲈⲦⲰϨⲤ ⲈⲨⲈⲢⲀϢⲈ ϨⲒⲞⲨⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ⲠϢⲀϪⲈ ⲄⲀⲢ ⲞⲨⲘⲈ ⲠⲈ ϨⲘ ⲠⲀⲒ ϪⲈ ⲞⲨⲈⲦ ⲠⲈⲦϪⲞ ⲞⲨⲈⲦ ⲠⲈⲦⲰϨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ⲀⲚⲞⲔ ⲀⲒϪⲈⲨⲦⲎⲨⲦⲚ ⲈⲰϨⲤ ⲘⲠⲈⲦⲈ ⲘⲠⲈⲦⲚϢⲠ ϨⲒⲤⲈ ⲈⲢⲞϤ. ϨⲈⲚⲔⲞⲞⲨ ⲚⲈ ⲚⲦⲀⲨϢⲠ ϨⲒⲤⲈ ⲀⲨⲰ ⲚⲦⲰⲦⲚ ⲀⲦⲈⲦⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲨϨⲒⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲘⲎⲎϢⲈ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈⲦⲂⲈ ⲠϢⲀϪⲈ ⲚⲦⲈⲤϨⲒⲘⲈ ⲈⲤⲢⲘⲚⲦⲢⲈ ϪⲈ ⲀϤϪⲰ ⲚⲀⲒ ⲚϨⲰⲂ ⲚⲒⲘ ⲈⲚⲦⲀⲒⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ⲚⲦⲈⲢⲞⲨⲈⲒ ϬⲈ ϢⲀⲢⲞϤ ⲚϬⲒ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈϬⲰ ϨⲀ ϨⲦⲎⲨ. ⲀⲨⲰ ⲀϤϬⲰ ⲘⲘⲀⲨ ⲚϨⲞⲞⲨ ⲤⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ⲀⲨⲰ ⲀⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈϤϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ⲚⲈⲨϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲦⲈⲤϨⲒⲘⲈ. ϪⲈ ⲈⲚⲠⲒⲤⲦⲈⲨⲈ ϬⲈ ⲀⲚ ⲈⲦⲂⲈ ⲠⲞⲨϢⲀϪⲈ ⲀⲚⲞⲚ ⲄⲀⲢ ⲀⲚⲤⲰⲦⲘ ⲈⲢⲞϤ ⲀⲨⲰ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲠⲀⲒ ⲚⲀⲘⲈ ⲠⲈ ⲠⲤⲰⲦⲎⲢ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ⲘⲚⲚⲤⲀ ⲠϨⲞⲞⲨ ⲆⲈ ⲤⲚⲀⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ⲚⲦⲞϤ ⲄⲀⲢ ⲒⲎⲤⲞⲨⲤ ⲀϤⲢⲘⲚⲦⲢⲈ ϪⲈ ⲘⲚⲦⲈ ⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲀⲒⲞ ϨⲘ ⲠⲈϤϮⲘⲈ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨϢⲞⲠϤ ⲈⲢⲞⲞⲨ ⲚϬⲒ ⲚⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲈⲀⲨⲚⲀⲨ ⲈϨⲰⲂ ⲚⲒⲘ ⲈⲚⲦⲀϤⲀⲀⲨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲘ ⲠϢⲀ. ⲚⲦⲞⲞⲨ ⲄⲀⲢ ϨⲰⲞⲨ ⲞⲚ ⲚⲈⲀⲨⲈⲒ ⲈⲠϢⲀ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ⲀϤⲈⲒ ⲆⲈ ⲞⲚ ⲈⲔⲀⲚⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲠⲘⲀ ⲈⲚⲦⲀϤⲦⲢⲈ ⲠⲘⲞⲞⲨ ⲢⲎⲢⲠ. ⲀⲨⲰ ⲚⲈⲨⲚ ⲞⲨⲂⲀⲤⲒⲖⲒⲔⲞⲤ ⲈⲢⲈ ⲠⲈϤϢⲎⲢⲈ ϢⲰⲚⲈ ϨⲚ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ⲠⲀⲒ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ϪⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲀϤⲂⲰⲔ ϢⲀⲢⲞϤ ⲀⲨⲰ ⲀϤⲤⲈⲠⲤⲰⲠϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲚϤⲦⲀⲖϬⲈ ⲠⲈϤϢⲎⲢⲈ. ⲚⲈϤⲚⲀⲘⲞⲨ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲀϤ. ϪⲈ ⲈⲦⲈⲦⲚⲦⲘⲚⲀⲨ ⲈϨⲈⲚⲘⲀⲒⲚ ⲚⲘ ϨⲈⲚϢⲠⲎⲢⲈ. ⲚⲚⲈⲦⲘⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲂⲀⲤⲒⲖⲒⲔⲞⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲘⲠⲀⲦⲈ ⲠⲀϢⲎⲢⲈ ⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ϪⲈ ⲂⲰⲔ ⲠⲈⲔϢⲎⲢⲈ ⲞⲚϨ. ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲚϬⲒ ⲠⲢⲰⲘⲈ ⲈⲠϢⲀϪⲈ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞϤ ⲚⲀϤ ⲀⲨⲰ ⲀϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ⲈϤⲚⲎⲨ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲀⲚⲈϤϨⲘϨⲀⲖ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲀⲨⲰ ⲀⲨⲦⲀⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲔϢⲎⲢⲈ ⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ⲀϤϪⲚⲞⲨⲞⲨ ϬⲈ ⲈⲠⲚⲀⲨ ⲈⲚⲦⲀϤⲘⲦⲞⲚ ⲚϨⲎⲦϤ. ⲠⲈϪⲀⲨ ϪⲈ ⲀⲠⲈϨⲘⲞⲘ ⲔⲀⲀϤ ⲘⲠⲚⲀⲨ ⲚϪⲠ ⲤⲀϢϤⲈ ⲚⲤⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ⲀϤⲈⲒⲘⲈ ⲚϬⲒ ⲠⲈϤⲈⲒⲰⲦ ϪⲈ ⲠⲚⲀⲨ ⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈⲔϢⲎⲢⲈ ⲞⲚϨ ⲀⲨⲰ ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲚⲦⲞϤ ⲘⲚ ⲠⲈϤⲎⲈⲒ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ⲠⲀⲒ ⲞⲚ ⲠⲈ ⲠⲘⲈϨ ⲤⲚⲀⲨ ⲘⲘⲀⲒⲚ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲀϤ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲈⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲚⲈ ⲠϢⲀⲀ ⲠⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲀⲒⲎⲤⲞⲨⲤ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ⲚⲈⲨⲚ ⲞⲨⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ⲆⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲒϪⲚ ⲦⲈⲠⲢⲞⲂⲀⲦⲒⲔⲎ. ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ϪⲈ ⲂⲎⲆⲤⲀⲒⲆⲀ ⲈⲢⲈϮ ⲚⲤⲦⲞⲀ ϨⲒϪⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ⲚⲈⲨⲚⲔⲞⲦⲔ ϨⲀ ⲚⲀⲒ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ⲚⲚⲈⲦϢⲰⲚⲈ ⲚϬⲀⲖⲈ ⲚⲘⲚⲂⲖⲖⲈ ⲘⲚ ⲚⲈⲦϢⲞⲨⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","— ");
INSERT INTO copshc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲘⲘⲀⲨ ⲈⲀϤⲢ ⲘⲀⲂ ϢⲘⲎⲚⲈ ⲚⲢⲞⲘⲠⲈ ϨⲘ ⲠⲈϤϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ⲈⲠⲀⲒ ⲈϤⲚⲔⲞⲦⲔ ⲈⲀϤⲈⲒⲘⲈ ϪⲈ ⲀϤⲰⲤⲔ. ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲔⲞⲨⲰϢ ⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲠⲈⲦϢⲰⲚⲈ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲚϮ ⲢⲰⲘⲈ ⲘⲘⲀⲨ ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀ ⲠⲘⲞⲞⲨ ⲦⲰϨ ⲈϤⲈⲚⲞϪⲦ ⲈⲠⲈⲤⲎⲦ ⲈⲦⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ϨⲞⲤⲞⲚ ⲆⲈ ⲀⲚⲞⲔ ϮⲚⲎⲨ ϢⲀⲢⲈⲔⲈⲞⲨⲀ ⲢϢⲞⲢⲠ ⲈⲢⲞⲒ ⲈⲂⲰⲔ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ϪⲈ ⲦⲰⲞⲨⲚⲄ ⲚⲄϤⲒⲠⲈⲔϬⲖⲞϬ ⲚⲄⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲞⲨϪⲀⲒ ⲚϬⲒ ⲠⲢⲰⲘⲈ ⲀⲨⲰ ⲀϤϤⲒ ⲠⲈϤϬⲖⲞϬ ⲀϤⲘⲞⲞϢⲈ. ⲚⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲆⲈ ⲠⲈ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲠⲈⲚⲦⲀϤⲖⲞ ϪⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲀⲨⲰ ⲚⲤⲦⲞ ⲚⲀⲔ ⲀⲚ ⲈϤⲒⲠⲈⲔϬⲖⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ. ϪⲈ ⲠⲈⲚⲦⲀϤⲦⲀⲖϬⲞⲒ. ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲒ ϪⲈ ϤⲒ ⲠⲈⲔϬⲖⲞϬ ⲚⲄⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ⲀⲨϪⲚⲞⲨϤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲢⲰⲘⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲀⲔ ϪⲈ ϤⲒⲦϤ ⲚⲄⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ⲠⲈⲚⲦⲀϤⲖⲞ ⲆⲈ ⲚⲈϤⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲒⲘ ⲠⲈ. ⲒⲎⲤⲞⲨⲤ ⲄⲀⲢ ⲚⲈ ⲀϤⲤⲈϨⲦϤ. ⲈⲢⲈ ⲞⲨⲘⲎⲎ ϢⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀⲒⲎⲤⲞⲨⲤ ϨⲈ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲢⲠⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲔⲞⲨϪⲀⲒ. ⲘⲠⲢⲔⲞⲦⲔ ⲈⲢⲚⲞⲂⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈ ⲠⲈⲐⲞⲞⲨ ⲈⲠⲀⲒ ϢⲰⲠⲈ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ⲀϤⲂⲰⲔ ⲚϬⲒ ⲠⲢⲰⲘⲈ ⲀϤⲦⲀⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲚⲦⲀϤⲦⲀⲖϬⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ⲀⲨⲰ ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲈⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲆⲒⲰⲔⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲈϤⲈⲒⲢⲈ ⲚⲚⲀⲒ ⲠⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ. ϪⲈ ⲠⲀⲒⲰⲦ ⲢϨⲰⲂ ϢⲀ ϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲢϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲚϨⲞⲨⲞ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲘⲞⲞⲨⲦϤ ϪⲈ ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲈϤⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲖⲖⲀ ⲠⲈϤϪⲰ ⲘⲘⲞⲤ ⲞⲚ ϪⲈ ⲠⲀⲈⲒⲰⲦ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲈϤϢⲰϢ ⲘⲘⲞϤ ⲚⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ⲀϤⲞⲨⲰϢⲂ ϬⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲚ ϢϬⲞⲘ ⲘⲠϢⲎⲢⲈ ⲈⲢ ⲖⲀⲀⲨ ϨⲀⲢⲞϤ ⲞⲨⲀⲀϤ ⲈⲒ ⲘⲎⲦⲒ ⲚϤⲚⲀⲨ ⲈⲠⲈⲒⲰⲦ ⲈϤⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲚⲈⲦⲈⲢⲈ ⲠⲎ ⲄⲀⲢ ⲚⲀⲀⲀⲨ ⲚⲀⲒ ϨⲰⲰϤ ⲠϢⲎⲢⲈ ϨⲞⲘⲞⲒⲰⲤ ϤⲚⲀⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ⲠⲈⲒⲰⲦ ⲄⲀⲢ ⲘⲈ ⲘⲠϢⲎⲢⲈ ⲀⲨⲰ ϤⲦⲤⲀⲂⲞ ⲘⲘⲞϤ ⲈϨⲰⲂ ⲚⲒⲘ ⲈⲦϤⲈⲒⲢⲈ ⲚⲦⲞϤ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ϤⲚⲀⲦⲤⲀⲂⲞϤ ⲈϨⲈⲚϨⲂⲎⲨⲈ ⲈⲚⲀⲀⲀⲨ ⲈⲚⲀⲒ ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈⲢϢⲠⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ⲚⲐⲈ ⲄⲀⲢ ⲈϢⲀⲢⲈ ⲠⲈⲒⲰⲦ ⲦⲞⲨⲚⲈⲤ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲨⲰ ⲚϤⲦⲀⲚϨⲞⲞⲨ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲚⲀⲦⲀⲚϨⲈ ⲚⲈⲦϤⲞⲨⲀϢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ⲘⲠⲒⲰⲦ ⲄⲀⲢ ⲔⲢⲒⲚⲈ ⲀⲚ ⲚⲖⲀⲀⲨ. ⲀⲖⲖⲀ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲦⲎⲢⲤ ⲀϤⲦⲀⲀⲤ ⲘⲠϢⲎⲢⲈ ");
INSERT INTO copshc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲦⲀⲒⲈ ⲠϢⲎⲢⲈ ⲔⲀⲦⲀⲐⲈ ⲈⲦⲞⲨⲦⲀⲒⲞ ⲘⲠⲒⲰⲦ. ⲠⲈⲦⲈⲚϤⲦⲀⲒⲞ ⲀⲚ ⲘⲠϢⲎⲢⲈ ⲚϤⲦⲀⲒⲞ ⲀⲚ ⲘⲠⲈⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲤⲰⲦⲘ ⲈⲠⲀϢⲀϪⲈ ⲀⲨⲰ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲀⲨⲰ ⲚϤⲚⲎⲨ ⲀⲚ ⲈⲦⲈⲔⲢⲒⲤⲒⲤ ⲀⲖⲖⲀ ⲀϤⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲞⲨ ⲈϨⲞⲨⲚ ⲈⲠⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲎⲨ ⲈⲦⲈ ⲦⲈⲚⲞⲨ ⲦⲈ ⲈⲢⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲤⲰⲦⲘ ⲈⲦⲈⲤⲘⲎ ⲘⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲚⲈⲦⲚⲀⲤⲰⲦⲘ ⲤⲈⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ⲚⲐⲈ ⲄⲀⲢ ⲈⲦⲈⲨⲚⲦⲈ ⲠⲒⲰⲦ ⲠⲰⲚϨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀϤϮ ⲘⲠϢⲎⲢⲈ ⲈⲦⲢⲈϤⲔⲰ ⲚⲀϤ ⲘⲠⲰⲚϨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ⲀⲨⲰ ⲀϤϮ ⲚⲀϤ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲦⲢⲈϤⲈⲒⲢⲈ ⲚⲦⲈⲔⲢⲒⲤⲒⲤ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ⲀⲨⲰ ⲘⲠⲢⲢϢⲠⲎⲢⲈ ⲘⲠⲀⲒ ϪⲈ ⲞⲨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲎⲨ ⲈⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϨⲚ ⲚⲦⲀⲪⲞⲤ ⲚⲀⲤⲰⲦⲘ ⲈⲦⲈϤⲤⲘⲎ ");
INSERT INTO copshc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ⲀⲨⲰ ⲚⲤⲈⲈⲒ ⲈⲂⲞⲖ ⲚⲈⲚⲦⲀⲨⲈⲒⲢⲈ ⲚⲘⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲈⲨⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲰⲚϨ. ⲚⲈⲚⲦⲀⲨⲈⲒⲢⲈ ⲚⲘⲠⲈⲐⲞⲞⲨ ⲈⲨⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ⲘⲘⲚϬⲞⲘ ⲀⲚⲞⲔ ⲘⲘⲞⲒ ⲈⲢ ⲖⲀⲀⲨ ⲚϨⲰⲂ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ. ⲔⲀⲦⲀⲐⲈ ⲈϮⲤⲰⲦⲘ ⲈⲈⲒⲔⲢⲒⲚⲈ ⲀⲨⲰ ⲦⲀⲔⲢⲒⲤⲒⲤ ⲞⲨⲘⲈⲈ ⲦⲈ ϪⲈ ⲚⲈ ⲈⲒϢⲒⲚⲈ ⲀⲚ ⲚⲤⲀ ⲠⲀⲞⲨⲰϢ ⲘⲘⲒⲚ ⲘⲘⲞⲒ ⲀⲖⲖⲀ ⲚⲤⲀ ⲠⲞⲨⲰϢ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ⲈϢⲰⲠⲈ ⲀⲚⲞⲔ ⲈⲒϢⲀⲚⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲒ. ⲦⲀⲘⲚⲦⲘⲚⲦⲢⲈ ⲞⲨⲘⲈ ⲀⲚ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ⲔⲈⲞⲨⲀ ⲠⲈⲦⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲒ ⲀⲨⲰ ϮⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨⲘⲈ ⲦⲈ ⲦⲈϤⲘⲚⲦⲘⲚⲦⲢⲈ ⲈⲦϤⲈⲒⲢⲈ ⲘⲘⲞⲤ ϨⲀⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ⲚⲦⲰⲦⲚ ⲀⲦⲈⲦⲚϪⲞⲞⲨ ϢⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ⲀⲨⲰ ⲀϤⲢⲘⲚⲦⲢⲈ ⲚⲦⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ⲀⲚⲞⲔ ⲆⲈ ⲚⲈⲒϪⲒ ⲀⲚ ⲚⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲢⲰⲘⲈ. ⲀⲖⲖⲀ ⲚⲀⲒ ⲚⲈⲒϪⲰ ⲘⲘⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ⲚⲈ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲠϨⲎⲂⲤ ⲈⲦⲘⲞⲨϨ ⲀⲨⲰ ⲈⲦⲢⲞⲨⲞⲒⲚ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲀⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲦⲈⲖⲎⲖ ⲘⲘⲰⲦⲚ ⲠⲢⲞⲤ ⲞⲨⲞⲨⲚⲞⲨ ϨⲘ ⲠⲈϤⲞⲨⲞⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ⲀⲚⲞⲔ ⲆⲈ ⲞⲨⲚⲦⲀⲒ ⲘⲘⲀⲨ ⲚⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲈⲚⲀⲀⲀⲤ ⲈⲦⲀ ⲒⲰϨⲀⲚⲚⲎⲤ. ⲚⲈϨⲂⲎⲨⲈ ⲄⲀⲢ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ⲦⲀⲀⲨ ⲚⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈϪⲞⲔⲞⲨ ⲈⲂⲞⲖ ⲚⲦⲞⲞⲨ ⲚⲈϨⲂⲎⲨⲈ ⲈϮⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲤⲈⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲒ ϪⲈ ⲠⲒⲰⲦ ⲠⲈ ⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ⲀⲨⲰ ⲠⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚⲦⲞϤ ⲠⲈ ⲚⲦⲀϤⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲒ. ⲞⲨⲦⲈ ⲘⲠⲈⲦⲚⲤⲰⲦⲘ ⲈⲤⲘⲎ ⲚⲦⲀϤ ⲈⲚⲈϨ ⲞⲨⲦⲈ ⲘⲠⲈⲦⲚⲚⲀⲨ ⲈϨⲢⲂ ⲚⲦⲀϤ ");
INSERT INTO copshc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ⲀⲨⲰ ⲘⲘⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲘⲠⲈϤϢⲀϪⲈ ⲈϤϢⲞⲞⲠ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϪⲈ ⲠⲈⲚⲦⲀⲠⲎ ⲦⲚⲚⲞⲞⲨϤ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ϨⲞⲦϨⲦ ⲚⲚⲈⲄⲢⲀⲪⲎ. ϪⲈ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲀⲨⲰ ⲚⲈⲦⲘⲘⲀⲨ ⲚⲈⲦⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲞⲨⲰϢ ⲀⲚ ⲈⲈⲒ ϢⲀⲢⲞⲒ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϪⲒ ⲘⲠⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ⲚⲈⲒϪⲒ ⲈⲞⲞⲨ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ⲀⲖⲖⲀ ⲀⲒⲤⲞⲨⲚ ⲦⲎⲨⲦⲚ ϪⲈ ⲘⲚⲦⲎⲦⲚ ⲦⲀⲄⲀⲠⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ⲀⲚⲞⲔ ⲀⲒⲈⲒ ϨⲘ ⲠⲢⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲘⲠⲈⲦⲚϪⲒⲦ. ⲈϢⲀⲢⲈ ⲔⲈⲞⲨⲀ ⲈⲒ ϨⲘ ⲠⲈϤⲢⲀⲚ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ⲠⲈⲦⲘⲘⲀⲨ ⲦⲈⲦⲚⲀϪⲒⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ⲚⲀϢ ⲚϨⲈ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲀϢ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲦⲈⲦⲚϪⲒ ⲈⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲀⲨⲰ ⲠⲈⲞⲞⲨ ⲠⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲒⲞⲨⲀ ⲚⲞⲨⲰⲦ ⲈⲚⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ⲘⲠⲢⲘⲈⲈⲨⲈ ϪⲈ ⲀⲚⲞⲔ ⲈⲦⲚⲀⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲰⲦⲚ ⲚⲚⲀϨⲢⲘ ⲠⲒⲰⲦ. ϤϢⲞⲞⲠ ⲚϬⲒ ⲠⲈⲦⲚⲀⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲰⲦⲚ ⲘⲰⲨⲤⲎⲤ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚϨⲈⲖⲠⲒⲌⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ⲈⲚⲈⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲄⲀⲢ ⲈⲘⲰⲨⲤⲎⲤ. ⲚⲈⲦⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲒ ⲠⲈ. ⲀⲠ ⲈⲦⲘⲘⲀⲨ ⲄⲀⲢ ⲤϨⲀⲒ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ⲈϢϪⲈ ⲚⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲆⲈ ⲀⲚ ⲈⲚⲈⲤϨⲀⲒ ⲘⲠ ⲈⲦⲘⲘⲀⲨ ⲚⲀϢ ⲚϨⲈ ⲦⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲀϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀⲒⲎⲤⲞⲨⲤ ⲂⲰⲔ ⲈⲠⲒⲔⲢⲞ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲚⲦⲒⲂⲈⲢⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ⲚⲈⲨⲚ ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲈⲚⲀϢⲰϤ ⲞⲨⲎϨ ⲚⲤⲰϤ ϪⲈ ⲚⲈⲨⲚⲀⲨ ⲠⲈ ⲈⲘⲘⲀⲒⲚ ⲈⲚⲈϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲈϪⲚ ⲚⲈⲦϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲦⲞⲞⲨ ⲀϤϨⲘⲞⲞⲤ ⲘⲘⲀⲨ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ⲚⲈϤϨⲎⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲠⲀⲤⲬⲀ ⲠϢⲀ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲀϤϤⲒ ⲚⲈϤⲂⲀⲖ ⲈϨⲢⲀⲒ ⲀϤⲚⲀⲨ ϪⲈ ⲞⲨⲚ ⲞⲨⲚⲞϬ ⲘⲘⲎⲎϢⲈ ⲚⲎⲨ ϢⲀⲢⲞϤ. ⲠⲈϪⲀϤ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ. ϪⲈ ⲈⲚⲚⲀϢⲈⲠ ⲞⲈⲒⲔ ⲦⲰⲚ ϪⲈ ⲈⲢⲈ ⲚⲀⲒ ⲚⲀⲞⲨⲰⲘ ");
INSERT INTO copshc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ⲚⲦⲀϤϪⲈⲠⲀⲒ ⲆⲈ ⲈϤⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲞϤ. ⲚⲦⲞϤ ⲄⲀⲢ ⲚⲈϤⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈⲦϤⲚⲀⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ⲘⲚϢⲎⲦ ⲚⲤⲀⲦⲈⲈⲢⲈ ⲚⲞⲒⲔ ⲚⲀⲢⲀϢⲦⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϪⲒ ⲞⲨⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ⲠⲈϪⲈ ⲞⲨⲀ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲀⲚⲆⲢⲈⲀⲤ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ϪⲈ ⲞⲨⲚ ⲞⲨϢⲎⲢⲈ ϢⲎⲘ ⲘⲠⲈⲒⲘⲀ ⲈⲨⲚ ϮⲞⲨ ⲚⲞⲒⲔ ⲚⲒⲰⲦ ⲚⲦⲞⲞⲦϤ ⲚⲘ ⲦⲂⲦ ⲤⲚⲀⲨ. ⲀⲖⲖⲀ ⲚⲀⲒ ⲈⲨⲚⲀⲢ ⲞⲨ ⲘⲠⲈⲒⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲘⲀⲢⲈ ⲚⲢⲰⲘⲈ ⲚⲞϪⲞⲨ ⲚⲈⲨⲚ ⲞⲨⲬⲞⲢⲦⲞⲤ ⲆⲈ ⲈⲚⲀϢⲰϤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲢⲰⲘⲈ ϬⲈ ⲚⲞϪⲞⲨ ⲈⲨⲚⲀⲢ ⲀϮⲞⲨ ⲚϢⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲀϤϪⲒ ⲚⲚⲞⲒⲔ ⲀⲨⲰ ⲀϤϢⲠϨⲘⲞⲦ ⲀϤϮ ⲚⲚⲈⲦⲚⲎϪ. ⲀⲨⲰ ⲞⲚ ⲠⲈⲚⲦⲀⲨϪⲒⲦϤ ⲈⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ⲚⲦⲈⲢⲞⲨⲤⲈⲒ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲚⲚⲖⲀⲔⲘ ⲈⲚⲦⲀⲨⲤⲈⲈⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲖⲀⲀⲨ ϨⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ⲀⲨⲤⲞⲞⲨϨⲞⲨ ϬⲈ ⲀⲨⲰ ⲀⲨⲘⲈϨ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲔⲞⲦ ⲚⲖⲀⲔⲘ ⲈⲀⲨⲢϨⲞⲨⲞ ⲈⲚⲈⲚⲦⲀⲨⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲘ ⲠϮⲞⲨ ⲚⲞⲒⲔ ⲚⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ⲚⲢⲰⲘⲈ ϬⲈ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲘⲀⲒⲚ ⲈⲚⲦⲀϤⲀⲀϤ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲚⲀⲘⲈ ⲠⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲚⲎⲨ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ϪⲈ ⲤⲈⲚⲎⲨ ⲚⲤⲈⲦⲞⲢⲠϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲀⲀϤ ⲚⲢⲢⲞ. ⲀϤⲤⲈϨⲦϤ ⲞⲚ ⲈϨⲢⲀⲈⲒ ⲈϪⲘ ⲠⲦⲞⲞⲨ ⲘⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ⲚⲦⲈⲢ ⲈⲢⲞⲨϨⲈ ⲆⲈ ϢⲰⲠⲈ. ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲐⲀⲖⲀⲤⲤⲀ ");
INSERT INTO copshc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ⲀⲨⲰ ⲀⲨⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲈⲦⲢⲈⲨⲈⲒ ⲈⲠⲒⲔⲢⲞ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ⲚⲈ ⲀⲠⲔⲀⲔⲈ ⲆⲈ ϢⲰⲠⲈ ⲈⲘⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲒ ϢⲀⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ⲈⲢⲈ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲦⲎⲨ ⲚⲂⲞⲖ ⲀⲐⲀⲖⲀⲤⲤⲀ ⲦⲰⲞⲨⲚ ⲈϨⲢⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ⲚⲦⲈⲢⲞⲨϨⲒⲚⲈ ϬⲈ ⲈⲂⲞⲖ ⲚⲀϪⲞⲨⲦⲎ ⲚⲤⲦⲀⲆⲒⲞⲚ ⲎⲘⲀⲀⲂ. ⲀⲨⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲘⲞⲞϢⲈ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲈⲀϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲠϪⲞⲈⲒ ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲘⲠⲢⲢϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ⲚⲈⲨⲞⲨⲰϢ ϬⲈ ⲠⲈ ⲈⲦⲀⲖⲞϤ ⲈⲠϪⲞⲈⲒ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲠϪⲞⲈⲒ ⲘⲞⲞⲚⲈ ⲈⲠⲈⲔⲢⲞ ⲈⲚⲈⲨⲚⲀⲂⲰⲔ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ⲠⲈϤⲢⲀⲤⲦⲈ ⲠⲘⲎⲎϢⲈ ⲈⲦⲀϨⲈⲢⲀⲦϤ ϨⲒ ⲠⲒⲔⲢⲞ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲚⲀⲨ ϪⲈ ⲘⲘⲚ ϬⲈϪⲞⲒ ⲘⲘⲀⲨ ⲚⲤⲀ ⲠⲎ ⲈⲚⲦⲀ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲖⲈ ⲈⲢⲞϤ ⲀⲨⲰ ϪⲈ ⲘⲠⲈⲒⲤ ⲀⲖⲈ ⲈⲠϪⲞⲒ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲖⲖⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲘⲘⲀⲨ ⲀⲀⲨ ⲚⲈ ⲚⲦⲀⲨⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ⲀⲨⲰ ⲈⲒⲤ ϨⲈⲚⲔⲈⲈϪⲎⲨ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲒⲂⲈⲢⲒⲀⲤ ϨⲀⲦⲘ ⲠⲘⲀ ⲈⲚⲦⲀⲨⲞⲨⲈⲘ ⲠⲞⲈⲒⲔ ⲈⲀ ⲠϪⲞⲈⲒⲤ ϢⲠϨⲘⲞⲦ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ⲚⲦⲈⲢⲈ ⲠⲘⲎⲎϢⲈ ϬⲈ ⲚⲀⲨ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨ ⲀⲚ ⲞⲨⲆⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲀⲨⲀⲖⲈ ⲚⲦⲞⲞⲨ ⲈⲚⲈϪⲎⲨ ⲀⲨⲈⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲈⲨϢⲒⲚⲈ ⲚⲤⲀⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϨⲈ ⲈⲢⲞϤ ϨⲒ ⲠⲒⲔⲢⲞ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲚⲦⲀⲔⲈⲒ ⲈⲠⲈⲈⲒⲘⲀ ⲚⲀϢ ⲚⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲚⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲀⲚ ϪⲈ ⲀⲦⲈⲦⲚⲚⲀⲨ ⲈϨⲈⲚⲘⲀⲒⲚ ⲀⲖⲖⲀ ϪⲈ ⲀⲦⲈⲦⲚⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲞⲒⲔ ⲀⲨⲰ ⲀⲦⲈⲦⲚⲤⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ⲘⲠⲢⲢϨⲰⲂ ⲈⲦⲈϨⲢⲈ ⲈⲦⲚⲀⲦⲀⲔⲞ. ⲀⲖⲖⲀ ⲦⲈϨⲢⲈ ⲚⲦⲞϤ ⲈⲦⲚⲀⲘⲞⲨⲚ ⲈⲂⲞⲖ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲦⲀⲒ ⲈⲦⲈⲢⲈ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲚⲀⲦⲀⲀⲤ ⲚⲎⲦⲚ. ⲠⲀⲒ ⲄⲀⲢ ⲠⲈ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲒⲰⲦ ⲤⲪⲢⲀⲄⲒⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ. ϪⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲀⲀϤ ϪⲈⲔⲀⲀⲤ ⲈⲚⲈⲢϨⲰⲂ ⲈⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠϨⲰⲂ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲚⲦⲀⲠⲎ ⲦⲚⲚⲞⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲞⲨ ϬⲈ ⲚⲦⲞⲔ ⲘⲘⲀⲒ ⲚⲠⲈⲦⲔⲈⲒⲢⲈ ⲘⲘⲞϤ ϪⲈⲔⲀⲀⲤ ⲈⲚⲈⲚⲀⲨ ⲀⲨⲰ ⲚⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲔ. ⲞⲨ ⲠⲈ ⲠϨⲰⲂ ⲈⲦⲔⲈⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ⲀⲚⲈⲚⲈⲒⲞⲦⲈ ⲞⲨⲰⲘ ⲘⲠⲘⲀⲚⲚⲀ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ. ⲔⲀⲦⲀⲐⲈ ⲈⲦⲤⲎϨ. ϪⲈ ⲀϤϮ ⲚⲀⲨ ⲚⲞⲨⲞⲒⲔ ⲈⲨⲞⲘϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲀⲨ. ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲰⲨⲤⲎⲤ ⲀⲚ ⲠⲈ ⲚⲦⲀϤϮ ⲚⲎⲦⲚ ⲘⲠⲞⲈⲒⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ⲀⲖⲖⲀ ⲠⲀⲒⲰⲦ ⲠⲈⲦϮ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲘⲠⲞⲈⲒⲔ ⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ⲠⲞⲈⲒⲔ ⲄⲀⲢ ⲠⲈ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲚⲎⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ⲚϤϮ ⲚⲞⲨⲰⲚϨ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲀ ⲚⲀⲚ ⲘⲠⲞⲈⲒⲔ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲀⲨ. ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲈⲒⲔ ⲘⲠⲰⲚϨ. ⲠⲈⲦⲚⲎⲨ ϢⲀⲢⲞⲒ ⲚϤⲚⲀϨⲔⲞ ⲀⲚ ⲀⲨⲰ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲚϤⲚⲀⲈⲒⲂⲈ ⲀⲚ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ⲀⲖⲖⲀ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ. ϪⲈ ⲀⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈⲢⲈ ⲠⲀⲈⲒⲰⲦ ⲚⲀⲦⲀⲀϤ ⲚⲀⲒ ϤⲚⲎⲨ ϢⲀⲢⲞⲒ. ⲀⲨⲰ ⲠⲈⲦⲚⲎⲨ ϢⲀⲢⲞⲒ ⲚϮⲚⲀⲚⲞϪϤ ⲀⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ϪⲈ ⲚⲦⲀⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈⲦⲢⲀⲈⲒⲢⲈ ⲀⲚ ⲘⲠⲀⲞⲨⲰϢ ⲀⲖⲖⲀ ⲠⲞⲨⲰϢ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ⲠⲀⲒ ⲆⲈ ⲠⲈ ⲠⲞⲨⲰϢ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ ϪⲈⲔⲀⲀⲤ ⲚⲈⲚⲦⲀϤⲦⲀⲀⲨ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲚⲀⲦⲀⲔⲞ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲀⲖⲖⲀ ⲈⲒⲈⲦⲞⲨⲚⲞⲞⲨⲤⲞⲨ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ⲠⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲞⲨⲰϢ ⲘⲠⲀⲒⲰⲦ ϪⲈⲔⲀⲀⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲨ ⲈⲠϢⲎⲢⲈ ⲀⲨⲰ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈϤⲈϪⲒ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀⲦⲞⲨⲚⲞⲤϤ ⲘⲠϨⲀⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ⲚⲈⲨⲔⲢⲘⲢⲘ ϬⲈ ⲠⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲦⲂⲎⲎⲦϤ ϪⲈ ⲀϤϪⲞⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲒⲔ ⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠⲀⲒ ⲀⲚ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲈ ⲚⲒⲰⲤⲎⲪ ⲠⲀⲒ ⲀⲚⲞⲚ ⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲠⲈϤⲈⲒⲰⲦ ⲚⲘ ⲦⲈϤⲘⲀⲀⲨ. ⲚⲀϢ ϬⲈ ⲚϨⲈ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲘⲠⲢⲔⲢⲘⲢⲘ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ⲘⲘⲚ ϢϬⲞⲘ ⲖⲖⲀⲀⲨ ⲈⲈⲒ ϢⲀⲢⲞⲈⲒ ⲈⲒ ⲘⲎⲦⲒ ⲚⲦⲈ ⲠⲀⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲤⲰⲔ ⲘⲘⲞϤ ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰ ⲦⲀⲦⲞⲨⲚⲞⲤϤ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ϤⲤⲎϨ ϨⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲤⲈⲚⲀϢⲰⲠⲈ ⲦⲎⲢⲞⲨ ⲚⲢⲈϤϮⲤⲂⲰ ⲚⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀϤⲤⲰⲦⲘ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲀϤϪⲒ ⲤⲂⲰ ϤⲚⲎⲨ ϢⲀⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ⲚⲚⲈⲂⲞⲖ ⲀⲚ ϪⲈ ⲀⲞⲨⲀ ⲚⲀⲨ ⲈⲠⲒⲰⲦ ⲈⲒ ⲘⲎⲦⲒ ⲠⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲠⲈ ⲚⲦⲀϤⲚⲀⲨ ⲈⲠⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲒⲔ ⲘⲠⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ⲀⲚⲈⲦⲚⲈⲒⲞⲦⲈ ⲞⲨⲰⲘ ⲘⲠⲘⲀⲚⲚⲀ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ ⲀⲨⲰ ⲀⲨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ⲠⲀⲒ ⲆⲈ ⲠⲈ ⲠⲞⲒⲔ ⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀⲞⲨⲀ ⲞⲨⲰⲘ ⲈⲂⲞⲖ ⲚϨⲎ ⲦϤ ⲚⲚⲈϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲒⲔ ⲈⲦⲞⲚϨ ⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ⲈⲢϢⲀⲚ ⲞⲨⲀ ⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲞⲒⲔ ϤⲚⲀⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ⲠⲞⲒⲔ ⲆⲈ ⲈϮⲚⲀⲦⲀⲀϤ ⲀⲚⲞⲔ ⲠⲈ ⲦⲀⲤⲀⲢⲜ ϨⲀ ⲠⲰⲚϨ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲚⲈⲨⲘⲒϢⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲈⲢⲈ ⲠⲀⲒ ⲚⲀϢ ϮⲚⲀⲚ ⲚⲦⲈϤⲤⲀⲢⲜ ⲈⲨⲞⲘⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲦⲈⲦⲚⲦⲘⲞⲨⲰⲘ ⲚⲦⲤⲀⲢⲜ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲤⲰ ⲘⲠⲈϤⲤⲚⲞϤ. ⲘⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲘⲠⲰⲚϨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ⲠⲈⲦⲞⲨⲰⲘ ⲚⲦⲀⲤⲀⲢⲜ ⲀⲨⲰ ⲈⲦⲤⲰ ⲘⲠⲀⲤⲚⲞϤ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀⲦⲞⲨⲚⲞⲤϤ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ⲦⲀⲤⲀⲢⲜ ⲄⲀⲢ ⲞⲨϨⲢⲈ ⲘⲘⲈⲈ ⲦⲈ ⲀⲨⲰ ⲠⲀⲤⲚⲞϤ ⲞⲨⲤⲰ ⲘⲘⲈⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ⲠⲈⲦⲞⲨⲰⲘ ⲚⲦⲀⲤⲀⲢⲜ ⲀⲨⲰ ⲈⲦⲤⲰ ⲘⲠⲀⲤⲚⲞϤ ϤⲚⲀϬⲰ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚϬⲒ ⲠⲒⲰⲦ ⲈⲦⲞⲚϨ ⲀⲚⲞⲔ ϨⲰ ϮⲞⲚϨ ⲈⲦⲂⲈ ⲠⲒⲰⲦ. ⲀⲨⲰ ⲠⲈⲦⲚⲀⲞⲨⲞⲘⲚⲦ ⲠⲈⲦⲘⲘⲀⲨ ϨⲰⲰϤ ⲞⲚ ⲚⲀⲰⲚϨ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ⲠⲀⲒ ⲠⲈ ⲠⲞⲒⲔ ⲈⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ⲚⲔⲀⲦⲀ ⲐⲈ ⲀⲚ ⲈⲚⲦ ⲀⲚⲒⲞⲦⲈ ⲞⲨⲰⲘ ⲀⲨⲰ ⲀⲨⲘⲞⲨ. ⲠⲈⲦⲚⲀⲞⲨⲰⲘ ⲘⲠⲈⲒⲞⲒⲔ ϤⲚⲀⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ⲚⲀⲒ ⲀϤϪⲞⲞⲨ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲈϤϮⲤⲂⲰ ϨⲚ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ϨⲀϨ ϬⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲠⲈϪⲀⲨ. ϪⲈ ⲠⲈⲒϢⲀϪⲈ ⲚⲀϢⲦ ⲚⲒⲘ ⲠⲈⲦⲚⲀϢ ⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ⲈϤⲤⲞⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ϪⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲔⲢⲘⲢⲘ ⲈⲦⲂⲎⲎⲦϤ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲠⲀⲒ ⲠⲈⲦⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ⲈⲦⲈⲦⲚϢⲀⲚⲚⲀⲨ ϬⲈ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲚⲀ ⲈϨⲢⲀⲒ ⲈⲠⲘⲀ ⲈⲚⲈϤⲚϨⲎⲦϤ ⲚϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ⲠⲈⲠⲚⲈⲨⲘⲀ ⲠⲈⲦⲦⲀⲚϨⲞ. ⲚⲦⲤⲀⲢⲜ ϮϨⲎⲨ ⲀⲚ ⲖⲖⲀⲀⲨ. ⲚϢⲀϪⲈ ⲀⲚⲞⲔ ⲈⲚⲦⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲠⲈ ⲀⲨⲰ ⲞⲨⲰⲚϨ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ⲀⲖⲖⲀ ⲞⲨⲚ ϨⲞⲒⲚⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲈⲚⲤⲈⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ. ⲚⲈϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲚⲈⲦⲈ ⲚⲤⲈⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ⲀⲨⲰ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ⲀⲨⲰ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲘⲚϢ ϬⲞⲘ ⲖⲖⲀⲀⲨ ⲈⲈⲒ ϢⲀⲢⲞⲒ. ⲈⲒ ⲘⲎⲦⲒ ⲚⲤⲈⲦⲀⲀⲤ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀϨⲀϨ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲂⲰⲔ ⲈⲠⲀϨⲞⲨ ⲀⲨⲰ ⲀⲨⲖⲞ ⲈⲨⲘⲞⲞϢⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ϪⲈ ⲘⲎ ⲚⲦⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲚⲚⲀⲂⲰⲔ ϢⲀ ⲚⲒⲘ ϨⲈⲚϢⲀϪⲈ ⲚⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲚⲈⲦⲚⲦⲞⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ⲀⲨⲰ ⲀⲚⲞⲚ ⲀⲚⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲀⲚⲈⲒⲘⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ. ϪⲈ ⲘⲎ ⲀⲚⲞⲔ ⲀⲚ ⲀⲒⲤⲈⲦⲠ ⲦⲎⲨⲦⲚ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ. ⲀⲨⲰ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲞⲨⲆⲒⲀⲂⲞⲖⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲠⲈ ⲈⲦⲂⲈ ⲒⲞⲨⲆⲀⲤ ⲠϢⲎⲢⲈ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ. ⲠⲀⲒ ⲄⲀⲢ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲈⲞⲨⲀ ⲠⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲚⲈϤⲘⲞⲞϢⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲚⲈϤⲞⲨⲰϢ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲈⲘⲞⲞϢⲈ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ϪⲈ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲘⲞⲞⲨⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ⲚⲈϤϨⲎⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠϢⲀ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲈⲤⲔⲎⲚⲞⲠⲎⲄⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲚⲈϤⲤⲚⲎⲨ. ϪⲈ ⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲀ ⲚⲄⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈϮⲞⲨⲆⲀⲒⲀ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ϨⲰⲞⲨ ⲚⲀⲨ ⲈⲚⲈⲔϨⲂⲎⲨⲈ ⲈⲦⲔⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ⲘⲈⲢⲈ ⲖⲀⲀⲨ ⲄⲀⲢ ⲢϨⲰⲂ ϨⲘ ⲠϨⲰⲠ ⲀⲨⲰ ⲚϤϢⲒⲚⲈ ⲚⲦⲞϤ ⲚⲤⲀ ϢⲰⲠⲈ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ. ⲈϢϪⲈ ⲔⲈⲒⲢⲈ ⲚⲚⲀⲒ. ⲞⲨⲞⲚϨⲔ ⲈⲂⲞⲖ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ⲚⲈⲢⲈ ⲚⲈϤⲔⲈⲤⲚⲎⲨ ⲄⲀⲢ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ⲠⲈϪⲀϤ ϬⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲠⲀⲞⲨⲞⲒϢ ⲀⲚⲞⲔ ⲘⲠⲀⲦϤⲈⲒ. ⲠⲈⲦⲚⲞⲨⲞⲒϢ ⲆⲈ ⲚⲦⲰⲦⲚ ⲤⲂⲦⲰⲦ ⲚⲤⲎⲨ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ⲘⲚ ϢϬⲞⲘ ⲈⲦⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲘⲈⲤⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲚⲞⲔ ⲆⲈ ϤⲘⲞⲤⲦⲈ ⲘⲘⲞⲒ ϪⲈ ϮⲢⲘⲚⲦⲢⲈ ⲀⲚⲞⲔ ⲈⲦⲂⲎⲎⲦϤ ϪⲈ ⲚⲈϤϨⲂⲎⲨⲈ ⲤⲈϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ⲚⲦⲰⲦⲚ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠϢⲀ. ⲀⲚⲞⲔ ⲆⲈ ⲘⲠⲀϮⲚⲞⲨ ⲈⲈⲒ ⲈⲠⲈⲈⲒϢⲀ. ϪⲈ ⲘⲠⲀⲦⲈ ⲠⲀⲞⲨⲞⲒϢ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲆⲈ ⲚⲦⲞϤ ⲀϤϬⲰ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ⲚⲦⲈⲢⲈ ⲚⲈϤⲤⲚⲎⲨ ⲆⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠϢⲀ. ⲦⲞⲦⲈ ⲚⲦⲞϤ ϨⲰⲰϤ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ϨⲚ ⲞⲨⲰⲚϨ ⲀⲚ ⲈⲂⲞⲖ ⲀⲖⲖⲀ ϨⲚ ⲞⲨϨⲰⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲚⲈⲨϢⲒⲚⲈ ⲚⲤⲰϤ ⲠⲈ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϤⲦⲰⲚ ⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ⲀⲨⲰ ⲚⲈⲢⲈ ⲞⲨⲔⲢⲘⲢⲘ ⲈⲚⲀϢⲰϤ ϢⲞⲞⲠ ⲈⲦⲂⲎⲎⲦϤ ϨⲚ ⲘⲘⲎⲎϢⲈ ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲄⲀⲐⲞⲤ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲈϤⲠⲖⲀⲚⲀ ⲘⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ⲚⲈ ⲘⲘⲚ ⲖⲀⲀⲨ ⲘⲈⲚⲦⲞⲒ ϢⲀϪⲈ ⲈⲦⲂⲎⲎ ⲦϤ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲈⲦⲂⲈ ⲐⲞⲦⲈ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ϨⲚ ⲦⲘⲎⲦⲈ ⲆⲈ ⲘⲠϢⲀ ⲀⲒⲎⲤⲞⲨⲤ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲢⲠⲈ ⲀϤϮⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ⲚⲈⲨⲢϢⲠⲎⲢⲈ ϬⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲠⲀⲒ ⲤⲞⲞⲨⲚ ⲚⲤϨⲀⲒ ⲈⲘⲠⲞⲨⲦⲤⲀⲂⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀⲤⲂⲰ ⲀⲚⲞⲔ ⲚⲦⲰⲒ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲦⲀ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ⲈⲢϢⲀ ⲞⲨⲀ ⲢϨⲚⲀϤ ⲈⲈⲒⲢⲈ ⲘⲠⲈϤⲞⲨⲰϢ ϤⲚⲀⲈⲒⲘⲈ ⲈⲦⲂⲈ ⲦⲈⲒⲤⲂⲰ ϪⲈⲚ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ ⲦⲈ. ϪⲈⲚ ⲀⲚⲞⲔ ⲈⲈⲒϢⲀϪⲈ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ⲠⲈⲦϢⲀϪⲈ ϨⲀⲢⲞϤ ⲘⲀⲨⲀⲀϤ ⲈϤϢⲒⲚⲈ ⲚⲤⲀ ⲠⲈϤⲈⲞⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ⲠⲈⲦϢⲒⲚⲈ ⲆⲈ ⲚⲦⲞϤ ⲚⲤⲀ ⲠⲈⲞⲞⲨ ⲘⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨϤ ⲠⲀⲒ ⲞⲨⲘⲈⲈ ⲠⲈ ⲀⲨⲰ ⲘⲚ ϪⲒ ⲚϬⲞⲚⲤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ⲘⲎ ⲘⲰⲨⲤⲎⲤ ⲀⲚ ⲠⲈ ⲚⲦⲀϤϮ ⲚⲎⲦⲚ ⲘⲠⲚⲞⲘⲞⲤ. ⲀⲨⲰ ⲘⲘⲚ ⲖⲀⲀⲨ ⲘⲘⲰⲦⲚ ⲈⲒⲢⲈ ⲘⲠⲚⲞⲘⲞⲤ. ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲀ ⲘⲞⲨⲞⲨⲦ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ. ϪⲈ ⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲠⲈⲦⲚⲘⲘⲀⲔ. ⲚⲒⲘ ⲠⲈⲦϢⲒⲚⲈ ⲚⲤⲀ ⲘⲞⲞⲨⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲞⲨϨⲰⲂ ⲚⲞⲨⲰⲦ ⲠⲈ ⲚⲦⲀⲒⲀⲀϤ ⲀⲨⲰ ⲦⲈⲦⲚⲢϢⲠⲎⲢⲈ ⲦⲎⲢⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲘⲰⲨⲤⲎⲤ ϮⲚⲎⲦⲚ ⲘⲠⲤⲂⲂⲈ. ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲘⲰⲨⲤⲎⲤ ⲠⲈ ⲀⲖⲖⲀ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲚⲒⲞⲦⲈ ⲠⲈ. ⲀⲨⲰ ⲦⲈⲦⲚⲤⲂⲂⲈ ⲢⲰⲘⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ⲈϢϪⲈ ϢⲀⲢⲈ ⲢⲰⲘⲈ ϪⲒ ⲤⲂⲂⲈ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϪⲈ ⲚⲚⲈϤⲂⲰⲖ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ. ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲚⲞϬⲤ ⲈⲢⲞⲈⲒ ϪⲈ ⲀⲈⲒⲦⲞⲨ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲦⲎⲢϤ ϨⲘ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ⲘⲠⲢⲔⲢⲒⲚⲈ ⲔⲀⲦⲀ ⲞⲨⲘⲚⲦⲢⲈϤϪⲒ ϨⲞ. ⲀⲖⲖⲀ ⲔⲢⲒⲚⲈ ⲘⲠϨⲀⲠ ⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ⲚⲈⲨⲚ ϨⲞⲒⲚⲈ ϬⲈ ϪⲰ ⲘⲘⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲢⲘⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ϪⲈ ⲘⲎ ⲘⲠⲀⲒ ⲀⲚ ⲠⲈⲦⲞⲨϢⲒⲚⲈ ⲚⲤⲰϤ ⲈⲘⲞⲞⲨⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲠⲈ ϤϢⲀϪⲈ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲀⲨⲰ ⲚⲤⲈϪⲈ ⲖⲀⲀⲨ ⲚⲀϤ ⲀⲚ. ⲘⲎⲠⲰⲤ ⲀⲨⲈⲒⲘⲈ ⲚⲀⲘⲈ ⲚϬⲒ ⲚⲀⲢⲬⲰⲚ ⲀⲨⲰ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ⲀⲖⲖⲀ ⲠⲀⲒ ⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲚⲦⲞϤ ⲈϤϢⲀⲚⲈⲒ ⲘⲚⲖⲀⲀⲨ ⲚⲀⲈⲒⲘⲈ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲀϤϪⲒ ϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ ⲈϤϮⲤⲂⲰ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲒ ⲀⲨⲰ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ. ⲀⲨⲰ ⲚⲦⲀⲒⲈⲒ ⲀⲚ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ ⲀⲖⲖⲀ ⲞⲨⲘⲈ ⲠⲈ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲈⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ⲀⲚⲞⲔ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ϮϢⲞⲞⲠ ϨⲀ ϨⲦⲎϤ ⲀⲨⲰ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ⲚⲈⲨϢⲒⲚⲈ ϬⲈ ⲚⲤⲀ ϬⲞⲠϤ ⲠⲈ ⲀⲨⲰ ⲘⲠⲈ ⲖⲀⲀⲨ ⲚⲦⲈϤϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲦⲈϤⲞⲨⲚⲞⲨ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ⲀϨⲀϨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢϢⲀⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲒ ⲘⲎ ⲈϤⲚⲀⲢϨⲞⲨⲞ ⲈⲘⲘⲀⲒⲚ ⲈⲚⲦⲀ ⲠⲀⲒ ⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ⲀⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϬⲈ ⲤⲰⲦⲘ ⲈⲠⲘⲎⲎϢⲈ ⲈⲨⲔⲢⲘⲢⲘ ⲚⲚⲀⲒ ⲈⲦⲂⲎⲎⲦϤ. ⲀⲨⲰ ⲀⲨϪⲞⲞⲨ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϨⲈⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϬⲞⲠϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ⲠⲈϪⲀϤ ϬⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲈⲦⲒ ⲔⲈⲔⲞⲨⲒ ⲚⲞⲨⲞⲒϢ ⲠⲈϮϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ ⲀⲨⲰ ϮⲚⲀⲂⲰⲔ ϢⲀ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ⲦⲈⲦⲚⲀϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲚⲦⲈⲦⲚ ⲦⲘϨⲈ ⲈⲢⲞⲈⲒ. ⲀⲨⲰ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲘⲘⲞϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲀϢⲈⲒ ⲀⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ⲠⲈϪⲈ ⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲚⲚⲈⲨⲈⲢⲎⲨ. ϪⲈ ⲈⲢⲈ ⲠⲀⲒ ⲚⲀⲂⲰⲔ ⲈⲦⲰⲚ ϪⲈ ⲀⲚⲞⲚ ⲚⲦⲚⲚⲀϨⲈ ⲀⲚ ⲈⲢⲞϤ. ⲘⲎ ⲈϤⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲆⲒⲀⲤⲠⲞⲢⲀ ⲚⲚϨⲈⲖⲖⲎⲚ ⲚϤϮⲤⲂⲰ ⲚⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ⲞⲨ ⲠⲈ ⲠⲈⲒϢⲀϪⲈ ⲈⲚⲦⲀϤϪⲞⲞϤ ϪⲈ ⲦⲈⲦⲚⲀϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲚⲦⲈⲦⲚ ⲦⲘϨⲈ ⲈⲢⲞⲈⲒ. ⲀⲨⲰ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮ ⲘⲘⲞϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲀϢⲈⲒ ⲀⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ϨⲢⲀⲒ ⲆⲈ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ ⲚⲞϬ ⲚⲦⲈ ⲠϢⲀ ⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲀϨⲈⲢⲀⲦϤ ⲀⲨⲰ ⲚⲈϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲞⲂⲈ ⲘⲀⲢⲈϤⲈⲒ ϢⲀⲢⲞⲈⲒ ⲚϤⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲦⲈⲄⲢⲀⲪⲎ ϪⲞⲞⲤ ⲞⲨⲚ ϨⲈⲚⲈⲒⲈⲢⲰⲞⲨ ⲚⲀϨⲀⲦⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ⲘⲘⲞⲞⲨ ⲈϤⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ⲚⲦⲀϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲈⲦⲂⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲚⲀϪⲒⲦϤ ⲚϬⲒ ⲚⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲚⲈ ⲘⲠⲀⲦⲞⲨϪⲒ ⲠⲚⲈⲨⲘⲀ ⲄⲀⲢ ⲠⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲈ ⲘⲠⲀⲦϤϪⲒ ⲈⲞⲞⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ϨⲞⲒⲚⲈ ϬⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲈⲚⲈⲒϢⲀϪⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲚⲀⲘⲈ ⲠⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ϨⲞⲒⲚⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲄⲀⲢ ⲈⲢⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ⲚⲦⲀⲦⲈⲄⲢⲀⲪⲎ ⲀⲚ ϪⲞⲞⲤ ϪⲈ ⲈⲢⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲎⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲆⲀⲨⲈⲒⲆ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲂⲎⲐⲖⲈⲈⲘ ⲠϮⲘⲈ ⲈⲚⲈⲢⲈ ⲆⲀⲨⲈⲒⲆ ϢⲞⲞⲠ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ⲀⲨⲠⲰⲢϪ ϬⲈ ϢⲰⲠⲈ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ϨⲞⲒⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲈⲨⲞⲨⲰϢ ⲈϬⲞⲠϤ ⲀⲖⲖⲀ ⲘⲠⲈ ⲖⲀⲀⲨ ⲚⲚⲈϤϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ⲀⲨⲂⲰⲔ ϬⲈ ⲚϬⲒ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ϢⲀ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ⲀⲨⲰ ⲠⲈϪⲈ ⲚⲎ ⲚⲀⲨ. ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲘⲠⲈⲦⲚⲚⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ⲀⲨⲞⲨⲰϢⲂ ⲚϬⲒ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ϪⲈ ⲘⲠⲈ ⲢⲰⲘⲈ ϢⲀϪⲈ ⲈⲚⲈϨ ⲚⲐⲈ ⲘⲠⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ⲀⲨⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ϪⲈ ⲘⲎ ⲚⲦⲀⲦⲈⲦⲚⲠⲖⲀⲚⲀ ϨⲰⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ⲘⲎ ⲀⲖⲀⲀⲨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲢⲬⲰⲚ ⲎⲈⲂⲞⲖ ϨⲚ ⲚⲈⲪⲎⲢⲒⲤⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ⲀⲖⲖⲀ ⲠⲈⲒⲘⲎⲎϢⲈ ⲈⲦⲈ ⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲚⲞⲘⲞⲤ ⲤⲈϢⲞⲞⲠ ϨⲀⲠⲤⲀϨⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ⲠⲈϪⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲚⲀⲨ ⲠⲈⲚⲦⲀϤⲈⲒ ϢⲀ ⲒⲎⲤⲞⲨⲤ ⲚϢⲞⲢⲠ ⲈⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ϪⲈ ⲘⲎ ⲠⲈⲚⲚⲞⲘⲞⲤ ⲚⲀⲔⲢⲒⲚⲈ ⲘⲠⲢⲰⲘⲈ ⲈⲒ ⲘⲎⲦⲒ ⲚϤⲤⲰⲦⲘ ⲈⲢⲞϤ ⲚϢⲞⲢⲠ ⲀⲨⲰ ⲚϤⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲠⲈⲦϤⲈⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲘⲎ ⲚⲦⲔ ⲞⲨⲈⲂⲞⲖ ϨⲰⲰⲔ ⲞⲚ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ϨⲞⲦϨⲦ ⲚⲚⲈⲄⲢⲀⲪⲎ ⲚⲄⲚⲀⲨ ϪⲈ ⲚⲈⲢⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","— ");
INSERT INTO copshc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲞⲚ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲨⲞⲒⲚ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲠⲈⲦⲚⲀⲞⲨⲀϨϤ ⲚⲤⲰⲈⲒ ⲚϤⲚⲀⲘⲞⲞϢⲈ ⲀⲚ ϨⲘ ⲠⲔⲀⲔⲈ ⲀⲖⲖⲀ ϤⲚⲀϪⲒ ⲘⲠⲞⲨⲞⲒⲚ ⲘⲠⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ⲠⲈϪⲈ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϬⲈ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲈⲔⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲔ. ⲦⲈⲔⲘⲚⲦⲘⲚⲦⲢⲈ ⲞⲨⲘⲈ ⲀⲚ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲔⲀⲚ ⲀⲚⲞⲔ ⲈⲈⲒϢⲀⲚⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲈⲒ ⲦⲀⲘⲚⲦⲘⲚⲦⲢⲈ ⲞⲨⲘⲈ ⲦⲈ ϪⲈ ϮⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲦⲰⲚ ⲀⲨⲰ ⲈⲒⲚⲀ ⲈⲦⲰⲚ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲀⲈⲒ ⲦⲰⲚ ⲎⲈⲒⲚⲀ ⲈⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲔⲢⲒⲚⲈ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲀⲠⲞⲔ ⲚϮⲔⲢⲒⲚⲈ ⲀⲚ ⲖⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ⲔⲀⲚ ⲈⲒϢⲀⲚⲔⲢⲒⲚⲈ ⲆⲈ ⲀⲚⲞⲔ ⲦⲀⲔⲢⲒⲤⲒⲤ ⲞⲨⲘⲈⲈ ⲦⲈ ϪⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ⲘⲘⲀⲦⲈ ⲠⲈ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲚⲘ ⲠⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ϤⲤⲎϨ ⲆⲈ ⲞⲚ ϨⲘ ⲠⲈⲦⲚⲚⲞⲘⲞⲤ ϪⲈ ⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲞⲨⲘⲈ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ⲀⲚⲞⲔ ⲠⲈⲦⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲈⲒ ⲀⲨⲰ ϤⲢ ⲘⲚⲦⲢⲈ ⲞⲚ ϨⲀⲢⲞⲒ ⲚϬⲒ ⲠⲈⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲈϤⲦⲰⲚ ⲠⲈⲔⲈⲒⲰⲦ ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲞⲨⲦⲈ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲘⲘⲞⲒ ⲀⲚ ⲞⲨⲦⲈ ⲞⲚ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲈⲚⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲒ ⲚⲈⲦⲈⲦⲚⲀⲤⲞⲨⲚ ⲠⲀⲒⲰⲦ ⲞⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ⲚⲈⲈⲒϢⲀϪⲈ ⲀϤϪⲞⲞⲨ ϨⲘ ⲠⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲈϤϮⲤⲂⲰ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ⲘⲠⲈ ⲖⲀⲀⲨ ϬⲞⲠϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲦⲈϤⲞⲨⲚⲞⲨ ⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ⲠⲈϪⲀϤ ϬⲈ ⲞⲚ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀⲂⲰⲔ ⲀⲨⲰ ⲦⲈⲦⲚⲀϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲀⲨⲰ ⲦⲈⲦⲚⲀⲘⲞⲨ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲦⲚⲚⲞⲂⲈ ⲀⲨⲰ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀⲂⲰⲔ ⲈⲢⲞϤ ⲚⲦⲰⲦⲚ ⲘⲚ ϢϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲈⲒ ⲈⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲘⲎⲦⲒ ⲈϤⲚⲀⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ ϪⲈ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀⲂⲰⲔ ⲈⲢⲞϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲀϢⲈⲒ ⲀⲚ ⲈⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲀⲚⲞⲔ ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲀⲚⲞⲔ ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ⲀⲒϪⲞⲞⲤ ϬⲈ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲀⲘⲞⲨ ϨⲚ ⲚⲈⲦⲚⲚⲞⲂⲈ. ⲈⲦⲈⲦⲚⲦⲘⲠⲒⲤⲦⲈⲨⲈ ⲄⲀⲢ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲦⲈⲦⲚⲀⲘⲞⲨ ϨⲚ ⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲞⲔ ⲚⲦⲔ ⲚⲒⲘ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ϪⲒⲚ ⲚϢⲞⲢⲠ ϮϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ⲈⲨⲚϮ ϨⲀϨ ⲈϪⲰ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲈⲔⲢⲒⲚⲈ. ⲀⲖⲖⲀ ⲞⲨⲘⲈ ⲠⲈ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ⲀⲨⲰ ⲀⲚⲞⲔ ⲚⲈⲚⲦⲀⲒⲤⲞⲦⲘⲞⲨ ⲚⲦⲞⲞⲦϤ ⲚⲀⲒ ⲚⲈϮϪⲰ ⲘⲘⲞⲞⲨ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ⲘⲠⲞⲨⲈⲒⲘⲈ ϪⲈ ⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲠⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ⲠⲈϪⲀϤ ϬⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲞⲦⲀⲚ ⲈⲦⲈⲦⲚϢⲀⲚϪⲒⲤⲈ ⲘⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲦⲞⲦⲈ ⲦⲈⲦⲚⲀⲈⲒⲘⲈ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲰ ⲚϮⲢⲖⲀⲀⲨ ⲀⲚ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ ⲀⲖⲖⲀ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀ ⲠⲀⲈⲒⲰⲦ ⲦⲤⲀⲂⲞⲈⲒ ⲚⲀⲒ ⲚⲈϮϪⲰ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ⲀⲨⲰ ϤϢⲞⲞⲠ ⲚⲘⲘⲀⲒ ⲚϬⲒ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ. ⲀⲨⲰ ⲘⲠϤⲔⲀⲀⲦ ⲘⲘⲀⲨⲀⲀⲦ ϪⲈ ⲀⲚⲞⲔ ϮⲈⲒⲢⲈ ⲚⲚⲈⲦⲢⲀⲚⲀϤ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲞⲨ ⲀϨⲀϨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ϪⲈ ⲈϢⲰⲠⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚϢⲀⲚϬⲰ ϨⲘ ⲠϢⲀϪⲈ. ⲚⲦⲈⲦⲚ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ⲀⲨⲰ ⲦⲈⲦⲚⲀⲤⲞⲨⲚ ⲦⲘⲈ ⲀⲨⲰ ⲦⲘⲈ ⲚⲀⲢ ⲦⲎⲨⲦⲚ ⲚⲢⲘϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ⲠⲈϪⲀⲨ. ϪⲈ ⲀⲚⲞⲚ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀϨⲀⲘ ⲀⲨⲰ ⲘⲠⲚⲢϨⲘϨⲀⲖ ⲖⲖⲀⲀⲨ ⲈⲚⲈϨ. ⲚⲀϢ ⲚϨⲈ ⲚⲦⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲚⲀⲢⲢⲘϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲒⲢⲈ ⲘⲠⲚⲞⲂⲈ ϤⲞ ⲚϨⲘϨⲀⲖ ⲘⲠⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ⲠϨⲘϨⲀⲖ ⲆⲈ ⲚϤⲚⲀϬⲰ ⲀⲚ ϨⲘ ⲠⲎⲒ ϢⲀ ⲈⲚⲈϨ. ⲠϢⲎⲢⲈ ⲆⲈ ⲚⲦⲞϤ ϤⲚⲀϬⲰ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ⲈⲢϢⲀ ⲠϢⲎⲢⲈ ϬⲈ ⲢⲦⲎⲨⲦⲚ ⲢⲢⲘϨⲈ. ⲞⲚⲦⲰⲤ ⲦⲈⲦⲚⲀϢⲰⲠⲈ ⲚⲢⲘϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ϮⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲈⲦⲚ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀϨⲀⲘ. ⲀⲖⲖⲀ ⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲈⲘⲞⲞⲨⲦ ϪⲈ ⲠϢⲀϪⲈ ⲚϤⲞⲨⲎϨ ⲀⲚ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ⲀⲚⲞⲔ ⲚⲈⲚⲦⲀⲒⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲚⲦⲘ ⲠⲀⲒⲰⲦ ⲚⲈϮϪⲰ ⲘⲘⲞⲞⲨ ⲚⲦⲰⲦⲚ ϬⲈ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲚⲈⲚⲦⲀⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲚⲦⲘ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲀⲢⲒⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈⲚⲈⲒⲰⲦ ⲠⲈ ⲀⲂⲢⲀϨⲀⲘ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲈⲚⲈ ⲚⲦⲈⲦⲚ ⲚϢⲎⲢⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲚⲈⲦⲈⲦⲚⲀⲢ ⲚⲈϨⲂⲎⲨⲈ ⲚⲀⲂⲢⲀϨⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ⲦⲈⲚⲞⲨ ⲆⲈ ⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲈⲘⲞⲞⲨⲦ ⲞⲨⲢⲰⲘⲈ ⲈϤϪⲰ ⲚⲎⲦⲚ ⲚⲦⲘⲈ ⲦⲀⲒ ⲈⲚⲦⲀϤⲤⲞⲦⲘⲈⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲘⲠⲈ ⲀⲂⲢⲀϨⲀⲘ ⲢⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲒⲢⲈ ⲚⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲚ ⲚⲦⲀⲨϪⲠⲞⲚ ⲀⲚ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲠⲞⲢⲚⲈⲒⲀ ⲞⲨⲒⲰⲦ ⲚⲞⲨⲰⲦ ⲠⲈⲦϢⲞⲞⲠ ⲚⲀⲚ ⲈⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲀⲨ ϪⲈ ⲈⲚⲈ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲈⲦⲈⲦⲚⲀⲘⲈⲢⲒⲦ ⲠⲈ ⲀⲚⲞⲔ ⲄⲀⲢ ⲚⲦⲀⲒⲈⲒ ⲀⲨⲰ ⲈⲒⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲦⲀⲒ ⲄⲀⲢ ⲀⲚ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ ⲀⲖⲖⲀ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ⲈⲦⲂⲈ ⲞⲨ ⲘⲠⲈⲦⲚⲤⲞⲨⲚ ⲦⲀϬⲒⲚϢⲀϪⲈ. ϪⲈ ⲘⲘⲚϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲤⲰⲦⲘ ⲈⲠⲀϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲀⲨⲰ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲢ ⲚⲈⲠⲒⲐⲨⲘⲒⲀ ⲘⲠⲈⲦⲚⲈⲒⲰⲦ. ⲠⲈⲦⲘⲘⲀⲨ ⲚⲈⲨⲢⲈϤϨⲈⲦⲂ ⲢⲰⲘⲈ ⲠⲈ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲀⲨⲰ ⲘⲠϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲘⲈ ϪⲈ ⲘⲚ ⲘⲈ ϢⲞⲞⲠ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ϨⲞⲦⲀⲚ ⲈⲢⲈ ⲠϬⲞⲖ ⲚⲀϢⲀϪⲈ ⲈϢⲀϤϢⲀϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲈⲚⲞⲨϤ ⲚⲈ ϪⲈ ⲞⲨⲢⲈϤϪⲒϬⲞⲖ ⲠⲈ ⲘⲚ ⲠⲈϤⲔⲈⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ⲀⲚⲞⲔ ⲆⲈ ϪⲈ ϮϪⲰ ⲚⲦⲘⲈ ⲚⲦⲈⲦⲘⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ⲚⲒⲘ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲠⲈⲦⲚⲀϪⲠⲒⲞⲈⲒ ⲈⲦⲂⲈ ⲚⲞⲂⲈ. ⲈϢϪⲈ ⲈⲈⲒϪⲰ ⲚⲦⲘⲈ. ⲈⲦⲂⲈ ⲞⲨ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲚⲀⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ⲠⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ ϢⲀϤⲤⲰⲦⲘ ⲈⲚϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲤⲰⲦⲘ ⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ⲀⲚⲒⲞⲨⲆⲀⲒ ⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲘⲎ ⲔⲀⲖⲰⲤ ⲀⲚ ⲀⲚⲞⲚ ⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲔⲞⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲀⲨⲰ ⲞⲨⲚ ⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲘⲘⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲚⲞⲔ ⲘⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲘⲘⲀⲒ. ⲀⲖⲖⲀ ϮⲦⲀⲒⲞ ⲘⲠⲀⲈⲒⲰⲦ ⲀⲨⲰ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲰϢ ⲘⲘⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ⲀⲚⲞⲔ ⲆⲈ ⲚϮϢⲒⲚⲈ ⲀⲚ ⲚⲤⲀ ⲠⲀⲈⲞⲞⲨ ϤϢⲞⲞⲠ ⲚϬⲒ ⲠⲈⲦⲚⲀϢⲒⲚⲈ ⲀⲨⲰ ⲚϤⲔⲢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲚⲀϨⲀⲢⲈϨ ⲈⲠⲀϢⲀϪⲈ. ⲚϤⲚⲀⲚⲀⲨ ⲀⲚ ⲈⲠⲘⲞⲨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ⲠⲈϪⲈ ⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲚⲀϤ ϪⲈ ⲦⲈⲚⲞⲨ ⲀⲚⲈⲒⲘⲈ ϪⲈ ⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲠⲈⲦⲚⲘⲘⲀⲔ ⲀⲂⲢⲀϨⲀⲘ ⲀϤⲘⲞⲨ ⲚⲘ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲰ ⲚⲦⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲚⲀϨⲀⲢⲈϨ ⲈⲠⲀϢⲀϪⲈ ⲚϤⲚⲀϪⲒϮⲠⲈ ⲀⲚ ⲘⲠⲘⲞⲨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ⲘⲎ ⲚⲦⲞⲔ ⲈⲚⲀⲀⲀⲔ ⲈⲠⲈⲚⲈⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ ⲠⲀⲒ ⲈⲚⲦⲀϤⲘⲞⲨ. ⲀⲨⲰ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲘⲞⲨ. ⲈⲔⲈⲒⲢⲈ ⲘⲘⲞⲔ ⲚⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈϢⲰⲠⲈ ⲀⲚⲞⲔ ⲈⲒϢⲀⲚϮⲈⲞⲞⲨ ⲚⲀⲒ ⲞⲨⲖⲀⲀⲨ ⲠⲈ ⲠⲀⲈⲞⲞⲨ ϤϢⲞⲞⲠ ⲚϬⲒ ⲠⲀⲈⲒⲰⲦ ⲈⲦϮⲈⲞⲞⲨ ⲚⲀⲒ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚⲚⲞⲨⲦⲈ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ⲀⲨⲰ ⲘⲠⲈⲦⲚⲤⲞⲨⲰⲚϤ ⲀⲚⲞⲔ ⲆⲈ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲈⲒϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲈⲈⲒⲚⲀϢⲰⲠⲈ ⲚⲢⲈϤϪⲒϬⲞⲖ ⲚⲦⲈⲦⲚ ϨⲈ ⲀⲖⲖⲀ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲨⲰ ϮϨⲀⲢⲈϨ ⲈⲠⲈϤϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ⲀⲂⲢⲀϨⲀⲘ ⲆⲈ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲀϤⲦⲈⲖⲎⲖ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲚⲀⲨ ⲈⲠⲀϨⲞⲞⲨ ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲀⲨⲰ ⲀϤⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲘⲠⲀⲦⲔⲢ ⲦⲀⲒⲞⲨ ⲚⲢⲞⲘⲠⲈ ⲀⲨⲰ ⲀⲀⲂⲢⲀϨⲀⲘ ⲚⲀⲨ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲘⲠⲀⲦⲈ ⲀⲂⲢⲀϨⲀⲘ ϢⲰⲠⲈ ⲀⲚⲞⲔ ϮϢⲞⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ⲀⲨϤⲒⲰⲚⲈ ϬⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲞⲨϪⲈ ⲈⲢⲞϤ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϨⲞⲠϤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ⲀⲨⲰ ⲈϤⲠⲀⲢⲀⲄⲈ ⲀϤⲚⲀⲨ ⲈⲨⲢⲰⲘⲈ ⲈⲀⲨϪⲠⲞϤ ⲈϤⲞ ⲚⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ⲀⲨⲰ ⲀⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲢⲀⲂⲂⲈⲒ ⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤⲢⲚⲞⲂⲈ. ⲠⲀⲒ ⲠⲈ ϪⲚ ⲚⲈϤⲈⲒⲞⲦⲈ ⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲠⲞϤ ⲈϤⲞ ⲂⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲞⲨⲦⲈ ⲘⲠⲈ ⲠⲀⲒ ⲢⲚⲞⲂⲈ ⲞⲨⲦⲈ ⲘⲠⲈ ⲚⲈϤⲔⲈⲈⲒⲞⲦⲈ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ϢϢⲈ ⲈⲢⲞⲚ ⲈⲢϨⲰⲂ ⲈⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ ϨⲞⲤⲞⲚ ⲠⲈϨⲞⲞⲨ ⲠⲈ. ⲤⲚⲎⲨ ⲚϬⲒ ⲦⲈⲨϢⲎ ϨⲞⲦⲈ ⲘⲚ ⲖⲀⲀⲨ ⲚⲀϢ ϬⲘϬⲞⲘ ⲈⲢϨⲰⲂ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ϨⲞⲤⲞⲚ ϮϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ⲀⲚⲄ ⲠⲞⲨⲞⲒⲚ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲀϤⲚⲈϪ ⲞⲨⲠⲀϬⲤⲈ ⲈⲠⲔⲀϨ ⲀϤⲦⲀⲘⲒⲈ ⲞⲨⲞⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲀϬⲤⲈ ⲀϤϪⲈϨ ⲠⲞⲘⲈ ⲈⲚⲈϤⲂⲀⲖ ");
INSERT INTO copshc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲂⲰⲔ ⲚⲄⲈⲒⲀ ⲠⲈⲔϨⲞ ϨⲚ ⲦⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ⲘⲠⲤⲒⲖⲰⲀⲘ ⲠⲀⲒ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲈⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨϤ. ⲀϤⲂⲰⲔ ϬⲈ ⲀϤⲈⲒ ⲀⲠⲈϤϨⲞ ⲀⲨⲰ ⲀϤⲈⲒ ⲈϤⲚⲀⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ⲚⲈⲦϨⲒ ⲦⲞⲨⲰϤ ϬⲈ ⲀⲨⲰ ⲚⲈⲦⲚⲀⲨ ⲈⲢⲞϤ ⲚϢⲞⲢⲠ ϪⲈ ⲚⲈⲨⲢⲈϤⲦⲰⲂⲀϨ ⲠⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠⲀⲒ ⲀⲚ ⲠⲈⲦϨⲘⲞⲞⲤ ⲀⲨⲰ ⲈⲦϢⲈⲦ ⲘⲚⲦⲚⲀⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲈϤⲈⲒⲚⲈ ⲘⲘⲞϤ ⲚⲦⲞϤ ⲆⲈ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ. ϪⲈ ⲚⲀϢ ϬⲈ ⲚϨⲈ ⲀⲨⲞⲨⲰⲚ ⲚϬⲒ ⲚⲈⲔⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ⲀϤⲞⲨⲰϢⲂ ϪⲈ ⲠⲒⲢⲰⲘⲈ ⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀϤⲦⲀⲘⲒⲈ ⲞⲨⲞⲘⲈ ⲀϤϪⲈϨ ⲚⲀⲂⲀⲖ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲒ ϪⲈ ⲂⲰⲔ ⲈⲠⲤⲒⲖⲰϨⲀⲘ ⲚⲄⲈⲒⲀ ⲠⲈⲔϨⲞ. ⲀⲒⲂⲰⲔ ϬⲈ ⲀⲒⲈⲒⲀ ⲠⲀϨⲞ ⲀⲨⲰ ⲀⲈⲒⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲈϤⲦⲰⲚ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈϪⲀϤ ϪⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ⲀⲨⲈⲒⲚⲈ ⲘⲠⲈⲚⲈϤⲞ ⲂⲂⲖⲖⲈ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ⲚⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲆⲈ ⲠⲈ ⲚⲦⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲦⲀⲘⲒⲈ ⲠⲞⲘⲈ ⲀⲨⲰ ⲀϤⲞⲨⲰⲚ ⲚⲚⲈϤⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ⲀⲨϪⲚⲞⲨϤ ϬⲈ ⲞⲚ ⲚϬⲒ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ϪⲈ ⲚⲦⲀⲔⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲀϢ ⲚϨⲈ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲀϤⲈⲤϬⲞⲨⲞⲘⲈ ⲈⲚⲀⲂⲀⲖ ⲀⲨⲰ ⲀⲒⲀ ⲠⲀϨⲞ ⲀⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ⲠⲈϪⲈ ϨⲞⲒⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϪⲈ ⲠⲈⲈⲒⲢⲰⲘⲈ ⲚⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ ⲀⲚ ⲠⲈ ϪⲈ ⲚϤϨⲀⲢⲈϨ ⲀⲚ ⲈⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲞⲨⲚϢϬⲞⲘ ⲚⲞⲨⲢⲰⲘⲈ ⲚⲢⲈϤⲢⲚⲞⲂⲈ ⲈⲢⲚⲈⲒⲘⲀⲒⲚ ⲚⲦⲈⲒⲘⲒⲚⲈ. ⲀⲨⲰ ⲚⲈⲢⲈ ⲞⲨⲤⲬⲒⲤⲘⲀ ϢⲞⲞⲠ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ⲠⲈϪⲀⲨ ⲞⲚ ⲘⲠⲎ ⲈⲦⲈ ⲚⲈϤⲞ ⲂⲂⲖⲖⲈ. ϪⲈ ⲚⲦⲞⲔ ⲈⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲈⲦⲂⲎⲎⲦϤ ϪⲈ ⲀϤⲞⲨⲰⲚ ⲚⲚⲈⲔⲂⲀⲖ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ⲚⲈⲨⲠⲒⲤⲦⲈⲨⲈ ϬⲈ ⲀⲚ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲦⲂⲎⲎⲦϤ ϪⲈ ⲚⲈⲨⲂⲖⲖⲈ ⲠⲈ ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲂⲞⲖ. ϢⲀⲚⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲚⲈⲒⲞⲦⲈ ⲘⲠⲈⲚⲦⲀϤⲚⲀⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ⲀⲨⲰ ⲀⲨϪⲚⲞⲨⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲦⲚϢⲎⲢⲈ ⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲠⲞϤ ⲈϤⲞ ⲚⲂⲖⲖⲈ. ⲚⲀϢ ϬⲈ ⲚϨⲈ ⲦⲈⲚⲞⲨ ϤⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ⲀⲚⲈϤⲈⲒⲞⲦⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀⲨ ⲚⲀⲨ. ϪⲈ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲚϢⲎⲢⲈ ⲀⲨⲰ ϪⲈ ⲚⲦⲀⲚϪⲠⲞϤ ⲈϤⲞ ⲚⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ⲚⲀϢ ⲆⲈ ⲚϨⲈ ⲦⲈⲚⲞⲨ ϤⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲎⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲞⲨⲰⲚ ⲚⲚⲈϤⲂⲀⲖ ⲀⲚⲞⲚ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲦⲞϤ ϨⲰⲰϤ ⲀϤⲢ ⲦⲈ ⲚϢⲀϪⲈ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ⲚⲦⲀⲨϪⲈ ⲚⲀⲒ ⲚϬⲒ ⲚⲈϤⲈⲒⲞⲦⲈ ϪⲈ ⲚⲈⲨⲢϨⲞⲦⲈ ϨⲎⲦⲞⲨ ⲚⲒⲞⲨⲆⲀⲒ. ⲚⲈ ⲀⲨⲞⲨⲰ ⲄⲀⲢ ⲈⲨⲤⲘⲒⲚⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀⲚ ⲞⲨⲀ ϨⲞⲘⲞⲖⲞⲄⲒ ⲘⲘⲞϤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ⲈϤⲈϢⲰⲠⲈ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲚⲈϤⲈⲒⲞⲦⲈ ϪⲞⲞⲤ ϪⲈ ⲀϤⲢⲚⲞϬ ⲘⲀϪⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ⲀⲨⲘⲞⲨⲦⲈ ϬⲈ ⲞⲚ ⲈⲠⲢⲰⲘⲈ ⲘⲠⲘⲈϨⲤⲈⲠ ⲤⲚⲀⲨ ⲠⲈⲦⲈ ⲚⲈϤⲞ ⲚⲂⲖⲖⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲚⲞⲚ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲠⲈⲈⲒⲢⲰⲘⲈ ⲞⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲎ. ϪⲈ ⲈϢϪⲈ ⲞⲨⲢⲈϤⲢⲚⲞⲂⲈ ⲠⲈ. ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ. ⲞⲨⲀ ⲀⲚⲞⲔ ⲠⲈϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ. ϪⲈ ⲚⲈⲒⲞ ⲚⲂⲖⲖⲈ ⲠⲈ. ⲀⲨⲰ ⲦⲈⲚⲞⲨ ϮⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ. ϪⲈ ⲞⲨ ⲠⲈ ⲚⲦⲀϤⲀⲀϤ ⲚⲀⲔ. ⲚⲦⲀϤⲞⲨⲰⲚ ⲚⲚⲈⲔⲂⲀⲖ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ϪⲈ ⲀⲈⲒⲞⲨⲰ ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲀⲨⲰ ⲘⲠⲈⲦⲚⲤⲰⲦⲘ ⲞⲨ ⲞⲚ ⲠⲈⲦⲈⲦⲚⲞⲨⲈϢ ⲤⲞⲦⲘⲈϤ ⲘⲎ ⲈⲦⲈⲦⲚⲞⲨⲰϢ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲈⲢⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ⲀⲨⲰ ⲀⲨⲤⲀϨⲞⲨ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲘⲀⲐⲎⲦⲎⲤ ⲘⲠ ⲈⲦⲘⲘⲀⲨ. ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲞⲚ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲘⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ⲀⲚⲞⲚ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ϢⲀϪⲈ ⲘⲚ ⲘⲰⲨⲤⲎⲤ. ⲠⲀⲒ ⲆⲈ ⲚⲦⲞϤ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ⲀⲠⲢⲰⲘⲈ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ϪⲈ ⲦⲀⲒ ⲢⲰ ⲦⲈ ⲦⲈϢⲠⲎⲢⲈ ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲠⲈ ⲀⲨⲰ ⲀϤⲞⲨⲰⲚ ⲚⲚⲀⲂⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲘⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲤⲰⲦⲘ ⲈⲢⲈϤⲢⲚⲞⲂⲈ. ⲀⲖⲖⲀ ⲈϢⲰⲠⲈ ⲈⲨⲢⲘ ⲚⲚⲞⲨⲦⲈ ⲠⲈ ⲞⲨⲀ ⲀⲨⲰ ⲈϤⲈⲒⲢⲈ ⲘⲠⲈϤⲞⲨⲰϢ. ϢⲀϤⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ϪⲒⲚ ⲈⲚⲈϨ ⲘⲠⲞⲨⲤⲰⲦⲘ ϪⲈ ⲀⲨⲞⲨⲰⲚ ⲈⲚⲂⲀⲖ ⲚⲞⲨⲀ ⲈⲀⲨϪⲠⲞϤ ⲈϤⲞ ⲚⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ⲈⲚⲈ ⲚⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲠⲀⲒ. ⲚⲈϤⲚⲀϢⲢ ⲖⲀⲀⲨ ⲚϨⲰⲂ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲀⲨϪⲠⲞⲔ ⲦⲎⲢⲔ ϨⲘ ⲠⲚⲞⲂⲈ ⲀⲨⲰ ⲚⲦⲞⲔ ⲈⲔⲚⲀϮⲤⲂⲰ ⲚⲀⲚ. ⲀⲨⲰ ⲀⲨⲚⲞϪϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ⲀⲒⲎⲤⲞⲨⲤ ⲤⲰⲦⲘ ϪⲈ ⲀⲨⲚⲞϪϤ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲈ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲦⲞⲔ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ⲠⲈϪⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲒⲘ ⲠⲈ ϪⲈ ⲈⲈⲒⲈⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ϪⲈ ⲀⲔⲚⲀⲨ ⲈⲢⲞϤ. ⲀⲨⲰ ⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀⲔ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲠⲒⲤⲦⲈⲨⲈ ⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ ");
INSERT INTO copshc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲀⲚⲞⲔ ⲈⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲈⲨϨⲀⲠ ϪⲈⲔⲀⲀⲤ ⲚⲈⲦⲈⲚⲤⲈⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲚ ⲈⲨⲈⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲈⲦⲚⲀⲨ ⲈⲂⲞⲖ ⲈⲨⲈϢⲰⲠⲈ ⲚⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ⲀⲨⲤⲰⲦⲘ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲚⲘⲘⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ⲘⲎ ⲀⲚⲞⲚ ϨⲰⲰⲚ ⲀⲚⲚ ϨⲈⲚⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ ϪⲈ ⲈⲚⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲂⲖⲖⲈ ⲚⲈ ⲘⲘⲚ ⲚⲞⲂⲈ ⲈⲢⲰⲦⲚ ⲠⲈ ⲦⲈⲚⲞⲨ ⲆⲈ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲚⲚⲀⲨ ⲈⲂⲞⲖ ⲠⲈⲦⲚⲚⲞⲂⲈ ⲀϨⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲈ ⲚϤⲚⲎⲨ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲞ ⲈϨⲞⲨⲚ ⲈⲠⲞϨⲈ ⲚⲚⲈⲤⲞⲞⲨ ⲀⲖⲖⲀ ⲈϤⲞⲨⲰⲦⲂ ⲈⲂⲞⲖ ϨⲒ ⲔⲈⲤⲀ. ⲠⲈⲦⲘⲘⲀⲨ ⲞⲨⲢⲈϤϪⲒⲞⲨⲈ ⲀⲨⲰ ⲞⲨⲤⲞⲞⲚⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ⲠⲈⲦⲚⲎⲨ ⲆⲈ ⲚⲦⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲞ ⲚⲦⲞϤ ⲠⲈ ⲠϢⲰⲤ ⲚⲚⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ⲠⲀⲒ ϢⲀⲢⲈ ⲠⲈⲘⲚⲞⲨⲦ ⲞⲨⲰⲚ ⲚⲀϤ ⲀⲨⲰ ϢⲀⲢⲈ ⲚⲈⲤⲞⲞⲨ ⲤⲰⲦⲘ ⲈⲦⲈϤⲤⲘⲎ ⲀⲨⲰ ϢⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲈⲤⲞⲞⲨ ⲔⲀⲦⲀ ⲠⲈⲨⲢⲀⲚ ⲚϤⲚⲦⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ϨⲞⲦⲀⲚ ⲈϤϢⲀⲚⲈⲒⲚⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈ ⲚⲞⲨϤ ⲦⲎⲢⲞⲨ ⲚⲈ. ϢⲀϤⲘⲞⲞϢⲈ ϨⲀ ⲦⲈⲨϨⲎ ⲀⲨⲰ ϢⲀⲢⲈ ⲚⲈⲤⲞⲞⲨ ⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ϪⲈ ⲤⲈⲤⲞⲞⲨⲚ ⲚⲦⲈϤⲤⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ⲚⲚⲈⲨⲞⲨⲀϨⲞⲨ ⲆⲈ ⲚⲦⲞϤ ⲚⲤⲀ ⲞⲨϢⲘⲘⲞ ⲀⲖⲖⲀ ⲤⲈⲚⲀⲠⲰⲦ ⲈⲂⲞⲖ ⲘⲘⲞϤ ϪⲈ ⲚⲤⲈⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲦⲈⲤⲘⲎ ⲚⲚϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ⲦⲈⲈⲒⲠⲀⲢϨⲞⲒⲘⲒⲀ ⲀϤϪⲞⲞⲤ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ⲚⲎ ⲆⲈ ⲘⲠⲞⲨⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲚⲈⲦϤϪⲰ ⲘⲘⲞⲞⲨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ⲠⲈϪⲀϤ ϬⲈ ⲞⲚ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠϢⲰⲤ ⲚⲚⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀⲨⲈⲒ ϨⲈⲚⲢⲈϤϪⲒⲞⲨⲈ ⲚⲈ ⲀⲨⲰ ϨⲈⲚⲤⲞⲞⲚⲈ ⲚⲈ. ⲀⲖⲖⲀ ⲘⲠⲈ ⲚⲈⲤⲞⲞⲨ ⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ⲀⲚⲞⲔ ⲠⲈ ⲠⲢⲞ. ⲈⲢϢⲀ ⲞⲨⲀ ⲂⲰⲔ ⲈϨⲞⲨⲚ ϨⲒⲦⲞⲞⲦ. ϤⲚⲀⲞⲨϪⲀⲒ ⲀⲨⲰ ϤⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚϤⲈⲒ ⲈⲂⲞⲖ ⲚϤϨⲈ ⲈⲨⲘⲀ ⲘⲘⲞⲞⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ⲠⲢⲈϤϪⲒⲞⲨⲈ ⲘⲈϤⲈⲒ ⲈⲦⲂⲈ ⲖⲀⲀⲨ. ⲈⲒ ⲘⲎⲦⲒ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϨⲰϤⲦ ⲀⲨⲰ ⲚϤϢⲰⲰⲦ ⲀⲨⲰ ⲚϤⲦⲀⲔⲞ. ⲀⲚⲞⲔ ⲚⲦⲀⲒⲈⲒ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲒ ⲚⲞⲨⲰⲚⲀϨ ⲀⲨⲰ ⲚⲤⲈϪⲒ ⲞⲨϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ⲀⲚⲞⲔ ⲠⲈ ⲠϢⲰⲤ ⲈⲦⲚⲀⲚⲞⲨϤ. ⲠϢⲰⲤ ⲈⲦⲚⲀⲚⲞⲨϤ ϢⲀϤⲔⲀ ⲦⲈϤⲮⲨⲬⲎ ϨⲀ ⲚⲈϤⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ⲠϪⲀⲒⲂⲈⲔⲈ ⲆⲈ ⲈⲦⲈ ⲚⲞⲨϢⲰⲤ ⲀⲚ ⲠⲈ ⲠⲀⲒ ⲈⲦⲈ ⲚⲚⲞⲨϤ ⲀⲚ ⲚⲈ ⲚⲈⲤⲞⲞⲨ ϢⲀϤⲚⲀⲨ ⲈⲠⲞⲨⲰⲚϢ ⲈϤⲚⲎⲨ ⲀⲨⲰ ϢⲀϤⲔⲀ ⲚⲈⲤⲞⲞⲨ ⲚϤⲠⲰⲦ. ⲀⲨⲰ ϢⲀⲢⲈ ⲠⲞⲨⲰⲚϢ ⲦⲞⲢⲠⲞⲨ ⲚϤϪⲞⲞⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ⲈⲂⲞⲖ ϪⲈ ⲞⲨϪⲀⲒⲂⲈⲔⲈ ⲠⲈ ⲀⲨⲰ ⲘⲠⲈϤⲢⲞⲞⲨϢ ⲀⲚ ⲠⲈ ϨⲀ ⲚⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ⲀⲚⲞⲔ ⲠⲈ ⲠϢⲰⲤ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ϮⲤⲞⲞⲨⲚ ⲚⲚⲞⲨⲈⲒ ⲀⲨⲰ ⲚⲞⲨⲈⲒ ⲤⲞⲞⲨⲚ ⲘⲘⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ⲔⲀⲦⲀⲐⲈ ⲈⲦⲈⲢⲈ ⲠⲒⲰⲦ ⲤⲞⲞⲨⲚ ⲘⲘⲞⲈⲒ. ⲀⲚⲞⲔ ϨⲰ ϮⲤⲞⲞⲨⲚ ⲘⲠⲒⲰⲦ. ⲀⲨⲰ ϮⲚⲀⲔⲰ ⲚⲦⲀⲮⲨⲬⲎ ϨⲀ ⲚⲀⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ⲞⲨⲚⲦⲀⲒ ⲞⲚ ⲘⲘⲀⲨ ⲚϨⲈⲚⲔⲈⲈⲤⲞⲞⲨ ⲈⲚϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ⲚⲈ ϨⲘ ⲠⲈⲒⲞϨⲈ. ⲀⲨⲰ ⲚⲈⲦⲘⲘⲀⲨ ⲞⲚ ϨⲀⲠⲤ ⲈⲦⲢⲀⲤⲞⲞⲨϨⲞⲨ ⲀⲨⲰ ⲤⲈⲚⲀⲤⲰⲦⲘ ⲈⲦⲀⲤⲘⲎ ⲚⲤⲈϢⲰⲠⲈ ⲚⲞⲨⲞϨⲈ ⲚⲞⲨⲰⲦ. ⲞⲨϢⲰⲤ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲀⲒⲰⲦ ⲘⲈ ⲘⲘⲞⲒ ϪⲈ ϮⲚⲀⲔⲰ ⲚⲦⲀⲮⲨⲬⲎ ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲈⲒⲈϪⲒⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ⲘⲚ ⲖⲀⲀⲨ ϤⲒ ⲘⲘⲞⲤ ⲚⲦⲞⲞⲦ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲈⲦⲔⲰ ⲘⲘⲞⲤ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ. ⲞⲨⲚϮ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲔⲀⲀⲤ ⲀⲨⲰ ⲞⲚ ⲞⲨⲚϮ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈϪⲒⲦⲤ. ⲦⲈⲒⲈⲚⲦⲞⲖⲎ ⲚⲦⲀⲒϪⲒⲦⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲀⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ⲀⲨⲤⲬⲒⲤⲘⲀ ⲞⲚ ϢⲰⲠⲈ ϨⲚ ⲒⲞⲨⲆⲀⲒ ⲈⲦⲂⲈ ⲚⲈⲒϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ⲚⲈⲨⲚ ϨⲀϨ ⲆⲈ ϪⲰ ⲘⲘⲞⲤ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲞⲨⲚ ⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲚⲘⲘⲀϤ ⲀⲨⲰ ϤⲖⲞⲂⲈ. ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲒϢⲀϪⲈ ⲚⲀ ⲞⲨⲀ ⲀⲚ ⲚⲈ ⲈϤⲞ ⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ⲘⲎ ⲞⲨⲚ ϬⲞⲘ ⲚⲞⲨⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲈⲨⲰⲚ ⲚⲂⲂⲀⲖ ⲚⲂⲂⲖⲖⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ⲀϤϢⲰⲠⲈ ⲆⲈ ϨⲘ ⲠⲈⲨⲞⲒϢ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲠϪⲒ ⲀⲈⲒⲔ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲈ ⲦⲈⲠⲢⲰ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ⲀⲨⲰ ⲚⲈϤⲘⲞⲞϢⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϨⲘ ⲠⲈⲢⲠⲈ ϨⲀ ⲦⲈⲤⲦⲞⲀ ⲚⲤⲞⲖⲞⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ⲀⲨⲔⲰⲦⲈ ϬⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀϤ. ϪⲈ ϢⲀ ⲦⲚⲀⲨ ⲔϤⲒ ⲘⲠⲈⲚϨⲎⲦ. ⲈϢϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀϪⲒⲤ ⲚⲀⲚ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ. ⲚⲈϨⲂⲎⲨⲈ ⲀⲚⲞⲔ ⲈϮⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲚⲀⲒ ⲚⲈⲦⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ⲀⲖⲖⲀ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ϨⲚ ⲚⲀⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ⲚⲀⲈⲤⲞⲞⲨ ⲀⲚⲞⲔ ϢⲀⲨⲤⲰⲦⲘ ⲈⲦⲀⲤⲘⲎ ⲀⲨⲰ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲤⲈⲚⲀⲞⲨⲀϨⲞⲨ ⲚⲤⲰⲈⲒ ");
INSERT INTO copshc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀϮ ⲚⲀⲨ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲀⲨⲰ ⲚⲚⲈⲨϨⲈ ⲈⲂⲞⲖ ⲈⲚⲈϨ ⲀⲨⲰ ⲚⲚⲈ ⲖⲀⲀⲨ ⲦⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲀϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ⲠⲀⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲀⲨ ⲚⲀⲒ ϤϨⲒϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲨⲰ ⲘⲚ ϢϬⲞⲘ ⲖⲖⲀⲀⲨ ⲈⲦⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦϬⲒϪ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ⲀⲚⲞⲔ ⲚⲘ ⲠⲀⲈⲒⲰⲦ ⲀⲚⲞⲚ ⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ⲀⲨϤⲒ ⲰⲚⲈ ⲞⲚ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲞⲨϪⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲒⲦⲤⲀⲂⲰⲦⲚ ⲈϨⲀϨ ⲚϨⲰⲂ ⲈⲚⲀⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲀⲒⲰⲦ ⲈⲦⲂⲈ ⲀϢ ⲘⲘⲞⲞⲨ ⲚϨⲰⲂ ⲦⲈⲦⲚϨⲒ ⲰⲚⲈ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲚⲚⲈⲚⲚⲀϨⲒ ⲰⲚⲈ ⲀⲚ ⲈⲢⲞⲔ ⲈⲦⲂⲈ ϨⲰⲂ ⲈⲚⲀⲚⲞⲨϤ ⲀⲖⲖⲀ ⲈⲦⲂⲈ ϪⲒⲞⲨⲀ ϪⲈ ⲚⲦⲞⲔ ⲈⲚⲦⲔ ⲞⲨⲢⲰⲘⲈ ⲔⲈⲒⲢⲈ ⲘⲘⲞⲔ ⲚⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲘⲎ ⲚϤⲤⲎϨ ⲀⲚ ϨⲘ ⲠⲈⲦⲚⲚⲞⲘⲞⲤ. ϪⲈ ⲀⲚⲞⲔ ⲀⲒϪⲞⲞⲤ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ⲈϢϪⲈ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲚ ⲈⲦⲘⲘⲀⲨ ϪⲈ ⲚⲞⲨⲦⲈ ⲚⲀⲒ ⲈⲚⲦⲀ ⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲰⲠⲈ ϢⲀⲢⲞⲞⲨ ⲀⲨⲰ ⲘⲘⲚ ϬⲞⲘ ⲚⲦⲈ ⲦⲈⲄⲢⲀⲪⲎ ⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ⲈⲒⲈ ⲠⲈⲚⲦⲀ ⲠⲒⲰⲦ ⲦⲂⲂⲞϤ ⲀϤⲦⲚⲚⲞⲞⲨϤ ⲈⲠⲔⲞⲤⲘⲞⲤ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔϪⲈ ⲞⲨⲀ ϪⲈ ⲀⲒϪⲞⲞⲤ ϪⲈ ⲀⲚⲄ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ⲈϢϪⲈ ⲚϮⲈⲒⲢⲈ ⲀⲚ ⲚⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲀⲒⲰⲦ ⲘⲠⲢⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ⲈϢϪⲈ ϮⲈⲒⲢⲈ ⲆⲈ ⲘⲘⲞⲞⲨ. ⲔⲀⲚ ⲈⲦⲈⲦⲚⲦⲘⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ. ⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲈϨⲂⲎⲨⲈ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ϪⲈ ⲠⲒⲰⲦ ϢⲞⲞⲠ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ϮϨⲘ ⲠⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ⲚⲈⲨϢⲒⲚⲈ ϬⲈ ⲞⲚ ⲚⲤⲀ ϬⲞⲠϤ ⲀⲨⲰ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨϬⲒϪ ");
INSERT INTO copshc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ⲀϤⲂⲰⲔ ⲞⲚ ⲈⲠⲒⲔⲢⲞ ⲘⲠⲒⲞⲢⲆⲀⲚⲎⲤ ⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲚϨⲎⲦϤ ⲚϢⲞⲢⲠ ⲈϤⲂⲀⲠⲦⲒⲌⲈ ⲀⲨⲰ ⲀϤϬⲰ ⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ⲀⲨⲘⲎⲎϢⲈ ⲂⲰⲔ ϢⲀⲢⲞϤ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲘⲠϤⲢ ⲖⲀⲀⲨ ⲘⲘⲀⲒⲚ. ϢⲀϪⲈ ⲆⲈ ⲚⲒⲘ ⲈⲚⲦⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ϪⲞⲞⲨ ⲈⲦⲂⲈ ⲠⲀⲒ ϨⲈⲚⲘⲈ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ⲀⲨⲰ ⲀϨⲀϨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ⲚⲈⲨⲚ ⲞⲨⲀ ⲆⲈ ϢⲰⲚⲈ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲂⲎⲐⲀⲚⲒⲀ ⲠϮⲘⲈ ⲘⲘⲀⲢⲒⲀ ⲚⲘ ⲘⲀⲢⲐⲀ ⲦⲈⲤⲤⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ⲦⲀⲒ ⲆⲈ ⲦⲈ ⲘⲀⲢⲒⲀ ⲦⲈⲚⲦⲀⲤⲦⲈϨⲤ ⲠϪⲞⲈⲒⲤ ⲚⲤⲞϬⲚ ⲀⲨⲰ ⲀⲤϤⲈⲦ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ϨⲘ ⲠⲈⲤϤⲰ ⲦⲀⲒ ⲈⲚⲈⲢⲈ ⲠⲈⲤⲤⲞⲚ ⲖⲀⲌⲀⲢⲞⲤ ϢⲰⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ⲀⲨϪⲞⲞⲨ ϬⲈ ϢⲀⲢⲞϤ ⲚϬⲒ ⲚⲈϤⲤⲰⲚⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤϢⲰⲚⲈ ⲚϬⲒ ⲠⲈⲦⲔⲘⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ. ϪⲈ ⲠⲈⲒϢⲰⲚⲈ ⲚⲚⲈϤϢⲞⲞⲠ ⲀⲚ ⲈⲠⲘⲞⲨ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲈϤϢⲎⲢⲈ ϪⲒⲈⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲈ ⲘⲘⲀⲢⲐⲀ ⲚⲘ ⲘⲀⲢⲒⲀ ⲦⲈⲤⲤⲰⲚⲈ ⲚⲘ ⲖⲀⲌⲀⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ϬⲈ ϪⲈ ϤϢⲰⲚⲈ. ⲦⲞⲦⲈ ⲀϤϬⲰ ⲚϨⲞⲞⲨ ⲤⲚⲀⲨ ϨⲘ ⲠⲘⲀ ⲈⲚⲈϤⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ⲘⲀⲢⲞⲚ ⲞⲚ ⲈϮⲞⲨⲆⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ⲠⲈϪⲀⲨ ⲚⲀϤ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ϨⲢⲀⲂⲂⲈⲒ. ⲦⲈⲚⲞⲨ ⲚⲈⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ϢⲒⲚⲈ ⲚⲤⲀ ϨⲒ ⲰⲚⲈ ⲈⲢⲞⲔ ⲀⲨⲰ ⲞⲚ ⲔⲚⲀⲂⲰⲔ ⲈⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ. ϪⲈ ⲘⲎ ⲘⲚ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲞⲨⲚⲞⲨ ϨⲘ ⲠⲈϨⲞⲞⲨ. ⲈⲢϢⲀ ⲞⲨⲀ ⲘⲞⲞϢⲈ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲘⲈϤϪⲒϪⲢⲞⲠ ϪⲈ ϤⲚⲀⲨ ⲈⲠⲞⲨⲞⲒⲚ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ⲈⲢϢⲀ ⲞⲨⲀ ⲘⲞⲞϢⲈ ϨⲚ ⲦⲈⲨϢⲎ. ϢⲀϤϪⲒ ϪⲢⲞⲠ ϪⲈ ⲘⲠⲞⲨⲞⲒⲚ ϢⲞⲞⲠ ⲀⲚ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ⲚⲀⲒ ⲀϤϪⲞⲞⲨ ⲘⲚⲚⲤⲰⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲠⲈⲚϢⲂⲎⲢ ⲀϤⲚⲔⲞⲦⲔ. ⲀⲖⲖⲀ ϮⲚⲀⲂⲰⲔ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈⲦⲞⲨⲚⲞⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ⲠⲈϪⲀⲨ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈϢϪⲈ ⲚⲦⲀϤⲚⲔⲞⲦⲔ. ϤⲚⲀⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ϪⲞⲞⲤ ⲠⲈ ⲈⲦⲂⲈ ⲠⲈϤⲘⲞⲨ. ⲚⲎ ⲆⲈ ⲀⲨⲘⲈⲨⲈ ϪⲈ ⲈϤϪⲈ ⲠⲈⲚⲔⲞⲦⲔ ⲘⲠⲰⲂϢ. ");
INSERT INTO copshc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ⲦⲞⲦⲈ ϬⲈ ⲀⲒⲎⲤⲞⲨⲤ ϪⲞⲞⲤ ⲚⲀⲨ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ. ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲀϤⲘⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ⲀⲨⲰ ϮⲢⲀϢⲈ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲈⲒⲘⲘⲀⲨ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲘⲀⲢⲞⲚ ϢⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ⲠⲈϪⲈ ⲐⲰⲘⲀⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲚⲚⲈϤϢⲂⲢ ⲘⲀⲐⲎⲦⲎⲤ. ϪⲈ ⲘⲀⲢⲞⲚ ϨⲰⲰⲚ ϪⲈ ⲈⲚⲈⲘⲞⲨ ⲚⲘⲘⲀϤ ");
INSERT INTO copshc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ⲚⲦⲈⲢⲈϤⲈⲒ ϬⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϨⲈ ⲈⲢⲞϤ ⲈⲠⲈϤϤⲦⲞⲞⲨ ⲠⲈ ⲈϤϨⲘ ⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ⲂⲎⲐⲀⲚⲒⲀ ⲆⲈ ⲚⲈⲤϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲀⲘⲚⲦⲎ ⲚⲤⲦⲀⲆⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲒⲞⲨⲆⲀⲒ ⲚⲈ ⲀⲨⲈⲒ ⲠⲈ ϢⲀ ⲘⲀⲢⲐⲀ ⲚⲘ ⲘⲀⲢⲒⲀ ϪⲈ ⲈⲨⲈⲤⲖⲤⲰⲖⲞⲨ ⲈⲦⲂⲈ ⲠⲈⲨⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ⲘⲀⲢⲐⲀ ϬⲈ ⲚⲦⲈⲢⲈⲤⲤⲰⲦⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲎⲨ. ⲀⲤⲈⲒ ⲈⲂⲞⲖ ϨⲎⲦϤ. ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲈⲤϨⲘⲞⲞⲤ ⲠⲈ ϨⲘ ⲠⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ϬⲈ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲚⲈⲔⲘⲠⲈⲒⲘⲀ ⲚⲈⲢⲈ ⲠⲀⲤⲞⲚ ⲚⲀⲘⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ⲀⲖⲖⲀ ⲦⲈⲚⲞⲨ ⲞⲚ ϮⲤⲞⲞⲨⲚ ϪⲈ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲔⲚⲀⲀⲒⲦⲒ ⲘⲘⲞⲞⲨ ⲚⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲠⲚⲞⲨⲦⲈ ⲚⲀⲦⲀⲀⲨ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲠⲞⲨⲤⲞⲚ ⲚⲀⲦⲰⲞⲨⲚϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ⲚⲀϤ. ϪⲈ ϮⲤⲞⲞⲨⲚ ϪⲈ ϤⲚⲀⲦⲰⲞⲨⲚ ϨⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲀⲨⲰ ⲠⲰⲚϨ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲔⲀⲚ ⲈϤϢⲀⲚⲘⲞⲨ ϤⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲚϨ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ. ⲚϤⲚⲀⲘⲞⲨ ⲀⲚ ϢⲀ ⲈⲚⲈϨ. ⲦⲈⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ⲠⲈϪⲀⲤ ⲚⲀϤ. ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ. ⲀⲚⲞⲔ ϮⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲚⲎⲨ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲤϪⲈ ⲚⲀⲒ ⲀⲤⲂⲰⲔ ⲀⲤⲘⲞⲨⲦⲈ ⲈⲘⲀⲢⲒⲀ ⲦⲈⲤⲤⲰⲚⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲤ ⲚϪⲒⲞⲨⲈ ϪⲈ ⲀⲠⲤⲀϨ ⲈⲒ ⲀⲨⲰ ϤⲘⲞⲨⲦⲈ ⲈⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ⲚⲦⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈⲤⲤⲰⲦⲘ. ⲀⲤⲦⲰⲞⲨⲚⲤ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲀⲤⲈⲒ ⲈⲂⲞⲖ ϢⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈ ⲘⲠⲀⲦϤⲈⲒ ⲈϨⲞⲨⲚ ⲈⲠϮⲘⲈ ⲀⲖⲖⲀ ⲈⲦⲒ ⲚⲈϤϨⲘ ⲠⲘⲀ ⲈⲚⲦⲀ ⲘⲀⲢⲐⲀ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ⲚⲒⲞⲨⲆⲀⲒ ϬⲈ ⲈⲦϨⲘ ⲠⲎⲒ ⲚⲘⲘⲀⲤ ⲀⲨⲰ ⲈⲦⲤⲞⲖⲤⲖ ⲘⲘⲞⲤ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲘⲀⲢⲒⲀ ϪⲈ ⲀⲤⲦⲰⲞⲨⲚⲤ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲀⲤⲈⲒ ⲈⲂⲞⲖ. ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲤⲚⲀⲂⲰⲔ ⲈⲂⲞⲖ ⲈⲠⲦⲀⲪⲞⲤ ϪⲈ ⲈⲤⲈⲢⲒⲘⲈ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ⲘⲀⲢⲒⲀ ϬⲈ ⲚⲦⲈⲢⲈⲤⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲚϨⲎⲦϤ. ⲀⲤⲚⲞϪⲤ ϨⲀ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲚⲈⲔⲘⲠⲈⲈⲒⲘⲀ. ⲚⲈⲢⲈ ⲠⲀⲤⲞⲚ ⲚⲀⲘⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲢⲞⲤ ⲈⲤⲢⲒⲘⲈ ⲀⲨⲰ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲚⲦⲀⲨⲈⲒ ⲚⲘⲘⲀⲤ ⲈⲨⲢⲒⲘⲈ. ⲀϤϢⲦⲞⲢⲦⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲐⲈ ⲚⲚⲈⲦⲞⲞⲦ ");
INSERT INTO copshc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ⲀⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲔⲀⲀϤ ⲦⲰⲚ. ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲘⲞⲨ ⲚⲄⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ⲀϤⲢⲒⲘⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲀⲚⲀⲨ ⲈⲐⲈ ⲈⲦϤⲘⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ϨⲞⲒⲚⲈ ⲆⲈ ⲚϨⲎⲦⲞⲨ ⲠⲈϪⲀⲨ. ϪⲈ ⲠⲀⲒ ⲈⲚⲦⲀϤⲞⲨⲰⲚ ⲚⲂⲂⲀⲖ ⲘⲠⲂⲖⲖⲈ ⲈⲒⲈ ⲚⲈⲘⲘⲚ ϬⲞⲘ ⲘⲘⲞϤ ⲞⲚ ⲠⲈ ⲈⲦⲘⲦⲢⲈ ⲠⲀⲒ ⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲞⲚ ⲈϤⲞⲞⲦ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲀϤⲈⲒ ⲈⲠⲦⲀⲪⲞⲤ. ⲚⲈ ⲞⲨⲤⲠⲎⲖⲀⲒⲞⲚ ⲆⲈ ⲠⲈ ⲈⲢⲈ ⲞⲨⲰⲚⲈ ϨⲒ ⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϤⲒ ⲠⲰⲚⲈ ⲘⲘⲀⲨ. ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ⲚⲀϤ ⲦⲤⲰⲚⲈ ⲘⲠⲈⲚⲦⲀϤⲘⲞⲨ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲎⲆⲎ ⲀϤⲢⲤⲦⲞⲒ ⲠⲈϤϤⲦⲞⲞⲨ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ. ϪⲈ ⲘⲠⲒϪⲞⲞⲤ ⲚⲈ ϪⲈ ⲈⲢϢⲀⲚⲠⲒⲤⲦⲈⲨⲈ ⲦⲈⲚⲀⲚⲀⲨ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ⲀⲨϤⲒ ⲠⲰⲚⲈ ϬⲈ ⲘⲘⲀⲨ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϤⲒ ⲚⲈϤⲂⲀⲖ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ϮϢⲠϨⲘⲞⲦ ⲚⲦⲞⲞⲦⲔ ϪⲈ ⲀⲔⲤⲰⲦⲘ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ⲀⲚⲞⲔ ⲆⲈ ⲚⲈⲒⲤⲞⲞⲨⲚ ϪⲈ ⲔⲤⲰⲦⲘ ⲈⲢⲞⲈⲒ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ. ⲀⲖⲖⲀ ⲚⲦⲀⲒϪⲞⲞⲤ ⲈⲦⲂⲈ ⲠⲘⲎⲎϢⲈ ⲈⲦⲀϨⲈⲢⲀⲦϤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲚⲦⲀⲔⲦⲚⲚⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲀϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ϪⲈ ⲖⲀⲌⲀⲢⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲚⲦⲀϤⲘⲞⲨ ⲈϤⲘⲎⲢ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲘⲚ ⲚⲈϤϬⲒϪ ϨⲚ ϨⲈⲚⲔⲈⲢⲈⲀ ⲀⲨⲰ ⲈⲢⲈ ⲠⲈϤϨⲞ ⲘⲎⲢ ϨⲚ ⲞⲨⲤⲞⲨⲆⲀⲢⲒⲞⲚ. ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ⲂⲞⲖϤ ⲈⲂⲞⲖ ⲚⲦⲈⲦⲚ ⲔⲀⲀϤ ⲚϤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲒⲞⲨⲆⲀⲒ ⲈⲚⲦⲀⲨⲈⲒ ϢⲀ ⲘⲀⲢⲒⲀ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤⲀⲀϤ. ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ϨⲞⲒⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲀⲨⲂⲰⲔ ϢⲀ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲦⲀⲘⲞⲞⲨ ⲈⲚⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϬⲈ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲀⲨⲰ ⲠⲈϪⲀⲨ. ϪⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲀⲀϤ ϪⲈ ⲠⲈⲒⲢⲰⲘⲈ ⲢϨⲀϨ ⲘⲘⲀⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ⲈⲚϢⲀⲚⲔⲀⲀϤ ⲚⲦⲈⲒϨⲈ. ⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲀⲨⲰ ⲚⲤⲈⲈⲒ ⲚϬⲒ ⲚⲈϨⲢⲰⲘⲀⲒⲞⲤ ⲚⲤⲈϤⲒ ⲚⲦⲞⲞⲦⲚ ⲘⲠⲈⲚⲘⲀ ⲀⲨⲰ ⲠⲈⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ⲞⲨⲀ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ϪⲈ ⲔⲀⲒⲪⲀⲤ ⲈⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈ ⲚⲦⲈⲢⲞⲘⲠⲈ ⲈⲦⲘⲘⲀⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ⲞⲨⲆⲈ ⲚⲦⲈⲦⲚ ⲖⲞⲄⲒⲌⲈ ⲀⲚ ϪⲈ ⲤⲢⲚⲞϤⲢⲈ ⲚⲀⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲞⲨⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲘⲞⲨ ϨⲀ ⲠⲖⲀⲞⲤ ⲀⲨⲰ ⲚⲦⲈⲦⲘ ⲠϨⲈⲐⲚⲞⲤ ⲦⲎⲢϤ ϨⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ⲚⲦⲀϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲀⲚ ϨⲀⲢⲞϤ ⲘⲘⲀⲨ ⲀⲀϤ ⲀⲖⲖⲀ ⲈⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈ ⲚⲦⲈⲢⲞⲘⲠⲈ ⲈⲦⲘⲘⲀⲨ ⲀϤⲠⲢⲞⲪⲎⲦⲈⲨⲈ ϪⲈ ⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲘⲞⲨ ϨⲀ ⲠϨⲈⲐⲚⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ⲀⲨⲰ ϨⲀ ⲠϨⲈⲐⲚⲞⲤ ⲀⲚ ⲘⲘⲀⲦⲈ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲚϢⲎⲢⲈ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲦϪⲞⲞⲢⲈ ⲈⲂⲞⲖ ⲈϤⲈⲤⲞⲞⲨϨⲞⲨ ⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ϪⲒⲚ ⲠⲈϨⲞⲞⲨ ϬⲈ ⲈⲦⲘⲘⲀⲨ ⲀⲨϪⲒϢⲞϪⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈϤⲘⲞⲞϢⲈ ϬⲈ ⲀⲚ ⲠⲈ ⲠⲀⲢⲢⲎⲤⲒⲀ ϨⲚ ⲒⲞⲨⲆⲀⲒ ⲀⲖⲖⲀ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲈⲬⲰⲢⲀ ⲈⲦϨⲎⲚ ⲈⲦⲈⲢⲎⲘⲞⲤ ⲈⲨⲠⲞⲖⲒⲤ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲈⲪⲢⲀⲒⲘ ⲀϤϢⲰⲠⲈ ⲘⲘⲀⲨ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ⲚⲈϤϨⲎⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲠⲈ ⲚϬⲒ ⲠⲠⲀⲤⲬⲀ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲀⲨⲘⲎⲎϢⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲬⲰⲢⲀ ϨⲀ ⲐⲎ ⲘⲠⲠⲀⲤⲬⲀ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲦⲂⲂⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ⲚⲈⲨϢⲒⲚⲈ ϬⲈ ⲠⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ ⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ϨⲘ ⲠⲈⲢⲠⲈ. ϪⲈ ⲞⲨ ⲠⲈⲦⲤⲚⲆⲞ ϬⲒ ⲚⲎⲦⲚ. ϪⲈ ⲚϤⲚⲎⲨ ⲀⲚ ⲈϨⲢⲀⲒ ⲈⲠϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲈⲀⲨϮ ⲚⲞⲨⲈⲚⲦⲞⲖⲎ ⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀ ⲞⲨⲀ ⲈⲒⲘⲈ ϪⲈ ⲈϤⲦⲰⲚ. ⲈϤⲈⲦⲀⲘⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϬⲞⲠϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ⲒⲎⲤⲞⲨⲤ ϬⲈ ϨⲀⲐⲎ ⲚⲤⲞⲞⲨ ⲚϨⲞⲞⲨ ⲈⲠⲠⲀⲤⲬⲀ ⲀϤⲈⲒ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲘⲘⲞϤ ⲠⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ⲀⲨⲈⲒⲢⲈ ϬⲈ ⲚⲀϤ ⲚⲞⲨⲆⲈⲒⲠⲚⲞⲚ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲰ ⲚⲈⲢⲈ ⲘⲀⲢⲐⲀ ⲆⲒⲀⲔⲞⲚⲒ. ⲖⲀⲌⲀⲢⲞⲤ ⲆⲈ ⲚⲈ ⲞⲨⲀ ⲠⲈ ⲚⲚⲈⲦⲚⲎϪ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ⲘⲀⲢⲒⲀ ϬⲈ ⲀⲤϪⲒ ⲚⲞⲨⲖⲒⲦⲢⲀ ⲚⲤⲞϬⲚ ⲚⲚⲀⲢⲆⲞⲤ ⲘⲠⲒⲤⲦⲒⲔⲎ ⲈⲚⲀϢⲈ ⲤⲞⲨⲚⲦⲤ ⲀⲤⲦⲰϨⲤ ⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲀⲤϤⲰⲦⲈ ⲚⲚⲈϤⲞⲨⲈⲢⲎ ⲦⲈ ϨⲘ ⲠϤⲰ ⲚⲦⲈⲤⲀⲠⲈ. ⲀⲠⲎⲒ ⲆⲈ ⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲦⲞⲒ ⲘⲠⲤⲞϬⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ⲠⲈϪⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲘⲠⲞⲨϮ ⲠⲈⲈⲒⲤⲞϬⲚ ⲈⲂⲞⲖ ϨⲀ ϢⲘⲚⲦ ϢⲈ ⲚⲤⲀⲦⲈⲈⲢⲈ ⲚⲤⲈⲦⲀⲀⲨ ⲚⲚϨⲎⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ⲚⲦⲀϤϪⲈ ⲠⲀⲒ ⲆⲈ. ⲈⲂⲞⲖ ⲀⲚ ϪⲈ ⲠⲈϤⲢⲞⲞⲨϢ ⲠⲈ ⲈⲦⲂⲈ ⲚϨⲎⲔⲈ. ⲀⲖⲖⲀ ϪⲈ ⲚⲈⲨⲢⲈϤϪⲒⲞⲨⲈ ⲠⲈ ⲀⲨⲰ ⲈⲢⲈ ⲠⲈⲄⲖⲰⲤ ⲤⲞⲔⲞⲘⲞⲚ ⲚⲦⲞⲞⲦϤ ⲚⲈϤϨⲰϤⲦ ⲚⲚⲈⲦⲞⲨⲚⲞⲨ ϪⲈ ⲘⲘⲞⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ⲠⲈϪⲀϤ ϬⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲖⲰⲦⲚ ϨⲀⲢⲞⲤ ϪⲈ ⲈⲤⲈϨⲀⲢⲈϨ ⲈⲢⲞϤ ⲈⲠⲈϨⲞⲞⲨ ⲚⲦⲀⲔⲀⲈⲒⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ⲚϨⲎⲔⲈ ⲄⲀⲢ ⲚⲘⲘⲎⲦⲚ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ. ⲀⲚⲞⲔ ⲆⲈ ⲚϮ ⲚⲘⲘⲎⲦⲚ ⲀⲚ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲈⲚⲀϢⲰϤ ⲈⲂⲞⲖ ϨⲚ ⲒⲞⲨⲆⲀⲒ ⲀⲨⲈⲒⲘⲈ ϪⲈ ϤⲘⲘⲀⲨ. ⲀⲨⲰ ⲀⲨⲈⲒ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲚ ⲘⲘⲀⲦⲈ ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲈⲨⲈⲚⲀⲨ ⲈⲖⲀⲌⲀⲢⲞⲤ ⲠⲈⲚⲦⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ⲀⲨϪⲒϢⲞϪⲚⲈ ϬⲈ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲨⲞⲨⲦ ⲘⲠⲔⲈⲖⲀⲌⲀⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ϪⲈ ⲚⲈⲢⲈ ϨⲀϨ ⲚⲒⲞⲨⲆⲀⲒ ⲂⲎⲔ ⲈⲦⲂⲎⲎ ⲦϤ ⲀⲨⲰ ⲚⲈⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ⲠⲈϤⲢⲀⲤⲦⲈ ⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲚⲚⲈⲚⲦⲀⲨⲈⲒ ⲈⲠϢⲀ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲎⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ⲀⲨϪⲒ ⲚϨⲈⲚⲂⲀ ϨⲚ ϨⲈⲚⲂⲚⲚⲈ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲰⲘⲚⲦ ⲈⲢⲞϤ ⲀⲨⲰ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲰⲤⲀⲚⲚⲀ. ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲈⲦⲚⲎⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲠⲢⲢⲞ ⲚⲦⲈ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϨⲈ ⲈⲨⲈⲒⲰ ⲀϤⲀⲖⲈ ⲈⲢⲞϤ ⲔⲀⲦⲀⲐⲈ ⲈⲦⲤⲎϨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲦϢⲈⲈⲢⲈ ⲚⲤⲒⲰⲚ ϪⲈ ⲈⲒⲤ ⲠⲞⲨⲢⲢⲞ ⲚⲎⲨ ⲚⲈ ⲈϤϨⲘⲞⲞⲤ ⲈϪⲚ ⲞⲨⲤⲎϬ ⲚⲈⲒⲰ. ");
INSERT INTO copshc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲘⲠⲞⲨⲈⲒⲘⲈ ⲈⲚⲀⲒ ⲚϢⲞⲢⲠ. ⲀⲖⲖⲀ ⲚⲦⲈⲢⲈϤϪⲒ ⲈⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲦⲞⲦⲈ ⲀⲨⲢⲠⲘⲈⲨⲈ ϪⲈ ⲚⲈⲢⲈ ⲚⲀⲒ ⲤⲎϨ ⲈⲦⲂⲎⲎⲦϤ ⲀⲨⲰ ⲚⲀⲒ ⲚⲈ ⲚⲦⲀⲨⲀⲀⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ⲚⲈϤⲢⲘⲚⲦⲢⲈ ϬⲈ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ⲈⲦⲚⲘⲘⲀϤ ϪⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲖⲀⲌⲀⲢⲞⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲦⲀⲪⲞⲤ ⲀⲨⲰ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ⲈⲦⲂⲈ ⲠⲀⲒ ⲞⲚ ⲀⲠⲘⲎⲎϢⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲎⲦϤ ϪⲈ ⲀϤⲤⲰⲦⲘ ϪⲈ ⲀϤⲢⲠⲈⲒⲘⲀⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ϬⲈ ⲠⲈϪⲀⲨ ⲚⲚⲈⲨⲈⲢⲎⲨ. ϪⲈ ⲦⲈⲦⲚⲚⲀⲨ ϪⲈ ⲚⲦⲈⲦⲚ ϮϨⲎⲨ ⲀⲚ ⲖⲖⲀⲀⲨ. ⲈⲒⲤ ⲠⲔⲞⲤⲘⲞⲤ ⲀϤⲂⲰⲔ ϨⲒ ⲠⲀϨⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ⲚⲈⲨⲚ ϨⲈⲚⲞⲨⲈⲒⲈⲚⲒⲚ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲂⲎⲔ ⲈϨⲢⲀⲒ ⲈⲞⲨⲰϢⲦ ⲘⲠϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ⲚⲀⲒ ϬⲈ ⲀⲨϮ ⲠⲈⲨⲞⲒ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈⲂⲞⲖ ϨⲚ ⲂⲎⲆⲤⲀⲒⲆⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲦⲚⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ⲀⲪⲒⲖⲒⲠⲠⲞⲤ ⲈⲒ ⲀϤϪⲞⲞⲤ ⲈⲀⲚⲆⲢⲈⲀⲤ. ⲀⲚⲆⲢⲈⲀⲤ ⲆⲈ ⲚⲘ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲀⲨϪⲞⲞⲤ ⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ. ϪⲈ ⲀⲦⲈⲨⲚⲞⲨ ⲈⲒ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲒ ⲈⲞⲞⲨ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲈⲢⲈⲦⲘⲦⲂⲖⲂⲒⲖⲈ ⲚⲤⲞⲨⲞ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ ⲚⲤⲘⲞⲨ ϢⲀⲤϬⲰ ⲘⲀⲨⲀⲀⲤ ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲤϢⲀⲚⲘⲞⲨ ϢⲀⲤϮ ⲞⲨⲔⲀⲢⲠⲞⲤ ⲈⲚⲀϢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ⲠⲈⲦⲘⲈ ⲚⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲤⲞⲢⲘⲈⲤ. ⲀⲨⲰ ⲠⲈⲦⲘⲞⲤⲦⲈ ⲚⲦⲈϤⲮⲨⲬⲎ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ϤⲚⲀϨⲈ ⲈⲢⲞⲤ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ⲈϢⲰⲠⲈ ⲞⲨⲚ ⲞⲨⲀ ⲚⲀⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲒ ⲘⲀⲢⲈϤⲞⲨⲀϨϤ ⲚⲤⲰⲈⲒ ⲀⲨⲰ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮ ⲘⲘⲞϤ ⲠⲀⲔⲈⲆⲒⲀⲔⲞⲚⲞⲤ ⲚⲀϢⲰⲠⲈ ⲘⲘⲀⲨ ⲈⲢϢⲀ ⲞⲨⲀ ⲆⲒⲀⲔⲞⲚⲒ ⲚⲀⲒ ⲠⲀⲒⲰⲦ ⲚⲀⲦⲀⲒⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ⲦⲈⲚⲞⲨ ⲀⲦⲀⲮⲨⲬⲎ ϢⲦⲞⲢⲦⲢ ⲀⲨⲰ ⲞⲨ ⲠⲈϮⲚⲀϪⲞⲞϤ. ⲠⲀⲒⲰⲦ ⲘⲀⲦⲞⲨϪⲞⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲒⲞⲨⲚⲞⲨ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈⲒⲞⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ⲠⲀⲒⲰⲦ ϮⲈⲞⲞⲨ ⲘⲠⲈⲔⲢⲀⲚ. ⲀⲨⲤⲘⲎ ϬⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ϪⲈ ⲀⲒϮ ⲈⲞⲞⲨ ⲀⲨⲰ ⲞⲚ ϮⲚⲀϮ ⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ⲠⲘⲎⲎϢⲈ ⲈⲦⲀϨⲈⲢⲀⲦϤ ⲈⲦⲤⲰⲦⲘ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨϨⲢⲞⲨ ⲘⲠⲈ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲠⲈ ⲚⲦⲀϤϢⲀϪⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ⲀϤⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲚⲦⲀ ⲦⲈⲒⲤⲘⲎ ⲈⲒ ⲀⲚ ⲈⲦⲂⲎⲎⲦ ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ⲦⲈⲚⲞⲨ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲦⲈ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ⲦⲈⲚⲞⲨ ⲠⲀⲢⲬⲰⲚ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲤⲈⲚⲀⲚⲞϪϤ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ⲀⲚⲞⲔ ϨⲰ ⲈⲨϢⲀⲚϪⲀⲤⲦ ⲈⲂⲞⲖ ϨⲒϪⲘ ⲠⲔⲀϨ. ϮⲚⲀⲤⲈⲔ ⲞⲨⲞⲚ ⲚⲒⲘ ϢⲀⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ⲚⲈϤϪⲰ ⲆⲈ ⲘⲠⲀⲒ ⲚⲈϤⲤⲎⲘⲀⲚⲈ ϪⲈ ⲈϤⲚⲀⲘⲞⲨ ϨⲚ ⲀϢ ⲘⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ⲀϤⲞⲨⲰϢⲂ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲰⲦⲘ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲀϢⲰⲠⲈ ϢⲀ ⲈⲚⲈϨ. ⲀⲨⲰ ⲚⲀϢ ⲚϨⲈ ⲚⲦⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈⲨϪⲈⲤⲦ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ⲠⲈϪⲀϤ ϬⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈⲦⲒ ⲔⲈⲔⲞⲨⲈⲒ ⲚⲞⲨⲞⲒϢ ⲠⲈ ⲈⲢⲈ ⲠⲞⲨⲞⲒⲚ ϢⲞⲞⲠ ⲚⲘⲘⲎⲦⲚ ⲘⲞⲞϢⲈ ϨⲞⲤⲞⲚ ⲞⲨⲚⲦⲎⲦⲚ ⲠⲞⲨⲞⲒⲚ ϪⲈ ⲚⲚⲈ ⲠⲔⲀⲔⲈ ⲦⲀϨⲈ ⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲠⲈⲦⲘⲞⲞϢⲈ ϨⲘ ⲠⲔⲀⲔⲈ ⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈϤⲚⲀ ⲈⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ϨⲞⲤⲞⲚ ⲞⲨⲚⲦⲎⲦⲚ ⲠⲞⲨⲞⲒⲚ. ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲞⲨⲞⲒⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϢⲰⲠⲈ ⲚϢⲎⲢⲈ ⲚⲦⲈ ⲠⲞⲨⲞⲒⲚ. ⲚⲀⲒ ⲀϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲀϤϨⲞⲠϤ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ⲚⲈⲒⲘⲀⲒⲚ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲀϤⲀⲀⲨ ⲘⲠⲈⲨⲘⲦⲞ ⲈⲂⲞⲖ. ⲘⲠⲞⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠϢⲀϪⲈ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲠⲈⲚⲦⲀϤϪⲞⲞϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲒⲘ ⲠⲈ ⲚⲦⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲚϨⲢⲞⲞⲨ. ⲀⲨⲰ ⲠⲈϬⲂⲞⲈⲒ ⲘⲠϪⲞⲈⲒⲤ ⲚⲦⲀϤϬⲰⲖⲠ ⲈⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ⲈⲦⲂⲈ ⲠⲀⲒ ⲘⲠⲞⲨϢ ϬⲘϬⲞⲘ ⲈⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲀϤϪⲞⲞⲤ ⲞⲚ ⲚϬⲒ ⲎⲤⲀⲒⲀⲤ ");
INSERT INTO copshc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ϪⲈ ⲀϤⲦⲰⲘ ⲚⲚⲈⲨⲂⲀⲖ ⲀⲨⲰ ⲀϤⲦⲰⲘ ⲘⲠⲈⲨϨⲎⲦ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨⲚⲀⲨ ϨⲚ ⲚⲈⲨⲂⲀⲖ ⲀⲨⲰ ⲚⲤⲈⲚⲞⲈⲒ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲦⲀⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ⲚⲀⲒ ⲀϤϪⲞⲞⲨ ⲚϬⲒ ⲎⲤⲀⲒⲀⲤ ϪⲈ ⲀϤⲚⲀⲨ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲀϤϢⲀϪⲈ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ϨⲞⲘⲞⲒⲰⲤ ⲘⲈⲚⲦⲞⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲢⲬⲰⲚ ⲀϨⲀϨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚⲈⲨϨⲞⲘⲞⲖⲞⲄⲒ ⲀⲚ ⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨϢⲰⲠⲈ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ⲀⲨⲘⲈⲢⲈ ⲠⲈⲞⲞⲨ ⲄⲀⲢ ⲚⲢⲢⲰⲘⲈ ⲈϨⲞⲨⲈ ⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ⲒⲎⲤⲞⲨⲤ ϬⲈ ⲀϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲒ. ⲚⲈϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲀⲚ ⲀⲖⲖⲀ ⲈⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ⲀⲨⲰ ⲠⲈⲦⲚⲀⲨ ⲈⲢⲞⲈⲒ. ⲈϤⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲨⲞⲈⲒⲚ ⲈⲚⲦⲀⲈⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ ϪⲈⲔⲀⲀⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲚⲚⲈϤϬⲰ ϨⲘ ⲠⲔⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ⲀⲨⲰ ⲈⲢϢⲀ ⲞⲨⲀ ⲤⲰⲦⲘ ⲈⲚⲀϢⲀϪⲈ ⲚϤϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲀⲚⲞⲔ ⲚϮⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲀⲚ ⲚⲦⲀⲒⲈⲒ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲈⲈⲒⲈⲔⲢⲒⲚⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈⲚⲀϨⲘⲈϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ⲠⲈⲦⲀⲐⲈⲦⲒ ⲘⲘⲞⲈⲒ ⲈⲚϤϪⲒ ⲀⲚ ⲚⲚⲀϢⲀϪⲈ ⲞⲨⲚⲦϤ ⲠⲈⲦⲔⲢⲒⲚⲈ ⲘⲘⲞϤ. ⲠϢⲀϪⲈ ⲈⲚⲦⲀⲒϪⲞⲞϤ ⲚⲦⲞϤ ⲠⲈⲦⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ϨⲘ ⲠϨⲀⲈ ⲚϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ϪⲈ ⲀⲚⲞⲔ ⲚⲦⲀⲒϢⲀϪⲈ ⲀⲚ ϨⲀⲢⲞⲒ ⲘⲘⲀⲨⲀⲀⲦ. ⲀⲖⲖⲀ ⲠⲀⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚⲦⲞϤ ⲠⲈ ⲚⲦⲀϤϮ ⲚⲀⲒ ⲚⲞⲨⲈⲚⲦⲞⲖⲎ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀϪⲞⲞϤ ⲀⲨⲰ ⲞⲨ ⲠⲈϮⲚⲀⲦⲀⲨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ⲀⲨⲰ ϮⲤⲞⲞⲨⲚ ϪⲈ ⲦⲈϤⲈⲚⲦⲞⲖⲎ ⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ⲦⲈ. ⲚⲈϮϪⲰ ϬⲈ ⲘⲘⲞⲞⲨ ⲀⲚⲞⲔ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ϪⲞⲞⲤ ⲚⲀⲒ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈϮϢⲀϪⲈ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ϨⲀ ⲐⲎ ⲆⲈ ⲘⲠϢⲀ ⲘⲠⲠⲀⲤⲬⲀ ⲈϤⲤⲞⲞⲨⲚ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲦⲈϤⲞⲨⲚⲞⲨ ⲈⲒ ϪⲈ ⲈϤⲈⲠⲰⲰⲚⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲚϤⲂⲰⲔ ϢⲀ ⲠⲒⲰⲦ. ⲈⲀϤⲘⲈⲢⲈ ⲚⲈⲦⲈ ⲚⲞⲨϤ ⲚⲈ ⲈⲦϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲀϤⲘⲈⲢⲒⲦⲞⲨ ϢⲀⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲞⲨⲆⲒⲠⲚⲞⲚ ϢⲰⲠⲈ ⲈⲀ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲞⲨⲰ ⲈϤⲚⲞⲨϪⲈ ⲘⲘⲞⲤ ⲈⲠϨⲎⲦ ⲚⲒⲞⲨⲆⲀⲤ ⲠϢⲎⲢⲈ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ⲈϤⲤⲞⲞⲨⲚ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲠⲒⲰⲦ ϮⲚⲔⲀ ⲚⲒⲘ ⲈⲚⲈϤϬⲒϪ ⲀⲨⲰ ϪⲈ ⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲈϤⲚⲀ ⲈⲢⲀⲦϤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ⲀϤⲦⲰⲞⲨⲚϤ ϨⲘ ⲠⲆⲈⲒⲠⲚⲞⲚ ⲀϤⲔⲀ ⲚⲈϤϨⲞⲒⲦⲈ ⲈϨⲢⲀⲒ ⲀϤϪⲒ ⲚⲞⲨⲖⲈⲚⲦⲒⲞⲚ ⲀϤⲘⲞⲢϤ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ⲀⲨⲰ ⲀϤⲚⲈϪ ⲘⲞⲞⲨ ⲈⲦⲖⲈⲔⲀⲚⲎ ⲀϤⲀⲢⲬⲒⲚⲈⲒⲰ ⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲈϤⲞⲦⲞⲨ ⲘⲠⲖⲈⲚⲦⲒⲞⲚ ⲈⲦⲘⲎⲢ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ⲀϤⲈⲒ ϬⲈ ϢⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲈ ⲠⲎ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲞⲔ ⲠⲈⲦⲚⲀⲈⲒⲀ ⲚⲀⲞⲨⲈⲢⲎ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ ⲚⲦⲞⲔ ⲚⲄⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲦⲈⲚⲞⲨ. ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲔⲚⲀⲈⲒⲘⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲚⲀⲔⲀⲀⲔ ⲈⲈⲒⲀ ⲢⲀⲦ ⲈⲚⲈϨ ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲚⲀϤ ϪⲈ ⲈⲒⲦⲘⲈⲒⲀ ⲢⲀⲦⲔ ⲘⲚⲦⲔ ⲘⲈⲢⲞⲤ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲀⲞⲨⲈⲢⲎⲦⲈ. ⲀⲖⲖⲀ ⲈⲒⲀ ⲚⲀⲔⲈϬⲒϪ ⲚⲘ ⲦⲀⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲠⲈⲚⲦⲀϤϪⲰⲔⲘ ⲚϤⲢⲬⲢⲒⲀ ⲀⲚ ⲈⲒ ⲘⲎⲦⲒ ⲈⲒⲀ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲀⲖⲖⲀ ϤⲦⲂⲂⲎⲨ ⲦⲎⲢϤ ⲚⲦⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲦⲂⲂⲎⲨ ⲀⲖⲖⲀ ⲚⲦⲎⲢⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ⲚⲈϤⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲘⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲀϤϪⲞⲞⲤ ϪⲈ ⲚⲦⲈⲦⲚ ⲦⲂⲂⲎⲨ ⲀⲚ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ⲚⲦⲈⲢⲈϤⲞⲨⲰ ϬⲈ ⲈϤⲈⲒⲰ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲀϤϪⲒⲚⲈϤϨⲞⲒⲦⲈ. ⲀϤⲚⲞϪϤ ⲞⲚ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲚⲦⲀⲒⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲘⲞⲨⲦⲈ ⲈⲢⲞⲈⲒ ϪⲈ ⲠⲤⲀϨ ⲀⲨⲰ ⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲔⲀⲖⲰⲤ ⲦⲈⲦⲚϪⲰ ⲘⲘⲞⲤ ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ⲈϢϪⲈ ⲀⲚⲞⲔ ϬⲈ ⲀⲒⲀ ⲚⲈⲦⲚⲞⲨⲈⲢⲎⲦⲈ ⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠⲤⲀϨ. ⲚⲦⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ϢϢⲈ ⲈⲢⲰⲦⲚ ⲈⲈⲒⲀ ⲢⲀⲦⲞⲨ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ⲞⲨⲤⲘⲞⲦ ⲄⲀⲢ ⲠⲈ ⲚⲦⲀⲒⲦⲀⲀϤ ⲚⲎⲦⲚ. ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲒⲀⲀⲤ ⲚⲎⲦⲚ. ⲈⲦⲈⲦⲚⲈⲀⲀⲤ ϨⲰⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲘⲚ ϨⲘϨⲀⲖ ⲈⲚⲀⲀⲀϤ ⲈⲠⲈϤϪⲞⲈⲒⲤ ⲞⲨⲆⲈ ⲘⲚ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲚⲀⲀⲀϤ ⲈⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ⲈϢϪⲈ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲚⲚⲀⲒ ⲚⲀⲒⲀⲦⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚϢⲀⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ⲚⲈⲈⲒϪⲈⲢⲰⲦⲚ ⲦⲎⲢⲦⲚ ⲀⲚ ⲀⲚⲞⲔ ⲈⲦⲤⲞⲞⲨⲚ ⲚⲚⲈⲚⲦⲀⲒⲤⲞⲦⲠⲞⲨ ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲠⲈⲦⲞⲨⲰⲘ ⲘⲠⲀⲞⲒⲔ ⲀϤϤⲒ ⲠⲈϤϮⲂⲤ ⲈϨⲢⲀⲒ ⲈϪⲰⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ϪⲒⲚ ⲦⲈⲚⲞⲨ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲈⲘⲠⲀⲦϤϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ ⲈϤϢⲀⲚϢⲰⲠⲈ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦϪⲒ ⲘⲠⲈϮⲚⲀⲦⲚⲚⲞⲞⲨϤ. ⲈϤϪⲒ ⲘⲘⲞⲈⲒ. ⲠⲈⲦϪⲒ ⲆⲈ ⲘⲘⲞⲒ ⲈϤϪⲒ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ⲚⲀⲒ ⲚⲦⲈⲢⲈϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϢⲦⲞⲢⲦⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲀⲨⲰ ⲀϤⲢⲘⲚⲦⲢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ⲚⲈⲨϬⲰϢⲦ ϬⲈ ⲈϨⲞⲨⲚ ϨⲚ ⲚⲈⲨⲈⲢⲎⲨ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲨⲀⲠⲞⲢⲒ ϪⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲦⲂⲈ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ⲚⲈⲨⲚ ⲞⲨⲀ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈϤⲚⲎϪ ⲈⲔⲞⲨⲚϤ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲈⲢⲈⲒⲤ ⲘⲈ ⲘⲘⲞϤ ");
INSERT INTO copshc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ⲀϤϪⲰⲢⲘ ϬⲈ ⲞⲨⲂⲈ ⲠⲀⲒ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϪⲚ ⲞⲨϤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦϤϢⲀϪⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ⲀⲠⲎ ϬⲈ ⲚⲞϪϤ ⲈϪⲚ ⲦⲘⲈⲤⲐⲎⲦ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲒⲘ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲠⲈϮⲚⲀⲤⲈⲠⲠⲞⲈⲒⲔ ⲦⲀⲦⲀⲀϤ ⲚⲀϤ Ⲡ ⲈⲦⲘⲘⲀⲨ ⲠⲈ. ⲚⲦⲈⲢⲈϤⲤⲈⲠ ⲠⲞⲒⲔ ⲆⲈ ⲀϤⲦⲀⲀϤ ⲚⲒⲞⲨⲆⲀⲤ ⲠϢⲎⲢⲈ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ⲀⲨⲰ ⲘⲚⲚⲤⲀ ⲦⲢⲈϤϪⲒ ⲠⲞⲒⲔ ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲠⲈϪⲀϤ ϬⲈ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲠⲈⲦⲔⲚⲀⲀⲀϤ ⲀⲢⲒϤ ϨⲚ ⲞⲨϬⲈⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ⲘⲠⲈ ⲖⲀⲀⲨ ⲆⲈ ⲚⲚⲈⲦⲚⲎϪ ⲈⲒⲘⲈ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀϤϪⲈ ⲠⲀⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ⲚⲈⲢⲈ ϨⲞⲒⲚⲈ ⲄⲀⲢ ⲘⲈⲨⲈ ϪⲈ ⲈⲠⲒⲆⲎ ⲠⲈⲄⲖⲰⲤ ⲤⲞⲔⲞⲘⲞⲚ ⲚⲦⲞⲞⲦϤ ⲚⲒⲞⲨⲆⲀⲤ. ϪⲈ ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ϢⲈⲠ ⲠⲈⲦⲈⲦⲚⲢⲬⲢⲒⲀ ⲘⲘⲞϤ ⲈⲠϢⲀ ⲎϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈϮ ⲚⲚϨⲎⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ⲚⲦⲈⲢⲈϤϪⲒ ϬⲈ ⲘⲠⲞⲈⲒⲔ ⲚϬⲒ ⲠⲎ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚⲈ ⲦⲈⲨϢⲎ ⲆⲈ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ⲚⲦⲈⲢⲈϤⲈⲒ ϬⲈ ⲈⲂⲞⲖ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲈⲚⲞⲨ ⲀϤϪⲒ ⲈⲞⲞⲨ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲀⲨⲰ ⲀⲠⲚⲞⲨⲦⲈ ϪⲒ ⲈⲞⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ⲈϢϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ϪⲒ ⲈⲞⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲚⲀϮ ⲈⲞⲞⲨ ⲚⲀϤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ϤⲚⲀϮ ⲈⲞⲞⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ⲚⲀϢⲎⲢⲈ ⲈⲦⲒ ⲔⲈⲔⲞⲨⲒ ⲠⲈϮ ⲚⲘⲘⲎⲦⲚ. ⲦⲈⲦⲚⲀϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲒϪⲞⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀⲂⲰⲔ ⲈⲢⲞϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲀϢⲈⲒ ⲀⲚ ⲈⲢⲞϤ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ⲠⲖⲎⲚ ϮϮ ⲚⲞⲨⲈⲚⲦⲞⲖⲎ ⲂⲂⲢⲢⲈ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲘⲈⲢⲈ ⲚⲈⲦⲚⲈⲢⲎⲨ. ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲒⲘⲈⲢⲈ ⲦⲎⲨⲦⲚ. ϪⲈⲔⲀⲀⲤ ϨⲰⲰⲦⲚ ⲈⲦⲈⲦⲚⲈⲘⲈⲢⲈ ⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ϨⲘ ⲠⲀⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲀⲈⲒⲘⲈ ϪⲈ ⲚⲦⲈⲦⲚ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲈⲦⲚϢⲀⲘⲈⲢⲈ ⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲔⲚⲀ ⲈⲦⲰⲚ ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀ ⲂⲰⲔ ⲈⲢⲞϤ ⲔⲚⲀϢⲞⲨⲀϨⲔ ⲚⲤⲰⲒ ⲀⲚ ⲦⲈⲚⲞⲨ ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲈⲔⲈⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲦⲂⲈ ⲞⲨ ⲚϮⲚⲀⲞⲨⲀϨⲦ ⲚⲤⲰⲔ ⲀⲚ ⲦⲈⲚⲞⲨ. ϮⲚⲀⲔⲰ ⲚⲦⲀⲮⲨⲬⲎ ⲈϨⲢⲀⲒ ϨⲀⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲔⲚⲀⲔⲀ ⲦⲈⲔⲮⲨⲬⲎ ϨⲀⲢⲞⲒ. ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲈⲘⲠⲔⲀⲢⲚⲀ ⲘⲘⲞⲒ ⲚϢⲞⲘⲚⲦ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ⲘⲠⲢⲦⲢⲈ ⲠⲈⲦⲚϨⲎⲦ ϢⲦⲞⲢⲦⲢ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ⲞⲨⲚ ϨⲀϨ ⲘⲘⲀ ⲚϢⲰⲠⲈ ϨⲘ ⲠⲎⲒ ⲘⲠⲀⲒⲰⲦ. ⲈⲚⲈ ⲘⲘⲞⲚ. ⲚⲈⲒⲚⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ⲠⲈ ϪⲈ ϮⲚⲀⲂⲰⲔ ⲈⲤⲂⲦⲈ ⲞⲨⲘⲀ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ⲀⲨⲰ ⲞⲚ ⲈⲒϢⲀⲚⲂⲰⲔ ⲦⲀⲤⲂⲦⲈ ⲞⲨⲘⲀ ⲚⲎⲦⲚ ϮⲚⲎⲨ ⲞⲚ ⲦⲀϪⲒ ⲦⲎⲨⲦⲚ ϢⲀⲢⲞⲈⲒ ϪⲈⲔⲀⲀⲤ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲘⲘⲞϤ ⲈⲦⲈⲦⲚⲈϢⲰⲠⲈ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ⲀⲨⲰ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀ ⲈⲢⲞϤ. ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲚⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ⲠⲈϪⲈ ⲐⲰⲘⲀⲤ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲔⲚⲀ ⲈⲦⲰⲚ ⲚⲀϢ ⲚϨⲈ ⲦⲚⲚⲀϢ ⲤⲞⲨⲚ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲦⲈϨⲒⲎ ⲀⲨⲰ ⲦⲘⲈ ⲀⲨⲰ ⲠⲰⲚϨ ⲘⲚ ⲖⲀⲀⲨ ⲚⲎⲨ ϢⲀⲠⲒⲰⲦ ⲈⲒ ⲘⲎⲦⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ⲈϢϪⲈ ⲀⲦⲈⲦⲚⲤⲞⲨⲰⲚⲦ. ⲦⲈⲦⲚⲀⲤⲞⲨⲚ ⲠⲀⲔⲈⲒⲰⲦ. ⲀⲨⲰ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲨⲰ ⲀⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ⲠⲈϪⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲀⲦⲤⲀⲂⲞⲚ ⲈⲠⲈⲔⲈⲒⲰⲦ ⲀⲨⲰ ϨⲰ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲈⲈⲒⲞⲨⲞⲒϢ ⲦⲎⲢϤ ϮⲚⲘⲘⲎⲦⲚ ⲀⲨⲰ ⲘⲠⲔⲤⲞⲨⲰⲚⲦ ⲪⲒⲖⲒⲠⲠⲈ. ⲠⲈⲚⲦⲀϤⲚⲀⲨ ⲈⲢⲞⲒ ⲀϤⲚⲀⲨ ⲈⲠⲒⲰⲦ ⲀⲨⲰ ⲚⲦⲞⲔ ⲚⲀϢ ⲚϨⲈ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀⲦⲤⲀⲂⲞⲚ ⲈⲠⲈⲔⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ⲚⲄⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ϪⲈ ⲀⲚⲞⲔ ϮϨⲘ ⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲠⲀⲒⲰⲦ ⲚϨⲎⲦ ⲚϢⲀϪⲈ ⲀⲚⲞⲔ ⲈϮϪⲰ ⲘⲘⲞⲞⲨ ⲚⲎⲦⲚ ⲚⲈⲒϪⲰ ⲘⲘⲞⲞⲨ ⲀⲚ ϨⲀⲢⲞⲒ ⲘⲀⲨⲀⲀⲦ ⲠⲀⲒⲰⲦ ⲆⲈ ⲈⲦϢⲞⲞⲠ ⲚϨⲎⲦ ϤⲒⲢⲈ ⲚⲚⲈϤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲀⲒ ϪⲈ ⲀⲚⲞⲔ ϮϨⲘ ⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲠⲀⲒⲰⲦ ⲚϨⲎⲦ. ⲈϢϪⲈ ⲘⲘⲞⲚ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲈϤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲚⲈϨⲂⲎⲨⲈ ⲈϮⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ⲠⲎ ϨⲰⲰϤ ⲞⲚ ⲚⲀⲀⲀⲨ. ⲀⲨⲰ ϤⲚⲀⲢ ⲚⲈⲦⲚⲀⲀⲀⲨ ⲈⲢⲞⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲈⲈⲒⲚⲀⲂⲰⲔ ϢⲀ ⲠⲀⲒⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ⲀⲨⲰ ⲠⲈⲦⲈⲦⲚⲀⲀⲒⲦⲒ ⲘⲘⲞϤ ϨⲘ ⲠⲀⲢⲀⲚ ⲠⲀⲒ ϮⲚⲀⲀⲀϤ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲒⲰⲦ ϪⲒⲈⲞⲞⲨ ϨⲘ ⲠϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ⲈⲦⲈⲦⲚϢⲀⲚⲀⲒⲦⲒ ⲚⲞⲨϨⲰⲂ ϨⲘ ⲠⲀⲢⲀⲚ. ⲠⲀⲒ ϮⲚⲀⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ⲈⲦⲈⲦⲚϢⲀⲘⲈⲢⲒⲦ. ⲦⲈⲦⲚⲀϨⲀⲢⲈϨ ⲈⲚⲀⲈⲚⲦⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲤⲈⲠⲤ ⲠⲒⲰⲦ ⲀⲨⲰ ϤⲚⲀϮ ⲚⲎⲦⲚ ⲚⲔⲈⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϢⲰⲠⲈ ⲚⲘⲘⲎⲦⲚ ϢⲀ ⲈⲚⲈϨ ");
INSERT INTO copshc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲦⲘⲈ ⲠⲈⲦⲈ ⲘⲘⲚ ϢϬⲞⲘ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲈϪⲒⲦϤ ϪⲈ ⲚϤⲚⲀⲨ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲆⲈ ⲚϤⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ϤⲚⲀϬⲰ ϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲚϤϢⲰⲠⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ⲚϮⲚⲀⲔⲀ ⲦⲎⲨⲦⲚ ⲀⲚ ⲈⲦⲈⲦⲚⲞ ⲚⲞⲢⲪⲀⲚⲞⲤ. ϮⲚⲎⲨ ϢⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ⲈϮⲔⲈⲔⲞⲨⲒ ⲠⲈ ⲀⲨⲰ ⲘⲠⲔⲞⲤⲘⲞⲤ ϬⲈ ⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲈⲢⲞⲈⲒ ϪⲈ ⲀⲚⲞⲔ ϮⲞⲚϨ ⲀⲨⲰ ⲚⲦⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲦⲈⲦⲚⲀⲈⲒⲘⲈ ⲚⲦⲰⲦⲚ ϪⲈ ⲀⲚⲞⲔ ϮϨⲘ ⲠⲀⲒⲰⲦ ⲀⲨⲰ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ⲠⲈⲦⲈⲨⲚⲦϤ ⲚⲀⲈⲚⲦⲞⲖⲎ ⲀⲨⲰ ⲈⲦϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈⲦⲘⲈ ⲘⲘⲞⲒ. ⲠⲈⲦⲘⲈ ⲆⲈ ⲘⲘⲞⲒ ⲠⲀⲒⲰⲦ ⲚⲀⲘⲈⲢⲒⲦϤ. ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲘⲈⲢⲒⲦϤ ⲀⲨⲰ ϮⲚⲀⲞⲨⲞⲚϨⲦ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ⲠⲈϪⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲔⲀⲚⲀⲚⲒⲦⲎⲤ ⲚⲀϤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲦⲂⲈ ⲞⲨ ⲈⲔⲚⲀⲞⲨⲞⲚϨⲔ ⲚⲀⲚ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲄⲦⲘⲞⲨⲞⲚϨⲔ ⲈⲂⲞⲖ ⲘⲠⲔⲞⲤⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲢϢⲀ ⲚⲞⲨⲀ ⲘⲈⲢⲒⲦ. ϤⲚⲀϨⲀⲢⲈϨ ⲈⲠⲀϢⲀϪⲈ ⲀⲨⲰ ⲠⲀⲒⲰⲦ ⲚⲀⲘⲈⲢⲒⲦϤ ⲀⲨⲰ ⲦⲚⲚⲎⲨ ϢⲀⲢⲞϤ. ⲚⲦⲚⲦⲀⲘⲒⲞ ⲚⲀⲚ ⲚⲞⲨⲘⲀ ⲚϢⲰⲠⲈ ϨⲀϨⲦⲎϤ. ");
INSERT INTO copshc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ⲠⲈⲦⲈ ⲚϤⲘⲈ ⲀⲚ ⲘⲘⲞⲒ ⲚϤⲚⲀϨⲀⲢⲈϨ ⲀⲚ ⲈⲠⲀϢⲀϪⲈ. ⲀⲨⲰ ⲠϢⲀϪⲈ ⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲈⲢⲞϤ ⲘⲠⲰⲒ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲠⲀ ⲠⲀⲒⲰⲦ ⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ⲈⲒϢⲞⲞⲠ ϨⲀ ϨⲦⲚ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ϨⲞⲦⲀⲚ ⲆⲈ ⲈϤϢⲀⲚⲈⲒ ⲚϬⲒ ⲠⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲠⲈⲦⲈⲢⲈ ⲠⲒⲰⲦ ⲚⲀⲦⲚⲚⲞⲞⲨϤ ϨⲘ ⲠⲀⲢⲀⲚ ⲠⲈⲦⲘⲘⲀⲨ ⲚⲀⲦⲤⲀⲂⲈ ⲦⲎⲨⲦⲚ ⲈϨⲰⲂ ⲚⲒⲘ ⲀⲨⲰ ⲚϤⲦⲢⲈⲦⲚⲢⲠⲘⲈⲨⲈ ⲚϢⲀϪⲈ ⲚⲒⲘ ⲈⲚⲦⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ϮⲔⲰ ⲚⲎⲦⲚ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲦⲀⲈⲒⲢⲎⲚⲎ ⲈⲦⲈ ⲦⲰⲈⲒ ⲦⲈ ϮϮ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲚⲔⲀⲦⲀ ⲐⲈ ⲀⲚ ⲈϢⲀⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ ϮⲀⲚⲞⲔ ⲈⲒϮ ⲚⲎⲦⲚ ⲘⲠⲢⲦⲢⲈ ⲠⲈⲦⲚϨⲎⲦ ϢⲦⲞⲢⲦⲢ ⲞⲨⲆⲈ ⲘⲠⲢⲦⲢⲈϤⲢϬ ⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ϮⲚⲀⲂⲰⲔ ⲦⲀⲒ ⲞⲚ ϢⲀⲢⲰⲦⲚ. ⲈⲚⲈⲦⲈⲦⲘⲘⲈ ⲘⲘⲞⲒ. ⲚⲈⲦⲈⲦⲚⲀⲢⲀϢⲈ ⲠⲈ ϪⲈ ⲈⲈⲒⲚⲀⲂⲰⲔ ϢⲀ ⲠⲒⲰⲦ ϪⲈ ⲠⲀⲒⲰⲦ ⲚⲀⲀⲀϤ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ⲀⲨⲰ ⲦⲈⲚⲞⲨ ⲀⲒϪⲞⲞϤ ⲚⲎⲦⲚ ⲈⲘⲠⲀⲦϤϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈϤϢⲀⲚϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ⲚϮⲚⲀϪⲈ ϨⲀϨ ϬⲈ ⲀⲚ ⲚϢⲀϪⲈ ⲚⲎⲦⲚ. ϤⲚⲎⲨ ⲄⲀⲢ ⲚϬⲒ ⲠⲀⲢⲬⲰⲚ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲀⲨⲰ ⲘⲚⲦϤⲖⲀⲀⲨ ϨⲢⲀⲒ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ⲀⲖⲖⲀ ϪⲈ ⲈⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲈⲒⲘⲈ ϪⲈ ϮⲘⲈ ⲘⲠⲀⲒⲰⲦ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈϮⲈⲒⲢⲈ ⲘⲘⲞⲤ. ⲦⲞⲨⲚ ⲦⲎⲨⲦⲚ ⲘⲀⲢⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ⲀⲚⲞⲔ ⲠⲈ ⲦⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ ⲘⲘⲈ ⲀⲨⲰ ⲠⲀⲒⲰⲦ ⲠⲈ ⲠⲞⲨⲞⲞⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ϢⲖϨ ⲚⲒⲘ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲠⲈⲦⲈ ⲚϤⲚⲀϮ ⲔⲀⲢⲠⲞⲤ ⲀⲚ ϤⲚⲀⲤⲞⲖⲠϤ ⲀⲨⲰ ϢⲖϨ ⲚⲒⲘ ⲈⲦⲚⲀϮ ⲔⲀⲢⲠⲞⲤ ϤⲚⲀⲦⲂⲂⲞϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϮ ϨⲞⲨⲈ ⲔⲀⲢⲠⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲦⲂⲂⲎⲨ ⲈⲦⲂⲈ ⲠϢⲀϪⲈ ⲈⲚⲦⲀⲒϪⲞⲞϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ϬⲰ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲔⲀⲦⲀ ⲐⲈ ⲘⲠϢⲖϨ ⲈⲦⲈ ⲚϤⲚⲀϢϮ ⲔⲀⲢⲠⲞⲤ ⲀⲚ ϨⲀⲢⲞϤ ⲘⲘⲀⲨ ⲀⲀϤ ⲈⲒ ⲘⲎⲦⲒ ⲚϤϬⲰ ϨⲚ ⲦⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ. ⲦⲀⲒ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈ ⲦⲈⲦⲚϨⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲦⲘϬⲰ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ⲀⲚⲞⲔ ⲠⲈ ⲦⲂⲰ ⲚⲈⲖⲞⲞⲖⲈ ⲚⲦⲰⲦⲚ ⲚⲈ ⲚϢⲖϨ ⲠⲈⲦⲚⲀϬⲰ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ⲚϨⲎⲦϤ ⲠⲀⲒ ⲚⲀϮ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ ⲈⲚⲀϢⲰϤ ϪⲈ ⲀϪⲚⲦ ⲚⲦⲈⲦⲚⲀϢⲢⲖⲀⲀⲨ ⲀⲚ ⲚϨⲰⲂ ");
INSERT INTO copshc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ⲈⲢⲈⲦⲘ ⲞⲨⲀ ϬⲰ ϨⲢⲀⲒ ⲚϨⲎⲦ. ⲀⲨⲚⲞϪϤ ⲈⲂⲞⲖ ⲚⲐⲈ ⲘⲠϢⲖϨ ⲀⲨⲰ ⲀϤϢⲞⲞⲨⲈ ⲀⲨⲰ ⲤⲈⲚⲀⲤⲞⲞⲨϨⲞⲨ ⲚⲤⲈⲚⲞϪⲞⲨ ⲈⲠⲔⲰϨⲦ ⲚⲤⲈⲢⲞⲬⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ⲈⲦⲈⲦⲚϢⲀⲚϬⲰ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲚⲦⲈ ⲚⲀϢⲀϪⲈ ϬⲰ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲠⲈⲦⲈⲦⲚⲀⲞⲨⲀϢϤ ⲀⲒⲦⲒ ⲘⲘⲞϤ ⲀⲨⲰ ϤⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ϨⲘ ⲠⲀⲒ ⲀϤϪⲒ ⲈⲞⲞⲨ ⲚϬⲒ ⲠⲀⲒⲰⲦ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϮ ⲞⲨⲔⲀⲢⲠⲞⲤ ⲈⲚⲀϢⲰϤ ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲚⲀⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ⲘⲈⲢⲒⲦ ⲀⲚⲞⲔ ϨⲰ ⲀⲒⲘⲈⲢⲈ ⲦⲎⲨⲦⲚ. ϬⲰ ϨⲢⲀⲒ ϨⲚ ⲦⲀⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ⲈⲦⲈⲦⲚϢⲀϨⲀⲢⲈϨ ⲈⲚⲀⲈⲚⲦⲞⲖⲎ. ⲦⲈⲦⲚⲀϬⲰ ϨⲚ ⲦⲀⲀⲄⲀⲠⲎ. ⲔⲀⲦⲀ ⲐⲈ ϨⲰ ⲈⲚⲦⲀⲒ ϨⲀⲢⲈϨ ⲈⲚⲈⲚⲦⲞⲖⲎ ⲘⲠⲀⲒⲰⲦ ⲀⲨⲰ ϮϬⲈⲈⲦ ϨⲚ ⲦⲈϤⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲀⲢⲀϢⲈ ϢⲰⲠⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲚⲦⲈ ⲠⲈⲦⲚⲢⲀϢⲈ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ⲦⲀⲒ ⲦⲈ ⲦⲀⲈⲚⲦⲞⲖⲎ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲘⲈⲢⲈ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲒⲘⲈⲢⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ⲘⲚⲦⲈ ⲖⲀⲀⲨ ⲀⲄⲀⲠⲎ ⲈⲚⲀⲀⲀϤ ⲈⲦⲀⲈⲒ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲔⲰ ⲚⲦⲈϤⲮⲨⲬⲎ ϨⲀⲚⲈϤϢⲂⲈⲈⲢ. ");
INSERT INTO copshc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲚⲀϢⲂⲈⲈⲢ. ⲈⲦⲈⲦⲚϢⲀⲚⲈⲒⲢⲈ ⲚⲚⲈϮϨⲰⲚ ⲘⲘⲞⲞⲨ ⲈⲦⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ⲚϮⲚⲀⲘⲞⲨⲦⲈ ϬⲈ ⲀⲚ ⲈⲢⲰⲦⲚ ϪⲈ ⲚⲀϨⲘϨⲀⲖ ϪⲈ ⲠϨⲘϨⲀⲖ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϪⲞⲈⲒⲤ ⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲀⲒⲘⲞⲨⲦⲈ ⲈⲢⲰⲦⲚ ϪⲈ ⲚⲀϢⲂⲈⲈⲢ ϪⲈ ⲚⲈⲚⲦⲀⲒⲤⲞⲦⲘⲞⲨ ⲦⲎⲢⲞⲨ ⲚⲦⲈ ⲠⲀⲒⲰⲦ ⲀⲒⲦⲀⲘⲰⲦⲚ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ⲚⲦⲰⲦⲚ ⲀⲚ ⲀⲦⲈⲦⲚⲤⲞⲦⲠⲦ. ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲀⲒⲤⲈⲦⲠ ⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲀⲒⲔⲀ ⲦⲎⲨⲦⲚ ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈⲂⲰⲔ ⲚⲦⲈⲦⲚ ϮⲔⲀⲢⲠⲞⲤ ⲀⲨⲰ ⲚⲦⲈ ⲠⲈⲦⲚⲔⲀⲢⲠⲞⲤ ⲘⲞⲨⲚ ⲈⲂⲞⲖ ϢⲀ ⲈⲚⲈϨ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚϢⲀⲚⲀⲒⲦⲒ ⲘⲠⲒⲰⲦ ϨⲘ ⲠⲀⲢⲀⲚ ⲈϤⲈⲦⲀⲀϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ⲚⲀⲒ ⲈⲒϨⲰⲚ ⲘⲘⲞⲞⲨ ⲈⲦⲈ ⲦⲎⲨⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲘⲈⲢⲈⲚ ⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ⲈϢϪⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ ⲈⲒⲘⲈ ϪⲈ ⲀϤⲘⲈⲤⲦⲰⲈⲒ ϨⲀⲦⲈⲦⲚϨⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ⲈⲚⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲚⲈⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲚⲀⲘⲈⲢⲈ ⲠⲈⲦⲈ ⲠⲰϤ ⲠⲈ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲆⲈ ⲀⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲀⲒⲤⲈⲦⲠ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲔⲞⲤⲘⲞⲤ ⲘⲞⲤⲦⲈ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ⲀⲢⲒⲠⲘⲈⲨⲈ ⲘⲠϢⲀϪⲈ ⲈⲚⲦⲀⲒϪⲞⲞϤ ⲚⲎⲦⲚ ϪⲈ ⲘⲚ ϨⲘϨⲀⲖ ⲈⲚⲀⲀⲀϤ ⲈⲠⲈϤϪⲞⲈⲒⲤ ⲈϢϪⲈ ⲀⲨⲠⲰⲦ ⲚⲤⲰⲈⲒ ⲤⲈⲚⲀⲠⲰⲦ ⲚⲤⲀ ⲦⲎⲨⲦⲚ ⲈϢϪⲈ ⲀⲨϨⲀⲢⲈϨ ⲈⲠⲀϢⲀϪⲈ ⲤⲈⲚⲀϨⲀⲢⲈϨ ⲞⲚ ⲈⲠⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ⲀⲖⲖⲀ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲨⲚⲀⲀⲀⲨ ⲚⲎⲦⲚ ⲈⲦⲂⲈ ⲠⲀⲢⲀⲚ ϪⲈ ⲚⲤⲈⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ⲈⲚⲈ ⲘⲠⲒⲈⲒ ⲦⲀϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲚⲈ ⲘⲘⲚ ⲚⲞⲂⲈ ⲈⲢⲞⲞⲨ. ⲦⲈⲚⲞⲨ ⲆⲈ ⲘⲚⲦⲞⲨ ⲖⲞⲒϬⲈ ⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲠⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ⲠⲈⲦⲘⲞⲤⲦⲈ ⲘⲘⲞⲒ ϤⲘⲞⲤⲦⲈ ⲞⲚ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ⲈⲚⲈⲘⲠⲒⲢⲚⲈϨⲂⲎⲨⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲈⲦⲈⲘⲠⲈⲔⲈⲨⲀ ⲀⲀⲨ. ⲚⲈⲘⲘⲚⲦⲞⲨⲚⲞⲂⲈ ⲘⲘⲀⲨ. ⲦⲈⲚⲞⲨ ⲆⲈ ⲀⲨⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲨⲰ ⲀⲨⲘⲈⲤⲦⲰⲒ ⲚⲘⲠⲀⲔⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠϢⲀϪⲈ ⲈⲦⲤⲎϨ ϨⲘ ⲠⲈⲨⲚⲞⲘⲞⲤ ϪⲈ ⲀⲨⲘⲈⲤⲦⲰⲈⲒ ⲈⲠϪⲒⲚϪⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ϨⲞⲦⲀⲚ ⲈϤϢⲀⲚⲈⲒ ⲚϬⲒ ⲠⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ⲠⲈϮⲚⲀⲦⲚⲚⲞⲞⲨϤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲒⲰⲦ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲦⲘⲈ ⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲒⲰⲦ ⲠⲈⲦⲘⲘⲀⲨ ⲚⲀⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ⲀⲨⲰ ⲚⲦⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚⲢⲘⲚⲦⲢⲈ ϪⲈ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲦⲈⲦⲚϢⲞⲞⲠ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲦⲚⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ⲀⲨⲢ ⲦⲎⲨⲦⲚ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ. ⲀⲖⲖⲀ ⲤⲚⲎⲨ ⲚϬⲒ ⲞⲨⲞⲨⲚⲞⲨ ϨⲞⲦⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲘⲞⲨⲞⲨⲦ ⲘⲘⲰⲦⲚ ⲈϤⲘⲈⲨⲈ ϪⲈ ⲈϤⲈⲒⲢⲈ ⲚⲞⲨϢⲘϢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ⲀⲨⲰ ⲈⲨⲚⲀⲢ ⲚⲀⲒ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲞⲨⲤⲞⲨⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲆⲈ ⲘⲠⲞⲨⲤⲞⲨⲰⲚⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢϢⲀ ⲦⲈⲨⲚⲞⲨ ⲈⲒ ⲈⲦⲈⲦⲚⲈⲢⲠⲘⲈⲈⲨⲈ ϪⲈ ⲀⲚⲞⲔ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ. ⲚⲀⲒ ⲆⲈ ⲘⲠⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲒⲚ ⲚϢⲞⲢⲠ ϪⲈ ⲚⲈⲒⲚⲘⲘⲎⲦⲚ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ⲦⲈⲚⲞⲨ ⲆⲈ ⲈⲈⲒⲚⲀⲂⲰⲔ ϢⲀ ⲠⲈⲚⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲀⲨⲰ ⲘⲘⲚ ⲖⲀⲀⲨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ϪⲚⲞⲨ ⲘⲘⲞⲒ ϪⲈ ⲈⲔⲚⲀ ⲈⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ⲀⲖⲖⲀ ϪⲈ ⲀⲒϪⲈ ⲚⲀⲒ ⲚⲎⲦⲚ. ⲀⲦⲖⲨⲠⲎ ⲘⲈϨ ⲠⲈⲦⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲈⲒϪⲰ ⲚⲎⲦⲚ ⲚⲦⲘⲈ ⲤⲢⲚⲞϤⲢⲈ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲀⲚⲞⲔ ⲈⲈⲒⲈⲂⲰⲔ ⲈⲈⲒⲦⲘⲂⲰⲔ ⲄⲀⲢ ⲠⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ⲚⲎⲨ ⲀⲚ ϢⲀⲢⲰⲦⲚ ⲈⲈⲒϢⲀⲚⲂⲰⲔ ⲆⲈ ϮⲚⲀⲦⲚⲚⲞⲞⲨϤ ϢⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ⲀⲨⲰ ⲠⲈⲦⲘⲘⲀⲨ ⲈϤϢⲀⲚⲈⲒ. ϤⲚⲀϪⲠⲒⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲈⲦⲂⲈ ⲠⲚⲞⲂⲈ ⲀⲨⲰ ⲈⲦⲂⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲀⲨⲰ ⲈⲦⲂⲈ ⲦⲈⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ⲈⲦⲂⲈ ⲠⲚⲞⲂⲈ ⲘⲈⲚ. ϪⲈ ⲚⲤⲈⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ⲈⲦⲂⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲆⲈ. ϪⲈ ⲀⲚⲞⲔ ⲈⲒⲚⲀⲂⲰⲔ ϢⲀ ⲠⲒⲰⲦ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲀⲚⲀⲨ ϬⲈ ⲀⲚ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ⲈⲦⲂⲈ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲆⲈ. ϪⲈ ⲠⲀⲢⲬⲰⲚ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲀⲨⲦϬⲀⲒⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ⲈⲦⲒ ⲞⲨⲚϮ ϨⲀϨ ⲚϢⲀϪⲈ ⲈϪⲞⲞⲨ ⲚⲎⲦⲚ ⲀⲖⲖⲀ ⲚⲦⲈⲦⲚ ⲀϢϤⲒ ⲀⲚ ⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ϨⲞⲦⲀⲚ ⲈⲢϢⲀⲚ ⲠⲎ ⲈⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲦⲘⲈ ϤⲚⲀϪⲒⲘⲞⲒⲦ ϨⲎ ⲦⲦⲎⲨⲦⲚ ϨⲚ ⲘⲈ ⲚⲒⲘ ⲚⲈϤϢⲀϪⲈ ⲄⲀⲢ ⲀⲚ ϨⲀⲢⲞϤ ⲘⲀⲨⲀⲀϤ ⲀⲖⲖⲀ ⲈϤⲚⲀϪⲈ ⲠⲈⲦϤⲚⲀⲤⲞⲦⲘⲈϤ ⲀⲨⲰ ϤⲚⲀⲦⲀⲘⲰⲦⲚ ⲈⲚⲈⲦⲚⲀϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ⲠⲈⲦⲘⲘⲀⲨ ⲠⲈⲦⲚⲀϮⲈⲞⲞⲨ ⲚⲀⲒ ϪⲈ ⲈϤⲚⲀϪⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲈ ⲠⲰⲒ ⲠⲈ ⲚϤϪⲰ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲈ ⲞⲨⲚⲦⲈⲤ ⲠⲀⲈⲒⲰⲦ ⲚⲞⲨⲒ ⲚⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒϪⲞⲞⲤ ϪⲈ ϤⲚⲀϪⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲈ ⲠⲰⲒ ⲠⲈ ⲚϤϪⲰ ⲈⲢⲰⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ⲔⲈⲔⲞⲨⲈⲒ ⲠⲈ ⲚⲦⲈⲦⲚⲖⲞ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲈⲒ ⲀⲨⲰ ⲞⲚ ⲔⲈⲔⲞⲨⲒ ⲠⲈ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ⲞⲚ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ⲠⲈϪⲈ ϨⲞⲒⲚⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲚⲈⲨⲈⲢⲎⲨ. ϪⲈ ⲞⲨ ⲠⲈ ⲠⲀⲒ ⲈⲦϤϪⲰ ⲘⲘⲞϤ ⲚⲀⲚ ϪⲈ ⲔⲈⲔⲞⲨⲒ ⲠⲈ ⲚⲦⲈⲦⲚ ⲦⲘⲚⲀⲨ ⲈⲢⲞⲈⲒ ⲀⲨⲰ ⲞⲚ ⲔⲈⲔⲞⲨⲒ ⲠⲈ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲨⲰ ⲀⲚⲞⲔ ⲈⲒⲚⲀⲂⲰⲔ ϢⲀ ⲠⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ⲀⲨⲰ ⲠⲈϪⲀⲨ. ϪⲈ ⲞⲨ ϬⲈ ⲠⲈ ⲠⲈⲒⲔⲞⲨⲈⲒ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲈϤϪⲈⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ⲀϤⲈⲒⲘⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲈⲨⲞⲨⲰϢ ⲈϪⲚ ⲞⲨϤ ⲠⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ϪⲈ ⲀⲒϪⲞⲞⲤ ϪⲈ ⲔⲈⲔⲞⲨⲒ ⲠⲈ ⲚⲦⲈⲦⲚⲖⲞ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲨⲰ ⲔⲈⲔⲞⲨⲒ ⲚⲦⲈⲦⲚ ⲚⲀⲨ ⲞⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲦⲈⲦⲚⲀⲢⲒⲘⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲦⲞⲒⲦ ⲚⲦⲰⲦⲚ . ⲠⲔⲞⲤⲘⲞⲤ ⲆⲈ ϤⲚⲀⲢⲀϢⲈ. ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲀⲖⲨⲠⲒ ⲀⲖⲖⲀ ⲦⲈⲦⲚⲖⲨⲠⲎ ⲚⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲈⲨⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ⲦⲈⲤϨⲒⲘⲈ ⲈⲤⲈⲒ ⲈⲤⲚⲀⲘⲒⲤⲈ ⲞⲨⲚⲦⲤ ⲞⲨⲖⲨⲠⲎ ⲘⲘⲀⲨ ϪⲈ ⲀⲤⲈⲒ ⲚϬⲒ ⲦⲈⲤⲞⲨⲚⲞⲨ. ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲤϢⲀⲚϪⲠⲈ ⲠϢⲎⲢⲈ. ⲘⲈⲤⲢ ⲠⲘⲈⲈⲨⲈ ϬⲈ ⲚⲦⲈⲐⲖⲒⲮⲒⲤ ⲈⲦⲂⲈ ⲠⲢⲀϢⲈ ϪⲈ ⲀⲤϪⲠⲈ ⲞⲨⲢⲰⲘⲈ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ⲚⲦⲰⲦⲚ ϬⲈ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲚⲞⲨ ⲘⲈⲚ ⲞⲨ ⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲖⲨⲠⲎ. ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲞⲚ ϮⲚⲀⲚⲀⲨ ⲈⲢⲰⲦⲚ ⲚⲦⲈ ⲠⲈⲦⲚϨⲎⲦ ⲢⲀϢⲈ ⲀⲨⲰ ⲘⲚ ⲖⲀⲀⲨ ⲚⲀϤⲒ ⲠⲈⲦⲚⲢⲀϢⲈ ⲚⲦⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲦⲚ ⲀϪⲚⲞⲨⲒ ⲀⲚ ⲈⲖⲀⲀⲨ. ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲈⲦⲈⲦⲚⲀⲀⲒⲦⲒ ⲘⲘⲞϤ ⲚⲦⲘ ⲠⲒⲰⲦ ϤⲚⲀⲦⲀⲀϤ ⲚⲎⲦⲚ ϨⲘ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ϢⲀ ⲦⲈⲚⲞⲨ ⲘⲠⲈⲦⲚⲀⲒⲦⲒ ⲖⲖⲀⲀⲨ ϨⲘ ⲠⲀⲢⲀⲚ. ⲀⲒⲦⲒ ⲀⲨⲰ ⲦⲈⲦⲚⲀϪⲒ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲈⲦⲚⲢⲀϢⲈ ϢⲰⲠⲈ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϨⲚ ϨⲈⲚⲠⲀⲢϨⲞⲒⲘⲒⲀ. ⲞⲨⲚ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲎⲨ ϨⲞⲦⲈ ⲚⲈⲒⲚⲀϢⲀϪⲈ ϬⲈ ⲀⲚ ⲚⲘⲘⲎⲦⲚ ϨⲚ ϨⲈⲚⲠⲀⲢϨⲞⲒⲘⲒⲀ. ⲀⲖⲖⲀ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲈⲒⲚⲀϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ⲈⲦⲂⲈ ⲠⲈⲒⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲦⲈⲦⲚⲀⲀⲒⲦⲒ ϨⲘ ⲠⲀⲢⲀⲚ ⲀⲨⲰ ⲚϮⲚⲀϪⲞⲞⲤ ⲀⲚ ⲚⲎⲦⲚ ϪⲈ ⲀⲚⲞⲔ ⲈⲦⲚⲀⲤⲈⲠⲤ ⲠⲒⲰⲦ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ⲚⲦⲞϤ ⲄⲀⲢ ⲠⲒⲰⲦ ϤⲘⲈ ⲘⲘⲰⲦⲚ ϪⲈ ⲚⲦⲰⲦⲚ ⲀⲦⲈⲦⲚⲘⲈⲢⲒⲦ ⲀⲨⲰ ⲀⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲀⲚⲞⲔ ⲈⲒⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ⲚⲦⲀⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲒⲰⲦ ⲀⲨⲰ ⲀⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ. ⲠⲀⲖⲒⲚ ⲞⲚ ϮⲚⲀⲔⲰ ⲚⲤⲰⲒ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲦⲀⲂⲰⲔ ϢⲀ ⲠⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ⲠⲈϪⲀⲨ ⲚⲀϤ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲈⲚⲞⲨ ⲔϢⲀϪⲈ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲀⲨⲰ ⲚⲄϪⲈ ⲖⲀⲀⲨ ⲀⲚ ⲘⲠⲀⲢϨⲞⲒⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ⲦⲈⲚⲞⲨ ⲦⲚⲒⲘⲈ ϪⲈ ⲔⲤⲞⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲘ ⲀⲨⲰ ⲚⲄⲢⲬⲢⲒⲀ ⲀⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲞⲨⲀ ϪⲚⲞⲨⲔ. ϨⲘ ⲠⲀⲒ ⲦⲚⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲦⲀⲔⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲦⲈⲚⲞⲨ ⲦⲈⲦⲘⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲤⲚⲎⲨ ⲚϬⲒ ⲞⲨⲞⲨⲚⲞⲨ ⲀⲨⲰ ⲀⲤⲈⲒ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲈⲚⲈϤⲘⲀ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲔⲀⲀⲦ ⲘⲀⲨⲀⲀⲦ. ⲀⲨⲰ ⲚϮϬⲈⲈⲦ ⲘⲀⲨⲀⲀⲦ ⲀⲚ ϪⲈ ⲠⲀⲒⲰⲦ ϢⲞⲞⲠ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ⲚⲀⲒ ⲀⲒϪⲞⲞⲨ ⲚⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲔⲰ ⲚⲎⲦⲚ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ϨⲢⲀⲒ ⲚϨⲎⲦ. ⲞⲨⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲐⲖⲒⲮⲒⲤ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ⲦⲰⲔ ⲚϨⲎⲦ ϪⲈ ⲀⲚⲞⲔ ⲀⲒϪⲢⲞ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ⲚⲀⲒ ⲀϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲀϤϤⲒ ⲚⲈϤⲂⲀⲖ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ⲀⲦⲈⲨⲚⲞⲨ ⲈⲒ. ϮⲈⲞⲞⲨ ⲘⲠⲈⲔϢⲎⲢⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲈⲔϢⲎⲢⲈ ϮⲈⲞⲞⲨ ⲚⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲔϮ ⲚⲀϤ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲤⲀⲢⲜ ⲚⲒⲘ ϪⲈⲔⲀⲀⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀϤ ⲈϤⲈϮ ⲚⲀⲨ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ⲠⲀⲒ ⲆⲈ ⲠⲈ ⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲤⲞⲨⲰⲚⲄ ⲠⲚⲞⲨⲦⲈ ⲘⲘⲈ ⲘⲘⲀⲨⲀⲀϤ ⲀⲨⲰ ⲠⲈⲚⲦⲀⲔⲦⲚⲚⲞⲞⲨϤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ⲀⲚⲞⲔ ⲀⲒϮⲈⲞⲞⲨ ⲚⲀⲔ ϨⲒϪⲘ ⲠⲔⲀϨ ϪⲈ ⲀⲒϪⲈⲔ ⲠϨⲰⲂ ⲈⲂⲞⲖ ⲈⲚⲦⲀⲔⲦⲀⲀϤ ⲚⲀⲒ ⲈⲦⲢⲀⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ⲦⲈⲚⲞⲨ ϬⲈ ⲠⲀⲒⲰⲦ ϮⲈⲞⲞⲨ ⲚⲀⲒ ϨⲀ ϨⲦⲎⲔ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲞⲞⲨ ⲈⲚⲈⲨⲚⲦⲀⲒϤ ϨⲀ ϨⲦⲎⲔ ⲈⲘⲠⲀⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ⲀⲒⲞⲨⲚϨ ⲠⲈⲔⲢⲀⲚ ⲈⲂⲞⲖ ⲚⲢⲢⲰⲘⲈ ⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ⲚⲈ ⲚⲞⲨⲔ ⲚⲈ. ⲀⲨⲰ ⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲀⲨⲰ ⲀⲨⲀⲢⲈϨ ⲈⲠⲈⲔϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ⲦⲈⲚⲞⲨ ⲀⲒⲈⲒⲘⲈ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ϨⲈⲚⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲔ ⲚⲈ ");
INSERT INTO copshc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ϪⲈ ⲚϢⲀϪⲈ ⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲀⲒⲦⲀⲀⲨ ⲚⲀⲨ ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲀⲨϪⲒⲦⲞⲨ ⲚⲀⲘⲈ ϪⲈ ⲚⲦⲀⲒⲈⲒ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲔ ⲀⲨⲰ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲦⲞⲔ ⲀⲔⲦⲚⲚⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ⲀⲚⲞⲔ ⲈⲒⲤⲞⲠⲤ ⲈⲦⲂⲎⲎⲦⲞⲨ. ⲚⲈⲒⲤⲞⲠⲤ ⲀⲚ ⲈⲦⲂⲈ ⲠⲔⲞⲤⲘⲞⲤ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲚⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ϪⲈ ⲚⲞⲨⲔ ⲚⲈ ⲀⲨⲰ ⲚⲞⲨⲒ ⲦⲎⲢⲞⲨ ⲚⲞⲨⲔ ⲚⲈ ⲀⲨⲰ ⲚⲞⲨⲔ ⲚⲞⲨⲒ ⲚⲈ ⲀⲨⲰ ⲀⲒϪⲒⲈⲞⲞⲨ ⲚϨⲎⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ⲀⲨⲰ ⲚϮϢⲞⲞⲠ ϬⲈ ⲀⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲀⲚⲞⲔ ⲆⲈ ⲈⲈⲒⲚⲎⲨ ϢⲀⲢⲞⲔ. ⲠⲀⲒⲰⲦ ⲈⲦⲞⲨⲀⲀⲂ ϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲈⲚⲦⲀⲔⲦⲀⲀϤ ⲚⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϢⲰⲠⲈ ⲚⲞⲨⲀ ⲔⲀⲦⲀⲐⲈ ⲚⲀⲚⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ⲘⲠⲈⲨⲞⲒϢ ⲈⲒ ⲚⲘⲘⲀⲨ ⲚⲈⲒϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲠⲈ ϨⲘ ⲠⲈⲔⲢⲀⲚ ⲈⲚⲦⲀⲔⲦⲀⲀϤ ⲚⲀⲒ ⲀⲨⲰ ⲀⲒϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲘⲠⲈ ⲖⲀⲀⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲦⲀⲔⲞ ⲈⲒ ⲘⲎⲦⲒ ⲠϢⲎⲢⲈ ⲘⲠⲦⲀⲔⲞ ϪⲈ ⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ⲦⲈⲚⲞⲨ ⲆⲈ ⲈⲈⲒⲚⲎⲨ ϢⲀⲢⲞⲔ. ⲀⲨⲰ ⲚⲀⲒ ⲚⲈⲒϪⲰ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲔⲰ ⲚⲀⲨ ⲘⲠⲀⲢⲀϢⲈ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ⲀⲚⲞⲔ ⲀⲒϮ ⲚⲀⲨ ⲘⲠⲈⲔϢⲀϪⲈ ⲀⲨⲰ ⲠⲔⲞⲤⲘⲞⲤ ⲀϤⲘⲈⲤⲦⲰⲞⲨ ϪⲈ ⲚϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲚⲈ ⲔⲀⲦⲀ ⲐⲈ ϨⲰ ⲈⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ⲚⲈⲒⲤⲞⲠⲤ ⲀⲚ ϪⲈ ⲈⲔⲈϤⲒⲦⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϪⲈ ⲈⲔⲈϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲠⲞⲚⲎⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ⲚϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲠⲞⲚⲎⲢⲞⲤ ⲚⲈ ⲔⲀⲦⲀ ⲐⲈ ϨⲰ ⲈⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ⲘⲀⲦⲂⲂⲞⲞⲨ ϨⲢⲀⲈⲒ ϨⲚ ⲦⲘⲈ. ⲠⲈⲔϢⲀϪⲈ ⲠⲈ ⲦⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲔⲦⲀⲞⲨⲞⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ. ⲀⲚⲞⲔ ϨⲰ ⲀⲒϪⲞⲞⲨⲤⲈ ⲈⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ⲀⲨⲰ ϮⲦⲂⲂⲞ ⲘⲘⲞⲒ ϨⲀⲢⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ϨⲰⲞⲨ ⲞⲚ ⲈⲨⲈϢⲰⲠⲈ ⲈⲨⲦⲂⲂⲎⲨ ϨⲚ ⲦⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ⲚⲈⲒⲤⲞⲠⲤ ⲆⲈ ⲀⲚ ⲈⲦⲂⲈ ⲚⲀⲒ ⲘⲀⲨⲀⲀⲨ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲚⲔⲞⲞⲨⲈ ⲞⲚ ⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲨϢⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ϪⲈⲔⲀⲀⲤ ⲦⲎⲢⲞⲨ ⲈⲨⲈϢⲰⲠⲈ ⲚⲞⲨⲀ. ⲔⲀⲦⲀⲐⲈ ⲚⲦⲞⲔ ⲠⲀⲒⲰⲦ ⲈⲔϨⲢⲀⲒ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲚⲞⲔ ⲚϨⲎⲦⲔ. ϪⲈⲔⲀⲀⲤ ϨⲰⲞⲨ ⲞⲚ ⲈⲨⲈϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲚⲦⲞⲔ ⲈⲚⲦⲀⲔⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ⲀⲨⲰ ⲀⲚⲞⲔ ⲀⲒϮ ⲚⲀⲨ ⲘⲠⲈⲞⲞⲨ ⲈⲚⲦⲀⲔⲦⲀⲀϤ ⲚⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϢⲰⲠⲈ ⲚⲞⲨⲀ ⲔⲀⲦⲀⲐⲈ ⲀⲚⲞⲚ ⲈⲀⲚⲞⲚ ⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ⲀⲚⲞⲔ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲀⲨⲰ ⲚⲦⲞⲔ ϨⲢⲀⲒ ⲚϨⲎⲦ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲈⲨϪⲎⲔ ⲈⲂⲞⲖ ⲈⲞⲨⲀ ⲀⲨⲰ ⲚⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲈⲒⲘⲈ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲚⲦⲀⲔⲦⲚⲚⲞⲞⲨⲦ ⲀⲨⲰ ⲀⲔⲘⲈⲢⲒⲦⲞⲨ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀⲔⲘⲈⲢⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ⲠⲀⲒⲰⲦ ⲚⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ. ϮⲞⲨⲰϢ ϪⲈⲔⲀⲀⲤ ⲠⲘⲀ ⲀⲚⲞⲔ ⲈϮⲘⲘⲞϤ ⲚⲦⲞⲞⲨ ϨⲰⲞⲨ ⲞⲚ ⲈⲨⲈϢⲰⲠⲈ ⲚⲘⲘⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲚⲀⲨ ⲈⲠⲀⲈⲞⲞⲨ ⲈⲚⲦⲀⲔⲦⲀⲀϤ ⲚⲀⲒ ϪⲈ ⲀⲔⲘⲈⲢⲒⲦ ϨⲀ ⲐⲎ ⲚⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ⲠⲀⲒⲰⲦ ⲠⲆⲒⲔⲀⲒⲞⲤ ⲘⲠⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲰⲚⲄ ⲀⲚⲞⲔ ⲆⲈ ⲀⲈⲒⲤⲞⲨⲰⲚⲄ ⲀⲨⲰ ⲚⲀⲒ ⲀⲨⲤⲞⲨⲰⲚⲦ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲚⲦⲀⲔⲦⲚⲚⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ⲀⲨⲰ ⲀⲒⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲘⲠⲈⲔⲢⲀⲚ ⲀⲨⲰ ⲞⲚ ϮⲚⲀⲞⲨⲞⲚϨϤ ϪⲈⲔⲀⲀⲤ ⲦⲀⲄⲀⲠⲎ ⲈⲚⲦⲀⲔⲘⲈⲢⲒⲦ ⲚϨⲎⲦⲤ ⲈⲤⲈϢⲰⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲀⲨⲰ ⲀⲚⲞⲔ ϨⲰⲰⲦ ⲞⲚ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ⲚⲀⲒ ⲚⲦⲈⲢⲈϤϪⲞⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲠⲒⲔⲢⲞ ⲘⲠⲬⲒⲘⲀⲢⲞⲤ ⲘⲠⲔⲈⲆⲢⲞⲤ ⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲞⲨϢⲎⲚ ⲚϨⲎⲦϤ ⲠⲘⲀ ⲈⲚⲦⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲚⲦⲞϤ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ⲚⲈϤⲤⲞⲞⲨⲚ ⲆⲈ ϨⲰⲰϤ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ϪⲈ ϨⲀϨ ⲚⲤⲞⲠ ⲀⲒⲎⲤⲞⲨⲤ ⲤⲰⲞⲨϨ ⲘⲘⲀⲨ ⲘⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ⲒⲞⲨⲆⲀⲤ ϬⲈ ⲈⲀϤϪⲒ ⲚⲦⲈⲤⲠⲈⲒⲢⲀ ⲀⲨⲰ ϨⲈⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀϤⲈⲒ ⲈⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲚⲘ ϨⲈⲚⲪⲀⲚⲞⲤ ⲀⲨⲰ ϨⲈⲚⲖⲀⲘⲠⲀⲤ ⲚⲘ ϨⲈⲚϨⲞⲠⲖⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈϤⲤⲞⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲘ ⲈⲦⲚⲎⲨ ⲈϪⲰϤ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲈⲦⲈⲦⲚϢⲒ ⲚⲈ ⲚⲤⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ϪⲈ ⲈⲚϢⲒⲚⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲈϪⲈⲒⲤ ⲚⲀⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲚⲈϤⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦϤ ⲚⲘⲘⲀⲨ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲚⲦⲀϤⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ⲚⲦⲈⲢⲈϤϪⲞⲞⲤ ϬⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ⲀⲨⲈⲒ ⲚⲤⲀ ⲠⲀϨⲞⲨ ⲀⲨϨⲈ ⲈϪⲘⲠ ⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲚⲞⲨⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲀ ⲚⲒⲘ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ. ϪⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲀⲒϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ⲈϢϪⲈ ⲀⲚⲞⲔ ϬⲈ ⲠⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲈⲒ ⲔⲀ ⲚⲀⲒ ⲦⲀⲢⲞⲨⲂⲰⲔ ");
INSERT INTO copshc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠϢⲀϪⲈ ⲈⲚⲦⲀϤϪⲞⲞϤ ϪⲈ ⲚⲈⲚⲦⲀⲔⲦⲀⲀⲨ ⲚⲀⲒ ⲘⲠⲒⲦⲀⲔⲈ ⲖⲀⲀⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ⲤⲒⲘⲰⲚ ⲆⲈ ⲠⲈⲦⲢⲞⲤ ⲈⲢⲈ ⲞⲨⲤⲎϤⲈ ⲚⲦⲞⲞⲦϤ ⲀϤⲦⲞⲔⲘⲈⲤ ⲀⲨⲰ ⲀϤⲢⲈϨⲦ ⲠϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤⲤⲖⲠ ⲠⲈϤⲘⲀⲀϪⲈ ⲚⲞⲨⲚⲀⲘ. ⲚⲈ ⲠⲢⲀⲚ ⲆⲈ ⲘⲠϨⲘϨⲀⲖ ⲠⲈ ⲘⲀⲖⲬⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲚⲞⲨϪⲈ ⲚⲦⲈⲔⲤⲎϤⲈ ⲈⲠⲈⲤⲔⲞⲈⲒϨ. ⲠϪⲰ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ⲦⲀⲀϤ ⲚⲀⲒ ⲘⲎ ⲚϮⲚⲀⲤⲞⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ⲦⲈⲤⲠⲈⲒⲢⲀ ⲆⲈ ⲀⲨⲰ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲘ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨϬⲰⲠⲈ ⲚⲒⲎⲤⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ⲀⲨⲘⲞⲢϤ ⲀⲨⲰ ⲀⲨⲚⲦϤ ϢⲀ ⲀⲚⲚⲀⲤ ⲚϢⲞⲢⲠ. ⲚⲈ ⲠϢⲞⲘⲚⲦ ⲆⲈ ⲠⲈ ⲚⲔⲀⲒⲪⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲦⲈⲢⲞⲘⲠⲈ ⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ⲔⲀⲒⲪⲀⲤ ⲆⲈ ⲠⲈ ⲠⲀⲒ ⲈⲚⲦⲀϤϪⲒ ϢⲞϪⲚⲈ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲤⲢⲚⲞϤⲢⲈ ⲈⲦⲢⲈ ⲞⲨⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲘⲞⲨ ϨⲀ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ⲚⲈϤⲞⲨⲎϨ ⲆⲈ ⲚⲤⲀ ⲒⲎⲤⲞⲨⲤ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲘ ⲔⲈⲘⲀⲐⲎⲦⲎⲤ. ⲠⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲢⲈ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲀⲨⲖⲎ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲘⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ⲠⲈ ⲂⲂⲞⲖ ϨⲒⲢⲘ ⲠⲢⲞ ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲈⲢⲈ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲨⲰ ⲀϤϪⲞⲞⲤ ⲚⲦⲈⲘⲚⲞⲞⲦⲈ ⲀϤϪⲒ ⲠⲈⲦⲢⲞⲤ ⲈϨⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ⲦϨⲘϨⲀⲖ ⲆⲈ ⲚⲘⲚⲞⲞⲦⲈ ⲠⲈϪⲀⲤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲘⲎ ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲞⲚ ⲚⲦⲔ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲘⲠⲈⲒⲢⲰⲘⲈ ⲠⲈϪⲀϤ ⲚϬⲒ ⲠⲎ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ⲚⲈⲨⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ⲚϬⲒ ⲚϨⲘϨⲀⲖ ⲚⲘ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲀⲨϪⲈⲢⲈ ⲞⲨϢⲀϨ ⲈⲨⲐⲘⲞ ⲘⲘⲞⲞⲨ ϪⲈ ⲚⲈⲢⲈ ⲠϪⲀϤ ⲂⲂⲞⲖ. ⲠⲈⲦⲢⲞⲤ ϨⲰⲰϤ ⲞⲚ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ⲈϤⲐⲘⲞ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀϤϪⲚⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲂⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲈⲦⲂⲈ ⲦⲈϤⲤⲂⲰ ");
INSERT INTO copshc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲦⲀⲒϢⲀϪⲈ ⲚⲘ ⲠⲔⲞⲤⲘⲞⲤ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲀⲚⲞⲔ ⲚⲞⲨⲞⲒϢ ⲚⲒⲘ ⲀⲒϮⲤⲂⲰ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲰ ϨⲘ ⲠⲈⲢⲠⲈ ⲠⲘⲀ ⲈϢⲀⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲰⲞⲨϨ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲘⲠⲒϪⲈ ⲖⲀⲀⲨ ⲚϢⲀϪⲈ ϨⲘ ⲠϨⲰⲠ. ");
INSERT INTO copshc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ⲀϨⲢⲞⲔ ⲔϪⲚⲞⲨ ⲘⲘⲞⲒ ⲘⲀϪⲚⲈ ⲚⲈⲚⲦⲀⲨⲤⲰⲦⲘ ϪⲈ ⲞⲨ ⲚⲈ ⲚⲦⲀⲒϪⲞⲞⲨ ⲚⲀⲨ. ⲚⲀⲒ ⲚⲈⲦⲤⲞⲞⲨⲚ ⲚⲚⲈⲚⲦⲀⲒϪⲞⲞⲨ ⲀⲚⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ⲚⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲞⲞⲨ ⲞⲨⲀ ⲚⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲀϤⲢⲈϨⲦ ⲒⲎⲤⲞⲨⲤ ⲚⲞⲨⲀⲀⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲞⲨⲰϢⲂ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈϢϪⲈ ⲔⲀⲔⲰⲤ ⲀⲒϢⲀϪⲈ ⲀⲢⲒ ⲘⲚⲦⲢⲈ ϨⲀ ⲠⲀⲠⲈⲐⲞⲞⲨ ⲈϢϪⲈ ⲔⲀⲖⲰⲤ ⲆⲈ ⲀϨⲢⲞⲔ ⲔϨⲒⲞⲨⲈ ⲈⲢⲞⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ⲀϤϪⲞⲞⲨϤ ⲆⲈ ⲚϬⲒ ⲀⲚⲚⲀⲤ ⲈϤⲘⲎⲢ ϢⲀ ⲔⲀⲒⲪⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ⲤⲒⲘⲰⲚ ⲆⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲈϤⲀϨⲈⲢⲀⲦϤ ⲈϤⲐⲘⲞ ⲘⲘⲞϤ. ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲀϤ ϪⲈ ⲘⲎ ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲞⲚ ⲚⲦⲔⲞⲨⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ⲀⲠⲎ ⲀⲢⲚⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ⲠⲈϪⲈⲞ ⲨⲀ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲚϨⲘϨⲀⲖ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲨⲤⲨⲄⲄⲈⲚⲎⲤ ⲠⲈ ⲘⲠⲈⲚⲦⲀ ⲠⲈⲦⲢⲞⲤ ⲤⲖⲠ ⲠⲈϤⲘⲀⲀϪⲈ. ϪⲈ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲚⲦⲀⲒⲚⲀⲨ ⲈⲢⲞⲔ ϨⲚ ⲦⲈϢⲚⲎ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲀⲢⲚⲀ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲀⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨⲦⲈ ⲚⲦⲈⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀⲨϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲔⲀⲒⲪⲀⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ. ⲚⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ⲠⲈ. ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲘⲠⲞⲨⲂⲰⲔ ⲚⲘⲘⲀϤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨⲤⲰⲰϤ ⲀⲖⲖⲀ ⲈⲨⲈⲞⲨⲰⲘ ⲘⲠⲠⲀⲤⲬⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϢⲀⲢⲞⲞⲨ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ⲀⲨⲰ ⲠⲈϪⲀϤ. ϪⲈ ⲞⲨ ⲚⲔⲀⲦⲎⲄⲞⲢⲒⲀ ⲠⲈⲦⲈⲦⲚⲒⲚⲈ ⲘⲘⲞϤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ⲀⲨⲞⲨⲰϢⲂ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲈⲚⲈ ⲘⲠⲀⲒ ⲢⲠⲈⲐⲞⲞⲨ ⲀⲚ. ⲚⲈⲚⲚⲀⲦⲀⲀϤ ⲀⲚ ⲈⲦⲞⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ϪⲒⲦϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲠⲈⲦⲚⲚⲞⲘⲞⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲞⲨⲔ ⲈⲜⲈⲤⲦⲒ ⲚⲀⲚ ⲈⲘⲈⲨⲦ ⲖⲀⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲠϢⲀϪⲈ ⲈⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲞϤ ⲈϤⲤⲎⲘⲀⲚⲈ ϪⲈ ϨⲚ ⲀϢ ⲘⲘⲞⲨ ⲈϤⲚⲀⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ⲀϤⲂⲰⲔ ⲆⲈ ⲞⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲈⲔϪⲰ ⲘⲠⲀⲒ ϨⲀⲢⲞⲔ ⲘⲀⲨⲀⲀⲔ. ϪⲈⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲈ ⲚⲦⲀⲨϪⲞⲞⲤ ⲚⲀⲔ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲘⲎⲦⲒ ⲀⲚⲞⲔ ⲀⲚⲄⲞⲨⲒⲞⲨⲆⲀⲒ. ⲠⲈⲔϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲦⲞⲞⲨ ⲚⲈ ⲚⲦⲀⲨⲦⲀⲀⲔ ⲈⲦⲞⲞⲦ. ⲞⲨ ⲠⲈ ⲚⲦⲀⲔⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲦⲀⲘⲚⲦⲢⲢⲞ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ⲦⲈ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ⲈⲚⲈ ⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲦⲈ ⲦⲀⲘⲚⲦⲢⲢⲞ ⲚⲈⲨⲚⲀⲘⲒϢⲈ ⲠⲈ ⲚϬⲒ ⲚⲀϨⲨⲠⲎⲢⲈⲦⲎⲤ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨⲦⲀⲀⲦ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲈⲚⲞⲨ ⲆⲈ ⲦⲀⲘⲚⲦⲢⲢⲞ ⲚⲞⲨⲈⲂⲞⲖ ⲀⲚ ⲦⲈ ϨⲘ ⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ϬⲈ ⲚⲀϤ ϪⲈ ⲞⲨⲔⲞⲨⲚ ϬⲈ ⲚⲦⲔⲞⲨⲢⲢⲞ ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈⲦⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄ ⲞⲨⲢⲢⲞ. ⲀⲚⲞⲔ ⲚⲦⲀⲨϪⲠⲞⲈⲒ ⲈⲠⲈⲒϨⲰⲂ ⲀⲨⲰ ⲚⲦⲀⲈⲒ ⲈⲠⲔⲞⲤⲘⲞⲤ ⲈⲠⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈⲢⲘⲚⲦⲢⲈ ⲚⲦⲘⲈ. ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲈ ϢⲀϤⲤⲰⲦⲘ ⲈⲦⲀⲤⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲦⲈ ⲦⲘⲈ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲀϤⲈⲒ ⲞⲚ ⲈⲂⲞⲖ ϢⲀ ⲚⲒⲞⲨⲆⲀⲒ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲀⲚⲞⲔ ⲚϮϬⲚ ⲖⲀⲀⲨ ⲀⲚ ⲚⲀⲒⲦⲒⲀ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ⲞⲨⲚⲦⲎⲦⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲤⲰⲚⲦ ϪⲈⲔⲀⲀⲤ ⲈⲈⲒⲈⲔⲀ ⲞⲨⲀ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲠⲀⲤⲬⲀ. ⲦⲈⲦⲚⲞⲨⲰϢ ϬⲈ ⲦⲀⲔⲰ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲘⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲦⲎⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢⲔⲀ ⲠⲀⲒ ⲈⲂⲞⲖ. ⲀⲖⲖⲀ ⲔⲀ ⲂⲀⲢⲀⲂⲂⲀⲤ. ⲂⲀⲢⲀⲂⲂⲀⲤ ⲆⲈ ⲚⲈⲨⲤⲞⲞⲚⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ⲦⲞⲦⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲀϤⲘⲀⲤⲦⲒⲄⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ⲀⲨⲰ ⲘⲘⲀⲦⲞⲒ ⲀⲨϢⲈⲚⲦ ⲞⲨⲔⲖⲞⲘ ⲈⲂⲞⲖ ϨⲚ ⲚϢⲞⲚⲦⲈ ⲀⲨⲔⲀⲀϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ ⲀⲨϮ ϨⲒⲰⲰϤ ⲚⲞⲨϢⲦⲎⲚ ⲚϪⲎϬⲈ ");
INSERT INTO copshc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ⲀⲨⲰ ⲚⲈⲨⲚⲎⲨ ϢⲀⲢⲞϤ ⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀⲒⲢⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲨⲰ ⲚⲈⲨϮⲀⲀⲤ ⲚⲀϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ⲠⲒⲖⲀⲦⲞⲤ ⲞⲚ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϢⲀⲢⲞⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲚⲦϤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ϪⲈ ⲚϮϬⲚ ⲖⲀⲀⲨ ⲀⲚ ⲚⲀⲒⲦⲒⲀ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲢⲈ ⲠⲈⲔⲖⲞⲘ ⲚϢⲞⲚⲦⲈ ϨⲒϪⲚ ⲦⲈϤⲀⲠⲈ ⲀⲨⲰ ⲈⲢⲈ ⲦⲈϢⲦⲎⲚ ⲚϪⲎϬⲈ ϨⲒⲰⲰϤ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲒⲤ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀⲨ. ϪⲈ ϪⲒⲦϤ ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲀⲚⲞⲔ ⲄⲀⲢ ⲚϮϨⲎⲨ ⲀⲚ ⲈⲖⲀⲀⲨ ⲚⲖⲞⲒϬⲈ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲚⲦⲀⲚ ⲞⲨⲚⲞⲘⲞⲤ ⲘⲘⲀⲨ ⲀⲨⲰ ⲔⲀⲦⲀ ⲠⲈⲚⲚⲞⲘⲞⲤ ϢϢⲈ ⲈⲢⲞϤ ⲈⲘⲞⲨ ϪⲈ ⲀϤⲀⲀϤ ⲚϢⲎⲢⲈ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲈⲠⲈⲈⲒϢⲀϪⲈ. ⲀϤⲢϨⲞⲦⲈ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲞⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲚⲦⲔⲞⲨⲈⲂⲞⲖ ⲦⲰⲚ ⲚⲦⲞⲔ. ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲠϤⲞⲨⲰϢⲂ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ϬⲈ ⲚⲀϤ. ϪⲈ ⲚⲄⲚⲀϢⲀϪⲈ ⲚⲘⲘⲀⲒ ⲀⲚ. ⲚⲄⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲚϮ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞⲔ ⲀⲨⲰ ⲞⲨⲚϮ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲔⲀⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ⲀϤⲞⲨⲰϢⲂ ⲚⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲈ ⲘⲚⲦⲔ ⲖⲀⲀⲨ ⲚⲈⲜⲞⲨⲤⲒⲀ ⲈϨⲞⲨⲚ ⲈⲢⲞⲈⲒ ⲈⲒⲘⲎⲦⲒ ϪⲈ ⲀⲨⲦⲀⲀⲤ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲈⲚⲦⲀϤⲦⲀⲀⲦ ⲈⲦⲞⲞⲦⲔ ⲞⲨⲚⲦϤ ⲞⲨⲚⲞϬ ⲚⲚⲞⲂⲈ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲈⲢⲈ ⲠⲒⲖⲀⲦⲞⲤ ϢⲒⲚⲈ ⲚⲤⲀ ⲔⲀⲀϤ ⲈⲂⲞⲖ ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲔϢⲀⲚⲔⲀ ⲠⲀⲒ ⲈⲂⲞⲖ ⲚⲦⲔ ⲠⲈϢⲂⲎⲢ ⲀⲚ ⲘⲠⲢⲢⲞ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈϮⲢⲈ ⲘⲘⲞϤ ⲚⲢⲢⲞ ⲈϤϮ ⲞⲨⲂⲈ ⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲈⲚⲈⲈⲒϢⲀϪⲈ ⲀϤⲈⲒⲚⲈ ⲈⲂⲞⲖ ⲚⲒⲎⲤⲞⲨⲤ ⲀϤⲐⲘⲤⲞϤ ⲈⲠⲂⲎⲘⲀ ⲞⲨⲘⲀ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲖⲒⲐⲞⲤⲦⲢⲰⲦⲞⲚ. ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ⲆⲈ ϪⲈ ⲄⲀⲂⲂⲀⲐⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ⲚⲈ ⲠⲚⲀⲨ ⲆⲈ ⲚϪⲠ ⲤⲞⲞ ⲠⲈ ⲚⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲘⲠⲠⲀⲤⲬⲀ. ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲈⲒⲤ ⲠⲈⲦⲚⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ϤⲒⲦϤ ϤⲒⲦϤ ⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀⲨ ϪⲈ ⲦⲀⲤⲦⲀⲨⲢⲞⲨ ⲘⲠⲈⲦⲚⲢⲢⲞ ⲀⲨⲞⲨⲰϢⲂ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈ ⲘⲚⲦⲚ ⲔⲈⲢⲢⲞ ⲘⲘⲀⲨ ⲈⲒⲘⲎⲦⲒ ⲠⲢⲢⲞ ⲔⲀⲒⲤⲀⲢ. ");
INSERT INTO copshc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ⲦⲞⲦⲈ ϬⲈ ⲀϤⲦⲀⲀϤ ⲈⲦⲞⲞⲦⲞⲨ ⲈⲦⲢⲈⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲚⲦϤ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ⲀⲨⲰ ⲚⲈϤϤⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ. ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲨⲘⲀ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲔⲢⲀⲚⲒⲞⲚ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ⲆⲈ ϪⲈ ⲄⲞⲖⲄⲞⲐ ");
INSERT INTO copshc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ⲠⲘⲀ ⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚϨⲎ ⲦϤ ⲀⲨⲰ ⲔⲈⲤⲚⲀⲨ ⲚⲘⲘⲀϤ ⲞⲨⲀ ⲚⲤⲀ ⲠⲒⲤⲀ ⲀⲨⲰ ⲞⲨⲀ ⲚⲤⲀ ⲠⲀⲒ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ⲀⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲤϨⲀⲒ ⲚⲞⲨⲦⲒⲦⲖⲞⲤ ⲀⲨⲰ ⲀϤⲦⲞϬϤ ⲈⲠⲈⲤⲦⲀⲨⲢⲞⲤ. ⲚⲈϤⲤⲎϨ ⲆⲈ ⲈⲢⲞϤ ⲠⲈ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ⲠⲈⲒⲦⲒⲦⲖⲞⲤ ⲆⲈ ⲀϨⲀϨ ⲚⲒⲞⲨⲆⲀⲒ ⲞϢϤ ϪⲈ ⲚⲈϤϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲚϬⲒ ⲠⲘⲀ ⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲚⲈϤⲤⲎϨ ⲘⲈⲚ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ⲘⲘⲚⲦϨⲢⲰⲘⲀⲒⲞⲤ ⲘⲘⲚⲦⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ⲚⲈⲨϪⲰ ϬⲈ ⲘⲘⲞⲤ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲘⲠⲢⲤⲀϨϤ ϪⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲖⲖⲀ ϪⲈ ⲠⲎⲎ ⲠⲈ ⲚⲦⲀϤϪⲞⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲢⲢⲞ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲠⲈⲚⲦⲀⲒ ⲤⲀϨϤ ⲀⲒⲤⲀϨϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ⲘⲘⲀⲦⲞⲒ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲀⲨϪⲒ ⲠⲈϤϨⲞⲒⲦⲈ ⲀⲨⲰ ⲀⲨⲀⲀϤ ⲚϤⲦⲞⲞⲨ ⲚⲞⲨⲰⲚ ⲞⲨⲰⲚ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲘⲘⲀⲦⲞⲒ ⲀⲨⲰ ⲦⲔⲈϢⲦⲎⲚ ⲦⲈϢⲦⲎⲚ ⲆⲈ ⲚⲈⲤⲦⲞⲢⲠ ⲀⲚ ⲈϪⲰⲤ ⲠⲈ ⲀⲖⲖⲀ ⲚⲈⲨⲤⲀϨ ϤⲦⲞⲞⲨ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ⲠⲈϪⲀⲨ ⲆⲈ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲘⲠⲢⲦⲢⲈⲚⲠⲀϨⲤ ⲀⲖⲖⲀ ⲘⲀⲢⲚⲈⲚⲒⲘ ⲈⲢⲞⲤ ϪⲈ ⲈⲤⲚⲀⲢ ⲦⲀ ⲚⲒⲘ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲀⲨⲠⲈϢ ⲚⲀϨⲞⲒⲦⲈ ⲈϪⲰⲞⲨ ⲀⲨⲚⲈϪ ⲔⲖⲎⲢⲞⲤ ⲈϪⲚ ⲦⲀϨⲂⲤⲰ ⲘⲘⲀⲦⲞⲒ ⲘⲈⲚ ⲀⲨⲢⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ⲚⲈⲨⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ϨⲀⲦⲘ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ⲚϬⲒ ⲦⲈϤⲘⲀⲀⲨ ⲀⲨⲰ ⲦⲤⲰⲚⲈ ⲚⲦⲈϤⲘⲀⲀⲨ ⲘⲀⲢⲒⲀ ⲦϢⲈⲈⲢⲈ ⲚⲔⲖⲰⲠⲀ ⲀⲨⲰ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲦⲈϤⲘⲀⲀⲨ ⲀⲨⲰ ⲠⲘⲀⲐⲎⲦⲎⲤ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲠⲈⲦⲈ ⲚⲈϤⲘⲈ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲚⲦⲈϤⲘⲀⲀⲨ ϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲈⲒⲤ ⲠⲞⲨϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ⲈⲒⲦⲀ ⲠⲈϪⲀϤ ⲘⲠⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲒⲤ ⲦⲈⲔⲘⲀⲀⲨ. ϪⲒⲚ ⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲠⲘⲀⲐⲎⲦⲎⲤ ϪⲒⲦⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈϤⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲈϤⲤⲞⲞⲨⲚ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀϨⲰⲂ ⲚⲒⲘ ϪⲰⲔ. ϪⲈ ⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ϪⲈ ϮⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ⲚⲈⲨⲚ ⲞⲨϨⲚⲀⲀⲨ ⲆⲈ ⲔⲎ ⲈϨⲢⲀⲒ ⲈϤⲘⲈϨ ⲚϨⲘϪ. ⲞⲨⲤⲠⲞⲄⲄⲞⲤ ⲆⲈ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ⲚϨⲘϪ ⲀⲨⲔⲀⲀϤ ⲈϪⲚ ⲞⲨϨⲨⲤⲤⲰⲠⲞⲤ ⲀⲨⲰ ⲀⲨⲤⲞⲞⲨⲦⲚ ⲘⲘⲞϤ ⲈⲦⲈϤⲦⲀⲠⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ⲚⲦⲈⲢⲈϤϪⲒ ⲆⲈ ⲘⲠϨⲘϪ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ. ϪⲈ ⲀⲨϪⲰⲔ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲀϤⲢⲒⲔⲈ ⲚⲦⲈϤⲀⲠⲈ ⲀϤϮ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϪⲈ ⲚⲈ ⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ϪⲈ ⲚⲚⲈ ⲚⲤⲰⲘⲀ ϬⲰ ϨⲒ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ⲚⲈ ⲞⲨⲚⲞϬ ⲄⲀⲢ ⲠⲈ ⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲤⲈⲠⲤ ⲠⲒⲖⲀⲦⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲞⲨⲰϬⲠ ⲚⲚⲈⲨⲞⲨⲈⲢⲎⲦⲈ ⲚⲤⲈϤⲒⲦⲞⲨ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ⲀⲨⲈⲒ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲦⲞⲒ ⲀⲨⲞⲨⲈϬⲠ ⲚⲞⲨⲈⲢⲎⲦⲈ ⲘⲠϢⲞⲢⲠ ⲚⲘ ⲠⲔⲈⲞⲨⲀ ⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈϪⲚ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈⲀϤⲞⲨⲰ ⲈϤⲘⲞⲨ. ⲘⲠⲞⲨⲞⲨⲈϬⲠ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ⲀⲖⲖⲀ ⲀⲞⲨⲀ ⲚⲘⲘⲀⲦⲞⲒ ⲀϤⲔⲰⲚⲤ ⲘⲠⲈϤⲤⲠⲒⲢ ⲚⲞⲨⲖⲞⲄⲬⲎ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϬⲒ ⲞⲨⲤⲚⲞϤ ⲚⲘ ⲞⲨⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ⲀⲨⲰ ⲠⲈⲚⲦⲀϤⲚⲀⲨ ⲀϤⲢⲘⲚⲦⲢⲈ ⲀⲨⲰ ⲞⲨⲘⲈ ⲦⲈ ⲦⲈϤⲘⲚⲦⲘⲚⲦⲢⲈ ⲀⲨⲰ ⲠⲈⲦⲘⲘⲀⲨ ⲤⲞⲞⲨⲚ ϪⲈ ⲈϤϪⲈⲘⲈ ϪⲈⲔⲀⲀⲤ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ⲚⲦⲀ ⲚⲀⲒ ⲄⲀⲢ ϢⲰⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲚⲚⲈⲨⲔⲀⲤ ⲚⲞⲨⲰⲦ ⲞⲨⲰϢϤ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ⲀⲨⲰ ⲞⲚ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲈⲠⲈⲚⲦⲀⲨⲔⲞⲚⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀϤⲤⲈⲠⲤ ⲠⲒⲖⲀⲦⲞⲤ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲠⲈⲂⲞⲖ ϨⲚ ⲀⲢⲒⲘⲀⲐⲀⲒⲀ ⲈⲨⲘⲀⲐⲎⲦⲎⲤ ⲠⲈ ⲚⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲈϤϨⲎⲠ ⲆⲈ ⲈⲦⲂⲈ ⲐⲞⲦⲈ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϤⲒ ⲠⲤⲰⲘⲀ ⲚⲒⲤ. ⲀⲨⲰ ⲀϤⲔⲀⲀϤ ⲚϬⲒ ⲠⲒⲖⲀⲦⲞⲤ. ⲀⲨⲈⲒ ⲆⲈ ⲀⲨϤⲒ ⲠⲈϤⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ⲀϤⲈⲒ ⲆⲈ ϨⲰⲰϤ ⲞⲚ ⲚϬⲒ ⲚⲒⲔⲞⲆⲎ ⲘⲞⲤ ⲠⲈⲚⲦⲀϤⲈⲒ ϢⲀ ⲒⲎⲤⲞⲨⲤ ⲚϢⲞⲢⲠ ⲚⲦⲈⲨϢⲎ ⲀϤⲈⲒⲚⲈ ⲚⲞⲨⲘⲒⲄⲘⲀ ⲚϢⲀⲖ ϨⲒ ⲀⲖⲖⲰⲒ ⲈⲨⲚⲀⲢ ϢⲈ ⲚⲖⲒⲦⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ⲀⲨϪⲒ ⲆⲈ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲘⲞⲢϤ ⲚϨⲈⲚϨⲂⲰⲰⲤ ⲚⲘ ⲚϨⲎⲚⲈ ⲔⲀⲦⲀ ⲠⲤⲰⲚⲦ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲔⲞⲞⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ⲚⲈⲨⲚ ⲞⲨϢⲚⲎ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲚϨⲎⲦϤ ⲈⲢⲈ ⲞⲨⲦⲀⲪⲞⲤ ⲚⲂⲢⲢⲈ ϨⲚ ⲦⲈϢⲚⲎ ⲈⲘⲠⲀⲦⲞⲨⲔⲀ ⲖⲀⲀⲨ ⲚϨⲞⲨⲚ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ⲈⲦⲂⲈ ⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲆⲈ ⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲚⲈⲢⲈⲠⲦⲀⲪⲞⲤ ϨⲎⲚ ⲈϨⲞⲨⲚ ⲀⲨⲔⲀ ⲒⲎⲤⲞⲨⲤ ⲚϨⲞⲨⲚ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ⲚⲦⲔⲨⲢⲒⲀⲔⲎ ⲆⲈ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲀⲤⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲦⲀⲪⲞⲤ ⲈϨⲦⲞⲞⲨⲈ ⲈⲦⲒ ⲈⲢⲈ ⲠⲔⲀⲔⲈ ⲂⲂⲞⲖ ⲀⲨⲰ ⲀⲤⲚⲀⲨ ⲈⲠⲰⲚⲈ ⲈⲀⲨϤⲒⲦϤ ⲈⲂⲞⲖ ϨⲒⲢⲘⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ⲀⲤⲠⲰⲦ ⲆⲈ ⲀⲤⲈⲒ ϢⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲘ ⲠⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲠⲈϪⲀⲤ ⲚⲀⲨ. ϪⲈ ⲀⲨϤⲒ ⲠϪⲞⲈⲒⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲦⲀⲪⲞⲤ ⲀⲨⲰ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲀⲨⲔⲀⲀϤ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲚⲘ ⲠⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲚⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ⲈⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ⲚⲈⲨⲠⲎⲦ ⲆⲈ ⲠⲈ ϨⲒⲞⲨⲤⲞⲠ. ⲠⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲀϤϬⲈⲠⲎ ⲈⲠⲰⲦ ⲈϨⲞⲨⲈ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲀϤⲈⲒ ⲚϢⲞⲢⲠ ⲈⲂⲞⲖ ⲈⲠⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ⲀϤϬⲰϢⲦ ⲆⲈ ⲈϨⲞⲨⲚ ⲀϤⲚⲀⲨ ⲈⲚⲈϨⲂⲰⲰⲤ ⲈⲨⲔⲎ ⲈϨⲢⲀⲒ ⲘⲠϤⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ⲀϤⲈⲒ ⲆⲈ ϨⲰⲰϤ ⲞⲚ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϤⲞⲨⲎϨ ⲚⲤⲰϤ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲦⲀⲪⲞⲤ ⲀϤⲚⲀⲨ ⲈⲚⲈϨⲂⲰⲰⲤ ⲈⲨⲔⲎ ⲈϨⲢⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ⲀⲨⲰ ⲠⲤⲞⲨⲆⲀⲢⲒⲞⲚ ⲈⲚⲈϤⲘⲎⲢ ⲈⲦⲈϤⲀⲠⲈ ⲈϤⲔⲎ ⲀⲚ ⲈϨⲢⲀⲒ ⲘⲚ ⲚⲈϨⲂⲰⲰⲤ ⲀⲖⲖⲀ ⲈϤϬⲖⲘⲖⲰⲘ ⲚⲤⲀ ⲞⲨⲤⲀ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ⲦⲞⲦⲈ ⲠⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲀϤⲈⲒ ⲚϢⲞⲢⲠ ⲀϤⲂⲰⲔ ϨⲰⲰϤ ⲞⲚ ⲈϨⲞⲨⲚ ⲈⲠⲦⲀⲪⲞⲤ ⲀϤⲚⲀⲨ ⲀⲨⲰ ⲀϤⲠⲒⲤⲦⲈⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ⲚⲈ ⲘⲠⲀⲦⲞⲨⲤⲞⲨⲚ ⲦⲈⲄⲢⲀⲪⲎ ⲄⲀⲢ ⲠⲈ ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ⲀⲨⲂⲰⲔ ⲞⲚ ⲈⲠⲈⲨⲎⲈⲒ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲈⲤⲀϨⲈⲢⲀⲦⲤ ⲠⲈ ⲘⲠⲂⲞⲖ ⲘⲠⲦⲀⲪⲞⲤ ⲈⲤⲢⲒⲘⲈ. ⲈⲤⲢⲒⲘⲈ ⲆⲈ. ⲀⲤϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈⲠⲦⲀⲪⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ⲀⲤⲚⲀⲨ ⲈⲀⲄⲄⲈⲖⲞⲤ ⲤⲚⲀⲨ ϨⲚ ϨⲈⲚϨⲂⲰⲰⲤ ⲈⲨⲞⲂϢ ⲈⲨϨⲘⲞⲞⲤ. ⲞⲨⲀ ϨⲀϪⲰϤ ⲀⲨⲰ ⲞⲨⲀ ϨⲀⲢⲀⲦϤ ⲘⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ⲠⲈϪⲈ ⲚⲎ ⲚⲀⲤ ϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲀϨⲢⲞ ⲦⲈⲢⲒⲘⲈ ⲠⲈϪⲀⲤ ⲚⲀⲨ ϪⲈ ⲈⲂⲞⲖ ϪⲈ ⲀⲨϤⲒ ⲠⲀϪⲞⲈⲒⲤ ⲀⲨⲰ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲀⲨⲔⲀⲀϤ ⲦⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ⲚⲦⲈⲢⲈⲤϪⲈ ⲚⲀⲒ. ⲀⲤⲔⲞⲦⲤ ⲈⲠⲀϨⲞⲨ ⲀⲤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲚⲈⲤⲤⲞⲞⲨⲚ ⲆⲈ ⲀⲚ ⲠⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ⲠⲈϪⲀϤ ⲚⲀⲤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲈⲤϨⲒⲘⲈ ⲀϨⲢⲞ ⲦⲈⲢⲒⲘⲈ ⲈⲢⲈϢⲒⲚⲈ ⲚⲤⲀ ⲚⲒⲘ ⲦⲎ ⲆⲈ ⲚⲈⲤⲘⲈⲨⲈ ϪⲈ ⲠⲀ ⲦⲈϢⲚⲎ ⲠⲈ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈϢϪⲈ ⲚⲦⲞⲔ ⲀⲔϤⲒⲦϤ ⲀϪⲒⲤ ⲈⲢⲞⲈⲒ ϪⲈ ⲚⲦⲀⲔⲔⲀⲀϤ ⲦⲰⲚ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀϤⲒⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲀⲢⲒϨⲀⲘ ⲦⲎ ⲆⲈ ⲀⲤⲔⲞⲦⲤ ⲠⲈϪⲀⲤ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ϪⲈ ϨⲢⲀⲂⲂⲞⲨⲚⲈⲒ ⲠⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲤⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲠⲢϪⲰϨ ⲈⲢⲞⲈⲒ ⲘⲠⲀϮⲂⲰⲔ ⲄⲀⲢ ⲈϨⲢⲀⲒ ϢⲀ ⲠⲀⲒⲰⲦ ⲂⲰⲔ ⲆⲈ ϢⲀ ⲚⲀⲤⲚⲎⲨ ⲚⲦⲈϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ϮⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ϢⲀ ⲠⲀⲒⲰⲦ ⲈⲦⲈ ⲠⲈⲦⲚⲈⲒⲰⲦ ⲠⲈ ⲀⲨⲰ ⲠⲀⲚⲞⲨⲦⲈ ⲈⲦⲈ ⲠⲈⲦⲚⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ⲀⲤⲈⲒ ⲚϬⲒ ⲘⲀⲢⲒϨⲀⲘ ⲦⲘⲀⲄⲆⲀⲖⲎⲚⲎ ⲀⲤⲦⲀⲘⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲈⲒⲚⲀⲨ ⲈⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲀϤϪⲈ ⲚⲀⲒ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ⲢⲞⲨϨⲈ ⲆⲈ ⲚⲦⲔⲨⲢⲒⲀⲔⲎ ⲘⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲢⲈ ⲢⲢⲞ ϢⲞⲦⲘ ⲘⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲤⲞⲞⲨϨ ⲈϨⲞⲨⲚ ⲚϨⲎⲦϤ ⲈⲦⲂⲈ ⲐⲞⲦⲈ ⲚⲒⲞⲨⲆⲀⲒ. ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϮⲢⲎⲚⲎ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲀϤⲦⲤⲀⲂⲞⲞⲨ ⲈⲚⲈϤϬⲒϪ ⲘⲚ ⲠⲈϤⲤⲠⲒⲢ. ⲀⲨⲢⲀϢⲈ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ⲠⲈϪⲀϤ ⲆⲈ ⲞⲚ ⲚⲀⲨ. ϪⲈ ϮⲢⲎⲚⲎ ⲚⲎⲦⲚ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲠⲀⲒⲰⲦ ⲦⲚⲚⲞⲞⲨⲦ ⲀⲚⲞⲔ ϨⲰⲰⲦ ⲞⲚ ϮϪⲞⲞⲨ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲀϤⲚⲒϤⲈ ⲈϨⲞⲨⲚ ϨⲘ ⲠⲈⲨϨⲞ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϪⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ⲚⲈⲦⲈⲦⲚⲀⲔⲀ ⲚⲈⲨⲚⲞⲂⲈ ⲚⲀⲨ ⲈⲂⲞⲖ ⲤⲈⲚⲀⲔⲀⲀⲨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲈⲦⲈⲦⲚⲀⲀⲘⲀϨⲦⲈ ⲚⲚⲞⲨⲞⲨ ⲤⲈⲚⲀⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ⲐⲰⲘⲀⲤ ⲆⲈ ⲞⲨⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲚⲈϤ ⲚⲘⲘⲀⲨ ⲀⲚ ⲠⲈ ⲚⲦⲈⲢⲈϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ⲚⲈⲨϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲀϤ ⲚϬⲒ ⲚⲔⲈⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈⲠϪⲞⲈⲒⲤ ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲈⲒⲦⲘⲚⲀⲨ ⲈⲚⲈϢⲤⲚⲈⲒϤⲦ ϨⲚ ⲚⲈϤϬⲒϪ ⲀⲨⲰ ⲦⲀⲚⲈϪ ⲠⲀⲦⲎⲎⲂⲈ ⲈϪⲚ ⲚⲈϢⲤⲚⲈⲒϤⲦ ⲀⲨⲰ ⲦⲀⲚⲈϪ ⲦⲀϬⲒϪ ⲈϪⲘ ⲠⲈϤⲤⲠⲒⲢ ⲚϮⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ⲘⲚⲚⲤⲀ ϢⲘⲞⲨⲚ ⲆⲈ ⲚϨⲞⲞⲨ ⲚⲈⲨ ⲚϨⲞⲨⲚ ⲞⲚ ⲠⲈ ⲚϬⲒ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲰ ⲠⲔⲈⲐⲰⲘⲀⲤ ⲚⲘⲘⲀⲨ. ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲈⲢⲈ ⲢⲢⲞ ϢⲞⲦⲘ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ϮⲒⲢⲎⲚⲎ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ⲈⲒⲦⲀ ⲠⲈϪⲀϤ ⲚⲐⲰⲘⲀⲤ ϪⲈ ⲀⲨ ⲠⲈⲔⲦⲎⲎⲂⲈ ⲈⲠⲈⲈⲒⲘⲀ ⲚⲄⲚⲀⲨ ⲈⲚⲀϬⲒϪ ⲀⲨⲰ ⲀⲨ ⲦⲈⲔϬⲒϪ ⲚⲄⲚⲞϪⲤ ⲈϪⲘ ⲠⲀⲤⲠⲒⲢ ⲀⲨⲰ ⲚⲄⲦⲘϢⲰⲠⲈ ⲚⲀⲠⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ⲘⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲐⲰⲘⲀⲤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲠⲀϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠⲀⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲈⲂⲞⲖ ϪⲈ ⲀⲔⲚⲀⲨ ⲈⲢⲞⲈⲒ ⲀⲔⲠⲒⲤⲦⲈⲨⲈ. ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲈ ⲘⲠⲞⲨⲚⲀⲨ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ⲀϤⲢ ϨⲈⲚⲔⲈⲘⲀⲒⲚ ⲆⲈ ⲈⲚⲀϢⲰⲞⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲒ ⲈⲚⲤⲈⲤⲎϨ ⲀⲚ ⲈⲠⲈⲈⲒϪⲰⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ⲚⲦⲀⲨⲤⲈϨ ⲚⲀⲒ ⲆⲈ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲠⲒⲤⲦⲈⲨⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲀⲨⲰ ϪⲈⲔⲀⲀⲤ ⲈⲀⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲦⲈⲦⲚⲈϪⲒ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϨⲘ ⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲞⲚ ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲞⲚϨϤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲚⲦⲒⲂⲈⲢⲒⲀⲤ. ⲚⲦⲀϤⲞⲨⲞⲚϨϤ ⲆⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ⲚⲈⲨϢⲞⲞⲠ ϨⲒ ⲞⲨⲤⲞⲠ ⲠⲈ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲘ ⲐⲰⲘⲀⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲀⲨⲰ ⲚⲀⲐⲀⲚⲀⲎⲖ ⲠⲈⲂⲞⲖ ϨⲚ ⲔⲀⲚⲀ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲚⲘ ⲚϢⲎⲢⲈ ⲚⲌⲈⲂⲈⲆⲀⲒⲞⲤ ⲀⲨⲰ ⲔⲈⲤⲚⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ⲠⲈϪⲀϤ ⲚⲀⲨ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϪⲈ ϮⲚⲀⲂⲰⲔ ⲈϬⲈⲠ ⲦⲂⲦ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲦⲚⲚⲎⲨ ϨⲰⲰⲚ ⲚⲘⲘⲀⲔ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲀⲨⲀⲖⲈ ⲈⲠϪⲞⲈⲒ ⲀⲨⲰ ⲘⲠⲞⲨϬⲈⲠ ⲖⲀⲀⲨ ϨⲚ ⲦⲈⲨϢⲎ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ⲚⲦⲈⲢⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲀϨⲈⲢⲀⲦϤ ϨⲒ ⲠⲈⲔⲢⲞ. ⲘⲠⲞⲨⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲈⲒϢⲎⲢⲈ ϢⲎⲘ ⲘⲎ ⲞⲨⲚ ⲖⲀⲀⲨ ⲚⲦⲂⲦ ⲚⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲨⲞⲨⲰϢⲂ ⲚⲀϤ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲚⲒⲚⲈ ⲘⲠⲈⲦⲚϢⲚⲈ ⲚⲤⲀ ⲞⲨⲚⲀⲘ ⲘⲠϪⲞⲈⲒ ⲀⲨⲰ ⲦⲈⲦⲚⲀϨⲈ ⲈⲞⲨⲞⲚ ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲀⲚϢⲠϨⲒⲤⲈ ⲚⲦⲈⲨϢⲎ ⲦⲎⲢⲈⲤ ⲘⲠⲚϬⲈⲠ ⲖⲀⲀⲨ ⲈϪⲘ ⲠⲈⲔⲢⲀⲚ ⲆⲈ ⲦⲚⲚⲀⲚⲞϪϤ ⲀⲨⲚⲞϪϤ ⲆⲈ ⲀⲨⲰ ⲘⲠⲞⲨⲈϢ ϬⲘϬⲞⲘ ⲈⲤⲞⲔϤ ⲈϨⲢⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲀϢⲎ ⲚⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ⲠⲈϪⲀϤ ϬⲈ ⲘⲠⲈⲦⲢⲞⲤ ⲚϬⲒ ⲠⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈ ⲘⲘⲞϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ. ⲤⲒⲘⲰⲚ ϬⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ ⲀϤⲘⲞⲢϤ ⲘⲠⲈϤⲈⲠⲈⲚⲆⲨⲦⲎⲤ ⲚⲈϤⲔⲎ ⲄⲀⲢ ⲔⲀϨⲎⲨ ⲠⲈ ⲀⲨⲰ ⲀϤϤⲞϬϤ ⲈⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ⲚⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲈⲒ ϨⲒⲠϪⲞⲈⲒ. ⲚⲈⲨⲞⲨⲎⲞⲨ ⲄⲀⲢ ⲀⲚ ⲈⲂⲞⲖ ⲘⲠⲈⲔⲢⲞ ⲀⲖⲖⲀ ⲚⲀϢⲎⲦ ⲘⲘⲀϨⲈ ⲈⲨⲤⲰⲔ ⲘⲠⲈϢⲚⲈ ⲚⲚⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ⲚⲦⲈⲢⲞⲨⲘⲞⲞⲚⲈ ⲆⲈ ⲈⲠⲈⲔⲢⲞ. ⲀⲨⲚⲀⲨ ⲈⲨϢⲀϨ ⲈⲢⲈⲞⲨⲦⲂⲦ ϨⲒϪⲰϤ ⲀⲨⲰ ⲞⲨⲞⲒⲔ ⲈϤⲔⲎ ⲈϨⲢⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ⲀⲚⲒⲚⲈ ⲈⲂⲞⲖ ⲚⲚⲦⲂⲦ ⲈⲚⲦⲀⲦⲈⲦⲚϬⲞⲠⲞⲨ ⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ⲀϤⲀⲖⲈ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲀϤⲤⲰⲔ ⲘⲠⲈϢⲚⲈ ⲈⲠⲈⲔⲢⲞ ⲈϤⲘⲈϨ ⲚⲚⲞϬ ⲚⲦⲂⲦ ⲈⲨⲈⲒⲢⲈ ⲚϢⲈ ⲦⲀⲒⲞⲨ ϢⲞⲘⲦⲈ. ⲀⲨⲰ ⲈⲢⲈ ⲦⲈⲒⲀϢⲎ ⲚⲦⲂⲦ ⲘⲘⲀⲨ ⲘⲠⲈ ⲠⲈϢⲚⲈ ⲠⲰϨ. ");
INSERT INTO copshc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲨ. ϪⲈ ⲀⲘⲎⲈⲒⲦⲚ ⲚⲦⲈⲦⲚ ⲞⲨⲰⲘ. ⲘⲠⲈⲖⲀⲀⲨ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲦⲞⲖⲘⲀ ⲈϪⲚ ⲞⲨϤ ϪⲈ ⲚⲦⲔ ⲚⲒⲘ ⲈⲨⲤⲞⲞⲨⲚ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ⲀϤⲈⲒ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲀϤϪⲒ ⲘⲠⲞⲒⲔ ⲀϤϮ ⲚⲀⲨ ⲀⲨⲰ ⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ⲠⲀⲒ ⲆⲈ ⲠⲈ ⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚⲤⲞⲠ ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞⲚϨϤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲢⲈϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ⲚⲦⲈⲢⲞⲨⲰⲘ ⲆⲈ ⲠⲈϪⲀϤ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲤⲒⲘⲰⲚ ⲠϢⲎⲢⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲔⲘⲈ ⲘⲘⲞⲒ ⲈϨⲞⲨⲈ ⲚⲀⲒ. ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ. ⲚⲦⲞⲔ ⲠⲈⲦⲤⲞⲞⲨⲚ ϪⲈ ϮⲘⲈ ⲘⲘⲞⲔ. ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲘⲞⲞⲚⲈ ⲚⲚⲀϨⲒⲒⲂ. ");
INSERT INTO copshc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ⲠⲈϪⲀϤ ⲞⲚ ⲚⲀϤ ⲘⲠⲘⲈϨ ⲤⲈⲠ ⲤⲚⲀⲨ ϪⲈ ⲤⲒⲘⲰⲚ ⲠϢⲎⲢⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲔⲘⲈ ⲘⲘⲞⲒ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲞⲔ ⲠⲈⲦⲤⲞⲞⲨⲚ ϪⲈ ϮⲘⲈ ⲘⲘⲞⲔ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞⲞⲚⲈ ⲚⲚⲀⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ⲠⲈϪⲀϤ ⲚⲀϤ ⲘⲠⲘⲈϨ ϢⲞⲘⲚⲦ ⲚⲤⲞⲠ ϪⲈ ⲤⲒⲘⲰⲚ ⲠϢⲎⲢⲈ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲔⲘⲈ ⲘⲘⲞⲒ ⲀϤⲖⲨⲠⲒ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲀϤϪⲞⲞⲤ ⲚⲀϤ ⲘⲠⲘⲈϨ ϢⲘⲚⲦ ⲤⲰⲰⲠ ϪⲈ ⲔⲘⲈ ⲘⲘⲞⲒ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲔⲤⲞⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲘ ⲚⲦⲞⲔ ⲔⲤⲞⲞⲨⲚ ϪⲈ ϮⲘⲈ ⲘⲘⲞⲔ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲞⲞⲚⲈ ⲚⲚⲀⲈⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ϨⲀⲘⲎⲚ ϨⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲘⲠⲈⲨⲞⲒϢ ⲈⲚⲈⲔⲞ ⲚϢⲎⲢⲈ ϢⲎⲘ ⲚⲈ ϢⲀⲔⲘⲞⲢⲔ ⲠⲈ ⲚⲄⲂⲰⲔ ⲈⲠⲘⲀ ⲈⲦⲔⲞⲨⲀϢϤ ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲔϢⲀⲚⲢ ϨⲖⲖⲞ ⲔⲚⲀⲠⲢϢ ⲚⲈⲔϬⲒϪ ⲈⲂⲞⲖ ⲚⲦⲈ ⲔⲈⲞⲨⲀ ⲘⲞⲢⲔ ⲚϤϪⲒⲦⲔ ⲈⲠⲘⲀ ⲈⲦⲈ ⲚⲄⲞⲨⲀϢϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ⲚⲦⲀϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲈϤⲤⲎⲘⲀⲚⲈ ϪⲈ ϨⲚ ⲀϢ ⲘⲘⲞⲨ ⲈϤⲚⲀϮ ⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ⲀϤⲔⲦⲞϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀϤⲚⲀⲨ ⲈⲠⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈ ⲘⲘⲞϤ ⲈϤⲞⲨⲎϨ ⲚⲤⲰϤ ⲠⲀⲒ ⲚⲦⲀϤⲚⲞϪϤ ϨⲘ ⲠⲆⲈⲒⲠⲚⲞⲚ ⲈϪⲚ ⲦⲈϤⲘⲈⲤⲦ ϨⲎⲦ ⲚⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ⲚⲦⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ϬⲈ ⲚⲀⲨ ⲈⲠⲀⲒ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲀⲒ ⲆⲈ ⲚⲦⲞϤ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ. ϪⲈ ⲈⲒϢⲀⲚⲞⲨⲰϢ ⲈⲦⲢⲈϤϬⲰ ϢⲀⲚϮⲈⲒ ⲚⲦⲔ ⲚⲒⲘ ⲚⲦⲞⲔ ⲞⲨⲀϨⲔ ⲚⲤⲰⲈⲒ ⲚⲦⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ⲀⲠⲈⲈⲒϢⲀϪⲈ ϬⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲤⲚⲎⲨϪⲈ ⲘⲠⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲘⲘⲀⲨ ⲚⲀⲘⲞⲨ ⲀⲚ. ⲚⲦⲀϤϪⲞⲞⲤ ⲆⲈ ⲚⲀϤ ⲀⲚ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚϤⲚⲀⲘⲞⲨ ⲀⲚ. ⲀⲖⲖⲀ ⲈⲒϢⲀⲚⲞⲨⲰϢ ⲈⲦⲢⲈϤϬⲰ ϢⲀⲚϮⲈⲒ ⲚⲦⲔ ⲚⲒⲘ ⲚⲦⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ⲠⲀⲒ ⲠⲈ ⲠⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲈ ⲚⲀⲒ ⲀⲨⲰ ⲠⲈⲚⲦⲀϤⲤⲈϨ ⲚⲀⲒ. ⲀⲨⲰ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨⲘⲈ ⲦⲈ ⲦⲈϤⲘⲚⲦⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ⲞⲨⲚ ϨⲈⲚⲔⲈϨⲂⲎⲨⲈ ⲆⲈ ⲈⲚⲀϢⲰⲞⲨ ⲈⲀϤⲀⲀⲨ ⲚϬⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲒ ⲈⲨϢⲀⲚⲤⲀϨⲞⲨ ⲞⲨⲀ ⲞⲨⲀ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲚⲀϢⲠ ⲚϪⲰⲰⲘⲈ ⲀⲚ ⲈⲦⲞⲨⲚⲀⲤⲀϨⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ⲠϢⲞⲢⲠ ⲘⲈⲚ ⲚⲖⲞⲄⲞⲤ ⲀⲒⲦⲀⲘⲒⲞϤ Ⲱ ⲐⲈⲞⲪⲒⲖⲈ. ⲈⲦⲂⲈ ϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲢⲬⲈⲒ ⲚⲀⲀⲨ. ⲀⲨⲰ ⲚϮⲤⲂⲰ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ϢⲀϨⲢⲀⲒ ⲈⲠⲈϨⲞⲞⲨ ⲚⲦⲀⲨⲀⲚⲀⲖⲀⲘⲂⲀⲚⲈ ⲘⲘⲞϤ ⲈⲀϤϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ ⲚⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲀⲒ ⲚⲦⲀϤⲤⲞⲦⲠⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ⲚⲀⲒ ⲞⲚ ⲚⲦⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲚⲀⲨ ⲈϤⲞⲚϨ. ⲘⲚⲚⲤⲀ ⲦⲢⲈϤⲘⲞⲨ ϨⲚ ϨⲀϨ ⲘⲘⲀⲈⲒⲚ ⲚϨⲘⲈ ⲚϨⲞⲞⲨ. ⲈϤⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲈϤϢⲀϪⲈ ⲈⲦⲂⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ⲀⲨⲰ ⲈϤⲞⲨⲰⲘ ⲚⲘⲘⲀⲨ ⲚⲈϤⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲨ ⲈⲦⲘⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲖⲖⲀ ⲈϬⲰ ⲈⲠⲈⲢⲎⲦ ⲘⲠⲈⲒⲰⲦ ⲠⲀⲒ ⲚⲦⲀⲦⲈⲦⲚⲤⲞⲦⲘⲈϤ ⲚⲦⲞⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ⲠⲈϪⲀϤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲀϤⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲞⲨⲘⲞⲞⲨ ⲚⲦⲰⲦⲚ ⲆⲈ ⲤⲈⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲘⲚⲚⲤⲀ ϨⲀϨ ⲀⲚ ⲚϨⲞⲞⲨ ⲀⲖⲖⲀ ϢⲀ ⲦⲠⲈⲚⲦⲎⲔⲞⲤⲦⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ⲚⲦⲞⲞⲨ ϬⲈ ⲀⲨⲤⲰⲞⲨϨ ⲀⲨϪⲚⲞⲨϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲈⲚ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲒⲞⲨⲈⲒϢ ⲔⲚⲀϮ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲠⲰⲦⲚ ⲀⲚ ⲠⲈ ⲤⲞⲨⲚ ⲚⲈⲨⲞⲒϢ ⲘⲚ ⲚⲈⲬⲢⲞⲚⲞⲤ. ⲚⲀⲒ ⲚⲦⲀ ⲠⲈⲒⲰⲦ ⲔⲀⲀⲨ ϨⲚ ⲦⲈϤⲈⲜⲞⲨⲤⲒⲀ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ⲀⲖⲖⲀ ⲦⲈⲦⲚⲀϪⲒ ⲚⲞⲨϬⲞⲘ ⲈⲢϢⲀⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲦⲚ. ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲚⲀⲒ ⲘⲘⲚⲦⲢⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲚ ϮⲞⲨⲆⲀⲒⲀ ⲦⲎⲢⲤ ⲘⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲀⲨⲰ ϢⲀ ⲀⲢⲎϪϤ ⲘⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ⲚⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲞⲞⲨ ⲀⲨⲔⲖⲞⲞⲖⲈ ϪⲒⲦϤ. ⲀⲨⲰ ⲀⲨϤⲒ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ⲈⲨⲈⲒⲞⲢⲘ ⲆⲈ ⲚⲤⲰϤ ⲈϤⲂⲎⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ⲈⲒⲤ ⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲚⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ϨⲒϪⲰⲞⲨ ϨⲚ ϨⲈⲚϨⲂⲤⲰ ⲈⲨⲞⲨⲞⲂϢ. ");
INSERT INTO copshc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚϬⲰϢⲦ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲀⲨϤⲒⲦϤ ⲚⲦⲈⲦⲎⲨⲦⲚ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦϤⲚⲎⲨ ⲘⲘⲞⲤ ⲚⲐⲈ ⲚⲦⲀⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ⲦⲞⲦⲈ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲦⲞⲞⲨ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲦⲞⲞⲨ ⲚⲚϪⲞⲈⲒⲦ. ⲈϤⲞⲨⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲞⲨϨⲒⲎ ⲚⲤⲀϢϤ ⲚϨⲞⲞⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈϨⲞⲨⲚ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲘⲀ ⲚⲦⲠⲈ ⲈⲚⲈⲨⲞⲨⲎϨ ⲚϨⲎⲦϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲚ ⲒⲀⲔⲰⲂⲞⲤ ⲀⲨⲰ ⲀⲚⲆⲢⲈⲀⲤ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲚ ⲐⲰⲘⲀⲤ ⲂⲀⲢⲐⲞⲖⲞⲘⲀⲒⲞⲤ ⲘⲚ ⲘⲀⲐⲐⲀⲒⲞⲤ ⲒⲀⲔⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲈ ⲚⲀⲖⲪⲀⲒⲞⲤ ⲀⲨⲰ ⲤⲒⲘⲰⲚ ⲠⲌⲎⲖⲰⲦⲎⲤ ⲘⲚ ⲒⲞⲨⲆⲀⲤ ⲠϢⲎⲢⲈ ⲚⲒⲀⲔⲔⲰⲂⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲨⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲠⲈϢⲖⲎⲖ ⲘⲚ ϨⲈⲚⲤϨⲒⲘⲈ ⲘⲚ ⲘⲀⲢⲒⲀ ⲦⲘⲀⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲚⲈϤⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ϨⲢⲀⲒ ⲆⲈ ϨⲚ ⲚⲈⲒϨⲞⲞⲨ ⲀϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲚⲦⲘⲎⲦⲈ ⲚⲚⲈⲤⲚⲎⲨ ⲈⲨⲚ ⲞⲨⲘⲎⲎ ϢⲈ ⲘⲘⲀⲨ ⲈⲨⲚⲀⲢⲀϢⲈ ϪⲞⲨⲰⲦ ⲚⲢⲀⲚ ⲀⲨⲰ ⲠⲈϪⲀϤ ");
INSERT INTO copshc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ ⲚⲈϨⲀⲠⲤ ⲈⲦⲢⲈ ⲦⲈⲒⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ⲦⲀⲒ ⲚⲦⲀϤϪⲞⲞⲤ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲚϬⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲆⲀⲨⲈⲒⲆ ⲈⲦⲂⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚⲢⲈϤϪⲒⲘⲞⲈⲒⲦ ⲚⲚⲈⲚⲦⲀⲨϬⲰⲠⲈ ⲚⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ϪⲈ ⲚⲈ ⲀⲨⲞⲠϤ ⲠⲈ ϨⲢⲀⲒ ⲚϨⲎⲦⲚ. ⲀⲨⲰ ⲀϤϪⲒ ⲘⲠⲈⲔⲖⲎⲢⲞⲤ ⲚⲦⲈⲒⲆⲒⲀⲔⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ⲠⲀⲒ ϬⲈ ⲀϤϢⲰⲠ ⲚⲀϤ ⲚⲞⲨϬⲰⲘ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲈⲔⲈ ⲘⲠⲈϤϪⲒ ⲚϬⲞⲚⲤ. ⲀⲨⲰ ⲀϤϨⲈ ⲈϪⲘ ⲠⲈϤϨⲞ ⲀϤⲠⲰϢ ⲈⲦⲈϤⲘⲎⲦⲈ. ⲀⲚⲈⲦⲠⲈϤϨⲞⲨⲚ ⲦⲎⲢⲞⲨ ⲠⲰⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ⲀⲨⲰ ⲀⲠⲈⲒϨⲰⲂ ϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ϨⲰⲤⲦⲈ ⲚⲤⲈⲘⲞⲨⲦⲈ ⲈⲠϬⲰⲘ ⲈⲦⲘⲘⲀⲨ ϨⲚ ⲦⲈⲨⲀⲤⲠⲈ ϪⲈ ⲀⲔⲈⲖⲆⲀⲘⲀⲬ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠϬⲰⲘ ⲘⲠⲈⲤⲚⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ϤⲤⲎϨ ⲄⲀⲢ ϨⲘ ⲠϪⲰⲰⲘⲈ ⲚⲚⲈⲮⲀⲖⲘⲞⲤ ϪⲈ ⲘⲀⲢⲈⲦⲈϤⲢⲤⲰ ϢⲰⲠⲈ ⲚϪⲀⲒⲈ. ⲀⲨⲰ ⲘⲠⲢⲦⲢⲈϤϢⲰⲠⲈ ⲚϬⲒ ⲠⲈⲦⲞⲨⲎϨ ϨⲚ ⲚⲈϤⲘⲀ ⲚϢⲰⲠⲈ. ⲀⲨⲰ ⲦⲈϤⲘⲚⲦⲈⲠⲒⲤⲔⲞⲠⲞⲤ ⲘⲀⲢⲈ ⲔⲈⲞⲨⲀ ϪⲒⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ϢϢⲈ ϬⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲢⲰⲘⲈ ⲈⲦⲘⲞⲞϢⲈ ⲚⲘⲘⲀⲚ. ϨⲘ ⲠⲈⲒⲞⲨⲞⲈⲒϢ ⲦⲎⲢϤ ⲚⲦⲀϤⲈⲒ ⲈϨⲞⲨⲚ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲚ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ⲈⲀϤⲀⲢⲬⲈⲒ ϪⲒⲚ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ϢⲀϨⲢⲀⲒ ⲈⲠⲈϨⲞⲞⲨ ⲚⲦⲀⲨϤⲒⲦϤ ⲈϨⲢⲀⲒ ⲚⲦⲞⲞⲦⲚ. ⲈⲦⲢⲈ ⲞⲨⲀ ⲚⲚⲀⲒ ϢⲰⲠⲈ ⲚⲘⲘⲀⲚ ⲘⲘⲚⲦⲢⲈ ⲚⲦⲈϤⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ⲀⲨⲰ ⲀⲨⲦⲀϨⲈ ⲤⲚⲀⲨ ⲈⲢⲀⲦⲞⲨ ⲒⲰⲤⲎⲤ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲤⲀⲂⲀⲤ ⲠⲀⲒ ⲚⲦⲀⲨϮⲢⲒⲚϤ ⲈⲒⲞⲨⲤⲦⲞⲤ ⲀⲨⲰ ⲘⲀⲐⲒⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ⲀⲨϢⲖⲎⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲞⲔ ⲈⲦⲤⲞⲞⲨⲚ ⲘⲪⲎⲦ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲞⲨⲀ ⲘⲠⲈⲒⲤⲚⲀⲨ. ⲠⲈⲚⲦⲀⲔⲤⲞⲦⲠϤ ");
INSERT INTO copshc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ⲈϪⲒ ⲘⲠⲘⲀ ⲚⲦⲈⲒⲆⲒⲀⲔⲞⲚⲒⲀ. ⲀⲨⲰ ⲦⲘⲚⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲦⲀϤⲠⲀⲢⲀⲂⲀ ⲚϨⲎⲦⲤ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲘⲀ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ⲀⲨⲰ ⲀⲨϮ ⲚⲀⲨ ⲚϨⲈⲚⲔⲖⲎⲢⲞⲤ. ⲀⲠⲈⲔⲖⲎⲢⲞⲤ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲘⲀⲐⲒⲀⲤ. ⲀⲨⲞⲠϤ ⲘⲚ ⲠⲘⲚⲦⲞⲨⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ⲚⲦⲈⲢⲈϤϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈϨⲞⲞⲨ ⲚⲦⲠⲈⲚⲦⲎⲔⲞⲤⲦⲎ. ⲚⲈⲨϢⲞⲞⲠ ⲦⲎⲢⲞⲨ ⲠⲈ ϨⲒ ⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ⲀⲨⲰ ⲀϤϢⲰⲠⲈ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲚϬⲒ ⲞⲨϨⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲚⲐⲈ ⲚⲞⲨⲠⲚⲞⲎ ⲈⲨⲈⲒⲚⲈ ⲘⲘⲞⲤ ⲚϬⲞⲚⲤ. ⲀⲨⲰ ⲀⲤⲘⲞⲨϨ ⲘⲠⲎⲒ ⲦⲎⲢϤ ⲈⲚⲈⲨϨⲘⲞⲞⲤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ⲀⲨⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚϬⲒ ϨⲈⲚⲖⲀⲤ ⲈⲨⲠⲞⲢϪ ⲚⲐⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲔⲰϨⲦ. ⲀⲨⲰ ⲀⲨϨⲘⲞⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ⲀⲨⲘⲞⲨϨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲀⲨⲰ ⲀⲨⲀⲢⲬⲈⲒ ⲚϢⲀϪⲈ ϨⲢⲀⲒ ϨⲚ ϨⲈⲚⲔⲈⲀⲤⲠⲈ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲈⲢⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ϮⲚⲀⲨ ⲈⲦⲢⲈⲨϢⲀϪⲈ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ⲚⲈⲨϢⲞⲞⲠ ⲆⲈ ⲠⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲈⲨⲞⲨⲎϨ ⲚϬⲒ ϨⲈⲚⲒⲞⲨⲆⲀⲒ. ϨⲈⲚⲢⲰⲘⲈ ⲚⲢⲈϤⲢϨⲞⲦⲈ ⲈⲂⲞⲖ ϨⲚ ϨⲈⲐⲚⲞⲤ ⲚⲒⲘ ⲈⲦϨⲀⲠⲈⲤⲎⲦ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ⲚⲦⲈⲢⲈ ⲦⲈⲒⲤⲘⲎ ⲆⲈ ϢⲰⲠⲈ. ⲀⲠⲘⲎⲎϢⲈ ⲤⲰⲞⲨϨ ⲀⲨⲰ ⲀⲨϢⲦⲞⲢⲦⲢ. ϪⲈ ⲚⲈⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲈⲨϢⲀϪⲈ ϨⲚ ⲦⲈϤⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ⲀⲨⲠⲰϢⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨⲢϢⲠⲎⲢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲚϨⲈⲚⲄⲀⲖⲒⲖⲀⲒⲞⲤ ⲀⲚ ⲚⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ⲀⲨⲰ ⲚⲀϢ ⲚϨⲈ ⲀⲚⲞⲚ ⲦⲚⲤⲰⲦⲘ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϨⲢⲀⲒ ϨⲚ ⲦⲈϤⲀⲤⲠⲈ ⲚⲦⲀⲨϪⲠⲞⲚ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ⲘⲠⲀⲢⲐⲞⲤ ⲘⲚ ⲘⲘⲎⲆⲞⲤ ⲘⲚ ⲚⲖⲀⲘⲒⲦⲎⲤ ⲀⲨⲰ ⲚⲈⲦⲞⲨⲎϨ ϨⲚ ⲦⲘⲈⲤⲀⲠⲞⲆⲀⲘⲒⲀ ϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲦⲔⲀⲠⲠⲀⲆⲞⲔⲒⲀ ⲠⲠⲞⲚⲦⲞⲤ ⲀⲨⲰ ⲦⲀⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ⲦⲈⲪⲢⲨⲄⲒⲀ ⲘⲚ ⲦⲠⲀⲘⲪⲨⲖⲒⲀ ⲔⲎⲘⲈ ⲀⲨⲰ ⲚⲤⲀ ⲚⲦⲖⲒⲂⲨⲎ ⲈⲦϨⲚⲦⲔⲨⲢⲎⲚⲎ ⲀⲨⲰ ⲚⲈϨⲢⲰⲘⲀⲒⲞⲤ ⲈⲦⲦⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚⲈⲠⲢⲞⲤⲨⲖⲨⲦⲞⲤ. ⲚⲈⲔⲢⲒⲦⲎⲤ ⲀⲨⲰ ⲚⲀⲢⲀⲂⲞⲤ. ⲦⲚⲤⲰⲦⲘ ⲈⲢⲞⲞⲨ ⲈⲨϢⲀϪⲈ ϨⲚ ϨⲈⲚⲀⲤⲠⲈ ⲈⲨⲦⲀⲨⲞ ⲚⲘⲘⲚⲦⲚⲞϬ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ⲀⲨⲠⲰϢⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲀⲨⲀⲠⲞⲢⲢⲒ. ⲞⲨⲀ ⲚⲚⲀϨⲢⲚ ⲞⲨⲀ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲈⲒϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲈⲨⲚⲞϬⲚⲈϬ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈ ϨⲎⲦⲞⲨ ⲘⲈϨ ⲚⲘⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ⲀϤⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦϤ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲠⲘⲚⲦⲞⲨⲈ ⲀϤϤⲒ ⲚⲦⲈϤⲤⲘⲎ ⲈϨⲢⲀⲒ ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲀⲢⲈ ⲠⲀⲒ ϢⲰⲠⲈ ⲈϤⲞⲨⲞⲚϨ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ϪⲒⲤⲘⲎ ⲈⲚⲀϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ⲚⲈⲢⲈ ⲚⲀⲒ ⲄⲀⲢ ⲦⲀϨⲈ ⲀⲚ ⲚⲐⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲈⲢⲞⲤ. ϪⲠϢⲞⲘⲦⲈ ⲄⲀⲢ ⲘⲠⲈϨⲞⲞⲨ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ⲀⲖⲖⲀ ⲠⲀⲒ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲒⲰⲎⲖ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ϪⲈ ⲤⲚⲀϢⲰⲠⲈ ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲠⲈϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲦⲀⲠⲰϨⲦ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲠⲚⲈⲨⲘⲀ ⲈϪⲚ ⲤⲀⲢⲜ ⲚⲒⲘ. ⲚⲤⲈⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲚϬⲒ ⲚⲈⲦⲚϢⲎⲢⲈ ⲘⲚ ⲚⲈⲦⲚϢⲈⲈⲢⲈ. ⲀⲨⲰ ⲚⲦⲈ ⲚⲈⲦⲚϨⲢϢⲒⲢⲈ ⲚⲀⲨ ⲈϨⲈⲚϨⲞⲢⲞⲤⲒⲤ ⲚⲦⲈ ⲚⲈⲦⲚϨⲖⲖⲞ ⲠⲰⲰⲢⲈ ⲚϨⲈⲚⲢⲀⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ⲀⲨⲰ ϮⲚⲀⲠⲰϨⲦ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲠⲚⲈⲨⲘⲀ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲀϨⲘϨⲀⲖ ⲚϨⲞⲞⲨⲦ ⲘⲚ ⲚⲀϨⲘϨⲀⲖ ⲚⲤϨⲒⲘⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲤⲈⲠⲢⲞⲪⲎⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ⲦⲀϮ ⲚϨⲈⲚⲘⲀⲈⲒⲚ ϨⲢⲀⲒ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ϨⲈⲚϢⲠⲎⲢⲈ ⲘⲠⲈⲤⲎⲦ ϨⲒϪⲘ ⲠⲔⲀϨ ⲞⲨⲤⲚⲞϤ ⲘⲚ ⲞⲨⲔⲰϨⲦ ⲘⲚ ⲞⲨⲖϨⲰⲂ ⲚⲔⲀⲠⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ⲠⲢⲎ ⲚⲀⲔⲦⲞϤ ⲈⲨⲔⲀⲔⲈ ⲀⲨⲰ ⲠⲞⲞϨ ⲈⲨⲤⲚⲞϤ. ⲘⲠⲀⲦϤⲈⲒ ⲚϬⲒ ⲠⲈϨⲞⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ⲠⲚⲞϬ ⲈⲦⲞⲨⲞⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ⲀⲨⲰ ⲤⲚⲀϢⲰⲠⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲰϢ ⲘⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ϤⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ⲚⲢⲰⲘⲈ ⲚⲦⲈⲠ ⲒⲤⲢⲀⲎⲖ ⲤⲰⲦⲘ ⲈⲚⲀϢⲀϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲞⲨⲢⲰⲘⲈ ⲈⲀⲨⲦⲞϢϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ϨⲢⲀⲒ ϨⲚ ϨⲈⲚϬⲞⲘ ⲘⲚ ϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ⲚⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ϨⲚ ⲦⲈⲦⲚⲘⲎⲦⲈ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ⲠⲀⲒ ϨⲘ ⲠϢⲞϪⲚⲈ ⲈⲦⲦⲎϢ ⲘⲚ ⲠⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲦⲈⲦⲚⲦⲀⲀϤ ⲈϨⲢⲀⲒ ⲈⲚϬⲒϪ ⲚⲀⲚⲞⲘⲞⲤ. ⲀⲦⲈⲦⲚⲀϢⲦϤ. ⲀⲦⲈⲦⲚⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ⲠⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲞⲤϤ ⲈⲀϤⲂⲰⲖ ⲈⲂⲞⲖ ⲚⲚⲚⲀⲀⲔⲈ ⲘⲠⲘⲞⲨ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲘⲚ ϢϬⲞⲘ ⲈⲦⲢⲈⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ⲆⲀⲨⲈⲒⲆ ⲄⲀⲢ ϪⲰ ⲘⲘⲞⲤ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ϪⲈ ⲚⲈⲒⲚⲀⲨ ⲈⲠϪⲞⲈⲒⲤ ⲠⲈ ⲘⲠⲀⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ϪⲈ ϤϨⲒⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ ϪⲈ ⲚⲚⲀⲔⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲠⲀϨⲎⲦ ⲈⲨⲪⲢⲀⲚⲈ ⲀⲨⲰ ⲀⲠⲀⲖⲀⲤ ⲦⲈⲖⲎⲖ. ⲈⲦⲒ ⲆⲈ ⲦⲀⲔⲈⲤⲀⲢⲜ ⲚⲀⲞⲨⲰϨ ϨⲚ ⲞⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ϪⲈ ⲚⲄⲚⲀⲔⲰ ⲚⲤⲰⲔ ⲀⲚ ⲚⲦⲀⲮⲨⲬⲎ ϨⲚ ⲀⲘⲚⲦⲈ. ⲞⲨⲆⲈ ⲚⲄⲚⲀϮ ⲀⲚ ⲘⲠⲈⲔⲠⲈⲦⲞⲨⲀⲀⲂ ⲈⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ⲀⲔⲞⲨⲰⲚϨ ⲚⲀⲒ ⲈⲂⲞⲖ ⲚⲚⲈϨⲒⲞⲞⲨⲈ ⲘⲠⲰⲚϨ. ⲔⲚⲀϪⲞⲔⲦ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲨⲚⲞϤ ⲘⲚ ⲠⲈⲔϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ ϢϢⲈ ⲈⲦⲢⲈⲚϪⲞⲞⲤ ⲚⲎⲦⲚ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲈⲦⲂⲈ ⲠⲠⲀⲦⲢⲒⲀⲢⲬⲎⲤ ⲆⲀⲨⲈⲒⲆ ϪⲈ ⲀϤⲘⲞⲨ ⲀⲨⲰ ⲀⲨⲦⲞⲘⲤϤ ⲀⲨⲰ ⲠⲈϤⲘϨⲀⲀⲨ ϢⲞⲞⲠ ⲚϨⲎⲦⲚ ϢⲀϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ⲈⲨⲠⲢⲞⲪⲎⲦⲎⲤ ϬⲈ ⲠⲈ ⲀⲨⲰ ⲈϤⲤⲞⲞⲨⲚ ϪⲈ ϨⲚ ⲞⲨⲀⲚⲀϢ ⲀⲠⲚⲞⲨⲦⲈ ⲰⲢⲔ ⲚⲀϤ. ⲈⲐⲘⲤⲞ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀⲢⲠⲞⲤ ⲚⲦⲈϤϮⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈϤⲐⲢⲞⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ⲀϤϢⲢⲠⲈⲒⲘⲈ ⲀϤϢⲀϪⲈ ⲈⲦⲂⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ϪⲈ ⲞⲨⲆⲈ ⲘⲠⲞⲨⲔⲀⲀϤ ϨⲚ ⲀⲘⲚⲦⲈ ⲞⲨⲆⲈ ⲘⲠⲈ ⲦⲈϤⲤⲀⲢⲜ ⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲞⲤϤ. ⲠⲀⲒ ⲈⲚϢⲞⲞⲠ ⲚⲀϤ ⲦⲎⲢⲚ ⲘⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ⲈⲀϤϪⲒⲤⲈ ϬⲈ ⲈϨⲢⲀⲒ ϨⲚ ⲦⲞⲨⲚⲀⲘ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤϪⲒ ⲘⲠⲈⲢⲎⲦ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲒⲰⲦ ⲀϤⲠⲰϨⲦ ⲘⲠⲈⲒⲦⲀⲒⲞ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲰ ⲈⲦⲈⲦⲚⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ⲆⲀⲨⲈⲒⲆ ⲄⲀⲢ ⲀⲚ ⲠⲈⲚⲦⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲘⲠⲎⲨⲈ. ϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲦⲞϤ. ϪⲈ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲀϪⲞⲈⲒⲤ ϪⲈ ϨⲘⲞⲞⲤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ϢⲀⲚϮⲔⲰ ⲚⲚⲈⲔϪⲀϪⲈ ⲚϨⲨⲠⲞⲠⲞⲆⲒⲞⲚ ⲚⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ϨⲚ ⲞⲨⲰⲢϪ ϬⲈ ⲘⲀⲢⲈϤⲈⲒⲘⲈ ⲚϬⲒ ⲠⲎⲒ ⲦⲎⲢϤ ⲘⲠⲒⲤⲢⲀⲎⲖ ϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ⲀⲀϤ ⲚϪⲞⲈⲒⲤ ⲀⲨⲰ ⲚⲬⲢⲎⲤⲦⲞⲤ. ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀⲦⲈⲦⲚⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲨⲘⲔⲀϨ ⲘⲠⲈⲨϨⲎⲦ. ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ϪⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲀϤ ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲈⲦⲀⲚⲞⲒ. ⲀⲨⲰ ⲘⲀⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲰⲦⲚ ϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ⲀⲨⲰ ⲦⲈⲦⲚⲀϪⲒ ⲚⲦⲆⲰⲢⲈⲀ ⲘⲠⲈⲒⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ⲈⲢⲈ ⲠⲈⲢⲎⲦ ⲄⲀⲢ ϢⲞⲞⲠ ⲚⲎⲦⲚ ⲘⲚ ⲚⲈⲦⲚϢⲎⲢⲈ. ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲘⲠⲞⲨⲈ. ⲚⲀⲒ ⲈⲦⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲚⲚⲞⲨⲦⲈ ⲚⲀⲦⲀϨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ϨⲢⲀⲒ ⲆⲈ ϨⲚ ϨⲈⲚⲔⲈⲘⲎⲎϢⲈ ⲚϢⲀϪⲈ ⲚⲈϤⲢⲘⲚⲦⲢⲈ. ⲀⲨⲰ ⲚⲈϤⲤⲞⲠⲤ ⲘⲘⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲒⲄⲈⲚⲈⲀ ⲈⲦϬⲞⲞⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ⲚⲈⲚⲦⲀⲨϢⲰⲠ ϬⲈ ⲈⲢⲞⲞⲨ ⲘⲠⲈϤϢⲀϪⲈ ⲀⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ. ⲀⲨⲰ ⲀⲨⲞⲨⲰϨ ⲈⲢⲞⲞⲨ ⲘⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲀϢⲘⲦϢⲞ ⲘⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ⲚⲈⲨϢⲞⲞⲠ ⲆⲈ ⲠⲈ ⲈⲨⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲦⲈⲤⲂⲰ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲘⲚ ⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲘⲠⲠⲰϢ ⲘⲠⲞⲈⲒⲔ. ⲀⲨⲰ ⲚⲈϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ⲞⲨⲚⲞϬ ⲚϨⲞⲦⲈ ⲀⲤϢⲰⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲮⲨⲬⲎ ⲚⲒⲘ. ϨⲀϨ ⲄⲀⲢ ⲘⲘⲀⲈⲒⲚ ϨⲒ ϢⲠⲎⲢⲈ ⲚⲈⲨϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲘ ⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ⲀⲨⲰ ⲈⲢⲈ ⲚⲔⲀ ⲚⲒⲘ ϢⲞⲞⲠ ⲚⲀⲨ ϨⲒⲞⲨⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ⲀⲨⲰ ⲚⲈⲨϬⲰⲘ ⲘⲚ ⲚⲈⲨϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲚⲈⲨϮ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲚⲈⲨⲦⲰϢ ⲘⲘⲞⲞⲨ ⲈϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ. ⲔⲀⲦⲀⲐⲈ ⲈⲦⲈ ⲢⲈⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲢⲬⲢⲒⲀ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ⲘⲘⲎⲚⲈ ⲆⲈ ⲚⲈⲨⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ϨⲒ ⲞⲨⲤⲞⲠ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ϨⲘ ⲠⲎⲒ ⲈⲨⲠⲰϢ ⲘⲠⲞⲈⲒⲔ ⲈⲨϪⲒ ⲚⲞⲨⲦⲢⲞⲪⲎ ϨⲚ ⲞⲨⲦⲈⲖⲎⲖ ⲘⲚ ⲦⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ ⲚⲦⲈ ⲠⲈⲨϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲈⲨⲚⲦⲞⲨ ⲬⲀⲢⲒⲤ ⲘⲘⲀⲨ ⲚⲚⲀϨⲢⲘ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ. ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲚⲈϤⲞⲨⲰϨ ⲈⲢⲞⲞⲨ ⲚⲚⲈⲦⲚⲀⲞⲨϪⲀⲒ ⲘⲘⲎⲚⲈ ϨⲒ ⲞⲨⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲈⲨⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲢⲠⲈ ⲚϪⲠ ⲮⲒⲦⲈ ⲘⲠⲚⲀⲨ ⲘⲠⲈϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ⲀⲨⲰ ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲚϬⲀⲖⲈ ϪⲒⲚ ⲈϤⲚϨⲎⲦⲤ ⲚⲦⲈϤⲘⲀⲀⲨ ⲈϢⲀⲨϤⲒⲦϤ. ⲠⲀⲒ ⲈⲚⲈⲨⲔⲰ ⲘⲘⲞϤ ϨⲒⲢⲘ ⲠⲢⲞ ⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲚⲈⲤⲰϤ ⲚⲦⲈ ⲠⲢⲠⲈ. ⲈⲦⲢⲈϤϢⲈⲦ ⲘⲚⲦⲚⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲦⲂⲎⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ⲠⲀⲒ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲈⲨⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ. ⲀϤⲤⲈⲠⲤⲰⲠⲞⲨ ⲈϮ ⲚⲀϤ ⲚⲞⲨⲘⲚⲦⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲈⲒⲰⲢⲘ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ϬⲰϢⲦ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ⲚⲦⲞϤ ⲆⲈ ⲀϤϬⲰϢⲦ ⲈⲢⲞⲞⲨ ⲈϤⲘⲈⲈⲨⲈ ϪⲈ ⲈϤⲚⲀϪⲒ ⲞⲨⲖⲀⲀⲨ ⲚⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲚ ϨⲀⲦ ⲞⲨⲆⲈ ⲘⲚ ⲚⲞⲨⲂ ϢⲞⲞⲠ ⲚⲀⲒ. ⲠⲈⲦⲈⲞⲨⲚⲦⲀⲒϤ ⲆⲈ ϮⲚⲀⲦⲀⲀϤ ⲚⲀⲔ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ⲀⲨⲰ ⲀϤⲀⲘⲀϨⲦⲈ ⲚⲦⲈϤϬⲒϪ ⲚⲞⲨⲚⲀⲘ ⲀϤⲦⲞⲨⲚⲞⲤϤ. ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲨⲦⲀϪⲢⲞ ⲚϬⲒ ⲚⲈϤϬⲞⲠ ⲀⲨⲰ ⲚⲈϤϮⲂⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ⲀⲨⲰ ⲀϤϤⲞϬϤ ⲀϤⲀϨⲈⲢⲀⲦϤ ⲀϤⲘⲞⲞϢⲈ. ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲚⲘⲘⲀⲨ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ. ⲈϤⲘⲞⲞϢⲈ ⲀⲨⲰ ⲈϤϪⲒϤⲞϬⲤ ⲈϤⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ⲀⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲘⲞⲞϢⲈ ⲀⲨⲰ ⲈϤⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ⲀⲨⲤⲞⲨⲰⲚϤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲚⲈϤϨⲘⲞⲞⲤ ⲀⲨⲰ ⲈϤϢⲈⲦ ⲘⲚⲦⲚⲀ ϨⲒⲢⲚ ⲦⲠⲨⲖⲎ ⲈⲦⲚⲈⲤⲰⲤ ⲚⲦⲈ ⲠⲢⲠⲈ. ⲀⲨⲘⲞⲨϨ ⲚϨⲞⲦⲈ ⲀⲨⲰ ⲀⲨⲠⲰϢⲤ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲪⲰⲂ ⲚⲦⲀϤϢⲰⲠⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ⲈϤⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ. ⲀⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ. ϨⲀ ⲦⲈⲤⲦⲞⲀ ⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲦⲀ ⲤⲞⲖⲞⲘⲰⲚ ⲈⲨϢⲦⲢⲦⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲦⲈ ⲠⲒⲤⲢⲀⲎⲖ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲢϢⲠⲎⲢⲈ ⲈϪⲘ ⲠⲀⲒ ⲎⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲈⲒⲞⲢⲘ ⲚⲤⲰⲚ ϨⲰⲤ ⲚⲦⲀⲚⲢ ⲠⲀⲒ ϨⲚ ⲦⲈⲚϬⲞⲘ ⲎⲦⲈⲚⲘⲚⲦⲈⲨⲤⲈⲂⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ⲠⲚⲞⲨⲦⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲘⲚ ⲒⲤⲀⲀⲔ ⲘⲚ ⲒⲀⲔⲰⲂ ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲀϤϮ ⲈⲞⲞⲨ ⲘⲠⲈϤϢⲎⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲚⲦⲀⲦⲈⲦⲚⲦⲀⲀϤ ⲀⲨⲰ ⲀⲦⲈⲦⲚⲀⲢⲚⲀ ⲘⲘⲞϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲈⲀ ⲠⲈⲦⲘⲘⲀⲨ ⲔⲢⲒⲚⲈ ⲈⲔⲀⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ⲚⲦⲰⲦⲚ ⲆⲈ ⲠⲈⲦⲞⲨⲀⲀⲂ ⲀⲨⲰ ⲠⲆⲒⲔⲀⲒⲞⲤ ⲀⲦⲈⲦⲚⲀⲢⲚⲀ ⲘⲘⲞϤ. ⲀⲦⲈⲦⲚⲀⲒⲦⲒ ⲈⲔⲰ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲚⲞⲨⲢⲰⲘⲈ ⲚⲢⲈϤϨⲰⲦⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ⲠⲀⲢⲬⲒⲄⲞⲤ ⲆⲈ ⲘⲠⲰⲚϨ ⲀⲦⲈⲦⲚⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ⲠⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲠⲀⲒ ⲀⲚⲞⲚ ⲈⲚϢⲞⲞⲠ ⲚⲀϤ ⲘⲘⲚⲦⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ⲀⲨⲰ ϨⲢⲀⲒ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲘⲠⲈϤⲢⲀⲚ ⲠⲀⲒ ⲈⲦⲈⲦⲚⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲰ ⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀϤⲦⲀϪⲢⲞϤ ⲚϬⲒ ⲠⲈϤⲢⲀⲚ ⲀⲨⲰ ⲦⲠⲒⲤⲦⲒⲤ ⲦⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲀⲤϮ ⲚⲀϤ ⲘⲠⲈⲒⲞⲨϪⲀⲒ ⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ⲦⲈⲚⲞⲨ ϬⲈ ⲚⲀⲤⲚⲎⲨ. ϮⲈⲒⲘⲈ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲀⲀⲤ ϨⲚ ⲞⲨⲘⲚⲦⲀⲦⲤⲞⲞⲨⲚ ⲚⲐⲈ ⲚⲚⲈⲦⲚⲔⲈⲀⲢⲬⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚⲚⲈⲚⲦⲀϤϪⲞⲞⲨ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲢⲈ ⲠⲈϤⲬⲢⲎⲤⲦⲞⲤ ϢⲞⲠⲞⲨ. ⲀϤϪⲞⲔⲞⲨ ⲈⲂⲞⲖ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ⲘⲈⲦⲀⲚⲞⲒ ϬⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚⲔⲈⲦⲦⲎⲨⲦⲚ ⲈⲦⲢⲈⲨϤⲰⲦⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ϪⲈⲔⲀⲀⲤ ⲈⲨϢⲀⲚⲈⲒ ⲚϬⲒ ⲚⲈⲞⲨⲞⲈⲒϢ ⲚⲘⲦⲞⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ⲈϤⲈⲦⲚⲚⲞⲞⲨ ⲘⲠⲈⲚⲦⲀⲨⲦⲞϢϤ ⲚⲀⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ⲠⲀⲒ ϨⲀⲠⲤ ⲈⲦⲢⲈϤϢⲰⲠⲈ ϨⲚ ⲦⲠⲈ. ϢⲀϨⲢⲀⲒ ⲈⲚⲈⲞⲨⲞⲈⲒϢ ⲘⲠϪⲰⲔ ⲈⲂⲞⲖ ⲚϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲨ ϪⲒⲚ ⲈⲚⲈϨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ⲘⲰⲨⲤⲎⲤ ⲘⲈⲚ ⲀϤϪⲞⲞⲤ ⲚⲚⲀϨⲢⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲚⲚⲞⲨⲦⲈ ⲚⲀⲦⲞⲨⲚⲈⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲚⲤⲚⲎⲨ ⲚⲦⲀϨⲈ. ⲤⲰⲦⲘ ⲚⲤⲰϤ ⲚϢⲀϪⲈ ⲚⲒⲘ ⲈⲦϤⲚⲀϪⲞⲞⲨ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ⲈⲤⲈϢⲰⲠⲈ ⲆⲈ ⲮⲨⲬⲎ ⲚⲒⲘ ⲈⲦⲈⲚⲤⲚⲀⲤⲰⲦⲘ ⲀⲚ ⲚⲤⲀ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲘⲘⲀⲨ ⲤⲈⲚⲀϤⲞⲦⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲆⲈ ⲞⲚ ⲦⲎⲢⲞⲨ ϪⲒⲚ ⲤⲀⲘⲞⲨⲎⲖ. ⲀⲨⲰ ⲚⲈⲦⲘⲚⲚⲤⲰϤ. ⲀⲨϢⲀϪⲈ ⲀⲨⲰ ⲀⲨⲦⲀϢⲈⲞⲈⲒϢ ⲚⲚⲈⲒϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲈ ⲚϢⲎⲢⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲘⲚ ⲦⲆⲒⲀⲐⲎⲔⲎ ⲦⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲤⲘⲚⲦⲤ ⲘⲚ ⲚⲈⲦⲚⲈⲒⲞⲦⲈ. ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲂⲢⲀϨⲀⲘ ϪⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲔⲤⲠⲈⲢⲘⲀ ⲤⲈⲚⲀϪⲒⲤⲘⲞⲨ ⲚϬⲒ ⲘⲠⲀⲦⲢⲒⲀ ⲦⲎⲢⲞⲨ ⲘⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ⲚⲦⲰⲦⲚ ⲚⲈ ⲚϢⲞⲢⲠ ⲀⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲈⲤ ⲠⲈϤϢⲎⲢⲈ ⲚⲎⲦⲚ. ⲀϤⲦⲚⲚⲞⲞⲨϤ ⲈϤⲤⲘⲞⲨ ⲈⲢⲰⲦⲚ. ϨⲘ ⲠⲦⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲔⲦⲞϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲠⲞⲚⲎⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ⲈⲨϢⲀϪⲈ ⲆⲈ ⲘⲚ ⲠⲘⲎⲎϢⲈ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲚϬⲒ ⲚⲞⲨⲎⲎⲂ ⲘⲚ ⲠⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲚⲦⲈ ⲠⲢⲠⲈ. ⲀⲨⲰ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ⲈⲨⲘⲞⲔϨ ⲚϨⲎⲦ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲨϮⲤⲂⲰ ⲘⲠⲖⲀⲞⲤ. ⲀⲨⲰ ⲚⲈⲨⲦⲀϢⲈⲞⲒϢ ϨⲚ ⲒⲎⲤⲞⲨⲤ ⲚⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ⲀⲨⲰ ⲀⲨⲈⲒⲚⲈ ⲚⲚⲈⲨϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲀⲨⲚⲞϪⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ ϢⲀ ⲠⲈϤⲢⲀⲤⲦⲈ. ⲚⲈⲀ ⲢⲞⲨϨⲈ ⲄⲀⲢ ϢⲰⲠⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ϨⲀϨ ⲆⲈ ⲚⲚⲈⲚⲦⲀⲨⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ. ⲀⲨⲰ ⲀⲦⲈⲨⲎⲠⲈ ⲀⲤⲢⲀϮⲞⲨ ⲚϢⲞ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲈⲦⲢⲈⲨⲤⲰⲞⲨϨ ⲚϬⲒ ⲚⲈⲨⲀⲢⲬⲰⲚ. ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲰ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ⲘⲚⲀⲚⲚⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲔⲀⲒⲪⲀⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲚ ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ. ⲀⲨⲰ ⲚⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲄⲈⲚⲞⲤ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ⲀⲨⲰ ⲀⲨⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ϨⲚ ⲦⲈⲨⲘⲎ ⲦⲈ ⲀⲨϪⲚⲞⲨⲞⲨ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲢ ⲠⲀⲒ ϨⲚ ⲀϢ ⲚϬⲞⲘ. ⲎϨⲚ ⲀϢ ⲚⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ⲦⲞⲦⲈ ⲠⲈⲦⲢⲞⲤ ⲀϤⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ. ϪⲈ ⲚⲀⲢⲬⲰⲚ ⲘⲠⲖⲀⲞⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ⲈϢϪⲈ ⲀⲚⲞⲚ ⲘⲠⲞⲞⲨ ⲤⲈⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲚ ⲈⲦⲂⲈ ⲠⲞⲨϪⲀⲒ ⲚⲞⲨⲢⲰⲘⲈ ⲚϬⲰⲂ ϪⲈ ⲚⲦⲀϤⲞⲨϪⲀⲒ ϨⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ⲘⲀⲢⲈϤⲞⲨⲰⲚϨ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲦⲎⲢⲦⲚ ⲀⲨⲰ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲘⲠⲒⲤⲢⲀⲎⲖ ϪⲈ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲀⲒ ⲘⲈⲚ ⲚⲦⲀⲦⲈⲦⲚⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ ⲀⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲈⲢⲈ ⲠⲀⲒ ⲀϨⲈⲢⲀⲦϤ ⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲈϤⲞⲨⲞϪ. ");
INSERT INTO copshc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ⲠⲀⲒ ⲠⲈ ⲠⲰⲚⲈ ⲚⲦⲀⲨⲤⲦⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲎⲨⲦⲚ ⲚⲈⲦⲔⲰⲦ. ⲠⲀⲒ ⲚⲦⲀϤϢⲰⲠⲈ ⲈⲨⲀⲠⲈ ⲚⲔⲞⲞϨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ⲀⲨⲰ ⲘⲚ ⲞⲨϪⲀⲒ ϢⲞⲞⲠ ϨⲚ ⲔⲈⲞⲨⲀ. ⲞⲨⲆⲈ ⲄⲀⲢ ⲘⲚ ⲔⲈⲢⲀⲚ ϨⲀⲠⲈⲤⲎⲦ ⲚⲦⲠⲈ ⲈⲀⲨⲦⲀⲀϤ ⲚⲚⲢⲰⲘⲈ ⲈⲚⲚⲀϢⲞⲨϪⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ⲈⲨⲚⲀⲨ ⲆⲈ ⲈⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ. ⲀⲨⲈⲒⲘⲈ ϪⲈ ϨⲈⲚⲢⲰⲘⲈ ⲚⲈ ⲚϨⲎⲆⲒⲰⲦⲎⲤ ⲚⲤⲈⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲤϨⲀⲒ. ⲀⲨⲢϢⲠⲎⲢⲈ ⲀⲨⲤⲞⲨⲰⲚⲞⲨ ⲆⲈ ϪⲈ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ⲘⲚ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ⲀⲨⲰ ⲞⲚ ⲚⲈⲨⲚⲀⲨ ⲈⲠⲢⲰⲘⲈ ⲚⲦⲀⲨⲦⲀⲖϬ ⲞϤ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲚⲘⲘⲀⲨ. ⲘⲠⲞⲨϬⲚ ϢⲀϪⲈ ⲈϪⲰ. ");
INSERT INTO copshc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲆⲈ ⲚⲀⲨ ⲈⲦⲢⲈⲨⲢⲠⲂⲞⲖ ⲘⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ⲀⲨϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀⲀⲀϤ ⲚⲚⲈⲒⲢⲰⲘⲈ ϨⲞⲦⲒ ⲘⲈⲚ ⲄⲀⲢ ⲀⲨⲘⲀⲈⲒⲚ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲘⲚ ϢϬⲞⲘ ⲘⲘⲞⲚ ⲈⲀⲢⲚⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈ ⲠϢⲀϪⲈ ⲘⲞⲞϢⲈ ⲈⲠⲈϨⲞⲨⲞ ϨⲘ ⲠⲖⲀⲞⲤ. ⲘⲀⲢⲚⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲨ ⲈⲦⲘϢⲀϪⲈ ϬⲈ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈⲒⲢⲀⲚ. ⲘⲚ ⲖⲀⲀⲨ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ⲀⲨⲰ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲀⲨⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲨ ⲈⲦⲘϢⲀϪⲈⲖⲀⲀⲨ. ⲀⲨⲰ ⲈⲦⲘϮⲤⲂⲰ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ ⲀⲨⲞⲨⲰϢⲂ ⲠⲈϪⲀⲨ ⲚⲀⲨ. ϪⲈ ⲔⲢⲒⲚⲈ ϪⲈ ⲞⲨⲆⲒⲔⲀⲒⲞⲚ ⲠⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲤⲰⲦⲘ ⲚⲤⲀ ⲦⲎⲨⲦⲚ ⲈϨⲞⲨⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ⲀⲚⲞⲚ ⲄⲀⲢ ⲚⲈⲚⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲀⲚⲤⲞⲦⲘⲞⲨ ⲘⲚ ϬⲞⲘ ⲘⲘⲞⲚ ⲈⲦⲘϪⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ⲚⲦⲞⲞⲨ ϬⲈ ⲀⲨⲀⲠⲒⲖⲎ ⲚⲀⲨ ⲀⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ ⲘⲠⲞⲨϬⲚ ⲐⲈ ⲚⲔⲞⲖⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲈⲦⲂⲈ ⲠⲖⲀⲞⲤ. ϪⲈ ⲚⲈⲨϮⲈⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈϪⲘ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ⲚⲈϤϨⲚ ϨⲞⲨⲞ ⲄⲀⲢ ⲈϨⲘⲈ ⲚⲢⲞⲘⲠⲈ ⲚϬⲒ ⲠⲢⲰⲘⲈ ⲚⲦⲀ ⲠⲈⲒⲘⲀⲈⲒⲚ ⲚⲦⲈ ⲠⲦⲀⲖϬⲞ ϢⲰⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ⲚⲦⲈⲢⲞⲨⲔⲀⲀⲨ ⲆⲈ ⲈⲂⲞⲖ. ⲀⲨⲈⲒ ϢⲀ ⲚⲈⲦⲈⲚⲞⲨⲞⲨ ⲚⲈ ⲀⲨⲰ ⲀⲨⲦⲀⲘⲞⲞⲨ ⲈⲚⲈⲚⲦⲀ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ϪⲞⲞⲨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲀⲨϤⲒ ⲚⲦⲈⲨⲤⲘⲎ ⲈϨⲢⲀⲒ ⲈⲠⲚⲞⲨⲦⲈ ϨⲒ ⲞⲨⲤⲞⲠ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ. ⲚⲦⲞⲔ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲦⲀⲔⲦⲀⲘⲒ ⲈⲦⲠⲈ ⲘⲚ ⲠⲔⲀϨ. ⲀⲨⲰ ⲐⲀⲖⲀⲤⲤⲀ ⲘⲚ ⲚⲈⲦⲚϨⲎⲦⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ⲠⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚϬⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲦⲀⲠⲢⲞ ⲘⲠⲈⲚⲈⲒⲰⲦ ⲆⲀⲨⲈⲒⲆ ⲠⲈⲔϨⲘϨⲀⲖ ⲈⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲚϨⲈⲐⲚⲞⲤ ϪⲒⲤⲈ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ⲀⲚⲖⲀⲞⲤ ⲘⲈⲖⲈⲦⲀ ⲚϨⲈⲚⲠⲈⲦϢⲞⲨⲈⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ⲀⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲚϬⲒ ⲚⲈⲢⲢⲰⲞⲨ ⲘⲠⲔⲀϨ ⲀⲨⲰ ⲚⲀⲢⲬⲰⲚ ⲀⲨⲤⲰⲞⲨϨ ⲈⲚⲈⲨⲈⲢⲎⲨ ⲈϮ ⲞⲨⲂⲈ ⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲞⲨⲂⲈ ⲠⲈϤⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ⲀⲨⲤⲰⲞⲨϨ ⲄⲀⲢ ⲚⲀⲘⲈ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲔϢⲎⲢⲈ ⲈⲦⲞⲨⲀⲀⲂ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀⲔⲦⲀϨⲤϤ ⲚϬⲒ ϨⲎⲢⲰⲆⲎⲤ ⲘⲚ ⲠⲞⲚⲦⲒⲞⲤ ⲠⲒⲖⲀⲦⲞⲤ ⲘⲚ ⲚϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲠⲖⲀⲞⲤ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ⲈⲈⲒⲢⲈ ⲚⲚⲈⲚⲦⲀ ⲦⲈⲔϬⲒϪ. ⲀⲨⲰ ⲠⲈⲔϢⲞϪⲚⲈ ⲦⲞϢⲞⲨ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲈⲦⲢⲈⲨϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ⲦⲈⲚⲞⲨ ϬⲈ ⲠϪⲞⲈⲒⲤ ϬⲰϢⲦ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈⲨϬⲰⲚⲦ. ⲀⲨⲰ ⲚⲄϮ ⲐⲈ ⲚⲚⲈⲔϨⲘϨⲀⲖ ϨⲘ ⲠⲀⲢⲢⲎⲤⲒⲀ ⲚⲒⲘ. ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲔϢⲀϪⲈ ");
INSERT INTO copshc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ϨⲘ ⲠⲦⲢⲈⲔⲤⲞⲞⲨⲦⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲔϬⲒϪ. ⲈϨⲈⲚⲦⲀⲖϬⲞ ⲀⲨⲰ ϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ. ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲀⲚ ⲘⲠⲈⲔϢⲎⲢⲈ ⲈⲦⲞⲨⲀⲀⲂ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲤⲞⲠⲤ ⲀⲠⲘⲀ ⲔⲒⲘ ⲈⲚⲈⲨⲤⲞⲞⲨϨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ⲀⲨⲘⲞⲨϨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲀⲨⲰ ⲚⲈⲨⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠⲀⲢⲢⲎⲤⲒⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲈⲨⲞ ⲚⲞⲨϨⲎⲦ ⲚⲞⲨⲰⲦ ⲀⲨⲰ ⲞⲨⲮⲨⲬⲎ ⲚⲞⲨⲰⲦ ⲀⲨⲰ ⲚⲈⲘⲚ ⲖⲀⲀⲨ ϪⲰ ⲘⲘⲞⲤ ⲈⲚⲈⲦϢⲞⲞⲠ ⲚⲀϤ ϪⲈ ⲚⲞⲨⲒ ⲚⲈ ⲀⲖⲖⲀ ⲚⲈⲢⲈ ⲚⲔⲀ ⲚⲒⲘ ϢⲞⲞⲠ ⲚⲀⲨ ϨⲒ ⲞⲨⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ⲀⲨⲰ ϨⲚ ⲞⲨⲚⲞϬ ⲚϬⲞⲘ ⲚⲈⲢⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϮⲚⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ⲀⲨⲰ ⲚⲈⲨⲚ ⲞⲨⲚⲞϬ ⲚⲬⲀⲢⲒⲤ ϢⲞⲞⲠ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ⲚⲈⲘⲚ ⲖⲀⲀⲨ ⲄⲀⲢ ⲚϨⲎⲦⲞⲨ ϢⲀⲀⲦ ⲠⲈ. ⲚⲈⲦⲈ ⲞⲨⲚⲦⲞⲨ ϬⲰⲘ ⲄⲀⲢ ⲘⲘⲀⲨ ϨⲒ ⲎⲒ ⲚⲈⲨϮ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ. ⲈⲨⲈⲒⲚⲈ ⲚⲚⲈⲨⲀⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ⲈⲨⲔⲰ ⲘⲘⲞⲞⲨ ϨⲀⲢⲀⲦⲞⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲀⲨⲰ ⲚⲈⲨϮ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲠⲈⲦϤⲢⲬⲢⲒⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ⲒⲰⲤⲎⲤ ⲆⲈ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲞⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲠⲀⲒ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠϢⲎⲢⲈ ⲘⲠⲤⲞⲠⲤ. ⲞⲨⲖⲈⲨⲈⲒⲦⲎⲤ ⲚⲔⲨⲠⲢⲒⲞⲤ ϨⲘ ⲠⲈϤⲄⲈⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ⲈⲨⲚⲦϤ ⲞⲨⲈⲒⲰϨⲈ ⲘⲘⲀⲨ ⲀϤⲦⲀⲀϤ ⲈⲂⲞⲖ. ⲀϤⲈⲒⲚⲈ ⲘⲠⲈⲬⲢⲎⲘⲀ ⲀϤⲔⲀⲀϤ ϨⲀⲢⲀⲦⲞⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ⲞⲨⲢⲰⲘⲈ ⲆⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲘⲚ ⲤⲀⲠⲠⲒⲢⲀ ⲦⲈϤⲤϨⲒⲘⲈ. ⲀϤϮ ⲞⲨϬⲰⲘ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ⲀⲨⲰ ⲀϤϤⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϤⲀⲤⲞⲨ ⲈⲢⲈ ⲦⲈϤⲔⲈⲤϨⲒⲘⲈ ⲤⲞⲞⲨⲚ. ⲀϤⲈⲒⲚⲈ ⲚⲞⲨⲘⲈⲢⲞⲤ ⲀϤⲔⲀⲀϤ ϨⲀⲢⲀⲦⲞⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲚⲒⲀ. ⲈⲦⲂⲈ ⲞⲨ ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲘⲞⲨϨ ⲘⲠⲈⲔϨⲎⲦ ⲈⲦⲢⲈⲔϪⲒϬⲞⲖ ⲈⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲀⲨⲰ ⲚⲄϤⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲀⲤⲞⲨ ⲘⲠϬⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ⲘⲎ ⲚⲈϤϢⲞⲞⲠ ⲚⲀⲔ ⲀⲚ ⲠⲈ ⲀⲨⲰ ⲚⲦⲈⲢⲈⲔⲦⲀⲀϤ ⲈⲂⲞⲖ ⲚⲈϤϢⲞⲞⲠ ⲀⲚ ⲠⲈ ϨⲀ ⲦⲈⲔⲈⲜⲞⲨⲤⲒⲀ ⲈⲦⲂⲈ ⲞⲨ ⲀⲔⲔⲀ ⲠⲀⲒ ϨⲘ ⲠⲈⲔϨⲎⲦ ⲈⲈⲒⲢⲈ ⲘⲠⲈⲒⲠⲞⲚⲎⲢⲞⲚ ⲚⲦⲀⲔϪⲒϬⲞⲖ ⲀⲚ ⲈⲢⲰⲘⲈ ⲀⲖⲖⲀ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ⲈϤⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲈⲒϢⲀϪⲈ ⲚϬⲒ ⲀⲚⲀⲚⲒⲀⲤ ⲀϤϨⲈ ⲀϤⲘⲞⲨ. ⲀⲨⲰ ⲀⲨⲚⲞϬ ⲚϨⲞⲦⲈ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲆⲈ ⲚϬⲒ ⲚϨⲢϢⲒⲢⲈ ⲀⲨⲔⲞⲞⲤϤ. ⲀⲨⲰ ⲀⲨϪⲒⲦϤ ⲈⲂⲞⲖ ⲀⲨⲦⲞⲘⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲚⲚⲤⲀ ϢⲞⲘⲦⲈ ⲚⲞⲨⲚⲞⲨ. ⲦⲈϤⲤϨⲒⲘⲈ ⲚⲤⲤⲞⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ⲀⲤⲈⲒ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀⲤ ϪⲈ ⲀϪⲒⲤ ⲈⲢⲞⲒ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚϮ ⲠϬⲰⲘ ⲈⲂⲞⲖ ϨⲀ ⲚⲈⲒϨⲞⲘⲚⲦ. ⲚⲦⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲈϨⲈ ϨⲀⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲀⲦⲈⲦⲚϤⲒ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲠⲈⲒⲢⲀⲌⲈ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠϪⲞⲈⲒⲤ. ⲈⲒⲤ ⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲚⲈⲚⲦⲀⲨⲦⲰⲘⲤ ⲘⲠⲞⲨϨⲀⲒ ⲤⲈϨⲒⲢⲘ ⲠⲢⲞ ⲀⲨⲰ ⲤⲈⲚⲀϤⲒⲦⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲤϨⲈ ϨⲀ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲀⲨⲰ ⲀⲤⲘⲞⲨ ⲀⲚϨⲢϢⲒⲢⲈ ⲆⲈ ⲈⲒ ⲈϨⲞⲨⲚ ⲀⲨϨⲈ ⲈⲢⲞⲤ ⲈⲤⲘⲞⲞⲨⲦ ⲀⲨϤⲒⲦⲤ ⲈⲂⲞⲖ ⲀⲨⲦⲞⲘⲤⲤ ϨⲀⲦⲘ ⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ⲀⲨⲚⲞϬ ⲆⲈ ⲚϨⲞⲦⲈ ϢⲰⲠⲈ ⲈϪⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ⲈⲂⲞⲖ ⲆⲈ ϨⲒⲦⲚ ⲚϬⲒϪ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲨϢⲰⲠⲈ ⲚϬⲒ ϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ⲈⲚⲀϢⲰⲞⲨ ϨⲘ ⲠⲖⲀⲞⲤ. ⲀⲨⲰ ⲚⲈⲨϢⲞⲞⲠ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ ϨⲘ ⲠⲢⲠⲈ ϨⲀ ⲦⲈⲤⲦⲞⲀ ⲚⲤⲞⲖⲞⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲘⲠⲈⲖⲀⲀⲨ ⲦⲞⲖⲘⲀ ⲈⲦⲞϬϤ ⲈⲢⲞⲞⲨ. ⲀⲖⲖⲀ ⲚⲈⲢⲈⲠⲖⲀⲞⲤ ϮⲈⲞⲞⲨ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ⲚϨⲞⲨⲞ ⲆⲈ ⲚⲈⲨⲞⲨⲰϨ ⲈⲢⲞⲞⲨ ⲚϬⲒ ⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ. ⲞⲨⲘⲎⲎϢⲈ ⲚⲢⲰⲘⲈ ϨⲒ ⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ϨⲰⲤⲦⲈ ⲚⲤⲈⲈⲒⲚⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦϢⲰⲚⲈ ⲈⲚⲈⲠⲖⲀⲦⲒⲀ. ⲚⲤⲈⲔⲀⲀⲨ ϨⲒ ϨⲈⲚϬⲖⲞϬ ⲘⲚ ϨⲈⲚⲘⲀ ⲚⲚⲔⲞⲦⲔ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈⲠⲈⲦⲢⲞⲤ ⲈⲒ ⲈϤⲚⲎⲨ ⲈⲢⲈ ⲦⲈϤϨⲀⲒⲂⲈⲤ ⲦⲀϨⲈ ⲞⲨⲀ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ⲚⲈϢⲀⲨⲤⲰⲞⲨϨ ⲆⲈ ⲞⲚ ⲚϬⲒ ⲠⲘⲎⲎϢⲈ ⲚⲘⲠⲞⲖⲒⲤ ⲈⲦⲘⲠⲔⲰⲦⲈ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲈⲨⲈⲒⲚⲈ ⲚⲚⲈⲦϢⲰⲚⲈ ⲘⲚ ⲚⲈⲦⲘⲞⲔϨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ. ⲀⲨⲰ ⲚⲈⲨⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲘⲘⲀϤ. ⲀⲨⲰ ⲐⲀⲒⲢⲈⲤⲒⲤ ⲚⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲀⲨⲘⲞⲨϨ ⲚⲔⲰϨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ⲀⲨⲈⲒⲚⲈ ⲚⲚⲈⲨϬⲒϪ ⲈϪⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲚⲞϪⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀϤⲞⲨⲰⲚ ⲚⲚⲢⲞ ⲘⲠⲈϢⲦⲈⲔⲞ ⲚⲦⲈⲨϢⲎ. ⲀϤⲚⲦⲞⲨ ⲈⲂⲞⲖ. ⲠⲈϪⲀϤ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ϪⲈ ⲂⲰⲔ ⲚⲦⲈⲦⲚⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ϨⲘ ⲠⲈⲢⲠⲈ ⲚⲦⲈⲦⲚⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲖⲀⲞⲤ ⲚⲚϢⲀϪⲈ ⲦⲎⲢⲞⲨ ⲘⲠⲈⲒⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲠⲈⲢⲠⲈ ⲘⲠⲚⲀⲨ ⲚϢⲰⲢⲠ ⲀⲨⲰ ⲚⲈⲨϮⲤⲂⲰ ⲀϤⲈⲒ ⲆⲈ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀϤ ⲀⲨⲤⲰⲞⲨϨ ⲘⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲀⲨⲰ ⲚϨⲖⲖⲞ ⲦⲎⲢⲞⲨ ⲚⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲀⲨϪⲞⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ ⲈⲦⲢⲈⲨⲚⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲘⲠⲞⲨϬⲚⲦⲞⲨ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲀⲨⲦⲀⲘⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϨⲈ ⲘⲈⲚ ⲈⲠⲈϢⲦⲈⲔⲞ ⲈϤϢⲞⲦⲘ ϨⲚ ⲰⲢϪ ⲚⲒⲘ. ⲀⲨⲰ ⲚⲀⲚⲞⲨⲢϢⲈ ⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ϨⲒⲢⲚ ⲚⲢⲞ ⲚⲦⲈⲢⲚⲞⲨⲰⲚ ⲆⲈ ⲘⲠⲚϬⲚ ⲖⲀⲀⲨ ⲚϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲈⲒϢⲀϪⲈ ⲚϬⲒ ⲠⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲘⲠⲈⲢⲠⲈ ⲘⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲀⲠⲞⲢⲢⲒ ⲈⲦⲂⲎⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ⲀⲞⲨⲀ ⲆⲈ ⲈⲒ ⲀϤⲦⲀⲘⲞⲞⲨ ϪⲈ ⲈⲒⲤ ⲚⲢⲰⲘⲈ ⲚⲦⲀⲦⲈⲦⲚⲚⲞϪⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ ⲤⲈⲀϨⲈⲢⲀⲦⲞⲨ ϨⲘ ⲠⲈⲢⲠⲈ ⲈⲨϮⲤⲂⲰ ⲘⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ⲦⲞⲦⲈ ⲀϤⲂⲰⲔ ⲚϬⲒ ⲠⲈⲤⲦⲢⲀⲦⲎⲔⲞⲤ ⲘⲚ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨⲚⲦⲞⲨ ⲚϪⲚⲀϨ ⲀⲚ. ⲚⲈⲨⲢϨⲞⲦⲈ ⲄⲀⲢ ϨⲎⲦϤ ⲘⲠⲖⲀⲞⲤ ⲘⲎⲠⲰⲤ ⲚⲤⲈϨⲒ ⲰⲚⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ⲚⲦⲈⲢⲞⲨⲚⲦⲞⲨ ⲆⲈ ⲀⲨⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ⲀⲨⲰ ⲀϤϪⲚⲞⲨⲞⲨ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ϨⲚ ⲞⲨⲠⲀⲢⲀⲄⲄⲈⲖⲒⲀ ⲘⲠⲚⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲎⲦⲚ ⲈⲦⲘϮⲤⲂⲰ ⲈϨⲢⲀⲒ ⲈϪⲘⲠ ⲈⲒⲢⲀⲚ ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲦⲈⲦⲚⲘⲞⲨϨ ⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲦⲈⲦⲚⲤⲂⲰ ⲀⲨⲰ ⲦⲈⲦⲚⲞⲨⲰϢ ⲈⲈⲒⲚⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲚ ⲘⲠⲈⲤⲚⲞϤ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϢϢⲈ ⲈⲤⲰⲦⲘ ⲚⲤⲀ ⲠⲚⲞⲨⲦⲈ ⲈϨⲞⲨⲈ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲀϤⲦⲞⲨⲚⲈⲤ ⲒⲎⲤⲞⲨⲤ. ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲚⲦⲀⲦⲈⲦⲚⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ⲈⲀⲦⲈⲦⲚⲀϢⲦϤ ⲈⲨϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ⲠⲀⲒ ⲀⲠⲚⲞⲨⲦⲈ ϪⲀⲤⲦϤ ⲚⲚⲀⲢⲬⲒⲄⲞⲤ ⲀⲨⲰ ⲚⲤⲰⲦⲎⲢ ϨⲘ ⲠⲈϤⲈⲞⲞⲨ ⲈⲦⲢⲈϤϮ ⲚⲞⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲀⲨⲰ ⲞⲨⲔⲀ ⲚⲞⲂⲈ ⲈⲂⲞⲖ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ⲀⲨⲰ ⲀⲚⲞⲚ ⲚⲈ ⲘⲘⲚⲦⲢⲈ ⲚⲚⲈⲒϢⲀϪⲈ. ⲀⲨⲰ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲀⲠⲚⲞⲨⲦⲈ ⲦⲀⲀϤ ⲚⲚⲈⲦⲤⲰⲦⲘ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨϬⲰⲚⲦ ⲀⲨⲰ ⲀⲨⲞⲨⲈϢ ⲘⲞⲞⲨⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲚϬⲒ ⲞⲨⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲄⲀⲘⲀⲖⲒⲎⲖ. ⲞⲨⲚⲞⲘⲞⲆⲒⲆⲀⲤⲔⲀⲖⲞⲤ ⲈϤⲦⲀⲒⲎⲨ ⲚⲚⲀϨⲢⲘ ⲠⲖⲀⲞⲤ ⲦⲎⲢϤ. ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲢⲠⲂⲞⲖ ⲘⲠⲘⲀ ⲚⲞⲨⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲚⲀϨⲢⲚ ⲚⲀⲢⲬⲰⲚ ⲘⲚ ⲚⲈⲦⲤⲞⲞⲨϨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲦⲈⲠⲒⲤⲢⲀⲎⲖ. ϮϨⲦⲎⲦⲚ ⲈⲢⲰⲦⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲚⲀⲀⲀϤ ⲈⲦⲂⲈ ⲚⲈⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ϨⲀⲐⲎ ⲄⲀⲢ ⲚⲚⲈⲒϨⲞⲞⲨ ⲀϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲐⲈⲨⲦⲀⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲀⲒ ⲚⲦⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϬⲒ ⲀϤⲦⲞⲨϢⲈ ⲚⲢⲰⲘⲈ ⲠⲀⲒ ⲆⲈ ⲀⲨϨⲞⲦⲂⲈϤ ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲚⲤⲰϤ ⲀⲨⲂⲰⲖ ⲈⲂⲞⲖ ⲀⲨϢⲰⲠⲈ ⲈⲨⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ⲘⲚⲚⲤⲀ ⲠⲀⲒ ⲀϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲒⲞⲨⲆⲀⲤ ⲠⲄⲀⲖⲒⲖⲀⲒⲞⲤ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲚⲦⲀⲠⲞⲄⲢⲀⲪⲎ ⲀⲨⲰ ⲀϤⲠⲈϢⲤ ⲞⲨⲖⲀⲞⲤ ⲈⲚⲀϢⲰϤ ϨⲒ ⲠⲀϨⲞⲨ ⲘⲘⲞϤ ⲚⲦⲞϤ ⲆⲈ ϨⲰⲰϤ ⲞⲚ ⲀⲨⲦⲀⲔⲞϤ ⲀⲨⲰ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲚⲤⲰϤ ⲀⲨϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ⲦⲈⲚⲞⲨ ϬⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲤⲀϨⲈ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲚⲚⲈⲒⲢⲰⲘⲈ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲔⲀⲀⲨ. ϪⲈ ⲈϢⲰⲠⲈ ⲠⲈⲒϢⲞϪⲚⲈ ⲎⲠⲈⲒϨⲰⲂ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲚⲢⲰⲘⲈ ⲠⲈ ⲈⲒⲈϤⲚⲀⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ⲈϢⲰⲠⲈ ⲆⲈ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲚⲦⲈⲦⲚ ⲀϢϬⲘϬⲞⲘ ⲀⲚ ⲈⲂⲞⲖϤ ⲈⲂⲞⲖ. ⲘⲎⲠⲰⲤ ⲚϢⲈϬ ⲚⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚϮ ⲞⲨⲂⲈ ⲠⲚⲞⲨⲦⲈ. ⲀⲨⲠⲒⲐⲈ ⲆⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ⲀⲨⲰ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲀⲨϨⲒ ⲞⲨⲈ ⲈⲢⲞⲞⲨ. ⲀⲨⲰ ⲀⲨⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲨ ⲈⲦⲘϢⲀϪⲈ ⲈϪⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲂⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲈⲨⲢⲀϢⲈ ϪⲈ ⲀⲨⲘⲠϢⲀ ⲈⲦⲢⲈⲨⲤⲞϢⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ⲘⲘⲎⲚⲈ ⲆⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲰ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲨⲎⲒ. ⲚⲈⲨⲔⲒⲘ ⲀⲚ ⲈⲨϮⲤⲂⲰ. ⲀⲨⲰ ⲈⲨⲦⲀϢⲈⲞⲒϢ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ϨⲢⲀⲒ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲢⲞⲨⲀϢⲀⲒ ⲚϬⲒ ⲦⲎⲠⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ. ⲀⲨⲔⲢⲘⲢⲘ ϢⲰⲠⲈ ϨⲚ ⲚⲞⲨⲈⲒⲈⲚⲒⲚ ⲈⲚϨⲈⲂⲢⲀⲒⲞⲤ ϪⲈ ⲚⲈⲨⲰⲂϢ ⲘⲘⲞⲞⲨ ⲈⲚⲈⲨⲬⲎⲢⲀ ϨⲚ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲘⲘⲎⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ⲀⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲆⲈ ⲘⲞⲨⲦⲈ ⲈⲠⲘⲎⲎϢⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ⲚϢϢⲈ ⲀⲚ ⲈⲦⲢⲈⲚⲔⲰ ⲚⲤⲰⲚ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲦⲚⲆⲒⲀⲔⲞⲚⲒ ⲈϨⲈⲚⲦⲢⲀⲠⲈⲌⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ⲤⲰⲦⲠ ⲆⲈ ⲚⲈⲤⲚⲎⲨ ⲚⲤⲀϢϤ ⲚⲢⲰⲘⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲈⲨⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲞⲨ ⲈⲨϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ϨⲒ ⲤⲞⲪⲒⲀ. ⲦⲀⲢⲚⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲒⲬⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ⲀⲚⲞⲚ ⲆⲈ ⲚⲦⲚⲤⲢϤⲈ ⲈⲠⲈϢⲖⲎⲖ ⲘⲚ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲘⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ⲀⲠⲈⲒϢⲀϪⲈ ⲢⲀⲚⲀϤ ⲘⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲀⲨⲤⲰⲦⲠ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲞⲨⲢⲰⲘⲈ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲦⲒⲤ ϨⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲘⲚ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲚ ⲠⲢⲞⲬⲞⲢⲞⲤ ⲀⲨⲰ ⲚⲒⲔⲀⲚⲰⲢ ⲘⲚ ⲦⲒⲘⲰⲚ ⲘⲚ ⲠⲀⲢⲘⲈⲚⲀⲤ ⲀⲨⲰ ⲚⲒⲔⲞⲖⲀⲞⲤ ⲞⲨⲠⲢⲞⲤⲎⲖⲨⲦⲞⲤ ⲚⲀⲚⲦⲒⲞⲬⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ⲚⲀⲒ ⲀⲨⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲰ ⲀⲨϢⲖⲎⲖ ⲀⲨⲦⲀⲖⲈ ϬⲒϪ ⲈϪⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ⲠϢⲀϪⲈ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤⲀⲨⲜⲀⲚⲈ. ⲀⲨⲰ ⲚⲈⲤⲀϢⲀⲒ ⲚϬⲒ ⲦⲎⲠⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲘⲀⲦⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲞⲨⲎⲎⲂ ⲚⲈⲨⲤⲰⲦⲘ ⲚⲤⲀ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ⲤⲦⲈⲪⲀⲚⲞⲤ ⲆⲈ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲚⲬⲀⲢⲒⲤ ϨⲒ ϬⲞⲘ ⲚⲈϤⲈⲒⲢⲈ ⲚϨⲈⲚⲚⲞϬ ⲘⲘⲀⲈⲒⲚ ⲀⲨⲰ ϨⲈⲚϢⲠⲎⲢⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲖⲀⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ⲀⲨⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲖⲒⲂⲈⲢⲦⲒⲚⲞⲤ ⲀⲨⲰ ⲚⲔⲨⲢⲎⲚⲀⲒⲞⲤ ⲘⲚ ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲀⲨⲰ ⲚⲈⲂⲞⲖ ϨⲚ ⲦⲔⲒⲖⲒⲔⲒⲀ ⲘⲚ ⲦⲀⲤⲒⲀ ⲈⲨϮⲦⲰⲚ ⲞⲨⲂⲈ ⲤⲦⲈⲪⲀⲚⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ⲀⲨⲰ ⲘⲠⲞⲨϬⲘϬⲞⲘ. ⲈϮ ⲞⲨⲂⲈ ⲦⲤⲞⲪⲒⲀ ⲘⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦϤϢⲀϪⲈ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ⲦⲞⲦⲈ ⲀⲨⲚⲞⲨϪⲈ ⲈϨⲞⲨⲚ ⲚϨⲈⲚⲢⲰⲘⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϤϪⲰ ⲚϨⲈⲚϢⲀϪⲈ ⲚⲞⲨⲀ ⲈϨⲞⲨⲚ ⲈⲘⲰⲨⲤⲎⲤ ⲘⲚ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ⲀⲨⲔⲒⲘ ⲆⲈ ⲈⲠⲖⲀⲞⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ. ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲀⲨⲰ ⲀϤϬⲞⲠϤ ⲀⲨϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ⲀⲨⲰ ⲀⲨⲦⲀϨⲞ ⲈⲢⲀⲦⲞⲨ ⲚϨⲈⲚⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲒⲢⲰⲘⲈ ⲖⲞ ⲀⲚ ⲈϤϪⲰ ⲚϨⲈⲚϢⲀϪⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲘⲚ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ⲀⲚⲤⲰⲦⲘ ⲄⲀⲢ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ. ⲠⲀⲒ ⲠⲈⲦⲚⲀⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲈⲒⲘⲀ. ⲀⲨⲰ ⲚϤϢⲒⲂⲈ ⲚⲚⲤⲰⲚⲦ ⲚⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲦⲀⲀⲨ ⲈⲦⲈⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ⲀⲨⲈⲒⲰⲢⲘ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲚϬⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϨⲘⲞⲞⲤ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ⲀⲨⲰ ⲀⲨⲚⲀⲨ ⲈⲠⲈϤϨⲞ ⲚⲐⲈ ⲘⲪⲞ ⲚⲞⲨⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϬⲒ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈ ⲚⲚⲀⲒⲤⲘⲞⲚⲦ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ⲚⲦⲞϤ ⲆⲈ ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲀⲨⲰ ⲚⲀⲈⲒⲞⲦⲈ ⲤⲰⲦⲘ ⲈⲢⲞⲒ ⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲞⲞⲨ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲚⲈⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ ⲈϤϢⲞⲞⲠ ϨⲚ ⲦⲘⲈⲤⲞⲠⲞⲆⲀⲘⲒⲀ ⲘⲠⲀⲦϤⲞⲨⲰϨ ϨⲚ ⲬⲀⲢⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲔⲔⲀϨ ⲘⲚ ⲦⲈⲔⲤⲨⲄⲄⲈⲚⲒⲀ ⲚⲄⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲔⲀϨ ⲈϮⲚⲀⲦⲤⲀⲂⲞⲔ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ⲦⲞⲦⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲚⲚⲈⲬⲀⲖⲆⲀⲒⲞⲤ ⲀϤⲞⲨⲰϨ ϨⲚ ⲬⲀⲢⲢⲀⲚ ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲘⲚⲚⲤⲀ ⲦⲢⲈ ⲠⲈϤⲈⲒⲰⲦ ⲘⲞⲨ ⲀϤⲠⲞⲞⲚⲈϤ ⲈϨⲢⲀⲒ ⲈⲠⲈⲒⲔⲀϨ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲦⲈⲚⲞⲨ ⲈⲦⲈⲦⲚⲞⲨⲎϨ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ⲀⲨⲰ ⲘⲠϤϮ ⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ⲚⲀϤ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ⲞⲨⲆⲈ ⲞⲨⲦⲀϬⲤⲈ ⲚⲞⲨⲈⲢⲎⲦⲈ. ⲀⲖⲖⲀ ⲀϤⲈⲢⲎⲦ ⲈⲦⲀⲀϤ ⲚⲀϤ ⲈⲨⲀⲘⲀϨⲦⲈ ⲘⲚ ⲠⲈϤⲤⲠⲈⲢⲘⲀ. ⲘⲚⲚⲤⲰⲤ ⲈⲘⲚⲦϤ ϢⲎⲢⲈ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ⲀⲠⲚⲞⲨⲦⲈ ⲆⲈ ϢⲀϪⲈ ⲚⲘⲘⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲔⲤⲠⲈⲢⲘⲀ ⲚⲀⲢⲢⲘⲚϬⲞⲒⲖⲈ ϨⲚ ⲞⲨⲔⲀϨ ⲘⲠⲰϤ ⲀⲚ ⲠⲈ. ⲀⲨⲰ ⲤⲈⲚⲀⲀⲨ ⲚϨⲘϨⲀⲖ ⲚⲤⲈⲘⲞⲔϨⲞⲨ ⲚϤⲦⲞⲨϢⲈ ⲚⲢⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ⲠϨⲈⲐⲚⲞⲤ ⲆⲈ ⲈⲦⲞⲨⲚⲀⲢϨⲘϨⲀⲖ ⲚⲀϤ. ϮⲚⲀⲔⲢⲒⲚⲈ ⲀⲚⲞⲔ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲚϬⲒ ⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲤⲈⲚⲎⲨ ⲈⲂⲞⲖ ⲚⲤⲈϢⲘϢⲈ ⲚⲀⲒ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲒⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ⲀⲨⲰ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨⲆⲒⲀⲐⲎⲔⲎ ⲚⲤⲂⲂⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲀϤϪⲠⲈ ⲒⲤⲀⲀⲔ ⲀϤⲤⲂⲂⲎⲦϤ ϨⲘ ⲠⲘⲈϨϢⲘⲞⲨⲚ ⲚϨⲞⲞⲨ ⲒⲤⲀⲀⲔ ⲆⲈ ⲚⲒⲀⲔⲰⲂ ⲒⲀⲔⲰⲂ ⲆⲈ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲘⲠⲀⲦⲢⲒⲀⲢⲬⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ⲀⲨⲰ ⲘⲠⲀⲦⲢⲒⲀⲢⲬⲎⲤ ⲀⲨⲔⲰϨ ⲈⲒⲰⲤⲎⲪ ⲀⲨⲦⲀⲀϤ ⲈⲂⲞⲖ ϨⲢⲀⲒ ϨⲚ ⲔⲎⲘⲈ. ⲚⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ϢⲞⲞⲠ ⲚⲘⲘⲀϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ⲀⲨⲰ ⲀϤⲚⲀϨⲘⲈϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲐⲖⲒⲮⲒⲤ ⲦⲎⲢⲞⲨ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨⲬⲀⲢⲒⲤ ⲘⲚ ⲞⲨⲤⲞⲪⲒⲀ ⲘⲠⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲪⲀⲢⲀⲰ ⲠⲢⲢⲞ ⲚⲔⲎⲘⲈ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲚⲚⲞϬ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲔⲎⲘⲈ ⲀⲨⲰ ⲈϪⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ⲀⲨϨⲈⲂⲰⲰⲚ ⲆⲈ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲔⲎⲘⲈ ⲦⲎⲢϤ ⲘⲚ ⲬⲀⲚⲀⲀⲚ ⲘⲚ ⲞⲨⲚⲞϬ ⲚⲐⲖⲒⲮⲒⲤ. ⲀⲨⲰ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲚⲈⲨϬⲚ ⲞⲈⲒⲔ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲒⲀⲔⲰⲂ ϪⲈ ⲞⲨⲚ ⲤⲞⲨⲞ ϨⲚ ⲔⲎⲘⲈ. ⲀϤϪⲞⲞⲨ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲚϢⲞⲢⲠ. ");
INSERT INTO copshc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ⲘⲠⲘⲈϨⲤⲈⲠ ⲤⲚⲀⲨ ⲆⲈ ⲀⲒⲰⲤⲎⲪ ⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ⲚⲚⲈϤⲤⲚⲎⲨ. ⲀⲨⲰ ⲀⲪⲀⲢⲀⲰ ⲤⲞⲨⲚ ⲠⲄⲈⲚⲞⲤ ⲚⲒⲰⲤⲎⲪ. ");
INSERT INTO copshc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ⲀϤϪⲞⲞⲨ ⲆⲈ ⲚϬⲒ ⲒⲰⲤⲎⲪ ⲀϤⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲒⲀⲔⲰⲂ ⲠⲈϤⲈⲒⲰⲦ. ⲀⲨⲰ ⲦⲈϤⲤⲨⲄⲄⲈⲚⲒⲀ ⲦⲎⲢⲤ ⲈⲨⲘⲈϨ ϢϤⲈⲦⲎ ⲘⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ⲒⲀⲔⲰⲂ ⲆⲈ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲔⲎⲘⲈ ⲀⲨⲰ ⲀϤⲘⲞⲨ ⲚⲦⲞϤ ⲘⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ⲀⲨⲠⲞⲞⲚⲞⲨ ⲈϨⲢⲀⲒ ⲈⲤⲨⲬⲈⲘ. ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ ϨⲢⲀⲒ ϨⲘ ⲠⲦⲀⲪⲞⲤ ⲚⲦⲀ ⲀⲂⲢⲀϨⲀⲘ ϢⲞⲠϤ ϨⲀ ⲞⲨⲀⲤⲞⲨ ⲚϨⲞⲘⲦ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϢⲎⲢⲈ ⲚⲈⲘⲰⲢ ϨⲚ ⲤⲨⲬⲈⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲈⲞⲨⲞⲈⲒϢ ⲘⲠⲈⲢⲎⲦ. ⲠⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲘⲘⲞϤ ⲚⲀⲂⲢⲀϨⲀⲘ. ⲀⲠⲚⲞⲨⲦⲈ ⲀⲨⲜⲀⲚⲈ ⲘⲠⲖⲀⲞⲤ ⲀⲨⲰ ⲀϤⲀϢⲀⲒ ϨⲚ ⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ϢⲀⲚⲦϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲔⲈⲢⲢⲞ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲔⲎⲘⲈ ⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲒⲰⲤⲎⲪ. ");
INSERT INTO copshc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ⲠⲀⲒ ⲀϤϪⲒϢⲞϪⲚⲈ ⲈⲠⲈⲚⲄⲈⲚⲞⲤ ⲈⲘⲞⲨⲔϨ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲈⲦⲢⲈⲨⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲨϢⲎⲢⲈ ⲈⲦⲘⲦⲀⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ϨⲘ ⲠⲈⲨⲞⲒϢ ⲈⲦⲘⲘⲀⲨ ⲀⲨϪⲠⲈ ⲘⲰⲨⲤⲎⲤ. ⲀⲨⲰ ⲚⲈⲚⲈⲤⲰϤ ⲠⲈ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ⲀⲨⲤⲀⲚⲞⲨϢϤ ⲆⲈ ⲚϢⲞⲘⲚⲦ ⲚⲈⲂⲞⲦ ϨⲘ ⲠⲎⲒ ⲘⲠⲈϤⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ⲚⲦⲈⲢⲞⲨⲚⲞϪϤ ⲆⲈ ⲈⲂⲞⲖ. ⲀⲤϤⲒⲦϤ ⲚϬⲒ ⲦϢⲈⲈⲢⲈ ⲘⲪⲀⲢⲀⲰ. ⲀⲨⲰ ⲀⲤⲤⲀⲚⲞⲨϢϤ ⲚⲀⲤ ⲈⲨϢⲎⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ⲀⲨⲰ ⲀⲨⲠⲀⲒⲆⲈⲨⲈ ⲘⲘⲰⲨⲤⲎⲤ ϨⲚ ⲤⲞⲪⲒⲀ ⲚⲒⲘ ⲚⲚⲢⲘⲚⲔⲎⲘⲈ. ⲀⲨⲰ ⲚⲈϤⲞ ⲚⲆⲨⲚⲀⲦⲞⲤ ϨⲚ ⲚⲈϤϢⲀϪⲈ ⲘⲚ ⲚⲈϤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ⲚⲦⲈⲢⲈ ϨⲘⲈ ⲆⲈ ⲚⲢⲞⲘⲠⲈ ϪⲰⲔ ⲈⲂⲞⲖ ⲚⲀϤ. ⲀⲤⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈϤϨⲎⲦ ⲈϬⲘⲠϢⲒ ⲚⲈ ⲚⲚⲈϤⲤⲚⲎⲨ ⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲞⲨⲀ ⲈⲨϪⲒ ⲘⲘⲞϤ ⲚϬⲞⲚⲤ ⲀϤⲚⲀϨⲘⲈϤ. ⲀⲨⲰ ⲀϤⲈⲒⲢⲈ ⲘⲠⲈⲔⲂⲀ ⲘⲠⲈⲦⲞⲨⲘⲞⲨⲔϨ ⲘⲘⲞϤ. ⲈⲀϤϨⲰⲦⲂ ⲘⲠⲢⲘⲚⲔⲎ ⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ⲚⲈϤⲘⲈⲈⲨⲈ ⲆⲈ ⲠⲈ ϪⲈ ⲤⲈⲚⲀⲈⲒⲘⲈ ⲚϬⲒ ⲚⲈϤⲤⲚⲎⲨ. ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀϮ ⲚⲀⲨ ⲚⲞⲨⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈϤϬⲒϪ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲈⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲞⲚ ⲀϤⲞⲨⲰⲚϨ ⲚⲀⲨ ⲈⲂⲞⲖ ⲈⲨⲘⲒϢⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ⲀⲨⲰ ⲀϤϨⲞⲦⲠⲞⲨ ⲈⲨⲈⲒⲢⲎⲚⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲚⲎⲨ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚϪⲒ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ⲚϬⲞⲚⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ⲠⲈⲦϪⲒ ⲆⲈ ⲘⲠⲈⲦϨⲒⲦⲞⲨⲰϤ ⲚϬⲞⲚⲤ ⲀϤⲦⲞϬⲚⲈϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞⲔ ⲚⲀⲢⲬⲰⲚ ⲀⲨⲰ ⲚⲢⲈϤϮϨⲀⲠ ⲈϨⲢⲀⲒ ⲈϪⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ⲘⲎ ⲈⲔⲞⲨⲰϢ ⲚⲦⲞⲔ ⲈϨⲞⲦⲂⲈⲦ ⲚⲐⲈ ⲚⲦⲀⲔϨⲰⲦⲂ ⲘⲠⲢⲘⲚⲔⲎⲘⲈ ⲚⲤⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ⲘⲰⲨⲤⲎⲤ ⲆⲈ ⲀϤⲠⲰⲦ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲒϢⲀϪⲈ. ⲀⲨⲰ ⲀⲨⲢⲢⲘⲚϬⲞⲒⲖⲈ ϨⲘ ⲠⲔⲀϨ ⲘⲘⲀⲆⲒϨⲀⲘ. ⲀϤϪⲠⲈ ϢⲎⲢⲈ ⲤⲚⲀⲨ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ϨⲘⲈ ⲚⲢⲞⲘⲠⲈ ϪⲰⲔ ⲈⲂⲞⲖ. ⲀϤⲞⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ ⲘⲠⲦⲞⲞⲨ ⲚⲤⲒⲚⲀ ⲚϬⲒ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ϨⲚ ⲞⲨϢⲀϨ ⲚⲔⲰϨⲦ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ⲘⲰⲨⲤⲎⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲀϤⲢϢⲠⲎⲢⲈ ⲘⲪⲞⲢⲀⲘⲀ. ⲈϤⲚⲀϮ ⲠⲈϤⲞⲨⲞⲒ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲚⲀⲨ. ⲀⲦⲈⲤⲘⲎ ⲘⲠϪⲞⲈⲒⲤ ϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲔⲈⲒⲞⲦⲈ. ⲠⲚⲞⲨⲦⲈ ⲚⲀⲂⲢⲀϨⲀⲘ ⲘⲚ ⲒⲤⲀⲀⲔ ⲘⲚ ⲒⲀⲔⲰⲂ. ⲘⲰⲨⲤⲎⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲰⲠⲈ ϨⲚ ⲞⲨⲤⲦⲰⲦ ⲘⲠϤⲦⲞⲖⲘⲀ ⲈϬⲰϢⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀϤ ϪⲈ ⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲦⲞⲞⲨⲈ ⲈⲦⲚⲢⲀⲦⲔ. ⲠⲘⲀ ⲄⲀⲢ ⲈⲦⲔⲀϨⲈⲢⲀⲦⲔ ⲚϨⲎⲦϤ ⲞⲨⲔⲀϨ ⲈϤⲞⲨⲀⲀⲂ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ϨⲚ ⲞⲨⲚⲀⲨ ⲀⲚⲀⲨ ⲈⲠⲘⲔⲀϨ ⲘⲠⲀⲖⲀⲞⲤ ⲈⲦϨⲚ ⲔⲎⲘⲈ. ⲀⲨⲰ ⲀⲒⲤⲰⲦⲘ ⲈⲠⲈⲨⲀϢⲀϨⲞⲘ ⲀⲨⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲚⲀϨⲘⲞⲨ. ⲦⲈⲚⲞⲨ ϬⲈ ⲀⲘⲞⲨ ⲦⲀϪⲞⲞⲨⲔ ⲈϨⲢⲀⲒ ⲈⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ⲠⲀⲒ ⲠⲈ ⲘⲰⲨⲤⲎⲤ ⲚⲦⲀⲨⲀⲢⲚⲀ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲔⲀⲐⲒⲤⲦⲀ ⲘⲘⲞⲔ ⲚⲀⲢⲬⲰⲚ ⲀⲨⲰ ⲚⲢⲈϤϮϨⲀⲠ ⲈϨⲢⲀⲒ ⲈϪⲰⲚ ⲠⲀⲒ ⲀⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲨϤ ⲚⲀⲢⲬⲰⲚ ⲀⲨⲰ ⲚⲢⲈϤⲤⲰⲦⲈ ⲘⲚ ⲦϬⲒϪ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲀϤⲞⲨⲰⲚϨ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲀⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ⲠⲀⲒ ⲠⲈⲚⲦⲀϤⲚⲦⲞⲨ ⲈⲂⲞⲖ ⲈⲀϤⲈⲒⲢⲈ ⲚϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ϨⲚ ⲔⲎⲘⲈ ⲀⲨⲰ ϨⲚ ⲦⲈⲢⲨⲐⲢⲀ ⲐⲀⲖⲀⲤⲤⲀ. ⲀⲨⲰ ϨⲘ ⲠϪⲀⲒⲈ ⲚϨⲘⲈ ⲚⲢⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ⲠⲀⲒ ⲠⲈ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲆⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲦⲞⲨⲚⲈⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲚⲤⲚⲎⲨ ⲚⲦⲀϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ⲠⲀⲒ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ϨⲒ ⲦⲈⲢⲎⲘⲞⲤ ⲘⲚ ⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀϤ ϨⲘ ⲠⲦⲞⲞⲨ ⲚⲤⲒⲚⲀ. ⲀⲨⲰ ⲘⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ. ⲠⲀⲒ ⲠⲈ ⲈⲚⲦⲀϤϪⲒ ⲚϨⲈⲚϢⲀϪⲈ ⲈⲨⲞⲚϨ ⲈⲦⲀⲀⲨ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ⲀⲨⲰ ⲘⲠⲞⲨⲞⲨⲰϢ ⲈⲤⲰⲦⲘ ⲚⲤⲰϤ ⲚϬⲒ ⲚⲈⲚⲈⲒⲞⲦⲈ. ⲀⲖⲖⲀ ⲀⲨⲔⲀⲀϤ ⲚⲤⲰⲞⲨ. ⲈⲀⲨⲔⲞⲦⲞⲨ ϨⲚ ⲚⲈⲨϨⲎⲦ ⲈⲔⲎⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ⲈⲀⲨϪⲞⲞⲤ ⲚⲀⲀⲢⲰⲚ ϪⲈ ⲦⲀⲘⲒⲞ ⲚⲀⲚ ⲚϨⲈⲚⲚⲞⲨⲦⲈ ⲚⲤⲈϪⲒⲘⲞⲈⲒⲦ ϨⲎⲦⲚ ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲠⲀⲒ ⲚⲦⲀϤⲚⲦⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ ⲚⲔⲎⲘⲈ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲀ ⲞⲨ ϢⲰⲠⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ⲀⲨⲰ ⲀⲨⲦⲀⲘⲒⲈ ⲠⲘⲀⲤⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲦⲀⲖⲈ ⲐⲨⲤⲒⲀ ⲈϨⲢⲀⲒ ⲘⲠⲈⲒⲆⲰⲖⲞⲚ. ⲀⲨⲰ ⲀⲨⲈⲨⲪⲢⲀⲚⲈ ϨⲚ ⲚⲈϨⲂⲎⲨⲈ ⲚⲚⲈⲨϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ⲀϤⲔⲦⲞⲞⲨ ⲆⲈ ⲚϬⲒ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲢⲈⲨϢⲘϢⲈ ⲚⲦⲈⲤⲦⲢⲀⲦⲒⲀ ⲚⲦⲠⲈ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϨⲘ ⲠϪⲰⲰⲘⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ϪⲈ ⲘⲎ ⲀⲦⲈⲦⲚⲦⲀⲖⲞ ⲚⲀⲒ ⲈϨⲢⲀⲒ ⲚϨⲚϢⲰⲦ ⲘⲚ ϨⲈⲚⲐⲨⲤⲒⲀ ⲚϨⲘⲈ ⲚⲢⲞⲘⲠⲈ ϨⲚ ⲦⲈⲢⲎⲘⲞⲤ ⲠⲎⲒ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ⲀⲨⲰ ⲀⲦⲈⲦⲚϪⲒ ⲚⲦⲈⲤⲔⲨⲚⲎ ⲘⲘⲞⲖⲞⲬ ⲘⲚ ⲠⲤⲒⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲢⲀⲒⲪⲀⲚ ⲚⲈⲤⲘⲞⲦ ⲚⲦⲀⲦⲈⲦⲚⲦⲀⲘⲒ ⲞⲞⲨ ⲈⲞⲨⲰϢⲦ ⲚⲀⲨ ⲀⲨⲰ ϮⲚⲀⲠⲚⲚⲈ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲈⲠⲒⲤⲀ ⲚⲦⲂⲀⲂⲨⲖⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ⲦⲈⲤⲔⲎⲚⲎ ⲘⲠⲘⲚⲦⲢⲈ ⲚⲈⲤϢⲞⲞⲠ ⲘⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ ϨⲒ ⲠϪⲀⲒⲈ. ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚϬⲒ ⲠⲈⲦϢⲀϪⲈ ⲘⲚ ⲘⲰⲨⲤⲎⲤ ⲈⲦⲀⲘⲒ ⲞⲤ. ⲔⲀⲦⲀ ⲠⲦⲨⲠⲞⲤ ⲚⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ⲦⲀⲒ ⲚⲦⲀ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲈⲀⲨⲈⲒ ⲘⲚⲚⲤⲀ ⲚϢⲞⲢⲠ ϪⲒⲦⲤ ⲈϨⲞⲨⲚ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ϨⲘ ⲠⲀⲘⲀϨⲦⲈ ⲚⲚϨⲈⲐⲚⲞⲤ. ⲚⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ϨⲀⲐⲎ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ϢⲀϨⲢⲀⲒ ⲈⲚⲈϨⲞⲞⲨ ⲚⲆⲀⲨⲈⲒⲆ. ");
INSERT INTO copshc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ⲠⲀⲒ ⲚⲦⲀϤϨⲈ ⲈⲨⲬⲀⲢⲒⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲀϤⲀⲒⲦⲒ ⲈϬⲒⲚⲈ ⲚⲞⲨⲘⲀ ⲚϢⲰⲠⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ⲤⲞⲖⲞⲘⲰⲚ ⲆⲈ ⲀϤⲔⲰⲦ ⲚⲀϤ ⲚⲞⲨⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ⲀⲖⲖⲀ ⲘⲈⲢⲈ ⲠⲈⲦϪⲞⲤⲈ ⲞⲨⲰϨ ϨⲚ ⲦⲀⲘⲒⲞ ⲚϬⲒϪ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ϪⲈ ⲦⲠⲈ ⲠⲈ ⲠⲀⲐⲢⲞⲚⲞⲤ ⲠⲔⲀϨ ⲠⲈ ⲠϨⲨⲠⲞⲠⲞⲆⲒⲞⲚ ⲚⲚⲀⲞⲨⲈⲢⲎⲦⲈ. ⲀϢ ⲚⲎⲒ ⲠⲈⲦⲈⲦⲚⲀⲔⲞⲦϤ ⲚⲀⲒ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ. ⲎⲀϢ ⲠⲈ ⲠⲀⲘⲀ ⲚⲘⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ⲘⲎ ⲚⲦⲀϬⲒϪ ⲀⲚ ⲦⲈⲚⲦⲀⲤⲦⲀⲘⲒⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ⲚⲚⲀϢⲦⲘⲀⲔϨ ⲀⲨⲰ ⲚⲀⲦⲤⲂⲂⲈ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲘⲚ ⲚⲈⲨⲘⲀⲀϪⲈ. ⲚⲦⲰⲦⲚ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲈⲦⲈⲦⲚϮ ⲞⲨⲂⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲐⲈ ⲚⲚⲈⲦⲚⲈⲒⲞⲦⲈ ⲦⲀⲒ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ⲚⲒⲘ ⲚⲚⲈ ⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲦⲈⲘⲠⲈ ⲚⲈⲦⲚⲈⲒⲞⲦⲈ ⲠⲰⲦ ⲚⲤⲰⲞⲨ ⲚⲤⲈⲘⲞⲞⲨⲦⲞⲨ ⲚⲀⲒ ⲚⲦⲀⲨⲦⲀϢⲈⲞⲒϢ ⲘⲠⲆⲒⲔⲀⲒⲞⲤ ϪⲈ ϤⲚⲎⲨ ⲠⲀⲒ ⲚⲦⲰⲦⲚ ⲦⲈⲚⲞⲨ ⲚⲦⲀⲦⲈⲦⲚϢⲰⲠⲈ ⲚⲀϤ ⲘⲠⲢⲞⲆⲞⲦⲎⲤ ⲀⲨⲰ ⲚⲢⲈϤϨⲰⲦⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ⲚⲀⲒ ⲚⲦⲀⲦⲈⲦⲚϪⲒ ⲘⲠⲚⲞⲘⲞⲤ ⲈϨⲈⲚⲆⲒⲀⲦⲀⲄⲎ ⲚⲀⲄⲄⲈⲖⲞⲤ. ⲀⲨⲰ ⲘⲠⲈⲦⲚϨⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ⲈⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲨϬⲰⲚⲦ ⲚⲚⲈⲨϨⲎⲦ. ⲀⲨⲰ ⲀⲨϨⲢⲞϪⲢⲈϪ ⲚⲚⲈⲨⲞⲂϨⲈ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ⲈϤϪⲎⲔ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲀϤⲈⲒⲰⲢⲘ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲀϤⲚⲀⲨ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲒⲎⲤⲞⲨⲤ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ⲠⲈϪⲀϤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲀⲨ ⲈⲘⲠⲎⲨⲈ ⲈⲨⲞⲨⲎⲚ. ⲀⲨⲰ ⲠϢⲎⲢⲈ ⲘⲠⲢⲰⲘⲈ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲚⲤⲀⲞⲨⲚⲀⲘ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ⲠⲖⲀⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲈⲚⲀⲒ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ. ⲀⲨϮⲦⲞⲞⲦⲞⲨ ⲈⲢⲚ ⲚⲈⲨⲘⲀⲀϪⲈ ⲀⲨⲰ ⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ϨⲒ ⲞⲨⲤⲞⲠ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ⲀⲨⲚⲞϪϤ ⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ ⲀⲨϨⲒⲰⲚⲈ ⲈⲢⲞϤ. ⲀⲨⲰ ⲘⲘⲚⲦⲢⲈ ⲀⲨⲔⲰ ⲈϨⲢⲀⲒ ⲚⲚⲈⲨϨⲞⲒ ⲦⲈ ϨⲀⲢⲀⲦϤ ⲚⲞⲨϨⲢϢⲒⲢⲈ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ⲀⲨⲰ ⲀⲨϨⲒⲰⲚⲈ ⲈⲤⲦⲈⲪⲀⲚⲞⲤ. ⲈϤⲈⲠⲒⲔⲀⲖⲈⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϢⲈⲠ ⲠⲀⲠⲚⲈⲨⲘⲀ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ⲀϤⲔⲰⲖϪ ⲆⲈ ⲚⲚⲈϤⲠⲀⲦ ⲀϤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲘⲠⲢⲰⲠ ⲈⲢⲞⲞⲨ ⲘⲠⲈⲒⲚⲞⲂⲈ. ⲚⲦⲈⲢⲈϤϪⲈ ⲠⲀⲒ ⲆⲈ ⲀϤⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈϤⲤⲨⲚⲈⲨⲆⲞⲔⲒ ⲠⲈ ⲈⲠⲈϤϨⲰⲦⲂ. ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲠⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲞⲨⲐⲖⲒⲮⲒⲤ ⲘⲚ ⲞⲨⲚⲞϬ ⲚⲆⲒⲰⲄⲘⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲘ ⲀⲨϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲈⲚⲈⲬⲰⲢⲀ ⲚϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ϢⲀⲦⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲀⲨⲀⲀⲨ ⲈⲀⲨϬⲰ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ⲀⲨⲔⲰⲰⲤ ⲆⲈ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲚϬⲒ ϨⲈⲚⲢⲰⲘⲈ ⲚⲢⲈϤⲢϨⲞⲦⲈ ⲈⲀⲨⲈⲒⲢⲈ ⲚⲞⲨⲚⲞϬ ⲚⲚⲈϨⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈϤϢⲰϤ ⲠⲈ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲈϤⲂⲎⲔ ⲈϨⲞⲨⲚ ⲈⲚⲎⲒ ⲈϤⲤⲰⲔ ⲈⲂⲞⲖ ⲚⲚⲢⲰⲘⲈ ⲘⲚ ⲚⲈϨⲒⲞⲘⲈ ⲈϤⲚⲞⲨϪⲈ ⲘⲘⲞⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ⲀⲨⲘⲞⲞϢⲈ ⲈⲨⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠϢⲀϪⲈ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲨⲠⲞⲖⲒⲤ ⲚⲦⲈ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲀϤⲔⲎⲢⲨⲤⲤⲈ ⲚⲀⲨ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲈⲚⲈⲨϮ ⲚϨⲦⲎⲨ ϨⲒ ⲞⲨⲤⲞⲠ ⲈⲚⲈⲦⲈⲢⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲰ ⲘⲘⲞⲞⲨ. ϨⲘ ⲠⲦⲢⲈⲨⲤⲰⲦⲘ ⲈⲢⲞϤ ⲀⲨⲰ ⲚⲤⲈⲚⲀⲨ ⲈⲘⲘⲀⲈⲒⲚ ⲈⲚⲈϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ϨⲀϨ ⲄⲀⲢ ⲚⲚⲈⲦⲈⲢⲈ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ϨⲒⲰⲞⲨ. ⲚⲈⲨⲰϢ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲞⲚ ⲈⲨⲤⲎϬ ⲀⲨⲰ ⲚϬⲀⲖⲈ ⲀϤⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ⲞⲨⲚⲞϬ ⲚⲢⲀϢⲈ ⲀϤϢⲰⲠⲈ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ ⲈϤⲢϨⲒⲔ. ⲀⲨⲰ ⲈϤⲠⲰϢⲤ ⲘⲠϨⲈⲐⲚⲞⲤ ⲚⲦⲤⲀⲘⲀⲢⲒⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ⲀⲨⲰ ⲚⲈⲨϮ ⲚϨⲦⲎⲨ ⲈⲢⲞϤ ⲦⲎⲢⲞⲨ ϪⲒⲚ ⲠⲈⲨⲔⲞⲨⲒ ϢⲀ ⲠⲈⲨⲚⲞϬ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲦⲚⲞϬ ⲚϬⲞⲘ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ⲚⲈⲨⲠⲢⲞⲤⲈⲬⲈ ⲆⲈ ⲈⲢⲞϤ. ⲈⲂⲞⲖ ϪⲈ ⲀϤⲢⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲒϢ ⲈϤⲠⲰϢⲤ ⲘⲘⲞⲞⲨ ϨⲚ ⲘⲘⲚⲦⲘⲀⲄⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲈϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲘⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲚϬⲒ ⲚⲢⲰⲘⲈ ⲀⲨⲰ ⲚⲈϨⲒⲞⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ⲤⲒⲘⲰⲚ ϨⲰⲰϤ ⲞⲚ ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲈϤⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲈϤⲚⲀⲨ ⲆⲈ ⲈϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚⲚⲞϬ ⲚϬⲞⲘ ⲈϤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀϤⲠⲰϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϪⲈ ⲀⲦⲤⲀⲘⲀⲢⲒⲀ ϢⲰⲠ ⲈⲢⲞⲤ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨϪⲞⲞⲨ ϢⲀⲢⲞⲞⲨ ⲘⲠⲈⲦⲢⲞⲤ ⲘⲚ ⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ⲚⲀⲒ ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲀⲨϢⲖⲎⲖ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϪⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ⲚⲈⲘⲠⲀⲦϤⲈⲒ ⲄⲀⲢ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲖⲀⲀⲨ ⲘⲘⲞⲞⲨ. ⲀⲖⲖⲀ ⲚⲦⲀⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲀⲦⲈ ⲈⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ⲦⲞⲦⲈ ⲀⲨⲦⲀⲖⲈ ϬⲒϪ ⲈϪⲰⲞⲨ ⲀⲨϪⲒ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲤⲒⲘⲰⲚ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲦⲀⲖⲞ ⲚⲚϬⲒϪ ⲚⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲨϮ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ⲀϤⲈⲒⲚⲈ ⲚⲀⲨ ⲚϨⲈⲚⲬⲢⲎⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀ ⲚⲀⲒ ϨⲰ ⲚⲦⲈⲒ ⲈⲜⲞⲨⲤⲒⲀ. ϪⲈⲔⲀⲀⲤ ⲠⲈϮⲚⲀⲦⲀⲖⲈ ϬⲒϪ ⲈϪⲰϤ ⲈϤⲈϪⲒ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈⲔϨⲀⲦ ⲈϤⲈϢⲰⲠⲈ ⲚⲘⲘⲀⲔ ⲈⲠⲦⲀⲔⲞ. ϪⲈ ⲀⲔⲘⲈⲈⲨⲈ ϪⲈ ⲦⲆⲰⲢⲈⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲈϢⲀⲨϪⲠⲞⲤ ϨⲒⲦⲚ ϨⲈⲚⲬⲢⲎⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ⲘⲚ ⲘⲈⲢⲒⲤ ⲞⲨⲆⲈ ⲘⲚ ⲔⲖⲎⲢⲞⲤ ϢⲞⲞⲠ ⲚⲀⲔ ϨⲘ ⲠⲈⲒϢⲀϪⲈ. ⲘⲠⲈⲔϨⲎⲦ ⲄⲀⲢ ⲤⲞⲨⲦⲰⲚ ⲀⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ⲘⲈⲦⲀⲚⲞⲒ ϬⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲔⲔⲀⲔⲒⲀ ⲚⲄⲤⲞⲠⲤ ⲘⲠϪⲞⲈⲒⲤ. ⲈϢⲰⲠⲈ ⲤⲈⲚⲀⲔⲰ ⲚⲀⲔ ⲈⲂⲞⲖ ⲘⲠⲘⲈⲈⲨⲈ ⲘⲠⲈⲔϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ϮⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲞⲔ ⲈⲔϢⲞⲞⲠ ϨⲚ ⲞⲨⲬⲞⲖⲎ ⲘⲠⲈⲔⲢⲒⲀ. ⲀⲨⲰ ⲞⲨⲘⲢⲢⲈ ⲚϪⲒ ⲚϬⲞⲚⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲤⲒⲘⲰⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲞⲠⲤ ⲚⲦⲰⲦⲚ ⲘⲠϪⲞⲈⲒⲤ ϨⲀⲢⲞⲒ ϪⲈⲔⲀⲀⲤ ⲚⲚⲈ ⲖⲀⲀⲨ ⲚⲚⲈⲚⲦⲀⲦⲈⲦⲚϪⲞⲞⲨ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲢⲘⲚⲦⲢⲈ ⲘⲠⲘⲎⲎϢⲈ ⲀⲨⲰ ⲀⲨϪⲰ ⲈⲢⲞⲞⲨ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ⲞⲨⲘⲎⲎϢⲈ ⲚϮⲘⲈ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲀⲨⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀϤϢⲀϪⲈ ⲘⲚ ⲪⲒⲖⲒⲠⲠⲞⲤ. ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲘⲞⲞϢⲈ ⲘⲠⲚⲞⲨ ⲘⲘⲈⲈⲢⲈ. ϨⲒ ⲦⲈϨⲒⲎ ⲈⲦⲞ ⲚⲈⲢⲎⲘⲞⲤ ⲈⲦⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈϨⲢⲀⲒ ⲈⲄⲀⲌⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲂⲰⲔ ⲀⲨⲰ ⲈⲒⲤ ⲞⲨⲢⲰⲘⲈ ⲚⲈϬⲰϢ ⲚⲤⲒⲞⲨⲢ ⲚⲆⲨⲚⲀⲤⲦⲎⲤ ⲚⲦⲈ ⲔⲀⲚⲆⲀⲔⲎ ⲦⲢⲢⲰ ⲚⲚⲈϬⲞⲞϢ ⲠⲀⲒ ⲈⲚⲈϤϢⲞⲞⲠ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈⲤⲬⲢⲎⲘⲀ ⲦⲎⲢⲞⲨ ⲚⲈⲀϤⲈⲒ ⲠⲈ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲞⲨⲰϢⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ⲚⲦⲈⲢⲈϤⲔⲦⲞϤ ⲆⲈ ⲚⲈϤϨⲘⲞⲞⲤ ϨⲒ ⲠⲈϤϨⲀⲢⲘⲀ. ⲈϤⲰϢ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ⲠⲈϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ϮⲠⲈⲔⲞⲨⲞⲒ ⲚⲄⲦⲞϬⲔ ⲈⲠⲈⲒϨⲀⲢⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲚϬⲒ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲀϤⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈϤⲰϢ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲠⲈϪⲀϤ ⲘⲠⲈⲤⲒⲞⲨⲢ ϪⲈ ⲀⲢⲀ ⲔⲚⲞⲒ ⲚⲚⲈⲦⲔⲰϢ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ϮⲚⲀϢϬⲘϬⲞⲘ ⲈⲒⲘⲎⲦⲒ ⲚⲦⲈ ⲞⲨⲀ ⲦⲤⲈⲂⲈ ⲈⲒⲀⲦ ⲈⲂⲞⲖ. ⲀϤⲤⲈⲠⲤ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲈⲦⲢⲈϤⲀⲖⲈ ⲚϤϨⲘⲞⲞⲤ ϨⲒⲦⲞⲨⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ⲠⲘⲀ ⲆⲈ ⲚⲦⲈⲄⲢⲀⲪⲎ ⲈⲚⲈϤⲰϢ ⲘⲘⲞϤ ⲠⲈ ⲠⲀⲒ ⲚⲐⲈ ⲚⲞⲨⲈⲤⲞⲞⲨ ⲈⲀⲨⲚⲦϤ ⲈⲔⲞⲚⲤϤ ⲀⲨⲰ ⲚⲐⲈ ⲚⲞⲨϨⲒⲈⲒⲂ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲈⲦϨⲰⲰⲔⲈ ⲘⲘⲞϤ ⲈⲚϤϮ ⲀⲚ ⲚⲦⲈϤⲤⲘⲎ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠϤⲞⲨⲰⲚ ⲚⲢⲰϤ ");
INSERT INTO copshc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ϨⲘ ⲠⲈϤⲐⲂⲂⲒⲞ ⲀⲨϤⲒ ⲘⲠⲈϤϨⲀⲠ ⲦⲈϤⲄⲈⲚⲈⲀ ⲚⲒⲘ ⲠⲈⲦⲚⲀϢⲦⲀⲨⲞⲤ ϪⲈ ⲤⲈⲚⲀϤⲒ ⲘⲠⲈϤⲰⲚϨ ⲈⲂⲞⲖ ϨⲒϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ⲀϤⲞⲨⲰϢⲂ ⲚϬⲒ ⲠⲈⲤⲒⲞⲨⲢ ⲠⲈϪⲀϤ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ. ⲀϪⲒⲤ ⲈⲢⲞⲒ ϪⲈ ⲈⲢⲈ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲰ ⲘⲠⲀⲒ ⲈⲦⲂⲈ ⲚⲒⲘ. ⲈⲦⲂⲎⲎⲦϤ ϪⲚ ⲈⲦⲂⲈ ⲔⲈⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ⲀⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲞⲨⲰⲚ ⲚⲢⲰϤ ⲈⲀϤⲀⲢⲬ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲒⲄⲢⲀⲪⲎ. ⲀϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲀϤ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ⲈⲨⲘⲞⲞϢⲈ ⲆⲈ ϨⲒ ⲦⲈϨⲒⲎ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲘⲞⲞⲨ. ⲠⲈϪⲈ ⲠⲈⲤⲒⲞⲨⲢ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ⲈⲒⲤ ⲠⲘⲞⲞⲨ ⲞⲨ ⲠⲈⲦⲔⲰⲖⲨ ⲘⲘⲞⲒ ⲈⲦⲢⲀϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","— ");
INSERT INTO copshc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚϬⲒ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲈⲦⲢⲈ ⲠϨⲀⲢⲘⲀ ⲀϨⲈⲢⲀⲦϤ. ⲀⲨⲂⲰⲔ ⲘⲠⲈⲤⲚⲀⲨ ⲈϨⲢⲀⲒ ⲈⲠⲘⲞⲞⲨ. ⲀⲨⲰ ⲀⲪⲒⲖⲒⲠⲠⲞⲤ ⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ϨⲘ ⲠⲘⲞⲞⲨ. ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ ⲀϤⲦⲰⲢⲠ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ. ⲀⲨⲰ ⲘⲠϤⲔⲞⲦϤ ⲈⲚⲀⲨ ⲈⲢⲞϤ ⲚϬⲒ ⲠⲈⲤⲒⲞⲨⲢ ⲚⲈϤⲘⲞⲞϢⲈ ⲄⲀⲢ ⲠⲈ ⲚⲦⲈϤϨⲒⲎ ⲈϤⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲀⲨϨⲈ ⲈⲢⲞϤ ϨⲚ ⲀⲌⲰⲦⲞⲤ. ⲀⲨⲰ ⲈϤⲘⲞⲞϢⲈ ⲈϤⲦⲀϢⲈⲞⲈⲒϢ ⲚⲘⲠⲞⲖⲒⲤ ⲦⲎⲢⲞⲨ. ϢⲀⲚⲦϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲒ ⲚⲈϤⲘⲈϨ ⲚⲀⲠⲒⲖⲎ ϨⲒ ϨⲰⲦⲂ ⲈϨⲞⲨⲚ ⲈⲘⲘⲀⲐⲎⲦⲎⲤ ⲘⲠϪⲞⲈⲒⲤ. ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲈⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ⲀϤⲀⲒⲦⲒ ⲈⲂⲞⲖ ⲚϨⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ. ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ϢⲀ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ϪⲈⲔⲀⲀⲤ ⲚⲈⲦϤⲚⲀϨⲈ ⲈⲢⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϨⲒⲎ ⲚⲢⲰⲘⲈ ⲀⲨⲰ ⲚⲈϨⲒⲞⲘⲈ. ⲈϤⲈϪⲒⲦⲞⲨ ⲈⲨⲘⲎⲢ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈϤⲘⲞⲞϢⲈ ⲚⲦⲈⲢⲈϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ϨⲚ ⲞⲨϢⲤⲚⲈ ⲀⲨⲞⲨⲞⲈⲒⲚ ϢⲀ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ ⲀϤⲤⲰⲦⲘ ⲈⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ. ϪⲈ ⲤⲀⲨⲖⲈ ⲤⲀⲨⲖⲈ ⲀϨⲢⲞⲔ ⲔⲠⲎⲦ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ⲚⲦⲔ ⲚⲒⲘ ⲠϪⲞⲈⲒⲤ. ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲆⲈ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲔⲠⲎⲦ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ⲀⲖⲖⲀ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ. ⲀⲨⲰ ⲤⲈⲚⲀⲦⲀⲘⲞⲔ ϪⲈ ⲞⲨ ⲠⲈⲦⲈϢϢⲈ ⲈⲢⲞⲔ ⲈⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ⲚⲢⲰⲘⲈ ⲆⲈ ⲈⲦⲘⲞⲞϢⲈ ⲚⲘⲘⲀϤ ⲚⲈⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲈⲨⲞⲚϢ. ⲚⲈⲨⲤⲰⲦⲘ ⲘⲈⲚ ⲈⲦⲈⲤⲘⲎ ⲚⲤⲈⲚⲞⲒ ⲀⲚ. ⲚⲈⲨⲚⲀⲨ ⲄⲀⲢ ⲀⲚ ⲈⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒϪⲘ ⲠⲔⲀϨ ⲈⲢⲈ ⲚⲈϤⲂⲀⲖ ⲆⲈ ⲞⲨⲎⲚ ⲚⲈϤⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲚ. ⲀⲨϪⲒⲘⲞⲈⲒⲦ ⲆⲈ ϨⲎⲦϤ ⲀⲨϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ⲀϤⲢ ϢⲞⲘⲚⲦ ⲆⲈ ⲚϨⲞⲞⲨ ⲈⲚϤⲚⲀⲨ ⲀⲚ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲘⲠϤⲞⲨⲰⲘ ⲞⲨⲆⲈ ⲘⲠϤⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ⲚⲈⲨⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲚⲀⲚⲒⲀⲤ. ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀϤ ϨⲚ ⲞⲨϨⲞⲢⲞⲘⲀ ϪⲈ ⲀⲚⲀⲚⲒⲀ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ ⲈⲪⲒⲢ ⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲤⲞⲨⲦⲰⲚ. ⲚⲄϢⲒⲚⲈ ϨⲘ ⲠⲎⲒ ⲚⲒⲞⲨⲆⲀⲤ ⲚⲤⲀ ⲞⲨⲢⲘⲦⲀⲢⲤⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲀⲨⲖⲞⲤ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲄⲀⲢ ⲚⲦⲞϤ ⲈϤϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ⲀϤⲚⲀⲨ ⲈⲨⲢⲰⲘⲈ ϪⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲈⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲀϤⲦⲀⲖⲈ ⲦⲞⲞⲦϤ ⲈϪⲰϤ ϪⲈ ⲈϤⲈⲚⲀⲨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲀⲚⲀⲚⲒⲀⲤ ⲠⲈϪⲀϤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲀⲒⲤⲰⲦⲘ ⲚⲦⲚ ϨⲀϨ ⲈⲦⲂⲈ ⲠⲈⲒⲢⲰⲘⲈ. ϪⲈ ⲀϤⲢϨⲀϨ ⲘⲠⲈⲐⲞⲞⲨ ⲚⲚⲈⲔⲠⲈⲦⲞⲨⲀⲀⲂ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ⲀⲨⲰ ⲞⲚ ⲀϤϪⲒ ⲈⲜⲞⲨⲤⲒⲀ ⲘⲠⲈⲒⲘⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲘⲞⲨⲢ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀϤ ϪⲈ ⲂⲰⲔ ϪⲈ ⲠⲀⲒ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲚⲀⲒ ⲚⲤⲰⲦⲠ ⲠⲈ. ⲈⲦⲢⲈϤϤⲒ ϨⲀ ⲠⲀⲢⲀⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚϨⲈⲐⲚⲞⲤ ⲘⲚ ⲚⲈⲢⲢⲰⲞⲨ ⲘⲚ ⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ⲀⲚⲞⲔ ⲄⲀⲢ ϮⲚⲀⲦⲀⲘⲞϤ ⲈⲚϨⲒⲤⲈ ⲈⲦϤⲚⲀϢⲞⲠⲞⲨ ϨⲀ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ⲀϤⲘⲞⲞϢⲈ ⲆⲈ ⲚϬⲒ ⲀⲚⲀⲚⲒⲀⲤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲀϤⲦⲀⲖⲈ ⲚⲈϤϬⲒϪ ⲈϪⲚ ⲤⲀⲨⲖⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ⲤⲀⲨⲖⲈ ⲠⲀⲤⲞⲚ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨⲦ ⲠⲀⲒ ⲚⲦⲀϤⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲈϨⲒⲎ ⲈⲦⲔⲚⲎⲨ ⲘⲘⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲰ ⲚⲄⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲨϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤⲂⲀⲖ ⲚⲐⲈ ⲚϨⲈⲚϨⲂⲤ. ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲂⲞⲖ. ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲞⲨⲰⲘ ⲀϤϬⲘϬⲞⲘ. ⲀϤϢⲰⲠⲈ ⲆⲈ ⲘⲚ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲦϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲚϨⲈⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲔⲎⲢⲨⲤⲤⲈ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ. ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ⲀⲨⲠⲰϢⲤ ⲆⲈ ⲚϬⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲢⲞϤ ⲀⲨⲰ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠⲀⲒ ⲀⲚ ⲠⲈ ⲈⲚⲦⲀϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚⲚⲈⲦⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲈⲒⲢⲀⲚ ⲀⲨⲰ ⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨϤ ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲠⲈⲒⲘⲀ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϪⲒⲦⲞⲨ ⲈⲨⲘⲎⲢ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈϤϬⲘϬⲞⲘ ⲚϨⲞⲨⲞ. ⲀⲨⲰ ⲈϤϢⲦⲞⲢⲦⲢ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲈϤⲦⲀⲘⲞ ⲘⲘⲞⲞⲨ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ⲚⲦⲈⲢⲈ ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲚϨⲞⲞⲨ ϪⲰⲔ ⲈⲂⲞⲖ. ⲀⲨϪⲒϢⲞϪⲚⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈϨⲞⲦⲂⲈϤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ⲀⲨⲦⲀⲘⲈ ⲤⲀⲨⲖⲞⲤ ⲈⲠⲈⲨϢⲞϪⲚⲈ. ⲚⲈⲨϨⲀⲢⲈϨ ⲆⲈ ⲈⲘⲠⲨⲖⲎ ⲘⲠⲈϨⲞⲞⲨ ⲘⲚ ⲦⲈⲨϢⲎ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ⲀⲨϪⲒⲦϤ ⲆⲈ ⲚϬⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲬⲀⲖⲀ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲤⲞⲂⲦ ϨⲚ ⲞⲨⲂⲒⲢ ⲚⲦⲈⲨϢⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀϤϪⲰⲚⲦ ⲈⲦⲞϬϤ ⲈⲘⲘⲀⲐⲎⲦⲎⲤ. ⲀⲨⲰ ⲚⲈⲨⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲦⲎⲢⲞⲨ ⲚⲤⲈⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ϪⲈ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲀϤⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ ⲀϤϪⲒⲦϤ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲰ ⲀϤⲦⲀⲘⲞⲞⲨ ⲈⲐⲈ ⲚⲦⲀϤⲚⲀⲨ ⲈⲠϪⲞⲈⲒⲤ ϨⲚ ⲦⲈϨⲒⲎ ⲀⲨⲰ ϪⲈ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲚⲐⲈ ⲚⲦⲀϤⲠⲀⲢⲢⲎⲤⲒⲀⲌⲈ ⲘⲘⲞϤ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ⲚⲈϤϢⲞⲞⲠ ⲆⲈ ⲚⲘⲘⲀⲨ ⲠⲈ ⲈϤⲂⲎⲔ ⲈϨⲞⲨⲚ ⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨⲰ ⲈϤⲠⲀⲢⲢⲎ ⲤⲒⲀⲌⲈ ⲘⲘⲞϤ ϨⲘ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ⲚⲈϤϢⲀϪⲈ ⲆⲈ ⲀⲨⲰ ⲚⲈϤϮⲦⲰⲚ ⲘⲚ ⲚⲞⲨⲈⲈⲒⲈⲚⲒⲚ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϨⲒⲦⲞⲞⲦⲞⲨ ⲈϨⲞⲦⲂⲈϤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ⲚⲦⲈⲢⲞⲨⲈⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲚⲈⲤⲚⲎⲨ. ⲀⲨⲚⲦϤ ⲈϨⲢⲀⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ ⲚⲦⲈⲨϢⲎ. ⲀⲨⲰ ⲀⲨϪⲞⲞⲨϤ ⲈⲦⲀⲢⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲆⲈ ⲈⲦϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲦⲎⲢⲤ ⲘⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲘⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲚⲈⲤϢⲞⲞⲠ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ ⲈⲨⲔⲰⲦ ⲘⲘⲞⲤ ⲈⲤⲘⲞⲞϢⲈ ϨⲚ ⲐⲞⲦⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ϨⲘ ⲠⲤⲞⲠⲤ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲈⲤⲀϢⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲢⲈϤⲂⲰⲔ ϢⲀ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲖⲨⲆⲆⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ⲀⲨⲰ ⲀϤϨⲈ ⲈⲨⲢⲰⲘⲈ ⲘⲘⲀⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲚⲚⲀⲒⲀⲤ. ⲈⲀϤⲢ ϢⲘⲞⲨⲚⲈ ⲚⲢⲞⲘⲠⲈ ⲈϤⲤⲎϬ ⲈϤⲚⲎϪ ϨⲒϪⲚ ⲞⲨϬⲖⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ⲀⲨⲰ ⲠⲈⲦⲢⲞⲤ ⲀϤϬⲰϢⲦ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ. ϪⲈ ⲈⲚⲀⲒⲀ ⲀϤⲦⲀⲖϬⲞⲔ ⲚϬⲒ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲚⲄⲠⲰⲢϢ ϨⲀⲢⲞⲔ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲖⲨⲆⲆⲀ ⲘⲚ ⲤⲀⲢⲰⲚⲀ. ⲀⲨⲰ ⲀϨⲀϨ ⲔⲞⲦⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ⲚⲈⲨⲚ ⲞⲨⲤⲰⲚⲈ ⲆⲈ ϨⲚ ⲒⲞⲠⲠⲎ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲦⲀⲂⲒⲐⲀ ⲦⲀⲒ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈⲤ ϪⲈ ⲦⲞⲢⲔⲀⲤ ⲦⲀⲒ ⲚⲈⲤϪⲎⲔ ⲈⲂⲞⲖ ⲠⲈ ⲚϨⲰⲂ ⲚⲒⲘ ⲈⲚⲀⲚⲞⲨϤ ϨⲒ ⲘⲚⲦⲚⲀ ⲚⲀⲒ ⲈⲚⲈⲤⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ⲀⲤϢⲰⲠⲈ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲢⲈⲤϢⲰⲚⲈ ⲚⲤⲘⲞⲨ. ⲀⲨϪⲞⲔⲘⲈⲤ ⲆⲈ ⲀⲨⲰ ⲀⲨⲔⲀⲀⲤ ϨⲚ ⲞⲨⲘⲀ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ⲈⲢⲈ ⲖⲨⲆⲆⲀ ⲆⲈ ϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲒⲞⲠⲠⲎ. ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲘⲘⲀⲨ. ⲀⲨϪⲞⲞⲨ ϢⲀⲢⲞϤ ⲚⲢⲰⲘⲈ ⲤⲚⲀⲨ ⲈⲨⲤⲞⲠⲤ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢϪⲚⲀⲀⲨ ⲈⲈⲒ ϢⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲂⲰⲔ ⲚⲘⲘⲀⲨ ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲀⲨϪⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲠⲘⲀ ⲚⲦⲠⲈ ⲀⲨⲰ ⲀⲚⲈⲬⲎⲢⲀ ⲦⲎⲢⲞⲨ ⲀϨⲈⲢⲀⲦⲞⲨ ⲈⲢⲞϤ ⲈⲨⲢⲒⲘⲈ ⲈⲨⲦⲤⲀⲂⲞ ⲘⲘⲞϤ ⲈϨⲈⲚϢⲦⲎⲚ ⲘⲚ ϨⲈⲚϨⲞⲒⲦⲈ ⲚⲀⲒ ⲈⲚⲈⲤⲦⲀⲘⲒⲞ ⲘⲘⲞⲞⲨ ⲈⲤⲚⲘⲘⲀⲨ ⲚϬⲒ ⲆⲞⲢⲔⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲨⲰ ⲀϤⲔⲰⲖϪ ⲚⲚⲈϤⲠⲀⲦ ⲀϤϢⲖⲎⲖ ⲀϤⲔⲦⲞϤ ⲆⲈ ⲈⲠⲤⲰⲘⲀ ⲠⲈϪⲀϤ ϪⲈ ⲦⲀⲂⲒⲐⲀ ⲦⲰⲞⲨⲚ ϨⲘ ⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲦⲞⲤ ⲆⲈ ⲀⲤⲞⲨⲰⲚ ⲚⲚⲈⲤⲂⲀⲖ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲰ ⲚⲦⲈⲢⲈⲤⲚⲀⲨ ⲈⲠⲈⲦⲢⲞⲤ ⲀⲤϨⲘⲞⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ⲀϤϮ ⲦⲞⲞⲦⲤ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤⲤ ⲀⲨⲰ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈⲦⲞⲨⲀⲀⲂ ⲘⲚ ⲚⲈⲬⲎⲢⲀ ⲀϤⲦⲀϨⲞⲤ ⲈⲢⲀⲦⲤ ⲚⲀⲨ ⲈⲤⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ⲀⲠⲀⲒ ϢⲰⲠⲈ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲒⲞⲠⲠⲎ ⲦⲎⲢⲤ. ⲀⲨⲰ ⲀϨⲀϨ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈⲦⲢⲈϤϬⲰ ⲚϨⲀϨ ⲚϨⲞⲞⲨ ϨⲚ ⲒⲞⲠⲠⲎ ϨⲀⲦⲚ ⲞⲨⲀ ϪⲈ ⲤⲒⲘⲰⲚ ⲠⲂⲀⲔϢⲀⲀⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ϨⲚ ⲔⲀⲒⲤⲀⲢⲒⲀ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ. ⲞⲨϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲤⲠⲒⲢⲎ ⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲐⲒⲦⲀⲖⲒⲔⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ⲈⲨⲈⲨⲤⲈⲂⲎⲤ ⲠⲈ ⲈϤⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ ⲈϢⲀϤⲢ ϨⲀϨ ⲘⲘⲚⲦⲚⲀ ⲘⲠⲖⲀⲞⲤ. ⲀⲨⲰ ⲈϤⲤⲞⲠⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ⲀϤⲚⲀⲨ ⲈⲨϨⲞⲢⲞⲘⲀ ϨⲚ ⲞⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲚⲀⲨ ⲚϪⲠ ⲮⲒⲦⲈ ⲘⲠⲈϨⲞⲞⲨ. ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ⲚⲦⲈⲢⲈϤϬⲰϢⲦ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀϤⲢϨⲞⲦⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦϢⲞⲞⲠ ⲠϪⲞⲈⲒⲤ. ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲚⲈⲔϢⲖⲎⲖ ⲀⲨⲰ ⲚⲈⲔⲘⲚⲦⲚⲀ. ⲀⲨⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲨⲢⲠⲘⲈⲈⲨⲈ ⲚⲀⲔ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ⲦⲈⲚⲞⲨ ϬⲈ ⲘⲀϪⲞⲞⲨ ⲚϨⲈⲚⲢⲰⲘⲈ ⲈϨⲢⲀⲒ ⲈⲒⲞⲠⲠⲎ ⲚⲄⲦⲚⲚⲞⲞⲨ ⲚⲤⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ⲈϤⲞⲨⲎϨ ϨⲀϨⲦⲚ ⲞⲨⲀ ϪⲈ ⲤⲒⲘⲰⲚ ⲠⲂⲀⲔϢⲀⲀⲢ. ⲠⲀⲒ ⲈⲢⲈⲠⲈϤⲎⲒ ϨⲒϪⲚ ⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲂⲰⲔ ⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀϤ. ⲀϤⲘⲞⲨⲦⲈ ⲈⲤⲚⲀⲨ ⲚⲚⲈϤϨⲘϨⲀⲖ. ⲀⲨⲰ ⲞⲨⲘⲀⲦⲞⲒ ⲚⲢⲘⲚⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ⲀⲨⲰ ⲀϤϪⲈ ϢⲀϪⲈ ⲚⲒⲘ ⲈⲢⲞⲞⲨ ⲀϤϪⲞⲞⲨⲤⲈ ⲈⲒⲞⲠⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲈⲨⲘⲞⲞϢⲈ ⲚϬⲒ ⲠⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲢⲞⲨϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ. ⲠⲈⲦⲢⲞⲤ ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦϪⲈⲚⲈⲠⲰⲢ ⲈϢⲖⲎⲖ ⲘⲠⲚⲀⲨ ⲚϪⲠ ⲤⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ⲀϤϨⲔⲞ ⲆⲈ ⲀⲨⲰ ⲀϤⲢϨⲚⲀϤ ⲚⲞⲨⲰⲘ. ⲈⲨⲤⲞⲂⲦⲈ ⲆⲈ ⲚⲀϤ. ⲀⲨⲈⲄⲤⲦⲀⲤⲒⲤ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲦⲠⲈ ⲈⲤⲞⲨⲎⲚ. ⲀⲨⲰ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲈϤⲘⲎⲢ ⲈⲠⲈϤⲦⲞⲞⲨ ⲚⲦⲞⲠ ⲚⲐⲈ ⲚⲞⲨⲚⲞϬ ⲚϨⲂⲞⲤ. ⲈⲨⲬⲀⲖⲀ ⲘⲘⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ⲈⲢⲈ ⲚⲦⲂⲚⲞⲞⲨⲈ ⲦⲎⲢⲞⲨ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲚϪⲀⲦϤⲈ ⲘⲠⲔⲀϨ ⲘⲚ ⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ⲀⲨⲤⲘⲎ ⲆⲈ ϢⲰⲠⲈ ϢⲀⲢⲞϤ ϪⲈ ⲦⲰⲞⲨⲚ ⲠⲈⲦⲢⲈ ϢⲰⲰⲦ ⲚⲄⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲘⲠⲰⲢ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲘⲠⲒⲞⲨⲈⲘ ⲖⲀⲀⲨ ⲈⲚⲈϨ ⲈϤϪⲀϨⲘ ⲎⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ⲀⲦⲈⲤⲘⲎ ⲆⲈ ⲞⲚ ϢⲰⲠⲈ ϢⲀⲢⲞϤ ⲘⲠⲘⲈϨⲤⲈⲠ ⲤⲚⲀⲨ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲂⲂⲞⲞⲨ ⲚⲦⲞⲔ ⲘⲠⲢϪⲀϨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ⲠⲀⲒ ⲆⲈ ⲞⲚ ⲀϤϢⲰⲠⲈ ⲚϢⲘⲦⲤⲰⲰⲠ. ⲀⲨⲰ ⲀⲨϪⲒ ⲠⲈⲤⲔⲈⲨⲞⲤ ⲞⲚ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲀⲠⲞⲢⲢⲒ ϨⲢⲀⲒ ⲚϨⲎⲦϤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲈⲒϨⲞⲢⲞⲘⲀ ⲚⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲈⲒⲤ ⲚⲢⲰⲘⲈ ⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨⲤⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲀⲨϢⲒⲚⲈ ⲚⲤⲀ ⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲀⲨⲈⲒ ⲈⲢⲘⲠⲢⲞ ");
INSERT INTO copshc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ⲀⲨⲘⲞⲨⲦⲈ ⲆⲈ ⲀⲨϪⲚⲞⲨⲞⲨ ϪⲈ ⲈⲢⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲎϨ ⲘⲠⲈⲒⲘⲀ. ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲘⲞⲔⲘⲈⲔ ⲘⲘⲞϤ ⲈⲦⲂⲈ ⲠϨⲞⲢⲞⲘⲀ. ⲠⲈϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀϤ. ϪⲈ ⲈⲒⲤ ϢⲞⲘⲚⲦ ⲚⲢⲰⲘⲈ ⲤⲈϢⲒⲚⲈ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ⲀⲖⲖⲀ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ ⲈⲠⲈⲤⲎⲦ ⲚⲄⲘⲞⲞϢⲈ ⲚⲘⲘⲀⲨ. ⲚⲄⲆⲒⲀⲔⲢⲒⲚⲈ ⲚⲖⲀⲀⲨ ⲀⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈⲚⲦⲀⲒⲦⲚⲚⲞⲞⲨⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲠⲈϪⲀϤ ⲚⲚⲢⲰⲘⲈ. ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ⲠⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰⲒ. ⲞⲨ ⲦⲈ ⲦⲖⲞⲒϬⲈ ⲚⲦⲀⲦⲈⲦⲚⲈⲒ ⲈⲦⲂⲎⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲞⲨϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲞⲨⲢⲰⲘⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲈϤⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈⲨⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞϤ ϨⲒⲦⲘ ⲠϨⲈⲐⲚⲞⲤ ⲦⲎⲢϤ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲈⲀⲨⲦⲤⲈⲂⲈ ⲈⲒⲀⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲈϤⲞⲨⲀⲀⲂ ⲈⲦⲚⲚⲞⲞⲨ ⲚⲤⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ⲀⲨⲰ ⲈⲤⲰⲦⲘ ⲈϨⲈⲚϢⲀϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ⲀϤⲘⲞⲨⲦⲈ ϬⲈ ⲈⲢⲞⲞⲨ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀϤϢⲞⲠⲞⲨ ⲈⲢⲞϤ. ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚⲘⲘⲀⲨ. ⲀⲨⲰ ϨⲞⲈⲒⲚⲈ ⲚⲚⲈⲤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲒⲞⲠⲠⲎ ⲀⲨⲈⲒ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀϤⲂⲰⲔ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ϬⲈ ⲚⲈϤϬⲰϢⲦ ϨⲎⲦⲞⲨ ⲠⲈ ⲈⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈϤⲤⲨⲄⲄⲈⲚⲎⲤ ⲘⲚ ⲚⲈϤϢⲂⲎⲢ ⲀⲚⲀⲄⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲀⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲦⲰⲘⲚⲦ ⲈⲢⲞϤ. ⲀⲨⲰ ⲀϤⲠⲀϨⲦϤ ϨⲀⲢⲀⲦϤ ⲀϤⲞⲨⲰϢⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚⲄ. ⲀⲚⲞⲔ ϨⲰⲰⲦ ⲞⲚ ⲀⲚⲄ ⲞⲨⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ⲈϤϢⲀϪⲈ ⲆⲈ ⲚⲘⲘⲀϤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ. ⲀⲨⲰ ⲀϤϨⲈ ⲈⲨⲘⲎⲎϢⲈ ⲈⲨⲤⲞⲞⲨϨ. ");
INSERT INTO copshc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨϢⲖⲞϤ ⲠⲈ ⲚⲞⲨⲢⲰⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲈϪⲰϨ ⲎⲈϮ ⲠⲈϤⲞⲨⲞⲒ ⲈⲨⲢⲰⲘⲈ ⲚⲀⲖⲖⲞⲪⲨⲖⲞⲤ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲀϤⲦⲤⲀⲂⲞⲒ ⲈⲦⲘⲈ ⲠⲖⲀⲀⲨ ⲚⲢⲰⲘⲈ ϪⲈ ϤϪⲀϨⲘ ⲎⲞⲨⲀⲔⲀⲐⲀⲢⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲦⲈⲢⲈⲦⲚⲈⲒ ⲚⲤⲰⲒ. ⲀⲒⲈⲒ ⲚⲞⲨⲈϢ ⲚⲖⲞⲒϬⲈ. ϮϪⲚⲞⲨ ϬⲈ ⲘⲘⲰⲦⲚ ϪⲈ ϨⲚ ⲞⲨ ⲚϢⲀϪⲈ ⲀⲦⲈⲦⲚⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ⲀⲨⲰ ⲠⲈϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ϪⲈ ϪⲒⲚϤⲦⲈⲨⲈⲠⲞⲞⲨ ϢⲀϨⲢⲀⲒ ⲈⲦⲈⲒⲞⲨⲚⲞⲨ. ⲚⲈⲒⲚⲎⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲚⲈⲒϢⲖⲎⲖ ϨⲘ ⲠⲀⲎⲒ ⲘⲠⲚⲀⲨ ⲚϪⲠ ⲮⲒⲦⲈ. ⲀⲨⲰ ⲈⲒⲤ ⲞⲨⲢⲰⲘⲈ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲘⲠⲀⲘⲦⲞ ⲈⲂⲞⲖ ϨⲚ ⲞⲨϨⲂⲤⲰ ⲚⲞⲨⲰⲂϢ. ");
INSERT INTO copshc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲈ ⲀⲨⲤⲰⲦⲘ ⲈⲠⲈⲔϢⲖⲎⲖ. ⲀⲨⲰ ⲚⲈⲔⲘⲚⲦⲚⲀ ⲀⲨⲢⲠⲈⲨⲘⲈⲈⲨⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ⲘⲀϪⲞⲞⲨ ϬⲈ ⲈⲒⲞⲠⲠⲎ ⲚⲄⲦⲚⲞⲞⲨ ⲚⲤⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ⲠⲀⲒ ⲈϤⲞⲨⲎϨ ϨⲘ ⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲂⲀⲔϢⲀⲀⲢ ϨⲀⲦⲚ ⲐⲀⲖⲀⲤⲤⲀ. ⲠⲀⲒ ⲈϤⲚⲎⲨ ⲚϤϪⲰ ⲚⲀⲔ ⲚϨⲈⲚϢⲀϪⲈ ⲈⲔⲚⲀⲞⲨϪⲀⲒ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲒⲦⲚⲚⲞⲞⲨ ϢⲀⲢⲞⲔ ⲚⲦⲞⲔ ⲆⲈ ⲔⲀⲖⲰⲤ ⲀⲔⲀⲀⲤ ⲀⲔⲈⲒ ⲦⲈⲚⲞⲨ ϬⲈ ⲈⲒⲤ ⲀⲚⲞⲚ ⲦⲎⲢⲚ ⲘⲠⲈⲔⲘⲦⲞ ⲈⲂⲞⲖ ⲈⲤⲰⲦⲘ ⲈⲚⲈⲚⲦⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲞⲨ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲞⲨⲰⲚ ⲚⲢⲰϤ ⲠⲈϪⲀϤ ϪⲈ ϨⲚ ⲞⲨⲘⲈ ϮⲈⲒⲘⲈ. ϪⲈ ⲚⲞⲨⲢⲈϤϪⲒϨⲞ ⲀⲚ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ⲀⲖⲖⲀ ϨⲚ ϨⲈⲐⲚⲞⲤ ⲚⲒⲘ ⲠⲈⲦⲢϨⲞⲦⲈ ϨⲎⲦϤ. ⲀⲨⲰ ⲈⲦⲢϨⲰⲂ ⲈⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϤϢⲎⲠ ⲚⲚⲀϨⲢⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ⲠⲈϤϢⲀϪⲈ ⲄⲀⲢ ⲀϤⲦⲚⲚⲞⲞⲨϤ ⲚⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ. ⲈϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲀⲒ ⲠⲈ ⲠϪⲞⲈⲒⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲠϢⲀϪⲈ ⲚⲦⲀϤϢⲰⲠⲈ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲦⲎⲢⲤ. ⲈⲀϤⲀⲢⲬⲈⲒ ϪⲒⲚ ⲚⲦⲄⲀⲖⲒⲖⲀⲒⲀ. ⲘⲚⲚⲤⲀ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲦⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ⲔⲎⲢⲨⲤⲤⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ⲒⲎⲤⲞⲨⲤ ⲠⲈⲂⲞⲖ ϨⲚ ⲚⲀⲌⲀⲢⲈⲐ ⲚⲐⲈ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲀϨⲤϤ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ⲘⲚ ⲞⲨϬⲞⲘ ⲠⲀⲒ ⲚⲦⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲈϤⲢ ⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲨⲰ ⲈϤⲢⲠⲀϨⲢⲈ ⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨϪⲒ ⲘⲘⲞⲞⲨ ⲚϬⲞⲚⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ϢⲞⲞⲠ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ⲀⲨⲰ ⲀⲚⲞⲚ ⲦⲚⲞ ⲘⲘⲚⲦⲢⲈ ⲚϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀϤⲀⲀⲨ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲚϮⲞⲨⲆⲀⲒⲀ ⲘⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲠⲀⲒ ⲚⲦⲀⲨⲘⲞⲞⲨⲦϤ ⲈⲀⲨⲀϢⲦϤ ⲈⲨϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ⲠⲀⲒ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲞⲤϤ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ⲀⲨⲰ ⲀϤⲦⲀⲀϤ ⲈⲦⲢⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ⲘⲠⲖⲀⲞⲤ ⲦⲎⲢϤ ⲀⲚ. ⲀⲖⲖⲀ ⲚⲈⲚⲦⲀⲨⲦⲞϢⲞⲨ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲘⲘⲚⲦⲢⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲚⲀⲒ ⲚⲦⲀⲚⲞⲨⲰⲘ ⲀⲨⲰ ⲀⲚⲤⲰ ⲚⲘⲘⲀϤ ⲘⲚⲚⲤⲀ ⲦⲢⲈϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚϨⲘⲈ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ⲈⲀϤⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲚ ⲈⲔⲎⲢⲨⲤⲤⲈ ⲘⲠⲖⲀⲞⲤ ⲀⲨⲰ ⲈⲢⲘⲚⲦⲢⲈ. ϪⲈ ⲠⲀⲒ ⲠⲈⲚⲦⲀⲨⲦⲞϢϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲔⲢⲒⲦⲎⲤ ⲚⲚⲈⲦⲞⲚϨ ⲘⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲢⲘⲚⲦⲢⲈ ⲘⲠⲀⲒ ⲈⲦⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ϪⲒ ⲚⲞⲨⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲚⲞⲂⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ⲈⲦⲒ ⲆⲈ ⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ϪⲰ ⲚⲚⲈⲒϢⲀϪⲈ. ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ⲀⲨⲰ ⲀⲨⲠⲰϢⲤ ⲚϬⲒ ⲘⲠⲒⲤⲦⲞⲤ ⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲂⲂⲈ. ⲚⲀⲒ ⲚⲦⲀⲨⲈⲒ ⲘⲚ ⲠⲈⲦⲢⲞⲤ. ϪⲈ ⲀⲦⲆⲰⲢⲈⲀ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲠⲰϨⲦ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲔⲈϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ⲚⲈⲨⲤⲰⲦⲘ ⲄⲀⲢ ⲈⲢⲞⲞⲨ ⲈⲨϢⲀϪⲈ ϨⲚ ϨⲈⲚⲔⲈⲀⲤⲠⲈ. ⲀⲨⲰ ⲈⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲦⲞⲦⲈ ⲀⲠⲈⲦⲢⲞⲤ ⲞⲨⲰϢⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ϪⲈ ⲘⲎⲦⲒ ⲞⲨⲚ ϢϬⲞⲘ ⲚⲖⲀⲀⲨ ⲈⲔⲰⲖⲨ ⲘⲠⲘⲞⲞⲨ. ⲈⲦⲢⲈ ⲚⲀⲒ ϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ. ⲚⲀⲒ ⲚⲦⲀⲨϪⲒ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϨⲰⲞⲨ ⲚⲦⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲆⲈ ⲚⲀⲨ ⲈⲦⲢⲈⲨϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀϤϬⲰ ⲆⲈ ϨⲀϨⲦⲎⲨ ⲚϨⲈⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲰ ⲚⲈⲤⲚⲎⲨ ⲈⲦϢⲞⲞⲠ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ. ϪⲈ ⲀⲚϨⲈⲐⲚⲞⲤ ϢⲰⲠ ⲈⲢⲞⲞⲨ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ⲚⲦⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨϪⲒϨⲀⲠ ⲚⲘⲘⲀϤ ⲚϬⲒ ⲚⲈⲤⲚⲎⲨ ⲚⲈⲂⲞⲖ ϨⲘ ⲠⲤⲂⲂⲈ ");
INSERT INTO copshc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲔⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀ ϨⲈⲚⲢⲰⲘⲈ ⲚⲀⲦⲤⲂⲂⲈ ⲀⲨⲰ ⲀⲔⲞⲨⲰⲘ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ⲀϤⲀⲢⲬⲈⲒ ⲆⲈ ⲚϬⲒ ⲠⲈⲦⲢⲞⲤ ⲀϤⲦⲀⲨⲈ ⲐⲈ ⲈⲢⲞⲞⲨ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ϪⲈ ⲀⲚⲞⲔ ⲚⲈⲒϢⲞⲞⲠ ϨⲚ ⲞⲨⲠⲞⲖⲒⲤ ϪⲈ ⲈⲒⲞⲠⲠⲎ ⲈⲒϢⲖⲎⲖ ⲀⲨⲰ ⲀⲚⲀⲨ ⲈⲨϨⲞⲢⲞⲘⲀ ϨⲚ ⲞⲨⲈⲔⲤⲦⲀⲤⲒⲤ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲚⲐⲈ ⲚⲞⲨⲚⲞϬ ⲚϨⲂⲞⲤ ⲈⲨⲬⲀⲖⲀ ⲘⲘⲞϤ ⲘⲠⲈϤⲦⲞⲞⲨ ⲚⲦⲞⲠ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲀⲨⲰ ⲀϤⲠⲰϨ ϢⲀⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ⲀⲒϬⲰϢⲦ ⲆⲈ ⲀⲨⲰ ⲀⲒⲘⲞⲨϨ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲀⲚⲀⲨ ⲈⲚⲦⲂⲚⲞⲞⲨⲈ ⲘⲠⲔⲀϨ ⲘⲚ ⲚⲈⲐⲎⲢⲒⲞⲚ ⲘⲚ ⲚϪⲀⲦϤⲈ. ⲀⲨⲰ ⲚϨⲀⲖⲀⲦⲈ ⲚⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ⲀⲒⲤⲰⲦⲘ ⲆⲈ ⲞⲚ ⲈⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲒ ϪⲈ ⲦⲰⲞⲨⲚ ⲠⲈⲦⲢⲈ ϢⲰⲰⲦ ⲚⲄⲞⲨⲰⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ⲀⲨⲰ ⲠⲈϪⲀⲒ ϪⲈ ⲘⲠⲰⲢ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲘⲠⲈ ⲠⲈⲦϪⲀϨⲘ ⲎⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲢⲰⲒ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ⲀⲦⲈⲤⲘⲎ ⲆⲈ ⲞⲨⲰϢⲂ ⲘⲠⲘⲈϨⲤⲈⲠ ⲤⲚⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ϪⲈ ⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲂⲂⲞⲞⲨ. ⲚⲦⲞⲔ ⲘⲠⲢϪⲀϨⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ⲠⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲈ ⲚϢⲘⲦⲤⲰⲰⲠ. ⲀⲨⲰ ⲀⲨϤⲒ ⲚⲔⲀ ⲚⲒⲘ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲈⲒⲤ ϢⲞⲘⲚⲦ ⲚⲢⲰⲘⲈ ⲀⲨⲈⲒ ⲈⲢⲘ ⲠⲎⲒ ⲈⲚⲈⲒ ⲚϨⲎⲦϤ. ⲈⲀⲨⲦⲚⲚⲞⲞⲨⲤⲈ ϢⲀⲢⲞⲒ ⲈⲂⲞⲖ ϨⲚ ⲔⲀⲒⲤⲀⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ⲠⲈϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀⲒ ϪⲈ ⲂⲰⲔ ⲚⲘⲘⲀⲨ ⲘⲠⲔⲆⲒⲀⲔⲢⲒⲚⲈ ⲚⲖⲀⲀⲨ. ⲀⲨⲈⲒ ⲆⲈ ⲚⲘⲘⲀⲒ ⲚϬⲒ ⲠⲈⲒⲔⲈⲤⲞⲞⲨ ⲚⲤⲞⲚ. ⲀⲨⲰ ⲀⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ⲀϤⲦⲀⲘⲞⲚ ⲈⲐⲈ ⲚⲦⲀϤⲚⲀⲨ ⲈⲠⲀⲄⲄⲈⲖⲞⲤ ⲈϤⲀϨⲈⲢⲀⲦϤ ϨⲘ ⲠⲈϤⲎⲒ. ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲘⲀϪⲞⲞⲨ ⲈⲈⲒⲞⲠⲠⲎ ⲚⲄⲦⲚⲚⲞⲞⲨ ⲚⲤⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ⲀⲨⲰ ⲠⲀⲒ ⲚⲀϪⲰ ⲈⲢⲞⲔ ⲚϨⲈⲚϢⲀϪⲈ ⲈⲔⲚⲀⲞⲨϪⲀⲒ ⲚϨⲎⲦⲞⲨ. ⲚⲦⲞⲔ ⲀⲨⲰ ⲠⲈⲔⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ⲚⲦⲈⲢⲒⲀⲢⲬⲈⲒ ⲆⲈ ⲚϢⲀϪⲈ ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ⲚⲐⲈ ϨⲰⲰⲚ ⲞⲚ ⲚⲦⲈϨⲞⲨⲈⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ⲀⲒⲢⲠⲘⲈⲈⲨⲈ ⲆⲈ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲚⲐⲈ ⲚⲦⲀϤϪⲞⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲀϤⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲞⲨⲘⲞⲞⲨ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲤⲈⲚⲀⲂⲀⲠⲦⲒⲌⲈ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ⲈϢϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ⲆⲈ ϮⲚⲀⲨ ⲚϮⲆⲰⲢⲈⲀ ⲚⲞⲨⲰⲦ ⲚⲐⲈ ϨⲰⲰⲚ ⲚⲦⲀϤϮ ⲚⲀⲚ ⲈⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲄ ⲚⲒⲘ ⲈⲦⲢⲀϢϬⲘϬⲞⲘ ⲈⲔⲰⲖⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲨⲔⲀⲢⲰⲞⲨ ⲀⲨⲰ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲀ ⲀⲠⲚⲞⲨⲦⲈ ϮⲦⲘⲈⲦⲀⲚⲞⲒⲀ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲢⲈⲨⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ⲚⲈⲚⲦⲀⲨϪⲰⲰⲢⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲐⲖⲒⲮⲒⲤ ⲚⲦⲀⲤϢⲰⲠⲈ ϨⲒ ⲤⲦⲈⲪⲀⲚⲞⲤ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϢⲀϨⲢⲀⲒ ⲈⲦⲈⲪⲞⲒⲚⲒⲔⲎ ⲘⲚ ⲔⲨⲠⲢⲞⲤ ⲘⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲈⲚⲤⲈϪⲰ ⲀⲚ ⲘⲠϢⲀϪⲈ ⲈⲖⲀⲀⲨ ⲈⲒⲘⲎⲦⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ⲚⲈⲨⲚ ϨⲞⲈⲒⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲈϨⲈⲚⲢⲰⲘⲈ ⲚⲈ ⲚⲔⲨⲠⲢⲒⲞⲤ. ⲀⲨⲰ ⲚⲔⲨⲢⲎⲚⲀⲒⲞⲤ. ⲚⲀⲒ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲀⲨϢⲀϪⲈ ⲘⲚ ⲚⲞⲨⲈⲈⲒⲈⲚⲒⲚ ⲈⲨⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ⲀⲨⲰ ⲦϬⲒϪ ⲘⲠϪⲞⲈⲒⲤ ⲚⲈⲤϢⲞⲞⲠ ⲚⲘⲘⲀⲨ. ⲞⲨⲚⲞϬ ⲆⲈ ⲘⲘⲎⲎϢⲈ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ⲀⲠϢⲀϪⲈ ⲆⲈ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲘⲘⲀⲀϪⲈ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲦⲂⲎⲎ ⲦⲞⲨ. ⲀⲨⲰ ⲀⲨϪⲞⲞⲨ ⲚⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲦⲢⲈϤⲂⲰⲔ ϢⲀ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲀϤⲚⲀⲨ ⲈⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤⲢⲀϢⲈ. ⲀⲨⲰ ⲚⲈϤⲤⲞⲠⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲢⲈⲨϬⲰ ϨⲒ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲨⲢⲰⲘⲈ ⲠⲈ ⲚⲀⲄⲀⲐⲞⲤ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ϨⲒ ⲠⲒⲤⲦⲒⲤ. ⲀⲨⲰ ⲀⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲞⲨⲀϨϤ ⲈⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲦⲀⲢⲤⲞⲤ ⲈϢⲒⲚⲈ ⲚⲤⲀ ⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲈ ⲈⲢⲞϤ ⲀϤⲚⲦϤ ⲈⲦⲀⲚⲦⲒⲞⲬ ⲒⲀ. ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲢ ⲞⲨⲢⲞⲘⲠⲈ ⲘⲘⲀⲨ ⲈⲨⲤⲞⲞⲨϨ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲀⲨⲰ ⲚⲤⲈϮⲤⲂⲰ ⲚⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲀⲨⲰ ⲚⲤⲈⲘⲞⲨⲦⲈ ⲈⲘⲘⲀⲐⲎⲦⲎⲤ ⲚϢⲞⲢⲠ ϨⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ϪⲈ ⲚⲈⲬⲢⲒⲤⲦⲒⲀⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ϨⲢⲀⲒ ⲆⲈ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ. ⲀϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ⲀⲞⲨⲀ ⲆⲈ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲄⲀⲂⲞⲤ ⲀϤⲤⲎⲘⲀⲚⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲚⲞϬ ⲚϨⲈⲂⲰⲰⲚ ⲈϤⲚⲀϢⲰⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ ⲠⲀⲒ ⲚⲦⲀϤϢⲰⲠⲈ ϨⲒ ⲔⲖⲀⲨⲆⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲦⲞϢⲞⲨ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲈⲞⲨⲚⲦⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ ⲈⲦⲢⲈⲨϮ ⲈϨⲢⲀⲒ ⲈⲨⲆⲒⲀⲔⲞⲚⲒⲀ. ⲚⲤⲈϪⲞⲞⲨⲤⲞⲨ ⲚⲚⲈⲤⲚⲎⲨ ⲈⲦⲞⲨⲎϨ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ⲠⲀⲒ ⲆⲈ ⲀⲨⲀⲀϤ ⲀⲨϪⲞⲞⲤⲞⲨ ⲚⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲚⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ⲘⲠⲈⲞⲨⲞⲈⲒϢ ⲆⲈ ⲈⲦⲘⲘⲀⲨ. ⲀⲀⲄⲢⲒⲠⲠⲀⲤ ⲠⲢⲢⲞ ϨⲒ ⲦⲞⲞⲦϤ ⲈⲐⲘⲔⲈ ϨⲞⲒⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ⲀϤϨⲰⲦⲂ ⲆⲈ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲠⲤⲞⲚ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ϨⲚ ⲞⲨⲤⲎϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲆⲈ ϪⲈ ϤⲢⲀⲚⲀⲨ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲀϤⲞⲨⲰϨ ⲈⲦⲞⲞⲦϤ ⲈϬⲰⲠⲈ ⲘⲠⲔⲈ ⲠⲈⲦⲢⲞⲤ. ⲚⲈ ⲚⲈϨⲞⲞⲨ ⲆⲈ ⲚⲀⲐⲀⲂ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ⲚⲦⲈⲢⲈϤϬⲞⲠϤ ⲆⲈ ⲀϤⲚⲞϪϤ ⲈⲠⲈϢⲦⲈⲔⲞ. ⲈⲀϤⲦⲀⲀϤ ⲈⲦⲞⲞⲦⲞⲨ ⲘⲘⲚⲦⲀⲤⲈ ⲘⲘⲀⲦⲞⲒ ⲈϨⲀⲢⲈϨ ⲈⲢⲞϤ. ⲈϤⲞⲨⲰϢ ⲘⲚⲚⲤⲀ ⲠⲠⲀⲤⲬⲀ ⲈⲚⲦϤ ⲈⲂⲞⲖ ⲚⲚⲀϨⲢⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ⲠⲈⲦⲢⲞⲤ ϬⲈ ⲚⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞϤ ⲠⲈ ϨⲚ ⲞⲨⲰⲢϪ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ⲚⲈⲨⲚ ⲞⲨⲚⲞϬ ⲆⲈ ⲚϢⲖⲎⲖ ϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ⲚⲦⲈⲢⲈϤⲚⲞⲨ ⲆⲈ ⲚϬⲒ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲈⲚⲦϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨϢⲎ ⲈⲦⲘⲘⲀⲨ ⲚⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲔⲞⲦⲔ ⲚⲦⲘⲎⲦⲈ ⲘⲘⲀⲦⲞⲒ ⲤⲚⲀⲨ ⲈϤⲘⲎⲢ ⲚϨⲀⲖⲨⲤⲒⲤ ⲤⲚⲦⲈ ⲈⲢⲈ ⲚⲀⲚⲞⲨⲢϢⲈ ϨⲒⲢⲘ ⲠⲢⲞ ⲈⲨϨⲀⲢⲈϨ ⲈⲠⲈϢⲦⲈⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ⲀⲨⲰ ⲈⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲒϪⲘ ⲠⲈⲦⲢⲞⲤ ⲀⲨⲰ ⲀⲨⲞⲨⲞⲈⲒⲚ ϢⲀ ϨⲘ ⲠⲎⲒ ⲀϤⲦⲂⲤ ⲠⲈⲤⲠⲒⲢ ⲆⲈ ⲘⲠⲈⲦⲢⲞⲤ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲞⲨⲚⲄ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲀⲨⲰ ⲀⲘⲘⲢⲢⲈ ϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϤϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ⲠⲈϪⲈ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲘⲞⲨⲢ ⲚⲦⲈⲔϮⲠⲈ ⲀⲨⲰ ⲚⲄϮ ⲘⲠⲈⲔⲤⲀⲚⲆⲀⲖⲒⲞⲚ ⲈⲢⲀⲦⲔ ⲀϤⲈⲒⲢⲈ ⲆⲈ ϨⲒⲚⲀⲒ ⲀⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϮⲦⲈⲔϢⲦⲎⲚ ϨⲒⲰⲰⲔ ⲀⲨⲰ ⲚⲄⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲰϤ. ⲈⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲘⲈ ⲠⲈ ⲠⲈⲦⲈⲢⲈ ⲠⲀⲄⲄⲈⲖⲞⲤ ⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲚⲈϤⲘⲈⲈⲨⲈ ⲄⲀⲢ ϪⲈ ⲞⲨϨⲞⲢⲞⲘⲀ ⲠⲈⲦϤⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϢⲞⲢⲠ ⲚⲢⲞ ⲀⲨⲰ ⲠⲘⲈϨⲤⲚⲀⲨ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲠⲨⲖⲎ ⲘⲠⲈⲚⲒⲠⲈ ⲈⲦⲞⲨⲎⲚ ⲈⲂⲞⲖ ⲈⲦⲠⲞⲖⲒⲤ ⲦⲀⲒ ⲆⲈ ⲀⲤⲞⲨⲰⲚ ⲚⲀⲨ ⲘⲀⲨⲀⲀⲤ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲠⲰϨ ϢⲀ ⲠϢⲞⲢⲠ ⲚϨⲒⲢ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲠⲀⲄⲄⲈⲖⲞⲤ ⲤⲀϨⲰϤ ⲈⲂⲞⲖ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈ ⲠⲈϤϨⲎⲦ ϢⲰⲠⲈ ⲘⲘⲞϤ. ⲠⲈϪⲀϤ ϪⲈ ⲦⲈⲚⲞⲨ ⲀⲒⲈⲒⲘⲈ ⲚⲀⲘⲈ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈⲚⲦⲀϤⲦⲚⲚⲞⲞⲨ ⲘⲠⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲀⲨⲰ ⲀϤⲚⲀϨⲘⲈⲦ ⲈⲂⲞⲖ ϨⲚ ⲦϬⲒϪ ⲚⲀⲄⲢⲒⲠⲠⲀⲤ. ⲀⲨⲰ ⲦⲈⲠⲢⲞⲤⲆⲞⲔⲒⲀ ⲦⲎⲢⲤ ⲘⲠⲖⲀⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲆⲈ ⲀϤⲂⲰⲔ ⲈⲢⲚ ⲠⲎⲒ ⲘⲘⲀⲢⲒⲀ ⲦⲘⲀⲀⲨ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ. ⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲞⲨⲘⲎⲎϢⲈ ⲚϨⲎⲦϤ ⲈⲨⲤⲞⲞⲨϨ ⲀⲨⲰ ⲈⲨϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ⲚⲦⲈⲢⲈϤⲦⲰϨⲘ ⲆⲈ ⲈⲢⲘ ⲠⲢⲞ ⲚⲐⲀⲈⲒⲦ. ⲀⲨϢⲈⲈⲢⲈ ϢⲎⲘ ⲈⲒ ⲈⲂⲞⲖ ⲈⲞⲨⲰϢⲂ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ϨⲢⲞⲆⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲤⲤⲞⲨⲚ ⲦⲈⲤⲘⲎ ⲘⲠⲈⲦⲢⲞⲤ ⲈⲂⲞⲖ ⲘⲠⲢⲀϢⲈ ⲘⲠⲤⲞⲨⲰⲚ ⲘⲠⲢⲞ. ⲀⲤⲠⲰⲦ ⲆⲈ ⲈϨⲞⲨⲚ ⲀⲤⲦⲀⲘⲞⲞⲨ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲀϨⲈⲢⲀⲦϤ ϨⲒⲢⲘ ⲠⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀⲤ ϪⲈ ⲈⲢⲈⲖⲞⲂⲈ. ⲚⲦⲞⲤ ⲆⲈ ⲀⲤⲦⲰⲔ ⲈϨⲞⲨⲚ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ. ⲠⲈϪⲀⲨ ⲚⲀⲤ ϪⲈ ⲠⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲘⲠϤⲖⲞ ⲈϤⲦⲰϨⲘ. ⲚⲦⲈⲢⲞⲨⲞⲨⲰⲚ ⲆⲈ ⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲰ ⲀⲨⲠⲰϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ⲀϤⲔⲒⲘ ⲆⲈ ⲚⲦⲈϤϬⲒϪ ⲈⲢⲞⲞⲨ ⲈⲦⲢⲈⲨⲔⲀⲢⲰⲞⲨ ⲀϤⲦⲀⲘⲞⲞⲨ ⲈⲐⲈ ⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲚⲦϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ. ⲀⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲦⲀⲘⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲀⲨⲰ ⲚⲈⲤⲚⲎⲨ ⲚⲀⲒ ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈⲨⲘⲀ ⲚϪⲀⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ⲚⲦⲈⲢⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ. ⲚⲈⲨⲚ ⲞⲨⲚⲞϬ ⲚϢⲦⲞⲢⲦⲢ ϢⲞⲞⲠ ϨⲚ ⲘⲘⲀⲦⲞⲒ. ϪⲈ ⲞⲨ ⲀⲢⲀ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲘⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϢⲒⲚⲈ ⲚⲤⲰϤ ⲘⲠϤϨⲈ ⲈⲢⲞϤ. ⲀϤⲀⲚⲀⲔⲢⲒⲚⲈ ⲚⲚⲀⲚⲞⲨⲢϢⲈ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϪⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲈⲦⲀⲔⲞⲞⲨ. ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲈϨⲢⲀⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ ⲀϤϢⲰⲠⲈ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ⲚⲈϤϬⲞⲚⲦ ⲆⲈ ⲈⲚⲢⲘⲚⲦⲨⲢⲞⲤ ⲘⲚ ⲤⲒⲆⲰⲚ ⲚⲦⲞⲞⲨ ⲆⲈ Ϩ ⲒⲞⲨⲤⲞⲠ ⲀⲨⲈⲒ ϢⲀⲢⲞϤ ⲀⲨⲰ ⲀⲨⲠⲒⲐⲈ ⲚϤⲖⲀⲤⲦⲞⲤ ⲠⲈⲦϨⲒϪⲘ ⲠⲔⲞⲒⲦⲰⲚ ⲘⲠⲢⲢⲞ ⲀⲨⲀⲒⲦⲒ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲨⲤⲀⲚϢ ⲚⲦⲈⲨⲬⲰⲢⲀ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ϨⲚ ⲞⲨϨⲞⲞⲨ ⲆⲈ ⲈⲀⲨⲦⲞϢϤ ⲀϨⲎⲢⲰⲆⲎⲤ ϮϨⲒⲰⲰϤ ⲚⲦⲈϤϨⲂⲤⲰ ⲚⲢⲢⲞ. ⲀⲨⲰ ⲀϤϨⲘⲞⲞⲤ ⲈⲠⲂⲎⲘⲀ. ⲀϤϮϨⲀⲠ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲤⲘⲎ ⲚⲚⲞⲨⲦⲈ ⲦⲈ. ⲀⲨⲰ ⲚⲞⲨⲤⲘⲎ ⲚⲢⲰⲘⲈ ⲀⲚ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϤⲠⲀⲦⲀⲤⲤⲈ ⲘⲘⲞϤ ⲚϬⲒ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ ⲈⲂⲞⲖ ϪⲈ ⲘⲠϤϮ ⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲀϤⲢϤⲚⲦ ⲀϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ⲠϢⲀϪⲈ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀϤⲀⲨⲜⲀⲚⲈ ⲀⲨⲰ ⲀϤⲀϢⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲘⲚ ⲤⲀⲨⲖⲞⲤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ⲈⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲀⲨϪⲒ ⲚⲘⲘⲀⲨ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ⲚⲈⲨϢⲞⲞⲠ ⲆⲈ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϨⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚϬⲒ ϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲚ ϨⲈⲚⲤⲀϨ ⲈⲦⲈ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲠⲈ ⲘⲚ ⲤⲨⲘⲈⲰⲚ ⲠⲈⲦⲞⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲚⲒⲄⲈⲢ ⲘⲚ ⲖⲞⲨⲔⲒⲞⲤ ⲠⲔⲨⲢⲎⲚⲀⲒⲞⲤ ⲀⲨⲰ ⲘⲀⲚⲀⲎⲚ ⲠⲤⲞⲚ ⲘⲘⲞⲞⲚⲈ ⲚϨⲎⲢⲰⲆⲎⲤ ⲠⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲀⲨⲰ ⲤⲀⲨⲖⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ⲈⲨϢⲘϢⲈ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲈⲨⲚⲎⲤⲦⲈⲨⲈ. ⲠⲈϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲚⲀⲨ ϪⲈ ⲠⲰⲢϪ ⲚⲀⲒ ⲈⲂⲞⲖ ⲚⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲤⲀⲨⲖⲞⲤ ⲈⲪⲰⲂ ⲚⲦⲀⲒⲦⲀϨⲘⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ⲦⲞⲦⲈ ⲀⲨⲚⲎⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲀⲨϢⲖⲎⲖ. ⲀⲨⲦⲀⲖⲈ ϬⲒϪ ⲈϪⲰⲞⲨ. ⲀⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨϪⲞⲞⲨⲤⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲦⲞⲨⲀⲀⲂ. ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲤⲈⲖⲈⲨⲔⲒⲀ. ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲤϬⲎⲢ ⲈϨⲢⲀⲒ ⲈⲔⲨⲠⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϢⲰⲠⲈ ϨⲚ ⲤⲀⲖⲀⲘⲒⲚⲀ ⲀⲨⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲚⲈⲨⲚⲦⲀⲨ ⲆⲈ ⲘⲘⲀⲨ ⲘⲠⲔⲈⲒⲰϨⲀⲚⲚⲎⲤ ⲈϤϢⲘϢⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ⲚⲦⲈⲢⲞⲨⲘⲞⲨϢⲦ ⲆⲈ ⲚⲦⲚⲎⲤⲞⲤ ⲦⲎⲢⲤ ϢⲀϨⲢⲀⲒ ⲈⲠⲀⲪⲞⲤ. ⲀⲨϨⲈ ⲈⲨⲢⲰⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲘⲀⲄⲞⲤ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ. ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲂⲀⲢⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ⲈϤϢⲞⲞⲠ ⲘⲚ ⲠⲀⲚⲐⲎⲠⲀⲦⲞⲤ ⲤⲈⲢⲔⲒⲞⲤ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲢⲰⲘⲈ ⲚⲢⲘⲚϨⲎⲦ ⲠⲀⲒ ⲀϤⲘⲞⲨⲦⲈ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲤⲀⲨⲖⲞⲤ ⲀϤϢⲒⲚⲈ ⲚⲤⲀ ⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ⲀϤϮ ⲆⲈ ⲞⲨⲂⲎⲨ ⲚϬⲒ ⲈⲖⲨⲘⲀⲤ ⲠⲘⲀⲄⲞⲤ. ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲈϢⲀⲨⲞⲨⲰϨⲘ ⲘⲠⲈϤⲢⲀⲚ. ⲈϤϢⲒⲚⲈ ⲚⲤⲀ ⲔⲦⲈ ⲠⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲠⲈ ⲀϤⲘⲞⲨϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲀϤⲈⲒⲰⲢⲘ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ");
INSERT INTO copshc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲠⲈⲦϪⲎⲔ ⲈⲂⲞⲖ ⲚⲔⲢⲞϤ ⲚⲒⲘ ⲀⲨⲰ ⲠⲈⲐⲞⲞⲨ ⲚⲒⲘ. ⲠϢⲎⲢⲈ ⲘⲠⲆⲒⲀⲂⲞⲖⲞⲤ ⲠϪⲀϪⲈ ⲚⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲒⲘ. ⲚⲄⲚⲀⲖⲞ ⲀⲚ ⲈⲔϬⲰⲰⲘⲈ ⲚⲚⲈϨⲒⲞⲞⲨⲈ ⲈⲦⲤⲞⲨⲦⲰⲚ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ⲦⲈⲚⲞⲨ ⲈⲒⲤ ⲦϬⲒϪ ⲘⲠϪⲞⲈⲒⲤ ⲚⲀϢⲰⲠⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲔ ⲀⲨⲰ ⲚⲄϢⲰⲠⲈ ⲚⲂⲖⲖⲈ ⲚⲄⲚⲀⲨ ⲈⲂⲞⲖ ⲀⲚ ⲈⲠⲢⲎ ϢⲀ ⲞⲨⲞⲈⲒϢ ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀϨⲈⲚϨⲂⲤ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲘⲚ ⲞⲨⲔⲀⲔⲈ ⲀⲨⲰ ⲚⲈϤⲘⲞⲞϢⲈ ⲈϤϢⲒⲚⲈ ⲚⲤⲀ ⲚⲈⲦⲚⲀϪⲒ ⲘⲞⲈⲒⲦ ϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ⲦⲞⲦⲈ ⲠⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲠⲈⲚⲦⲀϤϢⲰⲠⲈ. ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈϤⲠⲖⲎⲤⲤⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲤⲂⲰ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ⲚⲦⲈⲢⲈ ⲚⲀ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲤϬⲎⲢ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲪⲞⲤ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲈⲢⲄⲎ ⲚⲦⲠⲀⲘⲪⲨⲖⲒⲀ. ⲀⲒⲰϨⲀⲚⲚⲎⲤ ⲆⲈ ⲠⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ⲀϤⲔⲦⲞϤ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲢⲄⲎ. ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚⲦⲠⲒⲤⲒⲆⲒⲀ. ⲀⲨⲰ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲠⲈϨⲞⲞⲨ ⲚⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲨϨⲘⲞⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ⲘⲚⲚⲤⲀ ⲠⲰϢ ⲆⲈ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ⲀⲨϪⲞⲞⲨ ⲚϬⲒ ⲚⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲞⲤ ϢⲀⲢⲞⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ ⲈϢⲰⲠⲈ ⲞⲨⲚ ϢⲀϪⲈ ⲚⲤⲞⲠⲤ ⲚⲦⲈⲦⲎ ⲨⲦⲚ ⲀϪⲒⲤ ⲚⲚⲀϨⲢⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ⲀⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲦⲰⲞⲨⲚ ⲀϤⲔⲒⲘ ⲘⲚ ⲦⲈϤϬⲒϪ ⲈⲢⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲦⲈ ⲠⲒⲤⲢⲀⲎⲖ. ⲀⲨⲰ ⲚⲈⲦⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ⲠⲚⲞⲨⲦⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲀϤⲤⲰⲦⲠ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ. ⲀⲨⲰ ⲀϤϪⲒⲤⲈ ⲘⲠⲖⲀⲞⲤ ⲘⲠⲘⲀ ⲚϬⲞⲒⲖⲈ ϨⲘ ⲠⲔⲀϨ ⲚⲔⲎⲘⲈ. ⲀⲨⲰ ϨⲚ ⲞⲨϬⲂⲞⲒ ⲈϤϪⲞⲤⲈ ⲀϤⲚⲦⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ⲀϤⲤⲀⲚⲞⲨϢⲞⲨ ⲚϨⲘⲈ ⲚⲢⲞⲘⲠⲈ ϨⲒ ⲦⲈⲢⲎⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ⲀϤϤⲰⲦⲈ ⲈⲂⲞⲖ ⲚⲤⲀϢϤ ⲚϨⲈⲐⲚⲞⲤ ϨⲘ ⲠⲔⲀϨ ⲚⲬⲀⲚⲀⲀⲚ. ⲀϤϮ ⲠⲈⲨⲔⲀϨ ⲚⲀⲨ ⲚⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ⲚⲀϤⲦⲞⲨ ϢⲈ ⲦⲀⲒⲞⲨ ⲚⲢⲞⲘⲠⲈ. ⲀⲨⲰ ⲀϤϮ ⲚⲀⲨ ⲚⲔⲢⲎⲦⲎⲤ ϢⲀϨⲢⲀⲒ ⲈⲤⲀⲘⲞⲨⲎⲖ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ⲘⲚⲚⲤⲰⲤ ⲀⲨⲀⲒⲦⲒ ⲚⲞⲨⲢⲢⲞ. ⲀⲠⲚⲞⲨⲦⲈ ϮⲚⲀⲨ ⲚⲤⲀⲞⲨⲖ ⲠϢⲎⲢⲈ ⲚϬⲒⲤ. ⲞⲨⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲪⲨⲖⲎ ⲚⲂⲈⲚⲒⲀⲘⲈⲒⲚ ⲚϨⲘⲈ ⲚⲢⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲠⲞⲞⲚⲈϤ ⲀϤⲦⲞⲨⲚⲈⲤ ⲆⲀⲨⲈⲒⲆ ⲚⲀⲨ ⲈⲨⲢⲢⲞ. ⲠⲀⲒ ⲚⲦⲀϤⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒϨⲈ ⲈⲆⲀⲨⲈⲒⲆ ⲠϢⲎⲢⲈ ⲚⲒⲤⲤⲀⲒ ⲈϤⲚⲎⲨ ϨⲘ ⲠⲀϨⲎⲦ. ⲠⲀⲒ ⲈⲦⲚⲀⲈⲒⲢⲈ ⲚⲚⲀⲞⲨⲰϢ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ⲈⲂⲞⲖ ϬⲈ ϨⲘ ⲠⲈϤⲤⲠⲈⲢⲘⲀ ⲔⲀⲦⲀ ⲞⲨⲈⲢⲎⲦ. ⲀⲠⲚⲞⲨⲦⲈ ⲦⲞⲨⲚⲞⲤ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲘⲠⲤⲰⲦⲎ ⲢⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ⲈⲀ ⲒⲰϨⲀⲚⲚⲎⲤ ⲔⲎⲢⲨⲤⲤⲈ ϨⲀⲐⲎ ⲘⲠⲈϤⲈⲒ ⲈϨⲞⲨⲚ ⲚⲞⲨⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲖⲀⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ⲒⲰϨⲀⲚⲚⲎⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲈϤⲦⲢⲞⲘⲞⲤ ⲚⲈϤϪⲰ ⲘⲘⲞⲤ ⲠⲈ ⲚⲚⲀϨⲢⲘ ⲠⲘⲎⲎϢⲈ ϪⲈ ⲀϨⲢⲰⲦⲚ ⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲈⲢⲞⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϤⲚⲎⲨ ⲘⲚⲚⲤⲰⲒ ⲠⲀⲒ ⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲚⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲦⲞⲞⲨⲈ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ ⲚϢⲎⲢⲈ ⲘⲠⲄⲈⲚⲞⲤ ⲚⲀⲂⲢⲀϨⲀⲘ. ⲀⲨⲰ ⲚⲈⲦⲢϨⲞⲦⲈ ϨⲎⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨ ⲚⲀⲚ ⲘⲠϢⲀϪⲈ ⲘⲠⲈⲒⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ⲚⲈⲦⲞⲨⲎϨ ⲄⲀⲢ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ⲚⲈⲨⲀⲢⲬⲰⲚ ⲘⲠⲞⲨⲤⲞⲨⲰ ⲚⲠⲀⲒ. ⲀⲨⲰ ⲚⲈⲤⲘⲎ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲞⲨⲰϢ ⲘⲘⲞⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲘ. ⲀⲨⲔⲢⲒⲚⲈ ⲘⲘⲞⲞⲨ ⲀⲨϪⲞⲔⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ⲘⲠⲞⲨϬⲚ ⲖⲀⲀⲨ ⲆⲈ ⲚⲖⲞⲒϬⲈ ⲘⲘⲞⲨ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲀⲨⲀⲒⲦⲒ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ⲚⲦⲈⲢⲞⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲤⲎϨ ⲦⲎⲢⲞⲨ ⲈⲦⲂⲎⲦϤ. ⲀⲨⲞⲨⲀϨϤ ⲈϨⲢⲀⲒ ϨⲒ ⲠϢⲈ ⲀⲨⲔⲀⲀϤ ϨⲚ ⲞⲨⲦⲀⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ⲠⲀⲒ ⲚⲦⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϨⲀϨ ⲚϨⲞⲞⲨ ⲚⲚⲈⲚⲦⲀⲨⲂⲰⲔ ⲚⲘⲘⲀϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲄⲀⲖⲒⲖⲀⲒⲀ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲚⲀⲒ ⲦⲈⲚⲞⲨ ⲈⲨϢⲞⲞⲠ ⲚⲀϤ ⲘⲘⲚⲦⲢⲈ ⲚⲚⲀϨⲢⲘ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ⲀⲨⲰ ⲀⲚⲞⲚ ϨⲰⲰⲚ ⲦⲚⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲎⲦⲚ ⲘⲠⲈⲢⲎⲦ ⲚⲦⲀϤϢⲰⲠⲈ ⲚⲚⲀϨⲢⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲚⲈⲨϢⲎⲢⲈ ⲈⲀϤⲦⲞⲨⲚⲞⲤ ⲚⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲐⲈ ⲈⲦϤⲤⲎϨ ϨⲘ ⲠⲘⲈϨⲤⲚⲀⲨ ⲘⲮⲀⲖⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲀⲚⲞⲔ ⲀⲒϪⲠⲞⲔ ⲘⲠⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ϪⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚϤⲚⲀⲦⲤⲦⲞϤ ⲀⲚ ⲈⲠⲦⲀⲔⲞ. ⲀϤϪⲞⲞⲤ ⲚⲦⲈⲒϨⲈ ⲆⲈ ϮⲚⲀϮ ⲚⲎⲦⲚ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ ⲚⲆⲀⲨⲈⲒⲆ ⲈⲦⲚϨⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ϪⲈ ϤϪⲰ ⲘⲘⲞⲤ ⲞⲚ ϨⲚ ⲔⲈⲘⲀ. ϪⲈ ⲚⲚⲈⲔϮ ⲘⲠⲈⲔⲠⲈⲦⲞⲨⲀⲀⲂ ⲈⲦⲢⲈϤⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ⲆⲀⲨⲈⲒⲆ ⲘⲈⲚ ⲄⲀⲢ ϨⲚ ⲦⲈϤⲄⲈⲚⲈⲀ ⲀϤϢⲘϢⲈ ⲘⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ. ⲀϤⲚⲔⲞⲦⲔ. ⲀⲨⲞⲨⲀϨϤ ⲚⲚⲀϨⲢⲚ ⲚⲈϤⲈⲒⲞⲦⲈ ⲀⲨⲰ ⲀϤⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ⲠⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲦⲞⲨⲚⲞⲤϤ ⲘⲠϤⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ⲘⲀⲢⲈϤⲞⲨⲰⲚϨ ϬⲈ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ. ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲒⲎⲤⲞⲨⲤ ⲤⲈⲦⲀϢⲈⲞⲈⲒϢ ⲚⲎⲦⲚ ⲘⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ⲀⲨⲰ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲈⲘⲠⲈⲦⲚⲈϢϬⲘϬⲞⲘ ⲈⲦⲘⲀⲒⲞ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲀⲒ ⲤⲈⲚⲀⲦⲘⲀⲒⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ϬⲰϢⲦ ϬⲈ ⲘⲠⲢⲦⲢⲈ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ ϨⲒⲦⲘ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ϪⲈ ⲀⲚⲀⲨ ⲚⲔⲀⲦⲀⲪⲢⲞⲚⲒⲦⲎⲤ ⲚⲦⲈⲦⲚ ⲢϢⲠⲎⲢⲈ ⲚⲦⲈⲦⲚ ⲦⲀⲔⲞ. ϪⲈ ϮⲚⲀⲢ ⲞⲨϨⲰⲂ ⲀⲚⲞⲔ ϨⲚ ⲚⲈⲦⲚϨⲞⲞⲨ. ⲞⲨϨⲰⲂ ⲚⲚⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲈⲢϢⲀⲚⲞⲨⲀ ϪⲞⲞϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈⲦⲢⲈϤϪⲰ ⲈⲢⲞⲞⲨ ⲚⲚⲈⲒϢⲀϪⲈ ⲘⲠⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ⲚⲦⲈⲢⲈ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲆⲈ ⲦⲰⲚⲤ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚⲈⲠⲢⲞⲤⲎⲖⲨⲦⲞⲤ ⲈⲦϢⲘϢⲈ ⲚⲤⲀⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲀⲨⲠⲒⲐⲈ ⲘⲘⲞⲞⲨ ⲈⲦⲢⲈⲨϬⲰ ϨⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ϨⲘ ⲠⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲆⲈ ⲤⲬⲈⲆⲞⲚ ⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ. ⲀⲨⲤⲰⲞⲨϨ ⲈⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲘⲎⲎϢⲈ. ⲀⲨⲘⲞⲨϨ ⲚⲔⲰϨ. ⲀⲨⲰ ⲀⲨϮ ⲞⲨⲂⲈ ⲚⲈⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲞⲞⲨ ⲈⲨϪⲒⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲀⲨⲠⲀⲢⲢⲎ ⲤⲒⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲠⲈϪⲀⲨ ⲚⲀⲨ ϪⲈ ⲚⲈ ⲞⲨⲀⲚⲀⲄⲔⲀⲒⲞⲚ ⲠⲈ ⲈϪⲰ ⲚⲎⲦⲚ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚϢⲞⲢⲠ ⲈⲠⲈⲒⲆⲎ ⲦⲈⲦⲚⲚⲞⲨϪⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲘⲘⲰⲦⲚ ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲔⲢⲒⲚⲈ ⲘⲘⲰⲦⲚ ⲀⲚ ϪⲈ ⲦⲈⲦⲚⲘⲠϢⲀ ⲘⲠⲰⲚϨ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲚⲚⲀⲔⲦⲞⲚ ⲈϨⲢⲀⲒ ⲈⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲚⲦⲀ ⲦⲈⲄⲢⲀⲪⲎ ϪⲞⲞⲤ. ϪⲈ ⲀⲒⲔⲰ ⲘⲘⲞⲔ ⲚⲞⲨⲞⲈⲒⲚ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲢⲈⲔϢⲰⲠⲈ ⲈⲨⲞⲨϪⲀⲒ ϢⲀⲀⲢⲎϪϤ ⲘⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ⲚϨⲈⲐⲚⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲀⲨⲢⲀϢⲈ. ⲀⲨⲰ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲚϬⲒ ⲚⲈⲚⲦⲀⲨⲦⲞϢⲞⲨ ⲈⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ⲠϢⲀϪⲈ ⲆⲈ ⲘⲠϪⲞⲈⲒⲤ ⲚⲈϤⲘⲞⲞϢⲈ ϨⲚ ⲦⲈⲬⲰⲢⲀ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲀⲨⲦⲂⲤ ⲚⲈⲤϨⲒⲘⲈ ⲚⲢⲘⲘⲀⲞ ⲈⲦϢⲘϢⲈ ⲀⲨⲰ ⲚⲚⲞϬ ⲚⲢⲰⲘⲈ ⲚⲦⲠⲞⲖⲒⲤ ⲀⲨⲦⲞⲨⲚⲈⲤ ⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲀⲨⲰ ⲀⲨⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲦⲞϢ. ");
INSERT INTO copshc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲚⲈϨⲠϢⲞⲈⲒϢ ⲚⲚⲈⲨⲞⲨⲈⲢⲎ ⲦⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈϨⲒⲔⲞⲚⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲘⲞⲨϨ ⲚⲢⲀϢⲈ ϨⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲞⲚ ⲔⲀⲦⲀ ⲠⲈⲨⲤⲰⲚⲦ ⲈⲦⲢⲈⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲚⲤⲈϢⲀϪⲈ ⲚⲦⲈⲒϨⲈ. ϨⲰⲤⲦⲈ ⲚⲦⲈ ⲞⲨⲘⲎⲎϢⲈ ⲈⲚⲀϢⲰϤ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲦⲞⲞⲨ ⲈⲦⲈⲘⲠⲞⲨⲚⲀϨⲦⲈ ⲀⲨⲦⲰⲞⲨⲚ ⲀⲨⲘⲈⲔϨ ⲚⲈⲮⲨⲬⲎ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈϨⲞⲨⲚ ⲈⲚⲈⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ⲀⲨⲢ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲞⲨⲞⲈⲒϢ ⲘⲘⲀⲨ ⲈⲨⲠⲀⲢⲢⲎⲤⲒⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠϪⲞⲈⲒⲤ. ⲠⲀⲒ ⲈⲦⲢⲘⲚⲦⲢⲈ ⲘⲠϢⲀϪⲈ ⲚⲦⲈϤⲬⲀⲢⲒⲤ. ⲈⲦϮ ⲚϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲨϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ⲀⲠⲘⲎⲎϢⲈ ⲆⲈ ⲚⲦⲠⲞⲖⲒⲤ ⲠⲰϢ. ⲀⲨⲰ ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ⲘⲚ ⲚⲒⲞⲨⲆⲀⲒ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲘⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ⲚⲦⲈⲢⲞⲨϮ ⲘⲠⲈⲨⲞⲨⲞⲒ ⲆⲈ ⲚϬⲒ ⲚϨⲈⲐⲚⲞⲤ ⲘⲚ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲨⲰ ⲚⲈⲨⲀⲢⲬⲰⲚ. ⲈⲦⲢⲈⲨⲤⲞϢⲞⲨ ⲀⲨⲰ ⲚⲤⲈϨⲒⲰⲚⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ⲀⲨⲈⲒⲘⲈ ⲀⲨⲰ ⲀⲨⲠⲰⲦ ⲈϨⲢⲀⲒ ⲈⲘⲠⲞⲖⲒⲤ ⲚⲦⲖⲨⲔⲀⲞⲚⲒⲀ. ⲖⲨⲤⲆⲢⲀ ⲘⲚ ⲦⲈⲢⲂⲎ ⲀⲨⲰ ⲦⲠⲈⲢⲒⲬⲰⲢⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ⲀⲨⲰ ⲚⲈⲨⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ⲚⲈⲨⲚ ⲞⲨⲢⲰⲘⲈ ⲆⲈ ϨⲚ ⲖⲨⲤⲆⲢⲀ ⲚϬⲰⲂ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ⲈϤϨⲘⲞⲞⲤ ⲈⲨϬⲀⲖⲈ ⲠⲈ ϪⲒⲚ ⲚϨⲎⲦⲤ ⲚⲦⲈϤⲘⲀⲀⲨ ⲘⲠϤⲘⲞⲞϢⲈ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ⲠⲀⲒ ⲚⲈϤⲤⲰⲦⲘ ⲠⲈ ⲈⲠⲀⲨⲖⲞⲤ ⲈϤϢⲀϪⲈ. ⲚⲦⲞϤ ⲆⲈ ⲀϤⲈⲒⲰⲢⲘ ⲈϨⲞⲨⲚ ⲈϨⲢⲀϤ ⲀϤⲈⲒⲘⲈ ϪⲈ ⲞⲨⲚⲦϤ ⲠⲒⲤⲦⲒⲤ ⲘⲘⲀⲨ ⲈⲦⲢⲈϤⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ⲠⲈϪⲀϤ ⲚⲀϤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ϪⲈ ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲦⲰⲞⲨⲚ ⲚⲄⲀϨⲈⲢⲀⲦⲔ ϨⲒϪⲚ ⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ. ⲀⲨⲰ ⲀϤϤⲞϬϤ ⲀϤⲘⲞⲞϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ⲘⲘⲎⲎϢⲈ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲠⲈⲚⲦⲀ ⲠⲀⲨⲖⲞⲤ ⲀⲀϤ. ⲀⲨϤⲒ ϨⲢⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨⲀⲤⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲀ ⲚⲚⲞⲨⲦⲈ ⲈⲒⲚⲈ ⲚⲚⲢⲰⲘⲈ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ϢⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ⲀⲨⲰ ⲀⲨⲘⲞⲨⲦⲈ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ϪⲈ ⲠⲌⲈⲨⲤ. ⲠⲀⲨⲖⲞⲤ ⲆⲈ ϪⲈ ⲠϨⲢⲘⲎⲤ. ⲈⲠⲈⲒⲆⲎ ⲚⲦⲞϤ ⲠⲈ ⲚⲈⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲠⲈ ϨⲘ ⲠϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ⲠⲞⲨⲎⲎⲂ ⲆⲈ ⲘⲠⲌⲈⲨⲤ ⲈⲦⲘⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ. ⲀϤⲈⲒⲚⲈ ⲚϨⲈⲚⲘⲀⲤⲈ ⲘⲚ ϨⲈⲚⲔⲖⲞⲘ ⲈⲢⲚ ⲚⲢⲞ ⲘⲚ ⲘⲘⲎⲎϢⲈ. ⲀϤⲞⲨⲰϢ ⲈⲦⲀⲖⲈ ⲐⲨⲤⲒⲀ ⲈϨⲢⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲠⲀⲨⲖⲞⲤ. ⲀⲨⲠⲈϨ ⲚⲈⲨϨⲞⲈⲒⲦⲈ ⲀⲨⲰ ⲀⲨⲠⲰⲦ ⲈⲂⲞⲖ ⲈⲠⲘⲎⲎϢⲈ. ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲞⲨ ⲚⲈ ⲚⲀⲒ ⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀⲚⲞⲚ ϨⲰⲰⲚ ⲞⲚ ⲀⲚ ϨⲈⲚⲢⲰⲘⲈ ⲚⲦⲈⲦⲚ ϨⲈ ⲈⲚⲦⲀϢⲈⲞⲈⲒϢ ⲚⲎⲦⲚ ⲈⲤⲀϨⲈ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲚⲚⲈⲒⲠⲈⲦϢⲞⲨⲈⲒⲦ ⲈⲔⲦⲈ ⲦⲎⲨⲦⲚ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ ⲠⲀⲒ ⲚⲦⲀϤⲦⲀⲘⲒⲈ ⲦⲠⲈ ⲘⲚ ⲠⲔⲀϨ ⲘⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲰ ⲚⲈⲦⲚϨⲎⲦⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ⲠⲀⲒ ϨⲚ ⲚϪⲰⲘ ⲚⲦⲀⲨⲞⲨⲈⲒⲚⲈ. ⲀϤⲔⲰ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲢⲈⲨⲂⲰⲔ ϨⲚ ⲚⲈⲨϨⲒ ⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ⲔⲀⲒⲦⲞⲒ ⲞⲚ ⲘⲠϤϬⲰ ⲚⲞⲨⲈϢ ⲚⲢⲘⲚⲦⲢⲈ ⲘⲘⲞϤ ⲚⲀⲨ ⲈϤⲢⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲚⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈϤϮ ⲚϨⲈⲚϨⲰⲞⲨ ⲘⲚ ϨⲈⲚⲞⲨⲞⲒϢ ⲚⲢⲈϤϮⲔⲀⲢⲠⲞⲤ ⲈϤⲦⲤⲒⲞ ⲚⲚⲈⲨϨⲎⲦ ⲚⲦⲢⲨⲪⲎ ϨⲒ ⲞⲨⲚⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ⲚⲀⲒ ⲆⲈ ⲈⲨϪⲰ ⲘⲘⲞⲞⲨ ⲘⲞⲄⲒⲤ ⲀⲨⲦⲢⲈ ⲘⲘⲎⲎϢⲈ ⲈⲦⲘϢⲰⲰⲦ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ⲀⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲘⲚ ϨⲒⲔⲞⲚⲒⲞⲤ ⲚϬⲒ ϨⲈⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲠⲒⲐⲈ ⲚⲘⲘⲎⲎϢⲈ ⲀⲨϨⲒⲰⲚⲈ ⲈⲠⲀⲨⲖⲞⲤ ⲀⲨⲤⲨⲢⲢⲀ ⲘⲘⲞϤ ⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ. ⲈⲨⲘⲈⲈⲨⲈ ϪⲈ ⲀϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ⲚⲦⲈⲢⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲔⲰⲦⲈ ⲈⲢⲞϤ ⲚⲦⲈⲢⲈ ⲢⲞⲨϨⲈ ϢⲰⲠⲈ ⲀϤⲦⲰⲞⲨⲚ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲞⲖⲒⲤ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲦⲈⲢⲂⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ⲚⲦⲈⲢⲞⲨⲦⲀϢⲈⲞⲒϢ ⲆⲈ ⲚⲦⲠⲞⲖⲒⲤ ⲈⲦⲘⲘⲀⲨ. ⲀⲨⲰ ⲀⲨϮⲤⲂⲰ ⲚⲞⲨⲘⲎⲎϢⲈ. ⲀⲨⲔⲞⲦⲞⲨ ⲈϨⲢⲀⲒ ⲈⲖⲨⲤⲦⲢⲞⲤ ⲘⲚ ϨⲒⲔⲞⲚⲒⲞⲤ ⲘⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ⲈⲨⲦⲀϪⲢⲞ ⲚⲚⲈⲮⲨⲬⲎ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ. ⲈⲨⲤⲞⲠⲤ ⲘⲘⲞⲞⲨ ⲈⲦⲢⲈⲨϬⲰ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ⲀⲨⲰ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ϨⲀϨ ⲚⲐⲖⲒⲮⲒⲤ ⲈⲚⲀⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ⲀⲨⲤⲘⲒⲚⲈ ⲆⲈ ⲚⲀⲨ ⲚϨⲈⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲔⲀⲦⲀ ⲈⲔⲔⲖⲎⲤⲒⲀ. ⲀⲨϢⲖⲎⲖ ⲘⲚ ϨⲈⲚⲚⲎⲤⲦⲒⲀ ⲀⲨϮ ⲘⲘⲞⲞⲨ ⲈⲦⲞⲞⲦϤ ⲘⲠϪⲞⲈⲒⲤ ⲠⲀⲒ ⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲘⲞⲨϢⲦ ⲚⲦⲠⲎⲤⲒⲆⲒⲀ ⲀⲨⲈⲒ ⲈⲠⲈⲢⲄⲎ ⲚⲦⲠⲀⲘⲪⲨⲖⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϪⲈ ⲠϢⲀϪⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲂⲰⲔ ⲈⲀⲦⲦⲀⲖⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲤϬⲎⲢⲈϨⲢⲀⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ⲘⲠⲘⲀ ⲚⲦⲀⲨⲦⲀⲀⲨ ⲚϨⲎⲦϤ ϨⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲠϨⲰⲂ ⲚⲦⲀⲨϪⲞⲔϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲀⲨⲤⲰⲞⲨϨ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲀⲨϪⲰ ⲈⲢⲞⲞⲨ ⲚϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ⲚⲘⲘⲀⲨ. ⲀⲨⲰ ⲚⲐⲈ ⲚⲦⲀϤⲞⲨⲰⲚ ⲚⲞⲨⲢⲞ ⲘⲠⲒⲤⲦⲒⲤ ⲚⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ⲀⲨϢⲰⲠⲈ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲈⲒϢ ⲘⲚ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ⲀⲨⲰ ⲀϨⲞⲒⲚⲈ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲀⲨϮⲤⲂⲰ ⲚⲚⲈⲤⲚⲎⲨ. ϪⲈ ⲈⲒⲘⲎⲦⲒ ⲚⲦⲈⲦⲚ ⲤⲂⲂⲈⲦⲎⲨⲦⲚ. ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲘⲞⲞϢⲈ ϨⲘ ⲠⲤⲰⲚⲦ ⲘⲘⲰⲨⲤⲎⲤ ⲘⲚϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ⲚⲦⲈⲢⲈ ⲞⲨⲤⲦⲀⲤⲒⲤ ⲆⲈ ϢⲰⲠⲈ ⲘⲚ ⲞⲨⲚⲞϬ ⲚⲌⲎⲦⲎⲤⲒⲤ ⲘⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲘⲘⲀⲨ. ⲀⲨⲦⲈϢ ⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲀⲨⲰ ϨⲈⲚⲔⲈⲤⲚⲎⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲈⲦⲢⲈⲨⲂⲰⲔ ϢⲀ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲦϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲦⲂⲈ ⲠⲈⲒⲌⲎⲦⲎⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲐⲠⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲪⲞⲒⲚⲒⲔⲎ ⲘⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲨϪⲰ ⲘⲠⲈⲔⲦⲞ ⲚⲚϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲈⲨⲈⲒⲢⲈ ⲚⲞⲨⲚⲞϬ ⲚⲢⲀϢⲈ ϨⲚ ⲚⲈⲤⲚⲎⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨϢⲞⲠⲞⲨ ⲈⲢⲞⲞⲨ ⲈⲘⲀⲦⲈ ⲚϬⲒ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲦⲀⲘⲞⲞⲨ ⲆⲈ ⲈⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ⲚⲘⲘⲀⲨ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲆⲈ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲚⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲂⲞⲖ ϨⲚ ⲐⲀⲒⲢⲈⲤⲒⲤ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϢϢⲈ ⲈⲢⲞⲞⲨ ⲈⲦⲢⲈⲨⲤⲂⲂⲎ ⲦⲞⲨ. ⲀⲨⲰ ⲚⲤⲈⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲨ ⲈϨⲀⲢⲈϨ ⲈⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ⲀⲨⲤⲰⲞⲨϨ ⲆⲈ ⲚϬⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲚⲀⲨ ⲈⲦⲂⲈ ⲠⲈⲒϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲌⲎⲦⲎⲤⲒⲤ ϢⲰⲠⲈ ⲀⲠⲈⲦⲢⲞⲤ ⲦⲰⲞⲨⲚ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ϪⲒⲚ ⲚⲈϨⲞⲞⲨ ⲚϢⲞⲢⲠ ⲀⲠⲚⲞⲨⲦⲈ ⲤⲰⲦⲠ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲀⲦⲀⲠⲢⲞ ⲈⲦⲢⲈ ⲚϨⲈⲐⲚⲞⲤ ⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲤⲈⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲤⲞⲞⲨⲚ ⲚⲚϨⲎⲦ ⲀϤⲢⲘⲚⲦⲢⲈ. ⲈⲀϤϮ ⲚⲀⲨ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ⲔⲀⲦⲀ ⲐⲈ ϨⲰⲰⲚ ⲚⲦⲀϤⲦⲀⲀϤ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ⲀⲨⲰ ⲘⲠϤϮⲠⲰⲢϪ ⲖⲀⲀⲨ ⲞⲨⲦⲰⲚ ⲚⲘⲘⲀⲨ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲀϤⲦⲂⲂⲈ ⲚⲈⲨϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ⲦⲈⲚⲞⲨ ϬⲈ ⲈⲦⲂⲈ ⲞⲨ ⲦⲈⲦⲚⲠⲈⲒⲢⲀⲌⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲞⲨⲈϨ ⲞⲨⲚⲀϨⲂ ⲈϪⲘ ⲠⲘⲀⲔϨ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ. ⲠⲀⲒ ⲈⲦⲈⲘⲠⲈ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲚ ϢϬⲘϬⲞⲘ ⲈϤⲒ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲞⲨϪⲀⲒ. ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲞⲞⲨ ϨⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ⲀⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲔⲀⲢⲰⲞⲨ. ⲀⲨⲰ ⲀⲨϪⲒⲤⲘⲎ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲠⲀⲨⲖⲞⲤ. ⲈⲨⲦⲀⲨⲞ ⲚⲘⲘⲀⲈⲒⲚ ⲘⲚ ⲚⲈϢⲠⲎⲢⲈ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ⲘⲚⲚⲤⲀ ⲦⲢⲈⲨⲔⲀⲢⲰⲞⲨ ⲆⲈ ⲀⲒⲀⲔⲰⲂⲞⲤ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲈⲤⲚⲎⲨ ⲤⲰⲦⲘ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ⲤⲨⲘⲈⲰⲚ ⲀϤϪⲰ ⲈⲢⲞⲚ ⲚⲐⲈ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ϬⲘⲠϢⲒⲚⲈ ϪⲒⲚⲚ ϢⲞⲢⲠ. ⲈϪⲒ ⲞⲨⲖⲀⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲘⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ⲀⲨⲰ ⲚϢⲀϪⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲤⲨⲘⲪⲰⲚⲒ ⲚⲦⲈⲒϨⲈ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ");
INSERT INTO copshc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ϪⲈ ⲘⲚⲚⲤⲀ ⲚⲀⲒ ϮⲚⲀⲔⲦⲞⲒ ⲦⲀⲔⲰⲦ ⲚⲦⲈⲤⲔⲨⲚⲎ ⲚⲆⲀⲨⲈⲒⲆ ⲦⲈⲚⲦⲀⲤϨⲈ ⲀⲨⲰ ϮⲚⲀⲔⲰⲦ ⲚⲚⲈⲚⲦⲀⲨϢⲞⲢϢⲢ ⲚϨⲎⲦⲤ ⲀⲨⲰ ⲦⲀⲦⲀϨⲞⲤ ⲈⲢⲀⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲚⲚⲢⲰⲘⲈ ϢⲒⲚⲈ ⲚⲤⲀ ⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲦⲀⲨⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲀⲢⲀⲚ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ⲠⲈⲦⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲀⲒ ϪⲒⲚ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲚⲞⲔ ϨⲰ ϮⲔⲢⲒⲚⲈ ⲈⲦⲘϮϨⲒⲤⲈ ⲚⲚⲈⲦⲔⲰⲦ ⲘⲘⲞⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ⲀⲖⲖⲀ ⲤϨⲀⲒ ⲚⲀⲨ ⲈⲦⲢⲈⲨⲤⲀϨⲰⲞⲨ ⲈⲂⲞⲖ ⲚⲚϪⲰ ϨⲘ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲀⲨⲰ ⲦⲠⲞⲢⲚⲈⲒⲀ ⲘⲚ ⲞⲨⲚⲔⲀ ⲈϤⲘⲞⲞⲨⲦ ⲀⲨⲰ ⲠⲈⲤⲚⲞϤ ⲀⲨⲰ ⲠⲈⲦⲈⲚⲤⲈⲞⲨⲀϢϤ ⲀⲚ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲘⲘⲞⲞⲨ ⲈⲦⲘⲦⲢⲈⲨⲀⲀϤ ⲚϬⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ϪⲒⲚ ⲚⲄⲈⲚⲈⲀ ⲚⲚⲀⲢⲬⲀⲒⲞⲚ. ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲚⲈⲦⲔⲎⲢⲨⲤⲤⲈ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ. ϨⲢⲀⲒ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲨⲰϢ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ⲦⲞⲦⲈ ⲀⲤⲚⲆⲞⲔⲒ ⲚⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲈⲦⲢⲈⲨⲤⲰⲦⲠ ⲚϨⲈⲚⲢⲰⲘⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲤⲈϪⲞⲞⲨⲤⲈ ⲈϨⲢⲀⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲘⲚ ⲠⲀⲨⲖⲞⲤ ⲀⲨⲰ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲦⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲤⲀⲂⲀⲤ ⲀⲨⲰ ⲤⲒⲖⲀⲤ ϨⲈⲚⲢⲰⲘⲈ ⲚⲚⲞϬ ϨⲚ ⲚⲈⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ⲈⲀⲨⲤϨⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲚⲞⲨⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲈⲒϨⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲨⲤϨⲀⲒ ⲚⲚⲈⲤⲚⲎⲨ ⲈⲦϨⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲘⲚ ⲦⲤⲨⲢⲒⲀ ⲘⲚ ⲦⲔⲨⲖⲒⲔⲒⲀ ⲚⲈⲦϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲬⲀⲒⲢⲈⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ⲈⲠⲈⲒⲆⲎ ⲀⲚⲤⲰⲦⲘ ϪⲈ ⲀϨⲞⲒⲚⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲚ ⲈⲒ ϢⲀⲢⲰⲦⲚ ⲀⲨϢⲦⲢⲦⲢ ⲦⲎⲨⲦⲚ ϨⲚ ϨⲈⲚϢⲀϪⲈ ⲈⲨϮⲘⲔⲀϨ ⲚⲚⲈⲦⲘⲮⲨⲬⲎ ⲘⲠⲚϨⲰⲚ ⲈⲦⲞⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ⲀⲤⲚⲆⲞⲔⲒ ⲚⲀⲚ ⲈⲀⲚⲈⲒ ⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ϨⲒ ⲞⲨⲤⲞⲠ ⲈⲦⲢⲈⲚⲤⲰⲦⲠ ⲚϨⲈⲚⲢⲰⲘⲈ ⲚⲦⲚⲦⲀⲨⲞⲞⲨ ϢⲀⲢⲰⲦⲚ. ⲘⲚ ⲚⲈⲚⲘⲈⲢⲀⲦⲈ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ϨⲈⲚⲢⲰⲘⲈ ⲈⲀⲨϮ ⲚⲚⲈⲨⲮⲨⲬⲎ ϨⲀ ⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ⲀⲚⲦⲚⲚⲞⲞⲨ ⲆⲈ ⲚⲒⲞⲨⲆⲀⲤ ⲘⲚ ⲤⲒⲖⲀⲤ. ⲚⲦⲞⲞⲨ ϨⲰⲞⲨ ⲞⲚ ϨⲒⲦⲘ ⲠϢⲀϪⲈ ⲈⲨⲚⲀϪⲰ ⲚⲎⲦⲚ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ⲀⲤⲚⲆⲞⲔⲒ ⲄⲀⲢ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲀⲨⲰ ⲚⲀⲚ. ⲈⲦⲘⲦⲀⲖⲈ ⲖⲀⲀⲨ ⲚⲂⲀⲢⲞⲤ ⲈϪⲚ ⲦⲎⲨⲦⲚ ⲚⲤⲀ ⲚⲀⲒ ϨⲚ ⲞⲨϨⲦⲞⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ⲈⲤⲀϨⲈ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ⲚϢⲰⲰⲦ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲘⲚ ⲠⲈⲤⲚⲞϤ ⲘⲚ ⲚⲈϢⲀⲨⲘⲞⲨ ⲀⲨⲰ ⲦⲠⲞⲢⲚⲈⲒⲀ ⲘⲚ ⲚⲈⲦⲈⲦⲚⲞⲨⲀϢⲞⲨ ⲀⲚ ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲘⲘⲰⲦⲚ ⲘⲠⲢⲀⲀⲨ ⲚϬⲈ ⲚⲀⲒ ⲈⲦⲈⲦⲚϢⲀⲚϨⲀⲢⲈϨ ⲈⲢⲰⲦⲚ ⲈⲢⲞⲞⲨ ⲦⲈⲦⲚⲀⲢϢⲀⲨ ⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ⲀⲨⲤⲈⲨϨ ⲠⲘⲎⲎϢⲈ. ⲀⲨϮ ⲚⲀⲨ ⲚⲦⲈⲠⲒⲤⲦⲞⲖⲎ ");
INSERT INTO copshc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲞϢⲤ ⲀⲨⲢⲀϢⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲤⲞⲠⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ⲒⲞⲨⲆⲀⲤ ⲆⲈ ⲘⲚ ⲤⲒⲖⲀⲤ ϨⲈⲚⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲰⲞⲨ ⲚⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ϨⲀϨ ⲚϢⲀϪⲈ. ⲀⲨⲤⲈⲠⲤ ⲚⲈⲤⲚⲎⲨ ⲀⲨⲰ ⲀⲨⲦⲀϪⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ⲚⲦⲈⲢⲞⲨⲢⲞⲨⲞⲈⲒϢ ⲆⲈ ⲀⲨϪⲞⲞⲨⲤⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲤⲚⲎⲨ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϢⲀ ⲚⲈⲚⲦⲀⲨⲦⲀⲞⲨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ⲀⲤⲚⲆⲞⲔⲒ ⲆⲈ ⲚⲤⲒⲖⲀⲤ ⲈⲦⲢⲈϤϬⲰ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ϨⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ⲈⲨϮⲤⲂⲰ ⲀⲨⲰ ⲈⲨⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲘⲚ ϨⲈⲚⲔⲈⲘⲎⲎϢⲈ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ⲘⲚⲚⲤⲀ ϨⲈⲚϨⲞⲞⲨ ⲆⲈ ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲂⲀⲢⲚⲀⲂⲀⲤ ϪⲈ ⲘⲀⲢⲚⲔⲞⲦⲚ ⲚⲦⲚϬⲘⲠϢⲒⲚⲈ ⲚⲚⲈⲤⲚⲎⲨ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ ⲚⲒⲘ. ⲚⲀⲒ ⲚⲦⲀⲚⲦⲀϢⲈⲞⲈⲒϢ ⲚⲀⲨ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ϪⲈ ⲤⲈⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲚⲈϤⲞⲨⲰϢ ⲈϪⲒ ⲚⲘⲘⲀϤ ⲚⲒⲰϨⲀⲚⲚⲎⲤ ⲠⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈϤⲀⲜⲒⲞⲨ ⲈⲦⲘϪⲒ ⲠⲈⲚⲦⲀϤⲠⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ϪⲒⲚ ⲚⲦⲠⲀⲘⲪⲨⲖⲒⲀ ⲘⲠϤⲂⲰⲔ ⲚⲘⲘⲀⲨ ⲘⲪⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ⲀⲨⲠⲀⲢⲞⲜⲨⲤⲘⲞⲤ ⲆⲈ ϢⲰⲠⲈ. ϨⲰⲤⲦⲈ ⲚⲤⲈⲤⲀϨⲰⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲈⲢⲎⲨ. ⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲈⲚ ⲀϤϪⲒ ⲘⲘⲀⲢⲔⲞⲤ ⲀϤⲤϬⲎⲢ ⲈϨⲢⲀⲒ ⲈⲔⲨⲠⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲤⲰⲦⲠ ⲚⲤⲒⲖⲀⲤ. ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈⲨϮ ⲘⲘⲞϤ ⲚⲦⲈⲬⲀⲢⲒⲤ ⲘⲠϪⲞⲈⲒⲤ ϨⲒⲦⲚ ⲚⲈⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ⲀϤⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲦⲤⲨⲢⲒⲀ ⲘⲚ ⲦⲔⲒⲖⲒⲔⲒⲀ. ⲀϤⲦⲀϪⲢⲞ ⲚⲚⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ⲀⲨⲰ ⲀϤⲔⲀⲦⲀⲚⲦⲀ ⲈⲆⲈⲢⲂⲎ ⲘⲚ ⲖⲨⲤⲦⲢⲀ. ⲚⲈⲨⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲘⲘⲀⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲈⲠϢⲎⲢⲈ ⲠⲈ ⲚⲞⲨⲤϨⲒ ⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲠⲒⲤⲦⲎ. ⲠⲈϤⲈⲒⲰⲦ ⲆⲈ ⲞⲨⲈⲒⲈⲚⲒⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ⲠⲀⲒ ⲚⲈⲨⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲤⲚⲎⲨ ⲈⲦϨⲚ ⲖⲨⲤⲆⲢⲞⲤ ⲘⲚ ϨⲒⲔⲞⲚⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ⲠⲀⲒ ⲀⲠⲀⲨⲖⲞⲤ ⲞⲨⲰϢ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ⲚⲘⲘⲀϤ. ⲀⲨⲰ ⲀϤϪⲒⲦϤ ⲀϤⲤⲂⲂⲎⲦϤ ⲈⲦⲂⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲦϢⲞⲞⲠ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲚⲈⲨⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ϪⲈ ⲞⲨⲈⲈⲒⲈⲚⲒⲚ ⲠⲈ ⲠⲈϤⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ⲚⲈⲨⲚⲎⲨ ⲆⲈ ⲈⲂⲞⲖ ⲠⲈ ϨⲒⲦⲚ ⲘⲠⲞⲖⲒⲤ ⲈⲨϮ ⲈⲦⲞⲞⲦⲞⲨ ⲈⲦⲢⲈⲨϨⲀⲢⲈϨ ⲈⲚⲆⲞⲄⲘⲀ ⲚⲦⲀⲨⲔⲢⲒⲚⲈ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲦϨⲚⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ϬⲈ ⲚⲈⲨⲦⲀϪⲢⲞ ⲠⲈ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲀⲨⲰ ⲚⲈⲨⲢϨⲞⲨⲞ ϨⲚ ⲦⲎⲠⲈ ⲘⲘⲎⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ⲀⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲪⲢⲨⲄⲒⲀ ⲘⲚ ⲦⲈⲬⲰⲢⲀ ⲚⲦⲄⲀⲖⲀⲦⲒⲀ. ⲈⲀⲨⲔⲰⲖⲨ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲦⲘϪⲈ ⲠϢⲀϪⲈ ϨⲚ ⲦⲀⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲦⲘⲨⲤⲒⲀ ⲀⲨⲠⲈⲒⲢⲀⲌⲈ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲂⲨⲐⲨⲚⲒⲀ. ⲀⲨⲰ ⲘⲠϤⲔⲀⲀⲨ ⲚϬⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲤⲀⲀⲦ ⲦⲘⲨⲤⲒⲀ ⲀⲨⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲈⲦⲢⲰⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ⲀⲨϨⲞⲢⲞⲘⲀ ϬⲰⲖⲠ ⲈⲂⲞⲖ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲦⲈⲨϢⲎ. ⲈϢϪⲈ ⲈⲢⲈ ⲞⲨⲢⲰⲘⲈ ⲘⲘⲀⲔⲈⲆⲰⲚ ⲀϨⲈⲢⲀⲦϤ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ ⲈϤⲤⲞⲠⲤ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲘⲞⲨ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚⲄⲂⲞⲎⲐⲒ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ⲚⲦⲈⲢⲈϤⲦⲰⲞⲨⲚ ⲆⲈ ⲀϤϪⲰ ⲈⲢⲞⲚ ⲘⲠϨⲞⲢⲞⲘⲀ ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲚϢⲒⲚⲈ ⲚⲤⲀⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲈⲚⲦⲀⲘⲞ ⲘⲘⲞⲞⲨ ϪⲈ ⲀⲠϪⲞⲈⲒⲤ ⲦⲀϨⲘⲚ ⲈⲦⲀϢⲈⲞⲈⲒϢ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ⲚⲦⲈⲢⲈⲚⲔⲰ ⲆⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲢⲰⲀⲤ ⲀⲚⲤϬⲎⲢ ⲈⲤⲀⲘⲞⲐⲢⲀⲔⲎ. ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲈⲚⲈⲀⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲞⲨⲠⲞⲖⲒⲤ ϪⲈ ⲔⲀⲖⲞⲚⲒⲀ. ⲈⲦⲈⲦⲀⲒ ⲦⲈ ⲦϢⲞⲢⲠ ⲚⲦⲘⲈⲢⲒⲤ ⲚⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ⲚⲈⲚϢⲞⲞⲠ ⲆⲈ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ ⲚϨⲈⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ⲘⲠⲈϨⲞⲞⲨ ⲆⲈ ⲚⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲚⲈⲒ ⲈⲂⲞⲖ ⲠⲂⲞⲖ ⲚⲦⲠⲨⲖⲎ ⲈϪⲘ ⲠⲒⲈⲢⲞ ⲈⲨⲘⲀ ⲈϢⲀⲚϢⲖⲎⲖ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲀⲚϨⲘⲞⲞⲤ ⲀⲚϢⲀϪⲈ ⲘⲚ ⲚⲈϨⲒⲞⲘⲈ ⲚⲦⲀⲨⲈⲒ ⲈⲂⲞⲖ ϢⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ⲈⲨⲚ ⲞⲨⲤϨⲒⲘⲈ ⲆⲈ ⲤⲰⲦⲘ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲖⲨⲆⲒⲀ ⲞⲨⲤⲀⲚϪⲎϬⲈ ⲚⲦⲈ ⲦⲠⲞⲖⲒⲤ ⲚⲐⲨⲀⲦⲒⲢⲀ ⲈⲤϢⲘϢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀⲒ ⲈⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲞⲨⲰⲚ ⲘⲠⲈⲤϨⲎⲦ ⲈⲦⲢⲈⲤϮϨⲦⲎⲤ ⲈⲚⲈⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ⲚⲦⲈⲢⲈⲤϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲆⲈ ⲚⲦⲞⲤ ⲀⲨⲰ ⲠⲈⲤⲎⲒ ⲀⲤⲤⲈⲠⲤⲰⲠⲚ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢϪⲈ ⲀⲦⲈⲦⲚⲔⲢⲒⲚⲈ ⲈⲀⲀⲦ ⲘⲠⲒⲤⲦⲎ ⲘⲠϪⲞⲈⲒⲤ ⲀⲘⲎⲒⲦⲚ ⲈϨⲞⲨⲚ ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ϨⲘ ⲠⲀⲎⲒ ⲀⲨⲰ ⲀⲤⲤⲰⲔ ⲘⲘⲞⲚ ⲚϪⲚⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈⲚⲀⲂⲰⲔ ⲈϢⲖⲎⲖ. ⲞⲨϢⲈⲈⲢⲈ ϢⲎⲘ ⲈⲢⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲢⲈϤϢⲒⲚⲈ ϨⲒⲰⲰⲤ ⲀⲤⲦⲰⲘⲚⲦ ⲈⲢⲞⲚ. ⲦⲀⲒ ⲈⲚⲈⲤϮ ⲚϨⲈⲚⲚⲞϬ ⲚϨⲞⲘⲚⲦ ⲚⲚⲈⲤϪⲒⲤⲞⲞⲨⲈ ⲈⲤϢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ⲦⲀⲒ ⲆⲈ ⲚⲈⲀⲤⲞⲨⲀϨⲤ ⲚⲤⲀ ⲠⲀⲨⲖⲞⲤ ⲚⲘⲘⲀⲚ ⲀⲤⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲒⲢⲰⲘⲈ ⲚϨⲘϨⲀⲖ ⲚⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦϪⲞⲤⲈ ⲈⲨⲦⲀϢⲈⲞⲈⲒϢ ⲚⲀⲚ ⲚⲦⲈϨⲒⲎ ⲘⲠⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ⲠⲀⲒ ⲆⲈ ⲈⲚⲈⲤⲈⲒⲢⲈ ⲘⲘⲞϤ ⲠⲈ ⲚϨⲀϨ ⲚϨⲞⲞⲨ ⲚⲦⲈⲢⲈϤϨⲞϪϨϪ ⲆⲈ ⲚϬⲒ ⲠⲀⲨⲖⲞⲤ ⲀϤⲔⲦⲞϤ ⲠⲈϪⲀϤ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ϪⲈ ϮⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀⲔ ϨⲘ ⲠⲢⲀⲚ ⲚⲒⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲢⲈⲔⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲚϬⲒ ⲚⲈⲤϪⲒⲤⲞⲞⲨⲈ ϪⲈ ⲀⲤⲂⲰⲔ ⲚⲦⲞⲞⲦⲞⲨ ⲚϬⲒ ⲐⲈⲖⲠⲒⲤ ⲘⲠⲈⲨϨⲰⲂ. ⲀⲨⲀⲘⲀϨⲦⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲤⲒⲖⲀⲤ ⲀⲨⲤⲰⲔ ⲘⲘⲞⲞⲨ ⲈⲦⲀⲄⲞⲢⲀ ⲚⲚⲀϨⲢⲚ ⲚⲀⲢⲬⲰⲚ ");
INSERT INTO copshc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ⲀⲨⲰ ⲀⲨϪⲒⲦⲞⲨ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲈⲤⲦⲢⲀⲦⲎ ⲄⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲒⲢⲰⲘⲈ ϨⲈⲚⲒⲞⲨⲆⲀⲒ ⲚⲈ. ⲤⲈϢⲦⲞⲢⲦⲢ ⲚⲦⲈⲒⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ⲀⲨⲰ ⲤⲈⲦⲀϢⲈⲞⲒϢ ⲚϨⲈⲚⲤⲰⲚⲦ ⲚⲤⲦⲞ ⲚⲀⲚ ⲀⲚ ⲈϪⲒⲦⲞⲨ ⲎⲈⲀⲀⲨ ⲈⲀⲚⲞⲚ ϨⲈⲚϨⲢⲰⲘⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ⲀⲠⲘⲎⲎϢⲈ ⲆⲈ ⲠⲰⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ⲀⲨⲰ ⲚⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲀⲨⲠⲈϨ ⲚⲈⲨϨⲞⲒ ⲦⲈ. ⲀⲨⲰ ⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϨⲒⲞⲨⲈ ⲈⲢⲞⲞⲨ ⲚϨⲈⲚϬⲈⲢⲞⲞⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϪⲚⲀⲨ ϨⲀϨ ⲚⲤⲎϢⲈ ⲀⲨⲚⲞϪⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ. ⲈⲀⲨⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲘⲠⲈⲦϨⲒ ϪⲘ ⲠⲈϢⲦⲈⲔⲞ ⲈϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ϨⲚ ⲞⲨⲰⲢϪ. ");
INSERT INTO copshc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ⲚⲦⲞϤ ⲆⲈ ⲀϤϪⲒ ⲚⲞⲨⲠⲀⲢⲀⲄⲄⲈⲖⲒⲀ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲀϤⲚⲞϪⲞⲨ ⲈⲠⲈϢⲦⲈⲔⲞ ⲈⲦϨⲒϨⲞⲨⲚ. ⲀⲨⲰ ⲚⲈⲨⲞⲨⲈⲢⲎⲦⲈ ⲀϤⲦⲀϪⲢⲞⲞⲨ ϨⲚ ⲞⲨϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ϨⲚ ⲦⲠⲀϢⲈ ⲆⲈ ⲚⲦⲈⲨϢⲎ ⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲤⲒⲖⲀⲤ ⲚⲈⲨϢⲖⲎⲖ ⲠⲈ. ⲀⲨⲰ ⲚⲈⲨⲤⲘⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ. ⲚⲈⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲢⲞⲞⲨ ⲚϬⲒ ⲚⲈⲦⲘⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ⲀⲨⲰ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲀⲨⲚⲞϬ ⲚⲔⲘⲦⲞ ϢⲰⲠⲈ ϨⲰⲤⲦⲈ ⲚⲤⲈⲚⲞⲈⲒⲚ ⲚϬⲒ ⲚⲤⲚⲦⲈ ⲘⲠⲈϢⲦⲈⲔⲞ ⲀⲚⲢⲞ ⲆⲈ ⲦⲎⲢⲞⲨ ⲞⲨⲰⲚ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨⲰ ⲘⲘⲢⲢⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲨⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ⲀϤⲦⲰⲞⲨⲚ ⲆⲈ ⲚϬⲒ ⲠⲈⲦϨⲒϪⲘ ⲠⲈϢⲦⲈⲔⲞ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲚⲀⲨ ⲈⲚⲢⲞ ⲘⲠⲈϢⲦⲈⲔⲞ ⲈⲨⲞⲨⲎⲚ. ⲀϤⲦⲈⲔⲘ ⲦⲈϤⲤⲎϤⲈ ⲀϤⲈⲒ ⲈϤⲚⲀϨⲞⲦⲂⲈϤ ⲈϤⲘⲈⲈⲨⲈ ϪⲈ ⲀⲚⲈⲦⲘⲎⲢ ⲠⲰⲦ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢⲢ ⲖⲀⲀⲨ ⲚⲀⲔ ⲘⲠⲈⲐⲞⲞⲨ. ⲦⲚⲘⲠⲈⲒⲘⲀ ⲄⲀⲢ ⲦⲎⲢⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ⲀϤϪⲒ ⲆⲈ ⲚⲞⲨⲔⲰϨⲦ ⲀϤⲠⲰⲦ ⲈϨⲞⲨⲚ ⲀⲨⲰ ⲀϤⲠⲀϨⲦϤ ϨⲀⲢⲀⲦϤ ⲘⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲤⲒⲖⲀⲤ ⲈϤⲤⲦⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ⲀⲨⲰ ⲀϤⲚⲦⲞⲨ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲀϪⲒⲤⲞⲞⲨⲈ. ⲞⲨ ⲠⲈⲦⲈϢϢⲈ ⲈⲢⲞⲒ ⲈⲀⲀϤ ϪⲈ ⲈⲒⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ⲚⲦⲞⲞⲨ ϬⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲔⲚⲀⲞⲨϪⲀⲒ ⲚⲦⲞⲔ ⲀⲨⲰ ⲠⲈⲔⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ⲀⲨⲰ ⲀⲨϪⲰ ⲈⲢⲞϤ ⲘⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦϨⲘ ⲠⲈϤⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ⲀϤϪⲒⲦⲞⲨ ⲆⲈ ⲘⲠⲚⲀⲨ ⲈⲦⲘⲘⲀⲨ ⲚⲦⲈⲨϢⲎ. ⲀϤϪⲞⲔⲘⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲨⲤⲎϢⲈ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲦⲞϤ ⲘⲚ ⲚⲈⲦⲈⲚⲞⲨϤ ⲦⲎⲢⲞⲨ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ⲀϤϪⲒⲦⲞⲨ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲠⲈϤⲎⲒ. ⲀϤⲔⲰ ϨⲀⲢⲰⲞⲨ ⲚⲞⲨⲦⲢⲀⲠⲈⲌⲀ ⲀⲨⲰ ⲚⲈϤⲦⲈⲖⲎⲖ ⲠⲈ ⲈⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ ⲘⲚ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ⲚⲦⲈⲢⲈϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀⲚⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ϪⲞⲞⲨ ⲚϨⲈⲚϤⲀⲒϢⲂⲰⲦ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀⲚⲈⲒⲢⲰⲘⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ⲀⲨⲰ ⲀⲠⲈⲦϨⲒϪⲘ ⲠⲈϢⲦⲈⲔⲞ ⲦⲀⲘⲈ ⲠⲀⲨⲖⲞⲤ ⲈⲚⲈⲒϢⲀϪⲈ. ϪⲈ ⲀⲚⲈⲤⲦⲢⲀⲦⲎⲄⲞⲤ ⲦⲀⲨⲞⲞⲨ ⲈⲔⲀⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ. ⲦⲈⲚⲞⲨ ϬⲈ ⲀⲘⲎⲒⲦⲚ ⲂⲰⲔ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲀⲨϨⲒ ⲞⲨⲈ ⲈⲢⲞⲚ ⲆⲎⲘⲞⲤⲒⲀ ⲈⲀⲚⲞⲚ ϨⲈⲚⲢⲰⲘⲈ ⲚϨⲢⲰⲘⲀⲒⲞⲤ ⲈⲘⲚ ⲚⲞⲂⲈ ⲈⲢⲞⲚ ⲀⲨⲚⲞϪⲚ ⲈⲠⲈϢⲦⲈⲔⲞ ⲦⲈⲚⲞⲨ ϬⲈ ⲤⲈⲚⲞⲨϪⲈ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲚϪⲒⲞⲨⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲘⲀⲢⲞⲨⲈⲒ ⲚⲦⲞⲞⲨ ⲚⲤⲈⲚⲦⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ⲀⲚⲀⲚⲞⲨⲢϢⲈ ⲆⲈ ⲦⲀⲘⲈ ⲚⲈⲤⲦⲢⲀⲦⲎ ⲄⲞⲤ ⲈⲚⲈⲒϢⲀϪⲈ. ⲀⲨⲰ ⲀⲨⲢϨⲞⲦⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ϪⲈ ϨⲈⲚϨⲢⲰⲘⲀⲒⲞⲤ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ⲀⲨⲈⲒ ⲆⲈ ⲀⲨⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲚⲦⲞⲨ ⲈⲂⲞⲖ. ⲀⲨⲤⲈⲠⲤⲰⲠⲞⲨ ⲈⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈϢⲦⲈⲔⲞ ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲖⲨⲆⲒⲀ. ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲚⲈⲤⲚⲎⲨ ⲀⲨⲤⲈⲠⲤⲰⲠⲞⲨ ⲀⲨⲈⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ⲀⲨⲘⲞⲨϢⲦ ⲆⲈ ⲚⲦⲀⲘⲪⲒⲠⲞⲖⲒⲤ ⲀⲨⲰ ⲦⲀⲠⲞⲖⲰⲚⲒⲀ. ⲀⲨⲈⲒ ⲈⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ. ⲠⲘⲀ ⲈⲚⲈⲢⲈ ⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ⲔⲀⲦⲀ ⲠⲤⲰⲚⲦ ⲆⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲢⲞⲞⲨ. ⲀⲨⲰ ⲀϤⲢ ϢⲞⲘⲚⲦ ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ");
INSERT INTO copshc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ⲈϤⲂⲰⲖ ⲘⲘⲞⲞⲨ ⲈϤⲦⲀⲘⲞ ⲘⲘⲞⲞⲨ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ϪⲈ ϨⲀⲠⲤ ⲈⲦⲢⲈϤⲘⲞⲨ ⲀⲨⲰ ⲚϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲀⲨⲰ ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲠⲀⲒ ⲈϮⲦⲀϢⲈⲞⲈⲒϢ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ϨⲞⲒⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲀⲨⲠⲒⲐⲈ ⲀⲨⲰ ⲀⲨⲞⲨⲀϨⲞⲨ ⲈⲠⲀⲨⲖⲞⲤ ⲘⲚ ⲤⲒⲖⲀⲤ. ⲞⲨⲘⲎⲎϢⲈ ⲆⲈ ⲈⲚⲀϢⲰϤ ⲚⲚϨⲈⲖⲖⲎⲚ ⲈⲦϢⲘϢⲈ. ⲀⲨⲰ ϨⲀϨ ⲚⲚⲈϨⲒⲞⲘⲈ ⲚⲢⲘⲘⲀⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲔⲰϨ ⲀⲨⲂⲰⲔ ⲀⲨϪⲒ ⲚⲘⲘⲀⲨ ⲚϨⲈⲚⲢⲰⲘⲈ ⲚⲢⲘⲚϨⲞⲤⲂ ⲘⲠⲞⲚⲎⲢⲞⲤ ⲀⲨⲰ ⲀⲨⲤⲈⲨϨ ⲞⲨⲘⲎⲎϢⲈ ⲀⲨϢⲦⲢⲦⲢ ⲦⲠⲞⲖⲒⲤ ⲀⲨⲈⲒ ⲆⲈ ⲈⲢⲘⲠⲎⲒ ⲚⲒⲀⲤⲰⲚ ⲀⲨϢⲒⲚⲈ ⲚⲤⲰⲞⲨ ⲈⲚⲦⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲀϨⲢⲘ ⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲦⲘϨⲈ ⲈⲢⲞⲞⲨ ⲀⲨⲤⲰⲔ ⲚⲒⲀⲤⲰⲚ ⲘⲚ ϨⲞⲒⲚⲈ ⲚⲚⲈⲤⲚⲎⲨ ⲚⲚⲀϨⲢⲚ ⲚⲀⲢⲬⲰⲚ ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲚⲀⲒ ⲚⲈⲚⲦⲀⲨⲀⲚⲀⲤⲦⲀⲦⲞⲨ ⲚⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ. ⲀⲨⲰ ⲀⲨⲈⲒ ⲈⲠⲈⲒⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ⲀϤϢⲞⲠⲞⲨ ⲈⲢⲞϤ ⲚϬⲒ ⲒⲀⲤⲰⲚ. ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲨϮ ⲞⲨⲂⲈ ⲚⲆⲞⲄⲘⲀ ⲘⲠⲢⲢⲞ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚ ⲔⲈⲢⲢⲞ ϢⲞⲞⲠ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ⲀⲨⲰ ⲀⲨϢⲦⲢⲦⲢ ⲘⲠⲘⲎⲎϢⲈ ⲘⲚ ⲚⲀⲢⲬⲰⲚ ⲈⲨⲤⲰⲦⲘ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ⲀⲨⲰ ⲀⲨϪⲒ ϢⲠⲦⲰⲢⲈ ⲚⲦⲚ ⲒⲀⲤⲰⲚ ⲘⲚ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲀⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲚⲈⲤⲚⲎⲨ ϪⲞⲞⲨ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲦⲈⲨϢⲎ ⲀⲨⲰ ⲤⲒⲖⲀⲤ ⲈϨⲢⲀⲒ ⲈⲂⲈⲢⲞⲒⲀ. ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲠⲰϨ ⲈⲘⲀⲨ. ⲀⲨⲂⲰⲔ ⲚⲦⲈⲨⲚⲞⲨ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ⲚⲀⲒ ⲆⲈ ⲚⲈ ϨⲈⲚⲢⲘⲚϨⲎⲦ ⲚⲈ ⲈϨⲞⲨⲈ ⲚⲈⲦϨⲚ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ. ⲈⲀⲨϢⲰⲠ ⲈⲢⲞⲞⲨ ⲘⲠϢⲀϪⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲞⲨⲢⲞⲦ. ⲈⲨϨⲞⲦϨⲦ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ⲘⲘⲎⲚⲈ ϪⲈ ⲚⲈ ⲚⲀⲒ ⲤⲘⲞⲚⲦ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ϨⲀϨ ϬⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ. ⲀⲨⲰ ϨⲈⲚϨⲒⲞⲘⲈ ⲚϨⲈⲖⲖⲎⲚ ⲚⲢⲘⲘⲀⲞ. ⲘⲚ ϨⲈⲚⲢⲰⲘⲈ ⲈⲚⲀϢⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ⲚⲦⲈⲢⲞⲨⲈⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲚⲈⲂⲞⲖ ϨⲚ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ϪⲈ ⲀⲨⲦⲀϢⲈⲞⲈⲒϢ ϨⲚ ⲂⲈⲢⲞⲒⲀ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲀⲨⲖⲞⲤ ⲀⲨⲈⲒ ⲞⲚ ⲈⲘⲀⲨ ⲈⲨϢⲦⲞⲢⲦⲢ ⲀⲨⲰ ⲈⲨⲔⲒⲘ ⲈⲘⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲚⲈⲤⲚⲎⲨ ϪⲞⲞⲨ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲦⲢⲈϤⲂⲰⲔ ϢⲀϨⲢⲀⲒ ⲈϪⲚ ⲐⲀⲖⲀⲤⲤⲀ. ⲀⲤⲒⲖⲀⲤ ⲆⲈ ϬⲰ ⲘⲘⲀⲨ ⲘⲚⲦⲒⲘⲞⲐⲈⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ⲚⲈⲦⲔⲀⲐⲒⲤⲦⲀ ⲆⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲀⲨⲚⲦϤ ϢⲀ ⲀⲐⲎⲚⲀⲒⲤ. ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨϪⲒ ⲚⲞⲨⲈⲚⲦⲞⲖⲎ ⲚⲦⲞⲞⲦϤ ϢⲀ ⲤⲒⲖⲀⲤ ⲘⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ϪⲈ ⲈⲨⲈⲈⲒ ϢⲀⲢⲞϤ ϨⲚ ⲞⲨϬⲈⲠⲎ. ⲀⲨⲈⲒ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ϬⲰϢⲦ ϨⲎⲦⲞⲨ ϨⲚ ⲀⲐⲎⲚⲀⲒⲤ. ⲀⲠⲈϤⲠⲚⲈⲨⲘⲀ ϨⲞϪϨϪ ⲚϨⲎⲦϤ ⲈϤⲚⲀⲨ ⲈⲦⲠⲞⲖⲒⲤ ⲈⲤⲘⲈϨ ⲘⲘⲀ ⲚⲈⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ⲚⲈϤϢⲀϪⲈ ⲆⲈ ⲠⲈ ⲘⲚ ⲚⲒⲞⲨⲆⲀⲒ ϨⲚ ⲦⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲚ ⲚⲈⲦϢⲘϢⲈ. ⲀⲨⲰ ⲚⲈⲦϨⲚ ⲦⲀⲄⲞⲢⲀ ⲘⲘⲎⲚⲈ ⲚⲚⲀϨⲢⲚ ⲚⲈⲦⲚⲎⲨ ⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ϨⲞⲒⲚⲈ ⲆⲈ ϨⲈⲚ ⲈⲠⲒⲔⲞⲨⲢⲒⲞⲤ ⲘⲪⲒⲖⲞⲤⲞⲪⲞⲤ ⲘⲚ ⲚⲈⲤⲦⲞⲒⲔⲞⲤ ⲚⲈⲨϮⲦⲰⲚ ⲚⲘⲘⲀϤ ⲠⲈ ⲀⲨⲰ ⲚⲈⲢⲈ ϨⲞⲒⲚⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈ ⲠⲈⲒⲤⲀⲚϢⲀϪⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲈϤⲦⲀϢⲈⲞⲒϢ ⲚϨⲈⲚⲚⲞⲨⲦⲈ ⲚⲂⲢⲢⲈ ⲈⲂⲞⲖ ϪⲈ ⲚⲈϤⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ⲚⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ⲀⲨⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲘⲞϤ ⲀⲨϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲠⲀⲢⲒⲞⲘ ⲠⲀⲄⲞⲤ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲚⲚⲀⲞⲨⲰϢ ⲈⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲦⲈ ⲦⲈⲒⲤⲂⲰ ⲚⲂⲢⲢⲈ ⲈⲦⲔϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ⲔⲈⲒⲚⲈ ⲄⲀⲢ ⲚϨⲈⲚϢⲀϪⲈ ⲚⲂⲢⲢⲈ ⲈϨⲞⲨⲚ ⲈⲚⲈⲚⲘⲀⲀϪⲈ. ⲦⲚⲞⲨⲰϢ ϬⲈ ⲈⲈⲒⲘⲈ ϪⲈ ⲞⲨ ⲚⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ⲚⲀⲐⲎⲚⲀⲒⲤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚϢⲘⲘⲞ ⲈⲦⲚϨⲎⲦⲞⲨ ⲘⲈⲨⲤⲢϤⲈ ⲈⲖⲀⲀⲨ ⲈⲒⲘⲎⲦⲒ ⲈϢⲀϪⲈ. ⲎⲈⲤⲰⲦⲘ ⲈⲨϢⲀϪⲈ ⲚⲂⲢⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲘⲎⲦⲈ ⲘⲠⲀⲢⲒⲞⲘ ⲠⲀⲄⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲐⲎⲚⲀⲒⲤ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ϮⲚⲀⲨ ⲈⲢⲰⲦⲚ ⲈϢϪⲈ ⲚⲦⲈⲦⲚϨⲈⲚⲢⲈϤϢⲘϢⲈⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ⲈⲒⲘⲞⲞϢⲈ ⲄⲀⲢ ⲈⲒⲚⲀⲨ ⲈⲚⲈⲦⲈⲦⲚⲞⲨⲰϢⲦ ⲚⲀⲨ ⲀⲒϨⲈ ⲈⲨϢⲎⲨⲈ ⲈϤⲤⲎϨ ⲈⲢⲞⲤ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲈⲚⲤⲈⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈⲦⲈⲦⲚⲞⲨⲰϢⲦ ϬⲈ ⲚⲀϤ ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲀⲒ ⲠⲈ ⲈϮⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲦⲀϤⲦⲀⲘⲒⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲘⲚ ⲚⲈⲦⲚϨⲎⲦϤ ⲦⲎⲢⲞⲨ. ⲠⲀⲒ ⲠⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲠⲈ ⲘⲚ ⲠⲔⲀϨ. ⲚⲈϤⲞⲨⲎϨ ⲀⲚ ϨⲚ ⲢⲠⲈ ⲘⲘⲞⲨⲚⲄ ⲚϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ⲞⲨⲆⲈ ⲚⲈϤϢⲀⲀⲦ ⲀⲚ ⲚⲖⲀⲀⲨ ⲈⲦⲢⲈⲨϢⲘϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϬⲒϪ ⲚⲚⲢⲰⲘⲈ. ⲚⲦⲞϤ ⲠⲈⲦϮ ⲘⲠⲰⲚϨ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲀⲨⲰ ⲦⲈⲠⲚⲞⲎ ϨⲘ ⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ⲈⲀϤⲦⲀⲘⲒⲈ ϨⲈⲐⲚⲞⲤ ⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲀ ⲈⲦⲢⲈⲨⲞⲨⲰϨ ϨⲒϪⲘ ⲪⲞ ⲦⲎⲢϤ ⲘⲠⲔⲀϨ. ⲈⲀϤⲦⲰϢ ⲚϨⲈⲚⲞⲨⲞⲈⲒϢ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ⲚⲦⲞϢ ⲚⲚⲈⲨⲘⲀ ⲚϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ⲈⲦⲢⲈⲨϢⲒⲚⲈ ⲚⲤⲀ ⲠⲚⲞⲨⲦⲈ. ⲈϢⲰⲠⲈ ⲈⲨⲚⲀϢϬⲘϬⲰⲘϤ ⲚⲤⲈϨⲈ ⲈⲢⲞϤ. ⲔⲀⲒⲠⲈⲢ ⲚϤⲞⲨⲎⲨ ⲀⲚ ⲈⲂⲞⲖ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ⲈⲚϢⲞⲞⲠ ⲄⲀⲢ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲈⲚⲞⲚϨ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲈⲚⲔⲒⲘ ⲚⲐⲈ ⲞⲚ ⲚⲦⲀϨⲞⲒⲚⲈ ⲚⲚⲈⲦⲚⲠⲞⲒⲎⲦⲎⲤ ϪⲞⲞⲤ ϪⲈ ⲀⲚⲞⲚ ⲠⲈϤⲄⲈⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ⲈⲀⲚⲞⲚ ⲠⲄⲈⲚⲞⲤ ϬⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚϢϢⲈ ⲈⲢⲞⲚ ⲀⲚ ⲈⲘⲈⲈⲨⲈ ϪⲈ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲒⲚⲈ ⲚⲞⲨⲚⲞⲨⲂ ⲎⲞⲨϨⲀⲦ ⲎⲞⲨⲰⲚⲈ ⲈϤϢⲈⲦϢⲰⲦ ⲚⲦⲈⲬⲚⲎ ⲘⲘⲞⲔⲘⲈⲔ ⲚⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ⲘⲠⲈⲞⲨⲞⲈⲒϢ ϬⲈ ⲚⲦⲘⲚⲦⲀⲦⲤⲞⲞⲨⲚ. ⲀⲠⲚⲞⲨⲦⲈ ⲞⲂϢϤ ⲈⲢⲞⲞⲨ. ⲦⲈⲚⲞⲨ ϬⲈ ϤⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲚⲢⲰⲘⲈ ⲈⲦⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ϨⲘ ⲘⲀ ⲚⲒⲘ ⲘⲈⲦⲀⲚⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ⲈⲂⲞⲖ ϪⲈ ⲀϤⲤⲘⲒⲚⲈ ⲚⲞⲨϨⲞⲞⲨ ⲈϤⲚⲀⲔⲢⲒⲚⲈ ⲚϨⲎⲦϤ ⲚⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ϨⲚ ⲞⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲢⲰⲘⲈ ⲈⲀϤⲦⲞϢϤ. ⲀϤϮⲦⲠⲒⲤⲦⲒⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ϪⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲀⲨⲚⲞϬⲚⲈϬ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲠⲈϪⲀⲨ ϪⲈ ⲈⲚⲈⲤⲰⲦⲘ ⲈⲢⲞⲔ ⲈⲦⲂⲈ ⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲀ ⲠⲀⲨⲖⲞⲤ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ⲀϨⲈⲚⲢⲰⲘⲈ ⲆⲈ ⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲦⲞϬⲞⲨ ⲈⲢⲞϤ. ⲀⲨⲰ ⲆⲒⲞⲚⲎⲤⲒⲞⲤ ⲠⲀⲢⲈⲞⲠⲀⲄⲒⲦⲎⲤ ⲘⲚ ⲞⲨⲤϨⲒⲘⲈ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲆⲀⲘⲀⲢⲒⲤ ⲀⲨⲰ ϨⲈⲚⲔⲞⲞⲨⲈ ⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲀⲐⲎⲚⲀⲒⲤ. ⲀϤⲂⲰⲔ ⲈⲔⲞⲢⲒⲚⲐⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ⲀⲨⲰ ⲀϤϨⲈ ⲈⲨⲒⲞⲨⲆⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲔⲨⲖⲀⲤ ⲞⲨⲠⲞⲚⲦⲒⲔⲞⲤ ϨⲘ ⲠⲈϤⲄⲈⲚⲞⲤ ⲈⲀϤⲈⲒ ϨⲚ ⲚⲈϨⲞⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲦⲀⲖⲒⲀ ⲘⲚ ⲠⲢⲒⲤⲔⲒⲖⲖⲀ ⲦⲈϤⲤϨⲒⲘⲈ ⲈⲂⲞⲖ ϪⲈ ⲀⲔⲖⲀⲨⲆⲒⲞⲤ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ϨⲢⲰⲘⲎ ⲀϤϮ ⲠⲈϤⲞⲨⲞⲈⲒ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ⲀⲨⲰ ⲀϤϬⲰ ϨⲀϨⲦⲎⲨ ⲀϤⲢϨⲰⲂ. ϪⲈ ⲚⲈⲦⲈϤⲈⲒⲞⲠⲈ ⲦⲰⲞⲨ ⲦⲈ. ⲚⲈ ⲦⲈⲨⲦⲈⲬⲚⲎ ⲄⲀⲢ ⲠⲈ ⲢⲈϤⲦⲀⲘⲒⲈ ⲤⲔⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ⲀⲨⲰ ⲚⲈϤϢⲀϪⲈ ⲈⲢⲞⲞⲨ ⲠⲈ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲘ. ⲈϤⲠⲒⲐⲈ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ⲚⲦⲈⲢⲈ ⲤⲒⲖⲀⲤ ⲆⲈ ⲈⲒ ⲘⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ⲚⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲎⲚ ⲈⲂⲞⲖ ϨⲘ ⲠϢⲀϪⲈ ⲈϤⲢⲘⲚⲦⲢⲈ ⲚⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ⲚⲦⲈⲢⲞⲨϮ ⲆⲈ ⲞⲨⲂⲎϤ ⲈⲨϪⲒⲞⲨⲀ. ⲀϤⲚⲈϨ ⲚⲈϤϨⲞⲒⲦⲈ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲚⲤⲚⲞϤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲦⲚⲀⲠⲈ. ϮⲞⲨⲀⲀⲂ ⲀⲚⲞⲔ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲈⲒⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ⲀϤⲠⲰⲰⲚⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲞⲨⲤⲞⲚ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲦⲒⲦⲞⲤ ⲈϤϢⲘϢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲠⲀⲒ ⲈⲢⲈ ⲠⲈϤⲎⲒ ϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ⲔⲢⲒⲤⲠⲞⲤ ⲆⲈ ⲠⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ ⲘⲚ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ⲀⲨⲰ ϨⲀϨ ϨⲚ ⲚⲔⲞⲢⲒⲚⲐⲞⲤ ⲈⲨⲤⲰⲦⲘ ⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲀⲨⲰ ⲀⲨϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲘⲠⲀⲨⲖⲞⲤ ϨⲚ ⲞⲨϨⲞⲢⲞⲘⲀ ⲚⲦⲈⲨϢⲎ. ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲀⲖⲖⲀ ϢⲀϪⲈ. ⲀⲨⲰ ⲘⲠⲢⲔⲀⲢⲰⲔ ");
INSERT INTO copshc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ϪⲈ ⲀⲚⲞⲔ ϮϢⲞⲞⲠ ⲚⲘⲘⲀⲔ. ⲀⲨⲰ ⲘⲚ ⲖⲀⲀⲨ ⲚⲀϢϬⲘϬⲞⲘ ⲈⲢ ⲠⲈⲐⲞⲞⲨ ⲚⲀⲔ. ϪⲈ ⲞⲨⲚ ⲞⲨⲖⲀⲞⲤ ⲈⲚⲀϢⲰϤ ϢⲞⲞⲠ ⲚⲀⲒ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ⲀϤϨⲘⲞⲞⲤ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲢⲞⲘⲠⲈ ⲘⲚ ⲤⲞⲞⲨ ⲚⲈⲂⲞⲦ ⲈϤϮⲤⲂⲰ ⲚϨⲎⲦⲞⲨ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ⲄⲀⲖⲖⲒⲰⲚ ⲆⲈ ⲈϤⲞ ⲚⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲈϪⲚ ⲦⲀⲬⲀⲒⲀ. ⲀⲚⲒⲞⲨⲆⲀⲒ ⲦⲰⲞⲨⲚ ϨⲒ ⲞⲨⲤⲞⲠ ⲈϪⲘ ⲠⲀⲨⲖⲞⲤ ⲀⲨⲚ ⲚⲈⲨϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲀⲨϪⲒⲦϤ ⲈⲠⲂⲎⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲢⲀ ⲠⲚⲞⲘⲞⲤ ⲠⲀⲒ ⲠⲒⲐⲈ ⲚⲚⲢⲰⲘⲈ ⲈϢⲘϢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ⲚⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲒ ⲈϤⲚⲀⲞⲨⲰⲚ ⲚⲢⲰϤ. ⲠⲈϪⲈ ⲄⲀⲖⲖⲒⲰⲚ ⲚⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲈⲚⲈ ⲞⲨϪⲒ ⲚϬⲞⲚⲤ ⲎⲞⲨϨⲰⲂ ⲈϤϨⲞⲞⲨ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ Ⲱ ⲚⲒⲞⲨⲆⲀⲒ. ⲚⲈⲒⲚⲀⲀⲚⲈⲬⲈ ⲠⲈ ⲘⲘⲰⲦⲚ ⲈⲨⲖⲞⲄⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ⲦⲈⲚⲞⲨ ϬⲈ ⲈϢϪⲈ ϨⲈⲚⲌⲎⲦⲎⲘⲀ ⲚⲈ ⲈⲦⲂⲈ ⲞⲨϢⲀϪⲈ. ⲎϨⲈⲚⲢⲀⲚ ⲈⲦⲂⲈ ⲠⲈⲦⲚⲚⲞⲘⲞⲤ ⲦⲈⲦⲚⲢⲰϢⲈ ⲚⲦⲰⲦⲚ. ⲀⲚⲞⲔ ⲄⲀⲢ ⲚϮⲞⲨⲰϢ ⲀⲚ ⲈϮϨⲀⲠ ⲈϨⲰⲂ ⲚⲦⲈⲒⲘⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ⲀⲨⲰ ⲀϤⲚⲞϪⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲂⲎⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ⲀⲚϨⲖⲖⲎⲚ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲘⲀϨⲦⲈ ⲚⲤⲰⲤⲐⲈⲚⲎⲤ ⲠⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀⲨϨⲒⲞⲨⲈ ⲈⲢⲞϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲂⲎⲘⲀ. ⲀⲨⲰ ⲘⲠⲈ ⲄⲀⲖⲖⲒⲰⲚ ⲠⲢⲞⲤⲈⲬⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲞⲚ ⲀϤϬⲰ ⲚϨⲈⲚⲔⲈⲘⲎⲎ ϢⲈ ⲚϨⲞⲞⲨ ϨⲀⲦⲚ ⲚⲈⲤⲚⲎⲨ ⲘⲚⲚⲤⲀ ⲚⲀⲒ ⲀϤⲀⲠⲞⲦⲀⲤⲤⲈ ⲚⲀⲨ ⲀϤⲤϬⲎⲢ ⲈⲦⲤⲨⲢⲒⲀ ⲘⲚ ⲠⲢⲒⲤⲔⲒⲖⲖⲀ ⲀⲨⲰ ⲀⲔⲨⲖⲀⲤ ⲀϤϨⲈⲔⲈ ⲦⲈϤⲀⲠⲈ ϨⲚ ⲔⲈⲚⲬⲢⲀⲒⲀⲒⲤ ⲚⲈⲨⲚⲦⲀϤ ⲄⲀⲢ ⲘⲘⲀⲨ ⲚⲞⲨⲈⲢⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ⲚⲦⲈⲢⲞⲨⲠⲰϨ ⲆⲈ ⲈⲈⲪⲈⲤⲞⲤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲚⲎⲨ. ⲀⲠⲀⲨⲖⲞⲤ ⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ ⲀϤϢⲀϪⲈ ⲘⲚ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ⲚⲦⲈⲢⲞⲨⲤⲈⲠⲤⲰⲠϤ ⲆⲈ ⲈⲢ ⲞⲨⲚⲞϬ ⲚⲞⲨⲞⲈⲒϢ ⲘⲘⲀⲨ ⲘⲠϤϬⲰ. ");
INSERT INTO copshc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ⲀⲖⲖⲀ ⲀϤⲔⲀ ⲚⲎ ⲘⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀϤⲀⲠⲞⲦⲀⲤⲤⲈ ⲚⲀⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲚⲀⲔⲦⲞⲒ ⲞⲚ ϢⲀⲢⲰⲦⲚ ⲈϢⲰⲠⲈ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲀϤⲂⲰⲔ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲪⲈⲤⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ⲀϤⲤϬⲎⲢ ⲈϨⲢⲀⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲀϤⲀⲤⲠⲀⲌⲈ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲀϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ⲚⲦⲈⲢⲈϤⲢⲞⲨⲞⲈⲒϢ ⲆⲈ ⲘⲘⲀⲨ. ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈϤⲘⲞⲨϢⲦ ⲚⲦⲈⲬⲰⲢⲀ ⲚⲦⲄⲀⲖⲀⲦⲒⲀ ⲘⲚ ⲦⲈⲪⲢⲨⲄⲒⲀ. ⲈⲨⲦⲀϪⲢⲞ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ⲞⲨⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲠⲞⲖⲖⲰ ⲀϤⲈⲒ ⲈⲦⲈⲪⲈⲤⲞⲤ. ⲞⲨⲀⲖⲈⲜⲀⲚⲆⲢⲈⲨⲤ ϨⲘ ⲠⲈϤⲄⲈⲚⲞⲤ. ⲞⲨⲢⲰⲘⲈ ⲈⲨⲚⲦϤ ⲠϢⲀϪⲈ ⲈⲨⲚϬⲞⲘ ⲘⲘⲞϤ ϨⲈⲚ ⲚⲈⲄⲢⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ⲠⲀⲒ ⲆⲈ ⲚⲈ ⲀⲨⲔⲀⲐⲎⲔⲈⲒ ⲘⲘⲞϤ ⲠⲈ ϨⲚ ⲦⲈϨⲒⲎ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲈϤⲂⲢⲂⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲈϤϢⲀϪⲈ ⲀⲨⲰ ⲚⲈϤϮⲤⲂⲰ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲈϤⲤⲞⲞⲨⲚ ⲘⲘⲀⲦⲈ ⲘⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ⲠⲀⲒ ⲀϤⲀⲢⲬⲈⲒ ⲘⲠⲀⲢⲢⲎⲤⲒⲀⲌⲈ ⲘⲘⲞϤ ϨⲚ ⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲀⲔⲨⲖⲀⲤ ⲘⲚ ⲠⲢⲒⲤⲔⲒⲖⲖⲀ. ⲀⲨϢⲞⲠϤ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲀⲨⲦⲀⲘⲞϤ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲦⲈϨⲒⲎ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ⲀⲚⲈⲤⲚⲎⲨ ⲆⲈ ⲠⲢⲞⲦⲢⲈⲠⲈ ⲘⲘⲞϤ ⲈϨⲚⲀϤ ⲈⲂⲰⲔ ⲈⲦⲀⲬⲀⲒⲀ. ⲀⲨⲰ ⲀⲨⲤϨⲀⲒ ⲚⲚⲈⲤⲚⲎⲨⲈϢⲞⲠϤ ⲈⲢⲞⲞⲨ. ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ⲈⲘⲀⲨ ⲀϤⲦⲀⲀϤ ⲈⲠⲈϨⲞⲨⲞ ⲚⲚⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ϨⲚ ⲦⲈⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ⲚⲈϤϪⲠⲒⲞ ⲄⲀⲢ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲈⲘⲀⲦⲈ ϨⲚ ⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ. ⲈϤⲦⲀⲘⲞ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈⲢⲈ ⲀⲠⲞⲖⲖⲰ ϨⲚ ⲔⲞⲢⲒⲚⲐⲞⲤ. ⲠⲀⲨⲖⲞⲤ ⲀϤⲘⲈϢⲦ ⲚⲤⲀ ⲈⲦϨⲘ ⲠϪⲒⲤⲈ ⲀϤⲈⲒ ⲈⲦⲈⲪⲈⲤⲞⲤ. ⲀϤϨⲈ ⲈϨⲈⲚⲘⲀⲐⲎⲦⲎⲤ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲈⲢⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲀⲦⲈⲦⲚϪⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲘⲠⲚⲤⲰⲦⲘ ⲢⲰ ϪⲈ ϢⲀⲢⲈ ⲞⲨⲞⲚ ϪⲒ ⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ϬⲈ ⲈⲚⲒⲘ. ⲠⲈϪⲀⲨ ϪⲈ ⲚⲦⲀⲚϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲒⲰϨⲀⲚⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲒⲰϨⲀⲚⲚⲎⲤ ⲚⲦⲀϤⲂⲀⲠⲦⲒⲌⲈ ϨⲚ ⲞⲨⲂⲀⲠⲦⲒⲤⲘⲀ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ. ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲠⲖⲀⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲦⲚⲎⲨ ⲘⲚⲚⲤⲰϤ. ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲔⲀ ϬⲒϪ ⲈϪⲰⲞⲨ ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲚⲈⲨϢⲀϪⲈ ⲆⲈ ⲠⲈ ϨⲚ ϨⲈⲚⲔⲈⲀⲤⲠⲈ ⲀⲨⲰ ⲚⲈⲨⲠⲢⲞⲪⲎⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ⲚⲦⲞⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲈⲨⲘⲈϨ ⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚⲢⲰⲘⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲤⲨⲚⲀⲄⲰⲄⲎ. ⲀϤⲠⲀⲢⲢⲎⲤⲒⲀⲌⲈ ⲘⲘⲞϤ ⲚϢⲞⲘⲚⲦ ⲚⲈⲂⲞⲦ. ⲈϤϢⲀϪⲈ ⲀⲨⲰ ⲈϤⲠⲒⲐⲈ ⲘⲘⲞⲞⲨ ⲈⲦⲂⲈ ⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ⲚⲦⲈⲢⲈ ϨⲞⲒⲚⲈ ⲆⲈ ⲚϢⲞⲦ ⲚϨⲎⲦ ⲀⲨⲰ ⲀⲨⲢⲀⲦⲤⲰⲦⲘ ⲈⲨϪⲒⲞⲨⲀ ⲈⲦⲈϨⲒⲎ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲘⲎⲎϢⲈ ⲀϤⲤⲀϨⲰϤ ⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲀϤⲠⲢϪ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲢⲞⲞⲨ ⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲘⲘⲎⲚⲈ ϨⲚ ⲦⲈⲤⲬⲞⲖⲎ ⲚⲦⲎⲢⲀⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ⲠⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲈ ⲚⲢⲞⲘⲠⲈ ⲤⲚⲦⲈ. ϨⲰⲤⲦⲈ ⲚⲦⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲦⲀⲤⲒⲀ ⲤⲰⲦⲘ ⲈⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ. ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲘⲚ ⲚⲞⲨⲈⲈⲒⲈⲚⲒⲚ ");
INSERT INTO copshc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ϨⲈⲚⲚⲞϬ ⲚϬⲞⲘ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϬⲒ Ϫ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ϨⲰⲤⲦⲈ ⲚⲤⲈϪⲒ ⲚϨⲈⲚⲤⲞⲨⲆⲀⲢⲒⲞⲚ ⲘⲚ ϨⲈⲚⲤⲨⲘⲒⲔⲒⲚⲐⲒⲚⲞⲚ ⲈⲀⲨⲦⲞϬⲞⲨ ⲈⲠⲈϤⲤⲰⲘⲀ ⲚⲤⲈⲔⲀⲀⲨ ⲈϪⲚ ⲚⲈⲦϢⲰⲚⲈ ⲚⲦⲈ ⲚⲈⲦϢⲰⲚⲈ ⲖⲞ. ⲀⲨⲰ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲚⲈⲨⲚⲎⲨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ⲀⲨϨⲒⲦⲞⲞⲦⲞⲨ ⲆⲈ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲦⲘⲞⲞϢⲈ ⲈⲦⲞ ⲚⲈⲜⲞⲢⲔⲒⲤⲦⲎⲤ ⲈⲦⲀⲨⲈ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲚⲈⲦⲈⲢⲈ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ϨⲒⲰⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲚⲦⲀⲢⲔⲞ ⲘⲘⲰⲦⲚ ⲚⲒⲤ ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲔⲎⲢⲨⲤⲤⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ⲚⲈⲨⲚ ⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϪⲈ ⲤⲔⲈⲨⲀ ⲈⲨⲚⲦϤ ⲤⲀϢϤ ⲚϢⲎⲢⲈ ⲈⲨⲈⲒⲢⲈ ⲘⲠⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲒⲎⲤⲞⲨⲤ ϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ. ⲀⲨⲰ ⲠⲔⲈⲠⲀⲨⲖⲞⲤ ϮⲈⲒⲘⲈ ⲈⲢⲞϤ. ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ⲀϤϤⲰϬⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲚϬⲒ ⲠⲢⲰⲘⲈ ⲈⲦⲈⲢⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲞⲚⲎⲢⲞⲚ ϨⲒⲰⲰϤ ⲀϤⲢϪⲞⲈⲒⲤ ⲈⲢⲞⲞⲨ ⲘⲠⲤⲀϢϤ ⲀⲨⲰ ⲀϤϬⲘϬⲞⲘ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ϨⲰⲤⲦⲈ ⲚⲤⲈⲠⲰⲦ ⲈⲂⲞⲖ ϨⲘ ⲠⲎⲒ ⲈⲦⲘⲘⲀⲨ ⲈⲨⲔⲎ ⲔⲀϨⲎⲨ ⲀⲨⲰ ⲈⲨⲠⲞⲖϨ. ");
INSERT INTO copshc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ⲠⲀⲒ ⲆⲈ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲦⲈⲪⲈⲤⲞⲤ. ⲀⲨⲰ ⲀⲨϨⲞⲦⲈ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ ⲦⲎⲢⲞⲨ. ⲀⲨⲰ ⲀϤϪⲒⲤⲈ ⲚϬⲒ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ⲚⲈⲢⲈ ϨⲀϨ ⲆⲈ ⲚⲚⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲚⲎⲨ ⲈⲨⲈⲜⲞⲘⲞⲖⲞⲄⲒ. ⲀⲨⲰ ⲈⲨⲦⲀⲨⲞ ⲚⲚⲈⲨϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ⲞⲨⲘⲎⲎϢⲈ ⲞⲚ ⲚⲚⲈⲚⲦⲀⲨⲈⲒⲢⲈ ⲚϨⲈⲚⲘⲚⲦⲠⲈⲢⲠⲈⲢⲞⲤ ⲀⲨⲚ ϪⲰⲰⲘⲈ ⲚⲘⲘⲀⲨ ⲀⲨⲢⲞⲔϨⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲀⲨⲰ ⲀⲨⲈⲠ ⲤⲞⲨⲚⲦⲞⲨ. ⲀⲨϨⲈ ⲈⲢⲞⲞⲨ ⲈⲨⲈⲒⲢⲈ ⲚϮⲞⲨ ⲚⲦⲂⲀ ⲚϨⲀⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲀ ⲠϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲜⲀⲚⲈ. ⲀⲨⲰ ⲀϤⲦⲀϪⲢⲞ ⲀⲨⲰ ⲀϤϬⲘϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ⲚⲦⲈⲢⲈ ⲚⲀⲒ ⲆⲈ ϪⲰⲔ ⲈⲂⲞⲖ ⲀⲠⲀⲨⲖⲞⲤ ⲤⲘⲚⲦⲤ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲘⲚ ⲦⲀⲬⲀⲒⲀ ⲚϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲚⲚⲤⲀ ⲦⲢⲀⲂⲰⲔ ⲈⲘⲀⲨ ϨⲀⲠⲤ ⲞⲚ ⲈⲦⲢⲀⲚⲀⲨ ⲈⲦⲔⲈϨⲢⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ⲀϤϪⲞⲞⲨ ⲆⲈ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚⲤⲀ ⲤⲚⲀⲨ ⲚⲚⲈⲦⲆⲒⲀⲔⲞⲚⲒ ⲚⲀϤ. ⲦⲒⲘⲞⲐⲈⲞⲤ ⲘⲚ ⲈⲢⲀⲤⲦⲞⲤ. ⲚⲦⲞϤ ⲆⲈ ⲀϤϬⲰ ⲚⲞⲨⲞⲈⲒϢ ϨⲚ ⲦⲀⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ⲀϤϢⲰⲠⲈ ⲆⲈ ⲘⲠⲈⲨⲞⲈⲒϢ ⲈⲦⲘⲘⲀⲨ ⲚϬⲒ ⲞⲨⲚⲞϬ ⲚϢⲦⲞⲢⲦⲢ ⲈⲦⲂⲈ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ⲞⲨⲢⲈϤⲢϨⲀⲦ ⲄⲀⲢ ϪⲈ ⲦⲨⲘⲎⲦⲢⲒⲞⲤ ⲈϤⲦⲀⲘⲒⲞ ⲚϨⲈⲚⲦⲞⲨⲰⲦ ⲚϨⲀⲦ ⲚⲦⲀⲢⲦⲈⲘⲒⲤ. ⲚⲈⲨϮ ⲚⲞⲨⲚⲞϬ ⲚⲈⲢⲄⲀⲤⲒⲀ ⲚⲚⲦⲈⲬⲚⲒⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ⲠⲀⲒ ϬⲈ ⲀϤⲤⲈⲨϨ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲢϨⲰⲂ ⲈⲦⲈⲒⲞⲠⲈ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚϢⲂⲢⲦⲈⲬⲚⲒⲦⲎⲤ. ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲈⲢⲈ ⲠⲈⲚⲰⲚϨ ϢⲞⲞⲠ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲒⲈⲢⲄⲀⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ⲦⲈⲦⲚⲚⲀⲨ ⲆⲈ ⲀⲨⲰ ⲦⲈⲦⲚⲤⲰⲦⲘ ϪⲈ ⲞⲨ ⲘⲞⲚⲞⲚ ϨⲚ ⲦⲈⲪⲈⲤⲞⲤ ⲀⲖⲖⲀ ⲤⲬⲈⲆⲞⲚ ϨⲚ ⲦⲀⲤⲒⲀ ⲦⲎⲢⲤ ⲀⲠⲀⲒ ϪⲈ ⲠⲀⲨⲖⲞⲤ ⲠⲒⲐⲈ ⲀⲨⲰ ⲀϤⲠⲚⲚⲈ ⲞⲨⲘⲎⲎϢⲈ ⲈⲂⲞⲖ ⲈⲚⲀϢⲰϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚϨⲈⲚⲚⲞⲨⲦⲈ ⲀⲚ ⲚⲈ ⲚⲀⲒ ⲈⲦⲞⲨⲦⲀⲘⲒⲞ ⲘⲘⲞⲞⲨ ϨⲚ ⲚⲈⲨϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲠⲈⲒⲘⲈⲢⲞⲤ ⲔⲒⲚⲆⲨⲚⲈⲨⲈ ⲈⲦⲢⲈϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ ⲚⲦⲞⲞⲦⲚ ⲀⲖⲖⲀ ⲠⲔⲈⲢⲠⲈ ⲚⲦⲚⲞϬ ⲚⲀⲢⲦⲨⲘⲒⲤ ⲤⲈⲚⲀⲖⲞ ⲈⲨⲰⲠ ⲘⲘⲞϤ ⲀⲨⲰ ⲚⲤⲈⲚⲦⲤ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲤⲘⲚⲦⲚⲞϬ ⲦⲀⲒ ⲈⲦⲈⲢⲈ ⲦⲀⲤⲒⲀ ⲦⲎⲢⲤ ⲀⲨⲰ ⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ ϢⲘϢⲈ ⲚⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨⲘⲞⲨϨ ⲚϬⲰⲚⲦ ⲀⲨⲰ ⲀⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚⲞϬ ⲦⲈ ⲦⲀⲢⲦⲈⲘⲒⲤ ⲚⲦⲈⲪⲈⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ⲀⲨⲰ ⲀⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲘⲞⲨϨ ⲚϢⲦⲞⲢⲦⲢ. ⲈⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ϨⲒ ⲞⲨⲤⲞⲠ ⲈⲠⲈⲐⲨⲀⲦⲢⲞⲚ. ⲈⲀⲨⲦⲰⲢⲠ ⲚⲄⲀⲒⲞⲤ ⲘⲚ ⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ϨⲈⲚⲘⲀⲔⲈⲆⲰⲚ ⲈⲨⲘⲞⲞϢⲈ ⲘⲚ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲞⲨⲰϢ ⲈⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲆⲎⲘⲞⲤ ⲘⲠⲈ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲔⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ϨⲞⲒⲚⲈ ⲆⲈ ⲞⲚ ϨⲚ ⲚⲀⲢⲬⲰⲚ ⲈⲨⲞ ⲚϢⲂⲎⲢ ⲈⲢⲞϤ. ⲀⲨⲦⲀⲨⲞⲞⲨ ⲚⲀϤ ⲈⲨⲤⲞⲠⲤ ⲈⲦⲘⲦⲢⲈϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲐⲨⲀⲦⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ⲚⲈⲨⲀϢⲔⲀⲔ ϬⲈ ⲈⲂⲞⲖ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲚ ⲠⲈϤϢⲀϪⲈ. ⲚⲈⲀ ⲠⲘⲎⲎϢⲈ ⲄⲀⲢ ⲦⲰϨ. ⲀⲨⲰ ⲠⲈⲨϨⲞⲨⲞ ⲚⲈⲨⲤⲞⲞⲨⲚ ⲀⲚ ⲠⲈ ϪⲈ ⲚⲦⲀⲨⲤⲰⲞⲨϨ ⲈⲦⲂⲈ ⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲎⲎϢⲈ ⲀⲨⲚⲈϪ ⲞⲨⲀ ϪⲈ ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲈϨⲞⲨⲚ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲆⲈ ⲀϤϪⲰⲢⲘ ⲚⲦⲈϤϬⲒϪ. ⲀϤⲞⲨⲰϢ ⲈⲀⲠⲞⲖⲞⲄⲒⲌⲈ ⲘⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ⲚⲦⲈⲢⲞⲨⲈⲒⲘⲈ ⲆⲈ ϪⲈ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲠⲈ. ⲀⲨⲤⲘⲎ ⲚⲞⲨⲰⲦ ϢⲰⲠⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲚⲀⲞⲨⲚⲞⲨ ⲤⲚⲦⲈ. ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲚⲞϬ ⲦⲈ ⲦⲀⲢⲦⲈⲘⲒⲤ ⲚⲦⲈⲪⲈⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ⲠⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲔⲀⲦⲀⲤⲦⲒⲖⲈ ⲘⲠⲘⲎⲎϢⲈ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲢⲘⲚⲈⲪⲈⲤⲞⲤ. ⲚⲒⲘ ⲄⲀⲢ ⲚⲢⲰⲘⲈ ⲠⲈⲦⲈⲚϤⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲦⲠⲞⲖⲒⲤ ⲚⲈⲪⲈⲤⲞⲤ ⲈⲤϢⲘϢⲈ ⲚⲦⲚⲞϬ ⲚⲀⲢⲦⲨⲘⲒⲤ ⲘⲚ ⲠⲌⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ⲈⲢⲈ ⲚⲀⲒ ϬⲈ ⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϢϢⲈ ⲈⲢⲰⲦⲚ ⲈⲦⲢⲈⲦⲚⲤⲘⲚ ⲦⲎⲨⲦⲚ. ⲚⲦⲈⲦⲚ ⲦⲘⲢⲖⲀⲀⲨ ⲚϨⲰⲂ ϨⲚ ⲞⲨⲀⲤⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ⲀⲦⲈⲦⲚⲈⲒⲚⲈ ⲄⲀⲢ ⲚⲚⲈⲒⲢⲰⲘⲈ ⲈⲠⲈⲒⲘⲀ ⲘⲠⲞⲨϢⲖ ⲢⲠⲈ. ⲀⲨⲰ ⲘⲠⲞⲨϪⲒⲞⲨⲀ ⲈⲦⲚⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ⲈϢϪⲈ ⲦⲨⲘⲎⲦⲢⲒⲞⲤ ϬⲈ ⲀⲨⲰ ⲚⲈϤϢⲂⲢⲦⲈⲬ ⲚⲒⲦⲎⲤ ⲞⲨⲚⲦⲞⲨ ⲞⲨϢⲀϪⲈ ⲘⲘⲀⲨ. ϢⲀⲨⲚ ϨⲈⲚⲀⲄⲞⲢⲀⲒⲞⲤ. ⲀⲨⲰ ⲞⲨⲚ ϨⲈⲚⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲘⲀⲢⲞⲨⲤⲘⲘⲈ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ⲈϢϪⲈ ⲔⲈϨⲰⲂ ⲆⲈ ⲠⲈⲦⲈⲦⲚϢⲒⲚⲈ ⲚⲤⲰϤ. ⲤⲈⲚⲀⲂⲞⲖϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲞⲞⲨϨⲤ ⲈϢⲀⲤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ⲦⲚϬⲒⲚⲆⲨⲚⲈⲨⲈ ⲄⲀⲢ ⲈⲦⲢⲈⲨϮϢⲦⲞⲨⲎⲦ ⲈⲢⲞⲚ ⲈⲦⲂⲈ ⲠⲈⲒϢⲦⲞⲢⲦⲢ ⲘⲠⲞⲞⲨ ⲈⲘⲚ ϨⲰⲂ ⲚⲦⲘⲎⲦⲈ ⲈⲨⲚϢϬⲞⲘ ⲘⲘⲞⲚ ⲈϮⲖⲞⲄⲞⲤ ϨⲀⲢⲞϤ. ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲆⲈ ⲀϤⲔⲀ ⲠⲘⲎⲎϢⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ⲘⲚⲚⲤⲀ ⲦⲢⲈ ⲠⲈϢⲦⲞⲢⲦⲢ ⲆⲈ ⲖⲞ ⲀⲠⲀⲨⲖⲞⲤ ϪⲞⲞⲨ ⲚⲤⲀ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲤⲈⲠⲤⲰⲠⲞⲨ. ⲀⲨⲰ ⲀϤⲀⲤⲠⲀⲌⲈ ⲘⲘⲞⲞⲨ. ⲀϤⲈⲒ ⲈⲂⲞⲖ ⲈⲂⲰⲔ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ⲚⲦⲈⲢⲈϤⲘⲞⲨϢⲦ ⲆⲈ ⲚⲚⲤⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲨⲰ ⲀϤⲤⲈⲠⲤⲰⲠⲞⲨ ϨⲚ ⲞⲨϢⲀϪⲈ ⲈⲚⲀϢⲰϤ ⲀϤⲈⲒ ⲈⲐⲈⲖⲖⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲢ ϢⲞⲘⲚⲦ ⲚⲈⲂⲞⲦ ⲘⲘⲀⲨ. ⲀⲚⲒⲞⲨⲆⲀⲒ ⲢⲞⲨⲔⲢⲞϤ ⲈⲢⲞϤ ⲈϤⲚⲀⲤϬⲎⲢ ⲈⲦⲤⲨⲢⲒⲀ. ⲀϤϪⲒ ϢⲞϪⲚⲈ ⲈⲔⲦⲞϤ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ⲚⲈϤⲞⲨⲎϨ ⲆⲈ ⲚⲤⲰϤ ⲚϬⲒ ⲤⲰⲤⲒⲠⲀⲦⲢⲞⲤ ⲠϢⲎⲢⲈ ⲚⲠⲨⲢⲢⲞⲤ ⲠⲈⲂⲞⲖ ϨⲚ ⲂⲈⲢⲞⲒⲀ ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ⲘⲚ ⲤⲈⲔⲞⲨⲚⲦⲞⲤ ⲀⲨⲰ ⲔⲀⲒⲞⲤ ⲦⲈⲢⲂⲈⲞⲤ ⲘⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲦⲈⲪⲈⲤⲞⲤ ⲦⲨⲬⲒⲔⲞⲤ ⲀⲨⲰ ⲦⲢⲞⲪⲒⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ⲚⲀⲒ ⲘⲈⲚ ⲀⲨⲢϢⲞⲢⲠ ⲀⲨϬⲰ ⲈⲢⲞⲚ ϨⲚ ⲦⲢⲰⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲤϬⲎⲢ ⲈⲂⲞⲖ ϨⲚ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲚⲚⲤⲀ ⲚⲈϨⲞⲞⲨ ⲚⲀⲐⲀⲂ. ⲀⲚⲈⲒ ϢⲀⲢⲞⲞⲨ ⲪⲞⲨⲚ ⲚϮⲞⲨ ⲚϨⲞⲞⲨ ⲈⲦⲢⲰⲀⲤ. ⲀⲨⲰ ⲀⲚⲢ ⲤⲀϢϤ ⲚϨⲞⲞⲨ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ⲠⲞⲨⲀ ⲆⲈ ⲚⲚⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲚⲤⲞⲞⲨϨ ⲈⲠⲠⲰϢ ⲘⲠⲞⲒⲔ. ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲠⲈ ⲈϤⲚⲎⲨ ⲈⲂⲞⲖ ⲘⲠⲈϤⲢⲀⲤⲦⲈ. ⲚⲈϤⲤⲰⲔ ⲆⲈ ⲠⲈ ⲘⲠϢⲀϪⲈ ϢⲀ ⲦⲠⲀϢⲈ ⲚⲦⲈⲨϢⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ⲚⲈⲨⲚ ϨⲈⲚⲖⲀⲘⲠⲀⲤ ⲆⲈ ⲈⲚⲀϢⲰⲞⲨ ϪⲈⲢⲞ ϨⲚ ⲞⲨⲘⲀ ⲚⲦⲠⲈ ⲈⲚⲤⲞⲞⲨϨ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ⲀⲨⲰ ⲚⲈⲨⲚ ⲞⲨϨⲢϢⲒⲢⲈ ϨⲘⲞⲞⲤ ϨⲒϪⲘ ⲠϢⲞⲨϢⲦ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲨⲦⲨⲬⲞⲤ ⲈⲢⲈ ⲞⲨⲚⲞϬ ⲚϨⲒⲚⲎⲂ ⲤⲰⲔ ⲘⲘⲞϤ ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ϢⲀϪⲈ ⲀⲠϨⲒⲚⲎⲂ ϨⲢⲞϢ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈⲠⲈϨⲞⲨⲞ ⲀⲨⲰ ⲀϤϨⲈ ⲈⲂⲞⲖ ϨⲒϪⲚ ⲦⲘⲈϨϢⲞⲘⲦⲈ ⲚϨⲈ ⲈⲠⲈⲤⲎⲦ ⲀⲨⲰ ⲀⲨϤⲒⲦϤ ⲈϤⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ⲀⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲀϤⲠⲀϨⲦϤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲰⲖϬ ⲈⲢⲞϤ. ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲘⲠⲢϢⲦⲞⲢⲦⲢ ⲦⲈϤⲮⲨⲬⲎ ⲄⲀⲢ ϢⲞⲞⲠ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ⲚⲦⲈⲢⲈϤⲂⲰⲔ ⲆⲈ ⲈϨⲢⲀⲒ ⲀϤⲠⲰϢ ⲘⲠⲞⲈⲒⲔ ⲀϤϪⲒ ⲀⲨⲰ ⲀϤⲰⲤⲔ ⲈϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ϢⲀⲚⲦⲈ ⲠⲞⲨⲞⲈⲒⲚ ϨⲈ. ⲀⲨⲰ ⲚⲦⲈⲒϨⲈ ⲀϤⲈⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ⲀⲨⲈⲒⲚⲈ ⲆⲈ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲈϤⲞⲚϨ. ⲀⲨⲰ ⲀϤⲤⲈⲠⲤⲰⲠⲞⲨ ⲈⲘⲀⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲢϢⲞⲢⲠ ⲈⲂⲞⲖ ⲈⲠϪⲞⲒ ⲀⲚⲤϬⲎⲢ ⲈϨⲢⲀⲒ ⲈⲐⲀⲢⲤⲞⲤ ϪⲈ ⲈⲚⲈⲦⲀⲖⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲘⲀⲨ ⲦⲀⲒ ⲄⲀⲢ ⲦⲈ ⲐⲈ ⲚⲦⲀϤⲦⲞϢⲤ ⲚⲘⲘⲀⲚ ⲈϤⲚⲀⲘⲞⲞϢⲈ ⲚⲦⲞϤ ⲚⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ⲚⲦⲈⲢⲈϤⲦⲰⲘⲚⲦ ⲆⲈ ⲈⲢⲞⲚ ϨⲚ ⲐⲀⲢⲤⲞⲤ. ⲀⲚⲦⲀⲖⲞϤ ⲀⲚⲈⲒ ⲈⲘⲒⲦⲨⲖⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲚⲤϬⲎⲢ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲈⲒ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲬⲒⲞⲤ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲚⲘⲞⲞⲚⲈ ⲈⲤⲀⲘⲞⲤ ⲀⲨⲰ ⲚⲦⲈⲢⲚϢⲰⲠⲈ ϨⲚ ⲦⲢⲞⲄⲨⲖⲖⲒⲞⲤ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲚⲈⲒ ⲈⲘⲒⲖⲎⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ⲚⲈⲀ ⲠⲀⲨⲖⲞⲤ ⲄⲀⲢ ⲔⲢⲒⲚⲈ ⲈⲦⲘⲘⲞⲞⲚⲈ ⲈⲦⲈⲪⲈⲤⲞⲤ. ϪⲈⲔⲀⲀⲤ ⲚⲚⲈϤⲰⲤⲔ ϨⲚ ⲦⲀⲤⲒⲀ. ⲚⲈϤϬⲈⲠⲎ ⲄⲀⲢ ⲈϢⲰⲠⲈ ⲈϤⲚⲀϢϬⲘϬⲞⲘ ⲈⲢⲠⲈϨⲞⲞⲨ ⲚⲦⲠⲈⲚⲦⲎⲔⲞⲤⲦⲎ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲘⲒⲖⲎⲦⲞⲤ ⲀϤϪⲞⲞⲨ ⲈⲈⲪⲈⲤⲞⲤ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ⲚⲦⲈⲢⲞⲨⲈⲒ ⲆⲈ ϢⲀⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲚⲈⲤⲚⲎⲨ ϪⲈ ϪⲒⲚ ⲠϢⲞⲢⲠ ⲚϨⲞⲞⲨ ⲚⲦⲀⲒⲞⲨⲈϨ ⲢⲀⲦ ϨⲚ ⲦⲀⲤⲒⲀ. ⲚⲐⲈ ⲚⲦⲀⲒⲢ ⲠⲈⲒⲞⲨⲞⲈⲒϢ ⲦⲎⲢϤ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ⲈⲒⲞ ⲚϨⲘϨⲀⲖ ⲘⲠϪⲞⲈⲒⲤ ϨⲚ ⲐⲂⲂⲒⲞ ⲚⲒⲘ ⲘⲚ ϨⲈⲚⲢⲘⲈⲒⲞⲞⲨⲈ. ⲀⲨⲰ ⲘⲠⲈⲒⲢⲀⲤⲘⲞⲤ ⲚⲦⲀⲨϢⲰⲠⲈ ⲘⲘⲞⲒ ϨⲚ ⲚⲈⲠⲒⲂⲞⲨⲖⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ϪⲈ ⲘⲠⲒϨⲈⲠ ⲖⲀⲀⲨ ⲚⲚⲈⲦⲢⲚⲞϤⲢⲈ ⲚⲎⲦⲚ ⲈⲦⲘⲦⲀⲘⲰⲦⲚ ⲈⲢⲞⲞⲨ. ⲀⲨⲰ ⲈⲦⲘϮⲤⲂⲰ ⲚⲎⲦⲚ ⲦⲨⲘⲞⲤⲒⲀ. ⲀⲨⲰ ϨⲚ ⲚⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ⲈⲒⲢⲘⲚⲦⲢⲈ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ ⲚⲦⲘⲈⲦⲀⲚⲞⲒⲀ ⲈϨⲞⲨⲚ ⲈⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲦⲠⲒⲤⲦⲒⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ⲦⲈⲚⲞⲨ ϬⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮⲘⲎⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲒⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲚⲈⲦⲚⲀⲦⲰⲘⲚⲦ ⲈⲢⲞⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ⲠⲖⲎⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲢⲘⲚⲦⲢⲈ ⲚⲀⲒ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚ ϨⲈⲚⲘⲢⲢⲈ ⲘⲚ ϨⲈⲚⲐⲖⲒⲮⲒⲤ ϬⲈⲈⲦ ⲈⲢⲞⲔ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ⲀⲖⲖⲀ ⲚϮⲦⲀⲒⲞ ⲀⲚ ⲚⲦⲀⲮⲨⲬⲎ ϨⲀ ⲖⲀⲀⲨ ⲚϢⲀϪⲈ ⲚⲐⲈ ⲚϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲀⲆⲢⲞⲘⲞⲤ. ⲀⲨⲰ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲦⲀⲒϪⲒⲦⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲢⲀⲢⲘⲚⲦⲢⲈ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚⲞⲨⲈⲈⲒⲈⲚⲒⲚ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ⲦⲈⲚⲞⲨ ϬⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲚⲞⲔ ϮⲤⲞⲞⲨⲚ ϪⲈ ⲚⲦⲈⲦⲚ ⲀⲚⲀⲨ ϬⲈ ⲀⲚ ⲈⲠⲀϨⲞ ϪⲒⲚ ⲦⲈⲚⲞⲨ. ⲚⲦⲰⲦⲚ ⲦⲎⲢⲦⲚ. ⲚⲈⲚⲦⲀⲒⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ ⲈⲒⲔⲎⲢⲨⲤⲤⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲢⲘⲚⲦⲢⲈ ⲚⲎⲦⲚ ⲘⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ϪⲈ ϮⲞⲨⲀⲀⲂ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲚⲞϤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ⲘⲠⲒϨⲞⲠⲦ ⲄⲀⲢ ⲈⲦⲘⲦⲀⲘⲰⲦⲚ ⲈⲠϢⲞϪⲚⲈ ⲦⲎⲢϤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ⲠⲢⲞⲤⲈⲬⲈ ϬⲈ ⲈⲢⲰⲦⲚ ⲘⲚ ⲠⲞϨⲈ ⲦⲎⲢϤ ⲠⲀⲒ ⲚⲦⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲔⲀⲦⲎⲨⲦⲚ ⲚⲈⲠⲒⲤⲔⲞⲠⲞⲤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲈⲘⲞⲞⲚⲈ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠϪⲞⲈⲒⲤ ⲦⲚⲦⲀϤϪⲠⲞⲤ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϤⲤⲚⲞϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ϮⲤⲞⲞⲨⲚ ⲀⲚⲞⲔ ϪⲈ ⲘⲚⲚⲤⲀ ⲦⲢⲀⲂⲰⲔ ⲤⲈⲚⲎⲨ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ⲚϬⲒ ϨⲈⲚⲞⲨⲰⲚϢ ⲈⲨϨⲞⲢϢ ⲚⲤⲈϮⲤⲞ ⲀⲚ ⲈⲠⲞϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ⲀⲨⲰ ⲤⲈⲚⲀⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲚϬⲒ ϨⲈⲚⲢⲰⲘⲈ ⲈⲨϪⲰ ⲚϨⲈⲚϢⲀϪⲈ ⲈⲨϬⲞⲞⲘⲈ ⲈⲦⲢⲈⲨⲠⲰϬⲤ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲠⲀϨⲞⲨ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲢⲞⲈⲒⲤ ⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲠⲘⲈⲈⲨⲈ ϪⲈ ⲈⲒⲤ ϢⲞⲘⲦⲈ ⲚⲢⲞⲘⲠⲈ ⲚⲦⲈⲨϢⲎ ⲘⲚ ⲠⲈϨⲞⲞⲨ ⲘⲠⲒⲖⲞ ⲈⲒϮⲤⲂⲰ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲰⲦⲚ ϨⲚ ϨⲈⲚⲢⲘⲈⲒⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ⲦⲈⲚⲞⲨ ϬⲈ ϮϮ ⲘⲘⲰⲦⲚ ⲈⲦⲞⲞⲦϤ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲠϢⲀϪⲈ ⲚⲦⲈϤⲬⲀⲢⲒⲤ. ⲠⲈⲦⲈⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲔⲰⲦ ⲘⲘⲰⲦⲚ. ⲀⲨⲰ ⲈϮ ⲚⲎⲦⲚ ⲚⲦⲈⲔⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ϨⲚ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ⲘⲠⲒⲈⲠⲒⲐⲨⲘⲒ ⲈⲖⲀⲀⲨ ⲚϨⲀⲦ ⲎⲚⲞⲨⲂ. ⲎϨⲞⲒⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲀⲚⲈⲒϬⲒϪ ϢⲘϢⲈ ⲚⲚⲀⲬⲢⲒⲀ ⲘⲚ ⲚⲈⲦⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ⲈⲒⲦⲀⲘⲞ ⲘⲘⲰⲦⲚ ⲈϨⲰⲂ ⲚⲒⲘ ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈϢϢⲈ ⲈⲢⲰⲦⲚ ⲈϢⲠϨⲒⲤⲈ ⲚⲦⲈⲦⲚϤⲒ ϨⲀ ⲚⲈⲦⲚϢⲰⲚⲈ ⲚⲦⲈⲦⲚ ⲢⲠⲘⲈⲈⲨⲈ ⲚⲚϢⲀϪⲈ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲦⲞϤ ⲠⲈⲚⲦⲀϤϪⲞⲞⲤ ϪⲈ ⲞⲨⲘⲚⲦⲘⲀⲔⲀⲢⲒⲞⲤ ⲠⲈ ϮⲈϨⲞⲨ ⲈϪⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲆⲈ ⲚϬⲒ ⲠⲀⲨⲖⲞⲤ ⲀϤⲔⲰⲖϪ ⲚⲚⲈϤⲠⲀⲦ ⲚⲘⲘⲀⲨ ⲦⲎⲢⲞⲨ ⲀϤϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ⲀⲨⲚⲞϬ ⲆⲈ ⲚⲢⲒⲘⲈ ⲦⲀϨⲈ ⲞⲨⲞⲚ ⲚⲒⲘ. ⲀⲨⲰ ⲀⲨⲠⲀϨⲦⲞⲨ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲘⲀⲔϨ ⲘⲠⲀⲨⲖⲞⲤ ⲀⲨϮⲠⲒ ⲈⲢⲰϤ ");
INSERT INTO copshc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ⲈⲨⲘⲞⲔϨ ⲚϨⲎⲦ ⲚϨⲞⲨⲞ ⲈϪⲘ ⲠϢⲀϪⲈ ⲚⲦⲀϤϪⲞⲞϤ ϪⲈ ⲚⲦⲈⲦⲚⲀⲔⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲚ ⲈⲚⲀⲨ ⲈⲠⲀϨⲞ. ⲚⲈⲨⲐⲠⲞ ⲆⲈ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲈⲠϪⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ⲚⲦⲈⲢⲈⲤϢⲰⲠⲈ ⲆⲈ ⲈⲦⲢⲈⲚⲞⲨⲈ ⲘⲘⲞⲞⲨ ⲚⲦⲚⲔⲰ ⲈⲂⲞⲖ ⲀⲚⲤϬⲎⲢ ⲀⲚⲈⲒ ⲈϨⲢⲀⲒ ⲈⲔⲰ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲈϨⲢⲞⲆⲞⲤ ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲠⲀⲦⲀⲢⲀ ⲘⲚⲚⲤⲰⲤ ⲈⲘⲨⲢⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ⲀⲨⲰ ⲚⲦⲈⲢⲚϨⲈ ⲈⲨϪⲞⲒ ⲈϤⲚⲀϪⲒⲞⲞⲢ ⲈⲦⲈⲪⲞⲒⲚⲒⲔⲎ ⲀⲚⲀⲖⲈ ⲀⲚⲔⲰ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ⲚⲦⲈⲢⲚⲠⲰϨ ⲆⲈ ⲈⲔⲨⲠⲢⲞⲤ ⲀⲚⲔⲀⲀⲤ ϨⲒ ϨⲂⲞⲨⲢ ⲘⲘⲞⲚ ⲀⲚⲤϬⲎⲢ ⲈⲦⲤⲨⲢⲒⲀ. ⲀⲨⲰ ⲀⲚⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲨⲢⲞⲤ. ⲚⲈⲢⲈ ⲠϪⲞⲒ ⲄⲀⲢ ⲚⲀϢⲞⲨⲞ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ⲀⲨⲰ ⲚⲦⲈⲢⲚϨⲈ ⲈⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲚϬⲰ ϨⲀⲦⲎⲨ ⲚⲤⲀϢϤ ⲚϨⲞⲞⲨ. ⲚⲀⲒ ⲆⲈ ⲚⲈⲨϪⲰ ⲘⲘⲞⲤ ⲘⲠⲀⲨⲖⲞⲤ ⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲘⲦⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ⲚⲦⲈⲢⲈⲤϢⲰⲠⲈ ⲆⲈ ⲈⲦⲢⲈⲚϪⲰⲔ ⲈⲂⲞⲖ ⲚⲚⲈⲒϨⲞⲞⲨ ⲀⲚⲈⲒ ⲈⲂⲞⲖ ⲀⲚⲘⲞⲞϢⲈ ⲈⲨⲐⲠⲞ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲘⲚ ⲚⲈⲨϨⲒⲞⲘⲈ ⲘⲚ ⲚⲈⲨϢⲎⲢⲈ ϢⲀ ⲠⲂⲞⲖ ⲚⲦⲠⲞⲖⲒⲤ ⲀⲨⲰ ⲚⲦⲈⲢⲚⲔⲰⲖϪ ⲚⲚⲈⲚⲠⲀⲦ ϨⲒ ⲠⲈⲔⲢⲞ ⲀⲚϢⲖⲎⲖ ");
INSERT INTO copshc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ⲀⲨⲰ ⲀⲚⲀⲤⲠⲀⲌⲈ ⲚⲚⲈⲚⲈⲢⲎⲨ. ⲀⲚⲀⲖⲈ ⲈⲠϪⲞⲒ. ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲚⲈⲨⲎⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲢϨⲰⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲨⲢⲞⲤ. ⲀⲚⲔⲀⲦⲀⲚⲦⲀ ⲈϨⲢⲀⲒ ⲈⲠⲦⲞⲖⲈⲘⲀⲈⲒⲤ. ⲀⲨⲰ ⲚⲦⲈⲢⲚⲀⲤⲠⲀⲌⲈ ⲚⲚⲈⲤⲚⲎⲨ ⲀⲚϬⲰ ϨⲀⲦⲎⲨ ⲚⲞⲨϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲚⲦⲈⲢⲚⲈⲒ ⲈⲂⲞⲖ ⲀⲚⲈⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲨⲰ ⲀⲚⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲢⲈϤⲦⲀϢⲈⲞⲈⲒϢ ⲈⲞⲨⲀ ϨⲘ ⲠⲤⲀϢϤ ⲠⲈ ⲀⲚϬⲰ ϨⲀϨⲦⲎϤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ⲠⲀⲒ ⲆⲈ ⲚⲈⲨⲚⲦϤ ϤⲦⲞ ⲚϢⲈⲈⲢⲈ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ ⲈϢⲀⲨⲠⲢⲞⲪⲎⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ⲀⲨⲰ ⲚⲦⲈⲢⲚϬⲰ ⲘⲘⲀⲨ ⲚϨⲀϨ ⲚϨⲞⲞⲨ. ⲀⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲄⲀⲂⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ⲀⲨⲰ ⲚⲦⲈⲢⲈϤⲈⲒ ϢⲀⲢⲞⲚ ⲀϤϤⲒ ⲘⲠⲘⲞϪϨ ⲘⲠⲀⲨⲖⲞⲤ ⲀϤⲘⲞⲨⲢ ⲚⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ ⲘⲚ ⲚⲈϤϬⲒϪ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲒ ⲚⲈⲦⲈⲢⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϪⲰ ⲘⲘⲞⲞⲨ ϪⲈ ⲠⲢⲰⲘⲈ ⲈⲦⲈⲠⲰϤ ⲠⲈ ⲠⲈⲒⲘⲞϪϨ ⲤⲈⲚⲀⲘⲞⲢϤ ⲚⲦⲈⲒϨⲈ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲚⲤⲈⲦⲀⲀϤ ⲈϨⲢⲀⲒ ⲈⲚϬⲒϪ ⲚⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ⲚⲦⲈⲢⲚⲤⲰⲦⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲚⲤⲈⲠⲤⲰⲠϤ ⲀⲚⲞⲚ ⲘⲚ ⲚⲈⲦϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲘⲦⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ⲦⲞⲦⲈ ⲀⲠⲀⲨⲖⲞⲤ ⲞⲨⲰϢⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞϤ ⲈⲦⲈⲦⲚⲢⲒⲘⲈ ⲀⲨⲰ ⲈⲦⲈⲦⲚⲞⲨⲰϢϤ ⲘⲠⲀϨⲎⲦ. ⲀⲚⲞⲔ ⲄⲀⲢ ϮⲤⲂⲦⲰⲦ ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲦⲢⲈⲨⲘⲞⲢⲦ ⲀⲖⲖⲀ ⲈⲦⲢⲀⲘⲞⲨ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲀ ⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ⲚⲦⲈⲢⲈϤⲦⲘⲠⲒⲐⲈ ⲆⲈ ⲀⲚⲔⲀⲢⲰⲚ ⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀⲢⲈ ⲠⲞⲨⲰϢ ⲘⲠϪⲞⲈⲒⲤ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ⲘⲚⲚⲤⲀ ⲚⲈⲒϨⲞⲞⲨ ⲆⲈ ⲀⲚⲤⲂⲦⲰⲦⲚ ⲀⲚⲘⲞⲞϢⲈ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ⲀⲨⲈⲒ ⲆⲈ ⲚⲘⲘⲀⲚ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲘⲘⲀⲐⲎⲦⲎⲤ ⲈⲦϨⲚ ⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲨϪⲒⲦⲚ ϢⲀ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲢⲬⲀⲒⲞⲤ ⲚⲔⲨⲠⲢⲒⲞⲤ ϪⲈ ⲘⲚ ⲀⲤⲰⲚ ⲈⲦⲢⲈⲚϬⲞⲒⲖⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ⲚⲦⲈⲢⲚⲠⲰϨ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲚⲈⲤⲚⲎⲨ ϢⲞⲠⲚ ⲈⲢⲞⲞⲨ ϨⲚ ⲞⲨⲢⲀϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤⲈⲒ ⲚⲘⲘⲀⲚ ⲈϨⲞⲨⲚ ϢⲀ ⲒⲀⲔⲰⲂⲞⲤ. ⲚⲈⲨⲤⲞⲞⲨϨ ⲆⲈ ⲈⲢⲞϤ ⲠⲈ ⲚϬⲒ ϨⲈⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ⲚⲀⲒ ⲚⲦⲈⲢϤⲀⲤⲠⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲀϤϨⲘⲞⲞⲤ ⲀϤⲦⲀⲨⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲚⲈϨⲂⲎⲨⲈ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀⲀⲨ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈϤⲆⲒⲀⲔⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲀⲨϮⲈⲞⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲔⲚⲀⲨ ⲠⲤⲞⲚ ϪⲈ ⲞⲨⲎⲢ ⲚⲦⲂⲀ ϢⲞⲞⲠ ⲚⲚⲈⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲤⲈⲞ ⲚⲢⲈϤⲔⲰϨ ⲈⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ⲀⲨⲤⲰⲦⲘ ⲈⲦⲂⲎⲎⲦⲔ ϪⲈ ⲔϮⲤⲂⲰ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲈⲦⲢⲈⲨⲤⲀϨⲰⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲰⲨⲤⲎⲤ ⲈⲔϪⲰ ⲘⲘⲞⲤ ⲚⲀⲨ ⲈⲦⲘⲤⲂⲂⲈ ⲚⲈⲨϢⲎⲢⲈ ⲀⲨⲰ ⲈⲦⲘⲘⲞⲞϢⲈ ϨⲚ ⲚⲈϤⲤⲰⲚⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲀϢⲰⲠⲈ ⲠⲀⲚⲦⲰⲤ ⲤⲈⲚⲀⲤⲰⲦⲘ ϪⲈ ⲀⲔⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ⲀⲢⲒ ⲠⲀⲒ ϬⲈ ⲈⲦⲚϪⲰ ⲘⲘⲞϤ ⲚⲀⲔ. ⲞⲨⲚ ϤⲦⲞⲞⲨ ⲚⲢⲰⲘⲈ ⲈⲨϢⲞⲞⲠ ⲚⲀⲚ ⲈⲨⲚⲦⲀⲨ ⲘⲘⲀⲨ ⲚⲞⲨⲈⲢⲎⲦ ϨⲀⲢⲞⲞⲨ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ⲚⲀⲒ ϪⲒⲦⲞⲨ ⲚⲄⲦⲂⲂⲞⲔ ⲚⲘⲘⲀⲨ ⲀⲨⲰ ⲚⲄϪⲞ ⲈⲢⲞⲞⲨ ⲈⲂⲞⲖ ⲈⲦⲢⲈⲨϨⲈⲔ ⲈϪⲰⲞⲨ ⲀⲨⲰ ⲤⲈⲚⲀⲈⲒⲘⲈ ⲦⲎⲢⲞⲨ ϪⲈ ϨⲈⲚϬⲞⲖ ⲚⲈⲚⲦⲀⲨⲤⲞⲦⲘⲞⲨ ⲈⲦⲂⲎⲦⲔ ⲀⲖⲖⲀ ϪⲈ ⲚⲦⲞⲔ ϨⲰⲰⲔ ⲔⲀϨⲈ ⲈⲠⲚⲞⲘⲞⲤ ⲈⲔϨⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ⲈⲦⲂⲈ ⲚϨⲈⲐⲚⲞⲤ ⲆⲈ ⲚⲦⲀⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲘⲚⲦⲞⲨ ⲖⲀⲀⲨ ⲚϢⲀϪⲈ ⲈϪⲰ ⲚⲀⲔ ⲀⲚⲞⲚ ⲄⲀⲢ ⲀⲚⲔⲢⲒⲚⲈ ⲀⲨⲰ ⲀⲚⲤϨⲀⲒ ⲚⲀⲨ ⲈⲦⲢⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞⲞⲨ ⲈϢⲰⲰⲦ ⲚⲈⲒⲆⲰⲖⲞⲚ ⲘⲚ ⲠⲈⲤⲚⲞϤ ⲀⲨⲰ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲘⲚ ⲦⲠⲞⲢⲚⲈⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤϪⲒ ⲚⲚⲢⲰⲘⲈ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲀϤⲦⲂⲂⲞϤ ⲚⲘⲘⲀⲨ. ⲀⲨⲰ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ ⲈϤⲦⲀⲨⲞ ⲚⲚⲈϨⲞⲞⲨ ⲘⲠϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲦⲂⲂⲞ. ϢⲀⲚⲦⲞⲨⲦⲀⲖⲈ ⲐⲨⲤⲒⲀ ⲈϨⲢⲀⲒ ϨⲀ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ⲚⲦⲈⲢⲈ ⲠⲤⲀϢϤ ⲆⲈ ⲚϨⲞⲞⲨ ϨⲰⲚ ⲈϪⲰⲔ ⲈⲂⲞⲖ ⲚⲒⲞⲨⲆⲀⲒ ⲚⲈⲂⲞⲖ ϨⲚ ⲦⲀⲤⲒⲀ ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨⲤⲈⲨϨ ⲠⲘⲎⲎ ϢⲈ ⲦⲎⲢϤ ⲀⲨⲈⲒⲚⲈ ⲚⲚⲈⲨϬⲒϪ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ");
INSERT INTO copshc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲦⲈ ⲠⲒⲤⲢⲀⲎⲖ ⲂⲞⲎⲐⲒ ⲠⲀⲒ ⲠⲈ ⲠⲢⲰⲘⲈ ⲈⲦϮ ⲞⲨⲂⲈ ⲠⲖⲀⲞⲤ ⲘⲚ ⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲠⲈⲒⲢⲠⲈ ⲈϤϮⲤⲂⲰ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ϨⲘ ⲘⲀ ⲚⲒⲘ ⲀⲨⲰ ⲞⲚ ⲀϤⲚ ϨⲈⲚⲞⲨⲈⲈⲒⲈⲚⲒⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ ⲀϤϪⲰϨⲘ ⲘⲠⲈⲒⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ⲚⲈ ⲀⲨⲚⲀⲨ ⲄⲀⲢ ⲠⲈ ⲈⲦⲢⲞⲪⲒⲘⲞⲤ ⲠⲢⲘⲚⲈⲪⲈⲤⲞⲤ ϨⲚ ⲦⲠⲞⲖⲒⲤ ⲚⲘⲘⲀϤ. ⲈⲨⲘⲈⲈⲨⲈ ϪⲈ ⲚⲦⲀ ⲠⲀⲨⲖⲞⲤ ϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ⲈⲀ ⲦⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲚⲞⲒⲚ. ⲀⲨⲰ ⲠⲖⲀⲞⲤ ⲀⲨⲤⲰⲞⲨϨ ⲀⲨⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲀⲨⲤⲰⲔ ⲘⲘⲞϤ ⲠⲂⲞⲖ ⲘⲠⲈⲢⲠⲈ. ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀⲨϢⲦⲀⲘ ⲚⲚⲢⲞ ");
INSERT INTO copshc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ⲈⲨϢⲒⲚⲈ ⲆⲈ ⲚⲤⲀ ϨⲞⲦⲂⲈϤ ⲀⲠⲞⲨⲰ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲘⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲦⲈⲤⲠⲒⲢⲀ ϪⲈ ⲀⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲦⲎⲢⲤ ϢⲦⲞⲢⲦⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤϪⲒ ⲚϨⲈⲚϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲘⲚ ϨⲈⲚϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲘⲚ ϨⲈⲚⲘⲀⲦⲞⲒ ⲀϤⲠⲰⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲞⲨ. ⲚⲦⲈⲢⲞⲨⲚⲀⲨ ⲆⲈ ⲈⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲘⲚ ⲚϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲀⲨⲰ ⲘⲘⲀⲦⲞⲒ ⲀⲨⲖⲞ ⲈⲨϨⲒⲞⲨⲈ ⲈⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ⲦⲞⲦⲈ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲀϤⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ. ⲀⲨⲰ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲘⲞⲢϤ ⲚϨⲀⲖⲨⲤⲒⲤ ⲤⲚⲦⲈ. ⲀϤϢⲒⲚⲈ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲀⲨⲰ ⲞⲨ ⲠⲈⲚⲦⲀϤⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ⲚⲈⲢⲈ ⲠⲘⲎⲎϢⲈ ⲆⲈ ⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲚ ⲠⲈϤϢⲀϪⲈ. ⲘⲠϤⲈϢϬⲘϬⲞⲘ ⲈⲈⲒⲘⲈ ⲈⲠⲰⲢϪ ⲈⲦⲂⲈ ⲠⲈϢⲦⲞⲢⲦⲢ. ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϪⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ⲚⲦⲈⲢⲞⲨⲠⲰϨ ⲆⲈ ⲈϪⲚ ⲚⲦⲰⲢⲦⲢ. ⲀⲤϢⲰⲠⲈ ⲈⲦⲢⲈ ⲘⲘⲀⲦⲞⲒ ⲦⲀⲖⲞϤ ⲈϪⲰⲞⲨ ⲈⲦⲂⲈ ⲐⲞⲢⲘⲎ ⲘⲠⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ⲚⲈⲢⲈ ⲠⲖⲀⲞⲤ ⲄⲀⲢ ⲦⲎⲢϤ ⲞⲨⲎϨ ⲚⲤⲰϤ ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲒ ⲚⲦⲘⲎⲦⲈ ⲘⲠⲈⲚϪⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ⲈⲨⲚⲀϪⲒ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈϨⲞⲨⲚ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ⲠⲈϪⲀϤ ⲘⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ϪⲈ ⲈⲚⲈⲤⲦⲞ ⲚⲀⲒ ⲈⲦⲢⲀϪⲈ ⲞⲨϢⲀϪⲈ ⲈⲢⲞⲔ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲈⲚⲈⲔⲤⲞⲞⲨⲚ ⲘⲘⲚⲦⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ⲈⲒⲈ ⲚⲦⲞⲔ ⲀⲚ ϬⲈ ⲠⲈ ⲠⲢⲘⲚⲔⲎⲘⲈ ⲠⲈⲚⲦⲀϤⲂⲰϬⲤ ϨⲀⲐⲎ ⲚⲚⲈⲒϨⲞⲞⲨ. ⲀⲨⲰ ⲀϤϪⲒ ⲈⲂⲞⲖ ⲈⲦⲈⲢⲎⲘⲞⲤ ⲚⲀϤⲦⲞⲨ ϢⲞ ⲚⲢⲰⲘⲈ ⲚⲤⲒⲔⲀⲢⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲄ ⲞⲨⲢⲰⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲀⲚⲄ ⲞⲨⲢⲘⲦⲀⲢⲤⲞⲤ ⲚⲦⲔⲒⲖⲒⲔⲒⲀ ⲘⲠⲞⲖⲒⲦⲎⲤ ⲚⲞⲨⲠⲞⲖⲒⲤ ⲈⲤⲞ ⲚⲤⲞⲈⲒⲦ ϮⲤⲞⲠⲤ ⲆⲈ ⲘⲘⲞⲔ ⲔⲀⲀⲦ ⲦⲀϢⲀϪⲈ ⲘⲚ ⲠⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ⲚⲦⲈⲢⲈϤⲔⲀⲀϤ ⲆⲈ ⲚϬⲒ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ. ⲠⲀⲨⲖⲞⲤ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲒϪⲚ ⲚⲦⲰⲢⲦⲢ ⲀϤⲔⲒⲘ ⲚⲦⲈϤϬⲒϪ ⲈⲠⲖⲀⲞⲤ. ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲚⲤϬⲢⲈϨⲦ ϢⲰⲠⲈ ⲀϤⲞⲨⲰϢⲂ ⲚⲀⲨ ⲚⲦⲀⲤⲠⲈ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲀⲨⲰ ⲚⲀⲈⲒⲞⲦⲈ ⲤⲰⲦⲘ ⲈⲦⲀⲀⲠⲞⲖⲞⲄⲒⲀ ⲈⲦϢⲞⲞⲠ ⲦⲈⲚⲞⲨ ϢⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲆⲈ ϪⲈ ⲈϤⲚⲀϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ⲀⲨⲔⲀⲢⲰⲞⲨ ⲚϨⲞⲨⲞ. ⲀⲨⲰ ⲠⲈϪⲀϤ ");
INSERT INTO copshc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ϪⲈ ⲀⲚⲄ ⲞⲨⲢⲰⲘⲈ ⲚⲒⲞⲨⲆⲀⲒ. ⲈⲀⲨϪⲠⲞⲒ ϨⲚ ⲦⲀⲢⲤⲞⲤ ⲚⲦⲔⲒⲖⲒⲔⲒⲀ ⲈⲀⲨⲤⲀⲚⲞⲨϢⲦ ⲆⲈ ϨⲚ ⲦⲈⲒⲠⲞⲖⲒⲤ ⲈⲀⲨⲠⲀⲒⲆⲈⲨⲈ ⲘⲘⲞⲒ ϨⲚ ⲞⲨⲰⲢϪ ϨⲀⲢⲀⲦϤ ⲚⲄⲀⲘⲀⲖⲒⲎⲖ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲚⲚⲀⲈⲒⲞⲦⲈ. ⲈⲒⲞ ⲚⲢⲈϤⲔⲰϨ ⲈⲠⲚⲞⲨⲦⲈ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲈⲦⲚⲞ ⲘⲘⲞⲤ ⲘⲠⲞⲞⲨ ⲚⲦⲰⲦⲚ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ⲀⲒⲆⲒⲰⲔⲈ ⲚⲤⲀ ⲦⲈⲒϨⲒⲎ ϢⲀϨⲢⲀⲒ ⲈⲠⲘⲞⲨ. ⲈⲒⲘⲞⲨⲢ ⲚⲚⲢⲰⲘⲈ ⲀⲨⲰ ⲚⲈϨⲒⲞⲘⲈ ⲈⲒⲚⲞⲨϪⲈ ⲘⲘⲞⲞⲨ ⲈⲚⲈϢⲦⲈⲔⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ⲚⲐⲈ ⲞⲚ ⲈⲢⲈ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲢⲘⲚⲦⲢⲈ ⲚⲀⲒ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ⲚⲀⲒ ⲚⲦⲀⲒϪⲒ ⲚϨⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲞⲞⲦⲞⲨ. ⲀⲒⲂⲰⲔ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲈⲦⲢⲀⲈⲒⲚⲈ ⲞⲚ ⲚⲚⲈⲦⲘⲘⲀⲨ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲦⲒⲘⲰⲢⲒ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲘⲞⲒ ⲈⲒⲘⲞⲞϢⲈ. ⲚⲦⲈⲢⲈⲒϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲘⲠⲚⲞⲨ ⲘⲘⲈⲈⲢⲈ. ⲀⲨⲚⲞϬ ⲚⲞⲨⲞⲈⲒⲚ ϢⲀ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ⲀⲒϨⲈ ⲆⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ. ⲀⲨⲰ ⲀⲒⲤⲰⲦⲘ ⲈⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲒ ϪⲈ ⲤⲀⲨⲖⲈ ⲤⲀⲨⲖⲈ ⲀϨⲢⲞⲔ ⲔⲠⲎⲦ ⲚⲤⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲞⲨⲰϢⲂ ϪⲈ ⲚⲦⲔ ⲚⲒⲘ ⲠϪⲞⲈⲒⲤ. ⲠⲈϪⲀϤ ⲚⲀⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲠⲈⲦⲔⲠⲎⲦ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ⲚⲈⲦⲘⲞⲞϢⲈ ⲆⲈ ⲚⲘⲘⲀⲒ ⲀⲨⲚⲀⲨ ⲈⲠⲞⲨⲞⲈⲒⲚ ⲀⲨⲰ ⲀⲨϢⲰⲠⲈ ϨⲚ ⲞⲨϨⲞⲦⲈ. ⲘⲠⲞⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲦⲈⲤⲘⲎ ⲘⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ⲠⲈϪⲀⲒ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲞⲨ ⲠⲈϮⲚⲀⲀⲀϤ. ⲠⲈϪⲀϤ ⲚⲀⲒ ϪⲈ ⲦⲰⲞⲨⲚ ⲚⲄⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ⲀⲨⲰ ⲤⲈⲚⲀϢⲀϪⲈ ⲚⲘⲘⲀⲔ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲦⲂⲈ ϨⲰⲂ ⲚⲒⲘ ⲚⲦⲀⲒⲦⲞϢⲞⲨ ⲚⲀⲔ ⲈⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ⲚⲦⲈⲢⲒⲦⲰⲞⲨⲚ ⲆⲈ ⲀⲒⲖⲞ ⲈⲒⲚⲀⲨ ⲈⲂⲞⲖ ϨⲀ ⲠⲈⲞⲞⲨ ⲘⲠⲞⲨⲞⲈⲒⲚ ⲈⲦⲘⲘⲀⲨ. ⲀⲨϪⲒ ⲘⲞⲈⲒⲦ ⲆⲈ ϨⲎⲦ ⲚϬⲒ ⲚⲈⲦⲚⲘⲘⲀⲒ ⲀⲒⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ⲞⲨⲢⲰⲘⲈ ⲆⲈ ϪⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲞⲨⲢⲈϤⲢϨⲞⲦⲈ ⲔⲀⲦⲀⲠⲚⲞⲘⲞⲤ. ⲈⲨⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲞⲨⲎϨ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ⲀϤⲈⲒ ϢⲀⲢⲞⲒ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲒϪⲰⲒ ⲠⲈϪⲀϤ ⲚⲀⲒ. ϪⲈ ⲤⲀⲨⲖⲈ ⲠⲀⲤⲞⲚ ⲀⲚⲀⲨ ⲈⲂⲞⲖ. ⲀⲚⲞⲔ ⲆⲈ ⲚⲦⲈⲨⲚⲞⲨ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲒ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲀϤⲚⲈϨⲔ ⲈⲂⲞⲖ ⲈⲤⲞⲨⲚ ⲠⲈϤⲞⲨⲰϢ. ⲀⲨⲰ ⲈⲚⲀⲨ ⲈⲠⲆⲒⲔⲀⲒⲞⲤ. ⲀⲨⲰ ⲈⲤⲰⲦⲘ ⲈⲨⲤⲘⲎ ⲈⲂⲞⲖ ϨⲚ ⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ϪⲈ ⲔⲚⲀϢⲰⲠⲈ ⲚⲀϤ ⲘⲘⲚⲦⲢⲈ ⲚⲚⲀϨⲢⲚ ⲢⲰⲘⲈ ⲚⲒⲘ ⲚⲚⲈⲚⲦⲀⲔⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲨⲰ ⲀⲔⲤⲞⲦⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ⲦⲈⲚⲞⲨ ϬⲈ ⲞⲨ ⲠⲈⲦⲔⲚⲀⲀⲀϤ ⲦⲰⲞⲨⲚ ⲚⲄϪⲒⲂⲀⲠⲦⲒⲤⲘⲀ ⲚⲄⲈⲒⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲔⲚⲞⲂⲈ ⲀⲨⲰ ⲚⲄⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ⲀⲤϢⲰⲠⲈ ⲚⲦⲈⲢⲒⲔⲦⲞⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨⲰ ⲈⲒϢⲖⲎⲖ ϨⲘ ⲠⲈⲢⲠⲈ. ⲀⲒϢⲰⲠⲈ ϨⲚ ⲞⲨⲈⲔⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ⲀⲚⲀⲨ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲒ ϪⲈ ϬⲈⲠⲎ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ϪⲈ ⲤⲈⲚⲀϪⲒ ⲘⲚⲦⲘⲚⲦⲢⲈ ⲀⲚ ⲚⲦⲞⲞⲦⲔ ⲈⲦⲂⲎⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ⲀⲚⲞⲔ ϨⲰ ⲠⲈϪⲀⲒ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲦⲞⲞⲨ ⲤⲈⲤⲞⲞⲨⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲚⲈⲒⲰⲦⲠ ⲈϨⲞⲨⲚ ⲀⲨⲰ ⲈⲦϨⲒⲞⲨⲈ ϨⲚ ⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ⲀⲨⲰ ⲞⲚ ⲈⲨⲚⲀⲠⲰϨⲦ ⲈⲂⲞⲖ ⲘⲠⲈⲤⲚⲞϤ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲠⲈⲔⲘⲚⲦⲢⲈ. ⲀⲚⲞⲔ ϨⲰ ⲚⲈⲒⲀϨⲈⲢⲀⲦ ⲈⲒⲤⲨⲚⲈⲨⲆⲞⲔⲒ ⲀⲨⲰ ⲈⲒϨⲀⲢⲈϨ ⲈⲚϨⲞⲒⲦⲈ ⲚⲚⲈⲦⲚⲀϨⲰⲦⲂ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ⲠⲈϪⲀϤ ⲚⲀⲒ ϪⲈ ⲂⲰⲔ ϪⲈ ⲈⲒⲚⲀϪⲞⲞⲨⲔ ⲀⲚⲞⲔ ⲈϨⲈⲚϨⲈⲐⲚⲞⲤ ⲈⲨⲞⲨⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ⲀⲨⲤⲰⲦⲘ ⲆⲈ ⲈⲢⲞϤ ⲚϬⲒ ⲘⲘⲎⲎϢⲈ ϢⲀ ⲠⲈⲒϢⲀϪⲈ. ⲀⲨⲰ ⲀⲨϤⲒϨⲢⲀⲨ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲒ ⲠⲀⲒ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲈⲂⲞⲖ ϨⲒϪⲘⲠⲔⲀϨ. ⲚϢϢⲈ ⲄⲀⲢ ⲀⲚ ⲈⲢⲞϤ ⲈⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ⲈⲨⲀϢⲔⲀⲔ ⲆⲈ ⲈⲂⲞⲖ ⲈⲨϤⲒ ⲈϨⲢⲀⲒ ⲚⲚⲈⲨϨⲞⲒⲦⲈ. ⲀⲨⲰ ⲈⲨⲚⲈϪ ϢⲞⲈⲒϢ ⲈϨⲢⲀⲒ ⲈⲠⲀⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ⲀⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲆⲈ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϪⲒⲦϤ ⲈϨⲞⲨⲚ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ⲈⲀϤϪⲞⲞⲤ ⲈϨⲒⲞⲨⲈ ⲈⲢⲞϤ ⲚϨⲈⲚⲘⲀⲤⲦⲒⲄⲜ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲈⲒⲘⲈ ϪⲈ ⲈⲦⲂⲈ ⲀϢ ⲚⲖⲞⲒϬⲈ ⲈⲚⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ⲈⲢⲞϤ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ⲚⲦⲈⲢⲞⲨⲤⲞⲘⲚⲦϤ ⲆⲈ ⲚⲘⲘⲞⲨⲤ. ⲠⲈϪⲀϤ ⲚϬⲒ ⲠⲀⲨⲖⲞⲤ ⲘⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈⲦⲀϨⲈⲢⲀⲦϤ ϪⲈ ⲈⲚⲈⲤⲦⲞ ⲚⲎⲦⲚ ⲈϨⲒⲞⲨⲈ ⲈⲨⲢⲰⲘⲈ ⲚϨⲢⲰⲘⲀⲒⲞⲤ ⲈⲘⲚ ⲚⲞⲂⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ. ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲈⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤⲦⲀⲘⲞϤ ϪⲈ ⲀⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲔⲚⲀⲀⲀϤ. ⲠⲈⲒⲢⲰⲘⲈ ⲄⲀⲢ ⲞⲨϨⲢⲰⲘⲀⲒⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ⲀϤϮ ⲠⲈϤⲞⲨⲞⲒ ⲆⲈ ⲚϬⲒ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤϪⲚⲞⲨϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲞⲔ ⲚⲦⲔ ⲞⲨϨⲢⲰⲘⲀⲒⲞⲤ. ⲚⲦⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲈϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ⲀⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲆⲈ ⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲀⲒϮ ⲞⲨⲚⲞϬ ⲚⲬⲢⲎⲘⲀ ϨⲀ ⲦⲈⲒⲠⲞⲖⲒⲦⲒⲀ. ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲆⲈ ⲚⲦⲀⲨϪⲠⲞⲒ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ⲚⲦⲈⲨⲚⲞⲨ ⲆⲈ ⲀⲨⲤⲀϨⲰⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚϬⲒ ⲚⲈⲦⲚⲀϨⲈⲆⲀⲌⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤⲢϨⲞⲦⲈ ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ϪⲈ ⲞⲨϨⲢⲰⲘⲀⲒⲞⲤ ⲠⲈ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲀϤⲘⲞⲢϤ ⲠⲈ ⲀⲨⲰ ⲚⲦⲈⲨⲚⲞⲨ ⲀϤⲂⲞⲖϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀϤⲞⲨⲰϢ ⲈⲈⲒⲘⲈ ⲈⲠⲰⲢϪ ϪⲈ ⲈⲦⲂⲈ ⲞⲨ ⲤⲈⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲦⲢⲈⲨⲤⲰⲞⲨϨ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲦⲎⲢϤ ⲀϤϪⲒ ⲠⲀⲨⲖⲞⲤ ⲈⲠⲈⲤⲎⲦ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲈⲒⲰⲢⲘ ⲈϨⲞⲨⲚ ⲈⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲠⲈϪⲀϤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ. ⲀⲚⲞⲔ ⲀⲒⲠⲞⲖⲒⲦⲈⲨⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲤⲨⲚⲈⲒⲆⲎⲤⲒⲤ ⲚⲒⲘ ⲈⲚⲀⲚⲞⲨϤ ϢⲀϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϨⲀϨⲦⲎϤ ⲈⲢⲰϨⲦ ⲚⲦⲈϤⲦⲀⲠⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲢⲀϨⲦⲔ ⲦϪⲞ ⲈⲦϪⲎϨ. ⲔϨⲘⲞⲞⲤ ⲚⲦⲞⲔ ⲈⲔⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ⲔⲀⲦⲀ ⲠⲚⲞⲘⲞⲤ ⲀⲨⲰ ⲀⲔⲞⲨⲈϨⲤⲀϨⲚⲈ ⲠⲀⲢⲀ ⲠⲚⲞⲘⲞⲤ ⲈϨⲒⲞⲨⲈ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ⲠⲈϪⲀⲨ ⲚϬⲒ ⲚⲈⲦⲀϨⲈⲢⲀⲦⲞⲨ ϪⲈ ⲈⲔⲤⲀϨⲞⲨ ⲘⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ⲠⲈϪⲀϤ ⲆⲈ ⲚϬⲒ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲚⲈⲒⲤⲞⲞⲨⲚ ⲀⲚ ⲠⲈ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ⲚⲚⲈⲔϪⲈ ⲠⲈⲐⲞⲞⲨ ⲈⲠⲀⲢⲬⲰⲚ ⲘⲠⲈⲔⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲆⲈ ⲚϬⲒ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲠⲞⲨⲀ ⲚⲚⲤⲀ ⲠⲀⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲠⲈ ⲀⲨⲰ ⲠⲔⲈⲞⲨⲀ ⲠⲀ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲠⲈ ⲀϤϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲀⲚⲞⲔ ⲀⲚⲄ ⲞⲨⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲚϢⲎⲢⲈ ⲘⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲈⲨⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ⲈⲦⲂⲈ ⲐⲈⲖⲠⲒⲤ ⲘⲚ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ⲠⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲞⲞϤ ⲀⲨⲤⲦⲀⲤⲒⲤ ϢⲰⲠⲈ ϨⲚ ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲘⲚ ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ. ⲀⲨⲰ ⲀⲠⲘⲎⲎϢⲈ ⲠⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ⲚⲤⲀⲆⲆⲞⲨⲔⲀⲒⲞⲤ ⲄⲀⲢ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲚⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲞⲨⲆⲈ ⲘⲚⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲆⲈ ⲘⲚⲠⲚⲈⲨⲘⲀ. ⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲆⲈ ⲤⲈϨⲞⲘⲞⲖⲞⲄⲒ ϪⲈ ⲞⲨⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ⲀⲨⲰ ⲞⲨⲚ ⲀⲄⲄⲈⲖⲞⲤ ⲀⲨⲰ ⲞⲨⲚ ⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲀϢⲔⲀⲔ ϢⲰⲠⲈ ⲀⲨⲦⲰⲞⲨⲚ ⲚϬⲒ ϨⲞⲒⲚⲈ ⲚⲚⲈⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲘⲠⲤⲀ ⲚⲚⲈⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ ⲀⲨⲘⲒϢⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲚϬⲚ ⲖⲀⲀⲨ ⲀⲚ ⲘⲠⲈⲐⲞⲞⲨ ϨⲘ ⲠⲈⲒⲢⲰⲘⲈ ⲈⲒⲈ ⲈϢⲰⲠⲈ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲎⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲠⲈ ⲈⲚⲦⲀϤϢⲀϪⲈ ⲚⲘⲘⲀϤ ⲘⲠⲢⲦⲢⲈⲚϮ ⲞⲨⲂⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲤⲦⲀⲤⲒⲤ ϢⲰⲠⲈ ⲀⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲢϨⲞⲦⲈ ⲘⲎⲠⲰⲤ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲠⲀⲨⲖⲞⲤ. ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲠⲈⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲈⲂⲰⲔ ⲈⲠⲈⲤⲎⲦ ⲚⲤⲈⲦⲞⲢⲠϤ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ⲀⲨⲰ ⲈϪⲒⲦϤ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ϨⲚ ⲦⲈⲨϢⲎ ⲆⲈ ⲈⲦⲚⲎⲨ ⲀⲠϪⲞⲈⲒⲤ ⲀϨⲈⲢⲀⲦϤ ϨⲒϪⲰϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲦⲰⲔ ⲚϨⲎⲦ ⲚⲐⲈ ⲄⲀⲢ ⲚⲦⲀⲔⲢⲘⲚⲦⲢⲈ ⲈⲦⲂⲎⲎⲦ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϨⲀⲠⲤ ⲞⲚ ⲠⲈ ⲈⲦⲢⲈⲔⲢⲘⲚⲦⲢⲈ ⲚⲦⲈⲒϨⲈ ϨⲚ ⲦⲔⲈϨⲢⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ⲚⲦⲈⲢⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲀϨⲞⲒⲚⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲰⲢⲔ ⲚⲚⲈⲨⲈⲢⲎⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲚⲈⲚⲞⲨⲰⲘ. ⲞⲨⲆⲈ ⲚⲚⲈⲚⲤⲰ. ϢⲀⲚⲦⲚϨⲰⲦⲂ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ⲚⲈⲚⲦⲀⲨⲤⲘⲒⲚⲈ ⲆⲈ ⲘⲠⲈⲒⲀⲚⲀϢ ⲚⲈⲨⲚⲀⲢϨⲞⲨⲞ ⲈϨⲘⲈ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ⲚⲀⲒ ϬⲈ ⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ⲈⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲚ ⲞⲨⲀⲚⲀϢ ⲀⲚⲰⲢⲔ ⲚⲚⲈⲚⲈⲢⲎⲨ ⲈⲦⲘⲦⲈⲠ ⲖⲀⲀⲨ ϢⲀⲚⲦⲚϨⲰⲦⲂ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ⲦⲚⲤⲞⲠⲤ ⲆⲈ ⲘⲘⲰⲦⲚ ⲈⲦⲢⲈⲦⲚⲢ ⲠⲀⲒ ⲚⲀⲚ ⲤⲰⲞⲨϨ ⲘⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲚⲦⲈⲦⲚ ϪⲞⲞⲤ ⲘⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲚⲦϤ ⲈⲦⲈⲦⲚⲘⲎⲦⲈ ϨⲰⲤ ⲈⲦⲈⲦⲚⲀϪⲚⲞⲨϤ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲚⲈⲦϤⲚϨⲎ ⲦⲞⲨ ⲀⲚⲞⲚ ⲄⲀⲢ ⲦⲚⲤⲂⲦⲰⲦ ⲘⲠⲀⲦϤϨⲰⲚ ⲈϨⲞⲨⲚ ⲈϨⲰⲦⲂ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ⲀϤⲤⲰⲦⲘ ⲆⲈ ⲚϬⲒ ⲠϢⲎⲢⲈ ⲚⲦⲤⲰⲚⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲠⲈⲨⲔⲢⲞϤ. ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ ⲀϤⲦⲀⲘⲈ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲘⲞⲨⲦⲈ ⲈⲞⲨⲀ ⲚⲚϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ϪⲒ ⲠⲈⲒϢⲎⲢⲈ ϢⲎⲘ ϢⲀ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲞⲨⲚⲦϤ ⲞⲨϢⲀϪⲈ ⲄⲀⲢ ⲈϪⲞⲞϤ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ⲀϤⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲠϢⲎⲢⲈ ϢⲎⲘ ⲀϤϪⲒⲦϤ ⲈϨⲞⲨⲚ ϢⲀ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲨⲖⲞⲤ ⲠⲈⲦⲘⲎⲢ ⲠⲈⲚⲦⲀϤⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ⲀϤⲤⲈⲠⲤⲰⲠⲦ ⲈⲈⲒⲚⲈ ⲚⲀⲔ ⲈϨⲞⲨⲚ ⲘⲠⲈⲒϨⲢϢⲒⲢⲈ ⲈⲨⲚⲦϤⲞⲨϢⲀϪⲈ ⲈϪⲞⲞϤ ⲈⲢⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ⲀⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲆⲈ ⲀⲘⲀϨⲦⲈ ⲚⲦⲈϤϬⲒϪ ⲀϤⲤⲈϨⲦϤ ⲈⲨⲤⲀ ⲀϤϪⲚⲞⲨϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀⲔϤ ⲈϪⲞⲞϤ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ⲠⲈϪⲀϤ ϪⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲚⲈⲚⲦⲀⲨⲦⲀⲤⲤⲈ ⲈⲤⲈⲠⲤⲰⲠⲔ. ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲚⲠⲀⲨⲖⲞⲤ ⲚⲢⲀⲤⲦⲈ ⲈⲦⲘⲎ ⲦⲈ ⲘⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ϨⲰⲤ ⲈⲨⲚⲀϢⲒⲚⲈ ϨⲚ ⲞⲨⲰⲢϪ ⲈⲦⲂⲎⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ⲚⲦⲞⲔ ϬⲈ ⲘⲠⲢⲤⲰⲦⲘ ⲚⲀⲨ ⲤⲈϬⲞⲢϬ ⲄⲀⲢ ⲈⲢⲞϤ ⲚϬⲒ ϨⲞⲨⲞ ⲈϨⲘⲈ ⲚⲢⲰⲘⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲚⲀⲒ ⲚⲦⲀⲨⲰⲢⲔ ⲚⲚⲈⲨⲈⲢⲎⲨ ⲈⲦⲘⲞⲨⲰⲘ ⲞⲨⲆⲈ ⲈⲦⲘⲤⲰ ϢⲀⲚⲦⲞⲨϨⲰⲦⲂ ⲘⲘⲞϤ ⲀⲨⲰ ⲦⲈⲚⲞⲨ ⲤⲈⲤⲂⲦⲰⲦ ⲈⲨϬⲰϢⲦ ⲈⲂⲞⲖ ϢⲀⲚⲦⲔϪⲒⲠⲞⲨⲰ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲆⲈ ⲀϤⲔⲀ ⲠϨⲢϢⲒⲢⲈ ⲈⲂⲞⲖ ⲈⲀϤⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲀϤ ϪⲈ ⲘⲠⲢϪⲞⲞⲤ ⲈⲖⲀⲀⲨ ϪⲈ ⲀⲔⲦⲀⲘⲞⲒ ⲈⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ⲀϤⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲤⲚⲀⲨ ⲚⲚϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ⲤⲂⲦⲈ ϢⲎⲦ ⲘⲘⲀⲦⲞⲒ ⲈⲦⲢⲈⲨⲂⲰⲔ ϢⲀ ⲦⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲨⲰ ϢⲈ ⲚϨⲒⲠⲠⲈⲨⲤ ⲀⲨⲰ ϢⲎⲦ ⲚϤⲀⲒⲘⲈⲢⲈϨ ϪⲒⲚ ⲚϪⲠϢⲞⲘⲦⲈ ⲚⲦⲈⲨϢⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ⲀⲨⲰ ⲤⲞⲂⲦⲈ ⲚϨⲈⲚⲦⲂⲚⲞⲞⲨⲈ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲦⲀⲖⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲤⲈϪⲒⲦϤ ⲈⲢⲀⲦϤ ⲘⲪⲎⲖⲒⲜ ⲪⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ⲈⲀϤⲤϨⲀⲒ ⲚⲞⲨⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲠⲈⲒⲦⲨⲠⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ⲔⲖⲀⲨⲆⲒⲞⲤ ⲖⲨⲤⲒⲀⲤ ⲈϤⲤϨⲀⲒ ⲘⲪⲎⲖⲒⲜ ⲠⲈⲔⲢⲀⲦⲒⲤⲦⲞⲤ ⲚϨⲎⲄⲈⲘⲰⲚ ⲬⲀⲒⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ⲠⲈⲒⲢⲰⲘⲈ ⲈⲀⲨϬⲞⲠϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲀⲨⲞⲨⲰϢ ⲈϨⲞⲦⲂⲈϤ ⲀⲒⲈⲒ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲘⲚ ⲠⲈⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲚⲦⲈⲢⲒⲈⲒⲘⲈ ⲆⲈ ϪⲈ ⲞⲨϨⲢⲰⲘⲀⲒⲞⲤ ⲠⲈ ⲀⲒⲦⲞⲨϪⲞϤ ");
INSERT INTO copshc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ⲈⲒⲞⲨⲰϢ ⲈⲤⲞⲨⲚ ⲦⲖⲞⲒϬⲈ ⲈⲦⲞⲨⲈⲄⲔⲀⲖⲈⲒ ⲚⲀϤ ⲈⲦⲂⲎⲎⲦⲤ. ⲀⲒϪⲒⲦϤ ⲈϨⲢⲀⲒ ⲈⲠⲈⲨⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ⲀⲒϬⲚⲦⲤ ⲈⲨⲈⲄⲔⲀⲖⲈⲒ ⲚⲀϤ ⲈⲦⲂⲈ ϨⲈⲚⲌⲎⲦⲎⲘⲀ ⲚⲦⲈ ⲠⲈⲨⲚⲞⲘⲞⲤ. ⲈⲘⲚ ⲖⲀⲀⲨ ⲆⲈ ⲚϨⲀⲠ ⲈⲢⲞϤ ⲈϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ⲎⲘⲢⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ⲚⲦⲈⲢⲞⲨⲦⲀⲘⲞⲒ ⲆⲈ ⲈⲨⲔⲢⲞϤ ⲈϤⲚⲀϢⲰⲠⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲒⲢⲰⲘⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲒⲞⲨⲆⲀⲒ. ⲚⲦⲈⲨⲚⲞⲨ ⲀⲒⲦⲀⲨⲞϤ ϢⲀⲢⲞⲔ. ⲈⲒⲠⲀⲢⲀⲄⲄⲒⲖⲈ ⲚⲚⲈϤⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲈϪⲒϨⲀⲠ ϨⲒⲰⲰⲔ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ⲘⲘⲀⲦⲞⲒ ϬⲈ ⲔⲀⲦⲀ ⲠⲈⲚⲦⲀⲨⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲞϤ ⲚⲀⲨ ⲀⲨⲦⲀⲖⲈ ⲠⲀⲨⲖⲞⲤ. ⲚⲦⲈⲨϢⲎ ⲀⲨⲚⲦϤ ⲈⲀⲚⲦⲒⲠⲀⲦⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲨⲦⲢⲈ ⲚϨⲒⲠⲠⲈⲨⲤ ⲂⲰⲔ ⲚⲘⲘⲀϤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲦⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ⲚⲦⲞⲞⲨ ϬⲈ ⲚⲦⲈⲢⲞⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲦⲔⲀⲒⲤⲀⲢⲒⲀ ⲀⲨϮ ⲦⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲪⲎⲄⲈⲘⲰⲚ. ⲀⲨⲠⲀⲢϨⲒⲤⲦⲀ ⲚⲀϤ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ⲚⲦⲈⲢⲈϤⲞϢⲤ ⲆⲈ ⲚϬⲒ ⲪⲎⲄⲈⲘⲰⲚ. ⲀϤϢⲒⲚⲈ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲀϢ ⲚⲈⲠⲀⲢⲬⲒⲀ. ⲚⲦⲈⲢⲈϤⲈⲒⲘⲈ ⲆⲈ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲠⲈ ϨⲚ ⲦⲔⲒⲖⲒⲔⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ⲠⲈϪⲀϤ ϪⲈ ⲈⲒⲈⲤⲰⲦⲘ ⲈⲢⲞⲔ ϨⲞⲦⲀⲚ ⲈⲨϢⲀⲚⲈⲒ ϨⲰⲞⲨ ⲚϬⲒ ⲚⲈⲔⲔⲀⲦⲎⲄⲞⲢⲞⲤ. ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲆⲈ ⲈⲦⲢⲈⲨϨⲀⲢⲈϨ ⲈⲢⲞϤ ϨⲘ ⲠⲈⲠⲢⲀⲒⲦⲰⲢⲒⲞⲚ ⲚϨⲎⲢⲰⲆⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ⲘⲚⲚⲤⲀ ϮⲞⲨ ⲆⲈ ⲚϨⲞⲞⲨ ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲚϬⲒ ⲀⲚⲀⲚⲒⲀⲤ ⲠⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲘⲚ ϨⲈⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲰ ⲞⲨϨⲢⲎⲦⲰⲢ ϪⲈ ⲦⲈⲢⲦⲨⲖⲖⲞⲤ ⲀⲨⲰ ⲀⲨⲤⲘⲘⲈ ⲈⲠⲀⲨⲖⲞⲤ ⲘⲪⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ⲚⲦⲈⲢⲞⲨⲘⲞⲨⲦⲈ ⲆⲈ ⲈⲢⲞϤ ⲀϤⲀⲢⲬⲈⲒ ⲚⲔⲀⲦⲎⲄⲞⲢⲒ ⲚϬⲒ ⲦⲈⲢⲦⲨⲖⲖⲞⲤ. ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚ ⲞⲨⲚⲞϬ ⲚⲈⲒⲢⲎⲚⲎ ϢⲞⲞⲠ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲔ. ⲀⲨⲰ ϨⲈⲚ ⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲘⲠⲈⲒϨⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲔⲠⲢⲞⲚⲞⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ⲪⲎⲖⲒⲜ ⲠⲈⲔⲢⲀⲦⲒⲤⲦⲞⲤ. ⲤⲈⲦⲀⲒⲞ ⲘⲘⲞⲚ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲘ ⲘⲀ ⲚⲒⲘ. ϨⲚ ⲞⲨⲚⲞϬ ⲚϨⲘⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ϪⲈⲔⲀⲀⲤ ⲆⲈ ⲚⲚⲈⲚϮϨⲒⲤⲈ ⲚⲀⲔ ⲈⲠⲈϨⲞⲨⲞ. ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ⲈⲦⲢⲈⲔⲤⲰⲦⲘ ⲈⲢⲞⲚ ϨⲚ ⲞⲨϢⲰⲰⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲔⲘⲚⲦϨⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ⲀⲚϨⲈ ⲄⲀⲢ ⲈⲠⲈⲒⲢⲰⲘⲈ ⲚⲖⲞⲒⲘⲞⲤ ⲈϤⲦⲞⲨⲚⲈⲤ ⲤⲦⲀⲤⲒⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϨⲚ ⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ. ⲈⲠⲤⲀϨ ⲠⲈ ⲚⲐⲀⲒⲢⲈⲤⲒⲤ ⲚⲚⲀⲌⲰⲢⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ⲀϤⲠⲈⲒⲢⲀⲌⲈ ⲈϪⲰϨⲘ ⲘⲠⲈⲢⲠⲈ ⲠⲀⲒ ⲚⲦⲀⲚⲀⲘⲀϨⲦⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","— ");
INSERT INTO copshc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ⲞⲨⲚ ϬⲞⲘ ⲆⲈ ⲞⲚ ⲘⲘⲞⲔ ⲈⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲈⲈⲒⲘⲈ ⲈⲦⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲚⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞϤ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ⲀⲨⲞⲨⲰϢⲂ ⲆⲈ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒ ⲤⲘⲞⲚⲦ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ⲀⲪⲎⲄⲈⲘⲰⲚ ⲆⲈ ϪⲰⲢⲘ ⲈⲠⲀⲨⲖⲞⲤ ⲈϢⲀϪⲈ. ⲀϤⲞⲨⲰϢⲂ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲤⲞⲞⲨⲚ ⲘⲘⲞⲔ ⲈⲒⲤ ϨⲀϨ ⲚⲢⲞⲘⲠⲈ ⲈⲔⲞ ⲚⲢⲈϤϮϨⲀⲠ ⲈⲠⲈⲒϨⲈⲐⲚⲞⲤ. ϨⲚ ⲞⲨⲘⲦⲞⲚ ϬⲈ ⲚϨⲎⲦ ϮⲚⲀϢⲀϪⲈ ϨⲀⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ⲈⲨⲚ ϬⲞⲘ ⲘⲘⲞⲔ ⲈⲈⲒⲘⲈ ϪⲈ ⲘⲠⲒⲢ ϨⲞⲨⲞ ⲈⲘⲚⲦⲤⲚⲞⲞⲨⲤ ⲚϨⲞⲞⲨ ϪⲒⲚⲦⲀⲒⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲞⲨⲰϢⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ⲀⲨⲰ ⲘⲠⲞⲨϨⲈ ⲈⲢⲞⲒ ⲈⲒϢⲀϪⲈ ⲘⲚ ⲞⲨⲀ ϨⲘ ⲠⲈⲢⲠⲈ. ⲎⲈⲒⲤⲰⲞⲨϨ ⲚⲞⲨⲘⲎⲎϢⲈ. ⲞⲨⲆⲈ ϨⲚ ⲚⲈⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲆⲈ ϨⲚ ⲦⲠⲞⲖⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ⲞⲨⲆⲈ ⲘⲚ ϢϬⲞⲘ ⲘⲘⲞⲞⲨ ⲈⲦⲀϨⲞ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲈⲦⲞⲨⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞⲒ ⲦⲈⲚⲞⲨ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ϮϨⲞⲘⲞⲖⲞⲄⲒ ⲚⲀⲔ ⲘⲠⲀⲒ ϪⲈ ⲔⲀⲦⲀⲦⲈϨⲒⲎ ⲈⲦⲈⲢⲈ ⲚⲀⲒ ⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ϨⲀⲒⲢⲈⲤⲒⲤ ⲈⲒϢⲘϢⲈ ⲚⲦⲈⲒϨⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲚⲀⲈⲒⲞⲦⲈ ⲈⲒⲠⲒⲤⲦⲈⲨⲈ ⲈⲚⲈⲦⲤⲎϨ ⲦⲎⲢⲞⲨ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ⲈⲞⲨⲚⲦⲀⲒ ⲘⲘⲀⲨ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲈϨⲞⲨⲚ ⲈⲠⲚⲞⲨⲦⲈ. ⲦⲈⲦⲈⲢⲈ ⲚⲀⲒ ϬⲰϢⲦ ϨⲎⲦⲤ. ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲈⲦⲚⲀϢⲰⲠⲈ ⲚⲚⲆⲒⲔⲀⲒⲞⲤ ⲘⲚ ⲀⲆⲒⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ⲈⲀⲒⲀⲤⲔⲒ ϨⲰ ϨⲘ ⲠⲀⲒ. ⲈⲦⲢⲀⲔⲰ ⲚⲀⲒ ⲚⲞⲨⲤⲨⲚⲈⲒⲆⲎⲤⲒⲤ ⲀϪⲚ ϪⲢⲞⲠ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ⲘⲚⲚⲤⲀ ϨⲀϨ ⲆⲈ ⲚⲢⲞⲘⲠⲈ ⲀⲒⲈⲒ ⲈϨⲢⲀⲒ ⲈⲠⲀϨⲈⲐⲚⲞⲤ ⲈⲒⲈⲒⲢⲈ ⲚϨⲈⲚⲘⲚⲦⲚⲀ ⲘⲚ ϨⲈⲚⲐⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ϨⲚ ⲚⲀⲒ ⲀⲨϨⲈ ⲈⲢⲞⲒ ϨⲘ ⲠⲈⲢⲠⲈ. ⲈⲒⲦⲂⲂⲞ ⲘⲘⲞⲒ ⲘⲚ ⲞⲨⲘⲎⲎϢⲈ ⲀⲚ. ⲞⲨⲆⲈ ϨⲚ ⲞⲨϢⲦⲞⲢⲦⲢ ⲀⲚ ⲚϬⲒ ϨⲈⲚⲒⲞⲨⲆⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲀⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ⲚⲀⲒ ⲈϢϢⲈ ⲈⲨϨⲘ ⲠⲈⲒⲘⲀ. ⲚⲤⲈⲔⲀⲦⲎⲄⲞⲢⲒ ⲈϢϪⲈ ⲞⲨⲚⲦⲞⲨ ⲖⲀⲀⲨ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ⲎⲘⲘⲞⲚ ⲚⲀⲒ ⲚⲦⲞⲞⲨ ⲘⲀⲢⲞⲨϪⲞⲞⲤ. ϪⲈ ⲚⲦⲈⲢⲒⲀϨⲈⲢⲀⲦ ϨⲘ ⲠⲤⲨⲚϨⲈⲆⲢⲒⲞⲚ ⲚⲦⲀⲨϨⲈ ⲈⲀϢ ⲚϪⲒ ⲚϬⲞⲚⲤ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ⲈⲒ ⲘⲎⲦⲒ ϪⲈ ⲈⲦⲂⲈ ⲦⲈⲒⲤⲘⲎ ⲚⲞⲨⲰⲦ ⲚⲦⲀⲒϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ⲘⲘⲞⲤ ⲈⲒⲀϨⲈⲢⲀⲦ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ. ϪⲈ ⲈⲨⲈⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ⲘⲠⲞⲞⲨ ϨⲒⲰⲦⲦⲎⲨⲦⲚ. ⲈⲦⲂⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ⲪⲎⲖⲒⲜ ⲆⲈ ⲚⲦⲈⲢⲈϤⲤⲰⲦⲘ ⲈⲚⲀⲒ ⲀϤⲚⲈϪ ⲪⲰⲂ ⲈⲠⲀϨⲞⲨ. ⲈϤⲤⲞⲞⲨⲚ ⲚⲦⲈϨⲒⲎ ϨⲚ ⲞⲨⲰⲢϪ. ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢϢⲀⲚ ⲖⲨⲤⲒⲀⲤ ⲠⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲈⲒ ϮⲚⲀⲤⲰⲦⲘ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲆⲈ ⲘⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈϨⲀⲢⲈϨ ⲈⲠⲀⲨⲖⲞⲤ ⲀⲨⲰ ⲈⲦⲘⲘⲞⲔϨϤ ⲞⲨⲆⲈ ⲈⲦⲘⲔⲰⲖⲨⲈ ⲚⲖⲀⲀⲨ ⲚⲚⲈϤⲢⲰⲘⲈ ⲈⲦⲘϢⲘϢⲎⲦϤ ⲎⲈⲦⲢⲈⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ⲘⲚⲚⲤⲀ ϨⲈⲚϨⲞⲞⲨ ⲆⲈ ⲀϤⲈⲒ ⲚϬⲒ ⲪⲎⲖⲒⲜ ⲘⲚ ⲦⲢⲞⲨⲤⲒⲖⲖⲀ ⲦⲈϤⲤϨⲒⲘⲈ ⲈⲨⲒⲞⲨⲆⲀⲒ ⲦⲈ ⲀⲨⲰ ⲀϤⲦⲚⲚⲞⲞⲨ ⲚⲤⲀ ⲠⲀⲨⲖⲞⲤ ⲀϤⲤⲰⲦⲘ ⲈⲢⲞϤ ⲈⲦⲂⲈ ⲦⲠⲒⲤⲦⲒⲤ ⲈϨⲞⲨⲚ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ϢⲀϪⲈ ⲈⲦⲂⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲈⲦⲂⲈ ⲦⲈⲔⲢⲀⲦⲒⲀ ⲘⲚ ⲦⲈⲔⲢⲒⲤⲒⲤ ⲈⲦⲚⲀϢⲰⲠⲈ. ⲚⲦⲈⲢⲈϤⲢϨⲞⲦⲈ ⲆⲈ ⲚϬⲒ ⲪⲎⲖⲒⲜ ⲀϤⲞⲨⲰϢⲂ ϪⲈ ⲂⲰⲔ ⲦⲈⲚⲞⲨ. ⲈⲒϢⲀⲚϨⲈ ⲄⲀⲢ ⲈⲠⲈⲨⲞⲈⲒϢ ϮⲚⲀⲦⲀⲨⲞⲞⲨ ⲚⲤⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ϨⲀⲘⲀ ⲦⲈ ⲈϤϨⲈⲖⲠⲒⲌⲈ ϪⲈ ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲀϮ ϨⲈⲚⲬⲢⲎⲘⲀ ⲚⲀϤ ϪⲈ ⲈϤⲈⲂⲞⲖϤ ⲈⲂⲞⲖ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲈϤⲦⲚⲚⲞⲞⲨ ⲚⲤⲰϤ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲈϤϢⲀϪⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ⲚⲦⲈⲢⲈ ⲦⲈⲢⲞⲘⲠⲈ ⲆⲈ ⲤⲚⲦⲈ ϪⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲈ ⲪⲎⲖⲒⲜ. ⲀϤⲈⲒ ⲈⲠⲈϤⲘⲀ ⲚϬⲒ ⲠⲞⲢⲔⲒⲞⲤ ⲪⲎⲤⲦⲞⲤ. ⲈϤⲞⲨⲰϢ ⲆⲈ ⲚϬⲒ ⲪⲎⲖⲒⲜ ⲈϮ ⲚⲞⲨⲬⲀⲢⲒⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲀϤⲔⲀ ⲠⲀⲨⲖⲞⲤ ⲈϤⲘⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ⲪⲎⲤⲦⲞⲤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲒ ⲈⲦⲈⲠⲀⲢⲬⲒⲀ ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ⲀϤⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲂⲞⲖ ϨⲚ ⲦⲔⲀⲒⲤⲀⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲨⲰ ⲚⲚⲞϬ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲤⲘⲘⲈ ⲈⲠⲀⲨⲖⲞⲤ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ⲀⲨⲰ ⲀⲨⲤⲈⲠⲤⲰⲠϤ ⲈⲨⲀⲒⲦⲒ ⲚⲞⲨϨⲘⲞⲦ ⲚⲦⲞⲞⲦϤ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲦⲚⲚⲞⲞⲨ ⲚⲤⲰϤ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲨⲈⲒⲢⲈ ⲚⲞⲨⲔⲢⲞϤ ⲈⲢⲞϤ ⲈⲘⲞⲞⲨⲦϤ ϨⲒ ⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ⲪⲎⲤⲦⲞⲤ ϬⲈ ⲀϤⲞⲨⲰϢⲂ ϪⲈ ⲤⲈϨⲀⲢⲈϨ ⲈⲠⲀⲨⲖⲞⲤ ϨⲚ ⲦⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲚⲞⲔ ⲆⲈ ϨⲚ ⲞⲨϬⲈⲠⲎ ϮⲚⲀⲂⲰⲔ ⲈⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ⲚⲈⲦⲈⲞⲨⲚ ϬⲞⲘ ⲆⲈ ⲘⲘⲞⲞⲨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲘⲀⲢⲞⲨⲈⲒ ⲈϨⲢⲀⲒ ⲚⲤⲈⲔⲀⲦⲎⲄⲞⲢⲒ. ⲈϢϪⲈ ⲞⲨⲚϨⲰⲂ ⲈϤϨⲞⲞⲨ ϨⲘ ⲠⲈⲒⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ⲚⲦⲈⲢⲈϤⲢⲀϢⲘⲞⲨⲚ ⲆⲈ ⲎⲘⲎⲦ ⲚϨⲞⲞⲨ ⲘⲘⲀⲨ. ⲀϤⲈⲒ ⲈϨⲢⲀⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ. ⲀⲨⲰ ⲚⲦⲈⲢⲈϤϨⲘⲞⲞⲤ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲈⲠⲂⲎⲘⲀ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲈⲒⲚⲈ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ⲚⲦⲈⲢⲈϤⲈⲒ ⲆⲈ ⲀⲨⲀϨⲈⲢⲀⲦⲞⲨ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲚⲦⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲨϪⲰ ⲚϨⲈⲚⲚⲞϬ ⲚⲀⲒⲦⲒ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲀⲨⲰ ⲈⲨϨⲞⲢϢ ⲚⲀⲒ ⲈⲘⲠⲞⲨϢϬⲘϬⲞⲘ ⲈⲦⲀϨⲞⲞⲨ ⲈⲢⲀⲦⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲰϢⲂ ⲈϨⲎⲦⲞⲨ ϪⲈ ⲘⲠⲒⲢⲖⲀⲀⲨ ⲚⲚⲞⲂⲈ ⲈⲠⲚⲞⲘⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲞⲨⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲢⲠⲈ. ⲞⲨⲆⲈ ⲈϨⲞⲨⲚ ⲈⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ⲪⲎⲤⲦⲞⲤ ϬⲈ ⲈϤⲞⲨⲰϢ ⲈϮ ⲚⲞⲨⲬⲀⲢⲒⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲀϤⲞⲨⲰϢⲂ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ⲈⲚⲈⲔⲞⲨⲰϢ ⲈⲈⲒ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈϪⲒϨⲀⲠ ⲚⲘⲘⲀⲨ ϨⲒⲰⲦ ⲈⲦⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ϪⲈ ⲈⲒⲀϨⲈⲢⲀⲦ ϨⲒ ⲠⲂⲎⲘⲀ ⲘⲠⲢⲢⲞ ⲠⲀⲒ ⲠⲈ ⲠⲘⲀ ⲈϮⲚⲀϪⲒϨⲀⲠ ϨⲒⲰⲰϤ. ⲚⲒⲞⲨⲆⲀⲒ ⲄⲀⲢ ⲘⲠⲒϪⲒⲦⲞⲨ ⲚϬⲞⲚⲤ ⲖⲀⲀⲨ. ⲚⲐⲈ ϨⲰⲰⲔ ⲞⲚ ⲈⲔⲤⲞⲞⲨⲚ ⲚϨⲞⲨⲞ ");
INSERT INTO copshc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ⲈⲚⲈⲚⲦⲀⲒⲈⲒⲢⲈ ⲄⲀⲢ ⲚⲞⲨϪⲒ ⲚϬⲞⲚⲤ ⲎⲞⲨϨⲰⲂ ⲈϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ ⲚⲈⲒⲚⲀⲠⲀⲢⲀⲒⲦⲒ ⲀⲚ ⲘⲠⲘⲞⲨ ⲈϢϪⲈ ⲘⲠⲒⲢ ⲖⲀⲀⲨ ⲆⲈ ⲚⲚⲈⲦⲈⲢⲈ ⲚⲀⲒ ⲔⲀⲦⲎⲄⲞⲢⲒ ⲘⲘⲞⲒ ⲈⲦⲂⲎⲎⲦⲞⲨ ⲘⲘⲚϬⲞⲘ ⲚⲖⲀⲀⲨ ⲈⲬⲀⲢⲒⲌⲈ ⲘⲘⲞⲒ ⲚⲀⲨ ϮⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ⲦⲞⲦⲈ ⲪⲎⲤⲦⲞⲤ ⲚⲦⲈⲢⲈϤϢⲀϪⲈ ⲘⲚ ⲠⲈϤⲢⲈϤϪⲒϢⲞϪⲚⲈ ⲀϤⲞⲨⲰϢⲂ ϪⲈ ⲀⲔⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲢⲞ. ⲈⲔⲈⲂⲰⲔ ⲈⲢⲀⲦϤ ⲘⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ⲚⲦⲈⲢⲈ ϨⲈⲚϨⲞⲞⲨ ⲆⲈ ⲞⲨⲈⲒⲚⲈ. ⲀⲄⲢⲒⲠⲠⲀⲤ ⲠⲢⲢⲞ ⲀⲨⲰ ⲂⲈⲢⲈⲚⲒⲔⲎ. ⲀⲨⲈⲒ ⲈⲔⲀⲒⲤⲀⲢⲒⲀ ⲈⲀⲤⲠⲀⲌⲈ ⲘⲪⲎⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲢ ϨⲀϨ ⲚϨⲞⲞⲨ ⲘⲘⲀⲨ. ⲪⲎⲤⲦⲞⲤ ⲀϤⲦⲀⲘⲈ ⲠⲢⲢⲞ ⲈⲪⲰⲂ ⲘⲠⲀⲨⲖⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲠⲈ ⲚⲦⲀ ⲪⲎⲖⲒⲜ ⲔⲀⲀϤ ⲈϤⲘⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ⲠⲀⲒ ⲚⲦⲈⲢⲒⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲀⲨⲤⲘⲘⲈ ⲈⲢⲞϤ ⲚⲀⲒ ⲚϬⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲰ ⲚⲈⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲈⲨⲀⲒⲦⲒ ⲘⲘⲞϤ ⲈⲘⲞⲞⲨⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ⲀⲒⲞⲨⲰϢⲂ ⲆⲈ ⲚⲀⲨ ϪⲈ ⲘⲠⲤⲰⲚⲦ ⲀⲚ ⲠⲈ ⲚⲚⲈϨⲢⲰⲘⲀⲒⲞⲤ ⲈϮ ⲚⲞⲨⲢⲰⲘⲈ ⲈⲨⲔⲀⲦⲎ ⲄⲞⲢⲒ ⲘⲘⲞϤ ⲈⲦⲀⲔⲞϤ. ⲘⲠⲀⲦⲈ ⲚⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲈⲒ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ. ⲈⲦⲢⲈϤϬⲚⲐⲈ ⲚⲞⲨⲰϢⲂ ⲞⲨⲂⲈ ⲦⲔⲀⲦⲎⲄⲞⲢⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ⲚⲦⲈⲢⲞⲨⲈⲒ ϬⲈ ⲈⲠⲈⲒⲘⲀ ⲘⲠⲒⲚⲈϪ ⲠϨⲰⲂ ⲀⲒϨⲘⲞⲞⲤ ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲈⲠⲂⲎⲘⲀ. ⲀⲒⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈⲈⲒⲚⲈ ⲘⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ⲚⲦⲈⲢⲞⲨⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ⲈⲢⲞϤ ⲚϬⲒ ⲚⲔⲀⲦⲎⲄⲞⲢⲞⲤ. ⲘⲠⲞⲨⲦⲀϨⲈ ⲖⲀⲀⲨ ⲈⲢⲀⲦϤ ⲚϨⲰⲂ ⲈϤϨⲞⲞⲨ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲚⲐⲈ ⲀⲚⲞⲔ ⲈⲒⲈⲒⲘⲈ ⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ⲀⲖⲖⲀ ϨⲈⲚⲌⲎⲦⲎⲘⲀ ⲚⲈ ⲚⲦⲈ ⲠⲈⲨϢⲘϢⲈ ⲚⲈⲦⲈⲨⲚⲦⲀⲨⲤⲈ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ⲀⲨⲰ ⲈⲦⲂⲈ ⲞⲨⲀ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲀϤⲘⲞⲨ ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ⲈⲒⲀⲠⲞⲢⲢⲒ ⲆⲈ ⲀⲚⲞⲔ ⲈⲦⲂⲈ ⲪⲀⲠ ⲚⲚⲈⲒϢⲀϪⲈ. ⲀⲒϪⲚⲞⲨϤ ϪⲈ ⲈⲚⲈⲔⲞⲨⲰϢ ⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈϪⲒϨⲀⲠ ⲚⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ⲚⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲠⲒⲔⲀⲖⲈⲒ ⲈϨⲀⲢⲈϨ ⲈⲢⲞϤ ⲈⲪⲀⲠ ⲘⲠⲢⲢⲞ. ⲀⲒⲞⲨⲈϨⲤⲀϨⲚⲈ ⲈϨⲀⲢⲈϨ ⲈⲢⲞϤ ϢⲀⲚϮϪⲞⲞⲨϤ ⲘⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲪⲎⲤⲦⲞⲤ ϪⲈ ⲚⲈⲒⲞⲨⲰϢ ϨⲰ ⲈⲤⲰⲦⲘ ⲈⲠⲈⲒⲢⲰⲘⲈ. ⲠⲈϪⲀϤ ϪⲈ ⲢⲀⲤⲦⲈ ⲈⲔⲈⲤⲰⲦⲘ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲀϤⲈⲒ ⲚϬⲒ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲀⲨⲰ ⲂⲈⲢⲈⲚⲒⲔⲎ ⲘⲚ ⲞⲨⲚⲞϬ ⲘⲪⲀⲚⲦⲀⲤⲒⲀ. ⲀⲨⲂⲰⲔ ⲈϨⲞⲨⲚ ⲈⲠⲘⲀ ⲚϮϨⲀⲠ ⲘⲚ ϨⲈⲚⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲘⲚ ϨⲈⲚⲢⲰⲘⲈ ⲚⲢⲘⲘⲀⲞ ⲚⲦⲠⲞⲖⲒⲤ. ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲪⲎⲤⲦⲞⲤ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲀⲨⲈⲒⲚⲈ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ⲠⲈϪⲀϤ ⲚϬⲒ ⲪⲎⲤⲦⲞⲤ ϪⲈ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲠⲢⲢⲞ ⲀⲨⲰ ⲚⲢⲰⲘⲈ ⲦⲎⲢⲞⲨ ⲈⲦⲘⲠⲈⲒⲘⲀ ⲦⲈⲦⲚⲚⲀⲨ ⲈⲠⲈⲒⲢⲰⲘⲈ ⲚⲦⲀ ⲠⲘⲎⲎϢⲈ ⲦⲎⲢϤ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲤⲘⲘⲈ ⲚⲀⲒ ⲈⲦⲂⲎⲎⲦϤ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲀⲨⲰ ϨⲘ ⲠⲈⲒⲘⲀ ⲈⲨⲀϢⲔⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲚϢϢⲈ ⲀⲚ ⲈⲢⲞϤ ⲈⲰⲚϨ ϪⲒⲚ ⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒϨⲈ ⲈⲢⲞϤ ⲈϢϪⲈ ⲘⲠϤⲢ ⲖⲀⲀⲨ ⲚϨⲰⲂ ⲈϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲢⲞ ⲀⲒⲔⲢⲒⲚⲈ ⲈϪⲞⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ⲈⲘⲚϮ ⲞⲨϨⲰⲂ ⲆⲈ ⲘⲘⲀⲨ ⲈϤⲞⲢϪ ⲈⲤϨⲀⲒ ⲘⲠⲢⲢⲞ ⲈⲦⲂⲎⲎⲦϤ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒⲚⲦϤ ⲈⲂⲞⲖ ⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ⲚϨⲞⲨⲞ ⲆⲈ ⲈⲢⲀⲦⲔ ⲠⲢⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲦⲀϬⲘ ⲠⲈϮⲚⲀⲤⲀϨϤ. ");
INSERT INTO copshc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ⲚⲞⲨϨⲰⲂ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲈϢϢⲈ ⲚⲚⲀϨⲢⲀⲒ. ⲈϪⲈⲨⲞⲨⲀ ⲈϤⲘⲎⲢ ⲘⲠⲒⲤⲈϨ ⲚⲈϤⲔⲈⲀⲒⲦⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ⲠⲘⲀ ⲔⲎ ⲚⲀⲔ ⲈϢⲀϪⲈ ϨⲀⲢⲞⲔ. ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤⲤⲞⲨⲦⲚ ⲦⲈϤϬⲒϪ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ϪⲈ ⲈⲦⲂⲈ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲈⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲄⲔⲀⲖⲈⲒ ⲚⲀⲒ ⲈⲦⲂⲎⲎⲦⲞⲨ ⲠⲢⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ. ⲀⲒⲞⲠⲦ ⲘⲘⲀⲔⲀⲢⲒⲞⲤ ⲈⲒⲚⲀⲀⲠⲞⲖⲞⲄⲒⲌⲈ ϨⲒⲰⲰⲔ ⲘⲠⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ⲘⲀⲖⲒⲤⲦⲀ ⲈⲔⲤⲞⲞⲨⲚ ⲚⲚⲤⲰⲚⲦ ⲦⲎⲢⲞⲨ. ⲀⲨⲰ ⲚⲌⲎⲦⲎⲘⲀ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲤⲞⲠⲤ ⲘⲘⲞⲔ ⲈⲤⲰⲦⲘ ⲈⲢⲞⲒ ϨⲚ ⲞⲨⲘⲚⲦϨⲀⲢϢϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ⲠⲀⲂⲒⲞⲤ ϬⲈ ϪⲒⲚ ⲦⲀⲘⲚⲦⲔⲞⲨⲒ ⲚⲦⲀϤϢⲰⲠⲈ ⲘⲘⲞⲒ ϨⲘ ⲠⲀϨⲈⲐⲚⲞⲤ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ⲤⲈⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ⲈⲨⲤⲞⲞⲨⲚ ⲘⲘⲞⲒ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲈⲨϢⲀⲚⲞⲨⲰϢ ⲈⲢⲘⲚⲦⲢⲈ ⲚⲦⲘⲈ ϪⲈ ⲀⲒⲰⲚϨ ⲔⲀⲦⲀ ⲐⲀⲒⲢⲈⲤⲒⲤ ⲘⲠⲀϢⲘϢⲈ ⲈⲦⲞⲢϪ ⲀⲚⲄ ⲞⲨⲪⲀⲢⲒⲤⲤⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ⲀⲨⲰ ⲞⲚ ⲦⲈⲚⲞⲨ ⲈⲒⲀϨⲈⲢⲀⲦ. ⲈⲨⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ⲈⲦⲂⲈ ⲐⲈⲖⲠⲒⲤ ⲘⲠⲈⲢⲎⲦ. ⲚⲦⲀϤϢⲰⲠⲈ ⲚⲚⲀϨⲢⲚ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲦⲘⲚⲦⲤⲚⲞⲞⲨⲤⲈ ⲘⲪⲨⲖⲎ ⲘⲠⲈⲚⲄⲈⲚⲞⲤ ϨⲈⲖⲠⲒⲌⲈ ⲈⲦⲀϨⲞϤ. ⲈⲨϢⲘϢⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲞⲠⲤ ⲚⲦⲈⲨϢⲎ ⲘⲚ ⲠⲈϨⲞⲞⲨ. ⲈⲦⲂⲈ ⲦⲈⲒϨⲈⲖⲠⲒⲤ ⲠⲢⲢⲞ ⲈⲨⲈⲄⲔⲀⲖⲈⲒ ⲚⲀⲒ ⲚϬⲒ ⲚⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ⲈⲦⲂⲈ ⲞⲨ ϤⲞ ⲚⲀⲠⲒⲤⲦⲞⲤ ⲚⲚⲀϨⲢⲎⲦⲚ. ⲈϢϪⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲦⲞⲨⲚⲈⲤ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ⲀⲚⲞⲔ ϬⲈ ⲚⲈⲀⲒⲔⲀⲀⲤ ϨⲀ ⲒⲀⲦ ⲠⲈ ⲈϮ ⲞⲨⲂⲈ ⲠⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲚⲀⲌⲰⲢⲀⲒⲞⲤ ⲈⲠⲈϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ⲠⲀⲒ ϬⲈ ⲀⲒⲀⲀϤ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲀⲒⲚⲈϪ ϨⲀϨ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ ⲈⲠⲈϢⲦⲈⲔⲞ. ⲈⲀⲒϪⲒ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ⲀⲨⲰ ⲞⲚ ⲀⲒϮⲠⲌⲎⲪⲞⲤ ⲈⲦⲀⲔⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ⲚⲈⲒⲆⲒⲘⲰⲢⲒ ⲆⲈ ⲘⲘⲞⲞⲨ ⲚϨⲀϨ ⲚⲤⲞⲠ ϨⲚ ⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲒⲘ ⲈⲒⲀⲚⲀⲄⲔⲀⲌⲈ ⲘⲘⲞⲞⲨ ⲈϪⲒⲞⲨⲀ ⲈⲠⲈϤⲢⲀⲚ ⲀⲨⲰ ⲈⲒϬⲞⲚⲦ ⲈⲢⲞⲞⲨ ⲈⲠⲈϨⲞⲨⲞ ⲚⲈⲒⲆⲒⲰⲔⲈ ⲚⲤⲰⲞⲨ ϢⲀϨⲢⲀⲒ ⲈⲘⲠⲞⲖⲒⲤ ⲈⲦⲞⲨⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ⲈⲒⲚⲀⲂⲰⲔ ⲆⲈ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ϨⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲦⲀⲒϪⲒⲦⲤ ⲚⲦⲚⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ⲀⲚⲀⲨ ⲈⲠⲢⲢⲞ ϨⲚ ⲦⲈϨⲒⲎ ⲘⲠⲚⲞⲨ ⲘⲘⲈⲈⲢⲈ ⲈⲨⲞⲨⲞⲈⲒⲚ ⲈⲀϤⲠⲒⲢⲀ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈϨⲞⲨⲈ ⲠⲞⲨⲞⲈⲒⲚ ⲘⲠⲢⲎ ⲀϤϢⲀ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ⲘⲚ ⲚⲈⲦⲘⲞⲞϢⲈ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ⲀⲨⲰ ⲚⲦⲈⲢⲚϨⲈ ⲦⲎⲢⲚ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲔⲀϨ ⲈⲂⲞⲖ ϨⲚ ⲐⲞⲦⲈ ⲀⲒⲤⲰⲦⲘ ⲈⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲒ ⲚⲦⲀⲤⲠⲈ ⲘⲘⲚⲦϨⲈⲂⲢⲀⲒⲞⲤ ϪⲈ ⲤⲀⲨⲖⲈ ⲤⲀⲨⲖⲈ ⲀϨⲢⲞⲔ ⲔⲠⲎⲦ ⲚⲤⲰⲒ ⲤⲘⲞⲔϨ ⲚⲀⲔ ⲈϮⲦⲂⲎⲢ ⲈϨⲞⲨⲚ ϨⲚ ϨⲈⲚⲤⲞⲨⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ⲀⲚⲞⲔ ⲆⲈ ⲠⲈϪⲀⲒ ϪⲈ ⲚⲦⲔ ⲚⲒⲘ ⲠϪⲞⲈⲒⲤ. ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲔⲠⲎⲦ ⲚⲤⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ⲀⲖⲖⲀ ⲦⲰⲞⲨⲚ ⲚⲄⲀϨⲈⲢⲀⲦⲔ ϨⲒϪⲚ ⲚⲈⲔⲞⲨⲈⲢⲎⲦⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲄⲀⲢ ⲀⲒⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ⲈⲦⲞϢⲔ ⲚϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨⲰ ⲘⲘⲚⲦⲢⲈ ⲚⲐⲈ ⲚⲦⲀⲔⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲨⲰ ⲚⲐⲈ ⲈϮⲚⲀⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ");
INSERT INTO copshc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ⲈⲒⲚⲞⲨϨⲘ ⲘⲘⲞⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲖⲀⲞⲤ ⲘⲚ ⲚϨⲈⲐⲚⲞⲤ. ⲚⲀⲒ ⲀⲚⲞⲔ ⲈϮⲚⲀϪⲞⲞⲨⲔ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ⲈⲞⲨⲰⲚ ⲚⲚⲈⲨⲂⲀⲖ ⲈⲔⲦⲞⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀⲔⲈ ⲈⲠⲞⲨⲞⲈⲒⲚ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈϨⲞⲨⲚ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲦⲢⲈⲨϪⲒ ⲘⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲚⲞⲂⲈ ⲀⲨⲰ ⲞⲨⲔⲖⲎⲢⲞⲤ ⲘⲚ ⲚⲈⲦⲞⲨⲀⲀⲂ ϨⲘ ⲠⲦⲢⲈⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲠⲢⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ⲘⲠⲒⲢⲀⲦⲤⲰⲦⲘ ⲈⲠϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲦⲀϤϢⲰⲠⲈ ⲚⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ⲀⲖⲖⲀ ⲀⲒⲔⲎⲢⲨⲤⲤⲈ ⲚϢⲞⲢⲠ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲀⲨⲰ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲚ ⲦⲈⲬⲰⲢⲀ ⲦⲎⲢⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲢⲈⲨⲘⲈⲦⲀⲚⲞⲒ ⲀⲨⲰ ⲚⲤⲈⲔⲦⲞⲞⲨ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲨⲈⲒⲢⲈ ⲚⲚⲈϨⲂⲎⲨⲈ ⲈⲨⲘⲠϢⲀ ⲚⲦⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨϬⲞⲠⲦ ϨⲘ ⲠⲈⲢⲠⲈ ⲀⲨϨⲒⲦⲞⲞⲦⲞⲨ ⲈϨⲞⲦⲂⲈⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ⲀⲒⲘⲀⲦⲈ ⲆⲈ ⲚⲞⲨⲂⲞⲎⲐⲒⲀ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲈⲒⲀϨⲈⲢⲀⲦ ϢⲀϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ⲈⲒⲢⲘⲚⲦⲢⲈ ⲚⲚⲔⲞⲨⲒ ⲘⲚ ⲚⲚⲞϬ. ⲚϮϪⲈ ⲖⲀⲀⲨ ⲀⲚ ⲠⲂⲞⲖ ⲚⲚⲈⲚⲦⲀ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲚ ⲘⲰⲨⲤⲎⲤ ϪⲞⲞⲨ ⲈⲨⲚⲀϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲀϢⲞⲠⲞⲨ. ⲀⲨⲰ ⲠϢⲞⲢⲠ ⲠⲈ ⲚⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲀⲨⲰ ϤⲚⲀϪⲰ ⲚⲞⲨⲞⲈⲒⲚ ⲘⲠⲖⲀⲞⲤ ⲘⲚ ⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ⲚⲀⲒ ⲆⲈ ⲈϤⲦⲀⲨⲞ ⲘⲘⲞⲞⲨ ⲠⲈϪⲈ ⲪⲎⲤⲦⲞⲤ ⲚⲀϤ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲘⲎ ϪⲈ ⲠⲀⲨⲖⲈ ⲔⲖⲞⲂⲈ. ⲀⲠⲈϨⲞⲨⲈ ⲤϨⲀⲒ ⲖⲈⲂⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚϮⲖⲞⲂⲈ ⲀⲚ ⲪⲎⲤⲦⲈ ⲠⲈⲔⲢⲀⲦⲒⲤⲦⲞⲤ. ⲀⲖⲖⲀ ⲈⲒϪⲰ ⲚϨⲈⲚϢⲀϪⲈ ⲘⲘⲈ ϨⲒ ⲘⲚⲦⲢⲘⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ϤⲤⲞⲞⲨⲚ ⲆⲈ ⲚⲚⲀⲒ ⲚϬⲒ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲠⲢⲢⲞ ⲠⲀⲒ ⲈϮϢⲀϪⲈ ⲚⲘⲘⲀϤ ⲀⲨⲰ ⲈⲒⲠⲀⲢⲢⲎ ⲤⲒⲀⲌⲈ ⲘⲘⲞⲒ ⲀⲨⲰ ϮⲠⲒⲐⲈ ϪⲈ ⲘⲚ ⲖⲀⲀⲨ ⲚⲚⲀⲒ ϨⲎⲠ ⲈⲢⲞϤ ⲚⲦⲀ ⲠⲈⲒϨⲰⲂ ⲄⲀⲢ ϢⲰⲠⲈ ⲀⲚ ϨⲘ ⲪⲰⲠ. ");
INSERT INTO copshc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ⲔⲠⲒⲤⲦⲈⲨⲈ ⲠⲢⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ⲈⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ϮⲤⲞⲞⲨⲚ ϪⲈ ⲔⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ϨⲚ ⲞⲨⲔⲞⲨⲒ ⲚϢⲀϪⲈ ⲔⲠⲒⲐⲈ ⲘⲘⲞⲒ ⲈⲀⲀⲦ ⲚⲬⲢⲎⲤⲦⲒⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ϪⲈ ϮϢⲖⲎⲖ ⲈⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲔⲞⲨⲒ ⲘⲚ ⲞⲨⲚⲞϬ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲦⲞⲔ. ⲀⲖⲖⲀ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤⲰⲦⲘ ⲈⲢⲞⲒ ⲘⲠⲞⲞⲨ ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲚⲐⲈ ϨⲰⲰⲦ ⲞⲚ ⲈϮⲚϨⲎⲦⲤ ϢⲀⲚⲦⲈ ⲚⲈⲒⲘⲢⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ⲚⲀⲒ ⲆⲈ ⲚⲦⲈⲢⲈϤϪⲞⲞⲨ ⲀϤⲦⲰⲞⲨⲚ ⲚϬⲒ ⲠⲢⲢⲞ ⲘⲚ ⲠϨⲎⲄⲈⲘⲰⲚ. ⲀⲨⲰ ⲂⲈⲢⲈⲚⲒⲔⲎ ⲘⲚ ⲚⲈⲦϨⲘⲞⲞⲤ ϨⲀϨⲦⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ⲀⲨⲰ ⲀⲨⲀⲚⲀⲬⲰⲢⲒ ⲀⲨϢⲀϪⲈ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲒⲢⲰⲘⲈ ⲢⲖⲀⲀⲨ ⲀⲚ ⲚϨⲰⲂ ⲈϤⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲪⲎⲤⲦⲞⲤ ϪⲈ ⲈⲚⲈⲞⲨⲚϬⲞⲘ ⲈⲔⲀ ⲠⲈⲒⲢⲰⲘⲈ ⲈⲂⲞⲖ. ⲚⲤⲀⲂⲎⲖ ϪⲈ ⲀϤⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ⲚⲦⲈⲢⲞⲨⲔⲢⲒⲚⲈ ⲆⲈ ⲈⲦⲢⲈⲚⲤϬⲎⲢ ⲈⲦϨⲒⲦⲀⲖⲒⲀ ⲀⲨϮ ⲠⲀⲨⲖⲞⲤ ⲘⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲨⲘⲎⲢ ⲚⲞⲨϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲞⲨⲖⲒⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲤⲠⲒⲢⲀ ⲚⲤⲈⲂⲀⲤⲦⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ⲀⲚⲀⲖⲈ ⲆⲈ ⲈⲨϪⲞⲒ ⲈⲂⲞⲖ ϨⲚ ⲚⲀⲦⲢⲀⲘⲨⲆⲆⲎ. ⲈϤⲚⲀⲢϨⲰⲦ ⲈⲘⲘⲀ ⲚⲦⲀⲤⲒⲀ ⲀⲚⲔⲰ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ⲀϤⲈⲒ ⲚⲘⲘⲀⲚ ⲠⲈⲂⲞⲖ ϨⲚ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ⲚⲦⲈ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲚⲘⲞⲞⲚⲈ ⲈⲤⲒⲆⲰⲚ. ⲒⲞⲨⲖⲒⲞⲤ ⲆⲈ ⲀϤⲈⲒⲢⲈ ⲚⲞⲨⲘⲚⲦⲘⲀⲒⲢⲰⲘⲈ ⲘⲚ ⲠⲀⲨⲖⲞⲤ ⲀϤⲔⲀⲀϤ ⲈⲦⲢⲈϤⲂⲰⲔ ⲈϨⲢⲀⲒ ϢⲀ ⲚⲈϤϢⲂⲈⲈⲢ ⲈϢⲘϢⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ⲀⲚⲔⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲤϬⲎⲢ ⲈⲦⲞⲨⲚ ⲔⲨⲠⲢⲞⲤ. ⲈⲦⲂⲈ ϪⲈ ⲚⲈⲢⲈ ⲚⲦⲎⲨ ϮⲞⲨⲂⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ⲀⲨⲰ ⲚⲦⲈⲢⲚⲢϨⲰⲦ ϨⲘ ⲠⲠⲈⲖⲀⲔⲞⲤ ⲚⲦⲔⲒⲖⲒⲔⲒⲀ ⲘⲚ ⲦⲠⲀⲘⲪⲨⲖⲒⲀ. ⲀⲚⲈⲒ ⲈⲘⲨⲢⲢⲀ ⲚⲦⲖⲨⲔⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ⲀⲨⲰ ⲀⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ϨⲈ ⲈⲨϪⲞⲒ ⲚⲦⲈ ⲢⲀⲔⲞⲦⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈϤⲚⲀⲢϨⲰⲦ ⲈⲦϨⲒⲦⲀⲖⲒⲀ ⲀϤⲦⲀⲖⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ⲚⲦⲈⲢⲚⲰⲤⲔ ⲆⲈ ⲚϨⲀϨ ⲚϨⲞⲞⲨ ϨⲘ ⲠⲈⲤϬⲎⲢ. ⲀⲨⲰ ⲘⲞⲄⲒⲤ ⲚⲦⲈⲢⲚⲠⲰϨ ⲈⲔⲚⲒⲦⲎ ⲘⲠⲦⲎⲨ ⲔⲰ ⲘⲘⲞⲚ ⲀⲚ. ⲀⲚⲢϨⲰⲦ ⲈⲦⲞⲨⲚ ⲔⲢⲎⲦⲎ ⲚⲦⲈⲤⲀⲖⲘⲞⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ⲘⲞⲄⲒⲤ ⲚⲦⲈⲢⲚⲤⲀⲀⲦⲤ. ⲀⲚⲈⲒ ⲈⲨⲘⲀ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲚⲖⲒⲘⲎⲚ ⲈⲦⲚⲀⲚⲞⲨⲞⲨ. ⲈⲢⲈ ⲞⲨⲠⲞⲖⲒⲤ ϨⲎⲚ ⲈⲢⲞϤ ϪⲈ ⲀⲖⲀⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲆⲈ ⲚⲞⲨⲞⲈⲒϢ ⲞⲨⲈⲒⲚⲈ. ⲀⲚⲢϨⲂⲀ ϨⲘ ⲠⲈⲤϬⲎⲢ ⲈⲦⲂⲈ ϪⲈ ⲀⲦⲔⲈⲚⲎⲤⲦⲒⲀ ⲞⲨⲈⲒⲚⲈ. ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤϪⲒϢⲞϪⲚⲈ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ. ϮⲚⲀⲨ ϪⲈ ⲈⲢⲈ ⲠⲈⲤϬⲎⲢ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲞⲨⲘⲔⲀϨ ⲘⲚ ⲞⲨⲚⲞϬ ⲚⲞⲤⲈ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲘⲠϪⲞⲒ ⲘⲚ ⲠⲀⲨⲈⲒⲚ ⲀⲖⲖⲀ ⲚⲈⲚⲔⲈⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲚⲈϤⲤⲰⲦⲘ ⲚⲤⲀ ⲠⲈⲦⲢϨⲘⲘⲈ ⲘⲚ ⲠⲚⲀⲨⲔⲖⲎⲢⲞⲤ ⲈϨⲞⲨ ⲈⲚⲈⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ⲘⲠⲖⲒⲘⲎⲚ ⲆⲈ ⲘⲞⲦⲚ ⲀⲚ ⲈⲘⲞⲞⲚⲈ ⲈⲢⲞϤ ⲀⲠⲈⲨϨⲞⲨⲞ ϪⲒϢⲞϪⲚⲈ ⲈⲔⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲀⲨ ϪⲈ ⲦⲚⲚⲀϢϬⲘϬⲞⲘ ⲈⲦⲀϨⲈ ⲞⲨⲖⲒⲘⲎⲚ ϪⲈ ⲠϨⲎⲚⲒⲜ ⲚⲦⲈ ⲦⲈⲔⲢⲒⲦⲎ ⲚⲤⲈⲘⲞⲞⲚⲈ ⲈⲢⲞϤ ⲈϤϬⲰϢⲦ ⲈⲠⲈⲘⲚⲦ ⲀⲨⲰ ⲈⲦⲈⲬⲰⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ⲚⲦⲈⲢⲈ ⲠⲦⲞⲨⲢⲎⲤ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ⲈⲨⲘⲈⲈⲨⲈ ϪⲈ ⲀⲠⲈⲨⲦⲰϢ ϢⲰⲠⲈ. ⲀⲨⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲀⲖⲀⲤⲞⲤ. ⲀϤⲔⲀ ⲔⲢⲎⲦⲎ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ⲘⲚⲚⲤⲀ ⲞⲨⲔⲞⲨⲒ ⲆⲈ ⲀⲨⲦⲎⲨ ⲚⲦⲢⲰⲘ ϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲀⲚ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲈⲨⲢⲀⲔⲨⲖⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ⲚⲦⲈⲢⲈϤⲦⲰⲢⲠ ⲆⲈ ⲘⲠϪⲞⲒ ⲈⲘⲚ ϬⲞⲘ ⲘⲘⲞϤ ⲈϮ ⲞⲨⲂⲈ ⲠⲦⲎⲨ. ⲀⲚⲔⲀⲀⲚ ⲈⲂⲞⲖ ⲀⲚⲢϨⲰⲦ ");
INSERT INTO copshc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ⲀⲚⲦⲰⲘⲚⲦ ⲆⲈ ⲈⲨⲘⲀ ⲈϨⲞⲨⲚ ⲈⲨⲚⲎⲤⲞⲤ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲔⲖⲀⲨⲆⲒⲀ. ⲘⲞⲄⲒⲤ ⲀⲚϬⲘϬⲞⲘ ⲈⲀⲘⲀϨⲦⲈ ⲚⲦⲈⲤⲔⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ⲀⲨⲀⲖⲈ ⲈⲢⲞⲤ ⲈⲨⲈⲒⲢⲈ ⲚϨⲈⲚⲂⲞⲎⲐⲒⲀ ⲈⲨⲘⲞⲨⲢ ⲘⲠϪⲞⲒ. ⲈⲨⲢϨⲞⲦⲈ ⲆⲈ ⲘⲎⲠⲰⲤ ⲚⲤⲈϨⲈ ⲈϨⲢⲀⲒ ⲈⲨⲘⲀ ⲈϤⲞ ⲚϨⲰⲚ. ⲀⲨⲚⲈϨ ⲠⲤⲞⲂⲦⲈ ⲀⲨⲔⲀⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ⲈⲢⲈ ⲠⲬⲒⲘⲰⲚ ⲆⲈ ϢⲞⲞⲠ ⲈϨⲢⲀⲒ ⲈϪⲰⲚ ⲈⲠⲈϨⲞⲨⲞ. ⲘⲠⲈϤⲢⲀⲤⲦⲈ ⲆⲈ ⲀⲨⲚⲞⲨϪⲈ ⲈⲂⲞⲖ ⲚⲚⲈⲨϨⲚⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ⲀⲨⲰ ⲘⲚⲚⲤⲀ ⲠⲈϤⲢⲀⲤⲦⲈ ⲀⲨⲚⲈϪ ⲠⲤⲞⲂⲦⲈ ⲦⲎⲢϤ ⲘⲠϪⲞⲒ ⲈⲐⲀⲖⲀⲤⲤⲀ ");
INSERT INTO copshc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ⲈⲘⲚⲢⲎ ⲆⲈ ⲚⲂⲞⲖ ⲞⲨⲆⲈ ⲘⲚⲤⲒⲞⲨ ⲚⲞⲨⲀⲠⲤ ⲚϨⲞⲞⲨ. ⲀⲨⲰ ⲚⲈⲢⲈ ⲞⲨⲚⲞϬ ⲚⲬⲒⲘⲰⲚ ϨⲒϪⲰⲚ. ⲚⲈⲘⲚ ⲖⲀⲀⲨ ϬⲈ ⲚϨⲈⲖⲠⲒⲤ ϢⲞⲞⲠ ⲚⲀⲚ ⲈⲦⲢⲈⲚⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ⲚⲦⲈⲢⲞⲨⲰⲤⲔ ⲆⲈ ⲘⲠⲞⲨⲰⲘ ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤⲀϨⲈⲢⲀⲦϤ ϨⲚ ⲦⲈⲨⲘⲎⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲈϢϢⲈ ⲘⲈⲚ ⲈⲢⲰⲦⲚ ⲠⲈ ⲈⲤⲰⲦⲘ ⲚⲤⲰⲒ ⲈⲦⲘⲔⲰ ⲈⲂⲞⲖ ϨⲚ ⲔⲢⲎⲦⲎ ⲀⲨⲰ ⲈϮϨⲎⲨ ⲘⲠⲈⲒⲘⲔⲀϨ ⲘⲚ ⲠⲈⲒⲞⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ⲦⲈⲚⲞⲨ ⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲦⲰⲔ ⲚϨⲎⲦ. ⲘⲚ ⲞⲨⲮⲨⲬⲎ ⲄⲀⲢ ⲚⲞⲨⲰⲦ ⲚⲀϨⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈⲒ ⲘⲎⲦⲒ ⲠϪⲞⲒ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ⲀϤⲞⲨⲰⲚϨ ⲄⲀⲢ ⲚⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲒⲞⲨϢⲎ ⲚϬⲒ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈ ⲠⲀⲚⲞⲨⲦⲈ ⲈϮϢⲘϢⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢⲢϨⲞⲦⲈ ⲠⲀⲨⲖⲈ. ϨⲀⲠⲤ ⲈⲦⲢⲈⲨⲦⲀϨⲞⲔ ⲈⲢⲀⲦⲔ ⲘⲠⲢⲢⲞ. ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀⲠⲚⲞⲨⲦⲈ ⲬⲀⲢⲒⲌⲈ ⲚⲀⲔ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲤϬⲎⲢ ⲚⲘⲘⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲚⲢⲰⲘⲈ ⲘⲀⲢⲈ ⲠⲈⲦⲚϨⲎⲦ ⲞⲨⲢⲞⲦ. ϮⲠⲒⲤⲦⲈⲨⲈ ⲄⲀⲢ ⲈⲠⲚⲞⲨⲦⲈ ϪⲈ ⲤⲚⲀϢⲰⲠⲈ ⲔⲀⲦⲀ ⲐⲈ ⲚⲦⲀⲨϪⲞⲞⲤ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ϨⲀⲠⲤ ⲈⲦⲢⲈⲚⲦⲰⲘⲚⲦ ⲈϨⲞⲨⲚ ⲈⲨⲚⲎⲤⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ⲚⲦⲈⲢⲈ ⲦⲘⲈϨⲘⲚⲦⲀϤⲦⲈ ⲆⲈ ⲚⲞⲨϢⲎ ϢⲰⲠⲈ ⲈⲚⲢϨⲰⲦ ϨⲘ ⲠⲀⲚⲦⲢⲒⲀⲤ. ⲚⲈⲢⲈ ⲚⲚⲈⲈϤ ϪⲰ ⲘⲘⲞⲤ ϨⲚ ⲦⲠⲀϢⲈ ⲚⲦⲈⲨϢⲎ ϪⲈ ⲀⲚϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲨⲬⲰⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ⲀⲨⲰ ⲚⲦⲈⲢⲞⲨⲚⲞⲨϪⲈ ⲚⲦⲂⲞⲖⲒⲤ ⲀⲨϨⲈ ⲈϪⲞⲨⲰⲦ ⲚϨⲠⲞⲦ ⲘⲘⲞⲞⲨ. ⲚⲦⲈⲢⲞⲨϬⲰ ⲞⲚ ⲚⲔⲈⲔⲞⲨⲒ. ⲀⲨⲚⲞⲨϪⲈ ⲞⲚ ⲚⲦⲂⲞⲖⲒⲤ ⲈⲠⲘⲞⲞⲨ ⲀⲨϨⲈ ⲈⲘⲚⲦⲎ ⲚϨⲠⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ⲈⲨⲢϨⲞⲦⲈ ϬⲈ ϪⲈ ⲘⲎⲠⲰⲤ ⲚⲦⲚⲦⲰⲘⲚⲦ ⲈϨⲞⲨⲚ ⲈⲨⲘⲀ ⲈϤⲚⲀϢⲦ. ⲀⲨⲚⲈϪ ϤⲦⲞⲞⲨ ⲚϨⲀⲨϬⲀⲖ ϨⲒ ⲠⲀϨⲞⲨ. ⲀⲨϢⲖⲎⲖ ⲈⲦⲢⲈ ϨⲦⲞⲞⲨⲈ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ⲈⲢⲈ ⲚⲚⲈⲈϤ ⲆⲈ ϢⲒⲚⲈ ⲚⲤⲀ ⲠⲰⲦ ⲈⲔⲀ ⲠϪⲞⲒ. ⲀⲨⲰ ⲀⲨⲬⲀⲖⲀ ⲚⲦⲔⲀⲦⲞ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ ⲈⲨϬⲚ ⲖⲞⲒϬⲈ ϪⲈ ⲈⲚⲚⲀⲚⲈϪ ϨⲀⲨϬⲀⲖ ϨⲒⲐⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲪⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲘⲚ ⲘⲘⲀⲦⲞⲒ. ϪⲈ ⲈⲢⲈⲦⲘ ⲚⲀⲒ ϬⲰ ϨⲒ ⲠϪⲞⲒ. ⲚⲦⲰⲦⲚ ⲚⲦⲈⲦⲚ ⲀϢⲞⲨϪⲀⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ⲦⲞⲦⲈ ⲘⲘⲀⲦⲞⲒ ⲀⲨⲤⲰⲖⲠ ⲚⲚⲚⲞⲨϨ ⲚⲦⲈⲤⲔⲀⲪⲎ ⲀⲨⲔⲀⲀⲤ ⲈⲂⲞⲖ ⲈⲦⲢⲈⲤⲂⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ϢⲀⲚⲦⲈ ϨⲦⲞⲞⲨⲈ ϨⲰⲚ ⲈϢⲰⲠⲈ ⲚⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲤⲞⲠⲤ ⲘⲘⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲦⲢⲈⲨϪⲒ ⲚⲞⲨϨⲢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲒⲤ ⲘⲚⲦⲀϤⲦⲈ ϨⲞⲞⲨ ⲈⲠⲞⲞⲨ ⲀⲦⲈⲦⲚⲘⲞⲨⲚ ⲈⲂⲞⲖ ⲈⲦⲈⲦⲚϨⲔⲀⲈⲒⲦ ⲘⲠⲈⲦⲚⲞⲨⲈⲘ ⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲤⲞⲠⲤ ⲘⲘⲰⲦⲚ ⲈⲦⲢⲈⲦⲚϪⲒ ⲚⲞⲨϨⲢⲈ. ⲠⲀⲒ ⲄⲀⲢ ⲈϤϢⲞⲞⲠ ϨⲀⲐⲎ ⲘⲠⲈⲦⲚⲞⲨϪⲀⲒ. ⲘⲚ ⲞⲨϤⲰ ⲄⲀⲢ ⲚⲞⲨⲰⲦ ⲚⲀϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲀⲠⲈ ⲚⲖⲀⲀⲨ ⲘⲘⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ⲚⲦⲈⲢⲈϤϪⲈ ⲚⲀⲒ ⲆⲈ ⲀϤϪⲒ ⲚⲞⲨⲞⲈⲒⲔ ⲀϤⲈⲨⲬⲀⲢⲒⲤⲦⲒ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲀⲨⲰ ⲀϤⲠⲞϢϤ ⲀϤⲀⲢⲬⲈⲒ ⲚⲞⲨⲰⲘ. ⲀϤϮ ϨⲰⲰⲚ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ⲀⲨⲞⲨⲢⲞⲦ ⲆⲈ ⲚϨⲎⲦ ⲦⲎⲢⲞⲨ. ⲚⲦⲞⲞⲨ ϨⲰⲞⲨ ⲞⲚ ⲀⲨϪⲒ ⲚⲞⲨⲦⲢⲞⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ⲚⲈⲚⲈⲒⲢⲈ ⲆⲈ ⲦⲎⲢⲚ ⲚⲀϢϤⲈⲦⲀⲤⲈ ⲘⲮⲨⲬⲎ ϨⲒ ⲠϪⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ⲚⲦⲈⲢⲞⲨⲤⲈⲒ ⲆⲈ ⲀⲨⲦⲢⲈ ⲠϪⲞⲒ ⲀⲤⲀⲒ. ⲈⲨⲚⲞⲨϪⲈ ⲘⲠⲈⲤⲞⲨⲞ ⲈⲦⲈⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ⲚⲦⲈⲢⲈ ϨⲦⲞⲞⲨⲈ ⲆⲈ ϢⲰⲠⲈ ⲠⲘⲀ ⲘⲈⲚ ⲘⲠⲈ ⲚⲚⲈⲈϤ ⲤⲞⲨⲰⲚϤ ⲞⲨⲔⲞⲖⲠⲞⲤ ⲆⲈ ⲠⲈⲚⲦⲀⲨⲈⲒⲞⲢϨϤ ⲈⲨⲚ ⲞⲨⲘⲀ ⲘⲘⲞⲞⲚⲈ ⲚϨⲎⲦϤ ⲀⲨⲰ ⲀⲨϪⲒϢⲞϪⲚⲈ ⲈⲚⲀⲨ ϪⲈ ⲤⲈⲚⲀϢϬⲘϬⲞⲘ ⲈⲦⲞⲨϪⲈ ⲠϪⲞⲒ ⲈϨⲞⲨⲚ ⲈⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ⲀⲨⲦⲈⲔⲘ ⲚϨⲀⲨϬⲀⲖ ⲀⲨⲔⲀⲀⲨ ⲈⲨⲀϢⲈ ϨⲚ ⲐⲀⲖⲀⲤⲤⲀ ϨⲀⲘⲀ ⲀⲨⲔⲀ ϪⲰⲞⲨ ⲈⲂⲞⲖ ⲚⲚϨⲒⲎⲨ ⲀⲨϤⲒ ⲈϨⲢⲀⲒ ⲚⲦϬⲒⲤⲖⲀⲨⲞ ⲀⲨⲢϨⲰⲦ ⲘⲠⲦⲎⲨ ⲈⲦⲚⲂⲞⲖ ⲈϨⲞⲨⲚ ⲈⲠⲈⲔⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ⲀⲨⲦⲰⲘⲚⲦ ⲆⲈ ⲈⲨⲘⲀ ⲈϤⲞ ⲚϨⲰⲚ ϨⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲀⲨⲘⲀⲚⲈ ⲠϪⲞⲒ ⲈⲢⲞϤ ⲀⲠⲈϤⲐⲎ ⲘⲈⲚ ⲦⲀϪⲢⲞ ⲀϤϬⲰ ⲈⲚϤⲔⲒⲘ ⲀⲚ ⲠⲈϤⲠⲀϨⲞⲨ ⲆⲈ ⲀϤⲂⲰⲖ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲚϢⲞⲦ ⲘⲠⲦⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ⲘⲘⲀⲦⲞⲒ ϬⲈ ⲀⲨϪⲒϢⲞϪⲚⲈ ⲈϨⲈⲦⲂ ⲚⲈⲦⲘⲎⲢ. ⲘⲎⲠⲰⲤ ⲚⲦⲈⲞⲨⲀ ⲚⲎⲎⲂⲈ ⲚϤⲢⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲀϤⲞⲨⲰϢ ⲈⲦⲞⲨϪⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤⲔⲰⲖⲨ ⲘⲠⲈⲨϢⲞϪⲚⲈ ⲀϤⲞⲨⲈϨⲤⲀϨⲚⲈ ⲚⲚⲈⲦⲈⲨⲚϬⲞⲘ ⲘⲘⲞⲞⲨ ⲈⲚⲎⲂⲈ ⲚⲤⲈϤⲞϬⲞⲨ ⲚϢⲞⲢⲠ ⲚⲤⲈⲂⲰⲔ ⲈⲠⲈⲔⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ⲀⲨⲰ ⲠⲔⲈⲤⲈⲈⲠⲈ ϨⲞⲒⲚⲈ ⲘⲈⲚ ϨⲚ ϨⲈⲚⲠⲀⲦⲤⲈ ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ϨⲒ ϨⲈⲚϨⲚⲀⲀⲨ ⲚⲦⲈ ⲠϪⲞⲒ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲀ ⲞⲨⲞⲚ ⲚⲒⲘ ⲞⲨϪⲀⲒ ⲈⲠⲈⲔⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ⲀⲨⲰ ⲚⲦⲈⲢⲈⲚⲞⲨϪⲀⲒ. ⲦⲞⲦⲈ ⲀⲚⲤⲞⲨⲚ ⲦⲚⲎⲤⲞⲤ ϪⲈ ⲘⲒⲖⲎⲦⲎ ⲠⲈ ⲠⲈⲤⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ⲚⲂⲀⲢⲂⲀⲢⲞⲤ ⲆⲈ ⲀⲨⲈⲒⲢⲈ ⲚⲀⲚ ⲚⲞⲨⲚⲞϬ ⲘⲘⲚⲦⲘⲀⲒⲢⲰⲘⲈ. ⲀⲨϪⲈⲢⲞ ⲄⲀⲢ ⲚⲞⲨⲔⲰϨⲦ ⲀⲨϢⲞⲠⲚ ⲈⲢⲞⲞⲨ ⲈⲦⲂⲈ ⲠϪⲀϤ ⲈⲦⲚⲂⲞⲖ ⲘⲚ ⲠϨⲰⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ⲚⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ϬⲖⲞⲨⲀϢⲎ ⲚϬⲖⲘ ⲀϤⲚⲞϪⲞⲨ ⲈⲠⲔⲰϨⲦ. ⲀⲨϨⲂⲰ ⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲘⲘⲈ ⲀⲤⲘⲀϨⲢⲰⲤ ⲚⲦⲈϤϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ⲚⲦⲈⲢⲈ ⲚⲂⲀⲢⲂⲀⲢⲞⲤ ⲆⲈ ⲚⲀⲨ ⲈⲠⲈⲐⲎⲢⲒⲞⲚ ⲈϤⲀϢⲈ ⲚⲤⲀⲦⲈϤϬⲒϪ. ⲠⲈϪⲀⲨ ⲚⲚⲈⲨⲈⲢⲎⲨ ϪⲈ ⲠⲀⲚⲦⲰⲤ ⲠⲈⲒⲢⲰⲘⲈ ⲞⲨⲢⲈϤϨⲰⲦⲂ ⲠⲈ. ϪⲈ ⲚⲦⲈⲢⲈϤⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲚ ⲐⲀⲖⲀⲤⲤⲀ ⲘⲠⲈ ⲠⲈϤⲘⲠϢⲀ ⲔⲀⲀϤ ⲈⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ⲚⲦⲞϤ ⲆⲈ ⲚⲦⲈⲢⲈϤⲚⲞⲨϨⲈ ⲘⲠⲈⲐⲎⲢⲒⲞⲚ ⲈϨⲢⲀⲒ ⲈⲠⲔⲰϨⲦ ⲘⲠϤⲘⲔⲀϨ ⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲈⲨϬⲰϢⲦ ⲚⲤⲰϤ ⲠⲈ ϨⲰⲤ ⲈϤⲚⲀϢⲰϨⲂ ⲎⲚϤϨⲈ ⲈϨⲢⲀⲒ ϨⲚ ⲞⲨϢⲤⲚⲈ ⲚϤⲘⲞⲨ ⲈⲨⲈⲒⲞⲢⲘ ⲆⲈ ⲚⲤⲰϤ ⲚⲞⲨⲚⲞϬ ⲚⲔⲞⲞⲨ ⲀⲨⲰ ⲈⲨⲚⲀⲨ ϪⲈ ⲘⲠⲈⲖⲀⲀⲨ ⲘⲠⲈⲐⲞⲞⲨ ⲦⲀϨⲞϤ ⲀⲨⲔⲦⲞⲞⲨ ⲠⲈϪⲀⲨ ϪⲈ ⲞⲨⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ⲚⲈⲨⲚ ϨⲈⲚϬⲞⲞⲘ ⲆⲈ ⲠⲈ ⲘⲠⲔⲰⲦⲈ ⲈⲦⲘⲘⲀⲨ ⲈⲚⲀⲠⲀⲢⲬⲰⲚ ⲚⲦⲚⲎⲤⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲠⲞⲨⲠⲖⲒⲞⲤ. ⲠⲀⲒ ⲀϤϢⲞⲠⲚ ⲈⲢⲞϤ ⲚϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ. ⲀϤⲢⲞⲨⲚⲞϬ ⲈⲢⲞⲚ ⲘⲘⲚⲦⲘⲀⲒϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲈⲦⲢⲈ ⲠⲈⲒⲰⲦ ⲘⲠⲞⲨⲠⲖⲒⲞⲤ ϨⲘⲞⲘ ⲀⲨⲰ ⲚϤϢⲰⲚⲈ ⲈϨⲎⲦϤ ⲚϤⲚⲔⲞⲦⲔ ⲠⲀⲨⲖⲞⲤ ⲀϤⲂⲰⲔ ⲈϨⲞⲨⲚ ϢⲀⲢⲞϤ ⲀϤϢⲖⲎⲖ ⲀϤⲦⲀⲖⲈ ⲦⲞⲞⲦϤ ⲈϨⲢⲀⲒ ⲈϪⲰϤ ⲀϤⲦⲀⲖϬⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ⲚⲦⲈⲢⲈ ⲠⲀⲒ ⲆⲈ ϢⲰⲠⲈ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲈⲦϨⲚ ⲦⲚⲎⲤⲞⲤ ⲈⲦϢⲞⲞⲠ ϨⲚ ϨⲈⲚϢⲰⲚⲈ. ⲀⲨϮ ⲠⲈⲨⲞⲨⲞⲒ ⲈⲢⲞϤ ⲀϤⲢⲠⲀϨⲢⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ⲚⲦⲞⲞⲨ ⲆⲈ ⲀⲨⲈⲒⲚⲈ ⲚⲀⲚ ⲚϨⲈⲚⲚⲞϬ ⲚⲦⲀⲒⲞ. ⲚⲦⲈⲢⲚⲚⲞⲨ ⲆⲈ ⲈⲔⲰ ⲈⲂⲞⲖ ⲀⲚⲦⲀⲖⲞ ⲘⲠⲈⲦⲚⲢⲬⲢⲒⲀ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚⲈⲂⲞⲦ ⲀⲚⲤϬⲎⲢ ϨⲒ ⲞⲨϪⲞⲒ ⲚⲦⲈ ⲢⲀⲔⲞⲦⲈ ⲈⲀϤⲘⲞⲞⲚⲈ ⲈⲦⲚⲎⲤⲞⲤ ⲈⲢⲈ ⲞⲨⲘⲀⲈⲒⲚ ⲘⲘⲞϤ ⲚⲆⲒⲞⲤⲔⲞⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ⲀⲨⲰ ⲚⲦⲈⲢⲚⲘⲞⲞⲚⲈ ⲈⲤⲨⲢⲀⲔⲞⲨⲤⲀ ⲀⲚⲢ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ⲈⲂⲞⲖ ⲆⲈ ϨⲘ ⲠⲘⲀ ⲈⲦⲘⲘⲀⲨ ⲀⲚⲤϬⲎⲢ ⲀⲚⲔⲀⲦⲀⲚⲦⲀ ⲈϨⲢⲎⲄⲒⲞⲤ. ⲀⲨⲰ ⲘⲚⲚⲤⲀ ⲞⲨϨⲞⲞⲨ ⲚⲦⲈⲢⲈⲞⲨⲦⲞⲨⲢⲎⲤ ⲚⲒϤⲈ. ⲀⲚⲈⲒ ⲘⲠⲈⲚⲤⲚⲀⲨ ⲈⲠⲞⲚⲦⲒⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ⲀⲚϨⲈ ⲈϨⲈⲚⲤⲚⲎⲨ ⲘⲘⲀⲨ. ⲀⲨⲤⲈⲠⲤⲰⲠⲚ ⲈϬⲰ ϨⲀⲦⲎⲨ ⲚⲤⲀϢϤ ⲚϨⲞⲞⲨ. ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲀⲚⲂⲰⲔ ⲈϨⲢⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ⲚⲈⲤⲚⲎⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲤⲰⲦⲘ ⲘⲘⲀⲨ ⲈⲦⲂⲎⲦⲚ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲚϢⲞⲘⲦⲈ ⲘⲘⲞⲚⲎ ϢⲀ ⲠⲠⲒⲞⲤ ⲪⲞⲢⲞⲤ ⲈⲦⲰⲘⲚⲦ ⲈⲢⲞⲚ ⲚⲦⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀϤⲦⲰⲔ ⲚϨⲎⲦ ⲀϤⲈⲨⲬⲀⲢⲒⲤⲦⲒ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ⲚⲦⲈⲢⲚⲂⲰⲔ ⲆⲈ ⲈϨⲞⲨⲚ ⲈϨⲢⲰⲘⲎ. ⲀⲠϨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ϮⲚⲈⲦⲘⲎⲢ ⲈⲦⲞⲞⲦϤ ⲘⲠⲀⲢⲬⲰⲚ ⲚⲘⲘⲀⲦⲞⲒ. ⲀϤⲔⲀ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲢⲈϤϬⲰ ϨⲀⲢⲒ ϨⲀⲢⲞϤ ⲘⲚ ⲠⲘⲀⲦⲞⲒ ⲈⲦϨⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ⲀⲤϢⲰⲠⲈ ⲆⲈ ⲘⲚⲚⲤⲀ ϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲀϤⲘⲞⲨⲦⲈ ⲈⲚⲀⲢⲬⲰⲚ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲠⲈϪⲀϤ ⲚⲀⲨ ϪⲈ ⲚⲢⲰⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲀⲚⲞⲔ ⲚⲦⲀⲒϮ ⲀⲚ ⲞⲨⲂⲈ ⲠⲖⲀⲞⲤ ⲎⲠⲤⲰⲚⲦ ⲚⲚⲈⲚⲈⲒⲞⲦⲈ ⲀⲨϮ ⲘⲘⲞⲒ ⲈⲒⲘⲎⲢ ⲈⲂⲞⲖ ϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈϨⲢⲀⲒ ⲈⲚϬⲒϪ ⲚⲚⲈϨⲢⲰⲘⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ⲚⲦⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲢⲞⲨⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ. ⲀⲨⲞⲨⲰϢ ⲈⲔⲀⲀⲦ ⲈⲂⲞⲖ. ⲈⲦⲂⲈ ϪⲈ ⲘⲠⲞⲨϨⲈ ⲈⲖⲀⲀⲨ ⲚⲀⲒⲦⲒⲀ ⲘⲘⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ⲚⲦⲈⲢⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ϮⲞⲨⲂⲎⲒ ⲀⲨⲀⲚⲀⲄⲔⲀⲌⲈ ⲘⲘⲞⲒ ⲈⲦⲢⲀⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲢⲞ. ϨⲰⲤ ⲈⲒⲚⲀⲔⲀⲦⲎⲄⲞⲢⲒ ⲀⲚ ⲘⲠⲀϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ⲈⲦⲂⲈ ⲦⲈⲒⲈⲦⲒⲀ ϬⲈ ⲀⲒⲤⲈⲠⲤ ⲦⲎⲨⲦⲚ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲚ ⲀⲨⲰ ⲈϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ. ⲈⲒⲘⲎⲢ ⲄⲀⲢ ⲚⲦⲈⲒϨⲀⲖⲨⲤⲒⲤ ⲈⲦⲂⲈ ⲐⲈⲖⲠⲒⲤ ⲘⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ⲚⲦⲞⲞⲨ ϬⲈ ⲠⲈϪⲀⲨ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲆⲈ ⲘⲠⲚϪⲒ ⲤϨⲀⲒ ⲈⲦⲂⲎⲎⲦⲔ ⲈⲂⲞⲖ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ. ⲞⲨⲆⲈ ⲘⲠⲈ ⲞⲨⲀ ⲚⲚⲈⲤⲚⲎⲨ ⲈⲒ ⲚϤⲦⲀⲘⲞⲚ ⲚϤϪⲰ ⲚⲞⲨⲠⲈⲐⲞⲞⲨ ⲈⲦⲂⲎⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ⲦⲚⲀⲜⲒⲞⲨ ⲆⲈ ⲘⲘⲞⲔ ⲈⲦⲢⲈⲚⲤⲰⲦⲘ ⲈⲚⲈⲦⲔⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ. ⲈⲦⲂⲈ ⲦⲈⲒϨⲀⲒⲢⲈⲤⲒⲤ ⲄⲀⲢ ⲀⲨⲦⲀⲘⲞⲚ ϪⲈ ⲤⲈⲀⲚⲦⲒⲖⲈⲄⲈ ϨⲒⲰⲰⲤ ϨⲘ ⲘⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ⲀⲨⲦⲀⲤⲤⲈ ⲆⲈ ⲚⲀϤ ⲈⲨϨⲞⲞⲨ ⲀⲨⲈⲒ ϢⲀⲢⲞϤ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ ⲈⲠⲘⲀ ⲈⲦϤⲚϨⲎⲦϤ. ⲀⲨⲰ ⲀϤϢⲀϪⲈ ⲚⲘⲘⲀⲨ ⲈϤⲢⲘⲚⲦⲢⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲈϤⲠⲒⲐⲈ ⲘⲘⲞⲞⲨ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲒⲚϨⲦⲞⲞⲨⲈ ϢⲀⲢⲞⲨϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ϨⲞⲒⲚⲈ ⲆⲈ ⲀⲨⲠⲒⲐⲈ ⲈⲚⲈⲦϤϪⲰ ⲘⲘⲞⲞⲨ. ϨⲈⲚⲔⲞⲞⲨⲈ ⲆⲈ ⲀⲨⲢⲀⲦⲚⲀϨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ⲀⲨⲈⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚⲤⲈⲦⲎⲦ ⲀⲚ ⲚϨⲎⲦ ⲘⲚ ⲚⲈⲨⲈⲢⲎⲨ. ⲈⲀ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲚⲀⲨ ⲚⲞⲨϢⲀϪⲈ ⲚⲞⲨⲰⲦ. ϪⲈ ⲔⲀⲖⲰⲤ ⲀⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϢⲀϪⲈ ⲘⲚ ⲚⲈⲦⲚⲈⲒⲞⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲎⲤⲀⲒⲀⲤ ⲠⲈⲠⲢⲞⲪⲎⲦⲎⲤ ");
INSERT INTO copshc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲰⲔ ⲚⲚⲀϨⲢⲘ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲄϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ϨⲚ ⲞⲨⲤⲰⲦⲘ ⲦⲈⲦⲚⲀⲤⲰⲦⲘ ⲚⲦⲈⲦⲚ ⲦⲘⲚⲞⲒ. ⲀⲨⲰ ϨⲚ ⲞⲨⲚⲀⲨ ⲦⲈⲦⲚⲀⲚⲀⲨ ⲚⲦⲈⲦⲚ ⲦⲘⲈⲒⲰⲢϨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ⲀϤⲚϢⲞⲦ ⲄⲀⲢ ⲚϬⲒ ⲪⲎⲦ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲀⲨⲰ ⲀⲨϨⲢⲞϢ ⲈⲤⲰⲦⲘ ϨⲚ ⲚⲈⲨⲘⲀⲀϪⲈ. ⲀⲨⲰ ⲀⲨϢⲦⲀⲘ ⲚⲚⲈⲨⲂⲀⲖ. ⲘⲎⲠⲰⲤ ⲚⲤⲈⲚⲀⲨ ϨⲚ ⲚⲈⲨⲂⲀⲖ ⲚⲤⲈⲤⲰⲦⲘ ϨⲚ ⲚⲈⲨⲘⲀⲀϪⲈ ⲚⲤⲈⲚⲞⲒ ϨⲘ ⲠⲈⲨϨⲎⲦ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲦⲀⲦⲀⲖϬⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ⲘⲀⲢⲈϤⲞⲨⲰⲚϨ ϬⲈ ⲚⲎⲦⲚ ⲈⲂⲞⲖ ϪⲈ ⲚⲦⲀⲨⲦⲚⲚⲞⲞⲨ ⲘⲠⲈⲒⲞⲨⲆⲀⲒ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲚϨⲈⲐⲚⲞⲤ ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲚⲈⲦⲚⲀⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","— ");
INSERT INTO copshc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ⲀⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲢⲢⲘⲠⲈ ⲤⲚⲦⲈ ⲦⲎⲢⲞⲨ. ⲈϤⲞⲨⲎϨ ϨⲚ ⲞⲨⲘⲀ ⲈⲀϤⲘⲒⲤⲐⲞⲨ ⲘⲘⲞϤ. ⲀⲨⲰ ⲚⲈϤϢⲰⲠ ⲈϨⲞϤ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲂⲎⲔ ⲚⲀϤ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ⲈϤⲔⲎⲢⲨⲤⲤⲈ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲈϤϮⲤⲂⲰ ⲈⲦⲂⲈ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ϨⲘ ⲠⲀⲢⲢⲎⲤⲒⲀ ⲚⲒⲘ ⲀϪⲚ ϮⲤⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲠϨⲘϨⲀⲖ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦⲦⲀϨⲘ ⲠⲈⲚⲦⲀⲨⲠⲞⲢϪϤ ⲈⲂⲞⲖ ⲈⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ⲠⲀⲒ ⲈⲚⲦⲀϤϢⲢⲠⲈⲢⲎⲦ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲚ ⲚⲈⲄⲢⲀⲪⲎ ⲈⲦⲞⲨⲀⲀⲂ ");
INSERT INTO copshc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ⲈⲦⲂⲈ ⲠⲈϤϢⲎⲢⲈ ⲠⲀⲒ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲆⲀⲨⲈⲒⲆ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ⲠⲈⲚⲦⲀⲨⲦⲞϢϤ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲦϬⲞⲘ ⲔⲀⲦⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲦⲂⲂⲞ ⲈⲂⲞⲖ ϨⲘ ⲠⲦⲰⲞⲨⲚ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ⲠⲀⲒ ⲈⲚⲦⲀⲚϪⲒ ⲚⲞⲨⲬⲀⲢⲒⲤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ ⲘⲚ ⲞⲨⲘⲚ ⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲠⲤⲰⲦⲘ ⲚⲦⲠⲒⲤⲦⲒⲤ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ϨⲀ ⲠⲈϤⲢⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ⲈⲦⲈⲦⲚⲎⲠ ϨⲚ ⲚⲀⲒ ϨⲰⲦⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚⲦⲀϨⲘ ϨⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ⲚⲈⲦϨⲚ ϨⲢⲰⲘⲎ ⲦⲎⲢⲞⲨ ⲘⲘⲈⲢⲒⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲈⲦⲦⲀϨⲘ ⲈⲦⲞⲨⲀⲀⲂ. ⲦⲈⲬⲀⲢⲒⲤ ⲚⲎⲦⲚ ⲘⲚ ϮⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲈⲒⲰⲦ ⲘⲚ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ϢⲞⲢⲠ ⲘⲈⲚ ϮϢⲠϨⲘⲞⲦ ⲚⲦⲘⲠⲀⲚⲞⲨⲦⲈ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ⲦⲎⲢⲦⲚ ϪⲈ ⲤⲈϮⲤⲞⲈⲒⲦ ⲈⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ⲠⲀⲘⲚⲦⲢⲈ ⲄⲀⲢ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈϮϢⲘϢⲈ ⲚⲀϤ ϨⲘ ⲠⲀⲠⲚⲈⲨⲘⲀ ϨⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈϤϢⲎⲢⲈ ⲚⲐⲈ ⲀϪⲚⲰϪⲚ ⲈⲒⲈⲒⲢⲈ ⲘⲠⲈⲦⲚⲘⲈⲈⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲚ ⲚⲀϢⲖⲎⲖ ⲈⲒⲤⲞⲠⲤ ϪⲈ ⲈⲢⲈ ⲦⲀϨⲒⲎ ⲤⲞⲞⲨⲦⲚ ϨⲘ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ϮⲞⲨⲈϢⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲰⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲒⲈϮ ⲚⲎⲦⲚ ⲚⲞⲨϨⲘⲞⲦ ⲘⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲈⲠⲦⲀϪⲢⲈ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ⲠⲀⲒ ⲆⲈ ⲠⲈ ⲈⲦⲢⲈ ⲚⲤⲖⲤⲖ ⲚⲈⲚⲈⲢⲎⲨ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ϨⲒⲦⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲈⲦϨⲚ ⲚⲈⲚⲈⲢⲎⲨ ⲦⲰⲦⲚ ⲘⲚⲦⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ϮⲞⲨⲰϢ ⲄⲀⲢ ⲈⲦⲢⲈⲦⲚⲈⲒⲘⲈ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲀⲒⲔⲀⲀⲤ ϨⲀⲈⲒⲀⲦ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ ⲀⲨⲰ ⲀⲨⲔⲰⲖⲨ ⲘⲘⲞⲒ ϢⲀⲦⲈⲚⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲒⲈϪⲠⲞ ⲚⲞⲨⲔⲀⲢⲠⲞⲤ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲔⲀⲦⲀ ⲐⲈ ϨⲘ ⲠⲔⲈϢⲰϪⲠ ⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ⲚϨⲈⲖⲖⲎⲚ ⲘⲚ ⲚⲂⲀⲢⲂⲀⲢⲞⲤ ⲚⲤⲞⲪⲞⲤ ⲘⲚ ⲚⲀⲐⲎⲦ ⲈⲨⲚⲦⲀⲨ ⲈⲢⲞⲒ ");
INSERT INTO copshc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲞⲨⲢⲞⲦ ⲈⲦⲚⲘⲘⲀⲒ ⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲎⲦⲚ ⲚⲈⲦϨⲚ ϨⲢⲰⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ⲚϮϮϢⲒⲠⲈ ⲄⲀⲢ ⲀⲚ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ⲞⲨϬⲞⲘ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲈⲨⲞⲨϪⲀⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ϨⲚ ⲞⲨⲠⲒⲤⲦⲒⲤ ⲈⲨⲠⲒⲤⲦⲒⲤ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲈⲢⲈ ⲠⲆⲒⲔⲀⲒⲞⲤ ⲚⲀⲰⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ⲦⲞⲢⲄⲎ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀϬⲰⲖⲠ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲈϪⲘ ⲘⲚⲦϢⲀϤⲦⲈ ⲚⲒⲘ. ⲀⲨⲰ ⲠϪⲒ ⲚϬⲞⲚⲤ ⲚⲚⲢⲰⲘⲈ ⲚⲀⲒ ⲈⲦⲀⲘⲀϨⲦⲈ ⲚⲦⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨϪⲒ ⲚϬⲞⲚⲤ ");
INSERT INTO copshc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ϪⲈ ⲠⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ⲀⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲞⲨⲞⲚϨϤ ⲚⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ⲚⲈϤⲠⲈⲐⲎⲠ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲰⲚⲦ ⲘⲠⲔⲞⲤⲘⲞⲤ. ϨⲚ ⲚⲈϤⲦⲀⲘⲒⲞ ⲈⲨⲚⲞⲒ ⲘⲘⲞⲞⲨ ⲤⲈⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲈⲦⲈ ⲦⲈϤϬⲞⲘ ⲦⲈ ⲚϢⲀ ⲈⲚⲈϨ ⲘⲚ ⲦⲈϤⲘⲚⲦⲚⲞⲨⲦⲈ. ⲈⲦⲢⲈⲨϢⲰⲠⲈ ⲈⲘⲚⲦⲞⲨϢⲀϪⲈ ⲘⲘⲀⲨ ⲈϪⲰ. ");
INSERT INTO copshc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ϪⲈ ⲀⲨⲤⲞⲨⲚ ⲠⲚⲞⲨⲦⲈ ⲘⲠⲞⲨϮⲈⲞⲞⲨ ⲚⲀϤ ϨⲰⲤ ⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲘⲠⲞⲨϢⲠϨⲘⲞⲦ ⲀⲖⲖⲀ ⲀⲨⲢⲠⲈⲦϢⲞⲨⲈⲒⲦ ϨⲚ ⲚⲈⲨⲘⲈⲈⲨⲈ. ⲀⲨⲰ ⲀⲠⲈⲨϨⲎⲦ ⲚⲀⲦⲤⲂⲰ ⲢⲔⲀⲔⲈ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚ ϨⲈⲚⲤⲀⲂⲈ ⲀⲨⲢⲤⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ⲀⲨϢⲒⲂⲈ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀⲦⲦⲀⲔⲞ ϨⲚ ⲞⲨⲈⲒⲚⲈ ⲚϨⲒⲔⲰⲚ ⲚⲢⲰⲘⲈ ⲈϢⲀϤⲦⲀⲔⲞ ϨⲒ ϨⲀⲖⲎⲦ ϨⲒ ⲦⲂⲚⲎ. ϨⲒ ϪⲀⲦϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲠⲚⲞⲨⲦⲈ ⲦⲀⲀⲨ ϨⲚ ⲚⲞⲨⲰϢ ⲚⲚⲈⲨϨⲎⲦ ⲈⲨⲀⲔⲀⲐⲀⲢⲤⲒⲀ ⲈⲦⲢⲈⲨⲤⲰϢ ⲚⲚⲈⲨⲤⲰⲘⲀ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ⲚⲀⲒ ⲈⲚⲦⲀⲨϢⲒⲂⲈ ⲚⲦⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠϬⲞⲖ ⲀⲨⲞⲨⲰϢⲦ ⲀⲨⲰ ⲀⲨϢⲘϢⲈ ⲘⲠⲤⲰⲚⲦ ⲠⲀⲢⲀ ⲠⲈⲚⲦⲀϤⲤⲰⲚⲦ ⲠⲀⲒ ⲈⲦⲤⲘⲀⲘⲀⲀⲦ ϢⲀ ⲚⲒⲈⲚⲈϨ ϨⲀⲘⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲠⲚⲞⲨⲦⲈ ⲦⲀⲀⲨ ⲈϨⲢⲀⲒ ⲈϨⲈⲚⲠⲀⲐⲞⲤ ⲈⲨⲤⲎϢ. ⲈⲒⲦⲈ ⲄⲀⲢ ⲚⲈⲨϨⲒⲞⲘⲈ ⲀⲨϢⲒⲂⲈ ⲘⲠϨⲰⲂ ⲚⲦⲈⲨⲪⲨⲤⲒⲤ ⲈⲨⲠⲀⲢⲀ ⲦⲈⲨⲪⲨⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ϨⲞⲘⲞⲒⲰⲤ ⲚⲈⲨⲔⲈϨⲞⲞⲨⲦ ⲀⲨⲔⲰ ⲚⲤⲰⲞⲨ ⲘⲠϨⲰⲂ ⲚⲦⲈⲪⲨⲤⲒⲤ ⲚⲦⲈⲤϨⲒⲘⲈ ⲀⲨⲘⲞⲨϨ ⲘⲠⲈⲨⲘⲈ ⲈϨⲞⲨⲚ ⲈⲚⲈⲨⲈⲢⲎⲨ. ϨⲈⲚϨⲞⲞⲨⲦ ⲘⲚ ϨⲈⲚϨⲞⲞⲨⲦ ⲈⲨⲢϨⲰⲂ ⲈⲦⲀⲤⲬⲨⲘⲞⲤⲨⲚⲎ. ⲀⲨⲰ ⲦϢⲂⲈⲒⲰ ⲘⲠⲂⲈⲔⲈ ⲚⲦⲈⲨⲠⲖⲀⲚⲎ ⲈⲦⲈϢϢⲈ ⲈⲨϪⲈⲒ ⲘⲘⲞϤ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲈⲘⲠⲞⲨⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲔⲀⲀϤ ⲚⲀⲨ ϨⲚ ⲞⲨⲤⲞⲞⲨⲚ. ⲀⲠⲚⲞⲨⲦⲈ ⲦⲀⲀⲨ ⲈϨⲢⲀⲒ ⲈⲨϨⲎⲦ ⲚϪⲞⲞⲨⲦ ⲈⲈⲒⲢⲈ ⲚⲚⲈⲦⲈⲘⲈϢϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ⲈⲨϪⲎⲔ ⲈⲂⲞⲖ ⲚϪⲒ ⲚϬⲞⲚⲤ ⲚⲒⲘ ϨⲒ ⲔⲀⲔⲒⲀ ϨⲒ ⲠⲞⲚⲎⲢⲒⲀ ϨⲒ ⲘⲀⲒⲦⲞ ⲚϨⲞⲨⲞ ⲈⲨⲘⲈϨ ⲚⲖⲀ ϨⲒ ϨⲰⲦⲂ ϨⲒ ϮⲦⲰⲚ ϨⲒ ⲔⲢⲞϤ ⲚϨⲎⲦ ⲈϤϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ⲚⲢⲈϤⲔⲀⲤⲔⲤ ⲚⲢⲈϤⲔⲀⲦⲀⲖⲀⲖⲈⲒ ⲘⲘⲀⲤⲦ ⲚⲞⲨⲦⲈ ⲚⲢⲈϤⲤⲰϢ ⲚϪⲀⲤⲒϨⲎⲦ ⲚⲂⲀⲂⲈⲢⲰⲘ ⲚⲢⲈϤⲔⲰⲦⲈ ⲚⲤⲀ ⲠⲠⲈⲐⲞⲞⲨ ⲈⲚⲤⲈⲤⲰⲦⲘ ⲀⲚ ⲚⲤⲀ ⲚⲈⲨⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ⲚⲀⲐⲎⲦ ⲚⲀⲦⲚⲀϨⲦⲈ ⲚⲞⲨⲀϨⲒⲎⲦ ⲚⲀⲦⲚⲀ ");
INSERT INTO copshc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ⲚⲀⲒ ⲈⲦⲤⲞⲞⲨⲚ ⲘⲠⲆⲒⲔⲀⲒⲰⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲚⲈⲦⲈⲒⲢⲈ ⲚⲚⲀⲒ ⲤⲈⲘⲠϢⲀ ⲘⲠⲘⲞⲨ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲤⲈⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ⲀⲖⲖⲀ ⲤⲈⲤⲨⲚⲈⲨⲆⲞⲔⲒ ⲞⲚ ⲘⲚ ⲚⲈⲦⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ⲈⲦⲂⲈ ⲠⲀⲒ ⲘⲚⲦⲔϢⲀϪⲈ ⲘⲘⲀⲨ ⲈϪⲰ Ⲱ ⲠⲢⲰⲘⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲔⲔⲢⲒⲚⲈ ϨⲘ ⲠϨⲀⲠ ⲄⲀⲢ ⲈⲔⲔⲢⲒⲚⲈ ⲚⲔⲈⲞⲨⲀ ⲚϨⲎⲦϤ ⲔϬⲀⲒⲞ ⲘⲘⲞⲔ ⲞⲨⲀⲀⲔ ⲔⲈⲒⲢⲈ ⲄⲀⲢ ϨⲰⲰⲔ ⲘⲘⲞⲞⲨ ⲠⲈⲦⲔⲔⲢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ⲦⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲠϨⲀⲠ ⲘⲠⲚⲞⲨⲦⲈ ϢⲞⲞⲠ ⲘⲘⲈ ⲈϪⲚ ⲚⲈⲦⲈⲒⲢⲈ ⲚⲚⲀⲒ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ⲈⲔⲘⲈⲈⲨⲈ ⲆⲈ ⲈⲠⲀⲒ ⲰⲠⲢⲰⲘⲈ ⲠⲈⲦⲔⲔⲢⲒⲚⲈ ⲚⲚⲈⲦⲈⲒⲢⲈ ⲚⲦⲈⲈⲒϨⲈ. ⲀⲨⲰ ⲈⲔⲈⲒⲢⲈ ⲘⲘⲞⲞⲨ ϪⲈ ⲔⲚⲀⲢⲂⲞⲖ ⲚⲦⲞⲔ ⲈⲠϨⲀⲠ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ϪⲚ ⲘⲘⲞⲚ ⲈⲔⲔⲀⲦⲀⲪⲢⲞⲚⲒ ⲚⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲚⲦⲈϤⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ⲘⲚ ⲦⲈϤⲀⲚⲞⲬⲎ. ⲀⲨⲰ ⲦⲈϤⲘⲚⲦϨⲀⲢϢϨⲎⲦ. ⲈⲔⲞ ⲚⲀⲦⲤⲞⲞⲨⲚ ϪⲈ ⲈⲢⲈⲦⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲒⲚⲈ ⲘⲘⲞⲔ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ⲔⲀⲦⲀ ⲠⲈⲔⲚϢⲞⲦ ⲆⲈ ⲘⲚ ⲠⲈⲔϨⲎⲦ ⲈⲦⲈⲚϤⲘⲈⲦⲀⲚⲞⲒ ⲀⲚ ⲈⲔⲤⲰⲞⲨϨ ⲚⲀⲔ ⲈϨⲞⲨⲚ ⲚⲞⲨⲞⲢⲄⲎ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲚⲦⲞⲢⲄⲎ. ⲘⲚ ⲠϬⲰⲖⲠ ⲈⲂⲞⲖ ⲘⲠϨⲀⲠ ⲘⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ⲠⲀⲒ ⲈⲦⲚⲀⲦⲰⲰⲂⲈ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲔⲀⲦⲀ ⲚⲈϤϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ⲚⲈⲦϢⲞⲞⲠ ⲘⲈⲚ ⲔⲀⲦⲀ ⲐⲨⲠⲞⲘⲞⲚⲎ ⲘⲠϨⲰⲂ ⲈⲦⲚⲀⲚⲞⲨϤ ⲈⲦϢⲒⲚⲈ ⲚⲤⲀ ⲠⲈⲞⲞⲨ ⲘⲚ ⲠⲦⲀⲈⲒⲞ ⲘⲚⲦⲘⲚⲦⲀⲦⲦⲀⲔⲞ ⲚⲞⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ⲚⲈⲂⲞⲖ ⲆⲈ ϨⲚ ⲞⲨϮⲦⲰⲚ ⲈⲦⲞ ⲚⲀⲦⲤⲰⲦⲘ ⲚⲤⲀ ⲦⲘⲈ. ⲈⲦⲠⲒⲐⲈ ⲆⲈ ⲈⲠϪⲒ ⲚϬⲞⲚⲤ. ⲞⲨⲞⲢⲄⲎ ⲘⲚ ⲞⲨϬⲰⲚⲦ ");
INSERT INTO copshc_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ⲘⲚ ⲞⲨⲐⲖⲒⲮⲒⲤ ⲘⲚ ⲞⲨⲖⲰϪϨ ⲈϪⲚ ⲮⲨⲬⲎ ⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲈⲦⲢϨⲰⲂ ⲈⲠⲠⲈⲐⲞⲞⲨ. ⲦⲀ ⲠⲒⲞⲨⲆⲀⲒ ⲚϢⲞⲢⲠ ⲘⲚ ⲠⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ⲠⲈⲞⲞⲨ ⲆⲈ ⲘⲚ ⲠⲦⲀⲈⲒⲞ ⲘⲚ ϮⲢⲎⲚⲎ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲢϨⲰⲂ ⲈⲠⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲘⲠⲒⲞⲨⲆⲀⲒ ⲚϢⲞⲢⲠ ⲘⲚ ⲠⲞⲨⲈⲒⲈⲚⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ⲘⲚϪⲒϨⲞ ⲄⲀⲢ ϨⲀⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ⲚⲈⲚⲦⲀⲨⲢⲚⲞⲂⲈ ⲄⲀⲢ ⲀϪⲚ ⲚⲞⲘⲞⲤ ⲈⲨⲚⲀϨⲈ ⲞⲚ ⲈⲂⲞⲖ ⲀϪⲚ ⲚⲞⲘⲞⲤ. ⲀⲨⲰ ⲚⲈⲚⲦⲀⲨⲢⲚⲞⲂⲈ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲈⲨⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲞⲨ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ⲚⲈⲦⲤⲰⲦⲘ ⲄⲀⲢ ⲀⲚ ⲈⲠⲚⲞⲘⲞⲤ ⲚⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ⲀⲖⲖⲀ ⲚⲈⲦⲈⲒⲢⲈ ⲘⲠⲚⲞⲘⲞⲤ ⲚⲈⲦⲞⲨⲚⲀⲦⲘⲀⲈⲒⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ϨⲞⲦⲀⲚ ⲄⲀⲢ ⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲈⲘⲚⲦⲞⲨ ⲚⲞⲘⲞⲤ ⲪⲨⲤⲈⲒ ⲤⲈⲈⲒⲢⲈ ⲚⲚⲀ ⲠⲚⲞⲘⲞⲤ. ⲚⲀⲒ ⲈⲦⲈⲘⲚⲦⲞⲨ ⲚⲞⲘⲞⲤ ⲤⲈϢⲞⲞⲠ ⲚⲀⲨ ⲚⲚⲞⲘⲞⲤ ⲘⲀⲨⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ⲚⲀⲒ ⲈⲨⲦⲞⲨⲞ ⲘⲘⲞⲔ ⲈⲠϨⲰⲂ ⲘⲠⲚⲞⲘⲞⲤ ⲈϤⲤⲎϨ ϨⲘ ⲠⲈⲨϨⲎⲦ. ⲈⲢⲈ ⲦⲈⲨⲤⲨⲚⲒⲆⲎⲤⲒⲤ ⲢⲘⲚⲦⲢⲈ ⲚⲘⲘⲀⲨ ⲀⲨⲰ ⲚⲦⲘⲎⲦⲈ ⲚⲚⲈⲨⲘⲞⲔⲘⲈⲔ ϨⲒ ⲞⲨⲤⲞⲠ ⲈⲨⲄⲀⲦⲎⲄⲞⲢⲒ ⲎⲞⲚ ⲈⲨⲞⲨⲰϨⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ϨⲘ ⲠⲈϨⲞⲞⲨ ⲈⲦⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲔⲢⲒⲚⲈ ⲘⲚ ⲠⲈⲐⲎⲠ ⲚⲚⲢⲰⲘⲈ ⲔⲀⲦⲀ ⲠⲀⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ⲈϢϪⲈ ⲚⲦⲞⲔ ⲆⲈ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲔ ϪⲈ ⲠⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲔⲘⲦⲞⲚ ⲘⲘⲞⲔ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ⲀⲨⲰ ⲔⲤⲞⲞⲨⲚ ⲘⲠⲈϤⲞⲨⲰϢ. ⲔⲆⲞⲔⲒⲘⲀⲌⲈ ⲚⲚⲈⲦⲢⲚⲞϤⲢⲈ ⲈⲨⲦⲤⲀⲂⲞ ⲘⲘⲞⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ⲈⲔⲚⲀϨⲦⲈ ⲈⲢⲞⲔ ϪⲈ ⲈⲔⲞ ⲚϪⲀⲨⲘⲞⲈⲒⲦ ⲚⲚⲂⲖⲖⲈ ⲚⲞⲨⲞⲈⲒⲚ ⲚⲚⲈⲦϨⲘ ⲠⲔⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ⲚⲢⲈϤϮⲤⲂⲰ ⲚⲀⲐⲎⲦ ⲚⲤⲀϨ ⲚⲚϢⲎⲢⲈ ϢⲎⲘ ⲈⲨⲚⲦⲀⲔ ⲘⲘⲀⲨ ⲘⲠϨⲢⲂ ⲘⲠⲤⲞⲞⲨⲚ ⲚⲦⲘⲈ ϨⲘ ⲠⲚⲞⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ⲠⲈⲦϮⲤⲂⲰ ϬⲈ ⲚⲔⲈⲞⲨⲀ ⲈⲦⲂⲈ ⲞⲨ ⲚⲄϮⲤⲂⲰ ⲚⲀⲔ ⲀⲚ ⲠⲈⲦⲦⲀϢⲈⲞⲈⲒϢ ϪⲈ ⲘⲠⲢϪⲒ ⲞⲨⲈ ⲔϪⲒⲞⲨⲈ ");
INSERT INTO copshc_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲢⲢⲚⲞⲈⲒⲔ ⲔⲞ ⲚⲚⲞⲈⲒⲔ ⲠⲈⲦϤⲰⲦⲈ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲔϢⲰⲖ ⲚⲚⲈⲢⲠⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ⲈⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ϨⲘ ⲠⲚⲞⲘⲞⲤ. ϨⲒⲦⲘ ⲠⲦⲢⲈⲔⲠⲀⲢⲀⲂⲀ ⲘⲠⲚⲞⲘⲞⲤ ⲔⲤⲰϢ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ⲠⲢⲀⲚ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲨϪⲒⲞⲨⲀ ⲈⲢⲞϤ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ. ");
INSERT INTO copshc_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ⲠⲤⲂⲂⲈ ⲄⲀⲢ ⲢⲚⲞϤⲢⲈ ⲈⲔϢⲀⲚⲢ ⲠⲚⲞⲘⲞⲤ. ⲈϢⲰⲠⲈ ⲆⲈ ⲚⲦⲔ ⲞⲨⲠⲀⲢⲀⲂⲀⲦⲎⲤ ⲚⲦⲈ ⲠⲚⲞⲘⲞⲤ ⲀⲠⲈⲔⲤⲂⲂⲈ ϢⲰⲠⲈ ⲘⲘⲚⲦⲀⲦⲤⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ⲈϢⲰⲠⲈ ϬⲈ ⲈⲢϢⲀⲚⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ϨⲀⲢⲈϨ ⲈⲚⲆⲒⲔⲀⲒⲰⲘⲀ ⲘⲠⲚⲞⲘⲞⲤ. ⲈⲚⲤⲈⲚⲀⲈⲠ ⲦⲈϤⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲀⲚ ⲠⲈ ⲈⲨⲤⲂⲂⲈ ");
INSERT INTO copshc_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ⲚⲦⲈⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲦⲈⲂⲞⲖ ϨⲚ ⲦⲈⲪⲨⲤⲒⲤ ⲈⲀⲤϪⲈⲔ ⲠⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲚⲤⲔⲢⲒⲚⲈ ⲘⲘⲞⲔ ⲠⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲤϨⲀⲒ ⲘⲚ ⲠⲤⲂⲂⲈ ⲈⲦⲞ ⲘⲠⲀⲢⲀⲂⲀⲦⲎⲤ ⲘⲠⲚⲞⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ⲘⲠⲒⲞⲨⲆⲀⲒ ⲄⲀⲢ ⲈⲦⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲠⲈ ⲠⲒⲞⲨⲆⲀⲒ ⲞⲨⲆⲈ ⲘⲠⲤⲂⲂⲈ ⲀⲚ ⲈⲦⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲀⲢⲜ ⲠⲈ ⲠⲤⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ⲀⲖⲖⲀ ⲠⲒⲞⲨⲆⲀⲒ ⲈⲐⲎⲠ ⲠⲈ ⲠⲒⲞⲨⲆⲀⲒ ⲀⲨⲰ ⲠⲤⲂⲂⲈ ⲠⲈ ⲠⲤⲂⲂⲈ ⲘⲠϨⲎⲦ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ϨⲚ ⲞⲨⲤϨⲀⲒ ⲀⲚ. ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲈϤⲦⲀⲈⲒⲞ ϢⲞⲞⲠ ⲀⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲢⲰⲘⲈ. ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ⲞⲨ ϬⲈ ⲠⲈ ⲠⲈϨⲞⲨⲞ ⲘⲠⲒⲞⲨⲆⲀⲒ ⲎⲞⲨ ⲠⲈ ⲠϨⲎⲨ ⲘⲠⲤⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ⲚⲀϢⲰⲤ ⲔⲀⲦⲀⲤⲘⲞⲦ ⲚⲒⲘ ⲚϢⲞⲢⲠ ⲄⲀⲢ ⲚⲈⲚⲦⲀⲚϨⲞⲨⲦⲞⲨ ⲈⲚϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ⲈϢⲀⲢⲈ ⲞⲨ ⲄⲀⲢ ϢⲰⲠⲈ ⲈϢϪⲈ ⲀϨⲞⲒⲚⲈ ⲢⲀⲦⲚⲀϨⲦⲈ ⲘⲎ ⲈⲢⲈ ⲦⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ⲚⲀⲔⲀⲦⲀⲢⲄⲒ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ⲚⲚⲈⲤϢⲰⲠⲈ ⲘⲀⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ϢⲰⲠⲈ ⲘⲘⲈ ⲚⲦⲈ ⲢⲰⲘⲈ ⲚⲒⲘ ϢⲰⲠⲈ ⲚϬⲞⲖ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ϪⲈⲔⲀⲀⲤ ⲈⲔⲈⲦⲘⲀⲒⲞ ϨⲚ ⲚⲈⲔϢⲀϪⲈ ⲚⲄϪⲢⲞ ϨⲘ ⲠⲦⲢⲈⲔϮϨⲀⲠ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ⲈϢϪⲈ ⲠⲈⲚϪⲒ ⲚϬⲞⲚⲤ ⲆⲈ ⲠⲈⲦⲚⲀⲤⲨⲚϨⲒⲤⲦⲀ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ⲘⲎ ⲈⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲆⲒⲔⲞⲤ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲈⲒⲚⲈ ⲚⲦⲈϤⲞⲢⲄⲎ ⲈϪⲚ ⲚⲢⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ⲚⲚⲈⲤϢⲰⲠⲈ. ⲈⲘⲘⲞⲚ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲔⲢⲒⲚⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ⲈϢϪⲈ ⲚⲦⲀⲦⲘⲈ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲢϨⲞⲨⲞ ϨⲚ ⲦⲀϬⲞⲖ ⲈⲠⲈϤⲈⲞⲞⲨ. ⲀϨⲢⲞⲒ ϬⲈ ⲤⲈⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ϨⲰⲤ ⲢⲈϤⲢⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ⲀⲨⲰ ⲈⲚⲔⲀⲦⲀ ⲐⲈ ⲀⲚ ⲈⲦⲞⲨϪⲒⲞⲨⲀ ⲈⲢⲞⲚ ⲚⲐⲈ ⲈⲦⲈⲢⲈ ϨⲞⲒⲚⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲘⲀⲢⲚⲈⲒⲢⲈ ⲚⲘⲠⲈⲐⲞⲞⲨ ϪⲈ ⲈⲢⲈ ⲘⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲦⲀϨⲞⲚ ⲚⲀⲒ ⲈⲨⲘⲈ ⲠⲈ ⲠⲈⲨϨⲀⲠ. ");
INSERT INTO copshc_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ⲞⲨ ϬⲈ ⲠⲈ ⲈⲨⲞ ⲚϢⲞⲢⲠ ⲈⲢⲞⲚ ⲘⲘⲞⲚ. ϪⲒⲚ ⲚϢⲞⲢⲠ ⲄⲀⲢ ⲀⲚϬⲚⲀⲢⲒⲔⲈ ⲈⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚⲞⲨⲈⲒⲈⲚⲒⲚ ϪⲈ ⲤⲈϨⲀⲠ ⲚⲞⲂⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲘⲚ ⲆⲒⲔⲀⲒⲞⲤ ⲖⲀⲀⲨ ⲘⲚ ⲞⲨⲀ ");
INSERT INTO copshc_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ⲘⲚ ⲢⲘⲚϨⲎⲦ ⲘⲚ ⲠⲈⲦϢⲒⲚⲈ ⲚⲤⲀ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ⲀⲨⲢⲒⲔⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲀⲨⲢⲀⲦϢⲀⲨ ϨⲒⲞⲨⲤⲞⲠ. ⲘⲚ ⲠⲈⲦⲈⲒⲢⲈ ⲚⲞⲨⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ⲘⲚ ⲞⲨⲞⲚ ϢⲀϨⲢⲀⲒ ⲈⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ⲞⲨⲦⲀⲪⲞⲤ ⲈϤⲞⲨⲎⲚ ⲦⲈ ⲦⲈⲨϢⲞⲨⲰⲂⲈ ⲀⲨⲢⲔⲢⲞϤ ϨⲚ ⲚⲈⲨⲖⲀⲤ. ⲞⲨⲘⲀⲦⲞⲨ ⲚϨⲞϤ ⲦⲈⲦϨⲀⲚⲈⲨⲤⲠⲞⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ⲚⲀⲒ ⲈⲢⲈ ⲦⲈⲨⲦⲀⲠⲢⲞ ⲘⲈϨ ⲚⲤⲀϨⲞⲨ ϨⲒ ⲤⲒϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ⲚⲈⲨⲞⲨⲈⲢⲎⲦⲈ ϬⲈⲠⲎ ⲈⲠⲚⲤⲚⲞϤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ⲞⲨⲞⲨⲰϢϤ ⲘⲚ ⲞⲨⲦⲀⲖⲀⲒⲠⲰⲢⲒⲀ ⲚⲈⲦϢⲞⲞⲠ ϨⲚ ⲚⲈⲨϨⲒⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ⲦⲈϨⲒⲎ ⲚϮⲢⲎⲚⲎ ⲘⲠⲞⲨⲤⲞⲨⲰⲚⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ⲚⲐⲞ ⲦⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲘⲦⲞ ⲚⲚⲈⲨⲂⲀⲖ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ⲦⲚⲤⲞⲞⲨⲚ ⲆⲈ ϪⲈ ⲚⲈⲦⲈⲢⲈ ⲠⲚⲞⲘⲞⲤ ϪⲰ ⲘⲘⲞⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲞⲨ ⲚⲚⲈⲦϨⲘ ⲠⲚⲞⲘⲞⲤ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲦⲀⲠⲢⲞ ⲚⲒⲘ ⲦⲰⲘ. ⲚⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ϢⲰⲠⲈ ϨⲀⲠϨⲀⲠ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲖⲀⲀⲨ ⲚⲤⲀⲢⲜ ⲚⲀⲦⲘⲀⲈⲒⲞ ⲘⲠⲈϤⲘⲦⲞ ⲈⲂⲞⲖ. ⲚⲦⲀⲚⲤⲞⲨⲚ ⲠⲚⲞⲂⲈ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ⲦⲈⲚⲞⲨ ⲆⲈ ⲀϪⲘ ⲠⲚⲞⲘⲞⲤ ⲀⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲨⲢⲘⲚⲦⲢⲈ ϨⲀⲢⲞⲤ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲚ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈϨⲞⲨⲚ ⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ. ⲘⲚ ⲠⲰⲢϪ ⲄⲀⲢ ϢⲞⲞⲠ ");
INSERT INTO copshc_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ⲀⲨⲢⲚⲞⲂⲈ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲀⲨⲰ ⲤⲈϢⲀⲀⲦ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ⲈⲨⲦⲘⲀⲈⲒⲞ ⲘⲘⲞⲞⲨ ⲚϪⲒⲚϪⲎ ϨⲚ ⲦⲈϤⲬⲀⲢⲒⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲤⲰⲦⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ⲠⲀⲒ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲔⲀⲀϤ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲚⲔⲰ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲘⲠⲈϤⲤⲚⲞϤ. ⲈⲠⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈϤⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ⲈⲦⲂⲈ ⲠⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲚⲞⲂⲈ ⲈⲚⲦⲀⲚⲚⲀⲀⲨ ⲚϢⲞⲢⲠ ");
INSERT INTO copshc_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ϨⲚ ⲦⲀⲚⲞⲬⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲠⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈϤⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϨⲘ ⲠⲈⲈⲒⲞⲨⲞⲒϢ ⲦⲈⲚⲞⲨ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ ⲀⲨⲰ ⲈϤⲦⲘⲀⲈⲒⲞ ⲘⲠⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ⲈϤⲦⲰⲚ ϬⲈ ⲠϢⲞⲨϢⲞⲨ ⲀⲨϢⲦⲀⲘ ⲈⲢⲰϤ ϨⲒⲦⲚ ⲀϢ ⲚⲚⲞⲘⲞⲤ ⲠⲀ ⲚⲈϨⲂⲎⲨⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ⲦⲚϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲠⲢⲰⲘⲈ ⲚⲀⲦⲘⲀⲈⲒⲞ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲞⲨⲈϢ ⲚⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ⲎⲠⲚⲞⲨⲦⲈ ⲠⲀ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲀⲨⲀⲀⲨ ⲠⲈ ⲘⲠⲀ ⲚⲔⲈϨⲈⲐⲚⲞⲤ ⲚⲦⲞⲞⲨ ⲀⲚ ⲠⲈ ⲈϨⲈ ⲠⲀ ⲚⲔⲈϨⲈⲐⲚⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ⲈⲦⲂⲈ ϪⲈ ⲞⲨⲀ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈⲦⲚⲀⲦⲘⲀⲒ ⲈⲠⲤⲂⲂⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ⲀⲨⲰ ⲦⲘⲚⲦⲀⲄⲤⲂⲂⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ⲈⲚⲚⲀⲔⲀⲦⲀⲢⲄⲈⲒ ϬⲈ ⲘⲠⲚⲞⲘⲞⲤ ϨⲒⲦⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲚⲈⲤϢⲰⲠⲈ ⲀⲖⲖⲀ ⲈⲚⲚⲀⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ϪⲈ ⲀⲀⲂⲢⲀϨⲀⲘ ϨⲈ ⲈⲢⲞϤ ⲠⲈⲚⲈⲒⲰⲦ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ⲈϢϪⲈ ⲚⲦⲀⲨⲦⲘⲀⲒⲈ ⲀⲂⲢⲀϨⲀⲘ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϨⲂⲎⲨⲈ ⲞⲨⲚⲦϤ ⲞⲨϢⲞⲨϢⲞⲨ ⲘⲘⲀⲨ ⲀⲖⲖⲀ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ⲞⲨ ⲆⲈ ⲠⲈⲦⲈⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞϤ ϪⲈ ⲀⲀⲂⲢⲀϨⲀⲘ ⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲀⲨⲞⲠⲤ ⲈⲢⲞϤ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ⲠⲈⲦⲢϨⲰⲂ ⲆⲈ ⲈϢⲀⲨⲈⲠ ⲠⲈϤⲂⲈⲔⲈ ⲈⲢⲞϤ ⲀⲚ ⲔⲀⲦⲀ ⲞⲨϨⲘⲞⲦ ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲞⲨⲘⲠϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ⲠⲈⲦⲈⲚϤⲢϨⲰⲂ ⲆⲈ ⲀⲚ ⲀⲖⲖⲀ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲦⲦⲘⲀⲈⲒⲞ ⲘⲠⲀⲤⲈⲂⲎⲤ ϢⲀⲨⲈⲠ ⲦⲈϤⲠⲒⲤⲦⲒⲤ ⲈⲢⲞϤ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ⲔⲀⲦⲀ ⲐⲈ ⲞⲚ ⲈϢⲀⲢⲈ ⲆⲀⲨⲈⲒⲆ ϪⲰ ⲘⲠⲘⲀⲔⲀⲢⲒⲤⲘⲞⲤ ⲘⲠⲢⲰⲘⲈ ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲰⲠ ⲈⲢⲞϤ ⲚⲞⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲀϪⲚ ⲚⲈϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ϪⲈ ⲚⲀⲒⲀⲦⲞⲨ ⲚⲚⲈⲚⲦⲀⲨⲔⲰ ⲚⲀⲨ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲀⲚⲞⲘⲒⲀ ⲀⲨⲰ ⲚⲈⲚⲦⲀⲨϨⲰⲂⲤ ⲈⲂⲞⲖ ⲈϪⲚ ⲚⲈⲨⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ⲚⲀⲒⲀⲦϤ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲈ ⲘⲠϪⲞⲈⲒⲤ ⲚⲀⲈⲠ ⲚⲞⲂⲈ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ⲠⲈⲒⲘⲀⲔⲀⲢⲒⲤⲘⲞⲤ ϬⲈ ⲈϤϢⲞⲞⲠ ⲈϪⲘ ⲠⲤⲂⲂⲈ ϪⲚ ⲈϤϢⲞⲞⲠ ⲈϪⲚ ⲦⲔⲈⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲦⲚϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲀⲨⲈⲠ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲀⲂⲢⲀϨⲀⲘ ⲈⲢⲞϤ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ⲚⲦⲀⲨⲞⲠⲤ ϬⲈ ⲈⲢⲞϤ ⲚⲀϢ ⲚϨⲈ ⲚⲈϤϨⲘ ⲠⲤⲂⲂⲈ ⲠⲈ ϪⲚ ⲈϤϨⲚ ⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲚⲈϤϨⲘ ⲠⲤⲂⲂⲈ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲚⲈϤϨⲚⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ⲀⲨⲰ ⲀϤϪⲒ ⲚⲞⲨⲘⲀⲈⲒⲚ ⲚⲤⲂⲂⲈ ⲚⲤⲪⲢⲀⲄⲒⲤ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲈⲦϨⲚ ⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲈⲒⲰⲦ ⲚⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲦⲎⲢⲞⲨ ϨⲒⲦⲚ ⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ. ⲈⲦⲢⲈⲨⲞⲠⲤ ϨⲰⲞⲨ ⲞⲚ ⲈⲢⲞⲞⲨ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ⲀⲨⲰ ⲚⲈⲒⲰⲦ ⲘⲠⲤⲂⲂⲈ. ⲚⲚⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲤⲂⲂⲈ ⲘⲀⲨⲀⲀⲨ ⲀⲖⲖⲀ ⲚⲔⲞⲞⲨⲈ ⲈⲦⲀϨⲈ ⲈⲦⲈϨⲒⲎ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲈⲦϨⲚ ⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲘⲠⲈⲚⲈⲒⲰⲦ ⲀⲂⲢⲀϨⲀⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ⲞⲨⲈⲂⲞⲖ ⲄⲀⲢ ⲀⲚ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ ⲠⲈ ⲠⲈⲢⲎⲦ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚⲀⲂⲢⲀϨⲀⲘ. ⲎⲠⲈϤⲤⲠⲈⲢⲘⲀ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ⲈϢϪⲈ ⲈⲢⲈ ⲚⲈⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲄⲀⲢ ϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ. ⲈⲒⲈ ⲦⲠⲒⲤⲦⲒⲤ ϢⲞⲨⲈⲒⲦ. ⲀⲨⲰ ⲀⲠⲈⲢⲎⲦ ⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ⲈⲢⲈ ⲠⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲢϨⲰⲂ ⲈⲨⲞⲢⲄⲎ. ⲠⲘⲀ ⲆⲈ ⲈⲦⲈ ⲘⲚ ⲚⲞⲘⲞⲤ ⲚϨⲎⲦϤ. ⲞⲨⲆⲈ ⲘⲚⲠⲀⲢⲀⲂⲀⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ⲈⲦⲂⲈ ⲠⲀⲒ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲦⲈ ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲞⲨϨⲘⲞⲦ ⲈⲦⲢⲈ ⲠⲈⲢⲎⲦ ϢⲰⲠⲈ ⲈϤⲦⲀϪⲢⲎⲨ ⲘⲠⲈⲤⲠⲈⲢⲘⲀ ⲦⲎⲢϤ ⲘⲠⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲀⲦⲈ ⲀⲖⲖⲀ ⲘⲠⲔⲈⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲚⲀⲂⲢⲀϨⲀⲘ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠⲈⲚⲈⲒⲰⲦ ⲦⲎⲢⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀⲒⲔⲰ ⲘⲘⲞⲔ ⲚⲈⲒⲰⲦ ⲚϨⲀϨ ⲚϨⲈⲐⲚⲞⲤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲚⲦⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲠⲀⲒ ⲈⲦⲦⲀⲚϨⲞ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ ⲈⲦⲘⲞⲨⲦⲈ ⲈⲚⲈⲦⲈⲚⲤⲈϢⲞⲞⲠ ⲀⲚ ϨⲰⲤ ⲈⲨϢⲞⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ⲠⲀⲒ ⲠⲀⲢⲀ ⲞⲨϨⲈⲖⲠⲒⲤ ⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲨϨⲈⲖⲠⲒⲤ. ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚⲈⲒⲰⲦ ⲚϨⲀϨ ⲚϨⲈⲐⲚⲞⲤ ⲔⲀⲦⲀ ⲠⲈⲚⲦⲀⲨϪⲞⲞϤ. ϪⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠⲈⲔⲤⲠⲈⲢⲘⲀ ⲚⲀϢⲰⲠⲈ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ⲀⲨⲰ ⲘⲠϤϬⲂⲂⲈ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ⲀϤⲚⲀⲨ ⲈⲠⲈϤⲤⲰⲘⲀ ⲈⲀϤⲔⲀϬⲞⲘ ⲈⲠⲦⲎⲢϤ ⲈϤⲚⲀⲢⲀϢⲈ ⲚⲢⲞⲘⲠⲈ ⲘⲚⲠⲘⲞⲨ ⲚⲦⲞⲞⲦⲈ ⲚⲤⲀⲢⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ⲈⲠⲈⲢⲎⲦ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠϤⲢϨⲎⲦ ⲤⲚⲀⲨ ϨⲚ ⲞⲨⲘⲚⲦⲀⲠⲒⲤⲦⲞⲤ. ⲀⲖⲖⲀ ⲀϤϬⲘϬⲞⲘ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ⲈⲀϤϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ⲀⲨⲰ ⲀϤⲦⲰⲦ ⲚϨⲎⲦ ϪⲈ ⲠⲈⲚⲦⲀϤ ⲈⲢⲎⲦ ⲘⲘⲞϤ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲨⲞⲠⲤ ⲈⲢⲞϤ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ⲚⲦⲀⲨⲤⲀϨϤ ⲆⲈ ⲀⲚ ⲈⲦⲂⲎⲎⲦϤ ⲘⲀⲨⲀⲀϤ ϪⲈ ⲀⲨⲞⲠⲤ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ⲀⲖⲖⲀ ⲈⲦⲂⲎⲎⲦⲚ ϨⲰⲰⲚ ⲞⲚ ⲚⲀⲒ ⲈⲦⲞⲨⲚⲀⲞⲠⲤ ⲈⲢⲞⲞⲨ. ⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲚⲦⲀϤⲦⲞⲨⲚⲈⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϪⲞⲈⲒⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ⲠⲀⲒ ⲈⲚⲦⲀⲨⲦⲀⲀϤ ⲈⲦⲂⲈ ⲚⲈⲚⲚⲞⲂⲈ. ⲀⲨⲰ ⲀϤⲦⲰⲞⲨⲚ ⲈⲦⲂⲈ ⲠⲈⲚⲦⲘⲀⲈⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ⲈⲀⲚⲦⲘⲀⲈⲒⲞ ϬⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ⲞⲨⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲈⲒⲢⲎⲚⲎ ⲈϨⲞⲨⲚ ⲈⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲚ ⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ⲠⲀⲒ ⲈⲚⲦⲀⲚϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲘⲠϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲈⲒϨⲘⲞⲦ ⲈⲦⲚⲀϨⲈⲢⲀⲦⲚ ⲚϨⲎⲦϤ. ⲀⲨⲰ ⲈⲚϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ⲈϪⲚ ⲐⲈⲖⲠⲒⲤ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ. ⲀⲖⲖⲀ ⲈⲚⲢⲠⲔⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ϨⲚ ⲚⲈⲚⲐⲖⲒⲮⲒⲤ. ⲈⲚⲤⲞⲞⲨⲚ ϪⲈ ⲦⲈⲐⲖⲒⲮⲒⲤ ⲈⲤⲢϨⲰⲂ ⲈⲨϨⲨⲠⲞⲘⲞⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ⲐⲨⲠⲞⲘⲞⲚⲎ ⲆⲈ ⲈⲨⲆⲞⲔⲒⲘⲎ. ⲦⲆⲞⲔⲒⲘⲎ ⲆⲈ ⲈⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ⲐⲈⲖⲠⲒⲤ ⲆⲈ ⲘⲈⲤϪⲒϢⲒⲠⲈ. ϪⲈ ⲦⲀⲄⲀⲠⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲀϨⲦ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲚϨⲎⲦ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲠⲀⲒ ⲈⲚⲦⲀⲨⲦⲀⲀϤ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ⲈϢϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲈⲒ ⲈⲚⲞ ⲚϬⲰⲂ ⲔⲀⲦⲀ ⲠⲒⲞⲨⲞⲒϢ ⲀϤⲘⲞⲨ ϨⲀ ⲚⲀⲤⲈⲂⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ⲘⲞⲄⲒⲤ ⲄⲀⲢ ⲚⲦⲈ ⲞⲨⲀ ⲘⲞⲨ ϨⲀ ⲞⲨⲆⲒⲔⲀⲒⲞⲤ. ⲘⲈϢⲀⲔ ⲄⲀⲢ ⲚⲦⲈ ⲞⲨⲀ ⲦⲞⲖⲘⲀ ⲈⲘⲞⲨ ϨⲀ ⲞⲨⲀⲄⲀⲐⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲤⲨⲚϨⲒⲤⲦⲀ ⲚⲦⲈϤⲀⲄⲀⲠⲎ ⲈϨⲞⲨⲚ ⲈⲢⲞⲚ. ϪⲈ ⲈⲦⲒ ⲈⲚⲞ ⲚⲢⲈϤⲢⲚⲞⲂⲈ ⲀⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ϨⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ⲚⲀϢⲰⲤ ϬⲈ ⲚϨⲞⲨⲞ ⲈⲀⲚⲦⲘⲀⲈⲒⲞ ⲦⲈⲚⲞⲨ ϨⲘ ⲠⲈϤⲤⲚⲞϤ ⲦⲚⲚⲀⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲈⲦⲞⲢⲄⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ⲈϢϪⲈ ⲈⲚⲞ ⲚϪⲀϪⲈ ⲀⲚϨⲰⲦⲠ ⲈⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲘ ⲠⲘⲞⲨ ⲘⲠⲈϤϢⲎⲢⲈ. ⲚⲀϢⲰⲤ ⲚϨⲞⲨⲞ ⲈⲀⲚϨⲰⲦⲠ ⲦⲚⲚⲀⲞⲨϪⲀⲒ ϨⲘ ⲠⲈϤⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲈⲚⲢⲠⲔⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ϨⲘ ⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲘ ⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲒ ⲈⲚⲦⲀⲚϪⲒ ⲦⲈⲚⲞⲨ ⲘⲠϨⲰⲦⲠ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲂⲈ ⲈⲒ ⲈϨⲞⲨⲚ ⲈⲠⲔⲞⲤⲘⲞⲤ ϨⲒⲦⲚ ⲞⲨⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲂⲈ ⲠⲘⲞⲨ ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀ ⲠⲘⲞⲨ ⲈⲒ ⲈⲂⲞⲖ ⲈϪⲚ ⲢⲰⲘⲈ ⲚⲒⲘ ⲈⲀⲨⲢⲚⲞⲂⲈ ϨⲒⲰⲰϤ ⲦⲎⲢⲞⲨ ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲚⲦⲀⲠⲰⲚϨ ⲈⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ϢⲀ ⲠⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲚⲈⲢⲈ ⲠⲚⲞⲂⲈ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲠⲈ ⲈϤⲘⲞⲞⲨⲦ ⲠⲚⲞⲂⲈ ⲆⲈ ⲚⲈⲨⲰⲠ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ ⲈⲘⲚ ⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ⲀⲖⲖⲀ ⲀⲠⲘⲞⲨ ⲢⲢⲢⲞ ϪⲒⲚ ⲀⲆⲀⲘ ϢⲀ ⲘⲰⲨⲤⲎⲤ ⲈϪⲚ ⲚⲔⲞⲞⲨⲈ ⲈⲦⲈ ⲘⲠⲞⲨⲢⲚⲞⲂⲈ ϨⲘ ⲠⲈⲒⲚⲈ ⲚⲦⲠⲀⲢⲀⲂⲀⲤⲒⲤ ⲚⲀⲆⲀⲘ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠⲦⲨⲠⲞⲤ ⲘⲠⲈⲦⲚⲀϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ⲀⲖⲖⲀ ⲚⲐⲈ ⲀⲚ ⲘⲠⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲈϨⲘⲞⲦ. ⲈϢϪⲈ ϨⲢⲀⲒ ⲄⲀⲢ ϨⲘ ⲠⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲘⲠⲒⲞⲨⲀ ⲚⲞⲨⲰⲦ ⲀϨⲀϨ ⲘⲞⲨ. ⲚϨⲞⲨⲞ ϬⲈ ⲈⲘⲀⲦⲈ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲦⲆⲰⲢⲈⲀ ϨⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲒⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲤⲀϢⲀⲒ ⲈϨⲞⲨⲚ ⲈϨⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ⲀⲨⲰ ⲚⲐⲈ ⲀⲚ ϨⲒⲦⲘ ⲠⲒⲞⲨⲀ ⲚⲞⲨⲰⲦ ⲈⲚⲦⲀϤⲢⲚⲞⲂⲈ ⲠⲈ ⲠⲈⲦⲘⲀⲈⲒⲞ. ⲚⲦⲀⲠϨⲀⲠ ⲄⲀⲢ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲀ ⲈⲨⲦϬⲀⲈⲒⲞ. ⲠⲈⲬⲀⲢⲒⲤⲘⲀ ⲆⲈ ⲚⲦⲞϤ ⲈⲂⲞⲖ ϨⲚ ϨⲀϨ ⲚⲚⲞⲂⲈ ⲠⲈ ⲈⲨⲦⲘⲀⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ⲈϢϪⲈ ϨⲢⲀⲒ ⲄⲀⲢ ϨⲘ ⲠⲚⲞⲂⲈ ⲘⲠⲒⲞⲨⲀ ⲚⲞⲨⲰⲦ ⲀⲠⲘⲞⲨ ⲢⲢⲢⲞ ϨⲒⲦⲘ ⲠⲒⲞⲨⲀ. ⲚϨⲞⲨⲞ ϬⲈ ⲈⲘⲀⲦⲈ ⲚⲈⲦϪⲒ ⲘⲠⲈϨⲞⲨⲞ ⲚⲦⲈⲬⲀⲢⲒⲤ ⲘⲚ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲤⲈⲚⲀⲢⲢⲢⲞ ϨⲘ ⲠⲰⲚϨ ϨⲒⲦⲘ ⲠⲒⲞⲨⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ⲀⲢⲀ ϬⲈ ⲠⲠⲀⲢⲀⲠⲦⲰⲘⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲀ ⲠⲈ ⲈϨⲞⲨⲚ ⲈⲢⲰⲘⲈ ⲚⲒⲘ ⲈⲨⲦϬ ⲀⲈⲒⲞ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲘⲠⲈⲦⲘⲀⲒⲞ ⲈⲨⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲀ ⲠⲈ ⲈϨⲞⲨⲚ ⲈⲢⲰⲘⲈ ⲚⲒⲘ ⲈⲨⲦⲘⲀⲈⲒⲞ ⲚⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ⲚⲐⲈ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲘⲚⲦⲀⲦⲤⲰⲦⲘ ⲘⲠⲒⲢⲰⲘⲈ ⲚⲞⲨⲰⲦ ⲚⲦⲀ ϨⲀϨ ⲚⲢⲈϤⲢⲚⲞⲂⲈ ϢⲰⲠⲈ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ϨⲒⲦⲚ ⲦⲘⲚⲦⲤⲦⲘⲎⲦ ⲘⲠⲒⲞⲨⲀ ⲠⲈϨⲞⲨⲞ ⲚⲀϢⲰⲠⲈ ⲚⲆⲒⲔⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ⲚⲦⲀ ⲠⲚⲞⲘⲞⲤ ⲆⲈ ⲈⲒ ⲈϨⲞⲨⲚ ϪⲈ ⲈⲢⲈ ⲠⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲢϨⲞⲨⲞ ⲠⲈⲚⲦⲀ ⲠⲈϤⲚⲞⲂⲈ ⲀϢⲀⲒ ⲀⲠⲈϨⲘⲞⲦ ⲢϨⲞⲨⲈ ⲀϢⲀⲒ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲂⲈ ⲢⲢⲢⲞ ϨⲘ ⲠⲘⲞⲨ ⲈⲢⲈ ⲦⲈⲬⲀⲢⲒⲤ ⲞⲚ ⲢⲢⲢⲞ ⲚⲦⲈⲈⲒϨⲈ ϨⲒⲦⲚ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲈⲨⲰⲚϨ ϢⲀ ⲈⲚⲈϨ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ⲦⲀⲢⲚϬⲰ ϨⲘ ⲠⲚⲞⲂⲈ ϪⲈ ⲈⲢⲈ ⲦⲈⲬⲀⲢⲒⲤ ⲢϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ⲚⲚⲈⲤϢⲰⲠⲈ. ⲚⲀⲒ ⲈⲀⲚⲘⲞⲨ ⲘⲠⲚⲞⲂⲈ ⲚⲀϢ ⲚϨⲈ ⲈⲚⲚⲀϢⲰⲚϨ ϪⲒⲚ ⲘⲠⲈⲈⲒⲚⲀⲨ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ⲎⲈⲦⲈⲦⲚⲞ ⲚⲀⲦⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲀⲚⲂⲀⲠⲦⲒⲌⲈ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ⲚⲦⲀⲚⲂⲀⲠⲦⲒⲌⲈ ⲈⲠⲈϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ⲀⲨⲦⲞⲘⲤⲚ ϬⲈ ⲚⲘⲘⲀϤ ϨⲒⲦⲘ ⲠⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲠⲈϤⲘⲞⲨ. ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ϨⲒⲦⲘ ⲠⲈⲞⲞⲨ ⲘⲠⲈⲒⲰⲦ ⲚⲦⲚⲘⲞⲞϢⲈ ϨⲰⲰⲚ ⲚⲦⲈⲒϨⲈ ϨⲚ ⲞⲨⲘⲚⲦⲂⲢⲢⲈ ⲚⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ⲈϢϪⲈ ⲀⲚϢⲰⲠⲈ ⲄⲀⲢ ⲚϢⲂⲢⲦⲰϬⲈ ⲘⲠⲒ ⲚⲈ ⲘⲠⲈϤⲘⲞⲨ. ⲈⲒⲈ ⲦⲚⲚⲀϢⲰⲠⲈ ⲞⲚ ⲘⲠⲈϤⲔⲈⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ⲈⲚⲈⲒⲘⲈ ⲈⲠⲀⲒ ϪⲈ ⲀⲨⲈϢⲦ ⲠⲈⲚⲢⲘⲚⲀⲤ ⲚⲘⲘⲀϤ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲔⲀⲦⲀⲢⲄⲈⲒ ⲚϬⲒ ⲠⲤⲰⲘⲀ ⲘⲠⲚⲞⲂⲈ. ⲈⲦⲘⲦⲢⲈⲚⲢϨⲘϨⲀⲖ ϬⲈ ⲘⲠⲚⲞⲂⲈ ϪⲒⲚ ⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ⲠⲈⲚⲦⲀϤⲘⲞⲨ ⲄⲀⲢ ⲀϤⲦⲘⲀⲈⲒⲞ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ⲈϢϪⲈ ⲀⲚⲘⲞⲨ ⲆⲈ ⲘⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲞⲚ ϪⲈ ⲦⲚⲚⲀⲰⲚϨ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ⲈⲚⲤⲞⲞⲨⲚ ϪⲈ ⲀⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚϤⲚⲀⲤⲞⲦϤ ⲀⲚ ⲈⲘⲞⲨ. ⲘⲠⲘⲞⲨ ϬⲈ ⲞⲚϪⲞⲈⲒⲤ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ⲠⲘⲞⲨ ⲄⲀⲢ ⲈⲚⲦⲀϤⲘⲞⲨ ⲘⲘⲞϤ ⲚⲦⲀϤⲘⲞⲨ ⲘⲠⲚⲞⲂⲈ ⲚⲞⲨⲤⲞⲠ. ⲠⲰⲚϨ ⲆⲈ ⲈⲦϤⲞⲚϨ ⲘⲘⲞϤ ⲈϤⲞⲚϨ ϨⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ⲈⲠⲦⲎⲨⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲚⲦⲈⲈⲒϨⲈ ϪⲈ ⲦⲈⲦⲚⲘⲞⲞⲨⲦ ⲘⲈⲚ ⲘⲠⲚⲞⲂⲈ. ⲦⲈⲦⲚⲞⲚϨ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ⲘⲠⲢⲦⲢⲈ ⲠⲚⲞⲂⲈ ϬⲈ ⲢⲢⲢⲞ ϨⲘ ⲠⲈⲦⲚⲤⲰⲘⲀ ⲈⲦⲈϢⲀϤⲘⲞⲨ ⲈⲦⲢⲈⲦⲚⲤⲰⲦⲘ ⲚⲤⲀ ⲚⲈϤⲈⲠⲒⲐⲨⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ⲞⲨⲆⲈ ⲘⲠⲢⲠⲀⲢϨⲒⲤⲦⲀ ⲚⲚⲈⲦⲚⲘⲈⲖⲞⲤ ⲚϨⲞⲠⲖⲞⲚ ⲚϪⲒ ⲚϬⲞⲚⲤ ⲘⲠⲚⲞⲂⲈ. ⲀⲖⲖⲀ ⲠⲀⲢϨⲒⲤⲦⲀ ⲘⲘⲰⲦⲚ ⲘⲠⲚⲞⲨⲦⲈ ϨⲰⲤ ⲈⲦⲈⲦⲚⲞⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲀⲨⲰ ⲚⲈⲦⲚⲘⲈⲖⲞⲤ ⲚϨⲞⲠⲖⲞⲚ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ⲘⲠⲚⲞⲂⲈ ⲄⲀⲢ ⲚⲀⲢϪⲞⲈⲒⲤ ⲈⲢⲰⲦⲚ ⲀⲚ. ⲈⲦⲈⲦⲚϢⲞⲞⲠ ⲄⲀⲢ ⲀⲚ ϨⲀ ⲠⲚⲞⲘⲞⲤ. ⲀⲖⲖⲀ ϨⲀ ⲦⲈⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ⲀϨⲢⲞϤ ϬⲈ ⲦⲀⲢⲚⲢⲚⲞⲂⲈ. ϪⲈ ⲚⲦⲚϢⲞⲞⲠ ⲀⲚ ϨⲀ ⲠⲚⲞⲘⲞⲤ. ⲀⲖⲖⲀ ϨⲀ ⲦⲈⲬⲀⲢⲒⲤ ⲚⲚⲈⲤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲠⲈⲦⲈⲦⲚⲠⲀⲢϨⲒⲤⲦⲀ ⲘⲘⲰⲦⲚ ⲚⲀϤ ⲚϨⲘϨⲀⲖ ⲈⲤⲰⲦⲘ ⲚⲦⲈⲦⲚ ⲚϨⲘϨⲀⲖ ⲘⲠⲈⲦⲈⲦⲚⲤⲰⲦⲘ ⲚⲤⲰϤ ⲎⲘⲠⲚⲞⲂⲈ ⲎⲘⲠⲤⲰⲦⲘ ⲈⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ⲠⲈϨⲘⲞⲦ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ϪⲈ ⲚⲈⲦⲈⲦⲚⲞ ⲠⲈ ⲚϨⲘϨⲀⲖ ⲘⲠⲚⲞⲂⲈ. ⲀⲦⲈⲦⲚⲤⲰⲦⲘ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲚϨⲎⲦ ⲈⲠⲦⲨⲠⲞⲤ ⲚⲦⲈⲤⲂⲰ ⲈⲚⲦⲀⲨϮ ⲦⲎⲨⲦⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ⲈⲀⲦⲈⲦⲚⲢⲢⲘϨⲈ ⲆⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲂⲈ. ⲀⲦⲈⲦⲚⲢϨⲘϨⲀⲖ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ⲈⲒϪⲰ ⲘⲠⲀⲒ ⲔⲀⲦⲀ ⲢⲰⲘⲈ ⲈⲦⲂⲈ ⲦⲀⲤⲐⲈⲚⲒⲀ ⲚⲦⲈⲦⲚ ⲤⲀⲢⲜ. ⲚⲐⲈ ⲄⲀⲢ ⲈⲚⲦⲀⲦⲈⲦⲚⲠⲀⲢϨⲒⲤⲦⲀ ⲚⲚⲈⲦⲚⲘⲈⲖⲞⲤ ⲚϨⲘϨⲀⲖ ⲚⲦⲀⲔⲀⲐⲀⲢⲤⲒⲀ ⲘⲚ ⲦⲀⲚⲞⲘⲒⲀ ⲈϨⲞⲨⲚ ⲈⲦⲀⲚⲞⲘⲒⲀ. ⲠⲀⲢϨⲒⲤⲦⲀ ϨⲰⲰϤ ⲦⲈⲚⲞⲨ ⲚⲚⲈⲦⲚⲘⲈⲖⲞⲤ ⲚϨⲘϨⲀⲖ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲈⲨⲦⲂⲂⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ⲘⲠⲈⲨⲞⲈⲒϢ ⲄⲀⲢ ⲈⲦⲈⲦⲚⲞ ⲚϨⲘϨⲀⲖ ⲘⲠⲚⲞⲂⲈ ⲚⲈⲦⲈⲦⲚⲞ ⲚⲢⲘϨⲈ ⲠⲈ ϨⲚ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ⲀϢ ϬⲈ ⲠⲈ ⲠⲔⲀⲢⲠⲞⲤ ⲈⲚⲈ ⲞⲨⲚⲦⲎ ⲦⲚⲈϤ ⲘⲠⲒⲞⲨⲞⲈⲒϢ. ⲚⲀⲒ ⲈⲦⲈⲦⲚϪⲒϢⲒⲠⲈ ⲈϪⲰⲞⲨ ⲦⲈⲚⲞⲨ. ⲐⲀⲎ ⲄⲀⲢ ⲚⲚⲈⲦⲘⲘⲀⲨ ⲠⲈ ⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ⲦⲈⲚⲞⲨ ⲆⲈ ⲚⲦⲞϤ ⲈⲀⲦⲈⲦⲚⲢⲢⲘϨⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲂⲈ ⲀⲦⲈⲦⲚⲢϨⲘϨⲀⲖ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲘⲠⲈⲦⲚⲔⲀⲢⲠⲞⲤ ⲈⲨⲦⲂⲂⲞ ⲠϪⲰⲔ ⲆⲈ ⲠⲈ ⲠⲰⲚϨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ⲚⲞⲮⲰⲚⲒⲞⲚ ⲄⲀⲢ ⲘⲠⲚⲞⲂⲈ ⲠⲈ ⲠⲘⲞⲨ. ⲠⲈⲬⲀⲢⲒⲤⲘⲀ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲠⲰⲚϨ ⲚϢⲀ ⲈⲚⲈϨ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ⲎⲈⲦⲈⲦⲚⲞ ⲚⲀⲦⲤⲞⲞⲨⲚ ⲚⲈⲤⲚⲎⲨ ⲈⲒϢⲀϪⲈ ⲄⲀⲢ ⲘⲚ ⲚⲈⲦⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲘⲞⲤ. ϪⲈ ⲠⲚⲞⲘⲞⲤ ⲞⲚϪⲞⲈⲒⲤ ⲈⲠⲢⲰⲘⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲈϤⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ⲦⲈⲤϨⲒⲘⲈ ⲄⲀⲢ ⲈⲦϨⲘⲞⲞⲤ ⲘⲚϨⲀⲒ ⲤⲘⲎⲢ ⲈⲠⲈⲤϨⲀⲒ ⲈⲦⲞⲚϨ ϨⲘ ⲠⲚⲞⲘⲞⲤ. ⲈⲢϢⲀⲚ ⲠⲈⲤϨⲀⲒ ⲆⲈ ⲘⲞⲨ ⲀⲤⲞⲨⲰⲤϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲠϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ⲀⲢⲀ ϬⲈ ⲈⲢⲈ ⲠϨⲀⲒ ⲞⲚϨ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲚⲞⲈⲒⲔ ⲈⲤϢⲀⲚϨⲘⲞⲞⲤ ⲘⲚ ⲔⲈϨⲀⲒ. ⲈⲢϢⲀⲚ ⲠϨⲀⲒ ⲆⲈ ⲘⲞⲨ ⲞⲨⲢⲘϨⲎ ⲦⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲈⲦⲘⲦⲢⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲤ ϪⲈ ⲚⲞⲈⲒⲔ ⲈⲤϢⲀⲚϨⲘⲞⲞⲤ ⲘⲚ ⲔⲈϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲨ ⲀⲦⲈⲦⲚⲘⲞⲨ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲘⲠⲚⲞⲘⲞⲤ ϨⲒⲦⲘ ⲠⲤⲰⲘⲀ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲢⲈⲦⲚϢⲰⲠⲈ ⲚⲔⲈⲞⲨⲀ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ϪⲈ ⲈⲚⲈϮⲔⲀⲢⲠⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ⲚⲚⲈϨⲞⲞⲨ ⲄⲀⲢ ⲈⲚϨⲚ ⲦⲤⲀⲢⲜ ⲘⲠⲀⲐⲞⲤ ⲚⲚⲚⲞⲂⲈ ⲚⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ ⲚⲈⲨⲈⲚⲈⲢⲄⲈⲒ ⲠⲈ ϨⲚ ⲚⲈⲚⲘⲈⲖⲞⲤ ⲈⲦⲢⲈⲚϮⲔⲀⲢⲠⲞⲤ ⲘⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ⲦⲈⲚⲞⲨ ⲆⲈ ⲈⲀⲚⲘⲞⲨ ⲀⲚⲞⲨⲰⲤϤ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲠⲀⲒ ⲈⲚⲈⲨⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲚ ⲚϨⲎⲦϤ. ϨⲰⲤⲦⲈ ⲈⲦⲢⲈⲚⲢϨⲘϨⲀⲖ ⲚⲞⲨⲘⲚⲦⲂⲢⲢⲈ ⲘⲠⲚⲈⲨⲘⲀ ϨⲚ ⲞⲨⲘⲚⲦⲀⲤ ⲀⲚ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ⲠⲚⲞⲘⲞⲤ ⲠⲈ ⲠⲚⲞⲂⲈ ⲚⲚⲈⲤϢⲰⲠⲈ. ⲀⲖⲖⲀ ⲘⲠⲒⲤⲞⲨⲚ ⲠⲚⲞⲂⲈ ⲈⲒ ⲘⲎⲦⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲘⲞⲤ. ⲚⲈⲒⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲚⲦⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲤⲀⲂⲎⲖ ϪⲈ ⲀⲠⲚⲞⲘⲞⲤ ϪⲞⲞⲤ ϪⲈ ⲚⲚⲈⲔⲈⲠⲒⲐⲨⲘⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ⲀⲠⲚⲞⲂⲈ ⲆⲈ ϪⲒ ⲚⲞⲨⲀⲪⲞⲢⲘⲎ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲚⲦⲞⲖⲎ ⲀϤⲢϨⲰⲂ ϨⲢⲀⲒ ⲚϨⲎⲦ ⲈⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲒⲘ. ⲀϪⲘ ⲠⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲠⲚⲞⲂⲈ ⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ⲀⲚⲞⲔ ⲆⲈ ⲚⲈⲈⲒⲞⲚϨ ⲀϪⲚ ⲚⲞⲘⲞⲤ ⲚⲞⲨⲞⲨⲞⲈⲒϢ ⲠⲈ. ⲚⲦⲈⲢⲈⲤⲈⲒ ⲆⲈ ⲚϬⲒ ⲦⲈⲚⲦⲞⲖⲎ. ⲀⲠⲚⲞⲂⲈ ⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲘⲞⲨ. ⲀⲨϨⲈ ⲈϮⲈⲚⲦⲞⲖⲎ ⲈⲦϢⲞⲞⲠ ⲈⲨⲰⲚϨ ⲈⲨⲘⲞⲨ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ⲈⲀ ⲠⲚⲞⲂⲈ ⲄⲀⲢ ϪⲒ ⲚⲞⲨⲀⲪⲞⲢⲘⲎ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲚⲦⲈⲚⲦⲞⲖⲎ ⲀϤⲈⲜⲀⲠⲀⲦⲀ ⲘⲘⲞⲒ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲀϤⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ϨⲰⲤⲦⲈ ϬⲈ ⲠⲚⲞⲘⲞⲤ ⲞⲨⲀⲀⲂ ⲀⲨⲰ ⲦⲈⲚⲦⲞⲖⲎ ⲞⲨⲀⲀⲂ. ⲞⲨⲆⲒⲔⲀⲒⲞⲚ ⲦⲈ. ⲀⲨⲰ ⲞⲨⲀⲄⲀⲐⲞⲚ ⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ⲚⲦⲀ ⲠⲀⲄⲀⲐⲞⲚ ϬⲈ ϢⲰⲠⲈ ⲚⲀⲒ ⲈⲨⲘⲞⲨ ⲚⲚⲈⲤϢⲰⲠⲈ. ⲀⲖⲖⲀ ⲠⲚⲞⲂⲈ ⲠⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲚⲞⲂⲈ ⲠⲈ ϨⲒⲦⲘ ⲠⲀⲄⲀⲐⲞⲚ ⲈϤⲢϨⲰⲂ ⲚⲀⲒ ⲈⲠⲘⲞⲨ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲚⲞⲂⲈ ⲢϨⲞⲨⲈⲢⲈϤⲢⲚⲞⲂⲈ ϨⲒⲦⲚ ⲦⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ⲦⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲠⲚⲞⲘⲞⲤ ⲞⲨⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲤ ⲠⲈ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲄ ⲞⲨⲤⲀⲢⲔⲒⲔⲞⲤ ⲈⲒⲦⲞ ⲈⲂⲞⲖ ϨⲀ ⲠⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ⲠⲈϮⲈⲒⲢⲈ ⲄⲀⲢ ⲘⲘⲞϤ ⲚϮⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ⲘⲠⲈϮⲞⲨⲀϢϤ ⲄⲀⲢ ⲀⲚ ⲠⲀⲒ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲀⲖⲖⲀ ⲠⲈϮⲘⲞⲤⲦⲈ ⲘⲘⲞϤ ⲠⲀⲒ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ⲈϢϪⲈ ⲘⲠⲈϮⲞⲨⲀϢϤ ⲆⲈ ⲀⲚ ⲠⲀⲒ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ϮϪⲰ ⲘⲘⲞⲤ ⲈⲠⲚⲞⲘⲞⲤ ϪⲈ ⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ⲦⲈⲚⲞⲨ ⲆⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ϬⲈ ⲠⲈⲦⲢϨⲰⲂ ⲈⲢⲞϤ. ⲀⲖⲖⲀ ⲠⲚⲞⲂⲈ ⲠⲈ ⲈⲦⲞⲨⲎϨ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ϮⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲘⲚⲀⲄⲀⲐⲞⲚ ⲞⲨⲎϨ ⲚϨⲎⲦ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϨⲚ ⲦⲀⲤⲀⲢⲜ. ⲠⲞⲨⲰϢ ⲄⲀⲢ ϤⲔⲎ ⲚⲀⲒ ⲈϨⲢⲀⲒ. ⲠⲈⲢϨⲰⲂ ⲆⲈ ⲈⲠⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ⲘⲠⲀⲄⲀⲐⲞⲚ ⲄⲀⲢ ⲀⲚ ⲈϮⲞⲨⲀϢϤ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲀⲖⲖⲀ ⲠⲠⲈⲐⲞⲞⲨ ⲈⲦⲈ ⲚϮⲞⲨⲀϢϤ ⲀⲚ ⲠⲀⲒ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ⲈϢϪⲈ ⲘⲠⲈϮⲞⲨⲀϢϤ ⲀⲚ ⲠⲀⲒ ⲠⲈϮⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲈⲒⲈ ⲚⲀⲚⲞⲔ ⲀⲚ ϬⲈ ⲠⲈⲦⲈⲒⲢⲈ ⲘⲘⲞϤ. ⲀⲖⲖⲀ ⲠⲚⲞⲂⲈ ⲠⲈ ⲈⲦⲞⲨⲎϨ ϨⲢⲀⲒ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ϮϨⲎⲨ ⲚⲦⲞⲞⲨⲚ ⲈⲠⲚⲞⲘⲞⲤ ⲈⲚϤϢⲞⲞⲠ ⲚⲀⲒ ⲀⲚ. ⲠⲈⲦⲞⲨⲈϢⲢ ⲠⲈⲦⲚⲀⲚⲞⲨϤ ϪⲈ ⲠⲠⲈⲐⲞⲞⲨ ⲔⲎ ⲚⲀⲒ ⲈϨⲢⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ϮϨⲎⲆⲀⲚⲈ ⲄⲀⲢ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲔⲀⲦⲀ ⲠⲢⲰⲘⲈ ⲈⲦϨⲒ ϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ϮⲚⲀⲨ ⲆⲈ ⲈⲔⲈⲚⲞⲘⲞⲤ ϨⲚ ⲚⲀⲘⲈⲖⲞⲤ ⲈϤϮ ⲞⲨⲂⲈ ⲠⲚⲞⲘⲞⲤ ⲘⲠⲀϨⲎⲦ ⲀⲨⲰ ⲈϤⲀⲒⲬⲘⲀⲖⲰⲦⲒⲌⲈ ⲘⲘⲞⲒ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲂⲈ ⲠⲀⲒ ⲈⲦϢⲞⲞⲠ ϨⲚ ⲚⲀⲘⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ⲠⲦⲀⲖⲀⲒⲠⲰⲢⲞⲤ ⲀⲚⲞⲔ ⲠⲢⲰⲘⲈ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲚⲀϨⲘⲈⲦ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲰⲘⲀ ⲘⲠⲈⲒⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ⲠⲈϨⲘⲞⲦ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ⲀⲢⲀ ϬⲈ ⲀⲚⲞⲔ ϨⲢⲀⲒ ⲘⲈⲚ ϨⲘ ⲠⲀϨⲎⲦ ϮⲞ ⲚϨⲘϨⲀⲖ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ϨⲚ ⲦⲀⲤⲀⲢⲜ ⲆⲈ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ⲈⲒⲈ ⲘⲚⲖⲀⲀⲨ ⲦⲈⲚⲞⲨ ⲚⲦϬⲀⲈⲒⲞ ⲚⲚⲈⲦϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ⲀⲠⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲰⲚϨ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲀⲀⲦ ⲚⲢⲘϨⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲂⲈ ⲘⲚ ⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ⲦⲘⲚⲦⲀⲦϬⲞⲘ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲘⲞⲤ ⲈⲚⲈϤϬⲞⲞⲂ ⲚϨⲎⲦⲤ ϨⲒⲦⲚ ⲦⲤⲀⲢⲜ. ⲀⲠⲚⲞⲨⲦⲈ ⲦⲚⲚⲞⲞⲨ ⲘⲠⲈϤϢⲎⲢⲈ ϨⲚ ⲞⲨⲈⲒⲚⲈ ⲚⲤⲀⲢⲜ ⲚⲚⲞⲂⲈ. ⲀⲨⲰ ⲈⲦⲂⲈ ⲠⲚⲞⲂⲈ ⲀϤⲦϬⲀⲒⲈ ⲠⲚⲞⲂⲈ ϨⲚ ⲦⲈϤⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ϪⲈ ⲈⲢⲈ ⲠⲈⲦⲘⲀⲈⲒⲞ ⲘⲠⲚⲞⲘⲞⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲚϨⲎⲦⲚ. ⲚⲀⲒ ⲈⲦⲈ ⲚⲤⲈⲘⲞⲞϢⲈ ⲀⲚ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ⲚⲈⲦϢⲞⲞⲠ ⲄⲀⲢ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲈⲨⲘⲈⲈⲨⲈ ⲈⲚⲀ ⲦⲤⲀⲢⲜ. ⲚⲈⲦϢⲞⲞⲠ ⲆⲈ ⲔⲀⲦⲀ ⲠⲚⲈⲨⲘⲀ ⲈⲚⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ⲠⲘⲈⲈⲨⲈ ⲄⲀⲢ ⲚⲦⲤⲀⲢⲜ ⲠⲘⲞⲨ ⲠⲈ. ⲠⲘⲈⲈⲨⲈ ⲆⲈ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲠⲰⲚϨ ⲠⲈ ⲘⲚ ϮⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ϪⲈ ⲠⲘⲈⲈⲨⲈ ⲄⲀⲢ ⲚⲦⲤⲀⲢⲜ ⲞⲨⲘⲚⲦϪⲀϪⲈ ⲦⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲚⲤϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲄⲀⲢ ⲀⲚ ⲘⲠⲚⲞⲘⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ. ⲞⲨⲆⲈ ⲄⲀⲢ ⲘⲚϬⲞⲘ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ⲚⲈⲦϨⲚ ⲦⲤⲀⲢⲜ ⲆⲈ ⲚⲚⲈⲨⲈϢⲢⲀⲚⲀϤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲚⲈⲦⲈⲦⲚ ϨⲚ ⲦⲤⲀⲢⲜ ⲀⲚ ⲀⲖⲖⲀ ⲈⲦⲈⲦⲚϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈϢϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲈϢϪⲈ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ⲈⲘⲚⲦϤ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲒ ⲈⲘⲠⲰϤ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ⲈϢϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲈⲒⲈ ⲠⲤⲰⲘⲀ ⲘⲈⲚ ⲘⲞⲞⲨⲦ ⲈⲦⲂⲈ ⲠⲚⲞⲂⲈ. ⲠⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲠⲈ ⲠⲰⲚϨ ⲈⲦⲂⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ⲈϢϪⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲘⲠⲈⲚⲦⲀϤⲦⲞⲨⲚⲈⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲞⲨⲎϨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲠⲈⲚⲦⲀϤⲦⲞⲨⲚⲈⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲞⲨⲚⲈⲤ ⲚⲈⲦⲚⲔⲈⲤⲰⲘⲀ ⲈⲦⲈϢⲀⲨⲘⲞⲨ ϨⲒⲦⲘ ⲠⲈϤⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲎϨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ⲀⲢⲀ ϬⲈ ⲚⲀⲤⲚⲎⲨ ⲚⲤⲈⲢⲞⲚ ⲀⲚ ⲈⲦⲢⲈⲚⲰⲚϨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ⲈϢϪⲈ ⲈⲦⲈⲦⲚⲞⲚϨ ⲄⲀⲢ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲦⲈⲦⲚⲀⲘⲞⲨ. ⲈϢϪⲈ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲦⲈⲦⲚⲘⲞⲨⲞⲨⲦ ⲚⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲤⲰⲘⲀ ⲦⲈⲦⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ⲚⲈⲦⲘⲞⲞϢⲈ ⲄⲀⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲀⲒ ⲚⲈ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ⲚⲦⲀⲦⲈⲦⲚϪⲒ ⲄⲀⲢ ⲀⲚ ⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲘⲘⲚⲦϨⲘϨⲀⲖ ⲈⲨϨⲞⲦⲈ ⲞⲚ. ⲀⲖⲖⲀ ⲚⲦⲀⲦⲈⲦⲚϪⲒ ⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲘⲘⲚⲦϢⲎⲢⲈ ⲠⲀⲒ ⲈⲦⲚⲰϢ ⲈⲂⲞⲖ ⲚϨⲎⲦϤ ϪⲈ ⲀⲂⲂⲀ ⲠⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ⲚⲦⲞϤ ⲠⲈⲠⲚⲈⲨⲘⲀ ϤⲢⲘⲚⲦⲢⲈ ⲘⲚ ⲠⲈⲚⲠⲚⲈⲨⲘⲀ ϪⲈ ⲀⲚⲞⲚ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ⲈϢϪⲈ ⲀⲚⲞⲚ ⲚϢⲎⲢⲈ ⲈⲒⲈ ⲀⲚⲞⲚ ⲚⲈⲔⲖⲎ ⲢⲞⲚⲞⲘⲞⲤ ⲚⲈⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲘⲈⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲚϢⲂⲢⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲆⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈϢϪⲈ ⲦⲚϢⲠϨⲒⲤⲈ ⲚⲘⲘⲀϤ ϪⲈ ⲈⲚⲈϪⲒⲈⲞⲞⲨ ⲞⲚ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ϮⲘⲈⲈⲨⲈ ⲄⲀⲢ ϪⲈ ⲚϨⲒⲤⲈ ⲘⲠⲈⲒⲞⲨⲞⲈⲒϢ ⲦⲈⲚⲞⲨ ⲘⲠϢⲀ ⲀⲚ ⲘⲠⲈⲞⲞⲨ ⲈⲦⲚⲀϬⲰⲖⲠ ⲈⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ⲠϬⲰϢⲦ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚⲦⲈ ⲠⲤⲰⲚⲦ ϤϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦϤ ⲘⲠϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ⲚⲦⲀⲨⲐⲂⲂⲒⲈ ⲠⲤⲰⲚⲦ ⲄⲀⲢ ⲘⲠⲈⲦϢⲞⲨⲈⲒⲦ ⲈⲚϨⲚⲀϤ ⲀⲚ ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲠⲈⲚⲦⲀϤⲐⲂⲂⲒ ⲞϤ ⲈϪⲚ ⲞⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ϪⲈ ⲚⲦⲞϤ ϨⲰⲰϤ ⲠⲤⲰⲚⲦ ⲤⲈⲚⲀⲀⲀϤ ⲚⲢⲘϨⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲚⲦϨⲘϨⲀⲖ ⲘⲠⲦⲀⲔⲞ ⲈⲦⲘⲚⲦⲢⲘϨⲈ ⲘⲠⲈⲞⲞⲨ ⲚⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ⲦⲚⲤⲞⲞⲨⲚ ⲆⲈ ϪⲈ ⲠⲤⲰⲚⲦ ⲦⲎⲢϤ ⲀϢⲀϨⲞⲘ ⲚⲘⲘⲀⲚ. ⲀⲨⲰ ϤϮⲚⲀⲀⲔⲈ ϢⲀϨⲢⲀⲒ ⲈⲦⲈⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ⲚⲦⲞϤ ⲆⲈ ⲘⲀⲨⲀⲀϤ ⲀⲚ. ⲀⲖⲖⲀ ⲀⲚⲞⲚ ϨⲰⲰⲚ ⲈⲀⲚϪⲒ ⲚⲦⲀⲠⲀⲢⲬⲎ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲦⲚⲀϢⲀϨⲞⲘ ϨⲢⲀⲒ ⲚϨⲎⲦⲚ ⲈⲚϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦⲤ ⲚⲦⲈⲚⲘⲚⲦϢⲎⲢⲈ ⲠⲤⲰⲦⲈ ⲘⲠⲈⲚⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ⲚⲦⲀⲚⲞⲨϪⲀⲒ ⲄⲀⲢ ϨⲚ ⲐⲈⲖⲠⲒⲤ ⲞⲨϨⲈⲖⲠⲒⲤ ⲆⲈ ⲈⲨⲚⲀⲨ ⲈⲢⲞⲤ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲀⲚ ⲦⲈ. ⲠⲈⲦⲈⲢⲈ ⲞⲨⲀ ⲄⲀⲢ ⲚⲀⲨ ⲈⲢⲞϤ ⲀϨⲢⲞϤ ⲞⲚ ϤϨⲨⲠⲞⲘⲒⲚⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ⲈϢϪⲈ ⲠⲈⲦⲈⲚⲦⲚⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲀⲚ ⲈⲚϨⲈⲖⲠⲒⲌⲈ ⲈⲢⲞϤ ⲈⲒⲈ ⲈⲚϬⲰϢⲦ ⲈⲂⲞⲖ ϨⲎⲦϤ ϨⲒⲦⲚ ⲞⲨϨⲨⲠⲞⲘⲞⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ⲠⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲞⲚ ϮⲚⲦⲞⲞⲦⲚ ϨⲚ ⲦⲈⲚⲘⲚⲦϬⲰⲂ. ⲦⲀⲢⲚϢⲖⲎⲖ ⲄⲀⲢ ϪⲈ ⲞⲨ ⲔⲀⲦⲀⲐⲈ ⲈⲦϢⲈ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ. ⲀⲖⲖⲀ ⲚⲦⲞϤ ⲠⲈⲠⲚⲈⲨⲘⲀ ϤⲤⲘⲘⲈ ⲈϨⲢⲀⲒ ϨⲀⲢⲞⲚ ϨⲚ ϨⲈⲚⲀϢⲀϨⲞⲘ ⲈⲨϨⲎⲠ. ");
INSERT INTO copshc_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ⲠⲈⲦⲘⲞⲨϢⲦ ⲆⲈ ⲚⲚⲈⲚϨⲎⲦ ϤⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲘⲈⲈⲨⲈ ⲚⲦⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ϪⲈ ⲈϤⲤⲘⲘⲈ ⲈϨⲢⲀⲒ ⲔⲀⲦⲀ ⲠⲚⲞⲨⲦⲈ ϨⲀ ⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ⲦⲚⲤⲞⲞⲨⲚ ⲆⲈ ϪⲈ ⲚⲈⲦⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲀⲢⲈ ⲠⲚⲞⲨⲦⲈ ϮⲦⲞⲞⲦⲞⲨ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲈⲠⲀⲄⲀⲐⲞⲚ ⲚⲀⲒ ⲈⲦⲦⲀϨⲘ ⲔⲀⲦⲀ ⲠⲦⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ϪⲈ ⲚⲈⲚⲦⲀϤϢⲢⲠⲤⲞⲨⲰⲚⲞⲨ ⲀϤϢⲢⲠⲠⲞⲢϪⲞⲨ ⲈⲂⲞⲖ ⲚϢⲂⲢⲈⲒⲚⲈ ⲚⲐⲒⲔⲰⲚ ⲘⲠⲈϤϢⲎⲢⲈ ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲚϢⲢⲠ ⲘⲘⲒⲤⲈ ⲚϨⲀϨ ⲚⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ⲚⲈⲚⲦⲀϤϢⲢⲠ ⲠⲞⲢϪⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲀⲒ ⲞⲚ ⲚⲈⲚⲦⲀϤⲦⲀϨⲘⲞⲨ. ⲀⲨⲰ ⲚⲈⲚⲦⲀϤⲦⲀϨⲘⲞⲨ ⲚⲀⲒ ⲞⲚ ⲚⲈⲚⲦⲀϤⲦⲘⲀⲈⲒⲞⲞⲨ. ⲀⲨⲰ ⲚⲈⲚⲦⲀϤⲦⲘⲀⲈⲒⲞⲞⲨ ⲚⲀⲒ ⲞⲚ ⲚⲈⲚⲦⲀϤϮⲈⲞⲞⲨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ⲚⲚⲀϨⲢⲚ ⲚⲀⲒ. ⲈϢϪⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲘⲒϢⲈ ⲈϪⲰⲚ ⲚⲒⲘ ⲠⲈⲦⲚⲀϢϮ ⲞⲨⲂⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ⲠⲀⲒ ⲈⲦⲈⲘⲠϤϮⲤⲞ ⲈⲠⲈϤϢⲎⲢⲈ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ⲀⲖⲖⲀ ⲀϤⲦⲀⲀϤ ϨⲀⲢⲞⲚ ⲦⲎⲢⲚ. ⲚⲀϢ ⲚⲦⲞϤ ⲚϨⲈ ⲚϤⲚⲀⲬⲀⲢⲒⲌⲈ ⲚⲀⲚ ⲀⲚ ⲚⲚⲔⲀ ⲚⲒⲘ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ⲚⲒⲘ ⲠⲈⲦⲚⲀϢⲤⲘⲘⲈ ⲞⲨϤⲈ ⲚⲤⲰⲦⲠ ⲘⲠⲚⲞⲨⲦⲈ. ⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲦⲘⲀⲈⲒⲞ ");
INSERT INTO copshc_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ⲚⲒⲘ ⲠⲈⲦⲚⲀϢⲦϬⲀⲒⲞ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚⲦⲀϤⲘⲞⲨ. ⲚϨⲞⲨⲞ ⲆⲈ ⲠⲈⲚⲦⲀϤⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲠⲀⲒ ⲞⲚ ⲈⲦϨⲒⲞⲨⲚⲀⲘ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲈⲦⲤⲘⲘⲈ ⲈϨⲢⲀⲒ ϨⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ⲚⲒⲘ ⲠⲈⲦⲚⲀⲠⲞⲢϪⲚ ⲈⲦⲀⲄⲀⲠⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲐⲖⲒⲮⲒⲤ ⲦⲈ ⲎⲞⲨⲖⲰϪϨ ⲠⲈ ⲎⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲎⲞⲨϨⲔⲞ ⲎⲞⲨⲔⲰⲔⲀϨⲎⲨ ⲎⲞⲨⲔⲒⲚⲆⲨⲚⲞⲤ ⲎⲞⲨⲤⲎϤⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲈⲦⲂⲎⲎⲦⲔ ⲤⲈⲘⲞⲨⲞⲨⲦ ⲘⲘⲞⲚ ⲘⲠⲈϨⲞⲞⲨ ⲦⲎⲢϤ. ⲀⲨⲞⲠⲚ ⲚⲐⲈ ⲚⲚⲒⲈⲤⲞⲞⲨ ⲈⲔⲞⲚⲤⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ⲀⲖⲖⲀ ϨⲚ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲦⲚϪⲢⲀⲈⲒⲦ ⲚϨⲞⲨⲞ ϨⲒⲦⲘ ⲠⲈⲚⲦⲀϤⲘⲈⲢⲒⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ϮⲠⲒⲐⲈ ⲄⲀⲢ ϪⲈ ⲞⲨⲆⲈ ⲘⲚⲘⲞⲨ ⲞⲨⲆⲈ ⲘⲚⲰⲚϨ ⲞⲨⲆⲈ ⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲆⲈ ⲀⲢⲬⲎ ⲞⲨⲆⲈ ⲚⲈⲦϢⲞⲞⲠ ⲞⲨⲆⲈ ⲚⲈⲦⲚⲀϢⲰⲠⲈ ⲞⲨⲆⲈ ϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ⲞⲨⲆⲈ ⲠϪⲒⲤⲈ ⲞⲨⲆⲈ ⲠϢⲒⲔⲈ ⲞⲨⲆⲈ ⲔⲈⲔⲦⲒⲤⲒⲤ ⲚⲀϢϬⲘϬⲞⲘ ⲈⲠⲞⲢϪⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲀⲄⲀⲠⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀⲒ ⲈⲦϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ⲞⲨⲘⲈ ⲦⲈϮϪⲰ ⲘⲘⲞⲤ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚϮϪⲒϬⲞⲖ ⲀⲚ. ⲈⲤⲢⲘⲚⲦⲢⲈ ⲚⲘⲘⲀⲒ ⲚϬⲒ ⲦⲀⲤⲨⲚⲒⲆⲎⲤⲒⲤ ϨⲘ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ϪⲈ ⲞⲨⲚ ⲞⲨⲚⲞϬ ⲚⲖⲨⲠⲎ ⲚⲘⲘⲀⲒ ⲘⲚ ⲞⲨⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲀⲦⲰϪⲚ ϨⲘ ⲠⲀϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ⲚⲈⲒϢⲖⲎⲖ ⲄⲀⲢ ⲀⲚⲞⲔ ⲠⲈ ⲈⲦⲢⲀϢⲰⲠⲈ ⲚⲦⲤⲦⲈⲂⲞⲖ ⲚⲦⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ϨⲀ ⲚⲀⲤⲚⲎⲨ ⲚⲀⲤⲨⲄⲄⲈⲚⲎⲤ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ");
INSERT INTO copshc_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ⲈⲦⲈ ⲚⲀⲒ ⲚⲈ ⲚⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲚⲀⲒ ⲈⲦⲈⲦⲰⲞⲨ ⲦⲈ ⲦⲘⲚⲦϢⲎⲢⲈ ⲘⲚ ⲠⲈⲞⲞⲨ ⲘⲚ ⲦⲆⲒⲀⲐⲎⲔⲎ ⲘⲚ ⲦⲚⲞⲘⲞⲐⲈⲤⲒⲀ ⲘⲚ ⲠϢⲘϢⲈ ⲀⲨⲰ ⲚⲈⲢⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ⲚⲀⲒ ⲈⲦⲈⲚⲞⲨⲞⲨ ⲚⲈ ⲚⲈⲒⲞⲦⲈ. ⲀⲨⲰ ⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲠⲚⲞⲨⲦⲈ ⲈⲦϨⲒϪⲚ ⲞⲨⲞⲚ ⲚⲒⲘ. ⲠⲈⲦⲤⲘⲀⲘⲀⲀⲦ ϢⲀ ⲚⲒⲈⲚⲈϨ ϨⲀⲘⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ⲞⲨⲬ ⲞⲒⲞⲚ ⲆⲈ ϪⲈ ⲚⲦⲀϤϨⲈ ⲚϬⲒ ⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲀⲚ ⲈⲚⲦⲀⲨⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ ⲚⲀⲒ ⲚⲈ ⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ⲞⲨⲆⲈ ϪⲈ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀϨⲀⲘ ⲚⲈ ϨⲈⲚϢⲎⲢⲈ ⲦⲎⲢⲞⲨ ⲚⲈ. ⲀⲖⲖⲀ ϨⲚ ⲒⲤⲀⲀⲔ ⲈⲨⲚⲀⲘⲞⲨⲦⲈ ⲚⲀⲔ ⲈⲨⲤⲠⲈⲢⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ϪⲈ ⲚϢⲎⲢⲈ ⲀⲚ ⲚⲦⲤⲀⲢⲜ ⲚⲀⲒ ⲚⲈ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲖⲖⲀ ⲚϢⲎⲢⲈ ⲘⲠⲈⲢⲎⲦ ⲚⲈⲦⲞⲨⲚⲀⲞⲠⲞⲨ ⲈⲠⲈⲤⲠⲈⲢⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ⲠⲈⲒϢⲀϪⲈ ⲄⲀⲢ ⲠⲀ ⲠⲈⲢⲎⲦ ⲠⲈ ϪⲈ ϮⲚⲎⲨ ⲔⲀⲦⲀ ⲠⲒⲞⲨⲞⲈⲒϢ ⲚⲦⲈ ⲞⲨϢⲎⲢⲈ ϢⲰⲠⲈ ⲚⲤⲀⲢⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲦⲔⲈϨⲢⲈⲂⲈⲔⲔⲀ. ⲈⲀⲤϪⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀ ⲚⲚⲔⲞⲦⲔ ⲚⲞⲨⲀ ⲠⲈⲚⲈⲒⲰⲦ ⲒⲤⲀⲀⲔ. ");
INSERT INTO copshc_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ⲈⲘⲠⲀⲦⲞⲨϪⲠⲞⲞⲨ ⲞⲨⲆⲈ ⲘⲠⲀⲦⲞⲨⲢϨⲰⲂ ⲚⲀⲄⲀⲐⲞⲚ ⲎⲘⲠⲈⲐⲞⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲦⲰϢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲔⲀⲦⲀ ⲞⲨⲘⲚⲦⲤⲰⲦⲠ ⲘⲞⲨⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ⲈⲂⲞⲖ ϨⲚ ⲚⲈϨⲂⲎⲨⲈ ⲀⲚ. ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲦⲰϨⲘ. ⲀⲨϪⲞⲞⲤ ⲚⲀⲤ ϪⲈ ⲠⲚⲞϬ ⲚⲀⲢϨⲘϨⲀⲖ ⲘⲠⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲒⲀⲔⲰⲂ ⲀⲒⲘⲈⲢⲒⲦϤ. ⲎⲤⲀⲨ ⲆⲈ ⲀⲒⲘⲈⲤⲦⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲚⲀϪⲞⲞϤ ⲘⲎ ⲞⲨⲚϪⲒ ⲚϬⲞⲚⲤ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲚⲈⲤϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ϢⲀϤϪⲞⲞⲤ ⲄⲀⲢ ⲘⲘⲰⲨⲤⲎⲤ ϪⲈ ϮⲚⲀⲚⲀ ⲘⲠⲈ ϮⲚⲀⲚⲀ ⲚⲀϤ. ⲦⲀϢⲚϨⲦⲎⲒ ϨⲀ ⲠⲈϮⲚⲀϢⲚϨⲦⲎⲒ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ⲀⲢⲀ ϬⲈ ⲘⲠⲀ ⲠⲈⲦⲞⲨⲰϢ ⲀⲚ ⲠⲈ. ⲞⲨⲆⲈ ⲘⲠⲀ ⲠⲈⲦⲠⲎⲦ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲠⲀ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲚⲀ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ϢⲀⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ⲄⲀⲢ ϪⲞⲞⲤ ⲘⲪⲀⲢⲀⲰ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒⲦⲞⲨⲚⲞⲤⲔ ϪⲈ ⲈⲒⲈⲞⲨⲈⲚϨ ⲦⲀϬⲞⲘ ⲈⲂⲞⲖ ⲚϨⲎⲦⲔ. ⲀⲨⲰ ϪⲈ ⲈⲨⲈϪⲰ ⲘⲠⲀⲢⲀⲚ ϨⲘ ⲠⲔⲀϨ ⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ⲀⲢⲀ ϬⲈ ⲠⲈⲦϤⲞⲨⲀϢϤ ⲠⲈϢⲀϤⲚⲀ ⲚⲀϤ. ⲀⲨⲰ ⲠⲈⲦϤⲞⲨⲀϢϤ ϢⲀϤϮⲚϢⲞⲦ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ⲔⲚⲀϪⲞⲞⲤ ϬⲈ ⲚⲀⲒ ϪⲈ ⲀϨⲢⲞϤ ϤϬⲚⲀⲢⲒⲔⲈ. ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲚⲦⲀϤⲀϨⲈⲢⲀⲦϤ ⲞⲨⲂⲈ ⲠⲈϤⲞⲨⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ⲰⲠⲢⲰⲘⲈ ⲚⲦⲔ ⲚⲒⲘ ϨⲰⲰϤ ⲈⲞⲨⲰϢⲂ ⲞⲨⲂⲈ ⲠⲚⲞⲨⲦⲈ ⲘⲎ ⲠⲈⲠⲖⲀⲤⲘⲀ ⲚⲀϪⲞⲞⲤ ⲘⲠⲈⲚⲦⲀϤⲠⲖⲀⲤⲤⲈ ⲘⲘⲞϤ ϪⲈ ⲀϨⲢⲞⲔ ⲀⲔⲦⲀⲘⲒⲞⲒ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ⲎⲘⲚⲦⲈ ⲠⲔⲈⲢⲀⲘⲈⲨⲤ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲦⲀⲘⲒⲞ ⲈⲂⲞⲖ ϨⲘ ⲠⲒⲞⲘⲈ ⲚⲞⲨⲰⲦ ⲚⲞⲨϨⲚⲀⲀⲨ ⲈⲨⲦⲀⲈⲒⲞ. ⲔⲈⲞⲨⲀ ⲆⲈ ⲈⲨⲤⲰϢ. ");
INSERT INTO copshc_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ⲈϢϪⲈ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈϤⲞⲢⲄⲎ. ⲀⲨⲰ ⲈⲦⲀⲘⲞⲚ ⲈⲦⲈϤϬⲞⲘ. ⲀϤⲈⲒⲚⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲘⲘⲚⲦϨⲀⲢϢϨⲎⲦ ⲚϨⲈⲚⲤⲔⲈⲨⲎ ⲚⲞⲢⲄⲎ ⲈⲨⲤⲂⲦⲰⲦ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ϪⲈ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲘⲠⲈϤⲈⲞⲞⲨ ⲈϪⲚ ϨⲈⲚⲤⲔⲈⲨⲎ ⲚⲚⲀ. ⲚⲀⲒ ⲈⲚⲦⲀϤⲤⲂⲦⲰⲦⲞⲨ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲈⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ⲚⲀⲒ ⲞⲚ ⲈⲚⲦⲀϤⲦⲀϨⲘⲞⲨ ⲀⲚⲞⲚ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲒⲞⲨⲆⲀⲒ. ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲚ ⲚⲔⲈϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ⲚⲐⲈ ⲞⲚ ⲈϢⲀϤϪⲞⲞⲤ ⲚⲰⲤⲎⲈ ϪⲈ ϮⲚⲀⲘⲞⲨⲦⲈ ⲈⲠⲈⲦⲈⲘⲠⲀⲖⲀⲞⲤ ⲀⲚ ⲠⲈ ϪⲈ ⲠⲀⲖⲀⲞⲤ. ⲀⲨⲰ ⲦⲀⲘⲈⲢⲒⲦ ⲀⲚ ϪⲈ ⲦⲀⲘⲈⲢⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ⲚⲤϢⲰⲠⲈ ϨⲘ ⲠⲘⲀ ⲈⲚⲦⲀⲨϪⲞⲞⲤ ⲚⲀⲨ ϪⲈ ⲚⲦⲈⲦⲚ ⲠⲀⲖⲀⲞⲤ ⲀⲚ ⲤⲈⲚⲀⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ⲘⲘⲀⲨ ϪⲈ ⲚϢⲎⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ⲎⲤⲀⲒⲀⲤ ⲆⲈ ϪⲒϢⲔⲀⲔ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲤⲢⲀⲎⲖ. ϪⲈ ⲈⲢϢⲀⲚⲦⲎⲠⲈ ⲚⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲢⲐⲈ ⲘⲠϢⲰ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲞⲨϢⲰϪⲠ ⲠⲈⲦⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ⲞⲨϢⲀϪⲈ ⲄⲀⲢ ⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲀⲨⲰ ⲈϤϢⲰⲰⲦ ⲠⲈⲦⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲀⲀϤ ϨⲒϪⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ⲔⲀⲦⲀ ⲐⲈ ⲞⲚ ⲈⲚⲦⲀ ⲎⲤⲀⲒⲀⲤ ϪⲞⲞⲤ ϪⲈ ⲚⲤⲀⲂⲎⲖ ϪⲈ ⲀⲠϪⲞⲈⲒⲤ ⲤⲀⲂⲀⲰⲐ ϢⲰϪⲠ ⲚⲀⲚ ⲚⲞⲨⲤⲠⲈⲢⲘⲀ. ⲚⲈⲚⲚⲀϢⲰⲠⲈ ⲠⲈ ⲚⲐⲈ ⲚⲤⲞⲆⲞⲘⲀ. ⲚⲦⲚⲈⲒⲚⲈ ⲚⲄⲞⲘⲞⲢⲢⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ⲈⲚⲚⲀϪⲞⲞⲤ ϬⲈ ϪⲈ ⲞⲨ ϪⲈ ⲚϨⲈⲐⲚⲞⲤ ⲈⲦⲈⲚⲤⲈⲠⲎⲦ ⲀⲚ ⲚⲤⲀ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲀⲨⲦⲀϨⲈⲦ ⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲆⲈ ⲦⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ⲠⲒⲤⲢⲀⲎⲖ ⲆⲈ ⲈϤⲠⲎⲦ ⲚⲤⲀ ⲠⲚⲞⲘⲞⲤ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠϤⲦⲀϨⲈ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ⲈⲦⲂⲈ ⲞⲨ ϪⲈ ⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲀⲚ. ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈϨⲂⲎⲞⲨⲈ. ⲀⲨⲰ ⲀⲨϪⲰⲢⲠ ⲈⲠⲰⲚⲈ ⲚϪⲢⲞⲠ ");
INSERT INTO copshc_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮⲚⲀⲔⲰ ϨⲚ ⲤⲒⲰⲚ ⲚⲞⲨⲰⲚⲈ ⲚϪⲢⲞⲠ ⲘⲚ ⲞⲨⲠⲈⲦⲢⲀ ⲚⲤⲔⲀⲚⲆⲀⲖⲞⲚ. ⲀⲨⲰ ⲠⲈⲦⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲚϤⲚⲀϪⲒϢⲒⲠⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ⲚⲀⲤⲚⲎⲨ ⲠⲞⲨⲰϢ ⲘⲈⲚ ⲚⲦⲈ ⲠⲀϨⲎⲦ ⲘⲚⲠⲀⲤⲞⲠⲤ ϢⲞⲞⲠ ⲈϨⲢⲀⲒ ⲈⲠⲚⲞⲨⲦⲈ ϨⲀⲢⲞⲞⲨ ⲈⲨⲞⲨϪⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ϮⲢⲘⲚⲦⲢⲈ ⲄⲀⲢ ⲚⲀⲨ ϪⲈ ⲞⲨⲚⲦⲀⲨ ⲘⲘⲀⲨ ⲚⲞⲨⲔⲰϨ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲞⲨⲤⲞⲞⲨⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ⲈⲨⲞ ⲄⲀⲢ ⲚⲀⲦⲤⲞⲞⲨⲚ ⲈⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲨϢⲒⲚⲈ ⲚⲤⲀ ⲦⲀϨⲈ ⲦⲰⲞⲨ ⲈⲢⲀⲦⲤ ⲘⲘⲒⲚ ⲘⲘⲞⲞⲨ. ⲘⲠⲞⲨϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ⲠϪⲰⲔ ⲄⲀⲢ ⲘⲠⲚⲞⲘⲞⲤ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ⲀⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲤϨⲀⲒ ϪⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲦⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲠⲢⲰⲘⲈ ⲈⲦⲚⲀⲀⲤ ϤⲚⲀⲰⲚϨ ⲚϨⲎⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲆⲈ ⲦⲈⲂⲞⲖ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ϪⲰ ⲘⲘⲞⲤ ⲚⲦⲈⲈⲒϨⲈ. ϪⲈ ⲘⲠⲢϪⲞⲞⲤ ϨⲘ ⲠⲈⲔϨⲎⲦ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲂⲰⲔ ⲈϨⲢⲀⲒ ⲈⲦⲠⲈ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲈⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ⲎⲚⲒⲘ ⲠⲈⲦⲚⲀⲂⲰⲔ ⲈⲠⲈⲤⲎⲦ ⲈⲠⲚⲞⲨⲚ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲈⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈϨⲢⲀⲒ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ⲀⲖⲖⲀ ⲞⲨ ⲠⲈⲦϤϪⲰ ⲘⲘⲞϤ ϪⲈ ⲠϢⲀϪⲈ ϨⲎⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞⲔ ϨⲚ ⲦⲈⲔⲦⲀⲠⲢⲞ. ⲀⲨⲰ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲔϨⲎⲦ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠϢⲀϪⲈ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲈⲦⲚⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ϪⲈ ⲈⲔϢⲀⲚϨⲞⲘⲞⲖⲞⲄⲒ ⲘⲠϢⲀϪⲈ ϨⲚ ⲦⲈⲔⲦⲀⲠⲢⲞ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ. ⲀⲨⲰ ⲚⲄⲠⲒⲤⲦⲈⲨⲈ ϨⲘ ⲠⲈⲔϨⲎⲦ ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲔⲚⲀⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ⲈⲨⲠⲒⲤⲦⲈⲨⲈ ⲄⲀⲢ ⲈⲢⲞϤ ϨⲘ ⲠϨⲎⲦ ⲈⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲈⲨϨⲞⲘⲞⲖⲞⲄⲈⲒ ⲆⲈ ⲘⲘⲞϤ ϨⲚ ⲦⲦⲀⲠⲢⲞ ⲈⲨⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ϢⲀⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ⲄⲀⲢ ϪⲞⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ ⲚϤⲚⲀϪⲒϢⲒⲠⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ⲘⲚ ⲠⲰⲢϪ ⲄⲀⲢ ϢⲞⲞⲠ ⲘⲠⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲠⲞⲨⲈⲒⲈⲚⲒⲚ. ⲠⲒϪⲞⲈⲒⲤ ⲄⲀⲢ ⲚⲞⲨⲰⲦ ⲠⲈ ⲘⲘⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲈϤⲞ ⲚⲢⲘⲘⲀⲞ ⲈⲞⲨⲞⲚ ⲚⲒⲘ. ⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚⲀⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲚⲀⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ϤⲚⲀⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ⲚⲀϢ ⲆⲈ ⲚϨⲈ ⲈⲨⲚⲀⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲈⲦⲈ ⲘⲠⲞⲨⲠⲒⲤⲦⲈⲨⲈ ⲈⲢⲞϤ. ⲚⲀϢ ⲆⲈ ⲚϨⲈ ⲈⲨⲚⲀⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲦⲈ ⲘⲠⲞⲨⲤⲰⲦⲘ ⲈⲢⲞϤ. ⲚⲀϢ ⲆⲈ ⲚϨⲈ ⲈⲨⲚⲀⲤⲰⲦⲘ ⲚⲞⲨⲈϢ ⲘⲠⲈⲦⲦⲀϢⲈⲞⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ⲚⲀϢ ⲆⲈ ⲚϨⲈ ⲈⲨⲚⲀⲦⲀϢⲈⲞⲈⲒϢ ⲈⲨⲦⲘϪⲞⲞⲨⲤⲈ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲈϢϪⲈ ⲚⲈⲤⲈⲚⲞⲨⲈⲢⲎⲦⲈ ⲚⲚⲈⲦⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲘⲠⲈⲦⲚⲀⲚⲞⲨϤ ");
INSERT INTO copshc_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ⲀⲖⲖⲀ ⲘⲠⲞⲨⲤⲰⲦⲘ ⲦⲎⲢⲞⲨ ⲚⲤⲀ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ϢⲀⲢⲈ ⲎⲤⲀⲒⲀⲤ ⲄⲀⲢ ϪⲞⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲈⲚϨⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ⲀⲢⲀ ϬⲈ ⲦⲠⲒⲤⲦⲒⲤ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲤⲰⲦⲘ ⲦⲈ. ⲠⲤⲰⲦⲘ ⲆⲈ ϨⲒⲦⲘ ⲠϢⲀϪⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ⲀⲖⲖⲀ ⲦⲀϪⲞⲞⲤ ϪⲈ ⲈⲦⲈⲘⲠⲞⲨⲤⲰⲦⲘ. ⲈϢⲰⲠⲈ ϬⲈ ⲀⲠⲈⲨϨⲢⲞⲞⲨ ⲈⲒ ⲈⲂⲞⲖ ⲈⲠⲔⲀϨ ⲦⲎⲢϤ. ⲀⲨⲰ ⲀⲚⲈⲨϢⲀϪⲈ ⲠⲰϨ ϢⲀ ⲀⲢⲎϪⲤ ⲚⲦⲞⲒⲔⲞⲨⲘⲈⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ⲀⲖⲖⲀ ⲦⲀϪⲞⲞⲤ ϪⲈ ⲈⲦⲈ ⲘⲠⲈ ⲠⲒⲤⲢⲀⲎⲖ ⲈⲒⲘⲈ. ϢⲀⲢⲈ ⲘⲰⲨⲤⲎⲤ ϪⲞⲞⲤ ϪⲒⲚ ⲚϢⲞⲢⲠ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀϮⲔⲰϨ ⲚⲎⲦⲚ ⲈϪⲘ ⲠⲈⲦⲈⲚⲞⲨϨⲈⲐⲚⲞⲤ ⲀⲚ ⲠⲈ. ϮⲚⲀϮⲚⲞⲨϬⲤ ⲚⲎⲦⲚ ⲈϪⲚ ⲞⲨϨⲈⲐⲚⲞⲤ ⲚⲀⲐⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ϢⲀⲢⲈ ⲎⲤⲀⲒⲀⲤ ⲆⲈ ⲦⲞⲖⲘⲀ ⲚϤϪⲞⲞⲤ ϪⲈ ⲀⲨϨⲈ ⲈⲢⲞⲒ ϨⲚ ⲚⲈⲦⲈⲚⲤⲈϢⲒⲚⲈ ⲚⲤⲰⲒ ⲀⲚ. ⲀⲒⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲚⲤⲈϪⲚⲞⲨ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ϢⲀϤϪⲞⲞⲤ ⲆⲈ ⲈⲠⲒⲤⲢⲀⲎⲖ ϪⲈ ⲀⲒⲠⲢϢ ⲚⲀϬⲒϪ ⲈⲂⲞⲖ ⲘⲠⲈϨⲞⲞⲨ ⲦⲎⲢϤ ⲈⲨⲖⲀⲞⲤ ⲚⲀⲦⲚⲀϨⲦⲈ ⲀⲨⲰ ⲈϤⲞⲨⲰϨⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ⲦⲀϪⲞⲞⲤ ϬⲈ ϪⲈ ⲘⲎ ⲀⲠⲚⲞⲨⲦⲈ ⲔⲀ ⲠⲈϤⲖⲀⲞⲤ ⲚⲤⲰϤ ⲚⲚⲈⲤϢⲰⲠⲈ. ⲔⲀⲒ ⲄⲀⲢ ⲀⲚⲞⲔ ϨⲰ ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ϨⲘ ⲠⲒⲤⲢⲀⲎⲖ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀϨⲀⲘ ⲦⲈⲪⲨⲖⲎ ⲚⲂⲈⲚⲒⲀⲘⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ⲘⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲔⲀ ⲠⲈϤⲖⲀⲞⲤ ⲚⲤⲰϤ ⲠⲈⲚⲦⲀϤⲤⲞⲨⲰⲚϤ ϪⲒⲚ ⲚϢⲞⲢⲠ. ⲎⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ϢⲀⲢⲈ ⲦⲈⲄⲢⲀⲪⲎ ϪⲞⲞⲤ ϪⲈ ⲞⲨ ϨⲚ ϨⲎⲖⲈⲒⲀⲤ. ⲚⲐⲈ ⲈϢⲀϤⲤⲘⲘⲈ ⲈϨⲢⲀⲒ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲠⲒⲤⲢⲀⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ϪⲈ ⲠϪⲞⲈⲒⲤ ⲚⲈⲔⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲘⲞⲞⲨⲦⲞⲨ ⲚⲈⲔⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲀⲨϢⲢϢⲰⲢⲞⲨ ⲀⲚⲞⲔ ⲠⲈⲚⲦⲀⲒϢⲰϪⲠ ⲘⲀⲨⲀⲀⲦ ⲀⲨⲰ ⲤⲈϢⲒⲚⲈ ⲚⲤⲀ ⲦⲀⲮⲨⲬⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ⲀⲖⲖⲀ ⲈϢⲀⲢⲈ ⲠϢⲀϪⲈ ϪⲞⲞⲤ ⲚⲀϤ ϪⲈ ⲞⲨ ϪⲈ ⲀⲒϢⲰϪⲠ ⲚⲀⲒ ⲚⲤⲀϢϤ ⲚϢⲞ ⲚⲢⲰⲘⲈ ⲚⲀⲒ ⲈⲦⲈ ⲘⲠⲞⲨⲔⲖϪⲠⲀⲦ ⲚⲦⲂⲀϨⲀⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ⲦⲀⲒ ϬⲈ ⲞⲚ ⲦⲈ ⲐⲈ ϨⲘ ⲠⲈⲒⲔⲈⲞⲨⲞⲈⲒϢ ⲞⲨϢⲰϪⲠ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲔⲀⲦⲀ ⲞⲨⲘⲚⲦⲤⲰⲦⲠ ⲚⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ⲈⲒ ⲦⲈ ⲈϢϪⲈ ϨⲚ ⲞⲨⲬⲀⲢⲒⲤ ⲈⲒⲈ ⲞⲨⲈⲂⲞⲖ ϬⲈ ⲀⲚ ⲠⲈ ϨⲚ ⲚⲈϨⲂⲎⲨⲈ ⲘⲘⲞⲚ ⲦⲈⲬⲀⲢⲒⲤ ϬⲈ ⲚⲀⲢⲬⲀⲢⲒⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ⲞⲨ ϬⲈ ⲠⲈⲦⲈⲢⲈ ⲠⲒⲤⲢⲀⲎⲖ ϢⲒⲚⲈ ⲚⲤⲰϤ ⲠⲀⲒ ⲘⲠϤⲘⲀⲦⲈ ⲘⲘⲞϤ ⲀⲦⲘⲚⲦⲤⲰⲦⲠ ⲆⲈ ⲘⲀⲦⲈ ⲘⲘⲞϤ ⲀⲠⲔⲈⲤⲈⲈⲠⲈ ⲆⲈ ⲦⲰⲘ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ⲔⲀⲦⲀⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀⲠⲚⲞⲨⲦⲈ ϮⲚⲀⲨ ⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲘⲔⲀϨ ⲚϨⲎⲦ ϨⲈⲚⲂⲀⲖ ⲈⲦⲘⲚⲀⲨ ⲈⲂⲞⲖ. ⲀⲨⲰ ϨⲈⲚⲘⲀⲀϪⲈ ⲈⲦⲘⲤⲰⲦⲘ ϢⲀ ϨⲢⲀⲒ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ϢⲀⲢⲈ ⲆⲀⲨⲈⲒⲆ ⲞⲚ ϪⲞⲞⲤ ϪⲈ ⲘⲀⲢⲈ ⲦⲈⲨⲦⲢⲀⲠⲈⲌⲀ ϢⲰⲠⲈ ⲚⲀⲨ ⲈⲨϬⲞⲢϬⲤ ⲘⲚ ⲞⲨⲠⲀϢ. ⲀⲨⲰ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲘⲚ ⲞⲨⲦⲰⲰⲂⲈ ⲚⲀⲨ ");
INSERT INTO copshc_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ⲘⲀⲢⲞⲨⲢⲔⲀⲔⲈ ⲚϬⲒ ⲚⲈⲨⲂⲀⲖ ⲈⲦⲘⲚⲀⲨ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲦⲈⲨϪⲒⲤⲈ ⲚⲄⲞⲖⲔⲤ ⲚⲤⲎⲨ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ⲦⲀϪⲞⲞⲤ ϬⲈ ϪⲈ ⲚⲦⲀⲨϪⲰⲢⲠ ϪⲈ ⲈⲨⲈϨⲈ ⲚⲚⲈⲤϢⲰⲠⲈ. ⲀⲖⲖⲀ ϨⲘ ⲠⲈⲨϨⲈ ⲀⲠⲈⲨϪⲀⲒ ϢⲰⲠⲈ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲠϮⲔⲰϨ ⲚⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ⲈϢϪⲈ ⲀⲠⲈⲨϨⲈ ⲆⲈ ⲢⲘⲚⲦⲢⲘⲘⲀⲞ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲀⲨⲰ ⲀⲠⲈⲨϢⲰⲰⲦ ⲢⲘⲚⲦⲢⲘⲘⲀⲞ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲒⲈ ⲞⲨⲎⲢ ⲚϨⲞⲨⲞ ⲠⲈ ⲠⲈⲨϪⲰⲔ. ");
INSERT INTO copshc_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ⲚϨⲈⲐⲚⲞⲤ ⲈⲠϨⲞⲤⲞⲚ ⲄⲀⲢ ⲀⲚⲄ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲚϨⲈⲐⲚⲞⲤ. ϮϮⲈⲞⲞⲨ ⲚⲦⲀⲆⲒⲀⲔⲞⲚⲒⲀ ");
INSERT INTO copshc_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ϪⲈ ⲈⲒⲈϮⲔⲰϨ ⲚⲦⲀⲤⲀⲢⲜ ⲦⲀⲦⲞⲨϪⲈ ϨⲞⲒⲚⲈ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ⲈϢϪⲈ ⲀⲠⲈⲨⲦⲤⲦⲞ ⲄⲀⲢ ⲈⲂⲞⲖ ⲢϨⲰⲦⲠ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲈⲒⲈ ⲞⲨⲎⲢ ⲠⲈ ⲠⲈⲨϢⲞⲠⲞⲨ ⲈϨⲞⲨⲚ ⲚⲤⲀ ⲠⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ⲈϢϪⲈ ⲠⲈⲐⲀⲂ ⲄⲀⲢ ⲞⲨⲀⲀⲂ. ⲈⲒⲈ ⲠⲔⲈⲞⲨⲰϢⲘ ⲞⲨⲀⲀⲂ. ⲀⲨⲰ ⲈϢϪⲈ ⲦⲚⲞⲨⲚⲈ ⲞⲨⲀⲀⲂ ⲈⲒⲈ ⲚⲈⲤⲔⲈⲔⲖⲀⲆⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ⲈϢϪⲈ ϨⲞⲒⲚⲈ ⲆⲈ ⲚⲚⲈⲔⲖⲀⲆⲞⲤ ⲀⲨϢⲀⲀⲦⲞⲨ. ⲚⲦⲞⲔ ⲆⲈ ⲚⲦⲔ ⲞⲨⲂⲰ ⲚϪⲒⲦϨⲞⲞⲨⲦ ⲀⲨⲦⲞϬⲔ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ. ⲀⲨⲰ ⲀⲔϢⲰⲠⲈ ⲚⲔⲞⲒⲚⲰⲚⲞⲤ ⲈⲠⲔⲚⲚⲈ ⲚⲦⲚⲞⲨⲚⲈ ⲚⲦⲂⲰ ⲚϪⲞⲈⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ⲘⲠⲢϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ⲈϪⲚ ⲚⲈⲔⲖⲀⲆⲞⲤ ⲈϢϪⲈ ⲔϢⲞⲨϢⲞⲨ ⲆⲈ ⲘⲘⲞⲔ ⲚⲦⲞⲔ ⲀⲚ ⲈⲦϤⲒ ϨⲀ ⲦⲚⲞⲨⲚⲈ ⲀⲖⲖⲀ ⲦⲚⲞⲨⲚⲈ ⲦⲈⲦϤⲒ ϨⲀⲢⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ⲔⲚⲀϪⲞⲞⲤ ϬⲈ ⲚⲀⲒ ϪⲈ ⲚⲦⲀⲨϢⲈⲦ ϨⲈⲚⲔⲖⲀⲆⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲦⲞϬⲦ ");
INSERT INTO copshc_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ⲔⲀⲖⲰⲤ ϨⲚ ⲞⲨⲘⲚⲦⲀⲠⲒⲤⲦⲞⲤ ⲀⲨϢⲀⲀⲦⲞⲨ ⲚⲦⲞⲔ ⲆⲈ ⲈⲔⲀϨⲈⲢⲀⲦⲔ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲘⲠⲢϪⲒⲤⲈ ϬⲈ ⲚϨⲎⲦ ⲀⲖⲖⲀ ⲀⲢⲒϨⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ⲈϢϪⲈ ⲘⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ϮⲤⲞ ⲈⲚⲈⲔⲖⲀⲆⲞⲤ ⲈⲦⲈϨⲰⲞⲨ ⲚⲈ. ⲚϤⲚⲀϮⲤⲞ ϨⲰⲰⲔ ⲀⲚ ⲈⲢⲞⲔ ");
INSERT INTO copshc_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ⲀⲚⲀⲨ ϬⲈ ⲈⲦⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ⲀⲨⲰ ⲦⲘⲚⲦⲢⲈϤϢⲰⲰⲦ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲘⲚⲦⲢⲈϤϢⲰⲰⲦ ⲘⲈⲚ ⲈϪⲚ ⲚⲈⲚⲦⲀⲨϨⲈ. ⲦⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈϪⲰⲔ ⲈⲔϢⲀⲚϬⲰ ϨⲚ ⲦⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ. ⲈϢⲰⲠⲈ ⲘⲘⲞⲚ ϨⲰⲰⲔ ⲤⲈⲚⲀϢⲀⲀⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ⲚⲔⲞⲞⲨⲈ ϨⲰⲞⲨ ⲈⲨϢⲀⲚⲦⲘϬⲰ ϨⲚ ⲦⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ⲤⲈⲚⲀⲦⲞϬⲞⲨ. ⲞⲨⲚϬⲞⲘ ⲄⲀⲢ ⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞϬⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ⲈϢϪⲈ ⲚⲦⲞⲔ ⲄⲀⲢ ⲚⲦⲀⲨ ϢⲀⲀⲦⲔ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲂⲰ ⲚϪⲒⲦϨⲞⲞⲨⲦ ⲚⲀⲘⲈ ⲀⲨⲰ ⲠⲀⲢⲀ ⲦⲈⲔⲘⲒⲚⲈ ⲀⲨⲦⲞϬⲔ ⲈⲨⲂⲰ ⲚϪⲒⲦⲚⲞⲨⲦⲘ. ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲚⲀⲒ ⲈϨⲞⲒⲚⲈ ⲢⲰ ⲚⲈ ⲤⲈⲚⲀⲦⲞϬ ⲞⲨ ⲈⲦⲈⲨⲂⲰ ⲚϪⲞⲈⲒⲦ ⲘⲘⲒⲚ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ϮⲞⲨⲰϢ ⲆⲈ ⲈⲦⲢⲈⲦⲚⲈⲒⲘⲈ ⲚⲀⲤⲚⲎⲨ ⲈⲠⲈⲈⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲦⲚϢⲰⲠⲈ ⲚⲎⲦⲚ ⲚⲤⲀⲂⲈ ϪⲈ ⲚⲦⲀⲞⲨⲦⲰⲘ ⲚϨⲎⲦ ϢⲰⲠⲈ ⲚϨⲞⲒⲚⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ϢⲀⲚⲦⲈⲠϪⲰⲔ ⲚⲚϨⲈⲐⲚⲞⲤ ⲈⲒ ⲈϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲦⲈ ⲠⲒⲤⲢⲀⲎⲖ ⲦⲎⲢϤ ⲞⲨϪⲀⲒ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ϤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲚ ⲤⲒⲰⲚ ⲚϬⲒ ⲠⲈⲦⲚⲞⲨϨⲘ ⲚϤⲔⲦⲈⲘⲘⲚⲦϢⲀϤⲦⲈ ⲈⲂⲞⲖ ϨⲚ ⲒⲀⲔⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲦⲆⲒⲀⲐⲎⲔⲎ ⲈⲦϢⲞⲞⲠ ⲚⲀⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ ⲈⲒϢⲀⲚⲔⲰ ⲈⲂⲞⲖ ⲚⲚⲈⲨⲚⲞⲂⲈ ");
INSERT INTO copshc_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ⲔⲀⲦⲀ ⲘⲈⲚ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲀⲨⲢϪⲀϪⲈ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ. ⲔⲀⲦⲀ ⲦⲈ ⲦⲘⲚⲦⲤⲰⲦⲠ ϨⲈⲚⲘⲈⲢⲒⲦ ⲚⲈ ⲈⲦⲂⲈ ⲚⲈⲨⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ϨⲈⲚⲀⲦⲢϨⲦⲎϤ ⲄⲀⲢ ⲚⲈ ⲚⲈⲬⲀⲢⲒⲤⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲠⲈϤⲦⲰϨⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ⲚⲐⲈ ⲄⲀⲢ ⲚⲦⲰⲦⲚ ⲘⲠⲒⲞⲨⲞⲈⲒϢ ⲈⲚⲦⲀⲦⲈⲦⲚⲢⲀⲦⲚⲀϨⲦⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲦⲈⲚⲞⲨ ⲆⲈ ⲀⲨⲚⲀ ⲚⲎⲦⲚ ϨⲚ ⲦⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ⲚⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲚⲀⲒ ϨⲰⲞⲨ ⲦⲈⲚⲞⲨ ⲈⲀⲨⲢⲀⲦⲚⲀϨⲦⲈ ⲈⲠⲈⲦⲚⲚⲀ ϪⲈⲔⲀⲀⲤ ϨⲰⲞⲨ ⲈⲨⲈⲚⲀ ⲚⲀⲨ ⲘⲚⲚⲤⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ⲀⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲈⲦⲠⲞⲨⲞⲚ ⲚⲒⲘ ⲈϨⲞⲨⲚ ⲈⲨⲘⲚⲦⲀⲦⲚⲀϨⲦⲈ ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲚⲀ ⲚⲀⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ⲰⲠϢⲒⲔ ⲚⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲘⲚ ⲦⲤⲞⲪⲒⲀ ⲀⲨⲰ ⲠⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲐⲈ ⲈⲦⲈ ⲚⲈⲨⲈϢⲘⲈϢⲦ ⲚϨⲀⲠ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲈⲦⲈ ⲚⲈⲨⲈϢⲚⲢⲀⲦⲞⲨ ⲚⲚⲈϤϨⲒⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲚⲦⲀϤⲈⲒⲘⲈ ⲈⲠϨⲎⲦ ⲘⲠϪⲞⲈⲒⲤ ⲠⲀⲒ ⲈⲦⲚⲀⲦⲤⲀⲂⲈ ⲈⲒⲀⲦϤ ⲈⲂⲞⲖ. ⲎⲚⲒⲘ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚⲀϤ ⲚⲢⲈϤϪⲒϢⲞϪⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ⲎⲚⲒⲘ ⲠⲈⲚⲦⲀϤⲈⲒⲢⲈ ⲚⲀϤ ⲚϢⲞⲢⲠ ⲦⲀⲢⲈϤⲦⲞⲨⲈⲒⲞ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ϪⲈ ⲠⲦⲎⲢϤ ϨⲈⲚⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚⲈ ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲀⲨⲰ ⲈⲨⲚⲀⲔⲞⲦⲞⲨ ⲈⲢⲞϤ ⲠⲰϤ ⲠⲈ ⲠⲈⲞⲞⲨ ϢⲀ ⲚⲒⲈⲚⲈϨ ϨⲀⲘⲎⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ϬⲈ ⲘⲘⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ϨⲒⲦⲚ ⲘⲘⲚⲦϢⲀⲚϨⲦⲎϤ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲠⲀⲢϨⲒⲤⲦⲀ ⲚⲚⲈⲦⲚⲤⲰⲘⲀ ⲚⲞⲨⲐⲨⲤⲒⲀ ⲈⲤⲞⲚϨ ⲈⲤⲞⲨⲀⲀⲂ ⲈⲤⲢⲀⲚⲀϤ ⲘⲠⲚⲞⲨⲦⲈ. ⲠⲈⲦⲚϢⲘϢⲈ ⲚⲢⲘⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ⲚⲦⲈⲦⲚ ⲦⲘϪⲒϨⲢⲂ ⲘⲠⲈⲒⲀⲒⲰⲚ. ⲀⲖⲖⲀ ⲚⲦⲈⲦⲚ ϪⲒ ⲘⲠϨⲢⲂ ⲚⲦⲘⲚⲦⲂⲢⲢⲈ ⲘⲠⲈⲦⲚϨⲎⲦ ⲈⲦⲢⲈⲦⲚⲆⲞⲔⲒⲘⲀⲌⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲚⲀⲚⲞⲨϤ ⲈⲦⲢⲀⲚⲀϤ ⲈⲦϪⲎⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϨⲒⲦⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲀⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲈⲦⲘϪⲒⲤⲈ ⲚϨⲎⲦ ⲠⲀⲢⲀ ⲐⲈ ⲈⲦϢⲈ ⲈⲘⲈⲈⲨⲈ ⲀⲖⲖⲀ ⲈⲘⲈⲈⲨⲈ ⲚⲦⲞϤ ⲈⲢⲢⲘⲚϨⲎⲦ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲰϢ ⲚⲀϤ ⲚⲞⲨϢⲒ ⲘⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ⲔⲀⲦⲀ ⲐⲈ ⲄⲀⲢ ⲈⲦⲈⲨⲚⲦⲀⲚ ϨⲀϨ ⲘⲘⲈⲖⲞⲤ ϨⲚ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲈⲘⲠⲒϨⲰⲂ ⲀⲚ ⲚⲞⲨⲰⲦ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲈ ⲘⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ⲦⲀⲒ ⲦⲈ ⲦⲈⲚϨⲈ ⲦⲎⲢⲚ ⲀⲚⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲞⲨⲀ ⲆⲈ ⲠⲞⲨⲀ ⲀⲚⲞⲚ ⲘⲘⲈⲖⲞⲤ ⲚⲚⲈⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ⲈⲨⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚϨⲈⲚϨⲘⲞⲦ ⲈⲨϢⲞⲂⲈ. ⲔⲀⲦⲀ ⲦⲈⲬⲀⲢⲒⲤ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲀⲚ. ⲈⲒⲦⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲔⲀⲦⲀ ⲠϢⲒ ⲚⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ⲈⲒⲦⲈ ⲞⲨⲆⲒⲀⲔⲞⲚⲒⲀ ϨⲚ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ. ⲈⲒⲦⲈ ⲠⲈⲦϮⲤⲂⲰ ϨⲚ ⲦⲈⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ⲈⲒⲦⲈ ⲠⲈⲦⲠⲀⲢⲀⲔⲀⲖⲈⲒ ϨⲘ ⲠⲤⲞⲠⲤ ⲠⲈⲦϮ ϨⲚ ⲞⲨⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ ⲠⲈⲦⲠⲢⲞϨⲒⲤⲦⲀ ϨⲚ ⲞⲨⲤⲠⲞⲨⲆⲎ ⲠⲈⲦⲚⲀ ϨⲚ ⲞⲨⲞⲨⲢⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ⲦⲀⲄⲀⲠⲎ ⲀϪⲚ ϨⲨⲠⲞⲔⲢⲒⲚⲈ. ⲈⲦⲈⲦⲚⲘⲞⲤⲦⲈ ⲘⲠⲠⲈⲐⲞⲞⲨ. ⲈⲦⲈⲦⲚⲦⲰϬⲈ ⲘⲘⲰⲦⲚ ⲈⲠⲠⲈⲦⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ϨⲚ ⲦⲘⲚⲦⲘⲀⲒⲤⲞⲚ ⲈⲦⲈⲦⲚⲞⲔⲚⲈⲔ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲦⲈⲦⲚϪⲒⲤⲈ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲢⲰⲦⲚ ϨⲘ ⲠⲦⲀⲈⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ⲈⲚⲦⲈⲦⲚϪⲚⲀⲀⲨ ⲀⲚ ϨⲚ ⲦⲈⲤⲠⲞⲨⲆⲎ. ⲈⲦⲈⲦⲚⲂⲢⲂⲢ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲈⲦⲈⲦⲚⲞ ⲚϨⲘϨⲀⲖ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ⲈⲦⲈⲦⲚⲢⲀϢⲈ ϨⲚ ⲐⲈⲖⲠⲒⲤ. ⲈⲦⲈⲦⲚϨⲨⲠⲞⲘⲒⲚⲈ ϨⲚ ⲦⲈⲐⲖⲒⲮⲒⲤ. ⲈⲦⲈⲦⲚⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲒ ⲈⲠⲈϢⲖⲎⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ⲈⲦⲈⲦⲚⲔⲞⲒⲚⲰⲚⲒ ⲈⲚⲈⲬⲢⲒⲀ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ⲈⲦⲈⲦⲚⲠⲎⲦ ⲚⲤⲀ ⲦⲘⲚⲦⲘⲀⲒ ϢⲘⲘⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ⲤⲘⲞⲨ ⲈⲚⲈⲦⲠⲎⲦ ⲚⲤⲰⲦⲚ ⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲘⲠⲢⲤϨⲞⲨⲰⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ⲢⲀϢⲈ ⲘⲚ ⲚⲈⲦⲢⲀϢⲈ. ⲢⲒⲘⲈ ⲘⲚ ⲚⲈⲦⲢⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ⲈⲦⲈⲦⲚⲘⲈⲈⲨⲈ ⲈⲨⲘⲈⲈⲨⲈ ⲚⲞⲨⲰⲦ ⲈⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲚⲦⲈⲦⲚϬⲰϢⲦ ⲀⲚ ⲈⲚⲒⲘⲚⲦϪⲀⲤⲒϨⲎⲦ. ⲀⲖⲖⲀ ⲈⲦⲈⲦⲚⲘⲞⲞϢⲈ ⲘⲚ ⲚⲈⲦⲐⲂⲂⲒⲎⲨ. ⲘⲠⲢϢⲰⲠⲈ ⲚⲤⲀⲂⲈ ⲚⲚⲀϨⲢⲎⲦⲚ ⲞⲨⲀⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ⲈⲚⲦⲈⲦⲚⲦⲰⲰⲂⲈ ⲀⲚ ⲚⲞⲨⲠⲈⲐⲞⲞⲨ ϨⲀ ⲞⲨⲠⲈⲐⲞⲞⲨ ⲚⲖⲀⲀⲨ. ⲈⲦⲈⲦⲚϤⲒ ⲘⲠⲢⲞⲞⲨϢ ⲚⲘⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲢⲰⲘⲈ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ⲈϢϪⲈ ⲞⲨⲚϢϬⲞⲘ ⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲚⲀⲦⲞⲦ ⲦⲎⲨⲦⲚ ⲈⲢⲈⲒⲢⲎⲚⲎ ⲘⲚ ⲢⲰⲘⲈ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ⲈⲚⲦⲈⲦⲚⲈⲒⲢⲈ ⲀⲚ ⲘⲠⲈⲦⲚⲔⲂⲀ ⲚⲀⲘⲈⲢⲀⲦⲈ. ⲀⲖⲖⲀ ⲔⲀ ⲠⲘⲀ ⲚⲦⲞⲢⲄⲎ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ⲚⲈϪ ⲠϨⲀⲠ ⲈⲢⲞⲒ ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀⲦⲰⲰⲂⲈ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ⲀⲖⲖⲀ ⲈⲢϢⲀⲚ ⲠⲈⲔϪⲀϪⲈ ϨⲔⲞ ⲘⲀⲦⲘⲘⲞϤ ⲀⲨⲰ ⲈϤϢⲀⲚⲈⲒⲂⲈ ⲘⲀⲦⲤⲞϤ. ⲈⲔⲈⲒⲢⲈ ⲄⲀⲢ ⲘⲠⲀⲒ ⲔⲚⲀⲠⲢϢ ϨⲈⲚϪⲂⲂⲈⲤ ⲚⲔⲰϨⲦ ⲈϪⲚ ⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ⲘⲠⲢⲦⲢⲈⲨϪⲢⲞ ⲈⲢⲞⲔ ϨⲒⲦⲘ ⲠⲠⲈⲐⲞⲞⲨ. ⲀⲖⲖⲀ ϪⲢⲞ ⲈⲠⲠⲈⲐⲞⲞⲨ ϨⲘ ⲠⲈⲦⲚⲀⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ⲘⲀⲢⲈ ⲮⲨⲬⲎ ⲚⲒⲘ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲚⲒⲈⲜⲞⲨⲤⲒⲀ ⲈⲦϪⲞⲤⲈ. ⲘⲚ ⲈⲜⲞⲨⲤⲒⲀ ⲄⲀⲢ ⲈⲒⲘⲎⲦⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲚⲈⲦϢⲞⲞⲠ ⲆⲈ ⲈⲨⲦⲎϢ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ϨⲰⲤⲦⲈ ⲠⲈⲦⲚⲀϮ ⲞⲨⲂⲈ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈϤϮ ⲞⲨⲂⲈ ⲠⲦⲰϢ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲈⲦϮ ⲆⲈ ⲤⲈⲚⲀϪⲒ ⲚⲀⲨ ⲚⲞⲨϨⲀⲠ ");
INSERT INTO copshc_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ⲚⲀⲢⲬⲰⲚ ⲚϨⲈⲚϨⲞⲦⲈ ⲀⲚ ⲚⲈ ⲘⲠϨⲰⲂ ⲈⲦⲚⲀⲚⲞⲨϤ ⲀⲖⲖⲀ ⲘⲠⲠⲈⲐⲞⲞⲨ ⲔⲞⲨⲰϢ ⲆⲈ ⲈⲦⲘⲢϨⲞⲦⲈ ϨⲎⲦⲤ ⲚⲦⲈⲜⲞⲨⲤⲒⲀ ⲀⲢⲒⲠⲀⲄⲀⲐⲞⲚ ⲀⲨⲰ ⲔⲚⲀϪⲒ ⲚⲞⲨⲦⲀⲈⲒⲞ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ⲞⲨⲆⲒⲀⲔⲞⲚⲞⲤ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲔ ⲦⲈ ⲈⲨⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲔϢⲀⲚⲢ ⲠⲠⲈⲐⲞⲞⲨ ⲀⲢⲒϨⲞⲦⲈ ⲈⲒⲔⲎ ⲄⲀⲢ ⲀⲚ ⲤⲪⲞⲢⲒ ⲚⲦⲤⲎ ϤⲈ ⲞⲨⲆⲒⲀⲔⲞⲚⲞⲤ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲦⲈ ⲚⲢⲈϤϪⲒⲔⲂⲀ ⲈⲦⲞⲢⲄⲎ ⲘⲠⲈⲦⲈⲒⲢⲈ ⲘⲠⲠⲈⲐⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ⲈⲦⲂⲈ ⲠⲀⲒ ϢϢⲈ ⲈϨⲨⲠⲞⲦⲀⲤⲤⲈ. ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲦⲂⲈ ⲦⲞⲢⲄⲎ. ⲀⲖⲖⲀ ⲈⲦⲂⲈ ⲦⲔⲈⲤⲨⲚⲒⲆⲎ ⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ⲈⲦⲂⲈ ⲠⲀⲒ ⲄⲀⲢ ⲦⲈⲦⲚϮϢⲰⲘ. ϨⲈⲚⲖⲒⲦⲞⲨⲢⲄⲞⲤ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲚⲈ ⲈⲨⲠⲢⲞⲤⲔⲀⲢⲦⲈⲢⲈⲒ ⲈⲠⲈⲈⲒϨⲰⲂ ");
INSERT INTO copshc_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ϯ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲚⲈⲦⲈⲢⲰⲦⲚ ⲠϢⲰⲘ ⲘⲠⲀ ⲠϢⲰⲘ ⲠⲦⲈⲖⲞⲤ ⲘⲠⲀ ⲠⲦⲈⲖⲞⲤ ⲐⲞⲦⲈ ⲘⲠⲀ ⲐⲞⲦⲈ ⲠⲦⲀⲈⲒⲞ ⲘⲠⲀ ⲠⲦⲀⲈⲒⲞ. ");
INSERT INTO copshc_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ⲘⲠⲢⲔⲀ ⲖⲀⲀⲨ ⲈⲢⲰⲦⲚ ⲚⲦⲚ ⲖⲀⲀⲨ ⲚⲤⲀ ⲠⲘⲈⲢⲈ ⲚⲈⲦⲚⲈⲢⲎⲨ. ⲠⲈⲦⲘⲈ ⲄⲀⲢ ⲘⲠⲈⲐⲒ ⲦⲞⲨⲰϤ ⲀϤϪⲈⲔ ⲠⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ϨⲘ ⲠⲦⲢⲈϤϪⲞⲞⲤ ⲄⲀⲢ ϪⲈ ⲚⲚⲈⲔⲢⲚⲞⲈⲒⲔ ⲚⲚⲈⲔϨⲰⲦⲂ ⲚⲚⲈⲔϪⲒⲞⲨⲈ ⲚⲚⲈⲔⲈⲠⲒⲐⲨⲘⲒ ⲀⲨⲰ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲚⲚⲈⲚⲦⲞⲖⲎ ⲈϢⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲈⲒϢⲀϪⲈ ϨⲚ ⲈⲔⲈⲘⲈⲢⲈ ⲠⲈⲐⲒⲦⲞⲨⲰⲔ ⲚⲦⲈⲔϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ⲘⲈⲢⲈ ⲦⲀⲄⲀⲠⲎ ⲢⲠⲈⲐⲞⲞⲨ ⲘⲠⲈⲐⲒⲦⲞⲨⲰⲤ. ⲠϪⲰⲔ ϬⲈ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲘⲞⲤ ⲠⲈ ⲦⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ⲀⲨⲰ ⲠⲀⲒ ⲈⲚⲤⲞⲞⲨⲚ ⲘⲠⲒⲞⲨⲞⲈⲒϢ. ϪⲈ ⲀⲦⲈⲨⲚⲞⲨ ϬⲈ ϢⲰⲠⲈ ⲈⲦⲢⲈⲚⲦⲰⲞⲨⲚ ϨⲀ ⲠϨⲒⲚⲎⲂ. ⲦⲈⲚⲞⲨ ⲄⲀⲢ ⲀⲠⲈⲚⲞⲨϪⲀⲒ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞⲚ ⲈϨⲞⲨⲈ ⲠⲈⲨⲞⲈⲒϢ ⲈⲚⲦⲀⲚⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ⲀⲦⲈⲨϢⲎ ⲠⲢⲞⲔⲞⲠⲦⲈ. ⲀⲠⲈϨⲞⲞⲨ ϨⲰⲚ ⲈϨⲞⲨⲚ ⲘⲀⲢⲚⲔⲰ ϬⲈ ⲚⲤⲰⲚ ⲚⲚⲈϨⲂⲎⲨⲈ ⲘⲠⲔⲀⲔⲈ. ⲚⲦⲚϮ ⲆⲈ ϨⲒⲰⲰⲚ ⲚⲚϨⲞⲠⲖⲞⲚ ⲘⲠⲞⲨⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ϨⲰⲤ ⲈⲚϨⲘ ⲠⲈϨⲞⲞⲨ ⲘⲀⲢⲚⲘⲞⲞϢⲈ ⲈⲚⲦⲤⲀⲚⲎⲨ ϨⲚ ϨⲈⲚϪⲎⲢ ⲀⲚ ⲘⲚ ϨⲈⲚϮϨⲈ ϨⲚ ϨⲈⲚⲘⲀ ⲚⲚⲔⲞⲦⲔ ⲀⲚ ⲘⲚ ϨⲈⲚϪⲰϨⲘ ϨⲚ ϨⲈⲚϮⲦⲰⲚ ⲀⲚ ⲘⲚ ϨⲈⲚⲔⲰϨ. ");
INSERT INTO copshc_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ⲀⲖⲖⲀ ϮϨⲒⲰⲦ ⲦⲎⲨⲦⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲘⲠⲢϤⲒⲠⲢⲞⲞⲨϢ ⲚⲦⲈⲦⲚ ⲤⲀⲢⲜ ⲈϨⲈⲚⲈⲠⲒⲐⲨⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ⲠⲈⲦϬⲞⲞⲂ ⲆⲈ ϢⲞⲠϤ ⲈⲢⲰⲦⲚ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲈϨⲈⲚϨⲞⲦϨⲦ ⲀⲚ ⲘⲘⲞⲔⲘⲈⲔ. ");
INSERT INTO copshc_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ⲞⲨⲚ ⲠⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲘⲈⲚ ⲈⲞⲨⲈⲘ ⲚⲔⲀ ⲚⲒⲘ. ⲠⲈⲦϬⲞⲞⲂ ⲆⲈ ϤⲞⲨⲘ ⲞⲨⲞⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ⲘⲠⲢⲦⲢⲈ ⲠⲈⲦⲞⲨⲰⲘ ⲤⲈϢϤ ⲠⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ. ⲀⲨⲰ ⲘⲠⲢⲦⲢⲈ ⲠⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲔⲢⲒⲚⲈ ⲘⲠⲈⲦⲞⲨⲰⲘ. ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲠⲈⲚⲦⲀϤϢⲞⲠϤ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ⲚⲦⲔ ⲚⲒⲘ ⲈⲔⲔⲢⲒⲚⲈ ⲚⲞⲨϨⲘϨⲀⲖ ⲈⲘⲠⲰⲔ ⲀⲚ ⲠⲈ ⲈϤⲀϨⲈⲢⲀⲦϤ ⲈⲠⲈϤϪⲞⲈⲒⲤ ⲎⲈϤⲚⲀϨⲈ ϤⲚⲀⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦϤ. ⲞⲨⲚϬⲞⲘ ⲄⲀⲢ ⲘⲠϪⲞⲈⲒⲤ ⲈⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ⲞⲨⲚ ⲠⲈⲦⲔⲔⲢⲒⲚⲈ ⲘⲈⲚ ⲚⲞⲨϨⲞⲞⲨ ⲠⲀⲢⲀ ⲞⲨϨⲞⲞⲨ. ⲞⲨⲚ ⲠⲈⲦⲔⲔⲢⲒⲚⲈ ⲆⲈ ⲚϨⲞⲞⲨ ⲚⲒⲘ. ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲀⲢⲈϤⲦⲰⲦ ϨⲘ ⲠⲈϤϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ⲠⲈⲦⲘⲈⲈⲨⲈ ⲈⲠⲈϨⲞⲞⲨ ⲈϤⲘⲈⲈⲨⲈ ⲈⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠⲈⲦⲞⲨⲰⲘ ⲈϤⲞⲨⲰⲘ ⲘⲠϪⲞⲈⲒⲤ ϤϢⲠϨⲘⲞⲦ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ϤϢⲠϨⲘⲞⲦ ⲚⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ⲘⲚ ⲖⲀⲀⲨ ⲄⲀⲢ ⲘⲘⲞⲚ ⲞⲚϨ ⲚⲀϤ. ⲀⲨⲰ ⲘⲚ ⲖⲀⲀⲨ ⲘⲘⲞⲚ ⲚⲀⲘⲞⲨ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ⲈϢⲰⲠⲈ ⲄⲀⲢ ⲈⲚϢⲀⲚⲰⲚϨ ⲈⲚⲀⲰⲚϨ ⲘⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲈⲚϢⲀⲚⲘⲞⲨ ⲈⲚⲀⲘⲞⲨ ⲘⲠϪⲞⲈⲒⲤ. ⲈϢⲰⲠⲈ ϬⲈ ⲈⲚϢⲀⲚⲰⲚϨ ⲈϢⲰⲠⲈ ⲈⲚϢⲀⲚⲘⲞⲨ ⲀⲚⲞⲚ ⲚⲀ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ⲈⲦⲂⲈ ⲠⲀⲒ ⲄⲀⲢ ⲀⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ⲀⲨⲰ ⲀϤⲰⲚϨ ϪⲈ ⲈϤⲈⲢϪⲞⲈⲒⲤ ⲈⲚⲈⲦⲘⲞⲞⲨⲦ ⲘⲚ ⲚⲈⲦⲞⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ⲚⲦⲞⲔ ⲆⲈ ⲀϨⲢⲞⲔ ⲔⲔⲢⲒⲚⲈ ⲘⲠⲈⲔⲤⲞⲚ ⲎⲀϨⲢⲞⲔ ϨⲰⲰⲔ ⲔⲤⲰϢϤ ⲘⲠⲈⲔⲤⲞⲚ. ⲦⲚⲀⲀϨⲈⲢⲀⲦⲚ ⲄⲀⲢ ⲦⲎⲢⲚ ⲈⲠⲂⲎⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ϮⲞⲚϨ ⲀⲚⲞⲔ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲠⲀⲦ ⲚⲒⲘ ⲚⲀⲔⲰⲖϪ ⲚⲀⲒ. ⲀⲨⲰ ⲖⲀⲤ ⲚⲒⲘ ⲚⲀⲈⲜⲞⲘⲞⲖⲞⲄⲈⲒ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ⲈⲒⲈ ⲈⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲚ ⲚⲀϮ ⲖⲞⲄⲞⲤ ϨⲀⲢⲞϤ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ⲘⲠⲢⲦⲢⲈⲚⲔⲢⲒⲚⲈ ϬⲈ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲚⲚⲈⲚⲈⲢⲎⲨ. ⲀⲖⲖⲀ ⲔⲢⲒⲚⲈ ⲚⲦⲞϤ ⲘⲠⲀⲒ ⲚϨⲞⲨⲞ ⲈⲦⲘⲔⲀϪⲢⲞⲠ ⲘⲠⲈⲔⲤⲞⲚ. ⲎⲤⲔⲀⲚⲆⲀⲖⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ϮⲤⲞⲞⲨⲚ ⲀⲨⲰ ϮⲠⲒⲐⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲚ ⲖⲀⲀⲨ ⲤⲞⲞϤ ϨⲀⲢⲞϤ ⲘⲀⲨⲀⲀϤ ⲈⲒⲘⲎⲦⲒ ⲘⲠⲈⲦⲘⲈⲈⲨⲈ ϪⲈ ⲠⲀⲒ ⲤⲞⲞϤ ⲈϤⲤⲞⲞϤ ⲘⲠ ⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ⲈϢϪⲈ ⲈⲦⲂⲈ ⲞⲨϨⲢⲈ ⲄⲀⲢ ⲠⲈⲔⲤⲞⲚ ⲖⲨⲠⲈⲒ ⲈⲒⲈ ⲀⲔⲖⲞ ⲈⲔⲘⲞⲞϢⲈ ⲔⲀⲦⲀ ⲞⲨⲀⲄⲀⲠⲎ. ϨⲢⲀⲒ ϨⲚ ⲦⲈⲔϨⲢⲈ ⲘⲠⲢⲘⲈⲨⲦⲠⲎ ⲈⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ⲘⲠⲢⲦⲢⲈⲨϪⲒⲞⲨⲀ ϬⲈ ⲈⲠⲈⲚⲀⲄⲀⲐⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ⲚⲦⲘⲚⲦⲢⲢⲞ ⲄⲀⲢ ⲀⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲞⲨⲰⲘ ϨⲒⲤⲰ ⲀⲖⲖⲀ ⲞⲨⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲦⲈ ⲘⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ ⲘⲚ ⲞⲨⲢⲀϢⲈ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ⲠⲈⲦϨⲘ ⲠⲀⲒ ⲄⲀⲢ ⲈⲦⲞ ⲘϨⲘϨⲀⲖ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϤⲢⲀⲚⲀϤ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲞⲨⲤⲰⲦⲠ ⲚⲢⲰⲘⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ⲀⲢⲀ ϬⲈ ⲘⲀⲢⲚⲠⲰⲦ ⲚⲤⲀ ⲚⲀ ϮⲢⲎⲚⲎ. ⲀⲨⲰ ⲚⲀ ⲠⲔⲰⲦ ⲈϨⲞⲨⲚ ⲈⲚⲈⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ⲈⲦⲂⲈ ⲞⲨϨⲢⲈ ⲘⲠⲢⲔⲀⲦⲀⲖⲨ ⲘⲠϨⲰⲂ ⲘⲠⲚⲞⲨⲦⲈ. ⲤⲈⲞⲨⲀⲀⲂ ⲘⲈⲚ ⲦⲎⲢⲞⲨ. ⲀⲖⲖⲀ ϤϨⲞⲞⲨ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲚⲀⲞⲨⲰⲘ ϨⲒⲦⲚ ⲞⲨϪⲢⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ⲚⲀⲚⲞⲨ ⲦⲘⲞⲨⲈⲘ ⲀϤ ⲞⲨⲆⲈ ⲈⲦⲘⲤⲈ ⲎⲢⲠ ⲞⲨⲆⲈ ⲠⲈⲦⲈⲢⲈ ⲠⲈⲔⲤⲞⲚ ⲚⲀϪⲒϪⲢⲞⲠ ⲚϨⲎⲦϤ ⲎⲚϤⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲎⲚϤϬⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ⲚⲦⲞⲔ ⲞⲨⲚⲦⲔ ⲞⲨⲠⲒⲤⲦⲒⲤ ⲔⲀⲀⲤ ⲚⲀⲔ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ⲚⲀⲒⲀⲦϤ ⲘⲠⲈⲦⲈⲚϤⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲀⲚ ϨⲘ ⲠⲈⲦϤⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ⲠⲈⲦⲚⲀⲢϨⲎⲦ ⲆⲈ ⲤⲚⲀⲨ ⲈϤϢⲀⲚⲞⲨⲰⲘ ϤⲦϬⲀⲈⲒⲎⲨ ϪⲈ ⲚⲦⲀϤⲀⲀⲤ ⲀⲚ ϨⲚ ⲞⲨⲠⲒⲤⲦⲒⲤ. ϨⲰⲂ ⲆⲈ ⲚⲒⲘ ⲈⲦⲈ ⲚϨⲈⲚⲈⲂⲞⲖ ⲀⲚ ⲚⲈ ϨⲚ ⲞⲨⲠⲒⲤⲦⲒⲤ ϨⲈⲚⲚⲞⲂⲈ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ϢϢⲈ ⲆⲈ ⲈⲢⲞⲚ ⲀⲚⲞⲚ ⲚⲈⲦⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲞⲨ ⲈⲦⲢⲈⲚϤⲒ ϨⲀⲘⲘⲚⲦϬⲰⲂ ⲚⲚⲈⲦⲈ ⲘⲚϬⲞⲘ ⲘⲘⲞⲞⲨ. ⲀⲨⲰ ⲚⲦⲚⲦⲘⲀⲢⲈⲤⲔⲈ ⲚⲀⲚ ⲞⲨⲀⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲚ ⲘⲀⲢⲈϤⲀⲢⲈⲤⲔⲈ ⲘⲠⲈⲐⲒⲦⲞⲨⲰϤ ⲈϨⲞⲨⲚ ⲈⲠⲀⲄⲀⲐⲞⲚ ⲚⲚⲀϨⲢⲘ ⲠⲔⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ⲔⲀⲒ ⲄⲀⲢ ⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲢⲀⲚⲀϤ ⲀⲚ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀⲚⲚⲞϬⲚⲈϬ ⲚⲚⲈⲦⲚⲞϬⲚⲈϬ ⲘⲘⲞⲔ ϨⲈ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ⲚⲈⲚⲦⲀⲨⲤϨⲀⲒⲤⲞⲨ ⲄⲀⲢ ⲚⲦⲀⲨⲤϨⲀⲒⲤⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲚⲤⲂⲰ. ϪⲈⲔⲀⲀⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲚⲐⲨⲠⲞⲘⲞⲚⲎ ⲘⲚ ⲠⲤⲞⲠⲤ ⲚⲚⲈⲄⲢⲀⲪⲎ ⲈⲚⲈϪⲠⲞ ⲚⲀⲚ ⲚⲐⲈⲖⲠⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚⲐⲨⲠⲞⲘⲞⲚⲎ ⲘⲚ ⲠⲤⲞⲠⲤ ⲈϤⲈϮ ⲚⲎⲦⲚ ⲈⲘⲈⲈⲨⲈ ⲈⲞⲨⲀ ⲚⲞⲨⲰⲦ ϨⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲔⲀⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ϪⲈⲔⲀⲀⲤ ϨⲒⲞⲨⲤⲞⲠ ϨⲚ ⲞⲨⲦⲀⲠⲢⲞ ⲚⲞⲨⲰⲦ ⲈⲦⲈⲦⲚⲈϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲠⲒⲰⲦ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ⲈⲦⲂⲈ ⲠⲀⲒ ϢⲈⲠ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲢⲰⲦⲚ ⲔⲀⲦⲀⲐⲈ ⲈⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϢⲞⲠⲚ ⲈⲢⲞϤ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲢⲆⲒⲀⲔⲞⲚⲞⲤ ⲘⲠⲤⲂⲂⲈ ϨⲀⲦⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲠⲦⲀϪⲢⲈⲚⲈⲢⲎⲦ ⲚⲚⲈⲒⲞⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ⲚϨⲈⲐⲚⲞⲤ ⲆⲈ ϨⲀ ⲞⲨⲚⲀ ⲈⲦⲢⲈⲨϮⲈⲞⲞⲨ ⲘⲠ ⲚⲞⲨⲦⲈ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲚⲀⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲚ ⲚⲒϨⲈⲐⲚⲞⲤ. ⲀⲨⲰ ϮⲚⲀⲮⲀⲖⲖⲈⲒ ⲈⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ⲀⲨⲰ ⲞⲚ ϢⲀϤϪⲞⲞⲤ ϪⲈ ⲈⲨⲪⲢⲀⲚⲈ ⲚϨⲈⲐⲚⲞⲤ ⲘⲚ ⲠⲈϤⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ⲀⲨⲰ ⲞⲚ ϢⲀϤⲆⲞⲞⲤ ϪⲈ ⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲤⲘⲞⲨ ⲈⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲘⲈⲢⲞⲨⲦⲀⲈⲒⲞϤ ⲚϬⲒ ⲚⲖⲀⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ϢⲀⲢⲈ ⲎⲤⲀⲒⲀⲤ ⲞⲚ ϪⲞⲞⲤ ϪⲈ ⲤⲚⲀϢⲰⲠⲈ ⲚϬⲒ ⲦⲚⲞⲨⲚⲈ ⲚⲒⲈⲤⲤⲀⲒ. ⲀⲨⲰ ⲠⲈⲦⲚⲀⲦⲰⲞⲨⲚ ⲈⲀⲢⲬⲒ ⲈⲚϨⲈⲐⲚⲞⲤ ⲚϨⲈⲐⲚⲞⲤ ⲚⲀϨⲈⲖⲠⲒⲌⲈ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚⲐⲈⲖⲠⲒⲤ ⲈϤⲈϪⲈⲔ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲚⲢⲀϢⲈ ⲚⲒⲘ ϨⲒⲈⲒⲢⲎⲚⲎ. ϨⲘ ⲠⲦⲢⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲦⲢⲈⲦⲚⲢϨⲞⲨⲞ ϨⲚ ⲐⲈⲖⲠⲒⲤ ϨⲚ ⲦϬⲞⲘ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ϮⲠⲒⲐⲈ ϨⲰ ϨⲀⲢⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲦⲈⲦⲚⲘⲈϨ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲘⲠⲠⲈⲦⲚⲀⲚⲞⲨϤ ⲈⲦⲈⲦⲚϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲤⲞⲞⲨⲚ ⲦⲎⲢϤ ⲈⲨⲚϬⲞⲘ ⲞⲚ ⲘⲘⲰⲦⲚ ⲈϮⲤⲂⲰ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ϨⲚ ⲞⲨⲦⲞⲖⲘⲀ ⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ⲀⲠⲞ ⲘⲈⲢⲞⲨⲤ ⲚⲀⲤⲚⲎⲨ. ⲈⲒⲦⲢⲈⲦⲚⲈⲒⲢⲈ ⲘⲠⲘⲈⲈⲨⲈ ⲈⲦⲂⲈ ⲦⲈⲬⲀⲢⲒⲤ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ");
INSERT INTO copshc_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ⲈⲦⲢⲀϢⲰⲠⲈ ⲚⲖⲒⲦⲞⲨⲢⲄⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲚϨⲈⲐⲚⲞⲤ. ⲈⲒϢⲘϢⲈ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ ϪⲈ ⲈⲢⲈⲦⲈ ⲠⲢⲞⲤⲪⲞⲢⲀ ⲚⲚϨⲈⲐⲚⲞⲤ ϢⲰⲠⲈ ⲈⲤϢⲎⲠ ⲈⲀⲨⲦⲂⲂⲞⲤ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ⲞⲨⲚⲦⲀⲒ ϬⲈ ⲘⲘⲀⲨ ⲘⲠϢⲞⲨϢⲞⲨ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ⲚⲈⲈⲒⲦⲞⲖⲘⲀ ⲄⲀⲢ ⲀⲚ ⲈϪⲈ ⲖⲀⲀⲨ ⲚϢⲀϪⲈ ⲈⲘⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ ⲈⲠⲤⲰⲦⲘ ⲚⲚϨⲈⲐⲚⲞⲤ. ϨⲘ ⲠϢⲀϪⲈ. ⲘⲚ ⲠϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ϨⲚ ⲦϬⲞⲘ ⲚϨⲈⲚⲘⲀⲈⲒⲚ ⲘⲚ ϨⲈⲚϢⲠⲎⲢⲈ ϨⲚ ⲦϬⲞⲘ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ϨⲰⲤⲦⲈ ⲀⲚⲞⲔ ϪⲒⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲘⲚ ⲠⲈⲤⲔⲰⲦⲈ ϢⲀϨⲢⲀⲒ ⲈⲠⲒⲖⲖⲨⲢⲒⲔⲞⲚ ⲈⲦⲢⲀϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ⲈⲈⲒⲢⲞⲞⲨⲦ ⲆⲈ ⲚⲦⲈⲈⲒϨⲈ ⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ϨⲘ ⲠⲘⲀ ⲀⲚ ⲈⲚⲦⲀⲨⲦⲀⲨⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚϨⲎⲦϤ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲀⲔⲰⲦ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲔⲈⲤⲚⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲚϬⲒ ⲚⲈⲦⲈⲘⲠⲞⲨϪⲰ ⲚⲀⲨ ⲈⲦⲂⲎⲎⲦϤ. ⲀⲨⲰ ⲤⲈⲚⲀⲈⲒⲘⲈ ⲚϬⲒ ⲚⲈⲦⲈⲘⲠⲞⲨⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ⲈⲦⲂⲈ ⲠⲀⲒ ⲢⲰ ⲚⲈⲈⲒϪⲒϪⲢⲞⲠ ⲠⲈ ⲚϨⲀϨ ⲚⲤⲞⲠ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ⲦⲈⲚⲞⲨ ⲆⲈ ⲘⲚϮ ⲘⲀ ϨⲚ ⲚⲈⲒⲔⲖⲒⲘⲀ. ⲈⲨⲚⲦⲀⲒ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲞⲨⲰϢ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ ⲈⲒⲤ ϨⲀϨ ⲚⲢⲞⲘⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ⲈⲒⲈⲒ ⲈⲒⲚⲀⲂⲰⲔ ⲈⲦⲈⲤⲠⲀⲚⲒⲀ ϮϨⲈⲖⲠⲒⲌⲈ ⲈⲒⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲦⲎⲨⲦⲚ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲚ ⲀⲨⲰ ⲚⲤⲈⲐⲠⲞⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲦⲎⲨⲦⲚ ⲈⲘⲀⲨ ⲈⲒϢⲀⲚⲤⲈⲒ ⲘⲘⲰⲦⲚ ⲚϢⲞⲢⲠ ⲀⲠⲞ ⲘⲈⲢⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ⲦⲈⲚⲞⲨ ⲆⲈ ⲈⲒⲚⲀⲂⲰⲔ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ⲈⲆⲒⲀⲔⲞⲚⲒ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ⲀⲨⲢϨⲚⲀⲨ ⲄⲀⲢ ⲚϬⲒ ⲚⲀⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲘⲚⲦⲀⲬⲀⲒⲀ ⲈⲈⲒⲢⲈ ⲚⲞⲨⲔⲞⲒⲚⲰⲚⲒⲀ ⲈⲚϨⲎⲔⲈ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ ⲈⲦϨⲚ ⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ⲀⲨⲢϨⲚⲀⲨ ⲄⲀⲢ ⲀⲨⲰ ⲞⲨⲚⲦⲀⲨⲤ ⲈⲢⲞⲞⲨ. ⲈϢϪⲈ ⲀⲚϨⲈⲐⲚⲞⲤ ⲄⲀⲢ ⲔⲞⲒⲚⲰⲚⲒ ⲈⲚⲈⲨⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ϢϢⲈ ⲞⲚ ⲈⲢⲞⲞⲨ ⲈϢⲘϢⲈ ⲚⲀⲨ ϨⲚ ⲚⲤⲀⲢⲔⲒⲔⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ⲠⲀⲒ ϬⲈ ⲈⲒϢⲀⲚϪⲞⲔϤ ⲈⲂⲞⲖ ⲦⲀⲤⲪⲢⲀⲄⲒⲌⲈ ⲚⲀⲨ ⲘⲠⲈⲒⲔⲀⲢⲠⲞⲤ. ϮⲚⲀⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒ ⲦⲈⲦⲎⲨⲦⲚ ⲈⲦⲈⲤⲠⲀⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ϮⲤⲞⲞⲨⲚ ⲆⲈ ϪⲈ ⲈⲒⲚⲎⲨ ϢⲀⲢⲰⲦⲚ ⲈⲈⲒⲚⲎⲨ ϨⲚ ⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚⲤⲘⲞⲨ ⲚⲦⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲀⲄⲀⲠⲎ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ⲈⲦⲢⲈⲦⲚⲀⲄⲰⲚⲒⲌⲈ ⲚⲘⲘⲀⲒ ϨⲚ ⲚⲈϢⲖⲎⲖ ϨⲀⲢⲞⲒ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ϪⲈⲔⲀⲀⲤ ⲈⲒⲈⲚⲞⲨϨⲘ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲦⲞ ⲚⲀⲦⲚⲀϨⲦⲈ ϨⲚ ϮⲞⲨⲆⲀⲒⲀ. ⲀⲨⲰ ⲚⲦⲈⲦⲀⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲦϢⲞⲞⲠ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ ϢⲰⲠⲈ ⲈⲤϢⲎⲠ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ϪⲈⲔⲀⲀⲤ ⲈⲈⲒϢⲀⲚⲈⲒ ϢⲀⲢⲰⲦⲚ ϨⲚ ⲞⲨⲢⲀϢⲈ ϨⲒⲦⲘ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲒⲈⲘⲦⲞⲚ ⲘⲘⲞⲒ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ⲈⲢⲈⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚϮⲢⲎⲚⲎ ϢⲰⲠⲈ ⲚⲘⲘⲎⲦⲚ ⲦⲎⲢⲦⲚ ϨⲀⲘⲎⲚ ");
INSERT INTO copshc_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ϮⲤⲨⲚϨⲒⲤⲦⲀ ⲆⲈ ⲚⲎⲦⲚ ⲘⲪⲞⲒⲂⲎ ⲦⲈⲚⲤⲰⲚⲈ ⲈⲦⲢⲈϤϢⲘϢⲈ ⲦⲈ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϨⲚ ⲔⲈⲄⲬⲢⲈⲀⲒⲤ ");
INSERT INTO copshc_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ϪⲈ ⲈⲦⲈⲦⲚⲈϢⲞⲠⲤ ⲈⲢⲰⲦⲚ ϨⲘ ⲠϪⲞⲈⲒⲤ ϨⲚ ⲞⲨⲘⲠϢⲀ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ⲚⲘⲘⲀⲤ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲈⲦⲤⲚⲀⲀϨⲈ ⲚⲎⲦⲚ ⲘⲘⲞⲞⲨ. ⲔⲀⲒ ⲄⲀⲢ ⲚⲦⲞⲤ ϨⲰⲰⲤ ⲀⲤⲀϨⲈⲢⲀⲦⲤ ⲘⲚ ⲞⲨⲘⲎⲎϢⲈ ⲀⲨⲰ ⲚⲘⲘⲀⲒ ϨⲰ. ");
INSERT INTO copshc_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ϢⲒⲚⲈ ⲈⲠⲢⲒⲤⲔⲀ ⲘⲚ ⲀⲔⲨⲖⲀ ⲚⲀϢⲂⲢ ⲢϨⲰⲂ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ⲚⲀⲒ ⲈⲚⲦⲀⲨⲔⲰ ⲘⲠⲈⲨⲘⲀⲔϨ ϨⲀ ⲦⲀⲮⲨⲬⲎ. ⲚⲀⲒ ⲈϮϢⲠϨⲘⲞⲦ ⲚⲦⲞⲞⲦⲞⲨ ⲀⲚⲞⲔ ⲘⲀⲨⲀⲀⲦ ⲀⲚ. ⲀⲖⲖⲀ ⲚⲔⲈⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲚϨⲈⲐⲚⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ⲘⲚ ⲦⲤⲞⲞⲨϨⲤ ⲈⲦϨⲘ ⲠⲈⲨⲎⲈⲒ. ϢⲒⲚⲈ ⲈⲠⲀⲒⲚⲈⲦⲞⲤ ⲠⲀⲘⲈⲢⲒⲦ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠϢⲞⲢⲠ ϨⲚ ⲦⲀⲤⲒⲀ ⲈϨⲞⲨⲚ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ϢⲒⲚⲈ ⲈⲘⲀⲢⲒⲀ ⲦⲀⲒ ⲈⲚⲦⲀⲤϢⲠ ϨⲀϨ ⲚϨⲒⲤⲈ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ϢⲒⲚⲈ ⲈⲀⲚⲆⲢⲞⲚⲒⲔⲞⲤ ⲘⲚ ⲒⲞⲨⲚⲒⲀ ⲚⲀⲤⲨⲄⲄⲈⲚⲎⲤ ⲀⲨⲰ ⲚⲀϢⲂⲢⲀⲒⲬⲘⲀⲖⲰⲦⲞⲤ ⲚⲀⲒ ⲈⲦⲞⲨϮⲘⲀⲈⲒⲚ ⲈⲢⲞⲞⲨ ϨⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲰ ⲈⲀⲨϢⲰⲠⲈ ϨⲀⲦⲀϨⲎ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ϢⲒⲚⲈ ⲈⲀⲘⲠⲖⲒⲀⲤ ⲠⲀⲘⲈⲢⲒⲦ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ϢⲒⲚⲈ ⲈⲞⲨⲢⲂⲀⲚⲞⲤ ⲠⲈⲚϢⲂⲢⲢϨⲰⲂ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲚ ⲤⲦⲀⲬⲨⲤ ⲠⲀⲘⲈⲢⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ϢⲒⲚⲈ ⲈⲀⲠⲈⲖⲖⲎⲤ ⲠⲤⲰⲦⲠ ϨⲘ ⲠϪⲞⲈⲒⲤ. ϢⲒⲚⲈ ⲈⲚⲀⲠⲎⲈⲒ ⲚⲀⲢⲒⲤⲦⲞⲂⲞⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ϢⲒⲚⲈ ⲈϨⲎⲢⲰⲆⲒⲰⲚ ⲠⲀⲤⲨⲄⲄⲈⲚⲎⲤ. ϢⲒⲚⲈ ⲈⲚⲀ ⲠⲎⲒ ⲚⲀⲢⲔⲒⲤⲤⲞⲤ ⲚⲈⲦϢⲞⲞⲠ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ϢⲒⲚⲈ ⲈⲦⲢⲨⲪⲰⲤⲀ ⲘⲚ ⲦⲢⲨⲪⲀⲒⲚⲀ ⲚⲀⲒ ⲈⲦϢⲠⲌⲒⲤⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ. ϢⲒⲚⲈ ⲈⲠⲈⲢⲤⲒⲤ ⲦⲘⲈⲢⲒⲦ ⲦⲀⲒ ⲈⲚⲦⲀⲤϢⲠ ϨⲀϨ ⲚϨⲒⲤⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ϢⲒⲚⲈ ⲈϨⲢⲞⲨⲪⲞⲤ ⲠⲘⲈⲢⲒⲦ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲘⲚ ⲦⲈϤⲘⲀⲀⲨ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ϢⲒⲚⲈ ⲈⲀⲤⲨⲄⲔⲢⲒⲦⲞⲤ ⲘⲚ ⲪⲖⲈⲄⲰⲚ ⲘⲚ ϨⲈⲢⲘⲎ ⲘⲚ ⲠⲀⲦⲢⲞⲂⲀ ⲘⲚ ϨⲈⲢⲘⲀ ⲀⲨⲰ ⲚⲈⲤⲚⲎⲨ ⲦⲎⲢⲞⲨ ⲈⲦⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ϢⲒⲚⲈ ⲈⲪⲒⲖⲞⲖⲞⲄⲞⲤ ⲘⲚ ⲒⲞⲨⲖⲒⲀ ⲀⲨⲰ ⲚⲎⲢⲈⲀⲤ ⲘⲚ ⲦⲈϤⲤⲰⲚⲈ. ⲀⲨⲰ ⲞⲖⲨⲘⲠⲀ ⲘⲚ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲦⲎⲢⲞⲨ ⲈⲦⲚⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ⲀⲤⲠⲀⲌⲈ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ϨⲚ ⲞⲨⲠⲒ ⲈⲤⲞⲨⲀⲀⲂ. ⲤⲈϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲈⲦⲢⲈⲦⲚϬⲰϢⲦ ⲈⲚⲈⲦⲈⲒⲢⲈ ⲚⲘⲠⲰⲢϪ ⲘⲚ ⲚⲈⲤⲔⲀⲚⲆⲀⲖⲞⲚ. ⲠⲀⲢⲀ ⲦⲈⲤⲂⲰ ⲈⲚⲦⲀ ⲦⲈⲦⲚϪⲒⲤⲂⲰ ⲈⲢⲞⲤ ⲚⲦⲈⲦⲚ ⲤⲀϨⲈ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ⲚⲀⲒ ⲄⲀⲢ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲚⲤⲈⲞ ⲀⲚ ⲚϨⲘϨⲀⲖ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ⲈⲨⲞ ⲚϨⲎⲦⲞⲨ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲨϬⲒⲚϢⲀϪⲈ ⲈⲦϨⲞⲖϬ ⲘⲚ ⲠⲈⲤⲘⲞⲨ ϢⲀⲨⲈⲜⲀⲠⲀⲦⲀ ⲘⲠϨⲎⲦ ⲚⲚⲂⲀⲖϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ⲀⲦⲈⲦⲚⲘⲚⲦⲤⲦⲘⲎⲦ ⲄⲀⲢ ⲠⲰϨ ϢⲀ ⲞⲨⲞⲚ ⲚⲒⲘ. ϮⲢⲀϢⲈ ϬⲈ ⲈϪⲰⲦⲚ. ϮⲞⲨⲰϢ ⲆⲈ ⲈⲦⲢⲈⲦⲚϢⲰⲠⲈ ⲚⲤⲞⲪⲞⲤ ⲈⲠⲀⲄⲀⲐⲞⲚ ⲚⲀⲔⲈⲢⲀⲒⲞⲤ ⲆⲈ ⲈⲠⲠⲈⲐⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚϮⲢⲎⲚⲎ ⲚⲀⲞⲨϢϤ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ϨⲀ ⲚⲈⲦⲚⲞⲨⲈⲢⲎⲦⲈ ϨⲚ ⲞⲨϬⲈⲠⲎ. ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ϤϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲠⲀϢⲂⲢ ⲢϨⲰⲂ. ⲘⲚ ⲖⲞⲨⲔⲒⲞⲤ ⲘⲚ ⲒⲀⲤⲤⲰⲚ. ⲀⲨⲰ ⲤⲰⲤⲒⲠⲀⲦⲢⲞⲤ ⲚⲀⲤⲨⲄⲄⲈⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ϮϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲀⲚⲞⲔ ⲦⲈⲢⲦⲒⲞⲤ ⲠⲈⲚⲦⲀϤⲤϨⲀⲒ ⲚⲦⲈⲒⲈⲠⲒⲤⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ϤϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲄⲀⲒⲞⲤ ⲠⲈϢⲀⲒϬⲞⲒⲖⲈ ⲈⲢⲞϤ ⲘⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ϤϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲈⲢⲀⲤⲦⲞⲤ ⲠⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲦⲠⲞⲖⲒⲤ ⲘⲚ ⲔⲞⲨⲀⲢⲦⲞⲤ ⲠⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","— ");
INSERT INTO copshc_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ⲠⲈⲦⲈ ⲞⲨⲚϬⲞⲘ ⲆⲈ ⲘⲘⲞϤ ⲈⲦⲀϪⲢⲈ ⲦⲎⲨⲦⲚ ⲔⲀⲦⲀ ⲠⲀⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲚ ⲠⲦⲀϢⲈⲞⲈⲒϢ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲔⲀⲦⲀ ⲠϬⲰⲖⲠ ⲈⲂⲞⲖ ⲘⲠⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲈⲚⲦⲀⲨⲔⲀⲢⲰⲞⲨ ⲈⲢⲞϤ ϨⲚ ⲚⲈⲨⲞⲈⲒϢ ⲚⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ⲈⲀϤⲞⲨⲰⲚϨ ⲆⲈ ⲈⲂⲞⲖ ⲦⲈⲚⲞⲨ ϨⲒⲦⲚ ⲚⲈⲄⲢⲀⲪⲎ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲔⲀⲦⲀ ⲠⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲚϢⲀ ⲈⲚⲈϨ. ⲈⲠⲤⲰⲦⲘ ⲚⲦⲠⲒⲤⲦⲒⲤ ⲚⲚϨⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ⲈϤⲞⲨⲰⲚϨ ");
INSERT INTO copshc_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ⲈⲠⲚⲞⲨⲦⲈ ⲚⲤⲞⲪⲞⲤ ⲘⲀⲨⲀⲀϤ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲒ ⲈⲦⲈⲠⲰϤ ⲠⲈ ⲠⲈⲞⲞⲨ ϢⲀ ⲚⲒⲈⲚⲈϨ ϨⲀⲘⲎⲚ ");
INSERT INTO copshc_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦⲦⲀϨⲘ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ϨⲒⲦⲘ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲤⲰⲤⲐⲈⲚⲎⲤ ⲠⲤⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ⲈⲨⲤϨⲀⲒ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀⲒ ⲈⲦϢⲞⲞⲠ ϨⲚ ⲔⲞⲢⲒⲚⲐⲞⲤ. ⲚⲈⲦⲦⲂⲂⲎⲨ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲚⲈⲦⲦⲀϨⲘ ⲈⲦⲞⲨⲀⲀⲂ. ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲘ ⲘⲀ ⲚⲒⲘ ⲚⲦⲀⲨ ⲚⲘⲘⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ⲦⲈⲬⲀⲢⲒⲤ ⲚⲎⲦⲚ ⲘⲚ ϮⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲈⲒⲰⲦ ⲘⲚ ⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ϮϢⲠϨⲘⲞⲦ ⲚⲦⲘ ⲠⲀⲚⲞⲨⲦⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲀⲢⲰⲦⲚ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀⲒ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ⲚⲎⲦⲚ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ϪⲈ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲀⲦⲈⲦⲚⲢⲢⲘⲘⲀⲞ ⲚϨⲎⲦϤ. ϨⲚ ϢⲀϪⲈ ⲚⲒⲘ ⲘⲚ ⲤⲞⲞⲨⲚ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀϪⲢⲞ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ϨⲰⲤⲦⲈ ⲈⲦⲘⲦⲢⲈⲦⲚϢⲰⲰⲦ ⲚⲖⲀⲀⲨ ⲚϨⲘⲞⲦ ⲈⲦⲈⲦⲚϬⲰϢⲦ ϨⲎⲦϤ ⲘⲠϬⲰⲖⲠ ⲈⲂⲞⲖ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ⲠⲀⲒ ⲈⲦⲚⲀⲦⲀϪⲢⲈ ⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚϪⲎⲔ ⲈⲂⲞⲖ ⲈⲘⲚ ⲚⲞⲂⲈ ϪⲒ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ϢⲀ ⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ⲞⲨⲠⲒⲤⲦⲞⲤ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈⲚⲦⲀϤⲦⲈϨⲘ ⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲈⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲘⲠⲈϤϢⲎⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ⲦⲚⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲈⲤⲚⲎⲨ ϨⲒⲦⲘ ⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈϪⲰ ⲘⲠⲒϢⲀϪⲈ ⲚⲞⲨⲰⲦ ⲦⲎⲢⲦⲚ. ⲚⲦⲈⲦⲘⲠⲰⲢϪ ϢⲰⲠⲈ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲆⲈ ⲈⲦⲈⲦⲚⲤⲂⲦⲰⲦ ϨⲘ ⲠⲒϨⲎⲦ ⲚⲞⲨⲰⲦ ⲘⲚϮⲄⲚⲰⲘⲎ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ⲀⲨⲦⲀⲘⲞⲒ ⲄⲀⲢ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲨⲦⲞⲨ ⲚⲚⲀⲬⲖⲞⲎ ϪⲈ ⲞⲨⲚ ϨⲈⲚϮⲦⲰⲚ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ϮϪⲰ ⲆⲈ ⲘⲠⲀⲒ ϪⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲰⲦⲚ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲄ ⲠⲀ ⲠⲀⲨⲖⲞⲤ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲄ ⲠⲀ ⲀⲠⲞⲖⲖⲰ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲄ ⲠⲀ ⲔⲎⲪⲀ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲄ ⲠⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ⲘⲎ ⲚⲦⲀⲨⲠⲰϢ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲘⲎ ⲚⲦⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲠⲀⲨⲖⲞⲤ ϨⲀⲢⲰⲦⲚ. ⲎⲚⲦⲀⲦⲈⲦⲚϪⲒ ⲂⲀⲠⲦⲒⲤⲘⲀ ⲈⲠⲢⲀⲚ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ϮϢⲠϨⲘⲞⲦ ϪⲈ ⲘⲠⲒⲂⲀⲠⲦⲒⲌⲈ ⲚⲖⲀⲀⲨ ⲘⲘⲰⲦⲚ ⲚⲤⲀ ⲔⲢⲒⲤⲠⲞⲤ ⲘⲚ ⲄⲀⲒⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈ ⲞⲨⲀ ϪⲞⲞⲤ ϪⲈ ⲚⲦⲀⲦⲈⲦⲚⲂⲀⲠⲦⲒⲌⲈ ⲈⲠⲀⲢⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ⲀⲒⲂⲀⲠⲦⲒⲌⲈ ⲆⲈ ⲘⲠⲔⲈⲎⲈⲒ ⲚⲤⲦⲈⲪⲀⲚⲀ ⲘⲚⲚⲤⲰⲤ ϬⲈ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲀⲒⲂⲀⲠⲦⲒⲌⲈ ⲚϬⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲄⲀⲢ ⲦⲚⲚⲞⲞⲨⲦ ⲀⲚ ⲈⲂⲀⲠⲦⲒⲌⲈ ⲀⲖⲖⲀ ⲈⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ϨⲚ ⲞⲨⲤⲞⲪⲒⲀ ⲀⲚ ⲚϢⲀϪⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈϤϢⲰⲠⲈ ⲈϤϢⲞⲨⲈⲒⲦ ⲚϬⲒ ⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ⲠϢⲀϪⲈ ⲄⲀⲢ ⲘⲠⲈⲤⲦⲀⲨⲢⲞⲤ ⲞⲨⲘⲚⲦⲤⲞϬ ⲘⲈⲚ ⲠⲈ ⲚⲚⲈⲦⲚⲀϨⲈ ⲈⲂⲞⲖ. ⲚⲀⲚ ⲆⲈ ⲚⲈⲦⲚⲀⲞⲨϪⲀⲒ. ⲞⲨϬⲞⲘ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ϮⲚⲀⲦⲀⲔⲞ ⲚⲦⲤⲞⲪⲒⲀ ⲚⲚⲤⲞⲪⲞⲤ. ⲦⲀⲀⲐⲈⲦⲈⲒ ⲚⲦⲘⲚⲦⲤⲀⲂⲈ ⲚⲚⲤⲀⲂⲈⲈⲨ. ");
INSERT INTO copshc_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ⲈϤⲦⲰⲚ ⲤⲞⲪⲞⲤ ⲈϤⲦⲰⲚ ⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲈϤⲦⲰⲚ ⲤⲨⲚⲌⲎⲦⲎⲦⲎⲤ ⲚⲦⲈ ⲠⲈⲒⲀⲒⲰⲚ ⲘⲎ ⲘⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲒⲢⲈ ⲚⲦⲤⲞⲪⲒⲀ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲚⲤⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ⲈⲠⲈⲒⲆⲎ ⲄⲀⲢ ϨⲚ ⲦⲤⲞⲪⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲚ ⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲚ ⲦⲤⲞⲪⲒⲀ. ⲀϤⲢϨⲚⲀϤ ⲆⲈ ⲚϬⲒ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲨϪⲈ ⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ϨⲒⲦⲚ ⲦⲘⲚⲦⲤⲞϬ ⲘⲠⲦⲀϢⲈⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ⲈⲠⲈⲒⲆⲎ ⲚⲒⲞⲨⲆⲀⲒ ϨⲈⲚⲘⲀⲈⲒⲚ ⲚⲈⲦⲞⲨⲀⲒⲦⲒ ⲘⲘⲞⲞⲨ. ⲚϨⲈⲖⲖⲎⲚ ⲆⲈ ⲈⲨϢⲒⲚⲈ ⲚⲤⲀ ⲞⲨⲤⲞⲪⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ⲀⲚⲞⲚ ⲆⲈ ⲈⲚⲦⲀϢⲈⲞⲒϢ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ⲚⲒⲞⲨⲆⲀⲒ ⲘⲈⲚ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲀⲨ ⲠⲈ. ⲞⲨⲘⲚⲦⲤⲞϬ ⲆⲈ ⲠⲈ ⲚⲚϨⲈⲐⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲈⲦⲦⲀϨⲘ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲞⲨϬⲞⲘ ⲚⲀⲨ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ⲀⲨⲰ ⲤⲞⲪⲒⲀ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ϪⲈ ⲦⲘⲚⲦⲤⲞϬ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲞⲨⲘⲚⲦⲤⲀⲂⲈ ⲦⲈ ⲚϨⲞⲨⲞ ⲈⲚⲢⲰⲘⲈ. ⲀⲨⲰ ⲦⲘⲚⲦϬⲰⲂ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲤϪⲞⲞⲢ ⲚϨⲞⲨⲞ ⲈⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ⲦⲈⲦⲚϬⲰϢⲦ ⲄⲀⲢ ⲈⲠⲈⲦⲚⲦⲰϨⲘ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲘⲚ ϨⲀϨ ⲚⲤⲞⲪⲞⲤ ⲚϨⲎⲦϤ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲘⲚ ϨⲀϨ ⲚⲆⲨⲚⲀⲦⲞⲤ. ⲘⲚ ϨⲀϨ ⲚⲈⲨⲄⲈⲚⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ⲀⲖⲖⲀ ⲚⲤⲞϬ ⲚⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲤⲞⲦⲠⲞⲨ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϮϢⲒⲠⲈ ⲚⲚⲤⲀⲂⲈⲈⲨ. ⲀⲨⲰ ⲚϬⲰⲂ ⲚⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲤⲞⲦⲠⲞⲨ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈϮϢⲒⲠⲈ ⲚⲚϪⲰⲰⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ⲀⲨⲰ ⲚϨⲎⲔⲈ ⲚⲦⲈ ⲠⲔⲞⲤⲘⲞⲤ ⲘⲚ ⲚⲈⲦⲤⲞϢϤ ⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲤⲞⲦⲠⲞⲨ. ⲚⲈⲦⲈⲚⲤⲈϢⲞⲞⲠ ⲀⲚ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲔⲀⲦⲀⲢⲄⲈⲒ ⲚⲚⲈⲦϢⲞⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ϪⲈ ⲚⲚⲈ ⲖⲀⲀⲨ ⲚⲤⲀⲢⲜ ϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲈⲂⲞⲖ ⲚϨⲎⲦϤ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲀⲒ ⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚⲀⲚ ⲚⲤⲞⲪⲒⲀ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲀⲨⲰ ⲚⲦⲂⲂⲞ ⲀⲨⲰ ⲚⲤⲰⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲠⲈⲦϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ⲘⲀⲢⲈϤϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ⲀⲚⲞⲔ ⲆⲈ ϨⲰ ⲚⲦⲈⲢⲒⲈⲒ ϢⲀⲢⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲚⲦⲀⲒⲈⲒ ϨⲚ ⲞⲨϪⲒⲤⲈ ⲀⲚ ⲚϢⲀϪⲈ ⲎⲚⲤⲞⲪⲒⲀ ⲈⲒϪⲰ ⲈⲢⲰⲦⲚ ⲚⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ⲘⲠⲒⲘⲈⲈⲨⲈ ⲄⲀⲢ ϪⲈ ϮⲤⲞⲞⲨⲚ ⲚⲖⲀⲀⲨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲨⲰ ⲠⲀⲒ ⲈⲀⲨⲤⲦⲀⲨⲢⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ⲀⲚⲞⲔ ϨⲰ ⲚⲦⲀⲒⲈⲒ ϢⲀⲢⲰⲦⲚ ϨⲚ ⲞⲨⲘⲚⲦϬⲰⲂ. ⲘⲚ ⲞⲨϨⲞⲦⲈ. ⲘⲚ ⲞⲨⲤⲦⲰⲦ ⲈⲚⲀϢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ⲀⲨⲰ ⲠⲀϢⲀϪⲈ ⲘⲚ ⲠⲀⲦⲀϢⲈⲞⲈⲒϢ ⲚⲦⲀϤϢⲰⲠⲈ ⲀⲚ ϨⲚ ⲞⲨⲠⲒⲐⲈ ⲚⲤⲞⲪⲒⲀ ⲚϢⲀϪⲈ. ⲀⲖⲖⲀ ϨⲚ ⲞⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲚⲈⲨⲘⲀ ϨⲒ ϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲦⲚⲠⲒⲤⲦⲒⲤ ϢⲰⲠⲈ ϨⲚ ⲞⲨⲠⲒ ⲐⲈ ⲚⲤⲞⲪⲒⲀ ⲚⲢⲰⲘⲈ ⲀⲖⲖⲀ ϨⲚ ⲞⲨϬⲞⲘ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ⲈⲚϢⲀϪⲈ ⲆⲈ ⲚⲞⲨⲤⲞⲪⲒⲀ ϨⲚ ⲚⲦⲈⲖⲈⲒⲞⲤ ⲞⲨⲤⲞⲪⲒⲀ ⲆⲈ ⲈⲚⲦⲀ ⲠⲈⲒⲀⲒⲰⲚ ⲀⲚ ⲦⲈ ⲞⲨⲆⲈ ⲚⲦⲀ ⲚⲀⲢⲬⲰⲚ ⲀⲚ ⲦⲈ ⲘⲠⲈⲒⲀⲒⲰⲚ ⲚⲀⲒ ⲈⲦⲚⲀⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ⲀⲖⲖⲀ ⲈⲚϢⲀϪⲈ ⲚⲞⲨⲤⲞⲪⲒⲀ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲘⲨⲤⲦⲎⲢⲒⲞⲚ. ⲦⲀⲒ ⲈⲦϨⲎⲠ ⲦⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲠⲞⲢϪⲤ ⲈⲂⲞⲖ ϨⲀⲐⲎ ⲚⲚⲀⲒⲰⲚ ⲈⲠⲈⲚⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ⲦⲀⲒ ⲈⲦⲈⲘⲠⲈ ⲖⲀⲀⲨ ⲚⲀⲢⲬⲰⲚ ⲚⲦⲈ ⲠⲈⲒⲀⲒⲰⲚ ⲤⲞⲨⲰⲚⲤ. ⲈⲚⲈⲚⲦⲀⲨⲤⲞⲨⲰⲚⲤ ⲄⲀⲢ ⲚⲈⲨⲚⲀⲤⲦⲀⲨⲢⲞⲨ ⲀⲚ ⲠⲈ ⲘⲠϪⲞⲈⲒⲤ ⲘⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲚⲈⲦⲈ ⲘⲠⲈ ⲂⲀⲖ ⲚⲀⲨ ⲈⲢⲞⲞⲨ. ⲚⲈⲦⲈ ⲘⲠⲈ ⲘⲀⲀϪⲈ ⲤⲞⲦⲘⲞⲨ. ⲚⲈⲦⲈ ⲘⲠⲞⲨⲀⲖⲈ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠϨⲎⲦ ⲚⲢⲰⲘⲈ ⲚⲀⲒ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲤⲂⲦⲰⲦⲞⲨ ⲚⲚⲈⲦⲘⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ⲀⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ϬⲞⲖⲠⲞⲨ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲠⲈⲠⲚⲈⲨⲘⲀ ⲄⲀⲢ ϨⲞⲦϨⲦ ⲚⲚⲔⲀ ⲚⲒⲘ ⲀⲨⲰ ⲚⲈⲐⲎⲠ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ⲚⲒⲘ ⲄⲀⲢ ⲚⲢⲰⲘⲈ ⲠⲈⲦⲤⲞⲞⲨⲚ ⲚⲚⲀ ⲠⲢⲰⲘⲈ ⲈⲒⲘⲎⲦⲒ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲚϨⲎⲦϤ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲚⲚⲀ ⲠⲚⲞⲨⲦⲈ ⲘⲠⲈ ⲖⲀⲀⲨ ⲤⲞⲨⲰⲚⲞⲨ ⲚⲤⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ⲀⲚⲞⲚ ⲆⲈ ⲚⲦⲀⲚϪⲒ ⲀⲚ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲈⲈⲒⲔⲞⲤⲘⲞⲤ. ⲀⲖⲖⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲠⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ϪⲈⲔⲀⲀⲤ ⲈⲚⲈⲈⲒⲘⲈ ⲈⲚⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲬⲀⲢⲒⲌⲈ ⲘⲘⲞⲞⲨ ⲚⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ⲈⲦⲈ ⲚⲀⲒ ⲚⲈⲦⲚϢⲀϪⲈ ⲚϨⲎⲦⲞⲨ ϨⲚ ϨⲈⲚϢⲀϪⲈ ⲀⲚ ⲚϮⲤⲂⲰ ⲚⲤⲞⲪⲒⲀ ⲚⲢⲰⲘⲈ ⲀⲖⲖⲀ ϨⲚ ϨⲈⲚϮⲤⲂⲰ ⲘⲠⲚⲈⲨⲘⲀ ⲈⲚϢⲰⲚⲂ ⲚϨⲈⲚⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲈϨⲈⲚⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ⲞⲨⲮⲨⲬⲒⲔⲞⲤ ⲆⲈ ⲚⲢⲰⲘⲈ ⲘⲈϤϢⲰⲠ ⲈⲢⲞϤ ⲚⲚⲀ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ. ⲞⲨⲘⲚⲦⲤⲞϬ ⲄⲀⲢ ⲚⲀϤ ⲦⲈ. ⲀⲨⲰ ⲘⲚϬⲞⲘ ⲘⲘⲞϤ ⲈⲈⲒⲘⲈ ϪⲈ ⲤⲈⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ⲠⲚⲈⲨⲘⲀⲦⲒⲔⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ⲠⲈⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲤ ⲆⲈ ϢⲀϤⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲈⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲘ. ⲚⲦⲞϤ ⲆⲈ ⲘⲈⲢⲈ ⲖⲀⲀⲨ ⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲚⲦⲀϤⲤⲞⲨⲚ ⲠϨⲎⲦ ⲘⲠϪⲞⲈⲒⲤ ⲠⲀⲒ ⲈⲦⲚⲀⲦⲤⲈⲂⲈⲈⲒⲀⲦϤ ⲈⲂⲞⲖ. ⲀⲚⲞⲚ ⲆⲈ ⲞⲨⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲘⲠⲘⲈⲈⲨⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ⲀⲚⲞⲔ ϨⲰ ⲚⲀⲤⲚⲎⲨ ⲘⲠⲒϢϬⲘϬⲞⲘ ⲈϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ϨⲰⲤ ⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲤ. ⲀⲖⲖⲀ ϨⲰⲤ ⲤⲀⲢⲔⲒⲔⲞⲤ ϨⲰⲤ ⲔⲞⲨⲒ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ⲀⲒⲦⲤⲈⲦⲚ ⲈⲢⲰⲦⲈ ⲚⲞⲨϨⲢⲈ ⲀⲚ. ⲚⲈ ⲘⲠⲀⲦⲈⲦⲚⲈϢϬ ⲘϬⲞⲘ ⲄⲀⲢ ⲠⲈ. ⲀⲖⲖⲀ ⲦⲈⲚⲞⲨ ⲞⲚ ⲈⲘⲠⲀⲦⲈⲦⲚⲈϢϬⲘϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ⲈⲦⲈⲒ ⲄⲀⲢ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲀⲢⲔⲒⲔⲞⲤ ϨⲞⲠⲞⲨ ⲄⲀⲢ ⲞⲨⲚⲔⲰϨ ϨⲒ ϮⲦⲰⲚ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲘⲎ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲀⲢⲔⲒⲔⲞⲤ ⲀⲚ. ⲀⲨⲰ ⲈⲦⲈⲦⲚⲘⲞⲞϢⲈ ⲔⲀⲦⲀ ⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ϨⲞⲦⲀⲚ ⲄⲀⲢ ⲈⲢϢⲀⲚ ⲞⲨⲀ ϪⲞⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲄ ⲠⲀ ⲠⲀⲨⲖⲞⲤ. ⲔⲈⲞⲨⲀ ⲆⲈ ϪⲈ ⲀⲚⲄ ⲠⲀ ⲀⲠⲞⲖⲖⲰ. ⲘⲎ ⲚⲦⲈⲦⲚ ϨⲈⲚⲢⲰⲘⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ⲞⲨ ϬⲈ ⲠⲈ ⲀⲠⲞⲖⲖⲰ ⲞⲨ ⲆⲈ ⲠⲈ ⲠⲀⲨⲖⲞⲤ ⲀⲖⲖⲀ ϨⲈⲚⲆⲒⲀⲔⲰⲚ ⲚⲈ ⲈⲀⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲞⲨ ⲀⲨⲰ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ϮⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ⲀⲚⲞⲔ ⲀⲒⲦⲰϬⲈ ⲀⲠⲞⲖⲖⲰ ⲠⲈⲚⲦⲀϤⲦⲤⲞ. ⲀⲖⲖⲀ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲦⲀϤⲀⲨⲜⲀⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ϨⲰⲤⲦⲈ ϬⲈ ⲘⲠⲀ ⲠⲈⲦⲦⲰϬⲈ ⲀⲚ ⲠⲈ ⲞⲨⲆⲈ ⲘⲠⲀ ⲠⲈⲦⲦⲤⲞ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲈⲦⲀⲨⲜⲀⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ⲠⲈⲦⲦⲰϬⲈ ⲆⲈ ⲘⲚ ⲠⲈⲦⲦⲤⲞ ⲞⲨⲀ ⲚⲈ. ⲠⲞⲨⲀ ⲆⲈ ⲠⲞⲨⲀ ⲚⲀϪⲒ ⲘⲠⲈϤⲂⲈⲔⲈ ⲔⲀⲦⲀ ⲠⲈϤϨⲒⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ⲀⲚⲞⲚ ϨⲈⲚϢⲂⲢⲢϨⲰⲂ ⲄⲀⲢ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲞⲨⲘⲀ ⲚⲞⲨⲞⲈⲒⲈ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ⲚⲦⲈⲦⲚ ⲞⲨⲔⲰⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ⲔⲀⲦⲀ ⲠⲈϨⲘⲞⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲈⲚⲦⲀⲨⲦⲀⲀϤ ⲚⲀⲒ ϨⲰⲤ ⲤⲞⲪⲞⲤ ⲚⲀⲢⲬⲒⲦⲈⲔⲦⲰⲚ. ⲀⲒⲔⲰ ⲈϨⲢⲀⲒ ⲚⲦⲤⲚⲦⲈ ⲞⲨⲚϬⲈ ⲆⲈ ⲔⲰⲦ ⲈϪⲰⲤ. ⲠⲞⲨⲀ ⲆⲈ ⲠⲞⲨⲀ ⲘⲀⲢⲈϤϬⲰϢⲦ ϪⲈ ⲈϤⲔⲰⲦ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ⲘⲚϬⲞⲘ ⲄⲀⲢ ⲚⲖⲀⲀⲨ ⲈⲔⲀⲔⲈⲤⲚⲦⲈ ⲈϨⲢⲀⲒ ⲠⲀⲢⲀⲦⲈⲦⲔⲎ ⲈϨⲢⲀⲒ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ⲈϢϪⲈ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ⲚⲀⲔⲰⲦ ⲈϪⲚ ⲦⲈⲒⲤⲚⲦⲈ ⲞⲨⲚⲞⲨⲂ ⲞⲨϨⲀⲦ ϨⲈⲚⲈⲚⲈⲘⲘⲈ ϨⲈⲚϢⲈ ⲞⲨⲬⲞⲢⲦⲞⲤ ⲞⲨⲢⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ⲠϨⲰⲂ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲠⲈϨⲞⲞⲨ ⲄⲀⲢ ⲚⲀⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϪⲈ ⲈϤⲚⲀϬⲰⲖⲠ ⲈⲂⲞⲖ ϨⲚ ⲦⲤⲀⲦⲈ ⲀⲨⲰ ⲠϨⲰⲂ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲐⲈ ⲈⲦϤⲞ ⲘⲘⲞⲤ ⲠⲔⲰϨⲦ ⲠⲈⲦⲚⲀⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϨⲰⲂ ⲚⲀϬⲰ ⲠⲀⲒ ⲈⲚⲦⲀϤⲔⲞⲦϤ ϤⲚⲀϪⲒ ⲚⲞⲨⲂⲈⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ⲠⲈⲦⲈⲢⲈ ⲠⲈϤϨⲰⲂ ⲚⲀⲢⲰⲔϨ ϤⲚⲀϮⲞⲤⲈ. ⲚⲦⲞϤ ⲆⲈ ϤⲚⲀⲞⲨϪⲀⲒ. ⲚⲦⲈⲒϨⲈ ⲆⲈ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲔⲰϨⲦ. ");
INSERT INTO copshc_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲦⲈⲦⲚ ⲠⲢⲠⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲎϨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ⲠⲈⲦⲚⲀⲤⲰⲰϤ ⲘⲠⲢⲠⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲠⲚⲞⲨⲦⲈ ⲚⲀⲦⲀⲔⲞϤ ⲠⲢⲠⲈ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲞⲨⲀⲀⲂ ⲈⲦⲈⲚⲦⲰⲦⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ⲘⲠⲢⲦⲢⲈ ⲖⲀⲀⲨ ⲈⲜⲀⲠⲀⲦⲀ ⲘⲘⲞϤ. ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲄ ⲞⲨⲤⲞⲪⲞⲤ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲘⲀⲢⲈϤⲢⲤⲞϬ ϨⲘ ⲠⲈⲒⲀⲒⲰⲚ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϢⲰⲠⲈ ⲚⲤⲞⲪⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ⲦⲤⲞⲪⲒⲀ ⲄⲀⲢ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲘⲚⲦⲤⲞϬ ⲦⲈ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ϤⲤⲎϨ ⲄⲀⲢ ϪⲈ ⲠⲈⲦϬⲰⲠⲈ ⲚⲚⲤⲞⲪⲞⲤ ϨⲚ ⲚⲈⲨⲔⲞⲦⲤ. ");
INSERT INTO copshc_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ⲀⲨⲰ ⲞⲚ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲤⲞⲞⲨⲚ ⲚⲘⲘⲞⲔⲘⲈⲔ ⲚⲚⲤⲞⲪⲞⲤ ϪⲈ ⲤⲈϢⲞⲨⲈⲒⲦ ");
INSERT INTO copshc_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ϨⲰⲤⲦⲈ ⲘⲠⲢⲦⲢⲈ ⲖⲀⲀⲨ ϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϨⲚ ⲚⲢⲰⲘⲈ ");
INSERT INTO copshc_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ⲠⲦⲎⲢϤ ⲄⲀⲢ ⲠⲰⲦⲚ ⲠⲈ ⲈⲒⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲈⲒⲦⲈ ⲀⲠⲞⲖⲖⲰ ⲈⲒⲦⲈ ⲔⲎⲪⲀ ⲈⲒⲦⲈ ⲔⲞⲤⲘⲞⲤ ⲈⲒⲦⲈ ⲰⲚϨ ⲈⲒⲦⲈ ⲘⲞⲨ ⲈⲒⲦⲈ ⲚⲈⲦϢⲞⲞⲠ ⲈⲒⲦⲈ ⲚⲈⲦⲚⲀϢⲰⲠⲈ ⲠⲦⲎⲢϤ ⲠⲰⲦⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚ ⲚⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲠⲀ ⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲀⲢⲈ ⲚⲢⲰⲘⲈ ⲞⲠⲚ ϨⲰⲤ ϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲚⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲘⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ⲈⲨϢⲒⲚⲈ ϬⲈ ⲘⲠⲈⲒⲘⲀ ϨⲚ ⲚⲞⲒⲔⲞⲚⲞⲘⲞⲤ ϪⲈ ⲈⲨⲈϨⲈ ⲈⲨⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ⲀⲚⲞⲔ ⲆⲈ ⲞⲨⲈⲖⲀⲬⲒⲤⲦⲞⲚ ⲚⲀⲒ ⲠⲈ ⲈⲦⲢⲈⲨⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ϨⲒⲦⲚ ⲦⲎⲨⲦⲚ. ⲎϨⲒⲦⲚ ⲞⲨϨⲞⲞⲨ ⲚⲢⲰⲘⲈ. ⲀⲖⲖⲀ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲚϮⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ⲚϮⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ⲚⲖⲀⲀⲨ ⲈⲀⲒⲀⲀϤ. ⲀⲖⲖⲀ ⲚⲈⲒⲦⲘⲀⲒⲎⲨ ⲀⲚ ϨⲘ ⲠⲀⲒ. ⲠⲈⲦⲀⲚⲀⲔⲢⲒⲚⲈ ⲆⲈ ⲘⲘⲞⲒ ⲠⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ϨⲰⲤⲦⲈ ⲘⲠⲢⲔⲢⲒⲚⲈ ⲚⲖⲀⲀⲨ ϨⲀⲐⲎ ⲘⲠⲈⲨⲞⲈⲒϢ ϢⲀⲚⲦⲈ ⲠϪⲞⲈⲒⲤ ⲈⲒ. ⲠⲀⲒ ⲈⲦⲚⲀⲢⲞⲨⲞⲈⲒⲚ ⲈⲚⲈⲐⲎⲠ ϨⲘ ⲠⲔⲀⲔⲈ ⲀⲨⲰ ⲚϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚϢⲞϪⲚⲈ ⲚⲚϨⲎⲦ. ⲦⲞⲦⲈ ⲠⲦⲀⲈⲒⲞ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲀϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ⲚⲀⲒ ⲆⲈ ⲚⲀⲤⲚⲎⲨ ⲚⲦⲀⲒϪⲒⲦⲞⲨ ⲚⲤⲘⲞⲦ ⲈϨⲢⲀⲒ ⲈϪⲰⲒ ⲘⲚ ⲀⲠⲞⲖⲖⲰ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ. ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲤⲂⲞ ⲚϨⲎⲦⲚ ⲈⲦⲘⲢϨⲞⲨⲞ ⲈⲚⲈⲦⲤⲎϨ ϪⲈ ⲚⲚⲈ ⲞⲨⲀ ϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ⲈϪⲚ ⲞⲨⲀ ϨⲀ ⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲦⲆⲒⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲔ ⲞⲨ ⲆⲈ ⲠⲈⲦⲚⲦⲞⲞⲦⲔ ⲈⲘⲠⲔϪⲒⲦϤ ⲈϢϪⲈ ⲀⲔⲢⲠⲔⲈϪⲒ ⲀϨⲢⲞⲔ ⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ϨⲰⲤ ⲈⲘⲠⲔϪⲒ. ");
INSERT INTO copshc_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ⲎⲆⲎ ⲦⲈⲦⲚⲤⲎⲨ ⲎⲆⲎ ⲀⲦⲈⲦⲚⲢⲢⲘⲘⲀⲞ ⲀϪⲚⲦⲚ ⲀⲦⲈⲦⲚⲢⲢⲢⲞ ⲚⲀⲚⲞⲨⲤ ⲆⲈ ⲈϢϪⲈ ⲀⲦⲈⲦⲚⲢⲢⲢⲞ ϪⲈⲔⲀⲀⲤ ⲈⲚⲈⲢⲢⲢⲞ ϨⲰⲰⲚ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ⲀⲢⲎⲨ ⲄⲀⲢ ⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲔⲀⲀⲚ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚϨⲀⲈ ⲚⲐⲈ ⲚⲚⲒⲈⲠⲒⲐⲀⲚⲀⲦⲎⲤ. ϪⲈ ⲀⲚϢⲰⲠⲈ ⲚⲐⲈⲀⲦⲢⲞⲚ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲀⲨⲰ ⲚⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲚ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ⲀⲚⲞⲚ ⲀⲚⲢⲤⲞϬ ⲈⲦⲂⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲀⲂⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲚⲞⲚ ⲦⲚϬⲞⲞⲂ ⲚⲦⲰⲦⲚ ⲆⲈ ⲦⲈⲦⲚϪⲞⲞⲢ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚⲦⲀⲈⲒⲎⲨ ⲀⲚⲞⲚ ⲆⲈ ⲦⲚⲤⲎϢ ");
INSERT INTO copshc_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ϢⲀϨⲢⲀⲒ ⲈⲦⲈⲈⲒⲞⲨⲚⲞⲨ ⲦⲚϨⲔⲀⲈⲒⲦ ⲦⲚⲞⲂⲈ ⲦⲚⲔⲎⲔⲀϨⲎⲨ ⲤⲈϮⲔⲖⲮ ⲈϪⲰⲚ ⲦⲚϢⲦⲢⲦⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ⲦⲚϨⲞⲤⲈ ⲈⲚⲢϨⲰⲂ ϨⲚ ⲚⲈⲚϬⲒϪ ⲘⲘⲒⲚ ⲘⲘⲞⲚ ⲈⲨⲤⲀϨⲞⲨ ⲘⲘⲞⲚ ⲦⲚⲤⲘⲞⲨ ⲈⲢⲞⲞⲨ ⲈⲨⲠⲎⲦ ⲚⲤⲰⲚ ⲦⲚⲀⲚⲈⲬⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ⲈⲨϪⲒⲞⲨⲀ ⲈⲢⲞⲚ. ⲦⲚⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞⲞⲨ ⲚⲐⲈ ⲚⲚⲒⲠⲈⲢⲒⲔⲀⲐⲀⲢⲘⲀ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲀⲚⲢϢϤⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ϢⲀ ϨⲢⲀⲒ ⲈⲦⲈⲒⲞⲨⲚⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ⲚⲚⲈⲈⲒϮϢⲒⲠⲈ ⲚⲎⲦⲚ ⲀⲚ ⲈⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ⲚⲚⲀⲒ. ⲀⲖⲖⲀ ⲈⲒϮⲤⲂⲰ ⲚⲎⲦⲚ ϨⲰⲤ ϢⲎⲢⲈ ⲘⲘⲈⲢⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ⲔⲀⲚ ⲈϢⲰⲠⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲦⲂⲀ ⲘⲠⲀⲒⲆⲀⲄⲰⲄⲞⲤ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲖⲖⲀ ⲚϨⲀϨ ⲚⲈⲒⲰⲦ ⲀⲚ. ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒϪⲠⲈ ⲦⲎⲨⲦⲚ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ϨⲒⲦⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ϬⲈ ⲘⲘⲰⲦⲚ ⲦⲚⲦⲚⲦⲎ ⲨⲦⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒⲦⲚⲚⲈⲨⲦⲒⲘⲞⲐⲈⲞⲤ ⲚⲎⲦⲚ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲈ ⲘⲘⲈⲢⲒⲦ ⲀⲨⲰ ⲘⲠⲒⲤⲦⲞⲤ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲠⲀⲒ ⲈⲦⲚⲀⲦⲢⲈⲦⲚⲢⲠⲘⲈⲈⲨⲈ ⲚⲚⲀϨⲒⲞⲞⲨⲈ ⲈⲦϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲐⲈ ⲈϮϮⲤⲂⲰ ⲘⲘⲞⲤ ϨⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ ϨⲘ ⲘⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ϨⲰⲤ ⲈⲚϮⲚⲎⲨ ⲆⲈ ⲀⲚ ϢⲀⲢⲰⲦⲚ ⲀϨⲞⲒⲚⲈ ϪⲒⲤⲈ ⲚϨⲎⲦ ");
INSERT INTO copshc_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ϮⲚⲎⲨ ⲆⲈ ϢⲀⲢⲰⲦⲚ ϨⲚ ⲞⲨϬⲈⲠⲎ ⲈⲢϢⲀⲚ ⲠϪⲞⲈⲒⲤ ⲢϨⲚⲀϤ. ⲚⲦⲀⲈⲒⲘⲈ ⲀⲚ ⲈⲠϢⲀϪⲈ ⲚⲚⲈⲦϪⲞⲤⲈ ⲚϨⲎⲦ. ⲀⲖⲖⲀ ⲦⲈⲨϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ⲦⲘⲚⲦⲢⲢⲞ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲈⲤϨⲚϢⲀϪⲈ ⲀⲚ. ⲀⲖⲖⲀ ϨⲚ ⲞⲨϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ⲞⲨ ⲠⲈⲦⲈⲦⲚⲞⲨⲀϢϤ. ⲦⲀⲈⲒ ϢⲀⲢⲰⲦⲚ ϨⲚ ⲞⲨϬⲈⲢⲰⲂ ϪⲚ ϨⲚ ⲞⲨⲀⲄⲀⲠⲎ ⲘⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲘⲘⲚⲦⲢⲘⲢⲀϢ. ");
INSERT INTO copshc_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ⲤⲈⲤⲰⲦⲘ ⲢⲰ ⲈⲨⲠⲞⲢⲚⲈⲒⲀ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲀⲨⲰ ⲞⲨⲠⲞⲢⲚⲈⲒⲀ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ ⲈⲚⲤϨⲚ ⲚⲔⲈϨⲈⲐⲚⲞⲤ ⲀⲚ. ϨⲰⲤⲦⲈ ⲈⲦⲢⲈ ⲞⲨⲀ ϪⲒⲐⲒⲘⲈ ⲘⲠⲈϤⲈⲒⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ⲀⲨⲰ ⲚⲦⲰⲦⲚ ⲦⲈⲦⲚϪⲞⲤⲈ ⲚϨⲎⲦ ⲀⲨⲰ ⲚⲦⲀⲦⲈⲦⲚⲢϨⲎⲂⲈ ⲀⲚ ⲚϨⲞⲨⲞ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈϤⲒ ϨⲚ ⲦⲈⲦⲚⲘⲎⲦⲈ ⲘⲠⲈⲚⲦⲀϤⲈⲒⲢⲈ ⲘⲠⲈⲈⲒϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ⲀⲚⲞⲔ ⲄⲀⲢ ⲈⲚϮϨⲀⲦⲈⲦⲎⲨⲦⲚ ⲀⲚ ϨⲘ ⲠⲤⲰⲘⲀ. ⲈⲒϨⲀⲦⲈⲦⲎⲨⲦⲚ ⲆⲈ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲀⲒⲞⲨⲰ ⲈⲒⲔⲢⲒⲚⲈ ϨⲰⲤ ⲈⲒϨⲀⲦⲚⲦⲎⲨⲦⲚ ⲘⲠⲈⲚⲦⲀϤⲈⲒⲢⲈ ⲘⲠⲈⲈⲒϨⲰⲂ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ⲈⲀⲦⲈⲦⲚⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲚⲈⲢⲎⲨ ϨⲘ ⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲚ ⲠⲀⲠⲚⲈⲨⲘⲀ ⲘⲚ ⲦϬⲞⲘ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ⲈϮ ⲘⲠⲀⲒ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲨⲦⲀⲔⲞ ⲚⲦⲤⲀⲢⲜ. ϪⲈ ⲈⲢⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲞⲨϪⲀⲒ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ⲚⲚⲀⲚⲞⲨ ⲠⲈⲦⲚϢⲞⲨϢⲞⲨ ⲀⲚ. ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ϢⲀⲢⲈ ⲞⲨⲔⲞⲨⲒ ⲚⲐⲀⲂ ⲦⲢⲈ ⲠⲞⲨⲰϢⲘ ⲦⲎⲢϤ ϤⲒ. ");
INSERT INTO copshc_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ϤⲒ ⲘⲠⲒⲐⲀⲂ ⲚⲀⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ϪⲈ ⲈⲦⲈⲦⲚⲈϢⲰⲠⲈ ⲚⲞⲨⲞⲨⲰϢⲘ ⲚⲂⲢⲢⲈ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲈⲦⲚϨⲈⲚⲀⲐⲀⲂ. ⲔⲀⲒⲄⲀⲢ ⲀⲨϢⲰⲰⲦ ⲘⲠⲈⲚⲠⲀⲤⲬⲀ ϨⲀⲢⲞⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ϨⲰⲤⲦⲈ ⲘⲀⲢⲚⲢϢⲀ ϨⲚ ⲞⲨⲐⲀⲂ ⲀⲚ ⲚⲀⲤ. ⲞⲨⲆⲈ ϨⲚ ⲞⲨⲐⲀⲂ ⲀⲚ ⲚⲔⲀⲔⲒⲀ ϨⲒ ⲠⲞⲚⲎⲢⲒⲀ. ⲀⲖⲖⲀ ϨⲚ ϨⲈⲚⲀⲐⲀⲂ ⲚⲦⲂⲂⲞ ϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ϨⲚ ⲦⲈⲠⲒⲤⲦⲞⲖⲎ ϪⲈ ⲘⲠⲢⲦⲰϨ ⲘⲚ ⲠⲞⲢⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ⲞⲨ ⲠⲀⲚⲦⲰⲤ ⲈⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲞⲢⲚⲞⲤ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ ⲎⲘⲘⲀⲒⲦⲞ ⲚϨⲞⲨⲞ ⲎⲚⲢⲈϤⲦⲰⲢⲠ ⲎⲚⲢⲈϤϢⲘϢⲈ ⲈⲒⲆⲰⲖⲞⲚ ⲈϢϪⲈ ⲈϨⲈ ⲈⲒⲈ ϢϢⲈ ⲈⲢⲰⲦⲚ ⲈⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ⲦⲈⲚⲞⲨ ⲆⲈ ⲚⲦⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ϪⲈ ⲘⲠⲢⲦⲰϨ ⲘⲚ ⲞⲨⲀ ⲈⲨⲘⲞⲨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲤⲞⲚ ⲠⲈ ⲈϢⲰⲠⲈ ⲞⲨⲠⲞⲢⲚⲞⲤ ⲠⲈ ⲎⲚⲢⲈϤϢⲘϢⲈ ⲈⲒⲆⲰⲖⲞⲚ ⲎⲘⲘⲀⲒⲦⲞ ⲚϨⲞⲨⲞ ⲎⲚⲢⲈϤⲤⲀϨⲞⲨ ⲎⲚⲢⲈϤϮϨⲈ ⲎⲚⲢⲈϤⲦⲰⲢⲠ ⲠⲀⲒ ⲚⲦⲈⲈⲒⲘⲒ ⲚⲈ ⲞⲨⲆⲈ ⲘⲠⲢⲞⲨⲰⲘ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ⲞⲨ ⲄⲀⲢ ⲈⲢⲞⲒ ⲠⲈ ⲈⲔⲢⲒⲚⲈ ⲚⲚⲈⲦϨⲒⲂⲞⲖ. ⲀⲨⲰ ⲚⲚⲈⲦϨⲒϨⲞⲨⲚ ⲀⲚ. ⲚⲦⲰⲦⲚ ⲔⲢⲒⲚⲈ ⲚⲚⲈⲦϨⲒ ϨⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲚⲀⲔⲢⲒⲚⲈ ⲚⲚⲈⲦϨⲒⲂⲞⲖ ϤⲒ ⲘⲠⲠⲞⲚⲎⲢⲞⲤ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ⲞⲨⲚ ⲞⲨⲀ ⲚⲀⲦⲞⲖⲘⲀ ⲈⲂⲞⲖ ⲚϨⲎⲦⲦⲎ ⲨⲦⲚ ⲈⲞⲨⲚⲦϤ ⲞⲨϨⲰⲂ ⲘⲚ ⲠⲈⲐⲒⲦⲞⲨⲰϤ ⲈϪⲒϨⲀⲠ ϨⲒ ⲚⲢⲈϤϪⲒ ⲚϬⲞⲚⲤ ⲀⲨⲰ ϨⲒ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ⲎⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲚⲈⲦⲚⲀⲔⲢⲒⲚⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲀⲨⲰ ⲈϢϪⲈ ⲈⲨⲚⲀⲔⲢⲒⲚⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ϨⲒⲰⲦⲦⲎⲨⲦⲚ ⲚⲦⲈⲦⲚ ⲘⲠϢⲀ ⲀⲚ ⲚϨⲈⲚⲔⲞⲨⲒ ⲘⲘⲀ ⲚϮϨⲀⲠ. ");
INSERT INTO copshc_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲦⲚⲚⲀⲔⲢⲒⲚⲈ ⲚϨⲈⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲘⲠⲀⲦⲚⲠⲰϨ ⲈⲚⲀ ⲠⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ⲈϢⲰⲠⲈ ϬⲈ ⲞⲨⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲚϨⲈⲚϨⲰⲂ ⲚⲦⲈ ⲠⲂⲒⲞⲤ ⲚⲈⲦⲤⲞϢϤ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲀⲒ ⲘⲀⲐⲘⲤⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲈⲨϢⲒⲠⲈ ⲚⲎⲦⲚ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲚ ⲖⲀⲀⲨ ⲚⲤⲞⲪⲞⲤ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲠⲀⲒ ⲈϤⲚⲀϢϬⲘϬⲞⲘ ⲈⲆⲒⲀⲔⲢⲒⲚⲈ ⲚⲦⲘⲎⲦⲈ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ⲀⲖⲖⲀ ⲞⲨⲚ ⲞⲨⲤⲞⲚ ϪⲒϨⲀⲠ ⲘⲚ ⲠⲈϤⲤⲞⲚ. ⲀⲨⲰ ⲠⲀⲒ ϨⲒ ⲚⲀⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ⲎⲆⲎ ⲘⲈⲚ ϨⲞⲖⲰⲤ ⲢⲰ ⲞⲨϢⲰⲰⲦ ⲚⲎⲦⲚ ⲠⲈ ϪⲈ ⲞⲨⲚⲦⲎⲦⲚ ϨⲀⲠ ⲘⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ. ⲈⲦⲂⲈ ⲞⲨ ⲢⲰ ⲤⲈⲚⲀϪⲒⲦⲎⲨⲦⲚ ⲀⲚ ⲚϬⲞⲚⲤ. ⲈⲦⲂⲈ ⲞⲨ ⲢⲰ ⲤⲈⲚⲀϤⲈϬ ⲦⲎⲨⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ⲀⲖⲖⲀ ⲚⲦⲰⲦⲚ ⲚⲈⲦϪⲒ ⲚϬⲞⲚⲤ. ⲀⲨⲰ ⲈⲦϤⲰϬⲈ ⲀⲨⲰ ⲠⲀⲒ ⲚⲚⲈⲦⲚⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ⲎⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲢⲈϤϪⲒ ⲚϬⲞⲚⲤ ⲚⲀⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲀⲚ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲠⲢⲠⲖⲀⲚⲀ ⲞⲨⲆⲈ ⲘⲚ ⲠⲞⲢⲚⲞⲤ ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤϢⲘϢⲈ ⲈⲒⲆⲰⲖⲞⲚ ⲞⲨⲆⲈ ⲘⲚ ⲚⲞⲈⲒⲔ ⲞⲨⲆⲈ ⲘⲚ ⲘⲀⲖⲀⲔⲞⲤ ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤⲚⲔⲞⲦⲔ ⲘⲚ ϨⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤϨⲰϤⲦ ⲞⲨⲆⲈ ⲘⲚ ⲘⲀⲒⲦⲞ ⲚϨⲞⲨⲞ ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤϮϨⲈ ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤⲤⲀϨⲞⲨ ⲞⲨⲆⲈ ⲘⲚ ⲢⲈϤⲦⲰⲢⲠ ⲚⲀⲔⲖⲎ ⲢⲞⲚⲞⲘⲒ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ⲀⲨⲰ ⲚⲀⲒ ⲚⲈⲦⲈⲦⲚ ⲚϨⲎⲦⲞⲨ ⲠⲈ ⲀⲖⲖⲀ ⲀⲦⲈⲦⲚϪⲈⲔⲘ ⲦⲎⲨⲦⲚ ⲀⲖⲖⲀ ⲀⲦⲈⲦⲚⲦⲂⲂⲞ ⲀⲖⲖⲀ ⲀⲦⲈⲦⲚⲦⲘⲀⲈⲒⲞ ϨⲘ ⲠⲢⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲰ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲈⲚⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ϨⲰⲂ ⲚⲒⲘ ⲈⲜⲈⲤⲦⲈⲒ ⲚⲀⲒ. ⲀⲖⲖⲀ ϨⲰⲂ ⲚⲒⲘ ⲢⲚⲞϤⲢⲈ ⲀⲚ. ϨⲰⲂ ⲚⲒⲘ ⲈⲜⲈⲤⲦⲈⲒ ⲚⲀⲒ ⲀⲖⲖⲀ ⲚϮⲚⲀⲔⲀ ⲖⲀⲀⲨ ⲀⲚ ⲈⲢϪⲞⲈⲒⲤ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ⲚϬⲒ ⲚⲞⲨⲞⲞⲘ ⲚⲐⲎ ⲀⲨⲰ ⲐⲎ ⲚⲚϬⲒ ⲚⲞⲨⲞⲞⲘ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲦⲀⲒ ⲘⲚ ⲚⲈⲈⲒⲔⲞⲞⲨⲈ ϤⲚⲀⲞⲨⲞⲤϤⲞⲨ ⲠⲤⲰⲘⲀ ⲚⲦⲞϤ ⲚⲦⲠⲞⲢⲚⲈⲒⲀ ⲀⲚ ⲀⲖⲖⲀ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠϪⲞⲈⲒⲤ ⲘⲠⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ⲀⲠⲚⲞⲨⲦⲈ ⲆⲈ ⲦⲞⲨⲚⲈⲤ ⲠⲈⲚϪⲞⲈⲒⲤ. ⲀⲨⲰ ϤⲚⲀⲦⲞⲨⲚⲞⲤⲚ ϨⲒⲦⲚ ⲦⲈϤϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲈⲦⲚⲤⲰⲘⲀ ⲘⲘⲈⲖⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲈ. ⲦⲀϤⲒ ϬⲈ ⲚⲘⲘⲈⲖⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲀⲀⲀⲨ ⲘⲘⲈⲖⲞⲤ ⲘⲠⲞⲢⲚⲎ ⲚⲚⲈⲤϢⲰⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ⲎⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲠⲈⲦⲦⲰϬⲈ ⲘⲘⲞϤ ⲈⲦⲠⲞⲢⲚⲎ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ. ⲠⲈϪⲀϤ ⲄⲀⲢ ϪⲈ ⲤⲈⲚⲀϢⲰⲠⲈ ⲘⲠⲈⲤⲚⲀⲨ ⲈⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ⲠⲈⲦⲦⲰϬⲈ ⲆⲈ ⲘⲘⲞϤ ⲈⲠϪⲞⲈⲒⲤ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ⲠⲰⲦ ⲈⲂⲞⲖ ⲚⲦⲠⲞⲢⲚⲈⲒⲀ. ⲚⲞⲂⲈ ⲚⲒⲘ ⲈⲦⲈⲢⲈ ⲠⲢⲰⲘⲈ ⲚⲀⲀⲀⲨ ⲤⲈⲘⲠⲂⲞⲖ ⲘⲠⲤⲰⲘⲀ. ⲠⲈⲦⲠⲞⲢⲚⲈⲨⲈ ⲆⲈ ⲚⲦⲞϤ ⲈϤⲢⲚⲞⲂⲈ ⲈⲠⲈϤⲤⲰⲘⲀ ⲘⲀⲨⲀⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ⲎⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲠⲈⲦⲚⲤⲰⲘⲀ ⲠⲢⲠⲈ ⲠⲈ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲞⲨⲀⲀⲂ ⲈⲦⲚϨⲎⲦⲦⲎⲨⲦⲚ. ⲠⲀⲒ ⲈⲚⲦⲀⲦⲈⲦⲚϪⲒⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲠⲰⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ⲀⲨϢⲈⲠ ⲦⲎⲨⲦⲚ ⲄⲀⲢ ϨⲀ ⲞⲨⲀⲤⲞⲨ. ϮⲈⲞⲞⲨ ϬⲈ ⲘⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈⲦⲚⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ⲈⲦⲂⲈ ⲚⲈⲚⲦⲀⲦⲈⲦⲚⲤϨⲀⲒⲤⲞⲨ ⲆⲈ ⲚⲀⲒ ⲚⲀⲚⲞⲨⲤ ⲘⲠⲢⲰⲘⲈ ⲈⲦⲘϪⲰϨ ⲈⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ⲈⲦⲂⲈ ⲘⲠⲞⲢⲚⲈⲒⲀ ⲆⲈ ⲘⲀⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϪⲒ ⲚⲀϤ ⲚⲦⲈϤⲤϨⲒⲘⲈ. ⲀⲨⲰ ⲘⲀⲢⲈ ⲦⲞⲨⲈⲒ ⲦⲞⲨⲈⲒ ϪⲒ ⲚⲀⲤ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ⲠϨⲞⲞⲨⲦ ⲘⲀⲢⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ ⲚⲦⲈϤⲤϨⲒⲘⲈ. ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲦⲔⲈⲤϨⲒⲘⲈ ⲘⲀⲢⲈⲤϮ ⲘⲠⲈⲦⲈⲢⲞⲤ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ⲦⲈⲤϨⲒⲘⲈ ⲞⲘⲠϪⲞⲈⲒⲤ ⲀⲚ ⲘⲠⲈⲤⲤⲰⲘⲀ ⲀⲖⲖⲀ ⲠⲈⲤϨⲀⲒ ⲠⲈ. ϨⲞⲘⲞⲒⲰⲤ ⲆⲈ ⲘⲠϨⲀⲒ ⲞⲘⲠϪⲞⲈⲒⲤ ⲀⲚ ⲘⲠⲈϤⲤⲰⲘⲀ. ⲀⲖⲖⲀ ⲦⲈϤⲤϨⲒⲘⲈ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ⲘⲠⲢϤⲈϬ ⲚⲈⲦⲚⲈⲢⲎⲨ ⲈⲒⲘⲎⲦⲒ ϨⲚ ⲞⲨϢⲰⲚⲂ ⲠⲢⲞⲤ ⲞⲨⲞⲈⲒϢ ϪⲈ ⲈⲦⲈⲦⲚⲈⲤⲢϤⲈ ⲈⲠⲈϢⲖⲎⲖ. ⲀⲨⲰ ⲞⲚ ⲚⲦⲈⲦⲚ ⲈⲒ ⲈⲦⲞⲨⲈⲚ ⲚⲈⲦⲚⲈⲢⲎⲨ ϪⲈ ⲚⲚⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲰⲦⲚ ⲈⲦⲂⲈ ⲦⲈⲦⲚⲘⲚⲦⲀⲦⲀⲘⲀϨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ⲠⲀⲒ ⲆⲈ ⲈⲒϪⲰ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲞⲨⲤⲨⲚⲄⲚⲰⲘⲎ. ⲚⲔⲀⲦⲀ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ϮⲞⲨⲰϢ ⲄⲀⲢ ⲈⲦⲢⲈ ⲢⲰⲘⲈ ⲚⲒⲘ ϢⲰⲠⲈ ⲚⲦⲀϨⲈ ⲀⲖⲖⲀ ⲞⲨⲚⲦⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲞⲨⲬⲀⲢⲒⲤⲘⲀ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲞⲨⲀ ⲘⲈⲚ ϨⲒⲚⲀⲒ ⲔⲈⲦ ⲆⲈ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲚⲈⲦⲈⲘⲚⲦⲞⲨ ⲤϨⲒⲘⲈ ⲘⲚ ⲚⲈⲬⲎⲢⲀ ϪⲈ ⲚⲀⲚⲞⲨⲤ ⲚⲀⲨ ⲈϬⲰ ⲚⲦⲀϨⲈ ϨⲰ. ");
INSERT INTO copshc_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲚⲤⲈⲚⲀⲈϢⲈⲄⲔⲢⲀⲦⲈⲨⲈ ⲀⲚ ⲘⲘⲞⲞⲨ ⲘⲀⲢⲞⲨϪⲒ. ⲚⲀⲚⲞⲨ ϪⲒ ⲄⲀⲢ ⲈϨⲞⲨⲈⲢⲰⲔϨ. ");
INSERT INTO copshc_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ⲚⲈⲚⲦⲀⲨϪⲒ ⲆⲈ ϮⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲚⲀⲨ ⲀⲚⲞⲔ ⲀⲚ ⲀⲖⲖⲀ ⲠϪⲞⲈⲒⲤ ⲈⲦⲘⲦⲢⲈ ⲦⲈⲤϨⲒⲘⲈ ⲠⲰⲢϪ ⲈⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲤϢⲀⲚⲠⲰⲢϪ ⲘⲀⲢⲈⲤϬⲰ ⲚⲦⲈⲒϨⲈ. ⲎⲚⲤϨⲰⲦⲠ ⲈⲠⲈⲤϨⲀⲒ. ⲀⲨⲰ ⲠϨⲞⲞⲨⲦ ⲈⲦⲘⲦⲢⲈϤⲔⲰ ⲚⲤⲰϤ ⲚⲦⲈϤⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲘⲠⲔⲈⲤⲈⲈⲠⲈ ⲀⲚⲞⲔ ⲘⲠϪⲞⲈⲒⲤ ⲀⲚ ϪⲈ ⲈϢⲰⲠⲈ ⲞⲨⲤⲞⲚ ⲈⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲤϨⲒⲘⲈ ⲚⲀⲠⲒⲤⲦⲞⲤ ⲀⲨⲰ ⲈⲤⲞⲨⲰϢ ⲈϬⲰ ⲚⲘⲘⲀϤ ⲘⲠⲢⲦⲢⲈϤⲖⲞ ϨⲀⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲞⲨⲤϨⲒⲘⲈ ⲈⲨⲚⲦⲀⲤ ⲘⲘⲀⲨ ⲚⲞⲨϨⲀⲒ ⲚⲀⲠⲒⲤⲦⲞⲤ ⲈϤⲞⲨⲰϢ ⲈϬⲰ ⲚⲘⲘⲀⲤ ⲘⲠⲢⲦⲢⲈⲤⲖⲞ ϨⲀ ⲠϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ⲀϤⲦⲂⲂⲞ ⲄⲀⲢ ⲚϬⲒ ⲠϨⲀⲒ ⲚⲀⲠⲒⲤⲦⲞⲤ ϨⲚ ⲦⲈⲤϨⲒⲘⲈ ⲀⲨⲰ ⲀⲤⲦⲂⲂⲞ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ⲚⲀⲠⲒⲤⲦⲞⲤ ϨⲘ ⲠⲤⲞⲚ ⲈϢϪⲈ ⲘⲠⲈ ⲈⲒⲈ ⲚⲈⲦⲚϢⲎⲢⲈ ϨⲈⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲈ ⲦⲈⲚⲞⲨ ⲆⲈ ⲤⲈⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ⲈϢϪⲈ ⲠⲀⲠⲒⲤⲦⲞⲤ ⲆⲈ ⲚⲀⲠⲰⲢϪ ⲘⲀⲢⲈϤⲠⲰⲢϪ ⲈⲚϤⲞ ⲀⲚ ⲚϨⲘϨⲀⲖ ⲚϬⲒ ⲠⲤⲞⲚ ⲎⲦⲤⲰⲚⲈ ϨⲚ ⲚⲈⲈⲒϨⲰⲂ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲄⲀⲢ ⲦⲀϨⲘⲚ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ⲞⲨ ⲄⲀⲢ ⲠⲈⲦⲈⲢⲈ ⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲦⲈⲤϨⲒⲘⲈ. ⲘⲎ ⲦⲈⲚⲀϢⲦⲞⲨϪⲈ ⲠⲞⲨϨⲀⲒ. ⲀⲨⲰ ⲞⲨ ⲠⲈⲦⲔⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲠϨⲀⲒ ⲘⲎ ⲔⲚⲀϢⲦⲞⲨϪⲈ ⲦⲈⲔⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ⲈⲒⲘⲎ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲦⲈϢ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲤ. ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲀϨⲘⲈϤ ⲘⲀⲢⲈϤⲘⲞⲞϢⲈ ⲘⲘⲞⲤ. ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈϮⲦⲰϢ ⲘⲘⲞⲤ ϨⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ⲀⲨⲦⲈϨⲘ ⲞⲨⲀ ⲈϤⲤⲂⲂⲎⲨ ⲘⲠⲢⲦⲢⲈϤϨⲞⲂⲤϤ. ⲀⲨⲦⲈϨⲘ ⲞⲨⲀ ⲈϤⲞ ⲚⲀⲦⲤⲂⲂⲈ ⲘⲠⲢⲦⲢⲈϤⲤⲂⲂⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ⲠⲤⲂⲂⲈ ⲞⲨⲖⲀⲀⲨ ⲠⲈ ⲀⲨⲰ ⲦⲘⲚⲦⲀⲦⲤⲂⲂⲈ ⲞⲨⲖⲀⲀⲨ ⲦⲈ. ⲀⲖⲖⲀ ⲠϨⲀⲢⲈϨ ⲈⲚⲈⲚⲦⲞⲖⲎ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϨⲘ ⲠⲦⲰϨⲘ ⲈⲚⲦⲀⲨⲦⲀϨⲘⲈϤ ⲚϨⲎⲦϤ ⲘⲀⲢⲈϤϬⲰ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ⲀⲨⲦⲀϨⲘⲈⲔ ⲈⲔⲞ ⲚϨⲘϨⲀⲖ ⲘⲠⲢⲦⲢⲈϤⲢⲢⲞⲞⲨϢ ⲚⲀⲔ. ⲀⲖⲖⲀ ⲔⲀⲚ ⲈϢⲰⲠⲈ ⲞⲨⲚϬⲞⲘ ⲘⲘⲞⲔ ⲈⲢⲢⲘϨⲈ ⲬⲢⲰ ⲚϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ⲠϨⲘϨⲀⲖ ⲄⲀⲢ ⲈⲚⲦⲀⲨⲦⲀϨⲘⲈϤ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲠⲀ ⲠⲈⲖⲈⲨⲐⲈⲢⲞⲤ ⲘⲠϪⲞⲈⲒⲤ ⲠⲈ. ϨⲞⲘⲞⲒⲰⲤ ⲠⲢⲘϨⲈ ⲈⲚⲦⲀⲨⲦⲀϨⲘⲈϤ ⲠϨⲘϨⲀⲖ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ⲀⲨϢⲈⲠ ⲦⲎⲨⲦⲚ ϨⲀ ⲞⲨⲀⲤⲞⲨ ⲘⲠⲢϢⲰⲠⲈ ⲚϨⲘϨⲀⲖ ⲚⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϨⲘ ⲠⲈⲚⲦⲀⲨⲦⲀϨⲘⲈϤ ⲚϨⲎⲦϤ ⲚⲀⲤⲚⲎⲨ ⲘⲀⲢⲈϤϬⲰ ϨⲘ ⲠⲀⲒ ⲚⲚⲀϨⲢⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ⲈⲦⲂⲈ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ ⲆⲈ ⲘⲚⲦⲀⲒ ⲞⲨⲈϨⲤⲀϨⲚⲈ ⲘⲘⲀⲨ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ. ϮϮ ⲆⲈ ⲚⲞⲨⲄⲚⲰⲘⲎ ϨⲰⲤ ⲈⲀⲨⲚⲀ ⲚⲀⲒ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ ⲈⲢⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ϮⲘⲈⲈⲨⲈ ϬⲈ ϪⲈ ⲚⲀⲚⲞⲨ ⲠⲀⲒ ⲈⲦⲂⲈ ⲦⲀⲚⲀⲄⲔⲎ ⲈⲦϢⲞⲞⲠ. ϪⲈ ⲚⲀⲚⲞⲨⲤ ⲘⲠⲢⲰⲘⲈ ⲈϬⲰ ⲚⲦⲈⲒϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ⲔⲘⲎⲢ ⲈⲤϨⲒⲘⲈ ⲘⲠⲢϢⲒⲚⲈ ⲚⲤⲀⲂⲰⲖ ⲔⲂⲎⲖ ⲈⲂⲞⲖ ⲚⲤϨⲒⲘⲈ ⲘⲠⲢϢⲒⲚⲈ ⲚⲤⲀ ⲤϨⲒⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲔϢⲀⲚϪⲒ ⲘⲠⲔⲢⲚⲞⲂⲈ ⲀⲨⲰ ⲈⲤϢⲀⲚϪⲒ ⲚϬⲒ ⲦⲠⲀⲢⲐⲈⲚⲞⲤ ⲘⲠⲤⲢⲚⲞⲂⲈ ⲚⲀⲒ ⲆⲈ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ ⲚⲀϢⲈ ⲠⲐⲖⲒⲮⲒⲤ ϨⲚ ⲦⲈⲨⲤⲀⲢⲜ ⲀⲚⲞⲔ ⲆⲈ ϮϮⲤⲞ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ⲠⲀⲒ ⲆⲈ ⲈⲒϪⲰ ⲘⲘⲞϤ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲠⲈⲨⲞⲈⲒϢ ⲚⲞⲖⲔ ⲠⲈ. ϪⲈⲔⲀⲀⲤ ϬⲈ ⲚⲔⲞⲞⲨⲈ ⲈⲦⲈⲨⲚⲦⲞⲨ ⲤϨⲒⲘⲈ ⲘⲘⲀⲨ ⲚⲤⲈⲢⲐⲈ ⲚⲚⲈⲦⲈⲘⲚⲦⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ⲀⲨⲰ ⲚⲈⲦⲢⲒⲘⲈ ϨⲰⲤ ⲈⲚⲤⲈⲢⲒⲘⲈ ⲀⲚ. ⲀⲨⲰ ⲚⲈⲦⲢⲀϢⲈ ϨⲰⲤ ⲈⲚⲤⲈⲢⲀϢⲈ ⲀⲚ. ⲀⲨⲰ ⲚⲈⲦϢⲰⲠ ϨⲰⲤ ⲈⲚⲤⲈⲀⲘⲀϨⲦⲈ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ⲀⲨⲰ ⲚⲈⲦⲬⲢⲰ ⲘⲠⲈⲈⲒⲔⲞⲤⲘⲞⲤ ϨⲰⲤ ⲈⲚⲤⲈⲬⲢⲰ ⲀⲚ. ϤⲚⲀⲠⲀⲢⲀⲄⲈ ⲄⲀⲢ ⲚϬⲒ ⲠⲈⲤⲬⲎⲘⲀ ⲘⲠⲈⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ϮⲞⲨⲈϢ ⲦⲎⲨⲦⲚ ⲆⲈ ⲈⲦⲢⲈⲦⲈⲦⲚϢⲰⲠⲈ ⲚⲀⲦⲢⲞⲞⲨϢ. ⲠⲈⲦⲈⲘⲚⲦϤ ⲤϨⲒⲘⲈ ϤϤⲒⲢⲞⲞⲨϢ ⲈⲚⲀ ⲠϪⲞⲈⲒⲤ ϪⲈ ⲈϤⲚⲀⲀⲢⲈⲤⲔⲈ ⲘⲠϪⲞⲈⲒⲤ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ⲠⲈⲚⲦⲀϤϪⲒ ⲆⲈ ϤϤⲒⲢⲞⲞⲨϢ ⲈⲚⲀ ⲠⲔⲞⲤⲘⲞⲤ ϪⲈ ⲈϤⲚⲀⲀⲢⲈⲤⲔⲈ ⲚⲦⲈϤⲤϨⲒⲘⲈ ⲚⲀϢ ⲚϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ⲀⲨⲰ ϤⲠⲎϢ ⲀⲨⲰ ⲦⲈⲤϨⲒⲘⲈ ⲈⲦⲈⲘⲚⲦⲤ ϨⲀⲒ ⲘⲚ ⲦⲠⲀⲢⲐⲈⲚⲞⲤ ϤⲒⲢⲞⲞⲨϢ ⲈⲚⲀ ⲠϪⲞⲈⲒⲤ ϪⲈⲔⲀⲀⲤ ⲈⲤⲈϢⲰⲠⲈ ⲈⲤⲞⲨⲀⲀⲂ ϨⲘ ⲠⲈⲤⲤⲰⲘⲀ ⲘⲚ ⲠⲈⲤⲠⲚⲈⲨⲘⲀ ⲦⲈⲚⲦⲀⲤϪⲒϨⲀⲒ ⲆⲈ ϤⲒⲢⲞⲞⲨϢ ⲈⲚⲀ ⲠⲔⲞⲤⲘⲞⲤ ϪⲈ ⲚⲀϢ ⲚϨⲈ ⲈⲤⲚⲀⲀⲢⲈⲤⲔⲈ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ⲈⲒϪⲰ ⲆⲈ ⲘⲠⲀⲒ ⲈⲦⲈⲦⲚⲚⲞϤⲢⲈ. ϪⲈⲔⲀⲀⲤ ⲀⲚ ⲈⲒⲈϮ ⲚⲞⲨⲈⲖⲰ ⲈϨⲎⲦ ⲦⲎⲨⲦⲚ ⲀⲖⲖⲀ ⲠⲢⲞⲤⲞⲨⲦⲤⲀⲚⲞ ⲘⲚⲦϬⲒⲚⲀϨⲈⲢⲀⲦⲔ ⲈⲠϪⲞⲈⲒⲤ ⲔⲀⲖⲰⲤ ⲀϪⲚⲢⲞⲞⲨϢ ");
INSERT INTO copshc_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ⲈϢϪⲈ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤϢⲒⲠⲈ ⲈϪⲚ ⲦⲈϤϢⲈⲈⲢⲈ ⲈϢⲰⲠⲈ ⲀⲤⲢⲚⲞϬ ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦϢϢⲈ ⲈϢⲰⲠⲈ ⲠⲈⲦϤⲞⲨⲀϢϤ ⲘⲀⲢⲈϤⲀⲀϤ ⲚϤⲢⲚⲞⲂⲈ ⲀⲚ ⲘⲀⲢⲞⲨϪⲒ. ");
INSERT INTO copshc_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ⲠⲈⲚⲦⲀϤⲀϨⲈ ⲆⲈ ⲈⲢⲀⲦϤ ϨⲘ ⲠⲈϤϨⲎⲦ ⲈϤⲦⲀϪⲢⲎⲨ ⲈⲘⲚϨⲦⲞⲢ ⲈⲢⲞϤ. ⲞⲨⲚⲦϤ ⲈⲜⲞⲨⲤⲒⲀ ⲆⲈ ⲘⲘⲀⲨ ⲈⲦⲂⲈ ⲠⲈϤⲞⲨⲰϢ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ⲀⲨⲰ ⲀϤⲔⲢⲒⲚⲈ ⲘⲠⲀⲒ ϨⲘ ⲠⲈϤϨⲎⲦ ⲈϨⲀⲢⲈϨ ⲈⲦⲈϤϢⲈⲈⲢⲈ ⲔⲀⲖⲰⲤ ϤⲚⲀⲀⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ϨⲰⲤⲦⲈ ⲠⲈⲦⲚⲀϮ ⲦⲈϤϢⲈⲈⲢⲈ ⲚϨⲀⲒ ⲔⲀⲖⲰⲤ ϤⲚⲀⲀⲀⲤ. ⲀⲨⲰ ⲠⲈⲦⲈⲚϤⲚⲀⲦⲀⲀⲤ ⲀⲚ ⲈϤⲚⲀⲢⲞⲨϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ⲦⲈⲤϨⲒⲘⲈ ⲘⲎⲢ ⲈⲠϨⲞⲤⲞⲚ ⲠⲈⲨⲞⲈⲒϢ ⲠⲈⲤϨⲀⲒ ⲞⲚϨ ⲈⲢϢⲀⲚ ⲠⲈⲤϨⲀⲒ ⲆⲈ ⲘⲞⲨ ⲞⲨⲢⲘϨⲎ ⲦⲈ ⲈϨⲘⲞⲞⲤ ⲘⲚ ⲠⲈⲦⲈϨⲚⲀⲤ ⲘⲞⲚⲞⲚ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ⲚⲀⲒⲀⲦⲤ ⲆⲈ ⲚϨⲞⲨⲞ ⲈⲤϢⲀⲚϬⲰ ⲚⲦⲈⲈⲒϨⲈ ⲔⲀⲦⲀ ⲦⲀⲄⲚⲰⲘⲎ. ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϨⲰ ϪⲈ ⲞⲨⲚⲦⲀⲒ ⲘⲘⲀⲨ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ⲈⲦⲂⲈ ⲚϢⲰⲰⲦ ⲆⲈ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲞⲨⲚⲦⲀⲚ ⲦⲎⲢⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲤⲞⲞⲨⲚ. ⲠⲤⲞⲞⲨⲚ ϢⲀϤϪⲒⲤⲈ. ⲦⲀⲄⲀⲠⲎ ⲆⲈ ϢⲀⲤⲔⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲤⲞⲨⲚ ⲖⲀⲀⲨ ⲘⲠⲀⲦϤⲤⲞⲨⲚ ⲐⲈ ⲈⲦϢϢⲈ ⲈⲤⲞⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ⲈϢϪⲈ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ⲘⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲀⲨⲤⲞⲨⲰⲚϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ⲈⲦⲂⲈ ⲠⲞⲨⲰⲘ ϬⲈ ⲚⲚϢⲰⲰⲦ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲘⲚ ⲖⲀⲀⲨ ⲚⲈⲒⲆⲰⲖⲞⲚ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ⲀⲨⲰ ϪⲈ ⲘⲚ ⲚⲞⲨⲦⲈ ⲚⲤⲀ ⲞⲨⲀ. ");
INSERT INTO copshc_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ⲔⲀⲒⲄⲀⲢ ⲈϢϪⲈ ⲞⲨⲚ ϨⲞⲒⲚⲈ ⲈϢⲀⲨⲘⲞⲨⲦⲈ ⲈⲢⲞⲞⲨ ϪⲈ ⲚⲞⲨⲦⲈ ⲈⲒⲦⲈ ϨⲚ ⲦⲠⲈ. ⲈⲒⲦⲈ ϨⲒϪⲘ ⲠⲔⲀϨ. ⲚⲐⲈ ⲈⲦⲈ ⲞⲨⲚ ϨⲀϨ ⲚⲚⲞⲨⲦⲈ ϨⲒ ϨⲀϨ ⲚϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ⲀⲚⲞⲚ ⲞⲨⲚⲞⲨⲦⲈ ⲚⲞⲨⲰⲦ ⲠⲈⲦϢⲞⲞⲠ ⲚⲀⲚ ⲠⲈⲒⲰⲦ ⲠⲈⲚⲦⲀ ⲠⲦⲎⲢϤ ϢⲰⲠⲈ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲀⲨⲰ ⲀⲚⲞⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ ⲘⲚ ⲞⲨϪⲞⲈⲒⲤ ⲚⲞⲨⲰⲦ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲦⲈⲢⲈ ⲠⲦⲎⲢϤ ϢⲞⲞⲠ ⲈⲦⲂⲎⲎⲦϤ ⲀⲨⲰ ⲀⲚⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ⲀⲖⲖⲀ ⲘⲠⲤⲞⲞⲨⲚ ϨⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲀⲚ. ϨⲞⲒⲚⲈ ⲄⲀⲢ ϨⲘ ⲠⲦⲰⲠ ⲘⲠⲈⲒⲆⲰⲖⲞⲚ ϢⲀ ϨⲞⲨⲚ ⲈⲦⲈⲚⲞⲨ ⲤⲈⲞⲨⲰⲘ ϨⲰⲤ ϢⲰⲰⲦ ⲚⲈⲒⲆⲰⲖⲞⲚ ⲀⲨⲰ ⲦⲈⲨⲤⲨⲚⲈⲒⲆⲎⲤⲒⲤ ⲈⲤϬⲞⲞⲂ ⲤⲦⲰⲖⲘ. ");
INSERT INTO copshc_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ⲘⲚ ϨⲢⲈ ⲆⲈ ⲚⲀⲠⲀⲢϨⲒⲤⲦⲀ ⲘⲘⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ. ⲞⲨⲆⲈ ⲈⲚϢⲀⲚⲦⲘⲞⲨⲰⲘ ⲚⲦⲚⲚⲀϢⲰⲰⲦ ⲀⲚ. ⲞⲨⲆⲈ ⲈⲚϢⲀⲚⲞⲨⲰⲘ ⲚⲦⲚⲚⲀⲢϨⲞⲨⲞ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ϬⲰϢⲦ ⲆⲈ ⲘⲎⲠⲰⲤ ⲚⲦⲈⲦⲈⲒⲈⲜⲞⲨⲤⲒⲀ ⲚⲦⲈⲦⲎⲨⲦⲚ ϢⲰⲠⲈ ⲚϪⲢⲞⲠ ⲚⲚⲈⲦϬⲞⲞⲂ. ");
INSERT INTO copshc_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ⲈⲢϢⲀⲚ ⲞⲨⲀ ⲄⲀⲢ ⲚⲀⲨ ⲈⲢⲞⲔ ⲠⲈⲦⲈ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲘⲠⲤⲞⲞⲨⲚ ⲈⲔⲚⲎϪ ϨⲚ ⲞⲨⲘⲀ ⲚⲈⲒⲆⲰⲖⲞⲚ ⲈⲨϬⲰⲂ ⲠⲈ. ⲘⲎ ⲚⲦⲈϤⲤⲨⲚⲒⲆⲎⲤⲒⲤ ⲚⲀⲔⲰⲦ ⲀⲚ ⲈⲞⲨⲰⲘ ⲚⲚϢⲰⲰⲦ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ϤⲚⲀϨⲈ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚϬⲒ ⲠⲈⲦϬⲞⲞⲂ ϨⲘ ⲠⲈⲔⲤⲞⲞⲨⲚ. ⲠⲤⲞⲚ ⲈⲚⲦⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ⲦⲀⲒ ⲆⲈ ⲦⲈ ⲐⲈ ⲈⲦⲈⲦⲚⲢⲚⲞⲂⲈ ⲈⲚⲈⲤⲚⲎⲨ. ⲈⲦⲈⲦⲚⲢⲰϨⲦ ⲚⲦⲈⲨⲤⲨⲚⲒⲆⲎⲤⲒⲤ ⲈⲤϬⲞⲞⲂ ⲦⲈⲦⲚⲢⲚⲞⲂⲈ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈϢϪⲈ ⲞⲨϨⲢⲈ ⲦⲈⲦⲚⲀⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲠⲀⲤⲞⲚ ⲚⲚⲀⲞⲨⲈⲘ ⲀϤ ϢⲀ ⲈⲚⲈϨ ϪⲈ ⲚⲚⲈⲈⲒⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ ⲘⲠⲀⲤⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ⲘⲎ ⲀⲚⲄ ⲞⲨⲢⲘϨⲈ ⲀⲚ ⲘⲎ ⲀⲚⲄ ⲞⲨⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲚ ⲘⲎ ⲘⲠⲒⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϪⲞⲈⲒⲤ ⲘⲎ ⲚⲦⲰⲦⲚ ⲀⲚ ⲠⲈ ⲠⲀϨⲰⲂ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ⲈϢϪⲈ ⲀⲚⲄ ⲞⲨⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲚ ⲚϨⲈⲚⲔⲞⲞⲨⲈ. ⲀⲖⲖⲀ ⲀⲚⲄ ⲞⲨⲀ ⲚⲎⲦⲚ. ⲦⲈⲤⲪⲢⲀⲄⲒⲤ ⲄⲀⲢ ⲚⲦⲀⲘⲚⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲦⲰⲦⲚ ⲠⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ⲦⲀⲒ ⲦⲈ ⲦⲀⲀⲠⲞⲖⲞⲄⲒⲀ ⲚⲚⲈⲦⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ⲘⲎ ⲘⲚⲦⲀⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲚⲞⲨⲰⲘ ϨⲒ ⲤⲰ. ");
INSERT INTO copshc_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ⲘⲎ ⲘⲚⲦⲀⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲈⲦⲢⲈⲨⲤⲰⲚⲈ ⲚⲤϨⲒ ⲘⲈ ⲞⲨⲀϨⲤ ⲚⲤⲰⲚ ⲚⲐⲈ ⲚⲚⲔⲈⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲚ ⲚⲈⲤⲚⲎⲨ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲔⲎⲪⲀⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ϪⲚ ⲘⲘⲞⲚ ⲀⲚⲞⲔ ⲘⲀⲨⲀⲀⲦ ⲘⲚ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲘⲚⲦⲀⲚ ⲦⲈⲜⲞⲨⲤⲒⲀ ⲘⲘⲀⲨ ⲈⲦⲘⲢϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ⲚⲒⲘ ⲠⲈ ⲈϢⲀϤⲢⲘⲀⲦⲞⲒ ϨⲚ ⲚⲈϤⲞⲮⲰⲚⲒⲞⲚ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲈⲚⲈϨ. ⲚⲒⲘ ⲠⲈϢⲀϤⲦⲰϬⲈ ⲚⲞⲨⲘⲀ ⲚⲈⲖⲞⲞⲖⲈ ⲚϤⲦⲘⲞⲨⲰⲘ ⲘⲠⲈϤⲔⲀⲢⲠⲞⲤ. ⲚⲒⲘ ⲠⲈϢⲀϤⲘⲞⲞⲚⲈ ⲚⲞⲨⲞϨⲈ ⲚϤⲦⲘⲞⲨⲰⲘ ⲘⲠⲈϤⲈⲢⲰⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ⲘⲎ ⲔⲀⲦⲀ ⲢⲰⲘⲈ ⲈⲒϪⲰ ⲚⲚⲀⲒ. ⲎⲘⲈⲢⲈ ⲠⲔⲈⲚⲞⲘⲞⲤ ϪⲈ ⲚⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ϤⲤⲎϨ ⲄⲀⲢ ϨⲘ ⲠⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ϪⲈ ⲚⲚⲈⲔϢⲂⲦ ⲞⲨⲘⲀⲤⲈ ⲈϤϨⲒ. ⲘⲎ ⲠⲢⲞⲞⲨϢ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈ ϨⲀⲚⲈϨⲞⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ϪⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲦⲂⲎⲎⲦⲚ. ⲚⲦⲀⲨⲤⲀϨϤ ⲄⲀⲢ ⲈⲦⲂⲎⲎⲦⲚ ϪⲈ ϢϢⲈ ⲈⲠⲈⲦⲤⲔⲀⲒ ⲈⲤⲔⲀⲒ ⲈϪⲚ ⲞⲨϨⲈⲖⲠⲒⲤ. ⲀⲨⲰ ⲠⲈⲦϨⲒ ⲈϪⲚ ⲞⲨϨⲈⲖⲠⲒⲤ ⲈⲦⲢⲈϤⲘⲈⲦⲈⲬⲈ. ");
INSERT INTO copshc_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ⲈϢϪⲈ ⲀⲚⲞⲚ ⲀⲚϪⲞ ⲚⲎⲦⲚ ⲚⲚⲈⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲞⲨⲚⲞϬ ⲠⲈ. ⲈϢϪⲈ ⲀⲚⲞⲚ ⲠⲈⲦⲚⲀⲰϨⲤ ⲚⲚⲈⲦⲚⲤⲀⲢⲔⲒⲔⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ⲈϢϪⲈ ⲞⲨⲚ ϨⲈⲚⲔⲞⲞⲨⲈ ⲘⲈⲦⲈⲬⲈ ⲈⲦⲈⲦⲚⲈⲜⲞⲨⲤⲒⲀ ⲚϨⲞⲨⲞ ϬⲈ ⲀⲚ ⲀⲚⲞⲚ ⲀⲖⲖⲀ ⲘⲠⲚⲬⲢⲰ ⲚⲦⲈⲈⲒⲈⲜⲞⲨⲤⲒⲀ ⲀⲖⲖⲀ ⲈⲚϤⲒ ϨⲀ ϨⲰⲂ ⲚⲒⲘ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲚϮ ⲚⲞⲨϪⲢⲞⲠ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ⲚⲦⲈⲦⲚ ⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲈⲦⲢϨⲰⲂ ⲈⲚⲈⲢⲠⲎⲨⲈ ⲈⲨⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲚ ⲚⲀ ⲠⲢⲠⲈ. ⲚⲈⲦⲤⲢⲞϤⲦ ⲈⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ ⲈϢⲀⲨⲠⲰϢ ⲈϪⲰⲞⲨ ⲘⲚ ⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲦⲞϢⲤ ⲚⲚⲈⲦⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲈⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ⲀⲚⲞⲔ ⲆⲈ ⲘⲠⲒⲬⲢⲰ ⲚⲖⲀⲀⲨ ⲚⲚⲀⲒ. ⲚⲦⲀⲒ ⲤⲈϨⲚⲀⲒ ⲆⲈ ⲀⲚ ϪⲈ ⲈⲨⲈϢⲰⲠⲈ ⲚⲦⲈⲈⲒϨⲈ ⲚϨⲎⲦ. ⲚⲀⲚⲞⲨⲤ ⲄⲀⲢ ⲚⲀⲒ ⲈⲦⲢⲀⲘⲞⲨ ⲈϨⲞⲨⲈ ⲠⲀϢⲞⲨϢⲞⲨ ⲈⲦⲈ ⲘⲚ ⲖⲀⲀⲨ ⲚⲀϢⲦⲢⲈϤϢⲰⲠⲈ ⲈϤϢⲞⲨⲈⲒⲦ. ");
INSERT INTO copshc_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ⲈⲒϢⲀⲚⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲄⲀⲢ ⲚⲞⲨϢⲞⲨϢⲞⲨ ⲚⲀⲒ ⲀⲚ ⲠⲈ. ⲞⲨϨⲦⲞⲢ ⲄⲀⲢ ⲈⲢⲞⲒ ⲠⲈ ⲞⲨⲞⲒ ⲄⲀⲢ ⲚⲀⲒ ⲠⲈ ⲈⲒϢⲀⲚⲦⲘⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ. ");
INSERT INTO copshc_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ⲈϢϪⲈ ⲈϨⲚⲀⲒ ⲆⲈ ⲈⲒⲈⲒⲢⲈ ⲘⲠⲀⲒ ⲞⲨⲚⲦⲀⲒ ⲘⲘⲀⲨ ⲚⲞⲨⲂⲈⲔⲈ. ⲈϢϪⲈ ⲚϨⲚⲀⲒ ⲆⲈ ⲀⲚ ⲈⲒⲈ ⲚⲦⲀⲨⲦⲀⲚϨⲞⲨⲦ ⲈⲨⲞⲒⲔⲞⲚⲞⲘⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ⲀϢ ϬⲈ ⲠⲈ ⲠⲀⲂⲈⲔⲈ ϪⲈⲔⲀⲀⲤ ⲠⲈ ⲈⲒⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲦⲀⲔⲀ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲞⲨⲈϢ ⲚϪⲞ ⲈⲂⲞⲖ ⲈⲢⲞϤ ⲈⲦⲘⲦⲢⲀⲈⲒⲢⲈ ⲘⲠⲀϨⲦⲞⲢ ϨⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ⲈⲒⲞ ⲄⲀⲢ ⲚⲢⲘϨⲈ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲀⲒⲀⲀⲦ ⲚϨⲘϨⲀⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ϪⲈ ⲈⲒⲈϮϨⲎⲨ ⲘⲠⲈϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ⲀⲒϢⲰⲠⲈ ⲚⲚⲒⲞⲨⲆⲀⲒ ϨⲰⲤ ⲒⲞⲨⲆⲀⲒ ϪⲈ ⲈⲒⲈϮϨⲎⲨ ⲚⲚⲒⲞⲨⲆⲀⲒ. ⲀⲒϢⲰⲠⲈ ⲚⲚⲈⲦϨⲀ ⲠⲚⲞⲘⲞⲤ ϨⲰⲤ ⲈⲒϨⲀ ⲠⲚⲞⲘⲞⲤ ⲈⲚϮϢⲞⲞⲠ ⲀⲚ ⲀⲚⲞⲔ ϨⲀ ⲠⲚⲞⲘⲞⲤ ϪⲈ ⲈⲒⲈϮϨⲎⲨ ⲚⲚⲈⲦϨⲀ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ⲀⲒϢⲰⲠⲈ ⲚⲚⲀⲚⲞⲘⲞⲤ ϨⲰⲤ ⲀⲚⲞⲘⲞⲤ ⲈⲀⲚⲄ ⲞⲨⲀⲚⲞⲘⲞⲤ ⲀⲚ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲖⲖⲀ ⲈⲀⲚⲄ ⲞⲨⲈⲚⲚⲞⲘⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϪⲈ ⲈⲒⲈϮϨⲎⲨ ⲚⲚⲀⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ⲀⲒϢⲰⲠⲈ ⲚⲚϬⲰⲂ ϨⲰⲤ ϬⲰⲂ ϪⲈ ⲈⲒⲈϮϨⲎⲨ ⲚⲚϬⲰⲂ. ⲀⲒⲢⲤⲘⲞⲦ ⲚⲒⲘ ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ϪⲈⲔⲀⲀⲤ ⲠⲀⲚⲦⲰⲤ ⲈⲒⲈⲦⲞⲨϪⲈϨⲞⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ⲈⲈⲒⲈⲒⲢⲈ ⲆⲈ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲂⲈ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϪⲈ ⲈⲒⲈϢⲰⲠⲈ ⲚⲀϤ ⲚⲔⲞⲒⲚⲰⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ⲚⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ϪⲈ ⲚⲈⲦⲠⲎⲦ ϨⲘ ⲠⲈⲤⲦⲀⲆⲒⲞⲚ ⲤⲈⲠⲎⲦ ⲘⲈⲚ ⲦⲎⲢⲞⲨ ⲞⲨⲀ ⲆⲈ ⲠⲈϢⲀϤϪⲒ ⲠⲈⲔⲖⲞⲘ ⲠⲰⲦ ⲚⲦⲈⲒϨⲈ ϪⲈ ⲈⲦⲈⲦⲚⲈⲦⲀϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲘ ⲈⲦⲀⲄⲰⲚⲒⲌⲈ ϢⲀϤⲈⲄⲔⲢⲀⲦⲈⲨⲈ ⲘⲘⲞϤ ⲈϨⲰⲂ ⲚⲒⲘ ⲚⲎ ⲘⲈⲚ ϪⲈ ⲈⲨⲈϪⲒ ⲚⲞⲨⲔⲖⲞⲘ ⲈϢⲀϤⲦⲀⲔⲞ. ⲀⲚⲞⲚ ⲆⲈ ⲚⲞⲨⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ⲀⲚⲞⲔ ϬⲈ ⲈⲒⲠⲎⲦ ⲚⲦⲈⲒϨⲈ ϨⲰⲤ ϨⲚ ⲞⲨϨⲰⲠ ⲀⲚ. ⲈⲒⲠⲨⲔⲦⲈⲨⲈ ⲚⲦⲈⲒϨⲈ ϨⲰⲤ ⲈⲚⲈⲈⲒϨⲒⲞⲨⲈ ⲀⲚ ⲈⲠⲀⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ⲀⲖⲖⲀ ϮⲰϤⲈ ⲘⲠⲀⲤⲰⲘⲀ ϮⲈⲒⲢⲈ ⲘⲘⲞϤ ⲚϨⲘϨⲀⲖ. ⲘⲎⲠⲰⲤ ⲈⲒⲦⲀϢⲈⲞⲈⲒϢ ⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲦⲀϢⲰⲠⲈ ⲀⲚⲞⲔ ⲚϪⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ϮⲞⲨⲰϢ ⲄⲀⲢ ⲈⲦⲢⲈⲦⲚⲈⲒⲘⲈ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲚⲈⲚⲈⲒⲞⲦⲈ ⲦⲎⲢⲞⲨ ⲚⲈⲨϢⲞⲞⲠ ⲠⲈ ϨⲀ ⲦⲈⲔⲖⲞⲞⲖⲈ. ⲀⲨⲰ ⲀⲨⲈⲒ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ϨⲒⲦⲚ ⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲂⲀⲠⲦⲒⲌⲈ ⲈⲘⲰⲨⲤⲎⲤ ϨⲚ ⲦⲈⲔⲖⲞⲞⲖⲈ ⲘⲚ ⲐⲀⲖⲀⲤⲤⲀ. ");
INSERT INTO copshc_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲞⲨⲰⲘ ⲚⲞⲨϨⲢⲈ ⲚⲞⲨⲰⲦ ⲘⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ⲀⲨⲰ ⲚⲦⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲤⲰ ⲚⲞⲨⲤⲰ ⲚⲞⲨⲰⲦ ⲘⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ. ⲀⲨⲤⲰ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲦⲒⲔⲎ ⲘⲠⲈⲦⲢⲀ ⲈⲤⲞⲨⲎϨ ⲚⲤⲰⲞⲨ. ⲦⲠⲈⲦⲢⲀ ⲆⲈ ⲚⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ⲀⲖⲖⲀ ⲘⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲰⲔ ⲚϨⲎⲦ ⲘⲚ ⲠⲈⲨϨⲞⲨⲞ. ⲀⲨⲠⲞⲢϢⲞⲨ ⲄⲀⲢ ϨⲘ ⲠϪⲀⲒⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ⲚⲀⲒ ⲆⲈ ⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲚⲀⲚ ⲚⲤⲘⲞⲦ ⲈⲦⲘⲦⲢⲈⲚϢⲰⲠⲈ ⲚⲢⲈϤⲈⲠⲒⲐⲨⲘⲒ ⲈⲚⲈⲐⲞⲞⲨ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲚⲎ ⲈⲠⲒⲐⲨⲘⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ⲞⲨⲆⲈ ⲘⲠⲢϢⲰⲠⲈ ⲚⲢⲈϤϢⲘϢⲈ ⲈⲒⲆⲰⲖⲞⲚ ⲔⲀⲦⲀ ⲐⲈ ⲚϨⲞⲒⲚⲈ ⲘⲘⲞⲞⲨ. ⲚⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀϤϨⲘⲞⲞⲤ ⲚϬⲒ ⲠⲖⲀⲞⲤ ⲈⲞⲨⲰⲘ ⲈⲤⲰ. ⲀⲨⲰ ⲀⲨⲦⲰⲞⲨⲚ ⲈⲤⲰⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ⲞⲨⲆⲈ ⲘⲠⲢⲦⲢⲈⲚⲠⲞⲢⲚⲈⲨⲈ ⲚⲐⲈ ⲈⲚⲦⲀ ϨⲞⲒⲚⲈ ⲘⲘⲞⲞⲨ ⲠⲞⲢⲚⲈⲨⲈ. ⲀⲨⲰ ⲀⲨϨⲈ ⲚⲞⲨϨⲞⲞⲨ ⲚⲞⲨⲰⲦ ⲚϬⲒ ϪⲞⲨⲦϢⲞⲘⲦⲈ ⲚϢⲞ. ");
INSERT INTO copshc_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ⲞⲨⲆⲈ ⲘⲠⲢⲦⲢⲈⲚⲠⲈⲒⲢⲀⲌⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ϨⲞⲒⲚⲈ ⲘⲘⲞⲞⲨ ⲠⲈⲒⲢⲀⲌⲈ. ⲀⲨⲰ ⲀⲨϨⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚϨⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ⲞⲨⲆⲈ ⲘⲠⲢⲔⲢⲘⲢⲘ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ϨⲞⲒⲚⲈ ⲘⲘⲞⲞⲨ ⲔⲢⲘⲢⲘ ⲀⲨⲰ ⲀⲨϨⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϢⲀϤⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ⲚⲀⲒ ⲆⲈ ϨⲈⲚⲦⲨⲠⲞⲤ ⲚⲈ ⲚⲐⲈ ⲈⲚⲦⲀⲨϢⲰⲠⲈ ⲚⲚⲎ. ⲀⲨⲤϨⲀⲒⲤⲞⲨ ⲆⲈ ⲚⲀⲚ ⲈⲨⲤⲂⲰ ⲚⲀⲒ ⲈⲚⲦⲀⲐⲀⲎ ⲚⲚⲀⲒⲰⲚ ⲔⲀⲦⲀⲚⲦⲀ ⲈⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ϨⲰⲤⲦⲈ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲀϨⲈⲢⲀⲦ ⲘⲀⲢⲈϤϬⲰϢⲦ ⲘⲎⲠⲰⲤ ⲚϤϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ⲘⲠⲈ ⲠⲈⲒⲢⲀⲤⲘⲞⲤ ⲦⲀϨⲰⲦⲚ ⲚⲤⲀ ⲠⲈⲒⲢⲀⲤⲘⲞⲤ ⲚⲢⲰⲘⲈ. ⲞⲨⲠⲒⲤⲦⲞⲤ ⲆⲈ ⲠⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈⲦⲈⲚϤⲚⲀⲔⲀⲀⲨ ⲀⲚ ⲈⲠⲈⲒⲢⲀⲌⲈ ⲘⲘⲰⲦⲚ ⲚϨⲞⲨⲞ ⲈⲦⲈⲦⲚϬⲞⲘ. ⲀⲖⲖⲀ ϨⲘ ⲠⲠⲈⲒⲢⲀⲤⲘⲞⲤ ϤⲚⲀϮⲐⲈ ⲚⲎⲦⲚ ⲈⲈⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲈⲠⲦⲢⲈⲦⲚⲈϢϬⲘϬⲞⲘ ⲈϤⲒ. ");
INSERT INTO copshc_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲚⲀⲘⲈⲢⲀⲦⲈ ⲠⲰⲦ ⲈⲂⲞⲖ ⲚⲦⲘⲚⲦⲢⲈϤϢⲘϢⲈ ⲈⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϨⲰⲤ ⲤⲀⲂⲈⲈⲨ. ⲔⲢⲒⲚⲈ ⲚⲦⲰⲦⲚ ⲘⲠⲈϮⲚⲀϪⲞⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ⲠⲀⲠⲞⲦ ⲘⲠⲈⲤⲘⲞⲨ ⲈϢⲀⲚⲤⲘⲞⲨ ⲈⲢⲞϤ ⲘⲎ ⲚⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲀⲚ ⲠⲈ ⲘⲠⲈⲤⲚⲞϤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲞⲈⲒⲔ ⲈϢⲀⲚⲠⲞϢϤ ⲘⲎ ⲚⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲀⲚ ⲠⲈ ⲘⲠⲤⲰⲘⲀ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ϪⲈ ⲞⲨⲞⲈⲒⲔ ⲚⲞⲨⲰⲦ ⲠⲈ. ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ ⲀⲚⲞⲚ ⲦⲎⲢⲚ. ⲀⲚⲞⲚ ⲄⲀⲢ ⲦⲎⲢⲚ ⲦⲚϪⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲒⲞⲈⲒⲔ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ϬⲰϢⲦ ⲈⲠⲒⲤⲢⲀⲎⲖ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲘⲎ ⲚⲈⲦⲞⲨⲰⲘ ⲀⲚ ⲚⲚⲈⲐⲨⲤⲒⲀ ⲚⲈ ⲚⲔⲞⲒⲚⲰⲚⲞⲤ ⲘⲠⲈⲐⲨⲤⲒⲀⲤⲦⲎⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ⲞⲨ ϬⲈ ⲠⲈϮϪⲰ ⲘⲘⲞϤ. ⲘⲎ ⲈⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚϢⲰⲰⲦ ⲚⲈⲒⲆⲰⲖⲞⲚ ϢⲞⲞⲠ. ⲎϪⲈ ⲞⲨⲚ ⲈⲒⲆⲰⲖⲞⲚ ϢⲞⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ⲀⲖⲖⲀ ϪⲈ ⲚⲈⲦⲈⲢⲈ ⲚϨⲈⲐⲚⲞⲤ ϢⲰⲰⲦ ⲘⲘⲞⲞⲨ ⲈⲨϢⲰⲰⲦ ⲘⲘⲞⲞⲨ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲚ. ⲚϮⲞⲨⲰϢ ⲆⲈ ⲀⲚ ⲈⲦⲢⲈⲦⲚⲢⲔⲞⲒⲚⲰⲚⲞⲤ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ⲘⲚϢϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈⲤⲈ ⲠⲀⲠⲞⲦ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲠⲀⲠⲞⲦ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ ⲘⲚϢϬⲞⲘ ⲘⲘⲰⲦⲚ ⲈϪⲒ ⲚⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲘⲠϪⲞⲈⲒⲤ ⲀⲨⲰ ⲦⲈⲦⲢⲀⲠⲈⲌⲀ ⲚⲚⲆⲀⲒⲘⲰⲚⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ⲎⲈⲚⲚⲀϮⲔⲰϨ ⲘⲠϪⲞⲈⲒⲤ. ⲘⲎ ⲈⲚϪⲞⲞⲢ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ⲈⲜⲈⲤⲦⲈⲒ ⲈⲢϨⲰⲂ ⲚⲒⲘ ⲀⲖⲖⲀ ϨⲰⲂ ⲚⲒⲘ ⲢⲚⲞϤⲢⲈ ⲀⲚ. ⲈⲜⲈⲤⲦⲒ ⲈⲢϨⲰⲂ ⲚⲒⲘ. ⲀⲖⲖⲀ ϨⲰⲂ ⲚⲒⲘ ⲔⲰⲦ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ⲘⲠⲢⲦⲢⲈ ⲖⲀⲀⲨ ϢⲒⲚⲈ ⲚⲤⲀ ⲦⲈϤⲚⲞϤⲢⲈ. ⲀⲖⲖⲀ ⲦⲀⲔⲈ ⲞⲨⲀ ");
INSERT INTO copshc_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲞⲨϮ ⲘⲘⲞⲞⲨ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲀⲔⲈⲖⲖⲞⲤ ⲞⲨⲞⲘⲞⲨ ⲈⲚⲦⲈⲦⲚⲀⲚⲀⲔⲢⲒⲚⲈ ⲖⲀⲀⲨ ⲀⲚ ⲈⲦⲂⲈ ⲦⲤⲨⲚⲒⲆⲎⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ⲠⲀ ⲠϪⲞⲈⲒⲤ ⲄⲀⲢ ⲠⲈ ⲠⲔⲀϨ ⲘⲚ ⲠⲈϤϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ⲈⲢϢⲀⲚ ⲞⲨⲀ ⲚⲚⲀⲠⲒⲤⲦⲞⲤ ⲦⲈϨⲘ ⲦⲎⲨⲦⲚ ⲈⲨⲆⲒⲠⲚⲞⲚ ⲚⲦⲈⲦⲚ ⲞⲨⲰϢ ⲈⲂⲰⲔ. ⲚⲔⲀ ⲚⲒⲘ ⲈⲦⲞⲨⲚⲀⲔⲀⲀⲨ ϨⲀⲢⲰⲦⲚ ⲞⲨⲞⲘⲞⲨ ⲈⲚⲦⲈⲦⲚⲀⲚⲀⲔⲢⲒⲚⲈ ⲖⲀⲀⲨ ⲀⲚ ⲈⲦⲂⲈ ⲦⲤⲨⲚⲒⲆⲎⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ⲈⲢϢⲀⲚ ⲞⲨⲀ ⲆⲈ ϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲠⲀⲒ ⲞⲨϢⲰⲰⲦ ⲚⲢⲠⲈ ⲠⲈ ⲘⲠⲢⲞⲨⲞⲘϤ ⲈⲦⲂⲈ ⲠⲎ ⲈⲚⲦⲀϤϪⲞⲞⲤ ⲚⲎⲦⲚ ⲘⲚ ⲦⲤⲨⲚⲒⲆⲎⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ⲦⲤⲨⲚⲒⲆⲎⲤⲒⲤ ⲆⲈ ⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲦⲰⲔ ⲀⲚ ⲦⲈ. ⲀⲖⲖⲀ ⲦⲀⲠⲎ. ⲈⲦⲂⲈ ⲞⲨ ⲄⲀⲢ ⲤⲈⲔⲢⲒⲚⲈ ⲚⲦⲀⲘⲚⲦⲢⲘϨⲈ ϨⲒⲦⲚ ⲔⲈⲤⲨⲚⲒⲆⲎⲤⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ⲈϢϪⲈ ⲀⲚⲞⲔ ϮⲘⲈⲦⲈⲬⲈ ⲈⲨⲬⲀⲢⲒⲤ. ϪⲈ ⲞⲨ ⲤⲈϪⲒⲞⲨⲀ ⲈⲢⲞⲒ ϨⲘ ⲠⲈϮϢⲠϨⲘⲞⲦ ⲀⲚⲞⲔ ϨⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ⲈⲒⲦⲈ ϬⲈ ⲈⲦⲈⲦⲚⲞⲨⲰⲘ. ⲈⲒⲦⲈ ⲈⲦⲈⲦⲚⲤⲰ. ⲈⲒⲦⲈ ⲠⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞϤ ϨⲰⲂ ⲚⲒⲘ ⲀⲢⲒⲤⲞⲨ ⲈⲨⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ϢⲰⲠⲈ ⲀϪⲚ ϪⲢⲞⲠ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲘⲚ ⲚϨⲈⲖⲖⲎⲚ ⲘⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ⲔⲀⲦⲀ ⲐⲈ ϨⲰ ⲈϮⲀⲢⲈⲤⲔⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲘ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲈⲚϮϢⲒⲚⲈ ⲀⲚ ⲚⲤⲀⲦⲀⲚⲞϤⲢⲈ. ⲀⲖⲖⲀ ⲦⲀϨⲀϨ ϪⲈ ⲈⲨⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ⲦⲚⲦⲚ ⲦⲎⲨⲦⲚ ⲈⲢⲞⲒ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲒ ⲦⲚⲦⲰⲚⲦ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ϮⲈⲠⲀⲒⲚⲞⲨ ⲆⲈ ⲘⲘⲰⲦⲚ ϪⲈ ⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲠⲀⲘⲈⲈⲨⲈ ϨⲚ ϨⲰⲂ ⲚⲒⲘ. ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲒϮ ⲚⲎⲦⲚ ⲚⲘⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲦⲈⲦⲚⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ϮⲞⲨⲰϢ ⲆⲈ ⲈⲦⲢⲈⲦⲚⲈⲒⲘⲈ ϪⲈ ⲦⲀⲠⲈ ⲚϨⲞⲞⲨⲦ ⲚⲒⲘ ⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲦⲀⲠⲈ ⲆⲈ ⲚⲦⲈⲤϨⲒ ⲘⲈ ⲠⲈ ⲠⲈⲤϨⲀⲒ. ⲦⲀⲠⲈ ⲆⲈ ⲚⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ⲢⲰⲘⲈ ⲚⲒⲘ ⲈϤϢⲖⲎⲖ ⲎⲈϤⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲈⲢⲈ ⲦⲈϤⲀⲠⲈ ϨⲞⲂⲤ ϤϮϢⲒⲠⲈ ⲚⲦⲈϤⲀⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ⲤϨⲒⲘⲈ ⲆⲈ ⲚⲒⲘ ⲈⲤϢⲖⲎⲖ ⲎⲈⲤⲠⲢⲞⲪⲎ ⲦⲈⲨⲈ ⲈⲢⲈ ⲦⲈⲤⲀⲠⲈ ϬⲞⲖⲠ ⲈⲂⲞⲖ ⲤϮϢⲒⲠⲈ ⲚⲦⲈⲤⲀⲠⲈ. ⲦⲈⲒϨⲈ ⲄⲀⲢ ⲦⲈ. ⲀⲨⲰ ⲠⲈⲈⲒϨⲰⲂ ⲚⲞⲨⲰⲦ ⲠⲈ ⲚⲦⲈⲦⲈⲢⲈ ϪⲰⲤ ϨⲞⲞⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ⲈϢϪⲈ ⲤⲚⲀϨⲂⲤ ϪⲰⲤ ⲄⲀⲢ ⲀⲚ ⲚϬⲒ ⲦⲈⲤϨⲒⲘⲈ ⲘⲀⲢⲈⲤϢⲂ ϪⲰⲤ. ⲈϢϪⲈ ⲞⲨϢⲖⲞϤ ⲆⲈ ⲚⲦⲈⲤϨⲒⲘⲈ ⲠⲈ ϢⲂ ϪⲰⲤ ⲎϨⲈⲔⲈ ϪⲰⲤ. ⲘⲀⲢⲈⲤϨⲂⲤ ϪⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ⲠϨⲞⲞⲨⲦ ⲄⲀⲢ ⲚϢϢⲈ ⲀⲚ ⲈⲢⲞϤ ⲈϨⲰⲂⲤ ⲚⲦⲈϤⲀⲠⲈ. ⲈⲐⲒⲔⲰⲚ ⲠⲈ ⲀⲨⲰ ⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ⲦⲈⲤϨⲒⲘⲈ ⲆⲈ ⲠⲈⲞⲞⲨ ⲘⲠⲈⲤϨⲀⲒ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ⲚⲦⲀⲨϪⲒ ⲠⲢⲰⲘⲈ ⲄⲀⲢ ⲀⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲤϨⲒⲘⲈ ⲀⲖⲖⲀ ⲚⲦⲀⲨϪⲒ ⲦⲈⲤϨⲒⲘⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ⲔⲀⲒⲄⲀⲢ ⲚⲦⲀⲨⲤⲚⲦ ⲠⲢⲰⲘⲈ ⲀⲚ ⲈⲦⲂⲈ ⲦⲈⲤϨⲒⲘⲈ. ⲀⲖⲖⲀ ⲦⲈⲤϨⲒⲘⲈ ⲈⲦⲂⲈ ⲠⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ⲈⲦⲂⲈ ⲠⲀⲒ ϢϢⲈ ⲈⲦⲈⲤϨⲒⲘⲈ ⲈⲔⲰ ⲚⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲈϪⲚ ⲦⲈⲤⲀⲠⲈ ⲈⲦⲂⲈ ⲚⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ⲠⲖⲎⲚ ⲘⲚ ⲤϨⲒⲘⲈ ⲀϪⲚ ϨⲞⲞⲨⲦ ⲞⲨⲆⲈ ϨⲞⲞⲨⲦ ⲚⲞⲨⲈϢ ⲚⲤϨⲒⲘⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ⲚⲐⲈ ⲄⲀⲢ ⲚⲦⲈⲤϨⲒⲘⲈ ⲈⲨⲈⲂⲞⲖ ϨⲘ ⲠϨⲞⲞⲨⲦ ⲦⲈ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠϨⲞⲞⲨⲦ ⲈⲨⲈⲂⲞⲖ ϨⲚ ⲦⲈⲤϨⲒⲘⲈ ⲠⲈ. ⲠⲦⲎⲢϤ ⲆⲈ ϨⲈⲚⲈⲂⲞⲖ ϨⲘ ⲠⲚⲞⲨⲦⲈ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ⲔⲢⲒⲚⲈ ⲚⲦⲰⲦⲚ ⲚϨⲎ ⲦⲦⲎⲨⲦⲚ. ϢϢⲈ ⲈⲨⲤϨⲒⲘⲈ ⲈϢⲖⲎⲖ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲢⲈ ϪⲰⲤ ϬⲞⲖⲠ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ⲈⲒⲈ ⲚⲦⲈⲈⲒⲔⲈⲪⲨⲤⲒⲤ ⲚⲀⲦⲤⲀⲂⲈ ⲦⲎⲨⲦⲚ ⲀⲚ. ϪⲈ ⲞⲨⲢⲰⲘⲈ ⲘⲈⲚ ⲈϤϢⲀⲚⲞⲨⲈϨ ϤⲰ ⲞⲨⲤⲰϢ ⲚⲀϤ ⲠⲈ ");
INSERT INTO copshc_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ⲞⲨⲤϨⲒⲘⲈ ⲆⲈ ⲈⲤϢⲀⲚⲞⲨⲈϨ ϤⲰ ⲞⲨⲈⲞⲞⲨ ⲚⲀⲤ ⲠⲈ. ϪⲈ ⲠϤⲰ ⲈⲚⲦⲀⲨⲦⲀⲀϤ ⲚⲀⲤ ⲈⲠⲘⲀ ⲚⲞⲨⲢϢⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ⲈϢϪⲈ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ⲈⲨⲘⲀⲒ ϮⲦⲰⲚ ⲠⲈ ⲀⲚⲞⲚ ⲘⲚ ⲦⲀⲚ ⲤⲨⲚⲒⲐⲒⲀ ⲘⲘⲀⲨ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲞⲨⲆⲈ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ⲠⲀⲒ ⲆⲈ ϮⲠⲀⲢⲀⲄⲄⲈⲒⲖⲈ ⲘⲘⲞϤ ⲈⲒⲈⲠⲀⲒⲚⲞⲨ ⲀⲚ ϪⲈ ⲈⲦⲈⲦⲚⲤⲰⲞⲨϨ ⲀⲚ ⲈⲨϪⲒⲤⲈ. ⲀⲖⲖⲀ ⲈⲨϨⲂⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ϢⲞⲢⲠ ⲘⲈⲚ ⲄⲀⲢ ⲈⲦⲈⲦⲚⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ϮⲤⲰⲦⲘ ϪⲈ ⲞⲨⲚ ϨⲈⲚⲠⲰⲢϪ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲀⲨⲰ ϮⲠⲒⲤⲦⲈⲨⲈ ϨⲚ ⲞⲨⲘⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲈ ϨⲈⲚϨⲀⲒⲢⲈⲤⲒⲤ ϢⲰⲠⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲈⲢⲈ ⲚⲔⲈⲤⲰⲦⲠ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ⲈⲦⲈⲦⲚⲤⲰⲞⲨϨ ϬⲈ ⲈϨⲞⲨⲚ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ⲚⲞⲨⲔⲨⲢⲒⲀⲔⲞⲚ ⲀⲚ ⲠⲈ ⲚⲆⲒⲠⲚⲞⲚ ⲈⲞⲨⲞⲘϤ. ");
INSERT INTO copshc_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ⲠⲞⲨⲀ ⲄⲀⲢ ⲠⲞⲨⲀ ⲢϢⲞⲢⲠ ⲈⲞⲨⲰⲘ ⲘⲠⲈϤⲆⲒⲠⲚⲞⲚ. ⲀⲨⲰ ⲞⲨⲚ ⲞⲨⲀ ⲘⲈⲚ ϨⲔⲀⲈⲒⲦ ⲞⲨⲚ ⲞⲨⲀ ⲆⲈ ⲦⲀϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ⲘⲎ ⲈⲦⲈⲘⲚⲦⲎⲦⲚ ⲎⲈⲒ ⲘⲘⲀⲨ ⲈⲞⲨⲰⲘ ⲀⲨⲰ ⲈⲤⲰ ϪⲚ ⲘⲘⲞⲚ ⲈⲦⲈⲦⲚⲔⲀⲦⲀⲪⲢⲞⲚⲒ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲈⲦⲈⲦⲚϮϢⲒⲠⲈ ⲚⲚⲈⲦⲈⲘⲚⲦⲀⲨ ⲦⲀϪⲞⲞⲤ ⲚⲎⲦⲚ ϪⲈ ⲞⲨ ⲦⲀⲈⲠⲀⲒⲚⲞⲨ ⲘⲘⲰⲦⲚ ϨⲘ ⲠⲀⲒ ⲚϮⲈⲠⲀⲒⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ ⲘⲠⲈⲚⲦⲀⲒⲦⲀⲀϤ ⲚⲎⲦⲚ. ϪⲈ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϨⲚ ⲦⲈⲨϢⲎ ⲈⲦⲞⲨⲚⲀⲦⲀⲀϤ ⲚϨⲎⲦⲤ. ⲀϤϪⲒ ⲚⲞⲨⲞⲈⲒⲔ ");
INSERT INTO copshc_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ. ⲀϤⲠⲞϢϤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲀⲀϤ ϨⲀⲢⲰⲦⲚ ⲀⲢⲒⲠⲀⲒ ⲈⲠⲀⲢⲘⲈⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ⲀⲨⲰ ⲞⲨⲀⲠⲞⲦ ⲞⲚ ⲚⲦⲈⲒϨⲈ ⲘⲚⲚⲤⲀ ⲦⲢⲈⲨⲞⲨⲰⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲒⲀⲠⲞⲦ ⲠⲈ ⲦⲆⲒⲀⲐⲎⲔⲎ ⲚⲂⲢⲢⲈ ϨⲘ ⲠⲀⲤⲚⲞϤ. ⲀⲢⲒⲠⲀⲒ ⲚⲦⲀⲠⲤ ⲚⲤⲞⲠ ⲈⲦⲈⲦⲚⲀⲤⲰ ⲈⲠⲀⲢⲠⲘⲈⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ⲤⲞⲠ ⲄⲀⲢ ⲚⲒⲘ ⲈⲦⲈⲦⲚⲀⲞⲨⲰⲘ ⲘⲠⲈⲒⲞⲈⲒⲔ ⲚⲦⲈⲦⲚ ⲤⲰ ⲘⲠⲀⲠⲞⲦ ⲈⲦⲈⲦⲚⲦⲀϢⲈⲞⲈⲒϢ ⲘⲠⲘⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ϢⲀⲚⲦϤⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ϨⲰⲤⲦⲈ ⲠⲈⲦⲚⲀⲞⲨⲰⲘ ⲘⲠⲞⲈⲒⲔ ⲚϤⲤⲰ ⲘⲠⲀⲠⲞⲦ ⲘⲠϪⲞⲈⲒⲤ ⲈⲚϤⲘⲠϢⲀ ⲀⲚ. ϤⲚⲀϢⲰⲠⲈ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲠⲤⲰⲘⲀ ⲘⲚ ⲠⲈⲤⲚⲞϤ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ⲘⲀⲢⲈ ⲠⲢⲰⲘⲈ ⲆⲈ ⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲘⲞϤ ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲀⲢⲈϤⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲘ ⲠⲞⲈⲒⲔ. ⲀⲨⲰ ⲚϤⲤⲰ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲠⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ⲠⲈⲦⲞⲨⲰⲘ ⲄⲀⲢ ⲀⲨⲰ ⲈⲦⲤⲰ ⲈϤⲞⲨⲰⲘ ⲀⲨⲰ ⲈϤⲤⲰ ⲚⲀϤ ⲚⲞⲨⲔⲢⲒⲘⲀ ⲈⲚϤⲆⲒⲀⲔⲢⲒⲚⲈ ⲀⲚ ⲘⲠⲤⲰⲘⲀ ");
INSERT INTO copshc_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ⲈⲦⲂⲈ ⲠⲀⲒ ⲞⲨⲚ ϨⲀϨ ϢⲰⲚⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲀⲨⲰ ⲤⲈⲖⲈϪⲖⲰϪ. ⲀⲨⲰ ⲤⲈⲚⲔⲞⲦⲔ ⲚϬⲒ ⲞⲨⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ⲈⲚⲈⲚⲘⲞⲨϢⲦ ⲄⲀⲢ ⲘⲘⲞⲚ ⲚⲈⲨⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞⲚ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ⲈⲨⲔⲢⲒⲚⲈ ⲆⲈ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ. ⲈⲨϮⲤⲂⲰ ⲚⲀⲚ ϪⲈ ⲚⲚⲈⲨⲦϬⲀⲈⲒⲞⲚ ⲘⲚ ⲠⲔⲞⲤⲘⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲨ ⲈⲦⲈⲦⲚⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲞⲨⲰⲘ ⲀϨⲈ ⲈⲚⲈⲦⲚⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ⲠⲈⲦϨⲔⲀⲈⲒⲦ ⲘⲀⲢⲈϤⲞⲨⲰⲘ ⲘⲠⲈϤⲎⲈⲒ ϪⲈ ⲚⲚⲈⲦⲚⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲈⲨⲔⲢⲒⲘⲀ. ϮⲚⲀⲦⲈϢ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲆⲈ ⲚⲎⲦⲚ ⲈⲈⲒϢⲀⲚⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ⲈⲦⲂⲈ ⲚⲈⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲆⲈ ⲚⲈⲤⲚⲎⲨ ⲚϮⲞⲨⲰϢ ⲀⲚ ⲈⲦⲢⲈⲦⲚⲢⲀⲦⲤⲞⲞⲨⲚ ");
INSERT INTO copshc_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲚⲈⲦⲈⲦⲚⲞ ⲚϨⲈⲐⲚⲞⲤ ⲠⲈ. ⲈⲦⲈⲦⲚⲂⲎⲔ ⲈⲢⲀⲦⲞⲨ ⲚⲚⲈⲒⲆⲰⲖⲞⲚ ⲈⲦⲈⲘⲈⲨϢⲀϪⲈ ⲚⲐⲈ ⲈⲚⲦⲀⲨⲚ ⲦⲎⲨⲦⲚ ⲈϨⲢⲀⲒ ϨⲒⲰⲰⲤ. ");
INSERT INTO copshc_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲦⲀⲘⲞ ⲘⲘⲰⲦⲚ ϪⲈ ⲘⲈⲢⲈ ⲖⲀⲀⲨ ⲈϤϢⲀϪⲈ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲤ ϪⲈ ⲞⲨⲀⲚⲀⲐⲈⲘⲀ ⲠⲈ ⲒⲎⲤⲞⲨⲤ. ⲀⲨⲰ ⲘⲚϢϬⲞⲘ ⲚⲖⲀⲀⲨ ⲈϪⲞⲞⲤ ϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲒⲘⲎⲦⲒ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ⲞⲨⲚ ϨⲈⲚⲠⲰⲢϪ ⲆⲈ ⲚϨⲘⲞⲦ ⲈⲠⲒⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ⲀⲨⲰ ⲞⲨⲚ ϨⲈⲚⲠⲰⲢϪ ⲚⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲠⲒϪⲞⲈⲒⲤ ⲚⲞⲨⲰⲦ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ⲀⲨⲰ ⲞⲨⲚ ϨⲈⲚⲠⲰⲢϪ ⲚⲈⲚⲈⲢⲄⲎⲘⲀ ⲈⲠⲒⲚⲞⲨⲦⲈ ⲚⲞⲨⲰⲦ ⲠⲈⲦⲈⲚⲈⲢⲄⲒ ⲘⲠⲦⲎⲢϤ ϨⲘ ⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ⲤⲈϮ ⲆⲈ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ϨⲘ ⲠⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲈⲦⲚⲞϤⲢⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ⲞⲨⲀ ⲘⲈⲚ ϨⲒⲦⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϢⲀⲨϮ ⲚⲀϤ ⲚⲞⲨϢⲀϪⲈ ⲚⲤⲞⲪⲒⲀ. ⲔⲈⲦ ⲆⲈ ⲚⲞⲨϢⲀϪⲈ ⲚⲤⲞⲞⲨⲚ ⲔⲀⲦⲀ ⲠⲒⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ⲔⲈⲞⲨⲀ ⲆⲈ ⲚⲞⲨⲠⲒⲤⲦⲒⲤ ϨⲘ ⲠⲒⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ. ⲔⲈⲞⲨⲀ ⲆⲈ ⲚϨⲈⲚϨⲘⲞⲦ ⲚⲦⲀⲖϬⲞ ⲔⲀⲦⲀ ⲠⲒⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ⲔⲈⲞⲨⲀ ⲚϨⲈⲚⲈⲚⲈⲢⲄⲎⲘⲀ ⲚϬⲞⲘ ⲔⲈⲞⲨⲀ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲔⲈⲞⲨⲀ ⲚⲞⲨⲆⲒⲀⲔⲢⲒⲤⲒⲤ ⲘⲠⲚⲈⲨⲘⲀ ⲔⲈⲞⲨⲀ ⲚϨⲈⲚⲄⲈⲚⲞⲤ ⲚⲀⲤⲠⲈ ⲔⲈⲞⲨⲀ ⲚⲞⲨϨⲈⲢⲘⲎⲚⲒⲀ ⲚⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲠⲒⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈⲦⲈⲚⲈⲢⲄⲒ ⲘⲘⲞⲞⲨ ⲈϤⲠⲰϢ ⲈϪⲘ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦϤⲞⲨⲀϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ⲚⲐⲈ ⲄⲀⲢ ⲈⲞⲨⲀ ⲠⲈ ⲠⲤⲰⲘⲀ ⲈⲞⲨⲚⲦϤ ϨⲀϨ ⲘⲘⲈⲖⲞⲤ ⲘⲘⲈⲖⲞⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲘⲠⲤⲰⲘⲀ ϨⲀϨ ⲚⲈ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ⲔⲀⲒⲄⲀⲢ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ⲀⲚⲞⲚ ⲦⲎⲢⲚ ⲚⲦⲀⲚⲂⲀⲠⲦⲒⲌⲈ ⲈⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲈⲒⲦⲈ ⲒⲞⲨⲆⲀⲒ ⲈⲒⲦⲈ ⲞⲨⲈⲒⲈⲚⲒⲚ ⲈⲒⲦⲈ ϨⲘϨⲀⲖ ⲈⲒⲦⲈ ⲢⲘϨⲈ ⲀⲨⲰ ⲚⲦⲀⲨⲦⲤⲞⲚ ⲦⲎⲢⲚ ⲚⲞⲨⲠⲚⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ⲔⲀⲒⲄⲀⲢ ⲠⲤⲰⲘⲀ ⲚⲞⲨⲘⲈⲖⲞⲤ ⲚⲞⲨⲰⲦ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ϨⲀϨ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ⲈⲢϢⲀⲚ ⲦⲞⲨⲈⲢⲎⲦⲈ ϪⲞⲞⲤ ϪⲈ ⲀⲚⲄ ⲦϬⲒϪ ⲀⲚ. ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲤⲰⲘⲀ. ⲞⲨⲠⲀⲢⲀⲦⲞⲨⲦⲞ ⲚⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲤⲰⲘⲀ ⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ⲀⲨⲰ ⲈⲢϢⲀⲚ ⲠⲘⲀⲀϪⲈ ϪⲞⲞⲤ ϪⲈ ⲀⲚⲄ ⲠⲂⲀⲖ ⲀⲚ. ⲀⲚⲄ ⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲤⲰⲘⲀ. ⲞⲨⲠⲀⲢⲀⲦⲞⲨⲦⲞ ⲚⲞⲨⲈⲂⲞⲖ ⲀⲚ ϨⲘ ⲠⲤⲰⲘⲀ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ⲈϢϪⲈ ⲠⲤⲰⲘⲀ ⲦⲎⲢϤ ⲠⲈ ⲠⲂⲀⲖ ⲈϤⲦⲰⲚ ⲠⲘⲀⲀϪⲈ. ⲈϢϪⲈ ⲠⲤⲰⲘⲀ ⲦⲎⲢϤ ⲠⲈ ⲠⲘⲀⲀϪⲈ ⲈϤⲦⲰⲚ ⲠϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ⲦⲈⲚⲞⲨ ⲆⲈ ⲀⲠⲚⲞⲨⲦⲈ ⲤⲘⲚ ⲘⲘⲈⲖⲞⲤ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲞⲞⲨ ϨⲘ ⲠⲤⲰⲘⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦϤⲞⲨⲀϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ⲈϢϪⲈ ⲞⲨⲘⲈⲖⲞⲤ ⲆⲈ ⲚⲞⲨⲰⲦ ⲦⲎⲢⲞⲨ ⲚⲈ ⲈϤⲦⲰⲚ ⲠⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ⲦⲈⲚⲞⲨ ⲆⲈ ϨⲀϨ ⲘⲈⲚ ⲚⲈ ⲘⲘⲈⲖⲞⲤ. ⲞⲨⲀ ⲆⲈ ⲠⲈ ⲠⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ⲘⲚ ϬⲞⲘ ⲆⲈ ⲘⲠⲂⲀⲖ ⲈϪⲞⲞⲤ ⲚⲦϬⲒϪ ϪⲈ ⲚϮⲢⲬⲢⲒⲀ ⲘⲘⲞ ⲀⲚ. ⲎⲞⲚ ⲦⲀⲠⲈ ⲚⲚⲞⲨⲈⲢⲎⲦⲈ ϪⲈ ⲚϮⲢⲬⲢⲒⲀ ⲘⲘⲰⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ⲀⲖⲖⲀ ⲚϨⲞⲨⲞ ⲚⲦⲞϤ ⲘⲘⲈⲖⲞⲤ ⲚⲦⲈ ⲠⲤⲰⲘⲀ ⲈⲦⲈⲚⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ ϪⲈ ϨⲈⲚϬⲰⲂ ⲚⲈ ϨⲈⲚⲀⲚⲀⲄⲔⲀⲒⲞⲚ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ⲀⲨⲰ ⲚⲈⲦⲚⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ ⲚⲦⲈ ⲠⲤⲰⲘⲀ ϪⲈ ⲤⲈⲤⲎϢ. ⲦⲚⲞⲨⲰϨ ⲚⲞⲨϨⲞⲨⲈⲦⲒⲘⲎ ⲈⲚⲀⲒ. ⲀⲨⲰ ⲚⲈⲚϢⲒⲠⲈ ⲞⲨⲚⲦⲀⲨ ⲘⲘⲀⲨ ⲚⲞⲨϨⲞⲨⲈ ⲈⲨⲤⲬⲨⲘⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ⲀⲨⲰ ⲚⲈⲦⲚⲈⲤⲰⲞⲨ ⲚⲤⲈⲢⲬⲢⲒⲀ ⲀⲚ. ⲀⲖⲖⲀ ⲀⲠⲚⲞⲨⲦⲈ ⲤⲨⲚⲔⲈⲢⲀ ⲘⲠⲤⲰⲘⲀ ⲈⲀϤϮ ⲚⲞⲨϨⲞⲨⲞ ⲘⲠⲈⲦϢⲀⲀⲦ. ");
INSERT INTO copshc_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲠⲰⲢϪ ϢⲰⲠⲈ ϨⲘ ⲠⲤⲰⲘⲀ. ⲀⲖⲖⲀ ⲈⲢⲈ ⲘⲘⲈⲖⲞⲤ ϤⲒⲢⲞⲞⲨϢ ϨⲀ ⲚⲈⲨⲈⲢⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲞⲨⲚ ⲞⲨⲘⲈⲖⲞⲤ ϢⲰⲚⲈ ϢⲀⲢⲈ ⲘⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ϢⲰⲚⲈ ⲚⲘⲘⲀϤ ⲈⲒⲦⲀ ⲞⲨⲚ ⲞⲨⲘⲈⲖⲞⲤ ϪⲒⲈⲞⲞⲨ ϢⲀⲢⲈ ⲘⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲢⲀϢⲈ ⲚⲘⲘⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ⲚⲦⲰⲦⲚ ⲆⲈ ⲚⲦⲈⲦⲚ ⲠⲤⲰⲘⲀ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲚⲈϤⲘⲈⲖⲞⲤ ⲈⲔ ⲘⲈⲢⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ϨⲞⲒⲚⲈ ⲘⲈⲚ ⲀⲠⲚⲞⲨⲦⲈ ⲔⲀⲀⲨ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲚϢⲞⲢⲠ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲠⲘⲈϨⲤⲚⲀⲨ ⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚⲤⲀϨ ⲘⲚⲚⲤⲰⲤ ϨⲈⲚϬⲞⲘ ⲘⲚⲚⲤⲰⲤ ϨⲈⲚⲬⲀⲢⲒⲤⲘⲀ ⲚⲦⲀⲖϬⲞ ⲞⲨϮⲦⲞⲞⲦⲞⲨ ϨⲈⲚⲢϨⲘⲘⲈ ϨⲈⲚⲄⲈⲚⲞⲤ ⲚⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ⲘⲎ ⲈⲨⲚⲀⲢ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲘⲎ ⲈⲨⲚⲀⲢ ⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲘⲎ ⲈⲨⲚⲀⲢ ⲤⲀϨ ⲦⲎⲢⲞⲨ ⲘⲎ ⲈⲨⲚⲀⲢ ϬⲞⲘ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ⲘⲎ ⲞⲨⲚⲦⲀⲨ ⲦⲎⲢⲞⲨ ⲚϨⲈⲚϨⲘⲞⲦ ⲚⲦⲀⲖϬⲞ. ⲘⲎ ⲈⲨⲚⲀϢⲀϪⲈ ⲦⲎⲢⲞⲨ ϨⲚ ⲚⲀⲤⲠⲈ. ⲘⲎ ⲈⲨⲚⲀϨⲈⲢⲘⲎⲚⲈⲨⲈ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ⲔⲰϨ ⲆⲈ ⲈⲚⲈⲬⲀⲢⲒⲤⲘⲀ ⲚⲞϬ. ⲀⲨⲰ ⲈⲦⲈⲒ ⲠⲈϨⲞⲨⲞ ϮⲚⲀⲦⲤⲀⲂⲰⲦⲚ ⲈⲦⲈϨⲒⲎ. ");
INSERT INTO copshc_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ⲈⲒϢⲀⲚϢⲀϪⲈ ⲚⲚⲀⲤⲠⲈ ⲚⲚⲢⲰⲘⲈ ⲘⲚⲦⲀ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲘⲚⲦⲀⲒ ⲀⲄⲀⲠⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚⲦⲀⲒ ⲢⲐⲈ ⲚⲞⲨϨⲞⲘⲚⲦ ⲈϤϮϨⲢⲞⲞⲨ ⲎⲞⲨⲔⲨⲘⲂⲀⲖⲞⲚ ⲈϤⲰϢ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ⲀⲨⲰ ⲈϢⲰⲠⲈ ⲞⲨⲚⲦⲀⲒ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ. ⲦⲀⲈⲒⲘⲈ ⲈⲘⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲦⲎⲢⲞⲨ ⲘⲚ ⲠⲤⲞⲞⲨⲚ ⲦⲎⲢϤ. ⲔⲀⲚ ⲈⲨⲚⲦⲀⲒ ⲦⲠⲒⲤⲦⲒⲤ ⲦⲎⲢⲤ ϨⲰⲤⲦⲈ ⲈⲠⲈⲚⲈⲦⲞⲞⲨ ⲈⲂⲞⲖ ⲈⲘⲚ ⲀⲄⲀⲠⲎ ⲆⲈ ⲚϨⲎⲦ ⲀⲚⲄ ⲞⲨⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ⲔⲀⲚⲈⲒϢⲀⲚⲦⲘⲘⲞ ⲚⲚⲀϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ⲀⲨⲰ ⲦⲀϮ ⲘⲠⲀⲤⲰⲘⲀ ϪⲈ ⲈⲒⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲒ ⲈⲘⲚⲦⲀⲒ ⲀⲄⲀⲠⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚϮⲚⲀϮϨⲎⲨ ⲀⲚ ⲚⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ⲦⲀⲄⲀⲠⲎ ϢⲀⲤϨⲢⲞϢ ⲚϨⲎⲦ ϢⲀⲤⲢⲬⲢⲎⲤⲦⲞⲤ ⲦⲀⲄⲀⲠⲎ ⲘⲈⲤⲔⲰϨ ⲘⲈⲤⲢⲠⲈⲢⲠⲈⲢⲞⲤ ⲘⲈⲤϪⲒⲤⲈ ⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ⲘⲈⲤⲀⲤⲬⲨⲘⲞⲚⲒ. ⲘⲈⲤϢⲒⲚⲈ ⲚⲤⲀ ⲚⲈⲦⲈⲚⲞⲨⲤ ⲚⲈ. ⲘⲈⲤⲚⲞⲨϬⲤ ⲘⲈⲤⲘⲈⲈⲨⲈ ⲈⲠⲠⲈⲐⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ⲘⲈⲤⲢⲀϢⲈ ⲈϪⲘ ⲠϪⲒ ⲚϬⲞⲚⲤ. ϢⲀⲤⲢⲀϢⲈ ⲚⲦⲞϤ ⲘⲚ ⲦⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ϢⲀⲤϤⲒ ϨⲀ ϨⲰⲂ ⲚⲒⲘ ϢⲀⲤⲠⲒⲤⲦⲈⲨⲈ ⲈⲠⲦⲎⲢϤ ϢⲀⲤϨⲈⲖⲠⲒⲌⲈ ⲈⲠⲦⲎⲢϤ ϢⲀⲤϨⲨⲠⲞⲘⲒⲚⲈ ⲈⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ⲦⲀⲄⲀⲠⲎ ⲘⲈⲤϨⲈ ⲈⲚⲈϨ ⲈⲒⲦⲈ ⲆⲈ ⲚⲈⲠⲢⲞⲪⲎⲦⲒⲀ ⲤⲈⲚⲀⲞⲨⲰⲤϤ ⲈⲒⲦⲈ ⲚⲀⲤⲠⲈ ⲤⲈⲚⲀⲖⲞ ⲈⲒⲦⲈ ⲚⲤⲞⲞⲨⲚ ⲤⲈⲚⲀⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ⲈⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲘⲈⲢⲞⲤ. ⲀⲨⲰ ⲈⲚⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲘⲈⲢⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ϨⲞⲦⲀⲚ ⲆⲈ ⲈϤϢⲀⲚⲈⲒ ⲚϬⲒ ⲠϪⲰⲔ ⲠⲈⲂⲞⲖ ϨⲘ ⲠⲘⲈⲢⲞⲤ ⲚⲀⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ⲘⲠⲈⲨⲞⲈⲒϢ ⲈⲒⲞ ⲚⲔⲞⲨⲒ ⲚⲈⲈⲒϢⲀϪⲈ ⲠⲈ ϨⲰⲤ ⲔⲞⲨⲒ ⲚⲈⲒⲘⲈⲈⲨⲈ ϨⲰⲤ ⲔⲞⲨⲒ ⲚⲈⲒϢⲞϪⲚⲈ ϨⲰⲤ ⲔⲞⲨⲒ ⲚⲦⲈⲢⲒⲢⲚⲞϬ ⲆⲈ ⲀⲒⲞⲨⲰⲤϤ ⲚⲚⲀ ⲠⲔⲞⲨⲒ. ");
INSERT INTO copshc_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ⲦⲚⲚⲀⲨ ⲄⲀⲢ ⲦⲈⲚⲞⲨ ϨⲒⲦⲚ ⲞⲨⲈⲒⲀⲖ ϨⲚ ⲞⲨϨⲢⲂ ⲘⲚⲚⲤⲰⲤ ⲆⲈ ⲚϨⲞ ϨⲒ ϨⲞ. ⲦⲈⲚⲞⲨ ⲄⲀⲢ ⲈⲒⲈⲒⲘⲈ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲘⲈⲢⲞⲤ. ⲘⲚⲚⲤⲰⲤ ⲆⲈ ϮⲚⲀⲤⲞⲞⲨⲚ ⲔⲀⲦⲀ ⲐⲈ ⲞⲚ ⲈⲚⲦⲀⲨⲤⲞⲨⲰⲚⲦ. ");
INSERT INTO copshc_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ⲦⲈⲚⲞⲨ ϬⲈ ⲤϢⲞⲞⲠ ⲚϬⲒ ⲦⲠⲒⲤⲦⲒⲤ ⲐⲈⲖⲠⲒⲤ ⲦⲀⲄⲀⲠⲎ ⲠⲈⲈⲒϢⲞⲘⲚⲦ ⲦⲚⲞϬ ⲆⲈ ⲈⲚⲀⲒ ⲦⲈ ⲦⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ⲠⲰⲦ ⲚⲤⲀ ⲦⲀⲄⲀⲠⲎ. ⲔⲰϨ ⲆⲈ ⲈⲚⲈ ⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ. ⲚϨⲞⲨⲞ ⲆⲈ ϪⲈ ⲈⲦⲈⲦⲚⲈⲠⲢⲞⲪⲎ ⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ⲠⲈⲦϢⲀϪⲈ ⲄⲀⲢ ϨⲚ ⲦⲀⲤⲠⲈ ⲈϤϢⲀϪⲈ ⲀⲚ ⲘⲚ ⲚⲢⲰⲘⲈ ⲀⲖⲖⲀ ⲘⲚ ⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲖⲀⲀⲨ ⲄⲀⲢ ⲤⲰⲦⲘ ⲈⲢⲞϤ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲈϤϪⲰ ⲚϨⲈⲚⲘⲨⲤⲦⲎⲢⲒⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ⲠⲈⲦⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲆⲈ ⲈϤϢⲀϪⲈ ⲘⲚ ⲚⲢⲰⲘⲈ ⲚⲞⲨⲔⲰⲦ. ⲘⲚ ⲞⲨⲤⲞⲠⲤ ⲘⲚ ⲞⲨⲤⲞⲖⲤⲖ. ");
INSERT INTO copshc_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ⲠⲈⲦϢⲀϪⲈ ϨⲚ ⲦⲀⲤⲠⲈ ⲈϤⲔⲰⲦ ⲘⲘⲞϤ ⲞⲨⲀⲀϤ. ⲠⲈⲦⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲆⲈ ⲈϤⲔⲰⲦ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ϮⲞⲨⲰϢ ⲆⲈ ⲈⲦⲢⲈⲦⲈⲦⲚϢⲀϪⲈ ⲦⲎⲢⲦⲚ ϨⲚ ⲚⲀⲤⲠⲈ ⲚϨⲞⲨⲞ ⲆⲈ ϪⲈ ⲈⲦⲈⲦⲚⲈⲠⲢⲞⲪⲎ ⲦⲈⲨⲈ ⲚⲀⲈ ⲠⲈⲦⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲆⲈ ⲈϨⲞⲨⲈ ⲠⲈⲦϢⲀϪⲈ ϨⲚ ⲚⲀⲤⲠⲈ ϨⲒⲂⲞⲖ ⲈϢϪⲈ ⲚϤⲚⲀⲂⲰⲖ ⲀⲚ ϪⲈ ⲈⲢⲈ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ϪⲒ ⲚⲞⲨⲔⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ⲦⲈⲚⲞⲨ ⲆⲈ ⲚⲀⲤⲚⲎⲨ ⲈⲒϢⲀⲚⲈⲒ ϢⲀⲢⲰⲦⲚ ⲈⲒϢⲀϪⲈ ϨⲚ ⲚⲀⲤⲠⲈ ⲈⲒⲚⲀϮϨⲎⲨ ⲘⲘⲰⲦⲚ ⲚⲞⲨ ⲈⲒϢⲀⲚⲦⲘϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ⲎϨⲚ ⲞⲨϬⲰⲖⲠ ⲈⲂⲞⲖ ⲎϨⲚ ⲞⲨⲤⲞⲞⲨⲚ ⲎϨⲚ ⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲎϨⲚ ⲞⲨⲤⲂⲰ. ");
INSERT INTO copshc_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ⲈϢⲰⲠⲈ ⲢⲰ ⲚⲀⲮⲨⲬⲞⲚ ⲈⲨϮ ⲚⲦⲈⲨⲤⲘⲎ ⲈⲒⲦⲈ ⲞⲨⲤⲎⲂⲈ ⲚϪⲰ ⲈⲒⲦⲈ ⲞⲨⲔⲒⲐⲀⲢⲀ ⲈⲨϢⲀⲚⲦⲘϮ ⲚⲞⲨⲠⲰⲢϪ ⲚⲚⲈⲨϨⲢⲞⲞⲨ ⲚⲀϢ ⲚϨⲈ ⲤⲈⲚⲀⲈⲒⲘⲈ ⲈⲠϪⲰ ⲈⲦⲞⲨϪⲰ ⲘⲘⲞϤ ⲎⲠⲈⲦⲞⲨⲔⲒⲐⲀⲢⲒⲌⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ⲔⲀⲒⲄⲀⲢ ⲈⲢϢⲀⲚ ⲞⲨⲤⲀⲖⲠⲒⲄⲜ ϮⲚⲞⲨϨⲢⲞⲞⲨ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲀⲚ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲤⲂⲦⲰⲦϤ ⲈⲠⲠⲞⲖⲈⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ⲦⲀⲒ ⲦⲈ ⲐⲈ ϨⲰⲦ ⲦⲎⲨⲦⲚ ϨⲒⲦⲚ ⲦⲀⲤⲠⲈ ⲈⲦⲈⲦⲚϢⲀⲚⲦⲘϮ ⲚⲞⲨϢⲀϪⲈ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ. ⲚⲀϢ ⲚϨⲈ ⲈⲨⲚⲀⲈⲒⲘⲈ ⲈⲠⲈⲦⲈⲦⲚϪⲰ ⲘⲘⲞϤ. ⲈⲦⲈⲦⲚⲀϢⲰⲠⲈ ⲄⲀⲢ ⲈⲦⲈⲦⲚϢⲀϪⲈ ⲈⲠⲀⲎⲢ. ");
INSERT INTO copshc_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ⲞⲨⲚ ⲞⲨⲀⲠⲤ ⲘⲘⲒⲚⲈ ⲚⲤⲘⲎ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ. ⲀⲨⲰ ⲘⲚ ⲖⲀⲀⲨ ⲈⲘⲚⲦϤ ⲤⲘⲎ. ");
INSERT INTO copshc_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ⲈⲒϢⲀⲚⲦⲘⲈⲒⲘⲈ ⲈⲦϬⲞⲘ ⲚⲦⲈⲤⲘⲎ ϮⲚⲀϢⲰⲠⲈ ⲚⲂⲀⲢⲂⲀⲢⲞⲤ ⲘⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀⲒ. ⲀⲨⲰ ⲈⲨⲂⲀⲢⲂⲀⲢⲞⲤ ⲠⲈ ⲠⲈⲦϢⲀϪⲈ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ⲦⲀⲒ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲦⲈⲦⲚϨⲈ. ⲈⲠⲈⲒ ⲚⲦⲈⲦⲚ ϨⲈⲚⲢⲈϤⲔⲰϨ ⲈⲚⲈ ⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲠⲢⲞⲤⲠⲔⲰⲦ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ϢⲒⲚⲈ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲢϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ⲈⲦⲂⲈ ⲠⲀⲒ ⲠⲈⲦϢⲀϪⲈ ϨⲚ ⲦⲀⲤⲠⲈ ⲘⲀⲢⲈϤϢⲖⲎⲖ. ϪⲈⲔⲀⲀⲤ ⲈϤⲈⲂⲰⲖ. ");
INSERT INTO copshc_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ⲈⲒϢⲀⲚϢⲖⲎⲖ ϨⲚ ⲞⲨⲀⲤⲠⲈ. ⲠⲀⲠⲚⲈⲨⲘⲀ ⲠⲈⲦϢⲖⲎⲖ. ⲠⲀϨⲎⲦ ⲆⲈ ⲞⲨⲀⲦⲔⲀⲢⲠⲞⲤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ⲞⲨ ϬⲈ ⲠⲈϮⲚⲀϢⲖⲎⲖ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϮⲚⲀϢⲖⲎⲖ ⲞⲚ ϨⲘ ⲠⲀⲔⲈϨⲎⲦ ϮⲚⲀⲮⲀⲖⲖⲈⲒ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ϮⲚⲀⲮⲀⲖⲖⲈⲒ ⲞⲚ ϨⲘ ⲠⲀⲔⲈϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ⲈⲘⲘⲞⲚ ⲈⲔϢⲀⲚⲤⲘⲞⲨ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲠⲈⲦϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲘⲀ ⲘⲠϨⲒⲆⲒⲰⲦⲎⲤ ⲚⲀϢ ⲚϨⲈ ϤⲚⲀϪⲰ ⲘⲠϨⲀⲘⲎⲚ ⲈϪⲘ ⲠⲈⲔϢⲠϨⲘⲞⲦ. ⲈⲂⲞⲖ ⲄⲀⲢ ϪⲈ ⲈⲔϪⲈ ⲞⲨ ⲚϤⲤⲞⲞⲨⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ⲚⲦⲞⲔ ⲘⲈⲚ ⲄⲀⲢ ⲔⲀⲖⲰⲤ ⲔϢⲠϨⲘⲞⲦ. ⲀⲖⲖⲀ ⲠⲔⲈⲞⲨⲀ ⲔⲰⲦ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ϮϢⲠϨⲘⲞⲦ ⲚⲦⲘ ⲠⲀⲚⲞⲨⲦⲈ ϪⲈ ϮϢⲀϪⲈ ⲈϨⲞⲨⲈⲢⲰⲦⲚ ⲦⲎⲢⲦⲚ ϨⲚ ⲚⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ⲀⲖⲖⲀ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ϮⲞⲨⲈϢ ϮⲞⲨ ⲚϢⲀϪⲈ ⲈϪⲞⲞⲨ ϨⲘ ⲠⲀϨⲎⲦ ϪⲈ ⲈⲒⲈⲔⲀⲐⲎⲄⲈⲒ ⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲈϨⲞⲨⲈ ⲞⲨⲦⲂⲀ ⲚϢⲀϪⲈ ϨⲚ ⲦⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ⲚⲈⲤⲚⲎⲨ ⲘⲠⲢⲢⲔⲞⲨⲒ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ. ⲀⲖⲖⲀ ⲀⲢⲒⲔⲞⲨⲒ ϨⲚ ⲦⲔⲀⲔⲒⲀ. ⲚⲦⲈⲦⲚ ⲢⲦⲈⲖⲒⲞⲤ ⲆⲈ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ϤⲤⲎϨ ⲄⲀⲢ ϨⲘ ⲠⲚⲞⲘⲞⲤ ϪⲈ ϨⲢⲀⲒ ϨⲚ ϨⲈⲚⲔⲈⲀⲤⲠⲈ ⲘⲚ ϨⲈⲚⲔⲈⲤⲠⲞⲦⲞⲨ ϮⲚⲀϢⲀϪⲈ ⲘⲚ ⲠⲒⲖⲀⲦⲞⲤ ⲀⲨⲰ ⲚⲤⲈⲚⲀⲤⲰⲦⲘ ⲀⲚ ⲈⲢⲞⲒ ⲚⲦⲈⲈⲒⲔⲈϨⲈ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ϨⲰⲤⲦⲈ ⲚⲀⲤⲠⲈ ⲈⲨϢⲞⲞⲠ ⲈⲨⲘⲀⲈⲒⲚ ⲚⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ ⲀⲚ ⲀⲖⲖⲀ ⲚⲚⲀⲠⲒⲤⲦⲞⲤ ⲦⲈⲠⲢⲞⲪⲎⲦⲒⲀ ⲆⲈ ⲚⲈⲤϢⲞⲞⲠ ⲀⲚ ⲚⲚⲀⲠⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ⲚⲚⲈⲦⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ⲈϢⲰⲠⲈ ϬⲈ ⲈⲢϢⲀⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲈⲒ ⲈⲨⲘⲀ ⲚⲞⲨⲰⲦ ⲚⲤⲈϢⲀϪⲈ ⲦⲎⲢⲞⲨ ϨⲚ ⲚⲀⲤⲠⲈ ⲚⲤⲈⲈⲒ ⲆⲈ ⲈϨⲞⲨⲚ ⲚϬⲒ ϨⲈⲚϨⲒⲆⲒⲰⲦⲎⲤ ⲎϨⲈⲚⲀⲠⲒⲤⲦⲞⲤ ⲚⲈⲨⲚⲀϪⲞⲞⲤ ⲀⲚ ϪⲈ ⲈⲦⲈⲦⲚⲖⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ⲈϢⲰⲠⲈ ⲆⲈ ⲈⲨϢⲀⲚⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲦⲎⲢⲞⲨ ⲚⲦⲈ ⲞⲨⲀⲠⲒⲤⲦⲞⲤ ⲆⲈ ⲈⲒ ⲈϨⲞⲨⲚ ⲎⲞⲨϨⲒⲆⲒⲰⲦⲎⲤ ⲤⲈⲚⲀϪⲠⲒⲞϤ ϨⲒⲦⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲤⲈⲚⲀⲀⲚⲀⲔⲢⲒⲚⲈ ⲘⲘⲞϤ ϨⲒⲦⲚ ⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ⲚⲈⲐⲎⲠ ⲘⲠⲈϤϨⲎⲦ ⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲚⲦⲈⲈⲒϨⲈ ϤⲚⲀⲠⲀϨⲦϤ ⲈϪⲘ ⲠⲈϤϨⲞ ⲚϤⲞⲨⲰϢⲦ ⲘⲠⲚⲞⲨⲦⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲚⲦⲰⲤ ⲠⲚⲞⲨⲦⲈ ϢⲞⲞⲠ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ⲞⲨ ϬⲈ ⲠⲈⲦⲚⲀϢⲰⲠⲈ ⲚⲈⲤⲚⲎⲨ ⲈⲦⲈⲦⲚϢⲀⲚⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲮⲀⲖⲘⲞⲤ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲤⲂⲰ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨϬⲰⲖⲠ ⲈⲂⲞⲖ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲀⲤⲠⲈ ⲞⲨⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨϨⲈⲢⲘⲎⲚⲒⲀ ⲘⲀⲢⲞⲨϢⲰⲠⲈ ⲦⲎⲢⲞⲨ ⲈⲨⲔⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ⲈⲒⲦⲈ ⲈⲢⲈ ⲞⲨⲀ ⲚⲀϢⲀϪⲈ ϨⲚ ⲞⲨⲀⲤⲠⲈ ϢⲀⲤⲚⲀⲨ ⲎⲠⲈϨⲞⲨⲞ ϢⲞⲘⲚⲦ ⲚⲤⲈϪⲒ ⲞⲨϢⲎⲘ ⲈⲞⲨⲀ ⲚⲦⲈ ⲞⲨⲀ ⲂⲞⲖⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ⲈϢⲰⲠⲈ ⲆⲈ ⲘⲚ ⲢⲈϤⲂⲰⲖ. ⲘⲀⲢⲈϤⲔⲀⲢⲰϤ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲘⲀⲢⲈϤϢⲀϪⲈ ⲆⲈ ⲚⲘⲘⲀϤ ⲘⲚ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ⲠⲢⲞⲪⲎⲦⲎⲤ ⲆⲈ ⲤⲚⲀⲨ ⲎϢⲞⲘⲚⲦ ⲘⲀⲢⲞⲨϢⲀϪⲈ. ⲀⲨⲰ ⲘⲀⲢⲈ ⲠⲔⲈⲤⲈⲈⲠⲈ ⲆⲒⲀⲔⲢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ⲈϢⲰⲠⲈ ⲆⲈ ⲈϤϢⲀⲚϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲔⲈⲞⲨⲀ ⲈϤϨⲘⲞⲞⲤ ⲘⲀⲢⲈ ⲠϢⲞⲢⲠ ⲔⲀⲢⲰϤ. ");
INSERT INTO copshc_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ⲞⲨⲚϬⲞⲘ ⲄⲀⲢ ⲈⲦⲢⲈⲦⲚⲠⲢⲞⲪⲎⲦⲈⲨⲈ ⲦⲎⲢⲦⲚ ⲞⲨⲀ ⲞⲨⲀ ϪⲈ ⲈⲨⲈⲤⲂⲞ ⲦⲎⲢⲞⲨ ⲚⲤⲈⲤⲈⲠⲤⲰⲠⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ⲚⲦⲈ ⲚⲈⲠⲚⲈⲨⲘⲀ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲚⲈⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copshc_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ⲠⲚⲞⲨⲦⲈ ⲄⲀⲢ ⲘⲠⲀ ⲠⲈϢⲦⲞⲢⲦⲢ ⲀⲚ ⲠⲈ. ⲀⲖⲖⲀ ⲠⲀ ϮⲢⲎⲚⲎ ⲠⲈ. ⲚⲐⲈ ⲈⲦϢⲞⲞⲠ ϨⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ⲚⲈϨⲒⲞⲘⲈ ⲘⲀⲢⲞⲨⲔⲀⲢⲰⲞⲨ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ⲚⲤⲦⲞ ⲄⲀⲢ ⲚⲀⲨ ⲀⲚ ⲈϢⲀϪⲈ. ⲀⲖⲖⲀ ⲘⲀⲢⲞⲨϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲈⲢⲈ ⲠⲔⲈⲚⲞⲘⲞⲤ ϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ⲈϢⲰⲠⲈ ⲆⲈ ⲤⲈⲞⲨⲈϢⲤⲞⲨ ⲚⲞⲨϢⲀϪⲈ ⲘⲀⲢⲞⲨϪⲚⲈ ⲚⲈⲨϨⲀⲒ ϨⲚ ⲚⲈⲨⲎⲒ. ⲞⲨϢⲖⲞϤ ⲄⲀⲢ ⲠⲈ ⲚⲦⲈⲤϨⲒⲘⲈ ⲈϢⲀϪⲈ ϨⲚ ⲦⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ⲎⲚⲦⲀ ⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲒ ⲈⲂⲞⲖ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲎⲚⲦⲀϤⲠⲰϨ ϢⲀⲢⲰⲦⲚ ⲞⲨⲀⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ⲠⲈⲦⲘⲈⲈⲨⲈ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ⲎⲞⲨⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲤ ⲘⲀⲢⲈϤⲈⲒⲘⲈ ⲈⲚⲈϮⲤϨⲀⲒ ⲘⲘⲞⲞⲨ ⲚⲎⲦⲚ ϪⲈ ϨⲈⲚⲈⲚⲦⲞⲖⲎ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ⲠⲈⲦⲞ ⲆⲈ ⲚⲀⲦⲤⲞⲞⲨⲚ ⲤⲈⲞ ⲚⲀⲦⲤⲞⲞⲨⲚ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲨ ⲔⲰϨ ⲈⲠⲢⲞⲪⲎⲦⲈⲨⲈ. ⲀⲨⲰ ⲘⲠⲢⲔⲰⲖⲨ ⲈϢⲀϪⲈ ϨⲚ ⲚⲀⲤⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ⲘⲀⲢⲞⲨϢⲰⲠⲈ ⲆⲈ ⲦⲎⲢⲞⲨ ϨⲚ ⲞⲨⲦⲤⲀⲚⲞ. ⲀⲨⲰ ⲔⲀⲦⲀ ⲦⲀⲜⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ϮⲦⲀⲘⲞ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲈⲠⲀⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲠⲀⲒ ⲈⲚⲦⲀⲒⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲘⲘⲞϤ ⲚⲎⲦⲚ. ⲠⲀⲒ ⲞⲚ ⲈⲚⲦⲀⲦⲈⲦⲚϪⲒⲦϤ. ⲠⲀⲒ ⲞⲚ ⲈⲦⲈⲦⲚⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ⲀⲨⲰ ⲞⲚ ⲈⲦⲈⲦⲚⲀⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ϪⲈ ⲞⲨ ⲠⲈ ⲠϢⲀϪⲈ ⲈⲚⲦⲀⲒⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲘⲘⲞϤ ⲚⲎⲦⲚ ⲈϢϪⲈ ⲦⲈⲦⲚⲀⲘⲀϨⲦⲈ ϨⲒⲂⲞⲖ ⲈϢϪⲈ ⲈⲒⲔⲎ ⲀⲚ ⲀⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ⲀⲒϮ ⲄⲀⲢ ⲚⲎⲦⲚ ⲚϢⲞⲢⲠ ⲘⲠⲈⲚⲦⲀⲒϪⲒⲦϤ. ϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲘⲞⲨ ϨⲀ ⲚⲈⲚⲚⲞⲂⲈ ⲔⲀⲦⲀ ⲚⲈⲄⲢⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ⲀⲨⲰ ϪⲈ ⲀⲨⲦⲞⲘⲤϤ. ⲀⲨⲰ ϪⲈ ⲀϤⲦⲰⲞⲨⲚ ϨⲘ ⲠⲘⲈϨϢⲞⲘⲚⲦ ⲚϨⲞⲞⲨ ⲔⲀⲦⲀ ⲚⲈⲄⲢⲀⲪⲎ. ");
INSERT INTO copshc_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ⲀⲨⲰ ϪⲈ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲔⲎⲪⲀ. ⲈⲒⲦⲀ ⲘⲠⲘⲚⲦⲤⲚⲞⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ⲘⲚⲚⲤⲰⲤ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϨⲞⲨⲞ ⲈϮⲞⲨ ⲚϢⲈ ⲚⲤⲞⲚ ⲚⲞⲨⲤⲞⲠ ⲚⲞⲨⲰⲦ ⲚⲀⲒ ⲈⲢⲈ ⲠⲈⲨϨⲞⲨⲞ ϢⲞⲞⲠ ϢⲀ ⲦⲈⲚⲞⲨ. ϨⲞⲒⲚⲈ ⲆⲈ ⲘⲘⲞⲞⲨ ⲀⲨⲚⲔⲞⲦⲔ. ");
INSERT INTO copshc_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ⲘⲚⲚⲤⲰⲤ ⲀϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲒⲀⲔⲰⲂⲞⲤ. ⲈⲒⲦⲀ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ⲚϨⲀⲈ ⲆⲈ ⲈⲞⲨⲞⲚ ⲚⲒⲘ ⲚⲐⲈ ⲚⲞⲨϨⲞⲨϨⲈ. ⲀϤⲞⲨⲰⲚϨ ϨⲰ ⲚⲀⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲈ ⲠⲈⲖⲀⲬⲒⲤⲦⲞⲤ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲘⲘⲞⲨⲦⲈ ⲈⲢⲞⲒ ϪⲈ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϪⲈ ⲀⲒⲆⲒⲰⲔⲈ ⲚⲤ ⲀⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ⲐⲈ ⲆⲈ ⲈϮⲞ ⲘⲘⲞⲤ ⲈⲒⲞ ⲘⲘⲞⲤ ϨⲘ ⲠⲈϨⲘⲞⲦ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲦⲈϤⲬⲀⲢⲒⲤ ⲈⲚⲦⲀⲤⲠⲰϨ ϢⲀⲢⲞⲒ ⲘⲠⲤϢⲰⲠⲈ ⲈⲤϢⲞⲨⲈⲒⲦ ⲀⲖⲖⲀ ⲀⲒϢⲠϨⲒⲤⲈ ⲈϨⲞⲨⲈ ⲈⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ ⲚⲀⲚⲞⲔ ⲆⲈ ⲀⲚ ⲀⲖⲖⲀ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ⲈⲒⲦⲈ ϬⲈ ⲀⲚⲞⲔ. ⲈⲒⲦⲈ ⲚⲎ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲚⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞⲤ. ⲀⲨⲰ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲚⲦⲀⲦⲈⲦⲚⲠⲒⲤⲦⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ⲈϢϪⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲤⲈⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ ϪⲈ ⲀϤⲦⲰⲞⲨⲚ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀϢ ⲚϨⲈ ⲞⲨⲚ ϨⲞⲒⲚⲈ ϪⲰ ⲘⲘⲞⲤ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ⲈϢϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ ⲈⲒⲈ ⲘⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ⲈϢϪⲈ ⲘⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲈⲒⲈ ⲠⲈⲚⲦⲀϢⲈⲞⲈⲒϢ ϢⲞⲨⲈⲒⲦ. ⲀⲨⲰ ⲤϢⲞⲨⲈⲒⲦ ⲚϬⲒ ⲦⲈⲚⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ⲤⲈⲚⲀϨⲈ ⲆⲈ ⲞⲚ ⲈⲢⲞⲚ ⲈⲚⲞ ⲘⲘⲚⲦⲢⲈ ⲚⲚⲞⲨϪ ⲈⲠⲚⲞⲨⲦⲈ ϪⲈ ⲀⲚⲢⲘⲚⲦⲢⲈ ⲘⲠⲚⲞⲨⲦⲈ. ϪⲈ ⲀϤⲦⲞⲨⲚⲈⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲒ ⲈⲦⲈⲘⲠϤⲦⲞⲨⲚⲞⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ⲈϢϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ. ⲈϢϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲄⲀⲢ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ. ⲈⲒⲈ ⲘⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ⲈϢϪⲈ ⲘⲠⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲈⲒⲈ ⲤϢⲞⲨⲈⲒⲦ ⲚϬⲒ ⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ. ⲀⲨⲰ ⲈⲦⲈⲒ ⲦⲈⲦⲚϢⲞⲞⲠ ϨⲚ ⲚⲈⲦⲚⲚⲞⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ⲈⲒⲈ ⲀⲚⲔⲞⲞⲨⲈ ⲈⲚⲦⲀⲨⲚⲔⲞⲦⲔ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲈ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ⲈϢϪⲈ ϨⲢⲀⲒ ϨⲘ ⲠⲈⲒⲰⲚϨ ⲘⲘⲀⲦⲈ ⲈⲚⲚⲀϨⲦⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲈⲒⲈ ⲀⲚϨⲈⲚⲈⲂⲒⲎⲚ ⲈϨⲞⲨⲈ ⲢⲰⲘⲈ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ⲦⲈⲚⲞⲨ ⲆⲈ ⲀⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲞⲨⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲦⲀⲠⲀⲢⲬⲎ ⲚⲚⲈⲚⲦⲀⲨⲚⲔⲞⲦⲔ ");
INSERT INTO copshc_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ⲈⲠⲈⲒⲆⲎ ⲄⲀⲢ ⲚⲦⲀ ⲠⲘⲞⲨ ϢⲰⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲢⲰⲘⲈ. ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨⲢⲰⲘⲈ ⲞⲚ ⲠⲈ ⲠⲦⲰⲞⲨⲚ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ");
INSERT INTO copshc_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ⲚⲐⲈ ⲄⲀⲢ ⲈⲦⲞⲨⲘⲞⲨ ⲦⲎⲢⲞⲨ ϨⲚ ⲀⲆⲀⲘ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲤⲈⲚⲀⲰⲚϨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ⲠⲞⲨⲀ ⲆⲈ ⲠⲞⲨⲀ ϨⲘ ⲠⲈϤⲦⲀⲄⲘⲀ. ⲦⲀⲠⲀⲢⲬⲎ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲘⲚⲚⲤⲰⲤ ⲚⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲚ ⲦⲈϤⲠⲀⲢϨⲞⲨⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ⲈⲒⲦⲀ ⲐⲀⲎ ⲈϤϢⲀⲚϮ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ ⲠⲈⲒⲰⲦ ⲈϤϢⲀⲚⲞⲨⲰⲤϤ ⲚⲀⲢⲬⲎ ⲚⲒⲘ. ϨⲒ ⲈⲜⲞⲨⲤⲒⲀ ⲚⲒⲘ. ϨⲒϬⲞⲘ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ϨⲀⲠⲤ ⲄⲀⲢ ⲠⲈ ⲈⲦⲢⲈϤⲢⲢⲢⲞ ϢⲀⲚⲦϤⲔⲰ ⲚⲚⲈϤϪⲀϪⲈ ⲦⲎⲢⲞⲨ ϨⲀ ⲚⲈϤⲞⲨⲈⲢⲎⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ⲠϨⲀⲈ ⲆⲈ ⲚϪⲀϪⲈ ϤⲚⲀⲞⲨⲰⲤϤ ⲈⲦⲈ ⲠⲘⲞⲨ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ⲀϤⲔⲀ ⲚⲔⲀ ⲄⲀⲢ ⲚⲒⲘ ϨⲀ ⲚⲈϤⲞⲨⲈⲢⲎ ⲦⲈ. ϨⲞⲦⲀⲚ ⲆⲈ ⲈϤϢⲀⲚϪⲞⲞⲤ ϪⲈ ⲚⲔⲀ ⲚⲒⲘ ⲀⲨϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲀϤ. ⲈⲒⲈ ⲠⲂⲞⲖ ⲘⲠⲈⲚⲦⲀϤⲦⲢⲈ ⲚⲔⲀ ⲚⲒⲘ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲢϢⲀⲚ ⲚⲔⲀ ⲚⲒⲘ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲀϤ. ⲦⲞⲦⲈ ⲚⲦⲞϤ ⲠϢⲎⲢⲈ ϤⲚⲀϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲘⲠⲈⲚⲦⲀϤⲦⲢⲈ ⲚⲔⲀ ⲚⲒⲘ ϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲀϤ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ϢⲰⲠⲈ ⲈⲠⲦⲎⲢϤ ⲠⲈ ⲈϤϨⲘ ⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ⲈⲘⲘⲞⲚ ⲈⲨⲚⲀⲢⲞⲨ ⲚϬⲒ ⲚⲈⲦⲂⲀⲠⲦⲒⲌⲈ ϨⲀ ⲚⲈⲦⲘⲞⲞⲨⲦ. ⲈϢϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲢⲰ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ ⲀϨⲢⲞⲞⲨ ⲤⲈⲂⲀⲠⲦⲒⲌⲈ ϨⲀⲢⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ⲀϨⲢⲞⲚ ϨⲰⲰⲚ ⲦⲚⲔⲒⲚⲆⲨⲚⲈⲨⲈ ⲚⲚⲀⲨ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ϮⲘⲞⲨ ⲘⲘⲎⲚⲈ ϢⲈⲠⲈⲦⲚϢⲞⲨϢⲞⲨ ⲈⲦⲈⲨⲚⲦⲀⲈⲒϤ ⲚⲀⲤⲚⲎⲨ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ⲈϢϪⲈ ⲔⲀⲦⲀ ⲢⲰⲘⲈ ⲚⲦⲀⲒⲘⲒϢⲈ ⲘⲚ ⲚⲈⲐⲎⲢⲒⲞⲚ ϨⲚ ⲈⲪⲈⲤⲞⲤ ⲞⲨ ⲠⲈ ⲠⲀϨⲎⲨ. ⲈϢϪⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚ ⲀⲚ ⲘⲀⲢⲚⲞⲨⲰⲘ ⲚⲦⲚⲤⲰ. ϪⲈ ⲦⲚⲚⲀⲘⲞⲨ ⲄⲀⲢ ⲚⲢⲀⲤⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ⲘⲠⲢⲠⲖⲀⲚⲀ. ϢⲀⲢⲈ ⲚⲒϢⲀϪⲈ ⲈⲐⲞⲞⲨ ⲦⲀⲔⲈ ⲚⲒϨⲎⲦ ⲈⲦⲚⲀⲚⲞⲨⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ⲚⲎⲪⲈ ⲆⲒⲔⲀⲒⲰⲤ ⲀⲨⲰ ⲘⲠⲢⲢⲚⲞⲂⲈ. ⲞⲨⲚ ϨⲞⲒⲚⲈ ⲄⲀⲢ ⲞⲚⲀⲦⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲒϪⲰ ⲚⲚⲀⲒ ⲈⲒϮϢⲒⲠⲈ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ⲀⲖⲖⲀ ⲞⲨⲚ ⲞⲨⲀ ⲚⲀϪⲞⲞⲤ ϪⲈ ⲈⲢⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚ ⲚⲀϢ ⲚϨⲈ. ⲈⲨⲚⲎⲨ ⲆⲈ ϨⲚ ⲀϢ ⲚⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ⲠⲀⲐⲎⲦ ⲚⲦⲞⲔ ⲠⲈϢⲀϤϪⲞϤ ⲘⲈϤⲰⲚϨ. ⲈⲒ ⲘⲎⲦⲒ ⲚϤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ⲀⲨⲰ ⲘⲠⲤⲰⲘⲀ ⲀⲚ ⲈⲦⲚⲀϢⲰⲠⲈ ⲠⲈϢⲀⲔϪⲞϤ. ⲀⲖⲖⲀ ⲞⲨⲂⲖⲂⲒⲖⲈ ⲦⲈ ⲈⲤⲔⲎⲔⲀϨⲎⲨ ⲚⲤⲞⲨⲞ. ⲎⲘⲠⲔⲈⲤⲈⲈⲠⲈ ⲚϬⲢⲞϬ. ");
INSERT INTO copshc_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ϢⲀⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲆⲈ ϮⲚⲀϤ ⲚⲞⲨⲤⲰⲘⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲦϤⲞⲨⲀϢⲤ. ⲀⲨⲰ ⲞⲨⲤⲰⲘⲀ ⲘⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲚⲚⲈϬⲢⲰⲰϬ ⲔⲀⲦⲀⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ⲚⲞⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ ⲀⲚ ⲦⲈ ⲤⲀⲢⲜ ⲚⲒⲘ ⲀⲖⲖⲀ ⲞⲨⲈⲦ ⲦⲀⲚⲢⲰⲘⲈ ⲀⲨⲰ ⲞⲨⲈⲦ ⲦⲤⲀⲢⲜ ⲚⲚⲦⲂⲚⲎ ⲀⲨⲰ ⲞⲨⲈⲦ ⲦⲤⲀⲢⲜ ⲚⲚϨⲀⲖⲎⲦ ⲀⲨⲰ ⲞⲨⲈⲦ ⲦⲀ ⲚⲦⲂⲦ. ");
INSERT INTO copshc_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ⲘⲚ ⲚⲤⲰⲘⲀ ⲈⲦϨⲚ ⲦⲠⲈ ⲘⲚ ⲚⲤⲰⲘⲀ ⲈⲦϨⲘ ⲠⲔⲀϨ ⲀⲖⲖⲀ ⲞⲨⲈⲦ ⲠⲈⲞⲞⲨ ⲘⲈⲚ ⲚⲚⲈⲦϨⲚ ⲦⲠⲈ ⲞⲨⲈⲦ ⲠⲈⲞⲞⲨ ⲆⲈ ⲚⲚⲈⲦϨⲘ ⲠⲔⲀϨ. ");
INSERT INTO copshc_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ⲞⲨⲈⲦ ⲠⲈⲞⲞⲨ ⲘⲠⲢⲎ ⲞⲨⲈⲦ ⲠⲈⲞⲞⲨ ⲘⲠⲞⲞϨ ⲞⲨⲈⲦ ⲠⲈⲞⲞⲨ ⲚⲚⲤⲒⲞⲨ ⲞⲨⲚ ⲤⲒⲞⲨ ⲄⲀⲢ ϢⲞⲂⲈ ⲈⲤⲒⲞⲨ ϨⲘ ⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲔⲈⲦⲰⲞⲨⲚ ⲚⲚⲈⲦⲘⲞⲞⲨⲦ. ⲤⲈⲚⲀϪⲞϤ ϨⲚ ⲞⲨⲦⲀⲔⲞ ⲚϤⲦⲰⲞⲨⲚ ϨⲚ ⲞⲨⲘⲚⲦⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ⲤⲈⲚⲀϪⲞϤ ϨⲚ ⲞⲨⲤⲰϢ ⲚϤⲦⲰⲞⲨⲚ ϨⲚ ⲞⲨⲈⲞⲞⲨ. ⲤⲈⲚⲀϪⲞϤ ϨⲚ ⲞⲨⲘⲚⲦϬⲰⲂ ⲚϤⲦⲰⲞⲨⲚ ϨⲚ ⲞⲨϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ⲤⲈⲚⲀϪⲞϤ ⲚⲤⲰⲘⲀ ⲘⲮⲨⲬⲒⲔⲞⲚ ⲚϤⲦⲰⲞⲨⲚ ⲚⲤⲰⲘⲀ ⲘⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲈϢϪⲈ ⲞⲨⲚ ⲤⲰⲘⲀ ⲘⲮⲨⲬⲒⲔⲞⲚ ⲞⲨⲚ ⲤⲰⲘⲀ ⲞⲚ ⲘⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲈⲦⲤⲎϨ. ϪⲈ ⲀⲠϢⲞⲢⲠ ⲚⲢⲰⲘⲈ ⲀⲆⲀⲘ ϢⲰⲠⲈ ⲈⲨⲮⲨⲬⲎ ⲈⲤⲞⲚϨ. ⲠϨⲀⲈ ⲆⲈ ⲀⲆⲀⲘ ⲈⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲦⲀⲚϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ⲀⲖⲖⲀ ⲘⲠϢⲞⲢⲠ ⲀⲚ ⲠⲈ ⲠⲈⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ ⲀⲖⲖⲀ ⲠⲈⲮⲨⲬⲒⲔⲞⲚ. ⲘⲚⲚⲤⲰⲤ ⲠⲈⲠⲚⲈⲨⲘⲀⲦⲒⲔⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ⲠϢⲞⲢⲠ ⲚⲢⲰⲘⲈ ⲞⲨⲔⲀϨ ⲠⲈ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ. ⲠⲘⲈϨ ⲤⲚⲀⲨ ⲞⲨⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ⲚⲐⲈ ⲘⲠⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲚⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ. ⲀⲨⲰ ⲚⲐⲈ ⲘⲠⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲚⲚⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ⲀⲨⲰ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲚⲪⲞⲢⲒ ⲚⲐⲒⲔⲰⲚ ⲘⲠⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀϨ. ⲦⲚⲚⲀⲪⲞⲢⲒ ⲞⲚ ⲚⲐⲒⲔⲰⲚ ⲘⲠⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ⲠⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ⲚⲀⲤⲚⲎⲨ ϪⲈ ⲚⲚⲈϢ ⲤⲀⲢⲜ ϨⲒ ⲤⲚⲞϤ ⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲚⲦⲘⲚⲦⲢⲢⲞ ⲘⲠⲚⲞⲨⲦⲈ. ⲞⲨⲆⲈ ⲠⲦⲀⲔⲞ ⲚⲀⲔⲖⲎⲢⲞⲚⲞⲘⲒ ⲀⲚ ⲚⲦⲘⲚⲦⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ⲈⲒⲤ ϨⲎⲎⲦⲈ ϮϪⲰ ⲚⲎⲦⲚ ⲚⲞⲨⲘⲨⲤⲦⲎⲢⲒⲞⲚ. ϪⲈ ⲀⲚⲞⲚ ⲘⲈⲚ ⲦⲎⲢⲚ ⲦⲚⲚⲀⲚⲔⲦⲞⲔ ⲀⲚ. ⲀⲚⲞⲚ ⲆⲈ ⲦⲎⲢⲚ ⲦⲚⲚⲀϢⲒⲂⲈ ");
INSERT INTO copshc_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ϨⲚ ⲞⲨϢⲠⲚϢⲰⲠ ϨⲚ ⲞⲨⲢⲒⲔⲈ ⲚⲂⲀⲖ ϨⲚ ⲐⲀⲎ ⲚⲤⲀⲖⲠⲒⲄⲜ ϤⲚⲀⲤⲀⲖⲠⲒⲌⲈ ⲄⲀⲢ ⲚⲦⲈ ⲚⲈⲦⲘⲞⲞⲨⲦ ⲦⲰⲞⲨⲚ ⲈⲨⲞ ⲚⲀⲦⲦⲀⲔⲞ ⲀⲨⲰ ⲀⲚⲞⲚ ⲦⲚⲚⲀϢⲒⲂⲈ. ");
INSERT INTO copshc_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲈ ⲠⲀⲒ ⲈϢⲀϤⲦⲀⲔⲞ ϮϨⲒⲰⲰϤ ⲚⲞⲨⲘⲚⲦⲀⲦⲦⲀⲔⲞ. ⲀⲨⲰ ⲠⲀⲒ ⲈϢⲀϤⲘⲞⲨ ⲈⲦⲢⲈϤϮ ϨⲒⲰⲰϤ ⲚⲦⲘⲚⲦⲀⲦⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲢϢⲀⲚ ⲠⲀⲒ ⲈϢⲀϤⲘⲞⲨ ϮϨⲒⲰⲰϤ ⲚⲦⲘⲚⲦⲀⲦⲘⲞⲨ. ⲦⲞⲦⲈ ϤⲚⲀϢⲰⲠⲈ ⲚϬⲒ ⲠϢⲀϪⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀⲨⲈⲘⲔⲠⲘⲞⲨ ⲈⲨϪⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ⲠⲘⲞⲨ ⲈϤⲦⲰⲚ ⲦⲈⲔϪⲢⲞ. ⲠⲘⲞⲨ ⲈϤⲦⲰⲚ ⲠⲈⲔⲒⲈⲒⲂ. ");
INSERT INTO copshc_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ⲠⲒⲈⲒⲂ ⲆⲈ ⲘⲠⲘⲞⲨ ⲠⲈ ⲠⲚⲞⲂⲈ. ⲦϬⲞⲘ ⲆⲈ ⲘⲠⲚⲞⲂⲈ ⲠⲈ ⲠⲚⲞⲘⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ⲠⲈϨⲘⲞⲦ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ⲠⲀⲒ ⲈⲦϮ ⲚⲀⲚ ⲘⲠⲈϪⲢⲞ ϨⲒⲦⲚ ⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲨ ⲘⲘⲈⲢⲒⲦ ϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲦⲀϪⲢⲎⲨ ⲈⲚⲤⲈⲠⲰⲰⲚⲈ ⲘⲘⲰⲦⲚ ⲀⲚ ⲈⲦⲈⲦⲚⲞ ⲚϨⲞⲨⲞ ϨⲘ ⲠϨⲰⲂ ⲘⲠϪⲞⲈⲒⲤ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ϪⲈ ⲠⲈⲦⲚϨⲒⲤⲈ ϢⲞⲨⲈⲒⲦ ⲀⲚ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ⲈⲦⲂⲈ ⲠⲞⲨⲰϬⲤ ⲆⲈ ⲈⲦϪⲒ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲞⲨⲀⲀⲂ. ⲚⲐⲈ ⲈⲚⲦⲀⲒⲦⲞϢⲤ ϨⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲄⲀⲖⲀⲦⲒⲀ. ⲀⲢⲒⲤ ϨⲰⲦ ⲦⲎⲨⲦⲚ ");
INSERT INTO copshc_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ⲔⲀⲦⲀ ⲤⲞⲨⲀ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ⲘⲀⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲘⲘⲰⲦⲚ ⲔⲰ ⲚⲦⲞⲞⲦϤ ⲈϤⲤⲰⲞⲨϨ ⲈϨⲞⲨⲚ ⲘⲠⲈⲦϤⲚⲀϨⲈ ⲈⲢⲞϤ. ϪⲈⲔⲀⲀⲤ ⲀⲚ ⲈⲈⲒϢⲀⲚⲈⲒ ⲦⲞⲦⲈ ⲚⲦⲈ ⲞⲨⲰϬⲤ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ϨⲞⲦⲀⲚ ⲆⲈ ⲈⲈⲒϢⲀⲚⲈⲒ ⲚⲈⲦⲈⲦⲚⲀⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲘⲞⲞⲨ. ⲚⲀⲒ ⲈⲒⲈϪⲞⲞⲨⲤⲞⲨ ϨⲒⲦⲚ ⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲈϪⲒ ⲚⲦⲈⲦⲚⲬⲀⲢⲒⲤ ⲈⲐⲒⲈⲢⲞⲤⲞⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ⲈϢⲰⲠⲈ ⲆⲈ ⲠⲈⲦⲈϢϢⲈ ⲠⲈ ⲈⲦⲢⲀⲂⲰⲔ ϨⲰ ⲤⲈⲚⲎⲨ ⲚⲘⲘⲀⲒ. ");
INSERT INTO copshc_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ϮⲚⲎⲨ ⲆⲈ ϢⲀⲢⲰⲦⲚ ⲈⲈⲒϢⲀⲚⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ϮⲚⲎⲨ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ⲘⲈϢⲀⲔ ⲆⲈ ϮⲚⲀϬⲰ ϨⲀⲦⲈ ⲦⲎⲨⲦⲚ. ⲎⲚⲦⲀⲢⲦⲈⲠⲢⲰ. ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈⲐⲠⲞⲒ ⲈⲠⲘⲀ ⲈϮⲚⲀⲂⲰⲔ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ⲚϮⲞⲨⲰϢ ⲄⲀⲢ ⲀⲚ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲚ ⲦⲈⲚⲞⲨ ⲈⲈⲒⲠⲀⲢⲀⲄⲈ. ϮⲘⲈⲈⲨⲈ ⲄⲀⲢ ⲈⲢⲞⲨⲞⲈⲒϢ ϨⲀⲦⲚ ⲦⲎⲨⲦⲚ ⲈⲢϢⲀⲚ ⲠϪⲞⲈⲒⲤ ⲞⲨⲈϨⲤⲀϨⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ϮϬⲈⲈⲦ ⲆⲈ ϨⲚ ⲈⲪⲈⲤⲞⲤ ϢⲀ ⲦⲠⲈⲚⲦⲎⲔⲞⲤⲦⲎ. ");
INSERT INTO copshc_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ⲀⲨⲚⲞϬ ⲄⲀⲢ ⲚⲢⲞ ⲞⲨⲰⲚ ⲚⲀⲒ. ⲈϤⲈⲚⲈⲢⲄⲈⲒ. ⲀⲨⲰ ϨⲀϨ ⲚⲀⲚⲦⲒⲔⲒⲘⲈⲚⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ⲈⲢϢⲀⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲆⲈ ⲈⲒ ϮϨⲦⲎⲦⲚ ϪⲈ ⲈϤⲈϢⲰⲠⲈ ⲀϪⲚ ϨⲞⲦⲈ ϨⲀⲦⲚ ⲦⲎⲨⲦⲚ. ⲠϨⲰⲂ ⲄⲀⲢ ⲘⲠϪⲞⲈⲒⲤ ⲠⲈⲦϤⲢϨⲰⲂ ⲈⲢⲞϤ ⲚⲦⲀϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ⲘⲠⲢⲦⲢⲈ ⲖⲀⲀⲨ ϬⲈ ⲤⲞϢϤ. ⲘⲀⲐⲠⲞϤ ⲆⲈ ϨⲚ ⲞⲨⲈⲒⲢⲎⲚⲎ ϪⲈ ⲈϤⲈⲈⲒ ϢⲀⲢⲞⲒ. ϮϬⲰϢⲦ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲎⲦϤ ⲘⲚ ⲚⲈⲤⲚⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ⲈⲦⲂⲈ ⲀⲠⲞⲖⲖⲰ ⲆⲈ ⲠⲤⲞⲚ ⲀⲒⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞϤ ⲈⲘⲀⲦⲈ ϪⲈ ⲈϤⲈⲈⲒ ϢⲀⲢⲰⲦⲚ. ⲀⲨⲰ ⲘⲈϢⲀⲔ ⲘⲠⲦⲰϢ ⲀⲚ ⲠⲈ ⲈⲦⲢⲈϤⲈⲒ ⲦⲈⲚⲞⲨ. ϤⲚⲎⲨ ⲆⲈ ⲈϤϢⲀⲚϨⲈ ⲈⲠⲞⲨⲞⲈⲒϢ. ");
INSERT INTO copshc_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ⲢⲞⲈⲒⲤ ⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ϪⲢⲞ ⲚⲦⲈⲦⲚ ϬⲘϬⲞⲘ. ");
INSERT INTO copshc_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ⲚⲈⲦⲚϨⲂⲎⲨⲈ ⲦⲎⲢⲞⲨ ⲘⲀⲢⲞⲨϢⲰⲠⲈ ϨⲚ ⲞⲨⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲀⲤⲚⲎⲨ ⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲠⲎⲈⲒ ⲚⲤⲦⲈⲪⲀⲚⲀ ϪⲈ ⲠϢⲞⲢⲠ ⲠⲈ ϨⲚ ⲦⲀⲬⲀⲒⲀ. ⲀⲨⲰ ⲀⲨⲔⲀⲀⲨ ⲈϨⲢⲀⲒ ⲈⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ϪⲈⲔⲀⲀⲤ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚⲈϨⲨⲠⲞⲦⲀⲤⲤⲈ ⲚⲚⲀⲒ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ. ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ ⲈⲦⲞ ⲚϢⲂⲢⲢϨⲰⲂ. ⲀⲨⲰ ⲈⲦϨⲞⲤⲈ. ");
INSERT INTO copshc_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ϮⲢⲀϢⲈ ⲆⲈ ⲈϪⲚ ⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲚⲤⲦⲈⲪⲀⲚⲀ ⲘⲚ ⲪⲞⲢⲦⲞⲨⲚⲀⲦⲞⲤ ⲘⲚ ⲀⲬⲀⲒⲔⲞⲤ ϪⲈ ⲚⲀⲒ ⲚⲈⲚⲦⲀⲨϪⲈⲔ ⲠⲈⲦⲚϢⲰⲰⲦ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ⲀⲨϮ ⲘⲦⲞⲚ ⲄⲀⲢ ⲘⲠⲀⲠⲚⲈⲨⲘⲀ. Ⲙ ⲚⲠⲰⲦⲚ. ⲤⲞⲨⲚⲚⲀⲒ ϬⲈ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ⲤⲈϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲀⲤⲒⲀ. ⲤⲈϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲈⲘⲀⲦⲈ ϨⲘ ⲠϪⲞⲈⲒⲤ ⲚϬⲒ ⲀⲔⲨⲖⲀ ⲘⲚ ⲠⲢⲒⲤⲔⲀ ⲘⲚ ⲦⲤⲞⲞⲨϨⲤ ⲈⲦϨⲘ ⲠⲈⲨⲎⲈⲒ. ");
INSERT INTO copshc_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ⲤⲈϢⲒⲚⲈ ⲈⲢⲰⲦⲚ ⲚϬⲒ ⲚⲈⲤⲚⲎⲨ ⲦⲎⲢⲞⲨ. ⲀⲤⲠⲀⲌⲈ ⲚⲚⲈⲦⲚⲈⲢⲎⲨ ϨⲚ ⲞⲨⲠⲒ ⲈⲤⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ⲠⲀⲤⲠⲀⲤⲘⲞⲤ ⲈⲚⲦⲀⲒⲤϨⲀⲈⲒϤ ⲚⲦⲀϬⲒϪ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ⲠⲈⲦⲈⲚϤⲘⲈ ⲀⲚ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲘⲀⲢⲈϤϢⲰⲠⲈ ⲚⲀⲚⲀⲐⲈⲘⲀ ⲘⲀⲢⲀⲚⲀⲐⲀ. ");
INSERT INTO copshc_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ⲦⲀⲀⲄⲀⲠⲎ ⲚⲘⲘⲎⲦⲚ ⲦⲎⲢⲦⲚ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ");
INSERT INTO copshc_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ϨⲒⲦⲘ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲠⲤⲞⲚ ⲈⲨⲤϨⲀⲒ ⲚⲦⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲠⲚⲞⲨⲦⲈ. ⲦⲀⲒ ⲈⲦϢⲞⲞⲠ ϨⲚ ⲔⲞⲢⲒⲚⲐⲞⲤ. ⲘⲚ ⲚⲈⲦⲞⲨⲀⲀⲂ ⲦⲎⲢⲞⲨ ⲈⲦϢⲞⲞⲠ ϨⲚ ⲦⲀⲬⲀⲒⲀ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ⲦⲈⲬⲀⲢⲒⲤ ⲚⲎⲦⲚ ⲘⲚ ϮⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲈⲒⲰⲦ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ϤⲤⲘⲀⲘⲀⲀⲦ ⲚϬⲒ ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲠⲈⲒⲰⲦ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲈⲒⲰⲦ ⲚⲘⲘⲚⲦϢⲀⲚϨⲦⲎϤ ⲀⲨⲰ ⲠⲚⲞⲨⲦⲈ ⲚⲤⲞⲠⲤ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ⲠⲈⲦⲤⲞⲠⲤ ⲘⲘⲞⲚ ϨⲚ ⲚⲈⲚⲐⲖⲒⲮⲒⲤ ⲦⲎⲢⲞⲨ. ϪⲈ ⲈⲚⲈϢϬⲘϬⲞⲘ ϨⲰⲰⲚ ⲈⲤⲈⲠⲤ ⲚⲈⲦϨⲚ ⲐⲖⲒⲮⲒⲤ ⲚⲒⲘ. ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲤⲞⲠⲤ ⲈⲦⲞⲨⲤⲞⲠⲤ ⲘⲘⲞⲚ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ϪⲈ ⲚⲐⲈ ⲈⲦⲈⲢⲈ ⲘⲘⲞⲔϨⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲞϢ ⲈϨⲞⲨⲚ ⲈⲢⲞⲚ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ϨⲒⲦⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϤⲢϨⲞⲨⲞ ⲚϬⲒ ⲠⲈⲚⲔⲈⲤⲞⲠⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ⲈⲒⲦⲈ ⲆⲈ ⲤⲈⲐⲖⲒⲂⲈ ⲘⲘⲞⲚ ⲈⲨⲐⲖⲒⲂⲈ ⲘⲘⲞⲚ ϨⲀ ⲠⲈⲦⲚⲤⲞⲠⲤ ⲘⲚ ⲠⲈⲦⲚⲞⲨϪⲀⲒ ⲈⲒⲦⲈ ⲤⲈⲤⲞⲠⲤ ⲘⲘⲞⲚ ⲈⲨⲤⲞⲠⲤ ⲘⲘⲞⲚ ϨⲀ ⲠⲈⲦⲚⲤⲞⲠⲤ ⲠⲀⲒ ⲈⲦⲈⲚⲈⲢⲄⲒ ϨⲚ ⲐⲨⲠⲞⲘⲞⲚⲎ ⲚⲚⲒϨⲒⲤⲈ ⲚⲞⲨⲰⲦ ⲚⲀⲒ ϨⲰⲰⲚ ⲈⲦⲚϢⲰⲠ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲦⲈⲚϨⲈⲖⲠⲒⲤ ⲦⲀϪⲢⲎⲨ ϨⲀⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ⲈⲚⲤⲞⲞⲨⲚ ⲆⲈ ⲚⲐⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲔⲞⲒⲚⲰⲚⲞⲤ ⲈⲚⲈⲘⲔⲞⲞϨ. ⲦⲀⲒ ⲞⲚ ⲦⲈ ⲐⲈ ⲘⲠⲔⲈⲤⲞⲠⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ⲚⲦⲚⲞⲨⲰϢ ⲄⲀⲢ ⲀⲚ ⲈⲦⲢⲈⲦⲚⲢⲀⲦⲤⲞⲞⲨⲚ ⲚⲈⲤⲚⲎⲨ ⲚⲦⲈⲚⲐⲖⲒⲮⲒⲤ ⲦⲀⲒ ⲈⲚⲦⲀⲤϢⲰⲠⲈ ⲘⲘⲞⲚ ϨⲚ ⲦⲀⲤⲒⲀ. ϪⲈ ⲀⲨⲂⲀⲢⲒ ⲘⲘⲞⲚ ⲚϨⲞⲨⲞ ⲠⲀⲢⲀⲦⲈⲚϬⲞⲘ. ϨⲰⲤⲦⲈ ⲈⲦⲢ ⲈⲚⲞⲨⲈ ⲈⲠⲔⲈⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ⲀⲖⲖⲀ ⲀⲚⲞⲚ ϨⲢⲀⲒ ⲚϨⲎⲦⲚ ⲀⲚⲔⲀ ⲠⲘⲞⲨ ϨⲀ ⲈⲒⲀⲦⲚ. ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲚϢⲰⲠⲈ ⲈⲢⲈϨⲦⲎⲚ ⲔⲎ ⲈⲢⲞⲚ. ⲀⲖⲖⲀ ⲈⲠⲚⲞⲨⲦⲈ ⲠⲀⲒ ⲈⲦⲦⲞⲨⲚⲞⲤ ⲚⲚⲢⲈϤⲘⲞⲞⲨⲦ ");
INSERT INTO copshc_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ⲠⲀⲒ ⲈⲚⲦⲀϤⲦⲞⲨϪⲞⲚ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲒⲘⲞⲨ ⲚⲦⲈⲈⲒϬⲞⲦ. ⲀⲨⲰ ⲞⲚ ϤⲚⲀⲦⲞⲨϪⲞⲚ. ⲠⲀⲒ ⲈⲚⲦⲀⲚⲚⲀϨⲦⲈ ⲈⲢⲞϤ ϪⲈ ⲈⲦⲈⲒ ⲞⲚ ϤⲚⲀⲦⲞⲨϪⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ⲈⲦⲈⲦⲚⲞ ⲚϢⲂⲢⲢϨⲰⲂ ϨⲀⲢⲞⲚ ϨⲘ ⲠⲤⲞⲠⲤ ϪⲈⲔⲀⲀⲤ ϨⲘ ⲠϨⲞ ⲚϨⲀϨ. ⲠⲈϨⲘⲞⲦ ⲈⲚⲦⲀϤⲠⲰϨ ϢⲀⲢⲞⲚ. ⲈⲨⲈϢⲠϨⲘⲞⲦ ϨⲀⲢⲞϤ ϨⲒⲦⲚ ϨⲀϨ ϨⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ⲠⲈⲚϢⲞⲨϢⲞⲨ ⲄⲀⲢ ⲠⲀⲒ ⲠⲈ ⲦⲘⲚⲦⲘⲚⲦⲢⲈ ⲚⲦⲈⲚⲤⲨⲚⲒⲆⲎⲤⲒⲤ ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲞⲨⲞⲨⲞⲠ ⲘⲚ ⲞⲨⲦⲂⲂⲞ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨⲤⲞⲪⲒⲀ ⲀⲚ ⲚⲤⲀⲢⲔⲒⲔⲞⲚ ⲀⲖⲖⲀ ϨⲚ ⲞⲨⲬⲀⲢⲒⲤ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ⲀⲚⲘⲞⲞϢⲈ ϨⲘ ⲠⲔⲞⲤⲘⲞⲤ ⲚϨⲞⲨⲞ ⲆⲈ ϨⲀⲦⲈⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲄⲀⲢ ⲀⲚ ⲚⲈϮⲤϨⲀⲒ ⲘⲘⲞⲞⲨ ⲚⲎⲦⲚ ⲀⲖⲖⲀ ⲚⲈⲦⲈⲦⲚⲰϢ ⲘⲘⲞⲞⲨ ⲚⲈ ⲀⲨⲰ ⲚⲈⲦⲈⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞⲞⲨ ϮϨⲈⲖⲠⲒⲌⲈ ⲆⲈ ϪⲈ ⲦⲈⲦⲚⲀⲤⲞⲞⲨⲚ ϢⲀⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ⲔⲀⲦⲀ ⲐⲈ ⲞⲚ ⲈⲚⲦⲀⲦⲈⲦⲚⲤⲞⲨⲰⲚⲚ ⲀⲠⲞ ⲘⲈⲢⲞⲨⲤ. ϪⲈ ⲀⲚⲞⲚ ⲠⲈⲦⲚϢⲞⲨϢⲞⲨ. ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲈⲦⲚⲠⲰⲚ ϨⲘ ⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ⲀⲨⲰ ϨⲘ ⲠⲈⲈⲒⲚⲀϨⲦⲈ. ⲚⲈⲒⲞⲨⲰϢ ⲚϢⲞⲢⲠ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ. ϪⲈ ⲈⲦⲈⲦⲚⲈϪⲒ ⲘⲠⲘⲈϨ ⲤⲚⲀⲨ ⲚϨⲘⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ⲀⲨⲰ ⲈⲂⲰⲔ ⲈⲂⲞⲖ ϨⲒⲦⲈⲦⲎⲨⲦⲚ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲈⲈⲒ ϢⲀⲢⲰⲦⲚ ⲚⲤⲈⲐⲠⲞⲒ ϨⲒⲦⲈⲦⲎⲨⲦⲚ ⲈϮⲞⲨⲆⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ⲠⲀⲒ ϬⲈ ⲈⲀⲒⲞⲨⲀϢϤ ⲘⲎⲦⲒ ⲀⲒⲬⲢⲰ ϨⲚ ⲞⲨⲀⲤⲀⲒ ⲎⲚⲈϮⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ ⲘⲎ ⲈⲈⲒⲘⲈⲈⲨⲈ ⲈⲢⲞⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ϪⲈⲔⲀⲀⲤ ⲈϤⲈϢⲰⲠⲈ ⲚⲦⲞⲞⲦ ⲚϬⲒ ⲠⲤⲈ ⲚⲤⲈ ⲀⲨⲰ ⲠⲘⲘⲞⲚ ⲚⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ⲞⲨⲠⲒⲤⲦⲞⲤ ⲆⲈ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ϪⲈ ⲠⲈⲚϢⲀϪⲈ ⲈⲚⲦⲀϤⲠⲰϨ ϢⲀⲢⲰⲦⲚ ⲚⲞⲨⲤⲈ ⲀⲚ ⲠⲈ. ⲘⲚ ⲞⲨⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ⲠϢⲎⲢⲈ ⲄⲀⲢ ⲘⲠⲚⲞⲨⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚⲦⲀⲨⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ ⲚϨⲎⲦⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ ⲘⲚ ⲤⲒⲖⲞⲨⲀⲚⲞⲤ ⲘⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲘⲠϤϢⲰⲠⲈ ⲚⲤⲈ ⲀⲨⲰ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲤⲈ ⲠⲈⲚⲦⲀϤϢⲰⲠⲈ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ⲚⲈⲢⲎⲦ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲤⲈ ⲠⲈⲦϢⲰⲠⲈ ⲚϨⲎⲦϤ. ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦϤ ⲠⲈ ⲠϨⲀⲘⲎⲚ ⲈⲠϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ⲠⲈⲦⲦⲀϪⲢⲞ ⲆⲈ ⲘⲘⲞⲚ ⲚⲘⲘⲎⲦⲚ ⲈϨⲞⲨⲚ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲠⲈⲚⲦⲀϤⲦⲀϨⲤⲚ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ⲠⲀⲒ ⲈⲚⲦⲀϤⲤⲪⲢⲀⲄⲒⲌⲈ ⲘⲘⲞⲚ. ⲀⲨⲰ ⲈⲚⲦⲀϤϮ ⲚⲀⲚ ⲘⲠⲀⲢⲎⲂ ⲘⲠⲈ ⲠⲚⲈⲨⲘⲀ ϨⲢⲀⲒ ϨⲚ ⲚⲈⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ⲀⲚⲞⲔ ⲆⲈ ϮⲈⲠⲒⲔⲀⲖⲈⲒ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲘⲚⲦⲢⲈ ⲈϪⲚ ⲦⲀⲮⲨⲬⲎ ϪⲈ ⲈⲒϮⲤⲞ ⲈⲢⲰⲦⲚ ⲘⲠⲒⲈⲒ ϬⲈ ⲈⲔⲞⲢⲒⲚⲐⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ⲞⲨⲬ ⲞⲦⲈⲒ ϪⲈ ⲈⲚⲞ ⲚϪⲞⲈⲒⲤ ⲈⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ. ⲀⲖⲖⲀ ⲀⲚⲞⲚ ⲚⲈ ⲚⲈϢⲂⲢⲢϨⲰⲂ ⲘⲠⲈⲦⲚⲢⲀϢⲈ. ⲈⲦⲈⲦⲚⲀϨⲈⲢⲀⲦ ⲦⲎⲨⲦⲚ ⲄⲀⲢ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ⲀⲒⲔⲢⲒⲚⲈ ⲄⲀⲢ ⲘⲠⲀⲒ ⲚⲀⲒ ⲈⲦⲘⲈⲒ ⲞⲚ ϢⲀⲢⲰⲦⲚ ϨⲚ ⲞⲨⲖⲨⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ⲈϢϪⲈ ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲈⲦⲚⲀⲖⲨⲠⲈⲒ ⲘⲘⲰⲦⲚ. ⲈⲒⲈ ⲚⲒⲘ ⲠⲈⲦⲚⲀⲈⲨⲪⲢⲀⲚⲈ ⲘⲘⲞⲒ ⲈⲒ ⲘⲎⲦⲒ ⲠⲈⲦⲚⲀⲖⲨⲠⲈⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ⲔⲀⲒⲄⲀⲢ ⲈⲚⲦⲀⲒⲤⲈϨ ⲠⲀⲒ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲀⲈⲒ ⲦⲀⲖⲨⲠⲈⲒ ⲚⲦⲞⲞⲦⲞⲨ ⲚⲚⲈⲦⲈϢϢⲈ ⲈⲦⲢⲀⲢⲀϢⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲞⲨ. ⲈⲒⲔⲰ ⲚϨⲦⲎⲒ ⲈⲢⲰⲦⲚ ⲦⲎⲢⲦⲚ ϪⲈ ⲠⲀⲢⲀϢⲈ ⲠⲰⲦⲚ ⲦⲎⲢⲦⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ⲈⲂⲞⲖ ⲄⲀⲢ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲐⲖⲒⲮⲒⲤ. ⲘⲚ ⲞⲨⲖⲰϪϨ ⲚϨⲎⲦ ⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ϨⲒⲦⲚ ϨⲀϨ ⲚⲢⲘⲈⲒⲎ ϪⲈⲔⲀⲀⲤ ⲀⲚ ⲈⲦⲈⲦⲚⲈⲖⲨⲠⲈⲒ. ⲀⲖⲖⲀ ϪⲈ ⲈⲦⲈⲦⲚⲈⲈⲒⲘⲈ ⲈⲦⲀⲄⲀⲠⲎ ⲈⲦⲈⲨⲚⲦⲀⲈⲒⲤ ⲚϨⲞⲨⲞ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ⲈϢϪⲈ ⲀⲞⲨⲀ ⲆⲈ ⲖⲨⲠⲈⲒ ⲚⲦⲀϤⲖⲨⲠⲈⲒ ⲘⲘⲞⲒ ⲀⲚ. ⲀⲖⲖⲀ ⲀⲠⲞ ⲘⲈⲢⲞⲨⲤ. ϪⲈ ⲈⲚⲚⲀⲈⲠⲒⲂⲀⲢⲈⲒ ⲘⲘⲰⲦⲚ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ⲦⲈⲒⲈⲠⲒⲦⲒⲘⲒⲀ ϬⲈ ⲢⲰϢⲈ ⲈⲠⲀⲒ ⲦⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϨⲞⲨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ϨⲰⲤⲦⲈ ⲚⲦⲞϤ ⲚⲦⲈⲦⲚⲔⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ⲀⲨⲰ ⲚⲦⲈⲦⲚ ⲤⲈⲠⲤⲰⲠϤ. ⲘⲎⲠⲞⲦⲈ ϨⲢⲀⲒ ϨⲘ ⲠϨⲞⲨⲈ ⲖⲨⲠⲈⲒ ⲚⲤⲈⲰⲘⲔ ⲘⲠⲀⲒ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ⲈⲦⲂⲈ ⲠⲀⲒ ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲰⲦⲚ ⲘⲀⲦⲀϪⲢⲞ ⲚⲞⲨⲀⲄⲀⲠⲎ ⲈϨⲞⲨⲚ ⲈⲢⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ⲈⲦⲂⲈ ⲠⲀⲒ ⲄⲀⲢ ⲚⲦⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ϪⲈ ⲈⲒⲈⲈⲒⲘⲈ ⲈⲦⲈⲦⲚⲆⲞⲔⲒⲘⲎ ϪⲈ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲦⲘⲎⲦ ϨⲚ ϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ⲠⲈⲦⲈⲦⲚⲀⲔⲰ ⲆⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϮⲔⲰ ϨⲰ. ⲔⲀⲒⲄⲀⲢ ⲀⲚⲞⲔ ⲚⲦⲀⲒⲔⲰ ⲈⲂⲞⲖ ⲘⲠⲈⲚⲦⲀⲒ ⲔⲀⲀϤ ⲈⲂⲞⲖ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ϨⲘ ⲠϨⲞ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲨϨⲞⲨⲢⲰⲰⲚ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲤⲀⲦⲀⲚⲀⲤ. ⲚⲦⲚⲞⲂϢ ⲄⲀⲢ ⲀⲚ ⲈⲚⲈϤⲘⲈⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ⲚⲦⲈⲢⲒⲈⲒ ⲆⲈ ⲈϨⲢⲀⲒ ⲈⲦⲈⲦⲢⲰⲀⲤ ⲈⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲚⲦⲈⲢⲈ ⲞⲨⲚⲞϬ ⲚⲢⲞ ⲞⲨⲞⲚ ⲚⲀⲒ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ⲘⲠⲒⲘⲦⲞⲚ ϨⲘ ⲠⲀⲠⲚⲈⲨⲘⲀ ϪⲈ ⲘⲠⲒϨⲈ ⲈⲦⲒⲦⲞⲤ ⲠⲀⲤⲞⲚ. ⲀⲖⲖⲀ ⲚⲦⲈⲢⲒ ⲀⲠⲞⲦⲀⲤⲤⲈ ⲚⲀⲨ ⲀⲒⲈⲒ ⲈⲂⲞⲖ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ⲠⲈϨⲘⲞⲦ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ⲠⲀⲒ ⲈⲦϪⲀⲒⲞ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲈⲦⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲤⲦⲞⲒ ⲘⲠⲈϤⲤⲞⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲚ ϨⲘ ⲘⲀ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲤϮⲚⲞⲨϤⲈ ⲚⲦⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲠⲚⲞⲨⲦⲈ ϨⲚ ⲚⲈⲦⲚⲀⲞⲨϪⲀⲒ ⲘⲚ ⲚⲈⲦⲚⲀⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ⲚϨⲞⲒⲚⲈ ⲘⲈⲚ ⲚⲤⲦⲞⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲘⲞⲨ ⲈⲠⲘⲞⲨ. ⲚϨⲞⲒⲚⲈ ⲆⲈ ⲚⲤⲦⲞⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲰⲚϨ ⲈⲠⲰⲚϨ. ⲀⲨⲰ ⲚⲚⲀϨⲢⲚ ⲚⲀⲒ ⲚⲒⲘ ⲠⲈⲦⲘⲠϢⲀ. ");
INSERT INTO copshc_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ⲚⲚⲈⲚⲞ ⲄⲀⲢ ⲀⲚ ⲚⲐⲈ ⲚϨⲀϨ ⲈⲦⲞ ⲚⲈϢⲰⲦ ϨⲘ ⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ. ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲦⲂⲂⲞ. ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲚϢⲀϪⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ⲀⲚⲀⲢⲬⲒ ⲞⲚ ⲚⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞⲚ ⲘⲎⲦⲒ ⲦⲚⲢⲬⲢⲒⲀ ⲚϨⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲈⲨⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞⲚ ⲚⲎⲦⲚ ⲚⲐⲈ ⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲎⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲎⲨⲦⲚ ⲚⲚⲀϨⲢⲚ ϨⲈⲚⲔⲞⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ⲦⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲰⲦⲚ ⲠⲈ ⲈⲤⲤⲎϨ ϨⲚ ⲚⲈⲚϨⲎⲦ ⲈⲨⲈⲒⲘⲈ ⲈⲢⲞⲤ ⲀⲨⲰ ⲈⲨⲰϢ ⲘⲘⲞⲤ ϨⲒⲦⲚ ⲢⲰⲘⲈ ⲚⲒⲘ ");
INSERT INTO copshc_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ⲈⲦⲈⲦⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϪⲈ ⲚⲦⲈⲦⲚⲦⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲀⲨⲆⲒⲀⲔⲞⲚⲒ ⲘⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲚ ⲈⲤⲤⲎϨ ⲘⲘⲈⲖⲀ ⲀⲚ ⲀⲖⲖⲀ ϨⲘ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ ϨⲚ ϨⲈⲚⲠⲖⲀⲜ ⲀⲚ ⲚⲰⲚⲈ ⲀⲖⲖⲀ ϨⲚ ϨⲈⲚⲠⲖⲀⲜ ⲚϨⲎⲦ ⲚⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ⲞⲨⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲚⲀϨⲦⲈ ⲚⲦⲈⲒⲘⲒⲚⲈ ⲈⲠⲚⲞⲨⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦϤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ϪⲈ ⲈⲚⲞ ⲀⲚ ⲚϨⲒⲔⲀⲚⲞⲤ ⲘⲘⲒⲚ ⲘⲘⲞⲚ ⲈⲦⲢⲈⲚⲘⲈⲈⲨⲈ ⲈⲨϨⲰⲂ ϨⲀⲠⲈⲚϨⲦⲞⲢ. ⲀⲖⲖⲀ ⲦⲈⲚⲘⲚⲦϨⲒⲔⲀⲚⲞⲤ ⲈⲤϢⲞⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ⲠⲀⲒ ⲈⲚⲦⲀϤⲦⲢⲈⲚⲢⲠϢⲀ ⲚⲢⲆⲒⲀⲔⲞⲚⲞⲤ ⲚⲦⲆⲒⲀⲐⲎⲔⲎ ⲚⲂⲢⲢⲈ ⲚⲦⲈⲠⲈⲤϨⲀⲒ ⲀⲚ. ⲀⲖⲖⲀ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ⲠⲈⲤϨⲀⲒ ⲄⲀⲢ ⲘⲞⲨⲞⲨⲦ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲆⲈ ⲦⲀⲚϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ⲈϢϪⲈ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲆⲈ ⲘⲠⲘⲞⲨ ⲈⲤϢⲈⲦϢⲰⲦ ϨⲚ ϨⲈⲚⲤϨⲀⲒ ϨⲚ ϨⲈⲚⲰⲚⲈ ⲀⲤϢⲰⲠⲈ ϨⲚ ⲞⲨⲈⲞⲞⲨ. ϨⲰⲤⲦⲈ ⲚⲤⲈⲦⲘϬⲘϬⲞⲘ ⲚϬⲒ ⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲈϬⲰϢⲦ ⲈϨⲞⲨⲚ ⲈⲠϨⲞ ⲘⲘⲰⲨⲤⲎⲤ ⲈⲦⲂⲈ ⲠⲈⲞⲞⲨ ⲘⲠⲈϤϨⲞ ⲠⲀⲒ ⲈⲦⲚⲀⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ⲚⲀϢ ⲚϨⲈ ⲚϨⲞⲨⲞ ⲈⲚⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲀⲚ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲀϢⲰⲠⲈ ϨⲚ ⲞⲨⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ⲈϢϪⲈ ⲀⲨⲈⲞⲞⲨ ⲄⲀⲢ ϢⲰⲠⲈ ⲚⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲘⲠⲦϬⲀⲈⲒⲞ. ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲤⲚⲀⲢϨⲞⲨⲞ ⲚϬⲒ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϨⲘ ⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ⲔⲀⲒⲄⲀⲢ ⲘⲠⲞⲨϮⲈⲞⲞⲨ ⲘⲠⲈⲦⲦⲀⲒⲎⲨ ϨⲘ ⲠⲈⲈⲒⲘⲈⲢⲞⲤ ⲈⲦⲂⲈ ⲠⲈϨⲞⲨⲞ ⲘⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ⲈϢϪⲈ ⲀⲠⲈⲦⲚⲀⲞⲨⲰⲤϤ ⲄⲀⲢ ϢⲰⲠⲈ ϨⲒⲦⲚ ⲞⲨⲈⲞⲞⲨ. ⲚϨⲞⲨⲞ ϬⲈ ⲠⲈⲦⲚⲀϬⲰ ϤⲚⲀϢⲰⲠⲈ ϨⲘ ⲠⲈⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ⲈⲨⲚⲦⲀⲚ ϬⲈ ⲘⲘⲀⲨ ⲚⲦⲈⲈⲒϨⲈⲖⲠⲒⲤ ⲚⲦⲈⲒⲘⲒⲚⲈ. ⲦⲚⲬⲢⲰ ϨⲚ ⲞⲨⲚⲞϬ ⲘⲠⲀⲢϨⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ⲈⲚⲔⲀⲦⲀ ⲐⲈ ⲀⲚ ⲘⲘⲰⲨⲤⲎⲤ ⲈϢⲀϤⲔⲰ ⲚⲞⲨⲔⲀⲖⲨⲘⲀ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲈϤϨⲞ ϪⲈ ⲚⲚⲈⲨϬⲰϢⲦ ⲚϬⲒ ⲚϢⲎⲢⲈ ⲘⲠⲒⲤⲢⲀⲎⲖ ⲈⲐⲀⲎ ⲘⲠⲈⲦⲚⲀⲞⲨⲰⲤϤ. ");
INSERT INTO copshc_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ⲀⲖⲖⲀ ⲀⲨⲦⲰⲘ ⲚϬⲒ ⲚⲈⲨⲘⲈⲈⲨⲈ ⲚϨⲎⲦ ϢⲀ ϨⲢⲀⲒ ⲄⲀⲢ ⲈⲠⲞⲞⲨ ⲚϨⲞⲞⲨ ⲠⲒϨⲂⲤ ⲚⲞⲨⲰⲦ ϢⲞⲞⲠ ⲈϨⲢⲀⲒ ⲈϪⲘ ⲠⲰϢ ⲚⲦⲆⲒⲀⲐⲎⲔⲎ ⲚⲀⲤ. ⲈⲚⲤⲈϬⲰⲖⲠ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲀⲚ ϪⲈ ⲈϤⲚⲀⲞⲨⲰⲤϤ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ⲀⲖⲖⲀ ϢⲀ ⲠⲞⲞⲨ ⲈⲨⲚⲀⲰϢ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲚ ⲞⲨⲔⲀⲖⲨⲘⲀ ⲔⲎ ⲈϨⲢⲀⲒ ⲈϪⲘⲠⲈⲨϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ⲈϤⲈⲒ ⲆⲈ ⲈϤⲚⲀⲔⲞⲦϤ ⲈⲠϪⲞⲈⲒⲤ ϢⲀϤϤⲒ ⲘⲠⲔⲀⲖⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ⲠϪⲞⲈⲒⲤ ⲆⲈ ⲠⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲠⲘⲀ ⲆⲈ ⲈⲦⲈⲢⲈ ⲠⲈⲠⲚⲈⲨⲘⲀ ⲘⲠϪⲞⲈⲒⲤ ⲚϨⲎⲦϤ ⲈⲤⲘⲘⲀⲨ ⲚϬⲒ ⲦⲘⲚⲦⲢⲘϨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ⲀⲚⲞⲚ ⲆⲈ ⲦⲎⲢⲚ ϨⲚ ⲞⲨϨⲞ ⲈϤϬⲞⲖⲠ ⲈⲂⲞⲖ. ⲈⲚⲈⲒⲰⲢϨ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲚ ⲞⲨⲈⲒⲀⲖ ⲦⲚϪⲒϨⲢⲂ ⲚϮϨⲒⲔⲰⲚ ⲚⲞⲨⲰⲦ ⲈⲂⲞⲖ ϨⲚ ⲞⲨⲈⲞⲞⲨ ⲈⲨⲈⲞⲞⲨ ⲔⲀⲦⲀ ⲐⲈ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠϪⲞⲈⲒⲤ ⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ⲈⲦⲂⲈ ⲠⲀⲒ ⲈⲨⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲚⲦⲈⲈⲒⲆⲒⲀⲔⲞⲚⲒⲀ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀⲨⲚⲀ ⲚⲀⲚ ⲚⲦⲚⲈⲄⲔⲀϬⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ⲀⲖⲖⲀ ⲀⲚⲔⲰ ⲚⲤⲰⲚ ⲚⲚⲈⲐⲎⲠ ⲘⲠϢⲒⲠⲈ ⲚⲦⲚⲘⲞⲞϢⲈ ⲀⲚ ϨⲚ ⲞⲨⲠⲀⲚⲞⲨⲢⲄⲒⲀ ⲞⲨⲆⲈ ⲚⲚⲈⲚⲢⲔⲢⲞϤ ⲀⲚ ⲘⲠϢⲀϪⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲀⲖⲖⲀ ϨⲘ ⲠⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲘⲈ ⲈⲚⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞⲚ ⲚⲚⲀϨⲢⲚ ⲤⲨⲚⲒⲆⲎⲤⲒⲤ ⲚⲒⲘ ⲚⲢⲰⲘⲈ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ⲈϢϪⲈ ⲠⲈⲚⲔⲈⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϨⲞⲂⲤ. ⲈϤϨⲞⲂⲤ ⲚⲚⲈⲦⲚⲀⲦⲀⲔⲞ. ");
INSERT INTO copshc_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ϨⲚ ⲚⲀⲒ ⲠⲚⲞⲨⲦⲈ ⲀϤⲦⲰⲘ ⲚⲚϨⲎⲦ ⲚⲚⲀⲠⲒⲤⲦⲞⲤ ⲘⲠⲈⲈⲒⲀⲒⲰⲚ ϪⲈ ⲚⲚⲈⲨⲚⲀⲨ ⲈⲠⲞⲨⲞⲈⲒⲚ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲈ ⲠⲀⲒ ⲠⲈ ⲐⲒⲔⲰⲚ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ⲚⲚⲈⲚⲦⲀϢⲈⲞⲈⲒϢ ⲄⲀⲢ ⲘⲘⲞⲚ ⲀⲚ. ⲀⲖⲖⲀ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠϪⲞⲈⲒⲤ. ⲈⲚⲈⲒⲢⲈ ⲆⲈ ⲘⲘⲞⲚ ⲚⲎⲦⲚ ⲚϨⲘϨⲀⲖ ϨⲒⲦⲚ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","ϪⲈ ⲠⲚⲞⲨⲦⲈ ⲠⲈⲚⲦⲀϤϪⲞⲞⲤ ϪⲈ ⲞⲨⲚ ⲞⲨⲞⲈⲒⲚ ⲚⲀϢⲀ ⲈⲂⲞⲖ ϨⲘ ⲠⲔⲀⲔⲈ. ⲠⲀⲒ ⲈⲚⲦⲀϤⲢⲞⲨⲞⲈⲒⲚ ϨⲚ ⲚⲈⲚϨⲎⲦ ⲈⲠⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲤⲞⲞⲨⲚ ⲘⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈϨⲞ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ⲞⲨⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲘⲠⲈⲒⲀϨⲞ ϨⲚ ϨⲈⲚϨⲚⲀⲀⲨ ⲚⲂⲖϪⲈ ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲈϨⲞⲨⲞ ⲚⲦϬⲞⲘ ϢⲰⲠⲈ ⲈⲠⲀⲠⲚⲞⲨⲦⲈ ⲠⲈ ⲈⲚⲞⲨⲈⲂⲞⲖ ⲚϨⲎⲦⲚ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ⲈⲨⲐⲖⲒⲂⲈ ⲘⲘⲞⲚ ϨⲚ ϨⲰⲂ ⲚⲒⲘ. ⲀⲖⲖⲀ ⲚⲦⲚϨⲈϪϨⲰϪ ⲀⲚ ⲈⲨⲀⲠⲞⲢⲒ ⲘⲘⲞⲚ. ⲀⲖⲖⲀ ⲚⲦⲚⲀⲠⲞⲢⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ⲈⲨⲆⲒⲰⲔⲈ ⲘⲘⲞⲚ. ⲀⲖⲖⲀ ⲈⲚϤⲔⲰ ⲘⲘⲞⲚ ⲀⲚ ⲚⲤⲰϤ. ⲈⲨⲦⲀⲨⲞ ⲘⲘⲞⲚ ⲈⲠⲈⲤⲎⲦ ⲀⲖⲖⲀ ⲚⲦⲚⲦⲀⲔⲞ ⲀⲚ ");
INSERT INTO copshc_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲈⲚϤⲒ ϨⲀ ⲠⲘⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ ϨⲘ ⲠⲈⲚⲤⲰⲘⲀ. ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲠⲰⲚϨ ⲚⲒⲤ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲚⲤⲰⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","ⲚⲞⲨⲞⲈⲒϢ ⲄⲀⲢ ⲚⲒⲘ ⲀⲚⲞⲚ ⲚⲈⲦⲞⲚϨ ⲤⲈⲠⲀⲢⲀⲆⲒⲆⲞⲨ ⲘⲘⲞⲚ ⲈⲠⲘⲞⲨ ⲈⲦⲂⲈ ⲒⲎⲤⲞⲨⲤ. ϪⲈⲔⲀⲀⲤ ⲞⲚ ⲠⲰⲚϨ ⲚⲒⲤ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲚⲤⲀⲢⲜ ⲈⲦⲈϢⲀⲤⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ϨⲰⲤⲦⲈ ⲠⲘⲞⲨ ⲈⲚⲈⲢⲄⲈⲒ ⲚϨⲎⲦⲚ. ⲠⲰⲚϨ ⲆⲈ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ⲈⲨⲚⲦⲀⲚ ϬⲈ ⲘⲘⲀⲨ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ ⲚⲦⲠⲒⲤⲦⲒⲤ. ⲔⲀⲦⲀ ⲠⲈⲦⲤⲎϨ ϪⲈ ⲀⲒⲠⲒⲤⲦⲈⲨⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲒϢⲀϪⲈ. ⲀⲚⲞⲚ ϨⲰⲰⲚ ⲦⲚⲠⲒⲤⲦⲈⲨⲈ ⲈⲦⲂⲈ ⲠⲀⲒ ⲦⲚϢⲀϪⲈ. ");
INSERT INTO copshc_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ⲈⲚⲤⲞⲞⲨⲚ ϪⲈ ⲠⲈⲚⲦⲀϤⲦⲞⲨⲚⲈⲤ ⲒⲎⲤⲞⲨⲤ. ϤⲚⲀⲦⲞⲨⲚⲞⲤⲚ ϨⲰⲰⲚ ⲘⲚ ⲒⲎⲤⲞⲨⲤ ⲚϤⲦⲀϨⲞⲚ ⲈⲢⲀⲦⲚ ⲚⲘⲘⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ⲈⲢⲈ ⲠⲦⲎⲢϤ ⲄⲀⲢ ϢⲞⲞⲠ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ. ϪⲈⲔⲀⲀⲤ ⲦⲈⲬⲀⲢⲒⲤ ⲈⲀⲤⲀϢⲀⲒ ϨⲒⲦⲘ ⲠⲈϨⲞⲨⲞ ⲈⲤⲈⲦⲀϢⲞ ⲘⲠⲈϢⲠϨⲘⲞⲦ ⲈⲠⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ⲈⲦⲂⲈ ⲠⲀⲒ ⲚⲦⲚⲈⲄⲔⲀϬⲈⲒ ⲀⲚ. ⲀⲖⲖⲀ ⲈϢϪⲈ ⲠⲈⲚⲔⲈⲢⲰⲘⲈ ⲈⲦϨⲒⲂⲞⲖ ⲦⲀⲔⲞ. ⲀⲖⲖⲀ ⲠⲈⲦϨⲒϨⲞⲨⲚ ⲢⲂⲢⲢⲈ ⲚⲞⲨϨⲞⲞⲨ ⲈⲨϨⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ⲠⲈⲤⲂⲞⲔ ⲄⲀⲢ ⲚⲦⲈⲚⲐⲖⲒⲮⲒⲤ ⲦⲈⲚⲞⲨ ⲔⲀⲦⲀ ⲞⲨϨⲞⲨⲞ ⲈⲨϨⲞⲨⲞ ϤⲢϨⲰⲂ ⲚⲀⲚ ⲈⲨⲚⲞϬ ⲚⲈⲞⲞⲨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ⲈⲚⲦⲚϬⲰϢⲦ ⲀⲚ ⲈⲚⲈⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲖⲖⲀ ⲈⲚⲈⲦⲈⲚⲦⲚⲚⲀⲨ ⲈⲢⲞⲞⲨ ⲀⲚ ⲚⲈⲦⲚⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲞⲞⲨ ϨⲈⲚⲠⲢⲞⲤⲞⲨⲞⲈⲒϢ ⲚⲈ ⲚⲈⲦⲈⲚⲦⲚⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲞⲨ ⲀⲚ ϨⲈⲚϢⲀ ⲈⲚⲈϨ ⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ⲦⲚⲤⲞⲞⲨⲚ ⲄⲀⲢ ϪⲈ ⲈⲢϢⲀⲚ ⲠⲎⲒ ⲘⲠⲈⲚⲘⲀ ⲚϢⲰⲠⲈ ⲚⲦⲈ ⲠⲔⲀϨ ⲂⲰⲖ ⲈⲂⲞⲖ. ⲞⲨⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲔⲰⲦ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲚⲞⲨⲦⲈ. ⲞⲨⲎⲈⲒ ⲚⲀⲦⲘⲞⲨⲚⲄ ⲚϬⲒϪ ϢⲀ ⲈⲚⲈϨ ϨⲚ ⲘⲠⲎⲞⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ⲔⲀⲒⲄⲀⲢ ⲦⲚⲀϢⲀϨⲞⲘ ϨⲘ ⲠⲀⲒ ⲈⲚⲞⲨⲈϢϮ ϨⲒⲰⲰⲚ ⲘⲠⲈⲚⲘⲀ ⲚϢⲰⲠⲈ ⲠⲈⲂⲞⲖ ϨⲚ ⲦⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ⲈϢϪⲈ ⲈⲚϢⲀⲚⲦⲀⲀϤ ⲞⲚ ϨⲒⲰⲰⲚ ⲚⲤⲈⲚⲀϨⲈ ⲈⲢⲞⲚ ⲀⲚ ⲈⲚⲔⲎⲔⲀϨⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ⲔⲀⲒⲄⲀⲢ ⲀⲚⲞⲚ ⲈⲚϨⲘ ⲠⲈⲈⲒⲘⲀ ⲚϢⲰⲠⲈ ⲦⲚⲀϢⲀϨⲞⲘ ⲈⲨⲂⲀⲢⲒ ⲘⲘⲞⲚ ⲈϪⲘⲠ ⲈⲦⲈⲚⲦⲚⲞⲨⲈϢ ⲔⲀⲀⲚ ⲔⲀϨⲎⲨ ⲘⲘⲞϤ ⲀⲚ. ⲀⲖⲖⲀ ⲈϮ ϨⲒⲰⲰϤ. ϪⲈⲔⲀⲀⲤ ⲈⲨⲈⲰⲘⲔ ⲘⲠⲈϢⲀϤⲘⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲰⲚϨ. ");
INSERT INTO copshc_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ⲠⲈⲚⲦⲀϤⲢϨⲰⲂ ⲆⲈ ⲈⲢⲞⲚ ⲈⲠⲀⲒ ⲠⲈ ⲠⲚⲞⲨⲦⲈ. ⲠⲈⲚⲦⲀϤϮ ⲚⲀⲚ ⲘⲠⲀⲢⲎⲂ ⲘⲠⲈⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copshc_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ⲈⲚⲦⲎⲔ ϬⲈ ⲚϨⲎⲦ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ. ⲀⲨⲰ ⲈⲚⲤⲞⲞⲨⲚ ϪⲈ ⲈⲚϢⲞⲞⲠ ϨⲘ ⲠⲤⲰⲘⲀ ⲦⲚⲘⲠⲂⲞⲖ ⲘⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ⲈⲚⲘⲞⲞϢⲈ ⲄⲀⲢ ϨⲒⲦⲚ ⲞⲨⲠⲒⲤⲦⲒⲤ. ϨⲒⲦⲚ ⲞⲨⲚⲀⲨ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ⲦⲚⲦⲎⲔ ⲚϨⲎⲦ ⲀⲨⲰ ⲈϨⲚⲀⲚ ⲚϨⲞⲨⲞ ⲈⲈⲒ ⲈⲂⲞⲖ ϨⲘ ⲠⲤⲰⲘⲀ ⲈⲂⲰⲔ ϨⲀⲦⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ⲈⲦⲂⲈ ⲠⲀⲒ ϬⲈ ⲦⲚⲢⲞⲞⲨⲦ ⲈⲒⲦⲈ ⲈⲚϨⲘ ⲠⲤⲰⲘⲀ ⲈⲒⲦⲈ ⲈⲚⲘⲠⲈϤⲂⲞⲖ ⲈⲦⲢⲈⲚϢⲰⲠⲈ ⲈⲚⲢⲀⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ϨⲀⲠⲤ ⲄⲀⲢ ⲈⲦⲢⲈⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲦⲎⲢⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲂⲎⲘⲀ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ϪⲈⲔⲀⲀⲤ ⲈⲢⲈ ⲠⲞⲨⲀ ⲠⲞⲨⲀ ϪⲒ ⲚⲈⲂⲞⲖ ϨⲒⲦⲘ ⲠⲈϤⲤⲰⲘⲀ ⲠⲢⲞⲤ ⲚⲈⲚⲦⲀϤⲀⲀⲨ. ⲈⲒⲦⲈ ⲀⲄⲀⲐⲞⲚ ⲈⲒⲦⲈ ⲠⲈⲐⲞⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ⲈⲚⲤⲞⲞⲨⲚ ϬⲈ ⲚⲐⲞⲦⲈ ⲘⲠϪⲞⲈⲒⲤ ⲦⲚⲠⲒ ⲐⲈ ⲚⲚⲢⲰⲘⲈ ⲦⲚⲞⲨⲞⲚϨ ⲆⲈ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ϮϨⲈⲖⲠⲒⲌⲈ ⲆⲈ ϪⲈ ⲀⲒⲞⲨⲰⲚϨ ⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲚⲈⲦⲚϨⲎⲦ. ");
INSERT INTO copshc_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ⲚⲚⲈⲚⲤⲨⲚϨⲒⲤⲦⲀ ⲄⲀⲢ ⲘⲘⲞⲚ ⲚⲎⲦⲚ ⲀⲚ. ⲀⲖⲖⲀ ⲈⲚϮ ⲚⲎⲦⲚ ⲚⲞⲨⲀⲪⲞⲢⲘⲎ ⲚϢⲞⲨϢⲞⲨ ϨⲀⲢⲞⲚ. ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲔⲀⲀⲤ ⲚⲎⲦⲚ ⲚⲚⲀϨⲢⲚ ⲚⲈⲦϢⲞⲨϢⲞⲨ ⲘⲘⲞⲞⲨ ϨⲘ ⲠϨⲞ ϨⲘ ⲠϨⲎⲦ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ⲈⲒⲦⲈ ⲄⲀⲢ ⲈϢϪⲈ ⲀⲚⲠⲰϢⲤ ⲚⲦⲀⲚⲠⲰϢⲤ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲒⲦⲈ ⲈϢϪⲈ ⲠⲈⲚϨⲎⲦ ⲤⲘⲞⲚⲦ ⲈϤⲤⲘⲞⲚⲦ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ⲦⲀⲄⲀⲠⲎ ⲄⲀⲢ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲘⲀϨⲦⲈ ⲘⲘⲞⲚ. ⲈⲀⲚⲔⲢⲒⲚⲈ ⲘⲠⲀⲒ ϪⲈ ⲈϢϪⲈ ⲀⲞⲨⲀ ⲘⲞⲨ ϨⲀⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ. ⲀⲢⲀ ⲀⲠⲦⲎⲢϤ ⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ⲀⲨⲰ ⲚⲦⲀϤⲘⲞⲨ ϨⲀⲢⲞⲞⲨ ⲦⲎⲢⲞⲨ ϪⲈⲔⲀⲀⲤ ⲚⲈⲦⲞⲚϨ ⲚⲚⲈⲨⲰⲚϨ ϬⲈ ⲚⲀⲨ ⲀⲖⲖⲀ ⲘⲠⲈⲚⲦⲀϤⲘⲞⲨ ϨⲀⲢⲞⲞⲨ ⲀⲨⲰ ⲀϤⲦⲰⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ϨⲰⲤⲦⲈ ⲀⲚⲞⲚ ϪⲒⲚ ⲦⲈⲚⲞⲨ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲀⲚ ⲚⲖⲀⲀⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲈϢϪⲈ ⲀⲚⲤⲞⲨⲚ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲞⲚ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ⲀⲖⲖⲀ ⲦⲈⲚⲞⲨ ⲚⲦⲚⲤⲞⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ϨⲰⲤⲦⲈ ⲠⲈⲦϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲤⲰⲚⲦ ⲚⲂⲢⲢⲈ ⲠⲈ. ⲀⲚⲀⲢⲬⲀⲒⲞⲚ ⲞⲨⲈⲒⲚⲈ. ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲀϨⲈⲚⲂⲢⲢⲈ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ⲠⲦⲎⲢϤ ⲆⲈ ϨⲈⲚⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ ⲚⲈ. ⲠⲀⲒ ⲈⲚⲦⲀϤϨⲞⲦⲠⲚ ⲚⲀϤ ϨⲒⲦⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲀⲨⲰ ⲀϤϮ ⲚⲀⲚ ⲚⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲘⲠϨⲰⲦⲠ. ");
INSERT INTO copshc_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ϪⲈ ⲚⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲈϤϨⲰⲦⲠ ⲚⲀϤ ⲘⲠⲔⲞⲤⲘⲞⲤ. ⲈⲚϤⲰⲠ ⲀⲚ ⲈⲢⲞⲞⲨ ⲚⲚⲈⲨⲚⲞⲂⲈ. ⲀⲨⲰ ⲈⲀϤⲔⲰ ϨⲢⲀⲒ ⲚϨⲎⲦⲚ ⲘⲠϢⲀϪⲈ ⲘⲠϨⲰⲦⲠ. ");
INSERT INTO copshc_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ⲈⲚⲞ ϬⲈ ⲚϤⲀⲒϢⲒⲚⲈ ϨⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲰⲤ ⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲤⲞⲠⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲚ. ⲦⲚⲤⲞⲠⲤ ϨⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲰⲦⲠ ⲈⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ⲠⲈⲦⲈⲘⲠϤⲤⲞⲨⲚ ⲚⲞⲂⲈ ⲀϤⲀⲀϤ ⲚⲚⲞⲂⲈ ϨⲀⲢⲞⲚ. ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈϢⲰⲠⲈ ⲚⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲠⲚⲞⲨⲦⲈ ϨⲢⲀⲒ ⲚϨⲎⲦϤ. ");
INSERT INTO copshc_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ⲈⲚⲞ ⲆⲈ ⲚϢⲂⲢⲢϨⲰⲂ ⲦⲚⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲈⲦⲘⲦⲢⲈⲦⲚϢⲰⲠ ⲈⲢⲰⲦⲚ ⲘⲠⲈϨⲘⲞⲦ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲠϪⲒⲚϪⲎ. ");
INSERT INTO copshc_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ϢⲀϤϪⲞⲞⲤ ⲄⲀⲢ ϪⲈ ϨⲚ ⲞⲨⲞⲨⲞⲈⲒϢ ⲈϤϢⲎⲠ ⲀⲒⲤⲰⲦⲘ ⲈⲢⲞⲔ ⲀⲨⲰ ϨⲚ ⲞⲨϨⲞⲞⲨ ⲚⲞⲨϪⲀⲒ ⲀⲒⲂⲞⲎⲐⲒ ⲈⲢⲞⲔ ⲈⲒⲤ ⲠⲈⲨⲞⲈⲒϢ ⲦⲈⲚⲞⲨ ⲈⲦϢⲎⲠ ⲈⲒⲤ ⲠⲈϨⲞⲞⲨ ⲦⲈⲚⲞⲨ ⲘⲠⲈⲨϪⲀⲒ ");
INSERT INTO copshc_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ⲈⲚⲦⲚϮ ⲀⲚ ⲚⲞⲨϪⲢⲞⲠ ⲚⲞⲨⲰⲦ ϨⲚ ⲖⲀⲀⲨ ⲚϨⲰⲂ. ϪⲈ ⲚⲚⲈ ⲞⲨⲀ ⲤⲈϢϤ ⲦⲈⲚⲆⲒⲀⲔⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ⲀⲖⲖⲀ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲈⲚⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞⲚ ϨⲰⲤ ⲆⲒⲀⲔⲞⲚⲞⲤ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ϨⲚ ⲞⲨϨⲨⲠⲞⲘⲞⲚⲎ ⲈⲚⲀϢⲰⲤ ϨⲚ ϨⲈⲚⲐⲖⲒⲮⲒⲤ ϨⲚ ϨⲈⲚⲀⲚⲀⲄⲔⲎ ϨⲚ ϨⲈⲚⲖⲰϪϨ. ");
INSERT INTO copshc_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ϨⲚ ϨⲈⲚⲤⲎϢⲈ ϨⲚ ϨⲈⲚϢⲦⲈⲔⲞ ϨⲚ ϨⲈⲚϢⲦⲞⲢⲦⲢ ϨⲚ ϨⲈⲚϨⲒⲤⲈ ϨⲚ ϨⲈⲚⲞⲨϢⲎ ⲚⲢⲞⲒⲤ ϨⲚ ϨⲈⲚⲚⲎⲤⲦⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ϨⲚ ⲞⲨⲦⲂⲂⲞ ϨⲚ ⲞⲨⲤⲞⲞⲨⲚ ϨⲚ ⲞⲨⲘⲚⲦϨⲀⲢϢϨⲎⲦ ϨⲚ ⲞⲨⲘⲚⲦⲬⲢⲎⲤⲦⲞⲤ ϨⲚ ⲞⲨⲠⲚⲈⲨⲘⲀ ⲈϤⲞⲨⲀⲀⲂ ϨⲚ ⲞⲨⲀⲄⲀⲠⲎ ⲀϪⲚ ϨⲨⲠⲞⲔⲢⲒⲚⲈ. ");
INSERT INTO copshc_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ϨⲚ ⲞⲨϢⲀϪⲈ ⲚⲦⲈⲦⲘⲈ ϨⲚ ⲞⲨϬⲞⲘ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ ϨⲒⲦⲚ ⲚϨⲞⲠⲖⲞⲚ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲚⲈⲦϨⲒⲞⲨⲚⲀⲘ ⲘⲚ ⲚⲈⲦϨⲒϨⲂⲞⲨⲢ. ");
INSERT INTO copshc_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ϨⲒⲦⲚ ⲞⲨⲈⲞⲞⲨ ⲘⲚ ⲞⲨⲤⲰϢ. ϨⲒⲦⲚ ⲞⲨⲘⲚⲦⲢⲈϤϪⲒ ⲞⲨⲀ ⲘⲚ ⲞⲨⲤⲘⲞⲨ. ϨⲰⲤ ⲠⲖⲀⲚⲞⲤ ⲀⲨⲰ ⲚⲢⲘⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ϨⲰⲤ ⲈⲨⲞⲂϢ ⲈⲢⲞⲚ ⲀⲨⲰ ⲈⲨⲤⲞⲞⲨⲚ ⲘⲘⲞⲚ ϨⲰⲤ ⲈⲚⲘⲞⲨ ⲀⲨⲰ ⲈⲒⲤ ϨⲎⲎⲦⲈ ⲦⲚⲞⲚϨ ϨⲰⲤ ⲈⲨⲠⲀⲒⲆⲈⲨⲈ ⲘⲘⲞⲚ ⲀⲨⲰ ⲚⲤⲈⲘⲞⲨⲞⲨⲦ ⲀⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ϨⲰⲤ ⲈⲚⲖⲨⲠⲈⲒ ⲈⲚⲢⲀϢⲈ ⲆⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ϨⲰⲤ ϨⲎⲔⲈ ⲈⲚⲈⲒⲢⲈ ⲆⲈ ⲚⲞⲨⲘⲎⲎϢⲈ ⲚⲢⲘⲘⲀⲞ ϨⲰⲤ ⲈⲘⲚⲦⲀⲚ ⲖⲀⲀⲨ ⲘⲘⲀⲨ ⲈⲚⲀⲘⲀϨⲦⲈ ⲆⲈ ⲘⲠⲦⲎⲢϤ. ");
INSERT INTO copshc_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ⲦⲈⲚⲦⲀⲠⲢⲞ ⲞⲨⲎⲚ ⲈⲢⲰⲦⲚ ⲚⲔⲞⲢⲒⲚⲐⲒⲞⲤ. ⲠⲈⲚϨⲎⲦ ⲞⲨⲞϢⲤ. ");
INSERT INTO copshc_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ⲚⲦⲈⲦⲚ ϨⲈϪϨⲰϪ ⲀⲚ ⲚϨⲎⲦⲚ. ⲦⲈⲦⲚϨⲈϪϨⲰϪ ⲆⲈ ϨⲚ ⲚⲈⲦⲚⲘⲚⲦϢⲀⲚϨⲦⲎϤ. ");
INSERT INTO copshc_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ϮϢⲂⲈⲒⲰ ⲆⲈ ⲚⲞⲨⲰⲦ ⲘⲠⲂⲈⲔⲈ. ϮϪⲰ ⲘⲘⲞⲤ ⲚⲎⲦⲚ ϨⲰⲤ ϢⲎⲢⲈ. ⲞⲨⲰϢⲤ ϨⲰⲦⲦⲎⲨⲦⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copshc_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ⲘⲠⲢϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲘⲞⲞϢⲈ ⲘⲚ ⲚⲀⲠⲒⲤⲦⲞⲤ. ⲀϢ ⲄⲀⲢ ⲦⲈ ⲦⲘⲈⲦⲞⲬⲎ ⲚⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ⲘⲚ ⲦⲀⲚⲞⲘⲒⲀ. ⲚⲀϢ ⲦⲈ ⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲘⲠⲞⲨⲞⲈⲒⲚ ⲘⲚ ⲠⲔⲀⲔⲈ. ");
INSERT INTO copshc_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ⲀϢ ⲆⲈ ⲦⲈ ⲦⲤⲨⲘⲪⲰⲚⲎⲤⲒⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲚ ⲂⲈⲖⲒⲀⲢ. ⲀϢ ⲆⲈ ⲦⲈ ⲦⲘⲈⲢⲒⲤ ⲚⲞⲨⲠⲒⲤⲦⲞⲤ ⲘⲚ ⲞⲨⲀⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ⲎⲞⲨ ⲠⲈ ⲠϢⲰⲚⲂ ⲘⲠⲢⲠⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲘⲚ ⲚⲈⲒⲆⲰⲖⲞⲚ ⲀⲚⲞⲚ ⲄⲀⲢ ⲀⲚⲞⲚ ⲠⲢⲠⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲞⲚϨ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ϪⲞⲞⲤ ϪⲈ ϮⲚⲀⲞⲨⲰϨ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲦⲀⲘⲞⲞϢⲈ ⲚϨⲎⲦⲞⲨ ⲦⲀϢⲰⲠⲈ ⲚⲀⲨ ⲚⲚⲞⲨⲦⲈ ⲚⲤⲈϢⲰⲠⲈ ⲚⲀⲒ ⲚⲖⲀⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲘⲎⲈⲒⲦⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲈⲨⲘⲎ ⲦⲈ ⲚⲦⲈⲦⲚ ⲠⲢϪ ⲦⲎⲨⲦⲚ ⲈⲢⲞⲞⲨ ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ. ⲚⲦⲈⲦⲚ ⲦⲘϪⲰϨ ⲈⲀⲔⲀⲐⲀⲢⲦⲞⲚ. ⲀⲨⲰ ⲀⲚⲞⲔ ϮⲚⲀϢⲈⲠ ⲦⲎⲨⲦⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ⲦⲀϢⲰⲠⲈ ⲚⲎⲦⲚ ⲈⲨⲈⲒⲰⲦ ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲚⲀⲒ ⲈϨⲈⲚϢⲎⲢⲈ ⲘⲚ ϨⲈⲚϢⲈⲈⲢⲈ. ⲠⲈϪⲈ ⲠϪⲞⲈⲒⲤ ⲠⲠⲀⲚⲦⲞⲔⲢⲀⲦⲰⲢ. ");
INSERT INTO copshc_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ⲈⲨⲚⲦⲀⲚ ϬⲈ ⲘⲘⲀⲨ ⲚⲚⲈⲒⲈⲢⲎⲦ ⲚⲀⲘⲈⲢⲀⲦⲈ ⲘⲀⲢⲚⲦⲂⲂⲞⲚ ⲈⲂⲞⲖ ϨⲚ ⲦⲰⲖⲘ ⲚⲒⲘ ⲚⲦⲈ ⲦⲤⲀⲢⲜ ⲘⲚ ⲠⲈⲠⲚⲈⲨⲘⲀ. ⲈⲚϪⲰⲔ ⲈⲂⲞⲖ ⲚⲞⲨⲦⲂⲂⲞ ϨⲚ ⲐⲞⲦⲈ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ϢⲞⲠⲚ ⲈⲢⲰⲦⲚ ⲘⲠⲚϪⲒ ⲖⲀⲀⲨ ⲚϬⲞⲚⲤ ⲘⲠⲚⲦⲀⲔⲈ ⲖⲀⲀⲨ ⲘⲠⲚϤⲈϬ ⲖⲀⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ⲚⲈⲈⲒϪⲰ ⲘⲘⲞⲤ ⲀⲚ ⲈⲈⲒⲦϬⲀⲈⲒⲞ ⲘⲘⲰⲦⲚ ⲀⲒⲞⲨⲰ ⲄⲀⲢ ⲈⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲚϢⲞⲞⲠ ϨⲚ ⲚⲈⲚϨⲎⲦ ⲈⲘⲞⲨ ⲀⲨⲰ ⲈⲰⲚϨ ϨⲒ ⲞⲨⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ⲞⲨⲚⲦⲀⲒ ⲞⲨⲚⲞϬ ⲘⲠⲀⲢϨⲎⲤⲒⲀ ⲚⲚⲀϨⲢⲎ ⲦⲚ ⲞⲨⲚⲦⲀⲒ ⲞⲨⲚⲞϬ ⲚϢⲞⲨϢⲞⲨ ϨⲀⲢⲰⲦⲚ ϮϪⲎⲔ ⲈⲂⲞⲖ ⲘⲠⲤⲞⲠⲤ ϮⲢϨⲞⲨⲞ ⲈⲘⲀⲦⲈ ϨⲘ ⲠⲢⲀϢⲈ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈⲚⲐⲖⲒⲮⲒⲤ ⲦⲎⲢⲤ. ");
INSERT INTO copshc_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ⲔⲀⲒⲄⲀⲢ ⲚⲦⲈⲢⲈⲚⲈⲒ ⲈϨⲢⲀⲒ ⲈⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲘⲠⲈⲦⲈⲚⲤⲀⲢⲜ ϪⲒ ⲖⲀⲀⲨ ⲘⲘⲞⲦⲚⲈⲤ ⲀⲖⲖⲀ ⲈⲨⲐⲖⲒⲂⲈ ⲘⲘⲞⲚ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ϨⲈⲚⲘⲒϢⲈ ϨⲒⲂⲞⲖ ϨⲈⲚϨⲞⲦⲈ ϨⲒϨⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ⲀⲖⲖⲀ ⲠⲚⲞⲨⲦⲈ ⲈⲦⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲚⲚⲈⲦⲐⲂⲂⲒⲎⲨ. ⲀϤⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲞⲚ ϨⲘ ⲠⲦⲢⲈ ⲦⲒⲦⲞⲤ ⲈⲒ ϢⲀⲢⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ϨⲘ ⲠⲦⲢⲈϤⲈⲒ ⲆⲈ ⲘⲘⲀⲦⲈ ⲀⲚ ⲀⲖⲖⲀ ϨⲘ ⲠⲔⲈⲘⲦⲞⲚ ⲚϨⲎⲦ ⲈⲚⲦⲀϤⲀⲀϤ ⲈϪⲚ ⲦⲎⲨⲦⲚ ⲈϤⲦⲀⲘⲞ ⲘⲘⲞⲚ ⲈⲠⲈⲦⲚⲘⲈ ⲘⲚ ⲠⲈⲦⲚⲢⲒⲘⲈ ⲘⲚ ⲠⲈⲦⲚⲔⲰϨ ϨⲀⲢⲞⲒ ϨⲰⲤⲦⲈ ⲈⲦⲢⲀⲢⲀϢⲈ ⲚϨⲞⲨⲞ ");
INSERT INTO copshc_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ϪⲈ ⲈϢϪⲈ ⲀⲒⲢⲠⲔⲈⲖⲨⲠⲒ ⲘⲘⲰⲦⲚ ϨⲚ ⲦⲈⲠⲒⲤⲦⲞⲖⲎ ⲚϮⲈⲒⲢⲈ ⲚϨⲦⲎⲈⲒ ⲀⲚ ⲈϢϪⲈ ⲚⲈⲒⲚⲀⲢ ⲠⲔⲈⲢϨⲦⲎⲒ ⲠⲈ ⲈⲈⲒϬⲰϢⲦ ϪⲈ ⲦⲈⲠⲒⲤⲦⲞⲖⲎ ⲈⲦⲘⲘⲀⲨ ⲈϢϪⲈ ⲀⲤⲖⲨⲠⲈⲒ ⲘⲘⲰⲦⲚ ⲠⲢⲞⲤ ⲞⲨⲞⲨⲚⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ϮⲢⲀϢⲈ ⲦⲈⲚⲞⲨ ϪⲈ ⲀⲦⲈⲦⲚⲖⲨⲠⲒ ⲀⲚ. ⲀⲖⲖⲀ ϪⲈ ⲀⲦⲈⲦⲚⲖⲨⲠⲒ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ⲚⲦⲀⲦⲈⲦⲚⲖⲨⲠⲒ ⲄⲀⲢ ⲔⲀⲦⲀ ⲠⲚⲞⲨⲦⲈ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈⲦⲚϢⲰⲰⲦ ϨⲚ ⲖⲀⲀⲨ ⲈⲂⲞⲖ ⲘⲘⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ⲦⲖⲨⲠⲎ ⲄⲀⲢ ⲔⲀⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲈⲤⲢϨⲰⲂ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲚⲀⲦⲢϨⲦⲎⲤ ⲈⲨⲞⲨϪⲀⲒ. ⲦⲖⲨⲠⲎ ⲆⲈ ⲘⲠⲔⲞⲤⲘⲞⲤ ⲈⲤⲢϨⲰⲂ ⲈⲠⲘⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ⲈⲒⲤ ⲠⲈⲈⲒⲦⲢⲈⲦⲚⲖⲨⲠⲒ ⲄⲀⲢ ⲔⲀⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲀϤⲢϨⲰⲂ ⲚⲎⲦⲚ ⲈⲨⲚⲞϬ ⲚⲤⲠⲞⲨⲆⲎ ⲘⲚ ⲞⲨⲀⲠⲞⲖⲞⲄⲒⲀ ⲘⲚ ⲞⲨⲘⲔⲀϨ ⲚϨⲎⲦ ⲘⲚ ⲞⲨϨⲞⲦⲈ ⲘⲚ ⲞⲨⲘⲈ ⲘⲚ ⲞⲨⲔⲰϨ ⲘⲚ ⲞⲨⲔⲂⲀ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲀⲦⲈⲦⲚⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲰⲦⲚ ⲈⲦⲈⲦⲚⲞⲨⲀⲀⲂ ϨⲘ ⲠϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ⲀⲢⲀ ⲈϢϪⲈ ⲀⲒⲤϨⲀⲒ ⲚⲎⲦⲚ ⲚⲦⲀⲒⲤϨⲀⲒ ⲀⲚ ⲈⲦⲂⲈ ⲠⲈⲚⲦⲀϤϪⲒ ⲚϬⲞⲚⲤ. ⲞⲨⲆⲈ ⲈⲦⲂⲈ ⲠⲈⲚⲦⲀⲨϪⲒⲦϤ ⲀⲚ ⲚϬⲞⲚⲤ. ⲀⲖⲖⲀ ϪⲈ ⲈⲢⲈⲦⲈⲦⲚⲤⲠⲞⲨⲆⲎ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲦⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞⲤ ϨⲀⲢⲞⲚ ");
INSERT INTO copshc_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ⲈⲦⲂⲈ ⲠⲀⲒ ⲀⲠⲈⲚϨⲎⲦ ⲘⲦⲞⲚ ⲚⲚⲀϨⲢⲎⲦⲚ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲚⲞⲨⲦⲈ. ⲈϪⲘ ⲠⲈⲘⲦⲞⲚ ⲆⲈ ⲚϨⲎⲦ ⲀⲚⲢⲀϢⲈ ⲈⲘⲀⲦⲈ ⲈϪⲘ ⲠⲢⲀϢⲈ ⲚⲦⲒⲦⲞⲤ ϪⲈ ⲀⲠⲈϤⲠⲚⲈⲨⲘⲀ ⲘⲦⲞⲚ ϨⲒⲦⲈⲦⲎⲨⲦⲚ ⲦⲎⲢⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ϪⲈ ϢⲞⲨϢⲞⲨ ⲚⲒⲘ ⲈⲚⲦⲀⲒⲀⲀⲨ ⲈϪⲰⲦⲚ ϨⲀⲦⲎϤ ⲘⲠⲒϪⲒϢⲒⲠⲈ ⲘⲘⲞⲞⲨ. ⲀⲖⲖⲀ ⲚⲐⲈ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲈⲚⲦⲀⲚϢⲀϪⲈ ⲚⲘⲘⲎⲦⲚ ϨⲚ ⲞⲨⲘⲈ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲈⲚⲔⲈϢⲞⲨϢⲞⲨ ⲈⲚⲦⲀⲚⲀⲀϤ ϨⲀⲦⲚ ⲦⲒⲦⲞⲤ ⲚⲦⲀϤϢⲰⲠⲈ ⲘⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ⲀⲨⲰ ⲚⲈϤⲘⲚⲦϢⲀⲚϨⲦⲎϤ ϢⲞⲞⲠ ⲚϨⲞⲨⲞ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ. ⲈϤⲈⲒⲢⲈ ⲘⲠⲘⲈⲈⲨⲈ ⲚⲦⲈⲦⲚ ⲘⲚⲦⲤⲦⲘⲎⲦ ⲦⲎⲢⲦⲚ ⲚⲐⲈ ⲈⲚⲦⲀⲦⲈⲦⲚϢⲞⲠϤ ⲈⲢⲰⲦⲚ ϨⲚ ⲞⲨϨⲞⲦⲈ ⲘⲚ ⲞⲨⲤⲦⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ϮⲢⲀϢⲈ ϬⲈ ϪⲈ ϮⲦⲎⲔ ⲚϨⲎⲦ ⲘⲘⲰⲦⲚ ϨⲚ ϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ⲦⲚⲦⲀⲘⲞ ⲆⲈ ⲘⲘⲰⲦⲚ ⲚⲈⲤⲚⲎⲨ ⲈⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲦⲀⲒ ⲈⲚⲦⲀⲨⲦⲀⲀⲤ ϨⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ϪⲈ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲆⲞⲔⲒⲘⲎ ⲚⲐⲖⲒⲮⲒⲤ ⲀⲠⲈϨⲞⲨⲞ ⲘⲠⲈⲨⲢⲀϢⲈ ⲘⲚ ⲦⲈⲨⲘⲚⲦϨⲎⲔⲈ ⲈⲦⲚⲀϢⲰⲤ ⲢϨⲞⲨⲞ ⲈϨⲞⲨⲚ ⲈⲦⲘⲚⲦⲢⲘⲘⲀⲞ ⲚⲦⲈⲨⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ. ");
INSERT INTO copshc_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ϪⲈ ϮⲢⲘⲚⲦⲢⲈ ϪⲈ ⲔⲀⲦⲀⲦⲈⲨϬⲞⲘ. ⲀⲨⲰ ⲠⲀⲢⲀⲦⲈⲨϬⲞⲘ ϨⲀ ⲠⲈⲨϨⲦⲞⲢ ⲞⲨⲀⲀⲦⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ⲈⲨⲤⲞⲠⲤ ⲘⲘⲞⲚ ϨⲚ ⲞⲨⲚⲞϬ ⲚⲤⲞⲠⲤ ⲈϪⲒ ⲚⲦⲈⲨⲬⲀⲢⲒⲤ ⲘⲚ ⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲚⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲦϪⲒ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲞⲨⲀⲀⲂ. ");
INSERT INTO copshc_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ⲈⲚⲔⲀⲦⲀ ⲐⲈ ⲀⲚ ⲈⲚⲦⲀⲚϨⲈⲖⲠⲒⲌⲈ. ⲀⲖⲖⲀ ⲀⲨⲦⲀⲀⲨ ⲚϢⲞⲢⲠ ⲘⲠϪⲞⲈⲒⲤ. ⲀⲨⲰ ⲚⲀⲚ ϨⲒⲦⲘ ⲠⲞⲨⲰϢ ⲘⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ⲈⲦⲢⲈⲚⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲚⲦⲒⲦⲞⲤ. ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦⲀϤⲀⲢⲬⲒ ϪⲒⲚ ⲚϢⲞⲢⲠ ⲚϤϪⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲈⲈⲒϨⲈ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ⲚⲦⲈⲒⲔⲈⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ⲀⲖⲖⲀ ⲚⲐⲈ ⲈⲦⲈⲦⲚⲞ ⲚϨⲞⲨⲞ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ϨⲚ ⲦⲠⲒⲤⲦⲒⲤ ⲘⲚ ⲠϢⲀϪⲈ ⲘⲚ ⲠⲤⲞⲞⲨⲚ ⲘⲚ ⲤⲠⲞⲨⲆⲎ ⲚⲒⲘ ⲀⲨⲰ ⲦⲈⲚⲀⲄⲀⲠⲎ ⲈⲦϢⲞⲞⲠ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ϪⲈⲔⲀⲀⲤ ⲈⲦⲈⲦⲚⲈⲢϨⲞⲨⲞ ϨⲚ ⲦⲈⲒⲔⲈⲬⲀⲢⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ⲚⲈⲒϪⲰ ⲘⲘⲞⲤ ⲀⲚ ⲔⲀⲦⲀ ⲞⲨⲈϨⲤⲀϨⲚⲈ. ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲈⲤⲠⲞⲨⲆⲎ ⲚϨⲈⲚⲔⲞⲞⲨⲈ ⲈⲒⲆⲞⲔⲒⲘⲀⲌⲈ ϨⲰⲦⲦⲎⲨⲦⲚ ⲚⲦⲘⲚⲦϨⲀⲔ ⲚⲦⲈⲦⲚ ⲀⲄⲀⲠⲎ. ");
INSERT INTO copshc_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ⲦⲈⲦⲚⲈⲒⲘⲈ ⲄⲀⲢ ⲈⲦⲬⲀⲢⲒⲤ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀϤⲢϨⲎⲔⲈ ⲈⲦⲂⲈ ⲦⲎⲨⲦⲚ ⲈⲨⲢⲘⲘⲀⲞ ⲠⲈ. ϪⲈⲔⲀⲀⲤ ϨⲰⲦ ⲦⲎⲨⲦⲚ ⲈⲦⲈⲦⲚⲈⲢⲢⲘⲘⲀⲞ ϨⲚ ⲦⲘⲚⲦϨⲎⲔⲈ ⲘⲠⲈⲦⲘⲘⲀⲨ. ");
INSERT INTO copshc_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ϮϮ ⲆⲈ ⲚⲞⲨⲄⲚⲰⲘⲎ ⲚⲎⲦⲚ ⲘⲠⲀⲒ ⲠⲀⲒ ⲄⲀⲢ ⲠⲈⲦⲢⲚⲞϤⲢⲈ ⲚⲎⲦⲚ. ⲚⲀⲒ ⲘⲠⲈⲒⲢⲈ ⲘⲘⲀⲦⲈ ⲀⲚ. ⲀⲖⲖⲀ ⲠⲔⲈⲞⲨⲰϢ ⲀⲦⲈⲦⲚⲀⲢⲬⲒ ⲘⲘⲞϤ ϪⲒⲚ ⲤⲚⲞⲨϤ. ");
INSERT INTO copshc_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ⲦⲈⲚⲞⲨ ⲆⲈ ϪⲈ ⲔⲠⲔⲈⲈⲒⲢⲈ ⲈⲂⲞⲖ. ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲘⲠⲞⲨⲢⲞⲦ ⲘⲠⲞⲨⲰϢ. ⲦⲀⲒ ⲦⲈ ⲐⲈ ⲘⲠⲔⲈϪⲰⲔ ⲈⲂⲞⲖ ϨⲘ ⲠⲈⲦⲈⲞⲨⲚⲦⲎⲦⲚϤ. ");
INSERT INTO copshc_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ⲈϢϪⲈ ⲠⲞⲨⲢⲞⲦ ⲄⲀⲢ ⲔⲎ ⲈϨⲢⲀⲒ ⲔⲀⲦⲀ ⲠⲈⲦⲈⲞⲨⲚⲦⲀϤⲤϤ. ϤϢⲎⲠ ⲔⲀⲦⲀ ⲠⲈⲦⲈⲘⲚⲦⲀϤⲤϤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ϪⲈⲔⲀⲀⲤ ⲄⲀⲢ ⲀⲚ ⲈⲢⲈ ⲞⲨⲘⲦⲞⲚ ϢⲰⲠⲈ ⲚϨⲞⲒⲚⲈ. ⲚⲦⲈ ⲞⲨⲐⲖⲒⲮⲒⲤ ϢⲰⲠⲈ ⲚⲎⲦⲚ. ⲀⲖⲖⲀ ϨⲚ ⲞⲨϢⲰϢ ");
INSERT INTO copshc_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ϨⲘ ⲠⲈⲈⲒⲞⲨⲞⲈⲒϢ ⲦⲈⲚⲞⲨ ⲚⲦⲈ ⲠⲈⲦⲚϨⲞⲨⲞ ϢⲰⲠⲈ ⲈⲠϢⲰⲰⲦ ⲚⲚⲎ ϪⲈⲔⲀⲀⲤ ϨⲰⲰϤ ⲈⲢⲈ ⲠⲈϨⲞⲨⲞ ⲚⲚⲎ ϢⲰⲠⲈ ⲈⲠⲈⲦⲚϢⲰⲰⲦ ϪⲈ ⲈⲢⲈ ⲞⲨϢⲰϢ ϢⲰⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲠⲀ ⲠϨⲞⲨⲞ ⲘⲠϤⲢϨⲞⲨⲞ ⲀⲨⲰ ⲠⲀ ⲠⲔⲞⲨⲒ ⲘⲠϤⲤⲂⲞⲔ. ");
INSERT INTO copshc_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ⲠⲈϨⲘⲞⲦ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ⲠⲀⲒ ⲈⲦϮ ⲚϮⲤⲠⲞⲨⲆⲎ ⲚⲞⲨⲰⲦ ϨⲀⲢⲰⲦⲚ ϨⲘ ⲠϨⲎⲦ ⲚⲦⲒⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ϪⲈ ⲠⲈⲚⲤⲞⲠⲤ ⲘⲈⲚ ⲀϤϪⲒⲦϤ. ⲈϤⲞ ⲆⲈ ⲚⲤⲠⲞⲨⲆⲀⲒⲞⲤ ⲚϨⲞⲨⲞ ⲀϤⲈⲒ ⲈⲂⲞⲖ ϢⲀⲢⲰⲦⲚ ⲈϨⲚⲀϤ. ");
INSERT INTO copshc_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ⲀⲚⲦⲚⲚⲞⲞⲨ ⲆⲈ ⲚⲘⲘⲀϤ ⲘⲠⲤⲞⲚ ⲠⲀⲒ ⲈⲦⲈⲢⲈ ⲠⲈϤⲦⲀⲈⲒⲞ ϢⲞⲞⲠ ϨⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϨⲒⲦⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲀⲨⲢⲠⲔⲈⲚⲈϨϤ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦⲢⲈϤⲈⲒ ⲈⲂⲞⲖ ⲚⲘⲘⲀⲚ ϨⲘ ⲠⲈⲒϨⲘⲞⲦ ⲈⲦⲞⲨⲆⲒⲀⲔⲞⲚⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲚ ⲚⲚⲀϨⲢⲘ ⲠⲈⲞⲞⲨ ⲘⲠϪⲞⲈⲒⲤ ⲘⲚ ⲠⲈⲚⲞⲨⲢⲞⲦ. ");
INSERT INTO copshc_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ⲈⲚⲤⲒϨⲈ ⲘⲘⲞⲚ ⲘⲠⲀⲒ ⲘⲎⲠⲰⲤ ⲚⲦⲈ ⲞⲨⲀ ⲦⲈϬⲞⲨⲦⲰⲖⲘ ⲈⲢⲞⲚ ϨⲘ ⲠⲈⲈⲒⲦⲀϪⲢⲞ ⲈⲦⲞⲨⲆⲒⲀⲔⲞⲚⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ⲦⲚϤⲒ ⲄⲀⲢ ⲘⲠⲢⲞⲞⲨϢ ⲚϨⲈⲚⲠⲈⲦⲚⲀⲚⲞⲨⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲘⲠϪⲞⲈⲒⲤ ⲘⲘⲀⲦⲈ ⲀⲚ. ⲀⲖⲖⲀ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲔⲈⲢⲰⲘⲈ. ");
INSERT INTO copshc_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ⲀⲚⲦⲚⲚⲞⲞⲨ ⲆⲈ ⲚⲘⲘⲀⲨ ⲘⲠⲈⲚⲔⲈⲤⲞⲚ ⲠⲀⲒ ⲈⲚⲦⲀⲚⲆⲞⲔⲒⲘⲀⲌⲈ ⲘⲘⲞϤ ϨⲚ ϨⲀϨ ⲚⲤⲞⲠ ⲈⲨⲤⲠⲞⲨⲆⲀⲒⲞⲤ ⲠⲈ. ⲦⲈⲚⲞⲨ ⲆⲈ ⲚϨⲞⲨ ⲈⲤⲠⲞⲨⲆⲀⲒⲞⲤ. ϨⲚ ⲞⲨⲚⲀϨⲦⲈ ⲆⲈ ⲈⲚⲀϢⲰϤ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ⲈⲒⲦⲈ ϨⲀ ⲦⲒⲦⲞⲤ ⲠⲀⲔⲞⲒⲚⲰⲚⲞⲤ ⲠⲈ. ⲀⲨⲰ ⲚϢⲂⲢⲢϨⲰⲂ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ ⲈⲒⲦⲈ ⲚⲈⲚⲤⲚⲎⲨ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈ ⲚⲚⲈⲔⲔⲖⲎⲤⲒⲀ. ⲠⲈⲞⲞⲨ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ⲠⲞⲨⲰⲚϨ ϬⲈ ⲈⲂⲞⲖ ⲚⲦⲈⲦⲚ ⲀⲄⲀⲠⲎ ⲀⲨⲰ ⲠⲈⲚϢⲞⲨϢⲞⲨ ⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞϤ ϨⲀⲢⲰⲦⲚ. ⲞⲨⲞⲚϨⲞⲨ ⲈⲢⲞⲞⲨ ⲘⲠⲈⲘⲦⲞ ⲈⲂⲞⲖ ⲚⲚⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ⲈⲦⲂⲈ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲄⲀⲢ ⲦⲀⲒ ⲈⲦϢⲞⲞⲠ ⲈϨⲞⲨⲚ ⲈⲚⲈⲦⲞⲨⲀⲀⲂ. ⲞⲨϨⲞⲨⲞ ⲈⲢⲞⲒ ⲠⲈ ⲈⲤϨⲀⲒ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ϮⲤⲞⲞⲨⲚ ⲄⲀⲢ ⲘⲠⲈⲦⲚⲞⲨⲢⲞⲦ ⲠⲀⲒ ⲈϮϢⲞⲨϢⲞⲨ ⲘⲘⲞⲒ ⲚϨⲎⲦϤ ϨⲀⲢⲰⲦⲚ ϨⲚ ⲘⲘⲀⲔⲈⲆⲰⲚ. ϪⲈ ⲀⲦⲀⲬⲀⲒⲀ ⲤⲂⲦⲰⲦⲤ ϪⲒⲚ ⲤⲚⲞⲨϤ. ⲀⲨⲰ ⲀⲠⲈⲦⲚⲔⲰϨ ⲦⲂⲤ ⲞⲨⲘⲎⲎϢⲈ. ");
INSERT INTO copshc_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ⲀⲒⲦⲚⲚⲞⲞⲨ ⲆⲈ ⲚⲚⲈⲤⲚⲎⲨ ϪⲈⲔⲀⲀⲤ ⲈⲚⲚⲈ ⲠⲈⲚϢⲞⲨϢⲞⲨ ⲰϪⲚ ⲈⲦⲚⲈⲒⲢⲈ ⲘⲘⲞϤ ϨⲀⲢⲰⲦⲚ ϨⲘ ⲠⲈⲈⲒⲤⲀ. ⲀⲖⲖⲀ ϪⲈⲔⲀⲀⲤ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲈⲒϪⲰ ⲘⲘⲞⲤ ⲚⲦⲈⲦⲚ ϢⲰⲠⲈ ⲈⲦⲈⲦⲚⲤⲂⲦⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈⲈⲒ ⲚⲘⲘⲀⲒ ⲚϬⲒ ⲘⲘⲀⲔⲈⲆⲰⲚ ⲚⲤⲈϨⲈ ⲈⲢⲰⲦⲚ ⲈⲚⲦⲈⲦⲚⲤⲂⲦⲰⲦ ⲀⲚ. ⲚⲦⲚϪⲒϢⲒⲠⲈ ⲀⲚⲞⲚ ϨⲘ ⲠⲈⲒⲦⲀϪⲢⲞ ϪⲈ ⲚⲚⲈⲚϪⲞⲞⲤ ϪⲈ ⲚⲦⲰⲦⲚ . ");
INSERT INTO copshc_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ⲀⲒⲞⲠϤ ϬⲈ ϪⲈ ⲞⲨⲀⲚⲀⲄⲔⲀⲒⲞⲚ ⲠⲈ ⲈⲤⲈⲠⲤ ⲚⲈⲤⲚⲎⲨ ϪⲈ ⲈⲨⲈϢⲢⲠⲈⲒ ϢⲀⲢⲰⲦⲚ. ⲚⲤⲈϢⲢⲠⲤⲞⲂⲦⲈ ⲘⲠⲈⲦⲚⲤⲘⲞⲨ ⲈⲚⲦⲀⲦⲈⲦⲚⲈⲢⲎⲦ ⲘⲘⲞϤ ϪⲒⲚ ⲚϢⲞⲢⲠ. ⲈⲦⲢⲈϤϢⲰⲠⲈ ⲈϤⲤⲂⲦⲰⲦ ⲚⲦⲈⲈⲒϨⲈ ϨⲰⲤ ⲤⲘⲞⲨ ⲀⲨⲰ ϨⲰⲤ ϪⲒ ⲚϬⲞⲚⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","ⲠⲀⲒ ⲆⲈ ⲠⲈ ϪⲈ ⲠⲈⲦϪⲞ ϨⲚ ⲞⲨϮⲤⲞ ⲈϤⲚⲀⲰϨⲤ ⲞⲚ ϨⲚ ⲞⲨϮⲤⲞ. ⲀⲨⲰ ⲠⲈⲦϪⲞ ϨⲚ ⲞⲨⲤⲘⲞⲨ ⲈϤⲚⲀⲰϨⲤ ϨⲚ ⲞⲨⲤⲘⲞⲨ ");
INSERT INTO copshc_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ⲠⲞⲨⲀ ⲠⲞⲨⲀ ⲠⲈⲚⲦⲀϤⲦⲞϢϤ ϨⲘ ⲠⲈϤϨⲎⲦ ϨⲚ ⲞⲨⲖⲨⲠⲎ ⲀⲚ ⲎϨⲚ ⲞⲨϨⲦⲞⲢ. ⲞⲨⲢⲈϤϮ ⲄⲀⲢ ⲈϤⲢⲞⲞⲨⲦ ⲠⲈⲦⲈⲢⲈ ⲠⲚⲞⲨⲦⲈ ⲘⲈ ⲘⲘⲞϤ. ");
INSERT INTO copshc_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ⲞⲨⲚ ϬⲞⲘ ⲆⲈ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲀϢⲈ ϨⲘⲞⲦ ⲚⲒⲘ ⲈϨⲞⲨⲚ ⲈⲢⲰⲦⲚ. ϪⲈⲔⲀⲀⲤ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲚⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲈⲨⲚⲦⲎⲦⲚ ⲘⲘⲀⲨ ⲘⲠⲈⲦⲚⲢⲰϢⲈ ⲦⲎⲢϤ. ⲚⲦⲈⲦⲚ ⲢϨⲞⲨⲞ ⲈϨⲞⲨⲚ ⲈϨⲰⲂ ⲚⲒⲘ ⲚⲀⲄⲀⲐⲞⲚ. ");
INSERT INTO copshc_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ⲔⲀⲦⲀ ⲐⲈ ⲈⲦⲤⲎϨ ϪⲈ ⲀϤϪⲰⲰⲢⲈ ⲈⲂⲞⲖ. ⲀϤϮ ⲚⲚϨⲎⲔⲈ. ⲦⲈϤⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ ϢⲞⲞⲠ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ⲠⲈⲦϮ ⲆⲈ ⲘⲠⲈϬⲢⲞϬ ⲘⲠⲈⲦϪⲞ ⲘⲚ ⲞⲨⲞⲈⲒⲔ ⲈⲞⲨⲞⲘϤ ϤⲚⲀϮ ⲀⲨⲰ ⲚϤⲦⲀϢⲞ ⲘⲠⲈⲦⲚϪⲞ ⲚϤⲀⲨⲜⲀⲚⲈ ⲚⲚⲄⲈⲚⲎⲘⲀ ⲚⲦⲈⲦⲚ ⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ");
INSERT INTO copshc_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ⲈⲦⲈⲦⲚⲞ ⲚⲢⲘⲘⲀⲞ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲈϨⲞⲨⲚ ⲈⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ ⲚⲒⲘ. ⲦⲀⲒ ⲈⲦⲢϨⲰⲂ ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲚ ⲈⲨϢⲠϨⲘⲞⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ϪⲈ ⲦⲆⲒⲀⲔⲞⲚⲒⲀ ⲘⲠⲈⲒϢⲘϢⲈ ⲚⲈⲤϢⲰⲠⲈ ⲘⲘⲀⲦⲈ ⲀⲚ ⲈⲤϪⲰⲔ ⲈⲂⲞⲖ ⲚⲚⲈϬⲢⲰϨ ⲚⲚⲈⲦⲞⲨⲀⲀⲂ. ⲀⲖⲖⲀ ⲈⲤⲢⲠⲔⲈⲢϨⲞⲞⲨ ϨⲒⲦⲚ ϨⲀϨ ⲚϢⲠϨⲘⲞⲦ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ");
INSERT INTO copshc_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲞⲞⲦⲤ ⲚⲦⲆⲞⲔⲒⲘⲎ ⲚⲦⲈⲈⲒⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲚϮⲈⲞⲞⲨ ⲘⲠⲚⲞⲨⲦⲈ ⲈϪⲚ ⲐⲨⲠⲞⲦⲀⲄⲎ ⲚⲦⲈⲦⲚ ϨⲞⲘⲞⲖⲞⲄⲒⲀ ⲈϨⲞⲨⲚ ⲈⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲚ ⲦⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ ⲚⲦⲔⲞⲒⲚⲰⲚⲒⲀ ⲈϨⲞⲨⲚ ⲈⲢⲞⲞⲨ. ⲘⲚ ⲞⲨⲞⲚ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ⲘⲚ ⲠⲈⲨⲤⲞⲠⲤ ϨⲀⲢⲰⲦⲚ. ⲈⲨⲞⲨⲈ ϢⲦⲎⲨⲦⲚ ⲈⲦⲂⲈ ⲦⲈⲬⲀⲢⲒⲤ ⲘⲠⲚⲞⲨⲦⲈ ⲈⲦⲚⲀϢⲰⲤ ⲈϪⲚ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ⲠⲈϨⲘⲞⲦ ⲘⲠⲚⲞⲨⲦⲈ ϢⲎⲠ ⲈϨⲢⲀⲒ ⲈϪⲚ ⲦⲈϤⲆⲰⲢⲈⲀ ⲈⲦⲈⲚⲦⲚⲚⲀϢϪⲞⲞⲤ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ⲀⲚⲞⲔ ⲆⲈ ⲠⲀⲨⲖⲞⲤ ϮⲠⲀⲢⲀⲔⲀⲖⲈⲒ ⲘⲘⲰⲦⲚ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲦⲘⲚⲦⲢⲘⲢⲀϢ ⲘⲚ ⲦⲘⲚⲦϨⲀⲔ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ⲠⲀⲒ ⲈⲒϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ⲘⲈⲚ ϮⲐⲂⲂⲒⲎⲨ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ. ⲈⲈⲒⲦⲎⲔ ⲆⲈ ⲚϨⲎⲦ ⲘⲘⲰⲦⲚ ⲈⲚϮϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ϮⲤⲞⲠⲤ ⲆⲈ ⲈⲦⲢⲀϢⲰⲠⲈ ⲈⲒⲦⲎⲔ ⲚϨⲎⲦ ⲈⲚϮϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲚ. ϨⲘ ⲠⲚⲀϨⲦⲈ ⲈϮⲘⲈⲈⲨⲈ ϪⲈ ⲦⲈⲦⲚⲦⲞⲖⲘⲀ ⲈϪⲚ ϨⲞⲒⲚⲈ. ⲚⲀⲒ ⲈⲦⲘⲈⲈⲨⲈ ⲈⲢⲞⲚ ϨⲰⲤ ⲈⲚⲘⲞⲞϢⲈ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ⲈⲚⲘⲞⲞϢⲈ ⲄⲀⲢ ϨⲚ ⲦⲤⲀⲢⲜ. ⲚⲚⲈⲚϨⲎⲔ ⲀⲚ ⲔⲀⲦⲀⲤ ⲀⲢⲜ. ");
INSERT INTO copshc_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ⲚϨⲞⲠⲖⲞⲚ ⲄⲀⲢ ⲚⲦⲈⲚⲘⲚⲦⲘⲀⲦⲞⲒ ⲚϨⲈⲚⲤⲀⲢⲔⲒⲔⲞⲚ ⲀⲚ ⲚⲈ. ⲀⲖⲖⲀ ϨⲈⲚϬⲞⲘ ⲚⲈ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ⲈⲨϢⲞⲞⲠ ⲈⲨϢⲞⲢϢⲢ ⲚⲚⲈⲦⲦⲀϪⲢⲎⲨ ⲈⲚϢⲞⲢϢⲢ ⲚⲘⲘⲈⲈⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ⲀⲨⲰ ϪⲒⲤⲈ ⲚⲒⲘ ⲈⲦⲦⲰⲞⲨⲚ ⲈϨⲢⲀⲒ ⲈϪⲘⲠⲤⲞⲞⲨⲚ ⲘⲠⲚⲞⲨⲦⲈ. ⲈⲚⲤⲰⲔ ⲚϨⲎⲦ ⲚⲒⲘ ⲈⲦⲘⲚⲦⲤⲦⲘⲎⲦ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ");
INSERT INTO copshc_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ⲀⲨⲰ ⲈⲚⲤⲂⲦⲰⲦ ⲈϪⲒ ⲘⲠⲈⲔⲂⲀ ⲘⲘⲚⲦⲀⲦⲤⲰⲦⲘ ⲚⲒⲘ. ⲈⲤϢⲀⲚϪⲰⲔ ⲈⲂⲞⲖ ⲚϬⲒ ⲦⲈⲦⲚⲘⲚⲦⲢⲈϤⲤⲰⲦⲘ. ");
INSERT INTO copshc_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ϬⲰϢⲦ ⲈⲚⲈⲦⲘⲠⲈⲦⲚⲘⲦⲞ ⲈⲂⲞⲖ ⲠⲈⲦⲘⲈⲈⲨⲈ ⲈⲢⲞϤ ϪⲈ ⲀⲚⲄ ⲠⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲘⲀⲢⲈϤⲘⲈⲈⲨⲈ ⲞⲚ ⲈⲠⲀⲒ ⲚϨⲎⲦϤ ϪⲈ ⲔⲀⲦⲀ ⲐⲈ ⲈⲚⲦϤ ⲠⲀ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲀⲚⲞⲚ ⲠⲰϤ ϨⲰⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ⲈⲈⲒϢⲀⲚϢⲞⲨϢⲞⲨ ⲄⲀⲢ ⲘⲘⲞⲒ ⲈⲠⲈϨⲞⲨⲞ ⲈⲦⲂⲈ ⲦⲈⲚⲈⲜⲞⲨⲤⲒⲀ ⲦⲀⲒ ⲈⲚⲦⲀ ⲠϪⲞⲈⲒⲤ ⲦⲀⲀⲤ ⲈⲠⲈⲦⲚⲔⲰⲦ ⲀⲨⲰ ⲈⲠⲈⲦⲚϢⲞⲢϢⲢ ⲀⲚ. ⲚϮⲚⲀϪⲒ ϢⲒⲠⲈ ⲀⲚ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ϪⲈⲔⲀⲀⲤ ⲆⲈ ⲚⲚⲈⲔϨⲈ ⲈⲢⲞⲤ ⲈϢϪⲈ ⲈⲒⲐⲢϢⲞ ⲘⲘⲰⲦⲚ ϨⲒⲦⲚ ⲚⲈⲠⲒⲤⲦⲞⲖⲎ. ");
INSERT INTO copshc_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ϪⲈ ⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲈⲚ ⲠⲈϪⲀϤ ϨⲞⲢϢ ⲀⲨⲰ ⲤⲈϬⲘϬⲞⲘ ⲦⲠⲀⲢϨⲞⲨⲤⲒⲀ ⲆⲈ ⲘⲠⲈϤⲤⲰⲘⲀ ϬⲞⲞⲂ ⲀⲨⲰ ⲠⲈϤϢⲀϪⲈ ⲤⲞϢϤ. ");
INSERT INTO copshc_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ⲘⲀⲢⲈ ⲠⲀⲒ ϬⲈ ⲘⲈⲈⲨⲈ ⲈⲠⲀⲒ ϪⲈ ⲚⲐⲈ ⲈⲦⲚⲞ ⲘⲘⲞⲤ ϨⲘ ⲠⲈⲚϢⲀϪⲈ ϨⲒⲦⲚ ⲚⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲚϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ⲀⲚ. ⲀⲚϨⲈⲚⲦⲈⲈⲒⲘⲒⲚⲈ ⲞⲚ ⲈⲚϨⲀⲦⲈ ⲦⲎⲨⲦⲚ ϨⲘ ⲠϨⲰⲂ. ");
INSERT INTO copshc_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ⲚⲦⲚⲦⲞⲖⲘⲀ ⲄⲀⲢ ⲀⲚ ⲈⲔⲢⲒⲚⲈ ⲘⲘⲞⲚ ⲎⲈϢⲀϢⲚ ⲘⲚ ϨⲞⲒⲚⲈ ⲚⲀⲒ ⲈⲦⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞⲞⲨ ⲞⲨⲀⲀⲦⲞⲨ ⲀⲖⲖⲀ ⲚⲦⲞⲞⲨ ϨⲢⲀⲒ ⲚϨⲎⲦⲞⲨ ⲈⲨⲰⲠ ⲘⲘⲞⲞⲨ ⲀⲨⲰ ⲈⲨϢⲰϢ ⲘⲘⲞⲞⲨ ⲚⲘⲘⲀⲨ ⲈⲚⲤⲈⲚⲞⲒ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ⲀⲚⲞⲚ ⲆⲈ ⲚⲚⲈⲚϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ⲀⲚ ⲠⲂⲞⲖ ⲘⲠϢⲒ. ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲠϢⲒ ⲘⲠⲔⲀⲚⲰⲚ ⲈⲚⲦⲀ ⲠⲚⲞⲨⲦⲈ ⲦⲞϢϤ ⲚⲀⲚ ⲈⲦⲢⲈⲚⲠⲰϨ ϢⲀ ⲞⲨϢⲒ ϢⲀⲢⲰⲦⲚ ϨⲰⲦ ⲦⲎⲨⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ⲚⲦⲀⲚⲢⲐⲈ ⲄⲀⲢ ⲀⲚ ⲚⲚⲈⲦⲈⲚⲤⲈⲠⲎϨ ⲀⲚ ϢⲀⲢⲰⲦⲚ. ⲀⲚⲠⲞⲢϢⲚ ⲈⲂⲞⲖ. ⲀⲚⲠⲰϨ ⲄⲀⲢ ϢⲀⲢⲰⲦⲚ ϨⲘ ⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ⲚⲚⲈⲚϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ⲀⲚ ⲠⲂⲞⲖ ⲘⲠϢⲒ ⲎϨⲚ ϨⲈⲚϨⲒⲤⲈ ⲈⲚⲚⲞⲨⲚ ⲀⲚ ⲚⲈ ⲈⲨⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲈⲤϢⲀⲚⲀⲨⲜⲀⲚⲈ ⲚϬⲒ ⲦⲈⲦⲚⲠⲒⲤⲦⲒⲤ ⲈⲦⲢⲈⲚⲀⲒⲀⲈⲒ ⲚϨⲎⲦ ⲦⲎⲨⲦⲚ ⲔⲀⲦⲀ ⲠⲈⲚⲔⲀⲚⲰⲚ ⲈⲨϨⲞⲨⲞ ");
INSERT INTO copshc_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ⲈⲦⲢⲈⲚⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲚⲈⲦⲠⲒⲤⲀ ⲘⲘⲰⲦⲚ ϨⲚ ⲞⲨⲔⲀⲚⲰⲚ ⲀⲚ ⲈⲘⲠⲰⲚ ⲀⲚ ⲠⲈ. ⲈⲦⲢⲈⲚϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ϨⲚ ⲚⲈⲦⲤⲂⲦⲰⲦ. ");
INSERT INTO copshc_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ⲠⲈⲦϢⲞⲨϢⲞⲨ ⲆⲈ ⲘⲘⲞϤ ⲘⲀⲢⲈϤϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϨⲘ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ⲘⲠⲈⲦⲚⲀⲤⲨⲚϨⲒⲤⲦⲀ ⲄⲀⲢ ⲘⲘⲞϤ ⲀⲚ ⲘⲀⲨⲀⲀϤ ⲠⲈ ⲠⲤⲰⲦⲠ. ⲀⲖⲖⲀ ⲠⲈⲦⲈⲢⲈ ⲠϪⲞⲈⲒⲤ ⲚⲀⲤⲨⲚϨⲒⲤⲦⲀ ⲘⲘⲞϤ ⲠⲈ. ");
INSERT INTO copshc_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ⲚⲀⲚⲞⲨⲤ ⲈⲚⲈⲦⲈⲦⲚⲀⲀⲚⲈⲬⲈ ⲘⲘⲞⲒ ⲚⲞⲨⲔⲞⲨⲒ ⲘⲘⲚⲦⲀⲐⲎⲦ. ⲀⲖⲖⲀ ⲦⲈⲦⲚⲀⲚⲈⲬⲈ. ");
INSERT INTO copshc_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ϮⲔⲰϨ ⲄⲀⲢ ⲈⲢⲰⲦⲚ ⲚⲞⲨⲔⲰϨ ⲚⲦⲈ ⲠⲚⲞⲨⲦⲈ. ⲀⲒⲤⲂⲦⲰⲦ ⲄⲀⲢ ⲈⲠⲀⲢϨⲒⲤⲦⲀ ⲘⲘⲰⲦⲚ ⲚⲞⲨⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲤⲞⲨⲀⲀⲂ. ⲚⲞⲨϨⲀⲒ ⲚⲞⲨⲰⲦ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ϮⲢϨⲞⲦⲈ ⲆⲈ ϪⲈ ⲘⲎⲠⲞⲦⲈ ⲚⲐⲈ ⲚⲦⲀ ⲠϨⲞϤ ⲈⲜⲀⲠⲀⲦⲀ ⲚⲈⲨϨⲀ ϨⲚ ⲦⲈϤⲠⲀⲚⲞⲨⲢⲄⲒⲀ ⲚⲤⲈⲦⲀⲔⲞ ⲚϬⲒ ⲚⲈⲦⲚϨⲎⲦ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲚⲦϨⲀⲠⲖⲞⲨⲤ ⲘⲚ ⲠⲦⲂⲂⲞ ⲈⲦϪⲒ ⲈϨⲞⲨⲚ ⲈⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ⲈϢϪⲈ ⲠⲈⲦⲚⲎⲨ ⲄⲀⲢ ⲚⲀⲦⲀϢⲈⲞⲈⲒϢ ⲚⲎⲦⲚ ⲚⲔⲈⲒⲎⲤⲞⲨⲤ ⲈⲘⲠⲈⲚⲦⲀϢⲈⲞⲈⲒϢ ⲘⲘⲞϤ. ⲎⲦⲈⲦⲚⲀϪⲒ ⲔⲈⲠⲚⲈⲨⲘⲀ ⲈⲘⲠⲈⲦⲚϪⲒⲦϤ ⲎⲔⲈⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲈⲘⲠⲈⲦⲚϢⲞⲠϤ ⲈⲢⲰⲦⲚ. ⲈⲒⲈ ⲔⲀⲖⲰⲤ ⲦⲈⲦⲚⲀⲚⲈⲬⲈ. ");
INSERT INTO copshc_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ϮⲘⲈⲈⲨⲈ ⲄⲀⲢ ϪⲈ ⲘⲠⲒϢⲰⲰⲦ ⲚⲖⲀⲀⲨ ⲠⲀⲢⲀ ⲚⲚⲞϬ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ⲈϢϪⲈ ⲀⲚⲄ ⲞⲨϨⲒⲆⲒⲰⲦⲎⲤ ⲆⲈ ϨⲘ ⲠϢⲀϪⲈ. ⲀⲖⲖⲀ ϨⲘ ⲠⲤⲞⲞⲨⲚ ⲀⲚ. ⲀⲖⲖⲀ ϨⲚ ⲞⲨⲞⲈⲒϢ ⲚⲒⲘ ⲀⲚⲞⲨⲞⲚϨⲚ ⲈⲢⲰⲦⲚ ϨⲚ ϨⲰⲂ ⲚⲒⲘ. ");
INSERT INTO copshc_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ⲘⲎ ⲞⲨⲚⲞⲂⲈ ⲠⲈⲚⲦⲀⲒⲀⲀϤ ⲈⲀⲒⲐⲂⲂⲒⲞⲒ ϪⲈⲔⲀⲀⲤ ⲚⲦⲰⲦⲚ ⲈⲦⲈⲦⲚⲈϪⲒⲤⲈ. ϪⲈ ⲀⲒⲈⲨⲀⲄⲄⲈⲖⲒⲌⲈ ⲚⲎⲦⲚ ⲘⲠⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲚⲞⲨⲦⲈ ⲚϪⲒⲚϪⲎ. ");
INSERT INTO copshc_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ⲀⲒⲤⲨⲖⲀ ⲚϨⲈⲚⲔⲈⲈⲔⲔⲖⲎⲤⲒⲀ. ⲀⲒϪⲒ ⲘⲠⲀⲞⲮⲰⲚⲒⲞⲚ ⲈⲈⲒⲆⲒⲀⲔⲞⲚⲒ ⲚⲎⲦⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ⲀⲨⲰ ⲚⲦⲈⲢⲒϢⲰⲰⲦ ⲈⲈⲒϨⲀⲦⲚ ⲦⲎⲨⲦⲚ ⲘⲠⲒⲞⲨⲈϨ ϨⲒⲤⲈ ⲈⲖⲀⲀⲨ ⲠⲀϢⲰⲰⲦ ⲄⲀⲢ ⲀⲚⲈⲤⲚⲎⲨ ϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲦⲈⲢⲞⲨⲈⲒ ⲈⲂⲞⲖ ϨⲚ ⲦⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲀⲨⲰ ϨⲚ ϨⲰⲂ ⲚⲒⲘ ⲀⲒϨⲀⲢⲈϨ ⲈⲢⲞⲒ ⲈⲦⲘϨⲢⲞϢ ⲈⲢⲰⲦⲚ ⲀⲨⲰ ⲞⲚ ϮⲚⲀϨⲀⲢⲈϨ. ");
INSERT INTO copshc_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ⲞⲨⲚ ⲞⲨⲘⲈ ⲚⲦⲈ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚϨⲎⲦ. ϪⲈ ⲘⲠⲈⲒϢⲞⲨϢⲞⲨ ⲚⲀⲰϪⲚ ⲀⲚ ⲈϨⲞⲨⲚ ⲈⲢⲞⲒ ϨⲚ ⲚⲈⲔⲖⲒⲘⲀ ⲚⲦⲀⲬⲀⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ⲈⲦⲂⲈ ⲞⲨ ϪⲈ ϮⲘⲈ ⲘⲘⲰⲦⲚ ⲀⲚ. ⲠⲚⲞⲨⲦⲈ ⲠⲈⲦⲤⲞⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ⲠⲈϮⲈⲒⲢⲈ ⲆⲈ ⲘⲘⲞϤ ϮⲚⲀⲀⲀϤ ⲞⲚ. ϪⲈⲔⲀⲀⲤ ⲈⲒⲈϬⲰϪⲈ ⲈⲂⲞⲖ ⲚⲦⲀⲪⲞⲢⲘⲎ ⲚⲚⲈⲦⲞⲨⲈϢⲀⲪⲞⲢⲘⲎ. ϪⲈ ⲈⲨⲈϨⲈ ⲈⲢⲞⲞⲨ ϨⲘ ⲠⲈⲦⲞⲨϢⲞⲨϢⲞⲨ ⲘⲘⲞⲞⲨ ⲚϨⲎⲦϤ ⲚⲦⲈⲚϨⲈ ϨⲰⲰⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ⲚⲀⲒ ⲄⲀⲢ ⲚⲦⲈⲈⲒⲘⲒⲚⲈ ϨⲈⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲚⲞⲨϪ ⲚⲈ. ϨⲈⲚⲈⲢⲄⲀⲦⲎⲤ ⲚⲔⲢⲞϤ ⲚⲈ. ⲈⲨϪⲒϨⲢⲂ ϨⲰⲤ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copshc_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ⲀⲨⲰ ⲚⲞⲨϢⲠⲎⲢⲈ ⲀⲚ ⲦⲈ. ⲚⲦⲞϤ ⲄⲀⲢ ⲠⲤⲀⲦⲀⲚⲀⲤ ϢⲀϤϪⲒϨⲢⲂ ϨⲰⲤ ⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈ ⲠⲞⲨⲞⲈⲒⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ⲚⲞⲨⲚⲞϬ ⲀⲚ ϬⲈ ⲠⲈ. ⲈϢϪⲈ ⲚⲈϤⲔⲈⲆⲒⲀⲔⲞⲚⲞⲤ ϪⲒϨⲢⲂ ϨⲰⲤ ⲆⲒⲀⲔⲞⲚⲞⲤ ⲚⲦⲈ ⲦⲆⲒⲔⲀⲒⲞⲤⲨⲚⲎ. ⲚⲀⲒ ⲈⲢⲈ ⲦⲈⲨϨⲀⲎ ⲚⲀϢⲰⲠⲈ ⲔⲀⲦⲀ ⲚⲈⲨϨⲂⲎⲨⲈ. ");
INSERT INTO copshc_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","ϮⲚⲀϪⲞⲞⲤ ⲞⲚ ⲘⲠⲢⲦⲢⲈ ⲞⲨⲀ ⲘⲈⲈⲨⲈ ⲈⲢⲞⲒ ϪⲈ ⲀⲚⲄ ⲞⲨⲀⲐⲎⲦ. ⲈϢϪⲈ ⲘⲘⲞⲚ ⲔⲀⲚ ϢⲞⲠⲦ ⲈⲢⲰⲦⲚ ϨⲰⲤ ⲀⲐⲎⲦ. ϪⲈⲔⲀⲀⲤ ⲈⲒⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲒ ⲚⲞⲨϢⲎⲘ. ");
INSERT INTO copshc_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲈⲒϪⲰ ⲘⲘⲞϤ ⲀⲚ ⲔⲀⲦⲀ ⲠϪⲞⲈⲒⲤ. ⲀⲖⲖⲀ ϨⲰⲤ ϨⲚ ⲞⲨⲘⲚⲦⲀⲐⲎⲦ ϨⲘ ⲠⲦⲀϪⲢⲞ ⲘⲠϢⲞⲨϢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲚ ϨⲀϨ ϢⲞⲨϢⲞⲨ ⲘⲘⲞⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ϮⲚⲀϢⲞⲨϢⲞⲨ ϨⲰ ⲘⲘⲞⲒ. ");
INSERT INTO copshc_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ⲦⲈⲦⲚⲀⲚⲈⲬⲈ ⲄⲀⲢ ⲈϨⲚⲎⲦⲚ ⲚⲚⲒⲀⲐⲎⲦ ⲚⲦⲈⲦⲚ ϨⲈⲚⲤⲀⲂⲈⲈⲨ. ");
INSERT INTO copshc_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ⲦⲈⲦⲚⲀⲚⲈⲬⲈ ⲄⲀⲢ ⲘⲠⲈⲦⲈⲜⲀⲠⲀⲦⲀ ⲘⲘⲰⲦⲚ ⲘⲠⲈⲦⲔⲔⲦⲞ ⲈⲂⲞⲖ ⲘⲠⲈⲦⲈⲒⲢⲈ ⲘⲘⲰⲦⲚ ⲚϨⲘϨⲀⲖ ⲘⲠⲈⲦⲞⲨⲰⲘ ⲘⲠⲈⲦϪⲒ ⲘⲠⲈⲦϪⲒⲤⲈ ⲘⲘⲞϤ ⲘⲠⲈⲦϨⲒⲞⲨⲈ ⲈϨⲞⲨⲚ ⲈⲠⲈⲦⲚϨⲞ. ");
INSERT INTO copshc_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲔⲀⲦⲀⲞⲨⲤⲰϢ. ϨⲰⲤ ϨⲞⲦⲒ ϪⲈ ⲀⲚⲞⲚ ⲀⲚϬⲂⲂⲈ. ϨⲘ ⲠⲈⲦⲈⲢⲈ ⲞⲨⲀ ⲆⲈ ⲚⲀⲦⲞⲖⲘⲀ ⲚϨⲎⲦϤ ϨⲚ ⲞⲨⲘⲚⲦⲀⲐⲎⲦ ⲈⲈⲒϪⲰ ⲘⲘⲞⲤ ϮⲚⲀⲦⲞⲖⲘⲀ ϨⲰ. ");
INSERT INTO copshc_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ϨⲈⲚϨⲈⲂⲢⲀⲒⲞⲤ ⲚⲈ ⲀⲚⲄ ⲞⲨⲀ ϨⲰ. ϨⲈⲚⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲚⲈ ⲀⲚⲄ ⲞⲨⲀ ϨⲰ. ⲠⲈⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀϨⲀⲘ ⲚⲈ ⲀⲚⲞⲔ ϨⲰ. ");
INSERT INTO copshc_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ϨⲈⲚⲆⲒⲀⲔⲞⲚⲞⲤ ⲘⲠⲈⲬⲢⲒⲤⲦⲞⲤ ⲚⲈ ⲈⲈⲒϪⲰ ⲘⲘⲞⲤ ϨⲚ ⲞⲨⲘⲚⲦⲀⲐⲎⲦ ⲀⲚⲄ ⲞⲨⲀ ⲈϨⲞⲨⲈⲢⲞⲞⲨ ϨⲚ ϨⲈⲚϨⲒⲤⲈ ⲈϨⲞⲨⲈⲢⲞⲞⲨ ϨⲚ ϨⲈⲚϢⲦⲈⲔⲰⲞⲨ ⲈϨⲞⲨⲈⲢⲞⲞⲨ ϨⲚ ϨⲈⲚⲤⲎϢⲈ ⲈⲚⲀϢⲰⲞⲨ ϨⲚ ϨⲈⲚⲘⲞⲨ ⲚϨⲀϨ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ⲈⲂⲞⲖ ϨⲒ ⲦⲞⲞⲦⲞⲨ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲀⲒϪⲒ ϨⲘⲈ ⲚⲤⲀϢ ϢⲀⲦⲚⲞⲨⲀ ⲚϮⲞⲨ ⲚⲤⲞⲠ. ");
INSERT INTO copshc_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ⲀⲨϨⲒⲞⲨⲈ ⲈⲢⲞⲒ ⲚⲚϬⲈⲢⲞⲞⲂ ⲚϢⲘⲦⲤⲰⲰⲠ ⲀⲨϨⲒⲰⲚⲈ ⲈⲢⲞⲒ ⲚⲞⲨⲤⲞⲠ ⲀⲠϪⲞⲒ ⲂⲰⲔ ϨⲀⲢⲞⲒ ⲚϢⲘⲦⲤⲰⲰⲠ ⲀⲒⲢⲞⲨϨⲞⲞⲨ ⲘⲚ ⲞⲨⲞⲨϢⲎ ϨⲘ ⲠⲚⲞⲨⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ϨⲚ ϨⲈⲚϨⲒⲎ ⲘⲘⲞⲞϢⲈ ⲚϨⲀϨ ⲚⲤⲞⲠ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲚⲈⲒⲈⲢⲰⲞⲨ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲚⲚⲤⲞⲞⲚⲈ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲈⲂⲞⲖ ϨⲘ ⲠⲀⲄⲈⲚⲞⲤ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲈⲂⲞⲖ ϨⲚ ⲚϨⲈⲐⲚⲞⲤ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲚⲦⲠⲞⲖⲒⲤ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲘⲠϪⲀⲈⲒⲈ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ⲚⲐⲀⲖⲀⲤⲤⲀ ϨⲚ ⲚⲔⲒⲚⲆⲨⲚⲞⲤ ϨⲚ ϨⲈⲚⲤⲚⲎⲨ ⲚⲚⲞⲨϪ. ");
INSERT INTO copshc_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ϨⲚ ⲞⲨϨⲒⲤⲈ ⲘⲚ ⲞⲨⲘⲔⲀϨ ϨⲚ ϨⲈⲚⲞⲨϢⲎ ⲚⲢⲞⲈⲒⲤ ⲚϨⲀϨ ⲚⲤⲞⲠ ϨⲚ ⲞⲨϨⲔⲞ ⲘⲚ ⲞⲨⲈⲒⲂⲈ ϨⲚ ϨⲈⲚⲚⲎⲤⲦⲒⲀ ⲈⲚⲀϢⲰⲞⲨ ϨⲚ ⲞⲨϪⲀϤ ⲘⲚ ⲞⲨⲔⲰⲔⲀϨⲎⲨ. ");
INSERT INTO copshc_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ⲬⲰⲢⲒⲤ ⲚⲈⲦϨⲒⲂⲞⲖ ⲚⲈⲦⲚⲎⲨ ⲈϪⲰⲒ ⲘⲘⲎⲚⲈ ⲚⲢⲞⲞⲨϢ ⲚⲚⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copshc_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ⲚⲒⲘ ⲠⲈⲦϢⲰⲚⲈ ⲈⲚϮϢⲰⲚⲈ ⲀⲚ ⲚⲘⲘⲀϤ. ⲚⲒⲘ ⲠⲈϢⲀϤⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈ. ⲀⲨⲰ ⲀⲚⲞⲔ ⲈⲘⲈⲈⲒϪⲈⲢⲞ. ");
INSERT INTO copshc_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ⲈϢϪⲈ ϢϢⲈ ⲈϢⲞⲨϢⲞⲨ ⲈⲈⲒⲚⲀϢⲞⲨϢⲞⲨ ⲘⲘⲞⲒ ϨⲚ ⲚⲀⲦⲀⲤⲐⲈⲚⲒⲀ. ");
INSERT INTO copshc_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ⲠⲚⲞⲨⲦⲈ ⲀⲨⲰ ⲠⲈⲒⲰⲦ ⲘⲠⲈⲚϪⲞⲈⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲤⲞⲞⲨⲚ ⲠⲈⲦⲤⲘⲀⲘⲀⲀⲦ ϢⲀ ⲚⲒⲈⲚⲈϨ ϪⲈ ⲚϮϪⲒϬⲞⲖ ⲀⲚ. ");
INSERT INTO copshc_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ϪⲈ ϨⲢⲀⲒ ϨⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲀⲠϨⲈⲐⲚⲀⲢⲬⲎⲤ ⲚⲦⲈ ⲀⲢⲈⲦⲀ ⲠⲢⲢⲞ ϨⲀⲢⲈϨ ⲈⲦⲠⲞⲖⲒⲤ ⲚⲆⲀⲘⲀⲤⲔⲞⲤ ⲈϬⲞⲠⲦ. ");
INSERT INTO copshc_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ⲀⲨⲰ ⲈⲂⲞⲖ ϨⲒⲦⲚ ⲞⲨϢⲞⲨϢⲦ ϨⲚ ⲞⲨⲤⲀⲢⲄⲀⲚⲎ. ⲀⲨⲬⲀⲖⲀ ⲘⲘⲞⲒ ⲠⲂⲞⲖ ⲘⲠⲤⲞⲂⲦ. ⲀⲒⲢⲂⲞⲖ ⲈⲚⲈϤϬⲒϪ. ");
INSERT INTO copshc_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ⲈϢϪⲈ ϢϢⲈ ⲈϢⲞⲨϢⲞⲨ ⲚⲤⲢⲚⲞϤⲢⲈ ⲘⲈⲚ ⲀⲚ. ϮⲚⲎⲨ ⲆⲈ ⲈϨⲈⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲚ ⲞⲨϬⲰⲖⲠ ⲈⲂⲞⲖ ⲚⲦⲈ ⲠϪⲞⲈⲒⲤ. ");
INSERT INTO copshc_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ϮⲤⲞⲞⲨⲚ ⲚⲞⲨⲢⲰⲘⲈ ϨⲘ ⲠⲈⲬⲢⲒⲤⲦⲞⲤ ϨⲀⲐⲎ ⲘⲘⲚⲦⲀϤⲦⲈ ⲚⲢⲞⲘⲠⲈ ⲈⲒⲦⲈ ⲈϤϨⲘ ⲠⲤⲰⲘⲀ ⲚϮⲤⲞⲞⲨⲚ ⲀⲚ ⲈⲒⲦⲈ ⲈϤⲘⲠⲂⲞⲖ ⲘⲠⲤⲰⲘⲀ Ⲛ