﻿USE sofia;
DROP TABLE IF EXISTS sofia.copcnt_vpl;
CREATE TABLE copcnt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES copcnt_vpl WRITE;
INSERT INTO copcnt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ⲡ̇ϫⲱⲙ ⳿ⲙⲙⲓⲥⲓ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲀⲃⲣⲁⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ⲁⲃⲣⲁⲁⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ⳿ Ⲓⲥⲁⲁⲕ⳿ Ⲓⲥⲁⲁⲕ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲁⲕⲱⲃ Ⲓⲁⲕⲱⲃ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲟⲩⲇⲁⲥ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ⲓⲟⲩⲇⲁⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲫⲁⲣⲉⲥ ⲛⲉⲙ Ⲍⲁⲣⲁϩ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲑⲁⲙⲁⲣ Ⲫⲁⲣⲉⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲉⲥⲣⲱⲙ Ⲉⲥⲣⲱⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲣⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ⲁ̇ⲣⲁⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲙⲓⲛⲁⲇⲁⲃ Ⲁ̇ⲙⲓⲛⲁⲇⲁⲃ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲛⲁⲥⲥⲱⲛ Ⲛⲁⲥⲥⲱⲛ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲥⲁⲗⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ⲥⲁⲗⲙⲱⲛ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲃⲟⲉⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲣⲏⲭⲁⲃ Ⲃⲟⲉⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱⲃⲏⲇ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲣⲟⲩⲑ Ⲓⲱⲃⲏⲇ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲉⲥⲥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ⲓⲉⲥⲥⲉ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲇⲁⲩⲓⲇ ⳿ⲡⲟⲩⲣⲟ Ⲇⲁⲩⲓⲇ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲥⲟⲗⲟⲙⲱⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲁ Ⲟⲩⲣⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ⲥⲟⲗⲟⲙⲱⲛ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲣⲟⲃⲟⲁⲙ Ⲣⲟⲃⲟⲁⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲃⲓ⳿ⲁ Ⲁ̇ⲃⲓ⳿ⲁ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲥⲁⲫ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ⲁ̇ⲥⲁⲫ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱⲥⲁⲫⲁⲧ Ⲓⲱⲥⲁⲫⲁⲧ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱⲣⲁⲙ Ⲓⲱⲣⲁⲙ ⲇⲉ ⲁϥϫⲫⲉ Ⲟ̇ⲍⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ⲟ̇ⲍⲓⲁⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱ⳿ⲁⲑⲁⲙ Ⲓⲱ⳿ⲁⲑⲁⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲭⲁⲍ Ⲁ̇ⲭⲁⲍ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲉ̇ⲍⲉⲕⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ⲉ̇ⲍⲉⲕⲓⲁⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲙⲁⲛⲁⲥⲥⲏ Ⲙⲁⲛⲁⲥⲥⲏ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲙⲱⲥ Ⲁ̇ⲙⲱⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱⲥⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ⲓⲱⲥⲓⲁⲥ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲉⲭⲟⲛⲓⲁⲥ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ϩⲓ ⲡⲓⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ Ⲃⲁⲃⲩⲗⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ Ⲃⲁⲃⲩⲗⲱⲛ Ⲓⲉⲭⲟⲛⲓⲁⲥ ⲁϥ⳿ϫⲫⲉ Ⲥⲁⲗⲁⲑⲓⲏⲗ Ⲥⲁⲗⲁⲑⲓⲏⲗ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲍⲟⲣⲟⲃⲁⲃⲉⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ⲍⲟⲣⲟⲃⲁⲃⲉⲗ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲃⲓⲟⲩⲇ Ⲁ̇ⲃⲓⲟⲩⲇ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲉ̇ⲗⲓ⳿ⲁⲕⲓⲙ Ⲉ̇ⲗⲓ⳿ⲁⲕⲓⲙ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲍⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ⲁ̇ⲍⲱⲣ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲥⲁⲇⲱⲕ Ⲥⲁⲇⲱⲕ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲁ̇ⲭⲓⲛ Ⲁ̇ⲭⲓⲛ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲉ̇ⲗⲓⲟⲩⲇ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ⲉ̇ⲗⲓⲟⲩⲇ ⲇⲉ ⲁϥϫⲫⲉ Ⲉ̇ⲗⲉ⳿ⲁⲍⲁⲣ Ⲉ̇ⲗⲉ⳿ⲁⲍⲁⲣ ⲇⲉ ⲁϥϫⲫⲉ Ⲙⲁⲧⲑⲁⲛ Ⲙⲁⲧⲑⲁⲛ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲁⲕⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ⲓⲁⲕⲱⲃ ⲇⲉ ⲁϥ⳿ϫⲫⲉ Ⲓⲱⲥⲏⲫ ⳿ⲡϩⲁⲓ ⳿ⲙⲘⲁⲣⲓ⳿ⲁ ⲑⲏ⳿ⲉⲧⲁⲥⲙⲁⲥ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ϫⲱⲟⲩ ⲛⲓⲃⲉⲛ ⲓⲥϫⲉⲛ Ⲁⲃⲣⲁⲁⲙ ϣⲁ Ⲇⲁⲩⲓⲇ ⲓ̅ⲇ̅ ⳿ⲛϫⲱⲟⲩ ⲟⲩⲟϩ ⲓⲥϫⲉⲛ Ⲇⲁⲩⲓⲇ ϣⲁ ⲡⲓⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ Ⲃⲁⲃⲩⲗⲱⲛ ⲓ̅ⲇ̅ ⳿ⲛϫⲱⲟⲩ ⲟⲩⲟϩ ⲓⲥϫⲉⲛ ⲡⲓⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ Ⲃⲁⲃⲩⲗⲱⲛ ϣⲁ Ⲡⲭ̅ⲥ̅ ⲓ̅ⲇ̅ ⳿ⲛϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","⳿ⲡϫⲓⲛⲙⲓⲥⲓ ⲇⲉ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲛⲉ ⲟⲩⲡⲁⲓⲣⲏϯ ⲡⲉ ⳿ⲉⲧⲁⲩⲱⲡ ⳿ⲛⲥⲁ ⲧⲉϥⲙⲁⲩ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛⲒⲱⲥⲏⲫ ⳿ⲙⲡⲁⲧⲟⲩⲥⲟⲩⲉⲛ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲁⲩϫⲉⲙⲥ ⲉⲥ⳿ⲙⲃⲟⲕⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ⲓⲱⲥⲏⲫ ⲇⲉ ⲡⲉⲥϩⲁⲓ ⲛⲉ ⲟⲩ⳿ⲑⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ⲛ⳿ϥⲟⲩⲱϣ ⲁⲛ ⳿ⲉⲁⲓⲥ ⳿ⲛ⳿ⲥⲣⲁϩ ⲁϥⲥⲟϭⲛⲓ ⳿ⲉⲭⲁⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲭⲱⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ⲛⲁⲓ ⲇⲉ ⳿ⲉⲧⲁϥⲙⲟⲕⲙⲉⲕ ⳿ⲉⲣⲱⲟⲩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪̅ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲒⲱⲥⲏⲫ ϧⲉⲛ ⲟⲩⲣⲁⲥⲟⲩ⳿ⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲱⲥⲏⲫ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⳿ⲉϣⲉⲡ Ⲙⲁⲣⲓ⳿ⲁ ⲧⲉⲕ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲣⲟⲕ ⲫⲏ ⲅⲁⲣ ⳿ⲉⲧⲉⲥⲛⲁⲙⲁⲥϥ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ⲉⲥ⳿ⲉⲙⲓⲥⲓ ⲇⲉ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲉⲕ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲑⲟϥ ⲅⲁⲣ ⲉⲑⲛⲁⲛⲟϩⲉⲙ ⳿ⲙⲡⲉϥⲗⲁⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ⲫⲁⲓ ⲇⲉ ⲧⲏⲣϥ ⲁϥϣⲱⲡⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁ Ⲡ⳪ ϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ϯⲡⲁⲣⲑⲉⲛⲟⲥ ⲉⲥ⳿ⲉⲉⲣⲃⲟⲕⲓ ⲟⲩⲟϩ ⲉⲥ⳿ⲉⲙⲓⲥⲓ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲉⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ Ⲉⲙⲙⲁⲛⲟⲩⲏⲗ ⲫⲏ⳿ⲉⲧⲉ ϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ Ⲫϯ ⲛⲉⲙⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲱⲥⲏⲫ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲉⲛⲕⲟⲧ ⲁϥ⳿⳿ⲓⲣⲓ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲁϥ ⲟⲩⲟϩ ⲁϥϣⲉⲡ Ⲙⲁⲣⲓ⳿ⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲥⲟⲩⲱⲛⲥ ϣⲁⲧⲉⲥⲙⲓⲥⲓ ⳿ⲙⲡⲓϣⲏⲣⲓ ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ Ⲓⲏ̅ⲥ̅ ");
INSERT INTO copcnt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁⲩⲙⲁⲥϥ ϧⲉⲛ Ⲃⲏⲑⲗⲉⲉⲙ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲡⲟⲩⲣⲟ ϩⲏⲡⲡⲉ ⲓⲥ ϩⲁⲛⲙⲁⲅⲟⲥ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁ ⲡⲉⲓⲉⲃⲧ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ϫⲉ ⲁϥⲑⲱⲛ ⲫⲏ⳿ⲉⲧⲁⲩⲙⲁⲥϥ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ Ⲁⲛⲛⲁⲩ ⲅⲁⲣ ⳿ⲉⲡⲉϥⲥⲓⲟⲩ ⲥⲁⲡⲉⲓⲉⲃⲧ ⲟⲩⲟϩ ⲁⲛ⳿ⲓ ϫⲉ ⳿ⲛⲧⲉⲛⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⳿ⲡⲟⲩⲣⲟ Ⲏ̇ⲣⲱⲇⲏⲥ ⲁϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⲛⲉⲙ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲧⲏⲣⲥ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲑⲱⲟⲩϯ ⳿ⲛⲛⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲁϥϣⲓⲛⲓ ⳿ⲛⲧⲟⲧⲟⲩ ϫⲉ ⲁⲩⲛⲁⲙⲉⲥ Ⲡⲭ̅ⲥ̅ ⳿ⲛⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ϧⲉⲛ Ⲃⲏⲑⲗⲉⲉⲙ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲡⲁⲓⲣⲏϯ ⲅⲁⲣ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ϫⲉ ⲛⲉⲙ ⳿ⲛⲑⲟ ϩⲱⲓ Ⲃⲏⲑⲗⲉⲉⲙ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲒⲟⲩⲇⲁ ⳿ⲛⲑⲟ ⲟⲩⲕⲟⲩϫⲓ ⲁⲛ ϧⲉⲛ ⲛⲓⲙⲉⲧϩⲏⲅⲉⲙⲱⲛ ⳿ⲛⲧⲉ Ⲓⲟⲩⲇⲁ ⲉϥ⳿ⲉ⳿ⲓ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ⳿ⲛϧⲏϯ ⳿ⲛϫⲉ ⲟⲩϩⲏⲅⲟⲩⲙⲉⲛⲟⲥ ⲫⲏⲉⲑⲛⲁ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲡⲁⲗⲁⲟⲥ Ⲡⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ⲧⲟⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲓⲙⲁⲅⲟⲥ ⳿ⲛⲭⲱⲡ ⲁϥϧⲟⲧϧⲉⲧ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲥⲁ ⲡⲓⲥⲏⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲥⲓⲟⲩ ⳿ⲉⲧⲁϥⲟⲩⲱⲛϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲂⲏⲑⲗⲉⲉⲙ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ϣⲓⲛⲓ ⲁⲕⲣⲓⲃⲱⲥ ⲉⲑⲃⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉⲧⲉ⳿ⲛϫⲉⲙϥ ⲙⲁⲧⲁⲙⲟⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁ⳿ⲓ ϩⲱ ⳿ⲛⲧⲁⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⳿ⲡⲟⲩⲣⲟ ⲁⲩϣⲉⲛⲱⲟⲩ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲓⲥⲓⲟⲩ ⲫⲏ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲥⲁ ⲡⲉⲓⲉⲃⲧ ⲛⲁϥⲙⲟϣⲓ ϧⲁϫⲱⲟⲩ ϣⲁⲧⲉϥ⳿ⲓ ⳿ⲛⲧⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⲭⲏ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲉⲡⲓⲥⲓⲟⲩ ⲁⲩⲣⲁϣⲓ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲁϣⲓ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲡⲓⲏⲓ ⲁⲩⲛⲁⲩ ⳿ⲉⲡⲓ⳿ⲁⲗⲟⲩ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϩⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⲁⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲟⲩⲱⲛ ⳿ⲛⲛⲟⲩ⳿ⲁϩⲱⲣ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛϩⲁⲛⲇⲱⲣⲟⲛ ⲟⲩⲛⲟⲩⲃ ⲛⲉⲙ ⲟⲩⲗⲓⲃⲁⲛⲟⲥ ⲛⲉⲙ ⲟⲩϣⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲁⲙⲱⲟⲩ ϧⲉⲛ ⲟⲩⲣⲁⲥⲟⲩ⳿ⲓ ⳿ⲉ⳿ϣⲧⲉⲙⲕⲟⲧⲟⲩ ϩⲁ Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲕⲉⲙⲱⲓⲧ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲧⲟⲩⲭⲱⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⲇⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲒⲱⲥⲏⲫ ϧⲉⲛ ⲟⲩⲣⲁⲥⲟⲩ⳿ⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⲫⲱⲧ ⳿ⲉⲬⲏⲙⲓ ⲟⲩⲟϩ ϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϣⲁϯϫⲟⲥ ⲛⲁⲕ ⳿ϥⲛⲁⲕⲱϯ ⲅⲁⲣ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲛⲥⲁ ⲡⲓ⳿ⲁⲗⲟⲩ ⳿ⲉⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲧⲱⲛϥ ⲁϥϭⲓ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⳿ⲛϫⲱⲣϩ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲬⲏⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ⳿ⲙⲙⲁⲩ ⲡⲉ ϣⲁ ⳿ⲧϧⲁ⳿ⲉ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁ Ⲡ⳪ ϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓⲙⲟⲩϯ ⳿ⲉⲡⲁϣⲏⲣⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲭⲏ ⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ⲧⲟⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲉⲧⲁϥⲛⲁⲩ ϫⲉ ⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲅⲟⲥ ⲁϥ⳿ⲙⲃⲟⲛ ⳿ⲉⲙⲁϣⲱ ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⲁϥϧⲱⲧⲉⲃ ⳿ⲛ⳿ⲁⲗⲟⲩ ⲛⲓⲃⲉⲛ ⲉⲧϧⲉⲛ Ⲃⲏⲑⲗⲉⲉⲙ ⲛⲉⲙ ϧⲉⲛ ⲛⲉⲥϭⲓ⳿ⲏ ⲧⲏⲣⲟⲩ ⲓⲥϫⲉⲛ ⲣⲟⲙⲡⲓ ⳿ⲥⲛⲟⲩϯ ⲛⲉⲙ ⲥⲁⲡⲉⲥⲏⲧ ⲕⲁⲧⲁ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲁϥϧⲉⲧϧⲱⲧϥ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲙⲁⲅⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ⲧⲟⲧⲉ ⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲒⲉⲣⲉⲙⲓⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ϫⲉ ⲟⲩ⳿ⲥⲙⲏ ⲁⲩⲥⲟⲑⲙⲉⲥ ϧⲉⲛ Ⲣⲁⲙⲁ ⲟⲩⲣⲓⲙⲓ ⲛⲉⲙ ⲟⲩⲛⲉϩⲡⲓ ⳿ⲉⲛⲁϣⲱϥ Ⲣⲁⲭⲏⲗ ⲉⲥⲣⲓⲙⲓ ⳿⳿ⲉⲛⲉⲥϣⲏⲣⲓ ⲟⲩⲟϩ ⲛⲁⲥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ⳿ⲉϯⲛⲟⲙϯ ⲛⲁⲥ ϫⲉ ⳿ⲛⲥⲉϣⲟⲡ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","⳿ⲉⲧⲁϥⲙⲟⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲒⲱⲥⲏⲫ ϧⲉⲛ ⲟⲩⲣⲁⲥⲟⲩ⳿ⲓ ϧⲉⲛ ⲭⲏ ⲙⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ϫⲉ ⲧⲱⲛⲕ ϭⲓ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⲁⲩⲙⲟⲩ ⲅⲁⲣ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲧⲯⲩⲭⲏ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲁϥϭⲓ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ϫⲉ Ⲁⲣⲭⲉⲗⲁⲟⲥ ⲉⲧⲟⲓ ⳿ⲛⲟⲩⲣⲟ ⳿ⲉϯⲒⲟⲩⲇⲉ⳿ⲁ ⳿ⲛ⳿ⲧϣⲉⲃⲓ⳿ⲱ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ ⲡⲉϥⲓⲱⲧ ⲁϥⲉⲣϩⲟϯ ⳿ⲉϣⲉ ⳿ⲉⲙⲁⲩ ⳿ⲉⲧⲁⲩⲧⲁⲙⲟϥ ⲇⲉ ϧⲉⲛ ⲟⲩⲣⲁⲥⲟⲩ⳿ⲓ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲃⲁⲕⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ Ⲛⲁⲍⲁⲣⲉⲑ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲉ ⲉⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ");
INSERT INTO copcnt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲉϥϩⲓⲱⲓϣ ϩⲓ ⳿ⲡϣⲁϥⲉ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲣⲓⲙⲉⲧⲁⲛⲟⲓⲛ ⲁⲥϧⲱⲛⲧ ⲅⲁⲣ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲎ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙⲡⲉⲧⲱϣ ⳿ⲉⲃⲟⲗϩⲓ ⳿ⲡϣⲁϥⲉ ϫⲉ ⲥⲉⲃⲧⲉ ⳿ⲫⲙⲱⲓⲧ ⳿ⲙⲠ⳪ ⲥⲟⲩⲧⲱⲛ ⳿ⲛⲛⲉϥⲙⲁⲛⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","⳿ⲛⲑⲟϥ ⲇⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉ ⲧⲉϥϩⲉⲃⲥⲱ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ϩⲁⲛϥⲱⲓ ⳿ⲛϫ⳿ⲁⲙⲟⲩⲗ ⲧⲉ ⲟⲩⲟϩ ⲛⲁϥⲙⲏⲣ ⳿ⲛⲟⲩⲙⲟϫϧ ⳿ⲛϣⲁⲣ ⳿ⲉϫⲉⲛ ⲧⲉϥϯⲡⲓ ⲧⲉϥ⳿ϧⲣⲉ ⲇⲉ ⲛⲉ ⲟⲩ⳿ϣϫⲉ ⲧⲉ ⲛⲉⲙ ⲟⲩ⳿ⲉⲃⲓ⳿ⲱ ⳿ⲛⲧⲉ ⳿ⲧⲕⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ⲧⲟⲧⲉ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲁ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ ⳿ⲛⲧⲉ ⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ⲟⲩⲟϩ ⲛⲁⲩϭⲓⲱⲙⲥ ⳿ⲛⲧⲟⲧϥ ϧⲉⲛ ⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ⳿ⲛⲓⲁⲣⲟ ⲉⲩⲟⲩⲱⲛϩ ⳿ⲛⲛⲟⲩⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲟⲩⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲉⲩⲛⲏⲟⲩ ⳿ⲉϫⲉⲛ ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲁϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙⲓⲥⲓ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲁϫⲱ ⲛⲓⲙ ⲁϥⲧⲁⲙⲉ ⲑⲏⲛⲟⲩ ⳿ⲉⲫⲱⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓϫⲱⲛⲧ ⲉⲑⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","⳿ⲁⲣⲓⲟⲩ⳿ⲓ ⲟⲩⲛ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛϯⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲙⲉⲩⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉϫⲟⲥ ϫⲉ ⲟⲩⲟⲛ⳿ⲛⲧⲁⲛ ⳿ⲙⲡⲉⲛⲓⲱⲧ Ⲁⲃⲣⲁⲁⲙ ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲪϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲁⲓ⳿ⲱⲛⲓ ⳿ⲉⲧⲟⲩⲛⲟⲥ ϣⲏⲣⲓ ⳿ⲛⲀⲃⲣⲁⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ϩⲏⲇⲏ ⲇⲉ ⲡⲓⲕⲉⲗⲉⲃⲓⲛ ⳿ϥⲭⲏ ϧⲁ ⳿ⲑⲛⲟⲩⲛⲓ ⳿ⲛⲛⲓ⳿ϣϣⲏⲛ ⳿ϣϣⲏⲛ ⲟⲩⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲛ⳿ϥⲛⲁⲉⲛⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲥⲉⲛⲁⲕⲟⲣϫϥ ⳿ⲛⲥⲉϩⲓⲧϥ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⲅⲁⲣ ϯⲱⲙⲥ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⲉⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⲫⲏ ⲇⲉ ⲉⲑⲛⲏⲟⲩ ⲙ⳿ⲉⲛⲉⲛⲥⲱⲓ ⳿ϥϫⲟⲣ ⳿ⲉϩⲟⲧⲉⲣⲟⲓ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ⳿ⲉϥⲁⲓ ⳿ⲙⲡⲉϥⲑⲱⲟⲩ⳿ⲓ ⳿ⲛⲑⲟϥ ⲉϥ⳿ⲉⲉⲙⲥ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲛⲉⲙ ⲟⲩ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ⲫⲏ⳿ⲉⲧⲉ ⲡⲉϥϧⲁⲓ ϧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ϥⲛⲁⲧⲟⲩⲃⲟ ⳿ⲙⲡⲉϥϭⲛⲱⲟⲩ ⲟⲩⲟϩ ⳿ϥⲛⲁⲑⲱⲟⲩϯ ⳿ⲙⲡⲉϥⲥⲟⲩ⳿ⲟ ⳿ⲉϯ⳿ⲁⲡⲟⲑⲏⲕⲏ ⲡⲓⲧⲟϩ ⲇⲉ ⳿ϥⲛⲁⲣⲟⲕϩϥ ϧⲉⲛ ⲟⲩ⳿ⲭⲣⲱⲙ ⳿ⲛⲁⲧϭⲉⲛⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉϫⲉⲛ ⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ϩⲁ Ⲓⲱⲁⲛⲛⲏⲥ ⲉⲑⲣⲉϥϭⲓⲱⲙⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ⲓⲱⲁⲛⲛⲏⲥ ⲇⲉ ⲛⲁϥⲧⲁϩⲛⲟ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲉϭⲓⲱⲙⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ⳿ⲭⲛⲏⲟⲩ ϩⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲭⲁⲥ ϯⲛⲟⲩ ⲡⲁⲓⲣⲏϯ ⲅⲁⲣ ⲡⲉⲧⲥⲉⲙ⳿ⲡϣⲁ ⲛⲁⲛ ⳿ⲉϫⲉⲕ ⲙⲉⲑⲙⲏⲓ ⲛⲓⲃⲉⲛ ⳿ⲉⲃⲟⲗ ⲧⲟⲧⲉ ⲁϥⲭⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","⳿ⲉⲧⲁϥⲱⲙⲥ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲱⲟⲩ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲁⲩⲟⲩⲱⲛ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲫϯ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϭⲣⲟⲙⲡⲓ ⲉϥⲛⲏⲟⲩ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ⲟⲩⲟϩ ⲓⲥ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⳿ⲉⲧⲁⲓϯⲙⲁϯ ⳿ⲛϧⲏⲧϥ ");
INSERT INTO copcnt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ⲧⲟⲧⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲁ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲗϥ ⳿ⲉ⳿ⲡϣⲁϥⲉ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⳿ⲛⲙ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲙ̅ ⳿ⲛ⳿ⲉϫⲱⲣϩ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲁϥ⳿ϩⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧϭⲱⲛⲧ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ ⳿ⲁϫⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲛⲁⲓ⳿ⲱⲛⲓ ⲉⲣⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲛⲁⲣⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁⲱⲛϧ ⳿ⲉⲱⲓⲕ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲉϫⲉⲛ ⲥⲁϫⲓ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ⲧⲟⲧⲉ ⲁϥⲟⲗϥ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⳿ⲉϯⲃⲁⲕⲓ ⲉⲑⲟⲩⲁⲃ ⲟⲩⲟϩ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ⳿ⲉϫⲉⲛ ⳿ⲡⲧⲉⲛϩ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ ϩⲓⲧⲕ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ⲧⲁⲓ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⳿ϥⲛⲁϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲉⲑⲃⲏⲧⲕ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϥⲓⲧⲕ ϩⲓϫⲉⲛ ⲛⲟⲩϫⲓϫ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲧⲉⲕϭⲓϭⲣⲟⲡ ⳿ⲉⲟⲩ⳿ⲱⲛⲓ ⳿ⲛⲧⲉⲕϭ ⲁⲗⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲡⲁⲗⲓⲛ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⳿ⲛⲛⲉⲕⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲠ⳪ ⲡⲉⲕⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥⲟⲗϥ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⳿ⲉϫⲉⲛ ⲟⲩⲧⲱⲟⲩ ⲉϥϭⲟⲥⲓ ⳿ⲉⲙⲁϣⲱ ⲟⲩⲟϩ ⲁϥⲧⲁⲙⲟϥ ⳿ⲉⲛⲓⲙⲉⲧⲟⲩⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲉⲙ ⲡⲟⲩ⳿ⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ϯⲛⲁⲧⲏⲓⲧⲟⲩ ⲛⲁⲕ ⲁⲕϣⲁⲛϩⲓⲧⲕ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛⲧⲉⲕⲟⲩⲱϣⲧ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ ⲡⲉⲧⲉⲕⲉⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲡⲉⲧⲉⲕⲉϣⲉⲙϣⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ⲧⲟⲧⲉ ⲁϥⲭⲁϥ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲟⲩⲟϩ ⲓⲥ ϩⲁⲛⲁⲅⲅⲉⲗⲟⲥ ⲁⲩ⳿ⲓ ⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲩϯ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ⲟⲩⲟϩ ⲁϥⲭⲱ ⳿ⲛⲚⲁⲍⲁⲣⲉⲑ ⳿ⲛⲥⲱϥ ⲁϥ⳿ⲓ ⲁϥϣⲱⲡⲓ ϧⲉⲛ Ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲑⲏⲉⲧ ϩⲓ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ϧⲉⲛ ⲛⲓϭⲓ⳿ⲏ ⳿ⲛⲧⲉ Ⲍⲁⲃⲟⲩⲗⲱⲛ ⲛⲉⲙ Ⲛⲉⲫⲑⲁⲗⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲎ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ϫⲉ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲌⲁⲃⲟⲩⲗⲱⲛ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲚⲉⲫⲑⲁⲗⲓⲙ ⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ ⳿ⲫⲓⲟⲙ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ⲡⲓⲗⲁⲟⲥ ⲉⲧϩⲉⲙⲥⲓ ϧⲉⲛ ⳿ⲡⲭⲁⲕⲓ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲛⲓϣϯ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⲛⲏⲉⲧϩⲉⲙⲥⲓ ϧⲉⲛ ⳿ⲧⲭⲱⲣⲁ ⲛⲉⲙ ⳿ⲧϧⲏⲓⲃⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲟⲩⲟⲩⲱⲓⲛⲓ ⲁϥϣⲁⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ⲓⲥϫⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛϩⲓⲱⲓϣ ⲛⲉⲙ ⳿ⲉϫⲟⲥ ϫⲉ ⳿ⲁⲣⲓⲙⲉⲧⲁⲛⲟⲓⲛ ⲁⲥϧⲱⲛⲧ ⲅⲁⲣ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ⲉϥⲙⲟϣⲓ ⲇⲉ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲁϥⲛⲁⲩ ⳿ⲉⲥⲟⲛ ⲃ̅ Ⲥⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ⲡⲉϥⲥⲟⲛ ⲉⲩϩⲓ ⳿ϣⲛⲉ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲛⲉ ϩⲁⲛⲟⲩ⳿ⲟϩⲓ ⲅⲁⲣ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⳿ⲛⲧⲁⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛⲟⲩ⳿ⲟϩⲓ ⳿ⲛⲣⲉϥⲧⲁϩⲉ ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲭⲱ ⳿ⲛⲛⲟⲩ⳿ϣⲛⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⳿ⲉ⳿ⲧϩⲏ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥⲛⲁⲩ ⳿ⲉⲕⲉⲥⲟⲛ ⲃ̅ Ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϥⲥⲟⲛ ⲉⲩϩⲓ ⲡⲓϫⲟⲓ ⲛⲉⲙ Ⲍⲉⲃⲉⲇⲉⲟⲥ ⲡⲟⲩⲓⲱⲧ ⲉⲩⲥⲟⲃϯ ⳿ⲛⲛⲟⲩ⳿ϣⲛⲏⲟⲩ ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲭⲱ ⳿ⲙⲡⲓϫⲟⲓ ⲛⲉⲙ Ⲍⲉⲃⲉⲇⲉⲟⲥ ⲡⲟⲩⲓⲱⲧ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲧⲏⲣⲥ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲉϥϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲉϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϣⲱⲛⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲓⲁⲃⲓ ⲛⲓⲃⲉⲛ ⲉⲧϧⲉⲛ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ⲟⲩⲟϩ ⳿ⲁ ⲧⲉϥ⳿ⲥⲙⲏ ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲤⲩⲣⲓ⳿ⲁ ⲧⲏⲣⲥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϩⲉⲙⲕⲏⲟⲩⲧ ϧⲉⲛ ⲛⲟⲩϣⲱⲛⲓ ⲛⲉⲙ ⲟⲩ⳿ⲙⲕⲁⲩϩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲣⲏϯ ⲛⲏ⳿ⲉⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲛⲉⲙⲱⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲧⲟⲓ ⳿ⲙⲡⲉⲣⲙⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲛⲉⲙ ϯⲙⲏϯ ⳿ⲙⲃⲁⲕⲓ ⲛⲉⲙ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ϩⲓⲙⲏⲣ ⲙⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ");
INSERT INTO copcnt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲛⲓⲙⲏϣ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲙⲥⲓ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲩⲱⲛ ⳿ⲛⲣⲱϥ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ϫⲉ ⲑⲱⲟⲩ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲣϩⲏⲃⲓ ϯⲛⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲧⲟⲩⲛⲁϯϩⲟ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲣⲉⲙⲣⲁⲩϣ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲑⲛⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲙⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏⲉⲧϩⲟⲕⲉⲣ ⲛⲉⲙ ⲛⲏⲉⲧ⳿ⲟⲃⲓ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲑⲛⲁⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲛⲁⲏⲧ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲧⲟⲩⲛⲁⲛⲁⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏⲉⲑⲟⲩⲁⲃ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲑⲛⲁⲛⲁⲩ ⳿ⲉⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲣⲉϥⲉⲣϩⲓⲣⲏⲛⲏ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲧⲟⲩⲛ⳿ⲁⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩϭⲟϫⲓ ⳿ⲛⲥⲱⲟⲩ ⲉⲑⲃⲉ ϯⲙⲉⲑⲙⲏⲓ ϫⲉ ⲑⲱⲟⲩ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","⳿ⲱⲟⲩ⳿ⲛⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉϣⲱⲡ ⲁⲩϣⲁⲛϭⲟϫⲓ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲥⲉϣⲉϣ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲥⲉϫⲉ ⲡⲉⲧϩⲱⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⲉⲩϫⲉ ⲙⲉⲑⲛⲟⲩϫ ⳿ⲉⲣⲱⲧⲉⲛ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ⲣⲁϣⲓ ⲟⲩⲟϩ ⲑⲉⲗⲏⲗ ϫⲉ ⲡⲉⲧⲉⲛⲃⲉⲭⲉ ⲟⲩⲛⲓϣϯ ⲡⲉ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲡⲁⲓⲣⲏϯ ⲅⲁⲣ ⲁⲩϭⲟϫⲓ ⳿ⲛⲥⲁ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉⲛⲁⲩϧⲁϫⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","⳿ⲛⲑⲱⲧⲉⲛ ⲡⲉ ⳿ⲡ⳿ϩⲙⲟⲩ ⳿ⲙⲡⲓⲕⲁϩⲓ ⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲩ ⲗⲱϥ ⲁⲩⲛⲁⲙⲟⲗϩϥ ⳿ⲛⲟⲩ ⳿ⲙⲡⲁϥ⳿ϣϫⲉⲙϫⲟⲙ ϫⲉ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲛⲥⲉϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲥⲉϩⲱⲙⲓ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","⳿ⲛⲑⲱⲧⲉⲛ ⲡⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩⲃⲁⲕⲓ ⲭⲱⲡ ⲉⲥⲭⲏ ϩⲓϫⲉⲛ ⲟⲩⲧⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭⲉⲣⲉ ⲟⲩϧⲏⲃⲥ ⳿ⲛⲥⲉⲭⲁϥ ϧⲁ ⲟⲩⲙⲉⲛⲧ ⲁⲗⲗⲁ ⳿ⲉϣⲁⲩⲭⲁϥ ϩⲓϫⲉⲛ ϯⲗⲩⲭⲛⲓ⳿ⲁ ⲟⲩⲟϩ ϣⲁϥ⳿ⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲉⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲡⲓⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ⲡⲁⲓⲣⲏϯ ⲙⲁⲣⲉ ⲡⲉⲧⲉⲛⲟⲩⲱⲓⲛⲓ ⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ϩⲟⲡⲱⲥ ⳿ⲛⲥⲉⲛⲁⲩ ⳿⳿ⲉⲛⲉⲧⲉⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲉⲑⲛⲁⲛⲉⲩ ⲟⲩⲟϩ ⳿ⲛⲥⲉϯ⳿ⲱⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","⳿ⲙⲡⲉⲣⲙⲉⲩⲓ ϫⲉ ⳿ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲉⲗ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ⲓⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲉϫⲟⲕⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","⳿ⲁⲙⲏⲛ ⲅⲁⲣ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϣⲁⲧⲉ ⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⲥⲓⲛⲓ ⲟⲩⲓⲱⲧⲁ ⲓⲉ ⲟⲩϣⲱⲗϩ ⳿ⲛⲛⲉϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ϣⲁⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ⲫⲏ ⲟⲩⲛ ⲉⲑⲛⲁⲃⲉⲗ ⲟⲩ⳿ⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⳿ⲛⲉⲛⲧⲟⲗⲏ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓⲕⲟⲩϫⲓ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁ⳿⳿ⲓⲣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ⳿ⲥⲃⲱ ⲫⲁⲓ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓⲛⲓϣϯ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲧⲉⲧⲉⲛⲙⲉⲑⲙⲏⲓ ⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲑⲁ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","⳿ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁⲩϫⲟⲥ ⳿ⲛⲛⲓⲁⲣⲭⲉⲟⲥ ϫⲉ ⳿ⲛⲛⲉⲕϧⲱⲧⲉⲃ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲱⲧⲉⲃ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲉⲛⲟⲭⲟⲥ ⳿ⲉϯ⳿ⲕⲣⲓⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϫⲱⲛⲧ ⳿ⲉⲡⲉϥⲥⲟⲛ ϩⲓⲕⲏ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲉⲛⲟⲭⲟⲥ ⳿ⲉϯ⳿ⲕⲣⲓⲥⲓⲥ ⲫⲏⲉⲑⲛⲁϫⲟⲥ ⳿ⲙⲡⲉϥⲥⲟⲛ ϫⲉ ⲣⲁⲕⲁ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲉⲛⲟⲭⲟⲥ ⳿ⲉⲡⲓⲙⲁⲛϯϩⲁⲡ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲟⲥ ⳿ⲙⲡⲉϥⲥⲟⲛ ϫⲉ ⲡⲓⲥⲟϫ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲉⲛⲟⲭⲟⲥ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","⳿ⲉϣⲱⲡ ⲟⲩⲛ ⳿ⲭⲛⲁ⳿ⲓⲛⲓ ⳿ⲙⲡⲉⲕⲇⲱⲣⲟⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲕⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲙⲁⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲁⲣⲓⲕⲓ ⲟⲩⲧⲱⲕ ⲛⲉⲙ ⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ⲭⲱ ⳿ⲙⲡⲉⲕⲇⲱⲣⲟⲛ ⳿ⲙⲙⲁⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲛϣⲟⲣⲡ ϩⲱⲧⲡ ⳿ⲉⲡⲉⲕⲥⲟⲛ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⳿ⲁⲙⲟⲩ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉⲕⲇⲱⲣⲟⲛ ⳿ⲉϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ϣⲱⲡⲓ ⲉⲕⲕⲁϯ ⳿ⲉⲡⲉⲕⲁⲛⲧⲓⲇⲓⲕⲟⲥ ⳿ⲛⲭⲱⲗⲉⲙ ϩⲟⲥ ⲉⲕⲭⲏ ⲛⲉⲙⲁϥ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲧⲉ ⲡⲓⲁⲛⲧⲓⲇⲓⲕⲟⲥ ⲧⲏⲓⲕ ⳿ⲉⲡⲓ⳿ⲕⲣⲓⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲕⲣⲓⲧⲏⲥ ⲧⲏⲓⲕ ⳿ⲉⲡⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲛⲥⲉϩⲓⲧⲕ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛⲛⲉⲕ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ϣⲁⲧⲉⲕϯ ⳿ⲛ⳿ⲧϧⲁ⳿ⲉ ⳿ⲛⲧⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","⳿ⲁⲣ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁⲩϫⲟⲥ ⳿ⲛⲛⲓⲁⲣⲭⲉⲟⲥ ϫⲉ ⳿ⲛⲛⲉⲕⲉⲣⲛⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϫⲟⲩϣⲧ ⳿ⲛⲥⲁ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉ⳿ⲡϫⲓⲛⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲣⲟⲥ ⲁϥⲕⲏⲛ ⲉϥⲟⲓ ⳿ⲛⲛⲱⲓⲕ ⳿ⲉⲣⲟⲥ ϧⲉⲛ ⲡⲉϥϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ⲓⲥϫⲉ ⲡⲉⲕⲃⲁⲗ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟⲕ ⲫⲟⲣⲕϥ ϩⲓⲧϥ ⳿ⲉⲃⲟⲗϩⲁⲣⲟⲕ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲅⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲉⲕⲙⲉⲗⲟⲥ ⲧⲁⲕⲟ ⲟⲩⲟϩ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ϣⲉⲛⲁϥ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ⲟⲩⲟϩ ⲓⲥϫⲉ ⲧⲉⲕϫⲓϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲙⲟⲕ ϫⲟϫⲥ ϩⲓⲧⲥ ⳿ⲉⲃⲟⲗϩⲁⲣⲟⲕ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲅⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲉⲕⲙⲉⲗⲟⲥ ⲧⲁⲕⲟ ⲟⲩⲟϩ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ϣⲉⲛⲁϥ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ⲁⲩϫⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁϩⲓ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⲙⲁⲣⲉϥϯ ⳿ⲛⲟⲩ⳿ⲥϧⲓ ⳿ⲛⲟⲩⲉⲓ ⲛⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϩⲓ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩ⳿ⲉϣⲉⲛⲥⲁϫⲓ ⳿ⲙⲡⲟⲣⲛⲓ⳿ⲁ ⲁϥ⳿ⲑⲣⲟ ⳿ⲙⲙⲟⲥ ⳿ⲉ⳿ϫⲫⲉ ⲛⲱⲓⲕ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϭⲓ ⳿ⲛⲑⲏⲉⲧϩⲱⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ϥⲟⲓ ⳿ⲛⲛⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ⲡⲁⲗⲓⲛ ⳿ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁⲩϫⲟⲥ ⳿ⲛⲛⲓⲁⲣⲭⲉⲟⲥ ϫⲉ ⳿ⲛⲛⲉⲕⲱⲣⲕ ⳿ⲛⲛⲟⲩϫ ⲉⲕ⳿ⲉϯ ⲇⲉ ⳿ⲛⲛⲉⲕ⳿ⲁⲛⲁⲩϣ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲉⲣⲱⲣⲕ ϩⲟⲗⲱⲥ ⳿ⲙⲡⲉⲣⲱⲣⲕ ⳿ⲛ⳿ⲧⲫⲉ ϫⲉ ⲡⲓ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲙⲪϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ⲟⲩⲇⲉ ⳿ⲡⲕⲁϩⲓ ϫⲉ ⳿ⲫⲙⲁ⳿ⲛⲥⲉⲙⲛⲓ ⳿ⲛⲧⲉ ⲛⲉϥϭⲁⲗⲁⲩϫ ⲡⲉ ⲟⲩⲇⲉ Ⲓⲗ̅ⲏ̅ⲙ̅ ϫⲉ ⳿ⲑⲃⲁⲕⲓ ⳿ⲙⲡⲓⲛⲓϣϯ ⳿ⲛⲟⲩⲣⲟ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲱⲣⲕ ⳿ⲛⲧⲉⲕ⳿ⲁⲫⲉ ϫⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲉⲣ ⲟⲩⲕⲁⲡ ⳿ⲛϥⲱⲓ ⳿ⲛⲟⲩⲱⲃϣ ⲓⲉ ⲟⲩⲁⲓ ⳿ⲛⲭⲁⲙⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ⲙⲁⲣⲉ ⲡⲉⲧⲉⲛⲥⲁϫⲓ ⲇⲉ ⲉⲣ ⲟⲩ⳿ⲁϩⲁ ⳿ⲁϩⲁ ⳿ⲙⲙⲟⲛ ⳿ⲙⲙⲟⲛ ⳿ⲡϩⲟⲩⲟ ⲇⲉ ⳿ⲛⲛⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","⳿ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁⲩϫⲟⲥ ϫⲉ ⲟⲩⲃⲁⲗ ϧⲁ ⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⲟⲩⲛⲁϫϩⲓ ϧⲁ ⲟⲩⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲉⲣϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲁⲗⲗⲁ ⲫⲏⲉⲑⲛⲁϯ ⳿ⲛⲟⲩⲕⲟⲩⲣ ⲛⲁⲕ ϧⲉⲛ ⲧⲉⲕⲟⲩ⳿ⲟϫⲓ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲫⲉⲛϩ ϯⲭⲉϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲟⲩⲱϣ ⳿ⲉϭⲓϩⲁⲡ ⲛⲉⲙⲁⲕ ⳿ⲉⲉⲗ ⲧⲉⲕ⳿ϣⲑⲏⲛ ⲭⲁ ⲡⲉⲕⲉⲣϣⲱⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϭⲓⲧⲕ ⳿ⲛ⳿ⲭⲃⲁ ⳿ⲛⲟⲩⲙⲓⲗⲓⲟⲛ ⲙⲟϣⲓ ⲛⲉⲙⲁϥ ⳿ⲛⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ⲫⲏⲉⲧⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟⲕ ⲙⲟⲓ ⲛⲁϥ ⲟⲩⲟϩ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉϭⲓ ⳿ⲛⲧⲟⲧⲕ ⳿ⲙⲡⲉⲣⲧⲁⲥⲑⲟϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","⳿ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁⲩϫⲟⲥ ϫⲉ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⲟⲩⲟϩ ⲉⲕ⳿ⲉⲙⲉⲥⲧⲉ ⲡⲉⲕϫⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","⳿ⲁⲛⲟⲕ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛϫⲁϫⲓ ⳿ⲥⲙⲟⲩ ⳿ⲉⲛⲏⲉⲧⲥⲁϩⲟⲩ⳿ⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲧⲱⲃϩ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧϭⲟϫⲓ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧ⳿ⲉⲛⲉⲣ ϣⲏⲣⲓ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ϫⲉ ⳿ϥ⳿ⲑⲣⲟ ⳿ⲙⲡⲉϥⲣⲏ ϣⲁⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲥⲁⲙⲡⲉⲧϩⲱⲟⲩ ⲛⲉⲙ ⲛⲓⲥⲁⲙⲡⲉⲑⲛⲁⲛⲉⲩ ⲟⲩⲟϩ ⳿ϥϩⲱⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓ⳿ⲑⲙⲏⲓ ⲛⲉⲙ ⲛⲓ⳿ⲟϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","⳿ⲉϣⲱⲡ ⲅⲁⲣ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲛⲣⲉ ⲛⲏⲉⲑⲙⲉⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲁϣ ⲡⲉ ⲡⲉⲧⲉⲛⲃⲉⲭⲉ ⲛⲓⲕ⳿ⲉⲧⲉⲗⲱⲛⲏⲥ ϩⲱⲟⲩ ϣⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉⲧⲉⲛϣⲉⲡⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲟⲩ ⳿ⲙⲙⲉⲧϩⲟⲩ⳿ⲟ ⳿ⲉⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⲛⲓⲕⲉⲉⲑⲛⲓⲕⲟⲥ ϩⲱⲟⲩ ϣⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ϣⲱⲡⲓ ⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲣⲉⲧⲉⲛϫⲏⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉⲧϫⲏⲕ ⳿ⲉⲃⲟⲗ ");
INSERT INTO copcnt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ⲙⲁϩⲑⲏⲧⲉⲛ ⲇⲉ ⳿ⲉⲡⲉⲧⲉⲛⲧⲁⲓ⳿ⲟ ⳿ⲙⲡⲉⲣⲁⲓϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲉⲑⲣⲟⲩⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲙⲙⲟⲛ ⲧⲉⲧⲉⲛⲃⲉⲭⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","⳿ⲉϣⲱⲡ ⲟⲩⲛ ⲉⲕⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲉⲑⲛⲁⲏⲧ ⳿ⲙⲡⲉⲣⲉϣⲧⲁⲡ ϧⲁϫⲱⲕ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲟⲩⲣⲁ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ⲛⲓϣⲟⲃⲓ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲛⲓ⳿ⲁⲅⲟⲣⲁ ϩⲓⲛⲁ ⳿ⲛⲥⲉϯ⳿ⲱⲟⲩ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲩⲕⲏⲛ ⲉⲩϭⲓ ⳿ⲙⲡⲟⲩⲃⲉⲭⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","⳿ⲛⲑⲟⲕ ⲇⲉ ⲉⲕⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲉⲑⲛⲁⲏⲧ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⲧⲉⲕϫⲁϭⲏ ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉ ⲧⲉⲕⲟⲩ⳿ⲓⲛⲁⲙ ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲧⲉⲕⲙⲉⲑⲛⲁⲏⲧ ϣⲱⲡⲓ ϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲟⲩⲟϩ ⲡⲉⲕⲓⲱⲧ ⲉⲑⲛⲁⲩ ϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲉϥ⳿ⲉϯ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲉⲣⲉⲧⲉⲛⲛⲁⲧⲱⲃϩ ⳿ⲛⲛⲉⲧ⳿ⲉⲛⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓϣⲟⲃⲓ ϫⲉ ϣⲁⲩⲙⲉⲓ ⳿ⲛ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲛⲓⲗⲁⲕϩ ⳿ⲛⲧⲉ ⲛⲓ⳿ϣⲑⲉϩ ⳿ⲛⲥⲉⲧⲱⲃϩ ϩⲟⲡⲱⲥ ⳿ⲛⲥⲉⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲩⲕⲏⲛ ⲉⲩϭⲓ ⳿ⲙⲡⲟⲩⲃⲉⲭⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","⳿ⲛⲑⲟⲕ ⲇⲉ ⲉⲕⲛⲁⲧⲱⲃϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉⲕⲧⲁⲙⲓⲟⲛ ⲙⲁϣⲑⲁⲙ ⳿ⲙⲡⲉⲕⲣⲟ ⳿ⲉⲣⲟⲕ ⲟⲩⲟϩ ⲧⲱⲃϩ ⳿ⲙⲡⲉⲕⲓⲱⲧ ϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲟⲩⲟϩ ⲡⲉⲕⲓⲱⲧ ⲉⲑⲛⲁⲩ ϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲉϥ⳿ⲉϯ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","⳿ⲉⲣⲉⲧⲉⲛⲛⲁⲧⲱⲃϩ ⲇⲉ ⳿ⲙⲡⲉⲣⲉⲣ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲁϫⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲉⲑⲛⲓⲕⲟⲥ ⲥⲉⲙⲉⲩⲓ ⲅⲁⲣ ϫⲉ ϧⲉⲛ ⲡⲟⲩⲙⲏϣ ⳿ⲛⲥⲁϫⲓ ⲥⲉⲛⲁⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","⳿ⲙⲡⲉⲣ⳿ⲓⲛⲓ ⲟⲩⲛ ⳿ⲙⲙⲱⲟⲩ ⳿ϥⲥⲱⲟⲩⲛ ⲅⲁⲣ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲁⲧⲉⲧⲉⲛⲧⲟⲃϩϥ ⲉⲑⲃⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ⲧⲱⲃϩ ⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ Ⲡⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲙⲁⲣⲉϥⲧⲟⲩⲃⲟ ⳿ⲛϫⲉ ⲡⲉⲕⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ⲙⲁⲣⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉⲕⲙⲉⲧⲟⲩⲣⲟ ⲡⲉⲧⲉ⳿ϩⲛⲁⲕ ⲙⲁⲣⲉϥϣⲱⲡⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ϧⲉⲛ ⳿ⲧⲫⲉ ⲛⲉⲙ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ⲡⲉⲛⲱⲓⲕ ⳿ⲛⲧⲉ ⲣⲁⲥϯ ⲙⲏ ⲓϥ ⲛⲁⲛ ⳿ⲙⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ⲟⲩⲟϩ ⲭⲁ ⲛⲏ⳿ⲉⲧⲉⲣⲟⲛ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ϩⲱⲛ ⳿ⲛⲧⲉⲛⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲁⲛ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲛⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ ⲁⲗⲗⲁ ⲛⲁϩⲙⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ϫⲉ ⲑⲱⲕ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲛⲉⲙ ϯϫⲟⲙ ⲛⲉⲙ ⲡⲓ⳿ⲱⲟⲩ ϣⲁ⳿⳿ⲉⲛⲉϩ ⳿ⲁⲙⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","⳿ⲉϣⲱⲡ ⲅⲁⲣ ⳿ⲛⲧⲉⲧⲉⲛⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲛⲛⲟⲩⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ ⲉϥ⳿ⲉⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲛⲉⲧⲉⲛⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲛⲛⲟⲩⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ ⲟⲩⲇⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⳿ϥⲛⲁⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⲁⲛ ⳿ⲛⲛⲉⲧⲉⲛⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉⲧ⳿ⲉⲛⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⳿ⲛⲛⲉⲧ⳿ⲉⲛⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓϣⲟⲃⲓ ⳿ⲉϣⲁⲩ⳿ⲱⲕⲉⲙ ⳿ⲛⲛⲟⲩϩⲟ ϣⲁⲩⲧⲁⲕⲉ ⲛⲟⲩϩⲟ ⲅⲁⲣ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲉⲩⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲩⲕⲏⲛ ⲉⲩϭⲓ ⳿ⲙⲡⲟⲩⲃⲉⲭⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","⳿ⲛⲑⲟⲕ ⲇⲉ ⲉⲕ⳿ⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲑⲱϩⲥ ⳿ⲛⲧⲉⲕ⳿ⲁⲫⲉ ⲟⲩⲟϩ ⲓⲁ ⲡⲉⲕϩⲟ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕ⳿ϣⲧⲉⲙⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲉⲕⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲁⲗⲗⲁ ⳿ⲙⲡⲉⲕⲓⲱⲧ ⲉⲧϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲟⲩⲟϩ ⲡⲉⲕⲓⲱⲧ ⲉⲑⲛⲁⲩ ϧⲉⲛ ⲡⲉⲧϩⲏ ⲡ ⲉϥ⳿ⲉϯϣⲉⲃⲓ⳿ⲱ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","⳿ⲙⲡⲉⲣϩⲓⲟⲩ⳿ⲓ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϩⲁⲛ⳿ⲁϩⲱⲣ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲡⲓⲙⲁ ⳿ⲉϣⲁⲣⲉ ⳿ⲧϩⲟⲗⲓ ⲛⲉⲙ ⳿ⲧϫⲟⲗⲓ ⲧⲁⲕⲱⲟⲩ ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲉϣⲁⲣⲉ ⲛⲓⲥⲟⲛⲓ ϩⲓϣⲁⲧⲥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲕⲟⲗⲡⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ϩⲓⲟⲩ⳿ⲓ ⲇⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϩⲁⲛ⳿ⲁϩⲱⲣ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲡⲁⲣⲉ ϩⲟⲗⲓ ⲟⲩⲇⲉ ϫⲟⲗⲓ ⲧⲁⲕⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲁⲣⲉ ⲛⲓⲥⲟⲛⲓ ϩⲓϣⲁⲧⲥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲕⲟⲗⲡⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ⲡⲓⲙⲁ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲡⲉⲕ⳿ⲁϩⲟ ⳿ⲙⲙⲟϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲡⲉⲕⲕⲉϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","⳿ⲡϧⲏⲃⲥ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⲡⲉ ⲡⲓⲃⲁⲗ ⳿ⲉϣⲱⲡ ⲟⲩⲛ ⲡⲉⲕⲃⲁⲗ ⲟⲩϩⲁⲡⲗⲟⲩⲥ ⲡⲉ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","⳿ⲉϣⲱⲡ ⲇⲉ ⲡⲉⲕⲃⲁⲗ ⲟⲩⲥⲁⲙⲡⲉⲧϩⲱⲟⲩ ⲡⲉ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛⲭⲁⲕⲓ ⲓⲥϫⲉ ⲟⲩⲛ ⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲉⲧⲉ ⳿ⲛϧⲏⲧⲕ ⲟⲩⲭⲁⲕⲓ ⲡⲉ ⲓⲉ ⲁⲩⲏⲣ ⲙⲗⲗⲟⲛ ⲡⲉ ⲡⲓⲭⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⲉⲣⲃⲱⲕ ⳿ⲛ⳪ ⲃ̅ ⲓⲉ ⲅⲁⲣ ⳿ⲛⲧⲉϥⲙⲉⲥⲧⲉ ⲟⲩⲁⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲙⲉⲛⲣⲉ ⲟⲩⲁⲓ ⲓⲉ ⳿ⲛⲧⲉϥϣⲉⲡ ⲟⲩⲁⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲣⲕⲁⲧⲁ⳿ⲫⲣⲟⲛⲓⲛ ⳿ⲙⲡⲓⲭⲉⲧ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲉⲣⲃⲱⲕ ⳿ⲙⲪϯ ⲛⲉⲙ ⲙⲁⲙⲱⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ⲉⲑⲃⲉ ⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲧⲉⲧⲉⲛⲯⲩⲭⲏ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲟⲩⲟⲙϥ ⲓⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲥⲟϥ ⲟⲩⲇⲉ ϧⲁ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲧⲏⲓϥ ϩⲓ ⲑⲏⲛⲟⲩ ⲙⲏ ϯⲯⲩⲭⲏ ⲟⲩⲟⲧ ⲁⲛ ⳿ⲉϯ ⳿ϧⲣⲉ ⲟⲩⲟϩ ⲡⲓⲥⲱⲙⲁ ⳿ⲉϯϩⲉⲃⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ⲙⲁⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ϫⲉ ⲥⲉⲥⲓϯ ⲁⲛ ⲟⲩⲇⲉ ⲥⲉⲱⲥϧ ⲁⲛ ⲟⲩⲇⲉ ⲥ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⲁⲛ ⳿ⲉ⳿ⲁⲡⲟⲑⲏⲕⲏ ⲟⲩⲟϩ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉϥϣⲁⲛϣ ⳿ⲙⲙⲱⲟⲩ ⲙⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛ ⲙⲁⲗⲗⲟⲛ ⲉⲑⲟⲩⲟⲧ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ⲛⲓⲙ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧϥⲓⲣⲱⲟⲩϣ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲁⲗⲉ ⲟⲩⲙⲁϩⲓ ⳿ⲛϣⲓ⳿ⲏ ⳿ⲉϫⲉⲛ ⲧⲉϥⲙⲁⲓ⳿ⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ⲟⲩⲟϩ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛϥⲓⲣⲱⲟⲩϣ ⲉⲑⲃⲉ ϩⲉⲃⲥⲱ ⲙⲁⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲛⲓ⳿ϩⲣⲏⲣⲓ ⳿ⲛⲧⲉ ⳿ⲧⲕⲟⲓ ϫⲉ ⲡⲱⲥ ⲥⲉⲁⲓⲁⲓ ⳿ⲛⲥⲉϧⲟⲥⲓ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛⲥⲉⲉⲣⲓⲟⲡⲏ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲇⲉ Ⲥⲟⲗⲟⲙⲱⲛ ϧⲉⲛ ⲡⲉϥ⳿ⲱⲟⲩ ⲧⲏⲣϥ ⳿ⲙⲡⲉϥϯϩⲓⲱⲧϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ⲓⲥϫⲉ ⲇⲉ ⲡⲓⲥⲓⲙ ⳿ⲛⲧⲉ ⳿ⲧⲕⲟⲓ ⳿ϥϣⲟⲡ ⳿ⲙⲫⲟⲟⲩ ⲟⲩⲟϩ ⲣⲁⲥϯ ϣⲁⲩϩⲓⲧϥ ⳿ⲉϯ⳿ⲑⲣⲓⲣ Ⲫϯ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ϥϯϩⲉⲃⲥⲱ ϩⲓⲱⲧϥ ⲓⲉ ⲁⲩⲏⲣ ⲙⲁⲗⲗⲟⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ⲟⲩⲛ ⳿ⲉⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲟⲩⲟⲙϥ ⲓⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲥⲟϥ ⲓⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲧⲏⲓϥ ϩⲓ⳿ⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ⲛⲁⲓ ⲅⲁⲣ ⲧⲏⲣⲟⲩ ⲛⲓⲉⲑⲛⲓⲕⲟⲥ ⲥⲉⲕⲱϯ ⳿ⲛⲥⲱⲟⲩ ⳿ϥⲥⲱⲟⲩⲛ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ϫⲉ ⲧⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲛⲛⲁⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ⲕⲱϯ ⲇⲉ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲥⲁ ⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ ⲛⲉⲙ ⲧⲉϥⲙⲉⲑⲙⲏⲓ ⲟⲩⲟϩ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉϥ⳿ⲉⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲣⲁⲥϯ ⲣⲁⲥϯ ⲅⲁⲣ ⲉϥ⳿ⲉϥⲓⲣⲱⲟⲩϣ ϧⲁⲣⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲕⲏⲛ ⳿ⲉⲡⲓ⳿ⲉϩⲟⲟⲩ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉϥⲕⲁⲕⲓⲁ ");
INSERT INTO copcnt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","⳿ⲙⲡⲉⲣϯϩⲁⲡ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϯϩⲁⲡ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ⲡⲓϩⲁⲡ ⲅⲁⲣ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲧⲏⲓϥ ⲁⲩⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓϣⲓ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁ⳿ϣ⳿ⲓ ⳿ⲙⲙⲟϥ ⲁⲩⲛⲁϣⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ⲉⲑⲃⲉ ⲟⲩ ⳿ⲭⲛⲁⲩ ⳿ⲉⲡⲓϫⲏⲓ ϧⲉⲛ ⳿ⲫⲃⲁⲗ ⳿ⲙⲡⲉⲕⲥⲟⲛ ⲡⲓⲥⲟⲓ ⲇⲉ ⲉⲧϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲕϯⲛⲓⲁⲧⲕ ⳿ⲙⲙⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ⲓⲉ ⲡⲱⲥ ⳿ⲭⲛⲁϫⲟⲥ ⳿ⲙⲡⲉⲕⲥⲟⲛ ϫⲉ ⲭⲁⲧ ⳿ⲛⲧⲁϩⲓ ⲡⲓϫⲏⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲓⲥⲟⲓ ⳿ϥⲭⲏ ϧⲉⲛ ⲡⲉⲕⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ⲡⲓϣⲟⲃⲓ ϩⲓ ⲡⲓⲥⲟⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲕ⳿ⲉⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲉϩⲓ ⲡⲓϫⲏⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲃⲁⲗ ⳿ⲙⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","⳿ⲙⲡⲉⲣϯ ⳿ⲙⲡⲉⲑⲟⲩⲁⲃ ⳿ⲛⲛⲓⲟⲩϩⲱⲣ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲁⲛⲁⲙⲏⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓ⳿ⲉϣⲁⲩ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲥⲉϩⲱⲙⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛⲛⲟⲩϭⲁⲗⲁⲩϫ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲕⲟⲧⲟⲩ ⳿ⲛⲥⲉⲫⲉϧ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","⳿ⲁⲣⲓ⳿ⲉⲧⲓⲛ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϯ ⲛⲱⲧⲉⲛ ⲕⲱϯ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⲕⲱⲗϩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲁⲟⲩⲱⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲣ⳿ⲉⲧⲓⲛ ϣⲁϥϭⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲕⲱϯ ϣⲁϥϫⲓⲙⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲕⲱⲗϩ ϣⲁⲩⲟⲩⲱⲛ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ⲓⲉ ⲛⲓⲙ ⳿ⲛⲣⲱⲙⲓ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲧⲉ ⲡⲉϥϣⲏⲣⲓ ⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲱⲓⲕ ⲙⲏ ⳿ϥⲛⲁϯ ⲛⲁϥ ⳿ⲛⲟⲩ⳿ⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ⲓⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲧⲉⲃⲧ ⲙⲏ ⳿ϥⲛⲁϯ ⳿ⲛⲟⲩϩⲟϥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ⲓⲥϫⲉ ⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲥⲁⲙⲡⲉⲧϩⲱⲟⲩ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲉϯ ⳿ⲛⲛⲓⲧⲁⲓⲟ ⲉⲑⲛⲁⲛⲉⲩ ⳿ⲛⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲓⲉ ⲁⲩⲏⲣ ⲙⲁⲗⲗⲟⲛ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉϥ⳿ⲉϯ ⳿ⲛⲛⲓ⳿ⲁⲅⲁⲑⲟ⳿ ⲛⲛⲏⲉⲑⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ϩⲱⲃ ⲇⲉ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲟⲩⲱϣ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲁⲓⲧⲟⲩ ⲛⲱⲧⲉⲛ ⳿ⲁⲣⲓⲟⲩ⳿ⲓ ⲛⲱⲟⲩ ϩⲱⲧⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯⲡⲩⲗⲏ ⲉⲧϫⲏⲟⲩ ϫⲉ ⳿ⲥⲟⲩⲱϣⲥ ⳿ⲛϫⲉ ϯⲡⲩⲗⲏ ⲟⲩⲟϩ ⳿ϥⲟⲩⲉⲥⲑⲱⲛ ⳿ⲛϫⲉ ⲡⲓⲙⲱⲓⲧ ⲉⲧϭⲓ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ ⲟⲩⲟϩ ⲥⲉⲟϣ ⳿ⲛϫⲉ ⲛⲏⲉⲑⲛⲁϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ϫⲉ ⳿ⲥϫⲏⲟⲩ ⳿ⲛϫⲉ ϯⲡⲩⲗⲏ ⲟⲩⲟϩ ⳿ϥϩⲉϫϩⲱϫ ⳿ⲛϫⲉ ⲡⲓⲙⲱⲓⲧ ⲉⲧϭⲓ ⳿ⲉ⳿ⲡⲱⲛϧ ⲟⲩⲟϩ ϩⲁⲛⲕⲟⲩϫⲓ ⲡⲉⲑⲛⲁϫⲉⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","⳿ⲁⲣⲉϩ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲛⲟⲩϫ ⲛⲏⲉⲑⲛⲏⲟⲩ ϩⲁⲣⲱⲧⲉⲛ ϧⲉⲛ ϩⲁⲛϩⲉⲃⲥⲱ ⳿ⲛ⳿ⲉⲥⲱⲟⲩ ⲥⲁϧⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ϩⲁⲛⲟⲩⲱⲛϣ ⳿ⲛⲣⲉϥϩⲱⲗⲉⲙ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩⲟⲩⲧⲁϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟⲩⲱⲛⲟⲩ ⲙⲏ ⲧⲓ ϣⲁⲩⲥⲉⲕ ⳿ⲁⲗⲟⲗⲓ ⳿ⲉⲃⲟⲗϩⲓ ϩⲁⲛϣⲟⲛϯ ⲓⲉ ϣⲁⲩⲥⲉⲕ ⲕⲉⲛⲧⲉ ⳿ⲉⲃⲟⲗϩⲓ ⲛⲓⲥⲉⲣⲟϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ⲡⲁⲓⲣⲏϯ ⳿ϣϣⲏⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲛⲉϥ ϣⲁϥⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲃⲟⲗ ⲡⲓ⳿ϣϣⲏⲛ ⲇⲉ ⲉⲧϩⲱⲟⲩ ϣⲁϥⲉⲛ ⲟⲩⲧⲁϩ ⲉϥϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲟⲩ⳿ϣϣⲏⲛ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲉⲣⲟⲩⲧⲁϩ ⲉϥϩⲱⲟⲩ ⲟⲩⲇⲉ ⲟⲩ⳿ϣϣⲏⲛ ⲉϥϩⲱⲟⲩ ⳿ⲉⲉⲣⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","⳿ϣϣⲏⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ⳿ϥⲛⲁ⳿⳿ⲓⲣⲓ ⲁⲛ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ ⲥⲉⲛⲁⲕⲟⲣϫϥ ⳿ⲛⲥⲉϩⲓⲧϥ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ϩⲁⲣⲁ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩⲟⲩⲧⲁϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟⲩⲱⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲁⲛ ⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲏⲓ ϫⲉ Ⲡ⳪ Ⲡ⳪ ⲉⲑⲛⲁ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲁⲗⲗⲁ ⲡⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲉⲧⲉϩⲛⲉ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⲉⲩⲛⲁϫⲟⲥ ⲛⲏⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ Ⲡ⳪ Ⲡ⳪ ⲙⲏ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲁⲛ ⲁⲛⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲁⲛϩⲓ ⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲁⲛ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛϫⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲓ⳿ⲉⲟⲩⲱⲛϩ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲙⲡⲓⲥⲟⲩⲉⲛ ⲑⲏⲛⲟⲩ ⳿⳿ⲉⲛⲉϩ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲓ ⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⳿ⲛⲧⲉ ϯ⳿⳿ⲁⲛⲟⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲛⲁⲓ ⲟⲩⲟϩ ⲉϥ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲉⲓ⳿ⲉⲧⲉⲛⲑⲱⲛϥ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲛⲥⲁⲃⲉ ⲫⲏ⳿ⲉⲧⲁϥⲕⲱⲧ ⳿ⲙⲡⲉϥⲏⲓ ϩⲓϫⲉⲛ ϯⲡⲉⲧⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲡⲓⲙⲟⲩⲛϩⲱⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲓⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲛⲓϥⲓ ⳿ⲛϫⲉ ⲛⲓⲑⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩⲕⲱⲗϩ ⳿ⲉⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥϩⲉⲓ ⲛⲁⲣⲉ ⲧⲉϥⲥⲉⲛϯ ⲅⲁⲣ ⲧⲁϫⲣⲏⲟⲩⲧ ⲡⲉ ϩⲓϫⲉⲛ ϯⲡⲉⲧⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲛⲁⲓ ⲟⲩⲟϩ ⲉϥ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ ⲉⲓ⳿ⲉⲧⲉⲛⲑⲱⲛϥ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲛⲥⲟϫ ⲫⲁⲓ ⳿ⲉⲧⲁϥⲕⲱⲧ ⳿ⲙⲡⲉϥⲏⲓ ϩⲓϫⲉⲛ ⲡⲓϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲡⲓⲙⲟⲩⲛϩⲱⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲓⲁⲣⲱⲟⲩ ⲁⲩⲛⲓϥⲓ ⳿ⲛϫⲉ ⲛⲓⲑⲏⲟⲩ ⲁⲩⲕⲱⲗϩ ⳿ⲉⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁϥϩⲉⲓ ⲟⲩⲟϩ ⲡⲉϥϩⲉⲓ ⲛⲉ ⲟⲩⲛⲓϣϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲉⲕ ⲛⲁⲓⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ⲛⲁϥϯ⳿ⲥⲃⲱ ⲅⲁⲣ ⲛⲱⲟⲩ ⲡⲉ ϩⲱⲥ ⳿ⲉⲟⲩⲟ⳿ⲛⲧⲉϥⲉⲣϣⲓϣⲓ ⲟⲩⲟϩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲁⲛ ⳿ⲛⲛⲟⲩⲥⲁϧ ");
INSERT INTO copcnt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲕⲁⲕⲥⲉϩⲧ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⲉϥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲁ⳪ ⲁⲕϣⲁⲛⲟⲩⲱϣ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲧⲟⲩⲃⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁϥϭⲓⲛⲉⲙⲁϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲟⲩⲱϣ ⲙⲁⲧⲟⲩⲃⲟ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ϥⲧⲟⲩⲃⲟ ⳿ⲛϫⲉ ⲡⲉϥⲥⲉϩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲣϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⲁⲗⲗⲁ ⲙⲁϣⲉⲛⲁⲕ ⲙⲁⲧⲁⲙⲉ ⲡⲓⲟⲩⲏⲃ ⳿ⲉⲣⲟⲕ ⲟⲩⲟϩ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲇⲱⲣⲟⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲟϥ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲔⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲉϥϯϩⲟ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲁ⳪ ⲡⲁ⳿ⲁⲗⲟⲩ ⲣⲁϧⲧ ϧⲉⲛ ⲡⲁⲏⲓ ⲉϥϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁⲓ ⳿ⲛⲧⲁⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲡⲉϫⲁϥ ϫⲉ Ⲡⲁ⳪ ⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϧⲁ ⳿ⲑⲟⲩⲁϩⲥⲟⲓ ⳿ⲙⲡⲁⲏⲓ ⲁⲗⲗⲁ ⲙⲟⲛⲟⲛ ⳿ⲁϫⲟⲥ ϧⲉⲛ ⳿ⲡⲥⲁϫⲓ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲡⲁ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ⲕⲉ ⲅⲁⲣ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ϩⲱ ⲉϥⲭⲏ ϧⲁ ⲟⲩⲉⲣϣⲓϣⲓ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛⲙⲁⲧⲟⲓ ϧⲁⲣⲁⲧ ⲁⲓϣⲁⲛϫⲟⲥ ⳿ⲙⲫⲁⲓ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ϣⲁϥϣⲉⲛⲁϥ ⲕⲉ ⲟⲩⲁⲓ ϫⲉ ⳿ⲁⲙⲟⲩ ϣⲁϥ⳿ⲓ ⲟⲩⲟϩ ⲡⲁⲃⲱⲕ ϫⲉ ⳿ⲁⲣⲓ ⲫⲁⲓ ϣⲁϥⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲏ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲓϫⲉⲙ ⲟⲩⲛⲁϩϯ ⳿ⲛⲧⲁⲓⲙⲁⲓ⳿ⲏ ⳿ⲛⲧⲉⲛ ⳿ϩⲗⲓ ϧⲉⲛ Ⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲁⲛⲙⲏϣ ⲉⲩ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁⲡⲉⲓⲉⲃⲧ ⲛⲉⲙ ⲡⲉⲙⲉⲛⲧ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲣⲟⲑⲃⲟⲩ ⲛⲉⲙ Ⲁⲃⲣⲁⲁⲙ ⲛⲉⲙ Ⲓ̇ⲥⲁⲁⲕ ⲛⲉⲙ Ⲓⲁⲕⲱⲃ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ⲛⲓϣⲏⲣⲓ ⲇⲉ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲉⲩ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲭⲁⲕⲓ ⲉⲧⲥⲁⲃⲟⲗ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲕⲛⲁϩϯ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲛⲁⲕ ⲟⲩⲟϩ ⲁϥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲁϥⲛⲁⲩ ⳿ⲉⲧⲉϥϣⲱⲙⲓ ⲉⲥⲣⲁϧⲧ ⲟⲩⲟϩ ⲉⲥϧⲏⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ⲁϥϭⲓⲛⲉⲙ ⲧⲉⲥϫⲓϫ ⲟⲩⲟϩ ⲁϥⲭⲁⲥ ⳿ⲛϫⲉ ⲡⲓ⳿ϧⲙⲟⲙ ⲟⲩⲟϩ ⲁⲥⲧⲱⲛⲥ ⲟⲩⲟϩ ⲁⲥϣⲉⲙϣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛϩⲁⲛⲙⲏϣ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛⲓϧ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲥⲁϫⲓ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲛⲎ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟϥ ⲁϥϭⲓ ⳿ⲛⲛⲉⲛϣⲱⲛⲓ ⲟⲩⲟϩ ⲁϥϥⲁⲓ ⳿ⲛⲛⲉⲛⲓⲁⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲓⲙⲏϣ ⲉⲧⲕⲱϯ ⳿ⲉⲣⲟϥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉ⳿ⲑⲣⲟⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲙⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲥⲁϧ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲁⲙⲟϣⲓ ⳿ⲛⲥⲱⲕ ⳿ⲉ⳿ⲫⲙⲁ ⳿ⲉⲧⲁⲕϣⲉⲛⲁⲕ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ⲛⲓⲃⲁϣⲟⲣ ⲟⲩⲟⲛⲧⲟⲩ ⲃⲏⲃ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲟⲩⲟⲛⲧⲟⲩ ⲙⲁⲛⲟⲩⲱϩ ⳿ⲡϣⲏⲣⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ⲙⲙⲟⲛⲧⲉϥ ⲙⲁ ⳿ⲛⲣⲉⲕ ϫⲱϥ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ⲕⲉ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ Ⲡⲁ⳪ ⲙⲁⲉⲣϣⲓϣⲓ ⲛⲏⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲁϣⲉⲛⲏⲓ ⳿ⲛⲧⲁⲑⲱⲙⲥ ⳿ⲙⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲭⲁ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲙⲁⲣⲟⲩⲑⲱⲙⲥ ⳿ⲛⲛⲟⲩⲣⲉϥⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲟⲛⲙⲉⲛ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⳿ⲫⲓⲟⲙ ϩⲱⲥⲇⲉ ⳿ⲛⲧⲉ ⲛⲓϩⲱⲓⲙⲓ ⳿ⲛⲧⲟⲩϩⲱⲃⲥ ⳿ⲙⲡⲓϫⲟⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥⲉⲛⲕⲟⲧ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲁⲩⲛⲉϩⲥⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲛⲁϩⲙⲉⲛ ϫⲉ ⲧⲉⲛⲛⲁⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛϣⲟⲗϩ ⳿ⲛϩⲏⲧ ⲛⲁ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛⲛⲁϩϯ ⲧⲟⲧⲉ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲛⲓⲑⲏⲟⲩ ⲛⲉⲙ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛϫⲁⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ⲛⲓⲣⲱⲙⲓ ⲇⲉ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲁϣ ⳿ⲛⲣⲏϯ ⲡⲉ ⲫⲁⲓ ϫⲉ ⲛⲓⲑⲏⲟⲩ ⲛⲉⲙ ⳿ⲫⲓⲟⲙ ⲥⲉⲥⲱⲧⲉⲙ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲙⲏⲣ ⳿ⲉ⳿ⲧⲭⲱⲣⲁ ⳿ⲛⲧⲉ ⲛⲓⲄⲉⲣⲅⲉⲥⲏⲛⲟⲥ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲛϫⲉ ⳿ⲥⲛⲁⲩ ⳿ⲉⲣⲉ ⲛⲓⲓϧ ⲛⲉⲙⲱⲟⲩ ⲉⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⲉⲩϩⲱⲟⲩ ⳿ⲉⲙⲁϣⲱ ϩⲱⲥⲇⲉ ⳿ⲛⲧⲉ ⳿ϣⲧⲉⲙ ⳿ϩⲗⲓ ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁϧⲟⲕ ⲛⲉⲙⲁⲛ Ⲓⲏ̅ⲥ̅ ⳿̇ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ ⳿ⲉⲧⲁⲕ⳿ⲓ ⳿ⲙⲛⲁⲓ ⳿ⲉ⳿ⲧϩⲉⲙⲕⲟⲛ ⳿ⲙⲡⲁⲧⲉ ⳿ⲡⲥⲏⲟⲩ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲟϩⲓ ⲇⲉ ⳿ⲛⲣⲓⲣ ⲉⲩⲟϣ ⲉⲩⲟⲩ⳿ⲏⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⲉⲩⲙⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ⲛⲓⲓϧ ⲇⲉ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⳿ⲭⲛⲁϩⲓⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟⲣⲡⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲟϩⲓ ⲛⲣⲓⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓ⳿ⲉϣⲁⲩ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲓ⳿ⲟϩⲓ ⲧⲏⲣϥ ⳿ⲛⲣⲓⲣ ⲁⲩϣⲉⲛⲱⲟⲩ ϧⲉⲛ ⲟⲩⲟⲩⲟⲓ ϧⲁⲧⲉⲛ ⲡⲓϫⲁϫⲣⲓⲙ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩ ϧⲉⲛ ⲛⲓⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ⲛⲏ ⲇⲉ ⲉⲑⲙⲟⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲩⲫⲱⲧ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϯⲃⲁⲕⲓ ⲁⲩⲧⲁⲙⲱⲟⲩ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲉⲑⲃⲉ ⲛⲏ⳿ⲉⲧⲉ ⲛⲓⲓϧ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ⲟⲩⲟϩ ⲓⲥ ϯⲃⲁⲕⲓ ⲧⲏⲣⲥ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲉⲛ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩϭⲓ⳿ⲏ ");
INSERT INTO copcnt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲁϥ⳿ⲓ ⳿ⲉⲙⲏⲣ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲉϥⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲁⲓ ⲉϥϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲉϥ⳿ϣⲧⲏⲟⲩⲧ ϩⲓϫⲉⲛ ⲟⲩϭⲗⲟϫ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲡⲟⲩⲛⲁϩϯ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⲡⲁϣⲏⲣⲓ ⲛⲉⲕⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ⲟⲩⲟϩ ⲓⲥ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲥⲁϧ ⲡⲉϫⲱⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲫⲁⲓ ϫⲉⲟⲩ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲟⲩⲙⲟⲕⲙⲉⲕ ⲡⲉϫⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ⳿ⲉϩⲁⲛⲡⲉⲧϩⲱⲟⲩ ϧⲉⲛ ⲛⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ⲟⲩ ⲅⲁⲣ ⲉⲑⲙⲟⲧⲉⲛ ⳿ⲉϫⲟⲥ ϫⲉ ⲛⲉⲕⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ϣⲁⲛ ⳿ⲉϫⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⲟⲩⲟϩ ⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ϩⲓⲛⲁ ⲇⲉ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ⲛⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ϫⲉ ⲧⲱⲛⲕ ⳿ⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉⲡⲉⲕⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲁⲩⲉⲣϩⲟϯ ⲟⲩⲟϩ ⲁⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲫⲏ⳿ⲉⲧⲁϥϯⲉⲣϣⲓϣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲛⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ⲟⲩⲟϩ ⲉϥⲥⲓⲛⲓ⳿ⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⲉϥϩⲉⲙⲥⲓ ϩⲓ ⲟⲩⲧⲉⲗⲱⲛⲓⲟⲛ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲙⲁⲧⲑⲉⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ⲉϥⲣⲱⲧⲉⲃ ⲇⲉ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲓⲥ ϩⲁⲛⲙⲏϣ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲛⲉⲙ ϩⲁⲛⲧⲉⲗⲱⲛⲏⲥ ⲁⲩ⳿ⲓ ⲁⲩⲣⲟⲑⲃⲟⲩ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲣⲉϥϯ⳿ⲥⲃⲱ ⲉϥⲟⲩⲱⲙ ⲛⲉⲙ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲏⲉⲧϫⲟⲣ ⲥⲉⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲁⲛ ⳿ⲙⲡⲓⲥⲏⲓⲛⲓ ⲁⲗⲗⲁ ⲛⲏⲉⲑⲙⲟⲕϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲇⲉ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉ ⲟⲩⲛⲁⲓ ⲡⲉϯⲟⲩⲁϣϥ ⲟⲩⲟϩ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⲁⲛ ⲛⲉⲧⲁⲓ⳿ⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲉⲑⲁϩⲉⲙ ⲛⲓ⳿ⲑⲙⲏⲓ ⲁⲗⲗⲁ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲉⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲁⲛⲟⲛ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲧ⳿ⲉⲛⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⳿ⲛϩⲁⲛⲙⲏϣ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⳿ⲛⲑⲱⲟⲩ ⲥⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲙⲏ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲉⲉⲣϩⲏⲃⲓ ϩⲟⲥ ⲉϥⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲥⲉⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲉϣⲱⲡ ⲁⲩϣⲁⲛ⳿ⲱⲗⲓ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ ⲧⲟⲧⲉ ⲉⲩ⳿ⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⲉⲗ ⲟⲩⲧⲱⲓⲥ ⳿ⲙⲃⲉⲣⲓ ⳿ⲛⲧⲉϥϩⲓⲧⲥ ⳿ⲉⲟⲩⲫⲉⲗϫⲓ ⳿ⲛ⳿ϩⲃⲟⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ϣⲁⲥ⳿ⲱⲗⲓ ⲅⲁⲣ ⳿ⲙⲡⲉⲥⲙⲟϩ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓ⳿ϩⲃⲟⲥ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲟⲩⲫⲱϧ ϣⲱⲡⲓ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉⲁⲥⲕⲟⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ⳿ⲙⲙⲟⲛ ϣⲁⲣⲉ ⲛⲓⲁⲥⲕⲟⲥ ⲫⲱϧ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲡⲓⲏⲣⲡ ⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓⲁⲥⲕⲟⲥ ⲧⲁⲕⲟ ⲁⲗⲗⲁ ϣⲁⲩϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉⲁⲥⲕⲟⲥ ⳿ⲙⲃⲉⲣⲓ ⲟⲩⲟϩ ϣⲁⲩϥⲓ ⳿ⲛⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ⲛⲁⲓ ⲇⲉ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲓⲥ ⲟⲩⲁⲣⲭⲱⲛ ⲁϥ⳿ⲓ ⲉϥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲧⲁϣⲉⲣⲓ ⲙⲟⲩ ϯⲛⲟⲩ ⲁⲗⲗⲁ ⳿ⲁⲙⲟⲩ ⲭⲁ ⲧⲉⲕϫⲓϫ ⳿ⲉϫⲱⲥ ⲟⲩⲟϩ ⲉⲥ⳿ⲉⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ⲟⲩⲟϩ ⲓⲥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲣⲉ ⳿ⲡ⳿ⲥⲛⲟϥ ϣⲁⲧ ⳿ⲉⲃⲟⲗ ϧⲁⲣⲟⲥ ⳿ⲙⲓ̅ⲃ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲟϥ ⲁⲥϭⲓⲛⲉⲙ ⳿ⲡ⳿ϣⲧⲁϯ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ϩⲃⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ⲛⲁⲥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲥ ϫⲉ ⲙⲟⲛⲟⲛ ⲁⲓϣⲁⲛϭⲓⲛⲉⲙ ⳿ⲡ⳿ϣⲧⲁϯ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ϩⲃⲟⲥ ϯⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥⲫⲟⲛϩϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⲧⲁϣⲉⲣⲓ ⲡⲉⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲓ ⲟⲩⲟϩ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲁⲣⲭⲱⲛ ⲁϥⲛⲁⲩ ⳿ⲉⲛⲓⲣⲉϥϫⲱⲟⲩ⳿ⲓ ⲛⲉⲙ ⲛⲓⲙⲏϣ ⲉⲩ⳿ϣⲧⲉⲣⲑⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ⲛⲁϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲙⲡⲉⲥⲙⲟⲩ ⲅⲁⲣ ⳿ⲛϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲁⲗⲗⲁ ⲁⲥⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⲛⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁⲩϩⲓ ⲡⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲉⲥϫⲓϫ ⲟⲩⲟϩ ⲁⲥⲧⲱⲛⲥ ⳿ⲛϫⲉ ϯ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ⲟⲩⲟϩ ⳿ⲁ ⲧⲉⲥ⳿ⲥⲙⲏ ϣⲉⲛⲁⲥ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲧⲏⲣϥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲃⲉⲗⲗⲉ ⲃ̅ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓ ⲛⲁⲛ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲃⲉⲗⲗⲉⲩ ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁϩϯ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉⲉⲣ ⲫⲁⲓ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲥⲉ Ⲡⲉⲛ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ⲧⲟⲧⲉ ⲁϥϭⲓⲛⲉⲙ ⲛⲟⲩⲃⲁⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲕⲁⲧⲁ ⲡⲉⲧⲉⲛⲛⲁϩϯ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲛ ⳿ⲛϫⲉ ⲛⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩⲥⲉⲣ ⲧⲉϥ⳿ⲥⲙⲏ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲁϩⲓ ⲧⲏⲣϥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ⲉϥⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ϩⲏⲡⲡⲉ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⲛⲟⲩ⳿ⲉⲃⲟ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓ ⲡⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲁϥⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉⲃⲟ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⲟⲩⲟⲛϩϥ ⳿⳿ⲉⲛⲉϩ ⳿ⲙⲡⲁⲓⲣⲏϯ ϧⲉⲛ Ⲡⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϧⲉⲛ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲓⲃⲁⲕⲓ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓϯⲙⲓ ⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲉϥϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲉϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϣⲱⲛⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲓⲁⲃⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲛⲓⲙⲏϣ ⲁϥϣⲉⲛϩⲏⲧ ϧⲁⲣⲱⲟⲩ ϫⲉ ⲛⲁⲩⲥⲱⲣⲉⲙ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲣⲟϫⲡ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲡⲓⲱⲥϧ ⲙⲉⲛ ⲟⲩⲛⲓϣϯ ⲡⲉ ⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⲇⲉ ϩⲁⲛⲕⲟⲩϫⲓ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ⲧⲱⲃϩ ⲟⲩⲛ ⳿ⲙⲠ⳪ ⳿ⲙⲡⲓⲱⲥϧ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲛϩⲁⲛⲉⲣⲅⲁⲧⲏⲥ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲉϥⲱⲥϧ ");
INSERT INTO copcnt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲉϥ ⲓ̅ⲃ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲁϥϯⲉⲣϣⲓϣⲓ ⲛⲱⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ϩⲱⲥⲧⲉ ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϣⲱⲛⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲓⲁⲃⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","⳿ⲫⲣⲁⲛ ⲇⲉ ⳿ⲙⲡⲓ ⲓ̅ⲃ̅ ⳿ⲛⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲁⲓ ⲛⲉ ⲡⲓϩⲟⲩⲓⲧ ⲡⲉ Ⲥⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ⲡⲉϥⲥⲟⲛ Ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲉⲙ Ⲃⲁⲣⲑⲟⲗⲟⲙⲉⲟⲥ Ⲑⲱⲙⲁⲥ ⲛⲉⲙ Ⲙⲁⲧⲑⲉⲟⲥ ⲡⲓⲧⲉⲗⲱⲛⲏⲥ Ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲀⲗⲫⲉⲟⲥ ⲛⲉⲙ Ⲑⲁⲇⲇⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ⲥⲓⲙⲱⲛ ⲡⲓⲔⲁⲛⲁⲛⲉⲟⲥ ⲛⲉⲙ Ⲓⲟⲩⲇⲁⲥ ⲡⲓⲤ̇ⲕⲁⲣⲓⲱⲧⲏⲥ ⲫⲏⲉⲑⲛⲁⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ⲡⲁⲓ ⲓ̅ⲃ̅ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣϣⲉ ⳿ⲉ⳿ⲫⲙⲱⲓⲧ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⲛⲓⲤⲁⲙⲁⲣⲓⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲇⲉ ⲙⲁⲗⲗⲟⲛ ϩⲁ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲉⲧⲥⲱⲣⲉⲙ ⳿ⲛⲧⲉ ⳿ⲡⲏⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","⳿ⲉⲣⲉⲧⲉⲛⲙⲟϣⲓ ⲇⲉ ϩⲓⲱⲓϣ ⳿ⲉⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲁⲣⲓⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲙⲁⲧⲟⲩⲛⲟⲥⲟⲩ ⲛⲓⲕⲁⲕⲥⲉϩⲧ ⲙⲁⲧⲟⲩⲃⲱⲟⲩ ⲛⲓⲇⲉⲙⲱⲛ ϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲁⲣⲉⲧⲉⲛϭⲓ ⳿ⲛϫⲓⲛϫⲏ ⲙⲟⲓ ⳿ⲛϫⲓⲛϫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","⳿ⲙⲡⲉⲣⲭⲁ ⲛⲟⲩⲃ ⲛⲱⲧⲉⲛ ⲟⲩⲇⲉ ϩⲁⲧ ⲟⲩⲇⲉ ϩⲟⲙⲧ ϧⲉⲛ ⲛⲉⲧⲉⲛⲙⲟϫϧ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ⲟⲩⲇⲉ ⲡⲏⲣⲁ ⲛⲱⲧⲉⲛ ϩⲓ ⳿ⲫⲙⲱⲓⲧ ⲟⲩⲇⲉ ⳿ϣⲑⲏⲛ ⳿ⲥⲛⲟⲩϯ ⲟⲩⲇⲉ ⲑⲱⲟⲩ⳿ⲓ ⲟⲩⲇⲉ ⳿ϣⲃⲱⲧ ⲡⲓⲉⲣⲅⲁⲧⲏⲥ ⲅⲁⲣ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉϥ⳿ϧⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ϯⲃⲁⲕⲓ ⲇⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ ⲓⲉ ⲡⲓϯⲙⲓ ϣⲓⲛⲓ ⳿ⲛϧⲏⲧⲥ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲉⲙ⳿ⲡϣⲁ ⲟⲩⲟϩ ϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϣⲁⲧⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","⳿ⲉⲣⲉⲧⲉⲛⲛⲁϣⲉⲛⲱⲧⲉⲛ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⲙⲁⲧⲁⲓ⳿ⲉ ⲙⲟⲩϯ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⲙⲉⲛ ⳿ⲉⲡⲓⲏⲓ ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉⲧⲉⲛϩⲓⲣⲏⲛⲏ ⲉⲥ⳿ⲉ⳿ⲓ ⳿ⲉϫⲱϥ ⳿ⲉϣⲱⲡ ⲇⲉ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⲁⲛ ⲧⲉⲧⲉⲛϩⲓⲣⲏⲛⲏ ⲉⲥ⳿ⲉⲕⲟⲧⲥ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉⲛ⳿ϥⲛⲁϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲟϩ ⳿ⲉⲧⲉⲛ⳿ϥⲛⲁⲥⲱⲧⲉⲙ ⲁⲛ ⳿ⲛⲥⲁ ⲛⲉⲧⲉⲛⲥⲁϫⲓ ⳿ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲏⲓ ⲓⲉ ϯⲃⲁⲕⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲓⲉ ⲡⲓϯⲙⲓ ⲛⲉϩ ⳿ⲡϣⲱⲓϣ ⳿ⲛⲛⲉⲧⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲉⲩ⳿ⲉϯ⳿ⲁⲥⲟ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲤⲟⲇⲟⲙⲁ ⲛⲉⲙ Ⲅⲟⲙⲟⲣⲣⲁ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⳿⳿ⲉϩⲟⲧⲉ ϯⲃⲁⲕⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯⲟⲩⲱⲣⲡ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲉⲥⲱⲟⲩ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲱⲛϣ ϣⲱⲡⲓ ⲟⲩⲛ ⳿ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲥⲁⲃⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓϩⲟϥ ⳿ⲁⲕⲉⲣⲉⲟⲥ ⲇⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓ ϭⲣⲟⲙⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ⲙⲁϩⲑⲏⲧⲉⲛ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲓⲣⲱⲙⲓ ⲥⲉⲛⲁϯ ⲑⲏⲛⲟⲩ ⲅⲁⲣ ⳿ⲉϩⲁⲛⲙⲁ⳿ⲛϯϩⲁⲡ ⲟⲩⲟϩ ⲥⲉⲛⲁⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ⲉⲩ⳿ⲉ⳿ⲉⲛ ⲑⲏⲛⲟⲩ ⲇⲉ ⳿ⲛⲛⲓⲟⲩⲣⲱⲟⲩ ⲛⲉⲙ ⲛⲓϩⲏⲅⲉⲙⲱⲛ ⲉⲑⲃⲏⲧ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ⲛⲉⲙ ⲛⲓⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲩϣⲁⲛϯ ⲑⲏⲛⲟⲩ ⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϫⲉ ⲡⲱⲥ ⲓⲉ ⲟⲩ ⲡⲉ ⲧⲉⲧⲉⲛⲛⲁϫⲟϥ ⲥⲉⲛⲁϯ ⲅⲁⲣ ⲛⲱⲧⲉⲛ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲙⲫⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲥⲁϫⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","⳿ⲛⲑⲱⲧⲉⲛ ⲅⲁⲣ ⲁⲛ ⲡⲉⲑⲛⲁⲥⲁϫⲓ ⲁⲗⲗⲁ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲑⲛⲁⲥⲁϫⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","⳿ⲉⲣⲉ ⲟⲩⲥⲟⲛ ⲇⲉ ⲉϥ⳿ⲉϯ ⳿ⲛⲟⲩⲥⲟⲛ ⳿ⲉ⳿ⲫⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲟⲩⲓⲱⲧ ⲉϥ⳿ⲉϯ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ϩⲁⲛϣⲏⲣⲓ ⲧⲱⲟⲩⲛⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲟⲩⲓⲟϯ ⲉⲩ⳿ⲉϧⲟⲑⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϣⲱⲡⲓ ⲉⲩⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲟⲧϥ ϣⲁ ⳿ⲉⲃⲟⲗ ⲫⲁⲓ ⲡⲉⲑⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲩϣⲁⲛϭⲟϫⲓ ⳿ⲛⲥⲱⲧⲉⲛ ϧⲉⲛ ⲧⲁⲓⲃⲁⲕⲓ ⲫⲱⲧ ⳿ⲉⲕⲉⲟⲩ⳿ⲓ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉⲧⲉⲛⲫⲟϩ ⳿ⲉⲙⲉϣⲧ ⲛⲓⲃⲁⲕⲓ ⳿ⲛⲧⲉ Ⲡⲓ̅ⲥ̅ⲗ̅ ϣⲁⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","⳿ⲙⲙⲟⲛ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⲉϥⲟⲩⲟⲧ ⳿ⲉⲡⲉϥⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲇⲉ ⲟⲩⲃⲱⲕ ⲉϥⲟⲩⲟⲧ ⳿ⲉⲡⲉϥ⳪̅. ");
INSERT INTO copcnt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ⲕⲏⲛ ⳿ⲉⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲉϥⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲡⲓⲃⲱⲕ ⳿ⲛⲧⲉϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲉϥ⳪ ⲓⲥϫⲉ ⲡⲓⲛⲉⲃⲏⲓ ⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ⲡⲟⲥⲱ ⲙⲁⲗⲗⲟⲛ ⲛⲉϥⲣⲉⲙ⳿ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲟⲩⲛ ϧⲁⲧⲟⲩϩⲏ ⳿ⲙⲙⲟⲛ ⲡⲉⲧϩⲟⲃⲥ ⲅⲁⲣ ϫⲉ ⳿ϥⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⲡⲉⲧϩⲏ ⲡ ϫⲉ ⲥⲉⲛⲁ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ⲫⲏ ⳿ⲉϯϫⲱ ⳿ⲙⲙⲟϥ ⲛⲱⲧⲉⲛ ϧⲉⲛ ⳿ⲡⲭⲁⲕⲓ ⳿ⲁϫⲟϥ ϧⲉⲛ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲛⲉⲧⲉⲛⲙⲁϣϫ ϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ϩⲓϫⲉⲛ ⲛⲉⲧⲉ⳿ⲛϫ⳿ⲉⲛⲉⲫⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲫⲏⲉⲑⲛⲁϧⲱⲧⲉⲃ ⳿ⲙⲡⲉⲧⲉⲛⲥⲱⲙⲁ ⲧⲉⲧⲉⲛⲯⲩⲭⲏ ⲇⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϧⲟⲑⲃⲉⲥ ⳿ⲁⲣⲓϩⲟϯ ⲇⲉ ⳿ⲛⲑⲟϥ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉϯⲯⲩⲭⲏ ⲛⲉⲙ ⲡⲓⲥⲱⲙⲁ ⳿ⲉⲧⲁⲕⲱⲟⲩ ϧⲉⲛ ϯⲅⲉⲉⲛⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ⲙⲏ ϭⲁϫ ⲃ̅ ⲁⲛ ⳿ⲉⲧⲟⲩϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲁ ⲟⲩⲧⲉⲃⲓ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲛⲛⲉϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲁⲧϭⲛⲉ ⲡⲉⲧⲉϩⲛⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲛⲓⲕⲉϥⲱⲓ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲁⲫⲉ ⲥⲉⲏⲡ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲟⲩⲛ ⲧⲉⲧⲉⲛⲟⲩⲟⲧ ⲅⲁⲣ ⳿ⲉⲟⲩⲙⲏϣ ⳿ⲛϭⲁϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ϯⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ⳿ⲛⲏⲧϥ ϩⲱ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ϯⲛⲁϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ϩⲱ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","⳿ⲙⲡⲉⲣⲙⲉⲩⲓ ϫⲉ ⳿ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲛⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ⲁⲛ ⲁⲗⲗⲁ ⲟⲩⲥⲏϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ⲁⲓ⳿ⲓ ⲅⲁⲣ ⳿ⲉⲫⲉⲣϫ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲡⲉϥⲓⲱⲧ ⲟⲩⲟϩ ⲟⲩϣⲉⲣⲓ ⳿ⲉⲧⲉⲥⲙⲁⲩ ⲟⲩⲟϩ ⲟⲩϣⲉⲗⲉⲧ ⳿ⲉⲧⲉⲥϣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ⲟⲩⲟϩ ⲛⲉⲛϫⲁϫⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲛⲉ ⲛⲉϥⲣⲉⲙ⳿ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ⲫⲏⲉⲑⲙⲉⲓ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲓⲉ ⲧⲉϥⲙⲁⲩ ⳿ⲉϩⲟⲧⲉⲣⲟⲓ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲙⲙⲟⲓ ⲁⲛ ⲟⲩⲟϩ ⲫⲏⲉⲑⲙⲉⲓ ⳿ⲙⲡⲉϥϣⲏⲣⲓ ⲓⲉ ⲧⲉϥϣⲉⲣⲓ ⳿ⲉϩⲟⲧⲉⲣⲟⲓ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲙⲙⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ⲫⲏ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ ⲁⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲙⲙⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ⲫⲏ⳿ⲉⲧⲁϥϫⲓⲙⲓ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉϥ⳿ⲉⲧⲁⲕⲟⲥ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲧⲁⲕⲟ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉⲑⲃⲏⲧ ⲉϥ⳿ⲉϫⲉⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ⲫⲏⲉⲧϣⲱⲡ ⳿ⲙⲙⲱⲧⲉⲛ ⲁϥϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲁϥϣⲱⲡ ⳿ⲙⲫⲏ⳿ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ⲫⲏⲉⲧϣⲱⲡ ⳿ⲛⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲛⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥ⳿ⲉϭⲓ ⳿ⲙ⳿ⲫⲃⲉⲭⲉ ⳿ⲛⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⲫⲏⲉⲧϣⲱⲡ ⳿ⲛⲟⲩ⳿ⲑⲙⲏⲓ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲛⲟⲩ⳿ⲑⲙⲏⲓ ϥ⳿ⲉϭⲓ ⳿ⲙ⳿ⲫⲃⲉⲭⲉ ⳿ⲛⲟⲩ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁ⳿ⲧⲥⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⳿ⲛⲟⲩ⳿ⲁⲫⲟⲧ ⳿ⲙⲙⲱⲟⲩ ϩⲱϫ ⲙⲟⲛⲟⲛ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲛⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉϥⲧⲁⲕⲟ ⳿ⲛϫⲉ ⲡⲉϥⲃⲉⲭⲉ ");
INSERT INTO copcnt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ⲕⲏⲛ ⲉϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉⲧⲟⲧϥ ⳿ⲙⲡⲉϥ ⲓ̅ⲃ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲉⲑⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϩⲓⲱⲓϣ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲛⲟⲩⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ⲓⲱⲁⲛⲛⲏⲥ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲉϥⲭⲏ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲉⲑⲃⲉ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲃ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ϣⲁⲛ ⳿ⲛⲧⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⳿ⲛⲕⲉⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲙⲁⲧⲁⲙⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ϫⲉ ⲛⲓⲃⲉⲗⲗⲉⲩ ⲥⲉⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲛⲓϭⲁⲗⲉⲩ ⲥⲉⲙⲟϣⲓ ⲛⲓⲕⲁⲕⲥⲉϩⲧ ⲥⲉⲧⲟⲩⲃⲏⲟⲩⲧ ⲛⲓⲕⲟⲩⲣ ⲥⲉⲥⲱⲧⲉⲙ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲥⲉⲧⲱⲟⲩⲛⲟⲩ ⲛⲓϩⲏⲕⲓ ⲥⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ⲟⲩⲟϩ ⳿ⲱⲟⲩⲛⲓⲁⲧϥ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲁⲛ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ⲛⲁⲓ ⲇⲉ ⲉⲩⲛⲁϣⲉⲛⲱⲟⲩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲟⲥ ⳿ⲛⲛⲓⲙⲏϣ ⲉⲑⲃⲉ Ⲓⲱⲁⲛⲛⲏⲥ ϫⲉ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ⲡϣⲁϥⲉ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ ⳿ⲉⲟⲩⲕⲁϣ ⳿ⲉⲣⲉ ⲡⲓⲑⲏⲟⲩ ⲕⲓⲙ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ⲁⲗⲗⲁ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⲉϥⲭⲏ ϧⲉⲛ ϩⲁⲛϭⲓ⳿ϩⲃⲱⲥ ⳿ⲛϫⲁⲛⲏ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲁ ⲛⲓ⳿ϩⲃⲱⲥ ⳿ⲛϫⲁⲛⲏ ⲥⲉⲭⲏ ϧⲉⲛ ⲛⲉⲛⲏⲟⲩ ⳿ⲛⲛⲓⲟⲩⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ⲁⲗⲗⲁ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲁϩⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩϩⲟⲩ⳿ⲟ ⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ⲫⲁⲓ ⲅⲁⲣ ⲫⲏⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧϥ ϫⲉ ϩⲏⲡⲡⲉ ϯⲛⲁⲟⲩⲱⲣⲡ ⳿ⲙⲡⲁⲁⲅⲅⲉⲗⲟⲥ ϧⲁϫⲱⲕ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲥⲟⲃϯ ⳿ⲙⲡⲉⲕⲙⲱⲓⲧ ⳿ⲙⲡⲉⲕ⳿ⲙⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲉ ⲟⲩⲟⲛ ⲧⲱⲛϥ ϧⲉⲛ ⲛⲓⲙⲓⲥⲓ ⳿ⲛⲧⲉ ⲛⲓϩⲓ⳿ⲟⲙⲓ ⳿ⲉⲛⲁⲁϥ ⳿ⲉⲒⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲡⲓⲕⲟⲩϫⲓ ⲇⲉ ⳿ⲉⲣⲟϥ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲛⲓϣϯ ⳿ⲉⲣⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ⲓⲥϫⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲥⲉϭⲓ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ϩⲁⲛⲣⲉϥϭⲓ ⳿ⲛϫⲟⲛⲥ ⲉⲧϩⲱⲗⲉⲙ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲅⲁⲣ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲡⲓⲛⲟⲙⲟⲥ ⲁⲩⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ϣⲁ Ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ⲟⲩⲟϩ ⲓⲥϫⲉ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲉϣⲟⲡϥ ⳿ⲛⲑⲟϥ ⲡⲉ Ⲏ̇ⲗⲓⲁⲥ ⲉⲑⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ⲁⲓⲛⲁⲧⲉⲛⲑⲱⲛ ⲧⲁⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⲇⲉ ⳿ⲉⲛⲓⲙ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϩⲁⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲉⲩϩⲉⲙⲥⲓ ϩⲓ ⲛⲓ⳿ⲁⲅⲟⲣⲁ ⲛⲁⲓ ⲉⲑⲙⲟⲩϯ ⲟⲩⲃⲉ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛϫⲱ ⳿ⲉⲣⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛϭⲟⲥϫⲉⲥ ⲁⲛⲣⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲛⲉϩⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ⲁϥ⳿ⲓ ⲅⲁⲣ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲛ⳿ϥⲟⲩⲱⲙ ⲁⲛ ⲟⲩⲟϩ ⳿ⲛ⳿ϥⲥⲱ ⲁⲛ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⲉϥⲥⲱ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲥⲁⲩⲏⲣⲡ ⳿ⲡ⳿ϣⲫⲏⲣ ⲡⲉ ⳿ⲛⲧⲉ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲟⲩⲟϩ ⲁⲥ⳿ⲑⲙⲁⲓ⳿ⲟ ⳿ⲛϫⲉ ϯⲥⲟⲫⲓ⳿ⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲥ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ⲧⲟⲧⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲭⲟϩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓⲃⲁⲕⲓ ⲛⲏ⳿ⲉⲧⲁ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲛⲛⲉϥϫⲟⲙ ϣⲱⲡⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ⲟⲩⲟⲓ ⲛⲉ Ⲭⲟⲣⲁⲍⲓⲛ ⲟⲩⲟⲓ ⲛⲉ Ⲃⲏⲑⲥⲁ⳿ⲓⲇⲁ ϫⲉ ⳿⳿ⲉⲛⲉ ⳿ⲁ ⲛⲁⲓϫⲟⲙ ϣⲱⲡⲓ ϧⲉⲛ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲤⲓⲇⲱⲛ ⳿ⲉⲧⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲉ ⲓⲥ⳿ⲑⲛⲉⲓ ⲡⲉ ⲁⲩⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ϧⲉⲛ ⲟⲩⲥⲟⲕ ⲛⲉⲙ ⲟⲩⲕⲉⲣⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","⳿ⲡⲗⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲤⲓⲇⲱⲛ ⲉⲩ⳿ⲉϯ⳿ⲁⲥⲟ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⳿ⲉϩⲟⲧⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ⲛⲉⲙ ⳿ⲛⲑⲟ ϩⲱⲓ Ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲙⲏ ⲧⲉⲣⲁϭⲓⲥⲓ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲉⲩ⳿ⲉⲑⲉⲃⲓ⳿ⲟ ϣⲁ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲁⲙⲉⲛϯ ϫⲉ ⳿⳿ⲉⲛⲉ ϧⲉⲛ Ⲥⲟⲇⲟⲙⲁ ⲁⲩϣⲱⲡⲓ ⳿ⲛϫⲉ ⲛⲁⲓϫⲟⲙ ⳿ⲉⲧⲁⲩϣⲱⲡⲓ ⳿ⲛϧⲏϯ ⲛⲉ ⲓⲥϫⲉⲕ ⲥⲉϣⲟⲡ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","⳿ⲡⲗⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲡⲕⲁϩⲓ ⳿ⲛⲤⲟⲇⲟⲙⲁ ⲉⲩ⳿ⲉϯ⳿ⲁⲥⲟ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⳿ⲉϩⲟⲧⲉⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϯⲟⲩⲱⲛϩ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ Ⲫ̇ⲓⲱⲧ Ⲡ⳪ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ϫⲉ ⲁⲕϩⲉⲡ ⲛⲁⲓ ⳿ⲉϩⲁⲛⲥⲁⲃⲉⲩ ⲛⲉⲙ ϩⲁⲛⲕⲁⲧϩⲏ ⲧ ⲟⲩⲟϩ ⲁⲕϭⲟⲣⲡⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","⳿ⲁϩⲁ Ⲫ̇ⲓⲱⲧ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓϯⲙⲁϯ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲡⲉⲕ⳿ⲙⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲁ Ⲫ̇ⲓⲱⲧ ⲧⲏⲓⲧⲟⲩ ⳿ⲉⲧⲟⲧ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲥⲱⲟⲩⲛ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲪ̇ⲓⲱⲧ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲥⲱⲟⲩⲛ ⳿ⲙⲪ̇ⲓⲱⲧ ⳿ⲉⲃⲏⲗ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⲛⲉⲙ ⲫⲏ⳿ⲉⲧⲉϩⲛⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲉϭⲱⲣⲡ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","⳿ⲁⲙⲱⲓⲛⲓ ϩⲁⲣⲟⲓ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϧⲟⲥⲓ ⲟⲩⲟϩ ⲉⲧⲟⲡⲧ ϧⲁ ⲛⲟⲩⲉⲧⲫⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁϯ⳿ⲙⲧⲟⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲁⲛⲁϩⲃⲉϥ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲉⲙⲣⲁⲩϣ ⲟⲩⲟϩ ϯⲑⲉⲃⲓⲏⲟⲩⲧ ϧⲉⲛ ⲡⲁϩⲏⲧ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲟⲩⲙⲁⲛⲉⲙⲧⲟⲛ ⳿ⲛⲛⲉⲧⲉⲛⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ⲡⲁⲛⲁϩⲃⲉϥ ⲅⲁⲣ ⳿ϥϩⲟⲗϫ ⲟⲩⲟϩ ⲧⲁⲉⲧⲫⲱ ⳿ⲁⲥⲓ⳿ⲱⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲣⲟϯ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲛⲉ ⲁⲩ⳿ϩⲕⲟ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲥⲱⲗⲡ ⳿ⲛⲥⲁ ⲛⲓϧⲉⲙⲥ ⳿ⲉⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲓⲥ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲥⲉ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲁⲓϥ ⲁⲛ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲁ Ⲇⲁⲩⲓⲇ ⲁⲓϥ ⳿ⲉⲧⲁϥ⳿ϩⲕⲟ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ⲡⲱⲥ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲪϯ ⲟⲩⲟϩ ⲛⲓⲱⲓⲕ ⳿ⲛⲧⲉ ϯ⳿ⲡⲣⲟⲑⲉⲥⲓⲥ ⲁϥⲟⲩ⳿ⲟⲙⲟⲩ ⲛⲏ⳿ⲉⲧⲉⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⲛⲁϥ ⲁⲛ ⲡⲉ ⳿ⲉⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲇⲉ ⲛⲏⲉⲑⲛⲉⲙⲁϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲓⲟⲩⲏⲃ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ⲁⲛ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ϫⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲓⲟⲩⲏⲃ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲥⲉⲥⲱϥ ⳿ⲙⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲛⲟⲃⲓ ϭⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲓⲥ ϩⲟⲩ⳿ⲟ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⳿ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","⳿ⲉⲛⲁⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉ ⲟⲩⲛⲁⲓ ⲡⲉ ϯⲟⲩⲁϣϥ ⲟⲩⲟϩ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⲁⲛ ⲛⲁⲣⲉⲧⲉⲛⲛⲁϯϩⲁⲡ ⲁⲛ ⲡⲉ ⳿ⲉⲛⲓⲁⲑⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ⲡ⳪ ⲅⲁⲣ ⳿ⲙⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲣⲉ ⲧⲉϥϫⲓϫ ϣⲟⲩ⳿ⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛ ⳿ⲥϣⲉ ⳿ⲛⲉⲣⲫⲁϧⲣⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⳿ⲛⲣⲱⲙⲓ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲧⲉ ⲟⲩⲟⲛⲧⲉϥ ⲟⲩ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲫⲁⲓ ϩⲉⲓ ⳿ⲉⲟⲩϣⲓⲕ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲙⲏ ⳿ϥⲛⲁ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲛⲧⲉϥⲧⲟⲩⲛⲟⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ⲓⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ϫⲉ ⲟⲩⲟⲧ ⳿ⲉⲟⲩ⳿ⲉⲥⲱⲟⲩ ⳿ⲛⲁⲩⲏⲣ ϩⲱⲥⲧⲉ ⳿ⲥϣⲉ ⳿ⲛⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ϫⲉ ⲥⲟⲩⲧⲉⲛ ⲧⲉⲕϫⲓϫ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲥⲟⲩⲧⲱⲛⲥ ⲟⲩⲟϩ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϯⲭⲉϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁⲩⲉⲣⲟⲩⲥⲟϭⲛⲓ ϧⲁⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲟⲩⲟϩ ϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ϣⲧⲉⲙⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲎ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲁ⳿ⲁⲗⲟⲩ ⲫⲏ⳿ⲉⲧⲁϥⲣⲁⲛⲏⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⲫⲏ⳿ⲉⲧⲁ ⲧⲁⲯⲩⲭⲏ ϯⲙⲁϯ ⳿ⲛϧⲏⲧϥ ⲉⲓ⳿ⲉⲭⲱ ⳿ⲙⲡⲁⲡ͞ⲛⲁ̅ ϩⲓϫⲱϥ ⲉϥ⳿ⲉⲧⲁⲙⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲩϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","⳿ⲛⲛⲉϥ⳿ϣϭⲛⲏⲛ ⲟⲩⲇⲉ ⳿ⲛⲛⲉϥⲱϣ ⳿ⲉⲃⲟⲗ ⲟⲩⲇⲉ ⳿ⲛⲛⲉ ⲟⲩⲁⲓ ⲥⲱⲧⲉⲙ ⳿ⲉⲧⲉϥ⳿ⲥⲙⲏ ϧⲉⲛ ⲛⲓ⳿ⲡⲗⲁⲧⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ⲟⲩⲕⲁϣ ⲉϥϧⲉⲙϧⲱⲙ ⳿ⲛⲛⲉϥⲕⲁϣϥ ⲟⲩⲟϩ ⲟⲩⲥⲟⲗ ⲉϥⲟⲓ ⳿ⲛ⳿ⲭⲣⲉⲙⲧⲥ ⳿ⲛⲛⲉϥϭⲉⲛⲟϥ ϣⲁⲧⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓϩⲁⲡ ⲉⲩϭⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ⲟⲩⲟϩ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲩ⳿ⲉⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲉϥⲟⲓ ⳿ⲛ⳿ⲉⲃⲟ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟϥ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲉⲃⲟ ⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ⲛⲁⲩⲧⲱⲙⲧ ⲇⲉ ⲧⲏⲣⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲁⲣⲉ ⲫⲁⲓ ϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲁⲛ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ϧⲉⲛ Ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲟⲩⲙⲟⲕⲙⲉⲕ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲛⲓⲃⲉⲛ ⲁⲥϣⲁⲛⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁⲥ ⳿ⲙⲙⲁⲩⲁⲧⲥ ϣⲁⲥϣⲱϥ ⲟⲩⲟϩ ⲃⲁⲕⲓ ⲛⲓⲃⲉⲛ ⲓⲉ ⲏⲓ ⲛⲓⲃⲉⲛ ⲁⲩϣⲁⲛⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⳿ⲙⲡⲁⲩ⳿ϣ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ⲟⲩⲟϩ ⲓⲥϫⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲡⲉⲧϩⲓⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲉⲃⲟⲗ ⲓⲉ ⲁⲩⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲡⲱⲥ ⲟⲩⲛ ⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ ⲛⲁ⳿ϣ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ⲟⲩⲟϩ ⲓⲥϫⲉ ⳿ⲁⲛⲟⲕ ϧⲉⲛ Ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ϯϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲓⲉ ⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲙ ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲛⲑⲱⲟⲩ ⲉⲩ⳿ⲉⲉⲣⲣⲉϥϯϩⲁⲡ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ⲓⲥϫⲉ ⲇⲉ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲁⲛⲟⲕ ϯϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲁ ⲁⲥⲫⲟϩ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ⲓⲉ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓϫⲱⲣⲓ ⳿ⲛⲧⲉϥϩⲱⲗⲉⲙ ⳿ⲛⲛⲉϥ⳿ⲥⲕⲉⲩⲟⲥ ⲁϥ⳿ϣⲧⲉⲙⲥⲱⲛϩ ⳿ⲙⲡⲓϫⲱⲣⲓ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⳿ⲛⲧⲉϥϩⲱⲗⲉⲙ ⳿ⲙⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ⲫⲏ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲉⲙⲏⲓ ⲁⲛ ⲁϥϯⲟⲩⲃⲏⲓ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲉⲣⲥⲩⲛⲁⲅⲉⲥⲑⲉ ⲛⲉⲙⲏⲓ ⲁⲛ ⳿ϥϫⲱⲣ ⳿ⲙⲙⲟⲓ ⳿ⲉⲃⲟⲗ Ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲛⲛⲟⲩⲭⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ⲉⲑⲃⲉ ⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲛⲟⲃⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ϫⲉⲟⲩ⳿ⲁ ⲛⲓⲃⲉⲛ ⲉⲩ⳿ⲉⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲡⲓϫⲉⲟⲩ⳿ⲁ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ⲛⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϫⲉ ⲟⲩⲥⲁϫⲓ ⳿ⲛⲥⲁ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉⲩ⳿ⲉⲭⲁϥ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲱ ϧⲁ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲛⲛⲟⲩⲭⲱ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲇⲉ ϧⲉⲛ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ ⲟⲩⲇⲉ ϧⲉⲛ ⲡⲉⲑⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ⲓⲉ ⳿ⲁⲣⲓ ⲡⲓ⳿ϣϣⲏⲛ ⲉⲑⲛⲁⲛⲉϥ ⲛⲉⲙ ⲡⲉϥⲟⲩⲧⲁϩ ⲉⲑⲛⲁⲛⲉϥ ⲓⲉ ⳿ⲁⲣⲓ ⲡⲓ⳿ϣϣⲏⲛ ⲉⲧϩⲱⲟⲩ ⲛⲉⲙ ⲡⲉϥⲟⲩⲧⲁϩ ⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲅⲁⲣ ϧⲉⲛ ⲡⲓⲟⲩⲧⲁϩ ϣⲁⲩⲥⲟⲩⲉⲛ ⲡⲓ⳿ϣϣⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ⲛⲓⲙⲓⲥⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲁϫⲱ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲥⲁϫⲓ ⳿ⲛϩⲁⲛⲡⲉⲑⲛⲁⲛⲉϥ ⳿ⲉⲣⲉⲧⲉⲛϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲅⲁⲣ ϧⲉⲛ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲙⲡⲓϩⲏⲧ ϣⲁⲣⲉ ⲡⲓⲣⲱ ⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ⲡⲓ⳿ⲁⲅⲁⲑⲟⲥ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉϥ⳿ⲁϩⲟ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲛ ϣⲁϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲙⲡⲓ⳿ⲁⲅⲁⲑⲟⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲓⲣⲱⲙⲓ ⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉϥ⳿ⲁϩⲟ ⲉⲧϩⲱⲟⲩ ϣⲁϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲥⲁϫⲓ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲩⲓⲧ ⳿ⲉⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲁϫⲟⲧⲟⲩ ⲥⲉⲛⲁϯ ⲗⲟⲅⲟⲥ ϧⲁⲣⲱⲟⲩ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲓⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","⳿ⲉⲃⲟⲗ ⲅⲁⲣ ϧⲉⲛ ⲛⲉⲕⲥⲁϫⲓ ⲉⲕ⳿ⲉⲙⲁⲓ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉⲕⲥⲁϫⲓ ⲉⲩ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ⲧⲟⲧⲉ ⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲉⲛⲟⲩⲱϣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲧⲟⲧⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲓϫⲱⲟⲩ ⲉⲧϩⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲛⲱⲓⲕ ⳿ϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⲟⲩⲟϩ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲛⲟⲩⲧⲏⲓϥ ⲛⲁϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ Ⲓⲱⲛⲁ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲛⲒⲱⲛⲁ ⳿ⲉⲛⲁϥ ϧⲉⲛ ⳿ⲑⲛⲉϫⲓ ⳿ⲙⲡⲓⲕⲏⲧⲟⲥ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲅ̅ ⳿ⲛ⳿ⲉϫⲱⲣϩ ⲡⲁⲓⲣⲏϯ ϩⲱϥ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥ⳿ⲉⲉⲣ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲅ̅ ⳿ⲛ⳿ⲉϫⲱⲣϩ ϧⲉⲛ ⳿ⲡϩⲏⲧ ⳿ⲙ⳿ⲡⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲧⲉ Ⲛⲓⲛⲉⲩ⳿ⲏ ⲉⲩ⳿ⲉⲧⲱⲟⲩⲛⲟⲩ ϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⲛⲉⲙ ⲡⲁⲓϫⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲟϥ ϫⲉ ⲁⲩⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⳿ⲉⲡⲓϩⲓⲱⲓϣ ⳿ⲛⲧⲉ Ⲓⲱⲛⲁ ⲟⲩⲟϩ ⲓⲥ ϩⲟⲩ⳿ⲟ ⳿ⲉⲒⲱⲛⲁ ⳿ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ϯⲟⲩⲣⲱ ⳿ⲛⲧⲉ Ⲥⲁⲣⲏⲥ ⲉⲥ⳿ⲉⲧⲱⲛⲥ ϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⲛⲉⲙ ⲡⲁⲓϫⲱⲟⲩ ⲟⲩⲟϩ ⲉⲥ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲟϥ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉⲁⲧ ⳿ⲙ⳿ⲡⲕⲁϩⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉϯⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲥⲟⲗⲟⲙⲱⲛ ⲟⲩⲟϩ ⲓⲥ ϩⲟⲩ⳿ⲟ ⳿ⲉⲤⲟⲗⲟⲙⲱⲛ ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲣⲱⲙⲓ ϣⲁϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗ ⳿ⲉϩⲁⲛⲙⲁ ⳿ⲛⲁⲑⲙⲱⲟⲩ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲙⲁⲛⲉⲙⲧⲟⲛ ⲟⲩⲟϩ ⳿ⲙⲡⲁϥϫⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ⲧⲟⲧⲉ ϣⲁϥϫⲟⲥ ϫⲉ ⲉⲓ⳿ⲉⲧⲁⲥⲑⲟ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲁⲏⲓ ⲡⲓⲙⲁ ⳿ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ⳿ⲛⲏⲧϥ ⲟⲩⲟϩ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛⲧⲉϥϫⲉⲙϥ ⲉϥ⳿ⲥⲣⲱϥⲧ ⲉϥⲥⲁⲣϩ ⲟⲩⲟϩ ⲉϥⲥⲉⲗⲥⲱⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ⲧⲟⲧⲉ ϣⲁϥϣⲉⲛⲁϥ ⳿ⲛⲧⲉϥϭⲓ ⲛⲉⲙⲁϥ ⳿ⲛⲕⲉⲍ̅ ⳿ⲙⲡ͞ⲛⲁ̅ ⲉⲩϩⲱⲟⲩ ⳿ⲉϩⲟⲧⲉⲣⲟϥ ⲟⲩⲟϩ ϣⲁϥ⳿ⲓ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓϧⲁⲉⲩ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲧϩⲟ ⲛⲁϥ ⳿⳿ⲉⲛⲉϥϩⲟⲩⲁϯ ⲡⲁⲓⲣⲏϯ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲙⲡⲁⲓϫⲱⲟⲩ ⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ϩⲱⲥⲧⲉ ⲉϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓⲙⲏϣ ⲓⲥ ⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲥⲁⲃⲟⲗ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲉⲥⲁϫⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲧⲉⲕⲙⲁⲩ ⲛⲉⲙ ⲛⲉⲕ⳿ⲥⲛⲏⲟⲩ ⲥⲁⲃⲟⲗ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲛⲓⲙ ⲧⲉ ⲧⲁⲙⲁⲩ ⲓⲉ ⲛⲓⲙ ⲛⲉ ⲛⲁ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ϫⲉ ⲏⲡⲡⲉ ⲓⲥ ⲧⲁⲙⲁⲩ ⲛⲉⲙ ⲛⲁ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲉⲣⲡⲉⲧⲉϩⲛⲉ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲑⲟϥ ⲡⲉ ⲡⲁⲥⲟⲛ ⲛⲉⲙ ⲧⲁⲥⲱⲛⲓ ⲛⲉⲙ ⲁⲙⲁⲩ ");
INSERT INTO copcnt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲏⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥϩⲉⲙⲥⲓ ⲡⲉ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ⲟⲩⲟϩ ⲁⲩⲑⲱⲟⲩϯ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⳿ⲛⲧⲉϥϩⲉⲙⲥⲓ ⲡⲓⲙⲏϣ ⲇⲉ ⲧⲏⲣϥ ⲛⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ⲟⲩⲟϩ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲛϩⲁⲛⲙⲏϣ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϩⲏⲡⲡⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲥⲓϯ ⳿ⲉⲥⲓϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉϥⲥⲓϯ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲁⲩϩⲉⲓ ⳿ⲉ⳿ⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓϩⲁⲗⲁϯ ⲟⲩⲟϩ ⲁⲩⲟⲩ⳿ⲟⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ ⳿ⲙⲡⲉⲧⲣⲁ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛ ϣⲱⲕ ⳿ⲛⲕⲁϩⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲩⲣⲱⲧ ⲥⲁⲧⲟⲧⲟⲩ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ϣⲱⲕ ⳿ⲛⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","⳿ⲉⲧⲁ ⳿ⲫⲣⲏ ⲇⲉ ϣⲁⲓ ⲁⲩⲉⲣⲕⲁⲩⲙⲁ ⲟⲩⲟϩ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲩⲛⲓ ⳿ⲙⲙⲁⲩ ⲁⲩϣⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩϩⲉⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲥⲟⲩⲣⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲥⲁ ⳿ⲡϣⲱⲓ ⳿ⲛϫⲉ ⲛⲓⲥⲟⲩⲣⲓ ⲟⲩⲟϩ ⲁⲩⲟϫϩⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲁⲩϯⲟⲩⲧⲁϩ ⲟⲩⲁⲓ ⲙⲉⲛ ⲁϥⲉⲣ ⲣ̅ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲁϥⲉⲣ ⲝ̅ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲁϥⲉⲣ ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲕⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲧⲉⲥⲧⲟⲓ ⲛⲱⲧⲉⲛ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉⲛⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲛⲏ ⲇⲉ ⳿ⲙⲡⲟⲩⲧⲏⲓⲥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ⲫⲏ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲟⲩⲟⲛⲧⲁϥ ⲉⲩ⳿ⲉϯ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲟϥ ⲫⲏ ⲇⲉ ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲁϥ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛⲧⲟⲧϥ ⲉⲩ⳿ⲉⲟⲗϥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ⲉⲑⲃⲉ ⲫⲁⲓ ϯⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ϫⲉⲟⲩⲏⲓ ⲉⲩⲛⲁⲩ ⳿ⲛⲥⲉⲛⲁⲩ ⲁⲛ ⲟⲩⲟϩ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲉⲥⲱⲧⲉⲙ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛⲥⲉⲕⲁϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ⲟⲩⲟϩ ⲉⲥ⳿ⲉϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ϯ⳿ⲡⲣⲟⲫⲏⲧⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲏ̇ⲥⲁ⳿ⲏⲁⲥ ⲑⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϧⲉⲛ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲛⲉⲧⲉⲛⲕⲁϯ ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩⲛⲁⲩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲛⲉⲧⲉⲛⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ⲁϥⲟⲩⲙⲟⲧ ⲅⲁⲣ ⳿ⲛϫⲉ ⳿ⲡϩⲏⲧ ⳿ⲙⲡⲁⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⲁⲩ⳿ϩⲣⲟϣ ϧⲉⲛ ⲛⲟⲩⲙⲁϣϫ ⳿ⲉ⳿ⲡⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲁⲩⲙⲁϣⲑⲁⲙ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲥⲉⲛⲁⲩ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲥⲱⲧⲉⲙ ϧⲉⲛ ⲛⲟⲩⲙⲁϣϫ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲕⲁϯ ϧⲉⲛ ⲡⲟⲩϩⲏ ⲧ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲕⲟⲧⲟⲩ ⳿ⲛⲧⲁⲧⲟⲩϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲱⲟⲩⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲉⲧⲉⲛⲃⲁⲗ ϫⲉ ⲥⲉⲛⲁⲩ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲙⲁϣϫ ϫⲉ ⲥⲉⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲁⲛⲙⲏϣ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ϩⲁⲛ⳿ⲑⲙⲏⲓ ⲁⲩⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲛⲁⲩ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","⳿ⲛⲑⲱⲧⲉⲛ ⲟⲩⲛ ⲥ ⲱⲧⲉⲙ ⳿ⲉϯⲡⲁⲣⲁⲃⲟⲗⲏ ⳿ⲛⲧⲉ ⲫⲏⲉⲧⲥⲓϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⳿ⲉⲧⲉ ⳿ⲛ⳿ϥⲕⲁϯ ⳿ⲉⲣⲟϥ ⲁⲛ ϣⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲟⲩⲟϩ ϣⲁϥϩⲱⲗⲉⲙ ⳿ⲙⲫⲏ⳿ⲉⲧⲁⲩⲥⲁⲧϥ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ⲫⲁⲓ ⲡⲉ ⲫⲏ⳿ⲉⲧⲁϥⲥⲁⲧϥ ⳿ⲉ⳿ⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲁⲧϥ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ ⳿ⲙⲡⲉⲧⲣⲁ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⳿ϥϭⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","⳿ⲙⲙⲟⲛⲧⲉϥ ⲛⲟⲩⲛⲓ ⲇⲉ ⳿ⲛϧⲏⲧϥ ⲁⲗⲗⲁ ⲟⲩ⳿ⲡⲣⲟⲥ ⲟⲩⲥⲏⲟⲩ ⲡⲉ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩϩⲟϫϩⲉϫ ⲇⲉ ϣⲱⲡⲓ ⲓⲉ ⲟⲩⲇⲓⲱⲅⲙⲟⲥ ⲉⲑⲃⲉ ⲡⲓⲥⲁϫⲓ ⲥⲁⲧⲟⲧϥ ϣⲁϥⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲁⲧϥ ⳿ⲉϫⲉⲛ ⲛⲓⲥⲟⲩⲣⲓ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲫⲣⲱⲟⲩϣ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ ⲛⲉⲙ ϯ⳿ⲁⲡⲁⲧⲏ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ϣⲁⲩⲱϫϩ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ϣⲁϥⲉⲣⲁⲧⲟⲩⲧⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲉⲧⲕⲁϯ ⳿ⲉⲣⲟϥ ⲫⲁⲓ ⲇⲉ ϣⲁϥϯⲟⲩⲧⲁϩ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⲙⲉⲛ ϣⲁϥⲉⲣ ⲣ̅ ⲟⲩⲁⲓ ⲇⲉ ϣⲁϥⲉⲣ ⲝ̅ ⲟⲩⲁⲓ ⲇⲉ ϣⲁϥⲉⲣ ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ⲁϥⲭⲱ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲕⲉ ⲡⲁⲣⲁⲃⲟⲗⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁϥⲥⲉⲧ ⲟⲩ⳿ϫⲣⲟϫ ⲉⲑⲛⲁⲛⲉϥ ϧⲉⲛ ⲡⲉϥⲓⲟϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","⳿ⲉⲧⲁⲩⲉⲛⲕⲟⲧ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲉϥϫⲁϫⲓ ⲁϥⲥⲓϯ ⳿ⲛϩⲁⲛⲉⲛⲧⲏϫ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲙⲡⲓⲥⲟⲩ⳿ⲟ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁϥⲣⲱⲧ ⳿ⲛϫⲉ ⲡⲓⲥⲟⲩ⳿ⲟ ⲟⲩⲟϩ ⲁϥϯⲟⲩⲧⲁϩ ⲧⲟⲧⲉ ⲁⲩⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲉⲛⲧⲏϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲛⲧⲉ ⲡⲓⲛⲉⲃⲓⲟϩⲓ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲡⲉⲛ⳪ ⲙⲏ ⲟⲩ⳿ϫⲣⲟϫ ⳿ⲉⲛⲁⲛⲉϥ ⲁⲛ ⲡⲉⲧⲁⲕⲥⲁⲧϥ ϧⲉⲛ ⲡⲉⲕⲓⲟϩⲓ ⳿ⲉⲧⲁϥϫⲓⲙⲓ ⲟⲩⲛ ⳿ⲛⲛⲁⲓⲕⲉⲉⲛⲧⲏϫ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩϫⲁϫⲓ ⳿ⲛⲣⲱⲙⲓ ⲡⲉⲧⲁϥⲉⲣ ⲫⲁⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲁⲛ ⳿ⲭⲟⲩⲱϣ ⳿ⲛⲧⲉⲛϣⲉⲛⲁⲛ ⳿ⲛⲧⲉⲛⲥⲟⲕⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲉⲣⲉⲧⲉⲛⲥⲱⲕⲓ ⳿ⲛⲛⲓⲉⲛⲧⲏϫ ⳿ⲛⲧⲉⲧⲉⲛϥⲱϫⲓ ⳿ⲙⲡⲓⲕⲉⲥⲟⲩ⳿ⲟ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ⲁⲗⲗⲁ ⲭⲁⲩ ⲙⲁⲣⲟⲩⲣⲱⲧ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϣⲁ ⳿ⲡⲥⲏⲟⲩ ⳿ⲙ⳿ⲡⲱⲥϧ ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ⳿ⲙ⳿ⲡⲱⲥϧ ⲉⲓ⳿ⲉϫⲟⲥ ⳿ⲛⲛⲓϭⲁⲓⲱⲥϧ ϫⲉ ⲥⲱⲕⲓ ⳿ⲛⲛⲓⲉⲛⲧⲏϫ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲙⲟⲣⲟⲩ ⳿ⲛϩⲁⲛⲙⲏ⳿ⲓⲣⲓ ⳿ⲉ⳿ⲡⲣⲟⲕϩⲟⲩ ϧⲉⲛ ⲡⲓ⳿ⲭⲣⲱⲙ ⲡⲓⲥⲟⲩ⳿ⲟ ⲇⲉ ⲑⲟⲩⲱⲧϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲁ⳿ⲁⲡⲟⲑⲏⲕⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ⲁϥⲭⲱ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲕⲉⲡⲁⲣⲁⲃⲟⲗⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲛⲁⲫⲣⲓ ⳿ⲛϣⲉⲗⲧⲁⲙ ⳿ⲁ ⲟⲩⲣⲱⲙⲓ ϭⲓⲧⲥ ⲁϥⲥⲁⲧⲥ ϧⲉⲛ ⲡⲉϥⲓⲟϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","⳿ⲉⲟⲩⲕⲟⲩϫⲓ ⲙⲉⲛ ⲧⲉ ⳿ⲉⲃⲟⲗ ⲟⲩⲧⲉ ⲛⲓ⳿ϫⲣⲱϫ ⲧⲏⲣⲟⲩ ⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲥϣⲁⲛⲁⲓⲁⲓ ⳿ⲥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲛⲛⲓⲟⲩ⳿ⲟϯ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ϣⲁⲥϣⲱⲡⲓ ⳿ⲉⲟⲩ⳿ϣϣⲏⲛ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⳿ⲛⲥⲉⲟⲩⲱϩ ⳿ⲉϫⲉⲛ ⲛⲉⲥϫⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ⲕⲉ ⲡⲁⲣⲁⲃⲟⲗⲏ ⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩϣⲉⲙⲏⲣ ⳿ⲉ⳿ⲁⲟⲩ⳿ⲥϩⲓⲙⲓ ϭⲓⲧϥ ⲁⲥⲭⲟⲡϥ ϧⲉⲛ ⲅ̅ ⳿ⲛϣⲓ ⳿ⲛⲛⲱⲓⲧ ϣⲁⲧⲉ ⲡⲓϣⲱϯ ⲧⲏⲣϥ ϭⲓϣⲉⲙⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ϫⲟⲧⲟⲩ ⳿ⲛⲛⲓⲙⲏϣ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲟⲩⲟϩ ⲭⲱⲣⲓⲥ ⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓⲛⲁⲟⲩⲱⲛ ⳿ⲛⲣⲱⲓ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲥⲁϫⲓ ⳿ⲛⲛⲏⲉⲧϩⲏ ⲡ ⲓⲥϫⲉⲛ ⳿ⲧⲕⲁⲧⲁⲃⲟⲗⲏ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ⲧⲟⲧⲉ ⲁϥⲭⲁ ⲛⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲃⲉⲗ ϯⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓⲉⲛⲧⲏϫ ⳿ⲛⲧⲉ ⲡⲓⲓⲟϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⲡⲉⲧⲥⲓϯ ⳿ⲙⲡⲓ⳿ϫⲣⲟϫ ⲉⲑⲛⲁⲛⲉϥ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ⲡⲓⲓⲟϩⲓ ⲇⲉ ⲡⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲡⲓ⳿ϫⲣⲟϫ ⲉⲑⲛⲁⲛⲉϥ ⲛⲁⲓ ⲛⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲛⲓⲉⲛⲧⲏϫ ⲇⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲡⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ⲡⲓϫⲁϫⲓ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲁⲧⲟⲩ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲡⲉ ⲡⲓⲱⲥϧ ⲇⲉ ⳿ⲧϧⲁ⳿ⲉ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ ⲧⲉ ⲛⲓϭⲁⲓⲱⲥϧ ⲇⲉ ⲛⲉ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","⳿ⲙ⳿ⲫⲣⲏϯ ⲟⲩⲛ ⳿ⲉϣⲁⲩⲥⲱⲕⲓ ⳿ⲛⲛⲓⲉⲛⲧⲏϫ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲣⲟⲕϩⲟⲩ ϧⲉⲛ ⲡⲓ⳿ⲭⲣⲱⲙ ⲡⲁⲓⲣⲏϯ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧϧⲁ⳿ⲉ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","⳿ⲉⲣⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥ⳿ⲉⲧⲁⲟⲩ⳿ⲟ ⳿ⲛⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲥⲱⲕⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲛⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲛϯ⳿ⲁⲛⲟⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉϯ⳿ϩⲣⲱ ⳿ⲛ⳿ⲭⲣⲱⲙ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲡⲓⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ⲧⲟⲧⲉ ⲛⲓ⳿ⲑⲙⲏⲓ ⲉⲩ⳿ⲉⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲫⲣⲏ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲡⲟⲩⲓⲱⲧ ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩ⳿ⲁϩⲟ ⲉϥⲭⲏ ⲡ ϧⲉⲛ ⲟⲩⲓⲟϩⲓ ⲫⲏ⳿ⲉⲧⲁ ⲟⲩⲣⲱⲙⲓ ϫⲉⲙϥ ⲁϥⲭⲟⲡϥ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲣⲁϣⲓ ⲁϥϣⲉⲛⲁϥ ⲁϥϯ ⳿ⲙⲡⲉⲧⲉⲛⲧⲁϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥϣⲱⲡ ⳿ⲙⲡⲓⲟϩⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ⲡⲁⲗⲓⲛ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲉϣⲱⲧ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ϩⲁⲛ⳿ⲁⲛⲁⲙⲏⲓ ⳿ⲉⲛⲁⲛⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","⳿ⲉⲧⲁϥϫⲓⲙⲓ ⲇⲉ ⳿ⲛⲟⲩ⳿ⲁⲛⲁⲙⲏⲓ ⳿ⲉⲛⲁϣⲉ⳿ⲛⲥⲟⲩⲉⲛϥ ⲁϥϣⲉⲛⲁϥ ⲁϥϯ ⳿ⲙⲡⲉⲧⲉⲛⲧⲁϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥϣⲟⲡϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ⲡⲁⲗⲓⲛ ⲟⲛ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲥⲁⲅⲏⲛⲏ ⳿ⲉⲁⲩϩⲓⲧⲥ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲁⲥⲑⲱⲟⲩϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲅⲉⲛⲟⲥ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ⲑⲏⲉⲧⲁⲥⲙⲟϩ ⲁⲩⲥⲟⲕⲥ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϩⲉⲙⲥⲓ ⲁⲩⲥⲱⲕⲓ ⳿ⲛⲛⲏⲉⲑⲛⲁⲛⲉⲩ ⳿ⲉϩⲁⲛⲙⲟⲕⲓ ⲛⲏⲉⲧϩⲱⲟⲩ ⲇⲉ ⲁⲩϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧϧⲁⲏ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ ⲉⲩ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲫⲱⲣϫ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲥⲁ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛⲛⲓⲥⲁ⳿ⲙⲡⲉⲑⲛⲁⲛⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯ⳿ϩⲣⲱ ⳿ⲛ⳿ⲭⲣⲱⲙ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⳿ⲁⲧⲉⲧⲉⲛⲕⲁϯ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲁϩⲁ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ⲥⲁϧ ⲛⲓⲃⲉⲛ ⳿ⲉⲁϥϭⲓ⳿ⲥⲃⲱ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ϥ⳿ⲟⲛⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲛⲉⲃⲓⲟϩⲓ ⲫⲏⲉⲧϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉϥ⳿ⲁϩⲟ ⳿ⲛϩⲁⲛⲃⲉⲣⲓ ⲛⲉⲙ ⲁⲛⲁⲡⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲧⲁϥⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϫⲱⲕ ⳿ⲛⲛⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⳿ⲉⲃⲟⲗ ⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲉϥⲃⲁⲕⲓ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⲡⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉⲉⲣ⳿ϣⲫⲏⲣⲓ ⲟⲩⲟϩ ⳿ⲛⲥⲉϫⲟⲥ ϫⲉ ⳿ⲉⲧⲁ ⲫⲁⲓ ϫⲉⲙ ⲧⲁⲓ⳿ⲥⲃⲱ ⲑⲱⲛ ⲛⲉⲙ ⲛⲁⲓϫⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲡⲓⲁⲙϣⲉ ⲙⲏ ⲧⲉϥⲙⲁⲩ ⲁⲛ ⲧⲉ ⲙⲁⲣⲓⲁⲙ ⲟⲩⲟϩ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲥⲏ ⲛⲉⲙ Ⲥⲓⲙⲱⲛ ⲛⲉⲙ Ⲓⲟⲩⲇⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ⲟⲩⲟϩ ⲛⲉϥⲥⲱⲛⲓ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⲙⲏ ⲥⲉⲭⲏ ϩⲁⲣⲟⲛ ⲧⲏⲣⲟⲩ ⲁⲛ ⳿ⲉⲧⲁ ⲫⲁⲓ ⲟⲩⲛ ϫⲉⲙ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ⲟⲩⲟϩ ⲁⲩⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϣⲏϣ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲙⲙⲁ ⳿ⲉⲃⲏⲗ ϧⲉⲛ ⲧⲉϥⲃⲁⲕⲓ ⲛⲉⲙ ⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲉⲣⲟⲩⲙⲏϣ ⳿ⲛϫⲟⲙ ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲉ ⲧⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ");
INSERT INTO copcnt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲡⲓⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⳿ⲉ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ϫⲉ ⲫⲁⲓ ⲡⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⳿ⲛⲑⲟϥ ⲅⲁⲣ ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲓϫⲟⲙ ⲥⲉⲉⲣϩⲱⲃ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ⲏ̇ⲣⲱⲇⲏⲥ ⲅⲁⲣ ⲛⲉ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁϥⲥⲟⲛϩϥ ⲁϥⲭⲁϥ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲉⲑⲃⲉ ̇̇Ⲏⲣⲱⲇⲓⲁⲥ ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ⲛⲁϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ϫⲉ ⳿ⲥϣⲉ ⲛⲁⲕ ⲁⲛ ⳿ⲉϭⲓⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ⲟⲩⲟϩ ⲁϥⲟⲩⲱϣ ⳿ⲉϧⲟⲑⲃⲉϥ ⲁⲗⲗⲁ ⲁϥⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲙⲏϣ ϫⲉ ⲛⲁϥⲭⲏ ⳿ⲛⲧⲟⲧⲟⲩ ⲡⲉ ϩⲱⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","⳿ⲉⲧⲁ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲓⲥⲓ ⲇⲉ ϣⲱⲡⲓ ⳿ⲛⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲁⲥϭⲟⲥϫⲉⲥ ⳿ⲛϫⲉ ⳿ⲧϣⲉⲣⲓ ⳿ⲛ̇̇Ⲏⲣⲱⲇⲓⲁⲥ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⲟⲩⲟϩ ⲁⲥⲣⲁⲛⲁϥ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ϧⲉⲛ ⲫⲁⲓ ⲁϥⲉⲣ⳿ⲁⲛⲁϣ ⲉϥⲉⲣ⳿ⲟⲙⲟⲗⲟⲅⲓⲛ ⳿ⲉϯ ⲛⲁⲥ ⳿ⲙⲫⲏ⳿ⲉⲧⲉⲥⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","⳿ⲛⲑⲟⲥ ⲇⲉ ⳿ⲁ ⲧⲉⲥⲙⲁⲩ ⳿ⲧⲥⲁⲃⲟⲥ ⲡⲉϫⲁⲥ ϫⲉ ⲙⲁ ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲛⲏⲓ ⲡⲓⲣⲉϥϯⲱⲙⲥ ϩⲓ ⲟⲩⲃⲓⲛⲁϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ⲟⲩⲟϩ ⳿ⲁ ⳿ⲡϩⲏⲧ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⳿ⲙⲕⲁϩ ⲉⲑⲃⲉ ⲛⲓ⳿ⲁⲛⲁⲩϣ ⲇⲉ ⲛⲉⲙ ⲛⲏⲉⲑⲣⲱⲧⲉⲃ ⲛⲉⲙⲁϥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉⲧⲏⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⲁϥ⳿ⲱⲗⲓ ⳿ⲛ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ⲟⲩⲟϩ ⲁⲩⲉⲛⲥ ϩⲓ ⲡⲓⲃⲓⲛⲁϫ ⲁⲩⲧⲏⲓⲥ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ⲟⲩⲟϩ ⳿ⲁ ϯ⳿ⲁⲗⲟⲩ ⲧⲏⲓⲥ ⳿ⲛⲧⲉⲥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲉⲗ ϯϣⲟⲗϩⲥ ⲁⲩⲑⲟⲙⲥⲥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲁⲩⲧⲁⲙⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ϩⲓ ⲟⲩϫⲟⲓ ⳿ⲉⲟⲩⲙⲁ ⳿ⲛϣⲁϥⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲁⲩⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲛⲥⲱϥ ⲉⲩⲙⲟϣⲓ ⳿ⲛⲣⲁⲧⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲟⲩⲟϩ ⲁϥϣⲉⲛϩⲏⲧ ϧⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲙⲁ ⲟⲩϣⲁϥⲉ ⲡⲉ ⲟⲩⲟϩ ⲡⲓⲛⲁⲩ ⲁϥⲥⲓⲛⲓ ⲭⲁ ⲛⲓⲙⲏϣ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲥⲉϣⲉⲛⲱⲟⲩ ⳿ⲉⲛⲓϯⲙⲓ ⳿ⲛⲥⲉϣⲱⲡ ⳿ⲛϩⲁⲛ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲁⲛ ⳿ⲛⲧⲟⲩϣⲉⲛⲱⲟⲩ ⲙⲟⲓ ⲛⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲙⲁⲣⲟⲩⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲁⲛ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲉⲃⲏⲗ ⳿ⲉⲉ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲧⲉⲃⲧ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲓⲧⲟⲩ ⲛⲏⲓ ⳿ⲙⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲉ ⲛⲓⲙⲏϣ ⲣⲱⲧⲉⲃ ϩⲓϫⲉⲛ ⲡⲓⲥⲓⲙ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓⲉ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲡⲓⲧⲉⲃⲧ ⲃ̅ ⲁϥϫⲟⲩϣⲧ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁϥⲫⲁϣⲟⲩ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲓⲱⲓⲕ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲁⲩϯ ⳿ⲛⲛⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲙ ⲧⲏⲣⲟⲩ ⲁⲩⲥⲓ ⲟⲩⲟϩ ⲁⲩⲉⲗ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲛⲛⲓⲗⲁⲕϩ ⲁⲩⲙⲁϩ ⲓ̅ⲃ̅ ⳿ⲛⲕⲟⲧ ⲉⲩⲙⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ⲛⲏ ⲇⲉ ⳿ⲉⲛⲁⲩⲟⲩⲱⲙ ⲛⲁⲩⲉⲣ ⲉ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ ⲭⲱⲣⲓⲥ ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲉⲣ⳿ⲁⲛⲁⲅⲕⲁⲍⲓⲛ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⳿ⲉⲥⲱⲕ ϧⲁϫⲱϥ ⳿ⲉⲙⲏⲣ ϣⲁⲧⲉϥⲭⲁ ⲛⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁ ⲛⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲧⲱⲟⲩ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⳿ⲛⲑⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲛⲁϥⲭⲏ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ⲡⲓϫⲟⲓ ⲇⲉ ⲛⲉ ⲁϥⲟⲩⲉⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓⲕⲁϩⲓ ⲛⲁⲩ ⲕ̅ⲉ̅ ⳿ⲛ⳿ⲥⲧⲁⲇⲓⲟⲛ ⲉⲩϯⲟⲩⲃⲏϥ ⳿ⲛϫⲉ ⲛⲓϫⲟⲗ ⲛⲁⲣⲉ ⲡⲓⲑⲏⲟⲩ ⲅⲁⲣ ϯⲟⲩⲃⲏϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ϧⲉⲛ ϯⲙⲁϩⲇ̅ ⲇⲉ ⳿ⲛⲟⲩⲉⲣϣⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲁϥ⳿ⲓ ϩⲁⲣⲱⲟⲩ ⲉϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩϩⲟⲣⲧϥ ⲡⲉ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯϩⲟϯ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ⲥⲁⲧⲟⲧϥ ⲇⲉ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ Ⲡⲁ⳪ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲏⲓ ⳿ⲛⲧⲁ⳿ⲓ ϣⲁⲣⲟⲕ ϩⲓϫⲉⲛ ⲛⲓⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓϫⲟⲓ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⲛⲓⲙⲱⲟⲩ ⳿ⲉ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ⲉϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲡⲓⲑⲏⲟⲩ ⲁϥⲉⲣϩⲟϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲱⲙⲥ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲛⲁϩⲙⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ⲥⲁⲧⲟⲧϥ ⲇⲉ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲫⲁ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛⲛⲁϩϯ ⲉⲑⲃⲉ ⲟⲩ ⲁⲕⲉⲣϩⲏⲧ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲁϥϩⲉⲣⲓ ⳿ⲛϫⲉ ⲡⲓⲑⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ⲛⲏ ⲇⲉ ⳿ⲉⲛⲁⲩ ϩⲓ ⲡⲓϫⲟⲓ ⲁⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⳿ⲛⲑⲟⲕ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲉⲣϫⲓⲛⲓⲟⲣ ⳿ⲉⲙⲏⲣ ⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲄⲉⲛⲛⲏⲍⲁⲣⲉⲑ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲟⲩⲱⲛϥ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ϩⲓⲛⲁ ⲙⲟⲛⲟⲛ ⳿ⲛⲥⲉϭⲓⲛⲉⲙ ⳿ⲡ⳿ϣⲧⲁϯ ⳿ⲛⲧⲉ ⲛⲉϥ⳿ϩⲃⲟⲥ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϭⲓ ⲁⲩⲛⲟϩⲉⲙ ");
INSERT INTO copcnt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛϫⲉ ϩⲁⲛⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ϩⲁⲛⲥⲁϧ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲥⲉⲉⲣⲡⲁⲣⲁⲃⲉⲛⲓⲛ ⳿ⲛϯⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲥⲉⲓⲱⲓ ⲅⲁⲣ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲉⲩⲛⲁⲟⲩⲉⲙ ⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲧⲉⲧ⳿ⲉⲛⲉⲣⲡⲁⲣⲁⲃⲉⲛⲓⲛ ⳿ⲛϯⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲉ Ⲫϯ ⲉⲑⲃⲉ ⲧⲉⲧⲉⲛⲡⲁⲣⲁⲇⲟⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ⲫϯ ⲅⲁⲣ ⲁϥϫⲟⲥ ϫⲉ ⲙⲁⲧⲁⲓ⳿ⲉ ⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⲧⲉⲕⲙⲁⲩ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϫⲉ ⲟⲩⲥⲁϫⲓ ⲉϥϩⲱⲟⲩ ⳿ⲛⲥⲁ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲉϥ⳿ⲉⲙⲟⲩ ⳿ⲙ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁϫⲟⲥ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲓⲉ ⲧⲉϥⲙⲁⲩ ϫⲉ ⲟⲩⲧⲁⲓ⳿ⲟ ⳿ⲉ⳿ⲭⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧ ⳿ⲛⲛⲉϥⲧⲁⲓ⳿ⲉ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛⲕⲉⲣϥ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲉⲑⲃⲉ ⲛⲉⲧⲉⲛⲡⲁⲣⲁⲇⲟⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ⲛⲓϣⲟⲃⲓ ⲕⲁⲗⲱⲥ ⲁϥⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ϧⲁⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ Ⲏ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ϫⲉ ⲡⲁⲓⲗⲁⲟⲥ ⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙⲙⲟⲓ ϧⲉⲛ ⲛⲟⲩ⳿ⲥⲫⲟⲧⲟⲩ ⲡⲟⲩϩⲏⲧ ⲇⲉ ⳿ϥⲟⲩ⳿ⲏⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ⲉⲩⲉⲣⲥⲉⲃⲏⲥⲑⲉ ⳿ⲙⲙⲟⲓ ⳿ⲉ⳿ⲫⲗⲏⲟⲩ ⲉⲩϯ⳿ⲥⲃⲱ ⳿ⲛϩⲁⲛ⳿ⲥⲃⲱ ⳿ⲛϩⲟⲛϩⲉⲛ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲓⲙⲏϣ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ⲡⲉⲑⲛⲁϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲁⲛ ⲡⲉⲧⲥⲱϥ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ⲡⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⲫⲁⲓ ⲡⲉⲧⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲕ⳿ⲉⲙⲓ ϫⲉ ⳿ⲉⲧⲁ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲓⲥⲁϫⲓ ⲁⲩⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ϣϣⲏⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ ⳿ⲙⲡⲉ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ϭⲱⲟⲩ ⲥⲉⲛⲁⲕⲟⲣϫⲟⲩ ⲛⲉⲙ ⲧⲟⲩⲛⲟⲩⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ⲭⲁⲩ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ⲛⲉ ϭⲁⲩⲙⲱⲓⲧ ⳿ⲙⲃⲉⲗⲗⲉ ⳿ⲁⲣⲏⲟⲩ ⲟⲩⲃⲉⲗⲗⲉ ⲅⲁⲣ ⲉϥϭⲓⲙⲱⲓⲧ ϧⲁϫⲱϥ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ϣⲁⲩϩⲉⲓ ⳿ⲉⲟⲩϣⲓⲕ ⳿ⲙ⳿ⲡⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲃⲉⲗ ϯⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲕⲙⲏⲛ ϩⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛⲁⲧⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","⳿ⲙⲡⲁⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉϣⲁⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ϣⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϯⲛⲉϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϩⲓⲧⲟⲩ ⳿ⲉⲛⲓⲙⲁ⳿ⲛϩⲉⲙⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ⲛⲏ ⲇⲉ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⲉⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓϩⲏⲧ ⲛⲁⲓ ⲡⲉⲧⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","⳿ⲉϣⲁⲩ⳿ⲓ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓϩⲏⲧ ⳿ⲛϫⲉ ⲛⲓⲙⲟⲕⲙⲉⲕ ⲉⲧϩⲱⲟⲩ ⲛⲓϧⲱⲧⲉⲃ ⲛⲓⲙⲉⲧⲛⲱⲓⲕ ⲛⲓⲡⲟⲣⲛⲓ⳿ⲁ ⲛⲓϭⲓⲟⲩ⳿ⲓ ⲛⲓⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ⲛⲓϫⲉⲟⲩ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ⲛⲁⲓ ⲡⲉⲧⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲡⲓⲟⲩⲱⲙ ⲇⲉ ⳿ⲛⲟⲩ⳿ⲉϣⲉⲛ ⲓⲁ ⲧⲟⲧ ⳿ⲛ⳿ϥⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲤⲓⲇⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ⲟⲩⲟϩ ⲓⲥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲛ ⲛⲏ⳿ⲁ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓϭⲓ⳿ⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲛⲁⲥⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓ ϧⲁⲣⲟⲓ Ⲡⲁ⳪ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⲧⲁϣⲉⲣⲓ ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲉϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁⲥ ⳿ⲛⲟⲩⲥⲁϫⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲁ ⲧⲁⲓ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲥⲱϣ ⳿ⲉⲃⲟⲗ ⲥⲁⲙⲉⲛϩⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲟⲩⲧⲁⲟⲩⲟⲓ ϩⲁ ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲉⲧⲥⲱⲣⲉⲙ ⳿ⲛⲧⲉ ⳿ⲡⲏⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","⳿ⲛⲑⲟⲥ ⲇⲉ ⲁⲥ⳿ⲓ ⲁⲥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲁ⳪ ⳿ⲁⲣⲓⲃⲟ⳿ⲏⲑⲓⲛ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁⲛⲉⲥ ⲁⲛ ⳿ⲉⲉⲗ ⳿ⲡⲱⲓⲕ ⳿ⲛⲛⲓϣⲏⲣⲓ ⳿ⲉⲧⲏⲓϥ ⳿ⲛⲛⲓⲟⲩϩⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","⳿ⲛⲑⲟⲥ ⲇⲉ ⲡⲉϫⲁⲥ ϫⲉ ⲥⲉ Ⲡⲁ⳪ ⲕⲉ ⲅⲁⲣ ϣⲁⲣⲉ ⲛⲓⲕⲉⲟⲩϩⲱⲣ ⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲗⲉϥⲗⲓϥⲓ ⲛⲏ⳿ⲉϣⲁⲩϩⲉⲓ ⳿ⲉⲃⲟⲗϩⲓ ϯ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ ⲛⲟⲩϭⲓⲥⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ⲧⲟⲧⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⳿ⲱ ϯ⳿ⲥϩⲓⲙⲓ ⲟⲩⲛⲓϣϯ ⲡⲉ ⲡⲉⲛⲁϩϯ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲛⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉⲟⲩⲁϣϥ ⲟⲩⲟϩ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲧⲉⲥϣⲉⲣⲓ ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥ⳿ⲓ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϫⲉⲛ ⲟⲩⲧⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥϩⲉⲙⲥⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛϭⲁⲗⲉⲩ ⲛⲉⲙⲱⲟⲩ ⲛⲉⲙ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ⲛⲉⲙ ϩⲁⲛⲕⲟⲩⲣ ⲛⲉⲙ ϩⲁⲛϫⲁϭ ⲉⲩ ⲛⲉⲙ ϩⲁⲛⲕⲉⲙⲏϣ ⲟⲩⲟϩ ⲁⲩϩⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁ ⲛⲉϥϭⲁⲗⲁⲩϫ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ ⲛⲓⲙⲏϣ ⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩⲛⲁⲩ ⳿ⲉⲛⲓ⳿ⲉⲃⲱⲟⲩ ⲉⲩⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓϭⲁⲗⲉⲩ ⲉⲩⲙⲟϣⲓ ⲛⲉⲙ ⲛⲓⲃⲉⲗⲗⲉⲩ ⲉⲩⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲛⲉⲙ ⲛⲓⲕⲟⲩⲣ ⲉⲩⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲛⲁⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯϣⲉⲛϩⲏⲧ ϧⲁ ⲡⲁⲓⲙⲏϣ ϫⲉ ⲓⲥ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲥⲉⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲛⲉⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲫⲏ⳿ⲉⲧⲟⲩⲛⲁⲟⲩⲟⲙϥ ⲟⲩⲟϩ ϯⲟⲩⲱϣ ⲁⲛ ⳿ⲉⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩ⳿ⲉϣⲉⲛⲟⲩⲱⲙ ϫⲉ ⳿ⲛⲛⲟⲩⲃⲱⲗ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ Ⲁⲛⲛⲁϫⲉⲙ ⲧⲁⲓ⳿ⲏⲡⲓ ⳿ⲛⲱⲓⲕ ⲑⲱⲛ ϩⲓ ⲡⲁⲓⲙⲁ ⳿ⲛϣⲁϥⲉ ϩⲱⲥⲧⲉ ⳿ⲉ⳿ⲧⲥⲓ ⳿ⲉⲡⲁⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛⲧⲉⲧⲉⲛ ⲟⲩⲏⲣ ⳿ⲛⲱⲓⲕ ⳿ⲙⲙⲁⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲍ̅ ⲛⲉⲙ ϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛⲧⲉⲃⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⳿ⲛⲧⲉ ⲡⲓⲙⲏϣ ⲉⲑⲣⲟⲩⲣⲱⲧⲉⲃ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ⲁϥϭⲓ ⳿ⲙⲡⲓⲍ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲛⲓⲧⲉⲃⲧ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁϥⲫⲁϣⲟⲩ ⲟⲩⲟϩ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲁⲩϯ ⳿ⲛⲛⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲙ ⲧⲏⲣⲟⲩ ⲁⲩⲥⲓ ⲟⲩⲟϩ ⲁⲩⲉⲗ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲛⲛⲓⲗⲁⲕϩ ⲁⲩⲙⲁϩ ⲍ̅ ⳿ⲙⲃⲓⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ⲛⲏ ⲇⲉ ⳿ⲉⲛⲁⲩⲟⲩⲱⲙ ⲛⲁⲩⲉⲣ ⲇ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ ⲭⲱⲣⲓⲥ ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁ ⲛⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲛⲓϭⲓ⳿ⲏ ⳿ⲛⲧⲉ Ⲙⲁⲅⲇⲁⲗⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲁⲙⲱⲟⲩ ⳿ⲉⲟⲩⲙⲏⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲁⲣⲟⲩϩⲓ ⲧⲉⲧⲉⲛϫⲟⲥ ϫⲉ ⳿ⲧⲫⲉ ⲟⲩϫⲁⲙⲏ ⲉⲥ⳿ⲑⲣⲟϣⲣⲉϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ⲟⲩⲟϩ ϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⲧⲉⲧⲉⲛϫⲟⲥ ϫⲉ ⲫⲟⲟⲩ ⳿ⲧ⳿ⲫⲣⲱ ⲉⲑⲃⲉ ⲡⲓ⳿ⲑⲣⲟϣⲣⲉϣ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⲟⲩ⳿ⲅⲛⲟⲫⲟⲥ ⲛⲓϣⲟⲃⲓ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲉⲥⲟⲙⲥ ⳿ⲉ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⳿ⲫⲙⲏⲓⲛⲓ ⳿ⲙⲡⲁⲓⲥⲏⲟⲩ ⲫⲁⲓ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ϫⲉ ⲡⲓϫⲱⲟⲩ ⲉⲧϩⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲛⲱⲓⲕ ⳿ϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⲟⲩⲟϩ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲛⲟⲩⲧⲏⲓϥ ⲛⲁϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ Ⲓⲱⲛⲁ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁⲩ ⲁϥϣⲉⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲙⲏⲣ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲉⲣⲡⲱⲃϣ ⳿ⲉϣⲉⲡ ⲱⲓⲕ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲁⲩ ⲟⲩⲟϩ ⲙⲁϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲛϭⲓ ⲱⲓⲕ ⲛⲉⲙⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲁ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛⲛⲁϩϯ ϫⲉ ⳿ⲙⲙⲟⲛ ⲧⲉⲧⲉⲛ ⲱⲓⲕ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","⳿ⲙⲡⲁⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲟⲩⲇⲉ ⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙ⳿ⲫⲙⲉⲩⲓ ⲁⲛ ⳿ⲙⲡⲓⲉ̅ ⳿ⲛⲱⲓⲕ ⳿ⲛⲧⲉ ⲡⲓⲉ̅ ⳿ⲛϣⲟ ϫⲉ ⳿ⲁⲧⲉⲧⲉⲛϭⲓ ⲟⲩⲏⲣ ⳿ⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ⲟⲩⲇⲉ ⲡⲓⲍ̅ ⳿ⲛⲱⲓⲕ ⳿ⲛⲧⲉ ⲡⲓⲇ̅ ⳿ⲛϣⲟ ϫⲉ ⳿ⲁⲧⲉⲧⲉⲛϭⲓ ⲟⲩⲏⲣ ⳿ⲙⲃⲓⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ⲡⲱⲥ ⲧⲉⲧⲉⲛⲕⲁϯ ⲁⲛ ϫⲉ ⲛⲁⲓϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲛ ⲉⲑⲃⲉ ⲡⲓⲱⲓⲕ ⳿ⲁⲣⲉϩ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ⲧⲟⲧⲉ ⲁⲩⲕⲁϯ ϫⲉ ⲛⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⲁⲛ ϫⲉ ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲛⲓⲱⲓⲕ ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗϩⲁ ϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ ⳿ⲧⲔⲉⲥⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲁϥϣⲓⲛⲓ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲁⲣⲉ ⲛⲓⲣⲱⲙⲓ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ Ⲓⲉⲣⲉⲙⲓⲁⲥ ⲓⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲁⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲥⲓⲙⲱⲛ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ ⲉⲧⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲱⲟⲩ⳿ⲛⲓⲁⲧⲕ Ⲥⲓⲙⲱⲛ ⲃⲁⲣ Ⲓⲱⲛⲁ ϫⲉ ⲥⲁⲣⲝ ⲛⲉⲙ ⳿ⲥⲛⲟϥ ⲁⲛ ⲁϥϭⲱⲣⲡ ⳿ⲙⲫⲁⲓ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⲁⲗⲗⲁ ⲡⲁⲓⲱⲧ ⲡⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲉⲧⲣⲟⲥ ⲉⲓ⳿ⲉⲕⲱⲧ ⳿ⲛⲧⲁⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ϩⲓϫⲉⲛ ⲧⲁⲓⲡⲉⲧⲣⲁ ⲟⲩⲟϩ ⲛⲓⲡⲩⲗⲏ ⳿ⲛⲧⲉ ⳿ⲁⲙⲉⲛϯ ⳿ⲛⲛⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ⲉⲓ⳿ⲉϯ ⲛⲁⲕ ⳿ⲛⲛⲓϣⲟϣⲧ ⳿ⲛⲧⲉ ⳿ⲑⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉⲕⲛⲁⲥⲟⲛϩϥ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲥⲟⲛϩ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉⲕⲛⲁⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲉϥⲃⲏⲗ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ⲧⲟⲧⲉ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ϣⲧⲉⲙϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ϫⲉ ⳿ⲛⲑⲟϥ ⲡⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","✠ ");
INSERT INTO copcnt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ⲟⲩⲟϩ ϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲉⲗⲉⲱⲥ ⲛⲁⲕ Ⲡⲁ⳪ ⳿ⲛⲛⲉ ⲫⲁⲓ ϣⲱⲡⲓ ⳿ⲙⲙⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲙⲠⲉⲧⲣⲟⲥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⲥⲁⲙⲉⲛϩⲏⲓ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲛⲏⲓ ϫⲉ ⳿ⲭⲙⲉⲩⲓ ⲁⲛ ⳿ⲉⲛⲁ Ⲫϯ ⲁⲗⲗⲁ ⲛⲁ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⲙⲁⲣⲉϥϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲙⲁⲣⲉϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ ⳿ⲛⲧⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ⲫⲏ ⲅⲁⲣ ⲉⲑⲟⲩⲱϣ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉϥ⳿ⲉⲧⲁⲕⲟⲥ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲧⲁⲕⲟ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉⲑⲃⲏⲧ ⲉϥ⳿ⲉϫⲉⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ⲟⲩ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⲁϥϣⲁⲛϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⲧⲉϥⲯⲩⲭⲏ ⲇⲉ ⳿ⲛⲧⲉϥϯ⳿ⲟⲥⲓ ⳿ⲙⲙⲟⲥ ⳿ⲙⲙⲟⲛ ⲟⲩ ⲡⲉⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁⲧⲏⲓϥ ⳿ⲛ⳿ⲧϣⲉⲃⲓ⳿ⲱ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ⲡ̇ϣⲏⲣⲓ ⲅⲁⲣ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲡ⳿ⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⳿ϥⲛⲁϯ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲕⲁⲧⲁ ⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ϧⲉⲛ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲥⲉⲛⲁϫⲉⲙϯⲡⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲁⲛ ϣⲁⲧⲟⲩⲛⲁⲩ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲡ⳿ⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϥⲓⲱⲧ ");
INSERT INTO copcnt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲋ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ⲉⲗ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϥⲥⲟⲛ ⲁϥϭⲓⲧⲟⲩ ⳿ⲉϫⲉⲛ ⲟⲩⲧⲱⲟⲩ ⲉϥϭⲟⲥⲓ ⲥⲁ⳿ⲡⲥⲁ ⲙⲙⲁⲩⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ⲟⲩⲟϩ ⲁϥϣⲟⲃⲧϥ ⳿ⲛⲭⲉⲣⲉⲃ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ ⲟⲩⲟϩ ⳿ⲁ ⲡⲉϥϩⲟ ⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲫⲣⲏ ⲛⲉϥ⳿ϩⲃⲱⲥ ⲇⲉ ⲁⲩⲟⲩⲃⲁϣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ Ⲏ̇ⲗⲓⲁⲥ ⲉⲩⲥⲁϫⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ Ⲡⲁ⳪ ⲛⲁⲛⲉⲥ ⲛⲁⲛ ⳿ⲛⲧⲉⲛϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲭⲟⲩⲱϣ ⳿ⲛⲧⲉⲛⲑⲁⲙⲓ⳿ⲟ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲥⲕⲏⲛⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩ⳿ⲓ ⲛⲁⲕ ⲛⲉⲙ ⲟⲩ⳿ⲓ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲟⲩ⳿ⲓ ⳿ⲛ Ⲏ̇ⲗⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ϩⲟⲧⲉ ⲉϥⲥⲁϫⲓ ⲓⲥ ⲟⲩϭⲏⲡⲓ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⲁⲥⲉⲣϧⲏⲓⲃⲓ ⳿ⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⲓⲥ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯϭⲏⲡⲓ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⲫⲏ ⳿ⲉⲧⲁ ⲧⲁⲯⲩⲭⲏ ϯⲙⲁϯ ⳿ⲛϧⲏⲧϥ ⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁⲩϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲟⲩϩⲟ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϭⲓⲛⲉⲙⲱⲟⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","⳿ⲉⲧⲁⲩϥⲁⲓ ⲇⲉ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲒⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ⲟⲩⲟϩ ⲉⲩⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲧⲁⲙⲉ ⳿ϩⲗⲓ ⳿ⲉⲡⲓϩⲟⲣⲁⲙⲁ ϣⲁⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲛⲓⲥⲁϧ ⲥⲉϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲡⲉⲑⲛⲏⲟⲩ ⳿ⲛϣⲟⲣⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲙⲉⲛ ⳿ϥⲛⲏⲟⲩ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ϩⲏⲇⲏ ⲁϥ⳿ⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲥⲟⲩⲱⲛϥ ⲁⲗⲗⲁ ⲁⲩ⳿⳿ⲓⲣⲓ ⲛⲁϥ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉϩⲛⲱⲟⲩ ⲡⲁⲓⲣⲏϯ ϩⲱϥ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ϥⲛⲁϣⲉⲡ⳿ⲙⲕⲁϩ ⳿ⲛⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ⲧⲟⲧⲉ ⲁⲩⲕⲁϯ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⲉⲑⲃⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ϩⲁ ⲡⲓⲙⲏϣ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⲉϥϩⲓ ⳿ⲙⲙⲟϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ⲟⲩⲟϩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓ ϧⲁ ⲡⲁϣⲏⲣⲓ ϫⲉ ⳿ϥⲟⲓ ⳿ⲙⲡⲉⲣⲙⲟⲩ ⲟⲩⲟϩ ⳿ϥ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ⳿ⲉⲙⲁϣⲱ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲛⲥⲟⲡ ϣⲁϥϩⲉⲓ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ϣⲁϥϩⲉⲓ ⳿ⲉ⳿ⲫⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ⲟⲩⲟϩ ⲁⲓⲉⲛϥ ϩⲁ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ⲧⲟⲧⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲱ ⲡⲓϫⲱⲟⲩ ⳿ⲛⲁⲑⲛⲁϩϯ ⲟⲩⲟϩ ⲉⲧⲫⲱⲛϩ ϣⲁ ⳿ⲑⲛⲁⲩ ϯⲛⲁϣⲱⲡⲓ ⲛⲉⲙⲱⲧⲉⲛ ϣⲁ ⳿ⲑⲛⲁⲩ ϯⲛⲁ⳿ⲱⲟⲩ⳿ⲛϩⲏⲧ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲁⲛⲓⲧϥ ⲛⲏⲓ ⳿ⲙⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ⳿ⲛⲏⲧϥ ⳿ⲛϫⲉ ⲡⲓⲓϧ ⲟⲩⲟϩ ⲁϥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲁⲛⲟⲛ ⲙⲡⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","✠ ");
INSERT INTO copcnt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ⲟⲩⲟϩ ⲡⲁⲓⲅⲉⲛⲟⲥ ⳿ⲙⲡⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲛⲟⲩ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲉⲙ ⲟⲩⲛⲏⲥⲧⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⳿ⲉⲧⲁⲩⲕⲟⲧⲟⲩ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ⲟⲩⲟϩ ⲥⲉⲛⲁϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲉϥ⳿ⲉⲧⲱⲛϥ ⲟⲩⲟϩ ⳿ⲁ ⲡⲟⲩϩⲏⲧ ⳿ⲙⲕⲁϩ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲔⲁⲫⲁⲣⲛⲁⲟⲩⲱⲙ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲏⲉⲧϭⲓ ⲕⲓϯ ϩⲁ Ⲡⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲡⲉⲧⲉⲛⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ϥϯ ⲕⲓϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ⲡⲉϫⲁϥ ϫⲉ ⲥⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲡⲉⲧⲉⲕⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ Ⲥⲓⲙⲱⲛ ⲛⲓⲟⲩⲣⲱⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ ⲁⲩϭⲓ ⲧⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲙ ⲓⲉ ⲕⲏⲛⲥⲟⲥ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓϣⲏⲣⲓ ϣⲁⲛ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓϣⲉⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓϣⲉⲙⲙⲱⲟⲩ ⳿ⲉⲧⲁϥϫⲟⲥ ⲇⲉ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓϣⲉⲙⲙⲱⲟⲩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϩⲁⲣⲁ ⲛⲓϣⲏⲣⲓ ϩⲁⲛⲣⲉⲙϩⲉⲩ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ϩⲓⲛⲁ ⲇⲉ ⳿ⲛⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉ⳿ⲫⲓⲟⲙ ϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲧⲉⲕⲱⲓⲙⲓ ⲟⲩⲟϩ ⲡⲓⲧⲉⲃⲧ ⳿ⲛϩⲟⲩⲓⲧ ⲉⲑⲛⲁ⳿ⲓ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲁⲗⲓⲧϥ ⲟⲩⲟϩ ⲁⲕϣⲁⲛⲟⲩⲱⲛ ⳿ⲛⲣⲱϥ ⲉⲕ⳿ⲉϫⲓⲙⲓ ⲥⲁⲑⲉⲣⲓ ⳿ⲁⲗⲓⲧⲥ ⲙⲏ ⲓⲥ ⲛⲱⲟⲩ ⳿ⲉϫⲱⲓ ⲛⲉⲙⲁⲕ ");
INSERT INTO copcnt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ϩⲁⲣⲁ ⲡⲉ ⲡⲓⲛⲓϣϯ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲟⲩⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲟⲩ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲕⲉⲧ ⲑⲏⲛⲟⲩ ⳿ⲛⲧⲉⲧ⳿ⲉⲛⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲁⲓ⳿ⲁⲗⲟⲩ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ⲫⲏ ⲟⲩⲛ ⲉⲑⲛⲁⲑⲉⲃⲓⲟϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲁⲓ⳿ⲁⲗⲟⲩ ⲫⲁⲓ ⲡⲉ ⲡⲓⲛⲓϣϯ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϣⲉⲡ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲙⲡⲁⲓⲣⲏϯ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲉϥϣⲱⲡ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲛⲁϥ ⳿ⲛⲧⲟⲩⲉϣ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲙⲙⲟⲩⲗⲟⲛ ⳿ⲉϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲟⲙⲥϥ ϧⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ⲟⲩⲟⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲉⲑⲃⲉ ⲛⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⳿ⲁⲛⲁⲅⲕⲏ ⲅⲁⲣ ⳿ⲛⲧⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⳿ⲡⲗⲏⲛ ⲟⲩⲟⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ ⲡⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲛⲁ⳿ⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ⲓⲥϫⲉ ⲧⲉⲕϫⲓϫ ⲓⲉ ⲧⲉⲕϭⲁⲗⲟϫ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲙⲟⲕ ϫⲟϫⲟⲩ ϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗϩⲁⲣⲟⲕ ⲛⲁⲛⲉⲥ ⲅⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲱⲛϧ ⲉⲕⲟⲓ ⳿ⲛϭⲁⲗⲉ ⲓⲉ ⲉⲕⲟⲓ ⳿ⲛϭⲁϫⲏ ⳿⳿ⲉϩⲟⲧⲉ ⳿ⲉⲟⲩⲟⲛ ϫⲓϫ ⳿ⲥⲛⲟⲩϯ ⳿ⲉⲣⲟⲕ ⲓⲉ ϭⲁⲗⲟϫ ⳿ⲥⲛⲟⲩϯ ⳿ⲛⲥⲉϩⲓⲧⲕ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⳿ⲛ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ⲟⲩⲟϩ ⲓⲥϫⲉ ⲡⲉⲕⲃⲁⲗ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲙⲟⲕ ⲫⲟⲣⲕϥ ϩⲓⲧⲕ ⳿ⲉⲃⲟⲗϩⲁⲣⲟⲕ ⲛⲁⲛⲉⲥ ⲅⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲱⲛϧ ⳿ⲉⲟⲩⲃⲁⲗ ⲡⲉⲧⲉ ⳿ⲙⲙⲟⲕ ⲓⲉ ⳿ⲉⲟⲩⲟⲛ ⲃⲁⲗ ⲃ̅ ⳿ⲙⲙⲟⲕ ⳿ⲛⲥⲉϩⲓⲧⲕ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","⳿ⲁⲛⲁⲩ ⲟⲩⲛ ⳿ⲙⲡⲉⲣⲉⲣⲕⲁⲧⲁ⳿ⲫⲣⲟⲛⲓⲛ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲛⲟⲩⲁⲅⲅⲉⲗⲟⲥ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲥⲉⲛⲁⲩ ⳿ⲉ⳿ⲡϩⲟ ⳿ⲙⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ⲕⲉ ⲅⲁⲣ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉⲕⲱϯ ⲟⲩⲟϩ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲛⲏⲉⲧⲥⲱⲣⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ⲟⲩ ⲇⲉ ⲡⲉⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⳿ⲁⲣⲉϣⲁⲛ ⲣ̅ ⳿ⲛ⳿ⲉⲥⲱⲟⲩ ϣⲱⲡⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲥⲱⲣⲉⲙ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲙⲏ ⳿ⲙⲡⲁϥⲭⲁ ⲡⲓ ϥ̅ⲑ̅ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϣⲉⲛⲁϥ ⳿ⲛⲧⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲫⲏ⳿ⲉⲧⲁϥⲥⲱⲣⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ⲟⲩⲟϩ ⲁⲥϣⲁⲛϣⲱⲡⲓ ⲉⲑⲣⲉϥϫⲉⲙϥ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϣⲁϥⲣⲁϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲙⲁⲗⲗⲟⲛ ⳿⳿ⲉϩⲟⲧⲉ ⲡⲓ ϥ̅ⲑ̅ ⳿ⲉⲧⲉ ⳿ⲛⲥⲉⲥⲱⲣⲉⲙ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ⲡⲁⲓⲣⲏϯ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲡⲁⲓⲱⲧ ⲁⲛ ⲡⲉ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲁⲣⲉϣⲁⲛ ⲡⲉⲕⲥⲟⲛ ⲉⲣⲛⲟⲃⲓ ⳿ⲉⲣⲟⲕ ⲙⲁϣⲉⲛⲁⲕ ⲟⲩⲟϩ ⲥⲁϩⲱϥ ⲟⲩⲧⲱⲕ ⲛⲉⲙⲁϥ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲕ ⲕ⳿ⲉϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲕ ϭⲓ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⲓⲉ ⲕⲉⲃ̅ ⲛⲉⲙⲁⲕ ϩⲓⲛⲁ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⳿ⲙⲙⲉⲑⲣⲉ ⲃ̅ ⲓⲉ ⲅ̅ ⳿ⲛⲧⲉ ⲥⲁϫⲓ ⲛⲓⲃⲉⲛ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲟⲩ ⳿ⲁϫⲟⲥ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲛⲧⲟⲧⲕ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲉⲑⲛⲓⲕⲟⲥ ⲛⲉⲙ ⲟⲩⲧⲉⲗⲱⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲥⲟⲛϩⲟⲩ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲉⲩⲥⲟⲛϩ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲃⲟⲗⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲉⲩⲃⲏⲗ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ⲡⲁⲗⲓⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ ⲃ̅ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϯⲙⲁϯ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲟⲩⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲛⲱⲟⲩ ⳿ⲛⲧⲉⲛ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ⲡⲓⲙⲁ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲃ̅ ⲓⲉ ⲅ̅ ⲉⲣⲥⲩⲛⲁⲅⲉⲥⲑⲉ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲁⲣⲁⲛ ϯⲭⲏ ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ Ⲡⲁ⳪ ⳿ⲁⲣⲉϣⲁⲛ ⲡⲁⲥⲟⲛ ⲉⲣⲛⲟⲃⲓ ⳿ⲉⲣⲟⲓ ⳿ⲛⲧⲁⲭⲱ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϣⲁ ⲟⲩⲏⲣ ⳿ⲛⲥⲟⲡ ϣⲁ ⲍ̅ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ⲁⲛ ϣⲁ ⲍ̅ ⳿ⲛⲥⲟⲡ ⲁⲗⲗⲁ ⲍ̅ ⳿ⲛ ⲟ̅ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲟⲩⲣⲟ ⳿ⲉⲁϥⲟⲩⲱϣ ⳿ⲉϥⲓⲱⲡ ⲛⲉⲙ ⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","⳿ⲉⲧⲁϥⲉⲣϩⲏⲧⲥ ⲇⲉ ⳿ⲛϥⲓⲱⲡ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲁⲓ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛϫⲓⲛϭⲱⲣ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","⳿ⲙⲙⲟⲛⲧⲉϥ ⲇⲉ ⳿ⲉⲧⲏⲓⲧⲟⲩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉϥ⳪ ⳿ⲉⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲛⲉⲙ ⲛⲉϥϣⲏⲣⲓ ⲛⲉⲙ ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲛⲧⲁϥ ⲟⲩⲟϩ ⳿ⲉⲧⲟⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","⳿ⲉⲧⲁϥϩⲓⲧϥ ⲟⲩⲛ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁϥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁ⳪ ⳿ⲱⲟⲩ⳿ⲛϩⲏⲧ ⲛⲉⲙⲏⲓ ⲟⲩⲟϩ ϯⲛⲁⲧⲟⲃⲟⲩ ⲛⲁⲕ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","⳿ⲉⲧⲁϥϣⲉⲛϩⲏⲧ ⲇⲉ ⳿ⲛϫⲉ ⳿ⲡ⳪ ⳿ⲙⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲭⲁϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲉⲧ ⳿ⲉⲣⲟϥ ⲧⲏⲣϥ ⲁϥⲭⲁϥ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉⲟⲩⲟⲛ ⲣ̅ ⳿ⲛⲥⲁⲑⲉⲣⲓ ⳿ⲛⲧⲁϥ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲁϥⲱϫϩ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁ ⲡⲉⲧⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","⳿ⲉⲧⲁϥϩⲓⲧϥ ⲟⲩⲛ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲡⲉϥ⳿ϣⲫⲏⲣ ⳿ⲙⲃⲱⲕ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲱⲟⲩ⳿ⲛϩⲏⲧ ⲛⲉⲙⲏⲓ ⲟⲩⲟϩ ϯⲛⲁⲧⲟⲃⲟⲩ ⲛⲁⲕ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲉϥⲟⲩⲱϣ ⲁⲗⲗⲁ ⲁϥϣⲉⲛⲁϥ ⲁϥϩⲓⲧϥ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ ϣⲁⲧⲉϥϯ ⳿ⲙⲡⲉⲧⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉⲛⲏ⳿ⲉⲧⲁⲩϣⲱⲡⲓ ⳿ⲁ ⲡⲟⲩϩⲏⲧ ⳿ⲙⲕⲁϩ ⳿ⲉⲙⲁϣⲱ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲁⲩⲧⲁⲙⲉ ⲡⲟⲩ⳪ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ⲧⲟⲧⲉ ⳿ⲁ ⲡⲉϥ⳪ ⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲓⲃⲱⲕ ⲉⲧϩⲱⲟⲩ ⲫⲏⲉⲧ⳿ⲉⲣⲟⲕ ⲧⲏⲣϥ ⲁⲓⲭⲁϥ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁⲕϯϩⲟ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ⲛⲁⲥⲉⲙ⳿ⲡϣⲁ ⲛⲁⲕ ⲁⲛ ϫⲉ ⳿ⲛⲑⲟⲕ ⳿ⲛⲧⲉⲕⲛⲁⲓ ϧⲁ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲃⲱⲕ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲉⲧⲁⲓⲛⲁⲓ ⲛⲁⲕ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲱⲛⲧ ⳿ⲛϫⲉ ⲡⲉϥ⳪ ⲁϥⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲣⲉϥ⳿ⲧϩⲉⲙⲕⲟ ϣⲁⲧⲉϥϯ ⳿ⲙⲡⲉⲧⲉⲣⲟϥ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ⲡⲁⲓⲣⲏϯ ⲡⲉⲧⲉ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲛⲁⲁⲓϥ ⲛⲱⲧⲉⲛ ⳿ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉϥⲥⲟⲛ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ⲧⲏⲣϥ ");
INSERT INTO copcnt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲉⲕ ⲛⲁⲓⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ϥ⳿ⲓ ⳿ⲉⲛⲓϭⲓ⳿ⲏ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ⲟⲩⲟϩ ⲁⲩⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲪⲁⲣⲓⲥⲉⲟⲥ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛ ⳿ⲥϣⲉ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ϩⲓ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲃⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⲓⲥϫⲉⲛ ϩⲏ ⲟⲩϩⲱⲟⲩⲧ ⲛⲉⲙ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲡⲉⲧⲁϥⲥⲟⲛⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲉⲣⲉ ⲡⲓⲣⲱⲙⲓ ⲭⲁ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲧⲟⲙϥ ⳿ⲉⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲙ⳿ⲡⲃ̅ ⲉⲩⲥⲁⲣⲝ ⳿ⲛⲟⲩⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ϩⲱⲥⲧⲉ ⲃ̅ ⲁⲛ ϫⲉ ⲛⲉ ⲁⲗⲗⲁ ⲟⲩⲥⲁⲣⲝ ⳿ⲛⲟⲩⲱⲧ ⲧⲉ ⲫⲏ ⲟⲩⲛ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲙϥ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ⲫⲣⲱⲙⲓ ⲫⲟⲣϫϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲟⲩⲛ ⳿ⲁ Ⲙⲱ⳿ⲩⲥⲏⲥ ϩⲟⲛϩⲉⲛ ⲉϯ ⳿ⲥϧⲓ ⳿ⲛⲟⲩⲉⲓ ⲟⲩⲟϩ ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲧⲉⲧⲉⲛⲙⲉⲧⲛⲁϣⲧϩⲏ ⲧ ⳿ⲁ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲱⲧⲉⲛ ⳿ⲉϩⲓ ⲛⲉⲧⲉⲛϩⲓ⳿ⲟⲙⲓ ⳿ⲉⲃⲟⲗ ⲓⲥϫⲉⲛ ϩⲏ ⲇⲉ ⳿ⲙⲡⲉⲥϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϩⲓ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩ⳿ⲉϣⲉⲛⲥⲁϫⲓ ⳿ⲙⲡⲟⲣⲛⲓ⳿ⲁ ⲁϥ⳿ⲑⲣⲟ ⳿ⲙⲙⲟⲥ ⳿ⲉ⳿ϫⲫⲉ ⲛⲱⲓⲕ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϭⲓ ⳿ⲛⲑⲏⲉⲧϩⲱⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ϥⲟⲓ ⳿ⲛⲛⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ⲡⲉϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉ ⳿ⲧⲉⲧⲓ⳿ⲁ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲛⲉⲙ ϯ⳿ⲥϩⲓⲙⲓ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲁⲛ ⳿ⲉϭⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϣⲱⲡ ⳿ⲙⲡⲁⲓⲥⲁϫⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲥⲧⲟⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","✠ ");
INSERT INTO copcnt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛϩⲁⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲭⲁ ϫⲓϫ ⳿ⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲃϩ ⳿ⲉϫⲱⲟⲩ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲁⲩⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲭⲁ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ⲓ ϩⲁⲣⲟⲓ ⲛⲓⲟⲩⲟⲛ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲑⲱⲟⲩ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁ ϫⲓϫ ⳿ⲉϫⲱⲟⲩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲁⲓ ϥ⳿ⲓ ϩⲁⲣⲟϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲥ ⲟⲩ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲛ ⳿ⲉϯⲛⲁⲁⲓϥ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲕϣⲓⲛⲓ ⳿ⲙⲙⲟⲓ ⲉⲑⲃⲉ ⲡⲓ⳿ⲁⲅⲁⲑⲟⲛ ⲟⲩⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲓ⳿ⲁⲅⲁⲑⲟⲥ Ⲫϯ ⲓⲥϫⲉ ⲇⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲱⲛϧ ⳿ⲁⲣⲉϩ ⳿ⲉⲛⲓⲉⲛⲧⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁϣ ⲛⲉ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲛⲉⲕϧⲱⲧⲉⲃ ⳿ⲛⲛⲉⲕⲉⲣⲛⲱⲓⲕ ⳿ⲛⲛⲉⲕϭⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲉⲕⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ⲙⲁⲧⲁⲓ⳿ⲉ ⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⲧⲉⲕⲙⲁⲩ ⲟⲩⲟϩ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ⲡⲉϫⲉ ⲡⲓϧⲉⲗϣ⳿ⲓⲣⲓ ⲛⲁϥ ϫⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⲓⲥϫⲉⲛ ⲧⲁⲙⲉⲧ⳿ⲁⲗⲟⲩ ⲟⲩ ⲟⲛ ⲡⲉ ϯϣⲁⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲓⲥϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲉⲉⲣ ⲟⲩⲧⲉⲗⲓⲟⲥ ⲙⲁϣⲉⲛⲁⲕ ⲙⲁ ⲫⲏ⳿ⲉⲧⲉ⳿ⲛⲧⲁⲕ ⳿ⲉⲃⲟⲗ ⲙⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⲉⲕ⳿ⲉ⳿ϫⲫⲟ ⲛⲁⲕ ⳿ⲛⲟⲩ⳿ⲁϩⲟ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲩ ⲟⲩⲁϩⲕ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓϧⲉⲗϣ⳿ⲓⲣⲓ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲣⲉ ⲡⲉϥϩⲏⲧ ⲙⲟⲕϩ ⲛⲉ ⲟⲩⲟⲛⲧⲉϥ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲛϩⲩⲡⲁⲣⲭⲟⲛⲧⲁ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲥⲙⲟⲕϩ ⳿ⲛⲧⲉ ⲟⲩⲣⲁⲙⲁ⳿ⲟ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ⲡⲁⲗⲓⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲥⲙⲟⲧⲉⲛ ⳿ⲛⲧⲉ ⲟⲩϫⲁⲙⲟⲩⲗ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⳿ⲑⲟⲩⲁⲑⲛⲓ ⳿ⲛⲧⲉ ⲟⲩⲙⲁ⳿ⲛⲑⲱⲣⲡ ⲓⲉ ⲟⲩⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉⲙⲁϣⲱ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ϩⲁⲣⲁ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲙⲉⲧⲁⲧϫⲟⲙ ⲡⲉ ⲫⲁⲓ ⳿ⲛⲧⲉⲛ Ⲫϯ ⲇⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ⲧⲟⲧⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲭⲁ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲛⲥⲱⲛ ⲟⲩⲟϩ ⲁⲛⲟⲩⲁϩⲧⲉⲛ ⳿ⲛⲥⲱⲕ ⲟⲩ ϩⲁⲣⲁ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϧⲁ ⲛⲏ⳿ⲉⲧⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ϧⲉⲛ ⲡⲓⲟⲩ⳿ⲁϩⲉⲙⲥⲱⲛⲧ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ϩⲉⲙⲥⲓ ϩⲓ ⲡⲓ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ⲱⲟⲩ ⲉⲩ⳿ⲉ⳿ⲧϩⲉⲙⲥⲉ ⲑⲏⲛⲟⲩ ϩⲱⲧⲉⲛ ϩⲓ ⲓ̅ⲃ̅ ⳿ⲛ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϯϩⲁⲡ ⳿ⲉϯⲓ̅ⲃ̅ ⳿ⲙⲫⲩⲗⲏ ⳿ⲛⲧⲉ Ⲡⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁϥⲭⲁ ⲥⲟⲛ ⳿ⲛⲥⲱϥ ⲓⲉ ⲥⲱⲛⲓ ⲓⲉ ⲓⲱⲧ ⲓⲉ ⲙⲁⲩ ⲓⲉ ⳿ⲥϩⲓⲙⲓ ⲓⲉ ϣⲏⲣⲓ ⲓⲉ ⲓⲟϩⲓ ⲓⲉ ⲏⲓ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ ⲉϥ⳿ⲉϭⲓⲧⲟⲩ ⳿ⲛⲣ̅ ⳿ⲛⲕⲱⲃ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⲡⲓⲱⲛϧ ⳿ⲛ⳿⳿ⲉⲛⲉϩ ⲉϥ⳿ⲉⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲛϣⲟⲣⲡ ⲉⲩⲛⲁⲉⲣϧⲁ⳿ⲉ ⲟⲩⲟϩ ϩⲁⲛϧⲁⲉⲩ ⲉⲩⲛⲁⲉⲣϣⲟⲣⲡ ");
INSERT INTO copcnt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲛⲉⲃⲓⲟϩⲓ ⳿ⲉⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⳿ⲉⲧⲁϩⲟ ⳿ⲛϩⲁⲛⲉⲣⲅⲁⲧⲏⲥ ⳿ⲉⲡⲉϥⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ⲁϥⲥⲉⲙⲛⲏⲧⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⳿ⲉϯ ⲛⲱⲟⲩ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲟⲩⲥⲁⲑⲉⲣⲓ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲡⲉϥⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲅ̅ ⲁϥⲛⲁⲩ ⳿ⲉϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϩⲓ ϯ⳿ⲁⲅⲟⲣⲁ ⲉⲩⲕⲟⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ⲡⲉϫⲁϥ ⳿ⲛⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲉⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲥⲉⲙ⳿ⲡϣⲁ ϯⲛⲁⲧⲏⲓϥ ⲛⲱⲧⲉⲛ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϣⲉⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲋ̅ ⲛⲉⲙ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲑ̅ ⲁϥ⳿⳿ⲓⲣⲓ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲓ̅ⲁ̅ ⲁϥϫⲓⲙⲓ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲧⲏⲣϥ ⳿ⲉⲣⲉⲧⲉⲛⲕⲟⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⲧⲁϩⲟⲛ ⳿ⲉ⳿ⲫⲃⲉⲭⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲉⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲉⲡⲓ⳿ⲧⲣⲟⲡⲟⲥ ϫⲉ ⲙⲟⲩϯ ⳿ⲉⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⲙⲁ ⲟⲩⲃⲉⲭⲉ ⲛⲱⲟⲩ ⳿ⲉⲁⲕⲉⲣϩⲏⲧⲥ ⲓⲥϫⲉⲛ ⲛⲓϧⲁⲉⲩ ϣⲁ ⲛⲓϩⲟⲩⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲁ ϯⲁϫⲡ ⲓ̅ⲁ̅ ⲁⲩϭⲓ ⳿ⲛⲟⲩⲥⲁⲑⲉⲣⲓ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓϩⲟⲩⲁϯ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ⲥⲉⲛⲁϭⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⲁⲩϭⲓ ⳿ⲛⲟⲩⲥⲁⲑⲉⲣⲓ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","⳿ⲉⲧⲁⲩϭⲓ ⲇⲉ ⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⳿ⲛⲥⲁ ⲡⲓⲛⲉⲃⲓⲟϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓϧⲁⲉⲩ ⲟⲩⲟⲩⲛⲟⲩ ⳿ⲛⲉⲣϩⲱⲃ ⲡⲉⲧⲁⲩⲁⲓⲥ ⲟⲩⲟϩ ⲁⲕⲁⲓⲧⲟⲩ ⳿ⲛϩⲩⲥⲟⲥ ⲛⲉⲙⲁⲛ ϧⲁ ⲛⲏ⳿ⲉⲧⲁⲩϥⲁⲓ ⳿ⲙ⳿ⲫⲃⲁⲣⲟⲥ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲡⲓⲕⲁⲩⲥⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⳿ⲛⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⲡⲁ⳿ϣⲫⲏⲣ ϯϭⲓ ⳿ⲙⲙⲟⲕ ⳿ⲛϫⲟⲛⲥ ⲁⲛ ⲙⲏ ⲟⲩⲥⲁⲑⲉⲣⲓ ⲁⲛ ⲡⲉⲧⲁⲓⲥⲉⲙⲛⲏⲧⲥ ⲛⲉⲙⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ϭⲓ ⳿ⲙⲫⲏ⳿ⲉⲧⲉⲫⲱⲕ ⲙⲁϣⲉⲛⲁⲕ ϯⲟⲩⲱϣ ⲇⲉ ⳿ⲉϯ ⳿ⲙⲡⲁⲓϧⲁ⳿ⲉ ⳿ⲙⲡⲉⲕⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ϣⲁⲛ ⳿ⲥϣⲉ ⲛⲏⲓ ⳿ⲉⲉⲣ ⲡⲉⲧⲉϩⲛⲏⲓ ϧⲉⲛ ⲛⲏ⳿ⲉⲧⲉⲛⲟⲩ⳿ⲓ ϣⲁⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲛⲑⲟⲕ ⳿ϥϩⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲁⲅⲁⲑⲟⲥ ⳿ⲁⲛⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ⲡⲁⲓⲣⲏϯ ⲛⲓϧⲁⲉⲩ ⲉⲩ⳿ⲉⲉⲣϣⲟⲣⲡ ⲟⲩⲟϩ ⲛⲓϣⲟⲣⲡ ⲉⲩ⳿ⲉⲉⲣϧⲁ⳿ⲉ ϩⲁⲛⲙⲏϣ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ϩⲁⲛⲕⲟⲩϫⲓ ⲛⲏⲉⲧⲥⲱⲧⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ⲉϥⲛⲁϣⲉⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁϥϭⲓ ⲙⲡⲓⲓ̅ⲃ̅ ⲟⲩⲧⲱϥ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϩⲓ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ϫⲉ ϩⲏⲡⲡⲉ ⲧⲉⲛⲛⲁϣⲉⲛⲁⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⲥⲉⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⳿ⲉ⳿ⲡⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲉⲛⲁⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲥⲉⲁϣϥ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲉϥ⳿ⲉⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ⲧⲟⲧⲉ ⲁⲥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⳿ⲑⲙⲁⲩ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ ⲛⲉⲥϣⲏⲣⲓ ⲉⲥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲉⲥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲟⲩⲁϣϥ ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⳿ⲁϫⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲁϣⲏⲣⲓ ⲃ̅ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ϩⲉⲙⲥⲓ ⲥⲁ ⲧⲉⲕⲟⲩ⳿ⲓⲛⲁⲙ ⲛⲉⲙ ⲟⲩⲁⲓ ⲥⲁ ⲧⲉⲕϫⲁϭⲏ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲧⲉⲕⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⳿ⲁⲣⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲉⲧⲓⲛ ⲉⲑⲃⲉ ⲟⲩ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲥⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⳿ⲉϯⲛⲁⲥⲟϥ ⲟⲩⲟϩ ⲡⲓⲱⲙⲥ ⳿ⲉϯⲛⲁⲱⲙⲥ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲉⲧ⳿ⲉⲛⲉⲙⲥ ⲑⲏⲛⲟⲩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⲙⲉⲛ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟϥ ⲟⲩⲟϩ ⲡⲓⲱⲙⲥ ⲧⲉⲧⲉⲛⲛⲁⲱⲙⲥ ⳿ⲙⲙⲟϥ ⳿ⲉϩⲉⲙⲥⲓ ⲇⲉ ⲥⲁⲧⲁⲟⲩ⳿ⲓⲛⲁⲙ ⲛⲉⲙ ⲧⲁϫⲁϭⲏ ⲫⲱⲓ ⲁⲛ ⲡⲉ ⳿ⲉⲧⲏⲓϥ ⲁⲗⲗⲁ ⲫⲁ ⲛⲏ ⲡⲉ ⳿ⲉⲧⲁ ⲡⲁⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲥⲉⲃⲧⲱⲧϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲕⲉ ⲓ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲉⲑⲃⲉ ⲡⲓⲥⲟⲛ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲛⲓⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲧⲟⲓ ⳿ⲛ⳪ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲛⲟⲩⲕⲉⲛⲓϣϯ ⲉⲧⲟⲓ ⳿ⲛⲉⲣϣⲓϣⲓ ⳿ⲉϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲁⲛ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲗⲗⲁ ⲫⲏⲑⲟⲩⲱϣ ⳿ⲉⲉⲣ ⲛⲓϣϯ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲉⲉⲣ ⲇⲓⲁⲕⲱⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ⲟⲩⲟϩ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲉⲣ ϩⲟⲩⲓⲧ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲉⲉⲣ ⲃⲱⲕ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","⳿ⲙ⳿ⲫⲣⲏϯ ϩⲱϥ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲛⲉⲧⲁϥ⳿ⲓ ⲁⲛ ⲉⲑⲣⲟⲩϣⲉⲙϣⲏⲧϥ ⲁⲗⲗⲁ ⳿ⲉϣⲉⲙϣⲓ ⲟⲩⲟϩ ⳿ⲉϯ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⳿ⲛⲥⲱϯ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ⲉϥⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲉⲣⲓⲭⲱ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ⲟⲩⲟϩ ⲓⲥ ⲃⲉⲗⲗⲉ ⲃ̅ ⲛⲁⲩϩⲉⲙⲥⲓ ⲉⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥⲓⲛⲓ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲉⲛ⳪ ⲛⲁⲓ ϧⲁⲣⲟⲛ Ⲓⲏ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ⲡⲓⲙⲏϣ ⲇⲉ ⲛⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲭⲁⲣⲱⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲟⲩ⳿ⲟ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲉⲛ⳪ ⲛⲁⲓ ϧⲁⲣⲟⲛ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲁⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ Ⲡⲉⲛ⳪ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲟⲩⲱⲛ ⳿ⲛϫⲉ ⲛⲉⲛⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","⳿ⲉⲧⲁϥϣⲉⲛϩⲏⲧ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϭⲓⲛⲉⲙ ⲛⲟⲩⲃⲁⲗ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲁⲩⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲛⲥⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ⲟⲩⲟϩ ϩⲟⲧⲉ ⳿ⲉⲧⲁⲩϧⲱⲛⲧ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲩ⳿ⲓ ⳿ⲉⲂⲏⲑⲫⲁⲅⲏ ϧⲁⲧⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⲧⲟⲧⲉ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲱⲣⲡ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲡⲁⲓϯⲙⲓ ⲉⲧⲭⲏ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲟⲩ⳿ⲉ⳿ⲱ ⲉⲥⲥⲟⲛϩ ⲛⲉⲙ ⲟⲩⲥⲏϫ ⲛⲉⲙⲁⲥ ⲃⲟⲗⲟⲩ ⳿ⲁⲛⲓⲧⲟⲩ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","⳿ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲇⲉ ⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲁϫⲟⲥ ϫⲉ Ⲡ⳪ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲱⲟⲩ ⳿ϥⲛⲁⲟⲩⲟⲣⲡⲟⲩ ⲇⲉ ⲥⲁⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ⲫⲁⲓ ⲇⲉ ϥϣⲱⲡⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ϫⲉ ⳿ⲁϫⲟⲥ ⳿ⲛ⳿ⲧϣⲉⲣⲓ ⳿ⲛⲤⲓⲱⲛ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲟⲩⲣⲟ ⳿ϥⲛⲏⲟⲩ ⲛⲉ ⳿ⲉⲟⲩⲣⲉⲙⲣⲁⲩϣ ⲡⲉ ⲉϥⲧⲁⲗⲏⲟⲩⲧ ⳿ⲉⲟⲩ⳿ⲉ⳿ⲱ ⲛⲉⲙ ⲟⲩⲥⲏϫ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲟⲩ⳿ⲉ⳿ⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿⳿ⲓⲣⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛϯ⳿ⲉ⳿ⲱ ⲛⲉⲙ ⲡⲓⲥⲏϫ ⲟⲩⲟϩ ⲁⲩⲧⲁⲗⲟ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲑⲣⲉϥϩⲉⲙⲥⲓ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","⳿ⲡϩⲟⲩ⳿ⲟ ⲇⲉ ⳿ⲛⲛⲓⲙⲏϣ ⲁⲩⲫⲱⲣϣ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ϩⲓ ⲡⲓⲙⲱⲓⲧ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩⲕⲱⲣϫ ⳿ⲛϩⲁⲛϫⲁⲗ ⳿ⲉⲃⲟⲗ ϩⲓ ⲛⲓ⳿ϣϣⲏⲛ ⲁⲩⲫⲟⲣϣⲟⲩ ϩⲓ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ⲛⲓⲙⲏϣ ⲇⲉ ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ϧⲁϫⲱϥ ⲛⲉⲙ ⲛⲏ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲱⲥⲀⲛⲛⲁ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲡⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⳿ⲱⲥⲀⲛⲛⲁ ϧⲉⲛ ⲛⲏⲉⲧϭⲟⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲥⲙⲟⲛⲙⲉⲛ ⳿ⲛϫⲉ ϯⲃⲁⲕⲓ ⲧⲏⲣⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ⲛⲓⲙⲏϣ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲩϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲛⲏⲉⲧϣⲱⲡ ⲟⲩⲟϩ ⲛⲓ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲉⲣⲕⲉⲣⲙⲁ ⲁϥⲫⲟⲛϫⲟⲩ ⲛⲉⲙ ⲛⲓⲕⲁⲑⲉⲇⲣⲁ ⳿ⲛⲧⲉ ⲛⲏⲉⲧϯ ϭⲣⲟⲙⲡⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲁⲏⲓ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲟⲩⲏⲓ ⳿ⲙ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲁ⳿ⲛⲭⲱⲡ ⳿ⲛⲥⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ⲛⲉⲙ ϩⲁⲛϭⲁⲗⲉⲩ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⳿ⲉⲛⲓ⳿ϣⲫⲏⲣⲓ ⳿ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⲛⲉⲙ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲉⲧⲱϣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲱⲥⲀⲛⲛⲁ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲕⲥⲱⲧⲉⲙ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉ ⲛⲁⲓ ϫⲱ ⳿ⲙⲙⲟϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⳿⳿ⲉⲛⲉϩ ϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϫⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱⲟⲩ ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲛⲉⲙ ⲛⲏⲉⲑⲟⲩⲉⲙϭⲓ ⲁⲕⲥⲉⲃⲧⲉ ⲡⲓ⳿ⲥⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁⲩ ⲁϥ⳿ⲓ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲃⲁⲕⲓ ⳿ⲉⲂⲏⲑⲁⲛⲓ⳿ⲁ ⲟⲩⲟϩ ⲁϥⲉⲛⲕⲟⲧ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","⳿ⲉⲧⲁ ⲧⲟⲟⲩ⳿ⲓ ⲇⲉ ϣⲱⲡⲓ ⲉϥⲛⲁⲧⲁⲥⲑⲟ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲃⲁⲕⲓ ⲁϥ⳿ϩⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ϩⲁⲣⲟⲥ ⳿ⲙⲡⲉϥϫⲉⲙ ⳿ϩⲗⲓ ϩⲓⲱⲧⲥ ⳿ⲉⲃⲏⲗ ⳿ⲉϩⲁⲛϫⲱⲃⲓ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩⲧⲁϩ ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏϯ ϣⲁ ⳿⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⲁⲥϣⲱⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲱⲥ ⳿ⲁ ⲧⲁⲓⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ϣⲱⲟⲩ⳿ⲓ ⳿ⲛⲧⲁⲓⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲉⲟⲩⲟⲛⲧⲉⲧⲉⲛ ⲛⲁϩϯ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣϩⲏⲧ ⲃ̅ ⳿ⲙⲫⲁ ⲧⲁⲓⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲁⲓϥ ⲁⲗⲗⲁ ⳿ⲁⲣⲉⲧⲉⲛϣⲁⲛϫⲟⲥ ⳿ⲙⲡⲁⲓⲧⲱⲟⲩ ϫⲉ ϥⲓⲧⲕ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲉⲥ⳿ⲉϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ⲟⲩⲟϩ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲟⲩ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲉⲣⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϭⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲕ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ ⲟⲩⲟϩ ⲛⲓⲙ ⲡⲉⲧⲁϥϯ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯⲛⲁϣⲉⲛ ⲑⲏⲛⲟⲩ ϩⲱ ⳿ⲉⲟⲩⲥⲁϫⲓ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛϣⲁⲛⲧⲁⲙⲟⲓ ⳿ⲉⲣⲟϥ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁⲧⲁⲙⲱⲧⲉⲛ ϫⲉ ⲁⲓ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉ ⲟⲩ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ϣⲁⲛ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲡⲉ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲉϣⲱⲡ ⲁⲛϣⲁⲛϫⲟⲥ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ⳿ϥⲛⲁϫⲟⲥ ⲛⲁⲛ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲛϣⲁⲛϫⲟⲥ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲡⲉ ⲧ⳿ⲉⲛⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲙⲏϣ Ⲓⲱⲁⲛⲛⲏⲥ ⲅⲁⲣ ⳿ⲛⲧⲟⲧⲟⲩ ϩⲱⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲱⲟⲩ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛϯⲛⲁⲧⲁⲙⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⲁⲓ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ⲟⲩ ⲇⲉ ⲡⲉ ⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ϣⲏⲣⲓ ⲃ̅ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ϩⲁ ⲡⲓϩⲟⲩⲓⲧ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁϣⲏⲣⲓ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲙⲫⲟⲟⲩ ⳿ⲁⲣⲓϩⲱⲃ ϧⲉⲛ ⲡⲁⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲁ⳪ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥϣⲉⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ⲁϥ⳿ⲓ ϩⲁ ⲡⲓⲙⲁϩⲃ̅ ⲁϥϫⲟⲥ ⲛⲁϥ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛϯⲟⲩⲱϣ ⲁⲛ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⳿ⲉⲧⲁϥⲟⲩⲉⲙ⳿ϩⲑⲏϥ ⲁϥϣⲉⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ⲛⲓⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲃ̅ ⲁϥⲉⲣ ⲡⲉⲧⲉϩⲛⲉ ⲡⲉϥⲓⲱⲧ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲓϧⲁ⳿ⲉ ⲡⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲡⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲡⲟⲣⲛⲟⲥ ⲥⲉⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ⲁϥ⳿ⲓ ⲅⲁⲣ ϩⲁⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ϧⲉⲛ ⳿ⲫⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓⲡⲟⲣⲛⲟⲥ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲁⲣⲉⲧⲉⲛⲛⲁⲩ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲧⲉⲛⲟⲩⲉⲙ ⳿ϩⲑⲏⲧⲉⲛ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⳿ⲉ⳿ⲡϫⲓⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ⲥⲱⲧⲉⲙ ⳿ⲉⲕⲉ ⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲛⲉⲃⲓⲟϩⲓ ⳿ⲉⲁϥϭⲟ ⳿ⲛⲟⲩⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲁϥⲧⲁⲕⲧⲟ ⳿ⲛⲟⲩϫⲟⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲁϥϣⲱⲕ ⳿ⲛⲟⲩ⳿ϩⲣⲱⲧ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ϥⲕⲱⲧ ⳿ⲛⲟⲩⲡⲩⲣⲅⲟⲥ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛⲟⲩⲓⲏ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲛϫⲉ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲧⲁϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ϩⲁ ⲛⲓⲟⲩⲓⲏ ⳿ⲉϭⲓ ⳿ⲛⲛⲉϥⲟⲩⲧⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ⲟⲩⲟϩ ⳿ⲁ ⲛⲓⲟⲩⲓⲏ ϭⲓ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⲟⲩⲁⲓ ⲙⲉⲛ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟϥ ⲕⲉ ⲟⲩⲁⲓ ⲇⲉ ⲁⲩϧⲟⲑⲃⲉϥ ⲕⲉ ⲟⲩⲁⲓ ⲇⲉ ⲁⲩϩⲓ⳿ⲱⲛⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲛϩⲁⲛⲕⲉ⳿ⲉⲃⲓⲁⲓⲕ ⲉⲩⲟϣ ⳿ⲉⲛⲓϩⲟⲩ⳿ⲁϯ ⲟⲩⲟϩ ⲁⲩ⳿⳿ⲓⲣⲓ ⲛⲱⲟⲩ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉϥϣⲏⲣⲓ ϩⲁⲣⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲥⲉⲛⲁ⳿ϣⲫⲓⲧ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲁϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ⲛⲓⲟⲩⲓⲏ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲡⲓϣⲏⲣⲓ ⲡⲉϫⲱⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲛⲧⲉⲛϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛϭⲓ ⳿ⲛⲧⲉϥ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ⲟⲩⲟϩ ⲁⲩϭⲓⲧϥ ⲁⲩϩⲓⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲁⲩϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⳿ⲡ⳪ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉϥⲛⲁⲁⲓϥ ⳿ⲛⲛⲓⲟⲩⲓⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲛⲓⲕⲁⲕⲱⲥ ⲉϥ⳿ⲉⲧⲁⲕⲱⲟⲩ ⳿ⲛⲕⲁⲕⲱⲥ ⲟⲩⲟϩ ⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲉϥ⳿ⲉⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛⲕⲉⲟⲩⲓⲏ ⲛⲏⲉⲑⲛⲁϯ ⳿ⲛⲛⲉϥⲟⲩⲧⲁϩ ⲛⲁϥ ϧⲉⲛ ⲡⲟⲩⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⳿⳿ⲉⲛⲉϩ ϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϫⲉ ⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲧⲁⲩϣⲟϣϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲕⲟϯ ⲫⲁⲓ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲱϫ ⳿ⲛⲗⲁⲕϩ ⳿ⲉⲧⲁ ⲫⲁⲓ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲡ⳪ ⲟⲩⲟϩ ⳿ϥⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⲛⲉⲛⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ⲉⲑⲃⲉ ⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲉⲩ⳿ⲉⲟⲗⲥ ⳿ⲛⲧⲉⲛⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲧⲏⲓⲥ ⳿ⲛⲕⲉ ⲉⲑⲛⲟⲥ ⲫⲏⲉⲑⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲉⲥⲟⲩⲧⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲓ⳿ⲱⲛⲓ ⲉϥ⳿ⲉⲗⲁⲥϥ ⲫⲏ ⲇⲉ ⳿ⲉⲧⲉϥⲛⲁϩⲉⲓ ⳿ⲉϫⲱϥ ⲉϥ⳿ⲉϣⲁϣϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⳿⳿ⲉⲛⲉϥⲡⲁⲣⲁⲃⲟⲗⲏ ⲁⲩ⳿ⲉⲙⲓ ϫⲉ ⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⳿ⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⲁⲩⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲙⲏϣ ϫⲉ ⲛⲁϥⲭⲏ ⳿ⲛⲧⲟⲧⲟⲩ ⲡⲉ ϩⲱⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ");
INSERT INTO copcnt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲟⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲟⲩⲣⲟ ⳿ⲉⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩϩⲟⲡ ⳿ⲉⲡⲉϥϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉⲙⲟⲩϯ ⲟⲩⲃⲉ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓϩⲟⲡ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲟⲩⲱϣ ⳿ⲉ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛϩⲁⲛⲕⲉ⳿ⲉⲃⲓⲁⲓⲕ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁϫⲟⲥ ⳿ⲛⲛⲏⲉⲧⲑⲁϩⲉⲙ ϫⲉ ⲓⲥ ⲡⲁ⳿ⲁⲣⲓⲥⲧⲟⲛ ⲁⲓⲥⲉⲃⲧⲱⲧϥ ⲛⲁⲙⲁⲥⲓ ⲛⲉⲙ ⲛⲏⲉⲧϣⲁⲛⲉⲩϣ ⲥⲉϣⲁⲧ ⲥⲉⲥⲉⲃⲧⲱⲧ ⲧⲏⲣⲟⲩ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓϩⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲉⲣ⳿ⲁⲙⲉⲗⲉⲥ ⲁⲩϣⲉⲛⲱⲟⲩ ⲟⲩⲁⲓ ⲙⲉⲛ ⳿ⲉⲡⲉϥⲓⲟϩⲓ ⲕⲉ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉⲧⲉϥⲓⲉⲃϣⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","⳿ⲡⲥⲉⲡⲓ ⲇⲉ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⲁⲩϣⲟϣⲟⲩ ⲟⲩⲟϩ ⲁⲩϧⲟⲑⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ⲡⲓⲟⲩⲣⲟ ⲇⲉ ⳿ⲉⲧⲥⲱⲧⲉⲙ ⲁϥϫⲱⲛⲧ ⲟⲩⲟϩ ⲁϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲙⲛⲉϥ⳿ⲥⲧⲣⲁⲧⲉⲩⲙⲁ ⲟⲩⲟϩ ⲁϥⲧⲁⲕⲟ ⳿ⲛⲛⲓⲣⲉϥϧⲱⲧⲉⲃ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲧⲟⲩⲃⲁⲕⲓ ⲁϥⲣⲟⲕϩⲥ ϧⲉⲛ ⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲕ ϫⲉ ⲡⲓϩⲟⲡ ⲙⲉⲛ ⲉϥⲥⲉⲃⲧⲱⲧ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ⲇⲉ ⲛⲁⲩⲉⲙ⳿ⲡϣⲁ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲓⲙⲁⲛⲙⲟϣⲓ ⳿ⲛⲧⲉ ⲛⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁϫⲉⲙⲟⲩ ⲑⲁϩⲙⲟⲩ ⳿ⲉϧⲟⲩⲛ ⲉⲡⲓϩⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉ ⲛⲓⲙⲱⲓⲧ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϫⲉⲙⲟⲩ ⲛⲏⲉⲧϩⲱⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲁⲛⲉⲩ ⲟⲩⲟϩ ⲁϥⲙⲟϩ ⳿ⲛϫⲉ ⲡⲓϩⲟⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲣⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲣⲟ ⳿ⲉⲛⲁⲩ ⳿ⲉⲛⲏⲉⲑⲣⲱⲧⲉⲃ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛ⳿ⲧϩⲉⲃⲥⲱ ⳿ⲙⲡⲓϩⲟⲡ ⲧⲟⲓ ϩⲓⲱⲧϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁ⳿ϣⲫⲏⲣ ⲡⲱⲥ ⲁⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲙⲛⲁⲓ ⳿ⲛ⳿ⲧϩⲉⲃⲥⲱ ⳿ⲙⲡⲓϩⲟⲡ ⲧⲟⲓ ϩⲓⲱⲧⲕ ⲁⲛ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲁ ⲣⲱϥ ⲑⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ⲧⲟⲧⲉ ⲡⲉϫⲉ ⲡⲓⲟⲩⲣⲟ ⳿ⲛⲛⲓⲇⲓ⳿ⲁⲕⲱⲛ ϫⲉ ⲥⲱⲛϩ ⳿ⲙⲫⲁⲓ ⳿ⲛⲧⲟⲧϥ ⲛⲉⲙ ⲣⲁⲧϥ ϩⲓⲧϥ ⳿ⲉⲡⲓⲭⲁⲕⲓ ⲉⲧⲥⲁⲃⲟⲗ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⲉⲩⲑⲁϩⲉⲙ ϩⲁⲛⲕⲟⲩϫⲓ ⲇⲉ ⲛⲉ ⲛⲓⲥⲱⲧⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ⲧⲟⲧⲉ ⲁⲩϣⲉ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁⲩⲉⲣⲟⲩⲥⲟϭⲛⲓ ϧⲁⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲥⲉϫⲟⲣϫϥ ⳿ⲛⲟⲩⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛⲛⲟⲩⲙⲁⲑⲏⲧⲏⲥ ϩⲁⲣⲟϥ ⲛⲉⲙ ⲛⲓⲎ̇ⲣⲱⲇⲓⲁⲛⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲑⲙⲏⲓ ⲟⲩⲟϩ ⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲕϯ⳿ⲥⲃⲱ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲥⲉⲣⲙⲉⲗⲓⲛ ⲛⲁⲕ ⲁⲛ ϧⲁ⳿ⲧϩⲏ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛ⳿ⲕϫⲟⲩϣⲧ ⲅⲁⲣ ⲁⲛ ⳿ⲉϩⲟ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","⳿ⲁϫⲟⲥ ⲟⲩⲛ ⲛⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⳿ⲥϣⲉ ⳿ⲉϯϩⲱϯ ⲙ⳿ⲡⲟⲩⲣⲟ ϣⲁⲛ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲧⲟⲩⲙⲉⲧⲥⲁⲙⲡⲉⲧϩⲱⲟⲩ ⲡⲉϫⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛϭⲱⲛⲧ ⳿ⲙⲙⲟⲓ ⲛⲓϣⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ⲙⲁⲧⲁⲙⲟⲓ ⳿ⲉ⳿ⲫⲛⲟⲙⲓⲥⲙⲁ ⳿ⲛⲧⲉ ⲛⲓⲕⲏⲛⲥⲟⲥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲥⲁⲑⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲧⲁⲓϩⲓⲕⲱⲛ ⲑⲁ ⲛⲓⲙ ⲧⲉ ⲛⲉⲙ ⲛⲁⲓ⳿ⲥϧⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⲛⲉ ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲟⲩⲟϩ ⲙⲁ ⲛⲁ Ⲫϯ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲟⲩⲟϩ ⲁⲩⲭⲁϥ ⲁⲩϣⲉⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲛⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲛⲁϣⲱⲡⲓ ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲁ Ⲙⲱ⳿ⲩⲥⲏⲥ ϫⲟⲥ ⲛⲁⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲙⲟⲩ ⳿ⲙⲙⲟⲛⲧⲉϥ ϣⲏⲣⲓ ⳿ⲙⲙⲁⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉϥⲥⲟⲛ ϭⲓ ⳿ⲛⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲟⲩⲛⲟⲥ ⲟⲩ⳿ϫⲣⲟϫ ⳿ⲙⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ⲛⲉ ⲟⲩⲟⲛ ⲍ̅ ⲇⲉ ⳿ⲛⲥⲟⲛ ϧⲁⲧⲟⲧⲉⲛ ⲡⲉ ⲟⲩⲟϩ ⲡⲓϩⲟⲩⲓⲧ ⳿ⲉⲧⲁϥϭⲓ ⲁϥⲙⲟⲩ ⲟⲩⲟϩ ⲛⲉ ⳿ⲙⲙⲟⲛⲧⲉϥ ⳿ϫⲣⲟϫ ⳿ⲙⲙⲁⲩ ⲁϥⲭⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓⲙⲁϩ ⲃ̅ ⲛⲉⲙ ⲡⲓⲙⲁϩ ⲅ̅ ϣⲁ ⲡⲓⲙⲁϩ ⲍ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲁⲥⲙⲟⲩ ⳿ⲛϫⲉ ϯⲕⲉ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ϧⲉⲛ ϯ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲟⲩⲛ ⲁⲥⲛⲁⲉⲣ ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲛⲓⲙ ϧⲉⲛ ⲡⲓ ⲍ̅ ⲁⲩϭⲓⲥ ⲅⲁⲣ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲥⲱⲣⲉⲙ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛⲛⲓ⳿ⲅⲣⲁⲫⲏ ⲟⲩⲇⲉ ϯϫⲟⲙ ⳿ⲛⲧⲉ Ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ϧⲉⲛ ϯ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲅⲁⲣ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭⲓⲧⲟⲩ ⲁⲗⲗⲁ ⲁⲩⲛⲁⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ⲉⲑⲃⲉ ϯ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⳿ⲙⲫⲏ⳿ⲉⲧⲁⲩϫⲟϥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲫϯ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲫϯ ⳿ⲛⲀⲃⲣⲁⲁⲙ ⲛⲉⲙ Ⲫϯ ⳿ⲛ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ Ⲫϯ ⳿ⲛⲒⲁⲕⲱⲃ Ⲫϯ ⲫⲁ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲁ ⲛⲏⲉⲧⲟⲛϧ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⲁϥⲑⲱⲙ ⳿ⲛⲣⲱⲟⲩ ⳿ⲛⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲁⲩⲑⲱⲟⲩϯ ⲉⲩⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ⲟⲩⲟϩ ⲁϥϣⲉⲛϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲟⲩⲛⲟⲙⲓⲕⲟⲥ ⲡⲉ ⲉϥϭⲱⲛⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲁϣ ⲧⲉ ϯⲛⲓϣϯ ⳿ⲛⲉⲛⲧⲟⲗⲏ ⲉⲧϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕϩⲏⲧ ⲧⲏⲣϥ ⲛⲉⲙ ⲧⲉⲕⲯⲩⲭⲏ ⲧⲏⲣⲥ ⲛⲉⲙ ⲛⲉⲕⲙⲉⲩⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ⲑⲁⲓ ⲧⲉ ϯⲛⲓϣϯ ⲟⲩⲟϩ ⳿ⲛϩⲟⲩⲓϯ ⳿ⲛⲉⲛⲧⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ϯⲙⲁϩ ⲃ̅ϯ ⲇⲉ ⲉⲧ⳿ⲟⲛⲓ ⳿ⲛⲑⲁⲓ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ϧⲉⲛ ⲧⲁⲓⲉⲛⲧⲟⲗⲏ ⲃ̅ϯ ⲡⲓⲛⲟⲙⲟⲥ ⲧⲏⲣϥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲁⲩ⳿ⲁϣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⲇⲉ ⲉⲩⲙⲁ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁϥϣⲉⲛⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉ Ⲡⲭ̅ⲥ̅ ϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲛⲛⲓⲙ ⲡⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲡⲱⲥ ⲟⲩⲛ Ⲇⲁⲩⲓⲇ ϧⲉⲛ ⲡⲓ⳿ⲡ͞ⲛⲁ̅ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲁ⳪ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ϫⲉ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲠⲁ⳪̅ ϫⲉ ϩⲉⲙⲥⲓ ⲥⲁⲧⲟⲩⲓⲛⲁⲙ ϣⲁϯⲭⲱ ⳿ⲛⲛⲉⲕϫⲁϫⲓ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛⲛⲉⲕϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ⲓⲥϫⲉ ⲟⲩⲛ Ⲇⲁⲩⲓⲇ ϧⲉⲛ ⲡⲓ⳿ⲡⲛⲉⲩⲙⲁ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲁ⳪ ⲡⲱⲥ ⲡⲉϥϣⲏⲣⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛⲟⲩⲥⲁϫⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ϣⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉϣⲉⲛϥ ⲓⲥϫⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ");
INSERT INTO copcnt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ⲧⲟⲧⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓⲙⲏϣ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁⲩϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ϯⲕⲁⲑⲉⲇⲣⲁ ⳿ⲛⲧⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲟⲩⲛⲁϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⳿ⲁⲣⲓⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲙⲡⲉⲣ⳿⳿ⲓⲣⲓ ⲇⲉ ⲕⲁⲧⲁ ⲛⲟⲩ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲥⲉϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⲥⲉ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ⲥⲉⲙⲟⲩⲣ ⲇⲉ ⳿ⲛϩⲁⲛⲉⲧⲫⲱⲟⲩ⳿ⲓ ⲉⲩϩⲟⲣϣ ⲟⲩⲟϩ ⲥⲉⲧⲁⲗⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϫⲉⲛ ⳿ⲑⲛⲁϩⲃⲓ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲥⲉⲟⲩⲱϣ ⳿ⲉⲕⲓⲙ ⳿ⲉⲣⲱⲟⲩ ⲁⲛ ⳿ⲙⲡⲟⲩⲧⲏⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ⲛⲟⲩ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⲥⲉ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲉⲑⲣⲟⲩⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲥⲉⲟⲩⲱϣⲥ ⲅⲁⲣ ⳿ⲛⲛⲟⲩⲫⲩⲗⲁⲕⲧⲏⲣⲓⲟⲛ ⲟⲩⲟϩ ⲥⲉ⳿ⲑⲣⲟ ⳿ⲛⲛⲉⲛ⳿ϣⲧⲁϯ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲉϣⲓⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ⲥⲉⲙⲉⲓ ⲇⲉ ⳿ⲛⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁⲛⲣⲱⲧⲉⲃ ϧⲉⲛ ⲛⲓⲇⲓⲡⲛⲟⲛ ⲛⲉⲙ ⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛϩⲉⲙⲥⲓ ϩⲓ ⲛⲓⲕⲁⲑⲉⲇⲣⲁ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ⲛⲉⲙ ⲛⲓⲁⲥⲡⲁⲥⲙⲟⲥ ϧⲉⲛ ⲛⲓ⳿ⲁⲅⲟⲣⲁ ⲉⲑⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ϫⲉ ⲣⲁⲃⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉ ⲣⲁⲃⲃⲓ ⲟⲩⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲉⲧⲉⲛⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲙⲟⲩϯ ⲟⲩⲃⲉ ⲓⲱⲧ ⲛⲱⲧⲉⲛ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲟⲩⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲟⲩⲙⲟⲩϯ ⲟⲩⲃⲉ ⲥⲁϧ ⲛⲱⲧⲉⲛ ⲟⲩⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲉⲧⲉⲛⲥⲁϧ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ⲡⲓⲛⲓϣϯ ⲇⲉ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲉⲉⲣⲇⲓ⳿ⲁⲕⲱⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϭⲁⲥϥ ⲥⲉⲛⲁⲑⲉⲃⲓⲟϥ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲑⲉⲃⲓⲟϥ ⲥⲉⲛⲁϭⲁⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛⲟⲩⲱⲙ ⳿ⲛⲛⲓⲏⲓ ⳿ⲛⲧⲉ ⲛⲓⲭⲏⲣⲁ ϧⲉⲛ ⲟⲩⲗⲱⲓϫⲓ ⲉⲥⲟⲩ⳿ⲏⲟⲩ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ⲧⲉⲧⲉⲛϭⲓ ⳿ⲛⲟⲩϩⲁⲡ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛ⳿ϣⲑⲁⲙ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲅⲁⲣ ⲧⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ⲁⲛ ⲟⲩⲇⲉ ⲛⲏⲉⲑⲛⲏⲟⲩ ⲧⲉⲧⲉⲛⲭⲱ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲛⲉⲙ ⲡⲉⲧϣⲟⲩ⳿ⲱⲟⲩ ⲉⲑⲣⲉⲧⲉⲛⲑⲁⲙⲓ⳿ⲟ ⳿ⲛⲟⲩ⳿ⲡⲣⲟⲥ⳿ⲏⲗⲓⲧⲟⲥ ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛϣⲱⲡⲓ ⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϣⲏⲣⲓ ⳿ⲛⲅⲉⲉⲛⲛⲁ ⲉϥⲕⲏⲃ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓϭⲁⲩⲙⲱⲓⲧ ⳿ⲙⲃⲉⲗⲗⲉ ⲛⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁⲱⲣⲕ ⳿ⲙⲡⲓⲉⲣⲫⲉⲓ ⳿ϩⲗⲓ ⲡⲉ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲱⲣⲕ ⳿ⲙⲡⲓⲛⲟⲩⲃ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ⲛⲓⲥⲟϫ ⲟⲩⲟϩ ⳿ⲙⲃⲉⲗⲗⲉ ⲛⲓⲙ ⲅⲁⲣ ⲉⲧⲟⲓ ⳿ⲛⲛⲓϣϯ ⲡⲓⲛⲟⲩⲃ ⲡⲉ ϣⲁⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲧⲧⲟⲩⲃⲟ ⳿ⲙⲡⲓⲛⲟⲩⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ⲟⲩⲟϩ ⲫⲏⲑⲛⲁⲱⲣⲕ ⳿ⲙⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ ⳿ϩⲗⲓ ⲡⲉ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲱⲣⲕ ⳿ⲙⲡⲓⲧⲁⲓ⳿ⲟ ⲉⲧⲭⲏ ϩⲓϫⲱϥ ⲟⲩⲟⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ⲛⲓⲥⲟϫ ⲟⲩⲟϩ ⳿ⲙⲃⲉⲗⲗⲉ ⲁϣ ⲅⲁⲣ ⲉⲧⲟⲓ ⳿ⲛⲛⲓϣϯ ⲡⲓⲧⲁⲓ⳿ⲟ ⲡⲉ ϣⲁⲛ ⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ ⲉⲧⲧⲟⲩⲃⲟ ⳿ⲙⲡⲓⲧⲁⲓ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ⲫⲏ ⲟⲩⲛ ⲉⲧⲱⲣⲕ ⳿ⲙⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ ⲁϥⲱⲣⲕ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲭⲏ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ⲟⲩⲟϩ ⲫⲏⲉⲧⲱⲣⲕ ⳿ⲙⲡⲓⲉⲣⲫⲉⲓ ⲁϥⲱⲣⲕ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲫⲏⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ⲟⲩⲟϩ ⲫⲏⲉⲧⲱⲣⲕ ⳿ⲛ⳿ⲧⲫⲉ ⲁϥⲱⲣⲕ ⳿ⲙⲡⲓ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲛⲧⲉ Ⲫϯ ⲛⲉⲙ ⲫⲏⲉⲧϩⲉⲙⲥⲓ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","✠ ");
INSERT INTO copcnt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ⲛⲓϭⲁⲩⲙⲱⲓⲧ ⳿ⲙⲃⲉⲗⲗⲉ ⲛⲏⲉⲧⲥⲱϥ ⳿ⲛϯϣⲟⲗⲙⲉⲥ ⲟⲩⲟϩ ⲉⲧⲟⲙⲕ ⳿ⲙⲡⲓϫⲁⲙⲟⲩⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛⲧⲟⲩⲃⲟ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲁⲫⲟⲧ ⲛⲉⲙ ϯⲡⲁⲣⲟⲯⲓⲥ ⲥⲁϧⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ⲙⲉϩ ⳿ⲛϩⲱⲗⲉⲙ ⲛⲉⲙ ϭⲱϧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ⲡⲓⲃⲉⲗⲗⲉ ⳿ⲙⲪⲁⲣⲓⲥⲉⲟⲥ ⲙⲁⲧⲟⲩⲃⲟ ⲥⲁϧⲟⲩⲛ ⳿ⲙⲡⲓ⳿ⲁⲫⲟⲧ ⳿ⲛϣⲟⲣⲡ ⲛⲉⲙ ϯⲡⲁⲣⲟⲯⲓⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲟⲛⲓ ⳿ⲛϩⲁⲛ⳿ⲙϩⲁⲩ ⲉⲩⲟϣϫ ⳿ⲛⲕⲟⲛⲓ⳿ⲁ ⲥⲁⲃⲟⲗ ⲙⲉⲛ ⳿ⲙⲙⲱⲟⲩ ⲥⲉⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿⳿ⲉⲛⲉⲥⲱⲟⲩ ⲥⲁϧⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ⲙⲉϩ ⳿ⲛⲕⲁⲥ ⳿ⲛⲣⲉϥⲙⲱⲟⲩⲧ ⲛⲉⲙ ϭⲱϧⲉⲙ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲥⲁⲃⲟⲗ ⲙⲉⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲑⲙⲏⲓ ⲥⲁϧⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲧⲉⲛ ⲙⲉϩ ⳿ⲙⲙⲉⲧϣⲟⲃⲓ ⲛⲉⲙ ⳿ⲁⲛⲟⲙⲓ⳿ⲁ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲓϣⲟⲃⲓ ϫⲉ ⲧⲉⲧⲉⲛⲕⲱⲧ ⳿ⲛⲛⲓ⳿ⲙϩⲁⲩ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲟⲗⲥⲉⲗ ⳿ⲛⲛⲓⲃⲏⲃ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ⲟⲩⲟϩ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿⳿ⲉⲛⲉ ⲁⲛⲭⲏ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲛⲀⲛⲛⲁϣⲱⲡⲓ ⲉⲛⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲣⲱⲟⲩ ⲁⲛ ⲡⲉ ϧⲉⲛ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ϩⲱⲥⲧⲉ ⲧⲉⲧ⳿ⲉⲛⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩϧⲱⲧⲉⲃ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ϫⲉⲕ ⳿ⲡϣⲓ ⳿ⲛⲧⲉ ⲛⲉⲧⲉⲛⲓⲟϯ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ⲛⲓϩⲟϥ ⳿ⲙⲙⲓⲥⲓ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲁϫⲱ ⲡⲱⲥ ⲧⲉⲧⲉⲛⲛⲁ⳿ϣⲫⲱⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⳿ⲛⲧⲉ ϯⲅⲉⲉⲛⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ⲉⲑⲃⲉ ⲫⲁⲓ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲟⲩⲱⲣⲡ ϩⲁⲣⲱⲧⲉⲛ ⳿ⲛϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ϩⲁⲛⲥⲁⲃⲉⲩ ⳿ⲛⲥⲁϧ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϧⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲓϣⲓ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲛⲉⲧⲉⲛⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϭ ⲟϫⲓ ⳿ⲛⲥⲱⲟⲩ ⲓⲥϫⲉⲛ ⲃⲁⲕⲓ ⳿ⲉⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⳿ⲥⲛⲟϥ ⲛⲓⲃⲉⲛ ⳿ⲛ⳿ⲑⲙⲏⲓ ⳿ⲉⲧⲁⲩⲫⲟⲛϥ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲓⲥϫⲉⲛ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲀⲃⲏⲗ ⲡⲓ⳿ⲑⲙⲏⲓ ϣⲁ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲌⲁⲭⲁⲣⲓⲁⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲂⲁⲣⲁⲭⲓⲁⲥ ⲫⲏ⳿ⲉⲧⲁⲣⲉⲧⲉⲛϧⲟⲑⲃⲉϥ ⲟⲩⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲡⲓⲙⲁⲛⲉⲣϣⲱⲟⲩϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉⲣⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲓ ⳿ⲉϫⲉⲛ ⲧⲁⲓⲅ⳿ⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ⲓⲗ̅ⲏ̅ⲙ̅ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲑⲏⲉⲧϧⲱⲧⲉⲃ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⲉⲧϩⲓ⳿ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲛⲏ⳿ⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ ϩⲁⲣⲟⲥ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⲁⲓⲟⲩⲱϣ ⳿ⲉⲑⲟⲩⲏⲧ ⲛⲉϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϩⲁⲗⲏⲧ ⳿ⲉϣⲁϥⲑⲱⲟⲩϯ ⳿ⲛⲛⲉϥⲙⲁⲥ ⳿ⲉϧⲟⲩⲛ ϧⲁ ⲛⲉϥⲧⲉⲛϩ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲟⲩⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ϩⲏⲡⲡⲉ ϯⲛⲁⲭⲱ ⳿ⲙⲡⲉⲧⲉⲛⲏⲓ ⲛⲱⲧⲉⲛ ⲉϥϣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲛⲛⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ϣⲁⲧⲉⲧⲉⲛϫⲟⲥ ϫⲉ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ");
INSERT INTO copcnt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩⲧⲁⲙⲟ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲓⲕⲱⲧ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲟⲩⲭⲁ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲥⲉⲛⲁⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ⲉϥϩⲉⲙⲥⲓ ⲇⲉ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩ⳿ⲁⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁϫⲟⲥ ⲛⲁⲛ ϫⲉ ⳿ⲁⲣⲉ ⲛⲁⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲟⲩⲟϩ ⲁϣ ⲡⲉ ⲡⲓⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ ⲡⲉⲕϫⲓⲛ⳿ⲓ ⲛⲉⲙ ⳿ⲧϧⲁ⳿ⲉ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲣⲭⲁⲥ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲥⲉⲣⲉⲙ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","⳿ⲉⲣⲉ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲓ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲥⲉⲣⲉⲙ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉϩⲁⲛⲃⲱⲧⲥ ⲛⲉⲙ ϩⲁⲛ⳿ⲥⲙⲏ ⳿ⲙⲃⲱⲧⲥ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲣ⳿ϣⲑⲟⲣⲧⲉⲣ ϩⲱϯ ⲅⲁⲣ ⲡⲉ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⲁⲗⲗⲁ ⳿ⲙⲡⲁⲧⲉ ⳿ⲧϧⲁ⳿ⲉ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","⳿ⲉⲣⲉ ⲟⲩⲉⲑⲛⲟⲥ ⲅⲁⲣ ⲧⲱⲛϥ ⳿ⲉϫⲉⲛ ⲟⲩⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛⲙⲟⲛⲙⲉⲛ ⲛⲉⲙ ϩⲁⲛ⳿ϩⲕⲟ ⲛⲉⲙ ϩⲁⲛⲙⲟⲩ ⲕⲁⲧⲁ ⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ϩⲏ ⳿ⲛⲛⲓⲛⲁⲕϩⲓ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ⲧⲟⲧⲉ ⲉⲩ⳿ⲉϯ ⲑⲏⲛⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲡϩⲟϫϩⲉϫ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϧⲉⲧⲉⲃ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϣⲱⲡⲓ ⲉⲩⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ⲧⲟⲧⲉ ⳿ⲉⲣⲉ ⲟⲩⲙⲏϣ ⲭⲁⲧⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϯ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲙⲉⲥⲧⲉ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲛⲟⲩϫ ⲉⲩ⳿ⲉⲧⲱⲟⲩⲛⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲥⲉⲣⲉⲙ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ⲟⲩⲟϩ ⲉⲑⲃⲉ ⳿ⲡ⳿ⲁϣⲁⲓ ⳿ⲛⲧⲉ ϯ⳿⳿ⲁⲛⲟⲙⲓ⳿ⲁ ⳿ⲧ⳿⳿ⲁⲅⲁⲡⲏ ⳿ⲛⲟⲩⲙⲏϣ ⲉⲥ⳿ⲉ⳿ϩⲣⲟϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲟⲧϥ ϣⲁ ⳿ⲉⲃⲟⲗ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲑⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϩⲓⲱⲓϣ ⳿ⲙⲡⲁⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ϧⲉⲛ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲧⲏⲣⲥ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲧⲟⲧⲉ ⲉⲥ⳿ⲉ⳿ⲓ ⳿ⲛϫⲉ ϯϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲡⲓⲥⲱϥ ⳿ⲛⲧⲉ ⳿ⲡϣⲁϥⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲇⲁⲛⲓⲏⲗ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲑⲟⲩⲁⲃ ⲫⲏⲉⲧⲱϣ ⲙⲁⲣⲉϥⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ⲧⲟⲧⲉ ⲛⲏⲉⲧⲭⲏ ϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲙⲁⲣⲟⲩⲫⲱⲧ ⳿ⲉϫⲉⲛ ⲛⲓⲧⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ⲟⲩⲟϩ ⲫⲏⲉⲧⲭⲏ ϩⲓϫⲉⲛ ⳿ⲡϫ⳿ⲉⲛⲉⲫⲱⲣ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲉⲗ ⲛⲏⲉⲧϧⲉⲛ ⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ⲟⲩⲟϩ ⲫⲏⲉⲧⲭⲏ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥⲕⲟⲧϥ ⳿ⲉⲫⲁϩⲟⲩ ⳿ⲉⲉⲗ ⲉϥ⳿ϩⲃⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ⲟⲩⲟⲓ ⲇⲉ ⳿ⲛⲛⲏ⳿ⲉⲧⲉ ⳿ⲙⲃⲟⲕⲓ ⲛⲉⲙ ⲛⲏⲉⲧϯϭⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ⲧⲱⲃϩ ⲇⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲉⲧⲉⲛⲫⲱⲧ ϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧ⳿ⲫⲣⲱ ⲟⲩⲇⲉ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","⳿ⲉⲣⲉ ⲟⲩⲛⲓϣϯ ⲅⲁⲣ ⳿ⲛϩⲟϫϩⲉϫ ϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲙⲡⲉ ⲟⲩⲟⲛ ϣⲱⲡⲓ ⳿ⲙⲡⲉϥⲣⲏϯ ⲓⲥϫⲉⲛ ϩⲏ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ϣⲁ ϯⲛⲟⲩ ⲟⲩⲇⲉ ⳿ⲛⲛⲉ ⲟⲩⲟⲛ ϣⲱⲡⲓ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ⲟⲩⲟϩ ⳿ⲉⲃⲏⲗϫⲉ ⳿ⲁ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲕⲟⲩϫⲓ ⲛⲁⲩⲛⲁⲛⲟϩⲉⲙ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ ⲛⲓⲥⲱⲧⲡ ⲇⲉ ⳿ⲉⲣⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲕⲟⲩϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ⲧⲟⲧⲉ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲓⲥ Ⲡⲭ̅ⲥ̅ ⲧⲁⲓ ⲓⲉ ⳿ϥⲧⲏ ⳿ⲙⲡⲉⲣⲧⲉⲛϩⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ⲉⲩ⳿ⲉⲧⲱⲟⲩⲛⲟⲩ ⲅⲁⲣ ⳿ⲛϫⲉ ϩⲁⲛⲭ̅ⲥ̅ ⳿ⲛⲛⲟⲩϫ ⲛⲉⲙ ϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲛⲟⲩϫ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϯ ⳿ⲛϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ϩⲱⲥⲧⲉ ⳿⳿ⲉⲛⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲥⲉⲥⲱⲣⲉⲙ ⳿ⲛⲛⲁⲕⲉⲥⲱⲧⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ⲓⲥ ϩⲏⲡⲡⲉ ⲁⲓⲉⲣϣⲟⲣⲡ ⳿ⲛϫⲟⲥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","⳿ⲉϣⲱⲡ ⲟⲩⲛ ⲁⲩϣⲁⲛϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲏⲡⲡⲉ ⲉϥϩⲓ ⳿ⲡϣⲁϥⲉ ⳿ⲙⲡⲉⲣ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲏⲡⲡⲉ ⲉϥϧⲉⲛ ⲛⲓⲧⲁⲙⲓⲟⲛ ⳿ⲙⲡⲉⲣⲧⲉⲛϩⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲙⲡⲓⲥⲉⲧⲉⲃⲣⲏϫ ⳿ⲉϣⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁⲡⲉⲓⲉⲃⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲟⲩⲟⲛϩϥ ⲥⲁⲡⲉⲙⲉⲛⲧ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡϫⲓⲛ⳿ⲓ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ϯϣⲟⲗϩⲥ ⳿ⲙⲙⲟϥ ϣⲁⲩⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ⳿ⲛϫⲉ ⲛⲓ⳿ⲁϧⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ⲥⲁⲧⲟⲧϥ ⲇⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓϩⲟϫϩⲉϫ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲫⲣⲏ ⲉϥ⳿ⲉⲉⲣⲭⲁⲕⲓ ⲟⲩⲟϩ ⲡⲓⲓⲟϩ ⳿ⲛⲛⲉϥϯ ⳿ⲙⲡⲉϥⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⲛⲓⲥⲓⲟⲩ ⲉⲩ⳿ⲉϩⲉⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲛⲓϫⲟⲙ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲕⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ⲧⲟⲧⲉ ⲉϥ⳿ⲉⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲩ⳿⳿ⲉⲛⲉϩⲡⲓ ⳿ⲛϫⲉ ⲛⲓⲫⲩⲗⲏ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓϭⲏⲡⲓ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲛⲉⲙ ⲟⲩϫⲟⲙ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ⲟⲩⲟϩ ⲉϥ⳿ⲉⲧⲁⲟⲩ⳿ⲟ ⳿ⲛⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛⲥⲁⲗⲡⲓⲅⲅⲟⲥ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲑⲱⲟⲩϯ ⳿ⲛⲛⲉϥⲥⲱⲧⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓ⳿ϥⲧⲟⲩⲑⲏⲟⲩ ⲓⲥϫⲉⲛ ⲁⲩⲣⲏϫⲟⲩ ⳿ⲛⲛⲓⲫⲏⲟⲩ⳿ⲓ ϣⲁ ⲁⲩⲣⲏϫⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉϯⲡⲁⲣⲁⲃⲟⲗⲏ ⳿ⲉϣⲱⲡ ϩⲏⲇⲏ ⳿ⲛⲧⲉ ⲛⲉⲥϫⲁⲗ ϭⲛⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲛⲉⲥϫⲱⲃⲓ ϯⲟⲩ⳿ⲱ ⳿ⲉⲃⲟⲗ ϣⲁⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ϥϧⲉⲛⲧ ⳿ⲛϫⲉ ⲡⲓϣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛϣⲀⲛⲛⲁⲩ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⳿ϥϧⲉⲛⲧ ϩⲓⲣⲉⲛ ⲛⲓⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉ ⲧⲁⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⲥⲓⲛⲓ ϣⲁⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲓⲕⲁϩⲓ ⲛⲁⲥⲓⲛⲓ ⲛⲁⲥⲁϫⲓ ⲇⲉ ⳿ⲛⲛⲟⲩⲥⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ⲉⲑⲃⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ϯⲟⲩⲛⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲇⲉ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲪ̇ⲓⲱⲧ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ Ⲛⲱ⳿ⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧⲡⲁⲣⲟⲩⲥⲓ⳿ⲁ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲉⲛⲁⲩϣⲟⲡ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧϧⲁϫⲱϥ ⳿ⲙⲡⲓⲕⲁⲧⲁ⳿ⲕⲗⲩⲥⲙⲟⲥ ⲉⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲉⲩⲥⲱ ⲉⲩϭⲓ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲉⲩϭⲓϩⲁⲓ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁ Ⲛⲱ⳿ⲉ ϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲕⲩⲃⲱⲧⲟⲥ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ϣⲁⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲕⲁⲧⲁ⳿ⲕⲗⲩⲥⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲗ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲡⲁⲓⲣⲏϯ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲓ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ⲧⲟⲧⲉ ⲃ̅ ⲉⲩⲭⲏ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲟⲩⲁⲓ ⲉⲩ⳿ⲉⲟⲗϥ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⲉⲩ⳿ⲉⲭⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","⳿ⲥⲛⲟⲩϯ ⲉⲩⲛⲟⲩⲧ ϧⲉⲛ ⲟⲩⲉⲩⲛⲓ ⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲟⲗⲥ ⲟⲩⲟϩ ⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲭⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ⲣⲱⲓⲥ ⲟⲩⲛ ϫⲉ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ϫⲉ ⳿ⲁⲣⲉ ⲡⲉⲧⲉⲛ⳪ ⲛⲏⲟⲩ ϧⲉⲛ ⲁϣ ⳿ⲛⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ⲫⲁⲓ ⲇⲉ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲉⲛⲁⲣⲉ ⲡⲓⲛⲉⲃⲏⲓ ⳿ⲉⲙⲓ ϫⲉ ⳿ⲁⲣⲉ ⲡⲓⲥⲟⲛⲓ ⲛⲏⲟⲩ ⲛⲁϥ ϧⲉⲛ ⲁϣ ⳿ⲛⲟⲩⲛⲟⲩ ⲛⲁϥⲛⲁⲣⲱⲓⲥ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲭⲁϥ ⳿ⲉϭⲓ ⳿ⲙⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ⲉⲑⲃⲉ ⲫⲁⲓ ϩⲱⲧⲉⲛ ϣⲱⲡⲓ ⳿ⲉⲣⲉⲧⲉⲛⲥⲉⲃⲧⲱⲧ ϫⲉ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⳿ⲁⲣⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲛⲏⲟⲩ ⳿ⲛϧⲏⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ⲛⲓⲙ ϩⲁⲣⲁ ⲡⲉ ⲡⲓⲡⲓⲥⲧⲟⲥ ⳿ⲙⲃⲱⲕ ⲟⲩⲟϩ ⳿ⲛⲥⲁⲃⲉ ⲫⲏ⳿ⲉⲧⲉ ⲡⲉϥ⳪ ⲛⲁⲭⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉϯⲛⲱⲟⲩ ⳿ⲛⲧⲟⲩ⳿ϧⲣⲉ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲧⲏⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","⳿ⲱⲟⲩⲛⲓⲁⲧϥ ⳿ⲙⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲡⲉϥ⳪ ⳿ⲛⲧⲉϥϫⲉⲙϥ ⲉϥ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ϥⲛⲁⲭⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉⲧⲉⲛⲧⲁϥ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛϫⲟⲥ ⳿ⲛϫⲉ ⲡⲓⲃⲱⲕ ⲉⲧϩⲱⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ϫⲉ ⲡⲁ⳪ ⲛⲁⲱⲥⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲟⲩ⳿ⲓ ⳿⳿ⲉⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲛⲧⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲥⲱ ⲛⲉⲙ ⲛⲏⲉⲧⲑⲁϧⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲛϫⲉ ⲡ⳪ ⳿ⲙⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉϥϫⲟⲩϣⲧ ϧⲁϫⲱϥ ⲁⲛ ⲛⲉⲙ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ⲟⲩⲟϩ ⲉϥ⳿ⲉⲫⲟⲣϫϥ ϧⲉⲛ ⲧⲉϥⲙⲏϯ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲭⲱ ⳿ⲛⲧⲉϥⲧⲟⲓ ⲛⲉⲙ ⲛⲓϣⲟⲃⲓ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ ");
INSERT INTO copcnt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ⲧⲟⲧⲉ ⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲙⲙⲏϯ ⳿ⲙⲡⲁⲣⲑⲉⲛⲟⲥ ⲛⲏ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲛⲛⲟⲩⲗⲁⲙⲡⲁⲥ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ⲛⲉ ⲟⲩⲟⲛ ⲉ̅ ⲇⲉ ⳿ⲛⲥⲟϫ ⳿ⲛϧⲏⲧⲟⲩ ⲛⲉⲙ ⲉ̅ ⳿ⲛⲥⲁⲃⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ⲛⲓⲥⲟϫ ⲅⲁⲣ ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲛⲛⲟⲩⲗⲁⲙⲡⲁⲥ ⳿ⲙⲡⲟⲩⲉⲗ ⲛⲉϩ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ⲛⲓⲥⲁⲃⲉⲩ ⲇⲉ ⲁⲩⲉⲗ ⲛⲉϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲟⲩⲙⲟⲕⲓ ⲛⲉⲙ ⲛⲟⲩⲗⲁⲙⲡⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","⳿ⲉⲧⲁϥⲱⲥⲕ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲁⲩϩⲓⲛⲓⲙ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲁⲩⲉⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","⳿ⲉⲧⲁ ⳿ⲧⲫⲁϣⲓ ⲇⲉ ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ϣⲱⲡⲓ ⳿ⲁ ⲟⲩ⳿ϧⲣⲱⲟⲩ ϣⲱⲡⲓ ϫⲉ ⲓⲥ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲁϥ⳿ⲓ ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ⲧⲟⲧⲉ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲡⲁⲣⲑⲉⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩⲥⲟⲗⲥⲉⲗ ⳿ⲛⲛⲟⲩⲗⲁⲙⲡⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ⲡⲉϫⲉ ⲛⲓⲥⲟϫ ⲇⲉ ⲛⲓⲥⲁⲃⲉⲩ ϫⲉ ⲙⲟⲓ ⲛⲁⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲧⲉⲛⲛⲉϩ ⳿ⲙⲙⲟⲛ ⲛⲉⲛⲗⲁⲙⲡⲁⲥ ⲛⲁϭⲉⲛⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲥⲁⲃⲉⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏⲡⲟⲧⲉ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲣⲁϣⲧⲉⲛ ⲛⲉⲙⲱⲧⲉⲛ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲇⲉ ⲙⲁⲗⲗⲟⲛ ϩⲁ ⲛⲏⲉⲧϯ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϣⲱⲡ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⲇⲉ ϫⲉ ⳿ⲛⲧⲟⲩϣⲱⲡ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲟⲩⲟϩ ⲛⲏⲉⲧⲥⲉⲃⲧⲱⲧ ⲁⲩϣⲉⲛⲱⲟⲩ ⲛⲉⲙⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓϩⲟⲡ ⲟⲩⲟϩ ⲁⲩⲙⲁϣⲑⲁⲙ ⳿ⲙⲡⲓⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⳿ⲡⲥⲱϫⲡ ⳿ⲛⲛⲓⲡⲁⲣⲑⲉⲛⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛ⳪ ⲡⲉⲛ⳪ ⳿ⲁⲟⲩⲱⲛ ⲛⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ⲣⲱⲓⲥ ⲟⲩⲛ ϫⲉ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲟⲩⲇⲉ ϯⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⲉϥⲛⲁϣⲉⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ ⲁϥⲙⲟⲩϯ ⳿⳿ⲉⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲙⲡⲉⲧⲉⲛⲧⲁϥ ⳿ⲉⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ⲟⲩⲁⲓ ⲙⲉⲛ ⲁϥϯ ⲛⲁϥ ⳿ⲛⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲁϥϯ ⲛⲁϥ ⳿ⲛ ⲃ̅ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲁϥϯ ⲛⲁϥ ⳿ⲛⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲕⲁⲧⲁ ⲧⲉϥϫⲟⲙ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ⲁϥϣⲉⲛⲁϥ ⲇⲉ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧϭⲓ ⳿ⲙⲡⲓⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲁϥⲉⲣϩⲱⲃ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⲁϥ⳿ϫⲫⲉ ⲕⲉ ⲉ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲫⲏ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓ ⲃ̅ ⲁϥ⳿ϫⲫⲉ ⲕⲉ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲁϥϣⲉⲛⲁϥ ⲁϥϣⲱⲕⲓ ⳿ⲛⲟⲩⲕⲁϩⲓ ⲟⲩⲟϩ ⲁϥⲭⲱⲡ ⳿ⲙⲡⲓϩⲁⲧ ⳿ⲛⲧⲉ ⲡⲉϥ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ⲙⲉⲛⲉⲛⲥⲁ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲛⲥⲏⲟⲩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲡ⳪ ⳿ⲛⲛⲓ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁϥϥⲓⲱⲡ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓ ⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲁϥⲉⲛ ⲕⲉ ⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁ⳪ ⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⲓⲥ ⲕⲉ ⲉ̅ ⳿ⲛϫⲓⲛϭⲱⲣ ⲁⲓ⳿ϫⲫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ⲡⲉϫⲉ ⲡⲉϥ⳪ ⲇⲉ ⲛⲁϥ ϫⲉ ⲕⲁⲗⲱⲥ ⲡⲓⲃⲱⲕ ⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲉⲧⲉⲛϩⲟⲧ ⳿ⲉⲡⲓⲇⲏ ⲁⲕϣⲱⲡⲓ ⲉⲕⲉⲛϩⲟⲧ ϧⲉⲛ ϩⲁⲛⲕⲟⲩϫⲓ ⲉⲓ⳿ⲉⲭⲁⲕ ϩⲓϫⲉⲛ ϩⲁⲛⲛⲓϣϯ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲫⲣⲁϣⲓ ⳿ⲛⲧⲉ ⲡⲉⲕ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓϫⲓⲛϭⲱⲣ ⲃ̅ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁ⳪ ϫⲓⲛϭⲱⲣ ⲃ̅ ⲡⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⲓⲥ ⲕⲉ ⲃ̅ ⲁⲓ⳿ϫⲫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ⲡⲉϫⲉ ⲡⲉϥ⳪ ⲇⲉ ⲛⲁϥ ϫⲉ ⲕⲁⲗⲱⲥ ⲡⲓⲃⲱⲕ ⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲉⲧⲉⲛϩⲟⲧ ⳿ⲉⲡⲓⲇⲏ ⲁⲕϣⲱⲡⲓ ⲉⲕⲉⲛϩⲟⲧ ϧⲉⲛ ϩⲁⲛⲕⲟⲩϫⲓ ⲉⲓ⳿ⲉⲭⲁⲕ ϩⲓϫⲉⲛ ϩⲁⲛⲛⲓϣϯ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲫⲣⲁϣⲓ ⳿ⲛⲧⲉ ⲡⲉⲕ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ⲁϥ⳿ⲓ ⲇⲉ ϩⲱϥ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓϫⲓⲛϭⲱⲣ ⲡⲉϫⲁϥ ϫⲉ Ⲡⲁ⳪ ⲁⲓ⳿ⲉⲙⲓ ⳿ⲉⲣⲟⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲣⲱⲙⲓ ⲉϥⲛⲁϣⲧ ⲉⲕⲱⲥϧ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲉⲕⲥⲁⲧϥ ⲟⲩⲟϩ ⲉⲕⲑⲱⲟⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲉⲕϫⲟⲣϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ⲟⲩⲟϩ ⲁⲓⲉⲣϩⲟϯ ⲁⲓϣⲉⲛⲏⲓ ⲁⲓⲭⲱⲡ ⳿ⲙⲡⲉⲕϫⲓⲛϭⲱⲣ ϧⲉⲛ ⲡⲓⲕⲁϩⲓ ⲓⲥ ⲡⲉⲧⲉⲫⲱⲕ ⳿ⲛⲧⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉϥ⳪ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲓⲃⲱⲕ ⲉⲧϩⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛϭⲉⲛⲛⲉ ⲓⲥϫⲉ ⳿ⲕⲉⲙⲓ ϫⲉ ϣⲁⲓⲱⲥϧ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲓⲥⲁⲧϥ ⲟⲩⲟϩ ϣⲁⲓⲑⲱⲟⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲙⲫⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲓϫⲟⲣϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⲟⲩⲛ ⲛⲁⲕ ⲡⲉ ⳿ⲉϯ ⳿ⲙⲡⲁϩⲁⲧ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓ⳿ⲧⲣⲁⲡⲉⲍⲓⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛ⳿ⲓ ⲛⲁⲓⲛⲁϭⲓ ⳿ⲙⲡⲉⲧⲉⲫⲱⲓ ⲛⲉⲙ ⲧⲉϥⲙⲏⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⲟⲩⲛ ⳿ⲙⲡⲓϫⲓⲛϭⲱⲣ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲫⲁⲓ ⲟⲩⲟϩ ⲙⲏⲓϥ ⳿ⲙⲫⲁ ⲡⲓ ⲓ̅ ⳿ⲛϫⲓⲛϭⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ⲛⲧⲁϥ ⲉⲩ⳿ⲉϯ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲟϥ ⲫⲏ ⲇⲉ ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲁϥ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛⲧⲟⲧϥ ⲉⲩ⳿ⲉⲟⲗϥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ⲟⲩⲟϩ ⲡⲓⲁⲧϣⲁⲩ ⳿ⲙⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲭⲁⲕⲓ ⲉⲧⲥⲁⲃⲟⲗ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲓ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ϧⲉⲛ ⲡⲉϥ⳿ⲱⲟⲩ ⲛⲉⲙ ⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲉⲑⲟⲩⲁⲃ ⲧⲏⲣⲟⲩ ⲛⲉⲙⲁϥ ⲧⲟⲧⲉ ⲉϥ⳿ⲉϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ⲡⲓ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲑⲱⲟⲩϯ ⲛⲁϩⲣⲁϥ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲫⲟⲣϫⲟⲩ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲉϣⲁϥⲫⲱⲣϫ ⳿ⲛⲛⲓ⳿ⲉⲥⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛⲛⲓⲃⲁⲉⲙⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ⲟⲩⲟϩ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲙⲉⲛ ⲉϥ⳿ⲉⲭⲁⲩ ⲥⲁⲧⲉϥⲟⲩ⳿ⲓⲛⲁⲙ ⲛⲓⲃⲁⲉⲙⲡⲓ ⲇⲉ ⲥⲁⲧⲉϥϫⲁϭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ⲧⲟⲧⲉ ⲉϥ⳿ⲉϫⲟⲥ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲣⲟ ⳿ⲛⲛⲏⲉⲧⲥⲁⲧⲉϥⲟⲩ⳿ⲓⲛⲁⲙ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ϩⲁⲣⲟⲓ ⲛⲏⲉⲧ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ ⳿ⲁⲣⲓ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⲑⲏⲉⲧⲥⲉⲃⲧⲱⲧ ⲛⲱⲧⲉⲛ ⲓⲥϫⲉⲛ ⳿ⲧⲕⲁⲧⲁⲃⲟⲗⲏ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ⲁⲓ⳿ϩⲕⲟ ⲅⲁⲣ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛⲧⲉⲙⲙⲟⲓ ⲁⲓ⳿ⲓⲃⲓ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛ⳿ⲧⲥⲟⲓ ⲛⲁⲓⲟⲓ ⳿ⲛϣⲉⲙⲙⲟ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛϣⲟⲡⲧ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ⲛⲁⲓⲃⲏϣ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛϩⲟⲃⲥⲧ ⲛⲁⲓϣⲱⲛⲓ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛϫⲉⲙⲡⲁϣⲓⲛⲓ ⲛⲁⲓⲭⲏ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⳿ⲁⲧⲉⲧⲉⲛ⳿ⲓ ϣⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ⲧⲟⲧⲉ ⲉⲩ⳿ⲉ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲑⲙⲏⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛ⳪ ⳿ⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲣⲟⲕ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲉⲕϩⲟⲕⲉⲣ ⲟⲩⲟϩ ⲁⲛⲧⲉⲙⲙⲟⲕ ⲓⲉ ⲉⲕ⳿ⲟⲃⲓ ⲟⲩⲟϩ ⲁⲛ⳿ⲧⲥⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ⲓⲉ ⳿ⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲣⲟⲕ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲉⲕⲟⲓ ⳿ⲛϣⲉⲙⲙⲟ ⲟⲩⲟϩ ⲁⲛϣⲟⲡⲕ ⳿ⲉⲣⲟⲛ ⲓⲉ ⲉⲕⲃⲏϣ ⲟⲩⲟϩ ⲁⲛϩⲟⲃⲥⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ⲓⲉ ⳿ⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲣⲟⲕ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲉⲕϣⲱⲛⲓ ⲓⲉ ⲉⲕⲭⲏ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⲁⲛ⳿ⲓ ϣⲁⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ⲟⲩⲟϩ ⲉϥ⳿ⲉ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲣⲟ ⲉϥ⳿ⲉϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉⲫⲟⲥⲟⲛ ⳿ⲁⲣⲉⲧⲉⲛⲁⲓⲧⲟⲩ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲧⲏⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛⲁⲓⲧⲟⲩ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ⲧⲟⲧⲉ ⲉϥ⳿ⲉϫⲟⲥ ⳿ⲛⲛⲏⲉⲧϩⲱⲟⲩ ⲉⲧⲥⲁⲧⲉϥϫⲁϭⲏ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϩⲁⲣⲟⲓ ⲛⲏⲉⲧ⳿ⲥϩⲟⲩⲟⲣⲧ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⳿ⲛ⳿⳿ⲉⲛⲉϩ ⲫⲏⲉⲧⲥⲉⲃⲧⲱⲧ ⳿ⲙⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ⲁⲓ⳿ϩⲕⲟ ⲅⲁⲣ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲧⲉⲙⲙⲟⲓ ⲁⲓ⳿ⲓⲃⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲧⲥⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ⲛⲁⲓⲟⲓ ⳿ⲛϣⲉⲙⲙⲟ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛϣⲟⲡⲧ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲁⲓⲃⲏϣ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛϩⲟⲃⲥⲧ ⲛⲁⲓϣⲱⲛⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛϫⲉⲙⲡⲁϣⲓⲛⲓ ⲛⲁⲓⲭⲏ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲓ ϣⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ⲧⲟⲧⲉ ⲉⲩ⳿ⲉ⳿ⲉⲣⲟⲩ⳿ⲱ ϩⲱⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛ⳪ ⳿ⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲣⲟⲕ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲉⲕϩⲟⲕⲉⲣ ⲓⲉ ⲉⲕ⳿ⲟⲃⲓ ⲓⲉ ⲉⲕⲟⲓ ⳿ⲛϣⲉⲙⲙⲟ ⲓⲉ ⲉⲕⲃⲏϣ ⲓⲉ ⲉⲕϣⲱⲛⲓ ⲓⲉ ⲉⲕⲭⲏ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲛϣⲉⲙϣⲏⲧⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ⲧⲟⲧⲉ ⲉϥ⳿ⲉ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲉⲫⲟⲥⲟⲛ ⳿ⲙⲡⲉⲧⲉⲛⲁⲓⲧⲟⲩ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲉⲧⲉⲛⲁⲓⲧⲟⲩ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲉⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲁⲓ ⲉⲩⲕⲟⲗⲁⲥⲓⲥ ⳿ⲛ⳿⳿ⲉⲛⲉϩ ⲛⲓ⳿ⲑⲙⲏⲓ ⲇⲉ ⲉⲩⲱⲛϧ ⳿ⲛ⳿⳿ⲉⲛⲉϩ ");
INSERT INTO copcnt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲉⲕ ⲛⲁⲓⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉϩⲟⲟⲩ ⲃ̅ ⲡⲓⲡⲁⲥⲭⲁ ⲛⲁϣⲱⲡⲓ ⲟⲩⲟϩ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⲉⲑⲣⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ⲧⲟⲧⲉ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲁⲩⲗⲏ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲫⲏ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲕⲁⲓ⳿ⲁⲫⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ⲟⲩⲟϩ ⲁⲩⲉⲣ ⲟⲩⲥⲟϭⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ϧⲉⲛ ⲟⲩ⳿ⲭⲣⲟϥ ⲟⲩⲟϩ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲁⲓⲥ ϧⲉⲛ ⳿ⲡϣⲁⲓ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉϥⲭⲏ ϧⲉⲛ Ⲃⲏⲑⲁⲛⲓ⳿ⲁ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲡⲓⲕⲁⲕⲥⲉϩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ⲁⲥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲟⲕⲓ ⳿ⲛⲥⲟϫⲉⲛ ⳿ⲛⲧⲟⲧⲥ ⳿ⲉⲛⲁϣⲉ ⳿ⲛⲥⲟⲩⲉⲛϥ ⲟⲩⲟϩ ⲁⲥϫⲟϣϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ ⲉϥⲣⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲧⲁⲕⲟ ⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ⲛⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⲅⲁⲣ ⲡⲉ ⳿ⲉϯ ⳿ⲙⲫⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲁ ⲟⲩⲙⲏϣ ⲟⲩⲟϩ ⳿ⲉⲧⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛⲟⲩⲁϩϧⲓⲥⲓ ⳿ⲉϯ⳿ⲥϩⲓⲙⲓ ⲟⲩϩⲱⲃ ⲅⲁⲣ ⳿ⲉⲛⲁⲛⲉϥ ⲡⲉⲧⲁⲥⲁⲓϥ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ⲛⲓϩⲏⲕⲓ ⲅⲁⲣ ⲥⲉ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲁⲛⲟⲕ ⲇⲉ ϯⲛⲉⲙⲱⲧⲉⲛ ⲁⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ⲁⲥϩⲓⲟⲩ⳿ⲓ ⲅⲁⲣ ⳿ⲛϫⲉ ⲑⲁⲓ ⳿ⲙⲡⲁⲓⲥⲟϫⲉⲛ ⳿ⲉϫⲉⲛ ⲡⲁⲥⲱⲙⲁ ⳿ⲉ⳿ⲡϫⲓⲛⲕⲟⲥⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲫⲙⲁ ⳿ⲉⲧⲟⲩⲛⲁϩⲓⲱⲓϣ ⳿ⲙⲡⲁⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⲉⲩ⳿ⲉⲥⲁϫⲓ ϩⲱϥ ⳿ⲙⲫⲏ⳿ⲉⲧⲁ ⲧⲁⲓ⳿ⲥϩⲓⲙⲓ ⲁⲓϥ ⲉⲩⲙⲉⲩⲓ ⲛⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ⲧⲟⲧⲉ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲓ̅ⲃ̅ ⲫⲏ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲓⲟⲩⲇⲁⲥ ⲡⲓⲒⲥⲕⲁⲣⲓ⳿ⲱⲧⲏⲥ ϩⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲧⲏⲓϥ ⲛⲏⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛⲧⲁⲧⲏⲓϥ ⳿ⲉⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲥⲉⲙⲛⲏⲧⲥ ⲛⲉⲙⲁϥ ⳿ⲉϯ ⲛⲁϥ ⳿ⲙ ⲗ̅ ⳿ⲛϩⲁⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ⲟⲩⲟϩ ⲓⲥϫⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ ⲟⲩⲉⲩⲕⲉⲣⲓ⳿ⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲧⲏⲓϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϩⲟⲩⲓⲧ ⳿ⲛⲧⲉ ⲛⲓⲁⲧⲕⲱⲃ ⲁⲩ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲕⲟⲩⲱϣ ⳿ⲉⲥⲉⲃⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ ⲛⲁⲕ ⲑⲱⲛ ⳿ⲉⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲧⲁⲓⲃⲁⲕⲓ ϩⲁ ⲡⲁ⳿ⲫⲙⲁⲛ ⳿ⲛⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲁϫⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲉϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ϫⲉ ⲡⲁⲥⲏⲟⲩ ⲁϥϧⲱⲛⲧ ⲁⲓⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲡⲁⲥⲭⲁ ϧⲁⲧⲟⲧⲕ ⲛⲉⲙ ⲛⲁⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ⲟⲩⲟϩ ⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲟⲥ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲥⲟⲃϯ ⳿ⲙⲡⲓⲡⲁⲥⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲁϥⲣⲱⲧⲉⲃ ⲡⲉ ⲛⲉⲙ ⲡⲓ ⲓ̅ⲃ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ⲟⲩⲟϩ ⲉⲩⲟⲩⲱⲙ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⲡⲉⲑⲛⲁⲧⲏⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲡⲟⲩϩⲏⲧ ⲙⲟⲕϩ ⳿ⲉⲙⲁϣⲱ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϫⲟⲥ ϫⲉ ⲙⲏⲧⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲡⲁ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ϫⲉ ⲫⲏ⳿ⲉⲧⲁϥⲥⲉⲡ ⲧⲉϥϫⲓϫ ⲛⲉⲙⲏⲓ ϩⲓ ⲡⲓⲃⲓⲛⲁϫ ⲫⲁⲓ ⲡⲉⲑⲛⲁⲧⲏⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ⲡ̇ϣⲏⲣⲓ ⲙⲉⲛ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ϥⲛⲁϣⲉⲛⲁϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟⲓ ⲇⲉ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲫⲏ⳿ⲉⲧⲟⲩⲛⲁϯ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲛⲁⲛⲉⲥ ⲛⲁϥ ⲡⲉ ⳿ⲙⲡⲟⲩⲙⲁⲥϥ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲟⲩⲇⲁⲥ ⲫⲏ⳿ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲏⲧⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲣⲁⲃⲃⲓ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕϫⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ⲉⲩⲟⲩⲱⲙ ⲇⲉ ⲁϥϭⲓ ⳿ⲛⲟⲩⲱⲓⲕ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲟϥ ⲁϥⲫⲁϣϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲧⲏⲓϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ϫⲉ ϭⲓ ⲟⲩⲱⲙ ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲁⲥⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ⲁⲫⲟⲧ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲁϥⲧⲏⲓϥ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϭⲓ ⲥⲱ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲫⲁⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⲡⲁ⳿ⲥⲛⲟϥ ⳿ⲛⲧⲉ ϯⲇⲓ⳿ⲁⲑⲏⲕⲏ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉⲧⲟⲩⲛⲁⲫⲟⲛϥ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲉ⳿ⲡϫⲓⲛⲭⲁ ⳿ⲛⲟⲩⲛⲟⲃⲓ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲁⲥⲱ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲧⲁⲓⲃⲱ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲧⲏ ϩⲟⲧⲁⲛ ⲁⲓϣⲁⲛⲥⲟϥ ⲛⲉⲙⲱⲧⲉⲛ ⲉϥⲟⲓ ⳿ⲙⲃⲉⲣⲓ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲥⲙⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⲉⲓ⳿ⲉ⳿ⲓⲛⲓ ⳿ⲛⲟⲩⲉⲣϧⲟⲧ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϫⲱⲣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲟϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲓⲧⲱⲛⲧ ⲇⲉ ϯⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ϫⲉ ⲓⲥϫⲉ ⲥⲉⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲧⲏⲣⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲕ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲛⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⳿ⲙⲡⲁⲧⲉ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲭⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛ ⲅ̅ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ⲡⲉϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ ⲕⲁⲛ ⲁⲥϣⲁⲛⲫⲟϩ ⳿ⲛⲧⲁⲙⲟⲩ ⲛⲉⲙⲁⲕ ⳿ⲛⲛⲁϫⲟⲗⲕ ⳿ⲉⲃⲟⲗ ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲙⲁⲑⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲟⲩⲓⲟϩⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲅⲉⲑⲥⲏⲙⲁⲛⲓ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ϩⲉⲙⲥⲓ ⳿ⲙⲡⲁⲓ ⲙⲁ ϣⲁ ϯϣⲉⲛⲏⲓ ϣⲁ ⳿ⲙⲛⲁⲓ ⳿ⲛⲧⲁⲧⲱⲃϩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ⲟⲩⲟϩ ⲁϥⲉⲗ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙⲁϥ ⲛⲉⲙ ⳿ⲡϣⲏⲣⲓ ⲃ̅ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲛⲉⲙ ⳿ⲉⲉⲣ⳿ϣⲗⲁϩ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲁⲯⲩⲭⲏ ⲙⲟⲕϩ⳿ⲛϩⲏⲧ ϣⲁ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲙⲟⲩ ⳿ⲟϩⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩⲟϩ ⲣⲱⲓⲥ ⲛⲉⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲛϥ ⳿ⲉ⳿ⲧϩⲏ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲡⲉϥϩⲟ ⲉϥⲧⲱⲃϩ ⲟⲩⲟϩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲱⲧ ⲓⲥϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⲙⲁⲣⲉ ⲡⲁⲓ⳿ⲁⲫⲟⲧ ⲥⲉⲛⲧ ⳿ⲡⲗⲏⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉϩⲛⲏⲓ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉϩⲛⲁⲕ ⳿ⲛⲑⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁϥϫⲉⲙⲟⲩ ⲉⲩⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙⲠⲉⲧⲣⲟⲥ ϫⲉ ⲡⲁⲓⲣⲏϯ ⳿ⲙⲡⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲣⲱⲓⲥ ⲛⲉⲙⲏⲓ ⳿ⲛⲟⲩⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ⲣⲱⲓⲥ ⲟⲩⲛ ⲟⲩⲟϩ ⲧⲱⲃϩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ ⲡⲓⲡ͞ⲛⲁ̅ ⲙⲉⲛ ⲉϥⲣⲱⲟⲩⲧ ϯⲥⲁⲣⲝ ⲇⲉ ⲟⲩⲁⲥⲑⲉⲛⲏⲥ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥϣⲉⲛⲁϥ ⲁϥⲧⲱⲃϩ ⳿ⲙ⳿ⲫⲙⲁϩ ⲥⲟⲡ ⲃ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲱⲧ ⲓⲥϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲁⲓ ⳿ⲁⲫⲟⲧ ⲥⲉⲛⲧ ⳿ⲉⲃⲏⲗ ⳿ⲛⲧⲁⲥⲟϥ ⲙⲁⲣⲉ ⲡⲉⲧⲉϩⲛⲁⲕ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲟⲛ ϩⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁϥϫⲉⲙⲟⲩ ⲉⲩⲉⲛⲕⲟⲧ ⲛⲁⲣⲉ ⲛⲟⲩⲃⲁⲗ ⲅⲁⲣ ϩⲟⲣϣ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ⲟⲩⲟϩ ⲁϥⲭⲁⲩ ⲟⲛ ⲁϥϣⲉⲛⲁϥ ⲁϥⲧⲱⲃϩ ⳿ⲙ⳿ⲫⲙⲁϩ ⲅ̅ ⳿ⲛⲥⲟⲡ ⲉϥϫⲱ ⳿ⲙⲡⲁⲓⲥⲁϫⲓ ⲣⲱ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ϩⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲛⲕⲟⲧ ϫⲉ ⲟⲩⲟϩ ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲓⲥ ϩⲏⲡⲡⲉ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲟⲩⲛⲟⲩ ⲟⲩⲟϩ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁⲣⲟⲛ ϩⲏⲡⲡⲉ ⲁϥϧⲱⲛⲧ ⳿ⲛϫⲉ ⲫⲏⲉⲑⲛⲁⲧⲏⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ⲟⲩⲟϩ ⳿ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ⲓⲥ Ⲓⲟⲩⲇⲁⲥ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓ ⲓ̅ⲃ̅ ⲁϥ⳿ⲓ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲛⲉⲙ ϩⲁⲛⲥⲏϥⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲃⲟϯ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ⲫⲏ ⲇⲉ ⳿ⲉⲛⲁϥⲧⲏⲓϥ ⲁϥϯ ⳿ⲛⲟⲩⲙⲏⲓⲛⲓ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏ⳿ⲉϯⲛⲁϯ ⳿ⲛⲟⲩⲫⲓ ⳿ⲉⲣⲱϥ ⳿ⲛⲑⲟϥ ⲡⲉ ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲭⲉⲣⲉ ⲣⲁⲃⲃⲓ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲟⲩⲫⲓ ⳿ⲉⲣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁ⳿ϣⲫⲏⲣ ⲫⲏ⳿ⲉⲧⲁⲕ⳿ⲓ ⲉⲑⲃⲏⲧϥ ⲧⲟⲧⲉ ⲁⲩⲉⲛ ⲛⲟⲩϫⲓϫ ⳿ⲉϫⲉⲛ Ⲓⲏ̅ⲥ̅ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲧⲭⲏ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲁϥⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁϥϣⲉⲗⲉⲙ ⲧⲉϥⲥⲏϥⲓ ⲟⲩⲟϩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲥⲁ ⳿ⲫⲃⲱⲕ ⳿ⲙⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲁϥϫⲉϫ ⲡⲉϥⲙⲁϣϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲙⲁⲧⲁⲥⲑⲟ ⳿ⲛϯⲥⲏϥⲓ ⳿ⲉⲡⲉⲥⲙⲁ ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϭⲓⲥⲏϥⲓ ⲥⲉⲛⲁⲧⲁⲕⲱⲟⲩ ⳿ⲛ⳿ⲧⲥⲏϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ⲓⲉ ⲁⲕⲙⲉⲩⲓ ϫⲉ ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉⲧⲱⲃϩ ⳿ⲙⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲑⲣⲉ ϩⲟⲩ⳿ⲟ ⳿ⲉ ⲓ̅ⲃ̅ ⳿ⲛⲗⲉⲅⲓⲱⲛ ⳿ⲛⲁⲅⲅⲉⲗⲟⲥ ⳿ⲓ ⲛⲏⲓ ⳿ⲙⲛⲁⲓ ϯⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ⲡⲱⲥ ⲟⲩⲛ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲛⲓⲙⲏϣ ϫⲉ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲛⲥⲁ ⲟⲩⲥⲟⲛⲓ ⲛⲉⲙ ϩⲁⲛⲥⲏϥⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲃⲟϯ ⳿ⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟⲓ ⲙⲏ ⲛⲁⲓϩⲉⲙⲥⲓ ⳿ⲙⲙⲏⲛⲓ ⲁⲛ ⲡⲉ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲓϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ⲫⲁⲓ ⲇⲉ ⲧⲏⲣϥ ⲁϥϣⲱⲡⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲟⲧⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ ⲁⲩⲭⲁϥ ⲁⲩⲫⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ⲁⲩⲉⲛϥ ϩⲁ Ⲕⲁⲓ⳿ⲁⲫⲁ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲡⲓⲙⲁ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲡⲉ ϩⲓ ⳿ⲫⲟⲩⲉⲓ ϣⲁ ϯⲁⲩⲗⲏ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⲛⲁϥϩⲉⲙⲥⲓ ⲡⲉ ⲛⲉⲙ ⲛⲓϩⲩⲡⲉⲣⲉⲧⲏⲥ ⳿ⲉⲛⲁⲩ ⳿ⲉⲡⲓϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲛⲉⲙ ⲡⲓⲙⲁⲛϯϩⲁⲡ ⲧⲏⲣϥ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ ⲟⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ϧⲁ Ⲓⲏ̅ⲥ̅ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩϫⲓⲙⲓ ⳿ⲉⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁ ⲫⲁⲓ ϫⲟⲥ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉⲃⲉⲗ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲕⲟⲧϥ ϧⲉⲛ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛ⳿ⲕ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉ ⲛⲁⲓ ⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲙⲟϥ ϧⲁⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲁϥⲭⲱ ⳿ⲛⲣⲱϥ ⲡⲉ ⲟⲩⲟϩ ⲡⲉϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲁϥ ϫⲉ ϯⲧⲁⲣⲕⲟ ⳿ⲙⲙⲟⲕ ⳿ⲙⲪϯ ⲉⲧⲟⲛϧ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕϫⲟⲥ ⲛⲁⲛ ϫⲉ ⲁⲛ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ ⲉⲧⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕϫⲟⲥ ⳿ⲡⲗⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲛⲁⲩ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲛϯϫⲟⲙ ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓϭⲏⲡⲓ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ⲧⲟⲧⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲁϥⲫⲱϧ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥϫⲉⲟⲩ⳿ⲁ ⳿ⲛⲧ⳿ⲉⲛⲉⲣ⳿ⲭⲣⲓⲁ ⲁⲛ ϫⲉ ⳿ⲙⲙⲉⲑⲣⲉ ϩⲏⲡⲡⲉ ϯⲛⲟⲩ ⳿ⲁⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓϫⲉⲟⲩ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ⲟⲩ ⲡⲉ ⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ⲧⲟⲧⲉ ⲁⲩϩⲓⲑⲁϥ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲡⲉϥϩⲟ ⲟⲩⲟϩ ⲁⲩϯⲕⲟⲩⲣ ⲛⲁϥ ⲟⲩⲟϩ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲣⲓ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⲛⲁⲛ Ⲡⲭ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲁϥϩⲉⲙⲥⲓ ⲥⲁⲃⲟⲗ ⲡⲉ ϧⲉⲛ ϯⲁⲩⲗⲏ ⲟⲩⲟϩ ⲁⲥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲙⲃⲱⲕⲓ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⲛⲁⲕⲭⲏ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲠⲓⲄⲁⲗⲓⲗⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛϯ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⳿ⲁⲣⲉϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓ⳿ϣⲑⲟⲙ ⲁⲥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲕⲉⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲡⲉϫⲁⲥ ⳿ⲛⲛⲏⲉⲧⲭⲏ ⳿ⲙⲙⲁⲩ ϫⲉ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲛⲁϥⲭⲏ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲁⲣⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩ⳿ⲁⲛⲁϣ ϫⲉ ⳿ⲛϯⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ⲙⲉⲛⲉⲛⲥⲁ ⲕⲉⲕⲟⲩϫⲓ ⲇⲉ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲡⲉϫⲱⲟⲩ ⳿ⲙⲠⲉⲧⲣⲟⲥ ϫⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⳿ⲛⲑⲟⲕ ⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ϩⲱⲕ ⲕⲉ ⲅⲁⲣ ⲧⲉⲕϫⲓⲛⲥⲁϫⲓ ⲟⲩⲱⲛϩ ⳿ⲙⲙⲟⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ⲧⲟⲧⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣⲕⲁⲧⲁⲑⲉⲙⲁⲧⲓⲍⲓⲛ ⲛⲉⲙ ⳿ⲉⲱⲣⲕ ϫⲉ ⳿ⲛϯⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⳿ⲁ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ⲟⲩⲟϩ ⳿ⲁ Ⲡⲉⲧⲣⲟⲥ ⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲟϥ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲭⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛ ⲅ̅ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲣⲓⲙⲓ ϧⲉⲛ ⲟⲩⲣⲓⲙⲓ ⲉϥⲉⲛϣⲁϣⲓ ");
INSERT INTO copcnt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","⳿ⲉⲧⲁ ⲧⲟⲟⲩ⳿ⲓ ⲇⲉ ϣⲱⲡⲓ ⲁⲩⲉⲣ ⲟⲩⲥⲟϭⲛⲓ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ϧⲁ Ⲓⲏ̅ⲥ̅ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲟⲛϩϥ ⲁⲩⲟⲗϥ ⲁⲩⲧⲏⲓϥ ⳿ⲙⲠⲓⲗⲁⲧⲟⲥ ⲡⲓϩⲏⲅⲉⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ⲧⲟⲧⲉ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲟⲩⲇⲁⲥ ⲫⲏ⳿ⲉⲧⲁϥⲧⲏⲓϥ ϫⲉ ⲁⲩⲉⲣⲕⲁⲧⲁ⳿ⲕⲣⲓⲛⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲁϥⲟⲩⲉⲙ⳿ϩⲑⲏϥ ⲁϥⲧⲁⲥⲑⲟ ⳿ⲛϯ ⲗ̅ ⳿ⲛϩⲁⲧ ⳿ⲉⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓⲉⲣⲛⲟⲃⲓ ϫⲉ ⲁⲓϯ ⳿ⲛⲟⲩ⳿ⲥⲛⲟϥ ⳿ⲛ⳿ⲑⲙⲏⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲁϧⲟⲛ ⳿ⲁⲛⲟⲛ ⳿ⲛⲑⲟⲕ ⲉⲕ⳿ⲉⲣⲱϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ⲟⲩⲟϩ ⲁϥⲃⲟⲣⲃⲉⲣ ⳿ⲛⲛⲓϩⲁⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⲁϥⲟϫϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲛⲛⲓϩⲁⲧ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ⲥϣⲉ ⲁⲛ ⳿ⲉϩⲓⲧⲟⲩ ⳿ⲉⲡⲓⲕⲟⲣⲃⲁⲛⲟⲛ ϫⲉ ⳿ⲧⲧⲓⲙⲏ ⳿ⲛⲟⲩ⳿ⲥⲛⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","⳿ⲉⲧⲁⲩⲉⲣ ⲟⲩⲥⲟϭⲛⲓ ⲇⲉ ⲁⲩϣⲱⲡ ⳿ⲉⲃⲟⲗ⳿ⲛϩⲏⲧⲟⲩ ⳿ⲙⲡⲓⲓⲟϩⲓ ⳿ⲛⲧⲉ ⲡⲓⲕⲉⲣⲁⲙⲉⲩⲥ ⲉⲩⲙⲁ⳿ⲛⲑⲱⲙⲥ ⳿ⲛⲛⲓϣⲉⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲩⲙⲟⲩϯ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲓⲓⲟϩⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ ⲡⲓⲓⲟϩⲓ ⳿ⲙⲡⲓ⳿ⲥⲛⲟϥ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ⲧⲟⲧⲉ ⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲒⲉⲣⲉⲙⲓⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲩϭⲓ ⳿ⲛϯⲗ̅ ⳿ⲛϩⲁⲧ ⳿ⲧⲧⲓⲙⲏ ⳿ⲙⲫⲏ⳿ⲉⲧⲁⲩⲉⲣⲧⲓⲙⲏ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ⲟⲩⲟϩ ⲁⲩⲧⲏⲓⲧⲟⲩ ϧⲁ ⲡⲓⲓⲟϩⲓ ⳿ⲙⲡⲓⲕⲉⲣⲁⲙⲉⲩⲥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲏⲓ ⳿ⲛϫⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲟⲩⲟϩ ⲁϥϣⲉⲛϥ ⳿ⲛϫⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲙⲡⲉϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲛ⳿ⲕⲥⲱⲧⲉⲙ ⲁⲛ ϫⲉ ⲥⲉⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲕ ⳿ⲛⲟⲩⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⲟⲩⲃⲉ ⳿ϩⲗⲓ ⳿ⲛⲥⲁϫⲓ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲛϫⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ⲕⲁⲧⲁ ⳿ⲡϣⲁⲓ ⲇⲉ ⲛⲉ ⳿ⲧⲕⲁϩⲥ ⳿ⲙⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲧⲉ ⳿ⲉⲭⲁ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲧⲥⲟⲛϩ ⳿ⲙⲡⲓⲙⲏϣ ⲫⲏ⳿ⲉϣⲁⲩⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲁⲓ ⲇⲉ ⲉϥⲥⲱⲛϩ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲙⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲟⲩⲥⲟⲛⲓ ⲡⲉ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲃⲁⲣⲁⲃⲃⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⲟⲩⲛ ⲉⲩⲙⲁ ⲡⲉϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲭⲁϥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ Ⲃⲁⲣⲁⲃⲃⲁⲥ ϣⲁⲛ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ⲛⲁϥ⳿ⲉⲙⲓ ⲅⲁⲣ ⲡⲉ ϫⲉ ⳿ⲉⲧⲁⲩⲧⲏⲓϥ ⲉⲑⲃⲉ ⲟⲩ⳿ⲫⲑⲟⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ⲉϥϩⲉⲙⲥⲓ ⲇⲉ ϩⲓ ⲡⲓⲃⲏⲙⲁ ⲁⲥⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣ⳿ϩⲗⲓ ⳿ⲙⲡⲓ⳿ⲑⲙⲏⲓ ⲉⲧⲧⲏ ⲁⲓϣⲉⲡ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲛϧⲓⲥⲓ ⲉⲑⲃⲏⲧϥ ⳿ⲙⲡⲁⲓ⳿ⲉϫⲱⲣϩ ϧⲉⲛ ⳿ⲑⲣⲁⲥⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲩⲑⲉⲧ⳿ϩⲑⲏⲟⲩ ⳿ⲛⲛⲓⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲂⲁⲣⲁⲃⲃⲁⲥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲛⲥⲉⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⳿ⲉⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲭⲁϥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓ ⲃ̅ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲃⲁⲣⲁⲃⲃⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ⲡⲉϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ⳿ⲛⲒⲏ̅ⲥ̅ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉϫⲱⲟⲩ ⲧⲏⲣⲟⲩ ϫⲉ ⲙⲁⲣⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ϫⲉ ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲡⲉⲧⲁϥⲁⲓϥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲛϩⲟⲩ⳿ⲟ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ϫⲉ ⳿ϥⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⲁⲗⲗⲁ ⲙⲁⲗⲗⲟⲛ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ⲁϥϭⲓ ⳿ⲛⲟⲩⲙⲱⲟⲩ ⲁϥⲓⲁ ⲛⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲙⲏϣ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲟⲓ ⳿ⲛⲁⲑⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿ⲑⲙⲏⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲣⲱϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲉϥ⳿ⲥⲛⲟϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ ⲛⲉⲙ ⳿ⲉϫⲉⲛ ⲛⲉⲛϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ⲧⲟⲧⲉ ⲁϥⲭⲁ Ⲃⲁⲣⲁⲃⲃⲁⲥ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲉⲣ⳿ⲫⲣⲁⲅⲉⲗⲗⲓⲟⲛ ⳿ⲙⲙⲟϥ ⲁϥⲧⲏⲓϥ ⲉⲑⲣⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ⲧⲟⲧⲉ ⲛⲓⲙⲁⲧⲟⲓ ⳿ⲛⲧⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲁⲩⲉⲗ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϯ⳿ⲥⲡⲓⲣⲁ ⲧⲏⲣⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲃⲁϣϥ ⲁⲩϯ ⳿⳿ⲛⲟⲩ⳿ⲭⲗⲁⲙⲓⲥ ⳿ⲛⲕⲟⲕⲕⲟⲥ ϩⲓⲱⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ⲟⲩⲟϩ ⲁⲩϣⲱⲛⲧ ⳿ⲛⲟⲩ⳿ⲭⲗⲟⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ϩⲁⲛⲥⲟⲩⲣⲓ ⲁⲩⲧⲏⲓϥ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ ⲟⲩⲟϩ ⲁⲩⲭⲱ ⳿ⲛⲟⲩⲕⲁϣ ϧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲟⲩⲟϩ ⲛⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲟⲩⲕⲉⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ ⲉⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲉⲣⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϩⲓⲑⲁϥ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲡⲉϥϩⲟ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙⲡⲓⲕⲁϣ ⲟⲩⲟϩ ⲁⲩϩⲓⲟⲩ⳿ⲓ ϧⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲟⲩ⳿ⲱ ⲉⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲁⲩⲃⲁϣϥ ⳿ⲛϯ⳿ⲭⲗⲁⲙⲓⲥ ⲟⲩⲟϩ ⲁⲩϯ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ϩⲓⲱⲧϥ ⲟⲩⲟϩ ⲁⲩⲟⲗϥ ⲉⲑⲣⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ⲉⲩⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲁⲩϫⲓⲙⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲔⲩⲣⲓⲛⲛⲉⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲥⲓⲙⲱⲛ ⲫⲁⲓ ⲁⲩϭⲓⲧϥ ⳿ⲛ⳿ⲭⲃⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲗ ⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲉⲩⲙⲁ ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲅⲟⲗⲅⲟⲑⲁ ⳿ⲉⲧⲉ ⲡⲓⲙⲁ ⳿ⲛⲧⲉ ⲡⲓⲔ̇ⲣⲁⲛⲓⲟⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ⲁⲩϯ ⳿ⲛⲟⲩⲏⲣⲡ ⲛⲁϥ ⲉϥⲙⲟϫⲧ ⲛⲉⲙ ⲟⲩⲉⲛϣⲁϣⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲉⲙϯⲡⲓ ⳿ⲙⲡⲉϥⲟⲩⲱϣ ⳿ⲉⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","⳿ⲉⲧⲁⲩⲁϣϥ ⲇⲉ ⲁⲩⲫⲱϣ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲉⲁⲩϩⲓⲱⲡ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ⲟⲩⲟϩ ⲛⲁⲩϩⲉⲙⲥⲓ ⲉⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ⲟⲩⲟϩ ⲁⲩ⳿ⲥϧⲉ ⲧⲉϥ⳿ⲉⲧⲓ⳿ⲁ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲛⲧⲉϥ⳿ⲁⲫⲉ ⲉⲥ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲙⲡⲁⲓⲣⲏϯ ϫⲉ ( ⲪⲀⲒ ⲠⲈ Ⲡ̇ⲞⲨⲢⲞ Ⲛ̇ⲦⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ). ");
INSERT INTO copcnt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ⲧⲟⲧⲉ ⲁⲩⲉϣ ⲕⲉ ⲥⲟⲛⲓ ⲃ̅ ⲛⲉⲙⲁϥ ⲟⲩⲁⲓ ⲥⲁⲧⲉϥⲟⲩ⳿ⲓⲛⲁⲙ ⲛⲉⲙ ⲟⲩⲁⲓ ⲥⲁⲧⲉϥϫⲁϭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ⲛⲏ ⲇⲉ ⳿ⲉⲛⲁⲩⲥⲓⲛⲓ ⲛⲁⲩϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟϥ ⲡⲉ ⲉⲩⲕⲓⲙ ⳿ⲛⲧⲟⲩ⳿ⲁⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁⲃⲉⲗ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲕⲟⲧϥ ϧⲉⲛ ϣⲟⲙⲧ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲁϩⲙⲉⲕ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ ⳿ⲁⲙⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓϣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ϫⲉ ⲁϥⲛⲟϩⲉⲙ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲁϩⲙⲉϥ ⲓⲥϫⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⲡⲉ ⲙⲁⲣⲉϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ϯⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓϣⲉ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ⲓⲥϫⲉ ⳿ϩⲑⲏϥ ⲭⲏ ⳿ⲉⲪϯ ⲙⲁⲣⲉϥⲛⲁϩⲙⲉϥ ⲓⲥϫⲉ ϯⲛⲟⲩ ⳿ϥⲟⲩⲁϣϥ ⲁϥϫⲟⲥ ⲅⲁⲣ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ⲫⲁⲓ ⲇⲉ ⲛⲁⲣⲉ ⲛⲓⲕⲉⲥⲟⲛⲓ ϫⲱ ⳿ⲙⲙⲟϥ ⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲁϣⲟⲩ ⲛⲉⲙⲁϥ ⲉⲩϯ⳿ϣϭⲛⲏⲛ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ⲓⲥϫⲉⲛ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲋ̅ ⳿ⲁ ⳿ⲡⲭⲁⲕⲓ ϣⲱⲡⲓ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ ϣⲁ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲑ̅ ϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","⳿ⲉⲧⲁ ⳿ⲫⲛⲁⲩ ⲇⲉ ⳿ⲛⲁϫⲡ ⲯⲓϯ ϣⲱⲡⲓ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϧⲣⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲉⲗⲱ⳿ⲓ ⳿ⲉⲗⲱ⳿ⲓ ⲗⲉⲙⲁ ⲥⲁⲃⲁⲕⲑⲁⲛⲓ ⳿ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⲡⲁⲚⲟⲩϯ ⲡⲁⲚⲟⲩϯ ⲉⲑⲃⲉ ⲟⲩ ⲁⲕⲭⲁⲧ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥⲙⲟⲩϯ ⲟⲩⲃⲉ ⳿Ⲏ̇ⲗⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥϭⲟϫⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ⳿ⲛϧⲏⲧⲟⲩ ⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ⲥⲫⲟⲅⲅⲟⲥ ⲁϥⲙⲁϩⲥ ⳿ⲛϩⲉⲙϫ ⲟⲩⲟϩ ⲁϥⲑⲟⲕⲥ ⳿ⲉⲟⲩⲕⲁϣ ⲁⲩ⳿ⲧⲥⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","⳿ⲡⲥⲉⲡⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲁϥ ⳿ⲛⲧⲉⲛⲛⲁⲩ ϫⲉ ⳿ϥⲛⲏⲟⲩ ⳿ⲛϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⳿ⲛⲧⲉϥⲛⲁϩⲙⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲟⲛ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϧⲣⲱⲟⲩ ⲁϥϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ⲟⲩⲟϩ ⲓⲥ ⲡⲓⲕⲁⲧⲁⲡⲉⲧⲁⲥⲙⲁ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲁϥⲫⲱϧ ⲓⲥϫⲉⲛ ⳿ⲡϣⲱⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⲁϥⲉⲣ ⲃ̅ ⲟⲩⲟϩ ⲡⲓⲕⲁϩⲓ ⲁϥⲙⲟⲛⲙⲉⲛ ⲟⲩⲟϩ ⲛⲓⲡⲉⲧⲣⲁ ⲁⲩⲫⲱϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ⲟⲩⲟϩ ⲛⲓ⳿ⲙϩⲁⲩ ⲁⲩⲟⲩⲱⲛ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲱⲙⲁ ⳿ⲛⲧⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲉⲛⲕⲟⲧ ⳿ⲛⲧⲉ ⲛⲏ⳿ⲉⲑⲟⲩⲁⲃ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲉϥⲧⲱⲛϥ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲃⲁⲕⲓ ⲉ̅ⲑ̅ⲩ̅ ⲟⲩⲟϩ ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲉⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲇⲉ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ ⲉⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲒⲏ̅ⲥ̅ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲡⲓⲙⲟⲛⲙⲉⲛ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲁⲩϣⲱⲡⲓ ⲁⲩⲉⲣϩⲟϯ ⳿ⲉⲙⲁϣⲱ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⲛⲉ ⲫⲁⲓ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲙⲁⲩ ⲉⲩⲛⲁⲩ ϩⲓ ⳿ⲫⲟⲩⲉⲓ ⳿ⲉⲧⲉ ⲛⲁⲓ ⲛⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲉⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ⲛⲁⲓ ⳿ⲉⲧⲉ ⲛⲁⲣⲉ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⲑⲁ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⳿ⲑⲙⲁⲩ ⳿ⲛⲒⲱⲥⲏⲫ ⲛⲉⲙ ⳿ⲑⲙⲁⲩ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲁⲣⲓⲙⲁⲑⲉⲁⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲓⲱⲥⲏⲫ ⲫⲁⲓ ϩⲱϥ ⲁϥⲉⲣⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ⲫⲁⲓ ⳿ⲉⲧⲁϥ⳿ⲓ ϩⲁ Ⲡⲓⲗⲁⲧⲟⲥ ⲁϥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲧⲟⲧⲉ Ⲡⲓⲗⲁⲧⲟⲥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ⲟⲩⲟϩ ⲁϥϭⲓ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛϫⲉ Ⲓⲱⲥⲏⲫ ⲁϥⲕⲟⲩⲗⲱⲗϥ ϧⲉⲛ ⲟⲩϣⲉⲛⲧⲱ ⲉⲥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ⲟⲩⲟϩ ⲁϥⲭⲁϥ ϧⲉⲛ ⲡⲉϥ⳿ⲙϩⲁⲩ ⳿ⲙⲃⲉⲣⲓ ⲫⲏ⳿ⲉⲧⲁϥϣⲟⲕϥ ϧⲉⲛ ϯⲡⲉⲧⲣⲁ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲕⲉⲣⲕⲉⲣ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲱⲛⲓ ⳿ⲉⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ ⲁϥϩⲱⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ⲛⲁⲥⲭⲏ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲙⲁⲣⲓ⳿ⲁ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ ϯⲕⲉ Ⲙⲁⲣⲓ⳿ⲁ ⲉⲩϩⲉⲙⲥⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⳿ⲉⲧⲉ ⲙⲉⲛⲉⲛⲥⲁ ϯⲡⲁⲣⲁⲥⲕⲉⲩ⳿ⲏ ⲧⲉ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ϩⲁ Ⲡⲓⲗⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛ⳪ ⲁⲛⲉⲣ⳿ⲫⲙⲉⲩⲓ ϫⲉ ⳿ⲁ ⲡⲓ⳿ⲡⲗⲁⲛⲟⲥ ⲉⲧⲧⲏ ϫⲟⲥ ⲓⲥϫⲉⲛ ⲉϥⲟⲛϧ ϫⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϯⲛⲁⲧⲱⲛⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲟⲩⲛ ⳿ⲉⲧⲁϫⲣⲟ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ ϣⲁ ⲡⲓⲙⲁϩ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲙⲏⲡⲱⲥ ⳿ⲛⲧⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲟⲩⲟⲗϥ ⳿ⲛϭⲓⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϫⲟⲥ ⳿ⲙⲡⲓⲗⲁⲟⲥ ϫⲉ ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ϯϧⲁ⳿ⲉ ⳿ⲙ⳿ⲡⲗⲁⲛⲏ ⳿ⲧϩⲟ ⲛⲁⲛ ⳿ⲉϯϩⲟⲩ⳿ⲓϯ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ⲡⲉϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛⲧⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩ ⳿ⲛϩⲁⲛⲕⲟⲩⲥⲧⲱⲇⲓ⳿ⲁ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲙⲁⲧⲁϫⲣⲟϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϣⲉⲛⲱⲟⲩ ⲁⲩⲧⲁϫⲣⲟ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲉⲁⲩⲧⲟⲃϥ ⲛⲉⲙ ⲛⲓⲕⲟⲩⲥⲧⲱⲇⲓ⳿ⲁ ");
INSERT INTO copcnt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ⲣⲟⲩϩⲓ ⲇⲉ ⳿ⲛⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲧⲟⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲫⲟⲩⲁⲓ ⳿ⲛⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ Ⲙⲁⲣⲓ⳿ⲁ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ ϯⲕⲉ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲉⲛⲁⲩ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲟⲛⲙⲉⲛ ⲁϥϣⲱⲡⲓ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲕⲉⲣⲕⲉⲣ ⳿ⲙⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ ⲁϥϩⲉⲙⲥⲓ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ⲡⲉϥ⳿ⲥⲙⲟⲧ ⲇⲉ ⲛⲁϥⲟⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲥⲉⲧⲉⲃⲣⲏϫ ⲟⲩⲟϩ ⲧⲉϥϩⲉⲃⲥⲱ ⲉⲥⲟⲩⲱⲃϣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲭⲓⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","⳿ⲉⲃⲟⲗ ⲇⲉ ϧⲉⲛ ⲧⲉϥϩⲟϯ ⲁⲩⲙⲟⲛⲙⲉⲛ ⳿ⲛϫⲉ ⲛⲏⲉⲧ⳿ⲁⲣⲉϩ ⲟⲩⲟϩ ⲁⲩⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲣⲉϥⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲡⲉϫⲁϥ ⳿ⲛⲛⲓϩⲓ⳿ⲟⲙⲓ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⳿ⲛⲑⲱⲧⲉⲛ ϯ⳿ⲉⲙⲓ ⲅⲁⲣ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿ⲉⲧⲁⲩⲁϣϥ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","⳿ⲛ⳿ϥⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲁⲛ ⲁϥⲧⲱⲛϥ ⲅⲁⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥϫⲟⲥ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲁⲛⲁⲩ ⳿ⲉⲡⲓⲙⲁ ⳿ⲉⲛⲁϥⲭⲏ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ⲟⲩⲟϩ ⳿ⲛⲭⲱⲗⲉⲙ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲁϫⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⳿ϥⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲁⲣⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲁⲩ ⲓⲥ ϩⲏⲡⲡⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓ⳿ⲙϩⲁⲩ ϧⲉⲛ ⲟⲩϩⲟϯ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲁϣⲓ ⲛⲁⲩϭⲟϫⲓ ⳿ⲉⲧⲁⲙⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ⲟⲩⲟϩ ⲓⲥ ϩⲏⲡⲡⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲉⲣⲉⲧⲉ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ⲧⲟⲧⲉ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲙⲁⲧⲁⲙⲉ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲥⲉⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⲇⲉ ⲓⲥ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲕⲟⲩⲥⲧⲱⲇⲓ⳿ⲁ ⲁⲩ⳿ⲓ ⳿ⲉϯⲃⲁⲕⲓ ⲁⲩⲧⲁⲙⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲩⲉⲣ ⲟⲩⲥⲟϭⲛⲓ ⲁⲩϭⲓ ⳿ⲛϩⲁⲛϩⲁⲧ ⲉⲩ⳿ⲙ⳿ⲡϣⲁ ⲁⲩⲧⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓⲙⲁⲧⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁϫⲟⲥ ϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩ⳿ⲓ ⳿ⲛϫⲱⲣϩ ⲁⲩⲟⲗϥ ⳿ⲛϭⲓⲟⲩ⳿ⲓ ϩⲱⲥⲧⲉ ⳿ⲉⲛⲉⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲓⲥⲁϫⲓ ⲉⲛ⳿ⲉⲑⲉⲧ⳿ϩⲑⲏϥ ⳿ⲁⲛⲟⲛ ⲟⲩⲟϩ ⲉⲛ⳿ⲉⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛⲁⲧⲣⲱⲟⲩϣ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲛⲛⲓϩⲁⲧ ⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲩ⳿ⲧⲥⲁⲃⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲁ ⲡⲁⲓⲥⲁϫⲓ ⲥⲱⲣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲒⲟⲩⲇⲁⲓ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ⲡⲓ ⲓ̅ⲁ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϯⲛⲉⲓ ⲛⲱⲟⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⲁⲩϭⲓⲥⲁⲛⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲩϯ ⲉⲣϣⲓϣⲓ ⲛⲓⲃⲉⲛ ⲛⲏⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⲛⲉⲙ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲟⲩⲛ ⲙⲁ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲉⲣⲉⲧⲉⲛⲱⲙⲥ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲪ̇ⲓⲱⲧ ⲛⲉⲙ Ⲡ̇ϣⲏⲣⲓ ⲛⲉⲙ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉ̅ⲑ̅ⲩ̅. ");
INSERT INTO copcnt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","⳿ⲉⲣⲉⲧⲉⲛϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲓϩⲉⲛϩⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲓⲥ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯⲭⲏ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛⲛⲓⲉϩⲟⲟⲩ ⲧⲏⲣⲟⲩ ϣⲁ ⳿ⲡϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓ⳿⳿ⲉⲛⲉϩ Ⲁ̇ⲙⲏⲛ ⲉⲩⲁⲅⲅⲉⲗⲓⲟⲩ ⲧⲟⲩ ⲕ̅ⲩ̅ ⲍⲱⲏⲥ Ⲁ̇ⲙⲏⲛ Ⲁ̇ⲙⲏⲛ ");
INSERT INTO copcnt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","⳿ Ⲧⲁⲣⲭⲏ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ Ⲏ̇ⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲟⲩⲱⲣⲡ ⳿ⲙⲡⲁⲁⲅⲅⲉⲗⲟⲥ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲉⲕϩⲟ ⲫⲏⲉⲑⲛⲁⲥⲟⲃϯ ⳿ⲙⲡⲉⲕⲙⲱⲓⲧ ϧⲁϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","⳿ⲡ⳿ϧⲣⲱⲟⲩ ⳿ⲙⲡⲉⲧⲱϣ ⳿ⲉⲃⲟⲗϩⲓ ⳿ⲡϣⲁϥⲉ ϫⲉ ⲥⲉⲃⲧⲉ ⳿ⲫⲙⲱⲓⲧ ⳿ⲙⲠ⳪ ⲥⲟⲩⲧⲱⲛ ⲛⲉϥⲙⲁⲛⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲟⲩⲟϩ ⲉϥϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲱⲙⲥ ⳿ⲙⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ϧⲉⲛ ⲟⲩⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ϩⲁⲛⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲁ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⳿ⲛⲭⲱⲣⲁ ⲛⲉⲙ ⲛⲁ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩϭⲓⲱⲙⲥ ⳿ⲛⲧⲟⲧϥ ϧⲉⲛ ⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ⳿ⲛⲓⲁⲣⲟ ⲉⲩⲟⲩⲱⲛϩ ⳿ⲛⲛⲟⲩⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ⲟⲩⲟϩ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲁⲣⲉ ϩⲁⲛϥⲱⲓ ⳿ⲛϫⲁⲙⲟⲩⲗ ⲧⲟⲓ ϩⲓⲱⲧϥ ⲡⲉ ⲟⲩⲟϩ ⲉϥⲙⲏⲣ ⳿ⲛⲟⲩⲙⲟϫϧ ⳿ⲛϣⲁⲣ ⳿ⲉϫⲉⲛ ⲧⲉϥϯⲡⲓ ⲟⲩⲟϩ ⲛⲁϥⲟⲩⲉⲙ ⳿ϣϫⲉ ⲡⲉ ⲛⲉⲙ ⳿ⲉⲃⲓ⳿ⲱ ⳿ⲛⲧⲉ ⳿ⲧⲕⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ⲟⲩⲟϩ ⲛⲁϥϩⲓⲱⲓϣ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲛⲏⲟⲩ ⲙⲉⲛⲉⲛⲥⲱⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧϫⲟⲣ ⳿ⲉϩⲟⲧⲉⲣⲟⲓ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ⳿ⲉϫⲟⲃⲥⲧ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯⲟⲩ⳿ⲱ ⳿ⲛⲟⲩⲙⲟⲩⲥⲉⲣ ⳿ⲛⲧⲉ ⲡⲉϥⲑⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","⳿ⲁⲛⲟⲕ ⲁⲓϯⲱⲙⲥ ⲛⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ϥⲛⲁⲉⲙⲥ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲛⲁⲍⲁⲣⲉⲑ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲁϥϭⲓⲱⲙⲥ ϧⲉⲛ ⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ⳿ⲛⲧⲟⲧϥ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲱⲟⲩ ⲁϥⲛⲁⲩ ⳿ⲉⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲉⲁⲩⲫⲱϧ ⲟⲩⲟϩ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϭⲣⲟⲙⲡⲓ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩⲟϩ ⲁϥ⳿ⲟϩⲓ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲙⲏ ⲛⲁⲥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⳿ⲉⲧⲁⲓϯⲙⲁϯ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⳿ⲁ ⲡⲓⲡ͞ⲛⲁ̅ ϩⲓⲧϥ ⳿ⲉⲃⲟⲗϩⲓ ⳿ⲡϣⲁϥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ⲡⲉ ϩⲓ ⳿ⲡϣⲁϥⲉ ⳿ⲛ ⲙ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲙ̅ ⳿ⲛ⳿ⲉϫⲱⲣϩ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ⲡⲉ ⲛⲉⲙ ⲛⲓⲑⲏⲣⲓⲟⲛ ⲟⲩⲟϩ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⲛⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲟⲩϯ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲉϥϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ⲟⲩⲟϩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲥⲏⲟⲩ ⲟⲩⲟϩ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲁⲣⲓⲙⲉⲧ⳿ⲁⲛⲟⲓⲛ ⲟⲩⲟϩ ⲛⲁϩϯ ϧⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲁϥⲛⲁⲩ ⳿ⲉⲤⲓⲙⲱⲛ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ⳿ⲡⲥⲟⲛ ⳿ⲛⲤⲓⲙⲱⲛ ⲉⲩϩⲓ⳿ϣⲛⲉ ⳿ⲛⲥⲓϯ ⳿ⲉ⳿ⲫⲓⲟⲙ ϫⲉ ⲟⲩⲏⲓ ⲅⲁⲣ ⲛⲉ ϩⲁⲛⲟⲩ⳿ⲟϩⲓ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⳿ⲛⲧⲁⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛϩⲁⲛⲟⲩ⳿ⲟϩⲓ ⳿ⲛⲣⲉϥⲧⲁϩⲉⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ⲟⲩⲟϩ ⲁⲩⲭⲁ ⲛⲟⲩ⳿ϣⲛⲏⲟⲩ ⳿ⲛⲥⲱⲟⲩ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⲉⲧϩⲏ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁϥⲛⲁⲩ ⳿ⲉⲒⲁⲕⲱⲃⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϥⲥⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⲉⲩϩⲓ ⲡⲓϫⲟⲓ ⲉⲩⲥⲟⲃϯ ⳿ⲛⲛⲟⲩ⳿ϣⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲭⲁ ⲡⲟⲩⲓⲱⲧ ⳿ⲛⲥⲱⲟⲩ Ⲍⲉⲃⲉⲇⲉⲟⲥ ϩⲓⲡⲓϫⲟⲓ ⲛⲉⲙ ⲛⲓⲙⲩⲥⲑⲱⲧⲏⲥ ⲁⲩϣⲉⲛⲱⲟⲩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ⲟⲩⲟϩ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲔⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ϧⲉⲛ ⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲧⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⲛⲁϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲅⲁⲣ ⲛⲱⲟⲩ ⲡⲉ ϩⲱⲥ ⳿ⲉⲣⲉ ⲡⲉϥⲉⲣϣⲓϣⲓ ⳿ⲛⲧⲟⲧϥ ⲟⲩⲟϩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲁⲛ ⳿ⲛⲛⲓⲥⲁϧ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲉϥϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛ⳿⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲟⲩⲟϩ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁϧⲟⲕ ⲛⲉⲙⲁⲛ Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ⳿ⲉⲧⲁⲕ⳿ⲓ ⳿ⲉⲧⲁⲕⲟⲛ ⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⲡⲓ⳿ⲁⲅⲓⲟⲥ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲑⲱⲙ ⳿ⲛⲣⲱⲕ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ⳿ⲛⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ⲟⲩⲟϩ ⲁϥ⳿ϣⲧⲉⲣⲑⲱⲣϥ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲟⲩⲟϩ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲣⲱⲟⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ⲧⲏⲣⲟⲩ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩⲕⲱϯ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⲟⲩ⳿ⲥⲃⲱ ⳿ⲙⲃⲉⲣⲓ ⲧⲉ ϫⲉ ϧⲉⲛ ⲟⲩⲉⲣϣⲓϣⲓ ⳿ϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲥⲉⲥⲱⲧⲉⲙ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ⲟⲩⲟϩ ⳿ⲁ ⲧⲉϥ⳿ⲥⲙⲏ ⲥⲁⲧⲟⲧϥ ⲥⲱⲣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ϧⲉⲛ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲟⲩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ⳿ⲉⲣⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙⲱⲟⲩ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","⳿ⲧϣⲱⲙⲓ ⲇⲉ ⳿ⲛⲤⲓⲙⲱⲛ ⲛⲁⲥⲉⲛⲕⲟⲧ ⲡⲉ ⲉⲥϧⲏⲙ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩϫⲟⲥ ⲛⲁϥ ⲉⲑⲃⲏⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲁϥⲧⲟⲩⲛⲟⲥⲥ ⳿ⲉⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲉⲥϫⲓϫ ⲟⲩⲟϩ ⲁϥⲭⲁⲥ ⳿ⲛϫⲉ ⲡⲓ⳿ϧⲙⲟⲙ ⲟⲩⲟϩ ⲛⲁⲥϣⲉⲙϣⲓ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ϩⲟⲧⲉ ⳿ⲉⲧⲁ ⳿ⲫⲣⲏ ϩⲱⲧⲡ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ⲟⲩⲟϩ ϯⲃⲁⲕⲓ ⲧⲏⲣⲥ ⲁⲥⲑⲱⲟⲩϯ ϩⲓⲣⲉⲛ ⲡⲓⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ⲟⲩⲟϩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲟⲩⲙⲏϣ ⲉⲩ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ϧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲏϯ ⳿ⲛϣⲱⲛⲓ ⲟⲩⲟϩ ⲁϥϩⲓ ⲟⲩⲙⲏϣ ⳿ⲛⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲁϥⲭⲱ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲥⲁϫⲓ ⲁⲛ ⲡⲉ ϫⲉ ⲟⲩⲏⲓ ⲅⲁⲣ ⲛⲁⲩⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲛϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲙⲁϣⲱ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲟⲩⲙⲁ⳿ⲛϣⲁϥⲉ ⲟⲩⲟϩ ⲛⲁϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ⲟⲩⲟϩ ⲁϥϭⲟϫⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ Ⲥⲓⲙⲱⲛ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϫⲉⲙϥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲥⲉⲕⲱϯ ⳿ⲛⲥⲱⲕ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁⲣⲟⲛ ⳿ⲉⲕⲉ ⲙⲁ ⳿ⲉⲛⲓⲕⲟⲙⲟⲡⲟⲗⲓⲥ ⲉⲧϧⲉⲛⲧ ⳿ⲉⲣⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛϩⲓⲱⲓϣ ⳿ⲙⲙⲁⲩ ϩⲱϥ ⳿ⲉⲧⲁⲓ⳿ⲓ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲁⲓϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲉϥϩⲓⲱⲓϣ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲧⲏⲣⲥ ⲟⲩⲟϩ ⲛⲓⲇⲉⲙⲱⲛ ⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲕⲁⲕⲥⲉϩⲧ ⲉϥϯϩⲟ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲉϥϩⲓ ⳿ⲙⲙⲟϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⳿ⲉϣⲱⲡ ⲁⲕϣⲁⲛⲟⲩⲱϣ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲧⲟⲩⲃⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥϣⲉⲛϩⲏⲧ ϧⲁⲣⲟϥ ⲁϥⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁϥϭⲓⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ϯⲟⲩⲱϣ ⲙⲁⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⳿ⲁ ⲡⲓⲥⲉϩⲧ ϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗϩⲓⲱⲧϥ ⲟⲩⲟϩ ⲁϥⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲥⲣⲉⲙⲣⲱⲙϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲥⲁⲧⲟⲧϥ ⲁϥϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲣϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⲁⲗⲗⲁ ⲙⲁϣⲉⲛⲁⲕ ⲙⲁⲧⲁⲙⲉ ⲡⲓⲟⲩⲏⲃ ⳿ⲉⲣⲟⲕ ⲟⲩⲟϩ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲇⲱⲣⲟⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϫⲉⲛ ⲡⲉⲕⲧⲟⲩⲃⲟ ⲫⲏ⳿ⲉⲧⲁ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲟϥ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲙⲏϣ ⲟⲩⲟϩ ⳿ⲉⲥⲉⲣ ⲡⲉϥⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙϫⲉⲙϫⲟⲙ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲁⲕⲓ ⳿ⲛⲟⲩⲱⲛϩ ⲁⲗⲗⲁ ⲛⲁϥϣⲟⲡ ⲡⲉ ϧⲉⲛ ϩⲁⲛⲙⲱⲓⲧ ⳿ⲛϣⲁϥⲉ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ");
INSERT INTO copcnt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲟⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲔⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲙⲉⲛⲉⲛⲥⲁ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⲉϥⲭⲏ ϧⲉⲛ ⲟⲩⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ⲟⲩⲟϩ ⳿ⲁ ⲟⲩⲙⲏϣ ⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲓⲏⲓ ⳿ⲱⲗⲓ ϫⲉ ⲟⲩⲇⲉ ϩⲓⲣⲉⲛ ⲡⲓⲣⲟ ⲟⲩⲟϩ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲙⲡⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲁⲓ ⲉϥϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲉⲩϥⲁⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲇ̅ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲉ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲉⲛϥ ⳿ⲉϧⲟⲩⲛ ⲉⲑⲃⲉ ⲡⲓⲙⲏϣ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϫⲉⲛ ⳿ⲡϫⲉⲛⲉⲫⲱⲣ ⲁⲩϭⲱⲣⲡ ⳿ⲛϯⲟⲩⲁϩⲥⲟⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲡⲓⲏⲓ ⳿ⲉⲛⲁⲩⲭⲏ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϣⲱⲕⲓ ⲁⲩⲭⲱ ⳿ⲙⲡⲓϭⲗⲟϫ ⳿ⲉⲡⲉⲥⲏⲧ ⲫⲏ⳿ⲉⲛⲁⲣⲉ ⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲉⲛⲕⲟⲧ ϩⲓⲱⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲡⲟⲩⲛⲁϩϯ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ϫⲉ ⲡⲁϣⲏⲣⲓ ⲛⲉⲕⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓⲥⲁϧ ⳿ⲙⲙⲁⲩ ⲉⲩϩⲉⲙⲥⲓ ⲟⲩⲟϩ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲫⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ϫⲉⲟⲩ⳿ⲁ ⲛⲓⲙ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ Ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⳿ⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲙⲓ ϧⲉⲛ ⲡⲉϥⲡ͞ⲛⲁ̅ ϫⲉ ⲥⲉⲙⲟⲕⲙⲉⲕ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ⳿ⲉⲛⲁⲓ ϧⲉⲛ ⲛⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ⲟⲩ ⲡⲉⲑⲙⲟⲧⲉⲛ ⳿ⲉϫⲟⲥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ϫⲉ ⲛⲉⲕⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ϣⲁⲛ ⳿ⲉϫⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⳿ⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲡⲉⲣϣⲓϣⲓ ⳿ⲛⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⳿ⲉⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ⲧⲱⲛⲕ ⳿ⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ ⲟⲩⲟϩ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉⲡⲉⲕⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲧⲱⲛϥ ⲁϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥϭ ⲗⲟϫ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲛⲛⲁⲩ ⳿ⲉⲟⲩⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲟⲛ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲉⲛⲁϥⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ⲟⲩⲟϩ ⲉϥⲥⲓⲛⲓ⳿ⲱⲟⲩ ⲁϥⲛⲁⲩ ⳿ⲉⲖⲉⲩ⳿ⲓ ⳿ⲛⲧⲉ Ⲁⲗⲫⲉⲟⲥ ⲉϥϩⲉⲙⲥⲓ ϩⲓ ⲡⲓⲧⲉⲗⲱⲛⲓⲟⲛ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉϥⲣⲱⲧⲉⲃ ϧⲉⲛ ⲡⲉϥⲏⲓ ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲙⲏϣ ⳿ⲛⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ϩⲁⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲛⲁⲩⲣⲱⲧⲉⲃ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲁⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ⲟⲩⲟϩ ⲛⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ϫⲉ ⳿ϥⲟⲩⲱⲙ ⲛⲉⲙ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ϥⲥⲱ ⲛⲉⲙ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲁⲛ ⳿ⲛϫⲉ ⲛⲏⲉⲧϫⲟⲣ ⳿ⲙⲡⲓⲥⲏⲓⲛⲓ ⲁⲗⲗⲁ ⲛⲏⲉⲑⲙⲟⲕϩ ⲛⲉⲧⲁⲓ⳿ⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲉⲑⲁϩⲉⲙ ⲛⲓ⳿ⲑⲙⲏⲓ ⲁⲗⲗⲁ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲉⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ ⲛⲁ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲥⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲥⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲏ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ϩⲟⲥ ⲉϥⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲭⲣⲟⲛⲟⲥ ⲛⲓⲃⲉⲛ ϩⲟⲥ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲛⲉⲙⲱⲟⲩ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ⲥⲉⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛ⳿ⲱⲗⲓ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲛⲧⲟⲧⲟⲩ ⲧⲟⲧⲉ ⲥⲉⲛⲁⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⲑⲉⲣⲡ ⲟⲩⲧⲱⲓⲥ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ⳿ⲙⲙⲟⲛ ϣⲁⲣⲉ ⲡⲓⲃⲉⲣⲓ ⲉⲗ ⲡⲓⲙⲟϩ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲁⲡⲁⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲟⲩⲫⲱϧ ϣⲱⲡⲓ ⲉϥϩⲱⲟⲩ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ⲟⲩⲟϩ ⳿ⲙⲡⲁⲩϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉ⳿ⲁⲥⲕⲟⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ⳿ⲙⲙⲟⲛ ϣⲁⲣⲉ ⲡⲓⲏⲣⲡ ⲫⲉϧ ⲛⲓ⳿ⲁⲥⲕⲟⲥ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲡⲓⲏⲣⲡ ⲧⲁⲕⲟ ⲛⲉⲙ ⲛⲓ⳿ⲁⲥⲕⲟⲥ ⲁⲗⲗⲁ ϣⲁⲩϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉ⳿ⲁⲥⲕⲟⲥ ⳿ⲙⲃⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲧⲁϥⲙⲟϣⲓ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲣⲟϯ ⲟⲩⲟϩ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲉⲣϩⲏⲧⲥ ⲉⲩⲙⲟϣⲓ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲫⲉϫ ϧⲉⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲁⲩ ϫⲉ ⲟⲩ ⲡⲉⲧⲟⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲙⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲁⲓϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⳿⳿ⲉⲛⲉϩ ϫⲉ ⲟⲩ ⲡⲉⲧⲁϥⲁⲓϥ ⳿ⲛϫⲉ Ⲇⲁⲩⲓⲇ ϩⲟⲧⲉ ⳿ⲉⲧⲁϥⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ϩⲕⲟ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ⲡⲱⲥ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲪϯ ⲛⲁϩⲣⲁϥ ⳿ⲛⲀ̇ⲃⲓ⳿ⲁⲑⲁⲣ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲛⲓⲱⲓⲕ ⳿ⲛⲧⲉ ϯ⳿ⲡⲣⲟⲑⲉⲥⲓⲥ ⲁϥⲟⲩ⳿ⲟⲙⲟⲩ ⲛⲏ⳿ⲉⲧⲉ ⳿ⲛ⳿ⲥϣⲉ ⲛⲁϥ ⲁⲛ ⳿ⲉⲟⲩ⳿ⲟⲙⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲓⲟⲩⲏⲃ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲉⲛⲁⲩⲭⲏ ⲛⲉⲙⲁϥ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲉⲧⲁ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ϣⲱⲡⲓ ⲉⲑⲃⲉ ⲡⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲡⲓⲣⲱⲙⲓ ⲁⲛ ⲉⲑⲃⲉ ⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ϩⲱⲥⲧⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ");
INSERT INTO copcnt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲟⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ ⳿ⲉⲣⲉ ⲧⲉϥϫⲓϫ ϣⲟⲩ⳿ⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ⲟⲩⲟϩ ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲛⲁϥ ⲡⲉ ϫⲉ ⲁⲛ ⳿ϥⲛⲁⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉⲣⲉ ⲧⲉϥϫⲓϫ ϣⲟⲩ⳿ⲱⲟⲩ ϫⲉ ⲧⲱⲛⲕ ϧⲉⲛ ⳿ⲑⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲥϣⲉ ⳿ⲛⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ϣⲁⲛ ⳿ⲉⲉⲣⲡⲉⲧϩⲱⲟⲩ ⲟⲩⲯⲩⲭⲏ ⳿ⲉⲛⲁϩⲙⲉⲥ ϣⲁⲛ ⳿ⲉϧⲟⲑⲃⲉⲥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲭⲁⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲟⲩ⳿ⲙⲃⲟⲛ ⲉϥⲙⲟⲕϩ ⳿ⲛϩⲏⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲑⲱⲙ ⳿ⲛⲧⲉ ⲡⲟⲩϩⲏⲧ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ϫⲉ ⲥⲟⲩⲧⲉⲛ ⲧⲉⲕϫⲓϫ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲟⲩⲧⲱⲛⲥ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲧⲉϥϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁⲧⲟⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲥⲟϭⲛⲓ ⲛⲉⲙ ⲛⲓⲎ̇ⲣⲱⲇⲓ⳿ⲁⲛⲟⲥ ϧⲁⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ⲟⲩⲟϩ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲉⲣⲁⲛⲁⲭⲱⲣⲓⲛ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲁϥⲉⲣ⳿ⲁⲕⲟⲗⲟⲩⲑⲓⲛ ⲛⲉⲙ ϯⲒⲟⲩⲇⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ⲛⲉⲙ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ϯϨⲩⲇⲟⲩⲙⲉ⳿ⲁ ⲛⲉⲙ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ⲛⲉⲙ ⲕⲉⲙⲏϣ ⲉϥⲟϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲁ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲤⲓⲇⲱⲛ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲉⲛⲏ⳿ⲉⲛⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩϫⲟⲓ ⲙⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉ ⲡⲓⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϩⲉϫϩⲱϫϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ϩⲁⲛⲙⲏϣ ⲅⲁⲣ ⲛⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩ⳿ⲓ ⳿ⲉϫⲱϥ ⳿ⲛⲧⲟⲩϭⲓⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲛⲁⲣⲉ ϩⲁⲛⲙⲁⲥⲧⲓⲅⲝ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ⲟⲩⲟϩ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ϣⲁⲩϩⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲣⲁⲧϥ ⲟⲩⲟϩ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ϣⲧⲉⲙⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲏ⳿ⲉⲧⲁϥⲟⲩ⳿ⲁϣⲟⲩ ⳿ⲛⲑⲟϥ ⲟⲩⲟϩ ⲁⲩϣⲉⲛⲱⲟⲩ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ⲟⲩⲟϩ ⲁϥⲑⲁⲙⲓ⳿ⲉ ⲓ̅ⲃ̅ ⲛⲏ⳿ⲉⲧⲁϥϯⲣⲉⲛⲟⲩ ϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ⲟϩⲓ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉϩⲓⲱⲓϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ⲟⲩⲟϩ ⲉⲑⲣⲉ ⳿ⲡⲉⲣϣⲓϣⲓ ϣⲱⲡⲓ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲉⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϣⲱⲛⲓ ⲟⲩⲟϩ ⳿ⲉϩⲓ ⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲟⲩⲣⲁⲛ ⳿ⲉⲤⲓⲙⲱⲛ ϫⲉ Ⲡⲉⲧⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ⲟⲩⲟϩ Ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲡⲥⲟⲛ ⳿ⲛⲒⲁⲕⲱⲃⲟⲥ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛϩⲁⲛⲣⲁⲛ ⳿ⲉⲣⲱⲟⲩ ϫⲉ Ⲃⲟ⳿ⲁⲛⲉⲣⲅⲉⲥ ⳿ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ϯϧⲁⲣⲁⲃⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ⲛⲉⲙ Ⲫⲓⲗⲓⲡⲡⲟⲥ Ⲃⲁⲣⲑⲟⲗⲟⲙⲉⲟⲥ ⲛⲉⲙ Ⲙⲁⲧⲑⲉⲟⲥ ⲛⲉⲙ Ⲑⲱⲙⲁⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲛⲧⲉ Ⲁⲗⲫⲉⲟⲥ ⲛⲉⲙ Ⲑⲁⲇⲇⲉⲟⲥ ⲛⲉⲙ Ⲥⲓⲙⲱⲛ ⲡⲓⲔⲁⲛⲁⲛⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ⲛⲉⲙ Ⲓⲟⲩⲇⲁⲥ ⲡⲓⲒⲥⲕⲁⲣⲓ⳿ⲱⲧⲏⲥ ⲫⲏ⳿ⲉⲧⲁϥⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲏⲓ ⲟⲩⲟϩ ⲁϥⲑⲱⲟⲩϯ ⲟⲛ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϫⲉⲙϫⲟⲙ ⲟⲩⲇⲉ ⳿ⲉⲟⲩⲉⲙ ⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲏ⳿ⲉⲧⲉⲛⲟⲩϥ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲛⲁⲩϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⳿ⲁ ⲡⲉϥϩⲏⲧ ⲥⲓϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲛⲓⲥⲁϧ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ⲉⲑⲛⲉⲙⲁϥ ⲟⲩⲟϩ ϫⲉ ϧⲉⲛ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ϫⲉ ⲡⲱⲥ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ϩⲓ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁⲥ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉⲥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲟⲩⲏⲓ ⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ⲟⲩⲟϩ ⲓⲥϫⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲡⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉϫⲱϥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁϥⲫⲱϣ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲁⲗⲗⲁ ⲟⲩⲟⲛⲧⲉϥ ⲟⲩϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ⲁⲗⲗⲁ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓϫⲱⲣⲓ ⳿ⲛⲧⲉϥϩⲱⲗⲉⲙ ⳿ⲛⲛⲉϥ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲉⲃⲏⲗ ⳿ⲛⲧⲉϥⲥⲱⲛϩ ⳿ⲙⲡⲓϫⲱⲣⲓ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⳿ⲛⲧⲉϥϩⲱⲗⲉⲙ ⳿ⲙⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲩ⳿ⲉⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲛⲟⲃⲓ ⲛⲉⲙ ⲛⲓϫⲉⲟⲩ⳿ⲁ ⲧⲏⲣⲟⲩ ⳿ⲉⲧⲟⲩⲛⲁϫⲉⲟⲩ⳿ⲁ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙⲙⲟⲛ ⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲁϥ ϣⲁ ⳿⳿ⲉⲛⲉϩ ⲁⲗⲗⲁ ⳿ϥⲟⲓ ⳿ⲛ⳿ⲉⲛⲟⲭⲟⲥ ⳿ⲛⲟⲩϩⲁⲡ ⳿ⲛ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ϫⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛ⳿⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲥⲁⲃⲟⲗ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲓⲙⲏϣ ϩⲉⲙⲥⲓ ⳿ⲙⲡⲉϥⲕⲱϯ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲓⲥ ⲧⲉⲕⲙⲁⲩ ⲛⲉⲙ ⲛⲉⲕ⳿ⲥⲛⲏⲟⲩ ⲥⲁⲃⲟⲗ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⲧⲉ ⲧⲁⲙⲁⲩ ⲛⲉⲙ ⲛⲁ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲛⲏⲉⲧϩⲉⲙⲥⲓ ⳿ⲙⲡⲉϥⲕⲱϯ ⲡⲉϫⲁϥ ϫⲉ ⲓⲥ ⲧⲁⲙⲁⲩ ⲛⲉⲙ ⲛⲁ⳿ⲥⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ⲫⲏ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲉⲣ ⲡⲉⲧⲉϩⲛⲉ Ⲫϯ ⲫⲁⲓ ⲡⲉ ⲡⲁⲥⲟⲛ ⲛⲉⲙ ⲧⲁⲥⲱⲛⲓ ⲛⲉⲙ ⲧⲁⲙⲁⲩ ");
INSERT INTO copcnt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϯ⳿ⲥⲃⲱ ⳿ⲉ⳿ⲥⲕⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥ⳿ⲁⲗⲏⲓ ⳿ⲉ⳿ⲡϫⲟⲓ ⳿ⲛⲧⲉϥϩⲉⲙⲥⲓ ϧⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲟⲙ ϩⲓ ⲡⲓ⳿ⲭⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⳿ⲛϩⲁⲛⲙⲏϣ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϧⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ϫⲉ ⲥⲱⲧⲉⲙ ϩⲏⲡⲡⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥⲥⲓϯ ⳿ⲉⲥⲓϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉϥⲥⲓϯ ⲟⲩⲁⲓ ⲙⲉⲛ ⲁϥϩⲉⲓ ⳿ⲉ⳿ⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓϩⲁⲗⲁϯ ⲁⲩⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ⳿ⲙⲡⲉⲧⲣⲁ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲕⲁϩⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲣⲱⲧ ⲉⲑⲃⲉ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲉϥ ϣⲱⲕ ⳿ⲛⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ⲟⲩⲟϩ ϩⲟⲧⲉ ⳿ⲉⲧⲁϥϣⲁⲓ ⳿ⲛϫⲉ ⳿ⲫⲣⲏ ⲁϥⲉⲣⲕⲁⲩⲙⲁ ⲟⲩⲟϩ ⲉⲑⲃⲉ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲉϥ ⲛⲟⲩⲛⲓ ⲁϥϣⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲥⲟⲩⲣⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛϫⲉ ⲛⲓⲥⲟⲩⲣⲓ ⲁⲩⲟϫϩϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥϯⲟⲩⲧⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ⲟⲩⲟϩ ϩⲁⲛⲕⲉ ⲟⲩⲟⲛ ⲁⲩϩⲉⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲁⲩϯ ⲟⲩⲧⲁϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⲁϥⲉⲣⲉⲩⲑⲉⲛⲓⲛ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⲁϥⲉⲛ ⲗ̅ ⲕⲉⲟⲩⲁⲓ ⲝ̅ ⲕⲉⲟⲩⲁⲓ ⲣ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲱϯ ⳿ⲉⲣⲟϥ ⲛⲉⲙ ⲡⲓ ⲓ̅ⲃ̅ ⲉⲑⲃⲉ ⲛⲓⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ⲟⲩⲟϩ ⲡⲉϥϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲧⲉ ⲥⲧⲟⲓ ⲛⲱⲧⲉⲛ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲛⲛⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲛⲏⲇⲉ ⳿ⲛⲑⲱⲟⲩ ⲉⲧⲥⲁⲃⲟⲗ ϣⲁⲣⲉ ⳿ⲡⲧⲏⲣϥ ϣⲱⲡⲓ ⲛⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ϩⲓⲛⲁ ⲉⲩⲛⲁⲩ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲛⲁⲩ ⲟⲩⲟϩ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲟⲩⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲕⲁϯ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲧⲟⲩⲕⲟⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲭⲱ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⳿ⲉⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲟⲩⲟϩ ⲡⲱⲥ ⲛⲓⲕⲉⲡⲁⲣⲁⲃⲟⲗⲏ ⲧⲏⲣⲟⲩ ⲧⲉⲧⲉⲛⲛⲁⲥⲟⲩ⳿ⲱⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ⲫⲏⲉⲧⲥⲓϯ ⲁϥⲥⲓϯ ⳿ⲙⲡⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ⲛⲁⲓ ⲇⲉ ⲛⲉ ⲛⲏⲉⲧϩⲓ ⳿ⲉ⳿ⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲡⲓⲙⲁ ⳿ⲉⲧⲁⲩⲥⲓϯ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲟⲩⲥⲱⲧⲉⲙ ⲥⲁⲧⲟⲧϥ ⲇⲉ ϣⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲧⲁⲩⲥⲁⲧϥ ⳿ⲛϧⲣⲏⲓ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ⲟⲩⲟϩ ⲛⲁⲓ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲡⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲥⲁⲧⲟⲩ ϩⲓϫⲉⲛ ⲛⲓⲙⲁ⳿ⲙⲡⲉⲧⲣⲁ ⲛⲏ⳿ⲉⲧⲉ ⲁⲩϣⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ϣⲁⲩϭⲓⲧϥ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲛⲟⲩⲛⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲗⲗⲁ ϩⲁⲛ⳿ⲡⲣⲟⲥ ⲟⲩⲥⲏⲟⲩ ⲛⲉ ⳿ⲓⲧⲁ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩϩⲟϫϩⲉϫ ϣⲱⲡⲓ ⲓⲉ ⲟⲩⲇⲓⲱⲅⲙⲟⲥ ⲉⲑⲃⲉ ⲡⲓⲥⲁϫⲓ ⲥⲁⲧⲟⲧⲟⲩ ϣⲁⲩⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲟⲩⲟⲛ ⲛⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲥⲁⲧⲟⲩ ϩⲓϫⲉⲛ ⲛⲓⲥⲟⲩⲣⲓ ⲛⲁⲓ ⲛⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ⲟⲩⲟϩ ⲛⲓⲣⲱⲟⲩϣ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿⳿ⲉⲛⲉϩ ⲛⲉⲙ ϯ⳿ⲁⲡⲁⲧⲏ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⲛⲉⲙ ⲛⲓ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲛⲓⲕⲉⲥⲱϫⲡ ⲉⲩⲙⲟϣⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲥⲉⲱϫϩ ⳿ⲙⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ϣⲁϥⲉⲣⲁⲧⲟⲩⲧⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ⲟⲩⲟϩ ⲛⲏ ϩⲱⲟⲩ ⳿ⲉⲧⲁⲩⲥⲁⲧⲟⲩ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲛⲏ⳿ⲉⲧⲉ ⲁⲩϣⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ϣⲁⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ϣⲁⲩϯ ⲟⲩⲧⲁϩ ⲟⲩⲁⲓ ⳿ⲛⲗ̅ ⲟⲩⲁⲓ ⳿ⲛⲝ̅ ⲟⲩⲁⲓ ⳿ⲛⲣ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲙⲏⲧⲓ ϣⲁⲩϭⲉⲣⲉ ⲟⲩϧⲏⲃⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲭⲁϥ ϧⲁ ⲡⲓⲙⲉⲛⲧ ⲓⲉ ϧⲁ ⲡⲓϭⲗⲟϫ ⲟⲩⲭⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲭⲁϥ ϩⲓϫⲉⲛ ϯⲗⲩⲭⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⲡⲉⲧϩⲏⲡ ⲁϥ⳿ϣⲧⲉⲙⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲟⲩⲇⲉ ⳿ⲙⲡⲁϥϣⲱⲡⲓ ⲉϥϩⲏⲡ ⳿ⲉⲃⲏⲗ ϫⲉ ⳿ⲛⲧⲉϥ⳿ⲓ ⲉϥⲟⲩⲱⲛϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⲟⲛ ϫⲉ ⳿ⲁⲛⲁⲩ ϫⲉ ⲟⲩ ⲡⲉ ⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲓϣⲓ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁϣⲓ ⳿ⲙⲙⲟϥ ⲉⲩⲛⲁϣⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲧⲟⲩϩⲟ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ⲫⲏ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲟⲩⲟⲛⲧⲁϥ ⲉⲩ⳿ⲉϯ ⲛⲁϥ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲁϥ ⲟⲩⲟϩ ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛⲧⲟⲧϥ ϣⲁⲩⲟⲗϥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉϥ⳿ϫⲣⲟϫ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲛⲉⲙ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲡⲓ⳿ϫⲣⲟϫ ⲑⲏⲛⲓ ⲟⲩⲟϩ ϣⲁϥϣⲓ⳿ⲏ ϩⲱⲥ ⳿ⲛ⳿ϥ⳿ⲉⲙⲓ ⲁⲛ ⳿ⲛⲑⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ϣⲁⲣⲉ ⲡⲓⲕⲁϩⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ϯⲟⲩⲧⲁϩ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲟⲩⲥⲓⲙ ⳿ⲓⲧⲁ ⲟⲩϧⲉⲙⲥ ⳿ⲓⲧⲁ ϣⲁϥⲙⲟϩ ⳿ⲛϫⲉ ⲫⲏⲉⲧ ϧⲉⲛ ⲡⲓϧⲉⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲫⲟϩ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲧⲁϩ ⲥⲁⲧⲟⲧϥ ϣⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲡⲓⲟⲥϧ ϫⲉ ⲟⲩⲏⲓ ⲅⲁⲣ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲱⲥϧ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛⲛⲁⲧⲉⲛⲑⲱⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲟⲩ ⲓⲉ ⲁⲛⲛⲁⲭⲁⲥ ϧⲉⲛ ⲁϣ ⳿ⲙⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ⲁⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲛⲁⲫⲣⲓ ⳿ⲛϣⲉⲗⲧⲁⲙ ⲑⲏ⳿ⲉⲧⲉ ⲁⲩϣⲁⲛⲥⲁⲧⲥ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⳿ⲉⲟⲩⲕⲟⲩϫⲓ ⲧⲉ ⳿ⲉⲛⲓ⳿ϫⲣⲟϫ ⲧⲏⲣⲟⲩ ⲛⲏⲉⲧ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲟⲩⲥⲁⲧⲥ ϣⲁⲥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⲟⲩⲟϩ ϣⲁⲥϣⲱⲡⲓ ⲉⲥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲛⲓⲟⲩ⳿ⲟϯ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ϣⲁⲥ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲛⲓϣϯ ⳿ⲛϫⲁⲗ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩϫⲉⲙϫⲟⲙ ⳿ⲛϫⲉ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⳿ⲉⲟⲩⲱϩ ϧⲁ ⲧⲉⲥϧⲏⲓⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲡⲁⲣⲁⲃⲟⲗⲏ ⲡⲁⲓⲣⲏϯ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲡⲉ ⳿ⲙⲡⲓⲥⲁϫⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲛⲁⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ⲟⲩⲟϩ ⲭⲱⲣⲓⲥ ⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲁⲛ ⲡⲉ ⲥⲁ⳿ⲡⲥⲁ ⲇⲉ ⲛⲁϥⲃⲱⲗ ⳿ⲙ⳿ⲡⲧⲏⲣϥ ⳿⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ϣⲱⲡⲓ ϫⲉ ⲙⲁⲣⲉⲛⲥⲓⲛⲓ ⳿ⲉⲙⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲭⲁ ⲡⲓⲙⲏϣ ⳿ⲛⲥⲱⲟⲩ ⲁⲩⲟⲗϥ ⲛⲉⲙⲱⲟⲩ ϩⲱϥ ϩⲓ ⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲛⲁⲣⲉ ϩⲁⲛⲕⲉ⳿ⲉϫⲏⲟⲩ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ⲟⲩⲟϩ ⳿ⲁ ⲟⲩⲛⲓϣϯ ⳿ⲛⲑⲏⲟⲩ ϣⲱⲡⲓ ⲟⲩⲟϩ ⲛⲓϫⲟⲗ ⲛⲁⲩϩⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲡⲓϫⲟⲓ ϩⲱⲥⲧⲉ ϩⲏⲇⲏ ⳿ⲛⲧⲉϥⲙⲟϩ ⳿ⲛϫⲉ ⲡⲓϫⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥⲉⲛⲕⲟⲧ ϩⲓⲫⲁϩⲟⲩ ϩⲓϫⲉⲛ ⲡⲓ⳿ϣϣⲟⲧ ⲟⲩⲟϩ ⲁⲩⲛⲉϩⲥⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲥⲉⲣⲙⲉⲗⲓⲛ ⲛⲁⲕ ⲁⲛ ϫⲉ ⲧⲉⲛⲛⲁⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓⲑⲏⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙ⳿ⲫⲓⲟⲙ ϫⲉ ⲭⲁⲣⲱⲕ ⲟⲩⲟϩ ⲑⲱⲙ ⳿ⲛⲣⲱⲕ ⲟⲩⲟϩ ⲁϥⲕⲏⲛ ⳿ⲛϫⲉ ⲡⲓⲑⲏⲟⲩ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛϫⲁⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲉⲣϩⲟϯ ⳿ⲙⲡⲁⲧⲉ ⲛⲁϩϯ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲛⲓⲙ ϩⲁⲣⲁ ⲡⲉ ⲫⲁⲓ ϫⲉ ⲛⲓⲑⲏⲟⲩ ⲛⲉⲙ ⳿ⲫⲓⲟⲙ ⲥⲉⲥⲱⲧⲉⲙ ⲛⲁϥ ");
INSERT INTO copcnt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲙⲏⲣ ⳿ⲉ⳿ⲫⲓⲟⲙ ⳿ⲉ⳿ⲧⲭⲱⲣⲁ ⳿ⲛⲧⲉ ⲛⲓⲄⲉⲣⲅⲉⲥⲉⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓϫⲟⲓ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⲉϥϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ⲫⲏ ⳿ⲉⲛⲁⲣⲉ ⲡⲉϥⲙⲁ⳿ⲛϣⲱⲡⲓ ϣⲟⲡ ϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲟⲩⲇⲉ ϧⲉⲛ ⲛⲓⲕⲉϩⲁⲗⲩⲥⲓⲥ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛ⳿ϩⲗⲓ ⲡⲉ ⳿ⲉⲥⲟⲛϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ⲉⲑⲃⲉ ϫⲉ ⲛⲉ ⲁⲩⲥⲟⲛϩϥ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⳿ⲛϩⲁⲛⲡⲉⲇⲏⲥ ⲛⲉⲙ ϩⲁⲛϩⲁⲗⲩⲥⲓⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲥⲱⲗⲡ ⳿ⲛⲛⲓϩⲁⲗⲩⲥⲓⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⳿ⲛⲥⲉϧⲟⲙϧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲡⲉⲇⲏⲥ ⲟⲩⲟϩ ⲛⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⲉⲣⲇⲁⲙⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ⲟⲩⲟϩ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲛⲉⲙ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉϥⲭⲏ ϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ϧⲉⲛ ⲛⲓⲧⲱⲟⲩ ⲡⲉ ⲉϥⲱϣ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥϣⲱⲧ ⳿ⲙⲙⲟϥ ⳿ⲛϩⲁⲛ⳿ⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ⲓⲥϫⲉⲛ ϩⲓ ⳿ⲫⲟⲩⲉⲓ ⲁϥϭⲟϫⲓ ⲟⲩⲟϩ ⲁϥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁϧⲟⲕ ⲛⲉⲙⲏⲓ ϩⲱⲕ Ⲓⲏ̅ⲥ̅ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪϯ ⲉⲧϭⲟⲥⲓ ϯⲧⲁⲣⲕⲟ ⳿ⲙⲙⲟⲕ ⳿ⲙⲪϯ ⳿ⲙⲡⲉⲣϯϭⲗⲁⲕ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ⲛⲁϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ϧⲉⲛ ⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ⲟⲩⲟϩ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲡⲉⲕⲣⲁⲛ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲗⲉⲅⲉⲱⲛ ⲡⲉ ⲡⲁⲣⲁⲛ ϫⲉ ⲧⲉⲛⲉⲣ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ⲟⲩⲟϩ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϩⲁⲛⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲟⲩⲟⲣⲡ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲭⲱⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲁⲅⲉⲗⲏ ⲇⲉ ⳿ⲛⲣⲓⲣ ⲉⲥⲟϣ ⳿ⲙⲙⲁⲩ ⲡⲉ ⲉⲥⲙⲟⲛⲓ ϧⲁⲧⲉⲛ ⲡⲓⲧⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲟⲣⲡⲧⲉⲛ ⳿ⲉⲛ⳿ⲓⲣⲓⲣ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲣⲧⲟⲛ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓ⳿ⲉϣⲁⲩ ⲟⲩⲟϩ ⲁⲥϩⲉⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛϫⲉ ϯ⳿ⲁⲅⲉⲗⲏ ϧⲁⲧⲉⲛ ⲡⲓϫⲁϫⲣⲓⲙ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲉⲩⲉⲣ ϣⲟ ⲃ̅ ⲟⲩⲟϩ ⲛⲁⲩⲱϫϩ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲛⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲩⲫⲱⲧ ⲟⲩⲟϩ ⲁⲩϫⲟⲥ ϧⲉⲛ ϯⲃⲁⲕⲓ ⲛⲉⲙ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲛⲁⲩ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲏ⳿ⲉⲧⲁϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲛⲁⲩ ⳿ⲉⲫⲏ⳿ⲉⲛⲁⲣⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲉϥϩⲉⲙⲥⲓ ⳿ⲉⲣⲉ ⲛⲉϥ⳿ϩⲃⲱⲥ ⲧⲟⲓ ϩⲓⲱⲧϥ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲡⲉϥϩⲏⲧ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ⲟⲩⲟϩ ⲁⲩⲥⲁϫⲓ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲛⲁⲩ ϫⲉ ⳿ⲉⲧⲁⲥϣⲱⲡⲓ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⳿ⲙⲫⲏ⳿ⲉⲛⲁⲣⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲛⲉⲙ ⲉⲑⲃⲉ ⲛ⳿ⲓⲣⲓⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϯϩⲟ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲛⲧⲉϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩⲑⲟϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ⲟⲩⲟϩ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲛⲇⲉⲙⲱⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲟϩⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲭⲁϥ ⲁⲗⲗⲁ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉⲕⲏⲓ ϩⲁ ⲛⲏ⳿ⲉⲧⲉⲛⲟⲩⲕ ⲟⲩⲟϩ ⲙⲁⲧⲁⲙⲱⲟⲩ ⳿ⲉⲛⲏ⳿ⲉⲧⲁ Ⲡ⳪ ⲁⲓⲧⲟⲩ ⲛⲁⲕ ⲟⲩⲟϩ ⲁϥⲛⲁⲓ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ⲟⲩⲟϩ ⲁϥϩⲱⲗ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲱⲓϣ ϧⲉⲛ ϯⲙⲏϯ ⳿ⲙⲃⲁⲕⲓ ⳿ⲙⲡⲉⲧⲁϥⲁⲓϥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲧⲏⲣⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⲟⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲙⲏⲣ ϧⲉⲛ ⲡⲓϫⲟⲓ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ⲡⲉ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲓⲁⲓⲣⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁϥϩⲓⲧϥ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ⲟⲩⲟϩ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϩⲁⲛⲙⲏϣ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲁϣⲉⲣⲓ ⲁⲥϧⲱⲛⲧ ⳿ⲉ⳿ⲫⲙⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲛⲧⲉⲕⲭⲁ ⲧⲉⲕϫⲓϫ ⳿ⲉϫⲱⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥⲛⲟϩⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⲟⲩⲟϩ ⲛⲁⲩϩⲟϫϩⲉϫ ⳿ⲙⲙⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ⲟⲩⲟϩ ⲓⲥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲁⲥⲉⲣ ⲓ̅ⲃ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲥⲛⲟϥ ϧⲁⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ⲟⲩⲟϩ ⲁⲥϭⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛⲙⲏϣ ⳿ⲛⲥⲏⲓⲛⲓ ⲟⲩⲟϩ ⲁⲥϭⲉ ⲛⲉⲧⲉⲛⲧⲁⲥ ⲛⲓⲃⲉⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲥϫⲉⲙϩⲏⲟⲩ ⳿ⲛ⳿ϩⲗⲓ ⲁⲗⲗⲁ ⲙⲁⲗⲗⲟⲛ ⲛⲁⲥ⳿ⲧϩⲟ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","⳿ⲉⲧⲁⲥⲥⲱⲧⲉⲙ ⲉⲑⲃⲉ Ⲓⲏ̅ⲥ̅ ⲁⲥ⳿ⲓ ϧⲉⲛ ⲡⲓⲙⲏϣ ϩⲓⲫⲁϩⲟⲩ ⲁⲥϭⲓⲛⲉⲙ ⲡⲉϥ⳿ϩⲃⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ⲛⲁⲥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲕⲁⲛ ⲁⲓϣⲁⲛϭⲓⲛⲉⲙ ⲡⲉϥ⳿ϩⲃⲱⲥ ϯⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲥ ⲁⲥϣⲱⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ϯⲙⲟⲩⲙⲓ ⳿ⲛⲧⲉ ⲡⲉⲥ⳿ⲥⲛⲟϥ ⲟⲩⲟϩ ⲁⲥ⳿ⲉⲙⲓ ϧⲉⲛ ⲡⲉⲥⲥⲱⲙⲁ ϫⲉ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲉⲃⲟⲗϩⲁ ϯⲙⲁⲥⲧⲓⲅⲝ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⳿ⲉϯϫⲟⲙ ⳿ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲁϥⲫⲟⲛϩϥ ⲇⲉ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϭⲓⲛⲉⲙ ⲛⲁ⳿ϩⲃⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲭⲛⲁⲩ ⳿ⲉⲡⲓⲙⲏϣ ⲉϥϩⲟϫϩⲉϫ ⳿ⲙⲙⲟⲕ ⲟⲩⲟϩ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϭⲓⲛⲉⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ⲟⲩⲟϩ ⲛⲁϥϫⲟⲩϣⲧ ⲡⲉ ⳿ⲉⲛⲁⲩ ⳿ⲉⲑⲏ⳿ⲉⲧⲁⲥⲉⲣ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ϯ⳿ⲥϩⲓⲙⲓ ⲇⲉ ⳿ⲉⲧⲁⲥⲉⲣϩⲟϯ ⲟⲩⲟϩ ⲁⲥ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲉⲥ⳿ⲉⲙⲓ ⳿ⲉⲫⲏ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲟⲥ ⲁⲥ⳿ⲓ ⲟⲩⲟϩ ⲁⲥϩⲓⲧⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲣⲁⲧϥ ⲟⲩⲟϩ ⲁⲥϫⲉ ϯⲙⲉⲑⲙⲏⲓ ⲧⲏⲣⲥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲧⲁϣⲉⲣⲓ ⲡⲉⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲓ ⲙⲁϣⲉⲛⲉ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ ⲟⲩⲟϩ ϣⲱⲡⲓ ⲉⲩⲟⲩϫⲁⲓ ⳿ⲉⲃⲟⲗϩⲁ ⲧⲉⲙⲁⲥⲧⲓⲅⲝ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","⳿ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ⲁⲩ⳿ⲓ ϩⲁ ⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁ ⲧⲉⲕϣⲉⲣⲓ ⲙⲟⲩ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲕϯϧⲓⲥⲓ ⳿ⲙⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲉⲧⲟⲩϫⲱ ⳿ⲙⲙⲟϥ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲙⲟⲛⲟⲛ ⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲭⲁ ⳿ϩⲗⲓ ⲛⲉⲙⲁϥ ⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲡⲥⲟⲛ ⳿ⲛⲒⲁⲕⲱⲃⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲟⲩⲟϩ ⲁⲩⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲩ⳿ϣⲑⲉⲣⲑⲱⲣ ⲟⲩⲟϩ ⲉⲩⲣⲓⲙⲓ ⲟⲩⲟϩ ⲉⲩ⳿ϣⲗⲏⲗⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲣⲑⲱⲣ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲣⲓⲙⲓ ⳿ⲙⲡⲉⲥⲙⲟⲩ ⳿ⲛϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲁⲗⲗⲁ ⲁⲥⲉⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ⲟⲩⲟϩ ⲛⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥϩⲓ ⳿ⲡⲧⲏⲣϥ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲱⲗⲓ ⲛⲉⲙⲁϥ ⳿ⲙ⳿ⲫⲓⲱⲧ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉⲥⲙⲁⲩ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ϯ⳿ⲁⲗⲟⲩ ⲭⲏ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛ⳿ⲧϫⲓϫ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲧⲁⲗⲓⲑⲁ ⲕⲟⲩⲙⲓ ⳿ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲉⲓϫⲉⲣⲟ ⲧⲱⲟⲩⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲥ ⲁⲥⲧⲱⲛⲥ ⳿ⲛϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲟⲩⲟϩ ⲁⲥⲙⲟϣⲓ ⲛⲁⲥϧⲉⲛ ⲓ̅ⲃ̅ ⲅⲁⲣ ⳿ⲛⲣⲟⲙⲡⲓ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲥⲁⲧⲟⲧⲟⲩ ⲡⲉ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϣⲫⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲛϩⲁⲛⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⳿ⲉⲫⲁⲓ ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⳿ⲛⲧⲟⲩϯⲟⲩⲱⲙ ⲛⲁⲥ ");
INSERT INTO copcnt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲉϥⲃⲁⲕⲓ ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲥⲁⲃⲃⲁⲧⲟⲛ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϯ⳿ⲥⲃⲱ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⲁⲩⲥⲱⲧⲉⲙ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲉⲧⲁ ⲫⲁⲓ ϫⲉⲙ ⲛⲁⲓ ⲑⲱⲛ ⲟⲩⲟϩ ⲟⲩ ⲧⲉ ⲧⲁⲓⲥⲟⲫⲓ⳿ⲁ ⳿ⲉⲧⲁⲩⲧⲏⲓⲥ ⳿ⲙⲫⲁⲓ ⲛⲉⲙ ⲛⲁⲓⲕⲉϫⲟⲙ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲉϥϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⲡⲓⲁⲙϣⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲘⲁⲣⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲡⲥⲟⲛ ⳿ⲛⲒⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲥⲏ ⲛⲉⲙ Ⲓⲟⲩⲇⲁⲥ ⲛⲉⲙ Ⲥⲓⲙⲱⲛ ⲟⲩⲟϩ ⲛⲉϥⲥⲱⲛⲓ ⲛⲁⲩϩⲁ⳿ⲙⲛⲁⲓ ϩⲁⲣⲟⲛ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϣⲏϣ ⳿ⲉⲃⲏⲗ ϧⲉⲛ ⲧⲉϥⲃⲁⲕⲓ ⲛⲉⲙ ⲧⲉϥⲥⲩⲅⲅⲉⲛⲓ⳿ⲁ ⲛⲉⲙ ⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲙⲙⲁⲩ ⳿ⲉ⳿⳿ⲓⲣⲓ ⲟⲩⲇⲉ ⲟⲩ⳿ⲓ ⳿ⲛϫⲟⲙ ⳿ⲉⲃⲏⲗ ⳿ⲉⲟⲩⲙⲏϣ ⳿ⲛⲣⲉϥϣⲱⲛⲓ ⳿ⲉⲁϥⲭⲁϫⲓϫ ϩⲓϫⲱⲟⲩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲑⲃⲉ ⲧⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ⲟⲩⲟϩ ⲛⲁϥⲙⲟⲩϣⲧ ⳿ⲛⲛⲓϯⲙⲓ ⳿ⲉⲧⲉ ⳿ⲙ⳿ⲡⲕⲱϯ ⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲓⲓ̅ⲃ̅ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲟⲩⲟⲣⲡⲟⲩ ⳿ⲛⲃ̅ ⲃ̅ ⲟⲩⲟϩ ⲁϥϯⲉⲣϣⲓϣⲓ ⲛⲱⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲗ ⳿ϩⲗⲓ ⲛⲉⲙⲱⲟⲩ ϩⲓ ⳿ⲫⲙⲱⲓⲧ ⳿ⲉⲃⲏⲗ ⳿ⲉⲟⲩ⳿ϣⲃⲱⲧ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲟⲩⲇⲉ ⲱⲓⲕ ⲟⲩⲇⲉ ⲡⲏⲣⲁ ⲟⲩⲇⲉ ϩⲟⲙⲧ ϧⲉⲛ ⲛⲉⲧⲉⲛⲙⲟϫϧ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ⲁⲗⲗⲁ ⳿ⲉⲣⲉ ϩⲁⲛⲥⲁⲛⲇⲁⲗⲓⲟⲛ ⲧⲟⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣϯ ⳿ϣⲑⲏⲛ ⲃ̅ϯ ϩⲓ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲏⲓ ⳿ⲙⲙⲟϥ ϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϣⲁⲧⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ⲟⲩⲟϩ ⲙⲁ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲛⲉϩ ⳿ⲡϣⲱⲓϣ ⲉⲧⲥⲁ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛⲛⲉⲧⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲧⲁ⳿ⲫⲙⲏⲓ ϫⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲙⲧⲟⲛ ⲛⲁϣⲱⲡⲓ ⳿ⲛⲤⲟⲇⲟⲙⲁ ⲛⲉⲙ Ⲅⲟⲙⲟⲣⲣⲁ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⳿ⲉϩⲟⲧⲉ ⳿ⲛⲧⲉ ϯⲃⲁⲕⲓ ⳿ⲉⲧⲉ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩϩⲓⲱⲓϣ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ⲟⲩⲟϩ ⲁⲩϩⲓ ⲟⲩⲙⲏϣ ⳿ⲛⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲉϥϣⲱⲛⲓ ⲛⲁⲩⲑⲱϩⲥ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲛⲉϩ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ⲟⲩⲟϩ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⳿ⲡⲟⲩⲣⲟ Ⲏ̇ⲣⲱⲇⲏⲥ ⲡⲉϥⲣⲁⲛ ⲅⲁⲣ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲓϫⲟⲙ ⲥⲉⲉⲣϩⲱⲃ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲡⲉ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲁⲓ ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲁⲣⲭⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲫⲏ ⳿ⲁⲛⲟⲕ ⳿ⲉⲧⲁⲓⲉⲗ ⲧⲉϥⲛⲁϩⲃⲓ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ⲏ̇ⲣⲱⲇⲏⲥ ⲅⲁⲣ ⲛⲉ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁϥⲥⲟⲛϩϥ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲉⲑⲃⲉ ̇̇Ⲏⲣⲱⲇⲓⲁⲥ ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ⲡⲉϥⲥⲟⲛ ϫⲉ ⲟⲩⲏⲓ ⲛⲉ ⲁϥϭⲓⲧⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ⲛⲁϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ ϫⲉ ⳿ⲥϣⲉ ⲛⲁⲕ ⲁⲛ ⳿ⲉϭⲓ ⳿ⲛ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ⲏ̇ⲣⲱⲇⲓⲁⲥ ⲇⲉ ⲛⲁⲥ⳿ⲙⲃⲟⲛ ⳿ⲉⲣⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲥⲟⲩⲱϣ ⳿ⲉϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲛⲁⲥ⳿ϣϫⲉⲙϫⲟⲙ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ⲏ̇ⲣⲱⲇⲏⲥ ⲅⲁⲣ ⲛⲁϥⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲉϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ϥⲟⲩⲁⲃ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁϥⲥⲱⲧⲉⲙ ⳿ⲉϩⲁⲛⲙⲏϣ ⳿ⲛⲧⲟⲧϥ ⲟⲩⲟϩ ⲛⲁϥϣⲟⲗϩ ⳿ⲛϩⲏⲧ ⲡⲉ ⲟⲩⲟϩ ϩⲏⲇⲉⲱⲥ ⲛⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁ ⲟⲩ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⳿ⲛⲉⲩⲕⲉⲣⲓ⳿ⲁ ϩⲟⲧⲉ ⳿ⲉⲧⲁ Ⲏ̇ⲣⲱⲇⲏⲥ ϧⲉⲛ ⲡⲉϥ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲓⲥⲓ ⲑⲁⲙⲓ⳿ⲉ ⲟⲩⲇⲓⲡⲛⲟⲛ ⳿ⲉⲛⲉϥⲛⲓϣϯ ⲛⲉⲙ ⲛⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲛⲉⲙ ⲛⲓϩⲟⲩ⳿ⲁϯ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⳿ⲧϣⲉⲣⲓ ⳿ⲛⲎ̇ⲣⲱⲇⲓⲁⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥϭⲟⲥϫⲉⲥ ⲁⲥⲣⲁⲛⲁϥ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ ⲛⲉⲙ ⲛⲏⲉⲑⲣⲱⲧⲉⲃ ⲛⲉⲙⲁϥ ⲡⲉϫⲉ ⳿ⲡⲟⲩⲣⲟ ⲇⲉ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ϫⲉ ⳿ⲁⲣⲓ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟⲓ ⳿ⲙⲡⲉⲧⲉⲟⲩⲁϣϥ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲧⲏⲓϥ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ⲟⲩⲟϩ ⲁϥⲱⲣⲕ ⲛⲁⲥ ϫⲉ ⲫⲏ⳿ⲉⲧⲉⲣⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ϯⲛⲁϯ ⲛⲉ ϣⲁ ⳿ⲧⲫⲁϣⲓ ⳿ⲛⲧⲁⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁⲥ ⳿ⲛⲧⲉⲥⲙⲁⲩ ϫⲉ ⲟⲩ ⲡⲉ ϯⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲡⲉϫⲁⲥ ϫⲉ ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲟⲩ⳿ⲥⲡⲟⲩⲇⲏ ϩⲁ ⳿ⲡⲟⲩⲣⲟ ⲁⲥⲉⲣ⳿ⲉⲧⲓⲛ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲟⲩⲱϣ ϯⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕϯ ⲛⲏⲓ ⳿ⲛ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ϩⲓ ⲟⲩⲃⲓⲛⲁϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ⲟⲩⲟϩ ⳿ⲉⲧⲁ ⳿ⲡϩⲏⲧ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⳿ⲙⲕⲁϩ ⲉⲑⲃⲉ ⲛⲓⲁⲛⲁⲩϣ ⲛⲉⲙ ⲛⲏⲉⲑⲣⲱⲧⲉⲃ ⲛⲉⲙⲁϥ ⳿ⲙⲡⲉϥⲟⲩⲱϣ ⲉϥⲟϫⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛϫⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲟⲩ⳿ⲥⲡⲉⲕⲟⲩⲗⲁⲧⲱⲣ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲧⲉϥ⳿ⲓⲛⲓ ⳿ⲛⲧⲉϥ⳿ⲁⲫⲉ ϩⲓ ⲡⲓⲃⲓⲛⲁϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲉ ⳿ⲛϫⲉ ⲡⲓ⳿ⲥⲡⲉⲕⲟⲩⲗⲁⲧⲱⲣ ⲁϥ⳿ⲱⲗⲓ ⳿ⲛⲧⲉϥⲛⲁϩⲃⲓ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⲁϥ⳿ⲓⲛⲓ ⳿ⲛⲧⲉϥ⳿ⲁⲫⲉ ϩⲓ ⲡⲓⲃⲓⲛⲁϫ ⲟⲩⲟϩ ⲁϥⲧⲏⲓⲥ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ⲟⲩⲟϩ ⳿ⲁ ϯ⳿ⲁⲗⲟⲩ ⲉⲛⲥ ⳿ⲛⲧⲉⲥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩ⳿ⲓ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥⲥⲱⲙⲁ ⲟⲩⲟϩ ⲁⲩⲭⲁϥ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲟⲩ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ⲟⲩⲟϩ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲧⲁⲙⲟϥ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩⲁⲓϥ ⲛⲉⲙ ⲫⲏ⳿ⲉⲧⲁⲩϯ⳿ⲥⲃⲱ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲉⲟⲩⲙⲁ ⳿ⲛϣⲁϥⲉ ⲟⲩⲟϩ ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲛⲏ ⲅⲁⲣ ⲉⲑⲛⲏⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲁ ⲛⲁⲩⲟϣ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩϫⲉⲙ ⲉⲩⲕⲉⲣⲓ⳿ⲁ ⲁⲛ ⲡⲉ ⳿ⲉⲉⲣ⳿ⲡⲕⲉ ⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ⲟⲩⲟϩ ⲁⲩϣⲉⲛⲱⲟⲩ ϩⲓ ⲡⲓϫⲟⲓ ⳿ⲉⲟⲩⲙⲁ ⳿ⲛϣⲁϥⲉ ⲥⲁ⳿ⲡⲥⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ⲟⲩⲟϩ ⲁⲩⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲩϩⲏⲗ ⲟⲩⲟϩ ⲁⲩⲥⲟⲩ⳿ⲱⲛⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲟⲩⲟϩ ⲁⲩϭⲟϫⲓ ⳿ⲉⲙⲁⲩ ⳿ⲛⲣⲁⲧⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲃⲁⲕⲓ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲁⲩⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲙⲏϣ ⲉϥⲟϣ ⲟⲩⲟϩ ⲁϥϣⲉⲛϩⲏⲧ ϧⲁⲣⲱⲟⲩ ϫⲉ ⲛⲁⲩⲟⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⳿ⲛϩⲁⲛⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ⲟⲩⲟϩ ϩⲏⲇⲏ ⳿ⲉⲧⲁ ⲟⲩⲛⲓϣϯ ⳿ⲛⲟⲩⲛⲟⲩ ϣⲱⲡⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲙⲁ ⲟⲩϣⲁϥⲉ ⲡⲉ ⲟⲩⲟϩ ϩⲏⲇⲏ ϯⲟⲩⲛⲟⲩ ⲁⲥⲥⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ⲭⲁⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲛⲓⲓⲟϩⲓ ⲉⲧⲕⲱϯ ⲛⲉⲙ ⲛⲓϯⲙⲓ ⳿ⲛⲧⲟⲩϣⲱⲡ ⲛⲱⲟⲩ ⳿ⲙⲡⲉⲧⲟⲩⲛⲁⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲟⲓ ⲛⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲙⲁⲣⲟⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲧⲉⲛⲛⲁϣⲉⲛⲁⲛ ⳿ⲛⲧⲉⲛϣⲉⲡ ⲥ̅ ⳿ⲛⲥⲁⲑⲉⲣⲓ ⳿ⲛⲱⲓⲕ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛϯ ⲛⲱⲟⲩ ⳿ⲉⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲛⲱⲓⲕ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲁⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲉⲙⲓ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲉ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲧⲉⲃⲧ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲱⲟⲩ ⳿ⲛⲧⲟⲩⲣⲱⲧⲉⲃ ⲧⲏⲣⲟⲩ ⲥⲓⲙⲡⲟⲥⲓⲟⲛ ⲥⲓⲙⲡⲟⲥⲓⲟⲛ ϩⲓϫⲉⲛ ⲡⲓⲥⲓⲙ ⲉⲑⲟⲩⲉⲧⲟⲩⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ⲟⲩⲟϩ ⲁⲩⲣⲱⲧⲉⲃ ⲧⲏⲣⲟⲩ ⳿ⲙⲙⲁ ⲙⲁ ⲕⲁⲧⲁ ⲣ̅ ⲣ̅ ⲛⲉⲙ ⲕⲁⲧⲁ ⲛ̅ ⲛ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓ ⲉ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲡⲓⲧⲉⲃⲧ ⲃ̅ ⲁϥϫⲟⲩϣⲧ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲙⲟⲩ ⲟⲩⲟϩ ⲁϥⲫⲱϣ ⳿ⲛⲛⲓⲱⲓⲕ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲭⲱ ⲛⲁϩⲣⲁⲩ ⲛⲉⲙ ⲡⲓⲕⲉⲧⲉⲃⲧ ⲃ̅ ⲁϥⲫⲁϣⲟⲩ ⳿ⲉ⳿ϩⲣⲁⲩ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲙ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲁⲩⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ⲟⲩⲟϩ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙ ⲓ̅ⲃ̅ ⳿ⲛⲕⲟⲧ ⳿ⲛⲗⲁⲕϩ ⲉⲩⲙⲉϩ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲕⲉⲧⲉⲃⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲛⲁⲩⲟⲩⲱⲙ ⳿ⲛⲛⲓⲱⲓⲕ ⲛⲁⲩⲉⲣ ⲉ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲉⲣ⳿ⲁⲛⲁⲅⲕⲁⲍⲓⲛ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲥⲱⲕ ϧⲁϫⲱϥ ⳿ⲉⲙⲏⲣ ⳿ⲉⲂⲏⲑⲥⲁⲓⲇⲁ ϣⲁⲧⲉϥⲭⲁ ⲡⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣ⳿ⲁⲡⲟⲧⲁⲍⲉⲥⲑⲉ ⲛⲱⲟⲩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲡⲓⲧⲱⲟⲩ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ⲟⲩⲟϩ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ϣⲱⲡⲓ ⲛⲁⲣⲉ ⲡⲓϫⲟⲓ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲙ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲁϥⲭⲏ ϩⲓ ⲡⲓ⳿ⲭⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲩ⳿ⲧϩⲉⲙⲕⲏⲟⲩⲧ ϧⲉⲛ ⲡⲓϫⲓⲛⲥⲱⲕ ⲛⲁⲣⲉ ⲡⲓⲑⲏⲟⲩ ⲅⲁⲣ ϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲩ ⲡⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ϯⲙⲁϩ ⲇ̅ ⳿ⲛⲟⲩⲉⲣϣⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲁϥ⳿ⲓ ϩⲁⲣⲱⲟⲩ ⲉϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲛⲁϥⲟⲩⲱϣ ⳿ⲉⲥⲉⲛⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲉϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ⲟⲩϩⲟⲣⲧϥ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ⲛⲉ ⲁⲩⲛⲁⲩ ⲅⲁⲣ ⳿ⲉⲣⲟϥ ⲧⲏⲣⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲑⲟϥ ⲇⲉ ⲥⲁⲧⲟⲧϥ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ⲟⲩⲟϩ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ϩⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁϥϩⲉⲣⲓ ⳿ⲛϫⲉ ⲡⲓⲑⲏⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲧⲱⲙⲧ ⳿ⲉⲙⲁϣⲱ ⲡⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲟⲩⲕⲁϯ ⳿ⲉϫⲉⲛ ⲛⲓⲱⲓⲕ ⲁⲗⲗⲁ ⲛⲁⲣⲉ ⲡⲟⲩϩⲏⲧ ⲑⲏⲙ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲉⲣϫⲓⲛⲓⲟⲣ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ ⲁⲩ⳿ⲓ ⳿ⲉⲄⲉⲛⲏⲍⲁⲣⲉⲑ ⲟⲩⲟϩ ⲁⲩⲙⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓϫⲟⲓ ⲁⲩⲥⲟⲩⲱⲛϥ ⲥⲁⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ⲁⲩϭⲟϫⲓ ϧⲉⲛ ϯⲭⲱⲣⲁ ⲧⲏⲣⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϥⲁⲓ ⳿ⲛⲛⲏⲉⲧϩⲉⲙⲕⲏⲟⲩⲧ ϩⲓ ϩⲁⲛϭⲗⲟϫ ⳿ⲉⲡⲓⲙⲁ ⳿ⲉⲧⲉ ϣⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⳿ϥ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲉϣⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲉⲛⲓϯⲙⲓ ⲓⲉ ⲛⲓⲃⲁⲕⲓ ⲓⲉ ⲛⲓⲓⲟϩⲓ ⲛⲁⲩⲭⲱ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ϩⲓ ⲛⲓ⳿ⲁⲅⲟⲣⲁ ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⲕⲁⲛ ⳿ⲛⲧⲟⲩϭⲓⲛⲉⲙ ⳿ⲡ⳿ϣⲧⲁϯ ⳿ⲛⲧⲉ ⲛⲉϥ⳿ϩⲃⲱⲥ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉϣⲁⲩϭⲓⲛⲉⲙⲁϥ ϣⲁⲩⲟⲩϫⲁⲓ ");
INSERT INTO copcnt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ⲟⲩⲟϩ ⲁⲩⲑⲱⲟⲩϯ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲥⲁϧ ⳿ⲉⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉϩⲁⲛⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲥⲉⲟⲩⲱⲙ ⳿ⲛⲛⲓⲱⲓⲕ ⳿ⲉⲣⲉ ⲛⲟⲩϫⲓϫ ⲑⲱⲗⲉⲃ ⳿ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⳿ⲛⲁⲧⲓⲁ ⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲅⲁⲣ ⲛⲉⲙ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲙⲡⲁⲩⲟⲩⲱⲙ ⲁⲩ⳿ϣⲧⲉⲙⲓⲁ ⲧⲟⲧⲟⲩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⲉⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛϯⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⲁⲩ⳿ϣⲧⲉⲙⲟⲙⲥⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲁⲅⲟⲣⲁ ⳿ⲙⲡⲁⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛⲕⲉⲙⲏϣ ⳿ⲉⲁⲩϭⲓⲧⲟⲩ ⲉⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲱⲟⲩ ϩⲁⲛⲱⲙⲥ ⳿ⲛⲧⲉ ϩⲁⲛ⳿ⲁⲫⲟⲧ ⲛⲉⲙ ϩⲁⲛⲝⲉⲥⲧⲏⲥ ⲛⲉⲙ ϩⲁⲛⲭⲁⲗⲕⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲥⲉⲙⲟϣⲓ ⲁⲛ ⳿ⲛϫⲉ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲕⲁⲧⲁ ϯⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲗⲗⲁ ϧⲉⲛ ϩⲁⲛϫⲓϫ ⲉⲩⲑⲱⲗⲉⲃ ⲥⲉⲟⲩⲱⲙ ⳿ⲙⲡⲓⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲕⲁⲗⲱⲥ ⲁϥⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ Ⲏ̇ⲥⲁ⳿ⲏⲁⲥ ϧⲁ ⲛⲓϣⲟⲃⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲁⲓⲗⲁⲟⲥ ⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙⲙⲟⲓ ϧⲉⲛ ⲛⲟⲩ⳿ⲥⲫⲟⲧⲟⲩ ⲡⲟⲩϩⲏⲧ ⲇⲉ ⳿ϥⲟⲩ⳿ⲏⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ⲉⲩⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲙⲟⲓ ⳿ⲉ⳿ⲫⲗⲏⲟⲩ ⲉⲩϯ⳿ⲥⲃⲱ ⳿ⲛϩⲁⲛ⳿ⲥⲃⲱ ⳿ⲛϩⲟⲛϩⲉⲛ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","⳿ⲉⲁⲧⲉⲧⲉⲛⲭⲁ ϯⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⲧⲉⲧⲉⲛ⳿ⲁⲙⲟⲛⲓ ⳿ⲛϯⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ϩⲁⲛⲱⲙⲥ ⳿ⲛⲧⲉ ϩⲁⲛ⳿ⲁⲫⲟϯ ⲛⲉⲙ ϩⲁⲛⲝⲉⲥⲧⲏⲥ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⲉϥⲟϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲕⲁⲗⲱⲥ ⲧⲉⲧⲉⲛⲉⲣ⳿ⲁⲑⲉⲧⲓⲛ ⳿ⲛϯⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲉ Ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲁⲣⲉϩ ⳿ⲉⲛⲉⲧⲉⲛⲡⲁⲣⲁⲇⲟⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ⲙⲱ⳿ⲩⲥⲏⲥ ⲅⲁⲣ ⲁϥϫⲟⲥ ϫⲉ ⲙⲁⲧⲁⲓ⳿ⲉ ⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⲧⲉⲕⲙⲁⲩ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲥⲁϫⲓ ⲉϥϩⲱⲟⲩ ⳿ⲛⲥⲁ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲙⲁⲣⲉϥⲙⲟⲩ ⳿ⲛⲟⲩⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩⲣⲱⲙⲓ ϫⲟⲥ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ϫⲉ ⲕⲟⲣⲃⲁⲛ ⳿ⲉⲧⲉ ⲟⲩⲧⲁⲓ⳿ⲟ ⲡⲉ ⲁⲕϣⲁⲛϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","⳿ⲛⲧⲉⲧⲉⲛⲭⲱ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲉⲉⲣ ⳿ϩⲗⲓ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲓⲉ ⲧⲉϥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","⳿ⲉⲣⲉⲧⲉⲛⲕⲱⲣϥ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ϧⲉⲛ ⲧⲉⲧⲉⲛⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⲑⲏ⳿ⲉⲧⲁⲣⲉⲧⲉⲛⲧⲏⲓⲥ ⲟⲩⲟϩ ϩⲁⲛⲙⲏϣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲩ⳿ⲟⲛⲓ ⳿ⲛⲛⲁⲓ ⲧⲉⲧⲉⲛⲣⲁ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⲟⲛ ⳿ⲉⲡⲓⲙⲏϣ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲱⲧⲉⲙ ϫⲉ ⳿ⲉⲣⲟⲓ ⲟⲩⲟϩ ⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲉϥⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱϥ ⳿ⲉⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲟϥϥ ⲁⲗⲗⲁ ⲛⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲛⲏⲉⲧⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ⲟⲩⲟϩ ϩⲟⲧⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓⲙⲏϣ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉϯⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲁⲧⲕⲁϯ ϩⲱⲧⲉⲛ ⳿ⲙⲡⲉⲧⲉⲛⲕⲁϯ ϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲁⲃⲟⲗ ⲉⲑⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲥⲟϥϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ϫⲉ ⲥⲉⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥϩⲏⲧ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲉⲧⲉϥⲛⲉϫⲓ ⲟⲩⲟϩ ϣⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲛⲓⲙⲁⲛϩⲉⲙⲥⲓ ⲉϥⲧⲟⲩⲃⲟ ⳿ⲛⲛⲓ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲛⲑⲟϥ ⲉⲧⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","⳿ⲉⲃⲟⲗ ⲅⲁⲣ ⲥⲁϧⲟⲩⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓϩⲏⲧ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ϣⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲙⲟⲕⲙⲉⲕ ⲉⲧϩⲱⲟⲩ ⲛⲓⲡⲟⲣⲛⲓ⳿ⲁ ⲛⲓϭⲓⲟⲩ⳿ⲓ ⲛⲓϧⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ⲛⲓⲙⲉⲧⲛⲱⲓⲕ ⲛⲓⲙⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ⲛⲓⲙⲉⲧⲡⲉⲧϩⲱⲟⲩ ⲛⲓⲙⲉⲧⲇⲟⲗⲟⲥ ⲛⲓⲥⲱϥ ⲛⲓⲃⲁⲗ ⲉⲧϩⲱⲟⲩ ⲛⲓϫⲉⲟⲩ⳿ⲁ ⲟⲩϭⲓⲥⲓ ⳿ⲛϩⲏⲧ ⲟⲩⲙⲉⲧⲁⲧⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲩϩⲱⲟⲩ ⲉⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⲥⲁϧⲟⲩⲛ ⲟⲩⲟϩ ⲥⲉⲥⲱϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ Ⲧ̇ⲥⲓⲇⲱⲛ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲏⲓ ⲛⲁϥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲭⲟⲡϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ⲁⲗⲗⲁ ⲥⲁⲧⲟⲧⲥ ⲁⲥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲉⲑⲃⲏⲧϥ ⲑⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲉⲙ ⲧⲉⲥϣⲉⲣⲓ ⳿ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲁⲥϩⲓⲧⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁ ⲛⲉϥϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ϯ⳿ⲥϩⲓⲙⲓ ⲇⲉ ⲛⲉ Ⲟⲩⲉⲓⲛⲓⲛ ⲧⲉ ⳿ⲛⲧⲉ Ⲧ̇ⲥⲩⲣⲓ⳿ⲁ ⲡⲉⲥⲅⲉⲛⲟⲥ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲪⲟⲓⲛⲓⲕⲏ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲥϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϩⲓ ⲡⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲉⲥϣⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲥ ϫⲉ ⲭⲁⲥ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲟⲩⲥⲓ ⳿ⲛϫⲉ ⲛⲓϣⲏⲣⲓ ϫⲉ ⲟⲩⲏⲓ ⲅⲁⲣ ⲛⲁⲛⲉⲥ ⲁⲛ ⳿ⲉⲉⲗ ⳿ⲡⲱⲓⲕ ⳿ⲛⲛⲓϣⲏⲣⲓ ⳿ⲉⲧⲏⲓϥ ⳿ⲛⲛⲓⲟⲩϩⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","⳿ⲛⲑⲟⲥ ⲇⲉ ⲁⲥⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⲥⲉ Ⲡⲁ⳪ ⲛⲓⲕⲉⲟⲩϩⲱⲣ ⲥⲉⲟⲩⲱⲙ ⲥⲁ ⳿ϧⲣⲏⲓ ⳿ⲛϯ⳿ⲧⲣⲁⲛⲉⲍⲁ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲗⲉϥⲗⲓϥⲓ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲉⲑⲃⲉ ⲡⲁⲓⲥⲁϫⲓ ⲙⲁϣⲉⲛⲉ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗϩⲓ ⲧⲉϣⲉⲣⲓ ⳿ⲛϫⲉ ⲡⲓⲇⲉⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥϣⲉⲛⲁⲥ ⳿ⲉⲡⲉⲥⲏⲓ ⲁⲥϫⲉⲙ ϯ⳿ⲁⲗⲟⲩ ϩⲓϫⲉⲛ ⲡⲓϭⲗⲟϫ ⲟⲩⲟϩ ⲡⲓⲇⲉⲙⲱⲛ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲑⲟϣ ⳿ⲛⲧⲉ Ⲧⲩⲣⲟⲥ ⲁϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⳿Ⲧ̇ⲥⲓⲇⲱⲛ ⳿ⲉ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲧⲉ ⲛⲓⲑⲟϣ ⳿ⲛⲧⲉ ϯⲙⲏϯ ⳿ⲙⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲕⲟⲩⲣ ⳿ⲛⲉⲃⲟ ⲟⲩⲟϩ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲭⲁ ϫⲓϫ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ⲟⲩⲟϩ ⲁϥⲟⲗϥ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓⲙⲏϣ ⲁϥϩⲓ ⲛⲉϥⲧⲏⲃ ⳿ⲉϧⲟⲩⲛ ⳿⳿ⲉⲛⲉϥⲙⲁϣϫ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓⲑⲁϥ ⲁϥϭⲓⲛⲉⲙ ⲡⲉϥⲗⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲁϥϥⲓ⳿ⲁϩⲟⲙ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲉⲫⲫⲁⲑⲁ ⳿ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⳿ⲁⲟⲩⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲛ ⳿ⲛϫⲉ ⲛⲉϥⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲁϥϯⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓ⳿ⲥⲛⲁϩ ⳿ⲛⲧⲉ ⲡⲉϥⲗⲁⲥ ⲟⲩⲟϩ ⲛⲁϥⲥⲁϫⲓ ⲡⲉ ⲉϥⲥⲟⲩⲧⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ϩⲱⲥⲧⲉ ⳿ⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲙⲁⲗⲗⲟⲛ ⲛⲁⲩϩⲓⲱⲓϣ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ⲟⲩⲟϩ ⳿ⲛϩⲟⲩ⳿ⲟ ⳿ⲛϩⲟⲩ⳿ⲟ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲕⲁⲗⲱⲥ ⲁϥⲁⲓⲧⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥ⳿ⲑⲣⲉ ⲛⲓⲕⲟⲩⲣ ⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲛⲓⲁⲧⲥⲁϫⲓ ⳿ⲛⲧⲟⲩⲥⲁϫⲓ ");
INSERT INTO copcnt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲛ ⲉϥϣⲟⲡ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲡⲉⲧⲟⲩⲛⲁⲟⲩⲟⲙϥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ϫⲉ ϯϣⲉⲛϩⲏⲧ ϧⲁ ⲡⲁⲓⲙⲏϣ ϫⲉ ⲓⲥ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲥⲉ⳿ⲟϩⲓ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲡⲉⲧⲟⲩⲛⲁⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⲁⲓϣⲁⲛⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲟⲩⲏⲓ ⳿ⲛⲁⲑⲟⲩⲱⲙ ⲥⲉⲛⲁⲃⲱⲗ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲟⲩⲟⲛ ⳿ⲛϧⲏⲧⲟⲩ ⲛⲁⲩϩⲓⲫⲟⲩⲉⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲛⲓⲙ ⳿ⲉⲃⲟⲗⲑⲱⲛ ϩⲁ⳿ⲙⲛⲁⲓ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⲉⲑⲣⲉ ⲛⲁⲓ ⲥⲓ ⳿ⲛⲱⲓⲕ ϩⲓ ⳿ⲡϣⲁϥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ⲟⲩⲟϩ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲛⲱⲓⲕ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲍ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲓⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲣⲱⲧⲉⲃ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓ ⲍ̅ ⳿ⲛⲱⲓⲕ ⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲁϥⲫⲁϣⲟⲩ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲭⲱ ⲛⲁϩⲣⲁⲩ ⲟⲩⲟϩ ⲁⲩⲭⲱ ⲛⲁϩⲣⲉⲛ ⲡⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲕⲉⲕⲟⲩϫⲓ ⳿ⲛⲧⲉⲃⲧ ⳿ⲛⲧⲟⲧⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁϥϫⲟⲥ ⲉⲑⲣⲟⲩⲭⲱ ⳿ⲛⲛⲁⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲛⲁϩⲣⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲁⲩⲥⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲛⲛⲓϩⲟⲩ⳿ⲟ ⳿ⲛⲧⲉ ⲛⲓⲗⲁⲕϩ ⲍ̅ ⳿ⲙⲃⲓⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲛⲁⲩⲟⲩⲱⲙ ⲛⲁⲩ⳿⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛⲇ̅ ⳿ⲛϣⲟ ⲟⲩⲟϩ ⲁϥⲭⲁⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉ⳿ⲡϫⲟⲓ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁϥ⳿ⲓ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ Ⲇⲁⲗⲙⲁⲛⲟⲩⲑⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲕⲱϯ ⲛⲉⲙⲁϥ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲧⲟⲧϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϥⲓ⳿ⲁϩⲟⲙ ϧⲉⲛ ⲡⲉϥⲡ͞ⲛⲁ̅ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁϧⲟϥ ⲡⲁⲓϫⲱⲟⲩ ⳿ϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲛ ⲥⲉⲛⲁϯ ⳿ⲛⲟⲩⲙⲏⲓⲛⲓ ⳿ⲙⲡⲁⲓϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲁϥϣⲉ ⳿ⲉⲙⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ⲟⲩⲟϩ ⲁⲩⲉⲣ⳿ⲡⲱⲃϣ ⳿ⲉϭⲓⲱⲓⲕ ⲟⲩⲟϩ ⲛⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲧⲟⲧⲟⲩ ϩⲓ ⲡⲓϫⲟⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲟⲩⲱⲓⲕ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ⲟⲩⲟϩ ⲛⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲁⲩ ϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ⲟⲩⲟϩ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲱⲓⲕ ⳿ⲛⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ϫⲉ ⳿ⲙⲙⲟⲛ ⲱⲓⲕ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲙⲡⲁⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲕⲁϯ ⲁⲛ ⳿ϥⲑⲏⲙ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ⲟⲩⲟϩ ⲟⲩⲟⲛ ϩⲁⲛⲃⲁⲗ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲁⲛ ⲟⲩⲟⲛ ϩⲁⲛⲙⲁϣϫ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⲁⲛ ⳿ⲛⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙ⳿ⲫⲙⲉⲩⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","⳿ⲙⲡⲓ ⲉ̅ ⳿ⲛⲱⲓⲕ ⳿ⲉⲧⲁⲓⲫⲁϣⲟⲩ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓ ⲉ̅ ⳿ⲛϣⲟ ϫⲉ ⳿ⲁⲧⲉⲧⲉⲛⲉⲗ ⲟⲩⲏⲣ ⳿ⲛⲕⲟⲧ ⳿ⲛⲗⲁⲕϩ ⲉⲩⲙⲉϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲓ̅ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ⲟⲩⲟϩ ⲡⲓⲍ̅ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓⲇ̅ ⳿ⲛϣⲟ ϫⲉ ⲁⲧⲉⲧⲉⲛⲉⲗ ⲟⲩⲏⲣ ⳿ⲙⲃⲓⲣ ⲉⲩⲙⲉϩ ⳿ⲛⲗⲁⲕϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲍ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲡⲱⲥ ⲧⲉⲧⲉⲛⲕⲁϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲂⲏⲑⲥⲁⲓⲇⲁ ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ⲟⲩⲟϩ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛ⳿ⲧϫⲓϫ ⳿ⲙⲡⲓⲃⲉⲗⲗⲉ ⲁϥⲉⲛϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓϯⲙⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓⲑⲁϥ ϧⲉⲛ ⲛⲉϥⲃⲁⲗ ⲁϥⲭⲁ ⲛⲉϥϫⲓϫ ⳿ⲉϫⲱϥ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲛⲁⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲛⲁⲩ ⳿ⲉⲛⲓⲣⲱⲙⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ϣϣⲏⲛ ⲉⲩⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","⳿ⲓⲧⲁ ⲟⲛ ⲁϥⲭⲁ ⲛⲉϥϫⲓϫ ⳿ⲉϫⲉⲛ ⲛⲉϥⲃⲁⲗ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲟⲩϫⲁⲓ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲏⲣϥ ϧⲉⲛ ⲟⲩⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲉⲡⲉϥⲏⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϣⲉⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓϯⲙⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛϧⲏⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲛⲓϯⲙⲓ ⳿ⲛⲧⲉ Ⲕⲉⲥⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲫⲓⲗⲓⲡⲡⲉ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲛⲁϥϣⲓⲛⲓ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲣⲉ ⲛⲓⲣⲱⲙⲓ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϫⲟⲥ ⲛⲁϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ϣⲧⲉⲙϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ϭⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϣⲟϣϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ⲟⲩⲟϩ ⲛⲁϥⲥⲁϫⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓ⳿ⲁ ⲟⲩⲟϩ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲫⲟⲛϩϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲟⲓ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ϫⲉ ⳿ⲭⲙⲉⲩⲓ ⲁⲛ ⳿ⲉⲛⲁ Ⲫϯ ⲁⲗⲗⲁ ⳿ⲉⲛⲁ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲓⲙⲏϣ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉ⳿ⲓ ⲥⲁⲙⲉⲛϩⲏⲓ ⲙⲁⲣⲉϥϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ⲫⲏ ⲅⲁⲣ ⲉⲑⲛⲁⲟⲩⲱϣ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉϥ⳿ⲉⲧⲁⲕⲟⲥ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲧⲁⲕⲟ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉⲑⲃⲏⲧ ⲛⲉⲙ ⲉⲑⲃⲉ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲉϥ⳿ⲉⲛⲁϩⲙⲉⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ⲟⲩ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⲁϥϣⲁⲛϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ⳿ⲟⲥⲓ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ⲟⲩ ⲅⲁⲣ ⳿ⲉⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁⲧⲏⲓϥ ⳿ⲛ⳿ⲧϣⲉⲃⲓ⳿ⲱ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ⲫⲏ ⲅⲁⲣ ⲉⲑⲛⲁϣⲓⲡⲓ ⳿ⲉⲟⲩⲟⲛϩⲧ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲛⲁⲥⲁϫⲓ ϧⲉⲛ ⲡⲁⲓϫⲱⲟⲩ ⳿ⲛⲛⲱⲓⲕ ⲟⲩⲟϩ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ Ⲡ̇ϣⲏⲣⲓ ϩⲱϥ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲛⲁϯϣⲓⲡⲓ ⲛⲁϥ ϩⲟⲧⲁⲛ ⲁϥϣⲁⲛ⳿ⲓ ϧⲉⲛ ⳿ⲡ⳿ⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲉⲑⲟⲩⲁⲃ ");
INSERT INTO copcnt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ϧⲉⲛ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲥⲉⲛⲁϫⲉⲙϯⲡⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲁⲛ ϣⲁⲧⲟⲩⲛⲁⲩ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲁⲥ⳿ⲓ ϧⲉⲛ ⲟⲩϫⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲋ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥϭⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲟⲗⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲧⲱⲟⲩ ⲉϥϭⲟⲥⲓ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲁϥϣⲟⲃⲧϥ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ⲟⲩⲟϩ ⲛⲉϥ⳿ϩⲃⲱⲥ ⲁⲩϣⲱⲡⲓ ⲉⲩⲫⲟⲣⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲭⲓⲱⲛ ⲉⲩⲟⲩⲟⲃϣ ⳿ⲉⲙⲁϣⲱ ⲛⲏ⳿ⲉⲧⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲣⲁϧⲧ ⲉⲧϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲣⲉ ⲟⲩⲟⲛ ⲟⲩⲃⲁϣ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ⲟⲩⲟϩ ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲛⲉⲙ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲟϩ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ⲟⲩⲟϩ ⲧⲟⲧⲉ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲣⲁⲃⲃⲓ ⲛⲁⲛⲉⲥ ⲛⲁⲛ ⳿ⲛⲧⲉⲛϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲑⲁⲙⲓ⳿ⲟ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲥⲕⲩⲛⲏ ⲟⲩ⳿ⲓ ⲛⲁⲕ ⲟⲩ⳿ⲓ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲟϩ ⲟⲩ⳿ⲓ ⳿ⲛⲎ̇ⲗⲓⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ⲛⲁϥ⳿ⲉⲙⲓ ⲅⲁⲣ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉϥⲛⲁ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲙⲙⲟϥ ⲁⲩϣⲱⲡⲓ ⲅⲁⲣ ⲉⲩⲙⲉϩ ⳿ⲛϩⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩϭⲏⲡⲓ ⲉⲥⲉⲣϧⲏⲓⲃⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯϭⲏⲡⲓ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϫⲟⲩϣⲧ ⳿ⲉⲝⲁⲡⲓⲛⲁ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲒⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ⲟⲩⲟϩ ⲉⲩⲛⲏⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓⲧⲱⲟⲩ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲥⲁϫⲓ ϧⲁⲧⲉⲛ ⳿ϩⲗⲓ ⳿ⲙⲡⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲉⲃⲏⲗ ⳿ⲛⲧⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ⲟⲩⲟϩ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲩⲕⲱϯ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲟⲩ ⲡⲉ ⲡⲓⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲛⲓⲥⲁϧ ⲥⲉϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲉ Ⲏ̇ⲗⲓⲁⲥ ⳿ⲓ ⳿ⲛϣⲟⲣⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲙⲉⲛ ⳿ϥⲛⲁ⳿ⲓ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲁⲫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲡⲱⲥ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲉϫⲉⲛ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓ ⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϣⲟϣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ⲁⲗⲗⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲁϥ⳿ⲓ ⲟⲩⲟϩ ⲁⲩ⳿⳿ⲓⲣⲓ ⲛⲁϥ ⳿ⲙⲡⲉⲧⲟⲩⲟⲩⲁϣϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ϩⲁ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲙⲏϣ ⲉϥⲟϣ ⳿ⲙⲡⲟⲩⲕⲱϯ ⲟⲩⲟϩ ϩⲁⲛⲥⲁϧ ⲉⲩⲕⲱϯ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲩⲉⲣϩⲟϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϭⲟϫⲓ ⲛⲁⲩⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ⲟⲩⲟϩ ⲁϥϣⲉⲛⲟⲩ ϫⲉ ⳿ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩ ⳿ⲛⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲏϣ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲁⲓⲉⲛ ⲡⲁϣⲏⲣⲓ ϩⲁⲣⲟⲕ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲁⲧⲥⲁϫⲓ ⲛⲉⲙⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲉⲧⲉϥⲛⲁⲧⲁϩⲟϥ ⳿ⲙⲙⲁⲩ ϣⲁϥⲉⲛϥ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲣⲱϥ ϫⲉϣ⳿ⲥⲫⲏⲓϯ ⳿ⲉⲃⲟⲗ ⲉϥ⳿ϧⲣⲁϫⲣⲉϫ ⳿ⲛⲛⲉϥⲛⲁϫϩⲓ ⲟⲩⲟϩ ϣⲁϥϣⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲁⲓϫⲟⲥ ⳿ⲛⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲱ ⲡⲓϫⲱⲟⲩ ⳿ⲛⲁⲑⲛⲁϩϯ ϣⲁ ⳿ⲑⲛⲁⲩ ϯⲛⲁϣⲱⲡⲓ ⲛⲉⲙⲱⲧⲉⲛ ϣⲁ ⳿ⲑⲛⲁⲩ ϯⲛⲉⲁⲣ⳿ⲁⲛⲁⲭⲉⲥⲑⲉ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲁⲛⲓⲧϥ ϩⲁⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ⲟⲩⲟϩ ⲁⲩⲉⲛϥ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ϣⲧⲉⲣⲑⲱⲣϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲓ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲛⲁϥ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲡⲉ ⳿ⲉⲣⲉ ⲣⲱϥ ϫⲉϣ⳿ⲥⲫⲏⲓϯ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ⲟⲩⲟϩ ⲁϥϣⲉⲛ ⲡⲉϥⲓⲱⲧ ϫⲉ ⲓⲥ ⲟⲩⲏⲣ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲓⲥϫⲉⲛ ⳿ⲉⲧⲁ ⲫⲁⲓ ϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲓⲥϫⲉⲛ ⲧⲉϥⲙⲉⲧ⳿ⲁⲗⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ϣⲁϥϩⲓⲧϥ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⲛⲉⲙ ⲡⲓⲙⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲧⲁⲕⲟϥ ⲁⲗⲗⲁ ⲡⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲣⲟϥ ⳿ⲁⲣⲓⲃⲟ⳿ⲏⲑⲓⲛ ⳿ⲉⲣⲟⲛ ⳿ⲉⲁⲕϣⲉⲛϩⲏⲧ ⳿ⲉϫⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲟⲩ ⲡⲉ ϫⲉ ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲣⲟϥ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲙⲫⲏⲉⲑⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ⲥⲁⲧⲟⲧϥ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲫ̇ⲓⲱⲧ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ϧⲉⲛ ϩⲁⲛⲉⲣⲙⲱⲟⲩ⳿ⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲛⲁϩϯ Ⲡ⳪ ⳿ⲁⲣⲓⲃⲟ⳿ⲏⲑⲓⲛ ⳿ⲉⲧⲁⲙⲉⲧⲁⲑⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲡⲓⲙⲏϣ ϭⲟϫⲓ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲓⲁⲧⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲕⲟⲩⲣ ⳿ⲙⲡ͞ⲛⲁ̅ ⳿ⲁⲛⲟⲕ ⲡⲉ ϯⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲟⲕ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣϣⲉ ϫⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ϣⲧⲉⲣⲑⲱⲣϥ ⳿ⲛⲟⲩⲙⲏϣ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲣⲉϥⲙⲱⲟⲩⲧ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ ⲟⲩⲙⲏϣ ϫⲟⲥ ϫⲉ ⲁϥⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲉϥϫⲓϫ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲏⲓ ⳿ⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ϣⲉⲛϥ ⲥⲁ⳿ⲡⲥⲁ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲁⲛⲟⲛ ⳿ⲙⲡⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϩⲓⲧϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲁⲓⲅⲉⲛⲟⲥ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ϧⲉⲛ ⲟⲩⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲉⲙ ⲟⲩⲛⲏⲥⲧⲓ⳿ⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲛⲁϥⲥⲓⲛⲓ⳿ⲱⲟⲩ ⲡⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁϥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ⲛⲁϥϯ⳿ⲥⲃⲱ ⲅⲁⲣ ⲡⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲥⲉⲛⲁϧⲟⲑⲃⲉϥ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ϥⲛⲁⲧⲱⲛϥ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲟⲓ ⳿ⲛⲁⲧⲉⲙⲓ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣϩⲟϯ ⳿ⲉϣⲉⲛϥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲔⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⲟⲩ ⳿ⲉⲛⲁⲣⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ⳿ⲉⲣⲟϥ ϩⲓ ⳿ⲫⲙⲱⲓⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲭⲱ ⳿ⲛⲣⲱⲟⲩ ⲛⲁⲩⲥⲁϫⲓ ⲅⲁⲣ ⲡⲉ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϩⲓ ⳿ⲫⲙⲱⲓⲧ ϫⲉ ⲛⲓⲙ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ⲡⲓⲛⲓϣϯ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲙⲥⲓ ⲁϥⲙⲟⲩϯ ⳿ⲉⲡⲓ ⲓ̅ⲃ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲉⲣϩⲟⲩⲓⲧ ⲉϥ⳿ⲉⲉⲣϧⲁ⳿ⲉ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲇⲓ⳿ⲁⲕⲱⲛ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ⲁⲗⲟⲩ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ϫⲉ ⲫⲏⲉⲑⲛⲁϣⲉⲡ ⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲉⲡⲁⲣⲁⲛ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲉϥϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧϣⲱⲡ ⳿ⲙⲙⲟⲓ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲡⲉⲧⲉϥϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲁⲗⲗⲁ ⲁϥϣⲱⲡ ⳿ⲙⲫⲏ⳿ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲁⲛⲛⲁⲩ ⳿ⲉⲟⲩⲁⲓ ⲉϥϩⲓ ⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲟⲩⲟϩ ⲁⲛⲧⲁϩⲛⲟ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲛ⳿ϥⲟⲩⲉϩ ⳿ⲛⲥⲱⲛ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲅⲁⲣ ⲫⲏⲉⲑⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩϫⲟⲙ ⳿ⲉϫⲉⲛ ⲡⲁⲣⲁⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϫⲉⲙϫⲟⲙ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲉⲥⲁϫⲓ ⲉϥϩⲱⲟⲩ ϧⲁⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ⲫⲏ ⲅⲁⲣ ⳿ⲉⲧⲉ ⳿ⲛ⳿ϥϯⲟⲩⲃⲏⲛ ⲁⲛ ⲁϥϯ ⳿ⲉϫⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ⲫⲏ ⲅⲁⲣ ⲉⲑⲛⲁ⳿ⲧⲥⲉ ⲑⲏⲛⲟⲩ ⳿ⲛⲟⲩ⳿ⲁⲫⲟⲧ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲡⲁⲣⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁ Ⲡⲭ̅ⲥ̅ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉϥⲧⲁⲕⲟ ⳿ⲛϫⲉ ⲡⲉϥⲃⲉⲭⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲛⲁⲛⲉⲥ ⲛⲁϥ ⲙⲁⲗⲗⲟⲛ ⳿ⲉⲉϣ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲙⲙⲟⲩⲗⲟⲛ ⳿ⲉϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϩⲓⲧϥ ⳿ⲉ⳿ⲫⲓⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲧⲉⲕϫⲓϫ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟⲕ ϫⲟϫⲥ ⳿ⲉⲃⲟⲗ ⲛⲁⲛⲉⲥ ⲅⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲱⲛϧ ⲉⲕⲟⲓ ⳿ⲛϫⲁϭⲏ ⲓⲉ ⳿ⲉⲣⲉ ϫⲓϫ ⲃ̅ϯ ⳿ⲉⲣⲟⲕ ⳿ⲛⲧⲉⲕϣⲉ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⳿ⲛⲁⲧϭⲉⲛⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲡⲁⲣⲉ ⲡⲟⲩϥⲉⲛⲧ ⲙⲟⲩ ⲟⲩⲟϩ ⲡⲟⲩ⳿ⲭⲣⲱⲙ ⳿ⲙⲡⲁϥϭⲉⲛⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲧⲉⲕϭⲁⲗⲟϫ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟⲕ ϫⲟϫⲥ ϩⲓⲧⲥ ⳿ⲉⲃⲟⲗ ⲛⲁⲛⲉⲥ ⲛⲁⲕ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲱⲛϧ ⲉⲕⲟⲓ ⳿ⲛϭⲁⲗⲉ ⳿⳿ⲉϩⲟⲧⲉ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ϭⲁⲗⲟϫ ⳿ⲥⲛⲟⲩϯ ⳿ⲉⲣⲟⲕ ⳿ⲛⲥⲉϩⲓⲧⲕ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲡⲁⲣⲉ ⲡⲟⲩϥⲉⲛⲧ ⲙⲟⲩ ⲟⲩⲟϩ ⲡⲟⲩ⳿ⲭⲣⲱⲙ ⳿ⲙⲡⲁϥϭⲉⲛⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲡⲉⲕⲃⲁⲗ ⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟⲕ ⲫⲟⲣⲕϥ ⳿ⲉⲃⲟⲗ ⲛⲁⲛⲉⲥ ⲛⲁⲕ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲟⲩⲃⲁⲗ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲧⲉⲣⲟⲕ ⳿⳿ⲉϩⲟⲧⲉ ⳿ⲉⲟⲩⲟⲛ ⲃⲁⲗ ⲃ̅ ⳿ⲙⲙⲟⲕ ⳿ⲛⲥⲉϩⲓⲧⲕ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⳿ⲙⲡⲁⲣⲉ ⲡⲟⲩϥⲉⲛⲧ ⲙⲟⲩ ⲟⲩⲟϩ ⲡⲟⲩ⳿ⲭⲣⲱⲙ ⳿ⲙⲡⲁϥϭⲉⲛⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⳿ⲉϣⲁⲩⲙⲟⲗϩϥ ⳿ⲙⲡⲓ⳿ⲭⲣⲱⲙ ⲟⲩⲟϩ ϣⲱⲧ ⲛⲓⲃⲉⲛ ⳿ⲉϣⲁⲩⲙⲟⲩⲗϩϥ ϧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ⲛⲁⲛⲉ ⲡⲓ⳿ϩⲙⲟⲩ ⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲩ ⲉⲣⲁⲧ⳿ϩⲙⲟⲩ ⳿ⲉϣⲁⲩⲙⲟⲗϩϥ ϧⲉⲛ ⲟⲩ ⲙⲁⲣⲉ ⳿ϩⲙⲟⲩ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲣⲓϩⲓⲣⲏⲛⲏ ϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ⲉⲣⲏⲟⲩ . ");
INSERT INTO copcnt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉⲛⲓⲑⲟϣ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲒⲟⲣⲇⲁⲛⲏⲥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲟⲛ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏϣ ⲟⲩⲟϩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉ ⲧⲉϥⲥⲩⲛⲏⲑⲓⲁ ⲧⲉ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⲁⲛ ⳿ⲥϣⲉ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉϩⲓ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲡⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⳿ⲙⲙⲟϥ ϩⲓⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉ⳿ⲥϧⲉ ⲟⲩϫⲱⲙ ⳿ⲛ⳿ⲥϧⲓ ⳿ⲛⲟⲩⲉⲓ ⲟⲩⲟϩ ⳿ⲉⲭⲱ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲧⲉⲧⲉⲛⲙⲉⲧⲛⲁϣⲧϩⲏ ⲧ ⲁϥ⳿ⲥϧⲉ ⲧⲁⲓⲉⲛⲧⲟⲗⲏ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ⲓⲥϫⲉⲛ ⳿ⲧⲁⲣⲭⲏⲇⲉ ⳿ⲙⲡⲓⲥⲱⲛⲧ ⲟⲩϩⲱⲟⲩⲧ ⲛⲉⲙ ⳿ⲥϩⲓⲙⲓ ⲡⲉⲧⲁϥⲥⲟⲛⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲉⲣⲉ ⲡⲓⲣⲱⲙⲓ ⲭⲁ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲧⲟⲙϥ ⳿ⲉⲧⲉϥ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲙⲡⲃ̅ ⲉⲩⲥⲁⲣⲝ ⳿ⲛⲟⲩⲱⲧ ϩⲱⲥⲧⲉ ⲥⲉⲟⲓ ⳿ⲛ ⲁⲛ ⲁⲗⲗⲁ ⲟⲩⲥⲁⲣⲝ ⳿ⲛⲟⲩⲱⲧ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ⲫⲏ ⲟⲩⲛ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲙϥ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ⲫⲣⲱⲙⲓ ⲫⲟⲣϫϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓⲏⲓ ⲟⲛ ⳿ⲁ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϣⲉⲛϥ ⲉⲑⲃⲉ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲏⲉⲑⲛⲁⲭ ⳿ⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϭⲓ ⳿ⲛⲕⲉⲟⲩ⳿ⲓ ⳿ϥⲟⲓ ⳿ⲛⲛⲱⲓⲕ ⳿ⲉϫⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ϩⲱⲥ ⳿ⲛⲧⲉⲥⲭⲁ ⲡⲉⲥϩⲁⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥϭⲓ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⳿ⲥⲟⲓ ⳿ⲛⲛⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛϩⲁⲛ⳿ⲁⲗⲱⲟⲩ⳿Ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓ ⲛⲉⲙⲱⲟⲩ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲁⲩⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲁ ⲡⲉϥϩⲏⲧ ⳿ⲙⲕⲁϩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲭⲁ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿Ⲓ ⳿ⲛⲧⲟⲩ⳿ⲓ ϩⲁⲣⲟⲓ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿Ⲓ ϩⲁⲣⲟⲓ ⲑⲁ ⲛⲁⲓ ⲟⲩⲟⲛ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϣⲉⲡ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫⲧ ⳿ⲉⲣⲟϥ ⲁⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲛⲛⲉϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓⲧⲟⲧϥ ⳿ⲛⲥⲱⲟⲩ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁϥⲭⲁ ϫⲓϫ ⳿ⲡⲉϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲟⲩⲙⲱⲓⲧ ⲁϥϭⲟϫⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲥ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ⳿ⲛⲧⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲛⲟⲩⲱⲛϧ⳿ⲛ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟⲓ ϫⲉ ⲡⲓ⳿ⲁⲅⲁⲑⲟⲥ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲫϯ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ⲛⲓⲉⲛⲧⲟⲗⲏ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲉⲣϧⲱⲧⲉⲃ ⳿ⲙⲡⲉⲣⲉⲣⲛⲱⲓⲕ ⳿ⲙⲡⲉⲣϭⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉⲣⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ⳿ⲙⲡⲉⲣϥⲱϫⲓ ⳿ⲁⲣⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⲧⲉⲕⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⲓⲥϫⲉⲛ ⲧⲁⲙⲉⲧ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲣⲟϥ ⲁϥⲙⲉⲛⲣⲓⲧϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲕⲉⲟⲩⲁⲓ ⲡⲉⲧⲉⲕⲉⲣϧⲁ⳿ⲉ ⳿ⲙⲙⲟϥ ⲙⲁϣⲉⲛⲁⲕ ⲙⲁ ⲡⲉⲧⲉ⳿ⲛⲧⲁⲕ ⳿ⲉⲃⲟⲗ ⲙⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⲉⲕ⳿ⲉ⳿ϫⲫⲟ ⲛⲁⲕ ⳿ⲛⲟⲩ⳿ⲁϩⲟ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲩ ⲟⲩⲁϩⲕ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲱⲕⲉⲙ ⳿ⲉϫⲉⲛ ⲡⲓⲥⲁϫⲓ ⲁϥϣⲉⲛⲁϥ ⳿ⲉⲣⲉ ⲛⲉϥϩⲏⲧ ⲙⲟⲕϩ ⲛⲁⲣⲉ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⳿ⲛ⳿ϫⲫⲟ ⳿ⲛⲧⲁϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲡⲱⲥ ⳿ⲥⲙⲟⲕϩ ⳿ⲛⲛⲏ⳿ⲉⲧⲉ ⲛⲓ⳿ⲭⲣⲏⲙⲁ ⳿ⲛⲧⲱⲟⲩ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲛⲁⲩⲉⲣϩⲟϯ ⲡⲉ ⳿ⲉϫⲉⲛ ⲡⲓⲥⲁϫⲓ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲟⲛ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁϣⲏⲣⲓ ⲡⲱⲥ ⳿ⲥⲙⲟⲕϩ ⳿ⲛⲧⲉ ⲛⲏ⳿ⲉⲧⲉ ⳿ϩⲑⲏⲟⲩ ⲭⲏ ⳿ⲉϩⲁⲛ⳿ⲭⲣⲏⲙⲁ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","⳿ⲥⲙⲟⲧⲉⲛ ⳿ⲛⲟⲩϫ⳿ⲁⲙⲟⲩⲗ ⳿ⲉⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⳿ⲫⲟⲩⲱⲧⲉⲛ ⳿ⲛⲟⲩⲙⲁ⳿ⲛⲑⲱⲣⲡ ⲓⲉ ⲟⲩⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲛϩⲟⲩ⳿ⲟ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","⳿ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ϧⲁⲧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲙⲉⲧⲁⲧϫⲟⲙ ⲁⲗⲗⲁ ⳿ⲛⲧⲉⲛ Ⲫϯ ⲁⲛ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⲅⲁⲣ ⳿ⲙ⳿ⲡⲧⲏⲣϥ ⳿ⲛⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲭⲁ ⳿ⲡⲧⲏⲣϥ ⳿ⲛⲥⲱⲛ ⲟⲩⲟϩ ⲁⲛⲟⲩⲁϩⲧⲉⲛ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ⲡⲉϫⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲁϥⲭⲁ ⲏⲓ ⳿ⲛⲥⲱϥ ⲓⲉ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ ⲓⲉ ϩⲁⲛⲥⲱⲛⲓ ⲓⲉ ⲙⲁⲩ ⲓⲉ ⲓⲱⲧ ⲓⲉ ϣⲏⲣⲓ ⲓⲉ ⲓⲟϩⲓ ⲉⲑⲃⲏⲧ ⲛⲉⲙ ⲉⲑⲃⲉ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ⲁϥ⳿ϣⲧⲉⲙϭⲓⲧⲟⲩ ⳿ⲛⲣ̅ ⳿ⲛⲕⲱⲃ ⳿ⲛⲥⲟⲡ ϯⲛⲟⲩ ϧⲉⲛ ⲡⲁⲓⲥⲏⲟⲩ ϩⲁⲛⲏⲓ ⲛⲉⲙ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲙ ϩⲁⲛⲥⲱⲛⲓ ⲛⲉⲙ ϩⲁⲛⲙⲁⲩ ⲛⲉⲙ ϩⲁⲛⲓⲱⲧ ⲛⲉⲙ ϩⲁⲛϣⲏⲣⲓ ⲛⲉⲙ ϩⲁⲛⲓⲟϩⲓ ϧⲉⲛ ⲛⲓⲇⲓⲱⲅⲙⲟⲥ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓ⳿ⲉⲱⲛ ⲉⲑⲛⲏⲟⲩ ⲟⲩⲱⲛϧ⳿ⲛ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ϩⲁⲛⲙⲏϣ ⲇⲉ ⳿ⲛϣⲟⲣⲡ ⲉⲩ⳿ⲉⲉⲣϧⲁ⳿ⲉ ⲟⲩⲟϩ ϩⲁⲛϧⲁⲉⲩ ⲉⲩⲛⲁⲉⲣϣⲟⲣⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ⲛⲁⲩϩⲓ ⳿ⲫⲙⲱⲓⲧ ⲇⲉ ⲡⲉ ⲉⲩⲛⲏⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲛⲁϥⲙⲟϣⲓ ϧⲁϫⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣϩⲟϯ ⲛⲏⲇⲉ ⳿ⲉⲛⲁⲩⲉⲣⲁⲕⲟⲗⲟⲩⲑⲓⲛ ⲛⲁⲩⲉⲣϩⲟϯ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⲁϥ⳿ⲓⲛⲓ ⳿ⲙⲡⲓⲓ̅ⲃ̅ ⳿ⲉⲧⲟⲧϥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ ⲛⲏⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ϫⲉ ϩⲏⲡⲡⲉ ⲧⲉⲛⲛⲁϣⲉⲛⲁⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ ⲙ̅ ⲟⲩⲟϩ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲛⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⲥⲉⲛⲁϯϩⲁⲛ⳿ⲙⲙⲟⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ⲟⲩⲟϩ ⲥⲉⲛⲁⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲉⲛⲁϩⲓⲑⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⲟⲩⲟϩ ⲥⲉⲛⲁⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲉⲛⲁϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ϥⲛⲁⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲌⲉⲃⲉⲇⲉⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲉⲛⲟⲩⲱϣ ϩⲓⲛⲁ ⲫⲏ⳿ⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲉⲕⲁⲓϥ ⲛⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲁⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","⳿ⲛⲑⲱⲟⲩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲙⲏ ⲓⲥ ⲛⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϩⲉⲙⲥⲓ ⲥⲁⲧⲉⲕⲟⲩ⳿ⲓⲛⲁⲙ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⳿ⲙⲙⲟⲛ ⲥⲁⲧⲉⲕϫⲁϭⲏ ϧⲉⲛ ⲡⲉⲕⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲥⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⳿ⲉϯⲥⲱ ⳿ⲙⲙⲟϥ ⲓⲉ ⲡⲓⲱⲙⲥ ⳿ⲉϯⲱⲙⲥ ⳿ⲙⲙⲟⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⳿ⲉϯⲥⲱ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟϥ ⲟⲩⲟϩ ⲓⲱⲙⲥ⳿ⲉϯⲱⲙⲥ ⳿ⲙⲙⲟⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲉⲙⲥ ⲑⲏⲛⲟⲩ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ⲡⲓϩⲉⲙⲥⲓ ⲇⲉ ⳿ⲛⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲙⲟⲓ ⲓⲉ ϫⲁϭⲏ ⳿ⲙⲫⲱⲓ ⲁⲛ ⲡⲉ ⳿ⲉⲧⲏⲓϥ ⲁⲗⲗⲁ ⲫⲁ ⲛⲏ ⲡⲉ ⳿ⲉⲧⲁϥⲥⲉⲃⲧⲱⲧϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲓ̅ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲉⲑⲃⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲛⲏⲉⲑⲙⲉⲩⲓ ϫⲉ ⲥⲉⲟⲓ ⳿ⲛⲁⲣⲭⲱⲛ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ ⲥⲉⲟⲓ ⳿ⲛ ⲥ̅ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲛⲟⲩⲛⲓϣϯ ⲥⲉⲟⲓ ⳿ⲛⲉⲣϣⲓϣⲓ ⳿ⲡⲉϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲁⲛ ⲡⲉⲧϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲗⲗⲁ ⲫⲏⲉⲑⲛⲁⲟⲩⲱϣ ⳿ⲉⲉⲣⲛⲓϣϯ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲉⲉⲣⲇⲓ⳿ⲁⲕⲱⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲟⲩⲱϣ ⳿ⲉⲉⲣϩⲟⲩⲓⲧ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲉⲉⲣⲃⲱⲕ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ⲟⲩ ⲅⲁⲣ ⳿ⲡⲱⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛ⳿ⲉⲧⲁϥ⳿ⲓ ⲁⲛ ⲉⲑⲣⲟⲩϣⲉⲙϣⲏⲧϥ ⲁⲗⲗⲁ ⳿ⲉϣⲉⲙϣⲓ ⲟⲩⲟϩ ⳿ⲉϯ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⳿ⲛⲥⲱϯ ⳿ⲛϣⲉⲃⲓⲱ ⳿ⲛⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲓⲉⲣⲓⲭⲱ ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲉⲣⲓⲭⲱ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⲃⲁⲣⲧⲓⲙⲉⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲧⲓⲙⲉⲟⲥ⳿ⲉⲟⲩⲃⲉⲗⲗⲉ ⲡⲉ ⳿ⲛⲣⲉϥⲧⲱⲃϩ ⲛⲁϥϩⲉⲙⲥⲓ ⳿ⲉ⳿ⲥⲕⲉⲛ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ⲡⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⲉϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⲛⲁⲓ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ⲟⲩⲟϩ ⲛⲁⲩⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲭⲁⲣⲱϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲛϩⲟⲩ⳿ⲟ ⲙⲁⲗⲗⲟⲛ ⲛⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⲛⲁⲓ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩϯ ⳿ⲙⲡⲓⲃⲉⲗⲗⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⲧⲱⲛⲕ ⳿ⲁⲙⲟⲩ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲉⲧ ⲡⲉϥ⳿ϩⲃⲟⲥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϥⲟϫϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⲁϥ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ");
INSERT INTO copcnt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲁⲓϥ ⲛⲁⲕ ⲡⲓⲃⲉⲗⲗⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲟⲩⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⲡⲉⲕⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲉⲕ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲛⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ϧⲉⲛ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁϥ⳿ⲓ ⳿ⲉⲃⲏ ⲑⲫⲁⲅⲏⲛⲉⲙ Ⲃⲏⲑⲁⲛⲓ⳿ⲁ ϧⲁⲧⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲃ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ");
INSERT INTO copcnt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲡⲁⲓϯⲙⲓ ⲉⲧⲭⲏ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⲟⲩⲟϩ ⲥⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲉⲧⲉⲛⲛⲁϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲟⲩⲥⲏϫ ⲉϥⲥⲟⲛϩ ⲫⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲡⲁⲧⲉ ⳿ϩⲗⲓ ⳿ⲛⲣⲱⲙⲓ ⳿ⲁⲗⲏⲓ ⳿ⲉⲣⲟϥ ⲙⲁϯⲟⲩⲱ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲁⲛⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⳿ⲉⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲁϫⲟⲥ ϫⲉ Ⲡ⳪ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ⳿ϥⲛⲁⲟⲩⲟⲣⲡϥ ⳿ⲙⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ⲟⲩⲟϩ ⲁⲩϣⲉⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩϫⲓⲙⲓ ⳿ⲛⲟⲩⲥⲏϫ ⲉϥⲥⲟⲛϩ ϧⲁⲧⲉⲛ ⲟⲩⲣⲟ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓϧⲓⲣ ⲟⲩⲟϩ ⲁⲩϯⲟⲩⲱ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ⲟⲩⲟϩ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲙⲁⲩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ ⳿ⲉⲣⲉⲧⲉⲛϯⲟⲩⲱ ⳿ⲙⲡⲓⲥⲏϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϫⲟⲥ ⲛⲱⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲭⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲙⲡⲓⲥⲏϫ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲧⲁⲗⲉ ⳿ⲛⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲁϥϩⲉⲙⲥⲓ ϩⲓϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ⲟⲩⲟϩ ϩⲁⲛⲙⲏϣ ⲁⲩⲫⲱⲣϣ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ϩⲓ ⲡⲓⲙⲱⲓⲧ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩⲕⲱⲣϫ ⳿ⲛϩⲁⲛϫⲁⲗ ⳿ⲛ⳿ϣϣⲏⲛ ϧⲉⲛ ⲛⲓⲓⲟϩⲓ ⲟⲩⲟϩ ⲁⲩⲫⲱⲣϣ ⳿ⲙⲙⲱⲟⲩ ϩⲓ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ϩⲓ⳿ⲧϩⲏ ⲛⲉⲙ ⲛⲏ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ϩⲓⲫⲁϩⲟⲩ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲱⲥⲀⲛⲛⲁ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲡⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ");
INSERT INTO copcnt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","⳿ⲥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⲉⲑⲛⲏⲟⲩ ⳿ⲛⲧⲉ ⲡⲉⲛⲓⲱⲧ Ⲇⲁⲩⲓⲇ ⳿ⲱⲥⲀⲛⲛⲁ ϧⲉⲛ ⲛⲏⲉⲧϭⲟⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉ⳿ⲡⲧⲏⲣϥ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ϩⲏⲇⲏ ϣⲱⲡⲓ ⳿ⲛⲧⲉ ⲟⲩⲟⲩⲛⲟⲩ ⲁϥ⳿ⲓ ⳿ⲉⲂⲏⲑⲁⲛⲓ⳿ⲁ ⲛⲉⲙ ⲡⲓⲓ̅ⲃ̅ ");
INSERT INTO copcnt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ⲟⲩⲟϩ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲃⲏⲑⲁⲛⲓ⳿ⲁ ⲁϥ⳿ϩⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ϩⲓⲫⲟⲩⲉⲓ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛϫⲱⲃⲓ ϩⲓⲱⲧⲥ ⲁϥ⳿ⲓ ϫⲉ ϩⲁⲣⲁ ⳿ϥⲛⲁϫⲉⲙ ⳿ϩⲗⲓ ϩⲓⲱⲧⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϫⲱⲥ ⳿ⲙⲡⲉϥϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉϩⲁⲛϫⲱⲃⲓ ⲛⲉ ⳿ⲡⲥⲏⲟⲩ ⲅⲁⲣ ⳿ⲛⲕⲉⲛⲧⲉ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⳿ⲛⲛⲉ ⳿ϩⲗⲓ ϫⲉⲙ ⲟⲩⲧⲁϩ ϩⲓⲱϯ ϣⲁ ⳿⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⲛⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲏⲧⲏⲣⲟⲩ ⲉⲧϯ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲛⲏⲉⲧϣⲱⲡ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲛⲓ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ ⲛⲓⲕⲟⲗⲩⲃⲓⲥⲧⲏⲥ ⲛⲉⲙ ⲛⲓⲕⲁⲑⲉⲇⲣ⳿ⲁ ⳿ⲛⲧⲉ ⲛⲏⲉⲧϯ ϭⲣⲟⲙⲡⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲥⲟⲥⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ⲟⲩⲟϩ ⲛⲁϥⲭⲱ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲉⲛ ⲟⲩ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲁⲏⲓ ⲉⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲟⲩⲏⲓ ⳿ⲙ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲁⲣⲉⲧⲉⲛⲁⲓϥ ⳿ⲙⲃⲏⲃ ⳿ⲛⲥⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ϫⲉ ⲁⲩⲛⲁⲧⲁⲕⲟϥ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⲛⲁⲩⲉⲣϩⲟϯ ⲅⲁⲣ ϧⲁⲧⲉϥϩⲏⲡⲓⲙⲏϣ ⲅⲁⲣ ⲧⲏⲣϥ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲣⲟⲩϩⲓ ϣⲱⲡⲓ ⲛⲁϥϩⲏⲗ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ⲟⲩⲟϩ ⲉⲩⲥⲓⲛⲓⲱⲟⲩ ⳿ⲛϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⲁⲩⲛⲁⲩ ⳿ⲉϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲁⲥϣⲱⲟⲩ⳿ⲓ ϩⲓ ⲧⲉⲥⲛⲟⲩⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲓⲥ ϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⳿ⲉⲧⲁⲕⲥⲁϩⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲥ ⲁⲥϣⲱⲟⲩ⳿Ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲭⲁ ⲟⲩⲛⲁϩϯ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","⳿ⲁⲙⲏⲛ ⲅⲁⲣ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϫⲟⲥ ⳿ⲙⲡⲁⲓⲧⲱⲟⲩ ϫⲉ ϥⲓⲧⲕ ⲟⲩⲟϩ ϩⲓⲧⲕ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙϭⲓⲥⲁⲛⲓⲥ ϧⲉⲛⲡⲉϥϩⲏⲧ ⲁⲗⲗⲁ ⳿ⲛⲧⲉϥⲛⲁϩϯ ϫⲉ ⲫⲏ⳿ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲟϥ ⳿ϥⲛⲁϣⲱⲡⲓ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ⲉⲑⲃⲉ ⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲁϩϯ ϫⲉ ⳿ⲁⲣⲉⲧⲉⲛϭⲓ ⲟⲩⲟϩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛϣⲁⲛ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲧⲉⲛ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ϩⲱϥ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⳿ⲛⲧⲉϥⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲉⲧⲉⲛⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ⲟⲩⲟϩ ϩⲟⲧⲁⲛ ⲛⲧⲉⲧⲉⲛϭⲧⲉⲙⲭⲱ ⳿ⲉⲃⲟⲗ ⲟⲩⲇⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲛⲛⲉϥⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲙⲡⲉⲧⲉⲛⲡⲁⲣⲁⲡⲧⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲟⲛ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲉϥⲙⲟϣⲓ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲁⲕ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ ⲓⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϯ ⲛⲁⲕ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯⲛⲁϣⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩⲥⲁϫⲓ ⳿ⲛⲟⲩⲱⲧ ⳿ⲁⲣⲓⲟⲩⲱ ⲛⲏⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲓ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ϣⲁⲛ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⳿ⲁⲣⲓⲟⲩⲱ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ⲟⲩⲟϩ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛϣⲁⲛϫⲟⲥ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ⳿ϥⲛⲁϫⲟⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ⲁⲗⲗⲁ ⳿ⲛⲧⲉⲛϫⲟⲥ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲧ⳿ⲉⲛⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲙⲏϣ ⲛⲁⲣⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲅⲁⲣ ⳿ⲛⲧⲟⲧⲟⲩ ⲧⲏⲣⲟⲩ ϫⲉ ⲟⲛⲧⲱⲥ ⲛⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛⲒⲏ̅ⲥ̅ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲟⲩⲟϩ Ⲓⲏ̅ⲥ̅ ϩⲱϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⲁⲓ⳿⳿ⲓⲣⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲁϥϭⲟ ⳿ⲛⲟⲩⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲁϥⲕⲱⲧ ⳿ⲛⲟⲩϫⲟⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲁϥϣⲱⲕ ⳿ⲛⲟⲩ⳿ϩⲣⲱⲧ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁϥⲕⲱⲧ ⳿ⲛⲟⲩⲡⲩⲣⲅⲟⲥ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛⲟⲩⲓⲏ ⲟⲩⲟϩ ⲁϥϣⲉⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ϩⲁ ⲛⲓⲟⲩⲓⲏ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲟⲩⲃⲱⲕ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲟⲩⲓⲏ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϭⲓⲧϥ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲁⲩⲟⲩⲟⲣⲡϥ ⲉϥϣⲟⲩⲓⲧ ");
INSERT INTO copcnt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⲟⲛ ϩⲁⲣⲱⲟⲩ ⳿ⲛⲕⲉⲃⲱⲕ ⲟⲩⲟϩ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲁⲩⲫⲟⲗϩϥ ⲟⲩⲟϩ ⲁⲩϣⲟϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⲟⲩⲟϩ ⲡⲓⲭⲉⲧ ⲁⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛϩⲁⲛⲕⲉⲙⲏϣ ϩⲁⲛⲟⲩⲟⲛ ⲁⲩϩⲓ⳿ⲱⲛⲓ ⳿ⲉⲣⲱⲟⲩ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩϧⲱⲧⲉⲃ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ⲉⲧⲓ ⲟⲩϣⲏⲣⲓ ⳿ⲙⲙⲉⲛⲣⲓⲧ ⳿ⲉⲛⲁϥ⳿ⲛⲧⲁϥ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ϩⲁⲣⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲥⲉⲛⲁ⳿ϣⲫⲓⲧ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲁϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ⲛⲓⲟⲩⲓⲏ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲁⲙⲱⲓⲛⲓ ⲙⲁⲣⲉⲛϧⲟⲑⲃⲉϥ ⳿ⲛⲧⲉ ϯ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓ⳿ⲁ ⲉⲣⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϭⲓⲧϥ ⲁⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲁⲩϩⲓⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉϥⲛⲁⲁⲓϥ ⳿ⲛϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⳿ϥⲛⲁ⳿ⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲁⲕⲟ ⳿ⲛⲛⲓⲟⲩⲓⲏ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ⲟⲩⲇⲉ ⲧⲁⲓ⳿ⲅⲣⲁⲫⲏ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲧⲁⲩϣⲟϣϥ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲱⲧ ⲫⲁⲓ ⲁϥϣⲱⲡⲓ ⳿ⲛⲟⲩϫⲱϫ ⳿ⲛⲗⲁⲕϩ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ⲉⲧⲁ ⲫⲁⲓ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲡ⳪ ⲟⲩⲟϩ ⳿ϥⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⲛⲉⲛⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲙⲏϣ ⲁⲩ⳿ⲉⲙⲓ ⲅⲁⲣ ϫⲉ ⳿ⲉⲧⲁϥϫⲉ ⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲉⲑⲃⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲭⲁϥ ⲁⲩϣⲉⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲏⲣⲱⲇⲓ⳿ⲁⲛⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϫⲟⲣϫϥ ⳿ⲛⲟⲩⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","⳿ⲛⲑⲟϥ ⲇⲉ ⲉϥⲥⲱⲟⲩⲛ ⳿ⲛⲧⲟⲩⲙⲉⲧϣⲟⲃⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛϭⲱⲛⲧ ⳿ⲙⲙⲟⲓ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⲛⲏⲓ ⳿ⲛⲟⲩⲥⲁⲑⲉⲣⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲁⲩ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲓⲛⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲑⲁ ⲛⲓⲙ ⲧⲉ ⲧⲁⲓϩⲓⲕⲱⲛ ⲛⲉⲙ ⲧⲁⲓ⳿ⲉⲡⲓⲅⲣⲁⲫⲏ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⲙⲏⲓⲧⲟⲩ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲟⲩⲟϩ ⲛⲁ Ⲫϯ ⲙⲏⲓⲧⲟⲩ ⳿ⲙⲪϯ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲱϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲛⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ϣⲟⲡ ⲟⲩⲟϩ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ Ⲙⲱ⳿ⲩⲥⲏⲥ ⲁϥ⳿ⲥϧⲁⲓ ⲛⲁⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⳿ⲡⲥⲟⲛ ⳿ⲛⲟⲩⲁⲓ ⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲥⲉϫⲡ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲭⲁ ϣⲏⲣⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉϥⲥⲟⲛ ϭⲓ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲟⲩⲛⲟⲥ ⲟⲩ⳿ϫⲣⲟϫ ⳿ⲙⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ⲛⲉ ⲟⲩⲟⲛ ⲍ̅ ⲇⲉ ⳿ⲛⲥⲟⲛ ϧⲁⲧⲟⲧⲉⲛ ⲡⲉ ⲟⲩⲟϩ ⲡⲓϩⲟⲩⲓⲧ ϭⲓ⳿ⲥϩⲓⲙⲓ ⲛⲁϥⲙⲟⲩ ⳿ⲙⲡⲉϥⲭⲁ ⳿ϫⲣⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ⲟⲩⲟϩ ⲡⲓⲙⲁϩⲃ̅ ⲁϥϭⲓⲧⲥ ⲟⲩⲟϩ ⲁϥⲙⲟⲩ ⳿ⲙⲡⲉϥⲭⲁ ⳿ϫⲣⲟϫ ⲟⲩⲟϩ ⲡⲓⲙⲁϩⲅ̅ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ⲟⲩⲟϩ ⲡⲓⲙⲁϩⲍ̅ ⳿ⲙⲡⲟⲩⲭⲁ ⳿ϫⲣⲟϫ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲁⲥⲙⲟⲩ ⳿ⲛϫⲉ ϯⲕⲉ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ϧⲉⲛ ϯ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲁⲥⲛⲁⲉⲣ ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲛⲓⲙ ⳿ⲙⲙⲱⲟⲩ ⲡⲓⲍ̅ ⲅⲁⲣ ⲁⲩϭⲓⲧⲥ ⳿ⲛ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲙⲏ ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲛ ⲧⲉⲧⲉⲛⲥⲟⲣⲉⲙ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛϯ⳿ⲅⲣⲁⲫⲏ ⲟⲩⲇⲉ ϯϫⲟⲙ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ϩⲟⲧⲁⲛ ⲅⲁⲣ ⲁⲩϣⲁⲛⲧⲱⲟⲩⲛⲟⲩ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭ ⲓⲧⲟⲩ ⲁⲗⲗⲁ ⲁⲩ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲁⲅⲅⲉⲗⲟⲥ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ⲉⲑⲃⲉ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲇⲉ ϫⲉ ⲥⲉⲛⲁⲧⲱⲟⲩⲛⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛⲱϣ ϩⲓ ⳿ⲡϫⲱⲙ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲡⲱⲥ ⲁϥϫⲟⲥ ⲛⲁϥ ϩⲓϫⲉⲛ ⲡⲓⲃⲁⲧⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲫϯ ⳿ⲛⲀⲃⲣⲁⲁⲙ ⲛⲉⲙ Ⲫϯ ⳿ⲛ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ Ⲫϯ ⳿ⲛⲒⲁⲕⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ⲫϯ ⲫⲁ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲁ ⲛⲏⲉⲧⲟⲛϧ ⲧⲉⲧⲉⲛⲥⲟⲣⲉⲙ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲓⲥⲁϧ⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲉⲩⲕⲱϯ ⲉϥ⳿ⲉⲙⲓ ϫⲉ ⲕⲁⲗⲱⲥ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲁϥϣⲉⲛϥ ϫⲉ ⲁϣ ⲧⲉ ϯⲉⲛⲧⲟⲗⲏ ⲉⲧⲟⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϯϣⲟⲣⲡ ⲧⲉ ⲑⲁⲓ ⲥⲱⲧⲉⲙ ⲡⲓⲥ̅ⲗ̅ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ Ⲡ⳪ ⲟⲩⲁⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ⲟⲩⲟϩ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲕϩⲏⲧ ⲧⲏⲣϥ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲕⲯⲩⲭⲏ ⲧⲏⲣⲥ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉⲕⲙⲉⲩⲓ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲕϫⲟⲙ ⲧⲏⲣⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ϯⲙⲁϩ⳿ⲥⲛⲟⲩϯ ⲧⲉ ⲑⲁⲓ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ ⳿ⲙⲙⲟⲛ ⲕⲉⲉⲛⲧⲟⲗⲏ ⲉⲥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲥⲁϧ ϫⲉ ⲕⲁⲗⲱⲥ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲁⲕϫⲟⲥ ϫⲉ ⲟⲩⲁⲓ ⲡⲉ Ⲫϯ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲕⲉⲟⲩⲁⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ⲟⲩⲟϩ ⲡⲓⲙⲉⲛⲣⲓⲧϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲕϩⲏⲧ ⲧⲏⲣϥ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲕϫⲟⲙ ⲧⲏⲣⲥ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲕⲁϯ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲡⲓⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ ⲥⲉⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲛⲓϭⲗⲓⲗ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓϣⲟⲩϣⲱⲟⲩϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲉⲟⲩⲟⲛ ϩⲏⲧ ⳿ⲙⲙⲟϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲭⲟⲩ⳿ⲏⲟⲩ ⲁⲛ ⳿ⲉⲃⲟⲗϩⲁ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ϣⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉϣⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲡⲱⲥ ⲥⲉϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ϫⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⲛⲆⲁⲩⲓⲇ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⳿ⲛⲑⲟϥ Ⲇⲁⲩⲓⲇ ⲁϥϫⲟⲥ ϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ϫⲉ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲠⲁ⳪ ϫⲉ ϩⲉⲙⲥⲓ ⲥⲁⲧⲁⲟⲩⲓⲛⲁⲙ ϣⲁϯⲭⲁ ⲛⲉⲕϫⲁϫⲓ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛⲛⲉⲕϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","⳿ⲛⲑⲟϥ Ⲇⲁⲩⲓⲇ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡ⳪ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉϥϣⲏⲣⲓ ⲡⲉ ⲟⲩⲟϩ ⲡⲓⲙⲏϣ ⲉⲧⲟϣ ⲛⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ϩⲏⲇⲉⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ⲟⲩⲟϩ ϧⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲙⲟϣⲓ ϧⲉⲛ ϩⲁⲛ⳿ⲥⲧⲟⲗⲏⲛⲉⲙ ⲁⲛⲁⲥⲡⲁⲥⲙⲟⲥϧⲉⲛ ⲛⲓⲁⲅⲟⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ⲛⲉⲙ ϩⲁ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛϩⲉⲙⲥⲓ ϧⲉⲛ ⲛⲓⲕⲁⲑⲉⲇⲣ⳿ⲁ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ϩⲁ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲣⲱⲧⲉⲃ ϧⲉⲛ ⲛⲓⲇⲓⲡⲛⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ⲛⲏⲉⲑⲟⲩⲱⲙ ⳿ⲛⲛⲓⲏⲓ ⳿ⲛⲧⲉ ⲛⲓⲭⲏⲣⲁ ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩⲗⲱⲓϫⲓ ⲉⲥⲟⲩ⳿ⲏⲟⲩ ⲥⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲛⲁⲓ ⲉⲑⲛⲁϭⲓ ⳿ⲛⲟⲩϩⲟⲩ⳿ⲟ ϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲙⲥⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲅⲁⲍⲟⲫⲩⲗⲁⲕⲓⲟⲛ ⲛⲁϥⲛⲁⲩ ϫⲉ ⲡⲱⲥ ⲛⲓⲙⲏϣ ϩⲓ ϩⲟⲙⲧ ⳿ⲉⲡⲓⲅⲁⲍⲟⲫⲩⲗⲁⲕⲓⲟⲛ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⲛⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲛϩⲁⲛⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ⲉⲧⲁⲥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲭⲏⲣⲁ ⳿ⲛϩⲏⲕⲓ ⲁⲥϩⲓⲟⲩ⳿Ⲓ ⳿ⲛⲧⲉⲃⲓ ⳿ⲥⲛⲟⲩϯ ⳿ⲉⲧⲉ ⲟⲩⲕⲟⲛ⳿ⲇⲣⲁⲛⲧⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⳿⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲧⲁⲓⲭⲏⲣⲁ ⳿ⲛϩⲏⲕⲓ ⲁⲥϩⲓⲟⲩ⳿ⲓ ⳿ⲉϩⲟⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲧϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲡⲓⲅⲁⲍⲟⲫⲩⲗⲁⲕⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲧⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲱⲟⲩ ⲑⲁⲓ ⲇⲉ ⳿ⲛⲑⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲧⲉⲥⲉⲣϧⲁ⳿ⲉ ⳿ⲙⲙⲟϥ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ⳿ⲛⲧⲁⲥ ⲁⲥϩⲓⲧⲟⲩ ⲡⲉⲥⲱⲛϧ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲛⲁϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲭⲛⲁⲩ ϫⲉ ϩⲁⲛⲁϣ ⳿ⲛⲣⲏϯ ⲛⲉ ⲛⲁⲓ⳿ⲱⲛⲓ ⲟⲩⲟϩ ϩⲁⲛⲕⲱⲧ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲭⲛⲁⲩ ⳿ⲉⲛⲁⲓⲛⲓϣϯ ⳿ⲛ⳿ⲱⲛⲓ ⳿ⲛⲛⲟⲩⲭⲁ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲟⲩ⳿ⲱⲛⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲥⲉⲛⲁⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ⲟⲩⲟϩ ⲉϥϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲉⲣⲫⲉⲓ ⲁⲩϣⲉⲛϥ ⳿ⲛⲥⲁ ⳿ⲡⲥⲁ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ ");
INSERT INTO copcnt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ϫⲉ ⲁϫⲟⲥ ⲛⲁⲛ ϫⲉ ⳿ⲁⲣⲉ ⲛⲁⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲟⲩⲟϩ ⲟⲩ ⲡⲉ ⲡⲓⲙⲏⲓⲛⲓ ⳿ⲁⲣⲉϣⲁⲛ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲛⲟⲩ⳿ⲓ ⳿ⲉϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ϩⲗⲓ ⲥⲉⲣⲉⲙ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⲛⲁⲓ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⲥⲉⲛⲁⲥⲉⲣⲉⲙ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ϩⲟⲧⲁⲛ ⲇⲉ ⳿ⲁⲣⲉⲧⲉⲛϣⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉϩⲁⲛⲡⲟⲗⲉⲙⲟⲥ ⲛⲉⲙ ϩⲁⲛ⳿ⲥⲙⲏ ⳿ⲙⲡⲟⲗⲉⲙⲟⲥ ⳿ⲙⲡⲉⲣ⳿ϣⲑⲟⲣⲧⲉⲣ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⲁⲗⲗⲁ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ⲉϥ⳿ⲉⲧⲱⲛϥ ⲅⲁⲣ ⳿ⲛϫⲉ ⲟⲩⲉⲑⲛⲟⲥ ⳿ⲉϫⲉⲛ ⲟⲩⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛⲙⲟⲛⲙⲉⲛ ⲕⲁⲧⲁ ⲙⲁ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛ⳿ϩⲃⲱⲛ ϩⲏ⳿ⲛⲛⲓⲛⲁⲕϩⲓ ⲛⲉ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","⳿ⲁⲛⲁⲩ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲥⲉⲛⲁϯ ⲑⲏⲛⲟⲩ ⳿ⲉϩⲁⲛⲙⲁ⳿ⲛϯϩⲁⲡ ⲟⲩⲟϩ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲥⲉⲛⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲛⲧⲟⲩⲧⲁϩⲱⲧⲉⲛ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲁϩⲣⲉⲛ ϩⲁⲛϩⲏⲅⲉⲙⲱⲛ ⲛⲉⲙ ϩⲁⲛⲟⲩⲣⲱⲟⲩ ⲉⲑⲃⲏⲧ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ⲛⲉⲙ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ϩⲱϯ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲟⲩϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲟⲩⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲩϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲙⲡⲉⲣⲉⲣϣⲟⲣⲡ ⳿ⲛϥⲓⲣⲱⲟⲩϣ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ⲡⲉⲧⲟⲩⲛⲁⲧⲏⲓϥ ⲛⲱⲧⲉⲛ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲁⲓ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲅⲁⲣ ⲁⲛ ⲡⲉⲑⲛⲁⲥⲁϫⲓ ⲁⲗⲗⲁ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲟⲩⲥⲟⲛ ϯ ⳿ⲛⲟⲩⲥⲟⲛ ⳿ⲉ⳿ⲫⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲣⲉ ⲟⲩⲓⲱⲧ ⲉϥ⳿ⲉϯ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲱⲟⲩⲛⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛϣⲏⲣⲓ ⳿ⲉϫⲉⲛ ϩⲁⲛⲓⲟϯ ⲟⲩⲟϩ ⲥⲉⲛⲁϧⲟⲑⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϣⲱⲡⲓ ⲉⲩⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲟⲧϥ ϣⲁ ⳿ⲉⲃⲟⲗ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲑⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","⳿ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲡⲓⲥⲱϥ ⳿ⲛⲧⲉ ⲡⲓϣⲱϥ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲥϣⲉ ⲁⲛ ⲫⲏⲉⲧⲱϣ ⲙⲁⲣⲉϥⲕⲁϯ ⲧⲟⲧⲉ ⲛⲏⲉⲧⲭⲏ ϧⲉⲛϯⲒⲟⲩⲇⲉ⳿ⲁ ⲙⲁⲣⲟⲩⲫⲱⲧ ⳿ⲉϫⲉⲛ ⲛⲓⲧⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ⲫⲏⲉⲧϩⲓϫⲉⲛ ⳿ⲡϫ⳿ⲉⲛⲉⲫⲱⲣ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥ⳿Ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲉⲗ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ⲟⲩⲟϩ ⲫⲏⲉⲧϧⲉⲛ ⳿ⲧⲕⲟⲓ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥ⳿Ⲓ ⳿ⲉⲫⲁϩⲟⲩ ⳿ⲉⲉⲗ ⲡⲉϥ⳿ϩⲃⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ⲟⲩⲟⲓ ⲇⲉ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲙⲃⲟⲕⲓ ⲛⲉⲙ ⲛⲏⲉⲧϯϭⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ⲁⲣⲓ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲇⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙϣⲱⲡⲓ ϧⲉⲛ ⲧ⳿ⲫⲣⲱ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲫⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲅⲁⲣ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϩⲟϫϩⲉϫ ⳿ⲙⲡⲉ ⲟⲩⲟⲛ ϣⲱⲡⲓ ⳿ⲙⲡⲉϥⲣⲏϯ ⲓⲥϫⲉⲛ ϩⲏ ⳿ⲙⲡⲓⲥⲱⲛⲧ ⳿ⲉⲧⲁϥⲥⲟⲛⲧϥ ⳿ⲛϫⲉ ⲫϯϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲛⲉ ⲟⲩⲟⲛ ϣⲱⲡⲓ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ⲟⲩⲟϩ ⳿⳿ⲉⲛⲉ ⳿ⲙⲡⲉ Ⲡ⳪ ⲉⲑⲣⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲕⲟⲩϫⲓ ⲛⲁⲩⲛⲁⲛⲟϩⲉⲙ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⲛⲓⲥⲱⲧⲡ ⳿ⲉⲧⲁϥⲥⲟⲧⲡⲟⲩ ⲁϥϫⲉϫⲉⲃ ⲛⲓ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲓⲥ Ⲡⲭ̅ⲥ̅ ϩⲁ⳿ⲙⲛⲁⲓ ⲓⲉ ϩⲁ⳿ⲙⲛⲏ⳿ⲙⲡⲉⲣⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ⲉⲩ⳿ⲉⲧⲱⲟⲩⲛⲟⲩ ⲅⲁⲣ ⳿ⲛϫⲉ ϩⲁⲛⲭ̅ⲥ̅ ⳿ⲛⲛⲟⲩϫ ⲛⲉⲙ ϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲛⲟⲩϫ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϯ ⳿ⲛϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲉ⳿ⲡϫⲓⲛⲥⲱⲣⲉⲙ ⲁⲩϣⲁⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲛⲓⲕⲉⲥⲱⲧⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲁⲛⲁⲩ ϫⲉ ⲁⲓⲉⲣϣⲟⲣⲡ ⳿ⲛϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ⲁⲗⲗⲁ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲡϩⲟϫϩⲉϫ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲓⲣⲏⲉϥ⳿ⲉⲉⲣⲭ ⲁⲕⲓ ⲟⲩⲟϩ ⲡⲓⲓⲟϩ ⳿ⲛⲛⲉϥϯ ⳿ⲙⲡⲉϥⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ⲟⲩⲟϩ ⲛⲓⲥⲓⲟⲩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲉⲩϩⲓⲱⲟⲩⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲛⲓϫⲟⲙ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲕⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ϧⲉⲛ ϩⲁⲛϭⲏⲡⲓ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛϫⲟⲙ ⲛⲉⲙ ⲟⲩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ⲧⲟⲧⲉ ⳿ϥⲛⲁⲟⲩⲱⲣⲡ ⳿ⲛⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲟϩ ⳿ϥⲛⲁⲑⲱⲟⲩϯ ⳿ⲛⲛⲉϥⲥⲱⲧⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓ⳿ϥⲧⲟⲩ ⲑⲏⲟⲩ ⲓⲥϫⲉⲛ ⲁⲩⲣⲏϫϥ ⳿ⲙ⳿ⲡⲕⲁϩⲓ ϣⲁ ⲁⲩⲣⲏϫⲥ ⳿ⲛ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","⳿ⲉⲃⲟⲗ ⲇⲉ ϧⲉⲛ ϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉϯⲡⲁⲣⲟⲃⲟⲗⲏ⳿ⲉϣⲱⲡ ϩⲏⲇⲏ ⳿ⲛⲧⲉ ⲛⲉⲥϫⲁⲗ ϭⲛⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥϩⲓ ϫⲱⲃⲓ ⳿ⲉⲃⲟⲗ ϣ⳿ⲁⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ϥϧⲉⲛⲧ ⳿ⲛϫⲉ ⲡⲓϣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲙ ϩⲱⲧⲉⲛ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛϣⲀⲛⲛⲁⲩ ⳿ⲉⲛⲁⲓ ⳿ⲉⲁⲩϣⲱⲡⲓ ⳿ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⳿ϥϧⲱⲛⲧ ⳿ⲉⲛⲓⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉ ⲧⲁⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⲥⲓⲛⲓ ϣⲁⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲓⲕⲁϩⲓ ⲥⲉⲛⲁⲥⲓⲛⲓ ⲛⲁⲥⲁϫⲓ ⲇⲉ ⳿ⲛⲛⲟⲩⲥⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ⲉⲑⲃⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ϯⲟⲩⲛⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲇⲉ ⲁⲅⲅⲉⲗⲟⲥ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲇⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲪ̇ⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ⲣⲱⲓⲥ ⳿ⲁⲣⲓ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲅⲁⲣ ⲁⲛ ϫⲉ ⳿ⲑⲛⲁⲩ ⲡⲉ ⲡⲓⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁϥⲙⲟϣⲓ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ ⳿ⲉⲁϥⲭⲱ ⳿ⲙⲡⲉϥⲏⲓ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲉϥ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲙⲡⲓⲉⲣϣⲓϣⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲡⲉϥϩⲱⲃ ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧϥ ⳿ⲙⲡⲓⲉⲙⲛⲟⲩⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲣⲱⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ⲣⲱⲓⲥ ⲟⲩⲛ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲅⲁⲣ ⲁⲛ ϫⲉ ⳿ⲁⲣⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲏⲓ ⲛⲏⲟⲩ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲓⲉ ϩⲁⲛⲁⲣⲟⲩϩⲓ ⲓⲉ ⳿ⲧⲫⲁϣⲓ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲓⲉ ⳿ⲉⲣⲉ ⲓ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⲓⲉ ϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ⲙⲏⲡⲱⲥ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⳿ⲛⲧⲉϥϫⲉⲙ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲉⲧ⳿ⲉⲛⲉⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ⲡⲉϯϫⲱ ⳿ⲙⲙⲟϥ ⲛⲱⲧⲉⲛ ϯϫⲱ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲣⲱⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ⲛⲉ ⲛⲓⲡⲁⲥⲭⲁ ⲇⲉ ⲡⲉ ⲛⲉⲙ ⲛⲓⲁⲧϣⲉⲙⲏⲣ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ϫⲉ ⲡⲱⲥ ⳿ⲛⲧⲟⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩ⳿ⲭⲣⲟϥ ⳿ⲛⲧⲟⲩϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ⲛⲁⲩϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲁⲓⲥ ϧⲉⲛ ⳿ⲡϣⲁⲓ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲧⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ⲟⲩⲟϩ ⲉϥⲭⲏ ϧⲉⲛ Ⲃⲏⲑⲁⲛⲓ⳿ⲁ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲡⲓⲕⲁⲕⲥⲉϩⲧ ⲉϥⲣⲱⲧⲉⲃ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲟⲕⲓ ⳿ⲛⲥⲟϫⲉⲛ ⲛⲛⲁⲣⲇⲟⲥ ⳿ⲛⲧⲟⲧⲥ ⳿ⲙⲡⲓ⳿ⲥⲧⲓⲕⲏ⳿ⲉⲛⲁϣⲉ ⳿ⲛⲥⲟⲩⲉⲛϥ ⳿ⲉⲁⲥϧⲟⲙϧⲉⲙ ⳿ⲙⲡⲓⲙⲟⲕⲓ ⳿ⲉⲁⲥϫⲟϣϥ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ ");
INSERT INTO copcnt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ⲛⲁⲣⲉ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲁⲡⲁⲓⲧⲁⲕⲟ ⳿ⲛⲧⲉ ⲡⲁⲓⲥⲟϫⲉⲛ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ⲛⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⲅⲁⲣ ⳿ⲉϯ ⳿ⲙⲫⲁⲓ ⳿ⲉⲃⲟⲗ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲛⲧ̅ ⳿ⲛⲥⲁⲑⲉⲣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲧⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲙⲃⲟⲛ ⳿ⲉⲣⲟⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲭⲁⲥ ⳿ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛϯϧⲓⲥⲓ ⲛⲁⲥ ⲟⲩϩⲱⲃ ⲅⲁⲣ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲧⲁⲥⲉⲣϩⲱⲃ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲛⲓϩⲏⲕⲓ ⲥ⳿ⲉⲛⲉⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲛⲧⲉⲧⲉⲛⲟⲩⲱϣ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ ⲛⲱⲟⲩ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲁⲛⲟⲕ ⲇⲉ ϯⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ⲫⲏ⳿ⲉⲧⲁⲥϭⲓⲧϥ ⲁⲥⲁⲓϥ ⲁⲥⲉⲣϣⲟⲣⲡ ⲅⲁⲣ ⳿ⲛⲑⲁϩⲥ ⲡⲁⲥⲱⲙⲁ ⳿ⲙⲡⲁⲓⲥⲟϫⲉⲛ ⳿ⲉ⳿ⲡϫⲓⲛⲕⲟⲥⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲡⲓⲙⲁ ⲉⲧⲟⲩⲛⲁϩⲓⲱⲓϣ ⳿ⲙⲡⲁⲓⲉⲩⲁⲅⲅⲗⲓⲟⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⲫⲏⲱϥ ⳿ⲉⲧⲉ ⲑⲁⲓ ⲁⲓϥ ⲉⲩ⳿ⲉⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲉⲩⲙⲉⲩⲓ ⲛⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ⲟⲩⲟϩ Ⲓⲟⲩⲇⲁⲥ ⲡⲓⲒⲥⲕⲁⲣⲓ⳿ⲱⲧⲏⲥ ⲡⲓⲟⲩⲁⲓ ⳿ⲛⲧⲉ ⲡⲓⲓ ⲁϥϣⲉⲛⲁϥ ϩⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲧⲏⲓϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲁⲩⲣⲁϣⲒ ⲟⲩⲟϩ ⲁⲩϯ ⲛⲁϥ ⳿ⲛⲟⲩϩⲁⲧ ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ϫⲉ ⲡⲱⲥ ⳿ϥⲛⲁⲧⲏⲓϥ ϧⲉⲛ ⲟⲩⲉⲩⲕⲉⲣⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ⲟⲩⲟϩ ⲡⲓϩⲟⲩⲓⲧ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲁⲧϣⲉⲙⲏⲣ ϩⲟⲧⲉ ⲉⲩϣⲱⲧ ⳿ⲙⲡⲓⲡⲁⲥⲭⲁ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲛⲧⲉⲛϣⲉ ⳿ⲉⲑⲱⲛ ⳿ⲛⲧⲉⲛⲥⲟⲃϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲟⲩⲱⲙ ⳿ⲙⲡⲓⲡⲁⲥⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛ ⳿ⲛⲧⲉ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁⲉⲣ⳿ⲁⲡⲁⲛⲧⲁⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⲉϥϥⲁⲓ ⳿ⲛⲟⲩϣⲟϣⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲉⲧⲉϥⲛⲁϣⲉⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲁϫⲟⲥ ⳿ⲙⲡⲓⲛⲉⲃⲏⲓ ϫⲉ ⲡⲉϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ϫⲉ ⲁϥⲑⲱⲛ ⲡⲓⲙⲁ⳿ⲛⲙⲧⲟⲛ ⲡⲓⲙⲁ ⳿ⲉϯⲛⲁⲟⲩⲱⲙ⳿ⲙⲡⲓⲡⲁⲥⲭⲁ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲛⲁⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ϥⲛⲁⲧⲁⲙⲉ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲁ ⲉϥϭⲟⲥⲓ ⲉϥⲫⲟⲣϣ ⲉϥⲥⲉⲃⲧⲱⲧ ⲟⲩⲟϩ ⲥⲉⲃⲧⲱⲧϥ ⲛⲁⲛ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲁⲩϫⲓⲙⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲥⲉⲃⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ⲟⲩⲟϩ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ϣⲱⲡⲓ ⲁϥ⳿ⲓ ⲛⲉⲙ ⲡⲓⲓ̅ⲃ̅ ");
INSERT INTO copcnt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ⲉⲩⲣⲱⲧⲉⲃ ⲇⲉ ⲟⲩⲟϩ ⲉⲩⲟⲩⲱⲙ ⲡⲉϫⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⲡⲉⲑⲛⲁⲧⲏⲓⲧ ϧⲁ ⲛⲏⲉⲑⲟⲩⲱⲙ ⲛⲉⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲟⲩⲟϩ ⳿ⲉϫⲟⲥ ⲛⲁϥ ⳿ⲛⲟⲩⲁⲓ ⲟⲩⲁⲓ ϫⲉ ⲙⲏ ⲧⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲧⲉ ⲡⲓⲓ̅ⲃ̅ ⲫⲏ⳿ⲉⲧⲁϥⲥⲉⲡ ⲧⲉϥϫⲓϫ ⲛⲉⲙⲏⲓ ϧⲉⲛ ϯϫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ϫⲉ ⳿ⲡⲱⲏⲣⲓ ⲙⲉⲛ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ϥⲛⲁϣⲉⲛⲁϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧϥ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲏⲉⲧⲟⲩⲛⲁϯ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲛⲁⲛⲉⲥ ⲛⲁϥ ⲡⲉ ⳿ⲙⲡⲟⲩⲙⲁⲥϥ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ⲟⲩⲟϩ ⲉⲩⲟⲩⲱⲙ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩⲱⲓⲕ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲧⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲟϥ ⲁϥⲫⲁϣϥ ⲟⲩⲟϩ ⲁϥϯ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϭⲓ ⲫⲁⲓ ⲡⲉ ⲡⲁⲥⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ⲁⲫⲟⲧ ⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲁϥϯ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲥⲱ ⳿ⲛϧⲏⲧϥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁ⳿ⲥⲛⲟϥ ⳿ⲛⲧⲉ ϯⲇⲓ⳿ⲁⲑⲏⲕⲏⲉⲧⲟⲩⲛⲁⲫⲟⲛϥ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲉ⳿ⲡϫⲓⲛⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲟⲩⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲁⲥⲱ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲧⲁⲓⲃⲱ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲧⲏϩⲟⲧⲁⲛ ⲁⲓϣⲁⲛⲥⲟϥ ⳿ⲙⲃⲉⲣⲓ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲥⲙⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲧⲏⲣⲟⲩ ϫⲉ ⲟⲩⲏⲓ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ϯⲛⲁϣⲁⲣⲓ ⳿ⲙⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲥⲉϫⲱⲣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ⲁⲗⲗⲁ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲓⲧⲱⲛⲧ ϯⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲕⲁⲛ ⲁⲩϣⲁⲛⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲧⲏⲣⲟⲩ ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⳿ⲙⲫⲟⲟⲩ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⳿ⲙⲡⲁⲧⲉ ⲟⲩⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲛⲥⲟⲡ ⳿ⲭⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧϩⲟⲩ⳿ⲟ ϫⲉ ⲕⲁⲛ ⲁⲥϣⲁⲛⲫⲟϩ ⳿ⲛⲧ⳿ⲁⲙⲟⲩ ⲛⲉⲙⲁⲕ ⳿ⲛⲛⲁϫⲟⲗⲕ ⳿ⲉⲃⲟⲗ ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲟⲛ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲉⲩⲓⲟϩⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲅⲉⲑⲥⲏⲙⲁⲛⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ϩⲉⲙⲥⲓ ϩⲁ⳿ⲙⲛⲁⲓ ϩⲱⲥ ϯⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ⲟⲩⲟϩ ⲁϥ⳿ⲱⲗⲓ ⲛⲉⲙⲁϥ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⲟⲩⲟϩ ⳿ⲛⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲁⲯⲩⲭⲏ ⲙⲟⲕϩ ϣⲁ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲙⲟⲩ ⲟϩⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩⲟϩ ⲣⲱⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⳿ⲉ⳿ⲧϩⲏ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲛⲁϥϩⲓ ⳿ⲙⲙⲟϥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲟⲩⲟϩ ⲛⲁϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ϩⲓⲛⲁ ⲓⲥϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ϯⲟⲩⲛⲟⲩ ⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲃⲃⲁ Ⲫ̇ⲓⲱⲧ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ϧⲁⲧⲟⲧⲕ ⲙⲁⲣⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲓ ⲁⲗⲗⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉϩⲛⲏⲓ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉϩⲛⲁⲕ ⳿ⲛⲑⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲁϥϫⲉⲙⲟⲩ ⲉⲩⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙⲠⲉⲧⲣⲟⲥ ϫⲉ Ⲥⲓⲙⲱⲛ ⳿ⲕⲉⲛⲕⲟⲧ ⳿ⲙⲡⲉⲕ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲣⲱⲓⲥ ⲛⲉⲙⲏⲓ ⳿ⲛⲟⲩⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ⲣⲱⲓⲥ ⲟⲩⲛ ⲟⲩⲟϩ ⳿ⲁⲣⲓ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ ⲡⲓⲡ͞ⲛⲁ̅ ⲙⲉⲛ ⳿ϥⲣⲱⲟⲩⲧ ϯⲥⲁⲣⲝ ⲇⲉ ⲟⲩⲁⲥⲑⲉⲛⲏⲥ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⳿ⲉⲧⲁϥϣⲉⲛⲁϥ ⲛⲁϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲁϥϫⲉ ⲡⲁⲓⲥⲁϫⲓ ⲣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲟⲛ ⲁϥϫⲉⲙⲟⲩ ⲉⲩⲉⲛⲕⲟⲧ ⲛⲁⲣⲉ ⲛⲟⲩⲃⲁⲗ ⲅⲁⲣ ϩⲟⲣϣ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲉⲙⲓ ⲁⲛ ⲡⲉ ϫⲉ ⲟⲩ ⲉⲧⲟⲩⲛⲁⲉⲣⲟⲩⲱ ⳿ⲙⲙⲟϥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲙⲡⲓⲙⲁϩⲅ̅ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲛⲕⲟⲧ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ϯⲟⲩⲛⲟⲩ ϩⲏⲡⲡⲉ ⲥⲉⲛⲁϯ ⳿ⲙⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁⲣⲟⲛ ϩⲏⲡⲡⲉ ⲁϥϧⲱⲛⲧ ⳿ⲛϫⲉ ⲫⲏⲉⲑⲛⲁⲧⲏⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲟⲩⲟϩ ⲁϥϯⲫⲓ ⳿ⲉⲣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲉⲛ ⲛⲟⲩϫⲓϫ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ⲟⲩⲁⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲁϥⲑⲉⲕⲉⲙ ϯⲥⲏϥⲓ ⳿ⲉⲁϥϯ ⳿ⲛⲟⲩϣⲁϣ ⳿ⲙ⳿ⲫⲃⲱⲕ ⳿ⲙⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥⲙⲁϣϫ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲛⲥⲁ ⲟⲩⲥⲟⲛⲓ ⲛⲉⲙ ϩⲁⲛⲥⲏϥⲓ ⲛⲉⲙ ϩⲁⲛϣⲉ ⳿ⲉⲧⲁϩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ⲛⲁⲓⲭⲏϩⲁⲣⲱⲧⲉⲛ ⳿ⲙⲙⲏⲛⲓ ⲉⲓϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟⲓ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲅⲣⲁⲫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲭⲁϥ ⲁⲩⲫⲱⲧ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲟⲩⲟⲛ ⲟⲩϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲉϥϫⲏⲗ ⳿ⲛⲟⲩⲥⲩⲛⲇⲟⲛⲓⲟⲛ ⳿ⲉϫⲉⲛ ⲡⲉϥⲃⲱϣ ⲟⲩⲟϩ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲥⲱϫⲡ ⳿ⲛϯⲥⲩⲛⲇⲟⲛⲓⲟⲛ ⲁϥⲫⲱⲧ ⲉϥⲃⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ⲟⲩⲟϩ ⲁⲩϭⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ϩⲁ ⲛⲓⲁⲣⲭⲉⲓⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ");
INSERT INTO copcnt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ⲟⲩⲟϩ Ⲡⲉⲧⲣⲟⲥ ⲛⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ϩⲓⲫⲟⲩⲉⲓ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲁⲩⲗⲏ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲛⲁϥⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛϩⲉⲙⲥⲓ ⲛⲉⲙ ⲛⲓϩⲩⲡⲉⲣⲉⲧⲏⲥ ⲟⲩⲟϩ ⲉϥ⳿ⲧϧⲙⲟⲙ ⳿ⲙⲙⲟϥ ϧⲁⲧⲉⲛ ⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲛⲉⲙ ⲡⲓⲙⲁ⳿ⲛϯϩⲁⲛ ⲧⲏⲣϥ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲉⲧⲙⲉⲑⲣⲉ ϧⲁ Ⲓⲏ̅ⲥ̅ ⲉ⳿ⲡϫⲓⲛϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲛⲁⲩϫⲓⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ⲛⲁⲣⲉ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ϧⲁⲣⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲟⲓ ⳿ⲛϩⲩⲥⲟⲥ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲟⲩⲙⲉⲧⲙⲉⲑⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⲁⲩⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ϧⲁⲣⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ϫⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲃⲱⲗ ⳿ⲙⲡⲁⲓⲉⲣⲫⲉⲓ ⳿ⲉⲃⲟⲗ ⲡⲁⲓⲙⲟⲩⲛⲕ ⳿ⲛϫⲓϫ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲕⲉⲟⲩⲁⲓ ⳿ⲛⲁⲑⲙⲟⲩⲛⲕ ⳿ⲛϫⲓϫ ϯⲛⲁⲕⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ⲟⲩⲇⲉ ⲡⲁⲓⲣⲏϯ ⲛⲁⲥⲟⲓ ⳿ⲛϩⲩⲥⲟⲥ ⲁⲛ ⳿ⲛϫⲉ ⲧⲟⲩⲙⲉⲧⲙⲉⲑⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲉⲑⲙⲏϯ ⲁϥϣⲉⲛ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛ⳿ⲕⲉⲣⲟⲩⲱ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ϫⲉ ⲛⲁⲓ ⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥⲭⲱ ⳿ⲛⲣⲱϥ ⲡⲉ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛ⳿ϩⲗⲓ ⲡⲁⲗⲓⲛ ⳿ⲁ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ϣⲉⲛϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫⲏⲉⲧ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲛⲁⲩ ⳿ⲉⲠ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲛϯϫⲟⲙ ⲟⲩⲟϩ ⲉϥⲛⲏⲟⲩ ⲛⲉⲙ ⲛⲓϭⲏⲡⲓ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⳿ⲉⲧⲁϥⲫⲱϧ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩ ⲟⲛ ⳿ⲉⲧⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲉⲑⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ⲁⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓϫⲉⲟⲩⲁ ⲟⲩ ⲉⲑⲟⲩⲟⲛϩ ⲛⲱⲧⲉⲛ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲧⲏⲣⲟⲩ ⲁⲩ⳿ⲣⲕⲁⲧⲁ⳿ⲕⲣⲓⲛⲓⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ϥⲟⲓ ⳿ⲛⲉⲛⲟⲭⲟⲥ ⳿ⲉ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉϩⲓⲑⲁϥ ϧⲉⲛ ⳿ϩⲣⲁϥ ⲟⲩⲟϩ ⳿ⲉϩⲱⲃⲥ ⳿ⲙⲡⲉϥϩⲟ ⲟⲩⲟϩ ⳿ⲉϯⲕⲉϩ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉϫⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲁⲣⲓ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⲛⲁⲛ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϩⲓⲟⲩ⳿Ⲓ ⳿ⲉⲣⲟⲕ ϯⲛⲟⲩ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⲛⲓϩⲩⲡⲉⲣⲉⲧⲏⲥ ⲁⲩϭⲓⲧϥ ⲛϩⲁⲛⲁⲗⲱϫ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ⲟⲩⲟϩ ⳿ⲉⲣⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ϯⲁⲩⲗⲏⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲃⲱⲕⲓ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭ ⲓⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥⲛⲁⲩ ⳿ⲉⲠⲉⲧⲣⲟⲥ ⲉϥ⳿ⲧ⳿ϧⲙⲟⲙ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥϫⲟⲩϣⲧ ⳿ⲉⲣⲟϥ ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⲛⲁⲕⲭⲏ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲇⲉ ⳿ⲛϯ⳿ⲉⲙⲓ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛϯⲥⲱⲟⲩⲛ ⲁⲛ ϫⲉ ⲟⲩ ⳿ⲛⲑⲟ ⲡⲉⲧⲉϫⲱ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲙⲁ ⲉⲧⲥⲁⲃⲟⲗ ⳿ⲛⲧⲉ ϯⲁⲩⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ϯⲭⲉϯ ⲡⲉϫⲁⲥ ⳿ⲛⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϫⲉ ⲫⲁⲓ ⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","⳿ⲛⲑⲟϥ ⲇⲉ ⲟⲛ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⲙⲉⲛⲉⲛⲥⲁ ⲟⲩⲕⲟⲩϫⲓ ⲡⲁⲗⲓⲛ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲠⲉⲧⲣⲟⲥ ϫⲉ ⲁⲗⲏⲑⲱⲥ ⳿ⲛⲑⲟⲕ ⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲕⲉ ⲅⲁⲣ ⳿ⲛⲑⲟⲕ ⲟⲩⲄⲁⲗⲓⲗⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣⲁⲛⲁⲑⲉⲙⲁⲧⲓⲍⲓⲛ ⲛⲉⲙ ⲱⲣⲕ ϫⲉ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ⲁⲛ ⳿ⲉⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲛϫⲉ ⲟⲩⲁⲗⲉⲕⲧⲱⲣ ⳿ⲙ⳿ⲫⲙⲁϩⲥⲟⲡⲃ̅ ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥϫⲟⲥ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲟⲩⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲛⲥⲟⲡⲃ̅ ⳿ⲭⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛⲅ̅ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓⲧⲟⲧϥ ⲁϥⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲥⲟϭⲛⲓ ⳿ⲛⲟⲩⲥⲟϭⲛⲓ ⳿ⲛϣⲱⲣⲡ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲡⲓⲙⲁ⳿ⲛϯϩⲁⲡ ⲧⲏⲣϥ ⲁⲩⲥⲱⲛϩ ⳿ⲛⲒⲏ̅ⲥ̅ ⲁⲩϭⲓⲧϥ ⲁⲩⲧⲏⲓϥ ⳿ⲙⲠⲓⲗⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ⲟⲩⲟϩ ⲁϥϣⲉⲛϥ ⳿ⲛϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ⲟⲩⲟϩ ⲛⲁⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲛϩⲁⲛⲙⲏϣ ϧⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲟⲛ ⲛⲁϥϣⲉⲛϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲇⲉ ⳿ⲛ⳿ⲕⲉⲣⲟⲩⲱ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⳿ⲁⲛⲁⲩ ϫⲉ ⲥⲉⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟⲕ ⳿ⲛⲟⲩⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲙⲡⲉϥϫⲉ ⲉⲣⲟⲩⲱ ⳿ⲛ⳿ϩⲗⲓ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲛϫⲉ Ⲡⲓⲗⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ⲕⲁⲧⲁ ⳿ⲡϣⲁⲓ ⲇⲉ ⲛⲁϥⲭⲱ ⳿ⲛⲟⲩⲁⲓ ⲉϥⲥⲟⲛϩ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲫⲏ⳿ⲉϣⲁⲩⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲃⲁⲣⲁⲃⲃⲁⲥ ⲛⲁϥⲥⲟⲛϩ ⲡⲉ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲛⲏ⳿ⲉⲛⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩϧⲱⲧⲉⲃ ϧⲉⲛ ⳿ⲡ⳿ϣⲑⲟⲣⲧⲉⲣ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣ⳿ⲉⲧⲓⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲛⲁϥ⳿⳿ⲓⲣⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲛⲧⲁⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ⲛⲁϥ⳿ⲉⲙⲓ ⲅⲁⲣ ⲡⲉ ϫⲉ ⳿ⲉⲧⲁⲩⲧⲏⲓϥ ⲉⲑⲃⲉ ⲟⲩ⳿ⲫⲑⲟⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲁⲩⲕⲓⲙ ⳿ⲙⲡⲓⲙⲏϣ ϩⲓⲛⲁ ⲙⲁⲗⲗⲟⲛ ⳿ⲛⲧⲉϥⲭⲁ ⲃⲁⲣⲃⲃⲁⲥ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲟⲩⲛ ⲡⲉϯⲛⲁⲁⲓϥ ⳿ⲙⲫⲏ⳿ⲉⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲟⲛ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ⲡⲓⲗⲁⲧⲟⲥ ⲅⲁⲣ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲡⲉⲧⲁϥⲁⲓϥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲛϩⲟⲩ⳿ⲟ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉⲉⲣ ⲡⲉⲧⲉϩⲛⲉ ⲡⲓⲙⲏϣ ⲁϥⲭⲁ Ⲃⲁⲣⲁⲃⲃⲁⲥ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲁϥϯ ⲇⲉ ⳿ⲛⲒⲏ̅ⲥ̅ ⲉⲉⲣ⳿ⲫⲣⲅⲉⲗⲗⲓⲛ ⳿ⲙⲙⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ⲛⲓⲙⲁⲧⲟⲓ ⲇⲉ ⲁⲩϭⲓⲧϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲁⲩⲗⲏ⳿ⲛⲧⲉ ⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩϯ ⳿ⲉϯ⳿ⲥⲡⲓⲣⲁ ⲧⲏⲣⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ⲟⲩⲟϩ ⲁⲩϯ ϩⲓⲱⲧϥ ⳿ⲛⲟⲩ⳿ϩⲃⲟⲥ ⳿ⲛϭⲏϫⲓ ⲟⲩⲟϩ ⲁⲩϣⲱⲛⲧ ⳿ⲛⲟⲩ⳿ⲭⲗⲟⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ϩⲁⲛⲥⲟⲩⲣⲓ ⲁⲩⲭⲁϥ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲙⲙⲟϥ ϫⲉ ⲭⲉⲣⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ⲟⲩⲟϩ ⲁⲩϩⲓⲟⲩ⳿ⲓ ϧⲉⲛ ⲧⲉϥⲁⲫⲉ ⳿ⲛⲟⲩⲕⲁϣ ⲟⲩⲟϩ ⲛⲁⲩϩⲓⲑⲁϥ ϧⲉⲛ ⲡⲉϥϩⲟ ⲟⲩⲟϩ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϫⲉⲛ ⳿ⲛⲟⲩⲕⲉⲗⲓ ⳿ⲉⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ⲟⲩⲟϩ ϩⲟⲧⲉ ⳿ⲉⲧⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲁⲩⲃⲁϣϥ ⳿ⲙⲡⲓ⳿ϩⲃⲟⲥ ⳿ⲛϭⲏϫⲓ ⲟⲩⲟϩ ⲁⲩϯ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ϩⲓⲱⲧϥ ⲟⲩⲟϩ ⲁⲩⲉⲛϥ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ⲟⲩⲟϩ ⲁⲩϭⲓ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛ⳿ⲭⲃⲁ ⲉϥⲥⲓⲛⲓⲱⲟⲩ Ⲥⲓⲙⲱⲛ ⲡⲓⲔⲩⲣⲓⲛⲛⲉⲟⲥ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲕⲟⲓ Ⲫ̇ⲓⲱⲧ ⳿ⲛⲁⲗⲉⲝⲁⲛⲇⲣⲟⲥ ⲛⲉⲙ ⲣⲟⲩⲫⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥ ");
INSERT INTO copcnt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ⲟⲩⲟϩ ⲁⲩⲉⲛϥ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛⲧⲉ Ⲅⲟⲗⲅⲟⲑⲁ ⲫⲁⲓ ⲉϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ ⲡⲓⲙⲁ ⳿ⲛⲧⲉ ⲡⲓⲔ̇ⲣⲁⲛⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ⲟⲩⲟϩ ⲁⲩϯ ⲛⲁϥ ⳿ⲛⲟⲩⲏⲣⲡ ⲉϥⲙⲟϫⲧ ⲛⲉⲙ ⲟⲩϣⲁϣⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲉϥϭⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ⲟⲩⲟϩ ⲁⲩⲁϣϥ ⲟⲩⲟϩ ⲁⲩⲫⲱϣ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲉⲁⲩϩⲓⲱⲡ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⲉⲑⲛⲁⲟⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ⲛⲉ ⳿ⲫⲛⲁⲩ ⲇⲉ ⳿ⲛⲁϫⲡⲅ̅ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ⲟⲩⲟϩ ϯ⳿ⲉⲡⲓ⳿ⲅⲣⲁⲫⲏ⳿ⲛⲧⲉ ⲧⲉϥ⳿ⲉⲧⲓⲁ ⲛⲁⲥ⳿ⲥϧⲏⲟⲩⲧ ⲡⲉ ϫⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ⲟⲩⲟϩ ⲁⲩⲉϣ ⲕⲉⲥⲟⲛⲓ ⲃ̅ ⲛⲉⲙⲁϥ ⲟⲩⲁⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⲟⲩⲁⲓ ⲥⲁϫⲁϭⲏ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ⲟⲩⲟϩ ϯⲅⲣⲁⲫⲏϫⲱⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁⲩⲟⲡϥ ⲛⲉⲙ ⲛⲓⲁⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲛⲁⲩⲥⲓⲛⲓ ⲛⲁⲩϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟϥ ⲉⲩⲕⲓⲙ ⳿ⲛⲛⲟⲩ⳿ⲁⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁⲃⲉⲗ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲑⲛⲁⲕⲟⲧϥ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ⲛⲁϩⲙⲉⲕ ⳿ⲉⲁⲕ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓ ");
INSERT INTO copcnt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ⲡⲁⲓⲣⲏϯ ⲛⲓⲕⲉⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲉⲩⲥⲱⲃⲓ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲛⲟϩⲉⲙ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲁϩⲙⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ⲡⲭ̅ⲥ̅ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲙⲁⲣⲉϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ϯⲛⲟⲩ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲓ⳿ⲥⲧⲁⲩⲣⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲛⲁϩϯ ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲁⲩⲁϣⲟⲩ ⲛⲉⲙⲁϥ ⲛⲁⲩϯϣⲱϣ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ⲟⲩⲟϩ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲎ̇ⲗⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","⳿ⲉⲧⲁϥϭⲟϫⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⲁϥⲙⲁϩ ⲟⲩ⳿ⲥⲫⲟⲅⲅⲟⲥ ⳿ⲛϩⲉⲙϫ ⲁϥⲧⲁⲗⲟϥ ⳿ⲉϫⲉⲛ ⲟⲩⲕⲁϣ ⲁϥ⳿ⲧⲥⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲁϥ ⳿ⲛⲧⲉⲛⲛⲁⲩ ϫⲉ Ⲏ̇ⲗⲓⲁⲥ ⲛⲏⲟⲩ ⳿ⲛⲧⲉϥ⳿ⲉⲛϥ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲁϥϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ");
INSERT INTO copcnt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ⲟⲩⲟϩ ⲡⲓⲕⲁⲧⲁⲡⲉⲧⲁⲥⲙⲁ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲁϥⲫⲱϧ ϧⲉⲛ ⲃ̅ ⲓⲥϫⲉⲛ ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲫⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ ϫⲉ ⲁϥϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ⲡⲉϫⲁϥ ϫⲉ ⲁⲗⲏⲑⲱⲥ ⲡⲁⲓⲣⲱⲙⲓ ⲛⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲕⲉϩⲓ⳿ⲟⲙⲓ ⲇⲉ ⲡⲉ ⲉⲩⲛⲁⲩ ϩⲓⲫⲟⲩⲉⲓ ⲛⲉ ⲉⲛⲁⲣⲉ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲡⲓⲕⲟⲩϫⲓ ⲛⲉⲙ ⳿ⲑⲙⲁⲩ ⳿ⲛⲓⲱⲥⲏⲧⲟⲥ ⲛⲉⲙ ⲥⲁⲗⲱⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ⲛⲁⲓ ⲉⲛⲁⲩⲟⲩⲉϩ ⳿ⲛⲥⲱϥ ϩⲟⲧⲉ ⲉϥⲭⲏ ϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲕⲉⲙⲏϣ ⲉⲁⲩ⳿ⲓ ⲛⲉⲙⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ");
INSERT INTO copcnt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ⲟⲩⲟϩ ϩⲏⲇⲏ ⳿ⲉⲧⲁ ⲣⲟⲩϩⲓ ϣⲱⲡⲓ ⲉⲡⲓⲇⲏⲛⲉ ϯⲡⲁⲣⲁⲥⲕⲉⲩ⳿ⲏ ⲧⲉ ⲉⲧϧⲁϫⲱϥ ⳿ⲙ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","✠ ");
INSERT INTO copcnt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭ ⲟⲥ ⲁϥϯ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲒⲱⲥⲏⲫ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲉⲡ ⲟⲩϣⲉⲛⲧⲱ ⲁϥ⳿ⲉⲛϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲁϥⲕⲟⲩⲗⲱⲗϥ ϧⲉⲛ ⲟⲩϣⲉⲛⲧⲱ ⲟⲩⲟϩ ⲁϥⲭⲁϥ ϧⲉⲛ ⲟⲩ⳿ⲙϩⲁⲩ ⲫⲏⲉⲧϣⲏⲕ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲡⲉⲧⲣⲁ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲕⲉⲣⲕⲉⲣ ⳿ⲙⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲓⲱⲥⲏⲧⲟⲥ ⲛⲁⲩⲛⲁⲩ ⲡⲉ ϫⲉ ⳿ⲉⲧⲁⲩⲭⲁϥ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ Ⲙⲁⲣⲓ⳿ⲁ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲥⲁⲗⲱⲙⲏⲁⲩϣⲉⲛⲱⲟⲩ ⲁⲩϣⲱⲡ ⳿ⲛϩⲁⲛ⳿ⲥⲑⲟⲓⲛⲟⲩϥⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿Ⲓ ⳿ⲛⲧⲟⲩⲑⲁϩⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ⲟⲩⲟϩ ⳿ⲛϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⳿ⲉⲙⲁϣⲱ ⳿ⲙ⳿ⲫⲟⲩⲁⲓ ⳿ⲛⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲩ⳿ⲓ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲉⲧⲁ ⳿ⲫⲣⲏ ϣⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ⲥⲕⲉⲣⲕⲉⲣ ⳿ⲙⲡⲓ⳿ⲱⲛⲓ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϥⲁⲓ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⲁⲩⲛⲁⲩ ⳿ⲉⲡⲓ⳿ⲱⲛⲓ ϫⲉ ⲁⲩ⳿ⲥⲕⲉⲣⲕⲱⲣϥ ⲛⲉ ⲟⲩⲛⲓϣϯ ⲅⲁⲣ ⳿ⲉⲙⲁϣⲱ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲁⲩⲛⲁⲩ ⳿ⲉⲟⲩϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⲉϥϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⲉϥϫⲏⲗ ⳿ⲛⲟⲩ⳿ⲥⲧⲟⲗⲏⲉⲥⲟⲩⲟⲃϣ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ Ⲓⲏ̅ⲥ̅ ⲡⲉⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ⲫⲏ⳿ⲉⲧⲁⲩⲁϣϥ ⲁϥⲧⲱⲛϥ ⳿ϥϩⲁ⳿ⲙⲛⲁⲓ ⲁⲛ ⲓⲥ ⲡⲓⲙⲁ ⳿ⲉⲧⲁⲩⲭⲁϥ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ⲁⲗⲗⲁ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲁϫⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲛⲉⲙ Ⲡⲉⲧⲣⲟⲥ ϫⲉ ⳿ϥⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲁⲣⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩⲫⲱⲧ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓ⳿ⲙϩⲁⲩ ⲛⲉ ⳿ⲁ ⲟⲩ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲅⲁⲣ ⲧⲁϩⲱⲟⲩ ⲡⲉ ⲛⲉⲙ ⲟⲩⲧⲱⲙⲧ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩϫⲉ ⳿ϩⲗⲓ ⳿ⲛ⳿ϩⲗⲓ ⲛⲁⲩⲉⲣϩⲟϯ ⲅⲁⲣ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϩⲟⲩⲓⲧ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲘⲁⲣⲓ⳿ⲁ ϯⲘⲁⲅⲇⲁⲗⲓⲛⲏ ⲑⲏ⳿ⲉⲧⲁϥϩⲓ ⲡⲓⲍ̅ ⳿ⲛⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ⲑⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲥϣⲉⲛⲁⲥ ⲁⲥϫⲟⲥ ⳿ⲛⲛⲏⲉⲛⲁⲩϣⲱⲡⲓ ⲛⲉⲙⲁϥ ⲉⲩⲉⲣϩⲏⲃⲓ ⲟⲩⲟϩ ⲉⲩⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⳿ϥⲟⲛϧⲟⲩⲟϩ ϫⲉ Ⲁⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲛⲁⲩⲟⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲟⲛ ⲛⲁⲣⲉ ⲃ̅ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲩⲙⲟϣⲓ ϩⲓ ⲟⲩⲙⲱⲓⲧ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲕⲉⲙⲟⲣⲫⲏϧⲉⲛ ⳿ⲧⲕⲟⲓ ");
INSERT INTO copcnt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ⲟⲩⲟϩ ⲛⲁⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲁⲩϣⲉⲛⲱⲟⲩ ⲁⲩϫⲟⲥ ⳿ⲛⲛⲓⲥⲱϫⲡ ⲟⲩⲟϩ ⲛⲁⲓ ⲟⲛ ⳿ⲙⲡⲟⲩⲛⲁϩϯ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲉⲩⲣⲱⲧⲉⲃ ⳿ⲛϫⲉ ⲡⲓⲓ̅ⲁ̅ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥϯϣⲱϣ ⳿ⲛⲧⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ⲛⲉⲙ ⲧⲟⲩⲙⲉⲑⲛⲁϣⲧϩⲏ ⲧ ϫⲉ ⳿ⲙⲡⲟⲩⲛⲁϩϯ ⳿ⲉⲛⲏ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲉⲧⲁϥⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲙⲡⲓⲥⲱⲛⲧ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ⲫⲏ⳿ⲉⲧⲁϥⲛⲁϩϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓⲱⲙⲥ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁϥⲉⲣⲁⲑⲛⲁϩϯ ⲥⲉⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ⲛⲁⲓⲙⲏⲓⲛⲓ ⲇⲉ ⲉⲩ⳿ⲉⲙⲟϣⲓ ⳿ⲛⲥⲁ ⲛⲏⲉⲑⲛⲁϩϯ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲉⲩ⳿ⲉϩⲓ ϩⲁⲛⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲉⲩ⳿ⲉⲥⲁϫⲓ ϧⲉⲛ ϩⲁⲛⲁⲥⲡⲓ ⳿ⲛⲗⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ⲟⲩⲟϩ ϩⲁⲛϩⲟϥ ⲉⲩ⳿ⲉϥⲓⲧⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲟⲩϫⲓϫ ⲕⲁⲛ ⲁⲩϣⲁⲛⲟⲩⲱⲙ ⳿ⲛⲟⲩⲉⲛⲭⲁⲓ ⳿ⲉ⳿ⲫⲙⲟⲩ ⳿ⲛⲛⲉϥⲉⲣ⳿ⲃⲗⲁⲡⲧⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲭⲱ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉϫⲉⲛ ϩⲁⲛⲟⲩⲟⲛ ⲉⲩϣⲱⲛⲓ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲟⲩϫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ⲡ⳪ ⲟⲩⲛ Ⲓⲏ̅ⲥ̅ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲉϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲁⲩⲟⲗϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲁϥϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲪ̇ⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ⲛⲏⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩϩⲓⲱⲓϣ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲁⲣⲉ Ⲡ⳪ ⲉⲣϩⲱⲃ ⲛⲉⲙⲱⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲉϥⲧⲁϫⲣⲟ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲛⲓⲙⲏⲓⲛⲓ ⲉⲑⲙⲟϣⲓ ⳿ⲛⲥⲱⲟⲩ ϣⲁ ⳿⳿ⲉⲛⲉϩ ⳿ⲛⲧⲉ ⲛⲓ⳿⳿ⲉⲛⲉϩ ⲧⲏⲣⲟⲩ ⳿ⲁⲙⲏⲛ ⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲍⲱⲏⲥ ⲕⲁⲧⲁ ⲙⲁⲣⲕⲟⲛ ⳿ⲉⲛⲉⲏⲣⲏⲛⲏⲧⲱ ⲕ̅ⲱ̅ ⳿ⲁⲙⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ⲉⲡⲓⲇⲏ ⲟⲩⲙⲏϣ ⲩϩⲓⲧⲟⲧⲟⲩ ⲉ⳿ⲥϧⲉ ϩⲁⲛⲥⲁϫⲓ ⲉⲑⲃⲉ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⲉⲧⲁⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲩϯ ⳿ⲉⲧⲟⲧⲉⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓϣⲟⲣⲡ ⲉⲧⲁⲩⲛⲁⲩ ⲩⲟϩ ⲁⲩϣⲱⲡⲓ ⲉⲩⲟⲓ ⳿ⲛⲣⲉϥϣⲉⲙϣⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ⲁⲥⲣⲁⲛⲏⲓ ϩⲱ ⳿ⲉⲁⲓⲙⲟϣⲓ ⳿ⲛⲥⲁ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⳿ⲉ⳿ⲥϧⲁⲓ ⲛⲁⲕ ⳿ⲉ⳿ⲫⲣⲏϯ ⳿ⲕⲣⲁⲧⲓⲥⲧⲉ ⲉⲟⲫⲓⲗⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲥⲟⲩⲉⲛ ⲡⲓⲧⲁϫⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲥⲁϫⲓ ⲛⲏⲉⲧⲁⲩⲉⲣⲕⲁⲑⲏⲭⲓⲛ ⳿ⲙⲙⲟⲕ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲛⲧⲉ ⲏⲣⲱⲇⲏⲥ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲟⲩⲏⲃ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲍⲁⲭⲁⲣⲓⲁⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϣⲉⲙϣⲓ ⳿ⲛⲧⲉ ⲁⲃⲓ⳿ⲁ ⲟⲩⲟϩ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲧⲉ ϧⲉⲛ ⲛⲓϣⲉⲣⲓ ⳿ⲛⲧⲉ ⳿ⲁ⳿ⲁⲣⲱⲛ ⲟⲩⲟϩ ⲡⲉⲥⲣⲁⲛ ⲡⲉ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ⲛⲉ ϩⲁⲛ⳿ⲑⲙⲏⲓ ⲇⲉ ⳿ⲙ⳿ⲡⲃ̅ ⲛⲉ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ ⲉⲩⲙⲟϣⲓ ϧⲉⲛ ⲓ⳿ⲉⲛⲧⲟⲗⲏ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ⲉⲩⲟⲓ ⳿ⲛⲁⲧⲁⲣⲓⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ⲟⲩⲟϩ ⲛⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ϣⲏⲣⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ ϫⲉ ⲟⲩⲏⲓ ⲛⲉ ⲟⲩⲁⲧϭⲣⲏⲛ ⲧⲉ ⲉⲗⲓⲥⲁⲃⲉⲧ ⲟⲩⲟϩ ⲛⲉ ⲁⲩⲁⲓⲁⲓ ⳿ⲙ⳿ⲡⲃ̅ ⲡⲉ ϧⲉⲛ ⲛⲟⲩ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉϥ⳿ⲓⲣⲓ ⳿ⲛⲧⲉϥⲙⲉⲧⲟⲩⲏⲃ ϧⲉⲛ ϯⲧⲁⲝⲓⲥ ⳿ⲛⲧⲉ ⲛⲉϥ⳿ⲉϩⲟⲟⲩ ⳿ⲛϣⲉⲙϣⲓ ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ⲕⲁⲧⲁ ϯⲕⲁϩⲥ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲏⲃ ⲁ ⲡⲓⲱⲡ ⳿ⲓ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ⲉⲛ ⳿ⲥⲑⲟⲓⲛⲟⲩϥⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲁⲩⲧⲱⲃϩ ⲥⲁⲃⲟⲗ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲙⲡⲓ⳿ⲥⲑⲟⲓⲛⲟⲩϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ⲁϥⲟⲩⲱⲛϩ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲡⲓⲙⲁ⳿ⲛⲉⲣϣⲱⲟⲩϣⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲥⲑⲟⲓⲛⲟⲩϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ ⲍⲁⲭⲁⲣⲓⲁⲥ ϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⲟⲩⲟϩ ⲩϩⲟϯ ⲁⲥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲍⲁⲭⲁⲣⲓⲁⲥ ϫⲉ ⲟⲩⲏⲓ ⲁⲩⲥⲱⲧⲉⲙ ⲉⲡⲉⲕⲧⲱⲃϩ ⲟⲩⲟϩ ⲧⲉⲕ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ ⲉⲥ⳿ⲉⲙⲓⲥⲓ ⲛⲁⲕ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲟⲩⲟϩ ⲉⲕ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ⲟⲩⲟϩ ⲉⲣⲉ ⲟⲩⲣⲁϣⲓ ⲱⲡⲓ ⲁⲕ ⲛⲉⲙ ⲟⲩⲑⲉⲗⲏⲗ ⲟⲩⲟϩ ⲉⲣⲉ ⲟⲩⲙⲏϣ ⲣⲁϣⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥϫⲓⲛⲙⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","⳿ϥⲛⲁϣⲱⲡⲓ ⲅⲁⲣ ⲉϥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲠ⳪ ⲟⲩⲟϩ ⲟⲩⲏⲣⲡ ⲛⲉⲙ ⲩⲥⲓⲕⲉⲣⲁ ⳿ⲛⲛⲉϥⲥⲱⲟⲩ ⲟⲩⲟϩ ⳿ϥⲛⲁⲙⲟϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲓⲥϫⲉⲛ ⲉϥϧⲉⲛ ⳿ⲑⲛⲉϫⲓ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ⲟⲩⲟϩ ⲉϥ⳿ⲉ⳿ⲑⲣⲉ ⲟⲩⲙⲏϣ ⳿ⲛⲧⲉ ⲉⲛϣⲏⲣⲓ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲕⲟⲧⲟⲩ ⳿ⲉⲠ⳪ ⲡⲟⲩⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ϥⲛⲁⲉⲣϣⲟⲣⲡ ⳿ⲛ⳿ⲓ ϧⲁϫⲱϥ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲛⲉⲙ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲏⲗⲓⲁⲥ ⲉⲧⲁⲥⲑⲉ ⳿ⲡϩⲏⲧ ⳿ⲛϩⲁⲛⲓⲟϯ ⳿ⲉⲛⲟⲩϣⲏⲣⲓ ⲛⲉⲙ ⲛⲏⲉⲧⲟⲓ ⳿ⲛⲁⲧⲑⲱⲧ ⳿ⲛϩⲏⲧ ϧⲉⲛ ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲑⲙⲏⲓ ⳿ⲉⲥⲉⲃⲧⲉ ⲟⲩⲗⲁⲟⲥ ⳿ⲙⲠ⳪ ⳿ⲉⲁⲩ⳿ⲑⲙⲁⲓⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ⲩⲟϩ ⲡⲉϫⲉ ⲍⲁⲭⲁⲣⲓⲁⲥ ⳿ⲙⲡⲓⲁⲅⲅⲉⲗⲟⲥ ϫⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲟⲩ ϯⲛⲁ⳿ⲉⲙⲓ ⳿ⲉⲫⲁⲓ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲟⲩϧⲉⲗⲗⲟ ⲟⲩⲟϩ ⲧⲁ⳿ⲥϩⲓⲙⲓ ⲁⲥⲁⲓⲁⲓ ϧⲉⲛ ⲛⲉⲥ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲅⲁⲃⲣⲓⲏⲗ ⲫⲏⲉⲧⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲁⲩⲧⲁⲟⲩⲟⲓ ⳿ⲉⲥⲁϫⲓ ⲉⲙⲁⲕ ⲟⲩⲟϩ ⳿ⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲁⲕ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲉⲕ⳿ⲉϣⲱⲡⲓ ⲉⲕⲭⲱ ⳿ⲛⲣⲱⲕ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲥⲁϫⲓ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲉ ⲁⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⳿ⲙ⳿ⲫⲙⲁ ϫⲉ ⳿ⲙⲡⲉⲕⲛⲁϩϯ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲛⲁⲓ ⲉⲑⲛⲁϫⲱⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲟⲩⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⳿ⲛⲍⲁⲭⲁⲣⲓⲁⲥ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏ ⲣⲓ ⲡⲉ ⲉⲑⲃⲉϫⲉ ⲁϥⲱⲥⲕ ⳿ⲛϧⲟⲩⲛ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲛⲁϥ⳿ϣϫⲉⲙϫⲟⲙ ⲛⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲁⲛ ⲡⲉ ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲟⲩⲱⲛϩ ⲡⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲟⲩⲛ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥϭⲱⲣⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲡⲉ ⲟⲩⲟϩ ϥⲟϩⲓ ϥⲟⲓ ⳿ⲛ⳿ⲉⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁⲩⲙⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲉϥ⳿ⲉϩⲟⲟⲩ ⳿ⲛϣⲉⲙϣⲓ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲥⲉⲣⲃⲟⲕⲓ ⳿ⲛϫⲉ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲛⲁⲥϩⲱⲡ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛⲉ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ϫⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉⲧⲁ Ⲡ⳪ ⲁⲓϥ ⲏⲓ ⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲣⲟⲓ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲱⲗⲓ ⳿ⲙⲡⲁϣⲱϣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ϧⲉⲛ ⲡⲓⲁⲃⲟⲧ ⲇⲉ ⳿ⲙⲙⲁϩⲋ̅ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛⲅⲁⲃⲣⲓⲏⲗ ⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲛⲁⲍⲁⲣⲉⲑ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ϩⲁ ⲟⲩⲡⲁⲣⲑⲉⲛⲟⲥ ⳿ⲉⲁⲩⲱⲡ ⳿ⲛⲥⲱⲥ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲓⲱⲥⲏⲫ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲇⲁⲩⲓⲇ ⲟⲩⲟϩ ⳿ⲫⲣⲁⲛ ⳿ⲛϯⲡⲁⲣⲑⲉⲛⲟⲥ ⲡⲉ ⲙⲁⲣⲓⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ⲟⲩⲟϩ ⲉⲧⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲟⲥ ⲡⲉϫⲁϥ ⲁⲥ ϫⲉ ⲭⲉⲣⲉ ⲑⲏ ⲉⲑⲙⲉϩ ⳿ⲛ⳿ϩⲙⲟⲧ Ⲡ⳪ ⲛⲉⲙⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","⳿ⲛⲑⲟⲥ ⲇⲉ ⲁⲥ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲉϫⲉⲛ ⲡⲁⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲛⲁⲥⲙⲟⲕⲙⲉⲕ ⲡⲉ ϫⲉ ⲟⲩ ⲁϣ ⳿ⲛⲣⲏϯ ⲡⲉ ⲡⲁⲓⲁⲥⲡⲁⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲛⲁⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲙⲁⲣⲓⲁⲙ ⲁⲣⲉϫⲓⲙⲓ ⲅⲁⲣ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ⲟⲩⲟϩ ⲏⲡⲡⲉ ⲧⲉⲣⲁⲉⲣⲃⲟⲕⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲙⲓⲥⲓ ⳿ⲛⲟⲩϣⲏⲣⲓ ⲟⲩⲟϩ ⲉⲣ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ⲫⲁⲓ ⲉϥ⳿ⲉⲉⲣⲟⲩⲛⲓϣϯ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡϣⲏⲣⲓ ⳿ⲙⲡⲉⲧϭⲟⲥⲓ ⲟⲩⲟϩ ⲉϥ⳿ⲉϯ ⲛⲁϥ ⳿ⲛϫⲉ Ⲡ⳪ ⲫϯ ⳿ⲙ⳿ⲡ⳿ⲑⲣⲟⲛⲟⲥ ⳿ⲛⲇⲁⲩⲓⲇ ⲡⲉϥⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ⲟⲩⲟϩ ⳿ϥⲛⲁⲉⲣⲟⲩⲣⲟ ⳿ⲉϫⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲓⲁⲕⲱⲃ ϣⲁ ⳿ⲉⲛⲉϩ ⲩⲟϩ ⳿ⲛⲛⲉ ϧⲁ⳿ⲉ ϣⲱⲡⲓ ⳿ⲛⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ⲡⲉϫⲉ ⲙⲁⲣⲓⲁⲙ ⲇⲉ ⳿ⲙⲡⲓⲁⲅⲅⲉⲗⲟⲥ ϫⲉ ⲡⲱⲥ ⲫⲁⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟⲓ ⲉⲡⲓⲇⲏ ϯⲥⲱⲟⲩⲛ ⳿ⲛϩⲁⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⳿ϥⲛⲁ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱ ⲟⲩⲟϩ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲉⲧϭⲟⲥⲓ ⲉⲑⲛⲁⲉⲣϧⲏ ⲓⲃⲓ ⲉⲣⲟ ⲉⲑⲃⲉⲫⲁⲓ ⲫⲏⲉⲧⲟⲩⲛⲁⲙⲁⲥϥ ⳿ϥⲟⲩⲁⲃ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲉⲗⲓⲥⲁⲃⲉⲧ ⲧⲉⲥⲥⲩⲅⲅⲉⲛⲏ ⲥ ⲁⲥⲉⲣⲃⲟⲕⲓ ⲱⲥ ⳿ⲛⲟⲩϣⲏⲣⲓ ϧⲉⲛ ⲧⲉⲥⲙⲉⲧϧⲉⲗⲗⲱ ⲟⲩⲟϩ ⲫⲁⲓ ⲡⲉⲥⲙⲁϩⲋ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ⲡⲉ ⲑⲏ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ϯⲁⲧϭⲣⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲥⲁϫⲓ ⲓ ⲛⲁⲧϫⲟⲙ ϧⲁⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ⲡⲉϫⲉ ⲙⲁⲣⲓⲁⲙ ⲇⲉ ϫⲉ ⲓⲥ ϯⲃⲱⲕⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲛⲏⲓ ⲕⲁⲧⲁ ⲡⲉⲕⲥⲁϫⲓ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲥ ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ⲁⲥⲧⲱⲛⲥ ⲇⲉ ⳿ⲛϫⲉ ⲙⲁⲣⲓⲁⲙ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲥϣⲉ ⲛⲁⲥ ϧⲉⲛ ⲟⲩⲓⲏⲥ ⳿ⲉⲡⲓⲓⲁⲛⲧⲱⲟⲩ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⲓⲟⲩⲇⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ⲟⲩⲟϩ ⲁⲥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲍⲁⲭⲁⲣⲓⲁⲥ ⲟⲩⲟϩ ⲁⲥⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲛ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁⲥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ ⳿ⲉ⳿ⲡⲁⲥⲡⲁⲥⲙⲟⲥ ⳿ⲙⲙⲁⲣⲓⲁⲙ ⲁϥⲕⲓⲙ ⳿ⲛϫⲉ ⲡⲓⲙⲁⲥ ϧⲉⲛ ⲧⲉⲥⲛⲉϫⲓ ⲟⲩⲟϩ ⲁⲥⲙⲟϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⳿ⲛϫⲉ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ⲩⲟϩ ⲁⲥⲱϣ ⳿ⲉ⳿ⲡϣⲱⲓ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲟⲩⲟϩ ⲡⲉϫⲁⲥ ⲧⲉ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛⲑⲟ ϧⲉⲛ ⲛⲓϩⲓ⳿ⲟⲙⲓ ⲟⲩⲟϩ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲧⲉⲛⲉϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ⲫⲁⲓ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲛⲏⲓ ⲡⲉ ϫⲉ ⳿ⲛⲧⲉ ⳿ⲑⲙⲁⲩ ⳿ⲙⲡⲁϫ̅ⲥ̅ ⳿ⲓ ϩⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ϩⲏⲡⲡⲉ ⲅⲁⲣ ⲓⲥϫⲉⲛ ⲉⲧⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲛⲧⲉ ⲉⲁⲥⲡⲁⲥⲙⲟⲥ ⲉⲛ ⲛⲁⲙⲁϣϫ ⲁϥⲕⲓⲙ ⳿ⲛϫⲉ ⲡⲓⲙⲁⲥ ϧⲉⲛ ⲟⲩⲑⲉⲗⲏⲗ ϧⲉⲛ ⲧⲁⲛⲉϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ⲟⲩⲟϩ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲥ ⳿ⲛⲑⲏ ⲉⲧⲁⲥⲛⲁϩϯ ϫⲉ ⳿ⲡϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲛⲁϣⲱⲡⲓ ⳿ⲛⲛⲏ ⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲙⲁⲣⲓⲁⲙ ⲁ ⲧⲁⲯⲩⲭⲏ ϭⲓⲥⲓ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ⲟⲩⲟϩ ⲁ ⲡⲁⲡ͞ⲛⲁ̅ ⲑⲉⲗⲏⲗ ⳿ⲉϫⲉⲛ ϯ ⲡⲁⲥⲱⲧⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ϫⲉ ⲁϥϫⲟⲩϣⲧ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲡⲑⲉⲃⲓⲟ ⳿ⲛⲧⲉ ⲧⲉϥⲃⲱⲕⲓ ϩⲏⲡⲡⲉ ⲅⲁⲣ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⲥⲉⲛⲁⲉⲣⲙⲁⲕⲁⲣⲓⲍⲓⲛ ⳿ⲙⲙⲟⲓ ⳿ⲛϫⲉ ⲓⲅⲉⲛⲉ⳿ⲁ ⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ϫⲉ ⲁϥ⳿ⲓⲣⲓ ⲛⲏⲓ ⳿ⲛϩⲁⲛⲙⲉⲑⲛⲓϣϯ ⳿ⲛϫⲉ ⲫⲏⲉⲧϫⲟⲣ ⲟⲩⲟϩ ⳿ϥⲟⲩⲁⲃ ⳿ⲛϫⲉ ⲡⲉϥⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ⲟⲩⲟϩ ⲡⲉϥⲛⲁⲓ ϣⲱⲡⲓ ϣⲁ ϩⲁⲛϫⲱⲟⲩ ⲛⲉⲙ ϩⲁⲛϫⲱⲟⲩ ⳿ⲛⲛⲏⲉⲧⲉⲣϩⲟϯ ϧⲁⲧⲉϥϩⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ⲁϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲁⲙⲁϩⲓ ϧⲉⲛ ⲡⲉϥ⳿ϫⲫⲟⲓ ⲁϥϫⲱⲣ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓϭⲁⲥⲓϩⲏⲧ ϧⲉⲛ ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲧⲉ ⲡⲟⲩϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ⲁϥⲣⲱϧⲧ ⳿ⲛϩⲁⲛϫⲱⲣⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ϩⲁⲛ⳿ⲑⲣⲟⲛⲟⲥ ⲟⲩⲟϩ ⲁϥϭⲓⲥⲓ ⳿ⲛⲛⲏⲉⲧⲑⲉⲃⲓⲏⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ⲛⲏⲉⲧϩⲟⲕⲉⲣ ⲁϥ⳿ⲑⲣⲟⲩⲥⲓ ⲛⲁⲅⲁⲑⲟⲛ ⲟⲩⲟϩ ⲛⲏⲉⲧⲟⲓ ⳿ⲛⲣⲁⲙⲁⲟ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲃⲟⲗ ⲉⲩϣⲟⲩⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ⲁϥϯ ⲧⲟⲧϥ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲡⲉϥ⳿ⲁⲗⲟⲩ ⳿ⲉⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲉϥⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲉⲛⲓⲟϯ ⲁⲃⲣⲁⲁⲙ ⲛⲉⲙ ⲡⲉϥ⳿ϫⲣⲟϫ ϣⲁ ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲛⲉⲙⲁⲥ ⳿ⲛϫⲉ ⲙⲁⲣⲓⲁⲙ ⳿ⲛⲅ̅ ⳿ⲛⲁⲃⲟⲧ ⲟⲩⲟϩ ⲥⲕⲟⲧⲥ ⳿ⲉⲡⲉⲥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ⲁ ⲡⲓⲥⲏⲟⲩ ⲇⲉ ⲙⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⳿ⲉⲗⲓⲥⲁⲃⲉⲧ ⳿ⲉ⳿ⲑⲣⲉⲥⲙⲓⲥⲓ ⲟⲩⲟϩ ⲁⲥⲙⲓⲥⲓ ⳿ⲛⲟⲩϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ⲟⲩⲟϩ ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲏ ⲧⲉ⳿ⲙ⳿ⲡⲕⲱϯ ⳿ⲙⲡⲉⲥⲏⲓ ⲛⲉⲙ ⲛⲉⲥⲥⲩⲅⲅⲉⲛⲏⲥ ϫⲉ ⲁ Ⲡ⳪ ⲉⲣ ⲡⲉϥⲛⲁⲓ ⳿ⲛⲟⲩⲛⲓϣϯ ⲛⲉⲙⲁⲥ ⲟⲩⲟϩ ⲛⲁⲩⲣⲁϣⲓ ⲛⲉⲙⲁⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲁϩⲏ̅ ⲁⲩ⳿ⲓ ϫⲉ ⳿ⲛⲧⲟⲩⲥⲟⲩⲃⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲍⲁ ⲭⲁⲣⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ⲟⲩⲟϩ ⲁⲥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲉϥⲙⲁⲩ ⲡⲉϫⲁⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲁⲗⲗⲁ ⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϧⲉⲛ ⲧⲉⲥⲩⲅⲅⲉⲛⲓⲁ ⲉⲩⲙⲟⲩϯ ⲉⲣⲟϥ ⳿ⲙⲡⲁⲓⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ⲁⲩϭⲱⲣⲉⲙ ⲇⲉ ⳿ⲉⲡⲉϥⲓⲱⲧ ϫⲉ ⲁⲭ ⲟⲩⲱϣ ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ⲟⲩⲟϩ ⲉⲧⲁϥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲛⲟⲩⲡⲓⲛⲁⲕⲓⲥ ⲁϥ⳿ⲥϧⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉ ⲡⲉϥⲣⲁⲛ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲧⲏⲣⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ⲁ ⲣⲱϥ ⲇⲉ ⲟⲩⲱⲛ ⳿ⲛϯϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲛⲉⲙ ⲡⲉϥⲗⲁⲥ ⲩⲟϩ ⲁϥⲥⲁϫⲓ ⲡⲉ ⲉϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩϩⲟϯ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ⳿ⲙⲡⲟⲩⲕⲱϯ ⲟⲩⲟϩ ⲛⲁⲩⲥⲁϫⲓ ⳿ⲛⲛⲁⲓ ⲧⲏⲣⲟⲩ ϩⲓ ⲓⲓⲁⲛⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲓⲟⲩⲇⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ⲟⲩⲟϩ ⲛⲁⲩⲙⲟⲕⲙⲉⲕ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ϩⲁⲣⲁ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ⲙⲡⲁⲓ⳿ⲁⲗⲟⲩ ⲕⲉ ⲅⲁⲣ ⲛⲁⲣⲉ ⳿ⲧϫⲓϫ ⳿ⲙⲠ⳪ ⲭⲏ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ⲟⲩⲟϩ ⲍⲁⲭⲁⲣⲓⲁⲥ ⲡⲉϥⲓⲱⲧ ⲁϥⲙⲟϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲟⲩⲟϩ ϥⲉⲣ⳿ⲡⲣⲟⲫⲏ ⲧⲉⲩⲓⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ Ⲡ⳪ ⲫϯ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ϫⲉ ⲁϥϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⲟⲩⲟϩ ⲁϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲥⲱϯ ⳿ⲙⲡⲉϥⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ⲩⲟϩ ⲁϥⲧⲟⲩⲛⲟⲥ ⲟⲩⲧⲁⲡ ⳿ⲛⲛⲟϩⲉⲙ ⲛⲁⲛ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲇⲁⲩⲓⲇ ⲡⲉϥ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱⲟⲩ ⳿ⲛⲛⲉϥ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲑⲟⲩⲁⲃ ⲓⲥϫⲉⲛ ⳿ⲡ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ⲟⲩⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲛϫⲁϫⲓ ⲛⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲛϫⲓϫ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲙⲟⲥϯ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","⳿ⲉ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲛⲁⲓ ⲉⲙ ⲛⲉⲛⲓⲟϯ ⲟⲩⲟϩ ⳿ⲉⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲧⲉϥⲇⲓ⳿ⲁⲑⲏⲕⲏ ⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ⲡⲓⲁⲛⲁϣ ⲉⲧⲁϥⲱⲣⲕ ⳿ⲙⲙⲟϥ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲡⲉⲛⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","⳿ⲉ⳿ⲡϫⲓⲛⲧⲏⲓⲥ ⲛⲁⲛ ⲛⲁⲧⲉⲣϩⲟϯ ⳿ⲉⲁⲛⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲉⲛϫⲁϫⲓ ⳿ⲉϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ϧⲉⲛ ⲟⲩⲧⲟⲩⲃⲟ ⲛⲉⲙ ⲟⲩⲙⲉⲑⲙⲏⲓ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ ⲛⲛⲉⲛ⳿ⲉϩⲟⲟⲩ ⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟⲕ ϫⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲡⲉⲧϭⲟⲥⲓ ⳿ⲭⲛⲁⲉⲣϣⲟⲣⲡ ⲅⲁⲣ ⳿ⲙⲙⲟϣⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲠ⳪ ⲉⲥⲉⲃⲧⲉ ⲛⲉϥⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","⳿ⲉϯ ⳿ⲛⲟⲩ⳿ⲉⲙⲓ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟϩⲉⲙ ⳿ⲙⲡⲉϥⲗⲁⲟⲥ ϧⲉⲛ ⲟⲩⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ϩⲁⲛⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ⲉⲑⲃⲉ ⲛⲓⲙⲉⲧϣⲉⲛϩⲏⲧ ⳿ⲛⲧⲉ ⲫⲛⲁⲓ ⳿ⲙⲡⲉⲛⲛⲟⲩϯ ϧⲉⲛ ⲛⲁⲓ ⲉⲧⲁϥⲛⲁϣⲓⲛⲓ ⳿ⲉⲣⲟⲛ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲁⲛⲁⲧⲟⲗⲏ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡϭⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","⳿ⲉⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲛⲛⲏⲉⲧϩⲉⲙⲥⲓ ϧⲉⲛ ⳿ⲡⲭⲁⲕⲓ ⲛⲉⲙ ⳿ⲧϧⲏⲓⲃⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⳿ⲉ⳿ⲡϫⲓⲛⲥⲟⲩⲧⲉⲛ ⲛⲉⲛ ϭⲁⲗⲁⲩϫ ⳿ⲉ⳿ⲫⲙⲱⲓⲧ ⳿ⲛⲧⲉ ϯϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ⲡⲓ⳿ⲁⲗⲟⲩ ⲇⲉ ⲁϥⲁⲓⲁⲓ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲁⲙⲁϩⲓ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲩⲟϩ ⲛⲁϥⲭⲏ ⲡⲉ ϩⲓ ⲛⲓϣⲁϥⲉⲩ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ϣⲁ ⲡⲓⲥ̅ⲗ̅ ");
INSERT INTO copcnt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲩϩⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲡⲟⲩⲣⲟ ⲁⲩⲅⲟⲩⲥⲧⲟⲥ ϫⲉ ⳿ⲛⲧⲉ ϯⲟⲓⲕⲟⲓⲙⲉⲛⲏ ⲧⲏⲣⲥ ϯ ⲣⲉⲛⲥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲥϧⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ⲑⲁⲓ ⲧⲉ ϯ⳿ⲁⲡⲟⲅⲣⲁⲫⲏ ⳿ⲛϩⲟⲩⲓϯ ⲧⲁⲥϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛϩⲏⲅⲉⲙⲱⲛ ⳿ⲉϯⲥⲩⲣⲓⲁ ⳿ⲛϫⲉ ⲕⲩⲣⲓⲛⲛⲓⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ⲟⲩⲟϩ ⲛⲁⲩⲛⲁ ⲧⲏⲣⲟⲩ ⳿ⲉ⳿ⲥϧⲉ ⲡⲟⲩⲣⲁⲛ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲛⲥⲁ ⲧⲉϥⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ϥ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛϫⲉ ⳿ⲡⲕⲉⲓⲱⲥⲏⲫ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲃⲁⲕⲓ ϫⲉ ⲛⲁⲍⲁⲣⲉⲑ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⲇⲁⲩⲓⲇ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲏⲑⲗⲉⲉⲙ ⲉⲑⲃⲉϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲏⲓ ⲛⲉⲙ ⳿ⲑⲙⲉⲧⲓⲱⲧ ⳿ⲛⲇⲁⲩⲓⲇ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","⳿ⲉ⳿ⲥϧⲉ ⲡⲉϥⲣⲁⲛ ⲛⲉⲙ ⲙⲁⲣⲓⲁⲙ ⲑⲏ ⲉⲧⲁⲩⲱⲡ ⳿ⲛⲥⲱⲥ ⲛⲁϥ ⲉⲥ⳿ⲙⲃⲟⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲩⲭⲏ ⳿ⲙⲙⲁⲩ ⲁⲩⲙⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲉⲥ⳿ⲉϩⲟⲟⲩ ⲉⲑⲣⲉⲥⲙⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ⲟⲩⲟϩ ⲁⲥⲙⲓⲥⲓ ⳿ⲙⲡⲉⲥϣⲏⲣⲓ ⲡⲓϣⲟⲣⲡ ⳿ⲙⲙⲓⲥⲓ ⲟⲩⲟϩ ⲥⲕⲟⲩⲗⲱⲗϥ ⲁⲥⲭⲁϥ ϧⲉⲛ ⲟⲩⲟⲩⲟⲛϩϥ ϫⲉ ⲟⲩⲏⲓ ⲛⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲙⲁ ⳿ⲙⲙⲁⲩ ⲡⲉ ϧⲉⲛ ⲡⲓⲙⲁ⳿ⲛⲟⲩⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲩⲙⲟⲛⲓ ϧⲉⲛ ϯⲭⲱⲣⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲟⲩⲟϩ ⲉⲩⲣⲱⲓⲥ ϧⲉⲛ ⲛⲓⲣⲱⲓⲥ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲉϫⲱⲣϩ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲡⲟⲩⲟϩⲓ ⳿ⲛ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ⲟⲩⲟϩ ⲓⲥ ⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⲟⲩⲱⲟⲩ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","⳿ⲛⲑⲟϥ ⲇⲉ ⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ⲉⲣⲉⲧⲉⲛⲛⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲃⲁⲕⲓ ⳿ϥⲛⲁ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⲉϥϥⲁⲓ ⳿ⲛⲟⲩϣⲟϣⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⲙⲟϣⲓ ⲛⲥⲱϥ ⳿ⲉⲡⲓⲏⲓ ⲉⲧⲉ⳿ϥⲛⲁϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ϫⲉ ⲁⲩⲙⲓⲥⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲫⲟⲟⲩ ⳿ⲛⲟⲩⲥⲱⲧⲏ ⲣ ⲉⲧⲉ Ⲡⲭ̅ⲥ̅ Ⲡ⳪ ⲡⲉ ϧⲉⲛ ⳿ⲑⲃⲁⲕⲓ ⳿ⲛⲇⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ⲟⲩⲟϩ ⲫⲁⲓ ⲡⲉ ⲓⲙⲏⲓⲛⲓ ⲱⲧⲉⲛ ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲟⲩ⳿ⲁⲗⲟⲩ ⲉϥⲕⲟⲩⲗⲱⲗ ⲟⲩⲟϩ ⲉϥⲭⲏ ϧⲉⲛ ⲟⲩⲟⲩⲟⲛϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲙⲙⲉⲧⲙⲁⲧⲟⲓ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲉⲩϩⲱⲥ ⳿ⲉⲫϯ ⲟⲩⲟϩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ϫⲉ ⲟⲩⲱⲟⲩ ϧⲉⲛ ⲛⲏⲉⲧϭⲟⲥⲓ ⳿ⲙⲫϯ ⲛⲉⲙ ⲟⲩϩⲓⲣⲏⲛⲏ ⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲛⲉⲙ ⲟⲩ ϯⲙⲁϯ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉ⳿ⲧⲫⲉ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⲁⲩⲥⲁϫⲓ ⳿ⲛϫⲉ ⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁⲣⲟⲛ ϣⲁ ⲃⲏⲑⲗⲉⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲛⲁⲩ ⲉⲑⲃⲉ ⲡⲁⲓⲥⲁϫⲓ ⲉⲧⲁϥϣⲱⲡⲓ ⲫⲁⲓ ⲉⲧⲁ Ⲡ⳪ ⲧⲁⲙⲟⲛ ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲉⲩⲓⲏⲥ ⲁⲩϫⲓⲙⲓ ⳿ⲙⲙⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ⲓⲱⲥⲏⲫ ⲛⲉⲙ ⲡⲓ⳿ⲁⲗⲟⲩ ⲉϥⲭⲏ ϧⲉⲛ ⲡⲓⲟⲩⲟⲛϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⲁⲩ⳿ⲉⲙⲓ ⲉⲑⲃⲉ ⲓⲥⲁϫⲓ ⲉⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙⲱⲟⲩ ⲉⲑⲃⲉ ⲡⲓ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉϫⲉⲛ ⲛⲏⲉⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ⳿ⲛⲑⲟⲥ ⲛⲁⲥⲁⲣⲉϩ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⲉⲥⲥⲟϭⲛⲓ ϧⲉⲛ ⲡⲉⲥϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ⲟⲩⲟϩ ⲁⲩⲧⲁⲥⲑⲟ ⳿ⲛϫⲉ ⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲉⲩϯⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩϩⲱⲥ ⳿ⲉⲫϯ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲥⲟⲑⲙⲟⲩ ⲛⲉⲙ ⲛⲏⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲩⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ⲟⲩⲟϩ ⲉⲧⲁⲩⲙⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲏ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϫⲉ ⳿ⲛⲧⲟⲩⲥⲟⲩⲃⲏⲧϥ ⲁⲩⲙⲟⲩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲫⲏⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲓⲥϫⲉⲛ ⳿ⲙⲡⲁⲧⲟⲩⲉⲣⲃⲟⲕⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⳿ⲑⲛⲉϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ⲟⲩⲟϩ ⲉⲧⲁ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲙⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲡⲓⲧⲟⲩⲃⲟ ⲕⲁⲧⲁ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲱ⳿ⲩⲥⲏⲥ ⲁⲩ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ϫⲉ ϩⲱⲟⲩⲧ ⲛⲓⲃⲉⲛ ⲑⲛⲁⲟⲩⲱⲛ ⳿ⲉⲧⲟϯ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲉⲑⲟⲩⲁⲃ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ⲟⲩⲟϩ ⳿ⲉϯ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲩϫⲟⲥ ϩⲓ ⲛⲟⲙⲟⲥ ⳿ⲙⲠ⳪ ϫⲉ ⲟⲩϣⲱϣ ⳿ⲛϭⲣⲟⲙ⳿ⲡϣⲁⲗ ⲓⲉ ⲙⲁⲥ ⲃ̅ ⳿ⲛϭ ⲣⲟⲙⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ⲟⲩⲟϩ ⲓⲥ ϩⲏⲡⲡⲉ ⲛⲉ ⲟⲩⲣⲱⲙⲓ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲟϩ ⲁⲓⲣⲱⲙⲓ ⲛⲉ ⲟⲩⲇⲓⲕⲉⲟⲥ ⲡⲉ ⳿ⲛⲣⲉϥⲉⲣϩⲟϯ ⲉϥϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙ⳿ⲡϯⲛⲟⲙϯ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲭⲏ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ⲩⲟϩ ⲛⲉ ⲁⲩⲧⲁⲙⲟϥ ⲡⲉ ϧⲉⲛ ⲟⲩ ⳿ⲭⲣⲏⲙⲁⲧⲓⲥⲙⲟⲥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲑⲣⲉϥⲛⲁⲩ ⳿ⲉ⳿ⲫⲙⲟⲩ ⳿ⲙⲡⲁⲧⲉϥⲛⲁⲩ ⳿ⲉⲠⲭ̅ⲥ̅ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ⲩⲟϩ ⲁϥ⳿ⲓ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡϫⲓⲛⲧⲟⲩⲉⲛ ⲡⲓ⳿ⲁⲗⲟⲩ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ ⳿ⲉ⳿ⲓⲣⲓ ⳿ⲉϫⲱϥ ⲕⲁⲧⲁ ⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ⲁϥⲟⲗϥ ⳿ⲉϫⲉⲛ ⲛⲉϥϭⲛⲁⲩϩ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ϯⲛⲟⲩ ⲡⲁⲛⲏⲃ ⳿ⲭⲛⲁⲭⲁ ⲡⲉⲕⲃⲱⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲩϩⲓⲣⲏⲛⲏ ⲕⲁⲧⲁ ⲡⲉⲕⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ϫⲉ ⲁⲩⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲁⲃⲁⲗ ⳿ⲉⲡⲉⲕⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ⲫⲏⲉⲧⲁⲕⲥⲉⲃⲧⲱⲧϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲗⲁⲟⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ⲟⲩⲟⲩⲱⲓⲛⲓ ⲉⲩϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ϩⲁⲛⲉⲑⲛⲟⲥ ⲛⲉⲙ ⲟⲩⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲉⲕⲗⲁⲟⲥ ⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ⲟⲩⲟϩ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲛϫⲉ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧⲟⲩϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ⲟⲩⲟϩ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙⲙⲁⲣⲓ⳿ⲁ ⳿ⲑⲙⲁⲩ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ϫⲉ ⲓⲥ ⲫⲁⲓ ⳿ϥⲭⲏ ⳿ⲉⲟⲩϩⲉⲓ ⲛⲉⲙ ⲟⲩⲧⲱⲛϥ ⳿ⲛⲧⲉ ϩⲁⲛⲙⲏϣ ϧⲉⲛ ⲡⲓⲥ̅ⲗ̅ ⲛⲉⲙ ⲟⲩⲙⲏⲓⲛⲓ ⲉⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ⲟⲩⲟϩ ⳿ⲛⲑⲟ ϩⲱⲓ ⲉⲣⲉ ⲟⲩⲥⲏϥⲓ ⲥⲓⲛⲓ ⳿ⲛⲧⲉⲯⲩⲭⲏ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲟⲩϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲙⲏϣ ⳿ⲛϩⲏⲧ ⳿ⲛϫⲉ ϩⲁⲛⲙⲉⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲁⲛⲛⲁ ϯ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲧϣⲉⲣⲓ ⳿ⲛⲫⲁⲛⲟⲩⲏⲗ ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲩⲗⲏ ⳿ⲛⲁⲥⲥⲏ ⲣ ⲑⲁⲓ ⲛⲁⲥⲁⲓⲁⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲁⲥⲱⲛϧ ⲛⲉⲙ ϩⲁⲓ ⳿ⲛⲍ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲓⲥϫⲉⲛ ⲧⲉⲥⲙⲉⲧⲡⲁⲣⲑⲉⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ⲟⲩⲟϩ ⲑⲁⲓ ⲉ ⲁⲥⲉⲣⲭⲏⲣⲁ ϣⲁ ⲡ̅ⲇ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲑⲏ ⲉⲛⲁⲥⲥⲓⲛⲓ ⳿ⲙⲡⲓⲉⲣⲫⲉⲓ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲡⲉ ϧⲉⲛ ϩⲁⲛⲛⲏⲥⲧⲓ⳿ⲁ ⲛⲉⲙ ϩⲁⲛⲧⲱⲃϩ ⲉⲥϣⲉⲙϣⲓ ⳿ⲛϫⲱⲣϩ ⲛⲉⲙ ⲙⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲡ⳪ ⲓⲥ ⲥⲏϥⲓ ⳿ⲥⲛⲟⲩϯ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉⲣⲱϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ⲟⲩⲟϩ ⲉⲧⲁⲩϫⲱⲕ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲃⲟⲗ ⲕⲁⲧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲠ⳪ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉⲧⲟⲩⲃⲁⲕⲓ ⲁⲍⲁⲣⲉⲑ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ⲡⲓ⳿ⲁⲗⲟⲩ ⲇⲉ ⲛⲉ ⲁϥⲁⲓⲁⲓ ⲡⲉ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲁⲙⲁϩⲓ ⲉϥⲙⲉϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⲟⲩⲟϩ ⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁϥⲭⲏ ϩⲓϫⲱϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ⲟⲩⲟϩ ⲛⲉ ϣⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ ⳿ⲛⲧⲉⲛ ⲣⲟⲙⲡⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲡⲓϣⲁⲓ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ⲟⲩⲟϩ ⲉⲧⲁϥⲉⲣⲓ̅ⲃ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉⲡⲓϣⲁⲓ ⲕⲁⲧⲁ ϯⲕⲁϩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ⲟⲩⲟϩ ⲉⲧⲁⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ϧⲉⲛ ⳿ⲡϫⲓⲛⲧⲟⲩⲧⲁⲥⲑⲟ ⲁϥⲥⲱϫⲡ ⳿ⲛⲥⲱⲟⲩ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛϫⲉ ⲓ⳿ⲁⲗⲟⲩ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ⲉⲩⲙⲉⲩⲓ ⲇⲉ ϫⲉ ⲛⲁϥⲙⲟϣⲓ ⲛⲉⲙ ⲛⲏⲉⲑⲙⲟϣⲓ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲁⲩ⳿ⲓ ⳿ⲛⲟⲩ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲟϣⲓ ⲟⲩⲟϩ ⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ϧⲉⲛ ⲛⲟⲩⲥⲩⲅⲅⲉⲛⲏ ⲥ ⲛⲉⲙ ⲛⲏⲉⲧⲟⲩⲥⲱⲟⲩⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ⲟⲩⲟϩ ⳿ⲉⲧⲉ⳿ⲙⲡⲟⲩϫⲉⲙϥ ⲁⲩⲧⲁⲥⲑⲟ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ ⲙ̅ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲩϫⲉⲙϥ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉϥϩⲉⲙⲥⲓ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛⲛⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲉϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲉϥϣⲓⲛⲓ ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ⲛⲁⲩⲧⲱⲙⲧ ⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓ⳿ⲉⲙⲓ ⲛⲉⲙ ⲧⲉϥϫⲓⲛⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ⲟⲩⲟϩ ⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲟⲩⲟϩ ⲡⲉϫⲉ ⲧⲉϥⲙⲁⲩ ⲛⲁϥ ϫⲉ ⲡⲁϣⲏⲣⲓ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⲉⲧⲁⲕⲁⲓϥ ⲛⲁⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⳿ⲁⲛⲟⲕ ⲁⲛⲟⲓ ⳿ⲛⲉⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲡⲉ ⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲛⲁⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲡⲉ ϫⲉ ϩⲱϯ ⳿ⲉⲣⲟⲓ ⲛⲧⲁϣⲱⲡⲓ ϧⲉⲛ ⲛⲁ ⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲙⲡⲟⲩⲕⲁϯ ⳿ⲉⲡⲉϥⲥⲁϫⲓ ⲉⲧⲁϥϫⲟϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲛⲁⲍⲁⲣⲉⲑ ⲟⲩⲟϩ ⲛⲁϥϭⲛⲟ ⳿ⲛϫⲱϥ ⲛⲱⲟⲩ ⲡⲉ ⲧⲉϥⲙⲁⲩ ⲇⲉ ⲛⲁⲥ⳿ⲁⲣⲉϩ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⲡⲉ ϧⲉⲛ ⲡⲉⲥϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ⲟⲩⲟϩ Ⲓⲏ̅ⲥ̅ ⲛⲁϥⲉⲣ⳿ⲡⲣⲟⲕⲟⲡⲧⲓⲛ ⲡⲉ ϧⲉⲛ ϯⲙⲁⲓⲏ ⲛⲉⲙ ϯⲥⲟⲩⲫⲓ⳿ⲁ ⲛⲉⲙ ⲡⲓ⳿ϩⲙⲟⲧ ϧⲁⲧⲉⲛ ⲫϯ ⲛⲉⲙ ⲛⲓⲣⲱⲙⲓ ");
INSERT INTO copcnt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⳿ⲑⲙⲁϩ ⲓ̅ⲉ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲛⲧⲉ ⳿ⲑⲙⲉⲧϩⲏⲅⲉⲙⲱⲛ ⳿ⲛⲧⲓⲃⲉⲣⲓⲟⲥ ⲡⲟⲩⲣⲟ ⲉϥⲟⲓ ⳿ⲛϩⲏⲅⲉⲙⲱⲛ ⳿ⲛϫⲉ ⲡⲟⲛⲧⲓⲟⲥ ⲡⲓⲗⲁⲧⲟⲥ ⳿ⲉϯⲓⲟⲩⲇⲉ⳿ⲁ ⲟⲩⲟϩ ⲉϥⲟⲓ ⳿ⲛⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲛϫⲉ ⲏⲣⲱⲇⲏⲥ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲇⲉ ⲉϥⲥⲟⲛ ⲉϥⲟⲓ ⳿ⲛⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⲉⲧϩⲓⲇⲟⲩⲙⲉ⳿ⲁ ⲛⲉⲙ ϯ ⲧⲉⲧⲣⲁⲅⲱⲛⲓⲧⲏⲥ ⳿ⲛⲭⲱⲣⲁ ⲛⲉⲙ ⲗⲓⲥⲁⲛⲓⲟⲥ ⲉϥⲟⲓ ⳿ⲛⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⳿ⲉϯⲁⲃⲓⲗⲓⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ⲁϩⲣⲁϥ ⳿ⲛⲁⲛⲛⲁ ⲛⲉⲙ ⲕⲁⲓ⳿ⲁⲫⲁ ⲛⲓⲁⲣ ⲭⲓⲉⲣⲉⲩⲥ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉϫⲉⲛ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲍⲁⲭⲁⲣⲓⲁⲥ ϩⲓ ⳿ⲡϣⲁϥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ⲟⲩⲟϩ ϥ⳿ⲓ ⳿ⲉϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ ⳿ⲛⲧⲉ ⲡⲓⲓⲟⲣⲇⲁⲛⲏⲥ ⲉϥϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲱⲙⲥ ⳿ⲛⲧⲉ ⲟⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⳿ⲉ⳿ⲡⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲓ ⳿ⲡϫⲱⲙ ⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲏⲥ⳿ⲁⲓⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙⲡⲉⲧⲱϣ ⳿ⲉⲃⲟⲗ ϩⲓ ⳿ⲡϣⲁϥⲉ ϫⲉ ⲥⲉⲃⲧⲉ ⳿ⲫⲙⲱⲓⲧ ⳿ⲙⲠ⳪ ⲥⲟⲩⲧⲱⲛ ⳿ⲛⲛⲉϥⲙⲁ⳿ⲛⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ⲉⲗⲗⲟⲧ ⲓⲃⲉⲛ ⲉⲩ⳿ⲉⲙⲟϩ ⲟⲩⲟϩ ⲧⲱⲟⲩ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲑⲁⲗ ⲛⲓⲃⲉⲛ ⲉⲩ⳿ⲉⲑⲉⲃⲓⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲟⲗϫ ⲉⲩⲥⲟⲩⲧⲱⲛ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲁϣⲧ ⲉϩⲁⲛⲙⲱⲓⲧ ⲉⲩϫⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲛϫⲉ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ⳿ⲉⲡⲓⲥⲱⲧⲏ ⲣ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ⲛⲁϥϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛⲛⲓⲙⲏϣ ⲉⲑⲛⲏ ⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲣⲟϥ ⳿ⲉϭⲓⲱⲙⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲛⲓⲙⲓⲥⲓ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲁϫⲱ ⲛⲓⲙ ⲁϥⲧⲁⲙⲉ ⲑⲏⲛⲟⲩ ⳿ⲉⲫⲱⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓϫⲱⲛⲧ ⲉⲑⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ⲙⲁⲧⲁⲟⲩⲉ ⲩⲧⲁϩ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛϯⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⲡⲉⲛⲓⲱⲧ ⳿ⲛⲧⲁⲛ ⲁⲃⲣⲁⲁⲙ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲧⲉⲛ ⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲫϯ ⳿ⲉⲧⲟⲩⲛⲟⲥ ϩⲁⲛϣⲏⲣⲓ ⳿ⲛ⳿ⲁⲃⲣⲁⲁⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁⲓⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ϩⲏⲇⲏ ⲇⲉ ⲡⲓⲕⲉⲗⲉⲃⲓⲛ ⳿ϥⲭⲏ ϧⲁ ⳿ⲑⲛⲟⲩⲛⲓ ⳿ⲛⲛⲓϣϣⲏⲛ ⳿ϣϣⲏⲛ ⲉ ⲓⲃⲉⲛ ⲉⲧⲉϥⲛⲁ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲥⲉⲛⲁⲕⲟⲣϫϥ ⳿ⲛⲥⲉϩⲓⲧϥ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ⲟⲩⲟϩ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏ ϣ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣⲑⲏⲛ ⳿ⲥⲛⲟⲩϯ ⳿ⲛⲧⲁϥ ⲙⲁⲣⲉϥϯ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲙⲙⲟⲛⲧⲁϥ ⲟⲩⲟϩ ⲫⲏ ⲧⲉⲟⲩⲟⲛ ⲁⲛ⳿ϧⲣⲏ ⲟⲩ⳿ⲓ ⳿ⲛⲧⲁϥ ⲙⲁⲣⲉϥ⳿ⲓⲣⲓ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ⲁⲩ⳿ⲓ ⲇⲉ ⲟⲛ ⳿ⲛϫⲉ ϩⲁⲛⲕⲉⲧⲉⲗⲱⲛⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϭⲓⲱⲙⲥ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣ ⳿ϩⲗⲓ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲉⲧⲑⲏϣ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ⲛⲁⲩϣⲓⲛⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ⲛϫⲉ ϩⲁⲛⲕⲉⲙⲁⲧⲟⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ϩⲱⲛ ⲡⲉⲧⲉⲛⲛⲁⲁⲓϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣⲗⲉϣϫ ⳿ϩⲗⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϭⲓ ⳿ϩⲗⲓ ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ⲙⲁⲣⲟⲩⲣⲁϣ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲛⲉⲧⲉⲛⲟⲯⲱⲛⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ⲉϥϫⲟⲩϣⲧ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲉⲩⲙⲟⲕⲙⲉⲕ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⲉⲑⲃⲉ ⲱⲁⲛⲛⲏⲥ ϫⲉ ⲙⲏⲡⲟⲧⲉ ⳿ⲛⲑⲟϥ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲙⲉⲛ ϯ ⲱⲙⲥ ⳿ⲙⲙⲱⲧⲉⲛ ⲉⲛ ⲩⲙⲱⲟⲩ ⳿ϥⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉⲧϫⲟⲣ ⳿ⲉⲣⲟⲓ ⲫⲏⲉⲧⲉ ⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ⳿ⲉϯⲟⲩⲱ ⳿ⲛⲟⲩⲙⲟⲩⲥⲉⲣ ⳿ⲛⲧⲉ ⲡⲉϥⲑⲱⲟⲩ⳿ⲓ ⳿ⲛⲑⲟϥ ⲉϥ⳿ⲉ⳿ⲉⲙⲥ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ϥⲟⲩⲁⲃ ⲛⲉⲙ ⲟⲩ⳿ⲭⲣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ⲫⲏⲉⲧⲉ ⲡⲉϥϧⲁⲓ ⳿ⲛⲟⲩⲱⲧⲉⲃ ϧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲧⲟⲩⲃⲟ ⳿ⲙⲡⲉϥϭⲛⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲑⲱⲟⲩϯ ⳿ⲙⲡⲉϥⲥⲟⲩ⳿ⲟ ⲉϯⲁⲡⲟⲑⲏⲕⲏ ⲡⲓⲧⲟϩ ⲇⲉ ⳿ϥⲛⲁⲣⲟⲕϩϥ ϧⲉⲛ ⲟⲩ⳿ⲭⲣⲱⲙ ⳿ⲛⲁⲧϭⲉⲛⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ϩⲁⲛⲙⲏϣ ⲙⲉⲛ ⲟⲩⲛ ⲛⲉⲙ ϩⲁⲛⲕⲉ ⲭⲱⲟⲩⲛⲓ ⲉϥϯⲛⲟⲙϯ ⲛⲱⲟⲩ ⲁϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲙⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ⲏⲣⲱⲇⲏⲥ ⲇⲉ ⲡⲓⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⲉϥⲥⲟϩⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲉⲑⲃⲉ ⲏⲣⲱⲇⲓⲁⲥ ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲫⲓⲗⲓⲡⲡⲟⲥ ⲉϥⲥⲟⲛ ⲛⲉⲙ ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ ⲏⲣⲱⲇⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ⲁϥⲧⲟⲩϩⲟ ⳿ⲙⲡⲁⲓⲭⲉⲧ ⳿ⲉⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲓⲱⲁⲛⲛⲏⲥ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁϥϭⲓⲱⲙⲥ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲡⲓⲕⲉ Ⲓⲏ̅ⲥ̅ ⲉⲧⲁϥϭⲓⲱⲙⲥ ⲟⲩⲟϩ ⲉϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲁⲥⲟⲩⲱⲛ ⳿ⲛϫⲉ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙ⳿ⲡ⳿ⲥⲙⲟⲧ ⳿ⲛⲟⲩⲥⲱⲙⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩ ϭⲣⲟⲙⲡⲓ ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ϫⲉ ⳿ⲛⲑⲟⲕ ⲉ ⲁϣⲏⲣⲓ ⲡⲁⲙⲉⲛⲣⲓⲧ ⲉⲧⲁⲓϯ ⲙⲁϯ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϣⲱⲡⲓ ϧⲉⲛ ⳿ⲑⲙⲁϩ ⲗ̅ ⳿ⲛⲣⲟⲙⲡⲓ ϩⲱⲥ ⲉⲩⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲡϣⲏⲣⲓ ⲛⲓⲱⲥⲏⲫ ⲫⲁ ⲏⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ⲫⲁ ⲙⲁⲧⲑⲁⲧ ⲫⲁ ⲗⲉⲩⲓ ⲫⲁ ⲙⲉⲗⲭⲓ ⲫⲁ ⲓⲁⲛⲛⲏ ⲫⲁ ⲓⲱⲥⲏⲫ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ⲫⲁ ⲙⲁⲧⲑⲁⲑⲓⲟⲩ ⲫⲁ ⲁⲙⲱⲥ ⲫⲁ ⲛⲁⲟⲩⲙ ⲫⲁ ⲥⲣⲓⲙ ⲫⲁ ⲁⲅⲅⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ⲫⲁ ⲙⲁⲁⲧ ⲫⲁ ⲙⲁⲧⲑⲁⲑⲓⲟⲩ ⲫⲁ ⲥⲏⲙⲉⲓⲛ ⲫⲁ ⲓⲱⲥⲏⲭ ⲫⲁ ⲓⲱⲇⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ⲫⲁ ⲓⲱⲛⲁⲛ ⲫⲁ ⲣⲏⲥⲁ ⲫⲁ ⲍⲟⲣⲟⲃⲁⲃⲉⲗ ⲫⲁ ⲥⲁⲗⲁⲑⲓⲏⲗ ⲫⲁ ⲛⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ⲫⲁ ⲙⲉⲗⲭⲓ ⲫⲁ ⲁⲇⲇⲓ ⲫⲁ ⲕⲱⲥⲁⲙ ⲫⲁ ⲁⲗⲙⲁⲇⲁⲙ ⲫⲁ ⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ⲫⲁ ⲓⲏⲥⲟⲩ ⲫⲁ ⲉⲗⲉⲍⲉⲣ ⲫⲁ ⲓⲱⲣⲓⲙ ⲫⲁ ⲙⲁⲧⲑⲁⲧ ⲫⲁ ⲗⲉⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ⲫⲁ ⲥⲓⲙⲉⲱⲛ ⲫⲁ ⲓⲟⲩⲇⲁ ⲫⲁ ⲓⲱⲥⲏⲫ ⲫⲁ ⲓⲱⲛⲁⲙ ⲫⲁ ⲉⲗⲓⲁⲕⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ⲫⲁ ⲙⲉⲗⲉⲁ ⲫⲁ ⲙⲉⲛⲛⲁ ⲫⲁ ⲁⲧⲧⲁⲑⲁ ⲫⲁ ⲛⲁⲑⲁⲛ ⲫⲁ ⲇⲁⲩⲓⲇ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ⲫⲁ ⲓⲉⲥⲥⲏ ⲫⲁ ⲓⲱⲃⲏⲇ ⲫⲁ ⲃⲟⲉⲍ ⲫⲁ ⲥⲁⲗⲙⲱⲛ ⲫⲁ ⲛⲁⲥⲥⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ⲫⲁ ⳿ⲁⲙⲓⲛⲁⲇⲁⲃ ⲫⲁ ⲁⲇⲙⲓⲛ ⲫⲁ ⲁⲣⲛⲓ ⲫⲁ ⲉⲥⲣⲱⲙ ⲫⲁ ⲫⲁⲣⲉⲥ ⲫⲁ ⲓⲟⲩⲇⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ⲫⲁ ⲓⲁⲕⲱⲃ ⲫⲁ ⳿ Ⲓⲥⲁⲁⲕ ⲫⲁ ⲁⲃⲣⲁⲁⲙ ⲫⲁ ⲑⲁⲣⲣⲁ ⲫⲁ ⲛⲁⲭⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ⲫⲁ ⲥⲁⲣⲟⲩⲭ ⲫⲁ ⲁⲅⲁⲩ ⲫⲁ ⲫⲁⲗⲉⲭ ⲫⲁ ⲉⲃⲉⲣ ⲫⲁ ⲥⲁⲗⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ⲫⲁ ⲕⲁⲓⲛⲁⲙ ⲫⲁ ⲁⲣⲫⲁⲝⲁⲇ ⲫⲁ ⲥⲉⲙ ⲫⲁ ⲛⲱⲉ ⲫⲁ ⲗⲁⲙⲉⲭ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ⲫⲁ ⲙⲁⲑⲩⲥⲁⲗⲁ ⲫⲁ ⲛⲱⲭ ⲫⲁ ⲓⲁⲣⲇ ⲫⲁ ⲙⲁⲗⲉⲗⲉⲏⲗ ⲫⲁ ⲕⲁⲓⲛⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ⲫⲁ ⲉⲛⲱⲥ ⲫⲁ ⲥⲏⲑ ⲫⲁ ⲁⲇⲁⲙ ⲫⲁ ⲫϯ ");
INSERT INTO copcnt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉϥⲙⲉϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲑⲟⲩⲁⲃ ⲁϥⲧⲁⲥⲑⲟ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓⲓⲟⲣⲇⲁⲛⲏⲥ ⲟⲩⲟϩ ⲁϥⲟⲗϥ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ⲡϣⲁϥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ⲁⲩϫⲓⲙⲓ ⲇⲉ ⳿ⲙⲡⲓⲱⲛⲓ ⳿ⲉⲁⲩ⳿ⲥⲕⲉⲣⲕⲱⲣϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⳿ⲁϫⲟⲥ ⳿ⲙⲡⲁⲓⲱⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲥ⳿ⲥϧⲏ ⲟⲩⲧ ϫⲉ ⲛⲁⲣⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁⲱⲛϧ ⳿ⲉⲱⲓⲕ ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ⲟⲩⲟϩ ⲉⲧⲁϥⲟⲗϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⲁϥⲧⲁⲙⲟϥ ⳿ⲉⲛⲓⲙⲉⲧⲟⲩⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ϧⲉⲛ ⲟⲩ⳿ⲥⲧⲓⲅⲙⲏ ⳿ⲛⲧⲉ ⲟⲩ⳿ⲭⲣⲟⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ϫⲉ ϯⲛⲁϯ ⲛⲁⲕ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ⲧⲏⲣϥ ⲛⲉⲙ ⲡⲟⲩⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲉⲧⲉϥⲧⲟⲓ ⳿ⲉⲧⲟⲧ ⲟⲩⲟϩ ⲫⲏ ⲉϯⲟⲩⲁϣϥ ϣⲁⲓⲧⲏⲓϥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","⳿ⲛⲑⲟⲕ ⲟⲩⲛ ⲁⲕϣⲁⲛⲟⲩⲱϣⲧ ⳿ⲙⲡⲁ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲛⲁⲕ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ ⲡⲉ ⲉⲧⲉⲕ⳿ⲉⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲡⲉⲧⲉⲕ⳿ⲉϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ⲁϥ⳿ⲉⲛϥ ⲇⲉ ⲛ ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ⳿ⲉϫⲉⲛ ⳿ⲡⲧⲉⲛϩ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ϩⲓⲧⲕ ⳿ⲉⲡⲉⲥⲏⲧ ⲉⲃⲟⲗ ⲧⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⲉϥ⳿ⲉϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲉⲑⲃⲏⲧⲕ ϫⲉ ⳿ⲛⲧⲟⲩⲁⲣⲉϩ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϥⲓⲧⲕ ⲉϫⲉⲛ ⲛⲟⲩϭⲛⲁⲩϩ ⲙⲏⲡⲟⲧⲉ ⳿ⲛⲧⲉⲕϭⲓϭⲣⲟⲡ ⳿ⲉⲟⲩⲱⲛⲓ ⳿ⲛⲧⲉⲕϭⲁⲗⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁⲩϫⲟⲥ ϫⲉ ⲛⲛⲉⲕⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲠ⳪ ⲡⲉⲕⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ⲟⲩⲟϩ ⲉⲧⲁϥϫⲉⲕ ⲡⲓⲣⲁⲥⲙⲟⲥ ⲛⲓⲃⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ϣⲁ ⲩⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ⲟⲩⲟϩ ⲁϥⲧⲁⲥⲑⲟ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ϧⲉⲛ ϯϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲛⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⲉⲩϯⲱⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲛⲁⲍⲁⲣⲉⲑ ⲡⲓⲙⲁ ⲧⲁⲩϣⲁⲛⲟⲩϣϥ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲕⲁⲧⲁ ϯⲕⲁϩⲥ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲉⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ⲟⲩⲟϩ ⲁⲩϯ ⲛⲁϥ ⳿ⲙ⳿ⲡϫⲱⲙ ⳿ⲛⲧⲉ ⲏⲥⲁ̅ⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⲉⲧⲁϥⲟⲩⲱⲛ ⳿ⲉⲡⲓϫⲱⲙ ⲁϥϫⲓⲙⲓ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲛⲁϥ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ⲉ ⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲡ⳪ ⲡⲉⲧⲭⲏ ϩⲓϫⲱⲓ ⲉⲑⲃⲉ ⲫⲁⲓ ⲁϥⲑⲁϩⲥⲧ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲙⲟⲓ ⳿ⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲛⲓϩⲏⲕⲓ ⳿ⲉϩⲓⲱⲓϣ ⳿ⲛⲛⲓⲉⲭⲙⲁⲗⲱⲧⲟⲥ ⳿ⲛⲟⲩⲭⲱ ⳿ⲉⲃⲟⲗ ⲉⲙ ⲟⲩⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲛⲛⲓⲃⲉⲗⲗⲉⲩ ⳿ⲉⲟⲩⲱⲣⲡ ⳿ⲛⲛⲏⲉⲧⲥⲟⲛϩ ϧⲉⲛ ⲟⲩⲭⲱ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","⳿ⲉϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲣⲟⲙⲡⲓ ⲉⲥϣⲏⲡ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ⲟⲩⲟϩ ⲧⲁϥⲕⲉⲗ ⲡⲓϫⲱⲙ ⲁϥⲧⲏⲓϥ ⳿ⲙⲡⲓϩⲩⲡⲏ ⲣⲉⲧⲏⲥ ⲁϥϩⲉⲙⲥⲓ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲁⲣⲉ ⲛⲟⲩⲃⲁⲗ ϫⲟⲩϣⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ϩⲱⲓⲧϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲁⲥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙⲫⲟⲟⲩ ⳿ⲛϫⲉ ⲧⲁⲓ⳿ⲅⲣⲁⲫⲏ ϧⲉⲛ ⲛⲉⲧⲉⲛⲙⲁϣϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ⲟⲩⲟϩ ⲛⲁⲩⲉⲣⲙⲉⲑⲣⲉ ⲛⲁϥ ⲏⲣⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⲛⲏ ⳿ⲉⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱϥ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲓⲱⲥⲏⲫ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲁⲛⲧⲱⲥ ⲧⲉⲧⲉⲛⲛⲁϫⲉ ⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲏⲓ ϫⲉ ⲡⲓⲥⲏⲓⲛⲓ ⲁⲣⲓⲫⲁϧⲣⲓ ⳿ⲉⲣⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲛⲏ ⲧⲁⲛⲥⲟⲑⲙⲟⲩ ⳿ⲉⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⳿ⲁⲣⲓⲧⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ϩⲱϥ ϧⲉⲛ ⲧⲉⲕⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥϣⲏⲡ ϧⲉⲛ ⲧⲉϥⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ⲧⲁ⳿ⲫⲙⲏⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲭⲏⲣⲁ ⲡⲉ ϧⲉⲛ ⲓⲥ̅ⲗ̅ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲏⲗⲓⲁⲥ ϩⲟⲧⲉ ⲉⲧⲁⲥ⳿ϣⲑⲁⲙ ⲛϫⲉ ⳿ⲧⲫⲉ ⳿ⲛⲅ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲛⲉⲙ ⲋ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϩⲃⲱⲛ ϩⲓϫⲉⲛ ⲡⲕⲁϩⲓ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲟⲩⲱⲣⲡ ⳿ⲛⲏⲗⲓⲁⲥ ϩⲁ ⳿ϩⲗⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲏⲗ ϩⲁ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲭⲏⲣⲁ ⲑⲏ ⲉⲧϧⲉⲛ ⲥⲁⲣⲉⲡⲧⲁ ⳿ⲛⲧⲉ ϯⲥⲓⲇⲱⲛⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲕⲁⲕⲥⲉϩⲧ ⲡⲉ ϧⲉⲛ ⲡⲓⲥ̅ⲗ̅ ⲛⲁϩⲣⲁϥ ⳿ⲛ⳿ⲉⲗⲓⲥⲉⲟⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲧⲟⲩⲃⲟ ⳿ⲉⲃⲏⲗ ⲉⲛⲉⲙⲁⲛ ⲡⲓⲥⲩⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ⲟⲩⲟϩ ⲁⲩⲙⲟϩ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲱⲛⲧ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ⲟⲩⲟϩ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⲁⲩϩⲓⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲩ⳿ⲉⲛϥ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⳿ⲡϭⲓⲥⲓ ⳿ⲙⲡⲓⲧⲱⲟⲩ ⲫⲏ ⳿ⲉⲛⲁⲣⲉ ⲧⲟⲩⲃⲁⲕⲓ ⲭⲏ ϩⲓϫⲱϥ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩϫⲟⲗⲕϥ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲛⲱⲟⲩ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ⲟⲩⲟϩ ⲛⲁⲩⲧⲱⲙⲧ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲥⲃⲱ ϫⲉ ⲛⲁⲣⲉ ⲡⲉϥⲥⲁϫⲓ ⲭⲏ ϧⲉⲛ ⲟⲩⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ϧⲉⲛ ϯ ⲥⲩⲛⲁⲅⲱⲅⲏ ⲉⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲁϥⲱϣ ⳿ⲉ⳿ⲡϣⲱⲓ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϧⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ϫⲉ ⳿ⲁϧⲟⲕ ⲛⲉⲙⲁⲛ ϩⲱⲕ Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉⲙⲛⲁⲍⲁⲣⲉⲑ ⲉⲧⲁⲕ⳿ⲓ ⳿ⲉⲧⲁⲕⲟⲛ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⲡⲓⲁⲅⲓⲟⲥ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ⲟⲩⲟϩ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲑⲱⲙ ⲛⲣⲱⲕ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲉⲧⲁ ⲡⲓⲇⲉⲙⲱⲛ ⲥⲁⲧϥ ⳿ⲉ⳿ⲑⲙⲏϯ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⳿ⲙⲡⲉϥϯ ⳿ϩⲗⲓ ⳿ⲛⲉⲙⲕⲁϩ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ⲟⲩⲟϩ ⲁ ⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ϣⲱⲡⲓ ϩⲓϫⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏ ⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⲡⲁⲓⲥⲁϫⲓ ϫⲉ ϧⲉⲛ ⲟⲩⲉⲣϣⲓϣⲓ ⲛⲉⲙ ⲟⲩϫⲟⲙ ϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲛⲓ⳿ⲡ͞ⲛⲁ̅ ⳿ⲛⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲥⲉⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲥⲙⲏ ⲥⲏⲣ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲏⲧϥ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲛⲧⲉ ⲡⲉⲣⲓⲭⲱⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲥⲓⲙⲱⲛ ⳿ⲧϣⲱⲙⲓ ⲇⲉ ⳿ⲛⲥⲓⲙⲱⲛ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϧⲙⲟⲙ ⲛⲉⲙⲁⲥ ⲉ ⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ⲟⲩⲟϩ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲙⲙⲟⲥ ⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓ⳿ϧⲙⲟⲙ ⲟⲩⲟϩ ⲁϥⲭⲁⲥ ⲥⲁⲧⲟⲧⲥ ⲇⲉ ⲥⲧⲱⲛⲥ ⲟⲩⲟϩ ⲁⲥϣⲉⲙϣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ⲉⲧⲁ ⳿ⲫⲣⲏ ⲇⲉ ϩⲱⲧⲡ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲉ ⲟⲩⲟⲛⲧⲟⲩ ⲣⲉϥϣⲱⲛⲓ ⳿ⲙⲙⲁⲩ ϧⲉⲛ ϩⲁⲛϣⲱⲛⲓ ⳿ⲛⲟⲩⲙⲏϣ ⲛⲣⲏϯ ⲉⲩ⳿ⲉⲛⲟⲩ ϩⲁⲣⲟϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲭⲁ ϫⲓϫ ⳿ⲉϫⲉⲛ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ⲛⲁⲩⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲁⲛⲕⲉⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲙⲏϣ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲛⲁϥⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ⲡⲉ ⳿ⲛ⳿ϥⲭⲱ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ ⳿ⲉⲥⲁϫⲓ ϫⲉ ⲛⲁⲩⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲛⲑⲟϥ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ϣⲱⲡⲓ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲟⲩⲙⲁ ⳿ⲛϣⲁϥⲉ ⲟⲩⲟϩ ⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲑⲣⲉϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲱⲟⲩ ϫⲉ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲁϩⲓϣⲉⲛⲛⲟⲩϥⲓ ϧⲉⲛ ⲛⲓⲕⲉⲃⲁⲕⲓ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ϫⲉ ⲟⲩⲏⲓ ⲉⲧⲁⲩⲧⲁⲟⲩⲟⲓ ⲉⲑⲃⲉ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ⲟⲩⲟϩ ⲛⲁϥϩⲓⲱⲓϣ ⲡⲉ ⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲧⲉ ϯⲓⲟⲩⲇⲉ⳿ⲁ ");
INSERT INTO copcnt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲟⲩⲟϩ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲟϩⲓ ⲉⲣⲁⲧϥ ⲡⲉ ϧⲁⲧⲉⲛ ϯ ⲗⲩⲙⲛⲏ ⳿ⲛⲧⲉ ⲅⲉⲛⲛⲏⲍⲁⲣⲉⲑ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉϫⲟⲓ ⲃ̅ ⲉⲩⲙⲟⲛⲓ ϧⲁⲧⲉⲛ ϯⲗⲩⲙⲛⲏ ⲛⲓⲟⲩⲟϩⲓ ⲇⲉ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⲓⲱⲧⲟⲩ ⲛⲁⲩⲣⲱϧⲓ ⳿ⲛⲛⲟⲩ⳿ϣⲛⲏⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ⲁϥⲟⲗϥ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲓϫⲟⲓ ⳿ⲉⲫⲁ ⲥⲓⲙⲱⲛ ⲡⲉ ⲁϥϫⲟⲥ ⲛⲁϥ ⲉⲑⲣⲉϥϩⲉⲛϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲭⲣⲟ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲧⲁϥϩⲉⲙⲥⲓ ⲇⲉ ⲛⲁϥϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲙⲏ ϣ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓϫⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ⲉⲧⲁϥⲟⲩⲱ ⲇⲉ ⲉϥⲥⲁϫⲓ ⲡⲉϫⲁϥ ⳿ⲛⲥⲓⲙⲱⲛ ϫⲉ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲉⲧϣⲏⲕ ⲟⲩⲟϩ ⲭⲁ ⲉⲧⲉⲛ⳿ϣⲛⲏ ⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲟⲩϫⲟⲣϫⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉϫⲁϥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲧⲏⲣϥ ⲁⲛⲁⲓϥ ⳿ⲛϧⲟⲥⲓ ⳿ⲙⲡⲉⲛⲧⲁϩⲟ ⲉⲛ ⲡⲉⲕⲥⲁϫⲓ ⲇⲉ ⲧⲉⲛⲛⲁⲭ ⲱ ⳿ⲛⲛⲓ⳿ϣⲛⲏⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ⲉⲧⲁⲩ⳿ⲓⲣⲓ ⲇⲉ ⳿ⲙⲫⲁⲓ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲧⲉⲃⲧ ⳿ⲉⲛⲁϣⲱϥ ⲛⲁⲩⲛⲁⲫⲱϧ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲓ⳿ϣⲛⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ⲟⲩⲟϩ ⲁⲩϭⲱⲣⲉⲙ ⳿ⲉⲛⲟⲩ⳿ϣⲫⲏⲣ ⲛⲏⲉⲧϩⲓ ⲡⲓⲕⲉϫⲟⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ⲓ ⳿ⲛⲧⲟⲩϯⲧⲟⲧⲟⲩ ⲛⲉⲙⲱⲟⲩ ⲩⲟϩ ⲁⲩ⳿ⲓ ⲁⲩⲙⲁϩ ⲡⲓϫⲟⲓ ⲃ̅ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲱⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲁϥϩⲓⲧϥ ϧⲁⲧⲉⲛ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲒⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⲁⲣⲟⲓ ⲡⲁϫ̅ⲥ̅ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ⲟⲩϩⲟϯ ⲅⲁⲣ ⲁⲥⲧⲁϩⲟϥ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲉⲙⲁϥ ⳿ⲉϫⲉⲛ ϯϫⲟⲣϫⲥ ⳿ⲛⲧⲉ ⲛⲓⲧⲉⲃⲧ ⲉⲧⲁⲩⲧⲁϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲟⲛ ⲡⲓⲕⲉⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏⲥ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲍⲉⲃⲉⲇⲉⲟⲥ ⲛⲏ ⳿ⲉⲛⲁⲩⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲥⲓⲙⲱⲛ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲥⲓⲙⲱⲛ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⲅⲁⲣ ⲉⲕ⳿ⲉϣⲱⲡⲓ ⳿ⲛⲟⲩⲟϩⲓ ⳿ⲛⲣⲉϥⲧⲁϩⲉ ⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ⲟⲩⲟϩ ⲉⲧⲁⲩⲥⲉⲕ ⲛⲓ⳿ϣⲛⲏⲟⲩ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ ⲁⲩⲭⲁ ϩⲱⲃ ⲓⲃⲉⲛ ⳿ⲛⲥⲱⲟⲩ ⲁⲩⲟⲩⲁϩⲟⲩ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲃⲁⲕⲓ ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⲉϥⲙⲉϩ ⳿ⲛⲥⲉϩⲧ ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲒⲏ̅ⲥ̅ ϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲡⲉϥϩⲟ ⲉϥϯϩⲟ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲁⲕϣⲁⲛⲟⲩⲱϣ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲧⲟⲩⲃⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ⲟⲩⲟϩ ⲁϥⲥⲟⲩⲧⲉⲛ ⲉϥϫⲓϫ ⲉⲃⲟⲗ ⲁϥ ϭⲓ ⲛⲉⲙⲁϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲟⲩⲱϣ ⲙⲁⲧⲟⲩⲃⲟ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲥⲉϩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","⳿ⲛⲑⲟϥ ⲇⲉ ϥϩⲟⲛϩⲉⲛ ⲛⲁϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⲁⲗⲗⲁ ⲙⲁϣⲉ ⲛⲁⲕ ⲙⲁⲧⲁⲙⲉ ⲡⲓⲟⲩⲏⲃ ⳿ⲉⲣⲟⲕ ⲟⲩⲟϩ ⳿ⲁⲛⲓⲟⲩⲓ ⳿ⲉϫⲉⲛ ⲡⲉⲕⲧⲟⲩⲃⲟ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲧⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛϫⲉ ⲙⲱ⳿ⲩⲥⲏⲥ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ⲁϥⲥⲱⲣ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲟⲩ⳿ⲟ ⳿ⲛϫⲉ ⲡⲓⲥⲁϫⲓ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟϩ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲛⲟⲩϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲉϣⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲛⲓⲙⲁ⳿ⲛϣⲁϥⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲁⲓ ⳿ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩϩⲉⲙⲥⲓ ⳿ⲛϫⲉ ϩⲁⲛⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲙ ⲁⲛⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ Ⲡ⳪ ⲛⲁⲥϣⲟⲡ ⲉ⳿ⲡϫⲓⲛⲧⲁⲗϭⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ⲟⲩⲟϩ ⲓⲥ ϩⲏⲡⲡⲉ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲟⲩⲁⲓ ⲉϥϣⲏⲗ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲟⲩϭⲗⲟϫ ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ⳿ⲉⲛϥ ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⳿ⲉⲭⲁϥ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ⲟⲩⲟϩ ⲉⲧⲉ⳿ⲙⲡⲟⲩϫⲉⲙ ⲡⲓⲣⲏϯ ⳿ⲛ⳿ⲉⲛϥ ⳿ⲉϧⲟⲩⲛ ⲉⲑⲃⲉ ⲡⲓⲙⲏϣ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓϫⲉⲛⲉⲫⲱⲣ ⲩⲭⲁϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲛⲉⲙ ⲡⲓϭⲗⲟϫ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲗⲱⲃϣ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲡⲟⲩⲛⲁϩϯ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⲉⲃⲟⲗ ϫⲉ ⳿ⲫⲣⲱⲙⲓ ⲥⲉⲭⲏ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲉⲕⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲙⲙⲟⲕⲙⲉⲕ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲙ ⲡⲉ ⲫⲁⲓ ⲉⲧⲥⲁϫⲓ ⳿ⲙⲡⲁⲓϫⲉⲟⲩ⳿ⲁ ⲛⲓⲙ ⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⲏ̅ⲥ̅ ⳿ⲉⲛⲟⲩⲙⲟⲕⲙⲉⲕ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ϧⲉⲛ ⲛⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ⲟⲩ ⲉⲑⲙⲟⲧⲉⲛ ⳿ⲉϫⲟⲥ ϫⲉ ⲛⲉⲕⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲁⲕ ⳿ⲉⲃⲟⲗ ⲓⲉ ⳿ⲉϫⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⲟⲩⲟϩ ⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲟⲛ ⲉⲣϣⲓϣⲓ ⳿ⲛⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⳿ⲉⲭⲁ ⲛⲟⲃⲓ ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲉⲧϣⲏⲗ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ⲧⲱⲛⲕ ⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ ⲟⲩⲟϩ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲡⲉⲕⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ⲟⲩⲟϩ ⲁⲧⲟⲧϥ ⲁϥⲧⲱⲛϥ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⲁϥⲱⲗⲓ ⳿ⲙⲫⲏ ⳿ⲉⲛⲁϥ⳿ⲛⲕⲟⲧ ϩⲓϫⲱϥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲡⲉϥⲏⲓ ⲉϥϯⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ⲟⲩⲟϩ ⲟⲩⲧⲱⲙⲧ ⲁϥϭⲓ ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲁⲩϯⲱⲟⲩ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲁⲩⲙⲟϩ ⳿ⲛϩⲟϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛⲛⲁⲩ ⳿ⲉϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⳿ⲙⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲁϥ⳿ⲓ ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲧⲉⲗⲱⲛⲏⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲗⲉⲩ⳿ⲓ ⲉϥϩⲉⲙⲥⲓ ϩⲓ ⲟⲩⲧⲉⲗⲱⲛⲓⲟⲛ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ⲟⲩⲟϩ ⲁϥⲭⲁ ⲱⲃ ⲛⲓⲃⲉⲛ ⲁϥⲧⲱⲛϥ ⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ⲟⲩⲟϩ ⲗⲉⲩ⳿ⲓ ⲁϥⲉⲣ ⲟⲩⲛⲓϣϯ ⳿ⲛϣⲟⲡⲥ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲟⲩⲛ ϧⲉⲛ ⲡⲉϥⲏⲓ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲛⲧⲉ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ϩⲁⲛⲕⲉⲭ ⲱⲟⲩⲛⲓ ⲉⲩⲣⲟⲧⲉⲃ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲃⲉ ⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲟⲩⲱⲙ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲱ ⲛⲉⲙ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲏⲉⲧϫⲟⲣ ⲥⲉⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲡⲓⲥⲏⲓⲛⲓ ⲁⲛ ⲗⲗⲁ ⲛⲏⲉⲑⲙⲟⲕϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ⲛⲉⲧⲁⲓ⳿ⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲉⲑⲁϩⲉⲙ ⲛⲓ⳿ⲑⲙⲏⲓ ⲁⲗⲗⲁ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲛⲓⲙⲁⲑⲏ ⲧⲏⲥ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲥⲉ⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲙⲏϣ ⲛⲛⲏⲥⲧⲓ⳿ⲁ ⲛⲉⲙ ϩⲁⲛⲧⲱⲃϩ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲛⲁ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⳿ⲛⲑⲱⲟⲩ ⲥⲉⲟⲩⲱⲙ ⲥⲉⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲏ ⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⲉⲑⲣⲉ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲏ ⲧ ⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ϩⲱⲥ ⳿ⲉⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ⲥⲉⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲁⲛ⳿ⲉϩⲟⲟⲩ ⲟⲧⲁⲛ ⲁⲩϣⲁⲛⲱⲗⲓ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ ⲧⲟⲧⲉ ⲉⲩ⳿ⲉⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ⲛⲁⲩϫⲱ ⲇⲉ ⲛⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⲫⲉϧ ⲟⲩⲧⲱⲓⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩ⳿ϩⲃⲟⲥ ⳿ⲙⲃⲉⲣⲓ ⳿ⲛⲧⲉϥϩⲓⲧⲥ ⳿ⲉⲟⲩ⳿ϩⲃⲟⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ⳿ⲙⲙⲟⲛ ϣⲁⲥⲫⲉϧ ⲡⲓⲕⲉⲃⲉⲣⲓ ⲩⲟϩ ⳿ⲙⲡⲁⲥ ϯⲙⲁϯ ⲛⲉⲙ ⲡⲓ⳿ⲁⲡⲁⲥ ⳿ⲛϫⲉ ϯⲧⲱⲓⲥ ⲉⲧⲁⲩⲟⲗⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲃⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉⲁⲥⲕⲟⲥ ⳿ⲛ⳿ⲁⲡⲁⲥ ⲙⲙⲟⲛ ϣⲁⲣⲉ ⲡⲓⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⲫⲉϧ ⲛⲓ⳿ⲁⲥⲕⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ϣⲁϥⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓ⳿ⲁⲥⲕⲟⲥ ⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ⲁⲗⲗⲁ ⳿ⲉϣⲁⲩϩⲓ ⲏⲣⲡ ⳿ⲙⲃⲉⲣⲓ ⲉⲁⲥⲕⲟⲥ ⳿ⲙⲃⲉⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲉϥⲥⲱ ⳿ⲁⲡⲁⲥ ⲛⲁⲟⲩⲱϣ ⲃⲉⲣⲓ ⳿ϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥϩⲟⲗϫ ⳿ⲛϫⲉ ⲡⲓ⳿ⲁⲡⲁⲥ ");
INSERT INTO copcnt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲧⲁϥⲥⲓⲛⲓ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲣⲟϯ ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϥⲱϫⲓ ⳿ⲛⲛⲓϧⲉⲙⲥ ⲉⲩⲥⲁϩⲥⲁϩ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲛⲟⲩϫⲓϫ ⲟⲩⲟϩ ⲩⲟⲩⲱⲙ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛ⳿ⲓⲣⲓ ⳿ⲙⲡⲉⲧⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲁⲓϥ ⲁⲛ ϧⲉⲛ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲇⲉ ⲫⲁⲓ ⳿ⲙⲡⲉⲧⲉⲛⲟϣϥ ⲫⲏⲉⲧⲁ ⲇⲁⲩⲓⲇ ⲁⲓϥ ϩⲟⲧⲉ ⲉⲧⲁϥ⳿ϩⲕⲟ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ⲡⲱⲥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲛⲓⲱⲓⲕ ⳿ⲛⲧⲉ ϯ⳿ⲡⲣⲟⲑⲉⲥⲓⲥ ⲁϥϭⲓⲧⲟⲩ ⲁϥⲟⲩⲟⲙⲟⲩ ⲟⲩⲟϩ ⲁϥϯ ⳿ⲛⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲑⲛⲉⲙⲁϥ ⲛⲏ ⲧⲉⲛ⳿ⲥϣⲉ ⲛⲱⲟⲩ ⲁⲛ ⳿ⲉⲟⲩⲟⲙⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲓⲟⲩⲏⲃ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲕⲉⲥⲁⲃⲃⲁⲧⲟⲛ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲁϥ ϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲙⲙⲁⲩ ⲉ ⲉⲣⲉ ⲧⲉϥϫⲓϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ϣⲟⲩ⳿ⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ⲛⲁⲩϯ⳿ⲛⲓⲁⲧⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲁⲛ ⳿ϥⲛⲁⲉⲣⲫⲁϧⲣⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ϩⲓⲛⲁ ⲛⲧⲟⲩϫⲉⲙ ⲕⲁⲧⲏⲅⲟⲣⲓ⳿ⲁ ϧⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥ⳿ⲉⲙⲓ ⳿ⲉⲛⲟⲩⲙⲟⲕⲙⲉⲕ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉⲛⲁⲣⲉ ⲧⲉϥϫⲓϫ ϣⲟⲩ⳿ⲱⲟⲩ ϫⲉ ⲧⲱⲛⲕ ϩⲓ ⲉⲣⲁⲧⲕ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ϯϣⲓⲛⲓ ⳿ⲙⲙⲱⲧⲉⲛ ϫⲉ ⲁⲛ ⳿ⲥϣⲉ ⳿ⲛⲉⲣ ⲡⲉⲑⲛⲁⲛⲉϥ ϧⲉⲛ ⲓⲥⲁⲃⲃⲁⲧⲟⲛ ϣⲁⲛ ⳿ⲉⲉⲣ ⲡⲉⲧϩⲱⲟⲩ ⲟⲩⲯⲩⲭⲏ ⳿ⲉⲛⲁϩⲙⲉⲥ ϣⲁⲛ ⳿ⲉⲧⲁⲕⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ⲟⲩⲟϩ ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ϫⲉ ⲟⲩⲧⲉⲛ ⲧⲉⲕϫⲓϫ ⳿ⲉⲃⲟⲗ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲥⲟⲩⲧⲱⲛⲥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁⲥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲧⲉϥϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲙⲟϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲩⲙⲉⲧⲁⲧⲕⲁϯ ⲟⲩⲟϩ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲟⲩ ⲡⲉⲧⲟⲩⲛⲁⲁⲓϥ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲟⲩⲟϩ ⲛⲁϥⲟⲓ ⳿ⲛ⳿ϣⲣⲱⲓⲥ ϧⲉⲛ ϯ ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ⲟⲩⲟϩ ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲩⲟϩ ϥⲥⲱⲧⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏ ⲧⲟⲩ ⳿ⲙⲓ̅ⲃ̅ ⲛⲏⲉⲧⲁϥϯⲣⲉⲛⲟⲩ ϫⲉ ⲁⲡⲟⲥⲧⲟⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ⲥⲓⲙⲱⲛ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲁⲛⲇⲣⲉⲁⲥ ⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏⲥ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲑⲟⲗⲟⲙⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ⲛⲉⲙ ⲙⲁⲧⲑⲉⲟⲥ ⲛⲉⲙ ⲑⲱⲙⲁⲥ ⲛⲉⲙ ⲓⲁⲕⲱⲃⲟⲥ ⳿ⲛⲧⲉ ⲁⲗⲫⲉⲟⲥ ⲛⲉⲙ ⲥⲓⲙⲱⲛ ⲏ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓⲣⲉϥⲭⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ⲛⲉⲙ ⲓⲟⲩⲇⲁⲥ ⳿ⲛⲧⲉ ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲟⲩⲇⲁⲥ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⲛⲉⲙⲱⲟⲩ ϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲟⲩⲙⲁ⳿ⲛⲕⲟⲓ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉⲙ ⲕⲉⲙⲏϣ ⲉϥⲟϣ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲡⲁⲣⲁⲗⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲥⲓⲇⲱⲛ ⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲁⲗϭⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲧϩⲉⲙⲕⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲡ̅ⲛ̅ⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⲕⲱϯ ⳿ⲛⲥⲁ ϭⲓ ⲛⲉⲙⲁϥ ϫⲉ ⲟⲩⲏⲓ ⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲟⲩϫⲟⲙ ⲟⲩⲟϩ ⲛⲁϥⲧⲁⲗϭⲟ ⳿ⲙⲙⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲉⲧⲁϥϥⲁⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲓϩⲏⲕⲓ ϫⲉ ⲑⲱⲧⲉⲛ ⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ⲱⲟⲩ⳿ⲛⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲏ ⲧϩⲟⲕⲉⲣ ϯⲛⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲥⲓ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲏⲉⲧⲣⲓⲙⲓ ϯⲛⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲥⲱⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ⲱⲟⲩ⳿ⲛⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϣⲱⲡ ⲛⲧⲟⲩⲙⲉⲥⲧⲉ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲟⲩⲉⲧ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϣⲉϣ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϩⲓ ⲡⲉⲧⲉⲛⲣⲁⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲡⲉⲧϩⲱⲟⲩ ⲉⲑⲃⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ⲣⲁϣⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲑⲉⲗⲏⲗ ϩⲏⲡⲡⲉ ⲅⲁⲣ ⲡⲉⲧⲉⲛⲃⲉⲭⲉ ⲟⲩⲛⲓϣϯ ⲡⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ⲉⲛ ⳿ⲧⲫⲉ ⲛⲁⲓ ⲅⲁⲣ ⳿ⲉⲛⲁⲩ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛϫⲉ ⲛⲟⲩⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","⳿ⲡⲗⲏⲛ ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲓⲣⲁⲙⲁ⳿ⲟ ϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲏⲛ ⲉⲣⲉⲧⲉⲛϭⲓ ⲙⲡⲉⲧⲉⲛϯϩⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧⲥⲏⲟⲩ ϯⲛⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁ⳿ϩⲕⲟ ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧⲥⲱⲃⲓ ϯⲛⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲉⲣϩⲏⲃⲓ ⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲉϣⲱⲡ ⲁⲩϣⲁⲛϫⲟⲥ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲧⲏⲣⲟⲩ ϫⲉ ⲕⲁⲗⲱⲥ ⲛⲁⲓ ⲅⲁⲣ ⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲉⲛⲁⲩ⳿ⲓⲣⲓ ⲙⲙⲱⲟⲩ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲛⲟⲩϫ ⳿ⲛϫⲉ ⲛⲟⲩⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ⲁⲗⲗⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ϫⲉ ⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛϫⲁϫⲓ ⲁⲣⲓ ⲉⲑⲛⲁⲛⲉϥ ⳿ⲛⲛⲏⲉⲑⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","⳿ⲥⲙⲟⲩ ⳿ⲉⲛⲏⲉⲧⲥⲁϩⲟⲩ⳿ⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⲧⲱⲃϩ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧϭⲟϫⲓ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ⲫⲏⲉⲑⲛⲁϩⲓⲟⲩ⳿ⲓ ⲉⲛ ⲧⲁⲓⲟⲩⲟϫⲓ ⲭⲁ ϯⲭⲉϯ ϧⲁⲧⲟⲧϥ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲱⲗⲓ ⳿ⲙⲡⲉⲕ⳿ϩⲃⲟⲥ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⳿ⲙⲙⲟϥ ⳿ⲉⲱⲗⲓ ⳿ⲛⲧⲉⲕⲕⲉ⳿ϣⲑⲏ ⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ⲟⲩⲟⲛ ⲇⲉ ⲛⲓⲃⲉⲛ ⲑⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟⲕ ⲙⲟⲓ ⲛⲁϥ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲉⲗ ⲛⲉⲧⲉⲛⲟⲩⲕ ⳿ⲙⲡⲉⲣϣⲁⲧϥ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲛⲧⲟⲩ⳿ⲓⲣⲓ ⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲁⲣⲓⲟⲩ⳿ⲓ ⲛⲱⲟⲩ ϩⲱⲧⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ⲟⲩⲟϩ ⲓⲥϫⲉ ⲁⲣⲉⲧⲉⲛⲛⲁⲙⲉⲛⲣⲉ ⲛⲏⲉⲑⲙⲉⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲁϣ ⲡⲉ ⲡⲉⲧⲉⲛ⳿ϩⲙⲟⲧ ⲕⲉ ⲁⲣ ⲛⲓⲕⲉⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲁⲩⲙⲉⲓ ⳿ⲛⲛⲏⲉⲑⲙⲉⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛⲛⲁⲉⲣ ⲡⲉⲑⲛⲁⲛⲉϥ ⳿ⲛⲛⲏⲉⲧⲉⲣ ⲡⲉⲑⲛⲁⲛⲉϥ ⲛⲉⲙⲱⲧⲉⲛ ⲁϣ ⲡⲉ ⲡⲉⲧⲉⲛ⳿ϩⲙⲟⲧ ⲛⲓⲕⲉⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲥⲉ⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲉⲣⲇⲁⲛⲓⲍⲓⲛ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⲉⲣⲉⲧⲉⲛϩⲉⲗⲡⲓⲥ ⳿ⲉϭⲓ ⳿ⲛⲧⲟⲧⲟⲩ ϣ ⲡⲉ ⲡⲉⲧⲉⲛ⳿ϩⲙⲟⲧ ⲛⲓⲕⲉⲣⲉϥⲉⲣⲛⲟⲃⲓ ϩⲱⲟⲩ ⲥⲉⲉⲣⲇⲁⲛⲓⲍⲓⲛ ⳿ⲛⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϭⲓ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲧⲟⲩϣⲉⲃⲓⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","⳿ⲡⲗⲏⲛ ⲙⲉⲛⲣⲉ ⲉⲧⲉⲛϫⲁϫⲓ ⲟⲩⲟϩ ⲁⲣⲓ ⲡⲉⲑⲛⲁⲛⲉϥ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲙⲟⲓ ⳿ⲛⲧⲉⲧⲉⲛⲉⲣⲁⲡⲉⲗⲡⲓⲍⲓⲛ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁϣⲱⲡⲓ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲃⲉⲭⲉ ⳿ⲉⲛⲁϣⲱϥ ⲟⲩⲟϩ ⲉⲧⲉⲛⲛⲁϣⲱⲡⲓ ⳿ⲛϣⲏⲣⲓ ⳿ⲙⲡⲉⲧϭⲟⲥⲓ ϫⲉ ⳿ⲛⲑⲟϥ ⲟⲩⲭ̅ⲥ̅ ⲡⲉ ⳿ⲉϫⲉⲛ ⲛⲓⲁⲧ⳿ϩⲙⲟⲧ ⲛⲉⲙ ⲛⲓⲡⲟⲛⲏⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲛⲁⲏⲧ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲉϥⲟⲓ ⳿ⲛⲛⲁⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","⳿ⲙⲡⲉⲣϯϩⲁⲡ ⲟⲩⲟϩ ⳿ⲛⲛⲟⲩϯϩⲁⲡ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲙⲡⲉⲣϩⲓⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲡϩⲁⲡ ⲟⲩⲟϩ ⲥⲉⲛⲁϩⲓ ⲑⲏⲛⲟⲩ ⳿ⲙ⳿ⲡϩⲁⲡ ⲁⲛ ⲭⲱ ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ⲙⲟⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϯ ⲛⲱⲧⲉⲛ ⲟⲩϣⲓ ⳿ⲉⲛⲁⲛⲉϥ ⲉϥⲙⲉϩ ⲉϥϩⲉⲛϩⲱⲛ ⲉϥⲫⲉⲛⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⲥⲉⲛⲁⲧⲏⲓϥ ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲕⲉⲛ ⲑⲏⲛⲟⲩ ⲡⲓϣⲓ ⲅⲁⲣ ⲉⲧⲉⲧⲉⲛⲛⲁϣⲓ ⳿ⲙⲙⲟϥ ⲁⲩⲛⲁϣⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ⲁϥϫⲉ ⲕⲉⲡⲁⲣⲁⲃⲟⲗⲏ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲙⲏⲧⲓ ⲟⲩⲟⲛ ϣϫⲟⲙ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ⳿ⲉϭⲓⲙⲱⲓⲧ ϧⲁϫⲱϥ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ⲙⲏ ⲥⲉⲛⲁϩⲉⲓ ⲁⲛ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛⲟⲩϣⲓⲕ ⳿ⲙ⳿ⲡⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ⲙⲏ ⲟⲩⲟⲛ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⲉϥⲟⲩⲟⲧ ⳿ⲉⲡⲉϥⲣⲉϥϯ⳿ⲥⲃⲱ ⲙⲁⲣⲉϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉϥⲥⲉⲃⲧⲱⲧ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ⲉⲑⲃⲉⲟⲩ ϫⲉ ⳿ⲭⲛⲁⲩ ⳿ⲉⲡⲓϫⲏⲓ ϧⲉⲛ ⳿ⲫⲃⲁⲗ ⳿ⲙⲡⲉⲕⲥⲟⲛ ⲡⲓⲥⲟⲓ ⲇⲉ ⲉⲧϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲛ⳿ⲕϯ⳿ⲛⲓⲁⲧⲕ ⳿ⲙⲙⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ⲓⲉ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉϫⲟⲥ ⳿ⲙⲡⲉⲕⲥⲟⲛ ϫⲉ ⲡⲁⲥⲟⲛ ⲭⲁⲧ ⳿ⲛⲧⲁϩⲓ ⲓϫⲏⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲛⲑⲟⲕ ⲇⲉ ϩⲱⲕ ⳿ⲭⲛⲁⲩ ⲁⲛ ⳿ⲉⲡⲓⲥⲟⲓ ⲉⲧϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⲡⲓϣⲟⲃⲓ ϩⲓ ⲡⲓⲥⲟⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕⲃⲁⲗ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲕ⳿ⲉⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲉϩⲓ ⲡⲓϫⲏⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲃⲁⲗ ⳿ⲙⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⲟⲩ⳿ϣϣⲏⲛ ⳿ⲉⲛⲁⲛⲉϥ ⲉϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ⲉϥϩⲱⲟⲩ ⲡⲁⲗⲓⲛ ⲙⲙⲟⲛ ⲟⲩ⳿ϣϣⲏⲛ ⲉϥϩⲱⲟⲩ ⲉϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ⳿ⲉⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ⲡⲓⲟⲩⲁⲓ ⲅⲁⲣ ⲡⲓⲟⲩⲁⲓ ⳿ⲛⲛⲓ⳿ϣϣⲏⲛ ⲉϣⲁⲩⲥⲟⲩⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉϥⲟⲩⲧⲁϩ ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲁⲩⲥⲉⲕ ⲕⲉⲛⲧⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲥⲟⲩⲣⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲁⲩϭⲉⲗ ⳿ⲁⲗⲟⲗⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ⲟⲩⲃⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ⲡⲓⲁⲅⲁⲑⲟⲥ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲁϩⲟ ⳿ⲛⲁⲅⲁⲑⲟⲛ ⳿ⲛⲧⲉ ⲡⲉϥϩⲏⲧ ϣⲁϥ⳿ⲓⲛⲓ ⳿ⲙⲡⲓⲁⲅⲁⲑⲟⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲓⲥⲁ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲁϩⲟ ⲉⲧϩⲱⲟⲩ ϣⲁϥⲓⲛⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡϩⲟⲩⲟ ⳿ⲙ⳿ⲡϩⲏⲧ ϣⲁⲣⲉ ⲡⲓⲣⲱϥ ⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ⲉⲑⲃⲉⲟⲩ ⲇⲉ ⲧⲉⲧⲉⲛⲙⲟⲩϯ ⳿ⲉⲣⲟⲓ ϫⲉ Ⲡ⳪ Ⲡ⳪ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛ⳿ⲓⲣⲓ ⲁⲛ ⳿ⲛⲛⲏ ⳿ⲉϯϫⲱ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁ⳿ⲓ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲁⲓⲧⲟⲩ ϯⲛⲁⲧⲁⲙⲱⲧⲉⲛ ϫⲉ ⲁϥⲧⲉⲛⲑⲱⲛⲧ ⳿ⲉⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ⲁ ⲧⲉⲛⲑⲱⲛⲧ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⲉϥⲕⲱⲧ ⳿ⲛⲟⲩⲏⲓ ⲫⲏⲉⲧⲁϥϫⲱϫⲓ ⲟⲩⲟϩ ⲁϥϣⲱⲕⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⲁϥⲭⲱ ⳿ⲛⲟⲩⲥⲉⲛϯ ϩⲓϫⲉⲛ ϯⲡⲉⲧⲣⲁ ⲧⲁⲩϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲙⲟⲩ⳿ⲛϩⲱⲟⲩ ⲉⲩⲟϣ ⲁϥⲕⲱⲗϩ ⳿ⲛϫⲉ ⳿ⲡⲓⲁⲣⲟ ⳿ⲉϧⲟⲩⲛ ⳿ⲛⲥⲁ ⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲕⲓⲙ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉϫⲉ ⲛⲁϥⲕⲏⲧ ⳿ⲛⲕⲁⲗⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲁⲓⲧⲟⲩ ⲁϥⲧⲉⲛⲑⲱⲛⲧ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁϥⲕⲱⲧ ⳿ⲛⲟⲩⲏⲓ ϩⲓϫⲉⲛ ⲓⲕⲁϩⲓ ⲭⲱⲣⲓⲥ ⲥⲉⲛϯ ⲫⲏⲉⲧⲁ ⲡⲓⲓⲁⲣⲟ ⲕⲱⲗϩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥϩⲉⲓ ⲟⲩⲟϩ ⲁ ⳿ⲡϩⲉⲓ ⳿ⲙⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲉⲣⲟⲩⲛⲓϣϯ ");
INSERT INTO copcnt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ⲧⲁϥⲟⲩⲱ ⲇⲉ ⲉϥϫⲱⲕ ⳿ⲛⲛⲉϥⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲛⲙⲁϣϫ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ⲟⲩ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲇⲉ ϥⲙⲟⲕϩ ⳿ⲛϫⲉ ⲡⲉϥⲃⲱⲕ ⲛⲁϥⲛⲁⲙⲟⲩ ⲡⲉ ⲫⲏⲉⲧⲁϥⲧⲁⲓⲏⲟⲩⲧ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⲉⲑⲃⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⲛϩⲁⲛ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉϥϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲛⲧⲉϥⲧⲟⲩϫⲉ ⲡⲉϥⲃⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲉⲧⲁⲩ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲥⲡⲟⲩⲇⲉⲱⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲉⲕⲛⲁⲉⲣ ⲫⲁⲓ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","⳿ϥⲙⲉⲓ ⲅⲁⲣ ⳿ⲙⲡⲉⲛⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲑⲟϥ ⲁϥⲕⲟⲧⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲁϥⲙⲟϣⲓ ⲛⲉⲙⲱⲟⲩ ⲡⲉ ϩⲏⲇⲏ ⲇⲉ ⲉϥⲟⲩⲏⲟⲩ ⳿ⲙⲡⲓⲏⲓ ⲁⲛ ⲁϥⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⳿ⲛϩⲁⲛ⳿ϣⲫⲏⲣ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⳿ⲙⲡⲉⲣϯ ϧⲓⲥⲓ ⲛⲁⲕ ϯ⳿ⲙ⳿ⲡϣⲁ ⲅⲁⲣ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϧⲁ ⳿ⲑⲟⲩⲁϩⲥⲟⲓ ⳿ⲙⲡⲁⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ⲉⲑⲃⲉⲫⲁⲓ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲓⲁⲓⲧ ⲛⲉⲙ⳿ⲡϣⲁ ⳿ⲛ⳿ⲓ ϣⲁⲣⲟⲕ ⲁⲗⲗⲁ ⳿ⲁϫⲟⲥ ϧⲉⲛ ⳿ⲡⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲡⲁ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ⲕⲉ ⲅⲁⲣ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ϩⲱ ⲉⲩⲉⲣⲧⲁⲥⲥⲓⲛ ⳿ⲙⲙⲟϥ ϧⲁ ⲩⲉⲣϣⲓϣⲓ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛⲙⲁⲧⲟⲓ ϧⲁⲣⲁⲧ ⲟⲩⲟϩ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲫⲁⲓ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ϣⲁϥϣⲉ ⲛⲁϥ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⳿ⲁⲙⲟⲩ ⲟⲩⲟϩ ϣⲁϥ⳿ⲓ ⲟⲩⲟϩ ⲡⲁⲃⲱⲕ ⲉ ⲁⲣⲓ ⲫⲁⲓ ⲟⲩⲟϩ ϣⲁϥⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲉⲣ⳿ϣⲫⲏ ⲣⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲉⲧⲁϥⲫⲟⲛϩϥ ⲡⲉϫⲁϥ ϫⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲉ ⲟⲩⲇⲉ ϧⲉⲛ ⲡⲓⲥ̅ⲗ̅ ⲧⲏⲣϥ ⳿ⲙⲡⲓϫⲉⲙ ⲟⲩⲛⲁϩϯ ⳿ⲛⲧⲁⲓⲙⲁⲓⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ⲟⲩⲟϩ ⲉⲧⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲡⲓⲏⲓ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ ⲁⲩϫⲓⲙⲓ ⳿ⲙⲡⲓⲃⲱⲕ ⲉⲁϥⲟⲩϫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲛⲁⲓⲛ ⲟⲩⲟϩ ⲛⲁⲩⲙⲟϣⲓ ⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ϩⲱⲥⲇⲉ ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲉϯⲡⲩⲗⲏ ⳿ⲛⲧⲉ ϯⲃⲁⲕⲓ ϩⲏⲡⲡⲉ ⲛⲁⲩⲱⲗⲓ ⳿ⲛⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁϥⲙⲟⲩ ⳿ⲉⲟⲩϣⲏⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲡⲉ ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⲑⲁⲓ ⲛⲉ ⲟⲩⲭⲏⲣⲁ ⲧⲉ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⳿ⲛⲧⲉ ϯⲃⲁⲕⲓ ⲛⲉⲙⲁⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟⲥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϥϣⲉⲛϩⲏ ⲧ ϧⲁⲣⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲁϥϭⲓ ⲛⲉⲙ ϯ⳿ⲥⲗⲏ ⲛⲏ ⲇⲉ ⲉⲧϥⲁⲓ ⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲡⲓϧⲉⲗϣ⳿ⲓⲣⲓ ⳿ⲛⲑⲟⲕ ⲡⲉϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ⲧⲱⲛⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ⲟⲩⲟϩ ⲁϥϩⲉⲙⲥⲓ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲥⲁϫⲓ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲛⲧⲉϥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ⲟⲩϩⲟϯ ⲇⲉ ⲁⲥϭⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲁⲩϯⲱⲟⲩ ⳿ⲙⲫϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲁϥⲧⲱⲛϥ ⳿ⲛϧⲏⲧⲉⲛ ⲟⲩⲟϩ ϫⲉ ⲁ ⲫϯ ϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⳿ⲙⲡⲉϥⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲥⲁϫⲓ ⲉⲑⲃⲏⲧϥ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ϯⲡⲉⲣⲓ ⲭⲱⲣⲟⲥ ⲧⲏⲣⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ⲟⲩⲟϩ ⲁⲩⲧⲁⲙⲉ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲉⲑⲃⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲃ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ϥⲟⲩⲟⲣⲡⲟⲩ ϩⲁ Ⲡ⳪ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲑⲛⲏⲟⲩ ϣⲁⲛ ⳿ⲛⲧⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⳿ⲛⲕⲉⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲁϥⲟⲩⲟⲣⲡⲧⲉⲛ ϩⲁⲣⲟⲕ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ϣⲁⲛ ⳿ⲛⲧⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⲛⲕⲉⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϩⲁⲛⲙⲏϣ ⲛⲉⲙ ϩⲁⲛⲙⲁⲥⲧⲅⲅⲟⲥ ⲛⲉⲙ ϩⲁⲛⲡ̅ⲛ̅ⲁ̅ ⲉⲩϩⲱⲟⲩ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲙⲃⲉⲗⲗⲉ ⲁϥⲉⲣ⳿ϩⲙⲟⲧ ⲛⲱⲟⲩ ⳿ⲙⲡⲓⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⲙⲁⲧⲁⲙⲉ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲉⲛⲏ⳿ⲉⲧⲁⲣⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛⲥⲟⲑⲙⲟⲩ ⲛⲓⲃⲉⲗⲗⲉⲩ ⲥⲉⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲛⲓϭⲁⲗⲉⲩ ⲥⲉⲙⲟϣⲓ ⲛⲓⲕⲁⲕⲥⲉϩⲧ ⲥⲉⲧⲟⲩⲃⲏⲟⲩⲧ ⲛⲓⲕⲟⲩⲣ ⲉⲥⲱⲧⲉⲙ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲥⲉⲧⲱⲟⲩⲛⲟⲩ ⲛⲓϩⲏⲕⲓ ⲥⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ⲟⲩⲟϩ ⲱⲟⲩⲛⲓⲁⲧϥ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲁⲛ ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲣⲉⲙ⳿ⲛϩⲱⲃ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⳿ⲛⲛⲓⲙⲏϣ ⲉⲑⲃⲉ ⲓⲱⲁⲛⲛⲏⲥ ϫⲉ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲉ⳿ⲡϣⲁϥⲉ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ ⳿ⲉⲟⲩⲕⲁϣ ⲉⲩⲕⲓⲙ ⳿ⲉⲣⲟϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲑⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ⲁⲗⲗⲁ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲉⲟⲩⲟⲛ ⲁⲛϩⲉⲃⲥⲱ ⲩϫⲏⲛ ⲧⲟⲓ ϩⲓⲱⲧϥ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲁ ⲛⲓ⳿ϩⲃⲱⲥ ⳿ⲛⲧⲉ ⳿ⲡⲱⲟⲩ ⲛⲉⲙ ⳿ⲡⲟⲩⲛⲟϥ ⲥⲉⲭⲏ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲛⲓⲟⲩⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ⲁⲗⲗⲁ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲁⲩ ⲉⲟⲩ ⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲁϩⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩϩⲟⲩ⳿ⲟ ⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧϥ ϫⲉ ϩⲏⲡⲡⲉ ⲛⲁⲟⲩⲟⲣⲡ ⳿ⲙ⳿ⲡⲁⲅⲅⲉⲗⲟⲥ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲉⲕϩⲟ ⲫⲏⲉⲑⲛⲁⲥⲟⲃϯ ⳿ⲙⲡⲉⲕⲙⲱⲓⲧ ⳿ⲙⲡⲉⲕ⳿ⲙⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϧⲉⲛ ⳿ⲡϫⲓⲛⲙⲓⲥⲓ ⳿ⲛⲧⲉ ⲓϩⲓ⳿ⲟⲙⲓ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲛⲁⲁϥ ⳿ⲉⲓⲱⲁⲛⲛⲏ ⲥ ⲡⲓⲕⲟⲩϫⲓ ⲇⲉ ⳿ⲉⲣⲟϥ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲛⲓϣϯ ⳿ⲉⲣⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ⲟⲩⲟϩ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲉⲙ ⲛⲓⲧⲉⲗⲱⲛⲏ ⲥ ⲁⲩ⳿ⲑⲙⲁⲓ⳿ⲉ ⲫϯ ⲉⲧⲁⲩϭⲓⲱⲙⲥ ϧⲉⲛ ⲡⲓⲱⲙⲥ ⳿ⲛⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓⲛⲟⲙⲓⲕⲟⲥ ⲁⲩⲉⲣⲁⲑⲉⲧⲓⲛ ⳿ⲙⲡⲓⲥⲟϭⲛⲓ ⲛⲧⲉ ⲫϯ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏ ⲧⲟⲩ ⳿ⲙⲡⲟⲩϭⲓⲱⲙⲥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ⲁⲓⲛⲁⲧⲉⲛⲑⲱⲛⲧ ⲉⲛⲓⲣⲱⲙⲓ ⳿ⲛⲧⲉ ⲡⲁⲓϫⲱⲟⲩ ⳿ⲉⲟⲩ ⲟⲩⲟϩ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲟⲩ⳿ⲟⲛⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ⲥⲉ⳿ⲟⲛⲓ ⳿ⲛϩⲁⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲛⲏⲉⲧϩⲉⲙⲥⲓ ϧⲉⲛ ⲟⲩⲁⲅⲟⲣⲁ ⲟⲩⲟϩ ⲉⲩⲙⲟⲩϯ ⲟⲩⲃⲉ ⲛⲟⲩⲉⲣⲏ ⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛϫⲱ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲙⲡⲉⲧⲉⲛϭⲟⲥϫⲉⲥ ⲁⲛⲉⲣϩⲏⲃⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ⲁϥ⳿ⲓ ⲅⲁⲣ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲉϥⲟⲩⲉⲙ ⲱⲓⲕ ⲁⲛ ⲟⲩⲟϩ ⳿ⲛ⳿ϥⲥⲉ ⲏⲣⲡ ⲁⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⲉϥⲥⲱ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲥⲁⲩ ⲏⲣⲡ ⲉϥⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ⲟⲩⲟϩ ⲁⲥ⳿ⲑⲙⲁⲓⲟ ⳿ⲛϫⲉ ϯⲥⲟⲫⲓ⳿ⲁ ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲥϣⲏⲣⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩⲱⲙ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲉⲧⲁϥϣⲉ ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲁϥⲣⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲛⲁⲥⲟⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ϧⲉⲛ ϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲉⲧⲁⲥ⳿ⲉⲙⲓ ϫⲉ ⳿ϥⲣⲟⲧⲉⲃ ϧⲉⲛ ⲡⲏⲓ ⳿ⲙⲡⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲁⲥϭⲓ ⳿ⲛⲟⲩ⳿ⲁⲗⲁⲃⲁⲥⲧⲣⲟⲛ ⳿ⲛⲥⲟϫⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ⲟⲩⲟϩ ⲉⲧⲁⲥⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ ⲥⲁⲫⲁϩⲟⲩ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ⲉⲥⲣⲓⲙⲓ ⲥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲱⲣⲡ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ϧⲉⲛ ⲛⲉⲥⲉⲣⲙⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲁⲥϥⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓϥⲱⲓ ⳿ⲛⲧⲉ ⲧⲉⲥ⳿ⲁⲫⲉ ⲟⲩⲟϩ ⲛⲁⲥϯⲫⲓ ⳿ⲉⲛⲉϥϭⲁⲗⲁⲩϫ ⲥⲑⲱϩⲥ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲓⲥⲟϫⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲧⲁϥⲑⲁϩⲙⲉϥ ⲡⲉϫⲁϥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲛⲉ ⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲡⲉ ⲫⲁⲓ ⲛⲁϥⲛⲁ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲧⲉ ⲟⲩⲟϩ ϫⲉ ⲟⲩ ⲁϣ ⳿ⲛⲣⲏϯ ⲧⲉ ⲧⲁⲓ⳿ⲥϩⲓⲙⲓ ⲉⲧⲁⲥϭⲓ ⲛⲉⲙⲁϥ ϫⲉ ⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ⲟⲩⲟϩ ϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲟⲛ ⳿ⲛⲧⲏⲓ ⳿ⲛⲟⲩⲥⲁϫⲓ ⳿ⲉϫⲟϥ ⲛⲁⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲁϫⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ⲡⲉϫⲁϥ ⲇⲉ ⲉ ⲉ ⲟⲩⲟⲛ ⳿ⲭⲣⲉⲱⲥⲧⲏⲥ ⲃ̅ ⳿ⲉⲟⲩⲟⲛⲧⲉ ⲟⲩⲇⲁⲛⲓⲥⲧⲏⲥ ⳿ⲉⲣⲱⲟⲩ ⲡⲓⲟⲩⲁⲓ ⲛⲉ ⲟⲩⲟⲛ ⲫ̅ ⳿ⲛⲥⲁⲑⲉⲣⲓ ⳿ⲉⲣⲟϥ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲛⲉ ⲟⲩⲟⲛ ⲛ̅ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","⳿ⲙⲙⲟⲛ ⲛⲧⲱⲟⲩ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲉⲑⲣⲟⲩⲧⲟⲃⲟⲩ ⲁϥⲭⲁⲩ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡⲃ̅ ⳿ⲛ⳿ϩⲙⲟⲧ ⲛⲓⲙ ⲟⲩⲛ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲑⲛⲁⲙⲉⲛⲣⲓⲧϥ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲓⲙⲱⲛ ⲡⲉϫⲁϥ ϫⲉ ϯⲙⲉⲩⲓ ϫⲉ ⲫⲏⲉⲧⲁϥⲭⲁ ⲡⲓϩⲟⲩ⳿ⲟ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϩⲙⲟⲧ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲁⲕϯϩⲁⲡ ϧⲉⲛ ⲟⲩⲥⲱⲟⲩⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ⲟⲩⲟϩ ⲧⲁϥⲫⲟⲛϩϥ ⳿ⲉϯ⳿ⲥϩⲓⲙⲓ ⲡⲉϫⲁϥ ⳿ⲛⲥⲓⲙⲱⲛ ϫⲉ ⳿ⲭⲛⲁⲩ ⳿ⲉⲧⲁⲓ⳿ⲥϩⲓⲙⲓ ⲁⲓ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉⲕⲏⲓ ⳿ⲙⲡⲉⲕϯ ⳿ⲛⲟⲩⲙⲱⲟⲩ ⳿ⲉⲛⲁϭⲁⲗⲁⲩϫ ⲑⲁⲓ ⲉ ⳿ⲛⲑⲟⲥ ⲁⲥϩⲱⲣⲡ ⲛⲛⲁϭⲁⲗⲁⲩϫ ϧⲉⲛ ⲛⲉⲥⲉⲣⲙⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲁⲥϥⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲥϥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","⳿ⲙⲡⲉⲕϯ ⳿ⲛⲟⲩⲫⲓ ⳿ⲉⲣⲱⲓ ⲑⲁⲓ ⲇⲉ ⳿ⲛⲑⲟⲥ ⲓⲥϫⲉⲛ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲙⲡⲉⲥⲭⲁⲧⲟⲧⲥ ⳿ⲉⲃⲟⲗ ⲉⲥϯⲫⲓ ⳿ⲉⲛⲁϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","⳿ⲙⲡⲉⲕⲑⲱϩⲥ ⳿ⲛⲧⲁ⳿ⲁⲫⲉ ⳿ⲛⲟⲩⲛⲉϩ ⲑⲁⲓ ⲇⲉ ⳿ⲛⲑⲟⲥ ⲁⲥⲑⲱϩⲥ ⳿ⲛⲛⲁϭⲁⲗⲁⲩϫ ⳿ⲛⲟⲩⲥⲟϫⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ⲉⲑⲃⲉⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲛⲉⲥⲛⲟⲃⲓ ⲉⲧⲟϣ ⲥⲉⲭⲏ ⲛⲁⲥ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁⲥⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲉⲙⲁϣⲱ ⲫⲏ ⲅⲁⲣ ⳿ⲉϣⲁⲩⲭⲁ ⲟⲩⲕⲟⲩϫⲓ ⲛⲁϥ ⲉⲃⲟⲗ ϣⲁϥⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁⲥ ϫⲉ ⲛⲉⲛⲟⲃⲓ ⲥⲉⲭⲏ ⲛⲉ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏ ⲧⲟⲩ ⲛϫⲉ ⲛⲏⲉⲑⲣⲟⲧⲉⲃ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲫⲁⲓ ⲉⲧⲉⲣ ⳿ⲡⲕⲉⲭⲁⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ϫⲉ ⲙⲁϣⲉ ⲛⲉ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ ⲡⲉⲛⲁϩϯ ⲉⲧⲁϥⲛⲁϩⲙⲓ ");
INSERT INTO copcnt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥⲙⲟϣⲓ ⲕⲁⲧⲁ ⲃⲁⲕⲓ ⲛⲉⲙ ϯⲙⲓ ⲉϥϩⲓⲱⲓϣ ⲟⲩⲟϩ ⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⲡⲓⲓ̅ⲃ̅ ⲉⲩⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ⲛⲉⲙ ϩⲁⲛⲕⲉϩⲓ⳿ⲟⲙⲓ ⲛⲏⲉⲧⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲡ͞ⲛⲁ̅ ⲉⲩϩⲱⲟⲩ ⲛⲉⲙ ϩⲁⲛϣⲱⲛⲓ ⲙⲁⲣⲓ⳿ⲁ ⲑⲏ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ϯⲙⲁⲅⲇⲁⲗⲓⲛⲏ ⲑⲏ ⲉⲧⲁϥϩⲓ ⲡⲓⲍ̅ ⳿ⲛⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ⲛⲉⲙ ⲓⲱⲁⲛⲛⲁ ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⲛⲭⲟⲩⲍⲁ ⲡⲓ⳿ⲉⲡⲓ⳿ⲧⲣⲟⲡⲟⲥ ⳿ⲛⲧⲉ ⲏⲣⲱⲇⲏⲥ ⲛⲉⲙ ⲥⲟⲩⲥⲁⲛⲛⲁ ⲛⲉⲙ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲩⲟϣ ⲛⲏ ⳿ⲉⲛⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲟⲩϩⲩⲡⲁⲣⲭⲟⲛⲧ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ⲉϥⲑⲟⲩⲏⲧ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲛⲉⲙ ⲛⲏ ⳿ⲉⲛⲁⲩⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲕⲁⲧⲁ ⲃⲁⲕⲓ ⲡⲉϫⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛϫⲉ ⲫⲏⲉⲧⲥⲓϯ ⳿ⲉⲥⲓϯ ⳿ⲙⲡⲉϥ⳿ϫⲣⲟϫ ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉϥⲥⲓϯ ⲟⲩⲁⲓ ⲙⲉⲛ ⲁϥϩⲉⲓ ϧⲁⲧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⲁⲩϩⲉⲙϩⲱⲙϥ ⲟⲩⲟϩ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⲧⲫⲉ ⲁⲩⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲡⲉⲧⲣⲁ ⲟⲩⲟϩ ⲁϥⲣⲱⲧ ⲁϥϣⲱⲟⲩ⳿ⲓ ⲉⲑⲃⲉϫⲉ ⳿ⲙⲙⲟⲛⲧⲉϥ ϭⲛⲟⲛⲓ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ⲟⲩⲟϩ ⲉⲟⲩⲁⲓ ⲁϥϩⲉⲓ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛⲛⲓⲥⲟⲩⲣⲓ ⲟⲩⲟϩ ⲉⲧⲁϥⲣⲱⲧ ⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⲛⲓⲥⲟⲩⲣⲓ ⲁⲩⲟϫϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲩⲟϩ ⲉⲧⲁϥⲣⲱⲧ ⲁϥ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲣ̅ ⳿ⲛⲕⲱⲃ ⲛⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲛⲁϥⲙⲟⲩϯ ⲡⲉ ϫⲉ ⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲁⲣⲉϥⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ⲛⲁⲩϣⲓⲛⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲟⲩ ⲧⲉ ⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲉⲥⲧⲟⲓ ⲛⲱⲧⲉⲛ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉⲛⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲡⲥⲱϫⲡ ⲇⲉ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲁⲃⲟⲗⲏ ϩⲓⲛⲁ ⲉⲩⲛⲁⲩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲛⲁⲩ ⲟⲩⲟϩ ⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ϯⲡⲁⲣⲁⲃⲟⲗⲏ ⲇⲉ ⲑⲁⲓ ⲧⲉ ⲡⲓ⳿ϫⲣⲟϫ ⲡⲉ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ⲛⲏ ⲇⲉ ⲧϧⲁⲧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲛⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲓⲧⲁ ϣⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲟⲩⲟϩ ϣⲁϥⲱⲗⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲟⲩϩⲏ ⲧ ϩⲓⲛⲁ ⲙⲏⲡⲱⲥ ⳿ⲛⲥⲉⲛⲁϩϯ ⲩⲟϩ ⳿ⲛⲥⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ⲛⲏ ⲇⲉ ⲉⲧϩⲓϫⲉⲛ ϯⲡⲉⲧⲣⲁ ⲛⲉ ⲛⲏ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛⲥⲱⲧⲉⲙ ϣⲁⲩϣⲉⲡ ⲡⲓⲥⲁϫⲓ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ ⲟⲩⲟϩ ⲛⲁⲓ ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲩⲛⲓ ⳿ⲙⲙⲁⲩ ⲛⲏⲉⲑⲛⲁϩϯ ⳿ⲡⲣⲟⲥ ⲟⲩⲥⲏⲟⲩ ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲟⲩⲡⲓⲣⲁⲥⲙⲟⲥ ϣⲁⲩⲭⲁⲧⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ⲫⲏ ⲇⲉ ⲉⲧⲁϥϩⲉⲓ ⲉⲛ ⲛⲓⲥⲟⲩⲣⲓ ⲛⲁⲓ ⲛⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲛⲓⲣⲱⲟⲩϣ ⲛⲉⲙ ⲛⲓⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⲛⲉⲙ ⲛⲓϩⲩⲇⲟⲛⲏ ⳿ⲛⲧⲉ ⲡⲁⲓϫⲓⲛⲱⲛϧ ⲉⲩⲙⲟϣⲓ ⳿ⲛϧⲏⲧⲟⲩ ϣⲁⲩⲟϫϩⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲁⲩ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ⲫⲏ ⲇⲉ ⲉⲧⲁϥϩⲉⲓ ϧⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲑⲛⲁⲛⲉϥ ⲛⲁⲓ ⲛⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ϧⲉⲛ ⲟⲩϩⲏⲧ ⳿ⲉⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲛ⳿ⲁⲅⲁⲑⲟⲛ ⲉⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ϣⲁⲩ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩϩⲩⲡⲟⲙⲟⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ϭⲉⲣⲉ ⲟⲩϧⲏⲃⲥ ⳿ⲛⲧⲉϥϩⲟⲃⲥϥ ϧⲉⲛ ⲩ⳿ⲥⲕⲉⲩⲟⲥ ⲓⲉ ⳿ⲛⲧⲉϥⲭⲁϥ ⲥⲁ⳿ⲉ⳿ϧⲣⲏ ⲓ ⳿ⲛⲟⲩϭⲗⲟϫ ⲁⲗⲗⲁ ⳿ⲉϣⲁⲩⲭⲁϥ ϩⲓϫⲉⲛ ⲟⲩⲗⲩⲭⲛⲓ⳿ⲁ ϩⲓⲛⲁ ⲛⲏⲉⲑⲛⲁ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲉⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ⲙⲙⲟⲛ ⲡⲉⲧϩⲏⲡ ⲅⲁⲣ ϫⲉ ⳿ϥⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⲡⲉⲧⲭⲏⲡ ϫⲉ ⲥⲉⲛⲁ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉ⳿ⲑⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","⳿ⲁⲛⲁⲩ ⲟⲩⲛ ϫⲉ ⲧⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⲫⲏ ⲅⲁⲣ ⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⲉⲩ⳿ⲉϯ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉⲧⲉ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲁϥ ⲡⲓⲕⲉⲟⲩⲁⲓ ⳿ⲉⲧⲉϥⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ϥⲉⲛⲧⲟⲧϥ ⲩ⳿ⲉⲟⲗϥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ⲁⲥ⳿ⲓ ⲇⲉ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩ⳿ϣϫⲉⲙϫⲟⲙ ⲁⲛ ⲡⲉ ⳿ⲉϯⲙⲁϯ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉ ⲡⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ⲁⲩⲧⲁⲙⲟϥ ⲇⲉ ϫⲉ ⲓⲥ ⲧⲉⲕⲙⲁⲩ ⲛⲉⲙ ⲛⲉⲕ⳿ⲥⲛⲏⲟⲩ ⲥⲉ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲥⲁⲃⲟⲗ ⲉⲩⲟⲩⲱϣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲁⲙⲁⲩ ⲛⲉⲙ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲓ ⲛⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲟⲩⲁⲓ ⳿ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲑⲟϥ ϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲟⲩϫⲟⲓ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁⲣⲉⲛϣⲉ ⲛⲁⲛ ⳿ⲉⲙⲏⲣ ⳿ⲉϯⲗⲩⲙⲛⲏ ⲟⲩⲟϩ ⲁⲩⲥⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ⲉⲩⲉⲣϩⲱⲧ ⲇⲉ ϥⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯⲗⲩⲙⲛⲏ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲑⲏⲟⲩ ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⳿ⲉⲣⲱⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣⲕⲓⲛⲇⲩⲛⲉⲩⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⲩⲛⲉϩⲥⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲉⲛⲛⲁⲧⲁⲕⲟ ⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲧⲱⲛϥ ⲁϥⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓⲑⲏⲟⲩ ⲛⲉⲙ ⲛⲓϩⲱⲓⲙⲓ ⳿ⲛⲧⲉ ⲡⲓⲙⲱⲟⲩ ⲩⲟϩ ⲁⲩϩⲉⲣⲓ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛϫⲁⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁϥⲑⲱⲛ ⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲉⲧⲁⲩⲉⲣϩⲟϯ ⲩⲉⲣ⳿ϣⲫⲏ ⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⲛⲓⲙ ϩⲁⲣⲁ ⲡⲉ ⲫⲁⲓ ϫⲉ ⳿ϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲛⲓⲕⲉⲑⲏⲟⲩ ⲛⲉⲙ ⲛⲓⲙⲱⲟⲩ ⲟⲩⲟϩ ⲥⲉⲥⲱⲧⲉⲙ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ⲩⲟϩ ⲁⲩⲉⲣϩⲱⲧ ⳿ⲉ⳿ⲧⲭⲱⲣⲁ ⳿ⲛⲧⲉ ⲛⲓⲅⲉⲣⲅⲉⲥⲏ ⲛⲟⲥ ⲉⲧⲉ ⲑⲏ ⲧⲉ ⲉⲧϩⲓⲙⲏⲣ ⲟⲩⲃⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲕⲁϩⲓ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲃⲁⲕⲓ ⳿ⲉⲟⲩⲟⲛ ϩⲁⲛⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⳿ⲉⲁϥⲉⲣⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⳿ⲙⲡⲉϥϯ⳿ϩⲃⲟⲥ ϩⲓⲱⲧϥ ⲟⲩⲟϩ ⲙⲡⲉϥϣⲱⲡⲓ ϧⲉⲛ ⲏⲓ ⲁⲗⲗⲁ ϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲒⲏ̅ⲥ̅ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲣⲁⲧϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⲛ⳿ⲥⲙⲏ ϫⲉ ⳿ⲁϧⲟⲕ ⲛⲉⲙⲏⲓ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲉⲧⲟⲛϧ ϯϯϩⲟ ⳿ⲉⲣⲟⲕ ⳿ⲙⲡⲉⲣϯ⳿ⲙⲕⲁϩ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲁϥⲭⲁ ⲏⲓ ⳿ⲛⲥⲱϥ ⲓⲉ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲓⲉ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ ⲓⲉ ϩⲁⲛⲓⲟϯ ⲓⲉ ϩⲁⲛϣⲏⲣⲓ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ⲁϥϣⲉⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲏ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲡⲉⲕⲣⲁⲛ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲗⲉⲅⲓⲱⲛ ϫⲉ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛⲇⲉⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲱⲟⲩ ⳿ⲉϣⲉ ⳿ⲉ⳿ⲫⲛⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲟϩⲓ ⲇⲉ ⳿ⲛⲣⲓⲣ ⳿ⲙⲙⲁⲩ ⲉⲩⲙⲟⲛⲓ ϧⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲭⲁⲩ ⳿ⲉϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁϥⲭⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓⲣⲱⲙⲓ ⳿ⲛϫⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓ⳿ⲉϣⲁⲩ ⲟⲩⲟϩ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ϯⲁⲅⲉⲗⲏ ⳿ⲛⲣⲓⲣ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯ ⲗⲩⲙⲛⲏ ϧⲉⲛ ⲡⲓϫⲁϫⲣⲓⲙ ⲟⲩⲟϩ ⲁⲩⲱϫϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲏⲉⲑⲙⲟⲛⲓ ⲉⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⲁⲩⲫⲱⲧ ⲟⲩⲟϩ ⲁⲩⲧⲁⲙⲉ ⲛⲏⲉⲧϧⲉⲛ ϯⲃⲁⲕⲓ ⲛⲉⲙ ⲛⲏⲉⲧϧⲉⲛ ⳿ⲧⲕⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲁⲩ ⳿ⲉⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩϫⲓⲙⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲉϥϩⲉⲙⲥⲓ ⲫⲏⲉⲧⲁ ⲛⲓⲇⲉⲙⲱⲛ ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⲉϥⲟⲓ ⳿ⲛⲥⲁⲃⲉ ⲉⲣⲉ ⲛⲉϥ⳿ϩⲃⲱⲥ ⲧⲟⲓ ϩⲓⲱⲧϥ ⲉϥⲭⲏ ϧⲁⲧⲉⲛ ⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲒⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ⲁⲩⲧⲁⲙⲱⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲁⲩⲛⲁⲩ ϫⲉ ⲉⲧⲁϥⲛⲟϩⲉⲙ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲛⲁⲣⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ⲟⲩⲟϩ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲅⲉⲣⲅⲉⲥⲏⲛⲟⲥ ϫⲉ ⳿ⲛⲧⲉϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ ϫⲉ ⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ⲡⲉ ⳿ⲉⲛⲁⲩⲭⲏ ⳿ⲛϧⲏⲧⲥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲁⲗⲏⲓ ⳿ⲉ⳿ⲡϫⲟⲓ ⲁϥⲧⲁⲥⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⲫⲏⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⲛϫⲉ ⲛⲓⲇⲉⲙⲱⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟϩⲓ ⲛⲉⲙⲁϥ ⲁϥⲟⲩⲟⲣⲡϥ ⲇⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ϫⲉ ⲙⲁⲧⲁⲥⲑⲟ ⳿ⲉⲡⲉⲕⲏⲓ ⲟⲩⲟϩ ⲥⲁϫⲓ ⳿ⲛⲛⲏⲉⲧⲁϥⲁⲓⲧⲟⲩ ⲉⲙⲁⲕ ⳿ⲛϫⲉ ⲫϯ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲃⲁⲕⲓ ⲧⲏⲣⲥ ⲉϥϩⲓⲱⲓϣ ⳿ⲛⲛⲏⲉⲧⲁϥⲁⲓⲧⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ⲉⲧⲁϥⲧⲁⲥⲑⲟ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϥϣⲟⲡϥ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲛⲁⲩϫⲟⲩϣⲧ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⲧⲏⲣⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲓⲁⲓⲣⲟⲥ ⲟⲩⲟϩ ⲁⲓ ⲛⲉ ⲟⲩⲁⲣⲭ ⲱⲛ ⲡⲉ ⳿ⲛⲧⲉ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲟϩ ⲉⲧⲁϥϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲧⲉⲛ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲒⲏ̅ⲥ̅ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⲉⲑⲣⲉϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ⲉ ⲟⲩϣⲉⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧⲥ ⳿ⲉⲛⲁⲥ⳿ⲛⲧⲁϥ ⲡⲉ ⲉⲥϧⲉⲛ ⲓ̅ⲃ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲟⲩⲟϩ ⲑⲁⲓ ⲛⲁⲥⲛⲁⲙⲟⲩ ⲡⲉ ⲉϥⲛⲁ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲩϩⲟϫϩⲉϫ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ⲟⲩⲟϩ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲥⲛⲟϥ ⲭⲏ ϧⲁⲣⲟⲥ ⳿ⲙⲓ̅ⲃ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲑⲁⲓ ⲉⲧⲁⲥϭⲟ ⳿ⲙⲡⲉⲥⲱⲛϧ ⲏⲣϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲥⲏⲓⲛⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲥ⳿ϣϫⲉⲙϫⲟⲙ ⲉⲑⲣⲟⲩⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲫⲁϩⲟⲩ ⲁⲥϭⲓ ⲛⲉⲙ ⳿ⲡ⳿ϣⲧⲁϯ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ϩⲃⲟⲥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲟϩⲓ ⳿ⲛϫⲉ ⲓ⳿ⲥⲛⲟϥ ⳿ⲉⲛⲁϥϣⲁⲧ ⳿ⲉⲃⲟⲗ ϧⲁⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϭⲓ ⲛⲉⲙⲏⲓ ⲉⲩϫⲱⲗ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲛⲏ ⲑⲛⲉⲙⲁϥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲓⲙⲏϣ ⲉⲧⲕⲱϯ ⳿ⲉⲣⲟⲕ ⲟⲩⲟϩ ⲉⲧϩⲟϫϩⲉϫ ⳿ⲙⲙⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩⲟⲛ ⲡⲉⲧⲁϥϭⲓ ⲛⲉⲙⲏⲓ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲓ⳿ⲉⲙⲓ ⳿ⲉⲟⲩϫⲟⲙ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ⲉⲧⲁⲥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ϫⲉ ⳿ⲙⲡⲉϥⲉⲣ⳿ⲡⲱⲃϣ ⲁⲥ⳿ⲓ ⲉⲥ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲟⲩⲟϩ ⲉⲧⲁⲥϩⲓⲧⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲣⲁⲧϥ ⲥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲛ⳿ⲉⲧⲓ⳿ⲁ ⲁⲥϭⲓ ⲛⲉⲙⲁϥ ⲛⲉⲙ ⲡⲓⲣⲏϯ ⲉⲧⲁⲥⲟⲩϫⲁⲓ ⳿ⲙⲙⲟϥ ⲥⲁⲧⲟⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","⳿ⲛⲑⲟϥ ⲡⲉϫⲁϥ ⲁⲥ ϫⲉ ⲧⲁϣⲉⲣⲓ ⲡⲉⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲓ ⲙⲁϣⲉ ⲛⲉ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲉϥϫⲱ ⲙⲙⲟⲥ ϫⲉ ⲁⲥⲙⲟⲩ ⳿ⲛϫⲉ ⲧⲉⲕϣⲉⲣⲓ ⳿ⲙⲡⲉⲣϯ ϧⲓⲥⲓ ⳿ⲙⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲙⲟⲛⲟⲛ ⲁϩϯ ⲟⲩⲟϩ ⳿ⲥⲛⲁⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲡⲓⲏⲓ ⳿ⲙⲡⲉϥⲭⲁ ⳿ϩⲗⲓ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲛⲉⲙⲁϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ ⲫⲓⲱⲧ ⳿ⲛϯ⳿ⲁⲗⲟⲩ ⲛⲉⲙ ⲧⲉⲥⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ⲛⲁⲩⲣⲓⲙⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲛⲉϩⲡⲓ ⳿ⲉⲣⲟⲥ ⲡⲉ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲉⲣⲣⲓⲙⲓ ⳿ⲙⲡⲉⲥⲙⲟⲩ ⲅⲁⲣ ⲛϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲁⲗⲗⲁ ⲁⲥ⳿ⲛⲕⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ⲟⲩⲟϩ ⲛⲁⲩⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⲉⲩ⳿ⲉⲙⲓ ϫⲉ ⲁⲥⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥϩⲓⲧⲟⲩ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲉⲥϫⲓϫ ⲁϥⲙⲟⲩϯ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯ⳿ⲁⲗⲟⲩ ⲧⲱⲟⲩⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ⲟⲩⲟϩ ⲁϥⲕⲟⲧϥ ⳿ⲉⲣⲟⲥ ⳿ⲛϫⲉ ⲡⲉⲥⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲥ ⲁⲥⲧⲱⲛⲥ ⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲧⲟⲩϯ ⲛⲁⲥ ⳿ⲉⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ⲟⲩⲟϩ ⲁⲩⲧⲱⲙⲧ ⳿ⲛϫⲉ ⲛⲉⲥⲓⲟϯ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙϫⲉ ⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛ⳿ϩⲗⲓ ");
INSERT INTO copcnt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ⲉⲧⲁϥⲙⲟⲩϯ ⲇⲉ ⳿ⲉⲡⲓⲓ̅ⲃ̅ ⳿ⲛⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁϥϯϫⲟⲙ ⲛⲱⲟⲩ ⲛⲉⲙ ⲟⲩⲉⲣϣⲓϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲇⲉⲙⲱⲛ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉϩⲓⲱⲓϣ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲗϭⲟ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲗ ⳿ϩⲗⲓ ⳿ⲉ⳿ⲫⲙⲱⲓⲧ ⲩⲇⲉ ⳿ϣⲃⲱⲧ ⲟⲩⲇⲉ ⲡⲏⲣⲁ ⲟⲩⲇⲉ ⲱⲓⲕ ⲟⲩⲇⲉ ϩⲁⲧ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲭⲁ ⳿ϣⲑⲏⲛ ⳿ⲥⲛⲟⲩϯ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ⲟⲩⲟϩ ⲡⲓⲏⲓ ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϣⲁⲧⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ⲟⲩⲟϩ ⲛⲏⲉⲧⲉ⳿ⲛⲥⲉⲛⲁϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁⲛ ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲃⲁⲕⲓ ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉϩ ⳿ⲡϣⲱⲓϣ ⳿ⲛⲛⲉⲧⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ⲉⲩⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲛⲁⲩⲙⲟϣⲧ ⲡⲉ ⲕⲁⲧⲁ ϯⲙⲓ ⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲩⲟϩ ⲉⲩⲉⲣⲫⲁϧⲣⲓ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ⲁϥⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲏⲣⲱⲇⲏⲥ ⲡⲓⲧⲉⲧⲣⲁⲁⲣⲭⲏ ⲥ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲛⲁⲩϣⲟⲡ ⲟⲩⲟϩ ⲛⲁϥⲟⲓ ⳿ⲛ⳿ϣⲗⲁϩ ⳿ⲛϩⲏⲧ ⲑⲃⲉϫⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ ⲏⲗⲓⲁⲥ ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲛⲓⲁⲣⲭⲉⲟⲥ ⲡⲉⲧⲁϥⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ⲡⲉϫⲉ ⲏⲣⲱⲇⲏⲥ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲁⲛⲟⲕ ⲁⲓⲉⲗ ⲧⲉϥⲛⲁϩⲃⲓ ⲛⲓⲙ ⲇⲉ ⲡⲉ ⲫⲁⲓ ⳿ⲉϯⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ ⲛⲁⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ⲟⲩⲟϩ ⲉⲧⲁⲩⲧⲁⲥⲑⲟ ⳿ⲛϫⲉ ⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁⲩⲥⲁϫⲓ ϧⲁⲧⲟⲧϥ ⳿ⲛⲛⲏⲉⲧⲁⲩⲁⲓⲧⲟⲩ ⲟⲩⲟϩ ⲁϥⲟⲗⲟⲩ ⲛⲉⲙⲁϥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲃⲏⲑⲥⲁⲓⲇⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ⲛⲓⲙⲏϣ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲉⲧⲁϥϣⲟⲡⲟⲩ ⳿ⲉⲣⲟϥ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲩⲟϩ ⲛⲏⲉⲧⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲛⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⲛⲁϥⲧⲁⲗ ϭⲟ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲛⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲣⲓⲕⲓ ⲡⲉ ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲓ̅ⲃ̅ ⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲭⲁ ⲛⲓⲙⲏϣ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉⲛⲓϯⲙⲓ ⲉⲧⲉ ⳿ⲙ⳿ⲡⲕⲱϯ ⲛⲉⲙ ⲛⲓⲓⲟϩⲓ ⳿ⲛⲧⲟⲩ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϫⲉⲙ ⲫⲏ ⲧⲟⲩⲛⲁⲟⲩⲟⲙϥ ϫⲉ ⲧⲉⲛⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ϧⲉⲛ ⲟⲩⲙⲁ ⳿ⲛϣⲁϥⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲙⲟⲓ ⲛⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲑⲣⲟⲩⲟⲩⲱⲙ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲉϫⲱⲟⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ϩⲟⲩ⳿ⲟ ⳿ⲉⲉ̅ ⳿ⲛⲱⲓⲕ ⳿ⲛⲧⲟⲧⲉⲛ ⲛⲉⲙ ⲉⲃⲧ ⲃ̅ ⳿ⲉⲃⲏⲗ ⳿ⲁⲛⲟⲛ ⳿ⲛⲧⲉⲛϣⲉ ⲛⲁⲛ ⳿ⲛⲧⲉⲛϣⲱⲡ ⳿ⲛϩⲁⲛ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⳿ⲙⲡⲁⲓⲗⲁⲟⲥ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ⲁⲩⲟⲓ ⲇⲉ ⲛⲁⲩ ⲉ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ ⲁϥϫⲟⲥ ⲇⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲙⲁⲣⲟⲩⲣⲱⲧⲉⲃ ⲕⲁⲧⲁ ⲙⲁ ⳿ⲛϩⲁⲛⲛ̅ ⳿ⲉ⳿ⲫⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ϥ⳿ⲑⲣⲟⲩⲣⲱⲧⲉⲃ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ⲉⲧⲁϥϭⲓ ⲇⲉ ⳿ⲙⲡⲓⲉ̅ ⳿ⲛⲱⲓⲕ ⲛⲉⲙ ⲡⲓⲧⲉⲃⲧ ⲃ̅ ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁϥⲫⲁϣⲟⲩ ⲟⲩⲟϩ ϥϯ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲑⲣⲟⲩⲭⲱ ϧⲁⲣⲱⲟⲩ ⳿ⲙⲡⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲁⲩⲥⲓ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲁⲩⲱⲗⲓ ⳿ⲙⲫⲏⲉⲧⲁϥⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲱⲟⲩ ̅ⲃ̅ ⳿ⲛⲕⲟⲧ ⳿ⲛⲗⲁⲕϩ ⲉⲩⲙⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉϥⲭⲏ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲉϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲛⲁⲩⲭⲏ ⲛⲉⲙⲁϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲩⲟϩ ϥϣⲉⲛⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲣⲉ ⲛⲓⲣⲱⲙⲓ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲉⲣⲟⲩⲱ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲓⲣⲉϥϯⲱⲙⲥ ⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ ⲏⲗⲓⲁⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϫⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲛⲓⲁⲣⲭⲉⲟⲥ ⲡⲉ ⲉⲧⲁϥⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲁⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲱⲟⲩ ⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉ⳿ϣⲧⲉⲙϫⲉ ⲫⲁⲓ ⳿ⲛ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","⳿ⲉⲁϥϫⲟⲥ ϫⲉ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ϭⲓ ⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ⲟⲩⲟϩ ⲛⲧⲟⲩϣⲟϣϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ ϧⲉⲛ ⲡⲓⲙⲁϩⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁⲟⲩⲱϣ ⳿ⲉⲟⲩⲁϩϥ ⳿ⲛⲥⲱⲓ ⲙⲁⲣⲉϥϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲙⲁⲣⲉϥⲱⲗⲓ ⳿ⲙⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ ⳿ⲙⲙⲏⲛⲓ ⲟⲩⲟϩ ⲛⲧⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ⲫⲏ ⲅⲁⲣ ⲉⲑⲟⲩⲱϣ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲧⲉϥ ⲯⲩⲭⲏ ⳿ϥⲛⲁⲧⲁⲕⲟⲥ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲧⲁⲕⲟ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉⲑⲃⲏⲧ ⲉϥ⳿ⲉⲛⲁϩⲙⲉⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ⲟⲩ ⲅⲁⲣ ⲉⲣⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⲁϥϣⲁⲛϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲛⲧⲉϥⲧⲁⲕⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲓⲉ ⳿ⲛⲧⲉϥϯⲟⲥⲓ ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ⲫⲏ ⲅⲁⲣ ⲉⲑⲛⲁϣⲓⲡⲓ ϧⲁ⳿ⲧϩⲏ ⲛⲉⲙ ⲛⲁⲥⲁϫⲓ ⲫⲁⲓ ϩⲱϥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁ ϯϣⲓⲡⲓ ⲛⲁϥ ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ϧⲉⲛ ⲡⲉϥⲱⲟⲩ ⲛⲉⲙ ⲁ ⲉϥⲓⲱⲧ ⲛⲉⲙ ⲛⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲧⲁ⳿ⲫⲙⲏⲓ ϫⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ϧⲉⲛ ⲛⲏⲉⲧⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⲛⲏ ⲧⲉ⳿ⲛⲥⲉⲛⲁϫⲉⲙϯⲡⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲁⲛ ϣⲁⲧⲟⲩⲛⲁⲩ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓⲥⲁϫⲓ ⲛⲁⲩ ⲏ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥⲱⲗⲓ ⲙⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏⲥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲡϫⲓⲛ⳿ⲑⲣⲉϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲁϥϣⲱⲃⲧ ⳿ⲛϫⲉ ⲡⲁⲟⲩⲁⲛ ⳿ⲛⲧⲉ ⲡⲉϥϩⲟ ⲟⲩⲟϩ ⲡⲉϥϭⲓ⳿ϩⲃⲟⲥ ⲁϥⲟⲩⲃⲁϣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲉϥϩⲓⲥⲉⲧⲉⲃⲣⲏϫ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲣⲱⲙⲓ ⲃ̅ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲉⲧⲉ ⲙⲱ⳿ⲩⲥⲏⲥ ⲡⲉ ⲛⲉⲙ ⲏⲗⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ⲛⲏⲉⲧⲁⲩⲟⲩⲟⲛϩⲟⲩ ϧⲉⲛ ⲟⲩⲱⲟⲩ ⲛⲁⲩⲥⲁϫⲓ ⳿ⲙⲡⲉϥⲙⲱⲓⲧ ⲉⲃⲟⲗ ⲫⲏ ⳿ⲉⲛⲁϥⲛⲁϫⲟⲕϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲁϥ ⲛⲉⲁⲩ⳿ϩⲣⲟϣ ⳿ⲛϩⲓⲛⲓⲙ ⲡⲉ ⲉⲧⲁⲩⲉⲣ⳿ϣⲣⲱⲓⲥ ⲇⲉ ⲁⲩⲛⲁⲩ ⲉⲡⲉϥⲱⲟⲩ ⲛⲉⲙ ⲡⲓⲣⲱⲙⲓ ⲃ̅ ⲛⲏ ⳿ⲉⲛⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲩⲛⲁⲫⲱⲣϫ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲁⲛⲉⲥ ⲛⲁⲛ ⳿ⲛⲧⲉⲛϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩⲟϩ ⲓⲥϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲛⲧⲉⲛⲑⲁⲙⲓⲟ ⳿ⲛⲅ̅ϯ ⳿ⲛ⳿ⲥⲕⲩⲛⲏ ⲟⲩ⳿ⲓ ⲛⲁⲕ ⲛⲉⲙ ⲟⲩ⳿ⲓ ⳿ⲙⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲟϩ ⲟⲩ⳿ⲓ ⲛⲏⲗⲓⲁⲥ ⳿ⲙ⳿ϥ⳿ⲉⲙⲓ ⲁⲛ ⳿ⲉⲡⲉⲧⲁϥϫⲱ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ⲛⲁⲓ ⲇⲉ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩϭⲏⲡⲓ ⲟⲩⲟϩ ⲁⲥⲉⲣϧⲏⲓⲃⲓ ⳿ⲉϫⲱⲟⲩ ⲁⲩⲉⲣϩⲟϯ ⲇⲉ ⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯϭⲏⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯϭⲏⲡⲓ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⲉⲧⲥⲟⲧⲡ ⲥⲱⲧⲉⲙ ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ⲟⲩⲟϩ ⲉⲧⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ϯ⳿ⲥⲙⲏ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲡⲉⲧⲁⲩϫⲉⲙϥ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲁⲩ ⲭⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲧⲁⲙⲉ ⳿ϩⲗⲓ ϧⲉⲛ ⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲛⲛⲏⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ⲡⲓⲧⲱⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ϯ ϩⲟ ⳿ⲉⲣⲟⲕ ϫⲟⲩϣⲧ ⳿ⲉⲡⲁϣⲏⲣⲓ ϫⲉ ⲩϣⲏⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲏⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⳿ϥⲛⲏⲟⲩ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲟⲩⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⳿ϥⲱϣ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ϥⲣⲱϧⲧ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⲣⲱϥ ϫⲉϣ ⳿ⲥⲫⲏⲓϯ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲙⲟⲅⲓⲥ ϣⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⲉϥϧⲟⲙϧⲉⲙ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ⲩⲟϩ ⲓϯϩⲟ ⳿ⲉⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲱ ⲡⲓϫⲱⲟⲩ ⲛⲁⲑⲛⲁϩϯ ⲟⲩⲟϩ ⲉⲧⲫⲟⲛϩ ϣⲁ ⳿ⲑⲛⲁⲩ ϯⲛⲁϣⲱⲡⲓ ⲛⲉⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲉⲣⲁⲛⲉⲭ ⲉⲥⲑⲉ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ⳿ⲓ ⲡⲉⲕϣⲏⲣⲓ ⲛⲏⲓ ⳿ⲙⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ⲉⲧⲓ ϥⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ϩⲁⲣⲟϥ ⲁϥⲣⲁϧⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛϫⲉ ⲡⲓⲇⲉⲙⲱⲛ ⲟⲩⲟϩ ⲁϥ⳿ϣⲧⲉⲣⲑⲱⲣϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓⲇⲉⲙⲱⲛ ⳿ⲛⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲟⲩⲟϩ ϥⲧⲟⲩϫⲉ ⲡⲓ⳿ⲁⲗⲟⲩ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲉⲡⲉϥⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ⲛⲁϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⲧⲏⲣⲟⲩ ⳿ⲉϫⲉⲛ ϯⲙⲉⲑⲛⲓϣϯ ⳿ⲛⲧⲉ ⲫϯ ⲉⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲛⲁϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲭⲁ ⲛⲁⲓⲥⲁϫⲓ ϧⲉⲛ ⲛⲉⲧⲉⲛⲙⲁϣϫ ⳿ⲡϣⲏⲣⲓ ⲅⲁⲣ ⲙ⳿ⲫⲣⲱⲙⲓ ⲥⲉⲛⲁⲧⲏ ⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲱⲃϣ ⳿ⲉⲡⲁⲓⲥⲁϫⲓ ⲡⲉ ⲟⲩⲟϩ ⲛⲁϥϩⲏⲡ ⳿ⲉⲣⲱⲟⲩ ⲡⲉ ⲟⲩⲟϩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲕⲁϯ ⳿ⲉⲣⲟϥ ⲛⲁⲩⲉⲣϩⲟϯ ⳿ⲉϣⲉⲛϥ ⲡⲉ ⲉⲑⲃⲉ ⲡⲁⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲙⲟⲕⲙⲉⲕ ϫⲉ ⲛⲓⲙ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ⲓⲛⲓϣϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲡⲓⲙⲟⲕⲙⲉⲕ ⳿ⲛⲧⲉ ⲡⲟⲩϩⲏⲧ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲟⲩ⳿ⲁⲗⲟⲩ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ϧⲁⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲏ ⲉⲑⲛⲁϣⲉⲡ ⲡⲁⲓ⳿ⲁⲗⲟⲩ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲁϥϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲁϥϣⲱⲡ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲫⲏ ⲅⲁⲣ ⲉⲧⲟⲓ ⳿ⲛⲕⲟⲩϫⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲧⲏⲣⲟⲩ ⲫⲁⲓ ⲡⲉ ⲡⲓⲛⲓϣϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲁⲛⲛⲁⲩ ⳿ⲉⲟⲩⲁⲓ ⲉϥϩⲓ ⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲉⲛ ⲉⲕⲣⲁⲛ ⲟⲩⲟϩ ⲁⲛⲧⲁϩⲛⲟ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ϥⲙⲟϣⲓ ⲛⲉⲙⲁⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⲟⲩ ⲅⲁⲣ ⳿ϥϯ ⲁⲛ ⲟⲩⲃⲉ ⲑⲏⲛⲟⲩ ⲫⲏ ⲅⲁⲣ ⲉⲧⲉ⳿ⲛ⳿ϥϯ ⲟⲩⲃⲉ ⲑⲏⲛⲟⲩ ⲁⲛ ⲁϥϯ ϩⲓ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲧⲉϥ⳿ⲁⲛⲁⲗⲩⲙⲯⲓⲥ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲁϥⲥⲉⲙⲛⲉ ⲡⲉϥϩⲟ ⳿ⲉϣⲉ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛϩⲁⲛⲣⲉⲙ⳿ⲛϩⲱⲃ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⲟⲩⲟϩ ⲉⲧⲁⲩϣⲉ ⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩϯⲙⲓ ⳿ⲛⲧⲉ ⲓⲥⲁⲙⲁⲣⲓⲧⲏⲥ ϩⲱⲥⲧⲉ ⳿ⲉⲥⲟⲃϯ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲁⲣⲉ ⳿ϩⲣⲁϥ ⲟⲩⲉϩ ⲡⲉ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲡ⳪ ⳿ⲭⲟⲩⲱϣ ⳿ⲛⲧⲉⲛϫⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩ ⳿ⲭⲣⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲛⲧⲉϥⲣⲟⲕϩⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲉⲣϩⲱⲃ ⳿ⲛϫⲉ ⲏⲗⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ⲉⲧⲁϥⲫⲟⲛϩϥ ⲇⲉ ⲁϥⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲁϣ ⳿ⲙⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉϥ⳿ⲓ ⲁⲛ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ⲉⲧⲁⲕⲉ ⲛⲓⲯⲩⲭⲏ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲁⲗⲗⲁ ⳿ⲉⲧⲁⲛϧⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ⲟⲩⲟϩ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉⲕⲉϯⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ⲟⲩⲟϩ ⲉⲩⲙⲟϣⲓ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲛⲁϥ ϫⲉ ⳿ⲛⲧⲁⲙⲟϣⲓ ⳿ⲛⲥⲱⲕ ⳿ⲉ⳿ⲫⲙⲁ ⳿ⲉⲧⲉⲕϣⲉ ⲛⲁⲕ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ⲛⲓⲃⲁϣⲟⲣ ⲩⲟⲛⲧⲟⲩ ⲃⲏⲃ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲟⲩⲟⲛⲧⲟⲩ ⲙⲁ⳿ⲛⲟⲩⲟϩ ⳿ⲡϣⲏⲣⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ⲙⲙⲟⲛⲧⲉϥ ⲙⲁ⳿ⲛⲟⲩⲁϩϫⲱϥ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ⲉϫⲁϥ ⲇⲉ ⳿ⲛⲕⲉⲟⲩⲁⲓ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲏⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲁϣⲉ ⳿ⲛⲧⲁⲑⲱⲙⲥ ⳿ⲙⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ⲡⲉϫⲁϥ ⲁϥ ⲉ ⲭⲁ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲙⲁⲣⲟⲩⲕⲉⲥ ⲛⲟⲩⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲙⲁϣⲉ ⲛⲁⲕ ϩⲓⲱⲓϣ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲛⲁⲙⲟϣⲓ ⳿ⲛⲥⲱⲕ Ⲡ⳪ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲏⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲁⲉⲣⲁⲡⲟⲧⲁⲍⲉⲥⲑⲉ ⳿ⲛⲛⲏⲉⲧϧⲉⲛ ⲡⲁⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲉⲁϥϩⲓⲧⲟⲧϥ ⳿ⲉⲟⲩϩⲉⲃⲓ ⳿ⲛⲧⲉϥϫⲟⲩϣⲧ ⳿ⲉⲫⲁϩⲟⲩ ⲛⲁϣⲱⲡⲓ ⲉϥⲥⲟⲩⲧⲱⲛ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ");
INSERT INTO copcnt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲁ Ⲡ⳪ ⲟⲩⲱⲛϩ ⲛⲕⲉⲟ̅ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲛⲃ̅ ⲃ̅ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉⲛⲁϥⲛⲁϣⲉ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲟⲩ ⲡⲉ ϫⲉ ⲡⲓⲱⲥϧ ⲙⲉⲛ ⲟⲩⲛⲓϣϯ ⲡⲉ ⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⲇⲉ ϩⲁⲛⲕⲟⲩϫⲓ ⲛⲉ ⲧⲱⲃϩ ⲟⲩⲛ ⲙⲠ⳪ ⳿ⲙⲡⲓⲱⲥϧ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛϩⲁⲛⲉⲣⲅⲁⲧⲏⲥ ⲉⲃⲟⲗ ⳿ⲉⲡⲉϥⲱⲥϧ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯⲟⲩⲱⲣⲡ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛϩⲓⲏⲃ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲱⲛϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","⳿ⲙⲡⲉⲣϥⲁⲓ ⲛⲁⲥⲟⲩ⳿ⲓ ⲟⲩⲇⲉ ⲡⲏⲣⲁ ⲟⲩⲇⲉ ⲑⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲛ⳿ϩⲗⲓ ϩⲓ ⳿ⲫⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ⲡⲓⲏⲓ ⲇⲉ ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲁϫⲟⲥ ⳿ⲛϣⲟⲣⲡ ϫⲉ ⳿ⲧϩⲓⲣⲏⲛⲏ ⳿ⲙⲡⲁⲓⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ⲟⲩⲟϩ ⲉϣⲱⲡ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⳿ⲛϯϩⲓⲣⲏⲛⲏ ⳿ⲙⲙⲁⲩ ⲧⲉⲧⲉⲛϩⲓⲣⲏⲛⲏ ⲉⲥ⳿ⲉⲙⲧⲟⲛ ⳿ⲙⲙⲟⲥ ⳿ⲉϫⲱϥ ⲉϣⲱⲡ ⲙⲙⲟⲛ ⲧⲉⲧⲉⲛϩⲓⲣⲏⲛⲏ ⲉⲥ⳿ⲉⲕⲟⲧⲥ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲉⲧⲉⲛⲟⲩⲱⲙ ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛⲥⲱ ⳿ⲛⲛⲏⲉⲧⲉⲛⲧⲱⲟⲩ ⲡⲓⲉⲣⲅⲁⲧⲏⲥ ⲅⲁⲣ ⳿ϥ⳿ⲙⲡϣⲁ ⳿ⲛⲧⲉϥ⳿ϧⲣⲉ ⳿ⲙⲡⲉⲣⲟⲩⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲏⲓ ⳿ⲉⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ⲟⲩⲟϩ ϯⲃⲁⲕⲓ ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ ⲟⲩⲟϩ ⲛⲧⲟⲩϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲱⲙ ⳿ⲛⲛⲏⲉⲧⲟⲩⲛⲁⲭⲁⲩ ϧⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ⲟⲩⲟϩ ⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲛϧⲏⲧⲥ ⲁⲣⲓⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲁϫⲟⲥ ⲛⲱⲟⲩ ⲉ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ϯⲃⲁⲕⲓ ⲇⲉ ⲉⲧⲉⲧⲉⲛⲛⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁⲙⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲥ⳿ⲡⲗⲁⲧⲓ⳿ⲁ ⳿ⲁϫⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ϫⲉ ⲡⲓⲕⲉϣⲱⲓϣ ⲉⲧⲁϥⲧⲱⲙⲓ ⳿ⲉⲛⲉⲛ ϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲉⲧⲉⲛⲃⲁⲕⲓ ⲧⲉⲛⲛⲁⲛⲉϩϥ ⲛⲱⲧⲉⲛ ⲉⲃⲟⲗ ⳿ⲡⲗⲏⲛ ⲫⲁⲓ ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲉⲙⲧⲟⲛ ⲛⲁϣⲱⲡⲓ ⲛⲥⲟⲇⲟⲙⲁ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉϩⲟⲧⲉ ϯⲃⲁⲕⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ⲟⲩⲟⲓ ⲛⲉ ⲭⲟⲣⲁⲍⲓⲛ ⲟⲩⲟⲓ ⲛⲉ ⲃⲏⲑⲥⲁⲓⲇⲁ ϫⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲧⲩⲣⲟⲥ ⲉⲙ ⳿ⲧⲥⲓⲇⲱⲛ ⲉⲛⲉ ⲁⲩϣⲱⲡⲓ ⳿ⲛϫⲉ ⲛⲁⲓϫⲟⲙ ⲉⲧⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲉⲓ⳿ⲥⲑⲛⲉⲓ ⲁⲩⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲉⲩϩⲉⲙⲥⲓ ϧⲉⲛ ⲟⲩⲥⲟⲕ ⲛⲉⲙ ⲟⲩⲕⲉⲣⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ⲡⲗⲏⲛ ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲥⲓⲇⲱⲛ ⲟⲩⲟⲛ ⲟⲩⲉⲙⲧⲟⲛ ⲛⲁϣⲱⲡⲓ ⲛⲱⲟⲩ ϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⲉϩⲟⲧⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ⲟⲩⲟϩ ⳿ⲛⲑⲟ ϩⲱⲓ ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲙⲏ ⲧⲉⲣⲁϭⲓⲥⲓ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲥⲉⲛⲁⲑⲉⲃⲓ⳿ⲟ ϣⲁ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉ⳿ⲁⲙⲉⲛϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ⲫⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲧⲉⲛ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧϣⲱϣ ⲙⲙⲱⲧⲉⲛ ⲁϥϣⲱϣ ⳿ⲙⲙⲟⲓ ⲫⲏⲉⲧϣⲱϣ ⳿ⲙⲙⲟⲓ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ⲁⲩⲧⲁⲥⲑⲟ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲟ̅ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲓⲕⲉⲇⲉⲙⲱⲛ ⲥⲉϭⲛⲟ ⳿ⲛϫⲱⲟⲩ ⲛⲁⲛ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲁⲓⲛⲁⲩ ⳿ⲉ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲉⲁϥϩⲉⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲥⲉⲧⲉⲃⲣⲏϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ϩⲏⲡⲡⲉ ⲁⲓϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲉⲣϣⲓϣⲓ ⳿ⲉϩⲱⲙⲓ ⳿ⲉϫⲉⲛ ϩⲁⲛϩⲟϥ ⲛⲉⲙ ϩⲁⲛϭⲗⲏ ⲛⲉⲙ ⳿ⲉϫⲉⲛ ϯϫⲟⲙ ⲧⲏⲣⲥ ⳿ⲛⲧⲉ ⲡⲓϫⲁϫⲓ ⲩⲟϩ ⳿ⲛⲛⲉϥϭⲓ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲟⲛⲥ ⳿ⲛ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","⳿ⲡⲗⲏⲛ ⳿ⲙⲡⲉⲣⲣⲁϣⲓ ϧⲉⲛ ⲫⲁⲓ ϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲥⲉϭⲛⲟ ⳿ⲛϫⲱⲟⲩ ⲛⲱⲧⲉⲛ ⲣⲁϣⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ϫⲉ ⲛⲉⲧⲉⲛⲣⲁⲛ ⲉ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲑⲉⲗⲏⲗ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϯⲟⲩⲱⲛϩ ⲛⲁⲕ ⲉⲃⲟⲗ ⳿ⲫⲓⲱⲧ Ⲡ⳪ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲓⲕⲁϩⲓ ϫⲉ ⲁⲕϩⲉⲡ ⲛⲁⲓ ⳿ⲉϩⲁⲛⲥⲁⲃⲉⲩ ⲛⲉⲙ ϩⲁⲛⲕⲁⲧϩⲏⲧ ⲟⲩⲟϩ ⲁⲕϭⲟⲣⲡⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲁϩⲁ ⳿ⲫⲓⲱⲧ ϫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓϯⲙⲁϯ ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲡⲉⲕ⳿ⲙⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲩⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⳿ⲛⲧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲱⲟⲩⲛ ϫⲉ ⲛⲓⲙ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ϫⲉ ⲛⲓⲙ ⲡⲉ ⳿ⲫⲓⲱⲧ ⳿ⲉⲃⲏⲗ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⲛⲉⲙ ⲫⲏⲉⲧⲉ ⳿ⲡϣⲏⲣⲓ ⲟⲩⲱϣ ⳿ⲉϭⲱⲣⲡ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ⲩⲟϩ ⲉⲧⲁϥⲕⲟⲧϥ ⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲥⲁ⳿ⲡⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲡⲉϫⲁϥ ϫⲉ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲃⲁⲗ ⲉⲑⲛⲁⲩ ⳿ⲉⲛⲏⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ϯϫⲱ ⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲁⲛⲙⲏ ϣ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ϩⲁⲛⲟⲩⲣⲱⲟⲩ ⲁⲩⲟⲩⲱϣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲛⲏⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⲟⲩⲟϩ ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲛⲏⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲛⲟⲙⲓⲕⲟⲥ ⲁϥⲧⲱⲛϥ ⲁϥⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩ ⲡⲉϯⲛⲁⲛⲁⲓϥ ⳿ⲛⲧⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲟⲩ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲓⲛⲟⲙⲟⲥ ⲓⲉ ⲁⲕⲱϣ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ϫⲉ ⲉⲕ⳿ⲉⲙⲉⲛⲣⲉ Ⲡ⳪ ⲡⲉⲕⲛⲟⲩϯ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲕϩⲏ ⲧ ⲧⲏⲣϥ ⲛⲉⲙ ⲉⲕⲯⲩⲭⲏ ⲧⲏⲣⲥ ⲛⲉⲙ ⲧⲉⲕϫⲟⲙ ⲧⲏⲣⲥ ⲛⲉⲙ ϧⲉⲛ ⲛⲉⲕⲙⲉⲩⲓ ⲧⲏⲣϥ ⲛⲉⲙ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ϫⲉ ⲁⲕⲉⲣⲟⲩⲱ ϧⲉⲛ ⲩⲥⲱⲟⲩⲧⲉⲛ ⲫⲁⲓ ⳿ⲁⲣⲓⲧϥ ⲟⲩⲟϩ ⳿ⲭⲛⲁⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉ⳿ⲑⲙⲁⲓ⳿ⲟ ⲡⲉϫⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ϩⲱϥ ⲡⲉ ⲡⲁ⳿ϣⲫⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲓⲉⲣⲓⲭⲱ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛⲥⲓⲛⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⲧⲁⲩⲃⲁϣϥ ⲁⲩϯ ⳿ⲛϩⲁⲛⲉⲣϧⲱⲧ ⲛⲁϥ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⲁⲩⲭⲁϥ ⲉϥⲟⲓ ⳿ⲙⲫⲁϣⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ⲕⲁⲧⲁ ⲟⲩϯⲙⲁϯ ⲇⲉ ⲟⲩⲟⲩⲏⲃ ⲛⲁϥⲛⲏ ⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁϥⲥⲉⲛϥ ⲁϥⲭⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ⲕⲉⲗⲉⲩⲓⲧⲏⲥ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ϥⲭⲁϥ ⲁϥⲥⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ⲟⲩⲥⲁⲙⲁⲣⲓⲧⲏⲥ ⲇⲉ ⲁϥⲙⲟϣⲓ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁϥϣⲉⲛϩⲏ ⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ϥⲙⲟⲩⲣ ⳿ⲛⲛⲉϥⲉⲣϧⲱⲧ ⲁϥϯ ⲛⲉϩ ϩⲓ ⲏⲣⲡ ⳿ⲛⲥⲱⲟⲩ ⲉⲧⲁϥⲧⲁⲗⲟϥ ⳿ⲉⲡⲉⲧⲉⲫⲱϥ ⳿ⲛⲧⲉⲃⲛⲏ ⲁϥ⳿ⲉⲛϥ ⳿ⲉⲟⲩⲡⲁⲛⲧⲟⲭⲓⲟⲛ ⲟⲩⲟϩ ⲁϥϥⲓ ⲡⲉϥⲣⲱⲟⲩϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ⲟⲩⲟϩ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲁϥⲉⲛ ⲇⲏⲛⲁⲣⲓⲟⲛ ⲃ̅ ⳿ⲉⲃⲟⲗ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲙⲡⲓⲡⲁⲛⲧⲟⲭⲉⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϥⲓ ⲡⲉϥⲣⲱⲟⲩϣ ϧⲉⲛ ⲛⲁⲓ ⲟⲩⲟϩ ⲡⲓϩⲟⲩ⳿ⲟ ⲉⲧⲉⲕⲛⲁϭⲟϥ ⳿ⲉⲃⲟⲗ ⳿ⲉⲣⲟϥ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛⲧⲁⲥⲑⲟ ϯⲛⲁⲧⲏⲓϥ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ⲛⲓⲙ ⲟⲩⲛ ϧⲉⲛ ⲡⲁⲓⲅ̅ ⲉⲧⲉⲕⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⲁϥⲉⲣ⳿ϣⲫⲏⲣ ⲙⲫⲏⲉⲧⲁϥ⳿ⲓ ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲥⲓⲛⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲫⲏⲉⲧⲁϥ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲛⲁⲓ ⲛⲉⲙⲁϥ ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⲁⲣⲓⲟⲩ⳿ⲓ ϩⲱⲕ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ⲉⲩⲙⲟϣⲓ ⲇⲉ ⲁϥϣⲉ ⲛⲁϥ ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩϯⲙⲓ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲙⲁⲣⲑⲁ ⲁⲥϣⲟⲡϥ ⳿ⲉⲣⲟⲥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉⲥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛⲧⲉ ⲑⲁⲓ ⳿ⲛⲟⲩⲥⲱⲛⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲙⲁⲣⲓ⳿ⲁ ⲟⲩⲟϩ ⲉⲧⲁⲥϩⲉⲙⲥⲓ ϧⲁⲧⲉⲛ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲙⲠ⳪ ⲛⲁⲥⲥⲱⲧⲉⲙ ⳿ⲉⲡⲉϥⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ⲙⲁⲣⲑⲁ ⲇⲉ ⲛⲁⲥϭⲓ ⳿ⲛ⳿ϩⲣⲁⲥ ⲡⲉ ⳿ⲙ⳿ⲡⲕⲱϯ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛϣⲉⲙϣⲓ ⲉⲧⲁⲥⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ ⲡⲉϫⲁⲥ ϫⲉ Ⲡ⳪ ⳿ⲥⲉⲣⲙⲉⲗⲓ ⲛⲁⲕ ⲁⲛ ϫⲉ ⲁ ⲧⲁⲥⲱⲛⲓ ⲭⲁⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲉⲓϣⲉⲙϣⲓ ⳿ⲁϫⲟⲥ ⲟⲩⲛ ⲛⲁⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥϯⲧⲟⲧⲥ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲙⲁⲣⲑⲁ ⲙⲁⲣⲑⲁ ⲉϥⲓⲣⲱⲟⲩϣ ⲟⲩⲟϩ ⲧⲉ⳿ϣⲧⲉⲣⲑⲱⲣ ⲉⲑⲃⲉ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ϩⲁⲛⲕⲟⲩϫⲓ ⲇⲉ ⲡⲉ ϯ⳿ⲭⲣⲓⲁ ⲓⲉ ⲟⲩⲁⲓ ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ⲁⲥⲥⲱⲧⲡ ⲛⲁⲥ ⳿ⲛϯⲧⲟⲓ ⲉⲑⲛⲁⲛⲉⲥ ⲑⲏ ⲧⲉ⳿ⲛⲥⲉⲛⲁ⳿ϣⲟⲗϥ ⳿ⲛⲧⲟⲧⲥ ⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉϥⲭⲏ ϧⲉⲛ ⲟⲩⲙⲁ ⲉϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲉⲧⲁϥⲕⲏⲛ ⲡⲉϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲛⲁϥ ϫⲉ ⳪ ⲙⲁ⳿ⲧⲥⲁⲃⲟⲛ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲧⲥⲁⲃⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ϩⲟⲧⲁⲛ ⲣⲉⲧⲉⲛϣⲁⲛⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⳿ⲁϫⲟⲥ ⲡⲉⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲙⲁⲣⲉϥⲧⲟⲩⲃⲟ ⳿ⲛϫⲉ ⲡⲉⲕⲣⲁⲛ ⲙⲁⲣⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉⲕⲙⲉⲧⲟⲩⲣⲟ ⲡⲉⲧⲉϩⲛⲁⲕ ⲁⲣⲉϥϣⲱⲡⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ϧⲉⲛ ⳿ⲧⲫⲉ ⲛⲉⲙ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ⲡⲉⲛⲱⲓⲕ ⲉⲑⲛⲏⲟⲩ ⲙⲏⲓϥ ⲛⲁⲛ ⳿ⲙⲙⲏⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ⲟⲩⲟϩ ⲭⲁ ⲛⲉⲛⲛⲟⲃⲓ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ⲉ ⲅⲁⲣ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⲧⲉⲛⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲁⲛ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲛⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲟⲩⲟⲛⲧⲉϥ ⳿ϣⲫⲏⲣ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϣⲉ ϣⲁⲣⲟϥ ⳿ⲛ⳿ⲧⲫⲁϣⲓ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϫⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲁ⳿ϣⲫⲏⲣ ⲙⲁ ⲅ̅ ⲛⲱⲓⲕ ⲛⲏⲓ ⳿ⲉⲡⲟⲩϣⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ϫⲉ ⲟⲩ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲏⲓ ⲁϥ⳿ⲓ ϣⲁⲣⲟⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ⳿ⲫⲙⲱⲓⲧ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲫⲏ ⳿ⲉϯⲛⲁⲭⲁϥ ϧⲁⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲏ ϩⲱϥ ⲉⲧⲥⲁϧⲟⲩⲛ ⳿ⲉⲣⲟⲩⲱ ⳿ⲛⲧⲉϥϫⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣϯ ϧⲓⲥⲓ ⲛⲏⲓ ⲁⲓⲟⲩⲱ ⲅⲁⲣ ⲁⲓⲙⲁ⳿ϣⲑⲁⲙ ⳿ⲙⲡⲁⲣⲟ ⲟⲩⲟϩ ⲛⲁ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲥⲉⲭⲏ ⲛⲉⲙⲏⲓ ϩⲓϫⲉⲛ ⲁⲙⲁ⳿ⲛ⳿ⲛⲕⲟⲧ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉⲧⲱⲛⲧ ⳿ⲛⲧⲁϯ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲕⲁⲛ ⲁϥ⳿ϣⲧⲉⲙⲧⲱⲛϥ ⳿ⲉϯ ⲛⲁϥ ϫⲉ ⲡⲉϥ⳿ϣⲫⲏⲣ ⲡⲉ ⲉⲑⲃⲉ ⲧⲉϥⲙⲉⲧⲗⲁϫⲓ ⲇⲉ ⲉϥ⳿ⲉⲧⲱⲛϥ ⳿ⲛⲧⲉϥϯ ⲛⲁϥ ⳿ⲛⲛⲏⲉⲧⲁϥⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","⳿ⲁⲛⲟⲕ ϩⲱ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲓ⳿ⲉⲧⲓⲛ ⲟⲩⲟϩ ⲉⲛⲁϯ ⲛⲱⲧⲉⲛ ⲕⲱϯ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϫⲓⲙⲓ ⲕⲱⲗϩ ⲟⲩⲟϩ ⲥⲉⲛⲁⲟⲩⲱⲛ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲣ⳿ⲉⲧⲓⲛ ϣⲁϥϭⲓ ⲟⲩⲟϩ ⲫⲏ ⲧⲕⲱϯ ϣⲁϥϫⲓⲙⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲕⲱⲗϩ ϣⲁⲩⲟⲩⲱⲛ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ⲛⲓⲙ ⲇⲉ ⳿ⲛⲓⲱⲧ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲡⲉϥϣⲏⲣⲓ ⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲱⲓⲕ ⲏ ⳿ϥⲛⲁϯ ⳿ⲛⲟⲩⲱⲛⲓ ⲛⲁϥ ⲓⲉ ⳿ⲛⲧⲉϥ⳿ⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲧⲉⲃⲧ ⲙⲏ ⳿ⲛⲧⲉϥϣⲉⲃⲓⲱ ⳿ⲛⲟⲩⲧⲉⲃⲧ ⳿ϥⲛⲁϯ ⳿ⲛⲟⲩϩⲟϥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ⲓⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ⲉⲧⲓⲛ ⲛⲟⲩⲥⲱⲟⲩϩⲓ ⲙⲏ ⳿ϥⲛⲁϯ ⳿ⲛⲟⲩϭⲗⲏ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ⲓⲥϫⲉ ⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲥⲁ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲉϯ ⲛϩⲁⲛⲧⲁⲓⲟ ⳿ⲉⲛⲁⲛⲉⲩ ⳿ⲛⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲡⲟⲥⲱ ⲙⲁⲗⲗⲟⲛ ⳿ⲫⲓⲱⲧ ⳿ϥⲛⲁϯ ⳿ⲛⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲛⲛⲏⲉⲧⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ⲟⲩⲟϩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲇⲉⲙⲱⲛ ⳿ⲛⲕⲟⲩⲣ ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲇⲉⲙⲱⲛ ⲁϥⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓⲕⲟⲩⲣ ⲟⲩⲟϩ ⲁⲩⲉⲣ⳿ϣⲫⲏ ⲣⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉϫⲱⲟⲩ ϫⲉ ϧⲉⲛ ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲧⲟⲧϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","⳿ⲛⲑⲟϥ ⲇⲉ ⲉϥⲥⲱⲟⲩⲛ ⳿ⲛⲛⲟⲩⲙⲉⲩⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲉ ⲙⲉⲧⲟⲩⲣⲟ ⲛⲓⲃⲉⲛ ⲁⲥϣⲁⲛⲫⲱϣ ⳿ⲉϫⲱⲥ ϣⲁⲥϣⲱϥ ⲟⲩⲟϩ ⲟⲩⲏⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲏⲓ ϣⲁϥϩⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ⲓⲥϫⲉ ⲇⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ϩⲱϥ ⲁϥⲫⲱϣ ⳿ⲉϫⲱϥ ⲙⲙⲁⲩⲁⲧϥ ⲡⲱⲥ ϫⲉ ⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ ⲛⲁ⳿ϣⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ ϫⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϧⲉⲛ ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ϯϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ⲓⲥϫⲉ ⲉ ⳿ⲁⲛⲟⲕ ϧⲉⲛ ⲃⲉⲗⲍⲉⲃⲟⲩⲗ ϯϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲙ ⲉⲑⲃⲉⲫⲁⲓ ⳿ⲛⲑⲱⲟⲩ ⲥⲉⲉⲣⲣⲉϥϯϩⲁⲡ ⳿ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ⲓⲥϫⲉ ⲇⲉ ⳿ⲁⲛⲟⲕ ϧⲉⲛ ⲟⲩⲧⲏⲃ ⳿ⲛⲧⲉ ⲫϯ ϯϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲁ ⲁⲥⲫⲟϩ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ϣⲱⲡ ⲅⲁⲣ ⲁⲣⲉϣⲁⲛ ⲡⲓϫⲱⲣⲓ ϧⲟⲕϥ ⳿ⲛⲧⲉϥ⳿ⲁⲣⲉϩ ⳿ⲉⲧⲉϥⲁⲩⲗⲏ ϣⲁⲣⲉ ⲛⲉϥϩⲩⲡⲁⲣ ⲭⲟⲛⲧ⳿ⲁ ϣⲱⲡⲓ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉ ⲩϫⲱⲣⲓ ⳿ⲉⲣⲟϥ ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϭⲣⲟ ⳿ⲉⲣⲟϥ ϣⲁϥⲱⲗⲓ ⳿ⲙⲡⲉϥϧⲱⲕ ⲫⲏ ⳿ⲉⲛⲁⲣⲉ ⳿ϩⲑⲏϥ ⲭⲏ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ϣⲁϥϫⲱⲣ ⳿ⲛⲛⲉϥϣⲱⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ⲏ ⲧⲉ⳿ⲛ⳿ϥⲛⲉⲙⲏⲓ ⲁⲛ ⲁϥϯⲟⲩⲃⲏⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲉⲣⲥⲩⲛⲁⲅⲓⲥⲑⲉ ⲛⲉⲙⲏⲓ ⳿ϥϫⲱⲣ ⳿ⲙⲙⲟⲓ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ⲉϣⲱⲡ ⲁⲣⲉϣⲁⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⳿ⲓ ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲣⲱⲙⲓ ϣⲁϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϩⲁⲛⲙⲁ⳿ⲛⲁⲑⲙⲱⲟⲩ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲁ⳿ⲛ⳿ⲙⲧⲟⲛ ⲟⲩⲟϩ ⲁϥ⳿ϣⲧⲉⲙϫⲓⲙⲓ ⲧⲟⲧⲉ ⲁϥϫⲟⲥ ϫⲉ ⲛⲁⲧⲁⲥⲑⲟ ⲉⲡⲁⲏⲓ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ⲟⲩⲟϩ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛⲧⲉϥϫⲉⲙϥ ⲉϥ⳿ⲥⲣⲱϥⲧ ⲉϥ⳿ⲥⲣⲁϩ ⲉϥⲥⲉⲗⲥⲱⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ⲧⲟⲧⲉ ϣⲁϥϣⲉ ⲛⲁϥ ⲟⲩⲟϩ ⲁϥϫⲓⲙⲓ ⳿ⲛⲕⲉⲍ̅ ⳿ⲙⲡ͞ⲛⲁ̅ ⲉⲩϩⲱⲟⲩ ⳿ⲉϩⲟⲧⲉⲣⲟϥ ⲟⲩⲟϩ ⲁⲩϣⲁⲛϣⲉ ⳿ⲉϧⲟⲩⲛ ϣⲁⲩϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓϧⲁⲉⲩ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲧϩⲱⲟⲩ ⳿ⲉⲛⲉϥϩⲟⲩⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉϥϫⲱ ⳿ⲛⲛⲁⲓ ⲁ ⲟⲩ⳿ⲥϩⲓⲙⲓ ϥⲁⲓ ⳿ⲛⲟⲩ⳿ⲥⲙⲏ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲥ ⲛϯⲛⲉϫⲓ ⲉⲧⲁⲥϥⲓⲧⲕ ⲛⲉⲙ ⲛⲓⲉⲙⲛⲟϯ ⲉⲧⲁⲩϣⲁⲛⲟⲩϣⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲙⲉⲛⲟⲩⲛⲅⲉ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⲉⲧⲁⲣⲉϩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ⲉⲩⲛⲁⲑⲱⲟⲩϯ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲁϥⲉⲣϩⲏ ⲧⲥ ⳿ⲛϫⲟⲥ ϫⲉ ⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ ⲟⲩⲅⲉⲛⲉ⳿ⲁ ⲉⲥϩⲱⲟⲩ ⲧⲉ ⲥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏⲓⲛⲓ ⲟⲩⲟϩ ⲟⲩⲙⲏ ⲓⲛⲓ ⳿ⲛⲛⲟⲩⲧⲏⲓϥ ⲛⲁⲥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ ⲓⲱⲛⲁ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⲉⲧⲁ ⲓⲱⲛⲁ ϣⲱⲡⲓ ⳿ⲛⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲛⲓⲣⲉⲙⲛⲓⲛⲉⲩⲏ ⲡⲁⲓⲣⲏϯ ϩⲱϥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲛⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ϯⲟⲩⲣⲱ ⳿ⲛⲧⲉ ⲥⲁⲣⲏⲥ ⲉⲥ⳿ⲉⲧⲱⲛⲥ ϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⲛⲉⲙ ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲧⲉ ⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ ⲟⲩⲟϩ ⲉⲥ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲁⲧ ⳿ⲙ⳿ⲡⲕⲁϩⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉϯⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲥⲟⲗⲟⲙⲱⲛ ⲟⲩⲟϩ ⲥ ϩⲟⲩ⳿ⲟ ⳿ⲉⲥⲟⲗⲟⲙⲱⲛ ⳿ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲧⲉ ⲛⲓⲛⲉⲩⲏ ⲥⲉⲛⲁⲧⲱⲟⲩⲛⲟⲩ ϧⲉⲛ ϯ⳿ⲕⲣⲓⲥⲓⲥ ⲛⲉⲙ ⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ ⲟⲩⲟϩ ⲥⲉⲛⲁ ϯϩⲁⲡ ⳿ⲉⲣⲟⲥ ϫⲉ ⲩⲉⲣⲙⲉⲧⲁⲛⲓⲟⲛ ⳿ⲉⲡⲓϩⲓⲱⲓϣ ⳿ⲛⲧⲉ ⲓⲱⲛⲁ ⲟⲩⲟϩ ⲓⲥ ϩⲟⲩ⳿ⲟ ⳿ⲉⲓⲱⲛⲁ ⳿ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⲇⲉ ϭⲉⲣⲉ ⲟⲩϧⲏⲃⲥ ⳿ⲛⲧⲉϥⲭⲁϥ ϧⲉⲛ ⲩⲙⲁ⳿ⲛϩⲱⲡ ⲩⲇⲉ ϧⲁ ⲟⲩⲙⲉⲛⲧ ⲁⲗⲗⲁ ϩⲓϫⲉⲛ ϯⲗⲩⲭⲛⲓ⳿ⲁ ϩⲓⲛⲁ ⲛⲏⲉⲑⲛⲁⲉϧⲟⲩⲛ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲉⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","⳿ⲡϧⲏⲃⲥ ⳿ⲙⲡⲉⲕⲥⲱⲙⲁ ⲡⲉ ⲡⲉⲕⲃⲁⲗ ⲉϣⲱⲡ ⳿ⲉⲡⲉⲕⲃⲁⲗ ⲟⲩ⳿ⲁⲡⲗⲟⲩⲥ ⲡⲉ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ⲉϥ⳿ⲉⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲉϣⲱⲡ ⲇⲉ ⲟⲩⲡⲟⲛⲏⲣⲟⲥ ⲡⲉ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ⳿ϥⲟⲓ ⳿ⲛⲭⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","⳿ⲁⲛⲁⲩ ⲏⲡⲱⲥ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲉⲧⲉ⳿ⲛϧⲏⲧⲕ ⲟⲩⲭⲁⲕⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ⲓⲥϫⲉ ⲟⲩⲛ ⲡⲉⲕⲥⲱⲙⲁ ⲧⲏⲣϥ ⲟⲩⲟⲩⲱⲓⲛⲓ ⲡⲉ ⳿ⲙⲙⲟⲛ ⲧⲟⲓ ⳿ⲛⲧⲁϥ ⲟⲓ ⳿ⲛⲭⲉⲙⲥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⲏⲣϥ ϥⲟⲓ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓϧⲏⲃⲥ ϧⲉⲛ ⲡⲓⲥⲉⲧⲉⲃⲣⲏϫ ⲉϥⲉⲉⲣⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ⲉⲧⲁϥⲥⲁϫⲓ ⲇⲉ ⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲫⲁⲣⲓⲥⲉⲟⲥ ϩⲟⲡⲱⲥ ⲛⲧⲉϥⲟⲩⲱⲙ ϧⲁⲧⲟⲧϥ ⲉⲧⲁϥϣⲉ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⲁϥⲣⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ⲡⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⲉⲧⲁϥⲛⲁⲩ ⲁϥⲉⲣ⳿ϣⲫⲏ ⲣⲓ ϫⲉ ⳿ⲙⲡⲉϥϭⲓⲱⲙⲥ ⳿ⲛϣⲟⲣⲡ ϧⲁϫⲉⲛ ⲓⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϯⲛⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ϧⲁ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲧⲉⲧⲉⲛⲧⲟⲩⲃⲟ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲁⲫⲟⲧ ⲛⲉⲙ ⲡⲓⲃⲓⲛⲁϫ ⲥⲁϧⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲧⲉⲛ ⲙⲉϩ ⳿ⲛϩⲱⲗⲉⲙ ⲛⲉⲙ ⲡⲟⲛⲏⲣⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ⲛⲓⲁⲧϩⲏⲧ ⲙⲏ ⲫⲏ ⲁⲛ ⲉⲧⲁϥⲑⲁⲙⲓ⳿ⲉ ⲥⲁⲃⲟⲗ ⳿ⲛⲑⲟϥ ⲟⲛ ⲁϥⲑⲁⲙⲓ⳿ⲉ ⲥⲁϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","⳿ⲡⲗⲏⲛ ⲛⲏⲉⲧϣⲟⲡ ⲙⲏⲓⲧⲟⲩ ⲉⲑⲙⲉⲧⲛⲁⲏ ⲧ ⲟⲩⲟϩ ⲓⲥ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲥⲉⲧⲟⲩⲃⲏⲟⲩⲧ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ⲁⲗⲗⲁ ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛϯ ⳿ⲙ⳿ⲫⲣⲉⲙⲏⲧ ⳿ⲙⲡⲓⲁϭⲓⲛ⳿ⲛⲥⲑⲟⲓ ⲛⲉⲙ ⲡⲓⲃⲁϣⲟⲩϣ ⲛⲉⲙ ⲟⲩⲟϯ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲭⲱ ⳿ⲛⲥⲱⲧⲉⲛ ⳿ⲙⲡⲓϩⲁⲡ ⲛⲉⲙ ϯ⳿ⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲓ ⲇⲉ ⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉⲧⲉⲛⲁⲓⲧⲟⲩ ⲟⲩⲟϩ ⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲭⲁⲩ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲉⲧⲉⲛⲙⲉⲓ ⳿ⲛⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛϩⲉⲙⲥⲓ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲛⲓⲁⲥⲡⲁⲥⲙⲟⲥ ϧⲉⲛ ⲛⲓ⳿ⲁⲅⲟⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲟⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓ⳿ⲙϩⲁⲩ ⲉⲧⲉ⳿ⲛⲥⲉⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲟⲩⲟϩ ⲛⲓⲣⲱⲙⲓ ⲉⲑⲙⲟϣⲓ ϩⲓϫⲱⲟⲩ ⳿ⲛⲥⲉ⳿ⲉⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲓⲛⲟⲙⲓⲕⲟⲥ ⲡⲉϫⲁϥ ⲁϥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲁⲓ ⲉⲕϫⲱ ⳿ⲙⲙⲱⲟⲩ ⳿ⲕϣⲱϣ ⳿ⲙⲙⲟⲛ ϩⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ϧⲁ ⲛⲓⲛⲟⲙⲓⲕⲟⲥ ⲟⲩⲟⲓ ⲱⲧⲉⲛ ⲉ ⲧⲉⲧⲉⲛⲧⲁⲗⲟ ⳿ⲛϩⲁⲛⲉⲧⲫⲱⲟⲩⲓ ⲉⲩⲙⲟⲕϩ ⳿ⲙϥⲓⲧⲟⲩ ⳿ⲉϫⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛϭⲓ ⲛⲉⲙ ⲛⲓⲉⲧⲫⲱⲟⲩ⳿ⲓ ⲁⲛ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲉⲧⲉⲛⲧⲏⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲕⲱⲧ ⳿ⲛⲛⲓ⳿ⲙϩⲁⲩ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲧⲉⲛⲓⲟϯ ⲁⲩϧⲟⲑⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ϩⲁⲣⲁ ⲧⲉⲧⲉⲛⲉⲣⲙⲉⲑⲣⲉ ⲟⲩⲟϩ ⲉⲧⲉⲛϯ ⲙⲁϯ ⳿ⲉϫⲉⲛ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲛⲉⲧⲉⲛⲓⲟϯ ϫⲉ ⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲁⲩϧⲟⲑⲃⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲕⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ⲉⲑⲃⲉⲫⲁⲓ ⲁ ϯⲕⲉⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ϯ ϫⲟⲥ ϫⲉ ϯⲛⲁⲟⲩⲱⲣⲡ ϩⲁⲣⲱⲟⲩ ⳿ⲛϩⲁⲛ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ ⲛⲉⲙ ϩⲁⲛ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϧⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϭⲟϫⲓ ⳿ⲛⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ϩⲓⲛⲁ ⳿ⲛⲥⲉϭⲓ ⳿ⲙ⳿ⲡϣⲓϣ ⳿ⲙ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲛⲓ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ ⲉⲧⲁⲩⲫⲟⲛϥ ⳿ⲉⲃⲟⲗ ⲓⲥϫⲉⲛ ⳿ⲧⲕⲁⲧⲁⲃⲟⲗⲏ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲛⲧⲟⲧⲥ ⳿ⲛⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ⲓⲥϫⲉⲛ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲁⲃⲉⲗ ϣⲁ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲍⲁⲭⲁⲣⲓⲁⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲃⲁⲣⲁⲭⲓⲁⲥ ⲫⲏⲉⲧⲁⲩⲧⲁⲕⲟϥ ⲟⲩⲧⲉ ⲡⲓⲙⲁ⳿ⲛⲉⲣϣⲱⲟⲩϣⲓ ⲛⲉⲙ ⲡⲓⲏⲓ ⲥⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲥⲉⲛⲁⲕⲱϯ ⳿ⲛⲥⲱϥ ⳿ⲛⲧⲟⲧⲥ ⳿ⲛⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ⲟⲩⲟⲓ ⲛⲱⲧⲉⲛ ⳿ⲛⲛⲓⲛⲟⲙⲓⲕⲟⲥ ϫⲉ ⲁⲧⲉⲧⲉⲛⲱⲗⲓ ⳿ⲛⲛⲓϣⲱϣⲧ ⳿ⲛⲧⲉ ⲡⲥⲱⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ⲧⲉⲧⲉⲛⲉⲣⲕⲱⲗⲓⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲉⲥⲟⲙⲥ ⳿ⲛⲕⲁⲕⲱⲥ ⲟⲩⲟϩ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲉⲑⲃⲉ ϩⲁⲛⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ⲉⲩϭⲓ⳿ⲭⲣⲟϥ ⳿ⲉϫⲟⲣϫϥ ⳿ⲛⲟⲩⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","((ⲉⲛ ⲟⲓⲥ ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲑⲃⲁ ⳿ⲙⲙⲏϣ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲟⲩϩⲱⲙⲓ ⳿ⲉϫⲉⲛ ⲛⲟⲩⲉⲣⲏⲟⲩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛϣⲟⲣⲡ ⲙⲁϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲡϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲧⲉ ⲧⲟⲩⲙⲉⲧϣⲟⲃⲓ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲉϥϩⲟⲃⲥ ϫⲉ ⳿ϥⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲡⲉⲧϩⲏⲡ ϫⲉ ⲥⲉⲛⲁ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ⲛⲏ ⲅⲁⲣ ⲉⲧⲉⲧⲉⲛⲛⲁϫⲟⲧⲟⲩ ϧⲉⲛ ⳿ⲡ ⲭⲁⲕⲓ ⲥⲉⲛⲁⲥⲟⲑⲙⲟⲩ ϧⲉⲛ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲁⲣⲉⲧⲉⲛⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⳿ⲫⲙⲁϣϫ ϧⲉⲛ ⲛⲓⲧⲁⲙⲓⲟⲛ ⲉⲩ⳿ⲉϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ϩⲓϫⲉⲛ ⲛⲓϫⲉⲛⲉⲫⲱⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲛⲁ⳿ϣⲫⲏⲣ ϫⲉ ⲙⲡⲉⲣⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲛⲛⲏⲉⲑⲛⲁϧⲱⲧⲉⲃ ⳿ⲙⲡⲉⲧⲉⲛⲥⲱⲙⲁ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⳿ⲉⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ⲛⲁⲧⲁⲙⲱⲧⲉⲛ ⲇⲉ ϫⲉ ⲁⲣⲓϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲛⲛⲓⲙ ⲁⲣⲓϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲫⲏⲉⲧⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲉⲑⲣⲉϥϧⲱⲧⲉⲃ ⲟⲩⲟⲛⲧⲉϥ ⲉⲣϣⲓϣⲓ ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲉϯⲅⲉⲉⲛⲛⲁ ⲁϩⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲓϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ⲙⲏ ⲉ̅ ⳿ⲛϭⲁϫ ⲁⲛ ⳿ⲉⲧⲟⲩϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲁ ⲧⲉⲃⲓ ⳿ⲥⲛⲟⲩϯ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲥⲉⲟⲃϣ ⳿ⲉⲣⲟϥ ⲁⲛ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ⲁⲗⲗⲁ ⲛⲓⲕⲉϥⲱⲓ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲁⲫⲉ ⲥⲉⲏⲡ ⲧⲏⲣⲟⲩ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲧⲉⲧⲉⲛⲟⲩⲟⲧ ⳿ⲉⲟⲩⲙⲏϣ ⳿ⲛϭⲁϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲡϣⲏⲣⲓ ϩⲱϥ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲛϧⲏⲧϥ ⳿ⲙⲡⲉⲙⲑⲟ ⳿ⲛⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲥⲉⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ϩⲱϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϫⲉ ⲟⲩⲥⲁϫⲓ ⳿ⲛⲥⲁ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲥⲉⲛⲁⲭⲁϥ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϫⲉⲟⲩⲁ ⲉⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲛⲛⲟⲩ ⲭⲱ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛ⳿ⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲏ ⲛⲉⲙ ⲛⲓ⳿ⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϫⲉ ⲡⲱⲥ ⲓⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲟⲩⲱ ⳿ⲙⲙⲟϥ ⲓⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁϫⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ⲡⲓⲡ͞ⲛⲁ̅ ⲅⲁⲣ ⲉⲑⲟⲩⲁⲃ ⲛⲁ⳿ⲧⲥⲁⲃⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲛⲏⲉⲑⲛⲁⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛϫⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲇⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲓⲙⲏϣ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲁϫⲟⲥ ⳿ⲙⲡⲁⲥⲟⲛ ⲉⲑⲣⲉϥⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁϥ ⲛⲉⲙⲏⲓ ⳿ⲛϯ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲫⲣⲱⲙⲓ ⲛⲓⲙ ⲡⲉⲧⲁϥⲭⲁⲧ ⳿ⲛⲣⲉϥϯϩⲁⲡ ⲓⲉ ⳿ⲛⲣⲉϥⲫⲱϣ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲁⲩ ⲟⲩⲟϩ ⲁⲣⲉϩ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲁ ϭⲓ⳿ⲛϫⲟⲛⲥ ⲛⲓⲃⲉⲛ ϫⲉ ⲛⲁⲣⲉ ⳿ⲡⲱⲛϧ ϣⲟⲡ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲁⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲙⲡⲉⲧⲉⲛⲧⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ⲁϥϫⲉ ⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⲇⲉ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⳿ⲉⲁⲥⲉⲣϣⲁⲩ ⳿ⲛϫⲉ ⲉϥⲭⲱⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ⲟⲩⲟϩ ⲛⲁϥⲙⲟⲕⲙⲉⲕ ⲡⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ϫⲉ ⳿ⲙⲙⲟⲛϯ ⲙⲁ ⳿ⲙⲙⲁⲩ ⲉⲑⲣⲓⲑⲱⲟⲩϯ ⲛⲛⲁⲟⲩⲧⲁϩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲫⲁⲓ ϯⲛⲁⲁⲓϥ ϯⲛⲁϣⲟⲣϣⲉⲣ ⳿ⲛⲛⲁ⳿ⲁⲡⲟⲑⲏⲕⲏ ⲟⲩⲟϩ ϯⲛⲁⲕⲟⲧⲟⲩ ⳿ⲛⲛⲓϣϯ ⳿ⲛϩⲟⲩ⳿ⲟ ⲟⲩⲟϩ ⲛⲧⲁⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ⳿ⲙⲡⲁⲥⲟⲩ⳿ⲟ ⲧⲏⲣϥ ⲛⲉⲙ ⲛⲁⲁⲅⲁⲑⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ⲟⲩⲟϩ ϯⲛⲁϫⲟⲥ ⳿ⲛⲧⲁⲯⲩⲭⲏ ϫⲉ ⲧⲁ ⲯⲩⲭⲏ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲁⲅⲁⲑⲟⲛ ⲭⲏ ⲉ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲟ ⲟⲩⲱⲙ ⲥⲱ ⲟⲩⲛⲟϥ ⳿ⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ⲡⲉϫⲉ ⲫϯ ⲇⲉ ⲛⲁϥ ϫⲉ ⲡⲓⲁⲧϩⲏⲧ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⲥⲉⲛⲁⲱⲗⲓ ⲛⲧⲉⲕⲯⲩⲭⲏ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲕ ⲛⲏⲉⲧⲁⲕⲑⲟⲩⲱⲧⲟⲩ ⲉⲩⲛⲁϣⲱⲡⲓ ⳿ⲛⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲫⲏⲉⲧϩⲓⲟⲩ⳿ⲓ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⲉϥⲟⲓ ⲛⲣⲁⲙⲁⲟ ⲁⲛ ϧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲉⲑⲃⲉⲫⲁⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲧⲉⲧⲉⲛⲯⲩⲭⲏ ϫⲉ ⲩ ⲉⲧⲉⲧⲉⲛⲛⲁⲟⲩⲟⲙϥ ⲟⲩⲇⲉ ϧⲁ ⲡⲉⲧⲉⲛⲥⲱⲙⲁ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲧⲏⲓϥ ϩⲓ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ϯⲯⲩⲭⲏ ⲅⲁⲣ ⲟⲩⲟⲧ ⳿ⲉϯ ⳿ϧⲣⲉ ⲟⲩⲟϩ ⲡⲓⲥⲱⲙⲁ ⲉϯϩⲉⲃⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ⲙⲁⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲛⲓⲁⲃⲱⲕ ϫⲉ ⲥⲉⲥⲓϯ ⲁⲛ ⲟⲩⲟϩ ⲥⲉⲱⲥϧ ⲁⲛ ⲛⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲟⲛ ⲧⲁⲙⲓⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⲟⲩⲇⲉ ⳿ⲁⲡⲟⲑⲏⲕⲏ ⲟⲩⲟϩ ϯ ϣⲁⲛϣ ⳿ⲙⲙⲱⲟⲩ ⲁⲩⲏⲣ ⲙⲁⲗⲗⲟⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲟⲩⲟⲧ ⳿ⲉⲛⲓϩⲁⲗⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ⲛⲓⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥϥⲓⲣⲱⲟⲩϣ ⳿ⲉⲧⲉⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⲙⲙⲟϥ ⳿ⲉⲧⲁⲗⲉ ⲟⲩⲙⲁϩⲓ ⳿ⲛϣⲓⲏ ⳿ⲉϫⲉⲛ ⲧⲉϥⲙⲁⲓⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ⲓⲥϫⲉ ⲟⲩⲛ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲟⲩⲕⲟⲩϫⲓ ⲓⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛϥⲓⲣⲱⲟⲩϣ ϧⲁ ⳿ⲡⲥⲉⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ⲙⲁⲓⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲛⲓ⳿ϩⲣⲏⲣⲓ ϫⲉ ⲡⲱⲥ ⲥⲉⲁⲓⲁⲓ ⳿ⲛⲥⲉϧⲟⲥⲓ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛⲥⲉⲉⲣⲓⲟⲡⲏ ⲁⲛ ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲇⲉ ⲟⲗⲟⲙⲱⲛ ϧⲉⲛ ⲡⲉϥⲱⲟⲩ ⲧⲏⲣϥ ⳿ⲙⲡⲉϥϯ ϩⲓⲱⲧϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ⲓⲥϫⲉ ⲇⲉ ⲡⲓⲥⲓⲙ ⳿ϥϣⲟⲡ ⳿ⲙⲫⲟⲟⲩ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲟⲩⲟϩ ⲣⲁⲥϯ ⲁⲩϩⲓⲧϥ ⳿ⲉϯ⳿ⲑⲣⲓⲣ ⲡⲁⲓⲣⲏϯ ⲫϯ ϯϩⲉⲃⲥⲱ ϩⲓⲱⲧϥ ⲡⲟⲥⲱ ⲙⲁⲗⲗⲟⲛ ⲛⲁ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲙⲡⲉⲣⲕⲱϯ ϫⲉ ⲟⲩ ⲉⲧⲉⲧⲉⲛⲛⲁⲟⲩⲟⲙϥ ⲟⲩⲟϩ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲥⲟϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ⲛⲁⲓ ⲅⲁⲣ ⲧⲏⲣⲟⲩ ⲛⲓⲉⲑⲛⲓⲕⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲥⲉⲕⲱϯ ⲛⲥⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲥⲱⲟⲩⲛ ϫⲉ ⲧⲉⲧⲉⲛⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","⳿ⲡⲗⲏⲛ ⲕⲱϯ ⳿ⲛⲥⲁ ⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲥⲉⲛⲁⲟⲩⲁϩⲟⲩ ⲉⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲟϩⲓ ϫⲉ ⲁϥ ϯⲙⲁϯ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⳿ⲉϯ ⲛⲱⲧⲉⲛ ⳿ⲛϯ ⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ⲙⲁ ⲉⲧⲉⲛϩⲩⲡⲁⲣⲭⲟⲛⲧ⳿ⲁ ⳿ⲉⲃⲟⲗ ⲙⲏⲓⲧⲟⲩ ⲉⲑⲙⲉⲧⲛⲁⲏⲧ ⲙⲁⲑⲁⲙⲓ⳿ⲟ ⲛⲱⲧⲉⲛ ⳿ⲛϩⲁⲛ⳿ⲁⲥⲟⲩ⳿ⲓ ⳿ⲙⲡⲁⲩⲉⲣⲁⲡⲁⲥ ⳿ⲛⲟⲩⲁϩⲟ ⳿ⲛⲁⲑⲙⲟⲩⲛⲕ ϧⲉⲛ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲓⲙⲁ ⲧⲉ⳿ⲙⲡⲁⲣⲉ ⲣⲉϥϭⲓⲟⲩ⳿ⲓ ϧⲱⲛⲧ ⳿ⲉⲣⲟϥ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲣⲉ ϩⲟⲗⲓ ⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ⲡⲓⲙⲁ ⲅⲁⲣ ⲉⲧⲉ ⲡⲉⲧⲉⲛⲁϩⲟ ⳿ⲙⲙⲟϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲛϫⲉ ⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ⲙⲁⲣⲟⲩϣⲱⲡⲓ ⲉⲩϧⲏⲕ ⳿ⲛϫⲉ ⲛⲉⲧⲉⲛϯⲡⲓ ⲟⲩⲟϩ ⲛⲉⲧⲉⲛϧⲏⲃⲥ ⲉⲩⲙⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲉⲣⲉⲧⲉⲛ⳿ⲟⲛⲓ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⲉⲩϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲟⲩϫ̅ ⲥ̅ ϫⲉ ⳿ϥⲛⲁϯⲟⲩⲱ ⳿ⲛ⳿ⲑⲛⲁⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓϩⲟⲡ ϩⲓⲛⲁ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛⲧⲉϥⲕⲱⲗϩ ⲥⲁⲧⲟⲧⲟⲩ ⳿ⲛⲥⲉⲁⲟⲩⲱⲛ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲉⲃⲓⲁⲓⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲏⲉⲧⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲡⲟⲩϫ̅ⲥ̅ ⳿ⲛⲧⲉϥϫⲉⲙⲟⲩ ⲉⲩⲣⲏ ⲥ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲧⲉⲛ ϫⲉ ⳿ϥⲛⲁϧⲟⲕϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲑⲣⲟⲩⲣⲱⲧⲉⲃ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛⲧⲉϥϣⲉⲙϣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ⲕⲁⲛ ⲁϥϣⲁⲛ⳿ⲓ ϧⲉⲛ ϯⲙⲁϩ⳿ⲥⲛⲟⲩϯ ⲕⲁⲛ ⲁϥϣⲁⲛ⳿ⲓ ϧⲉⲛ ϯⲙⲁϩⲅ̅ϯ ⳿ⲛⲟⲩⲉⲣϣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϫⲉⲙⲟⲩ ⲉⲩ⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ⲫⲁⲓ ⲇⲉ ⲁⲣⲓ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⲉ ⳿ⲉⲛⲁⲣⲉ ⲡⲓⲛⲉⲃⲏⲓ ⳿ⲉⲙⲓ ϫⲉ ϧⲉⲛ ⲁϣ ⳿ⲛⲟⲩⲛⲟⲩ ⳿ϥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥϭⲓⲟⲩ⳿ⲓ ⲛⲁϥⲛⲁⲣⲱⲓⲥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁϥⲛⲁⲭ ⲁⲩ ⲁⲛ ⲡⲉ ⳿ⲉⲉⲣϣⲁⲧⲥ ⳿ⲉⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲥⲉⲃⲧⲱⲧ ϫⲉ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⳿ϥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ⲡⲉϫⲉ ⲉⲧⲣⲟⲥ ϫⲉ Ⲡ⳪ ⲁⲕϫⲱ ⳿ⲛⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⳿ⲉⲣⲟⲛ ϣⲁⲛ ⲁⲕϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲡ⳪ ϫⲉ ⲛⲓⲙ ϩⲁⲣⲁ ⲡⲉ ⲡⲓⲡⲓⲥⲧⲟⲥ ⲛⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲥⲁⲃⲉ ⲫⲏⲉⲧⲉ ⲡⲉϥϫ̅ⲥ̅ ⲛⲁⲭⲁϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲉⲃⲓⲁⲓⲕ ϫⲉ ⳿ⲛⲧⲉϥϯ ⳿ⲛⲧⲟⲩ⳿ϧⲣⲉ ⲛⲱⲟⲩ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲧⲏⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ⲟⲩ⳿ⲛⲓⲁⲧϥ ⲙⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲏⲉⲧⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲡⲉϥϫ̅ⲥ̅ ⳿ⲛⲧⲉϥϫⲉⲙϥ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ⲧⲁ⳿ⲫⲙⲏⲓ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ϥⲛⲁⲭⲁϥ ⳿ⲉϫⲉⲛ ⲉϥϩⲩⲡⲁⲣⲭⲟⲛⲧ⳿ⲁ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛϫⲟⲥ ⳿ⲛϫⲉ ⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲛⲁⲱⲥⲕ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⲟⲩⲟϩ ⲛⲧⲉϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲃⲱⲕ ⲛⲉⲙ ⲛⲓⲃⲱⲕⲓ ⳿ⲛⲧⲉϥⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲥⲱ ⳿ⲛⲧⲉϥⲑⲓϧⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","⳿ϥⲛⲁⲓ ⳿ⲛϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲃⲱⲕ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉϥⲥⲟⲙⲥ ϧⲁϫⲱϥ ⲁⲛ ⲛⲉⲙ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⲟⲩⲟϩ ⳿ϥⲛⲁⲫⲟⲣϫϥ ϧⲉⲛ ⲧⲉϥⲙⲏϯ ⲟⲩⲟϩ ⲧⲉϥⲧⲟⲓ ⲛⲁⲭⲁⲥ ⲛⲉⲙ ⲓⲁⲑⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ⲡⲓⲃⲱⲕ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲉ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲡⲉϥϫ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲉⲧⲉ⳿ⲙⲡⲉϥⲥⲟⲃϯ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ⲓⲣⲓ ⲕⲁⲧⲁ ⲛⲉϥⲟⲩⲱϣ ⲥⲉⲛⲁϯ ⳿ⲛϩⲁⲛⲙⲏϣ ⳿ⲛϣⲁϣ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲡⲉϥ⳿ⲉⲙⲓ ⳿ⲛⲧⲉϥ⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛⲛⲏⲉⲧⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛϩⲁⲛϣⲏϣⲓ ⲥⲉⲛⲁϯ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛϣⲁϣ ⲛⲁϥ ⲟⲩⲟⲛ ⲓⲃⲉⲛ ⲉⲧⲁⲩϯ ⲟⲩⲙⲏϣ ⲛⲁϥ ⲥⲉⲛⲁⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲙⲏϣ ⳿ⲛⲧⲟⲧϥ ⲟⲩⲟϩ ⲫⲏⲉⲧⲁⲩϫⲁⲗⲉ ⲟⲩⲙⲏϣ ⳿ⲉⲣⲟϥ ⲥⲉⲛⲁⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ⲩ⳿ⲭⲣⲱⲙ ⲡⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲟⲩⲟϩ ⲟⲩ ⲡⲉ ⳿ⲉϯⲛⲁⲟⲩⲁϣϥ ⲓⲉ ϩⲏⲇⲏ ⲁϥⲙⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ⲟⲩⲟⲛ ⳿ⲛⲧⲏⲓ ⲇⲉ ⳿ⲛⲟⲩⲱⲙⲥ ⳿ⲉϭⲓⲧϥ ⲟⲩⲟϩ ⲱⲥ ⲉⲣⲥⲩⲛⲉⲭⲉⲥⲑⲉ ϣⲁⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ⲁⲣⲉⲧⲉⲛⲙⲉⲩⲓ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⳿ⲙⲙⲟⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲗⲗⲁ ⲩⲫⲱⲣϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲅⲁⲣ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⳿ⲛϫⲉ ⲉ̅ ϧⲉⲛ ⲟⲩⲏⲓ ⳿ⲛⲟⲩⲱⲧ ⲉⲩⲫⲟⲣϫ ⲅ̅ ⳿ⲉϫⲉⲛ ⲃ̅ ⲟⲩⲟϩ ⲃ̅ ⳿ⲉϫⲉⲛ ⲅ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ⲉⲩ⳿ⲉⲫⲱⲣϫ ⳿ⲛϫⲉ ⲩⲓⲱⲧ ⳿ⲉϫⲉⲛ ⲟⲩϣⲏ ⲣⲓ ⲟⲩⲟϩ ⲟⲩϣⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲓⲱⲧ ⲟⲩⲙⲁⲩ ⳿ⲉϫⲉⲛ ⲟⲩϣⲉⲣⲓ ⲟⲩⲟϩ ⲟⲩϣⲉⲣⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲁⲩ ⲟⲩϣⲱⲙⲓ ⳿ⲉϫⲉⲛ ⲟⲩϣⲉⲗⲉⲧ ⲟⲩⲟϩ ⲩϣⲉⲗⲉⲧ ⳿ⲉϫⲉⲛ ⲟⲩϣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲓⲕⲉⲙⲏϣ ϫⲉ ϩⲟⲧⲁⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲛⲁⲩ ⳿ⲉⲟⲩϭⲏⲡⲓ ⳿ⲉⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁ⳿ⲡⲉⲙⲉⲛⲧ ⲁⲣⲉⲧⲉⲛϫⲟⲥ ⲥⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⲟⲩⲙⲟⲩ⳿ⲛϩⲱⲟⲩ ⲉⲑⲛⲏⲟⲩ ⲟⲩⲟϩ ϣⲁⲥϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ⲟⲩⲟϩ ϩⲟⲧⲁⲛ ⲟⲩⲑⲟⲩⲣⲏⲥ ⲉϥⲛⲓϥⲓ ϣⲁⲣⲉⲧⲉⲛϫⲟⲥ ϫⲉ ⲕⲁⲩⲥⲱⲛ ⲡⲉⲑⲛⲁϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ⲛⲓϣⲟⲃⲓ ⳿ⲡϩⲟ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲓⲕⲁϩⲓ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲛⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⲡⲁⲓⲥⲏ ⲟⲩ ⲉ ⲛⲑⲟϥ ⲡⲱⲥ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛϯϩⲁⲡ ⲁⲛ ⳿ⲛϯⲙⲉⲑⲙⲏ ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲙⲙⲁⲩⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ϩⲱⲥ ⲅⲁⲣ ⳿ⲭⲛⲁϣⲉ ⲛⲉⲙ ⲡⲉⲕ⳿ⲁⲛⲧⲓⲇⲓⲕⲟⲥ ϣⲁ ⲟⲩⲁⲣⲭⲱⲛ ⲙⲟⲓ ⳿ⲛⲟⲩϩⲱⲃ ⳿ⲛⲛⲟⲩϥⲧ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⲙⲏⲡⲟⲧⲉ ⳿ⲛⲧⲉϥⲥⲟⲕⲕ ϩⲁ ⲡⲓⲣⲉϥϯϩⲁⲡ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲡⲓⲣⲉϥϯ ϩⲁⲡ ⲧⲏⲓⲕ ⳿ⲉⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲁⲕⲧⲱⲣ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲡⲣⲁⲕⲧⲱⲣ ϩⲓⲧⲕ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛⲛⲉⲕ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ϣⲁⲧⲉⲕϯ ⳿ⲙⲡⲓϧⲁ⳿ⲉ ⳿ⲛⲗⲉⲡⲧⲟⲛ ");
INSERT INTO copcnt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ⲛⲉ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⲡⲉ ⳿ⲙⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⲩⲧⲁⲙⲟ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲉ ⲛⲓⲅⲁⲗⲓⲗⲉⲟⲥ ⲛⲏⲉⲧⲁ ⲡⲓⲗⲁⲧⲟⲥ ⲙⲟⲩϫⲧ ⳿ⲙⲡⲟⲩ⳿ⲥⲛⲟϥ ⲛⲉⲙ ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲉ ⲁⲣⲉⲧⲉⲛⲙⲉⲩⲓ ϫⲉ ⲛⲁⲓⲅⲁⲗⲓⲗⲉⲟⲥ ⲁⲩϣⲱⲡⲓ ⲉⲩⲟⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲧⲉ ⲛⲓⲅⲁⲗⲓⲗⲉⲟⲥ ⲧⲏⲣⲟⲩ ϫⲉ ⲁⲩϭⲓ ⳿ⲛⲛⲁⲓ⳿ⲙⲕⲁⲩϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","⳿ⲙⲙⲟⲛ ϫⲱ ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲗⲗⲁ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲧⲉⲧⲉⲛⲛⲁⲧⲁⲕⲟ ⲧⲏⲣⲟⲩ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ⲓⲉ ⲡⲓⲓ̅ⲏ̅ ⳿ⲛⲣⲱⲙⲓ ⲉⲧⲁ ⲡⲓⲡⲩⲣⲅⲟⲥ ϩⲉⲓ ⳿ⲉϫⲱⲟⲩ ϧⲉⲛ ⲡⲓⲥⲓⲗⲱⲁⲙ ⲟⲩⲟϩ ⲁϥϧⲟⲑⲃⲟⲩ ⲁⲣⲉⲧⲉⲛⲙⲉⲩⲓ ϫⲉ ⲁ ⲛⲁⲓ ϣⲱⲡⲓ ⳿ⲉⲟⲩⲟⲛ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲧⲉ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","⳿ⲙⲙⲟⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲗⲗⲁ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲧⲉⲧⲉⲛⲛⲁⲧⲁⲕⲟ ⲧⲏⲣⲟⲩ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ⲛⲁϥϫⲱ ⲇⲉ ⲛⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲱⲟⲩ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲛⲟⲩⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲉⲥ ϭⲏⲟⲩⲧ ϧⲉⲛ ⲡⲉϥⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲁϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲧⲁϩ ϩⲓⲱⲧⲥ ⲟϩ ⳿ⲙⲡⲉϥϫⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲙⲡⲓⲟⲩⲱⲓ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ϫⲉ ⲓⲥ ⲅ̅ϯ ⳿ⲛⲣⲟⲙⲡⲓ ⲓⲥϫⲉⲛ ⲉⲓⲛⲏⲟⲩ ⲉⲓⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲧⲁϩ ϧⲉⲛ ⲧⲁⲓⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲟⲩⲟϩ ϫⲓⲙⲓ ⲁⲛ ⲕⲟⲣϫⲥ ⲟⲩⲛ ϩⲓⲛⲁ ⲟⲩ ϫⲉ ⲥⲉⲣ⳿ⲡⲕⲉⲕⲱⲣϥ ⳿ⲙⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲭⲁⲥ ⳿ⲛⲧⲁⲓⲕⲉⲣⲟⲙⲡⲓ ⲁϯϭⲣⲏ ϧⲁⲣⲁⲧⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲁϯⲙⲁϩⲣⲟ ⲛⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ⲁⲣⲏⲟⲩ ⳿ⲛⲧⲉⲥ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϯⲕⲉⲣⲟⲙⲡⲓ ⲉⲑⲛⲏⲟⲩ ⲉϣⲱⲡ ⲇⲉ ⲁⲥ⳿ϣⲧⲉⲙ⳿ⲓⲛⲓ ⲉⲕ⳿ⲉⲕⲟⲣϫⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ⲛⲁϥϯ⳿ⲥⲃⲱ ⲇⲉ ⲡⲉ ϧⲉⲛ ⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛϣⲱⲛⲓ ⲭⲏ ⲉⲙⲁⲥ ⳿ⲙⲓ̅ⲏ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲟⲩⲟϩ ⲛⲁⲥⲕⲟⲗϫ ⲡⲉ ⳿ⲛ⳿ϣⲥⲱⲟⲩⲧⲉⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⳿ⲉ⳿ⲡⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲣⲟⲥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ⲟⲩⲟϩ ⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲧⲉⲭⲏ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ⲟⲩⲟϩ ⲁϥⲭⲁ ⲛⲉϥϫⲓϫ ϩⲓϫⲱⲥ ⲟⲩⲟϩ ⲁⲥⲥⲱⲟⲩⲧⲉⲛ ⲥⲁⲧⲟⲧⲥ ⲟⲩⲟϩ ⲁⲥϯⲱⲟⲩ ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲉϥϫⲱⲛⲧ ϫⲉ ⲁ Ⲓⲏ̅ⲥ̅ ⲉϥⲫⲁϧⲣⲓ ⳿ⲉⲣⲟⲥ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲡⲓⲙⲏϣ ϫⲉ ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲉⲧⲉ⳿ⲥϣⲉ ⳿ⲛⲉⲣϩⲱⲃ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ⲟⲩⲛ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲛⲧⲟⲩⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲙ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ϥⲉⲣⲟⲩⲱ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲛⲓϣⲟⲃⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ϥϯⲟⲩⲱ ⳿ⲛⲧⲉϥⲉϩⲉ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲓⲉ ⲡⲉϥⲓⲱ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲟⲩⲟⲛϩϥ ⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϭⲓⲧⲟⲩ ⳿ⲛⲧⲉϥ⳿ⲧⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ⲑⲁⲓ ⲇⲉ ⳿ⲛⲑⲟⲥ ⲟⲩϣⲉⲣⲓ ⳿ⲛⲧⲉ ⲁⲃⲣⲁⲁⲙ ⲧⲉ ⳿ⲉⲁ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲥⲟⲛϩⲥ ⲓⲥ ⲓ̅ⲏ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲛⲉ ⲡⲉⲧ⳿ⲥϣⲉ ⲁⲛ ⲡⲉ ⳿ⲉⲃⲟⲗⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓ⳿ⲥⲛⲁϩ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲙ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ⲟⲩⲟϩ ⲛⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲩϣⲓⲡⲓ ⲧⲏⲣⲟⲩ ⲡⲉ ⲛϫⲉ ⲛⲏⲉⲧϯ ⲟⲩⲃⲏϥ ⲟⲩⲟϩ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲛⲁϥⲣⲁϣⲓ ⲡⲉ ⳿ⲉϫⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲧⲁⲓⲏⲟⲩⲧ ⲛⲏⲉⲧⲁⲩϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ⲛⲁϥϫⲱ ⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲁⲣⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲁⲥ⳿ⲟⲛⲓ ⳿ⲛⲟⲩ ⲟⲩⲟϩ ⲁⲓⲛⲁⲧⲉⲛⲑⲱⲛⲥ ⳿ⲉⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛⲟⲩⲛⲁⲫⲣⲓ ⳿ⲛϣⲉⲗⲧⲁⲙ ⲑⲏ ⲉⲧⲁ ⲟⲩⲣⲱⲙⲓ ⲓⲧⲥ ⲁϥⲥⲁⲧⲥ ϧⲉⲛ ⲡⲉϥϭⲱⲙ ⲟⲩⲟϩ ⲁⲥⲁⲓⲁⲓ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲟⲩ⳿ϣϣⲏⲛ ⲟⲩⲟϩ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲁⲩⲟⲩⲟϩ ⳿ⲉϫⲉⲛ ⲛⲉⲥϫⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ⲟⲩⲟϩ ⲁⲗⲓⲛ ⲡⲉϫⲁϥ ϫⲉ ⲁⲓⲛⲁⲧⲉⲛⲑⲱⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","⳿ⲥ⳿ⲟⲛⲓ ⳿ⲛⲟⲩϣⲉⲙⲏⲣ ⲫⲏⲉⲧⲁ ⲟⲩ⳿ⲥϩⲓⲙⲓ ϭⲓⲧϥ ⲁⲥⲭⲟⲡϥ ϧⲉⲛ ⲅ̅ ⳿ⲛϣⲓ ⲛⲛⲱⲓⲧ ϣⲁⲧⲉϥ ϭⲓϣⲉⲙⲏⲣ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ⲟⲩⲟϩ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ⲕⲁⲧⲁ ⲃⲁⲕⲓ ⲛⲉⲙ ϯⲙⲓ ⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲡⲉϥϫⲓⲛⲙⲟϣⲓ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲇⲉ ⲛⲁϥ ϫⲉ Ⲡ⳪ ϩⲁⲛⲕⲟⲩϫⲓ ⲉⲑⲛⲁⲛⲟϩⲉⲙ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ϫⲉ ⲁⲣⲓ⳿ⲁⲅⲱⲛⲓⲍⲉⲥⲑⲉ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϩⲓⲧⲉⲛ ⲓⲣⲟ ⲉⲧϫⲏⲟⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲛⲁⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⳿ⲛⲛⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ⲁϥϣⲁⲛⲫⲟϩ ⳿ⲉⲧⲱⲛϥ ⳿ⲛϫⲉ ⲓⲛⲉⲃⲏⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ϣⲑⲁⲙ ⳿ⲙⲡⲓⲣⲟ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲉⲣϩⲏ ⲧⲥ ⳿ⲛⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲥⲁⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲕⲱⲗϩ ⳿ⲉⲡⲓⲣⲟ ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⳿ⲁⲟⲩⲱⲛ ⲛⲁⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲣⲟⲩⲱ ⳿ⲛⲧⲉϥϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛ⳿ⲉⲃⲟⲗ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ⲧⲟⲧⲉ ⲣⲉⲧⲉⲛ⳿ⲉⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ϫⲉ ⲁⲛⲟⲩⲱⲙ ⳿ⲙⲡⲉⲕ⳿ⲙⲑⲟ ⲟⲩⲟϩ ⲁⲛⲥⲱ ⲟⲩⲟϩ ⲁⲕ ϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲛⲉⲛ⳿ⲡⲗⲁⲧⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ⲟⲩⲟϩ ⳿ϥⲛⲁϫⲟⲥ ϫⲉ ϯⲥⲱⲟⲩⲛ ⲙⲙⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲓ ⲧⲏⲣⲟⲩ ⲛⲓⲉⲣⲅⲁⲧⲏⲥ ⳿ⲛⲧⲉ ϯ⳿ⲁⲇⲓⲕⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϥⲛⲁϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲫⲣⲓⲙⲓ ⲛⲉⲙ ⳿ⲡ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲛⲓⲛⲁϫϩⲓ ϩⲟⲧⲁⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲛⲁⲩ ⳿ⲉⲁⲃⲣⲁⲁⲙ ⲛⲉⲙ ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ ⲓⲁⲕⲱⲃ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲏⲣⲟⲩ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ⲟⲩⲟϩ ⲉⲩ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲙⲁ⳿ⲛϣⲁⲓ ⲛⲉⲙ ⲛⲓⲙⲁ⳿ⲛϩⲱⲧⲡ ⲉⲙ ⲡⲉⲙϩⲓⲧ ⲛⲉⲙ ⲥⲁⲣⲏⲥ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲣⲟⲑⲃⲟⲩ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲟⲩⲟⲛ ϩⲁⲛϧⲁⲉⲩ ⲉⲩⲛⲁⲉⲣϣⲟⲣⲡ ⲟⲩⲟϩ ⲁⲛϣⲟⲣⲡ ⲩⲛⲁⲉⲣϧⲁⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⲟⲩⲟϩ ϩⲱⲗ ⲁⲓ ⲉ ⲣⲱⲇⲏⲥ ⲟⲩⲱϣ ⳿ⲉϧⲟⲑⲃⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲁϫⲟⲥ ⳿ⲛⲧⲁⲓⲃⲁϣⲟⲣ ϫⲉ ϩⲏⲡⲡⲉ ϯϩⲓ ⲇⲉⲙⲱⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϫⲱⲕ ⳿ⲛϩⲁⲛⲧⲁⲗϭⲟ ⲙⲫⲟⲟⲩ ⲛⲉⲙ ⲣⲁⲥϯ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓⲙⲁϩⲅ̅ ϯⲛⲁϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","⳿ⲡⲗⲏⲛ ϩⲱϯ ⳿ⲉⲣⲟⲓ ⳿ⲛⲧⲁⲉⲣ ⲫⲟⲟⲩ ⲛⲉⲙ ⲣⲁⲥϯ ⲟⲩⲟϩ ⲡⲉⲑⲛⲏⲟⲩ ⳿ⲛⲧⲁϣⲉ ⲏⲓ ⲉ ⳿ⲥⲭⲏ ⲁⲛ ⳿ⲛⲧⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲁⲕⲟ ⲥⲁⲃⲟⲗ ⳿ⲛ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲑⲏ ⲉⲧⲁⲥϧⲱⲧⲉⲃ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⲉⲧϩⲓ ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ ϩⲁⲣⲟⲥ ⲟⲩⲏⲣ ⳿ⲛⲥⲟⲡ ⲁⲓⲟⲩⲱϣ ⳿ⲉⲑⲟⲩⲉⲧ ⲛⲉϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϩⲁⲗⲏⲧ ⳿ⲙⲡⲉϥⲙⲟϩ ϧⲁ ⲛⲉϥⲧⲉⲛϩ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲟⲩⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲧⲉⲛⲏⲓ ⳿ϥⲭⲏ ⲛⲱⲧⲉⲛ ϯ ϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ϣⲁⲧⲉⲧⲉⲛϫⲟⲥ ϫⲉ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲡⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ");
INSERT INTO copcnt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲟⲩⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲟⲩⲱⲙ ⲛⲟⲩⲱⲓⲕ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲛⲁϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛϩⲩⲇⲣⲱⲡⲓⲕⲟⲥ ⲉϥⲭⲏ ⳿ⲙⲡⲉϥ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⳿ⲛⲛⲓⲛⲟⲙⲓⲕⲟⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲥϣⲉ ⳿ⲛⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ϣⲁⲛ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲭⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲁϥⲧⲁⲗϭⲟϥ ⲁϥⲭⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲡⲉϥⲓⲱ ⲉ ⲉϥ⳿ⲉϩⲉ ⲛⲁϩⲉⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲟⲩϣⲱϯ ⲟⲩⲟϩ ⳿ϥⲛⲁ⳿ⲉⲛϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⲁⲛ ⲥⲁⲧⲟⲧϥ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⲛⲉⲣⲟⲩⲱ ⲛⲁϥ ⲟⲩⲃⲉ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲛⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⳿ⲛⲛⲏⲉⲧⲑⲁϩⲉⲙ ⲉϥⲛⲁⲩ ϫⲉ ⲡⲱⲥ ⲛⲁⲩⲥⲱⲧⲡ ⲛⲱⲟⲩ ⳿ⲛⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛⲣⲱⲧⲉⲃ ϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ϫⲉ ϩⲟⲧⲁⲛ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲑⲁϩⲙⲉⲕ ⳿ⲉϩⲁⲛϩⲟⲡ ⳿ⲙⲡⲉⲣⲣⲱⲧⲉⲃ ⳿ⲉⲡⲓϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛⲣⲱⲧⲉⲃ ⲙⲏⲡⲱⲥ ⲁⲩⲑⲁϩⲉⲙ ⲕⲉⲟⲩⲁⲓ ϥⲧⲁⲓⲏ ⲟⲩⲧ ⲉϩⲟⲧⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲁϥⲑⲁϩⲙⲉⲕ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϫⲟⲥ ⲛⲁⲕ ϫⲉ ⲭⲁ ⲡⲓⲙⲁ ⳿ⲙⲫⲁⲓ ⲧⲟⲧⲉ ⲭⲛⲁⲉⲣϩⲏⲧⲥ ϧⲉⲛ ⲟⲩϣⲓⲡⲓ ⳿ⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲡⲓϧⲁ⳿ⲉ ⳿ⲙⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ⲁⲗⲗⲁ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛⲑⲁϩⲙⲉⲕ ⲙⲁϣⲉ ⲛⲁⲕ ⲣⲱⲧⲉⲃ ⳿ⲙⲡⲓϧⲁ⳿ⲉ ϩⲓⲛⲁ ϩⲟⲧⲁⲛ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲁϥⲑⲁϩⲙⲉⲕ ⳿ⲛⲧⲉϥϫⲟⲥ ⲛⲁⲕ ϫⲉ ⲡⲁ⳿ϣⲫⲏⲣ ⲟⲩⲟⲑⲃⲉⲕ ⳿ⲉ⳿ⲡϣⲱⲓ ⲧⲟⲧⲉ ⲉⲣⲉ ⲟⲩⲱⲟⲩ ϣⲱⲡⲓ ⲛⲁⲕ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲑⲣⲱⲧⲉⲃ ⲛⲉⲙⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϭⲁⲥϥ ⲥⲉⲛⲁⲑⲉⲃⲓⲟϥ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲑⲉⲃⲓⲟϥ ⲥⲉⲛⲁϭⲁⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲙⲫⲏⲉⲧⲁϥⲑⲁϩⲙⲉϥ ϫⲉ ϩⲟⲧⲁⲛ ⲁⲕϣⲁⲛ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲁⲣⲓⲥⲧⲟⲛ ⲓⲉ ⲟⲩⲇⲓⲡⲛⲟⲛ ⳿ⲙⲡⲉⲣⲙⲟⲩϯ ⳿ⲉⲛⲉⲕ⳿ϣⲫⲏⲣ ⲟⲩⲇⲉ ⲛⲉⲕ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲇⲉ ⲛⲉⲕⲥⲩⲅⲅⲉⲛⲏⲥ ⲩⲇⲉ ⲛⲉⲕⲑⲉϣⲉⲩ ⳿ⲛⲣⲁⲙⲁⲟ ⲙⲏⲡⲱⲥ ⳿ⲛⲥⲉⲑⲁϩⲙⲉⲕ ϩⲱⲕ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲟⲩϣⲉⲃⲓⲱ ϣⲱⲡⲓ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ⲁⲗⲗⲁ ⲁⲕϣⲁⲛ⳿ⲓⲣⲓ ⳿ⲛⲟⲩϣⲟⲡⲥ ⲙⲟⲩϯ ⳿ⲉϩⲁⲛϩⲏⲕⲓ ϩⲁⲛⲁⲧϫⲟⲙ ϩⲁⲛϭⲁⲗⲉⲩ ϩⲁⲛⲃⲉⲗⲗⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ⲟⲩⲟϩ ⳿ⲭⲛⲁⲉⲣⲟⲩⲙⲁⲕⲁⲣⲓⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲉϯϣⲉⲃⲓⲱ ⲛⲁⲕ ⲥⲉⲛⲁϯ ⲁⲣ ⲛⲁⲕ ⳿ⲛⲧⲟⲩϣⲉⲃⲓⲱ ϧⲉⲛ ϯⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲏⲉⲑⲣⲟⲧⲉⲃ ⲡⲉϫⲁϥ ϫⲉ ⲱⲟⲩⲛⲓⲁⲧϥ ⲙⲫⲏⲉⲑⲛⲁⲟⲩⲱⲙ ⳿ⲛⲟⲩⲱⲓⲕ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲇⲓⲡⲛⲟⲛ ⲟⲩⲟϩ ϥⲑⲁϩⲉⲙ ⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉϥⲃⲱⲕ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲇⲓⲡⲛⲟⲛ ⳿ⲉϫⲟⲥ ⳿ⲛⲛⲏⲉⲧⲑⲁϩⲉⲙ ⲉⲑⲣⲟⲩ⳿ⲓ ϫⲉ ϩⲏⲇⲏ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲥⲉⲃⲧⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣⲡⲁⲣⲉⲧⲓⲥⲑⲉ ϧⲉⲛ ⲟⲩ⳿ϧⲣⲱⲟⲩ ⳿ⲛⲟⲩⲱⲧ ⲧⲏⲣⲟⲩ ⲡⲓϩⲟⲩⲓⲧ ⲁϥϫⲟⲥ ϫⲉ ⲁⲓϣⲱⲡ ⳿ⲛⲟⲩⲓⲟϩⲓ ⲟⲩⲟϩ ⲩⲟⲛ ⳿ⲁⲛⲁⲅⲕⲏ ⲧⲟⲓ ⳿ⲉⲣⲟⲓ ⲉⲑⲣⲓϣⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲁⲛⲁⲩ ⳿ⲉⲣⲟϥ ϯϯϩⲟ ⳿ⲉⲣⲟⲕ ⲭⲁⲧ ⳿ⲛⲧⲟⲧⲕ ϩⲱⲥ ⳿ⲛϯⲛⲏⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲡⲉϫⲁϥ ϫⲉ ⲁⲓϣⲉⲡ ̅ ⲛϩⲉⲃⲓ ⳿ⲛ⳿ⲉϩⲉ ⲟⲩⲟϩ ϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲛⲧⲁⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲙⲙⲱⲟⲩ ϯϯϩⲟ ⳿ⲉⲣⲟⲕ ⲭⲁⲧ ⳿ⲛⲧⲟⲧⲕ ϩⲱⲥ ϯⲛⲏⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲡⲉϫⲁϥ ⲉ ⲁⲓϭⲓ ⳿ⲛⲟⲩ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲉⲑⲃⲉⲫⲁⲓ ϯⲛⲁ⳿ⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲃⲱⲕ ⲁϥⲧⲁⲙⲉ ⲡⲉϥϫ̅ⲥ̅ ⲧⲟⲧⲉ ⲉⲧⲁϥϫⲱⲛⲧ ⳿ⲛϫⲉ ⲡⲓⲛⲉⲃⲏⲓ ⲡⲉϫⲁϥ ⳿ⲙⲡⲉϥⲃⲱⲕ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲉⲛⲓ⳿ⲡⲗⲁⲧⲓ⳿ⲁ ⲛⲉⲙ ⲛⲓϧⲓⲣ ⳿ⲛⲧⲉ ϯ ⲃⲁⲕⲓ ⲟⲩⲟϩ ⲛⲓϩⲏⲕⲓ ⲛⲉⲙ ⲛⲓⲁⲧϫⲟⲙ ⲛⲉⲙ ⲛⲓⲃⲉⲗⲗⲉⲩ ⲛⲓⲧⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲡⲓⲃⲱⲕ ϫⲉ Ⲡ⳪ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲁⲕⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲓ ⲟⲩⲟⲛ ⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ⲩⲟϩ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲃⲱⲕ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲓⲙⲱⲓⲧ ⲛⲉⲙ ⲛⲓ⳿ⲫⲣⲁⲅⲙⲟⲥ ⲟⲩⲟϩ ⲁⲣⲓ⳿ⲁⲛⲁⲅⲕⲁⲍⲓⲛ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲙⲟϩ ⳿ⲛϫⲉ ⲁⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉ ⳿ϩⲗⲓ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ϫⲉⲙϯⲡⲓ ⳿ⲙⲡⲁⲇⲓⲡⲛⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ⲛⲁⲩⲙⲟϣⲓ ⲇⲉ ⲉⲙⲁϥ ⳿ⲛϫⲉ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲟⲩⲟϩ ⲉⲧⲁϥⲫⲟⲛϩϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ϫⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲙⲉⲥⲧⲉ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲉϥⲙⲁⲩ ⲛⲉⲙ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲛⲉⲙ ⲛⲉϥϣⲏⲣⲓ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲙ ⲛⲉϥⲥⲱⲛⲓ ⲉⲧⲓ ⲇⲉ ⲛⲉⲙ ⲧⲉϥⲕⲉⲯⲩⲭⲏ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲉⲣ ⲙⲁⲑⲏⲧⲏⲥ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ⲫⲏⲉⲧⲉⲛϥⲛⲁⲧⲁⲗⲉ ⲡⲉϥ ̇ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲟϩ ⲛⲧⲉϥⲟⲩⲁϩϥ ⲛⲥⲱⲓ ⲙⲙⲟⲛ ϭϫⲟⲙ ⲙⲙⲟϥ ⲉⲉⲣⲙⲁⲑⲏⲧⲏⲥ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ⲛⲓⲙ ⲅⲁⲣ ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥⲟⲩⲱϣ ⳿ⲉⲕⲉⲧ ⲟⲩⲡⲩⲣⲅⲟⲥ ⲙⲏ ⳿ϥⲛⲁϩⲉⲙⲥⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲉϥϥⲓⲱⲡ ⳿ⲛϯⲇⲁⲡⲁⲛⲏ ϫⲉ ⲁⲛ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩ ⳿ⲉⲉⲣ ⲡⲉϥⲥⲟⲃϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ϩⲓⲛⲁ ⲙⲏⲡⲱⲥ ⳿ⲛⲧⲉϥⲭⲁ ϯⲥⲉⲛϯ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉϫⲟⲕϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲟⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲣⲱⲙⲓ ⲁϥⲉⲣϩⲏ ⲧⲥ ⳿ⲛⲕⲱⲧ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϫⲟⲕϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ⲓⲉ ⲛⲓⲙ ⳿ⲛⲟⲩⲣⲟ ⲉⲑⲛⲁϣⲉ ⲛⲁϥ ⲉ⳿ⲡⲡⲟⲗⲉⲙⲟⲥ ⳿ⲉϯ ⲛⲉⲙ ⲕⲉⲟⲩⲣⲟ ⲙⲏ ⳿ϥⲛⲁϩⲉⲙⲥⲓ ⲁⲛ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲧⲉϥⲥⲟϭⲛⲓ ϫⲉ ⲁⲛ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲓ̅ ⳿ⲛϣⲟ ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲡⲉⲑⲛⲏ ⲟⲩ ⲉϫⲱϥ ⲛⲉⲙ ⲕ̅ ⳿ⲛϣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","⳿ⲙⲙⲟⲛ ⲉⲧⲓ ⲓⲥϫⲉⲛ ⲉϥⲟⲩⲏⲟⲩ ⳿ⲙⲙⲟϥ ϣⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲟⲩ⳿ⲡⲣⲉⲥⲃⲓ⳿ⲁ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ⲡⲁⲓⲣⲏϯ ⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲉⲣⲁⲡⲟⲧⲁⲍⲉⲥⲑⲉ ⲁⲛ ⳿ⲛⲛⲉϥϩⲩⲡⲁⲣ ⲭⲟⲛⲧ⳿ⲁ ⲧⲏⲣⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲉⲣ ⲙⲁⲑⲏⲧⲏⲥ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ⲁⲛⲉ ⲡⲓ⳿ϩⲙⲟⲩ ⲉϣⲱⲡ ⲇⲉ ⳿ⲛⲧⲉϥⲗⲱϥ ⳿ⲛϫⲉ ⲡⲓ⳿ϩⲙⲟⲩ ⲁⲩⲛⲁⲙⲟⲗϩϥ ⳿ⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ⲟⲩⲇⲉ ⲡⲓⲕⲁϩⲓ ⲟⲩⲇⲉ ϯⲕⲟⲡⲣⲓ⳿ⲁ ⳿ϥⲉⲣϣⲁⲩ ⲁⲛ ⲁⲗⲗⲁ ⲉϣⲁⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲁϣϫ ⳿ⲙⲙⲟϥ ⳿ⲉⲥⲱⲧⲉⲙ ⲙⲁⲣⲉϥⲥⲱⲧⲉⲙ ");
INSERT INTO copcnt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ⲛⲁⲩϧⲱⲛⲧ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲧⲉⲗⲱⲛⲏⲥ ⲏⲣⲟⲩ ⲉⲙ ⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ϣⲱⲡ ⳿ⲛⲛⲓⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ϥⲟⲩⲱⲙ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ⲁϥϫⲉ ⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ϫⲉ ⲛⲓⲙ ⳿ⲛⲣⲱⲙⲓ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲟⲩⲟⲛⲧⲉϥ ⲣ̅ ⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⲁϥϣⲁⲛⲧⲁⲕⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲙⲏ ⳿ⲙⲡⲁϥⲭⲁ ⲡⲓϥ̅ⲑ̅ ⳿ⲛⲥⲱϥ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϣⲉ ⲛⲁϥ ⳿ⲛⲧⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲫⲏ ⲧⲁϥⲧⲁⲕⲟ ϣⲁⲧⲉϥϫⲉⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ⲟⲩⲟϩ ⲁϥϣⲁⲛϫⲉⲙϥ ϣⲁϥⲧⲁⲗⲟϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲙⲟϯ ⲉϥⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ⲟⲩⲟϩ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲉⲡⲓⲏⲓ ϣⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲉϥ⳿ϣⲫⲏⲣ ⲛⲉⲙ ⲛⲉϥⲑⲉϣⲉⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲣⲁϣⲓ ⲛⲉⲙⲏⲓ ⲧⲏⲣⲟⲩ ϫⲉ ⲁⲓϫⲓⲙⲓ ⳿ⲙⲡⲁ⳿ⲉⲥⲱⲟⲩ ⲉⲧⲁϥⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲧⲉⲛ ⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲁϣⲓ ⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲉϫⲉⲛ ⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛⲟⲩⲱⲧ ⲉϥⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲓⲉ ⳿ⲉϫⲉⲛ ⲡⲓϥ̅ⲑ̅ ⳿ⲛ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ⲓⲉ ⲛⲓⲙ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⲉⲧⲉ ⲩⲟⲛⲧⲉⲥ ⲓ̅ ⳿ⲛϫⲉⲥⲕⲓϯ ⳿ⲙⲙⲁⲩ ⲉϣⲱⲡ ⲁⲥϣⲁⲛⲧⲁⲕⲉ ⲟⲩ⳿ⲓ ⳿ⲙⲙⲱⲟⲩ ⲙⲏ ⳿ⲙⲡⲁⲥϭⲉⲣⲉ ⲟⲩϧⲏⲃⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥⲥⲁⲣϩ ⲡⲓⲏⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥⲕⲱϯ ϧⲉⲛ ⲩϥⲓⲣⲱⲟⲩϣ ϣⲁⲧⲉⲥϫⲉⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲥϣⲁⲛϫⲉⲙⲥ ϣⲁⲥⲙⲟⲩϯ ⳿ⲉⲛⲉⲥ⳿ϣⲫⲏⲣ ⲛⲉⲙ ⲛⲉⲥⲑⲉϣⲉⲩ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲣⲁϣⲓ ⲛⲉⲙⲏⲓ ϫⲉ ⲓϫⲓⲙⲓ ⳿ⲛⲧⲁϫⲉⲥⲕⲓϯ ⲉⲧⲁⲥⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ⲡⲁⲓⲣⲏϯ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϣⲁⲣⲉ ⲟⲩⲣⲁϣⲓ ϣⲱⲡⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉϫⲉⲛ ⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛⲟⲩⲱⲧ ⲉϥⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ⲡⲉϫⲁϥ ⲇⲉ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ϣⲏⲣⲓ ⲃ̅ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲓⲕⲟⲩϫⲓ ⲉⲧⲉ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲙⲡⲉϥⲓⲱⲧ ϫⲉ ⲡⲁⲓⲱⲧ ⲙⲟⲓ ⲛⲏⲓ ⳿ⲛⲧⲁⲧⲟⲓ ⳿ⲛⲧⲉ ϯⲟⲩⲥⲓⲁ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲫⲱϣ ⳿ⲙⲡⲓⲱⲛϧ ⳿ⲉ⳿ϩⲣⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲛ ⲁϥⲑⲱⲟⲩⲧ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲛϫⲉ ⲡⲓⲕⲟⲩϫⲓ ⳿ⲛϣⲏⲣⲓ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ ⳿ⲉⲟⲩⲭⲱⲣⲁ ⲉⲥⲟⲩⲏⲟⲩ ⲟⲩⲟϩ ⲁϥϫⲉⲣ ⲧⲉϥⲟⲩⲥⲓ⳿ⲁ ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲉϥⲟⲛϧ ϧⲉⲛ ⲟⲩⲙⲉⲧⲁⲧⲟⲩϫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ⲉⲧⲁϥⲟⲩⲱ ⲇⲉ ⲉϥϭⲟ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲃⲟⲗ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϩⲃⲱⲛ ϧⲉⲛ ⲭⲱⲣⲁ ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲁϥⲉⲣϩⲏ ⲧⲥ ⳿ⲛⲉⲣϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⲁϥⲧⲟⲙϥ ⳿ⲉⲟⲩⲁⲓ ⳿ⲛⲛⲓⲣⲉⲙⲃⲁⲕⲓ ⳿ⲛⲧⲉ ϯⲭⲱⲣⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲉ⳿ⲧⲕⲟⲓ ⳿ⲉⲙⲟⲛⲓ ⳿ⲛϩⲁⲛⲉϣⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ⲟⲩⲟϩ ⲛⲁϥⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲙⲁϩ ϧⲏⲧϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓϫⲓⲛ⳿ⲓⲣⲓ ⲛⲏ ⲉⲛⲁⲩⲟⲩⲟⲙⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲉϣⲁⲩ ⲟⲩⲟϩ ⲛⲉ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϯ ⲛⲁϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ⲉⲧⲁ ⲡⲉϥϩⲏⲧ ⲇⲉ ⲓ̅ ⳿ⲉⲣⲟϥ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲛⲣⲉⲙⲃⲉⲭⲉ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ ⲡⲓⲱⲓⲕ ⲟⲓ ⲛϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲱⲟⲩ ⲁⲛⲟⲕ ⲇⲉ ϯⲛⲁⲧⲁⲕⲟ ⳿ⲙⲡⲁⲓⲙⲁ ϧⲉⲛ ⲟⲩ⳿ϩⲃⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ϯⲛⲁⲧⲱⲛⲧ ⳿ⲛⲧⲁϣⲉ ⲛⲏⲓ ϩⲁ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲁϫⲟⲥ ⲛⲁϥ ϫⲉ ⲁⲓⲱⲧ ⲓⲉⲣⲛⲟⲃⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲉⲕ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ϫⲉ ⲉⲑⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲓ ϫⲉ ⲡⲉⲕϣⲏⲣⲓ ⲁⲣⲓⲧ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲉⲕⲣⲉⲙⲃⲉⲭ ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥ⳿ⲓ ϩⲁ ⲡⲉϥⲓⲱⲧ ⲉⲧⲓ ⲇⲉ ⲓⲥϫⲉⲛ ⲉϥⲟⲩⲏⲟⲩ ⳿ⲙⲙⲟϥ ⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲉϥⲓⲱⲧ ⲟⲩⲟϩ ⲁϥϣⲉⲛϩⲏⲧ ⲁϥ ϭⲟϫⲓ ϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲧⲉϥⲛⲁϩⲃⲓ ⲟⲩⲟϩ ⲁϥ ϯⲫⲓ ⳿ⲉⲣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ⲡⲉϫⲉ ⲡⲉϥϣⲏⲣⲓ ⲇⲉ ⲛⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ⲁⲓⲉⲣⲛⲟⲃⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲉⲕ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⳿ⲛϯ ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ϫⲉ ⲉⲑⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲓ ϫⲉ ⲡⲉⲕϣⲏ ⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ⲡⲉϫⲉ ⲡⲉϥⲓⲱⲧ ⲇⲉ ⳿ⲛⲛⲉϥⲉⲃⲓⲁⲓⲕ ⲭⲱⲗⲉⲙ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϯϩⲟⲩⲓϯ ⳿ⲛ⳿ⲥⲧⲟⲗⲏ ⲟⲩⲟϩ ⲏⲓⲥ ϩⲓⲱⲧϥ ⲟⲩⲟϩ ⲙⲁ ⲟⲩ⳿ϣϭⲟⲩⲣ ⳿ⲉⲧⲉϥϫⲓϫ ⲛⲉⲙ ⲟⲩⲑⲱⲟⲩ⳿ⲓ ⳿ⲉⲛⲉϥϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ⲟⲩⲟϩ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲙⲁⲥⲓ ⲉⲧϣⲁⲛⲉⲩϣ ϣⲁⲧϥ ⲟⲩⲟϩ ⲛⲧⲉⲛⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲟⲩⲛⲟϥ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ϫⲉ ⲡⲁϣⲏⲣⲓ ⲫⲁⲓ ⲛⲁϥⲙⲱⲟⲩⲧ ⲡⲉ ⲟⲩⲟϩ ⲁϥⲱⲛϧ ⲛⲁϥⲧⲁⲕⲏⲟⲩⲧ ⲡⲉ ⲟⲩⲟϩ ⲁⲛϫⲉⲙϥ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛⲟⲩⲛⲟϥ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ⲡⲉϥⲛⲓϣϯ ⲇⲉ ⳿ⲛϣⲏⲣⲓ ⲛⲁϥⲭⲏ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲟⲩⲟϩ ϩⲱⲥ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⲁϥϧⲱⲛⲧ ⳿ⲉⲡⲓⲏⲓ ϥⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩⲥⲩⲙⲫⲱⲛⲓⲁ ⲛⲉⲙ ϩⲁⲛ ⲭⲟⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ⲟⲩⲟϩ ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲟⲩⲁⲓ ⳿ⲛⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩ ⲛⲉ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲉⲕⲥⲟⲛ ⲁϥ⳿ⲓ ⲟⲩⲟϩ ⲡⲉⲕⲓⲱⲧ ϣⲱⲧ ⳿ⲙⲡⲓⲙⲁⲥⲓ ⲉⲧϣⲁⲛⲉⲩϣ ϫⲉ ⲁϥϭⲓⲧϥ ⲉϥⲟⲩⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ⲁϥϫⲱⲛⲧ ⲇⲉ ⲟⲩⲟϩ ⲙⲡⲉϥⲟⲩⲱϣ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲡⲉϥⲓⲱⲧ ⲇⲉ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⳿ⲙⲡⲉϥⲓⲱⲧ ϫⲉ ⲓⲥ ⲟⲩⲏⲣ ⲛⲣⲟⲙⲡⲓ ϯⲟⲓ ⳿ⲙⲃⲱⲕ ⲛⲁⲕ ⲟⲩⲟϩ ⳿ⲙⲡⲓⲉⲣⲥⲁⲃⲟⲗ ⳿ⲛⲟⲩⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲁⲕ ⲉⲛⲉϩ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲉⲕϯ ⳿ⲛⲟⲩⲙⲁⲥⲓ ⳿ⲙⲃⲁⲉⲙⲡⲓ ⲛⲏⲓ ⲉⲛⲉϩ ϩⲓⲛⲁ ⲛⲧⲁⲟⲩⲛⲟϥ ⳿ⲙⲙⲟⲓ ⲛⲉⲙ ⲛⲁ⳿ϣⲫⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ϩⲟⲧⲉ ⲇⲉ ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲉⲕϣⲏⲣⲓ ⲫⲁⲓ ⲉⲧⲁϥⲟⲩⲱⲙ ⳿ⲙⲡⲉϥⲱⲛϧ ⲛⲉⲙ ⲛⲓⲡⲟⲣⲛⲟⲥ ⲁⲕϣⲱⲧ ⲛⲁϥ ⲙⲡⲓⲙⲁⲥⲓ ⲉⲧϣⲁⲛⲉⲩϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁϣⲏⲣⲓ ⳿ⲛⲑⲟⲕ ⲭⲏ ⲛⲉⲙⲏⲓ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲏⲉⲧⲉⲛⲟⲩ⳿ⲓ ⲧⲏⲣⲟⲩ ⲛⲟⲩⲕ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉⲛⲟⲩⲛⲟϥ ⳿ⲙⲙⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛⲣⲁϣⲓ ϫⲉ ⲡⲉⲕⲥⲟⲛ ⲫⲁⲓ ⲛⲁϥⲙⲱⲟⲩⲧ ⲡⲉ ⲟⲩⲟϩ ⲁϥⲱⲛϧ ⲛⲁϥⲧⲁⲕⲏⲟⲩⲧ ⲡⲉ ⲟⲩⲟϩ ⲛϫⲉⲙϥ ");
INSERT INTO copcnt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⲟⲩⲟϩ ⲫⲁⲓ ⲩⲉⲣⲇⲓ⳿ⲁⲃⲟⲗⲓⲛ ⳿ⲙⲙⲟϥ ϧⲁⲧⲟⲧϥ ϩⲱⲥ ⲉϥϫⲱⲣ ⳿ⲛⲛⲉϥϩⲩⲡⲁⲣⲭ ⲟⲛⲧⲁ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ⲟⲩⲟϩ ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⲉϯⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲏⲧⲕ ⲙⲁ ⳿ⲡⲱⲡ ⳿ⲛϯⲙⲉⲧⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⲟⲩ ⲅⲁⲣ ⳿ⲭⲛⲁⲉⲣⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⲁⲛ ϫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⳿ⲛϫⲉ ⲡⲓⲟⲓⲕⲟⲛⲟⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ⲡⲁϫ̅ⲥ̅ ⲛⲁⲱⲗⲓ ⳿ⲛϯⲙⲉⲧⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲟⲧ ⳿ⲛϯⲛⲁ⳿ϣϫⲉⲙϫⲟⲙ ⲁⲛ ⳿ⲉϭⲣⲏ ⲟⲩⲟϩ ϯϣⲓⲡⲓ ⳿ⲉϣⲁⲧ ⲙⲉⲑⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ⲓ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ϩⲓⲛⲁ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛϩⲓⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲙⲉⲧⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⳿ⲛⲥⲉϣⲟⲡⲧ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲟⲩⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ⲟⲩⲟϩ ⲧⲁϥⲙⲟⲩϯ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲛⲛⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲡⲉϥϫ̅ⲥ̅ ⳿ⲉⲣⲱⲟⲩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲡⲓϩⲟⲩⲓⲧ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲉⲣⲟⲕ ⳿ⲛⲧⲉ ⲡⲁϫ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲣ̅ ⳿ⲙⲃⲁⲧⲟⲥ ⳿ⲛⲛⲉϩ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲙⲟ ⳿ⲉⲛⲉⲕ⳿ⲥϧⲁⲓ ⲟⲩⲟϩ ϩⲉⲙⲥⲓ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲥϧⲁⲓ ⳿ⲉⲛ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ⲓⲧⲁ ⲡⲉϫⲁϥ ⲛⲕⲉⲟⲩⲁⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲉⲣⲟⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲣ̅ ⳿ⲛⲕⲟⲣⲟⲥ ⳿ⲛⲥⲟⲩ⳿ⲟ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟ ⳿ⲉⲛⲉⲕ⳿ⲥϧⲁⲓ ⲟⲩⲟϩ ⳿ⲥϧⲁⲓ ⳿ⲉⲡ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ⲩⲟϩ ⲁ Ⲡ⳪ ϣⲟⲩϣⲟⲩ ⳿ⲉϫⲉⲛ ⲡⲓⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ϯ⳿ⲁⲇⲓⲕⲓⲁ ϫⲉ ⲁϥ⳿ⲓⲣⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧⲥⲁⲃⲉ ϫⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲁⲓⲉⲛⲉϩ ϩⲁⲛⲥⲁⲃⲉⲩ ⲛⲉ ⳿ⲉϩⲟⲧⲉ ⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ϧⲉⲛ ⲧⲟⲩⲅⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲉ ⲙⲁⲑⲁⲙⲓ⳿ⲟ ⲛⲱⲧⲉⲛ ⳿ⲛϩⲁⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲁⲙⲱⲛⲁ ⲛⲧⲉ ⳿ⲧ⳿ⲁⲇⲓⲕⲓⲁ ϩⲓⲛⲁ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛⲙⲟⲩⲛⲕ ⳿ⲛⲧⲟⲩϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓ⳿ⲥⲕⲩⲛⲏ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ⲡⲓⲡⲓⲥⲧⲟⲥ ϧⲉⲛ ⲟⲩⲕⲟⲩϫⲓ ⲟⲩⲡⲓⲥⲧⲟⲥ ⲟⲛ ⲡⲉ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⲟⲩⲟϩ ⲫⲏⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ϧⲉⲛ ⲟⲩⲕⲟⲩϫⲓ ⳿ϥϭⲓ⳿ⲛϫⲟⲛⲥ ⲟⲛ ϧⲉⲛ ⲟⲩⲛⲓϣϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ⲓⲥϫⲉ ⲟⲩⲛ ϧⲉⲛ ⲡⲓ⳿ⲁⲇⲓⲕⲟⲥ ⲙⲁⲙⲱⲛⲁ ⳿ⲙⲡⲉⲧⲉⲛϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛ⳿ⲛϩⲟⲧ ⲡⲓⲧⲁ⳿ⲫⲙⲏⲓ ⲇⲉ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲧⲉⲛϩⲉⲧ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ⲟⲩⲟϩ ⲓⲥϫⲉ ϧⲉⲛ ⲡⲉⲧⲉⲫⲱⲧⲉⲛ ⲁⲛ ⲡⲉ ⲙⲡⲉⲧⲉⲛϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛ⳿ⲛϩⲟⲧ ⲡⲉⲧⲉⲫⲱⲧⲉⲛ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲧⲏⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲙⲃⲱⲕ ⲛⲁ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲉⲣⲃⲱⲕ ⳿ⲛϫ̅ⲥ̅ ⲃ̅ ⲓⲉ ⲅⲁⲣ ⲛⲧⲉϥⲙⲉⲥⲧⲉ ⲟⲩⲁⲓ ⲟⲩⲟϩ ⲡⲓⲕⲉⲟⲩⲁⲓ ⳿ⲛⲧⲉϥⲙⲉⲛⲣⲓⲧϥ ⲓⲉ ⳿ⲛⲧⲉϥⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲟⲩⲁⲓ ⲟⲩⲟϩ ⲡⲓⲕⲉⲟⲩⲁⲓ ⳿ⲛⲧⲉϥⲉⲣⲕⲁⲧⲁ⳿ⲫⲣⲟⲛⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲟⲛ ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲉⲣⲃⲱⲕ ⳿ⲙⲫϯ ⲛⲉⲙ ⲙⲁⲙⲱⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ⲛⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲧⲟⲓ ⳿ⲙⲙⲁⲓϩⲁⲧ ⲟⲩⲟϩ ⲁⲩⲉⲗⲕϣⲁⲓ ⳿ⲛⲥⲱϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲉ ⲛⲏⲉⲧ⳿ⲑⲙⲁⲓⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲫϯ ⲇⲉ ⳿ϥⲥⲱⲟⲩⲛ ⲛⲛⲉⲧⲉⲛϩⲏⲧ ϫⲉ ⳿ⲡϭⲓⲥⲓ ⲛϩⲏⲧ ⲉⲧϧⲉⲛ ⲡⲓⲣⲱⲙⲓ ⲟⲩⲥⲱϥ ⲡⲉ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϣⲁ ⲓⲱⲁⲛⲛⲏⲥ ⲓⲥϫⲉⲛ ⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲥⲉϩⲓⲱⲓϣ ⳿ⲙⲙⲟⲥ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲥⲉϭⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲟⲛⲥ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","⳿ⲥⲙⲟⲧⲉⲛ ⲇⲉ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲛⲉⲙ ⲡⲕⲁϩⲓ ⲥⲓⲛⲓ ⳿ⲉϩⲟⲧⲉ ⳿ⲛⲧⲉ ⲟⲩⲕⲉⲣⲉ⳿ⲁ ϩⲉⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲧϭⲓ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⳿ϥⲟⲓ ⲛⲛⲱⲓⲕ ⲟⲩⲟϩ ⲫⲏⲉⲧϭⲓ ⳿ⲛⲑⲏ ⲉⲧϩⲱⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉⲛ ⲡⲉⲥϩⲁⲓ ⳿ϥⲟⲓ ⳿ⲛⲛⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⲡⲉ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⲟⲩⲟϩ ⲛⲉϣⲁϥϯ ⲛⲟⲩⲡⲟⲣⲫⲩⲣⲁ ϩⲓⲱⲧϥ ⲛⲉⲙ ⲟⲩϣⲉⲛⲥ ⲉϥⲟⲩⲛⲟϥ ⳿ⲙⲙⲏⲓⲛⲓ ϧⲉⲛ ⲟⲩⲥⲟⲗⲥⲉⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ⲟⲩϩⲏⲕⲓ ⲇⲉ ϩⲱϥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲗⲁⲍⲁⲣⲟⲥ ⲉϥϩⲱⲟⲩ⳿ⲓ ⲉⲡⲉϥⲡⲩⲗⲱⲛ ⲉϥⲟⲓ ⳿ⲛϣⲁϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ⲟⲩⲟϩ ⲉϥⲉⲣ⳿ⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲙⲁϩ ϧⲏⲧϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏ ⳿ⲉϣⲁⲩϩⲉⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ϯ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ ⲡⲓⲣⲁⲙⲁ⳿ⲟ ⲗⲗⲁ ⲓⲕⲉⲟⲩϩⲱⲣ ⲛⲁⲩⲛⲏⲟⲩ ⲉⲩⲗⲱϫϩ ⳿ⲛⲛⲉϥϣⲁϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲑⲣⲉϥⲙⲟⲩ ⳿ⲛϫⲉ ⲡⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲟⲗϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϩⲁⲛⲁⲅⲅⲉⲗⲟⲥ ⳿ⲉⲕⲉⲛϥ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲁϥⲙⲟⲩ ⲇⲉ ϩⲱϥ ⳿ⲛϫⲉ ⲡⲓⲣⲁⲙⲁ⳿ⲟ ⲟⲩⲟϩ ⲁⲩⲕⲟⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ⲟⲩⲟϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲁⲙⲉⲛϯ ⲉⲧⲁϥϥⲁⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⲉϥⲭⲏ ⲉⲛ ϩⲁⲛ⳿ⲙⲕⲁⲩϩ ⲁϥⲛⲁⲩ ⳿ⲉⲁⲃⲣⲁⲁⲙ ϩⲓ⳿ⲫⲟⲩⲉⲓ ⲟⲩⲟϩ ⲗⲁⲍⲁⲣⲟⲥ ϧⲉⲛ ⲕⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲉⲧⲁϥⲙⲟⲩϯ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ⲁⲃⲣⲁⲁⲙ ⲁⲓ ⲛⲏⲓ ⲟⲩⲟϩ ⲟⲩⲱⲣⲡ ⳿ⲛⲗⲁⲍⲁⲣⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲥⲉⲡ ⳿ϩⲑⲏϥ ⳿ⲙⲡⲉϥⲧⲏⲃ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ⳿ⲭⲃⲟⲃ ⳿ⲙⲡⲁⲗⲁⲥ ϫⲉ ϯⲙⲟⲕϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓϣⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ⲡⲉϫⲉ ⲁⲃⲣⲁⲁⲙ ϫⲉ ⲡⲁϣⲏⲣⲓ ⲁⲣⲓ⳿ⲫⲙⲉⲩⲓ ϫⲉ ⲁⲕⲟⲩⲱ ⲉⲕϭⲓ ⳿ⲛⲛⲉⲕⲁⲅⲁⲑⲟⲛ ϧⲉⲛ ⲡⲉⲕⲱⲛϧ ⲟⲩⲟϩ ⲗⲁⲍⲁⲣⲟⲥ ϩⲱϥ ⳿ⲛⲛⲓⲡⲉⲧϩⲱⲟⲩ ϯⲛⲟⲩ ⲇⲉ ⲥⲉⲑⲱⲧ ⳿ⲙⲡⲉϥϩⲏⲧ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲭⲏ ϧⲉⲛ ⲟⲩ⳿ⲙⲕⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ⲟⲩⲟϩ ϧⲉⲛ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛϣⲓⲕ ⲉϥⲧⲁϫⲣⲏⲟⲩⲧ ⲩⲧⲱⲛ ⲛⲉⲙⲱⲧⲉⲛ ϩⲟⲡⲱⲥ ⲛⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ⲧⲁⲓ ϩⲁⲣⲱⲧⲉⲛ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙϫⲉⲙϫⲟⲙ ⲟⲩⲇⲉ ⲛⲏⲉⲧϩⲁⲣⲱⲧⲉⲛ ⳿ⲉⲉⲣϫⲓⲛⲓⲟⲣ ϩⲁⲣⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ⲡⲉϫⲁϥ ⲇⲉ ϫⲉ ϯϯϩⲟ ⳿ⲉⲣⲟⲕ ⲡⲁⲓⲱⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲟⲩⲟⲣⲡϥ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ⲟⲩⲟⲛ ⲅⲁⲣ ⲉ̅ ⳿ⲛⲥⲟⲛ ⳿ⲛⲧⲏⲓ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ϣⲧⲉⲙ⳿ⲓ ϩⲱⲟⲩ ⳿ⲉⲡⲁⲓⲙⲁ ⳿ⲛⲧⲉ ⲡⲁⲓ⳿ⲙⲕⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛϫⲉ ⲁⲃⲣⲁⲁⲙ ϫⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲙⲁⲣⲟⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲡⲁⲓⲱⲧ ⲁⲃⲣⲁⲁⲙ ⲁⲗⲗⲁ ⲉϣⲱⲡ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲉ ⲛⲁϥ ϩⲁⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲥⲉⲛⲁⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⲥⲉⲛⲁⲥⲱⲧⲉⲙ ⲁⲛ ⳿ⲛⲥⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲇⲉ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲡⲟⲩϩⲏⲧ ⲛⲁⲑⲱⲧ ⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⳿ⲡⲗⲏⲛ ⲟⲩⲟⲓ ⳿ⲙⲫⲏⲉⲧⲉ ⲡⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ⲛⲁⲛⲉⲥ ⲛⲁϥ ⳿ⲛⲧⲟⲩⲉϣ ⲟⲩⲱⲛⲓ ⳿ⲙⲙⲟⲩⲗⲟⲛ ⳿ⲉϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲓⲟⲙ ⳿ⲉϩⲟⲧⲉ ⳿ⲛⲧⲉϥⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓⲕⲟⲩϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ⲙⲁϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲁⲣⲉϣⲁⲛ ⲉⲕⲥⲟⲛ ⲉⲣⲛⲟⲃⲓ ⲁⲣⲓ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁϥϣⲁⲛⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲭⲱ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲉⲣⲛⲟⲃⲓ ⳿ⲉⲣⲟⲕ ⳿ⲛⲍ̅ ⳿ⲛⲥⲟⲡ ⲉⲛ ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉϥⲕⲟⲧϥ ⳿ⲉⲣⲟⲕ ⳿ⲛⲍ̅ ⳿ⲛⲥⲟⲡ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲭⲱ ⲛⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲙⲠ⳪ ϫⲉ ⲟⲩⲁϩⲛⲁϩϯ ⳿ⲉⲣⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ϫⲉ ⲉⲛⲉ ⲟⲩⲟⲛⲧⲉⲧⲉⲛ ⲛⲁϩϯ ⳿ⲙⲙⲁⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲛⲁⲫⲣⲓ ⳿ⲛϣⲉⲗⲧⲁⲙ ⲛⲁⲣⲉⲧⲉⲛⲛⲁϫⲟⲥ ⳿ⲛϯⲛⲟⲩϩⲓ ϫⲉ ϥⲱϫⲓ ⲟⲩⲟϩ ⲣⲱⲧ ϧⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲛⲁⲥⲛⲁⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ⲛⲓⲙ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲟⲩⲟⲛⲧⲉϥ ⲟⲩⲃⲱⲕ ⳿ⲙⲙⲁⲩ ⲉϥ⳿ⲥⲭⲁⲓ ⲓⲉ ⲉϥⲙⲟⲛⲓ ⲫⲏⲉⲧⲉ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲙⲏ ⳿ϥⲛⲁϫⲟⲥ ⲛⲁϥ ⲥⲁⲧⲟⲧϥ ϫⲉ ⲁⲙⲟⲩ ⳿ⲉ⳿ⲡϣⲱⲓ ⲣⲱⲧⲉⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ⲙⲏ ⳿ϥⲛⲁϫⲟⲥ ⲛⲁϥ ⲁⲛ ϫⲉ ⲥⲟⲃϯ ⳿ⲙⲫⲏ ⳿ⲉϯⲛⲁⲟⲩⲟⲙϥ ⲟⲩⲟϩ ⲙⲟⲣⲕ ϣⲉⲙϣⲓ ⳿ⲙⲙⲟⲓ ϣⲁϯⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲥⲱ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲁⲓ ϩⲱⲕ ⳿ⲛⲧⲉⲕⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲕⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ⲙⲏ ⲟⲩⲟⲛ ⳿ϩⲙⲟⲧ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉ ⲡⲓⲃⲱⲕ ϫⲉ ⲁϥ⳿ⲓⲣⲓ ⳿ⲛⲛⲏⲉⲧⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛ⳿ⲓⲣⲓ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⲛⲱⲧⲉⲛ ⳿ⲁϫⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛⲃⲱⲕ ⳿ⲛⲁⲧϣⲁⲩ ⲡⲉⲧⲉⲣⲟⲛ ⲉⲁⲓϥ ⲁⲛⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ⲁⲥϣⲱⲡⲓ ⲉϥϣⲉ ⲛⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲛⲁϥⲥⲓⲛⲓⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲧⲉ ⳿ⲑⲙⲏϯ ⳿ⲛ⳿ⲧⲁⲥⲁⲙⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ⲟⲩⲟϩ ⲉϥⲛⲁϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩϯⲙⲓ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲛϫⲉ ⲓ̅ ⳿ⲛⲣⲱⲙⲓ ⳿ⲛⲕⲁⲕⲥⲉϩⲧ ⲟⲩⲟϩ ⲛⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϩⲓⲫⲟⲩⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲛⲁⲩϭⲓⲥⲓ ⳿ⲛⲧⲟⲩ⳿ⲥⲙⲏ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲁⲓ ⲛⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⲁⲧⲁⲙⲉ ⲡⲓⲟⲩⲏⲃ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲩϣⲉ ⲛⲱⲟⲩ ⲁⲩⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲧⲁϥⲛⲁⲩ ϫⲉ ⲁϥⲗⲟϫϥ ⲁϥⲧⲁⲥⲑⲟ ⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲉϥϯⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ⲟⲩⲟϩ ⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲡⲉϥϩⲟ ϧⲁⲧⲉⲛ ⲛⲉϥϭⲁⲗⲁⲩϫ ⲉϥϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲟⲧϥ ⲟⲩⲟϩ ⲫⲁⲓ ⲛⲉ ⲩⲥⲁⲙⲁⲣⲓⲧⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲙⲏ ⳿ⲙⲡⲉ ⲡⲓⲓ̅ ⲧⲟⲩⲃⲟ ⲡⲓⲕⲉⲑ̅ ⲁⲩⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩϫⲉⲙⲟⲩ ⲉⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉϯ ⲱⲟⲩ ⳿ⲙⲫϯ ⳿ⲉⲃⲏⲗ ⳿ⲉⲫⲁⲓ ⲁⲗⲗⲟⲅⲉⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲧⲱⲛⲕ ⲙⲁϣⲉ ⲛⲁⲕ ⲡⲉⲕⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ⲉⲧⲁⲩϣⲉⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲁⲥⲛⲁ⳿ⲓ ⳿ⲛ⳿ⲑⲛⲁⲩ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁⲣⲉ ϯ ⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁ⳿ⲓ ⲁⲛ ϧⲉⲛ ⲟⲩⲙⲉⲧⲣⲉϥϯ ⳿ϩⲑⲏϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ⲟⲩⲇⲉ ⲥⲉⲛⲁϫⲟⲥ ⲁⲛ ϫⲉ ⳿ⲥⲧⲁⲓ ⲓⲉ ⳿ⲥⲧⲏ ϩⲏⲡⲡⲉ ⲅⲁⲣ ⲓⲥ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲥⲁϧⲟⲩⲛ ⳿ⲙⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ⲡⲉϫⲁϥ ⲇⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲥⲉⲛⲏ ⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ϩⲟⲧⲉ ⲉⲣⲉⲧⲉⲛⲛⲁⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩⲁⲓ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡϣⲏ ⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲛⲉⲧⲉⲛⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲏⲡⲡⲉ ⳿ϥⲧⲏ ⲓⲉ ⳿ϥⲧⲁⲓ ⳿ⲙⲡⲉⲣϣⲉ ⲛⲱⲧⲉⲛ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣϭⲟϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲥⲉⲧⲉⲃⲣⲏϫ ⳿ⲉϣⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲉⲣⲟⲩⲱⲓⲛⲓ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛ⳿ⲧⲫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲉ ⲡϣⲏ ⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲟϥ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉϥ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ϣⲟⲣⲡ ⲇⲉ ϩⲱϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉϥϭⲓ ⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ⲟⲩⲟϩ ⳿ⲛⲥⲉϣⲟϣϥ ⳿ⲛϫⲉ ⲁⲓⲅⲉⲛⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲱ⳿ⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ⲛⲁⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲛⲁⲩⲥⲱ ⲛⲁⲩϭⲓ ⳿ⲥϩⲓⲙⲓ ⲛⲁⲩϭⲓ ϩⲁⲓ ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲁ ⲛⲱ⳿ⲉ ϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲕⲓⲃⲱⲧⲟⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲕⲁⲧⲁ⳿ⲕⲗⲩⲥⲙⲟⲥ ⲟⲩⲟϩ ⲁϥⲧⲁⲕⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","⳿ⲙ⳿ⲫⲣⲏϯ ⲟⲛ ⲉⲧⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲗⲱⲧ ⲛⲁⲩⲟⲩⲱⲙ ⲛⲁⲩⲥⲱ ⲛⲁⲩϣⲱⲡ ⲁⲩϯ ⳿ⲉⲃⲟⲗ ⲛⲁⲩϭⲟ ⲛⲁⲩⲕⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲉⲧⲁ ⲗⲱⲧ ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲥⲟⲇⲟⲙⲁ ⲁϥϩⲱⲟⲩ ⳿ⲛⲟⲩ⳿ⲭⲣⲱⲙ ⲛⲉⲙ ⲟⲩⲑⲏⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲫⲉ ⲟⲩⲟϩ ⲁϥⲧⲁⲕⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ⲕⲁⲧⲁ ⲛⲁⲓ ⲣⲱ ⲟⲛ ⲁⲥⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲏⲉⲧⲭⲏ ϩⲓϫⲉⲛ ⳿ⲡϫⲉⲛⲉⲫⲱⲣ ⲟⲩⲟϩ ⲉⲣⲉ ⲛⲉϥ⳿ⲥⲕⲉⲩⲟⲥ ϧⲉⲛ ⲡⲓⲏⲓ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲟⲗⲟⲩ ⲟⲩⲟϩ ⲏ ⲉⲧⲭⲏ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥⲕⲟⲧϥ ⳿ⲉⲫⲁϩⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ⲁⲣⲓ⳿ⲫⲙⲉⲩⲓ ⳿ⲛ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲗⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ⲫⲏⲉⲑⲛⲁⲕⲱϯ ⳿ⲛⲥⲁ ⲛⲟϩⲉⲙ ⲛⲧⲉϥ ⲯⲩⲭⲏ ⳿ϥⲛⲁⲧⲁⲕⲟⲥ ⲫⲏⲉⲑⲛⲁⲧⲁⲕⲟⲥ ⲉϥ⳿ⲉⲧⲁⲛϧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⲃ̅ ⲓϫⲉⲛ ⲟⲩϭⲗⲟϫ ⳿ⲛⲟⲩⲱⲧ ⲡⲓⲟⲩⲁⲓ ⲉⲩ⳿ⲉⲟⲗϥ ⲟⲩⲟϩ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲉⲩ⳿ⲉⲭⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲥⲛⲟⲩϯ ⲉⲩⲛⲟⲩⲧ ϧⲉⲛ ⲟⲩⲙⲁ ⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲟⲗⲥ ⲟⲩⲟϩ ϯⲕⲉⲟⲩ⳿ⲓ ⲉⲩ⳿ⲉⲭⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ⲟⲩⲟϩ ⲉⲩⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ϧⲉⲛ ⲁϣ ⳿ⲙⲙⲁ Ⲡ⳪ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⲡⲓⲥⲱⲙⲁ ⳿ⲙⲙⲟϥ ⲥⲉⲛⲁⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲕⲉ⳿ⲁϧⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ⲟⲩⲟϩ ⲁⲩⲉⲣⲟⲩⲱ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ϧⲉⲛ ⲁϣ ⳿ⲙⲙⲁ Ⲡ⳪ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲓⲙⲁ ⲉⲧⲉ ⳿ⲡⲥⲱⲙⲁ ⲙⲟϥ ⲥⲉⲛⲁⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲁϧⲱⲙ ");
INSERT INTO copcnt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲛⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲱⲟⲩ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲟⲩⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲉⲣⲉⲛⲕⲁⲕⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲉϥϯϩⲁⲡ ⲡⲉ ϧⲉⲛ ⲟⲩⲃⲁⲕⲓ ⳿ⲛ⳿ϥⲉⲣϩⲟϯ ⲁⲛ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⳿ⲛ⳿ϥϣⲓⲡⲓ ⲁⲛ ⲁ⳿ⲧϩⲏ ⳿ⲛⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲭⲏⲣⲁ ⲇⲉ ⲡⲉ ϧⲉⲛ ϯ ⲃⲁⲕⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲛⲁⲥⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲡⲉ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϭⲓ ⳿ⲙⲡⲁ⳿ⲙϣⲓϣ ⲉⲙ ⲏ ⲉⲧϭⲓ ⳿ⲙⲙⲟⲓ ⳿ⲛϫⲟⲛⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ⲟⲩⲟϩ ⲛⲁϥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ϣⲁ ⲟⲩⲥⲏⲟⲩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ϫⲉ ⲭⲁⲥ ϫⲉ ⲫϯ ϯⲉⲣϩⲟϯ ⲁⲛ ⲁⲧⲉϥϩⲏ ⲟⲩⲟϩ ⳿ⲛϯϣⲓⲡⲓ ⲁⲛ ϧⲁ⳿ⲧϩⲏ ⳿ⲛⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ⲉⲑⲃⲉϫⲉ ⲧⲁⲓⲭⲏⲣⲁ ϯ ϧⲓⲥⲓ ⲛⲏⲓ ϯⲛⲁϭⲓ ⳿ⲙⲡⲉⲥ⳿ⲙϣⲓϣ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥ⳿ϣⲧⲉⲙ⳿ⲓ ϣⲁ ⳿ⲉⲃⲟⲗ ⲉⲥϯ ϧⲓⲥⲓ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ϫⲉ ⲥⲱⲧⲉⲙ ϫⲉ ⲟⲩ ⲡⲉⲧⲉ ⲡⲓⲣⲉϥϯϩⲁⲡ ⳿ⲛⲧⲉ ϯ⳿ⲁⲇⲓⲕⲓ⳿ⲁ ϫⲱ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ⲫϯ ⲇⲉ ⳿ϥⲛⲁϭⲓ ⳿ⲙⲡⲉ⳿ⲙϣⲓϣ ⲛ ⲛⲛⲉϥⲥⲱⲧⲡ ⲛⲁⲓ ⲉⲧⲱϣ ⲟⲩⲃⲏϥ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲟⲩⲟϩ ⳿ϥⲱⲟⲩ⳿ⲛϩⲏⲧ ⳿ⲉϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ⲥⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ϥⲛⲁϭⲓ ⳿ⲙⲡⲟⲩ⳿ⲙϣⲓϣ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲡⲗⲏⲛ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲁϥϣⲁⲛ⳿ⲓ ϩⲁⲣⲁ ⳿ϥⲛⲁϫⲉⲙ ⳿ⲫⲛⲁϩϯ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ⲁϥϫⲟⲥ ⲉⲑⲃⲉ ϩⲁⲛⲟⲩⲟⲛ ⲛⲏ ⲧϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲛⲉ ⲟⲩⲟϩ ⲉⲩϣⲟϣϥ ⳿ⲛⲛⲓⲕⲉⲥⲱϫⲡ ⳿ⲛⲧⲁⲡⲁⲣⲁⲃⲟⲗⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ⲁ ⲣⲱⲙⲓ ⲃ̅ ϣⲉ ⲛⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲡⲓⲟⲩⲁⲓ ⲛⲉ ⲟⲩⲫⲁⲣⲓⲥⲉⲟⲥ ⲡⲉ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲛⲉ ⲟⲩⲧⲉⲗⲱⲛⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ⲡⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⲉⲧⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲛⲁⲓ ⲁϥⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ϫⲉ ⲫϯ ϯϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲟⲧⲕ ϫⲉ ϯⲟⲓ ⲁⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡⲥⲱϫⲡ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲛⲣⲉϥϩⲱⲗⲉⲙ ⳿ⲛⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ⳿ⲛⲛⲱⲓⲕ ⲓⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲁⲓⲕⲉⲧⲉⲗⲱⲛⲏ ⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ϯⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⳿ⲛⲥⲟⲡⲃ̅ ⲕⲁⲧⲁ ⲥⲁⲃⲃⲁⲧⲟⲛ ϯϯ ⳿ⲙ⳿ⲫⲣⲉⲙⲏⲧ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲉϯ ⳿ϫⲫⲟ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ⲡⲓⲧⲉⲗⲱⲛⲏⲥ ⲇⲉ ⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϩⲓⲫⲟⲩⲉⲓ ⲛⲁϥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ⲟⲩⲇⲉ ⳿ⲉϥⲁⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲁⲗⲗⲁ ⲁϥⲕⲱⲗϩ ⲡⲉ ϧⲉⲛ ⲧⲉϥⲙⲉⲥⲧⲉⲛϩⲏⲧ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫϯ ⲭⲱ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁ ⲫⲁⲓ ⲉ ⲛⲁϥ ⳿ⲉⲡⲉⲥⲏⲧ ⲉϥ⳿ⲑⲙⲁⲓⲏⲟⲩⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲏⲓ ⳿ⲉϩⲟⲧⲉ ⲫⲏ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϭⲁⲥϥ ⲥⲉⲛⲁⲑⲉⲃⲓⲟϥ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁⲑⲉⲃⲓⲟϥ ⲥⲉⲛⲁϭⲁⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ⲛⲁⲩ⳿ⲓⲛⲓ ⲇⲉ ⲛⲁϥ ⳿ⲛϩⲁⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓ ⲛⲉⲙⲱⲟⲩ ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲁⲩⲉⲣ⳿ⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ⲓⲏ̅ⲥ̅ ⲉ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲁ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⳿ⲛⲧⲟⲩ⳿ⲓ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ ⲛⲓⲟⲩⲟⲛ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲑⲱⲟⲩ ⲧⲉ ⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϣⲉⲡ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉⲣⲟϥ ⲁⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲁⲓ⳿ⲁⲗⲟⲩ ⳿ⲛⲛⲉϥ⳿ⲓ ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ⲟⲩⲟϩ ⲁϥϣⲉⲛϥ ⳿ⲛϫⲉ ⲟⲩⲁⲣⲭⲱⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲁⲅⲁⲑⲟⲥ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ⳿ⲛⲧⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⲛⲟⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟⲓ ϫⲉ ⲡⲓ⳿ⲁⲅⲁⲑⲟⲥ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲁⲅⲁⲑⲟⲥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲫϯ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ⲛⲓⲉⲛⲧⲟⲗⲏ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲉⲣⲉⲣⲛⲱⲓⲕ ⳿ⲙⲡⲉⲣϧⲱⲧⲉⲃ ⳿ⲙⲡⲉⲣϭⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉⲣⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ⲙⲁⲧⲁⲓⲉ ⲡⲉⲕⲓⲱⲧ ⲛⲉⲙ ⲉⲕⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⲓⲥϫⲉⲛ ⲧⲁⲙⲉⲧ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲉⲧⲓ ⲕⲉⲟⲩⲁⲓ ⲡⲉ ⲉⲧⲉⲕϣⲁⲧ ⳿ⲙⲙⲟϥ ⳿ⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲉⲧⲉ⳿ⲛⲧⲁⲕ ⲙⲏⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲥⲟⲣⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⲉⲕ⳿ⲉ⳿ϫⲫⲟ ⲛⲁⲕ ⳿ⲛⲟⲩⲁϩⲟ ϧⲉⲛ ⲓⲫⲏⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲩ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲁ ⲡⲉϥϩⲏⲧ ⳿ⲙⲕⲁϩ ⲛⲉ ⲟⲩⲣⲁⲙⲁ⳿ⲟ ⲅⲁⲣ ⲡⲉ ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ⲧⲁϥⲛⲁⲩ ⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲡⲱⲥ ⳿ⲥⲙⲟⲕϩ ⳿ⲛⲧⲉ ⲛⲏⲉⲧⲉ ⲛⲓ⳿ⲭⲣⲏⲙⲁ ⳿ⲛⲧⲱⲟⲩ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","⳿ⲥⲙⲟⲧⲉⲛ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲩϭⲁⲙⲟⲩⲗⲓ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϩⲓⲧⲉⲛ ⳿ⲑⲟⲩⲁⲑⲛⲓ ⳿ⲙⲡⲓⲙⲁ⳿ⲛⲑⲱⲣⲡ ⳿ⲉϩⲟⲧⲉ ⳿ⲛⲧⲉ ⲟⲩⲣⲁⲙⲁⲟ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ⲡⲉϫⲱⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲏ ⲉⲧⲥⲱⲧⲉⲙ ϫⲉ ⲛⲓⲙ ϩⲱϥ ⳿ⲉⲧⲉⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲛⲓⲁⲧϫⲟⲙ ⳿ⲛⲧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⲙⲙⲱⲟⲩ ⳿ⲛⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲇⲉ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲭⲁ ⲡⲉⲧⲉⲛⲧⲁⲛ ⲁⲛⲙⲟϣⲓ ⳿ⲛⲥⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲁϥⲭⲁ ⲏⲓ ⳿ⲛⲥⲱϥ ⲓⲉ ⳿ⲥϩⲓⲙⲓ ⲓⲉ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ ⲓⲉ ϩⲁⲛⲓⲟϯ ⲓⲉ ϩⲁⲛϣⲏⲣⲓ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ϫⲉ ⳿ϥⲛⲁϭⲓⲧⲟⲩ ⲁⲛ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲕⲱⲃ ϧⲉⲛ ⲡⲁⲓⲥⲏⲟⲩ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓ⳿ⲉⲛⲉϩ ⲉⲑⲛⲏⲟⲩ ⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ⲉⲧⲁϥ⳿ⲓⲛⲓ ⲇⲉ ⳿ⲉⲧⲟⲧϥ ⳿ⲙⲡⲓⲓ̅ⲃ̅ ⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ⲧⲉⲛⲛⲁϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲥⲉⲛⲁϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲥϧⲏ ⲟⲩⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲉⲑⲃⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ⲥⲉⲛⲁⲧⲏⲓϥ ⲅⲁⲣ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ⲥⲉⲛⲁⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲉⲛⲁϣⲟϣϥ ⲟⲩⲟϩ ⲥⲉⲛⲁϩⲓⲑⲁϥ ⳿ⲉⲡⲉϥϩⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ⲟⲩⲟϩ ⲁⲩϣⲁⲛⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲟϥ ⲥⲉⲛⲁϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲱⲛϥ ϧⲉⲛ ⲡⲓⲙⲁϩⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲙⲡⲟⲩⲕⲁϯ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲛⲛⲁⲓ ⲟⲩⲟϩ ⲛⲁϥϩⲏⲡ ⳿ⲉⲣⲱⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲉⲙⲓ ⲁⲛ ⲡⲉ ⳿ⲉⲛⲏ ⳿ⲉⲛⲁϥϫⲱ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲧⲁϥϧⲱⲛⲧ ⳿ⲉⲓⲉⲣⲓⲭⲱ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲃⲉⲗⲗⲉ ⲡⲉ ⲉϥϩⲉⲙⲥⲓ ϧⲁⲧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲉϥϣⲁⲧⲙⲉⲑⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲟⲩⲙⲏϣ ⲉϥⲥⲓⲛⲓⲱⲟⲩ ⲛⲁϥϣⲓⲛⲓ ⲡⲉ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ⲁⲩⲧⲁⲙⲟϥ ⲇⲉ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲛⲁⲍⲱⲣⲉⲟⲥ ⲥⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ⲟⲩⲟϩ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡϣⲏⲣⲓ ⳿ⲛⲇⲁⲩⲓⲇ ⲛⲁⲓ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ⲟⲩⲟϩ ⲛⲏ ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ⳿ⲉ⳿ⲧϩⲏ ⲛⲁⲩⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲭⲁⲣⲱϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲙⲁⲗⲗⲟⲛ ⳿ⲛϩⲟⲩⲟ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲇⲁⲩⲓⲇ ⲛⲁⲓ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ⲉⲧⲁϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲟⲩ⳿ⲉⲛϥ ϩⲁⲣⲟϥ ⲉⲧⲁϥϧⲱⲛⲧ ⲇⲉ ⲉⲣⲟϥ ⲁϥϣⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲁⲓϥ ⲛⲁⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲡⲉⲕⲛⲁϩϯ ⲡⲉⲧⲁϥⲛⲁϩⲙⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲉϥϯⲱⲟⲩ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲉⲧⲁⲩⲛⲁⲩ ⲁⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ");
INSERT INTO copcnt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ⲟⲩⲟϩ ⲉⲧⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ϧⲉⲛ ⲓⲉⲣⲓⲭⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⲉⲩⲙⲟⲩϯ ⲉⲡⲉϥⲣⲁⲛ ϫⲉ ⲍⲁⲕⲭⲉⲟⲥ ⲟⲩⲟϩ ⲫⲁⲓ ⲛⲉ ⲟⲩⲁⲣⲭⲓⲧⲉⲗⲱⲛⲏ ⲥ ⲡⲉ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲣⲁⲙⲁ⳿ⲟ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲉⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲩⲟϩ ⲛⲁϥ⳿ϣϫⲉⲙϫⲟⲙ ⲁⲛ ⲡⲉ ⲉⲑⲃⲉ ⲡⲓⲙⲏϣ ϫⲉ ⲛⲉ ⲟⲩⲕⲟⲩϫⲓ ⲡⲉ ϧⲉⲛ ⲧⲉϥⲙⲁⲓⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ⲉⲧⲁϥϭⲟϫⲓ ⳿ⲉ⳿ⲧϩⲏ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲩⲥⲩⲕⲟⲙⲟⲣⲉ⳿ⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲛⲁϥⲥⲓⲛⲓ ⲡⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ ⲁϥⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲁϥ ϫⲉ ⲍⲁⲕⲭⲉⲟⲥ ⲭⲱⲗⲉⲙ ⳿ⲙⲙⲟⲕ ⳿ⲁⲙⲟⲩ ⲉⲡⲉⲥⲏⲧ ⳿ⲙⲫⲟⲟⲩ ⲅⲁⲣ ϩⲱϯ ⳿ⲉⲣⲟⲓ ⳿ⲛⲧⲁϣⲱⲡⲓ ϧⲉⲛ ⲡⲉⲕⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ⲟⲩⲟϩ ⲁϥⲭⲱⲗⲉⲙ ⳿ⲙⲙⲟϥ ⲁϥ⳿ⲓ ⲉⲡⲉⲥⲏ ⲧ ⲟⲩⲟϩ ⲁϥϣⲟⲡϥ ⳿ⲉⲣⲟϥ ⲉϥⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ⲟⲩⲟϩ ⲛⲏ ⲧⲏⲣⲟⲩ ⲉⲧⲁⲩⲛⲁⲩ ⲁⲩⲉⲣ⳿ⲭ ⲣⲉⲙⲣⲉⲙ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⲛⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲍⲁⲕⲭⲉⲟⲥ ⲡⲉϫⲁϥ ⳿ⲙⲠ⳪ ϫⲉ Ⲡ⳪ ϩⲏⲡⲡⲉ ϯϯ ⳿ⲛ⳿ⲧⲫⲁϣⲓ ⳿ⲛⲛⲁϩⲩⲡⲁⲣⲭ ⲟⲛⲧⲁ ⳿ⲛⲛⲓϩⲏⲕⲓ ⲟⲩⲟϩ ⲫⲏⲉⲧⲁⲓϭⲓⲧϥ ⳿ⲛϫⲟⲛⲥ ⳿ⲛ⳿ϩⲗⲓ ϯⲛⲁⲕⲟⲃⲟⲩ ⲛⲁϥ ⳿ⲛⲇ̅ ⳿ⲛⲕⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ϫⲉ ⳿ⲙⲫⲟⲟⲩ ⳿ⲡⲟⲩϫⲁⲓ ϣⲱⲡⲓ ϧⲉⲛ ⲁⲓⲏⲓ ϫⲉ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲟⲩϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲁⲃⲣⲁⲁⲙ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ⲁϥ⳿ⲓ ⲅⲁⲣ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ⲉⲕⲱϯ ⲟⲩⲟϩ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲁϥⲟⲩⲁϩⲧⲟⲧϥ ⳿ⲛϫⲉ ⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⲉⲑⲃⲉϫⲉ ⲛⲁϥϧⲉⲛⲧ ⲡⲉ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲟⲩⲱⲛϩ ⲉⲃⲟⲗ ⲥⲁⲧⲟⲧⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ⲡⲉϫⲁϥ ⲟⲩⲛ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲉⲩⲅⲉⲛⲏⲥ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲟⲩⲭⲱⲣⲁ ⲉⲥⲟⲩⲏⲟⲩ ⳿ⲉϭⲓ ⳿ⲛⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲉⲧⲁⲥⲑⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ⲉⲧⲁϥⲙⲟⲩϯ ⲇⲉ ⳿ⲉⲓ̅ ⳿ⲙⲃⲱⲕ ⳿ⲛⲧⲁϥ ⲁϥϯ ⳿ⲙⲓ̅ ⳿ⲛⲉⲙⲛⲁ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲣⲓⲓⲉⲃϣⲱⲧ ϧⲉⲛ ⲛⲁⲓ ϣⲁϯ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ⲉϥⲡⲟⲗⲓⲧⲏⲥ ⲇⲉ ⲛⲁⲩⲙⲟⲥϯ ⳿ⲙⲙⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛⲟⲩ⳿ⲡⲣⲉⲥⲃⲓ⳿ⲁ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲛⲟⲩⲉϣ ⲫⲁⲓ ⲁⲛ ⲉⲑⲣⲉϥⲉⲣⲟⲩⲣⲟ ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁϥⲧⲁⲥⲑⲟ ⳿ⲉⲁϥϭⲓ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⲁϥϫⲟⲥ ⲉⲑⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲛⲓ⳿ⲉⲃⲓⲁⲓⲕ ⲛⲁⲓ ⲉⲧⲁϥϯ ⳿ⲙⲡⲓϩⲁⲧ ⲛⲱⲟⲩ ⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⳿ⲙⲙⲉⲧⲓⲉⲃϣⲱⲧ ⲉⲧⲁⲩⲁⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓϩⲟⲩⲓⲧ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲁ ⲡⲉⲕⲉⲙⲛⲁ ⲁϥⲉⲣ ⲓ̅ ⳿ⲛⲉⲙⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲕⲁⲗⲱⲥ ⲡⲓⲃⲱⲕ ⲉⲑⲛⲁⲛⲉϥ ⲉⲑⲃⲉϫⲉ ⲁⲕϣⲱⲡⲓ ⲉⲕⲉⲛϩⲟⲧ ϧⲉⲛ ϩⲁⲛⲕⲟⲩϫⲓ ϣⲱⲡⲓ ⳿ⲉⲟⲩⲟⲛⲧⲉⲕ ⲉⲣϣⲓϣⲓ ⲙⲙⲁⲩ ⲉϫⲉⲛ ⲓ̅ ⳿ⲙⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲙⲁϩⲃ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ⲁ ⲡⲉⲕ⳿ⲙⲛⲁ ⲁϥⲉⲣ ⲉ̅ ⳿ⲛ⳿ⲙⲛⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ⲡⲉϫⲁϥ ⲇⲉ ⲟⲛ ⳿ⲙⲡⲁⲓⲭⲉⲧ ⲉ ⲱⲡⲓ ϩⲱⲕ ⳿ⲉϫⲉⲛ ⲉ̅ ⳿ⲙⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁϫ̅ⲥ̅ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲕ⳿ⲙⲛⲁ ⳿ϥⲭⲏ ⳿ⲛⲧⲟⲧ ⲁⲓⲕⲟⲩⲗⲱⲗϥ ϧⲉⲛ ⲩⲥⲟⲩⲇⲁⲣⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ⲛⲁⲓⲉⲣϩⲟϯ ϧⲁⲧⲉⲕϩⲏ ⲡⲉ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲣⲱⲙⲓ ⲉϥⲛⲁϣⲧ ⳿ⲕⲱⲗⲓ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲙⲡⲉⲕⲭⲁϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⳿ⲕⲱⲥϧ ⳿ⲙⲫⲏ ⲧⲉ⳿ⲙⲡⲉⲕⲥⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱⲕ ϯⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟⲕ ⲡⲓⲃⲱⲕ ⲉⲧϩⲱⲟⲩ ⲓⲥϫⲉ ⳿ⲕⲥⲱⲟⲩⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ⲉϥⲛⲁϣⲧ ⲓⲱⲗⲓ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲙⲡⲓⲭⲁϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⲉⲓⲱⲥϧ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲙⲡⲓⲥⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ⲉⲑⲃⲉⲟⲩ ⳿ⲙⲡⲉⲕϯ ⳿ⲙⲡⲁϩⲁⲧ ⳿ⲉϯ⳿ⲧⲣⲁⲡⲉⲍⲁ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛ⳿ⲓ ⲁⲓⲛⲁⲉⲣ⳿ⲡⲣⲁⲥⲥⲓⲛ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲧⲉϥⲙⲏⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲏⲉⲧⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϫⲉ ⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓ⳿ⲙⲛⲁ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲫⲁⲓ ⲟⲩⲟϩ ⲙⲏⲓϥ ⳿ⲙⲫⲏ ⲧⲉ ⲡⲓⲓ̅ ⳿ⲛ⳿ⲙⲛⲁ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲟⲩⲟⲛ ⲓ̅ ⳿ⲛⲉⲙⲛⲁ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲉ ⲩⲟⲛ ⳿ⲛⲧⲁϥ ⲉⲩ⳿ⲉϯⲛⲁϥ ⲫⲏ ⲇⲉ ⲉⲧⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲁϥ ⲡⲉⲧⲉ⳿ⲛⲧⲟⲧϥ ⲥⲉⲛⲁⲟⲗϥ ⳿ⲛⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","⳿ⲡⲗⲏⲛ ⲛⲁϫⲁϫⲓ ⲛⲁⲓ ⲉⲧⲉ⳿ⲙⲡⲟⲩⲟⲩⲱϣ ⲉⲑⲣⲓⲉⲣⲟⲩⲣⲟ ⳿ⲉ⳿ϩⲣⲏⲓ ⲉϫⲱⲟⲩ ⳿ⲁⲛⲓⲧⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⲟⲩⲟϩ ϧⲉⲗϧⲱⲗⲟⲩ ⳿ⲙⲡⲁ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ⲟⲩⲟϩ ⲉⲧⲁϥϫⲉ ⲛⲁⲓ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ϩⲓ⳿ⲧϩⲏ ϥⲛⲁ ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲉⲃⲏⲑⲫⲁⲅⲏ ⲛⲉⲙ ⲃⲏⲑⲁⲛⲓ⳿ⲁ ϧⲁⲧⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲫⲁⲛⲓϫⲱⲓⲧ ϥⲟⲩⲱⲣⲡ ⳿ⲙⲃ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉⲡⲁⲓϯⲙⲓ ⲉⲧⲭⲏ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⲧⲉⲧⲉⲛⲛⲁϫⲓⲙⲓ ⳿ⲛⲟⲩⲥⲏϫ ϥⲥⲟⲛϩ ⲫⲏⲉⲧⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲛⲣⲱⲙⲓ ⳿ⲁⲗⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲉⲛⲉϩ ⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⳿ⲁⲛⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ϣⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲉⲧⲉⲛⲃⲱⲗ ⳿ⲙⲙⲟϥ ⳿ⲁϫⲟⲥ ⳿ⲙⲡⲁⲓⲣⲏϯ ϫⲉ Ⲡ⳪ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ ⲁⲩϫⲓⲙⲓ ⲕⲁⲧⲁ ⲫⲣⲏϯ ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ⲉⲩⲃⲱⲗ ⲇⲉ ⳿ⲙⲡⲓⲥⲏϫ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲉ ⲛⲉϥϭⲓⲥⲉⲩ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲃⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓⲥⲏϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲡ⳪ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲛϥ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲧⲁⲩⲃⲟⲣⲃⲉⲣ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲉϫⲉⲛ ⲡⲓⲥⲏϫ ⲁⲩⲧⲁⲗⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ⲉⲩⲙⲟϣⲓ ⲇⲉ ⲛⲁⲩⲫⲱⲣϣ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ϩⲓ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ⲉϥⲛⲁϧⲱⲛⲧ ⲇⲉ ϩⲏⲇⲏ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛⲧⲉ ⲡⲓⲧⲱⲟⲩ ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⲁϥⲉⲣϩⲏ ⲧⲥ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲩⲣⲁϣⲓ ⲉⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲉⲑⲃⲉ ⲛⲓϫⲟⲙ ⲧⲏⲣⲟⲩ ⲧⲁⲩⲛⲁⲩ ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲣⲟ ⲫⲏⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⲟⲩϩⲓⲣⲏⲛⲏ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲟⲩⲱⲟⲩ ϧⲉⲛ ⲛⲏⲉⲧϭⲟⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ⲟⲩⲟϩ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲡⲓⲣⲉϥϯ ⳿ⲥⲃⲱ ⲁⲣⲓⲉⲡⲓⲧⲓⲙⲁⲛ ⳿ⲛⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ⲟⲩⲟϩ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ϫⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲉϣⲁⲛ ⲛⲁⲓ ⲭⲁⲣⲱⲟⲩ ⲥⲉⲛⲁⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲁⲓⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ⲟⲩⲟϩ ϩⲱⲥ ⲧⲁϥϧⲱⲛⲧ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉϯⲃⲁⲕⲓ ⲁϥⲣⲓⲙⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲛⲁⲣⲉ⳿ⲉⲙⲓ ϩⲱⲓ ⲡⲉ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲛⲁ ⲧⲉϩⲓⲣⲏⲛⲏ ϯⲛⲟⲩ ⲉ ⲁⲩϩⲱⲡ ⳿ⲉⲃⲟⲗ ϩⲁ ⲛⲉⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ϫⲉ ⲥⲉⲛⲁ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲁⲕⲧⲉ ⲕⲁϣ ⳿ⲉⲣⲟ ⳿ⲛϫⲉ ⲛⲉϫⲁϫⲓ ⲟⲩⲟϩ ⲉⲛⲁⲕⲱϯ ⲉⲣⲟ ⲟⲩⲟϩ ⲥⲉⲛⲁϩⲉϫϩⲱϫⲓ ⲥⲁⲥⲁ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲣⲱϧⲧ ⳿ⲙⲙⲟ ⳿ⲉⲡⲉⲥⲏⲧ ⲛⲉⲙ ⲛⲉϣⲏⲣⲓ ⳿ⲛϧⲏϯ ⲟⲩⲟϩ ⳿ⲛⲛⲟⲩⲭⲁ ⲟⲩⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲱⲛⲓ ⲛϧⲏϯ ⳿ⲉ⳿ⲫⲙⲁ ϫⲉ ⳿ⲙⲡⲉ⳿ⲉⲙⲓ ⳿ⲉ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϫⲉⲙ⳿ⲡϣⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ⲟⲩⲟϩ ⲉⲧⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲏⲉⲧϯ ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲁⲏⲓ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲛⲟⲩⲏⲓ ⳿ⲙ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲁⲣⲉⲧⲉⲛⲁⲓϥ ⳿ⲙⲃⲏⲃ ⳿ⲛⲥⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⳿ⲙⲙⲏⲛⲓ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓϩⲟⲩ⳿ⲁϯ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ ⲧⲁⲕⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ⲟⲩⲟϩ ⲛⲁⲩϫⲓⲙⲓ ⲁⲛ ⲡⲉ ⳿ⲙⲫⲏ⳿ⲉⲧⲟⲩⲛⲁⲁⲓϥ ⲡⲓⲗⲁⲟⲥ ⲅⲁⲣ ⲧⲏⲣϥ ⲛⲁⲩ⳿ⲁϣⲓ ⳿ⲛⲥⲱϥ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲁⲓ ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲁϫⲟⲥ ⲛⲁⲛ ϫⲉ ⲁⲕ⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ ⲓⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϯ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ⲁϥⲉⲣⲟⲩⲱ ⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯⲛⲁϣⲉⲛ ⲑⲏⲛⲟⲩ ϩⲱ ⳿ⲉⲟⲩⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲁϫⲟϥ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ϣⲁⲛ ⲟⲩ⳿ⲉⲃⲟⲗ ⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲥⲟϭⲛⲓ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉϣⲱⲡ ⲁⲛϣⲁⲛϫⲟⲥ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲡⲉ ⳿ϥⲛⲁϫⲟⲥ ϫⲉ ⲑⲃⲉⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ⲉϣⲱⲡ ⲇⲉ ⲁⲛϣⲁⲛϫⲟⲥ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲡⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲛⲁϥϩⲓⲱⲛⲓ ⳿ⲉⲣⲟⲛ ⲡⲟⲩϩⲏⲧ ⲅⲁⲣ ⲏⲧ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ⲟⲩⲟϩ ⲁⲩⲉⲣⲟⲩⲱ ϫⲉ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲛϯⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⲁⲓ⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲉⲣϣⲓϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ⲁϥⲉⲣϩⲏⲧⲥ ⲇⲉ ⳿ⲛⲥⲁϫⲓ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ ⳿ⲛⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲉ ⲩⲟⲛ ⲩⲣⲱⲙⲓ ⳿ⲉⲁϥϭⲟ ⳿ⲛⲟⲩⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲛϩⲁⲛⲟⲩⲓⲏ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲡⲥⲏⲟⲩ ϥⲟⲩⲱⲣⲡ ⳿ⲛⲟⲩⲃⲱⲕ ϩⲁ ⲛⲓⲟⲩⲓⲏ ϩⲓⲛⲁ ⳿ⲛⲥⲉϯ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲛⲓⲟⲩⲓⲏ ⲇⲉ ⲉⲧⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟϥ ⲁⲩϯⲧⲟⲧϥ ⳿ⲉⲃⲟⲗ ϥϣⲟⲩⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲧⲟⲧϥ ⲟⲛ ⳿ⲉⲟⲩⲱⲣⲡ ⲛⲱⲟⲩ ⳿ⲛⲕⲉⲃⲱⲕ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲉⲧⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲡⲓ ⲭⲉⲧ ⲟⲩⲟϩ ⲉⲧⲁⲩϣⲟϣϥ ⲁⲩϯⲧⲟⲧϥ ⲉⲃⲟⲗ ⲉϥϣⲟⲩⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲧⲟⲧϥ ⲟⲛ ⳿ⲉⲟⲩⲱⲣⲡ ⳿ⲙⲡⲓⲙⲁϩⲅ̅ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲫⲱⲗϩ ⳿ⲙⲡⲁⲓⲭⲉⲧ ⲁⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ⲡⲉϫⲉ ⳪ ⲇⲉ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ ϯⲛⲁⲟⲩⲱⲣⲡ ⳿ⲙⲡⲁϣⲏⲣⲓ ⳿ⲙⲙⲉⲛⲣⲓⲧ ⲁⲣⲏⲟⲩ ⳿ⲛⲥⲉϣⲓⲡⲓ ϧⲁⲧⲉϥϩⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲓⲟⲩⲓⲏ ⲛⲁⲩⲥⲟϭⲛⲓ ⲡⲉ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲁⲙⲱⲓⲛⲓ ⲙⲁⲣⲉⲛϧⲟⲑⲃⲉϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ ⲛⲁⲛ ⳿ⲛϫⲉ ϯ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ⲟⲩⲟϩ ⲉⲧⲁⲩϩⲓⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⲁⲩϧⲟⲑⲃⲉϥ ⲟⲩ ⲡⲉⲧⲉϥⲛⲁⲁⲓϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲡ⳪ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","⳿ϥⲛⲁⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲁⲕⲉ ⲛⲓⲟⲩⲓⲏ ⲟⲩⲟϩ ⳿ϥⲛⲁϯ ⳿ⲙⲡⲓⲓⲁϩ⳿ⲁⲗⲟⲗⲓ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","⳿ⲛⲑⲟϥ ⲇⲉ ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉⲣⲱⲟⲩ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲓⲱⲛⲓ ⲉⲧⲁⲩϣⲟϣϥ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲱⲧ ⲫⲁⲓ ⲁϥϣⲱⲡⲓ ⲉⲩϫⲱϫ ⳿ⲛⲗⲁⲕϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲓⲱⲛⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ϥⲛⲁⲗⲱⲥ ⲫⲏ ⲇⲉ ⲉⲧⲉϥⲛⲁϩⲉⲓ ⳿ⲉϫⲱϥ ⳿ϥⲛⲁϣⲁϣϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲥⲁϧ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲉ⳿ⲉⲛ ⲛⲟⲩϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲁⲩ⳿ⲉⲙⲓ ⲅⲁⲣ ϫⲉ ⲉⲧⲁϥϫⲉ ⲧⲁⲓⲡⲁⲣⲁⲃⲟⲗⲏ ⲉⲑⲃⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ⲟⲩⲟϩ ⲉⲧⲁⲩϯ⳿ϩⲑⲏⲟⲩ ⲁⲩⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⳿ⲛϩⲁⲛⲣⲉϥ⳿ⲭⲣⲟϥ ⲩⲉⲣⲙⲉⲧϣⲟⲃⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ϩⲁⲛ⳿ⲑⲙⲏⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲧⲁϩⲟϥ ⳿ⲛⲟⲩⲥⲁϫⲓ ϩⲱⲥⲧⲉ ⳿ⲉⲧⲏⲓϥ ⳿ⲛϯⲁⲣⲭⲏ ⲛⲉⲙ ϯ⳿ⲉⲝⲟⲩⲥⲓⲁ ⳿ⲛⲧⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲕⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲥⲱⲟⲩⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲕϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⳿ⲕϭⲓ ϩⲟ ⲁⲛ ⲁⲗⲗⲁ ϧⲉⲛ ⲩⲙⲉⲑⲙⲏⲓ ⳿ⲕϯ⳿ⲥⲃⲱ ⳿ⲙⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","⳿ⲥϣⲉ ⳿ⲛϯϩⲱϯ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ϣⲁⲛ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ⲉⲧⲁϥϯ⳿ϩⲑⲏϥ ⲇⲉ ⲉⲧⲟⲩⲙⲉⲧⲡⲁⲛⲟⲩⲣⲅⲟⲥ ⲡⲉϫⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ϫⲉ ⲙⲁⲧⲁⲙⲟⲓ ⳿ⲉⲟⲩⲥⲁⲑⲉⲣⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲧⲁⲙⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯ ϩⲓⲕⲱⲛ ⲛⲉⲙ ϯⲉⲡⲓⲅⲣⲁⲫⲏⲉⲧϩⲓⲱⲧⲥ ⲛⲁ ⲓⲙ ⲛⲉ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯⲛⲟⲩ ⲙⲁ ⲛⲁ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲟⲩⲟϩ ⲙⲁ ⲛⲁ ⲫϯ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲉⲁⲙⲁϩⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩⲥⲁϫⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⲉⲧⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥϫⲓⲛⲉⲣⲟⲩⲱ ⲁⲩⲭⲁⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲛϫⲉ ϩⲁⲛⲥⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲛⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲁⲩϣⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","⳿ⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲥϧⲁⲓ ⲛⲁⲛ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ ⳿ⲡⲥⲟⲛ ⳿ⲛⲟⲩⲁⲓ ⲙⲟⲩ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲫⲁⲓ ⳿ⲙⲙⲟⲛⲧⲉϥ ϣⲏⲣⲓ ⳿ⲙⲙⲁⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉϥⲥⲟⲛ ϭⲓ ⳿ⲛⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲟⲩⲛⲟⲥ ⲟⲩ⳿ϫⲣⲟϫ ⳿ⲙⲡⲉϥⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ⲛⲉ ⲟⲩⲟⲛ ⲍ̅ ⲟⲩⲛ ⳿ⲛⲥⲟⲛ ⲡⲉ ⲟⲩⲟϩ ⲡⲓϩⲟⲩⲓⲧ ⳿ⲉⲧⲁϥϭⲓ⳿ⲥϩⲓⲙⲓ ⲁϥⲙⲟⲩ ⳿ⲛⲧⲁϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ⲟⲩⲟϩ ⲡⲓⲙⲁϩⲃ̅ ⲁϥϭⲓⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ⲛⲉⲙ ⲡⲓⲙⲁϩⲅ̅ ⲡⲁⲓⲣⲏϯ ⲇⲉ ϣⲁ ⲡⲓⲙⲁϩⲍ̅ ⳿ⲙⲡⲟⲩⲭⲁ ⲏⲣⲓ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","⳿ⲉ⳿ⲡϧⲁⲉ ⲇⲉ ⲁⲥⲙⲟⲩ ϩⲱⲥ ⳿ⲛϫⲉ ϯⲕⲉ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","⳿ⲛ⳿ϩⲣⲏⲓ ⲟⲩⲛ ϧⲉⲛ ϯⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲁⲥⲛⲁⲉⲣ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲛⲓⲙ ⲙⲙⲱⲟⲩ ⲁ ⲡⲓⲍ̅ ⲅⲁⲣ ϭⲓⲧⲥ ⲉⲩ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲁⲓⲉⲛⲉϩ ϣⲁⲩϭⲓ ⲟⲩⲟϩ ϣⲁⲩ ϭⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ⲛⲏ ⲇⲉ ⲉⲧⲁⲩⲉⲣ⳿ⲡⲉⲙ⳿ⲡϣⲁ ⳿ⲙⲡⲓⲉⲛⲉϩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ϯⲁⲛⲁⲥⲧⲁⲥⲓⲥ ϯ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩϭⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲩ ϭⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ⲟⲩⲇⲉ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲥⲉⲙⲟⲩ ϫⲉ ϩⲁⲛϩⲓⲥⲟⲥ ⳿ⲛⲁⲅⲅⲉⲗⲟⲥ ⲅⲁⲣ ⲛⲉ ⲟⲩⲟϩ ϩⲁⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ ⲛⲉ ⲉⲩⲟⲓ ⳿ⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ϯⲁⲛⲁⲥⲧⲁⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ⲟⲧⲓ ⲇⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲛⲁⲧⲱⲟⲩⲛⲟⲩ ⲙⲱ⳿ⲩⲥⲏⲥ ϩⲱϥ ⲁϥϯⲙⲏⲓⲛⲓ ϩⲓ ⲡⲓⲃⲁⲧⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ϯ ⲛⲁⲃⲣⲁⲁⲙ ⲛⲉⲙ ⲫϯ ⳿ⲛ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ ⲫϯ ⳿ⲛⲓⲁⲕⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ⲫϯ ⲫⲁ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲁ ⲛⲏⲉⲧⲟⲛϧ ⲡⲉ ⲥⲉⲟⲛϧ ⲅⲁⲣ ⲛⲁϥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ⲁⲩⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲥⲁϧ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲕⲁⲗⲱⲥ ⲁⲕϫⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ⲛⲁⲩ⳿ϣⲉⲣⲧⲟⲗⲙⲁⲛ ⲅⲁⲣ ⲁⲛ ⲉ ⳿ⲉϣⲉⲛϥ ⳿ⲉ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲡⲱⲥ ⲥⲉϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡϣⲏⲣⲓ ⳿ⲛⲇⲁⲩⲓⲇ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","⳿ⲛⲑⲟϥ ⲅⲁⲣ ⲇⲁⲩⲓⲇ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϧⲉⲛ ⳿ⲡϫⲱⲙ ⳿ⲛⲛⲓⲯⲁⲗⲙⲟⲥ ϫⲉ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲡⲁϫ̅ⲥ̅ ϫⲉ ϩⲉⲙⲥⲓ ⲥⲁⲧⲁⲟⲩⲓⲛⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ϣⲁϯⲭⲁ ⲛⲉⲕϫⲁϫⲓ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛⲛⲉⲕ ϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ⲇⲁⲩⲓⲇ ⲟⲩⲛ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲁ ϫ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲱⲥ ⲡⲉϥϣⲏⲣⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ⲉϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲡⲉϫⲁϥ ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ϫⲉ ⲙⲁ⳿ϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲁ ⲛⲓⲥⲁϧ ⲛⲏⲉⲑⲟⲩⲱϣ ⳿ⲉⲙⲟϣⲓ ϧⲉⲛ ϩⲁⲛ⳿ⲥⲧⲟⲗⲏ ⲟⲩⲟϩ ⲉⲩⲙⲉⲓ ⳿ⲛⲛⲓⲁⲥⲡⲁⲥⲙⲟⲥ ⲉⲛ ⲓⲁⲅⲟⲣⲁ ⲛⲉⲙ ⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁⲛϩⲉⲙⲥⲓ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲛⲓϣⲟⲣⲡ ⳿ⲙⲙⲁ⳿ⲛⲣⲱⲧⲉⲃ ϧⲉⲛ ⲛⲓⲇⲓⲡⲛⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ⲛⲏⲉⲑⲟⲩⲱⲙ ⳿ⲛⲛⲓⲏⲓ ⳿ⲛⲧⲉ ⲓⲭⲏⲣⲁ ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩⲗⲱⲓϫⲓ ⲉⲥⲟⲩⲏⲟⲩ ⲥⲉⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭ ⲉⲥⲑⲉ ⲛⲁⲓ ⲉⲩ⳿ⲉϭⲓ ⳿ⲛⲟⲩϩⲁⲡ ⳿ⲛϩⲟⲩ⳿ⲟ ");
INSERT INTO copcnt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ⲉⲧⲁϥⲥⲟⲙⲥ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⲁϥⲛⲁⲩ ⲉϩⲁⲛⲣⲁⲙⲁ⳿ⲟ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲛⲛⲟⲩⲇⲱⲣⲟⲛ ⳿ⲉⲛⲓⲅⲁⲍⲟⲫⲩⲗⲁⲕⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲭⲏⲣⲁ ϩⲱⲥ ⳿ⲛϩⲏⲕⲓ ⲉⲥϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲙⲁⲩ ⳿ⲛⲗⲉⲡⲧⲟⲛ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲗⲏⲑⲱⲥ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲧⲁⲓⲭⲏⲣⲁ ⳿ⲛϩⲏⲕⲓ ⲁⲥϩⲓⲟⲩ⳿ⲓ ⳿ⲉϩⲟⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ⲉⲧⲁ ⲛⲁⲓ ⲅⲁⲣ ϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲇⲱⲣⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲣⲱⲟⲩ ⲑⲁⲓ ⳿ⲛⲑⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲥⲉⲣϧⲁ⳿ⲉ ⳿ⲙⲙⲟϥ ⲡⲉⲥⲱⲛϧ ⲧⲏⲣϥ ⲉⲛⲁϥ⳿ⲛⲧⲁⲥ ⲁⲥϩⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ⲟⲩⲟϩ ⲉⲣⲉ ⲁⲛⲟⲩⲟⲛ ⲱ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲉ ⲡⲓⲉⲣⲫⲉⲓ ϫⲉ ⲁⲩⲥⲉⲗⲥⲱⲗϥ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ϩⲁⲛⲱⲛⲓ ⲉⲛⲁⲛⲉⲩ ⲛⲉⲙ ϩⲁⲛⲁⲛⲁⲑⲏⲙⲁ ⲡⲉϫⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ϫⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲧⲉⲧⲉⲛⲛⲁⲩ ⲉⲣⲱⲟⲩ ⲥⲉⲛⲏⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲥⲉⲛⲁⲭⲁ ⲟⲩⲱⲛⲓ ⲁⲛ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉϫⲉⲛ ⲟⲩⲱⲛⲓ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲥⲉⲛⲁⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ⲁⲩϣⲉⲛϥ ⲇⲉ ϫⲉ ⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲁⲣⲉ ⲛⲁⲓ ⲛⲁϣⲱⲡⲓ ⳿ⲛ⳿ⲑⲛⲁⲩ ⲟⲩⲟϩ ⲟⲩ ⲡⲉ ⲡⲓⲙⲏⲓⲛⲓ ⲁⲣⲉϣⲁⲛ ⲛⲁⲓ ⲛⲟⲩ⳿ⲓ ⳿ⲉϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲁⲩ ⳿ⲙⲡⲉⲣⲥⲱⲣⲉⲙ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲅⲁⲣ ⲛⲁⲓ ⳿ⲉⲡⲁⲣⲁⲛ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲟⲩⲟϩ ⲁ ⳿ⲡⲥⲏⲟⲩ ϧⲱⲛⲧ ⳿ⲙⲡⲉⲣⲙⲟϣⲓ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ϩⲟⲧⲁⲛ ⲇⲉ ⲣⲉⲧⲉⲛϣⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉϩⲁⲛⲡⲟⲗⲉⲙⲟⲥ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲙⲡⲉⲣⲛⲟⲩϣⲡ ⲁⲗⲗⲁ ⲥⲁⲧⲟⲧϥ ⲁⲛ ⲡⲉ ⲡⲓϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ⲧⲟⲧⲉ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲱⲟⲩ ⲡⲉ ϫⲉ ⲉϥ⳿ⲉⲧⲱⲛϥ ⳿ⲛϫⲉ ⲟⲩⲉⲑⲛⲟⲥ ⳿ⲉϫⲉⲛ ⲟⲩⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ ⳿ⲉϫⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ϩⲁⲛⲛⲓϣϯ ⲇⲉ ⳿ⲙⲙⲟⲛⲙⲉⲛ ⲩ⳿ⲉϣⲱⲡⲓ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛ⳿ϩⲃⲱⲛ ⲛⲉⲙ ϩⲁⲛⲙⲟⲩ ⲕⲁⲧⲁ ⲙⲁ ϩⲁⲛϩⲟϯ ⲇⲉ ⲛⲉⲙ ϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏⲓⲛⲓ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ⲁϫⲉⲛ ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⲉⲩ⳿ⲉ⳿ⲉⲛ ⲛⲟⲩϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲥⲉⲛⲁϭⲟϫⲓ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⲉⲩϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉϩⲁⲛⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲉⲙ ⲁⲛ⳿ϣⲧⲉⲕⲱⲟⲩ ⲉⲩ⳿ⲓⲛⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲛⲓⲟⲩⲣⲱⲟⲩ ⲛⲉⲙ ⲛⲓϩⲏⲅⲉⲙⲱⲛ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ⲉϥ⳿ⲉϣⲱⲡⲓ ⲇⲉ ⲛⲱⲧⲉⲛ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ⲁⲥ ⲩⲛ ϧⲉⲛ ⲛⲉⲧⲉⲛϩⲏⲧ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣϣⲟⲣⲡ ⳿ⲛⲉⲣⲙⲉⲗⲉⲧⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","⳿ⲁⲛⲟⲕ ⲅⲁⲣ ϯⲛⲁϯ ⲛⲱⲧⲉⲛ ⳿ⲛⲟⲩⲣⲟ ⲛⲉⲙ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⲑⲏ ⲉⲧⲉ⳿ⲛⲥⲉⲛⲁϣϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲥ ⲁⲛ ⲟⲩⲇⲉ ⳿ⲛⲥⲉⲛⲁ⳿ϣⲟⲩⲱϩⲉⲙ ⲟⲩⲃⲏⲥ ⲛ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϯ ⲟⲩⲃⲉ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ⲥⲉⲛⲁϯ ⲑⲏⲛⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϩⲁⲛⲓⲟϯ ⲛⲉⲙ ϩⲁⲛ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲙ ϩⲁⲛⲥⲩⲅⲅⲉⲛⲏⲥ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣ ⲟⲩⲟϩ ⲥⲉⲛⲁϧⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛ⳿ⲉϣⲱⲡⲓ ⲉⲩⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ⲟⲩⲟϩ ⲟⲩϥⲱⲓ ⳿ⲛⲧⲉⲧⲉⲛⲁⲫⲉ ⳿ⲛⲛⲉϥⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲧⲉⲧⲉⲛϩⲩⲡⲟⲙⲟⲛⲏ ⲉⲣⲉⲧⲉⲛ⳿ϫⲫⲟ ⳿ⲛⲛⲉⲧⲉⲛⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ϩⲟⲧⲁⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲛⲁⲩ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲉⲣⲉ ϩⲁⲛⲙⲁⲧⲟⲓ ⲱϯ ⳿ⲉⲣⲟⲥ ⲧⲟⲧⲉ ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⲁϥϧⲱⲛⲧ ⳿ⲛϫⲉ ⲡⲉⲥϣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ⲧⲟⲧⲉ ⲛⲏⲉⲧⲭⲏ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲙⲁⲣⲟⲩⲫⲱⲧ ϩⲓϫⲉⲛ ⲛⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⲛⲏ ⲧϧⲉⲛ ⲧⲉⲥⲙⲏϯ ⲙⲁⲣⲟⲩⲫⲱⲧ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲏⲉⲧϧⲉⲛ ⲛⲓⲭⲱⲣⲁ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲟⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ϫⲉ ⲛⲁⲓ ⲛⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡϭⲓ⳿ⲙϣⲓϣ ⲉⲑⲣⲟⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲥϧⲏ ⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ⲟⲩⲟⲓ ⲇⲉ ⳿ⲛⲛⲏⲉⲧ⳿ⲙⲃⲟⲕⲓ ⲛⲉⲙ ⲛⲏⲉⲧϭⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲅⲁⲣ ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲁⲛⲁⲅⲕⲏ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲛⲉⲙ ⲟⲩϫⲱⲛⲧ ⳿ⲙⲡⲁⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϩⲉⲓ ϧⲉⲛ ⲣⲱϥ ⳿ⲛ⳿ⲧⲥⲏϥⲓ ⲟⲩⲟϩ ⲩ⳿ⲉⲉⲣⲉⲭⲙⲁⲗⲱⲧⲉⲩⲓⲛ ⲙⲙⲱⲟⲩ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲉⲩϩⲱⲙⲓ ⳿ⲉϫⲱⲥ ⳿ⲛϫⲉ ϩⲁⲛⲉⲑⲛⲟⲥ ϣⲁⲧⲟⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϩⲁⲛⲥⲏⲟⲩ ⲟⲩⲟϩ ⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛⲥⲏⲟⲩ ⳿ⲛⲧⲉ ϩⲁⲛⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏⲓⲛⲓ ϧⲉⲛ ⳿ⲫⲣⲏ ⲛⲉⲙ ⲡⲓⲓⲟϩ ⲛⲉⲙ ⲛⲓⲥⲓⲟⲩ ⲟⲩⲟϩ ⲟⲩϩⲟϫϩⲉϫ ⳿ⲛⲧⲉ ϩⲁⲛⲉⲑⲛⲟⲥ ⲉϥ⳿ⲉϣⲱⲡⲓ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ϧⲉⲛ ⲟⲩⲁⲡⲟⲣⲓⲁ ⳿ⲛⲧⲉ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙ⳿ⲫⲓⲟⲙ ⲛⲉⲙ ⳿ⲫⲙⲟⲛⲙⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ϩⲁⲛⲣⲱⲙⲓ ⲉⲣⲉ ⲧⲟⲩⲯⲩⲭⲏ ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲧϩⲟϯ ⲛⲉⲙ ⳿ⲡⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱⲟⲩ ⳿ⲛⲛⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉϫⲉⲛ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲛⲓϫⲟⲙ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲥⲉⲛⲁⲕⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ⲩⲟϩ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲉϥⲛⲏⲟⲩ ϧⲉⲛ ⲟⲩϭⲏⲡⲓ ⲛⲉⲙ ⲟⲩϫⲟⲙ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ⲉⲣⲉ ⲛⲁⲓ ⲇⲉ ⲛⲁⲉⲣϩⲏⲧⲥ ⳿ⲛϣⲱⲡⲓ ϫⲟⲩϣⲧ ⳿ⲉ⳿ⲡϣⲱⲓ ⲟⲩⲟϩ ⲧⲱⲟⲩⲛ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲁⲫⲏ ⲟⲩ⳿ⲓ ϫⲉ ⳿ϥϧⲉⲛⲧ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲥⲱϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ⲟⲩⲟϩ ⲁϥϫⲉ ⲟⲩⲡⲁⲣⲁⲃⲟⲗⲏ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲁⲩ ⲉϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲛⲉⲙ ⲛⲓ⳿ϣϣⲏⲛ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ⲉϣⲱⲡ ϩⲏⲇⲏ ⲉⲩⲛⲁϯⲟⲩⲱ ⳿ⲉⲃⲟⲗ ⲉⲣⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ϣⲁⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ϥϧⲱⲛⲧ ⲛϫⲉ ⲡⲓϣⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲛⲁⲩ ⳿ⲉⲛⲁⲓ ⲉⲩⲛⲁϣⲱⲡⲓ ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⲁⲥϧⲱⲛⲧ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲉ ⲧⲁⲓⲅⲉⲛⲉ⳿ⲁ ⲥⲓⲛⲓ ϣⲁⲧⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⲥⲉⲛⲁⲥⲓⲛⲓ ⲛⲁⲥⲁϫⲓ ⲇⲉ ⳿ⲛⲛⲟⲩⲥⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ⲙⲁϩⲑⲏⲧⲉⲛ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⲙⲏⲡⲟⲧⲉ ⳿ⲛⲧⲟⲩ⳿ϩⲣⲟϣ ⳿ⲛϫⲉ ⲛⲉⲧⲉⲛϩⲏⲧ ϧⲉⲛ ϩⲁⲛϭⲓⲙⲉ ⲛⲉⲙ ϩⲁⲛⲑⲓϧⲓ ⲛⲉⲙ ϩⲁⲛⲣⲱⲟⲩϣ ⲙⲃⲓⲱⲧⲓⲕⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲉⲧⲉϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲫⲁϣ ⲉϥ⳿ⲉ⳿ⲓ ⲅⲁⲣ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ⳿ⲡϩⲟ ⳿ⲙ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ⲣⲱⲓⲥ ⲟⲩⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲉⲣⲉⲧⲉⲛⲧⲱⲃϩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲉⲣ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲑⲛⲁϣⲱⲡⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ⲛⲁϥ⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲓ⳿ⲉϫⲱⲣϩ ⲇⲉ ⲛⲁϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⲉϥⲙⲟⲧⲉⲛ ⳿ⲙⲙⲟϥ ϩⲓϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲫⲁ ⲛⲓϫⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ⲟⲩⲟϩ ⲡⲓⲗⲁⲟⲥ ⲏⲣϥ ⲛⲁϥϣⲱⲣⲡ ⳿ⲙⲙⲟϥ ϩⲁⲣⲟϥ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ⲛⲁϥϧⲉⲛⲧ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲁⲧ⳿ϣⲙⲏⲣ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ⲉ ⲡⲓⲡⲁⲥⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ⲟⲩⲟϩ ⲛⲁⲩⲕⲱϯ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ϫⲉ ⲁⲩⲛⲁⲧⲁⲕⲟϥ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⲛⲁⲩⲉⲣϩⲟϯ ⲅⲁⲣ ⲡⲉ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ⲁ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲇⲉ ϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡϩⲏⲧ ⳿ⲛⲓⲟⲩⲇⲁⲥ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏ ⲥ ⳿ⲉⲟⲩ⳿ⲉⲃⲟⲗ ⲡⲉ ϧⲉⲛ ⲡⲓⲓ̅ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ⲟⲩⲟϩ ϥϣⲉ ⲛⲁϥ ⲁϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓⲁⲣⲭ ⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁⲧⲏⲅⲟⲥ ⲉⲑⲃⲉ ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ⲟⲩⲟϩ ⲁⲩⲣⲁϣⲓ ⲟⲩⲟϩ ⲁⲩⲥⲉⲙⲛⲏⲧⲥ ⲛⲉⲙⲁϥ ⲉϯ ⲛⲁϥ ⳿ⲛⲟⲩϩⲁⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ⲟⲩⲟϩ ⲁϥⲉⲣⲉⲝⲟⲙⲟⲗⲟⲅⲓⲛ ⲟⲩⲟϩ ⲛⲁϥⲕⲱϯ ⲡⲉ ⳿ⲛⲥⲁ ⲟⲩⲉⲩⲕⲉⲣⲓⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⲁⲧϭⲛⲉ ⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲁⲧ⳿ϣⲙⲏ ⲣ ⲫⲏⲉⲧⲉ⳿ⲥϣⲉ ⳿ⲉϣⲁⲧ ⲡⲓⲡⲁⲥⲭⲁ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲏ ⲥ ϫⲉ ⲁϣⲉ ⲱⲧⲉⲛ ⲥⲉⲃⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ ⲛⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲁⲕⲟⲩⲱϣ ⳿ⲉⲥⲉⲃⲧⲱⲧϥ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲉⲣⲉⲧⲉⲛⲛⲁϣⲉⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲃⲁⲕⲓ ⳿ϥⲛⲁ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⲉϥϥⲁⲓ ⳿ⲛⲟⲩϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⲙⲟϣⲓ ⳿ⲛⲑⲟϥ ⳿ⲉⲡⲓⲏⲓ ⳿ⲉⲧⲉϥⲛⲁϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ⲟⲩⲟϩ ⳿ⲁϫⲟⲥ ⳿ⲙⲡⲓⲛⲉⲃⲏⲓ ⳿ⲛⲧⲉ ⲡⲓⲏⲓ ϫⲉ ⲡⲉϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲛⲁⲕ ϫⲉ ⲁϣ ⲡⲉ ⲡⲓⲙⲁ ⳿ⲉ ⲛⲁⲟⲩⲱⲙ ⲙⲡⲁⲡⲁⲥⲭⲁ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲛⲁⲙⲁⲑⲏ ⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ⲟⲩⲟϩ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ϥⲛⲁⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲁ ⲉϥⲥⲁ⳿ⲡϣⲱⲓ ⲉϥⲫⲟⲣϣ ⲥⲉⲃⲧⲱⲧϥ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⲇⲉ ⲁⲩϫⲓⲙⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲥⲉⲃⲧⲉ ⲡⲓⲡⲁⲥⲭ ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲟⲩ ⲁϥⲣⲱⲧⲉⲃ ⲛⲉⲙ ⲡⲓⲓ̅ⲃ̅ ⳿ⲛⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϧⲉⲛ ⲟⲩⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⲁⲓⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲟⲩⲱⲙ ⳿ⲙⲡⲁⲡⲁⲥ ⲭⲁ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲙⲡⲁϯϭⲓ⳿ⲙⲕⲁϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲁⲟⲩⲟⲙϥ ϣⲁⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ⲩⲟϩ ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ⲁⲫⲟⲧ ⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲡⲉϫⲁϥ ϫⲉ ⲙⲱⲓⲛⲓ ⳿ⲉⲫⲁⲓ ⲫⲟϣϥ ⳿ⲉ⳿ϩⲣⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲛⲁⲥⲱ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲧⲁⲓⲃⲱ ⳿ⲛⲁⲗⲟⲗⲓ ϣⲁⲧⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ⲟⲩⲟϩ ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩⲱⲓⲕ ϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲁϥⲫⲁϣϥ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⲛⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲁⲥⲱⲙⲁ ⳿ⲉⲧⲟⲩⲛⲁⲧⲏⲓϥ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲫⲁⲓ ⲁⲣⲓⲧϥ ⳿ⲉⲡⲁⲙⲉⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ⲟⲩⲟϩ ⲓ⳿ⲁⲫⲟⲧ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲇⲓⲡⲛⲟⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓ⳿ⲁⲫⲟⲧ ϯⲇⲓ⳿ⲁⲑⲏⲕⲏ ⳿ⲙⲃⲉⲣⲓ ⲧⲉ ϧⲉⲛ ⲡⲁ⳿ⲥⲛⲟϥ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ⲡⲗⲏⲛ ⲓⲥ ⳿ⲧϫⲓϫ ⳿ⲙⲫⲏⲉⲑⲛⲁⲧⲏⲓⲧ ⳿ⲥⲭⲏ ⲛⲉⲙⲏⲓ ϩⲓϫⲉⲛ ϯ⳿ⲧⲣⲁⲡⲉⲍⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ϫⲉ ⳿ⲡϣⲏⲣⲓ ⲙⲉⲛ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ϥⲛⲁϣⲉ ⲛⲁϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲑⲏϣ ⲡⲗⲏⲛ ⲟⲩⲟⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲏⲉⲧⲟⲩⲛⲁⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛϣⲓⲛⲓ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⲛⲓⲙ ⲁⲣⲁ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏ ⲧⲟⲩ ⲉⲑⲛⲁⲉⲣ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲟⲛ ⳿ⲛϫⲉ ⲟⲩⲫⲓⲗⲟⲛⲓⲕⲓ⳿ⲁ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲛⲓⲙ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ⲡⲓⲛⲓϣϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","⳿ⲛⲑⲟϥ ⲉ ⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲟⲩⲣⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲥⲉⲟⲓ ⳿ⲛϭⲟⲓⲥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲛⲏⲉⲧⲉⲣϣⲓϣⲓ ⳿ⲉϫⲱⲟⲩ ⲥⲉⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲓⲣⲉϥⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲁⲛ ⲁⲗⲗⲁ ⲡⲓⲛⲓϣϯ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁⲣⲉϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓϧⲉⲗϣ⳿ⲓⲣⲓ ⲟⲩⲟϩ ⲡⲓϩⲏⲅⲟⲩⲙⲉⲛⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲇⲓ⳿ⲁⲕⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ⲛⲓⲙ ⲅⲁⲣ ⲡⲉ ⲡⲓⲛⲓϣϯ ⲫⲏⲉⲑⲣⲱⲧⲉⲃ ϣⲁⲛ ⲫⲏⲉⲧⲉⲣⲇⲓ⳿ⲁⲕⲱⲛ ⲙⲏ ⲫⲏⲉⲑⲣⲱⲧⲉⲃ ⲁⲛ ⲡⲉ ⳿ⲁⲛⲟⲕ ⲡⲉϯⲭⲏ ϧⲉⲛ ⲉⲧⲉⲛⲙⲏϯ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲫⲏⲉⲧⲉⲣⲇⲓ⳿ⲁⲕⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲛⲏⲉⲧⲁⲩⲟϩⲓ ⲛⲉⲙⲏⲓ ϧⲉⲛ ⲛⲁⲡⲓⲣⲁⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁⲥⲉⲙⲛⲓ ⲉⲙⲱⲧⲉⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲉⲙⲛⲓ ⲛⲉⲙⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⳿ⲛⲟⲩⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲟⲩⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱ ϩⲓ ⲁ⳿ⲧⲣⲁⲡⲉⲍⲁ ⲉⲛ ⲧⲁⲙⲉⲧⲟⲩⲣⲟ ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ϩⲁⲛ⳿ⲑⲣⲟⲛⲟⲥ ⲉⲣⲉⲧⲉⲛ⳿ⲉϯ ϩⲁⲡ ⳿ⲉϯⲓ̅ⲃ̅ ⳿ⲙⲫⲩⲗⲏ ⳿ⲛⲧⲉ ⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ⲥⲓⲙⲱⲛ ⲥⲓⲙⲱⲛ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲥⲁⲧⲁⲛⲁⲥ ⲉϥ⳿ⲉⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉϣⲉⲗϣⲉⲗ ⲑⲏⲛⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓⲥⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","⳿ⲁⲛⲟⲕ ⲇⲉ ⲁⲓⲧⲱⲃϩ ⳿ⲉϫⲱⲕ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲙⲟⲩⲛⲕ ⲛϫⲉ ⲡⲉⲕⲛⲁϩϯ ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⲕⲟⲧⲕ ⳿ⲛⲟⲩⲥⲏⲟⲩ ⲙⲁⲧⲁϫⲣⲉ ⲛⲉⲕ⳿ⲥⲛⲏ ⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ϯ ⲥⲉⲃⲧⲱⲧ ⳿ⲉϣⲉ ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲛⲉⲙⲁⲕ ⲛⲉⲙ ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ⲡⲉⲧⲣⲉ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲙⲫⲟⲟⲩ ⲁⲧⲉⲕϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛⲅ̅ ⳿ⲛⲥⲟⲡ ⲉⲑⲣⲉⲕ⳿ⲉⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲟⲧⲉ ⲉⲧⲁⲓⲟⲩⲉⲣⲡ ⲑⲏⲛⲟⲩ ⲁϭⲛⲉ ⲁⲥⲟⲩⲓ ⲛⲉⲙ ⲡⲏⲣⲁ ⲛⲉⲙ ⲑⲱⲟⲩ⳿ⲓ ⲏ ⲁⲧⲉⲧⲉⲛⲉⲣϧⲁ⳿ⲉ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ⲙⲫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲁⲗⲗⲁ ϯⲛⲟⲩ ⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲛⲟⲩⲁⲥⲟⲩⲓ ⲙⲙⲁⲩ ⲙⲁⲣⲉϥⲟⲗⲥ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲟⲩⲡⲏⲣⲁ ⲟⲩⲟϩ ⲫⲏⲉⲧⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲁϥ ⲙⲁⲣⲉϥϯ ⲡⲉϥ⳿ϩⲃⲟⲥ ⳿ⲉⲃⲟⲗ ⲙⲁⲣⲉϥϣⲉⲡ ⲟⲩⲥⲏϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲱϯ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ϫⲉ ⲁⲩⲟⲡϥ ⲛⲉⲙ ⲛⲓ⳿ⲁⲛⲟⲙⲟⲥ ⲕⲉ ⲅⲁⲣ ⲡⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧ ⲟⲩⲟⲛⲧⲉ ⲉϥϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲡ⳪ ⲓⲥ ⲥⲏϥⲓ ⲃ̅ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉⲣⲱϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ⲉⲃⲟⲗ ⲁϥϣⲉ ⲛⲁϥ ⲕⲁⲧⲁ ϯⲕⲁϩⲥ ⳿ⲉⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ ⲁⲩⲙⲟϣⲓ ⲇⲉ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲡⲓⲙⲁ ⲡⲉϫⲁϥ ⲱⲟⲩ ϫⲉ ⲧⲱⲃϩ ϫⲉ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲟⲩⲱϯ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲩ ⳿ⲫⲟⲩⲱϣ ⳿ⲛϩⲓ ⲟⲩⲱⲛⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲧⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲁϥⲧⲱⲃϩ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲱⲧ ⲓⲥϫⲉ ⳿ⲭⲟⲩⲱϣ ⲙⲁⲣⲉ ⲡⲓ⳿ⲁⲫⲟⲧ ⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲓ ⳿ⲡⲗⲏⲛ ⲡⲉⲧⲉϩⲛⲏⲓ ⲁⲛ ⲁⲗⲗⲁ ⲱⲕ ⲙⲁⲣⲉϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲛϩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲉⲑⲣⲉϥϯϫⲟⲙ ⲛⲁϥ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉϥϭⲓϣϣⲱⲟⲩ ⲉϥⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ϧⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲣⲉ ⲛⲉϥϥⲱϯ ⳿ⲙ⳿ⲫⲣⲏϯ ⲙⲡⲓⲟⲩⲁⲛ ⳿ⲛⲧⲉ ⲡ⳿ⲥⲛⲟϥ ⲉϥϣⲟⲩⲟ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ⲟⲩⲟϩ ϥⲧⲱⲃϩ ϧⲉⲛ ⲟⲩⲙⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲉϥϥⲱϯ ⲁϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡϣⲟⲩⲟ ⲉⲃⲟⲗ ⲙⲡⲓ⳿ⲥⲛⲟϥ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ⲟⲩⲟϩ ⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⲁϥ⳿ⲓ ϩⲁ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁϥϫⲉⲙⲟⲩ ⲉⲩ⳿ⲛⲕⲟⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲉ ⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛ⳿ⲛⲕⲟⲧ ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲣⲓ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲙⲏϣ ⲉⲙ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲓⲟⲩⲇⲁⲥ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲓ̅ⲃ̅ ⲛⲁϥⲙⲟϣⲓ ϧⲁϫⲱⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲁϥϧⲱⲛⲧ ⳿ⲉⲒⲏ̅ⲥ̅ ⲁϥϯⲫⲓ ⳿ⲉⲣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲓⲟⲩⲇⲁⲥ ⲁⲕⲛⲁϯ ⳿ⲙ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ϧⲉⲛ ⲟⲩⲫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲕⲱϯ ⳿ⲉⲣⲟϥ ⳿ⲉⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⲡⲉϫⲱⲟⲩ ⲉ ⳪ ⳿ⲛⲧⲉⲛϩⲓⲟⲩ⳿ⲓ ⳿ⲛ⳿ⲧⲥⲏϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ⲟⲩⲟϩ ⲁ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲥⲁ ⳿ⲫⲃⲱⲕ ⳿ⲙⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲁϥⲉⲗ ⲡⲉϥⲙⲁϣϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲕⲏⲛ ϣⲁ ⳿ⲙⲛⲁⲓ ⲟⲩⲟϩ ⲉⲧⲁϥϭⲟϩ ⳿ⲉⲡⲉϥⲙⲁϣϫ ⲁϥⲧⲁⲗϭⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲛⲛⲏ ⲧⲁⲩ⳿ⲓ ⳿ⲛⲥⲱϥ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁⲧⲏⲅⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ϫⲉ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲣⲉⲧⲉⲛⲛⲏⲟⲩ ⳿ⲛⲥⲁ ⲟⲩⲥⲟⲛⲓ ⲉⲙ ϩⲁⲛ⳿ϣⲃⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ⲉⲓⲭⲏ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲙⲙⲏ ⲓⲛⲓ ⳿ⲙⲡⲉⲧⲉⲛⲥⲟⲩⲧⲉⲛ ⲛⲉⲧⲉⲛϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⲁⲗⲗⲁ ⲑⲁⲓ ⲧⲉ ⲧⲉⲧⲉⲛⲟⲩⲛⲟⲩ ⲉⲙ ⳿ⲡⲉⲣϣⲓϣⲓ ⳿ⲛⲧⲉ ⳿ⲡⲭⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ⲉⲧⲁⲩ⳿ⲁⲙⲟⲛⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ⲁⲩ⳿ⲉⲛϥ ⲟⲩⲟϩ ⲁⲩϭⲓⲧϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲓⲫⲟⲩⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ⲉⲧⲁⲩϭⲉⲣⲉ ⲟⲩ⳿ⲭⲣⲱⲙ ⲇⲉ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛϯⲁⲩⲗⲏ ⲟⲩⲟϩ ⲉⲧⲁⲩϩⲉⲙⲥⲓ ⲛⲁⲣⲉ ⲡⲉⲧⲣⲟⲥ ϩⲱϥ ϩⲉⲙⲥⲓ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ⲧⲁⲥⲛⲁⲩ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲙⲃⲱⲕⲓ ⲉϥϩⲉⲙⲥⲓ ϧⲁⲧⲉⲛ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⲉⲧⲁⲥⲥⲟⲙⲥ ⲡⲉϫⲁⲥ ϫⲉ ⲛⲁⲣⲉ ⲫⲁⲓ ϩⲱϥ ⲭⲏ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ⲛⲑⲟϥ ⲇⲉ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ϯ⳿ⲥϩⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲕⲉⲕⲟⲩϫⲓ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲕⲉⲟⲩⲁⲓ ⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ϩⲱⲕ ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲫⲣⲱⲙⲓ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ⲟⲩⲟϩ ⲉⲧⲁ ⳿ⲫⲟⲩⲱϣ ⳿ⲛⲟⲩⲟⲩⲛⲟⲩ ϣⲱⲡⲓ ⲁⲣⲉ ⲕⲉⲟⲩⲁⲓ ⲧⲁϫⲣⲟ ⳿ⲛⲧⲟⲧϥ ⲡⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲛⲁⲣⲉ ⲫⲁⲓ ϩⲱϥ ⲭⲏ ⲛⲉⲙⲁϥ ⲕⲉ ⲅⲁⲣ ⲟⲩⲅⲁⲗⲓⲗⲉⲟⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ⲡⲉϫⲁϥ ⲉ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ϫⲉ ⳿ⲫⲣⲱⲙⲓ ϯ⳿ⲉⲙⲓ ⲁⲛ ⳿ⲉⲡⲉⲧⲉⲕϫⲱ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ⲁ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ⲟⲩⲟϩ ⲉⲧⲁϥⲫⲟⲛϩϥ ⲛϫⲉ Ⲡ⳪ ⲁϥⲥⲟⲙⲥ ⳿ⲉⲡⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲁ ⲡⲉⲧⲣⲟⲥ ⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲠ⳪ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥϫⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ⳿ⲙⲫⲟⲟⲩ ⲭⲛⲁϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛⲅ̅ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲣⲓⲙⲓ ϧⲉⲛ ⲟⲩ⳿ⲛϣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ⲟⲩⲟϩ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲛⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲛⲁⲩⲥⲱⲃⲓ ⲙⲙⲟϥ ⲡⲉ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ⲟⲩⲟϩ ⲉⲧⲁⲩϩⲟⲃⲥϥ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲣⲓ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⲛⲁⲛ ϫⲉ ⲛⲓⲙ ⲡⲉⲧⲁϥϩⲓⲟⲩ⳿ⲓ ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲙⲏϣ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲣⲟϥ ⲉⲩϫⲉⲟⲩ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ⲟⲩⲟϩ ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲛϥ ⲉϧⲟⲩⲛ ⳿ⲉⲡⲟⲩⲙⲁ⳿ⲛϯϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲁϫⲟⲥ ⲛⲁⲛ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲓϣⲁⲛϫⲟⲥ ⲛⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁⲛⲁϩϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ⲉϣⲱⲡ ⲇⲉ ⲟⲛ ⲁⲓϣⲁⲛϣⲉⲛ ⲑⲏⲛⲟⲩ ⲧⲉⲧⲉⲛⲛⲁⲉⲣⲟⲩⲱ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲉϥϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲛϯϫⲟⲙ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ⲡⲉϫⲱⲟⲩ ⲉ ⲏⲣⲟⲩ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲛ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲉⲣ⳿ⲭⲣⲓⲁ ϫⲉ ⳿ⲛⲟⲩⲙⲉⲑⲣⲉ ⳿ⲁⲛⲟⲛ ⲅⲁⲣ ⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲡⲟⲩⲙⲏϣ ⲧⲏⲣϥ ⲁⲩ⳿ⲉⲛϥ ϩⲁ ⲡⲓⲗⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ⲩⲉⲣϩⲏⲧⲥ ⲇⲉ ⳿ⲛⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲁⲛϫⲉⲙϥ ⲉⲧⲫⲱⲛϩ ⳿ⲙⲡⲉⲛⲉⲑⲛⲟⲥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥⲧⲁϩⲛⲟ ⳿ⲉ⳿ϣⲧⲉⲙϯ ϩⲱϯ ⲙ⳿ⲡⲟⲩⲣⲟ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲡⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲁϥϣⲉⲛϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲛⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲙⲏϣ ϫⲉ ⳿ⲛϯϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲉⲧⲓ⳿ⲁ ⲁⲛ ϧⲉⲛ ⲡⲁⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩϫⲉⲙϫⲟⲙ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⳿ⲉⲁϥⲉⲣϩⲏⲧⲥ ⲥϫⲉⲛ ⲅⲁⲗⲓⲗⲉ⳿ⲁ ϣⲁ ⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲛⲁϥϣⲓⲛⲓ ϫⲉ ⲁⲛ ⲟⲩⲅⲁⲗⲓⲗⲉⲟⲥ ⲡⲉ ⲡⲁⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲉⲙⲓ ϫⲉ ⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲉⲣϣⲓϣⲓ ⳿ⲛⲏⲣⲱⲇⲏⲥ ⲡⲉ ⲁϥⲟⲩⲟⲣⲡϥ ϩⲁ ⲏⲣⲱⲇⲏⲥ ⲉϥⲭⲏ ϩⲱϥ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ⲏⲣⲱⲇⲏⲥ ⲇⲉ ⲧⲁϥⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ⲁϥⲣⲁϣⲓ ⳿ⲉⲙⲁϣⲱ ⲛⲁϥⲟⲩⲱϣ ⲅⲁⲣ ⲡⲉ ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲓⲥϫⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲉⲑⲃⲉϫⲉ ⲛⲁϥⲥⲱⲧⲉⲙ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲧⲟⲧϥ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ⲛⲁϥϣⲓⲛⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ϧⲉⲛ ϩⲁⲛⲙⲏϣ ⳿ⲛⲥⲁϫⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲉⲣⲉⲣⲟⲩⲱ ⳿ⲛ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ⲛⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲉⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⳿ⲉⲙⲁϣⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ⲉⲧⲁϥϣⲟϣϥ ⲇⲉ ⳿ⲛϫⲉ ⲏⲣⲱⲇⲏⲥ ⲛⲉⲙ ⲛⲉϥⲙⲁⲧⲟⲓ ⲟⲩⲟϩ ⲉⲧⲁϥⲥⲱⲃⲓ ⳿ⲙⲙⲟϥ ⲁϥϫⲟⲗϩϥ ⳿ⲛⲟⲩϩⲉⲃⲥⲱ ⲉⲥⲫⲉⲣⲓⲱⲟⲩ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲉⲡⲓⲗⲁⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ⲁⲩⲉⲣ⳿ϣⲫⲏⲣ ⲇⲉ ⳿ⲉⲛⲟⲩⲉⲣⲏⲟⲩ ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲉⲙ ⲏⲣⲱⲇⲏⲥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁⲩϣⲟⲡ ⲅⲁⲣ ⳿ⲛϣⲟⲣⲡ ⲡⲉ ϧⲉⲛ ⲟⲩⲙⲉⲧϫⲁϫⲓ ⳿ⲉⲛⲟⲩⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲧⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲱⲛ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲧⲉⲧⲉⲛ⳿ⲓⲛⲓ ⲛⲏⲓ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ϩⲱⲥ ⲉϥⲫⲱⲛϩ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲉⲃⲟⲗ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ⲉⲧⲁⲓϣⲉⲛϥ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⳿ⲙⲡⲓϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲉⲧⲓ⳿ⲁ ϧⲉⲛ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲛⲛⲏⲉⲧⲉⲧⲉⲛⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ⲁⲗⲗⲁ ⲟⲩⲇⲉ ⳿ⲡⲕⲉⲏⲣⲱⲇⲏⲥ ⲁϥⲟⲩⲟⲣⲡϥ ⲅⲁⲣ ϩⲁⲣⲟⲛ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛϩⲱⲃ ⳿ⲛϧⲏⲧϥ ⳿ⲉⲁϥⲁⲓϥ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","⳿ⲛⲧⲁϯ⳿ⲥⲃⲱ ⲟⲩⲛ ⲛⲁϥ ⳿ⲛⲧⲁⲭⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ⲛⲉ ⲟⲩⲟⲛⲧⲟⲩ ⲕⲁϩⲥ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲉⲑⲣⲉϥⲭⲱ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲛⲏⲉⲧⲥⲟⲛϩ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲧⲁ ⳿ⲡϣⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ⲁ ⲡⲓⲙⲏϣ ⲇⲉ ⲧⲏⲣϥ ⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁⲗⲓ ⲫⲁⲓ ⲭⲁ ⲃⲁⲣⲁⲃⲃⲁⲥ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ⲫⲁⲓ ⲉⲧⲁⲩϩⲓⲧϥ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲉⲑⲃⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲛⲉⲙ ⲟⲩϧⲱⲧⲉⲃ ⳿ⲉⲁϥϣⲱⲡⲓ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ⲡⲁⲗⲓⲛ ⲇⲉ ⲟⲛ ⲁ ⲡⲓⲗⲁⲧⲟⲥ ⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲉϥⲟⲩⲱϣ ⳿ⲉⲭⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϣϥ ⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲙ⳿ⲫⲙⲁϩⲅ̅ ⳿ⲛⲥⲟⲡ ϫⲉ ⲟⲩ ⲅⲁⲣ ⲙⲡⲉⲧϩⲱⲟⲩ ⲡⲉⲧⲁ ⲫⲁⲓ ⲁⲓϥ ⳿ⲙⲡⲓϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲉⲧⲓ⳿ⲁ ⳿ⲛⲧⲉ ⳿ⲫⲙⲟⲩ ⳿ⲛϧⲏⲧϥ ⳿ⲛⲧⲁϯ⳿ⲥⲃⲱ ⲟⲩⲛ ⲛⲁϥ ⳿ⲛⲧⲁⲭⲁϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲩⲟⲩⲁϩⲧⲟⲧⲟⲩ ϧⲉⲛ ϩⲁⲛⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲉⲩⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⲉⲑⲣⲟⲩⲁϣϥ ⲟⲩⲟϩ ⲛⲁⲩϫⲉⲙϫⲟⲙ ⲡⲉ ⳿ⲛϫⲉ ⲛⲟⲩ⳿ⲥⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ⲟⲩⲟϩ ⲁ ⲡⲓⲗⲁⲧⲟⲥ ϩⲁⲡ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲡⲟⲩⲉⲧⲏⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ⲁϥⲭⲱ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲙⲫⲏⲉⲧⲁⲩϩⲓⲧϥ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲉⲑⲃⲉ ⲟⲩϧⲱⲧⲉⲃ ⲛⲉⲙ ⳿ϣⲑⲟⲣⲧⲉⲣ ⲫⲏ ⲧⲁⲩⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲧⲏⲓϥ ⲕⲁⲧⲁ ⲡⲟⲩⲟⲩⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ⲟⲩⲟϩ ϩⲱⲥ ⲉⲩ⳿ⲓⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲟⲩⲁⲓ ϫⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲕⲩⲣⲓⲛⲉⲟⲥ ϥⲛⲏ ⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲕⲟⲓ ⲁⲩⲧⲁⲗⲉ ⲡⲓ⳿ⲥⲧⲁⲩⲣⲟⲥ ⳿ⲉⲣⲟϥ ⲉⲑⲣⲉϥⲧⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ⲛⲁϥⲙⲟϣⲓ ⲇⲉ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ ⲛⲏ⳿ⲉⲛⲁⲩⲧⲱⲓⲧ ⲟⲩⲟϩ ⲛⲁⲩⲛⲉϩⲡⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","⳿ⲉⲧⲁϥⲫⲟⲛϥ ⲇⲉ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲛⲓϣⲉⲣⲓ ⳿ⲛⲧⲉ ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲙⲡⲉⲣⲣⲓⲙⲓ ⳿ⲉϫⲱⲓ ⳿ⲡⲗⲏⲛ ⲣⲓⲙⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲉⲙ ⳿ⲉϫⲉⲛ ⲛⲉⲧⲉⲛϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ϫⲉ ϩⲏⲡⲡⲉ ⲥⲉⲛⲏⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲛⲏ ⲧⲟⲩⲛⲁϫⲟⲥ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲓⲁⲧϭ ⲣⲏⲛ ⲛⲉⲙ ⲛⲓⲛⲉϫⲓ ⲉⲧⲉ⳿ⲙⲡⲟⲩⲙⲓⲥⲓ ⲛⲉⲙ ⲛⲓⲉⲙⲛⲟϯ ⲉⲧⲉ⳿ⲙⲡⲟⲩϣⲁⲛϣ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ⲧⲟⲧⲉ ⲉⲛⲁⲉⲣϩⲏⲧⲥ ⳿ⲛϫⲟⲥ ⳿ⲛⲛⲓⲧⲱⲟⲩ ϫⲉ ϩⲉⲓ ⳿ⲉϫⲱⲛ ⲛⲉⲙ ⲛⲓⲕⲁⲗⲁⲙⲫⲟ ϫⲉ ϩⲟⲃⲥⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ϫⲉ ⲓⲥϫⲉ ⲥⲉ⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⲡⲓϣⲉ ⲉⲧⲗⲏ ⲕ ⲓⲉ ⲟⲩ ⲉⲑⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⲡⲉⲧϣⲟⲩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ⲛⲁⲩ⳿ⲓⲛⲓ ⲇⲉ ⳿ⲛⲕⲉⲣⲉϥⲉⲣⲡⲉⲧϩⲱⲟⲩ ⲃ̅ ⲛⲉⲙⲁϥ ⳿ⲉϧⲟⲑⲃⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ⲟⲩⲟϩ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲁ ⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓ⳿ⲕⲣⲁⲛⲓⲟⲛ ⲁⲩⲁϣϥ ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ⲛⲓⲕⲁⲕⲟⲩⲣⲅⲟⲥ ⲟⲩⲁⲓ ⲙⲉⲛ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⲟⲩⲁⲓ ⲇⲉ ⲥⲁϫⲁϭⲏ ⲁⲩⲫⲱϣ ⲇⲉ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⳿ⲉ⳿ϩⲣⲁⲩ ⲁⲩϩⲓⲱⲡ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ⲓ̅ⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ⲭⲱ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ⳿ⲉⲛⲏ⳿ⲉⲧⲟⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ⲟⲩⲟϩ ⲛⲁϥⲟϩⲓ ⲉⲣⲁⲧϥ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲉϥⲛⲁⲩ ⲛⲁⲩⲉⲗⲕϣⲁⲓ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲁⲣⲭ ⲱⲛ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥⲛⲟϩⲉⲙ ⳿ⲛϩⲁⲛⲕⲉⲭ ⲱⲟⲩⲛⲓ ⲙⲁⲣⲉϥⲛⲁϩⲙⲉϥ ⲱϥ ⲥϫⲉ ⲫⲁⲓ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲡⲓⲥⲱⲧⲡ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ⲛⲁⲩⲥⲱⲃⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓⲕⲉⲙⲁⲧⲟⲓ ⲉⲩⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲟⲩϩⲉⲙϫ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲁϩⲙⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ⲛⲉ ⲟⲩⲟⲛ ⲕⲉⲉⲡⲓ⳿ⲅⲣⲁⲫⲏ ⲇⲉ ⲡⲉ ϩⲓϫⲱϥ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⲙⲙⲉⲧⲣⲱⲙⲉⲟⲥ ⳿ⲙⲙⲉⲧⲟⲩⲉⲓⲛⲓⲛ ϫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲕⲁⲕⲟⲩⲣⲅⲟⲥ ⲉⲧⲁⲩⲁϣⲟⲩ ⲛⲉⲙⲁϥ ⲉⲟⲩ⳿ⲁ ⲉⲣⲟϥ ⲡⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⳿ⲛⲑⲟⲕ ⲁⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲛⲁϩⲙⲉⲕ ⲟⲩⲟϩ ⲛⲁϩⲙⲉⲛ ϩⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲁϥⲉⲣⲉⲡⲓⲧⲓⲙⲁⲛ ⲛⲁϥ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩⲇⲉ ⲫϯ ⳿ⲛⲑⲟⲕ ⳿ⲕⲉⲣϩⲟϯ ⲁⲛ ϧⲁⲧⲉϥϩⲏ ϫⲉ ⲁⲛⲭⲏ ϧⲉⲛ ⲡⲁⲓϩⲁⲡ ⳿ⲛⲟⲩⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⲙⲉⲛ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲉⲧⲁⲛϭⲓ ⲕⲁⲧⲁ ⳿ⲡⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲛⲏⲉⲧⲁⲛⲁⲓⲧⲟⲩ ⲫⲁⲓ ⲇⲉ ⳿ⲙⲡⲉϥⲉⲣ ⳿ϩⲗⲓ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲁⲣⲓⲡⲁⲙⲉⲩⲓ ϩⲟⲧⲁⲛ ⲕϣⲁⲛ⳿ⲓ ϧⲉⲛ ⲧⲉⲕⲙⲉⲧⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲙⲫⲟⲟⲩ ⲉⲕ⳿ⲉϣⲱⲡⲓ ⲛⲉⲙⲏⲓ ϧⲉⲛ ⲡⲓⲡⲁⲣⲁⲇⲓⲥⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ⲩⲟϩ ⲛⲉ ⳿ⲫⲛⲁⲩ ϩⲏⲇⲏ ⳿ⲛⲁϫⲡ ⲋ̅ ⲡⲉ ⲟⲩⲟϩ ⲁ ⲟⲩⲭⲁⲕⲓ ϣⲱⲡⲓ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ ϣⲁ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲑ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ⲉϥⲛⲁⲙⲟⲩⲛⲕ ⲇⲉ ⳿ⲛϫⲉ ⲓⲣⲏ ⲓⲕⲁⲧⲁⲡⲉⲧⲁⲥⲙⲁ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲫⲱϧ ϧⲉⲛ ⲧⲉϥⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ⲟⲩⲟϩ ⲉⲧⲁϥⲙⲟⲩϯ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ϯϯ ⳿ⲙⲡⲁⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲛⲉⲕϫⲓϫ ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲁϥϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭ ⲟⲥ ⳿ⲉⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⲁϥϯⲱⲟⲩ ⳿ⲙⲫϯ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲛⲧⲱⲥ ⲛⲉ ⲡⲁⲓⲣⲱⲙⲓ ⲟⲩ⳿ⲑⲙⲏ ⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ⲟⲩⲟϩ ⲛⲓⲙⲏϣ ⲧⲏⲣⲟⲩ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϫⲉⲛ ⲧⲁⲓⲑⲉⲱⲣⲓ⳿ⲁ ⲉⲧⲁⲩⲛⲁⲩ ⲉⲛⲏⲉⲧⲁⲩϣⲱⲡⲓ ⲁⲩⲧⲁⲥⲑⲟ ⲉⲩⲕⲱⲗϩ ϧⲉⲛ ⲧⲟⲩⲙⲉⲥⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ⲛⲁⲩⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧⲟⲩ ϩⲓ⳿ⲫⲟⲩⲉⲓ ⲡⲉ ⳿ⲛϫⲉ ⲛⲉϥⲣⲉⲙ⳿ⲛⲥⲱⲟⲩⲛ ⲧⲏⲣⲟⲩ ⲉⲙ ϩⲁⲛⲕⲉϩⲓ⳿ⲟⲙⲓ ⲛⲏⲉⲧⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲓⲥϫⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲉⲩⲛⲁⲩ ⳿ⲉⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲓⲱⲥⲏⲫ ⲉⲟⲩⲃⲟⲩⲗⲉⲩⲧⲏⲥ ⲡⲉ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲛⲁⲅⲁⲑⲟⲥ ⲡⲉ ⲟⲩⲟϩ ⳿ⲛ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ⲫⲁⲓ ⲛⲁϥϯⲙⲁϯ ⲁⲛ ⲡⲉ ϧⲉⲛ ⲡⲟⲩⲥⲟϭ ⲛⲓ ⲛⲉⲙ ⲧⲟⲩ⳿ⲡⲣⲁⲝⲓⲥ ⲛⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲉⲛ ⲁⲣⲓⲙⲁⲑⲉⲁⲥ ⲡⲉ ⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲫⲏ ⲉⲛⲁϥϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲉⲛ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ⲫⲁⲓ ⲉⲧⲁϥ⳿ⲓ ϩⲁ ⲡⲓⲗⲁⲧⲟⲥ ϥⲉⲣⲉⲧⲓⲛ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲉⲛϥ ⲉⲡⲉⲥⲏⲧ ⲁϥⲕⲟⲩⲗⲱⲗϥ ϧⲉⲛ ⲟⲩϣⲉⲛⲧⲱ ⲟⲩⲟϩ ⲁϥⲭⲁϥ ϧⲉⲛ ⲟⲩ⳿ⲙϩⲁⲩ ⳿ⲉⲁϥϣⲟⲕϥ ⲙⲡⲁⲧⲟⲩⲭⲁ ⳿ϩⲗⲓ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁϥ⳿ⲥⲕⲉⲣⲕⲉⲣ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲱⲛⲓ ϩⲓⲣⲉⲛ ⳿ⲫⲣⲟ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ⲟⲩⲟϩ ⲛⲉ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⲡⲉ ⳿ⲙⲡⲁⲣⲁⲥⲕⲉⲩⲏ ⲟⲩⲟϩ ⲛⲉⲁ ϣⲱⲣⲡ ϣⲱⲡⲓ ⳿ⲙ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ⲉⲧⲁⲩⲙⲟϣⲓ ⲇⲉ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲛⲓϩⲓ⳿ⲟⲙⲓ ⲛⲏⲉⲧⲁⲩ⳿ⲓ ⲛⲉⲙⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲁⲩⲛⲁⲩ ⲉⲡⲓⲉⲙϩⲁⲩ ⲛⲉⲙ ⲡⲓⲣⲏϯ ⲉⲧⲁⲩⲭⲁ ⲡⲉϥⲥⲱⲙⲁ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ⲉⲧⲁⲩⲧⲁⲥⲑⲟ ⲇⲉ ⲁⲩⲥⲉⲃⲧⲉ ϩⲁⲛ⳿ⲥⲑⲟⲓ ⲛⲉⲙ ϩⲁⲛⲥⲟϫⲉⲛ ⲟⲩⲟϩ ⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲉⲛ ⲁⲩⲉⲣⲏⲥⲩⲭⲁⲍⲓⲛ ⲕⲁⲧⲁ ϯⲉⲛⲧⲟⲗⲏ ");
INSERT INTO copcnt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ϧⲉⲛ ⳿ⲫⲟⲩⲁⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲛϣⲱⲣⲡ ⳿ⲉⲙⲁϣⲱ ⲁⲩ⳿ⲓ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲉⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲓ⳿ⲥⲑⲟⲓ ⳿ⲉⲧⲁⲩⲥⲉⲃⲧⲱⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ⲁⲩϫⲓⲙⲓ ⲇⲉ ⳿ⲙⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲁⲩ⳿ⲥⲕⲉⲣⲕⲱⲣϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","⳿ⲉⲧⲁⲩϣⲉ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲙⲡⲟⲩϫⲉⲙ ⳿ⲡⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲡ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲩⲉⲣⲁⲡⲟⲣⲓⲥⲑⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ϩⲏⲡⲡⲉ ⲓⲥ ⲣⲱⲙⲓ ⲃ̅ ⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ϩⲁⲛϩⲉⲃⲥⲱ ⲉⲩϩⲓⲥⲉⲧⲉⲃⲣⲏϫ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ⲉⲧⲁⲩϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲟⲩϩⲟϯ ⲟⲩⲟϩ ⲉⲩⲣⲓⲕⲓ ⳿ⲙⲡⲟⲩϩⲟ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⲡⲉϫⲱⲟⲩ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲡⲉⲧⲟⲛϧ ⲛⲉⲙ ⲓⲣⲉϥⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","⳿ⲛ⳿ϥⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲁⲛ ⲁⲗⲗⲁ ⲁϥⲧⲱⲛϥ ⲁⲣⲓ⳿ⲫⲙⲉⲩⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⲉⲧⲓ ⲉϥϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ϥϫⲱ ⲙⲙⲟⲥ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲟⲩϯ ⳿ⲙ⳿ⲡϣⲏ ⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲁϣϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ ϧⲉⲛ ⲡⲓⲙⲁϩⲅ̅ ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ⲟⲩⲟϩ ⲁⲩⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲛⲉϥⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ⲟⲩⲟϩ ⲉⲧⲁⲩⲧⲁⲥⲑⲟ ⳿ⲉⲃⲟⲗ ϩⲁ ⲡⲓ⳿ⲙϩⲁⲩ ⲁⲩⲧⲁⲙⲉ ⲡⲓⲓ̅ⲁ̅ ⳿ⲉⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲓⲥⲱϫⲡ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ⲛⲉ ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ⲧⲉ ϯⲙⲁⲅⲇⲁⲗⲓⲛⲏ ⲛⲉⲙ ⲓⲱⲁⲛⲛⲁ ⲛⲉⲙ ⲙⲁⲣⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⳿ⲡⲥⲱϫⲡ ⲉⲑⲛⲉⲙⲱⲟⲩ ⲛⲏ ⳿ⲉⲛⲁⲩϫⲱ ⳿ⲛⲛⲁⲓ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲛϩ ⳿ⲛϫⲉ ⲛⲁⲓⲥⲁϫⲓ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲉⲃϣⲓ ⲟⲩⲟϩ ⲛⲁⲩⲧⲉⲛϩⲟⲧⲟⲩ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ⲉⲧⲣⲟⲥ ⲇⲉ ⲁϥⲧⲱⲛϥ ⲁϥϭⲟϫⲓ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉϧⲟⲩⲛ ⲁϥⲛⲁⲩ ⳿ⲉⲛⲓ⳿ϩⲃⲱⲥ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲡⲉϥⲏⲓ ⲉϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⲙⲫⲏⲉⲧⲁϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲃ̅ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲛⲁⲩⲙⲟϣⲓ ⲡⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲩⲛⲁ ⳿ⲉⲟⲩϯⲙⲓ ⲉⲥⲟⲩⲏⲟⲩ ⳿ⲛ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲁⲩ ⲝ̅ ⳿ⲛ⳿ⲥⲧⲁⲇⲓⲟⲛ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲉⲙⲙⲁⲟⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏ ⲟⲩ ⲉⲑⲃⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲧⲁϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ⲟⲩⲟϩ ⲥϣⲱⲡⲓ ⲉⲩⲥⲁϫⲓ ⲟⲩⲟϩ ⲉⲩⲕⲱϯ ⳿ⲛⲑⲟϥ ϩⲱϥ Ⲓⲏ̅ⲥ̅ ⲁϥϧⲱⲛⲧ ⳿ⲉⲣⲱⲟⲩ ⲁϥⲙⲟϣⲓ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ⲛⲁⲩ⳿ⲁⲙⲟⲛⲓ ⲇⲉ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲟⲩⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲛⲁⲓⲥⲁϫⲓ ⲟⲩ ⲛⲉ ⲉⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲉⲣⲉⲧⲉⲛⲙⲟϣⲓ ⲟⲩⲟϩ ⲁⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲉⲩⲟⲕⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲕⲗⲉⲟⲡⲁⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲉⲧϣⲟⲡ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲕ⳿ⲉⲙⲓ ⳿ⲉⲛⲏ ⲧⲁⲩϣⲱⲡⲓ ⳿ⲛϧⲏⲧⲥ ϧⲉⲛ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲛⲉ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲛⲏⲉⲧⲁⲩϣⲱⲡⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ⲓⲣⲉⲙⲛⲁⲍⲁⲣⲉⲑ ⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲙ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⳿ⲡϩⲱⲃ ⲛⲉⲙ ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ϩⲱⲥⲇⲉ ⲁⲩⲧⲏⲓϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲱⲛ ⲉⲩϩⲁⲡ ⳿ⲛⲧⲉ ⳿ⲫⲙⲟⲩ ⲟⲩⲟϩ ⲁⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","⳿ⲁⲛⲟⲛ ⲇⲉ ⲁⲛⲉⲣϩⲉⲗⲡⲓⲥ ϫⲉ ⲁⲓ ⲡⲉⲑⲛⲁⲥⲱϯ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲁⲗⲗⲁ ⲛⲉⲙ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲧⲉϥⲙⲁϩⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲡⲉ ⲫⲁⲓ ⲓⲥϫⲉⲛ ⲉⲧⲁ ⲛⲁⲓ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ⲁⲗⲗⲁ ⲛⲉⲙ ϩⲁⲛⲕⲉϩⲓ⳿ⲟⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲉⲛ ⲁⲩ⳿ⲑⲣⲉⲛⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲛϣⲱⲣⲡ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ⲟⲩⲟϩ ⲉⲧⲉ⳿ⲙⲡⲟⲩϫⲉⲙ ⲡⲉϥⲥⲱⲙⲁ ⲁⲩ⳿ⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛⲛⲁⲩ ⲉⲟⲩⲟⲩⲱⲛϩ ⳿ⲛⲧⲉ ϩⲁⲛⲁⲅⲅⲉⲗⲟⲥ ⲛⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ϥⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ⲟⲩⲟϩ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲉⲛ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲩϫⲓⲙⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲛⲓⲕⲉϩⲓ⳿ⲟⲙⲓ ϫⲟⲥ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲱ ⲛⲓⲁⲛⲟⲏⲧⲟⲥ ⲟⲩⲟϩ ⲉⲧⲟⲥⲕ ⲉⲛ ⲟⲩϩⲏⲧ ⳿ⲉⲛⲁϩϯ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ⲙⲏ ⲛⲁⲥⲭⲏ ⲁⲛ ⲉⲑⲣⲉ Ⲡⲭ̅ⲥ̅ ϭⲓ ⳿ⲛⲛⲁⲓ⳿ⲙⲕⲁⲩϩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϣⲉ ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ⲟⲩⲟϩ ⲉⲧⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ ⲛⲁϥⲉⲣⲙⲏ ⲛⲉⲩⲓⲛ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⲛⲉ ⲛⲏ ⲧϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ⲧⲏⲣⲟⲩ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ⲟⲩⲟϩ ⲁⲩϧⲱⲛⲧ ⳿ⲉⲡⲓϯⲙⲓ ⲉⲛⲁⲩⲛⲁϣⲉ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉϥⲛⲁⲟⲩⲉⲓ ⲉϥⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲟⲛⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟϩⲓ ⲛⲉⲙⲁⲛ ϫⲉ ⲣⲟⲩϩⲓ ⲟⲩⲟϩ ϩⲏⲇⲏ ⲁϥⲣⲓⲕⲓ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲉ ⲛⲧⲉϥⲟϩⲓ ⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲧⲁϥⲣⲱⲧⲉⲃ ⲛⲉⲙⲱⲟⲩ ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓⲱⲓⲕ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲉⲧⲁϥⲫⲁϣϥ ⲛⲁϥϯ ⲛⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲁ ⲛⲟⲩⲃⲁⲗ ⲟⲩⲱⲛ ⲟⲩⲟϩ ⲁⲩⲥⲟⲩⲱⲛϥ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲁϥⲉⲣⲁⲑⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗϩⲁⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲙⲏ ⲛⲁⲣⲉ ⲡⲉⲛϩⲏⲧ ⲣⲟⲕϩ ⲁⲛ ⲡⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ϩⲱⲥ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲁⲛ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲉϥⲟⲩⲱⲛϩ ⳿ⲉⲛⲓ⳿ⲅⲣⲁⲫⲏ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ⲩⲟϩ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩⲧⲁⲥⲑⲟ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲁⲩϫⲓⲙⲓ ⳿ⲙⲡⲓⲓ̅ⲁ̅ ⲉⲩⲑⲟⲩⲏⲧ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ⲉⲩϫⲱ ⲙⲙⲟⲥ ϫⲉ ⲟⲛⲧⲱⲥ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ Ⲡ⳪ ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲥⲓⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲛⲁⲩⲥⲁϫⲓ ⳿ⲛⲛⲏⲉⲧϧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⲛⲉⲙ ⳿ⲙ⳿ⲫⲣⲏϯ ⲧⲁϥⲟⲩⲱⲛϩ ⳿ⲉ⳿ⲣⲱⲟⲩ ϧⲉⲛ ⲡⲓⲫⲱϣ ⳿ⲛⲧⲉ ⲡⲓⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ⲛⲁⲓ ⲇⲉ ⲉⲩⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲑⲟϥ Ⲓⲏ̅ⲥ̅ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϯϩⲓⲣⲏⲛⲏ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ⲉⲧⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲇⲉ ⲟⲩⲟϩ ⲉⲧⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⲟⲩϩⲟϯ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ⲟⲩⲡ͞ⲛⲁ̅ ⲡⲉ ⲉⲧⲟⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲣⲑⲱⲣ ⲟⲩⲟϩ ⲉⲑⲃⲉⲟⲩ ⲥⲉⲛⲏⲟⲩ ⳿ⲛϫⲉ ϩⲁⲛⲙⲉⲩⲓ ⳿ⲉϫⲉⲛ ⲛⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","⳿ⲁⲛⲁⲩ ⲉⲛⲁϫⲓϫ ⲛⲉⲙ ⲛⲁϭⲁⲗⲁⲩϫ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ϫⲟⲙϫⲉⲙ ⳿ⲉⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲡ͞ⲛⲁ̅ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⲥⲁⲣⲝ ϩⲓ ⲕⲁⲥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⲉⲣⲟⲓ ⳿ⲉⲟⲩⲟⲛ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲁϥⲧⲁⲙⲱⲟⲩ ⳿ⲉⲛⲉϥϫⲓϫ ⲛⲉⲙ ⲛⲉϥϭⲁⲗⲁⲩϫ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ⲉⲧⲓ ⲇⲉ ⲉⲩⲟⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲣⲁϣⲓ ⲟⲩⲟϩ ⲉⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲟⲛⲧⲉⲧⲉⲛ ⳿ⲛⲭⲁⲓ ⳿ⲛⲟⲩⲱⲙ ⳿ⲙⲡⲁⲓⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϯ ⲛⲁϥ ⳿ⲛⲟⲩⲙⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲩⲧⲉⲃⲧ ⲉϥϫⲉϥϫⲱϥ ⲛⲉⲙ ⲟⲩⲙⲟⲩⲗϩ ⳿ⲛ⳿ⲉⲃⲓⲱ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ⲟⲩⲟϩ ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ ⲁϥⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲛⲁⲓ ⲛⲉ ⲁⲥⲁϫⲓ ⲉⲧⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲉⲧⲓ ⲉⲓⲭⲏ ⲛⲉⲙⲱⲧⲉⲛ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲟⲩϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ⲛⲓⲯⲁⲗⲙⲟⲥ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ⲧⲟⲧⲉ ⲁϥⲟⲩⲱⲛ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲉⲑⲣⲟⲩⲕⲁϯ ⳿ⲉⲛⲓ⳿ⲅⲣⲁⲫⲏ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ϫⲉ ⲥ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲑⲣⲉ Ⲡⲭ̅ⲥ̅ ϣⲉⲡ⳿ⲙⲕⲁϩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ϧⲉⲛ ⲡⲓⲙⲁϩⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ⲟⲩⲟϩ ⲛⲧⲟⲩϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ϧⲉⲛ ⲡⲉϥⲣⲁⲛ ⳿ⲉ⳿ⲡⲭⲁ ⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲉⲁⲧⲉⲧⲉⲛⲉⲣϩⲏⲧⲥ ⲓⲥϫⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲣⲙⲉⲑⲣⲉ ϧⲁ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲟⲩⲱⲣⲡ ⳿ⲙⲡⲓⲱϣ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ϩⲉⲙⲥⲓ ϧⲉⲛ ϯⲃⲁⲕⲓ ϣⲁⲧⲉⲧⲉⲛϭⲓ ⲛⲟⲩϫⲟⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡϭⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ⲟⲩⲟϩ ⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϣⲁ ⲃⲏⲑⲁⲛⲓ⳿ⲁ ⲟⲩⲟϩ ⲉⲧⲁϥϥⲁⲓ ⳿ⲛⲛⲉϥϫⲓϫ ⳿ⲉ⳿ⲡϣⲱⲓ ⲁϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϧⲉⲛ ⳿ⲡϫⲓⲛⲧⲉϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲁϥⲟⲩⲱϯ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲱⲗⲓ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲧⲁⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ⲟⲩⲟϩ ⲛⲁⲩⲭⲏ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ");
INSERT INTO copcnt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ϧⲉⲛ ⳿ⲧⲁⲣⲭⲏ ⲛⲉ ⲡⲓⲥⲁϫⲓ ⲡⲉ ⲟⲩⲟϩ ⲡⲓⲥⲁϫⲓ ⲛⲁϥⲭⲏ ϧⲁⲧⲉⲛ ⲫϯ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲛⲟⲩϯ ⲡⲉ ⲡⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ⲫⲁⲓ ⳿ⲉⲛⲁϥⲭⲏ ⲓⲥϫⲉⲛ ϩⲏ ϧⲁⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲩϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⲁⲧϭⲛⲟⲩϥ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ϣⲱⲡⲓ ϧⲉⲛ ⲫⲏⲉⲧⲁϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ⲛⲉ ⳿ⲡⲱⲛϧ ⲡⲉⲧⲉ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⳿ⲡⲱⲛϧ ⲛⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ⲟⲩⲟϩ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲁϥⲉⲣⲟⲩⲱⲓⲛⲓ ϧⲉⲛ ⲡⲓⲭⲁⲕⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⲡⲓⲭⲁⲕⲓ ⲧⲁϩⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁⲩⲟⲩⲟⲣⲡϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ⲫⲁⲓ ⲁϥ⳿ⲓ ⲉⲩⲙⲉⲧⲙⲉⲑⲣⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣⲙⲉⲑⲣⲉ ϧⲁ ⲡⲓⲟⲩⲱⲓⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲛⲁϩϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ⲛⲉ ⳿ⲛⲑⲟϥ ⲁⲛ ⲡⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣⲙⲉⲑⲣⲉ ϧⲁ ⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ⲛⲁϥϣⲟⲡ ⳿ⲛϫⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲁ⳿ⲫⲙⲏⲓ ⲫⲏⲉⲧⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲉⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ⲛⲁϥⲭⲏ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲡⲉ ⲟⲩⲟϩ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁϥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲥⲟⲩⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ⲁϥ⳿ⲓ ϩⲁ ⲛⲏⲉⲧⲉⲛⲟⲩϥ ⲟⲩⲟϩ ⲛⲉⲧⲉⲛⲟⲩϥ ⳿ⲙⲡⲟⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ⲛⲏ ⲇⲉ ⲉⲧⲁⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ⲁϥϯⲉⲣϣⲓϣⲓ ⲛⲱⲟⲩ ⳿ⲉⲉⲣϣⲏⲣⲓ ⳿ⲛⲛⲟⲩϯ ⲛⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ⲛⲏ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲥⲛⲟϥ ⲁⲛ ⲛⲉ ⲟⲩⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲟⲩⲱϣ ⳿ⲛⲥⲁⲣⲝ ⲁⲛ ⲛⲉ ⲟⲩⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲟⲩⲱϣ ⳿ⲛⲣⲱⲙⲓ ⲁⲛ ⲛⲉ ⲁⲗⲗⲁ ⲉⲧⲁⲩⲙⲁⲥⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ⲟⲩⲟϩ ⲡⲓⲥⲁϫⲓ ⲁϥⲉⲣⲟⲩⲥⲁⲣⲝ ⲟⲩⲟϩ ⲁϥϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ⲟⲩⲟϩ ⲁⲛⲛⲁⲩ ⳿ⲉⲡⲉϥⲱⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡⲱⲟⲩ ⳿ⲛⲟⲩϣⲏⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲉϥⲙⲉϩ ⳿ⲛ⳿ϩⲙⲟⲧ ⲛⲉⲙ ⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ⲓⲱⲁⲛⲛⲏⲥ ⳿ϥⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟϩ ⳿ϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲫⲏⲉⲧⲁⲓϫⲟϥ ⲉⲑⲃⲏⲧϥ ϫⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ⲙⲉⲛⲉⲛⲥⲱⲓ ⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ϫⲉ ⲛⲉ ⲟⲩϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ⲣⲱ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ϫⲉ ⳿ⲁⲛⲟⲛ ⲧⲏⲣⲉⲛ ⲁⲛϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉϥⲙⲟϩ ⲛⲉⲙ ⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲛ⳿ⲧϣⲉⲃⲓⲱ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ϫⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲁⲩⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲙⲱ⳿ⲩⲥⲏⲥ ⲡⲓ⳿ϩⲙⲟⲧ ⲇⲉ ⲛⲉⲙ ϯⲙⲉⲑⲙⲏⲓ ⲁⲩϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ⲫϯ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲉⲛⲉϩ ⲡⲓⲙⲟⲛⲟⲅⲉⲛⲏ ⲥ ⳿ⲛⲛⲟⲩϯ ⲫⲏⲉⲧⲭⲏ ϧⲉⲛ ⲕⲉⲛϥ ⳿ⲙⲡⲉϥⲓⲱⲧ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ⲟⲩⲟϩ ⲑⲁⲓ ⲧⲉ ϯⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ϩⲟⲧⲉ ⲉⲧⲁⲩⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛϩⲁⲛⲟⲩⲏⲃ ⲛⲉⲙ ϩⲁⲛⲗⲉⲩⲓⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲉⲛϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲛϩ ⳿ⲙⲡⲉϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲛϩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲏⲗⲓⲁⲥ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲁϥⲉⲣⲟⲩⲱ ϫⲉ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⲟⲩⲛ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⳿ⲛⲛⲏⲉⲧⲁⲩⲧⲁⲟⲩⲟⲛ ⲟⲩ ⲡⲉⲧⲉⲕϫⲱ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲏⲧⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ϯ⳿ⲥⲙⲏ ⲉⲧⲱϣ ⳿ⲉⲃⲟⲗ ϩⲓ ⳿ⲡϣⲁϥⲉ ϫⲉ ⲥⲟⲩⲧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ Ⲡ⳪ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥϫⲟⲥ ⳿ⲛϫⲉ ⳿ⲏⲥⲁ⳿ⲓⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ⲟⲩⲟϩ ⲛⲉ ⲁⲩⲟⲩⲱⲣⲡ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲕϯⲱⲙⲥ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲁⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲟⲩⲇⲉ ⳿ⲏⲗⲓⲁⲥ ⲟⲩⲇⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲱⲙⲥ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲉⲧⲉⲛⲙⲏϯ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ⲫⲏⲉⲑⲛⲏⲟⲩ ⲙⲉⲛⲉⲛⲥⲱⲓ ⲫⲏⲉⲧⲉ⳿ⲛϯ ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲁϯⲟⲩⲱ ⳿ⲛⲟⲩⲙⲟⲩⲥⲉⲣ ⳿ⲛⲧⲉ ⲡⲉϥⲑⲱⲟⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ⲛⲁⲓ ⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⲃⲏⲑⲁⲛⲓ⳿ⲁ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲓⲟⲣⲇⲁⲛⲏⲥ ⲡⲓⲙⲁ ⲉⲛⲁⲣⲉ ⲓⲱⲁⲛⲛⲏⲥ ϯⲱⲙⲥ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ⲉϥⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲓⲥ ⲡⲓϩⲓⲏⲃ ⳿ⲛⲧⲉ ⲫϯ ⲫⲏⲉⲑⲛⲁⲱⲗⲓ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧⲁⲓϫⲟⲥ ⳿ⲁⲛⲟⲕ ⲉⲑⲃⲏⲧⲕ ϫⲉ ⳿ϥⲛⲏⲟⲩ ⲙⲉⲛⲉⲛⲥⲱⲓ ⳿ⲛϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ϫⲉ ⲟⲩϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ⲣⲱ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲛⲁⲓⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓⲥ̅ⲗ̅ ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓ⳿ⲓ ⳿ⲉϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ⲟⲩⲟϩ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓⲛⲁⲩ ⳿ⲉⲡⲓⲡ͞ⲛⲁ̅ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ϧⲣⲏ ⲓ ⳿ⲉϫⲱϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϭⲣⲟⲙⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲁϥⲟϩⲓ ϩⲓϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲛⲁⲓⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ⲉϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥϫⲟⲥ ⲛⲏⲓ ϫⲉ ⲫⲏⲉⲧⲉⲕⲛⲁⲩ ⲉⲡⲓⲡ͞ⲛⲁ̅ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲟϩⲓ ϩⲓϫⲱϥ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲑⲛⲁϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲁⲓⲛⲁⲩ ⲟⲩⲟϩ ⲁⲓⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲟⲛ ⲛⲁⲣⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲛⲉⲙ ⲃ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ⲟⲩⲟϩ ⲉⲧⲁϥϫⲟⲩϣⲧ ⳿ⲉⲒⲏ̅ⲥ̅ ⲉϥⲙⲟϣⲓ ⲡⲉϫⲁϥ ϫⲉ ⲓⲥ ⲡⲓϩⲏⲓⲃ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ⲟⲩⲟϩ ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉϥⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲃ̅ ⳿ⲛⲧⲁϥ ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⲛⲥⲁ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ⲉⲧⲁϥⲫⲟⲛϩϥ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲫⲏⲉⲧⲉ ϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲁⲕϣⲟⲡ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ ⲁⲩ⳿ⲓ ⲟⲩⲛ ⲟⲩⲟϩ ⲁⲩⲛⲁⲩ ϫⲉ ⲁϥϣⲟⲡ ⲑⲱⲛ ⲟⲩⲟϩ ⲁⲩϣⲱⲡⲓ ϧⲁⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉ ⳿ⲫⲛⲁⲩ ⲇⲉ ⳿ⲛⲁϫⲡ ⲓ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ⲁⲛⲇⲣⲉⲁⲥ ⲇⲉ ⳿ⲡⲥⲟⲛ ⳿ⲛⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲉ ⲟⲩⲁⲓ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲃ̅ ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ⲫⲁⲓ ⲇⲉ ⲁϥϫⲓⲙⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲡⲉϥⲥⲟⲛ ⲥⲓⲙⲱⲛ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁⲛϫⲓⲙⲓ ⳿ⲙⲙⲉⲥⲓⲁⲥ ⲫⲏⲉⲧⲉ ⲡⲉϥⲟⲩⲱϩⲉⲙ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ⲫⲁⲓ ⲁϥ⳿ⲉⲛϥ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲉⲧⲁϥϫⲟⲩϣⲧ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲥⲓⲙⲱⲛ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲓⲱⲁⲛⲛⲏⲥ ⳿ⲛⲑⲟⲕ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲟⲕ ϫⲉ ⲕⲏⲫⲁ ⲫⲏ ⳿ⲉϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ ⲡⲉⲧⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥⲟⲩⲱϣ ⳿ⲉ⳿ⲓ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲁϥϫⲓⲙⲓ ⳿ⲙⲫⲓⲗⲓⲡⲡⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ⲫⲓⲗⲓⲡⲡⲟⲥ ⲇⲉ ⲛⲉ ⲟⲩⲣⲉⲙⲃⲏⲑⲥⲁⲓⲇⲁ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲑⲃⲁⲕⲓ ⳿ⲛⲁⲛⲇⲣⲉⲁⲥ ⲛⲉⲙ ⲡⲉⲧⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ⲫⲓⲗⲓⲡⲡⲟⲥ ⲇⲉ ⲁϥϫⲓⲙⲓ ⳿ⲛⲛⲁⲑⲁⲛⲁⲏⲗ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲫⲏⲉⲧⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲥϧⲁⲓ ⲉⲑⲃⲏⲧϥ ϩⲓ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲁⲛϫⲉⲙϥ ⲉⲧⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲓⲱⲥⲏⲫ ⲡⲓ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁⲍⲁⲣⲉⲑ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲛⲁⲑⲁⲛⲁⲏⲗ ⲛⲁϥ ϫⲉ ⲁⲛ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩ⳿ⲁⲅⲁⲑⲟⲛ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁⲍⲁⲣⲉⲑ ⲡⲉϫⲉ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲁⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲁⲑⲁⲛⲁⲏⲗ ⲉϥⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲉⲑⲃⲏⲧϥ ϫⲉ ⲓⲥ ϩⲏⲡⲡⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⲓⲥ ⲟⲩ⳿ⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⳿ⲙⲙⲟⲛ ⲇⲟⲗⲟⲥ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ⲡⲉϫⲉ ⲛⲁⲑⲁⲛⲁⲏⲗ ⲛⲁϥ ϫⲉ ⲁⲕⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⲑⲱⲛ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲙⲟⲩϯ ⳿ⲉⲣⲟⲕ ⲉⲕⲭⲏ ϧⲁⲧⲟⲧⲥ ⳿ⲛϯⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⲁⲓⲛⲁⲩ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲁⲑⲁⲛⲁⲏⲗ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲁⲓ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲁⲕ ϫⲉ ⲁⲓⲛⲁⲩ ⳿ⲉⲣⲟⲕ ϧⲁⲣⲁⲧⲥ ⳿ⲛϯ ⲃⲱ ⳿ⲛⲕⲉⲛⲧⲉ ⳿ⲭⲛⲁϩϯ ϩⲁⲛⲛⲓϣϯ ⳿ⲉⲛⲁⲓ ⲉⲕ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲛⲁⲩ ⳿ⲉ⳿ⲧⲫⲉ ⲉⲥⲟⲩⲏ ⲛ ⲟⲩⲟϩ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲫϯ ⲉⲩⲛⲁ ⳿ⲉ⳿ⲡϣⲱⲓ ⲟⲩⲟϩ ⲉⲩⲛⲏⲟⲩ ⲉⲡⲉⲥⲏⲧ ⳿ⲛⲥⲁ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ⲟⲩⲟϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲁϩⲅ̅ ⲟⲩϩⲟⲡ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧⲕⲁⲛⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁⲣⲉ ⳿ⲑⲙⲁⲩ ⳿ⲛⲒⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ⲁⲩⲑⲁϩⲉⲙ ⳿ⲡⲕⲉⲒⲏ̅ⲥ̅ ⲇⲉ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⳿ⲉⲡⲓϩⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ⲟⲩⲟϩ ⲉⲧⲁϥⲙⲟⲩⲛⲕ ⳿ⲛϫⲉ ⲡⲓⲏⲣⲡ ⲡⲉϫⲉ ⳿ⲑⲙⲁⲩ ⳿ⲛⲒⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲏⲣⲡ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ⲁϧⲟ ⲛⲉⲙⲏⲓ ϩⲱⲓ ϯ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲁⲧⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲁⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ⲡⲉϫⲉ ⲧⲉϥⲙⲁⲩ ⲇⲉ ⳿ⲛⲛⲓⲇⲓ⳿ⲁⲕⲱⲛ ϫⲉ ⲫⲏⲉⲧⲉϥⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲁⲣⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ⲛⲁⲩⲭⲏ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲡⲉ ⳿ⲛϫⲉ ⳿ⲛϩⲩⲇⲣⲓ⳿ⲁ ⳿ⲛⲱⲛⲓ ⲕⲁⲧⲁ ⳿ⲡⲧⲟⲩⲃⲟ ⳿ⲛⲛⲓⲟⲩⲇⲁⲓ ⲉⲩⲱⲗⲓ ⳿ⲙⲙⲉⲧⲣⲓⲧⲏⲥ ⲃ̅ ⲓⲉ ⲅ̅ ⳿ⲉⲑⲟⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲙⲟϩ ⳿ⲛⲛⲓϩⲩⲇⲣⲓ⳿ⲁ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲙⲁϩⲟⲩ ϣⲁ⳿ⲡϣⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲱⲧϩ ϯⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲁⲣⲭⲏ⳿ⲧⲣⲓⲕⲗⲓⲛⲟⲥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩ⳿ⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ϩⲱⲥ ⲇⲉ ⲉⲧⲁϥϫⲉⲙϯⲡⲓ ⳿ⲙⲡⲓⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲧⲣⲓⲕⲗⲓⲛⲟⲥ ⳿ⲉⲁϥⲉⲣ ⳿ⲏⲣⲡ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ ⲛⲓⲇⲓ⳿ⲁⲕⲱⲛ ⲇⲉ ⲛⲁⲩ⳿ⲉⲙⲓ ⲛⲏⲉⲧⲁⲩⲙⲁϩ ⲡⲓⲙⲱⲟⲩ ⲁ ⲡⲓⲁⲣⲭⲏ ⳿ⲧⲣⲓⲕⲗⲓⲛⲟⲥ ⲇⲉ ⲙⲟⲩϯ ⳿ⲉⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⳿ⲉϣⲁⲩ ⲭⲱ ⳿ⲙⲡⲓⲏⲣⲡ ⲉⲑⲛⲁⲛⲉϥ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⲁⲩϣⲁⲛⲑⲓϧⲓ ϣⲁⲩ⳿ⲓⲛⲓ ⳿ⲙⲡⲉⲧ⳿ⲥⲃⲟⲕ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲁⲕ⳿ⲁⲣⲉϩ ⳿ⲉⲡⲓⲏⲣⲡ ⲉⲑⲛⲁⲛⲉϥ ϣⲁ ϯⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ⲫⲁⲓ ⲡⲉ ⲡⲓϩⲟⲩⲓⲧ ⳿ⲙⲙⲏⲓⲛⲓ ⲉⲧⲁϥⲁⲓϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⳿ⲧⲕⲁⲛⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲛϩ ⳿ⲙⲡⲉϥ⳿ⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁⲩⲛⲁϩϯ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ⲙⲉⲛⲉⲛⲥⲁ ⲫⲁⲓ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⳿ⲛⲑⲟϥ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲟϩⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ⲟⲩⲟϩ ⲛⲁϥϧⲉⲛⲧ ⲡⲉ ⳿ⲛϫⲉ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ⲟⲩⲟϩ ⲁϥϫⲓⲙⲓ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲛⲏⲉⲧϯ ⳿ⲉϩⲉ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⳿ⲉⲥⲱⲟⲩ ⲛⲉⲙ ϭⲣⲟⲙⲡⲓ ⲛⲉⲙ ⲛⲓϥⲁⲓⲕⲉⲣⲙⲁ ⲉⲩϩⲉⲙⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ⲟⲩⲟϩ ⲁϥⲑⲁⲙⲓⲟ ⳿ⲛⲟⲩ⳿ⲫⲣⲁⲅⲉⲗⲗⲓⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲛⲟϩ ⲁϥϩⲓⲧⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲛⲉⲙ ⲛⲓ⳿ⲉϩⲱⲟⲩ ⲟⲩⲟϩ ⲛⲓⲕⲉⲣⲙⲁ ⳿ⲛⲧⲉ ⲛⲓϥⲁⲓⲕⲉⲣⲙⲁ ⲁϥⲫⲟⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲟⲩ⳿ⲧⲣⲁⲡⲉⲍⲁ ⲁϥⲫⲟⲛϫⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⳿ⲛⲛⲏⲉⲧϯ ϭⲣⲟⲙⲡⲓ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲁⲓ ⳿ⲉⲃⲟⲗ ⲧⲁⲓ ⳿ⲙⲡⲉⲣⲉⲣ ⳿ⲡⲏⲓ ⳿ⲙⲡⲁⲓⲱⲧ ⳿ⲛⲟⲩⲏⲓ ⳿ⲛϣⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ⲁⲩⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⳿ⲡⲭⲟϩ ⳿ⲙⲡⲉⲕⲏⲓ ⳿ϥⲛⲁⲟⲩⲟⲙⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ⲁⲩⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲟⲩ ⳿ⲙⲙⲏⲓⲛⲓ ⲉⲧⲉⲕⲛⲁⲧⲁⲙⲟⲛ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲕ⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲃⲉⲗ ⲡⲁⲓⲉⲣⲫⲉⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ϯⲛⲁⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ⲡⲉϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⲁⲩⲉⲣ ⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲉⲩⲕⲱⲧ ⳿ⲙⲡⲁⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ⳿ⲭ ⲛⲁⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ⲉⲑⲃⲉ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ ⲡⲉϥⲥⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲁⲩⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ϫⲉ ⲫⲁⲓ ⳿ⲉⲛⲁϥϫⲱ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲩⲛⲁϩϯ ⳿ⲉϯ⳿ⲅⲣⲁⲫⲏ ⲛⲉⲙ ⲡⲓⲥⲁϫⲓ ⲉⲧⲁϥϫⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ⲉϥⲭⲏ ⲇⲉ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ϧⲉⲛ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ ⲟⲩⲙⲏϣ ⲁⲩⲛⲁϩϯ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲉⲩⲛⲁⲩ ⳿ⲉⲛⲓⲙⲏⲓⲛⲓ ⳿ⲉⲛⲁϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","⳿ⲛⲑⲟϥ ⲇⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥⲧⲉⲛϩⲟⲩⲧ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲱⲟⲩ ⲁⲛ ⲡⲉ ⲉⲑⲃⲉϫⲉ ⲛⲁϥⲥⲱⲟⲩⲛ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ⲟⲩⲟϩ ⲛⲁϥⲉⲣ⳿ⲭⲣⲓⲁ ⲁⲛ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲉⲣⲙⲉⲑⲣⲉ ⲛⲁϥ ϧⲁ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲑⲟϥ ⲅⲁⲣ ⲛⲁϥⲥⲱⲟⲩⲛ ϫⲉ ⲟⲩ ⲡⲉⲧϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲛⲓⲕⲟⲇⲏⲙⲟⲥ ⲟⲩⲁⲣ ⲭⲱⲛ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ⲫⲁⲓ ⲁϥ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛ⳿ⲉϫⲱⲣϩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲉⲧⲁⲕ⳿Ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⳿ⲛⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⲅⲁⲣ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲉⲉⲣ ⲛⲁⲓⲙⲏⲓⲛⲓ ⲉⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲫϯ ϣⲱⲡⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲁⲩ⳿ϣⲧⲉⲙⲙⲉⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲕⲉⲥⲟⲡ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲁⲩ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ⲡⲉϫⲉ ⲛⲓⲕⲟⲇⲏⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲟⲩⲙⲉⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲕⲉⲥⲟⲡ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲉϥⲉⲣϧⲉⲗⲗⲟ ⲙⲏ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⲉⲑⲣⲉϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲑⲛⲉϫⲓ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ ⳿ⲙ⳿ⲫⲙⲁϩ ⲥⲟⲡ ⲃ̅ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲙⲁⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲁⲩ⳿ϣⲧⲉⲙⲙⲉⲥ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⲛⲉⲙ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯ ⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ⲡⲓⲙⲓⲥⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲥⲁⲣⲝ ⲟⲩⲥⲁⲣⲝ ⲡⲉ ⲡⲓⲙⲓⲥⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲩⲡ͞ⲛⲁ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","⳿ⲙⲡⲉⲣⲉⲣ⳿ϣⲫⲏⲣⲓ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲁⲕ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲟⲩⲙⲉⲥ ⲑⲏⲛⲟⲩ ⳿ⲛⲕⲉⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ⲡⲓⲡ͞ⲛⲁ̅ ⳿ϥⲛⲓϥⲓ ⳿ⲉ⳿ⲫⲙⲁ ⲉⲧⲉϩⲛⲁϥ ⲟⲩⲟϩ ⳿ⲕⲥⲱⲧⲉⲙ ⳿ⲉⲧⲉϥ⳿ⲥⲙⲏ ⲁⲗⲗⲁ ⳿ⲕ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁϥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲟⲩⲟϩ ⲉϥⲛⲁ ⳿ⲉⲑⲱⲛ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲟⲩⲙⲓⲥⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲓⲕⲟⲇⲏⲙⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲛⲁⲓ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲥⲁϧ ⳿ⲙ⳿ⲡⲓⲥ̅ⲗ̅ ⲟⲩⲟϩ ⲛⲁⲓ ⳿ⲕ⳿ⲉⲙⲓ ⳿ⲉⲣⲱⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲫⲏⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲧⲉⲛⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲫⲏⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲧⲉⲛⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲧⲉⲛⲙⲉⲧⲙⲉⲑⲣⲉ ⲧⲉⲧⲉⲛϭⲓ ⳿ⲙⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ⲓⲥϫⲉ ⲁⲓϫⲉ ⲛⲁ ⳿ⲡⲕⲁϩⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⲡⲱⲥ ⲁⲓϣⲁⲛϫⲉ ⲛⲁ ⳿ⲧⲫⲉ ⲛⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ϣⲉ ⲛⲁϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⳿ⲉⲃⲏⲗ ⲉⲫⲏⲉⲧⲁϥ⳿ⲓ ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲉⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲡⲉ ⲫⲏⲉⲧϣⲟⲡ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ⲟⲩⲟϩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ϭⲉⲥ ⲡⲓϩⲟϥ ⳿ⲛ⳿ϩⲣⲏⲓ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲡⲁⲓⲣⲏϯ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲟⲩϭⲉⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ϩⲓⲛⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉϥϭⲓ ⳿ⲙⲡⲓⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ⲡⲁⲓⲣⲏϯ ⲅⲁⲣ ⲁ ⲫϯ ⲙⲉⲛⲣⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲱⲥⲧⲉ ⲡⲉϥϣⲏⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲛⲧⲉϥⲧⲏⲓϥ ϩⲓⲛⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲧⲁⲕⲟ ⲁⲗⲗⲁ ⳿ⲛⲧⲉϥϭⲓ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ⲛⲉⲧⲁ ⲫϯ ⲅⲁⲣ ⲁⲛ ⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉϥϣⲏ ⲣⲓ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϯϩⲁⲡ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲥⲉⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⲁⲛ ⲫⲏ ⲇⲉ ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲁⲛ ϩⲏⲇⲏ ⲁⲩⲟⲩⲱ ⲉⲩϯϩⲁⲡ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲙⲡⲉϥⲛⲁϩϯ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲓⲙⲟⲛⲟⲅⲉⲛⲏⲥ ⳿ⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ⲫⲁⲓ ⲡⲉ ⲡⲓϩⲁⲡ ϫⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲁϥ⳿Ⲓ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ⲛⲓⲣⲱⲙⲓ ⲁⲩⲙⲉⲛⲣⲉ ⲡⲓⲭⲁⲕⲓ ⲙⲁⲗⲗⲟⲛ ⳿ⲉϩⲟⲧⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ ⲛⲟⲩϩⲃⲏⲟⲩ⳿ⲓ ⲅⲁⲣ ⲛⲁⲩϩⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ϥⲙⲟⲥϯ ⳿ⲙⲡⲓⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲁϥ⳿ⲓ ϩⲁ ⲡⲓⲟⲩⲱⲓⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲥⲟϩⲓ ⳿ⲛⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿Ⲓ ϫⲉ ⲥⲉϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ⲫⲏ ⲇⲉ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ϣⲁϥ⳿ⲓ ϩⲁ ⲡⲓⲟⲩⲱⲓⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ ϫⲉ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ϧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲧⲉ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁϥⲭⲏ ⳿ⲙⲙⲁⲩ ⲛⲉⲙⲱⲟⲩ ⲡⲉ ⲉϥϯⲱⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ⲛⲁⲣⲉ ⳿ⲡⲕⲉⲓⲱⲁⲛⲛⲏⲥ ⲇⲉ ϯⲱⲙⲥ ⲡⲉ ϧⲉⲛ ⳿ⲉⲛⲱⲛ ϧⲁⲧⲉⲛ ⲥⲁⲗⲓⲙ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩϭⲓⲱⲙⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ⲛⲉ ⳿ⲙⲡⲁⲧⲟⲩϩⲓⲟⲩ⳿ⲓ ⲇⲉ ⳿ⲛⲓⲱⲁⲛⲛⲏⲥ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ⲁⲥϣⲱⲡⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲟⲩⲍⲏⲧⲏⲥⲓⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲑⲃⲉ ⲟⲩⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁ ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲫⲏⲉⲧⲭⲏ ⲛⲉⲙⲁⲕ ϩⲓⲙⲏⲣ ⳿ⲙⲡⲓⲓⲟⲣⲇⲁⲛⲏⲥ ⲫⲏ ⳿ⲛⲑⲟⲕ ⲉⲧⲉⲕⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟϥ ϩⲏⲡⲡⲉ ⲓⲥ ⲫⲁⲓ ⳿ϥϯⲱⲙⲥ ⲟⲩⲟϩ ⲥⲉⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩⲣⲱⲙⲓ ϭⲓ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲩ⳿ϣⲧⲉⲙⲧⲏ ⲓⲥ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲉⲣⲙⲉⲑⲣⲉ ⲛⲏⲓ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲁⲗⲗⲁ ϫⲉ ⲉⲧⲁⲩⲧⲁⲟⲩⲟⲓ ϧⲁϫⲱϥ ⳿ⲙⲫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ⲫⲏⲉⲧⲉ ϯϣⲉⲗⲉⲧ ⳿ⲛⲧⲟⲧϥ ⳿ⲛⲑⲟϥ ⲡⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⳿ⲡ⳿ϣⲫⲏⲣ ⲇⲉ ⳿ⲙⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲡⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲡⲉ ⲟⲩⲟϩ ⲉϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ ⳿ϥⲣⲁϣⲓ ⲉⲑⲃⲉ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲧϣⲉⲗⲉⲧ ⲫⲁⲓ ⲟⲩⲛ ⲡⲉ ⲡⲁⲣⲁϣⲓ ⳿ⲁⲛⲟⲕ ⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ϩⲱϯ ⲟⲩⲛ ⳿ⲛⲧⲉ ⲫⲏ ⲁⲓⲁⲓ ⳿ⲁⲛⲟⲕ ⲇⲉ ⲛⲧⲁⲑⲉⲃⲓ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ⲫⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ϥⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲡⲓ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲡⲉ ⲟⲩⲟϩ ϣⲁϥⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲫⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ϥⲥⲁ⳿ⲡϣⲱⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ⲫⲏⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲉⲧⲁϥⲥⲟⲑⲙⲉϥ ⲫⲁⲓ ⲉⲧⲉϥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲧⲉϥⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϭⲓ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ⲫⲏⲉⲑⲛⲁϭⲓ ⳿ⲛⲧⲉϥⲙⲉⲧⲙⲉⲑⲣⲉ ⲫⲁⲓ ⲁϥⲉⲣ⳿ⲥⲫⲣⲁⲅⲓⲍⲓⲛ ϫⲉ ⲫϯ ⲟⲩ⳿ⲑⲙⲏⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ⲫⲏ ⲅⲁⲣ ⲉⲧⲁ ⲫϯ ⲟⲩⲟⲣⲡϥ ⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲉϥⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲣⲉ ⲫϯ ⲅⲁⲣ ⲁⲛ ϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ϧⲉⲛ ⲟⲩϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","⳿ⲫⲓⲱⲧ ⲙⲉⲓ ⳿ⲙ⳿ⲡϣⲏⲣⲓ ⲟⲩⲟϩ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲛⲉϥϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲡⲓϣⲏⲣⲓ ⲟⲩⲟⲛⲧⲉϥ ⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⳿ⲙⲙⲁⲩ ⲫⲏ ⲇⲉ ⲉⲧⲟⲓ ⳿ⲛⲁⲧⲑⲱⲧ ⳿ⲛϩⲏⲧ ⳿ⲉⲡⲓϣⲏⲣⲓ ⳿ⲛⲛⲉϥⲛⲁⲩ ⳿ⲉ⳿ⲡⲱⲛϧ ⲁⲗⲗⲁ ⳿ⲡ⳿ϫⲱⲛⲧ ⳿ⲙⲫϯ ⲉϥ⳿ⲉϣⲱⲡⲓ ϩⲓϫⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲁ Ⲓⲏ̅ⲥ̅ ⲑⲁⲙⲓⲉ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ ⲟⲩⲟϩ ⳿ϥϯⲱⲙⲥ ⳿ⲉϩⲟⲧⲉ ⲓⲱⲁⲛⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ⲕⲉⲧⲟⲓ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲑⲟϥ ⲁⲛ ⳿ⲉⲛⲁϥϯⲱⲙⲥ ⲁⲗⲗⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ⲁϥⲭⲱ ⳿ⲛϯⲓⲟⲩⲇⲉ⳿ⲁ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⲟⲛ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ⲛⲉ ϩⲱϯ ⲇⲉ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲉⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲧⲥⲁⲙⲁⲣⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⳿ⲧⲥⲁⲙⲁⲣⲓ⳿ⲁ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲥⲩⲭⲁⲣ ⲉⲥϧⲉⲛⲧ ⳿ⲉⲡⲓⲓⲟϩⲓ ⲉⲧⲁ ⲓⲁⲕⲱⲃ ⲧⲏⲓϥ ⳿ⲛⲓⲱⲥⲏⲫ ⲡⲉϥϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ⲛⲁⲥⲭⲏ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲟⲩⲙⲟⲩⲙⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲧⲉ ⲓⲁⲕⲱⲃ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲉⲧⲁϥϧⲓⲥⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲙⲙⲟϣⲓ ⲁϥϩⲉⲙⲥⲓ ⲡⲁⲓⲣⲏϯ ϩⲓϫⲉⲛ ϯⲙⲟⲩⲙⲓ ⲛⲉ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ⲁⲥ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲥⲁⲙⲁⲣⲓⲁ ⳿ⲉⲙⲁϩ ⲙⲱⲟⲩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⲙⲟⲓ ⲛⲏⲓ ⳿ⲛⲧⲁⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲛⲉ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉ ϯⲃⲁⲕⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡ ⳿ⲛϩⲁⲛ⳿ϧⲣⲏⲟⲩⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ⲡⲉϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ⳿ⲛⲥⲁⲙⲁⲣⲓⲧⲏⲥ ϫⲉ ⲡⲱⲥ ⳿ⲛⲑⲟⲕ ⲟⲩⲓⲟⲩⲇⲁⲓ ⳿ⲕⲉⲣⲉⲧⲓⲛ ⳿ⲛⲧⲟⲧ ⳿ⲉⲥⲱ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲥⲁⲙⲁⲣⲓⲧⲏⲥ ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲁⲣⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲙⲟⲩϫⲧ ⲛⲉⲙ ⲛⲓⲥⲁⲙⲁⲣⲓⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⳿ⲉⲛⲁⲣⲉ⳿ⲉⲙⲓ ⳿ⲉϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ϫⲉ ⲛⲓⲙ ⲡⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲉ ϫⲉ ⲙⲟⲓ ⲛⲏⲓ ⳿ⲛⲧⲁⲥⲱ ⳿ⲛⲑⲟ ⲛⲁⲣⲉⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ ⲛⲉ ⳿ⲛⲟⲩⲙⲱⲟⲩ ⲉϥⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ⲡⲉϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⲁⲛ⳿ⲧⲗⲏⲙⲁ ⳿ⲛⲧⲟⲧⲕ ⲟⲩⲟϩ ϯϣⲱϯ ϣⲏⲕ ⲉϥ⳿ⲉ⳿ⲛⲧⲟⲧⲕ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⳿ⲛϫⲉ ⲡⲓⲙⲱⲟⲩ ⲉⲧⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ⲙⲏ ⳿ⲛⲑⲟⲕ ⲟⲩⲛⲓϣϯ ⳿ⲛⲑⲟⲕ ⳿ⲉⲡⲉⲛⲓⲱⲧ ⲓⲁⲕⲱⲃ ⲫⲏⲉⲧⲁϥϯ ⲛⲁⲛ ⳿ⲛⲧⲁⲓϣⲱϯ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲁϥⲥⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⲛⲉⲙ ⲛⲉϥϣⲏⲣⲓ ⲛⲉⲙ ⲛⲉϥϣⲁⲛϣ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲥⲱ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲱⲟⲩ ⲫⲏ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁⲧⲏⲓϥ ⲛⲁϥ ⳿ⲛⲛⲉϥ⳿ⲓⲃⲓ ϣⲁ ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ⲁⲗⲗⲁ ⲡⲓⲙⲱⲟⲩ ⳿ⲉϯⲛⲁⲧⲏⲓϥ ⲛⲁϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⳿ⲛⲟⲩⲙⲟⲩⲙⲓ ⳿ⲙⲙⲱⲟⲩ ⲉϥ⳿ⲉϭⲓⲫⲉⲓ ⲉⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ⲡⲉϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⲙⲟⲓ ⲛⲏⲓ ⳿ⲙⲡⲁⲓⲙⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙ⳿ⲓⲃⲓ ϫⲉ ⲟⲩⲇⲉ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙ⳿ⲓ ⳿ⲉ⳿ⲙⲛⲁⲓ ⳿ⲉⲙⲁϩ ⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⲙⲁϣⲉ ⲛⲉ ⲙⲟⲩϯ ⳿ⲉⲡⲉϩⲁⲓ ⲟⲩⲟϩ ⲁⲙⲏ ⳿ⲉ⳿ⲙⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ⲁⲥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲡⲉϫⲁⲥ ϫⲉ ⳿ⲙⲙⲟⲛϯ ϩⲁⲓ ⳿ⲙⲙⲁⲩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⲕⲁⲗⲱⲥ ⲁⲣⲉϫⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛϯ ϩⲁⲓ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ⲉ̅ ⲅⲁⲣ ⳿ⲛϩⲁⲓ ⲁⲣⲉϭⲓⲧⲟⲩ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲉⲙⲉ ϯⲛⲟⲩ ⲡⲉϩⲁⲓ ⲁⲛ ⲡⲉ ⲫⲁⲓ ⲟⲩⲙⲏⲓ ⲡⲉ ⲉⲧⲁⲣⲉϫⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ⲡⲉϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ϯⲛⲁⲩ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ⲛⲉⲛⲓⲟϯ ⲁⲩⲟⲩⲱϣⲧ ϩⲓϫⲉⲛ ⲡⲁⲓⲧⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲣⲉ ⲡⲓⲙⲁ⳿ⲛⲟⲩⲱϣⲧ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲡⲓⲙⲁ ⲉⲧⲉ⳿ⲥϣⲉ ⳿ⲛⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲧⲉⲛϩⲟⲩⲧ ϫⲉ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ϩⲟⲧⲉ ⲟⲩⲇⲉ ϩⲓϫⲉⲛ ⲡⲁⲓⲧⲱⲟⲩ ⲟⲩⲇⲉ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲉⲩⲛⲁⲟⲩⲱϣⲧ ⳿ⲙ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲟⲩⲱϣⲧ ⳿ⲙⲫⲏⲉⲧⲉⲧⲉ⳿ⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲁⲛⲟⲛ ⲇⲉ ⲧⲉⲛⲟⲩⲱϣⲧ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲡⲓⲟⲩϫⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ⲁⲗⲗⲁ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ⲉⲧⲉ ϯⲛⲟⲩ ⲧⲉ ϩⲟⲧⲉ ⲛⲓⲣⲉϥⲟⲩⲱϣⲧ ⳿ⲛⲧⲁ⳿ⲫⲙⲏⲓ ⲉⲩⲛⲁⲟⲩⲱϣⲧ ⳿ⲙ⳿ⲫⲓⲱⲧ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲛⲉⲙ ⲟⲩⲙⲉⲑⲙⲏ ⲓ ⲕⲉ ⲅⲁⲣ ⳿ⲫⲓⲱⲧ ⲁϥⲕⲱϯ ⳿ⲛⲥⲁ ⲛⲁⲓ ⲟⲩⲟⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲛⲏⲉⲑⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ⲟⲩⲡ͞ⲛⲁ̅ ⲡⲉ ⲫϯ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲁⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲟⲩⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲛⲉⲙ ⲟⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ⲡⲉϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ϫⲉ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲙⲉⲥⲓⲁⲥ ⲛⲏⲟⲩ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛⲑⲟϥ ⲉⲑⲛⲁⲧⲁⲙⲟⲛ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲫⲏⲉⲧⲥⲁϫⲓ ⲛⲉⲙⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ⲟⲩⲟϩ ϧⲉⲛ ⲫⲁⲓ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ϫⲉ ⳿ϥⲥⲁϫⲓ ⲛⲉⲙ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⲙⲉⲛⲧⲟⲓ ϫⲟⲥ ⲛⲁϥ ϫⲉ ⲁⲕⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩ ⲓⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲕⲥⲁϫⲓ ⲛⲉⲙⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ⲁⲥⲭⲱ ⲟⲩⲛ ⳿ⲛⲧⲉⲥϩⲩⲇⲣⲓ⳿ⲁ ⳿ⲛϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲁⲥϣⲉ ⲛⲁⲥ ⳿ⲉϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲡⲉϫⲁⲥ ⳿ⲛⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲁⲛⲁⲩ ⳿ⲉⲡⲁⲓⲣⲱⲙⲓ ⳿ⲉⲁϥϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲛⲏⲓ ⲉⲧⲁⲓⲁⲓⲧⲟⲩ ⲙⲏⲧⲓ ⲫⲁⲓ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ⲛⲁⲩⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲧⲱⲟⲩ ⲛⲉⲙⲁϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲣⲁⲃⲃⲓ ⲧⲱⲛⲕ ⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲟⲛϯ ⲟⲩ⳿ϧⲣⲉ ⳿ⲙⲙⲁⲩ ⳿ⲉⲟⲩⲟⲙⲥ ⲑⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲉⲧⲉ⳿ⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲙⲏⲧⲓ ⲁⲛ ⲁ ⲟⲩⲁⲓ ⳿ⲓⲛⲓ ⲛⲁϥ ⲉⲑⲣⲉϥⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲧⲁ⳿ϧⲣⲉ ⳿ⲁⲛⲟⲕ ⲧⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲉⲣ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲁϫⲱⲕ ⳿ⲙⲡⲉϥϩⲱⲃ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ⲙⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛ ⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲧⲓ ⲕⲉⲇ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ⳿ϥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲱⲥϧ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϥⲁⲓ ⳿ⲛⲛⲉⲧⲉⲛⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ ⳿ⲉⲛⲓⲭⲱⲣⲁ ϫⲉ ⲁⲩⲟⲩⲃⲁϣ ⳿ⲉⲡⲟⲥϧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ϩⲏⲇⲏ ⲫⲏⲉⲑⲛⲁⲱⲥϧ ⳿ϥⲛⲁϭⲓ ⳿ⲙⲡⲉϥⲃⲉⲭ ⲉ ⲟⲩⲟϩ ⳿ϥⲛⲁⲑⲱⲟⲩϯ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ⲉⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ϩⲓⲛⲁ ⲫⲏⲉⲧⲥⲓϯ ⳿ⲛⲧⲉϥⲣⲁϣⲓ ⲉⲩⲥⲟⲡ ⲛⲉⲙ ⲫⲏⲉⲧⲱⲥϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ϧⲉⲛ ⲫⲁⲓ ⲅⲁⲣ ⲟⲩⲧⲁ⳿ⲫⲙⲏⲓ ⲡⲉ ⲡⲓⲥⲁϫⲓ ϫⲉ ⲕⲉⲟⲩⲁⲓ ⲡⲉⲧⲥⲓϯ ⲟⲩⲟϩ ⲕⲉⲟⲩⲁⲓ ⲡⲉⲧⲱⲥϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","⳿ⲁⲛⲟⲕ ⲁⲓⲟⲩⲉⲣⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲱⲥϧ ⳿ⲙⲫⲏⲉⲧⲉ ⳿ⲙⲡⲉⲧⲉⲛϧⲓⲥⲓ ⳿ⲉⲣⲟϥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲡⲉⲧⲁⲩϧⲓⲥⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲟⲩϧⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","⳿ⲉⲃⲟⲗ ⲇⲉ ϧⲉⲛ ϯⲃⲁⲕⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁ ⲟⲩⲙⲏϣ ⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲥⲁⲙⲁⲣⲓⲧⲏ ⲥ ⲉⲑⲃⲉ ⳿ⲡⲥⲁϫⲓ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ⲉⲥⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⲁϥϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲛⲏⲉⲧⲁⲓⲁⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲥⲁⲙⲁⲣⲓⲧⲏ ⲥ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲟϩⲓ ϧⲁⲧⲟⲧⲟⲩ ⲟⲩⲟϩ ⲁϥⲟϩⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲙⲏϣ ⳿ⲛϩⲟⲩ⳿ⲟ ⲁⲩⲛⲁϩϯ ⲉⲑⲃⲉ ⲡⲉϥⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ϫⲉ ⲉⲑⲃⲉ ⲧⲉⲛϫⲓⲛⲥⲁϫⲓ ⲁⲛ ϫⲉ ⲧⲉⲛⲛⲁϩϯ ⳿ⲁⲛⲟⲛ ⲅⲁⲣ ϩⲱⲛ ⲁⲛⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⲧⲉⲛ⳿ⲉⲙⲓ ⲧⲁ⳿ⲫⲙⲏⲓ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓⲥⲱⲧⲏⲣ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲃ̅ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","⳿ⲛⲑⲟϥ ⲅⲁⲣ Ⲓⲏ̅ⲥ̅ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉϥⲧⲁⲓⲏⲟⲩⲧ ϧⲉⲛ ⲑⲏ ⲉⲧⲉⲑⲱϥ ⳿ⲙⲃⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲁⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲅⲁⲗⲓⲗⲉⲟⲥ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ϧⲉⲛ ⳿ⲡϣⲁⲓ ⲛⲉ ⲁⲩ⳿ⲓ ⲅⲁⲣ ϩⲱⲟⲩ ⳿ⲉ⳿ⲡϣⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ⲁϥ⳿ⲓ ⲟⲛ ⳿ⲉ⳿ⲧⲕⲁⲛⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲡⲓⲙⲁ ⲉⲧⲁϥ⳿ⲑⲣⲉ ⲡⲓⲙⲱⲟⲩ ⲉⲣⲏⲣⲡ ⳿ⲙⲙⲟϥ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲃⲁⲥⲓⲗⲓⲕⲟⲥ ⲡⲉ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲛⲟⲩϣⲏ ⲣⲓ ⳿ⲙⲙⲁⲩ ⲉϥϣⲱⲛⲓ ϧⲉⲛ ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ⲫⲁⲓ ⲁϥⲥⲱⲧⲉⲙ ϫⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲁϥϣⲉ ⲛⲁϥ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲛⲁϥϯϩⲟ ⳿ⲉⲣⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿Ⲓ ⳿ⲉϧⲣⲏⲓ ⳿ⲛⲧⲉϥⲧⲟⲩϫⲉ ⲡⲉϥϣⲏⲣⲓ ⲛⲁϥⲛⲁⲙⲟⲩ ⲅⲁⲣ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲛⲁϥ ϫⲉ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲉϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ⲡⲉϫⲉ ⲡⲓⲃⲁⲥⲓⲗⲓⲕⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⳿ⲁⲙⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲙⲡⲁⲧⲉϥⲙⲟⲩ ⳿ⲛϫⲉ ⲡⲁ⳿ⲁⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ϥⲟⲛϧ ⳿ⲛϫⲉ ⲡⲉⲕϣⲏⲣⲓ ⲟⲩⲟϩ ⲁϥⲛⲁϩϯ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲟϥ ⲛⲁϥ ⲟⲩⲟϩ ⲁϥⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ϩⲏⲇⲏ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⲓⲥ ⲛⲉϥⲉⲃⲓⲁⲓⲕ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲟⲛϧ ⳿ⲛϫⲉ ⲡⲉⲕϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ⲛⲁϥϣⲓⲛⲓ ⲇⲉ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲥⲁ ϯⲟⲩⲛⲟⲩ ⲑⲏ ⲉⲧⲁϥ⳿ⲁⲥⲓⲁⲓ ⳿ⲛϧⲏⲧⲥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ϧⲉⲛ ⲁϫⲡ ⲍ̅ ⳿ⲛⲥⲁϥ ⲁϥⲭⲁϥ ⳿ⲛϫⲉ ⲡⲓ⳿ϧⲙⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ⲁϥ⳿ⲉⲙⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲡⲉϥⲓⲱⲧ ϫⲉ ⲛⲉ ϯ ⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲧⲉ ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϫⲟⲥ ⲛⲁϥ ϫⲉ ⳿ϥⲟⲛϧ ⳿ⲛϫⲉ ⲡⲉⲕϣⲏⲣⲓ ⲟⲩⲟϩ ⲁϥⲛⲁϩϯ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ⲫⲁⲓ ⲡⲉ ⲡⲓⲙⲏⲓⲛⲓ ⳿ⲙⲙⲁϩ ⲃ̅ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯ ⲓⲟⲩⲇⲉ⳿ⲁ ⳿ⲉϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ");
INSERT INTO copcnt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲛⲉ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲇⲁⲓ ⲡⲉ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ϩⲓϫⲉⲛ ϯ⳿ⲡⲣⲟⲃⲁⲧⲓⲕⲏ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲕⲟⲗⲩⲙⲃⲏⲑⲣⲁ ⲑⲏ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ϫⲉ ⲃⲏⲑⲥⲁⲓⲇⲁ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲁⲥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲉ̅ ⳿ⲛ⳿ⲥⲧⲟ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ⲟⲩⲟϩ ⲛⲁⲩⲣⲟϫⲡ ⲡⲉ ϧⲉⲛ ⲛⲁⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲏ ϣ ⳿ⲛⲧⲉ ⲛⲏⲉⲧϣⲱⲛⲓ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ⲛⲉⲙ ϩⲁⲛϭⲁⲗⲉⲩ ⲛⲉⲙ ϩⲁⲛⲟⲩⲟⲛ ⲉⲩϣⲟⲩ⳿ⲱⲟⲩ ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ⲉⲩϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ⲉⲩⲕⲓⲙ ⳿ⲙⲡⲓⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛⲛⲁⲩ ⲛⲓⲃⲉⲛ ϧⲉⲛ ϯⲕⲟⲗⲩⲙⲃⲏⲑⲣⲁ ⲟⲩⲟϩ ⲉϥⲕⲓⲙ ⳿ⲙⲡⲓⲙⲱⲟⲩ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲉⲡⲉⲥⲏ ⲧ ⳿ⲛϣⲟⲣⲡ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲕⲓⲙ ⳿ⲙⲡⲓⲙⲱⲟⲩ ⲉϥ⳿ⲉⲉⲣⲫⲁϧⲣⲓ ⳿ⲉϣⲱⲛⲓ ⲛⲓⲃⲉⲛ ⲉⲧⲉ⳿ⲛⲧⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲡⲉ ⳿ⲉⲁϥⲉⲣ ⲗ̅ⲏ̅ ⳿ⲛⲣⲟⲙⲡⲓ ϧⲉⲛ ⲡⲉϥϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲫⲁⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥ⳿ⲛⲕⲟⲧ ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲉⲙⲓ ϫⲉ ⲁϥⲉⲣ ⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲉⲟⲩϫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲫⲏⲉⲧϣⲱⲛⲓ ⲡⲉϫⲁϥ ⲡⲁ⳪ ⳿ⲙⲙⲟⲛϯ ⲣⲱⲙⲓ ⳿ⲙⲙⲁⲩ ϩⲓⲛⲁ ⲁϥϣⲁⲛⲑⲟϩ ⳿ⲛϫⲉ ⲡⲓⲙⲱⲟⲩ ⳿ⲛⲧⲉϥϩⲓⲧ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯⲕⲟⲗⲩⲙⲃⲏⲑⲣⲁ ϩⲱⲥ ⲇⲉ ⲉⲓⲛⲏⲟⲩ ⳿ⲁⲛⲟⲕ ϣⲁⲣⲉ ⲕⲉⲟⲩⲁⲓ ⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲧⲱⲛⲕ ⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉⲕϭ ⲗⲟϫ ⲟⲩⲟϩ ⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥⲟⲩϫⲁⲓ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲁϥⲱⲗⲓ ⳿ⲙⲡⲉϥϭⲗⲟϫ ⲁϥⲙⲟϣⲓ ⲛⲉ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲡⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲙⲫⲏⲉⲧⲁϥⲉⲣⲫⲁϧⲣⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲡⲉ ⲟⲩⲟϩ ⳿ⲥϣⲉ ⲛⲁⲕ ⲁⲛ ⳿ⲉⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲏⲉⲧⲁϥ⳿ⲑⲣⲓⲟⲩϫⲁⲓ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥϫⲟⲥ ⲛⲏⲓ ϫⲉ ⲱⲗⲓ ⳿ⲙⲡⲉⲕϭⲗⲟϫ ⲙⲁϣⲉ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ⲁⲩϣⲉⲛϥ ⲇⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲡⲓⲣⲱⲙⲓ ⲉⲧⲁϥϫⲟⲥ ⲛⲁⲕ ϫⲉ ⲱⲗⲓ ⳿ⲙⲡⲉⲕ ϭⲗⲟϫ ⲟⲩⲟϩ ⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ⲫⲏ ⲇⲉ ⲉⲧⲁϥⲟⲩϫⲁⲓ ⲛⲁϥ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲓⲙ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲁϥϫⲉⲙϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ⲁⲕⲟⲩϫⲁⲓ ⳿ⲙⲡⲉⲣⲉⲣⲛⲟⲃⲓ ϫⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲉⲧϩⲱⲟⲩ ⳿ⲛϩⲟⲩⲟ ϣⲱⲡⲓ ⳿ⲙⲙⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ⲁϥϣⲉ ⲛⲁϥ ⲟⲩⲛ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉⲧⲁϥ⳿ⲑⲣⲓⲟⲩϫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ⲉⲑⲃⲉⲫⲁⲓ ⲟⲩⲛ ⲛⲁⲩϭⲟϫⲓ ⳿ⲛⲥⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⲛⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ ⲡⲁⲓⲱⲧ ⲉⲣϩⲱⲃ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲉⲣϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ⲉⲑⲃⲉⲫⲁⲓ ⲟⲩⲛ ⳿ⲛϩⲟⲩ⳿ⲟ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲉϧⲟⲑⲃⲉϥ ϫⲉ ⲟⲩ ⲙⲟⲛⲟⲛ ⲛⲁϥⲃⲱⲗ ⳿ⲙⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲗⲗⲁ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫϯ ⲡⲉ ⲡⲁⲓⲱⲧ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϩⲓⲥⲟⲥ ⲛⲉⲙ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ⲡϣⲏⲣⲓ ⲉⲣ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲁϥ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⲛⲏ ⲅⲁⲣ ⲉⲧⲉ ⳿ⲫⲓⲱⲧ ⲣⲁ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲓ ⲟⲛ ⲉⲧⲉ ⲡⲓⲕⲉϣⲏⲣⲓ ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","⳿ⲫⲓⲱⲧ ⲅⲁⲣ ⳿ϥⲙⲉⲓ ⳿ⲙ⳿ⲡϣⲏⲣⲓ ⲟⲩⲟϩ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ϥⲛⲁⲧⲁⲙⲟϥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲉⲩⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲛⲁⲓ ⳿ϥⲛⲁⲧⲁⲙⲟϥ ⳿ⲉⲣⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲉⲣ⳿ϣⲫⲏ ⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲉⲧⲉ ⳿ⲫⲓⲱⲧ ⲧⲟⲩⲛⲟⲥ ⳿ⲛⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⳿ϥⲧⲁⲛϧⲟ ⳿ⲙⲙⲱⲟⲩ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓⲕⲉϣⲏⲣⲓ ⲛⲏⲉⲧⲉϥⲟⲩⲁϣⲟⲩ ⳿ϥⲧⲁⲛϧⲟ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ⲟⲩ ⲅⲁⲣ ⳿ⲫⲓⲱⲧ ⳿ϥⲛⲁϯϩⲁⲡ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ ⲁⲗⲗⲁ ⲡⲓϩⲁⲡ ⲧⲏⲣϥ ⲁϥⲧⲏⲓϥ ⳿ⲙⲡⲓϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙⲡⲓϣⲏ ⲣⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲟⲩⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙ⳿ⲫⲓⲱⲧ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲉⲣⲧⲓⲙⲁⲛ ⲁⲛ ⳿ⲙⲡⲓϣⲏⲣⲓ ⳿ϥⲉⲣⲧⲓⲙⲁⲛ ⲁⲛ ⲟⲛ ⳿ⲙⲡⲓⲕⲉⲓⲱⲧ ⲉⲧⲁϥⲧⲁⲟⲩⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲛⲁϩϯ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲟⲩⲟⲛⲧⲉϥ ⲱⲛϧ ⳿ⲛⲉⲛⲉϩ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ϥⲛⲁ⳿ⲓ ⲁⲛ ⳿ⲉ⳿ⲡϩⲁⲡ ⲁⲗⲗⲁ ⳿ϥⲟⲩⲱⲧⲉⲃ ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲙⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ⲉⲧⲉ ϯⲛⲟⲩ ⲧⲉ ϩⲟⲧⲉ ⲉⲣⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲛⲁⲥⲱⲧⲉⲙ ⳿ⲉ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙ⳿ⲡϣⲏ ⲣⲓ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲁⲥⲱⲧⲉⲙ ⲉⲩ⳿ⲉⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲱⲛϧ ϣⲟⲡ ϧⲉⲛ ⳿ⲫⲓⲱⲧ ⲡⲁⲓⲣⲏϯ ⲁϥⲧⲏⲓⲥ ⳿ⲙⲡⲓⲕⲉϣⲏ ⲣⲓ ⲉⲑⲣⲉ ⲟⲩⲱⲛϧ ϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ⲟⲩⲟϩ ⲁϥϯⲉⲣϣⲓϣⲓ ⲛⲁϥ ⲉⲑⲣⲉϥ⳿ⲓⲣⲓ ⳿ⲛⲟⲩϩⲁⲡ ϫⲉ ⲟⲩϣⲏⲣⲓ ⳿ⲛⲣⲱⲙⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","⳿ⲙⲡⲉⲣⲉⲣ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⲫⲁⲓ ϫⲉ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ϩⲟⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲭⲏ ϧⲉⲛ ⲛⲓ⳿ⲙϩⲁⲩ ⲉⲩ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲧⲉϥ⳿ⲥⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ⲟⲩⲟϩ ⲉⲩ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲁⲩ⳿ⲓⲣⲓ ⳿ⲛⲛⲓⲡⲉⲑⲛⲁⲛⲉⲩ ⲉⲩⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲱⲛϧ ⲟⲩⲟϩ ⲛⲏⲉⲧⲁⲩ⳿ⲓⲣⲓ ⳿ⲛⲛⲓⲡⲉⲧϩⲱⲟⲩ ⲉⲩⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛ⳿ⲕⲣⲓⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲁⲉⲣ ⳿ϩⲗⲓ ⳿ⲁⲛⲟⲕ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉϯⲥⲱⲧⲉⲙ ϯϯϩⲁⲡ ⲟⲩⲟϩ ⲡⲁϩⲁⲡ ⳿ⲁⲛⲟⲕ ⲟⲩⲙⲏⲓ ⲡⲉ ϫⲉ ⳿ⲛϯⲕⲱϯ ⲁⲛ ⳿ⲛⲥⲁ ⲡⲁⲟⲩⲱϣ ⲁⲗⲗⲁ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ⲉϣⲱⲡ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ ⲧⲁⲙⲉⲧⲙⲉⲑⲣⲉ ⲟⲩⲙⲏⲓ ⲁⲛ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ⲕⲉⲟⲩⲁⲓ ⲡⲉⲧⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ ⲟⲩⲟϩ ϯ⳿ⲉⲙⲓ ϫⲉ ⲧⲉϥⲙⲉⲧⲙⲉⲑⲣⲉ ⲟⲩⲙⲏⲓ ⲧⲉ ⲑⲏ ⲉⲧⲁϥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲁⲧⲉⲧⲉⲛⲟⲩⲱⲣⲡ ϩⲁ ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛ⳿ⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","⳿ⲁⲛⲟⲕ ⲇⲉ ⲛⲁⲓϭⲓ ⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲁⲛ ⲁⲗⲗⲁ ⲛⲁⲓ ϯϫⲱ ⳿ⲙⲙⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉ ⳿ⲛⲑⲟϥ ⲡⲉ ⲡⲓϧⲏⲃⲥ ⲉⲑⲙⲟϩ ⲟⲩⲟϩ ⲉⲧⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲁⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲉⲑⲉⲗⲏⲗ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲡⲣⲟⲥ ⲟⲩⲟⲩⲛⲟⲩ ϧⲉⲛ ⲡⲉϥⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","⳿ⲁⲛⲟⲕ ⲇⲉ ⲟⲩⲟⲛϯ ⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲉⲛⲁⲁⲥ ⳿ⲉⲑⲁ ⲓⲱⲁⲛⲛⲏⲥ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⲅⲁⲣ ⲉⲧⲁϥⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲟⲕⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲑⲱⲟⲩ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲱⲟⲩ ⲥⲉⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲓ ϫⲉ ⳿ⲫⲓⲱⲧ ⲡⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ⲟⲩⲟϩ ⳿ⲫⲓⲱⲧ ⲡⲉⲧⲁϥⲟⲩⲟⲣⲡⲧ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉ⳿ⲥⲙⲏ ⳿ⲛⲧⲁϥ ⲉⲛⲉϩ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉ⳿ⲥⲙⲟⲧ ⳿ⲛⲧⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ⲟⲩⲟϩ ⲡⲉϥⲥⲁϫⲓ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲛ ϫⲉ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟϥ ⳿ⲙⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ⲟⲧϧⲉⲧ ϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ⲛⲏⲉⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ϣⲟⲡ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲉⲧⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⲁⲛ ⳿ⲉ⳿ⲓ ϩⲁⲣⲟⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲱⲛϧ ϣⲱⲡⲓ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","⳿ⲛϯⲛⲁϭⲓⲱⲟⲩ ⳿ⲛⲧⲉⲛ ⲣⲱⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ⲁⲗⲗⲁ ⲁⲓ⳿ⲉⲙⲓ ⲉⲣⲱⲧⲉⲛ ϫⲉ ϯ⳿ⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ ⲫϯ ϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","⳿ⲁⲛⲟⲕ ⲁⲓ⳿ⲓ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛϭⲓ ⳿ⲙⲙⲟⲓ ⲁⲛ ⲁⲣⲉϣⲁⲛ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⳿Ⲓ ϧⲉⲛ ⲡⲉⲧⲉⲫⲱϥ ⳿ⲛⲣⲁⲛ ⲧⲉⲧⲉⲛⲛⲁϭⲓⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲛⲁϩϯ ⲉⲣⲉⲧⲉⲛϭⲓⲱⲟⲩ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲟⲩⲟϩ ⳿ⲡⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ⲙⲏ ⲧⲉⲧⲉⲛⲙⲉⲩⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁⲉⲣⲕⲁⲧⲏ ⲅⲟⲣⲓⲛ ⳿ⲉⲣⲱⲧⲉⲛ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲱⲧ ⲟⲩⲟⲛ ⲫⲏⲉⲑⲛⲁⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲙⲱ⳿ⲩⲥⲏⲥ ⲫⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲁⲣⲉⲧⲉⲛⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","⳿ⲉⲛⲁⲣⲉⲧⲉⲛⲛⲁϩϯ ⲅⲁⲣ ⳿ⲉⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲁⲣⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ϩⲱ ⲡⲉ ⲉⲧⲁ ⲫⲏ ⲅⲁⲣ ⳿ⲥϧⲁⲓ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ⲓⲥϫⲉ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⲁⲛ ⳿ⲉⲛⲓ⳿ⲥϧⲁⲓ ⳿ⲛⲧⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲱⲥ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲛⲁⲥⲁϫⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲙⲏ ⲣ ⳿ⲙ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲛⲧⲉ ⲧⲓⲃⲉⲣⲓⲁⲇⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ⲛⲁϥⲙⲟϣⲓ ⲇⲉ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ϫⲉ ⲛⲁⲩⲛⲁⲩ ⳿ⲉⲛⲓⲙⲏⲓⲛⲓ ⲉⲛⲁϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲛⲏⲉⲧϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ⲁϥϣⲉ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥϩⲉⲙⲥⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ⲛⲉ ⲁϥϧⲱⲛⲧ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲥⲭⲁ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ⲉⲧⲁϥϥⲁⲓ ⲟⲩⲛ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲧⲁϥⲛⲁⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏ ϣ ⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲡⲉϫⲁϥ ⳿ⲙⲫⲓⲗⲓⲡⲡⲟⲥ ϫⲉ ⲁⲛⲛⲁϫⲉⲙ ⲱⲓⲕ ⲑⲱⲛ ⲉϣⲱⲡ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲟⲩⲱⲙ ⳿ⲛϫⲉ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ⲫⲁⲓ ⲇⲉ ⲁϥϫⲟϥ ⲉϥⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟϥ ⲅⲁⲣ ⲛⲁϥⲥⲱⲟⲩⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲁϥⲣⲱⲟⲩϣ ⳿ⲉⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲫⲓⲗⲓⲡⲡⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲥ̅ ⳿ⲛⲥⲁⲑⲣⲉⲓ ⳿ⲛⲱⲓⲕ ⲛⲁⲣⲁϣⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϭ ⲓ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲉⲧⲉ ⲁⲛⲁⲇⲣⲉⲁⲥ ⲡⲉ ⳿ⲡⲥⲟⲛ ⳿ⲛⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ϫⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲙⲡⲁⲓⲙⲁ ⳿ⲉⲟⲩⲟⲛ ⲉ̅ ⳿ⲛⲱⲓⲕ ⳿ⲛⲓⲱⲧ ⳿ⲛⲧⲟⲧϥ ⲛⲉⲙ ⲧⲉⲃⲧ ⲃ̅ ⲁⲗⲗⲁ ⲉⲣⲉ ⲛⲁⲓ ⲛⲁⲫⲟϩ ⳿ⲉⲑⲱⲛ ⳿ⲛⲛⲁⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲙⲁⲣⲉ ⲛⲓⲣⲱⲙⲓ ⲣⲟⲑⲃⲟⲩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲛⲥⲓⲙ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩⲣⲟⲑⲃⲟⲩ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲥⲓⲙ ⲧⲟⲩ⳿ⲏⲡⲓ ⲉⲩⲉⲣ ⲉ̅ ⳿ⲛϣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ⲁϥϭⲓ ⲟⲩⲛ ⳿ⲛⲛⲓⲱⲓⲕ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲧⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲁϥϯ ⳿ⲛⲛⲏⲉⲑⲣⲟⲧⲉⲃ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲕⲉⲧⲉⲃⲧ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲟⲩⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩⲥⲓ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ϫⲉ ⲑⲱⲟⲩϯ ⳿ⲛⲛⲓⲗⲁⲕϩ ⲉⲧⲁⲩⲉⲣϩⲟⲩ⳿ⲟ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩⲟⲛ ⲧⲁⲕⲟ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛⲛⲏⲉⲧⲁⲩⲉⲣϩⲟⲩ⳿ⲟ ⲟⲩⲟϩ ⲁⲩⲙⲁϩ ⲓ̅ⲃ̅ ⳿ⲛⲕⲟⲧ ⳿ⲛⲗⲁⲕϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉ̅ ⳿ⲛⲱⲓⲕ ⳿ⲛⲓⲱⲧ ⲛⲏⲉⲧⲁⲩⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲛⲏⲉⲧⲁⲩⲟⲩⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲛⲓⲙⲏⲓⲛⲓ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉⲧⲁϥⲛⲁⲩ ϫⲉ ⲥⲉⲣⲱⲟⲩϣ ⳿ⲉ⳿Ⲓ ⳿ⲉϩⲟⲗⲙⲉϥ ⳿ⲉⲁⲓϥ ⳿ⲛⲟⲩⲣⲟ ⲁϥⲉⲣ⳿ⲁⲛⲁⲭⲱⲣⲓⲛ ⳿ⲉϫⲉⲛ ⲡⲓⲧⲱⲟⲩ ⳿ⲛⲑⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ⲉⲧⲁ ⲣⲟⲩϩⲓ ⲇⲉ ϣⲱⲡⲓ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲓⲟⲙ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ⲟⲩⲟϩ ⲉⲧⲁⲩ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲙⲏⲣ ⳿ⲙ⳿ⲫⲓⲟⲙ ⳿ⲉⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ ⲟⲩⲟϩ ⲛⲉⲁ ⳿ⲧⲭⲉⲙⲥ ϩⲏⲇⲏ ϣⲱⲡⲓ ⲡⲉ ⲟⲩⲟϩ ⲛⲉ ⳿ⲙⲡⲁⲧⲉϥ⳿Ⲓ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","⳿ⲫⲓⲟⲙ ⲇⲉ ⲛⲁϥⲛⲏⲟⲩ ⳿ⲛⲛⲉϩⲥⲓ ⲡⲉ ⲉϥⲛⲓϥⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲑⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ⲉⲧⲁⲩⲟⲩⲉⲓ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲛⲁⲩ ⲕ̅ⲉ̅ ⳿ⲛ⳿ⲥⲧⲁⲇⲓⲟⲛ ⲓⲉ ⲗ̅ ⲁⲩⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ⲉϥⲙⲟϣⲓ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ ⲟⲩⲟϩ ⲉϥϧⲱⲛⲧ ⳿ⲙⲙⲟϥ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲁⲩⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ⲛⲁⲩⲟⲩⲱϣ ⲟⲩⲛ ⲡⲉ ⳿ⲉⲧⲁⲗⲟϥ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁ ⲡⲓϫⲟⲓ ⲁϥ⳿ⲓ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ ⳿ⲉⲡⲓⲕⲁϩⲓ ⳿ⲉⲛⲁⲩⲛⲁϣⲉ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲡⲓⲙⲏϣ ⳿ⲉⲛⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϩⲓⲙⲏⲣ ⳿ⲙ⳿ⲫⲓⲟⲙ ⲁⲩⲛⲁⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲕⲉϫⲟⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲟⲩⲁⲓ ⲟⲩⲟϩ ϫⲉ ⳿ⲙⲡⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲗⲗⲁ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉ ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ϩⲁⲛⲕⲉⲉϫⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲓⲃⲉⲣⲓⲁⲇⲟⲥ ϧⲁⲧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲁⲩⲟⲩⲱⲙ ⳿ⲙⲡⲓⲱⲓⲕ ⳿ⲙⲙⲟϥ ⲉⲧⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩ ⲁⲛ ⲟⲩⲇⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩ⳿ⲁⲗⲏⲓ ⳿ⲛⲑⲱⲟⲩ ⳿ⲉⲛⲓ⳿ⲉϫⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲕⲁⲫⲁⲣⲛⲁⲟⲩⲱⲙ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲁ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ⲟⲩⲟϩ ⲉⲧⲁⲩϫⲉⲙϥ ϩⲓⲙⲏⲣ ⳿ⲙ⳿ⲫⲓⲟⲙ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲣⲁⲃⲃⲓ ⲉⲧⲁⲕ⳿ⲓ ⳿ⲉ⳿ⲙⲛⲁⲓ ⳿ⲛ⳿ⲑⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲁⲛ ϫⲉ ⲁⲣⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉϩⲁⲛⲙⲏⲓⲛⲓ ⲁⲗⲗⲁ ϫⲉ ⲁⲣⲉⲧⲉⲛⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲱⲓⲕ ⲟⲩⲟϩ ⲁⲣⲉⲧⲉⲛⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ⲁⲣⲓϩⲱⲃ ⳿ⲉϯ⳿ϧⲣⲉ ⲁⲛ ⲉⲑⲛⲁⲧⲁⲕⲟ ⲁⲗⲗⲁ ϯ⳿ϧⲣⲉ ⲉⲑⲛⲁϣⲱⲡⲓ ⲉⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ ⲑⲏ ⲉⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲁⲧⲏⲓⲥ ⲛⲱⲧⲉⲛ ⲫⲁⲓ ⲅⲁⲣ ⲁ ⲫϯ ⳿ⲫⲓⲱⲧ ⲉⲣ⳿ⲥ⳿ⲫⲣⲁⲅⲓⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ⲡⲉϫⲱⲟⲩ ⲟⲩⲛ ⲛⲁϥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲛⲁⲁⲓϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛⲉⲣϩⲱⲃ ⳿ⲉⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲓϩⲱⲃ ⳿ⲛⲧⲉ ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⲟⲩⲛ ϫⲉ ⲟⲩ ⳿ⲙⲙⲏⲓⲛⲓ ⲉⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟⲕ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛⲛⲁⲩ ⳿ⲛⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟⲕ ⲟⲩ ⳿ⲛϩⲱⲃ ⲉⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ⲁ ⲛⲉⲛⲓⲟϯ ⲟⲩⲱⲙ ⳿ⲙⲡⲓⲙⲁⲛⲛⲁ ⳿ⲛ⳿ϩⲣⲏⲓ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲟⲩⲱⲓⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲁϥⲧⲏⲓϥ ⲛⲱⲟⲩ ⲉⲑⲣⲟⲩⲟⲩⲟⲙϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲙⲱ⳿ⲩⲥⲏⲥ ⲁⲛ ⲁϥϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲱⲓⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲁⲗⲗⲁ ⲡⲁⲓⲱⲧ ⲉⲑⲛⲁϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲱⲓⲕ ⳿ⲛ⳿ⲧⲁ⳿ⲫⲙⲏⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ⲡⲓⲱⲓⲕ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲉϥϯ ⳿ⲙ⳿ⲡⲱⲛϧ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲙⲟⲓ ⲛⲁⲛ ⳿ⲙⲡⲁⲓⲱⲓⲕ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲱⲓⲕ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ ⲫⲏⲉⲑⲛⲏⲟⲩ ϩⲁⲣⲟⲓ ⳿ⲛⲛⲉϥ⳿ϩⲕⲟ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⳿ⲛⲛⲉϥ⳿ⲓⲃⲓ ϣⲁ ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ⲁⲗⲗⲁ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ⲟⲩⲟϩ ⲁⲣⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲧⲁ ⲡⲁⲓⲱⲧ ⲧⲏⲓϥ ⲛⲏⲓ ⳿ϥⲛⲁ⳿Ⲓ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁ⳿ⲓ ϩⲁⲣⲟⲓ ⳿ⲛⲛⲁϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ϫⲉ ⲟⲩⲏⲓ ⲅⲁⲣ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ϩⲓⲛⲁ ⲁⲛ ⳿ⲛⲧⲁ⳿ⲓⲣⲓ ⳿ⲙⲡⲉⲧⲉ⳿ϩⲛⲏⲓ ⲁⲗⲗⲁ ⲡⲉⲧⲉⲛⲁϥ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ⲫⲁⲓ ⲡⲉ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ϩⲓⲛⲁ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲧⲁϥⲧⲏⲓϥ ⲛⲏⲓ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙⲧⲁⲕⲉ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲗⲗⲁ ⳿ⲛⲧⲁⲧⲟⲩⲛⲟⲥϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲡⲁⲓⲱⲧ ϩⲓⲛⲁ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲩ ⳿ⲉⲡⲓϣⲏⲣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲧⲟⲩⲛⲟⲥϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ⲛⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲟⲩⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲑⲃⲏⲧϥ ϫⲉ ⲁϥϫⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲱⲓⲕ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲓⲱⲥⲏⲫ ⲫⲏ ⳿ⲁⲛⲟⲛ ⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲡⲱⲥ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϯⲛⲟⲩ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲣ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⳿ⲓ ϩⲁⲣⲟⲓ ⲁⲣⲉ⳿ϣⲧⲉⲙ ⳿ⲫⲓⲱⲧ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲥⲟⲕϥ ϩⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⳿ⲛⲧⲁⲧⲟⲩⲛⲟⲥϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲉ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲧⲏⲣⲟⲩ ⳿ⲛⲣⲉϥϭⲓ⳿ⲥⲃⲱ ⳿ⲛⲧⲉⲛ ⲫϯ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ϥⲛⲁ⳿ⲓ ϩⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ⲟⲩⲭ ⳿ⲟⲧⲓ ϫⲉ ⲁ ⲟⲩⲁⲓ ⲛⲁⲩ ⳿ⲉ⳿ⲫⲓⲱⲧ ⳿ⲉⲃⲏⲗ ⳿ⲉⲫⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ⲫⲁⲓ ⲡⲉ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲟⲩⲟⲛⲧⲉϥ ⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲱⲓⲕ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ⲛⲉⲧⲉⲛⲓⲟϯ ⲁⲩⲟⲩⲱⲙ ⳿ⲙⲡⲓⲙⲁⲛⲛⲁ ⳿ⲛ⳿ϩⲣⲏ ⲓ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ⲫⲁⲓ ⲇⲉ ⲡⲉ ⲡⲓⲱⲓⲕ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ϩⲓⲛⲁ ⲫⲏⲉⲑⲛⲁⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲱⲓⲕ ⲉⲧⲟⲛϧ ⲫⲏⲉⲧⲁϥ⳿Ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲫⲏⲉⲑⲛⲁⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲱⲓⲕ ⲉϥ⳿ⲉⲱⲛϧ ϣⲁ ⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⲡⲓⲱⲓⲕ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁⲧⲏⲓϥ ⲧⲁⲥⲁⲣⲝ ⲧⲉ ⲑⲏ ⳿ⲉϯⲛⲁⲧⲏⲓⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲡⲱⲛϧ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ⲛⲁⲩϯ ⲟⲩⲛ ⲡⲉ ⲟⲩⲃⲉ ⲛⲟⲩⲉⲣⲏⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲫⲁⲓ ϯ ⳿ⲛⲧⲉϥⲥⲁⲣⲝ ⲛⲁⲛ ⲉⲑⲣⲉⲛⲟⲩⲟⲙⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲟⲩⲱⲙ ⳿ⲛ⳿ⲧⲥⲁⲣⲝ ⳿ⲙ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱ ⳿ⲙⲡⲉϥ⳿ⲥⲛⲟϥ ⳿ⲙⲙⲟⲛⲧⲉⲧⲉⲛ ⲱⲛϧ ⳿ⲙⲙⲁⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ⲫⲏⲉⲑⲟⲩⲱⲙ ⳿ⲛⲧⲁⲥⲁⲣⲝ ⲟⲩⲟϩ ⲉⲧⲥⲱ ⳿ⲙⲡⲁ⳿ⲥⲛⲟϥ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲧⲟⲩⲛⲟⲥϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ⲧⲁⲥⲁⲝ ⲅⲁⲣ ⲟⲩ⳿ϧⲣⲉ ⳿ⲛⲧⲁ⳿ⲫⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⲡⲁ⳿ⲥⲛⲟϥ ⲟⲩⲥⲱ ⳿ⲛⲧⲁ⳿ⲫⲙⲏⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ⲫⲏⲉⲑⲟⲩⲱⲙ ⳿ⲛⲧⲁⲥⲁⲣⲝ ⲟⲩⲟϩ ⲉⲧⲥⲱ ⳿ⲙⲡⲁ⳿ⲥⲛⲟϥ ⳿ϥⲛⲁϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁϣⲱⲡⲓ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲫⲏⲉⲧⲟⲛϧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲱⲛϧ ⲉⲑⲃⲉ ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ⲫⲏⲉⲑⲟⲩⲱⲙ ⳿ⲙⲙⲟⲓ ⲉϥ⳿ⲉⲱⲛϧ ϩⲱϥ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ⲫⲁⲓ ⲡⲉ ⲡⲓⲱⲓⲕ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⲁⲛ ⳿ⲛⲛⲓⲓⲟϯ ⲉⲧⲁⲩⲟⲩⲱⲙ ⲟⲩⲟϩ ⲁⲩⲙⲟⲩ ⲫⲏⲉⲑⲛⲁⲟⲩⲱⲙ ⳿ⲙⲡⲁⲓⲱⲓⲕ ⲉϥ⳿ⲉⲱⲛϧ ϣⲁ ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ⲛⲁⲓ ⲁϥϫⲟⲧⲟⲩ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲧⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ϧⲉⲛ ⲕⲁⲫⲁⲣⲛⲁⲟⲩⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ϩⲁⲛⲙⲏϣ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ϥⲛⲁϣⲧ ⳿ⲛϫⲉ ⲡⲁⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ϫⲉ ⲥⲉ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲉⲧⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ⲓⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛϣⲁⲛⲛⲁⲩ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲉϥⲛⲁ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲡⲓⲙⲁ ⳿ⲉⲛⲁϥⲭⲏ ⳿ⲙⲙⲟϥ ⳿ⲛϣⲟⲣⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ⲡⲓⲡ͞ⲛⲁ̅ ⲡⲉⲧⲧⲁⲛϧⲟ ϯⲥⲁⲣⲝ ⳿ⲥϯ ⳿ϩⲗⲓ ⳿ⲛϩⲏⲟⲩ ⲁⲛ ⲛⲓⲥⲁϫⲓ ⳿ⲁⲛⲟⲕ ⲉⲧⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲡⲉ ⲟⲩⲟϩ ⲟⲩⲱⲛϧ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ⲁⲗⲗⲁ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲥⲉⲛⲁϩϯ ⲁⲛ ⲛⲁϥⲥⲱⲟⲩⲛ ⲅⲁⲣ ⲓⲥϫⲉⲛ ϩⲏ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲛⲓⲙ ⲛⲉ ⲛⲏⲉⲧⲉ⳿ⲛⲥⲉⲛⲁϩϯ ⲁⲛ ⲟⲩⲟϩ ϫⲉ ⲛⲓⲙ ⲫⲏ ⳿ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⲡⲉ ϫⲉ ⲉⲑⲃⲉⲫⲁⲓ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⳿ⲓ ϩⲁⲣⲟⲓ ⲁⲩ⳿ϣⲧⲉⲙⲧⲏⲓⲥ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ⲉⲑⲃⲉⲫⲁⲓ ⲟⲩⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲁⲩⲫⲱⲧ ⳿ⲉⲫⲁϩⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲙⲟϣⲓ ⲛⲉⲙⲁϥ ⲁⲛ ϫⲉ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⳿ⲙⲡⲓⲓ̅ⲃ̅ ϫⲉ ⲙⲏ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲉϣⲉ ⲛⲱⲧⲉⲛ ϩⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ϫⲉ Ⲡ⳪ ⲁⲛⲛⲁϣⲉ ⲛⲁⲛ ϩⲁ ⲛⲓⲙ ϩⲁⲛⲥⲁϫⲓ ⲅⲁⲣ ⳿ⲛⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⲉⲧⲉ⳿ⲛⲧⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⲁⲛ⳿ⲉⲙⲓ ⲟⲩⲟϩ ⲁⲛⲛⲁϩϯ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉⲑⲟⲩⲁⲃ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲙⲏ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲁⲓⲥⲉⲧⲡ ⲑⲏⲛⲟⲩ ϧⲁ ⲡⲓⲓ̅ⲃ̅ ⲟⲩⲟϩ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ⲛⲁϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲉⲓⲟⲩⲇⲁⲥ ⲥⲓⲙⲱⲛ ⲡⲓⲓⲥⲕⲁⲣⲓⲱⲧⲏⲥ ⲫⲁⲓ ⲅⲁⲣ ⳿ⲉⲛⲁϥⲣⲱⲟⲩϣ ⳿ⲉⲧⲏⲓϥ ⳿ⲉⲟⲩⲁⲓ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲓ̅ⲃ̅ ");
INSERT INTO copcnt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩ ⲅⲁⲣ ⲛⲁϥⲟⲩⲱϣ ⲁⲛ ⲡⲉ ⳿ⲉⲙⲟϣⲓ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ϫⲉ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ⲛⲁϥϧⲉⲛⲧ ⲇⲉ ⳿ⲛϫⲉ ⳿ⲡϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϯ⳿ⲥⲕⲏⲛⲟⲡⲏⲅⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⲟⲩⲟⲑⲃⲉⲕ ⳿ⲉⲃⲟⲗ ⲧⲁⲓ ⲟⲩⲟϩ ⲙⲁϣⲉ ⲛⲁⲕ ⳿ⲉϯⲓⲟⲩⲇⲉ⳿ⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲛⲉⲕⲙⲁⲑⲏⲧⲏⲥ ⲛⲁⲩ ⳿ⲉⲛⲉⲕ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲉⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⲉⲣϩⲱⲃ ϧⲉⲛ ⲡⲉⲧϩⲏⲡ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲕⲱϯ ⳿ⲛⲥⲱϥ ϧⲉⲛ ⲡⲉⲑⲟⲩⲱⲛϩ ⲓⲥϫⲉ ⳿ⲭⲛⲁⲉⲣ ⲛⲁⲓ ⲟⲩⲟⲛϩⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ⲟⲩⲇⲉ ⲅⲁⲣ ⲛⲉϥⲕⲉ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲛⲱⲟⲩ ϫⲉ ⲡⲁⲥⲏⲟⲩ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⲡⲉⲧⲉⲛⲥⲏⲟⲩ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ϥⲥⲉⲃⲧⲱⲧ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲙⲉⲥⲧⲉ ⲑⲏⲛⲟⲩ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ϥⲙⲟⲥϯ ⳿ⲙⲙⲟⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧϥ ϫⲉ ⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲥⲉϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲡϣⲁⲓ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲛϯⲛⲁ⳿ⲓ ⲁⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓϣⲁⲓ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲡⲁⲥⲏⲟⲩ ⳿ⲁⲛⲟⲕ ϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ⲛⲁⲓ ⲇⲉ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⳿ⲛⲑⲟϥ ϧⲉⲛ ϯ ⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ϩⲟⲧⲉ ⲇⲉ ⲉⲧⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲡϣⲁⲓ ⳿ⲛϫⲉ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲧⲟⲧⲉ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲁϥ⳿Ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲟⲩⲟⲩⲱⲛϩ ⲁⲛ ⲁⲗⲗⲁ ϩⲱⲥ ϧⲉⲛ ⲟⲩⲭⲱⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲛ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲉ ϧⲉⲛ ⳿ⲡϣⲁⲓ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϥⲑⲱⲛ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲡⲉ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲉⲑⲃⲏⲧϥ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ⳿ⲁⲅⲁⲑⲟⲥ ⲡⲉ ϩⲁⲛⲕⲉ ⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲁⲗⲗⲁ ⲁϥⲥⲱⲣⲉⲙ ⳿ⲙⲡⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⲙⲉⲛⲧⲟⲓ ⲥⲁϫⲓ ⲉⲑⲃⲏⲧϥ ϧⲉⲛ ⲟⲩⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲉ ⳿ⲧϩⲟϯ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ϩⲏⲇⲏ ⲇⲉ ⲉⲧⲁ ⲡⲓϣⲁⲓ ⲉⲣⲫⲁϣⲓ ⲁϥ⳿Ⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲟⲩⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲱⲥ ⲫⲁⲓ ⲥⲱⲟⲩⲛ ⳿ⲛ⳿ⲥϧⲁⲓ ⳿ⲙⲡⲉϥⲥⲁⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲧⲁ⳿ⲥⲃⲱ ⳿ⲁⲛⲟⲕ ⲑⲱⲓ ⲁⲛ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ⲫⲏⲉⲑⲛⲁⲉⲣ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲉϥ⳿ⲉⲥⲟⲩⲉⲛ ⲧⲁ⳿ⲥⲃⲱ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ⲧⲉ ϣⲁⲛ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ⲫⲏⲉⲧⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁϥⲕⲱϯ ⳿ⲛⲥⲁ ⲡⲉϥⲱⲟⲩ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲫⲏ ⲇⲉ ⲉⲧⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲡⲱⲟⲩ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟϥ ⲫⲁⲓ ⲟⲩ⳿ⲑⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ⲁⲇⲓⲕⲓ⳿ⲁ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ⲙⲏ ⲙⲱ⳿ⲩⲥⲏⲥ ⲁⲛ ⲁϥϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⳿ⲉϧⲟⲑⲃⲉⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁⲕ ⲛⲓⲙ ⲡⲉⲧⲕⲱϯ ⳿ⲛⲥⲱⲕ ⳿ⲉϧⲟⲑⲃⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩϩⲱⲃ ⳿ⲛⲟⲩⲱⲧ ⲡⲉⲧⲁⲓⲁⲓϥ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲉⲣ⳿ϣⲫⲏ ⲣⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ⲉⲑⲃⲉⲫⲁⲓ ⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲥⲉⲃⲓ ⲟⲩⲭ ⲟⲧⲓ ϫⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲙⲱ⳿ⲩⲥⲏⲥ ⲡⲉ ⲡⲓⲥⲉⲃⲓ ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲓⲟϯ ⲡⲉ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲉⲃⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ⲓⲥϫⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲛⲁϭⲓ ⳿ⲙⲡⲓⲥⲉⲃⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ϩⲓⲛⲁ ϫⲉ ⳿ⲛⲛⲉϥⲃⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲙⲱ⳿ⲩⲥⲏⲥ ⲓⲉ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛϫⲱⲛⲧ ⳿ⲉⲣⲟⲓ ϫⲉ ⲁⲓ⳿ⲑⲣⲉ ⲟⲩⲣⲱⲙⲓ ⲧⲏⲣϥ ⲟⲩϫⲁⲓ ϧⲉⲛ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","⳿ⲙⲡⲉⲣϯϩⲁⲡ ⲕⲁⲧⲁ ϩⲟ ⲁⲗⲗⲁ ⲙⲁϩⲁⲡ ϧⲉⲛ ⲟⲩϩⲁⲡ ⳿ⲙⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⲫⲏⲉⲧⲟⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⳿ⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ϩⲏⲡⲡⲉ ⳿ϥⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓⲁ ⲟⲩⲟϩ ⲥⲉϫⲉ ⳿ϩⲗⲓ ⲛⲁϥ ⲁⲛ ⲙⲏⲡⲱⲥ ⲣⲱ ⲁⲩ⳿ⲉⲙⲓ ⲧⲁ⳿ⲫⲙⲏⲓ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲱⲛ ϫⲉ ⲫⲁⲓ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ⲁⲗⲗⲁ ⲫⲁⲓ ⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲇⲉ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲛⲁ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ⲁϥⲱϣ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲉⲧⲁⲓ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲟⲩⲟϩ ⲛⲉⲧⲁⲓ⳿ⲓ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⲟⲩ⳿ⲑⲙⲏⲓ ⲡⲉ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲫⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","⳿ⲁⲛⲟⲕ ⲇⲉ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲫⲏ ⲡⲉ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ⲛⲁⲩⲕⲱϯ ⲟⲩⲛ ⳿ⲉⲧⲁϩⲟϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲉⲛ ⲛⲉϥϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ϫⲉ ⲟⲩⲏⲓ ⲛⲉ ⳿ⲙⲡⲁⲧⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉϥⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ϩⲁⲛⲙⲏϣ ⲟⲩⲛ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⲙⲏ ⳿ϥⲛⲁⲉⲣ ϩⲟⲩ⳿ⲟ ⲣⲱ ⳿ⲉⲛⲁⲓⲙⲏⲓⲛⲓ ⲉⲧⲁ ⲫⲁⲓ ⲁⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲉⲛⲓⲙⲏϣ ⲉⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⳿ⲛⲛⲁⲓ ⲉⲑⲃⲏⲧϥ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲛϩⲁⲛϩⲩⲡⲏ ⲣⲉⲧⲏⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲧⲁϩⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ϫⲉ ⲉⲧⲓ ⲕⲉⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲭ ⲣⲟⲛⲟⲥ ϯϣⲟⲡ ⲛⲉⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϫⲉⲙⲧ ⲁⲛ ⲟⲩⲟϩ ⳿ⲫⲙⲁ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϣⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ⲡⲉϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲛ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⲁⲣⲉ ⲫⲁⲓ ⲛⲁϣⲉ ⲛⲁϥ ⳿ⲉⲑⲱⲛ ⳿ⲛⲧⲉⲛ⳿ϣⲧⲉⲙϫⲉⲙϥ ⲙⲏ ⳿ϥⲛⲁϣⲉ ⲛⲁϥ ⳿ⲉⲡⲓϫⲱⲣ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲟⲩⲉⲓⲛⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ⲡⲁⲓⲥⲁϫⲓ ⲟⲩ ⲡⲉ ⲉⲧⲁϥϫⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϫⲉⲙⲧ ⲁⲛ ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉ⳿ⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ ⳿ⲛⲧⲉ ⲡⲓⲛⲓϣϯ ⳿ⲛϣⲁⲓ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲛⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲧ⳿ⲟⲃⲓ ⲙⲁⲣⲉϥ⳿ⲓ ϩⲁⲣⲟⲓ ⳿ⲛⲧⲉϥⲥⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲥϫⲟⲥ ⳿ⲛϫⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲉ ϩⲁⲛⲓⲁⲣⲱⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲱⲛϧ ⲉⲑⲛⲁϧⲁϯ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲉϥⲛⲉϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ⲫⲁⲓ ⲇⲉ ⲁϥϫⲟϥ ⲉⲑⲃⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉⲛⲁⲩⲛⲁϭ ⲓⲧϥ ⳿ⲛϫⲉ ⲛⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲛⲉ ⳿ⲙⲡⲁⲧⲉ ⲡ͞ⲛⲁ̅ ⲅⲁⲣ ϣⲱⲡⲓ ⲡⲉ ϫⲉ ⲛⲉ ⳿ⲙⲡⲁⲧⲉ Ⲓⲏ̅ⲥ̅ ϭⲓⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲁ⳿ⲫⲙⲏⲓ ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲡⲉ Ⲡⲭ̅ⲥ̅ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲁⲣⲉ Ⲡⲭ̅ⲥ̅ ⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ⲙⲏ ⲛⲉⲧⲁⲥϫⲟⲥ ⲁⲛ ⳿ⲛϫⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡ⳿ϫⲣⲟϫ ⳿ⲛⲇⲁⲩⲓⲇ ⲡⲉ ⲟⲩⲟϩ ϫⲉ ⲁⲣⲉ Ⲡⲭ̅ⲥ̅ ⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲃⲏⲑⲗⲉⲉⲙ ⲡⲓ ϯⲙⲓ ⳿ⲉⲛⲁⲣⲉ ⲇⲁⲩⲓⲇ ⲭⲏ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ⲟⲩ⳿ⲥⲭⲓⲥⲙⲁ ⲟⲩⲛ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲙⲏ ϣ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲛϧⲏⲧⲟⲩ ⲛⲁⲩⲟⲩⲱϣ ⳿ⲉⲧⲁϩⲟϥ ⲡⲉ ⲁⲗⲗⲁ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ϣⲉⲛ ⲛⲉϥϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ⲁⲩ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ϩⲁ ⲛⲓⲁⲣⲭ ⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ⲁⲩⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉ ⲣⲱⲙⲓ ⲥⲁϫⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ⲁⲩⲉⲣⲟⲩⲱ ⲇⲉ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲁⲣⲉⲧⲉⲛⲥⲱⲣⲉⲙ ϩⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ⲙⲏ ⲁ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲁⲣⲭⲱⲛ ⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲓⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ⲁⲗⲗⲁ ⲡⲁⲓⲙⲏϣ ⲉⲧⲉ⳿ⲛⲥⲉⲥⲱⲟⲩⲛ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲁⲛ ⲥⲉⲭⲏ ϧⲁ ⳿ⲡⲥⲁϩⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ⲡⲉϫⲉ ⲛⲓⲕⲟⲇⲏⲙⲟⲥ ⲛⲱⲟⲩ ⲫⲏⲉⲧⲁϥ⳿Ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϣⲟⲣⲡ ⳿ⲛϫⲱⲣϩ ⳿ⲉⲟⲩⲁⲓ ⲡⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ϫⲉ ⲙⲏ ⲡⲉⲛⲛⲟⲙⲟⲥ ⲛⲁϯϩⲁⲡ ⳿ⲉⲡⲓⲣⲱⲙⲓ ⲁϥ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉⲧⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ⲁⲩⲉⲣⲟⲩⲱ ⲛⲁϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ϩⲱⲕ ϧⲟⲧϧⲉⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲁⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ⲟⲩⲟϩ ⲁⲩϣⲉ ⲛⲱⲟⲩ ⳿ⲉ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲉⲡⲉϥⲙⲁ ");
INSERT INTO copcnt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲡⲓⲧⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϫⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","⳿ⲓⲧⲁ ⲁϥ⳿ⲓ ⳿ⲛϩⲁⲛ⳿ⲁⲧⲟⲟⲩ⳿ⲓ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲛⲓⲙⲏ ϣ ⲇⲉ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲁϥϩⲉⲙⲥⲓ ⳿ⲉϯ ⳿ⲥⲃⲱ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲁⲩ⳿ⲓⲛⲓ ⲛⲁϥ ⳿ⲛⲟⲩ⳿ⲥϩⲓⲙⲓ ⲁⲩϫⲉⲙⲥ ϧⲉⲛ ⲟⲩⲡⲟⲣⲛⲓ⳿ⲁ ⲟⲩⲟϩ ⲁⲩⲧⲁϩⲟⲥ ⳿ⲉⲣⲁⲧⲥ ϧⲉⲛ ⳿ⲑⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⲧⲁⲓ⳿ⲥϩⲓⲙⲓ ⲑⲁⲓ ⲁⲛϫⲉⲙⲥ ϧⲉⲛ ⲟⲩⲡⲟⲣⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ⲟⲩⲟϩ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲙⲱ⳿ⲩⲥⲏⲥ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉϩⲓⲱⲛⲓ ⳿ⲉϫⲱⲥ ⲟⲩ ⲡⲉ ⲇⲉ ⲉⲧⲉⲕϫⲱ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ⲫⲁⲓ ⲇⲉ ⲁⲩϫⲱϥ ⲉⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϫⲉⲙ ⲗⲱⲓϫⲓ ϩⲓϫⲱϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲣⲓⲕⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⲁϥ⳿ⲥϧⲁⲓ ⳿ⲙⲡⲉϥⲧⲏⲃ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ⲉⲧⲁⲩⲱⲥⲕ ⲇⲉ ⳿ⲙⲡⲉϥⲉⲣⲟⲩⲱ ⲁϥϥⲁⲓ ⳿ⲛⲧⲉϥ⳿ⲁⲫⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲙ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁϭⲛⲉ ⲛⲟⲃⲓ ⲙⲁⲣⲉϥϩⲓⲱⲛⲓ ⳿ⲉϫⲱⲥ ⳿ⲛϣⲟⲣⲡ ⳿ⲛⲟⲩⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ⲧⲟⲧⲉ ⲁϥⲣⲉⲕ ϫⲱϥ ⲟⲩⲟϩ ⲁϥ⳿ⲥϧⲁⲓ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲫⲁⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⲁⲩⲕⲁϯ ⳿ⲉⲡⲉϥⲥⲟϩⲓ ⲁⲩⲉⲣϩⲏⲧⲥ ⳿ⲛ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ϣⲁⲧⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲡⲟⲩⲙⲏϣ ⲟⲩⲟϩ ⲁϥⲥⲱϫⲡ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲉⲙ ϯ⳿ⲥϩⲓⲙⲓ ⲑⲏ ⳿ⲉⲛⲁⲥⲭⲏ ϧⲉⲛ ⳿ⲑⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ⲁ Ⲓⲏ̅ⲥ̅ ϥⲁⲓ ⳿ⲛⲧⲉϥ⳿ⲁⲫⲉ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲱ ϯ⳿ⲥϩⲓⲙⲓ ⲁⲩⲑⲱⲛ ⲛⲏⲉⲧⲁⲩϯϩⲁⲡ ⳿ⲉⲣⲟ ⳿ⲙⲙⲟⲛ ⲟⲩⲁⲓ ⲉϥϯϩⲁⲡ ⳿ⲉⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ϯⲛⲁⲩ ⲁⲛ ⳿ⲉⲟⲩⲁⲓ ⲡⲁ⳪ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⲉⲓ ϯϩⲁⲡ ⳿ⲉⲣⲟ ⲙⲁϣⲉ ⲛⲉ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⳿ⲙⲡⲉⲣⲧⲁⲥⲑⲟ ⳿ⲉⲉⲣⲛⲟⲃⲓ ϫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲫⲏⲉⲑⲛⲁⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ⳿ⲛⲛⲉϥⲙⲟϣⲓ ϧⲉⲛ ⲡⲓⲭⲁⲕⲓ ⲁⲗⲗⲁ ⲉϥ⳿ⲉϭⲓ ⳿ⲙ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ⲡⲉϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲟⲩⲛ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲉⲧⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲕ ⲧⲉⲕⲙⲉⲧⲙⲉⲑⲣⲉ ⲟⲩⲙⲏⲓ ⲁⲛ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲕⲁⲛ ⳿ⲉϣⲱⲡ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲓ ⲟⲩⲙⲏⲓ ⲧⲉ ⲧⲁⲙⲉⲧⲙⲉⲑⲣⲉ ϫⲉ ϯ⳿ⲉⲙⲓ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲟⲩⲟϩ ⲁⲓⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲑⲱⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲉⲧⲁⲓ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲓⲉ ⲁⲓⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","⳿ⲛⲑⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛϯϩⲁⲡ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⳿ⲁⲛⲟⲕ ⲇⲉ ϯϯϩⲁⲡ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ⲟⲩⲟϩ ⳿ⲉϣⲱⲡ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛϯϩⲁⲡ ⲡⲁϩⲁⲡ ⳿ⲁⲛⲟⲕ ⲟⲩⲙⲏⲓ ⲡⲉ ϫⲉ ⳿ⲛϯⲭⲏ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⲛⲉⲙ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ⲟⲩⲟϩ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲇⲉ ⲟⲛ ϧⲉⲛ ⲡⲉⲧⲉⲛⲛⲟⲙⲟⲥ ϫⲉ ⳿ⲑⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲣⲱⲙⲓ ⲃ̅ ⲟⲩ⳿ⲑⲙⲏⲓ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","⳿ⲁⲛⲟⲕ ϯⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ϥⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲓ ⳿ⲛϫⲉ ⳿ⲫⲓⲱⲧ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲁϥⲑⲱⲛ ⲡⲉⲕⲓⲱⲧ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲛⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⲁⲛ ⲟⲩⲇⲉ ⲡⲁⲕⲉⲓⲱⲧ ⳿ⲉⲛⲁⲣⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⲛⲁⲣⲉⲧⲉⲛⲛⲁⲥⲟⲩⲉⲛ ⲡⲁⲕⲉⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ⲛⲁⲓⲥⲁϫⲓ ⲁϥϫⲟⲧⲟⲩ ϧⲉⲛ ⲡⲓⲅⲁⲍⲟⲫⲩⲗⲁⲕⲓⲟⲛ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ϣ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⲛⲉ ⳿ⲙⲡⲁⲧⲉⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉϥⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ⲡⲁⲗⲓⲛ ⲟⲛ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁϣⲉ ⲛⲏⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϫⲉⲙⲧ ⲁⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲙⲟⲩ ϧⲉⲛ ⲛⲉⲧⲉⲛⲛⲟⲃⲓ ⲟⲩⲟϩ ⲡⲓⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉ⳿ⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⲙⲏ ⲁϥⲛⲁϧⲟⲑⲃⲉϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ϫⲉ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲓⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϣⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⲡⲉ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ϧⲣⲏⲓ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡϣⲱⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ⲁⲓϫⲟⲥ ⲟⲩⲛ ⲛⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲙⲟⲩ ϧⲉⲛ ⲛⲉⲧⲉⲛⲛⲟⲃⲓ ⳿ⲉϣⲱⲡ ⲅⲁⲣ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲛⲁϩϯ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲧⲉⲧⲉⲛⲛⲁⲙⲟⲩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲉⲧⲉⲛⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲡⲉ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛϯⲁⲣⲭⲏ ⲁⲓⲉⲣ ⳿ⲡⲕⲉⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ⲟⲩⲟⲛϯ ⲟⲩⲙⲏϣ ⳿ⲉϫⲟⲧⲟⲩ ⲉⲑⲃⲉ ⲑⲏ ⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲉϯϩⲁⲡ ⲁⲗⲗⲁ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲟⲩ⳿ⲑⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⲛⲏⲉⲧⲁⲓⲥⲟⲑⲙⲟⲩ ⳿ⲛⲧⲟⲧϥ ⲛⲁⲓ ϯⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ϫⲉ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉⲑⲃⲉ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛϣⲁⲛϭ ⲉⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲧⲟⲧⲉ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲟⲩⲟϩ ϯⲉⲣ ⳿ϩⲗⲓ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥ⳿ⲧⲥⲁⲃⲟⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲛⲁⲓ ϯⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ⲟⲩⲟϩ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ϥⲭⲏ ⲛⲉⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲭⲁⲧ ⳿ⲙⲙⲁⲩⲁⲧ ϫⲉ ⳿ⲁⲛⲟⲕ ϯ⳿ⲓⲣⲓ ⳿ⲛⲛⲏⲉⲑⲣⲁⲛⲁϥ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ⲛⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ϩⲁⲛⲙⲏϣ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ⲛⲁϥϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲉϣⲱⲡ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲟϩⲓ ϧⲉⲛ ⲡⲁⲥⲁϫⲓ ⲧⲁ⳿ⲫⲙⲏⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟⲩⲉⲛ ⳿ⲑⲙⲏⲓ ⲟⲩⲟϩ ⲉⲣⲉ ⳿ⲑⲙⲏⲓ ⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛⲣⲉⲙϩⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ⲁⲩⲉⲣⲟⲩⲱ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲛ ⲛⲁ ⳿ⲡ⳿ⲥⲡⲉⲣⲙⲁ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲛⲉⲣⲃⲱⲕ ⳿ⲛ⳿ϩⲗⲓ ⲉⲛⲉϩ ⲡⲱⲥ ⳿ⲛⲑⲟⲕ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲣⲉⲧⲉⲛⲉⲣⲣⲉⲙϩⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⲟⲩⲃⲱⲕ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ⲡⲓⲃⲱⲕ ⲇⲉ ⳿ⲙⲡⲁϥⲟϩⲓ ϧⲉⲛ ⲡⲓⲏⲓ ϣⲁ ⲉⲛⲉϩ ⲡⲓϣⲏⲣⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ϣⲁϥⲟϩⲓ ϣⲁ ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","⳿ⲉϣⲱⲡ ⲟⲩⲛ ⲁⲣⲉϣⲁⲛ ⲡⲓϣⲏⲣⲓ ⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛⲣⲉⲙϩⲉ ⲟⲛⲧⲱⲥ ⲧⲉⲧⲉⲛⲛⲁⲉⲣⲣⲉⲙϩⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ϯ⳿ⲉⲙⲓ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁ ⳿ⲡ⳿ϫⲣⲟϫ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲁⲗⲗⲁ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⳿ⲉϧⲟⲑⲃⲏⲧ ϫⲉ ⲡⲁⲥⲁϫⲓ ϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ⲛⲏ ⲟⲩⲛ ⳿ⲁⲛⲟⲕ ⲉⲧⲁⲓⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲁⲓⲱⲧ ⲛⲁⲓ ϯⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲏⲉⲧⲁⲣⲉⲧⲉⲛⲥⲟⲑⲙⲟⲩ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲉⲧⲉⲛⲓⲱⲧ ⲧⲉⲧⲉⲛ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ⲁⲩⲉⲣⲟⲩⲱ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲡⲉⲛⲓⲱⲧ ⲁⲃⲣⲁⲁⲙ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲉⲛⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲡⲉ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲁⲃⲣⲁⲁⲙ ⲛⲁⲣⲉⲧⲉⲛⲛⲁⲁⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ϯⲛⲟⲩ ⲇⲉ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⳿ⲉϧⲟⲑⲃⲏ ⲧ ⲟⲩⲣⲱⲙⲓ ⲉϥϫⲱ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲛⲱⲧⲉⲛ ⲑⲏ ⲉⲧⲁⲓⲥⲟⲑⲙⲉⲥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲫϯ ⲫⲁⲓ ⳿ⲙⲡⲉ ⲁⲃⲣⲁⲁⲙ ⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛ⳿ⲓⲣⲓ ⳿ⲛⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛ⳿ϫⲫⲟ ⲁⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲡⲟⲣⲛⲓ⳿ⲁ ⲟⲩⲓⲱⲧ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲉⲧⲉ⳿ⲛⲧⲁⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲉⲛⲉ ⲫϯ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲡⲉ ⲛⲁⲣⲉⲧⲉⲛⲛⲁⲙⲉⲛⲣⲓⲧ ⲡⲉ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ⲟⲩⲟϩ ⲁⲓ⳿ⲓ ⲟⲩ ⲅⲁⲣ ⲛⲉⲧⲁⲓ⳿ⲓ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ⲉⲑⲃⲉⲟⲩ ⲧⲁϫⲓⲛⲥⲁϫⲓ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲟⲩⲟϩ ⲛⲓ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲉⲁⲓⲧⲟⲩ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉ ⲟⲩⲣⲉϥϧⲁⲧⲉⲃ ⲣⲱⲙⲓ ⲡⲉ ⲓⲥϫⲉⲛ ϩⲏ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⳿ⲑⲙⲏⲓ ⲉⲛⲉϩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲙⲉⲑⲙⲏⲓ ϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓⲙⲉⲑⲛⲟⲩϫ ϣⲁϥⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲧⲉⲛⲟⲩϥ ϫⲉ ⲟⲩⲥⲁⲙⲉⲑⲛⲟⲩϫ ⲡⲉ ⲛⲉⲙ ⲡⲉϥⲕⲉⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϫⲱ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲛⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ⲛⲓⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲑⲛⲁⲥⲟϩⲓ ⳿ⲙⲙⲟⲓ ⲉⲑⲃⲉ ⲟⲩⲛⲟⲃⲓ ⲓⲥϫⲉ ⳿ⲑⲙⲏⲓ ⲧⲉϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲓⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ⲡⲓ⳿ⲉⲃⲟⲗ ⳿ⲙⲫϯ ⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ϣⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲉⲑⲃⲉⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙⲫϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ⲁⲩⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲕⲁⲗⲱⲥ ⳿ⲁⲛⲟⲛ ⲁⲛϫⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲥⲁⲙⲁⲣⲓⲧⲏⲥ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲙⲟⲛ ⲇⲉⲙⲱⲛ ⲛⲉⲙⲏⲓ ⲁⲗⲗⲁ ϯⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛϣⲱϣ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","⳿ⲁⲛⲟⲕ ⲇⲉ ⲛⲁⲓⲕⲱϯ ⳿ⲛⲥⲁ ⲡⲁⲱⲟⲩ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲛ ⳿ϥϣⲟⲡ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲕⲱϯ ⲟⲩⲟϩ ⲉⲧϯϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲉϣⲱⲡ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲁⲣⲉϩ ⳿ⲉⲡⲁⲥⲁϫⲓ ⳿ⲛⲛⲉϥⲛⲁⲩ ⳿ⲉ⳿ⲫⲙⲟⲩ ϣⲁ ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ⲡⲉϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ϯⲛⲟⲩ ⲁⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁⲕ ⲁⲃⲣⲁⲁⲙ ⲁϥⲙⲟⲩ ⲛⲉⲙ ⲛⲓⲕⲉ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ⲕϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏⲉⲑⲛⲁⲁⲣⲉϩ ⳿ⲉⲡⲁⲥⲁϫⲓ ⳿ⲛⲛⲉϥϫⲉⲙϯⲡⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ϣⲁ ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ⲙⲏ ⳿ⲛⲑⲟⲕ ⲟⲩⲛⲓϣϯ ⳿ⲛⲑⲟⲕ ⳿ⲉⲡⲉⲛⲓⲱⲧ ⲁⲃⲣⲁⲁⲙ ⲫⲏⲉⲧⲁϥⲙⲟⲩ ⲟⲩⲟϩ ⲛⲓⲕⲉ⳿ⲡⲣⲟⲫⲏ ⲧⲏⲥ ⲁⲩⲙⲟⲩ ⲁⲕ⳿ⲓⲣⲓ ⳿ⲙⲙⲟⲕ ⳿ⲛⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉϣⲱⲡ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲁⲛϯⲱⲟⲩ ⲛⲏⲓ ⳿ⲙⲙⲁⲩⲁⲧ ⲡⲁⲱⲟⲩ ⳿ϩⲗⲓ ⲡⲉ ⳿ϥϣⲟⲡ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲉⲑⲛⲁ ϯⲱⲟⲩ ⲛⲏⲓ ⲫⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛⲛⲟⲩϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲥⲟⲩⲱⲛϥ ⳿ⲁⲛⲟⲕ ⲇⲉ ϯ ⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲓϣⲁⲛϫⲟⲥ ϫⲉ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⲉⲓ⳿ⲉϣⲱⲡⲓ ⲉⲓ⳿ⲟⲛⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲥⲁⲙⲉⲑⲛⲟⲩϫ ⲁⲗⲗⲁ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲡⲉϥⲥⲁϫⲓ ϯ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ⲁⲃⲣⲁⲁⲙ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲛⲁϥⲑⲉⲗⲏⲗ ⲡⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲟⲩ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲏⲓ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⲁϥⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ⲡⲉϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲁϥ ϫⲉ ⳿ⲙⲡⲁⲧⲉⲕⲉⲣ ⲛ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲟⲩⲟϩ ⲁⲕⲛⲁⲩ ⳿ⲉⲁⲃⲣⲁⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲡⲁⲧⲉ ⲁⲃⲣⲁⲁⲙ ϣⲱⲡⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ⲁⲩⲉⲗ ⲱⲛⲓ ⲟⲩⲛ ϩⲓⲛⲁ ⳿ⲛⲥⲉϩⲓⲟⲩ⳿Ⲓ ⳿ⲉϫⲱϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲭⲟⲡϥ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁϥⲥⲓⲛⲓ ⲛⲁϥⲙⲟϣⲓ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲟⲩⲟϩ ⲛⲁϥⲥⲓⲛⲓⲱⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ⲟⲩⲟϩ ⲉϥⲥⲓⲛⲓ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⳿ⲙⲙⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ⲟⲩⲟϩ ⲁⲩϣⲉⲛϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲣⲁⲃⲃⲓ ⲛⲓⲙ ⲡⲉⲧⲁϥⲉⲣⲛⲟⲃⲓ ⲫⲁⲓ ⲡⲉ ϣⲁⲛ ⲛⲉϥⲓⲟϯ ⲛⲉ ϫⲉ ⲁⲩⲙⲁⲥϥ ⲉϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲟⲩⲇⲉ ⲫⲁⲓ ⳿ⲙⲡⲉϥⲉⲣⲛⲟⲃⲓ ⲟⲩⲇⲉ ⲛⲉϥⲓⲟϯ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛ⳿ϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","⳿ⲁⲛⲟⲛ ϩⲱϯ ⳿ⲉⲣⲟⲛ ⲡⲉ ⳿ⲛⲧⲉⲛⲉⲣϩⲱⲃ ⳿ⲉⲛⲓ⳿ϩⲃⲏ ⲟⲩ⳿ⲓ ⳿ⲛⲧⲉ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲛ ϩⲱⲥ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲡⲉ ⳿ϥⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉϫⲱⲣϩ ϩⲟⲧⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⲉⲣϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ϩⲱⲥ ⲉⲓϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲑⲁϥ ⳿ⲉⲡⲉⲥⲏ ⲧ ⲟⲩⲟϩ ⲁϥⲑⲁⲙⲓ⳿ⲟ ⳿ⲛⲟⲩⲟⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲑⲁϥ ⲟⲩⲟϩ ⲁϥⲗⲁⲗⲱϥ ⳿ⲉⲛⲉⲛⲃⲁⲗ ⳿ⲙⲡⲓⲃⲉⲗⲗⲉ ⳿ⲙⲙⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⲓⲁ ⲡⲉⲕϩⲟ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲕⲟⲗⲩⲙⲃⲏⲑⲣⲁ ⳿ⲛⲧⲉ ⲡⲓⲥⲓⲗⲱⲁⲙ ⲫⲏ ⳿ⲉϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ ⲫⲏⲉⲧⲁⲩⲟⲩⲟⲣⲡϥ ⲁϥϣⲉ ⲛⲁϥ ⲟⲩⲛ ⲁϥⲓⲱⲓ ⳿ⲙⲡⲉϥϩⲟ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⲉϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ⲛⲉϥⲑⲉϣⲉⲩ ⲟⲩⲛ ⲛⲉⲙ ⲛⲏⲉⲧⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϣⲟⲣⲡ ϫⲉ ⲛⲉ ⲟⲩϣⲁⲧ ⲙⲉⲑⲛⲁⲓ ⲡⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⲫⲏ ⳿ⲉⲛⲁϥϩⲉⲙⲥⲓ ⲉϥϣⲁⲧ ⲙⲉⲑⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟϥ ⲡⲉ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⲁⲗⲗⲁ ⲁϥ⳿ⲟⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲡⲉ ϫⲉ ⲡⲱⲥ ⲁⲩⲟⲩⲱⲛ ⳿ⲛϫⲉ ⲛⲉⲕⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲉϫⲁϥ ϫⲉ ⲡⲓⲣⲱⲙⲓ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲑⲁⲙⲓ⳿ⲟ ⳿ⲛⲟⲩⲟⲙⲓ ⲁϥⲗⲁⲗⲱϥ ⳿ⲉⲛⲁⲃⲁⲗ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲏⲓ ϫⲉ ⲙⲁϣⲉ ⲛⲁⲕ ⲓⲁ ⲡⲉⲕϩⲟ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲥⲓⲗⲱⲁⲙ ⲁⲓϣⲉ ⲛⲏⲓ ⲟⲩⲛ ⲁⲓⲓⲱⲓ ⳿ⲙⲡⲁϩⲟ ⳿ⲉⲃⲟⲗ ⲁⲓⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲁϥⲑⲱⲛ ϩⲱϥ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲉϫⲁϥ ϫⲉ ϯ⳿ⲉⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ⲁⲩ⳿ⲉⲛϥ ⲟⲩⲛ ϩⲁ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲫⲏ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⳿ⲛⲟⲩⲥⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ⲛⲉ ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲇⲉ ⲡⲉⲧⲁϥⲑⲁⲙⲓ⳿ⲟ ⳿ⲙⲡⲓⲟⲙⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁϥ⳿ⲑⲣⲉ ⲛⲉϥⲃⲁⲗ ⲟⲩⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ⲡⲁⲗⲓⲛ ⲟⲩⲛ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲡⲱⲥ ⲁⲕⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲟⲙⲓ ⲡⲉⲧⲁϥⲭⲁϥ ⳿ⲉϫⲉⲛ ⲛⲁⲃⲁⲗ ⲟⲩⲟϩ ⲁⲓⲓⲁⲧ ⳿ⲉⲃⲟⲗ ⲁⲓⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲛⲟⲩ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲁⲛ ⲡⲉ ϫⲉ ⳿ⲛ⳿ϥⲁⲣⲉϩ ⲁⲛ ⳿ⲉⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲉⲣ ⲛⲁⲓⲙⲏⲓⲛⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲭⲓⲥⲙⲁ ⲛⲁϥϣⲟⲡ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ⲡⲁⲗⲓⲛ ⲟⲩⲛ ⲡⲉϫⲱⲟⲩ ⳿ⲙⲡⲓⲃⲉⲗⲗⲉ ϫⲉ ⲟⲩ ⳿ⲛⲑⲟⲕ ⲉⲧⲉⲕϫⲱ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲏⲧϥ ϫⲉ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲉⲕⲃⲁⲗ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","⳿ⲙⲡⲟⲩⲧⲉⲛϩⲟⲩⲧϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⲛⲁϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⲡⲉ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ϣⲁⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲛⲉϥⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩϣⲉⲛⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛ ⲫⲁⲓ ⲡⲉ ⲡⲉⲧⲉⲛϣⲏⲣⲓ ⲫⲏⲉⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛⲙⲁⲥϥ ⲉϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⲡⲱⲥ ϫⲉ ϯⲛⲟⲩ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ⲁⲩⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲡⲉⲛϣⲏⲣⲓ ⲟⲩⲟϩ ϫⲉ ⲁⲛⲙⲁⲥϥ ⲉϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ⲡⲱⲥ ϫⲉ ϯⲛⲟⲩ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲓⲉ ⲛⲓⲙ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲁⲛⲟⲛ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϣⲉⲛϥ ⲧⲉϥⲙⲁⲓⲏ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ϩⲱϥ ⳿ⲉⲥⲁϫⲓ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ⲛⲁⲓ ⲁⲩϫⲟⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ ⳿ⲉⲡⲓⲇⲏ ⲛⲁⲩⲉⲣϩⲟϯ ⲡⲉ ϧⲁ⳿ⲧϩⲏ ⳿ⲛⲛⲓⲟⲩⲇⲁⲓ ⲛⲉ ⲁⲩⲥⲉⲙⲛⲏ ⲧⲥ ⲅⲁⲣ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϩⲓⲛⲁ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ ⳿ⲛⲧⲟⲩⲁⲓϥ ⳿ⲛⲁⲡⲟⲥⲩⲛⲁⲅⲱⲅⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ⲉⲑⲃⲉⲫⲁⲓ ⲁⲩϫⲟⲥ ⳿ⲛϫⲉ ⲛⲉϥⲓⲟϯ ϫⲉ ⲧⲉϥⲙⲁⲓⲏ ⳿ⲛⲧⲁϥ ϩⲱϥ ϣⲉⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ⲁⲩⲙⲟⲩϯ ⲟⲩⲛ ⳿ⲉⲡⲓⲣⲱⲙⲓ ⳿ⲙ⳿ⲫⲙⲁϩⲥⲟⲡ ⲃ̅ ⲫⲁⲓ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲙⲁ⳿ⲱⲟⲩ ⳿ⲙⲫϯ ⳿ⲁⲛⲟⲛ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲡⲁⲓⲣⲱⲙⲓ ⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲡⲉ ⳿ⲛϯ⳿ⲉⲙⲓ ⲁⲛ ⲟⲩⲁⲓ ⲇⲉ ⲡⲉϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲛⲁⲓⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⲡⲉ ϯⲛⲟⲩ ⲇⲉ ϯⲛⲁⲩ ⳿ⲙⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲟⲩ ⲡⲉⲧⲁϥⲁⲓϥ ⲛⲁⲕ ⲡⲱⲥ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲉⲕⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲇⲏ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⲟⲩ ⲟⲛ ⲉⲧⲉⲧⲉⲛⲟⲩⲱϣ ⳿ⲉⲥⲟⲑⲙⲉϥ ⲙⲏ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ϩⲱⲧⲉⲛ ⳿ⲉⲉⲣⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϩⲱⲟⲩϣ ⳿ⲉⲣⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲁⲛⲟⲛ ⲇⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ ⲙⲱ⳿ⲩⲥⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","⳿ⲁⲛⲟⲛ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲁ ⲫϯ ⲥⲁϫⲓ ⲛⲉⲙ ⲙⲱ⳿ⲩⲥⲏⲥ ⲫⲁⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲑⲁⲓ ⲣⲱ ⲧⲉ ϯ⳿ϣⲫⲏⲣⲓ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ϫⲉ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ ⲡⲉ ⲟⲩⲟϩ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲁⲃⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲙⲡⲁⲣⲉ ⲫϯ ⲥⲱⲧⲉⲙ ⳿ⲉϩⲁⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⲁⲗⲗⲁ ⳿ⲉϣⲱⲡ ⳿ⲉⲟⲩϣⲁⲙϣⲉ ⲛⲟⲩϯ ⲡⲉ ⲟⲩⲁⲓ ⲟⲩⲟϩ ⲉϥ⳿ⲓⲣⲓ ⳿ⲙⲡⲉϥⲟⲩⲱϣ ⲫⲁⲓ ϣⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ⲓⲥϫⲉⲛ ⳿ⲡ⳿ⲉⲛⲉϩ ⳿ⲙⲡⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲁ ⲟⲩⲁⲓ ⲟⲩⲱⲛ ⳿ⲛⲛⲉⲛⲃⲁⲗ ⳿ⲛⲟⲩⲃⲉⲗⲗⲉ ⳿ⲙⲙⲓⲥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","⳿ⲉⲛⲉ ⲫⲁⲓ ⲟⲩ⳿ⲉⲃⲟⲗ ⳿ⲙⲫϯ ⲁⲛ ⲡⲉ ⲛⲁϥⲛⲁ⳿ϣϫⲉⲙϫⲟⲙ ⲁⲛ ⲡⲉ ⳿ⲉⲉⲣ ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ⲁⲩⲉⲣⲟⲩⲱ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ϫⲫⲟ ⲧⲏⲣⲕ ϧⲉⲛ ⳿ⲫⲛⲟⲃⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲟⲕ ⲉⲑⲛⲁϯ⳿ⲥⲃⲱ ⲛⲁⲛ ⲟⲩⲟϩ ⲁⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲩϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲧⲁϥϫⲉⲙϥ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲭⲛⲁϩϯ ⳿ⲛⲑⲟⲕ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲡⲁ⳪ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲭⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲫⲏ ⲡⲉ ⲉⲧⲥⲁϫⲓ ⲛⲉⲙⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ϯⲛⲁϩϯ ⲡⲁ⳪ ⲟⲩⲟϩ ⲁϥⲟⲩⲱϣⲧ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ⲟⲩⲟϩ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲁⲛⲟⲕ ⲉⲩϩⲁⲡ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲓⲛⲁ ⲛⲏⲉⲧⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲛⲧⲟⲩⲉⲣⲃⲉⲗⲗⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲛⲧⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲉⲧⲭⲏ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲙⲏ ⳿ⲁⲛⲟⲛ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ϩⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲉⲛⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲃⲉⲗⲗⲉⲩ ⲡⲉ ⲛⲉ⳿ⲙⲙⲟⲛⲧⲉⲧⲉⲛ ⲛⲟⲃⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ ϯⲛⲟⲩ ⲇⲉ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲛⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⳿ϥϣⲟⲡ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛⲛⲟⲃⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲣⲟ ⳿ⲉϯⲁⲩⲗⲏ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲁⲗⲗⲁ ⲉϥⲛⲏⲟⲩ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲛϭⲟϥⲧⲉⲛ ⲫⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲣⲉϥ ϭⲓⲟⲩ⳿ⲓ ⲡⲉ ⲟⲩⲟϩ ⲟⲩⲥⲟⲛⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ⲫⲏ ⲇⲉ ⲉⲑⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲣⲟ ⲫⲁⲓ ⲟⲩⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲡⲉ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ⲫⲁⲓ ϣⲁⲣⲉ ⲡⲓⲉⲙⲛⲟⲩϯ ⲟⲩⲱⲛ ⲛⲁϥ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲥⲱⲧⲉⲙ ⳿ⲉⲧⲉϥ⳿ⲥⲙⲏ ⲟⲩⲟϩ ϣⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲉϥ⳿ⲉⲥⲱⲟⲩ ⲕⲁⲧⲁ ⲛⲟⲩⲣⲁⲛ ⲟⲩⲟϩ ϣⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛ⳿ⲓⲛⲓ ⳿ⲛⲛⲏⲉⲧⲉⲛⲟⲩϥ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ϣⲁϥⲙⲟϣⲓ ϧⲁϫⲱⲟⲩ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ϫⲉ ⲟⲩⲏⲓ ⲥⲉⲥⲱⲟⲩⲛ ⳿ⲛⲧⲉϥ⳿ⲥⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ⲡⲓϣⲉⲙⲙⲟ ⲇⲉ ⳿ⲙⲡⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲁⲗⲗⲁ ⲉⲩ⳿ⲉⲫⲱⲧ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ϫⲉ ⲥⲉⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙⲡⲓϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ⲧⲁⲓⲡⲁⲣⲟⲓⲙⲓ⳿ⲁ ⲁϥϫⲟⲥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ϫⲉ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉⲑⲃⲉⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ⲡⲁⲗⲓⲛ ⲟⲛ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓ⳿ⲥⲃⲉ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩ⳿ⲓ ϧⲁϫⲱⲓ ϩⲁⲛⲥⲟⲛⲓ ⲛⲉ ⲟⲩⲟϩ ϩⲁⲛⲣⲉϥϭⲓⲟⲩ⳿ⲓ ⲛⲉ ⲁⲗⲗⲁ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓ⳿ⲥⲃⲉ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲫⲏⲉⲑⲛⲁ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ ⲟⲩⲟϩ ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲟⲩⲙⲁ⳿ⲙⲙⲟⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ⲡⲓⲣⲉϥϭⲓⲟⲩ⳿ⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ⲙⲡⲁϥ⳿ⲓ ⳿ⲉⲃⲏⲗ ⲁⲣⲏⲟⲩ ⳿ⲛⲧⲉϥϭⲓⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϣⲱⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲁⲕⲟ ⳿ⲁⲛⲟⲕ ⲉⲧⲁⲓ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲱⲛϧ ϣⲱⲡⲓ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲟⲩϩⲟⲩ⳿ⲟ ϣⲱⲡⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲉⲑⲛⲁⲛⲉϥ ⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲉⲑⲛⲁⲛⲉϥ ϣⲁϥϯ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲉϥ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ⲡⲓⲣⲉⲙⲃⲉⲭⲉ ⲇⲉ ⳿ⲛⲑⲟϥ ⲟⲩⲟϩ ⲉⲧⲉ⳿ⲛⲟⲩⲙⲁⲛⲉⲥⲱⲟⲩ ⲁⲛ ⲡⲉ ⲫⲏⲉⲧⲉ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲛⲟⲩϥ ⲁⲛ ⲛⲉ ⲁϥϣⲁⲛⲛⲁⲩ ⳿ⲉⲡⲓⲟⲩⲱⲛϣ ⲉϥⲛⲏⲟⲩ ϣⲁϥⲫⲱⲧ ⲟⲩⲟϩ ϣⲁϥⲭⲁ ⲛⲓ⳿ⲉⲥⲱⲟⲩ ⲟⲩⲟϩ ϣⲁⲣⲉ ⲡⲓⲟⲩⲱⲛϣ ϩⲟⲗⲙⲟⲩ ⲟⲩⲟϩ ϣⲁϥϫⲟⲣⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ϫⲉ ⲟⲩⲣⲉⲙⲃⲉⲭⲉ ⲡⲉ ⲟⲩⲟϩ ⳿ⲥⲉⲣⲙⲉⲗⲓⲛ ⲛⲁϥ ⲁⲛ ϧⲁ ⲛⲓ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⲉⲑⲛⲁⲛⲉϥ ϯⲥⲱⲟⲩⲛ ⳿ⲛⲛⲏⲉⲧⲉⲛⲟⲩⲓ ⲟⲩⲟϩ ⲛⲏⲉⲧⲉⲛⲟⲩ⳿Ⲓ ⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲥⲱⲟⲩⲛ ⳿ⲙ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ϯⲛⲁⲭⲱ ⳿ⲛⲧⲁⲯⲩⲭⲏ ⳿ⲉϫⲉⲛ ⲛⲁ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ⲟⲩⲟⲛ ⳿ⲛⲧⲏⲓ ⳿ⲛϩⲁⲛⲕⲉ⳿ⲉⲥⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲉϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲁⲓⲁⲩⲗⲏ ⲁⲛ ⲛⲉ ϩⲱϯ ⳿ⲉⲣⲟⲓ ⳿ⲉ⳿ⲉⲛ ⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲧⲁ⳿ⲥⲙⲏ ⲟⲩⲟϩ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲉⲩⲟϩⲓ ⳿ⲛⲟⲩⲱⲧ ⲟⲩⲙⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲛⲟⲩⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ⲉⲑⲃⲉⲫⲁⲓ ⳿ϥⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲭⲱ ⳿ⲛⲧⲁⲯⲩⲭⲏ ϩⲓⲛⲁ ⲟⲛ ⳿ⲛⲧⲁϭⲓⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲱⲗⲓ ⳿ⲙⲙⲟⲥ ⳿ⲛⲧⲟⲧ ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⲉⲧⲭⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲟⲩⲟⲛϯ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉ ⲭⲁⲥ ⲟⲩⲟⲛϯ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⲟⲛ ⳿ⲉϭⲓⲧⲥ ⲑⲁⲓ ⲧⲉ ϯ⳿ⲉⲛⲧⲟⲗⲏ ⲉⲧⲁⲓϭⲓⲧⲥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ⲟⲩ⳿ⲥⲭⲓⲥⲙⲁ ⲟⲩⲛ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲑⲃⲉ ⲛⲁⲓⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ϩⲁⲛⲙⲏϣ ⲇⲉ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲏⲧⲟⲩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⳿ϥⲗⲟⲃⲓ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓⲥⲁϫⲓ ⲛⲁ ⲟⲩⲣⲱⲙⲓ ⲁⲛ ⲛⲉ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲇⲉⲙⲱⲛ ⲛⲉⲙⲁϥ ⲙⲏ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲟⲩⲇⲉⲙⲱⲛ ⳿ⲉⲁⲟⲩⲱⲛ ⳿ⲛⲛⲉⲛⲃⲁⲗ ⳿ⲛϩⲁⲛⲃⲉⲗⲗⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ⲁϥϣⲱⲡⲓ ⳿ⲙⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲟⲩⲁⲓⲕ ϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉ ⳿ⲧ⳿ⲫⲣⲱ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ⲟⲩⲟϩ ⲛⲁϥⲙⲟϣⲓ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ϧⲁ ϯ⳿ⲥⲧⲟⲁ ⳿ⲛⲧⲉ ⲥⲟⲗⲟⲙⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ⲁⲩⲧⲁⲕⲧⲟ ⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ϣⲁ ⳿ⲑⲛⲁⲩ ⳿ⲕⲱⲗⲓ ⳿ⲛⲧⲉⲛⲯⲩⲭⲏ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲁϫⲟⲥ ⲛⲁⲛ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⲁⲛ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲁⲓⲱⲧ ⳿ⲛⲑⲱⲟⲩ ⲉⲧⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ⲁⲗⲗⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁ⳿ⲉⲥⲱⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ⲛⲁ⳿ⲉⲥⲱⲟⲩ ⳿ⲁⲛⲟⲕ ϣⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲧⲁ⳿ⲥⲙⲏ ⲟⲩⲟϩ ϣⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲛⲁϯ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ⲟⲩⲟϩ ⳿ⲛⲛⲟⲩⲧⲁⲕⲟ ϣⲁ ⲉⲛⲉϩ ⲟⲩⲟϩ ⳿ⲛⲛⲉ⳿ϣ ⳿ϩⲗⲓ ϩⲟⲗⲙⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲁϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ⲫⲏⲉⲧⲁ ⲡⲁⲓⲱⲧ ⲧⲏⲓϥ ⲛⲏⲓ ⲟⲩⲛⲓϣϯ ⲡⲉ ⳿ⲉⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲛⲁ⳿ϣϩⲟⲗⲙⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧϫⲓϫ ⳿ⲙⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","⳿ⲁⲛⲟⲕ ⲛⲉⲙ ⲡⲁⲓⲱⲧ ⳿ⲁⲛⲟⲛ ⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ⲁⲩⲉⲗ ⲱⲛⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲉϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛϩⲱⲃ ⳿ⲉⲛⲁⲛⲉⲩ ⲁⲓⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲁⲓⲱⲧ ⲉⲑⲃⲉ ⲁϣ ⲟⲩⲛ ⳿ⲛϩⲱⲃ ⲧⲉⲧⲉⲛⲛⲁϩⲓⲱⲛⲓ ⳿ⲉϫⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ⲁⲩⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⲉⲑⲃⲉ ⲟⲩϩⲱⲃ ⳿ⲉⲛⲁⲛⲉϥ ⲧⲉⲛⲛⲁϩⲓⲱⲛⲓ ⳿ⲉϫⲱⲕ ⲁⲛ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ϫⲉⲟⲩ⳿ⲁ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲣⲱⲙⲓ ϩⲱⲕ ⳿ⲕ⳿ⲓⲣⲓ ⳿ⲙⲙⲟⲕ ⳿ⲛⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲙⲏ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲁⲛ ϧⲉⲛ ⲡⲉⲧⲉⲛⲛⲟⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲁⲓϫⲟⲥ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ⲓⲥϫⲉ ⲁϥϫⲟⲥ ⳿ⲉⲛⲏ ϫⲉ ⲛⲟⲩϯ ⲛⲏⲉⲧⲁ ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲫϯ ϣⲱⲡⲓ ϩⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ⲃⲱⲗ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ⲫⲏⲉⲧⲁ ⳿ⲫⲓⲱⲧ ⲧⲟⲩⲃⲟϥ ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲕϫⲉⲟⲩ⳿ⲁ ϫⲉ ⲁⲓϫⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ⲓⲥϫⲉ ϯ⳿ⲓⲣⲓ ⲁⲛ ⳿ⲉⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ ⳿ⲙⲡⲉⲣⲛⲁϩϯ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ⲓⲥϫⲉ ⲇⲉ ϯ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲕⲁⲛ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲛⲁϩϯ ⳿ⲉⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ϯϧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲡⲁⲓⲱⲧ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ⲡⲁⲗⲓⲛ ⲟⲛ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲱϥ ⲡⲉ ⳿ⲉⲧⲁϩⲟϥ ⲟⲩⲟϩ ⲁϥⲫⲱⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲟⲩϫⲓϫ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ⲟⲩⲟϩ ⲁϥϣⲉ ⲛⲁϥ ⲟⲛ ⳿ⲉⲙⲏⲣ ⳿ⲙⲡⲓⲓⲟⲣⲇⲁⲛⲏ ⲥ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ⲓⲱⲁⲛⲛⲏⲥ ϯⲱⲙⲥ ⳿ⲙⲙⲟϥ ⳿ⲛϣⲟⲣⲡ ⲟⲩⲟϩ ⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏϣ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲱⲁⲛⲛⲏⲥ ⲙⲉⲛ ⳿ⲙⲡⲉϥⲉⲣ ⳿ϩⲗⲓ ⳿ⲙⲙⲏⲓⲛⲓ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲉⲑⲃⲉ ⲫⲁⲓ ϩⲁⲛⲙⲉⲑⲙⲏⲓ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ⲟⲩⲟϩ ϩⲁⲛⲙⲏϣ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲁⲩ ");
INSERT INTO copcnt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲁⲓ ⲇⲉ ⲉϥϣⲱⲛⲓ ϫⲉ ⲗⲁⲍⲁⲣⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲃⲏⲑⲁⲛⲓ⳿ⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡϯⲙⲓ ⳿ⲙⲙⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ⲙⲁⲣⲑⲁ ⲧⲉⲥⲥⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ⲛⲉ ⲑⲁⲓ ⲇⲉ ⲧⲉ ⲙⲁⲣⲓ⳿ⲁ ⲑⲏ ⲉⲧⲁⲥⲑⲁϩⲥ ⳿ⲙⲠ⳪ ⳿ⲙⲡⲓⲥⲟϫⲉⲛ ⲟⲩⲟϩ ⲁⲥϥⲱϯ ⳿ⲛⲛⲉϥϭ ⲁⲗⲁⲩϫ ⳿ⲙⲡⲉⲥϥⲱⲓ ⲑⲏ ⳿ⲉⲛⲁⲣⲉ ⲡⲉⲥⲥⲟⲛ ⲗⲁⲍⲁⲣⲟⲥ ϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ⲁⲩⲟⲩⲱⲣⲡ ⲟⲩⲛ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲉϥⲥⲱⲛⲓ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲓⲥ ⲫⲏⲉⲧⲉⲕⲙⲉⲓ ⳿ⲙⲙⲟϥ ⳿ϥϣⲱⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲧⲁⲓⲓⲁⲃⲓ ⳿ⲛⲟⲩⲓⲁⲃⲓ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲁⲛ ⲧⲉ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⳿ⲡⲱⲟⲩ ⳿ⲙⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϭⲓⲱⲟⲩ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲁϥⲙⲉⲓ ⳿ⲙⲙⲁⲣⲑⲁ ⲛⲉⲙ ⲙⲁⲣⲓ⳿ⲁ ⲧⲉⲥⲥⲱⲛⲓ ⲛⲉⲙ ⲗⲁⲍⲁⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ⲧⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ϫⲉ ⳿ϥϣⲱⲛⲓ ⲁϥϣⲱⲡⲓ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲛⲁϥⲭⲏ ⳿ⲙⲙⲟϥ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲃ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ⲙⲉⲛⲉⲛⲥⲁ ⲫⲁⲓ ⲡⲉϫⲁϥ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲙⲁⲣⲟⲛ ⳿ⲉϯⲓⲟⲩⲇⲉ⳿ⲁ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲣⲁⲃⲃⲓ ϯⲛⲟⲩ ⲛⲁⲩⲕⲱϯ ⳿ⲛⲥⲱⲕ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲉϩⲓⲱⲛⲓ ⳿ⲉϫⲱⲕ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⳿ⲭⲛⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲙⲏ ⲓ̅ⲃ̅ ⳿ⲛⲟⲩⲛⲟⲩ ⲉⲧⲭⲏ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲫⲏⲉⲑⲙⲟϣⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲡⲁϥϭⲓϭⲣⲟⲡ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ⲫⲏ ⲇⲉ ⲉⲑⲙⲟϣⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ϣⲁϥϭⲓϭⲣⲟⲡ ϫⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲛϧⲏⲧϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲗⲁⲍⲁⲣⲟⲥ ⲡⲉⲛ⳿ϣⲫⲏⲣ ⲁϥ⳿ⲛⲕⲟⲧ ⲁⲗⲗⲁ ⲉⲓ⳿ⲉϣⲉ ⲛⲏⲓ ⳿ⲛⲧⲁⲧⲟⲩⲛⲟⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ⲡⲉϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲓⲥϫⲉ ⲁϥ⳿ⲛⲕⲟⲧ ⲉϥ⳿ⲉⲧⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉⲧⲁϥϫⲟⲥ ⲉⲑⲃⲉ ⲡⲓⲉⲛⲕⲟⲧ ⳿ⲛⲧⲉ ⲡⲉϥⲙⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲙⲉⲩⲓ ⲡⲉ ϫⲉ ⲁϥϫⲟⲥ ⲉⲑⲃⲉ ⲡⲓ⳿ⲛⲕⲟⲧ ⳿ⲛⲧⲉ ⲡⲓϩⲓⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ⲧⲟⲧⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓⲁ ϫⲉ ⲗⲁⲍⲁⲣⲟⲥ ⲁϥⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ⲟⲩⲟϩ ϯⲣⲁϣⲓ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ ϫⲉ ⲛⲁⲓⲭⲏ ⳿ⲙⲙⲁⲩ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲙⲁⲣⲟⲛ ϣⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ⲡⲉϫⲉ ⲑⲱⲙⲁⲥ ⲟⲩⲛ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲇⲓⲇⲩⲙⲟⲥ ⳿ⲛⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲙⲁⲣⲟⲛ ϩⲱⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛⲙⲟⲩ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ⲉⲧⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϫⲉⲙϥ ⳿ⲉⲡⲉϥⲇ̅ ⲡⲉ ⲉϥⲭⲏ ϧⲉⲛ ⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ⲃⲏⲑⲁⲛⲓ⳿ⲁ ⲇⲉ ⲛⲁⲥϧⲉⲛⲧ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲁⲩ ⲓ̅ⲉ̅ ⳿ⲛ⳿ⲥⲧⲁⲇⲓⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲉ ⲁⲩ⳿ⲓ ⲡⲉ ϩⲁ ⲙⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ⲙⲁⲣⲑⲁ ⲉⲑⲃⲉ ⲡⲟⲩⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ⲉⲧⲁⲥⲥⲱⲧⲉⲙ ⲟⲩⲛ ⳿ⲛϫⲉ ⲙⲁⲣⲑⲁ ϫⲉ ⳿ϥⲛⲏⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁⲥⲧⲱⲛⲥ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ⲛⲁⲥϩⲉⲙⲥⲓ ϧⲉⲛ ⲡⲓⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ⲡⲉϫⲉ ⲙⲁⲣⲑⲁ ⲟⲩⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲡⲁ⳪ ⳿ⲉⲛⲁⲕⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲛⲁⲣⲉ ⲡⲁⲥⲟⲛ ⲛⲁⲙⲟⲩ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ⲁⲗⲗⲁ ϯⲛⲟⲩ ⲟⲩⲛ ϯ⳿ⲉⲙⲓ ϫⲉ ⲫⲏⲉⲧⲉⲕⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲉⲛ ⲫϯ ⳿ϥⲛⲁⲧⲏⲓϥ ⲛⲁⲕ ⳿ⲛϫⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ϥⲛⲁⲧⲱⲛϥ ⳿ⲛϫⲉ ⲡⲉⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ⲡⲉϫⲉ ⲙⲁⲣⲑⲁ ⲛⲁϥ ϫⲉ ϯ⳿ⲉⲙⲓ ϫⲉ ⳿ϥⲛⲁⲧⲱⲛϥ ϧⲉⲛ ϯⲁⲛⲁⲥⲧⲁⲥⲓⲥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ϯ ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲛⲉⲙ ⲡⲓⲱⲛϧ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲕⲁⲛ ⲁϥϣⲁⲛⲙⲟⲩ ⲉϥ⳿ⲉⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲟⲛϧ ⲟⲩⲟϩ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⳿ⲛⲛⲉϥⲙⲟⲩ ϣⲁ ⲉⲛⲉϩ ⲧⲉⲛⲁϩϯ ⳿ⲉⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⳿ⲁⲛⲟⲕ ϯ ⲛⲁϩϯ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲫⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁⲥϫⲟϥ ⲁⲥϣⲉ ⲛⲁⲥ ⲁⲥⲙⲟⲩϯ ⳿ⲉⲙⲁⲣⲓ⳿ⲁ ⲧⲉⲥⲥⲱⲛⲓ ⳿ⲛⲭⲱⲡ ⳿ⲉⲁⲥϫⲟⲥ ⲛⲁⲥ ϫⲉ ⳿ϥⲧⲁⲓ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⳿ϥⲙⲟⲩϯ ⳿ⲉⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","⳿ⲛⲑⲟⲥ ⲇⲉ ⲉⲧⲁⲥⲥⲱⲧⲉⲙ ⲁⲥⲧⲱⲛⲥ ⳿ⲛ ⲭⲱⲗⲉⲙ ⲟⲩⲟϩ ⲁⲥ⳿ⲓ ϩⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ⲛⲉ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⲅⲁⲣ ⲡⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏ ⲓ ⳿ⲉ⳿ⲡϯⲙⲓ ⲁⲗⲗⲁ ⲛⲁϥⲭⲏ ⲟⲩⲛ ⲡⲉ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲁ ⲙⲁⲣⲑⲁ ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲛ ⲛⲏ ⳿ⲉⲛⲁⲩⲭⲏ ⲛⲉⲙⲁⲥ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲡⲓⲏⲓ ⲉⲩⲑⲱⲧ ⳿ⲙⲡⲉⲥϩⲏⲧ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲙⲁⲣⲓ⳿ⲁ ϫⲉ ⲁⲥⲧⲱⲛⲥ ⳿ⲛⲭⲱⲗⲉⲙ ⲟⲩⲟϩ ⲁⲥ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲱⲥ ⲉⲩⲙⲉⲩⲓ ⲛⲱⲟⲩ ϫⲉ ⲁⲥⲛⲁϩⲱⲗ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥⲣⲓⲙⲓ ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ⲙⲁⲣⲓ⳿ⲁ ⲟⲩⲛ ⲉⲧⲁⲥ⳿ⲓ ⳿ⲉⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ Ⲓⲏ̅ⲥ̅ ⲭⲏ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲉⲧⲁⲥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲥϩⲓⲧⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲧⲉⲛ ⲛⲉϥϭⲁⲗⲁⲩϫ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁ⳪ ⳿ⲉⲛⲁⲕⲭⲏ ⳿ⲙⲡⲁⲓⲙⲁ ⲛⲁⲣⲉ ⲡⲁⲥⲟⲛ ⲛⲁⲙⲟⲩ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟⲥ ⲉⲥⲣⲓⲙⲓ ⲛⲉⲙ ⲛⲓⲕⲉⲓⲟⲩⲇⲁⲓ ⲉⲧⲁⲩ⳿ⲓ ⲛⲉⲙⲁⲥ ⲉⲩⲣⲓⲙⲓ ⲁϥ⳿ⲙⲕⲁϩ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ⲁϥ⳿ϣⲑⲟⲣⲧⲉⲣ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲉⲧⲁⲣⲉⲧⲉⲛ ⲭⲁϥ ⲑⲱⲛ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⳿ⲁⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ⲟⲩⲟϩ ⲁ ⲛⲉϥⲃⲁⲗ ϯⲉⲣⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⳿ⲁⲛⲁⲩ ⲡⲱⲥ ⳿ϥⲙⲉⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲓⲉ ⲛⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲫⲁⲓ ⲡⲉ ⲉⲧⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲉⲛⲃⲁⲗ ⳿ⲙⲡⲓⲃⲉⲗⲗⲉ ⳿ⲙⲙⲓⲥⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲭⲁ ⲡⲁⲓⲭⲉⲧ ⳿ⲉⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲁϥϣⲉⲛϩⲏⲧ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲁϥ⳿ⲓ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲛⲉ ⲟⲩⲃⲏⲃ ⲇⲉ ⲡⲉ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛⲱⲛⲓ ⲧⲟⲓ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ϣⲱⲡ ⳿ⲙⲡⲁⲓⲱⲛⲓ ⳿ⲙⲙⲁⲩ ⲡⲉϫⲉ ⲙⲁⲣⲑⲁ ⲛⲁϥ ⳿ⲧⲥⲱⲛⲓ ⳿ⲙⲫⲏⲉⲧⲁϥⲙⲟⲩ ϫⲉ Ⲡ⳪ ⲁϥⲭⲱⲛⲥ ⲡⲉϥⲇ̅ ⲅⲁⲣ ⲫⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ⲙⲡⲓϫⲟⲥ ⲛⲉ ϫⲉ ⲁⲣⲉϣⲁⲛⲛⲁϩϯ ⲧⲉⲣⲁⲛⲁⲩ ⳿ⲉ⳿ⲡⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ⲁⲩⲱⲗⲓ ⲟⲩⲛ ⳿ⲙⲡⲓⲱⲛⲓ ⳿ⲉⲃⲟⲗ ϩⲓ ⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥϥⲁⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ϯϣⲉⲡ ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲟⲧⲕ ϫⲉ ⲁⲕⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","⳿ⲁⲛⲟⲕ ⲇⲉ ⲛⲁⲓ⳿ⲉⲙⲓ ⲡⲉ ϫⲉ ⳿ⲕⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⲡⲁⲓⲙⲏϣ ⲉⲧⲕⲱϯ ⳿ⲉⲣⲟⲓ ⲁⲓϫⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲛⲁϩϯ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ⲟⲩⲟϩ ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ϫⲉ ⲗⲁⲍⲁⲣⲟⲥ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲁϥⲙⲟⲩ ⲉϥⲙⲏⲣ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ⲛⲉⲙ ⲛⲉϥϫⲓϫ ⳿ⲛϩⲁⲛⲥⲉⲃⲉⲛ ⲟⲩⲟϩ ⲡⲉϥϩⲟ ⲙⲏⲣ ⳿ⲛⲟⲩⲥⲟⲇⲁⲣⲓⲟⲛ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲙⲁϯⲟⲩⲱ ⳿ⲙⲙⲟϥ ⲭⲁϥ ⳿ⲉⲃⲟⲗ ⲙⲁⲣⲉϥϣⲉ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ⲟⲩⲙⲏϣ ⲟⲩⲛ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲏⲉⲧⲁⲩ⳿ⲓ ϩⲁ ⲙⲁⲣⲓ⳿ⲁ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲛⲏⲉⲧⲁϥⲁⲓⲧⲟⲩ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲏⲧⲟⲩ ⲁⲩϣⲉ ⲛⲱⲟⲩ ϩⲁ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲁⲩⲧⲁⲙⲱⲟⲩ ⳿ⲉⲫⲏⲉⲧⲁϥⲁⲓϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ⲁⲩⲑⲱⲟⲩϯ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⳿ⲛⲟⲩⲑⲱⲟⲩⲧⲥ ⲟⲩⲟϩ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲛⲁⲁⲓϥ ⲛⲁϣⲉ ⲛⲓⲙⲏⲓⲛⲓ ⲉⲧⲉ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","⳿ⲉϣⲱⲡ ⲁⲛϣⲁⲛⲭⲁϥ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲥⲉⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲥⲉⲛⲁ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲉⲟⲥ ⲥⲉⲛⲁⲱⲗⲓ ⳿ⲙⲡⲉⲛⲧⲟⲡⲟⲥ ⲛⲉⲙ ⲛⲉⲛ⳿ϣⲗⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ⲁϥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏ ⲧⲟⲩ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲕⲁⲓ⳿ⲁⲫⲁ ⲉϥⲟⲓ ⳿ⲛⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲛϯⲣⲟⲙⲡⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ⲟⲩⲇⲉ ⲧⲉⲧⲉⲛⲙⲟⲕⲙⲉⲕ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲓⲉⲑⲛⲟⲥ ⲧⲏⲣϥ ⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ⲛⲉⲧⲁϥϫⲉ ⲫⲁⲓ ⲇⲉ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲗⲗⲁ ϫⲉ ⲛⲁϥⲟⲓ ⳿ⲛⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲛⲧⲉ ϯⲣⲟⲙⲡⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓ⳿ϣⲗⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ⲟⲩⲟϩ ⳿ⲉϫⲉⲛ ⲡⲓ⳿ϣⲗⲟⲗ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲁⲗⲗⲁ ⲛⲓⲕⲉϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧϫⲏⲣ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉϥⲑⲟⲩⲱⲧⲟⲩ ⲉⲩⲙⲉⲧⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩⲥⲟϭⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲛⲁϥⲙⲟϣⲓ ⲁⲛ ϫⲉ ⲡⲉ ⳿ⲛⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲁⲗⲗⲁ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⳿ⲉⲟⲩⲭⲱⲣⲁ ϧⲁⲧⲉⲛ ⲡⲓϣⲁϥⲉ ⳿ⲉⲟⲩⲃⲁⲕⲓ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲉⲫⲣⲉⲙ ⲟⲩⲟϩ ⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ⲛⲁϥϧⲉⲛⲧ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲥⲭⲁ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⳿ⲉ⳿ϩⲣⲏ ⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲭⲱⲣⲁ ϧⲁϫⲉⲛ ⲡⲓⲡⲁⲥⲭⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲧⲟⲩⲃⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ⲛⲁⲩⲕⲱϯ ⲟⲩⲛ ⲡⲉ ⳿ⲛⲥⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ⲉⲩⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ϥⲛⲁ⳿ⲓ ⲁⲛ ⳿ⲉ⳿ⲡϣⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ⲛⲉ ⲁⲩϯⲉⲛⲧⲟⲗⲏ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϩⲓⲛⲁ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⳿ⲉⲙⲓ ϫⲉ ⲁϥⲑⲱⲛ ⳿ⲛⲧⲉϥⲧⲁⲙⲱⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲛⲥⲉⲧⲁϩⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ϧⲁϫⲉⲛ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲥⲭ ⲁ ⲁϥ⳿ⲓ ⳿ⲉⲃⲏⲑⲁⲛⲓ⳿ⲁ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ⲗⲁⲍⲁⲣⲟⲥ ⳿ⲙⲙⲟϥ ⲫⲏⲉⲧⲁϥⲙⲟⲩ ⲫⲏⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ⲁⲩⲉⲣ ⲟⲩⲇⲓⲡⲛⲟⲛ ⳿ⲉⲣⲟϥ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲙⲁⲣⲑⲁ ⲛⲁⲥϣⲉⲙϣⲓ ⲟⲩⲟϩ ⲗⲁⲍⲁⲣⲟⲥ ⲛⲉ ⲟⲩⲁⲓ ⲡⲉ ⳿ⲛⲛⲏⲉⲑⲣⲟⲧⲉⲃ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ⲙⲁⲣⲓ⳿ⲁ ⲟⲩⲛ ⲁⲥϭⲓ ⳿ⲛⲟⲩⲗⲓⲧⲣⲁ ⳿ⲛⲥⲟϫⲉⲛ ⳿ⲛⲧⲉ ⲟⲩⲛⲁⲣⲇⲟⲥ ⳿ⲙⲡⲓⲥⲧⲓⲕⲏ ⳿ⲉⲛⲁϣⲉ ⳿ⲛⲥⲟⲩⲉⲛϥ ⲟⲩⲟϩ ⲁⲥⲑⲱϩⲥ ⳿ⲛⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲒⲏ̅ⲥ̅ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲥϥⲟⲧⲟⲩ ⳿ⲙ⳿ⲡϥⲱⲓ ⳿ⲛⲧⲉ ⲧⲉⲥ⳿ⲁⲫⲉ ⲁ ⲡⲓ ⲏⲓ ⲇⲉ ⲙⲟϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓ⳿ⲥⲑⲟⲓ ⳿ⲛⲧⲉ ⲡⲓⲥⲟϫⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⲉⲧⲉ ⲓⲟⲩⲇⲁⲥ ⲡⲉ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏⲥ ⲫⲏ ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲡⲁⲓⲥⲟϫⲉⲛ ⳿ⲙⲡⲟⲩⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ϧⲁ ⲧ̅ ⳿ⲛⲥⲁⲑⲉⲣⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲧⲏⲓⲧⲟⲩ ⳿ⲛⲛⲓϩⲏⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ⲫⲁⲓ ⲇⲉ ⲁϥϫⲟϥ ⲟⲩⲭ ⳿ⲟⲧⲓ ϫⲉ ⳿ⲥⲉⲣⲙⲉⲗⲓⲛ ⲛⲁϥ ϧⲁ ⲛⲓϩⲏⲕⲓ ⲁⲗⲗⲁ ϫⲉ ⲛⲉ ⲟⲩⲣⲉϥϭ ⲓⲟⲩ⳿ⲓ ⲡⲉ ⲟⲩⲟϩ ⲉⲣⲉ ⲡⲓ⳿ⲅⲗⲱⲥⲟⲕⲟⲙⲟⲛ ⳿ⲛⲧⲟⲧϥ ⲛⲏ ⳿ⲉϣⲁϥϩⲓⲧⲟⲩ ⳿ⲉⲣⲟϥ ⲛⲉϣⲁϥⲧⲱⲟⲩⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ϫⲉ ⲭⲁⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲡⲁⲕⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ⲛⲓϩⲏⲕⲓ ⲅⲁⲣ ⲥⲉⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲁⲛⲟⲕ ⲇⲉ ϯⲛⲉⲙⲱⲧⲉⲛ ⲁⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ⲁⲩ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⳿ϥⲭⲏ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⲉⲑⲃⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲁⲗⲗⲁ ⲛⲉⲙ ⲉⲑⲃⲉ ⳿ⲡⲕⲉⲗⲁⲍⲁⲣⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲫⲏⲉⲧⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ⲁⲩⲉⲣⲟⲩⲥⲟϭⲛⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲱⲧⲉⲃ ⳿ⲙ⳿ⲡⲕⲉⲗⲁⲍⲁⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ϫⲉ ⲉⲑⲃⲏⲧϥ ⲛⲁⲣⲉ ⲟⲩⲙⲏϣ ϩⲏⲗ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲛⲁⲩⲛⲁϩϯ ⲡⲉ ⳿ⲉⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲡⲓⲙⲏϣ ⲉⲧⲟϣ ⳿ⲉⲧⲁⲩ⳿Ⲓ ⳿ⲉ⳿ⲡϣⲁⲓ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲏⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ⲁⲩϭⲓ ⳿ⲛϩⲁⲛⲃⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϩⲁⲛⲃⲉⲛⲓ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁϥ ⲟⲩⲟϩ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲱⲥⲁⲛⲛⲁ ⳿ϥ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ⳿ⲛϫⲉ ⲫⲏⲉⲑⲛⲏⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⲟⲩⲟϩ ⳿ⲡⲟⲩⲣⲟ ⳿ⲙ⳿ⲡⲒⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲉⲧⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩ⳿ⲉ⳿ⲱ ⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉⲣⲟϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⳿ⲧϣⲉⲣⲓ ⳿ⲛⲥⲓⲱⲛ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲟⲩⲣⲟ ⳿ϥⲛⲏⲟⲩ ⲉϥⲧⲁⲗⲏⲟⲩⲧ ⳿ⲉⲟⲩⲥⲏ ϫ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲟⲩⲉⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ⲛⲁⲓ ⲇⲉ ⳿ⲙⲡⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲙⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϣⲟⲣⲡ ⲁⲗⲗⲁ ϩⲟⲧⲉ ⲉⲧⲁϥϭⲓⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲧⲟⲧⲉ ⲁⲩⲉⲣ⳿ⲫⲙⲉⲩ⳿ⲓ ϫⲉ ⲛⲁⲓ ⲛⲉ ⳿ⲉⲧⲁⲩⲁⲓⲧⲟⲩ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ⲛⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲟⲩⲛ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⳿ⲉⲛⲁϥⲛⲉⲙⲁϥ ϫⲉ ⲁϥⲙⲟⲩϯ ⳿ⲉⲗⲁⲍⲁⲣⲟⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ϫⲉ ⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⲁϥⲉⲣ ⲡⲁⲓⲙⲏⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ⲡⲉϫⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲟⲩⲛ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⲧⲉⲛⲛⲁⲩ ϫⲉ ⲧⲉⲛⲛⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⲓⲥ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ⲁϥϣⲉ ⲛⲁϥ ⲥⲁⲙⲉⲛϩⲏϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲉⲓⲛⲓⲛ ⲇⲉ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲡϣⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲟⲩⲱϣⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ⲛⲁⲓ ⲟⲩⲛ ⲛⲁⲩ⳿ⲓ ϩⲁ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲡⲓⲣⲉⲙⲃⲏ ⲑⲥⲁⲓⲇⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲓⲗⲉ⳿ⲁ ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲡⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲛ⳪ ⲧⲉⲛⲟⲩⲱϣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲁϥϫⲟⲥ ⳿ⲛⲁⲛⲇⲣⲉⲁⲥ ⲁⲛⲇⲣⲉⲁⲥ ⲟⲛ ⲛⲉⲙ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲁⲩ⳿Ⲓ ⲁⲩϫⲟⲥ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲉⲣⲟⲩⲱ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ϯⲟⲩⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ϭⲓⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁⲣⲉ⳿ϣⲧⲉⲙ ϯⲛⲁⲫⲣⲓ ⳿ⲛⲥⲟⲩ⳿ⲟ ϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲥⲙⲟⲩ ⳿ⲛⲑⲟⲥ ⳿ⲙⲙⲁⲩⲁⲧⲥ ⳿ⲉϣⲁⲥϣⲱⲡⲓ ⲉϣⲱⲡ ⲇⲉ ⲁⲥϣⲁⲛⲙⲟⲩ ϣⲁⲥⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ⲫⲏⲉⲑⲙⲉⲓ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⲉϥ⳿ⲉⲧⲁⲕⲟⲥ ⲟⲩⲟϩ ⲫⲏⲉⲧⲙⲟⲥϯ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲉϥ⳿ⲉⲁⲣⲉϩ ⳿ⲉⲣⲟⲥ ⲉⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ⲫⲏⲉⲑⲛⲁϣⲉⲙϣⲓ ⳿ⲙⲙⲟⲓ ⲙⲁⲣⲉϥⲟⲩⲁϩϥ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⳿ⲫⲙⲁ ⳿ⲉϯϣⲟⲡ ⳿ⲙⲙⲟϥ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲛⲉⲙⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲣⲉϥϣⲉⲙϣⲓ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲉⲣⲣⲉϥϣⲉⲙϣⲓ ⲛⲏⲓ ⳿ϥⲛⲁⲉⲣⲧⲓⲙⲁⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ϯⲛⲟⲩ ⲁ ⲧⲁⲯⲩⲭⲏ ⳿ϣⲑⲟⲣⲧⲉⲣ ⲟⲩⲟϩ ⲟⲩ ⲡⲉϯⲛⲁϫⲟϥ ⲡⲁⲓⲱⲧ ⲛⲁϩⲙⲉⲧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲁⲓⲟⲩⲛⲟⲩ ⲁⲗⲗⲁ ⲉⲑⲃⲉⲫⲁⲓ ⲁⲓ⳿ⲓ ⳿ⲉⲧⲁⲓⲟⲩⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","⳿ⲫⲓⲱⲧ ⲙⲁⲱⲟⲩ ⳿ⲙⲡⲉⲕϣⲏⲣⲓ ⲟⲩ⳿ⲥⲙⲏ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓ ϯⲱⲟⲩ ⲡⲁⲗⲓⲛ ⲟⲛ ϯⲛⲁϯⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ⲡⲓⲙⲏϣ ⲟⲩⲛ ⳿ⲉⲛⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩϧⲁⲣⲁⲃⲁⲓ ⲡⲉⲧⲁⲥϣⲱⲡⲓ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⲡⲉⲧⲁϥⲥⲁϫⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲉⲧⲁⲥϣⲱⲡⲓ ⲁⲛ ⲉⲑⲃⲏⲧ ⳿ⲛϫⲉ ⲧⲁⲓ⳿ⲥⲙⲏ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ϯⲛⲟⲩ ⳿ⲡϩⲁⲡ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ϯⲛⲟⲩ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲉⲩ⳿ⲉϩⲓⲧϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⲁⲓϣⲁⲛϭⲓⲥⲓ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲡⲕⲁϩⲓ ⲉⲓ⳿ⲉⲥⲉⲕ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ⲫⲁⲓ ⲇⲉ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟϥ ⲉϥϯⲙⲏⲓⲛⲓ ϫⲉ ϧⲉⲛ ⲁϣ ⳿ⲙⲙⲟⲩ ⳿ϥⲛⲁⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ϫⲉ Ⲡⲭ̅ⲥ̅ ϣⲟⲡ ϣⲁ ⲉⲛⲉϩ ⲟⲩⲟϩ ⲡⲱⲥ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲑⲟⲕ ϫⲉ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲟⲩϭⲉⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲛⲓⲙ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⲉⲧⲓ ⲕⲉⲕⲟⲩϫⲓ ⳿ⲛⲥⲏ ⲟⲩ ⲡⲓⲟⲩⲱⲓⲛⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲟϣⲓ ⲟⲩⲛ ϧⲉⲛ ⲡⲓⲟⲩⲱⲓⲛⲓ ϩⲱⲥ ⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲓⲭⲁⲕⲓ ⲧⲁϩⲉ ⲑⲏⲛⲟⲩ ϫⲉ ⲫⲏⲉⲑⲙⲟϣⲓ ϧⲉⲛ ⲡⲓⲭⲁⲕⲓ ⳿ϥ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁϥⲙⲟϣⲓ ⳿ⲉⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ϩⲱⲥ ⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲟϣⲓ ϧⲉⲛ ⲡⲓⲟⲩⲱⲓⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲉⲣϣⲏⲣⲓ ⳿ⲙⲡⲓⲟⲩⲱⲓⲛⲓ ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϣⲉ ⲛⲁϥ ⲁϥⲭⲟⲡϥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ⲛⲁⲓⲙⲏϣ ⲇⲉ ⳿ⲙⲙⲏⲓⲛⲓ ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⳿ⲙⲡⲟⲩ⳿ⲙⲑⲟ ⳿ⲙⲡⲟⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⳿ⲡⲥⲁϫⲓ ⳿ⲛⲏⲥⲁ⳿ⲓⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲫⲏⲉⲧⲁϥϫⲟϥ ϫⲉ Ⲡ⳪ ⲛⲓⲙ ⲉⲧⲁϥⲛⲁϩϯ ⳿ⲉⲧⲉⲛ⳿ⲥⲙⲏ ⲟⲩⲟϩ ⳿ⲡϣⲱⲃϣ ⳿ⲙⲠ⳪ ⲉⲧⲁϥϭⲱⲣⲡ ⳿ⲉⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ⲉⲑⲃⲉⲫⲁⲓ ⲛⲉ ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲛⲁϩϯ ⲡⲉ ⲟⲩⲟϩ ⲁϥϫⲟⲥ ⲟⲛ ⳿ⲛϫⲉ ⳿ⲏⲥⲁ⳿ⲓⲁⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ϫⲉ ⲁϥⲑⲱⲙ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⲁϥⲑⲱⲙ ⳿ⲙⲡⲟⲩϩⲏⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲕⲁϯ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲕⲟⲧⲟⲩ ϩⲁⲣⲟⲓ ⳿ⲛⲧⲁⲧⲟⲩϫⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ⲛⲁⲓ ⲁϥϫⲟⲧⲟⲩ ⳿ⲛϫⲉ ⲏⲥⲁ⳿ⲓⲁⲥ ϫⲉ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲡⲱⲟⲩ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲁϥⲥⲁϫⲓ ⲉⲑⲃⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ⲟⲙⲱⲥ ⲙⲉⲛⲧⲟⲓ ⲟⲩⲙⲏϣ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲕⲉⲁⲣⲭⲱⲛ ⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲁⲗⲗⲁ ⲛⲁⲩⲟⲩⲱⲛϩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲡⲉ ⲉⲑⲃⲉ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ϫⲉ ⳿ⲛⲛⲟⲩⲁⲓⲧⲟⲩ ⳿ⲛ⳿ⲁⲡⲟⲥⲩⲛⲁⲅⲱⲅⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ⲁⲩⲙⲉⲛⲣⲉ ⳿ⲡⲱⲟⲩ ⲅⲁⲣ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲙⲁⲗⲗⲟⲛ ⳿ⲉϩⲟⲧⲉ ⳿ⲡⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁϥⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁⲛ ⲁⲗⲗⲁ ⲁϥⲛⲁϩϯ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁϥⲛⲁⲩ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","⳿ⲁⲛⲟⲕ ⲁⲓ⳿ⲓ ⲉⲩⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲓⲛⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲟϩⲓ ϧⲉⲛ ⳿ⲡⲭⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲉⲑⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⲛⲉⲧⲁⲓ⳿ⲓ ⲅⲁⲣ ϩⲓⲛⲁ ⳿ⲛⲧⲁϯ ϩⲁⲡ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲟϩⲉⲙ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ⲫⲏⲉⲧϫⲱⲗ ⳿ⲙⲙⲟⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲧⲉ⳿ⲛ⳿ϥϭ ⲓ ⳿ⲛⲛⲁⲥⲁϫⲓ ⲁⲛ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲫⲏⲉⲑⲛⲁ ϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⲡⲓⲥⲁϫⲓ ⲉⲧⲁⲓⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲑⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁ⳿ⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ϫⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ⲛⲑⲟϥ ⲡⲉⲧⲁϥϯⲉⲛⲧⲟⲗⲏ ⲛⲏⲓ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁϫⲟϥ ⲓⲉ ⲟⲩ ⲡⲉϯⲛⲁⲥⲁϫⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ⲟⲩⲟϩ ϯ⳿ⲉⲙⲓ ϫⲉ ⲧⲉϥⲉⲛⲧⲟⲗⲏ ⲟⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ ⲧⲉ ⲛⲏ ⲟⲩⲛ ⳿ⲁⲛⲟⲕ ⳿ⲉϯϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥϫⲟⲥ ⲛⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲡⲁⲓⲣⲏϯ ϯⲥⲁϫⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ⲁϫⲉⲛ ⳿ⲡϣⲁⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲥⲭⲁ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉϥⲟⲩⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲉϥⲛⲁϣⲉ ⲛⲁϥ ϩⲁ ⳿ⲫⲓⲱⲧ ⳿ⲉⲁϥⲙⲉⲛⲣⲉ ⲛⲏⲉⲧⲉⲛⲟⲩϥ ⲉⲧϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲉⲁϥⲙⲉⲛⲣⲓⲧⲟⲩ ϣⲁ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ⲟⲩⲟϩ ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲇⲓⲡⲛⲟⲛ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ϩⲏⲇⲏ ⲛⲉ ⲁϥⲟⲩⲱ ⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲉ⳿ⲡϩⲏ ⲧ ⳿ⲙⲫⲏ ⳿ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ ⲉⲧⲉ ⲓⲟⲩⲇⲁⲥ ⲡⲉ ⲥⲓⲙⲱⲛ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁ ⳿ⲫⲓⲱⲧ ϯ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲛⲉϥϫⲓϫ ⲟⲩⲟϩ ϫⲉ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ⲟⲩⲟϩ ⲁϥⲛⲁϣⲉ ⲛⲁϥ ϩⲁ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲇⲓⲡⲛⲟⲛ ⲁϥ ⲭⲱ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲩⲟϩ ⲁϥϭⲓ ⳿ⲛⲟⲩⲗⲉⲛⲧⲓⲟⲛ ⲁϥⲙⲟⲣϥ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ⲟⲩⲟϩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩⲙⲱⲟⲩ ⳿ⲉⲟⲩⲗⲁⲕⲁⲛⲏ ⲟⲩⲟϩ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲓⲱⲓ ⳿ⲛⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲉϥϥⲱϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲓⲗⲉⲛⲧⲓⲟⲛ ⳿ⲉⲛⲁϥⲙⲏⲣ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ⲁϥ⳿ⲓ ⲟⲩⲛ ϩⲁ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲉϥⲛⲁⲓⲁ ⲣⲁⲧϥ ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⳿ⲛⲑⲟⲕ ⲉⲑⲛⲁⲓⲁ ⲣⲁⲧ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲫⲏ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲟⲕ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ϯⲛⲟⲩ ⲉⲕ⳿ⲉⲉⲙⲓ ⲇⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ ⳿ⲛⲛⲉⲕⲓⲁ ⲣⲁⲧ ⳿ⲉⲃⲟⲗ ϣⲁ ⳿ⲉⲛⲉϩ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲁⲓ⳿ϣⲧⲉⲙⲓⲁ ⲣⲁⲧⲕ ⳿ⲙⲙⲟⲛⲧⲉⲕ ⲧⲟⲓ ⲛⲉⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ⲡⲉϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⲟⲩ ⲙⲟⲛⲟⲛ ⲛⲁϭⲁⲗⲁⲩϫ ⲁⲗⲗⲁ ⲛⲉⲙ ⲛⲁⲕⲉϫⲓϫ ⲛⲉⲙ ⲧⲁ⳿ⲁⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲫⲏⲉⲧⲁϥϫⲟⲕⲉⲙ ⳿ⲛ⳿ϥⲉⲣ⳿ⲭⲣⲓⲁ ⲁⲛ ⳿ⲉⲃⲏⲗ ⳿ⲉⲓⲁ ⲣⲁⲧϥ ⲁⲗⲗⲁ ⳿ϥⲟⲩⲁⲃ ⲧⲏⲣϥ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲟⲩⲁⲃ ⲁⲗⲗⲁ ⲧⲏⲣⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ⲛⲁϥⲥⲱⲟⲩⲛ ⲅⲁⲣ ⳿ⲙⲫⲏ ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ ⲉⲑⲃⲉⲫⲁⲓ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉⲧⲉⲛⲟⲩⲁⲃ ⲧⲏⲣⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥⲓⲱⲓ ⳿ⲛⲛⲟⲩϭⲁⲗⲁⲩϫ ⲁϥϭⲓ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⲟⲩⲟϩ ⲉⲧⲁϥⲣⲟⲑⲃⲉϥ ⲟⲛ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉⲧⲁⲓⲁⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲙⲟⲩϯ ⳿ⲉⲣⲟⲓ ϫⲉ ⳿ⲫⲣⲉϥϯ ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲡⲉⲛ⳪ ⲕⲁⲗⲱⲥ ⲧⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ⲓⲥϫⲉ ⲟⲩⲛ ⳿ⲁⲛⲟⲕ ⲁⲓⲓⲱⲓ ⳿ⲛⲛⲉⲧⲉⲛ ϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ ⲡⲉⲧⲉⲛ⳪ ⲟⲩⲟϩ ⲡⲉⲧⲉⲛⲣⲉϥ ϯ⳿ⲥⲃⲱ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉⲧⲉⲛⲓⲁ ⲣⲁⲧⲟⲩ ⳿ⲛⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ⲟⲩ⳿ⲥⲙⲟⲧ ⲅⲁⲣ ⲡⲉⲧⲁⲓⲁⲓϥ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲁⲛⲟⲕ ⲉⲧⲁⲓⲁⲓⲥ ⲛⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲁⲓⲥ ⳿ⲛⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲙⲙⲟⲛ ⲟⲩⲃⲱⲕ ⲉϥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲡⲉϥ⳪ ⲟⲩⲇⲉ ⲟⲩ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲉϥⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ⲓⲥϫⲉ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⳿ⲉⲛⲁⲓ ⲱⲟⲩⲛⲓ⳿ⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲁⲓⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ⲛⲁⲓϫⲱ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ⲧⲏⲣⲟⲩ ⲁⲛ ϯⲥⲱⲟⲩⲛ ⲅⲁⲣ ⳿ⲁⲛⲟⲕ ⳿ⲛⲛⲏⲉⲧⲁⲓⲥⲟⲧⲡⲟⲩ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲫⲏⲉⲑⲟⲩⲱⲙ ⳿ⲙⲡⲁⲱⲓⲕ ⲛⲉⲙⲏⲓ ⲁϥⲧⲱⲟⲩⲛ ⳿ⲙⲡⲉϥⲑⲓⲃⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲁⲧⲉⲥϣⲱⲡⲓ ϩⲓⲛⲁ ⲁⲥϣⲁⲛϣⲱⲡⲓ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲧϣⲱⲡ ⳿ⲙⲫⲏ ⳿ⲉϯⲛⲁⲟⲩⲟⲣⲡϥ ⲁϥϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲫⲏ ⲇⲉ ⲉⲧϣⲱⲡ ⳿ⲙⲙⲟⲓ ⲁϥϣⲱⲡ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ⲛⲁⲓ ⲇⲉ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥ⳿ϣⲑⲟⲣⲧⲉⲣ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲡⲉⲑⲛⲁⲧⲏⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ⲛⲁⲩⲥⲟⲙⲥ ⲟⲩⲛ ⲡⲉ ⳿ⲉⲛⲟⲩⲉⲣⲏⲟⲩ ⳿ⲛϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲥⲉ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁϥ⳿ϫⲫⲉ ⲉⲣⲉ ⲛⲓⲙ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ⲛⲁϥⲣⲟⲧⲉⲃ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ϧⲉⲛ ⲕⲉⲛϥ ⳿ⲛⲒⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲫⲏ ⳿ⲉⲛⲁⲣⲉ Ⲓⲏ̅ⲥ̅ ⲙⲉⲓ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ⲁϥϭⲱⲣⲉⲙ ⲟⲩⲛ ⳿ⲉⲫⲁⲓ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϣⲉⲛϥ ϫⲉ ⲁϥϫⲉ ⲉⲣⲉ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲧⲁϥⲟⲩⲁϩϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲑⲙⲉⲥⲧⲉⲛϩⲏⲧ ⳿ⲛⲒⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⲛⲓⲙ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲏ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁⲥⲉⲡ ⲡⲓⲗⲱⲙ ⳿ⲛⲧⲁⲧⲏⲓϥ ⲛⲁϥ ⳿ⲛⲑⲟϥ ⲡⲉ ⲟⲩⲟϩ ⲉⲧⲁϥⲥⲉⲡ ⲡⲓⲗⲱⲙ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⳿ⲛⲓⲟⲩⲇⲁⲥ ⲥⲓⲙⲱⲛ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲗⲱⲙ ⲁϥϣⲉ ⲛⲁϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲛⲁϥ ϫⲉ ⲫⲏⲉⲧⲉⲕⲛⲁⲁⲓϥ ⲁⲣⲓⲧϥ ⳿ⲛⲭⲱⲗⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ⲡⲁⲓⲥⲁϫⲓ ⲇⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲛⲏⲉⲑⲣⲟⲧⲉⲃ ϫⲉ ⲉⲧⲁϥϫⲟⲥ ⲛⲁϥ ⲉⲑⲃⲉⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⲛⲁⲩⲙⲉⲩⲓ ⲡⲉ ϫⲉ ⲉⲡⲓⲇⲏ ⲛⲁⲣⲉ ⲡⲓ⳿ⲅⲗⲱⲥⲟⲕⲟⲙⲟⲛ ⳿ⲛⲧⲟⲧϥ ⳿ⲛⲓⲟⲩⲇⲁⲥ ϫⲉ ⲁⲣⲏⲟⲩ ⲉⲣⲉ Ⲓⲏ̅ⲥ̅ ϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ϣⲱⲡ ⳿ⲙⲫⲏⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲭⲣⲓⲁ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ⲡϣⲁⲓ ⲓⲉ ϫⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϯ ⳿ⲛⲟⲩⲉⲛⲭⲁⲓ ⳿ⲛⲛⲓϩⲏⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ⲉⲧⲁϥϭⲓ ⲟⲩⲛ ⳿ⲙⲡⲓⲗⲱⲙ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲥⲁⲧⲟⲧϥ ⲛⲉ ⲉϫⲱⲣϩ ⲇⲉ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϯⲛⲟⲩ ⲁϥϭⲓⲱⲟⲩ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲫⲣⲱⲙⲓ ⲟⲩⲟϩ ⲁ ⲫϯ ϭⲓⲱⲟⲩ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ⲓⲥϫⲉ ⲁ ⲫϯ ϭⲓⲱⲟⲩ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲫϯ ⲛⲁϯⲱⲟⲩ ⲛⲁϥ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲉϥ⳿ⲉϯⲱⲟⲩ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ⲛⲁϣⲏⲣⲓ ⲉⲧⲓ ⲕⲉⲕⲟⲩϫⲓ ϯⲭⲏ ⲛⲉⲙⲱⲧⲉⲛ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲓϫⲟⲥ ⳿ⲛⲛⲓⲟⲩⲇⲁⲓ ϫⲉ ⲡⲓⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϣⲓ ⳿ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲟϩ ϯ ⲛⲟⲩ ϩⲱⲧⲉⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ⲟⲩ⳿ⲉⲛⲧⲟⲗⲏ ⳿ⲙⲃⲉⲣⲓ ⳿ⲉϯϯ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲓⲙⲉⲛⲣⲉ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲫⲁⲓ ⲥⲉⲛⲁ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲁⲕⲛⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲑⲱⲛ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲡⲓⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ ϯⲛⲟⲩ ⳿ⲉ⳿ⲡϧⲁ⳿ⲉ ⲇⲉ ⲉⲕ⳿ⲉⲙⲟϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ⲡⲉϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉⲙⲟϣⲓ ⳿ⲛⲥⲱⲕ ϯⲛⲟⲩ ⲧⲁⲯⲩⲭⲏ ϯⲛⲁⲭⲁⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲧⲉⲕ ⲯⲩⲭⲏ ⳿ⲭⲛⲁⲭⲁⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ ϣⲁⲧⲉⲕϫⲟⲗⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛⲅ̅ ⳿ⲛⲥⲟⲡ ");
INSERT INTO copcnt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⲡⲉⲧⲉⲛϩⲏⲧ ⳿ϣⲑⲟⲣⲧⲉⲣ ⲛⲁϩ ϯ ⳿ⲉⲫϯ ⲟⲩⲟϩ ⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ϩⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲟⲛⲏ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲙⲡⲁⲓⲱⲧ ⳿ⲉⲛⲉ⳿ⲙⲙⲟⲛ ⲛⲁⲓⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ⲡⲉ ϫⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲛⲧⲁⲥⲉⲃⲧⲉ ⲟⲩⲙⲁ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ⲟⲩⲟϩ ⲁⲓϣⲁⲛϣⲉ ⲛⲏⲓ ⳿ⲛⲧⲁⲥⲉⲃⲧⲉ ⲟⲩⲙⲁ ⲛⲱⲧⲉⲛ ⲡⲁⲗⲓⲛ ⲟⲛ ⲉⲓ⳿ⲉ⳿ⲓ ⳿ⲛⲧⲁⲉⲗ ⲑⲏⲛⲟⲩ ϩⲁⲣⲟⲓ ϩⲓⲛⲁ ⳿ⲙ⳿ⲫⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯϣⲟⲡ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲛⲉⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ⲟⲩⲟϩ ⳿ⲫⲙⲁ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ⲡⲉϫⲉ ⲑⲱⲙⲁⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁⲕⲛⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲑⲱⲛ ⲟⲩⲟϩ ⲡⲱⲥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ ⲉⲥⲟⲩⲉⲛ ⲡⲓⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲡⲓⲙⲱⲓⲧ ⲛⲉⲙ ϯⲙⲉⲑⲙⲏⲓ ⲛⲉⲙ ⲡⲓⲱⲛϧ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⳿Ⲓ ϩⲁ ⳿ⲫⲓⲱⲧ ⲁϥ⳿ϣⲧⲉⲙ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ⲓⲥϫⲉ ⲁⲣⲉⲧⲉⲛⲥⲟⲩⲱⲛⲧ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲟⲩⲉⲛ ⲡⲁⲕⲉⲓⲱⲧ ⲟⲩⲟϩ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ⲡⲉϫⲉ ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲙⲁⲧⲁⲙⲟⲛ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ⲕⲏⲛ ⳿ⲉⲣⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲡⲁⲓⲥⲏⲟⲩ ⲧⲏⲣϥ ϯ ⲛⲉⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲕⲥⲟⲩⲱⲛⲧ ⲫⲓⲗⲓⲡⲡⲉ ⲫⲏⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲡⲱⲥ ⳿ⲛⲑⲟⲕ ⳿ⲕϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁⲧⲁⲙⲟⲛ ⳿ⲉ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","⳿ⲭⲛⲁϩϯ ⲁⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ϯϧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲡⲁⲓⲱⲧ ⳿ⲛϧⲏⲧ ⲛⲁⲓⲥⲁϫⲓ ⳿ⲉϯϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲛⲱⲧⲉⲛ ⲛⲁⲓⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⳿ⲫⲓⲱⲧ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏ ⲧ ⳿ⲛⲑⲟϥ ⲡⲉ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲛⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ϯϧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲡⲁⲓⲱⲧ ⳿ⲛϧⲏⲧ ⳿ⲙⲙⲟⲛ ⲕⲁⲛ ⲉⲑⲃⲉ ⲛⲓ⳿ϩⲃⲏ ⲟⲩ⳿ⲓ ⲛⲁϩϯ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲁⲛⲟⲕ ⳿ⲉϯ ⲣⲁ ⳿ⲙⲙⲱⲟⲩ ⲉϥ⳿ⲉⲁⲓⲧⲟⲩ ϩⲱϥ ⲟⲩⲟϩ ϩⲁⲛⲛⲓϣϯ ⳿ⲉⲛⲁⲓ ⲉϥ⳿ⲉⲁⲓⲧⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ⲟⲩⲟϩ ⲫⲏⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲉⲓ⳿ⲉⲁⲓϥ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ ϭⲓⲱⲟⲩ ⳿ⲛϫⲉ ⳿ⲫⲓⲱⲧ ϧⲉⲛ ⳿ⲡϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ⲫⲏⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲫⲁⲓ ϯⲛⲁⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ⲉϣⲱⲡ ⲧⲉⲧⲉⲛⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲧⲉⲧⲉⲛⲛⲁⲁⲣⲉϩ ⳿ⲉⲛⲁ⳿ⲉⲛⲧⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁϯϩⲟ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ⲉϥ⳿ⲉϯ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲁⲣⲁⲕⲗⲏⲧⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⲛⲉⲙⲱⲧⲉⲛ ϣⲁ ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲉϣⲟⲡϥ ϫⲉ ⳿ϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲛ ⲟⲩⲇⲉ ⳿ϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲁϥϣⲟⲡ ⲛⲉⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⲉϥ⳿ⲉϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","⳿ⲛⲛⲁⲭⲁ ⲑⲏⲛⲟⲩ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲟⲣⲫⲁⲛⲟⲥ ϯⲛⲏⲟⲩ ϩⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ⲉⲧⲓ ⲕⲉⲕⲟⲩϫⲓ ⲟⲩⲟϩ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁⲛⲁⲩ ⲉⲣⲟⲓ ⲁⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲟⲛϧ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲉⲧⲉⲛ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲛⲑⲱⲧⲉⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ϯϧⲉⲛ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ⲫⲏⲉⲧⲉ ⲛⲁⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲟⲧϥ ⲟⲩⲟϩ ⲉⲧⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲑⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲫⲏ ⲇⲉ ⲉⲑⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲉϥ⳿ⲉⲙⲉⲛⲣⲓⲧϥ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲉⲓ⳿ⲉⲙⲉⲛⲣⲓⲧϥ ⲟⲩⲟϩ ⲉⲓ⳿ⲉⲟⲩⲟⲛϩⲧ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ⲡⲉϫⲉ ⲓⲟⲩⲇⲁⲥ ⲛⲁϥ ⲡⲓ⳿ⲥⲕⲁⲣⲓⲱⲧⲏⲥ ⲁⲛ ϫⲉ Ⲡ⳪ ⲟⲩ ⲡⲉⲧⲁϥϣⲱⲡⲓ ϫⲉ ⳿ⲭⲛⲁⲟⲩⲟⲛϩⲕ ⳿ⲉⲣⲟⲛ ⳿ⲁⲛⲟⲛ ⲟⲩⲟϩ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲛⲑⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲫⲏⲉⲑⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲉϥ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉⲡⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⲉϥ⳿ⲉⲙⲉⲛⲣⲓⲧϥ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲉⲛ⳿ⲉ⳿ⲓ ϩⲁⲣⲟϥ ⲟⲩⲟϩ ⲉⲛ⳿ⲉⲑⲁⲙⲓ⳿ⲟ ⳿ⲙⲡⲉⲛⲙⲁ⳿ⲛϣⲱⲡⲓ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲁⲛ ⳿ϥⲛⲁ⳿ⲁⲣⲉϩ ⲁⲛ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲟⲩⲟϩ ⲡⲓⲥⲁϫⲓ ⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲫⲱⲓ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲁ ⳿ⲫⲓⲱⲧ ⲡⲉ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ⲛⲁⲓ ⲇⲉ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲉⲓϣⲟⲡ ϧⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲣⲁⲕⲗⲏ ⲧⲟⲥ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲫⲏⲉⲧⲉ ⳿ⲫⲓⲱⲧ ⲛⲁⲟⲩⲟⲣⲡϥ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⳿ⲛⲑⲟϥ ⲉⲑⲛⲁ⳿ⲧⲥⲁⲃⲉ ⲑⲏⲛⲟⲩ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⳿ϥⲛⲁϯ ⳿ⲙ⳿ⲫⲙⲉⲩⲓ ⲛⲱⲧⲉⲛ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ϯⲛⲁⲭⲱ ⳿ⲛⲧⲁϩⲓⲣⲏⲛⲏ ⲛⲱⲧⲉⲛ ⲧⲁϩⲓⲣⲏ ⲛⲏ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲧⲏⲓⲥ ⲛⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⲁⲛ ⲉⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ϯ ⳿ⲙⲙⲟⲥ ⳿ⲉϯⲛⲁϯ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛϫⲉ ⲡⲉⲧⲉⲛϩⲏⲧ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲉⲣ⳿ϣⲗⲁϩ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲛ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ⲟⲩⲟϩ ϯⲛⲏⲟⲩ ϩⲁⲣⲱⲧⲉⲛ ⳿ⲉⲛⲁⲣⲉⲧⲉⲛⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲛⲁⲣⲉⲧⲉⲛⲛⲁⲣⲁϣⲓ ⲡⲉ ϫⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⳿ⲫⲓⲱⲧ ϫⲉ ⲡⲁⲓⲱⲧ ⲟⲩⲛⲓϣϯ ⳿ⲉⲣⲟⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲁⲧⲉⲥϣⲱⲡⲓ ϩⲓⲛⲁ ⲁⲥϣⲁⲛϣⲱⲡⲓ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","⳿ⲛϯⲛⲁϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲁϫⲓ ⲛⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⳿ϥⲛⲏⲟⲩ ⲅⲁⲣ ⳿ⲛϫⲉ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲧⲁϥ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ϫⲉ ϯⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲙⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⲛⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ϯ⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁⲣⲟⲛ ⳿ⲉⲃⲟⲗ ⲧⲁⲓ ");
INSERT INTO copcnt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","⳿ⲁⲛⲟⲕ ⲡⲉ ϯⲃⲱ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ⳿ⲛⲧⲁ⳿ⲫⲙⲏⲓ ⲟⲩⲟϩ ⲡⲁⲓⲱⲧ ⲡⲉ ⲡⲓⲟⲩⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","⳿ⲕⲗⲏⲙⲁ ⲛⲓⲃⲉⲛ ⲉⲧⲉ ⳿ⲛϧⲏⲧ ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ⲁⲛ ⳿ϥⲛⲁⲕⲟⲣϫϥ ⲟⲩⲟϩ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲉⲛ ⲟⲩⲧⲁϩ ⳿ϥⲛⲁⲧⲟⲩⲃⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲉⲛ ϩⲟⲩ⳿ⲟ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ϩⲏⲇⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲧⲉⲧⲉⲛⲧⲟⲩⲃⲟ ⲉⲑⲃⲉ ⲡⲁⲓⲥⲁϫⲓ ⲉⲧⲁⲓⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲛⲉⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓ⳿ⲕⲗⲏⲙⲁ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉϥⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁϥ⳿ϣⲧⲉⲙϣⲱⲡⲓ ϧⲉⲛ ϯⲃⲱ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ⲡⲁⲓⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","⳿ⲁⲛⲟⲕ ⲡⲉ ϯⲃⲱ ⳿ⲛ⳿ⲁⲗⲟⲗⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲉ ⲛⲓ⳿ⲕⲗⲏⲙⲁ ⲫⲏⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛϧⲏⲧϥ ⲫⲁⲓ ⲉϥ⳿ⲉ⳿ⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ϫⲉ ⲁⲧϭⲛⲟⲩ⳿ⲓ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲉⲣ ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲟⲩⲁⲓ ϣⲱⲡⲓ ⳿ⲛϧⲏⲧ ⲥⲉⲛⲁϩⲓⲧϥ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓ⳿ⲕⲗⲏⲙⲁ ⲟⲩⲟϩ ϣⲁϥϣⲱⲟⲩ⳿ⲓ ⲟⲩⲟϩ ϣⲁⲩⲑⲟⲩⲱⲧⲟⲩ ⳿ⲛⲥⲉϩⲓⲧⲟⲩ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⲟⲩⲟϩ ϣⲁⲩⲣⲱⲕϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ⲉϣⲱⲡ ⲇⲉ ⲁⲣⲉⲧⲉⲛϣⲁⲛϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲛⲁⲥⲁϫⲓ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏ ⲛⲟⲩ ⲫⲏⲉⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⲁⲣⲓⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ϥⲛⲁϣⲱⲡⲓ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ϧⲉⲛ ⲫⲁⲓ ⲁϥϭⲓⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⲛⲏⲓ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲙⲉⲛⲣⲓⲧ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⳿ⲁⲛⲟⲕ ϩⲱ ⲁⲓⲙⲉⲛⲣⲉ ⲑⲏⲛⲟⲩ ϣⲱⲡⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲧⲁⲁⲅⲁⲡⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ⲉϣⲱⲡ ⳿ⲛⲧⲉⲧⲉⲛⲁⲣⲉϩ ⳿ⲉⲛⲁⲉⲛⲧⲟⲗⲏ ⲧⲉⲧⲉⲛⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⲧⲁⲁⲅⲁⲡⲏ ⳿ⲙ⳿ⲫⲣⲏϯ ϩⲱ ⲉⲧⲁⲓⲁⲣⲉϩ ⳿ⲉⲛⲓⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲧ ⲟⲩⲟϩ ϯϣⲟⲡ ϧⲉⲛ ⲧⲉϥⲁⲅⲁⲡⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ⲛⲁⲓ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲁⲣⲁϣⲓ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲣⲁϣⲓ ϩⲱⲧⲉⲛ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ⲑⲁⲓ ⳿ⲁⲛⲟⲕ ⲧⲉ ⲧⲁⲉⲛⲧⲟⲗⲏ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁⲓⲙⲉⲛⲣⲉ ⲑⲏⲛⲟⲩ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","⳿ⲙⲙⲟⲛ ⲡⲉⲑⲛⲁⲁⲥ ⳿ⲉⲧⲁⲓⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉⲛ ⳿ϩⲗⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲭⲱ ⳿ⲛⲧⲉϥⲯⲩⲭⲏ ⳿ⲉϫⲉⲛ ⲡⲉϥ⳿ϣⲫⲏⲣ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁ⳿ϣⲫⲏⲣ ⲉϣⲱⲡ ⲁⲣⲉⲧⲉⲛϣⲁⲛⲉⲣ ⲛⲏ ⳿ⲉϯϩⲟⲛϩⲉⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","⳿ⲛϯⲛⲁⲙⲟⲩϯ ⳿ⲉⲣⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⲃⲱⲕ ϫⲉ ⳿ⲙⲡⲁⲣⲉ ⲡⲓⲃⲱⲕ ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲡⲉⲧⲉ ⲡⲉϥ⳪ ⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲁⲓⲛⲁⲙⲟⲩϯ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉ ⲛⲁ⳿ϣⲫⲏⲣ ϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲓⲥⲟⲑⲙⲟⲩ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲡⲁⲓⲱⲧ ⲁⲓⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛ ⲁⲣⲉⲧⲉⲛⲥⲟⲧⲡⲧ ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⲁⲓⲥⲉⲧⲡ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲁⲓⲭⲁ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϣⲉ ⲛⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲛ ⲟⲩⲧⲁϩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲉⲧⲉⲛⲟⲩⲧⲁϩ ⳿ⲛⲧⲉϥⲟϩⲓ ϩⲓⲛⲁ ⲫⲏⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙ⳿ⲫⲓⲱⲧ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⳿ⲛⲧⲉϥⲧⲏⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ⲛⲁⲓ ⲇⲉ ϯϩⲟⲛϩⲉⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ⲓⲥϫⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲣⲓ⳿ⲉⲙⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⳿ⲛϣⲟⲣⲡ ⲡⲉⲧⲁϥⲙⲟⲥϯ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","⳿ⲉⲛⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁⲣⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁⲙⲉⲛⲣⲉ ⲡⲉⲧⲫⲱϥ ⲟⲧⲓ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⲁⲓⲥⲉⲧⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲉⲑⲃⲉⲫⲁⲓ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲙⲟⲥϯ ⳿ⲙⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ⲁⲣⲓ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⲉⲧⲁⲓⲥⲁϫⲓ ⳿ⲙⲙⲟϥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩⲃⲱⲕ ⳿ⲉⲛⲁⲁϥ ⳿ⲉⲡⲉϥ⳪ ⲓⲥϫⲉ ⲁⲩϭⲟϫⲓ ⳿ⲛⲥⲱⲓ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲉⲩ⳿ⲉϭⲟϫⲓ ⳿ⲛⲥⲱⲧⲉⲛ ⲓⲥϫⲉ ⲁⲩⲁⲣⲉϩ ⳿ⲉⲡⲁⲥⲁϫⲓ ⲉⲩ⳿ⲉⲁⲣⲉϩ ⳿ⲉⲫⲱⲧⲉⲛ ϩⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ⲁⲗⲗⲁ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲥⲉⲛⲁⲁⲓⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲉⲑⲃⲉ ⲡⲁⲣⲁⲛ ϫⲉ ⲥⲉⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","⳿ⲉⲛⲉ ⳿ⲙⲡⲓ⳿ⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲛⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲃⲓ ⳿ⲙⲙⲁⲩ ϯⲛⲟⲩ ⲇⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲗⲱⲓϫⲓ ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲉ ⲡⲟⲩⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ⲫⲏⲉⲑⲙⲟⲥϯ ⳿ⲙⲙⲟⲓ ⳿ϥⲙⲟⲥϯ ⳿ⲙⲡⲁⲕⲉⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","⳿ⲉⲛⲉ ⳿ⲙⲡⲓ⳿ⲓⲣⲓ ⳿ⲛⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏ ⲧⲟⲩ ⲛⲏⲉⲧⲉ⳿ⲙⲡⲉ ⲕⲉⲟⲩⲁⲓ ⲁⲓⲧⲟⲩ ⲛⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲃⲓ ⳿ⲙⲙⲁⲩ ϯⲛⲟⲩ ⲇⲉ ⲁⲩⲛⲁⲩ ⲟⲩⲟϩ ⲁⲩⲙⲉⲥⲧⲱⲓ ⲛⲉⲙ ⲡⲁⲕⲉⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲥⲁϫⲓ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲓ ⲡⲟⲩⲛⲟⲙⲟⲥ ϫⲉ ⲁⲩⲙⲉⲥⲧⲱⲓ ⳿ⲛϫⲓⲛϫⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲡⲁⲣⲁⲕⲗⲏ ⲧⲟⲥ ⲫⲏ ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁⲟⲩⲟⲣⲡϥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲁⲓⲱⲧ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲫⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲓⲱⲧ ⳿ⲛⲑⲟϥ ⲉⲑⲛⲁⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⲧⲉⲧⲉⲛⲭⲏ ⲛⲉⲙⲏⲓ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ");
INSERT INTO copcnt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ⲛⲁⲓ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ⲁⲩϣⲁⲛⲉⲣ ⲑⲏⲛⲟⲩ ⳿ⲛⲁⲡⲟⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲁⲗⲗⲁ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ϩⲓⲛⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϧⲱⲧⲉⲃ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲧⲉϥⲙⲉⲩⲓ ϫⲉ ⲁϥ⳿ⲓⲛⲓ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ⲟⲩⲟϩ ⲛⲁⲓ ⲉⲩ⳿ⲉⲁⲓⲧⲟⲩ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩ ⲏⲓ ⳿ⲙⲡⲟⲩⲥⲟⲩⲉⲛ ⳿ⲫⲓⲱⲧ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲡⲟⲩⲥⲟⲩⲱⲛⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ⲁⲗⲗⲁ ⲛⲁⲓ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⲁⲥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ϯⲟⲩⲛⲟⲩ ⳿ⲛⲧⲉⲧⲉⲛⲉⲣⲡⲟⲩⲙⲉⲩⲓ ϫⲉ ⲁⲓⲟⲩⲱ ⳿ⲁⲛⲟⲕ ⲉⲓϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲛⲱⲧⲉⲛ ⲛⲁⲓ ⲇⲉ ⳿ⲙⲡⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲓⲥϫⲉⲛ ϩⲏ ϫⲉ ⲛⲁⲓⲭⲏ ⲛⲉⲙⲱⲧⲉⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ϯⲛⲟⲩ ⲇⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⲫⲏⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏ ⲛⲟⲩ ϣⲓⲛⲓ ⳿ⲙⲙⲟⲓ ϫⲉ ⳿ⲭⲛⲁϣⲉ ⲛⲁⲕ ⳿ⲉⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ⲁⲗⲗⲁ ϫⲉ ⲁⲓϫⲉ ⲛⲁⲓ ⲛⲱⲧⲉⲛ ⲁ ⳿ⲡⲉⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲙⲁϩ ⲡⲉⲧⲉⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ⲁⲗⲗⲁ ⳿ⲁⲛⲟⲕ ⳿ⲑⲙⲏⲓ ⲡⲉϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲁⲛⲟⲕ ⳿ⲛⲧⲁϣⲉ ⲛⲏⲓ ⲉϣⲱⲡ ⲅⲁⲣ ⲁⲓ⳿ϣⲧⲉⲙϣⲉ ⲛⲏⲓ ⲡⲓⲡⲁⲣⲁⲕⲗⲏ ⲧⲟⲥ ⲛⲁⲓ ϩⲁⲣⲱⲧⲉⲛ ⲁⲛ ⲉϣⲱⲡ ⲇⲉ ⲁⲓϣⲁⲛϣⲉ ⲛⲏⲓ ϯⲛⲁⲟⲩⲟⲣⲡϥ ϩⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ⲟⲩⲟϩ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉϥ⳿ⲉⲥⲟϩⲓ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲉⲑⲃⲉ ⳿ⲫⲛⲟⲃⲓ ⲛⲉⲙ ⲉⲑⲃⲉ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲛⲉⲙ ⲉⲑⲃⲉ ⲟⲩϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ⲉⲑⲃⲉ ⳿ⲫⲛⲟⲃⲓ ⲙⲉⲛ ϫⲉ ⲥⲉⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ⲉⲑⲃⲉ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲇⲉ ϫⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁⲛ ϫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ⲉⲑⲃⲉ ⲟⲩϩⲁⲡ ⲇⲉ ϫⲉ ⳿ⲡⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲁⲩⲟⲩⲱ ⲉⲩϯϩⲁⲡ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ⲟⲩⲟⲛϯ ϩⲁⲛⲕⲉⲙⲏϣ ⳿ⲉϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ⲁⲗⲗⲁ ⲧⲉⲧⲉⲛⲛⲁ⳿ϣϥⲁⲓ ϧⲁⲣⲱⲟⲩ ϯⲛⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲉϥ⳿ⲉϭⲓⲙⲱⲓⲧ ⲛⲱⲧⲉⲛ ϧⲉⲛ ⲙⲉⲑⲙⲏⲓ ⲛⲓⲃⲉⲛ ⲁϥⲛⲁⲥⲁϫⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲗⲗⲁ ⲛⲏⲉⲧⲁϥⲛⲁⲥⲟⲑⲙⲟⲩ ⲉⲧⲉϥⲛⲁⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⲟⲩⲟϩ ⲛⲏⲉⲑⲛⲏⲟⲩ ⲉϥ⳿ⲉⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲑⲛⲁϯⲱⲟⲩ ⲛⲏⲓ ϫⲉ ⲁϥⲛⲁϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲫⲱⲓ ⲟⲩⲟϩ ⳿ϥⲛⲁⲧⲁⲙⲉ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲛⲧⲉ ⲡⲁⲓⲱⲧ ⲛⲟⲩ⳿Ⲓ ⲛⲉ ⲉⲑⲃⲉⲫⲁⲓ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲁϥⲛⲁϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲫⲱⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲁⲙⲉ ⲑⲏ ⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁⲛ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ⲡⲉϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏ ⲧⲏⲥ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⲡⲁⲓⲥⲁϫⲓ ⲟⲩ ⲡⲉ ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲟϥ ⲛⲁⲛ ϫⲉ ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁⲛ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲟⲩⲟϩ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲟϥ ϫⲉ ⲕⲉⲕⲟⲩϫⲓ ⳿ⲛⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ⲁϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲛⲁⲩⲟⲩⲱϣ ⳿ⲉϣⲉⲛϥ ⲡⲉ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲡⲁⲓⲥⲁϫⲓ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲛⲁⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁⲛ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⲕⲉⲕⲟⲩϫⲓ ⲧⲉⲧⲉⲛⲁⲛⲁⲩ ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁⲣⲓⲙⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲉⲣϩⲏ ⲃⲓ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ϥⲛⲁⲣⲁϣⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲛⲁⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲁⲗⲗⲁ ⲡⲉⲧⲉⲛ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⳿ϥⲛⲁϣⲱⲡⲓ ⲛⲱⲧⲉⲛ ⲉⲩⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ϯ⳿ⲥϩⲓⲙⲓ ⲁⲥϣⲁⲛⲛⲟⲩ⳿ⲓ ⳿ⲉⲙⲓⲥⲓ ϣⲁⲥⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲛϫⲉ ⲧⲉⲥⲟⲩⲛⲟⲩ ⲉϣⲱⲡ ⲇⲉ ⲁⲥϣⲁⲛⲙⲓⲥⲓ ⳿ⲙⲡⲓϣⲏⲣⲓ ⳿ⲙⲡⲁⲥⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲓϩⲟϫϩⲉϫ ⲉⲑⲃⲉ ⲡⲓⲣⲁϣⲓ ϫⲉ ⲁⲥⲙⲉⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ϯⲛⲟⲩ ⲉⲣⲉⲧⲉⲛ⳿ⲉϭ ⲓ ⳿ⲛⲟⲩ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲡⲁⲗⲓⲛ ⲟⲛ ϯⲛⲁⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲣⲁϣⲓ ⲟⲩⲟϩ ⲡⲉⲧⲉⲛⲣⲁϣⲓ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲛⲁⲟⲗϥ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲧⲉⲧⲉⲛⲛⲁϣⲉⲛⲧ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⲫⲏⲉⲧⲉⲧⲉⲛⲛⲁⲉⲣⲉⲧⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲛⲧⲟⲧϥ ⳿ⲙ⳿ⲫⲓⲱⲧ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲉϥ⳿ⲉⲧⲏⲓϥ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ϣⲁ ϯⲛⲟⲩ ⳿ⲙⲡⲁⲧⲉⲧⲉⲛⲉⲣⲉⲧⲓⲛ ⳿ⲛ⳿ϩⲗⲓ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲁⲣⲓⲉⲧⲓⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϭⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲣⲁϣⲓ ϣⲱⲡⲓ ⲉϥϫⲏⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ⲛⲁⲓ ⲇⲉ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲟⲓⲙⲓ⳿ⲁ ⳿ⲥⲛⲏⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ϩⲟⲧⲉ ⲉⲓⲛⲁⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⲁⲛ ϫⲉ ϧⲉⲛ ϩⲁⲛⲡⲁⲣⲟⲓⲙⲓ⳿ⲁ ⲁⲗⲗⲁ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓ⳿ⲁ ϯⲛⲁⲧⲁⲙⲱⲧⲉⲛ ⲉⲑⲃⲉ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲉⲣⲉⲧⲓⲛ ϧⲉⲛ ⲡⲁⲣⲁⲛ ⲟⲩⲟϩ ϯⲛⲁϫⲟⲥ ⲛⲱⲧⲉⲛ ⲁⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁϯϩⲟ ⳿ⲉ⳿ⲫⲓⲱⲧ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","⳿ⲛⲑⲟϥ ⲅⲁⲣ ϩⲱϥ ⳿ⲫⲓⲱⲧ ⳿ϥⲙⲉⲓ ⳿ⲙⲙⲱⲧⲉⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲣⲉⲧⲉⲛⲙⲉⲛⲣⲓⲧ ⲟⲩⲟϩ ⲁⲣⲉⲧⲉⲛⲛⲁϩϯ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲓⲱⲧ ⲟⲩⲟϩ ⲁⲓ⳿Ⲓ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲡⲁⲗⲓⲛ ⲟⲛ ϯⲛⲁⲭⲱ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ϯⲛⲁϣⲉ ⲛⲏⲓ ϩⲁ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ⲡⲉϫⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ϯⲛⲟⲩ ⳿ⲕⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲕϫⲉ ⳿ϩⲗⲓ ⲁⲛ ⳿ⲙⲡⲁⲣⲟⲓⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ϯⲛⲟⲩ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⳿ⲛ⳿ⲕⲉⲣ⳿ⲭⲣⲓⲁ ⲁⲛ ⲉⲑⲣⲉ ⲟⲩⲁⲓ ϣⲉⲛⲕ ϧⲉⲛ ⲫⲁⲓ ⲧⲉⲛⲛⲁϩϯ ϫⲉ ⲁⲕ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲁ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϯⲛⲟⲩ ⲧⲉⲧⲉⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ϩⲏⲡⲡⲉ ⳿ⲥⲛⲏⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲛⲟⲩ ⲟⲩⲟϩ ⲁⲥ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϫⲱⲣ ⳿ⲉⲃⲟⲗ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲉⲡⲉϥⲙⲁ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲭⲁⲧ ⳿ⲙⲙⲁⲩⲁⲧ ⲟⲩⲟϩ ϯⲭⲏ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲛ ϫⲉ ⳿ϥⲭⲏ ⲛⲉⲙⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ⲛⲁⲓ ⲁⲓϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲟⲩϩⲓⲣⲏⲛⲏ ϣⲱⲡⲓ ⲛⲱⲧⲉⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩϩⲟϫϩⲉϫ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ϫⲉⲙⲛⲟⲙϯ ⳿ⲁⲛⲟⲕ ⲁⲓϭⲣⲟ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ");
INSERT INTO copcnt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ⲛⲁⲓ ⲁϥⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲧⲁϥϥⲁⲓ ⳿ⲛⲛⲉϥⲃⲁⲗ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁⲓⲱⲧ ⲙⲁⲱⲟⲩ ⳿ⲙⲡⲉⲕϣⲏⲣⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉⲕϣⲏⲣⲓ ϯⲱⲟⲩ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁⲕϯ ⲉⲣϣⲓϣⲓ ⲛⲁϥ ⳿ⲉϫⲉⲛ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ϩⲓⲛⲁ ⲫⲏ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲕⲧⲏⲓϥ ⲛⲁϥ ⳿ⲛⲧⲉϥϯ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ⲫⲁⲓ ⲇⲉ ⲡⲉ ⲡⲓⲱⲛϧ ⳿ⲛⲉⲛⲉϩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲥⲟⲩⲱⲛⲕ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲫϯ ⳿ⲛⲧⲁ⳿ⲫⲙⲏ ⲓ ⲛⲉⲙ ⲫⲏⲉⲧⲁⲕⲟⲩⲟⲣⲡϥ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","⳿ⲁⲛⲟⲕ ⲁⲓϯⲱⲟⲩ ⲛⲁⲕ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉⲧⲁⲓϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓϩⲱⲃ ⲉⲧⲁⲕⲧⲏⲓϥ ⲛⲏⲓ ϫⲉ ⳿ⲛⲧⲁⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲙⲁⲱⲟⲩ ⲛⲏⲓ ⳿ⲛⲑⲟⲕ ⲡⲁⲓⲱⲧ ϧⲁⲧⲟⲧⲕ ϧⲉⲛ ⲡⲓⲱⲟⲩ ⳿ⲉⲛⲁϥ⳿ⲛⲧⲏⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲡⲁⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ϣⲱⲡⲓ ϧⲁⲧⲟⲧⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ⲁⲓⲟⲩⲱⲛϩ ⳿ⲙⲡⲉⲕⲣⲁⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲛⲏⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲟⲩⲕ ⲛⲉ ⲟⲩⲟϩ ⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⲟⲩⲟϩ ⲡⲉⲕⲥⲁϫⲓ ⲁⲩⲁⲣⲉϩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲁⲩ⳿ⲉⲙⲓ ϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ϫⲉ ⲛⲓⲥⲁϫⲓ ⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⲁⲓⲧⲏⲓⲧⲟⲩ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⲁⲩϭⲓⲧⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲙⲓ ⲧⲁ⳿ⲫⲙⲏⲓ ϫⲉ ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ⲟⲩⲟϩ ⲁⲩⲛⲁϩϯ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","⳿ⲁⲛⲟⲕ ϯⲧⲱⲃϩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲟⲩ ⲛⲁⲓⲧⲱⲃϩ ⲁⲛ ⲉⲑⲃⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⲛⲏⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ϫⲉ ⲛⲟⲩⲕ ⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ⲟⲩⲟϩ ⲛⲏⲉⲧⲉⲛⲟⲩ⳿ⲓ ⲛⲟⲩⲕ ⲛⲉ ⲟⲩⲟϩ ⲁⲓϭⲓⲱⲟⲩ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ⲟⲩⲟϩ ϯⲭⲏ ⲁⲛ ϫⲉ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁⲓ ⲇⲉ ⳿ⲛⲑⲱⲟⲩ ⲥⲉⲭⲏ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϯⲛⲏⲟⲩ ϩⲁⲣⲟⲕ ⲡⲁⲓⲱⲧ ⲡⲓⲁⲅⲓⲟⲥ ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲫⲏⲉⲧⲁⲕⲧⲏⲓϥ ⲛⲏⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ ⳿ⲙⲡⲉⲛⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ϩⲟⲧⲉ ⳿ⲁⲛⲟⲕ ⲉⲓⲭⲏ ⲛⲉⲙⲱⲟⲩ ⲛⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉⲕⲣⲁⲛ ⲫⲏⲉⲧⲁⲕⲧⲏ ⲓϥ ⲛⲏⲓ ⲁⲓⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲧⲁⲕⲟ ⳿ⲉⲃⲏⲗ ⳿ⲉ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲧⲉ ⳿ⲡⲧⲁⲕⲟ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ϯⲛⲟⲩ ⲇⲉ ⲁⲓⲛⲏⲟⲩ ϩⲁⲣⲟⲕ ⲟⲩⲟϩ ⲛⲁⲓ ϯⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲁⲣⲁϣⲓ ϣⲱⲡⲓ ⲉϥϫⲏⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","⳿ⲁⲛⲟⲕ ⲁⲓϯ ⲛⲱⲟⲩ ⳿ⲙⲡⲉⲕⲥⲁϫⲓ ⲟⲩⲟϩ ⲁ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲙⲉⲥⲧⲱⲟⲩ ϫⲉ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲛⲉ ⳿ⲙⲡⲁⲣⲏϯ ϩⲱ ⲉⲧⲉ ⲁⲛⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ⲛⲁⲓϯϩⲟ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲟⲗⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲁ ⲡⲓⲡⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲛⲉ ⳿ⲙⲡⲁⲣⲏϯ ϩⲱ ⲉⲧⲉ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ⲙⲁⲧⲟⲩⲃⲱⲟⲩ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ϯⲙⲉⲑⲙⲏⲓ ⲡⲉⲧⲉⲫⲱⲕ ⳿ⲛⲥⲁϫⲓ ⲡⲉ ϯⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲕⲟⲩⲟⲣⲡⲧ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲁⲛⲟⲕ ϩⲱ ⲁⲓⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ⲟⲩⲟϩ ϯⲧⲟⲩⲃⲟ ⳿ⲙⲙⲟⲓ ⳿ⲁⲛⲟⲕ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ϩⲱⲟⲩ ⲉⲩⲧⲟⲩⲃⲏ ⲟⲩⲧ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ⲛⲁⲓϯϩⲟ ⲇⲉ ⲁⲛ ⲉⲑⲃⲉ ⲛⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲁⲗⲗⲁ ⲛⲉⲙ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲟⲩⲥⲁϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲫⲓⲱⲧ ⲉⲧⲉⲕϣⲟⲡ ⳿ⲛ⳿ϩⲣⲏ ⲓ ⳿ⲛϧⲏⲧ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧⲕ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⳿ⲛϧⲏⲧⲉⲛ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁϩϯ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲡⲓⲱⲟⲩ ⲉⲧⲁⲕⲧⲏⲓϥ ⲛⲏⲓ ⲁⲓⲧⲏⲓϥ ⲛⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ϩⲱⲟⲩ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ ⳿ⲙⲡⲉⲛⲣⲏϯ ϩⲱⲛ ⲉⲛϣⲟⲡ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⲉⲩϫⲏⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲉⲙⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ⲡⲁⲓⲱⲧ ⲫⲏⲉⲧⲁⲕⲧⲏⲓϥ ⲛⲏⲓ ϯⲟⲩⲱϣ ϩⲓⲛⲁ ⳿ⲫⲙⲁ ⳿ⲉϯϣⲟⲡ ⳿ⲙⲙⲟϥ ⳿ⲁⲛⲟⲕ ⳿ⲛⲧⲟⲩϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲛⲉⲙⲏⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲛⲁⲩ ⳿ⲉⲡⲁⲱⲟⲩ ⲉⲧⲁⲕⲧⲏ ⲓϥ ⲛⲏⲓ ϫⲉ ⲁⲕⲙⲉⲛⲣⲓⲧ ϧⲁϫⲉⲛ ⳿ⲧⲕⲁⲧⲁⲃⲟⲗⲏ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ⲡⲁⲓⲱⲧ ⲡⲓ⳿ⲑⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲥⲟⲩⲱⲛⲕ ⳿ⲁⲛⲟⲕ ⲁⲓⲥⲟⲩⲱⲛⲕ ⲟⲩⲟϩ ⲛⲁⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲁⲩ⳿ⲉⲙⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲧⲁⲟⲩⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ⲟⲩⲟϩ ⲁⲓⲧⲁⲙⲱⲟⲩ ⳿ⲉⲡⲉⲕⲣⲁⲛ ⲟⲩⲟϩ ϯⲛⲁⲧⲁⲙⲱⲟⲩ ϩⲓⲛⲁ ϯⲁⲅⲁⲡⲏ ⲉⲧⲁⲕⲙⲉⲛⲣⲓⲧ ⳿ⲛϧⲏⲧⲥ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛ⳿ϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲙⲏⲣ ⳿ⲙⲡⲓⲙⲟⲩⲛⲥⲱⲣⲉⲙ ⳿ⲛⲧⲉ ⲛⲓϣⲉⲛⲥⲓϥⲓ ⲡⲓⲙⲁ ⲉⲧⲉⲟⲩⲟⲛ ⲟⲩϭⲱⲙ ⳿ⲙⲙⲟϥ ⲫⲁⲓ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ⲟⲩⲟϩ ⲓⲟⲩⲇⲁⲥ ⲫⲏ ⳿ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ ⲛⲁϥⲥⲱⲟⲩⲛ ϩⲱϥ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⲁϥⲑⲱⲟⲩϯ ⳿ⲉⲙⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ⲓⲟⲩⲇⲁⲥ ⲟⲩⲛ ⲉⲧⲁϥϭⲓ ⳿ⲙⲡⲓⲙⲏϣ ⲛⲉⲙ ϩⲁⲛϩⲩⲡⲉⲣⲉⲧⲏⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓⲫⲁⲣⲓⲥⲉⲟⲥ ⲁϥ⳿ⲓ ⳿ⲉⲙⲁⲩ ⲛⲉⲙ ϩⲁⲛⲫⲁⲛⲟⲥ ⲛⲉⲙ ϩⲁⲛⲗⲁⲙⲡⲁⲥ ⲛⲉⲙ ϩⲁⲛϩⲟⲡⲗⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉϥⲥⲱⲟⲩⲛ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲏ ⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ⲁⲩⲉⲣⲟⲩⲱ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲛⲁⲍⲱⲣⲉⲟⲥ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲛⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲛⲉⲙⲱⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲓⲟⲩⲇⲁⲥ ⲫⲏ ⳿ⲉⲛⲁϥⲛⲁⲧⲏⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲁⲩⲫⲱⲧ ⳿ⲉⲫⲁϩⲟⲩ ⲟⲩⲟϩ ⲁⲩϩⲉⲓ ⳿ⲉⲡⲉⲥⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥϣⲉⲛⲟⲩ ϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲛⲓⲙ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲛⲁⲍⲱⲣⲉⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲁⲓϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲓⲥϫⲉ ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲭⲁ ⲛⲁⲓ ⳿ⲉⲃⲟⲗ ⲙⲁⲣⲟⲩϣⲉ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲥⲁϫⲓ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲉⲧⲁϥϫⲟϥ ϫⲉ ⲛⲏⲉⲧⲁⲕⲧⲏⲓⲧⲟⲩ ⲛⲏⲓ ⳿ⲙⲡⲓⲧⲁⲕⲉ ⳿ϩⲗⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ⲥⲓⲙⲱⲛ ⲟⲩⲛ ⲡⲉⲧⲣⲟⲥ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲥⲏϥⲓ ⳿ⲛⲧⲟⲧϥ ⲁϥⲑⲟⲕⲙⲉⲥ ⲟⲩⲟϩ ⲁϥϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲥⲁ ⳿ⲫⲃⲱⲕ ⳿ⲙⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲁϥϫⲱϫⲓ ⳿ⲙⲡⲉϥⲙⲁϣϫ ⳿ⲛⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲉⲃⲟⲗ ⳿ⲫⲣⲁⲛ ⲇⲉ ⳿ⲙⲡⲓⲃⲱⲕ ⲡⲉ ⲙⲁⲗⲭⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⳿ⲙⲡⲉⲧⲣⲟⲥ ϫⲉ ϩⲓⲟⲩ⳿Ⲓ ⳿ⲛϯⲥⲏϥⲓ ⳿ⲉⲧⲉⲥⲑⲏⲕⲏ ⲡⲓ⳿ⲁⲫⲟⲧ ⲉⲧⲁϥⲧⲏⲓϥ ⲛⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⲁⲛ ϯⲛⲁⲥⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ⲡⲓⲙⲏϣ ⲟⲩⲛ ⲛⲉⲙ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲛⲉⲙ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ⲁⲩⲥⲟⲛϩϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ⲟⲩⲟϩ ⲁⲩ⳿ⲉⲛϥ ⳿ⲛϣⲟⲣⲡ ϩⲁ ⲁⲛⲛⲁ ⲛⲉ ⳿ⲡϣⲟⲙ ⲅⲁⲣ ⳿ⲛⲕⲁⲓⲁⲫⲁ ⲫⲏ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲛⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲛⲧⲉ ϯⲣⲟⲙⲡⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ⲛⲉ ⲫⲁⲓ ⲇⲉ ⲡⲉ ⲕⲁⲓⲁⲫⲁ ⲫⲏⲉⲧⲁϥⲥⲟϭ ⲛⲓ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲥⲉⲣⲛⲟϥⲣⲓ ⳿ⲛⲧⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲟⲩⲱⲧ ⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ⲛⲁϥⲙⲟϣⲓ ⲇⲉ ⲡⲉ ⳿ⲛⲥⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲕⲉⲙⲁⲑⲏⲧⲏⲥ ⲡⲓⲙⲁⲑⲏ ⲧⲏⲥ ⲇⲉ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁϥⲟⲓ ⳿ⲛⲥⲟⲩⲓⲛ ⲡⲉ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⳿ⲉϯⲁⲩⲗⲏ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ⲡⲉⲧⲣⲟⲥ ⲛⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁⲃⲟⲗ ϧⲁⲧⲉⲛ ⲡⲓⲣⲟ ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲫⲏ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲛⲣⲉⲙⲥⲱⲟⲩⲛ ⳿ⲉⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲁϥⲥⲁϫⲓ ⲛⲉⲙ ϯⲉⲙⲛⲟⲩⲧ ⲟⲩⲟϩ ⲁϥ⳿ⲓⲛⲓ ⳿ⲙⲡⲉⲧⲣⲟⲥ ⳿ⲉϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ⲡⲉϫⲉ ϯ⳿ⲁⲗⲟⲩ ⳿ⲛⲉⲙⲛⲟⲩⲧ ⳿ⲙⲡⲉⲧⲣⲟⲥ ϫⲉ ⲙⲏ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲛⲙⲁⲑⲏⲧⲏⲥ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ϩⲱⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ⲛⲁⲩⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲃⲓⲁⲓⲕ ⲛⲉⲙ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⳿ⲉⲁⲩϭⲉⲣⲟ ⳿ⲛⲟⲩⲣⲁⲕϩⲓ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲉ ⳿ⲧⲫⲣⲱ ⲧⲉ ⲟⲩⲟϩ ⲛⲁⲩ⳿ⲧ⳿ϧⲙⲟ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ⲛⲁϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⲛⲉⲙⲱⲟⲩ ϩⲱϥ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ⲉϥ⳿ⲧ⳿ϧⲙⲟ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲟⲩⲛ ⲁϥϣⲉⲛ Ⲓⲏ̅ⲥ̅ ⲉⲑⲃⲉ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲉⲙ ⲉⲑⲃⲉ ⲧⲉϥ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ⲁϥⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲁⲓⲥⲁϫⲓ ⲛⲉⲙ ⲡⲓⲕⲟⲥⲙⲟⲥ ϧⲉⲛ ⲟⲩⲡⲁⲣⲣⲏⲥⲓ⳿ⲁ ⲟⲩⲟϩ ⲛⲁⲓϯ⳿ⲥⲃⲱ ⲡⲉ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲡⲓⲙⲁ ⳿ⲉϣⲁⲣⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⲑⲱⲟⲩϯ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲙⲡⲓϫⲉ ⳿ϩⲗⲓ ⳿ⲛⲥⲁϫⲓ ϧⲉⲛ ⲡⲉⲧϩⲏⲡ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ⲉⲑⲃⲉⲟⲩ ⳿ⲕϣⲓⲛⲓ ⳿ⲙⲙⲟⲓ ϣⲉⲛ ⲛⲏⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⲟⲩ ⲡⲉⲧⲁⲓϫⲟϥ ⲛⲱⲟⲩ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲁⲓ ⲥⲉ⳿ⲉⲙⲓ ⳿ⲉⲛⲏ ⳿ⲉⲧⲁⲓϫⲟⲧⲟⲩ ⳿ⲁⲛⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁ ⲟⲩⲁⲓ ⳿ⲛⲧⲉ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⲉⲧⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲁϥϯ ⳿ⲛⲟⲩⲕⲟⲩⲣ ⳿ⲛⲒⲏ̅ⲥ̅ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛ ⲫⲁⲓ ⲡⲉ ⳿ⲫⲣⲏϯ ⳿ⲛⲉⲣⲟⲩⲱ ⳿ⲙⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲓⲥϫⲉ ⲕⲁⲕⲱⲥ ⲁⲓⲥⲁϫⲓ ⲁⲣⲓⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲡⲓⲕⲁⲕⲱⲥ ⲓⲥϫⲉ ⲇⲉ ⲕⲁⲗⲱⲥ ⲉⲑⲃⲉⲟⲩ ⳿ⲕϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ⲧⲟⲧⲉ ⲁϥⲟⲩⲟⲣⲡϥ ⳿ⲛϫⲉ ⲁⲛⲛⲁ ⲉϥⲥⲟⲛϩ ϩⲁ ⲕⲁⲓⲁⲫⲁ ⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ⲛⲁϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲉϥ⳿ⲧ⳿ϧⲙⲟ ⳿ⲙⲙⲟϥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲙⲏ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϩⲱⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ⲡⲉϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲉⲃⲓⲁⲓⲕ ⳿ⲛⲧⲉ ⲡⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲉⲟⲩⲥⲩⲅⲅⲉⲛⲏⲥ ⲡⲉ ⳿ⲛⲧⲉ ⲫⲏⲉⲧⲁ ⲡⲉⲧⲣⲟⲥ ϫⲱϫⲓ ⳿ⲙⲡⲉϥⲙⲁϣϫ ⳿ⲉⲃⲟⲗ ϫⲉ ⲙⲏ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲁⲓⲛⲁⲩ ⳿ⲉⲣⲟⲕ ⲛⲉⲙⲁϥ ϧⲉⲛ ⲡⲓ ϭⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥϫⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁ ⲟⲩ⳿ⲁⲗⲉⲕⲧⲱⲣ ⲙⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ⲁⲩ⳿ⲓⲛⲓ ⲟⲩⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϩⲁ ⲕⲁⲓⲁⲫⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⲛⲉ ϣⲱⲣⲡ ⲇⲉ ⲡⲉ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲙⲡⲟⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ϩⲓⲛⲁ ϫⲉ ⳿ⲛⲛⲟⲩⲥⲱϥ ϣⲁⲧⲟⲩⲟⲩⲱⲙ ⳿ⲙⲡⲓⲡⲁⲥ ⲭⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲟⲩ ⳿ⲛⲕⲁⲧⲏ ⲅⲟⲣⲓ⳿ⲁ ⲉⲧⲉⲧⲉⲛ⳿ⲓⲛⲓ ⳿ⲙⲙⲟⲥ ϧⲁ ⲡⲁⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ⲁⲩⲉⲣⲟⲩⲱ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲉⲛⲉ ⲫⲁⲓ ⲟⲩⲥⲁ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲁⲛ ⲡⲉ ⲛⲁⲛⲛⲁⲧⲏⲓϥ ⲛⲁⲕ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ϫⲉ ϭⲓⲧϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲙⲁϩⲁⲡ ⳿ⲉⲣⲟϥ ⲕⲁⲧⲁ ⲡⲉⲧⲉⲛⲛⲟⲙⲟⲥ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⳿ⲁⲛⲟⲛ ⳿ⲥϣⲉ ⲛⲁⲛ ⲁⲛ ⳿ⲉϧⲱⲧⲉⲃ ⳿ⲛ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲫⲏⲉⲧⲁϥϫⲟϥ ⲉϥⲉⲣⲥⲏⲙⲉⲛⲓⲛ ϫⲉ ϧⲉⲛ ⲁϣ ⳿ⲙⲙⲟⲩ ⳿ϥⲛⲁⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲒⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲉⲧϫⲱ ⳿ⲙⲫⲁⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ϣⲁⲛ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲡⲉⲧⲁⲩϫⲟⲥ ⲛⲁⲕ ⲉⲑⲃⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⳿ⲁⲛⲟⲕ ⲟⲩⲓⲟⲩⲇⲁⲓ ϩⲱ ⲡⲉⲕⲉⲑⲛⲟⲥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟⲕ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲛⲑⲱⲟⲩ ⲡⲉⲧⲁⲩⲧⲏ ⲓⲕ ⲟⲩ ⲡⲉⲧⲁⲕⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⲧⲁⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲑⲁ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲧⲉ ⲉⲛⲉ ⲧⲁⲙⲉⲧⲟⲩⲣⲟ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲧⲉ ⲛⲁⲣⲉ ⲛⲁϩⲩⲡⲉⲣⲉⲧⲏ ⲥ ⲛⲁⲩⲛⲁϯ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⲡⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲧⲏ ⲓⲧ ⳿ⲛⲛⲓⲟⲩⲇⲁⲓ ϯⲛⲟⲩ ⲇⲉ ⲧⲁⲙⲉⲧⲟⲩⲣⲟ ⲑⲁ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ⲡⲓⲗⲁⲧⲟⲥ ⲟⲩⲛ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩⲕⲟⲩⲛ ⳿ⲛⲑⲟⲕ ⲟⲩⲟⲩⲣⲟ ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲟⲩⲣⲟ ⲕⲉ ⲅⲁⲣ ⲉⲧⲁⲩⲙⲁⲥⲧ ⳿ⲁⲛⲟⲕ ⳿ⲉⲡⲁⲓϩⲱⲃ ⲟⲩⲟϩ ⲉⲑⲃⲉⲫⲁⲓ ⲁⲓ⳿ⲓ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲁⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲉ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲙⲉⲑⲙⲏⲓ ⲛⲉ ϣⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲧⲁ⳿ⲥⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲁϥ ϫⲉ ⲟⲩ ⲡⲉ ϯⲙⲉⲑⲙⲏⲓ ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲁ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲕ ⳿ⲛϯϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛ⳿ⲉⲧⲓ⳿ⲁ ⲁⲛ ϧⲉⲛ ⲡⲁⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ⲧⲉⲧⲉⲛⲥⲩⲛⲏⲑⲓ⳿ⲁ ⲇⲉ ⲧⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲭⲁ ⲟⲩⲁⲓ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲡⲁⲥⲭⲁ ⲧⲉⲧⲉⲛⲟⲩⲱϣ ⲟⲩⲛ ⳿ⲛⲧⲁⲭⲱ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ⲁⲩⲱϣ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲭⲁ ⲫⲁⲓ ⳿ⲉⲃⲟⲗ ⲁⲗⲗⲁ ⲭⲁ ⲃⲁⲣⲁⲃⲃⲁⲥ ⲡⲁⲓⲃⲁⲣⲁⲃⲃⲁⲥ ⲇⲉ ⲛⲉ ⲟⲩⲥⲟⲛⲓ ⲡⲉ ");
INSERT INTO copcnt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ⲧⲟⲧⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲁϥϭⲓ ⳿ⲛⲒⲏ̅ⲥ̅ ⲁϥⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ⲟⲩⲟϩ ⲛⲓⲙⲁⲧⲟⲓ ⲁⲩϣⲱⲛⲧ ⳿ⲛⲟⲩ⳿ⲭⲗⲟⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛⲥⲟⲩⲣⲓ ⲁⲩⲧⲏⲓϥ ⳿ⲉϫⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ ⲟⲩⲟϩ ⲁⲩϫⲟⲗϩϥ ⳿ⲛⲟⲩ⳿ϩⲃⲟⲥ ⳿ⲛϭⲏϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ϩⲁⲣⲟϥ ⲡⲉ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲉⲣⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲛⲁⲩϯⲕⲟⲩⲣ ⲛⲁϥ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ϯⲛⲁ⳿ⲉⲛϥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ϯϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛ⳿ⲉⲧⲓ⳿ⲁ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉϥⲉⲣⲫⲟⲣⲓⲛ ⳿ⲙⲡⲓ⳿ⲭⲗⲟⲙ ⳿ⲛⲥⲟⲩⲣⲓ ⲛⲉⲙ ⲡⲓ⳿ϩⲃⲟⲥ ⳿ⲛ ϭⲏϫⲓ ⲟⲩⲟϩ ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭ ⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓϩⲩⲡⲏⲣⲉⲧⲏⲥ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁϣϥ ⲁϣϥ ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ϫⲉ ⲙⲱⲓⲛⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲁϣϥ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⳿ⲛϯϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛ⳿ⲉⲧⲓ⳿ⲁ ϭⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ⲁⲩⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⳿ⲁⲛⲟⲛ ⲟⲩⲟⲛ ⳿ⲛⲧⲁⲛ ⳿ⲛⲟⲩⲛⲟⲙⲟⲥ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲕⲁⲧⲁ ⲡⲉⲛⲛⲟⲙⲟⲥ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ϫⲉ ⲁϥⲁⲓϥ ⳿ⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲓⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲁϥⲉⲣϩⲟϯ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⲡⲉϫⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ⲑⲱⲛ Ⲓⲏ̅ⲥ̅ ⲇⲉ ⳿ⲙⲡⲉϥⲉⲣⲟⲩⲱ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲁϥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲕⲥⲁϫⲓ ⲛⲉⲙⲏⲓ ⲁⲛ ϣⲁⲛ ⳿ⲕ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩⲟⲛϯ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉⲁϣⲕ ⲟⲩⲟⲛϯ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⲟⲛ ⳿ⲉⲭⲁⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲉⲕ ⳿ϩⲗⲓ ⳿ⲛⲉⲣϣⲓϣⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲓ ⲉⲛⲉ ⳿ⲙⲡⲟⲩⲧⲏⲓⲥ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡϣⲱⲓ ⲉⲑⲃⲉⲫⲁⲓ ⲫⲏⲉⲧⲁϥⲧⲏⲓⲧ ⲛⲁⲕ ⲟⲩⲟⲛⲧⲉϥ ⲛⲓϣϯ ⳿ⲛⲛⲟⲃⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ⲉⲑⲃⲉⲫⲁⲓ ⲟⲩⲛ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲁϥⲕⲱϯ ⳿ⲛⲥⲁ ⲭⲁϥ ⳿ⲉⲃⲟⲗ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲛ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉϣⲱⲡ ⲁⲕϣⲁⲛⲭⲁ ⲫⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲑⲟⲕ ⳿ⲡ⳿ϣⲫⲏⲣ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲁⲛ ⲟⲩⲟⲛ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲣⲟ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲉϥϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⳿ⲡⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ⲡⲓⲗⲁⲧⲟⲥ ⲇⲉ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⲁϥ⳿ⲉⲛ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥϩⲉⲙⲥⲓ ϩⲓ ⲡⲓⲃⲏ ⲙⲁ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓⲗⲓⲑⲟⲥⲧⲣⲱⲧⲟⲛ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⲇⲉ ϫⲉ ⲅⲁⲃⲃⲁⲑⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ⲛⲉ ⳿ⲧⲡⲁⲣⲁⲥⲕⲉⲩⲏ ⲇⲉ ⲧⲉ ⳿ⲛⲧⲉ ⲡⲓⲡⲁⲥⲭ ⲁ ⲛⲉ ⳿ⲫⲛⲁⲩ ⲇⲉ ⳿ⲛⲁϫⲡ ⲡⲉ ⲟⲩⲟϩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⳿ⲛⲛⲓⲟⲩⲇⲁⲓ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲡⲉⲧⲉⲛⲟⲩⲣⲟ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲁⲗⲓⲧϥ ⳿ⲁⲗⲓⲧϥ ⲁϣϥ ⲡⲉϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲛⲱⲟⲩ ⳿ⲛⲧⲁⲉϣ ⲡⲉⲧⲉⲛⲟⲩⲣⲟ ⲁⲩⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭ ⲓⲉⲣⲉⲩⲥ ϫⲉ ⳿ⲙⲙⲟⲛⲧⲉⲛ ⲟⲩⲣⲟ ⳿ⲙⲙⲁⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲕⲉⲥⲁⲣ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ⲧⲟⲧⲉ ⲟⲩⲛ ⲁϥϯ ⲛⲱⲟⲩ ⳿ⲛⲒⲏ̅ⲥ̅ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲁϣϥ ⲁⲩϭⲓ ⲟⲩⲛ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲉϥϥⲁⲓ ⳿ⲙⲡⲉϥ⳿ⲥⲧⲁⲩⲣⲟⲥ ⲁϥ⳿ⲓ ⳿ⲉⲡⲓⲙⲁ ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲓ⳿ⲕⲣⲁⲛⲓⲟⲛ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⲇⲉ ϫⲉ ⲅⲟⲗⲅⲟⲑⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ⲡⲓⲙⲁ ⲉⲧⲁⲩⲁϣϥ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓϣⲓ ⳿ⲛⲕⲉⲥⲟⲛⲓ ⲃ̅ ⲛⲉⲙⲁϥ ⲥⲁ⳿ⲙⲛⲁⲓ ⲛⲉⲙ ⲥⲁ⳿ⲙⲛⲁⲓ ⳿ⲙⲙⲟϥ Ⲓⲏ̅ⲥ̅ ⲇⲉ ϧⲉⲛ ⳿ⲑⲙⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ⲁϥ⳿ⲥϧⲉ ⲕⲉⲧⲓⲧⲗⲟⲥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⲟⲩⲟϩ ⲁϥⲭⲁϥ ϩⲓϫⲉⲛ ⲡⲓ⳿ⲥⲧⲁⲩⲣⲟⲥ ⲛⲁϥ⳿ⲥϧⲏ ⲟⲩⲧ ⲇⲉ ⲡⲉ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲛⲁⲍⲱⲣⲉⲟⲥ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲩⲱϣ ⳿ⲙⲡⲓⲧⲓⲧⲗⲟⲥ ϫⲉ ⲛⲁϥϧⲉⲛⲧ ⲡⲉ ⳿ⲉϯⲃⲁⲕⲓ ⳿ⲛϫⲉ ⲡⲓⲙⲁ ⲉⲧⲁⲩⲉϣ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲥϧⲏ ⲟⲩⲧ ⲡⲉ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⳿ⲙⲙⲉⲧⲣⲱⲙⲉⲟⲥ ⳿ⲙⲙⲉⲧⲟⲩⲉⲓⲛⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲡⲉ ⳿ⲙⲡⲓⲗⲁⲧⲟⲥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ϫⲉ ⳿ⲙⲡⲉⲣ⳿ⲥϧⲁⲓ ϫⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲗⲗⲁ ϫⲉ ⳿ⲛⲑⲟϥ ⲁϥϫⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ϫⲉ ⲫⲏⲉⲧⲁⲓ⳿ⲥϧⲏⲧϥ ⲁⲓ⳿ⲥϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ⲛⲓⲙⲁⲧⲟⲓ ⲟⲩⲛ ⲉⲧⲁⲩⲉϣ Ⲓⲏ̅ⲥ̅ ⲁⲩϭⲓ ⳿ⲛⲛⲉϥ⳿ϩⲃⲱⲥ ⲁⲩⲁⲓⲧⲟⲩ ⳿ⲛⲇ̅ ⳿ⲛⲧⲟⲓ ⲛⲉⲙ ϯⲕⲉ⳿ϣⲑⲏ ⲛ ϯ⳿ϣⲑⲏⲛ ⲇⲉ ⲛⲉ ⲟⲩⲁⲧⲑⲱⲣⲡ ⲧⲉ ⳿ⲛⲥⲱϧⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡϣⲱⲓ ⲧⲏⲣⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ⲡⲉϫⲱⲟⲩ ⲟⲩⲛ ⳿ⲛⲛⲟⲩⲉⲣⲏⲟⲩ ϫⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲫⲁϧⲥ ⲁⲗⲗⲁ ⲙⲁⲣⲉⲛϩⲓⲱⲡ ⳿ⲉⲣⲟⲥ ϫⲉ ⲁⲥⲛⲁⲉⲣ ⲑⲁ ⲛⲓⲙ ⳿ⲙⲙⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲩⲫⲱϣ ⳿ⲛⲛⲁ⳿ϩⲃⲱⲥ ⳿ⲉ⳿ϩⲣⲁⲩ ⲟⲩⲟϩ ⲧⲁϩⲉⲃⲥⲱ ⲁⲩϩⲓⲱⲡ ⳿ⲉⲣⲟⲥ ⲛⲁⲓ ⲟⲩⲛ ⲉⲧⲁⲩⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲧⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ⲛⲁⲩⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧⲟⲩ ⲡⲉ ϧⲁⲧⲉⲛ ⲡⲓ⳿ⲥⲧⲁⲩⲣⲟⲥ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲉ ⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⳿ⲧⲥⲱⲛⲓ ⳿ⲛⲧⲉϥⲙⲁⲩ ⲙⲁⲣⲓ⳿ⲁ ⲑⲏ ⳿ⲛⲧⲉ ⲕⲗⲉⲟⲡⲁ ⲛⲉⲙ ⲙⲁⲣⲓ⳿ⲁ ϯⲙⲁⲅⲇⲁⲗⲓⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ⲓⲏ̅ⲥ̅ ⲇⲉ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲧⲉϥⲙⲁⲩ ⲛⲉⲙ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲛⲁϥⲙⲉⲓ ⳿ⲙⲙⲟϥ ⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲡⲉϫⲁϥ ⳿ⲛⲧⲉϥⲙⲁⲩ ϫⲉ ⲓⲥ ⲡⲉϣⲏⲣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","⳿ⲓⲧⲁ ⲡⲉϫⲁϥ ⳿ⲙⲡⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲧⲉⲕⲙⲁⲩ ⲟⲩⲟϩ ⲓⲥϫⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁϥⲟⲗⲥ ⳿ⲛϫⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲡⲉϥⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ϩⲏⲇⲏ ⲁ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ϫⲉ ϯⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲟⲕⲓ ⲇⲉ ⲡⲉ ⲉϥⲙⲉϩ ⳿ⲛϩⲉⲙϫ ⲉϥⲭⲏ ⳿ⲉ⳿ϧⲣⲏⲓ ⲁⲩⲙⲟϩ ⳿ⲛⲟⲩ⳿ⲥⲫⲟⲅⲅⲟⲥ ⳿ⲛϩⲉⲙϫ ⲁⲩⲧⲁⲗⲟϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲟⲩϩⲩⲥⲥⲱⲡⲟⲥ ⲁⲩϩⲓⲧϥ ϧⲁⲧⲉⲛ ⲣⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁϥϫⲉⲙϯⲡⲓ ⳿ⲙⲡⲓϩⲉⲙϫ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉϫⲁϥ ϫⲉ ⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲧⲁϥⲣⲉⲕ ϫⲱϥ ⲁϥϯ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ⲛⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲛ ⲉⲡⲓⲇⲏ ⲛⲉ ϯⲡⲁⲣⲁⲥⲕⲉⲩⲏ ⲧⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲟϩⲓ ⳿ⲛϫⲉ ⲛⲓⲥⲱⲙⲁ ϩⲓϫⲉⲛ ⲡⲓ⳿ⲥⲧⲁⲩⲣⲟⲥ ⳿ⲙ⳿ⲡⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲉ ⲟⲩⲛⲓϣϯ ⲅⲁⲣ ⲡⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩϯϩⲟ ⳿ⲉⲡⲓⲗⲁⲧⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲕⲱϣ ⳿ⲛⲛⲟⲩⲕⲉⲗⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲟⲩⲟⲗⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ⲁⲩ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲧⲟⲓ ⲟⲩⲟϩ ⲡⲓϩⲟⲩⲓⲧ ⲙⲉⲛ ⲁⲩⲕⲱϣ ⳿ⲛⲛⲉϥⲕⲉⲗⲓ ⲟⲩⲟϩ ⲁⲩⲕⲱϣ ⳿ⲛⲛⲁ ⲡⲓⲕⲉⲟⲩⲁⲓ ⲉⲧⲁⲩⲁϣϥ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ϩⲁ Ⲓⲏ̅ⲥ̅ ⲁⲩϫⲉⲙϥ ϩⲏⲇⲏ ⲁϥⲟⲩⲱ ⲉϥⲙⲟⲩ ⳿ⲙⲡⲟⲩⲕⲱϣ ⳿ⲛⲛⲉϥⲕⲉⲗⲓ ⳿ⲛⲑⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ⲁⲗⲗⲁ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲙⲁⲧⲟⲓ ⲁϥⲑⲟⲩⲝ ⳿ⲙⲡⲉϥ⳿ⲥⲫⲓⲣ ⳿ⲛⲧⲉϥⲗⲟⲅⲭⲏ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲟⲩⲙⲱⲟⲩ ⲛⲉⲙ ⲟⲩ⳿ⲥⲛⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ⲟⲩⲟϩ ⲫⲏⲉⲧⲁϥⲛⲁⲩ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲟⲩⲟϩ ⲟⲩⲙⲏⲓ ⲧⲉ ⲧⲉϥⲙⲉⲧⲙⲉⲑⲣⲉ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ϥ⳿ⲉⲙⲓ ϫⲉ ⲁϥϫⲉ ⲙⲉⲑⲙⲏ ⲓ ϩⲓⲛⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ⲛⲁⲓ ⲅⲁⲣ ⲁⲩϣⲱⲡⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲟⲩⲕⲁⲥ ⳿ⲛⲧⲁϥ ⳿ⲛⲛⲟⲩⲕⲁϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲉⲫⲏⲉⲧⲁⲩⲑⲟⲕⲥϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲓⲱⲥⲏⲫ ⲡⲓⲣⲉⲙⲁⲣⲓⲙⲁⲑⲉⲁⲥ ⲁϥϯϩⲟ ⳿ⲉⲡⲓⲗⲁⲧⲟⲥ ⳿ⲉⲟⲩⲙⲁⲑⲏ ⲧⲏⲥ ϩⲱϥ ⲡⲉ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥⲭⲏⲡ ⲇⲉ ⲡⲉ ⲉⲑⲃⲉ ⳿ⲧϩⲟϯ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲱⲗⲓ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲧⲟⲥ ⳿ⲉⲧⲏⲓϥ ⲁϥ⳿ⲓ ⲟⲩⲛ ⲟⲩⲟϩ ⲁϥⲱⲗⲓ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ⲁϥ⳿ⲓ ⲇⲉ ϩⲱϥ ⳿ⲛϫⲉ ⲛⲓⲕⲟⲇⲏⲙⲟⲥ ⲫⲏⲉⲧⲁϥ⳿ⲓ ϩⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϫⲱⲣϩ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲙⲓⲅⲙⲁ ⳿ⲛⲧⲟⲧϥ ⲟⲩϣⲁⲗ ⲛⲉⲙ ⲟⲩ⳿ⲁⲗⲗⲟⲏ ⲛⲁⲩⲣ̅ ⳿ⲛⲗⲓⲧⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ⲁⲩϭⲓ ⲟⲩⲛ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲁⲩⲕⲟⲩⲗⲱⲗϥ ⳿ⲛϩⲁⲛϣⲉⲛⲧⲱ ⳿ⲛⲓⲁⲩ ⲛⲉⲙ ⲛⲓ⳿ⲥⲑⲟⲓ ⲕⲁⲧⲁ ϯⲕⲁϩⲥ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲉⲩⲕⲱⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩϭⲱⲙ ⲇⲉ ⲡⲉ ⳿ⲙⲡⲓⲙⲁ ⲉⲧⲁⲩⲁϣϥ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲙϩⲁⲩ ⳿ⲙⲃⲉⲣⲓ ϧⲉⲛ ⲡⲓϭⲱⲙ ⳿ⲙⲡⲁⲧⲟⲩϩⲓ ⳿ϩⲗⲓ ⳿ⲉϧⲟⲩⲛ ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ⲉⲡⲓⲇⲏ ⲛⲁϥϧⲉⲛⲧ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓ⳿ⲙϩⲁⲩ ⲉⲑⲃⲉϫⲉ ⲛⲉ ϯⲡⲁⲣⲁⲥⲕⲉⲩⲏ ⲧⲉ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲩⲭⲁ Ⲓⲏ̅ⲥ̅ ⳿ⲛϧⲏⲧϥ ");
INSERT INTO copcnt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⳿ⲫⲟⲩⲁⲓ ⳿ⲛⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲙⲁⲣⲓ⳿ⲁ ϯⲙⲁⲅⲇⲁⲗⲓⲛⲏ ⲁⲥ⳿ⲓ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲛϣⲱⲣⲡ ⲉⲧⲓ ⲉⲣⲉ ⳿ⲧⲭⲉⲙⲥ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲁⲥⲛⲁⲩ ⳿ⲉⲡⲓⲱⲛⲓ ⳿ⲉⲁⲩⲟⲗϥ ⳿ⲉⲃⲟⲗ ϩⲓⲣⲱϥ ⳿ⲙⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ⲁⲥϭⲟϫⲓ ⲟⲩⲛ ⲁⲥ⳿ⲓ ϩⲁ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ϩⲁ ⲡⲓⲕⲉⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲛⲁⲣⲉ Ⲓⲏ̅ⲥ̅ ⲙⲉⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲡⲉϫⲁⲥ ⲛⲱⲟⲩ ϫⲉ ⲁⲩⲱⲗⲓ ⳿ⲙⲡⲉⲛϭ̅ ⲥ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁⲩⲭⲁϥ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲡⲓⲕⲉⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ⲛⲁⲩϭⲟϫⲓ ⲇⲉ ⳿ⲙ⳿ⲡⲃ̅ ϩⲓⲟⲩⲥⲟⲡ ⲟⲩⲟϩ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲁϥϭⲟϫⲓ ⲉⲧϩⲏ ⳿ⲙⲡⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟϥ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ⲟⲩⲟϩ ⲁϥⲥⲟⲙⲥ ⳿ⲉϧⲟⲩⲛ ⲁϥⲛⲁⲩ ⳿ⲉⲛⲓ⳿ϩⲃⲱⲥ ⲉⲩⲭⲏ ⳿ⲉ⳿ϧⲣⲏⲓ ⲙⲉⲛⲧⲟⲓ ⳿ⲙⲡⲉϥϣⲉ ⳿ⲉϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ⲁϥ⳿ⲓ ⲇⲉ ϩⲱϥ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲉϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲁϥϩⲱⲗ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉⲛⲓ⳿ϩⲃⲱⲥ ⲉⲩⲭⲏ ⳿ⲉ⳿ϧⲣⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ⲛⲉⲙ ⲡⲓⲥⲟⲩⲇⲁⲣⲓⲟⲛ ⳿ⲉⲛⲁϥⲭⲏ ϩⲓϫⲉⲛ ⲧⲉϥ⳿ⲁⲫⲉ ⲛⲁϥⲭⲏ ⲁⲛ ⲛⲉⲙ ⲛⲓ⳿ϩⲃⲱⲥ ⲁⲗⲗⲁ ⲉϥⲕⲟⲩⲗⲱⲗ ⲉϥⲭⲏ ⲥⲁⲟⲩⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϩⲱϥ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲙⲁⲑⲏ ⲧⲏⲥ ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⲁϥⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ⲛⲉ ⳿ⲙⲡⲁⲧⲟⲩⲥⲟⲩⲉⲛ ϯ⳿ⲅⲣⲁⲫⲏ ⲅⲁⲣ ⲡⲉ ϫⲉ ϩⲱϯ ⳿ⲉⲣⲟϥ ⲡⲉ ⳿ⲉⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ⲁⲩϣⲉ ⲛⲱⲟⲩ ⲟⲛ ⳿ⲉⲡⲟⲩⲙⲁ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏ ⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ⲙⲁⲣⲓ⳿ⲁ ⲇⲉ ⲛⲁⲥⲟϩⲓ ⳿ⲉⲣⲁⲧⲥ ⲥⲁⲃⲟⲗ ⲡⲉ ϧⲁⲧⲉⲛ ⲡⲓ⳿ⲙϩⲁⲩ ⲉⲥⲣⲓⲙⲓ ϩⲱⲥ ⲇⲉ ⲉⲥⲣⲓⲙⲓ ⲁⲥϫⲟⲩϣⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲙϩⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ⲁⲥⲛⲁⲩ ⳿ⲉⲁⲅⲅⲉⲗⲟⲥ ⲃ̅ ⲉⲩϩⲉⲙⲥⲓ ϧⲉⲛ ϩⲁⲛϭⲓ⳿ϩⲃⲟⲥ ⳿ⲛⲟⲩⲱⲃϣ ⲟⲩⲁⲓ ϧⲁϫⲱϥ ⲟⲩⲟϩ ⲟⲩⲁⲓ ϧⲁⲣⲁⲧϥ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ⲡⲓⲥⲱⲙⲁ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ ⲭⲏ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ⲛⲁⲥ ⳿ⲛϫⲉ ⲛⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲁϧⲟ ⲧⲉⲣⲓⲙⲓ ⲡⲉϫⲁⲥ ⲛⲱⲟⲩ ϫⲉ ⲁⲩⲱⲗⲓ ⳿ⲙⲡⲁ⳪ ⲟⲩⲟϩ ⳿ⲛϯ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁⲩⲭⲁϥ ⲑⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ⲛⲁⲓ ⲉⲧⲁⲥϫⲟⲧⲟⲩ ⲁⲥⲫⲟⲛϩⲥ ⳿ⲉⲫⲁϩⲟⲩ ⲁⲥⲛⲁⲩ ⳿ⲉⲒⲏ̅ⲥ̅ ⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲟⲩⲟϩ ⲛⲁⲥ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲉⲑⲃⲉⲟⲩ ⲧⲉⲣⲓⲙⲓ ⲁⲣⲉⲕⲱϯ ⳿ⲛⲥⲁ ⲛⲓⲙ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲉⲥⲙⲉⲩⲓ ϫⲉ ⲡⲓϭⲙⲏ ⳿ⲙⲡⲓϭⲱⲙ ⲡⲉ ⲡⲉϫⲁⲥ ⲛⲁϥ ϫⲉ ⲡⲁ⳪ ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲁⲕϥⲁⲓ ⳿ⲙⲙⲟϥ ⲙⲁⲧⲁⲙⲟⲓ ϫⲉ ⲁⲕⲭⲁϥ ⲑⲱⲛ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁⲟⲗϥ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⲙⲁⲣⲓⲁⲙ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲁⲥⲫⲟⲛϩⲥ ⲡⲉϫⲁⲥ ⲛⲁϥ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ϫⲉ ⲣⲁⲃⲃⲟⲩⲛⲓ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲥ ϫⲉ ⳿ⲙⲡⲉⲣϭⲓ ⲛⲉⲙⲏⲓ ⳿ⲙⲡⲁϯϣⲉ ⲛⲏⲓ ⲅⲁⲣ ⳿ⲉ⳿ⲡϣⲱⲓ ϩⲁ ⲡⲁⲓⲱⲧ ⲙⲁϣⲉ ⲛⲉ ⲇⲉ ϩⲁ ⲛⲁⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⳿ⲁϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉ⳿ⲡϣⲱⲓ ϩⲁ ⲡⲁⲓⲱⲧ ⲉⲧⲉ ⲡⲉⲧⲉⲛⲓⲱⲧ ⲡⲉ ⲛⲉⲙ ⲡⲁⲛⲟⲩϯ ⲉⲧⲉ ⲡⲉⲧⲉⲛⲛⲟⲩϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ⲁⲥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲙⲁⲣⲓ⳿ⲁ ϯⲙⲁⲅⲇⲁⲗⲓⲛⲏ ⲁⲥⲧⲁⲙⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲁⲓⲛⲁⲩ ⳿ⲉⲠ⳪ ⲟⲩⲟϩ ⲛⲁⲓ ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲛⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ⲛⲉ ⲣⲟⲩϩⲓ ⲇⲉ ⲡⲉ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲙ⳿ⲫⲟⲩⲁⲓ ⳿ⲛⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲟⲩⲟϩ ⲉⲣⲉ ⲛⲓⲣⲱⲟⲩ ϣⲟⲧⲉⲙ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲣⲉ ⲛⲓⲙⲁⲑⲏ ⲧⲏⲥ ⲑⲟⲩⲏⲧ ⳿ⲛϧⲏⲧϥ ⲉⲑⲃⲉ ⳿ⲧϩⲟϯ ⳿ⲛⲧⲉ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲧϩⲓⲣⲏⲛⲏ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲁϥⲧⲁⲙⲱⲟⲩ ⳿ⲉⲛⲉϥϫⲓϫ ⲛⲉⲙ ⲡⲉϥ⳿ⲥⲫⲓⲣ ⲁⲩⲣⲁϣⲓ ⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲟⲛ ϫⲉ ⳿ⲧϩⲓⲣⲏ ⲛⲏ ⲛⲱⲧⲉⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲱⲧ ⳿ⲁⲛⲟⲕ ϩⲱ ϯⲟⲩⲱⲣⲡ ⳿ⲙⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲁϥⲛⲓϥⲓ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲡⲟⲩϩⲟ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϭⲓ ⲛⲱⲧⲉⲛ ⳿ⲛⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ⲛⲏⲉⲧⲉⲧⲉⲛⲛⲁⲭⲁ ⲛⲟⲩⲛⲟⲃⲓ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲥⲉⲭⲏ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲏⲉⲧⲉⲧⲉⲛⲛⲁⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ ⲉⲩⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ⲑⲱⲙⲁⲥ ⲇⲉ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲇⲓⲇⲩⲙⲟⲥ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲓ̅ⲃ̅ ⲛⲁϥⲭⲏ ⳿ⲙⲙⲁⲩ ⲛⲉⲙⲱⲟⲩ ⲁⲛ ⲡⲉ ⲉⲧⲁϥ⳿ⲓ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ⲛⲁⲩϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⲁⲛⲛⲁⲩ ⳿ⲉⲠ⳪ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲓ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲩⲡⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲓϥⲧ ϧⲉⲛ ⲛⲉϥϫⲓϫ ⲟⲩⲟϩ ⳿ⲛⲧⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲁⲧⲏ ⲃ ⳿ⲉ⳿ⲡⲧⲩⲡⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲓϥⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲁϩⲟⲩ⳿ⲓ ⳿ⲛⲧⲁϫⲓϫ ⳿ⲉⲡⲉϥ⳿ⲥⲫⲓⲣ ⳿ⲛϯⲛⲁⲛⲁϩϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲏ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲡⲁⲗⲓⲛ ⲟⲛ ⲛⲁⲩⲑⲟⲩⲏⲧ ⳿ⲉϧⲟⲩⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲛⲁϥⲛⲉⲙⲱⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲑⲱⲙⲁⲥ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲉⲣⲉ ⲛⲓⲣⲱⲟⲩ ϣⲟⲧⲉⲙ ⲟⲩⲟϩ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲧϩⲓⲣⲏⲛⲏ ⲛⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ⲓⲧⲁ ⲡⲉϫⲁϥ ⳿ⲛⲑⲱⲙⲁⲥ ϫⲉ ⲙⲁ ⲡⲉⲕⲧⲏ ⲃ ⳿ⲉ⳿ⲙⲛⲁⲓ ⲟⲩⲟϩ ⳿ⲁⲛⲁⲩ ⳿ⲉⲛⲁϫⲓϫ ⲟⲩⲟϩ ⲁⲩⲓⲥ ⲧⲉⲕϫⲓϫ ϩⲓⲧⲥ ⳿ⲉⲡⲁ⳿ⲥⲫⲓⲣ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲉⲣⲁⲑⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲑⲱⲙⲁⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲡⲁ⳪ ⲟⲩⲟϩ ⲡⲁⲛⲟⲩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲉⲧⲁⲕⲛⲁⲩ ⳿ⲉⲣⲟⲓ ⲁⲕⲛⲁϩϯ ⲱⲟⲩ⳿ⲛⲓⲁⲧⲟⲩ ⳿ⲛⲛⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲛⲁⲩ ⲟⲩⲟϩ ⲁⲩⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ⲕⲉⲙⲏϣ ⲙⲉⲛ ⳿ⲙⲙⲏⲓⲛⲓ ⲁϥⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲛⲏⲉⲧⲉ ⳿ⲛⲥⲉ⳿ⲥϧⲏ ⲟⲩⲧ ⲁⲛ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓϫⲱⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ⲛⲁⲓ ⲇⲉ ⲁⲩ⳿ⲥϧⲏⲧⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ ϫⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲡⲉ ⲟⲩⲟϩ ϩⲓⲛⲁ ⲉⲣⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲛⲧⲉ ⲟⲩⲱⲛϧ ⳿ⲛ⳿ⲉⲛⲉϩ ϣⲱⲡⲓ ⲛⲱⲧⲉⲛ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉϥⲣⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲇⲉ ⲟⲛ ⲛⲁϥⲟⲩⲟⲛϩϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ϩⲓϫⲉⲛ ⳿ⲫⲓⲟⲙ ⳿ⲛⲧⲉ ⲧⲓⲃⲉⲣⲓⲁⲇⲟⲥ ⲁϥⲟⲩⲟⲛϩϥ ⲇⲉ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ⲛⲁⲩⲭⲏ ϩⲓϫⲉⲛ ⲟⲩⲙⲁ ⲡⲉ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲑⲱⲙⲁⲥ ⲫⲏⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲇⲓⲇⲩⲙⲟⲥ ⲛⲉⲙ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲍⲉⲃⲉⲇⲉⲟⲥ ⲛⲉⲙ ⲕⲉⲃ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ⲡⲉϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲛⲱⲟⲩ ϫⲉ ϯ ⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲛⲧⲁⲧⲁϩⲉ ⲧⲉⲃⲧ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⲧⲉⲛⲛⲏⲟⲩ ϩⲱⲛ ⲛⲉⲙⲁⲕ ⲟⲩⲟϩ ⲉⲧⲁⲩ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲙⲡⲟⲩⲧⲁϩⲉ ⳿ϩⲗⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ⲉⲣⲉ ϣⲱⲣⲡ ⲇⲉ ⲛⲁϣⲱⲡⲓ ⲁϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϩⲓ ⲡⲓ⳿ⲭⲣⲟ ⲙⲉⲛⲧⲟⲓ ⳿ⲙⲡⲟⲩ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲛ ⲛⲱⲟⲩ ϫⲉ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿Ⲓ ⲙⲏ ⲟⲩⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲉⲛⲭⲁⲓ ⳿ⲛⲟⲩⲱⲙ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲩⲉⲣⲟⲩⲱ ϫⲉ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓ⳿ϣⲛⲉ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛ⳿ⲉϫⲓⲙⲓ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲥⲟⲕϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲛⲧⲉⲛ ⳿ⲡ⳿ⲁϣⲁⲓ ⳿ⲛⲧⲉ ⲛⲓⲧⲉⲃⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ⲡⲉϫⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲫⲏ ⳿ⲉⲛⲁⲣⲉ Ⲓⲏ̅ⲥ̅ ⲙⲉⲓ ⳿ⲙⲙⲟϥ ⳿ⲙⲡⲉⲧⲣⲟⲥ ϫⲉ Ⲡ⳪ ⲡⲉ ⲥⲓⲙⲱⲛ ⲟⲩⲛ ⲡⲉⲧⲣⲟⲥ ⲉⲧⲁϥⲥⲱⲧⲉⲙ ϫⲉ Ⲡ⳪ ⲡⲉ ⲁϥⲙⲟⲣϥ ⳿ⲙⲡⲉϥⲉⲡⲉⲛⲇⲩⲧⲏⲥ ⲛⲁϥⲃⲏϣ ⲅⲁⲣ ⲡⲉ ⲟⲩⲟϩ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ⲫⲓⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ⲛⲓⲕⲉⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲁⲩ⳿ⲓ ϧⲉⲛ ⲡⲓϫⲟⲓ ⲛⲁⲩⲟⲩⲏⲟⲩ ⲅⲁⲣ ⲁⲛ ⲡⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⲡⲓ⳿ⲭⲣⲟ ⲁⲗⲗⲁ ϩⲱⲥ ⲛⲁⲩⲥ̅ ⳿ⲙⲙⲁϩⲓ ⲉⲩⲥⲱⲕ ⳿ⲙⲡⲓ⳿ϣⲛⲉ ⳿ⲛⲧⲉ ⲛⲓⲧⲉⲃⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ϩⲟⲧⲉ ⲇⲉ ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲡⲓⲕⲁϩⲓ ⲁⲩϫⲟⲩϣⲧ ⲁⲩⲛⲁⲩ ⳿ⲉⲟⲩⲣⲁⲕϩⲓ ⲉⲥⲭⲏ ⳿ⲉ⳿ϧⲣⲏⲓ ⲛⲉⲙ ⲟⲩⲧⲉⲃⲧ ϩⲓϫⲱⲥ ⲛⲉⲙ ⲟⲩⲱⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲛⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲧⲉⲃⲧ ⲉⲧⲁⲣⲉⲧⲉⲛⲧⲁϩⲱⲟⲩ ϯⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲛϫⲉ ⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ⲟⲩⲟϩ ⲁϥⲥⲉⲕ ⲡⲓ⳿ϣⲛⲉ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲉϥⲙⲉϩ ⳿ⲛⲛⲓϣϯ ⳿ⲛⲧⲉⲃⲧ ⳿ⲉⲟⲩⲟⲛ ⲣ̅ⲛ̅ⲅ̅ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲉⲣⲉ ⲧⲁⲓⲏⲡⲓ ⳿ⲛϧⲏⲧϥ ⳿ⲙⲡⲉϥⲫⲱϧ ⳿ⲛϫⲉ ⲡⲓ⳿ϣⲛⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲙⲱⲓⲛⲓ ⲟⲩⲱⲙ ⲛⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲇⲉ ⲡⲉ ⳿ⲛⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉϣⲉⲛϥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⲉⲩ⳿ⲉⲙⲓ ϫⲉ Ⲡ⳪ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ⲁϥ⳿ⲓ ⲟⲩⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲁϥϭⲓ ⳿ⲙⲡⲓⲱⲓⲕ ⲟⲩⲟϩ ⲁϥϯ ⲛⲱⲟⲩ ⲛⲉⲙ ⲡⲓⲧⲉⲃⲧ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ⲫⲁⲓ ⲇⲉ ⲡⲉ ⳿ⲫⲙⲁϩⲅ̅ ⳿ⲛⲥⲟⲡ ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲛⲉϥⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ϩⲟⲧⲉ ⲟⲩⲛ ⲉⲧⲁⲩⲟⲩⲱⲙ ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲛⲥⲓⲙⲱⲛ ⲡⲉⲧⲣⲟⲥ ϫⲉ ⲥⲓⲙⲱⲛ ⲫⲁ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲕⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲙⲙⲟⲓ ⲉϩⲟⲧⲉ ⲛⲁⲓ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲥⲉ ⲡⲁ⳪ ⳿ⲛⲑⲟⲕ ⲉⲧ⳿ⲉⲙⲓ ϫⲉ ϯⲙⲉⲓ ⳿ⲙⲙⲟⲕ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟⲛⲓ ⳿ⲛⲛⲁϩⲓⲏⲃ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ⲡⲁⲗⲓⲛ ⲟⲛ ⲡⲉϫⲁϥ ⲛⲁϥ ⳿ⲙ⳿ⲫⲙⲁϩⲥⲟⲡ ⲃ̅ ϫⲉ ⲥⲓⲙⲱⲛ ⲫⲁ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲕⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲙⲙⲟⲓ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲥⲉ ⲡⲁ⳪ ⳿ⲛⲑⲟⲕ ⲉⲧ⳿ⲉⲙⲓ ϫⲉ ϯⲙⲉⲓ ⳿ⲙⲙⲟⲕ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟⲛⲓ ⳿ⲛⲛⲁ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ⲡⲉϫⲁϥ ⲛⲁϥ ⲟⲛ ⳿ⲙ⳿ⲫⲙⲁϩⲅ̅ ⳿ⲛⲥⲟⲡ ϫⲉ ⲥⲓⲙⲱⲛ ⲫⲁ ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲭⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲁϥⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ϫⲉ ⲁϥϫⲟⲥ ⲛⲁϥ ⳿ⲙ⳿ⲫⲙⲁϩⲅ̅ ⳿ⲛⲥⲟⲡ ϫⲉ ⳿ⲭⲙⲉⲓ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⳿ⲛⲑⲟⲕ ⲉⲧⲥⲱⲟⲩⲛ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲛⲑⲟⲕ ⲉⲧ⳿ⲉⲙⲓ ϫⲉ ϯⲙⲉⲓ ⳿ⲙⲙⲟⲕ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟⲛⲓ ⳿ⲛⲛⲁ⳿ⲉⲥⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ⲁⲙⲏⲛ ⲁⲙⲏⲛ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁⲕ ϫⲉ ⲉⲕⲟⲓ ⳿ⲛ⳿ⲁⲗⲟⲩ ϣⲁⲕⲙⲟⲣⲕ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲟⲩⲟϩ ϣⲁⲕϣⲉ ⲛⲁⲕ ⳿ⲉ⳿ⲫⲙⲁ ⲉⲧⲉϩⲛⲁⲕ ⲉϣⲱⲡ ⲇⲉ ⲁⲕϣⲁⲛⲉⲣϧⲉⲗⲗⲟ ⲉⲕ⳿ⲉⲥⲟⲩⲧⲉⲛ ⲛⲉⲕϫⲓϫ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲣⲉ ⲕⲉⲟⲩⲁⲓ ⲙⲟⲣⲕ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲟⲗⲕ ⳿ⲉ⳿ⲫⲙⲁ ⲉⲧⲉϩⲛⲁⲕ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ⲫⲁⲓ ⲇⲉ ⲉⲧⲁϥϫⲟϥ ⲁϥⲉⲣⲥⲏⲙⲉⲛⲓⲛ ϫⲉ ⲁϥⲛⲁϯⲱⲟⲩ ⳿ⲙⲫϯ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲁϣ ⳿ⲙⲙⲟⲩ ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲧⲁϥϫⲟϥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ⲁϥⲫⲟⲛϩϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ⲁϥⲛⲁⲩ ⳿ⲉⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲛⲁⲣⲉ Ⲓⲏ̅ⲥ̅ ⲙⲉⲓ ⳿ⲙⲙⲟϥ ⲫⲏⲉⲧⲁϥⲣⲟⲑⲃⲉϥ ⳿ⲉϫⲉⲛ ⲧⲉϥⲙⲉⲥⲧⲉ⳿ⲛϩⲏⲧ ϧⲉⲛ ⲡⲓⲇⲓⲡⲛⲟⲛ ⳿ⲉⲁϥϫⲟⲥ ⲛⲁϥ ϫⲉ Ⲡ⳪ ⲛⲓⲙ ⲡⲉⲑⲛⲁⲧⲏ ⲓⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ⲉⲧⲁϥⲛⲁⲩ ⲟⲩⲛ ⳿ⲉⲫⲁⲓ ⳿ⲛϫⲉ ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ϫⲉ ⲡⲁ⳪ ⲫⲁⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ⲡⲉϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁϥ ϫⲉ ⲉϣⲱⲡ ⲁⲓϣⲁⲛⲟⲩⲱϣ ⳿ⲉⲭⲁϥ ϣⲁϯ⳿ⲓ ⳿ⲁϧⲟⲕ ⳿ⲛⲑⲟⲕ ⳿ⲛⲑⲟⲕ ⲇⲉ ⲟⲩⲁϩⲕ ⳿ⲛⲥⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ⲁ ⲡⲁⲓⲥⲁϫⲓ ⲇⲉ ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓ⳿ⲥⲛⲏ ⲟⲩ ϫⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ϥⲛⲁⲙⲟⲩ ⲁⲛ ⲛⲉⲧⲁϥϫⲟⲥ ⲇⲉ ⲛⲁϥ ⲁⲛ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ϥⲛⲁⲙⲟⲩ ⲁⲛ ⲁⲗⲗⲁ ⲉϣⲱⲡ ⲁⲓϣⲁⲛⲟⲩⲱϣ ⳿ⲉⲭⲁϥ ϣⲁϯ⳿ⲓ ⳿ⲁϧⲟⲕ ⳿ⲛⲑⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ⲡⲁⲓ ⲡⲉ ⲡⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲧⲁϥⲉⲣⲙⲉⲑⲣⲉ ϧⲁ ⲛⲁⲓ ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲁϥ⳿ⲥϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲙⲏⲓ ⲧⲉ ⲧⲉϥⲙⲉⲧⲙⲉⲑⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲙⲏϣ ⲇⲉ ⲟⲛ ⳿ⲉⲁϥⲁⲓⲧⲟⲩ ⳿ⲛϫⲉ Ⲓⲏ̅ⲥ̅ ⲛⲁⲓ ⲉⲛⲉ ⲁⲩ⳿ⲥϧⲏⲧⲟⲩ ⲡⲉ ⲕⲁⲧⲁ ⲟⲩⲁⲓ ⲟⲩⲁⲓ ϯ⳿ⲉⲙⲓ ϫⲉ ⲛⲁⲣⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲁ⳿ϣⲉⲣⲭⲱⲣⲓⲛ ⲁⲛ ⲡⲉ ⳿ⲛⲛⲓϫⲱⲙ ⲉⲧⲟⲩⲛⲁ⳿ⲥϧⲏ ⲧⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ⲡⲓϩⲟⲩⲓⲧ ⲙⲉⲛ ⳿ⲛⲥⲁϫⲓ ⲁⲓⲁⲓϥ ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲱ ⲑⲉⲟⲫⲩⲗⲗⲉ ϧⲉⲛ ⲛⲏ⳿ⲉⲧⲁ Ⲓⲏ̅ⲥ̅ ϩⲓⲧⲟⲧϥ ⳿ⲉⲁⲓⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲉϯ⳿ⲥⲃⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ϣⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲏ⳿ⲉⲧⲁϥⲥⲟⲧⲡⲟⲩ ⲁⲩⲟⲗϥ ⳿ⲉ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ⲛⲁⲓ ⳿ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲱⲟⲩ ⲉϥⲟⲛϧ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉⲧⲁϥϣⲉⲡ⳿ⲙⲕⲁϩ ϧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲙⲏⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲙ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲉϥⲟⲩⲟⲛϩ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲉϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ⲟⲩⲟϩ ⲉϥⲟⲩⲱⲙ ⲛⲉⲙⲱⲟⲩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲫⲱⲣϫ ⲥⲁⲃⲟⲗ ⳿ⲛⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲗⲗⲁ ⳿ⲉⲟϩⲓ ⳿ⲙⲡⲓⲱϣ ⳿ⲛⲧⲉ Ⲫ̇ⲓⲱⲧ ⲫⲏ⳿ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲥⲟⲑⲙⲉϥ ⳿ⲛⲧⲟⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲙⲉⲛ ⲁϥϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲥⲉⲛⲁⲉⲙⲥ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲙⲉⲛⲉⲛⲥⲁ ⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲛ ⳿ⲁ ⲛⲁⲓ ϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲓⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓⲥⲏⲟⲩ ⳿ⲭⲛⲁ⳿ⲧⲫⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲉⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲫⲱⲧⲉⲛ ⲁⲛ ⲡⲉ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉϩⲁⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲓⲉ ϩⲁⲛⲥⲏⲟⲩ ⲛⲁⲓ ⳿ⲉⲧⲁ Ⲫ̇ⲓⲱⲧ ⲭⲁⲩ ϧⲁ ⲡⲉϥⲉⲣϣⲓϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ⲁⲗⲗⲁ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉϭⲓ ⳿ⲛⲟⲩϫⲟⲙ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϣⲱⲡⲓ ⲛⲏⲓ ⳿ⲙⲙⲉⲑⲣⲉ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ⳿ⲧⲤⲁⲙⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ϣⲁ ⲁⲩⲣⲏϫϥ ⳿ⲙ⳿ⲡⲕⲁϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ⲟⲩⲟϩ ⲛⲁⲓ ⳿ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲉⲩⲥⲟⲙⲥ ⲁⲩϥⲓⲧϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⲟⲩⲟϩ ⲟⲩϭⲏⲡⲓ ⲁⲥϣⲟⲡⲥ ⳿ⲉⲣⲟⲥ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲟⲩⲃⲁⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ⲛⲁⲩⲟⲓ ⲇⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲛⲁⲩⲓⲟⲣⲉⲙ ⲟⲩⲁⲓ ⲟⲩⲃⲉ ⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ⲉϥⲙⲟϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲣⲱⲙⲓ ⲃ̅ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲁϩⲣⲁⲩ ϧⲉⲛ ϩⲁⲛϩⲉⲃⲥⲱ ⲉⲩⲟⲩⲟⲃϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ⲟⲩⲟϩ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲄⲁⲗⲓⲗⲉⲟⲥ ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲉⲧⲉⲛⲥⲟⲙⲥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲫⲁⲓ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲧⲁⲩⲟⲗϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲱⲧⲉⲛ ⲫⲁⲓ ⲟⲛ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉϥⲛⲏⲟⲩ ⳿ⲙⲙⲟϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲉϥⲙⲟϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ⲧⲟⲧⲉ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓⲧⲱⲟⲩ ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲫⲁⲛⲓϫⲱⲓⲧ ⲉⲧϧⲉⲛⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲛⲟⲩⲥⲁⲃⲃⲁⲧⲟⲛ ⳿ⲙⲙⲟϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ⲧⲟⲧⲉ ⳿ⲉⲧⲁⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⲁⲩϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲟⲩⲙⲁ ⲉϥⲥⲁ⳿ⲡϣⲱⲓ ⲡⲓⲙⲁ ⳿ⲉⲛⲁϥϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ Ⲁⲛ⳿ⲇⲣⲉⲁⲥ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲉⲙ Ⲑⲱⲙⲁⲥ Ⲃⲁⲣⲑⲟⲗⲟⲙⲉⲟⲥ ⲛⲉⲙ Ⲙⲁⲧⲑⲉⲟⲥ Ⲓⲁⲕⲱⲃⲟⲥ ⲫⲁ Ⲁⲗⲫⲉⲟⲥ ⲛⲉⲙ Ⲥⲓⲙⲱⲛ ⲡⲓⲣⲉϥⲭⲟϩ ⲛⲉⲙ Ⲓⲟⲩⲇⲁⲥ ⲫⲁ Ⲓⲁⲕⲱⲃⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⲉⲩⲙⲏⲛ ⲉⲩⲥⲟⲡ ⳿ⲉϯ ⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲉⲙ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ ⲛⲉⲙ Ⲙⲁⲣⲓ⳿ⲁ ⳿ⲑⲙⲁⲩ ⳿ⲛⲒⲏ̅ⲥ̅ ⲛⲉⲙ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ⲟⲩⲟϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲇⲉ ⲉⲩⲑⲟⲩⲏⲧ ϩⲓ ⲫⲁⲓ ⳿ⲉⲫⲁⲓ ⳿ⲉⲛⲁⲩⲛⲁⲉⲣⲣ̅ⲕ̅ ⳿ⲛⲣⲁⲛ ⲡⲉϫⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ⲛⲓⲣⲱⲙⲓ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲉⲥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϯ⳿ⲅⲣⲁⲫⲏ ⲑⲏ⳿ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛϫⲟⲥ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⳿ⲛⲆⲁⲩⲓⲇ ⲉⲑⲃⲉ Ⲓⲟⲩⲇⲁⲥ ⲫⲏ⳿ⲉⲧⲁϥⲉⲣϭⲁⲩⲙⲱⲓⲧ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲁⲙⲁϩⲓ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ϫⲉ ⲛⲁϥⲏⲡ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ⲡⲉ ⲟⲩⲟϩ ⳿ⲁ ⲡⲓⲱⲡ ⳿ⲓ ⳿ⲉⲣⲟϥ ⳿ⲙⲡⲓ⳿ⲕⲗⲏⲣⲟⲥ ⳿ⲛⲧⲉ ⲧⲁⲓⲇⲓ⳿ⲁⲕⲟⲛⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ⲫⲁⲓ ⲙⲉⲛ ⲟⲩⲛ ⲁϥϣⲱⲡ ⳿ⲛⲟⲩⲓⲟϩⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲃⲉⲭⲉ ⳿ⲛⲧⲉ ⳿ⲧⲁⲇⲓⲕⲓⲁ ⲟⲩⲟϩ ⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥϩⲟ ⲁϥⲕⲱϣ ϧⲉⲛ ⲧⲉϥⲙⲏϯ ⲟⲩⲟϩ ⲛⲏⲉⲧⲥⲁϧⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲧⲏⲣⲟⲩ ⲁⲩⲫⲱⲛ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉⲙⲟⲩϯ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲓⲓⲟϩⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϧⲉⲛ ⲧⲟⲩⲁⲥⲡⲓ ϫⲉ ⲁⲭⲉⲗⲇⲁⲙⲁⲅ ⳿ⲉⲧⲉ ⲡⲓⲓⲟϩⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲥⲛⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϩⲓ ⳿ⲡϫⲱⲙ ⳿ⲛⲧⲉ ⲛⲓⲯⲁⲗⲙⲟⲥ ϫⲉ ⲧⲉϥⲉⲣⲃⲓ ⲙⲁⲣⲉⲥϣⲱϥ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧⲥ ⲧⲉϥⲙ⳿ⲉⲧⲉⲡⲓⲥⲕⲟⲡⲟⲥ ⲙⲁⲣⲉ ⲕⲉⲟⲩⲁⲓ ϭⲓⲧⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ϩⲱϯ ⲟⲩⲛ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲁⲩ⳿Ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϧⲏⲧⲉⲛ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⲧⲏⲣϥ ⳿ⲉⲧⲁϥ⳿Ⲓ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ϩⲓϫⲱⲛ ⳿ⲛϫⲉ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","⳿ⲉⲁϥⲉⲣϩⲏⲧⲥ ⲓⲥϫⲉⲛ ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁⲩⲟⲗϥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟⲛ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⳿ⲛⲛⲁⲓ ⲉⲣⲙⲉⲑⲣⲉ ⲛⲉⲙⲁⲛ ϧⲁ ⲧⲉϥ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ⲟⲩⲟϩ ⲁⲩⲧⲁϩⲉ ⲃ̅ ⳿ⲉⲣⲁⲧⲟⲩ Ⲓⲱⲥⲏⲫ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲃⲁⲣⲥⲁⲃⲃⲁⲥ ⲫⲏ⳿ⲉⲧⲁⲩϯⲣⲉⲛϥ ϫⲉ ⲓⲟⲩⲥⲧⲟⲥ ⲛⲉⲙ ⲙⲁⲑⲓⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲃϩ ⲡⲉϫⲱⲟⲩ ϫⲉ Ⲡ⳪ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲥⲱⲟⲩⲛ ⳿ⲙ⳿ⲡϩⲏⲧ ⳿ⲛⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟⲛϩ ⳿ⲙⲫⲏ⳿ⲉⲧⲁⲕⲥⲟⲧⲡϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲁⲓⲃ̅ ⲟⲩⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","⳿ⲉϭⲓ ⳿ⲉ⳿ⲫⲙⲁ ⳿ⲛⲧⲉ ⲧⲁⲓⲇⲓ⳿ⲁⲕⲟⲛⲓⲁ ⲛⲉⲙ ⲧⲁⲓⲙⲉⲧⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲑⲏ⳿ⲉⲧⲁϥⲉⲣⲡⲁⲣⲁⲃⲉⲛⲓⲛ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ Ⲓⲟⲩⲇⲁⲥ ⲉⲁϥϣⲉⲛⲁϥ ⳿ⲉⲡⲉϥⲙⲁ ⳿ⲉⲧⲉ ⲫⲱϥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ⲟⲩⲟϩ ⲁⲩϯ⳿ⲕⲗⲏⲣⲟⲥ ⲛⲱⲟⲩ ⳿ⲁ ⲡⲓ⳿ⲕⲗⲏⲣⲟⲥ ⳿ⲓ ⳿ⲉϫⲉⲛ ⲙⲁⲑⲓⲁⲥ ⲁⲩⲟⲡϥ ⲛⲉⲙ ⲡⲓⲓ̅ⲁ̅ ⳿ⲛ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯⲡⲉⲛⲧⲏⲕⲟⲥⲧⲏⲛⲁⲩⲑⲟⲩⲏⲧ ⲧⲏⲣⲟⲩ ⲡⲉ ϩⲓ ⲟⲩⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲑⲏⲟⲩ ⲉⲩ⳿ⲓⲛⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ⲁϥⲙⲟϩ ⳿ⲙⲡⲓⲏⲓ ⲧⲏⲣϥ ⳿ⲉⲛⲁⲩϩⲉⲙⲥⲓ ⳿ⲛϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ⲟⲩⲟϩ ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲗⲁⲥ ⳿ⲛ⳿ⲭⲣⲱⲙ ⲉⲩⲫⲏϣ ⲟⲩⲟϩ ⲁⲩϩⲉⲙⲥⲓ ⳿ⲉϫⲉⲛ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ⲟⲩⲟϩ ⲁⲩⲙⲟϩ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲟⲩⲟϩ ⲁⲩⲟⲩⲁϩⲧⲟⲧⲟⲩ ⳿ⲉⲥⲁϫⲓ ⳿ⲛϩⲁⲛⲕⲉⲗⲁⲥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥϯ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲣⲟⲩⲉⲣⲟⲩⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⲉⲩϣⲟⲡ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲩⲉⲣϩⲟϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ϣⲗⲱⲗ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ⲉⲧⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲧⲁⲓ⳿ⲥⲙⲏ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲟⲩⲟϩ ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ϫⲉ ⲛⲁⲣⲉ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲉⲩⲥⲁϫⲓ ϧⲉⲛ ⲧⲟⲩⲁⲥⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ⲛⲁⲩⲧⲱⲙⲧ ⲇⲉ ⲧⲏⲣⲟⲩ ⲡⲉ ⲉⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲭⲓ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲧⲥⲁϫⲓ ϩⲁⲛⲄⲁⲗⲓⲗⲉⲟⲥ ⲁⲛ ⲛⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ⲡⲱⲥ ⳿ⲁⲛⲟⲛ ⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲟⲛ ϧⲉⲛ ⲧⲉⲛⲁⲥⲡⲓ ⳿ⲉⲧⲁⲩ⳿ϫⲫⲟⲛ ⳿ⲛϧⲏⲧⲥ . ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ϯⲕⲁⲡⲡⲟⲇⲟⲕⲓ⳿ⲁ ⲡⲟⲛⲧⲟⲥ ⲛⲉⲙ ϯ⳿ⲁⲥⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ⲛⲓⲡⲁⲣⲑⲟⲥ ⲛⲉⲙ ⲛⲓⲙⲏⲇⲟⲥ ⲛⲉⲙ ⲛⲓⲉⲗⲁⲙⲓⲧⲏⲥ ⲛⲉⲙ ⲛⲏⲉⲧϣⲟⲡ ϧⲉⲛ ϯⲙⲉⲥⲟⲡⲟⲧⲁⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ϯ⳿ⲫⲣⲓⲕⲓ⳿ⲁ ⲛⲉⲙ ϯⲡⲁⲙⲫⲓⲗⲓ⳿ⲁ ⲭⲏ ⲙⲓ ⲛⲉⲙ ⲛⲓⲥⲁ ⳿ⲛⲧⲉ ϯⲗⲩⲃⲏⲑⲏⲉⲧϩⲓ ⲛⲓⲥⲁ ⳿ⲛⲧⲉ ϯⲕⲩⲣⲓⲛⲛⲏⲛⲉⲙ ⲛⲓⲣⲱⲙⲉⲟⲥ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓϣⲉⲙⲙⲱⲟⲩ ⲛⲓ⳿ⲕⲣⲓⲧⲏⲥ ⲛⲉⲙ ⲛⲓⲁⲣⲁⲃⲟⲥ ⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⲉⲩⲥⲁϫⲓ ϧⲉⲛ ϩⲁⲛⲗⲁⲥ ⳿ⲛⲛⲓⲙⲉⲧⲛⲓϣϯ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ⲛⲁⲩⲧⲱⲙⲧ ⲇⲉ ⲧⲏⲣⲟⲩ ⲡⲉ ⲉⲩⲓⲟⲣⲉⲙ ⲟⲩⲁⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲟⲩⲁⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⳿ⲉⲧⲁϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩⲉⲣϣⲉⲣϣⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁ ⲛⲁⲓ ⲙⲁϩ ϧⲏⲧⲟⲩ ⳿ⲛⲉⲙⲃⲣⲓⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲣⲉ ⲛⲁⲓ ⲑⲁϧⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ⲁϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲡⲓⲕⲉⲓ̅ⲁ̅ ⲁϥϭⲓⲥⲓ ⳿ⲛⲧⲉϥ⳿ⲥⲙⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲛⲱⲟⲩ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲏⲉⲧϣⲟⲡ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲧⲏⲣⲟⲩ ⲫⲁⲓ ⲙⲁⲣⲉϥⲟⲩⲱⲛϩ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ϭⲓ⳿ⲥⲙⲏ ⳿ⲉⲛⲁⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ⲟⲩ ⲅⲁⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛ ⳿ⲉⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲁⲣⲉ ⲛⲁⲓ ⲑⲁϧⲓ ⲁϫⲡⲅ̅ϯ ⲅⲁⲣ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲧⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ⲁⲗⲗⲁ ⲫⲁⲓ ⲡⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲓⲱⲏⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ϫⲉ ⲉⲥ⳿ⲉϣⲱⲡⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϧⲁⲉ ⲡⲉϫⲉ Ⲫϯ ⲉⲓ⳿ⲉⲫⲱⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲁⲡ͞ⲛⲁ̅ ⳿ⲉϫⲉⲛ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ ⳿ⲛϫⲉ ⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲛⲉⲙ ⲛⲉⲧⲉⲛϣⲉⲣⲓ ⲟⲩⲟϩ ⲛⲉⲧⲉⲛϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲉϩⲁⲛϩⲟⲣⲁⲥⲓⲥ ⲟⲩⲟϩ ⲛⲉⲧⲉⲛϧⲉⲗⲗⲟⲓ ⲉⲩ⳿ⲉⲫⲱⲣ ⳿ⲛϩⲁⲛⲣⲁⲥⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ⲕⲉⲅⲉ ⲉⲓ⳿ⲉⲫⲱⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲁⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲁⲃⲱⲕ ⲛⲉⲙ ⲛⲁⲃⲱⲕⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ⲉⲓ⳿ⲉϯ ⳿ⲛϩⲁⲛ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲉ⳿ⲡϣⲱⲓ ⲛⲉⲙ ϩⲁⲛⲙⲏⲓⲛⲓ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩ⳿ⲥⲛⲟϥ ⲛⲉⲙ ⲟⲩ⳿ⲭⲣⲱⲙ ⲛⲉⲙ ⲟⲩ⳿ⲭⲣⲉⲙⲧⲥ ⳿ⲛⲕⲁⲡⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","⳿ⲫⲣⲏⲉϥ⳿ⲉⲟⲩ⳿ⲱⲧⲉⲃ ⲉϥ⳿ⲉⲉⲣⲭⲁⲕⲓ ⲟⲩⲟϩ ⲡⲓⲓⲟϩ ⲉϥ⳿ⲉⲉⲣ⳿ⲥⲛⲟϥ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲓⲛⲓϣϯ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ Ⲡ⳪ ⲉⲑⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ⲟⲩⲟϩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲧⲱⲃϩ ⳿ⲙ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ⲛⲓⲣⲱⲙⲓ ⲛⲓⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲥⲁϫⲓ ⲛⲁⲓ Ⲓⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ ⲟⲩⲣⲱⲙⲓ ⲉⲁ Ⲫϯ ⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ϣⲁⲣⲱⲧⲉⲛ ⲡⲉ ϧⲉⲛ ϩⲁⲛϫⲟⲙ ⲛⲉⲙ ϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲛⲏ⳿ⲉⲧⲁ Ⲫϯ ⲁⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ϧⲉⲛ ⲧⲉⲧⲉⲛⲙⲏϯ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ⲫⲁⲓ ϧⲉⲛ ⲡⲓⲥⲟϭⲛⲓ ⲉⲧⲑⲏϣ ⲛⲉⲙ ⲡⲓϣⲟⲣⲡ ⳿ⲛ⳿ⲉⲙⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲁⲧⲉⲧⲉⲛⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓ⳿ⲁⲛⲟⲙⲟⲥ ⳿ⲉ⳿ⲁⲣⲉⲧⲉⲛⲁϣϥ ⲟⲩⲟϩ ⳿ⲁⲣⲉⲧⲉⲛϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ⲫⲁⲓ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲁϥⲃⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲛⲁⲕϩⲓ ⳿ⲛⲧⲉ ⳿ⲁⲙⲉⲛϯ ϫⲉ ⲛⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲥⲉ⳿ⲁⲙⲁϩⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ⲇⲁⲩⲓⲇ ⲅⲁⲣ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ ⲁⲓⲉⲣϣⲟⲣⲡ ⳿ⲛⲛⲁⲩ ⳿ⲙⲠ⳪ ⳿ⲙⲡⲁ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲉϥⲭⲏ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲙⲟⲓ ϫⲉ ⳿ⲛⲛⲁⲕⲓⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲁ ⲡⲁϩⲏⲧ ⲟⲩⲛⲟϥ ⲟⲩⲟϩ ⳿ⲁ ⲡⲁⲗⲁⲥ ⲑⲉⲗⲏⲗ ⳿ⲉⲧⲓ ⲇⲉ ⲛⲉⲙ ⲧⲁⲔⲉⲥⲁⲣⲝ ⲉⲥ⳿ⲉϣⲱⲡⲓ ϧⲉⲛ ⲟⲩϩⲉⲗⲡⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ϫⲉ ⳿ⲛⲛⲉⲕⲥⲱϫⲡ ⳿ⲛⲧⲁⲯⲩⲭⲏ ϧⲉⲛ ⳿ⲁⲙⲉⲛϯ ⲟⲩⲇⲉ ⳿ⲛⲛⲉⲕϯ ⳿ⲙⲡⲉⲑⲟⲩⲁⲃ ⳿ⲛⲧⲁⲕ ⳿ⲉⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ⲛⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ ⲁⲕⲟⲩⲟⲛϩⲟⲩ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ⲉⲕ⳿ⲉⲙⲁϩⲧ ⳿ⲛⲟⲩⲛⲟϥ ⲛⲉⲙ ⲡⲉⲕϩⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲥϣⲉ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲉ ⲡⲉⲛⲡⲁⲧⲣⲓⲁⲣⲭⲏⲥ Ⲇⲁⲩⲓⲇ ϫⲉ ⲁϥⲙⲟⲩ ⲟⲩⲟϩ ⲁⲩⲕⲟⲥϥ ⲟⲩⲟϩ ⲡⲉϥ⳿ⲙϩⲁⲩ ⳿ⲛϧⲏⲧⲉⲛ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲟⲩⲛ ⲡⲉ ⲟⲩⲟϩ ⲉϥⲥⲱⲟⲩⲛ ϫⲉ ϧⲉⲛ ⲟⲩ⳿ⲁⲛⲁϣ ⳿ⲁ Ⲫϯ ⲱⲣⲕ ⲛⲁϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲟⲩⲧⲁϩ ⳿ⲛⲧⲉ ⲧⲉϥϯⲡⲓ ⲉⲑⲣⲉϥϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ⲡⲉϥ⳿ⲑⲣⲟⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","⳿ⲉⲧⲁϥⲛⲁⲩ ⲟⲩⲛ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ⲁϥⲥⲁϫⲓ ⲉⲑⲃⲉ ⳿ⲧ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲙⲠⲭ̅ⲥ̅ ϫⲉ ⳿ⲙⲡⲉϥⲥⲟϫⲡϥ ϧⲉⲛ ⳿ⲁⲙⲉⲛϯ ⲟⲩⲇⲉ ⳿ⲙⲡ⳿ⲉⲧⲉϥⲥⲁⲣⲝ ⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ⲫⲁⲓ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⲫⲁⲓ ⳿ⲉⲧⲉ ⳿ⲁⲛⲟⲛ ⲧⲏⲣⲉⲛ ⲧⲉⲛⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⲛⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","⳿ⲉⲁϥϭⲓⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲪϯ ⲁϥϭⲓ ⳿ⲙⲡⲓⲱϣ ⳿ⲛⲧⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲪ̇ⲓⲱⲧ ⲁϥⲫⲱⲛ ⳿ⲙⲙⲟϥ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ⲇⲁⲩⲓⲇ ⲅⲁⲣ ⳿ⲙⲡⲉϥϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ⳿ⲛⲑⲟϥ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉϫⲉ Ⲡ⳪ ⳿ⲙⲠⲁ⳪ ϫⲉ ϩⲉⲙⲥⲓ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲙⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ϣⲁϯⲭⲁ ⲛⲉⲕϫⲁϫⲓ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛⲛⲉⲕ ϭⲁⲗⲁⲩϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ⲁⲥⲫⲁⲗⲱⲥ ⲟⲩⲛ ⲙⲁⲣⲉϥ⳿ⲉⲙⲓ ⳿ⲛϫⲉ ⳿ⲡⲏⲓ ⲧⲏⲣϥ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ϫⲉ ⲁϥⲁⲓϥ ⳿ⲛ⳪ ⲟⲩⲟϩ ⲁϥⲁⲓϥ ⳿ⲛⲭ͞ⲣⲥ̅ ⳿ⲛϫⲉ Ⲫϯ ⲫⲁⲓ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲁϣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲁ ⲡⲟⲩϩⲏⲧ ⳿ⲙⲕⲁϩ ⲡⲉϫⲱⲟⲩ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ ⳿ⲡⲥⲱϫⲡ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲛⲛⲁⲁⲓϥ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲁⲣⲓⲙⲉⲧⲁⲛⲟⲓⲛ ⲟⲩⲟϩ ⲙⲁⲣⲉ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲟⲙⲥϥ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲉ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲉⲧⲉⲛⲛⲟⲃⲓ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁϭⲓ ⳿ⲛϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲛⲧⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ⲫⲱⲧⲉⲛ ⲅⲁⲣ ⲡⲉ ⲡⲓⲱϣ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲓⲟϯ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲟⲩⲏⲟⲩ ⲛⲏ⳿ⲉⲧⲉ Ⲡ⳪ ⲡⲉⲛⲛⲟⲩϯ ⲛⲁⲑⲁϩⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲕⲉⲙⲏϣ ⳿ⲛⲥⲁϫⲓ ⲛⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥϧⲱⲛϫ ⳿ⲉⲣⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁϩⲉⲙ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗϩⲁ ⲧⲁⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⲉⲧⲕⲟⲗϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ⲛⲏⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩϣⲉⲡ ⲡⲓⲥⲁϫⲓ ⳿ⲉⲣⲱⲟⲩ ⲁⲩⲟⲙⲥⲟⲩ ⲟⲩⲟϩ ⲁⲩⲟⲩⲟϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲅ̅ ⳿ⲛϣⲟ ⳿ⲙⲯⲩⲭⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ⲛⲁⲩⲙⲏⲛ ⲇⲉ ⳿ⲉϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ϯⲙⲉⲧ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲉ ⲡⲓⲫⲱϣ ⳿ⲛⲧⲉ ⲡⲓⲱⲓⲕ ⲛⲉⲙ ϯⲡⲣⲟⲥⲉⲩⲭⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ⲟⲩϩⲟϯ ⲇⲉ ⲛⲁⲥϣⲟⲡ ⳿ⲙⲯⲩⲭⲏ ⲛⲓⲃⲉⲛ ϩⲁⲛⲙⲏϣ ⲇⲉ ⳿ⲙⲙⲏⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲛⲁⲩϣⲟⲡ ⲡⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲛϩⲟϯ ⲛⲁⲥϣⲟⲡ ϩⲓϫⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ⲛⲏⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⲛⲁⲩϩⲓⲟⲩⲙⲁ ⲡⲉ ⲟⲩⲟϩ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲛⲁⲩϣⲟⲡ ⲛⲱⲟⲩ ⲡⲉ ϧⲉⲛ ⲟⲩⲙⲉⲧ⳿ϣⲫⲏⲣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ⲟⲩⲟϩ ⲛⲟⲩⲓⲟϩⲓ ⲛⲉⲙ ⲛⲟⲩϩⲩⲡⲁⲣ ⲭⲟⲛⲧ⳿ⲁ ⲛⲁⲩϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲛⲁⲩⲫⲱϣ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲁⲩ ⲧⲏⲣⲟⲩ ⲕⲁⲧⲁ ⲡⲉⲧⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ⲛⲁⲩⲙⲏⲛ ⲇⲉ ⳿ⲙⲙⲏⲛⲓ ⲡⲉ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲉⲩⲫⲱϣ ⳿ⲛⲟⲩⲱⲓⲕ ⲕⲁⲧⲁ ⲏⲓ ⲟⲩⲟϩ ⲛⲁⲩϭⲓ ⳿ⲛⲟⲩ⳿ϧⲣⲉ ϧⲉⲛ ⲟⲩⲑⲉⲗⲏⲗ ⲛⲉⲙ ⲟⲩϩⲏⲧ ⲉϥⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ⲉⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ϧⲁⲧⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ Ⲡ⳪ ⲇⲉ ϣⲁϥⲟⲩⲟϩ ⳿ⲉⲛⲏ⳿ⲉⲧⲉϣⲁⲩⲛⲟϩⲉⲙ ⳿ⲙⲙⲏⲛⲓ ϩⲓ ⲫⲁⲓ ⳿ⲉⲫⲁⲓ . ");
INSERT INTO copcnt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲁⲩⲛⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛϯⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲛⲧⲉ ⲁϫⲡϧ̅ϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⲉϥⲟⲓ ⳿ⲛϭⲁⲗⲉ ⲓⲥϫⲉⲛ ⲉϥϧⲉⲛ ⳿ⲑⲛⲉϫⲓ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ ⲫⲁⲓ ⲛⲉϣⲁⲩⲧⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲏⲛⲓ ⳿ⲛⲥⲉⲭⲁϥ ϧⲁⲧⲉⲛ ⳿ⲫⲣⲟ ⳿ⲛϯⲡⲩⲗⲏ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲑⲏ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⳿ⲧⲥⲁⲓ⳿ⲏⲉⲑⲣⲉϥϭⲓ ⳿ⲛⲟⲩⲙⲉⲑⲛⲁⲏⲧ ⳿ⲛⲧⲉⲛ ⲛⲏⲉⲑⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ⲫⲁⲓ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲉⲩⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲛⲁϥⲧⲱⲃϩ ⳿ⲙⲙⲱⲟⲩ ⲉϥⲟⲩⲱϣ ⳿ⲉϭⲓ ⳿ⲛⲟⲩⲙⲉⲑⲛⲁⲏⲧ ⳿ⲛⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲁϥⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϫⲁϥ ϫⲉ ⲥⲟⲙⲥ ⳿ⲉⲣⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","⳿ⲛⲑⲟϥ ⲇⲉ ⲛⲁϥⲙⲉⲩⲓ ϫⲉ ⲁϥⲛⲁϭⲓ ⳿ⲛⲟⲩⲙⲉⲑⲛⲁⲏⲧ ⳿ⲛⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲟⲩϩⲁⲧ ⲛⲉⲙ ⲟⲩⲛⲟⲩⲃ ⳿ⲛ⳿ϥϣⲟⲡ ⲛⲏⲓ ⲁⲛ ⲡⲉⲧⲉⲛⲧⲏⲓ ⲇⲉ ϯϯ ⳿ⲙⲙⲟϥ ⲛⲁⲕ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ ⲧⲱⲛⲕ ⲙⲟϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ⲁϥ⳿ⲁⲙⲁϩⲓ ⲇⲉ ⳿ⲛⲧⲉϥϫⲓϫ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲛϯⲟⲩⲛⲟⲩ ⲇⲉ ⲁⲩⲧⲁϫⲣⲟ ⳿ⲛϫⲉ ⲛⲉϥⲃⲁⲥⲓⲥ ⲛⲉⲙ ⲛⲓϭⲟⲡ ⳿ⲛⲧⲉ ⲣⲁⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ⲁϥϭⲓⲫⲉⲓ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲁϥⲙⲟϣⲓ ⲟⲩⲟϩ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙⲱⲟⲩ ⲉϥⲙⲟϣⲓ ⲉϥϭⲓⲫⲉⲓ ⲉϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲉϥⲙⲟϣⲓ ⲉϥ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ⲛⲁⲩⲥⲱⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲟϥ ⲡⲉ ϫⲉ ⲫⲁⲓ ⲡⲉ ⲫⲏ⳿ⲉⲛⲁϥϩⲉⲙⲥⲓ ⲉϥϣⲁⲧ ⲙⲉⲑⲛⲁⲓ ϧⲁⲧⲉⲛ ϯⲥⲁⲓ⳿ⲏ⳿ⲙⲡⲩⲗⲏ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲁⲩⲙⲟϩ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩϩⲟϯ ⲛⲉⲙ ⲟⲩⲙ⳿ⲉⲧⲉⲃⲏ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲫⲁⲓ ⳿ⲉⲧⲁϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ⲁϥ⳿ⲁⲙⲁϩⲓ ⲇⲉ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲁϥⲫⲱⲧ ϩⲁⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ϧⲁⲧⲉⲛ ϯ⳿ⲥⲧⲟ⳿ⲁ ⲑⲏ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⲑⲁ Ⲥⲟⲗⲟⲙⲱⲛ ⲉⲩ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲟⲩϩⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧ⳿ⲉⲛⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ⲫⲁⲓ ⲓⲉ ⳿ⲁϧⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲟⲙⲥ ⳿ⲉⲣⲟⲛ ϩⲱⲥ ϫⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲧⲉⲛϫⲟⲙ ⲓⲉ ⲧⲉⲛⲙ⳿ⲉⲧⲉⲩⲥⲉⲃⲏⲥ ⲁⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲫⲁⲓ ⲉⲑⲣⲉ ⲫⲁⲓ ⲙⲟϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ⲫϯ ⳿ⲛⲀⲃⲣⲁⲁⲙ ⲛⲉⲙ Ⲫϯ ⳿ⲛ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ Ⲫϯ ⳿ⲛⲒⲁⲕⲱⲃ Ⲫϯ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲁϥ ϯ⳿ⲱⲟⲩ ⳿ⲙⲡⲉϥ⳿ⲁⲗⲟⲩ Ⲓⲏ̅ⲥ̅ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲧⲏⲓϥ ⲁⲧⲉⲧⲉⲛϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲠⲓⲗⲁⲧⲟⲥ ⲉⲁ ⲫⲏⲙⲉⲛ ϯϩⲁⲡ ⳿ⲉⲭⲁϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲡⲉⲑⲟⲩⲁⲃ ⲡⲓ⳿ⲑⲙⲏⲓ ⲁⲧⲉⲧⲉⲛϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⳿ⲁⲣⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲉⲧⲓⲛ ⲉⲑⲣⲟⲩⲭⲁ ⲟⲩⲣⲱⲙⲓ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛⲣⲉϥϧⲱⲧⲉⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ⲡⲁⲣⲭⲏⲅⲟⲥ ⲇⲉ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ ⳿ⲁⲣⲉⲧⲉⲛϧⲟⲑⲃⲉϥ ⲫⲁⲓ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲫⲁⲓ ⳿ⲁⲛⲟⲛ ⲧⲉⲛⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⲛⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ⲟⲩⲟϩ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲧⲉ ⲡⲉϥⲣⲁⲛ ⲫⲁⲓ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲡⲉϥⲣⲁⲛ ⲡⲉ ⳿ⲉⲧⲁϥⲧⲁⲗϭ ⲟϥ ⲟⲩⲟϩ ⲡⲓⲛⲁϩϯ ⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲡⲉ ⲁϥϯ ⲛⲁϥ ⳿ⲙⲡⲓⲟⲩϫⲁⲓ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ϯⲛⲟⲩ ⲇⲉ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϯⲥⲱⲟⲩⲛ ϫⲉ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲁⲓⲥ ϧⲉⲛ ⲟⲩⲙⲉⲧⲁⲧ⳿ⲉⲙⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲉⲧⲉⲛⲕⲉⲁⲣⲭⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ⲫϯ ⲇⲉ ⲛⲏ⳿ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱⲟⲩ ⳿ⲛⲛⲉϥ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ ⲉⲑⲣⲉ ⲡⲉϥⲭ͞ⲣⲥ̅ ϣⲉⲡ⳿ⲙⲕⲁϩ ⲁϥϫⲟⲕⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","⳿ⲁⲣⲓⲙⲉⲧⲁⲛⲟⲓⲛ ⲟⲩⲛ ⲟⲩⲟϩ ⲕⲉⲧ ⲑⲏⲛⲟⲩ ⲉⲑⲣⲟⲩϥⲱϯ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲉⲧⲉⲛⲛⲟⲃⲓ ϩⲟⲡⲱⲥ ⳿ⲛⲥⲉ⳿Ⲓ ⲛⲱⲧⲉⲛ ⳿ⲛϫⲉ ϩⲁⲛⲥⲏⲟⲩ ⳿ⲛ⳿ⲭⲃⲟⲃ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙ⳿ⲡϩⲟ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ⲟⲩⲟϩ ⲉϥ⳿ⲉⲧⲁⲟⲩ⳿ⲟ ⲛⲱⲧⲉⲛ ⳿ⲙⲫⲏ⳿ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲑⲁϣϥ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ⲫⲁⲓ ⳿ⲉⲧⲉ ϩⲱϯ ⲡⲉ ⳿ⲛⲧⲉ ⲛⲓⲫⲏⲟⲩ⳿Ⲓ ϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ϣⲁ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁϥⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱⲟⲩ ⳿ⲛⲛⲉϥ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲓⲥϫⲉⲛ ⳿ⲡ⳿⳿ⲉⲛⲉϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ⲙⲱ⳿ⲩⲥⲏⲥ ⲙⲉⲛ ⲁϥϫⲟⲥ ϫⲉ ⳿ⲉⲣⲉ Ⲡ⳪ Ⲫϯ ⲉϥ⳿ⲉⲧⲟⲩⲛⲟⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲡⲁⲣⲏϯ ⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ ⲕⲁⲧⲁ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉϥⲛⲁϫⲟⲧⲟⲩ ⲛⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ⲉⲥ⳿ⲉϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲯⲩⲭⲏ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲛ⳿ⲥⲛⲁⲥⲱⲧⲉⲙ ⲁⲛ ⳿ⲛⲥⲁ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲩ⳿ⲉϥⲱϯ ⳿ⲛϯⲯⲩⲭⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲥⲗⲁⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ⲟⲩⲟϩ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ ⲓⲥϫⲉⲛ ⲥ⳿ⲁⲙⲟⲩⲏⲗ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲓ ⲙ⳿ⲉⲛⲉⲛⲥⲱϥ ⲁⲩⲥⲁϫⲓ ⲟⲩⲟϩ ⲁⲩϩⲓⲱⲓϣ ⲉⲑⲃⲉ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ϯⲇⲓ⳿ⲁⲑⲏⲕⲏ⳿ⲉⲧⲁ Ⲫϯ ⲥⲉⲙⲛⲏⲧⲥ ⲛⲉⲙ ⲛⲉⲛⲓⲟϯ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲀⲃⲣⲁⲁⲙ ϫⲉ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲉⲩ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ϧⲉⲛ ⲡⲉⲕ⳿ϫⲣⲟϫ ⳿ⲛϫⲉ ⲛⲓⲡⲁⲧⲣⲓ⳿ⲁ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","⳿ⲛϣⲟⲣⲡ ⲙⲉⲛ ⳿ⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥ ⲡⲉϥ⳿ⲁⲗⲟⲩ ⲛⲱⲧⲉⲛ ⲁϥⲧⲁⲟⲩⲟϥ ⳿ⲉ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉⲭⲁⲥ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ϩⲉⲛϥ ⲥⲁⲃⲟⲗ ⳿ⲛⲛⲉϥⲡⲉⲧϩⲱⲟⲩ . ");
INSERT INTO copcnt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ⲉⲩⲥⲁϫⲓ ⲇⲉ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲟⲩⲏⲃ ⲛⲉⲙ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ⲉⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲩ ϫⲉ ⲛⲁⲩϯ⳿ⲥⲃⲱ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩϩⲓⲱⲓϣ ϧⲉⲛ Ⲓⲏ̅ⲥ̅ ⳿ⲛϯ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ϯ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⲁⲩϩⲓⲧⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ϣⲁ ⲡⲉϥⲣⲁⲥϯ ⲛⲉⲁ ⲣⲟⲩϩⲓ ϩⲏⲇⲏ ϣⲱⲡⲓ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⲁⲩⲛⲁϩϯ ⲟⲩⲟϩ ⲁⲩϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲧⲏⲡⲓ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⲉⲩⲉⲣ ⲉ̅ ⳿ⲛϣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁ ⲡⲉϥⲣⲁⲥϯ ϣⲱⲡⲓ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲱⲛ ⲛⲉⲙ ⲛⲟⲩ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ⲛⲉⲙ Ⲁⲛⲛⲁ ⲛⲉⲙ Ⲕⲁⲓ⳿ⲁⲫⲁ ⲛⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲛⲉⲙ ⲁⲗⲉⲝⲁⲛⲇⲣⲟⲥ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲅⲉⲛⲟⲥ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲁϩⲱⲟⲩ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲛⲁⲩϣⲓⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ϫⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲁϣ ⳿ⲛϫⲟⲙ ⲓⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲁϣ ⳿ⲛⲣⲁⲛ ⳿ⲁⲣⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ⲧⲟⲧⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥⲙⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲛⲓⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ⲓⲥϫⲉ ⳿ⲁⲛⲟⲛ ⳿ⲙⲫⲟⲟⲩ ⲥⲉⲉⲣⲁⲛⲁⲕⲣⲓⲛⲓⲛ ⳿ⲙⲙⲟⲛ ⲉⲑⲃⲉ ⲟⲩ ϩⲱⲃ ⳿ⲉⲛⲁⲛⲉϥ ⳿ⲉⲁϥϣⲱⲡⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛϫⲱⲃ ϫⲉ ⳿ⲉⲧⲁ ⲫⲁⲓ ⲟⲩϫⲁⲓ ϧⲉⲛ ⲛⲓⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ⲙⲁⲣⲉ ⲡⲓϩⲱⲃ ⲟⲩⲟⲛϩ ⳿ⲉⲣⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⳿ⲛⲧⲉ Ⲡⲓ̅ⲥ̅ⲗ̅ ϫⲉ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲁⲧⲉⲛⲁϣϥ ⲫⲁⲓ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲫⲁⲓ ⳿ϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲫⲁⲓ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙⲑⲟ ⲉϥⲟⲩⲟϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ⲫⲁⲓ ⲡⲉ ⲡⲓ⳿ⲱⲛⲓ ⳿ⲉⲧⲁⲩϣⲟϣϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲏⲉⲧⲕⲱⲧ ⲫⲁⲓ ⲁϥϣⲱⲡⲓ ⳿ⲛⲟⲩϫⲱϫ ⳿ⲛⲗⲁⲕϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⲕⲉⲟⲩⲁⲓ ⳿ⲉⲣⲉ ⳿ⲫⲛⲟϩⲉⲙ ϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⲕⲉⲣⲁⲛ ⲥⲁⲡⲉⲥⲏⲧ ⳿ⲛ⳿ⲧⲫⲉ ⳿ⲉⲁⲩⲧⲏⲓϥ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲫⲏ⳿ⲉⲧⲉϩⲱϯ ⳿ⲛⲧⲟⲩⲛⲟϩⲉⲙ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲉ⳿ⲧⲡⲁⲣⲣⲏⲥⲓⲁ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲉⲙⲓ ϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⲛⲉ ⳿ⲛⲥⲉⲥⲱⲟⲩⲛ ⳿ⲛ⳿ⲥϧⲁⲓ ⲁⲛ ⲟⲩⲟϩ ϩⲁⲛⲓⲇⲓⲱⲧⲏⲥ ⲛⲉ ⲛⲁⲩⲉⲣ⳿ϣⲫⲏⲣⲓ ⲡⲉ ⲛⲁⲩⲥⲱⲟⲩⲛ ⲇⲉ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⲛⲁⲩⲭⲏ ⲛⲉⲙ Ⲓⲏ̅ⲥ̅ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ⲡⲓⲕⲉⲣⲱⲙⲓ ⲇⲉ ⲛⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲁϥⲟⲩϫⲁⲓ ⲛⲁⲩϣϯ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","⳿ⲉⲧⲁⲩⲟⲩⲁϩⲥⲁϩⲛⲓ ⲇⲉ ⳿ⲛⲥⲉϩⲓⲧⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲛⲛⲁⲁⲓϥ ⳿ⲛⲛⲁⲓⲣⲱⲙⲓ ⳿ⲟⲧⲓ ⲙⲉⲛ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲙⲏⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⲉϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲥⲉⲥⲱⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲏⲧⲏⲣⲟⲩ ⲉⲧϣⲟⲡ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ ⳿ⲉϫⲱⲗ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ⲁⲗⲗⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲡⲓϩⲱⲃ ⲥⲱⲣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲗⲁⲟⲥ ⳿ⲛϩⲟⲩⲟ ⲙⲁⲣⲉⲛⲛⲟϣⲡⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩ⳿ϣⲧⲉⲙⲥⲁϫⲓ ⲛⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲣⲱⲙⲓ ϧⲉⲛ ⲡⲁⲓⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⲁⲩϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣⲟⲩⲱ ⳿ⲉ⳿ⲡⲧⲏⲣϥ ⲟⲩⲇⲉ ⳿ⲉ⳿ϣⲧⲉⲙϯ ⳿ⲥⲃⲱ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ⲡⲉϫⲱⲟⲩ ⲛⲱⲟⲩ ⲓⲥϫⲉ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲧⲉ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲪϯ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⳿⳿ⲉϩⲟⲧⲉ Ⲫϯ ⲙⲁϩⲁⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⳿ⲁⲛⲟⲛ ⲛⲏⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲉⲧⲁⲛⲥⲟⲑⲙⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲟϣⲡⲟⲩ ⲁⲩⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲟⲩϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲗⲱⲓϫⲓ ⳿ⲉⲣⲱⲟⲩ ⲉⲑⲃⲉ ⲡⲓⲣⲏϯ ⳿ⲛⲉⲣⲕⲟⲗⲁⲍⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⲉⲑⲃⲉ ⲡⲓⲗⲁⲟⲥ ϫⲉ ⲛⲁⲣⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲉⲑⲃⲉ ⲫⲏ⳿ⲉⲧⲁϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ⲛⲉ ⲁϥⲉⲣϩⲟⲩ⳿ⲟ ⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲁ ⲡⲁⲓϩⲱⲃ ⳿ⲙⲙⲏⲓⲛⲓ ⳿ⲛⲟⲩϫⲁⲓ ϣⲱⲡⲓ ϩⲓⲱⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","⳿ⲉⲧⲁⲩⲭⲁⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲁⲩ⳿ⲓ ϣⲁ ⲛⲏ⳿ⲉⲧⲉⲛⲱⲟⲩ ⲁⲩⲧⲁⲙⲱⲟⲩ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲓⲧⲟⲩ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⲁⲩϭⲓⲥⲓ ⳿ⲛⲧⲟⲩ⳿ⲥⲙⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ϩⲁ Ⲫϯ ⲉⲩⲥⲟⲡ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲉⲛⲛⲏⲃ ⳿ⲛⲑⲟⲕ ⲡⲉⲧⲁⲕⲑⲁⲙⲓⲟ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⳿ⲫⲓⲟⲙ ⲛⲉⲙ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ ⳿ⲛ⳿ϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ⲫⲏ⳿ⲉⲧⲁϥϫⲟⲥ ϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱϥ ⳿ⲙⲡⲉⲛⲓⲱⲧ Ⲇⲁⲩⲓⲇ ⲉⲑⲃⲉ ⲡⲉⲕ⳿ⲁⲗⲟⲩ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϩⲁⲛⲉⲑⲛⲟⲥ ϩⲁⲛⲗⲁⲟⲥ ⲁⲩⲉⲣⲙⲉⲗⲉⲧⲁⲛ ⳿ⲛϩⲁⲛⲡⲉⲧϣⲟⲩⲓⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲟⲩⲣⲱⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ ⲛⲓⲕⲉⲁⲣⲭⲱⲛ ⲁⲩⲑⲱⲟⲩϯ ⲉⲩⲙⲁ ⳿ⲉϯ ⲟⲩⲃⲉ Ⲡ⳪ ⲛⲉⲙ ⲡⲉϥⲭ͞ⲣⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲅⲁⲣ ⲁⲩⲑⲱⲟⲩϯ ϧⲉⲛ ⲧⲁⲓⲡⲟⲗⲓⲥ ⳿ⲉϫⲉⲛ ⲡⲉⲕ⳿ⲁⲗⲟⲩ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿ⲉⲧⲁⲕⲑⲁϩⲥϥ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲛⲉⲙ ⲡⲟⲛⲧⲓⲟⲥ Ⲡⲓⲗⲁⲧⲟⲥ ⲛⲉⲙ ϩⲁⲛⲕⲉⲉⲑⲛⲟⲥ ⲛⲉⲙ ϩⲁⲛⲗⲁⲟⲥ ⳿ⲛⲧⲉ Ⲡⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","⳿ⲉ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁ ⲧⲉⲕϫⲓϫ ⲛⲉⲙ ⲡⲉⲕⲥⲟϭⲛⲓ ⲉⲣϣⲟⲣⲡ ⲉⲑⲣⲟⲩϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ⲟⲩⲟϩ ϯⲛⲟⲩ Ⲡ⳪ ⲥⲟⲙⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲟⲩϫⲱⲛⲧ ⲙⲏ ⲓⲥ ⳿ⲛⲛⲉⲕ⳿ⲉⲃⲓⲁⲓⲕ ⲉⲑⲣⲟⲩⲥⲁϫⲓ ϧⲉⲛ ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉⲕⲥⲟⲩⲧⲱⲛ ⲧⲉⲕϫⲓϫ ⳿ⲉⲃⲟⲗ ⳿ⲉϩⲁⲛⲧⲁⲗϭⲟ ⲛⲉⲙ ϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲉⲑⲣⲟⲩϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲉⲕ⳿ⲁⲗⲟⲩ ⲉⲑⲟⲩⲁⲃ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲃϩ ⲁϥⲕⲓⲙ ⳿ⲛϫⲉ ⲡⲓⲙⲁ ⲉⲛⲁⲩⲑⲟⲩⲏⲧ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁⲩⲙⲟϩ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲟⲩⲟϩ ⲛⲁⲩⲥⲁϫⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲙⲡⲁⲣⲣⲏⲥⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ⲛⲓⲙⲏϣ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⲛⲁⲩⲟⲓ ⳿ⲛⲟⲩϩⲏⲧ ⳿ⲛⲟⲩⲱⲧ ⲛⲉⲙ ⲟⲩⲯⲩⲭⲏ ⳿ⲛⲟⲩⲱⲧ ⲛⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲡⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲟⲩ⳿ϩⲗⲓ ⳿ⲛⲧⲉ ⲛⲉϥϩⲩⲡⲁⲣⲭⲟⲛⲧⲁ ϫⲉ ⲛⲟⲩϥ ⲛⲉ ⲁⲗⲗⲁ ⲛⲁⲣⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϣⲟⲡ ⲛⲱⲟⲩ ϧⲉⲛ ⲟⲩⲙⲉⲧ⳿ϣⲫⲏⲣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","⳿ⲉ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛϫⲟⲙ ⲛⲁⲣⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ϯ ⳿ⲛϯⲙⲉⲧⲙⲉⲑⲣⲉ ϧⲁ ⳿ⲧ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲛ⳿ϩⲙⲟⲧ ⲛⲁϥϩⲓϫⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ⲛⲉ ⳿ⲙⲙⲟⲛ ⲡⲉⲧⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲅⲁⲣ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲉ ⲛⲏⲅⲁⲣ ⳿ⲉⲧⲉ ⲟⲩⲟⲛⲧⲟⲩ ⲓⲟϩⲓ ⳿ⲙⲙⲁⲩ ⲛⲁⲩϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲛⲁⲩ⳿ⲓⲛⲓ ⳿ⲛ⳿ⲧⲧⲓⲙⲏ⳿ⲛⲛⲏ⳿ⲉϣⲁⲩⲧⲏⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ⲛⲁⲩⲭⲱ ⳿ⲙⲙⲱⲟⲩ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲁⲩϯ ⲇⲉ ⳿ⲙ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲡ⳿ⲉⲧⲉϥⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ⲓⲱⲥⲏⲫ ⲇⲉ ⲫⲏ⳿ⲉⲧⲁⲩϯⲣⲉⲛϥ ϫⲉ ⲃⲁⲣⲥⲁⲃⲁⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲉⲧⲉ ⲫⲏⲡⲉ ⳿ⲉϣⲁⲩⲟⲩⲁϩⲙⲉϥ ϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙ⳿ⲡϯϩⲟ ⳿ⲉⲟⲩⲗⲉⲩⲓⲧⲏⲥ ⲡⲉ ⳿ⲛⲕⲩⲡⲣⲓⲟⲥ ϧⲉⲛ ⲡⲉϥⲅⲉⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⲓⲟϩⲓ ⳿ⲙⲙⲁⲩ ⲁϥⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ⲁϥ⳿ⲓⲛⲓ ⳿ⲛⲛⲓ⳿ⲭⲣⲏⲙⲁ ⲁϥⲭⲁⲩ ϧⲁⲧⲉⲛ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ⲟⲩⲣⲱⲙⲓ ⲇⲉ ϩⲱϥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲛⲁⲛⲓⲁⲥ ⲛⲉⲙ ⲥⲁⲡⲫⲓⲣⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲁϥϯ ⳿ⲛⲟⲩⲓⲟϩⲓ ⳿ⲉⲃⲟⲗ ϧⲁ ⲧⲉϥⲧⲓⲙⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ⲉⲥⲥⲱⲟⲩⲛ ⳿ⲛϫⲉ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲁϥ⳿ⲱⲗⲓ ⳿ⲛϭⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲧⲓⲙⲏ⳿ⲛⲧⲉ ⲡⲓⲓⲟϩⲓ ⲁϥ⳿ⲓⲛⲓ ⲇⲉ ⳿ⲛⲟⲩⲙ⳿ⲉⲣⲟⲥ ⲁϥⲭⲁⲩ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲁⲛⲁⲛⲓⲁⲥ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲁ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲙⲁϩ ⲡⲉⲕϩⲏⲧ ⲉⲑⲣⲉⲕϫⲉⲙⲉⲑⲛⲟⲩϫ ⳿ⲉⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲟⲩⲟϩ ⲉⲑⲣⲉⲕ⳿ⲱⲗⲓ ⳿ⲛϭⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲧⲓⲙⲏ⳿ⲛⲧⲉ ⲡⲓⲓⲟϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ⲙⲏⲉϥϣⲟⲡ ⲛⲁϥϣⲟⲡ ⲛⲁⲕ ⲁⲛ ⲡⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲕⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ⲛⲁϥⲭⲏ ⲁⲛ ϧⲁ ⲧⲉⲕⲉⲝⲟⲩⲥⲓⲁ ⲉⲑⲃⲉ ⲟⲩ ϫⲉ ⳿ⲉⲧⲁⲕⲭⲁ ⲡⲁⲓϩⲱⲃ ϧⲉⲛ ⲡⲉⲕϩⲏⲧ ⳿ⲉⲧⲁⲕϫⲉⲙⲉⲑⲛⲟⲩϫ ⳿ⲉⲣⲱⲙⲓ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲉⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ⲉϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲁⲛⲁⲛⲓⲁⲥ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⲁϥϩⲓ ⲁϥϩⲓ ⲡⲉϥⲑⲏⲟⲩ ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⳿ⲛϫⲉ ⲛⲓ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⲁⲩϫⲟⲗϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲛϥ ⳿ⲉⲃⲟⲗ ⲁⲩⲑⲟⲙⲥϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁ ⲅ̅ϯ ⳿ⲛⲟⲩⲛⲟⲩ ⲛⲉⲥⲕⲓ ϣⲱⲡⲓ ⲁⲥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲛ⳿ⲥⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲡⲉⲧⲁϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ⲡⲉϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲁⲥ ϫⲉ ⲁϫⲟⲥ ⲛⲏⲓ ϫⲉ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛϯ ⳿ⲙⲡⲓⲓⲟϩⲓ ⳿ⲉⲃⲟⲗ ϧⲁ ⲛⲁⲓϩⲁⲧ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲡⲉϫⲁⲥ ϫⲉ ⳿ⲁϩⲁ ϧⲁ ⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁⲥ ϫⲉ ⲉⲑⲃⲉ ⲟⲩ ⳿ⲁ ⲡⲁⲓϩⲱⲃ ϯⲙⲁϯ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲡ⳪ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲓϭⲁⲗⲁⲩϫ ⳿ⲛⲧⲉ ⲛⲏ⳿ⲉⲧⲁⲩⲑⲱⲙⲥ ⳿ⲙⲡⲉϩⲁⲓ ⲥⲉⲭⲏ ϩⲓⲣⲉⲛ ⲛⲓⲣⲱⲟⲩ ⲥⲉⲛⲁϥⲓϯ ⳿ⲉⲃⲟⲗ ϩⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ⲁⲥϩⲉⲓ ⲇⲉ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ⲁⲥϩⲓ ⲡⲉⲥⲑⲏⲟⲩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⲛⲓϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⲁⲩϫⲉⲙⲥ ⲉⲥⲙⲱⲟⲩⲧ ⳿ⲉⲧⲁⲩⲟⲗⲥ ⳿ⲉⲃⲟⲗ ⲁⲩⲭⲁⲥ ϧⲁⲧⲉⲛ ⲡⲉⲥϩⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛϩⲟϯ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","⳿ⲉⲃⲟⲗ ⲇⲉ ϩⲓⲧⲉⲛ ⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲁⲩϣⲟⲡ ⲡⲉ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏϣ ⳿ⲙⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⲛⲁⲩⲑⲟⲩⲏⲧ ⲧⲏⲣⲟⲩ ⲉⲩⲥⲟⲡ ϧⲁⲧⲉⲛ ϯ⳿ⲥⲧⲟⲁ ⳿ⲛⲧⲉ Ⲥⲟⲗⲟⲙⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲛⲓⲥⲱϫⲡ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉⲧⲟⲙϥ ⳿ⲉⲣⲱⲟⲩ ⲁⲗⲗⲁ ⲛⲁⲣⲉ ⲡⲓⲗⲁⲟⲥ ϭⲓⲥⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ⲙⲁⲗⲗⲟⲛ ⲇⲉ ⲛⲁⲩⲟⲩⲟϩ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲠ⳪ ⲉⲩⲛⲁϩϯ ⳿ⲛϫⲉ ϩⲁⲛⲙⲏϣ ⳿ⲛⲣⲱⲙⲓ ⲛⲉⲙ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉ⳿ⲓⲛⲓ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲛⲓ⳿ⲡⲗⲁⲧⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲭⲁⲩ ϩⲓϫⲉⲛ ϩⲁⲛ ϭⲗⲟϫ ⲛⲉⲙ ϩⲁⲛⲙⲁ ⳿ⲛⲉⲛⲕⲟⲧ ϩⲓⲛⲁ ⲉϥⲛⲁⲥⲓⲛⲓⲱⲟⲩ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲕⲁⲛ ⳿ⲛⲧⲉ ⲧⲉϥϧⲏⲓⲃⲓ ⳿Ⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ⲛⲁⲩⲛⲏⲟⲩ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲡⲟⲗⲓⲥ ⲉⲧⲕⲱϯ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲉⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⲛⲉⲙ ⲛⲏⲉⲧϩⲏ ϣ ⳿ⲛⲧⲉⲛ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ϣⲁⲩⲟⲩϫⲁⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲏⲧⲏⲣⲟⲩ ⲉⲑⲛⲉⲙⲁϥ ⳿ⲉⲧⲉ ⳿ⲧϩⲉⲣⲉⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲁⲩⲙⲟϩ ⳿ⲛⲭⲟϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉϫⲉⲛ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲟⲩⲟϩ ⲁⲩⲭⲁⲩ ⳿ⲉ⳿ⲡ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲇⲏⲙⲟⲥⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⲇⲉ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲛⲓⲣⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲓ⳿ϣⲧⲉⲕⲟ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ϫⲉ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ⲥⲁϫⲓ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲡⲓⲗⲁⲟⲥ ⳿ⲛⲛⲓⲥⲁϫⲓ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⲡⲁⲓⲱⲛϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⲁⲩϣⲟⲣⲡⲟⲩ ⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲛⲁⲩϯ⳿ⲥⲃⲱ ⲡⲉ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲏⲧⲏⲣⲟⲩ ⲉⲑⲛⲉⲙⲁϥ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲛⲉⲙ ⲛⲓϧⲉⲗⲗⲟⲓ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ⲉⲑⲣⲟⲩ⳿ⲓⲛⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓϩⲩⲡⲉⲣⲉⲧⲏⲥ ⳿ⲙⲡⲟⲩϫⲉⲙⲟⲩ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⳿ⲉⲧⲁⲩⲕⲟⲧⲟⲩ ⲇⲉ ⲁⲩⲧⲁⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲛϫⲓⲙⲓ ⲙⲉⲛ ⳿ⲙⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ⲉϥϣⲟⲧⲉⲙ ϧⲉⲛ ⲧⲁϫⲣⲟ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲓⲣⲉϥ⳿ⲁⲣⲉϩ ⲉⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲁⲧⲉⲛ ⲛⲓⲣⲱⲟⲩ ⳿ⲉⲧⲁⲩⲟⲩⲱⲛ ⲇⲉ ⳿ⲙⲡⲉ⳿ⲛϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛϧⲟⲩⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⳿ⲛϫⲉ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⳿ⲛⲧⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲁⲩⲧⲱⲙⲧ ⲉⲑⲃⲏⲧⲟⲩ ⲡⲉ ϫⲉ ⲟⲩ ⲡⲉ ⲫⲁⲓ ⳿ⲉⲧⲁϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⲁϥⲧⲁⲙⲱⲟⲩ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲓⲣⲱⲙⲓ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲭⲁⲩ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲥⲉ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲩ ϯ⳿ⲥⲃⲱ ⳿ⲙⲡⲓⲗⲁⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ⲧⲟⲧⲉ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⲛⲉⲙ ⲛⲓϩⲩⲡⲉⲣⲉⲧⲏⲥ ⲁⲩ⳿ⲉⲛⲟⲩ ⳿ⲛϫⲟⲛⲥ ⲁⲛ ⲛⲁⲩⲉⲣϩⲟϯ ⲅⲁⲣ ⲡⲉ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲥⲉϩⲓ⳿ⲱⲛⲓ ⳿ⲡⲉϫⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","⳿ⲉⲧⲁⲩ⳿ⲉⲛⲟⲩ ⲇⲉ ⲁⲩⲧⲁϩⲱⲟⲩ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲁϥϣⲉⲛⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϧⲉⲛ ⲟⲩϩⲟⲛϩⲉⲛ ⲁⲛϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲡⲁⲓⲣⲁⲛ ϩⲏⲡⲡⲉ ⲁⲧⲉⲧⲉⲛⲙⲟϩ ⳿ⲛⲒⲗ̅ⲏ̅ⲙ̅ ⲧⲏⲣⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲧⲉⲛ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⳿ⲉ⳿ⲉⲛ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⳿ⲥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ Ⲫϯ ⳿⳿ⲉϩⲟⲧⲉ ⲛⲓⲣⲱⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ⲫϯ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲁϥⲧⲟⲩⲛⲟⲥ Ⲓⲏ̅ⲥ̅ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛ⳿ⲉⲛ ⲛⲉⲧⲉⲛϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲉ⳿ⲁⲣⲉⲧⲉⲛⲁϣϥ ⳿ⲉϫⲉⲛ ⲟⲩϣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ⲫⲁⲓ ⲁϥϭⲁⲥϥ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲛϩⲟⲩⲓⲧ ⳿ⲛⲥⲱⲧⲏⲣ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲧⲉϥⲟⲩ⳿ⲓⲛⲁⲙ ⲉⲑⲣⲉϥϯ ⳿ⲛⲟⲩⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⲛⲉⲙ ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ϩⲁⲛⲛⲟⲃⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲧⲉⲛⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⳿ⲛⲧⲉ ⲛⲁⲓⲥⲁϫⲓ ⲛⲁⲓ Ⲫϯ ⲇⲉ ⲁϥϯ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲛⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲁⲩ⳿ϧⲣⲁϫⲣⲉϫ ⳿ⲛⲛⲟⲩⲛⲁϫϩⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩⲟⲩⲱϣ ⳿ⲉϧⲟⲑⲃⲟⲩ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲟⲩⲪⲁⲣⲓⲥⲉⲟⲥ ⲡⲉ ⲡⲉϥⲣⲁⲛ ⲡⲉ ⲅⲁⲙⲁⲗⲓⲏⲗ ⲟⲩⲣⲉϥϯ⳿ⲥⲃⲱ ⲡⲉ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲉϥⲧⲁⲓⲏⲟⲩⲧ ⳿ⲛⲧⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉϩⲓ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⲙⲁϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲉⲑⲃⲉ ⲛⲁⲓⲣⲱⲙⲓ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲁⲓϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ϧⲁϫⲱⲟⲩ ⲅⲁⲣ ⳿ⲛⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ϫⲉ ⲑⲉⲩⲧⲏⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⲁⲩⲟⲩ⳿ⲁϩⲟⲩ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲩ̅ ⳿ⲛⲏⲡⲓ ⳿ⲛⲣⲱⲙⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲛⲁⲣⲉ ⲡⲟⲩϩⲏⲧ ⲑⲏⲧ ⲛⲉⲙⲁϥ ⲁⲩⲃⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁⲩϣⲱⲡⲓ ⳿ⲉϩⲁⲛ⳿ϩⲗⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ⲙⲉⲛⲉⲛⲥⲁ ⲫⲁⲓ ⲁϥⲧⲱⲛϥ ⳿ⲛϫⲉ Ⲓⲟⲩⲇⲁⲥ ⲡⲓⲄⲁⲗⲓⲗⲉⲟⲥ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ϯⲉⲡⲓ⳿ⲅⲣⲁⲫⲏⲟⲩⲟϩ ⲁϥⲥⲉⲕ ⲟⲩⲙⲏϣ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲡⲓⲭⲉⲧ ⲁϥⲧⲁⲕⲟ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲛⲁⲣⲉ ⲡⲟⲩϩⲏⲧ ⲑⲏⲧ ⲛⲉⲙⲁϥ ⲁⲩⲃⲱⲗ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ⲟⲩⲟϩ ϯⲛⲟⲩ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ϩⲉⲛⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲁⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ⲭⲁⲩ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲉϣⲱⲡ ⲡⲁⲓⲥⲟϭⲛⲓ ⲓⲉ ⲡⲁⲓϩⲱⲃ ⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲡⲉ ⲓⲉ ⳿ϥⲛⲁⲃⲱⲗ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ⲓⲥϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲫϯ ⲡⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲙⲏ ⲡⲟⲧⲉ ⳿ⲛⲥⲉϫⲉⲙ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲣⲉϥϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ ⲁⲩⲙⲟⲩϯ ⳿ⲉⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲱⲟⲩ ⲁⲩϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙϯ⳿ⲥⲃⲱ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ⲁⲩⲭⲁϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⲛⲁⲩⲙⲟϣⲓ ⲉⲩⲣⲁϣⲓ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡϩⲟ ⳿ⲙⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ϫⲉ ⲁⲩⲉⲣ⳿ⲡⲉⲙⲡϣⲁ ⳿ⲛϣⲟϣⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲓⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ⲛⲁⲩϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲙⲙⲏⲛⲓ ⲡⲉ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲭⲱ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲉⲩϯ⳿ⲥⲃⲱ ⲕⲁⲧⲁ ⲏⲓ ⲉⲩϩⲓⲱⲓϣ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ");
INSERT INTO copcnt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁⲩ⳿ⲁϣⲁⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲟⲩⲃⲉ ⲛⲓϩⲉⲃⲣⲉⲟⲥ ϫⲉ ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲁⲛ ⲡⲉ ⳿ⲉⲡⲓϣⲉⲙϣⲓ ⳿ⲙⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ ⲛⲟⲩⲭⲏⲣⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ⲁ ⲡⲓⲓ̅ⲃ̅ ⲇⲉ ⳿ⲛⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲙⲟⲩϯ ⳿ⲉⲡⲓⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲡⲉϫⲱⲟⲩ ⲛⲱⲟⲩ ⲡⲓϩⲱⲃ ⲣⲁⲛⲁⲛ ⲁⲛ ⲉⲑⲣⲉⲛⲭⲱ ⳿ⲛⲥⲱⲛ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲛⲧⲉⲛϣⲉⲙϣⲓ ⳿ⲛϩⲁⲛ⳿ⲧⲣⲁⲡⲉⲍⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⲟⲩⲛ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲍ̅ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲩⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲱⲟⲩ ⲉⲩⲙⲉϩ ⳿ⲙ⳿ⲡⲡ͞ⲛⲁ̅ ⲛⲉⲙ ⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉⲛⲭⲁⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϯ⳿ⲭⲣⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","⳿ⲁⲛⲟⲛ ⲇⲉ ⳿ⲛⲧⲉⲛ⳿ⲥⲣⲱϥⲧ ⳿ⲉϯⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲉⲙ ⲡⲓϣⲉⲙϣⲓ ⳿ⲛⲧⲉ ⲡⲓⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ⲟⲩⲟϩ ⳿ⲁ ⲡⲓⲥⲁϫⲓ ⲣⲁⲛⲱⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲁⲩⲥⲱⲧⲡ ⳿ⲛ⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲣⲱⲙⲓ ⲡⲉ ⲉϥⲙⲉϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⲛⲉⲙ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲉⲙ ⳿ⲡⲣⲟⲭⲱⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲕⲁⲛⲱⲣ ⲛⲉⲙ ⲧⲓⲙⲱⲛ ⲛⲉⲙ ⲡⲁⲣⲙⲉⲛⲁ ⲛⲉⲙ ⲛⲓⲕⲟⲗⲁⲟⲥ ⲡⲓϣⲉⲙⲙⲟ ⳿ⲛⲣⲉⲙ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ⲛⲁⲓ ⳿ⲉⲧⲁⲩⲧⲁϩⲱⲟⲩ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲃϩ ⲁⲩⲭⲁ ϫⲓϫ ⳿ⲡⲉϫⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ⲟⲩⲟϩ ⳿ⲁ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲁⲓⲁⲓ ⲁⲥ⳿ⲁϣⲁⲓ ⳿ⲛϫⲉ ⳿ⲧⲏⲡⲓ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲙⲁϣⲱ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲙⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲏⲃ ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⳿ⲫⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⲇⲉ ⲉϥⲙⲉϩ ⳿ⲛ⳿ϩⲙⲟⲧ ⲛⲉⲙ ϫⲟⲙ ⲛⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲛⲓϣϯ ⳿ⲙⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲛⲉⲙ ϩⲁⲛϫⲟⲙ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲓⲗⲁⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲉⲧⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲓⲗⲓⲃⲉⲣⲧⲓⲛⲟⲥ ⲛⲉⲙ ⲛⲓⲔⲩⲣⲓⲛⲛⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲣⲉⲙⲣⲁⲕⲟϯ ⲛⲉⲙ ⲛⲓⲣⲉⲙ⳿ⲧⲕⲩⲗⲓⲕⲓⲁ ⲛⲉⲙ ϯ⳿ⲁⲥⲓ⳿ⲁ ⲉⲩⲕⲱϯ ⲛⲉⲙ ⳿ⲥⲧⲉⲫⲁⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ⲟⲩⲟϩ ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ϯⲥⲟⲫⲓ⳿ⲁ ⲛⲉⲙ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉⲧⲉⲛⲁϥⲥⲁϫⲓ ⳿ⲛϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ⲧⲟⲧⲉ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⳿ⲛϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲘⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ⲁⲩⲕⲓⲙ ⲇⲉ ⳿ⲉⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲛⲓⲥⲁϧ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⲁⲩϩⲟⲗⲙⲉϥ ⲁⲩⲉⲛϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ⲁⲩⲧⲁϩⲟ ⳿ⲛϩⲁⲛⲙⲉⲧⲙⲉⲑⲣⲉⲩ ⳿ⲛⲛⲟⲩϫ ⳿ⲉⲣⲁⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲛ⳿ϥⲭⲱ ⳿ⲛⲧⲟⲧϥ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲉϥϫⲱ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲥⲁ ⲡⲁⲓⲙⲁ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ ⲡⲓⲛⲟⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ⲁⲛⲥⲱⲧⲉⲙ ⲅⲁⲣ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ ⳿ⲛⲑⲟϥ ⲉⲑⲛⲁⲃⲉⲗ ⲡⲁⲓⲙⲁ ⲉⲑⲟⲩⲁⲃ ⳿ⲉⲃⲟⲗ ⳿ϥⲛⲁϣⲓⲃϯ ⳿ⲛⲛⲓⲥⲩⲛⲏⲑⲓⲁ ⳿ⲉⲧⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲉⲧⲟⲧⲉⲛ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","⳿ⲉⲧⲁⲩⲥⲟⲙⲥ ⲧⲏⲣⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲛϫⲉ ⲛⲏⲉⲧϩⲉⲙⲥⲓ ϧⲉⲛ ⲡⲓⲙⲁⲛϯϩⲁⲡ ⲁⲩⲛⲁⲩ ⳿ⲉⲡⲉϥϩⲟ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡϩⲟ ⳿ⲛⲟⲩⲁⲅⲅⲉⲗⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ϫⲉ ⲁⲛ ⲛⲁⲓ ϣⲟⲡ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲛⲉⲛⲓⲟϯ ⲥⲱⲧⲉⲙ Ⲫϯ ⳿ⲛⲧⲉ ⳿ⲡ⳿ⲱⲟⲩ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲡⲉⲛⲓⲱⲧ Ⲁⲃⲣⲁⲁⲙ ⲉϥⲭⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ϧⲉⲛ ϯⲙⲉⲥⲟⲡⲟⲧⲁⲙⲓ⳿ⲁ ⳿ⲙⲡⲁⲧⲉϥϣⲱⲡⲓ ϧⲉⲛ ⲭⲁⲣⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲁⲙⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲕⲕⲁϩⲓ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲕⲥⲩⲅⲅⲉⲛⲓ⳿ⲁ ⳿ⲁⲙⲟⲩ ⳿ⲉⲡⲓⲕⲁϩⲓ ⳿ⲉϯⲛⲁⲧⲁⲙⲟⲕ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ⲧⲟⲧⲉ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲧⲉ ⲛⲓⲭⲁⲗⲇⲉⲟⲥ ⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲭⲁⲣⲣⲁⲛ ⳿ⲉⲃⲟⲗ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲉϥⲙⲟⲩ ⳿ⲛϫⲉ ⲡⲉϥⲓⲱⲧ ⲁϥⲟⲩⲟⲑⲃⲉϥ ⳿ⲉⲃⲟⲗ ⲉⲑⲣⲉϥϣⲱⲡⲓ ϧⲉⲛ ⲡⲁⲓⲕⲁϩⲓ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛϣⲟⲡ ϩⲓⲱⲧϥ ϯⲛⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","⳿ⲙⲡⲉϥϯ ⲛⲁϥ ⳿ⲛⲟⲩ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓ⳿ⲁ ⳿ⲛϧⲏⲧϥ ⲟⲩⲇⲉ ⲟⲩϣⲉⲛⲧⲁⲧⲥⲓ ⳿ⲛⲧⲉ ⲟⲩϭⲁⲗⲟϫ ⲁϥⲱϣ ⳿ⲉⲧⲏⲓϥ ⲛⲁϥ ϧⲉⲛ ⲟⲩ⳿ⲁⲙⲁϩⲓ ⲛⲉⲙ ⲡⲉϥ⳿ϫⲣⲟϫ ⲙ⳿ⲉⲛⲉⲛⲥⲱϥ ⳿ⲙⲙⲟⲛⲧⲉϥ ϣⲏⲣⲓ ⲇⲉ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ⲁ Ⲫϯ ⲇⲉ ⲥⲁϫⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ϫⲉ ⳿ⲉⲣⲉ ⲡⲉⲕ⳿ϫⲣⲟϫ ⲉⲣⲣⲉⲙ⳿ⲛϫⲱⲓⲗⲓ ϧⲉⲛ ⲟⲩⲕⲁϩⲓ ⳿ⲛϣⲉⲙⲙⲟ ⲟⲩⲟϩ ⲉⲩ⳿ⲉⲁⲓⲧⲟⲩ ⳿ⲙⲃⲱⲕ ⲟⲩⲟϩ ⲉⲩ⳿ⲉ⳿ⲧϩⲉⲙⲕⲱⲟⲩ ⳿ⲛⲩ̅ ⳿ⲛⲣⲟⲙⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ⲟⲩⲟϩ ⲡⲓ⳿ϣⲗⲱⲗ ⲉⲧⲟⲩⲛⲁⲉⲣⲃⲱⲕ ⲛⲁϥ ⲉⲓ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⳿ⲁⲛⲟⲕ ⲡⲉϫⲉ Ⲫϯ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲉⲩ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲉⲩ⳿ⲉϣⲉⲙϣⲓ ⳿ⲙⲙⲟⲓ ϧⲉⲛ ⲡⲁⲓⲙⲁ ⲫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ⲟⲩⲟϩ ⲁϥϯ ⲛⲁϥ ⳿ⲛⲟⲩⲇⲓ⳿ⲁⲑⲏⲕⲏ⳿ⲛⲧⲉ ⳿ⲡⲥⲉⲃⲓ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁϥ⳿ϫⲫⲉ ⳿ Ⲓⲥⲁⲁⲕ ⲟⲩⲟϩ ⲁϥⲥⲟⲩⲃⲏⲧϥ ϧⲉⲛ ⲡⲓⲙⲁϩⲏ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⳿ Ⲓⲥⲁⲁⲕ ⲁϥ⳿ϫⲫⲉ Ⲓⲁⲕⲱⲃ Ⲓⲁⲕⲱⲃ ⲁϥ⳿ϫⲫⲟ ⳿ⲙⲡⲓⲓ̅ⲃ̅ ⳿ⲙⲡⲁⲧⲣⲓⲁⲣⲭⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ⲟⲩⲟϩ ⲛⲓⲡⲁⲧⲣⲓⲁⲣⲭⲏⲥ ⲁⲩⲭⲟϩ ⳿ⲉⲒⲱⲥⲏⲫ ⲁⲩⲧⲏⲓϥ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲬⲏⲙⲓ ⲟⲩⲟϩ ⲛⲁⲣⲉ Ⲫϯ ⲭⲏ ⲛⲉⲙⲁϥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ⲁϥⲛⲁϩⲙⲉϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥ⳿ⲑⲗⲩⲯⲓⲥ ⲧⲏⲣⲟⲩ ⲁϥϯ ⲛⲁϥ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⲛⲉⲙ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫⲁⲣⲁⲱ ⳿ⲡⲟⲩⲣⲟ ⳿ⲛⲬⲏⲙⲓ ⲁϥⲭⲁϥ ⳿ⲛϩⲩⲅⲟⲩⲙⲉⲛⲟⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲭⲏ ⲙⲓ ⲛⲉⲙ ⳿ⲉϫⲉⲛ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩ⳿ϩⲃⲱⲛ ⳿ⲉϫⲉⲛ ⲭⲏ ⲙⲓ ⲧⲏⲣϥ ⲛⲉⲙ ⲭⲁⲛⲁⲁⲛ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲑⲗⲩ ⲯⲓⲥ ⲟⲩⲟϩ ⲛⲁⲩϫⲉⲙ ⲥⲟⲩ⳿ⲟ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲉⲛⲓⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲁⲕⲱⲃ ϫⲉ ⲥⲉϯ ⲥⲟⲩ⳿ⲟ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲭⲏ ⲙⲓ ⲁϥⲧⲁⲟⲩ⳿ⲟ ⳿ⲛⲛⲉⲛⲓⲟϯ ⳿ⲛϣⲟⲣⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ⲟⲩⲟϩ ϧⲉⲛ ⲡⲓⲙⲁϩⲥⲟⲡ ⲃ̅ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲛϫⲉ Ⲓⲱⲥⲏⲫ ⳿⳿ⲉⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⳿ⲁ ⳿ⲡⲅⲉⲛⲟⲥ ⳿ⲛⲒⲱⲥⲏⲫ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲫⲁⲣⲁⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ⲁϥⲟⲩⲱⲣⲡ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲱⲥⲏⲫ ⲁϥⲙⲟⲩϯ ⳿ⲉⲒⲁⲕⲱⲃ ⲡⲉϥⲓⲱⲧ ⲛⲉⲙ ⲧⲉϥⲥⲩⲅⲅⲉⲛⲓⲁ ⲧⲏⲣⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲟ̅ⲉ̅ ⳿ⲙⲯⲩⲭⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲓⲁⲕⲱⲃ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲬⲏⲙⲓ ⲟⲩⲟϩ ⲁϥⲙⲟⲩ ⳿ⲛⲑⲟϥ ⲛⲉⲙ ⲛⲉⲛⲓⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ⲟⲩⲟϩ ⲁⲩⲟⲩⲟⲑⲃⲉϥ ⳿ⲉⲥⲩⲭⲉⲙ ⲁⲩⲭⲁϥ ϧⲉⲛ ⲡⲓ⳿ⲙϩⲁⲩ ⳿ⲉⲧⲁϥϣⲟⲡϥ ⳿ⲛϫⲉ Ⲁⲃⲣⲁⲁⲙ ϧⲁ ⲟⲩⲧⲓⲙⲏ⳿ⲛϩⲁⲧ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲛⲉⲙⲱⲣ ϧⲉⲛ ⲥⲩⲭⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲇⲉ ⳿ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲛϫⲉ ⳿ⲡⲥⲏⲟⲩ ⳿ⲛⲧⲉ ϯⲉⲡⲁⲅⲅⲉⲗⲓ⳿ⲁ ⲑⲏ⳿ⲉⲧⲁ Ⲫϯ ⲱⲣⲕ ⲉⲑⲃⲏⲧⲥ ⳿ⲛⲀⲃⲣⲁⲁⲙ ⲁϥⲁⲓⲁⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲁⲙⲁϩⲓ ⲁϥ⳿ⲁϣⲁⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲭⲏ ⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ϣⲁⲛⲧⲉϥⲧⲱⲛϥ ⳿ⲛϫⲉ ⲕⲉⲟⲩⲣⲟ ⳿ⲉϫⲉⲛ ⲭⲏ ⲙⲓ ⳿ⲛ⳿ϥⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛⲒⲱⲥⲏⲫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ⲫⲁⲓ ⲁϥϫⲉⲙ ⲟⲩ⳿ⲥⲃⲱ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉⲛⲅⲉⲛⲟⲥ ⲁϥ⳿ⲧϩⲉⲙⲕⲟ ⳿ⲛⲛⲉⲛⲓⲟϯ ⲉⲑⲣⲟⲩϩⲓⲟⲩ⳿Ⲓ ⳿ⲛⲛⲟⲩⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϣⲧⲉⲙⲧⲁⲛϧⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩⲙⲓⲥⲓ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲛⲉ ⲟⲩⲁⲥⲧⲓⲟⲥ ⲡⲉ ⳿ⲙⲪϯ ⲫⲁⲓ ⲁⲩϣⲁⲛⲟⲩϣϥ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲙⲡⲉϥⲓⲱⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","⳿ⲉⲧⲁⲩϩⲓⲧϥ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲁⲥⲟⲗϥ ⳿ⲛϫⲉ ⳿ⲧϣⲉⲣⲓ ⳿ⲙⲫⲁⲣⲁⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ⲟⲩⲟϩ ⲁⲩ⳿ⲧⲥⲁⲃⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉ⳿ⲥⲃⲱ ⲛⲓⲃⲉⲛ ⳿ⲛⲧⲉ ⲛⲓⲣⲉⲙ⳿ⲛⲬⲏⲙⲓ ⲛⲁϥϫⲟⲣ ⲡⲉ ϧⲉⲛ ⲛⲉϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲛⲥⲏⲟⲩ ⲁⲥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥϩⲏⲧ ⳿ⲉϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⳿ⲛⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⲟⲩⲁⲓ ⲉⲩϭⲓ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲟⲛⲥ ⲁϥϣⲉⲛϩⲏⲧ ⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩϭⲓ ⳿ⲙ⳿ⲡϣⲓϣ ⳿ⲙⲫⲏ⳿ⲉⲛⲁⲩ⳿ⲧϩⲉⲙⲕⲟ ⳿ⲙⲙⲟϥ ⲁϥϧⲱⲧⲉⲃ ⳿ⲙⲡⲓⲣⲉⲙ⳿ⲛⲭⲏⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","⳿ⲉⲛⲁϥⲙⲉⲩⲓ ⲇⲉ ⲡⲉ ϫⲉ ⲥⲉⲛⲁⲕⲁϯ ⳿ⲛϫⲉ ⲛⲉϥ⳿ⲥⲛⲏⲟⲩ ϫⲉ Ⲫϯ ⲛⲁϯ ⳿ⲛⲟⲩⲟⲩϫⲁⲓ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲙⲡⲟⲩⲕⲁϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉϩⲁⲛⲕⲉ ⲭⲱⲟⲩⲛⲓ ⲉⲩ⳿ⲙⲗⲁϧ ⲟⲩⲟϩ ⲛⲁϥϩⲱⲧⲡ ⳿ⲙⲙⲱⲟⲩ ⲡⲉ ⳿ⲉⲟⲩϩⲓⲣⲏⲛⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛ⳿ⲥⲛⲏⲟⲩ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛ ϭⲓ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲉⲣⲏⲟⲩ ⳿ⲛϫⲟⲛⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ⲫⲏ ⲇⲉ ⲉⲧϭⲓ ⳿ⲙⲡⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛϫⲟⲛⲥ ⲁϥϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲡⲉ ⳿ⲉⲧⲁϥⲭⲁⲕ ⳿ⲛⲁⲣⲭⲱⲛ ⲓⲉ ⲣⲉϥϯϩⲁⲡ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ⲙⲏⲉⲕⲟⲩⲱϣ ⳿ⲉϧⲟⲑⲃⲉⲧ ⳿ⲛⲑⲟⲕ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲕϧⲱⲧⲉⲃ ⳿ⲙⲡⲓⲣⲉⲙ⳿ⲛⲬⲏⲙⲓ ⳿ⲛⲥⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ⲁϥⲫⲱⲧ ⲇⲉ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ϧⲉⲛ ⲡⲁⲓⲥⲁϫⲓ ⲁϥⲉⲣⲣⲉⲙ⳿ⲛϫⲱⲓⲗⲓ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲙⲙⲁⲇⲓⲁⲙ ⲡⲓⲙⲁ ⳿ⲉⲧⲁϥ⳿ϫⲫⲉ ϣⲏⲣⲓ ⲃ̅ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⳿ⲡϣⲁϥⲉ ⳿ⲛⲧⲉ ⳿ⲡⲧⲱⲟⲩ ⳿ⲛⲥⲓⲛⲁ ⳿ⲛϫⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ϧⲉⲛ ⲟⲩϣⲁϩ ⳿ⲛ⳿ⲭⲣⲱⲙ ϩⲓϫⲉⲛ ⲟⲩⲃⲁⲧⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ⲙⲱ⳿ⲩⲥⲏⲥ ⲇⲉ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲡⲓϩⲟⲣⲁⲙⲁ ⲁϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⲉϥⲛⲁ⳿ⲓ ⲇⲉ ⳿ⲉϯⲛⲓⲁⲧϥ ⲁⲥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲛⲧⲉ Ⲡ⳪ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲫϯ ⳿ⲛⲧⲉ ⲛⲉⲕⲓⲟϯ Ⲫϯ ⳿ⲛ⳿Ⲁⲃⲣⲁⲁⲙ ⲛⲉⲙ Ⲫϯ ⳿ⲛ⳿ Ⲓⲥⲁⲁⲕ ⲛⲉⲙ Ⲫϯ ⳿ⲛⲒⲁⲕⲱⲃ ⲁϥ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲇⲉ ⳿ⲛϫⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲙⲡⲉϥⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉϯ⳿ⲛⲓⲁⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ⲛⲁϥ ϫⲉ ⲃⲱⲗ ⳿ⲙⲡⲓⲑⲱⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϩⲓ ⲛⲉⲕϭⲁⲗⲁⲩϫ ⲡⲓⲙⲁ ⲅⲁⲣ ⳿ⲉⲧⲉⲕ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲕ ϩⲓϫⲱϥ ⲟⲩⲕⲁϩⲓ ⲉϥⲟⲩⲁⲃ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ϧⲉⲛ ⲟⲩⲛⲁⲩ ⲁⲓⲛⲁⲩ ⳿ⲉ⳿ⲡ⳿ⲧϩⲉⲙⲕⲟ ⳿ⲙⲡⲁⲗⲁⲟⲥ ⲉⲧϧⲉⲛ ⲭⲏ ⲙⲓ ⲟⲩⲟϩ ⲁⲓⲥⲱⲧⲉⲙ ⳿ⲉⲡⲟⲩϥⲓ⳿ⲁϩⲟⲙ ⲁⲓ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲛⲁϩⲙⲟⲩ ϯⲛⲟⲩ ⲇⲉ ⳿ⲁⲙⲟⲩ ⳿ⲛⲧⲁⲟⲩ⳿ⲟⲣⲡⲕ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲬⲏⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ⲫⲁⲓ ⲡⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉⲧⲁⲩϫⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲙ ⲁϥⲭⲁⲕ ⳿ⲛⲁⲣⲭⲱⲛ ⲓⲉ ⲣⲉϥϯϩⲁⲡ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ ⲫⲁⲓ ⲇⲉ ⳿ⲁ Ⲫϯ ⲧⲁⲟⲩⲟϥ ⳿ⲛⲁⲣⲭⲱⲛ ⲛⲉⲙ ⲣⲉϥⲥⲱϯ ϧⲉⲛ ⳿ⲧϫⲓϫ ⳿ⲙⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲫⲏ⳿ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲓⲃⲁⲧⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ⲫⲏ⳿ⲉⲧⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲬⲏⲙⲓ ⲛⲉⲙ ⳿ⲫⲓⲟⲙ ⳿ⲛϣⲁⲣⲓ ⲛⲉⲙ ϧⲉⲛ ⲡϣⲁϥⲉ ⳿ⲛⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ⲫⲁⲓ ⲡⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉⲧⲁϥϫⲟⲥ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ϫⲉ ⳿ⲉⲣⲉ Ⲫϯ ⲧⲟⲩⲛⲟⲥ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲛⲁ ⲡⲁⲣⲏϯ ⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ⲫⲁⲓ ⲡⲉⲧⲁϥϣⲱⲡⲓ ϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ϩⲓ ⳿ⲡϣⲁϥⲉ ⲛⲉⲙ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲉⲧⲥⲁϫⲓ ⲛⲉⲙⲁϥ ϩⲓϫⲉⲛ ⳿ⲡⲧⲱⲟⲩ ⳿ⲛⲥⲓⲛⲁ ⲛⲉⲙ ⲛⲉⲛⲓⲟϯ ⲫⲁⲓ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲱⲛϧ ⳿ⲉⲧⲏⲓⲧⲟⲩ ⲛⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ⲫⲁⲓ ⳿ⲉⲧⲉ ⳿ⲙⲡⲟⲩⲟⲩⲱϣ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲛⲉⲛⲓⲟϯ ⲁⲗⲗⲁ ⲁⲩⲭⲁϥ ⲟⲩⲟϩ ⲁⲩⲕⲟⲧⲟⲩ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲬⲏⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛ⳿ⲁ⳿ⲁⲣⲱⲛ ϫⲉ ⲙⲁⲑⲁⲙⲓ⳿ⲟ ⲛⲁⲛ ⳿ⲛϩⲁⲛⲛⲟⲩϯ ⲛⲁⲓ ⲉⲑⲛⲁⲥⲱⲕ ϧⲁϫⲱⲛ ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉⲧⲁϥ⳿ⲉⲛⲧⲉⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲬⲏⲙⲓ ⳿ⲛⲧⲉⲛⲥⲱⲟⲩⲛ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ⲟⲩⲟϩ ⲁⲩⲑⲁⲙⲓ⳿ⲟ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲙⲁⲥⲓ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲙⲡⲓ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩⲟϩ ⲁⲩⲟⲩⲛⲟϥ ϧⲉⲛ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲛⲟⲩϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ⲁϥⲕⲟⲧⲟⲩ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲉϣⲉⲙϣⲓ ⳿ⲛϯ ⳿ⲥⲧⲣⲁⲧⲓ⳿ⲁ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲓ ⳿ⲡϫⲱⲙ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲉ ⲙⲏ ϩⲁⲛϧⲟⲗϧⲉⲗ ⲛⲉⲙ ϩⲁⲛϣⲟⲩϣⲱⲟⲩϣⲓ ⳿ⲁⲣⲉⲧⲉⲛ⳿ⲉⲛⲟⲩ ⲛⲏⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ϩⲓ ⳿ⲡϣⲁϥⲉ ⳿ⲛⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ⲟⲩⲟϩ ⲁⲧⲉⲧⲉⲛϭⲓ ⳿ⲛϯ⳿ⲥⲕⲩⲛⲏ⳿ⲛⲧⲉ ⲙⲟⲗⲟⲭ ⲛⲉⲙ ⲡⲓⲥⲓⲟⲩ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲛⲟⲩϯ ⲣⲏⲫⲁⲛ ⲛⲓⲧⲩⲡⲟⲥ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲑⲁⲙⲓⲱⲟⲩ ⳿ⲉⲟⲩⲱϣⲧ ⳿ⲙⲙⲱⲟⲩ ⲉⲓ⳿ⲉⲟⲩ⳿ⲉⲧⲉⲃ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲛⲓⲥⲁ ⳿ⲛⲧⲉ ⲃⲁⲃⲩⲗⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ϯ⳿ⲥⲕⲩⲛⲏ⳿ⲛⲧⲉ ϯⲙⲉⲧⲙⲉⲑⲣⲉ ⲑⲏ⳿ⲉⲛⲁⲥ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ϩⲓ ⳿ⲡϣⲁϥⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛϫⲉ ⲫⲏⲉⲧⲥⲁϫⲓ ⲛⲉⲙ Ⲙⲱ⳿ⲩⲥⲏⲥ ⳿ⲉⲑⲁⲙⲓⲟⲥ ⲕⲁⲧⲁ ⲡⲓⲧⲩⲡⲟⲥ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ⲑⲁⲓ ⳿ⲉⲧⲁⲩⲟⲗⲥ ⳿ⲉϧⲟⲩⲛ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲁⲩϣⲟⲡⲥ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲉⲛⲓⲟϯ ⲛⲉⲙ ⲓⲏⲥⲟⲩ ϧⲉⲛ ⲡⲓⲁⲙⲁϩⲓ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲛⲏ⳿ⲉⲧⲁ Ⲫϯ ϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙ⳿ⲡϩⲟ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ϣⲁ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ Ⲇⲁⲩⲓⲇ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ⲫⲏ⳿ⲉⲧⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲪϯ ⲁϥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲉⲑⲁⲙⲓⲟ ⳿ⲛⲟⲩⲙⲁ ⳿ⲛϣⲱⲡⲓ ⳿ⲙⲪϯ ⳿ⲛⲒⲁⲕⲱⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ⲥⲟⲗⲟⲙⲱⲛ ⲇⲉ ⲁϥⲕⲉⲧ ⲟⲩⲏⲓ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ⲁⲗⲗⲁ ⲛⲁⲣⲉ ⲡⲉⲧϭⲟⲥⲓ ϣⲟⲡ ⲁⲛ ϧⲉⲛ ϩⲁⲛⲙⲟⲩⲛⲕ ⳿ⲛϫⲓϫ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲱ ⳿ⲙⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ϫⲉ ⳿ⲧⲫⲉ ⲡⲉ ⲡⲁⲑⲣⲟⲛⲟⲥ ⳿ⲡⲕⲁϩⲓ ⲇⲉ ⲡⲉ ⳿ⲫⲙⲁ ⳿ⲛⲥⲉⲙⲛⲓ ⳿ⲛⲧⲉ ⲛⲁϭⲁⲗⲁⲩϫ ⲁϣ ⳿ⲛⲏⲓ ⲫⲏ⳿ⲉⲧⲉⲧⲉⲛⲛⲁⲕⲟⲧϥ ⲛⲏⲓ ⲡⲉϫⲉ Ⲡ⳪ ⲓⲉ ⲁϣ ⲡⲉ ⳿ⲫⲙⲁ ⳿ⲛⲧⲉ ⲡⲁⲙⲁ ⳿ⲛⲉⲙⲧⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ⲙⲏⲧⲁϫⲓϫ ⲁⲛ ⲁⲥⲑⲁⲙⲓ⳿ⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ⲛⲓⲛⲁϣϯ ⲛⲁϩⲃⲓ ⲟⲩⲟϩ ⳿ⲛⲁⲧⲥⲉⲃⲓ ϧⲉⲛ ⲡⲟⲩⲕⲉϩⲏⲧ ⲛⲉⲙ ⲛⲟⲩⲕⲉⲙⲁϣϫ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲧⲉⲧⲉⲛϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲉⲧⲉⲛⲕⲉⲓⲟϯ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ⲛⲓⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉⲧⲉ ⳿ⲙⲡⲉ ⲛⲉⲧⲉⲛⲓⲟϯ ϭⲟϫⲓ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲁⲩϧⲱⲧⲉⲃ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩⲉⲣϣⲟⲣⲡ ⳿ⲛϩⲓⲱⲓϣ ⳿ⲙ⳿ⲡϫⲓⲛ⳿Ⲓ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲑⲙⲏⲓ ⲫⲁⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲧⲏⲓϥ ⲟⲩⲟϩ ⳿ⲁⲣⲉⲧⲉⲛϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲁⲣⲉⲧⲉⲛϭⲓ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉϩⲁⲛⲑⲱϣ ⳿ⲛⲁⲅⲅⲉⲗⲟⲥ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ⲛⲁⲓ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲟⲑⲙⲟⲩ ⲛⲁⲩϣⲟⲡϣⲉⲡ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲟⲩⲟϩ ⲛⲁⲩ⳿ϧⲣⲁϫⲣⲉϫ ⳿ⲛⲛⲟⲩⲛⲁϫϩⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⲇⲉ ⲉϥⲙⲉϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ ⳿ⲫⲛⲁϩϯ ⲁϥⲥⲟⲙⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲡ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲟⲩⲟϩ Ⲓⲏ̅ⲥ̅ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ϯⲛⲁⲩ ⳿ⲉⲛⲓⲫⲏⲟⲩ⳿ⲓ ⲉⲩⲟⲩⲏⲛ ⲟⲩⲟϩ Ⲡ̇ϣⲏⲣⲓ ⳿ⲙⲪ̇ⲣⲱⲙⲓ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲁⲩ⳿ⲁⲙⲁϩⲓ ⳿ⲛⲛⲟⲩⲙⲁϣϫ ⲟⲩⲟϩ ⲁⲩϭⲟϫⲓ ⲉⲩⲥⲟⲡ ⲧⲏⲣⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ⲁⲩϩⲓⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲃⲁⲕⲓ ⲁⲩϩⲓ⳿ⲱⲛⲓ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ⲛⲓⲙⲉⲑⲣⲉⲩ ⲁⲩⲭⲱ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ϧⲁⲣⲁⲧϥ ⳿ⲛⲟⲩϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲥⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ⲟⲩⲟϩ ⲁⲩϩⲓ⳿ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⲉϥϯϩⲟ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ ϣⲉⲡ ⲡⲁⲡ͞ⲛⲁ̅ ⳿ⲉⲣⲟⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ϫⲉ Ⲡ⳪ ⳿ⲛⲛⲉⲕⲉⲡ ⲡⲁⲓⲛⲟⲃⲓ ⳿ⲉⲣⲱⲟⲩ ⲫⲁⲓ ⲇⲉ ⳿ⲉⲧⲁϥϫⲟϥ ⲁϥⲉⲛⲕⲟⲧ . ");
INSERT INTO copcnt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⲛⲁϥϯⲙⲁϯ ⲡⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥϧⲱⲧⲉⲃ ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲇⲓⲱⲅⲙⲟⲥ ⳿ⲉϫⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲉⲧϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲁⲩⲥⲱⲣ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⳿ⲉⲛⲓⲭⲱⲣⲁ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ⳿ⲧⲥⲁⲘⲁⲣⲓ⳿ⲁ ϣⲁⲧⲉⲛ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ⲁⲩ⳿ⲱⲗⲓ ⲇⲉ ⳿ⲛ⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲣⲉϥⲉⲣϩⲟϯ ⲟⲩⲟϩ ⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲛⲉϩⲡⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⲛⲁϥϯ ⲟⲩⲃⲉ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲉϥⲛⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓⲏⲓ ⲉϥⲱϣϯ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ ⲉϥϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ⲡϣⲧⲉⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ⲛⲏⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲥⲱⲣ ⳿ⲉⲃⲟⲗ ⲛⲁⲩⲥⲓⲛⲓ ⲡⲉ ⲉⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲇⲉ ⳿ⲉⲧⲁϥⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲟⲩⲡⲟⲗⲓⲥ ⳿ⲛⲧⲉ ⳿ⲧⲤⲁⲙⲁⲣⲓ⳿ⲁ ⲁϥϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲉⲩⲥⲟⲡ ⳿ⲉⲛⲏ⳿ⲉⲛⲁⲣⲉ Ⲫⲓⲗⲓⲡⲡⲟⲥ ϫⲱ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲟⲩⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲛⲁⲩ ⳿ⲉⲛⲓⲙⲏⲓⲛⲓ ⳿ⲉⲛⲁϥ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏ⳿ⲉⲧⲉ ⲛⲓⲡ͞ⲛⲁ̅ ⳿ⲛ⳿⳿ⲁⲕⲁⲑⲁⲣⲧⲟⲛ ⲛⲉⲙⲱⲟⲩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧⲟⲩ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ϩⲁⲛⲕⲉⲙⲏϣ ⲇⲉ ⲉⲩϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ϩⲁⲛⲟⲩⲟⲛ ⲉⲩⲟⲓ ⳿ⲛϭⲁⲗⲉ ⲛⲁϥⲧⲁⲗϭⲟ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲁϣⲓ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ Ⲥⲓⲙⲱⲛ ⲛⲁϥϣⲟⲡ ⳿ⲛϣⲟⲣⲡ ⲡⲉ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉϥⲟⲓ ⳿ⲛⲁⲭⲱ ⲉϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓ⳿ϣⲗⲱⲗ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ⳿ⲧⲤⲁⲙⲁⲣⲓ⳿ⲁ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲛⲓϣϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ⲫⲁⲓ ⲇⲉ ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲛⲁϥ ⲧⲏⲣⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲕⲟⲩϫⲓ ⲛⲉⲙ ⲛⲓⲛⲓϣϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲑⲁⲓ ⲧⲉ ϯϫⲟⲙ ⳿ⲛⲧⲉ Ⲫϯ ⲑⲏ⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ϯⲛⲓϣϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ⲛⲁⲩϯ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲛⲁϥ ⲧⲏⲣⲟⲩ ⲡⲉ ϫⲉ ⲛⲉⲁϥⲉⲣ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲡⲉ ⲉϥⲉⲣϩⲁⲗ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ⲛⲉϥⲙⲉⲧϩⲓⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ϩⲟⲧⲉ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲉⲪⲓⲗⲓⲡⲡⲟⲥ ⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲟⲩ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲛⲉⲙ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲛⲁⲩⲛⲏⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⲛⲉⲙ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ ⲉⲩϭⲓⲱⲙⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ⲥⲓⲙⲱⲛ ⲇⲉ ϩⲱϥ ⳿ⲉⲧⲁϥⲛⲁϩϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲓⲱⲙⲥ ⲛⲁϥⲙⲏⲛ ⳿ⲉⲪⲓⲗⲓⲡⲡⲟⲥ ⲉϥⲛⲁⲩ ⳿ⲉⲛⲓⲙⲏⲓⲛⲓ ⲛⲉⲙ ⲛⲓⲛⲓϣϯ ⳿ⲛϫⲟⲙ ⲉⲩϣⲟⲡ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⲛⲁϥⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣⲓ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲉⲧϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ϫⲉ ⳿ⲁ ϯⲕⲉⲥⲁⲘⲁⲣⲓ⳿ⲁ ϣⲉⲡ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲣⲟⲥ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲛⲉⲙ Ⲓⲱⲁⲛⲛⲏⲥ ϣⲁⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ⲛⲁⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲙⲁⲩ ⲛⲁⲩⲧⲱⲃϩ ⳿ⲡⲉϫⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ⲛⲉ⳿ⲙⲡⲁⲧⲉϥ⳿ⲓ ⲅⲁⲣ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⳿ⲙⲙⲱⲟⲩ ⲙⲁⲗⲗⲟⲛ ⲇⲉ ⲛⲁⲩϭⲓⲱⲙⲥ ⲡⲉ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ⲧⲟⲧⲉ ⲁⲩⲭⲁϫⲓϫ ⳿ⲡⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁⲩ ϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ Ⲥⲓⲙⲱⲛ ϫⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓⲭⲁϫⲓϫ ⳿ⲛⲧⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲥⲉϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲁϥ⳿ⲓⲛⲓ ⲛⲱⲟⲩ ⳿ⲛϩⲁⲛ⳿ⲭⲣⲏⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁ ⲡⲁⲓⲉⲣϣⲓϣⲓ ⲛⲏⲓ ϩⲱ ϩⲓⲛⲁ ⲫⲏ⳿ⲉϯⲛⲁⲭⲁϫⲓϫ ⳿ⲉϫⲱϥ ⳿ⲛⲧⲉϥϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲡⲉⲕϩⲁⲧ ⲛⲉⲙⲁⲕ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ ϫⲉ ϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲛⲧⲉ Ⲫϯ ⲁⲕⲙⲉⲩⲓ ⳿ⲉ⳿ϫⲫⲟⲥ ⲛⲁⲕ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϩⲁⲛ⳿ⲭⲣⲏⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","⳿ⲛⲛⲉ ⲧⲟⲓ ϣⲱⲡⲓ ⲛⲁⲕ ⲟⲩⲇⲉ ⳿ⲕⲗⲏⲣⲟⲥ ϧⲉⲛ ⲡⲁⲓⲥⲁϫⲓ ⲡⲉⲕϩⲏⲧ ⲅⲁⲣ ⲥⲟⲩⲧⲱⲛ ⲁⲛ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⲙⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","⳿ⲁⲣⲓⲙⲉⲧⲁⲛⲟⲓⲛ ⲟⲩⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲉⲕⲕⲁⲕⲓⲁ ⲑⲁⲓ ⲟⲩⲟϩ ⲧⲱⲃϩ ⳿ⲙⲠ⳪ ⲁⲣⲏⲟⲩ ⲥⲉⲛⲁⲭⲁ ⲡⲁⲓⲙⲉⲩⲓ ⳿ⲛⲧⲉ ⲡⲉⲕϩⲏⲧ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ϯⲛⲁⲩ ⳿ⲉⲣⲟⲕ ϧⲉⲛ ⲟⲩⲭⲟⲗⲏ⳿ⲛⲧⲉ ⲟⲩ⳿ⲛϣⲁϣⲓ ⲛⲉⲙ ⲟⲩ⳿ⲥⲛⲁⲩϩ ⳿ⲛⲧⲉ ⳿ⲧ⳿ⲁⲇⲓⲕⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲥⲓⲙⲱⲛ ⲡⲉϫⲁϥ ϫⲉ ⲧⲱⲃϩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁ Ⲡ⳪ ϩⲓⲛⲁ ϫⲉ ⳿ⲛⲛⲉ ⳿ϩⲗⲓ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲣⲉⲧⲉⲛϫⲟⲧⲟⲩ ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲉⲣⲙⲉⲑⲣⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲙⲏϣ ⳿ⲛϯⲙⲓ ⳿ⲛⲧⲉ ⲛⲓⲤⲁⲙⲁⲣⲓⲧⲏⲥ ⲛⲁⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲟⲩ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⲇⲉ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥⲥⲁϫⲓ ⲛⲉⲙ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲙⲙⲉⲣⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲧⲉⲕⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲅⲁⲍⲁ ⲫⲁⲓ ⲟⲩϣⲁϥⲉ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥϣⲉⲛⲁϥ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲉⲑⲱϣ ⳿ⲛⲥⲓⲟⲩⲣ ⳿ⲛⲣⲉⲙ⳿ⲛϫⲟⲙ ⳿ⲛⲕⲁⲛⲇⲁⲕⲏⲥ ⳿ⲛⲧⲉ ϯⲟⲩⲣⲱ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲁⲩϣ ⲫⲁⲓ ⲛⲁϥⲭⲏ ϩⲓϫⲉⲛ ⲧⲉⲥⲅⲁⲍⲁ ⲧⲏⲣⲥ ⲛⲉ ⲁϥⲓ ⲡⲉ ⳿ⲉⲟⲩⲱϣⲧ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲁϥⲕⲟⲧϥ ⲇⲉ ⲡⲉ ⲉϥϩⲉⲙⲥⲓ ϩⲓ ⲡⲉϥϩⲁⲣⲙⲁ ⲟⲩⲟϩ ⲛⲁϥⲱϣ ⲡⲉ ϩⲓ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲏⲥⲁ⳿ⲏⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ⲡⲉϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲇⲉ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⲧⲟⲙⲕ ⳿ⲉⲡⲁⲓϩⲁⲣⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ⲁϥϭⲟϫⲓ ⲇⲉ ⳿ⲛϫⲉ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉϥⲱϣ ϩⲓ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲏⲥⲁ⳿ⲏⲁⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ϩⲁⲣⲁ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲕⲱϣ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲡⲱⲥ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲓ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲟⲩⲁⲓ ϭⲓⲙⲱⲓⲧ ⲛⲏⲓ ⲁϥⲧⲱⲃϩ ⲇⲉ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲁⲗⲏⲓ ⳿ⲛⲧⲉϥϩⲉⲙⲥⲓ ⲛⲉⲙⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","⳿ⲫⲙⲁ ⲇⲉ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲉⲧⲉⲛⲁϥⲱϣ ⳿ⲙⲙⲟϥ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩ⳿ⲉⲥⲱⲟⲩ ⲉⲩⲛⲁ⳿ⲉⲛϥ ⳿ⲉ⳿ⲡϧⲟⲗϧⲉⲗ ⲟⲩⲟϩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩϩⲓⲏⲃ ⳿ⲛⲁⲧ⳿ϧⲣⲱⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫⲏⲉⲧϧⲱⲕ ⳿ⲙⲙⲟϥ ⲡⲁⲓⲣⲏϯ ⳿ⲛ⳿ϥⲟⲩⲱⲛ ⳿ⲛⲣⲱϥ ⲁⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥϩⲁⲡ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲉϥⲑⲉⲃⲓ⳿ⲟ ⲧⲉϥⲅ⳿ⲉⲛⲉ⳿ⲁ ⲇⲉ ⲛⲓⲙ ⲡⲉⲑⲛⲁ⳿ϣⲥⲁϫⲓ ⳿ⲉⲣⲟⲥ ϫⲉ ⲥⲉⲛⲁ⳿ⲱⲗⲓ ⳿ⲙⲡⲉϥⲱⲛϧ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲥⲓⲟⲩⲣ ⲡⲉϫⲁϥ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ϫⲉ ϯϯϩⲟ ⳿ⲉⲣⲟⲕ ⲙⲁⲧⲁⲙⲟⲓ ϫⲉ ⳿ⲉⲣⲉ ⲡⲁⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲱ ⳿ⲙⲫⲁⲓ ⲉⲑⲃⲉ ⲛⲓⲙ ⲉⲑⲃⲏⲧϥ ϣⲁⲛ ⲉⲑⲃⲉ ⲕⲉⲟⲩⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ⲁϥⲟⲩⲱⲛ ⲇⲉ ⳿ⲛⲣⲱϥ ⳿ⲛϫⲉ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲁϥ ⳿ⲛⲒⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲁⲓ⳿ⲅⲣⲁⲫⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ϩⲱⲥ ⲇⲉ ⲉⲩⲙⲟϣⲓ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲁⲩ⳿ⲓ ϩⲓϫⲉⲛ ⲟⲩⲙⲱⲟⲩ ⲡⲉϫⲉ ⲡⲓⲥⲓⲟⲩⲣ ϫⲉ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲙⲱⲟⲩ ⲟⲩ ⲡⲉ ⲉⲧⲧⲁϩⲛⲟ ⳿ⲙⲙⲟⲓ ⳿ⲉϭⲓⲱⲙⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲧⲁϩⲛⲟ ⳿ⲙⲡⲓϩⲁⲣⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲡⲓⲙⲱⲟⲩ ⳿ⲙ⳿ⲡⲃ̅ ⳿ⲛϫⲉ Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲛⲉⲙ ⲡⲓⲥⲓⲟⲩⲣ ⲟⲩⲟϩ ⲁϥ ϯⲱⲙⲥ ⲛⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲱⲟⲩ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥϩⲱⲗⲉⲙ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ⲟⲩⲟϩ ⳿ⲙⲡⲉϥϫⲉⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲥⲓⲟⲩⲣ ⲛⲁϥⲙⲟϣⲓ ⲅⲁⲣ ϩⲓ ⲡⲉϥⲙⲱⲓⲧ ⲉϥⲣⲁϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ⲫⲓⲗⲓⲡⲡⲟⲥ ⲇⲉ ⲁⲩϫⲉⲙϥ ϧⲉⲛ ⲁⲍⲱⲧⲟⲥ ⲛⲁϥⲕⲱϯ ⲡⲉ ⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ϧⲉⲛ ⲛⲓⲡⲟⲗⲓⲥ ⲧⲏⲣⲟⲩ ϣⲁⲧⲉϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲧⲓ ⲉϥⲙⲉϩ ⳿ⲛϫⲱⲛⲧ ⲛⲉⲙ ϧⲱⲧⲉⲃ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥ⳿ⲓ ϣⲁ ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ⲁϥⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲛϩⲁⲛ⳿ⲉⲡⲓⲥⲧⲟⲗⲏ⳿ⲛⲧⲟⲧϥ ⳿ⲉⲇⲁⲙⲁⲥⲕⲟⲥ ϣⲁ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ϩⲓⲛⲁ ⲛⲏ⳿ⲉⲧⲉϥⲛⲁϫⲉⲙⲟⲩ ⳿ⲉⲛⲁ ⲡⲓⲙⲱⲓⲧ ⲛⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲙ ⲛⲓϩⲓ⳿ⲟⲙⲓ ⳿ⲛⲧⲉϥⲥⲟⲛϩⲟⲩ ⳿ⲛⲧⲉϥ⳿ⲉⲛⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","⳿ⲉⲧⲁϥⲙⲟϣⲓ ⲇⲉ ⲁⲥϣⲱⲡⲓ ⳿ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲉⲇⲁⲙⲁⲥⲕⲟⲥ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱⲓⲛⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲟⲩⲟⲩⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩ⳿ⲥⲙⲏ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ϫⲉ ⲥⲁⲟⲩⲗ ⲥⲁⲟⲩⲗ ⳿ⲁϧⲟⲕ ⲉⲕϭⲟϫⲓ ⳿ⲛⲥⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ⲡⲉϫⲁϥ ⲇⲉ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ Ⲡ⳪ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿ⲛⲑⲟⲕ ⳿ⲉⲧⲉⲕϭⲟϫⲓ ⳿ⲛⲥⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ⲁⲗⲗⲁ ⲧⲱⲛⲕ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯ ⲡⲟⲗⲓⲥ ⲉⲩ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲁⲕ ⳿ⲙⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲉⲕⲁⲓϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ⲛⲓⲣⲱⲙⲓ ⲇⲉ ⳿ⲉⲛⲁⲩⲙⲟϣⲓ ⲛⲉⲙⲁϥ ⲛⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲉⲩⲧⲱⲙⲧ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲉϯ⳿ⲥⲙⲏ ⳿ⲉⲛⲁⲩⲛⲁⲩ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲥⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲛⲁⲩⲟⲩⲏⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲉϥⲃⲁⲗ ⲛⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ ⲡⲉ ⲁⲩⲁⲙⲁϩⲓ ⲇⲉ ⳿ⲛⲧⲉϥϫⲓϫ ⲁⲩⲟⲗϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲇⲁⲙⲁⲥⲕⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ⲁϥⲉⲣⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲛ⳿ϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲁⲛ ⳿ⲙⲡⲉϥⲟⲩⲱⲙ ⲟⲩⲇⲉ ⳿ⲙⲡⲉϥⲥⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ϧⲉⲛ ⲇⲁⲙⲁⲥⲕⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲛⲁⲛⲓⲁⲥ ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ⲛⲁϥ ϧⲉⲛ ⲟⲩϩⲟⲣⲁⲙⲁ ϫⲉ ⲁⲛⲁⲛⲓⲁⲥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ⲛⲁϥ ϫⲉ ⲧⲱⲛⲕ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉⲡⲓϧⲓⲣ ⳿ⲉⲧⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲡⲉⲧⲥⲟⲩⲧⲱⲛ ⲕⲱϯ ϧⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲟⲩⲒⲟⲩⲇⲁⲓ ⳿ⲛⲥⲁ ⲫⲏ⳿ⲉⲧⲉ ⲡⲉϥⲣⲁⲛ ⲡⲉ ⲥⲁⲩⲗⲟⲥ ⲡⲓⲣⲉⲙⲑⲁⲣⲥⲟⲥ ϩⲏⲡⲡⲉ ⳿ⲉⲧⲁϥⲧⲱⲃϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉⲟⲩⲣⲱⲙⲓ ϧⲉⲛ ⲟⲩϩⲟⲣⲁⲙⲁ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲛⲁⲛⲓⲁⲥ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⲁϥⲭⲁ ⲛⲉϥϫⲓϫ ϩⲓϫⲱϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲇⲉ ⳿ⲛϫⲉ ⲁⲛⲁⲛⲓⲁⲥ ϫⲉ Ⲡ⳪ ⲁⲓⲥⲱⲧⲉⲙ ⲉⲑⲃⲉ ⲡⲁⲓⲣⲱⲙⲓ ϩⲓⲧⲉⲛ ⲟⲩⲙⲏϣ ⲉⲑⲃⲉ ⲛⲓⲡⲉⲧϩⲱⲟⲩ ⲧⲏⲣⲟⲩ ⳿ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⳿ⲛⲛⲏⲉⲑⲟⲩⲁⲃ ⳿ⲛⲧⲁⲕ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ⲟⲩⲟϩ ϧⲉⲛ ⲡⲁⲓⲕⲉⲙⲁ ⲟⲛ ⲟⲩⲟⲛⲧⲉϥ ⲉⲣϣⲓϣⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲉⲥⲱⲛϩ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲧⲱⲃϩ ⳿ⲙⲡⲉⲕⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ϫⲉ ⲟⲩ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲛⲥⲱⲧⲡ ⲛⲏⲓ ⲡⲉ ⲫⲁⲓ ⲉϥⲛⲁⲧⲱⲟⲩⲛ ϧⲁ ⲡⲁⲣⲁⲛ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲛⲉⲙ ⲛⲓⲟⲩⲣⲱⲟⲩ ⲛⲉⲙ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","⳿ⲁⲛⲟⲕ ⲅⲁⲣ ϯⲛⲁⲧⲁⲙⲟϥ ⳿ⲉⲛⲓ⳿ⲙⲕⲁⲩϩ ⲧⲏⲣⲟⲩ ⳿ⲉⲧⲉϥⲛⲁϭⲓⲧⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ⲁϥϣⲉⲛⲁϥ ⲇⲉ ⳿ⲛϫⲉ ⲁⲛⲁⲛⲓⲁⲥ ⲟⲩⲟϩ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲏⲓ ⲁϥⲭⲁ ⲛⲉϥϫⲓϫ ⳿ⲉϫⲱϥ ⲡⲉϫⲁϥ ϫⲉ ⲥⲁⲟⲩⲗ ⲡⲁⲥⲟⲛ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ ⲡⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲫⲏ⳿ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲟⲕ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲧⲉⲕⲛⲏⲟⲩ ϩⲓⲱⲧϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲕⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲛⲧⲉⲕⲙⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ⲟⲩⲟϩ ⳿ⲛⲭⲱⲗⲉⲙ ⲁⲩϩⲉⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥⲃⲁⲗ ⳿ⲛϫⲉ ϩⲁⲛⲕⲏⲕⲥ ⲁϥⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲁϥϭⲓⲱⲙⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩ⳿ϧⲣⲉ ⲁϥϫⲉⲙϫⲟⲙ ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲧϧⲉⲛ ⲇⲁⲙⲁⲥⲕⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥϩⲓⲱⲓϣ ⳿ⲛⲒⲏ̅ⲥ̅ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ϫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ⲛⲁⲩⲧⲱⲙⲧ ⲇⲉ ⲧⲏⲣⲟⲩ ⲡⲉ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲥⲱⲧⲉⲙ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⲫⲁⲓ ⲁⲛ ⲡⲉ ⲫⲏ⳿ⲉⲛⲁϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲛⲏⲉⲧⲧⲱⲃϩ ⳿ⲙⲡⲁⲓⲣⲁⲛ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲡⲁⲓⲙⲁ ⳿ⲉⲡⲁⲓϩⲱⲃ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲥⲟⲛϩⲟⲩ ⳿ⲛⲧⲉϥϭⲓⲧⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ϣⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⲙⲁⲗⲗⲟⲛ ⲛⲁϥⲛⲏⲟⲩ ⳿ⲛϫⲉⲙϫⲟⲙ ⲟⲩⲟϩ ⲛⲁϥ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲧϧⲉⲛ ⲇⲁⲙⲁⲥⲕⲟⲥ ⲉϥⲧⲁⲙⲟ ⳿ⲙⲙⲱⲟⲩ ϫⲉ ⲫⲁⲓ ⲡⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲩⲉⲣⲟⲩⲥⲟϭⲛⲓ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ⲁⲩⲧⲁⲙⲉ ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲡⲟⲩⲥⲟϭⲛⲓ ⲛⲁⲩ⳿ⲁⲣⲉϩ ⲇⲉ ⳿ⲉⲛⲓⲡⲩⲗⲏ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲡⲓ⳿ⲉϫⲱⲣϩ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ⲁⲩⲟⲗϥ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛϫⲱⲣϩ ⲁⲩⲭⲁϥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲟⲩⲃⲓⲣ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓⲥⲟⲃⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲛⲁϥϭⲱⲛⲧ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲟⲙϥ ⳿ⲉⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣϩⲟϯ ϧⲁⲧⲉϥϩⲏⲧⲏⲣⲟⲩ ⲡⲉ ⳿ⲛⲥ⳿ⲉⲧⲉⲛϩⲟⲩⲧ ⳿ⲙⲙⲟϥ ⲁⲛ ϫⲉ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ⲃⲁⲣⲛⲁⲃⲁⲥ ⲇⲉ ⲁϥ⳿ⲁⲙⲁϩⲓ ⳿ⲙⲙⲟϥ ⲁϥ⳿ⲉⲛϥ ϣⲁ ⲛⲓ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ϫⲉ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⲁϥⲛⲁⲩ ⳿ⲉⲠ⳪ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ϫⲉ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⲁϥⲟⲩⲟⲛϩϥ ϧⲉⲛ ⲇⲁⲙⲁⲥⲕⲟⲥ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ⲟⲩⲟϩ ⲛⲁϥϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲡⲉ ⲉϥⲛⲁ ⳿ⲉϧⲟⲩⲛ ⲛⲉⲙ ⳿ⲉⲃⲟⲗ ⲛⲉⲙⲱⲟⲩ ⲉϥⲟⲩⲱⲛϩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ⲛⲁϥⲥⲁϫⲓ ⲇⲉ ⲡⲉ ⲛⲁϥϣⲓⲛⲓ ⳿ⲛⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲟⲩⲱϣ ⳿ⲉ⳿ⲓⲛⲓ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲉϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","⳿ⲉⲧⲁⲩ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲁⲩⲉⲛϥ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⲁⲩⲟⲩⲟⲣⲡϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲑⲁⲣⲥⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲛⲉⲙ ⳿ⲧⲤⲁⲙⲁⲣⲓ⳿ⲁ ⲛⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ⳿ⲙⲙⲁⲩ ⲉⲩⲕⲏⲧ ⲟⲩⲟϩ ⲉⲩⲙⲏⲛ ϧⲉⲛ ϯϩⲟϯ ⳿ⲛⲧⲉ Ⲡ⳪ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲛⲁⲓⲁⲓ ϧⲉⲛ ⲡⲓⲑⲱⲧ ⳿ⲛϩⲏⲧ ⳿ⲛⲧⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲣⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲁⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲧⲏⲣⲟⲩ ⲁϥ⳿ⲓ ϣⲁ ⲛⲓⲁⲅⲓⲟⲥ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲗⲩⲇⲇⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ⲁϥϫⲉⲙ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⳿ⲉⲛⲉⲁ ⳿ⲉⲁϥⲉⲣ ⲏ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲉϥ⳿ϣⲧⲏⲟⲩⲧ ϩⲓϫⲉⲛ ⲟⲩϭⲗⲟϫ ⲫⲁⲓ ⲇⲉ ⲛⲁϥϣⲏⲗ ⳿ⲉⲃⲟⲗ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲉⲛⲉⲁ ⳿ϥⲧⲁⲗϭⲟ ⳿ⲙⲙⲟⲕ ⳿ⲛϫⲉ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲧⲱⲛⲕ ⲫⲱⲣϣ ϧⲁⲣⲟⲕ ⲥⲁⲧⲟⲧϥ ⲁϥⲧⲱⲛϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲉⲣⲟϥ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲛⲏⲉⲧϣⲟⲡ ϧⲉⲛ ⲗⲩⲇⲇⲁ ⲛⲉⲙ ⲥⲁⲣⲱⲛ ⲛⲏ⳿ⲉⲧⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲓⲟⲡⲡⲏⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲧⲁⲃⲓⲑⲁ ⲑⲏ⳿ⲉⲧⲉϣⲁⲩⲟⲩⲁϩⲙⲉⲥ ⳿ⲛⲥⲉⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ϯϭⲁϩⲥⲓ ⲑⲁⲓ ⲛⲁⲥⲙⲉϩ ⳿ⲛϩⲱⲃ ⳿ⲛ⳿ⲁⲅⲁⲑⲟ⳿ ⲛⲉⲙ ⲛⲓⲙⲉⲑⲛⲁⲏⲧ ⳿ⲉⲛⲁⲥ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲥϣⲱⲛⲓ ⲁⲥⲙⲟⲩ ⳿ⲉⲧⲁⲩϫⲟⲕⲙⲉⲥ ⲇⲉ ⲁⲩⲭⲁⲥ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲥⲁ⳿ⲡϣⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ⲛⲁⲣⲉ ⲗⲩⲇⲇⲁ ⲇⲉ ⲛⲁⲥϧⲉⲛⲧ ⳿ⲉⲓⲟⲡⲡⲏⲡⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ⳿ϥ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛⲣⲱⲙⲓ ⲃ̅ ϩⲁⲣⲟϥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲉⲩⲧⲱⲃϩ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲙⲡⲉⲣϭⲛⲁⲩ ⳿ⲉ⳿ⲓ ϩⲁⲣⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥⲙⲟϣⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⲁⲩⲟⲗϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲛⲓⲙⲁ ⲉⲧⲥⲁ⳿ⲡϣⲱⲓ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲁϩⲣⲁϥ ⳿ⲛϫⲉ ⲛⲓⲭⲏⲣⲁ ⲧⲏⲣⲟⲩ ⲉⲩⲣⲓⲙⲓ ⲉⲩⲧⲁⲙⲟ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲓ⳿ϣⲑⲏⲛ ⲛⲉⲙ ⲛⲓ⳿ϩⲃⲱⲥ ⲉⲥⲑⲁⲙⲓⲟ ⳿ⲙⲙⲱⲟⲩ ⲉⲥϣⲟⲡ ⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ ϯϭⲁϩⲥⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ⲁϥϩⲓⲧⲟⲩ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲉⲧⲁϥϩⲓⲧϥ ϩⲓϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲁϥⲧⲱⲃϩ ⳿ⲉⲧⲁϥⲕⲟⲧϥ ⳿ⲉⲡⲓⲥⲱⲙⲁ ⲡⲉϫⲁϥ ϫⲉ ⲧⲁⲃⲓⲑⲁ ⲧⲱⲟⲩⲛⲓ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲁⲥⲟⲩⲱⲛ ⳿ⲛⲛⲉⲥⲃⲁⲗ ⳿ⲉⲧⲁⲥⲛⲁⲩ ⲇⲉ ⳿ⲉⲠⲉⲧⲣⲟⲥ ⲁⲥϩⲉⲙⲥⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ⲁϥϯⲧⲟⲧⲥ ⲇⲉ ⲁϥⲧⲁϩⲟⲥ ⲉⲣⲁⲧⲥ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⲇⲉ ⳿ⲉⲛⲓⲁⲅⲓⲟⲥ ⲛⲉⲙ ⲛⲓⲭⲏⲣⲁ ⲁϥⲧⲁϩⲟⲥ ⲛⲱⲟⲩ ⲉⲥⲟⲛϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ⲁ ⲡⲁⲓϩⲱⲃ ⲇⲉ ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲓⲟⲡⲡⲏⲧⲏⲣⲥ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⲁⲩⲛⲁϩϯ ⳿ⲉⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϧⲉⲛ ⲓⲟⲡⲡⲏϧⲁⲧⲉⲛ ⲟⲩⲁⲓ ϫⲉ Ⲥⲓⲙⲱⲛ ⲡⲓⲃⲁⲕϣⲁⲣ . ");
INSERT INTO copcnt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲇⲉ ϧⲉⲛ Ⲕⲉⲥⲁⲣⲓ⳿ⲁ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ⳿ⲉⲟⲩ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲡⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲥⲡⲩⲣⲁ ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ϯϩⲩⲇⲁⲗⲓⲕⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","⳿ⲉⲟⲩⲉⲩⲥⲉⲃⲏⲥ ⲡⲉ ⲉϥⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲪϯ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ ⲉϥ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲙⲙⲉⲑⲛⲁⲏⲧ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲉϥⲧⲱⲃϩ ⳿ⲙⲪϯ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ⲁϥⲛⲁⲩ ϧⲉⲛ ⲟⲩϩⲟⲣⲁⲙⲁ ϧⲉⲛ ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲫϯ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲟϥ ϧⲉⲛ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ϧ̅ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲟⲩϩⲟϯ ⲡⲉϫⲁϥ ϫⲉ ⲟⲩ ⲡⲉⲧϣⲟⲡ Ⲡ⳪ ⲡⲉϫⲁϥ ⲇⲉ ⲛⲁϥ ϫⲉ ⲛⲉⲕⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲉⲙ ⲛⲉⲕⲙⲉⲑⲛⲁⲏⲧ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲟⲩⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ϯⲛⲟⲩ ⲟⲩⲛ ⲟⲩⲱⲣⲡ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲓⲟⲡⲡⲏⲙⲁⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲟⲩⲁⲓ ϫⲉ Ⲥⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ⲫⲁⲓ ⳿ϥϫⲁⲗⲏⲟⲩⲧ ⳿ⲉⲟⲩⲁⲓ ϫⲉ Ⲥⲓⲙⲱⲛ ⲡⲓⲃⲁⲕϣⲁⲣ ⲫⲁⲓ ⳿ⲉⲧⲉ ⲡⲉϥⲏⲓ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","⳿ⲉⲧⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲉⲧⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲃⲱⲕ ⲃ̅ ⳿ⲛⲧⲁϥ ⲛⲉⲙ ⲟⲩⲙⲁⲧⲟⲓ ⳿ⲛⲉⲩⲥⲉⲃⲏⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲏⲛ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","⳿ⲉⲧⲁϥϫⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϧⲁⲧⲟⲧⲟⲩ ⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲓⲟⲡⲡⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲉⲩⲙⲟϣⲓ ϩⲓ ⲡⲓⲙⲱⲓⲧ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϧⲱⲛⲧ ⳿ⲉϯⲡⲟⲗⲓⲥ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓϫ⳿ⲉⲛⲉⲫⲱⲣ ⳿ⲉⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ⲛⲉ ⲁϥ⳿ϩⲕⲟ ⲇⲉ ⲡⲉ ⲛⲁϥⲟⲩⲱϣ ⳿ⲉⲟⲩⲱⲙ ⲉⲩⲥⲟⲃϯ ⲇⲉ ⲛⲁϥ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲧⲱⲙⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲧⲫⲉ ⲉⲥⲟⲩⲏⲛ ⲟⲩⲟϩ ⲟⲩ⳿ⲥⲕⲉⲩⲟⲥ ⲉⲩⲭⲱ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϩⲃⲱⲥ ⳿ⲛⲓⲁⲩ ⳿ⲛⲇ̅ ⳿ⲛⲁⲣⲭⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ⲉⲩⲭⲏ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⳿ⲛϫⲉ ⲛⲓ⳿ϥⲧⲉⲫⲁⲧ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓϭⲁⲧϥⲓ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ ⲛⲉⲙ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ⲟⲩⲟϩ ⲁⲥϣⲱⲡⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥⲙⲏ ϫⲉ ⲧⲱⲛⲕ ⲡⲉⲧⲣⲉ ϣⲱⲧ ⲟⲩⲟϩ ⲟⲩⲱⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲫⲱⲣ Ⲡ⳪ ϫⲉ ⳿ⲙⲡⲓⲟⲩⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲉⲛⲭⲁⲓ ⳿⳿ⲉⲛⲉϩ ⲉϥϭⲁϧⲉⲙ ⲓⲉ ⲉϥⲥⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ⲡⲁⲗⲓⲛ ⲟⲛ ⲁⲥϣⲱⲡⲓ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ϯ⳿ⲥⲙⲏ ⳿ⲙⲫⲙⲁϩⲥⲟⲡⲃ̅ ϫⲉ ⲛⲏ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲃⲱⲟⲩ ⳿ⲛⲑⲟⲕ ⲇⲉ ⳿ⲙⲡⲉⲣϭⲁϧⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ⲫⲁⲓ ⲇⲉ ⲁϥϣⲱⲡⲓ ϣⲁ ⲅ̅ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙⲡⲓ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ϩⲱⲥ ⲇⲉ ⲉϥⲙⲉⲩⲓ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ϫⲉ ⲟⲩ ⲡⲉ ⲡⲓϩⲟⲣⲁⲙⲁ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ ϩⲏⲡⲡⲉ ⲓⲥ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲁϥⲟⲩⲟⲣⲡⲟⲩ ⳿ⲛϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ⳿ⲉⲁⲩϣⲓⲛⲓ ⳿ⲛⲥⲁ ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϩⲓⲣⲉⲛ ⲡⲓⲡⲩⲗⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","⳿ⲉⲧⲁⲩⲙⲟⲩϯ ⲛⲁⲩϣⲓⲛⲓ ⲡⲉ ϫⲉ ⲁⲛ Ⲥⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ϥϫⲁⲗⲏⲟⲩⲧ ⳿ⲉⲡⲁⲓⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲉϥⲥⲟϭⲛⲓ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲉⲑⲃⲉ ⲡⲓϩⲟⲣⲁⲙⲁ ⲡⲉϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲇⲉ ⲛⲁϥ ϫⲉ ⲓⲥ ⲅ̅ ⳿ⲛⲣⲱⲙⲓ ⲥⲉⲕⲱϯ ⳿ⲛⲥⲱⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ⲁⲗⲗⲁ ⲧⲱⲛⲕ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩⲟϩ ⲙⲟϣⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲛ⳿ⲕⲟⲓ ⳿ⲛϩⲏⲧ ⲃ̅ ⲁⲛ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲉⲧⲁⲓⲟⲩⲟⲣⲡⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ϣⲁ ⲛⲓⲣⲱⲙⲓ ⲡⲉϫⲁϥ ϫⲉ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ⲡⲉⲧⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲡⲓϩⲱⲃ ⲟⲩ ⲡⲉ ⳿ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲓ ⲉⲑⲃⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⲉϥⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲪϯ ⲉⲩⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓ⳿ϣⲗⲟⲗ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲩⲧⲁⲙⲟϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⲉϥⲟⲩⲁⲃ ⳿ⲉⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱⲕ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲏⲓ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲧⲟⲧⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉϧⲟⲩⲛ ⲁϥϣⲟⲡⲟⲩ ⳿ⲉⲣⲟϥ ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥⲧⲱⲛϥ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ϩⲁⲛⲕⲉ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲓⲟⲡⲡⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲩ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ⲇⲉ ⲛⲁϥⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱⲟⲩ ⳿ⲉⲧⲁϥⲙⲟⲩϯ ⲇⲉ ⳿⳿ⲉⲛⲉϥⲥⲩⲅⲅⲉⲛⲏⲥ ⲛⲉⲙ ⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛⲁⲛⲁⲅⲕⲉⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁϥϯⲙⲁϯ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ⲁϥϩⲓⲧϥ ⳿ⲉⲡⲉⲥⲏⲧ ϧⲁⲣⲁⲧⲟⲩ ⳿ⲛⲛⲉϥϭⲁⲗⲁⲩϫ ⲁϥⲟⲩⲱϣⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ⲟⲩⲟϩ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲉⲁⲩⲑⲱⲟⲩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲃⲟϯ ⲡⲉ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲉⲧⲟⲙϥ ⲓⲉ ⳿ⲉⲙⲟϣⲓ ⲛⲉⲙ ⲟⲩ⳿ⲁⲗⲗⲟⲫⲩⲗⲟⲥ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ⳿ⲁ Ⲫϯ ⲧⲁⲙⲟⲓ ⳿ⲉ⳿ϣⲧⲉⲙϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛⲣⲱⲙⲓ ϫⲉ ⳿ϥϭⲁϧⲉⲙ ⲓⲉ ⳿ϥⲥⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓ⳿ⲓ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱⲓ ⳿ⲙⲡⲓⲉⲣⲁⲛⲧⲓⲗⲉⲅⲓⲛ ϯϣⲓⲛⲓ ⲟⲩⲛ ϫⲉ ⲉⲑⲃⲉ ⲁϣ ⳿ⲛϩⲱⲃ ⲁⲧⲉⲧⲉⲛⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲟⲥ ϫⲉ ⲓⲥ ⳿ϥⲧⲟⲩ ⳿ⲫⲟⲟⲩ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲧⲁⲓⲟⲩⲛⲟⲩ ⲛⲁⲓ ⲧⲱⲃϩ ⳿ⲙ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡ ϧ̅ϯ ϧⲉⲛ ⲡⲁⲏⲓ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲣⲱⲙⲓ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲙⲡⲁ⳿ⲙⲑⲟ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩϩⲉⲃⲥⲱ ⲉⲥⲟⲩⲟⲃϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲕⲟⲣⲛⲏⲗⲓⲉ ⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲧⲉⲕⲡⲣⲟⲥⲉⲩⲭⲏ ⲟⲩⲟϩ ⲛⲉⲕⲙⲉⲑⲛⲁⲏⲧ ⲁⲩⲉⲣⲡⲟⲩⲙⲉⲩⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ⲟⲩⲱⲣⲡ ⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲓⲟⲡⲡⲏⲙⲁⲣⲟⲩⲙⲟⲩϯ ⳿ⲉⲤⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲫⲁⲓ ⳿ϥϫⲁⲗⲏⲟⲩⲧ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲤⲓⲙⲱⲛ ⲡⲓⲃⲁⲕϣⲁⲣ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","⳿ⲛϯⲛⲟⲩ ⲟⲩⲛ ⲁⲓⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱⲕ ⲛⲑⲟⲕ ⲇⲉ ⲕⲁⲗⲱⲥ ⲁⲕⲁⲓⲥ ⳿ⲉⲧⲁⲕ⳿ⲓ ϯⲛⲟⲩ ⳿ⲁⲛⲟⲛ ⲧⲏⲣⲉⲛ ⲧⲉⲛ⳿ⲙⲡⲁⲓⲙⲁ ⲉⲛⲭⲏ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲪϯ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲛⲏⲧⲏⲣⲟⲩ ⳿ⲉⲧⲁ Ⲡ⳪ ⲑⲁϣⲟⲩ ⲛⲁⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","⳿ⲉⲧⲁϥⲟⲩⲱⲛ ⲇⲉ ⳿ⲛⲣⲱϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ϫⲉ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ϯⲛⲁⲩ ϫⲉ ⲟⲩⲣⲉϥϭⲓϩⲟ ⲁⲛ ⲡⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ⲁⲗⲗⲁ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⳿ϣⲗⲱⲗ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉⲣϩⲟϯ ϧⲁⲧⲉϥϩⲏⲟⲩⲟϩ ⳿ⲉⲧⲉⲣϩⲱⲃ ⳿ⲉϯⲙⲉⲑⲙⲏⲓ ⳿ϥϣⲏⲡ ⲛⲁϩⲣⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ⲁϥⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉϥⲥⲁϫⲓ ⳿ⲛⲛⲉⲛϣⲏⲣⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲫⲁⲓ ⲡⲉ Ⲡ⳪ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲧⲏⲣⲥ ⳿ⲉⲁϥⲉⲣϩⲏⲧⲥ ⲓⲥϫⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲱⲙⲥ ⳿ⲉⲧⲁϥϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ⲓⲏ̅ⲥ̅ ⲡⲓⲣⲉⲙⲚⲁⲍⲁⲣⲉⲑ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥⲑⲁϩⲥϥ ⳿ⲛϫⲉ Ⲫϯ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⲛⲉⲙ ⲟⲩϫⲟⲙ ⲫⲁⲓ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲉⲣⲡⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲉϥⲧⲁⲗϭⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁ ⲡⲓⲇⲓⲁⲃⲟⲗⲟⲥ ϫⲉⲙϫⲟⲙ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ϫⲉ ⲛⲁⲣⲉ Ⲫϯ ⲭⲏ ⲛⲉⲙⲁϥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⲧⲉⲛⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁϥⲁⲓⲧⲟⲩ ϧⲉⲛ ⳿ⲧⲭⲱⲣⲁ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲫⲏ⳿ⲉⲧⲁⲩϧⲟⲑⲃⲉϥ ⲟⲩⲟϩ ⲁⲩⲁϣϥ ⳿ⲉϫⲉⲛ ⲟⲩϣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ⲫⲁⲓ ⳿ⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲁϩⲅ̅ ⲟⲩⲟϩ ⲁϥⲧⲏⲓϥ ⲉⲑⲣⲉϥⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","⳿ⲙⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲛⲛⲓⲙⲉⲑⲣⲉⲩ ⲛⲏ⳿ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲟⲧⲡⲟⲩ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲉⲧⲉ ⳿ⲁⲛⲟⲛ ⲡⲉ ϧⲁ ⲛⲏⲉⲧⲁⲛⲟⲩⲱⲙ ⲟⲩⲟϩ ⲁⲛⲥⲱ ⲛⲉⲙⲁϥ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ⲟⲩⲟϩ ⲁϥϩⲟⲛϩⲉⲛ ⲛⲁⲛ ⳿ⲉϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲉⲧⲁ Ⲫϯ ⲑⲁϣϥ ⳿ⲛⲣⲉϥϯϩⲁⲡ ⳿ⲉⲛⲏⲉⲧⲟⲛϧ ⲛⲉⲙ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ⲫⲁⲓ ⳿ⲉⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ ⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟϥ ⲉⲑⲣⲟⲩϭⲓ ⳿ⲙ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲟⲩⲛⲟⲃⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲉϥⲣⲁⲛ ⳿ⲛϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ⲉⲧⲓ ⲉϥⲥⲁϫⲓ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲛⲛⲁⲓⲥⲁϫⲓ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ⲟⲩⲟϩ ⲁⲩⲧⲱⲙⲧ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲥⲉⲃⲓ ⲛⲓⲡⲓⲥⲧⲟⲥ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲛⲉⲙ Ⲡⲉⲧⲣⲟⲥ ϫⲉ ⳿ⲁ ϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲛⲧⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲁⲥⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲕⲉⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ⲛⲁⲩⲥⲱⲧⲉⲙ ⲅⲁⲣ ⳿ⲉⲣⲱⲟⲩ ⲡⲉ ⲉⲩⲥⲁϫⲓ ϧⲉⲛ ϩⲁⲛⲗⲁⲥ ⲟⲩⲟϩ ⲉⲩϭⲓⲥⲓ ⳿ⲙⲪϯ ⲧⲟⲧⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ϫⲉ ⲙⲏ ⲧⲓ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⲧⲁϩⲛⲟ ⳿ⲙⲡⲓⲙⲱⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲑⲣⲉ ⲛⲁⲓ ϭⲓⲱⲙⲥ ⲛⲁⲓ ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙⲡⲉⲛⲣⲏϯ ϩⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲇⲉ ⲛⲱⲟⲩ ⲉⲑⲣⲟⲩⲟⲙⲥⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲧⲟⲧⲉ ⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ ⲉⲑⲣⲉϥϣⲱⲡⲓ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛϩⲁⲛ⳿ⲉϩⲟⲟⲩ . ");
INSERT INTO copcnt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲉⲧϣⲟⲡ ϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ ϫⲉ ⳿ⲁ ⲛⲓⲉⲑⲛⲟⲥ ϣⲉⲡ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ϩⲟⲧⲉ ⳿ⲉⲧⲁϥϣⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲩϭⲓϩⲁⲡ ⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡⲥⲉⲃⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲕϣⲉ ⳿ⲉϧⲟⲩⲛ ϣⲁ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲁⲧⲥⲉⲃⲓ ⲟⲩⲟϩ ⲁⲕⲟⲩⲱⲙ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","⳿ⲉⲧⲁϥⲉⲣϩⲏⲧⲥ ⲇⲉ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","⳿ⲁⲛⲟⲕ ⲛⲁⲓϧⲉⲛ ⲓⲟⲡⲡⲏϯⲡⲟⲗⲓⲥ ⲉⲓⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲟⲩⲟϩ ⲁⲓⲛⲁⲩ ϧⲉⲛ ⲟⲩⲧⲱⲙⲧ ⳿ⲉⲟⲩϩⲟⲣⲁⲙⲁ ⲉϥⲛⲏⲟⲩ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲟⲩ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϩⲃⲱⲥ ⳿ⲛⲓⲁⲩ ⲉⲩⲭⲱ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲛⲇ̅ ⳿ⲛⲁⲣⲭⲏ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ϣⲁⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ⲫⲁⲓ ⳿ⲉⲧⲁⲓⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⲛⲁⲓϯ ⳿ⲛ⳿ϩⲑⲏⲓ ⲡⲉ ⲟⲩⲟϩ ⲁⲓⲛⲁⲩ ⳿ⲉⲛⲓⲧⲉⲃⲛⲱⲟⲩ⳿ⲓ ⳿ⲛⲧⲉ ⳿ⲡⲕⲁϩⲓ ⲛⲉⲙ ⲛⲓⲑⲏⲣⲓⲟⲛ ⲛⲉⲙ ⲛⲓϭⲁⲧϥⲓ ⲛⲉⲙ ⲛⲓϩⲁⲗⲁϯ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ⲁⲓⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲕⲉ⳿ⲥⲙⲏ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⲡⲉⲧⲣⲉ ϣⲱⲧ ⲟⲩⲟϩ ⲟⲩⲱⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ⲡⲉϫⲏⲓ ⲇⲉ ⳿ⲙⲫⲱⲣ Ⲡ⳪ ϫⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲛⲉⲛⲭⲁⲓ ⲉϥϭⲁϧⲉⲙ ⲓⲉ ⲉϥⲥⲟϥ ϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲓ ⳿⳿ⲉⲛⲉϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ⲁⲥⲉⲣⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ϯ⳿ⲥⲙⲏ ⳿ⲙ⳿ⲫⲙⲁϩⲥⲟⲡ ⲃ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲏ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲃⲱⲟⲩ ⳿ⲛⲑⲟⲕ ⳿ⲙⲡⲉⲣ ϭⲁϧⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ⲫⲁⲓ ⲇⲉ ⲁϥϣⲱⲡⲓ ϣⲁ ⲅ̅ ⳿ⲛⲥⲟⲡ ⲟⲩⲟϩ ⲁⲩϥⲓ ⲟⲛ ⳿ⲛⲕⲉⲥⲟⲡ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ϯⲟⲩⲛⲟⲩ ⲓⲥ ⲅ̅ ⳿ⲛⲣⲱⲙⲓ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϩⲓⲣⲉⲛ ⳿ⲫⲣⲟ ⳿ⲙⲡⲓⲏⲓ ⳿ⲉⲛⲁⲓⲭⲏ⳿ⲛϧⲏⲧϥ ⲉⲁⲩⲧⲁⲟⲩⲱⲟⲩ ϩⲁⲣⲟⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲕⲉⲥⲁⲣⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ⲡⲉϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲇⲉ ⲛⲏⲓ ϫⲉ ⲙⲁϣⲉⲛⲁⲕ ⲛⲉⲙⲱⲟⲩ ⳿ⲛⲕⲟⲓ ⳿ⲛϩⲏⲧ ⲃ̅ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⲁⲩ⳿ⲓ ⲇⲉ ⲛⲉⲙⲏⲓ ⳿ⲛϫⲉ ⲡⲁⲓⲕⲉ ⳿ⲛⲥⲟⲛ ⲟⲩⲟϩ ⲁⲛϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ⲁϥⲧⲁⲙⲟⲛ ⲇⲉ ⳿ⲙⲫⲣⲏϯ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲡⲓⲁⲅⲅⲉⲗⲟⲥ ϧⲉⲛ ⲡⲉϥⲏⲓ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲟⲩⲟϩ ⲉϥϫⲟⲥ ϫⲉ ⲟⲩⲱⲣⲡ ⳿ⲉⲓⲟⲡⲡⲏⲟⲩⲟϩ ⲙⲟⲩϯ ⳿ⲉⲤⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ Ⲡⲉⲧⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ⲫⲁⲓ ⲉⲑⲛⲁⲥⲁϫⲓ ⲛⲉⲙⲁⲕ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⲛⲁⲓ ⳿ⲉⲧⲉⲕⲛⲁⲛⲟϩⲉⲙ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲛⲑⲟⲕ ⲛⲉⲙ ⲡⲉⲕⲏⲓ ⲧⲏⲣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ⲉⲧⲁⲓⲉⲣϩⲏⲧⲥ ⲇⲉ ⳿ⲛⲥⲁϫⲓ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ ⳿ⲛϣⲟⲣⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ⲁⲓⲉⲣ⳿ⲫⲙⲉⲩⲓ ⲇⲉ ⳿ⲙ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲠ⳪ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲙⲉⲛ ⲁϥϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲥⲉⲛⲁ⳿ⲉⲙⲥ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ⲓⲥϫⲉ ⲟⲩⲛ ⳿ⲁ Ⲫϯ ⲁϥϯ ⲛⲱⲟⲩ ⳿ⲛϯ ϩⲩⲥⲟⲥ ⳿ⲛϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲉⲠ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲙⲡⲉⲛⲣⲏϯ ϩⲱⲛ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ ⲇⲉ ⳿ⲉⲧⲁϩⲛⲟ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲁⲩⲭⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϩⲁⲣⲁ ⳿ⲁ Ⲫϯ ⲁϥϯ ⳿ⲛϯⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⳿ⲛⲛⲓⲕⲉⲉⲑⲛⲟⲥ ⳿ⲉ⳿ⲡⲱⲛϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ⲛⲏⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲥⲱⲣ ⳿ⲉⲃⲟⲗ ⲓⲥϫⲉⲛ ⲡⲓϩⲟϫϩⲉϫ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϩⲓ ⳿ⲥⲧⲉⲫⲁⲛⲟⲥ ⲁⲩ⳿ⲓ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲫⲟⲓⲛⲓⲕⲏⲛⲉⲙ ⲕⲩⲡⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲁⲛϯⲟⲭⲓⲁ ⳿ⲛⲥⲉⲥⲁϫⲓ ⲛⲉⲙ ⳿ϩⲗⲓ ⲁⲛ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲕⲩⲡⲣⲓⲟⲥ ⲛⲉⲙ ϩⲁⲛⲔⲩⲣⲓⲛⲛⲉⲟⲥ ⲛⲁⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓⲁ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲉⲩϩⲓⲱⲓϣ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅ ⲉⲑⲃⲏⲧⲟⲩ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲙⲃⲁⲣⲛⲁⲃⲁⲥ ϣⲁ ⳿ⲧⲁⲛⲧⲓⲟⲭⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ⲟⲩⲟϩ ⲛⲁⲣⲉ ⳿ⲧϫⲓϫ ⳿ⲙⲠ⳪ ⲭⲏ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲙⲙⲏϣ ⲁⲩⲛⲁϩϯ ⲟⲩⲟϩ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ⲁ ⲡⲓⲥⲁϫⲓ ⲇⲉ ϣⲉ ϣⲁ ⲛⲉⲛⲙⲁϣϫ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲉⲧϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ⲫⲁⲓ ⳿ⲉⲧⲁϥ⳿ⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ Ⲫϯ ⲁϥⲣⲁϣⲓ ⲟⲩⲟϩ ⲛⲁϥϯⲛⲟⲙϯ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲡⲓⲑⲱⲧ ⳿ⲛϩⲏⲧ ⲉⲑⲣⲟⲩⲟϩⲓ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ϫⲉ ⲛⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛ⳿ⲁⲅⲁⲑⲟⲥ ⲡⲉ ⲉϥⲙⲉϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ ⳿ⲫⲛⲁϩϯ ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩϥ ⳿ⲛⲥⲁ Ⲡ⳪ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲑⲁⲣⲥⲟⲥ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲥⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲉⲙϥ ⲁϥ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓⲁ ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁⲩⲉⲣ ⲟⲩⲣⲟⲙⲡⲓ ⲧⲏⲣⲥ ⲉⲩⲑⲟⲩⲏⲧ ϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲁⲩϯ⳿ⲥⲃⲱ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲁⲩϯⲣⲉⲛ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲉⲧϧⲉⲛ ⳿ⲧⲁⲛⲧⲓⲟⲭⲓⲁ ⳿ⲛϣⲟⲣⲡ ϫⲉ ⲛⲓ⳿ⲭⲣⲏⲥⲧⲓ⳿ⲁⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲅⲁⲃⲟⲥ ⲁϥϯⲙⲏⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϩⲃⲱⲛ ⲉϥⲛⲁϣⲱⲡⲓ ⳿ⲉϫⲉⲛ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲧⲏⲣⲥ ⳿ⲉⲧⲉ ⲫⲏⲡⲉ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϩⲓ ⳿ⲕⲗⲁⲩⲇⲓⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲉⲛⲁⲣⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲙⲉϩ ⳿ⲙⲙⲟϥ ⲁϥⲑⲱϣ ⳿ⲛϫⲉ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲟⲩⲇⲓ⳿ⲁⲕⲱⲛⲓⲁ ⳿ⲉⲟⲩⲱⲣⲡ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲉⲧϣⲟⲡ ϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ⲫⲁⲓ ⳿ⲉⲧⲁⲩⲁⲓϥ ⳿ⲉⲟⲩⲱⲣⲡ ⳿ⲛϩⲁⲛ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲙⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲥⲁⲩⲗⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲁ Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲡⲟⲩⲣⲟ ⲁϥ⳿ⲓⲛⲓ ⳿ⲛⲧⲉϥϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲉϯ⳿ⲙⲕⲁϩ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ⲟⲩⲟϩ ⲁϥϧⲱⲧⲉⲃ ⳿ⲛⲒⲁⲕⲱⲃⲟⲥ ⳿ⲡⲥⲟⲛ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⳿ⲛ⳿ⲧⲥⲏϥⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ϫⲉ ⲡⲓϩⲱⲃ ⲣⲁⲛⲱⲟⲩ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲁϥⲟⲩⲁϩⲧⲟⲧϥ ⳿ⲉϭⲱⲡⲓ ⳿ⲙ⳿ⲡⲕⲉⲠⲉⲧⲣⲟⲥ ⲛⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲛⲉ ⳿ⲛⲧⲉ ⲛⲓⲁⲧⲕⲱⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ⲫⲁⲓ ⳿ⲉⲧⲁϥϭⲟⲡϥ ⲁϥⲭⲁϥ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⳿ⲉⲁϥⲧⲏⲓϥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲇ̅ ⳿ⲛϣⲱⲡ ⳿ⲙⲙⲁⲧⲟⲓ ⲉⲑⲣⲟⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⲉϥⲙⲉⲩⲓ ⳿ⲉ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲡⲁⲥⲭⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ⲡⲉⲧⲣⲟⲥ ⲙⲉⲛ ⲟⲩⲛ ⲛⲁⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲛⲁⲥⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲇⲉ ⲉⲑⲃⲏⲧϥ ⳿ⲉⲙⲁϣⲱ ϩⲁ Ⲫϯ ⳿ⲛϫⲉ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ϩⲟⲧⲉ ⲇⲉ ⲉϥⲛⲁ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛϫⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁϥⲉⲛⲕⲟⲧ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲟⲩⲧⲉ ⲙⲁⲧⲟⲓ ⲃ̅ ⲉϥⲙⲏⲣ ⳿ⲛϩⲁⲗⲩⲥⲓⲥ ⲃ̅ϯ ⲛⲉ ⲟⲩⲟⲛ ⳿ⲛϩⲁⲛ⳿ⲁⲣⲉϩ ⲇⲉ ϩⲓⲣⲉⲛ ⲛⲓⲣⲱⲟⲩ ⲉⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲓⲥ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥ⳿ⲓ ⲟⲩⲟϩ ⲟⲩⲟⲩⲱⲓⲛⲓ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱⲓⲛⲓ ϧⲉⲛ ⲡⲓⲏⲓ ⳿ⲉⲧⲁϥⲕⲓⲙ ⲇⲉ ⳿ⲉ⳿ⲡ⳿ⲥⲫⲓⲣ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲱⲛⲕ ⳿ⲛⲭⲱⲗⲉⲙ ⲟⲩⲟϩ ⲁⲩϩⲉⲓ ⳿ⲛϫⲉ ⲛⲓϩⲁⲗⲩⲥⲓⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲉϥϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ⲡⲉϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲇⲉ ⲛⲁϥ ϫⲉ ⲙⲟⲣⲕ ⲟⲩⲟϩ ⲙⲁ ⲡⲉⲕⲥⲩⲛⲇⲁⲗⲓⲟⲛ ⳿ⲉⲣⲁⲧⲕ ⲁϥ⳿⳿ⲓⲣⲓ ⲇⲉ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ϫⲟⲗϩⲕ ⳿ⲙⲡⲉⲕ⳿ϩⲃⲱⲥ ⲟⲩⲟϩ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲁϥⲙⲟϣⲓ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⲛⲁϥ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩⲙⲏⲓ ⲡⲉⲧⲉ ⲛⲁϥϣⲟⲡ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⲛⲁϥⲙⲉⲩⲓ ⲇⲉ ϫⲉ ⲟⲩϩⲟⲣⲁⲙⲁ ⲡⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","⳿ⲉⲧⲁⲩⲥⲓⲛⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲛ⳿ⲁⲣⲉϩ ⳿ⲛϩⲟⲩⲓⲧ ⲛⲉⲙ ⲡⲓⲙⲁϩⲃ̅ ⲁⲩ⳿ⲓ ⳿ⲉϯⲡⲩⲗⲏ⳿ⲙⲃⲉⲛⲓⲡⲓ ⲑⲏⲉⲑⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉϯⲡⲟⲗⲓⲥ ⲑⲁⲓ ⲁⲥⲟⲩⲱⲛ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲁⲧⲥ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲁⲩⲥⲉⲛ ⲟⲩⲁⲓ ⳿ⲛⲛⲓϧⲓⲣ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥϣⲉⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓⲁⲅⲅⲉⲗⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲁⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⳿ⲉⲧⲁ ⲡⲉϥϩⲏⲧ ⳿ⲓ ⳿ⲉⲣⲟϥ ⲡⲉϫⲁϥ ϫⲉ ϯⲛⲟⲩ ⲁⲓ⳿ⲉⲙⲓ ⲧⲁ⳿ⲫⲙⲏϫⲉ ⳿ⲁ Ⲡ⳪ ⲟⲩⲱⲣⲡ ⳿ⲙⲡⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲟϩ ⲁϥⲛⲁϩⲙⲉⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧϫⲓϫ ⳿ⲛⲎ̇ⲣⲱⲇⲏⲥ ⲛⲉⲙ ⳿ⲡⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ⲧⲏⲣϥ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲘⲁⲣⲓ⳿ⲁ ⳿ⲑⲙⲁⲩ ⳿ⲛⲒⲱⲁⲛⲛⲏⲥ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲙⲁⲣⲕⲟⲥ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲩⲑⲟⲩⲏⲧ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉⲩⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","⳿ⲉⲧⲁϥⲕⲱⲗϩ ⲇⲉ ϩⲓⲣⲉⲛ ⳿ⲫⲣⲟ ⳿ⲙⲡⲓⲡⲩⲗⲱⲛ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲙⲃⲱⲕⲓ ⳿ⲉⲉⲣⲟⲩⲱ ⲛⲁϥ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲣⲱⲇⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲥⲥⲟⲩⲉⲛ ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙⲠⲉⲧⲣⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲣⲁϣⲓ ⳿ⲙⲡⲉⲥⲟⲩⲱⲛ ⳿ⲙⲡⲓ⳿ϣⲑⲱⲙ ⳿ⲉⲧⲁⲥϭⲟϫⲓ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⲁⲥⲧⲁⲙⲱⲟⲩ ϫⲉ Ⲡⲉⲧⲣⲟⲥ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϩⲓⲣⲉⲛ ⲡⲓⲡⲩⲗⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁⲥ ϫⲉ ⲁⲣⲉⲗⲟⲃⲓ ⳿ⲛⲑⲟⲥ ⲇⲉ ⲛⲁⲥⲧⲁϫⲣⲟ ⳿ⲛⲧⲟⲧⲥ ⲡⲉ ϫⲉ ⲡⲁⲓⲣⲏϯ ⲡⲉⲧϣⲟⲡ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲉϥⲁⲅⲅⲉⲗⲟⲥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ⲡⲉⲧⲣⲟⲥ ⲇⲉ ⲛⲁϥⲙⲏⲛ ⲉϥⲕⲱⲗϩ ⲡⲉ ⳿ⲉⲧⲁⲩⲟⲩⲱⲛ ⲇⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲩⲧⲱⲙⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ⲁϥϭⲱⲣⲉⲙ ⲇⲉ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲧⲉϥϫⲓϫ ϫⲉ ⲭⲁⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲁϥⲥⲁϫⲓ ϧⲁⲧⲟⲧⲟⲩ ϫⲉ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⳿ⲁ Ⲡ⳪ ⳿ⲉⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲡⲉϫⲁϥ ⲇⲉ ⲛⲱⲟⲩ ϫⲉ ⲙⲁⲧⲁⲙⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲛⲁⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥϣⲉ ⳿ⲉⲕⲉⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ϣⲱⲡⲓ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁⲛ ϧⲉⲛ ⲛⲓⲙⲁⲧⲟⲓ ϫⲉ ⲟⲩ ϩⲁⲣⲁ ⲡⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲙⲠⲉⲧⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ⲏ̇ⲣⲱⲇⲏⲥ ⳿ⲉⲧⲁϥⲕⲱϯ ⳿ⲛⲥⲱϥ ⲟⲩⲟϩ ⳿ⲉⲧⲉ⳿ⲙⲡⲉϥϫⲉⲙϥ ⲁϥϯ⳿ⲙⲕⲁϩ ⳿ⲛⲛⲓⲣⲉϥ⳿ⲁⲣⲉϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉϧⲟⲑⲃⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⲁϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ⲛⲁϥϣⲟⲡ ⲇⲉ ϧⲉⲛ ⲟⲩ⳿ⲙⲃⲟⲛ ⲉϥϯ ⲟⲩⲃⲉ ⲛⲁ Ⲧⲩⲣⲟⲥ ⲛⲉⲙ ⳿ⲧⲤⲓⲇⲱⲛ ⲁⲩ⳿ⲓ ⲇⲉ ⲉⲩⲥⲟⲡ ϣⲁⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲑⲉⲧ ⳿ⲡϩⲏⲧ ⳿ⲙ⳿ⲡⲗⲁⲥⲧⲟⲥ ⲫⲏⲉⲧⲭⲏ ϩⲓϫⲉⲛ ⲡⲓⲕⲟⲓⲧⲱⲛ ⳿ⲛⲧⲉ ⳿ⲡⲟⲩⲣⲟ ⲛⲁⲩⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏⲉⲑⲃⲉ ϫⲉ ⲛⲁⲩϣⲁⲛϣ ⳿ⲛⲧⲟⲩⲭⲱⲣⲁ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲥ ⳿ⲛⲧⲉϥⲙⲉⲧⲟⲩⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⲉϥⲑⲏϣ ⳿ⲁ Ⲏ̇ⲣⲱⲇⲏⲥ ϯ ϩⲓⲱⲧϥ ⳿ⲛⲟⲩϩⲉⲃⲥⲱ ⳿ⲛⲟⲩⲣⲟ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲉⲙⲥⲓ ϩⲓϫⲉⲛ ⲡⲓⲃⲏⲙⲁ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ⲡⲓⲙⲏϣ ⲇⲉ ⲛⲁϥⲱϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲛⲛⲟⲩϯ ⲧⲉ ⲑⲁⲓ ⲟⲩⲟϩ ⲑⲁ ⲣⲱⲙⲓ ⲁⲛ ⲧⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ⲥⲁⲧⲟⲧϥ ⲇⲉ ⳿ⲁ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲁϥϣⲁⲣⲓ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ⲫⲙⲁ ϫⲉ ⳿ⲙⲡⲉϥϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣϭⲓϥⲉⲛⲧ ⲁϥⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ⲡⲓⲥⲁϫⲓ ⲇⲉ ⳿ⲛⲧⲉ Ⲫϯ ⲁϥⲁⲓⲁⲓ ⲟⲩⲟϩ ⲛⲁϥⲛⲏⲟⲩ ⳿ⲛ⳿ⲁϣⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ⲃⲁⲣⲛⲁⲃⲁⲥ ⲇⲉ ⲛⲉⲙ ⲥⲁⲩⲗⲟⲥ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛϯⲇⲓ⳿ⲁⲕⲟⲛⲓⲁ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁⲩ⳿ⲓⲛⲓ ⳿ⲙ⳿ⲡⲕⲉⲒⲱⲁⲛⲛⲏⲥ ⲫⲏ⳿ⲉⲧⲁⲩϯⲣⲉⲛϥ ϫⲉ ⲙⲁⲣⲕⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ⲛⲉ ⲟⲩⲟⲛ ϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲇⲉ ⲛⲉⲙ ϩⲁⲛⲣⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲛⲧⲉ ⳿ⲧⲁⲛ ϯⲟⲭⲓ⳿ⲁ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ Ⲥⲓⲙⲱⲛ ⲫⲏ⳿⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲛⲓⲕⲉⲣ ⲛⲉⲙ ⲗⲟⲩⲕⲓⲟⲥ ⲡⲓⲔⲩⲣⲓⲛⲛⲉⲟⲥ ⲛⲉⲙ ⲙⲁⲛⲁⲏⲡⲓ⳿ϣⲫⲏⲣ ⳿ⲛϣⲁⲛϣ ⳿ⲛⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ ⲡⲓⲧⲉⲧⲣⲁⲁⲣⲭⲏⲥ ⲛⲉⲙ ⲥⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ⲉⲩϣⲉⲙϣⲓ ⲇⲉ ⳿ⲙⲠ⳪ ⲉⲩⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲡⲉϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ϫⲉ ⲫⲱⲣϫ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲥⲁⲩⲗⲟⲥ ⳿ⲉⲡⲓϩⲱⲃ ⳿ⲉⲧⲁⲓⲑⲁϩⲙⲟⲩ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ⲧⲟⲧⲉ ⳿ⲉⲧⲁⲩⲉⲣⲛⲏⲥⲧⲉⲩⲓⲛ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲃϩ ⲁⲩⲭⲁϫⲓϫ ⳿ⲡⲉϫⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲭⲁⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲥⲉⲗⲉⲩⲕⲓ⳿ⲁ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲩⲉⲣϩⲱⲧ ⳿ⲉⲕⲩⲡⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲥⲁⲗⲁⲙⲓⲛⲏⲛⲁⲩϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲁⲣⲉ ⳿ⲡⲕⲉⲒⲱⲁⲛⲛⲏⲥ ⲇⲉ ⲛⲉⲙⲱⲟⲩ ⲉϥⲟⲓ ⳿ⲛⲣⲉϥϣⲉⲙϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","⳿ⲉⲧⲁⲩⲥⲉⲛ ϯⲛⲏⲥⲟⲥ ⲇⲉ ⲧⲏⲣⲥ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲁⲫⲟⲩ ⲁⲩϫⲓⲙⲓ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛⲁⲭⲱ ⳿ⲙⲯⲉⲇⲟ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⳿ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲃⲁⲣⲓⲏⲥⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ⲫⲁⲓ ⳿ⲉⲛⲁϥⲭⲏ ⲛⲉⲙ ⲡⲓ⳿ⲁⲛⲑⲩⲡⲁⲧⲟⲥ ⲥⲉⲣⲅⲓⲟⲥ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲕⲁⲧϩⲏ ⲧ ⲫⲁⲓ ⲇⲉ ⲁϥⲙⲟⲩϯ ⳿ⲉⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲥⲁⲩⲗⲟⲥ ⲛⲁϥⲕⲱϯ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ⲛⲁϥϯ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲩ ⳿ⲛϫⲉ ⳿ⲉⲗⲩⲙⲁⲥ ⲡⲓⲁⲭⲱ ⳿ⲉϣⲁⲩⲟⲩⲁϩⲉⲙ ⲡⲉϥⲣⲁⲛ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉϥⲕⲱϯ ⳿ⲛⲥⲁ ⲫⲉⲛϩ ⲡⲓ⳿ⲁⲛⲑⲩⲡⲁⲧⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ⲥⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲧⲉ ⲡⲁⲩⲗⲟⲥ ⲡⲉ ⳿ⲉⲧⲁϥⲙⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ⲡⲉϫⲁϥ ⳿ⲱ ⲫⲏⲉⲑⲙⲉϩ ⳿ⲛ⳿ⲭⲣⲟϥ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲡⲉⲧϩⲱⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲇⲓ⳿ⲁⲃⲟⲗⲟⲥ ⲡⲓϫⲁϫⲓ ⳿ⲛⲧⲉ ⳿ⲑⲙⲏⲓ ⲛⲓⲃⲉⲛ ⳿ⲛ⳿ⲕⲭⲱ ⳿ⲛⲧⲟⲧⲕ ⳿ⲉⲃⲟⲗ ⲁⲛ ⲉⲕⲫⲱⲛϩ ⳿ⲛⲛⲓⲙⲱⲓⲧ ⲉⲧⲥⲟⲩⲧⲱⲛ ⳿ⲛⲧⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ⲟⲩⲟϩ ϯⲛⲟⲩ ϩⲏⲡⲡⲉ ⲓⲥ ⳿ⲧϫⲓϫ ⳿ⲙⲠ⳪ ⲉⲥ⳿ⲉ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲕ ⲟⲩⲟϩ ⲉⲕ⳿ⲉϣⲱⲡⲓ ⲉⲕⲟⲓ ⳿ⲙⲃⲉⲗⲗⲉ ⳿ⲛ⳿ⲭⲛⲁⲩ ⳿ⲙ⳿ⲫⲣⲏⲁⲛ ϣⲁ ⲟⲩⲥⲏⲟⲩ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧϥ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⳿ⲛϫⲉ ⲟⲩ⳿ϩⲗⲟⲗ ⲛⲉⲙ ⲟⲩⲭⲁⲕⲓ ⲛⲁϥⲕⲱϯ ⲉϥϣⲓⲛⲓ ⳿ⲛⲥⲁ ⲫⲏⲉⲑⲛⲁϯⲧⲟⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ⲧⲟⲧⲉ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲛϫⲉ ⲡⲓ⳿ⲁⲛⲑⲩⲡⲁⲧⲟⲥ ⳿ⲉⲫⲏ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲁϥⲛⲁϩϯ ⲁϥⲉⲣ⳿ϣⲫⲏⲣⲓ ⳿ⲉϫⲉⲛ ϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲁⲫⲟⲩ ⳿ⲛϫⲉ ⲛⲁ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲡⲁⲣⲛⲁⲃⲁⲥ ⲁⲩ⳿ⲓ ⳿ⲉⲡⲉⲣⲅⲏ⳿ⲛⲧⲉ ϯⲡⲁⲙⲫⲓⲗⲓ⳿ⲁ Ⲓⲱⲁⲛⲛⲏⲥ ⲇⲉ ⲁϥⲫⲱⲣϫ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲁϥⲕⲟⲧϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲉⲣⲅⲏⲁⲩ⳿ⲓ ⳿ⲉ⳿ⲧⲁⲛϯⲟⲭⲓ⳿ⲁ ⳿ⲛⲧⲉ ϯⲡⲓⲥⲓⲇⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲩϩⲉⲙⲥⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ⲙⲉⲛⲉⲛⲥⲁ ⲡⲓⲱϣ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ϩⲁⲣⲱⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲥⲁϫⲓ ⳿ⲛⲛⲟⲙϯ ⲡⲉ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϣⲁ ⲡⲓⲗⲁⲟⲥ ⳿ⲁϫⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϭⲱⲣⲉⲙ ⳿ⲛⲧⲉϥϫⲓϫ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⲛⲓ⳿ⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲉⲣϩⲟϯ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲪϯ ⲥⲱⲧⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ⲫϯ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ Ⲡⲓ̅ⲥ̅ⲗ̅ ⲁϥⲥⲱⲧⲡ ⳿ⲛⲛⲉⲛⲓⲟϯ ⲟⲩⲟϩ ⲁϥϭⲓⲥⲓ ⳿ⲙⲡⲓⲗⲁⲟⲥ ϧⲉⲛ ϯⲡⲁⲣⲟⲓⲕⲓ⳿ⲁ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲬⲏⲙⲓ ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩϣⲱⲃϣ ⲉϥϭⲟⲥⲓ ⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ⳿ⲛⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ⲟⲩⲟϩ ⲁϥϣⲁⲛⲟⲩϣⲟⲩ ⳿ⲛⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲛⲥⲏⲟⲩ ϩⲓ ⳿ⲡϣⲁϥⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲣⲱϧⲧ ⳿ⲛⲍ̅ ⳿ⲛ⳿ϣⲗⲱⲗ ϧⲉⲛ ⳿ⲡⲕⲁϩⲓ ⳿ⲛⲭⲁⲛⲁⲁⲛ ⲁϥ⳿ⲑⲣⲟⲩⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲙⲡⲟⲩⲕⲁϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","⳿ⲛⲩ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲁϥϯ ⳿ⲛϩⲁⲛ⳿ⲕⲣⲓⲧⲏⲥ ϣⲁ ⲥ⳿ⲁⲙⲟⲩⲏⲗ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲩⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲛⲟⲩⲟⲩⲣⲟ ⲟⲩⲟϩ ⲁϥϯ ⲛⲱⲟⲩ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲛⲥⲁⲟⲩⲗ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲕⲓⲥ ⲟⲩⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲩⲗⲏ⳿ⲙⲃⲉⲛⲓ⳿ⲁⲙⲓⲛ ⳿ⲛⲙ̅ ⳿ⲛⲣⲟⲙⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲩⲟⲑⲃⲉϥ ⳿ⲉⲃⲟⲗ ⲁϥⲧⲟⲩⲛⲟⲥ Ⲇⲁⲩⲓⲇ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲣⲟ ⲫⲁⲓ ⳿ⲉⲧⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧϥ ⳿ⲉⲁϥϫⲟⲥ ϫⲉ ⲁⲓϫⲓⲙⲓ ⳿ⲛⲆⲁⲩⲓⲇ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲓⲉⲥⲥⲉ ⲟⲩⲣⲱⲙⲓ ⲕⲁⲧⲁ ⲡⲁϩⲏⲧ ⲫⲁⲓ ⲉⲑⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉϩⲛⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲡ⳿ϫⲣⲟϫ ⳿ⲙⲫⲁⲓ ⳿ⲁ Ⲫϯ ⲕⲁⲧⲁ ⲟⲩⲱϣ ⲁϥ⳿ⲓⲛⲓ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ⳿ⲛⲟⲩⲥⲱⲧⲏⲣ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","⳿ⲉⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛϩⲓⲱⲓϣ ϧⲁϫⲉⲛ ⲡⲉϥⲙⲱⲓⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲛⲟⲩⲱⲙⲥ ⳿ⲙⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⳿ⲛⲧⲉ Ⲡⲓ̅ⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ⲉⲧⲁ Ⲓⲱⲁⲛⲛⲏⲥ ⲇⲉ ϫⲱⲕ ⳿ⲙⲡⲉϥ⳿ⲇⲣⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ⲛⲁϥⲭⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲣⲉⲧⲉⲛⲙⲉⲩⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲛⲓⲙ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ϩⲏⲡⲡⲉ ⲉϥⲛⲏⲟⲩ ⲙ⳿ⲉⲛⲉⲛⲥⲱⲓ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲉ⳿ⲛϯ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ⳿ⲉϯⲟⲩ⳿ⲱ ⳿ⲙⲡⲓⲑⲱⲟⲩ⳿ⲓ ⳿ⲛⲧⲉ ⲛⲉϥϭⲁⲗⲁⲩϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⳿ⲡⲅⲉⲛⲟⲥ ⳿ⲛⲀⲃⲣⲁⲁⲙ ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲉⲣϩⲟϯ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲪϯ ⳿ⲉⲧⲁⲩⲟⲩⲱⲣⲡ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲡⲁⲓⲟⲩϫⲁⲓ ⲫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ⲛⲏⲅⲁⲣ ⲉⲧϣⲟⲡ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ⲛⲟⲩⲕⲉⲁⲣⲭⲱⲛ ⲫⲁⲓ ⲁⲩⲉⲣⲁⲧ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⲛⲉⲙ ⲛⲓⲕⲉ⳿ⲥⲙⲏ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲁⲓ ⲉⲧⲟⲩⲱϣ ⳿ⲙⲙⲱⲟⲩ ⲕⲁⲧⲁ ⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲁⲩϯϩⲁⲡ ⳿ⲉⲁⲩϫⲟⲕⲟⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ⲟⲩⲟϩ ⳿ⲉⲧⲉ⳿ⲙⲡⲟⲩϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛⲗⲱⲓϫⲓ ⳿ⲛⲧⲉ ⳿ⲫⲙⲟⲩ ⳿ⲛϧⲏⲧϥ ⲁⲩⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲙⲠⲓⲗⲁⲧⲟⲥ ⳿ⲉϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ⲉⲑⲃⲏⲧϥ ⲁⲩⲭⲁϥ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⲡⲓϣⲉ ⲁⲩⲭⲁϥ ⳿ⲛϧⲟⲩⲛ ϧⲉⲛ ⲟⲩ⳿ⲙϩⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ⲫϯ ⲇⲉ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ⲫⲁⲓ ⳿ⲉⲧⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩ⳿ⲓ ⲛⲉⲙⲁϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲄⲁⲗⲓⲗⲉ⳿ⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲛⲁⲓ ϯⲛⲟⲩ ⲉⲧⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⲛⲁϥ ϣⲁ ⲡⲓⲗⲁⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⲧⲉⲛϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲱϣ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲛⲓⲓⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ϫⲉ ⲫⲁⲓ ⳿ⲁ Ⲫϯ ϫⲟⲕϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓϣⲏⲣⲓ ⳿ⲉⲧⲁϥⲧⲟⲩⲛⲟⲥ Ⲓⲏ̅ⲥ̅ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲡⲓⲙⲁϩⲃ̅ ⳿ⲙⲯⲁⲗⲙⲟⲥ ϫⲉ ⳿ⲛⲑⲟⲕ ⲡⲉ ⲡⲁϣⲏⲣⲓ ⳿ⲁⲛⲟⲕ ⲁⲓ⳿ϫⲫⲟⲕ ⳿ⲙⲫⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ⲟⲧⲓ ⲇⲉ ϫⲉ ⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⳿ϥⲛⲁⲧⲁⲥⲑⲟ ⲁⲛ ϫⲉ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ ⲁϥϫⲟⲥ ⳿ⲙⲡⲁⲓⲣⲏϯ ϫⲉ ⲉⲓ⳿ⲉϯ ⲛⲱⲧⲉⲛ ⳿ⲛⲛⲏⲉⲑⲟⲩⲁⲃ ⳿ⲛⲧⲉ Ⲇⲁⲩⲓⲇ ⳿ⲉⲧⲉⲛϩⲟⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ⲉⲑⲃⲉ ⲫⲁⲓ ⲟⲛ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϧⲉⲛ ⲕⲉⲙⲁ ϫⲉ ⳿ⲛⲛⲉⲕϯ ⳿ⲙⲡⲉⲑⲟⲩⲁⲃ ⳿ⲛⲧⲁⲕ ⳿ⲉⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ⲇⲁⲩⲓⲇ ⲙⲉⲛ ⲅⲁⲣ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲧⲉϥⲅ⳿ⲉⲛⲉ⳿ⲁ ⲛⲁϥϣⲉⲙϣⲓ ⳿ⲙⲡⲓⲥⲟϭⲛⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲁϥⲉⲛⲕⲟⲧ ⲟⲩⲟϩ ⲁⲩⲭⲁϥ ϧⲁⲧⲉⲛ ⲛⲉϥⲓⲟϯ ⲟⲩⲟϩ ⲁϥⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ⲫⲏ ⲇⲉ ⳿ⲉⲧⲁ Ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲙⲡⲉϥⲛⲁⲩ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ⲙⲁⲣⲉ ⲡⲓϩⲱⲃ ⲟⲩⲛ ⲟⲩⲱⲛϩ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲫⲁⲓ ⲥⲉϩⲓⲱⲓϣ ⲛⲱⲧⲉⲛ ⳿ⲙ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲉⲧⲉⲛⲛⲟⲃⲓ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲏⲧⲏⲣⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲡⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲉⲑⲁⲙⲓⲟ ⳿ⲛϧⲏⲧⲟⲩ ϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ϧⲉⲛ ⲫⲁⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⲥⲉⲛⲁ⳿ⲑⲙⲁⲓⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","⳿ⲁⲛⲁⲩ ⲟⲩⲛ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲧⲉϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϫⲉ ⲫⲏ⳿ⲉⲧⲁϥϫⲟϥ ϧⲉⲛ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ϫⲉ ⳿ⲁⲛⲁⲩ ⲛⲓⲕⲁⲧⲁ⳿ⲫⲣⲟⲛⲓⲧⲏⲥ ⲟⲩⲟϩ ⳿ⲁⲣⲓ⳿ϣⲫⲏⲣⲓ ⲟⲩⲟϩ ⲙⲁⲕⲉⲧ ⲑⲏⲛⲟⲩ ϫⲉ ϯⲛⲁ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩϩⲱⲃ ϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩϩⲱⲃ ⳿ⲛⲧⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲁⲛ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ⲫ⳿⳿ⲓⲣⲓ ϧⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ⲉⲩⲛⲏⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲛⲁⲩⲉⲣ⳿ⲁⲝⲓⲟⲓⲛ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲥⲁϫⲓ ϧⲉⲛ ⲡⲓⲕⲉⲥⲁⲃⲃⲁⲧⲟⲛ ⲉⲑⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ⲉⲧⲁⲥⲃⲱⲗ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲁⲩⲙⲟϣⲓ ⳿ⲛⲥⲁ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲉⲣⲥⲉⲃⲉⲥⲑⲉ ϧⲉⲛ ⲛⲓϣⲉⲙⲙⲱⲟⲩ ⲉⲩⲑⲱⲧ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲉⲑⲣⲟⲩϣⲱⲡⲓ ϧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","⳿ⲛ⳿ϧⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲕⲉⲥⲁⲃⲃⲁⲧⲟⲛ ⲉⲑⲛⲏⲟⲩ ⳿ⲥⲭⲉⲇⲟⲛ ⳿ⲁ ϯⲡⲟⲗⲓⲥ ⲧⲏⲣⲥ ⲑⲱⲟⲩϯ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲉⲛⲓⲙⲏϣ ⲁⲩⲙⲟϩ ⳿ⲛⲭⲟϩ ⲟⲩⲟϩ ⲛⲁⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲛⲏ⳿ⲉⲛⲁⲣⲉ ⲡⲁⲩⲗⲟⲥ ϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲉⲩϫⲉⲟⲩ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","⳿ⲉⲧⲁⲩⲟⲩⲟⲛϩⲟⲩ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲉ ⲟⲩⲁⲛⲁⲅⲕⲉⲟⲛ ⲡⲉ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲉⲡⲓⲇⲏⲧⲉⲧⲉⲛϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲟϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲱⲡ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ ⳿ⲉⲉⲣ⳿ⲡⲉⲙ⳿ⲡϣⲁ ⳿ⲙⲡⲓⲱⲛϧ ⳿ⲛ⳿⳿ⲉⲛⲉϩ ϩⲏⲡⲡⲉ ⲧⲉⲛⲛⲁⲕⲟⲧⲧⲉⲛ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ⲫⲁⲓ ⲅⲁⲣ ⲡⲉ ⳿ⲙⲫⲣⲏϯ ⳿ⲉⲧⲁϥϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲉⲛ ⳿ⲛϫⲉ Ⲡ⳪ ϫⲉ ⲁⲓⲭⲁⲕ ⲉⲩⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲑⲣⲉⲕϣⲱⲡⲓ ⲉⲩⲟⲩϫⲁⲓ ϣⲁ ⲁⲩⲣⲏϫϥ ⳿ⲙ⳿ⲡⲕⲁϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲁⲩⲣⲁϣⲓ ⲟⲩⲟϩ ⲛⲁⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲟⲩⲟϩ ⲁⲩⲛⲁϩϯ ⳿ⲛϫⲉ ⲛⲏⲧⲏⲣⲟⲩ ⲉⲧⲑⲏϣ ⳿ⲉⲡⲓⲱⲛϧ ⳿ⲛ⳿⳿ⲉⲛⲉϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ⲛⲁⲩⲕⲱϯ ⲇⲉ ⲛⲉⲙ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ϧⲉⲛ ϯⲭⲱⲣⲁ ⲧⲏⲣⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ⲛⲓⲒⲟⲩⲇⲁⲓ ⲇⲉ ⲛⲁⲩϣⲟⲡϣⲉⲡ ⳿ⲛⲛⲓϩⲓ⳿ⲟⲙⲓ ⳿ⲉⲧⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⲛⲉⲙ ⲛⲓⲉⲩⲥⲭⲏⲙⲱⲛ ⲛⲉⲙ ⲛⲓϩⲟⲩⲁϯ ⳿ⲛⲧⲉ ϯⲡⲟⲗⲓⲥ ⲟⲩⲟϩ ⲁⲩⲧⲟⲩⲛⲟⲥ ⲟⲩⲇⲓⲱⲅⲙⲟⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲟⲩⲟϩ ⲁⲩϩⲓⲧⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲛⲛⲟⲩⲑⲱϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲁⲩⲛⲉϩ ⳿ⲡϣⲱⲓϣ ⳿ⲛⲛⲟⲩ ϭⲁⲗⲁⲩϫ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲓⲕⲟⲛⲓⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲇⲉ ⲛⲁⲩⲙⲉϩ ⳿ⲛⲣⲁϣⲓ ⲛⲉⲙ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ . ");
INSERT INTO copcnt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲓⲕⲟⲛⲓⲟⲛ ⲕⲁⲧⲁ ⲡⲁⲓⲣⲏϯ ⲣⲱ ⲉⲑⲣⲟⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲥⲁϫⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ϩⲱⲥⲇⲉ ⳿ⲛⲥⲉⲛⲁϩϯ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ⲛⲓⲒⲟⲩⲇⲁⲓ ⲇⲉ ⳿ⲉⲧⲁⲩⲉⲣⲁⲧⲑⲱⲧ ⳿ⲛϩⲏⲧ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⲟⲩⲟϩ ⲁⲩϯ⳿ⲙⲕⲁϩ ⳿ⲛⲛⲓⲯⲩⲭⲏ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲑⲃⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ⲁⲩⲉⲣ ⲟⲩⲛⲓϣϯ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⳿ⲙⲙⲁⲩ ⲉⲩⲟⲩⲟⲛϩ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⲫⲁⲓ ⲉⲧⲉⲣⲙⲉⲑⲣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲡⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ϩⲙⲟⲧ ⲉϥϯ ⳿ⲛϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ⲉⲑⲣⲟⲩϣⲱⲡⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲟⲩϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ⲁϥⲫⲱⲣϫ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⳿ⲛⲧⲉ ϯ ⲡⲟⲗⲓⲥ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲛⲁⲩⲭⲏ ⲛⲉⲙ ⲛⲓⲒⲟⲩⲇⲁⲓ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩⲭⲏ ⲛⲉⲙ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","⳿ⲉⲧⲁⲩϭⲟϫⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲛⲉⲙ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲟⲩⲕⲉⲁⲣⲭⲱⲛ ⳿ⲉϣⲟϣⲟⲩ ⲟⲩⲟϩ ⲉⲥ⳿ⲉⲧⲱⲛⲓ ⳿ⲡⲉϫⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲁⲩⲫⲱⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲛⲓⲡⲟⲗⲓⲥ ⳿ⲛⲧⲉ ⲗⲩⲕⲁⲟⲛⲓ⳿ⲁ ⲗⲩⲥⲧⲣⲁ ⲛⲉⲙ ⲧⲉⲣⲃⲏⲛⲉⲙ ϯⲡⲉⲣⲓⲭⲱⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ⲛⲁⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲙⲙⲁⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ⲟⲩⲟϩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲁⲧϫⲟⲙ ϧⲉⲛ ⲛⲉϥϭⲁⲗⲁⲩϫ ϧⲉⲛ ⲗⲩⲥⲧⲣⲁ ⲛⲁϥϩⲉⲙⲥⲓ ⲉϥⲟⲓ ⳿ⲛϭⲁⲗⲉ ⲓⲥϫⲉⲛ ⲉϥϧⲉⲛ ⳿ⲑⲛⲉϫⲓ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲁⲩ ⳿ⲙⲡⲉϥⲙⲟϣⲓ ⳿⳿ⲉⲛⲉϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ⲟⲩⲟϩ ⲫⲁⲓ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲡⲁⲩⲗⲟⲥ ⲉϥⲥⲁϫⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲟⲛ ⲛⲁϩϯ ⳿ⲛϧⲏⲧϥ ⳿ⲉⲛⲟϩⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ⲡⲉϫⲁϥ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ϫⲉ ⲧⲱⲛⲕ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲕ ⳿ⲉϫⲉⲛ ⲛⲉⲕϭⲁⲗⲁⲩϫ ⲟⲩⲟϩ ⲛⲁϥϭⲓⲫⲉⲓ ⲟⲩⲟϩ ⲛⲁϥⲙⲟϣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ⲛⲓⲙⲏϣ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲫⲏ⳿ⲉⲧⲁϥⲁⲓϥ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲁⲩϭⲓⲥⲓ ⳿ⲛⲧⲟⲩ⳿ⲥⲙⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲙⲙⲉⲧⲗⲩⲕⲁⲱⲛ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁ ⲛⲓⲛⲟⲩϯ ⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲁⲩ⳿ⲓ ⳿ⲉⲡⲉⲥⲏⲧ ϣⲁⲣⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ⲛⲁⲩⲙⲟⲩϯ ⲙⲉⲛ ⳿ⲉⲃⲁⲣⲛⲁⲃⲁⲥ ϫⲉ ⲡⲓⲍⲉⲩⲥ ⲡⲁⲩⲗⲟⲥ ⲇⲉ ϫⲉ ⲡⲓⲉⲣⲙⲏⲥ ⲉⲡⲓⲇⲏ⳿ⲛⲑⲟϥ ⲉⲧⲟⲓ ⳿ⲛϩⲩⲅⲟⲩⲙⲉⲛⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ⲡⲓⲟⲩⲏⲃ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲍⲉⲩⲥ ⲫⲏ⳿ⲉⲛⲁϥ ⲭⲏ ϧⲁϫⲱⲥ ⳿ⲛϯⲡⲟⲗⲓⲥ ⲁϥ⳿ⲓⲛⲓ ⳿ⲛϩⲁⲛⲙⲁⲥⲓ ⲛⲉⲙ ϩⲁⲛ⳿ⲭⲗⲟⲙ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓⲡⲩⲗⲱⲛ ⲛⲁϥⲟⲩⲱϣ ⳿ⲉϣⲱⲧ ⲡⲉ ⲛⲉⲙ ⲡⲓⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ ⲁⲩⲫⲱϧ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⲁⲩϭⲟϫⲓ ϣⲁ ⲡⲓⲙⲏϣ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲓⲣⲱⲙⲓ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲁⲛⲟⲛ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲣⲉϥϣⲉⲡ⳿ⲙⲕⲁϩ ⳿ⲙⲡⲉⲧⲉⲛⲣⲏϯ ⲉⲛϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲧⲉⲛ ⳿ⲉϩⲉⲛ ⲑⲏⲛⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲛⲛⲓⲙ⳿ⲉⲧⲉⲫⲗⲏⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲕⲉⲧ ⲑⲏⲛⲟⲩ ⳿ⲉⲫϯ ⲉⲧⲟⲛϧ ⲫⲏ⳿ⲉⲧⲁϥⲑⲁⲙⲓⲟ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⲛⲉⲙ ⳿ⲫⲓⲟⲙ ⲛⲉⲙ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉ⳿ⲛϧⲏⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ⲫⲏ⳿ⲉⲧⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⳿ⲉⲧⲁⲩⲥⲓⲛⲓ ⲁϥⲭⲱ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲉⲑⲣⲟⲩⲙⲟϣⲓ ϩⲓ ⲛⲟⲩⲙⲱⲓⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ⲕⲉⲧⲟⲓ ⳿ⲙⲡⲉϥⲭⲁϥ ⲉϥⲟⲓ ⳿ⲛⲁⲧⲙⲉⲑⲣⲉ ⲉϥ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲡⲉⲑⲛⲁⲛⲉⲩ ⲁϥϯ ⲛⲱⲟⲩ ⳿ⲛϩⲁⲛⲙⲟⲩ⳿ⲛϩⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲛⲉⲙ ϩⲁⲛⲥⲏⲟⲩ ⳿ⲙⲙⲁⲥⲟⲩⲧⲁϩ ⲉϥ⳿ⲧⲥⲓⲟ ⳿ⲛⲛⲉⲧⲉⲛϩⲏⲧ ⳿ⲛ⳿ϧⲣⲉ ⲛⲉⲙ ⲟⲩⲛⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ⲟⲩⲟϩ ⲛⲁⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲙⲟⲅⲓⲥ ⲁⲩ⳿ⲑⲣⲉ ⲡⲓⲙⲏϣ ϩⲉⲣⲓ ⳿ⲉ⳿ϣⲧⲉⲙϣⲱⲧ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ⲁⲩϣⲉ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ ⲛⲉⲙ ⲓⲕⲟⲛⲓⲟⲛ ⳿ⲛϫⲉ ϩⲁⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲩⲑⲉⲧ ϩⲏⲧ ⳿ⲛⲛⲓⲙⲏϣ ⲁⲩϩⲓ⳿ⲱⲛⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⲁⲩⲱϣϯ ⳿ⲙⲙⲟϥ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲡⲟⲗⲓⲥ ⲉⲩⲙⲉⲩⲓ ϫⲉ ⲁϥⲙⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ⲉⲩⲕⲱϯ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲧⲁϥⲧⲱⲛϥ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲃⲁⲕⲓ ⲟⲩⲟϩ ⲡⲉϥⲣⲁⲥϯ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲧⲉⲣⲃⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","⳿ⲉⲧⲁⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲇⲉ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϯ⳿ⲥⲃⲱ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⲁⲩⲧⲁⲥⲑⲟ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲗⲩⲥⲧⲣⲁ ⲛⲉⲙ ⲓⲕⲟⲛⲓⲟⲛ ⲛⲉⲙ ⳿ⲧⲁⲛϯⲟⲭⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ⲉⲩⲧⲁϫⲣⲟ ⳿ⲛⲛⲓⲯⲩⲭⲏ ⳿ⲛⲧⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲉⲩϯⲛⲟⲙϯ ⲛⲱⲟⲩ ⲉⲑⲣⲟⲩⲟϩⲓ ϧⲉⲛ ⲡⲓⲛⲁϩϯ ⲟⲩⲟϩ ϫⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛϩⲟϫϩⲉϫ ϩⲱϯ ⳿ⲉⲣⲟⲛ ⳿ⲉϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ⲁⲩⲭⲁϫⲓϫ ⲇⲉ ⳿ⲉϫⲉⲛ ϩⲁⲛ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲱⲟⲩ ⲕⲁⲧⲁ ⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲧⲱⲃϩ ϧⲉⲛ ϩⲁⲛⲛⲏⲥⲧⲓ⳿ⲁ ⲁⲩⲭⲁⲩ ϧⲁⲧⲉⲛ Ⲡ⳪ ⲫⲏ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","⳿ⲉⲧⲁⲩⲥⲉⲛ ϯⲡⲓⲥⲓⲇⲓⲁ ⲇⲉ ⲁⲩ⳿ⲓ ⳿ⲉϯ ⲡⲁⲙⲫⲩⲗⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲁϫⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ϧⲉⲛ ⲡⲉⲣⲅⲏⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲁⲧⲧⲁⲗⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲩⲉⲣϩⲱⲧ ⳿ⲉ⳿ⲧⲁⲛϯⲟⲭⲓ⳿ⲁ ⲡⲓⲙⲁ ⳿ⲉⲧⲁⲩⲧⲏⲓⲧⲟⲩ ⳿ⲛϧⲏⲧϥ ϧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲡⲓϩⲱⲃ ⳿ⲉⲧⲁⲩϫⲟⲕϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲛⲁⲩⲧⲁⲙⲟ ⳿ⲙⲙⲱⲟⲩ ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁϥⲁⲓⲧⲟⲩ ⲛⲉⲙⲱⲟⲩ ⳿ⲛϫⲉ Ⲫϯ ⲟⲩⲟϩ ϫⲉ ⲁϥⲟⲩⲱⲛ ⳿ⲛⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ⲁⲩϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲙⲁⲩ ⲛⲉⲙ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⳿ⲛⲥⲏⲟⲩ ⲁⲛ . ");
INSERT INTO copcnt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲁⲩϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲥⲟⲩⲃⲉ ⲑⲏⲛⲟⲩ ⲕⲁⲧⲁ ⳿ⲧⲥⲩⲛⲏⲑⲓ⳿ⲁ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲛⲟϩⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁⲛ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲩⲑⲱϣ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲉⲑⲣⲟⲩϣⲉ ϣⲁ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲉⲧϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲛⲁⲩ ⲉⲑⲃⲉ ⲡⲁⲓⲍⲏⲧⲏⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩ⳿ⲧⲫⲱⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲁⲩⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯⲫⲟⲓⲛⲓⲕⲏⲛⲉⲙ ⳿ⲧⲥⲁⲘⲁⲣⲓ⳿ⲁ ⲉⲩⲥⲁϫⲓ ⲉⲑⲃⲉ ⳿ⲡⲧⲁⲥⲑⲟ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ⲛⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲁϣⲓ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲩϣⲟⲡⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲁ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲛⲉⲙ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲁⲩⲧⲁⲙⲱⲟⲩ ⲇⲉ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁ Ⲫϯ ⲁⲓⲧⲟⲩ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ⲁⲩⲧⲱⲟⲩⲛ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧϩⲉⲣⲉⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲏ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲥϣⲉ ⳿ⲛⲥⲉⲥⲟⲩⲃⲏⲧⲟⲩ ⲟⲩⲟϩ ⳿ⲉϩⲟⲛϩⲉⲛ ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ⲁⲩⲑⲱⲟⲩϯ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲉⲛⲁⲩ ⲉⲑⲃⲉ ⲡⲁⲓⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ⲉⲧⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲍⲏⲇⲏⲥⲓⲥ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ Ⲡⲉⲧⲣⲟⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⲓⲥϫⲉⲛ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲁⲣⲭⲉⲟⲥ ⳿ⲁ Ⲫϯ ⲥⲱⲧⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱⲓ ⳿ⲉ⳿ⲑⲣⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲥⲱⲧⲉⲙ ⳿ⲉ⳿ⲡⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ⲟⲩⲟϩ ⲡⲉⲧⲥⲱⲟⲩⲛ ⳿ⲛⲛⲓϩⲏⲧ Ⲫϯ ⲁϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ⲟⲩⲟϩ ⲁϥϯ ⲛⲱⲟⲩ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲙ⳿ⲫⲣⲏϯ ϩⲱⲛ ⳿ⲉⲧⲁϥⲧⲏⲓϥ ⲛⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ⲟⲩⲟϩ ⳿ⲙⲡⲉϥⲭⲁ ⳿ϩⲗⲓ ⳿ⲛϣⲓⲃϯ ⲟⲩⲧⲱⲛ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲁϥⲧⲟⲩⲃⲟ ⳿ⲛⲛⲟⲩϩⲏⲧ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲓⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ϯⲛⲟⲩ ⲟⲩⲛ ⲉⲑⲃⲉ ⲟⲩ ⲧⲉⲧ⳿ⲉⲛⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲪϯ ⳿ⲉⲧⲁⲗⲉ ⲟⲩⲛⲁϩⲃⲉϥ ⳿ⲉϫⲉⲛ ⲛⲉⲛⲙⲟϯ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲫⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲡⲉ ⲛⲉⲛⲓⲟϯ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲛ ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲧⲱⲟⲩⲛ ϧⲁⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ ⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲛⲟϩⲉⲙ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲛⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ⲁⲩⲭⲁⲣⲱϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲛⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ ⲉⲩⲥⲁϫⲓ ⳿ⲛⲛⲓⲙⲏⲓⲛⲓ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓ⳿ϣⲫⲏⲣⲓ ⳿ⲉⲧⲁ Ⲫϯ ⲁⲓⲧⲟⲩ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉⲧⲁⲩⲭⲁⲣⲱⲟⲩ ⲇⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ Ⲓⲁⲕⲱⲃⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ⲥⲩⲙⲉⲱⲛ ⲁϥⲥⲁϫⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ⳿ⲉⲧⲁ Ⲫϯ ϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⳿ⲉϭⲓ ⳿ⲛⲟⲩⲗⲁⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ϧⲉⲛ ⲡⲉϥⲣⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ⲟⲩⲟϩ ⲫⲁⲓ ⲥⲉϯⲙⲁϯ ⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ϫⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⲉⲓ⳿ⲉⲧⲁⲥⲑⲟ ⲟⲩⲟϩ ⲉⲓ⳿ⲉⲕⲱⲧ ⳿ⲛϯ⳿ⲥⲕⲏⲛⲏ ⳿ⲛⲧⲉ Ⲇⲁⲩⲓⲇ ⲑⲏⲉⲧⲁⲥϩⲉⲓ ⲟⲩⲟϩ ⲛⲏ⳿ⲉⲧⲁⲩⲥⲱⲥ ⳿ⲛⲧⲁⲥ ⲉⲓ⳿ⲉⲕⲟⲧⲟⲩ ⲟⲩⲟϩ ϯⲛⲁⲧⲁϩⲟⲥ ⳿ⲉⲣⲁⲧⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ϩⲟⲡⲱⲥ ⳿ⲛⲥⲉⲕⲱϯ ⳿ⲛⲥⲁ Ⲡ⳪ ⳿ⲛϫⲉ ⳿ⲡⲥⲱϫⲡ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲛⲉⲙ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⲛⲏ⳿ⲉⲧⲁⲩⲙⲟⲩϯ ⳿ⲉⲡⲁⲣⲁⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⲡⲉϫⲉ Ⲡ⳪ ⲫⲏⲉⲧ⳿ⲑⲣⲟ ⳿ⲛⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲓⲥϫⲉⲛ ⳿ⲡ⳿⳿ⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ⲉⲑⲃⲉ ⲫⲁⲓ ϯϯϩⲁⲡ ⳿ⲁⲛⲟⲕ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲩⲁϩϧⲓⲥⲓ ⳿ⲛⲛⲏⲉⲑⲛⲁⲕⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ⲁⲗⲗⲁ ⳿ⲉⲟⲩⲱⲣⲡ ⲛⲱⲟⲩ ⲉⲑⲣⲟⲩϩⲉⲛⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲛⲛⲓϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲛⲉⲙ ϯⲡⲟⲣⲛⲓ⳿ⲁ ⲛⲉⲙ ⲛⲓⲱϫϩ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲟϥ ⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ⲙⲱ⳿ⲩⲥⲏⲥ ⲅⲁⲣ ⲓⲥϫⲉⲛ ⲛⲓⲅ⳿ⲉⲛⲉ⳿ⲁ ⳿ⲛⲁⲣⲭⲉⲟⲥ ⲟⲩⲟⲛⲧⲁϥ ⳿ⲛⲛⲏⲉⲧϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ⲕⲁⲧⲁ ⲡⲟⲗⲓⲥ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲉⲩⲱϣ ⳿ⲙⲙⲟϥ ⲕⲁⲧⲁ ⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ⲧⲟⲧⲉ ⲁⲥⲉⲣⲇⲟⲕⲓⲛ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲧⲏⲣⲥ ⳿ⲉⲥⲱⲧⲡ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲟⲩⲟⲣⲡⲟⲩ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ Ⲓⲟⲩⲇⲁⲥ ⲡ⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲃⲁⲣⲥⲁⲃⲃⲁⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛϩⲩⲅⲟⲩⲙⲉⲛⲟⲥ ϧⲉⲛ ⲛⲓ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","⳿ⲉⲁⲩ⳿ⲥϧⲁⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲛⲏⲉⲧⲭⲏ ϧⲉⲛ ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ ⲛⲉⲙ ϯⲕⲩⲗⲓⲕⲓ⳿ⲁ ⲛⲉⲙ ϯⲥⲩⲣⲓ⳿ⲁ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲛⲓ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲭⲉⲣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ⲉⲡⲓⲇⲏⲁⲛⲥⲱⲧⲉⲙ ϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩ⳿ϣⲑⲉⲣⲧⲉⲣ ⲑⲏⲛⲟⲩ ⲉⲩⲫⲱⲛϩ ⳿ⲛⲛⲉⲧⲉⲛⲯⲩⲭⲏ ϧⲉⲛ ϩⲁⲛⲥⲁϫⲓ ⲛⲁⲓ ⳿ⲉⲧⲉ ⳿ⲙⲡⲉⲛϫⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ⲁⲥⲉⲣⲇⲟⲕⲓⲛ ⲟⲩⲛ ⲛⲁⲛ ⳿ⲉⲁⲛ⳿ⲓ ⲉⲩⲙⲁ ⲉⲩⲥⲟⲡ ⳿ⲉⲥⲱⲧⲡ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲟⲩⲟⲣⲡⲟⲩ ϩⲁⲣⲱⲧⲉⲛ ⲛⲉⲙ ⲛⲉⲛ⳿ⲁⲅⲁⲡⲏⲧⲟⲥ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲁⲩϯ ⳿ⲛⲧⲟⲩⲯⲩⲭⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ⲁⲛⲟⲩⲱⲣⲡ ⲇⲉ ⳿ⲛⲒⲟⲩⲇⲁⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⲉⲩⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲛⲁⲓ ⲣⲱ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⳿ⲡⲥⲁϫⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ⲁⲥⲣⲁⲛⲁϥ ⲅⲁⲣ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲩⲁϩⲃⲁⲣⲟⲥ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛϩⲟⲩⲟ ⳿ⲡⲗⲏⲛ ⲛⲁⲓ ϧⲉⲛ ⲟⲩ⳿ⲁⲛⲁⲅⲕⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲧⲉⲛ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲛⲓϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲟϥ ⲉⲑⲙⲱⲟⲩⲧ ⲛⲉⲙ ⲛⲓⲱϫϩ ⲛⲉⲙ ⲛⲓⲡⲟⲣⲛⲓ⳿ⲁ ⲛⲁⲓ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲧⲉⲛ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲧⲉⲧ⳿ⲉⲛⲉⲣϩⲱⲃ ⳿ⲛⲕⲁⲗⲱⲥ ⲟⲩϫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","⳿ⲛⲑⲱⲟⲩ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲧⲁⲩⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⳿ⲙⲡⲓⲙⲏϣ ⲁⲩϯ ⳿ⲛϯⲉⲡⲓⲥⲧⲟⲗⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","⳿ⲉⲧⲁⲩⲱϣ ⲇⲉ ⲁⲩⲣⲁϣⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲓⲑⲱⲧ ⳿ⲛϩⲏⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ⲓⲟⲩⲇⲁⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ϩⲁⲛ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ϩⲱⲟⲩ ⲛⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲟⲩⲥⲁϫⲓ ⲉϥⲟϣ ⲁⲩⲑⲉⲧ ⳿ⲡϩⲏⲧ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩⲧⲁϫⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","⳿ⲉⲧⲁⲩⲉⲣ ⲟⲩ⳿ⲭⲣⲟⲛⲟⲥ ⲇⲉ ϧⲁⲧⲟⲧⲟⲩ ⲁⲩⲭⲁⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏⲉⲑⲣⲟⲩϣⲉ ϣⲁ ⲛⲏ⳿ⲉⲧⲁⲩⲟⲩⲟⲣⲡⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ⲥⲓⲗⲁⲥ ⲇⲉ ⲁϥⲟⲩⲱϣ ⳿ⲉϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲉⲧⲉⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲁⲩϣⲱⲡⲓ ϧⲉⲛ ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ ⲉⲩϯ⳿ⲥⲃⲱ ⲟⲩⲟϩ ⲉⲩϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲉⲙ ⲕⲉⲙⲏϣ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ⲙⲉⲛⲉⲛⲥⲁ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲡⲉϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲙⲃⲁⲣⲛⲁⲃⲁⲥ ϫⲉ ⲙⲁⲣⲉⲛⲕⲟⲧⲧⲉⲛ ⳿ⲛⲧⲉ⳿ⲛϫⲉⲙ⳿ⲡϣⲓⲛⲓ ⳿ⲛⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⲕⲁⲧⲁ ⲃⲁⲕⲓ ⲛⲓⲃⲉⲛ ⲛⲏⲉⲧⲁⲛϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ⳿ⲛϧⲏⲧⲟⲩ ϫⲉ ⲟⲩ ⲡⲉⲧϣⲟⲡ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ⲃⲁⲣⲛⲁⲃⲁⲥ ⲇⲉ ⲛⲁϥⲟⲩⲱϣ ⳿ⲉ⳿ⲱⲗⲓ ⳿ⲙ⳿ⲡⲕⲉⲒⲱⲁⲛⲛⲏⲥ ⲛⲉⲙⲱⲟⲩ ⲡ⳿ⲉⲧⲟⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲙⲁⲣⲕⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲛⲁϥⲉⲣ⳿ⲁⲝⲓⲟⲓⲛ ϫⲉⲭⲁⲥ ⲫⲏ⳿ⲉⲧⲁϥⲫⲱⲣϫ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲓⲥϫⲉⲛ ⳿ⲧⲡⲁⲙⲫⲩⲗⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲉ ⳿ⲙⲡⲉϥ⳿ⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲡⲓϩⲱⲃ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲗϥ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩϫⲱⲛⲧ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉⲫⲱⲣϫ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲇⲉ ⲁϥϭⲓ ⳿ⲙⲙⲁⲣⲕⲟⲥ ⲁϥⲉⲣϩⲱⲧ ⳿ⲉⲕⲩⲡⲣⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲁϥⲥⲱⲧⲡ ⳿ⲛⲥⲓⲗⲁⲥ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁⲩⲧⲏⲓϥ ⳿ⲛⲧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ⲛⲁϥⲥⲓⲛⲓ ⲇⲉ ⲡⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲥⲩⲣⲓ⳿ⲁ ⲛⲉⲙ ⳿ⲧⲕⲩⲗⲓⲕⲓ⳿ⲁ ⲉϥⲧⲁϫⲣⲟ ⳿ⲛⲛⲓⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ");
INSERT INTO copcnt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲕ⳿ⲉⲧⲉⲣⲃⲏⲛⲉⲙ ⲗⲩⲥⲧⲣⲁ ⲟⲩⲟϩ ⲓⲥ ⲟⲩⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲛⲁϥⲭⲏ ⳿ⲙⲙⲁⲩ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲧⲓⲙⲟⲑⲉⲟⲥ ⳿ⲡϣⲏⲣⲓ ⳿ⲛⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲙⲡⲓⲥⲧⲏⲡⲉϥⲓⲱⲧ ⲇⲉ ⲛⲉ ⲟⲩⲉⲓⲛⲓⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ⲫⲁⲓ ⲛⲁⲩⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲉⲧϧⲉⲛ ⲗⲩⲥⲧⲣⲁ ⲛⲉⲙ ⲓⲕⲟⲛⲓⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ⲫⲁⲓ ⲁϥⲟⲩⲱϣ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲉⲑⲣⲉϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲛⲉⲙⲁϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲗϥ ⲁϥⲥⲟⲩⲃⲏⲧϥ ⲉⲑⲃⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁⲩⲥⲱⲟⲩⲛ ⲅⲁⲣ ⲧⲏⲣⲟⲩ ϫⲉ ⲡⲉϥⲓⲱⲧ ⲟⲩⲟⲩⲉⲓⲛⲓⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ⲉⲩⲕⲱϯ ⲇⲉ ϧⲉⲛ ⲛⲓⲡⲟⲗⲓⲥ ⲛⲁⲩϯ ⳿ⲙⲙⲟⲥ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉⲛⲓϩⲱⲛ ⳿ⲉⲧⲁⲩⲥⲉⲙⲛⲏⲧⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲉⲧϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ⲛⲓⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲙⲉⲛ ⲟⲩⲛ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲛⲧⲁϫⲣⲟ ϧⲉⲛ ⲡⲓⲛⲁϩϯ ⲟⲩⲟϩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲛ⳿ⲁϣⲁⲓ ϧⲉⲛ ⲧⲟⲩⲏⲡⲓ ⳿ⲙⲙⲏⲛⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ⲁⲩⲥⲓⲛⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯ⳿ⲫⲣⲓⲕⲓⲁ ⲛⲉⲙ ϯⲭⲱⲣⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲁⲧⲓⲁ ⳿ⲉⲁϥⲧⲁϩⲛⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲁϫⲓ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ϧⲉⲛ ϯ⳿ⲁⲥⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲛⲓⲙⲁ ⳿ⲛⲧⲉ ϯ ⲙⲩⲥⲓⲁ ⲛⲁⲩϭⲱⲛⲧ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉϣⲉ ⳿ⲉϯⲃⲏⲑⲉⲛⲓ⳿ⲁ ⲟⲩⲟϩ ⲛⲁϥⲭⲱ ⳿ⲙⲙⲱⲟⲩ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","⳿ⲉⲧⲁⲩⲥⲓⲛⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲙⲩⲥⲓⲁ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲣⲱⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ⲟⲩⲟϩ ⲁϥⲟⲩⲟⲛϩ ⳿ⲉⲡⲁⲩⲗⲟⲥ ⳿ⲛϫⲉ ⲟⲩϩⲟⲣⲁⲙⲁ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲟⲩⲣⲱⲙⲓ ⳿ⲙⲙⲁⲕⲉⲇⲱⲛ ⲉϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲉϥⲧⲱⲃϩ ⳿ⲙⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲙⲟⲩ ⳿ⲉ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓⲁ ⳿ⲁⲣⲓⲃⲟ⳿ⲏⲑⲓⲛ ⳿ⲉⲣⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ϩⲱⲥ ⲇⲉ ⲉⲧⲀⲛⲛⲁⲩ ⳿ⲉⲡⲓϩⲟⲣⲁⲙⲁ ⲥⲁⲧⲟⲧⲉⲛ ⲁⲛⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲓ ⳿ⲉ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓⲁ ⲉⲛⲥⲟϭⲛⲓ ϫⲉ ⳿ⲉⲧⲁ Ⲫϯ ⲑⲁϩⲙⲉⲛ ⳿ⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ⲉⲧⲁⲛ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲣⲱⲁⲥ ⲁⲛϣⲉ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲉⲥⲁⲙⲟⲑⲣⲁⲕⲏⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲛ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿⳿ⲉⲛⲉⲁⲡⲟⲗⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲛ⳿ⲓ ⳿ⲉⲫⲓⲗⲓⲡⲡⲟⲓⲥ ⳿ⲉⲧⲉ ⳿ⲛⲑⲟⲥ ⲧⲉ ϯϩⲟⲩⲓϯ ⳿ⲛⲧⲉ ϯⲧⲟⲓ ⳿ⲛⲧⲉ ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓⲁ ⲟⲩⲡⲟⲗⲓⲥ ⳿ⲛⲕⲟⲗⲱⲛⲓⲁ ⲛⲁⲛϣⲟⲡ ⲇⲉ ⲡⲉ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϩⲁⲛ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲁⲛ⳿ⲓ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲡⲟⲗⲓⲥ ϧⲁⲧⲉⲛ ⳿ⲫⲓⲁⲣⲟ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲛⲙⲉⲩⲓ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲡⲣⲟⲥⲉⲩⲭⲏ ⲛⲁϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲉⲧⲁⲛϩⲉⲙⲥⲓ ⲛⲁⲛⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓϩⲓ⳿ⲟⲙⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ⲟⲩⲟϩ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲗⲩⲇⲓⲁ ⳿ⲉⲟⲩⲥⲁ⳿ⲛϭⲏϫⲓ ⲧⲉ ⳿ⲛⲧⲉ ⲟⲩⲡⲟⲗⲓⲥ ϫⲉ ⲑⲩⲁⲧⲏⲣⲱⲛ ⲉⲥⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲪϯ ⲛⲁⲥⲥⲱⲧⲉⲙ ⲑⲁⲓ ⳿ⲁ Ⲫϯ ⲟⲩⲱⲛ ⳿ⲙⲡⲉⲥϩⲏⲧ ⳿ⲉϯ⳿ϩⲑⲏⲥ ⳿ⲉⲛⲏ⳿ⲉⲛⲁⲣⲉ ⲡⲁⲩⲗⲟⲥ ϫⲱ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ⲉⲧⲁⲥϭⲓⲱⲙⲥ ⲇⲉ ⲛⲉⲙ ⲡⲉⲥⲏⲓ ⲁⲥϯϩⲟ ⳿ⲉⲣⲟⲛ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⲁⲧⲉⲧⲉⲛⲟⲡⲧ ⳿ⲉⲟⲩⲡⲓⲥⲧⲏ⳿ⲙⲠ⳪ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲁⲏⲓ ϣⲱⲡⲓ ⲟⲩⲟϩ ⲁⲥϭⲓⲧⲧⲉⲛ ⳿ⲛϫⲟⲛⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲛⲛⲁ ⳿ⲉϯⲡⲣⲟⲥⲉⲩⲭⲏ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁⲛ ⳿ⲛϫⲉ ⲟⲩ⳿ⲁⲗⲟⲩ ⳿ⲙⲃⲱⲕⲓ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲣⲉϥϣⲓⲛⲓ ⲛⲉⲙⲁⲥ ⲑⲁⲓ ⳿ⲉⲛⲁⲥϯ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲉⲣⲅⲁⲥⲓⲁ ⳿ⲛⲛⲉⲥϭⲓⲥⲉⲩ ⲉⲥⲟⲓ ⳿ⲛⲣⲉϥϣⲓⲛⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ⲑⲁⲓ ⳿ⲉⲧⲁⲥⲙⲟϣⲓ ⳿ⲛⲥⲁ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙⲁⲛ ⲛⲁⲥⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲁⲓⲣⲱⲙⲓ ϩⲁⲛ⳿ⲉⲃⲓⲁⲓⲕ ⳿ⲛⲧⲉ Ⲫϯ ⲉⲧϭⲟⲥⲓ ⲛⲉ ⲛⲁⲓ ⲉⲧϩⲓⲱⲓϣ ⲛⲱⲧⲉⲛ ⳿ⲛⲟⲩⲙⲱⲓⲧ ⳿ⲛⲟⲩϫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ⲫⲁⲓ ⲇⲉ ⲛⲁⲥⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁϥⲉⲣ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲕⲟⲧϥ ⳿ⲉⲡⲓⲡ͞ⲛⲁ̅ ⲡⲉϫⲁϥ ϫⲉ ϯϩⲟⲛϩⲉⲛ ⲛⲁⲕ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲉ⳿Ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲥ ⲟⲩⲟϩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲉⲥϭⲓⲥⲉⲩ ϫⲉ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲥ ⳿ⲛϫⲉ ⳿ⲧϩⲉⲗⲡⲓⲥ ⳿ⲛⲧⲉ ⲡⲟⲩϩⲱⲃ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ⲁⲩⲱϣϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉϯ⳿ⲁⲅⲟⲣⲁ ϣⲁ ⲛⲓⲁⲣⲭⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲉⲛⲟⲩ ϩⲁ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲁⲓⲣⲱⲙⲓ ⲥⲉ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲧⲉⲛⲡⲟⲗⲓⲥ ⳿ⲉϩⲁⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ⲟⲩⲟϩ ⲥⲉϩⲓⲱⲓϣ ⲛⲁⲛ ⳿ⲛϩⲁⲛⲕⲉⲕⲁϩⲥ ⲛⲁⲓ ⳿ⲉⲧⲉⲥϣⲉⲛⲁⲛ ⲁⲛ ⳿ⲉϣⲟⲡⲟⲩ ⲟⲩⲇⲉ ⳿ⲉⲁⲓⲧⲟⲩ ⳿ⲉ⳿ⲁⲛⲟⲛ ϩⲁⲛⲣⲱⲙⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⲟⲩⲟϩ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⲁⲩⲫⲱϧ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⲁⲩⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⳿ⲛⲥⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲙ⳿ⲡ⳿ϣⲃⲱⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","⳿ⲉⲧⲁⲩϯ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛϣⲁϣ ⲛⲱⲟⲩ ⲁⲩϩⲓⲧⲟⲩ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ ⳿ⲉⲁⲩϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧϥ ⳿ⲙⲡⲓⲣⲉϥ⳿ⲁⲣⲉϩ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ⲫⲁⲓ ⳿ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩϩⲟⲛϩⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲁϥϩⲓⲧⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓ⳿ϣⲧⲉⲕⲟ ⲉⲧⲥⲁϧⲟⲩⲛ ⲟⲩⲟϩ ⲁϥⲧⲁϫⲣⲟ ⳿ⲛⲛⲟⲩϭⲁⲗⲁⲩϫ ⳿ⲉⲡⲓϣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⳿ⲧⲫⲁϣⲓ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ⲉⲩⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲛⲁⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲫϯ ⲛⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲥⲟⲛϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲟⲛⲙⲉⲛ ϩⲱⲥⲇⲉ ⳿ⲛⲥⲉⲕⲓⲙ ⳿ⲛϫⲉ ⲛⲓⲥⲉⲛϯ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ⳿ⲛϯⲟⲩⲛⲟⲩ ⲇⲉ ⲁⲩⲟⲩⲱⲛ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲛⲓ⳿ⲥⲛⲁⲩϩ ⳿ⲛⲧⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲁⲩⲃⲱⲗ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","⳿ⲉⲧⲁϥⲛⲉϩⲥⲓ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥ⳿ⲁⲣⲉϩ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲛⲁⲩ ⳿ⲉⲛⲓⲣⲱⲟⲩ ⳿ⲛⲧⲉ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲉⲩⲟⲩⲏⲛ ⲁϥⲑⲱⲕⲉⲙ ⳿ⲛⲧⲉϥⲥⲏϥⲓ ⲉϥⲛⲁϧⲟⲑⲃⲉϥ ⲉϥⲙⲉⲩⲓ ϫⲉ ⲁⲩⲫⲱⲧ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲥⲱⲛϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ⲁϥⲱϣ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣ ⳿ϩⲗⲓ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲛⲁⲕ ⲧⲉⲛ⳿ⲙⲡⲁⲓⲙⲁ ⲅⲁⲣ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ⲁϥϭⲓ ⲇⲉ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⲁϥϭⲟϫⲓ ⳿ⲉϧⲟⲩⲛ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ϧⲉⲛ ⲟⲩ⳿ⲥⲑⲉⲣⲧⲉⲣ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲁⲣⲁⲧϥ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲛⲁϭⲓⲥⲉⲩ ⲟⲩ ⲡⲉⲧⲥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲁⲁⲓϥ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲟϩⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲛⲁϩϯ ⳿ⲉⲠ⳪ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⲉⲕ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲑⲟⲕ ⲛⲉⲙ ⲡⲉⲕⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ⲟⲩⲟϩ ⲁⲩⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ⳿ⲛⲑⲟϥ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ⲟⲩⲟϩ ⲁϥⲟⲗⲟⲩ ⳿ⲛϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲁϥϫⲟⲕⲙⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲟⲩⲉⲣϧⲱⲧ ⲟⲩⲟϩ ⲁϥϭⲓⲱⲙⲥ ⳿ⲛⲑⲟϥ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","⳿ⲉⲧⲁϥ⳿ⲉⲛⲟⲩ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲉϥⲏⲓ ⲁϥ ⲭⲁ ⲟⲩ⳿ⲧⲣⲁⲡⲉⲍⲁ ϧⲁⲧⲟⲧⲟⲩ ⲟⲩⲟϩ ⲛⲁϥⲑⲉⲗⲏⲗ ⳿ⲙⲙⲟϥ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ ⳿ⲉⲧⲁϥⲛⲁϩϯ ⳿ⲉⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ϣⲱⲡⲓ ⲁⲩⲟⲩⲱⲣⲡ ⳿ⲛϫⲉ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⳿ⲛϩⲁⲛⲣⲁⲃⲇⲟⲩⲭⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲭⲁ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ⲁϥⲧⲁⲙⲉ ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲓⲣⲉϥ⳿ⲁⲣⲉϩ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲛⲥⲱⲛϩ ϫⲉ ⳿ⲁ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⲟⲩⲱⲣⲡ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲭⲁ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϯⲛⲟⲩ ⲟⲩⲛ ⳿ⲁⲙⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗ ⲙⲁϣⲉⲛⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲉⲧⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲛ ⳿ⲛⲇⲏⲙⲟⲥⲓⲁ ⳿ⲉ⳿ⲁⲛⲟⲛ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲛⲣⲱⲙⲉⲟⲥ ⳿ⲛⲧ⳿ⲉⲛⲉⲣ⳿ⲡⲕⲉϩⲱⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲡϩⲁⲡ ⲁⲛ ⲁⲩϩⲓⲧⲧⲉⲛ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⲥ⳿ⲉϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲟⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛⲭⲱⲡ ⳿ⲙⲙⲟⲛ ⲁⲗⲗⲁ ⲙⲁⲣⲟⲩ⳿ⲓ ⳿ⲛⲑⲱⲟⲩ⳿ⲓ ⳿ⲛⲥⲉ⳿ⲉⲛⲧⲉⲛ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ⲁⲩⲧⲁⲙⲉ ⲛⲓⲥⲁⲧⲏⲅⲟⲩⲥ ⲇⲉ ⳿ⲉⲛⲁⲓⲥⲁϫⲓ ⳿ⲛϫⲉ ⲛⲓⲣⲁⲃⲇⲟⲩⲭⲟⲥ ⲁⲩⲉⲣϩⲟϯ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ϫⲉ ϩⲁⲛⲣⲱⲙⲉⲟⲥ ⲛⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲁⲩϧⲱⲛϫ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲩϯϩⲟ ⳿ⲉⲣⲱⲟⲩ ⲉⲑⲣⲟⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲟⲩⲡⲟⲗⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓ⳿ϣⲧⲉⲕⲟ ⲁⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲗⲩⲇⲓⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⲁⲩϯⲛⲟⲙϯ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ . ");
INSERT INTO copcnt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","⳿ⲉⲧⲁⲩⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲁⲙⲫⲓⲡⲟⲗⲓⲥ ⲛⲉⲙ ϯ⳿ⲁⲡⲟⲗⲗⲱⲛⲓ⳿ⲁ ⲁⲩ⳿ⲓ ⳿ⲉⲑⲉⲥⲥⲁⲗⲟⲛⲓⲕⲏⲡⲓⲙⲁ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛϧⲏⲧϥ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ⲕⲁⲧⲁ ϯⲥⲩⲛⲏⲑⲓ⳿ⲁ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϣⲁ ⲅ̅ ⳿ⲛⲥⲁⲃⲃⲁⲧⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ⲉϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥⲭⲱ ϧⲁⲧⲟⲧⲟⲩ ϫⲉ ϩⲱϯ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ϭⲓ⳿ⲙⲕⲁϩ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ϫⲉ ⲫⲁⲓ ⲡⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲫⲁⲓ ⳿ⲁⲛⲟⲕ ⳿ⲉϯϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ⲛⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ⲟⲩⲟϩ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲩⲛⲁϩϯ ⲟⲩⲟϩ ⲁⲩⲱⲡ ⳿ⲉⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ⳿ⲛϫⲉ ⲟⲩⲙⲏϣ ⲉϥⲟϣ ⳿ⲛⲧⲉ ⲛⲏ⳿ⲉⲧⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲛⲧⲉ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ϩⲁⲛϩⲓ⳿ⲟⲙⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓϩⲟⲩⲁϯ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ⲁⲩⲭⲟϩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲁⲩϭⲓ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⲉⲩϩⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲁⲅⲟⲣⲣⲉⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲑⲟⲩⲉⲧ ⲟⲩⲙⲏϣ ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛϯⲡⲟⲗⲓⲥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲉⲛ ⳿ⲡⲏⲓ ⳿ⲛⲓⲁⲥⲥⲱⲛ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲱⲟⲩ ⳿ⲛⲥⲉ⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","⳿ⲉⲧⲉ⳿ⲙⲡⲟⲩϫⲉⲙⲟⲩ ⲇⲉ ⲁⲩⲱϣϯ ⳿ⲛⲓⲁⲥⲥⲱⲛ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ϩⲁⲛⲕⲉ⳿ⲥⲛⲏⲟⲩ ϣⲁ ⲛⲓⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ϯⲡⲟⲗⲓⲥ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲛⲁⲓ ⲛⲉ ⲛⲏ⳿ⲉⲧⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲟⲩⲟϩ ⲥⲉϣⲟⲡ ⲧⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","⳿ⲉⲁ ⲓⲁⲥⲥⲱⲛ ϣⲟⲡⲟⲩ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲥⲉϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲛⲓϩⲱⲛ ⳿ⲛⲧⲉ ⳿ⲡⲟⲩⲣⲟ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥϣⲟⲡ ⳿ⲛϫⲉ ⲕⲉⲟⲩⲣⲟ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲇⲉ ⳿ⲙⲡⲓⲙⲏϣ ⲛⲉⲙ ⲛⲓⲁⲣⲭ ⲱⲛ ⳿ⲛⲧⲉ ϯⲡⲟⲗⲓⲥ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲉⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϭⲓ ⳿ⲙⲡⲉⲧⲥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉⲛ ⲓⲁⲥⲥⲱⲛ ⲛⲉⲙ ⲛⲓⲕⲉⲥⲱϫⲡ ⲁⲩⲭⲁⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲇⲉ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩ⳿ⲧⲫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲥⲓⲗⲁⲥ ⳿ⲛϫⲱⲣϩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲃⲉⲣⲟⲓ⳿ⲁ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲙⲁⲩ ⲁⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ⲛⲁⲓ ⲇⲉ ⲛⲉ ϩⲁⲛⲉⲩⲅⲉⲛⲏⲥ ⲛⲉ ⳿⳿ⲉϩⲟⲧⲉ ⲛⲏⲉⲧϧⲉⲛ ⲑⲉⲥⲥⲁⲗⲟⲛⲓⲕⲏⲛⲁⲓ ⳿ⲉⲧⲁⲩϣⲉⲡ ⲡⲓⲥⲁϫⲓ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲣⲱⲟⲩⲧϥ ⳿ⲛϩⲏⲧ ⲛⲓⲃⲉⲛ ⲉⲩϧⲟⲧϧⲉⲧ ⳿ⲙⲙⲏⲛⲓ ϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϫⲉ ⲁⲛ ⲛⲁⲓ ϣⲟⲡ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ⲟⲩⲙⲏϣ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲩⲛⲁϩϯ ⲛⲉⲙ ϩⲁⲛⲕⲉⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⳿ⲛϩⲓ⳿ⲟⲙⲓ ⳿ⲛⲉⲩ⳿ⲥⲭⲏⲙⲱⲛ ⲛⲉⲙ ϩⲁⲛⲕⲉⲣⲱⲙⲓ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","⳿ⲉⲧⲁⲩ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲛⲧⲉ ⲑⲉⲥⲥⲁⲗⲟⲛⲓⲕⲏϫⲉ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ϩⲓⲱⲓϣ ϧⲉⲛ ⳿ⲧⲕⲉⲃⲉⲣⲟⲓ⳿ⲁ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲫϯ ⲁⲩ⳿ⲓ ⳿ⲉⲡⲓⲕⲉⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲩⲕⲓⲙ ⳿ⲛⲛⲓⲙⲏϣ ⲉⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ⲧⲟⲧⲉ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩ⳿ⲧⲫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲉⲑⲣⲉϥϣⲉ ⳿ⲉϫⲉⲛ ⳿ⲫⲓⲟⲙ ⲁⲩⲥⲱϫⲡ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲥⲓⲗⲁⲥ ⲛⲉⲙ ⲧⲓⲙⲟⲑⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ⲛⲏⲇⲉ ⳿ⲉⲛⲁⲩ⳿ⲧⲫⲟ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗ ⲁⲩⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲁⲑⲏⲛⲛⲁⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϭⲓ ⲉⲛⲧⲟⲗⲏ ⳿ⲉϭⲓ⳿ⲡϣⲓⲛⲓ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲥⲓⲗⲁⲥ ⲛⲉⲙ ⲧⲓⲙⲟⲑⲉⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ⲓ ϩⲁⲣⲟϥ ⳿ⲛⲭⲱⲗⲉⲙ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲩϣⲉⲛⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲛⲁϥϧⲉⲛ ⳿ⲁⲑⲏⲛⲛⲁⲥ ⲉϥⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱⲟⲩ ⲁϥϫⲱⲛⲧ ⲇⲉ ⳿ⲛϫⲉ ⲡⲉϥⲡ͞ⲛⲁ̅ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ⲉϥⲛⲁⲩ ⳿ⲉϯⲡⲟⲗⲓⲥ ⲉⲥⲟϣ ⳿ⲙⲙⲉⲧϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ⲛⲁϥⲥⲁϫⲓ ⲙⲉⲛ ⲟⲩⲛ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲏ⳿ⲉⲧⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲉϣⲁⲩⲑⲱⲟⲩϯ ⳿ⲙⲙⲏⲛⲓ ϩⲓ ϯ⳿ⲁⲅⲟⲣⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲡⲓⲕⲟⲩⲣⲓⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲥⲧⲟⲓⲭⲟⲥ ⳿ⲙⲫⲓⲗⲟⲥⲟⲫⲟⲥ ⲛⲁⲩϯ ⲟⲩⲃⲏϥ ⲟⲩⲟϩ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉϥⲟⲩⲱϣ ⳿ⲉϫⲟϥ ⳿ⲛϫⲉ ⲡⲁⲓ⳿ⲥⲡⲉⲣⲙⲟⲗⲟⲅⲟⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲣⲉϥϩⲓⲱⲓϣ ⲡⲉ ⳿ⲛⲧⲉ ϩⲁⲛⲇⲉⲙⲱⲛ ⳿ⲛϣⲉⲙⲙⲟ ϫⲉ ⲛⲁϥϩⲓⲱⲓϣ ⲛⲱⲟⲩ ⲡⲉ ⳿ⲛⲒⲏ̅ⲥ̅ ⲛⲉⲙ ⲧⲉϥ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⲇⲉ ⳿ⲙⲙⲟϥ ⲁⲩⲉⲛϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲁⲣⲓⲟⲡⲁⲅⲟⲥ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ ⳿ⲉ⳿ⲉⲙⲓ ϫⲉ ⲧⲁⲓ⳿ⲥⲃⲱ ⳿ⲙⲃⲉⲣⲓ ⲟⲩ ⲧⲉ ⳿ⲉⲧⲉⲕⲥⲁϫⲓ ⳿ⲙⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","⳿ⲕⲓⲛⲓ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⳿ⲛϣⲉⲙⲙⲟ ⳿ⲉϧⲟⲩⲛ ⳿⳿ⲉⲛⲉⲛⲙⲁϣϫ ⲧⲉⲛⲟⲩⲱϣ ⳿ⲉ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⲛⲉ ⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ⲛⲓⲁⲑⲏⲛⲛⲉⲟⲥ ⲇⲉ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓϣⲉⲙⲙⲱⲟⲩ ⲉⲑⲛⲏⲟⲩ ⳿ⲉⲙⲁⲩ ⲛⲁⲩ⳿ⲥⲣⲱϥⲧ ⳿ⲉ⳿ϩⲗⲓ ⲁⲛ ⲡⲉ ⳿ⲉⲃⲏⲗ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉϩⲱⲃ ⳿ⲙⲃⲉⲣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ⲁϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϧⲉⲛ ⳿ⲑⲙⲏϯ ⳿ⲙⲡⲓⲁⲣⲓⲟⲡⲁⲅⲟⲥ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲓⲁⲑⲏⲛⲛⲉⲟⲥ ⲕⲁⲧⲁ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϯⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲟⲓ ⳿ⲛⲣⲉϥϣⲁⲙϣⲉ ⲓϧ ⳿ⲛϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ⲉⲓⲥⲓⲛⲓ ⲅⲁⲣ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲓⲛⲁⲩ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲧ⳿ⲉⲛⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲙⲱⲟⲩ ⲁⲓϫⲓⲙⲓ ⳿ⲛⲟⲩϣⲏⲟⲩ⳿ⲓ ⲉⲥ⳿ⲥϧⲏⲟⲩⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ϩⲓⲱⲧⲥ ϫⲉ Ⲫϯ ⳿ⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⲫⲏ ⲟⲩⲛ ⳿ⲉⲧⲉⲧ⳿ⲉⲛⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲙⲟϥ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⲫⲁⲓ ⳿ⲁⲛⲟⲕ ⳿ⲉϯϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ⲛⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ⲫϯ ⳿ⲉⲧⲁϥⲑⲁⲙⲓ⳿ⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲉⲙ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⲫⲁⲓ ⲡⲉ Ⲡ⳪ ⳿ⲛ⳿ⲧⲫⲉ ⲛⲉⲙ ⳿ⲡⲕⲁϩⲓ ⲛⲁϥϣⲟⲡ ⲁⲛ ϧⲉⲛ ϩⲁⲛⲉⲣⲫⲏⲟⲩ⳿ⲓ ⳿ⲙⲙⲟⲩⲛⲕ ⳿ⲛϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ⲟⲩⲇⲉ ⲛⲉϣⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲛϫⲉ ϩⲁⲛϫⲓϫ ⳿ⲛⲣⲱⲙⲓ ⳿ⲛ⳿ϥⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛⲑⲟϥ ⲡⲉⲧϯ ⳿ⲙ⳿ⲡⲱⲛϧ ⲛⲉⲙ ⳿ⲫⲛⲓϥⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","⳿ⲉⲁϥⲑⲁⲙⲓ⳿ⲉ ⳿ϣⲗⲟⲗ ⲛⲓⲃⲉⲛ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲟⲩⲁⲓ ⲉⲑⲣⲟⲩϣⲱⲡⲓ ϩⲓϫⲉⲛ ⳿ⲡϩⲟ ⳿ⲙ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ ⳿ⲉⲁϥⲑⲱϣ ⳿ⲛϩⲁⲛⲥⲏⲟⲩ ⲉⲩⲑⲏϣ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ⲛⲉⲙ ⲡⲓⲑⲱϣ ⳿ⲛⲧⲉ ⲡⲟⲩϫⲓⲛϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ⲉⲑⲣⲟⲩⲕⲱϯ ⳿ⲛⲥⲁ Ⲫϯ ϫⲉ ϩⲁⲣⲁ ⲅⲉ ⲥⲉⲛⲁϫⲟⲙϫⲉⲙ ⳿ⲛⲥⲱϥ ⳿ⲛⲥⲉϫⲉⲙϥ ⲕⲉⲧⲟⲓ ⳿ϥⲟⲩⲏⲟⲩ ⲁⲛ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ⲁⲛⲱⲛϧ ⲅⲁⲣ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲁⲛⲕⲓⲙ ⲟⲩⲟϩ ⲁⲛϣⲟⲡ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲩϫⲟⲥ ⳿ⲛϫⲉ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲡⲟⲓⲧⲏⲥ ⲉⲧϧⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⳿ⲁⲛⲟⲛ ⲡⲉϥⲅⲉⲛⲟⲥ ⲅⲁⲣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","⳿ⲉ⳿ⲁⲛⲟⲛ ⲟⲩⲅⲉⲛⲟⲥ ⲟⲩⲛ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲥϣⲉⲛⲁⲛ ⲁⲛ ⲉⲑⲣⲉⲛⲙⲉⲩⲓ ⳿ⲉⲛⲟⲩⲃ ⲓⲉ ϩⲁⲧ ⲓⲉ ⳿ⲱⲛⲓ ⳿ⲙⲫⲱⲧϩ ⳿ⲛⲧⲉⲭⲛⲏⲓⲉ ⲙⲟⲕⲙⲉⲕ ⳿ⲛⲣⲱⲙⲓ ϫⲉ ⲁϥⲟⲛⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ⲛⲓⲥⲏⲟⲩ ⲙⲉⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲧⲁⲧ⳿ⲉⲙⲓ ⲁϥ ⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ Ⲫϯ ϯⲛⲟⲩ ⲇⲉ ⳿ϥϩⲓⲱⲓϣ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲉⲑⲣⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ϫⲉ ⲁϥⲥⲉⲙⲛⲉ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⲉϥⲛⲁϯϩⲁⲡ ⳿ⲉϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⳿ⲛϧⲏⲧϥ ϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲁϥⲑⲁϣϥ ⳿ⲉⲁϥϯ ⳿ⲙ⳿ⲫⲛⲁϩϯ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉⲁϥⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ϫⲉ ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲁⲩⲥⲱⲃⲓ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲁⲩϫⲟⲥ ϫⲉ ⳿ⲉⲛⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲕ ⲉⲑⲃⲉ ⲫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲟⲩⲙⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ⲁⲩⲧⲟⲙⲟⲩ ⲇⲉ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲁⲩⲛⲁϩϯ ⲛⲁⲓ ⳿ⲉⲧⲉⲛⲁⲣⲉ ⲇⲓⲟⲛⲏⲥⲓⲟⲥ ⳿ⲛϧⲏⲧⲟⲩ ⲡⲓⲁⲣⲓⲟⲡⲁⲅⲓⲧⲏⲥ ⲛⲉⲙ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲡⲉⲥⲣⲁⲛ ⲡⲉ ⲇⲁⲙⲁⲣⲓⲥ ⲛⲉⲙ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲛⲉⲙⲱⲟⲩ . ");
INSERT INTO copcnt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲁⲑⲏⲛⲛⲏⲥ ⲁϥ⳿ⲓ ⳿ⲉⲕⲟⲣⲓⲛⲑⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩⲒⲟⲩⲇⲁⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲕⲩⲗⲗⲁⲥ ⳿ⲉⲟⲩⲡⲟⲛⲧⲓⲟⲥ ⲡⲉ ϧⲉⲛ ⲡⲉϥⲅⲉⲛⲟⲥ ⳿ⲉⲁϥ⳿ⲓ ⲥⲁⲧⲟⲧϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯϩⲩⲧⲁⲗⲓ⳿ⲁ ⲛⲉⲙ ⳿ⲡⲣⲓⲥⲕⲩⲗⲗⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ϫⲉ ⲛⲉ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲡⲉ ⳿ⲛϫⲉ ⳿ⲕⲗⲁⲩⲇⲓⲟⲥ ⲉⲑⲣⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⲫⲱⲣϫ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲣⲱⲙⲏⲁϥ⳿ⲓ ϣⲁⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ⲟⲩⲟϩ ⲁϥϣⲱⲡⲓ ϧⲁⲧⲟⲧⲟⲩ ⲉⲑⲃⲉ ϫⲉ ⲟⲩ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲉⲭⲛⲏ⳿ⲛⲧⲁϥ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣϩⲱⲃ ⲡⲉ ⲛⲉ ϩⲁⲛⲣⲉϥⲑⲁⲙⲓ⳿ⲉ ⳿ⲥⲕⲩⲛⲏⲅⲁⲣ ⲛⲉ ϧⲉⲛ ⲧⲟⲩⲧⲉⲭⲛⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ⲛⲁⲩⲥⲁϫⲓ ⲇⲉ ⲡⲉ ϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲕⲁⲧⲁ ⲥⲁⲃⲃⲁⲧⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲛⲁⲩⲑⲱⲧ ⳿ⲙ⳿ⲡϩⲏⲧ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ⳿ⲛϫⲉ ⲥⲓⲗⲁⲥ ⲛⲉⲙ ⲧⲓⲙⲟⲑⲉⲟⲥ ⲛⲁϥⲙⲏⲛ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϧⲉⲛ ⲡⲓⲥⲁϫⲓ ⲉϥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ⲉⲩϯ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⲟⲩⲟϩ ⲉⲩϫⲉⲟⲩ⳿ⲁ ⲁϥⲛⲉϩ ⲛⲉϥ⳿ϩⲃⲱⲥ ⳿ⲉⲃⲟⲗ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛ⳿ⲥⲛⲟϥ ⳿ⲉϫⲉⲛ ⲧⲉⲧⲉⲛⲁⲫⲉ ϯⲟⲩⲁⲃ ⳿ⲁⲛⲟⲕ ⲓⲥϫⲉⲛ ϯⲛⲟⲩ ⲉⲓ⳿ⲉϣⲉⲛⲏⲓ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲛⲟⲩⲁⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲧⲓⲧⲟⲥ ⲫⲁⲓ ⲟⲩⲡⲓⲥⲧⲟⲥ ⲉϥⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲪϯ ⲫⲁⲓ ⳿ⲉⲛⲁⲣⲉ ⲡⲉϥⲏⲓ ⲧⲟⲙⲓ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","⳿ⲕⲣⲓⲥⲡⲟⲥ ⲇⲉ ⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲁϥⲛⲁϩϯ ⳿ⲉⲠ⳪ ⲛⲉⲙ ⲡⲉϥⲏⲓ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲟⲩⲙⲏϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲕⲟⲣⲓⲛⲑⲟⲥ ⲉⲩⲥⲱⲧⲉⲙ ⲛⲁⲩⲛⲁϩϯ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲩϭⲓⲱⲙⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ⲡⲉϫⲉ Ⲡ⳪ ⲇⲉ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲟⲩϩⲟⲣⲁⲙⲁ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲁⲗⲗⲁ ⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲭⲁⲣⲱⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲭⲏ ⲛⲉⲙⲁⲕ ⲟⲩⲟϩ ⳿ⲛⲛⲉ ⳿ϩⲗⲓ ⲧⲱⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲕ ⳿ⲉϯ⳿ⲙⲕⲁϩ ⲛⲁⲕ ϫⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲏⲓ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲛⲗⲁⲟⲥ ϧⲉⲛ ⲧⲁⲓⲡⲟⲗⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ⲁϥϩⲉⲙⲥⲓ ⲇⲉ ⳿ⲛⲟⲩⲣⲟⲙⲡⲓ ⲛⲉⲙ ⳿ⲛ⳿ⲁⲃⲟⲧ ⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ⲅⲁⲗⲓⲱⲛ ⲇⲉ ⲉϥⲟⲓ ⳿ⲛⲁⲛⲑⲩⲡⲁⲧⲟⲥ ⳿ⲉϯ⳿ⲁⲭⲁⲓ⳿ⲁ ⲁⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲩⲥⲟⲡ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⲁⲩⲉⲛϥ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲫⲁⲓ ⲑⲱⲧ ⳿ⲙ⳿ⲡϩⲏⲧ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⳿ⲉⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲪϯ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ⲉϥⲛⲁⲟⲩⲱⲛ ⲇⲉ ⳿ⲛⲣⲱϥ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲡⲉϫⲉ ⲅⲁⲗⲓⲱⲛ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ϫⲉ ⳿⳿ⲉⲛⲉ ⲟⲩⲟⲛ ϭⲓ ⳿ⲛϫⲟⲛⲥ ⲓⲉ ⲟⲩϩⲱⲃ ⲉϥϩⲱⲟⲩ ⳿ⲙⲡⲟⲛⲏⲣⲟⲛ ⳿ⲱ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲕⲁⲗⲱⲥ ⲛⲁⲓⲛⲁⲉⲣⲁⲛⲉⲭⲉⲥⲑⲉ ⳿ⲙⲙⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ⲓⲥϫⲉ ⲇⲉ ϩⲁⲛⲍⲏⲧⲏⲙⲁ ⲛⲉ ⲉⲑⲃⲉ ⲟⲩⲥⲁϫⲓ ⲛⲉⲙ ϩⲁⲛⲣⲁⲛ ⲛⲉⲙ ⲡⲉⲧⲉⲛⲛⲟⲙⲟⲥ ⳿ⲉⲣⲉⲧ⳿ⲉⲛⲉⲣⲱϣⲓ ⳿ⲛⲑⲱⲧⲉⲛ ϯⲟⲩ⳿ⲱϣ ⳿ⲁⲛⲟⲕ ⲁⲛ ⳿ⲉⲉⲣⲣⲉϥϯϩⲁⲡ ⳿ⲛⲧⲉ ⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ⲟⲩⲟϩ ⲁⲩϩⲓⲧⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲃⲏⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲛⲥⲱⲥⲑⲉⲛⲏⲥ ⲡⲓⲁⲣⲭⲏⲥⲩⲛⲁⲅⲱⲅⲟⲥ ⲁⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟϥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲃⲏⲙⲁ ⲟⲩⲟϩ ⲛⲁⲥⲉⲣⲙⲉⲗⲉⲥⲑⲉ ⲁⲛ ⳿ⲛⲅⲁⲗⲓⲱⲛ ⲉⲑⲃⲉ ⳿ϩⲗⲓ ⳿ⲛⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛⲕⲉⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϧⲁⲧⲉⲛ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲁϥⲉⲣⲁⲡⲟⲇⲁⲍⲉⲥⲑⲉ ⲛⲱⲟⲩ ⲁϥⲉⲣϩⲱⲧ ⳿ⲉ⳿ⲧⲤⲩⲣⲓ⳿ⲁ ⲉⲥⲛⲉⲙⲁϥ ⳿ⲛϫⲉ ⳿ⲡⲣⲓⲥⲕⲩⲗⲗⲁ ⲛⲉⲙ ⲁⲕⲩⲗⲗⲁⲥ ⳿ⲉⲁϥϣⲉⲡ ϫⲱϥ ϧⲉⲛ ⲕⲉⲛⲭⲣⲉⲉⲥ ⲛⲁϥϧⲉⲛ ⲟⲩⲉⲩⲭⲏⲅⲁⲣ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲉⲫⲉⲥⲟⲥ ⲟⲩⲟϩ ⲁϥⲥⲉϫⲡ ⲛⲏ⳿ⲙⲙⲁⲩ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲉⲧⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲁϥⲥⲁϫⲓ ⲛⲉⲙ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ⲉⲩⲧⲱⲃϩ ⲇⲉ ⳿ⲙⲙⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣ ⲟⲩⲛⲓϣϯ ⳿ⲛⲥⲏⲟⲩ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲙⲡⲉϥⲟⲩⲱϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ⲁⲗⲗⲁ ⲁϥⲉⲣⲁⲡⲟⲇⲁⲍⲉⲥⲑⲉ ⲛⲱⲟⲩ ⳿ⲉⲁϥϫⲟⲥ ϫⲉ ϯⲛⲁⲕⲟⲧⲧ ϩⲁⲣⲱⲧⲉⲛ ϧⲉⲛ ⲡⲉⲧⲉϩⲛⲉ Ⲫϯ ⲁϥⲉⲣϩⲱⲧ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲉⲫⲉⲥⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲁⲛⲧⲓⲟⲭⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣⲟⲩⲥⲏⲟⲩ ⳿ⲙⲙⲁⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲉϥⲥⲓⲛⲓ ⲕⲁⲧⲁ ⲙⲁ ⳿ⲛⲧⲉ ϯⲭⲱⲣⲁ ⳿ⲛⲧⲉ ϯⲅⲁⲗⲁⲧⲓ⳿ⲁ ⲛⲉⲙ ϯ⳿ⲫⲣⲓⲕⲓⲁ ⲉϥⲧⲁϫⲣⲟ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲒⲟⲩⲇⲁⲓ ⲇⲉ ⲡⲉ ⲡⲉϥⲣⲁⲛ ⲡⲉ ⳿ⲁⲡⲉⲗⲗⲏⲥ ⳿ⲉⲟⲩⲣⲉⲙⲣⲁⲕⲟϯ ⲡⲉ ϧⲉⲛ ⲡⲉϥⲅⲉⲛⲟⲥ ⳿ⲉⲟⲩⲣⲱⲙⲓ ⲡⲉ ⳿ⲛⲗⲟⲅⲓⲙⲟⲥ ⳿ⲉⲁϥⲉⲣⲕⲁⲧⲁⲛⲧⲁⲛ ⳿ⲉⲉⲫⲉⲥⲟⲥⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ⲫⲁⲓ ⲛⲉ ⲁⲩⲉⲣⲕⲁⲑⲏⲕⲓⲛ ⳿ⲙⲙⲟϥ ⳿ⲉⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ Ⲡ⳪ ⲟⲩⲟϩ ⲉϥϧⲏⲙ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲛⲁϥⲥⲁϫⲓ ⲟⲩⲟϩ ⲛⲁϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⲉⲑⲃⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲧⲉϥⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ⲫⲁⲓ ⲇⲉ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⳿ⲡⲣⲓⲥⲕⲩⲗⲗⲁ ⲛⲉⲙ ⲁⲕⲩⲗⲗⲁ ⲁⲩϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲧⲁⲙⲟϥ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⳿ⲉⲡⲓⲙⲱⲓⲧ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ⲉϥⲟⲩⲱϣ ⲇⲉ ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉϯⲁⲭⲁⲓ⳿ⲁ ⲁⲩϯⲉⲣⲟⲩⲟⲧ ⲛⲁϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲁⲩ⳿ⲥϧⲁⲓ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ϫⲉ ⳿ⲛⲥⲉϣⲟⲡϥ ⳿ⲉⲣⲱⲟⲩ ⲫⲁⲓ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲓ ⲁϥⲉⲣ ⲟⲩⲛⲟϥⲣⲓ ⳿ⲉⲙⲁϣⲱ ⳿ⲛⲛⲏ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ⲛⲁϥⲥⲟϩⲓ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⳿ⲛⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲉϥⲧⲁⲙⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ Ⲓⲏ̅ⲥ̅ ");
INSERT INTO copcnt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲣⲉ ⲁⲡⲉⲗⲗⲏⲥ ϧⲉⲛ ⲕⲟⲣⲓⲛⲑⲟⲥ ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⳿ⲉⲧⲁϥⲥⲉⲡ ⲛⲓⲙⲁ ⲉⲧⲥⲁ⳿ⲡϣⲱⲓ ⲉⲑⲣⲉϥ⳿ⲓ ⳿ⲉⲉⲫⲉⲥⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲓⲙⲓ ⳿ⲛϩⲁⲛⲙⲁⲑⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲁⲛ ⳿ⲁⲣⲉⲧⲉⲛϭⲓ ⳿ⲙⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲉⲧ⳿ⲁⲣⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲁⲗⲗⲁ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛⲥⲱⲧⲉⲙ ⲣⲱ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ϣⲟⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲉⲧⲁⲩ⳿ⲉⲙⲥ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲡⲓⲱⲙⲥ ⳿ⲛⲧⲉ Ⲓⲱⲁⲛⲛⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ Ⲓⲱⲁⲛⲛⲏⲥ ⲙⲉⲛ ⲁϥϯⲱⲙⲥ ϧⲉⲛ ⲟⲩⲙⲱⲟⲩ ⳿ⲙⲙⲉⲧⲁⲛⲟⲓⲁ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲛⲁϩϯ ⳿ⲉⲡⲉⲑⲛⲏⲟⲩ ⲙ⳿ⲉⲛⲉⲛⲥⲱϥ ⳿ⲉⲧⲉ Ⲓⲏ̅ⲥ̅ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⲁⲩϭⲓⲱⲙⲥ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ⲟⲩⲟϩ ⳿ⲉⲧⲁ ⲡⲁⲩⲗⲟⲥ ⲭⲁ ϫⲓϫ ⳿ⲡⲉϫⲱⲟⲩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲛⲁⲩⲥⲁϫⲓ ⲇⲉ ϧⲉⲛ ⳿ⲫⲗⲁⲥ ⲟⲩⲟϩ ⲛⲁⲩⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲧⲏⲣⲟⲩ ⲛⲁⲩⲉⲣ ⲓ̅ⲃ̅ ⳿ⲛⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","⳿ⲉⲧⲁϥϣⲉ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲁϥⲟⲩⲟⲛϩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲁⲃⲟⲧ ⲉϥⲥⲁϫⲓ ⲟⲩⲟϩ ⲉϥⲑⲱⲧ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ⲉⲧⲁ ϩⲁⲛⲟⲩⲟⲛ ⲇⲉ ⲉⲣⲛⲁϣⲧϩⲏ ⲧ ⲉⲩⲟⲓ ⳿ⲛⲁⲧⲥⲱⲧⲉⲙ ⲉⲩⲥⲁϫⲓ ⲉϥϩⲱⲟⲩ ⳿ⲛⲥⲁ ⲡⲓⲙⲱⲓⲧ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲡⲓⲙⲏϣ ⲁϥⲫⲱⲧ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲁϥⲫⲱⲣϫ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲃⲟⲗ ⲉϥⲥⲁϫⲓ ⳿ⲙⲙⲏⲛⲓ ϧⲉⲛ ϯ⳿ⲥⲭⲟⲗⲏ⳿ⲛⲧⲉ ⲧⲩⲣⲁⲛⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ⲫⲁⲓ ⲇⲉ ⲛⲁϥⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲛⲣⲟⲙⲡⲓ ⲃ̅ϯ ϩⲱⲥⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ϯ ⲁⲥⲓⲁ ⳿ⲛⲧⲟⲩⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲡ⳪ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ⲛⲁϥ⳿⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛϩⲁⲛϫⲟⲙ ⳿ⲛϫⲉ Ⲫϯ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⲁⲛ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲉⲛϫⲓϫ ⳿ⲙⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ϩⲱⲥⲇⲉ ⳿ⲛⲥⲉϭⲓ ⳿ⲛϩⲁⲛⲥⲟⲩⲇⲁⲣⲓⲟⲛ ⲛⲉⲙ ϩⲁⲛⲥⲓⲙⲓⲕⲩⲛⲑⲓⲛⲟⲛ ⳿ⲉⲃⲟⲗϩⲓ ⲡⲉϥⲥⲱⲙⲁ ⳿ⲛⲥⲉⲭⲁⲩ ϩⲓϫⲉⲛ ⲛⲏⲉⲧϣⲱⲛⲓ ⲟⲩⲟϩ ⲛⲉϣⲁⲩϣⲉⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲱⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓϣⲱⲛⲓ ⲟⲩⲟϩ ⲛⲓⲡ͞ⲛⲁ̅ ⲉⲧϩⲱⲟⲩ ⲛⲁⲩⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ⲁⲩϩⲓⲧⲟⲧⲟⲩ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲩⲕⲱϯ ⳿ⲛⲉⲝⲟⲣⲅⲓⲥⲧⲏⲥ ⳿ⲉϫⲉ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅ ⳿ⲉϫⲉⲛ ⲛⲏ⳿ⲉⲧⲉ ⲛⲓⲡ͞ⲛⲁ̅ ⲉⲧϩⲱⲟⲩ ϩⲓⲱⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϯⲧⲁⲣⲕⲟ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ⲫⲏ⳿ⲉⲧⲉ ⲡⲁⲩⲗⲟⲥ ϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ⲛⲉ ⲟⲩⲟⲛ ⲍ̅ ⲇⲉ ⳿ⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϫⲉ ⳿ⲥⲕⲉⲩⲁ ⳿ⲉⲟⲩⲒⲟⲩⲇⲁⲓ ⳿ⲛⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲉⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲧϩⲱⲟⲩ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ Ⲓⲏ̅ⲥ̅ ϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⳿ⲡⲕⲉⲡⲁⲩⲗⲟⲥ ϯ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲓⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ⲟⲩⲟϩ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲧϩⲱⲟⲩ ⲛⲉⲙⲁϥ ⲁϥⲉⲣ⳪ ⳿ⲉⲣⲱⲟⲩ ⲉⲩⲥⲟⲡ ⲁϥϫⲉⲙϫⲟⲙ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ϩⲱⲥⲧⲉ ⳿ⲛⲥⲉⲫⲱⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲏⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲩⲃⲏϣ ⲉⲣⲡⲉϫⲱⲟⲩ ⲫⲏϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ⲫⲁⲓ ⲇⲉ ⲁϥϣⲱⲡⲓ ⲉϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ⳿ⲉⲫⲉⲥⲟⲥ ⲟⲩⲟϩ ⲟⲩϩⲟϯ ⲁⲥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲡⲉϫⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲛⲁϥⲛⲏⲟⲩ ⳿ⲛϭⲓⲥⲓ ⳿ⲛϫⲉ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲏ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⲛⲁⲩⲛⲏⲟⲩ ⲡⲉ ⲉⲩⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲩϫⲱ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ϩⲁⲛⲙⲏϣ ⲇⲉ ϧⲉⲛ ⲛⲏ⳿ⲉⲛⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲓⲙⲉⲧⲡⲉⲣⲓⲉⲣⲅⲟⲥ ⳿ⲉⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲟⲩϫⲱⲙ ⲁⲩⲣⲟⲕϩⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲁⲩϥⲓⲱⲡ ⳿ⲛⲛⲟⲩⲧⲓⲙⲏ⳿ⲉⲁⲩϫⲉⲙⲟⲩ ⳿ⲉⲟⲩⲟⲛ ⲉ̅ ⳿ⲛ⳿ⲑⲃⲁ ⳿ⲛϩⲁⲧ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ⲡⲁⲓⲣⲏϯ ⲇⲉ ϧⲉⲛ ⲟⲩⲁⲙⲁϩⲓ ⲁϥⲁⲓⲁⲓ ⳿ⲛϫⲉ ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲠ⳪ ⲟⲩⲟϩ ⲁϥϫⲉⲙϫⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲁⲓ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ⲭⲁⲥ ϧⲉⲛ ⲡⲉϥⲡ͞ⲛⲁ̅ ϫⲉ ⲁϥϣⲁⲛⲙⲟⲩϣⲧ ⳿ⲛ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ⲛⲉⲙ ϯⲁⲭⲁⲓⲁ ⳿ⲛⲧⲉϥϣⲉ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲁϥϫⲟⲥ ϫⲉ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲓϣⲉ ⳿ⲙⲙⲁⲩ ϩⲱϯ ⳿ⲛⲧⲁⲛⲁⲩ ⳿ⲉ⳿ⲧⲕⲉⲣⲱⲙⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ⲁϥⲟⲩⲱⲣⲡ ⲇⲉ ⳿ⲛⲃ̅ ⳿ⲉ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ϧⲉⲛ ⲛⲏⲉⲧϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ ⲧⲓⲙⲟⲑⲉⲟⲥ ⲛⲉⲙ ⲉⲣⲁⲥⲧⲟⲥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲁϥⲉⲣ ⲟⲩ⳿ⲭⲣⲟⲛⲟⲥ ϧⲉⲛ ϯⲁⲥⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲡⲓⲥⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲛϫⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁⲛ ⲉⲑⲃⲉ ⲡⲓⲙⲱⲓⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ⲟⲩⲁⲓ ⲅⲁⲣ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲇⲓⲙⲏⲧⲣⲓⲟⲥ ⲟⲩⲙⲁⲛⲕ ϩⲁⲧ ⲉϥⲙⲟⲛⲕ ⳿ⲛϩⲁⲛⲉⲣⲫⲏⲟⲩ⳿ⲓ ⳿ⲛϩⲁⲧ ⳿ⲛⲧⲉ ϯⲁⲣⲧⲉⲙⲓⲥ ⲛⲁϥϯ ⳿ⲛϩⲁⲛⲙⲏϣ ⳿ⲛϩⲱⲃ ⳿ⲛⲛⲓⲧⲉⲭⲛⲓⲧⲏⲥ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ⲛⲁⲓ ⳿ⲉⲧⲁϥⲑⲟⲩⲱⲧⲟⲩ ⲛⲉⲙ ⲛⲓⲕⲉⲉⲣⲅⲁⲧⲏⲥ ⳿ⲉⲧⲉ⳿ⲙ⳿ⲡⲕⲱϯ ⳿ⲛⲛⲁⲓ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲁⲓϫⲓⲛⲉⲣϩⲱⲃ ⳿ⲁⲣⲉ ϯⲙⲉⲧⲣⲉϥ⳿ϫⲫⲉ ϩⲏⲟⲩ ϣⲟⲡ ⲛⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲛⲁⲩ ⲟⲩⲟϩ ⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ϫⲉ ⲟⲩ ⲙⲟⲛⲟⲛ ⲇⲉ ⳿ⲉⲫⲉⲥⲟⲥ ⳿ⲙⲙⲁⲩⲁⲧⲥ ⲁⲗⲗⲁ ⳿ⲥⲭⲉⲇⲟⲛ ϧⲉⲛ ϯⲁⲥⲓⲁ ⲧⲏⲣⲥ ⳿ⲁ ⲫⲁⲓ ϫⲉ ⲡⲁⲩⲗⲟⲥ ⲟⲩ⳿ⲱⲧⲉⲃ ⳿ⲛⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲏϣ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϩⲁⲛⲛⲟⲩϯ ⲁⲛ ⲛⲉ ⲛⲁⲓ ⲉⲧⲟⲩⲑⲁⲙⲓⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϩⲁⲛⲙⲟⲩⲛⲕ ⳿ⲛϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ⲟⲩ ⲙⲟⲛⲟⲛ ⲡⲁⲓⲙ⳿ⲉⲣⲟⲥ ⲉⲑⲛⲁϣⲱⲡⲓ ⲛⲁⲛ ⳿ⲉⲟⲩⲕⲩⲛⲇⲓⲛⲟⲥ ⲉⲑⲣⲉⲛ⳿ⲓ ⲉⲩⲥⲟϩⲓ ⲁⲗⲗⲁ ⲡⲓⲕⲉⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ ϯⲛⲓϣϯ ⳿ⲛⲛⲟⲩϯ ϯⲁⲣⲧⲉⲙⲓⲥ ⳿ⲛⲥⲉⲛⲁⲟⲡϥ ⲁⲛ ϫⲉ ⳿ⲉ⳿ϩⲗⲓ ⲟⲩⲟϩ ⲥⲉⲛⲁϣⲟⲣϣⲉⲣ ⳿ⲛⲧⲉⲥⲙⲉⲧⲛⲓϣϯ ⲑⲁⲓ ⳿ⲉⲧⲉ ϯⲁⲥⲓⲁ ⲧⲏⲣⲥ ⲛⲉⲙ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲧⲏⲣⲥ ⲉⲣⲥⲉⲃⲉⲥⲑⲉ ⳿ⲙⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲙⲟϩ ⳿ⲛϫⲱⲛⲧ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲛⲓϣϯ ⲧⲉ ϯⲁⲣⲧⲉⲙⲓⲥ ⳿ⲛⲧⲉ ⲛⲁ ⳿ⲉⲫⲉⲥⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ⲟⲩⲟϩ ⲁⲥⲙⲟϩ ⳿ⲛϫⲉ ϯⲡⲟⲗⲓⲥ ⳿ⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⲁⲩϭⲟϫⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲟⲩⲟⲩⲟⲓ ⲉⲩⲥⲟⲡ ⳿ⲉⲡⲓⲑⲉⲁⲧⲣⲟⲛ ⲁⲩϩⲱⲗⲉⲙ ⳿ⲛⲅⲁⲓⲟⲥ ⲛⲉⲙ ⳿ⲁⲣⲓⲥⲧⲁⲣⲭⲟⲥ ⳿ⲉϩⲁⲛⲣⲉⲙ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ⲛⲉ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ⲡϣⲉⲙⲙⲟ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ⲉϥⲟⲩⲱϣ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲙⲏϣ ⲛⲁⲩⲭⲱ ⳿ⲙⲙⲟϥ ⲁⲛ ⲡⲉ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲁⲣⲭ ⲱⲛ ⳿ⲛⲧⲉ ϯⲁⲥⲓⲁ ⲉⲩⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲣⲟϥ ⲁⲩⲟⲩⲱⲣⲡ ϩⲁⲣⲟϥ ⲉⲩϯϩⲟ ⳿ⲉ⳿ϣⲧⲉⲙ⳿ⲑⲣⲉϥⲧⲏⲓϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⳿ⲉⲡⲓⲑⲉⲁⲧⲣⲟⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲙⲉⲛ ⲟⲩⲛ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲛⲕⲉϩⲱⲃ ⲛⲉⲁ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲅⲁⲣ ⳿ϣⲑⲟⲣⲧⲉⲣ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲣⲉ ⲡⲟⲩϩⲟⲩⲟ ⲥⲱⲟⲩⲛ ⲁⲛ ϫⲉ ⳿ⲉⲧⲁⲩⲑⲱⲟⲩϯ ⲉⲑⲃⲉ ⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","⳿ⲉⲃⲟⲗ ⲇⲉ ϧⲉⲛ ⲡⲓⲙⲏϣ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲁⲗⲉⲝⲁⲛⲇⲣⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲗⲉⲝⲁⲛⲇⲣⲟⲥ ⲁϥϭⲱⲣⲉⲙ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲧⲉϥϫⲓϫ ⲉϥⲟⲩⲱϣ ⳿ⲉⲉⲣⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ ⳿ⲙⲡⲓⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","⳿ⲉⲧⲁⲩ⳿ⲉⲙⲓ ⲇⲉ ϫⲉ ⲟⲩⲒⲟⲩⲇⲁⲓ ⲡⲉ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ϧⲣⲱⲟⲩ ⳿ⲛⲟⲩⲱⲧ ⳿ⲛⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲛⲁⲩ ⲟⲩⲛⲟⲩ ⳿ⲥⲛⲟⲩϯ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⲟⲩⲛⲓϣϯ ⲧⲉ ϯⲁⲣⲧⲉⲙⲓⲥ ⳿ⲛⲧⲉ ⲛⲁ ⲉⲫⲉⲥⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","⳿ⲉⲧⲁϥ⳿ⲑⲣⲉ ⲡⲓⲙⲏϣ ⲇⲉ ϩⲉⲣⲓ ⳿ⲛϫⲉ ⲡⲓ⳿ⲅⲣⲁⲙⲙⲁⲧⲉⲩⲥ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲣⲉⲙⲉⲫⲉⲥⲟⲥ ⲛⲓⲙ ⲅⲁⲣ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉ⳿ⲛ⳿ϥⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲛ⳿ⲧⲡⲟⲗⲓⲥ ⳿ⲛⲛⲓⲣⲉⲙⲉⲫⲉⲥⲟⲥ ϫⲉ ⳿ⲥⲟⲓ ⳿ⲛⲛⲉⲱⲕ⳿ⲉⲣⲟⲥ ⳿ⲛⲧⲉ ϯⲛⲓϣϯ ⳿ⲛⲁⲣⲧⲉⲙⲓⲥ ⲛⲉⲙ ⲡⲓⲇⲓⲟⲡⲉⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲟⲩⲛ ϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲛⲁⲓ ⳿ⲥⲉⲙ⳿ⲡϣⲁ ⲟⲩⲛ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲥⲙⲟⲛⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣ ⳿ϩⲗⲓ ⳿ⲛϩⲱⲃ ϧⲉⲛ ⲟⲩⲁⲥⲓⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ⲁⲧⲉⲧⲉⲛ⳿ⲓⲛⲓ ⲅⲁⲣ ⳿ⲛⲛⲁⲓⲣⲱⲙⲓ ⳿ⲙⲛⲁⲓ ⲟⲩⲇⲉ ϩⲁⲛⲕⲁⲗⲡⲉⲣⲫⲉⲓ ⲁⲛ ⲛⲉ ⲟⲩⲇⲉ ⲥⲉϫⲉⲟⲩ⳿ⲁ ⲁⲛ ⳿⳿ⲉⲛⲉⲧⲉⲛⲛⲟⲩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ⲓⲥϫⲉ ⲟⲩⲛ ⲇⲓⲙⲏⲧⲣⲓⲟⲥ ⲛⲉⲙ ⲛⲓⲕ⳿ⲉⲧⲉⲭ ⲛⲓⲧⲏⲥ ⲉⲑⲛⲉⲙⲁϥ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲛⲟⲩⲥⲁϫⲓ ϧⲁ ⲟⲩⲁⲓ ⲥⲉⲛⲁ⳿ⲓⲛⲓ ⳿ⲛⲛⲓⲁⲅⲟⲣⲉⲟⲥ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⲁⲛⲑⲩⲡⲁⲧⲟⲥ ϣⲟⲡ ⲙⲁⲣⲟⲩⲥⲉⲙⲓ ⳿ⲉⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ⲓⲥϫⲉ ⲇⲉ ⳿ⲁⲣⲉⲧⲉⲛⲕⲱϯ ⳿ⲛⲥⲁ ⲕⲉϩⲱⲃ ϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲛⲛⲟⲙⲓⲙⲟⲛ ⲉⲩ⳿ⲉⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ⲕⲉ ⲅⲁⲣ ⲧ⳿ⲉⲛⲉⲣⲕⲩⲛⲇⲓⲛⲉⲩⲓⲛ ⲉⲑⲣⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟⲛ ⲉⲑⲃⲉ ⲡⲓ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲧⲉ ⲫⲟⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲗⲱⲓϫⲓ ϣⲟⲡ ⲑⲁⲓ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲛ ⳿ⲉϯⲗⲟⲅⲟⲥ ⲉⲑⲃⲏⲧⲥ ϧⲁ ⲡⲓ⳿ϣⲑⲟⲣⲧⲉⲣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ⲟⲩⲟϩ ⲛⲁⲓ ⳿ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲁϥⲭⲱ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲉⲃⲟⲗ . ");
INSERT INTO copcnt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲉϥⲟⲩⲱ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲱⲣⲡ ⳿ⲛⲥⲁ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲟⲩⲟϩ ⲁϥϯⲛⲟⲙϯ ⲛⲱⲟⲩ ⲁϥⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲙⲙⲱⲟⲩ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉϣⲉ ⳿ⲉ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϯⲛⲟⲙϯ ⲛⲱⲟⲩ ϧⲉⲛ ⲟⲩⲥⲁϫⲓ ⲉϥⲟϣ ⲁϥ⳿ⲓ ⳿ⲉϯⲉⲗⲗⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","⳿ⲉⲧⲁϥⲉⲣ ⲅ̅ ⲇⲉ ⳿ⲛ⳿ⲁⲃⲟⲧ ⳿ⲙⲙⲁⲩ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲥⲟϭⲛⲓ ⲉϥϩⲱⲟⲩ ⲉⲑⲃⲏⲧϥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉϥⲛⲁ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲧⲤⲩⲣⲓ⳿ⲁ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩⲥⲟϭⲛⲓ ⲉⲑⲣⲉϥⲕⲟⲧϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ⲛⲁϥⲛⲉⲙⲁϥ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲥⲱⲥⲓⲡⲁⲧⲣⲟⲥ ⳿ⲛⲧⲉ ⲡⲩⲣⲣⲟⲥ ⲡⲓⲣⲉⲙⲃⲉⲣⲟⲓ⳿ⲁ ⲛⲁ ⲑⲉⲥⲥⲁⲗⲟⲛⲓⲕⲏⲇⲉ ⳿ⲁⲣⲓⲥⲧⲁⲣⲭⲟⲥ ⲛⲉⲙ ⲥⲉⲕⲟⲩⲛⲑⲟⲥ ⲛⲉⲙ ⲅⲁⲓⲟⲥ ⲡⲓⲣⲉⲙⲧⲉⲣⲃⲏⲛⲉⲙ ⲧⲓⲙⲟⲑⲉⲟⲥ ⲛⲁ ϯⲁⲥⲓⲁ ⲇⲉ ⲧⲩⲭⲓⲕⲟⲥ ⲛⲉⲙ ⳿ⲧⲣⲟⲫⲏⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ⲛⲁⲓ ⲇⲉ ⳿ⲉⲧⲁⲩⲉⲣϣⲟⲣⲡ ⳿ⲉⲣⲟⲛ ⲁⲩⲟϩⲓ ⲛⲁⲛ ϧⲉⲛ ⳿ⲧⲣⲱⲁⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","⳿ⲁⲛⲟⲛ ⲇⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲁⲧϣⲉⲙⲏⲣ ⲁⲛⲉⲣϩⲱⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲫⲓⲗⲓⲡⲡⲟⲓⲥ ⲟⲩⲟϩ ⲁⲛ⳿ⲓ ϣⲁⲣⲱⲟⲩ ⳿ⲉ⳿ⲧⲣⲱⲁⲥ ⳿ⲙⲡ⳿ⲉⲛⲉ̅ ⲟⲩⲟϩ ⲁⲛϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲍ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ϧⲉⲛ ⳿ⲫⲟⲩⲁⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲃⲁⲧⲟⲛ ⲉⲧⲁⲛⲑⲱⲟⲩϯ ⳿ⲉⲫⲱϣ ⳿ⲛⲟⲩⲱⲓⲕ ⲛⲁϥⲥⲁϫⲓ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙⲱⲟⲩ ⲉϥⲛⲁ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲛⲁϥⲫⲱⲣϣ ⲇⲉ ⳿ⲙⲡⲓⲥⲁϫⲓ ⳿ⲉⲃⲟⲗ ϣⲁ ⳿ⲧⲫⲁϣⲓ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲛⲗⲁⲙⲡⲁⲥ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲥⲁ⳿ⲡϣⲱⲓ ⲡⲓⲙⲁ ⳿ⲉⲛⲁⲩⲑⲟⲩⲏⲧ ⳿ⲛϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ⲛⲁϥϩⲉⲙⲥⲓ ⲇⲉ ⲡⲉ ⳿ⲛϫⲉ ⲟⲩϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲉⲩⲧⲩⲭⲟⲥ ϩⲓϫⲉⲛ ⲡⲓϣⲟⲩϣⲧ ⲉϥⲟⲃϣ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛⲉⲛⲕⲟⲧ ⳿ⲉⲣⲉ ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲥⲁϫⲓ ⳿ⲁ ⲡⲓⲉⲛⲕⲟⲧ ⲥⲟⲕϥ ⳿ⲛϩⲟⲩⲟ ⲁϥϩⲉⲓ ⳿ⲉⲡⲉⲥⲏⲧ ϧⲉⲛ ϯⲙⲁϩⲅ̅ϯ ⳿ⲛⲟⲩⲁϩⲙⲓ ⲟⲩⲟϩ ⲁⲩϥⲓⲧϥ ⲉϥⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ⲁϥ⳿ⲓ ⲇⲉ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϫⲱϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲙⲟⲗϫϥ ⳿ⲉϧⲏⲧϥ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲙⲡⲉⲣ⳿ϣⲑⲟⲣⲧⲉⲣ ⲧⲉϥ ⲯⲩⲭⲏ ⲅⲁⲣ ⳿ⲛϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","⳿ⲉⲧⲁϥϣⲉ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲫⲱϣ ⳿ⲙⲡⲓⲱⲓⲕ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϫⲉⲙϯⲡⲓ ⲁϥⲥⲱⲕ ⳿ⲙⲡⲓⲥⲁϫⲓ ϣⲁⲧⲉ ⳿ⲫⲟⲩⲱⲓⲛⲓ ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁϥ⳿ⲓ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ⲁⲩ⳿ⲓⲛⲓ ⲇⲉ ⳿ⲙⲡⲓ⳿ⲁⲗⲟⲩ ⲉϥⲱⲛϧ ⲟⲩⲟϩ ⲁⲩϭⲓ ⳿ⲛⲟⲩⲙⲉⲧⲑⲁⲧϩⲏ ⲧ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","⳿ⲁⲛⲟⲛ ⲇⲉ ⲁⲛⲁⲗⲏⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲡⲓϫⲟⲓ ⲁⲛ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲁⲥⲥⲟⲥ ⲉⲛⲑⲱϣ ⳿ⲉⲧⲁⲗⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉ ⲁϥϩⲟⲛϩⲉⲛ ⲅⲁⲣ ⳿ⲉⲧⲟⲧⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲉϥⲛⲁⲙⲟϣⲓ ⳿ⲛⲣⲁⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","⳿ⲉⲧⲁϥϯⲙⲁϯ ⲇⲉ ⳿ⲉⲣⲟⲛ ϧⲉⲛ ⲁⲥⲥⲟⲥ ⲁⲛⲧⲁⲗⲟϥ ⲁⲛ⳿ⲓ ⳿ⲉⲙⲓⲗⲓⲧⲓⲛⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲛⲉⲣϩⲱⲧ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲛϯⲙⲁϯ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲭⲓⲟⲥ ⳿ⲛϩⲁⲛ⳿ⲁⲣⲟⲩϩⲓ ⲇⲉ ⲁⲛ⳿ⲓ ⳿ⲉⲥⲁⲙⲟⲥ ⲙ⳿ⲉⲛⲉⲛⲥⲱϥ ⲁⲛ⳿ⲓ ⳿ⲉⲙⲓⲗⲏⲧⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ⲛⲉ ⲁϥⲑⲱϣ ⲅⲁⲣ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲉⲣϩⲱⲧ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲉⲫⲉⲥⲟⲥ ϩⲟⲡⲱⲥ ϫⲉ ⳿ⲛⲛⲉϥⲱⲥⲕ ϧⲉⲛ ϯⲁⲥⲓⲁ ⲛⲁϥⲓⲏⲥ ⲅⲁⲣ ⲡⲉ ϩⲓⲛⲁ ⲓⲥϫⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉϥⲉⲣ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲛϯⲡⲉⲛⲧⲏⲕⲟⲥⲧⲏϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","⳿ⲉⲃⲟⲗ ⲇⲉ ϧⲉⲛ ⲙⲓⲗⲏⲧⲟⲥ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲉⲉⲫⲉⲥⲟⲥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ϣⲁⲣⲟϥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⲓⲥϫⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛϩⲟⲩⲓⲧ ⳿ⲉⲧⲁⲓ⳿ⲓ ⳿ⲉϯⲁⲥⲓⲁ ϫⲉ ⲁⲓϣⲱⲡⲓ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ ⳿ⲙⲡⲁⲓⲥⲏⲟⲩ ⲧⲏⲣϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ⲉⲓⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙⲠ⳪ ϧⲉⲛ ⲑⲉⲃⲓ⳿ⲟ ⳿ⲛϩⲏⲧ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ϩⲁⲛⲉⲣⲙⲱⲟⲩ⳿ⲓ ⲛⲉⲙ ⲛⲓⲡⲓⲣⲁⲥⲙⲟⲥ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ϧⲉⲛ ⲛⲓⲥⲟϭⲛⲓ ⲉⲧϩⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉ⳿ⲙⲡⲓϩⲉⲡ ⳿ϩⲗⲓ ϧⲉⲛ ⲛⲏ⳿ⲉⲧⲉⲣⲛⲟϥⲣⲓ ⳿ⲛⲟⲩϣⲉⲛ ⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ ⲛⲉⲙ ⳿ⲉϯ⳿ⲥⲃⲱ ⲛⲱⲧⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ⲉⲓⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲇⲏⲙⲟⲥⲓⲁ ⲛⲉⲙ ⲕⲁⲧⲁ ⲏⲓ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⳿ⲛϯⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲫϯ ⲛⲉⲙ ⲡⲓⲛⲁϩϯ ⳿ⲉⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ⲟⲩⲟϩ ϯⲛⲟⲩ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ⲉⲓⲥⲟⲛϩ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ϯⲛⲁϣⲉⲛⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ϯⲥⲱⲟⲩⲛ ⲁⲛ ⳿ⲙⲡⲉⲑⲛⲁ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲓ ⳿ⲛϧⲏⲧⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","⳿ⲡⲗⲏⲛ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⳿ϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲏⲓ ⲕⲁⲧⲁ ⲡⲟⲗⲓⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲥⲉⲟϩⲓ ⲛⲁⲕ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲥⲛⲁⲩϩ ⲛⲉⲙ ϩⲁⲛ⳿ⲑⲗⲩⲯⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ⲁⲗⲗⲁ ⲧⲁⲯⲩⲭⲏ ϯⲭⲱ ⳿ⲙⲙⲟⲥ ⲁⲛ ϫⲉ ⳿ⲥⲧⲁⲓⲏⲟⲩⲧ ⳿ⲛⲧⲟⲧ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲛⲥⲁϫⲓ ϣⲁ ϯϫⲱⲕ ⳿ⲙⲡⲁ⳿ⲇⲣⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ϯⲇⲓ⳿ⲁⲕⲟⲛⲓ⳿ⲁ ⲑⲏ⳿ⲉⲧⲁⲓϭⲓⲧⲥ ⳿ⲛⲧⲉⲛ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲉⲣⲙⲉⲑⲣⲉ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ⲟⲩⲟϩ ϯⲛⲟⲩ ϩⲏⲡⲡⲉ ⳿ⲁⲛⲟⲕ ϯ⳿ⲉⲙⲓ ϫⲉ ⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲡⲁϩⲟ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲛⲏⲉⲧⲁⲓⲥⲓⲛⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲓϩⲓⲱⲓϣ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ⲉⲑⲃⲉ ⲫⲁⲓ ϯⲉⲣⲙⲉⲑⲣⲉ ⲛⲱⲧⲉⲛ ϧⲉⲛ ⲡⲁⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲫⲟⲟⲩ ϫⲉ ϯⲟⲩⲁⲃ ⳿ⲁⲛⲟⲕ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲉⲧⲉⲛ⳿ⲥⲛⲟϥ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲓϩⲟⲡⲧ ⳿ⲉ⳿ϣⲧⲉⲙⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉ⳿ⲫⲟⲩⲱϣ ⲧⲏⲣϥ ⳿ⲙⲪϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ⲙⲁϩⲑⲏⲧⲉⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲉⲙ ⲡⲓⲟϩⲓ ⲧⲏⲣϥ ⲉⲧ⳿ⲁ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲭⲁ ⲑⲏⲛⲟⲩ ⳿ⲛ⳿ⲉⲡⲓⲥⲕⲟⲡⲟⲥ ⳿ⲛϧⲏⲧϥ ⳿ⲉ⳿ⲁⲙⲟⲛⲓ ⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲛⲧⲉ Ⲡ⳪ ⲑⲏ⳿ⲉⲧⲁϥ⳿ϫⲫⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲉϥ⳿ⲥⲛⲟϥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","⳿ⲁⲛⲟⲕ ⲇⲉ ϯ⳿ⲉⲙⲓ ϫⲉ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲑⲣⲓϣⲉⲛⲏⲓ ⲥⲉⲛⲁ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲱⲛϣ ⲉⲩϩⲟⲣϣ ⳿ⲛⲥⲉⲛⲁϯ⳿ⲁⲥⲟ ⲁⲛ ⳿ⲉⲡⲓⲟϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲱⲟⲩⲛ ⳿ⲛϫⲉ ϩⲁⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲩϫⲱ ⳿ⲛϩⲁⲛⲥⲁϫⲓ ⲉⲩⲫⲱⲛϩ ⲉⲑⲣⲟⲩⲥⲱⲕ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲥⲁⲙⲉⲛϩⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ⲉⲑⲃⲉ ⲫⲁⲓ ⲟⲩⲛ ⲣⲱⲓⲥ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲣⲉⲧⲉⲛ⳿⳿ⲓⲣⲓ ⳿ⲙ⳿ⲫⲙⲉⲩⲓ ϫⲉ ⲁⲓⲉⲣ ⲅ̅ϯ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲙⲡⲓ ⲭⲁⲧⲟⲧ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲉⲓϯ⳿ⲥⲃⲱ ⳿ⲙ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲉⲛ ϩⲁⲛⲉⲣⲙⲱⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ⲟⲩⲟϩ ϯⲛⲟⲩ ϯⲭⲱ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲁⲧⲉⲛ Ⲡ⳪ ⲛⲉⲙ ⳿ⲡⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲡⲉϥ⳿ϩⲙⲟⲧ ⲫⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲑⲱϣ ⲟⲩⲟϩ ⳿ⲉϯ ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲁ ϧⲉⲛ ⲛⲏ⳿ⲉⲧⲁⲩⲧⲟⲩⲃⲱⲟⲩ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ⲟⲩϩⲁⲧ ⲓⲉ ⲟⲩⲛⲟⲩⲃ ⲓⲉ ⲟⲩ⳿ϩⲃⲱⲥ ⳿ⲙⲡⲓⲉⲣⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲉⲟⲩⲟⲛ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⲛⲁϫⲓϫ ⲛⲁⲓ ⲁⲩϣⲉⲙϣⲓ ⳿ⲛⲧⲁ⳿ⲭⲣⲓⲁ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ⲁⲓⲧⲁⲙⲱⲧⲉⲛ ⳿ⲉϩⲱⲃ ⲛⲓⲃⲉⲛ ϫⲉ ⳿ⲥϣⲉ ⳿ⲛϧⲟⲥⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲛⲧⲉⲛϯⲧⲟⲧⲟⲩ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲛⲧⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲛⲑⲟϥ ⲁϥϫⲟⲥ ϫⲉ ⲟⲩⲙⲉⲧⲙⲁⲕⲁⲣⲓⲟⲥ ⲧⲉ ⲙⲁⲗⲗⲟⲛ ⳿ⲉϯ ⳿ⲉϩⲟⲧⲉ ⳿ⲉϭⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ⲟⲩⲟϩ ⲛⲁⲓ ⳿ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲁϥϩⲓⲧϥ ⳿ⲉϫⲉⲛ ⲛⲉϥⲕⲉⲗⲓ ⲛⲉⲙⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲁⲩⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲣⲓⲙⲓ ⳿ⲛⲧⲱⲟⲩ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲁⲩϩⲓⲧⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲑⲛⲁϩⲃⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⲁⲩϯⲫⲓ ⳿ⲉⲣⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ⲉⲩⲟⲓ ⳿ⲛ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲙⲁⲗⲓⲥⲧⲁ ⲉⲑⲃⲉ ⲡⲓⲥⲁϫⲓ ⳿ⲉⲧⲁϥϫⲟϥ ϫⲉ ⲥⲉⲛⲁⲛⲁⲩ ⳿ⲉⲡⲁϩⲟ ⲁⲛ ϫⲉ ⲛⲁⲩ⳿ⲧⲫⲟ ⲇⲉ ⳿ⲙⲙⲟϥ ⳿ⲉϫⲉⲛ ⲡⲓϫⲟⲓ . ");
INSERT INTO copcnt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁⲛϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲁⲛⲫⲱⲣϫ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ ⲁⲛⲉⲣϩⲱⲧ ⲉⲛⲥⲱⲟⲩⲧⲉⲛ ⲁⲛ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲕⲱ ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲛ⳿ⲓ ⳿ⲉⲣⲟⲇⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲛ⳿ⲓ ⳿ⲉⲡⲁⲧⲁⲣⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ⲟⲩⲟϩ ⲉⲧⲁⲛϫⲓⲙⲓ ⳿ⲛⲟⲩϫⲟⲓ ⲉϥⲛⲁⲉⲣϫⲓⲛⲓⲟⲣ ⳿ⲉϯⲫⲟⲓⲛⲓⲕⲏⲁⲛ⳿ⲁⲗⲏⲓ ⲁⲛϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ⲉⲧⲀⲛⲛⲁⲩ ⲇⲉ ⳿ⲉⲕⲩⲡⲣⲟⲥ ⲁⲛⲥⲟϫⲡⲥ ⲥⲁϫⲁϭⲏ ⳿ⲙⲙⲟⲛ ⲁⲛⲉⲣϩⲱⲧ ⳿ⲉ⳿ⲧⲥⲩⲣⲓ⳿ⲁ ⲟⲩⲟϩ ⲁⲛ⳿ⲓ ⳿ⲉⲦⲩⲣⲟⲥ ⲛⲁⲣⲉ ⲡⲓϫⲟⲓ ⲅⲁⲣ ⲛⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲉϥⲁⲟⲩⲓⲛ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ⲉⲧⲁⲛϫⲓⲙⲓ ⲇⲉ ⳿ⲛⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⲁⲛϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲍ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲁⲓ ⳿ⲉⲧⲉⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ϣⲧⲉⲙ⳿ⲑⲣⲉϥϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲉⲧⲁⲛϫⲱⲕ ⳿ⲛⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲃⲟⲗ ⲁⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲛⲙⲟϣⲓ ⲉⲩ⳿ⲧⲫⲟ ⳿ⲙⲙⲟⲛ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⲛⲉⲙ ϩⲁⲛⲕⲉϩⲓ⳿ⲟⲙⲓ ⲛⲉⲙ ⲛⲟⲩϣⲏⲣⲓ ϣⲁ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲡⲟⲗⲓⲥ ⲟⲩⲟϩ ⲁⲛϩⲓⲧⲉⲛ ϩⲓϫⲉⲛ ⲛⲉⲛⲕⲉⲗⲓ ϩⲓϫⲉⲛ ⲡⲓ⳿ⲭⲣⲟ ⲁⲛⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ⲟⲩⲟϩ ⲁⲛⲉⲣⲁⲡⲟⲧⲁⲍⲉⲥⲑⲉ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲉⲛ⳿ⲉⲣⲏⲟⲩ ⲁⲛ⳿ⲁⲗⲏⲓ ⳿ⲉⲡⲓϫⲟⲓ ⲛⲏⲇⲉ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉⲛⲏ⳿ⲉⲧⲉⲛⲟⲩⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","⳿ⲁⲛⲟⲛ ⲇⲉ ⲁⲛⲉⲣϩⲱⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲧⲩⲣⲟⲥ ⲁⲛ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲡⲧⲟⲗⲉⲙⲁⲓⲥ ⲟⲩⲟϩ ⲉⲧⲁⲛⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲁⲛϣⲱⲡⲓ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲟⲩ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲉⲧⲁⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁⲛ⳿ⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⲟⲩⲟϩ ⲉⲧⲁⲛϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲡⲏⲓ ⳿ⲙⲪⲓⲗⲓⲡⲡⲟⲥ ⲡⲓⲣⲉϥϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲉⲟⲩⲁⲓ ⲡⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲍ̅ ⲁⲛϣⲱⲡⲓ ϧⲁⲧⲟⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ⲫⲁⲓ ⲇⲉ ⲛⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲁϥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲇ̅ ⳿ⲛϣⲉⲣⲓ ⳿ⲙⲡⲁⲣⲑⲉⲛⲟⲥ ⲉⲩⲉⲣ⳿ⲡⲣⲟⲫⲏⲧⲉⲩⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ⲉⲧⲁⲛϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ Ⲓⲟⲩⲇⲉ⳿ⲁ ⳿ⲉⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲡⲉ ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲁⲅⲁⲃⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲓ ϣⲁⲣⲟⲛ ⲁϥ⳿ⲱⲗⲓ ⳿ⲛϯ ⲍⲱⲛⲏ⳿ⲛⲧⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥⲙⲟⲩⲣ ⳿ⲛⲛⲉϥϫⲓϫ ⲛⲉⲙ ⲛⲉϥϭⲁⲗⲁⲩϫ ⲡⲉϫⲁϥ ⲛⲁⲓ ⲛⲉ ⲛⲏ⳿ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ϫⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲧⲉⲫⲱϥ ⲡⲉ ⲡⲁⲓⲙⲟϫϧ ⲥⲉⲛⲁⲥⲟⲛϩϥ ⳿ⲙⲡⲁⲓⲣⲏϯ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲥⲉⲛⲁⲧⲏⲓϥ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛϩⲁⲛⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ⲉⲧⲁⲛⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲛⲁⲓ ⲛⲁⲛϯϩⲟ ⲡⲉ ⳿ⲁⲛⲟⲛ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⳿ⲉ⳿ϣⲧⲉⲙ⳿ⲑⲣⲉϥϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ⲧⲟⲧⲉ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲧⲉⲛⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲉⲧⲉⲛⲣⲓⲙⲓ ⲟⲩⲟϩ ⳿ⲉⲣⲉⲧⲉⲛϯ⳿ⲙⲕⲁϩ ⳿ⲙⲡⲁϩⲏⲧ ⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲟⲩ ⲙⲟⲛⲟⲛ ⳿ⲉⲥⲟⲛϩⲧ ⲁⲗⲗⲁ ϯⲥⲉⲃⲧⲱⲧ ⳿ⲉⲙⲟⲩ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","⳿ⲉⲧⲉ ⳿ⲙⲡⲉ ⲡⲉϥϩⲏⲧ ⲇⲉ ⲑⲱⲧ ⲁⲛ ⲭⲁⲣⲱⲛ ⲉⲛϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲡⲉⲧⲉϩⲛⲁϥ ⳿ⲙⲠ⳪ ⲙⲁⲣⲉϥϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ⲙⲉⲛⲉⲛⲥⲁ ⲛⲁⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲉⲧⲁⲛⲥⲉⲃⲧⲱⲧⲉⲛ ⳿ⲛⲀⲛⲛⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ⲁⲩ⳿ⲓ ⲇⲉ ⲛⲉⲙⲁⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲕⲉⲥⲁⲣⲓⲁ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲙⲁⲑⲏⲧⲏⲥ ⳿ⲉⲁⲩ⳿ⲓⲛⲓ ⳿ⲙⲫⲏ⳿ⲉⲧⲉⲛⲛⲁϫⲱⲓⲗⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲁⲓ ϫⲉ ⲛⲁⲥⲥⲱⲛ ⲟⲩⲕⲩⲡⲣⲓⲟⲥ ⲟⲩⲁⲣⲭⲉⲟⲥ ⳿ⲙⲙⲁⲑⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ⲉⲧⲁⲛ⳿ⲓ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲩϣⲟⲡⲧⲉⲛ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲛⲉⲙⲁⲛ ϣⲁ Ⲓⲁⲕⲱⲃⲟⲥ ⲁⲩ⳿ⲓ ⲇⲉ ϩⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲙⲙⲱⲟⲩ ⲛⲁϥⲥⲁϫⲓ ϧⲁⲧⲟⲧⲟⲩ ⲕⲁⲧⲁ ⲟⲩⲁⲓ ⲟⲩⲁⲓ ⳿ⲛⲛⲏ⳿ⲉⲧⲁ Ⲫϯ ⲁⲓⲧⲟⲩ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲧⲉϥⲇⲓ⳿ⲁⲕⲟⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲁⲩϯ⳿ⲱⲟⲩ ⳿ⲙⲪϯ ⲡⲉϫⲱⲟⲩ ⲇⲉ ⲛⲁϥ ϫⲉ ⳿ⲭⲛⲁⲩ ⲡⲉⲛⲥⲟⲛ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲏⲣ ⳿ⲛ⳿ⲑⲃⲁ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲉⲁⲩⲛⲁϩϯ ⲟⲩⲟϩ ϩⲁⲛⲣⲉϥⲭⲟϩ ⲧⲏⲣⲟⲩ ⲛⲉ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ⲁⲩⲧⲁⲙⲱⲟⲩ ⲇⲉ ⲉⲑⲃⲏⲧⲕ ϫⲉ ⳿ⲕϯ ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲧ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲑⲣⲟⲩϩⲉⲛⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲉⲕϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲥⲟⲩⲃⲉ ⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲙⲟϣⲓ ⲕⲁⲧⲁ ⲛⲓⲥⲩⲛⲏⲑⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ⲟⲩ ϫⲉ ⲡⲁⲛⲧⲟⲥ ⲥⲉⲛⲁⲥⲱⲧⲉⲙ ϫⲉ ⲁⲕ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ⲫⲁⲓ ⲟⲩⲛ ⳿ⲁⲣⲓⲧϥ ⳿ⲉⲧⲉⲛⲛⲁϫⲟϥ ⲛⲁⲕ ⲟⲩⲟⲛⲧⲁⲛ ⳿ⲛⲇ̅ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲛⲟⲩⲉⲩⲭⲏ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ϭⲓ ⳿ⲛⲛⲁⲓ ⲙⲁⲧⲟⲩⲃⲟⲕ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ϭⲉ ⲇⲁⲡⲁⲛⲏ⳿ⲉⲃⲟⲗ ⳿ⲉⲣⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲉⲕ ϫⲱⲟⲩ ⲟⲩⲟϩ ⲉⲩ⳿ⲉ⳿ⲉⲙⲓ ⲧⲏⲣⲟⲩ ϫⲉ ⲛⲏ⳿ⲉⲧⲁⲩϫⲟⲧⲟⲩ ⲉⲑⲃⲏⲧⲕ ϩⲁⲛ⳿ϩⲗⲓ ⲛⲉ ⲁⲗⲗⲁ ϫⲉ ⳿ⲕϯⲙⲁϯ ϩⲱⲕ ⳿ⲉ⳿ⲁⲣⲉϩ ⳿ⲉⲡⲓⲛⲟⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ⲉⲑⲃⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁϩϯ ⳿ⲁⲛⲟⲛ ⲁⲛⲟⲩⲱⲣⲡ ⳿ⲉⲁⲛϯϩⲁⲡ ⲉⲑⲣⲟⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗϩⲁ ⲛⲓϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲟϥ ⲛⲉⲙ ⲛⲓⲱϫϩ ⲛⲉⲙ ϯⲡⲟⲣⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ⲧⲟⲧⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥϭⲓ ⳿ⲛⲛⲓⲣⲱⲙⲓ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲉⲑⲛⲏⲟⲩ ⲁϥⲧⲟⲩⲃⲟϥ ⲛⲉⲙⲱⲟⲩ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲉϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲡⲓⲧⲟⲩⲃⲟ ϣⲁⲧⲟⲩ⳿ⲓⲛⲓ ⳿ⲛϯⲡⲣⲟⲥⲫⲱⲣⲁ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ⲉⲩⲛⲁϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲡⲓⲍ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲛⲧⲉ ϯ⳿ⲁⲥⲓ⳿ⲁ ⲉϥϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲁⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲙⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲛⲛⲟⲩϫⲓϫ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲓⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⳿ⲁⲣⲓⲃⲟ⳿ⲏⲑⲓⲛ ⲫⲁⲓ ⲡⲉ ⲡⲓⲣⲱⲙⲓ ⲉⲧϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲡⲁⲓⲙⲁ ⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲓ ⲇⲉ ⲛⲉⲙ ϩⲁⲛⲕⲉⲟⲩⲉⲓⲛⲓⲛ ⳿ⲉⲁϥ⳿ⲉⲛⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁϥⲥⲱϥ ⳿ⲙⲡⲓⲙⲁ ⲉⲑⲟⲩⲁⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ⲛⲉ ⲁⲩⲉⲣϣⲟⲣⲡ ⲅⲁⲣ ⲡⲉ ⳿ⲛⲛⲁⲩ ⳿ⲉ⳿ⲧⲣⲟⲫⲏⲙⲟⲥ ⲛⲉⲙⲁϥ ϧⲉⲛ ϯⲡⲟⲗⲓⲥ ⲡⲓⲣⲉⲙⲉⲫⲉⲥⲟⲥ ⲫⲁⲓ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ⲟⲗϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲉⲣⲫⲉⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ⲁⲥⲕⲓⲙ ⲇⲉ ⳿ⲛϫⲉ ϯⲡⲟⲗⲓⲥ ⲧⲏⲣⲥ ⲟⲩⲟϩ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩϭⲟϫⲓ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲧⲏⲣϥ ⲉⲩⲥⲟⲡ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲁⲙⲁϩⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲁⲩⲥⲟⲕϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲥⲁⲧⲟⲧⲟⲩ ⲁⲩⲙⲁϣⲑⲁⲙ ⲛⲛⲓⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ⲉⲩⲕⲱϯ ⲇⲉ ⳿ⲛⲥⲁ ϧⲟⲑⲃⲉϥ ⳿ⲁ ⲡⲓϣⲓⲛⲓ ⲇⲉ ϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲙⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⳿ⲛⲧⲉ ϯ⳿ⲥⲡⲓⲣⲁ ϫⲉ ⲁⲥ⳿ϣⲑⲟⲣⲧⲉⲣ ⲧⲏⲣⲥ ⳿ⲛϫⲉ Ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ⲥⲁⲧⲟⲧϥ ⲇⲉ ⲁϥϭⲓ ⳿ⲛϩⲁⲛⲙⲁⲧⲟⲓ ⲛⲉⲙ ϩⲁⲛⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲁϥϭⲟϫⲓ ⳿ⲡⲉϫⲱⲟⲩ ⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⳿ⲉⲧⲁⲩⲛⲁⲩ ⳿ⲉⲛⲓⲙⲁⲧⲟⲓ ⲛⲉⲙ ⲡⲓⲭⲓⲗⲓⲁⲣⲭ ⲟⲥ ⲁⲩⲗⲟϫⲟⲩ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲉⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ⲧⲟⲧⲉ ⳿ⲉⲧⲁϥϧⲱⲛⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲛϫⲉ ⲡⲓ ⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲟⲩⲥⲟⲛϩϥ ⳿ⲛϩⲁⲗⲩⲥⲓⲥ ⲃ̅ϯ ⲟⲩⲟϩ ⲛⲁϥϣⲓⲛⲓ ϫⲉ ⲛⲓⲙ ⲡⲉ ⲟⲩⲟϩ ϫⲉ ⲟⲩ ⲡⲉⲧⲁϥⲁⲓϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩⲱϣ ⳿ⲉⲃⲟⲗ ⲉⲩϫⲱ ⳿ⲛⲕⲉϩⲱⲃ ⳿ⲉⲧⲉ ⳿ⲙⲡⲉϥ⳿ϣϫⲉⲙϫⲟⲙ ⲇⲉ ⳿ⲛ⳿ⲉⲙⲓ ⳿ⲉⲡⲓⲧⲁϫⲣⲟ ⲉⲑⲃⲉ ⲡⲓ⳿ϣⲑⲟⲣⲧⲉⲣ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲟⲩⲟⲗϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲡⲁⲣⲉ⳿ⲙⲃⲟⲗⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁϥ⳿ⲁⲗⲏⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲓⲧⲱⲧⲉⲣ ⲁⲥϣⲱⲡⲓ ⲉⲑⲣⲟⲩⲧⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲧⲟⲓ ⲉⲑⲃⲉ ⳿ⲡϭⲓ⳿ⲛϫⲟⲛⲥ ⳿ⲛⲧⲉ ⲡⲓⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ⲛⲁⲩⲙⲟϣⲓ ⲅⲁⲣ ⳿ⲛⲥⲱϥ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ ⳿ⲛⲧⲉ ⲡⲓⲗⲁⲟⲥ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ⲁⲗⲓⲧϥ ⳿ⲙⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ⲉⲩⲛⲁ⳿ⲉⲛϥ ⲇⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲡⲁⲣⲉ⳿ⲙⲃⲟⲗⲏⲡⲉϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲙⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ϫⲉ ⲁⲛ ⳿ⲥϣⲉⲛⲏⲓ ⳿ⲛⲧⲁϫⲉ ⳿ϩⲗⲓ ⲛⲁⲕ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲕⲥⲱⲟⲩⲛ ⲣⲱ ⳿ⲙⲙⲉⲧⲟⲩⲉⲓⲛⲓⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ϩⲁⲣⲁ ⳿ⲛⲑⲟⲕ ⲁⲛ ⲡⲉ ⲡⲓⲣⲉⲙ⳿ⲛⲬⲏⲙⲓ ⲉⲧϧⲁϫⲱⲟⲩ ⳿ⲛⲛⲁⲓ ⳿ⲉϩⲟⲟⲩ ⲁⲕ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⲟⲩⲟϩ ⲁⲕϭⲓ ⳿ⲙⲡⲓⲇ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ ⳿ⲛⲧⲉ ⲛⲓⲥⲓⲕⲁⲣⲓⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ⲡϣⲁϥⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲣⲉⲙⲧⲁⲣⲥⲟⲥ ⳿ⲛⲧⲉ ϯⲕⲩⲗⲓⲕⲓ⳿ⲁ ⲟⲩⲣⲉⲙ⳿ⲙⲃⲁⲕⲓ ⳿ⲛⲧⲉ ⲟⲩⲃⲁⲕⲓ ⲉⲥⲟⲓ ⳿ⲛⲁⲧⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⲁⲛ ϯⲧⲱⲃϩ ⲟⲩⲛ ⳿ⲙⲙⲟⲕ ⲉⲑⲣⲉⲕⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲏⲓ ⳿ⲛⲧⲁⲥⲁϫⲓ ⲛⲉⲙ ⲡⲁⲡⲓⲗⲁⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","⳿ⲉⲧⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲇⲉ ⲛⲁϥ ⳿ⲉⲣⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϩⲓϫⲉⲛ ⲛⲓⲧⲱⲧⲉⲣ ⲁϥⲕⲓⲙ ⳿ⲛⲧⲉϥϫⲓϫ ⲟⲩⲃⲉ ⲡⲓⲗⲁⲟⲥ ⳿ⲉⲧⲁ ⲟⲩⲛⲓϣϯ ⲇⲉ ⳿ⲛⲭⲁⲣⲱϥ ϣⲱⲡⲓ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲁⲥⲡⲓ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ⲛⲓⲣⲱⲙⲓ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲛⲓⲓⲟϯ ⲥⲱⲧⲉⲙ ⳿ⲉⲧⲁ⳿ⲁⲡⲟⲗⲟⲅⲓⲁ ⳿ⲉⲧⲉⲛⲧⲏⲓ ϣⲁⲣⲱⲧⲉⲛ ϯⲛⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ϫⲉ ⲁϥⲉⲣⲟⲩⲱ ⲛⲱⲟⲩ ϧⲉⲛ ϯⲁⲥⲡⲓ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ⲙⲁⲗⲗⲟⲛ ⲇⲉ ⲁⲩⲭⲁⲣⲱⲟⲩ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ϫⲉ ⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲒⲟⲩⲇⲁⲓ ⲁⲩⲙⲁⲥⲧ ϧⲉⲛ Ⲧⲁⲣⲥⲟⲥ ⳿ⲛⲧⲉ ϯⲔⲩⲗⲓⲕⲓⲁ ⳿ⲉⲁⲩϣⲁⲛⲟⲩϣⲧ ϧⲉⲛ ⲧⲁⲓⲡⲟⲗⲓⲥ ϧⲁⲧⲉⲛ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲄⲁⲙⲁⲗⲓⲏⲗ ⲫⲁⲓ ⳿ⲉⲧⲁϥ⳿ⲧⲥⲁⲃⲟⲓ ⳿ⲉ⳿ⲡⲧⲁϫⲣⲟ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲉⲓⲟⲓ ⳿ⲛⲣⲉϥⲭⲟϩ ⳿ⲛⲧⲉ Ⲫⲛⲟⲩϯ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ϩⲱⲧⲉⲛ ⳿ⲉⲧⲉⲧⲉⲛⲟⲓ ⳿ⲙⲙⲟⲥ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⳿ⲙⲫⲟⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","⳿ⲉⲁⲓϭⲟϫⲓ ⳿ⲛⲥⲁ ⲡⲁⲓⲙⲱⲓⲧ ϣⲁ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲙⲟⲩ ⲉⲓⲥⲱⲛϩ ⳿ⲛϩⲁⲛⲣⲱⲙⲓ ⲛⲉⲙ ϩⲁⲛϩⲓⲟⲙⲓ ⲉⲓϩⲓⲟⲩ⳿ⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ");
INSERT INTO copcnt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲉ ⲡⲓ⳿ⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲟⲓ ⳿ⲙⲙⲉⲑⲣⲉ ⲛⲏⲓ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲧⲏⲣⲟⲩ ⲛⲏ ⳿ⲉⲧⲁⲓϭⲓ ⲉⲡⲓⲥⲧⲟⲗⲏ ⳿ⲛⲧⲟⲧⲟⲩ ϣⲁ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲓⲛⲁ ⲇⲉ ⳿ⲉⲆⲁⲙⲁⲥⲕⲟⲥ ⳿ⲉ⳿ⲓⲛⲓ ⳿ⲛⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⳿ⲉⲧⲉ⳿⳿ⲙⲙⲁⲩ ⲉⲩⲥⲟⲛϩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲉⲣⲟⲩⲥⲁⲗⲏⲙ ϩⲓⲛⲁ ⳿ⲛⲥⲉϯ⳿ⲙⲕⲁϩ ⲛⲱⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲙⲙⲟⲓ ⲉⲓⲙⲟϣⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲓϧⲱⲛⲧ ⳿ⲉⲆⲁⲙⲁⲥⲕⲟⲥ ⳿ⲙ⳿ⲡⲕⲱϯ ⳿ⲙⲙⲉⲣⲓ ⳿ⲛⲟⲩϩⲟϯ ϧⲉⲛ ⲟⲩϩⲟϯ ⲁϥⲉⲣⲟⲩⲱⲓⲛⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ");
INSERT INTO copcnt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ⲁⲓϩⲉⲓ ⲇⲉ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩⲟϩ ⲁⲓⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩ⳿ⲥⲙⲏ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲏⲓ ϫⲉ Ⲥⲁⲟⲩⲗ Ⲥⲁⲟⲩⲗ ⳿ⲁϧⲟⲕ ⳿ⲕϭⲟϫⲓ ⳿ⲛⲥⲱⲓ ");
INSERT INTO copcnt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","⳿ⲁⲛⲟⲕ ⲇⲉ ⲁⲓⲉⲣⲟⲩⲱ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ Ⲡϭⲟⲓⲥ ⲡⲉϫⲁϥ ⲇⲉ ⲛⲏⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲓⲏⲥⲟⲩⲥ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ ⲫⲏ ⳿ⲛⲑⲟⲕ ⳿ⲉⲧⲉⲕϭⲟϫⲓ ⳿ⲛⲥⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ⲛⲏ ⲇⲉ ⳿ⲉⲛⲁⲩⲛⲉⲙⲏⲓ ⲛⲁⲩⲛⲁⲩ ⲙⲉⲛ ⳿ⲉⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉ⳿ⲧ⳿ⲥⲙⲏ ⳿ⲙⲡⲉⲧⲥⲁϫⲓ ⲛⲉⲙⲏⲓ ");
INSERT INTO copcnt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ⲡⲉϫⲏⲓ ⲇⲉ ϫⲉ ⲟⲩ ⲡⲉϯⲛⲁⲁⲓϥ Ⲡϭⲟⲓⲥ Ⲡϭⲟⲓⲥ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲏⲓ ϫⲉ ⲧⲱⲛⲕ ⲙⲁϣⲉⲛⲁⲕ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲆⲁⲙⲁⲥⲕⲟⲥ ⲟⲩⲟϩ ⲥⲉⲛⲁⲥⲁϫⲓ ⲛⲉⲙⲁⲕ ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉⲧⲁⲩⲑⲁϣⲟⲩ ⲛⲁⲕ ⲉⲑⲣⲉⲕⲁⲓⲧⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϯⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲁⲛ ⳿ⲛⲧⲉⲛ ⳿ⲡ⳿ⲱⲟⲩ ⳿ⲙⲡⲓⲟⲩⲱⲓⲛⲓ ⳿ⲉⲧⲉ⳿⳿ⲙⲙⲁⲩ ⲁⲩ⳿ⲁⲙⲟⲛⲓ ⲇⲉ ⳿ⲛⲧⲁϫⲓϫ ⳿ⲛϫⲉ ⲛⲏⲉⲑⲛⲉⲙⲏⲓ ⲁⲓ⳿ⲓ ⳿ⲉⲆⲁⲙⲁⲥⲕⲟⲥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ⲟⲩⲁⲓ ⲇⲉ ϫⲉ Ⲁⲛⲁⲛⲓⲁⲥ ⲟⲩⲣⲱⲙⲓ ⲉϥⲉⲣϩⲟϯ ⲕⲁⲧⲁ ⲡⲓⲛⲟⲙⲟⲥ ⲉⲩⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲧϣⲟⲡ ⳿ⲙⲙⲁⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","⳿ⲉⲧⲁϥ⳿ⲓ ⲇⲉ ϣⲁⲣⲟⲓ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲡⲉϫⲁϥ ⲛⲏⲓ ϫⲉ Ⲥⲁⲟⲩⲗ ⲡⲁⲥⲟⲛ ⳿ⲁⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⳿ⲁⲛⲟⲕ ⲇⲉ ϩⲱ ϧⲉⲛ ϯⲟⲩⲛⲟⲩ ⳿ⲉⲧⲉ⳿⳿ⲙⲙⲁⲩ ⲁⲓⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ Ⲫⲛⲟⲩϯ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲱⲧⲡⲕ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉⲡⲉⲧⲉϩⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉⲛⲁⲩ ⳿ⲉⲡⲓⲑⲙⲏⲓ ⲟⲩⲟϩ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩ⳿ⲥⲙⲏ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ϫⲉ ⳿ⲭⲛⲁϣⲱⲡⲓ ⲛⲁϥ ⳿ⲙⲙⲉⲑⲣⲉ ϧⲁⲧⲉⲛ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ ⲛⲏ ⳿ⲉⲧⲁⲕⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲕⲥⲟⲑⲙⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲟⲩ ⲡⲉⲧⲉⲕⲛⲁⲁⲓϥ ⲧⲱⲛⲕ ϭⲓⲱⲙⲥ ⲟⲩⲟϩ ϫⲟⲕⲙⲉⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲕⲛⲟⲃⲓ ⲉⲕⲧⲱⲃϩ ⳿ⲙⲡⲉϥⲣⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁⲓⲕⲟⲧⲧ ⳿ⲉⲒⲉⲣⲟⲩⲥⲁⲗⲏⲙ ⲟⲩⲟϩ ⲉⲓⲉⲣ⳿ⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲁⲓϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲧⲱⲙⲧ ");
INSERT INTO copcnt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ⲁⲓⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲏⲓ ϫⲉ ⳿ⲁⲙⲟⲩ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ Ⲓⲉⲣⲟⲩⲥⲁⲗⲏⲙ ϫⲉ ⲟⲩⲏⲓ ⲥⲉⲛⲁ ϭⲓⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲧⲟⲧⲕ ⲁⲛ ⲉⲑⲃⲏⲧ ");
INSERT INTO copcnt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","⳿ⲁⲛⲟⲕ ϩⲱ ⲡⲉϫⲏⲓ ϫⲉ Ⲡϭⲟⲓⲥ ⳿ⲛⲑⲱⲟⲩ ⲥⲉ⳿ⲉⲙⲓ ϫⲉ ⲛⲁⲓϩⲓⲟⲩ⳿ⲓ ⳿ⲉ⳿ⲡ⳿ϣⲧⲉⲕⲟ ⲟⲩⲟϩ ⲛⲁⲓϩⲓⲟⲩ⳿ⲓ ⲕⲁⲧⲁ ⲥⲩⲛⲁⲅⲱⲅⲏ ⳿ⲛⲛⲏ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟⲕ ");
INSERT INTO copcnt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ⲟⲩⲟϩ ϩⲟⲧⲉ ⲉⲩⲛⲁⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲛⲤⲧⲉⲫⲁⲛⲟⲥ ⲡⲉⲕⲙⲁⲣⲧⲩⲣⲟⲥ ⳿ⲁⲛⲟⲕ ϩⲱ ⲛⲁⲓ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ⲉⲓϯⲙⲁϯ ⲟⲩⲟϩ ⲛⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲛⲓ⳿ϩⲃⲱⲥ ⳿ⲛⲧⲉ ⲛⲏ ⳿ⲉⲛⲁⲩϧⲱⲧⲉⲃ ⳿ⲙⲙⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ⲟⲩⲟϩ ⲡⲉϫⲁϥ ⲛⲏⲓ ϫⲉ ⲙⲟϣⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ϯⲛⲁⲟⲩⲟⲣⲡⲕ ⳿ⲉϩⲁⲛⲉⲑⲛⲟⲥ ⲉⲩⲟⲩⲏⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ⲛⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲣⲟϥ ϣⲁ ⲡⲁⲓⲥⲁϫⲓ ⲟⲩⲟϩ ⲁⲩϭⲓⲥⲓ ⳿ⲛⲧⲟⲩ⳿ⲥⲙⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲗⲓ ⲫⲁⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲟⲩ ⲅⲁⲣ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲱⲛϧ ⲁⲛ ");
INSERT INTO copcnt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ⲉⲩⲱϣ ⲇⲉ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉⲩⲥⲓϯ ⳿ⲛⲛⲟⲩ⳿ϩⲃⲱⲥ ⲟⲩⲟϩ ⲉⲩⲥⲉⲧ ϣⲱⲓϣ ⳿ⲉⲡⲓⲁⲏⲣ ");
INSERT INTO copcnt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ⲁϥⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⳿ⲛϫⲉ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲉⲑⲣⲟⲩϭⲓⲧϥ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲡⲁⲣⲉⲙⲃⲟⲗⲏ ⳿ⲉⲁϥϫⲟⲥ ⲉⲑⲣⲟⲩϯ⳿ⲙⲕⲁϩ ⲛⲁϥ ϧⲉⲛ ϩⲁⲛⲙⲁⲥⲧⲓⲅⲝ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ⲉⲙⲓ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲛⲗⲱⲓϫⲓ ⲥⲉⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲉ⳿ϩⲣⲏⲓ ⲉϫⲱϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","⳿ⲉϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁⲩϭⲟⲗⲕϥ ϧⲉⲛ ⲛⲓϧⲱⲕ ⲡⲉϫⲉ Ⲡⲁⲩⲗⲟⲥ ⳿ⲙⲡⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⳿ⲉⲛⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϫⲉ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲢⲱⲙⲉⲟⲥ ⳿ⲛ⳿ϥⲉⲣ ⳿ⲡⲕⲉϩⲱⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲡϩⲁⲡ ⲁⲛ ⲡⲉⲧⲥϣⲉ ⲛⲱⲧⲉⲛ ⲡⲉ ⳿ⲉⲉⲣⲙⲁⲥⲧⲓⲅⲅⲟⲓⲛ ⳿ⲙⲙⲟϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲡⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲁϥϣⲉ ϣⲁ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲁϥⲧⲁⲙⲟϥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲛⲁⲁⲓϥ ⲡⲓⲣⲱⲙⲓ ⲅⲁⲣ ⲟⲩⲢⲱⲙⲉⲟⲥ ⲡⲉ ");
INSERT INTO copcnt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ⲁϥ⳿ⲓ ⲇⲉ ϣⲁⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲡⲉϫⲁϥ ⲛⲁϥ ϫⲉ ⳿ⲁϫⲟⲥ ⲛⲏⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲢⲱⲙⲉⲟⲥ ⳿ⲛⲑⲟϥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁϩⲁ ");
INSERT INTO copcnt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ⲁϥⲉⲣⲟⲩⲱ ⳿ⲛϫⲉ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲁⲓϣⲱⲡ ⳿ⲛⲧⲁⲓⲡⲟⲗⲏⲧⲓⲁ ⲛⲏⲓ ϧⲁ ⲟⲩⲙⲏϣ ⳿ⲛⲕⲉⲫⲁⲗⲉⲟⲛ Ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⳿ⲁⲛⲟⲕ ⳿ⲉⲧⲁⲩⲙⲁⲥⲧ ⳿ⲛϧⲏⲧⲥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ⲥⲁⲧⲟⲧⲟⲩ ⲟⲩⲛ ⲁⲩϩⲉⲛⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲏ ⲉⲧϯ⳿ⲙⲕⲁϩ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲁ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲉⲣϩⲟϯ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲢⲱⲙⲉⲟⲥ ⲡⲉ ⲟⲩⲟϩ ϫⲉ ⲁϥⲥⲟⲛϩϥ ");
INSERT INTO copcnt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉⲡⲓⲧⲁϫⲣⲟ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲁⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁϥⲃⲟⲗϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲟⲩ⳿ⲓ ⳿ⲛϫⲉ ⲛⲓ⳿ⲁⲣⲭⲓⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲡⲓⲙⲁ⳿ⲛϯϩⲁⲡ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲁϥⲉⲛ Ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲡⲉⲥⲏⲧ ⲁϥⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϧⲏⲧⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","⳿ⲉⲧⲁϥⲥⲟⲙⲥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲡⲉϫⲁϥ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲁⲛⲟⲕ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲥⲩⲛⲏⲇⲉⲥⲓⲥ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲛⲉⲩ ⲁⲓⲉⲣⲡⲟⲗⲓⲧⲉⲩⲉⲥⲑⲉ ⳿ⲙⲪϯ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲁⲓ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ⲡⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲇⲉ ⳿ⲁⲛⲁⲛⲓⲁⲥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲛⲏⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲁϩⲣⲁϥ ⲉⲑⲣⲟⲩϩⲓⲟⲩ⳿ⲓ ϧⲉⲛ ⲣⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ⲧⲟⲧⲉ ⲡⲉϫⲉ ⲡⲁⲩⲗⲟⲥ ⲛⲁϥ ϫⲉ Ⲫϯ ⲛⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲕ ⳿ⲙⲡⲁⲓⲣⲏϯ ϯϫⲟⲓ ⲉⲧⲟϣϫ ⳿ⲛⲕⲟⲛⲓⲁ ⳿ⲕⲉⲣ⳿ⲡⲕⲉϩⲉⲙⲥⲓ ⲉⲕϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ⲕⲁⲧⲁ ⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲕⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⲉⲑⲣⲟⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲣⲟⲓ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ⲛⲏⲇⲉ ⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲡⲉϫⲱⲟⲩ ϫⲉ ⲁⲕϩⲱⲟⲩϣ ⳿ⲉⲡⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⳿ⲛⲧⲉ ⲫϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁⲓⲥⲱⲟⲩⲛ ⲡⲉ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⲟⲩⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲡⲉ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⲟⲩⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲉⲕⲗⲁⲟⲥ ⳿ⲛⲛⲉⲕϫⲉ ⲡⲉⲧϩⲱⲟⲩ ϧⲁⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲙ⳿ⲉⲣⲟⲥ ⲙⲉⲛ ⳿ⲉⲫⲁ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲡⲉ ⲡⲓⲕⲉⲙ⳿ⲉⲣⲟⲥ ⲇⲉ ⳿ⲉⲫⲁ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲡⲉ ⲁϥⲱϣ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲁⲛⲟⲕ ⲟⲩⲪⲁⲣⲓⲥⲉⲟⲥ ⲉⲑⲃⲉ ⲟⲩϩⲉⲗⲡⲓⲥ ⲛⲉⲙ ⲟⲩ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲁⲛⲟⲕ ⲥⲉϯϩⲁⲡ ⳿ⲉⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ⲫⲁⲓ ⲇⲉ ⳿ⲉⲧⲁϥϫⲟϥ ⲁϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲟⲩⲧⲉ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲛⲉⲙ ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲟⲩⲟϩ ⲁϥⲫⲱⲣϫ ⳿ⲛϫⲉ ⲡⲓⲙⲏϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ⲛⲓⲤⲁⲇⲇⲟⲩⲕⲉⲟⲥ ⲙⲉⲛ ⲅⲁⲣ ⲥⲉϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲟⲩⲇⲉ ⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲇⲉ ⲡ͞ⲛⲁ̅ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲇⲉ ⲥⲉⲟⲩⲱⲛϩ ⳿ⲙⲙⲱⲟⲩ ⲉⲩⲥⲟⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϧⲣⲱⲟⲩ ⲟⲩⲟϩ ⲁⲩⲧⲱⲟⲩⲛ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲪⲁⲣⲓⲥⲉⲟⲥ ⲁⲩ⳿ⲙⲗⲁϧ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲧⲉ⳿ⲛϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⲁⲛ ϧⲉⲛ ⲡⲁⲓⲣⲱⲙⲓ ⲓⲥϫⲉ ⲟⲩⲡ͞ⲛⲁ̅ ⲁϥⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲓⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⲁϥⲉⲣϩⲟϯ ⳿ⲛϫⲉ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲥⲉϥⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⲁϥⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⳿ⲙⲡⲓ⳿ⲥⲧⲣⲁⲧⲉⲩⲙⲁ ⳿ⲛⲧⲟⲩϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛⲧⲟⲩϩⲱⲗⲉⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⳿ⲛⲧⲟⲩ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϯⲡⲁⲣⲉ⳿ⲙⲃⲟⲗⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲉⲑⲛⲏⲟⲩ ⳿ⲁ Ⲡ⳪ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲛⲁϩⲣⲁϥ ⲡⲉϫⲁϥ ϫⲉ ϫⲉⲙⲛⲟⲙϯ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲕⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲡⲁⲓⲣⲏϯ ϩⲱϯ ⳿ⲉⲣⲟⲕ ⲟⲛ ⳿ⲛⲧⲉⲕⲉⲣⲙⲉⲑⲣⲉ ⲉⲑⲃⲏⲧ ϧⲉⲛ ⳿ⲧⲕⲉⲣⲱⲙⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ϣⲱⲡⲓ ⲁⲩⲑⲱⲟⲩϯ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲩⲧⲁⲣⲕⲱⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲩⲱⲙ ⲟⲩⲇⲉ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲱ ϣⲁⲧⲟⲩϧⲱⲧⲉⲃ ⳿ⲙⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ⲛⲁⲩⲉⲣϩⲟⲩ⳿ⲟ ⲇⲉ ⳿ⲉⲙ̅ ⳿ⲛⲣⲱⲙⲓ ⳿ⲛϫⲉ ⲛⲏ⳿ⲉⲧⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁⲓ⳿ⲁⲛⲁϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ⲛⲁⲓ ⲁⲩ⳿ⲓ ϣⲁ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲡⲉϫⲱⲟⲩ ϫⲉ ϧⲉⲛ ⲟⲩ⳿ⲁⲛⲁⲑⲉⲙⲁ ⲁⲛⲧⲁⲣⲕⲟⲛ ⳿ⲉ⳿ϣⲧⲉⲙϫⲉⲙϯⲡⲓ ⳿ⲛ⳿ϩⲗⲓ ϣⲁⲧⲉⲛϧⲱⲧⲉⲃ ⳿ⲙⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ϯⲛⲟⲩ ⲟⲩⲛ ⲟⲩⲟⲛϩ ⳿ⲉⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲛⲉⲙ ⲡⲓⲙⲁⲛϯϩⲁⲡ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥ⳿ⲉⲛϥ ϣⲁⲣⲱⲧⲉⲛ ϩⲱⲥ ϫⲉ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⲉⲑⲃⲏⲧϥ ⳿ⲁⲛⲟⲛ ⲇⲉ ⳿ⲙⲡⲁⲧⲉϥϧⲱⲛⲧ ⳿ⲉⲣⲱⲧⲉⲛ ⲧⲉⲛⲥⲉⲃⲧⲱⲧ ⳿ⲉϧⲟⲑⲃⲉϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","⳿ⲉⲧⲁϥⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉϯϫⲟⲣϫⲥ ⳿ⲛϫⲉ ⳿ⲡϣⲏⲣⲓ ⳿ⲛ⳿ⲧⲥⲱⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲁϥ⳿ⲓ ⲁϥϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲡⲁⲣⲉ⳿ⲙⲃⲟⲗⲏⲁϥⲧⲁⲙⲉ ⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ⲁϥⲙⲟⲩϯ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲟⲩⲁⲓ ⳿ⲛⲛⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲡⲉϫⲁϥ ϫⲉ ϭⲓ ⳿ⲙⲡⲁⲓϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⳿ⲉϧⲟⲩⲛ ϣⲁ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲟⲩⲟⲛⲧⲉϥ ⲟⲩϩⲱⲃ ⲅⲁⲣ ⳿ⲉϫⲟϥ ⲛⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","⳿ⲛⲑⲟϥ ⲙⲉⲛ ⲟⲩⲛ ⲁϥϭⲓⲧϥ ⲁϥ⳿ⲉⲛϥ ϣⲁ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲟⲩⲟϩ ⲡⲉϫⲁϥ ϫⲉ ⲡⲉⲧⲥⲟⲛϩ ⲡⲁⲩⲗⲟⲥ ⲁϥⲙⲟⲩϯ ⳿ⲉⲣⲟⲓ ⲁϥϫⲟⲥ ⲛⲏⲓ ⳿ⲉ⳿ⲓⲛⲓ ⳿ⲙⲡⲁⲓϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲟⲕ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⲟⲩϩⲱⲃ ⳿ⲉϫⲟϥ ⲛⲁⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ⲁϥ⳿ⲁⲙⲁϩⲓ ⲇⲉ ⳿ⲛⲧⲉϥϫⲓϫ ⳿ⲛϫⲉ ⲡⲓⲭⲓⲗⲓⲁⲣⲭ ⲟⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣ⳿ⲁⲛⲁⲭⲱⲣⲓⲛ ⲥⲁⲟⲩⲥⲁ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲁϥϣⲓⲛⲓ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩ ⲡⲉⲧⲉⲕⲟⲩⲱϣ ⳿ⲉϫⲟϥ ⲛⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ⲡⲉϫⲁϥ ϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲩⲥⲉⲙⲛⲏⲧⲥ ⳿ⲉⲧⲟⲃϩⲕ ⳿ⲛⲣⲁⲥϯ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉⲕ⳿ⲓⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲉⲡⲓⲙⲁⲛϯϩⲁⲡ ϩⲱⲥ ⲉⲕⲛⲁ⳿ⲉⲙⲓ ⲉⲑⲃⲏⲧϥ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","⳿ⲛⲑⲟⲕ ⲟⲩⲛ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⲡⲉⲕϩⲏⲧ ⲑⲱⲧ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟⲛ ϩⲟⲩ⳿ⲟ ⲅⲁⲣ ⳿ⲉⲙ̅ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲩϫⲱⲣϫ ⳿ⲉⲣⲟϥ ⲛⲁⲓ ⳿ⲉⲧⲁⲩⲧⲁⲣⲕⲉ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲩⲱⲙ ⲟⲩⲇⲉ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲱ ϣⲁⲧⲟⲩϧⲱⲧⲉⲃ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ϯⲛⲟⲩ ⲥⲉⲥⲉⲃⲧⲱⲧ ⲉⲩϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲱϣ ⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲟⲩⲛ ⲁϥⲭⲁ ⲡⲓϧⲉⲗϣ⳿⳿ⲓⲣⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉⲁϥϩⲟⲛϩⲉⲛ ⲛⲁϥ ⳿ⲉ⳿ϣⲧⲉⲙϫⲟⲥ ⳿ⲛ⳿ϩⲗⲓ ϫⲉ ⲁⲕⲧⲁⲙⲟⲓ ⳿ⲉⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ⲟⲩⲟϩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲃ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲡⲉϫⲁϥ ⲛⲱⲟⲩ ϫⲉ ⲥⲉⲃⲧⲉ ⲥ̅ ⳿ⲙⲙⲁⲧⲟⲓ ϩⲟⲡⲱⲥ ⳿ⲛⲥⲉϣⲉ ϣⲁ Ⲕⲉⲥⲁⲣⲓ⳿ⲁ ⲛⲉⲙ ⲟ̅ ⳿ⲛϩⲓⲡⲉⲩⲥ ⲛⲉⲙ ⲥ̅ ⳿ⲛⲣⲉϥϩⲓⲗⲟⲅⲭⲏ ⲓⲥϫⲉⲛ ⳿ⲫⲛⲁⲩ ⳿ⲛⲁϫⲡⲅ̅ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","⳿ⲛⲥⲉϭⲓ ⳿ⲛϩⲁⲛⲕ⳿ⲉⲧⲉⲃⲛⲱⲟⲩ⳿ⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲟⲩⲧⲁⲗⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲛⲧⲟⲩⲛⲁϩⲙⲉϥ ϣⲁ ⲫⲩⲗⲓⲝ ⲡⲓϩⲏⲅⲉⲙⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ⲁϥ⳿ⲥϧⲁⲓ ⲇⲉ ⳿ⲛⲟⲩ⳿ⲉⲡⲓⲥⲧⲟⲗⲏ⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲁⲥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩⲧⲩⲡⲟⲥ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","⳿ⲕⲗⲁⲩⲇⲓⲟⲥ ⲗⲩⲥⲓⲁ ⳿ⲙⲡⲓ⳿ⲕⲣⲁⲧⲓⲥⲧⲟⲥ ⳿ⲛϩⲏⲅⲉⲙⲱⲛ ⲫⲩⲗⲓⲝ ⲭⲉⲣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ⲡⲁⲓⲣⲱⲙⲓ ⲁⲩⲧⲁϩⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲉⲩⲙⲉⲩⲓ ⳿ⲉϧⲟⲑⲃⲉϥ ⲁⲓϣ⳿ⲉⲛⲉⲙ ⲡⲓ⳿ⲥⲧⲣⲁⲧⲉⲩⲙⲁ ⲁⲓⲛⲁϩⲙⲉϥ ⳿ⲉⲧⲁⲓ⳿ⲉⲙⲓ ϫⲉ ⲟⲩⲣⲱⲙⲉⲟⲥ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ⲉⲓⲟⲩⲱϣ ⲇⲉ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉϯⲗⲱⲓϫⲓ ⲉⲧⲟⲩϫⲉⲙ ⳿ⲁⲣⲓⲕⲓ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲏⲧⲥ ⲁⲓ⳿ⲉⲛϥ ⳿ⲉϫⲉⲛ ⲡⲟⲩⲙⲁ⳿ⲛϯϩⲁⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ⲫⲁⲓ ⳿ⲉⲧⲁⲓϫⲉⲙϥ ⲉⲩϫⲉⲙ ⳿ⲁⲣⲓⲕⲓ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉ ϩⲁⲛⲍⲏⲧⲏⲙⲁ ⳿ⲛⲧⲉ ⲡⲟⲩⲛⲟⲙⲟⲥ ⳿ⲙⲡⲓϫⲉⲙ ⲛⲟⲃⲓ ⲇⲉ ⳿ⲛϧⲏⲧϥ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲓⲉ ϩⲁⲛ⳿ⲥⲛⲁⲩϩ ⳿ⲛⲧⲉ ⲟⲩⲉⲅ⳿ⲕⲗⲏⲙⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","⳿ⲉⲧⲁⲩⲧⲁⲙⲟⲓ ⲇⲉ ⲉⲑⲃⲉ ⲟⲩⲥⲟϭⲛⲓ ⲉϥϩⲱⲟⲩ ⲉϥⲛⲁϣⲱⲡⲓ ϧⲁ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧⲟⲩ ⲥⲁⲧⲟⲧ ⲁⲓⲟⲩⲟⲣⲡϥ ϩⲁⲣⲟⲕ ⳿ⲉⲁⲓϩⲟⲛϩⲉⲛ ⳿ⲉⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉϥⲕⲁⲧⲏⲅⲟⲣⲟⲥ ⲉⲑⲣⲟⲩⲥⲁϫⲓ ⲛⲁϩⲣⲁⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ⲛⲓⲙⲁⲧⲟⲓ ⲙⲉⲛ ⲟⲩⲛ ⲕⲁⲧⲁ ⲡⲉⲧⲁⲩⲑⲁϣ ⲛⲱⲟⲩ ⲁⲩ⳿ⲱⲗⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⳿ⲛϫⲱⲣϩ ⳿ⲉⲁⲩⲉⲛϥ ⳿ⲉⲁⲛⲧⲓⲡⲁⲧⲣⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲩⲭⲱ ⳿ⲛⲛⲓϩⲓⲡⲉⲩⲥ ⲉⲑⲣⲟⲩϣ⳿ⲉⲛⲉⲙⲁϥ ⲁⲩⲕⲟⲧⲟⲩ ⳿ⲉϯⲡⲁⲣⲉ⳿ⲙⲃⲟⲗⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ⲛⲁⲓ ⲇⲉ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϯ ⳿ⲛϯⲉⲡⲓⲥⲧⲟⲗⲏ⳿ⲙⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲁⲩⲧⲁϩⲟ ⳿ⲙ⳿ⲡⲕⲉⲡⲁⲩⲗⲟⲥ ⲛⲁϩⲣⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","⳿ⲉⲧⲁϥⲱϣ ⲇⲉ ⳿ⲛϯⲉⲡⲓⲥⲧⲟⲗⲏⲁϥϣⲓⲛⲓ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲁϣ ⳿ⲛ⳿ⲉⲡⲁⲣⲭⲓ⳿ⲁ ⲡⲉ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥ⳿ⲉⲙⲓ ϫⲉ ⲟⲩ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲕⲩⲗⲓⲕⲓ⳿ⲁ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ⲉⲓ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲕ ⲡⲉϫⲁϥ ϩⲟⲧⲁⲛ ⲁⲩϣⲁⲛ⳿ⲓ ⳿ⲛϫⲉ ⲛⲉⲕⲕⲁⲧⲏⲅⲟⲣⲟⲥ ⲟⲩⲟϩ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲉⲑⲣⲟⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲡⲓ⳿ⲡⲣⲉⲧⲱⲣⲓⲟⲛ ⳿ⲛⲧⲉ Ⲏ̇ⲣⲱⲇⲏⲥ . ");
INSERT INTO copcnt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ⲙⲉⲛⲉⲛⲥⲁ ⲉ̅ ⲇⲉ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛϫⲉ ⲡⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⳿ⲁⲛⲁⲛⲓⲁⲥ ⲛⲉⲙ ϩⲁⲛ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⲛⲉⲙ ⲕⲉⲣⲏⲧⲱⲣ ϫⲉ ⲧⲉⲣⲧⲩⲗⲗⲟⲥ ⲛⲁⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲁⲩⲟⲩⲱⲛϩ ⳿ⲙⲡⲓϩⲏⲅⲉⲙⲱⲛ ϧⲁ ⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","⳿ⲉⲧⲁⲩⲙⲟⲩϯ ⲇⲉ ⳿ⲉⲣⲟϥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲛϫⲉ ⲧⲉⲣⲧⲩⲗⲗⲟⲥ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲥϣⲟⲡ ⳿ⲛϫⲉ ⲟⲩϩⲓⲣⲏⲛⲏ ⲉⲥⲟϣ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ⲛⲉⲙ ϩⲁⲛⲧⲁϩⲟ ⳿ⲉⲣⲁⲧⲟⲩ ⲉⲩϣⲟⲡ ⳿ⲙⲡⲁⲓⲉⲑⲛⲟⲥ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲉⲕϥⲓⲣⲱⲟⲩϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ⲥⲁⲥⲁ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⲧⲉⲛϣⲱⲡ ⳿ⲙⲙⲟⲕ ⳿ⲕⲣⲁⲧⲓⲥⲑⲉ ⲫⲩⲗⲓⲝ ϧⲉⲛ ϣⲉⲡ⳿ϩⲙⲟⲧ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ϩⲓⲛⲁ ⲇⲉ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙⲧⲁϩⲛⲟ ⳿ⲙⲙⲟⲕ ⳿ⲛϩⲟⲩ⳿ⲟ ϯⲧⲱⲃϩ ⳿ⲙⲙⲟⲕ ⳿ⲉ⳿ⲑⲣⲉⲕⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ ϧⲉⲛ ⲟⲩϣⲱⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲧⲉⲕⲙ⳿ⲉⲧⲉⲡⲓⲕⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ⲁⲛϫⲓⲙⲓ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲱⲙⲓ ⳿ⲛⲗⲟⲓⲙⲟⲥ ⲉϥⲕⲓⲙ ⳿ⲛϩⲁⲛ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ ⲉⲧϣⲟⲡ ϧⲉⲛ ϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ ⲉϥⲟⲓ ⳿ⲛϩⲟⲩⲓⲧ ⲉⲧϩⲉⲣⲉⲥⲓⲥ ⳿ⲛⲧⲉ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ⲫⲁⲓ ⳿ⲉⲧⲁϥϭⲱⲛⲧ ⳿ⲉⲥⲱϥ ⳿ⲙⲡⲓⲕⲉⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲁⲛ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ⲫⲁⲓ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲑⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ⲁⲕϣⲁⲛϧⲉⲧϧⲱⲧϥ ⲉⲑⲃⲉ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⳿ⲉⲧ⳿ⲉⲛⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲏⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ⲁⲩⲟⲩⲁϩⲧⲟⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ϫⲉ ⲛⲁⲓ ϣⲟⲡ ⳿ⲙⲡⲁⲓⲣⲏϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲧⲁϥ ϭⲱⲣⲉⲙ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲉⲑⲣⲉϥⲥⲁϫⲓ ⲉⲓⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲕ ⲓⲥ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲟⲙⲡⲓ ⲉⲕⲟⲓ ⳿ⲛⲣⲉϥϯϩⲁⲡ ⳿ⲉⲡⲁⲓ⳿ϣⲗⲱⲗ ϯⲛⲁⲉⲣⲟⲩⲱ ϧⲉⲛ ⲟⲩⲟⲩⲛⲟϥ ⳿ⲛϩⲏⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","⳿ⲉⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉ⳿ⲉⲙⲓ ϫⲉ ⳿ⲙⲡⲁⲛⲧⲉ ϩⲟⲩ⳿ⲟ ⲓ̅ⲃ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⲓⲥϫⲉⲛ ⳿ⲉⲧⲁⲓϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲟⲩⲱϣⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ⲟⲩⲇⲉ ⳿ⲙⲡⲟⲩϫⲉⲙⲧ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲉⲓⲥⲁϫⲓ ⲛⲉⲙ ⲟⲩⲁⲓ ⲟⲩⲇⲉ ⲉⲓ⳿ϣⲑⲟⲣⲧⲉⲣ ⳿ⲛⲟⲩⲙⲏϣ ⲟⲩⲇⲉ ϧⲉⲛ ⲛⲓⲥⲩⲛⲁⲅⲱⲅⲏ ⲟⲩⲇⲉ ⲕⲁⲧⲁ ⲡⲟⲗⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲧⲁϩⲉ ⲛⲁⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⲛⲁⲓ ⲉⲧⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲙⲙⲱⲟⲩ ϧⲁⲣⲟⲓ ϯⲛⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ϯⲟⲩ⳿ⲱⲛϩ ⲇⲉ ⳿ⲙⲫⲁⲓ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ϫⲉ ⲕⲁⲧⲁ ⲡⲁⲓⲙⲱⲓⲧ ⳿ⲉⲧⲉ ⲛⲁⲓ ϫⲱ ⳿ⲙⲙⲟϥ ϫⲉ ϩⲉⲣⲉⲥⲓⲥ ⲁⲓϣⲉⲙϣⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲙⲪϯ ⳿ⲛⲧⲉ ⲛⲁⲓⲟϯ ⲉⲓⲛⲁϩϯ ⳿ⲉⲛⲏⲧⲏⲣⲟⲩ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","⳿ⲉⲟⲩⲟⲛ ⳿ⲛⲧⲏⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩϩⲉⲗⲡⲓⲥ ⳿ⲉⲫϯ ⲑⲏ⳿ⲉⲧⲉ ⲛⲁⲓ ϩⲱⲟⲩ ⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱⲥ ϯ⳿⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲛⲛⲓ⳿ⲑⲙⲏⲓ ⲛⲉⲙ ⲛⲓⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲫⲁⲓ ϯⲛⲁⲉⲣⲁⲥⲕⲓⲛ ϩⲱ ⲉⲑⲣⲉⲥϣⲱⲡⲓ ⲛⲏⲓ ⳿ⲛϫⲉ ⲟⲩⲥⲩⲛⲏⲇⲉⲥⲓⲥ ⳿ⲛⲁⲧϭⲣⲟⲡ ⲛⲁϩⲣⲉⲛ Ⲫϯ ⲛⲉⲙ ⲛⲁϩⲣⲉⲛ ⲛⲓⲣⲱⲙⲓ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","⳿ⲉⲃⲟⲗ ⲇⲉ ϩⲓⲧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲟⲙⲡⲓ ⲁⲓ⳿ⲓ ⳿ⲉ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛⲙⲉⲑⲛⲁⲏⲧ ⳿ⲙⲡⲁⲉⲑⲛⲟⲥ ⲛⲉⲙ ϩⲁⲛⲡⲣⲟⲥⲫⲱⲣⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ⲛⲁⲓ ⳿ⲉⲧⲁⲩϫⲉⲙⲧ ⲉⲓⲧⲟⲩⲃⲏⲟⲩⲧ ⳿ⲛϧⲏⲧⲟⲩ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⲁⲛ ⲟⲩⲇⲉ ⲛⲉⲙ ⲟⲩ⳿ϣⲑⲟⲣⲧⲉⲣ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ϩⲁⲛⲓⲒⲟⲩⲇⲁⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯⲁⲥⲓ⳿ⲁ ⲛⲁⲓ ⳿ⲉⲧⲉⲛⲁⲥ⳿ⲥϣⲉ ⳿ⲛⲥⲉ⳿ⲓ ⲛⲁϩⲣⲁⲕ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⲓⲥϫⲉ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲟⲩ ⳿ⲛⲟⲩϩⲱⲃ ⲛⲉⲙⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","⳿ⲙⲙⲟⲛ ⲛⲁⲓ ⳿ⲛⲑⲱⲟⲩ ⲙⲁⲣⲟⲩϫⲟⲥ ϫⲉ ⲟⲩ ⳿ⲛϭⲓ⳿ⲛϫⲟⲛⲥ ⲁⲩϫⲉⲙϥ ⳿ⲛϧⲏⲧ ⲉⲓ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲛϯϩⲁⲡ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ⲓⲉ ⲉⲑⲃⲉ ⲧⲁⲓ⳿ⲥⲙⲏ ⳿ⲛⲟⲩⲱⲧ ⲑⲁⲓ ⳿ⲉⲧⲁⲓⲟϣⲥ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲉⲓ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ϫⲉ ⲉⲑⲃⲉ ⳿ⲧ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲁⲛⲟⲕ ⲥⲉϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ⳿ⲙⲫⲟⲟⲩ ϩⲓ ⲑⲏⲛⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ⲁϥϩⲓⲧⲟⲩ ⲇⲉ ⳿ⲉⲫⲁϩⲟⲩ ⳿ⲛϫⲉ ⲫⲩⲗⲓⲝ ⲉϥ⳿ⲉⲙⲓ ϧⲉⲛ ⲟⲩⲧⲁϫⲣⲟ ⲉⲑⲃⲉ ⲛⲁ ⲡⲓⲙⲱⲓⲧ ⳿ⲉⲁϥϫⲟⲥ ϫⲉ ⳿ⲉϣⲱⲡ ⲁϥϣⲁⲛ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲛϫⲉ ⲗⲩⲥⲓⲁⲥ ⲡⲓⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲉⲓ⳿ⲉ⳿ⲉⲙⲓ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","⳿ⲉⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲉⲧ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⳿ⲉϯ⳿ⲙⲧⲟⲛ ⲇⲉ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲉ⳿ϣⲧⲉⲙϣⲉϣⲧ ⳿ϩⲗⲓ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲛⲟⲩϥ ⳿ⲉϣⲉⲙϣⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ⲙⲉⲛⲉⲛⲥⲁ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲫⲩⲗⲓⲝ ⲛⲉⲙ ⳿ⲇⲣⲟⲩⲥⲓⲗⲗⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲟⲩⲒⲟⲩⲇⲁⲓ ⲧⲉ ⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲥⲁ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⲁϥⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ ⲉⲑⲃⲉ ⲡⲓⲛⲁϩϯ ⳿ⲉⲠⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ⲉϥⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲉⲑⲃⲉ ϯⲙⲉⲑⲙⲏⲓ ⲛⲉⲙ ϯⲉⲅⲕⲣⲁⲧⲓ⳿ⲁ ⲛⲉⲙ ⲡⲓϩⲁⲡ ⲉⲑⲛⲁϣⲱⲡⲓ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲇⲉ ϧⲉⲛ ⲟⲩϩⲟϯ ⳿ⲛϫⲉ ⲫⲩⲗⲓⲝ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ϫⲉ ⲙⲟϣⲓ ϯⲛⲟⲩ ⲁⲓϣⲁⲛϭⲓ ⲇⲉ ⳿ⲛⲟⲩⲥⲏⲟⲩ ϯⲛⲁⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ⲁⲙⲁ ⲇⲉ ⲛⲁϥⲉⲣϩⲉⲗⲡⲓⲥ ϫⲉ ⲡⲁⲩⲗⲟⲥ ⲛⲁϯ ⳿ⲛϩⲁⲛ⳿ⲭⲣⲏⲙⲁ ⲛⲁϥ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⳿ⲛⲧⲉϥⲭⲁϥ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲁϥⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱϥ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⲉϥⲥⲁϫⲓ ⲛⲉⲙⲁϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","⳿ⲉⲧⲁⲩϫⲱⲕ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲣⲟⲙⲡⲓ ⳿ⲥⲛⲟⲩϯ ⲁϥϭⲓ ⳿ⲛⲟⲩⲇⲓⲁⲧⲟⲭⲟⲥ ⳿ⲛϫⲉ ⲫⲩⲗⲓⲝ ⲡⲟⲣⲕⲓⲟⲥ ⲫⲏⲥⲧⲟⲥ ⲉϥⲟⲩⲱϣ ⲇⲉ ⳿ⲉϯ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲛϫⲉ ⲫⲩⲗⲓⲝ ⲁϥⲥⲱϫⲡ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲉϥⲥⲟⲛϩ . ");
INSERT INTO copcnt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ⲫⲏⲥⲧⲟⲥ ⲟⲩⲛ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲉϯⲉⲡⲁⲣⲭⲓⲁ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲕⲉⲥⲁⲣⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓϩⲟⲩⲁϯ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲑⲃⲉ ⲡⲁⲩⲗⲟⲥ ⲟⲩⲟϩ ⲛⲁⲩϯϩⲟ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ⲉⲩⲉⲣ⳿ⲉⲧⲓⲛ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ϧⲁⲣⲟϥ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉϥⲟⲩⲱⲣⲡ ⳿ⲛⲥⲱϥ ⳿ⲉ⳿ⲉⲛϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲉⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩ⳿ⲭⲣⲟϥ ⳿ⲉϧⲟⲑⲃⲉϥ ϩⲓ ⲡⲓⲙⲱⲓⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ⲫⲏⲥⲧⲟⲥ ⲟⲩⲛ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ϫⲉ ⲥⲉ⳿ⲁⲣⲉϩ ⳿ⲉⲡⲁⲩⲗⲟⲥ ϧⲉⲛ Ⲕⲉⲥⲁⲣⲓ⳿ⲁ ⳿ⲛⲑⲟϥ ⲇⲉ ⲉϥⲙⲉⲩⲓ ⳿ⲉϣⲉ ⳿ⲉⲙⲁⲩ ⳿ⲛⲭⲱⲗⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ⲛⲏⲟⲩⲛ ⲡⲉϫⲁϥ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲁⲣⲟⲩ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⲛⲉⲙⲏⲓ ⲓⲥϫⲉ ⲟⲩⲟⲛ ⲟⲩϩⲱⲃ ⲉϥϩⲱⲟⲩ ϧⲉⲛ ⲡⲁⲓⲣⲱⲙⲓ ⲙⲁⲣⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲛϩⲟⲩ⳿ⲟ ⲏ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲛ ⲓⲉ ⲓ̅ ⲁϥ⳿ⲓ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⳿ⲉⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁϥϩⲉⲙⲥⲓ ϩⲓ ⲡⲓⲃⲏⲙⲁ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉ⳿ⲑⲣⲟⲩ⳿ⲓⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","⳿ⲉⲧⲁϥⲓ ⲇⲉ ⲁⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲁⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲉⲧⲁⲩ⳿ⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲉⲩ⳿ⲓⲛⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲗⲱⲓϫⲓ ⲉⲩϩⲟⲣϣ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ⲛⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛⲧⲁϩⲱⲟⲩ ⳿ⲉⲣⲁⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ⲉϥⲉⲣⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϫⲉ ⲟⲩⲇⲉ ⳿ⲙⲡⲓⲉⲣⲛⲟⲃⲓ ⳿ⲉ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲟⲩⲇⲉ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲇⲉ ⳿ⲡⲟⲩⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ⲫⲏⲥⲧⲟⲥ ⲇⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉⲉⲣ⳿ϩⲙⲟⲧ ⳿ⲛⲛⲓⲒⲟⲩⲇⲁⲓ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲡⲉϫⲁϥ ⳿ⲙⲡⲁⲩⲗⲟⲥ ϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲉϣⲉ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲉϭⲓϩⲁⲡ ⳿ⲙⲙⲁⲩ ϧⲁⲧⲟⲧⲟⲩ ⲉⲑⲃⲉ ⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ϯ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ϩⲓϫⲉⲛ ⲡⲓⲃⲏⲙⲁ ⳿ⲛⲧⲉ ⳿ⲡⲟⲩⲣⲟ ⲡⲓⲙⲁ ⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲟⲩϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ⳿ⲙⲙⲟϥ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲇⲉ ⳿ⲙⲡⲓϭⲓⲧⲟⲩ ⳿ⲛϫⲟⲛⲥ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ϩⲱⲕ ⳿ⲉⲧⲉⲕⲥⲱⲟⲩⲛ ⳿ⲉⲙⲁϣⲱ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ⲓⲥϫⲉ ⲟⲩⲛ ϯϭⲓ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ⲓⲥϫⲉ ⲁⲓⲉⲣ⳿ϩⲗⲓ ⳿ⲛϩⲱⲃ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲓⲉ ϯⲉⲣⲡⲁⲣⲁⲧⲓⲥⲑⲉ ⲁⲛ ⳿ⲉⲙⲟⲩ ⲓⲥϫⲉ ⲇⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϣⲟⲡ ϧⲉⲛ ⲛⲏⲉⲧⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟⲓ ⳿ⲛϫⲉ ⲛⲁⲓ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⲧⲏⲓⲧ ⲛⲱⲟⲩ ⳿ⲛ⳿ϩⲙⲟⲧ ϯⲉⲣⲉⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ⲧⲟⲧⲉ ⳿ⲁ ⲫⲏⲥⲧⲟⲥ ⲥⲁϫⲓ ⲛⲉⲙ ⲡⲓⲥⲩⲙⲃⲟⲩⲗⲟⲛ ⲁϥ⳿ⲉⲣⲟⲩ⳿ⲱ ⲁⲕⲉⲣⲉⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲉⲕ⳿ⲉϣⲉ ϣⲁ ⳿ⲡⲟⲩⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","⳿ⲉⲧⲁⲩⲥⲓⲛⲓ ⲇⲉ ⳿ⲛϫⲉ ϩⲁⲛ⳿ⲉϩⲟⲟⲩ ⲁⲅⲣⲓⲡⲡⲁⲥ ⳿ⲡⲟⲩⲣⲟ ⲛⲉⲙ ⲃⲉⲣⲛⲓⲕⲏⲁⲩⲉⲣⲕⲁⲧⲁⲛⲧⲁⲛ ⳿ⲉⲔⲉⲥⲁⲣⲓ⳿ⲁ ⲁⲩⲉⲣⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲙⲫⲏⲥⲧⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","⳿ⲉⲧⲁⲩⲉⲣ ⲟⲩⲙⲏϣ ⲇⲉ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲙⲁⲩ ⳿ⲁ ⲫⲏⲥⲧⲟⲥ ⲭⲁ ⳿ⲡϩⲱⲃ ⳿ⲙⲡⲁⲩⲗⲟⲥ ϧⲁⲧⲟⲧϥ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲟⲩⲟⲛ ⲟⲩⲣⲱⲙⲓ ⲉϥⲥⲟⲛϩ ⳿ⲉⲁϥⲥⲱϫⲡ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲫⲩⲗⲓⲝ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ⲉⲧⲁⲓϣⲉ ⲇⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⲁⲩⲟⲩⲟⲛϩⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⲛⲉⲙ ⲛⲓ⳿ⲡⲣⲉⲥⲃⲩⲧⲉⲣⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲩⲉⲣ⳿ⲉⲧⲓⲛ ϧⲁⲣⲟϥ ⳿ⲛⲟⲩⲕⲁⲧⲁⲧⲓⲕⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ⲁⲓⲟⲩⲱϩⲉⲙ ⲇⲉ ⲛⲱⲟⲩ ⲉⲓϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲟⲩⲥⲩⲛⲏⲑⲓⲁ ⲁⲛ ⲧⲉ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲉⲟⲥ ⳿ⲉϯ ⳿ⲛⲟⲩⲣⲱⲙⲓ ⳿ⲛ⳿ϩⲙⲟⲧ ⳿ⲙⲡⲁⲧⲟⲩ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲕⲁⲧⲏⲅⲟⲣⲟⲥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫⲏⲉⲧⲟⲩⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϫⲉⲙ ⲙⲁ ⳿ⲛϯ ⳿ⲛⲧⲉϥⲁⲡⲟⲗⲟⲅⲓⲁ ⲉⲑⲃⲉ ⲡⲓⲁⲣⲓⲕⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","⳿ⲉⲧⲁⲩ⳿ⲓ ⲟⲩⲛ ⲛⲉⲙⲏⲓ ⳿ⲉⲡⲁⲓⲙⲁ ⳿ⲙⲡⲓⲉⲣ ⳿ϩⲗⲓ ⳿ⲛϭⲓϩⲟ ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲓϩⲉⲙⲥⲓ ϩⲓ ⲡⲓⲃⲏⲙⲁ ⲁⲓⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲉ⳿ⲑⲣⲟⲩ⳿ⲓⲛⲓ ⳿ⲙⲡⲓⲣⲱⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ⲟⲩⲟϩ ⲫⲁⲓ ⳿ⲉⲧⲁ ⲛⲓⲕⲁⲧⲏⲅⲟⲣⲟⲥ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲟⲩ ϧⲁⲣⲟϥ ⲛⲁⲩ⳿ⲓⲛⲓ ⳿ⲛϩⲁⲛⲗⲱⲓϫⲓ ⲁⲛ ϧⲉⲛ ⲛⲏ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲙⲉⲩⲓ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲥⲉϩⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ϩⲁⲛⲍⲏⲧⲏⲙⲁ ⲟⲩⲛ ⲛⲱⲟⲩ ⲟⲩⲧⲱⲟⲩ ⲛⲉⲙⲁϥ ⲉⲑⲃⲉ ⲟⲩ⳿ⲥⲃⲱ ⳿ⲛⲓϧ ⳿ⲛⲧⲱⲟⲩ ⲛⲉⲙ ⲉⲑⲃⲉ ⲟⲩⲁⲓ ϫⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲁϥⲙⲟⲩ ⲫⲁⲓ ⳿ⲉⲛⲁⲣⲉ ⲡⲁⲩⲗⲟⲥ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲟⲛϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ⲛⲁⲓⲧⲱⲙⲧ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲉⲑⲃⲉ ⲛⲁⲓⲍⲏⲧⲏⲙⲁ ⳿ⲛⲧⲉ ⲛⲁⲓ ⲛⲁⲓϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥϫⲉ ⳿ⲭⲟⲩⲱϣ ⳿ⲉϣⲉ ⳿ⲉⲒⲗ̅ⲏ̅ⲙ̅ ⳿ⲛⲥⲉϯϩⲁⲡ ⳿ⲉⲣⲟⲕ ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲉ ⲛⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ⲉⲧⲁ ⲡⲁⲩⲗⲟⲥ ⳿ⲉⲣⲉ ⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲁⲓ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ⲡⲥⲟⲩⲉⲛ ⳿ⲡⲟⲩⲣⲟ ⲁⲓⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⲉⲑⲣⲟⲩ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ ϣⲁ ϯⲟⲩⲟⲣⲡϥ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ⲁⲅⲣⲓⲡⲡⲁⲥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲥⲧⲟⲥ ϫⲉ ⲛⲁⲓⲟⲩⲱϣ ϩⲱ ⲡⲉ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲣⲱⲙⲓ ⲣⲁⲥϯ ⲅⲁⲣ ⲡⲉϫⲁϥ ⲉⲕ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ⲡⲉϥⲣⲁⲥϯ ⲟⲩⲛ ⳿ⲉⲧⲁϥ⳿ⲓ ⳿ⲛϫⲉ ⲁⲅⲣⲓⲡⲡⲁ ⲛⲉⲙ ⲃⲉⲣⲛⲓⲕⲏⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲙⲫⲁⲛⲧⲁⲥⲓ⳿ⲁ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲙⲁ ⳿ⲛϭⲓ⳿ⲥⲙⲏ ⲛⲉⲙ ϩⲁⲛⲭⲓⲗⲓⲁⲣⲭⲟⲥ ⲛⲉⲙ ϩⲁⲛⲣⲱⲙⲓ ⲉⲩⲟⲓ ⳿ⲛⲛⲓϣϯ ⳿ⲛⲧⲉ ϯⲡⲟⲗⲓⲥ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲉⲣⲕⲉⲗⲉⲩⲓⲛ ⳿ⲛϫⲉ ⲫⲏⲥⲧⲟⲥ ⲁⲩ⳿ⲓⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ⲟⲩⲟϩ ⲡⲉϫⲉ ⲫⲏⲥⲧⲟⲥ ϫⲉ ⳿ⲡⲟⲩⲣⲟ ⲁⲅⲣⲓⲡⲡⲁ ⲛⲉⲙ ⲛⲓⲣⲱⲙⲓ ⲧⲏⲣⲟⲩ ⲉⲑⲛⲉⲙⲁⲛ ⲧⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲫⲁⲓ ⲉⲑⲃⲏⲧϥ ⳿ⲁ ⲡⲓⲙⲏϣ ⲧⲏⲣϥ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲥ⳿ⲉⲙⲓ ⲛⲏⲓ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ϧⲉⲛ ⲡⲁⲓⲕⲉⲙⲁ ⲉⲩⲱϣ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ϥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲱⲛϧ ⲁⲛ ϫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","⳿ⲁⲛⲟⲕ ⲇⲉ ⲁⲓ⳿ⲉⲙⲓ ⳿ⲉⲣⲟϥ ϫⲉ ⳿ⲙⲡⲉϥⲉⲣ ⳿ϩⲗⲓ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲫⲁⲓ ⲇⲉ ⳿ⲛⲑⲟϥ ⳿ⲉⲧⲁϥⲉⲣⲉⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲁⲓϯϩⲁⲡ ⳿ⲉⲟⲩⲟⲣⲡϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ⲫⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲟⲛ ⲡⲉϯⲛⲁ⳿ⲥϧⲏⲧϥ ⳿ⲛⲧⲁϫⲣⲟ ⲉⲑⲃⲏⲧϥ ⳿ⲙⲠⲁ⳪ ⳿ⲡⲟⲩⲣⲟ ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓ⳿ⲉⲛϥ ⲛⲁϩⲣⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲙⲁⲗⲓⲥⲧⲁ ⲛⲁϩⲣⲁⲕ ⳿ⲡⲟⲩⲣⲟ ⲁⲅⲣⲓⲡⲡⲁ ϩⲟⲡⲱⲥ ⳿ⲉⲁⲕϣⲉⲛϥ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲛⲧⲁϫⲉⲙ ⲡⲉϯⲛⲁ⳿ⲥϧⲏⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ϯⲙⲉⲩⲓ ⲅⲁⲣ ϫⲉ ⲟⲩϩⲱⲃ ⳿ⲛⲁⲧⲥⲁϫⲓ ⲡⲉ ⳿ⲉⲟⲩⲟⲣⲡ ⳿ⲙⲡⲉⲧⲥⲟⲛϩ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣⲥⲩⲙⲉⲛⲓⲛ ⳿ⲛⲛⲉϥⲕⲉⲗⲱⲓϫⲓ ⲉⲧϭⲓ ⳿ⲉⲣⲟϥ . ");
INSERT INTO copcnt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ⲁⲅⲣⲓⲡⲡⲁⲥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲙⲡⲁⲩⲗⲟⲥ ϫⲉ ⲥⲉⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲁⲕ ⳿ⲉⲥⲁϫⲓ ⳿ⲉϫⲱⲕ ⲧⲟⲧⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥⲥⲟⲩⲧⲉⲛ ⲧⲉϥϫⲓϫ ⳿ⲉⲃⲟⲗ ⲁϥⲉⲣⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ⲉⲑⲃⲉ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲟⲩϫⲉⲙ ⳿ⲁⲣⲓⲕⲓ ⳿ⲉⲣⲟϥ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲁⲅⲣⲓⲡⲡⲁ ϯⲙⲉⲩⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲙⲁⲕⲁⲣⲓⲟⲥ ⲉⲓⲛⲁⲉⲣⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ ⳿ⲙⲫⲟⲟⲩ ϧⲁⲧⲟⲧⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ⲙⲁⲗⲓⲥⲧⲁ ⲉⲕⲥⲱⲟⲩⲛ ⳿ⲛⲛⲓⲥⲩⲛⲏⲑⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲟⲩⲍⲏⲧⲏⲙⲁ ⲉⲑⲃⲉ ⲫⲁⲓ ϯ ⲧⲱⲃϩ ⳿ⲙⲙⲟⲕ ⲉⲑⲣⲉⲕⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧⲣⲉϥⲱⲟⲩ ⳿ⲛϩⲏⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ⲡⲁϫⲓⲛⲱⲛϧ ⲓⲥϫⲉⲛ ⲧⲁⲙⲉⲧⲁⲗⲟⲩ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⲓⲥϫⲉⲛ ϩⲏ ϧⲉⲛ ⲡⲁⲉⲑⲛⲟⲥ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲥⲉⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲧⲏⲣⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ⲉⲩⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲓ ⲓⲥϫⲉⲛ ⲥⲁ⳿ⲡϣⲱⲓ ⲁⲩϣⲁⲛⲟⲩⲱϣ ⳿ⲉⲉⲣⲙⲉⲑⲣⲉ ϫⲉ ⲕⲁⲧⲁ ϯϩⲉⲣⲉⲥⲓⲥ ⲉⲧⲧⲁϫⲣⲏⲟⲩⲧ ⳿ⲛⲧⲉ ⲡⲉⲛϣⲉⲙϣⲓ ⲁⲓⲱⲛϧ ⳿ⲙⲪⲁⲣⲓⲥⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲉⲑⲃⲉ ⳿ⲧϩⲉⲗⲡⲓⲥ ⳿ⲙⲡⲓⲱϣ ⳿ⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲛⲛⲉⲛⲓⲟϯ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲫϯ ϯ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ⲉⲩϯϩⲁⲡ ⳿ⲉⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","⳿ⲉⲧⲉ ⲧⲁⲓϩⲉⲗⲡⲓⲥ ⲧⲉ ⳿ⲉⲛⲁⲣⲉ ϯⲓ̅ⲃ̅ ⳿ⲙⲫⲩⲗⲏϣⲉⲙϣⲓ ϧⲉⲛ ⲟⲩⲙⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲛⲉⲙ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲉⲩⲟⲩⲱϣ ⲉⲑⲣⲉ ⲧⲟⲧⲟⲩ ϯⲙⲁϯ ⳿ⲉⲣⲟⲥ ⲉⲑⲃⲉ ⲧⲁⲓϩⲉⲗⲡⲓⲥ ⳿ⲡⲟⲩⲣⲟ ⲥⲉϫⲉⲙ ⳿ⲁⲣⲓⲕⲓ ⳿ⲉⲣⲟⲓ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ⲟⲩ ⲙⲉⲧⲁⲑⲛⲁϩϯ ⲧⲉ ⲙⲁϩⲁⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲓⲥϫⲉ Ⲫϯ ⲛⲁⲧⲟⲩⲛⲟⲥ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⲟⲩⲛ ⲛⲁⲓⲙⲉⲩⲓ ⳿ⲉⲣⲟⲓ ⳿ⲉⲉⲣ ⲟⲩⲙⲏϣ ⳿ⲛϩⲱⲃ ⲉⲩϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲛⲒⲏ̅ⲥ̅ ⲡⲓⲚⲁⲍⲱⲣⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ⲫⲁⲓ ⳿ⲉⲧⲁⲓⲁⲓϥ ϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲟⲩⲙⲏϣ ϧⲉⲛ ⲛⲏⲉⲑⲟⲩⲁⲃ ⳿ⲁⲛⲟⲕ ⲁⲓϩⲓⲧⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲓ⳿ϣⲧⲉⲕⲱⲟⲩ ⳿ⲉⲁⲓϭⲓ ⳿ⲙⲡⲓⲉⲣϣⲓϣⲓ ϩⲓⲧⲉⲛ ⲛⲓⲁⲣⲭⲏⲉⲣⲉⲩⲥ ⲉⲩϧⲱⲧⲉⲃ ⳿ⲙⲙⲱⲟⲩ ϣⲁⲓϯⲱⲡ ϧⲁⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ⲕⲁⲧⲁ ⲥⲩⲛⲁⲅⲱⲅⲏ ⲛⲓⲃⲉⲛ ⲉⲓϯ⳿ⲙⲕⲁϩ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⲛⲁⲓϭⲓ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲟⲛⲥ ⲉⲑⲣⲟⲩϫⲉⲟⲩ⳿ⲁ ϧⲉⲛ ⲟⲩⲙⲉⲧϩⲟⲩ⳿ⲟ ⲇⲉ ⲉⲓϧⲉⲛ ⲟⲩⲗⲓⲃⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲟⲩ ϣⲁⲓϭⲟϫⲓ ⳿ⲛⲥⲱⲟⲩ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲛⲓⲕⲉⲡⲟⲗⲓⲥ ⲉⲧⲥⲁⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ⲟⲩⲟϩ ϧⲉⲛ ⲛⲁⲓ ⲉⲓⲙⲟϣⲓ ⳿ⲉⲇⲁⲙⲁⲥⲕⲟⲥ ⲛⲉⲙ ⲟⲩⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲛⲉⲙ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲧⲉ ⲛⲓⲁⲣⲭⲏ⳿ⲉⲣⲉⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ⲉⲓϩⲓ ⲡⲓⲙⲱⲓⲧ ⲇⲉ ϧⲉⲛ ⳿ⲧⲫⲁϣⲓ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲁⲓⲛⲁⲩ ⳿ⲡⲟⲩⲣⲟ ⳿ⲉⲟⲩⲟⲩⲱⲓⲛⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧⲫⲉ ⲉϥⲫⲟⲣⲓ ⳿ⲉϩⲟⲧⲉ ⳿ⲫⲣⲏ ⲁϥ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ⲛⲉⲙ ⲛⲏⲉⲑⲛⲉⲙⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ⲉⲧⲁⲛϩⲉⲓ ⲇⲉ ⲧⲏⲣⲉⲛ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⲁⲓⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩ⳿ⲥⲙⲏ ⲉⲥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲏⲓ ϧⲉⲛ ϯⲁⲥⲡⲓ ⳿ⲙⲙⲉⲧϩⲉⲃⲣⲉⲟⲥ ϫⲉ ⲥⲁⲟⲩⲗ ⲥⲁⲟⲩⲗ ⳿ⲁϧⲟⲕ ⳿ⲕϭⲟϫⲓ ⳿ⲛⲥⲱⲓ ⲟⲩϩⲱⲃ ⲉϥⲛⲁϣⲧ ⲛⲁⲕ ⲡⲉ ⳿ⲉϯϣⲉⲛⲫⲁⲧ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ϩⲁⲛⲥⲟⲩⲣⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","⳿ⲁⲛⲟⲕ ⲇⲉ ⲡⲉϫⲏⲓ ϫⲉ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ Ⲡ⳪ Ⲡ⳪ ⲇⲉ ⲡⲉϫⲁϥ ⲛⲏⲓ ϫⲉ ⳿ⲁⲛⲟⲕ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⲫⲏ⳿ⲛⲑⲟⲕ ⳿ⲉⲧⲉⲕϭⲟϫⲓ ⳿ⲛⲥⲱϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ⲁⲗⲗⲁ ⲧⲱⲛⲕ ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧⲕ ⳿ⲉϫⲉⲛ ⲛⲉⲕϭⲁⲗⲁⲩϫ ⲉⲑⲃⲉ ⲫⲁⲓ ⲅⲁⲣ ⲁⲓⲟⲩⲟⲛϩⲧ ⳿ⲉⲣⲟⲕ ⳿ⲉⲥⲟⲧⲡⲕ ⳿ⲛⲟⲩϩⲩⲡⲉⲣⲉⲧⲏⲥ ⲛⲏⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲕⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲏⲉⲧⲁⲕⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲛⲏ⳿ⲉϯⲛⲁⲟⲩⲟⲛϩⲧ ⳿ⲉⲣⲟⲕ ⳿ⲛϧⲏⲧⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ⲉⲓ⳿ⲉⲛⲁϩⲙⲉⲕ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲛⲏ⳿ⲁⲛⲟⲕ ⳿ⲉϯⲛⲁⲟⲩⲟⲣⲡⲕ ⳿ⲉⲣⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","⳿ⲉⲁⲟⲩⲱⲛ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲉⲑⲣⲟⲩⲕⲟⲧⲟⲩ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡⲭⲁⲕⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ⲫⲟⲩⲱⲓⲛⲓ ⲛⲉⲙ ⳿ⲉⲃⲟⲗϩⲁ ⳿ⲡⲉⲣϣⲓϣⲓ ⳿ⲙ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲉⲫϯ ⲉⲑⲣⲟⲩϭⲓ ⳿ⲙ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲟⲩⲛⲟⲃⲓ ⲛⲉⲙ ⲟⲩ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓ⳿ⲁ ϧⲉⲛ ⲛⲏⲉⲧⲧⲟⲩⲃⲏⲟⲩⲧ ϧⲉⲛ ⲡⲓⲛⲁϩϯ ⳿ⲉⲣⲟⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲡⲟⲩⲣⲟ ⳿ⲁⲅⲣⲓⲡⲡⲁ ⳿ⲙⲡⲓϣⲉⲣⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲡⲓⲛⲁⲩ ⳿ⲛⲧⲉ ⳿ⲧⲫⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ⲁⲗⲗⲁ ⲛⲏⲉⲧϧⲉⲛ ⲇⲁⲙⲁⲥⲕⲟⲥ ⳿ⲛϣⲟⲣⲡ ⲛⲉⲙ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ⳿ⲧⲭⲱⲣⲁ ⲧⲏⲣⲥ ⳿ⲛⲧⲉ ϯⲒⲟⲩⲇⲉ⳿ⲁ ⲛⲉⲙ ⲛⲓⲉⲑⲛⲟⲥ ⲁⲓϩⲓⲱⲓϣ ⲛⲱⲟⲩ ⲉⲑⲣⲟⲩⲉⲣⲙⲉⲧⲁⲛⲟⲓⲛ ⲟⲩⲟϩ ⲉⲑⲣⲟⲩⲕⲟⲧⲟⲩ ⳿ⲉⲫϯ ⳿ⲉ⳿⳿ⲓⲣⲓ ⳿ⲛϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲉⲩ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛϯⲙⲉⲧⲁⲛⲟⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲁ ⲛⲓⲒⲟⲩⲇⲁⲓ ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟⲓ ϧⲉⲛ ⲡⲓⲉⲣⲫⲉⲓ ⲛⲁⲩϭⲱⲛⲧ ⳿ⲉ⳿ⲓⲛⲓ ⳿ⲛⲧⲟⲧⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ⲉⲧⲁⲓϭⲓ ⲇⲉ ⳿ⲛⲟⲩⲃⲟⲏⲑⲓ⳿ⲁ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ Ⲫϯ ⲁⲓ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ ⲉⲓⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲛⲉⲙ ⲟⲩⲛⲓϣϯ ⳿ⲛϯϫⲉ ⳿ϩⲗⲓ ⲁⲛ ⲥⲁⲃⲟⲗ ⳿ⲛⲛⲏ⳿ⲉⲧⲁ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϫⲟⲧⲟⲩ ⲛⲉⲙ Ⲙⲱ⳿ⲩⲥⲏⲥ ϫⲉ ⲥⲉⲛⲁϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ⲓⲥϫⲉ ⲟⲩⲣⲉϥϭⲓ⳿ⲙⲕⲁϩ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⲓⲥϫⲉ ⲟⲩϩⲟⲩⲓⲧ ⲡⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲧ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⳿ϥⲛⲁϩⲓⲱⲓϣ ⳿ⲛⲟⲩⲱⲓⲛⲓ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲛⲉⲙ ⲛⲓⲉⲑⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ⲛⲁⲓ ⲉϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲡⲉϫⲉ ⲫⲏⲥⲧⲟⲥ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲥⲙⲏ ϫⲉ ⲁⲕⲗⲓⲃⲓ ⲡⲁⲩⲗⲉ ⳿ⲁ ⲡⲓⲙⲏϣ ⳿ⲛ⳿ⲥϧⲁⲓ ⳿ⲑⲣⲉⲕⲗⲓⲃⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ϯⲗⲟⲃⲓ ⲁⲛ ⳿ⲕⲣⲁⲧⲓⲥⲑⲉ ⲫⲏⲥⲧⲉ ⲁⲗⲗⲁ ϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲛⲉⲙ ϯⲙ⳿ⲉⲧⲉⲩⲥⲉⲃⲏⲥ ⲛⲏ⳿ⲉϯϫⲱ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","⳿ϥⲥⲱⲟⲩⲛ ⲅⲁⲣ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲟⲩⲣⲟ ⲉⲑⲃⲉ ⲛⲁⲓ ⲫⲁⲓ ⳿ⲉϯⲟⲩⲟⲛϩ ⳿ⲙⲙⲟⲓ ⳿ⲉⲃⲟⲗ ⲉⲓⲥⲁϫⲓ ⲛⲉⲙⲁϥ ⲡⲁϩⲏⲧ ⲅⲁⲣ ⲑⲏⲧ ϫⲉ ⲟⲩⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲛⲁⲓ ⲟⲃϣ ⳿ⲉⲣⲟϥ ⲁⲛ ⲛⲉⲧⲁ ⲫⲁⲓ ⲅⲁⲣ ⲁⲛ ϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲉⲗⲕⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","⳿ⲭⲛⲁϩϯ ⳿ⲡⲟⲩⲣⲟ ⲁⲅⲣⲓⲡⲡⲁⲥ ⳿ⲉⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ϯⲥⲱⲟⲩⲛ ϫⲉ ⳿ⲭⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ⲁⲅⲣⲓⲡⲡⲁⲥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲙⲡⲁⲩⲗⲟⲥ ϫⲉ ⲕⲉⲕⲟⲩϫⲓ ⳿ⲭⲛⲁⲑⲉⲧ ⲡⲁϩⲏⲧ ⳿ⲉⲁⲓⲧ ⳿ⲛ⳿ⲭⲣⲏⲥⲧⲓ⳿ⲁⲛⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ⲡⲁⲩⲗⲟⲥ ⲇⲉ ⲡⲉϫⲁϥ ϫⲉ ϯⲧⲱⲃϩ ⳿ⲙⲪϯ ⲛⲉⲙ ϧⲉⲛ ⲟⲩⲕⲟⲩϫⲓ ⲛⲉⲙ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⲟⲩ ⲙⲟⲛⲟⲛ ⳿ⲛⲑⲟⲕ ⲁⲗⲗⲁ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲥⲱⲧⲉⲙ ⳿ⲉⲣⲟⲓ ⳿ⲙⲫⲟⲟⲩ ⲉⲑⲣⲟⲩϣⲱⲡⲓ ⳿ⲙⲡⲁⲣⲏϯ ⳿ⲙⲡⲓⲣⲏϯ ⳿ⲉϯⲟⲓ ⳿ⲙⲙⲟϥ ϩⲱ ϣⲁⲧⲉⲛ ⲛⲁ⳿ⲥⲛⲁⲩϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ⲁϥⲧⲱⲛϥ ⲇⲉ ⳿ⲛϫⲉ ⳿ⲡⲟⲩⲣⲟ ⲛⲉⲙ ⲡⲓϩⲏⲅⲉⲙⲱⲛ ⲛⲉⲙ ⲃⲉⲣⲛⲓⲕⲏⲛⲉⲙ ⲛⲏⲉⲧϩⲉⲙⲥⲓ ⲛⲉⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲉⲣⲁⲛⲁⲭⲱⲣⲓⲛ ⲛⲁⲩⲥⲁϫⲓ ⲛⲉⲙ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ϥⲉⲣ ⳿ϩⲗⲓ ⳿ⲛϩⲱⲃ ⲁⲛ ⳿ⲛϫⲉ ⲡⲁⲓⲣⲱⲙⲓ ⲉϥ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲓⲉ ϩⲁⲛ⳿ⲥⲛⲁⲩϩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ⲁⲅⲣⲓⲡⲡⲁⲥ ⲇⲉ ⲡⲉϫⲁϥ ⳿ⲙⲫⲏⲥⲧⲟⲥ ϫⲉ ⲛⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⲡⲉ ⳿ⲉⲭⲁ ⲡⲁⲓⲣⲱⲙⲓ ⳿ⲉⲃⲟⲗ ⳿⳿ⲉⲛⲉ ⳿ⲙⲡⲉϥⲉⲣⲉⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ . ");
INSERT INTO copcnt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁⲩϯϩⲁⲡ ⲉⲑⲣ⳿ⲉⲛⲉⲣϩⲱⲧ ⳿ⲉϯϩⲩⲧⲁⲗⲓ⳿ⲁ ⲁϥϯ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲛⲉⲙ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲩⲥⲟⲛϩ ⳿ⲉⲧⲟⲧϥ ⳿ⲛⲟⲩⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭ ⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲓⲟⲩⲗⲓⲟⲥ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲥⲡⲓⲣⲁ ⳿ⲛⲧⲉ ⲥⲁⲃⲁⲥⲧⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ⲁⲛ⳿ⲁⲗⲏⲓ ⲇⲉ ⳿ⲉⲟⲩϫⲟⲓ ⳿ⲛⲁⲛ⳿ⲇⲣⲁⲙⲁⲛⲧⲓⲛⲉⲟⲥ ⲉϥⲛⲁⲉⲣϩⲱⲧ ⳿ⲉⲛⲓⲙⲁ ⳿ⲛⲧⲉ ϯ⳿ⲁⲥⲓⲁ ⲁⲛϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⲉϥⲛⲉⲙⲁⲛ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲁⲣⲓⲥⲧⲁⲣ ⲭⲟⲥ ⳿ⲛⲧⲉ ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ⲡⲓⲣⲉⲙⲑⲉⲥⲥⲁⲗⲟⲛⲓⲕⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲁⲛ⳿ⲓ ⳿ⲉ⳿ⲧⲥⲩⲇⲱⲛ ⲁϥ⳿⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛⲟⲩⲙⲉⲧⲙⲁⲓⲣⲱⲙⲓ ⲛⲉⲙ ⲡⲁⲩⲗⲟⲥ ⳿ⲛϫⲉ ⲓⲟⲩⲗⲓⲟⲥ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲛⲁϥ ⲉⲑⲣⲉϥϣⲉ ϣⲁ ⲛⲉϥ⳿ϣⲫⲏⲣ ⳿ⲛⲥⲉϥⲓ ⲡⲉϥⲣⲱⲟⲩϣ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ⲟⲩⲟϩ ⲉⲧⲁⲛϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲛⲉⲣϩⲱⲧ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲕⲩⲡⲣⲟⲥ ⲉⲑⲃⲉ ϫⲉ ⲛⲁⲣⲉ ⲡⲓⲑⲏⲟⲩ ϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲛ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ⲉⲧⲁⲛⲉⲣϩⲱⲧ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲉⲡⲓⲡⲉⲗⲁⲅⲟⲥ ⲉⲧⲟⲩⲧⲱϥ ⳿ⲛⲕⲩⲡⲣⲟⲥ ⲛⲉⲙ ϯⲡⲁⲙⲫⲩⲗⲓ⳿ⲁ ⲁⲛ⳿ⲓ ⳿ⲉⲗⲩⲥⲧⲣⲁ ⳿ⲛⲧⲉ ϯⲕⲩⲗⲓⲕⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ⲟⲩⲟϩ ⳿ⲁ ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ϫⲓⲙⲓ ⳿ⲛⲟⲩϫⲟⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲧⲉ ⲣⲁⲕⲟϯ ⲉϥⲛⲁⲉⲣϩⲱⲧ ⳿ⲉϯϩⲩⲧⲁⲗⲓ⳿ⲁ ⲁϥⲧⲁⲗⲟⲛ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ⲉⲧⲁⲛⲱⲥⲕ ⲇⲉ ⳿ⲛⲉⲣϩⲱⲧ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⲙⲟⲅⲓⲥ ⲉⲧⲁⲛ⳿ⲓ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛ⳿ⲭⲛⲓⲇⲟⲥ ⳿ⲛ⳿ϥⲭⲱ ⳿ⲙⲙⲟⲛ ⲁⲛ ⳿ⲛϫⲉ ⲡⲓⲑⲏⲟⲩ ⲁⲛⲉⲣϩⲱⲧ ⲇⲉ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ϯ⳿ⲕⲣⲏⲧⲏ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲥⲁⲗⲙⲟⲛⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ⲙⲟⲅⲓⲥ ⲉⲧⲁⲛⲭⲁⲥ ⳿ⲛⲥⲱⲛ ⲁⲛ⳿ⲓ ⲉⲩⲙⲁ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲛⲓⲗⲩⲙⲏⲛ ⲉⲑⲛⲁⲛⲉⲩ ⲛⲁⲥϧⲉⲛⲧ ⲇⲉ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲟⲩⲡⲟⲗⲓⲥ ϫⲉ ⲗⲁⲥⲉⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","⳿ⲉⲧⲁϥⲥⲓⲛⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲭⲣⲟⲛⲟⲥ ⲟⲩⲟϩ ϩⲏⲇⲏ ⲛⲉ ⳿ⲡⲥⲏⲟⲩ ⲁⲛ ϫⲉ ⲡⲉ ⳿ⲛⲉⲣ⳿ⲡⲗⲉⲓⲛ ⲛⲉⲁ ⲡⲓϫⲟⲓ ⲅⲁⲣ ⲥⲱⲣⲉⲙ ⲡⲉ ⲉⲑⲃⲉ ϫⲉ ⲛⲉⲁ ϯⲕⲉⲛⲏⲥⲧⲓ⳿ⲁ ⲥⲓⲛⲓ ⲡⲉ ⲛⲁϥϯⲛⲟⲙϯ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⲛⲓⲣⲱⲙⲓ ϯⲛⲁⲩ ϫⲉ ⲟⲩⲟⲛ ⲟⲩϣⲱϣ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⳿ⲛⲟⲥⲓ ⲛⲁϣⲱⲡⲓ ⲟⲩ ⲙⲟⲛⲟⲛ ⳿ⲙⲡⲓϫⲟⲓ ⲛⲉⲙ ⲡⲓⲁⲟⲩⲓⲛ ⲁⲗⲗⲁ ⲛⲉⲙ ⲛⲉⲛⲕⲉⲯⲩⲭⲏ ϧⲉⲛ ⲡⲁⲓϫⲓⲛⲉⲣϩⲱⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲇⲉ ⲛⲁϥⲑⲏⲧ ⳿ⲛϩⲏⲧ ⲛⲉⲙ ⲡⲓⲣⲉϥⲉⲣϩⲉⲙⲓ ⲛⲉⲙ ⲡⲓⲛⲁⲩ⳿ⲕⲗⲏⲣⲟⲥ ⳿⳿ⲉϩⲟⲧⲉ ⲛⲏ⳿ⲉⲛⲁⲣⲉ ⲡⲁⲩⲗⲟⲥ ϫⲱ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ⲉⲛ⳿ϥ⳿ⲥⲙⲟⲛⲧ ⲇⲉ ⲁⲛ ⳿ⲛϫⲉ ⲡⲓⲗⲩⲙⲏⲛ ⲉⲑⲣ⳿ⲉⲛⲉⲣⲡⲁⲣⲁⲭⲓⲙⲁⲍⲓⲛ ⳿ⲁ ⲡⲟⲩϩⲟⲩ⳿ⲟ ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲥⲟϭⲛⲓ ⳿ⲉⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ϫⲉ ⲁⲣⲏⲟⲩ ⳿ⲛⲥⲉ⳿ϣϫⲟⲙϫⲉⲙ ⳿ⲛⲉⲣⲕⲁⲧⲁⲛⲧⲁⲛ ⳿ⲉⲫⲟⲓⲛⲓⲝ ⳿ⲉⲉⲣⲡⲁⲣⲁⲭ ⲓⲙⲁⲍⲓⲛ ϧⲉⲛ ⲟⲩⲗⲩⲙⲏⲛ ⳿ⲛⲧⲉ ϯ⳿ⲕⲣⲏⲧⲏⲉϥⲥⲟⲙⲥ ⳿ⲉⲡⲓⲥⲁ ⳿ⲛⲉⲙⲉⲛⲧ ⳿ⲉⲟⲩⲙⲁ ⳿ⲛⲭⲱⲣⲁ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ⲉϥⲛⲓϥⲓ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲑⲟⲩⲣⲏⲥ ⲛⲁⲩⲙⲉⲩⲓ ⲡⲉ ϫⲉ ⲥⲉⲛⲁ⳿ϣⲧⲁϩⲉ ⲡⲓϣⲟⲣⲡ ⳿ⲛⲑⲱϣ ⳿ⲉⲧⲁⲩⲁⲓϥ ⲁⲩϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲁⲥⲥⲱⲥ ⲁⲩⲭⲁ ϯ⳿ⲕⲣⲏⲧⲏ⳿ⲛⲥⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","⳿ⲙⲡⲉⲥⲱⲥⲕ ⲇⲉ ⲁϥⲛⲓϥⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲛ ⳿ⲛϫⲉ ⲟⲩⲑⲏⲟⲩ ⲉϥϭⲟⲥⲓ ⲫⲏ⳿ⲉϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟϥ ϫⲉ ⲉⲩⲣⲁⲕⲩⲗⲱⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","⳿ⲉⲧⲁϥϩⲱⲗⲉⲙ ⲇⲉ ⳿ⲙⲡⲓϫⲟⲓ ⳿ⲉⲧⲉ⳿ⲙⲡⲟⲩ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲡⲓⲑⲏⲟⲩ ⲁⲛϯⲧⲟⲧⲉⲛ ⲁⲛⲥⲱⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ⲉⲧⲁⲛⲫⲱⲧ ⲇⲉ ⳿ⲉⲟⲩⲛⲏⲥⲟⲥ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⳿ⲕⲗⲁⲩⲇⲁ ⲙⲟⲅⲓⲥ ⲁⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲉ⳿ⲁⲙⲁϩⲓ ⳿ⲛϯϧⲉⲗⲙⲉϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ⲑⲁⲓ ⳿ⲉⲧⲁⲩⲟⲗⲥ ⲛⲁⲩⲉⲣⲃⲟ⳿ⲏⲑⲓⲛ ⲉⲩⲙⲟⲩⲣ ⳿ⲙⲡⲓϫⲟⲓ ⲉⲩⲉⲣϩⲟϯ ⲇⲉ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲥⲉϩⲉⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯⲥⲓⲣⲧⲏⲥ ⲁⲛⲭⲱ ⳿ⲙⲡⲓ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲉⲡⲉⲥⲏⲧ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁⲛⲗⲱⲓⲗⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","⳿ⲉⲣⲉ ⲃⲟⲗ ⲇⲉ ⲫⲟⲛϩ ⳿ⲉⲣⲟⲛ ⳿ⲉⲙⲁϣⲱ ⲡⲉϥⲣⲁⲥϯ ⲇⲉ ⲛⲁⲩⲃⲟⲣⲃⲉⲣ ⳿ⲉⲃⲟⲗ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ⲟⲩⲟϩ ϧⲉⲛ ⳿ⲫⲙⲁϩ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁⲩϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲥⲁ ⲛⲓ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲛⲧⲉ ⲡⲓϫⲟⲓ ⲁⲩⲥⲁⲧⲟⲩ ⳿ⲉⲃⲟⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ⲉϥⲟⲩⲟⲛϩ ⲇⲉ ⲁⲛ ⳿ⲛϫⲉ ⳿ⲫⲣⲏ ⲛⲉⲙ ⲛⲓⲥⲓⲟⲩ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⳿ⲙⲫⲱⲛϩ ⲁⲛ ⲡⲉ ⳿ⲉⲛⲁϥϣⲟⲡ ⲗⲟⲓⲡⲟⲛ ⲛⲉ ⲁⲥϣⲉⲛⲁⲥ ⲡⲉ ⳿ⲛϫⲉ ⲧⲉⲛϩⲉⲗⲡⲓⲥ ⲧⲏⲣⲥ ⲉⲑⲣⲉⲛⲟⲩϫⲁⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","⳿ⲥϣⲟⲡ ⲇⲉ ⳿ⲛϫⲉ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲉⲧⲁⲑⲟⲩⲱⲙ ⲧⲟⲧⲉ ⲁϥ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϧⲉⲛ ⲧⲟⲩⲙⲏϯ ⲡⲉϫⲁϥ ϫⲉ ⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⲙⲉⲛ ⲡⲉ ⳿ⲱ ⲛⲓⲣⲱⲙⲓ ⳿ⲉⲁⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱⲓ ⳿ⲉ⳿ϣⲧⲉⲙϫⲱⲟⲩⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ⲕⲣⲏⲧⲏ⳿ⲛⲧⲉⲧⲉ⳿ⲛϫⲉⲙ ϩⲏⲟⲩ ⳿ⲙⲡⲁⲓϣⲱϣ ⲛⲉⲙ ⲡⲁⲓⲟⲥⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ⲟⲩⲟϩ ϯⲛⲟⲩ ⲟⲛ ϯϧⲱⲛϫ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲱⲟⲩ⳿ⲛϩⲏⲧ ⲟⲩⲯⲩⲭⲏ ⲅⲁⲣ ⳿ⲛⲟⲩⲱⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲥⲛⲁⲧⲁⲕⲟ ⲁⲛ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓϫⲟⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ⲁϥⲟϩⲓ ⲅⲁⲣ ⳿ⲉⲣⲁⲧϥ ⲛⲁϩⲣⲁⲓ ⳿ⲙⲡⲁⲓ⳿ⲉϫⲱⲣϩ ⳿ⲛϫⲉ ⲟⲩⲁⲅⲅⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲫϯ ⳿ⲉⲧⲉ ⳿ⲁⲛⲟⲕ ⲫⲱϥ ⲟⲩⲟϩ ϯϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣϩⲟϯ ⲡⲁⲩⲗⲉ ϩⲱϯ ⳿ⲛⲥⲉⲧⲁϩⲟⲕ ⳿ⲉⲣⲁⲧⲕ ⲛⲁϩⲣⲁϥ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⲟⲩⲟϩ ϩⲏⲡⲡⲉ ⲛⲏ⳿ⲉⲧⲉⲣϩⲱⲧ ⲛⲉⲙⲁⲕ ⲧⲏⲣⲟⲩ ⲁⲓⲧⲏⲓⲧⲟⲩ ⲛⲁⲕ ⳿ⲛ⳿ϩⲙⲟⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲛⲟϥ ⳿ⲛϩⲏⲧ ϯⲛⲁϩϯ ⲅⲁⲣ ⳿ⲉⲫϯ ϫⲉ ⲥⲉⲛⲁϣⲱⲡⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲉⲧⲁⲩⲥⲁϫⲓ ⲛⲉⲙⲏⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ϩⲱϯ ⲅⲁⲣ ⳿ⲛⲧⲉⲛ⳿ⲓ ⳿ⲉϫⲉⲛ ⲟⲩⲛⲏⲥⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ⲉⲧⲁ ⲓ̅ⲇ̅ ⲇⲉ ⳿ⲛ⳿ⲉϫⲱⲣϩ ϣⲱⲡⲓ ⲉⲛⲭⲏⲥⲁⲡⲓϩⲱⲓⲙⲓ ϧⲉⲛ ⲡⲓⲁⲛ⳿ⲇⲣⲓⲁⲥ ϧⲉⲛ ⳿ⲧⲫⲁϣⲓ ⲇⲉ ⳿ⲙⲡⲓ⳿ⲉϫⲱⲣϩ ⲛⲁⲩⲙⲉⲩⲓ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲛⲉϥ ϫⲉ ⲁⲩϧⲱⲛⲧ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲭⲱⲣⲁ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲓϯ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲛϯⲃⲟⲗⲓⲥ ⲁⲩϫⲉⲙ ⲕ̅ ⳿ⲛ⳿ϩϥⲟⲧ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲧⲁⲩⲉⲣ ⲟⲩⲕⲟⲩϫⲓ ⲇⲉ ⳿ⲛⲟⲩⲱϣ ⲁⲩⲥⲓϯ ⳿ⲛϯⲃⲟⲗⲓⲥ ⳿ⲉⲡⲉⲥⲏⲧ ⲁⲩϫⲉⲙ ⲓ̅ⲉ̅ ⳿ⲛ⳿ϩϥⲟⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","⳿ⲉⲛⲉⲣϩⲟϯ ⲇⲉ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲧⲉⲛϩⲉⲓ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϩⲁⲛⲙⲁ ⲉⲩⲛⲁϣⲧ ⲁⲩϩⲓ ⲇ̅ ⳿ⲛⲁⲩϫⲁⲗ ⲥⲁⲫⲁϩⲟⲩ ⳿ⲙⲡⲓϫⲟⲓ ⲛⲁⲩⲧⲱⲃϩ ⲉⲑⲣⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ⲉⲩⲕⲱϯ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲛⲉϥ ⳿ⲛⲥⲉⲫⲱⲧ ⳿ⲉⲃⲟⲗϩⲁ ⲡⲓϫⲟⲓ ⲁⲩⲭⲱ ⳿ⲛϯ⳿ⲥⲕⲁⲫⲏ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲓⲟⲙ ϧⲉⲛ ⲟⲩⲗⲱⲓϫⲓ ϩⲱⲥ ϫⲉ ⲉⲩⲛⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲛϩⲁⲛⲁⲩϫⲁⲗ ⳿ⲉⲃⲟⲗ ⲥⲁ⳿ⲧϩⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ⲡⲉϫⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲙⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲛⲉⲙ ⲛⲓⲙⲁⲧⲟⲓ ϫⲉ ⳿ⲉϣⲱⲡ ⳿ⲁⲣⲉ⳿ϣⲧⲉⲙ ⲛⲁⲓ ⲟϩⲓ ϩⲓ ⲡⲓϫⲟⲓ ⳿ⲙⲙⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲛⲟϩⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ⲧⲟⲧⲉ ⲛⲓⲙⲁⲧⲟⲓ ⲁⲩⲥⲱⲗⲡ ⳿ⲛⲛⲓⲛⲟϩ ⳿ⲛⲧⲉ ϯ⳿ⲥⲕⲁⲫⲏⲁⲩⲭⲁⲥ ⲉⲑⲣⲉⲥϩⲉⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ϣⲁⲧⲉ ⲡⲓ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⲛⲁϥⲑⲱⲧ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲧⲏⲣⲟⲩ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉϭⲓ ⳿ⲛⲟⲩ⳿ϧⲣⲉ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲓⲥ ⲓ̅ⲇ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⳿ⲁⲣⲉⲧⲉⲛϫⲟⲕⲟⲩ ⳿ⲉⲃⲟⲗ ⳿ⲉⲣⲉⲧⲉⲛⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲉⲧⲉⲛⲟⲩⲉⲙ ⳿ϩⲗⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ⲉⲑⲃⲉ ⲫⲁⲓ ϯⲧⲱⲃϩ ⳿ⲙⲙⲱⲧⲉⲛ ⲉⲑⲣ⳿ⲉⲧⲉⲧⲉⲛϭ ⲓ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϧⲣⲉ ⲫⲁⲓ ⲅⲁⲣ ⳿ϥϣⲟⲡ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲡⲉⲧⲉⲛⲟⲩϫⲁⲓ ⲟⲩϥⲱⲓ ⲅⲁⲣ ⳿ⲛⲧⲉ ⳿ⲧⲁⲫⲉ ⳿ⲛⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ϥⲛⲁⲧⲁⲕⲟ ⲁⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ⲛⲁⲓ ⲇⲉ ⳿ⲉⲧⲁϥϫⲟⲧⲟⲩ ⲁϥϭⲓ ⳿ⲛⲟⲩⲱⲓⲕ ⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉⲛ Ⲫϯ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥⲫⲁϣϥ ⲁϥⲉⲣϩⲏⲧⲥ ⳿ⲛⲟⲩⲱⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ⲉⲧⲁ ⲡⲟⲩϩⲏⲧ ⲇⲉ ⲟⲩⲛⲟϥ ⲧⲏⲣⲟⲩ ⳿ⲛⲑⲱⲟⲩ ϩⲱⲟⲩ ⲁⲩϭⲓ ⳿ⲛⲧⲟⲩ⳿ϧⲣⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ⲛⲓⲯⲩⲭⲏ ⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲉⲛⲁⲩϩⲓ ⲡⲓϫⲟⲓ ⲛⲁⲩⲉⲣ ⲥ̅ⲟ̅ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","⳿ⲉⲧⲁⲩⲥⲓ ⲇⲉ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ⳿ϧⲣⲉ ⲛⲁⲩ⳿ⲑⲣⲟ ⳿ⲙⲡⲓϫⲟⲓ ⳿ⲉⲁⲥⲓⲁⲓ ⲡⲉ ⲉⲩⲥⲓϯ ⳿ⲙⲡⲓⲥⲟⲩ⳿ⲟ ⳿ⲉ⳿ⲫⲓⲟⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ϩⲟⲧⲉ ⲇⲉ ⳿ⲉⲧⲁ ⲡⲓ⳿ⲉϩⲟⲟⲩ ϣⲱⲡⲓ ⳿ⲙⲡⲟⲩⲥⲟⲩⲉⲛ ⲡⲓⲕⲁϩⲓ ⲛⲁⲩϯ ⲇⲉ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⳿ⲛⲟⲩⲕⲟⲗⲡⲥ ⳿ⲉⲟⲩⲟⲛ ⲟⲩ⳿ⲭⲣⲟ ⳿ⲛϧⲏⲧϥ ⲛⲁⲩⲥⲟϭⲛⲓ ⲇⲉ ϫⲉ ⲁⲣⲏⲟⲩ ⲥⲉⲛⲁ⳿ϣⲛⲟϩⲉⲙ ⳿ⲙⲡⲓϫⲟⲓ ⳿ⲉⲙⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩϥⲓ ⳿ⲛⲛⲓⲁⲩϫⲁⲗ ⲛⲁⲩⲭⲱ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ⳿ⲫⲓⲟⲙ ⲁⲙⲁ ⲇⲉ ⲁⲩⲭⲁ ϫⲱⲟⲩ ⳿ⲛⲛⲓϩⲓⲏⲟⲩ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲥⲟⲥⲓ ⳿ⲙⲡⲓⲁⲣⲧⲉⲙⲱⲛ ⳿ⲙⲡⲓⲑⲏⲟⲩ ⲉⲑⲛⲓϥⲓ ⲁⲩⲙⲟⲛⲓ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","⳿ⲉⲧⲁⲩϩⲉⲓ ⲇⲉ ⳿ⲉⲟⲩⲙⲁ ⲉϥⲟⲓ ⳿ⲛⲑⲁⲗⲁⲥⲥⲁ ⳿ⲥⲛⲟⲩϯ ⲁⲩϩⲉⲣϣ ⲡⲓϫⲟⲓ ⳿ⲉⲙⲁⲩ ⲟⲩⲟϩ ϩⲓ⳿ⲧϩⲏ ⲙⲉⲛ ⳿ⲙⲙⲟϥ ⲁϥⲧⲁϫⲣⲟ ⲁϥⲟϩⲓ ⳿ⲛ⳿ϥⲕⲓⲙ ⲁⲛ ⲫⲁϩⲟⲩ ⲇⲉ ⳿ⲙⲙⲟϥ ⲁϥⲃⲱⲗ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉⲛ ⳿ⲡϭⲓ⳿ⲛϫⲟⲛⲥ ⳿ⲛⲧⲉ ⲛⲓϩⲱⲓⲙⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ⲁⲩ⳿⳿ⲓⲣⲓ ⲇⲉ ⳿ⲛⲟⲩⲥⲟϭⲛⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲁⲧⲟⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉϧⲱⲧⲉⲃ ⳿ⲛⲛⲏⲉⲧⲥⲟⲛϩ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲛⲏⲃⲓ ⳿ⲛⲧⲉϥⲫⲱⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ⲡⲓ⳿ⲉⲕⲁⲧⲟⲛⲧⲁⲣⲭⲟⲥ ⲇⲉ ⲉϥⲟⲩⲱϣ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲁϥϣⲁϣⲧⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲟⲩⲥⲟϭⲛⲓ ⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⲇⲉ ⳿ⲛⲛⲏ⳿ⲉⲧⲉ ⲟⲩⲟⲛ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲥⲉϥⲓⲧⲟⲩ ⳿ⲉ⳿ⲫⲓⲟⲙ ⳿ⲛⲥⲉⲛⲏⲃⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ .. ");
INSERT INTO copcnt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ⲟⲩⲟϩ ⳿ⲡⲕⲉⲥⲱϫⲡ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ϩⲓ ϩⲁⲛⲥⲁⲛⲓⲥ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲇⲉ ϩⲓ ϩⲁⲛⲕⲉⲉⲛⲭ ⲁⲓ ⳿ⲛⲧⲉ ⲡⲓϫⲟⲓ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁⲥϣⲱⲡⲓ ⲉⲑⲣⲉⲛⲛⲟϩⲉⲙ ⲧⲏⲣⲉⲛ ⳿ⲉⲡⲓ⳿ⲭⲣⲟ . ");
INSERT INTO copcnt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ⲟⲩⲟϩ ⲉⲧⲁⲛⲛⲟϩⲉⲙ ⲧⲟⲧⲉ ⲁⲛ⳿ⲉⲙⲓ ϫⲉ ϣⲁⲩⲙⲟⲩϯ ⳿ⲛϯⲛⲏⲥⲟⲥ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ϫⲉ ⲙⲉⲗⲓⲧⲓⲛⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ⲛⲓⲃⲁⲣⲃⲁⲣⲟⲥ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲁⲩ⳿⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲉⲧⲙⲁⲓⲣⲱⲙⲓ ⲛⲉⲙⲁⲛ ⳿ⲛⲟⲩⲕⲟⲩϫⲓ ⲁⲛ ⳿ⲉⲧⲁⲩϭⲉⲣⲉ ⲟⲩ⳿ⲭⲣⲱⲙ ⲅⲁⲣ ⲁⲩϣⲟⲡⲧⲉⲛ ⲧⲏⲣⲉⲛ ⳿ⲉⲣⲱⲟⲩ ⲉⲑⲃⲉ ⲡⲓⲙⲟⲩⲛϩⲱⲟⲩ ⳿ⲉⲧⲉ ⲛⲁϥϣⲟⲡ ⲛⲉⲙ ⲉⲑⲃⲉ ⲡⲓⲱϫⲉⲃ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ⲁϥⲕⲟⲧϥ ⲇⲉ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥϫⲓⲙⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲗⲉⲡϣ ⲟⲩⲟϩ ⳿ⲉⲧⲁϥϩⲓⲧⲟⲩ ⳿ⲉⲡⲓ ⳿ⲭⲣⲱⲙ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⲡⲓ⳿ϧⲙⲟⲙ ⲁⲥ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲟⲩⲁϫⲱ ⲁⲥϫⲉⲕϩ ⲧⲉϥϫⲓϫ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","⳿ⲉⲧⲁⲩⲛⲁⲩ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲃⲁⲣⲃⲁⲣⲟⲥ ⳿ⲉⲡⲓⲑⲏⲣⲓⲟⲛ ⲉϥⲁϣⲓ ⳿ⲛⲥⲁ ⲧⲉϥϫⲓϫ ⲛⲁⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ϫⲉ ⲡⲁⲛⲧⲱⲥ ⲡⲁⲓⲣⲱⲙⲓ ⲟⲩⲣⲉϥϧⲱⲧⲉⲃ ⲡⲉ ⲫⲁⲓ ⳿ⲉⲧⲉ ⲙⲉⲛⲉⲛⲥⲁ ⳿ⲉⲧⲁϥⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲓⲟⲙ ⳿ⲙⲡⲉ ⲡⲉϥϩⲁⲡ ⲭⲁϥ ⳿ⲉⲱⲛϧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","⳿ⲛⲑⲟϥ ⲙⲉⲛ ⲟⲩⲛ ⲁϥⲛⲉϩ ⲡⲓⲑⲏⲣⲓⲟⲛ ⳿ⲉⲡⲓ⳿ⲭⲣⲱⲙ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ϣⲱⲡⲓ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲛⲁⲩⲙⲉⲩⲓ ϫⲉ ⳿ϥⲛⲁⲫⲱϫⲓ ⲓⲉ ⳿ϥⲛⲁϩⲉⲓ ⲥⲁⲧⲟⲧϥ ⳿ⲛⲧⲉϥⲙⲟⲩ ⳿ⲉⲧⲁⲩⲱⲥⲕ ⲇⲉ ⲉⲩⲥⲟⲙⲥ ⳿ⲉⲣⲟϥ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲩⲛⲁⲩ ϫⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲛϩⲱⲃ ⲉϥϩⲱⲟⲩ ⲧⲁϩⲟϥ ⲁⲩⲕⲟⲧⲟⲩ ⲥⲁⲧⲟⲧⲟⲩ ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟϥ ϫⲉ ⲟⲩⲛⲟⲩϯ ⲡⲉ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","⳿ⲛ⳿ϩⲣⲏⲓ ⲇⲉ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲛⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲓⲟϩⲓ ϣⲟⲡ ⳿ⲛⲧⲉ ⲡⲓϩⲟⲩⲓⲧ ⳿ⲛⲧⲉ ϯⲛⲏⲥⲟⲥ ⳿ⲉⲡⲉϥⲣⲁⲛ ⲡⲉ ⲡⲟⲩⲡⲗⲓⲟⲥ ⲫⲁⲓ ⳿ⲉⲧⲁϥ ϭⲓⲧⲧⲉⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⲁϥϣⲟⲡⲧⲉⲛ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲟⲩⲙⲉⲓ ⳿ⲙⲙⲉⲧϣⲁⲡϣⲉⲙⲙⲟ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⳿ⲉⲧⲁ Ⲫ̇ⲓⲱⲧ ⳿ⲙⲡⲟⲩⲡⲗⲓⲟⲥ ϣⲱⲡⲓ ϧⲉⲛ ϩⲁⲛ⳿ϧⲙⲟⲙ ⲛⲉⲙ ϩⲁⲛϣⲁⲛⲙⲁϧⲧ ⲉϥ⳿ϣⲧⲏⲟⲩⲧ ϧⲁⲣⲱⲟⲩ ⲫⲁⲓ ⲇⲉ ⳿ⲁ ⲡⲁⲩⲗⲟⲥ ϣⲉ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲟϥ ⲁϥⲉⲣⲡⲣⲟⲥⲉⲩⲭⲉⲥⲑⲉ ⲁϥ ⲭⲁ ⲛⲉϥϫⲓϫ ϩⲓϫⲱϥ ⲁϥⲧⲁⲗϭⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ⲉⲧⲁ ⲫⲁⲓ ⲇⲉ ϣⲱⲡⲓ ⳿ⲡⲥⲱϫⲡ ⲉⲧϧⲉⲛ ϯⲛⲏⲥⲟⲥ ⳿ⲉⲧⲉ ⲟⲩⲟⲛ ϣⲱⲛⲓ ϣⲟⲡ ⳿ⲙⲙⲱⲟⲩ ⲛⲁⲩⲛⲏⲟⲩ ϣⲁⲣⲟϥ ⲟⲩⲟϩ ⲛⲁϥⲧⲁⲗϭⲟ ⳿ⲙⲙⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ⲛⲁⲓ ⲇⲉ ⲁⲩⲧⲁⲓⲟⲛ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛⲧⲁⲓⲟ ⲟⲩⲟϩ ⲉⲩⲛⲁ⳿ⲉⲛⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲩⲥⲉⲃⲧⲱⲧⲉⲛ ⳿ⲙⲡⲉⲧ⳿ⲉⲛⲉⲣ⳿ⲭⲣⲓ⳿ⲁ ⳿ⲙⲙⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⲇⲉ ⳿ⲛⲁⲃⲟⲧ ⲁⲛ⳿ⲓ ϩⲓ ⲟⲩϫⲟⲓ ⳿ⲛⲧⲉ ⲣⲁⲕⲟϯ ⳿ⲉⲣⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏⲓⲛⲓ ϩⲓⲱⲧϥ ⳿ⲛⲧⲉ ϩⲁⲛⲇⲓⲟⲥⲕⲟⲣⲟⲥ ⳿ⲉⲁϥⲉⲣⲡⲁⲣⲁ ⲭⲓⲙⲁⲍⲓⲛ ϧⲉⲛ ϯⲛⲏⲥⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ⲟⲩⲟϩ ⲁⲛⲙⲟⲛⲓ ⳿ⲉⲥⲓⲣⲁⲕⲟⲩⲥⲁⲥ ⲁⲛϣⲱⲡⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ⲟⲩⲟϩ ⲉⲧⲁⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲁⲩ ⲁⲛⲉⲣⲕⲁⲧⲁⲛⲧⲁⲛ ⳿ⲉⲣⲏⲅⲓⲟⲛ ⲟⲩⲟϩ ⲙⲉⲛⲉⲛⲥⲁ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⲁϥ⳿ⲁⲙⲁϩⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϫⲱⲛ ⳿ⲛϫⲉ ⲟⲩⲑⲟⲩⲣⲏⲥ ⲁⲛ⳿ⲓ ⳿ⲙⲡⲉⲛⲃ̅ ⳿ⲉⲡⲟⲛⲧⲓⲟⲗⲟⲩⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ⲟⲩⲟϩ ⲉⲧⲁⲛϫⲓⲙⲓ ⳿ⲛⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲙⲙⲁⲩ ⲁⲩⲑⲉⲧ ⲡⲉⲛϩⲏⲧ ⲉⲑⲣⲉⲛϣⲱⲡⲓ ϧⲁⲧⲟⲧⲟⲩ ⳿ⲛⲍ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁⲛ⳿ⲓ ⳿ⲉⲣⲱⲙⲏ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","⳿ⲉⲧⲁⲩⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲏⲧⲉⲛ ⲁⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲁⲛ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲁⲡⲡⲓⲟⲫⲟⲣⲟⲩ ⳿ⲛⲅ̅ ⳿ⲛⲧⲁⲃⲉⲣⲛⲱⲛ ⳿ⲉⲧⲁϥⲛⲁⲩ ⲇⲉ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ⲁϥϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉⲛ Ⲫϯ ⲟⲩⲟϩ ⲁϥϭⲓ ⳿ⲛⲟⲩⲙⲉⲧϫⲁⲣϩⲏⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ϩⲟⲧⲉ ⲇⲉ ⲉⲧⲁⲛϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲙⲏⲁϥⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲡⲁⲩⲗⲟⲥ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲛⲉⲙ ⲡⲓⲙⲁⲧⲟⲓ ⲉⲧ⳿ⲁⲣⲉϩ ⳿ⲉⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ⲁⲥϣⲱⲡⲓ ⲇⲉ ⲙⲉⲛⲉⲛⲥⲁ ⲅ̅ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲁϥⲙⲟⲩϯ ⳿ⲉⲛⲓϩⲟⲩⲁϯ ⳿ⲛⲧⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲉⲧϣⲟⲡ ⳿ⲙⲙⲁⲩ ⳿ⲉⲧⲁⲩ⳿ⲓ ⲇⲉ ⳿ⲉⲙⲁⲩ ⲛⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⳿ⲁⲛⲟⲕ ⲛⲓⲣⲱⲙⲓ ⲛⲉⲛ⳿ⲥⲛⲏⲟⲩ ⳿ⲙⲡⲓⲉⲣ⳿ϩⲗⲓ ⲉⲓϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁϥ ⳿ⲙⲡⲓⲗⲁⲟⲥ ⲓⲉ ⲛⲓⲥⲩⲛⲏⲑⲓⲁ ⳿ⲛⲧⲉ ⲛⲉⲛⲓⲟϯ ⲁⲩⲥⲟⲛϩⲧ ⳿ⲉⲃⲟⲗϧⲉⲛ Ⲓⲗ̅ⲏ̅ⲙ̅ ⲁⲩⲧⲏⲓⲧ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿⳿ⲉⲛⲉⲛϫⲓϫ ⳿ⲛⲛⲓⲣⲱⲙⲉⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ⲛⲁⲓ ⳿ⲉⲧⲁⲩϧⲉⲧϧⲱⲧ ⲛⲁⲩⲟⲩⲱϣ ⳿ⲉⲭⲁⲧ ⳿ⲉⲃⲟⲗ ⲡⲉ ϫⲉ ⳿ⲙⲡⲟⲩϫⲉⲙ ⳿ϩⲗⲓ ⳿ⲛ⳿ⲉⲧⲓⲁ ⳿ⲛⲧⲉ ⳿ⲫⲙⲟⲩ ⲉϥϣⲟⲡ ⳿ⲛϧⲏⲧ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ⲉⲩⲉⲣⲁⲛⲧⲓⲗⲉⲅⲓⲛ ⲇⲉ ⳿ⲛϫⲉ ⲛⲓⲒⲟⲩⲇⲁⲓ ⲁⲥⲉⲣ⳿ⲁⲛⲁⲅⲕⲏ ⳿ⲉⲣⲟⲓ ⳿ⲉⲉⲣⲉⲡⲓⲕⲁⲗⲓⲥⲑⲉ ⳿ⲙ⳿ⲡⲟⲩⲣⲟ ⳿ⲙ⳿ⲫⲣⲏϯ ⲁⲛ ϫⲉ ⲟⲩⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲕⲁⲧⲏⲅⲟⲣⲓⲁ ⳿ⲉ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲁ⳿ϣⲗⲱⲗ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ⲉⲑⲃⲉ ⲧⲁⲓⲗⲱⲓϫⲓ ⲟⲩⲛ ⲛⲁⲓⲧⲱⲃϩ ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⲉⲑⲃⲉ ⳿ⲧϩⲉⲗⲡⲓⲥ ⲅⲁⲣ ⳿ⲙⲠⲓ̅ⲥ̅ⲗ̅ ϯⲥⲟⲛϩ ⳿ⲛⲧⲁⲓϩⲁⲗⲩⲥⲓⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","⳿ⲛⲑⲱⲟⲩ ⲇⲉ ⲡⲉϫⲱⲟⲩ ⲛⲁϥ ϫⲉ ⳿ⲁⲛⲟⲛ ⲟⲩⲇⲉ ⳿ⲙⲡⲉ ⳿ⲥϧⲁⲓ ⳿ⲓ ⲛⲁⲛ ⳿ⲉⲃⲟⲗϧⲉⲛ ϯ Ⲓⲟⲩⲇⲉ⳿ⲁ ⲟⲩⲇⲉ ⳿ⲙⲡⲉϥ⳿ⲓ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ⳿ⲉⲃⲟⲗϧⲉⲛ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲧⲉϥⲧⲁⲙⲟⲛ ⲓⲉ ⳿ⲛⲧⲉϥϫⲉ ⲟⲩⲥⲁϫⲓ ⲉϥϩⲱⲟⲩ ϧⲁⲣⲟⲕ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ⲧ⳿ⲉⲛⲉⲣⲁⲝⲓⲟⲓⲛ ⲇⲉ ⳿ⲉⲥⲱⲧⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲕ ⳿ⲛⲛⲏ⳿ⲉⲧⲉⲕⲙⲉⲩⲓ ⳿ⲉⲣⲱⲟⲩ ⲉⲑⲃⲉ ⲧⲁⲓϩⲉⲣⲉⲥⲓⲥ ⲅⲁⲣ ⲡⲓϩⲱⲃ ⲟⲩⲟⲛϩ ⳿ⲉⲣⲟⲛ ϫⲉ ⲥⲉⲉⲣⲁⲛⲧⲓⲗⲉⲅⲓⲛ ⲉⲑⲃⲏⲧⲥ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ⲁⲩϯⲛⲉⲓ ⲇⲉ ⲛⲁϥ ⳿ⲛⲟⲩ⳿ⲉϩⲟⲟⲩ ⲁⲩ⳿ⲓ ϣⲁⲣⲟϥ ⳿ⲉϯⲉⲝⲉⲛⲓⲁ ⲉⲩⲉⲣⲟⲩⲙⲏϣ ⲟⲩⲟϩ ⲁϥⲥⲁϫⲓ ϧⲁⲧⲟⲧⲟⲩ ⲉϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲱⲟⲩ ⲉⲑⲃⲉ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲉϥⲑⲱⲧ ⳿ⲙⲡⲟⲩϩⲏⲧ ⲉⲑⲃⲉ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲘⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ϣⲁ ⲣⲟⲩϩⲓ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ⲟⲩⲟϩ ϩⲁⲛⲟⲩⲟⲛ ⲙⲉⲛ ⲛⲁⲣⲉ ⲡⲟⲩϩⲏⲧ ⲑⲏⲧ ⲛⲉⲙ ⲛⲏ⳿ⲉⲛⲁϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ϩⲁⲛⲕⲉ ⲭⲱⲟⲩⲛⲓ ⲇⲉ ⲛⲁⲩⲟⲓ ⳿ⲛⲁⲧⲛⲁϩϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ⲉⲩⲟⲓ ⲇⲉ ⳿ⲛⲁⲧϯⲙⲁϯ ⲛⲉⲙ ⲛⲟⲩ⳿ⲉⲣⲏⲟⲩ ⲁϥⲭⲁⲩ ⳿ⲉⲃⲟⲗ ⲉϥϫⲱ ⳿ⲛⲟⲩⲥⲁϫⲓ ⳿ⲛⲟⲩⲱⲧ ⲛⲱⲟⲩ ⳿ⲛϫⲉ ⲡⲁⲩⲗⲟⲥ ϫⲉ ⲕⲁⲗⲱⲥ ⳿ⲁ ⲡⲠⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲥⲁϫⲓ ⳿ⲉⲃⲟⲗϩⲓⲧⲟⲧϥ ⳿ⲛⲏⲥⲁ⳿ⲏⲁⲥ ⲡⲓ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲓⲟϯ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲟϣⲓ ϣⲁ ⲡⲁⲡⲓⲗⲁⲟⲥ ⲁϫⲟⲥ ⲛⲱⲟⲩ ϫⲉ ϧⲉⲛ ⲟⲩ⳿ⲥⲙⲏ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ⲛⲛⲉⲧⲉⲛⲕⲁϯ ϧⲉⲛ ⲟⲩⲛⲁⲩ ⳿ⲉⲣⲉⲧⲉⲛⲛⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲛⲉⲧⲉⲛⲛⲁⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ⲁϥⲟⲩⲙⲟⲧ ⲅⲁⲣ ⳿ⲛϫⲉ ⳿ⲡϩⲏⲧ ⳿ⲙⲡⲁⲡⲓⲗⲁⲟⲥ ⲟⲩⲟϩ ⲁⲩ⳿ϩⲣⲱϣ ⳿ⲉ⳿ⲡⲥⲱⲧⲉⲙ ϧⲉⲛ ⲛⲟⲩⲙⲁϣϫ ⲟⲩⲟϩ ⲁⲩⲙⲁϣⲑⲁⲙ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲙⲏ ⲡⲱⲥ ⳿ⲛⲥⲉⲛⲁⲩ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲥⲱⲧⲉⲙ ϧⲉⲛ ⲛⲟⲩⲙⲁϣϫ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲕⲁϯ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⳿ⲛⲥⲉⲕⲟⲧⲟⲩ ⳿ⲛⲧⲁⲧⲟⲩϫⲱⲟⲩ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ⲙⲁⲣⲉ ⲡⲓϩⲱⲃ ⲟⲩⲟⲛϩ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉ ⳿ⲁ Ⲫϯ ⲧⲁⲟⲩ⳿ⲟ ⳿ⲙⲡⲉϥⲥⲱⲧⲏⲣ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⳿ⲛⲑⲱⲟⲩ ⲟⲛ ⲉⲑⲛⲁⲥⲱⲧⲉⲙ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ⲁϥϣⲱⲡⲓ ⲇⲉ ⳿ⲛⲣⲟⲙⲡⲓ ⳿ⲥⲛⲟⲩϯ ⲧⲏⲣⲟⲩ ϧⲉⲛ ⲡⲓⲙⲁ ⳿ⲉⲧⲁϥϭⲓⲧϥ ⳿ⲉⲡⲉϥ⳿ϣϭⲟⲣ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ⲟⲩⲟϩ ⲛⲁϥϣⲟⲡ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲏⲟⲩ ⳿ⲉϧⲟⲩⲛ ϣⲁⲣⲟϥ .. ");
INSERT INTO copcnt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ⲉϥϩⲓⲱⲓϣ ⳿ⲛϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ Ⲫϯ ⲟⲩⲟϩ ⲉϥϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲃⲉ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ϣⲱϣⲧ ⳿ⲙⲙⲟϥ ⳿ⲡⲣⲁⲝⲓⲥ ⲧⲟⲛ ⲁⲅⲓⲟⲛ ⲁⲡⲟⲥⲧⲟⲗⲟⲛ ⲉⲛ ⲓⲣⲏⲛⲏⲧⲱ ⲕ̅ⲱ̅ ⳿ⲁⲙⲏⲛⲀ ϯⲁⲡⲟⲅⲁⲗⲩⲙⲯⲓⲥ ⲧⲟⲩ ⲁⲅⲓⲟⲩ ⲓⲱⲁⲛⲛⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ⲡⲁⲩⲗⲟⲥ ⳿ⲫⲃⲱⲕ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲉⲧⲑⲁϩⲉⲙ ⲫⲏⲉⲧⲁⲩⲑⲁϣϥ ⳿ⲉⲡⲓϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ⲫⲏⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲱϣ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲉϥⲡⲣⲟⲫⲏⲧⲏⲥ ϧⲉⲛ ⲛⲓⲅⲣⲁⲫⲏⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ⲉⲑⲃⲉ ⲡⲉϥϣⲏⲣⲓ ⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡ⳿ϫⲣⲟϫ ⳿ⲛⲇⲁⲩⲓⲇ ⲕⲁⲧⲁ ⲥⲁⲣⲝ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","⳿ⲡϣⲏⲣⲓ ⳿ⲙⲫϯ ⲉⲧⲑⲏϣ ϧⲉⲛ ⲟⲩϫⲟⲙ ⲕⲁⲧⲁ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲧⲱⲛϥ ⳿ⲛⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ⲫⲏⲉⲧⲁⲛϭⲓ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲛⲉⲙ ⲟⲩⲙⲉⲧⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ⲛⲏⲉⲧⲉⲧⲉⲛ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ϩⲱⲧⲉⲛ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲣⲱⲙⲏ ⲛⲓⲙⲉⲛⲣⲁϯ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲑⲁϩⲉⲙ ⲉⲑⲟⲩⲁⲃ ⳿ⲡ⳿ϩⲙⲟⲧ ⲛⲱⲧⲉⲛ ⲛⲉⲙ ⳿ⲧϩⲓⲣⲏⲛⲏ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲡⲉⲛⲓⲱⲧ ⲛⲉⲙ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","⳿ⲛϣⲟⲣⲡ ⲙⲉⲛ ϯϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲡⲁⲛⲟⲩϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲧⲏⲣⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϩϯ ⲥⲉϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ⲡⲁⲙⲉⲑⲣⲉ ⲅⲁⲣ ⲡⲉ ⲫϯ ⲫⲏ ⳿ⲉϯϣⲉⲙϣⲓ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲁⲡ͞ⲛⲁ̅ ϧⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ⲡⲉϥϣⲏⲣⲓ ϩⲱⲥ ⳿ⲛϯⲭⲱ ⳿ⲛⲧⲟⲧ ⲁⲛ ⲉⲓ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲉⲧⲉⲛⲙⲉⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲛⲁⲡⲣⲟⲥⲉⲩⲭⲏ ⲉⲓⲧⲱⲃϩ ϫⲉ ⲁⲣⲏⲟⲩ ⳿ⲛⲧⲉ ⲡⲁⲙⲱⲓⲧ ⲥⲟⲃϯ ϧⲉⲛ ⲡⲓⲟⲩⲱϣ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ϯⲟⲩⲱϣ ⲅⲁⲣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲁϯ ⲛⲱⲧⲉⲛ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲙⲡ͞ⲛⲁ̅ⲧⲓⲕⲟⲛ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲁϫⲣⲉ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲉⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲁϫⲣⲟ ⳿ⲛϩⲏⲧ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲁϩϯ ⲫⲏⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧⲉⲛ ⲛⲉⲙ ⲛⲉⲛⲉⲣⲏⲟⲩ ⲫⲱⲧⲉⲛ ⲛⲉⲙ ⲫⲱⲓ ϩⲱ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⲁⲛ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧ⳿ⲉⲙⲓ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⲓⲥ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ϯ ⲥⲟⲃϯ ⳿ⲙⲙⲟⲓ ⳿ⲉ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ ⲟⲩⲟϩ ⲁⲩⲧⲁϩⲛⲟ ⳿ⲙⲙⲟⲓ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲁϭⲓ ⳿ⲛⲟⲩⲟⲩⲧⲁϩ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϩⲱⲧⲉⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡⲥⲱϫⲡ ⳿ⲛⲛⲓⲕⲉⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲛⲉⲙ ⲛⲓⲃⲁⲣⲃⲁⲣⲟⲥ ⲛⲓⲥⲁⲃⲉⲩ ⲛⲉⲙ ⲛⲓⲁⲧϩⲏⲧ ⲟⲩⲟⲛ ⳿ⲉⲣⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ⲡⲁⲓⲣⲏϯ ⲡⲉ ⲡⲁⲣⲱⲟⲩⲧϥ ⲉⲧϣⲟⲡ ⳿ⲙⲙⲟⲓ ⳿ⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲛⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧϣⲟⲡ ϧⲉⲛ ⲣⲱⲙⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ϯϣⲓⲡⲓ ⲅⲁⲣ ⲁⲛ ϧⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲟⲩϫⲟⲙ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉ ⲉⲩⲛⲟϩⲉⲙ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⲡⲓⲓⲟⲩⲇⲁⲓ ⳿ⲛϣⲟⲣⲡ ⲛⲉⲙ ⲡⲓⲟⲩⲉⲓⲛⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ⲟⲩⲙⲉⲑⲙⲏⲓ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉⲑⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲛⲁϩϯ ⲉⲩⲛⲁϩϯ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲓ⳿ⲑⲙⲏ ⲓ ⳿ϥⲛⲁⲱⲛϧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ⲡⲓϫⲱⲛⲧ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⳿ϥⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲧⲫⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲙⲉⲧⲁⲥⲉⲃⲏⲥ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⳿ⲑⲙⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲏⲉⲧ⳿ⲁⲙⲟⲛⲓ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ϧⲉⲛ ϯⲙⲉⲧⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ϫⲉ ⲡⲓ⳿ⲉⲙⲓ ⳿ⲛⲧⲉ ⲫϯ ⳿ϥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲫϯ ⲅⲁⲣ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ⲛⲓⲁⲑⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲧⲁϥ ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲥⲱⲛⲧ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲉϥⲑⲁⲙⲓⲟ ⲉⲩⲕⲁϯ ⳿ⲉⲣⲱⲟⲩ ⲥⲉⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲧⲉ ⲧⲉϥϫⲟⲙ ⳿ⲛ⳿ⲉⲛⲉϩ ⲧⲉ ⲛⲉⲙ ⲧⲉϥⲙⲉⲑⲛⲟⲩϯ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲟⲩϣⲱⲡⲓ ⳿ⲛⲁⲧⲗⲱⲓϫⲓ ⳿ⲛⲁⲧⲉⲣⲟⲩⲱ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ϫⲉ ⲉⲧⲁⲩⲥⲟⲩⲉⲛ ⲫϯ ⳿ⲙⲡⲟⲩϯⲱⲟⲩ ⲛⲁϥ ϩⲱⲥ ⲛⲟⲩϯ ⲟⲩⲇⲉ ⳿ⲙⲡⲟⲩϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲟⲧϥ ⲁⲗⲗⲁ ⲁⲩⲉⲣⲉⲫⲗⲏⲟⲩ ϧⲉⲛ ⲛⲟⲩⲙⲟⲕⲙⲉⲕ ⲟⲩⲟϩ ⲁϥⲉⲣⲭⲁⲕⲓ ⳿ⲛϫⲉ ⲡⲟⲩⲁⲧⲕⲁϯ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ⲉⲩϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ϩⲁⲛⲥⲁⲃⲉⲩ ⲛⲉ ⲁⲩⲉⲣⲥⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ⲟⲩⲟϩ ⲁⲩϣⲉⲃⲓⲉ ⲡⲓⲱⲟⲩ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲉ ⳿ⲙⲡⲉϥⲧⲁⲕⲟ ϧⲉⲛ ⲟⲩ⳿ⲓⲛⲓ ⳿ⲛⲧⲉ ⲟⲩϩⲓⲕⲱⲛ ⳿ⲛⲣⲱⲙⲓ ⳿ⲉϣⲁϥⲧⲁⲕⲟ ⲛⲉⲙ ϩⲁⲛϩⲁⲗⲁϯ ⲛⲉⲙ ϩⲁⲛⲧⲉⲃⲛⲱⲟⲩⲓ ⲛⲉⲙ ϩⲁⲛϭⲁⲧϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲛϫⲉ ⲫϯ ⳿ⲉ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲓ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲡⲟⲩϩⲏⲧ ⳿ⲉ⳿ⲡϭⲱϧⲉⲙ ⳿ⲉ⳿ⲡϫⲓⲛ⳿ⲑⲣⲟⲩϣⲱϣ ⳿ⲛϫⲉ ⲛⲟⲩⲥⲱⲙⲁ ⳿ⲛ⳿ϧⲣⲏ ⲓ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ⲛⲏⲉⲧⲁⲩϣⲓⲃϯ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ϧⲉⲛ ϯⲙⲉⲑⲛⲟⲩϫ ⲟⲩⲟϩ ⲁⲩⲟⲩⲱϣⲧ ⲟⲩⲟϩ ⲁⲩϣⲉⲙϣⲓ ⳿ⲙⲡⲓⲥⲱⲛⲧ ⲡⲁⲣⲁ ⲫⲏⲉⲧⲁϥⲥⲱⲛⲧ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ⲫⲏⲉⲧ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ϣⲁ ⲛⲓⲉⲛⲉϩ ⲁⲙⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲛϫⲉ ⲫϯ ⳿ⲉ⳿ϧⲣⲏ ⲓ ⳿ⲉϩⲁⲛⲡⲁⲑⲟⲥ ⳿ⲛϣⲱϣ ⲛⲟⲩϩⲓⲟⲙⲓ ⲅⲁⲣ ⲁⲩϣⲉⲃⲓ⳿ⲉ ⲧⲟⲩⲫⲩⲥⲓⲕⲏ ⳿ⲛⲭⲣⲏⲥⲓⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲉⲩⲡⲁⲣⲁ ⲫⲩⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲛⲓⲕⲉϩⲱⲟⲩⲧ ⲁⲩⲭⲱ ⳿ⲛⲥⲱⲟⲩ ⳿ⲛϯⲫⲩⲥⲓⲕⲏ ⳿ⲛⲭⲣⲏⲥⲓⲥ ⳿ⲛⲧⲉ ϯ⳿ⲥϩⲓⲙⲓ ⲁⲩⲣⲱⲕϩ ϧⲉⲛ ⲡⲟⲩⲟⲩⲱϣ ⳿ⲉⲛⲟⲩⲉⲣⲏⲟⲩ ϩⲁⲛϩⲱⲟⲩⲧ ϧⲉⲛ ϩⲁⲛϩⲱⲟⲩⲧ ⲉⲩⲉⲣϩⲱⲃ ⳿ⲉ⳿ⲡϣⲓⲡⲓ ⲉⲩ⳿ⲉϭⲓ ⳿ⲉ⳿ⲡϣⲉⲃⲓⲉ ⲃⲉⲭⲉ ⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲉ ⲧⲟⲩⲡⲗⲁⲛⲏ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲉ ⳿ⲙⲡⲟⲩⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲉⲭⲁ ⲫϯ ⳿ⲛⲧⲟⲧⲟⲩ ϧⲉⲛ ⲟⲩ⳿ⲉⲙⲓ ⲁϥⲧⲏⲓⲧⲟⲩ ⳿ⲛϫⲉ ⲫϯ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉⲟⲩϩⲏⲧ ⳿ⲛⲁⲇⲟⲕⲓⲙⲟⲥ ⲉⲑⲣⲟⲩ⳿ⲓⲣⲓ ⳿ⲛⲛⲏⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲁⲓⲧⲟⲩ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ⲉⲩⲙⲉϩ ⳿ⲛ⳿ⲁⲇⲓⲕⲓⲁ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲕⲁⲕⲓⲁ ⲛⲉⲙ ⲡⲟⲛⲏⲣⲓ⳿ⲁ ⲛⲉⲙ ⲙⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ⲉⲩⲙⲉϩ ⳿ⲛⲫⲑⲟⲛⲟⲥ ϩⲓ ϧⲱⲧⲉⲃ ⲛⲉⲙ ⳿ϣϭⲛⲏⲛ ⲛⲉⲙ ⳿ⲭ ⲣⲟϥ ⲛⲉⲙ ⲙⲉⲩⲓ ⲉϥϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ⲉⲩⲟⲓ ⳿ⲛⲣⲉϥⲭⲁⲥⲕⲉⲥ ⳿ⲛⲣⲉϥⲉⲣⲕⲁⲧⲁⲗⲁⲗⲓⲛ ⳿ⲙⲙⲁⲥⲧⲉ ⲛⲟⲩϯ ⳿ⲛⲣⲉϥϯϣⲱϣ ⳿ⲛϭⲁⲥⲓϩⲏⲧ ⳿ⲛⲣⲉϥϩⲓ⳿ⲡϩⲟ ⳿ⲛⲣⲉϥϫⲓⲙⲓ ⳿ⲛⲛⲓⲡⲉⲧϩⲱⲟⲩ ⳿ⲛⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲛⲟⲩⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","⳿ⲛⲁⲧⲕⲁϯ ⳿ⲛⲁⲧϯⲙⲁϯ ⳿ⲛⲁⲧϣⲉⲛϩⲏⲧ ⳿ⲛⲁⲧⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ⲛⲏⲉⲧⲥⲱⲟⲩⲛ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ϫⲉ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲙ⳿ⲫⲙⲟⲩ ⲟⲩ ⲙⲟⲛⲟⲛ ϫⲉ ⲥⲉ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲁⲗⲗⲁ ⲥⲉϯⲙⲁϯ ⲟⲛ ⲛⲉⲙ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲭⲛⲁ⳿ϣⲉⲣⲟⲩⲱ ⲁⲛ ⲱ ⳿ⲫⲣⲱⲙⲓ ϧⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϯϩⲁⲡ ϧⲉⲛ ⲡⲓϩⲁⲡ ⲅⲁⲣ ⲉⲧⲉⲕϯ ⳿ⲙⲙⲟϥ ⳿ⲉⲡⲉⲕ⳿ϣⲫⲏⲣ ⲁⲕϩⲓⲟⲩⲓ ⳿ⲙⲙⲟⲕ ⳿ⲉ⳿ⲡϩⲁⲡ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲛⲁⲓ ⲅⲁⲣ ϩⲱⲕ ⲟⲛ ⲉⲧⲉⲕ⳿⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲁ ⲫⲏⲉⲧϯϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ⲧⲉⲛ⳿ⲉⲙⲓ ⲅⲁⲣ ϫⲉ ⲡⲓϩⲁⲡ ⳿ⲛⲧⲉ ⲫϯ ⲁϥϣⲟⲡ ⲕⲁⲧⲁ ⲟⲩⲙⲉⲑⲙⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","⳿ⲭⲙⲉⲩⲓ ⲇⲉ ⳿ⲛⲑⲟⲕ ⳿ⲉⲫⲁⲓ ⲱ ⳿ⲫⲣⲱⲙⲓ ⲫⲏⲉⲧϯϩⲁⲡ ⳿ⲉⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲟⲩⲟϩ ⳿ⲭⲣⲁ ⳿ⲙⲙⲱⲟⲩ ϩⲱⲕ ⲟⲛ ϫⲉ ⲁⲛ ⳿ⲭⲛⲁ⳿ϣⲫⲱⲧ ⳿ⲛⲑⲟⲕ ⳿ⲛⲧⲉⲛ ⲡⲓϩⲁⲡ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ϣⲁⲛ ⳿ⲕⲉⲣⲕⲁⲧⲁ⳿ⲫⲣⲟⲛⲓⲛ ⳿ⲛϯⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲉⲧⲭ͞ⲣⲥ̅ ⲛⲉⲙ ⲧⲉϥⲙⲉⲧⲣⲉϥⲉⲣⲁⲛⲉⲭⲉⲥⲑⲉ ⲛⲉⲙ ⲧⲉϥⲙⲉⲧⲣⲉϥⲱⲟⲩ ⳿ⲛϩⲏⲧ ⳿ⲛ⳿ⲕ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ϯⲙⲉⲧⲭ͞ⲣⲥ̅ ⳿ⲛⲧⲉ ⲫϯ ⲥⲓⲛⲓ ⳿ⲙⲙⲟⲕ ⲉⲩⲙⲉⲧⲁⲛⲟⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ⲕⲁⲧⲁ ⲇⲉ ⲧⲉⲕⲙⲉⲧⲛⲁϣⲧϩⲏⲧ ⲛⲉⲙ ⲡⲉⲕϩⲏⲧ ⳿ⲛⲁⲧⲟⲩⲉⲙ⳿ϩⲑⲏϥ ⳿ⲕϩⲓ ϫⲱⲛⲧ ⲛⲁⲕ ⳿ⲉϧⲟⲩⲛ ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⳿ⲡϫⲱⲛⲧ ⲛⲉⲙ ⲡⲓϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲡⲓϩⲁⲡ ⳿ⲙⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ⲫⲏⲉⲑⲛⲁϯ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲕⲁⲧⲁ ⲛⲉϥ⳿ϩⲃⲏⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ⲛⲏ ⲙⲉⲛ ⲉⲧⲁⲩ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲟⲧⲟⲩ ϧⲉⲛ ⲟⲩϩⲱⲃ ⲉⲛⲁⲛⲉϥ ⲟⲩⲱⲟⲩ ⲛⲉⲙ ⲟⲩⲧⲁⲓⲟ ⲛⲉⲙ ⲟⲩⲙⲉⲧⲁⲧⲧⲁⲕⲟ ⳿ⲛⲛⲏⲉⲧⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲱⲛϧ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ⲛⲏ ⲇⲉ ⲉⲧⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩ⳿ϣϭⲛⲏⲛ ⲛⲉ ⲟⲩⲟϩ ⳿ⲛⲥⲉϯⲙⲁϯ ⲁⲛ ⲛⲉⲙ ⳿ⲑⲙⲏⲓ ⲉⲩⲑⲏⲧ ⲇⲉ ⳿ⲛϩⲏⲧ ⲛⲉⲙ ϯⲙⲉⲧϭⲓ ⳿ⲛϫⲟⲛⲥ ⲟⲩϫⲱⲛⲧ ⲛⲉⲙ ⲟⲩ⳿ⲙⲃⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ⲟⲩϩⲟϫϩⲉϫ ⲛⲉⲙ ⲟⲩ⳿ⲙⲕⲁϩ ⳿ⲉϫⲉⲛ ⲯⲩⲭⲏ ⲛⲓⲃⲉⲛ ⳿ⲛⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲡⲓⲓⲟⲩⲇⲁⲓ ⳿ⲛϣⲟⲣⲡ ⲛⲉⲙ ⲡⲓⲟⲩⲉⲓⲛⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ⲟⲩⲱⲟⲩ ⲇⲉ ⲛⲉⲙ ⲟⲩⲧⲁⲓⲟ ⲛⲉⲙ ⲟⲩϩⲓⲣⲏⲛⲏ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲣϩⲱⲃ ⳿ⲉⲡⲓⲁⲅⲁⲑⲟⲛ ⲡⲓⲓⲟⲩⲇⲁⲓ ⳿ⲛϣⲟⲣⲡ ⲛⲉⲙ ⲡⲓⲟⲩⲉⲓⲛⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","⳿ⲙⲙⲟⲛ ⲙⲉⲧⲣⲉϥϭⲓϩⲟ ϧⲁⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ⲛⲏ ⲅⲁⲣ ⲉⲧⲁⲩⲉⲣⲛⲟⲃⲓ ⲁⲛⲟⲙⲟⲥ ⲁⲛⲟⲙⲟⲥ ⲟⲛ ⲥⲉⲛⲁⲧⲁⲕⲱⲟⲩ ⲟⲩⲟϩ ⲛⲏⲉⲧⲁⲩⲉⲣⲛⲟⲃⲓ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲥⲉⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ⲟⲩ ⲅⲁⲣ ⲛⲓⲣⲉϥⲥⲱⲧⲉⲙ ⳿ⲉⲡⲓⲛⲟⲙⲟⲥ ⲁⲛ ⲛⲉ ⲛⲓ⳿ⲑⲙⲏⲓ ϧⲁⲧⲉⲛ ⲫϯ ⲁⲗⲗⲁ ⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲉⲧⲟⲩⲛⲁ⳿ⲑⲙⲁⲓⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ⲉϣⲱⲡ ⲅⲁⲣ ⲛⲉ ⲛⲓ⳿ⲉⲑⲛⲟⲥ ⲛⲏⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲙⲟⲥ ⳿ⲙⲙⲁⲩ ⲫⲩⲥⲓⲥ ⲥⲉ⳿ⲓⲣⲓ ⳿ⲛⲛⲁ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲁⲓ ⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲟⲩ ⲛⲟⲙⲟⲥ ⳿ⲙⲙⲁⲩ ⲥⲉⲟⲓ ⳿ⲛⲛⲟⲙⲟⲥ ⲛⲱⲟⲩ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ⲛⲁⲓ ⲉⲑⲟⲩⲱⲛϩ ⳿ⲙⲡⲓϩⲱⲃ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ⲉϥ⳿ⲥϧⲏⲟⲩⲧ ϧⲉⲛ ⲡⲟⲩϩⲏⲧ ⲟⲩⲟϩ ⲉⲣⲉ ⲧⲟⲩⲥⲩⲛⲏⲇⲏⲥⲓⲥ ⲉⲣⲙⲉⲑⲣⲉ ⳿ⲉⲣⲱⲟⲩ ⲛⲉⲙⲱⲟⲩ ⲟⲩⲟϩ ⲉⲣⲉ ⲛⲟⲩⲙⲉⲩⲓ ⲉⲣⲕⲁⲧⲏⲅⲟⲣⲓⲛ ⲟⲩⲧⲱⲟⲩ ⲛⲉⲙ ⲛⲟⲩⲉⲣⲏⲟⲩ ⲓⲉ ⲉⲩⲛⲁⲉⲣ⳿ⲡⲕⲉⲁⲡⲟⲗⲟⲅⲓⲥⲑⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁϯϩⲁⲡ ⳿ⲉⲛⲏⲉⲧϩⲏⲡ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲕⲁⲧⲁ ⲡⲁⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⳿ⲕϯⲣⲁⲛ ⳿ⲉⲣⲟⲕ ϫⲉ ⲓⲟⲩⲇⲁⲓ ⳿ⲕⲙⲟⲧⲉⲛ ⳿ⲙⲙⲟⲕ ⳿ⲉϫⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲟϩ ⳿ⲕϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲕ ϧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ⲟⲩⲟϩ ⳿ⲕⲥⲱⲟⲩⲛ ⳿ⲙⲡⲉϥⲟⲩⲱϣ ⲟⲩⲟϩ ⳿ⲕⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲛⲛⲏⲉⲧⲥⲱⲧⲡ ⳿ⲕⲉⲣⲕⲁⲑⲏⲕⲓⲛ ⳿ⲙⲙⲟⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","⳿ϩⲑⲏⲕ ⲭⲏ ⳿ⲉⲣⲟⲕ ϫⲉ ⳿ⲛⲑⲟⲕ ⲟⲩⲣⲉϥ ϭⲓⲙⲱⲓⲧ ⳿ⲛⲛⲓⲃⲉⲗⲗⲉⲩ ⲟⲩⲟⲩⲱⲓⲛⲓ ⳿ⲛⲧⲉ ⲛⲏⲉⲧϧⲉⲛ ⳿ⲡⲭⲁⲕⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","⳿ⲫⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ ⲛⲓⲁⲧϩⲏⲧ ⲟⲩⲟϩ ⳿ⲡⲥⲁϧ ⳿ⲛⲛⲓⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩⲓ ⲉⲣⲉ ⳿ⲑⲙⲟⲣⲫⲏ ⳿ⲛⲧⲉ ⳿ⲡ⳿ⲉⲙⲓ ⳿ⲛⲧⲟⲧⲕ ⲛⲉⲙ ϯⲙⲉⲑⲙⲏⲓ ⲉⲧϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ⲫⲏ ⲟⲩⲛ ⲉⲧϯ⳿ⲥⲃⲱ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⳿ⲕϯ⳿ⲥⲃⲱ ⲛⲁⲕ ⳿ⲙⲙⲁⲩⲁⲧⲕ ⲁⲛ ⲫⲏⲉⲧϩⲓⲱⲓϣ ⳿ⲉ⳿ϣⲧⲉⲙ ϭⲓⲟⲩ⳿ⲓ ⳿ⲕϭⲓⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ⲫⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲙⲡⲉⲣⲉⲣⲛⲱⲓⲕ ⳿ⲕⲟⲓ ⳿ⲛⲛⲱⲓⲕ ⲫⲏⲉⲧⲥⲱϥ ⳿ⲛⲛⲓ⳿ⲓⲇⲱⲗⲟⲛ ⳿ⲕⲟⲓ ⳿ⲛⲕⲁⲗⲡⲉⲣⲫⲉⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ⲫⲏⲉⲧϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲡⲁⲣⲁⲃⲁⲥⲓⲥ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲕϣⲱϣ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","⳿ⲫⲣⲁⲛ ⲅⲁⲣ ⳿ⲙⲫϯ ⲥⲉϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ⲟⲩⲟⲛ ϩⲏⲟⲩ ⲅⲁⲣ ⳿ⲙⲡⲓⲥⲉⲃⲓ ⲉϣⲱⲡ ⲁⲕϣⲁⲛ⳿⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲉϣⲱⲡ ⲇⲉ ⲉⲕⲟⲓ ⳿ⲙⲡⲁⲣⲁⲃⲁⲧⲏⲥ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲁ ⲡⲉⲕⲥⲉⲃⲓ ⲁϥϣⲱⲡⲓ ⲉⲩⲙⲉⲧⲁⲧⲥⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ⲉϣⲱⲡ ⲟⲩⲛ ⲁⲣⲉϣⲁⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲁⲣⲉϩ ⳿ⲉϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲭⲓ ⲧⲉϥⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲥⲉⲛⲁⲟⲡⲥ ⲉⲩⲥⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ⲟⲩⲟϩ ϯⲫⲩⲥⲓⲕⲏ ⳿ⲙⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲉⲥϫⲱⲕ ⳿ⲙ⳿ⲡϩⲱⲃ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ⳿ⲥⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟⲕ ϧⲁ ⲡⲓ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓ⳿ⲥϧⲁⲓ ⲛⲉⲙ ⲡⲓⲥⲉⲃⲓ ϫⲉ ⲁⲕⲉⲣ ⲟⲩⲡⲁⲣⲁⲃⲁⲧⲏ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ⲡⲓⲓⲟⲩⲇⲁⲓ ⲅⲁⲣ ⲁⲛ ⲉⲧϧⲉⲛ ⲡⲉⲑⲟⲩⲟⲛϩ ⲡⲉ ⲡⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲇⲉ ⳿ⲡⲥⲉⲃⲓ ⲁⲛ ⲉⲑⲟⲩⲟⲛϩ ϧⲉⲛ ⳿ⲧⲥⲁⲣⲝ ⲡⲉ ⲡⲓⲥⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ⲁⲗⲗⲁ ⲡⲓⲓⲟⲩⲇⲁⲓ ⲉⲧϩⲏⲡ ⲫⲁⲓ ⲡⲉ ⲡⲓⲓⲟⲩⲇⲁⲓ ⲟⲩⲟϩ ⲡⲓⲥⲉⲃⲓ ⳿ⲛⲧⲉ ⲡⲓϩⲏⲧ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ϧⲉⲛ ⲟⲩ⳿ⲥϧⲁⲓ ⲁⲛ ⲫⲏⲉⲧⲉ ⲡⲉϥϣⲟⲩϣⲟⲩ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱⲙⲓ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ⲡⲉ ");
INSERT INTO copcnt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ⲟⲩ ϫⲉ ⲡⲉ ⳿ⲡϩⲟⲩ⳿ⲟ ⳿ⲙⲡⲓⲓⲟⲩⲇⲁⲓ ⲓⲉ ⲁϣ ⲡⲉ ⳿ⲡϩⲏⲟⲩ ⳿ⲙⲡⲓⲥⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ⲟⲩⲛⲓϣϯ ⲡⲉ ⲕⲁⲧⲁ ⲥⲁ⳿ⲛⲣⲏϯ ⲛⲓⲃⲉⲛ ⳿ⲛϣⲟⲣⲡ ⲙⲉⲛ ϫⲉ ⲁⲩⲧⲉⲛϩⲟⲩⲧⲟⲩ ⳿ⲉⲛⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ⲟⲩ ⲅⲁⲣ ⲓⲥϫⲉ ⲁⲩⲉⲣⲁⲑⲛⲁϩϯ ⳿ⲛϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⲙⲏ ⲧⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ⲛⲁⲕⲉⲣϥ ⲡⲓⲛⲁϩϯ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲙⲁⲣⲉ ⲫϯ ⲇⲉ ϣⲱⲡⲓ ⳿ⲛⲣⲉϥϫⲉⲙⲉⲑⲙⲏⲓ ⲟⲩⲟϩ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⳿ⲛⲣⲉϥϫⲉⲙⲉⲑⲛⲟⲩϫ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉⲕⲙⲁⲓ ϧⲉⲛ ⲛⲉⲕⲥⲁϫⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲕϭⲣⲟ ⲉⲩⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ⲓⲥϫⲉ ⲧⲉⲛⲙⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ⲉⲑⲛⲁⲧⲁϩⲉ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉⲣⲁⲧⲥ ⲟⲩ ⲡⲉ ⲧⲉⲛⲛⲁϫⲟϥ ⲙⲏ ⲟⲩⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ⲡⲉ ⲫϯ ⲉϥⲛⲁ⳿ⲓⲛⲓ ⳿ⲙⲡⲉϥϫⲱⲛⲧ ⲁⲓϫⲱ ⳿ⲙⲫⲁⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧⲣⲱⲙⲓ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","⳿ⲙⲙⲟⲛ ⲡⲱⲥ ⲫϯ ⲛⲁϯϩⲁⲡ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ⲓⲥϫⲉ ⲇⲉ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ⲁⲥⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲡⲉϥⲱⲟⲩ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲧⲁⲙⲉⲑⲛⲟⲩϫ ⲓⲉ ⲉⲑⲃⲉⲟⲩ ⲥⲉϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ϩⲱ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲣⲉϥⲉⲣⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲁⲛ ⲉⲧⲟⲩϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟⲛ ⳿ⲙⲙⲟϥ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲉⲣⲟⲛ ϫⲉ ϣⲁⲛϫⲟⲥ ϫⲉ ⲙⲁⲣⲉⲛ⳿ⲓⲣⲓ ⳿ⲛⲛⲓⲡⲉⲧϩⲱⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ⲓ ⲛⲁⲛ ⳿ⲛϫⲉ ⲛⲓⲡⲉⲑⲛⲁⲛⲉⲩ ⲛⲏⲉⲧⲉ ⲡⲟⲩϩⲁⲡ ⲭⲏ ϧⲁ ⳿ⲡϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ⲟⲩ ϫⲉ ⲟⲩⲟⲛ ϩⲟⲩ⳿ⲟ ⳿ⲛⲧⲟⲧⲉⲛ ⲟⲩ ⲡⲁⲛⲧⲱⲥ ⲁⲛ ⲉⲣϣⲟⲣⲡ ⳿ⲛϫⲉⲙ ⲁⲣⲓⲕⲓ ⳿ⲉⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ϫⲉ ⲥⲉⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲃⲓ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩ⳿ⲑⲙⲏⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","⳿ⲙⲙⲟⲛ ⲡⲉⲧⲕⲁϯ ⳿ⲙⲙⲟⲛ ⲡⲉⲧϣⲓⲛⲓ ⳿ⲛⲥⲁ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ⲁⲩⲣⲓⲕⲓ ⳿ⲉⲃⲟⲗ ⲧⲏⲣⲟⲩ ⲁⲩⲉⲣⲁⲧϣⲁⲩ ⲉⲩⲥⲟⲡ ⳿ⲙⲙⲟⲛ ⲡⲉⲧ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲉⲧⲭ͞ⲣⲥ̅ ⳿ⲙⲙⲟⲛ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲟⲩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ⲟⲩ⳿ⲙϩⲁⲩ ⲉϥⲟⲩⲏⲛ ⲡⲉ ⲧⲟⲩ⳿ϣⲃⲱⲃⲓ ⲁⲩⲉⲣ⳿ⲭⲣⲟϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲟⲩⲗⲁⲥ ⲟⲩⲙⲁⲑⲟⲩⲓ ⳿ⲛϩⲟϥ ⲉⲧⲭⲏ ϧⲁ ⲛⲟⲩ⳿ⲥⲫⲟⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ⲛⲁⲓ ⲉⲧⲉ ⲣⲱⲟⲩ ⲙⲉϩ ⳿ⲛⲥⲁϩⲟⲩ⳿ⲓ ⲛⲉⲙ ⲉⲛϣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ⲥⲉⲓⲏⲥ ⳿ⲛϫⲉ ⲛⲟⲩϭⲁⲗⲁⲩϫ ⳿ⲉⲫⲉⲛ ⳿ⲥⲛⲟϥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","⳿ⲡϧⲟⲙϧⲉⲙ ⲛⲉⲙ ⳿ⲡⲧⲁⲗⲉⲡⲱⲣⲓⲁ ⲉⲧⲭⲏ ϩⲓ ⲛⲟⲩⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ⲟⲩⲟϩ ⳿ⲫⲙⲱⲓⲧ ⳿ⲛⲧⲉ ϯϩⲓⲣⲏⲛⲏ ⳿ⲙⲡⲟⲩⲥⲟⲩⲱⲛϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ϯϩⲟϯ ⳿ⲛⲧⲉ ⲫϯ ⲭⲏ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲛⲟⲩⲃⲁⲗ ⳿ⲉⲃⲟⲗ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ⲧⲉⲛ⳿ⲉⲙⲓ ⲇⲉ ϫⲉ ⲛⲏ ⲧⲏⲣⲟⲩ ⲉⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ϫⲱ ⳿ⲙⲙⲱⲟⲩ ⲁϥϫⲱ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲛⲏⲉⲧϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲣⲱϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲑⲱⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲧⲏⲣϥ ϣⲱⲡⲓ ϧⲁ ⲡⲓϩⲁⲡ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ϫⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲥⲁⲣⲝ ⲛⲁⲙⲁⲓ ϧⲁⲧⲉⲛ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲁ ⳿ⲡⲥⲟⲩⲉⲛ ⳿ⲫⲛⲟⲃⲓ ϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ϯⲛⲟⲩ ⲇⲉ ⲁⲧϭⲛⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲁ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ⲁⲥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲉⲩⲉⲣⲙⲉⲑⲣⲉ ϧⲁⲣⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ϯⲙⲉⲑⲙⲏⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲫϯ ϯ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ϧⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲙⲙⲟⲛ ⲫⲱⲣϫ ⲅⲁⲣ ϣⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ⲁⲩⲉⲣⲛⲟⲃⲓ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⲥⲉϣⲁⲧ ⳿ⲙ⳿ⲡⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ⲉⲩ⳿ⲑⲙⲁⲓⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲓⲛϫⲏ ϧⲉⲛ ⲡⲉϥ⳿ϩⲙⲟⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲥⲱϯ ⲫⲏⲉⲧϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ⲫⲏⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲭⲁϥ ⳿ⲛϫⲉ ⲫϯ ⳿ⲛⲟⲩⲣⲉϥⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲉⲃⲟⲗϩⲓⲧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉϥ⳿ⲥⲛⲟϥ ⳿ⲉ⳿ⲫⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲧⲉϥⲙⲉⲑⲙⲏⲓ ⲉⲑⲃⲉ ⳿ⲡⲭⲱ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓϣⲟⲣⲡ ⳿ⲛⲛⲟⲃⲓ ⲉⲧⲁⲩϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ϧⲉⲛ ϯⲙⲉⲧⲣⲉϥⲱⲟⲩ ⳿ⲛϩⲏⲧ ⳿ⲛⲧⲉ ⲫϯ ⲉⲑⲣⲉⲥϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲧⲉϥⲙⲉⲑⲙⲏⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲁⲓⲥⲏⲟⲩ ⳿ⲛⲧⲉ ϯⲛⲟⲩ ϫⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲑⲙⲏⲓ ⲟⲩⲟϩ ⲉϥ⳿ⲑⲙⲁⲓⲟ ⳿ⲙⲡⲓ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ⲁϥⲑⲱⲛ ⲟⲩⲛ ⲡⲓϣⲟⲩϣⲟⲩ ⲁⲩⲙⲁ⳿ϣⲑⲁⲙ ⳿ⲉⲣⲱϥ ϩⲓⲧⲉⲛ ⲁϣ ⳿ⲛⲛⲟⲙⲟⲥ ⲫⲁ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ⲧⲉⲛⲛⲁⲉⲡ ⲟⲩⲣⲱⲙⲓ ⲅⲁⲣ ϫⲉ ⳿ϥⲛⲁⲙⲁⲓ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⲁⲧϭⲛⲉ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ϣⲁⲛ ⲫϯ ⲫⲁ ⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲡⲉ ⲟⲩⲟϩ ⲫⲁ ⲛⲓⲕⲉⲉⲑⲛⲟⲥ ⳿ⲛⲑⲱⲟⲩ ⲁⲛ ⲡⲉ ⲁϩⲁ ⲫⲁ ⲛⲓⲕⲉⲉⲑⲛⲟⲥ ϩⲱⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ⲓⲥϫⲉ ϩⲁⲣⲁ ⲟⲩⲁⲓ ⲡⲉ ⲫϯ ⲫⲏⲉⲑⲛⲁ⳿ⲑⲙⲁⲓ⳿ⲉ ⳿ⲡⲥⲉⲃⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⲛⲉⲙ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ⲧⲉⲛⲛⲁⲕⲉⲣϥ ⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲁϩϯ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲁⲗⲗⲁ ⲡⲓⲛⲟⲙⲟⲥ ⲧⲉⲛⲛⲁⲧⲁϩⲟ ⳿ⲙⲙⲟϥ ⳿ⲉⲣⲁⲧϥ ");
INSERT INTO copcnt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϫⲟϥ ⲉⲑⲃⲉ ⲁⲃⲣⲁⲁⲙ ϫⲉ ⲁⲩϫⲉⲙϥ ⲡⲉⲛϣⲟⲣⲡ ⳿ⲛⲓⲱⲧ ⲕⲁⲧⲁ ⲥⲁⲣⲝ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ⲓⲥϫⲉ ⲅⲁⲣ ⲁⲃⲣⲁⲁⲙ ⲁϥⲙⲁⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲓⲉ ⲟⲩⲟⲛⲧⲉϥ ϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲁⲩ ⲁⲗⲗⲁ ⲟⲩⲃⲉ ⲫϯ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ⲟⲩ ⲅⲁⲣ ⲉⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱ ⳿ⲙⲙⲟϥ ⲁⲃⲣⲁⲁⲙ ⲇⲉ ⲁϥⲛⲁϩϯ ⳿ⲉⲫϯ ⲟⲩⲟϩ ⲁⲩⲟⲡⲥ ⲛⲁϥ ⲉⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ⲫⲏⲉⲧⲉⲣϩⲱⲃ ⳿ⲙⲡⲁⲩⲉⲡ ⲡⲉϥⲃⲉⲭⲉ ⲛⲁϥ ⲕⲁⲧⲁ ⲟⲩ⳿ϩⲙⲟⲧ ⲁⲗⲗⲁ ϫⲉ ⳿ϥⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ⲫⲏ ⲇⲉ ⲉⲧⲉ⳿ⲛ⳿ϥⲉⲣϩⲱⲃ ⲁⲛ ⲉϥⲛⲁϩϯ ⲇⲉ ⳿ⲉⲫⲏⲉⲧ⳿ⲑⲙⲁⲓⲟ ⳿ⲙⲡⲓⲁⲥⲉⲃⲏⲥ ϣⲁⲩⲉⲡ ⲡⲉϥⲛⲁϩϯ ⲛⲁϥ ⲉⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ϩⲱϥ ⲉⲧⲁ ⲇⲁⲩⲓⲇ ϫⲱ ⳿ⲙⲡⲓⲙⲁⲕⲁⲣⲓⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲫⲏⲉⲧⲉ ⲫϯ ⲛⲁⲱⲡ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ ⲛⲁϥ ⲁⲧϭⲛⲉ ϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ⲱⲟⲩⲛⲓ⳿ⲁⲧⲟⲩ ⳿ⲛⲛⲏⲉⲧⲁⲩⲭⲱ ⳿ⲛⲛⲟⲩ⳿ⲁⲛⲟⲙⲓⲁ ⲛⲱⲟⲩ ⳿ⲉⲃⲟⲗ ⲛⲉⲙ ⲛⲏⲉⲧⲁⲩϩⲱⲃⲥ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⲛⲟⲩⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ⲱⲟⲩⲛⲓ⳿ⲁⲧϥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲉⲧⲉ Ⲡ⳪ ⲛⲁⲉⲡ ⲛⲟⲃⲓ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ⲡⲁⲓⲙⲁⲕⲁⲣⲓⲥⲙⲟⲥ ⲟⲩⲛ ⲁϥⲭⲏ ⳿ⲉϫⲉⲛ ⳿ⲡⲥⲉⲃⲓ ϣⲁⲛ ⳿ⲉϫⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲧⲉⲛϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲩⲉⲡ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲛⲁϥ ⲉⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ⲡⲱⲥ ⲟⲩⲛ ⲁⲩⲟⲡϥ ⲉϥⲭⲏ ϧⲉⲛ ⳿ⲡⲥⲉⲃⲓ ϣⲁⲛ ⲉϥⲭⲏ ϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲉϥⲭⲏ ϧⲉⲛ ⳿ⲡⲥⲉⲃⲓ ⲁⲛ ⲁⲗⲗⲁ ϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ⲟⲩⲟϩ ⲁϥϭⲓ ⳿ⲛⲟⲩⲙⲏⲓⲛⲓ ⳿ⲛⲧⲉ ⳿ⲡⲥⲉⲃⲓ ⲟⲩ⳿ⲥⲫⲣⲁⲅⲓⲥ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ⲑⲏⲉⲧϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲛⲓⲱⲧ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⳿ⲉ⳿ⲡϫⲓⲛⲧⲟⲩⲱⲡ ⳿ⲛⲟⲩⲙⲉⲑⲙⲏⲓ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ⲟⲩⲟϩ ⳿ⲛⲓⲱⲧ ⳿ⲛⲧⲉ ⳿ⲡⲥⲉⲃⲓ ⳿ⲛⲛⲓ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲥⲉⲃⲓ ⳿ⲙⲙⲁⲩⲁⲧⲟⲩ ⲁⲛ ⲁⲗⲗⲁ ⲛⲉⲙ ⲛⲏⲉⲑⲙⲟϣⲓ ϩⲓ ⲛⲓϣⲉⲛⲧⲁⲧⲥⲓ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ⲉⲧϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⳿ⲛⲧⲉ ⲡⲉⲛⲓⲱⲧ ⲁⲃⲣⲁⲁⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ⲟⲩ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲁⲛ ⲁⲩϯ ⳿ⲙⲡⲓⲱϣ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲓⲉ ⲡⲉϥ⳿ϫⲣⲟϫ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ⲓⲥϫⲉ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⲛⲉ ⲛⲓ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ϩⲁⲣⲁ ⲁϥϣⲱⲡⲓ ⲉϥϣⲟⲩⲓⲧ ⳿ⲛϫⲉ ⲡⲓⲛⲁϩϯ ⲟⲩⲟϩ ⲁϥⲕⲱⲣϥ ⳿ⲛϫⲉ ⲡⲓⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","⳿ⲫⲛⲟⲙⲟⲥ ⲅⲁⲣ ⲁϥⲉⲣϩⲱⲃ ⲉⲩϫⲱⲛⲧ ⳿ⲫⲙⲁ ⲇⲉ ⲉⲧⲉ ⳿ⲙⲙⲟⲛ ⲛⲟⲙⲟⲥ ⳿ⲙⲙⲁⲩ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⲡⲁⲣⲁⲃⲁⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ⲉⲑⲃⲉ ⲫⲁⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲛⲁϩϯ ϩⲓⲛⲁ ⲕⲁⲧⲁ ⲟⲩ⳿ϩⲙⲟⲧ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲛϫⲉ ⲡⲓⲱϣ ⲉϥⲧⲁϫⲣⲏⲟⲩⲧ ⳿ⲙⲡⲓ⳿ϫⲣⲟϫ ⲧⲏⲣϥ ⳿ⲙⲫⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲁⲗⲗⲁ ⲛⲉⲙ ⲫⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⲉⲧⲉ ⲡⲉⲛⲓⲱⲧ ⲧⲏⲣⲉⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲁⲓⲭⲁⲕ ⳿ⲛⲓⲱⲧ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲉⲑⲛⲟⲥ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ ⲫⲏⲉⲧⲁϥⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲫⲏⲉⲧⲧⲁⲛϧⲟ ⳿ⲛⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⲉⲧⲑⲱϩⲉⲙ ⳿ⲛⲛⲏⲉⲧⲉ ⳿ⲛⲥⲉϣⲟⲡ ⲁⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⲛⲉ ⲉⲩϣⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ⲫⲏ ⳿ⲉⲛⲁϥⲟⲓ ⳿ⲛⲁⲧϩⲉⲗⲡⲓⲥ ⲉⲩϩⲱⲃ ⲁϥⲛⲁϩϯ ⲉⲩϩⲉⲗⲡⲓⲥ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲛⲓⲱⲧ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲉⲑⲛⲟⲥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁⲩϫⲟⲥ ⲛⲁϥ ϫⲉ ⲉⲣⲉ ⲡⲉⲕ⳿ϫⲣⲟϫ ⲉϥ⳿ⲉϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ⲟⲩⲟϩ ⲉⲧⲉ ⳿ⲙⲡⲉϥϣⲱⲛⲓ ϧⲉⲛ ⲡⲓⲛⲁϩϯ ⳿ⲉⲁϥϯⲛⲓ⳿ⲁⲧϥ ⳿ⲙⲡⲉϥⲥⲱⲙⲁ ⲁϥϫⲉⲙϥ ϩⲏⲇⲏ ⲁϥⲙⲟⲩ ⲁϥ⳿ⲓ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲛⲁⲩ ⲣ̅ ⳿ⲛⲣⲟⲙⲡⲓ ⲛⲉⲙ ϯⲕⲉⲙⲉⲧⲣⲉϥⲙⲱⲟⲩⲧ ⳿ⲛⲧⲉ ⳿ⲑⲙⲏⲧⲣⲁ ⳿ⲛⲥⲁⲣⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ⲟⲩⲟϩ ⲉⲧⲉ ⳿ⲙⲡⲉϥⲉⲣϩⲏⲧ ⲃ̅ ϧⲉⲛ ⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ⳿ⲉⲡⲓⲱϣ ⳿ⲛⲧⲉ ⲫϯ ⲁⲗⲗⲁ ⲁϥϫⲉⲙϫⲟⲙ ϧⲉⲛ ⲡⲓⲛⲁϩϯ ⳿ⲉⲁϥϯⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ⲟⲩⲟϩ ⲁ ⲡⲉϥϩⲏⲧ ⲑⲏⲧ ϫⲉ ⲫⲏⲉⲧⲁϥⲱϣ ⳿ⲙⲙⲟϥ ⲛⲁϥⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲁⲓϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲩⲟⲡⲥ ⲛⲁϥ ⲉⲩⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ⲛⲉ ⲉⲧⲁⲩ⳿ⲥϧⲏⲟⲩⲧ ⲇⲉ ⲁⲛ ⲉⲑⲃⲏⲧϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ϫⲉ ⲁⲩⲟⲡⲥ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ⲁⲗⲗⲁ ⲛⲉⲙ ⲉⲑⲃⲏⲧⲉⲛ ϩⲱⲛ ϧⲁ ⲛⲏⲉⲧⲁⲩⲟⲡⲥ ⲛⲱⲟⲩ ⲛⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲫⲏⲉⲧⲁϥⲧⲟⲩⲛⲟⲥ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ⲫⲏⲉⲧⲁⲩⲧⲏⲓϥ ⲉⲑⲃⲉ ⲛⲉⲛⲛⲟⲃⲓ ⲟⲩⲟϩ ⲁϥⲧⲱⲛϥ ⲉⲑⲃⲉ ⲡⲉⲛ⳿ⲑⲙⲁⲓⲟ ");
INSERT INTO copcnt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ⲉⲧⲁⲩ⳿ⲑⲙⲁⲓⲟⲛ ⲟⲩⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲛⲁϩϯ ⲙⲁⲣⲉⲛ⳿ⲓⲣⲓ ⳿ⲛⲟⲩϩⲓⲣⲏⲛⲏ ϧⲁⲧⲉⲛ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ⲫⲏⲉⲧⲁ ⳿ⲡϫⲓⲛ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϣⲱⲡⲓ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲉⲡⲁⲓ⳿ϩⲙⲟⲧ ⲫⲏⲉⲧⲉⲛⲟϩⲓ ⳿ⲉⲣⲁⲧⲉⲛ ⳿ⲛϧⲏⲧϥ ⲟⲩⲟϩ ⲉⲛϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲛ ϧⲉⲛ ⲟⲩϩⲉⲗⲡⲓⲥ ⳿ⲛⲧⲉ ⳿ⲡⲱⲟⲩ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ⲟⲩ ⲙⲟⲛⲟⲛ ⲇⲉ ⲁⲗⲗⲁ ⲉⲛⲉⲣ⳿ⲡⲕⲉϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲓϩⲟϫϩⲉϫ ⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⲡⲓϩⲟϫϩⲉϫ ⲁϥⲉⲣϩⲱⲃ ⲉⲩϩⲩⲡⲟⲙⲟⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ϯϩⲩⲡⲟⲙⲟⲛⲏ ⲇⲉ ⲉⲩⲇⲟⲕⲓⲙⲏ ϯⲇⲟⲕⲓⲙⲏ ⲇⲉ ⲉⲩϩⲉⲗⲡⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ϯϩⲉⲗⲡⲓⲥ ⲇⲉ ⳿ⲙⲡⲁⲥϭⲓϣⲓⲡⲓ ϫⲉ ϯⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ ⲫϯ ⲁⲥⲫⲱⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲛⲉⲛϩⲏⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲉⲧⲁϥⲧⲏ ⲓϥ ⲛⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ⲓⲥϫⲉ ⲅⲁⲣ ⲉⲧⲓ ⲉⲛⲟⲓ ⳿ⲛⲁⲥⲑⲉⲛⲏⲥ ⳿ⲛⲟⲩⲥⲏⲟⲩ Ⲡⲭ̅ⲥ̅ ⲁϥⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲓ⳿ⲁⲥⲉⲃⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ⲙⲟⲅⲓⲥ ⲅⲁⲣ ϣⲁⲧⲉ ⲟⲩⲁⲓ ⲙⲟⲩ ⳿ⲉϫⲉⲛ ⲟⲩ⳿ⲑⲙⲏⲓ ⲧⲁⲭⲁ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉⲙⲟⲩ ⳿ⲉϫⲉⲛ ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","⳿ϥⲧⲁϩⲟ ⲇⲉ ⳿ⲛⲧⲉϥⲁⲅⲁⲡⲏ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟⲛ ⳿ⲛϫⲉ ⲫϯ ϫⲉ ⲉⲧⲓ ⲉⲛⲟⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ Ⲡⲭ̅ⲥ̅ ⲁϥⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","⳿ⲛϩⲟⲩ⳿ⲟ ⲙⲁⲗⲗⲟⲛ ⲉⲧⲁⲩ⳿ⲑⲙⲁⲓⲟⲛ ϯⲛⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥ⳿ⲥⲛⲟϥ ⲉⲛ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲥⲁⲃⲟⲗ ⳿ⲙ⳿ⲡϫⲱⲛⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ⲓⲥϫⲉ ⲅⲁⲣ ⲉⲛⲟⲓ ⳿ⲛϫⲁϫⲓ ⲁⲛϩⲱⲧⲡ ⳿ⲉⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲙⲟⲩ ⳿ⲛⲧⲉ ⲡⲉϥϣⲏⲣⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⲙⲁⲗⲗⲟⲛ ⲉⲧⲁⲛϩⲱⲧⲡ ⳿ⲉⲣⲟϥ ⲉⲛ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲡⲉϥⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ⲟⲩ ⲙⲟⲛⲟⲛ ⲇⲉ ⲁⲗⲗⲁ ⲁⲛⲉⲣ⳿ⲡⲕⲉϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲛ ϧⲉⲛ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲫⲁⲓ ⲉⲧⲁⲛϭⲓ ⳿ⲙⲡⲓϩⲱⲧⲡ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ⲉⲑⲃⲉ ⲫⲁⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⳿ⲫⲛⲟⲃⲓ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲟⲩⲱⲧ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲛⲟⲃⲓ ⲁ ⳿ⲫⲙⲟⲩ ϣⲱⲡⲓ ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⲁ ⲡⲓⲙⲟⲩ ϣⲉ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲫⲏⲉⲧⲁⲩⲉⲣⲛⲟⲃⲓ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ϣⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⲅⲁⲣ ⲛⲁⲣⲉ ⳿ⲫⲛⲟⲃⲓ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲫⲛⲟⲃⲓ ⲇⲉ ⲛⲁⲩⲱⲡ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲉ⳿ⲙⲙⲟⲛ ⲛⲟⲙⲟⲥ ϣⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ⲁⲗⲗⲁ ⳿ⲫⲙⲟⲩ ⲁϥⲉⲣⲟⲩⲣⲟ ⲓⲥϫⲉⲛ ⲁⲇⲁⲙ ϣⲁ ⲙⲱ⳿ⲩⲥⲏⲥ ⲛⲉⲙ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲛⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲉⲣⲛⲟⲃⲓ ϧⲉⲛ ⳿ⲡ⳿ⲓⲛⲓ ⳿ⲛϯⲡⲁⲣⲁⲃⲁⲥⲓⲥ ⳿ⲛⲧⲉ Ⲁⲇⲁⲙ ⲉⲧⲉ ⳿ⲡⲧⲩⲡⲟⲥ ⳿ⲛⲧⲉ ⲡⲉⲑⲛⲏⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ⲁⲗⲗⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲁⲛ ⳿ⲙⲡⲓⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ ⲫⲁⲓ ⲡⲉ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓ⳿ϩⲙⲟⲧ ⲓⲥϫⲉ ⲅⲁⲣ ϧⲉⲛ ⲡⲓⲡⲁⲣⲁⲡⲧⲱⲙⲁ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ⲁ ⲟⲩⲙⲏϣ ⲙⲟⲩ ⳿ⲛϩⲟⲩⲟ ⲙⲁⲗⲗⲟⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ ⲛⲉⲙ ϯⲇⲱⲣⲉ⳿ⲁ ϧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲛⲟⲩⲱⲧ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲁϥⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲉⲟⲩⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲁⲛ ⲉⲧⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲁⲓ ⳿ⲉⲁϥⲉⲣⲛⲟⲃⲓ ⲡⲉ ⲡⲓⲧⲁⲓⲟ ⲡⲓϩⲁⲡ ⲙⲉⲛ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲁⲓ ⲡⲉ ⲉⲩⲕⲁⲧⲁ⳿ⲕⲣⲓⲙⲁ ⲡⲓ⳿ϩⲙⲟⲧ ⲇⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲙⲏϣ ⳿ⲙⲡⲁⲣⲁ⳿ⲡⲧⲱⲙⲁ ⲉⲩ⳿ⲑⲙⲁⲓⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ⲓⲥϫⲉ ⲅⲁⲣ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲛⲟⲃⲓ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲁⲓ ⲁ ⳿ⲫⲙⲟⲩ ⲁϥⲉⲣⲟⲩⲣⲟ ⳿ⲛϩⲟⲩ⳿ⲟ ⲙⲁⲗⲗⲟⲛ ⲛⲏⲉⲑⲛⲁϭⲓ ⳿ⲙⲡⲓϩⲟⲩ⳿ⲟ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⲛⲉⲙ ϯⲇⲱⲣⲉ⳿ⲁ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⲉⲩ⳿ⲉⲉⲣⲟⲩⲣⲟ ϧⲉⲛ ⲟⲩⲱⲛϧ ϣⲁ ⳿ⲉⲛⲉϩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲣⲱⲙⲓ ⳿ⲛⲟⲩⲱⲧ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ϩⲁⲣⲁ ⲟⲩⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⳿ⲫⲛⲟⲃⲓ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲟⲩⲁⲓ ⲁϥ⳿ⲓ ⳿ⲉϫⲉⲛ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲉⲩϩⲓⲟⲩⲓ ⳿ⲙ⳿ⲡϩⲁⲡ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓ⳿ⲑⲙⲁⲓⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩⲁⲓ ⲡⲉ ⳿ⲉϫⲉⲛ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲉⲩ⳿ⲑⲙⲁⲓⲟ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⲉⲧⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲑⲙⲉⲧⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⳿ⲛⲟⲩⲱⲧ ⲁⲩϣⲱⲡⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲑⲙⲉⲧⲣⲉϥⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲁⲓ ⲥⲉⲛⲁϣⲱⲡⲓ ⳿ⲛ⳿ⲑⲙⲏⲓ ⳿ⲛϫⲉ ⲛⲓⲙⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ⲫⲛⲟⲙⲟⲥ ⲇⲉ ⲁϥ⳿ⲓ ⳿ⲉϧⲟⲩⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⳿ⲁϣⲁⲓ ⲫⲏ ⲇⲉ ⲉⲧⲁ ⲡⲉϥⲛⲟⲃⲓ ⲉⲣϩⲟⲩ⳿ⲟ ⲁϥⲉⲣϩⲟⲩ⳿ⲟ ⳿ⲁϣⲁⲓ ⲛⲁϥ ⳿ⲛϫⲉ ⲡⲓ⳿ϩⲙⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ϩⲓⲛⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⳿ⲫⲛⲟⲃⲓ ⲉⲣⲟⲩⲣⲟ ϧⲉⲛ ⳿ⲫⲙⲟⲩ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉϥⲉⲣⲟⲩⲣⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲙⲉⲑⲙⲏⲓ ⲉⲩⲱⲛϧ ϣⲁ ⲉⲛⲉϩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪ ");
INSERT INTO copcnt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϫⲟϥ ⲧⲉⲛⲛⲁϣⲱⲡⲓ ϧⲉⲛ ⳿ⲫⲛⲟⲃⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⲉⲣϩⲟⲩ⳿ⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲛⲏⲉⲧⲁⲛⲙⲟⲩ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⲡⲱⲥ ⲟⲛ ⲧⲉⲛⲛⲁⲱⲛϧ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⳿ⲁⲛⲟⲛ ϧⲁ ⲛⲏⲉⲧⲁⲛϭⲓⲱⲙⲥ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲉⲧⲁⲛϭⲓⲱⲙⲥ ⳿ⲉⲡⲉϥⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ⲁⲩⲕⲟⲥⲉⲛ ⲟⲩⲛ ⲛⲉⲙⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲱⲙⲥ ⳿ⲉⲡⲉϥⲙⲟⲩ ϩⲓⲛⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲡⲱⲟⲩ ⳿ⲙ⳿ⲫⲓⲱⲧ ⲡⲁⲓⲣⲏϯ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲛⲧⲉⲛⲙⲟϣⲓ ϧⲉⲛ ⲟⲩⲙⲉⲧⲃⲉⲣⲓ ⳿ⲛⲧⲉ ⲟⲩⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ⲓⲥϫⲉ ⲅⲁⲣ ⲁⲛⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲱϫⲓ ϧⲉⲛ ⳿ⲡ⳿ⲥⲙⲟⲧ ⳿ⲛⲧⲉ ⲡⲉϥⲙⲟⲩ ⲁⲗⲗⲁ ⲉⲛ⳿ⲉϣⲱⲡⲓ ⲟⲛ ⲉⲧⲉϥⲕⲉ⳿ⲁⲛⲁⲥⲧⲁⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ⲉⲛ⳿ⲉⲙⲓ ⳿ⲉⲫⲁⲓ ϫⲉ ⲡⲉⲛⲣⲱⲙⲓ ⳿ⲛ⳿ⲁⲡⲁⲥ ⲁⲩⲁϣϥ ⲛⲉⲙⲁϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲕⲱⲣϥ ⳿ⲛϫⲉ ⳿ⲡⲥⲱⲙⲁ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣⲃⲱⲕ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ϫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ⲫⲏ ⲅⲁⲣ ⲉⲧⲁϥⲙⲟⲩ ⲁϥⲙⲁⲓ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ⲓⲥϫⲉ ⲇⲉ ⲁⲛⲙⲟⲩ ⲛⲉⲙ Ⲡⲭ̅ⲥ̅ ⲧⲉⲛⲛⲁϩϯ ϫⲉ ⲧⲉⲛⲛⲁⲱⲛϧ ⲛⲉⲙⲁϥ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ⲉⲛ⳿ⲉⲙⲓ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⳿ϥⲛⲁⲙⲟⲩ ⲁⲛ ϫⲉ ⳿ⲫⲙⲟⲩ ϫⲉ ⲛⲁⲉⲣ⳪ ⳿ⲉⲣⲟϥ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ⲫⲏ ⲅⲁⲣ ⲉⲧⲁϥⲙⲟⲩ ⳿ⲙⲙⲟϥ ⲁϥⲙⲟⲩ ⳿ⲉ⳿ⲫⲛⲟⲃⲓ ⳿ⲛⲟⲩⲥⲟⲡ ⲫⲏ ⲇⲉ ⳿ⲉⲧⲉϥⲱⲛϧ ⳿ⲙⲙⲟϥ ⳿ϥⲱⲛϧ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ⲡⲁⲓⲣⲏϯ ϩⲱⲧⲉⲛ ⲙⲉⲩⲓ ⳿ⲉⲣⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲙⲱⲟⲩⲧ ⳿ⲉ⳿ⲫⲛⲟⲃⲓ ⲉⲣⲉⲧⲉⲛⲱⲛϧ ⲇⲉ ⳿ⲙⲫϯ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲡⲉⲛ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ⲫⲛⲟⲃⲓ ⲟⲩⲛ ⲉⲣⲟⲩⲣⲟ ϧⲉⲛ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ ⲉⲑⲛⲁⲙⲟⲩ ⲉⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲛⲉϥ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲧⲁϩⲉ ⲛⲉⲧⲉⲛⲙⲉⲗⲟⲥ ⳿ⲛϩⲟⲡⲗⲟⲛ ⳿ⲛⲧⲉ ϯ⳿ⲁⲇⲓⲕⲓ⳿ⲁ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⲁⲗⲗⲁ ⲙⲁⲧⲁϩⲉ ⲑⲏⲛⲟⲩ ⳿ⲙⲫϯ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⲉⲩⲟⲛϧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲣⲉϥⲙⲱⲟⲩⲧ ⲟⲩⲟϩ ⲛⲉⲧⲉⲛⲙⲉⲗⲟⲥ ⳿ⲛϩⲟⲡⲗⲟⲛ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","⳿ⲫⲛⲟⲃⲓ ⲅⲁⲣ ⲛⲁⲉⲣ⳪ ⳿ⲉⲣⲱⲧⲉⲛ ⲁⲛ ⲛⲁⲣⲉⲧⲉⲛⲭⲏ ⲅⲁⲣ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⲁⲛ ⲁⲗⲗⲁ ϧⲁ ⲡⲓ⳿ϩⲙⲟⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ⲟⲩ ϫⲉ ⳿ⲛⲧⲉⲛⲉⲣⲛⲟⲃⲓ ϫⲉ ⲧⲉⲛⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⲁⲛ ⲁⲗⲗⲁ ϧⲁ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲫⲏⲉⲧⲉⲧⲉⲛⲧⲁϩⲟ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲙⲃⲱⲕ ⲛⲁϥ ⳿ⲉ⳿ⲡⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲃⲱⲕ ⳿ⲛⲧⲉ ⲫⲏⲉⲧⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⳿ⲛⲥⲱϥ ⳿ⲓⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⲉⲩⲙⲟⲩ ⳿ⲓⲧⲉ ⳿ⲡⲥⲱⲧⲉⲙ ⳿ⲉϯⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","⳿ⲡ⳿ϩⲙⲟⲧ ⲇⲉ ⳿ⲙⲫϯ ϣⲏⲡ ϫⲉ ⲛⲁⲣⲉⲧⲉⲛⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⲡⲉ ⲁⲣⲉⲧⲉⲛⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲛϩⲏⲧ ⳿ⲉⲡⲓⲧⲩⲡⲟⲥ ⳿ⲛ⳿ⲥⲃⲱ ⲫⲏⲉⲧⲁⲩϯ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ⲁⲣⲉⲧⲉⲛⲉⲣⲣⲉⲙϩⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲃⲓ ⲁⲣⲉⲧⲉⲛⲉⲣⲃⲱⲕ ⲇⲉ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ⲟⲩⲙⲉⲧⲣⲱⲙⲓ ⲡⲉϯϫⲱ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲉ ⳿ⲡϣⲱⲛⲓ ⳿ⲛⲧⲉⲧⲉⲛⲥⲁⲣⲝ ⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⲉⲧⲁⲣⲉⲧⲉⲛⲧⲁϩⲉ ⲛⲉⲧⲉⲛⲙⲉⲗⲟⲥ ⳿ⲙⲃⲱⲕ ⳿ⲙ⳿ⲡϭⲱϧⲉⲙ ⲛⲉⲙ ϯ⳿ⲁⲛⲟⲙⲓ⳿ⲁ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉϯ⳿ⲁⲛⲟⲙⲓ⳿ⲁ ⲡⲁⲓⲣⲏϯ ⲟⲛ ϯⲛⲟⲩ ⲙⲁⲧⲁϩⲉ ⲛⲉⲧⲉⲛⲙⲉⲗⲟⲥ ⳿ⲙⲃⲱⲕ ⳿ⲛ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉ⳿ⲡⲧⲟⲩⲃⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ϩⲟⲧⲉ ⲅⲁⲣ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙ⳿ⲫⲛⲟⲃⲓ ⲛⲁⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲣⲉⲙϩⲉ ⲡⲉ ⳿ⲛϯⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ⲟⲩ ϫⲉ ⳿ⲛⲟⲩⲧⲁϩ ⲉⲛⲁϥϣⲟⲡ ⲛⲱⲧⲉⲛ ⳿ⲙⲡⲓⲥⲏⲟⲩ ϧⲉⲛ ⲛⲏⲉⲧⲉⲧⲉⲛϭⲓϣⲓⲡⲓ ⳿ⲉϫⲱⲟⲩ ϯⲛⲟⲩ ⳿ⲧϧⲁ⳿ⲉ ⲅⲁⲣ ⳿ⲛⲛⲏ ⳿ⲫⲙⲟⲩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ϯⲛⲟⲩ ⲇⲉ ⲁⲣⲉⲧⲉⲛⲉⲣⲣⲉⲙϩⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲃⲓ ⲁⲣⲉⲧⲉⲛⲉⲣⲃⲱⲕ ⳿ⲙⲫϯ ⲟⲩⲟⲛ ⳿ⲛⲧⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩ ⳿ⲙⲡⲉⲧⲉⲛⲟⲩⲧⲁϩ ⳿ⲉ⳿ⲡⲧⲟⲩⲃⲟ ⳿ⲡϫⲱⲕ ⲇⲉ ⲟⲩⲱⲛϧ ϣⲁ ⲉⲛⲉϩ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ⲛⲓⲟⲯⲱⲛⲓⲟⲛ ⲅⲁⲣ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⳿ⲫⲙⲟⲩ ⲡⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⲇⲉ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲱⲛϧ ϣⲁ ⳿ⲉⲛⲉϩ ⲡⲉ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲡⲉⲛ⳪ ");
INSERT INTO copcnt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲁⲓⲥⲁϫⲓ ⲅⲁⲣ ⲛⲉⲙ ⲛⲏⲉⲧⲥⲱⲟⲩⲛ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ϫⲉ ⲡⲓⲛⲟⲙⲟⲥ ⳿ϥⲟⲓ ⳿ⲛ⳪ ⳿ⲉⲡⲓⲣⲱⲙⲓ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⲉϥⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ϯ⳿ⲥϩⲓⲙⲓ ϧⲁ ϩⲁⲓ ⲅⲁⲣ ⳿ⲥⲥⲟⲛϩ ⳿ⲉⲡⲉⲥϩⲁⲓ ⲉⲧⲟⲛϧ ϧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲙⲟⲩ ⳿ⲛϫⲉ ⲡⲓϩⲁⲓ ⲁⲥⲕⲱⲣϥ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲡⲓϩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ϩⲁⲣⲁ ⲟⲩⲛ ⲉϥⲟⲛϧ ⳿ⲛϫⲉ ⲡⲓϩⲁⲓ ϣⲁⲩⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲛⲱⲓⲕ ⲁⲥϣⲁⲛϣⲱⲡⲓ ⲛⲉⲙ ⲕⲉϩⲁⲓ ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲙⲟⲩ ⳿ⲛϫⲉ ⲡⲓϩⲁⲓ ⲟⲩⲣⲉⲙϩⲏ ⲧⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲉ⳿ϣⲧⲉⲙⲙⲟⲩϯ ⳿ⲉⲣⲟⲥ ϫⲉ ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲛⲱⲓⲕ ⲁⲥϣⲁⲛϣⲱⲡⲓ ⲛⲉⲙ ⲕⲉϩⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ϩⲱⲥⲧⲉ ⲟⲩⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲁⲧⲉⲧⲉⲛⲙⲟⲩ ϩⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲡⲥⲱⲙⲁ ⳿ⲙⲠⲭ̅ⲥ̅ ⲉⲑⲣⲉⲧⲉⲛϣⲱⲡⲓ ⳿ⲛⲕⲉⲟⲩⲁⲓ ⲉⲧⲉ ⲫⲏ ⲡⲉ ⲉⲧⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϯⲟⲩⲧⲁϩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ⲉⲛϣⲟⲡ ⲅⲁⲣ ϧⲉⲛ ϯⲥⲁⲣⲝ ⲛⲁⲣⲉ ⲛⲓⲡⲁⲑⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲛⲟⲃⲓ ⲛⲓ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ⲛⲁⲩⲉⲣϩⲱⲃ ϧⲉⲛ ⲛⲉⲛⲙⲉⲗⲟⲥ ⳿ⲉ⳿ⲡϯⲟⲩⲧⲁϩ ⳿ⲙ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ϯⲛⲟⲩ ⲇⲉ ⲁⲛⲕⲱⲣϥ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲉⲁⲛⲙⲟⲩ ϧⲉⲛ ⲫⲏ⳿ⲉⲛⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲟⲛ ⳿ⲛϧⲏⲧϥ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉⲛⲉⲣⲃⲱⲕ ϧⲉⲛ ⲟⲩⲙⲉⲧⲃⲉⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲟⲩⲟϩ ϧⲉⲛ ⲟⲩⲙⲉⲧⲁⲡⲁⲥ ⲁⲛ ⳿ⲛⲧⲉ ⲟⲩ⳿ⲥϧⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ⲟⲩ ϫⲉ ⲡⲉ ⳿ⲉⲧⲉⲛⲛⲁϫⲟϥ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲫⲛⲟⲃⲓ ⲡⲉ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲁⲗⲗⲁ ⳿ⲫⲛⲟⲃⲓ ⲛⲉ ⳿ⲙⲡⲓⲥⲟⲩⲱⲛϥ ⲡⲉ ⳿ⲉⲃⲏⲗ ϫⲉ ⲁⲓⲥⲟⲩⲱⲛϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲛⲟⲙⲟⲥ ϯ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⲅⲁⲣ ⲛⲁⲓⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⲡⲉ ⳿ⲉⲃⲏⲗ ϫⲉ ⲁ ⳿ⲫⲛⲟⲙⲟⲥ ϫⲟⲥ ϫⲉ ⳿ⲛⲛⲉⲕⲉⲣ⳿ⲉⲡⲓⲑⲩⲙⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","⳿ⲫⲛⲟⲃⲓ ⲇⲉ ⲉⲧⲁϥϭⲓ ⳿ⲛⲟⲩⲗⲱⲓϫⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲉⲛⲧⲟⲗⲏ ⲁϥⲉⲣϩⲱⲃ ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ⲛⲓⲃⲉⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲁⲧϭⲛⲉ ⳿ⲫⲛⲟⲙⲟⲥ ⲅⲁⲣ ⳿ⲫⲛⲟⲃⲓ ⲛⲁϥⲙⲱⲟⲩⲧ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","⳿ⲁⲛⲟⲕ ⲇⲉ ⲛⲁⲓⲱⲛϧ ⳿ⲛⲟⲩⲥⲏⲟⲩ ⲁⲧϭⲛⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲉⲧⲁⲥ⳿ⲓ ⲇⲉ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ϯⲉⲛⲧⲟⲗⲏ ⲁ ⳿ⲫⲛⲟⲃⲓ ⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","⳿ⲁⲛⲟⲕ ⲇⲉ ⲁⲓⲙⲟⲩ ⲟⲩⲟϩ ⲁⲩϫⲉⲙ ϯⲉⲛⲧⲟⲗⲏ ⲉⲧϭⲓ ⲛⲏⲓ ⳿ⲉ⳿ⲡⲱⲛϧ ⲑⲁⲓ ⲁⲥϣⲱⲡⲓ ⲛⲏⲓ ⲉⲩⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","⳿ⲫⲛⲟⲃⲓ ⲅⲁⲣ ⲁϥϭⲓ ⳿ⲛⲟⲩⲗⲱⲓϫⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲉⲛⲧⲟⲗⲏ ⲁϥⲉⲣϩⲁⲗ ⳿ⲙⲙⲟⲓ ⲟⲩⲟϩ ⲁϥϧⲟⲑⲃⲉⲧ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ϩⲱⲥⲧⲉ ⳿ⲫⲛⲟⲙⲟⲥ ⲙⲉⲛ ⳿ϥⲟⲩⲁⲃ ⲟⲩⲟϩ ϯⲉⲛⲧⲟⲗⲏ ⳿ⲥⲟⲩⲁⲃ ⲟⲩⲟϩ ⲟⲩ⳿ⲑⲙⲏⲓ ⲧⲉ ⲟⲩⲟϩ ⲛⲁⲛⲉⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲛ ⲁϥϣⲱⲡⲓ ⲛⲏⲓ ⲉⲩⲙⲟⲩ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲁⲗⲗⲁ ⳿ⲫⲛⲟⲃⲓ ⲡⲉ ϩⲓⲛⲁ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⳿ⲛⲧⲉϥⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⳿ⲫⲛⲟⲃⲓ ⲉϥⲉⲣϩⲱⲃ ⲛⲏⲓ ⲉⲩⲙⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛⲣⲉϥⲉⲣⲛⲟⲃⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲉⲛⲧⲟⲗⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ⲧⲉⲛⲥⲱⲟⲩⲛ ⲙⲉⲛ ⲅⲁⲣ ϫⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲟⲩⲡ͞ⲛⲁ̅ⲧⲓⲕⲟⲥ ⲡⲉ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲟⲩⲥⲁⲣⲕⲓⲕⲟⲥ ⳿ⲉⲁⲩⲧⲏⲓⲧ ⳿ⲉⲃⲟⲗ ϧⲁ ⳿ⲫⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ⲫⲏ ⲅⲁⲣ ⳿ⲉϯⲉⲣϩⲱⲃ ⳿ⲉⲣⲟϥ ⳿ⲛϯⲥⲱⲟⲩⲛ ⳿ⲙⲙⲟϥ ⲁⲛ ⳿ⲙⲫⲏ ⲅⲁⲣ ⲁⲛ ⳿ⲉϯⲟⲩⲁϣϥ ⲫⲁⲓ ⲡⲉ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ⲫⲏ ⳿ⲉϯⲙⲟⲥϯ ⳿ⲙⲙⲟϥ ⲡⲉ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ⲓⲥϫⲉ ⲫⲏⲉⲧⲉ ⳿ⲛϯⲟⲩⲁϣϥ ⲁⲛ ⲫⲁⲓ ⲡⲉ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲉⲙ ⲡⲓⲛⲟⲙⲟⲥ ϫⲉ ⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ϯⲛⲟⲩ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲉⲧⲉⲣϩⲱⲃ ⳿ⲉⲣⲟϥ ⲁⲗⲗⲁ ⳿ⲫⲛⲟⲃⲓ ⲡⲉ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ϯⲥⲱⲟⲩⲛ ⲅⲁⲣ ϫⲉ ⳿ϥϣⲟⲡ ⳿ⲛϧⲏⲧ ⲁⲛ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϧⲉⲛ ⲧⲁⲥⲁⲣⲝ ⳿ⲛϫⲉ ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲡⲓⲟⲩⲱϣ ⲅⲁⲣ ⳿ϥⲭⲏ ⲛⲁϩⲣⲁⲓ ⳿ⲉⲉⲣϩⲱⲃ ⲇⲉ ⳿ⲉⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⳿ⲙⲙⲟⲛ ⳿ⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ⲡⲉϯⲟⲩⲁϣϥ ⲅⲁⲣ ⳿ⲙⲡⲉⲑⲛⲁⲛⲉϥ ⲫⲁⲓ ⲡⲉ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ⲡⲉⲧⲉ ⳿ⲛϯⲟⲩⲁϣϥ ⲁⲛ ⳿ⲙⲡⲉⲧϩⲱⲟⲩ ⳿ⲛⲑⲟϥ ⲡⲉ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ⲓⲥϫⲉ ⲇⲉ ⲡⲉⲧⲉ ⳿ⲛϯⲟⲩⲁϣϥ ⲁⲛ ⳿ⲁⲛⲟⲕ ⲫⲁⲓ ϯⲣⲁ ⳿ⲙⲙⲟϥ ⲓⲉ ⳿ⲁⲛⲟⲕ ⲁⲛ ϫⲉ ⲉⲧⲉⲣϩⲱⲃ ⳿ⲉⲣⲟϥ ⲁⲗⲗⲁ ⳿ⲫⲛⲟⲃⲓ ⲡⲉ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ϯϫⲓⲙⲓ ϩⲁⲣⲁ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲫⲏⲉⲑⲟⲩⲱϣ ⳿ⲉ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲛⲉⲙⲏⲓ ϫⲉ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ϥⲭⲏ ⲛⲁϩⲣⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ϯϯⲙⲁϯ ⲅⲁⲣ ⲛⲉⲙ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲫϯ ⲕⲁⲧⲁ ⲡⲓⲣⲱⲙⲓ ⲉⲧⲥⲁϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ϯⲛⲁⲩ ⲇⲉ ⳿ⲉⲕⲉⲛⲟⲙⲟⲥ ϧⲉⲛ ⲛⲁⲙⲉⲗⲟⲥ ⲉϥϧⲏⲕ ⲟⲩⲃⲉ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲡⲁϩⲏⲧ ⲉϥⲉⲣⲉⲭⲙⲁⲗⲱⲧⲉⲩⲓⲛ ⳿ⲙⲙⲟⲓ ϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⲫⲏⲉⲧϣⲟⲡ ϧⲉⲛ ⲛⲁⲙⲉⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","⳿ⲡⲧⲁⲗⲉⲡⲱⲣⲟⲥ ⳿ⲁⲛⲟⲕ ⳿ⲫⲣⲱⲙⲓ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲛⲁϩⲙⲉⲧ ⳿ⲉⲃⲟⲗ ϩⲁ ⳿ⲡⲥⲱⲙⲁ ⳿ⲛⲧⲉ ⲡⲁⲓⲙⲟⲩ ⲫⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","⳿ⲡ⳿ϩⲙⲟⲧ ⲇⲉ ⳿ⲙⲫϯ ϣⲏⲡ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ϩⲁⲣⲁ ⲟⲩⲛ ⳿ⲁⲛⲟⲕ ϧⲉⲛ ⲡⲁϩⲏ ⲧ ⲙⲉⲛ ϯⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲫϯ ϧⲉⲛ ⲧⲁⲥⲁⲣⲝ ⲇⲉ ϯⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ");
INSERT INTO copcnt_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ϩⲁⲣⲁ ⲟⲩⲛ ϯⲛⲟⲩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛϩⲁⲡ ϭⲓ ⳿ⲉⲛⲏⲉⲧϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ⲡⲓⲛⲟⲙⲟⲥ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⳿ⲡⲱⲛϧ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲁϥⲁⲓⲧⲉⲛ ⳿ⲛⲣⲉⲙϩⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⲛⲉⲙ ⳿ⲫⲙⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ϯⲙⲉⲧⲁⲧϫⲟⲙ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ⲑⲏ⳿ⲉⲛⲁϥϣⲱⲛⲓ ⳿ⲛϧⲏⲧⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲥⲁⲣⲝ ⲁ ⲫϯ ⲧⲁⲟⲩ⳿ⲟ ⳿ⲙⲡⲉϥϣⲏⲣⲓ ϧⲉⲛ ⲟⲩ⳿ⲓⲛⲓ ⳿ⲛⲥⲁⲣⲝ ⳿ⲛⲧⲉ ⳿ⲫⲛⲟⲃⲓ ⲟⲩⲟϩ ⲉⲑⲃⲉ ⳿ⲫⲛⲟⲃⲓ ⲁϥϩⲓ ⳿ⲫⲛⲟⲃⲓ ⳿ⲉ⳿ⲡϩⲁⲡ ϧⲉⲛ ⳿ⲧⲥⲁⲣⲝ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓ⳿ⲑⲙⲁⲓⲟ ⳿ⲛⲧⲉ ⲡⲓⲛⲟⲙⲟⲥ ϫⲱⲕ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ϧⲁ ⲛⲏⲉⲧⲉ⳿ⲛⲥⲉⲙⲟϣⲓ ⲁⲛ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⲁⲗⲗⲁ ⲕⲁⲧⲁ ⲡ͞ⲛⲁ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ⲛⲏⲉⲧϣⲟⲡ ⲅⲁⲣ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⲛⲁ⳿ⲧⲥⲁⲣⲝ ⲡⲉⲧⲟⲩⲙⲉⲩⲓ ⳿ⲉⲣⲱⲟⲩ ⲛⲉⲧⲙⲟϣⲓ ⲇⲉ ⲕⲁⲧⲁ ⲡ͞ⲛⲁ̅ ⲛⲁ ⲡⲓⲡ͞ⲛⲁ̅ ⲡⲉⲧⲟⲩⲙⲉⲩⲓ ⳿ⲉⲣⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","⳿ⲫⲙⲉⲩⲓ ⲅⲁⲣ ⳿ⲛⲧⲉ ϯⲥⲁⲣⲝ ⳿ⲫⲙⲟⲩ ⲡⲉ ⳿ⲫⲙⲉⲩⲓ ⲇⲉ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲡⲱⲛϧ ⲡⲉ ⲛⲉⲙ ϯ ϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ϫⲉ ⳿ⲫⲙⲉⲩⲓ ⳿ⲛⲧⲉ ϯⲥⲁⲣⲝ ⲟⲩⲙⲉⲧϫⲁϫⲓ ⲡⲉ ⳿ⲉⲫϯ ⳿ⲙⲡⲁϥϭⲛⲉ ϫⲱϥ ⲅⲁⲣ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲇⲉ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ⲛⲏ ⲇⲉ ⲉⲧϧⲉⲛ ⳿ⲧⲥⲁⲣⲝ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲣⲁⲛⲁϥ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⲛⲁⲣⲉⲧⲉⲛⲭⲏ ϧⲉⲛ ⳿ⲧⲥⲁⲣⲝ ⲁⲛ ⲁⲗⲗⲁ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲓⲥϫⲉ ⲟⲩⲟⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲫϯ ϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲫⲏ ⲇⲉ ⲉⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⲁⲛ ⲫⲁⲓ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲫⲱϥ ⲁⲛ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ⲓⲥϫⲉ ⲇⲉ Ⲡⲭ̅ⲥ̅ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲡⲓⲥⲱⲙⲁ ⲙⲉⲛ ⳿ϥⲙⲱⲟⲩⲧ ⲉⲑⲃⲉ ⳿ⲫⲛⲟⲃⲓ ⲡⲓⲡ͞ⲛⲁ̅ ⲇⲉ ⲟⲩⲱⲛϧ ⲡⲉ ⲉⲑⲃⲉ ϯⲙⲉⲑⲙⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ⲓⲥϫⲉ ⲇⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲫⲏⲉⲧⲁϥⲧⲟⲩⲛⲟⲥ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⳿ϥϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲓⲉ ⲫⲏⲉⲧⲁϥⲧⲟⲩⲛⲟⲥ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲉϥ⳿ⲉⲧⲁⲛϧⲉ ⲛⲉⲧⲉⲛⲕⲉⲥⲱⲙⲁ ⲉⲧⲉϣⲁⲩⲙⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉϥⲡ͞ⲛⲁ̅ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ϩⲁⲣⲁ ⲟⲩⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟⲛ ⳿ⲉⲣⲟⲛ ϧⲉⲛ ⲥⲁⲣⲝ ⲁⲛ ⲉⲑⲣⲉⲛⲱⲛϧ ⲕⲁⲧⲁ ⲥⲁⲣⲝ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ⲓⲥϫⲉ ⲅⲁⲣ ⲉⲣⲉⲧⲉⲛⲟⲛϧ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⲧⲉⲧⲉⲛⲛⲁⲙⲟⲩ ⲓⲥϫⲉ ⲇⲉ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲛⲓ⳿ϩⲃⲏⲟⲩⲓ ⳿ⲛⲧⲉ ⲡⲓⲥⲱⲙⲁ ⲧⲉⲧⲉⲛϧⲱⲧⲉⲃ ⳿ⲙⲙⲱⲟⲩ ⲧⲉⲧⲉⲛⲛⲁⲱⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ⲛⲏ ⲅⲁⲣ ⲉⲑⲙⲟϣⲓ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲓ ⲛⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ⲛⲁⲣⲉⲧⲉⲛϭⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲛⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲟⲩⲙⲉⲧⲃⲱⲕ ⳿ⲉ⳿ϧⲣⲏⲓ ⲟⲛ ⲉⲩϩⲟϯ ⲁⲗⲗⲁ ⲁⲣⲉⲧⲉⲛϭ ⲓ ⳿ⲛⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲉ ⲟⲩⲙⲉⲧϣⲏⲣⲓ ⲫⲁⲓ ⲉⲧⲉⲛⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ ϫⲉ ⲁⲃⲃⲁ ⳿ⲫⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ⲟⲩⲟϩ ⳿ⲛⲑⲟϥ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ϥⲉⲣⲙⲉⲑⲣⲉ ⲛⲉⲙ ⲡⲉⲛⲡ͞ⲛⲁ̅ ϫⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ⲓⲥϫⲉ ⲇⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛϣⲏⲣⲓ ⲓⲉ ⳿ⲁⲛⲟⲛ ϩⲁⲛ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⲟⲛ ϩⲁⲛ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⲙⲉⲛ ⳿ⲛⲧⲉ ⲫϯ ϩⲁⲛ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲓⲥϫⲉ ⲧⲉⲛϭⲓ⳿ⲙⲕⲁϩ ⲛⲉⲙⲁϥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛ ϭⲓⲱⲟⲩ ⲛⲉⲙⲁϥ ⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ϯⲙⲉⲩⲓ ⲅⲁⲣ ϫⲉ ⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ⳿ⲛϫⲉ ⲛⲓ⳿ⲙⲕⲁⲩϩ ⳿ⲛⲧⲉ ⲡⲁⲓⲥⲏⲟⲩ ⳿ⲛⲧⲉ ϯⲛⲟⲩ ⳿ⲙⲡⲓⲱⲟⲩ ⲉⲑⲛⲁϭⲱⲣⲡ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","⳿ⲡϫⲓⲛⲥⲟⲙⲥ ⲅⲁⲣ ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲡⲓⲥⲱⲛⲧ ⲁϥⲥⲟⲙⲥ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ⲡⲓⲥⲱⲛⲧ ⲅⲁⲣ ⲁϥϭⲛⲉϫⲱϥ ⳿ⲛϯⲙⲉⲧⲉⲫⲗⲏⲟⲩ ⳿ⲛ⳿ϥⲟⲩⲱϣ ⲁⲛ ⲁⲗⲗⲁ ⲉⲑⲃⲉ ⲫⲏⲉⲧⲁϥ⳿ⲑⲣⲉϥϭⲛⲉϫⲱϥ ϧⲉⲛ ⲟⲩϩⲉⲗⲡⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ϫⲉ ⳿ⲛⲑⲟϥ ϩⲱϥ ⲡⲓⲥⲱⲛⲧ ⳿ϥⲛⲁⲉⲣⲣⲉⲙϩⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ϯⲙⲉⲧⲃⲱⲕ ⳿ⲛⲧⲉ ⳿ⲡⲧⲁⲕⲟ ⳿ⲉ⳿ϧⲣⲏⲓ ⳿ⲉ ϯⲙⲉⲧⲣⲉⲙϩⲉ ⳿ⲛⲧⲉ ⳿ⲡⲱⲟⲩ ⳿ⲛⲧⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ⲧⲉⲛⲥⲱⲟⲩⲛ ⲙⲉⲛ ⲅⲁⲣ ϫⲉ ⲡⲓⲥⲱⲛⲧ ⲧⲏⲣϥ ϥⲓ⳿ⲁϩⲟⲙ ⲛⲉⲙⲁⲛ ⲟⲩⲟϩ ⳿ϥϯⲛⲁⲕϩⲓ ⲛⲉⲙⲁⲛ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ⲟⲩ ⲙⲟⲛⲟⲛ ⲇⲉ ⲁⲗⲗⲁ ⲛⲉⲙ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲉϯⲁⲡⲁⲣⲭⲏ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲟⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ⲧⲉⲛϥⲓ⳿ⲁϩⲟⲙ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲛϯⲙⲉⲧϣⲏⲣⲓ ⲡⲓⲥⲱϯ ⳿ⲛⲧⲉ ⲡⲉⲛⲥⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ⲉⲧⲁⲛⲛⲟϩⲉⲙ ⲅⲁⲣ ϧⲉⲛ ⲟⲩϩⲉⲗⲡⲓⲥ ⲟⲩϩⲉⲗⲡⲓⲥ ⲇⲉ ⲉⲩⲛⲁⲩ ⳿ⲉⲣⲟⲥ ⳿ⲛⲟⲩϩⲉⲗⲡⲓⲥ ⲁⲛ ⲧⲉ ⲫⲏ ⲅⲁⲣ ⳿ⲉϣⲁⲣⲉ ⲟⲩⲁⲓ ⲛⲁⲩ ⳿ⲉⲣⲟϥ ϣⲁϥⲉⲣϩⲩⲡⲟⲙⲟⲛⲓⲛ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ⲓⲥϫⲉ ⲇⲉ ⲫⲏⲉⲧⲉⲛⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲁⲛ ⲧⲉⲛⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉⲣⲟϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩϩⲩⲡⲟⲙⲟⲛⲏ ⲧⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁϫⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲟⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲁϥϯⲧⲟⲧⲥ ⳿ⲛⲧⲉⲛⲙⲉⲧϫⲱⲃ ⲟⲩ ⲅⲁⲣ ⳿ⲛⲧⲱⲃϩ ⲉⲧⲉⲛⲛⲁⲁⲓϥ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϣⲉ ⳿ⲛⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲛⲑⲟϥ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ϥⲉⲣϩⲟⲩ⳿ⲟ ⲥⲉⲙⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ ϧⲉⲛ ϩⲁⲛϥⲓ⳿ⲁϩⲟⲙ ⳿ⲛⲁⲧⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ⲫⲏ ⲇⲉ ⲉⲧϧⲟⲧϧⲉⲧ ⳿ⲛⲛⲓϩⲏⲧ ⳿ϥⲥⲱⲟⲩⲛ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲫⲙⲉⲩⲓ ⳿ⲙⲡⲓⲡ͞ⲛⲁ̅ ϫⲉ ⲁϥⲥⲉⲙⲓ ⳿ⲉⲫϯ ⳿ⲉϫⲉⲛ ⲫⲏⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ⲧⲉⲛⲥⲱⲟⲩⲛ ⲇⲉ ϫⲉ ⲛⲏⲉⲧⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲙⲫϯ ϣⲁϥⲉⲣϩⲱⲃ ⲛⲉⲙⲱⲟⲩ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲛⲉⲩ ⲛⲏⲉⲧⲁϥⲑⲁϩⲙⲟⲩ ⲕⲁⲧⲁ ⲡⲉϥϣⲟⲣⲡ ⳿ⲛⲑⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ϫⲉ ⲛⲏⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲟⲩⲱⲛⲟⲩ ⲛⲁⲓ ⲟⲛ ⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲑⲁϣⲟⲩ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲥⲙⲟⲧ ⳿ⲛⲧⲉ ⳿ⲧϩⲓⲕⲱⲛ ⳿ⲙⲡⲉϥϣⲏⲣⲓ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⲉϥⲟⲓ ⳿ⲛϣⲟⲣⲡ ⳿ⲙⲙⲓⲥⲓ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ⲛⲏ ⲇⲉ ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲑⲁϣⲟⲩ ⲛⲁⲓ ⲟⲛ ⲛⲏⲉⲧⲁϥⲑⲁϩⲙⲟⲩ ⲟⲩⲟϩ ⲛⲏⲉⲧⲁϥⲑⲁϩⲙⲟⲩ ⲛⲁⲓ ⲟⲛ ⲁϥ⳿ⲑⲙⲁⲓⲱⲟⲩ ⲛⲏ ⲇⲉ ⲉⲧⲁϥ⳿ⲑⲙⲁⲓⲱⲟⲩ ⲛⲁⲓ ⲟⲛ ⲁϥϯⲱⲟⲩ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϫⲟϥ ⲟⲩⲃⲉ ⲛⲁⲓ ⲓⲥϫⲉ ⲫϯ ⲡⲉⲧϯ ⳿ⲉϫⲱⲛ ⲛⲓⲙ ⲉⲑⲛⲁϣϯ ⲟⲩⲃⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ⲫⲏⲉⲧⲉ⳿ⲙⲡⲉϥϯⲁⲥⲟ ⳿ⲉⲡⲉϥϣⲏⲣⲓ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ⲁϥⲧⲏⲓϥ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ ⲧⲏⲣⲉⲛ ⲡⲱⲥ ϫⲉ ⳿ⲛⲛⲉϥϯ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲛⲁⲛ ⳿ⲛ⳿ϩⲙⲟⲧ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲥⲉⲙⲓ ⳿ⲉⲛⲓⲥⲱⲧⲡ ⳿ⲛⲧⲉ ⲫϯ ⲫϯ ⲡⲉⲧ⳿ⲑⲙⲁⲓⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣϩⲓⲟⲩ⳿ⲓ ⳿ⲙ⳿ⲡϩⲁⲡ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲡⲉ ⲉⲧⲁϥⲙⲟⲩ ⲙⲁⲗⲗⲟⲛ ⲇⲉ ⲁϥⲧⲱⲛϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲫⲏⲉⲧⲭⲏ ⲥⲁⲟⲩ⳿ⲓⲛⲁⲙ ⳿ⲙⲫϯ ⳿ⲛⲑⲟϥ ⲉⲧⲥⲉⲙⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲫⲟⲣϫⲧⲉⲛ ⲥⲁⲃⲟⲗ ⳿ⲛϯ ⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲟⲩϩⲟϫϩⲉϫ ⲡⲉ ⲓⲉ ⲟⲩⲧⲁⲧϩⲟ ⲓⲉ ⲟⲩⲇⲓⲱⲅⲙⲟⲥ ⲓⲉ ⲟⲩ⳿ϩⲕⲟ ⲓⲉ ⲟⲩⲃⲱϣ ⲓⲉ ⲟⲩⲕⲩⲛⲇⲓⲛⲟⲥ ⲓⲉ ⲟⲩⲥⲏϥⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲉⲑⲃⲏⲧⲕ ⲥⲉϧⲱⲧⲉⲃ ⳿ⲙⲙⲟⲛ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲧⲏⲣϥ ⲁⲩⲟⲡⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲉ⳿ⲡϧⲟⲗϧⲉⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ⲁⲗⲗⲁ ϧⲉⲛ ⲛⲁⲓ ⲧⲏⲣⲟⲩ ⲧⲉⲛⲉⲣϩⲟⲩ⳿ⲟ ϭⲣⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫⲏⲉⲧⲁϥⲙⲉⲛⲣⲓⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","⳿ⲁⲛⲟⲕ ⲅⲁⲣ ⲡⲁϩⲏⲧ ⲑⲏⲧ ϫⲉ ⲟⲩⲇⲉ ⳿ⲫⲙⲟⲩ ⲟⲩⲇⲉ ⳿ⲡⲱⲛϧ ⲟⲩⲇⲉ ⲁⲅⲅⲉⲗⲟⲥ ⲟⲩⲇⲉ ⲁⲣⲭⲏ ⲟⲩⲇⲉ ⲛⲉⲧϣⲟⲡ ⲟⲩⲇⲉ ⲛⲉⲧⲛⲁϣⲱⲡⲓ ⲟⲩⲇⲉ ϫⲟⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ⲟⲩⲇⲉ ϭⲓⲥⲓ ⲟⲩⲇⲉ ϣⲱⲕ ⲟⲩⲇⲉ ⲕⲉⲥⲱⲛⲧ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲫⲟⲣϫⲧⲉⲛ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ ⲫϯ ⲑⲏ ⲉⲧϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲡⲉⲛ⳪ ");
INSERT INTO copcnt_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","⳿ⲑⲙⲏⲓ ⲡⲉϯϫⲱ ⳿ⲙⲙⲟⲥ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ⳿ⲛϯ ϫⲉⲙⲉⲑⲛⲟⲩϫ ⲁⲛ ⲉⲥⲉⲣⲙⲉⲑⲣⲉ ⳿ⲉⲣⲟⲓ ⲛⲉⲙⲏⲓ ⳿ⲛϫⲉ ⲧⲁⲥⲩⲛⲏⲇⲉⲥⲓⲥ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲛⲓϣϯ ⳿ⲛ⳿ⲙⲕⲁϩ ⳿ⲛϩⲏⲧ ⲛⲉⲙⲏ ⲓ ⲛⲉⲙ ⲟⲩϣⲉⲛϩⲏⲧ ⳿ⲙⲡⲁϥⲙⲟⲩⲛⲕ ϧⲉⲛ ⲡⲁϩⲏ ⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ⲛⲁⲓⲧⲱⲃϩ ⲅⲁⲣ ⳿ⲁⲛⲟⲕ ⳿ⲉⲉⲣ⳿ⲁⲛⲁⲑⲏⲙⲁ ⳿ⲉⲃⲟⲗ ϩⲁ Ⲡⲭ̅ⲥ̅ ⳿ⲉϫⲉⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲛⲁⲥⲩⲛⲅⲉⲛⲏⲥ ⲕⲁⲧⲁ ⲥⲁⲣⲝ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ⲉⲧⲉ ⳿ⲛ⳿ⲓⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⲛⲉ ⲛⲏⲉⲧⲉ ⲑⲱⲟⲩ ⲧⲉ ϯⲙⲉⲧϣⲏⲣⲓ ⲛⲉⲙ ⲡⲓⲱⲟⲩ ⲛⲉⲙ ⲛⲓⲇⲓ⳿ⲁⲑⲏⲕⲏ ⲛⲉⲙ ⲡⲓⲥⲉⲙⲛⲉ ⲛⲟⲙⲟⲥ ⲛⲉⲙ ⲡⲓϣⲉⲙϣⲓ ⲛⲉⲙ ⲛⲓⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ⲛⲏⲉⲧⲉ ⳿ⲛⲟⲩⲟⲩ ⲛⲉ ⲛⲓⲓⲟϯ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲟⲩ ⲟⲛ ⲁ Ⲡⲭ̅ⲥ̅ ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⲫⲏⲉⲧⲭⲏ ϩⲓϫⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲫϯ ⲉⲧ⳿ⲥⲙⲁⲣⲱⲟⲩⲧ ϣⲁ ⲉⲛⲉϩ ⲁⲙⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⳿ⲙⲡⲉ ⲡⲓⲥⲁϫⲓ ⳿ⲛⲧⲉ ⲫϯ ϩⲉⲓ ⳿ⲉⲃⲟⲗ ⲟⲩ ⲅⲁⲣ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲁⲛ ⲉⲧⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲓⲥ̅ⲗ̅ ⲛⲁⲓ ⲛⲉ ⳿ⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ⲟⲩⲇⲉ ϫⲉ ϩⲁⲛ⳿ϫⲣⲟϫ ⳿ⲛⲧⲉ ⲁⲃⲣⲁⲁⲙ ⲛⲉ ϩⲁⲛϣⲏⲣⲓ ⲧⲏⲣⲟⲩ ⲛⲉ ⲁⲗⲗⲁ ϧⲉⲛ ⳿ Ⲓⲥⲁⲁⲕ ⲉⲩ⳿ⲉⲑⲁϩⲉⲙ ⲟⲩ⳿ϫⲣⲟϫ ⲛⲁⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⳿ⲧⲥⲁⲣⲝ ⲁⲛ ⲛⲁⲓ ⲛⲉ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲫϯ ⲁⲗⲗⲁ ⲛⲓϣⲏⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲱϣ ⲉⲧⲟⲩⲛⲁⲟⲡⲟⲩ ⲉⲩ⳿ϫⲣⲟϫ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ⲡⲁⲓⲥⲁϫⲓ ⲅⲁⲣ ⲫⲁ ⲟⲩⲱϣ ⲡⲉ ϫⲉ ⲕⲁⲧⲁ ⲡⲁⲓⲥⲏⲟⲩ ⲫⲁⲓ ⲉⲓ⳿ⲉ⳿ⲓ ⲟⲩⲟϩ ⲉⲣⲉ ⲟⲩϣⲏⲣⲓ ϣⲱⲡⲓ ⳿ⲛⲥⲁⲣⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ⲟⲩ ⲙⲟⲛⲟⲛ ⲇⲉ ⲁⲗⲗⲁ ⲛⲉⲙ ⳿ⲧⲕⲉⲉⲣⲉⲃⲉⲕⲕⲁ ⳿ⲉⲁⲥϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩϣⲁ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲱⲧ ⳿ⲛⲧⲉ ⳿ Ⲓⲥⲁⲁⲕ ⲡⲉⲛⲓⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ⲉⲙⲡⲁⲛⲧⲟⲩⲙⲁⲥⲟⲩ ⲅⲁⲣ ⲟⲩⲇⲉ ⳿ⲙⲡⲁⲧⲟⲩ⳿ⲓⲣⲓ ⳿ⲛⲟⲩϩⲱⲃ ⳿ⲉⲛⲁⲛⲉϥ ⲓⲉ ⲉϥϩⲱⲟⲩ ϩⲓⲛⲁ ϯⲙⲉⲧⲥⲱⲧⲡ ⲉⲧⲁ ⲫϯ ⲑⲁϣⲥ ⲓⲥϫⲉⲛ ϣⲟⲣⲡ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ ⲉⲥ⳿ⲥⲙⲟⲛⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","⳿ⲉⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲁⲛ ⲧⲉ ⲁⲗⲗⲁ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲑⲱϩⲉⲙ ⲁⲩϫⲟⲥ ⲛⲁⲥ ϫⲉ ⲉⲣⲉ ⲡⲓⲛⲓϣϯ ⲉⲣⲃⲱⲕ ⳿ⲙⲡⲓⲕⲟⲩϫⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲓⲁⲕⲱⲃ ⲙⲉⲛ ⲁⲓⲙⲉⲛⲣⲓⲧϥ ⲏⲥⲁⲩ ⲇⲉ ⲁⲓⲙⲉⲥⲧⲱϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϫⲟϥ ⲙⲏ ⲟⲩⲟⲛ ⲟⲩⲙⲉⲧϭ ⲓ⳿ⲛϫⲟⲛⲥ ϧⲁⲧⲉⲛ ⲫϯ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","⳿ϥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⳿ⲙⲙⲱ⳿ⲩⲥⲏⲥ ϫⲉ ϯ ⲛⲁⲛⲁⲓ ⳿ⲙⲫⲏ ⳿ⲉϯⲛⲁⲛⲁⲓ ⲛⲁϥ ⲟⲩⲟϩ ϯⲛⲁϣⲉⲛϩⲏ ⲧ ϧⲁ ⲫⲏ ⳿ⲉϯⲛⲁϣⲉⲛϩⲏⲧ ϧⲁⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ϩⲁⲣⲁ ⲟⲩⲛ ⲫⲁ ⲡⲉⲑⲟⲩⲱϣ ⲁⲛ ⲡⲉ ⲟⲩⲇⲉ ⳿ⲙⲫⲁ ⲡⲉⲧϭⲟϫⲓ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ⲫⲁ ⲫϯ ⲉⲑⲛⲁⲓ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","⳿ⲥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ϯ⳿ⲅⲣⲁⲫⲏ ⳿ⲙⲫⲁⲣⲁⲱ ϫⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓⲧⲟⲩⲛⲟⲥⲕ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲟⲩⲱⲛϩ ⳿ⲛⲧⲁϫⲟⲙ ⳿ⲉⲃⲟⲗ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲕ ⲟⲩⲟϩ ⳿ⲛⲥⲉⲫ⳿ⲓⲣⲓ ⳿ⲉⲡⲁⲣⲁⲛ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ϩⲁⲣⲁ ⲟⲩⲛ ⲡⲉⲧⲉϥⲟⲩⲁϣϥ ϣⲁϥⲛⲁⲓ ⲛⲁϥ ⲫⲏ ⲇⲉ ⲉⲧⲁϥⲟⲩⲁϣϥ ⲁⲛ ϣⲁϥⲉⲑⲣⲉϥⲉⲛϣⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","⳿ⲭⲛⲁϫⲟⲥ ⲟⲩⲛ ⲛⲏⲓ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⳿ϥϫⲉⲙ ⲁⲣⲓⲕⲓ ⲛⲓⲙ ⲅⲁⲣ ⲉϥϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲉϥⲥⲟϭ ⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ⲙⲉⲛⲟⲩⲛⲅⲉ ⲱ ⳿ⲫⲣⲱⲙⲓ ⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⳿ⲛⲑⲟⲕ ⲫⲏⲉⲧⲉⲣⲟⲩⲱ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲫϯ ⲙⲏ ⳿ⲉⲣⲉϣ ⲡⲓⲙⲟⲛⲕ ϫⲟⲥ ⳿ⲙⲫⲏⲉⲧⲁϥⲙⲟⲛⲕϥ ϫⲉ ⲉⲑⲃⲉⲟⲩ ⲁⲕⲑⲁⲙⲓⲟⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ϣⲁⲛ ⳿ⲙⲙⲟⲛ ⳿ⲛⲧⲉ ⲡⲓⲕⲉⲣⲁⲙⲉⲩⲥ ⳿ⲙ⳿ⲡⲉⲣϣⲓϣⲓ ⳿ⲙⲡⲉϥ⳿ⲟⲙⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲟⲩⲱϣⲉⲙ ⲣⲱ ⳿ⲉⲑⲁⲙⲓⲟ ⳿ⲛⲟⲩ⳿ⲥⲕⲉⲩⲟⲥ ⲟⲩⲁⲓ ⲙⲉⲛ ⳿ⲉ⳿ⲡⲧⲁⲓⲟ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⲉⲩϣⲱϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ⲓⲥϫⲉ ⲇⲉ ⲁϥⲟⲩⲱϣ ⳿ⲛϫⲉ ⲫϯ ⲉϥⲟⲩⲱⲛϩ ⳿ⲙⲡⲉϥϫⲱⲛⲧ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⳿ⲉⲧⲁⲙⲟⲛ ⳿ⲉⲧⲉϥϫⲟⲙ ⲁϥ⳿ⲓⲛⲓ ϧⲉⲛ ⲟⲩⲛⲓϣϯ ⳿ⲙⲙⲉⲧⲣⲉϥⲱⲟⲩ ⳿ⲛϩⲏⲧ ⳿ⲛϩⲁⲛ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲛⲧⲉ ⳿ⲡϫⲱⲛⲧ ⲉⲩⲥⲉⲃⲧⲱⲧ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲟⲩⲱⲛϩ ⳿ⲛϯⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲧⲉ ⲡⲉϥⲱⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ϩⲁⲛ⳿ⲥⲕⲉⲩⲟⲥ ⳿ⲛⲛⲁⲓ ⲉⲧⲉ ⲛⲏ ⲛⲉ ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲉⲃⲧⲱⲧⲟⲩ ⲉⲩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ⲉⲧⲉ ⳿ⲁⲛⲟⲛ ⲡⲉ ϧⲁ ⲛⲏⲉⲧⲁϥⲑⲁϩⲙⲟⲩ ⲟⲩ ⲙⲟⲛⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲗⲗⲁ ⲛⲉⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲕⲉⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","⳿ⲙ⳿ⲫⲣⲏϯ ⲟⲛ ⳿ⲉⲧⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲛⲱⲥⲓⲉ ϫⲉ ϯⲛⲁⲙⲟⲩϯ ⳿ⲉⲫⲏⲉⲧⲉ ⲡⲁⲗⲁⲟⲥ ⲁⲛ ⲡⲉ ϫⲉ ⲡⲁⲗⲁⲟⲥ ⲟⲩⲟϩ ⲑⲏ ⲉⲧⲉ ⳿ⲙⲡⲟⲩⲙⲉⲛⲣⲓⲧⲥ ϫⲉ ⲁⲩⲙⲉⲛⲣⲓⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ⲟⲩⲟϩ ⲉⲥ⳿ⲉϣⲱⲡⲓ ϧⲉⲛ ⲡⲓⲙⲁ ⲉⲧⲁⲩϫⲟⲥ ⲛⲱⲟⲩ ⳿ⲙⲙⲟϥ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲡⲁⲗⲁⲟⲥ ⲁⲛ ⳿ⲙⲡⲓⲙⲁ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ ⲉⲩ⳿ⲉⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲉⲛϣⲏ ⲣⲓ ⳿ⲙⲫϯ ⲉⲧⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ⲏⲥⲁ⳿ⲏⲁⲥ ⲇⲉ ⲉϥⲱϣ ⳿ⲉⲃⲟⲗ ⳿ⲉϫⲉⲛ ⳿ⲡⲓⲥ̅ⲗ̅ ϫⲉ ⲉϣⲱⲡ ⲉⲣⲉ ⳿ⲧⲏⲡⲓ ⳿ⲛⲧⲉ ⲛⲉⲛϣⲏⲣⲓ ⳿ⲙ⳿ⲡⲓⲥ̅ⲗ̅ ⲉⲥⲟⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙⲡⲓϣⲱ ⳿ⲛⲧⲉ ⳿ⲫⲓⲟⲙ ⳿ⲡⲥⲱϫⲡ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ⲟⲩⲥⲁϫⲓ ⲅⲁⲣ ⲉϥϫⲱⲕ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⲟⲩⲟϩ ⲉϥϣⲱⲧ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⲫⲏⲉⲧⲉ Ⲡ⳪ ⲛⲁⲁⲓϥ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ⲟⲩⲟϩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲟⲛ ⲉⲧⲁϥϫⲟⲥ ⳿ⲛϫⲉ ⲏⲥⲁ⳿ⲏⲁⲥ ϫⲉ ⲉⲛⲉ⳿ⲙⲡⲉ Ⲡ⳪ ⲥⲁⲃⲁⲱⲑ ⲥⲱϫⲡ ⳿ⲛⲟⲩ⳿ϫⲣⲟϫ ⲛⲁⲛ ⲛⲁⲛⲛⲁⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲥⲟⲇⲟⲙⲁ ⲡⲉ ⲟⲩⲟϩ ⲛⲁⲛⲛⲁ⳿ⲓⲛⲓ ⳿ⲛⲅⲟⲙⲟⲣⲣⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲛⲛⲁϫⲟϥ ϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲧⲉ ⳿ⲙⲡⲟⲩϭⲟϫⲓ ⳿ⲛⲥⲁ ϯⲙⲉⲑⲙⲏⲓ ⲁⲩⲧⲁϩⲉ ϯⲙⲉⲑⲙⲏ ⲓ ϯⲙⲉⲑⲙⲏⲓ ⲇⲉ ϯ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","⳿ⲡⲓⲥ̅ⲗ̅ ⲇⲉ ⲉϥϭⲟϫⲓ ⳿ⲛⲥⲁ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ϯⲙⲉⲑⲙⲏⲓ ⳿ⲙⲡⲉϥⲫⲟϩ ⳿ⲉⲡⲓⲛⲟⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ⲉⲑⲃⲉⲟⲩ ϫⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⲁⲛ ⲡⲉ ⲁⲗⲗⲁ ϩⲱⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿Ⲓ ⲁⲩϭⲓϭⲣⲟⲡ ⳿ⲉⲡⲓⲱⲛⲓ ⳿ⲛϭⲣⲟⲡ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ϫⲉ ϩⲏⲡⲡⲉ ϯⲛⲁⲭⲱ ϧⲉⲛ ⲥⲓⲱⲛ ⳿ⲛⲟⲩⲱⲛⲓ ⳿ⲛϭⲣⲟⲡ ⲛⲉⲙ ⲟⲩⲡⲉⲧⲣⲁ ⳿ⲛ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲟⲩⲟϩ ⲫⲏⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲛⲉϥϭⲓϣⲓⲡⲓ ");
INSERT INTO copcnt_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲡϯⲙⲁϯ ⳿ⲛⲧⲉ ⲡⲁϩⲏⲧ ⲛⲉⲙ ⲡⲁⲧⲱⲃϩ ⳿ⲉϯⲣⲁ ⳿ⲙⲙⲟϥ ϩⲁ ⲫϯ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲟⲩ ⲉⲩⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ϯⲉⲣⲙⲉⲑⲣⲉ ⲅⲁⲣ ⲛⲱⲟⲩ ϫⲉ ⲟⲩⲭⲟϩ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧⲟⲩ ⲁⲗⲗⲁ ⲕⲁⲧⲁ ⲟⲩ⳿ⲉⲙⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ⲉⲩⲟⲃϣ ⲅⲁⲣ ⳿ⲉϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⲉⲩⲕⲱϯ ⳿ⲛⲥⲁ ⲥⲉⲙⲛⲉ ⲑⲱⲟⲩ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲟⲩϭⲛⲉϫⲱⲟⲩ ⳿ⲉϯⲙⲉⲑⲙⲏⲓ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","⳿ⲡϫⲱⲕ ⲅⲁⲣ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ Ⲡⲭ̅ⲥ̅ ⲡⲉ ⲉⲩⲙⲉⲑⲙⲏ ⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ⲙⲱ⳿ⲩⲥⲏⲥ ⲅⲁⲣ ⲁϥ⳿ⲥϧⲁⲓ ϫⲉ ϯⲙⲉⲑⲙⲏⲓ ϯ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲫⲣⲱⲙⲓ ⲉⲑⲛⲁⲁⲓⲥ ⲉϥ⳿ⲉⲱⲛϧ ⳿ⲛϧⲏⲧⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ϯⲙⲉⲑⲙⲏⲓ ⲇⲉ ϯ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲙⲡⲉⲣϫⲟⲥ ϧⲉⲛ ⲡⲉⲕϩⲏ ⲧ ϫⲉ ⲛⲓⲙ ⲉⲩⲛⲁ⳿ϣϣⲉ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉ⳿ⲧⲫⲉ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⳿ⲛⲧⲉϥ⳿ⲓⲛⲓ ⳿ⲙⲠⲭ̅ⲥ̅ ⳿ⲉⲡⲉⲥⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ⲓⲉ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣϣⲉ ⳿ⲉⲡⲉⲥⲏⲧ ⳿ⲉ⳿ⲫⲛⲟⲩⲛ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ϫⲉ ⳿ⲛⲧⲉϥ⳿ⲓⲛⲓ ⳿ⲙⲠⲭ̅ⲥ̅ ⳿ⲉ⳿ⲡϣⲱⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ⲁⲗⲗⲁ ⲟⲩ ⲡⲉⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱ ⳿ⲙⲙⲟϥ ⳿ϥϧⲉⲛⲧ ⳿ⲉⲣⲟⲕ ⳿ⲛϫⲉ ⲡⲓⲥⲁϫⲓ ⳿ϥⲭⲏ ϧⲉⲛ ⲣⲱⲕ ⲟⲩⲟϩ ⳿ϥⲭⲏ ϧⲉⲛ ⲡⲉⲕϩⲏⲧ ⲉⲧⲉ ⲫⲁⲓ ⲡⲉ ⳿ⲡⲥⲁϫⲓ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ⲉⲧⲉⲛϩⲓⲱⲓϣ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ϫⲉ ⲉϣⲱⲡ ⲁⲕϣⲁⲛⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲣⲱⲕ ϫⲉ Ⲡ⳪ ⲡⲉ Ⲓⲏ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲕⲛⲁϩϯ ϧⲉⲛ ⲡⲉⲕϩⲏⲧ ϫⲉ ⲁ ⲫϯ ⲧⲟⲩⲛⲟⲥϥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲉⲕ⳿ⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ϧⲉⲛ ⲡⲓϩⲏⲧ ⲅⲁⲣ ⲥⲉⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲉⲩⲙⲉⲑⲙⲏⲓ ϧⲉⲛ ⲣⲱⲟⲩ ⲇⲉ ⲥⲉⲟⲩⲱⲛϩ ⳿ⲙⲙⲟϥ ⳿ⲉⲃⲟⲗ ⲉⲩⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","⳿ⲥϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⳿ⲛϫⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⳿ⲛⲛⲉϥϭⲓϣⲓⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","⳿ⲙⲙⲟⲛ ⲫⲱⲣϫ ⲅⲁⲣ ϣⲟⲡ ⳿ⲙⲡⲓⲓⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲡⲓⲟⲩⲉⲓⲛⲓⲛ ⲡⲁⲓ⳪ ⲅⲁⲣ ⲡⲉ ⳿ⲛⲧⲉ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉϥⲟⲓ ⳿ⲛⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧⲱϣ ⳿ⲉ⳿ϩⲣⲏⲓ ⲟⲩⲃⲏϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲛⲁⲧⲱⲃϩ ⳿ⲙ⳿ⲫⲣⲁⲛ ⳿ⲙⲠ⳪ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ⲡⲱⲥ ⲟⲩⲛ ⲥⲉⲛⲁⲧⲱⲃϩ ⳿ⲙⲫⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲛⲁϩϯ ⳿ⲉⲣⲟϥ ⲡⲱⲥ ⲇⲉ ⲥⲉⲛⲁⲛⲁϩϯ ⳿ⲙⲫⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲥⲟⲑⲙⲉϥ ⲡⲱⲥ ⲇⲉ ⲥⲉⲛⲁⲥⲱⲧⲉⲙ ⲁⲧϭⲛⲉ ⲫⲏⲉⲧϩⲓⲱⲓϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ⲡⲱⲥ ⲇⲉ ⲥⲉⲛⲁϩⲓⲱⲓϣ ⲁⲩ⳿ϣⲧⲉⲙⲟⲩⲟⲣⲡⲟⲩ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ϩⲱⲥ ⲉⲛⲉⲥⲉ ⲛⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲛⲏⲉⲧϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲛⲓⲡⲉⲑⲛⲁⲛⲉⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ⲁⲗⲗⲁ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ ⲧⲏⲣⲟⲩ ⳿ⲛⲥⲁ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲏⲥⲁ⳿ⲏⲁⲥ ⲅⲁⲣ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡ⳪ ⲛⲓⲙ ⲡⲉⲧⲁϥⲛⲁϩϯ ⳿ⲉⲧⲉⲛ⳿ⲥⲙⲏ ⲟⲩⲟϩ ⳿ⲡϣⲱⲃϣ ⳿ⲙⲠ⳪ ⲉⲧⲁϥϭⲱⲣⲡ ⳿ⲉⲛⲓⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ϩⲁⲣⲁ ⳿ⲫⲛⲁϩϯ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲥⲱⲧⲉⲙ ⲡⲉ ⳿ⲡⲥⲱⲧⲉⲙ ⲇⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲡⲥⲁϫⲓ ⳿ⲙⲠⲭ̅ⲥ̅ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ⲁⲗⲗⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ ⲙⲉⲛ ⲟⲩⲛ ⲅⲉ ⲁ ⲡⲟⲩ⳿ϧⲣⲱⲟⲩ ϣⲉ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓϫⲉⲛ ⳿ⲡⲕⲁϩⲓ ⲧⲏⲣϥ ⲟⲩⲟϩ ⲛⲟⲩⲥⲁϫⲓ ⲁⲩⲫⲟϩ ϣⲁ ⲁⲩⲣⲏϫⲥ ⳿ⲛϯⲟⲓⲕⲟⲩⲙⲉⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ⲁⲗⲗⲁ ϯϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲏ ⳿ⲙⲡⲉ ⳿ⲡⲓⲥ̅ⲗ̅ ⳿ⲙⲡⲉϥ⳿ⲉⲙⲓ ⳿ⲛϣⲟⲣⲡ ⲙⲱ⳿ⲩⲥⲏⲥ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲉⲓ⳿ⲉϯⲭⲟϩ ⲛⲱⲧⲉⲛ ⳿ⲉϫⲉⲛ ⲡⲉⲧⲉ ⳿ⲛⲟⲩⲉⲑⲛⲟⲥ ⲁⲛ ⲡⲉ ⳿ⲉϫⲉⲛ ⲟⲩⲉⲑⲛⲟⲥ ⳿ⲛⲁⲧⲕⲁϯ ⲉⲓ⳿ⲉ⳿ⲑⲣⲉⲧⲉⲛϫⲱⲛⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ⲏⲥⲁ⳿ⲏⲁⲥ ⲇⲉ ⲁϥⲉⲣⲧⲟⲗⲙⲁⲛ ⲟⲩⲟϩ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲩϫⲉⲙⲧ ⳿ⲛⲛⲏⲉⲧⲉ⳿ⲛⲥⲉⲕⲱϯ ⳿ⲛⲥⲱⲓ ⲁⲛ ⲁⲓⲟⲩⲟⲛϩⲧ ⳿ⲉⲛⲏ ⳿ⲉⲧⲉ⳿ⲛⲥⲉϣⲓⲛⲓ ⳿ⲙⲙⲟⲓ ⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","⳿ϥϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲉ ⳿ⲡⲓⲥ̅ⲗ̅ ϫⲉ ⲁⲓⲫⲱⲣϣ ⳿ⲛⲛⲁϫⲓϫ ⳿ⲉⲃⲟⲗ ⳿ⲙⲡⲓ⳿ⲉϩⲟⲟⲩ ⲧⲏⲣϥ ⲟⲩⲃⲉ ⲟⲩⲗⲁⲟⲥ ⳿ⲛⲁⲧⲥⲱⲧⲉⲙ ⲟⲩⲟϩ ⳿ϥⲉⲣⲁⲛⲧⲓⲗⲉⲅⲓⲛ ");
INSERT INTO copcnt_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ϯϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲙⲏ ⲁ ⲫϯ ⲭⲁ ⲡⲉϥⲗⲁⲟⲥ ⳿ⲛⲥⲱϥ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲕⲉⲅⲁⲣ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲁⲛⲟⲕ ⲟⲩ⳿ⲏⲥⲣⲁⲏⲗⲓⲧⲏⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡ⳿ϫⲣⲟϫ ⳿ⲛⲁⲃⲣⲁⲁⲙ ⳿ⲧⲫⲩⲗⲏ ⳿ⲙⲃⲉⲛⲓ⳿ⲁⲙⲓⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","⳿ⲙⲡⲉ ⲫϯ ⲭⲁ ⲡⲉϥⲗⲁⲟⲥ ⳿ⲛⲥⲱϥ ⲫⲏⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲥⲟⲩⲱⲛϥ ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩ ⲡⲉⲧⲉ ϯ⳿ⲅⲣⲁⲫⲏ ϫⲱ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲏⲗⲓⲁⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁϥⲥⲉⲙⲓ ⳿ⲙⲫϯ ⳿ⲉ⳿ⲡⲓⲥ̅ⲗ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ϫⲉ Ⲡ⳪ ⲛⲉⲕ⳿ⲡⲣⲟⲫⲏⲧⲏⲥ ⲁⲩϧⲟⲑⲃⲟⲩ ⲛⲉⲕⲙⲁ⳿ⲛⲉⲣϣⲟⲩϣⲱⲟⲩϣⲓ ⲁⲩⲟⲩⲟϫⲡⲟⲩ ⳿ⲁⲛⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲓⲥⲱϫⲡ ⲟⲩⲟϩ ⲥⲉⲕⲱϯ ⳿ⲛⲥⲁ ⲧⲁ ⲯⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ⲁⲗⲗⲁ ⲟⲩ ⲡⲉⲧⲉ ⲡⲓ⳿ⲭⲣⲏⲙⲁⲧⲓⲥⲙⲟⲥ ϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲁϥ ⲁⲓⲥⲱϫⲡ ⲛⲏⲓ ⳿ⲛⲍ̅ ⳿ⲛϣⲟ ⳿ⲛⲣⲱⲙⲓ ⲛⲁⲓ ⲉⲧⲉ ⳿ⲙⲡⲟⲩⲕⲉⲗϫ ⲕⲉⲗⲓ ⳿ⲛϯⲃⲁⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ⲡⲁⲓⲣⲏϯ ⲟⲛ ϧⲉⲛ ⲡⲁⲓⲥⲏⲟⲩ ⳿ⲛⲧⲉ ϯ ⲛⲟⲩ ⲟⲩⲗⲩⲙⲙⲁ ⲕⲁⲧⲁ ⲟⲩⲙⲉⲧⲥⲱⲧⲡ ⳿ⲛⲟⲩ⳿ϩⲙⲟⲧ ⲁϥϣⲱⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ⲓⲥϫⲉ ⲇⲉ ϧⲉⲛ ⲟⲩ⳿ϩⲙⲟⲧ ⲓⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⲁⲛ ⲡⲉ ⳿ⲙⲙⲟⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ϥⲛⲁⲉⲣ⳿ϩⲙⲟⲧ ⲁⲛ ϫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ⲟⲩ ϫⲉ ⲫⲏ ⲡⲉⲧⲉ ⳿ⲡⲓⲥ̅ⲗ̅ ⲕⲱϯ ⳿ⲛⲥⲱϥ ⲫⲁⲓ ⳿ⲙⲡⲉϥϣⲁϣⲛⲓ ⳿ⲉⲣⲟϥ ϯⲙⲉⲧⲥⲱⲧⲡ ⲇⲉ ⲁⲥϯⲙⲁϯ ⳿ⲡⲥⲉⲡⲓ ⲇⲉ ⲁⲩⲑⲱⲙ ⳿ⲛϩⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲁ ⲫϯ ϯ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲡ͞ⲛⲁ̅ ⳿ⲛⲧⲱⲙⲧ ⲛⲉⲙ ϩⲁⲛⲃⲁⲗ ⳿ⲉ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲛⲉⲙ ϩⲁⲛⲙⲁϣϫ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲱⲧⲉⲙ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲫⲟⲟⲩ ⳿ⲛ⳿ⲉϩⲟⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ⲟⲩⲟϩ ⲇⲁⲩⲓⲇ ϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲙⲁⲣⲉ ⲧⲟⲩ⳿ⲧⲣⲁⲡⲉⲍⲁ ϣⲱⲡⲓ ⲛⲱⲟⲩ ⳿ⲛⲟⲩⲫⲁϣ ⲛⲉⲙ ⲟⲩϫⲟⲣϫⲥ ⲛⲉⲙ ⲟⲩ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲛⲉⲙ ⲟⲩϯ ϣⲉⲃⲓⲱ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ⲛⲟⲩⲃⲁⲗ ⲙⲁⲣⲟⲩⲉⲣ⳿ⲭⲣⲉⲙⲧⲥ ⳿ⲉ⳿ϣⲧⲉⲙⲛⲁⲩ ⳿ⲙⲃⲟⲗ ⲧⲟⲩϭⲓⲥⲓ ⲙⲁⲣⲉⲥⲕⲱⲗϫ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ϯϫⲱ ⲟⲩⲛ ⳿ⲙⲙⲟⲥ ⲙⲏ ⲁⲩ⳿ⲥⲗⲁϯ ϩⲓⲛⲁ ⳿ⲛⲥⲉϩⲉⲓ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ ⲁⲗⲗⲁ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲡⲟⲩⲡⲁⲣⲁⲡⲧⲱⲙⲁ ⲁ ⳿ⲡⲟⲩϫⲁⲓ ϣⲱⲡⲓ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ϫⲉ ⳿ⲛⲥⲉϯⲭⲟϩ ⲛⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ⲓⲥϫⲉ ⲡⲟⲩⲡⲁⲣⲁⲡⲧⲱⲙⲁ ⲁϥⲉⲣ ⲟⲩⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ⲡⲟⲩϭⲣⲟϩ ⲁϥⲉⲣ ⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⲓⲉ ⲁⲩⲏⲣ ⲡⲉ ⲡⲟⲩϫⲱⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ϧⲁ ⲛⲓⲉⲑⲛⲟⲥ ⳿ⲉⲫⲟⲥⲟⲛ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲁⲛⲟⲕ ϯⲟⲓ ⳿ⲛ⳿ⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ϯϯⲱⲟⲩ ⳿ⲛⲧⲁⲇⲓ⳿ⲁⲕⲟⲛⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ϫⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲁϯⲭⲟϩ ⳿ⲛⲧⲁⲥⲁⲣⲝ ⲟⲩⲟϩ ⳿ⲛⲧⲁⲛⲟϩⲉⲙ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ⲓⲥϫⲉ ⲅⲁⲣ ⲁ ⲡⲟⲩϩⲓⲟⲩ⳿ⲓ ⳿ⲉⲃⲟⲗ ⲁϥⲉⲣ ⲟⲩϩⲱⲧⲡ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲓⲉ ⲁϣ ⲡⲉ ⲡⲟⲩ⳿ⲓⲛⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲃⲏⲗ ⳿ⲉ⳿ⲡⲱⲛϧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲑⲙⲱⲟⲩⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ⲓⲥϫⲉ ⲇⲉ ϯⲁⲡⲁⲣⲭⲏ ⲟⲩⲁⲃ ⲓⲉ ⳿ϥⲟⲩⲁⲃ ⲟⲛ ⳿ⲛϫⲉ ⲡⲓⲕⲉⲟⲩⲱϣⲉⲙ ⲟⲩⲟϩ ⲓⲥϫⲉ ϯ ⲛⲟⲩⲛⲓ ⲟⲩⲁⲃ ⲓⲉ ⳿ⲥⲟⲩⲁⲃ ⲟⲛ ⳿ⲛϫⲉ ⲛⲓⲕⲉϫⲁⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ⲓⲥϫⲉ ⲇⲉ ⲁ ϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓϫⲁⲗ ⲁⲩⲕⲱⲣϫ ⳿ⲛⲑⲟⲕ ⲇⲉ ⳿ⲛⲑⲟⲕ ⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯⲃⲱ ⳿ⲛϫⲱⲓⲧ ⳿ⲛϣⲁϣⲓ ⲁⲩⲉⲣⲕⲓⲛ⳿ⲇⲣⲓⲍⲓⲛ ⳿ⲙⲙⲟⲕ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲟⲩ ⲟⲩⲟϩ ⲁⲕⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲓⲕⲉⲛⲓ ⳿ⲛⲧⲉ ⳿ⲑⲛⲟⲩⲛⲓ ⳿ⲛϯⲃⲱ ⳿ⲛϫⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","⳿ⲙⲡⲉⲣϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲕ ⳿ⲉϫⲉⲛ ⲛⲓϫⲁⲗ ⲓⲥϫⲉ ⲇⲉ ⳿ⲛⲑⲟⲕ ⳿ⲕϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲕ ⳿ⲛⲑⲟⲕ ⲁⲛ ⲉⲧϥⲁⲓ ϧⲁ ϯⲛⲟⲩⲛⲓ ⲁⲗⲗⲁ ϯⲛⲟⲩⲛⲓ ⲉⲧⲧⲱⲟⲩⲛ ϧⲁⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","⳿ⲭⲛⲁϫⲟⲥ ⲟⲩⲛ ϫⲉ ϩⲁⲛⲟⲩⲟⲛ ⲕⲱⲣϫ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓϫⲁⲗ ϩⲓⲛⲁ ⳿ⲁⲛⲟⲕ ⳿ⲛⲧⲟⲩⲉⲣⲕⲩⲛ⳿ⲇⲣⲓⲍⲓⲛ ⳿ⲙⲙⲟⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ⲕⲁⲗⲱⲥ ⲁⲩⲕⲱⲣϫ ϧⲉⲛ ⲧⲟⲩⲙⲉⲧⲁⲑⲛⲁϩϯ ⳿ⲛⲑⲟⲕ ⲇⲉ ⳿ⲕⲟϩⲓ ⳿ⲉⲣⲁⲧⲕ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ⳿ⲙⲡⲉⲣϭⲓⲥⲓ ⳿ⲛϩⲏⲧ ⲁⲗⲗⲁ ⲁⲣⲓϩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ⲓⲥϫⲉ ⲅⲁⲣ ⳿ⲙⲡⲉ ⲫϯ ϯⲁⲥⲟ ⳿ⲉϫⲉⲛ ⲛⲓⲕⲁⲧⲁⲫⲩⲥⲓⲥ ⳿ⲛϫⲁⲗ ⲟⲩⲇⲉ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⳿ⲛⲛⲉϥϯⲁⲥⲟ ⳿ⲉⲣⲟⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","⳿ⲁⲛⲁⲩ ⲟⲩⲛ ⳿ⲉϯⲙⲉⲧⲭ̅ⲥ̅ ⲛⲉⲙ ϯⲙⲉⲧⲣⲉϥϣⲱⲧ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉϫⲉⲛ ⲛⲏ ⲙⲉⲛ ⲉⲧⲁⲩϩⲉⲓ ⲟⲩϣⲱⲧ ⳿ⲉⲃⲟⲗ ⳿ⲉ⳿ϩⲣⲏⲓ ⲇⲉ ⳿ⲉϫⲱⲕ ⲟⲩⲙⲉⲧⲭ͞ⲣⲥ̅ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲕϣⲁⲛⲟϩⲓ ϧⲉⲛ ϯⲙⲉⲧⲭ͞ⲣⲥ̅ ⳿ⲙⲙⲟⲛ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⲥⲉⲛⲁⲕⲟⲣϫⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ⲟⲩⲟϩ ⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲁⲩ⳿ϣⲧⲉⲙⲟϩⲓ ϧⲉⲛ ϯⲙⲉⲧⲁⲑⲛⲁϩϯ ⲥⲉⲛⲁⲉⲣⲕⲩⲛ⳿ⲇⲣⲓⲍⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲕⲉⲥⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ⲓⲥϫⲉ ⳿ⲛⲑⲟⲕ ⲁⲩⲕⲟⲣϫⲕ ⳿ⲉⲃⲟⲗ ϩⲁ ϯ ⲕⲁⲧⲁⲫⲩⲥⲓⲥ ⳿ⲙⲃⲱ ⳿ⲛϫⲱⲓⲧ ⳿ⲛϣⲁϣⲓ ⲟⲩⲟϩ ⲁⲩⲉⲣⲕⲩⲛ⳿ⲇⲣⲓⲍⲓⲛ ⳿ⲙⲙⲟⲕ ⲡⲁⲣⲁ ⲧⲉⲕⲫⲩⲥⲓⲥ ⳿ⲉ ϯⲃⲱ ⳿ⲛϫⲱⲓⲧ ⳿ⲛⲛⲟⲩⲧⲉⲙ ⲡⲱⲥⲟ ⲙⲁⲗⲗⲟⲛ ⲛⲁⲓ ⲉⲩⲛⲁⲉⲣⲕⲩⲛ⳿ⲇⲣⲓⲍⲓⲛ ⳿ⲙⲙⲱⲟⲩ ⲕⲁⲧⲁ ⲧⲟⲩⲫⲩⲥⲓⲥ ⳿ⲉⲧⲟⲩⲃⲱ ⳿ⲛϫⲱⲓⲧ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","⳿ⲛϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⲁⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧ⳿ⲉⲙⲓ ⳿ⲉⲡⲁⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲥⲁⲃⲉ ⲛⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⲟⲩⲑⲱⲙ ⳿ⲛϩⲏⲧ ⲁϥϣⲱⲡⲓ ⳿ⲙ⳿ⲡⲓⲥ̅ⲗ̅ ϧⲉⲛ ⲟⲩ⳿ⲁⲡⲟⲙⲉⲣⲟⲥ ϣⲁⲧⲉ ⳿ⲡϫⲱⲕ ⳿ⲛⲛⲓⲉⲑⲛⲟⲥ ⳿ⲓ ⳿ⲉϧⲟⲩⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ⲟⲩⲟϩ ⲡⲁⲓⲣⲏϯ ⳿ⲡⲓⲥ̅ⲗ̅ ⲧⲏⲣϥ ⲉϥ⳿ⲉⲛⲟϩⲉⲙ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲉϥ⳿ⲉ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲥⲓⲱⲛ ⳿ⲛϫⲉ ⲫⲏⲉⲑⲛⲁⲛⲟϩⲉⲙ ⲉϥ⳿ⲉⲧⲁⲥⲑⲟ ⳿ⲛⲛⲓⲙⲉⲧⲁⲥⲉⲃⲏⲥ ⳿ⲉⲃⲟⲗ ϩⲁ ⲓⲁⲕⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ⲟⲩⲟϩ ⲑⲁⲓ ⲧⲉ ⲧⲁⲇⲓ⳿ⲁⲑⲏⲕⲏ ⲉⲑⲛⲁϣⲱⲡⲓ ⲛⲱⲟⲩ ϩⲟⲧⲁⲛ ⲁⲓϣⲁⲛⲱⲗⲓ ⳿ⲛⲛⲟⲩⲛⲟⲃⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ⲕⲁⲧⲁ ⲙⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ϩⲁⲛϫⲁϫⲓ ⲛⲉ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ⲕⲁⲧⲁ ϯⲙⲉⲧⲥⲱⲧⲡ ⲇⲉ ϩⲁⲛⲙⲉⲛⲣⲁϯ ⲛⲉ ⲉⲑⲃⲉ ⲛⲟⲩⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ϩⲁⲛⲁⲑⲟⲩⲱⲙ ⳿ⲛ⳿ϩⲑⲏⲟⲩ ⲅⲁⲣ ⲛⲉ ⲛⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ ⲛⲉⲙ ⲡⲓⲑⲱϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧⲁⲣⲉⲧⲉⲛⲉⲣⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲫϯ ⳿ⲛⲟⲩⲥⲏⲟⲩ ϯⲛⲟⲩ ⲇⲉ ⲁⲩⲛⲁⲓ ⲛⲱⲧⲉⲛ ϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⲛⲁⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ⲡⲁⲓⲣⲏϯ ⲛⲁⲓ ϩⲱⲟⲩ ϯⲛⲟⲩ ⲁⲩⲉⲣⲁⲧⲥⲱⲧⲉⲙ ⳿ⲛⲥⲁ ⲡⲉⲧⲉⲛⲛⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲛⲁ⳿ⲓ ⲛⲱⲟⲩ ϩⲱⲟⲩ ϯⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ⲁ ⲫϯ ⲅⲁⲣ ⲙⲁ⳿ϣⲑⲁⲙ ⳿ⲉ⳿ϩⲣⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲉϧⲟⲩⲛ ϧⲁ ⲟⲩⲙⲉⲧⲁⲧⲥⲱⲧⲉⲙ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲛⲁⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ⲱ ⳿ⲡϣⲱⲕ ⳿ⲛϯⲙⲉⲧⲣⲁⲙⲁ⳿ⲟ ⲛⲉⲙ ϯ ⲥⲟⲫⲓ⳿ⲁ ⲛⲉⲙ ⲡⲓ⳿ⲉⲙⲓ ⳿ⲛⲧⲉ ⲫϯ ϩⲱⲥ ϩⲁⲛⲁⲧϧⲉⲧϧⲱⲧⲟⲩ ⲛⲉ ⲛⲉϥϩⲁⲡ ⲟⲩⲟϩ ϩⲁⲛⲁⲧ ϭⲓⲧⲁⲧⲥⲓ ⳿ⲛⲥⲱⲟⲩ ⲛⲉ ⲛⲉϥⲙⲱⲓⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ⲛⲓⲙ ⲅⲁⲣ ⲡⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲉ⳿ⲡϩⲏⲧ ⳿ⲙⲠ⳪ ⲓⲉ ⲛⲓⲙ ⲁϥⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛⲥⲟϭⲛⲓ ⲛⲉⲙⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ⲓⲉ ⲛⲓⲙ ⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛϯ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥϯ ⲛⲁϥ ⳿ⲛⲧⲟⲩϣⲉⲃⲓⲱ. ");
INSERT INTO copcnt_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ϫⲉ ϩⲁⲛ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟϥ ⲛⲉ ⲟⲩⲟϩ ϩⲁⲛ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲛⲉ ⲟⲩⲟϩ ϩⲁⲛ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲧⲏⲣⲟⲩ ⲛⲉ ⲫⲱϥ ⲡⲉ ⲡⲓⲱⲟⲩ ϣⲁ ⲉⲛⲉϩ ⲁⲙⲏⲛ ");
INSERT INTO copcnt_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ϯϯϩⲟ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲛⲓⲙⲉⲧϣⲉⲛϩⲏⲧ ⳿ⲛⲧⲉ ⲫϯ ⲉⲑⲣⲉⲧⲉⲛⲧⲁϩⲉ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ ⳿ⲉⲣⲁⲧⲟⲩ ⳿ⲛⲟⲩϣⲟⲩϣⲱⲟⲩϣⲓ ⲉϥⲟⲛϧ ⲉϥⲟⲩⲁⲃ ⲉϥⲣⲁⲛⲁϥ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⲡⲉⲧⲉⲛϣⲉⲙϣⲓ ⳿ⲛⲗⲟⲅⲓⲕⲟⲛ ⲉϥⲣⲁⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣⲧⲉⲙⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛ⳿ⲥⲭⲏⲙⲁ ϫⲉ ⲛⲉⲙ ⲡⲁⲓⲉⲛⲉϩ ⲁⲗⲗⲁ ⳿ⲛⲧⲉⲧⲉⲛϣⲉⲃⲧ ⲡⲉⲧⲉⲛ⳿ⲥⲙⲟⲧ ϧⲉⲛ ⲟⲩⲙⲉⲧⲃⲉⲣⲓ ⳿ⲛⲧⲉ ⲡⲓⲕⲁϯ ⲉⲑⲣⲉⲧⲉⲛⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ϫⲉ ⲟⲩ ⲡⲉ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫϯ ⲡⲓⲁⲅⲁⲑⲟⲛ ⲉⲑⲣⲁⲛⲁϥ ⲟⲩⲟϩ ⲉⲧϫⲏⲕ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⲉⲧⲧⲟⲓ ⲛⲏⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣϩⲟⲩ⳿ⲟ ⲙⲉⲩⲓ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲉⲧ⳿ⲥϣⲉ ⳿ⲉⲙⲉⲩⲓ ⳿ⲉⲣⲟϥ ⲁⲗⲗⲁ ⳿ⲉⲙⲉⲩⲓ ⳿ⲉϭⲓ⳿ⲥⲃⲱ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲫϯ ⲫⲱϣ ⲛⲁϥ ⳿ⲛⲟⲩϣⲓ ⳿ⲛⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","⳿ⲙ⳿ⲫⲣⲏϯ ⲅⲁⲣ ⲉⲧⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⲟⲩⲥⲱⲙⲁ ⳿ⲛⲟⲩⲱⲧ ⲟⲩⲟⲛⲧⲁⲛ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲙⲙⲉⲗⲟⲥ ⳿ⲙⲙⲁⲩ ⲛⲓⲙⲉⲗⲟⲥ ⲇⲉ ⲧⲏⲣⲟⲩ ⳿ⲛⲟⲩϩⲱⲃ ⳿ⲛⲟⲩⲱⲧ ⲁⲛ ⲡⲉⲧⲉⲛⲧⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ⲡⲁⲓⲣⲏϯ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ϧⲁ ⲛⲓⲙⲏϣ ⳿ⲁⲛⲟⲛ ⲟⲩⲥⲱⲙⲁ ⳿ⲛⲟⲩⲱⲧ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲟⲛ ⳿ⲁⲛⲟⲛ ϩⲁⲛⲙⲉⲗⲟⲥ ⳿ⲛⲧⲉ ⲛⲉⲛⲉⲣⲏ ⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","⳿ⲉⲟⲩⲟⲛⲧⲁⲛ ⲇⲉ ⳿ⲙⲙⲁⲩ ⳿ⲛϩⲁⲛ⳿ϩⲙⲟⲧ ⲉⲩϣⲉⲃⲓⲏⲟⲩⲧ ⲕⲁⲧⲁ ⳿ⲡϣⲓ ⳿ⲙⲡⲓ⳿ϩⲙⲟⲧ ⲉⲧⲧⲟⲓ ⲛⲁⲛ ⳿ⲓⲧⲉ ⲟⲩ⳿ⲡⲣⲟⲫⲏⲧⲓ⳿ⲁ ⲕⲁⲧⲁ ⲡⲓⲑⲟⲛⲧⲉⲛ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","⳿ⲓⲧⲉ ⲟⲩⲇⲓ⳿ⲁⲕⲟⲛⲓ⳿ⲁ ϧⲉⲛ ϯⲇⲓ⳿ⲁⲕⲟⲛⲓ⳿ⲁ ⳿ⲓⲧⲉ ⲡⲉⲧϯ⳿ⲥⲃⲱ ϧⲉⲛ ϯⲙⲉⲧⲣⲉϥϯ⳿ⲥⲃⲱ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","⳿ⲓⲧⲉ ⲡⲉⲧϯⲛⲟⲙϯ ϧⲉⲛ ϯⲙⲉⲧⲑⲁⲧϩⲏⲧ ⲫⲏⲉⲧϯ ϧⲉⲛ ⲟⲩⲙⲉⲧϩⲁⲡⲗⲟⲩⲥ ⲫⲏⲉⲧⲭⲏ ϧⲁϫⲱⲟⲩ ϧⲉⲛ ⲟⲩ⳿ⲥⲡⲟⲩⲇⲏ ⲫⲏⲉⲑⲛⲁ⳿ⲓ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ϯⲁⲅⲁⲡⲏ ⳿ⲙⲙⲟⲛ ⲙⲉⲧϣⲟⲃⲓ ⳿ⲛϧⲏⲧⲥ ⲉⲣⲉⲧⲉⲛⲫⲏⲧ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲉⲣⲉⲧⲉⲛⲧⲟⲙⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲡⲓⲁⲅⲁⲑⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ϧⲉⲛ ϯⲙⲉⲧⲙⲁⲓⲥⲟⲛ ⲉⲣⲉⲧⲉⲛⲭⲏ ϧⲉⲛ ⲟⲩⲙⲉⲓ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲉⲣⲉⲧⲉⲛⲉⲣϣⲟⲣⲡ ⳿ⲛⲭⲁ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩⲧⲁⲓⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛϭⲛⲁⲩ ⲁⲛ ϧⲉⲛ ϯ⳿ⲥⲡⲟⲩⲇⲏ ⲉⲣⲉⲧⲉⲛϧⲏⲙ ϧⲉⲛ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙⲠ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ⲉⲣⲉⲧⲉⲛⲣⲁϣⲓ ϧⲉⲛ ϯϩⲉⲗⲡⲓⲥ ⲉⲣⲉⲧⲉⲛⲉⲣϩⲩⲡⲟⲙⲉⲛⲓⲛ ϧⲉⲛ ⲛⲓϩⲟϫϩⲉϫ ⲉⲣⲉⲧⲉⲛⲙⲏ ⲛ ⳿ⲉϯⲡⲣⲟⲥⲉⲩⲭⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲛⲓ⳿ⲭⲣⲓⲁ ⳿ⲛⲧⲉ ⲛⲓⲁⲅⲓⲟⲥ ⲉⲣⲉⲧⲉⲛϭⲟϫⲓ ⳿ⲛⲥⲁ ⳿ⲧⲙⲉⲧⲙⲁⲓϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","⳿ⲥⲙⲟⲩ ⳿ⲉⲛⲏⲉⲧϭⲟϫⲓ ⳿ⲛⲥⲁ ⲑⲏⲛⲟⲩ ⳿ⲥⲙⲟⲩ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣⲥⲁϩⲟⲩ⳿ⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ⲣⲁϣⲓ ⲛⲉⲙ ⲛⲏⲉⲧⲣⲁϣⲓ ⲟⲩⲟϩ ⲣⲓⲙⲓ ⲛⲉⲙ ⲛⲏⲉⲧⲣⲓⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ⲟⲩⲙⲉⲩⲓ ⳿ⲛⲟⲩⲱⲧ ⲉⲣⲉⲧⲉⲛⲣⲁ ⳿ⲙⲙⲟϥ ⳿ⲉⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⳿ⲛⲧⲉⲧⲉⲛⲙⲉⲩⲓ ⲁⲛ ⳿ⲉⲛⲓⲙⲉⲧϭⲁⲥⲓϩⲏ ⲧ ⲁⲗⲗⲁ ⲉⲣⲉⲧⲉⲛⲙⲟϣⲓ ⲛⲉⲙ ⲛⲏⲉⲧⲑⲉⲃⲓⲏ ⲟⲩⲧ ⳿ⲙⲡⲉⲣϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲥⲁⲃⲉ ⲛⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","⳿ⲛⲧⲉⲧⲉⲛϯ ⳿ⲛⲟⲩⲡⲉⲧϩⲱⲟⲩ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲛ⳿ⲧϣⲉⲃⲓⲱ ⳿ⲛⲡⲟⲩⲡⲉⲧϩⲱⲟⲩ ⲉⲣⲉⲧⲉⲛϥⲓ ⳿ⲙ⳿ⲫⲣⲱⲟⲩϣ ⳿ⲛϩⲁⲛⲡⲉⲑⲛⲁⲛⲉⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲛⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ⲓⲥϫⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲣⲓⲁⲩⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲉⲣϩⲓⲣⲏⲛⲏ ⲛⲉⲙ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","⳿ⲛⲧⲉⲧⲉⲛϭⲓ ⳿ⲙⲡⲉⲧⲉⲛ⳿ⲙ⳿ⲡϣⲓϣ ⲁⲛ ⲛⲁⲙⲉⲛⲣⲁϯ ⲁⲗⲗⲁ ⲙⲁⲙⲁ ⳿ⲙ⳿ⲡϫⲱⲛⲧ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⳿ⲛϭⲓ⳿ⲙ⳿ⲡϣⲓϣ ⲫⲱⲓ ⳿ⲁⲛⲟⲕ ⲡⲉ ⳿ⲁⲛⲟⲕ ⲉⲑⲛⲁϯϣⲉⲃⲓⲱ ⲡⲉϫⲉ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ⲁⲗⲗⲁ ⲉϣⲱⲡ ⲁⲣⲉϣⲁⲛ ⲡⲉⲕϫⲁϫⲓ ⳿ϩⲕⲟ ⲙⲁⲧⲉⲙⲙⲟϥ ⲁϥϣⲁⲛ⳿ⲓⲃⲓ ⲙⲁ⳿ⲧⲥⲟϥ ⲫⲁⲓ ⲅⲁⲣ ⲉⲕⲣⲁ ⳿ⲙⲙⲟϥ ⲉⲕ⳿ⲉⲑⲱⲟⲩϯ ⳿ⲛϩⲁⲛϫⲉⲃⲥ ⳿ⲛ ⳿ⲭⲣⲱⲙ ϩⲓϫⲉⲛ ⲧⲉϥⲁⲫⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","⳿ⲙⲡⲉⲛⲑⲣⲉ ⲡⲓⲡⲉⲧϩⲱⲟⲩ ϭⲣⲟ ⳿ⲉⲣⲱⲧⲉⲛ ⲁⲗⲗⲁ ϧⲉⲛ ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ϭⲣⲟ ⳿ⲉⲡⲓⲡⲉⲧϩⲱⲟⲩ ");
INSERT INTO copcnt_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ⲯⲩⲭⲏ ⲛⲓⲃⲉⲛ ⲙⲁⲣⲟⲩϭⲛⲉϫⲱⲟⲩ ⳿ⲉⲛⲓⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲉⲧϭⲟⲥⲓ ⳿ⲙⲙⲟⲛ ⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲅⲁⲣ ϣⲟⲡ ⳿ⲉⲃⲏⲗ ⳿ⲉⲛⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲛⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲥⲉⲑⲏϣ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ϩⲱⲥⲧⲉ ⲫⲏⲉⲧϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ϯ ⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲁϥϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲉⲛ ⲡⲓⲑⲱϣ ⳿ⲛⲧⲉ ⲫϯ ⲛⲏ ⲇⲉ ⲉⲧϯ ⳿ⲉϧⲟⲩⲛ ⳿ⲉ⳿ϩⲣⲁⲩ ⲉⲩ⳿ⲉϭⲓ ⳿ⲛⲟⲩϩⲁⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ⲛⲓⲁⲣⲭⲏ ⲅⲁⲣ ⲛⲁⲩⲭⲏ ⲉⲩϩⲟϯ ⲁⲛ ⳿ⲙⲡⲓϩⲱⲃ ⲉⲑⲛⲁⲛⲉϥ ⲁⲗⲗⲁ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ⲭ ⲟⲩⲱϣ ⲇⲉ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣϩⲟϯ ϧⲁ⳿ⲧϩⲏ ⳿ⲛϯⲉⲝⲟⲩⲥⲓ⳿ⲁ ⲁⲣⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲟⲩⲟϩ ⲉⲣⲉ ⲟⲩⲧⲁⲓⲟ ϣⲱⲡⲓ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ⳿ⲙⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ⲟⲩⲇⲓ⳿ⲁⲕⲱⲛ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲕ ⲧⲉ ⳿ⲉⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲉϣⲱⲡ ⲇⲉ ⲁⲕϣⲁⲛ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⲁⲣⲓϩⲟϯ ⲛⲁⲥⲉⲣⲫⲟⲣⲓⲛ ⲅⲁⲣ ⲁⲛ ⳿ⲛϯ ⲥⲏϥⲓ ϩⲓⲕⲏ ⲟⲩⲇⲓ⳿ⲁⲕⲱⲛ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉ ⲉⲥϭⲓ⳿ⲙ⳿ⲡϣⲓϣ ⳿ⲙ⳿ⲡϫⲱⲛⲧ ⳿ⲙⲫⲏⲉⲧ⳿ⲓⲣⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲛⲁⲅⲕⲏ ⳿ⲉϭⲛⲉϫⲱⲧⲉⲛ ⲟⲩ ⲙⲟⲛⲟⲛ ⲉⲑⲃⲉ ⳿ⲡϫⲱⲛⲧ ⲁⲗⲗⲁ ⲛⲉⲙ ⲉⲑⲃⲉ ϯⲥⲩⲛⲏⲇⲉⲥⲓⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ⲉⲑⲃⲉ ⲫⲁⲓ ⲅⲁⲣ ⲧⲉⲛϯϩⲱϯ ϩⲁⲛⲣⲉϥⲫⲱϣⲉⲛ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲛⲉ ⲉⲩⲙⲏⲛ ⳿ⲉⲡⲁⲓϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ⲙⲁ ⲛⲉⲧⲉⲣⲱⲧⲉⲛ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲙⲁ ⲡⲓϩⲱϯ ⳿ⲙⲫⲁ ⲡⲓϩⲱϯ ⲙⲁ ⲡⲓⲧⲉⲗⲟⲥ ⳿ⲙⲫⲁ ⲡⲓⲧⲉⲗⲟⲥ ⲙⲁϯϩⲟϯ ⳿ⲙⲫⲁ ϯϩⲟϯ ⲙⲁ ⲡⲓⲧⲁⲓⲟ ⳿ⲙⲫⲁ ⲡⲓⲧⲁⲓⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","⳿ⲙⲡⲉⲣⲭⲁ ⳿ϩⲗⲓ ⳿ⲛⲧⲉ ⳿ϩⲗⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲉⲃⲏⲗ ⳿ⲉⲙⲉⲛⲣⲉ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲫⲏ ⲅⲁⲣ ⲉⲑⲙⲉⲓ ⳿ⲙⲡⲉϥ⳿ϣⲫⲏⲣ ⲁϥϫⲉⲕ ⲡⲓⲛⲟⲙⲟⲥ ⳿ⲉⲃⲟⲗ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ⲫⲁⲓ ⲅⲁⲣ ϫⲉ ⳿ⲛⲛⲉⲕⲉⲣⲛⲱⲓⲕ ⳿ⲛⲛⲉⲕϧⲱⲧⲉⲃ ⳿ⲛⲛⲉⲕϭⲓⲟⲩ⳿ⲓ ⳿ⲛⲛⲉⲕⲉⲣⲙⲉⲑⲣⲉ ⳿ⲛⲛⲟⲩϫ ⳿ⲛⲛⲉⲕⲉⲣ⳿ⲉⲡⲓⲑⲩⲙⲓⲛ ⲛⲉⲙ ⲕⲉⲟⲩ⳿ⲓ ⲕⲉⲟⲩ⳿ⲓ ⳿ⲛⲛⲓⲉⲛⲧⲟⲗⲏ ⲁⲩϫⲏⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲥⲁϫⲓ ϧⲉⲛ ⳿ⲫⲙⲉⲛⲣⲉ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⳿ⲙⲡⲉⲕⲣⲏϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ϯⲁⲅⲁⲡⲏ ⳿ⲙⲡⲉⲥⲉⲣⲡⲉⲧϩⲱⲟⲩ ⳿ⲙⲡⲉⲥ⳿ϣⲫⲏ ⲣ ⳿ⲡϫⲱⲕ ⲟⲩⲛ ⳿ⲙⲡⲓⲛⲟⲙⲟⲥ ⲡⲉ ϯⲁⲅⲁⲡⲏ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ⲟⲩⲟϩ ⲫⲁⲓ ⲉⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ⳿ⲉⲡⲓⲥⲏⲟⲩ ϫⲉ ϯⲟⲩⲛⲟⲩ ⲧⲉ ϩⲏⲇⲏ ⲉⲑⲣⲉⲧⲉⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉⲛⲕⲟⲧ ϯⲛⲟⲩ ⲇⲉ ⲁϥϧⲱⲛⲧ ⳿ⲉⲣⲟⲛ ⳿ⲛϫⲉ ⲡⲉⲛⲛⲟϩⲉⲙ ⳿ⲉϩⲟⲧⲉ ⲡⲓⲥⲏⲟⲩ ⲉⲧⲁⲛⲛⲁϩϯ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ⲁ ⲡⲓ⳿ⲉϫⲱⲣϩ ⲉⲣ⳿ⲡⲣⲟⲕⲟⲡⲧⲓⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲇⲉ ⲁϥϧⲱⲛⲧ ⲙⲁⲣⲉⲛⲭⲱ ⲟⲩⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛⲛⲓ⳿ϩⲃⲏ ⲟⲩ⳿ⲓ ⳿ⲛⲧⲉ ⳿ⲡⲭⲁⲕⲓ ⲙⲁⲣⲉⲛϯ ⲇⲉ ϩⲓⲱⲧⲉⲛ ⳿ⲛⲛⲓϩⲟⲡⲗⲟⲛ ⳿ⲛⲧⲉ ⲡⲓⲟⲩⲱⲓⲛⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ϩⲱⲥ ⲉⲛϧⲉⲛ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲙⲁⲣⲉⲛⲙⲟϣⲓ ⲉⲛⲥⲟⲩⲃⲏⲧ ϧⲉⲛ ϩⲁⲛϫⲉⲣϫⲉⲣ ⲁⲛ ⲛⲉⲙ ϩⲁⲛⲑⲓϧⲓ ϧⲉⲛ ϩⲁⲛϣⲁ⳿ⲓⲣⲓ ⲁⲛ ⲛⲉⲙ ϩⲁⲛⲥⲱϥ ϧⲉⲛ ⲟⲩϣϭⲛⲏⲛ ⲁⲛ ⲛⲉⲙ ⲟⲩⲭⲟϩ. ");
INSERT INTO copcnt_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ⲁⲗⲗⲁ ⲙⲟⲓ ϩⲓ ⲑⲏⲛⲟⲩ ⳿ⲙⲠ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⳿ⲙⲡⲉⲣϥⲓⲣⲱⲟⲩϣ ϧⲁ ϯⲥⲁⲣⲝ ϧⲉⲛ ϩⲁⲛ⳿ⲉⲡⲓⲑⲩⲙⲓ⳿ⲁ ");
INSERT INTO copcnt_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ⲡⲉⲧϣⲱⲛⲓ ϧⲉⲛ ⳿ⲫⲛⲁϩϯ ϣⲟⲡϥ ⳿ⲉⲣⲱⲧⲉⲛ ϧⲉⲛ ϩⲁⲛϩⲓⲟⲓ ⲁⲛ ⳿ⲛⲧⲉ ϩⲁⲛⲙⲟⲕⲙⲉⲕ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ⲟⲩⲟⲛ ⲡⲉⲑⲛⲁϩϯ ⲙⲉⲛ ⳿ⲉⲟⲩⲉⲙ ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲡⲉⲧϣⲱⲛⲓ ⲇⲉ ϣⲁϥⲟⲩⲉⲙ ⲟⲩⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ⲫⲏⲉⲑⲟⲩⲱⲙ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥϣⲉϣϥ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲟⲩⲱⲙ ⲁⲛ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲟⲩⲱⲙ ⲁⲛ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥϯ ϩⲁⲡ ⳿ⲉⲡⲉⲑⲟⲩⲱⲙ ⲫϯ ⲅⲁⲣ ⲁϥϣⲟⲡϥ ⳿ⲉⲣⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","⳿ⲛⲑⲟⲕ ⲛⲓⲙ ⳿ⲛⲑⲟⲕ ⲫⲏⲉⲧϯϩⲁⲡ ⳿ⲉⲟⲩⲃⲱⲕ ⳿ⲛϣⲉⲙⲙⲟ ⲉϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⳿ⲉⲡⲉϥ⳪ ⲓⲉ ⲉϥⲛⲁϩⲉⲓ ⲉϥⲟϩⲓ ⲇⲉ ⳿ⲉⲣⲁⲧϥ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲠ⳪ ⳿ⲉⲧⲁϩⲟϥ ⳿ⲉⲣⲁⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ⲟⲩⲟⲛ ⲡⲉϯϩⲁⲡ ⲅⲁⲣ ⲙⲉⲛ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ϧⲁ⳿ⲧϩⲏ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲟⲩⲟⲛ ⲡⲉⲧϯϩⲁⲡ ⲇⲉ ⳿ⲛ⳿ⲉϩⲟⲟⲩ ⲛⲓⲃⲉⲛ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲙⲁⲣⲉϥⲑⲱⲧ ⳿ⲛϩⲏⲧ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ⲫⲏⲉⲑⲙⲉⲩⲓ ⳿ⲉⲡⲓ⳿ⲉϩⲟⲟⲩ ⲁϥⲙⲉⲩⲓ ⳿ⲉⲠ⳪ ⲟⲩⲟϩ ⲡⲉⲑⲟⲩⲱⲙ ⲁϥⲟⲩⲱⲙ ⳿ⲙⲠ⳪ ⳿ϥϣⲉⲡ⳿ϩⲙⲟⲧ ⲅⲁⲣ ⳿ⲛⲧⲉⲛ ⲫϯ ⲟⲩⲟϩ ⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲟⲩⲱⲙ ⲁⲛ ⳿ϥⲟⲩⲱⲙ ⲁⲛ ⳿ⲙⲠ⳪ ⲟⲩⲟϩ ⳿ϥϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⲛⲁⲱⲛϧ ⲛⲁϥ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲛⲁⲙⲟⲩ ⲛⲁϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ⲉϣⲱⲡ ⲅⲁⲣ ⲉⲛⲛⲁⲱⲛϧ ⲉⲛⲛⲁⲱⲛϧ ⳿ⲙⲡϭ̅ ⲥ̅ ⲉϣⲱⲡ ⲇⲉ ⲉⲛⲛⲁⲙⲟⲩ ⲉⲛⲛⲁⲙⲟⲩ ⳿ⲙⲠ⳪ ⳿ⲓⲧⲉ ⲟⲩⲛ ⲉⲛⲛⲁⲱⲛϧ ⳿ⲓⲧⲉ ⲉⲛⲛⲁⲙⲟⲩ ⳿ⲁⲛⲟⲛ ⲛⲁ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ⲉⲑⲃⲉ ⲫⲁⲓ Ⲡⲭ̅ⲥ̅ ⲁϥⲙⲟⲩ ⲟⲩⲟϩ ⲁϥⲱⲛϧ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣ⳪ ⳿ⲉⲛⲏⲉⲑⲙⲱⲟⲩⲧ ⲛⲉⲙ ⲛⲏⲉⲧⲟⲛϧ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","⳿ⲛⲑⲟⲕ ⲇⲉ ⲉⲑⲃⲉⲟⲩ ⳿ⲕϯϩⲁⲡ ⳿ⲉⲡⲉⲕⲥⲟⲛ ⳿ⲙⲙⲟⲛ ⳿ⲛⲑⲟⲕ ϩⲱⲕ ⲉⲑⲃⲉⲟⲩ ⳿ⲕϣⲱϣ ⳿ⲙⲡⲉⲕⲥⲟⲛ ⳿ⲁⲛⲟⲛ ⲅⲁⲣ ⲧⲏⲣⲉⲛ ⲥⲉⲛⲁⲧⲁϩⲟⲛ ⳿ⲉⲣⲁⲧⲉⲛ ⲛⲁϩⲣⲉⲛ ⲡⲓⲃⲏⲙⲁ ⳿ⲛⲧⲉ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ϯⲟⲛϧ ⳿ⲁⲛⲟⲕ ⲡⲉϫⲉ Ⲡ⳪ ϫⲉ ⲕⲉⲗⲓ ⲛⲓⲃⲉⲛ ⲉⲩ⳿ⲉⲕⲱⲗϫ ⲛⲏⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉ ⲗⲁⲥ ⲛⲓⲃⲉⲛ ⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ϩⲁⲣⲁ ⲟⲩⲛ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲟⲛ ⳿ϥⲛⲁϯⲗⲟⲅⲟⲥ ⳿ⲉϫⲱϥ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛϯϩⲁⲡ ⲟⲩⲛ ϫⲉ ⳿ⲉⲛⲉⲛⲉⲣⲏⲟⲩ ⲁⲗⲗⲁ ⲫⲁⲓ ⲙⲁⲗⲗⲟⲛ ⲙⲁϩⲁⲡ ⳿ⲉⲣⲟϥ ⳿ⲉ⳿ϣⲧⲉⲙⲭ ⲁ ⲟⲩϭⲣⲟⲡ ⲓⲉ ⲟⲩ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⳿ⲙⲡⲉⲕⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ϯ⳿ⲉⲙⲓ ⲟⲩⲟϩ ⲡⲁϩⲏⲧ ⲑⲏⲧ ϧⲉⲛ Ⲡ⳪ Ⲓⲏ̅ⲥ̅ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲉϥϭⲁϧⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲉⲃⲏⲗ ⳿ⲉⲫⲏⲉⲑⲙⲉⲩⲓ ⳿ⲉⲟⲩⲉⲛⲭⲁⲓ ϫⲉ ⳿ϥ ϭⲁϧⲉⲙ ⳿ϥϭⲁϧⲉⲙ ⳿ⲛⲧⲟⲧϥ ⳿ⲙⲫⲏ ⳿ⲉⲧⲉ⳿ⲙⲙⲁⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ⲓⲥϫⲉ ⲅⲁⲣ ⲉⲑⲃⲉ ⲟⲩ⳿ϧⲣⲉ ⲁⲣⲉ ⲡⲉⲕⲥⲟⲛ ⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲉⲥⲑⲉ ⲓⲉ ⳿ⲕⲙⲟϣⲓ ⲁⲛ ϫⲉ ⲕⲁⲧⲁ ⲟⲩⲁⲅⲁⲡⲏ ⳿ⲙⲡⲉⲣⲧⲁⲕⲉ ⲫⲏⲉⲧⲁ Ⲡⲭ̅ⲥ̅ ⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ ϧⲉⲛ ⲧⲉⲕ⳿ϧⲣⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲟⲩϫⲉⲟⲩ⳿ⲁ ⲟⲩⲛ ⳿ⲉⲡⲉⲧⲉⲛⲡⲉⲑⲛⲁⲛⲉϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ϯⲙⲉⲧⲟⲩⲣⲟ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲥϧⲉⲛ ⲟⲩⲱⲙ ⲁⲛ ⲛⲉⲙ ⲟⲩⲥⲱ ⲁⲗⲗⲁ ⲁⲥϧⲉⲛ ⲟⲩⲙⲉⲑⲙⲏ ⲓ ⲛⲉⲙ ⲟⲩϩⲓⲣⲏⲛⲏ ⲛⲉⲙ ⲟⲩⲣⲁϣⲓ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ⲫⲏ ⲅⲁⲣ ⲉⲧⲟⲓ ⳿ⲙⲃⲱⲕ ϧⲉⲛ ⲛⲁⲓ ⳿ⲉⲠⲭ̅ⲥ̅ ⳿ϥⲣⲁⲛⲁϥ ⳿ⲙⲫϯ ⲟⲩⲟϩ ⳿ϥⲥⲟⲩⲧⲱⲛ ⲡⲉ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ϩⲁⲣⲁ ⲟⲩⲛ ⲙⲁⲣⲉⲛϭⲟϫⲓ ⳿ⲛⲥⲁ ⲛⲁ ϯϩⲓⲣⲏⲛⲏ ⲛⲉⲙ ⲛⲁ ⲡⲓⲕⲱⲧ ⳿ⲉⲛⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","⳿ⲙⲡⲉⲣⲃⲉⲗ ⲡⲓϩⲱⲃ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲉⲃⲟⲗ ⲉⲑⲃⲉ ⲟⲩ⳿ϧⲣⲉ ⲥⲉⲟⲩⲁⲃ ⲙⲉⲛ ⲧⲏⲣⲟⲩ ⲁⲗⲗⲁ ⲟⲩⲡⲉⲧϩⲱⲟⲩ ⲡⲉ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲫⲏⲉⲑⲛⲁⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩϭⲣⲟⲡ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ⲛⲁⲛⲉⲥ ⳿ⲉ⳿ϣⲧⲉⲙⲟⲩⲉⲙ ⲁϥ ⲟⲩⲇⲉ ⳿ⲉ⳿ϣⲧⲉⲙⲥⲉ ⲏⲣⲡ ⲛⲉⲙ ⲫⲏⲉⲧⲉ ⲡⲉⲕⲥⲟⲛ ⲛⲁ ϭⲓϭⲣⲟⲡ ⳿ⲛϧⲏⲧϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","⳿ⲛⲑⲟⲕ ⲟⲩⲟⲛⲧⲁⲕ ⳿ⲛⲟⲩⲛⲁϩϯ ⳿ⲙⲙⲁⲩ ⲭⲁϥ ⳿ⲛϧⲏⲧⲕ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ ⲱⲟⲩⲛⲓ⳿ⲁⲧϥ ⳿ⲙⲫⲏⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⲁⲛ ϧⲉⲛ ⲫⲏⲉⲧⲉϥⲛⲁⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ. ");
INSERT INTO copcnt_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ⲫⲏ ⲇⲉ ⲉⲧⲟⲓ ⳿ⲛϩⲏⲧ ⲃ̅ ⲉϣⲱⲡ ⲁϥϣⲁⲛⲟⲩⲱⲙ ⲁϥϩⲓⲧϥ ⳿ⲉ⳿ⲡϩⲁⲡ ϫⲉ ⳿ⲛⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲛⲁϩϯ ⲁⲛ ⲡⲉ ϩⲱⲃ ⲇⲉ ⲛⲓⲃⲉⲛ ⲉⲧⲉ⳿ⲛⲟⲩ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲛⲁϩϯ ⲁⲛ ⲡⲉ ⲟⲩⲛⲟⲃⲓ ⲡⲉ ");
INSERT INTO copcnt_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","⳿ⲥⲉⲙ⳿ⲡϣⲁ ⲇⲉ ⲛⲁⲛ ⳿ⲁⲛⲟⲛ ϧⲁ ⲛⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲧⲉⲛϥⲁⲓ ϧⲁ ⲛⲓϣⲱⲛⲓ ⳿ⲛⲧⲉ ⲛⲓⲁⲧϫⲟⲙ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲛ⳿ϣⲧⲉⲙⲣⲁⲛⲁⲛ ⳿ⲙⲙⲁⲩⲁⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲙⲁⲣⲉϥⲣⲁⲛⲁϥ ⳿ⲙⲡⲉϥ⳿ϣⲫⲏⲣ ϧⲉⲛ ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲉⲩⲕⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ⲕⲉ ⲅⲁⲣ Ⲡⲭ̅ⲥ̅ ⲛⲉⲧⲁϥⲣⲁⲛⲁϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲛ ⲁⲗⲗⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲛⲓϣⲱϣ ⳿ⲛⲧⲉ ⲛⲏⲉⲧϯ⳿ϣⲫⲓⲧ ⲛⲁⲕ ⲁⲩ⳿ⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ϩⲱⲃ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲉⲧⲁⲩⲉⲣϣⲟⲣⲡ ⳿ⲛ⳿ⲥϧⲏ ⲧⲟⲩ ⲁⲩ⳿ⲥϧⲏⲧⲟⲩ ⳿ⲉⲧⲉⲛ⳿ⲥⲃⲱ ϩⲓⲛⲁ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯϩⲩⲡⲟⲙⲟⲛⲏ ⲛⲉⲙ ϯⲙⲉⲧⲣⲉϥϯⲛⲟⲙϯ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ⳿ⲛⲧⲉ ϯϩⲉⲗⲡⲓⲥ ϣⲱⲡⲓ ⲛⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ⲫϯ ⲇⲉ ⳿ⲛⲧⲉ ϯϩⲓⲣⲏⲛⲏ ⲛⲉⲙ ϯⲡⲁⲣⲁⲕⲗⲏ ⲥⲓⲥ ⲉϥ⳿ⲉϯ ⲛⲟⲩⲙⲉⲩⲓ ⳿ⲛⲟⲩⲱⲧ ⲛⲱⲧⲉⲛ ⳿ⲉⲛⲉⲧⲉⲛⲉⲣⲏ ⲟⲩ ⲕⲁⲧⲁ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ϩⲓⲛⲁ ϧⲉⲛ ⲟⲩϩⲏⲧ ⳿ⲛⲟⲩⲱⲧ ⲛⲉⲙ ⲟⲩⲣⲱ ⳿ⲛⲟⲩⲱⲧ ⳿ⲛⲧⲉⲧⲉⲛϯⲱⲟⲩ ⳿ⲙⲫϯ ⳿ⲫⲓⲱⲧ ⳿ⲙⲡⲉⲛϭ̅ ⲥ̅ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ⲉⲑⲃⲉ ⲫⲁⲓ ϣⲉⲡ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⳿ⲉⲣⲱⲧⲉⲛ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ϩⲱϥ ⲉⲧⲁ Ⲡⲭ̅ⲥ̅ ϣⲉⲡ ⲑⲏⲛⲟⲩ ⳿ⲉⲣⲟϥ ⲉⲩⲱⲟⲩ ⳿ⲙⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ϯϫⲱ ⲅⲁⲣ ⳿ⲙⲙⲟⲥ ϫⲉ Ⲡⲭ̅ⲥ̅ ⲁϥϣⲱⲡⲓ ⳿ⲛⲟⲩⲇⲓ⳿ⲁⲕⲱⲛ ⳿ⲛⲧⲉ ⳿ⲡⲥⲉⲃⲓ ⳿ⲉϫⲉⲛ ϯⲙⲉⲑⲛⲏⲓ ⳿ⲛⲧⲉ ⲫϯ ϫⲉⲭⲁⲥ ⲉϥ⳿ⲉⲧⲁϫⲣⲉ ⲛⲓⲱϣ ⳿ⲛⲧⲉ ⲛⲓⲓⲟϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ⲛⲓⲉⲑⲛⲟⲥ ⲇⲉ ⲉⲑⲃⲉ ⲟⲩⲛⲁⲓ ⳿ⲉϯⲱⲟⲩ ⳿ⲙⲫϯ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲉⲑⲃⲉ ⲫⲁⲓ ϯⲛⲁⲟⲩⲱⲛϩ ⲛⲁⲕ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲟⲩⲟϩ ϯⲛⲁⲉⲣⲯⲁⲗⲓⲛ ⳿ⲉⲡⲉⲕⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ⲟⲩⲟϩ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ⲟⲛ ϫⲉ ⲟⲩⲛⲟϥ ⳿ⲙⲙⲱⲧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲛⲉⲙ ⲡⲉϥⲗⲁⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ⲟⲩⲟϩ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ⲟⲛ ϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ ⳿ⲥⲙⲟⲩ ⳿ⲉⲠ⳪ ⲙⲁⲣⲟⲩ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲗⲁⲟⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ⲟⲩⲟϩ ⳿ϥϫⲱ ⳿ⲙⲙⲟⲥ ⲟⲛ ⳿ⲛϫⲉ ⲏⲥⲁⲏⲁⲥ ϫⲉ ⲉⲥ⳿ⲉϣⲱⲡⲓ ⳿ⲛϫⲉ ⳿ⲑⲛⲟⲩⲛⲓ ⳿ⲛⲓⲉⲥⲥⲉ ⲛⲉⲙ ⲫⲏⲉⲑⲛⲁⲧⲱⲛϥ ⳿ⲉⲉⲣⲁⲣⲭⲱⲛ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ ⲉⲩ⳿ⲉⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉⲣⲟϥ ⳿ⲛϫⲉ ⲛⲓⲉⲑⲛⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ⲫϯ ⲇⲉ ⳿ⲛⲧⲉ ϯϩⲉⲗⲡⲓⲥ ⲉϥ⳿ⲉⲙⲁϩ ⲑⲏⲛⲟⲩ ⳿ⲛⲣⲁϣⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ϯϩⲓⲣⲏⲛⲏ ϧⲉⲛ ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉⲧⲉⲛⲛⲁϩϯ ⲉⲣⲉⲧⲉⲛⲉⲣϩⲟⲩ⳿ⲟ ϧⲉⲛ ϯ ϩⲉⲗⲡⲓⲥ ϧⲉⲛ ϯϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","⳿ⲁⲛⲟⲕ ϩⲱ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲡⲁϩⲏⲧ ⲑⲏⲧ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲙⲉϩ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲛⲁⲅⲁⲑⲟⲛ ⲉⲣⲉⲧⲉⲛⲙⲉϩ ϧⲉⲛ ⳿ⲉⲙⲓ ⲛⲓⲃⲉⲛ ⳿ⲉⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ϧⲉⲛ ⲟⲩⲙⲉⲧⲧⲟⲗⲙⲉⲣⲟⲥ ⲇⲉ ⲁⲓ⳿ⲥϧⲁⲓ ⲛⲱⲧⲉⲛ ⳿ⲛⲟⲩ⳿ⲁⲡⲟⲙⲉⲣⲟⲥ ϩⲱⲥ ⲉⲓϯ ⳿ⲙ⳿ⲫⲙⲉⲩⲓ ⲛⲱⲧⲉⲛ ⲉⲑⲃⲉ ⲡⲓ⳿ϩⲙⲟⲧ ⲉⲧⲁⲩⲧⲏⲓϥ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ⲉⲑⲣⲓϣⲱⲡⲓ ⲉⲓⲟⲓ ⳿ⲛⲣⲉϥⲫⲱϣⲉⲛ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲉⲛⲓⲉⲑⲛⲟⲥ ⲉⲓⲉⲣϩⲱⲃ ϧⲉⲛ ⲟⲩⲙⲉⲧⲟⲩⲏ ⲃ ⳿ⲉⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ϯ⳿ⲡⲣⲟⲥⲫⲱⲣⲁ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ϣⲱⲡⲓ ⲉⲥϣⲏⲡ ⲟⲩⲟϩ ⲉⲥⲧⲟⲩⲃⲏⲟⲩⲧ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ⲟⲩⲟⲛⲧⲏⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩϣⲟⲩϣⲟⲩ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ϩⲁ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ⲟⲩ ⲅⲁⲣ ⳿ⲛⲛⲁⲉⲣⲧⲟⲗⲙⲁⲛ ⳿ⲉϫⲉ ⲟⲩⲥⲁϫⲓ ϧⲉⲛ ⲛⲏⲉⲧⲉ ⳿ⲙⲡⲉ Ⲡⲭ̅ⲥ̅ ⲉⲣϩⲱⲃ ⳿ⲛϧⲏ ⲧⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ϧⲉⲛ ⳿ⲡⲥⲁϫⲓ ϧⲉⲛ ⳿ⲡϩⲱⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ϧⲉⲛ ⳿ⲧϫⲟⲙ ⳿ⲛⲧⲉ ϩⲁⲛⲙⲏⲓⲛⲓ ⲛⲉⲙ ϩⲁⲛ⳿ϣⲫⲏⲣⲓ ϧⲉⲛ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲟⲩⲡ͞ⲛⲁ̅ ⲉϥⲟⲩⲁⲃ ϩⲱⲥⲧⲉ ⲓⲥϫⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⲛⲉⲙ ⲡⲉⲥⲕⲱϯ ϣⲁ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉⲡⲓ⳿ⲁⲗⲗⲩⲣⲓⲕⲟⲛ ⳿ⲛⲧⲁⲙⲁϩⲟⲩ ⳿ⲉⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲛⲁⲓⲙⲉⲓ ⳿ⲛϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⲡⲉ ⳿ⲉ⳿ⲫⲙⲁ ⲁⲛ ⲉⲧⲁⲩϫⲉ ⳿ⲫⲣⲁⲛ ⳿ⲙⲠⲭ̅ⲥ̅ ⳿ⲙⲙⲟϥ ϩⲓⲛⲁ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙⲕⲱⲧ ⳿ⲉϫⲉⲛ ⲟⲩⲥⲉⲛϯ ⳿ⲛϣⲉⲙⲙⲟ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ⲁⲗⲗⲁ ⲕⲁⲧⲁ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲉⲩ⳿ⲉⲛⲁⲩ ⳿ⲛϫⲉ ⲛⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲧⲁⲙⲱⲟⲩ ⲉⲑⲃⲏ ⲧϥ ⲟⲩⲟϩ ⲛⲏⲉⲧⲉ ⳿ⲙⲡⲟⲩⲥⲱⲧⲉⲙ ⲉⲩ⳿ⲉⲕⲁϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓⲧⲁϩⲛⲟ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲥⲟⲡ ⳿ⲉ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ϯⲛⲟⲩ ⲇⲉ ⳿ⲙⲙⲟⲛϯ ⲙⲁ ϧⲉⲛ ⲛⲁⲓⲥⲁ ⲟⲩⲟⲛ ⲟⲩⲙⲉⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⲇⲉ ϣⲟⲡ ⳿ⲛϧⲏⲧ ⳿ⲉ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ ⲓⲥ ⲟⲩⲙⲏϣ ⳿ⲛⲣⲟⲙⲡⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ϩⲱⲥ ⲉⲓⲛⲁϣⲉⲛⲏⲓ ⳿ⲉϯ⳿ⲥⲡⲁⲛⲓ⳿ⲁ ϯⲉⲣϩⲉⲗⲡⲓⲥ ⲅⲁⲣ ⳿ⲉⲛⲁⲩ ⳿ⲉⲣⲱⲧⲉⲛ ⲉⲓⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉⲙⲁⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲧⲫⲟⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲙⲁⲩ ⲉϣⲱⲡ ⲁⲓϣⲁⲛⲥⲓ ⳿ⲙⲙⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩ⳿ⲁⲡⲟⲙⲉⲣⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ϯⲛⲟⲩ ⲇⲉ ϯⲛⲁϣⲉ ⲛⲏⲓ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲉϣⲉⲙϣⲓ ⳿ⲛⲛⲏⲉⲑⲟⲩⲁⲃ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ⲁⲩϯⲙⲁϯ ⲅⲁⲣ ⳿ⲛϫⲉ ⲛⲁ⳿ⲑⲙⲁⲕⲉⲇⲟⲛⲓ⳿ⲁ ⲛⲉⲙ ⲁⲭⲁⲓ⳿ⲁ ⲉ⳿ⲓⲣⲓ ⳿ⲛⲟⲩⲙⲉⲧ⳿ϣⲫⲏⲣ ⳿ⲉⲛⲓϩⲏⲕⲓ ⳿ⲛⲧⲉ ⲛⲏⲉⲑⲟⲩⲁⲃ ⲛⲏⲉⲧϧⲉⲛ ⳿ⲓⲗ̅ⲏ̅ⲙ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ⲁⲩϯⲙⲁϯ ⲅⲁⲣ ⲟⲩⲟϩ ⲟⲩⲟⲛ ⳿ⲉⲣⲱⲟⲩ ⳿ⲛⲧⲱⲟⲩ ⲓⲥϫⲉ ⲅⲁⲣ ⲛⲓⲉⲑⲛⲟⲥ ⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲉⲣⲱⲟⲩ ϧⲉⲛ ⲟⲩⲡ͞ⲛⲁ̅ⲧⲓⲕⲟⲛ ⲥⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲥⲉϣⲉⲙϣⲏⲧⲟⲩ ϧⲉⲛ ⲛⲓⲕⲉⲥⲁⲣⲕⲓⲕⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ⲫⲁⲓ ⲟⲩⲛ ⲁⲓϣⲁⲛϫⲟⲕϥ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲁⲉⲣ⳿ⲥ⳿ⲫⲣⲁⲅⲓⲍⲓⲛ ⳿ⲙⲡⲁⲓⲟⲩⲧⲁϩ ⲛⲱⲟⲩ ⲉⲓ⳿ⲉϣⲉ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉϯ⳿ⲥⲡⲁⲛⲓ⳿ⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ϯⲥⲱⲟⲩⲛ ⲇⲉ ϫⲉ ⲁⲓⲛⲏⲟⲩ ϩⲁⲣⲱⲧⲉⲛ ⲁⲓⲛⲏⲟⲩ ϧⲉⲛ ⲟⲩⲙⲟϩ ⳿ⲛ⳿ⲥⲙⲟⲩ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ϯϯϩⲟ ⲟⲩⲛ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲛⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯ⳿ⲁⲅⲁⲡⲏ ⳿ⲛⲧⲉ ⲡⲓⲡ͞ⲛⲁ̅ ⳿ⲉ⳿ⲑⲣⲉⲧⲉⲛⲉⲣ⳿ⲁⲅⲱⲛⲓⲍⲉⲥⲑⲉ ⲛⲉⲙⲏⲓ ϧⲉⲛ ⲛⲉⲧⲉⲛ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱⲓ ϩⲁ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ϩⲓⲛⲁ ⳿ⲛⲧⲁⲛⲟϩⲉⲙ ⳿ⲉⲃⲟⲗ ϩⲁ ⲛⲏⲉⲧⲟⲓ ⳿ⲛⲁⲧⲥⲱⲧⲉⲙ ϧⲉⲛ ϯⲓⲟⲩⲇⲉ⳿ⲁ ⲟⲩⲟϩ ⲧⲁⲇⲓ⳿ⲁⲕⲟⲛⲓ⳿ⲁ ⳿ⲉ⳿ⲓⲗ̅ⲏ̅ⲙ̅ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ ⲉⲥϣⲏⲡ ⳿ⲉⲛⲓⲁⲅⲓⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ϩⲓⲛⲁ ⲁⲓϣⲁⲛ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩⲣⲁϣⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲉⲧⲉϩⲛⲉ ⲫϯ ⲟⲩⲟϩ ⳿ⲛⲧⲁ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲟⲓ ⲛⲉⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ⲫϯ ⲇⲉ ⳿ⲛⲧⲉ ϯϩⲓⲣⲏⲛⲏ ⳿ϥⲭⲏ ⲛⲉⲙⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲁⲙⲏⲛ ");
INSERT INTO copcnt_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ϯϯϩⲟ ⲇⲉ ⳿ⲙⲫⲟⲓⲃⲏ ⲧⲉⲛⲥⲱⲛⲓ ⲉⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲉⲧⲉ ⲟⲩⲣⲉϥϣⲉⲙϣⲓ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ ϯⲉⲕ⳿ⲕⲗⲏ ⲥⲓ⳿ⲁ ⲉⲧϧⲉⲛ ⲕⲉⲛⲭⲣⲉⲉⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϣⲟⲡⲥ ⳿ⲉⲣⲱⲧⲉⲛ ϧⲉⲛ Ⲡ⳪ ϧⲉⲛ ⳿ⲡⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉ ⲛⲏⲉⲑⲟⲩⲁⲃ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛϯⲧⲟⲧⲥ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲥⲛⲁⲉⲣ⳿ⲭ ⲣⲓⲁ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϧⲏⲧⲟⲩ ⲕⲉ ⲅⲁⲣ ⳿ⲛⲑⲟⲥ ϩⲱⲥ ⲁⲥϣⲱⲡⲓ ϧⲁϫⲉⲛ ⲟⲩⲙⲏϣ ⲡⲉⲙⲏⲓ ϩⲱ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ϣⲓⲛⲓ ⳿ⲉ⳿ⲡⲣⲓⲥⲕⲩⲗⲗⲁ ⲛⲉⲙ ⲁⲕⲩⲗⲗⲁ ⲛⲁ⳿ϣⲫⲏⲣ ⳿ⲛⲣⲉϥⲉⲣϩⲱⲃ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ⲛⲁⲓ ⲉⲧⲁⲩϯ ⳿ⲛⲧⲟⲩⲛⲁϩⲃⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲧⲁⲯⲩⲭⲏ ⲛⲁⲓ ⲉⲧⲉ ⳿ⲁⲛⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲛ ⲉⲧϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲟⲧⲟⲩ ⲁⲗⲗⲁ ⲛⲉⲙ ⲛⲓⲕⲉⲉⲕ⳿ⲕⲗⲏ ⲥⲓ⳿ⲁ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲛⲉⲙ ϯⲉⲕ⳿ⲕⲗⲏ ⲥⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲡⲟⲩⲏⲓ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ϣⲓⲛⲓ ⳿ⲉⲡⲉⲛⲉⲧⲟⲥ ⲡⲁⲁⲅⲁⲡⲏⲧⲟⲥ ⲉⲧⲉ ⳿ⲛⲑⲟϥ ⲡⲉ ϯⲁⲣⲭⲏ ⳿ⲛⲧⲉ ϯ⳿ⲁⲥⲓⲁ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ϣⲓⲛⲓ ⳿ⲉⲙⲁⲣⲓ⳿ⲁ ⲑⲏ ⲉⲧⲁⲥϭⲓ ⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ϧⲁⲣⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ϣⲓⲛⲓ ⳿ⲉⲁⲛ⳿ⲇⲣⲟⲛⲓⲕⲟⲥ ⲛⲉⲙ ⲓⲟⲩⲗⲓ⳿ⲁ ⲛⲁⲥⲩⲅⲅⲉⲛⲏ ⲥ ⲟⲩⲟϩ ⲛⲁ⳿ϣⲫⲏⲣ ⳿ⲛⲉⲭⲙⲁⲗⲱⲧⲟⲥ ⲉⲧⲉ ϩⲁⲛⲥⲟⲩⲓⲛ ⲛⲉ ϧⲉⲛ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲁⲓ ⲉⲧⲉ ϩⲁⲛϣⲟⲣⲡ ⳿ⲉⲣⲟⲓ ⲛⲉ ϧⲉⲛ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ϣⲓⲛⲓ ⳿ⲉⲁⲙ⳿ⲡⲗⲓⲁⲧⲟⲥ ⲡⲁⲁⲅⲁⲡⲏⲧⲟⲥ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ϣⲓⲛⲓ ⳿ⲉⲟⲩⲣⲃⲁⲛⲟⲥ ⲛⲉⲛ⳿ϣⲫⲏⲣ ⳿ⲛⲣⲉϥⲉⲣϩⲱⲃ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ⲛⲉⲙ ⳿ⲥⲧⲁⲭⲏⲥ ⲡⲁⲁⲅⲁⲡⲏⲧⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ϣⲓⲛⲓ ⳿ⲉⲁⲡⲉⲗⲗⲏⲥ ⲡⲓⲥⲱⲧⲡ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ϣⲓⲛⲓ ⳿ⲉⲛⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲁⲣⲓⲥⲧⲟⲃⲟⲩⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ϣⲓⲛⲓ ⳿ⲉⲏⲣⲱⲇⲓⲟⲛ ⲡⲁⲥⲩⲅⲅⲉⲛⲏⲥ ϣⲓⲛⲓ ⳿ⲉⲛⲏⲉⲧϣⲟⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁⲛⲁⲣⲕⲩⲥⲟⲥ ⲛⲏⲉⲧϣⲟⲡ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ϣⲓⲛⲓ ⳿ⲉ⳿ⲧⲣⲓⲫⲱⲛⲁ ⲛⲉⲙ ⳿ⲧⲣⲩⲫⲱⲥⲁ ⲛⲏⲉⲧϧⲟⲥⲓ ϧⲉⲛ Ⲡ⳪ ϣⲓⲛⲓ ⳿ⲉⲡⲉⲣⲥⲓⲇⲁ ϯⲙⲉⲛⲣⲓⲧ ⲑⲏ ⲉⲧⲁⲥϭⲓ ⲟⲩⲙⲏϣ ⳿ⲛϧⲓⲥⲓ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ϣⲓⲛⲓ ⳿ⲉⲣⲟⲩⲫⲟⲥ ⲡⲓⲥⲱⲧⲡ ϧⲉⲛ Ⲡ⳪ ⲛⲉⲙ ⲧⲉϥⲙⲁⲩ ⲟⲩⲟϩ ⲑⲱⲓ ϩⲱ ⲧⲉ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ϣⲓⲛⲓ ⳿ⲉⲁⲥⲩⲛ⳿ⲕⲣⲓⲧⲟⲥ ⲫⲗⲏⲅⲟⲛⲧ⳿ⲁ ⲉⲣⲙⲏ ⲡⲁⲧⲣⲟⲃⲁ ⲉⲣⲙⲁ ⲛⲉⲙ ⲛⲓⲕⲉ⳿ⲥⲛⲏⲟⲩ ⲉⲑⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ϣⲓⲛⲓ ⳿ⲉⲫⲩⲗⲟⲗⲟⲅⲟⲥ ⲛⲉⲙ ⲓⲟⲩⲗⲓ⳿ⲁ ⲛⲉⲣⲉⲁ ⲛⲉⲙ ⲧⲉϥⲥⲱⲛⲓ ⲛⲉⲙ ⲟⲩⲩⲙⲡⲁⲛ ⲛⲉⲙ ⲛⲓⲁⲅⲓⲟⲥ ⲧⲏⲣⲟⲩ ⲉⲑⲛⲉⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ⲁⲣⲓ⳿ⲁⲥⲡⲁⲍⲉⲥⲑⲉ ⳿ⲛⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ϧⲉⲛ ⲟⲩⲫⲓ ⲉⲥⲟⲩⲁⲃ ⲥⲉϣⲓⲛⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲛⲓⲉⲕ⳿ⲕⲗⲏ ⲥⲓ⳿ⲁ ⲧⲏⲣⲟⲩ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ϯϯϩⲟ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲉⲑⲣⲉⲧⲉⲛ ϯ⳿ϩⲑⲏⲧⲉⲛ ⳿ⲉⲛⲏⲉⲧ⳿⳿ⲓⲣⲓ ⳿ⲛⲛⲓⲫⲱⲣϫ ⲛⲉⲙ ⲛⲓ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲥⲁⲃⲟⲗ ⳿ⲛϯ⳿ⲥⲃⲱ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲧⲥⲁⲃⲟ ⳿ⲉⲣⲟⲥ ⲟⲩⲟϩ ⲣⲉⲕ ⲑⲏⲛⲟⲩ ⲥⲁⲃⲟⲗ ⳿ⲙⲙⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ⲛⲁⲓ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲥⲉⲟⲓ ⳿ⲙⲃⲱⲕ ⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲁⲗⲗⲁ ⳿ⲛⲧⲟⲩⲛⲉϫⲓ ⲟⲩⲟϩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲧⲟⲩϫⲓⲛⲥⲁϫⲓ ⲉⲧϩⲟⲗϫ ⲛⲉⲙ ⲡⲟⲩ⳿ⲥⲙⲟⲩ ϣⲁⲩⲉⲣϩⲁⲗ ⳿ⲙ⳿ⲡϩⲏⲧ ⳿ⲛⲛⲓⲁⲧⲕⲁⲕⲓⲁ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ⲧⲉⲧⲉⲛⲙⲉⲧⲣⲉϥⲥⲱⲧⲉⲙ ⲅⲁⲣ ⲁⲥϣⲉ ⲛⲁⲥ ϣⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϯⲣⲁϣⲓ ⲟⲩⲛ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲥⲁⲃⲉ ϧⲉⲛ ⲡⲓⲡⲉⲑⲛⲁⲛⲉϥ ⲁⲕⲉⲣⲉⲟⲥ ⲇⲉ ⳿ⲉⲡⲓⲡⲉⲧϩⲱⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ⲫϯ ⲇⲉ ⳿ⲛⲧⲉ ϯϩⲓⲣⲏⲛⲏ ⲉϥ⳿ⲉϧⲟⲙϧⲉⲙ ⳿ⲙ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ϧⲁ ⲛⲉⲧⲉⲛϭⲁⲗⲁⲩϫ ⳿ⲛⲭⲱⲗⲉⲙ ⳿ⲡ⳿ϩⲙⲟⲧ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲛⲉⲙⲱⲧⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","⳿ϥϣⲓⲛⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲧⲓⲙⲟⲑⲉⲟⲥ ⲡⲁ⳿ϣⲫⲏ ⲣ ⳿ⲛⲣⲉϥⲉⲣϩⲱⲃ ⲛⲉⲙ ⲗⲟⲩⲕⲓⲟⲥ ⲛⲉⲙ ⲓⲁⲥⲥⲱⲛ ⲛⲉⲙ ⲥⲱⲥⲓⲡⲁⲧⲣⲟⲥ ⲡⲁⲥⲩⲅⲅⲉⲛⲏⲥ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ϯϣⲓⲛⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲁⲛⲟⲕ ⲧⲉⲣⲧⲓⲟⲥ ⲫⲏⲉⲧⲁϥ⳿ⲥϧⲉ ⲧⲁⲓ⳿ⲉⲡⲓⲥⲧⲟⲗⲏ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","⳿ϥϣⲓⲛⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲅⲁⲓⲟⲥ ⲡⲁϣⲉⲙⲙⲟ ⲛⲉⲙ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲧⲏⲣⲥ ⳿ϥϣⲓⲛⲓ ⳿ⲉⲣⲱⲧⲉⲛ ⳿ⲛϫⲉ ⲁⲣⲁⲥⲧⲟⲥ ⲡⲓⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ϯⲡⲟⲗⲓⲥ ⲛⲉⲙ ⲕⲟⲩⲁⲣⲧⲟⲥ ⲡⲓⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ⲡⲏⲙⲟⲧ ⲙⲡⲉⲛⲝⲥ ⲓ̅ⲥ ⲡⲋⲥ ⲛⲉⲙⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲁⲙⲏⲛ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲧⲁϫⲣⲉ ⲑⲏⲛⲟⲩ ⲕⲁⲧⲁ ⲡⲁⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲛⲉⲙ ⲡⲓϩⲓⲱⲓϣ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲕⲁⲧⲁ ⲟⲩϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲟⲩⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲉⲁⲩⲭⲁⲣⲱⲟⲩ ⳿ⲉⲣⲟϥ ⳿ⲉϩⲁⲛⲥⲏ ⲟⲩ ⳿ⲛⲉⲛⲉϩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ϯⲛⲟⲩ ⲇⲉ ⲁϥⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲛⲓ⳿ⲅⲣⲁⲫⲏ ⳿ⲛⲧⲉ ⲛⲓⲡⲣⲟⲫⲏⲧⲏⲥ ⲕⲁⲧⲁ ⲡⲓⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲛⲧⲉ ⲫϯ ⲡⲓϣⲁ ⲉⲛⲉϩ ⳿ⲉⲁⲩⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ⲉⲩⲥⲱⲧⲉⲙ ⳿ⲛⲧⲉ ⳿ⲫⲛⲁϩϯ ϧⲉⲛ ⲛⲓⲉⲑⲛⲟⲥ ⲧⲏⲣⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲡⲓⲥⲁⲃⲉ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲫⲁⲓ ⲉⲧⲉ ⲫⲱϥ ⲡⲉ ⲡⲓⲱⲟⲩ ϣⲁ ⲉⲛⲉϩ ⳿ⲛⲧⲉ ⲛⲓⲉⲛⲉϩ ⲁⲙⲏⲛ ⳿ⲡⲣⲟⲥ ⲣⲱⲙⲉⲟⲥ ⲁⲩ⳿ⲥϧⲏⲧⲥ ϧⲉⲛ ⲕⲟⲣⲓⲛⲑⲟⲥ ⲁⲩⲟⲩⲟⲣⲡⲥ ϩⲓⲧⲉⲛ ⲫⲟⲓⲃⲏ ϯⲥⲱⲛⲓ ");
INSERT INTO copcnt_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ⲡⲁⲩⲗⲟⲥ ⳿ⲡⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲉⲧⲑⲁϩⲉⲙ ⳿ⲛⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲫϯ ⲛⲉⲙ ⲥⲱⲥⲑⲉⲛⲏⲥ ⲡⲓⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","⳿ⲛϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲫϯ ⲑⲏⲉⲧϣⲟⲡ ϧⲉⲛ ⲕⲟⲣⲓⲛⲑⲟⲥ ⲛⲏⲉⲧⲁⲩⲧⲟⲩⲃⲱⲟⲩ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲛⲏⲉⲧⲑⲁϩⲉⲙ ⲉⲑⲟⲩⲁⲃ ⲛⲉⲙ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲉⲑⲙⲟⲩϯ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲛⲧⲱⲟⲩ ⲛⲉⲙ ⳿ⲛⲧⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","⳿ⲡ⳿ϩⲙⲟⲧ ⲛⲱⲧⲉⲛ ⲛⲉⲙ ⳿ⲧϩⲓⲣⲏⲛⲏ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲡⲉⲛⲓⲱⲧ ⲛⲉⲙ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ϯϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉⲛ ⲡⲁⲛⲟⲩϯ ⳿ⲛⲥⲏⲟⲩ ⲛⲓⲃⲉⲛ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉϫⲉⲛ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲁⲩⲧⲏⲓϥ ⲛⲱⲧⲉⲛ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ϫⲉ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲧⲉⲧⲉⲛⲉⲣⲣⲁⲙⲁ⳿ⲟ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧϥ ϧⲉⲛ ⲥⲁϫⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⳿ⲉⲙⲓ ⲛⲓⲃⲉⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲁ ϯⲙⲉⲧⲙⲉⲑⲣⲉ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲧⲁϫⲣⲟ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⳿ⲛⲧⲉⲧⲉⲛϣⲁⲧ ⲁⲛ ϧⲉⲛ ⳿ϩⲗⲓ ⳿ⲛ⳿ϩⲙⲟⲧ ⲉⲣⲉⲧⲉⲛϫⲟⲩϣⲧ ⳿ⲉⲃⲟⲗ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ⲫⲁⲓ ⲉⲧⲉ ⲉϥ⳿ⲉⲧⲁϫⲣⲉ ⲑⲏⲛⲟⲩ ϣⲁ ⳿ⲉⲃⲟⲗ ⳿ⲛⲁⲧⲁⲣⲓⲕⲓ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","⳿ϥⲉⲛϩⲟⲧ ⳿ⲛϫⲉ ⲫϯ ⲫⲏⲉⲧⲁϥⲑⲁϩⲉⲙ ⲑⲏⲛⲟⲩ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲙⲉⲧ⳿ϣⲫⲏⲣ ⳿ⲛⲧⲉ ⲡⲉϥϣⲏⲣⲓ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪. ");
INSERT INTO copcnt_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ϯϯϩⲟ ⲇⲉ ⳿ⲉⲣⲱⲧⲉⲛ ⲛⲁⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ϩⲓⲛⲁ ⲟⲩⲥⲁϫⲓ ⳿ⲛⲟⲩⲱⲧ ⲉⲣⲉⲧⲉⲛϫⲱ ⳿ⲙⲙⲟϥ ⲧⲏⲣⲟⲩ ⲟⲩⲟϩ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ϩⲁⲛⲫⲱⲣϫ ϣⲱⲡⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⲇⲉ ⲉⲣⲉⲧⲉⲛⲥⲉⲃⲧⲱⲧ ϧⲉⲛ ⲟⲩϩⲏⲧ ⳿ⲛⲟⲩⲱⲧ ⲛⲉⲙ ⲟⲩ⳿ⲅⲛⲱⲙⲏ ⳿ⲛⲟⲩⲱⲧ. ");
INSERT INTO copcnt_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ⲁⲩⲧⲁⲙⲟⲓ ⲅⲁⲣ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲛⲁ⳿ⲭⲗⲟⲏⲥ ϫⲉ ⲟⲩⲟⲛ ϩⲁⲛ⳿ϣϭⲛⲏⲛ ϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ⲫⲁⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟϥ ϫⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲉϥϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⳿ⲁⲛⲟⲕ ⲫⲁ ⲡⲁⲩⲗⲟⲥ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲫⲁ ⲁⲡⲟⲗⲗⲱ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲫⲁ ⲕⲏⲫⲁ ⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲁⲛⲟⲕ ⲫⲁ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ⲁⲩⲫⲉϣ Ⲡⲭ̅ⲥ̅ ⲙⲏ ⲡⲁⲩⲗⲟⲥ ⲁⲩⲁϣϥ ⳿ⲉϫⲉⲛ ⲑⲏⲛⲟⲩ ⲓⲉ ⲁⲛ ⲁⲣⲉⲧⲉⲛϭⲓⲱⲙⲥ ⳿ⲉ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲁⲩⲗⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ϯϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉⲛ ⲡⲁⲛⲟⲩϯ ϫⲉ ⳿ⲙⲡⲓϯⲱⲙⲥ ⳿ⲛ⳿ϩⲗⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲃⲏⲗ ⳿ⲉ⳿ⲕⲣⲓⲥⲡⲟⲥ ⲛⲉⲙ ⲅⲁⲓⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲟⲩⲁⲓ ϫⲟⲥ ϫⲉ ⲁⲣⲉⲧⲉⲛ ϭ- ⲓⲱⲙⲥ ⳿ⲉⲡⲁⲣⲁⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ⲁⲓϯⲱⲙⲥ ⲇⲉ ⳿ⲙⲡⲓⲕⲉⲏⲓ ⳿ⲛ⳿ⲥⲧⲉⲫⲁⲛⲁ ⲗⲟⲓⲡⲟⲛ ⳿ⲛϯ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲁⲛ ⲁⲓϯⲱⲙⲥ ⳿ⲛⲕⲉⲟⲩⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ⲛⲉⲧⲁϥⲧⲁⲟⲩⲟⲓ ⲅⲁⲣ ⲁⲛ ⳿ⲛϫⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲉϯⲱⲙⲥ ⲁⲗⲗⲁ ⳿ⲉϩⲓϣⲉⲛⲛⲟⲩϥⲓ ϧⲉⲛ ⲟⲩ⳿ⲥⲃⲱ ⳿ⲛⲥⲁϫⲓ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙϣⲱⲡⲓ ⲉϥϣⲟⲩⲓⲧ ⳿ⲛϫⲉ ⲡⲓ⳧ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ⲡⲓⲥⲁϫⲓ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲡⲓ⳧ ⳿ⲛⲧⲉⲛ ⲛⲏ ⲙⲉⲛ ⲉⲑⲛⲁⲧⲁⲕⲟ ⲟⲩⲙⲉⲧⲥⲟϫ ⲡⲉ ⲛⲁⲛ ⲇⲉ ⳿ⲁⲛⲟⲛ ϧⲁ ⲛⲏⲉⲑⲛⲁⲛⲟϩⲉⲙ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ϯⲛⲁⲧⲁⲕⲟ ⳿ⲛ⳿ⲧⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲛⲓⲥⲁⲃⲉⲩ ⲟⲩⲟϩ ⳿ⲡ⳿ⲉⲙⲓ ⳿ⲛⲧⲉ ⲛⲓⲕⲁⲧϩⲏⲧ ϯⲛⲁϣⲟϣϥ. ");
INSERT INTO copcnt_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ⲁϥⲑⲱⲛ ⲟⲩⲥⲁⲃⲉ ⲁϥⲑⲱⲛ ⲟⲩⲥⲁϧ ⲁϥⲑⲱⲛ ⲟⲩⲣⲉϥϧⲟⲧϧⲉⲧ ⳿ⲛⲧⲉ ⲡⲁⲓⲉⲛⲉϩ ⲙⲏ ⳿ⲙⲡⲉ ⲫϯ ⲉⲣ ⳿ⲧⲥⲟⲫⲓ⳿ⲁ ⲛ̇ⲧⲉ ⲡⲁⲓ ⲕⲟⲥⲙⲟⲥ ⳿ⲛⲥⲟϫ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","⳿ⲉⲡⲓⲇⲏ ⲅⲁⲣ ϧⲉⲛ ϯⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲙⲡⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲥⲟⲩⲉⲛ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲥⲟⲫⲓ⳿ⲁ ⲁϥϯⲙⲁϯ ⳿ⲛϫⲉ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ϯⲙⲉⲧⲥⲟϫ ⳿ⲛⲧⲉ ⲡⲓϩⲓⲱⲓϣ ⳿ⲉⲛⲟϩⲉⲙ ⳿ⲛⲛⲏⲉⲑⲛⲁϩϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ⲉⲡⲓⲇⲏ ⲛⲓⲕⲉⲓⲟⲩⲇⲁⲓ ⲥⲉⲉⲣⲉⲧⲓⲛ ⳿ⲛϩⲁⲛⲙⲏⲓⲛⲓ ⲟⲩⲟϩ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲥⲉⲕⲱϯ ⳿ⲛⲥⲁ ⲟⲩⲥⲟⲫⲓ⳿ⲁ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","⳿ⲁⲛⲟⲛ ⲇⲉ ⲧⲉⲛϩⲓⲱⲓϣ ⳿ⲙⲠⲭ̅ⲥ̅ ⳿ⲉⲁⲩⲁϣϥ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲙⲉⲛ ⲟⲩ⳿ⲥⲕⲁⲛⲇⲁⲗⲟⲛ ⲛⲱⲟⲩ ⲡⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲇⲉ ⲟⲩⲙⲉⲧⲥⲟϫ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ⲛⲁⲛ ⲇⲉ ⳿ⲁⲛⲟⲛ ϧⲁ ⲛⲏⲉⲑⲛⲁⲛⲟϩⲉⲙ ⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ Ⲡⲭ̅ⲥ̅ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲫϯ ⲡⲉ ⲛⲉⲙ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ϫⲉ ϯⲙⲉⲧⲥⲟϫ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲥⲟⲓ ⳿ⲛⲥⲁⲃⲉ ⳿ⲉϩⲟⲧⲉ ⲛⲓⲣⲱⲙⲓ ⲟⲩⲟϩ ϯⲙⲉⲧⲁⲥⲑⲏⲛⲏⲥ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲥⲟⲓ ⳿ⲛϫⲱⲣⲓ ⲉϩⲟⲧⲉ ⲛⲓⲣⲱⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","⳿ⲁⲛⲁⲩ ⲅⲁⲣ ⳿ⲉⲡⲉⲧⲉⲛⲑⲱϩⲉⲙ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⳿ⲙⲙⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲥⲁⲃⲉ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⳿ⲙⲙⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛϫⲱⲣⲓ ⳿ⲙⲙⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲉⲩⲅⲉⲛⲏⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ⲁⲗⲗⲁ ⲛⲓⲥⲟϫ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁϥⲥⲟⲧⲡⲟⲩ ⳿ⲛϫⲉ ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϯϣⲓⲡⲓ ⳿ⲛⲛⲓⲥⲁⲃⲉⲩ ⲟⲩⲟϩ ⲛⲓⲙⲉⲧϫⲱⲃ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲁϥⲥⲟⲧⲡⲟⲩ ⳿ⲛϫⲉ ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥϯϣⲓⲡⲓ ⳿ⲛⲛⲓϫⲱⲣⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ⲟⲩⲟϩ ⲛⲓⲙⲉⲧⲁⲅⲉⲛⲏⲥ ⳿ⲛⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲉⲙ ⲛⲏ ⲉⲧϣⲟϣϥ ⲁϥⲥⲟⲧⲡⲟⲩ ⳿ⲛϫⲉ ⲫϯ ⲛⲉⲙ ⲛⲏ ⲉⲧⲉ⳿ⲛⲥⲉϣⲟⲡ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲕⲱⲣϥ ⳿ⲛⲛⲏⲉⲧϣⲟⲡ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ϩⲟⲡⲱⲥ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⲥⲁⲣⲝ ⲛⲓⲃⲉⲛ ϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲱⲟⲩ ⳿ⲙⲡⲉ⳿ⲙⲑⲟ ⳿ⲙⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⲇⲉ ⳿ⲙⲙⲟϥ ϩⲱⲧⲉⲛ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲫⲏⲉⲧⲁϥϣⲱⲡⲓ ⲛⲁⲛ ⳿ⲛⲟⲩⲥⲟⲫⲓ⳿ⲁ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲟⲩⲙⲉⲑⲙⲏⲓ ⲛⲉⲙ ⲟⲩⲧⲟⲩⲃⲟ ⲛⲉⲙ ⲟⲩⲥⲱϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ϩⲓⲛⲁ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲡⲉⲧϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟϥ ⲙⲁⲣⲉϥϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟϥ ϧⲉⲛ Ⲡ⳪. ");
INSERT INTO copcnt_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ⲟⲩⲟϩ ⳿ⲁⲛⲟⲕ ϩⲱ ⲉⲧⲁⲓ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲛⲉⲧⲁⲓ⳿ⲓ ⲁⲛ ⲕⲁⲧⲁ ⲟⲩϭⲓⲥⲓ ⳿ⲛⲧⲉ ⲟⲩⲥⲁϫⲓ ⲓⲉ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⲉⲓⲧⲁⲙⲟ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲡⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","⳿ⲙⲡⲓϯϩⲁⲡ ⲅⲁⲣ ⳿ⲉ⳿ⲉⲙⲓ ⳿⳿ⲛ⳿ϩⲗⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲒⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲟⲩⲟϩ ⲫⲁⲓ ⳿ⲉⲁⲩⲁϣϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","⳿ⲁⲛⲟⲕ ϩⲱ ϧⲉⲛ ⲟⲩⲙⲉⲧⲁⲥⲑⲉⲛⲏⲥ ⲛⲉⲙ ⲟⲩϩⲟϯ ⲛⲉⲙ ⲟⲩ⳿ⲥⲑⲉⲣⲧⲉⲣ ⳿ⲉⲛⲁϣⲱϥ ⲁⲓ⳿ⲓ ϩⲁⲣⲱⲧⲉⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ⲟⲩⲟϩ ⲡⲁⲥⲁϫⲓ ⲛⲉⲙ ⲡⲁϩⲓⲱⲓϣ ⲛⲁϥϧⲉⲛ ϩⲁⲛⲑⲱⲧ ⳿ⲛϩⲏⲧ ⲁⲛ ⳿ⲛⲧⲉ ϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲣⲱⲙⲓ ⲁⲗⲗⲁ ϧⲉⲛ ⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲧⲉ ⲟⲩⲡⲛ̅ⲁ̅ ⲛⲉⲙ ⲟⲩϫⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ϩⲓⲛⲁ ⲡⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙϣⲱⲡⲓ ϧⲉⲛ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲣⲱⲙⲓ ⲁⲗⲗⲁ ϧⲉⲛ ⲟⲩϫⲟⲙ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ⲟⲩⲥⲟⲫⲓⲁ ⲇⲉ ⲡⲉⲧⲉⲛⲥⲁϫⲓ ⳿ⲙⲙⲟⲥ ϧⲉⲛ ⲛⲏ ⲉⲧϫⲏⲕ ⳿ⲉⲃⲟⲗ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⲇⲉ ⳿ⲛⲑⲁ ⲡⲁⲓⲉⲛⲉϩ ⲁⲛ ⲧⲉ ⲟⲩⲇⲉ ⳿ⲛⲑⲁ ⲛⲓⲁⲣⲭⲱⲛ ⲁⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲉⲛⲉϩ ⲛⲁⲓ ⲉⲑⲛⲁⲕⲱⲣϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ⲁⲗⲗⲁ ⲟⲩⲥⲟⲫⲓ⳿ⲁ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲉⲛⲥⲁϫⲓ ⳿ⲙⲙⲟⲥ ϧⲉⲛ ⲟⲩⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⲑⲏⲉⲧϩⲏⲡ ⲑⲏ - ⲉⲧⲁϥⲉⲣϣⲟⲣⲡ ⳿ⲛⲑⲁϣⲥ ⳿ⲛϫⲉ ⲫϯ ϧⲁϫⲱⲟⲩ ⳿ⲛⲛⲓⲉⲛⲉϩ ⳿ⲉⲟⲩⲱⲟⲩ ⲛⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ⲑⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲛⲛⲓⲁⲣⲭⲱⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲉⲛⲉϩ ⲥⲟⲩⲱⲛⲥ ⳿ⲉⲛⲉ ⲁⲩⲥⲟⲩⲱⲛⲥ ⲅⲁⲣ ⲛⲁⲩⲛⲁⲉϣ Ⲡ⳪ ⳿ⲛⲧⲉ ⳿ⲡⲱⲟⲩ ⲁⲛ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ⲁⲗⲗⲁ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϫⲉ ⲛⲏ⳿ⲉⲧⲉ ⳿ⲙⲡⲉ ⲃⲁⲗ ⲛⲁⲩ ⳿ⲉⲣⲱⲟⲩ ⲟⲩⲇⲉ ⳿ⲙⲡⲉ ⲙⲁϣϫ ⲥⲟⲑⲙⲟⲩ ⲟⲩⲇⲉ ⳿ⲙⲡⲟⲩϣⲉ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⳿ⲡϩⲏⲧ ⳿ⲛⲣⲱⲙⲓ ⲛⲏⲉⲧⲁ ⲫϯ ⲥⲉⲃⲧⲱⲧⲟⲩ ⳿ⲛⲛⲏ ⲉⲑⲛⲁⲙⲉⲛⲣⲓⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","⳿ⲁⲛⲟⲛ ⲅⲁⲣ ⲁϥϭⲟⲣⲡⲟⲩ ⲛⲁⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϫⲉ ⲫϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲡⲓⲡⲛ̅ⲁ̅ ⲡⲓⲡⲛ̅ⲁ̅ ⲅⲁⲣ ⳿ϥϧⲟⲧϧⲉⲧ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲛⲉⲙ ⲛⲏⲉⲧϣⲏⲕ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ⲛⲓⲙ ⲅⲁⲣ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲉⲧⲥⲱⲟⲩⲛ ⳿ⲛⲛⲁ ⲡⲓⲣⲱⲙⲓ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲉⲧϣⲟⲡ ⳿ⲛϧⲏⲧϥ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲛⲁ ⲫϯ ⳿ⲙⲡⲉ ⳿ϩⲗⲓ ⳿ⲉⲙⲓ ⳿ⲉⲣⲱⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","⳿ⲁⲛⲟⲛ ⲇⲉ ⲡⲓⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲁⲛ ⲡⲉⲧⲁⲛϭⲓⲧϥ ⲁⲗⲗⲁ ⲡⲓⲡⲛ̅ⲁ̅ ⲡⲓ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲫϯ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛ⳿ⲉⲙⲓ ⳿ⲉⲛⲏⲉⲧⲁ ⲫϯ ⲧⲏⲓⲧⲟⲩ ⲛⲁⲛ ⳿ⲛ⳿ϩⲙⲟⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ⲉⲧⲉ ⲛⲁⲓ ⲛⲉ ⲉⲧⲉⲛⲥⲁϫⲓ ⳿ⲙⲙⲱⲟⲩ ϧⲉⲛ ϩⲁⲛⲙⲉⲧⲣⲉϥϯ⳿ⲥⲃⲱ ⳿ⲛⲛⲓⲣⲱⲙⲓ ⲁⲛ ⳿ⲛⲧⲉ ϩⲁⲛⲥⲁϫⲓ ⳿ⲛⲥⲟⲫⲓ⳿ⲁ ⲁⲗⲗⲁ ϧⲉⲛ ϩⲁⲛⲙⲉⲧⲣⲉϥϯ ⳿ⲥⲃⲱ ⳿ⲛⲧⲉ ⲡⲓⲡⲛ̅ⲁ̅ ⲉⲛⲉⲣⲥⲩⲛ⳿ⲕⲣⲓⲛⲓⲛ ⳿ⲛϩⲁⲛⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲛ ⳿ⲛⲛⲓⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ⲡⲓⲯⲩⲭⲓⲕⲟⲥ ⲇⲉ ⳿ⲛⲣⲱⲙⲓ ⳿ⲙⲡⲁϥϣⲉⲡ ⲛⲁ ⲡⲓⲡⲛ̅ⲁ̅ ⲫϯ ⳿ⲉⲣⲟϥ ⲟⲩⲙⲉⲧⲥⲟϫ ⲅⲁⲣ ⲛⲁϥ ⲡⲉ ⲟⲩⲟϩ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉ⳿ⲉⲙⲓ ϫⲉ ⲁⲩϧⲟⲧϧⲉⲧ ⳿ⲙⲙⲟϥ ⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ⲡⲓⲡⲛ̅ⲁ̅ⲧⲓⲕⲱⲥ ⲇⲉ ⳿ⲛⲑⲟϥ ϣⲁϥϧⲉⲧϧⲉⲧ ⳿ⲛⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ⲙⲡⲁⲣⲉ ⳿ϩⲗⲓ ⳿ϣϧⲉⲧϧⲱⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ⲛⲓⲙ ⲅⲁⲣ ⲡⲉⲧⲁϥ⳿ⲉⲙⲓ ⳿ⲉ⳿ⲡϩⲏⲧ ⳿ⲙⲠ⳪ ⳿ⲙⲙⲟⲛ ⲛⲓⲙ ⲉⲑⲛⲁ⳿ϣⲧⲥⲁⲃⲟϥ ⳿ⲁⲛⲟⲛ ⲇⲉ ⳿ⲡϩⲏⲧ ⳿ⲙⲠⲭ̅ⲥ̅ ⲡⲉⲧⲉⲙⲙⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","⳿Ⲁⲛⲟⲕ ⲇⲉ ϩⲱ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⳿ⲙⲡⲓ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲉⲥⲁϫⲓ ⲛⲉⲙⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲥ ⲁⲗⲗⲁ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲥⲁⲣⲕⲓⲕⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲛ⳿ⲁⲗⲱⲟⲩ⳿ⲓ ϧⲉⲛ Ⲡⲭ̅ⲥ̅.̅. ");
INSERT INTO copcnt_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ⲁⲓ⳿ⲧⲥⲉ ⲑⲏⲛⲟⲩ ⳿ⲛⲟⲩⲉⲣⲱϯ ⳿ⲛⲟⲩ⳿ϧⲣⲉ ⲁⲛ ⲧⲉ ⲛⲉ ⳿ⲙⲡⲁⲧⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⲅⲁⲣ ⲡⲉ ⲁⲗⲗⲁ ⲟⲩⲇⲉ ϯⲛⲟⲩ ⲟⲛ ⳿ⲙⲡⲁⲧⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⲉⲧⲓ ⲅⲁⲣ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲥⲁⲣⲕⲓⲕⲟⲥ .. ");
INSERT INTO copcnt_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ϩⲱⲥ ⲅⲁⲣ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲭⲟϩ ⲛⲉⲙ ⲟⲩ⳿ϣϭⲛⲏⲛ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲙⲏ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲥⲁⲣⲕⲓⲕⲟⲥ ⲁⲛ ⲟⲩⲟϩ ⲁⲣⲉⲧⲉⲛⲙⲟϣⲓ ⲕⲁⲧⲁ ⲣⲱⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ⲉϣⲱⲡ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϫⲟⲥ ϫⲉ ⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⳿ⲁⲛⲟⲕ ⲫⲁ ⲡⲁⲩⲗⲟⲥ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ϫⲉ ⳿ⲁⲛⲟⲕ ⲫⲁ ⲁⲡⲟⲗⲗⲱ ⲟⲩⲭⲓ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲣⲱⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ⲟⲩ ⲟⲩⲛ ⲡⲉ ⲁⲡⲟⲗⲗⲱ ⲟⲩ ⲇⲉ ⲡⲉ ⲡⲁⲩⲗⲟⲥ ϩⲁⲛⲇⲓ⳿ⲁⲕⲱⲛ ⲛⲉ ⳿ⲉⲁⲣⲉⲧⲉⲛⲛⲁϩϯ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲁ Ⲡ⳪ ϯ ⲛⲁϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","⳿ⲁⲛⲟⲕ ⲁⲓⲧⲱϫⲓ ⲁⲡⲟⲗⲗⲱ ⲁϥ⳿ⲧⲥⲟ ⲁⲗⲗⲁ ⲫϯ ⲁϥ⳿ⲑⲣⲟⲩⲁⲓⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ϩⲱⲥⲧⲉ ⲟⲩⲇⲉ ⲫⲏⲉⲧⲧⲱϫⲓ ⲟⲩⲇⲉ ⲫⲏⲉⲧ⳿ⲧⲥⲟ ⳿ϩⲗⲓ ⲡⲉ ⲁⲗⲗⲁ ⲫϯ ⲉⲧ⳿ⲑⲣⲟ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲁⲓⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ⲫⲏ ⲇⲉ ⲉⲧⲧⲱϫⲓ ⲛⲉⲙ ⲫⲏⲉⲧⲥⲟ ⲟⲩⲁⲓ ⲛⲉ ⲡⲓⲟⲩⲁⲓ ⲇⲉ ⲡⲓⲟⲩⲁⲓ ⳿ϥⲛⲁϭⲓ ⳿ⲙⲡⲉϥⲃⲉⲭⲉ ⲕⲁⲧⲁ ⲡⲉϥϧⲓⲥⲓ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","⳿ⲁⲛⲟⲛ ϩⲁⲛ⳿ϣⲫⲏⲣ ⲅⲁⲣ ⳿ⲛⲣⲉϥⲉⲣϩⲱⲃ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲓⲉⲫⲟⲩⲱⲓ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲛⲑⲱⲧⲉⲛ ⲟⲩⲕⲱⲧ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ⲕⲁⲧⲁ ⲡⲓ⳿ϩⲙⲟⲧ ⳿ⲛⲧⲉ ⲫϯ ⲉⲧⲧⲟⲓ ⲛⲏⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲥⲁⲃⲉ ⳿ⲛⲁⲣⲭⲏⲧⲉⲕⲧⲱⲛ ⲁⲓⲭⲱ ⳿ⲛⲟⲩⲥⲉⲛϯ ⳿ⲉ⳿ϧⲣⲏⲓ ⲕⲉⲟⲩⲁⲓ ⲡⲉⲑⲟⲩⲁϩⲉⲙ ⲕⲱⲧ ⲡⲓⲟⲩⲁⲓ ⲇⲉ ⲡⲓⲟⲩⲁⲓ ⲙⲁⲣⲉϥⲥⲟⲙⲥ ϫⲉ ⲁϥⲕⲱⲧ ⳿ⲛⲁϣ ⳿ⲛⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ⲕⲉⲥⲉⲛϯ ⲅⲁⲣ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲛⲧⲉ ⲕⲉⲟⲩⲁⲓ ⲭⲁⲥ ⳿ⲉ⳿ϧⲣⲏⲓ ⲥⲁⲃⲟⲗ ⳿ⲛⲑⲏⲉⲧⲭⲏ ⲉⲧⲉ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ⲓⲥϫⲉ ⲟⲩⲟⲛ ⲡⲉⲧⲕⲱⲧ ⳿ⲉϫⲉⲛ ⲧⲁⲓⲥⲉⲛϯ ⲛⲟⲩⲃ ϩⲁⲧ ⲁⲛⲁⲙⲏⲓ ⲣⲱⲕϩ ⲥⲱⲟⲩⲃⲉⲛ ⲣⲱⲟⲩ⳿ⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","⳿ⲡϩⲱⲃ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲉϥ⳿ⲛⲁⲟⲩⲱⲛϩ ⳿ⲉⲃⲟⲗ ⲡⲓ⳿ⲉϩⲟⲟⲩ ⲅⲁⲣ ⳿ϥⲛⲁⲟⲩⲟⲛϩϥ ⳿ⲉⲃⲟⲗ ϫⲉ ⳿ϥⲛⲁϭⲱⲣⲡ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩ⳿ⲭⲣⲱⲙ ⲟⲩⲟϩ ⳿ⲡϩⲱⲃ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲡⲓ⳿ⲭⲣⲱⲙ ⲉⲑ- ⲛⲁⲉⲣⲇⲟⲕⲓⲙⲁⲍⲓⲛ ⳿ⲙⲙⲟϥ ϫⲉ ⲟⲩⲁϣ ⳿ⲛⲣⲏϯ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ⲫⲏ ⲇⲉ ⲉⲧⲉ ⲡⲉϥϩⲱⲃ ⲛⲁⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲉⲧⲁϥⲕⲟⲧϥ ⳿ϥⲛⲁϭⲓ ⳿ⲙⲡⲉϥⲃⲉⲭⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ⲫⲏ ⲇⲉ ⲉⲧⲉ ⲡⲉϥϩⲱⲃ ⲛⲁⲣⲱⲕϩ ⳿ϥⲛⲁϯⲟⲥⲓ ⳿ⲛⲑⲟϥ ⲇⲉ ⳿ϥⲛⲁⲛⲟϩⲉⲙ ⲡⲁⲓⲣⲏϯ ⲇⲉ ϩⲱⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩ⳿ⲭⲣⲱⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲟⲩⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ ⲫϯ ⲟⲩⲟϩ ⲡⲓⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲫϯ ⲁϥϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ⲫⲏ ⲟⲩⲛ ⲉⲑⲛⲁⲥⲉϥ ⲡⲓⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ ⲫϯ ⲫⲁⲓ ⲫϯ ⲛⲁⲧⲁⲕⲟϥ ⲡⲓⲉⲣⲫⲉⲓ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⳿ϥⲟⲩⲁⲃ ⲉⲧⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ϩⲗⲓ ⲉⲣϩⲁⲗ ⳿ⲙⲙⲟϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲫⲏ ⲉⲑⲙⲉⲩ⳿ⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϫⲉ ⲟⲩⲥⲁⲃⲉ ⲡⲉ ϧⲉⲛ ⲡⲁⲓⲉⲛⲉϩ ⲙⲁⲣⲉϥⲉⲣⲥⲟϫ ϩⲓⲛⲁ ⳿ⲛⲧⲉϥⲉⲣⲥⲁⲃⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ϯⲥⲟⲫⲓ⳿ⲁ ⲅⲁⲣ ⳿ⲙⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲙⲉⲧⲥⲟϫ ⲧⲉ ⲛⲁϩⲣⲉⲛ ⲫϯ ⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϫⲉ ⲫⲏⲉⲧⲁⲙⲁϩⲓ ⳿ⲛⲛⲓⲥⲁⲃⲉⲩ ϧⲉⲛ ⲧⲟⲩⲙⲉⲧⲥⲉⲃ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ϫⲉ Ⲡ⳪ ⲥⲱⲟⲩⲛ ⳿ⲛⲛⲓⲙⲟⲕⲙⲉⲕ ⳿ⲛⲧⲉ ϩⲁⲛⲥⲁⲃⲉⲩ ϫⲉ ϩⲁⲛⲉⲫⲗⲏⲟⲩ ⲛⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ϩⲱⲥⲧⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ϩⲗⲓ ϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲛⲓⲣⲱⲙⲓ ⲉⲛⲭⲁⲓ ⲅⲁⲣ ⲛⲓⲃⲉⲛ ⲛⲱⲧⲉⲛ ⲛⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","⳿ⲓⲧⲉ ⲡⲁⲩⲗⲟⲥ ⳿ⲓⲧⲉ ⲁⲡⲟⲗⲗⲱ ⳿ⲓⲧⲉ ⲕⲏⲫⲁ ⳿ⲓⲧⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⳿ⲓⲧⲉ ⳿ⲡⲱⲛϧ ⳿ⲓⲧⲉ ⳿ⲫⲙⲟⲩ ⳿ⲓⲧⲉ ⲛⲏ ⲉⲧϣⲟⲡ ⳿ⲓⲧⲉ ⲛⲏⲉⲑⲛⲁϣⲱⲡⲓ ⲛⲱⲧⲉⲛ ⲧⲏⲣⲟⲩ ⲛⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ⲛⲁ Ⲡⲭ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲇⲉ ⲫⲁ ⲫϯ ⲡⲉ. ");
INSERT INTO copcnt_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲙⲁⲣⲟⲩⲙⲉⲩ⳿ⲓ ⳿ⲉⲣⲟⲛ ⳿ⲛϫⲉ ⲛⲓⲣⲱⲙⲓ ϩⲱⲥ ϩⲁⲛϩⲩⲡⲉⲣⲉⲧⲏⲥ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲛⲉⲙ ϩⲁⲛⲟⲓⲕⲟⲛⲟⲙⲟⲥ ⳿ⲛⲧⲉ ⲛⲓⲙⲩⲥⲧⲏⲣⲓⲟⲛ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ⲗⲟⲓⲡⲟⲛ ⳿ⲛⲥⲉⲕⲱϯ ⳿ⲙⲡⲁⲓⲙⲁ ϧⲉⲛ ⲛⲓⲟⲓⲕⲟⲛⲟⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲥⲉϫⲉⲙ ⲟⲩⲁⲓ ⲉϥⲉⲛϩⲟⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","⳿ⲁⲛⲟⲕ ⲇⲉ ⲟⲩⲙⲉⲧⲕⲟⲩϫⲓ ⲛⲏⲓ ⲧⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲓⲉ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲧⲉ ⲟⲩⲙⲉⲧⲣⲱⲙⲓ ⲁⲗⲗⲁ ⲟⲩⲇⲉ ⳿ⲁⲛⲟⲕ ⳿ⲛϯϯϩⲁⲡ ⳿ⲉⲣⲟⲓ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ⲟⲩⲇⲉ ⲅⲁⲣ ⳿ⲁⲛⲟⲕ ⳿ⲛϯⲥⲱⲟⲩⲛ ⳿ⲛ⳿ϩⲗⲓ ⲁⲛ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲁⲗⲗⲁ ⲟⲩⲇⲉ ⳿ⲛ⳿ϧⲣⲏⲓ ϧⲉⲛ ⲫⲁⲓ ⳿ⲛϯ⳿ⲑⲙⲁⲓⲏⲟⲩⲧ ⲁⲛ ⲫⲏ ⲇⲉ ⲉⲑⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟⲓ Ⲡ⳪ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ϩⲱⲥⲧⲉ ⳿ⲙⲡⲉⲣϯϩⲁⲡ ⳿ⲉ⳿ϩⲗⲓ ϧⲁ⳿ⲧϩⲏ ⳿ⲙⲡⲓⲥⲏⲟⲩ ϣⲁⲧⲉϥ⳿ⲓ ⳿ⲛϫⲉ Ⲡ⳪ ⲫⲏⲉⲑⲛⲁ⳿ⲑⲣⲉ ⲛⲏⲉⲧϩⲏⲡ ⳿ⲛⲧⲉ ⳿ⲡⲭⲁⲕⲓ ⲉⲣⲟⲩⲱⲓⲛⲓ ⲟⲩⲟϩ ⳿ⲛⲧⲉϥⲟⲩⲟⲛϩ ⳿ⲉⲃⲟⲗ ⳿ⲛⲛⲓⲥⲟϭⲛⲓ ⳿ⲛⲧⲉ ⲛⲓϩⲏⲧ ⲟⲩⲟϩ ⲧⲟⲧⲉ ⲉⲣⲉ ⳿ⲡⲧⲁⲓⲟ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ϣⲱⲡⲓ ⲛⲁϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ. ");
INSERT INTO copcnt_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ⲛⲁⲓ ⲇⲉ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ⲁⲓϣⲟⲡⲧⲟⲩ ⳿ⲛ⳿ⲥⲭⲏⲙⲁ ⳿ⲉⲣⲟⲓ ⲛⲉⲙ ⲁⲡⲟⲗⲗⲱ ⲉⲑⲃⲉ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧⲉⲛ ⳿ⲛⲧⲉⲧⲉⲛϭⲓ⳿ⲥⲃⲱ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣⲥⲁⲃⲟⲗ ⳿ⲛⲛⲏⲉⲧ⳿ⲥϧⲏⲟⲩⲧ ϩⲓⲛⲁ ϫⲉ ⳿ⲛⲛⲉ ⲟⲩⲁⲓ ϭⲓⲥⲓ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲉ ⲟⲩⲁⲓ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲉⲛ ⲡⲉϥ⳿ϣⲫⲏⲣ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ⲛⲓⲙ ⲅⲁⲣ ⲡⲉⲧⲉⲣⲇⲓ⳿ⲁ⳿ⲕⲣⲓⲛⲓⲛ ⳿ⲙⲙⲟⲕ ⲟⲩ ⲇⲉ ⲡⲉⲧⲉ⳿ⲛⲧⲟⲧⲕ ⲉⲧⲉ ⳿ⲙⲡⲉⲕϭⲓⲧϥ ⲓⲥϫⲉ ⲇⲉ ⲁⲕⲉⲣ ⳿ⲡⲕⲉϭⲓ ⲉⲑⲃⲉⲟⲩ ⲉⲕϣⲟⲩϣⲟⲩ ⳿ⲙⲙⲟⲕ ϩⲱⲥ ⲟⲩⲁⲓ ⳿ⲙⲡⲉϥϭⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ϩⲏⲇⲏ ⲁⲧⲉⲧⲉⲛⲥⲓ ϩⲏⲇⲏ ⲁⲧⲉⲧⲉⲛⲉⲣⲣⲁⲙⲁ⳿ⲟ ⲁⲧ⳿ϭⲛⲟⲩⲛ ⲁⲣⲉⲧⲉⲛⲉⲣⲟⲩⲣⲟ ⲟⲩⲟϩ ⳿ⲁⲙⲟⲓ ⲛⲉ ⲁⲣⲉⲧⲉⲛⲉⲣⲟⲩⲣⲟ ϩⲓⲛⲁ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲛⲧⲉⲛⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛⲟⲩⲣⲟ ⲛⲉⲙⲱⲧⲉⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ϯⲙⲉⲩ⳿ⲓ ⲅⲁⲣ ϫⲉ ⲉⲧⲁ ⲫϯ ⲟⲩⲟⲛϩⲧⲉⲛ ⳿ⲉⲃⲟⲗ ⳿ⲁⲛⲟⲛ ϧⲁ ⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲛϩⲁⲛϧⲁⲉⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛ⳿ⲉⲡⲓⲑⲁⲛⲁⲧⲓⲟⲥ ϫⲉ ⲁⲛⲉⲣⲑⲉⲁⲧⲣⲟⲛ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ⲛⲉⲙ ⲛⲓⲁⲅⲅⲉⲗⲟⲥ ⲛⲉⲙ ⲛⲓⲣⲱⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","⳿ⲁⲛⲟⲛ ϩⲁⲛⲥⲟϫ ⲅⲁⲣ ⲉⲑⲃⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲥⲁⲃⲉⲩ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ⳿ⲁⲛⲟⲛ ⲅⲁⲣ ϩⲁⲛϫⲱⲃ ⳿ⲛⲑⲱⲧⲉⲛ ⲇⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛϫⲱⲣⲓ ⳿ⲛⲑⲱⲧⲉⲛ ⲧⲉⲧⲉⲛⲧⲁⲓⲏⲟⲩⲧ ⳿ⲁⲛⲟⲛ ⲇⲉ ⲧⲉⲛϣⲏϣ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ϣⲁ ⳿ⲉϧⲟⲩⲛ ⲉⲧⲁⲓⲟⲩⲛⲟⲩ ⲧⲉⲛϩⲟⲕⲉⲣ ⲟⲩⲟϩ ⲧⲉⲛⲟⲃⲓ ⲧⲉⲛⲃⲏϣ ⲟⲩⲟϩ ⲥⲉϯⲕⲉϩ ⲛⲁⲛ ⲟⲩⲟϩ ⲧⲉⲛⲥⲉⲙⲛⲏⲟⲩⲧ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ⲧⲉⲛϧⲟⲥⲓ ⲉⲛⲉⲣϩⲱⲃ ϧⲉⲛ ⲛⲉⲛϫⲓϫ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟⲛ ⲥⲉϩⲱⲟⲩϣ ⳿ⲉⲣⲟⲛ ⲟⲩⲟϩ ⲧⲉⲛ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲱⲟⲩ ⲉⲩϭⲟϫⲓ ⳿ⲛⲥⲱⲛ ⲧⲉⲛⲱⲟⲩ ⳿ⲛϩⲏⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ⲉⲩϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟⲛ ⲧⲉⲛϯϩⲟ ⳿ⲉⲣⲱⲟⲩ ⲁⲛⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲡⲉⲣⲓⲕⲁⲑⲁⲣⲙⲁ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲁⲛⲉⲣ⳿ϣⲃⲉ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ⲛⲁⲓ⳿ϫⲫⲓⲟ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ ⲉⲓ⳿ⲥϧⲁⲓ ⳿ⲛⲛⲁⲓ ⲛⲱⲧⲉⲛ ⲁⲗⲗⲁ ⲉⲓϯ⳿ⲥⲃⲱ ⲛⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛϣⲏⲣⲓ ⳿ⲙⲙⲉⲛⲣⲓⲧ ⳿ⲛⲧⲏⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ⲉϣⲱⲡ ⲅⲁⲣ ⳿ⲉⲟⲩⲟⲛⲧⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩ⳿ⲑⲃⲁ ⳿ⲛϭⲁⲩⲙⲱⲓⲧ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ ⲁⲗⲗⲁ ⳿ⲛⲟⲩⲙⲏϣ ⳿ⲛⲓⲱⲧ ⲁⲛ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲁⲛⲟⲕ ⲁⲓ⳿ϫⲫⲉ ⲑⲏⲛⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ϯϯϩⲟ ⲟⲩⲛ ⳿ⲉⲣⲱⲧⲉⲛ ϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲟⲛⲓ ⳿ⲙⲙⲟⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ⲉⲑⲃⲉ ⲫⲁⲓ ⲁⲓⲟⲩⲱⲣⲡ ⲛⲱⲧⲉⲛ ⳿ⲛⲧⲓⲙⲟⲑⲉⲟⲥ ⲉⲧⲉ ⲡⲁϣⲏⲣⲓ ⳿ⲙⲙⲉⲛⲣⲓⲧ ⲡⲉ ⲟⲩⲟϩ ⳿ⲙⲡⲓⲥⲧⲟⲥ ϧⲉⲛ Ⲡ⳪ ⲫⲁⲓ ⲉⲑⲛⲁ⳿ⲑⲣⲉⲧⲉⲛⲉⲣ⳿ⲫⲙⲉⲩ⳿ⲓ ⳿ⲛⲛⲁⲙⲱⲓⲧ ⲉⲧϧⲉⲛ Ⲡⲭ̅ⲥ̅ Ⲓⲏ̅ⲥ̅ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⳿ⲉϯϯ⳿ⲥⲃⲱ ϧⲉⲛ ⲙⲁⲓ ⲛⲓⲃⲉⲛ ϧⲉⲛ ⲛⲓⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲧⲏⲣⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ϩⲱⲥ ⳿ⲛϯⲛⲏⲟⲩ ⲇⲉ ϩⲁⲣⲱⲧⲉⲛ ⲁⲛ ⲁ ϩⲁⲛⲟⲩⲟⲛ ϭⲓⲥⲓ ⳿ⲛϩⲏⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ⲉⲓ⳿ⲉ⳿ⲓ ⲇⲉ ϩⲁⲣⲱⲧⲉⲛ ⳿ⲛⲭⲱⲗⲉⲙ ⲉϣⲱⲡ ⳿ⲉ⳿ⲫⲟⲩⲱϣ ⳿ⲙⲠ⳪ ⲡⲉ ⲟⲩⲟϩ ⲉⲓ⳿ⲉ⳿ⲉⲙⲓ ⳿ⲉ⳿ⲡⲥⲁϫⲓ ⲁⲛ ⳿ⲛⲧⲉ ⲛⲏ- ⲉⲧⲁⲩϭⲓⲥⲓ ⳿ⲛϩⲏⲧ ⲁⲗⲗⲁ ⳿ⲉⲧⲟⲩϫⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ϯⲙⲉⲧⲟⲩⲣⲟ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲫϯ ⲛⲁⲥϧⲉⲛ ⳿ⲡⲥⲁϫⲓ ⲁⲛ ⲁⲗⲗⲁ ⲁⲥϧⲉⲛ ⲟⲩϫⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ⲟⲩ ϫⲉ ⲡⲉⲧⲉⲧⲉⲛⲟⲩⲁϣϥ ⳿ⲛⲧⲁⲓ ϩⲁⲣⲱⲧⲉⲛ ϧⲉⲛ ⲟⲩ⳿ϣⲃⲱⲧ ϣⲁⲛ ϧⲉⲛ ⲟⲩⲁⲅⲁⲡⲏ ⳿ⲙⲡⲛ̅ⲁ̅ ⳿ⲙⲙⲉⲧⲣⲉⲙⲣⲁⲩϣ. ");
INSERT INTO copcnt_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ϩⲟⲗⲱⲥ ⲥⲉⲥⲱⲧⲉⲙ ⳿ⲉⲟⲩⲡⲟⲣⲛⲓⲁ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩⲟϩ ⲟⲩⲡⲟⲣⲛⲓⲁ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲑⲁⲓ ⲉⲧⲉ⳿ⲛ⳿ⲥϣⲟⲡ ⲁⲛ ϧⲉⲛ ⲛⲓⲕⲉⲉⲑⲛⲟⲥ ϩⲱⲥⲧⲉ ⳿ⲛⲧⲉ ⲟⲩⲁⲓ ϭⲓ ⳿ⲧ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉϥⲓⲱⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲱⲧⲉⲛ ⲧⲉⲧⲉⲛϭⲓⲥⲓ ⳿ⲛϩⲏⲧ ⲟⲩⲟϩ ⲉⲑⲃⲉⲟⲩ ⲙⲁⲗⲗⲟⲛ ⳿ⲙⲡⲉⲧⲉⲛⲉⲣϩⲏⲃⲓ ϩⲓⲛⲁ ⳿ⲛⲥⲉ⳿ⲱⲗⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲧⲉⲧⲉⲛⲙⲏϯ ⳿ⲙⲫⲏ- ⲉⲧⲁϥⲓⲣⲓ ⳿ⲙⲡⲁⲓϩⲱⲃ ⳿ⲙⲡⲁⲓⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","⳿ⲁⲛⲟⲕ ⲙⲉⲛ ⲅⲁⲣ ⳿ⲛϯⲛⲉⲙⲱⲧⲉⲛ ⲁⲛ ϧⲉⲛ ⲡⲓⲥⲱⲙⲁ ϯⲛⲉⲙⲱⲧⲉⲛ ⲇⲉ ϧⲉⲛ ⲡⲓⲡⲛ̅ⲁ̅ ϩⲏⲇⲏ ⲁⲓϯϩⲁⲡ ϩⲱⲥ ⲉⲓⲛⲉⲙⲱⲧⲉⲛ ⳿ⲙⲫⲏⲉⲧⲁϥⲓⲣⲓ ⳿ⲙⲡⲁⲓϩⲱⲃ ⳿ⲙⲡⲁⲓⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⳿ⲛⲧⲉⲧⲉⲛⲑⲱⲟⲩϯ ⲉⲩⲙⲁ ⲛⲉⲙ ⲡⲁⲡⲛ̅ⲁ̅ ⲛⲉⲙ ϯϫⲟⲙ ⳿ⲛⲧⲉ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ.̅. ");
INSERT INTO copcnt_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","⳿ⲉϯ ⳿ⲙⲫⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲉⲧⲟⲧϥ ⳿ⲙ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⳿ⲉ⳿ⲡⲧⲁⲕⲟ ⳿ⲛⲧⲉ ϯⲥⲁⲣⲝ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲓⲡⲛ̅ⲁ̅ ⲛⲟϩⲉⲙ ϧⲉⲛ ⳿ⲡ⳿ⲉϩⲟⲟⲩ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅.. ");
INSERT INTO copcnt_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ⲛⲁⲛⲉ ⲡⲉⲧⲉⲛϣⲟⲩϣⲟⲩ ⲁⲛ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲟⲩⲕⲟⲩϫⲓ ⳿ⲛϣⲉⲙⲏⲣ ϣⲁϥ⳿ⲑⲣⲉ ⲡⲓⲟⲩⲱϣⲉⲙ ⲧⲏⲣϥ ϭⲓϣⲉⲙⲏⲣ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ⲙⲁⲧⲟⲩⲃⲉ ⲡⲓϣⲉⲙⲏⲣ ⳿ⲛⲁⲡⲁⲥ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛϣⲱⲡⲓ ⳿ⲛⲟⲩⲱϣⲉⲙ ⳿ⲙⲃⲉⲣⲓ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧϣⲉⲙⲏⲣ ⲕⲉ ⲅⲁⲣ ⲡⲉⲛⲡⲁⲥⲭⲁ ⲁⲩϣⲁⲧϥ Ⲡⲭ̅ⲥ.̅. ");
INSERT INTO copcnt_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ϩⲱⲥⲧⲉ ⲙⲁⲣⲉⲛⲉⲣϣⲁⲓ ϧⲉⲛ ⲟⲩϣⲉⲙⲏⲣ ⳿ⲛⲁⲡⲁⲥ ⲁⲛ ⲟⲩⲇⲉ ϧⲉⲛ ⲟⲩϣⲉⲙⲏⲣ ⳿ⲛⲕⲁⲕⲓⲁ ⲁⲛ ⲛⲉⲙ ⲡⲟⲛⲏⲣⲓⲁ ⲁⲗⲗⲁ ϧⲉⲛ ϩⲁⲛⲙⲉⲧⲁⲧϣⲉⲙⲏⲣ ⳿ⲛⲧⲉ ⲟⲩⲧⲟⲩⲃⲟ ⲛⲉⲙ ⲟⲩⲙⲉⲑⲙⲏⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ⲁⲓ⳿ⲥϧⲁⲓ ⲛⲱⲧⲉⲛ ϩⲓ ϯ⳿ⲉⲡⲓⲥⲧⲟⲗⲏ ⳿ⲉ⳿ϣⲧⲉⲙⲙⲟⲩϫⲧ ⲛⲉⲙ ⲛⲓⲡⲟⲣⲛⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ⲛⲁⲓϫⲉⲣⲉ ⲛⲓⲡⲟⲣⲛⲟⲥ ⲁⲛ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ ⲓⲉ ⲛⲓⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ⲓⲉ ⲛⲓⲣⲉϥϩⲱⲗⲉⲙ ⲓⲉ ⲛⲓⲣⲉϥϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ ⳿ⲙⲙⲟⲛ ⲛⲁⲥ⳿ⲙ⳿ⲡϣⲁ ⲛⲱⲧⲉⲛ ⲡⲉ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ϯⲛⲟⲩ ⲇⲉ ⲁⲓ⳿ⲥϧⲁⲓ ⲛⲱⲧⲉⲛ ⳿ⲉ⳿ϣⲧⲉⲙⲙⲟⲩϫⲧ ⲛⲉⲙⲱⲟⲩ ⲉϣⲱⲡ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲁⲓ ⲉⲩ ϯⲣⲁⲛ ⳿ⲉⲣⲟϥ ϫⲉ ⲥⲟⲛ ⳿ⲉⲟⲩⲡⲟⲣⲛⲟⲥ ⲡⲉ ⲓⲉ ⲟⲩⲣⲉϥ ϭⲓ⳿ⲛϫⲟⲛⲥ ⲓⲉ ⲟⲩⲣⲉϥϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ ⲓⲉ ⲟⲩⲣⲉϥϩⲱⲟⲩϣ ⲓⲉ ⲟⲩⲣⲉϥⲑⲓϧⲓ ⲓⲉ ⲟⲩⲣⲉϥϩⲱⲗⲉⲙ ⲫⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲣⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲛⲟⲩⲱⲙ ⲛⲉⲙⲁϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ⲉⲣⲟⲩ ⲅⲁⲣ ⲛⲏⲓ ⳿ⲉϯϩⲁⲡ ⳿ⲉⲛⲏⲉⲧⲥⲁⲃⲟⲗ ⲛⲏ ⲉⲧⲥⲁϧⲟⲩⲛ ⳿ⲛⲑⲱⲧⲉⲛ ⲙⲁϩⲁⲡ ⳿ⲉⲣⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ⲛⲏⲉⲧⲥⲁⲃⲟⲗ ⲇⲉ ⲫϯ ⲉϥ⳿ⲉϯϩⲁⲡ ⳿ⲉⲣⲱⲟⲩ ⳿ⲁⲗⲓⲟⲩ⳿ⲓ ⳿ⲙⲡⲓⲡⲉⲧϩⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲑⲏⲛⲟⲩ. ");
INSERT INTO copcnt_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ⲟⲩⲟⲛ ⲟⲩⲁⲓ ⲛⲁⲉⲣⲧⲟⲗⲙⲁⲛ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⲟⲩϩⲱⲃ ⲟⲩⲧⲱϥ ⲛⲉⲙ ⲡⲉϥ⳿ϣⲫⲏⲣ ⳿ⲉϭⲓϩⲁⲡ ϩⲓ ⲛⲓⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ϩⲓ ⲛⲓⲁⲅⲓⲟⲥ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲓⲁⲅⲓⲟⲥ ⲉⲑⲛⲁϯ ϩⲁⲡ ⳿ⲉⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ⲓⲥϫⲉ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲉⲩⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟϥ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲛⲁⲣⲉⲧⲉⲛ⳿ⲙ⳿ⲡϣⲁ ⲁⲛ ϫⲉ ⳿ⲛϩⲁⲛⲕⲟⲩϫⲓ ⳿ⲙⲙⲁ ⳿ⲛϯϩⲁⲡ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲉⲛⲛⲁϯϩⲁⲡ ⳿ⲉϩⲁⲛⲁⲅⲅⲉⲗⲟⲥ ⲙⲏⲧⲓⲅⲉ ϩⲁⲛ⳿ϩⲃⲏⲟⲩ⳿ⲓ ⳿ⲛⲧⲉ ⲡⲁⲓⲃⲓⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ⲉϣⲱⲡ ⲙⲉⲛ ⲟⲩⲛ ⳿ⲉⲟⲩⲟⲛⲧⲱⲧⲉⲛ ⳿ⲙⲙⲁⲩ ⳿ⲛϩⲁⲛⲙⲁ⳿ⲛϯϩⲁⲡ ⳿ⲛⲧⲉ ⲡⲁⲓⲃⲓⲟⲥ ⲛⲏⲉⲧϣⲏϣ ϧⲉⲛ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓ⳿ⲁ ⲛⲁⲓ ⲙⲁ⳿ⲧϩⲉⲙⲥⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ⲉⲓϫⲱ ⳿ⲙⲙⲟⲥ ⲉⲩ⳿ϫⲫⲓⲟ ⲛⲱⲧⲉⲛ ⲡⲁⲓⲣⲏϯ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲥⲁⲃⲉ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⳿ⲉⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟϥ ⳿ⲉⲉⲣⲇⲓ⳿ⲁ⳿ⲕⲣⲓⲛⲓⲛ ⲟⲩⲧⲉ ⲡⲉϥⲥⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ⲁⲗⲗⲁ ⲟⲩⲥⲟⲛ ⲛⲉⲙ ⲟⲩⲥⲟⲛ ⲉϥϭⲓϩⲁⲡ ⲟⲩⲟϩ ⲫⲁⲓ ϩⲓ ⲛⲓⲁⲑⲛⲁϩϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ϩⲏⲇⲏ ⲙⲉⲛ ϩⲟⲗⲱⲥ ⲟⲩⲑⲉⲃⲓⲟ ⲛⲱⲧⲉⲛ ⲡⲉ ϫⲉ ⲟⲩⲟⲛⲧⲉⲧⲉⲛ ϩⲁⲡ ⳿ⲙⲙⲁⲩ ⲟⲩⲧⲱⲧⲉⲛ ⲛⲉⲙ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⲉⲑⲃⲉⲟⲩ ⲙⲁⲗⲗⲟⲛ ⲥⲉϭⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲛϫⲟⲛⲥ ⲁⲛ ⲉⲑⲃⲉⲟⲩ ⲙⲁⲗⲗⲟⲛ ⲥⲉϥⲱϫⲓ ⳿ⲙⲙⲱⲧⲉⲛ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ⲁⲗⲗⲁ ⳿ⲛⲑⲱⲧⲉⲛ ⲉⲧϭⲓ⳿ⲛϫⲟⲛⲥ ⲟⲩⲟϩ ⲉⲧϥⲱϫⲓ ⲟⲩⲟϩ ⲫⲁⲓ ⳿ⲛⲛⲉⲧⲉⲛ⳿ⲥⲛⲏⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲓⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲥⲉⲛⲁⲉⲣ⳿ⲕⲗⲏⲣⲟⲛⲟⲙⲓⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ ⳿ⲙⲡⲉⲣⲥⲱⲣⲉⲙ ϫⲉ ⲟⲩⲇⲉ ⲡⲟⲣⲛⲟⲥ ⲟⲩⲇⲉ ⲣⲉϥϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩⲇⲉ ⲛⲱⲓⲕ ⲟⲩⲇⲉ ⲙⲁⲗⲁⲕⲟⲥ ⲟⲩⲇⲉ ⲣⲉϥⲉⲛⲕⲟⲧ ⲛⲉⲙ ϩⲱⲟⲩⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ⲟⲩⲇⲉ ⲣⲉϥϭⲓⲟⲩ⳿ⲓ ⲟⲩⲇⲉ ⲣⲉϥϭⲓ⳿ⲛϫⲟⲛⲥ ⲟⲩⲇⲉ ⲣⲉϥⲑⲓϧⲓ ⲟⲩⲇⲉ ⲣⲉϥϯϣⲱϣ ⲟⲩⲇⲉ ⲣⲉϥϩⲱⲗⲉⲙ ϯⲙⲉⲧⲟⲩⲣⲟ ⳿ⲛⲧⲉ ⲫϯ ⲥⲉⲛⲁⲉⲣ⳿ⲕⲗⲏ ⲣⲟⲛⲟⲙⲓⲛ ⳿ⲙⲙⲟⲥ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ⲕⲉ ⲧⲁⲩⲧⲁ ⲛⲉ ⳿ⲛⲑⲱⲧⲉⲛ ϩⲁⲛⲟⲩⲟⲛ ⲡⲉ ⲁⲗⲗⲁ ⲁⲩϫⲉⲕⲉⲙ ⲑⲏⲛⲟⲩ ⲁⲗⲗⲁ ⲁⲩⲧⲟⲩⲃⲉ ⲑⲏⲛⲟⲩ ⲁⲗⲗⲁ ⲁⲩ⳿ⲑⲙⲁⲓ⳿ⲉ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⳿ⲫⲣⲁⲛ ⳿ⲙⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲛⲉⲙ ϧⲉⲛ ⲡⲓⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲡⲉⲛⲛⲟⲩϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","⳿ⲉⲝⲉⲥⲧⲓⲛ ⲛⲏⲓ ⳿ⲉⲉⲣϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⲥⲉⲉⲣⲛⲟϥⲣⲓ ⲧⲏⲣⲟⲩ ⲁⲛ ⲉⲝⲉⲥⲧⲓⲛ ⲛⲏⲓ ⳿ⲉⲉⲣϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⳿ⲛⲛⲉ⳿ϣ ⳿ϩⲗⲓ ⲓⲣⲓ ⳿ⲙⲡⲁⲉⲣϣⲓϣⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ⲛⲓ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⲁⲩⲭⲏ ⳿ⲛϯⲛⲉϫⲓ ⲟⲩⲟϩ ϯⲛⲉϫⲓ ⳿ⲛⲛⲓ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⲑⲁⲓ ⲇⲉ ⲛⲉⲙ ⲛⲓⲕⲉⲭⲱⲟⲩⲛⲓ ⲫϯ ⲛⲁⲕⲟⲣϥⲟⲩ ⲡⲓⲥⲱⲙⲁ ⲇⲉ ⲛⲁϥⲭⲏ ⳿ⲛϯ ⲡⲟⲣⲛⲓⲁ ⲁⲛ ⲁⲗⲗⲁ ⳿ⲙⲠ⳪ ⲟⲩⲟϩ Ⲡ⳪ ⳿ⲙⲡⲓⲥⲱⲙⲁ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ⲫϯ ⲇⲉ ⲁϥⲧⲟⲩⲛⲟⲥ ⲡⲉⲛ⳪ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⲉϥ⳿ⲉⲧⲟⲩⲛⲟⲥⲧⲉⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲧⲉϥϫⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ ϩⲁⲛⲙⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲛⲉ ⳿ⲛⲧⲁⲱⲗⲓ ⲟⲩⲛ ⳿ⲛⲛⲓⲙⲉⲗⲟⲥ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲛⲧⲁⲁⲓⲧⲟⲩ ⳿ⲙⲙⲉⲗⲟⲥ ⳿ⲙⲡⲟⲣⲛⲏ ⳿ⲛⲛⲉⲥϣⲱⲡⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲫⲏ ⲉⲧⲧⲱⲙⲓ ⳿ⲙⲙⲟϥ ⳿ⲉϯⲡⲟⲣⲛⲏ ⲟⲩⲥⲱⲙⲁ ⳿ⲛⲟⲩⲱⲧ ⲡⲉ ⲉⲩ⳿ⲉϣⲱⲡⲓ ⲅⲁⲣ ⲡⲉϫⲁϥ ⳿ⲙⲡⲃ̅ ⲉⲩⲥⲁⲣⲝ ⳿ⲛⲟⲩⲱⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ⲫⲏⲇⲉ ⲉⲧⲧⲱⲙⲓ ⳿ⲙⲙⲟϥ ⳿ⲉⲠ⳪ ⲟⲩⲡⲛ̅ⲁ̅ ⳿ⲛⲟⲩⲱⲧ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ⲫⲱⲧ ⲥⲁⲃⲟⲗ ⳿ⲛϯⲡⲟⲣⲛⲓⲁ ⲛⲟⲃⲓ ⲛⲓⲃⲉⲛ ⲉⲧⲉ ⲡⲓⲣⲱⲙⲓ ⲛⲁⲁⲓϥ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲓⲥⲱⲙⲁ ⲫⲏ ⲇⲉ ⲉⲧⲉⲣⲡⲟⲣⲛⲉⲩⲓⲛ ⲁϥⲉⲣⲛⲟⲃⲓ ⳿ⲉⲡⲉϥⲥⲱⲙⲁ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ϣⲁⲛ ⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ ⲟⲩⲉⲣⲫⲉⲓ ⳿ⲛⲧⲉ ⲡⲓⲡⲛ̅ⲁ̅ ⲉⲑⲟⲩⲁⲃ ⲡⲉ ⲫⲏ ⲉⲧϣⲟⲡ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲫⲏ ⲉⲧⲁⲣⲉⲧⲉⲛϭⲓⲧϥ ⳿ⲛⲧⲉⲛ ⲫϯ ⲟⲩⲟϩ ⳿ⲛⲑⲱⲧⲉⲛ ⲫⲱⲧⲉⲛ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ⲁⲩϣⲉⲡ ⲑⲏⲛⲟⲩ ϧⲁ ⲟⲩⲧⲓⲙⲏ ⲙⲁⲱⲟⲩ ⳿ⲙⲫϯ ϧⲉⲛ ⲛⲉⲧⲉⲛⲥⲱⲙⲁ. ");
INSERT INTO copcnt_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ⲉⲑⲃⲉ ⲛⲏ ⲇⲉ ⲉⲧⲁⲣⲉⲧⲉⲛ⳿ⲥϧⲏⲧⲟⲩ ⲛⲏⲓ ⲛⲁⲛⲉⲥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⳿ⲉ⳿ϣⲧⲉⲙϭⲓ ⲛⲉⲙ ⳿ⲥϩⲓⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ⲉⲑⲃⲉ ⲛⲓⲡⲟⲣⲛⲓⲁ ⲇⲉ ⲙⲁⲣⲉ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲭⲁ ⲧⲉϥ⳿ⲥϩⲓⲙⲓ ⲛⲁϥ ⲟⲩⲟϩ ⲙⲁⲣⲉ ϯⲟⲩ⳿ⲓ ϯⲟⲩ⳿ⲓ ⲭⲁ ⲡⲉⲥϩⲁⲓ ⲛⲁⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ⲡⲓϩⲁⲓ ⲙⲁⲣⲉϥϯ ⳿ⲙⲡⲉⲧⲉⲣⲟϥ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ⲡⲁⲓⲣⲏϯ ⲟⲛ ϯ⳿ⲥϩⲓⲙⲓ ⲙⲁⲣⲉⲥϯ ⳿ⲙⲡⲉⲧⲉⲣⲟⲥ ⳿ⲙⲡⲉⲥϩⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ϯ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲙⲟⲛⲧⲉⲥ ⲉⲣϣⲓϣⲓ ⳿ⲙⲡⲉⲥⲥⲱⲙⲁ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟⲥ ⲁⲗⲗⲁ ⲡⲓϩⲁⲓ ⲡⲉ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓⲕⲉϩⲁⲓ ⳿ⲙⲙⲟⲛⲧⲉϥ ⲉⲣϣⲓϣⲓ ⳿ⲙⲡⲉϥⲥⲱⲙⲁ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲁⲗⲗⲁ ϯ⳿ⲥϩⲓⲙⲓ ⲧⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","⳿ⲙⲡⲉⲣϥⲉϫ ⲛⲉⲧⲉⲛⲉⲣⲏⲟⲩ ⳿ⲉⲃⲏⲗ ⲁⲣⲏⲟⲩ ϧⲉⲛ ⲟⲩϯⲙⲁϯ ⳿ⲡⲣⲟⲥ ⲟⲩⲥⲏⲟⲩ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲥⲣⲱϥⲧ ⳿ⲉϯ⳿ⲡⲣⲟⲥⲉⲩⲭⲏ ⲟⲩⲟϩ ⲡⲁⲗⲓⲛ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲓ ⲉⲩⲙⲁ ϩⲓⲛⲁ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⳿ⲡⲥⲁⲧⲁⲛⲁⲥ ⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲉⲑⲃⲉ ⲧⲉⲧⲉⲛⲙⲉⲧⲁⲧⲑⲱⲧ⳿ⲛϩⲏⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ⲫⲁⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟϥ ⲕⲁⲧⲁ ⲟⲩⲥⲩⲛ⳿ⲅⲛⲱⲙⲏ ⲕⲁⲧⲁ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ϯⲟⲩⲱϣ ⲇⲉ ⳿ⲛⲧⲉ ⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ϣⲱⲡⲓ ⳿ⲙⲡⲁⲣⲏϯ ⲁⲗⲗⲁ ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲟⲩⲛⲟⲧⲉϥ ⲟⲩ⳿ϩⲙⲟⲧ ⳿ⲙⲙⲁⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲫϯ ⲡⲓⲟⲩⲁⲓ ⲙⲉⲛ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲕⲉⲟⲩⲁⲓ ⲇⲉ ⳿ⲙⲡⲁⲓⲕⲉⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ϯϫⲱ ⲇⲉ ⳿ⲙⲙⲟⲥ ⳿ⲛⲛⲏ ⲉⲧⲉ⳿ⲙⲡⲟⲩϭⲓ ⲛⲉⲙ ⲛⲓⲭⲏⲣⲁ ϫⲉ ⲛⲁⲛⲉⲥ ⲛⲱⲟⲩ ⲁⲩϣⲁⲛϣⲱⲡⲓ ⳿ⲙⲡⲁⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ⲓⲥϫⲉ ⲇⲉ ⲥⲉⲛⲁ⳿ϣⲉⲣⲉⲅⲕⲣⲁⲧⲉⲩⲉⲥⲑⲉ ⲁⲛ ⲙⲁⲣⲟⲩϭⲓ ⲛⲁⲛⲉⲥ ⲅⲁⲣ ⳿ⲉϭⲓ ⲉϩⲟⲧⲉ ⳿ⲛⲥⲉϭⲓ ⳿ⲭⲣⲱⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ⲛⲏ ⲇⲉ ⲉⲧⲁⲩϭⲓ ϯϩⲟⲛϩⲉⲛ ⲛⲱⲟⲩ ⳿ⲁⲛⲟⲕ ⲁⲛ ⲁⲗⲗⲁ Ⲡ⳪ ϯ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲧⲉⲥ⳿ϣⲧⲉⲙⲫⲱⲣϫ ⲥⲁⲃⲟⲗ ⳿ⲙⲡⲉⲥϩⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ⲕⲁⲛ ⲉϣⲱⲡ ⲁⲥϣⲁⲛⲫⲱⲣϫ ⲙⲁⲣⲉⲥⲟϩⲓ ⳿ⲛⲟⲩⲉϣⲉⲛ ϭⲓ ⳿ⲙⲙⲟⲛ ⲙⲁⲣⲉⲥϩⲱⲧⲡ ⳿ⲉⲡⲉⲥϩⲁⲓ ⲟⲩⲟϩ ⲡⲓϩⲁⲓ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲭⲁ ϯ⳿ⲥϩⲓⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","⳿ⲡⲥⲉⲡⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲟⲩ ⳿ⲁⲛⲟⲕ Ⲡ⳪ ⲁⲛ ϫⲉ ⲉϣⲱⲡ ⳿ⲉⲟⲩⲟⲛ ⲟⲩⲥⲟⲛ ⳿ⲉⲟⲩⲟⲛⲧⲉϥ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ⳿ⲙⲙⲁⲩ ⲟⲩⲟϩ ⲑⲁⲓ ⲉⲥϯ ⲙⲁϯ ⳿ⲉϣⲱⲡⲓ ⲛⲉⲙⲁϥ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥⲭⲁⲥ ⳿ⲛⲥⲱϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ⲟⲩⲟϩ ⲟⲩ⳿ⲥϩⲓⲙⲓ ⳿ⲉⲟⲩⲟⲛⲧⲁⲥ ⳿ⲙⲙⲁⲩ ⳿ⲛⲟⲩϩⲁⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ⲟⲩⲟϩ ⲫⲁⲓ ⲉϥϯⲙⲁϯ ⳿ⲉϣⲱⲡⲓ ⲛⲉⲙⲁⲥ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲥⲭⲁ ⲡⲓϩⲁⲓ ⳿ⲛⲥⲱⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ⲁϥⲧⲟⲩⲃⲟ ⲅⲁⲣ ⳿ⲛϫⲉ ⲡⲓϩⲁⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ϧⲉⲛ ϯ⳿ⲥϩⲓⲙⲓ ⲟⲩⲟϩ ⲁⲥⲧⲟⲩⲃⲟ ⳿ⲛϫⲉ ϯ⳿ⲥϩⲓⲙⲓ ⳿ⲛⲁⲑⲛⲁϩϯ ϧⲉⲛ ⲡⲓⲥⲟⲛ ⳿ⲙⲙⲟⲛ ϩⲁⲣⲁ ⲛⲉⲧⲉⲛϣⲏⲣⲓ ⲥⲉϭⲁϧⲉⲙ ϯⲛⲟⲩ ⲇⲉ ⲥⲉⲟⲩⲁⲃ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ⲟⲩⲟϩ ⲓⲥϫⲉ ⲡⲓⲁⲑⲛⲁϩϯ ⲛⲁⲫⲱⲣϫ ⲙⲁⲣⲉϥⲫⲱⲣϫ ⳿ⲛ⳿ϥⲟⲓ ⳿ⲙⲃⲱⲕ ⲁⲛ ⳿ⲛϫⲉ ⲡⲓⲥⲟⲛ ⲓⲉ ϯⲥⲱⲛⲓ ϧⲉⲛ ⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲫϯ ⲇⲉ ⲁϥⲑⲁϩⲉⲙ ⲑⲏⲛⲟⲩ ϧⲉⲛ ⲟⲩϩⲓⲣⲏⲛⲏ. ");
INSERT INTO copcnt_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ⲁⲣⲉ⳿ⲉⲙⲓ ⲅⲁⲣ ⲑⲱⲛ ϯ⳿ⲥϩⲓⲙⲓ ϫⲉ ⲁⲣⲏⲟⲩ ⲧⲉⲣⲁ⳿ϣⲛⲟϩⲉⲙ ⳿ⲙⲡⲉϩⲁⲓ ⲓⲉ ⲁⲕⲥⲱⲟⲩⲛ ⲑⲱⲛ ⲡⲓⲣⲱⲙⲓ ϫⲉ ⲁⲣⲏⲟⲩ ⳿ⲭⲛⲁ⳿ϣⲛⲟϩⲉⲙ ⳿ⲛⲧⲉⲕ⳿ⲥϩⲓⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","⳿ⲓⲙⲏϯ ⳿ⲉⲡⲓⲣⲏϯ ⲉⲧⲁ Ⲡ⳪ ⲑⲁϣϥ ⳿ⲙⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲫϯ ⲑⲁϩⲉⲙ ⳿ⲫⲟⲩⲁⲓ ⳿ⲫⲟⲩⲁⲓ ⲡⲁⲓⲣⲏϯ ⲙⲁⲣⲉϥⲙⲟϣⲓ ⳿ⲛϧⲏⲧϥ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⳿ⲉϯⲟⲩⲁϩⲥⲁϩⲛⲓ ϧⲉⲛ ⲛⲓⲉⲕ⳿ⲕⲗⲏⲥⲓⲁ ⲧⲏⲣⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ⲁⲩⲑⲁϩⲉⲙ ⲟⲩⲁⲓ ⲉϥⲥⲟⲩⲃⲏⲧ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥⲥⲉⲕ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⲛⲁϥ ⲁⲩⲑⲁϩⲉⲙ ⲟⲩⲁⲓ ϧⲉⲛ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉϥⲥⲟⲩⲃⲏⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","⳿ⲡⲥⲉⲃⲓ ⲅⲁⲣ ⳿ϩⲗⲓ ⲡⲉ ⲟⲩⲟϩ ϯⲙⲉⲧⲁⲧⲥⲉⲃⲓ ⳿ϩⲗⲓ ⲧⲉ ⲁⲗⲗⲁ ⲡⲓⲁⲣⲉϩ ⳿ⲉⲛⲓⲉⲛⲧⲟⲗⲏ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ϧⲉⲛ ⲡⲓⲑⲱϩⲉⲙ ⲉⲧⲁⲩⲑⲁϩⲙⲉϥ ⳿ⲛϧⲏⲧϥ ⲙⲁⲣⲉϥϣⲱⲡⲓ ⳿ⲛϧⲏⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ⲁⲩⲑⲁϩⲙⲉⲕ ⲉⲕⲟⲓ ⳿ⲙⲃⲱⲕ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲥⲉⲣⲙⲉⲗⲓ ⲛ ⲛⲁⲕ ⲁⲗⲗⲁ ⲓⲥϫⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲟⲕ ⳿ⲉⲉⲣⲣⲉⲙϩⲉ ⲙⲁⲗⲗⲟⲛ ⲁⲣⲓⲟⲩ⳿ⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ⲡⲓⲃⲱⲕ ⲅⲁⲣ ⲉⲧⲁⲩⲑⲁϩⲙⲉϥ ϧⲉⲛ Ⲡ⳪ ⲟⲩⲁⲡⲉⲗⲉⲩⲑⲉⲣⲟⲥ ⳿ⲛⲧⲉ Ⲡ⳪ ⲡⲉ ⲡⲁⲓⲣⲏϯ ⲟⲛ ⲡⲓⲣⲉⲙϩⲉ ⲉⲧⲁⲩⲑⲁϩⲙⲉϥ ⲟⲩⲃⲱⲕ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ⲁⲩϣⲉⲡ ⲑⲏⲛⲟⲩ ϧⲁ ⲟⲩⲧⲓⲙⲏ ⳿ⲙⲡⲉⲣⲉⲣⲃⲱⲕ ⳿ⲛⲛⲓⲣⲱⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ⲡⲓⲟⲩⲁⲓ ⲡⲓⲟⲩⲁⲓ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϧⲉⲛ ⲫⲏ ⲉⲧⲁⲩⲑⲁϩⲙⲉϥ ⳿ⲛϧⲏⲧϥ ϧⲉⲛ ⲫⲁⲓ ⲙⲁⲣⲉϥϣⲱⲡⲓ ϧⲁⲧⲉⲛ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ⲉⲑⲃⲉ ⲛⲓⲡⲁⲣⲑⲉⲛⲟⲥ ⲇⲉ ⳿ⲙⲙⲟⲛϯ ⲟⲩⲁϩⲥⲁϩⲛⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲧⲉⲛ Ⲡ⳪ ⲟⲩ⳿ⲅⲛⲱⲙⲏ ⲇⲉ ⲡⲉϯϯ ⳿ⲙⲙⲟⲥ ϩⲱⲥ ⳿ⲉⲁⲩⲛⲁⲓ ⲛⲏⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ Ⲡ⳪ ⲉⲑⲣⲓϣⲱⲡⲓ ⳿ⲙⲡⲓⲥⲧⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ϯⲙⲉⲩ⳿ⲓ ⲟⲩⲛ ϫⲉ ⲛⲁⲛⲉ ⲫⲁⲓ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⲉⲑⲃⲉ ϯⲁⲛⲁⲅⲕⲏ ⲉⲧϣⲟⲡ ϫⲉ ⲛⲁⲛⲉⲥ ⳿ⲙⲡⲓⲣⲱⲙⲓ ⲉⲑⲣⲉϥϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","⳿ⲕⲥⲟⲛϩ ⳿ⲉ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉⲣⲕⲱϯ ⳿ⲛⲥⲁ ⲃⲟⲗⲕ ⳿ⲕⲃⲏⲗ ⳿ⲉⲃⲟⲗ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲡⲉⲣⲕⲱϯ ⳿ⲛⲥⲁ ⳿ⲥϩⲓⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ⲕⲁⲛ ⲉϣⲱⲡ ⲁⲕϣⲁⲛϭⲓ ⳿ⲙⲡⲉⲕⲉⲣⲛⲟⲃⲓ ⲟⲩⲟϩ ⲉϣⲱⲡ ⲁⲥϣⲁⲛϭⲓ ⳿ⲛϫⲉ ϯⲡⲁⲣⲑⲉⲛⲟⲥ ⳿ⲙⲡⲉⲥⲉⲣⲛⲟⲃⲓ ⲉⲩ⳿ⲉϭⲓ ⲇⲉ ⳿ⲛⲟⲩϩⲟϫϩⲉϫ ⳿ⲛⲧⲟⲩⲥⲁⲣⲝ ⳿ⲛϫⲉ ⲛⲁⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ. ⳿. ");
INSERT INTO copcnt_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϯ⳿ⲁⲥⲟ ⳿ⲉⲣⲱⲧⲉⲛ ⲫⲁⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟϥ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⳿ⲡⲥⲏⲟⲩ ⳿ⲙⲡⲱⲣϥ ⲡⲉ ⲧⲟⲗⲟⲓⲡⲟⲛ ϩⲓⲛⲁ ⲛⲏ ⲉⲧⲉ ⲟⲩⲟⲛⲧⲟⲩ ⳿ⲥϩⲓⲙⲓ ⳿ⲙⲙⲁⲩ ⳿ⲛⲥⲉⲉⲣ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛ ⲛⲏ ⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ⲛⲏ ⲉⲧⲣⲓⲙⲓ ϩⲱⲥ ⳿ⲛⲥⲉⲣⲓⲙⲓ ⲁⲛ ⲛⲏ ⲉⲧⲣⲁϣⲓ ϩⲱⲥ ⳿ⲛⲥⲉⲣⲁϣⲓ ⲁⲛ ⲛⲏ ⲉⲧϣⲱⲡ ϩⲱⲥ ⳿ⲛⲥⲉ⳿ⲁⲙⲟⲛⲓ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ⲛⲏ ⲉⲧⲉⲣ⳿ⲭⲣⲁⲥⲑⲉ ⳿ⲙⲡⲓⲕⲟⲥⲙⲟⲥ ϩⲱⲥ ⳿ⲛⲥⲉⲉⲣⲕⲁⲧⲁ⳿ⲭⲣⲁⲥⲑⲉ ⲁⲛ ⳿ϥⲛⲁⲥⲓⲛⲓ ⲅⲁⲣ ⳿ⲛϫⲉ ⲡⲓ⳿ⲥⲭⲏⲙⲁ ⳿ⲛⲧⲉ ⲡⲁⲓⲕⲟⲥⲙⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧⲣⲱⲟⲩϣ ⲫⲏ ⲉⲧⲉ⳿ⲙⲡⲉϥϭⲓ ⲁϥϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲛⲁ Ⲡ⳪ ϫⲉ ⲡⲱⲥ ⳿ϥⲣⲁⲛⲁϥ ⳿ⲙⲠ⳪.. ");
INSERT INTO copcnt_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ⲫⲏ ⲇⲉ ⲉⲧⲁϥϭⲓ ⲁϥϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲛⲁ ⲡⲓⲕⲟⲥⲙⲟⲥ ϫⲉ ⲡⲱⲥ ⳿ϥⲛⲁⲣⲁⲛⲁⲥ ⳿ⲛⲧⲉϥ⳿ⲥϩⲓⲙⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ⲟⲩⲟϩ ⳿ϥⲫⲏϣ ϯ⳿ⲥϩⲓⲙⲓ ⲉⲧⲁⲥϭⲓ ⲛⲉⲙ ϯⲡⲁⲣⲑⲉⲛⲟⲥ ⲑⲏ ⲉⲧⲉ ⳿ⲙⲡⲉⲥϭⲓ ⲁⲥϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲛⲁ Ⲡ⳪ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲥϣⲱⲡⲓ ⲉⲥⲟⲩⲁⲃ ϧⲉⲛ ⲡⲉⲥⲥⲱⲙⲁ ⲛⲉⲙ ⲡⲉⲥⲡⲛ̅ⲁ̅ ⲑⲏ ⲇⲉ ⲉⲧⲁⲥϭⲓ ⲁⲥϥⲓⲣⲱⲟⲩϣ ϧⲁ ⲛⲁ ⲡⲓⲕⲟⲥⲙⲟⲥ ϫⲉ ⲡⲱⲥ ⳿ⲥⲛⲁⲣⲁⲛⲁϥ ⳿ⲙⲡⲉⲥϩⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ⲫⲁⲓ ⲇⲉ ϯϫⲱ ⳿ⲙⲙⲟϥ ⲉⲑⲃⲉ ⲡⲉⲧⲉⲣⲛⲟϥⲣⲓ ⲛⲱⲧⲉⲛ ⲟⲩⲭⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁϩⲓⲟⲩ⳿ⲓ ⳿ⲛⲟⲩϩⲁϫⲓ ϧⲉⲛ ⲑⲏⲛⲟⲩ ⲁⲗⲗⲁ ϫⲉ ϩⲓⲛⲁ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛ⳿ⲥⲭⲏⲙⲁ ϣⲱⲡⲓ ⲉϥⲥⲟⲩⲃⲏⲧ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛ⳿ⲙⲧⲟⲛ ⳿ⲙⲙⲟⲩⲛ ⳿ⲉⲠ⳪ ϧⲉⲛ ⲟⲩⲙⲉⲧ ⲁⲧϭⲓ⳿ϩⲣⲁϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ⲓⲥϫⲉ ⲇⲉ ⲟⲩⲟⲛ ⲟⲩⲁⲓ ⲙⲉⲩ⳿ⲓ ⳿ⲉϭⲓϣⲓⲡⲓ ⳿ⲉϫⲉⲛ ⲧⲉϥⲡⲁⲣⲑⲉⲛⲟⲥ ⲉϣⲱⲡ ⲁϥϣⲁⲛⲉⲣⲁⲕⲙⲏ ⳿ⲛϩⲟⲩⲟ ⲟⲩⲟϩ ⲫⲁⲓ ⲡⲉⲧⲉ⳿ⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⲡⲉⲧⲉϩⲛⲁϥ ⲙⲁⲣⲉϥⲁⲓϥ ⳿ⲛ⳿ϥⲉⲣⲛⲟⲃⲓ ⲁⲛ ⲙⲁⲣⲟⲩϭ ⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ⲫⲏ ⲇⲉ ⲉⲧ⳿ⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ⲉϥⲧⲁϫⲣⲏⲟⲩⲧ ⳿ⲙⲙⲟⲛ ⳿ⲁⲛⲁⲅⲕⲏ ⲧⲟⲓ ⳿ⲉⲣⲟϥ ⲟⲩⲟⲛⲧⲉϥ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⲉⲑⲃⲉ ⲡⲉⲧⲉϩⲛⲁϥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ⲟⲩⲟϩ ⲫⲁⲓ ⲁϥϯϩⲁⲡ ⳿ⲉⲣⲟϥ ⳿ⲙⲙⲓⲛ ⳿ⲙⲙⲟϥ ϧⲉⲛ ⲡⲉϥϩⲏⲧ ⳿ⲉⲁⲣⲉϩ ⳿ⲉⲧⲉϥⲡⲁⲣⲑⲉⲛⲟⲥ ⲕⲁⲗⲱⲥ ⳿ϥⲛⲁⲁⲓⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ϩⲱⲥⲧⲉ ⲫⲏⲉⲧϯ ⳿ⲛⲧⲉϥⲡⲁⲣⲑⲉⲛⲟⲥ ⲉⲩⲅⲁⲙⲟⲥ ⲕⲁⲗⲱⲥ ⳿ϥⲣⲁ ⳿ⲙⲙⲟⲥ ⲟⲩⲟϩ ⲫⲏ ⲉⲧⲉ⳿ⲛ⳿ϥϯ ⳿ⲛⲑⲱϥ ⲁⲛ ⲟⲩϩⲟⲩ⳿ⲟ ⲕⲁⲗⲱⲥ ⲡⲉⲧⲉ⳿ϥⲛⲁⲁⲓϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ϯ⳿ⲥϩⲓⲙⲓ ⲉⲥ ⲥⲱⲛϩ ⳿ⲉⲡⲉⲥϩⲁⲓ ⳿ⲉⲫⲟⲥⲟⲛ ⳿ⲭⲣⲟⲛⲟⲛ ⲉϥⲟⲛϧ ⳿ⲛϫⲉ ⲡⲉⲥϩⲁⲓ ⲉϣⲱⲡ ⲇⲉ ⲁϥϣⲁⲛⲉⲛⲕⲟⲧ ⳿ⲛϫⲉ ⲡⲉⲥϩⲁⲓ ⲟⲩⲣⲉⲙϩⲏ ⲧⲉ ⳿ⲉϭⲓ ⳿ⲙⲡⲉⲧⲉϩⲛⲁⲥ ⲙⲟⲛⲟⲛ ϧⲉⲛ Ⲡ⳪.. ");
INSERT INTO copcnt_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ⲱⲟⲩ⳿ⲛⲓⲁⲧⲥ ⲇⲉ ⳿ⲛϩⲟⲩ⳿ⲟ ⲁⲥϣⲁⲛⲟϩⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⲕⲁⲧⲁ ⲧⲁ⳿ⲅⲛⲱⲙⲏ ϯⲙⲉⲩ⳿ⲓ ⲇⲉ ϩⲱ ϫⲉ ⲟⲩⲟⲛ ⲟⲩⲡⲛ̅ⲁ̅ ⳿ⲛⲧⲉ ⲫϯ ⳿ⲛ⳿ϩⲣⲏⲓ ⳿ⲛϧⲏⲧ. ");
INSERT INTO copcnt_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ⲉⲑⲃⲉ ⲛⲓϣⲱⲧ ⲇⲉ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲧⲉⲛⲥⲱⲟⲩⲛ ϫⲉ ⲟⲩⲟⲛ ⲟⲩ⳿ⲉⲙⲓ ⳿ⲛϧⲏⲧⲉⲛ ⲧⲏⲣⲟⲩ ⳿ⲡ⳿ⲉⲙⲓ ϣⲁϥϭⲓⲥⲓ ϯⲁⲅⲁⲡⲏ ⲇⲉ ϣⲁⲥⲕⲱⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ⲫⲏⲉⲧϫⲱ ⳿ⲙⲙⲟⲥ ϫⲉ ⲁⲓ⳿ⲉⲙⲓ ⳿ⲉ⳿ϩⲗⲓ ⳿ⲙⲡⲁⲧⲉϥ⳿ⲉⲙⲓ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϣⲉ ⳿ⲛ⳿ⲉⲙⲓ ⳿ⲙⲙⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ⲫⲏ ⲇⲉ ⲉⲧⲉⲣⲁⲅⲁⲡⲁⲛ ⳿ⲙⲫϯ ⲫⲁⲓ ⲁⲩⲥⲟⲩⲱⲛϥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ⲉⲑⲃⲉ ⲛⲓ⳿ϧⲣⲏⲟⲩ⳿ⲓ ⲟⲩⲛ ⳿ⲛⲧⲉ ⲛⲓϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⲡⲉ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ϧⲉⲛ ⲡⲓⲕⲟⲥⲙⲟⲥ ⲟⲩⲟϩ ϫⲉ ⳿ⲙⲙⲟⲛ ⳿ϩⲗⲓ ⳿ⲛⲛⲟⲩϯ ⳿ⲉⲃⲏⲗ ⳿ⲉⲟⲩⲁⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ⲕⲉ ⲅⲁⲣ ⲓⲥϫⲉ ⲟⲩⲟⲛ ϩⲁⲛⲟⲩⲟⲛ ⲉⲩⲙⲟⲩϯ ⳿ⲉⲣⲱⲟⲩ ϫⲉ ⲛⲟⲩϯ ⲓⲧⲉ ⳿ⲛ⳿ϩⲣⲏⲓ ϧⲉⲛ ⳿ⲧⲫⲉ ⲓⲧⲉ ϩⲓϫⲉⲛ ⲡⲓⲕⲁϩⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧⲉ ⲟⲩⲟⲛ ⲟⲩⲙⲏϣ ⳿ⲛⲛⲟⲩϯ ⲛⲉⲙ ⲟⲩⲙⲏϣ ⳿ⲛ⳪.. ");
INSERT INTO copcnt_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ⲛⲁⲛ ⲇⲉ ⳿ⲁⲛⲟⲛ ⲟⲩⲁⲓ ⲡⲉ ⲫϯ ⳿ⲫⲓⲱⲧ ⲫⲏⲉⲧⲁ ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲉϧⲟⲩⲛ ⳿ⲉⲣⲟϥ ⲟⲩⲁⲓ ⲡⲉ ⲡⲉⲛ⳪ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲫⲏⲉⲧⲁ ⲉⲛⲭⲁⲓⲛⲓⲃⲉⲛ ϣⲱⲡⲓ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⲟⲩⲟϩ ⳿ⲁⲛⲟⲛ ϩⲱⲛ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ⲁⲗⲗⲁ ⳿ⲡ⳿ⲉⲙⲓ ϧⲉⲛ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲁⲛ ϩⲁⲛⲟⲩⲟⲛ ⲅⲁⲣ ϣⲁ ⳿ⲉϧⲟⲩⲛ ⳿ⲉϯⲛⲟⲩ ϧⲉⲛ ϯⲕⲁϩⲥ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲓⲇⲱⲗⲟⲛ ⲥⲉⲟⲩⲱⲙ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩⲟϩ ⲧⲟⲩⲥⲩⲛⲏⲇⲏⲥⲓⲥ ⲉⲥϣⲱⲛⲓ ⳿ⲉⲣⲱⲟⲩ ϣⲁⲥϭⲱϧⲉⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ⲟⲩ⳿ϧⲣⲉ ⲇⲉ ⲁⲛ ⲉⲑⲛⲁⲧⲁϩⲟⲛ ⳿ⲉⲣⲁⲧⲉⲛ ⳿ⲙⲫϯ ⲟⲩⲇⲉ ⲁⲛ⳿ϣⲧⲉⲙⲟⲩⲱⲙ ⲧⲉⲛⲛⲁ⳿ϭⲣⲟϩ ⲁⲛ ⲟⲩⲇⲉ ⲁⲛϣⲁⲛⲟⲩⲱⲙ ⲧⲉⲛⲛⲁⲉⲣϩⲟⲩ⳿ⲟ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","⳿ⲁⲛⲁⲩ ⲇⲉ ⲙⲏⲡⲱⲥ ⳿ⲛⲧⲉ ⲡⲉⲧⲉⲛⲉⲣϣⲓϣⲓ ⲫⲁⲓ ⳿ⲛⲧⲉϥϣⲱⲡⲓ ⳿ⲛⲟⲩ⳿ϭⲣⲟⲡ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ⲁϥϣⲁⲛⲛⲁⲩ ⲅⲁⲣ ⳿ⲉⲣⲟⲕ ⳿ⲛϫⲉ ⲟⲩⲁⲓ ϧⲁ ⲫⲏⲉⲧⲉ ⳿ⲡ⳿ⲉⲙⲓ ⳿ⲛⲧⲟⲧϥ ⲉⲕⲣⲱⲧⲉⲃ ϧⲉⲛ ⲟⲩⲙⲁ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩⲭⲓ ⲧⲉϥⲥⲩⲛⲏⲇⲏⲥⲓⲥ ⲉⲥⲟⲓ ⳿ⲛⲣⲉϥϣⲱⲛⲓ ⳿ⲥⲛⲁⲕⲱⲧ ⳿ⲉ⳿ⲡϫⲓⲛ⳿ⲑⲣⲉϥⲟⲩⲉⲙ ϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ϣⲁϥⲧⲁⲕⲟ ⲅⲁⲣ ⳿ⲛϫⲉ ⲫⲏⲉⲧϣⲱⲛⲓ ϧⲉⲛ ⲡⲉⲕ⳿ⲉⲙⲓ ⲡⲓⲥⲟⲛ ⲉⲧⲁ Ⲡⲭ̅ⲥ̅ ⲙⲟⲩ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ⲡⲁⲓⲣⲏϯ ⲇⲉ ⲉⲣⲉⲧⲉⲛⲉⲣⲛⲟⲃⲓ ⳿ⲉⲛⲓ⳿ⲥⲛⲏⲟⲩ ⲟⲩⲟϩ ⲉⲣⲉⲧⲉⲛⲙⲓϣⲓ ⳿⳿ⲛⲧⲟⲩⲥⲩⲛⲏⲇⲏⲥⲓⲥ ⲉⲧϣⲱⲛⲓ ⲁⲣⲉⲧⲉⲛⲉⲣⲛⲟⲃⲓ ⳿ⲉⲠⲭ̅ⲥ̅. ");
INSERT INTO copcnt_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ⲉⲑⲃⲉⲫⲁⲓ ⲓⲥϫⲉ ⲟⲩ⳿ϧⲣⲉ ⲉⲑⲛⲁⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲡⲁⲥⲟⲛ ⳿ⲛⲛⲁⲟⲩⲉⲙ ⲁϥ ϣⲁ ⳿ⲉⲛⲉϩ ϩⲓⲛⲁ ⳿ⲛⲧⲁ⳿ϣⲧⲉⲙⲉⲣ⳿ⲥⲕⲁⲛⲇⲁⲗⲓⲍⲓⲛ ⳿ⲙⲡⲁⲥⲟⲛ. ");
INSERT INTO copcnt_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ⲙⲏ ⳿ⲁⲛⲟⲕ ⲟⲩⲣⲉⲙϩⲉ ⲁⲛ ⲙⲏ ⳿ⲁⲛⲟⲕ ⲟⲩⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁⲛ ⲙⲏ Ⲓⲏ̅ⲥ̅ Ⲡⲭ̅ⲥ̅ ⲡⲉⲛ⳪ ⳿ⲙⲡⲓⲛⲁⲩ ⳿ⲉⲣⲟϥ ⲙⲏ ⳿ⲛⲑⲱⲧⲉⲛ ⲁⲛ ⲡⲉ ⲡⲁϩⲱⲃ ϧⲉⲛ Ⲡ⳪.. ");
INSERT INTO copcnt_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ⲓⲥϫⲉ ϯⲟⲓ ⳿ⲛⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲁⲛ ⳿ⲛϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲁⲗⲗⲁ ϯⲟⲓ ⲛⲱⲧⲉⲛ ϯ⳿ⲥ⳿ⲫⲣⲁⲅⲓⲥ ⲅⲁⲣ ⳿ⲛⲧⲉ ⲧⲁⲙⲉⲧⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⳿ⲛⲑⲱⲧⲉⲛ ⲡⲉ ϧⲉⲛ Ⲡ⳪.. ");
INSERT INTO copcnt_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ⲧⲁⲁⲡⲟⲗⲟⲅⲓⲁ ⳿ⲛⲛⲏ ⲉⲧϧⲟⲧϧⲉⲧ ⳿ⲙⲙⲟⲓ ⲑⲁⲓ ⲧⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ⲙⲏ ⳿ⲙⲙⲟⲛⲧⲉⲛ ⲉⲣϣⲓϣⲓ ⳿ⲉⲟⲩⲱⲙ ⲛⲉⲙ ⳿ⲉⲥⲱ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ⲙⲏ ⲟⲩⲟⲛⲧⲉⲛ ⲉⲣϣⲓϣⲓ ⲉⲑⲣⲉ ⲟⲩⲥⲱⲛⲓ ⳿ⲛ⳿ⲥϩⲓⲙⲓ ⲙⲟϣⲓ ⳿ⲛⲥⲱⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲙ⳿ⲡⲥⲉⲡⲓ ⳿ⲛⲛⲓⲁⲡⲟⲥⲧⲟⲗⲟⲥ ⲛⲉⲙ ⲛⲓ⳿ⲥⲛⲏⲟⲩ ⳿ⲛⲧⲉ Ⲡ⳪ ⲛⲉⲙ ⲕⲏⲫⲁ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ϣⲁⲛ ⳿ⲁⲛⲟⲕ ⳿ⲙⲙⲁⲩⲁⲧ ⲛⲉⲙ ⲃⲁⲣⲛⲁⲃⲁⲥ ⲉⲧⲉ ⳿ⲙⲙⲟⲛⲧⲉⲛ ⲉⲣϣⲓϣⲓ ⳿ⲙⲙⲁⲩ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣϩⲱⲃ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ⲛⲓⲙ ⳿ⲉϣⲁϥⲉⲣⲙⲁⲧⲟⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲉⲧⲉⲛⲟⲩϥ ⳿ⲛⲟⲯⲱⲛⲓⲟⲛ ⲉⲛⲉϩ ⲛⲓⲙ ⳿ⲉϣⲁϥϭⲟ ⳿ⲛⲟⲩⲓⲁϩⲁⲗⲟⲗⲓ ⲟⲩⲟϩ ⳿ⲙⲡⲁϥⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉϥⲟⲩⲧⲁϩ ⲓⲉ ⲛⲓⲙ ⳿ⲉϣⲁϥⲙⲟⲛⲓ ⳿ⲛⲟⲩⲟϩⲓ ⳿ⲛ⳿ⲉⲥⲱⲟⲩ ⳿ⲛⲧⲉϥ⳿ϣⲧⲉⲙⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⳿ⲡⲉⲣⲱϯ ⳿ⲛⲧⲉ ⲡⲓⲟϩⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ⲙⲏ ⲁⲓⲥⲁϫⲓ ⳿ⲛⲛⲁⲓ ⲕⲁⲧⲁ ⲣⲱⲙⲓ ϣⲁⲛ ⲡⲓⲕⲉⲛⲟⲙⲟⲥ ⳿ⲛⲑⲟϥ ⳿ϥϫⲱ ⳿ⲛⲛⲁⲓ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","⳿ⲥ⳿ⲥϧⲏⲟⲩⲧ ⲅⲁⲣ ϧⲉⲛ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲙⲱ⳿ⲩⲥⲏⲥ ϫⲉ ⳿ⲛⲛⲉⲕϯ ⲥⲁⲭⲟⲗ ⳿ⲉ⳿ϩⲣⲉⲛ ⲉϩⲉ ⲉϥϩⲓ ⲙⲏ ⲁⲥⲉⲣⲙⲉⲗⲓⲛ ⳿ⲙⲫϯ ϧⲁ ⲛⲓ⳿ⲉϩⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ϣⲁⲛ ⲡⲁⲛⲧⲱⲥ ⲁϥϫⲱ ⳿ⲙⲙⲟⲥ ⲉⲑⲃⲏ ⲧⲉⲛ ⲉⲧⲁⲩ⳿ⲥϧⲏⲧⲟⲩ ⲅⲁⲣ ⲉⲑⲃⲏⲧⲉⲛ ϫⲉ ⳿ⲥⲉⲙ⳿ⲡϣⲁ ⳿ⲛⲧⲉ ⲫⲏ ⲉⲧ⳿ⲥⲭⲁⲓ ⳿ⲛⲧⲉϥ⳿ⲥⲭⲁⲓ ϧⲉⲛ ⲟⲩϩⲉⲗⲡⲓⲥ ⲟⲩⲟϩ ⲫⲏ ⲉⲧϩⲓ ⳿ⲛⲧⲉϥⲉⲣϩⲉⲗⲡⲓⲥ ⳿ⲉϭⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ⲓⲥϫⲉ ⳿ⲁⲛⲟⲛ ⲁⲛⲥⲓϯ ⲛⲱⲧⲉⲛ ⳿ⲛⲛⲓⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲛ ⲟⲩⲛⲓϣϯ ⲡⲉ ⲉϣⲱⲡ ⲁⲛϣⲁⲛⲱⲥϧ ⳿ⲛⲛⲉⲧⲉⲛⲥⲁⲣⲕⲓⲕⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ⲓⲥϫⲉ ϩⲁⲛⲕⲉⲭⲱⲟⲩⲛⲓ ⲉⲧϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲉⲧⲉⲛⲉⲣϣⲓϣⲓ ⳿ⲛϩⲟⲩ⳿ⲟ ⲙⲁⲗⲗⲟⲛ ⳿ⲁⲛⲟⲛ ⲁⲗⲗⲁ ⳿ⲙⲡⲉⲛ⳿ⲭⲣⲁⲥⲑⲉ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ⲁⲗⲗⲁ ⲧⲉⲛⲱⲟⲩ ⳿ⲛϩⲏⲧ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲛ⳿ϣⲧⲉⲙϯ ⳿ϩⲗⲓ ⳿ⲛ⳿ϭⲣⲟⲡ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲛⲧⲉ Ⲡⲭ̅ⲥ. ̅. ");
INSERT INTO copcnt_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲏ ⲉⲧⲉⲣϩⲱⲃ ⳿ⲉⲛⲓⲉⲣⲫⲏⲟⲩ⳿ⲓ ϣⲁⲩⲟⲩⲱⲙ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲛⲁ ⲡⲓⲉⲣⲫⲉⲓ ⲟⲩⲟϩ ⲛⲏ ⲉⲑⲙⲏⲛ ⳿ⲉⲡⲓⲙⲁ⳿ⲛⲉⲣϣⲱⲟⲩϣⲓ ϣⲁⲩⲫⲱϣ ⳿ⲉ⳿ϩⲣⲁⲩ ⲛⲉⲙ ⲡⲓⲙⲁ⳿ⲛⲉⲣϣⲱⲟⲩϣⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ⲡⲁⲓⲣⲏϯ ϩⲱϥ Ⲡ⳪ ⲁϥⲑⲱϣ ⳿ⲛⲛⲏⲉⲧϩⲓⲱⲓϣ ⳿ⲙⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⳿ⲉⲱⲛϧ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","⳿ⲁⲛⲟⲕ ⲇⲉ ⳿ⲙⲡⲓⲉⲣ⳿ⲭⲣⲁⲥⲑⲉ ⳿ⲛⲟⲩⲟⲛ ⳿ⲛⲛⲁⲓ ⲛⲉⲧⲁⲓ⳿ⲥϧⲉ ⲛⲁⲓ ⲇⲉ ⲁⲛ ϩⲓⲛⲁ ⳿ⲛⲥⲉϣⲱⲡⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ⳿ⲛ⳿ϧⲣⲏⲓ ⳿ⲛϧⲏⲧ ⲛⲁⲛⲉⲥ ⲅⲁⲣ ⲛⲏⲓ ⲙⲁⲗⲗⲟⲛ ⳿ⲉⲙⲟⲩ ⲓⲉ ⲡⲁϣⲟⲩϣⲟⲩ ⳿ⲛⲧⲉ⳿ϣⲧⲉⲙ ⳿ϩⲗⲓ ϣⲟⲩⲱϥ ⳿ⲉⲃⲟⲗ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","⳿ⲉϣⲱⲡ ⲅⲁⲣ ⲁⲓϣⲁⲛϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲟⲩϣⲟⲩϣⲟⲩ ⲛⲏⲓ ⲁⲛ ⲡⲉ ⲟⲩⲁⲛⲁⲅⲕⲏ ⲅⲁⲣ ⲉⲧⲭⲏ ϩⲓϫⲱⲓ ⲟⲩⲟⲓ ⲅⲁⲣ ⲛⲏⲓ ⲉϣⲱⲡ ⲁⲓ⳿ϣⲧⲉⲙϩⲓϣⲉⲛⲛⲟⲩϥⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ⲓⲥϫⲉ ⲅⲁⲣ ⲁⲓ⳿ⲓⲣⲓ ⳿ⲙⲫⲁⲓ ⳿ⲉ⳿ϩⲛⲏⲓ ⲓⲉ ⲟⲩⲟⲛϯ ⲃⲉⲭⲉ ⳿ⲙⲙⲁⲩ ⲓⲥϫⲉ ⳿ⲉ⳿ϩⲛⲏⲓ ⲁⲛ ⲓⲉ ⲟⲩⲟⲓⲕⲟⲛⲟⲙⲓⲁ ⲡⲉⲧⲁⲩⲧⲉⲛϩⲟⲩⲧ ⳿ⲉⲣⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ⲁϣ ⲟⲩⲛ ⲡⲉ ⲡⲁⲃⲉⲭⲉ ϩⲓⲛⲁ ⲉⲓϩⲓϣⲉⲛⲛⲟⲩϥⲓ ⳿ⲛⲧⲁⲭⲁ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ⲁⲧ⳿ϭⲛⲉ ⲇⲁⲡⲁⲛⲏ ⳿ⲉ⳿ϣⲧⲉⲙⲉⲣ⳿ⲭⲣⲁⲥⲑⲉ ⳿ⲙⲡⲁⲓⲉⲣϣⲓϣⲓ ϧⲉⲛ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ⲉⲓⲟⲓ ⲅⲁⲣ ⳿ⲛⲣⲉⲙϩⲉ ⳿ⲉⲃⲟⲗ ϩⲁ ⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⲁⲓⲁⲓⲧ ⳿ⲙⲃⲱⲕ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲙⲡⲓϩⲟⲩ⳿ⲟ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ⲁⲓϣⲱⲡⲓ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲓⲟⲩⲇⲁⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ⲁⲓϣⲱⲡⲓ ⳿ⲛⲛⲏ ⲉⲧⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲉⲓⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲛϯⲭⲏ ⳿ⲁⲛⲟⲕ ⲁⲛ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛⲛⲏⲉⲧⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ⲁⲓϣⲱⲡⲓ ⳿ⲛⲛⲓⲁⲛⲟⲙⲟⲥ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲁⲛⲟⲙⲟⲥ ⳿ⲉ⳿ⲁⲛⲟⲕ ⲟⲩⲁⲛⲟⲙⲟⲥ ⲁⲛ ⳿ⲛⲧⲉ ⲫϯ ⲁⲗⲗⲁ ⲉⲓⲭⲏ ϧⲁ ⳿ⲫⲛⲟⲙⲟⲥ ⳿ⲙⲠⲭ̅ⲥ̅ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛⲛⲓⲁⲛⲟⲙⲟⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ⲁⲓϣⲱⲡⲓ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛⲟⲩⲣⲉϥϣⲱⲛⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲁϫⲉⲙϩⲏⲟⲩ ⳿ⲛⲛⲏⲉⲧϣⲱⲛⲓ ⲁⲓϣⲱⲡⲓ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲛⲣⲏϯ ⲛⲓⲃⲉⲛ ϩⲓⲛⲁ ⲡⲁⲛⲧⲱⲥ ⳿ⲛⲧⲁⲛⲟϩⲉⲙ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ϯ⳿ⲓⲣⲓ ⳿ⲙⲙⲱⲟⲩ ⲉⲑⲃⲉ ⲡⲓⲉⲩⲁⲅⲅⲉⲗⲓⲟⲛ ϩⲓⲛⲁ ⳿ⲛⲧⲁⲉⲣ⳿ϣⲫⲏⲣ ⳿ⲉⲣⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","⳿ⲛⲧⲉⲧⲉⲛ⳿ⲉⲙⲓ ⲁⲛ ϫⲉ ⲛⲏⲉⲧϭⲟϫⲓ ϧⲉⲛ ⲡⲓ⳿ⲥⲧⲁⲇⲓⲟⲛ ⲥⲉϭⲟϫⲓ ⲙⲉⲛ ⲧⲏⲣⲟⲩ ⲟⲩⲁⲓ ⲇⲉ ⳿ⲉϣⲁϥϭⲓ ⳿ⲙⲡⲓⲃⲁⲓ ⲡⲁⲓⲣⲏϯ ⲇⲉ ϭⲟϫⲓ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛⲧⲁϩⲟ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ⲟⲩⲟⲛ ⲇⲉ ⲛⲓⲃⲉⲛ ⲉⲧⲉⲣⲁⲅⲱⲛⲓⲍⲉⲥⲑⲉ ϣⲁϥ⳿ⲁⲙⲟⲛⲓ ⳿ⲛⲧⲟⲧϥ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲛⲏ ⲙⲉⲛ ⲟⲩⲛ ϩⲓⲛⲁ ⳿ⲛⲥⲉϭⲓ ⳿ⲛⲟⲩ⳿ⲭⲗⲟⲙ ⲉϥⲛⲁⲧⲁⲕⲟ ⳿ⲁⲛⲟⲛ ⲇⲉ ⲟⲩⲁⲧⲧⲁⲕⲟ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","⳿ⲁⲛⲟⲕ ⲇⲉ ϯϭⲟϫⲓ ⳿ⲙⲡⲁⲓⲣⲏϯ ϩⲱⲥ ϧⲉⲛ ⲟⲩϩⲱⲡ ⲁⲛ ⲡⲁⲓⲣⲏϯ ϯϯ ϩⲱⲥ ⲉⲓϩⲓⲟⲩ⳿ⲓ ⲁⲛ ⳿ⲉⲡⲓⲁⲏⲣ.. ");
INSERT INTO copcnt_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ⲁⲗⲗⲁ ϯⲱϥⲓ ⳿ⲙⲡⲁⲥⲱⲙⲁ ⲟⲩⲟϩ ϯⲓⲣⲓ ⳿ⲙⲙⲟϥ ⳿ⲙⲃⲱⲕ ⲙⲏⲡⲱⲥ ⳿ⲉⲁⲓϩⲓⲱⲓϣ ⳿ⲛϩⲁⲛⲕⲉ ⲭⲱⲟⲩⲛⲓ ⳿ⲁⲛⲟⲕ ϩⲱ ⳿ⲛⲥⲉϫⲉⲙⲧ ⲉⲓⲟⲓ ⳿ⲛⲁⲇⲟⲕⲓⲙⲟⲥ. ");
INSERT INTO copcnt_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Ⲛ̇ϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲅⲁⲣ ⲁⲛ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧ⳿ⲉⲙⲓ ⲛⲁ⳿ⲥⲛⲏⲟⲩ ϫⲉ ⲛⲉⲛⲓⲟϯ ⲧⲏⲣⲟⲩ ⲛⲁⲩⲭⲏ ϧⲁ ϯϭⲏⲡⲓ ⲡⲉ ⲟⲩⲟϩ ⲁⲩⲥⲓⲛⲓ ⲧⲏⲣⲟⲩ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⳿ⲫⲓⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ⲟⲩⲟϩ ⲁⲩϭⲓⲱⲙⲥ ⲧⲏⲣⲟⲩ ⳿ⲉⲙⲱ⳿ⲩⲥⲏⲥ ϧⲉⲛ ϯϭⲏⲡⲓ ⲛⲉⲙ ϧⲉⲛ ⳿ⲫⲓⲟⲙ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ⲟⲩⲟϩ ⲧⲁⲓ⳿ϧⲣⲉ ⳿ⲛⲟⲩⲱⲧ ⳿ⲙⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲛ ⲁⲩⲟⲩⲟⲙⲥ ⲧⲏⲣⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ⲟⲩⲟϩ ⲡⲁⲓⲥⲱ ⳿ⲛⲟⲩⲱⲧ ⳿ⲙⲡⲛ̅ⲁ̅ⲧⲓⲕⲟⲛ ⲁⲩⲥⲟϥ ⲧⲏⲣⲟⲩ ⲛⲁⲩⲥⲱ ⲅⲁⲣ ⲡⲉ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲟⲩⲡⲛ̅ⲁ̅ⲧⲓⲕⲏ ⳿ⲙⲡⲉⲧⲣⲁ ⲉⲥⲙⲟϣⲓ ⳿ⲛⲥⲱⲟⲩ ϯⲡⲉⲧⲣⲁ ⲇⲉ ⲛⲉ Ⲡⲭ̅ⲥ̅ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ⲁⲗⲗⲁ ⳿ⲙⲡⲉ ⲫϯ ϯⲙⲁϯ ϧⲉⲛ ⲡⲟⲩϩⲟⲩ⳿ⲟ ⲁⲩⲫⲱϣ ⲅⲁⲣ ⳿ⲛ⳿ϩⲣⲏⲓ ϩⲓ ⳿ⲡϣⲁϥⲉ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ⲛⲁⲓ ⲇⲉ ⲁⲩϣⲱⲡⲓ ⲛⲁⲛ ⳿ⲛϩⲁⲛⲧⲩⲡⲟⲥ ϫⲉ ⳿ⲛⲧⲉⲛ⳿ϣⲧⲉⲙϣⲱⲡⲓ ⲉⲛⲟⲓ ⳿ⲛⲣⲉϥⲉⲣ⳿ⲉⲡⲓⲑⲩⲙⲓⲛ ⳿ⲛϩⲁⲛⲡⲉⲧϩⲱⲟⲩ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲁ ⲛⲏ ⲉⲣ⳿ⲉⲡⲓⲑⲩⲙⲓⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛϣⲱⲡⲓ ⳿ⲛϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲙ⳿ⲫⲣⲏϯ ⲉⲧ⳿ⲥϧⲏ ⲟⲩⲧ ϫⲉ ⲁϥϩⲉⲙⲥⲓ ⳿ⲛϫⲉ ⲡⲓⲗⲁⲟⲥ ⳿ⲉⲟⲩⲱⲙ ⲛⲉⲙ ⳿ⲉⲥⲱ ⲟⲩⲟϩ ⲁⲩⲧⲱⲟⲩⲛⲟⲩ ⳿ⲉⲥⲱⲃⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲉⲣⲡⲟⲣⲛⲉⲩⲓⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲁⲩⲉⲣⲡⲟⲣⲛⲉⲩⲓⲛ ⲟⲩⲟϩ ⲁⲩϩⲉⲓ ϧⲉⲛ ⲟⲩ⳿ⲉϩⲟⲟⲩ ⳿ⲛⲟⲩⲱⲧ ⳿ⲛϫⲉ ⲕ̅ⲅ̅ ⳿ⲛϣⲟ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲠⲭ̅ⲥ̅ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲁⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⲟⲩⲟϩ ⲁⲩⲧⲁⲕⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧⲟⲩ ⳿ⲛⲛⲓϩⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ⲟⲩⲇⲉ ⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉⲛⲉⲣ ⲣⲉⲣ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲟⲩⲟⲛ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧⲟⲩ ⳿ⲉⲁⲩ⳿ⲭⲣⲉⲙⲣⲉⲙ ⲟⲩⲟϩ ⲁⲩⲧⲁⲕⲟ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲟⲧϥ ⳿ⲙⲡⲓⲣⲉϥⲧⲁⲕⲟ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ⲛⲁⲓ ⲇⲉ ⲧⲏⲣⲟⲩ ⲁⲩϣⲱⲡⲓ ⳿ⲛⲧⲩⲡⲟⲥ ⳿ⲛⲛⲏ ⲁⲩ⳿ⲥϧⲏⲧⲟⲩ ⲇⲉ ⲛⲁⲛ ⲉⲩ⳿ⲥⲃⲱ ϧⲁ ⲛⲏ ⲉⲧⲁ ⳿ⲡϫⲱⲕ ⳿ⲛⲧⲉ ⲛⲓ⳿ⲉⲛⲉϩ ⲉⲣⲕⲁⲧⲁⲛⲧⲁⲛ ⳿ⲉⲣⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ϩⲱⲥⲧⲉ ⲫⲏⲉⲑⲙⲉⲩ⳿ⲓ ϫⲉ ⳿ϥⲟϩⲓ ⳿ⲉⲣⲁⲧϥ ⲙⲁⲣⲉϥⲛⲁⲩ ⲙⲏⲡⲱⲥ ⳿ⲛⲧⲉϥϩⲉⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","⳿ⲙⲡⲉ ⲡⲓⲣⲁⲥⲙⲟⲥ ⲧⲁϩⲉ ⲑⲏⲛⲟⲩ ⳿ⲉⲃⲏⲗ ⳿ⲉⲡⲓⲣⲁⲥⲙⲟⲥ ⳿ⲛⲣⲱⲙⲓ ⳿ϥⲉⲛϩⲟⲧ ⲇⲉ ⳿ⲛϫⲉ ⲫϯ ⲫⲏ ⲉⲧⲉ⳿ⲛ⳿ϥⲛⲁⲭⲁ ⲑⲏⲛⲟⲩ ⲁⲛ ⲉⲑⲣⲟⲩⲉⲣⲡⲓⲣⲁⲍⲓⲛ ⳿ⲙⲙⲱⲧⲉⲛ ⲥⲁⲃⲟⲗ ⳿ⲙⲫⲏⲉⲧⲉ ⲟⲩⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲣⲟϥ ⲁⲗⲗⲁ ⲉϥ⳿ⲉϯⲧⲟⲧϥ ⲛⲉⲙⲱⲧⲉⲛ ϧⲉⲛ ⲡⲓⲣⲁⲥⲙⲟⲥ ϩⲓⲛⲁ ⳿ⲛⲧⲉⲧⲉⲛ⳿ϣϫⲉⲙϫⲟⲙ ⳿ⲛϥⲁⲓ ϣⲁⲧⲉⲧⲉⲛ⳿ⲓ ⳿ⲉⲃⲟⲗ ⳿ⲛϧⲏⲧϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ⲉⲑⲃⲉ ⲫⲁⲓ ⲛⲁⲙⲉⲛⲣⲁϯ ⲫⲱⲧ ⳿ⲉⲃⲟⲗ ϩⲁ ϯⲙⲉⲧⲣⲉϥϣⲁⲙϣⲉ ⳿ⲓⲇⲱⲗⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ⲁⲓϫⲱ ⳿ⲙⲙⲟⲥ ⲛⲱⲧⲉⲛ ⳿ⲙ⳿ⲫⲣⲏϯ ⳿ⲛϩⲁⲛⲥⲁⲃⲉⲩ ⲙⲁϩⲁⲡ ⳿ⲛⲑⲱⲧⲉⲛ ⳿ⲉⲫⲏ⳿ⲉϯϫⲱ ⳿ⲙⲙⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ⲡⲓⲁⲫⲟⲧ ⳿ⲛⲧⲉ ϯⲉⲩⲗⲟⲅⲓⲁ ⲫⲏⲉⲧⲉⲛ⳿ⲥⲙⲟⲩ ⳿ⲉⲣⲟϥ ⲙⲏ ϯⲙⲉⲧ⳿ϣⲫⲏⲣ ⲁⲛ ⲧⲉ ⳿ⲛⲧⲉ ⳿ⲡ⳿ⲥⲛⲟϥ ⳿ⲙⲠⲭ̅ⲥ̅ ⲟⲩⲟϩ ⲡⲓⲱⲓⲕ ⳿ⲉⲧⲉⲛⲫⲱϣ ⳿ⲙⲙⲟϥ ⲙⲏ ϯⲙⲉⲧ⳿ϣⲫⲏⲣ ⲁⲛ ⲧⲉ ⳿ⲛⲧⲉ ⳿ⲡⲥⲱⲙⲁ ⳿ⲙⲠⲭ̅ⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ϫⲉ ⳿ⲁⲛⲟⲛ ⲧⲉⲛⲟⲓ ⳿ⲛⲟⲩⲁⲓ ⳿ⲛⲱⲓⲕ ⲟⲩⲁⲓ ⳿ⲛⲥⲱⲙⲁ ϧⲁ ⲛⲓⲙⲏϣ ⳿ⲁⲛⲟⲛ ⲅⲁⲣ ⲧⲏⲣⲟⲩ ⲧⲉⲛϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲁⲓⲱⲓⲕ ⳿ⲛⲟⲩⲱⲧ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","⳿ⲁⲛⲁⲩ ⳿ⲉⲡⲓⲥ̅ⲗ̅ ⲕⲁⲧⲁ ⲥⲁⲣⲝ ⲙⲏ ⲛⲏ ⲁⲛ ⲉⲑⲟⲩⲱⲙ ⳿ⲛⲛⲓϣⲟⲩϣⲱⲟⲩϣⲓ ⲉⲧⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲉⲡⲓⲙⲁ⳿ⲛⲉⲣϣⲱⲟⲩϣⲓ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ⲟⲩ ϫⲉ ⲡⲉⲧϯϫⲱ ⳿ⲙⲙⲟϥ ϫⲉ ϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩ ⲡⲉ ⲓⲉ ϫⲉ ⲟⲩ ⳿ⲛⲑⲟϥ ⲡⲉ ⳿ⲓⲇⲱⲗⲟⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ⲁⲗⲗⲁ ϫⲉ ⲛⲏⲉⲧⲟⲩϣⲱⲧ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛϫⲉ ⲛⲓⲉⲑⲛⲟⲥ ⲁⲩϣⲱⲧ ⳿ⲙⲙⲱⲟⲩ ⳿ⲛⲛⲓ⳿ⲓⲇⲱⲗⲟⲛ ⲟⲩⲟϩ ⲫϯ ⲁⲛ ⳿ⲛϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⲁⲛ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛ⳿ϣⲫⲏⲣ ⳿ⲛⲛⲓⲇⲉⲙⲱⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉⲥⲱ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲁⲫⲟⲧ ⳿ⲛⲧⲉ Ⲡ⳪ ⲛⲉⲙ ⲡⲓⲁⲫⲟⲧ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ ⳿ⲙⲙⲟⲛ ⳿ϣϫⲟⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⳿ⲉϭⲓ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ϯ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ Ⲡ⳪ ⲛⲉⲙ ϯ⳿ⲧⲣⲁⲡⲉⲍⲁ ⳿ⲛⲧⲉ ⲛⲓⲇⲉⲙⲱⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ϣⲁⲛ ⲁⲛⲛⲁϯⲭⲟϩ ⳿ⲙⲠ⳪ ⲙⲏ ⳿ⲁⲛⲟⲛ ϩⲁⲛϫⲱⲣⲓ ⳿ⲉϩⲟⲧⲉⲣⲟϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","⳿ⲥϣⲉ ⳿ⲛⲉⲣ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⳿ⲛⲥⲉⲉⲣⲛⲟϥⲣⲓ ⲧⲏⲣⲟⲩ ⲁⲛ ⲉⲝⲉⲥⲧⲓⲛ ⳿ⲉⲉⲣ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲁⲗⲗⲁ ⲥⲉⲕⲱⲧ ⲧⲏⲣⲟⲩ ⲁⲛ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","⳿ⲙⲡⲉⲛ⳿ⲑⲣⲉ ⳿ϩⲗⲓ ⲕⲱϯ ⳿ⲛⲥⲁ ⲡⲉⲧⲉⲫⲱϥ ⳿ⲙⲙⲁⲩⲁⲧϥ ⲁⲗⲗⲁ ⳿ⲛⲥⲁ ⲫⲁ ⲡⲉϥ⳿ϣⲫⲏⲣ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲉⲧⲟⲩϯ ⳿ⲙⲙⲱⲟⲩ ⳿ⲉⲃⲟⲗ ϧⲉⲛ ⲡⲓⲙⲁⲕⲉⲗⲗⲟⲥ ⲟⲩ⳿ⲟⲙⲟⲩ ⳿ⲛⲧⲉⲧⲉⲛϧⲟⲧϧⲉⲧ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⲉⲑⲃⲉ ϯⲥⲩⲛⲏⲇⲏⲥⲓⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ⲫⲁ Ⲡ⳪ ⲅⲁⲣ ⲡⲉ ⲡⲓⲕⲁϩⲓ ⲛⲉⲙ ⲡⲉϥⲙⲟϩ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ⲓⲥϫⲉ ⲟⲩⲟⲛ ⲟⲩⲁⲓ ⳿ⲛⲛⲓⲁⲑⲛⲁϩϯ ⲑⲱϩⲉⲙ ⳿ⲙⲙⲱⲧⲉⲛ ⲟⲩⲟϩ ⳿ⲛⲧⲉⲧⲉⲛⲟⲩⲱϣ ⲙⲁϣⲉ ⲛⲱⲧⲉⲛ ⲉⲛⲭⲁⲓ ⲛⲓⲃⲉⲛ ⲉⲧⲟⲩⲛⲁⲭⲁⲩ ϧⲁⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲟⲩ⳿ⲟⲙⲟⲩ ⳿ⲛⲧⲉⲧⲉⲛϧⲟⲧϧⲉⲧ ⲁⲛ ⳿ⲛ⳿ϩⲗⲓ ⲉⲑⲃⲉ ϯⲥⲩⲛⲏⲇⲏⲥⲓⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","⳿ⲉϣⲱⲡ ⲇⲉ ⲁⲣⲉϣⲁⲛ ⲟⲩⲁⲓ ϫⲟⲥ ⲛⲱⲧⲉⲛ ϫⲉ ⲟⲩϣⲱⲧ ⳿ⲛ⳿ⲓⲇⲱⲗⲟⲛ ⲡⲉ ⲫⲁⲓ ⳿ⲙⲡⲉⲣⲟⲩⲱⲙ ⲉⲑⲃⲉ ⲫⲏⲉⲧⲁϥⲧⲁⲙⲱⲧⲉⲛ ⲛⲉⲙ ⲉⲑⲃⲉ ϯⲥⲩⲛⲏⲇⲏⲥⲓⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ϯϫⲱ ⲇⲉ ⲉⲑⲃⲉ ⲟⲩⲥⲩⲛⲏⲇⲏⲥⲓⲥ ⳿ⲛⲑⲱⲕ ⲁⲛ ⲧⲉ ⲁⲗⲗⲁ ⲑⲁ ⲡⲉⲕ⳿ϣⲫⲏⲣ ⲉⲑⲃⲉⲟⲩ ⲅⲁⲣ ⲧⲁⲙⲉⲧⲣⲉⲙϩⲉ ⲥⲉⲛⲁϯϩⲁⲡ ⳿ⲉⲣⲟⲥ ⳿ⲉⲃⲟⲗ ϩⲓⲧⲉⲛ ⲕⲉⲥⲩⲛⲏⲇⲏⲥⲓⲥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ⲓⲥϫⲉ ⳿ⲁⲛⲟⲕ ϯϭⲓ ϧⲉⲛ ⲟⲩϣⲉⲡ⳿ϩⲙⲟⲧ ⲉⲑⲃⲉⲟⲩ ⲥⲉϫⲉⲟⲩ⳿ⲁ ⳿ⲉⲣⲟⲓ ⳿ⲉϫⲉⲛ ⲫⲏ ⳿ⲁⲛⲟⲕ ⲉϯϣⲉⲡ⳿ϩⲙⲟⲧ ⳿ⲉ⳿ϩⲣⲏⲓ ⳿ⲉϫⲱϥ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","⳿ⲓⲧⲉ ⲟⲩⲛ ⲧⲉⲧⲉⲛⲟⲩⲱⲙ ⳿ⲓⲧⲉ ⲧⲉⲧⲉⲛⲥⲱ ⳿ⲓⲧⲉ ⲧⲉⲧⲉⲛⲓⲣⲓ ⳿ⲛⲕⲉϩⲱⲃ ⲁⲣⲓ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⳿ⲉ⳿ⲡϯⲱⲟⲩ ⳿ⲙⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ⲟⲩⲟϩ ϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛⲟⲓ ⳿ⲛⲁⲧ⳿ϭⲣⲟⲡ ⳿ⲛⲛⲓⲓⲟⲩⲇⲁⲓ ⲛⲉⲙ ⲛⲓⲟⲩⲉⲓⲛⲓⲛ ⲛⲉⲙ ϯⲉⲕ⳿ⲕⲗⲏⲥⲓⲁ ⳿ⲛⲧⲉ ⲫϯ.. ");
INSERT INTO copcnt_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ϩⲱ ⲉⲧⲉ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ϯⲣⲁⲛⲁϥ ⳿ⲛⲟⲩⲟⲛ ⲛⲓⲃⲉⲛ ⳿ⲛϯⲕⲱϯ ⲁⲛ ⳿ⲛⲥⲁ ⲧⲁⲛⲟϥⲣⲓ ⳿ⲙⲙⲁⲩⲁⲧ ⲁⲗⲗⲁ ⲑⲁ ⲛⲓⲙⲏϣ ϩⲓⲛⲁ ⳿ⲛⲥⲉⲛⲟϩⲉⲙ. ");
INSERT INTO copcnt_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ϣⲱⲡⲓ ⲉⲣⲉⲧⲉⲛ⳿ⲟⲛⲓ ⳿ⲙⲙⲟⲓ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ϩⲱ ⳿ⲉϯ⳿ⲟⲛⲓ ⳿ⲙⲠⲭ̅ⲥ.̅. ");
INSERT INTO copcnt_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ϯⲧⲁⲓ⳿ⲟ ⲇⲉ ⳿ⲙⲙⲱⲧⲉⲛ ϫⲉ ⲧⲉⲧⲉⲛⲓⲣⲓ ⳿ⲙⲡⲁⲙⲉⲩ⳿ⲓ ϧⲉⲛ ϩⲱⲃ ⲛⲓⲃⲉⲛ ⲟⲩⲟϩ ⲕⲁⲧⲁ ⳿ⲫⲣⲏϯ ⲉⲧⲁⲓϯ ⳿ⲛⲛⲓⲡⲁⲣⲁⲇⲟⲥⲓⲥ ⳿ⲛⲧⲉⲛ ⲑⲏⲛⲟⲩ ⲧⲉⲧⲉⲛ⳿ⲁⲙⲟⲛⲓ ⳿ⲙⲙⲱⲟⲩ.. ");
INSERT INTO copcnt_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ϯⲟⲩⲉϣ ⲑⲏⲛⲟⲩ ⲇⲉ ⳿ⲉⲣⲉⲧⲉⲛ⳿ⲉⲙⲓ ϫⲉ ⳿ⲧ⳿ⲁⲫⲉ ⳿ⲛⲣⲱⲙⲓ ⲛⲓⲃⲉⲛ ⲡⲉ Ⲡⲭ̅ⲥ̅ ⳿ⲧ⳿ⲁⲫⲉ ⲇⲉ ⳿ⲛϯ⳿ⲥϩⲓⲙⲓ ⲡⲉⲥϩⲁⲓ ⲡⲉ ⳿ⲧ⳿ⲁⲫⲉ ⲇⲉ ⳿ⲙⲠⲭ̅ⲥ̅ ⲫϯ ⲡⲉ.. ");
INSERT INTO copcnt_vpl VALUES 