﻿USE sofia;
DROP TABLE IF EXISTS sofia.copbhc_vpl;
CREATE TABLE copbhc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES copbhc_vpl WRITE;
INSERT INTO copbhc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ⲠϪⲰⲘ ⲘⲘⲒⲤⲒ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲠϢⲎⲢⲒ ⲚⲀⲂⲢⲀⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ⲀⲂⲢⲀⲀⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲤⲀⲀⲔ ⲒⲤⲀⲀⲔ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲀⲔⲰⲂ ⲒⲀⲔⲰⲂ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲞⲨⲆⲀⲤ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ⲒⲞⲨⲆⲀⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲪⲀⲢⲈⲤ ⲚⲈⲘ ⲌⲀⲢⲀ ⲈⲂⲞⲖ ϦⲈⲚⲐⲀⲘⲀⲢ ⲪⲀⲢⲈⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲈⲤⲢⲰⲘ. ⲈⲤⲢⲰⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲢⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ⲀⲢⲀⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲘⲒⲚⲀⲆⲀⲂ ⲀⲘⲒⲚⲀⲆⲀⲂ ⲆⲈ ⲀϤϪⲪⲈ ⲚⲀⲤⲤⲰⲚ ⲚⲀⲤⲤⲰⲚ ⲆⲈ ⲀϤϪⲪⲈ ⲤⲀⲖⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ⲤⲀⲖⲘⲰⲚ ⲆⲈ ⲀϤϪⲪⲈ ⲂⲞⲈⲤ ⲈⲂⲞⲖ ϦⲈⲚⲢⲎⲬⲀⲂ ⲂⲞⲈⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲞⲨⲂⲎⲆ ⲒⲞⲨⲂⲎⲆ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲈⲤⲤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ⲒⲈⲤⲤⲈ ⲆⲈ ⲀϤϪⲪⲈ ⲆⲀⲨⲒⲆ ⲆⲀⲨⲒⲆ ⲆⲈ ⲀϤϪⲪⲈ ⲤⲞⲖⲞⲘⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲐⲀ ⲞⲨⲢⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ⲤⲞⲖⲞⲘⲰⲚ ⲆⲈ ⲀϤϪⲪⲈ ⲢⲞⲂⲞⲀⲘ ⲢⲞⲂⲞⲀⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲂⲒⲀ ⲀⲂⲒⲀ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲤⲀⲪ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ⲀⲤⲀⲪ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲰⲤⲀⲪⲀⲦ ⲒⲰⲤⲀⲪⲀⲦ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲰⲢⲀⲘ ⲒⲰⲢⲀⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲞⲌⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ⲞⲌⲒⲀⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲰⲀⲐⲀⲘ ⲒⲰⲀⲐⲀⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲬⲀⲌ ⲀⲬⲀⲌ ⲆⲈ ⲀϤϪⲪⲈ ⲈⲌⲈⲔⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ⲈⲌⲈⲔⲒⲀⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲘⲀⲚⲀⲤⲤⲎ ⲘⲀⲚⲀⲤⲤⲎ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲘⲰⲤ ⲀⲘⲰⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲰⲤⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ⲒⲰⲤⲒⲀⲤ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲈⲬⲞⲚⲒⲀⲤ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ ϨⲒ ⲠⲒⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚⲦⲈⲂⲀⲂⲨⲖⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚⲦⲈⲂⲀⲂⲨⲖⲰⲚ ⲒⲈⲬⲞⲚⲒⲀⲤ ⲀϤϪⲪⲈ ⲤⲀⲖⲀⲐⲒⲎⲖ ⲤⲀⲖⲀⲐⲒⲎⲖ ⲆⲈ ⲀϤϪⲪⲈ ⲌⲞⲢⲞⲂⲀⲂⲈⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ⲌⲞⲢⲞⲂⲀⲂⲈⲖ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲂⲒⲞⲨⲆ ⲀⲂⲒⲞⲨⲆ ⲆⲈ ⲀϤϪⲪⲈ ⲈⲖⲒⲀⲔⲒⲘ ⲈⲖⲒⲀⲔⲒⲘ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲌⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ⲀⲌⲰⲢ ⲆⲈ ⲀϤϪⲪⲈ ⲤⲀⲆⲰⲔ ⲤⲀⲆⲰⲔ ⲆⲈ ⲀϤϪⲪⲈ ⲀⲬⲒⲚ ⲀⲬⲒⲚ ⲆⲈ ⲀϤϪⲪⲈ ⲈⲖⲒⲞⲨⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ⲈⲖⲒⲞⲨⲆ ⲆⲈ ⲀϤϪⲪⲈ ⲈⲖⲈⲀⲌⲀⲢ ⲈⲖⲈⲀⲌⲀⲢ ⲆⲈ ⲀϤϪⲪⲈ ⲘⲀⲦⲐⲀⲚ ⲘⲀⲦⲐⲀⲚ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲀⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ⲒⲀⲔⲰⲂ ⲆⲈ ⲀϤϪⲪⲈ ⲒⲰⲤⲎⲪ ⲠϨⲀⲒ ⲘⲘⲀⲢⲒⲀ ⲐⲎ ⲈⲦⲀⲤⲘⲈⲤ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ϪⲰⲞⲨ ⲚⲒⲂⲈⲚ ⲒⲤϪⲈⲚ ⲀⲂⲢⲀⲀⲘ ϢⲀ ⲆⲀⲨⲒⲆ ⲒⲆ ⲚϪⲰⲞⲨ ⲞⲨⲞϨ ⲒⲤϪⲈⲚ ⲆⲀⲨⲒⲆ ϢⲀ ⲠⲒⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚⲦⲈⲂⲀⲂⲨⲖⲰⲚ ⲒⲆ ⲚϪⲰⲞⲨ ⲞⲨⲞϨ ⲒⲤϪⲈⲚ ⲠⲒⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚⲦⲈⲂⲀⲂⲨⲖⲰⲚ ϢⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲆ ⲚϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ⲠϪⲒⲚⲘⲒⲤⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲞⲨ ⲠⲀⲒⲢⲎϮ ⲈⲦⲀⲨⲰⲠ ⲚⲤⲀⲦⲈϤⲘⲀⲨ ⲘⲀⲢⲒⲀ ⲚⲒⲰⲤⲎⲪ ⲘⲠⲀⲦⲞⲨⲤⲞⲨⲈⲚ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲀⲨϪⲈⲘⲤ ⲈⲤⲘⲂⲞⲔⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ⲒⲰⲤⲎⲪ ⲆⲈ ⲠⲈⲤϨⲀⲒ ⲚⲈⲞⲨⲐⲘⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲚϤⲞⲨⲰϢ ⲀⲚ ⲈⲀⲒⲤ ⲚⲤⲢⲀϨ ⲀϤⲤⲞϬⲚⲒ ⲈⲬⲀⲤ ⲈⲂⲞⲖ ⲚⲬⲰⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀϤⲘⲞⲔⲘⲈⲔ ⲈⲢⲰⲞⲨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲒⲰⲤⲎ ⲪϦⲈⲚ ⲞⲨⲢⲀⲤⲞⲨⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲤⲎⲪ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲈϢⲈⲠ ⲘⲀⲢⲒⲀ ⲦⲈⲔⲤϨⲒⲘⲒ ⲈⲢⲞⲔ ⲪⲎ ⲄⲀⲢ ⲈⲦⲈⲤⲚⲀⲘⲀⲤϤ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ⲈⲤⲈⲘⲒⲤⲒ ⲆⲈ ⲚⲞⲨϢⲎⲢⲒ ⲈⲔⲈⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲐⲞϤ ⲄⲀⲢ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲘⲠⲈϤⲖⲀⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ⲪⲀⲒ ⲆⲈ ⲦⲎⲢϤ ⲀϤϢⲰⲠⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀ ⲠϬⲞⲒⲤ ϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ϮⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲤⲈⲈⲢⲂⲞⲔⲒ ⲞⲨⲞϨ ⲈⲤⲈⲘⲒⲤⲒ ⲚⲞⲨϢⲎⲢⲒ ⲈⲨⲈⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲈⲘⲘⲀⲚⲞⲨⲎⲖ ⲪⲎ ⲈⲦⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲪⲚⲞⲨϮ ⲚⲈⲘⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲒⲰⲤⲎⲪ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲔⲞⲦ ⲀϤⲒⲢⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲀϤ ⲞⲨⲞϨ ⲀϤϢⲈⲠ ⲘⲀⲢⲒⲀ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ⲞⲨⲞϨ ⲘⲠⲈϤⲤⲞⲨⲰⲚⲤ ϢⲀⲦⲈⲤⲘⲒⲤⲒ ⲘⲠⲒϢⲎ ⲢⲒ ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀⲨⲘⲀⲤϤ ϦⲈⲚⲂⲎⲐⲖⲈⲈⲘ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ ⲠⲞⲨⲢⲞ ϨⲎⲠⲠⲈ ⲒⲤ ϨⲀⲚⲘⲀⲄⲞⲤ ⲀⲨⲒ ⲈⲂⲞⲖ ⲤⲀⲠⲈⲒⲈⲂⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤⲐⲰⲚ ⲪⲎ ⲈⲦⲀⲨⲘⲀⲤϤ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲚⲚⲀⲨ ⲄⲀⲢ ⲈⲠⲈϤⲤⲒⲞⲨ ⲤⲀⲠⲈⲒⲈⲂⲦ ⲀⲚⲒ ϪⲈ ⲚⲦⲈⲚⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲠⲞⲨⲢⲞ ⲎⲢⲰⲆⲎⲤ ⲀϤϢⲐⲞⲢⲦⲈⲢ ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲦⲎⲢⲤ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ⲞⲨⲞϨ ⲈⲦⲀϤⲐⲰⲞⲨϮ ⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲀϤϢⲒⲚⲒ ⲚⲦⲞⲦⲞⲨ ϪⲈ ⲀⲨⲚⲀⲘⲈⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ϦⲈⲚⲂⲎⲐⲖⲈⲈⲘ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲠⲀⲒⲢⲎϮ ⲄⲀⲢ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ϪⲈ ⲚⲈⲘ ⲚⲐⲞ ϨⲰⲒ ⲂⲎⲐⲖⲈⲈⲘ ⲠⲔⲀϨⲒ ⲚⲒⲞⲨⲆⲀ ⲚⲐⲞ ⲞⲨⲔⲞⲨϪⲒ ⲀⲚ ϦⲈⲚⲚⲒⲘⲈⲦϨⲎⲄⲈⲘⲰⲚ ⲚⲦⲈⲒⲞⲨⲆⲀ ⲈϤⲈⲒ ⲄⲀⲢ ⲈⲂⲞⲖ ⲚϦⲎϮ ⲚϪⲈⲞⲨϨⲎⲄⲞⲨⲘⲈⲚⲞⲤ ⲪⲎ ⲈⲐⲚⲀⲀⲘⲞⲚⲒ ⲘⲠⲀⲖⲀⲞⲤ ⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ⲦⲞⲦⲈ ⲎⲢⲰⲆⲎⲤ ⲀϤⲘⲞⲨϮ ⲈⲚⲒⲘⲀⲄⲞⲤ ⲚⲬⲰⲠ ⲀϤϦⲞⲦϦⲈⲦ ⲚⲦⲞⲦⲞⲨ ⲚⲤⲀⲠⲒⲤⲎⲞⲨ ⲚⲦⲈⲠⲒⲤⲒⲞⲨ ⲈⲦⲀϤⲞⲨⲰⲚϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲈⲂⲎⲐⲖⲈⲈⲘ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ϢⲒⲚⲒ ⲀⲔⲢⲒⲂⲰⲤ ⲈⲐⲂⲈ ⲠⲒⲀⲖⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲦⲈⲚϪⲈⲘϤ ⲘⲀⲦⲀⲘⲞⲒ ϨⲒⲚⲀ ⲚⲦⲀⲒ ϨⲰ ⲚⲦⲀⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚⲤⲀⲠⲞⲨⲢⲞ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲒⲤⲒⲞⲨ ⲪⲎ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲤⲀⲠⲈⲒⲈⲂⲦ ⲚⲀϤⲘⲞϢⲒ ϦⲀϪⲰⲞⲨ ϢⲀⲦⲈϤⲒ ⲚⲦⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲠϢⲰⲒ ⲘⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲠⲒⲀⲖⲞⲨ ⲬⲎ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲠⲒⲤⲒⲞⲨ ⲀⲨⲢⲀϢⲒ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲠⲒⲎⲒ ⲀⲨⲚⲀⲨ ⲈⲠⲒⲀⲖⲞⲨ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲒⲦⲞⲨ ⲈϦⲢⲎ ⲒⲀⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲞⲨⲰⲚ ⲚⲚⲞⲨⲀϨⲰⲢ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚϨⲀⲚⲆⲰⲢⲞⲚ ⲞⲨⲚⲞⲨⲂ ⲚⲈⲘ ⲞⲨⲖⲒⲂⲀⲚⲞⲤ ⲚⲈⲘ ⲞⲨϢⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲀⲘⲰⲞⲨ ϦⲈⲚⲞⲨⲢⲀⲤⲞⲨⲒ ⲈϢⲦⲈⲘⲔⲞⲦⲞⲨ ϨⲀ ⲎⲢⲰⲆⲎⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲔⲈⲘⲰⲒⲦ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲦⲞⲨⲬⲰⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲆⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲒⲰⲤⲎⲪ ϦⲈⲚⲞⲨⲢⲀⲤⲞⲨⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲀⲖⲒⲞⲨⲒ ⲘⲠⲒⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲪⲰⲦ ⲈⲬⲎⲘⲒ ⲞⲨⲞϨ ϢⲰⲠⲒ ⲘⲘⲀⲨ ϢⲀϮϪⲞⲤ ⲚⲀⲔ ϤⲚⲀⲔⲰϮ ⲄⲀⲢ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲚⲤⲀⲠⲒⲀⲖⲞⲨ ⲈⲦⲀⲔⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲦⲰⲚϤ ⲀϤϬⲒ ⲘⲠⲒⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲚϪⲰⲢϨ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲬⲎⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲘⲘⲀⲨ ⲠⲈ ϢⲀ ⲦϦⲀⲎ ⲚⲎⲢⲰⲆⲎⲤ ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀ ⲠϬⲞⲒⲤ ϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲘⲞⲨϮ ⲈⲠⲀϢⲎⲢⲒ ⲈⲂⲞⲖ ϦⲈⲚⲬⲎⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ⲦⲞⲦⲈ ⲎⲢⲰⲆⲎⲤ ⲈⲦⲀϤⲚⲀⲨ ϪⲈ ⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲚϪⲈⲚⲒⲘⲀⲄⲞⲤ ⲀϤⲘⲂⲞⲚ ⲈⲘⲀϢⲰ ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲀϤϦⲰⲦⲈⲂ ⲚⲀⲖⲞⲨ ⲚⲒⲂⲈⲚ ⲈⲦϦⲈⲚ ⲂⲎⲐⲖⲈⲈⲘ ⲚⲈⲘ ϦⲈⲚⲚⲈⲤϬⲒⲎ ⲦⲎⲢⲞⲨ ⲒⲤϪⲈⲚ ⲢⲞⲘⲠⲒ ⲤⲚⲞⲨϮ ⲚⲈⲘ ⲤⲀⲠⲈⲤⲎⲦ ⲔⲀⲦⲀ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲀϤϦⲈⲦϦⲰⲦϤ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒⲘⲀⲄⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ⲦⲞⲦⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲒⲈⲢⲈⲘⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ϪⲈ ⲞⲨⲤⲘⲎ ⲀⲨⲤⲞⲐⲘⲈⲤ ϦⲈⲚⲢⲀⲘⲀ ⲢⲀⲬⲎⲖ ⲈⲤⲢⲒⲘⲒ ⲈⲚⲈⲤϢⲎⲢⲒ ⲞⲨⲞϨ ⲚⲀⲤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲈϮⲚⲞⲘϮ ⲚⲀⲤ ϪⲈ ⲤⲈϢⲞⲠ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ⲈⲦⲀϤⲘⲞⲨ ⲆⲈ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲒⲰⲤⲎⲪ ϦⲈⲚⲞⲨⲢⲀⲤⲞⲨⲒ ϦⲈⲚⲬⲎⲘⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ϪⲈ ⲦⲰⲚⲔ ϬⲒ ⲘⲠⲒⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲔⲀϨⲒ ⲘⲠⲒⲤⲖ ⲀⲨⲘⲞⲨ ⲄⲀⲢ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰϮ ⲚⲤⲀⲦⲮⲨⲬⲎ ⲘⲠⲒⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲦⲰⲚϤ ⲀϤϬⲒ ⲘⲠⲒⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲔⲀϨⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ϪⲈ ⲀⲢⲬⲈⲖⲀⲞⲤ ⲈⲦⲞⲒ ⲚⲞⲨⲢⲞ ⲈϮⲒⲞⲨⲆⲈⲀ ⲚⲦϢⲈⲂⲒⲰ ⲚⲎⲢⲰⲆⲎⲤ ⲠⲈϤⲒⲰⲦ ⲀϤⲈⲢϨⲞϮ ⲈϢⲈ ⲈⲘⲀⲨ ⲈⲦⲀⲨⲦⲀⲘⲞϤ ⲆⲈ ϦⲈⲚⲞⲨⲢⲀⲤⲞⲨⲒ ⲀϤϢⲈ ⲚⲀϤ ⲈⲚⲒⲤⲀ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ⲞⲨⲞϨ ⲀϤⲒ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲂⲀⲔⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲚⲀⲌⲀⲢⲈⲐ. ϨⲞⲠⲰⲤ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ϦⲈⲚ ⲚⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲒ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲈϤϨⲒⲰⲒϢ ϨⲒ ⲠϢⲀϤⲈ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ");
INSERT INTO copbhc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲀⲤϦⲰⲚⲦ ⲄⲀⲢ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ⲪⲀⲒ ⲄⲀⲢ ⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲤⲘⲎ ⲘⲪⲎ ⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϢⲀϤⲈ ϪⲈ ⲤⲈⲂⲦⲈ ⲪⲘⲰⲒⲦ ⲘⲠϬⲞⲒⲤ ⲤⲞⲨⲦⲰⲚ ⲚⲚⲈϤⲘⲀⲚⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ⲚⲐⲞϤ ⲆⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲦⲈϤϨⲈⲂⲤⲰ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϤⲰⲒ ⲚϬⲀⲘⲞⲨⲖ ⲦⲈ ⲞⲨⲞϨ ⲚⲀϤⲘⲎⲢ ⲚⲞⲨⲘⲞϪϦ ⲚϢⲀⲢ ⲈϪⲈⲚ ⲦⲈϤϮⲠⲒ ⲦⲈϤϦⲢⲈ ⲆⲈ ⲚⲈⲞⲨϢϪⲈ ⲦⲈ ⲚⲈⲘ ⲞⲨⲈⲂⲒⲰ ⲚⲦⲈⲦⲔⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ⲦⲞⲦⲈ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲠⲈ ⲚϪⲈⲚⲀ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲚⲦⲈⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ⲞⲨⲞϨ ⲚⲀⲨϬⲒⲰⲘⲤ ⲚⲦⲞⲦϤ ϦⲈⲚⲠⲒⲒⲞⲢⲆⲀⲚⲎ ⲤⲚⲒⲀⲢⲞ ⲈⲨⲞⲨⲰⲚϨ ⲚⲚⲞⲨⲚⲞⲂⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲞⲨⲘⲎϢ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲈⲨⲚⲎⲞⲨ ⲈϪⲈⲚ ⲠⲒⲰⲘⲤ ⲚⲦⲀϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘⲒⲤⲒ ⲚⲦⲈⲚⲒⲀϪⲰ ⲚⲒⲘ ⲀϤⲦⲀⲘⲈ ⲐⲎⲚⲞⲨ ⲈⲪⲰⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲒϪⲰⲚⲦ ⲈⲐⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ⲀⲢⲒⲞⲨⲒ ⲞⲨⲚ ⲚⲞⲨⲞⲨⲦⲀϨ ⲈϤⲘⲠϢⲀ ⲚϮⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ⲞⲨⲞϨ ⲘⲠⲈⲢⲘⲈⲨⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϪⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲚⲦⲀⲚ ⲘⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲒⲰⲚⲒ ⲈⲦⲞⲨⲚⲈⲤ ϢⲎⲢⲒ ⲚⲀⲂⲢⲀⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ϨⲎⲆⲎ ⲆⲈ ⲠⲒⲔⲈⲖⲈⲂⲒⲚ ϤⲬⲎ ϦⲀ ⲐⲚⲞⲨⲚⲒ ⲚⲚⲒϢϢⲎⲚ ϢϢⲎⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈϤⲚⲀⲈⲚ ⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ ⲈⲂⲞⲖ ⲀⲚ ⲤⲈⲚⲀⲔⲞⲢϪϤ ⲚⲤⲈϨⲒⲦϤ ⲈⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ⲀⲚⲞⲔ ⲘⲈⲚ ⲄⲀⲢ ϮⲰⲘⲤ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲪⲎ ⲆⲈ ⲈⲐⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ϤϪⲞⲢ ⲈϨⲞⲦⲈⲢⲞⲒ ⲪⲎ ⲈⲦⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲈϤⲀⲒ ⲘⲠⲈϤⲐⲰⲞⲨⲒ ⲚⲐⲞϤ ⲈϤⲈⲈⲘⲤ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲚⲈⲘ ⲞⲨⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ⲪⲎ ⲆⲈ ⲠⲈϤϦⲀⲒ ϦⲈⲚⲦⲈϤϪⲒϪ ϤⲚⲀⲦⲞⲨⲂⲞ ⲘⲠⲈϤϬⲚⲰⲞⲨ ⲞⲨⲞϨ ϤⲚⲀⲐⲰⲞⲨϮ ⲘⲠⲈϤⲤⲞⲨⲞ ⲈϮⲀⲠⲞⲐⲎⲔⲎ ⲠⲒⲦⲞϨ ⲆⲈ ϤⲚⲀⲢⲞⲔϨϤ ϦⲈⲚⲞⲨⲬⲢⲰⲘ ⲚⲀⲦϬⲈⲚⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ⲦⲞⲦⲈ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲈϪⲈⲚ ⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ϨⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲈⲐⲢⲈϤϬⲒⲰⲘⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ⲚⲀϤⲦⲀϨⲚⲞ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲈⲦⲈⲢⲬⲢⲒⲀ ⲈϬⲒⲰⲘⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ⲞⲨⲞϨ ⲚⲐⲞⲔ ⲈⲐⲚⲎⲞⲨ ϨⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲬⲀⲤ ϮⲚⲞⲨ ⲠⲀⲒⲢⲎϮ ⲠⲈⲦⲤⲈⲘⲠϢⲀ ⲚⲀⲚ ⲈϪⲈⲔ ⲘⲈⲐⲘⲎⲒ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ⲦⲞⲦⲈ ⲀϤⲬⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ⲈⲦⲀϤⲰⲘⲤ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲞⲨ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲀⲨⲞⲨⲰⲚ ⲚⲀϤ ⲚϪⲈⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲘⲪⲢⲎϮ ⲚⲞⲨϬⲢⲞⲘⲠⲒ ⲈϤⲚⲎⲞⲨ ϨⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲤⲘⲎ ⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲠⲀⲘⲈⲚⲢⲒⲦ ⲈⲦⲀⲒϮⲘⲀϮ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ⲦⲞⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲠⲒⲠⲚⲈⲨⲘⲀⲞⲖϤ ⲈⲠϢⲀϤⲈ ⲈⲠϪⲒⲚⲦⲈ ⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲚⲘⲚⲈϨⲞⲞⲨ ⲚⲈⲘ ⲘⲚⲈϪⲰⲢϨ ⲈⲠϦⲀⲈ ⲀϤϨⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲪⲎ ⲈⲦϬⲰⲚⲦ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲀϪⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲚⲀⲒⲰⲚⲒ ⲈⲢⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲤϦⲎ ⲞⲨⲦ ϪⲈ ⲚⲀⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀⲰⲚϦ ⲈⲰⲒⲔ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲀⲖⲖⲀ ⲈϪⲈⲚ ⲤⲀϪⲒ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ⲦⲞⲦⲈ ⲀϤⲞⲖϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲈϮⲂⲀⲔⲒ ⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲈϪⲈⲚ ⲠⲦⲈⲚϨ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ϨⲒⲦⲔ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ⲦⲀⲒ ⲤⲤϦⲎ ⲞⲨⲦ ⲄⲀⲢ ϪⲈ ϤⲚⲀϨⲞⲚϨⲈⲚ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲐⲂⲎⲦⲔ ⲞⲨⲞϨ ⲈⲨⲈϤⲒⲦⲔ ϨⲒϪⲈⲚ ⲚⲞⲨϪⲒϪ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲔϬⲒϬⲢⲞⲠ ⲈⲞⲨⲰⲚⲒ ⲚⲦⲈⲔϬ ⲀⲖⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲀⲖⲒⲚ ⲤⲤϦⲎ ⲞⲨⲦ ϪⲈ ⲚⲚⲈⲔⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲞⲖϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲈϪⲈⲚ ⲞⲨⲦⲰⲞⲨ ⲈϤϬⲞⲤⲒ ⲈⲘⲀϢⲰ ⲞⲨⲞϨ ⲀϤⲦⲀⲘⲞϤ ⲈⲚⲒⲘⲈⲦⲞⲨⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲈⲘ ⲠⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϮⲚⲀⲦⲎⲒⲦⲞⲨ ⲚⲀⲔ ⲀⲔϢⲀⲚϨⲒⲦⲔ ⲈϦⲢⲎⲒ ⲚⲦⲈⲔⲞⲨⲰϢⲦ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲠⲈⲦⲈⲔⲈⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲠⲈⲦⲈⲔⲈϢⲈⲘϢⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ⲦⲞⲦⲈ ⲀϤⲬⲀϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲞⲨⲞϨ ⲒⲤ ϨⲀⲚⲀⲄⲄⲈⲖⲞⲤ ⲀⲨⲒ ⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ϪⲈ ⲀⲨϮ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ⲞⲨⲞϨ ⲀϤⲬⲰ ⲚⲚⲀⲌⲀⲢⲈⲐ ⲚⲤⲰϤ ⲀϤⲒ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲐⲎ ⲈⲦϨⲒⲤⲔⲈⲚ ⲪⲒⲞⲘ ϦⲈⲚⲚⲒϬⲒⲎ ⲚⲦⲈⲌⲀⲂⲞⲨⲖⲰⲚ ⲚⲈⲘ ⲚⲈⲪⲐⲀⲖⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ϪⲈ ⲠⲔⲀϨⲒ ⲚⲌⲀⲂⲞⲨⲖⲰⲚ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲚⲚⲈⲪⲐⲀⲖⲒⲘ ⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲪⲒⲞⲘ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ϮⲄⲀⲖⲒⲖⲈⲀ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ⲠⲒⲖⲀⲞⲤ ⲈⲦϨⲈⲘⲤⲒ ϦⲈⲚⲠⲬⲀⲔⲒ ⲀϤⲚⲀⲨ ⲈⲞⲨⲚⲒϢϮ ⲚⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ϦⲈⲚⲦⲬⲰⲢⲀ ⲚⲈⲘ ⲦϦⲎⲒⲂⲒ ⲘⲪⲘⲞⲨ ⲞⲨⲞⲨⲰⲒⲚⲒ ⲀϤϢⲀⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ⲒⲤϪⲈⲚ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚϨⲒⲰⲒϢ ⲚⲈⲘ ⲈϪⲞⲤ ϪⲈ ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲀⲤϦⲰⲚⲦ ⲄⲀⲢ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ⲈϤⲘⲞϢⲒ ⲆⲈ ⲈⲤⲔⲈⲚ ⲪⲒⲞⲘ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀϤⲚⲀⲨ ⲈⲤⲞⲚ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲠⲈϤⲤⲞⲚ ⲈⲨϨⲒ ϢⲚⲈ ⲈⲪⲒⲞⲘ ⲚⲈϨⲀⲚⲞⲨⲞϨⲒ ⲄⲀⲢ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲚⲦⲀⲈⲢ ⲐⲎⲚⲞⲨ ⲚⲞⲨⲞϨⲒ ⲚⲢⲈϤⲦⲀϨⲈ ⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ⲚⲐⲰⲞⲨ ⲆⲈ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲬⲰ ⲚⲚⲞⲨϢⲚⲎ ⲞⲨ ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲦϨⲎ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤⲚⲀⲨ ⲈⲔⲈⲤⲞⲚ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ⲈⲨϨⲒ ⲠⲒϪⲞⲒ ⲚⲈⲘ ⲌⲈⲂⲈⲆⲈⲞⲤ ⲠⲞⲨⲒⲰⲦ ⲈⲨⲤⲞⲂϮ ⲚⲚⲞⲨϢⲚⲎ ⲞⲨ ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ⲚⲐⲰⲞⲨ ⲆⲈ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲬⲰ ⲘⲠⲒϪⲞⲒ ⲚⲈⲘ ⲌⲈⲂⲈⲆⲈⲞⲤ ⲠⲞⲨⲒⲰⲦ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲦⲎⲢⲤ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲈϤϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈϤⲈⲢⲪⲀϦⲢⲒ ⲈϢⲰⲚⲒ ⲚⲒⲂⲈⲚ ⲈⲦϦⲈⲚ ⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ⲞⲨⲞϨ ⲀⲦⲈϤⲤⲘⲎ ⲒⲈⲂⲞⲖ ϦⲈⲚϮⲤⲨⲢⲒⲀ ⲦⲎⲢⲤ ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲦϨⲈⲘⲔⲎⲞⲨⲦ ϦⲈⲚⲚⲞⲨϢⲰⲚⲒ ⲚⲈⲘ ⲚⲞⲨⲘⲔⲀⲨϨ ⲚⲞⲨⲘⲎϢ ⲚⲢⲎϮ ⲚⲎ ⲈⲦⲈ ⲚⲒⲆⲈⲘⲰⲚ ⲚⲈⲘⲰⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲦⲞⲒ ⲘⲠⲈⲢⲘⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲚⲈⲘ ϮⲘⲎϮ ⲘⲂⲀⲔⲒ ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲚⲒⲘⲎϢ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲰⲒ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲘⲤⲒ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲰⲚ ⲚⲢⲰϤ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀϪⲈ ⲐⲰⲞⲨ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲈⲢϨⲎⲂⲒ ϮⲚⲞⲨ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲦⲞⲨⲚⲀϮϨⲞ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲢⲈⲘⲢⲀⲨϢ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲐⲚⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲘⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦϨⲞⲔⲈⲢ ⲚⲈⲘ ⲚⲎ ⲈⲦⲞⲂⲒ ⲚϮⲘⲈⲐⲘⲎⲒ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲐⲚⲀⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲚⲀⲎⲦ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲚⲀⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲐⲞⲨⲀⲂ ϦⲈⲚⲠⲞⲨϨⲎⲦ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲐⲚⲀⲚⲀⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲢⲈϤⲈⲢϨⲒⲢⲎⲚⲎ ϪⲈ ⲚⲐⲰⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲀⲨϬⲞϪⲒ ⲚⲤⲰⲞⲨ ⲈⲐⲂⲈ ϮⲘⲈⲐⲘⲎⲒ ϪⲈ ⲐⲰⲞⲨ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϢⲰⲠ ⲀⲨϢⲀⲚϬⲞϪⲒ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲚⲤⲈϢⲈϢ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲚⲤⲈϪⲈ ⲠⲈⲦϨⲰⲞⲨ ⲚⲒⲂⲈⲚ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲈⲨϪⲈ ⲘⲈⲐⲚⲞⲨϪ ⲈⲢⲰⲦⲈⲚ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ⲢⲀϢⲒ ⲞⲨⲞϨ ⲐⲈⲖⲎⲖ ϪⲈ ⲠⲈⲦⲈⲚⲂⲈⲬⲈ ⲞⲨⲚⲒϢϮ ⲠⲈ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲠⲀⲒⲢⲎϮ ⲄⲀⲢ ⲀⲨϬⲞϪⲒ ⲚⲤⲀⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲚⲀⲨϦⲀϪⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲠϨⲘⲞⲨ ⲘⲠⲒⲔⲀϨⲒ ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲠⲒϨⲘⲞⲨ ⲖⲰϤ ⲀⲨⲚⲀⲘⲞⲖϨϤ ⲚⲞⲨ ⲘⲠⲀϤϢϪⲈⲘϪⲞⲘ ϪⲈ ⲈϨⲖⲒ ⲈⲂⲎⲖ ⲚⲤⲈϨⲒⲦϤ ⲈⲂⲞⲖ ⲚⲤⲈϨⲰⲘⲒ ⲈϪⲰϤ ⲚϪⲈⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ⲚⲐⲰⲦⲈⲚ ⲠⲈ ⲪⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲞⲨⲂⲀⲔⲒ ⲬⲰⲠ ⲈⲤⲬⲎ ϨⲒϪⲈⲚ ⲞⲨⲦⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ⲞⲨⲆⲈ ⲘⲠⲀⲨϬⲈⲢⲈ ⲞⲨϦⲎⲂⲤ ⲚⲤⲈⲬⲀϤ ϦⲀ ⲞⲨⲘⲈⲚⲦ ⲀⲖⲖⲀ ⲈϢⲀⲨⲬⲀϤ ϨⲒϪⲈⲚ ϮⲖⲨⲬⲚⲒⲀ ⲞⲨⲞϨ ϢⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲠⲒⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ⲠⲀⲒⲢⲎϮ ⲘⲀⲢⲈ ⲠⲈⲦⲈⲚⲞⲨⲰⲒⲚⲒ ⲈⲢⲞⲨⲰⲒⲚⲒ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ϨⲞⲠⲰⲤ ⲚⲤⲈⲚⲀⲨ ⲈⲚⲈⲦⲈⲚϨⲂⲎ ⲞⲨⲒ ⲈⲐⲚⲀⲚⲈⲨ ⲚⲤⲈϮⲰⲞⲨ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ⲘⲠⲈⲢⲘⲈⲨⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲈⲖ ⲠⲒⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲒⲈ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲦⲀⲒⲒ ⲈⲂⲞⲖⲞⲨ ⲀⲚ ⲀⲖⲖⲀ ⲈϪⲞⲔⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϢⲀⲦⲈ ⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲤⲒⲚⲒ ⲞⲨⲒⲰⲦⲀ ⲒⲈ ⲞⲨϢⲰⲖϨ ⲚⲚⲈϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ϢⲀⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ⲪⲎ ⲞⲨⲚ ⲈⲐⲚⲀⲂⲈⲖ ⲞⲨⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲚⲈⲚⲦⲞⲖⲎ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈϤϮⲤⲂⲰ ⲚⲚⲒⲢⲰⲘⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲔⲞⲨϪⲒ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲒⲢⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϮⲤⲂⲰ ⲪⲀⲒ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲚⲒϢϮ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲈϢⲦⲈⲘ ⲦⲈⲦⲈⲚⲘⲈⲐⲘⲎⲒ ⲈⲢϨⲞⲨⲞ ⲈⲐⲀ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲚⲈⲦⲈⲚⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲀⲨϪⲞⲤ ⲚⲚⲒⲀⲢⲬⲈⲞⲤ ϪⲈ ⲚⲚⲈⲔϦⲰⲦⲈⲂ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϦⲰⲦⲈⲂ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲈϮⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϪⲰⲚⲦ ⲈⲠⲈϤⲤⲞⲚ ϨⲒⲔⲎ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲈϮⲔⲢⲒⲤⲒⲤ ⲪⲎ ⲈⲐⲚⲀϪⲞⲤ ⲘⲠⲈϤⲤⲞⲚ ϪⲈ ⲢⲀⲔⲀ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲠⲒⲘⲀⲚϮϨⲀⲠ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϪⲞⲤ ⲘⲠⲈϤⲤⲞⲚ ϪⲈ ⲠⲒⲤⲞϪ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲈϮⲄⲈⲈⲚⲚⲀ ⲚⲦⲈⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ⲈϢⲰⲠ ⲞⲨⲚ ⲈⲔⲚⲀⲒⲚⲒ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲞⲨⲞϨ ⲚⲦⲈⲔⲈⲢⲪⲘⲈⲨⲒ ⲘⲘⲀⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲢⲒⲔⲒ ⲞⲨⲦⲰⲔ ⲚⲈⲘ ⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ⲬⲰ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲘⲘⲀⲨ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲚϢⲞⲢⲠ ϨⲰⲦⲠ ⲈⲠⲈⲔⲤⲞⲚ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲀⲘⲞⲨ ⲀⲚⲒⲞⲨⲒ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲈϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ϢⲰⲠⲒ ⲈⲔⲔⲀϮ ⲈⲠⲈⲔⲀⲚⲦⲒⲆⲒⲔⲞⲤ ⲚⲬⲰⲖⲈⲘ ϨⲰⲤ ⲈϤⲬⲎ ⲚⲈⲘⲀⲔ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲠⲒⲀⲚⲦⲒⲆⲒⲔⲞⲤ ⲦⲎⲒⲔ ⲈⲠⲒⲔⲢⲒⲦⲎⲤ ⲞⲨⲞϨ ⲚⲦⲈⲠⲒⲔⲢⲒⲦⲎⲤ ⲦⲎⲒⲔ ⲈⲠⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲞⲨⲞϨ ⲚⲤⲈϨⲒⲦⲔ ⲈⲠⲒϢⲦⲈⲔⲞ ");
INSERT INTO copbhc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈⲔⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ϢⲀⲦⲈⲔϮ ⲚⲦϦⲀⲎ ⲚⲦⲈⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ⲀⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲀⲨϪⲞⲤ ϪⲈ ⲚⲚⲈⲔⲈⲢⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϪⲞⲨϢⲦ ⲚⲤⲀⲞⲨⲤϨⲒⲘⲒ ⲈⲠϪⲒⲚⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲢⲞⲤ ⲀϤⲔⲎⲚ ⲈϤⲞⲒ ⲚⲚⲰⲒⲔ ⲈⲢⲞⲤ ϦⲈⲚⲠⲈϤϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ⲒⲤϪⲈ ⲠⲈⲔⲂⲀⲖ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ⲪⲞⲢⲔϤ ϨⲒⲦϤ ⲈⲂⲞⲖ ϨⲀⲢⲞⲔ ⲤⲈⲢⲚⲞϤⲢⲒ ⲄⲀⲢ ⲚⲀⲔ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲚⲈⲔⲘⲈⲖⲞⲤ ⲦⲀⲔⲞ ⲞⲨⲞϨ ⲚⲦⲈϢⲦⲈⲘ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ϢⲈ ⲚⲀϤ ⲈϮⲄⲈⲈⲚⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲦⲈⲔϪⲒϪ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ϪⲞϪⲤ ϨⲒⲦⲤ ⲈⲂⲞⲖ ϨⲀⲢⲞⲔ ⲤⲈⲢⲚⲞϤⲢⲒ ⲄⲀⲢ ⲚⲀⲔ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲚⲈⲔⲘⲈⲖⲞⲤ ⲦⲀⲔⲞ ⲞⲨⲞϨ ⲚⲦⲈϢⲦⲈⲘ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ϢⲈ ⲚⲀϤ ⲈϮⲄⲈⲈⲚⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ⲀⲨϪⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨⲒ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲘⲀⲢⲈϤϮ ⲚⲞⲨⲤϦⲒ ⲚⲞⲨⲈⲒ ⲚⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨⲒ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲚⲞⲨⲈϢⲈ ⲚⲤⲀϪⲒ ⲘⲠⲞⲢⲚⲒⲀ ⲀϤⲐⲢⲞ ⲘⲘⲞⲤ ⲈϪⲪⲈ ⲚⲰⲒⲔ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϬⲒ ⲚⲐⲎ ⲈⲦϨⲰⲞⲨⲒ ⲈⲂⲞⲖ ϤⲞⲒ ⲚⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ⲠⲀⲖⲒⲚ ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲀⲨϪⲞⲤ ⲚⲚⲒⲀⲢⲬⲈⲞⲤ ϪⲈ ⲚⲚⲈⲔⲰⲢⲔ ⲚⲚⲞⲨϪ ⲈⲔⲈϮ ⲆⲈ ⲚⲚⲈⲔⲀⲚⲀⲨϢ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲈⲢⲰⲢⲔ ϨⲞⲖⲰⲤ ⲘⲠⲈⲢⲰⲢⲔ ⲚⲦⲪⲈ ϪⲈ ⲠⲐⲢⲞⲚⲞⲤ ⲘⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ⲞⲨⲆⲈ ⲠⲔⲀϨⲒ ϪⲈ ⲪⲘⲀⲚⲤⲈⲘⲚⲒ ⲚⲦⲈⲚⲈϤϬⲀⲖⲀⲨϪ ⲠⲈ ⲞⲨⲆⲈ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϪⲈ ⲐⲂⲀⲔⲒ ⲘⲠⲒⲚⲒϢϮ ⲚⲞⲨⲢⲞ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ⲞⲨⲆⲈ ⲘⲠⲈⲢⲰⲢⲔ ⲚⲦⲈⲔⲀⲪⲈ ϪⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲈⲢ ⲞⲨⲔⲀⲠ ⲘϤⲰⲒ ⲚⲞⲨⲰⲂϢ ⲒⲈ ⲞⲨⲀⲒ ⲚⲬⲀⲘⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ⲘⲀⲢⲈ ⲠⲈⲦⲈⲚⲤⲀϪⲒ ⲆⲈ ⲈⲢ ⲞⲨⲀϨⲀ ⲀϨⲀ ⲘⲘⲞⲚ ⲘⲘⲞⲚ ⲠϨⲞⲨⲞ ⲆⲈ ⲚⲚⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲀⲨϪⲞⲤ ϪⲈ ⲞⲨⲂⲀⲖ ϦⲀ ⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲞⲨⲚⲀϪϨⲒ ϦⲀ ⲞⲨⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲈⲢϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲀⲖⲖⲀ ⲪⲎ ⲈⲐⲚⲀϮ ⲚⲞⲨⲔⲞⲨⲢ ⲚⲀⲔ ϦⲈⲚⲦⲈⲔⲞⲨⲞϪⲒ ⲚⲞⲨⲒⲚⲀⲘ ⲪⲈⲚϨ ϮⲬⲈϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰϢ ⲈϬⲒϨⲀⲠ ⲚⲈⲘⲀⲔ ⲈⲈⲖ ⲦⲈⲔϢⲐⲎⲚ ⲬⲀ ⲠⲈⲔⲈⲢϢⲰⲚ ⲈⲂⲞⲖ ⲘⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϬⲒⲦⲔ ⲚⲬⲂⲀ ⲚⲞⲨⲘⲒⲖⲒⲞⲚ ⲘⲞϢⲒ ⲚⲈⲘⲀϤ ⲚⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ⲪⲎ ⲈⲦⲈⲢⲈⲦⲒⲚ ⲘⲘⲞⲔ ⲘⲞⲒ ⲚⲀϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈϬⲒ ⲚⲦⲞⲦⲔ ⲘⲠⲈⲢⲦⲀⲤⲐⲞϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲀⲨϪⲞⲤ ϪⲈ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲞⲨⲞϨ ⲈⲔⲈⲘⲈⲤⲦⲈ ⲠⲈⲔϪⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ⲀⲚⲞⲔ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚϪⲀϪⲒ ⲞⲨⲞϨ ⲦⲰⲂϨ ⲈϪⲈⲚ ⲚⲎ ⲈⲦϬⲞϪⲒ ⲚⲤⲀⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲢϢⲎⲢⲒ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ϪⲈ ⲈϤⲐⲢⲞ ⲘⲠⲈϤⲢⲎ ϢⲀⲒ ⲈϪⲈⲚ ⲚⲒⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲚⲈⲘ ⲚⲒⲤⲀⲘⲠⲈⲐⲚⲀⲚⲈⲨ ⲞⲨⲞϨ ⲈϤϨⲰⲞⲨ ⲈϪⲈⲚ ⲚⲒⲐⲘⲎⲒ ⲚⲈⲘ ⲚⲒⲞϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ⲈϢⲰⲠ ⲄⲀⲢ ⲚⲦⲈⲦⲈⲚⲘⲈⲚⲢⲈ ⲚⲎ ⲈⲐⲘⲈⲒ ⲘⲘⲰⲦⲈⲚ ⲀϢ ⲠⲈ ⲠⲈⲦⲈⲚⲂⲈⲬⲈ ⲚⲒⲔⲈⲦⲈⲖⲰⲚⲎⲤ ϨⲰⲞⲨ ϢⲀⲨⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲦⲈⲚϢⲈⲠ ⲦⲞⲦⲞⲨ ⲚⲚⲈⲦⲈⲚⲤⲚⲎ ⲞⲨ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲞⲨ ⲘⲘⲈⲦϨⲞⲨⲞ ⲈⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲞϤ ⲚⲒⲔⲈⲈⲐⲚⲒⲔⲞⲤ ϨⲰⲞⲨ ϢⲀⲨⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ϢⲰⲠⲒ ⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚϪⲎⲔ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲈⲦϪⲎⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ⲘⲀϨⲐⲎⲦⲈⲚ ⲆⲈ ⲈⲠⲈⲦⲈⲚⲦⲀⲒⲞ ⲘⲠⲈⲢⲀⲒϤ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲐⲢⲞⲨⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ⲘⲘⲞⲚⲦⲈⲦⲈⲚ ⲂⲈⲬⲈ ⲘⲘⲀⲨ ⲚⲦⲞⲦϤ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ⲈϢⲰⲠ ⲞⲨⲚ ⲈⲔⲚⲀⲒⲢⲒ ⲚⲞⲨⲘⲈⲐⲚⲀⲎⲦ ⲘⲠⲈⲢⲈϢ ⲦⲀⲠ ϦⲀϪⲰⲔ ⲘⲪⲢⲎϮ ⲈⲦⲞⲨⲢⲀ ⲘⲘⲞⲤ ⲚϪⲈⲚⲒϢⲞⲂⲒ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ⲚⲒⲀⲄⲞⲢⲀ ϨⲒⲚⲀ ⲚⲤⲈϮⲰⲞⲨ ⲚⲰⲞⲨ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲨⲔⲎⲚ ⲈⲨϬⲒ ⲘⲠⲞⲨⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ⲚⲐⲞⲔ ⲆⲈ ⲈⲔⲚⲀⲒⲢⲒ ⲚⲞⲨⲘⲈⲐⲚⲀⲎⲦ ⲘⲠⲈⲚⲐⲢⲈⲬ ⲀⲦⲈⲔϪⲀϬⲎ ⲈⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈ ⲦⲈⲔⲞⲨⲒⲚⲀⲘ ⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲔⲘⲈⲐⲚⲀⲎⲦ ϢⲰⲠⲒ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲞⲨⲞϨ ⲠⲈⲔⲒⲰⲦ ⲈⲐⲚⲀⲨ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲈϤⲈϮ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲈⲢⲈⲦⲈⲚⲚⲀⲦⲰⲂϨ ⲚⲚⲈⲦⲈⲚⲈⲢ ⲘⲪⲢⲎϮ ⲚⲚⲒϢⲞⲂⲒ ϪⲈ ϢⲀⲨⲘⲈⲒ ⲚⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ⲚⲒⲖⲀⲔϨ ⲚⲦⲈⲚⲒϢⲐⲈϨ ⲚⲤⲈⲦⲰⲂϨ ϨⲞⲠⲰⲤ ⲚⲤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲨⲔⲎⲚ ⲈⲨϬⲒ ⲘⲠⲞⲨⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ⲚⲐⲞⲔ ⲆⲈ ⲈⲔⲚⲀⲦⲰⲂϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϦⲞⲨⲚ ⲈⲠⲈⲔⲦⲀⲘⲒⲞⲚ ⲘⲀϢⲐⲀⲘ ⲘⲠⲈⲔⲢⲞ ⲈⲢⲞⲔ ⲞⲨⲞϨ ⲦⲰⲂϨ ⲘⲠⲈⲔⲒⲰⲦ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲞⲨⲞϨ ⲠⲈⲔⲒⲰⲦ ⲈⲐⲚⲀⲨ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲈϤⲈϮ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ⲈⲢⲈⲦⲈⲚⲚⲀⲦⲰⲂϨ ⲆⲈ ⲘⲠⲈⲢⲈⲢ ⲞⲨⲘⲎϢ ⲚⲤⲀϪⲒ ⲘⲪⲢⲎϮ ⲚⲚⲒⲈⲐⲚⲒⲔⲞⲤ ⲤⲈⲘⲈⲨⲒ ⲄⲀⲢ ϪⲈ ϦⲈⲚⲠⲞⲨⲘⲎϢ ⲚⲤⲀϪⲒ ⲤⲈⲚⲀⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ⲘⲠⲈⲢⲒⲚⲒ ⲞⲨⲚ ⲘⲘⲰⲞⲨ ϤⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲚϪⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲚⲚⲎ ⲈⲦⲈⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲘⲘⲰⲞⲨ ⲘⲠⲀⲦⲈⲦⲈⲚⲦⲞⲂϨϤ ⲈⲐⲂⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ⲦⲰⲂϨ ⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ⲠⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲘⲀⲢⲈϤⲦⲞⲨⲂⲞ ⲚϪⲈⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ⲘⲀⲢⲈⲤⲒ ⲚϪⲈⲦⲈⲔⲘⲈⲦⲞⲨⲢⲞ ⲠⲈⲦⲈϨⲚⲀⲔ ⲘⲀⲢⲈϤϢⲰⲠⲒ ⲘⲪⲢⲎϮ ϦⲈⲚⲦⲪⲈ ⲚⲈⲘ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ⲠⲈⲚⲰⲒⲔ ⲚⲦⲈⲢⲀⲤϮ ⲘⲎⲒϤ ⲚⲀⲚ ⲘⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ⲞⲨⲞϨ ⲬⲀ ⲚⲈⲦⲈⲢⲞⲚ ⲚⲀⲚ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ϨⲰⲚ ⲚⲦⲈⲚⲬⲰ ⲈⲂⲞⲖ ⲚⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀⲚ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲚⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ ⲀⲖⲖⲀ ⲚⲀϨⲘⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ⲈϢⲰⲠ ⲄⲀⲢ ⲚⲦⲈⲦⲈⲚⲬⲰ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲚⲞⲨⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲈϤⲈⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲚϪⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲚⲚⲈⲦⲈⲚⲠⲀⲢⲀⲠⲦⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲬⲰ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲞⲨⲆⲈ ⲠⲈⲦⲈⲚⲒⲰⲦ ϤⲚⲀⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲀⲚ ⲚⲚⲈⲦⲈⲚⲠⲀⲢⲀⲠⲦⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲦⲈⲚⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲚⲚⲈⲦⲈⲚⲈⲢ ⲘⲪⲢⲎϮ ⲚⲚⲒϢⲞⲂⲒ ⲈϢⲀⲨⲰⲔⲈⲘ ⲘⲠⲞⲨϨⲞ ϢⲀⲨⲦⲀⲔⲈ ⲚⲞⲨϨⲞ ⲄⲀⲢ ϨⲒⲚⲀ ⲚⲤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲨⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲨⲔⲎⲚ ⲈⲨϬⲒ ⲘⲠⲞⲨⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ⲚⲐⲞⲔ ⲆⲈ ⲈⲔⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲐⲰϨⲤ ⲚⲦⲈⲔⲀⲪⲈ ⲞⲨⲞϨ ⲒⲀ ⲠⲈⲔϨⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ϨⲒⲚⲀ ⲚⲦⲈⲔϢⲦⲈⲘⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲔⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲀⲖⲖⲀ ⲠⲈⲔⲒⲰⲦ ⲈⲦϦⲈⲚ ⲠⲈⲦϨⲎⲠ ⲞⲨⲞϨ ⲠⲈⲔⲒⲰⲦ ⲈⲐⲚⲀⲨ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲈϤⲈϮϢⲈⲂⲒⲰ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ⲘⲠⲈⲢϨⲒⲞⲨⲒ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲚϨⲀⲚⲀϨⲰⲢ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲠⲒⲘⲀ ⲈϢⲀⲢⲈ ⲦϨⲞⲖⲒ ⲚⲈⲘ ⲦϪⲞⲖⲒ ⲦⲀⲔⲰⲞⲨ ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲈϢⲀⲢⲈ ⲚⲒⲤⲞⲚⲒ ϨⲒϢⲀⲦⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨⲔⲞⲖⲠⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ϨⲒⲞⲨⲒ ⲆⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲚϨⲀⲚⲀϨⲰⲢ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲪⲈ ⲠⲒⲘⲀ ⲈⲦⲈⲘⲠⲀⲢⲈ ϨⲞⲖⲒ ⲞⲨⲆⲈ ϪⲞⲖⲒ ⲦⲀⲔⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲀⲢⲈ ⲚⲒⲤⲞⲚⲒ ϨⲒϢⲀⲦⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨⲔⲞⲖⲠⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ⲠⲒⲘⲀ ⲄⲀⲢ ⲈⲦⲈ ⲠⲈⲔⲀϨⲞ ⲘⲘⲞϤ ⲈϤⲈϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚϪⲈⲠⲈⲔⲔⲈϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ⲠϦⲎⲂⲤ ⲘⲠⲒⲤⲰⲘⲀ ⲠⲈ ⲠⲒⲂⲀⲖ ⲈϢⲰⲠ ⲞⲨⲚ ⲠⲈⲔⲂⲀⲖ ⲞⲨϨⲀⲠⲖⲞⲨⲤ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ⲈϢⲰⲠ ⲆⲈ ⲠⲈⲔⲂⲀⲖ ⲞⲨⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲬⲀⲔⲒ ⲒⲤϪⲈ ⲞⲨⲚ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲈⲦⲈⲚϦⲎⲦⲔ ⲞⲨⲬⲀⲔⲒ ⲠⲈ ⲒⲈ ⲀⲨⲎⲢ ⲠⲒⲬⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲈⲢⲂⲰⲔ ⲚϬⲞⲒⲤ ⲂⲒⲈ ⲄⲀⲢ ⲚⲦⲈϤⲘⲈⲤⲦⲈ ⲞⲨⲀⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲘⲈⲚⲢⲈ ⲞⲨⲀⲒ ⲒⲈ ⲚⲦⲈϤϢⲈⲠ ⲞⲨⲀⲒ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲢⲔⲀⲦⲀⲪⲢⲞⲚⲒⲚ ⲘⲠⲒⲬⲈⲦ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲈⲢⲂⲰⲔ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲘⲀⲘⲰⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ⲈⲐⲂⲈ ⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲦⲈⲦⲈⲚⲮⲨⲬⲎ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲞⲨⲞⲘϤ ⲒⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲤⲞϤ ⲞⲨⲆⲈ ϦⲀ ⲠⲈⲦⲈⲚⲤⲰⲘⲀ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲦⲎ ⲒϤ ϨⲒ ⲐⲎⲚⲞⲨ ⲘⲎ ϮⲮⲨⲬⲎ ⲞⲨⲞⲦ ⲀⲚ ⲈϮϦⲢⲈ ⲞⲨⲞϨ ⲠⲒⲤⲰⲘⲀ ⲈϮϨⲈⲂⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ⲘⲀⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ϪⲈ ⲤⲈⲤⲒϮ ⲀⲚ ⲞⲨⲆⲈ ⲤⲈⲰⲤϦ ⲀⲚ ⲞⲨⲆⲈ ⲤⲈϨⲒⲞⲨⲒ ⲀⲚ ⲈⲀⲠⲞⲐⲎⲔⲎ ⲞⲨⲞϨ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ϤϢⲀⲚϢ ⲘⲘⲰⲞⲨ ⲘⲎ ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲘⲀⲖⲖⲞⲚ ⲈⲐⲞⲨⲞⲦ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ⲚⲒⲘ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲦϤⲒⲢⲰⲞⲨϢ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲦⲀⲖⲈ ⲞⲨⲀⲘⲀϨⲒ ⲚϢⲒⲎ ⲈϪⲈⲚ ⲦⲈϤⲘⲀⲒⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ⲞⲨⲞϨ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϤⲒⲢⲰⲞⲨϢ ⲈⲐⲂⲈ ϨⲈⲂⲤⲰ ⲘⲀⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲚⲒϨⲢⲎⲢⲒ ⲚⲦⲈⲦⲔⲞⲒ ϪⲈ ⲠⲰⲤ ⲤⲈⲀⲒⲀⲒ ⲚⲤⲈϦⲞⲤⲒ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲈⲢⲒⲞⲠⲎ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲆⲈ ⲤⲞⲖⲞⲘⲰⲚ ϦⲈⲚⲠⲈϤⲰⲞⲨ ⲦⲎⲢϤ ⲘⲠⲈϤϮ ϨⲒⲰⲦϤ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ⲒⲤϪⲈ ⲆⲈ ⲠⲒⲤⲒⲘ ⲚⲦⲈⲦⲔⲞⲒ ϤϢⲞⲠ ⲘⲪⲞⲞⲨ ⲞⲨⲞϨ ⲢⲀⲤϮ ϢⲀⲨϨⲒⲦϤ ⲈϮⲐⲢⲒⲢ ⲪⲚⲞⲨϮ ⲘⲠⲀⲒⲢⲎϮ ϤϮϨⲈⲂⲤⲰ ϨⲒⲰⲦϤ ⲒⲈ ⲀⲨⲎⲢ ⲘⲀⲖⲖⲞⲚ ⲚⲐⲰⲦⲈⲚ ⲚⲀ ⲠⲒⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ⲞⲨⲚ ⲈⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲞⲨⲞⲘϤ ⲒⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲤⲞϤ ⲒⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲦⲎⲒϤ ϨⲒⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲒⲈⲐⲚⲒⲔⲞⲤ ⲤⲈⲔⲰϮ ⲚⲤⲰⲞⲨ ϤⲤⲰⲞⲨⲚ ⲆⲈ ⲚϪⲈⲠⲈⲦⲈⲚⲒⲰⲦ ϪⲈ ⲦⲈⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ⲔⲰϮ ⲆⲈ ⲚϢⲞⲢⲠ ⲚⲤⲀⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ ⲚⲈⲘ ⲦⲈϤⲘⲈⲐⲘⲎⲒ ⲞⲨⲞϨ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈϤⲈⲞⲨⲀϨⲞⲨ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲢⲀⲤϮ ⲢⲀⲤϮ ⲄⲀⲢ ⲈϤⲈϤⲒⲢⲰⲞⲨϢ ϦⲀⲢⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲔⲎⲚ ⲈⲠⲒⲈϨⲞⲞⲨ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈϤⲔⲀⲔⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ⲘⲠⲈⲢϮϨⲀⲠ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘϮϨⲀⲠ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ⲠⲒϨⲀⲠ ⲄⲀⲢ ⲈⲦⲈⲦⲈⲚⲚⲀⲦⲎⲒϤ ⲀⲨⲚⲀϮϨⲀⲠ ⲈⲢⲰⲦⲈⲚ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ϦⲈⲚⲠⲒϢⲒ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲘⲘⲞϤ ⲀⲨⲚⲀϢⲒ ⲚⲰⲦⲈⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ⲈⲐⲂⲈⲞⲨ ⲬⲚⲀⲨ ⲈⲠⲒϪⲎⲒ ϦⲈⲚⲪⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ ⲠⲒⲤⲞⲒ ⲆⲈ ⲈⲦϦⲈⲚ ⲠⲈⲔⲂⲀⲖ ⲔϮⲚⲒⲀⲦⲔ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ⲒⲈ ⲠⲰⲤ ⲬⲚⲀϪⲞⲤ ⲘⲠⲈⲔⲤⲞⲚ ϪⲈ ⲬⲀⲦ ⲚⲦⲀϨⲒ ⲠⲒϪⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲂⲀⲖ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲒⲤⲞⲒ ϤⲬⲎ ϦⲈⲚⲠⲈⲔⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ⲠⲒϢⲞⲂⲒ ϨⲒ ⲠⲒⲤⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲂⲀⲖ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲔⲈⲚⲀⲨ ⲘⲂⲞⲖ ⲈϨⲒ ⲠⲒϪⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ⲘⲠⲈⲢϮ ⲘⲠⲈⲐⲞⲨⲀⲂ ⲚⲚⲒⲞⲨϨⲰⲢ ⲞⲨⲆⲈ ⲘⲠⲈⲢϨⲒⲞⲨⲒ ⲚⲚⲈⲦⲈⲚⲀⲚⲀⲘⲎⲒ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲈϢⲀⲨ ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈϨⲰⲘⲒ ⲈϪⲰⲞⲨ ⲚⲚⲞⲨϬⲀⲖⲀⲨϪ ⲞⲨⲞϨ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲚⲤⲈⲪⲈϦ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ⲀⲢⲒⲈⲦⲒⲚ ⲞⲨⲞϨ ⲈⲨⲈϮ ⲚⲰⲦⲈⲚ ⲔⲰϮ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲔⲰⲖϨ ⲞⲨⲞϨ ⲈⲨⲈⲀⲞⲨⲰⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲢⲈⲦⲒⲚ ϢⲀϤϬⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲔⲰϮ ϢⲀϤϪⲒⲘⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲔⲰⲖϨ ϢⲀⲨⲞⲨⲰⲚ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ⲒⲈ ⲚⲒⲘ ⲚⲢⲰⲘⲒ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲠⲈϤϢⲎⲢⲒ ⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲞⲨⲰⲒⲔ ⲘⲎ ϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ⲒⲈ ⲚⲦⲈϤⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲞⲨⲦⲈⲂⲦ ⲘⲎ ϤⲚⲀϮ ⲚⲀϤ ⲚⲞⲨϨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ⲒⲤϪⲈ ⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲈϮ ⲚⲚⲒⲦⲀⲒⲞ ⲈⲐⲚⲀⲚⲈⲨ ⲚⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲒⲈ ⲀⲨⲎⲢ ⲘⲀⲖⲖⲞⲚ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲈϤⲈϮ ⲚⲚⲒⲀⲄⲀⲐⲞⲚ ⲚⲚⲎ ⲈⲐⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ϨⲰⲂ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲦⲈⲚⲞⲨⲰϢ ϨⲒⲚⲀ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲀⲒⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲀⲢⲒⲞⲨⲒ ⲚⲰⲞⲨ ϨⲰⲦⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ⲀⲘⲰⲒⲚⲒ ⲈϦⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲠⲨⲖⲎ ⲈⲦϪⲎⲞⲨ ϪⲈ ⲤⲞⲨⲞϢⲤ ⲚϪⲈϮⲠⲨⲖⲎ ⲞⲨⲞϨ ϤⲞⲨⲈⲤⲐⲰⲚ ⲚϪⲈⲠⲒⲘⲰⲒⲦ ⲈⲦϬⲒ ⲈⲠⲦⲀⲔⲞ ⲞⲨⲞϨ ⲤⲈⲞϢ ⲚϪⲈⲚⲎ ⲈⲐⲚⲀϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ϪⲈ ⲤϪⲎⲞⲨ ⲚϪⲈϮⲠⲨⲖⲎ ⲞⲨⲞϨ ϤϨⲈϪϨⲰϪ ⲚϪⲈⲠⲒⲘⲰⲒⲦ ⲈⲦϬⲒ ⲈⲠⲰⲚϦ ⲞⲨⲞϨ ϨⲀⲚⲔⲞⲨϪⲒ ⲠⲈⲐⲚⲀϪⲈⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ⲀⲢⲈϨ ⲆⲈ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲚⲚⲞⲨϪ ⲚⲎ ⲈⲐⲚⲎⲞⲨ ϨⲀⲢⲰⲦⲈⲚ ϦⲈⲚϨⲀⲚϨⲈⲂⲤⲰ ⲚⲈⲤⲰⲞⲨ ⲤⲀϦⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲞⲨ ϨⲀⲚⲞⲨⲰⲚϢ ⲚⲢⲈϤϨⲰⲖⲈⲘ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨⲞⲨⲦⲀϨ ⲈⲢⲈⲦⲈⲚⲈⲤⲞⲨⲰⲚⲞⲨ ⲘⲎⲦⲒ ϢⲀⲨⲤⲈⲔ ⲀⲖⲞⲖⲒ ⲈⲂⲞⲖ ϨⲒ ϨⲀⲚϢⲞⲚϮ ⲒⲈ ϢⲀⲨⲤⲈⲔ ⲔⲈⲚⲦⲈ ⲈⲂⲞⲖ ϨⲒ ⲚⲒⲤⲈⲢⲞϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ⲠⲀⲒⲢⲎϮ ϢϢⲎⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲚⲈϤ ϢⲀϤⲈⲚ ⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ ⲈⲂⲞⲖ ⲠⲒϢϢⲎⲚ ⲆⲈ ⲈⲦϨⲰⲞⲨ ϢⲀϤⲈⲚ ⲞⲨⲦⲀϨ ⲈϤϨⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲞⲨϢϢⲎⲚ ⲈⲚⲀⲚⲈϤ ⲈⲈⲢⲞⲨⲦⲀϨ ⲈϤϨⲰⲞⲨ ⲞⲨⲆⲈ ⲞⲨϢϢⲎⲚ ⲈϤϨⲰⲞⲨ ⲈⲈⲢⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ϢϢⲎⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈϤⲚⲀⲒⲢⲒ ⲀⲚ ⲚⲞⲨⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ ⲤⲈⲚⲀⲔⲞⲢϪϤ ⲚⲤⲈϨⲒⲦϤ ⲈⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ϨⲀⲢⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨⲞⲨⲦⲀϨ ⲈⲢⲈⲦⲈⲚⲈⲤⲞⲨⲰⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲀⲚ ⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲎⲒ ϪⲈ ⲠϬⲞⲒⲤ ⲠϬⲞⲒⲤ ⲈⲐⲚⲀⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲀⲖⲖⲀ ⲠⲈⲦⲒⲢⲒ ⲘⲠⲈⲦⲈϨⲚⲈ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲈⲨⲚⲀϪⲞⲤ ⲚⲎⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲠϬⲞⲒⲤ ⲘⲎ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲀⲚ ⲀⲚⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲞⲨⲞϨ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲀⲚϨⲒ ⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲀⲚⲒⲢⲒ ⲚⲞⲨⲘⲎϢ ⲚϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲒⲈⲞⲨⲰⲚϨ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ϪⲈ ⲘⲠⲒⲤⲞⲨⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲚⲈϨ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲚⲦⲈϮⲀⲚⲞⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲚⲀⲒ ⲞⲨⲞϨ ⲈϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲈⲒⲈⲦⲈⲚⲐⲰⲚϤ ⲈⲞⲨⲢⲰⲘⲒ ⲚⲤⲀⲂⲈ ⲪⲎ ⲈⲦⲀϤⲔⲰⲦ ⲘⲠⲈϤⲎⲒ ϨⲒϪⲈⲚ ϮⲠⲈⲦⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲒⲘⲞⲨⲚϨⲰⲞⲨ ⲀⲨⲒ ⲚϪⲈⲚⲒⲒⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲔⲰⲖϨ ⲘⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲘⲠⲈϤϨⲈⲒ ⲚⲀⲢⲈ ⲦⲈϤⲤⲈⲚϮ ⲄⲀⲢ ⲦⲀϪⲢⲎⲞⲨⲦ ⲠⲈ ϨⲒϪⲈⲚ ϮⲠⲈⲦⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲚⲀⲒ ⲞⲨⲞϨ ⲈϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲀⲚ ⲈⲒⲈⲦⲈⲚⲐⲰⲚϤ ⲈⲞⲨⲢⲰⲘⲒ ⲚⲤⲞϪ ⲪⲀⲒ ⲈⲦⲀϤⲔⲰⲦ ⲘⲠⲈϤⲎⲒ ϨⲒϪⲈⲚ ⲠⲒϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲒⲘⲞⲨⲚϨⲰⲞⲨ ⲀⲨⲒ ⲚϪⲈⲚⲒⲒⲀⲢⲰⲞⲨ ⲀⲨⲚⲒϤⲒ ⲚϪⲈⲚⲒⲐⲎⲞⲨ ⲀⲨⲔⲰⲖϨ ⲘⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀϤϨⲈⲒ ⲞⲨⲞϨ ⲠⲈϤϨⲈⲒ ⲚⲈⲞⲨⲚⲒϢϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲈⲔ ⲚⲀⲒⲤⲀϪⲒ ⲈⲂⲞⲖ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲠⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲈϪⲈⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ⲚⲀϤϮⲤⲂⲰ ⲄⲀⲢ ⲚⲰⲞⲨ ⲠⲈ ϨⲰⲤ ⲈⲞⲨⲞⲚⲦⲈϤ ⲈⲢϢⲒϢⲒ ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲀⲚ ⲚⲚⲞⲨⲤⲀϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲔⲀⲔⲤⲈϨⲦ ⲀϤⲒ ϨⲀⲢⲞϤ ⲀϤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲔϢⲀⲚⲞⲨⲰϢ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲞⲨⲂⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤϬⲒ ⲚⲈⲘⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ⲘⲀⲦⲞⲨⲂⲞ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲦⲞⲨⲂⲞ ⲚϪⲈⲠⲈϤⲤⲈϨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲢϪⲞⲤ ⲚϨⲖⲒ ⲀⲖⲖⲀ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲀⲦⲀⲘⲈ ⲠⲒⲞⲨⲎⲂ ⲈⲢⲞⲔ ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒ ⲘⲠⲈⲔⲆⲰⲢⲞⲚ ⲈϦⲞⲨⲚ ⲈⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲞϤ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ⲈⲦⲀϤⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈϤϮϨⲞ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲠⲀⲀⲖⲞⲨ ⲢⲀϦⲦ ϦⲈⲚⲠⲀⲎⲒ ⲈϤϢⲎⲖ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲈⲐⲚⲀⲒ ⲚⲦⲀⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ϮⲘⲠϢⲀ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ϦⲀ ⲐⲞⲨⲀϨⲤⲞⲒ ⲘⲠⲀⲎⲒ ⲀⲖⲖⲀ ⲘⲞⲚⲞⲚ ⲀϪⲞⲤ ϦⲈⲚⲠⲤⲀϪⲒ ⲞⲨⲞϨ ⲈϤⲈⲞⲨϪⲀⲒ ⲚϪⲈⲠⲀⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ⲔⲈ ⲄⲀⲢ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ϨⲰ ⲈϤⲬⲎ ϦⲀ ⲞⲨⲈⲢϢⲒϢⲒ ⲈⲞⲨⲞⲚ ϨⲀⲚⲘⲀⲦⲞⲒ ϦⲀⲢⲀⲦ ⲀⲒϢⲀⲚϪⲞⲤ ⲘⲪⲀⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ϢⲀϤϢⲈ ⲚⲀϤ ⲔⲈⲞⲨⲀⲒ ϪⲈ ⲀⲘⲞⲨ ϢⲀϤⲒ ⲞⲨⲞϨ ⲠⲀⲂⲰⲔ ϪⲈ ⲀⲢⲒ ⲪⲀⲒ ϢⲀϤⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲢϢⲪⲎⲢⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲎ ⲈⲚⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲒϪⲈⲘ ⲞⲨⲚⲀϨϮ ⲚⲦⲀⲒⲘⲀⲒⲎ ⲚⲦⲈⲚ ϨⲖⲒ ϦⲈⲚⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲀⲚⲘⲎϢ ⲈⲨⲈⲒ ⲈⲂⲞⲖ ⲤⲀⲠⲈⲒⲈⲂⲦ ⲚⲈⲘ ⲠⲈⲘⲈⲚⲦ ⲞⲨⲞϨ ⲈⲨⲈⲢⲞⲐⲂⲞⲨ ⲚⲈⲘ ⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲒⲀⲔⲰⲂ ⲚϨⲢⲎⲒ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ⲚⲒϢⲎⲢⲒ ⲆⲈ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲈⲨⲈϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲈⲠⲒⲬⲀⲔⲒ ⲈⲦⲤⲀⲂⲞⲖ ⲠⲒⲘⲀ ⲈⲦⲈ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲒⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲪⲢⲎϮ ⲈⲦⲀⲔⲚⲀϨϮ ⲈⲤⲈϢⲰⲠⲒ ⲚⲀⲔ ⲞⲨⲞϨ ⲀϤⲞⲨϪⲀⲒ ⲚϪⲈⲠⲒⲀⲖⲞⲨ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ⲈⲦⲀϤⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲈⲦⲢⲞⲤ ⲀϤⲚⲀⲨ ⲈⲦⲈϤϢⲰⲘⲒ ⲈⲤⲢⲀϦⲦ ⲞⲨⲞϨ ⲈⲤϦⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ⲀϤϬⲒ ⲚⲈⲘ ⲦⲈⲤϪⲒϪ ⲞⲨⲞϨ ⲀϤⲬⲀⲤ ⲚϪⲈⲠⲒϦⲘⲞⲘ ⲞⲨⲞϨ ⲀⲤⲦⲰⲚⲤ ⲞⲨⲞϨ ⲀⲤϢⲈⲘϢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚϨⲀⲚⲘⲎϢ ⲈⲞⲨⲞⲚ ϨⲀⲚⲒϦ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀϤϨⲒⲞⲨⲒ ⲚⲚⲒⲠⲚⲈⲨⲘⲀⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲀϪⲒ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲦϨⲈⲘⲔⲎⲞⲨⲦ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞϤ ⲀϤϬⲒ ⲚⲚⲈⲚϢⲰⲚⲒ ⲞⲨⲞϨ ⲀϤϤⲀⲒ ⲚⲚⲈⲚⲒⲀⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲒⲘⲎϢ ⲈⲦⲔⲰϮ ⲈⲢⲞϤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨϢⲈ ⲚⲰⲞⲨ ⲈⲘⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ⲞⲨⲞϨ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲤⲀϦ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲚⲦⲀⲘⲞϢⲒ ⲚⲤⲰⲔ ⲈⲪⲘⲀ ⲈⲦⲀⲔϢⲈ ⲚⲀⲔ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ⲚⲒⲂⲀϢⲞⲢ ⲞⲨⲞⲚⲦⲞⲨ ⲂⲎⲂ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲘⲀⲚⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲆⲈ ⲚⲐⲞϤ ⲘⲪⲢⲰⲘⲒ ⲘⲘⲞⲚⲦⲈϤ ⲘⲀⲚⲢⲈⲔϪⲰϤ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲘⲀⲈⲢϢⲒϢⲒ ⲚⲎⲒ ⲚϢⲞⲢⲠ ⲚⲦⲀϢⲈ ⲚⲎⲒ ⲚⲦⲀⲐⲰⲘⲤ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲬⲀ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲘⲀⲢⲞⲨⲐⲰⲘⲤ ⲚⲚⲞⲨⲢⲈϤⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲖⲎⲒ ⲈⲠϪⲞⲒ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲚⲒϢϮ ⲘⲘⲞⲚⲘⲈⲚ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲪⲒⲞⲘ ϨⲰⲤⲦⲈ ⲚⲦⲈⲚⲒϨⲰⲒⲘⲒ ⲚⲦⲞⲨϨⲰⲂⲤ ⲘⲠⲒϪⲞⲒ ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲚⲔⲞⲦ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ⲞⲨⲞϨ ⲀⲨⲚⲈϨⲤⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲀϨⲘⲈⲚ ⲦⲈⲚⲚⲀⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϢⲞⲖϨ ⲚϨⲎⲦ ⲚⲀ ⲠⲒⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ ⲦⲞⲦⲈ ⲈⲦⲀϤⲦⲰⲚϤ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲚⲒⲐⲎⲞⲨ ⲚⲈⲘ ⲪⲒⲞⲘ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϪⲀⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ⲚⲒⲢⲰⲘⲒ ⲆⲈ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲀϢ ⲚⲢⲎϮ ⲠⲈ ⲪⲀⲒ ⲚⲒⲐⲎⲞⲨ ⲚⲈⲘ ⲪⲒⲞⲘ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲘⲎⲢ ⲈⲦⲬⲰⲢⲀ ⲚⲦⲈⲄⲈⲢⲄⲈⲤⲎⲚⲞⲤ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲚϪⲈⲤⲚⲀⲨ ⲈⲢⲈ ⲚⲒⲒϦ ⲚⲈⲘⲰⲞⲨ ⲈⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲘϨⲀⲨ ⲈⲨϨⲰⲞⲨ ⲈⲘⲀϢⲰ ϨⲰⲤⲦⲈ ⲚⲦⲈϢⲦⲈⲘ ϨⲖⲒ ϢϪⲈⲘϪⲞⲘ ⲚⲤⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϦⲞⲔ ⲚⲈⲘⲀⲚ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲀⲔⲒ ⲈⲘⲚⲀⲒ ⲈⲦⲀⲔⲞⲚ ⲘⲠⲀⲦⲈ ⲠⲈⲚⲤⲎⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲞϨⲒ ⲆⲈ ⲚⲢⲒⲢ ⲈⲨⲞϢ ⲈⲨⲞⲨⲎⲞⲨ ⲘⲘⲰⲞⲨ ⲈⲨⲘⲞⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ⲚⲒⲒϦ ⲆⲈ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲬⲚⲀϨⲒⲦⲈⲚ ⲈⲂⲞⲖ ⲞⲨⲞⲢⲠⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲠⲒⲞϨⲒ ⲚⲢⲒⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲈϢⲀⲨ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲒⲞϨⲒ ⲦⲎⲢϤ ⲚⲢⲒⲢ ⲀⲨϢⲈ ⲚⲰⲞⲨ ϦⲈⲚⲞⲨⲞⲨⲞⲒ ϦⲀⲦⲈⲚ ⲠⲒϪⲀϪⲢⲒⲘ ⲈϦⲢⲎⲒ ⲈⲪⲒⲞⲘ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨ ϦⲈⲚⲚⲒⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ⲚⲎ ⲆⲈ ⲈⲐⲘⲞⲚⲒ ⲘⲘⲰⲞⲨ ⲀⲨⲪⲰⲦ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϮⲂⲀⲔⲒ ⲀⲨⲦⲀⲘⲰⲞⲨ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲈⲐⲂⲈ ⲚⲎ ⲈⲦⲈ ⲚⲒⲒϦ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ⲞⲨⲞϨ ⲒⲤ ϮⲂⲀⲔⲒ ⲦⲎⲢⲤ ⲀⲤⲒ ⲈⲂⲞⲖ ⲈϨⲢⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨϬⲒⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲖⲎⲒ ⲈⲠϪⲞⲒ ⲀϤⲒ ⲈⲘⲎⲢ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲦⲈϤⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲈⲦⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲀⲒ ⲈϤϢⲎ ⲖⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤϢⲦⲎⲞⲨⲦ ϨⲒϪⲈⲚ ⲞⲨϬⲖⲞϪ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲠⲞⲨⲚⲀϨϮ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲠⲀϢⲎⲢⲒ ⲚⲈⲔⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ⲞⲨⲞϨ ⲒⲤ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲀϦ ⲠⲈϪⲰⲞⲨ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲪⲀⲒ ϪⲈⲞⲨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲞⲨⲘⲞⲔⲘⲈⲔ ⲠⲈϪⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ⲈϨⲀⲚⲠⲈⲦϨⲰⲞⲨ ϦⲈⲚⲚⲈⲦⲈⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ⲞⲨ ⲄⲀⲢ ⲈⲐⲘⲞⲦⲈⲚ ⲈϪⲞⲤ ϪⲈ ⲚⲈⲔⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ϢⲀⲚ ⲈϪⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲞⲨⲞϨ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ϨⲒⲚⲀ ⲆⲈ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨⲞⲚ ⲚⲦⲈⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ⲦⲰⲚⲔ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲈⲔⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲀⲨⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲀϤϮⲈⲢϢⲒϢⲒ ⲘⲠⲀⲒⲢⲎϮ ⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ⲞⲨⲞϨ ⲀϤⲤⲒⲚⲒⲰⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲚⲀⲨ ⲈⲞⲨⲢⲰⲘⲒ ⲈϤϨⲈⲘⲤⲒ ϨⲒ ⲞⲨⲦⲈⲖⲰⲚⲒⲞⲚ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲘⲀⲦⲐⲈⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ⲈϤⲢⲞⲦⲈⲂ ⲆⲈ ϦⲈⲚⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲒⲤ ϨⲀⲚⲦⲈⲖⲰⲚⲎⲤ ⲀⲨⲒ ⲀⲨⲢⲞⲐⲂⲞⲨ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲠⲈⲦⲈⲚⲢⲈϤϮⲤⲂⲰ ϤⲞⲨⲰⲘ ⲚⲈⲘ ⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲎ ⲈⲦϪⲞⲢ ⲤⲈⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲘⲠⲒⲤⲎⲒⲚⲒ ⲀⲖⲖⲀ ⲚⲎ ⲈⲐⲘⲞⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲆⲈ ⲀⲢⲒⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈ ⲞⲨⲚⲀⲒ ⲠⲈϮⲞⲨⲀϢϤ ⲞⲨⲞϨ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲀⲚ ⲚⲈⲦⲀⲒⲒ ⲄⲀⲢ ⲀⲚ ⲈⲐⲀϨⲈⲘ ⲚⲒⲐⲘⲎⲒ ⲀⲖⲖⲀ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ⲦⲞⲦⲈ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲚⲞⲚ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲦⲈⲚⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲚϨⲀⲚⲘⲎ ϢⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲐⲰⲞⲨ ⲤⲈⲈⲢⲚⲎ ⲤⲦⲈⲨⲒⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲎ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲈⲈⲢϨⲎⲂⲒ ϨⲰⲤ ⲈϤⲚⲈⲘⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲤⲈⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ⲈϢⲰⲠ ⲀⲨϢⲀⲚⲰⲖⲒ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ ⲦⲞⲦⲈ ⲈⲨⲈⲈⲢⲚⲎ ⲤⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ⲘⲠⲀⲢⲈ ϨⲖⲒ ⲈⲖ ⲞⲨⲦⲰⲒⲤ ⲘⲂⲈⲢⲒ ⲚⲦⲈϤϨⲒⲦⲤ ⲈⲞⲨⲪⲈⲖϪⲒ ⲚϨⲂⲞⲤ ϢⲀⲤⲰⲖⲒ ⲄⲀⲢ ⲘⲠⲈⲤⲘⲞϨ ⲈⲂⲞⲖ ϨⲒ ⲠⲒϨⲂⲞⲤ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲞⲨⲪⲰϦ ϢⲰⲠⲒ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ⲞⲨⲆⲈ ⲘⲠⲀⲨϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲚⲀⲠⲀⲤ ⲘⲘⲞⲚ ϢⲀⲢⲈ ⲚⲒⲀⲤⲔⲞⲤ ⲪⲰϦ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲠⲒⲎⲢⲠ ⲪⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒⲀⲤⲔⲞⲤ ⲦⲀⲔⲞ ⲀⲖⲖⲀ ϢⲀⲨϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲘⲂⲈⲢⲒ ⲞⲨⲞϨ ϢⲀⲨϤⲒ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ⲚⲀⲒ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲒⲤ ⲞⲨⲀⲢⲬⲰⲚ ⲀϤⲒ ⲀϤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ Ⲁ- ⲦⲀϢⲈⲢⲒ ⲘⲞⲨ ϮⲚⲞⲨ ⲀⲖⲖⲀ ⲀⲘⲞⲨ ⲬⲀ ⲦⲈⲔϪⲒϪ ϨⲒϪⲰⲤ ⲞⲨⲞϨ ⲈⲤⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲤϨⲒⲘⲒ ⲈⲢⲈ ⲠⲈⲤⲤⲚⲞϤ ϢⲀⲦ ⲈⲂⲞⲖ ϦⲀⲢⲞⲤ ⲘⲒⲂ ⲚⲢⲞⲘⲠⲒ ⲀⲤⲒ ⲈⲂⲞⲖ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲞϤ ⲀⲤϬⲒ ⲚⲈⲘ ⲠϢⲦⲀϮ ⲚⲦⲈⲠⲈϤϨⲂⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ⲀⲤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲤ ϪⲈ ⲘⲞⲚⲞⲚ ⲀⲒϢⲀⲚϬⲒ ⲚⲈⲘ ⲠϢⲦⲀϮ ⲚⲦⲈⲠⲈϤϨⲂⲞⲤ ϮⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲦⲀϢⲈⲢⲒ ⲠⲈⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲒ ⲞⲨⲞϨ ⲀⲤⲞⲨϪⲀⲒ ⲚϪⲈϮⲤϨⲒⲘⲒ ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒⲀⲢⲬⲰⲚ ⲀϤⲚⲀⲨ ⲈⲚⲒⲢⲈϤϪⲰⲞⲨⲒ ⲚⲈⲘ ⲚⲒⲘⲎ ϢⲈⲨϢⲦⲈⲢⲐⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ⲚⲀϤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲘⲠⲈⲤⲘⲞⲨ ⲄⲀⲢ ⲚϪⲈϮⲀⲖⲞⲨ ⲀⲖⲖⲀ ⲀⲤⲚⲔⲞⲦ ⲞⲨⲞϨ ⲚⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀϤϨⲒ ⲠⲒⲘⲎϢ ⲈⲂⲞⲖ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲀϤⲀⲘⲞⲚⲒ ⲚⲦⲈⲤϪⲒϪ ⲞⲨⲞϨ ⲀⲤⲦⲰⲚⲤ ⲚϪⲈϮⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ⲞⲨⲞϨ ⲀⲦⲈⲤⲤⲘⲎ ϢⲈ ⲚⲀⲤ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲦⲎⲢϤ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈⲂⲈⲖⲖⲈ ⲂⲈⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒ ⲚⲀⲚ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ⲈⲦⲀϤⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲂⲈⲖⲖⲈⲨ ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲈⲢ ⲪⲀⲒ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ⲦⲞⲦⲈ ⲀϤϬⲒ ⲚⲈⲘ ⲚⲞⲨⲂⲀⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀⲦⲀ ⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲤⲈϢⲰⲠⲒ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲚ ⲚϪⲈⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ⲈⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨⲤⲈⲢ ⲦⲈϤⲤⲘⲎ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲀϨⲒ ⲦⲎⲢϤ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ⲈϤⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ϨⲎⲠⲠⲈ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲈⲂⲞ ⲈⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒ ⲠⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲀϤⲤⲀϪⲒ ⲚϪⲈⲠⲒⲈⲂⲞ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲚϪⲈⲚⲒⲘⲎϢ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈ ϨⲖⲒ ⲞⲨⲞⲚϨϤ ⲈⲚⲈϨ ⲘⲠⲀⲒⲢⲎϮ ϦⲈⲚⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϦⲈⲚⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ ⲀϤϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲒⲂⲀⲔⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϮⲘⲒ ⲈϤϮⲤⲂⲰ ⲚϨⲢⲎⲒ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲈϤϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈϤⲈⲢⲪⲀϦⲢⲒ ⲈϢⲰⲚⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲒⲀⲂⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲚⲒⲘⲎϢ ⲀϤϢⲈⲚϨⲎⲦ ϦⲀⲢⲰⲞⲨ ϪⲈ ⲚⲀⲨⲤⲞⲢⲈⲘ ⲞⲨⲞϨ ⲚⲀⲨⲢⲞϪⲠ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲤⲰⲞⲨ ⲘⲘⲞⲚⲦⲞⲨ ⲘⲀⲚⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲒⲰⲤϦ ⲘⲈⲚ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲆⲈ ϨⲀⲚⲔⲞⲨϪⲒ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ⲦⲰⲂϨ ⲞⲨⲚ ⲘⲠϬⲞⲒⲤ ⲘⲠⲒⲰⲤϦ ϨⲒⲚⲀ ⲚⲦⲈϤⲦⲀⲞⲨⲞ ⲚϨⲀⲚⲈⲢⲄⲀⲦⲎⲤ ⲈⲂⲞⲖ ⲈⲠⲈϤⲰⲤϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲠⲒⲒⲂ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤϮⲈⲢϢⲒϢⲒ ⲚⲰⲞⲨ ⲈϪⲈⲚ ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ϨⲰⲤⲦⲈ ⲈϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲈⲢⲪⲀϦⲢⲒ ⲈϢⲰⲚⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲒⲀⲂⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ⲪⲢⲀⲚ ⲆⲈ ⲘⲠⲒⲒⲂ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲀⲒ ⲚⲈⲠⲒϨⲞⲨⲒⲦ ⲠⲈ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲠⲈϤⲤⲞⲚ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲐⲞⲖⲞⲘⲈⲞⲤ ⲐⲰⲘⲀⲤ ⲚⲈⲘ ⲘⲀⲦⲐⲈⲞⲤ ⲠⲒⲦⲈⲖⲰⲚⲎⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲒ ⲚⲀⲖⲪⲈⲞⲤ ⲚⲈⲘ ⲐⲀⲆⲆⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ⲤⲒⲘⲰⲚ ⲠⲒⲬⲀⲚⲀⲚⲈⲞⲤ ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎ ⲤⲪⲎ ⲈⲐⲚⲀⲦⲎⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ⲠⲒⲒⲂ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢϢⲈ ⲈⲪⲘⲰⲒⲦ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲞⲨⲆⲈ ⲘⲠⲈⲢϢⲈ ⲈϦⲞⲨⲚ ⲈⲂⲀⲔⲒ ⲚⲦⲈⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲆⲈ ⲘⲀⲖⲖⲞⲚ ⲈϨⲀⲚⲈⲤⲰⲞⲨ ⲈⲦⲤⲰⲢⲈⲘ ⲚⲦⲈⲠⲎⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ⲈⲢⲈⲦⲈⲚⲘⲞϢⲒ ⲆⲈ ϨⲒⲰⲒϢ ⲈⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ⲚⲎ ⲈⲦϢⲰⲚⲒ ⲀⲢⲒⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲘⲀⲦⲞⲨⲚⲞⲤⲞⲨ ⲚⲒⲔⲀⲔⲤⲈϨⲦ ⲘⲀⲦⲞⲨⲂⲰⲞⲨ ⲚⲒⲆⲈⲘⲰⲚ ϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲀⲢⲈⲦⲈⲚϬⲒ ⲚϪⲒⲚϪⲎ ⲘⲞⲒ ⲚϪⲒⲚϪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ⲘⲠⲈⲢⲬⲀ ⲚⲞⲨⲂ ⲚⲰⲦⲈⲚ ⲞⲨⲆⲈ ϨⲀⲦ ⲞⲨⲆⲈ ϨⲞⲘⲦ ϦⲈⲚⲚⲈⲦⲈⲚⲘⲞϪϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲚⲰⲦⲈⲚ ϨⲒ ⲪⲘⲰⲒⲦ ⲞⲨⲆⲈ ϢⲐⲎⲚ ⲤⲚⲞⲨϮ ⲞⲨⲆⲈ ⲐⲰⲞⲨⲒ ⲞⲨⲆⲈ ϢⲂⲰⲦ ⲠⲒⲈⲢⲄⲀⲦⲎⲤ ⲄⲀⲢ ϤⲈⲘⲠϢⲀ ⲚⲦⲈϤϦⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ϮⲂⲀⲔⲒ ⲆⲈ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ ⲒⲈ ⲠⲒϮⲘⲒ ϢⲒⲚⲒ ⲚϦⲎⲦⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲈⲘⲠϢⲀ ⲞⲨⲞϨ ϢⲰⲠⲒ ⲘⲘⲀⲨ ϢⲀⲦⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ⲈⲢⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲆⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲘⲀⲦⲀⲒⲈ ⲘⲞⲨϮ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲘⲈⲚ ⲈⲠⲒⲎⲒ ⲘⲠϢⲀ ⲚⲦⲈⲦⲈⲚϨⲒⲢⲎⲚⲎ ⲈⲤⲈⲒ ⲈϪⲰϤ ⲈϢⲰⲠ ⲆⲈ ϤⲘⲠϢⲀ ⲀⲚ ⲚⲦⲈⲦⲈⲚϨⲒⲢⲎⲚⲎ ⲈⲤⲈⲔⲞⲦⲤ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚϤⲚⲀϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲞϨ ⲈⲦⲈⲚϤⲚⲀⲤⲰⲦⲈⲘ ⲚⲤⲀⲚⲈⲦⲈⲚⲤⲀϪⲒ ⲈⲢⲈⲦⲈⲚⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲎⲒ ⲒⲈ ϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲒⲈ ⲠⲒϮⲘⲒ ⲚⲈϨ ⲠϢⲰⲒϢ ⲚⲦⲈⲚⲈⲦⲈⲚϬ ⲀⲖⲀⲨϪ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲨⲈϮⲀⲤⲞ ⲈⲠⲔⲀϨⲒ ⲚⲤⲞⲆⲞⲘⲀ ⲚⲈⲘ ⲄⲞⲘⲞⲢⲢⲀ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈϮⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲦⲈ ϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮⲞⲨⲰⲢⲠ ⲘⲘⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲤⲰⲞⲨ ϦⲈⲚⲐⲘⲎϮ ⲚϨⲀⲚⲞⲨⲰⲚϢ ϢⲰⲠⲒ ⲞⲨⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲤⲀⲂⲈ ⲘⲪⲢⲎϮ ⲚⲚⲒϨⲰϤ ⲀⲔⲈⲢⲈⲞⲤ ⲆⲈ ⲘⲪⲢⲎϮ ⲚⲚⲒϬⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ⲘⲀϨⲐⲎⲦⲈⲚ ⲆⲈ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲢⲰⲘⲒ ⲤⲈⲚⲀϮ ⲐⲎⲚⲞⲨ ⲄⲀⲢ ⲈϨⲀⲚⲘⲀⲚϮϨⲀⲠ ⲞⲨⲞϨ ⲤⲈⲚⲀⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ⲈⲨⲈⲈⲚ ⲐⲎⲚⲞⲨ ⲆⲈ ⲚⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲈⲘ ⲚⲒϨⲎⲄⲈⲘⲰⲚ ⲈⲐⲂⲎⲦ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ⲈϢⲰⲠ ⲆⲈ ⲀⲨϢⲀⲚϮ ⲐⲎⲚⲞⲨ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ⲒⲈ ⲠⲰⲤ ⲒⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀϪⲞϤ ⲤⲈⲚⲀϮ ⲄⲀⲢ ⲚⲰⲦⲈⲚ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲘⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲤⲀϪⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲄⲀⲢ ⲠⲈⲐⲚⲀⲤⲀϪⲒ ⲀⲖⲖⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲐⲚⲀⲤⲀϪⲒ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ⲈⲢⲈ ⲞⲨⲤⲞⲚ ⲆⲈ ⲈϤⲈϮ ⲚⲞⲨⲤⲞⲚ ⲈⲪⲘⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲒⲰⲦ ⲈϤⲈϮ ⲚⲞⲨϢⲎⲢⲒ ⲞⲨⲞϨ ⲈⲢⲈ ϨⲀⲚϢⲎⲢⲒ ⲦⲰⲞⲨⲚⲞⲨ ⲈϪⲈⲚ ⲚⲞⲨⲒⲞϮ ⲈⲨⲈϦⲞⲐⲂⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϢⲰⲠⲒ ⲈⲨⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲀⲘⲞⲚⲒ ⲚⲦⲞⲦϤ ϢⲀ ⲈⲂⲞⲖ ⲪⲀⲒ ⲠⲈⲐⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ⲈϢⲰⲠ ⲆⲈ ⲀⲨϢⲀⲚϬⲞϪⲒ ⲚⲤⲰⲦⲈⲚ ϦⲈⲚⲦⲀⲒⲂⲀⲔⲒ ⲪⲰⲦ ⲈⲔⲈⲞⲨⲒ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈⲦⲈⲚⲪⲞϨ ⲈⲘⲈϢⲦ ⲚⲒⲂⲀⲔⲒ ⲚⲦⲈⲠⲒⲤⲖ ϢⲀⲦⲈϤⲒ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ⲘⲘⲞⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲈϤⲞⲨⲞⲦ ⲈⲠⲈϤⲢⲈϤϮ ⲤⲂⲰ ⲞⲨⲆⲈ ⲞⲨⲂⲰⲔ ⲈϤⲞⲨⲞⲦ ⲈⲠⲈϤϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ⲔⲎⲚ ⲈⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈϤⲈⲢ ⲘⲪⲢⲎϮ ⲘⲠⲈϤⲢⲈϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲠⲒⲂⲰⲔ ⲚⲦⲈϤⲈⲢ ⲘⲪⲢⲎϮ ⲘⲠⲈϤϬⲞⲒⲤ ⲒⲤϪⲈ ⲠⲒⲚⲈⲂⲎⲒ ⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲂⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲚⲈϤⲢⲈⲘⲚⲎ Ⲓ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲞⲨⲚ ϦⲀⲦⲞⲨϨⲎ ⲘⲘⲞⲚ ⲠⲈⲦϨⲞⲂⲤ ⲄⲀⲢ ϪⲈ ϤⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ⲀⲚ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲠⲈⲦϨⲎⲠ ϪⲈ ⲤⲈⲚⲀⲈⲘⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ⲪⲎ ⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ ϦⲈⲚⲠⲬⲀⲔⲒ ⲀϪⲞϤ ϦⲈⲚⲪⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ϦⲈⲚⲚⲈⲦⲈⲚⲘⲀϢϪ ϨⲒⲰⲒϢ ⲘⲘⲞϤ ϨⲒϪⲈⲚ ⲚⲈⲦⲈⲚϪⲈⲚⲈⲪⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲪⲎ ⲈⲐⲚⲀϦⲰⲦⲈⲂ ⲘⲠⲈⲦⲈⲚⲤⲰⲘⲀ ⲦⲈⲦⲈⲚⲮⲨⲬⲎ ⲆⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈϦⲞⲐⲂⲈⲤ ⲀⲢⲒϨⲞϮ ⲆⲈ ⲚⲐⲞϤ ϦⲀⲦϨⲎ ⲘⲪⲎ ⲈⲦⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈϮⲮⲨⲬⲎ ⲚⲈⲘ ⲠⲒⲤⲰⲘⲀ ⲈⲦⲀⲔⲰⲞⲨ ϦⲈⲚϮⲄⲈⲈⲚⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ⲘⲎ ϬⲀϪ ⲂⲀⲚ ⲈⲦⲞⲨϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲀ ⲞⲨⲦⲈⲂⲒ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎ ⲦⲞⲨ ⲚⲚⲈϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲀϬⲚⲈ ⲠⲈⲦⲈϨⲚⲈ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲒⲔⲈϤⲰⲒ ⲚⲦⲈⲦⲈⲚⲀⲪⲈ ⲤⲈⲎⲠ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲞⲨⲚ ⲦⲈⲦⲈⲚⲞⲨⲞⲦ ⲄⲀⲢ ⲈⲞⲨⲘⲎϢ ⲚϬⲀϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲎ ⲦⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ϮⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ϨⲰ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎ ⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ⲪⲎ ⲈⲐⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ϮⲚⲀϪⲞⲖϤ ⲈⲂⲞⲖ ϨⲰ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ⲘⲠⲈⲢⲘⲈⲨⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈϨⲒⲞⲨⲒ ⲚⲞⲨϨⲒⲢⲎ ⲚⲎ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲚⲈⲦⲀⲒⲒ ⲈϨⲒⲞⲨⲒ ⲚⲞⲨϨⲒⲢⲎ ⲚⲎ ⲀⲚ ⲀⲖⲖⲀ ⲞⲨⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ⲀⲒⲒ ⲄⲀⲢ ⲈⲪⲈⲢϪ ⲞⲨⲢⲰⲘⲒ ⲈⲠⲈϤⲒⲰⲦ ⲞⲨⲞϨ ⲞⲨϢⲈⲢⲒ ⲈⲦⲈⲤⲘⲀⲨ ⲞⲨⲞϨ ⲞⲨϢⲈⲖⲈⲦ ⲈⲦⲈⲤϢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ⲞⲨⲞϨ ⲚⲈⲚϪⲀϪⲒ ⲘⲠⲒⲢⲰⲘⲒ ⲚⲈⲚⲈϤⲢⲈⲘⲚⲎ Ⲓ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ⲪⲎ ⲈⲐⲘⲈⲒ ⲘⲠⲈϤⲒⲰⲦ ⲒⲈ ⲦⲈϤⲘⲀⲨ ⲈϨⲞⲦⲈⲢⲞⲒ ϤⲈⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲘⲈⲒ ⲘⲠⲈϤϢⲎⲢⲒ ⲒⲈ ⲦⲈϤϢⲈⲢⲒ ⲈϨⲞⲦⲈⲢⲞⲒ ϤⲈⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ⲪⲎ ⲈⲦⲈⲚϤⲚⲀⲰⲖⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲀⲚ ⲞⲨⲞϨ ⲚⲦⲈϤⲘⲞϢⲒ ⲚⲤⲰⲒ ϤⲈⲘⲠϢⲀ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ⲪⲎ ⲈⲦⲀϤϪⲒⲘⲒ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϤⲈⲦⲀⲔⲞⲤ ⲪⲎ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲐⲂⲎⲦ ⲈϤⲈϪⲈⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ⲪⲎ ⲈⲦϢⲰⲠ ⲘⲘⲰⲦⲈⲚ ⲀϤϢⲰⲠ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϢⲰⲠ ⲘⲘⲞⲒ ⲀϤϢⲰⲠ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ⲪⲎ ⲈⲦϢⲰⲠ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲪⲢⲀⲚ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤⲈϬⲒ ⲘⲪⲂⲈⲬⲈ ⲚⲞⲨⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲪⲎ ⲈⲦϢⲰⲠ ⲚⲞⲨⲐⲘⲎⲒ ⲈⲪⲢⲀⲚ ⲚⲞⲨⲐⲘⲎ ⲒⲈϤⲈϬⲒ ⲘⲪⲂⲈⲬⲈ ⲚⲞⲨⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲦⲤⲈ ⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲚⲞⲨⲀⲪⲞⲦ ⲘⲘⲰⲞⲨ ⲘⲰⲞⲨ ϨⲰϪ ⲘⲞⲚⲞⲚ ⲈⲪⲢⲀⲚ ⲚⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈϤⲦⲀⲔⲞ ⲚϪⲈⲠⲈϤⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲔⲎⲚ ⲈϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲦⲞⲦϤ ⲘⲠⲈϤⲒⲂ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈⲐⲢⲈϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲚⲦⲈϤϨⲒⲰⲒϢ ⲚϨⲢⲎⲒ ϦⲈⲚⲚⲞⲨⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲈϤⲬⲎ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲈⲐⲂⲈ ⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲞⲨⲰⲢⲠ ⲚⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ϢⲀⲚ ⲚⲦⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲚⲔⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲦⲀⲘⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ϪⲈ ⲚⲒⲂⲈⲖⲖⲈⲨ ⲤⲈⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲒϬⲀⲖⲈⲨ ⲤⲈⲘⲞϢⲒ ⲚⲒⲔⲀⲔⲤⲈϨⲦ ⲤⲈⲦⲞⲨⲂⲎⲞⲨⲦ ⲚⲒⲔⲞⲨⲢ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲤⲈⲦⲰⲞⲨⲚⲞⲨ ⲚⲒϨⲎⲔⲒ ⲤⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ⲞⲨⲞϨ ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲪⲎ ⲈⲦⲈⲚϤⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ⲚⲀⲒ ⲆⲈ ⲈⲨⲚⲀϢⲈ ⲚⲰⲞⲨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚϪⲞⲤ ⲚⲚⲒⲘⲎϢ ⲈⲐⲂⲈ ⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲠϢⲀϤⲈ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲞⲨⲔⲀϢ ⲈⲢⲈ ⲠⲒⲐⲎⲞⲨ ⲔⲒⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ⲀⲖⲖⲀ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲞⲨⲢⲰⲘⲒ ⲈϤⲬⲎ ϦⲈⲚϨⲀⲚϬⲒϨⲂⲞⲤ ⲚϪⲀⲚⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲀ ⲚⲒϨⲂⲰⲤ ⲚϪⲀⲚⲈ ⲤⲈⲬⲎ ϦⲈⲚⲚⲒⲎⲞⲨ ⲚⲚⲒⲞⲨⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ⲀⲖⲖⲀ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲐⲂⲈⲞⲨ ⲈⲚⲀⲨ ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲀϨⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲞⲨⲞ ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ⲪⲀⲒ ⲄⲀⲢ ⲪⲎ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦϤ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲞⲨⲰⲢⲠ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ ϦⲀϪⲰⲔ ⲞⲨⲞϨ ⲈϤⲈⲤⲞⲂϮ ⲘⲠⲈⲔⲘⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲈ ⲞⲨⲞⲚ ⲦⲰⲚϤ ϦⲈⲚⲚⲒⲘⲒⲤⲒ ⲚⲦⲈⲚⲒϨⲒⲞⲘⲒ ⲈⲚⲀⲀϤ ⲈⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲠⲒⲔⲞⲨϪⲒ ⲆⲈ ⲈⲢⲞϤ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲚⲒϢϮ ⲈⲢⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ⲒⲤϪⲈⲚ ⲚⲒⲈϨⲞⲞⲨ ⲆⲈ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮ ⲰⲘⲤ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲤⲈϬⲒ ⲘⲘⲞⲤ ⲚϪⲞⲚⲤ ⲞⲨⲞϨ ϨⲀⲚⲢⲈϤϬⲒ ⲚϪⲞⲚⲤ ⲠⲈⲦϨⲰⲖⲈⲘ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲠⲒⲚⲞⲘⲞⲤ ⲀⲨⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ϢⲀ ⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲈϢⲞⲠϤ ⲚⲐⲞϤ ⲠⲈ ⲎⲖⲒⲀⲤ ⲈⲐⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ⲀⲒⲚⲀⲦⲈⲚⲐⲰⲚ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲆⲈ ⲈⲚⲒⲘ ⲤⲞⲚⲒ ⲚϨⲀⲚⲀⲖⲰⲞⲨⲒ ⲈⲨϨⲈⲘⲤⲒ ϨⲒ ⲚⲒⲀⲄⲞⲢⲀ ⲚⲀⲒ ⲈⲐⲘⲞⲨϮ ⲞⲨⲂⲈ ⲚⲞⲨⲈⲢⲎⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲰ ⲈⲢⲰⲦⲈⲘ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚϬⲞⲤϪⲈⲤ ⲀⲚⲢⲒⲘⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲚⲈϨⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ⲀϤⲒ ⲄⲀⲢ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲞⲨⲞϨ ⲈⲚϤⲤⲰ ⲀⲚ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲈϤⲤⲰ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲤⲀⲨⲎⲢⲠ ⲠϢⲪⲎⲢ ⲠⲈ ⲚⲦⲈⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲞⲨⲞϨ ⲀⲤⲐⲘⲀⲒⲞ ⲚϪⲈϮⲤⲞⲪⲒⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲤϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ⲦⲞⲦⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲬⲞϨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲂⲀⲔⲒ ⲚⲎ ⲈⲦⲀ ⲠϨⲞⲨⲞ ⲚⲚⲈϤϪⲞⲘ ϢⲰⲠⲒ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ⲞⲨⲞⲒ ⲚⲈⲬⲞⲢⲀⲌⲒⲚ ⲞⲨⲞⲒ ⲚⲈⲂⲎⲐⲤⲀⲒⲆⲀ ϪⲈ ⲈⲚⲈⲀ ⲚⲀⲒϪⲞⲘ ϢⲰⲠⲒ ϦⲈⲚⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲈⲦⲀⲨϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲈⲒⲤⲐⲚⲈⲒ ⲠⲈ ⲀⲨⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ϦⲈⲚⲞⲨⲤⲞⲔ ⲚⲈⲘ ⲞⲨⲔⲈⲢⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲈⲨⲈϮⲀⲤⲞ ⲈⲢⲰⲞⲨ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲚⲦⲈϮⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲦⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ⲚⲈⲘ ⲚⲐⲞ ϨⲰⲒ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲘⲎ ⲦⲈⲢⲀϬⲒⲤⲒ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ⲈⲨⲈⲐⲈⲂⲒⲞ ϢⲀ ⲈϦⲢⲎⲒ ⲈⲀⲘⲈⲚϮ ϪⲈ ⲈⲚⲈ ϦⲈⲚⲤⲞⲆⲞⲘⲀ ⲀⲨϢⲰⲠⲒ ⲚϪⲈⲚⲀⲒϪⲞⲘ ⲈⲦⲀⲨϢⲰⲠⲒ ⲚϦⲎϮ ⲚⲈⲒⲤϪⲈⲔ ⲤⲈϢⲞⲠ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲠⲔⲀϨⲒ ⲚⲤⲞⲆⲞⲘⲀ ⲈⲨⲈϮⲀⲤⲞ ⲈⲢⲞϤ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲚⲦⲈϮⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲦⲈⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϮⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ⲪⲒⲰⲦ ⲠϬⲞⲒⲤ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲔⲀϨⲒ ϪⲈ ⲀⲔϨⲈⲠ ⲚⲀⲒ ⲈϨⲀⲚⲤⲀⲂⲈⲨ ⲚⲈⲘ ϨⲀⲚⲔⲀⲦϨⲎⲦ ⲞⲨⲞϨ ⲀⲔϬⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ⲀϨⲀ ⲪⲒⲰⲦ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒϮⲘⲀϮ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲠⲈⲔⲘⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲪⲒⲰⲦ ⲦⲎⲒⲦⲞⲨ ⲈⲦⲞⲦ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲤⲰⲞⲨⲚ ⲘⲠϢⲎⲢⲒ ⲈⲂⲎⲖ ⲈⲪⲒⲰⲦ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲤⲰⲞⲨⲚ ⲘⲪⲒⲰⲦ ⲈⲂⲎⲖ ⲈⲠϢⲎⲢⲒ ⲚⲈⲘ ⲪⲎ ⲈⲦⲈϨⲚⲈ ⲠϢⲎⲢⲒ ⲈϬⲰⲢⲠ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ⲀⲘⲰⲒⲚⲒ ϨⲀⲢⲞⲒ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϦⲞⲤⲒ ⲞⲨⲞϨ ⲈⲦⲞⲠⲦ ϦⲀ ⲚⲞⲨⲈⲦⲪⲰⲞⲨⲒ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲈⲐⲚⲀϮⲘⲦⲞⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ⲀⲖⲒⲞⲨⲒ ⲘⲠⲀⲚⲀϨⲂⲈϤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲀⲢⲒⲈⲘⲒ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲢⲈⲘⲢⲀⲨϢ ⲞⲨⲞϨ ϮⲐⲈⲂⲒⲎⲞⲨⲦ ϦⲈⲚⲠⲀϨⲎⲦ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲚⲞⲨⲘⲀⲚⲘⲦⲞⲚ ⲚⲚⲈⲦⲈⲚⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ⲠⲀⲚⲀϨⲂⲈϤ ⲄⲀⲢ ϨⲞⲖϪ ⲞⲨⲞϨ ⲦⲀⲈⲦⲪⲰ ⲀⲤⲒⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲢⲞϮ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲈⲀⲨϨⲔⲞ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲤⲰⲖⲠ ⲚⲤⲀⲚⲒϦⲈⲘⲤ ⲈⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲈⲦⲀⲨⲚⲀⲨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲒⲤ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲤⲈⲒⲢⲒ ⲘⲠⲈⲦⲤϢⲈ ⲚⲀⲒϤ ⲀⲚ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲦⲈⲚⲰϢ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲀ ⲆⲀⲨⲒⲆ ⲀⲒϤ ⲈⲦⲀϤϨⲔⲞ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ⲠⲰⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲒⲰⲒⲔ ⲚⲦⲈϮⲠⲢⲞⲐⲈⲤⲒⲤ ⲀϤⲞⲨⲞⲘⲞⲨ ⲚⲎ ⲈⲦⲈⲚⲀⲤⲘⲠϢⲀ ⲚⲀϤ ⲀⲚ ⲠⲈ ⲈⲞⲨⲰⲘ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲞⲨⲆⲈ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ⲈⲂⲎⲖ ⲈⲚⲒⲞⲨⲎⲂ ⲘⲘⲀⲨⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ⲀⲚ ⲘⲠⲈⲦⲈⲚⲰϢ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ϪⲈ ⲚϨⲢⲎ ⲒϦⲈⲚ ⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲞⲨⲎⲂ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲤⲈⲤⲰϤ ⲘⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲚⲞⲂⲒ ϬⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲒⲤ ϨⲞⲨⲞ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ⲈⲚⲀⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈ ⲞⲨⲚⲀⲒ ϮⲞⲨⲀϢϤ ⲞⲨⲞϨ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲀⲚ ⲚⲀⲢⲈⲦⲈⲚⲚⲀϮ ϨⲀⲠ ⲀⲚ ⲠⲈ ⲈⲚⲒⲀⲦⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ⲠϬⲞⲒⲤ ⲄⲀⲢ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲦⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲢⲈ ⲦⲈϤϪⲒϪ ϢⲞⲨⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚ ⲤϢⲈ ⲚⲈⲢⲪⲀϦⲢⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲒⲚⲀ ⲚⲤⲈⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ⲚⲢⲰⲘⲒ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈⲞⲨⲞⲚⲦⲈϤ ⲞⲨⲈⲤⲰⲞⲨ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲦⲈⲪⲀⲒ ϨⲈⲒ ⲈⲞⲨϢⲒⲔ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲎ ϤⲚⲀⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲀⲚ ⲚⲦⲈϤⲦⲞⲨⲚⲞⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ⲒⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ϪⲈ ⲞⲨⲞⲦ ⲈⲞⲨⲈⲤⲰⲞⲨ ⲚⲀⲨⲎⲢ ϨⲰⲤⲦⲈ ⲤϢⲈ ⲚⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲘⲠⲒⲢⲰⲘⲒ ϪⲈ ⲤⲞⲨⲦⲈⲚ ⲦⲈⲔϪⲒϪ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲤⲞⲨⲦⲰⲚⲤ ⲞⲨⲞϨ ⲀⲤⲞⲨϪⲀⲒ ⲘⲪⲢⲎϮ ⲚϮⲬⲈϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ϦⲀⲢⲞϤ ϨⲒⲚⲀ ⲚⲤⲈⲦⲀⲔⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲈⲘⲒ ⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲀⲀⲖⲞⲨ ⲪⲎ ⲈⲦⲀϤⲢⲀⲚⲎ ⲒⲠⲀⲘⲈⲚⲢⲒⲦ ⲪⲎ ⲈⲦⲀ ⲦⲀⲮⲨⲬⲎ ϮⲘⲀϮ ⲚϦⲎⲦϤ ⲈⲒⲈⲬⲰ ⲘⲠⲀⲠⲚⲈⲨⲘⲀϨⲒϪⲰϤ ⲈϤⲈⲦⲀⲘⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲈⲨϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ⲚⲚⲈϤϢϬⲚⲎⲚ ⲞⲨⲆⲈ ⲚⲚⲈϤⲰϢ ⲈⲂⲞⲖ ⲞⲨⲆⲈ ⲚⲚⲈ ⲞⲨⲀⲒ ⲤⲰⲦⲈⲘ ⲈⲦⲈϤⲤⲘⲎ ϦⲈⲚⲚⲒⲠⲖⲀⲦⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ⲞⲨⲔⲀϢ ⲈϤϦⲈⲘϦⲰⲘ ⲚⲚⲈϤⲔⲀϢϤ ⲞⲨⲤⲞⲖ ⲈϤⲞⲒ ⲚⲬⲢⲈⲘⲦⲤ ⲚⲚⲈϤϬⲈⲚⲞϤ ϢⲀⲦⲈϤϨⲒⲞⲨⲒ ⲘⲠⲒϨⲀⲠ ⲈⲨϬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ⲞⲨⲞϨ ⲚⲒⲈⲐⲚⲞⲤ ⲈⲨⲈⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ⲦⲞⲦⲈ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲂⲈⲖⲖⲈ ⲈⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲈϤⲞⲒ ⲚⲈⲂⲞ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞϤ ϨⲰⲤⲦⲈ ⲚⲦⲈⲠⲒⲈⲂⲞ ⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ⲚⲀⲨⲦⲞⲘⲦ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚϪⲈⲚⲒⲘⲎϢ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲠⲈ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲀⲢⲈ ⲪⲀⲒ ϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲀⲚ ϦⲈⲚϨⲖⲒ ⲈⲂⲎⲖ ϦⲈⲚⲂⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲚⲞⲨⲘⲞⲔⲘⲈⲔ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲈⲦⲞⲨⲢⲞ ⲚⲒⲂⲈⲚ ⲀⲤϢⲀⲚⲪⲰϢ ⲈϨⲢⲀⲤ ⲘⲘⲀⲨⲀⲦⲤ ϢⲀⲤϢⲰϤ ⲞⲨⲞϨ ⲂⲀⲔⲒ ⲚⲒⲂⲈⲚ ⲒⲈ ⲎⲒ ⲚⲒⲂⲈⲚ ⲀⲨϢⲀⲚⲪⲰϢ ⲈϨⲢⲀⲨ ⲘⲘⲀⲨⲦⲞⲨ ⲘⲠⲀⲨϢⲞϨⲒ ⲈⲢⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲠⲈⲦϨⲒⲞⲨⲒ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲂⲞⲖ ⲒⲈ ⲀϤⲪⲰϢ ⲈϨⲢⲀϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲠⲰⲤ ⲞⲨⲚ ⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ ⲚⲀϢⲞϨⲒ ⲈⲢⲀⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲀⲚⲞⲔ ϦⲈⲚⲂⲈⲖⲌⲈⲂⲞⲨⲖ ϮϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲒⲈ ⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲀⲨϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘ ⲈⲐⲂⲈ ⲪⲀⲒ ⲚⲐⲰⲞⲨ ⲈⲨⲈⲈⲢⲢⲈϤϮϨⲀⲠ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ⲒⲤϪⲈ ⲆⲈ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲚⲞⲔ ϮϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϨⲀⲢⲀ ⲀⲤⲪⲞϨ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ⲒⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲞⲨⲀⲒ ϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒϪⲰⲢⲒ ⲚⲦⲈϤϨⲰⲖⲈⲘ ⲚⲚⲈϤⲤⲔⲈⲨⲞⲤ ⲀϤϢⲦⲈⲘⲤⲰⲚϨ ⲘⲠⲒϪⲰⲢⲒ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲚⲦⲈϤϨⲰⲖⲈⲘ ⲘⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ⲪⲎ ⲈⲦⲈⲚϤⲚⲈⲘⲎⲒ ⲀⲚ ⲀϤϮⲞⲨⲂⲎⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚϤⲈⲢⲤⲨⲚⲀⲄⲒⲤⲐⲈ ⲚⲈⲘⲎⲒ ⲀⲚ ϤϪⲰⲢ ⲘⲘⲞⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ⲈⲐⲂⲈ ⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲞⲂⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϪⲈⲞⲨⲀ ⲚⲒⲂⲈⲚ ⲈⲨⲈⲬⲀⲨ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲠⲒϪⲈⲞⲨⲀ ⲆⲈ ⲚⲐⲞϤ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲚⲞⲨⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϪⲈ ⲞⲨⲤⲀϪⲒ ⲚⲤⲀⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲨⲈⲬⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϪⲰ ϦⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲚⲞⲨⲬⲰ ⲚⲀϤ ⲈⲂⲞⲖ ⲞⲨⲆⲈ ϦⲈⲚⲠⲀⲒⲈⲚⲈϨ ⲞⲨⲆⲈ ϦⲈⲚⲠⲈⲐⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ⲒⲈ ⲀⲢⲒ ⲠⲒϢϢⲎⲚ ⲈⲐⲚⲀⲚⲈϤ ⲚⲈⲘ ⲠⲈϤⲞⲨⲦⲀϨ ⲈⲐⲚⲀⲚⲈϤ ⲒⲈ ⲀⲢⲒ ⲠⲒϢϢⲎⲚ ⲈⲦϨⲰⲞⲨ ⲚⲈⲘ ⲠⲈϤⲞⲨⲦⲀϨ ⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ⲄⲀⲢ ϦⲈⲚⲠⲒⲞⲨⲦⲀϨ ϢⲀⲨⲤⲞⲨⲈⲚ ⲠⲒϢϢⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ⲚⲒⲘⲒⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲀϪⲰ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲤⲀϪⲒ ⲚϨⲀⲚⲠⲈⲐⲚⲀⲚⲈϤ ⲈⲢⲈⲦⲈⲚϨⲰⲞⲨ ⲈⲂⲞⲖ ⲄⲀⲢ ϦⲈⲚⲠϨⲞⲨⲞ ⲘⲠⲒϨⲎ ⲦϢⲀⲢⲈ ⲠⲒⲢⲰ ⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ⲠⲒⲀⲄⲀⲐⲞⲤ ⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲀϨⲞ ⲚⲀⲄⲀⲐⲞⲚ ϢⲀϤⲦⲀⲞⲨⲞ ⲘⲠⲒⲀⲄⲀⲐⲞⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲒⲢⲰⲘⲒ ⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲀϨⲞ ⲈⲦϨⲰⲞⲨ ϢⲀϤⲦⲀⲞⲨⲞ ⲚⲚⲒⲠⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲤⲀϪⲒ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲨⲒⲦ ⲈⲦⲈ ⲚⲒⲢⲰⲘⲒ ⲚⲀϪⲞⲦⲞⲨ ⲤⲈⲚⲀϮ ⲖⲞⲄⲞⲤ ϦⲀⲢⲰⲞⲨ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲚⲦⲈϮⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ⲈⲂⲞⲖ ⲄⲀⲢ ϦⲈⲚⲚⲈⲔⲤⲀϪⲒ ⲈⲔⲈⲘⲀⲒ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲔⲤⲀϪⲒ ⲈⲨⲈϮϨⲀⲠ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ⲦⲞⲦⲈ ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲢⲈϤϮⲤⲂⲰ ⲦⲈⲚⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲞⲨⲘⲎⲒⲚⲒ ⲚⲦⲞⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲒϪⲰⲞⲨ ⲈⲦϨⲰⲞⲨ ⲞⲨⲞϨ ⲚⲚⲰⲒⲔ ϤⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎⲒⲚⲒ ⲞⲨⲞϨ ⲞⲨⲘⲎⲒⲚⲒ ⲚⲚⲞⲨⲦⲎⲒϤ ⲚⲀϤ ⲈⲂⲎⲖ ⲈⲠⲒⲘⲎⲒⲚⲒ ⲚⲦⲈⲒⲰⲚⲀ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲚⲒⲰⲚⲀ ⲈⲚⲀϤϦⲈⲚ ⲐⲚⲈϪⲒ ⲘⲠⲒⲔⲎⲦⲞⲤ ⲚⲄ ⲚⲈϨⲞⲞⲨ ⲚⲈⲘ ⲄⲚⲈϪⲰⲢϨ ⲠⲀⲒⲢⲎϮ ϨⲰϤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲈⲈⲢ ⲄⲚⲈϨⲞⲞⲨ ⲚⲈⲘ ⲄⲚⲈϪⲰⲢϨ ϦⲈⲚⲠϨⲎⲦ ⲘⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ⲚⲒⲢⲰⲘⲒ ⲚⲦⲈⲚⲒⲚⲈⲨⲎ ⲈⲨⲈⲦⲰⲞⲨⲚⲞⲨ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲚⲈⲘ ⲠⲀⲒϪⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈϮϨⲀⲠ ⲈⲢⲞϤ ϪⲈ ⲀⲨⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲈⲠϨⲒⲰⲒϢ ⲚⲦⲈⲒⲰⲚⲀ ⲞⲨⲞϨ ⲒⲤ ϨⲞⲨⲞ ⲈⲒⲰⲚⲀ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ϮⲞⲨⲢⲰ ⲚⲦⲈⲤⲀⲢⲎⲤ ⲈⲤⲈⲦⲰⲚⲤ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲚⲈⲘ ⲠⲀⲒϪⲰⲞⲨ ⲞⲨⲞϨ ⲈⲤⲈϮϨⲀⲠ ⲈⲢⲞϤ ϪⲈ ⲀⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲀⲦ ⲘⲠⲔⲀϨⲒ ⲈⲤⲰⲦⲈⲘ ⲈϮⲤⲞⲪⲒⲀ ⲚⲦⲈⲤⲞⲖⲞⲘⲰⲚ ⲞⲨⲞϨ ⲒⲤ ϨⲞⲨⲞ ⲈⲤⲞⲖⲞⲘⲰⲚ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲰⲘⲒ ϢⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ⲈϨⲀⲚⲘⲀⲚⲀⲐⲘⲰⲞⲨ ⲈϤⲔⲰϮ ⲚⲤⲀⲘⲀⲚⲘⲦⲞⲚ ⲞⲨⲞϨ ⲘⲠⲀϤϪⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ⲦⲞⲦⲈ ϢⲀϤϪⲞⲤ ϪⲈ ⲈⲒⲈⲦⲀⲤⲐⲞ ⲈϦⲞⲨⲚ ⲈⲠⲀⲎⲒ ⲠⲒⲘⲀ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤϢⲀⲚⲒ ⲚⲦⲈϤϪⲈⲘϤ ⲈϤⲤⲢⲰϤⲦ ⲈϤⲤⲀⲢϨ ⲞⲨⲞϨ ⲈϤⲤⲈⲖⲤⲰⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ⲦⲞⲦⲈ ϢⲀϤϢⲈ ⲚⲀϤ ⲚⲦⲈϤϬⲒ ⲚⲈⲘⲀϤ ⲚⲔⲈⲌ ⲘⲠⲚⲈⲨⲘⲀⲈⲨϨⲰⲞⲨ ⲈϨⲞⲦⲈⲢⲞϤ ⲞⲨⲞϨ ϢⲀϤⲒ ⲚⲦⲈϤϢⲰⲠⲒ ⲘⲘⲀⲨ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒϦⲀⲈⲨ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲦϨⲰⲞⲨ ⲚⲀϤ ⲈⲚⲈϤϨⲞⲨⲀϮ ⲠⲀⲒⲢⲎϮ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ⲘⲠⲀⲒϪⲰⲞⲨ ⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ϨⲰⲤ ⲆⲈ ⲈϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲘⲎϢ ⲒⲤ ⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ ⲚⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲈⲨⲔⲰϮ ⲚⲤⲀⲤⲀϪⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲆⲈ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲦⲈⲔⲘⲀⲨ ⲚⲈⲘ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲤⲀⲂⲞⲖ ⲤⲈⲔⲰϮ ⲚⲤⲰⲔ ");
INSERT INTO copbhc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲒⲘ ⲦⲈ ⲦⲀⲘⲀⲨ ⲒⲈ ⲚⲒⲘ ⲚⲈⲚⲀⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ⲞⲨⲞϨ ⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲤ ⲠⲈϪⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲦⲀⲘⲀⲨ ⲚⲈⲘ ⲚⲀⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲈⲢⲠⲈⲦⲈϨⲚⲈ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲚⲐⲞϤ ⲠⲈ ⲠⲀⲤⲞⲚ ⲚⲈⲘ ⲦⲀⲤⲰⲚⲒ ⲚⲈⲘ ⲦⲀⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲎⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀϤϨⲈⲘⲤⲒ ⲠⲈ ⲈⲤⲔⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ⲞⲨⲞϨ ⲀⲨⲐⲰⲞⲨϮ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ϨⲰⲤⲦⲈ ⲚⲦⲈϤⲀⲖⲎⲒ ⲈⲠϪⲞⲒ ⲚⲦⲈϤϨⲈⲘⲤⲒ ⲠⲒⲘⲎϢ ⲆⲈ ⲦⲎⲢϤ ⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲚϨⲀⲚⲘⲎϢ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϨⲎⲠⲠⲈ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲤⲒϮ ⲈⲤⲒϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ⲞⲨⲞϨ ϦⲈⲚⲠϪⲒⲚⲐⲢⲈϤⲤⲒϮ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲀⲨϨⲈⲒ ⲈⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲚⲒϨⲀⲖⲀϮ ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀ ⲘⲠⲈⲦⲢⲀ ⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲞⲚ ϢⲰⲔ ⲚⲔⲀϨⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲨⲢⲰⲦ ⲤⲀⲦⲞⲦⲞⲨ ϪⲈ ⲘⲘⲞⲚⲦⲞⲨ ϢⲰⲔ ⲚⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ⲈⲦⲀ ⲪⲢⲎ ⲆⲈ ϢⲀⲒ ⲀⲨⲈⲢⲔⲀⲨⲘⲀ ⲞⲨⲞϨ ϪⲈ ⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲨⲚⲒ ⲘⲘⲀⲨ ⲀⲨϢⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨϨⲈⲒ ⲈϪⲈⲚ ⲚⲒⲤⲞⲨⲢⲒ ⲞⲨⲞϨ ⲀⲨⲢⲰⲦ ⲚϪⲈⲚⲒⲤⲞⲨⲢⲒ ⲞⲨⲞϨ ⲀⲨⲞϪϨⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲀⲨϮⲞⲨⲦⲀϨ ⲞⲨⲀⲒ ⲘⲈⲚ ⲀϤⲈⲢ ⲢⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀϤⲈⲢ ⲜⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀϤⲈⲢ Ⲗ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ⲪⲎ ⲈⲦⲈⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲤⲦⲞⲒ ⲚⲰⲦⲈⲚ ⲈⲈⲘⲒ ⲈⲚⲒⲘⲨⲤⲦⲎ ⲢⲒⲞⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲎ ⲆⲈ ⲘⲠⲞⲨⲦⲎⲒⲤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ⲪⲎ ⲄⲀⲢ ⲈⲦⲈⲞⲨⲞⲚ ⲚⲦⲀϤ ⲈⲨⲈϮ ⲚⲀϤ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲞⲚ ⲈⲢϨⲞⲨⲞ ⲈⲢⲞϤ ⲪⲎ ⲆⲈ ⲈⲦⲈⲘⲘⲞⲚ ⲚⲦⲀϤ ⲪⲎ ⲈⲦⲈⲚⲦⲞⲦϤ ⲈⲨⲈⲞⲖϤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ⲈⲐⲂⲈⲪⲀⲒ ϮⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲞⲨⲎⲒ ⲈⲨⲚⲀⲨ ⲚⲤⲈⲚⲀⲨ ⲀⲚ ⲞⲨⲞϨ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲤⲈⲤⲰⲦⲈⲘ ⲀⲚ ⲆⲈ ⲚⲤⲈⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ⲞⲨⲞϨ ⲈⲤⲈϪⲰⲔ ⲈⲂⲞⲖ ⲈϪⲰⲞⲨ ⲚϪⲈϮⲠⲢⲞⲪⲎⲦⲒⲀ ⲚⲦⲈⲎⲤⲀⲒⲀⲤ ⲐⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ϦⲈⲚⲞⲨⲤⲘⲎ ⲈⲢⲈⲦⲈⲚⲈⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲚⲈⲦⲈⲚⲔⲀϮ ⲞⲨⲞϨ ϦⲈⲚⲞⲨⲚⲀⲨ ⲈⲢⲈⲦⲈⲚⲈⲚⲀⲨ ⲞⲨⲞϨ ⲚⲚⲈⲦⲈⲚⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ⲀϤⲞⲨⲘⲞⲦ ⲄⲀⲢ ⲚϪⲈⲠϨⲎⲦ ⲘⲠⲀⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲀⲨϨⲢⲞϢ ϦⲈⲚⲚⲞⲨⲘⲀϢϪ ⲈⲠⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲀⲨⲘⲀϢⲐⲀⲘ ⲚⲚⲞⲨⲂⲀⲖ ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈⲚⲀⲨ ⲚⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲚⲤⲈⲤⲰⲦⲈⲘ ϦⲈⲚⲚⲞⲨⲘⲀϢϪ ⲞⲨⲞϨ ⲚⲤⲈⲔⲀϮ ϦⲈⲚⲠⲞⲨϨⲎ ⲦⲞⲨⲞϨ ⲚⲤⲈⲔⲞⲦⲞⲨ ⲚⲦⲀⲦⲞⲨϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲈⲦⲈⲚⲂⲀⲖ ϪⲈ ⲤⲈⲚⲀⲨ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲘⲀϢϪ ϪⲈ ⲤⲈⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲀⲚⲘⲎϢ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ϨⲀⲚⲐⲘⲎⲒ ⲀⲨⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨⲚⲀⲨ ⲞⲨⲞϨ ⲈⲤⲰⲦⲈⲘ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ⲚⲐⲰⲦⲈⲚ ⲞⲨⲚ ⲤⲰⲦⲈⲘ ⲈϮⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲦⲈⲪⲎ ⲈⲦⲤⲒϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈⲦⲈⲚϤⲔⲀϮ ⲈⲢⲞϤ ⲀⲚ ϢⲀϤⲒ ⲚϪⲈⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲞⲨⲞϨ ϢⲀϤϨⲰⲖⲈⲘ ⲘⲪⲎ ⲈⲦⲀⲨⲤⲀⲦϤ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲀϤⲤⲀⲦϤ ⲈⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ⲪⲎ ⲆⲈ ⲈⲦⲀⲨⲤⲀⲦϤ ⲈϪⲈⲚ ⲠⲒⲘⲀⲘⲠⲈⲦⲢⲀ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ϤϬⲒ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ⲘⲘⲞⲚⲦⲈϤ ⲚⲞⲨⲚⲒ ⲚϦⲎⲦϤ ⲀⲖⲖⲀ ⲞⲨⲠⲢⲞⲤⲞⲨⲤⲎⲞⲨ ⲠⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨϨⲞϪϨⲈϪ ⲆⲈ ϢⲰⲠⲒ ⲒⲈ ⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲤⲀϪⲒ ⲤⲀⲦⲞⲦϤ ϢⲀϤⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ⲪⲎ ⲆⲈ ⲈⲦⲀⲨⲤⲀⲦϤ ⲈϪⲈⲚ ⲚⲒⲤⲞⲨⲢⲒ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲪⲢⲰⲞⲨϢ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲚⲈⲘ ϮⲀⲠⲀⲦⲎ ⲚⲦⲈϮⲘⲈⲦⲢⲀⲘⲀⲞ ϢⲀⲨⲰϪϨ ⲘⲠⲒⲤⲀϪⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ϢⲀϤⲈⲢⲀⲦⲞⲨⲦⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ⲪⲎ ⲆⲈ ⲈⲦⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲈⲦⲔⲀϮ ⲈⲢⲞϤ ⲪⲀⲒ ⲆⲈ ϢⲀϤϮⲞⲨⲦⲀϨ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲘⲈⲚ ϢⲀϤⲈⲢ ⲢⲞⲨⲀⲒ ⲆⲈ ϢⲀϤⲈⲢ ⲜⲞⲨⲀⲒ ⲆⲈ ϢⲀϤⲈⲢ Ⲗ-. ");
INSERT INTO copbhc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ⲀϤⲬⲰ ϦⲀⲦⲞⲦⲞⲨ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎ ⲞⲨⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲈⲀϤⲤⲈⲦ ⲞⲨϪⲢⲞϪ ⲈⲚⲀⲚⲈϤ ϦⲈⲚⲠⲈϤⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ⲈⲦⲀⲨⲚⲔⲞⲦ ⲆⲈ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲀϤⲒ ⲚϪⲈⲠⲈϤϪⲀϪⲒ ⲀϤⲤⲒϮ ⲚϨⲀⲚⲚⲦⲎϪ ϦⲈⲚⲐⲘⲎϮ ⲘⲠⲒⲤⲞⲨⲞ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀϤⲢⲰⲦ ⲚϪⲈⲠⲒⲤⲞⲨⲞ ⲞⲨⲞϨ ⲀϤϮⲞⲨⲦⲀϨ ⲦⲞⲦⲈ ⲀⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲔⲈⲚⲦⲎϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ⲀⲨⲒ ⲆⲈ ⲚϪⲈⲚⲒⲈⲂⲒⲀⲒⲔ ⲚⲦⲈⲠⲒⲚⲈⲂⲒⲞϨⲒ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲘⲎ ⲞⲨϪⲢⲞϪ ⲈⲚⲀⲚⲈϤ ⲀⲚ ⲀⲔⲤⲀⲦϤ ϦⲈⲚⲠⲈⲔⲒⲞϨⲒ ⲈⲦⲀⲨϪⲒⲘⲒ ⲞⲨⲚ ⲚⲚⲀⲒⲔⲈⲚⲦⲎϪ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨϪⲀϪⲒ ⲚⲢⲰⲘⲒ ⲠⲈⲦⲀϤⲈⲢ ⲪⲀⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀⲚ ⲬⲞⲨⲰϢ ⲚⲦⲈⲚϢⲈ ⲚⲀⲚ ⲚⲦⲈⲚⲤⲞⲔⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ ⲘⲎⲠⲞⲦⲈ ⲈⲢⲈⲦⲈⲚⲤⲰⲔⲒ ⲚⲚⲒⲈⲚⲦⲎϪ ⲚⲦⲈⲦⲈⲚϤⲰϪⲒ ⲘⲠⲒⲔⲈⲤⲞⲨⲞ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ⲀⲖⲖⲀ ⲬⲀⲨ ⲘⲀⲢⲞⲨⲢⲰⲦ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎ ⲞⲨ ϢⲀ ⲠⲤⲎⲞⲨ ⲘⲠⲰⲤϦ ⲞⲨⲞϨ ϦⲈⲚⲠⲤⲎⲞⲨ ⲘⲠⲰⲤϦ ⲈⲒⲈϪⲞⲤ ⲚⲚⲒϬⲀⲒⲞⲤϦ ϪⲈ ⲤⲰⲔⲒ ⲚⲚⲒⲈⲚⲦⲎϪ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲘⲞⲢⲞⲨ ⲚϨⲀⲚⲘⲎⲒⲢⲒ ⲈⲠⲢⲞⲔϨⲞⲨ ϦⲈⲚⲠⲒⲬⲢⲰⲘ ⲠⲒⲤⲞⲨⲞ ⲆⲈ ⲐⲞⲨⲰⲦϤ ⲈϦⲞⲨⲚ ⲈⲦⲀⲀⲠⲞⲐⲎⲔⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ⲀϤⲬⲰ ϦⲀⲦⲞⲦⲞⲨ ⲚⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲚⲀⲪⲢⲒ ⲚϢⲈⲖⲦⲀⲘ ⲈⲀ ⲞⲨⲢⲰⲘⲒ ϬⲒⲦⲤ ⲀϤⲤⲀⲦⲤ ϦⲈⲚⲠⲈϤⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ⲈⲞⲨⲔⲞⲨϪⲒ ⲘⲈⲚ ⲦⲈ ⲈⲂⲞⲖ ⲞⲨⲦⲈ ⲚⲒϪⲢⲰϪ ⲦⲎⲢⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲀⲤϢⲀⲚⲀⲒⲀⲒ ⲤⲞⲒ ⲚⲚⲒϢϮ ⲈⲚⲒⲞⲨⲞϮ ⲞⲨⲞϨ ϢⲀⲤϢⲰⲠⲒ ⲈⲞⲨϢϢⲎⲚ ϨⲰⲤⲦⲈ ⲚⲤⲈⲒ ⲚϪⲈⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲚⲤⲈⲞⲨⲞϨ ⲈϪⲈⲚ ⲚⲈⲤϪⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨϢⲈⲘⲎⲢ ⲈⲀ ⲞⲨⲤϨⲒⲘⲒ ϬⲒⲦϤ ⲀⲤⲬⲞⲠϤ ϦⲈⲚⲄⲚϢⲒ ⲚⲚⲰⲒⲦ ϢⲀⲦⲈ ⲠⲒϢⲰϮ ⲦⲎⲢϤ ϬⲒϢⲈⲘⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲒⲎⲤⲞⲨⲤ ϪⲞⲦⲞⲨ ⲚⲚⲒⲘⲎ ϢϦⲈⲚ ϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲞⲨⲞϨ ⲬⲰⲢⲒⲤ ⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲚⲀⲞⲨⲰⲚ ⲚⲢⲰⲒ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲞⲨⲞϨ ⲚⲦⲀⲤⲀϪⲒ ⲚⲚⲎ ⲈⲦϨⲎⲠ ⲒⲤϪⲈⲚ ⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ⲦⲞⲦⲈ ⲀϤⲬⲀ ⲚⲒⲘⲎϢ ⲈⲂⲞⲖ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲈⲖ ϮⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲀⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒⲈⲚⲦⲎϪ ⲚⲦⲈⲠⲒⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲠⲈⲦⲤⲒϮ ⲘⲠⲒϪⲢⲞϪ ⲈⲐⲚⲀⲚⲈϤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ⲠⲒⲒⲞϨⲒ ⲆⲈ ⲠⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲠⲒϪⲢⲞϪ ⲈⲐⲚⲀⲚⲈϤ ⲚⲀⲒ ⲚⲈⲚⲒϢⲎⲢⲒ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲒⲈⲚⲦⲎ ϪⲆⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ⲠⲒϪⲀϪⲒ ⲆⲈ ⲈⲦⲀϤⲤⲀⲦⲞⲨ ⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲠⲈ ⲠⲒⲰⲤϦ ⲆⲈ ⲦϦⲀⲎ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲚⲒϬⲀⲒⲞⲤϦ ⲆⲈ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ⲘⲪⲢⲎϮ ⲞⲨⲚ ⲈϢⲀⲨⲤⲰⲔⲒ ⲚⲚⲒⲈⲚⲦⲎϪ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲚⲤⲈⲢⲞⲔϨⲞⲨ ϦⲈⲚⲠⲒⲬⲢⲰⲘ ⲠⲀⲒⲢⲎϮ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲦϦⲀⲎ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ⲈⲢⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲈⲦⲀⲞⲨⲞ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈⲤⲰⲔⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ ⲚⲚⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲦⲒⲢⲒ ⲚϮⲀⲚⲞⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ⲞⲨⲞϨ ⲈⲨⲈϨⲒⲦⲞⲨ ⲈϮϨⲢⲰ ⲚⲬⲢⲰⲘ ⲠⲒⲘⲀ ⲈⲦⲈ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ⲦⲞⲦⲈ ⲚⲒⲐⲘⲎⲒ ⲈⲨⲈⲢⲞⲨⲰⲒⲚⲒ ⲘⲪⲢⲎϮ ⲘⲪⲢⲎ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲠⲞⲨⲒⲰⲦ ⲪⲎ ⲈⲦⲈⲞⲨⲞⲚ ⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲀϨⲞ ⲈϤⲬⲎⲠ ϦⲈⲚⲞⲨⲒⲞϨⲒ ⲪⲎ ⲈⲦⲀ ⲞⲨⲢⲰⲘⲒ ϪⲈⲘϤ ⲀϤⲬⲞⲠϤ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲀϢⲒ ⲀϤϢⲈ ⲚⲀϤ ⲀϤϮ ⲘⲠⲈⲦⲈⲚⲦⲀϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤϢⲰⲠ ⲘⲠⲒⲞϨⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ⲠⲀⲖⲒⲚ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚϢⲰⲦ ⲈϤⲔⲰϮ ⲚⲤⲀϨⲀⲚⲀⲚⲀⲘⲎⲒ ⲈⲚⲀⲚⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ⲈⲦⲀϤϪⲒⲘⲒ ⲚⲞⲨⲀⲚⲀⲘⲎⲒ ⲈⲚⲀϢⲈ ⲚⲤⲞⲨⲈⲚϤ ⲀϤϢⲈ ⲚⲀϤ ⲀϤϮ ⲘⲠⲈⲦⲈⲚⲦⲀϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤϢⲞⲠϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ⲠⲀⲖⲒⲚ ⲞⲚ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲤⲀⲄⲎⲚⲎ ⲈⲀⲨϨⲒⲦⲤ ⲈⲪⲒⲞⲘ ⲞⲨⲞϨ ⲀⲤⲐⲰⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲄⲈⲚⲞⲤ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ⲐⲎ ⲈⲦⲀⲤⲘⲞϨ ⲀⲨⲤⲞⲔⲤ ⲈⲠⲒⲬⲢⲞ ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲈⲘⲤⲒ ⲀⲨⲤⲰⲔⲒ ⲚⲚⲎ ⲈⲐⲚⲀⲚⲈⲨ ⲈϨⲀⲚⲘⲞⲔⲒ ⲚⲎ ⲈⲦϨⲰⲞⲨ ⲆⲈ ⲀⲨϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲦϦⲀⲎ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲈⲨⲈⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈⲪⲰⲢϪ ⲚⲚⲒⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲐⲘⲎϮ ⲚⲚⲒⲤⲀⲘⲠⲈⲐⲚⲀⲚⲈⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ⲞⲨⲞϨ ⲈⲨⲈϨⲒⲦⲞⲨ ⲈϦⲢⲎⲒ ⲈϮϨⲢⲰ ⲚⲬⲢⲰⲘ ⲠⲒⲘⲀ ⲈⲦⲈ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲒⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ⲀⲦⲈⲦⲈⲚⲔⲀϮ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀϨⲀ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲪⲀⲒ ⲤⲀϦ ⲚⲒⲂⲈⲚ ⲈⲀϤϬⲒⲤⲂⲰ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ϤⲞⲚⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲚⲈⲂⲒⲞϨⲒ ⲪⲎ ⲈⲦϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲀϨⲞ ⲚϨⲀⲚⲂⲈⲢⲒ ⲚⲈⲘ ϨⲀⲚⲀⲠⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰⲔ ⲚⲚⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲂⲞⲖ ⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲦⲈϤⲂⲀⲔⲒ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ⲠⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ϨⲰⲤⲦⲈ ⲚⲤⲈⲈⲢϢⲪⲎⲢⲒ ⲞⲨⲞϨ ⲚⲤⲈϪⲞⲤ ϪⲈ ⲈⲦⲀ ⲪⲀⲒ ϪⲈⲘ ⲦⲀⲒⲤⲂⲰ ⲐⲰⲚ ⲚⲈⲘ ⲚⲀⲒϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ⲘⲎ ⲪⲀⲒ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲠⲒⲀⲘϢⲈ ⲘⲎ ⲦⲈϤⲘⲀⲨ ⲀⲚ ⲦⲈ ⲘⲀⲢⲒⲀⲘ ⲞⲨⲞϨ ⲚⲈϤⲤⲚⲎⲞⲨ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲤⲎ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ⲞⲨⲞϨ ⲚⲈϤⲤⲰⲚⲒ ⲚⲤϨⲒⲘⲒ ⲘⲎ ⲤⲈⲬⲎ ϨⲀⲢⲞⲚ ⲦⲎⲢⲞⲨ ⲀⲚ ⲈⲦⲀ ⲪⲀⲒ ⲞⲨⲚ ϪⲈⲘ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϢⲎϢ ϦⲈⲚϨⲖⲒ ⲘⲘⲀ ⲈⲂⲎⲖ ϦⲈⲚⲦⲈϤⲂⲀⲔⲒ ⲚⲈⲘ ⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ⲞⲨⲞϨ ⲘⲠⲈϤⲈⲢ ⲞⲨⲘⲎϢ ⲚϪⲞⲘ ⲘⲘⲀⲨ ⲈⲐⲂⲈ ⲦⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲤⲰⲦⲈⲘ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲠⲒⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈⲦⲤⲘⲎ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲀⲖⲰⲞⲨⲒ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲚⲐⲞϤ ⲄⲀⲢ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲒϪⲞⲘ ⲤⲈⲈⲢϨⲰⲂ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲚⲈⲀϤⲀⲘⲞⲚⲒ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲀϤⲤⲞⲚϨϤ ⲀϤⲬⲀϤ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲈⲐⲂⲈ ⲎⲢⲰⲆⲒⲀⲤ ⲦⲤϨⲒⲘⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ⲠⲈ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲤϢⲈ ⲚⲀⲔ ⲀⲚ ⲈϬⲒⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ⲞⲨⲞϨ ⲈϤⲞⲨⲰϢ ⲈϦⲞⲐⲂⲈϤ ⲀϤⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲘⲎϢ ϪⲈ ⲚⲀϤⲬⲎ ⲚⲦⲞⲦⲞⲨ ϨⲰⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ⲈⲦⲀ ⲞⲨⲈϨⲞⲞⲨ ⲘⲘⲒⲤⲒ ⲆⲈ ϢⲰⲠⲒ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ ⲀⲤϬⲞⲤϪⲈⲤ ⲚϪⲈⲦϢⲈⲢⲒ ⲚⲎⲢⲰⲆⲒⲀⲤ ϦⲈⲚⲐⲘⲎϮ ⲞⲨⲞϨ ⲀⲤⲢⲀⲚⲀϤ ⲚⲎⲢⲰⲆⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ϦⲈⲚ ⲪⲀⲒ ⲀϤⲈⲢⲀⲚⲀϢ ⲈϤⲈⲢⲞⲘⲞⲖⲞⲄⲒⲚ ⲈϮ ⲚⲀⲤ ⲘⲪⲎ ⲈⲦⲈⲤⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ⲚⲐⲞⲤ ⲆⲈ ⲀⲦⲈⲤⲘⲀⲨ ⲦⲤⲀⲂⲞⲤ ⲠⲈϪⲀⲤ ϪⲈ ⲘⲀ ⲦⲀⲪⲈ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲚⲎⲒ ⲠⲒⲢⲈϤϮⲰⲘⲤ ϨⲒ ⲞⲨⲂⲒⲚⲀϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ⲞⲨⲞϨ ⲀⲠϨⲎⲦ ⲘⲠⲞⲨⲢⲞ ⲘⲔⲀϨ ⲈⲐⲂⲈ ⲚⲒⲀⲚⲀⲨϢ ⲆⲈ ⲚⲈⲘ ⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲚⲈⲘⲀϤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲦⲎⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲀϤⲰⲖⲒ ⲚⲦⲀⲪⲈ ⲚⲒⲰⲀⲚⲚⲎ ⲤϦⲈⲚ ⲠⲒϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ⲞⲨⲞϨ ⲀⲨⲈⲚⲤ ϨⲒ ⲠⲒⲂⲒⲚⲀϪ ⲀⲨⲦⲎⲒⲤ ⲚϮⲀⲖⲞⲨ ⲞⲨⲞϨ ⲀϮⲀⲖⲞⲨ ⲦⲎⲒⲤ ⲚⲦⲈⲤⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲖ ϮϢⲞⲖϨⲤ ⲀⲨⲐⲞⲘⲤⲤ ⲞⲨⲞϨ ⲀⲨⲒ ⲀⲨⲦⲀⲘⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ϨⲒ ⲞⲨϪⲞⲒ ⲈⲞⲨⲘⲀⲚϢⲀϤⲈ ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲒⲘⲎϢ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲀⲨⲘⲞϢⲒ ⲚⲢⲀⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤⲚⲀⲨ ⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲞⲨⲞϨ ⲀϤϢⲈⲚϨⲎⲦ ϦⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲘⲀ ⲞⲨϢⲀϤⲈ ⲠⲈ ⲞⲨⲞϨ ⲠⲒⲚⲀⲨ ⲀϤⲤⲒⲚⲒ ⲬⲀ ⲠⲒⲘⲎ ϢⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲤⲈϢⲈ ⲚⲰⲞⲨ ⲈⲚⲒϮⲘⲒ ⲚⲤⲈϢⲰⲠ ⲚϨⲀⲚϦⲢⲎⲞⲨⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲤⲈⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲚⲦⲞⲨϢⲈ ⲚⲰⲞⲨ ⲘⲞⲒ ⲚⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲘⲀⲢⲞⲨⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲘⲞⲚ ⲚⲦⲀⲚ ⲘⲠⲀⲒⲘⲀ ⲈⲂⲎⲖ ⲈⲈ ⲚⲰⲒⲔ ⲚⲈⲘ ⲦⲈⲂⲦ Ⲃ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲒⲦⲞⲨ ⲚⲎⲒ ⲘⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲈ ⲚⲒⲘⲎϢ ⲢⲰⲦⲈⲂ ϨⲒϪⲈⲚ ⲠⲒⲤⲒⲘ ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲈ ⲚⲰⲒⲔ ⲚⲈⲘ ⲠⲒⲦⲈⲂⲦ ⲂⲀϤϪⲞⲨϢⲦ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϤⲪⲀϢⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲒⲰⲒⲔ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϮ ⲚⲚⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲘ ⲦⲎⲢⲞⲨ ⲀⲨⲤⲒ ⲞⲨⲞϨ ⲀⲨⲈⲖ ⲠϨⲞⲨⲞ ⲚⲚⲒⲖⲀⲔϨ ⲀⲨⲘⲀϨ ⲒⲂ ⲚⲔⲞⲦ ⲈⲨⲘⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ⲚⲎ ⲆⲈ ⲈⲦⲀⲨⲞⲨⲰⲘ ⲚⲀⲨⲈⲢ ⲈⲚϢⲞ ⲚⲢⲰⲘⲒ ⲬⲰⲢⲒⲤ ⲀⲖⲞⲨ ⲚⲈⲘ ⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲈⲢⲀⲚⲀⲄⲔⲀⲌⲒⲚ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲀⲖⲎⲒ ⲈⲠϪⲞⲒ ⲞⲨⲞϨ ⲈⲤⲰⲔ ϦⲀϪⲰϤ ⲈⲘⲎⲢ ϢⲀⲦⲈϤⲬⲀ ⲠⲒⲘⲎϢ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀ ⲚⲒⲘⲎϢ ⲈⲂⲞⲖ ⲀϤϢⲈ ⲚⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲞⲨⲦⲰⲞⲨ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦϤ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲚⲐⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲈⲚⲀϤⲬⲎ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ⲠⲒϪⲞⲒ ⲆⲈ ⲀϤⲞⲨⲈⲒ ⲈⲂⲞⲖ ⲘⲠⲒⲔⲀϨⲒ ⲚⲀⲨ ⲔⲈ ⲚⲤⲦⲀⲆⲒⲞⲚ ⲈⲨϮⲞⲨⲂⲎϤ ⲚϪⲈⲚⲒϪⲞⲖ ⲚⲀⲢⲈ ⲠⲒⲐⲎⲞⲨ ⲄⲀⲢ ϮⲞⲨⲂⲎϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ϦⲈⲚ ϮⲘⲀϨⲆ ⲆⲈ ⲚⲞⲨⲈⲢϢⲒ ⲚⲦⲈⲠⲒⲈϪⲰⲢϨ ⲀϤⲒ ϨⲀⲢⲰⲞⲨ ⲈϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ ⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨϨⲞⲢⲦϤ ⲠⲈ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϦⲈⲚϮϨⲞϮ ⲀⲨⲰϢ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ⲤⲀⲦⲞⲦϤ ⲆⲈ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲀⲚⲞⲔ ⲠⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲎⲒ ⲚⲦⲀⲒ ϨⲀⲢⲞⲔ ϨⲒϪⲈⲚ ⲚⲒⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒ ⲠⲒϪⲞⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲚⲒⲘⲰⲞⲨ ⲈⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ⲀϤⲚⲀⲨ ⲆⲈ ⲈⲠⲒⲐⲎⲞⲨ ⲀϤⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢϨⲎⲦⲤ ⲚⲰⲘⲤ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲀϨⲘⲈⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ⲤⲀⲦⲞⲦϤ ⲆⲈ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲀ ⲠⲒⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ ⲈⲐⲂⲈⲞⲨ ⲀⲔⲈⲢϨⲎ Ⲧ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲀϤϨⲈⲢⲒ ⲚϪⲈⲠⲒⲐⲎⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ⲚⲎ ⲆⲈ ⲈⲚⲀⲨϨⲒ ⲠⲒϪⲞⲒ ⲀⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀⲪⲘⲎⲒ ⲚⲐⲞⲔ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢϪⲒⲚⲒⲞⲢ ⲈⲘⲎⲢ ⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲠⲔⲀϨⲒ ⲚⲄⲈⲚⲚⲎⲤⲀⲢⲈⲐ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲞⲨⲰⲚϤ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲚⲦⲈⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲞⲨⲰⲢⲠ ⲈⲂⲞⲖ ϦⲈⲚϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲦϨⲈⲘⲔⲎⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ϨⲒⲚⲀ ⲘⲞⲚⲞⲚ ⲚⲤⲈϬⲒ ⲚⲈⲘ ⲠϢⲦⲀϮ ⲚⲦⲈⲚⲈϤϨⲂⲰⲤ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϬⲒ ⲀⲨⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ⲦⲞⲦⲈ ⲀⲨⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚϪⲈϨⲀⲚⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ϨⲀⲚⲤⲀϦ ⲈⲨϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲤⲈⲈⲢⲠⲀⲢⲀⲂⲈⲚⲒⲚ ⲚⲚⲒⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲤⲈⲒⲰⲒ ⲄⲀⲢ ⲚⲚⲞⲨϪⲒϪ ⲈⲂⲞⲖ ⲀⲚ ⲈⲨⲚⲀⲞⲨⲈⲘ ⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲈⲢⲠⲀⲢⲀⲂⲈⲚⲒⲚ ⲚϮⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲐⲂⲈ ⲦⲈⲦⲈⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲀϤϪⲞⲤ ϪⲈ ⲘⲀⲦⲀⲒⲈ ⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲦⲈⲔⲘⲀⲨ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϪⲈ ⲞⲨⲤⲀϪⲒ ⲈϤϨⲰⲞⲨ ⲚⲤⲀⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲈϤⲈⲘⲞⲨ ⲘⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϪⲞⲤ ⲘⲠⲈϤⲒⲰⲦ ⲒⲈ ⲦⲈϤⲘⲀⲨ ϪⲈ ⲞⲨⲦⲀⲒⲞ ⲬⲚⲀϪⲈⲘϨⲎⲞⲨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ⲚⲚⲈϤⲦⲀⲒⲈ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲔⲈⲢϤ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲐⲂⲈ ⲚⲈⲦⲈⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ⲚⲒϢⲞⲂⲒ ⲔⲀⲖⲰⲤ ⲀϤⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ϦⲀⲢⲰⲦⲈⲚ ⲚϪⲈⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ϪⲈ ⲠⲀⲒⲖⲀⲞⲤ ⲈⲢⲦⲒⲘⲀⲚ ⲘⲘⲞⲒ ϦⲈⲚⲚⲞⲨⲤⲪⲞⲦⲞⲨ ⲠⲞⲨϨⲎⲦ ⲆⲈ ⲞⲨⲎⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ⲈⲨⲈⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲘⲞⲒ ⲈⲪⲖⲎⲞⲨ ⲈⲨϮⲤⲂⲰ ⲚϨⲀⲚⲤⲂⲰ ⲚϨⲞⲚϨⲈⲚ ⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲠⲒⲘⲎϢ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ⲠⲈⲐⲚⲀ ⲈϦⲞⲨⲚ ⲈⲢⲰϤ ⲘⲠⲒⲢⲰⲘⲒ ⲀⲚ ⲠⲈⲦⲤⲰϤ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲠⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲪⲀⲒ ⲠⲈⲦⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ⲦⲞⲦⲈ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲔⲈⲘⲒ ϪⲈ ⲈⲦⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲤⲰⲦⲈⲘ ⲈⲠⲀⲒⲤⲀϪⲒ ⲀⲨⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ϢϢⲎ ⲚⲚⲒⲂⲈⲚ ⲈⲦⲈⲘⲠⲈ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ϬⲰⲞⲨ ⲤⲈⲚⲀⲔⲞⲢϪⲞⲨ ⲚⲈⲘ ⲦⲞⲨⲚⲞⲨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ⲬⲀⲨ ϨⲀⲚϬⲀⲨⲘⲰⲒⲦ ⲘⲂⲈⲖⲖⲈ ⲚⲈⲞⲨⲂⲈⲖⲖⲈ ⲄⲀⲢ ⲈϤϬⲒⲘⲰⲒⲦ ϦⲀϪⲰϤ ⲚⲞⲨⲂⲈⲖⲖⲈ ϢⲀⲨϨⲈⲒ ⲈⲞⲨϢⲒⲔ ⲘⲠⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲂⲈⲖ ϮⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲀⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲔⲘⲎⲚ ϨⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲀⲦⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ⲘⲠⲀⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈϢⲀⲨϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰϤ ⲘⲠⲒⲢⲰⲘⲒ ϢⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϮⲚⲈϪⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϨⲒⲦⲞⲨ ⲈⲚⲒⲘⲀⲚϨⲈⲘⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ⲚⲎ ⲆⲈ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϨⲎⲦ ⲚⲀⲒ ⲠⲈⲦⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ⲈϢⲀⲨⲒ ⲄⲀⲢ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϨⲎⲦ ⲚϪⲈⲚⲒⲘⲞⲔⲘⲈⲔ ⲈⲦϨⲰⲞⲨ ⲚⲒϦⲰⲦⲈⲂ ⲚⲒⲘⲈⲦⲚⲰⲒⲔ ⲚⲒⲠⲞⲢⲚⲒⲀ ⲚⲒϬⲒⲞⲨⲒ ⲚⲒⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ⲚⲒϪⲈⲞⲨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ⲚⲀⲒ ⲠⲈⲦⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ ⲠⲒⲞⲨⲰⲘ ⲆⲈ ⲚⲞⲨⲈϢⲈ ⲚⲒⲀ ⲦⲞⲦⲔ ⲚϤⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲚⲒⲤⲀ ⲚⲦⲈⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲤϨⲒⲘⲒ ⲚⲬⲀⲚⲀⲚⲈⲀ ⲀⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒϬⲒⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲤⲰϢ ⲈⲂⲞⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒ ϦⲀⲢⲞⲒ ⲠⲀϬⲞⲒⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲦⲀϢⲈⲢⲒ ⲈⲦⲦϨⲈⲘⲔⲎⲞⲨⲦ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲚⲀⲤ ⲚⲞⲨⲤⲀϪⲒ ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀ ⲦⲀⲒⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ϪⲈ ⲤⲰϢ ⲈⲂⲞⲖ ⲤⲀⲘⲈⲚϨⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲞⲨⲦⲀⲞⲨⲞⲒ ϨⲀ ϨⲖⲒ ⲈⲂⲎⲖ ⲈⲚⲒⲈⲤⲰⲞⲨ ⲈⲦⲤⲞⲢⲈⲘ ⲚⲦⲈⲠⲎⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ⲚⲐⲞⲤ ⲆⲈ ⲀⲤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲢⲒⲂⲞⲎⲐⲒⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲚⲈⲤ ⲀⲚ ⲈⲈⲖ ⲠⲰⲒⲔ ⲚⲚⲒϢⲎⲢⲒ ⲈⲦⲎⲒϤ ⲚⲚⲒⲞⲨϨⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ⲚⲐⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲤⲈ ⲠⲀϬⲞⲒⲤ ⲔⲈ ⲄⲀⲢ ϢⲀⲢⲈ ⲚⲒⲔⲈⲞⲨϨⲰⲢ ⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲖⲈϤⲖⲒϤⲒ ⲚⲎ ⲈϢⲀⲨϨⲈⲒ ⲈⲂⲞⲖ ϨⲒ ϮⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲚⲞⲨϬⲒⲤⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ⲦⲞⲦⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲰϮⲤϨⲒⲘⲒ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲠⲈⲚⲀϨϮ ⲈϤⲈϢⲰⲠⲒ ⲚⲈⲘⲪⲢⲎϮ ⲈⲦⲈⲞⲨⲀϢϤ ⲞⲨⲞϨ ⲀⲤⲞⲨϪⲀⲒ ⲚϪⲈⲦⲈⲤϢⲈⲢⲒ ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲒ ⲈⲤⲔⲈⲚ ⲪⲒⲞⲘ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϪⲈⲚ ⲞⲨⲦⲰⲞⲨ ⲚⲀϤϨⲈⲘⲤⲒ ⲘⲘⲀⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲈⲞⲨⲞⲚ ϨⲀⲚϬⲀⲖⲈⲨ ⲚⲈⲘⲰⲞⲨ ⲚⲈⲘ ϨⲀⲚⲂⲈⲖⲖⲈⲨ ⲚⲈⲘ ϨⲀⲚⲔⲞⲨⲢ ⲚⲈⲘ ϨⲀⲚϪⲀϬ ⲈⲨ ⲚⲈⲘ ϨⲀⲚⲔⲈⲘⲎϢ ⲀⲨϨⲒⲦⲞⲨ ⲈϦⲢⲎⲒ ϦⲀ ⲚⲈϤϬⲀⲖⲀⲨϪ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ϨⲰⲤⲦⲈ ⲚⲦⲈⲚⲒⲘⲎϢ ⲈⲢϢⲪⲎⲢⲒ ⲈⲨⲚⲀⲨ ⲈⲚⲒⲈⲂⲰⲞⲨ ⲈⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒϬⲀⲖⲈⲨ ⲈⲨⲘⲞϢⲒ ⲚⲈⲘ ⲚⲒⲂⲈⲖⲖⲈⲨ ⲈⲨⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲈⲘ ⲚⲒⲔⲞⲨⲢ ⲈⲨⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲘⲞⲨϮ ⲞⲨⲂⲈ ⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮϢⲈⲚϨⲎⲦ ϦⲀ ⲠⲀⲒⲘⲎϢ ϪⲈ ⲒⲤ ⲄⲚⲈϨⲞⲞⲨ ⲤⲈⲬⲎ ⲘⲠⲀⲒⲘⲀ ⲚⲈⲘⲎⲒ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲪⲎ ⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ⲞⲨⲞϨ ϮⲞⲨⲰϢ ⲀⲚ ⲈⲬⲀⲨ ⲈⲂⲞⲖ ⲚⲞⲨⲈϢⲈ ⲚⲞⲨⲰⲘ ϪⲈ ⲚⲚⲞⲨⲂⲰⲖ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ⲠⲈϪⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲚⲚⲀϪⲈⲘ ⲦⲀⲒⲎⲠⲒ ⲚⲰⲒⲔ ⲐⲰⲚ ϨⲒ ⲠⲀⲒⲘⲀⲚϢⲀϤⲈ ϨⲰⲤⲦⲈ ⲈⲦⲤⲒ ⲈⲠⲀⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚⲦⲈⲦⲈⲚ ⲞⲨⲎⲢ ⲚⲰⲒⲔ ⲘⲘⲀⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲌⲚⲈⲘ ϨⲀⲚⲔⲞⲨϪⲒ ⲚⲦⲈⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲦⲈⲚ ⲚⲒⲘⲎϢ ⲈⲐⲢⲞⲨⲢⲰⲦⲈⲂ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ⲀϤϬⲒ ⲘⲠⲒⲌ ⲚⲰⲒⲔ ⲚⲈⲘ ⲚⲒⲦⲈⲂⲦ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲀϤⲪⲀϢⲞⲨ ⲞⲨⲞϨ ⲀϤⲦⲎ ⲒⲦⲞⲨ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨϮ ⲚⲚⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲘ ⲦⲎⲢⲞⲨ ⲀⲨⲤⲒ ⲞⲨⲞϨ ⲀⲨⲈⲖ ⲠϨⲞⲨⲞ ⲚⲚⲒⲖⲀⲔϨ ⲀⲨⲘⲀϨ ⲌⲘⲂⲒⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ⲚⲎ ⲆⲈ ⲈⲚⲀⲨⲞⲨⲰⲘ ⲚⲀⲨⲈⲢ ⲆⲚϢⲞ ⲚⲢⲰⲘⲒ ⲬⲰⲢⲒⲤ ⲀⲖⲞⲨ ⲚⲈⲘ ⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀ ⲠⲒⲘⲎϢ ⲈⲂⲞⲖ ⲀϤⲀⲖⲎ ⲒⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲚⲒϬⲒⲎ ⲚⲦⲈⲘⲀⲄⲆⲀⲖⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲈⲦⲀⲘⲰⲞⲨ ⲈⲞⲨⲘⲎⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲚϪⲈϨⲀⲚⲀⲢⲞⲨϨⲒ ⲦⲈⲦⲈⲚϪⲞⲤ ϪⲈ ⲦⲪⲈ ⲞⲨϪⲀⲘⲎ ⲈⲤⲐⲢⲞϢⲢⲈϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ⲞⲨⲞϨ ϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲦⲈⲦⲈⲚϪⲞⲤ ϪⲈ ⲪⲞⲞⲨ ⲦⲪⲢⲰ ⲈⲐⲂⲈ ⲠⲒⲐⲢⲞϢⲢⲈϢ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲈⲤⲄⲚⲞⲪⲞⲤ ⲚⲒϢⲞⲂⲒ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲚⲤⲞⲘⲤ ⲈⲦⲪⲈ ⲞⲨⲞϨ ⲦϨⲒⲢⲎⲚⲎ ⲘⲠⲀⲒⲤⲎⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ϪⲈ ⲠⲒϪⲰⲞⲨ ⲈⲦϨⲰⲞⲨ ⲞⲨⲞϨ ⲚⲚⲰⲒⲔ ϤⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎⲒⲚⲒ ⲞⲨⲞϨ ⲞⲨⲘⲎⲒⲚⲒ ⲚⲚⲞⲨⲦⲎ ⲒϤ ⲚⲀϤ ⲈⲂⲎⲖ ⲈⲠⲒⲘⲎⲒⲚⲒ ⲚⲦⲈⲒⲰⲚⲀ ⲠⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀⲨ ⲀϤϢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲘⲎⲢ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲢⲠⲰⲂϢ ⲈϢⲈⲠ ⲰⲒⲔ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲀⲨ ⲞⲨⲞϨ ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲠϢⲈⲘⲎⲢ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲚϬⲒ ⲰⲒⲔ ⲚⲈⲘⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ⲈⲦⲀϤⲈⲘⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲀ ⲠⲒⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ ϪⲈ ⲘⲘⲞⲚⲦⲈⲦⲈⲚ ⲰⲒⲔ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ⲘⲠⲀⲦⲈⲦⲈⲚⲈⲘⲒ ⲞⲨⲆⲈ ⲦⲈⲦⲈⲚⲈⲢⲪⲘⲈⲨⲒ ⲀⲚ ⲈⲠⲒⲈ ⲚⲰⲒⲔ ⲚⲦⲈⲠⲒⲈ ⲚϢⲞ ϪⲈ ⲀⲦⲈⲦⲈⲚϬⲒ ⲞⲨⲎⲢ ⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ⲞⲨⲆⲈ ⲠⲒⲌ ⲚⲰⲒⲔ ⲚⲦⲈⲠⲒⲆ ⲚϢⲞ ϪⲈ ⲀⲦⲈⲦⲈⲚϬⲒ ⲞⲨⲎⲢ ⲘⲂⲒⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ⲠⲰⲤ ⲦⲈⲦⲈⲚⲔⲀϮ ⲀⲚ ϪⲈ ⲚⲀⲒϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲚ ⲈⲐⲂⲈ ⲰⲒⲔ ⲀⲢⲈϨ ⲆⲈ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲠϢⲈⲘⲎⲢ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ⲦⲞⲦⲈ ⲀⲨⲔⲀϮ ϪⲈ ⲚⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲀⲚ ϪⲈ ⲀⲢⲈϨ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲠϢⲈⲘⲎⲢ ⲚⲦⲈⲚⲒⲰⲒⲔ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲀ ϮⲤⲂⲰ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ⲈⲦⲀϤⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲒⲤⲀ ⲚⲦⲈⲔⲈⲤⲀⲢⲒⲀ ⲚⲦⲈⲪⲒⲖⲒⲠⲠⲈ ⲚⲀϤϢⲒⲚⲒ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ϪⲈ ⲀⲢⲈ ⲚⲒⲢⲰⲘⲒ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲎⲖⲒⲀⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲒⲈⲢⲈⲘⲒⲀⲤ ⲒⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲈⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲰⲞⲨⲚⲒⲀⲦⲔ ⲤⲒⲘⲰⲚ ⲂⲀⲢⲒⲰⲚⲀ ϪⲈ ⲤⲀⲢⲜ ⲚⲈⲘ ⲤⲚⲞϤ ⲀⲚ ⲀϤϬⲰⲢⲠ ⲘⲪⲀⲒ ⲚⲀⲔ ⲈⲂⲞⲖ ⲀⲖⲖⲀ ⲠⲀⲒⲰⲦ ⲠⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ⲀⲚⲞⲔ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲈⲦⲢⲞⲤ ⲈⲒⲈⲔⲰⲦ ⲚⲦⲀⲈⲔⲔⲖⲎⲤⲒⲀ ϨⲒϪⲈⲚ ⲦⲀⲒⲠⲈⲦⲢⲀ ⲞⲨⲞϨ ⲚⲒⲠⲨⲖⲎ ⲚⲦⲈⲀⲘⲈⲚϮ ⲚⲚⲞⲨϢϪⲈⲘϪⲞⲘ ⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ⲈⲒⲈϮ ⲚⲀⲔ ⲚⲚⲒϢⲰϢⲦ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲪⲎ ⲈⲦⲈⲔⲚⲀⲤⲞⲚϨϤ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲤⲞⲚϨ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲔⲚⲀⲂⲞⲖϤ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲂⲎⲖ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ⲦⲞⲦⲈ ⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲈⲚ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘϪⲞⲤ ⲚϨⲖⲒ ϪⲈ ⲚⲐⲞϤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ⲒⲤϪⲈⲚ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲀⲘⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲰϮ ⲈⲢⲞϤ ⲚⲦⲈϤϢⲈ ⲚⲀϤ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲚⲦⲈϤϬⲒ ⲚⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲚⲤⲈϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ Ⲅ- ⲚⲈϨⲞⲞⲨ ⲚⲦⲈϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ⲞⲨⲞϨ ⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲖⲈⲰⲤ ⲚⲀⲔ ⲠⲀϬⲞⲒⲤ ⲚⲚⲈ ⲪⲀⲒ ϢⲰⲠⲒ ⲘⲘⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲤⲀⲘⲈⲚϨⲎⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲎⲒ ϪⲈ ⲬⲘⲈⲨⲒ ⲀⲚ ⲈⲚⲀ ⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲚⲀ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲘⲞϢⲒ ⲚⲤⲰⲒ ⲘⲀⲢⲈϤϪⲞⲖϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲀⲢⲈϤⲰⲖⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈϤⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ⲪⲎ ⲄⲀⲢ ⲈⲐⲞⲨⲰϢ ⲈⲚⲞϨⲈⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϤⲈⲦⲀⲔⲞⲤ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲐⲂⲎⲦ ⲈϤⲈϪⲈⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ⲞⲨ ⲄⲀⲢ ⲈⲦⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀϪⲈⲘϨⲎⲞⲨ ⲘⲘⲞϤ ⲀϤϢⲀⲚϪⲈⲘϨⲎⲞⲨ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲦⲈϤⲮⲨⲬⲎ ⲆⲈ ⲚⲦⲈϤϮⲞⲤⲒ ⲘⲘⲞⲤ ⲘⲘⲞⲚ ⲞⲨ ⲠⲈⲦⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀⲦⲎⲒϤ ⲚⲦϢⲈⲂⲒⲰ ⲚⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ⲠϢⲎⲢⲒ ⲄⲀⲢ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲎⲞⲨ ϦⲈⲚⲠⲰⲞⲨ ⲚⲦⲈⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲦⲞⲦⲈ ⲈϤⲚⲀϮ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲚⲈϤϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ϦⲈⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲚⲤⲈⲚⲀϪⲈⲘϮⲠⲒ ⲘⲪⲘⲞⲨ ⲀⲚ ϢⲀⲦⲞⲨⲚⲀⲨ ⲈⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲎⲞⲨ ϦⲈⲚⲠⲰⲞⲨ ⲚⲦⲈⲠⲈϤⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲈϨⲞⲞⲨ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲖ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ⲀϤϬⲒⲦⲞⲨ ⲈϪⲈⲚ ⲞⲨⲦⲰⲞⲨ ⲈϤϬⲞⲤⲒ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ⲞⲨⲞϨ ⲀϤϢⲞⲂⲦϤ ⲚϦⲈⲢⲈⲂ ⲘⲠⲞⲨⲘⲐⲞ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀⲠⲈϤϨⲞ ⲈⲢⲞⲨⲰⲒⲚⲒ ⲘⲪⲢⲎϮ ⲘⲪⲢⲎ ⲚⲈϤϨⲂⲰⲤ ⲆⲈ ⲀⲨⲞⲨⲂⲀϢ ⲘⲪⲢⲎϮ ⲘⲠⲒⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲢⲰⲞⲨ ⲚϪⲈⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲎⲖⲒⲀⲤ ⲈⲨⲤⲀϪⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲚⲀⲚⲈⲤ ⲚⲀⲚ ⲚⲦⲈⲚϢⲰⲠⲒ ⲘⲠⲀⲒⲘⲀ ⲬⲞⲨⲰϢ ⲚⲦⲈⲚⲐⲀⲘⲒⲞ ⲚⲄ ⲚⲤⲔⲎⲚⲎ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲒ ⲚⲀⲔ ⲚⲈⲘ ⲞⲨⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲞⲨⲒ ⲚⲎⲖⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ϨⲞⲦⲈ ⲈϤⲤⲀϪⲒ ⲒⲤ ⲞⲨϬⲎⲠⲒ ⲚⲞⲨⲰⲒⲚⲒ ⲀⲤⲈⲢϦⲎⲒⲂⲒ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲤⲘⲎ ⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚϮϬⲎⲠⲒ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲠⲀⲘⲈⲚⲢⲒⲦ ⲪⲎ ⲈⲦⲀ ⲦⲀⲮⲨⲬⲎ ϮⲘⲀϮ ⲚϦⲎⲦϤ ⲤⲰⲦⲈⲘ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϨⲈⲒ ⲈϪⲈⲚ ⲠⲞⲨϨⲞ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ⲞⲨⲞϨ ⲀϤⲒ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϬⲒ ⲚⲈⲘⲰⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲠⲈⲢⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ⲈⲦⲀⲨϤⲀⲒ ⲆⲈ ⲚⲚⲞⲨⲂⲀⲖ ⲈⲠϢⲰⲒ ⲘⲠⲞⲨⲚⲀⲨ ⲈϨⲖⲒ ⲈⲂⲎⲖ ⲈⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ⲞⲨⲞϨ ⲈⲨⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲦⲀⲘⲈ ϨⲖⲒ ⲈⲠⲒϨⲞⲢⲀⲘⲀ ϢⲀⲦⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲒⲤⲀϦ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲎⲖⲒⲀⲤ ⲠⲈⲐⲚⲎⲞⲨ ⲚϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲎⲖⲒⲀⲤ ⲘⲈⲚ ⲈϤⲚⲎⲞⲨ ⲞⲨⲞϨ ϤⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲎⲖⲒⲀⲤ ϨⲎⲆⲎ ⲀϤⲒ ⲞⲨⲞϨ ⲘⲠⲞⲨⲤⲞⲨⲰⲚϤ ⲀⲖⲖⲀ ⲀⲨⲒⲢⲒ ⲚⲀϤ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈϨⲚⲰⲞⲨ ⲠⲀⲒⲢⲎϮ ϨⲰϤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϤⲚⲀϢⲈⲠ ⲘⲔⲀϨ ⲚⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ⲦⲞⲦⲈ ⲀⲨⲔⲀϮ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲈⲐⲂⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ϨⲀ ⲠⲒⲘⲎϢ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈϤϨⲒ ⲘⲘⲞϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ");
INSERT INTO copbhc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ⲞⲨⲞϨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒ ϦⲀ ⲠⲀϢⲎ ⲢⲒ ϪⲈ ϤⲞⲒ ⲘⲠⲈⲢⲘⲞⲨ ⲞⲨⲞϨ ϤⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ⲈⲘⲀϢⲰ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚⲤⲞⲠ ϢⲀϤϨⲈⲒ ⲈⲠⲒⲬⲢⲰⲘ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ϢⲀϤϨⲈⲒ ⲈⲪⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ⲞⲨⲞϨ ⲀⲒⲈⲚϤ ⲈⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ⲦⲞⲦⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲰⲠⲒϪⲰⲞⲨ ⲚⲀⲐⲚⲀϨϮ ⲞⲨⲞϨ ⲈⲦⲪⲞⲚϨ ϢⲀ ⲐⲚⲀⲨ ϮⲚⲀϢⲰⲠⲒ ⲚⲈⲘⲰⲦⲈⲚ ϢⲀ ⲐⲚⲀⲨ ϮⲚⲀⲰⲞⲨⲚϨⲎⲦ ⲚⲈⲘⲰⲦⲈⲚ ⲀⲚⲒⲦϤ ⲚⲎⲒ ⲈⲘⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲚϪⲈⲠⲒⲒϦ ⲞⲨⲞϨ ⲀϤⲞⲨϪⲀⲒ ⲚϪⲈⲠⲒⲀⲖⲞⲨ ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ⲦⲞⲦⲈ ⲀⲨⲒ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲚⲞⲚ ⲘⲠⲈⲚϢϪⲈⲘϪⲞⲘ ⲚϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈ ⲠⲈⲦⲈⲚⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚⲦⲈⲦⲈⲚ ⲚⲀϨϮ ⲘⲘⲀⲨ ⲘⲪⲢⲎϮ ⲚⲞⲨⲚⲀⲪⲢⲒ ⲚϢⲈⲖⲦⲀⲘ ⲈⲢⲈⲦⲈⲚⲈϪⲞⲤ ⲘⲠⲀⲒⲦⲰⲞⲨ ϪⲈ ⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲦⲀⲒ ⲈⲘⲚⲎ ⲞⲨⲞϨ ⲈϤⲈⲞⲨⲰⲦⲈⲂ ⲞⲨⲞϨ ⲚⲚⲈ ϨⲖⲒ ⲈⲢⲀⲦϪⲞⲘ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ⲞⲨⲞϨ ⲠⲀⲒⲄⲈⲚⲞⲤ ⲘⲠⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚϨⲖⲒ ⲈⲂⲎⲖ ⲚⲞⲨⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲈⲘ ⲞⲨⲚⲎⲤⲦⲒⲀ ");
INSERT INTO copbhc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ⲈⲦⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲈϨⲢⲎⲒ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎ ⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ⲞⲨⲞϨ ⲤⲈⲚⲀϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ⲈϤⲈⲦⲰⲚϤ ⲞⲨⲞϨ ⲀⲠⲞⲨϨⲎⲦ ⲘⲔⲀϨ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲰⲘ ⲀⲨⲒ ⲚϪⲈⲚⲎ ⲈⲦϬⲒⲔⲒϮ ϨⲀ ⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠⲈⲦⲈⲚⲢⲈϤϮⲤⲂⲰ ϤϮⲔⲒϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ⲠⲈϪⲀϤ ϪⲈ ⲤⲈ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲀⲒⲎⲤⲞⲨⲤ ⲈⲢϢⲞⲢⲠ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲘⲈⲨⲒ ⲈⲢⲞϤ ⲤⲒⲘⲰⲚ ⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲦⲈⲠⲔⲀϨⲒ ⲈⲨϬⲒⲦⲈⲖⲞⲤ ⲚⲦⲈⲚⲒⲘ ⲒⲈ ⲔⲎⲚⲤⲞⲤ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒϢⲎⲢⲒ ϢⲀⲚ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒϢⲈⲘⲘⲰⲞⲨ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒϢⲈⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ⲈⲦⲀϤϪⲞⲤ ⲆⲈ ϪⲈ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒϢⲈⲘⲘⲰⲞⲨ ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲀⲢⲀ ⲚⲒϢⲎⲢⲒ ϨⲀⲚⲢⲈⲘϨⲈⲨ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲰⲞⲨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲪⲒⲞⲘ ϨⲒⲞⲨⲒ ⲚⲦⲈⲔⲰⲒⲘⲒ ⲞⲨⲞϨ ⲠⲒⲦⲈⲂⲦ ⲚϨⲞⲨⲒⲦ ⲈⲐⲚⲀⲒ ⲈⲠϢⲰⲒ ⲀⲖⲒⲦϤ ⲞⲨⲞϨ ⲀⲔϢⲀⲚⲞⲨⲰⲚ ⲚⲢⲰϤ ⲈⲔⲈϪⲒⲘⲒ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ ⲀⲖⲒⲦⲤ ⲘⲎⲒⲤ ⲚⲰⲞⲨ ⲈϪⲰⲒ ⲚⲈⲘⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲒ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲠⲈ ⲠⲒⲚⲒϢϮ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲞⲨⲔⲞⲨϪⲒ ⲚⲀⲖⲞⲨ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲞⲨⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲔⲈⲦ ⲐⲎⲚⲞⲨ ⲚⲦⲈⲦⲈⲚⲈⲢ ⲘⲪⲢⲎϮ ⲘⲠⲀⲒⲀⲖⲞⲨ ⲚⲚⲈⲦⲈⲚⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ⲪⲎ ⲞⲨⲚ ⲈⲐⲚⲀⲐⲈⲂⲒⲞϤ ⲘⲪⲢⲎϮ ⲘⲠⲀⲒⲀⲖⲞⲨ ⲪⲀⲒ ⲠⲈ ⲠⲒⲚⲒϢϮ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϢⲈⲠ ⲞⲨⲀⲖⲞⲨ ⲈⲢⲞϤ ⲘⲠⲀⲒⲢⲎϮ ϦⲈⲚⲠⲀⲢⲀⲚ ⲀⲚⲞⲔ ⲠⲈⲦⲈϤϢⲰⲠ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲤⲈⲢⲚⲞϤⲢⲒ ⲚⲀϤ ⲚⲦⲞⲨⲈϢ ⲞⲨⲰⲚⲒ ⲘⲘⲞⲨⲖⲞⲚ ⲈϦⲎⲦϤ ⲞⲨⲞϨ ⲚⲦⲞⲨⲞⲘⲤϤ ϦⲈⲚⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ⲞⲨⲞⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲐⲂⲈ ⲚⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲀⲚⲀⲄⲔⲎ ⲄⲀⲢ ⲚⲦⲞⲨⲒ ⲚϪⲈⲚⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲦⲈ ⲠⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ Ⲓ- ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ⲒⲤϪⲈ ⲦⲈⲔϪⲒϪ ⲒⲈ ⲦⲈⲔϬⲀⲖⲞϪ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ϪⲞϪⲞⲨ ϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ϨⲀⲢⲞⲔ ⲚⲀⲚⲈⲤ ⲄⲀⲢ ⲚⲀⲔ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲰⲚϦ ⲈⲔⲞⲒ ⲚϬⲀⲖⲈ ⲒⲈ ⲈⲔⲞⲒ ⲚϪⲀϬⲈ ⲈϨⲞⲦⲈ ⲈⲞⲨⲞⲚ ϪⲒϪ ⲤⲚⲞⲨϮ ⲈⲢⲞⲔ ⲒⲈ ϬⲀⲖⲞϪ ⲤⲚⲞⲨϮ ⲚⲤⲈϨⲒⲦⲔ ⲈⲠⲒⲬⲢⲰⲘ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲠⲈⲔⲂⲀⲖ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ⲪⲞⲢⲔϤ ϨⲒⲦⲔ ⲈⲂⲞⲖ ϨⲀⲢⲞⲔ ⲚⲀⲚⲈⲤ ⲄⲀⲢ ⲚⲀⲔ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲰⲚϦ ⲈⲞⲨⲂⲀⲖ ⲠⲈⲦⲈⲘⲘⲞⲔ ⲒⲈ ⲈⲞⲨⲞⲚ ⲂⲀⲖ ⲂⲘⲘⲞⲔ ⲚⲤⲈϨⲒⲦⲔ ⲈϮⲄⲈⲈⲚⲚⲀ ⲚⲦⲈⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ⲀⲚⲀⲨ ⲞⲨⲚ ⲘⲠⲈⲢⲈⲢⲔⲀⲦⲀⲪⲢⲞⲚⲒⲚ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲞⲨⲀⲄⲄⲈⲖⲞⲤ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲤⲈⲚⲀⲨ ⲈⲠϨⲞ ⲘⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ⲔⲈ ⲄⲀⲢ ⲀϤⲒ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲔⲰϮ ⲞⲨⲞϨ ⲈⲚⲞϨⲈⲘ ⲚⲚⲎ ⲈⲦⲤⲰⲢⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ⲞⲨ ⲆⲈ ⲠⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ⲀⲢⲈϢⲀⲚ ⲢⲚⲈⲤⲰⲞⲨ ϢⲰⲠⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈⲞⲨⲀⲒ ⲤⲰⲢⲈⲘ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲘⲎ ⲘⲠⲀϤⲬⲀ ⲠⲒϤⲐ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲈ ⲚⲀϤ ⲚⲦⲈϤⲔⲰϮ ⲚⲤⲀⲪⲎ ⲈⲦⲀϤⲤⲰⲢⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ⲞⲨⲞϨ ⲀⲤϢⲀⲚϢⲰⲠⲒ ⲈⲐⲢⲈϤϪⲈⲘϤ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϢⲀϤⲢⲀϢⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲘⲀⲖⲖⲞⲚ ⲈϨⲞⲦⲈ ⲠⲒϤⲐ ⲈⲦⲈⲚⲤⲈⲤⲰⲢⲈⲘ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ⲠⲀⲒⲢⲎϮ ⲪⲞⲨⲰϢ ⲘⲠⲀⲒⲰⲦ ⲀⲚ ⲠⲈ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲠⲈⲔⲤⲞⲚ ⲈⲢⲚⲞⲂⲒ ⲈⲢⲞⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲞⲨⲞϨ ⲤⲀϨⲰϤ ⲞⲨⲦⲰⲔ ⲚⲈⲘⲀϤ ⲘⲘⲀⲨⲀⲦⲔ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲤⲰⲦⲈⲘ ⲚⲤⲰⲔ ⲈⲔⲈϪⲈⲘϨⲎⲞⲨ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲚⲤⲰⲔ ϬⲒ ⲚⲔⲈⲞⲨⲀⲒ ⲒⲈ ⲔⲈⲂ ⲚⲈⲘⲀⲔ ϨⲒⲚⲀ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲘⲘⲈⲐⲢⲈ ⲂⲒⲈ ⲄⲚⲦⲈ ⲤⲀϪⲒ ⲚⲒⲂⲈⲚ ⲞϨⲒ ⲈⲢⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲚⲤⲰⲞⲨ ⲀϪⲞⲤ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲚⲤⲀϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈϤⲈϢⲰⲠⲒ ⲚⲦⲞⲦⲔ ⲘⲪⲢⲎϮ ⲚⲞⲨⲈⲐⲚⲒⲔⲞⲤ ⲚⲈⲘ ⲞⲨⲦⲈⲖⲰⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲤⲞⲚϨⲞⲨ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲨⲈϢⲰⲠⲒ ⲈⲨⲤⲞⲚϨ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲂⲞⲖⲞⲨ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲨⲈϢⲰⲠⲒ ⲈⲨⲂⲎⲖ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ⲠⲀⲖⲒⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲂϦⲈⲚ ⲐⲎⲚⲞⲨ ϮⲘⲀϮ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨⲈⲢⲈⲦⲒⲚ ⲘⲘⲰⲞⲨ ⲈⲤⲈϢⲰⲠⲒ ⲚⲰⲞⲨ ⲚⲦⲈⲚ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ⲠⲒⲘⲀ ⲄⲀⲢ ⲈⲦⲈⲞⲨⲞⲚ ⲂⲒⲈ ⲄⲈⲢⲤⲨⲚⲀⲄⲈⲤⲐⲈ ⲘⲘⲞϤ ϦⲈⲚⲠⲀⲢⲀⲚ ϮⲬⲎ ⲘⲘⲀⲨ ϦⲈⲚⲦⲞⲨⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ⲦⲞⲦⲈ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲢⲈϢⲀⲚ ⲠⲀⲤⲞⲚ ⲈⲢⲚⲞⲂⲒ ⲈⲢⲞⲒ ⲚⲦⲀⲬⲰ ⲚⲀϤ ⲈⲂⲞⲖ ϢⲀ ⲞⲨⲎⲢ ⲚⲤⲞⲠ ϢⲀ ⲌⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲀⲚ ϢⲀ ⲌⲚⲤⲞⲠ ⲀⲖⲖⲀ ⲌⲚⲞ ⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ⲈⲐⲂⲈ ⲪⲀⲒ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲞⲨⲢⲞ ⲈⲀϤⲞⲨⲰϢ ⲈϤⲒⲰⲠ ⲚⲈⲘ ⲚⲈϤⲈⲂⲒⲀⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ⲈⲦⲀϤⲈⲢϨⲎⲦⲤ ⲆⲈ ⲚϤⲒⲰⲠ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲀⲒ ⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚϪⲒⲚϬⲰⲢ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ⲘⲘⲞⲚⲦⲈϤ ⲆⲈ ⲚⲦⲎⲒⲦⲞⲨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲆⲈ ⲚϪⲈⲠⲈϤϬⲞⲒⲤ ⲈⲦⲎⲒϤ ⲈⲂⲞⲖ ⲚⲈⲘ ⲦⲈϤⲤϨⲒⲘⲒ ⲚⲈⲘ ⲚⲈϤϢⲎⲢⲒ ⲚⲈⲘ ⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲀϤ ⲞⲨⲞϨ ⲈⲦⲞⲂⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ⲈⲦⲀϤϨⲒⲦϤ ⲞⲨⲚ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀϤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲰⲞⲨⲚϨⲎⲦ ⲚⲈⲘⲎⲒ ⲞⲨⲞϨ ϮⲚⲀⲦⲞⲂⲞⲨ ⲚⲀⲔ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ⲈⲦⲀϤϢⲈⲚϨⲎⲦ ⲆⲈ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲬⲀϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲈⲦⲈⲢⲞϤ ⲦⲎⲢϤ ⲀϤⲬⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤϪⲒⲘⲒ ⲚⲞⲨⲀⲒ ⲚⲚⲈϤϢⲪⲎⲢ ⲚⲈⲂⲒⲀⲒⲔ ⲈⲞⲨⲞⲚ ⲢⲚⲤⲀⲐⲈⲢⲒ ⲚⲦⲀϤ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲀϤⲰϪϨ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀ ⲠⲈⲦⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ⲈⲦⲀϤϨⲒⲦϤ ⲞⲨⲚ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲈϤϢⲪⲎ ⲢⲘⲂⲰⲔ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲞⲨⲚϨⲎⲦ ⲚⲈⲘⲎⲒ ⲞⲨⲞϨ ϮⲚⲀⲦⲞⲂⲞⲨ ⲚⲀⲔ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲈϤⲞⲨⲰϢ ⲀⲖⲖⲀ ⲀϤϢⲈ ⲚⲀϤ ⲀϤϨⲒⲦϤ ⲈⲠⲒϢⲦⲈⲔⲞ ϢⲀⲦⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲈϤϢⲪⲎⲢ ⲚⲈⲂⲒⲀⲒⲔ ⲈⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲀⲠⲞⲨϨⲎⲦ ⲘⲔⲀϨ ⲈⲘⲀϢⲰ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲀⲨⲦⲀⲘⲈ ⲠⲞⲨϬⲞⲒⲤ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ⲦⲞⲦⲈ ⲀⲠⲈϤϬⲞⲒⲤ ⲘⲞⲨϮ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲒⲂⲰⲔ ⲈⲦϨⲰⲞⲨ ⲪⲎ ⲈⲦⲈⲢⲞⲔ ⲦⲎⲢϤ ⲀⲒⲬⲀϤ ⲚⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲀⲔϮϨⲞ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ⲚⲀⲤⲘⲠϢⲀ ⲚⲀⲔ ⲀⲚ ϪⲈ ⲚⲐⲞⲔ ⲚⲦⲈⲔⲚⲀⲒ ϦⲀ ⲠⲈⲔϢⲪⲎⲢ ⲘⲂⲰⲔ ⲘⲠⲒⲢⲎϮ ⲈⲦⲀⲨⲚⲀⲒ ⲚⲀⲔ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲰⲚⲦ ⲚϪⲈⲠⲈϤϬⲞⲒⲤ ⲀϤⲦⲎ ⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲢⲈϤⲦϨⲈⲘⲔⲞ ϢⲀⲦⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ⲠⲀⲒⲢⲎϮ ⲠⲈⲦⲈ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲚⲀⲀⲒϤ ⲚⲰⲦⲈⲚ ⲀⲢⲈϢⲦⲈⲘ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ⲬⲰ ⲈⲂⲞⲖ ⲘⲠⲈϤⲤⲞⲚ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲈⲔ ⲚⲀⲒⲤⲀϪⲒ ⲈⲂⲞⲖ ⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲀϤⲒ ⲈⲚⲒϬⲒⲎ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎ Ⲥ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ⲞⲨⲞϨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚ ⲤϢⲈ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ϨⲒ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲂⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲈⲦⲈⲚⲰϢ ⲒⲤϪⲈⲚ ϨⲎ ⲞⲨϨⲰⲞⲨⲦ ⲚⲈⲘ ⲤϨⲒⲘⲒ ⲠⲈⲦⲀϤⲤⲞⲚⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲈⲐⲂⲈⲪⲀⲒ ⲈⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲬⲀ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲈϤⲈⲦⲞⲘϤ ⲈⲦⲈϤⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲘⲠⲂ ⲈⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ϨⲰⲤⲦⲈ ⲂⲀⲚ ϪⲈ ⲚⲈⲀⲖⲖⲀ ⲞⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ ⲦⲈ ⲪⲎ ⲞⲨⲚ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲘϤ ⲘⲠⲈⲚⲐⲢⲈ ⲪⲢⲰⲘⲒ ⲪⲞⲢϪϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲞⲨⲚ Ⲁ- ⲘⲰⲨⲤⲎⲤ ϨⲞⲚϨⲈⲚ ⲈϮⲤϦⲒ ⲚⲞⲨⲈⲒ ⲞⲨⲞϨ ⲈϨⲒⲦⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈ ⲦⲈⲦⲈⲚⲘⲈⲦⲚⲀϢⲦϨⲎ ⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲦⲈⲚ ⲈϨⲒ ⲚⲈⲦⲈⲚϨⲒⲞⲘⲒ ⲈⲂⲞⲖ ⲒⲤϪⲈⲚ ϨⲎ ⲆⲈ ⲘⲠⲈⲤϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨⲒ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲚⲞⲨⲈϢⲈ ⲚⲤⲀϪⲒ ⲘⲠⲞⲢⲚⲒⲀ ⲀϤⲐⲢⲞ ⲘⲘⲞⲤ ⲈϪⲪⲈ ⲚⲰⲒⲔ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϬⲒ ⲚⲐⲎ ⲈⲦϨⲰⲞⲨⲒ ⲈⲂⲞⲖ ϤⲞⲒ ⲚⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ⲠⲈϪⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈ ⲦⲈⲦⲒⲀ ⲘⲠⲒⲢⲰⲘⲒ ⲚⲈⲘ ϮⲤϨⲒⲘⲒ ⲤⲈⲢⲚⲞϤⲢⲒ ⲀⲚ ⲈϬⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϢⲰⲠ ⲘⲠⲀⲒⲤⲀϪⲒ ⲈⲢⲰⲞⲨ ⲈⲂⲎⲖ ⲈⲚⲎ ⲈⲦⲈⲤⲦⲞⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ⲞⲨⲞⲚ ϨⲀⲚⲤⲒⲞⲨⲢ ⲄⲀⲢ ⲈⲀⲨⲘⲀⲤⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲐⲚⲈϪⲒ ⲚⲦⲈⲦⲞⲨⲘⲀⲨ ⲞⲨⲞⲚ ϨⲀⲚⲔⲈⲤⲒⲞⲨⲢ ⲈⲀⲨⲀⲒⲦⲞⲨ ⲚⲤⲒⲞⲨⲢ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲞⲨⲞⲚ ϨⲀⲚⲔⲈⲤⲒⲞⲨⲢ ⲈⲀⲨⲀⲒⲦⲞⲨ ⲚⲤⲒⲞⲨⲢ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎ ⲞⲨⲒ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈϢⲰⲠ ⲈⲢⲞϤ ⲘⲀⲢⲈϤϢⲰⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ⲦⲞⲦⲈ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚϨⲀⲚⲀⲖⲰⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲈϤⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲰⲂϨ ⲈϪⲰⲞⲨ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲬⲀ ⲚⲒⲀⲖⲰⲞⲨⲒ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ ⲈⲒ ϨⲀⲢⲞⲒ ⲚⲒⲞⲨⲞⲚ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲎϮ ⲐⲰⲞⲨ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲀⲒ ⲀϤⲒ ϨⲀⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲞⲨ ⲚⲀⲄⲀⲐⲞⲚ ⲈϮⲚⲀⲀⲒϤ ϨⲒⲚⲀ ⲚⲦⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔϢⲒⲚⲒ ⲘⲘⲞⲒ ⲈⲐⲂⲈ ⲠⲒⲀⲄⲀⲐⲞⲚ ⲞⲨⲀⲒ ⲠⲈ ⲠⲒⲀⲄⲀⲐⲞⲤ ⲪⲚⲞⲨϮ ⲒⲤϪⲈ ⲆⲈ ⲬⲞⲨⲰϢ ⲈⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲰⲚϦ ⲀⲢⲈϨ ⲈⲚⲒⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀϢ ⲚⲈⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲚⲈⲔϦⲰⲦⲈⲂ ⲚⲚⲈⲔⲈⲢⲚⲰⲒⲔ ⲚⲚⲈⲔϬⲒⲞⲨⲒ ⲚⲚⲈⲔⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ⲘⲀⲦⲀⲒⲈ ⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲦⲈⲔⲘⲀⲨ ⲞⲨⲞϨ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ⲠⲈϪⲈ ⲠⲒϦⲈⲖϢⲒⲢⲒ ⲚⲀϤ ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲒⲤϪⲈⲚ ⲦⲀⲘⲈⲦⲀⲖⲞⲨ ⲞⲨ ⲞⲚ ⲠⲈϮϢⲀⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲒⲤϪⲈ ⲬⲞⲨⲰϢ ⲈⲈⲢⲞⲨⲦⲈⲖⲒⲞⲤ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲀ ⲪⲎ ⲈⲦⲈⲚⲦⲀⲔ ⲈⲂⲞⲖ ⲘⲎⲒⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲀⲔϪⲪⲞ ⲚⲀⲔ ⲚⲞⲨⲀϨⲞ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲀⲘⲞⲨ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲠⲒϦⲈⲖϢⲒⲢⲒ ⲈⲠⲒⲤⲀϪⲒ ⲀϤϢⲈ ⲚⲀϤ ⲈⲢⲈ ⲠⲈϤϨⲎⲦ ⲘⲞⲔϨ ⲚⲈⲞⲨⲞⲚⲦⲈϤ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲤⲘⲞⲔϨ ⲚⲦⲈⲞⲨⲢⲀⲘⲀⲞ ⲒⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎ ⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ⲠⲀⲖⲒⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲤⲘⲞⲦⲈⲚ ⲚⲦⲈⲞⲨϬⲀⲘⲞⲨⲖ ⲒⲈϦⲞⲨⲚ ϦⲈⲚⲐⲞⲨⲀⲐⲚⲒ ⲚⲞⲨⲘⲀⲚⲐⲰⲢⲠ ⲒⲈ ⲞⲨⲢⲀⲘⲀⲞ ⲚⲦⲈϤⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲘⲀϢⲰ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ⲈⲦⲀϤϪⲞⲨϢⲦ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲦⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲘⲈⲦⲀⲦϪⲞⲘ ⲠⲈ ⲪⲀⲒ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲆⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ⲦⲞⲦⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲚⲞⲚ ⲀⲚⲬⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲤⲰⲚ ⲞⲨⲞϨ ⲀⲚⲞⲨⲀϨⲦⲈⲚ ⲚⲤⲰⲔ ⲞⲨ ϨⲀⲢⲀ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦⲀⲨⲘⲞϢⲒ ⲚⲤⲰⲒ ϦⲈⲚⲠⲒⲞⲨⲀϨⲈⲘ ⲤⲰⲚⲦ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϨⲈⲘⲤⲒ ϨⲒ ⲠⲐⲢⲞⲚⲞⲤ ⲚⲦⲈⲠⲈϤⲰⲞⲨ ⲈⲨⲈⲦϨⲈⲘⲤⲈ ⲐⲎⲚⲞⲨ ϨⲰⲦⲈⲚ ϨⲒ ⲒⲂ ⲚⲐⲢⲞⲚⲞⲤ ⲈⲢⲈⲦⲈⲚϮϨⲀⲠ ⲈϮⲒⲂ ⲚⲪⲨⲖⲎ ⲚⲦⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲬⲀ ⲤⲞⲚ ⲚⲤⲰϤ ⲒⲈ ⲤⲰⲚⲒ ⲒⲈ ⲒⲰⲦ ⲒⲈ ⲘⲀⲨ ⲒⲈ ⲤϨⲒⲘⲒ ⲒⲈ ϢⲎⲢⲒ ⲒⲈ ⲒⲞϨⲒ ⲒⲈ ⲎⲒ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ ⲈϤⲈϬⲒⲦⲞⲨ ⲚⲢ ⲚⲔⲰⲂ ⲚⲤⲞⲠ ⲞⲨⲞϨ ⲠⲒⲰⲚϦ ⲚⲈⲚⲈϨ ⲈϤⲈⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚϢⲞⲢⲠ ⲈⲨⲚⲀⲈⲢϦⲀⲈ ⲞⲨⲞϨ ϨⲀⲚϦⲀⲈⲨ ⲈⲨⲚⲀⲈⲢϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲚⲈⲂⲒⲞϨⲒ ⲈⲀϤⲒ ⲈⲂⲞⲖ ⲚϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲈⲦⲀϨⲞ ⲚϨⲀⲚⲈⲢⲄⲀⲦⲎⲤ ⲈⲠⲈϤⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ⲀϤⲤⲈⲘⲚⲎⲦⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲈϮ ⲚⲰⲞⲨ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ ⲈⲪⲞⲨⲀⲒ ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲈⲠⲈϤⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲘⲪⲚⲀⲨ ⲚⲀϪⲠⲄ ⲀϤⲚⲀⲨ ⲈϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϨⲒ ϮⲀⲄⲞⲢⲀ ⲈⲨⲔⲞⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ⲠⲈϪⲀϤ ⲚⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲠⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲤⲈⲘⲠϢⲀ ϮⲚⲀⲦⲎⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲒ ⲈⲂⲞⲖ ⲘⲪⲚⲀⲨ ⲚⲀϪⲠ ⲚⲈⲘ ⲪⲚⲀⲨ ⲚⲀϪⲠ ⲐⲀϤⲒⲢⲒ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲘⲪⲚⲀⲨ ⲚⲀϪⲠ ⲒⲀ ⲀϤϪⲒⲘⲒ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀϦⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲘⲠⲒⲈϨⲞⲞⲨ ⲦⲎⲢϤ ⲈⲢⲈⲦⲈⲚⲔⲞⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲠⲈ ϨⲖⲒ ⲦⲀϨⲞⲚ ⲈⲪⲂⲈⲬⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲠⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲒⲀϨⲀⲖⲞⲖⲒ ⲘⲠⲈϤⲈⲠⲒⲦⲢⲞⲠⲞⲤ ϪⲈ ⲘⲞⲨϮ ⲈⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲘⲀ ⲠⲞⲨⲂⲈⲬⲈ ⲚⲰⲞⲨ ⲈⲀⲔⲈⲢϨⲎ ⲦⲤ ⲒⲤϪⲈⲚ ⲚⲒϦⲀⲈⲨ ϢⲀ ⲚⲒϨⲞⲨⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲚϪⲈⲚⲀ ϮⲀϪⲠ ⲒⲀ ⲀⲨϬⲒ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ ⲈⲪⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ⲈⲦⲀⲨⲒ ⲆⲈ ⲚϪⲈⲚⲒϨⲞⲨⲀϮ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ⲤⲈⲚⲀϬⲒ ⲚϨⲞⲨⲞ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲀⲨϬⲒ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ ⲈⲪⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ⲈⲦⲀⲨϬⲒ ⲆⲈ ⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲚⲤⲀⲠⲒⲚⲈⲂⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒϦⲀⲈⲨ ⲞⲨⲞⲨⲚⲞⲨ ⲚⲈⲢϨⲰⲂ ⲠⲈⲦⲀⲨⲀⲒⲤ ⲞⲨⲞϨ ⲀⲔⲀⲒⲦⲞⲨ ⲚϨⲨⲤⲞⲤ ⲚⲈⲘⲀⲚ ϦⲀ ⲚⲎ ⲈⲦⲀⲨϤⲒ ⲘⲪⲂⲀⲢⲞⲤ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲈⲘ ⲠⲒⲔⲀⲨⲤⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ϪⲈ ⲠⲀϢⲪⲎⲢ ϮϬⲒ ⲘⲘⲞⲔ ⲚϪⲞⲚⲤ ⲀⲚ ⲘⲎ ⲞⲨⲤⲀⲐⲈⲢⲒ ⲀⲚ ⲠⲈⲦⲀⲒⲤⲈⲘⲚⲎⲦⲤ ⲚⲈⲘⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ϬⲒ ⲘⲪⲎ ⲈⲦⲈ ⲪⲰⲔ ⲘⲀϢⲈ ⲚⲀⲔ ϮⲞⲨⲰϢ ⲆⲈ ⲈϮ ⲘⲠⲀⲒϦⲀⲈ ⲘⲠⲈⲔⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ϢⲀⲚ ⲤϢⲈ ⲚⲎⲒ ⲈⲈⲢ ⲠⲈⲦⲈϨⲚⲎⲒ ϦⲈⲚⲚⲎ ⲈⲦⲈⲚⲞⲨⲒ ϢⲀⲚ ⲠⲈⲔⲂⲀⲖ ⲚⲐⲞⲔ ϤϨⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲀⲄⲀⲐⲞⲤ ⲀⲚⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ⲠⲀⲒⲢⲎϮ ⲚⲒϦⲀⲈⲨ ⲈⲨⲈⲈⲢϢⲞⲢⲠ ⲞⲨⲞϨ ⲚⲒϢⲞⲢⲠ ⲈⲨⲈⲈⲢϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ⲈϤⲚⲀϢⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀϤϬⲒ ⲘⲠⲒⲒⲂ ⲞⲨⲦⲰϤ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ϪⲈ ϨⲎⲠⲠⲈ ⲦⲈⲚⲚⲀϢⲈ ⲚⲀⲚ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲚⲚⲈⲚϪⲒϪ ⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ⲈⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲈⲠⲤⲰⲂⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲞϤ ⲚⲤⲈⲀϢϤ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ⲈϤⲈⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ⲦⲞⲦⲈ ⲀⲤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲐⲘⲀⲨ ⲚⲚⲈⲚϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲚⲈⲤϢⲎⲢⲒ ⲈⲤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲤⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲞⲨϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲞⲨⲀϢϤ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲀϪⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲠⲀϢⲎⲢⲒ ⲂⲚⲦⲈ ⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ϨⲈⲘⲤⲒ ⲤⲀⲦⲈⲔⲞⲨⲒⲚⲀⲘ ⲞⲨⲀⲒ ⲤⲀⲦⲈⲔϪⲀϬⲎ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲈⲔⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲢⲈⲦⲈⲚⲈⲢⲈⲦⲒⲚ ⲈⲐⲂⲈⲞⲨ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲤⲈ ⲠⲒⲀⲪⲞⲦ ⲈϮⲚⲀⲤⲞϤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲒⲀⲪⲞⲦ ⲘⲈⲚ ⲈⲢⲈⲦⲈⲚⲈⲤⲞϤ ⲈϨⲈⲘⲤⲒ ⲆⲈ ⲤⲀⲦⲀⲞⲨⲒⲚⲀⲘ ⲒⲈ ⲦⲀϪⲀϬⲎ ⲪⲰⲒ ⲀⲚ ⲠⲈ ⲈⲦⲎⲒϤ ⲀⲖⲖⲀ ⲪⲀ ⲚⲎ ⲠⲈ ⲈⲦⲀ ⲠⲀⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲤⲈⲂⲦⲰⲦⲤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲠⲒⲔⲈⲒ ⲘⲘⲀⲐⲎ ⲦⲎⲤ ⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲈⲐⲂⲈ ⲠⲒⲤⲞⲚ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲚⲒⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲠⲈⲦⲞⲒ ⲚϬⲞⲒⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲞⲨⲔⲈⲚⲒϢϮ ⲈⲦⲞⲒ ⲚⲈⲢϢⲒϢⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲀⲚ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲖⲖⲀ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲈⲢⲚⲒϢϮ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲈⲈⲢⲆⲒⲀⲔⲰⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲈⲢϨⲞⲨⲒⲦ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲈⲈⲢⲂⲰⲔ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ⲘⲪⲢⲎϮ ϨⲰϤ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲈⲦⲀϤⲒ ⲀⲚ ⲈⲐⲢⲞⲨϢⲈⲘϢⲎⲦϤ ⲀⲖⲖⲀ ⲈϢⲈⲘϢⲒ ⲞⲨⲞϨ ⲈϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲚⲤⲰϮ ⲈϪⲈⲚ ⲞⲨⲘⲎ Ϣ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ⲈϤⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲒⲬⲰ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ⲞⲨⲞϨ ⲒⲤ ⲂⲈⲖⲖⲈ ⲂⲚⲀⲨϨⲈⲘⲤⲒ ⲈⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤⲒⲚⲒ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲚⲀⲒ ϦⲀⲢⲞⲚ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ⲠⲒⲘⲎϢ ⲆⲈ ⲚⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈⲬⲀⲢⲰⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲚϨⲞⲨⲞ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲚⲀⲒ ϦⲀⲢⲞⲚ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ⲞⲨⲞϨ ⲈⲦⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲞⲨⲀϢϤ ⲚⲦⲀⲀⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲞⲨⲰⲚ ⲚϪⲈⲚⲈⲚⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ⲈⲦⲀϤϢⲈⲚϨⲎⲦ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϬⲒ ⲚⲈⲘ ⲚⲞⲨⲂⲀⲖ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ⲞⲨⲞϨ ϨⲞⲦⲈ ⲈⲦⲀⲨϦⲰⲚⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨⲒ ⲈⲂⲎⲐⲪⲀⲄⲎ ϦⲀⲦⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲦⲞⲦⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲞⲨⲰⲢⲠ ⲘⲘⲀⲐⲎⲦⲎⲤ Ⲃ- ");
INSERT INTO copbhc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲠⲀⲒϮⲘⲒ ⲈⲦⲬⲎ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲚⲞⲨⲈⲰ ⲈⲤⲤⲞⲚϨ ⲚⲈⲘ ⲞⲨⲤⲎϪ ⲚⲈⲘⲀⲤ ⲂⲞⲖⲞⲨ ⲀⲚⲒⲦⲞⲨ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲆⲈ ⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲀϪⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲘⲘⲰⲞⲨ ϤⲚⲀⲞⲨⲞⲢⲠⲞⲨ ⲆⲈ ⲤⲀⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ⲪⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ϪⲈ ⲀϪⲞⲤ ⲚⲦϢⲈⲢⲒ ⲚⲤⲒⲰⲚ ϪⲈ ⲒⲤ ⲠⲈⲞⲨⲢⲞ ϤⲚⲎⲞⲨ ⲚⲈⲈⲞⲨⲢⲈⲘⲢⲀⲨϢ ⲠⲈ ⲈϤⲦⲀⲖⲎ ⲞⲨⲦ ⲈⲞⲨⲈⲰ ⲚⲈⲘ ⲞⲨⲤⲎϪ ⲠϢⲎⲢⲒ ⲚⲞⲨⲈⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒⲢⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ⲀⲨⲒⲚⲒ ⲚϮⲈⲰ ⲚⲈⲘ ⲠⲒⲤⲎϪ ⲞⲨⲞϨ ⲀⲨⲦⲀⲖⲞ ⲚⲚⲞⲨϨⲂⲰⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲐⲢⲈϤϨⲈⲘⲤⲒ ⲤⲀⲠϢⲰⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ⲠϨⲞⲨⲞ ⲆⲈ ⲚⲚⲒⲘⲎϢ ⲀⲨⲪⲰⲢϢ ⲚⲚⲞⲨϨⲂⲰⲤ ϨⲒ ⲠⲒⲘⲰⲒⲦ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲨⲔⲰⲢϪ ⲚϨⲀⲚϪⲀⲖ ⲈⲂⲞⲖ ϨⲒ ⲚⲒϢϢⲎⲚ ⲀⲨⲪⲞⲢϢⲞⲨ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ⲚⲒⲘⲎϢ ⲆⲈ ⲀⲨⲘⲞϢⲒ ϦⲀϪⲰϤ ⲚⲈⲘ ⲚⲎ ⲈⲚⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲤⲀⲚⲚⲀ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲰⲤⲀⲚⲚⲀ ϦⲈⲚⲚⲎ ⲈⲦϬⲞⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲤⲘⲞⲚⲘⲈⲚ ⲚϪⲈϮⲂⲀⲔⲒ ⲦⲎⲢⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ⲚⲒⲘⲎϢ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲀϤϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲰⲠ ⲞⲨⲞϨ ⲚⲒⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲚⲒⲢⲈϤⲈⲢⲔⲈⲢⲘⲀ ⲀϤⲪⲞⲚϪⲞⲨ ⲚⲈⲘ ⲚⲒⲔⲀⲐⲈⲆⲢⲀ ⲚⲦⲈⲚⲎ ⲈⲦϮ ϬⲢⲞⲘⲠⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲀⲎⲒ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲎⲒ ⲘⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲞϤ ⲘⲘⲀⲚⲬⲰⲠ ⲚⲤⲞⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲂⲈⲖⲖⲈⲨ ⲚⲈⲘ ϨⲀⲚϬⲀⲖⲈⲨ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲈⲚⲒϢⲪⲎⲢⲒ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚⲈⲘ ⲚⲒⲀⲖⲰⲞⲨⲒ ⲈⲦⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲤⲀⲚⲚⲀ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲀⲨⲬⲢⲈⲘⲢⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲔⲤⲰⲦⲈⲘ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ⲚⲀⲒ ϪⲰ ⲘⲘⲞϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲈ ⲘⲠⲈⲦⲈⲚⲰϢ ⲈⲚⲈϨ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲞⲨ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ ⲚⲈⲘ ⲚⲎ ⲈⲐⲞⲨⲈⲘϬⲒ ⲀⲔⲤⲈⲂⲦⲈ ⲠⲒⲤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀⲨ ⲀϤⲒ ⲤⲀⲂⲞⲖ ⲚϮⲂⲀⲔⲒ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲀϤⲚⲔⲞⲦ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ⲈⲦⲀ ⲦⲞⲞⲨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀϤⲦⲀⲤⲐⲞ ⲈϮⲂⲀⲔⲒ ⲀϤϨⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲞⲨⲂⲰ ⲚⲔⲈⲚⲦⲈ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ϨⲀⲢⲞⲤ ⲘⲠⲈϤϪⲈⲘ ϨⲖⲒ ϨⲒⲰⲦⲤ ⲈⲂⲎⲖ ⲈϨⲀⲚϪⲰⲂⲒ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲚⲚⲈ ⲞⲨⲦⲀϨ ⲒⲈⲂⲞⲖ ⲚϦⲎϮ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲀⲤϢⲰⲞⲨⲒ ⲚϪⲈϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲰⲤ ⲀⲦⲀⲒⲂⲰ ⲚⲔⲈⲚⲦⲈ ϢⲰⲞⲨⲒ ⲚⲦⲀⲒⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚⲦⲈⲦⲈⲚ ⲚⲀϨϮ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲈⲢϨⲎ ⲦⲂ ⲘⲪⲀ ⲦⲀⲒⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲠⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲀⲒϤ ⲀⲖⲖⲀ ⲀⲢⲈⲦⲈⲚϢⲀⲚϪⲞⲤ ⲘⲠⲀⲒⲦⲰⲞⲨ ϪⲈ ϤⲒⲦⲔ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲪⲒⲞⲘ ⲈⲤⲈϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ⲞⲨⲞϨ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲠⲢⲞⲤⲈⲨⲬⲎ ⲈⲢⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲈⲦⲈⲚⲈϬⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲈϤϮⲤⲂⲰ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲔⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ ⲞⲨⲞϨ ⲚⲒⲘ ⲠⲈⲦⲀϤϮ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲀϢⲈⲚ ⲐⲎⲚⲞⲨ ϨⲰ ⲈⲞⲨⲤⲀϪⲒ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲦⲀⲘⲞⲒ ⲈⲢⲞϤ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ϪⲈ ⲀⲒⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϢⲀⲚ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲠⲈ ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲀⲚϢⲀⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϤⲚⲀϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ⲈϢⲰⲠ ⲆⲈ ⲀⲚϢⲀⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲦⲈⲚⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲘⲎϢ ⲒⲰⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲚⲦⲞⲦⲞⲨ ϨⲰⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ⲞⲨⲞϨ ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲀⲒⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ⲞⲨ ⲆⲈ ⲠⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲈⲞⲨⲞⲚⲦⲈϤ ϢⲎⲢⲒ ⲂⲘⲘⲀⲨ ⲀϤⲒ ϨⲀ ⲠⲒϨⲞⲨⲒⲦ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϢⲎⲢⲒ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲪⲞⲞⲨ ⲀⲢⲒϨⲰⲂ ϦⲈⲚⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲀϬⲞⲒⲤ ⲞⲨⲞϨ ⲘⲠⲈϤϢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ⲀϤⲒ ϨⲀ ⲠⲒⲘⲀϨⲂ ⲀϤϪⲞⲤ ⲚⲀϤ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚϮⲞⲨⲰϢ ⲀⲚ ⲈⲠϦⲀⲈ ⲆⲈ ⲈⲦⲀϤⲞⲨⲈⲘϨⲐⲎϤ ⲀϤϢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ⲚⲒⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲂ ⲀϤⲈⲢ ⲠⲈⲦⲈϨⲚⲈ ⲠⲈϤⲒⲰⲦ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲒϦⲀⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲠⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲞⲢⲚⲞⲤ ⲤⲈⲚⲀⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲈⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ⲀϤⲒ ⲄⲀⲢ ϨⲀⲢⲰⲦⲈⲚ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲠⲞⲢⲚⲞⲤ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚⲚⲀⲨ ⲞⲨⲆⲈ ⲘⲠⲈⲦⲈⲚⲞⲨⲈⲘϨⲐⲎⲦⲈⲚ ⲈⲠϦⲀⲈ ⲈⲠϪⲒⲚⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ⲤⲰⲦⲈⲘ ⲈⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲚⲈⲂⲒⲞϨⲒ ⲈⲀϤϬⲞ ⲚⲞⲨⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲀϤⲦⲀⲔⲦⲞ ⲚⲞⲨϪⲞⲒ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲀϤϢⲰⲔ ⲚⲞⲨϨⲢⲰⲦ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤⲔⲰⲦ ⲚⲞⲨⲠⲨⲢⲄⲞⲤ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚϨⲀⲚⲞⲨⲒⲎ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀϤϦⲰⲚⲦ ⲚϪⲈⲠⲤⲎⲞⲨ ⲚⲦⲈⲚⲒⲞⲨⲦⲀϨ ⲀϤⲞⲨⲰⲢⲠ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ϨⲀ ⲚⲒⲞⲨⲒⲎ ⲈϬⲒ ⲚⲚⲈϤⲞⲨⲦⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒⲎ ϬⲒ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲞⲨⲀⲒ ⲘⲈⲚ ⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀⲨϦⲞⲐⲂⲈϤ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀⲨϨⲒⲰⲚⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲦⲀⲞⲨⲞ ⲚϨⲀⲚⲔⲈⲈⲂⲒⲀⲒⲔ ⲈⲨⲞϢ ⲈⲚⲒϨⲞⲨⲀϮ ⲞⲨⲞϨ ⲀⲨⲒⲢⲒ ⲚⲰⲞⲨ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ⲈⲠϦⲀⲈ ⲆⲈ ⲀϤⲞⲨⲰⲢⲠ ⲘⲠⲈϤϢⲎⲢⲒ ϨⲀⲢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲚⲀϢⲪⲒⲦ ϦⲀⲦϨⲎ ⲘⲠⲀϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ⲚⲒⲞⲨⲒⲎ ⲆⲈ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲠⲒϢⲎⲢⲒ ⲠⲈϪⲰⲞⲨ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒⲔⲖⲎ ⲢⲞⲚⲞⲘⲞⲤ ⲀⲘⲰⲒⲚⲒ ⲚⲦⲈⲚϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲚⲦⲈⲚϬⲒ ⲚⲦⲈϤⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ⲞⲨⲞϨ ⲀⲨϬⲒⲦϤ ⲀⲨϨⲒⲦϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲀⲨϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨ ⲠⲈⲦⲈϤⲚⲀⲀⲒϤ ⲚⲚⲒⲞⲨⲒⲎ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲒⲔⲀⲔⲰⲤ ⲈϤⲈⲦⲀⲔⲰⲞⲨ ⲚⲔⲀⲔⲰⲤ ⲞⲨⲞϨ ⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲈϤⲈⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚϨⲀⲚⲔⲈⲞⲨⲒⲎ ⲚⲎ ⲈⲐⲚⲀϮ ⲚⲚⲈϤⲞⲨⲦⲀϨ ⲚⲀϤ ϦⲈⲚⲠⲞⲨⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲦⲈⲚⲰϢ ⲈⲚⲈϨ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ϪⲈ ⲠⲒⲰⲚⲒ ⲈⲦⲀⲨϢⲞϢϤ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰⲦ ⲪⲀⲒ ⲀϤϢⲰⲠⲒ ⲚϪⲰϪ ⲚⲖⲀⲔϨ ⲈⲦⲀ ⲪⲀⲒ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠϬⲞⲒⲤ ⲞⲨⲞϨ ϤⲞⲒ ⲚϢⲪⲎⲢⲒ ϦⲈⲚⲚⲈⲚⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ⲈⲐⲂⲈⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲨⲈⲞⲖⲤ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈⲦⲎⲒⲤ ⲚⲔⲈⲈⲐⲚⲞⲤ ⲪⲎ ⲈⲐⲚⲀⲒⲢⲒ ⲚⲚⲈⲤⲞⲨⲦⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϨⲈⲒ ⲈϪⲈⲚ ⲠⲀⲒⲰⲚⲒ ⲈϤⲈⲖⲀⲤϤ ⲞⲨⲞϨ ⲪⲎ ⲆⲈ ⲈⲦⲈϤⲚⲀϨⲈⲒ ⲈϪⲰϤ ⲈϤⲈϢⲀϢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲚⲈϤⲠⲀⲢⲀⲂⲞⲖⲎ ⲀⲨⲈⲘⲒ ϪⲈ ⲀϤϪⲰ ⲘⲘⲞⲤ ⲈⲐⲂⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲈⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲠⲈ ⲀⲨⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲘⲎϢ ϪⲈ ⲚⲀϤⲬⲎ ⲚⲦⲞⲦⲞⲨ ⲠⲈ ϨⲰⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲞⲨⲢⲞ ⲈⲀϤⲒⲢⲒ ⲚⲞⲨϨⲞⲠ ⲈⲠⲈϤϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲈⲘⲞⲨϮ ⲞⲨⲂⲈ ⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲈϦⲞⲨⲚ ⲈⲠⲒϨⲞⲠ ⲞⲨⲞϨ ⲘⲠⲞⲨⲞⲨⲰϢ ⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲞⲨⲰⲢⲠ ⲚϨⲀⲚⲈⲂⲒⲀⲒⲔ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϪⲞⲤ ⲚⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ϪⲈ ⲒⲤ ⲠⲀⲀⲢⲒⲤⲦⲞⲚ ⲀⲒⲤⲈⲂⲦⲰⲦϤ ⲚⲀⲘⲀⲤⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲀⲚⲈⲨϢ ⲤⲈϢⲀⲦ ⲤⲈⲤⲈⲂⲦⲰⲦ ⲦⲎⲢⲞⲨ ⲀⲘⲰⲒⲚⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒϨⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲈⲢⲀⲘⲈⲖⲈⲤ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲞⲨⲀⲒ ⲘⲈⲚ ⲈⲠⲈϤⲒⲞϨⲒ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲈⲦⲈϤⲒⲈⲂϢⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ⲠⲤⲈⲠⲒ ⲆⲈ ⲀⲨⲀⲘⲞⲚⲒ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲀⲨϢⲞϢⲞⲨ ⲞⲨⲞϨ ⲀⲨϦⲞⲐⲂⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ⲠⲒⲞⲨⲢⲞ ⲆⲈ ⲀϤϪⲰⲚⲦ ⲞⲨⲞϨ ⲀϤⲦⲀⲞⲨⲞ ⲘⲠⲈϤⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲀϤⲦⲀⲔⲞ ⲚⲚⲒⲢⲈϤϦⲰⲦⲈⲂ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲦⲞⲨⲂⲀⲔⲒ ⲀϤⲢⲞⲔϨⲤ ϦⲈⲚⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲈⲂⲒⲀⲔ ϪⲈ ⲠⲒϨⲞⲠ ⲘⲈⲚ ϤⲤⲈⲂⲦⲰⲦ ⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲆⲈ ⲚⲀⲨⲘⲠϢⲀ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲆⲈ ⲈⲂⲞⲖ ⲈⲚⲒⲘⲀⲚⲘⲞϢⲒ ⲚⲦⲈⲚⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀϪⲈⲘⲞⲨ ⲐⲀϨⲘⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲒϨⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲈⲂⲒⲀⲒⲔ ⲈⲦⲈⲘⲘⲀⲨ ϨⲒ ⲚⲒⲘⲰⲒⲦ ⲀⲨⲐⲰⲞⲨϮ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϪⲈⲘⲞⲨ ⲚⲎ ⲈⲦϨⲰⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲀⲚⲈⲨ ⲞⲨⲞϨ ⲀϤⲘⲞϨ ⲚϪⲈⲠⲒϨⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲢⲰⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ⲈⲦⲀϤⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲚϪⲈⲠⲒⲞⲨⲢⲞ ⲈⲚⲀⲨ ⲈⲚⲎ ⲈⲐⲢⲰⲦⲈⲂ ⲀϤⲚⲀⲨ ⲈⲞⲨⲢⲰⲘⲒ ⲘⲘⲀⲨ ⲚⲦϨⲈⲂⲤⲰ ⲘⲠⲒϨⲞⲠ ⲦⲞⲒ ϨⲒⲰⲦϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϢⲪⲎⲢ ⲠⲰⲤ ⲀⲔⲒ ⲈϦⲞⲨⲚ ⲈⲘⲚⲀⲒ ⲚⲦϨⲈⲂⲤⲰ ⲘⲠⲒϨⲞⲠ ⲦⲞⲒ ϨⲒⲰⲦⲔ ⲀⲚ ⲚⲐⲞϤ ⲆⲈ ⲀⲢⲰϤ ⲐⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲠⲒⲞⲨⲢⲞ ⲚⲚⲒⲆⲒⲀⲔⲰⲚ ϪⲈ ⲤⲰⲚϨ ⲘⲪⲀⲒ ⲚⲦⲞⲦϤ ⲚⲈⲘ ⲢⲀⲦϤ ϨⲒⲦϤ ⲈⲠⲒⲬⲀⲔⲒ ⲈⲦⲤⲀⲂⲞⲖ ⲠⲒⲘⲀ ⲈⲦⲀ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲈⲨⲐⲀϨⲈⲘ ϨⲀⲚⲔⲞⲨϪⲒ ⲚⲈⲚⲒⲤⲰⲦⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ⲦⲞⲦⲈ ⲀⲨϢⲈ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ϦⲀⲢⲞϤ ϨⲒⲚⲀ ⲚⲤⲈϪⲞⲢϪϤ ⲚⲞⲨⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ⲚⲚⲞⲨⲘⲀⲐⲎⲦⲎⲤ ϨⲀⲢⲞϤ ⲚⲈⲘ ⲚⲒⲎⲢⲰⲆⲒⲀⲚⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲐⲘⲎⲒ ⲞⲨⲞϨ ⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲔϮⲤⲂⲰ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎ ⲒⲞⲨⲞϨ ⲤⲈⲢⲘⲈⲖⲒⲚ ⲚⲀⲔ ⲀⲚ ϦⲀⲦϨⲎ ⲚϨⲖⲒ ⲔϪⲞⲨϢⲦ ⲄⲀⲢ ⲀⲚ ⲈϨⲞ ⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ⲀϪⲞⲤ ⲞⲨⲚ ⲚⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲘⲈⲨⲒ ⲈⲢⲞϤ ⲤϢⲈ ⲈϮϨⲰϮ ⲘⲠⲞⲨⲢⲞ ϢⲀⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ⲈⲦⲀϤⲈⲘⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲦⲞⲨⲘⲈⲦⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϬⲰⲚⲦ ⲘⲘⲞⲒ ⲚⲒϢⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ⲘⲀⲦⲀⲘⲞⲒ ⲪⲚⲞⲘⲒⲤⲘⲀ ⲚⲦⲈⲚⲒⲔⲎⲚⲤⲞⲤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲀⲒϨⲒⲔⲰⲚ ⲐⲀ ⲚⲒⲘ ⲦⲈ ⲚⲈⲘ ⲚⲀⲒⲤϦⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲀ ⲠⲞⲨⲢⲞ ⲚⲈⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀ ⲚⲀ ⲠⲞⲨⲢⲞ ⲘⲠⲞⲨⲢⲞ ⲞⲨⲞϨ ⲘⲀ ⲚⲀ ⲪⲚⲞⲨϮ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲞⲨⲞϨ ⲀⲨⲬⲀϤ ⲀⲨϢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲀϢⲰⲠⲒ ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ Ⲁ- ⲘⲰⲨⲤⲎⲤ ϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲘⲞⲨ ⲘⲘⲞⲚⲦⲈϤ ϢⲎⲢⲒ ⲘⲘⲀⲨ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈϤⲤⲞⲚ ϬⲒ ⲚⲦⲈϤⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲞⲨⲚⲞⲤ ⲞⲨϪⲢⲞϪ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ⲚⲈ ⲞⲨⲞⲚ ⲌⲞⲨⲚ ⲚⲤⲞⲚ ϦⲀⲦⲞⲦⲈⲚ ⲠⲈ ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲒⲦ ⲈⲦⲀϤϬⲒ ⲀϤⲘⲞⲨ ⲞⲨⲞϨ ⲚⲈⲘⲘⲞⲚⲦⲈϤ ϪⲢⲞϪ ⲘⲘⲀⲨ ⲀϤⲬⲀ ⲦⲈϤⲤϨⲒⲘⲒ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲘⲀϨⲂ ⲚⲈⲘ ⲠⲒⲘⲀϨⲄ ϢⲀ ⲠⲒⲘⲀϨⲌ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ⲈⲠϦⲀⲈ ⲆⲈ ⲘⲘⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲤⲘⲞⲨ ⲚϪⲈϮⲔⲈⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ϦⲈⲚ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲞⲨⲚ ⲀⲤⲚⲀⲈⲢⲤϨⲒⲘⲒ ⲚⲚⲒⲘ ϦⲈⲚⲠⲒⲌ ⲀⲨϬⲒⲤ ⲄⲀⲢ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲤⲞⲢⲈⲘ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ⲚⲚⲒⲄⲢⲀⲪⲎ ⲞⲨⲆⲈ ϮϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ϦⲈⲚ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲄⲀⲢ ⲘⲠⲀⲨϬⲒ ⲞⲨⲆⲈ ⲘⲠⲀⲨϬⲒⲦⲞⲨ ⲀⲖⲖⲀ ⲀⲨⲚⲀⲈⲢ ⲘⲪⲢⲎϮ ⲚⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ⲈⲐⲂⲈ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲆⲈ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲘⲠⲈⲦⲈⲚⲰϢ ⲘⲪⲎ ⲈⲦⲀⲨϪⲞϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲪⲚⲞⲨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ ⲪⲚⲞⲨϮ ⲪⲀ ⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲚⲎ ⲈⲦⲞⲚϦ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ⲀϤⲐⲰⲘ ⲚⲢⲰⲞⲨ ⲚⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲀⲨⲐⲰⲞⲨϮ ⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ⲞⲨⲞϨ ⲀϤϢⲈⲚϤ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲞⲨⲚⲞⲘⲒⲔⲞⲤ ⲠⲈ ⲈϤϬⲰⲚⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲀϢ ⲦⲈ ϮⲚⲒϢϮ ⲚⲈⲚⲦⲞⲖⲎ ⲈⲦϦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔϨⲎⲦ ⲦⲎⲢϤ ⲚⲈⲘ ⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲚⲈⲘ ⲚⲈⲔⲘⲈⲨⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ⲐⲀⲒ ⲦⲈ ϮⲚⲒϢϮ ⲞⲨⲞϨ ⲚϨⲞⲨⲒϮ ⲚⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ϮⲘⲀϨⲤⲚⲞⲨϮ ⲦⲈ ⲈⲦⲞⲚⲒ ⲚⲐⲀⲒ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ϦⲈⲚ ⲦⲀⲒⲈⲚⲦⲞⲖⲎ ⲤⲚⲞⲨϮ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲀϢⲀⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲆⲈ ⲈⲨⲘⲀ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀϤϢⲈⲚⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ⲈⲐⲂⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲚⲚⲒⲘ ⲠⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲰⲤ ⲞⲨⲚ ⲆⲀⲨⲒⲆ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϤⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ϪⲈ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲀϬⲞⲒⲤ ϪⲈ ϨⲈⲘⲤⲒ ⲤⲀⲦⲞⲨⲒⲚⲀⲘ ϢⲀϮⲬⲰ ⲚⲚⲈⲔϪⲀϪⲒ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈⲔϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ⲒⲤϪⲈ ⲞⲨⲚ ⲆⲀⲨⲒⲆ ϤⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲠⲰⲤ ⲠⲈϤϢⲎⲢⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ϢϪⲈⲘϪⲞⲘ ⲚⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚⲞⲨⲤⲀϪⲒ ⲞⲨⲆⲈ ⲘⲠⲈ ϨⲖⲒ ϢⲈⲢⲦⲞⲖⲘⲀⲚ ⲈϢⲈⲚϤ ⲒⲤϪⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ⲦⲞⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲘⲎϢ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨϨⲈⲘⲤⲒ ϨⲒ ϮⲔⲀⲐⲈⲆⲢⲀ ⲚⲦⲈⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨⲚⲀϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲀⲢⲒⲦⲞⲨ ⲞⲨⲞϨ ⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲘⲠⲈⲢⲒⲢⲒ ⲆⲈ ⲔⲀⲦⲀ ⲚⲞⲨϨⲂⲎⲞⲨⲒ ⲤⲈϪⲰ ⲄⲀⲢ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲤⲈⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ⲤⲈⲘⲞⲨⲢ ⲆⲈ ⲚϨⲀⲚⲈⲦⲪⲰⲞⲨⲒ ⲈⲨϨⲞⲢϢ ⲞⲨⲞϨ ⲤⲈⲦⲀⲖⲞ ⲘⲘⲰⲞⲨ ⲈϪⲈⲚ ⲐⲚⲀϨⲂⲒ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲤⲈⲞⲨⲰϢ ⲈⲔⲒⲘ ⲈⲢⲰⲞⲨ ⲀⲚ ⲘⲠⲞⲨⲦⲎⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ⲚⲞⲨϨⲂⲎⲞⲨⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲤⲈⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲈⲐⲢⲞⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲤⲈⲞⲨⲰϢⲤ ⲄⲀⲢ ⲚⲚⲞⲨⲪⲨⲖⲀⲔⲦⲎⲢⲒⲞⲚ ⲞⲨⲞϨ ⲤⲈⲐⲢⲞ ⲚⲚⲈⲚϢⲦⲀϮ ⲚⲚⲞⲨϨⲂⲰⲤ ⲈϢⲒⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ⲤⲈⲘⲈⲒ ⲆⲈ ⲚⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚⲢⲰⲦⲈⲂ ϦⲈⲚⲚⲒⲆⲒⲠⲚⲞⲚ ⲚⲈⲘ ⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚϨⲈⲘⲤⲒ ϨⲒ ⲚⲒⲔⲀⲐⲈⲆⲢⲀ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ⲚⲈⲘ ⲚⲒⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲚⲒⲀⲄⲞⲢⲀ ⲈⲐⲢⲞⲨⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ϪⲈ ⲢⲀⲂⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲘⲠⲈⲚⲐⲢⲈⲘⲞⲨϮ ⲈⲢⲰⲦⲈⲚ ϪⲈ ⲢⲀⲂⲂⲒ ⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲈⲚⲢⲈϤϮⲤⲂⲰ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ⲞⲨⲞϨ ⲘⲠⲈⲢⲘⲞⲨϮ ⲞⲨⲂⲈ ⲒⲰⲦ ⲚⲰⲦⲈⲚ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ⲞⲨⲆⲈ ⲘⲠⲈⲢⲘⲞⲨϮ ⲈⲤⲀϦ ⲚⲰⲦⲈⲚ ⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲈⲦⲈⲚⲤⲀϦ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ⲠⲒⲚⲒϢϮ ⲆⲈ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϤⲈⲈⲢⲆⲒⲀⲔⲰⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϬⲀⲤϤ ⲤⲈⲚⲀⲐⲈⲂⲒⲞϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲐⲈⲂⲒⲞϤ ⲤⲈⲚⲀϬⲀⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚⲞⲨⲰⲘ ⲠⲎⲒ ⲚⲚⲒⲬⲎⲢⲀ ϦⲈⲚⲈⲦⲒⲀ ⲚⲦⲈⲦⲈⲚⲠⲢⲞⲤⲈⲨⲬⲎ ⲈⲐⲘⲎⲚ ⲈⲐⲂⲈⲪⲀⲒ ⲦⲈⲦⲈⲚϬⲒ ⲚϨⲀⲚⲚⲒϢϮ ⲚϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ⲞⲨⲞⲒ ⲆⲈ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚϢⲐⲀⲘ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲐⲰⲦⲈⲚ ⲄⲀⲢ ⲦⲈⲦⲈⲚⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ⲀⲚ ⲞⲨⲆⲈ ⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲦⲈⲦⲈⲚⲬⲰ ⲘⲘⲰⲞⲨ ⲀⲚ ⲈⲒ ⲈϦⲞⲨⲚ ");
INSERT INTO copbhc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚⲔⲰϮ ⲈⲪⲒⲞⲘ ⲚⲈⲘ ⲠⲈⲦϢⲞⲨⲰⲞⲨ ⲈⲐⲢⲈⲦⲈⲚⲐⲀⲘⲒⲞ ⲚⲞⲨⲠⲢⲞⲤⲨⲖⲒⲦⲞⲚ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀϤϢⲀⲚϢⲰⲠⲒ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲞϤ ⲚϢⲎⲢⲒ ⲚⲄⲈⲈⲚⲚⲀ ⲈϤⲔⲎⲂ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒϬⲀⲨⲘⲰⲒⲦ ⲘⲂⲈⲖⲖⲈ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲰⲢⲔ ⲘⲠⲒⲈⲢⲪⲈⲒ ϨⲖⲒ ⲠⲈ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲰⲢⲔ ⲘⲠⲒⲚⲞⲨⲂ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ⲚⲒⲤⲞϪ ⲞⲨⲞϨ ⲘⲂⲈⲖⲖⲈ ⲚⲒⲘ ⲄⲀⲢ ⲈⲦⲞⲒ ⲚⲚⲒϢϮ ⲠⲒⲚⲞⲨⲂ ϢⲀⲚ ⲠⲒⲈⲢⲪⲈⲒ ⲈⲦⲦⲞⲨⲂⲞ ⲘⲠⲒⲚⲞⲨⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲰⲢⲔ ⲘⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ϨⲖⲒ ⲠⲈ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲰⲢⲔ ⲘⲠⲒⲦⲀⲒⲞ ⲈⲦⲬⲎ ϨⲒϪⲰϤ ⲞⲨⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ⲚⲒⲤⲞϪ ⲞⲨⲞϨ ⲘⲂⲈⲖⲖⲈ ⲀϢ ⲄⲀⲢ ⲈⲦⲞⲒ ⲚⲚⲒϢϮ ⲠⲒⲦⲀⲒⲞ ϢⲀⲚ ⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲈⲦⲦⲞⲨⲂⲞ ⲘⲠⲒⲦⲀⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ⲪⲎ ⲞⲨⲚ ⲈⲦⲰⲢⲔ ⲘⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲀϤⲰⲢⲔ ⲘⲘⲞϤ ⲚⲈⲘ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲬⲎ ϨⲒϪⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲰⲢⲔ ⲘⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲰⲢⲔ ⲘⲘⲞϤ ⲚⲈⲘ ⲪⲎ ⲈⲦϢⲞⲠ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲰⲢⲔ ⲚⲦⲪⲈ ⲀϤⲰⲢⲔ ⲘⲠⲒⲐⲢⲞⲚⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ⲪⲎ ⲈⲦϨⲈⲘⲤⲒ ϨⲒϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚϮ ⲘⲪⲢⲈⲘⲎⲦ ⲘⲠⲒⲀϬⲒⲚⲚⲤⲐⲞⲒ ⲚⲈⲘ ⲠⲒⲀⲘⲒⲤⲒ ⲚⲈⲘ ⲠⲒⲐⲀⲠⲈⲚ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲬⲰ ⲚⲚⲎ ⲈⲦϨⲞⲢϢ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲠⲒϨⲀⲠ ⲚⲈⲘ ⲠⲒⲚⲀⲒ ⲚⲈⲘ ⲠⲒⲚⲀϨϮ ⲚⲀⲒ ⲚⲀⲤⲘⲠϢⲀ ⲚⲦⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲬⲀⲨ ⲚⲤⲀⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ⲚⲒϬⲀⲨⲘⲰⲒⲦ ⲘⲂⲈⲖⲖⲈ ⲚⲎ ⲈⲦⲤⲰϤ ⲚϮϢⲞⲖⲘⲈⲤ ⲞⲨⲞϨ ⲈⲦⲰⲘⲔ ⲘⲠⲒϬⲀⲘⲞⲨⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚⲦⲞⲨⲂⲞ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲀⲪⲞⲦ ⲚⲈⲘ ϮⲠⲀⲢⲞⲮⲒⲤ ⲤⲀϦⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲞⲨ ⲘⲈϨ ⲚϨⲰⲖⲈⲘ ⲚⲈⲘ ϬⲰϦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ⲠⲒⲂⲈⲖⲖⲈ ⲘⲪⲀⲢⲒⲤⲈⲞⲤ ⲘⲀⲦⲞⲨⲂⲞ ⲤⲀϦⲞⲨⲚ ⲘⲠⲒⲀⲪⲞⲦ ⲚϢⲞⲢⲠ ⲚⲈⲘ ϮⲠⲀⲢⲞⲮⲒⲤ ϨⲒⲚⲀ ⲚⲦⲈⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲦⲞⲨⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ⲦⲈⲦⲈⲚⲞⲚⲒ ⲚϨⲀⲚⲘϨⲀⲨ ⲈⲨⲞϢϪ ⲚⲔⲞⲚⲒⲀ ⲤⲀⲂⲞⲖ ⲘⲈⲚ ⲘⲘⲰⲞⲨ ⲤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲚⲈⲤⲰⲞⲨ ⲤⲀϦⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲞⲨ ⲘⲈϨ ⲚⲔⲀⲤ ⲚⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲈⲘ ϬⲰϦⲈⲘ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲘⲈⲚ ⲘⲘⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲐⲘⲎⲒ ⲤⲀϦⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲦⲈⲚ ⲘⲈϨ ⲘⲘⲈⲦϢⲞⲂⲒ ⲚⲈⲘ ⲀⲚⲞⲘⲒⲀ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲒϢⲞⲂⲒ ϪⲈ ⲦⲈⲦⲈⲚⲔⲰⲦ ⲚⲚⲒⲘϨⲀⲨ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲞⲖⲤⲈⲖ ⲚⲚⲒⲂⲎⲂ ⲚⲦⲈⲚⲒⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ⲞⲨⲞϨ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲀⲚⲬⲎ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲚⲀⲚⲚⲀϢⲰⲠⲒ ⲈⲚⲞⲒ ⲚϢⲪⲎⲢ ⲈⲢⲰⲞⲨ ⲀⲚ ⲠⲈ ϦⲈⲚⲠⲒⲤⲚⲞϤ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ϨⲰⲤⲦⲈ ⲦⲈⲦⲈⲚⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲰⲦⲈⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲈⲚϢⲎⲢⲒ ⲚⲚⲎ ⲈⲦⲀⲨϦⲰⲦⲈⲂ ⲚⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ϪⲈⲔ ϢⲒ ⲚⲦⲈⲚⲈⲦⲈⲚⲒⲞϮ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ⲚⲒϨⲞϤ ⲘⲘⲒⲤⲒ ⲚⲦⲈⲚⲒⲀϪⲰ ⲠⲰⲤ ⲦⲈⲦⲈⲚⲚⲀϢⲪⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲚⲦⲈϮⲄⲈⲈⲚⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ⲈⲐⲂⲈⲪⲀⲒ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮⲚⲀⲞⲨⲰⲢⲠ ϨⲀⲢⲰⲦⲈⲚ ⲚϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ϨⲀⲚⲤⲀⲂⲈⲨ ⲚⲤⲀϦ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϦⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈⲒϢⲒ ⲈⲢⲈⲦⲈⲚⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲰⲞⲨ ϦⲈⲚⲚⲈⲦⲈⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϬ ⲞϪⲒ ⲚⲤⲰⲞⲨ ⲒⲤϪⲈⲚ ⲂⲀⲔⲒ ⲈⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚϪⲈⲤⲚⲞϤ ⲚⲒⲂⲈⲚ ⲚⲐⲘⲎⲒ ⲈⲦⲀⲨⲪⲞⲚϤ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲒⲤϪⲈⲚ ⲠⲤⲚⲞϤ ⲚⲦⲈⲀⲂⲎⲖ ⲠⲒⲐⲘⲎⲒ ϢⲀ ⲠⲤⲚⲞϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲠϢⲎⲢⲒ ⲚⲂⲀⲢⲀⲬⲒⲀⲤ ⲪⲎ ⲈⲦⲀⲢⲈⲦⲈⲚϦⲞⲐⲂⲈϤ ⲞⲨⲦⲈ ⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲠⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈⲢⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲒⲈϪⲈⲚ ⲦⲀⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲐⲎ ⲈⲦϦⲰⲦⲈⲂ ⲚⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲈⲦϨⲒⲰⲚⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ ϨⲀⲢⲞⲤ ⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ⲀⲒⲞⲨⲰϢ ⲈⲐⲞⲨⲈⲦ ⲚⲈϢⲎⲢⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨϨⲀⲖⲎⲦ ⲈϢⲀϤⲐⲰⲞⲨϮ ⲚⲚⲈϤⲘⲀⲤ ⲈϦⲞⲨⲚ ϦⲀ ⲚⲈϤⲦⲈⲚϨ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲞⲨⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ϨⲎⲠⲠⲈ ϮⲚⲀⲬⲰ ⲘⲠⲈⲦⲈⲚⲎⲒ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲚⲚⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ϢⲀⲦⲈⲦⲈⲚϪⲞⲤ ϪⲈ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲪⲎ ⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨⲦⲀⲘⲞ ⲘⲘⲞϤ ⲈⲚⲒⲔⲰⲦ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲞⲨⲬⲀ ⲞⲨⲰⲚⲒ ⲈϪⲈⲚ ⲞⲨⲰⲚⲒ ⲘⲠⲀⲒⲘⲀ ⲚⲤⲈⲚⲀⲂⲞⲖϤ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ⲈϤϨⲈⲘⲤⲒ ⲆⲈ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲈⲢⲈ ⲚⲀⲒ ϢⲰⲠⲒ ⲚⲐⲚⲀⲨ ⲞⲨⲞϨ ⲀϢ ⲠⲈ ⲠⲒⲘⲎⲒⲚⲒ ⲚⲦⲈⲠⲈⲔϪⲒⲚⲒ ⲚⲈⲘ ⲦϦⲀⲎ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲢⲬⲀⲤ ⲚⲦⲈⲞⲨⲀⲒ ⲤⲈⲢⲈⲘ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ⲈⲢⲈ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲒϦⲈⲚ ⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈⲤⲈⲢⲈⲘ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ⲈⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲆⲈ ⲈϨⲀⲚⲂⲰⲦⲤ ⲚⲈⲘ ϨⲀⲚⲤⲘⲎ ⲘⲂⲰⲦⲤ ⲀⲚⲀⲨ ⲘⲠⲈⲢϢⲐⲞⲢⲦⲈⲢ ϨⲰϮ ⲄⲀⲢ ⲠⲈ ⲚⲦⲞⲨϢⲰⲠⲒ ⲀⲖⲖⲀ ⲘⲠⲀⲦⲈ ⲦϦⲀⲎ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ⲈⲢⲈ ⲞⲨⲈⲐⲚⲞⲤ ⲄⲀⲢ ⲦⲰⲚϤ ⲈϪⲈⲚ ⲞⲨⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲈϪⲈⲚ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚⲘⲞⲚⲘⲈⲚ ⲚⲈⲘ ϨⲀⲚϨⲔⲞ ⲚⲈⲘ ϨⲀⲚⲘⲞⲨ ⲔⲀⲦⲀ ⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ϨⲎ ⲚⲚⲒⲚⲀⲔϨⲒ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ⲦⲞⲦⲈ ⲈⲨⲈϮ ⲐⲎⲚⲞⲨ ⲈϦⲢⲎⲒ ⲈⲠϨⲞϪϨⲈϪ ⲞⲨⲞϨ ⲈⲨⲈϦⲈⲦⲈⲂ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϢⲰⲠⲒ ⲈⲨⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ⲦⲞⲦⲈ ⲈⲢⲈ ⲞⲨⲘⲎϢ ⲬⲀ ⲦⲞⲦⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲨⲈϮ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈⲘⲈⲤⲦⲈ ⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲈⲨⲈⲦⲰⲞⲨⲚⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈⲤⲈⲢⲈⲘ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ⲞⲨⲞϨ ⲈⲐⲂⲈ ⲠⲀϢⲀⲒ ⲚⲦⲈϮⲀⲚⲞⲘⲒⲀ ⲦⲀⲄⲀⲠⲎ ⲚⲞⲨⲘⲎϢ ⲈⲤⲈϨⲢⲞϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲀⲘⲞⲚⲒ ⲚⲦⲞⲦϤ ϢⲀ ⲈⲂⲞⲖ ⲪⲀⲒ ⲠⲈⲐⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ⲞⲨⲞϨ ⲈⲨⲈϨⲒⲰⲒϢ ⲘⲠⲀⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ϦⲈⲚϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲦⲞⲦⲈ ⲈⲤⲈⲒ ⲚϪⲈϮϦⲀⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲠⲒⲤⲰϤ ⲚⲦⲈⲠϢⲀϤⲈ ⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲆⲀⲚⲒⲎⲖ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲠⲒⲘⲀ ⲈⲐⲞⲨⲀⲂ ⲪⲎ ⲈⲦⲰϢ ⲘⲀⲢⲈϤⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ⲦⲞⲦⲈ ⲚⲎ ⲈⲦⲬⲎ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲘⲀⲢⲞⲨⲪⲰⲦ ⲈϪⲈⲚ ⲚⲒⲦⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲬⲎ ϨⲒϪⲈⲚ ⲠϪⲈⲚⲈⲪⲰⲢ ⲘⲠⲈⲚⲐⲢⲈϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲈⲖ ⲚⲎ ⲈⲦϦⲈⲚ ⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲬⲎ ϦⲈⲚⲦⲔⲞⲒ ⲘⲠⲈⲚⲐⲢⲈϤⲔⲞⲦϤ ⲈⲪⲀϨⲞⲨ ⲈⲈⲖ ⲠⲈϤϨⲂⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲎ ⲈⲦⲈⲘⲂⲞⲔⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϮϬⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ⲦⲰⲂϨ ⲆⲈ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲈⲦⲈⲚⲪⲰⲦ ϢⲰⲠⲒ ϦⲈⲚⲦⲪⲢⲰ ⲞⲨⲆⲈ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ⲈⲢⲈ ⲞⲨⲚⲒϢϮ ⲄⲀⲢ ⲚϨⲞϪϨⲈϪ ϢⲰⲠⲒ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲘⲠⲈ ⲞⲨⲞⲚ ϢⲰⲠⲒ ⲘⲠⲈϤⲢⲎϮ ⲒⲤϪⲈⲚ ϨⲎ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ϢⲀ ϮⲚⲞⲨ ⲞⲨⲆⲈ ⲚⲚⲈ ⲞⲨⲞⲚ ϢⲰⲠⲒ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ⲞⲨⲞϨ ⲈⲂⲎⲖ ϪⲈ ⲀⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲔⲞⲨϪⲒ ⲠⲈ ⲚⲚⲀⲨⲚⲀⲚⲞϨⲈⲘ ⲀⲚ ⲠⲈ ⲚϪⲈⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲚⲒⲤⲰⲦⲠ ⲆⲈ ⲈⲢⲈ ⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲔⲞⲨϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ⲦⲞⲦⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲒⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϤⲦⲀⲒ ⲒⲈ ϤⲦⲎ ⲘⲠⲈⲢⲦⲈⲚϨⲞⲨⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ⲈⲨⲈⲦⲰⲞⲨⲚⲞⲨ ⲄⲀⲢ ⲚϪⲈϨⲀⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲚⲞⲨϪ ⲚⲈⲘ ϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲞⲨⲞϨ ⲈⲨⲈϮ ⲚϨⲀⲚⲚⲒϢϮ ⲘⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ϨⲰⲤⲦⲈ ⲈⲚⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲤⲈⲤⲰⲢⲈⲘ ⲚⲚⲀⲔⲈⲤⲰⲦⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ⲒⲤ ϨⲎⲠⲠⲈ ⲀⲒⲈⲢϢⲞⲢⲠ ⲚϪⲞⲤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ⲈϢⲰⲠ ⲞⲨⲚ ⲀⲨϢⲀⲚϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲎⲠⲠⲈ ⲈϤϨⲒ ⲠϢⲀϤⲈ ⲘⲠⲈⲢⲒ ⲈⲂⲞⲖ ϨⲎⲠⲠⲈ ⲈϤϦⲈⲚ ⲚⲒⲦⲀⲘⲒⲞⲚ ⲘⲠⲈⲢⲦⲈⲚϨⲞⲨⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲘⲠⲒⲤⲈⲦⲈⲂⲢⲎϪ ⲈϢⲀϤⲒ ⲈⲂⲞⲖ ⲤⲀⲠⲈⲒⲈⲂⲦ ⲞⲨⲞϨ ⲚⲦⲈϤⲞⲨⲞⲚϨϤ ⲤⲀⲠⲈⲘⲈⲚⲦ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲘⲠϪⲒⲚⲒ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ⲠⲒⲘⲀ ⲈⲦⲈ ϮϢⲞⲖϨⲤ ⲘⲘⲞϤ ϢⲀⲨⲐⲰⲞⲨϮ ⲈⲘⲀⲨ ⲚϪⲈⲚⲒⲀϦⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ⲤⲀⲦⲞⲦϤ ⲆⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒϨⲞϪϨⲈϪ ⲚⲦⲈⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲢⲎ ⲈϤⲈⲈⲢⲬⲀⲔⲒ ⲞⲨⲞϨ ⲠⲒⲒⲞϨ ⲚⲚⲈϤϮ ⲘⲠⲈϤⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲚⲒⲤⲒⲞⲨ ⲈⲨⲈϨⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲚⲒϪⲞⲘ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲈⲨⲈⲔⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ⲦⲞⲦⲈ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲘⲎⲒⲚⲒ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲨⲈⲚⲈϨⲠⲒ ⲚϪⲈⲚⲒⲪⲨⲖⲎ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲔⲀϨⲒ ⲞⲨⲞϨ ⲈⲨⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲎ ⲞⲨ ⲈϪⲈⲚ ⲚⲒϬⲎⲠⲒ ⲚⲦⲈⲦⲪⲈ ⲚⲈⲘ ⲞⲨϪⲞⲘ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ⲞⲨⲞϨ ⲈϤⲈⲦⲀⲞⲨⲞ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲤⲀⲖⲠⲒⲄⲄⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈⲐⲰⲞⲨϮ ⲚⲚⲈϤⲤⲰⲦⲠ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϤⲦⲞⲨ ⲐⲎⲞⲨ ⲒⲤϪⲈⲚ ⲀⲨⲢⲎϪⲞⲨ ⲚⲚⲒⲪⲎⲞⲨⲒ ϢⲀ ⲀⲨⲢⲎϪⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ⲈⲂⲞⲖ ϦⲈⲚϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲀⲢⲒⲈⲘⲒ ⲈϮⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϢⲰⲠ ϨⲎⲆⲎ ⲚⲦⲈⲚⲈⲤϪⲀⲖ ϬⲚⲞⲚ ⲞⲨⲞϨ ⲚⲦⲈⲚⲈⲤϪⲰⲂⲒ ϮⲞⲨⲰ ⲈⲂⲞⲖ ϢⲀⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ϤϦⲈⲚⲦ ⲚϪⲈⲠⲒϢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲢⲒⲈⲘⲒ ϪⲈ ⲤϦⲈⲚⲦ ϨⲒⲢⲈⲚ ⲚⲒⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲤⲒⲚⲒ ϢⲀⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲔⲀϨⲒ ⲚⲀⲤⲒⲚⲒ ⲚⲀⲤⲀϪⲒ ⲆⲈ ⲚⲚⲞⲨⲤⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ⲈⲐⲂⲈ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲘ ϮⲞⲨⲚⲞⲨ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲘⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲆⲈ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲈⲂⲎⲖ ⲈⲪⲒⲰⲦ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲰⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲦⲠⲀⲢⲞⲨⲤⲒⲀ ⲘⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲚⲀⲨϢⲞⲠ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦϦⲀϪⲰϤ ⲘⲠⲒⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲈⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲈⲨⲤⲰ ⲈⲨϬⲒⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲈⲨϬⲒϨⲀⲒ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲀ ⲚⲰⲈ ϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈϮⲔⲒⲂⲰⲦⲞⲤ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ⲞⲨⲞϨ ⲘⲠⲞⲨⲈⲘⲒ ϢⲀⲦⲈϤⲒ ⲚϪⲈⲠⲒⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲖ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲠⲀⲒⲢⲎϮ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲠϪⲒⲚⲒ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ⲦⲞⲦⲈ ⲂⲈⲨⲬⲎ ϦⲈⲚⲦⲔⲞⲒ ⲞⲨⲀⲒ ⲈⲨⲈⲞⲖϤ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲈⲨⲈⲬⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ⲤⲚⲞⲨϮ ⲈⲨⲚⲞⲨⲦ ϦⲈⲚⲞⲨⲈⲨⲚⲒ ⲞⲨⲒ ⲈⲨⲈⲞⲖⲤ ⲞⲨⲞϨ ⲞⲨⲒ ⲈⲨⲈⲬⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ⲢⲰⲒⲤ ⲞⲨⲚ ϪⲈ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲢⲈ ⲠⲈⲦⲈⲚϬⲞⲒⲤ ⲚⲎⲞⲨ ϦⲈⲚⲀϢ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ⲪⲀⲒ ⲆⲈ ⲀⲢⲒⲈⲘⲒ ⲈⲢⲞϤ ϪⲈ ⲈⲚⲀⲢⲈ ⲠⲒⲚⲈⲂⲎⲒ ⲈⲘⲒ ϪⲈ ⲀⲢⲈ ⲠⲤⲞⲚⲒ ⲚⲎⲞⲨ ⲚⲀϤ ϦⲈⲚⲀϢ ⲚⲞⲨⲚⲞⲨ ⲚⲀϤⲚⲀⲢⲰⲒⲤ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘⲬ ⲀϤ ⲈϬⲒ ⲘⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ⲈⲐⲂⲈⲪⲀⲒ ϨⲰⲦⲈⲚ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲤⲈⲂⲦⲰⲦ ϪⲈ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ⲀⲢⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲎⲞⲨ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ⲚⲒⲘ ϨⲀⲢⲀ ⲠⲈ ⲠⲒⲠⲒⲤⲦⲞⲤ ⲘⲂⲰⲔ ⲞⲨⲞϨ ⲚⲤⲀⲂⲈ ⲪⲎ ⲈⲦⲈ ⲠⲈϤϬⲞⲒⲤ ⲚⲀⲬⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲈϮ ⲚⲦⲞⲨϦⲢⲈ ⲚⲰⲞⲨ ϦⲈⲚⲠⲤⲎⲞⲨ ⲚⲦⲎⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲈϤϬⲞⲒⲤ ⲚⲦⲈϤϪⲈⲘϤ ⲈϤⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϤⲚⲀⲬⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈⲦⲈⲚⲦⲀϤ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ⲈϢⲰⲠ ⲀϤϢⲀⲚϪⲞⲤ ⲚϪⲈⲠⲒⲂⲰⲔ ⲈⲦϨⲰⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲠⲈϤϨⲎⲦ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲚⲀⲰⲤⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲞⲨⲒ ⲈⲚⲈϤϢⲪⲎ ⲢⲚⲈⲂⲒⲀⲒⲔ ⲚⲦⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰ ⲚⲈⲘ ⲚⲎ ⲈⲦⲐⲀϦⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ⲈϤⲈⲒ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲚϤϪⲞⲨϢⲦ ϦⲀϪⲰϤ ⲀⲚ ⲚⲈⲘ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲚϤⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ⲞⲨⲞϨ ⲈϤⲈⲪⲞⲢϪϤ ϦⲈⲚⲦⲈϤⲘⲎϮ ⲞⲨⲞϨ ⲈϤⲈⲬⲰ ⲚⲦⲈϤⲦⲞⲒ ⲚⲈⲘ ⲚⲒϢⲞⲂⲒ ⲠⲒⲘⲀ ⲈⲦⲈ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ⲦⲞⲦⲈ ⲤⲞⲚⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎ ⲞⲨⲒ ⲘⲘⲎϮ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ ⲚⲎ ⲈⲦⲀⲨϬⲒ ⲚⲚⲞⲨⲖⲀⲘⲠⲀⲤ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲈⲚ ⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ⲚⲈ ⲞⲨⲞⲚ ⲈⲆⲈ ⲚⲤⲞϪ ⲚϦⲎⲦⲞⲨ ⲚⲈⲘ Ⲉ- ⲚⲤⲀⲂⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ⲚⲒⲤⲞϪ ⲄⲀⲢ ⲈⲦⲀⲨϬⲒ ⲚⲚⲞⲨⲖⲀⲘⲠⲀⲤ ⲘⲠⲞⲨⲈⲖ ⲚⲈϨ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ⲚⲒⲤⲀⲂⲈⲨ ⲆⲈ ⲀⲨⲈⲖ ⲚⲈϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲞⲨⲘⲞⲔⲒ ⲚⲈⲘ ⲚⲞⲨⲖⲀⲘⲠⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ⲈⲦⲀϤⲰⲤⲔ ⲆⲈ ⲚϪⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲀⲨϨⲒⲚⲒⲘ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲀⲨⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ⲈⲦⲀ ⲦⲪⲀϢⲒ ⲆⲈ ⲘⲠⲒⲈϪⲰⲢϨ ϢⲰⲠⲒ Ⲁ- ⲞⲨϦⲢⲰⲞⲨ ϢⲰⲠⲒ ϪⲈ ⲒⲤ ⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲀⲘⲰⲒⲚⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ⲦⲞⲦⲈ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲚϪⲈⲚⲒⲠⲀⲢⲐⲈⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲤⲞⲖⲤⲈⲖ ⲚⲚⲞⲨⲖⲀⲘⲠⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ⲠⲈϪⲈ ⲚⲒⲤⲞϪ ⲆⲈ ⲚⲒⲤⲀⲂⲈⲨ ϪⲈ ⲘⲞⲒ ⲚⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲚⲚⲈϨ ⲘⲘⲞⲚ ⲚⲈⲚⲖⲀⲘⲠⲀⲤ ⲚⲀϬⲈⲚⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ⲀⲨⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲚⲒⲤⲀⲂⲈⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈϤϢⲦⲈⲘⲢⲀϢⲦⲈⲚ ⲚⲈⲘⲰⲦⲈⲚ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲖⲖⲞⲚ ϨⲀ ⲚⲎ ⲈⲦϮ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϢⲰⲠ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲆⲈ ϪⲈ ⲚⲦⲞⲨϢⲰⲠ ⲀϤⲒ ⲚϪⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲤⲈⲂⲦⲰⲦ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲚⲈⲘⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲒϨⲞⲠ ⲞⲨⲞϨ ⲀⲨⲘⲀϢⲐⲀⲘ ⲘⲠⲒⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ⲈⲠϦⲀⲈ ⲆⲈ ⲀⲨⲒ ⲚϪⲈⲠⲤⲰϪⲠ ⲚⲚⲒⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲠⲈⲚϬⲞⲒⲤ ⲀⲞⲨⲰⲚ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲰⲦⲈⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ⲢⲰⲒⲤ ⲞⲨⲚ ϪⲈ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲠⲒⲈϨⲞⲞⲨ ⲞⲨⲆⲈ ϮⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲚⲞⲨⲢⲰⲘⲒ ⲈϤⲚⲀϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ ⲀϤⲘⲞⲨϮ ⲈⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲞⲨⲞϨ ⲀϤϮ ⲘⲠⲈⲦⲈⲚⲦⲀϤ ⲈⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ⲞⲨⲀⲒ ⲘⲈⲚ ⲀϤϮ ⲚⲀϤ ⲚⲈⲚϪⲒⲚϬⲰⲢ ⲞⲨⲀⲒ ⲆⲈ ⲀϤϮ ⲚⲀϤ ⲚⲂ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲦⲈϤϪⲞⲘ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ⲀϤϢⲈ ⲚⲀϤ ⲆⲈ ⲚϪⲈⲪⲎ ⲈⲦϬⲒ ⲘⲠⲒⲈ ⲚϪⲒⲚϬⲰⲢ ⲀϤⲈⲢϨⲰⲂ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲀϤϪⲪⲈ ⲔⲈⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲪⲎ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲂ ⲀϤϪⲪⲈ ⲔⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ⲪⲎ ⲆⲈ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲞⲨⲀⲒ ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲀϤϢⲰⲔⲒ ⲚⲞⲨⲔⲀϨⲒ ⲞⲨⲞϨ ⲀϤⲬⲰⲠ ⲘⲠϨⲀⲦ ⲚⲦⲈⲠⲈϤϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ⲘⲈⲚⲈⲚⲤⲀ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲚⲤⲎⲞⲨ ⲀϤⲒ ⲚϪⲈⲠϬⲞⲒⲤ ⲚⲚⲒⲈⲂⲒⲀⲒⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀϤϤⲒⲰⲠ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲈ ⲚϪⲒⲚϬⲰⲢ ⲀϤⲈⲚ ⲔⲈⲈ ⲚϪⲒⲚϬⲰⲢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲈⲚϪⲒⲚϬⲰⲢ ⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲒⲤ ⲔⲈⲈ ⲚϪⲒⲚϬⲰⲢ ⲀⲒϪⲪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ⲠⲈϪⲈ ⲠⲈϤϬⲞⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠⲒⲂⲰⲔ ⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲈⲦⲈⲚϨⲞⲦ ⲈⲠⲒⲆⲎ ⲀⲔⲚϨⲞⲦ ϦⲈⲚϨⲀⲚⲔⲞⲨϪⲒ ⲈⲒⲈⲬⲀⲔ ϨⲒϪⲈⲚ ϨⲀⲚⲚⲒϢϮ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϦⲞⲨⲚ ⲈⲪⲢⲀϢⲒ ⲚⲦⲈⲠⲈⲔϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϬⲒ ⲘⲠⲒϪⲒⲚϬ ⲰⲢ ⲂⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ϪⲒⲚϬⲰⲢ Ⲃ- ⲠⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲒⲤ ⲔⲈⲂ ⲀⲒϪⲪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ⲠⲈϪⲈ ⲠⲈϤϬⲞⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠⲒⲂⲰⲔ ⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲈⲦⲈⲚϨⲞⲦ ⲈⲠⲒⲆⲎ ⲀⲔⲚϨⲞⲦ ϦⲈⲚϨⲀⲚⲔⲞⲨϪⲒ ⲈⲒⲈⲬⲀⲔ ϨⲒϪⲈⲚ ϨⲀⲚⲚⲒϢϮ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϦⲞⲨⲚ ⲈⲪⲢⲀϢⲒ ⲚⲦⲈⲠⲈⲔϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ⲀϤⲒ ⲆⲈ ϨⲰϤ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϬⲒ ⲘⲠⲒϪⲒⲚϬ ⲰⲢ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲒⲈⲘⲒ ⲈⲢⲞⲔ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲈϤⲚⲀϢⲦ ⲈⲔⲰⲤϦ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲈⲔⲤⲀⲦϤ ⲞⲨⲞϨ ⲈⲔⲐⲰⲞⲨϮ ⲈϦⲞⲨⲚ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲈⲔϪⲞⲢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ⲞⲨⲞϨ ⲀⲒⲈⲢϨⲞϮ ⲀⲒϢⲈ ⲚⲎⲒ ⲀⲒⲬⲰⲠ ⲘⲠⲈⲔϪⲒⲚϬⲰⲢ ϦⲈⲚⲠⲒⲔⲀϨⲒ ⲒⲤ ⲪⲎ ⲈⲦⲈⲪⲰⲔ ⲚⲦⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈϤϬⲞⲒⲤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲒⲂⲰⲔ ⲈⲦϨⲰⲞⲨ ⲞⲨⲞϨ ⲚϬⲈⲚⲚⲈ ⲒⲤϪⲈ ⲔⲈⲘⲒ ϪⲈ ϢⲀⲒⲰⲤϦ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲒⲤⲀⲦϤ ⲞⲨⲞϨ ϢⲀⲒⲐⲰⲞⲨϮ ⲈϦⲞⲨⲚ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲒϪⲞⲢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ⲚⲀⲤⲘⲠϢⲀ ⲞⲨⲚ ⲚⲀⲔ ⲠⲈ ⲈϮ ⲘⲠⲀϨⲀⲦ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲦⲢⲀⲠⲈⲌⲒⲦⲎⲤ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚⲒ ⲚⲀⲒⲚⲀϬⲒ ⲘⲪⲎ ⲈⲦⲈⲪⲰⲒ ⲚⲈⲘ ⲦⲈϤⲘⲎ ⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ⲀⲖⲒⲞⲨⲒ ⲞⲨⲚ ⲘⲠⲒϪⲒⲚϬⲰⲢ ⲚⲦⲞⲦϤ ⲘⲪⲀⲒ ⲞⲨⲞϨ ⲘⲎⲒϤ ⲘⲪⲀ ⲠⲒⲒ ⲚϪⲒⲚϬⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲈⲨⲈϮ ⲚⲀϤ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲞⲚ ⲈⲢϨⲞⲨⲞ ⲈⲢⲞϤ ⲪⲎ ⲆⲈ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲦⲀϤ ⲪⲎ ⲈⲦⲈⲚⲦⲞⲦϤ ⲈⲨⲈⲞⲖϤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ⲞⲨⲞϨ ⲠⲒⲀⲦϢⲀⲨ ⲘⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ϨⲒⲦϤ ⲈⲠⲒⲬⲀⲔⲒ ⲈⲦⲤⲀⲂⲞⲖ ⲠⲒⲘⲀ ⲈⲦⲈ ⲪⲢⲒⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲠⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϦⲈⲚⲠⲈϤⲰⲞⲨ ⲚⲈⲘ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲈⲘⲀϤ ⲦⲞⲦⲈ ⲈϤⲈϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ⲠⲐⲢⲞⲚⲞⲤ ⲚⲦⲈⲠⲈϤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ⲞⲨⲞϨ ⲈⲨⲈⲐⲰⲞⲨϮ ⲚⲀϨⲢⲀϤ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲈϤⲈⲪⲞⲢϪⲞⲨ ⲈⲂⲞⲖ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ⲘⲪⲢⲎϮ ⲘⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲈϢⲀϤⲪⲰⲢϪ ⲚⲚⲒⲈⲤⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲂⲀⲈⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ⲞⲨⲞϨ ⲚⲒⲈⲤⲰⲞⲨ ⲘⲈⲚ ⲈϤⲈⲬⲀⲨ ⲤⲀⲦⲈϤⲞⲨⲒⲚⲀⲘ ⲚⲒⲂⲀⲈⲘⲠⲒ ⲆⲈ ⲤⲀⲦⲈϤϪⲀϬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ⲦⲞⲦⲈ ⲈϤⲈϪⲞⲤ ⲚϪⲈⲠⲞⲨⲢⲞ ⲚⲚⲎ ⲈⲦⲤⲀⲦⲈϤⲞⲨⲒⲚⲀⲘ ϪⲈ ⲀⲘⲰⲒⲚⲒ ϨⲀⲢⲞⲒ ⲚⲎ ⲈⲦⲤⲘⲀⲢⲰⲞⲨⲦ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲀⲢⲒⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲐⲎ ⲈⲦⲤⲈⲂⲦⲰⲦ ⲚⲰⲦⲈⲚ ⲒⲤϪⲈⲚ ⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ⲀⲒϨⲔⲞ ⲄⲀⲢ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲦⲈⲘⲘⲞⲒ ⲀⲒⲒⲂⲒ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲦⲞⲒ ⲀⲒⲞⲒ ⲚϢⲈⲘⲘⲞ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚϢⲞⲠⲦ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ⲚⲀⲒⲂⲎϢ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚϨⲞⲂⲤⲦ ⲚⲀⲒϢⲰⲚⲒ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚϪⲈⲘⲠⲀϢⲒⲚⲒ ⲚⲀⲒⲬⲎ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲒ ϢⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ⲦⲞⲦⲈ ⲈⲨⲈⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲚⲒⲐⲘⲎⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲚⲐⲚⲀⲨ ⲈⲔϨⲞⲔⲈⲢ ⲞⲨⲞϨ ⲀⲚⲦⲈⲘⲘⲞⲔ ⲒⲈ ⲈⲔⲞⲂⲒ ⲞⲨⲞϨ ⲀⲚⲦⲤⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ⲒⲈ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲚⲐⲚⲀⲨ ⲈⲔⲞⲒ ⲚϢⲈⲘⲘⲞ ⲞⲨⲞϨ ⲀⲚϢⲞⲠⲔ ⲈⲢⲞⲚ ⲒⲈ ⲈⲔⲂⲎϢ ⲞⲨⲞϨ ⲀⲚϨⲞⲂⲤⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ⲒⲈ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲚⲐⲚⲀⲨ ⲈⲔϢⲰⲚⲒ ⲒⲈ ⲈⲔⲬⲎ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲞⲨⲞϨ ⲀⲚⲒ ϢⲀⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ⲞⲨⲞϨ ⲈϤⲈⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲞⲨⲢⲞ ⲈϤⲈϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈⲪⲞⲤⲞⲚ ⲀⲦⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲚⲤⲚⲎⲞⲨ ⲚⲦⲎⲒ ⲀⲚⲞⲔ ⲠⲈⲦⲀⲢⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ⲦⲞⲦⲈ ⲈϤⲈϪⲞⲤ ⲚⲚⲒϨⲰⲞⲨ ⲈⲦⲤⲀ ⲦⲈϤϪⲀϬⲎ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲚⲎ ⲈⲦⲤϨⲞⲨⲞⲢⲦ ⲈⲠⲒⲬⲢⲰⲘ ⲚⲈⲚⲈϨ ⲪⲎ ⲈⲦⲤⲈⲂⲦⲰⲦ ⲘⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ⲀⲒϨⲔⲞ ⲄⲀⲢ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲦⲈⲘⲘⲞⲒ ⲀⲒⲒⲂⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲦⲤⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ⲚⲀⲒⲞⲒ ⲚϢⲈⲘⲘⲞ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚϢⲞⲠⲦ ⲈⲢⲰⲦⲈⲚ ⲚⲀⲒⲂⲎϢ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚϨⲞⲂⲤⲦ ⲚⲀⲒϢⲰⲚⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚϪⲈⲘⲠⲀϢⲒⲚⲒ ⲚⲀⲒⲬⲎ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲘⲠⲈⲦⲈⲚⲒ ϢⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ⲦⲞⲦⲈ ⲈⲨⲈⲈⲢⲞⲨⲰ ϨⲰⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲚⲐⲚⲀⲨ ⲈⲔϨⲞⲔⲈⲢ ⲒⲈ ⲈⲔⲞⲂⲒ ⲒⲈ ⲈⲔⲞⲒ ⲚϢⲈⲘⲘⲞ ⲒⲈ ⲈⲔⲂⲎϢ ⲒⲈ ⲈⲔϢⲰⲚⲒ ⲒⲈ ⲈⲔⲬⲎ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲞⲨⲞϨ ⲘⲠⲈⲚϢⲈⲘϢⲎⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ⲦⲞⲦⲈ ⲈϤⲈⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈⲪⲞⲤⲞⲚ ⲘⲠⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲘⲠⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ⲞⲨⲞϨ ⲈⲨⲈϢⲈ ⲚⲰⲞⲨ ⲚϪⲈⲚⲀⲒ ⲈⲨⲔⲞⲖⲀⲤⲒⲤ ⲚⲈⲚⲈϨ ⲚⲒⲐⲘⲎⲒ ⲆⲈ ⲈⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲈⲔ ⲚⲀⲒⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲔⲈⲈϨⲞⲞⲨ ⲂⲠⲒⲠⲀⲤⲬⲀ ⲚⲀϢⲰⲠⲒ ⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈⲐⲢⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ⲦⲞⲦⲈ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲈϦⲞⲨⲚ ⲈϮⲀⲨⲖⲎ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲪⲎ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲔⲀⲒⲀⲪⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ⲞⲨⲞϨ ⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ϨⲒⲚⲀ ⲚⲤⲈⲀⲘⲞⲚⲒ ⲚⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲞⲨⲬⲢⲞϤ ⲞⲨⲞϨ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲀⲒⲤ ϦⲈⲚⲠϢⲀⲒ ϪⲈ ⲚⲚⲈ ⲞⲨϢⲐⲞⲢⲦⲈⲢ ϢⲰⲠⲒ ϦⲈⲚⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤⲬⲎ ϦⲈⲚⲂⲎⲐⲀⲚⲒⲀ ϦⲈⲚⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲔⲀⲔⲤⲈϨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ⲀⲤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲤϨⲒⲘⲒ ⲈⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲞⲔⲒ ⲚⲤⲞϪⲈⲚ ⲚⲦⲞⲦⲤ ⲈⲚⲀϢⲈ ⲚⲤⲞⲨⲈⲚϤ ⲞⲨⲞϨ ⲀⲤϪⲞϢϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲦⲈϤⲀⲪⲈ ⲈϤⲢⲞⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲦⲀⲔⲞ ⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ⲚⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲠⲈ ⲈϮ ⲘⲪⲀⲒ ⲈⲂⲞⲖ ϦⲀ ⲞⲨⲘⲎϢ ⲞⲨⲞϨ ⲈⲦⲎⲒⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ⲈⲦⲀϤⲈⲘⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲞⲨⲀϨϦⲒⲤⲒ ⲈϮⲤϨⲒⲘⲒ ⲞⲨϨⲰⲂ ⲈⲚⲀⲚⲈϤ ⲠⲈⲦⲀⲤⲀⲒϤ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ⲚⲒϨⲎⲔⲒ ⲄⲀⲢ ⲤⲈⲚⲈⲘⲰⲦⲈⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲀⲚⲞⲔ ⲆⲈ ϮⲚⲈⲘⲰⲦⲈⲚ ⲀⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ⲀⲤϨⲒⲞⲨⲒ ⲄⲀⲢ ⲚϪⲈⲐⲀⲒ ⲘⲠⲀⲒⲤⲞϪⲈⲚ ⲈϪⲈⲚ ⲠⲀⲤⲰⲘⲀ ⲈⲠϪⲒⲚⲔⲞⲤⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲘⲀ ⲈⲦⲞⲨⲚⲀϨⲒⲰⲒϢ ⲘⲠⲀⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲘⲞϤ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲈⲨⲈⲤⲀϪⲒ ϨⲰϤ ⲘⲪⲎ ⲈⲦⲀ ⲦⲀⲒⲤϨⲒⲘⲒ ⲀⲒϤ ⲈⲨⲘⲈⲨⲒ ⲚⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ⲦⲞⲦⲈ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ ⲪⲎ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ϨⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲦⲎⲒϤ ⲚⲎⲒ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲚⲦⲀⲦⲎⲒϤ ⲈⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲤⲈⲘⲚⲎⲦⲤ ⲚⲈⲘⲀϤ ⲈϮ ⲚⲀϤ ⲘⲖ ⲚϨⲀⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ⲞⲨⲞϨ ⲒⲤϪⲈⲚ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀϤⲔⲰϮ ⲚⲤⲀⲞⲨⲈⲨⲔⲈⲢⲒⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲦⲎⲒϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϨⲞⲨⲒⲦ ⲚⲦⲈⲚⲒⲀⲦⲔⲰⲂ ⲀⲨⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲔⲞⲨⲰϢ ⲈⲤⲈⲂⲦⲈ ⲠⲒⲠⲀⲤⲬⲀ ⲚⲀⲔ ⲚⲐⲰⲚ ⲈⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲦⲀⲒⲂⲀⲔⲒ ϨⲀ ⲠⲀⲪⲘⲀⲚ ⲚⲢⲰⲘⲒ ⲞⲨⲞϨ ⲀϪⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲈϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ϪⲈ ⲀⲠⲀⲤⲎⲞⲨ ⲀϤϦⲰⲚⲦ ⲀⲒⲚⲀⲒⲢⲒ ⲘⲠⲀⲠⲀⲤⲬⲀ ϦⲀⲦⲞⲦⲔ ⲚⲈⲘ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ⲞⲨⲞϨ ⲀⲨⲒⲢⲒ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲘⲪⲢⲎϮ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲤ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲤⲞⲂϮ ⲘⲠⲒⲠⲀⲤⲬⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲚⲀϤⲢⲞⲦⲈⲂ ⲚⲈⲘ ⲠⲒⲒⲂ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ⲞⲨⲞϨ ⲈⲨⲞⲨⲰⲘ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲠⲈⲐⲚⲀⲦⲎⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ⲞⲨⲞϨ ⲈⲢⲈ ⲠⲞⲨϨⲎⲦ ⲘⲞⲔϨ ⲈⲘⲀϢⲰ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚϪⲈⲪⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ϪⲈ ⲘⲎϮ ⲀⲚⲞⲔ ⲠⲈ ⲠⲀϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲤⲈⲠ ⲦⲈϤϪⲒϪ ⲚⲈⲘⲎⲒ ϦⲈⲚⲠⲒⲂⲒⲚⲀϪ ⲪⲀⲒ ⲠⲈⲐⲚⲀⲦⲎⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ⲠϢⲎⲢⲒ ⲘⲈⲚ ⲘⲪⲢⲰⲘⲒ ϤⲚⲀϢⲈ ⲚⲀϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞⲒ ⲆⲈ ⲘⲠⲒⲢⲰⲘⲒ ⲪⲎ ⲈⲦⲞⲨⲚⲀϮ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲀⲚⲈⲤ ⲠⲈ ⲘⲠⲞⲨⲘⲀⲤϤ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎ ⲒϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲘⲎⲦⲒ ⲀⲚⲞⲔ ⲠⲈ ⲢⲀⲂⲂⲒ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔϪⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ⲈⲨⲞⲨⲰⲘ ⲆⲈ ⲀϤϬⲒ ⲚⲞⲨⲰⲒⲔ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲀϤⲪⲀϢϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲎⲒϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ϪⲈ ϬⲒ ⲞⲨⲰⲘ ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲀⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲀⲪⲞⲦ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤⲦⲎⲒϤ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲒ ⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲪⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲠⲀⲤⲚⲞϤ ⲚⲦⲈϮⲆⲒⲀⲐⲎ ⲔⲎ ⲘⲂⲈⲢⲒ ⲈⲦⲞⲨⲚⲀⲪⲞⲚϤ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲞⲨⲘⲎ ϢⲈⲠϪⲒⲚⲬⲀ ⲚⲞⲨⲚⲞⲂⲒ ⲚⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲀⲤⲰ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲦⲀⲒⲂⲰ ⲚⲀⲖⲞⲖⲒ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲦⲎ ϨⲞⲦⲀⲚ ⲀⲒϢⲀⲚⲤⲞϤ ⲚⲈⲘⲰⲦⲈⲚ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲘⲞⲨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲦⲈⲦⲈⲚⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ϦⲈⲚⲠⲀⲒⲈϪⲰⲢϨ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲈⲒⲈⲒⲚⲒ ⲚⲞⲨⲈⲢϦⲞⲦ ⲈϪⲈⲚ ⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈϪⲰⲢ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲈⲤⲰⲞⲨ ⲚⲦⲈⲠⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲒⲦⲰⲚⲦ ⲆⲈ ϮⲚⲀⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲈⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲤⲈⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲦⲎⲢⲞⲨ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲔ ⲀⲚⲞⲔ ⲆⲈ ⲚⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲈϪⲰⲢϨ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲬⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲔⲀⲚ ⲀⲤϢⲀⲚⲪⲞϨ ⲚⲦⲀⲘⲞⲨ ⲚⲈⲘⲀⲔ ⲚⲚⲀϪⲞⲖⲔ ⲈⲂⲞⲖ ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚϪⲈⲚⲒⲔⲈⲘⲀⲐⲎ ⲦⲎⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ⲦⲞⲦⲈ ⲀϤⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲨⲒⲞϨⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲄⲈⲐⲤⲎⲘⲀⲚⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ϪⲈ ϨⲈⲘⲤⲒ ⲘⲠⲀⲒⲘⲀ ϢⲀϮϢⲈ ⲚⲎⲒ ϢⲀ ⲘⲚⲀⲒ ⲚⲦⲀⲦⲰⲂϨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ⲞⲨⲞϨ ⲀϤⲈⲖ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘⲀϤ ⲚⲈⲘ ⲠϢⲎⲢⲒ ⲂⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲈⲘ ⲈⲈⲢϢⲖⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲘⲞⲔϨ ⲚϨⲎⲦ ϢⲀ ⲈϦⲢⲎⲒ ⲈⲪⲘⲞⲨ ⲞϨⲒ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲞϨ ⲢⲰⲒⲤ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲚϤ ⲈⲦϨⲎ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ⲈϤⲦⲰⲂϨ ⲞⲨⲞϨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲀⲢⲈ ⲠⲀⲒⲀⲪⲞⲦ ⲤⲈⲚⲦ ⲠⲖⲎⲚ ⲘⲪⲢⲎϮ ⲈⲦⲈϨⲚⲎⲒ ⲀⲚⲞⲔ ⲀⲚ ⲀⲖⲖⲀ ⲘⲪⲢⲎϮ ⲈⲦⲈϨⲚⲀⲔ ⲚⲐⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ϨⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤϪⲈⲘⲞⲨ ⲈⲨⲚⲔⲞⲦ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠⲀⲒⲢⲎϮ ⲘⲠⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ ⲚⲢⲰⲒⲤ ⲚⲈⲘⲎⲒ ⲚⲞⲨⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ⲢⲰⲒⲤ ⲞⲨⲚ ⲞⲨⲞϨ ⲦⲰⲂϨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ ⲠⲒⲠⲚⲈⲨⲘⲀⲘⲈⲚ ⲈϤⲢⲰⲞⲨⲦ ϮⲤⲀⲢⲜ ⲞⲨⲀⲤⲐⲈⲚⲎⲤ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ⲠⲀⲖⲒⲚ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲦⲰⲂϨ ⲘⲪⲘⲀϨⲤⲞⲠ ⲂⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲠⲀⲒⲀⲪⲞⲦ ⲤⲈⲚⲦ ⲈⲂⲎⲖ ⲚⲦⲀⲤⲞϤ ⲘⲀⲢⲈ ⲠⲈⲦⲈϨⲚⲀⲔ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ⲞⲨⲞϨ ⲀϤⲒ ⲞⲚ ϨⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤϪⲈⲘⲞⲨ ⲈⲨⲚⲔⲞⲦ ⲚⲀⲢⲈ ⲚⲞⲨⲂⲀⲖ ⲄⲀⲢ ϨⲞⲢϢ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ⲞⲨⲞϨ ⲀϤⲬⲀⲨ ⲞⲚ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲦⲰⲂϨ ⲘⲪⲘⲀϨ ⲄⲚⲤⲞⲠ ⲈϤϪⲰ ⲘⲠⲀⲒⲤⲀϪⲒ ⲢⲰ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ⲦⲞⲦⲈ ⲀϤⲒ ϨⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲔⲞⲦ ϪⲈ ⲞⲨⲞϨ ⲘⲦⲞⲚ ⲘⲘⲰⲦⲈⲚ ⲒⲤ ϨⲎⲠⲠⲈ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲞⲨⲚⲞⲨ ⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲀⲢⲞⲚ ϨⲎⲠⲠⲈ ⲀϤϦⲰⲚⲦ ⲚϪⲈⲪⲎ ⲈⲐⲚⲀⲦⲎⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲀϪⲒ ⲒⲤ ⲒⲞⲨⲆⲀⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ ⲀϤⲒ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲚⲈⲘ ϨⲀⲚⲤⲎϤⲒ ⲚⲈⲘ ϨⲀⲚϢⲂⲞϮ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ⲪⲎ ⲆⲈ ⲈⲚⲀϤⲦⲎⲒϤ ⲀϤϮ ⲚⲞⲨⲘⲎⲒⲚⲒ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈϮⲚⲀϮ ⲚⲞⲨⲪⲒ ⲈⲢⲰϤ ⲚⲐⲞϤ ⲠⲈ ⲀⲘⲞⲚⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲬⲈⲢⲈ ⲢⲀⲂⲂⲒ ⲞⲨⲞϨ ⲀϤϮ ⲚⲞⲨⲪⲒ ⲈⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϢⲪⲎⲢ ⲪⲎ ⲈⲦⲀⲔⲒ ⲈⲐⲂⲎⲦϤ ⲦⲞⲦⲈ ⲈⲨⲈⲚ ⲚⲞⲨϪⲒϪ ⲈϪⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲬⲎ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤϢⲈⲖⲈⲘ ⲦⲈϤⲤⲎϤⲒ ⲞⲨⲞϨ ⲀϤϨⲒⲞⲨⲒ ⲚⲤⲀⲪⲂⲰⲔ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤϪⲈϪ ⲠⲈϤⲘⲀϢϪ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲚⲀϤ ϪⲈ ⲘⲀⲦⲀⲤⲐⲞ ⲚϮⲤⲎϤⲒ ⲈⲠⲈⲤⲘⲀ ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϬⲒⲤⲎϤⲒ ⲤⲈⲚⲀⲦⲀⲔⲰⲞⲨ ⲚⲦⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ⲒⲈ ⲀⲔⲘⲈⲨⲒ ϪⲈ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲦⲰⲂϨ ⲘⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲚⲦⲈϤⲐⲢⲈ ϨⲞⲨⲞ ⲈⲒⲂ ⲚⲖⲈⲄⲒⲰⲚ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲒⲚⲎⲒ ⲘⲚⲀⲒ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ⲠⲰⲤ ⲞⲨⲚ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈⲦⲤϢⲈ ⲚⲦⲈⲤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ϦⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲚⲒⲘⲎϢ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲈⲢⲈⲦⲈⲚⲚⲎ ⲞⲨ ⲚⲤⲀⲞⲨⲤⲞⲚⲒ ⲚⲈⲘ ϨⲀⲚⲤⲎϤⲒ ⲚⲈⲘ ϨⲀⲚϢⲂⲞϮ ⲈⲀⲘⲞⲚⲒ ⲘⲘⲞⲒ ⲘⲎ ⲚⲀⲒϨⲈⲘⲤⲒ ⲘⲘⲎⲒⲚⲒ ⲀⲚ ⲠⲈ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈϮⲤⲂⲰ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲀⲘⲞⲚⲒ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ⲪⲀⲒ ⲆⲈ ⲦⲎⲢϤ ⲀϤϢⲰⲠⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲄⲢⲀⲪⲎ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲞⲦⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲀⲨⲬⲀϤ ⲀⲨⲪⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲀⲘⲞⲚⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲈⲚϤ ϨⲀ ⲔⲀⲒⲀⲪⲀ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲒⲘⲀ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲠⲈ ϨⲒⲪⲞⲨⲈⲒ ϢⲀ ϮⲀⲨⲖⲎ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲚⲀϤϨⲈⲘⲤⲒ ⲠⲈ ⲚⲈⲘ ⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲚⲀⲨ ⲈⲠⲒϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲚⲈⲘ ⲠⲒⲘⲀⲚϮϨⲀⲠ ⲦⲎⲢϤ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚⲤⲀⲞⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ϦⲀ ⲒⲎⲤⲞⲨⲤ ϨⲒⲚⲀ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ⲞⲨⲞϨ ⲘⲠⲞⲨϪⲒⲘⲒ ⲈⲀⲨⲒ ⲚϪⲈⲞⲨⲘⲎϢ ⲘⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ⲈⲠϦⲀⲈ ⲆⲈ ⲀⲨⲒ ⲚϪⲈⲂ-. ");
INSERT INTO copbhc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲪⲀⲒ ϪⲞⲤ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲂⲈⲖ ⲠⲒⲈⲢⲪⲈⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲔⲞⲦϤ ϦⲈⲚⲄⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲔⲈⲢⲞⲨⲰ ⲚϨⲖⲒ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ⲚⲀⲒ ⲈⲢⲘⲈⲐⲢⲈ ⲘⲘⲞϤ ϦⲀⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤⲬⲰ ⲚⲢⲰϤ ⲠⲈ ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲀϤ ϪⲈ ϮⲦⲀⲢⲔⲞ ⲘⲘⲞⲔ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ ϨⲒⲚⲀ ⲚⲦⲈⲔϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔϪⲞⲤ ⲠⲖⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲚϮϪⲞⲘ ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲈϪⲈⲚ ⲚⲒϬⲎⲠⲒ ⲚⲦⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ⲦⲞⲦⲈ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤⲪⲰϦ ⲚⲚⲈϤϨⲂⲰⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤϪⲈⲞⲨⲀ ⲚⲦⲈⲚⲈⲢⲬ ⲢⲒⲀ ⲀⲚ ϪⲈ ⲘⲘⲈⲐⲢⲈ ϨⲎⲠⲠⲈ ϮⲚⲞⲨ ⲀⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲠⲒⲞⲨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ϪⲈ ϤⲈⲘⲠϢⲀ ⲘⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ⲦⲞⲦⲈ ⲀⲨϨⲒⲐⲀϤ ⲈϦⲞⲨⲚ ϦⲈⲚⲠⲈϤϨⲞ ⲞⲨⲞϨ ⲀⲨϮⲔⲞⲨⲢ ⲚⲀϤ ⲞⲨⲞϨ ⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲒⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲚⲀⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϨⲒⲞⲨⲒ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤϨⲈⲘⲤⲒ ⲤⲀⲂⲞⲖ ⲠⲈ ϦⲈⲚϮⲀⲨⲖⲎ ⲞⲨⲞϨ ⲀⲤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲂⲰⲔⲒ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ϨⲰⲔ ⲚⲀⲔⲬⲎ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲄⲀⲖⲒⲖⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚϮⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲢⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲠⲒϢⲐⲞⲘ ⲀⲤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲔⲈⲞⲨⲒ ⲞⲨⲞϨ ⲠⲈϪⲀⲤ ⲚⲚⲎ ⲈⲦⲬⲎ ⲘⲘⲀⲨ ϪⲈ ⲚⲐⲞϤ ϨⲰϤ ⲚⲀϤⲬⲎ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲀⲚⲀϢ ϪⲈ ⲚϮⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲠⲀⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ⲘⲈⲚⲈⲚⲤⲀ ⲔⲈⲔⲞⲨϪⲒ ⲆⲈ ⲀⲨⲒ ⲚϪⲈⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲠⲈϪⲰⲞⲨ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲦⲀⲪⲘⲎ ⲒⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ϨⲰⲔ ⲔⲈ ⲄⲀⲢ ⲦⲈⲔϪⲒⲚⲤⲀϪⲒ ⲞⲨⲰⲚϨ ⲘⲘⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ⲦⲞⲦⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲔⲀⲦⲀⲐⲈⲘⲀⲦⲒⲌⲒⲚ ⲚⲈⲘ ⲈⲰⲢⲔ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲠⲀⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ⲞⲨⲞϨ ⲀⲠⲈⲦⲢⲞⲤ ⲈⲢⲪⲘⲈⲨⲒ ⲘⲠⲒⲤⲀϪⲒ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞϤ ⲚⲀϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲬⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤⲢⲒⲘⲒ ϦⲈⲚⲞⲨⲢⲒⲘⲒ ⲈϤⲚϢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ⲈⲦⲀ ⲦⲞⲞⲨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ⲦⲎⲢⲞⲨ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ϦⲀ ⲒⲎⲤⲞⲨⲤ ϨⲰⲤⲦⲈ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲞⲚϨϤ ⲀⲨⲞⲖϤ ⲀⲨⲦⲎⲒϤ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲠⲒϨⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ⲦⲞⲦⲈ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲦⲀϤⲦⲎ ⲒϤ ϪⲈ ⲀⲨⲈⲢⲔⲀⲦⲀⲔⲢⲒⲚⲒⲚ ⲘⲘⲞϤ ⲈⲦⲀϤⲞⲨⲈⲘϨⲐⲎ ϤⲀϤⲦⲀⲤⲐⲞ ⲚϮⲖ ⲚϨⲀⲦ ϨⲀ ⲚⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲈⲢⲚⲞⲂⲒ ϪⲈ ⲀⲒϮ ⲚⲞⲨⲤⲚⲞϤ ⲚⲐⲘⲎⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲀϦⲞⲚ ⲀⲚⲞⲚ ⲚⲐⲞⲔ ⲈⲔⲈⲢⲰϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ⲞⲨⲞϨ ⲀϤⲂⲞⲢⲂⲈⲢ ⲚⲚⲒϨⲀⲦ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲞϪϨϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲈⲦⲀⲨϬⲒ ⲚⲚⲒϨⲀⲦ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲤϢⲈ ⲀⲚ ⲈϨⲒⲦⲞⲨ ⲈⲠⲒⲔⲞⲢⲂⲀⲚⲞⲚ ϪⲈ ⲦⲦⲒⲘⲎ ⲚⲞⲨⲤⲚⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ⲈⲦⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ⲆⲈ ⲀⲨϢⲰⲠ ⲈⲂⲞⲖ ⲚϨⲎⲦⲞⲨ ⲘⲠⲒⲒⲞϨⲒ ⲚⲦⲈⲠⲒⲔⲈⲢⲀⲘⲈⲨⲤ ⲈⲨⲘⲀⲚⲐⲰⲘⲤ ⲚⲚⲒϢⲈⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲨⲘⲞⲨϮ ⲈⲪⲢⲀⲚ ⲘⲠⲒⲒⲞϨⲒ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ⲪⲒⲞϨⲒ ⲘⲠⲒⲤⲚⲞϤ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ⲦⲞⲦⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲒⲈⲢⲈⲘⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϬⲒ ⲚϮⲖ ⲚϨⲀⲦ ϮⲦⲒⲘⲎ ⲚⲦⲈⲪⲎ ⲈⲦⲀⲨⲈⲢⲦⲒⲘⲎ ⲈⲢⲞϤ ⲚϪⲈⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ⲞⲨⲞϨ ⲀⲨⲦⲎⲒⲦⲞⲨ ϦⲀ ⲪⲒⲞϨⲒ ⲘⲠⲒⲔⲈⲢⲀⲘⲈⲨⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚϪⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒϨⲎ ⲄⲈⲘⲰⲚ ⲞⲨⲞϨ ⲀϤϢⲈⲚϤ ⲚϪⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ⲞⲨⲞϨ ϦⲈⲚⲠϪⲒⲚⲐⲢⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲚϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀϤ ϪⲈ ⲔⲤⲰⲦⲈⲘ ⲀⲚ ϪⲈ ⲀⲤⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲔ ⲚⲞⲨⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ⲞⲨⲞϨ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲞⲨⲂⲈ ϨⲖⲒ ⲚⲤⲀϪⲒ ϨⲰⲤⲦⲈ ⲚⲦⲈϤⲈⲢϢⲪⲎⲢⲒ ⲚϪⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ⲔⲀⲦⲀ ⲠϢⲀⲒ ⲆⲈ ⲚⲈⲦⲔⲀϨⲤ ⲘⲠⲒϨⲎ ⲄⲈⲘⲰⲚ ⲦⲈ ⲈⲬⲀ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲤⲞⲚϨ ⲘⲠⲒⲘⲎϢ ⲪⲎ ⲈϢⲀⲨⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲆⲈ ⲈϤⲤⲞⲚϨ ⲚⲦⲞⲦⲞⲨ ⲘⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲞⲨⲤⲞⲚⲒ ⲠⲈ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲈⲨⲘⲀ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ⲈⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲚⲦⲀⲬⲀϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲂⲀⲢⲀⲂⲂⲀⲤ ϢⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ⲚⲀϤⲈⲘⲒ ⲄⲀⲢ ⲠⲈ ϪⲈ ⲈⲦⲀⲨⲦⲎⲒϤ ⲈⲐⲂⲈ ⲞⲨⲪⲐⲞⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ⲈϤϨⲈⲘⲤⲒ ⲆⲈ ϨⲒ ⲠⲒⲂⲎⲘⲀ ⲀⲤⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϪⲈⲦⲈϤⲤϨⲒⲘⲒ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲖⲒ ⲘⲠⲒⲐⲘⲎⲒ ⲈⲦⲦⲎ ⲀⲒϢⲈⲠ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚϦⲒⲤⲒ ⲈⲐⲂⲎⲦϤ ⲘⲠⲀⲒⲈϪⲰⲢϨ ϦⲈⲚⲐⲢⲀⲤⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲐⲈⲦϨⲐⲎⲞⲨ ⲚⲚⲒⲘⲎϢ ϨⲒⲚⲀ ⲚⲤⲈⲈⲢⲈⲦⲒⲚ ⲘⲂⲀⲢⲀⲂⲂⲀⲤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲤⲈⲦⲀⲔⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ⲀϤⲈⲢⲞⲨⲰ ⲞⲨⲚ ⲚϪⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ⲈⲦⲈⲦⲈⲚⲞⲨⲀϢϤ ⲚⲦⲀⲬⲀϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲂ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ⲚⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ϪⲈ ⲘⲀⲢⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ϪⲈ ⲞⲨ ⲄⲀⲢ ⲠⲈⲦϨⲰⲞⲨ ⲈⲦⲀϤⲀⲒϤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ϤⲚⲀϪⲈⲘϨⲎⲞⲨ ⲚϨⲖⲒ ⲀⲚ ⲀⲖⲖⲀ ⲘⲀⲖⲖⲞⲚ ⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ⲀϤϬⲒ ⲚⲞⲨⲘⲰⲞⲨ ⲀϤⲒⲀ ⲚⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲘⲎϢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲒ ⲚⲀⲐⲚⲞⲂⲒ ⲈⲂⲞⲖ ϨⲀ ⲠⲤⲚⲞϤ ⲚⲦⲈⲠⲀⲒⲐⲘⲎⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲈⲢⲰϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲦⲎⲢϤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲈϤⲤⲚⲞϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ⲚⲈⲘ ⲈϪⲈⲚ ⲚⲈⲚϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ⲦⲞⲦⲈ ⲀϤⲬⲀ ⲂⲀⲢⲀⲂⲂⲀⲤ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲈⲢⲪⲢⲀⲄⲈⲖⲖⲒⲞⲚ ⲘⲘⲞϤ ⲀϤⲦⲎⲒϤ ⲈⲐⲢⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ⲦⲞⲦⲈ ⲚⲒⲘⲀⲦⲞⲒ ⲚⲦⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲀⲨⲈⲖ ⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲀⲨⲐⲰⲞⲨϮ ⲚϮⲤⲠⲒⲢⲀ ⲦⲎⲢⲤ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ⲞⲨⲞϨ ⲈⲦⲀⲨⲂⲀϢϤ ⲀⲨϮ ⲬⲖⲀⲘⲒⲤ ⲚⲔⲞⲔⲔⲞⲤ ϨⲒⲰⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ⲞⲨⲞϨ ⲀⲨϢⲰⲚⲦ ⲚⲞⲨⲬⲖⲞⲘ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲤⲞⲨⲢⲒ ⲀⲨⲦⲎⲒϤ ⲈϪⲈⲚ ⲦⲈϤⲀⲪⲈ ⲞⲨⲞϨ ⲀⲨⲬⲰ ⲚⲞⲨⲔⲀϢ ϦⲈⲚⲦⲈϤϪⲒϪ ⲚⲞⲨⲒⲚⲀⲘ ⲞⲨⲞϨ ⲀⲨϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈϪⲈⲚ ⲚⲞⲨⲔⲈⲖⲒ ⲘⲠⲈϤⲘⲐⲞ ⲈⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲈⲢⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲒⲐⲀϤ ⲈϦⲞⲨⲚ ϦⲈⲚⲠⲈϤϨⲞ ⲀⲨⲰⲖⲒ ⲘⲠⲒⲔⲀϢ ⲀⲨϨⲒⲞⲨⲒ ϦⲈⲚⲦⲈϤⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ⲞⲨⲞϨ ⲈⲦⲀⲨⲞⲨⲰ ⲈⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲀⲨⲂⲀϢϤ ⲚϮⲬⲖⲀⲘⲒⲤ ⲀⲨϮ ⲚⲚⲈϤϨⲂⲰⲤ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲀⲨⲞⲖϤ ⲈⲐⲢⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ⲈⲨⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨϪⲒⲘⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲔⲨⲢⲒⲚⲚⲈⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ ⲪⲀⲒ ⲀⲨϬⲒⲦϤ ⲚⲬⲂⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲖ ⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲨⲘⲀ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲄⲞⲖⲄⲞⲐⲀ ⲈⲦⲈ ⲠⲒⲘⲀ ⲚⲦⲈⲠⲒⲔⲢⲀⲚⲒⲞⲚ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ⲀⲨϮ ⲚⲞⲨⲎⲢⲠ ⲚⲀϤ ⲈϤⲘⲞϪⲦ ⲚⲈⲘ ⲞⲨϢⲀϢⲒ ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈⲘϮⲠⲒ ⲘⲠⲈϤⲞⲨⲰϢ ⲈⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ⲈⲦⲀⲨⲀϢϤ ⲆⲈ ⲀⲨⲪⲰϢ ⲚⲚⲈϤϨⲂⲰⲤ ⲈϨⲢⲀⲨ ⲈⲀⲨϨⲒⲰⲠ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ⲞⲨⲞϨ ⲚⲀⲨϨⲈⲘⲤⲒ ⲈⲨⲀⲢⲈϨ ⲈⲢⲞϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ⲞⲨⲞϨ ⲀⲨⲤϦⲈ ⲦⲈϤⲈⲦⲒⲀ ⲤⲀⲠϢⲰⲒ ⲚⲦⲈϤⲀⲪⲈ ⲈⲤⲤϦⲎⲞⲨⲦ ⲘⲠⲀⲒⲢⲎϮ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ⲦⲞⲦⲈ ⲀⲨⲈϢ ⲔⲈⲤⲞⲚⲒ ⲂⲚⲈⲘⲀϤ ⲞⲨⲀⲒ ⲤⲀⲦⲈϤⲞⲨⲒⲚⲀⲘ ⲚⲈⲘ ⲞⲨⲀⲒ ⲤⲀⲦⲈϤϪⲀϬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ⲚⲎ ⲆⲈ ⲈⲚⲀⲨⲤⲒⲚⲒ ⲚⲀⲨϪⲈⲞⲨⲀ ⲈⲢⲞϤ ⲈⲨⲔⲒⲘ ⲚⲦⲞⲨⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲂⲈⲖ ⲠⲒⲈⲢⲪⲈⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈϤⲔⲞⲦϤ ϦⲈⲚⲄⲚⲈϨⲞⲞⲨ ⲚⲀϨⲘⲈⲔ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲒ ⲠⲒϢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ϪⲈ ⲀϤⲚⲞϨⲈⲘ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲚⲀϨⲘⲈϤ ⲒⲤϪⲈ ⲠⲞⲨⲢⲞ ⲘⲠⲒⲤⲖ ⲠⲈ ⲘⲀⲢⲈϤⲒ ⲈⲠⲈⲤⲎⲦ ϮⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒ ⲠⲒϢⲈ ⲞⲨⲞϨ ⲚⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ⲒⲤϪⲈ ϨⲐⲎϤ ⲬⲎ ⲈⲪⲚⲞⲨϮ ⲘⲀⲢⲈϤⲚⲀϨⲘⲈϤ ⲒⲤϪⲈ ϤⲞⲨⲀϢϤ ⲀϤϪⲞⲤ ⲄⲀⲢ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ⲪⲀⲒ ⲆⲈ ⲈⲚⲀⲢⲈ ⲚⲒⲔⲈⲤⲞⲚⲒ ϪⲰ ⲘⲘⲞϤ ⲚⲎ ⲈⲦⲀⲨⲀϢⲞⲨ ⲚⲈⲘⲀϤ ⲈⲨϮϢϬⲚⲎⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ⲒⲤϪⲈⲚ ⲪⲚⲀⲨ ⲚⲀϪⲠ ⲀⲠⲬⲀⲔⲒ ϢⲰⲠⲒ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲦⲎⲢϤ ϢⲀ ⲪⲚⲀⲨ ⲚⲀϪⲠ Ⲑ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ⲈⲦⲀ ⲪⲚⲀⲨ ⲆⲈ ⲚⲀϪⲠ ⲐϢⲰⲠⲒ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϦⲢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲖⲰⲒ ⲈⲖⲰⲒ ⲖⲈⲘⲀ ⲤⲀⲂⲀⲔⲐⲀⲚⲒ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲠⲀⲚⲞⲨϮ ⲠⲀⲚⲞⲨϮ ⲈⲐⲂⲈⲞⲨ ⲀⲔⲬⲀⲦ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲘⲘⲀⲨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤⲘⲞⲨϮ ⲞⲨⲂⲈ ⲎⲖⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤϬⲞϪⲒ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀϤϬⲒ ⲚⲞⲨⲤⲪⲞⲄⲄⲞⲤ ⲀϤⲘⲀϨⲤ ⲚϨⲈⲘϪ ⲞⲨⲞϨ ⲀϤⲐⲞⲔⲤ ⲈⲞⲨⲔⲀϢ ⲀⲨⲦⲤⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ⲠⲤⲈⲠⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀⲤ ⲚⲦⲈⲚⲚⲀⲨ ϪⲈ ϤⲚⲎⲞⲨ ⲚϪⲈⲎⲖⲒⲀⲤ ⲚⲦⲈϤⲚⲀϨⲘⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲚ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϦⲢⲰⲞⲨ ⲀϤϮ ⲘⲠⲒⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ⲞⲨⲞϨ ⲒⲤ ⲠⲒⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲪⲰϪⲒ ⲒⲤϪⲈⲚ ⲠϢⲰⲒ ⲈⲠⲈⲤⲎⲦ ⲀϤⲈⲢⲂ ⲞⲨⲞϨ ⲠⲒⲔⲀϨⲒ ⲀϤⲘⲞⲚⲘⲈⲚ ⲞⲨⲞϨ ⲚⲒⲠⲈⲦⲢⲀ ⲀⲨⲪⲰϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ⲞⲨⲞϨ ⲚⲒⲘϨⲀⲨ ⲀⲨⲞⲨⲰⲚ ⲞⲨⲞϨ ⲞⲨⲘⲎ ϢⲚⲤⲰⲘⲀ ⲚⲦⲈⲚⲎ ⲈⲦⲀⲨⲚⲔⲞⲦ ⲚⲦⲈⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘϨⲀⲨ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲈϤⲦⲰⲚϤ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈϮⲂⲀⲔⲒ ⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ⲈⲨⲀⲢⲈϨ ⲈⲒⲎⲤⲞⲨⲤ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲠⲒⲘⲞⲚⲘⲈⲚ ⲚⲈⲘ ⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲀⲨⲈⲢϨⲞϮ ⲈⲘⲀϢⲰ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀⲪⲘⲎⲒ ⲚⲈⲪⲀⲒ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲆⲈ ⲚⲤϨⲒⲘⲒ ⲘⲘⲀⲨ ⲈⲨⲚⲀⲨ ϨⲒⲪⲞⲨⲈⲒ ⲈⲦⲈ ⲚⲀⲒ ⲚⲎ ⲈⲦⲀⲨⲘⲞϢⲒ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲈⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ⲚⲀⲒ ⲈⲦⲈⲚⲀⲢⲈ ⲘⲀⲢⲒⲀ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲠⲈ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲐⲀ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲐⲘⲀⲨ ⲚⲒⲰⲤⲎⲪ ⲚⲈⲘ ⲐⲘⲀⲨ ⲚⲚⲈⲚϢⲎ ⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀϤⲒ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲚⲢⲀⲘⲀⲞ ⲈⲂⲞⲖ ϦⲈⲚⲀⲢⲒⲘⲀⲐⲈⲀⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ ⲪⲀⲒ ϨⲰϤ ⲚⲈⲀϤⲈⲢ ⲘⲀⲐⲎⲦⲎⲤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ⲪⲀⲒ ⲈⲦⲀϤⲒ ϨⲀ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲈⲢⲈⲦⲒⲚ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲦⲞⲦⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲦⲎⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ⲞⲨⲞϨ ⲀϤϬⲒ ⲘⲠⲒⲤⲰⲘⲀ ⲚϪⲈⲒⲰⲤⲎⲪ ⲀϤⲔⲞⲨⲖⲰⲖϤ ϦⲈⲚⲞⲨϢⲈⲚⲦⲰ ⲈⲤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ⲞⲨⲞϨ ⲀϤⲬⲀϤ ϦⲈⲚⲠⲈϤⲘϨⲀⲨ ⲘⲂⲈⲢⲒ ⲪⲎ ⲈⲦⲀϤϢⲞⲔϤ ϦⲈⲚϮⲠⲈⲦⲢⲀ ⲞⲨⲞϨ ⲀϤⲤⲔⲞⲢⲔⲈⲢ ⲚⲞⲨⲚⲒϢϮ ⲚⲰⲚⲒ ⲈⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ ⲀϤϨⲰⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ⲚⲀⲤⲬⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚϪⲈⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ϮⲔⲈⲘⲀⲢⲒⲀ ⲈⲨϨⲈⲘⲤⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲈⲦⲈ ⲘⲈⲚⲈⲚⲤⲀ ϮⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϨⲀ ⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲀⲚⲈⲢⲪⲘⲈⲨⲒ ϪⲈ ⲀⲠⲒⲠⲖⲀⲚⲞⲤ ⲈⲦⲈⲘⲘⲀⲨ ϪⲞⲤ ⲒⲤϪⲈⲚ ⲈϤⲞⲚϦ ϪⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ϮⲚⲀⲦⲰⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲞⲨⲚ ⲈⲦⲀϪⲢⲞ ⲘⲠⲒⲘϨⲀⲨ ϢⲀ ⲠⲒⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ ⲘⲎⲠⲰⲤ ⲚⲦⲞⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲞⲨⲞⲖϤ ⲚϬⲒⲞⲨⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϪⲞⲤ ⲘⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ⲚⲦⲈϮϦⲀⲎ ⲘⲠⲖⲀⲚⲎ ⲦϨⲞ ⲚⲀⲚ ⲈϮϨⲞⲨⲒϮ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚ ⲚⲦⲰⲦⲈⲚ ⲘⲘⲀⲨ ⲚϨⲀⲚⲔⲞⲨⲤⲦⲰⲆⲒⲀ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲦⲀϪⲢⲞϤ ⲘⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲀⲨⲦⲀϪⲢⲞ ⲘⲠⲒⲘϨⲀⲨ ⲀⲨⲦⲞⲂϤ ⲚⲈⲘ ϮⲔⲞⲨⲤⲦⲰⲆⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ⲢⲞⲨϨⲒ ⲆⲈ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲞⲞⲨⲒ ⲈⲪⲞⲨⲀⲒ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲤⲒ ⲚϪⲈⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ϮⲔⲈⲘⲀⲢⲒⲀ ⲈⲚⲀⲨ ⲈⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲚⲒϢϮ ⲘⲘⲞⲚⲘⲈⲚ ⲀϤϢⲰⲠⲒ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲀϤⲤⲔⲞⲢⲔⲈⲢ ⲘⲠⲒⲰⲚⲒ ⲈⲂⲞⲖ ϨⲒ ⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲚⲀϤϨⲈⲘⲤⲒ ϨⲒϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ⲠⲈϤⲤⲘⲞⲦ ⲆⲈ ⲚⲀϤⲞⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲤⲈⲦⲈⲂⲢⲎ ϪⲞⲨⲞϨ ⲦⲈϤϨⲈⲂⲤⲰ ⲈⲤⲞⲨⲞⲂϢ ⲘⲪⲢⲎϮ ⲚⲞⲨⲬⲒⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ⲈⲂⲞⲖ ⲆⲈ ϦⲈⲚⲦⲈϤϨⲞϮ ⲀⲨⲘⲞⲚⲘⲈⲚ ⲚϪⲈⲚⲎ ⲈⲦⲀⲢⲈϨ ⲞⲨⲞϨ ⲀⲨⲈⲢ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲢⲈϤⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲠⲈϪⲀϤ ⲚⲚⲒϨⲒⲞⲘⲒ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲚⲐⲰⲦⲈⲚ ϮⲈⲘⲒ ⲄⲀⲢ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲀⲨⲀϢϤ ⲠⲈⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ϤⲬⲎ ⲘⲠⲀⲒⲘⲀ ⲀⲚ ⲀϤⲦⲰⲚϤ ⲄⲀⲢ ⲘⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲀⲘⲰⲒⲚⲒ ⲀⲚⲀⲨ ⲈⲠⲒⲘⲀ ⲈⲚⲀϤⲬⲎ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ⲞⲨⲞϨ ⲚⲬⲰⲖⲈⲘ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲀϪⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ϤⲚⲀⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲈⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀⲢⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞϤ ⲘⲘⲀⲨ ⲒⲤ ϨⲎⲠⲠⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲚⲬⲰⲖⲈⲘ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘϨⲀⲨ ϦⲈⲚⲞⲨϨⲞϮ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ⲞⲨⲞϨ ⲚⲀⲨϬⲞϪⲒ ⲈⲦⲀⲘⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ⲞⲨⲞϨ ⲒⲤ ϨⲎⲠⲠⲈ ⲀϤⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲈⲢⲈⲦⲈ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲀⲘⲞⲚⲒ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲦⲀⲘⲈ ⲚⲀⲤⲚⲎⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲈ ⲚⲰⲞⲨ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲚⲤⲈⲚⲀⲨ ⲈⲢⲞⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲒⲤ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲞⲨⲤⲦⲰⲆⲒⲀ ⲀⲨⲒ ⲈϮⲂⲀⲔⲒ ⲀⲨⲦⲀⲘⲈ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ⲞⲨⲞϨ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ⲀⲨϬⲒ ⲚϨⲀⲚϨⲀⲦ ⲈⲨⲘⲠϢⲀ ⲀⲨⲦⲎⲒⲦⲞⲨ ⲚⲚⲒⲘⲀⲦⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ϪⲈ ⲀϪⲞⲤ ϪⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀⲨⲒ ⲚϪⲰⲢϨ ⲀⲨⲞⲖϤ ⲚϬⲒⲞⲨⲒ ϨⲰⲤ ⲆⲈ ⲈⲚⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲤⲰⲦⲈⲘ ⲈⲠⲀⲒⲤⲀϪⲒ ⲈⲚⲈⲐⲈⲦϨⲐⲎϤ ⲀⲚⲞⲚ ⲞⲨⲞϨ ⲈⲚⲈⲈⲢ ⲐⲎⲚⲞⲨ ⲚⲀⲐⲢⲰⲞⲨϢ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨϬⲒ ⲚⲚⲒϨⲀⲦ ⲀⲨⲒⲢⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀⲨⲤⲀⲂⲰⲞⲨ ⲞⲨⲞϨ ⲀⲠⲀⲒⲤⲀϪⲒ ⲤⲰⲢ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ⲠⲒⲒⲀ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϮⲚⲈⲒ ⲚⲰⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲀⲨϬⲒⲤⲀⲚⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϮⲈⲢϢⲒϢⲒ ⲚⲒⲂⲈⲚ ⲚⲎⲒ ϦⲈⲚⲦⲪⲈ ⲚⲈⲘ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲞⲨⲚ ⲘⲀⲤⲂⲰ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲢⲈⲦⲈⲚⲰⲘⲤ ⲘⲘⲰⲞⲨ ⲈⲪⲢⲀⲚ ⲘⲪⲒⲰⲦ ⲚⲈⲘ ⲠϢⲎⲢⲒ ⲚⲈⲘ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ⲈⲢⲈⲦⲈⲚϮⲤⲂⲰ ⲚⲰⲞⲨ ⲈⲀⲢⲈϨ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲒϨⲈⲚϨⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲒⲤ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮⲬⲎ ⲚⲈⲘⲰⲦⲈⲚ ⲚⲚⲒⲈϨⲞⲞⲨ ⲦⲎⲢⲞⲨ ϢⲀ ⲠϪⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒⲈⲚⲈϨ ⲀⲘⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ⲦⲀⲢⲬⲎ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϦⲈⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲞⲨⲰⲢⲠ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ ϦⲀⲦϨⲎ ⲘⲠⲈⲔϨⲞ ⲪⲎ ⲈⲐⲚⲀⲤⲞⲂϮ ⲘⲠⲈⲔⲘⲰⲒⲦ ϦⲀϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ⲠϦⲢⲰⲞⲨ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϢⲀϤⲈ ϪⲈ ⲤⲈⲂⲦⲈ ⲪⲘⲰⲒⲦ ⲘⲠϬⲞⲒⲤ ⲤⲞⲨⲦⲈⲚ ⲚⲈϤⲘⲀⲚⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ϨⲒ ⲠϢⲀϤⲈ ⲞⲨⲞϨ ⲈϤϨⲒⲰⲒϢ ⲚⲞⲨⲰⲘⲤ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ϦⲈⲚⲞⲨⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈϨⲀⲚⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲀ ϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲬⲰⲢⲀ ⲚⲈⲘ ⲚⲀ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨϬⲒⲰⲘⲤ ⲚⲦⲞⲦϤ ϦⲈⲚⲠⲒⲒⲞⲢⲆⲀⲚⲎ ⲤⲚⲒⲀⲢⲞ ⲈⲨⲞⲨⲰⲚϨ ⲚⲚⲞⲨⲚⲞⲂⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ⲚⲀⲢⲈ ϨⲀⲚϤⲰⲒ ⲚϬⲀⲘⲞⲨⲖ ⲦⲞⲒ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲈϤⲘⲎⲢ ⲚⲞⲨⲘⲞϪϦ ⲚϢⲀⲢ ⲈϪⲈⲚ ⲦⲈϤϮⲠⲒ ⲞⲨⲞϨ ⲚⲀϤⲞⲨⲈⲘ ϢϪⲈ ⲚⲈⲘ ⲈⲂⲒⲰ ⲚⲦⲈⲦⲔⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ⲞⲨⲞϨ ⲚⲀϤϨⲒⲰⲒϢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲚⲎ ⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ⲚϪⲈⲪⲎ ⲈⲦϪⲞⲢ ⲈϨⲞⲦⲈⲢⲞⲒ ⲪⲎ ⲈⲦⲈ ⲚϮⲘⲠϢⲀ ⲀⲚ ⲈϪⲞⲂⲤⲦ ⲈϦⲢⲎⲒ ⲈϮⲞⲨⲰ ⲚⲞⲨⲘⲞⲨⲤⲈⲢ ⲚⲦⲈⲠⲈϤⲐⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ⲀⲚⲞⲔ ⲈⲦⲀⲒϮⲰⲘⲤ ⲚⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲚⲐⲞϤ ⲆⲈ ϤⲚⲀⲈⲘⲤ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲌⲀⲢⲈⲐ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲀϤϬⲒⲰⲘⲤ ϦⲈⲚⲠⲒⲒⲞⲢⲆⲀⲚⲎ ⲤⲚⲦⲞⲦϤ ⲚⲒⲰⲀⲚⲚⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲈϤⲚⲎⲞⲨ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲞⲨ ⲀϤⲚⲀⲨ ⲈⲚⲒⲪⲎⲞⲨⲒ ⲈⲀⲨⲪⲰϦ ⲞⲨⲞϨ ⲠⲒⲠⲚⲈⲨⲘⲀⲀϤⲒ ⲈϦⲢⲎⲒ ⲈϪⲰϤ ⲘⲪⲢⲎϮ ⲚⲞⲨϬⲢⲞⲘⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ⲞⲨⲞϨ ⲞⲨⲤⲘⲎ ⲚⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲠⲀⲘⲈⲚⲢⲒⲦ ⲈⲦⲀⲒϮⲘⲀϮ ⲚϦⲎⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲠⲒⲠⲚⲈⲨⲘⲀϨⲒⲦϤ ⲈⲂⲞⲖ ⲈⲠϢⲀϤⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲠⲈ ϨⲒ ⲠϢⲀϤⲈ ⲚⲘⲚⲈϨⲞⲞⲨ ⲚⲈⲘ ⲚⲈϪⲰⲢϨ ⲈϤⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲚϪⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲠⲈ ⲚⲈⲘ ⲚⲒⲐⲎ ⲢⲒⲞⲚ ⲞⲨⲞϨ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲞⲨϮ ⲆⲈ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲈϤϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ⲞⲨⲞϨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲤⲎⲞⲨ ⲞⲨⲞϨ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲞⲨⲞϨ ⲚⲀϨϮ ⲈⲠⲒⲈⲨⲀⲄⲄⲖⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲀ ⲪⲒⲞⲘ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀϤⲚⲀⲨ ⲈⲤⲒⲘⲰⲚ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲈⲨϨⲒ ϢⲚⲈ ⲚⲤⲒϮ ⲈⲪⲒⲞⲘ ϪⲈ ⲞⲨⲎⲒ ⲄⲀⲢ ⲚⲈϨⲀⲚⲞⲨⲞϨⲒ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲚⲦⲀⲈⲢ ⲐⲎⲚⲞⲨ ⲚϨⲀⲚⲞⲨⲞϨⲒ ⲚⲢⲈϤⲦⲀϨⲈ ⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ⲞⲨⲞϨ ⲀⲨⲬⲀ ⲚⲒϢⲚⲎⲞⲨ ⲚⲤⲰⲞⲨ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲦϨⲎ ⲚⲔⲈⲔⲞⲨϪⲒ ⲀϤⲚⲀⲨ ⲈⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϤⲤⲞⲚ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲈⲨϨⲒ ⲠⲒϪⲞⲒ ⲈⲨⲤⲞⲂϮ ⲚⲚⲞⲨϢⲚⲎⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲬⲀ ⲠⲞⲨⲒⲰⲦ ⲚⲤⲰⲞⲨ ⲌⲈⲂⲈⲆⲈⲞⲤ ϨⲒ ⲠⲒϪⲞⲒ ⲚⲈⲘ ⲚⲒⲘⲒⲤⲐⲰⲦⲎⲤ ⲀⲨϢⲈⲚ ⲰⲞⲨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲤⲀⲦⲞⲦϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ⲦⲈϤⲤⲂⲰ ⲚⲀϤϮⲤⲂⲰ ⲄⲀⲢ ⲚⲰⲞⲨ ⲠⲈ ϨⲰⲤ ⲈⲢⲈ ⲠⲈϤⲈⲢϢⲒϢⲒ ⲚⲦⲞⲦϤ ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲀⲚ ⲚⲚⲒⲤⲀϦ ");
INSERT INTO copbhc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲈϤϦⲈⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲞⲨⲞϨ ⲀϤⲰϢ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϦⲞⲔ ⲚⲈⲘⲀⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲈⲦⲀⲔⲒ ⲈⲦⲀⲔⲞⲚ ⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲔ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠⲒⲀⲄⲒⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲐⲰⲘ ⲚⲢⲰⲔ ⲞⲨⲞϨ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ⲞⲨⲞϨ ⲀϤϢⲦⲈⲢⲐⲰⲢϤ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲞⲨⲞϨ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϦⲢⲰⲞⲨ ⲀϤⲒ ⲈⲂⲞⲖ ϨⲒⲰⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ⲦⲎⲢⲞⲨ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨⲔⲰϮ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲞⲨⲤⲂⲰ ⲘⲂⲈⲢⲒ ⲠⲈ ϪⲈ ϦⲈⲚⲞⲨⲈⲢϢⲒϢⲒ ϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ⲞⲨⲞϨ ⲀⲦⲈϤⲤⲘⲎ ⲤⲰⲢ ⲈⲂⲞⲖ ϦⲈⲚϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲞⲨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲈⲢⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ⲦϢⲰⲘⲒ ⲆⲈ ⲚⲤⲒⲘⲰⲚ ⲚⲀⲤⲚⲔⲞⲦ ⲠⲈ ⲈⲤϦⲎⲘ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨϪⲞⲤ ⲚⲀϤ ⲈⲐⲂⲎ ⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ⲞⲨⲞϨ ⲀϤⲒ ⲀϤⲦⲞⲨⲚⲞⲤⲤ ⲈⲀϤⲀⲘⲞⲚⲒ ⲚⲦⲈⲤϪⲒϪ ⲞⲨⲞϨ ⲀϤⲬⲀⲤ ⲚϪⲈⲠⲒϦⲘⲞⲘ ⲞⲨⲞϨ ⲚⲀⲤϢⲈⲘϢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ϨⲞⲦⲈ ⲈⲦⲀ ⲪⲢⲎ ϨⲰⲦⲠ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈ ⲚⲒⲆⲈⲘⲰⲚ ⲚⲈⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ⲞⲨⲞϨ ϮⲂⲀⲔⲒ ⲦⲎⲢⲤ ⲀⲤⲐⲰⲞⲨϮ ϨⲒⲢⲈⲚ ⲠⲒⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲞⲨⲘⲎϢ ⲈⲨⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ϦⲈⲚⲞⲨⲘⲎϢ ⲚⲢⲎϮ ⲚϢⲰⲚⲒ ⲞⲨⲞϨ ⲀϤϨⲒ ⲞⲨⲘⲎϢ ⲚⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲀϤⲬⲰ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲤⲀϪⲒ ⲀⲚ ⲠⲈ ϪⲈ ⲞⲨⲎⲒ ⲄⲀⲢ ⲚⲀⲨⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲰⲚϤ ⲚϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲚϢⲞⲢⲠ ⲈⲘⲀϢⲰ ⲀϤⲒ ⲈⲂⲞⲖ ⲈⲨⲘⲀⲚϢⲀϤⲈ ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ⲞⲨⲞϨ ⲚⲀϤϬⲞϪⲒ ⲚⲤⲰϤ ⲚϪⲈⲤⲒⲘⲰⲚ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲈⲘϤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲤⲈⲔⲰϮ ⲚⲤⲰⲔ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀⲢⲞⲚ ⲈⲔⲈⲘⲀ ⲈⲚⲒⲔⲰⲘⲞⲠⲞⲖⲒⲤ ⲈⲦϦⲈⲚⲦ ⲈⲢⲞⲚ ϨⲒⲚⲀ ⲚⲦⲈⲚϨⲒⲰⲒϢ ⲘⲘⲀⲨ ϨⲰϤ ⲈⲦⲀⲒⲒ ⲄⲀⲢ ⲈⲠⲀⲒϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ⲞⲨⲞϨ ⲀϤⲒ ⲈϨⲒⲰⲒϢ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲦⲎⲢⲤ ⲞⲨⲞϨ ⲚⲒⲆⲈⲘⲰⲚ ⲈϤϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ⲞⲨⲞϨ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲔⲀⲔⲤⲈϨⲦ ⲈϤϮϨⲞ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈϤϨⲒⲞⲨⲒ ⲘⲘⲞϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲚⲦⲈⲔⲞⲨⲰϢ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲞⲨⲂⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ⲞⲨⲞϨ ⲀϤϢⲈⲚϨⲎⲦ ϦⲀⲢⲞϤ ⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤϬⲒ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϮⲞⲨⲰϢ ⲘⲀⲦⲞⲨⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲠⲒⲤⲈϨⲦ ϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲀϤⲦⲞⲨⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲢⲈⲘⲢⲰⲘϤ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲤⲀⲦⲞⲦϤ ⲀϤϨⲒⲦϤ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲢⲦⲀⲘⲈ ϨⲖⲒ ⲀⲖⲖⲀ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲀⲦⲀⲘⲈ ⲠⲒⲞⲨⲎⲂ ⲈⲢⲞⲔ ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒ ⲘⲠⲒⲆⲰⲢⲞⲚ ⲈϦⲞⲨⲚ ⲈϪⲈⲚ ⲠⲈⲔⲦⲞⲨⲂⲞ ⲪⲎ ⲈⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲞϤ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲰⲒϢ ⲚⲞⲨⲘⲎϢ ⲞⲨⲞϨ ⲈⲤⲈⲢ ⲠⲈϤⲤⲀϪⲒ ⲈⲂⲞⲖ ϨⲰⲤⲦⲈ ⲚⲦⲈϤϢⲦⲈⲘϢϪⲈⲘϪⲞⲘ ⲈⲒ ⲈϦⲞⲨⲚ ⲈⲂⲀⲔⲒ ⲚⲞⲨⲰⲚϨ ⲀⲖⲖⲀ ⲚⲀϤϢⲞⲠ ⲠⲈ ϦⲈⲚϨⲀⲚⲘⲰⲒⲦ ⲚϢⲀϤⲈ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ⲞⲨⲞϨ ⲀϤⲒ ⲞⲚ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲘⲈⲚⲈⲚⲤⲀ ϨⲀⲚⲈϨⲞⲞⲨ ⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ϤⲚϦⲞⲨⲚ ϦⲈⲚⲞⲨⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ⲞⲨⲞϨ ⲀⲞⲨⲘⲎϢ ⲐⲰⲞⲨϮ ⲈⲘⲀⲨ ϨⲰⲤⲦⲈ ⲚⲦⲈϢⲦⲈⲘ ⲠⲒⲎⲒ ⲰⲖⲒ ϪⲈ ⲞⲨⲆⲈ ϨⲒⲢⲈⲚ ⲠⲒⲢⲞ ⲞⲨⲞϨ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲘⲠⲒⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲀⲒ ⲈϤϢⲎⲖ ⲈⲂⲞⲖ ⲈⲨϤⲀⲒ ⲘⲘⲞϤ ⲚϪⲈⲆⲚⲢⲰⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚⲈⲚϤ ⲈϦⲞⲨⲚ ⲈⲐⲂⲈ ⲠⲒⲘⲎϢ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϪⲈⲚ ⲠϪⲈⲚⲈⲪⲰⲢ ⲀⲨϬⲰⲢⲠ ⲚϮⲞⲨⲀϨⲤⲞⲒ ⲈⲂⲞⲖ ⲚⲦⲈⲠⲒⲎⲒ ⲈⲚⲀⲨⲬⲎ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲰⲔⲒ ⲀⲨⲬⲰ ⲘⲠⲒϬⲖⲞϪ ⲈⲠⲈⲤⲎⲦ ⲈⲦⲈ ⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ⲚⲔⲞⲦ ϨⲒⲰⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲠⲞⲨⲚⲀϨϮ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ⲠⲀϢⲎⲢⲒ ⲚⲈⲔⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲚⲦⲈⲚⲒⲤⲀϦ ⲘⲘⲀⲨ ⲈⲨϨⲈⲘⲤⲒ ⲞⲨⲞϨ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ϦⲈⲚⲠⲞⲨϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲪⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ϪⲈⲞⲨⲀ ⲚⲒⲘ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ⲈⲂⲎⲖ ⲈⲠⲒⲞⲨⲀⲒ ⲘⲘⲀⲨⲀⲦϤ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲒⲎⲤⲞⲨⲤ ⲈⲘⲒ ϦⲈⲚⲠⲈϤⲠⲚⲈⲨⲘⲀϪⲈ ⲤⲈⲘⲞⲔⲘⲈⲔ ⲘⲠⲀⲒⲢⲎϮ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ⲈⲚⲀⲒ ϦⲈⲚⲚⲈⲦⲈⲚϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ⲞⲨ ⲠⲈⲐⲘⲞⲦⲈⲚ ⲈϪⲞⲤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ⲚⲈⲔⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ϢⲀⲚ ⲈϪⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ");
INSERT INTO copbhc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲠⲈⲢϢⲒϢⲒ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ϪⲈ ⲚⲐⲞⲔ ⲠⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲦⲰⲚⲔ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲈⲔⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲦⲰⲚϤ ⲀϤⲰⲖⲒ ⲘⲠⲈϤϬ ⲖⲞϪ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨⲈⲢϢⲪⲎⲢⲒ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲚⲚⲀⲨ ⲈⲞⲨⲞⲚ ⲠⲀⲒⲢⲎϮ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ϨⲀ ⲪⲒⲞⲘ ⲞⲨⲞϨ ⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲈⲚⲀϤⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ⲞⲨⲞϨ ⲈϤⲤⲒⲚⲒⲰⲞⲨ ⲀϤⲚⲀⲨ ⲈⲖⲈⲨⲒ ⲚⲦⲈⲀⲖⲪⲈⲞⲤ ⲈϤϨⲈⲘⲤⲒ ϨⲒ ⲠⲒⲦⲈⲖⲰⲚⲒⲞⲚ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈϤⲢⲞⲦⲈⲂ ϦⲈⲚⲠⲈϤⲎⲒ ⲚⲈⲞⲨⲞⲚ ϨⲀⲚⲘⲎϢ ⲚⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ϨⲀⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚⲀⲨⲢⲞⲦⲈⲂ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲘⲘⲀⲨ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲠⲈ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ϪⲈ ϤⲞⲨⲰⲘ ⲚⲈⲘ ⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ϤⲞⲨⲰⲘ ⲞⲨⲞϨ ϤⲤⲰ ⲚⲈⲘ ⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚϪⲈⲠⲈⲦⲈⲚⲢⲈϤϮⲤⲂⲰ ");
INSERT INTO copbhc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲈⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲚϪⲈⲚⲎ ⲈⲦϪⲞⲢ ⲘⲠⲒⲤⲎⲒⲚⲒ ⲀⲖⲖⲀ ⲚⲎ ⲈⲐⲘⲞⲔϨ ⲚⲈⲦⲀⲒⲒ ⲄⲀⲢ ⲀⲚ ⲈⲐⲀϨⲈⲘ ⲚⲒⲐⲘⲎⲒ ⲀⲖⲖⲀ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎ ⲤⲚⲈⲘ ⲚⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲞⲨⲞϨ ⲀⲨⲒ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘ ⲚⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲤⲈⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲚⲞⲨⲔ ⲆⲈ ⲤⲈⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲎⲦⲒ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲈⲐⲢⲈ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ϨⲰⲤ ⲈϤⲚⲈⲘⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲬⲢⲞⲚⲞⲤ ⲚⲒⲂⲈⲚ ϨⲰⲤ ⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲚⲈⲘⲰⲞⲨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ⲤⲈⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲰⲖⲒ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲚⲦⲞⲦⲞⲨ ⲦⲞⲦⲈ ⲤⲈⲚⲀⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ⲞⲨ ⲄⲀⲢ ⲘⲠⲀⲢⲈ ϨⲖⲒ ϨⲒ ⲞⲨⲦⲰⲒⲤ ⲘⲂⲈⲢⲒ ⲈⲞⲨϨⲂⲞⲤ ⲚⲀⲠⲀⲤ ⲘⲘⲞⲚ ϢⲀⲢⲈ ⲠⲒⲂⲈⲢⲒ ⲈⲖ ⲠⲒⲘⲞϨ ⲚⲦⲈⲠⲒⲀⲠⲀⲤ ⲞⲨⲞϨ ⲚⲦⲈⲞⲨⲪⲰϦ ϢⲰⲠⲒ ⲈϤϨⲰⲞⲨ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ⲞⲨⲞϨ ⲘⲠⲀⲨϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲚⲀⲠⲀⲤ ⲘⲘⲞⲚ ϢⲀⲢⲈ ⲠⲒⲎⲢⲠ ⲪⲈϦ ⲚⲒⲀⲤⲔⲞⲤ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲠⲒⲎⲢⲠ ⲦⲀⲔⲞ ⲚⲈⲘ ⲚⲒⲀⲤⲔⲞⲤ ⲀⲖⲖⲀ ϢⲀⲨϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲘⲂⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤⲘⲞϢⲒ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲢⲞϮ ⲞⲨⲞϨ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲢϨⲎⲦⲤ ⲈⲨⲘⲞϢⲒ ⲈϤⲈϪ ϦⲈⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲞⲨⲒⲢⲒ ⲘⲘⲞϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲤϢⲈ ⲚⲀⲒϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲦⲈⲚⲰϢ ⲈⲚⲈϨ ϪⲈ ⲞⲨ ⲠⲈⲦⲀϤⲀⲒϤ ⲚϪⲈⲆⲀⲨⲒⲆ ϨⲞⲦⲈ ⲈⲦⲀϤⲈⲢⲬⲢⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲔⲞ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ⲠⲰⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲪⲚⲞⲨϮ ⲚⲀϨⲢⲀϤ ⲚⲀⲂⲒⲀⲐⲀⲢ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲚⲒⲰⲒⲔ ⲚⲦⲈϮⲠⲢⲞⲐⲈⲤⲒⲤ ⲀϤⲞⲨⲞⲘⲞⲨ ⲚⲈⲦⲈⲚⲤϢⲈ ⲚⲀϤ ⲀⲚ ⲈⲞⲨⲞⲘⲞⲨ ⲈⲂⲎⲖ ⲈⲚⲒⲞⲨⲎⲂ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲚⲀⲨⲬⲎ ⲚⲈⲘⲀϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲦⲀ ⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϢⲰⲠⲒ ⲈⲐⲂⲈ ⲠⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲠⲒⲢⲰⲘⲒ ⲀⲚ ⲈⲐⲂⲈ ⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ϨⲰⲤⲦⲈ ⲠϬⲞⲒⲤ ⲘⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ⲞⲨⲞϨ ⲀϤⲒ ⲞⲚ ⲈϦⲞⲨⲚ ⲈⲦⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲘⲘⲀⲨ ⲠⲈ ⲈⲢⲈ ⲦⲈϤϪⲒϪ ϢⲞⲨⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ⲞⲨⲞϨ ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲚⲀϤ ⲠⲈ ϪⲈ ⲀⲚ ϤⲚⲀⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲒⲚⲀ ⲚⲦⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲢⲈ ⲦⲈϤϪⲒϪ ϢⲞⲨⲰⲞⲨ ϪⲈ ⲦⲰⲚⲔ ϦⲈⲚⲐⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤϢⲈ ⲈⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϢⲀⲚ ⲈⲈⲢⲠⲈⲦϨⲰⲞⲨ ⲞⲨⲮⲨⲬⲎ ⲈⲚⲀϨⲘⲈⲤ ϢⲀⲚ ⲈϦⲞⲐⲂⲈⲤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲬⲀⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲢⲰⲞⲨ ϦⲈⲚⲞⲨⲘⲂⲞⲚ ⲈϤⲘⲞⲔϨ ⲚϨⲎⲦ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲐⲰⲘ ⲚⲦⲈⲠⲞⲨϨⲎⲦ ⲠⲈϪⲀϤ ⲘⲠⲒⲢⲰⲘⲒ ϪⲈ ⲤⲞⲨⲦⲈⲚ ⲦⲈⲔϪⲒϪ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲞⲨⲦⲰⲚⲤ ⲀⲤⲞⲨϪⲀⲒ ⲚϪⲈⲦⲈϤϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲤⲀⲦⲞⲦⲞⲨ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀⲨⲒⲢⲒ ⲚⲞⲨⲤⲞϬⲚⲒ ⲚⲈⲘ ⲚⲒⲎⲢⲰⲆⲒⲀⲚⲞⲤ ϦⲀⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲦⲀⲔⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲈⲢⲀⲚⲀⲬⲰⲢⲒⲚ ⲈⲠⲦⲰⲞⲨ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲚⲈⲘ ϮⲒⲞⲨⲆⲈⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ϮϨⲨⲆⲞⲨⲘⲈⲀ ⲚⲈⲘ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ⲚⲈⲘ ⲔⲈⲘⲎϢ ⲈϤⲞϢ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀ ⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲈⲨⲤⲰⲦⲈⲘ ⲈⲚⲎ ⲈⲚⲀϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲀⲨⲒ ϨⲀⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨϪⲞⲒ ⲘⲞⲨⲚ ⲈⲢⲞϤ ⲈⲐⲂⲈ ⲠⲒⲘⲎϢ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘϨⲈϪϨⲰϪϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ϨⲀⲚⲘⲎϢ ⲄⲀⲢ ⲚⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨⲒ ⲈϪⲰϤ ⲚⲦⲞⲨϬⲒ ⲚⲈⲘⲀϤ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲚⲀⲢⲈ ϨⲀⲚⲘⲀⲤⲦⲒⲄⲜ ⲚⲈⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ⲞⲨⲞϨ ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈϢⲰⲠ ⲚⲦⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ϢⲀⲨϨⲒⲦⲞⲨ ⲈϦⲢⲎⲒ ϦⲀⲢⲀⲦϤ ⲞⲨⲞϨ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ⲚⲞⲨⲘⲎ ϢϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲚⲎ ⲈⲚⲀϤⲞⲨⲀϢⲞⲨ ⲚⲐⲞϤ ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ϨⲀⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ⲞⲨⲞϨ ⲀϤⲐⲀⲘⲒⲈ ⲒⲂ ⲚⲎ ⲈⲦⲀϤϮⲢⲈⲚⲞⲨ ϪⲈ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲞϨⲒ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲞⲢⲠⲞⲨ ⲈϨⲒⲰⲒϢ ");
INSERT INTO copbhc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ⲞⲨⲞϨ ⲈⲐⲢⲈ ⲠⲈⲢϢⲒϢⲒ ϢⲰⲠⲒ ⲚⲦⲞⲦⲞⲨ ⲈϨⲒ ⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ⲞⲨⲞϨ ⲀϤϮ ⲚⲞⲨⲢⲀⲚ ⲈⲤⲒⲘⲰⲚ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ⲞⲨⲞϨ ⲒⲀⲔⲰⲂⲞⲤ ⲠϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲞⲨⲞϨ ⲀϤϮ ⲚϨⲀⲚⲢⲀⲚ ⲈⲢⲰⲞⲨ ϪⲈ ⲂⲞⲀⲚⲎⲢⲄⲈⲤ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈϮϦⲀⲢⲀⲂⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ⲀⲚⲆⲢⲈⲀⲤ ⲚⲈⲘ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲂⲀⲢⲐⲞⲖⲞⲘⲈⲞⲤ ⲚⲈⲘ ⲘⲀⲦⲐⲈⲞⲤ ⲚⲈⲘ ⲐⲰⲘⲀⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲦⲈⲀⲖⲪⲈⲞⲤ ⲚⲈⲘ ⲐⲀⲆⲆⲈⲞⲤ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲠⲒⲔⲀⲚⲀⲚⲈⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲪⲎ ⲈⲦⲀϤⲦⲎ ⲒϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲞⲨⲎⲒ ⲞⲨⲞϨ ⲀϤⲐⲰⲞⲨϮ ⲞⲚ ⲚϪⲈⲠⲒⲘⲎϢ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨϢⲦⲈⲘϢϪⲈⲘϪⲞⲘ ⲞⲨⲆⲈ ⲈⲞⲨⲈⲘ ⲰⲒⲔ ");
INSERT INTO copbhc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲎ ⲈⲦⲈⲚⲞⲨϤ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲚⲀⲨϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲀⲠⲈϤϨⲎⲦ ⲤⲒϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲚⲒⲤⲀϦ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲂⲈⲖⲌⲈⲂⲞⲨⲖ ⲈⲐⲚⲈⲘⲀϤ ⲞⲨⲞϨ ϪⲈ ϦⲈⲚⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ ⲀϤϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϪⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲠⲤⲀⲦⲀⲚⲀⲤ ϨⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲪⲰϢ ⲈϨⲢⲀⲤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲤⲞϨⲒ ⲈⲢⲀⲦⲤ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲞⲨⲎⲒ ⲪⲰϢ ⲈϨⲢⲀϤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲠⲈⲦⲀϤⲦⲰⲚϤ ⲈϪⲰϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀϤⲪⲰϢ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲞϨⲒ ⲈⲢⲀⲦϤ ⲀⲖⲖⲀ ⲞⲨⲞⲚⲦⲈϤ ⲞⲨϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ⲀⲖⲖⲀ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒϪⲰⲢⲒ ⲚⲦⲈϤϨⲰⲖⲈⲘ ⲚⲚⲈϤⲤⲔⲈⲨⲞⲤ ⲈⲂⲎⲖ ⲚⲦⲈϤⲤⲰⲚϨ ⲘⲠⲒϪⲰⲢⲒ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲚⲦⲈϤϨⲰⲖⲈⲘ ⲘⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲨⲈⲬⲀⲨ ⲈⲂⲞⲖ ⲚⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲚⲒⲚⲞⲂⲒ ⲚⲈⲘ ⲚⲒϪⲈⲞⲨⲀ ⲦⲎⲢⲞⲨ ⲈⲦⲞⲨⲚⲀϪⲈⲞⲨⲀ ⲘⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϪⲈⲞⲨⲀ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲘⲞⲚ ⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲀϤ ϢⲀ ⲈⲚⲈϨ ⲀⲖⲖⲀ ϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲚⲞⲨⲚⲞⲂⲒ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ϪⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎ ⲞⲨ ⲞⲨⲞϨ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠⲒⲘⲎϢ ϨⲈⲘⲤⲒ ⲘⲠⲈϤⲔⲰϮ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲒⲤ ⲦⲈⲔⲘⲀⲨ ⲚⲈⲘ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲤⲀⲂⲞⲖ ⲈⲨⲔⲰϮ ⲚⲤⲰⲔ ");
INSERT INTO copbhc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲒⲤ ⲦⲀⲘⲀⲨ ⲚⲈⲘ ⲚⲀⲤⲚⲎⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ⲘⲠⲈϤⲔⲰϮ ⲠⲈϪⲀϤ ϪⲈ ⲒⲤ ⲦⲀⲘⲀⲨ ⲚⲈⲘ ⲚⲀⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ⲪⲎ ⲈⲐⲚⲀⲒⲢⲒ ⲘⲠⲈⲦⲈϨⲚⲈ ⲪⲚⲞⲨϮ ⲪⲀⲒ ⲠⲈ ⲠⲀⲤⲞⲚ ⲚⲈⲘ ⲦⲀⲤⲰⲚⲒ ⲚⲈⲘ ⲦⲀⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϮⲤⲂⲰ ⲈⲤⲔⲈⲚ ⲪⲒⲞⲘ ⲞⲨⲞϨ ⲀⲨⲐⲰⲞⲨϮ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ϨⲰⲤⲦⲈ ⲚⲦⲈϤⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲚⲦⲈϤϨⲈⲘⲤⲒ ϦⲈⲚⲪⲒⲞⲘ ϨⲒ ⲠⲒⲬⲢⲞ ");
INSERT INTO copbhc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ⲚϨⲀⲚⲘⲎϢ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϦⲈⲚⲦⲈϤⲤⲂⲰ ");
INSERT INTO copbhc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ϪⲈ ⲤⲰⲦⲈⲘ ϨⲎⲠⲠⲈ ⲀϤⲒ ⲚϪⲈⲪⲎ ⲈⲦⲤⲒϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲠϪⲒⲚⲐⲢⲈϤⲤⲒϮ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲘⲈⲚ ⲀϤϨⲈⲒ ⲈⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲚⲒϨⲀⲖⲀϮ ⲀⲨⲞⲨⲞⲘϤ ");
INSERT INTO copbhc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀⲘⲠⲈⲦⲢⲀ ⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲞⲚ ⲘⲎϢ ⲚⲔⲀϨⲒ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲢⲰⲦ ⲈⲐⲂⲈϪⲈ ⲘⲘⲞⲚⲦⲈϤ ϢⲰⲔ ⲚⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ⲞⲨⲞϨ ϨⲞⲦⲈ ⲈⲦⲀϤϢⲀⲒ ⲚϪⲈⲪⲢⲎ ⲀϤⲈⲢⲔⲀⲨⲘⲀ ⲞⲨⲞϨ ⲈⲐⲂⲈϪⲈ ⲘⲘⲞⲚⲦⲈϤ ⲚⲞⲨⲚⲒ ⲀϤϢⲰⲞⲨⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲚⲒⲤⲞⲨⲢⲒ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈϨⲢⲎⲒ ⲚϪⲈⲚⲒⲤⲞⲨⲢⲒ ⲀⲨⲞϪϨϤ ⲞⲨⲞϨ ⲘⲠⲈϤϮⲞⲨⲦⲀϨ ");
INSERT INTO copbhc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲞⲨⲞⲚ ⲀⲨϨⲈⲒ ⲈϪⲈⲚ ⲞⲨⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲀⲨϮ ⲞⲨⲦⲀϨ ⲈϤⲚⲎⲞⲨ ⲈϨⲢⲎⲒ ⲀϤⲈⲢⲈⲨⲐⲎⲚⲒⲚ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲀϤⲈⲚ ⲖⲔⲈⲞⲨⲀⲒ ⲚⲜ ⲔⲈⲞⲨⲀⲒ ⲚⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲘⲀⲨⲀⲦϤ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰϮ ⲈⲢⲞϤ ⲚⲈⲘ ⲠⲒⲒⲂ ⲈⲐⲂⲈ ⲚⲒⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲠⲈ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈ ⲚⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲦⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲎ ⲆⲈ ⲚⲐⲰⲞⲨ ⲈⲦⲤⲀⲂⲞⲖ ϢⲀⲢⲈ ⲠⲦⲎⲢϤ ϢⲰⲠⲒ ⲚⲰⲞⲨ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ϨⲒⲚⲀ ⲈⲨⲚⲀⲨ ⲚⲦⲞⲨⲚⲀⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘⲚⲀⲨ ⲞⲨⲞϨ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲦⲞⲨⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘⲔⲀϮ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲞⲨⲔⲞⲦⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨⲬⲰ ⲚⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲈⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲞⲨⲞϨ ⲠⲰⲤ ⲚⲒⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲦⲎⲢⲞⲨ ⲦⲈⲦⲈⲚⲚⲀⲤⲞⲨⲰⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ⲪⲎ ⲈⲦⲤⲒϮ ⲀϤⲤⲒϮ ⲘⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ⲚⲀⲒ ⲆⲈ ⲚⲈⲚⲎ ⲈⲦϨⲒⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲠⲒⲘⲀ ⲈⲦⲀⲨⲤⲒϮ ⲘⲠⲒⲤⲀϪⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲞⲨⲤⲰⲦⲈⲘ ⲤⲀⲦⲞⲦϤ ⲆⲈ ϢⲀϤⲒ ⲚϪⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲞⲨⲞϨ ⲚⲦⲈϤⲰⲖⲒ ⲘⲠⲒⲤⲀϪⲒ ⲈⲦⲀⲨⲤⲀⲦϤ ⲚϦⲎⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ⲞⲨⲞϨ ⲚⲀⲒ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ⲠⲈ ⲚⲎ ⲈⲦⲀⲨⲤⲀⲦⲞⲨ ϨⲒϪⲈⲚ ⲚⲒⲘⲀⲘⲠⲈⲦⲢⲀ ⲚⲎ ⲈⲦⲀⲨϢⲀⲚⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ϢⲀⲨϬⲒⲦϤ ϦⲈⲚⲞⲨⲢⲀϢⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲚⲞⲨⲚⲒ ⲚϦⲎⲦⲞⲨ ⲀⲖⲖⲀ ϨⲀⲚⲠⲢⲞⲤⲞⲨⲤⲎⲞⲨ ⲚⲈⲒⲦⲀ ⲀⲢⲈϢⲀⲚ ⲞⲨϨⲞϪϨⲈϪ ϢⲰⲠⲒ ⲒⲈ ⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲤⲀϪⲒ ⲤⲀⲦⲞⲦⲞⲨ ϢⲀⲨⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲞⲨⲞⲚ ⲚⲈⲚⲎ ⲈⲦⲀⲨⲤⲀⲦⲞⲨ ϨⲒϪⲈⲚ ⲚⲒⲤⲞⲨⲢⲒ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ⲞⲨⲞϨ ⲠⲒⲢⲰⲞⲨϢ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲚⲈⲘ ϮⲀⲠⲀⲦⲎ ⲚⲦⲈϮⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲈⲘ ⲚⲒⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲦⲈⲚⲒⲔⲈⲤⲰϪⲠ ⲈⲨⲘⲞϢⲒ ⲚϦⲎⲦⲞⲨ ⲤⲈⲰϪϨ ⲘⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ϢⲀϤⲈⲢ ⲀⲦⲞⲨⲦⲀϨ ");
INSERT INTO copbhc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ⲞⲨⲞϨ ⲚⲎ ϨⲰⲞⲨ ⲈⲦⲀⲨⲤⲀⲦⲞⲨ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲚⲎ ⲈⲦⲀⲨϢⲀⲚⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ϢⲀⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ϢⲀⲨϮⲞⲨⲦⲀϨ ⲞⲨⲀⲒ ⲚⲖ ⲞⲨⲀⲒ ⲚⲜ ⲞⲨⲀⲒ ⲚⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲎⲦⲒ ϢⲀⲨϬⲈⲢⲈ ⲞⲨϦⲎⲂⲤ ϨⲒⲚⲀ ⲚⲤⲈⲬⲀϤ ϦⲀ ⲠⲒⲘⲈⲚⲦ ⲒⲈ ϦⲀ ⲠⲒϬⲖⲞϪ ⲞⲨⲬⲒ ϨⲒⲚⲀ ⲚⲤⲈⲬⲀϤ ϨⲒϪⲈⲚ ϮⲖⲨⲬⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ⲞⲨ ⲄⲀⲢ ⲘⲘⲞⲚ ⲠⲈⲦϨⲎⲠ ⲀϤϢⲦⲈⲘⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲞⲨⲆⲈ ⲘⲠⲀϤϢⲰⲠⲒ ⲈϤϨⲎⲠ ⲈⲂⲎⲖ ϪⲈ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ⲈϤⲞⲨⲰⲚϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ⲠⲈⲦⲈⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲞⲚ ϪⲈ ⲀⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ϦⲈⲚⲠⲒϢⲒ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲘⲘⲞϤ ⲈⲨⲚⲀϢⲒ ⲚⲰⲦⲈⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲦⲞⲨⲦⲞⲨϨⲞ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ⲪⲎ ⲄⲀⲢ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲈⲨⲈϮ ⲚⲀϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲦⲀϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈ ⲚⲦⲞⲦϤ ϢⲀⲨⲞⲖϤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲘⲪⲢⲎϮ ⲚⲞⲨⲢⲰⲘⲒ ⲈϤϨⲒⲞⲨⲒ ⲘⲠⲈϤϪⲢⲞϪ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ⲞⲨⲞϨ ⲚⲦⲈϤⲚⲔⲞⲦ ⲞⲨⲞϨ ϢⲀϤⲦⲰⲚϤ ⲘⲠⲒⲈϪⲰⲢϨ ⲚⲈⲘ ⲠⲒⲈϨⲞⲞⲨ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲠⲒϪⲢⲞϪ ⲐⲎⲚⲒ ⲞⲨⲞϨ ϢⲀϤϢⲒⲎ ϨⲰⲤ ⲚϤⲈⲘⲒ ⲀⲚ ⲚⲐⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ϢⲀⲢⲈ ⲠⲒⲔⲀϨⲒ ⲘⲘⲀⲨⲀⲨⲦϤ ϮⲞⲨⲦⲀϨ ⲚϢⲞⲢⲠ ⲚⲞⲨⲤⲒⲘ ⲒⲦⲀ ⲞⲨϦⲈⲘⲤ ⲒⲦⲀ ϢⲀϤⲘⲞϨ ⲚϪⲈⲪⲎ ⲈⲦϦⲈⲚ ⲠⲒϦⲈⲘⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲪⲞϨ ⲚϪⲈⲠⲒⲞⲨⲦⲀϨ ⲤⲀⲦⲞⲦϤ ϢⲀϤⲞⲨⲰⲢⲠ ⲘⲠⲒⲞⲤϦ ϪⲈⲞⲨⲎ ⲒⲄⲀⲢ ⲀϤⲒ ⲚϪⲈⲠⲒⲰⲤϦ ");
INSERT INTO copbhc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲚⲀⲦⲈⲚⲐⲰⲚ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲞⲨ ⲒⲈ ⲀⲚⲚⲀⲬ ⲀⲤ ϦⲈⲚⲀϢ ⲘⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ⲀⲤⲘⲪⲢⲎϮ ⲚⲞⲨⲚⲀⲪⲢⲒ ⲚϢⲈⲖⲦⲀⲘ ⲐⲎ ⲈⲦⲀⲨϢⲀⲚⲤⲀⲦⲤ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲞⲨⲔⲞⲨϪⲒ ⲦⲈ ⲈⲚⲒϪⲢⲞϪ ⲦⲎⲢⲞⲨ ⲚⲎ ⲈⲦϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲞⲨⲤⲀⲦⲤ ϢⲀⲤⲒ ⲈϨⲢⲎⲒ ⲞⲨⲞϨ ϢⲀⲤϢⲰⲠⲒ ⲈⲤⲞⲒ ⲚⲚⲒϢϮ ⲈⲚⲒⲞⲨⲞϮ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ϢⲀⲤⲒⲢⲒ ⲚϨⲀⲚⲚⲒϢϮ ⲚϪⲀⲖ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨϢϪⲈⲘϪⲞⲘ ⲚϪⲈⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲈⲞⲨⲞϨ ϦⲀ ⲦⲈⲤϦⲎⲒⲂⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲘⲠⲒⲤⲀϪⲒ ⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲘⲠⲀⲒⲢⲎϮ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲚⲀⲨϢϪⲈⲘϪⲞⲘ ⲚⲤⲰⲦⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ⲞⲨⲞϨ ⲬⲰⲢⲒⲤ ⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲀⲚ ⲠⲈ ⲤⲀⲠⲤⲀ ⲆⲈ ⲚⲀϤⲂⲰⲖ ⲘⲠⲦⲎ ⲢϤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲦⲀ ⲢⲞⲨϨⲒ ϢⲰⲠⲒ ϪⲈ ⲘⲀⲢⲈⲚⲤⲒⲚⲒ ⲈⲘⲎⲢ ");
INSERT INTO copbhc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ⲞⲨⲞϨ ⲈⲦⲀⲨⲬⲀ ⲠⲒⲘⲎϢ ⲚⲤⲰⲞⲨ ⲀⲨⲞⲖϤ ⲚⲈⲘⲰⲞⲨ ϨⲰϤ ϨⲒ ⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲚⲀⲢⲈ ϨⲀⲚⲔⲈⲈϪⲎⲞⲨ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ⲞⲨⲞϨ ⲀⲞⲨⲚⲒϢϮ ⲚⲐⲎⲞⲨ ϢⲰⲠⲒ ⲞⲨⲞϨ ⲚⲒϪⲞⲖ ⲚⲀⲨϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈⲠⲒϪⲞⲒ ϨⲰⲤⲦⲈ ϨⲎⲆⲎ ⲚⲦⲈϤⲘⲞϨ ⲚϪⲈⲠⲒϪⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤⲚⲔⲞⲦ ϨⲒⲪⲀϨⲞⲨ ϨⲒϪⲈⲚ ⲠⲒϢϢⲞⲦ ⲞⲨⲞϨ ⲀⲨⲚⲈϨⲤⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲤⲈⲢⲘⲈⲖⲒⲚ ⲚⲀⲔ ⲀⲚ ϪⲈ ⲦⲈⲚⲚⲀⲦⲀⲔⲞ ");
INSERT INTO copbhc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲰⲚϤ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲒⲐⲎ ⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲪⲒⲞⲘ ϪⲈ ⲬⲀⲢⲰⲔ ⲞⲨⲞϨ ⲐⲰⲘ ⲚⲢⲰⲔ ⲞⲨⲞϨ ⲀϤⲔⲎⲚ ⲚϪⲈⲠⲒⲐⲎ ⲞⲨ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϪⲀⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲈⲢϨⲞϮ ⲘⲠⲀⲦⲈ ⲚⲀϨϮ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲠⲈ ⲪⲀⲒ ϪⲈ ⲚⲒⲐⲎⲞⲨ ⲚⲈⲘ ⲪⲒⲞⲘ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲘⲎⲢ ⲈⲪⲒⲞⲘ ⲈⲦⲬⲰⲢⲀ ⲚⲦⲈⲚⲒⲄⲈⲢⲄⲈⲤⲎⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϪⲞⲒ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘϨⲀⲨ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈϤϦⲈⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ⲪⲎ ⲈⲚⲀⲢⲈ ⲠⲈϤⲘⲀⲚϢⲰⲠⲒ ϢⲞⲠ ϦⲈⲚⲚⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲞⲨⲆⲈ ϦⲈⲚⲚⲒⲔⲈϨⲀⲖⲨⲤⲒⲤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚϨⲖⲒ ⲠⲈ ⲈⲤⲞⲚϨϤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ⲈⲐⲂⲈϪⲈ ⲚⲈⲀⲨⲤⲞⲚϨϤ ⲚⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ⲚϨⲀⲚⲠⲈⲆⲎⲤ ⲚⲈⲘ ϨⲀⲚϨⲀⲖⲨⲤⲒⲤ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰⲖⲠ ⲚⲚⲒϨⲀⲖⲨⲤⲒⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲚⲤⲈϦⲞⲘϦⲈⲘ ⲚϪⲈⲚⲒⲠⲈⲆⲎⲤ ⲞⲨⲞϨ ⲚⲈⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲈⲢⲆⲀⲘⲀⲌⲒⲚ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ⲞⲨⲞϨ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲘⲠⲒⲈϪⲰⲢϨ ⲚⲈⲘ ⲠⲒⲈϨⲞⲞⲨ ⲈϤⲬⲎ ϦⲈⲚⲚⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ϦⲈⲚⲚⲒⲦⲰⲞⲨ ⲠⲈ ⲈϤⲰϢ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤϢⲰⲦ ⲘⲘⲞϤ ⲚϨⲀⲚⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲒⲤϪⲈⲚ ϨⲒⲪⲞⲨⲈⲒ ⲀϤϬⲞϪⲒ ⲞⲨⲞϨ ⲀϤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ⲞⲨⲞϨ ⲈⲦⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀϦⲞⲔ ⲚⲈⲘⲎⲒ ϨⲰⲔ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦϬⲞⲤⲒ ϮⲦⲀⲢⲔⲞ ⲘⲘⲞⲔ ⲘⲪⲚⲞⲨϮ ⲘⲠⲈⲢϮϬⲖⲀⲔ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ⲚⲀϤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ϦⲈⲚⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ⲞⲨⲞϨ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲈⲔⲢⲀⲚ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲖⲈⲄⲒⲰⲚ ⲠⲈ ⲠⲀⲢⲀⲚ ϪⲈ ⲦⲈⲚⲈⲢⲞⲨⲘⲎϢ ");
INSERT INTO copbhc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ⲞⲨⲞϨ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲚϨⲀⲚⲘⲎϢ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘⲞⲨⲞⲢⲠ ⲤⲀⲂⲞⲖ ⲚϮⲬⲰⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲄⲈⲖⲎ ⲆⲈ ⲚⲢⲒⲢ ⲈⲤⲞϢ ⲘⲘⲀⲨ ⲠⲈ ⲈⲤⲘⲞⲚⲒ ϦⲀⲦⲈⲚ ⲠⲒⲦⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲞⲢⲠⲦⲈⲚ ⲈⲚⲒⲢⲒⲢ ϨⲒⲚⲀ ⲚⲦⲈⲚϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲢⲦⲞⲚ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲈϢⲀⲨ ⲞⲨⲞϨ ⲀⲤϨⲈⲒ ⲈϦⲢⲎⲒ ⲚϪⲈϮⲀⲄⲈⲖⲎ ϦⲀⲦⲈⲚ ⲠⲒϪⲀϪⲢⲒⲘ ⲈⲪⲒⲞⲘ ⲈⲨⲈⲢ ϢⲞ ⲤⲚⲀⲨ ⲞⲨⲞϨ ⲚⲀⲨⲰϪϨ ⲘⲘⲰⲞⲨ ϦⲈⲚⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲘⲞⲚⲒ ⲘⲘⲰⲞⲨ ⲀⲨⲪⲰⲦ ⲞⲨⲞϨ ⲀⲨϪⲞⲤ ϦⲈⲚϮⲂⲀⲔⲒ ⲚⲈⲘ ϦⲈⲚⲦⲔⲞⲒ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲚⲀⲨ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨⲚⲀⲨ ⲈⲪⲎ ⲈⲚⲀⲢⲈ ⲚⲒⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲈϤϨⲈⲘⲤⲒ ⲈⲢⲈ ⲚⲈϤϨⲂⲰⲤ ⲦⲞⲒ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲈⲢⲈ ⲠⲈϤϨⲎⲦ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ⲞⲨⲞϨ ⲀⲨⲤⲀϪⲒ ϦⲀⲦⲞⲦⲞⲨ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲚⲀⲨ ϪⲈ ⲈⲦⲀⲤϢⲰⲠⲒ ⲚⲀϢ ⲚⲢⲎϮ ⲘⲪⲎ ⲈⲚⲀⲢⲈ ⲚⲒⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲚⲈⲘ ⲈⲐⲂⲈ ⲚⲒⲢⲒⲢ ");
INSERT INTO copbhc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚϮϨⲞ ⲈⲢⲞϤ ϪⲈ ⲚⲦⲈϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨⲐⲞϢ ");
INSERT INTO copbhc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ⲞⲨⲞϨ ⲀϤⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲚϪⲈⲪⲎ ⲈⲚⲀϤⲞⲒ ⲚⲆⲈⲘⲰⲚ ϨⲒⲚⲀ ⲚⲦⲈϤⲞϨⲒ ⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ⲞⲨⲞϨ ⲘⲠⲈϤⲬⲀϤ ⲀⲖⲖⲀ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϦⲞⲨⲚ ⲈⲠⲈⲔⲎⲒ ϨⲀ ⲚⲎ ⲈⲦⲈⲚⲞⲨⲔ ⲞⲨⲞϨ ⲘⲀⲦⲀⲘⲰⲞⲨ ⲈⲚⲎ ⲈⲦⲀ ⲠϬⲞⲒⲤ ⲀⲒⲦⲞⲨ ⲚⲀⲔ ⲈⲀϤⲚⲀⲒ ⲚⲀⲔ ");
INSERT INTO copbhc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ⲞⲨⲞϨ ⲀϤϨⲰⲖ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲰⲒϢ ϦⲈⲚⲐⲘⲎϮ ⲚϮⲂⲀⲔⲒ ⲘⲠⲈⲦⲀϤⲀⲒϤ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲦⲎⲢⲞⲨ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲞⲚ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲘⲎⲢ ϦⲈⲚⲠⲒϪⲞⲒ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲠⲈ ϦⲀⲦⲈⲚ ⲪⲒⲞⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ⲞⲨⲞϨ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲀⲒ ⲚⲦⲈⲚⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲀⲒⲢⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤϨⲒⲦϤ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ");
INSERT INTO copbhc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ⲞⲨⲞϨ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲚϨⲀⲚⲘⲎϢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲦⲀϢⲈⲢⲒ ⲀⲤϦⲰⲚⲦ ⲈⲪⲘⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲔⲒ ⲚⲦⲈⲔⲬⲀ ⲦⲈⲔϪⲒϪ ⲈϪⲰⲤ ϨⲒⲚⲀ ⲚⲦⲈⲤⲚⲞϨⲈⲘ ⲞⲨⲞϨ ⲚⲦⲈⲤⲰⲚϦ ");
INSERT INTO copbhc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲞⲨⲞϨ ⲚⲀⲨϨⲞϪϨⲈϪ ⲘⲘⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲤϨⲒⲘⲒ ⲀⲤⲈⲢ ⲒⲂ ⲚⲢⲞⲘⲠⲒ ⲈⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲚⲞϤ ϦⲀⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ⲞⲨⲞϨ ⲀⲤϬⲒ ⲚⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒⲘⲎϢ ⲚⲤⲎⲒⲚⲒ ⲞⲨⲞϨ ⲀⲤϬⲈ ⲚⲈⲦⲈⲚⲦⲀⲤ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲠⲈⲤϪⲈⲘϨⲎⲞⲨ ⲚϨⲖⲒ ⲀⲖⲖⲀ ⲘⲀⲖⲖⲞⲚ ⲀⲤⲦϨⲞ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ⲈⲦⲀⲤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲐⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲤⲒ ϦⲈⲚⲠⲒⲘⲎϢ ϨⲒⲪⲀϨⲞⲨ ⲀⲤϬⲒ ⲚⲈⲘ ⲠⲈϤϨⲂⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ⲚⲀⲤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲔⲀⲚ ⲀⲒϢⲀⲚϬ ⲒⲚⲈⲘ ⲚⲈϤϨⲂⲰⲤ ϮⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲤ ⲀⲤϢⲰⲞⲨⲒ ⲚϪⲈϮⲘⲞⲨⲘⲒ ⲚⲦⲈⲠⲈⲤⲤⲚⲞϤ ⲞⲨⲞϨ ⲀⲤⲈⲘⲒ ϦⲈⲚⲠⲈⲤⲤⲰⲘⲀ ϪⲈ ⲀⲤⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲀ ϮⲘⲀⲤⲦⲒⲄⲜ ");
INSERT INTO copbhc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲈⲘⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚϦⲢⲎ ⲒⲚϦⲎⲦϤ ⲈϮϪⲞⲘ ⲈⲦⲀⲤⲒ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲈⲦⲀϤⲪⲞⲚϨϤ ϦⲈⲚⲠⲒⲘⲎϢ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϬⲒ ⲚⲈⲘ ⲚⲀϨⲂⲰⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ϪⲈ ⲬⲚⲀⲨ ⲈⲠⲒⲘⲎϢ ⲈϤϨⲞϪϨⲈϪ ⲘⲘⲞⲔ ⲞⲨⲞϨ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϬⲒ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ⲞⲨⲞϨ ⲚⲀϤϪⲞⲨϢⲦ ⲠⲈ ⲈⲚⲀⲨ ⲈⲐⲎ ⲈⲦⲀⲤⲈⲢ ⲪⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ϮⲤϨⲒⲘⲒ ⲆⲈ ⲈⲦⲀⲤⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲀⲤⲤⲐⲈⲢⲦⲈⲢ ⲈⲤⲈⲘⲒ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲘⲞⲤ ⲀⲤⲒ ⲞⲨⲞϨ ⲀⲤϨⲒⲦⲤ ⲈϦⲢⲎⲒ ϦⲀⲢⲀⲦϤ ⲞⲨⲞϨ ⲀⲤϪⲈ ϮⲘⲈⲐⲘⲎⲒ ⲦⲎⲢⲤ ⲚⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀϢⲈⲢⲒ ⲠⲈⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲒ ⲘⲀϢⲈ ⲚⲈϦⲈⲚⲞⲨϨⲒⲢⲎ ⲚⲎ ⲞⲨⲞϨ ϢⲰⲠⲒ ⲈⲞⲨⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲀ ⲦⲈⲘⲀⲤⲦⲒⲄⲜ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ⲀⲨⲒ ϨⲀ ⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲦⲈⲔϢⲈⲢⲒ ⲘⲞⲨ ⲈⲐⲂⲈⲞⲨ ⲈⲔϮϦⲒⲤⲒ ⲘⲠⲒⲢⲈϤϮⲤⲂⲰ ");
INSERT INTO copbhc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲈⲦⲞⲨϪⲰ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲘⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲘⲞⲚⲞⲚ ⲚⲀϨϮ ");
INSERT INTO copbhc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ⲞⲨⲞϨ ⲘⲠⲈϤⲬⲀ ϨⲖⲒ ⲚⲈⲘⲀϤ ⲈϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲈⲂⲎⲖ ⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲠⲎⲒ ⲘⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲞⲨⲞϨ ⲀⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲈⲨϢⲐⲈⲢⲐⲰⲢ ⲞⲨⲞϨ ⲈⲨⲢⲒⲘⲒ ⲞⲨⲞϨ ⲈⲨϢⲖⲎⲖⲞⲨⲒ ⲚⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϢⲦⲈⲢⲐⲰⲢ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲢⲒⲘⲒ ⲘⲠⲈⲤⲘⲞⲨ ⲚϪⲈϮⲀⲖⲞⲨ ⲀⲖⲖⲀ ⲀⲤⲚⲔⲞⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ⲞⲨⲞϨ ⲚⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤϨⲒ ⲠⲦⲎⲢϤ ⲈⲂⲞⲖ ⲀϤⲰⲖⲒ ⲚⲈⲘⲀϤ ⲘⲪⲒⲰⲦ ⲚϮⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈⲤⲘⲀⲨ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ϮⲀⲖⲞⲨ ⲬⲎ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲘⲞⲚⲒ ⲚⲦϪⲒϪ ⲚϮⲀⲖⲞⲨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀⲖⲒⲐⲀ ⲔⲞⲨⲘ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ϮⲀⲖⲞⲨ ⲀⲒϪⲈ ⲈⲢⲞ ⲦⲰⲚⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲤ ⲀⲤⲦⲰⲚⲤ ⲚϪⲈϮⲀⲖⲞⲨ ⲞⲨⲞϨ ⲀⲤⲘⲞϢⲒ ⲚⲀⲤϦⲈⲚ ⲒⲂ ⲄⲀⲢ ⲚⲢⲞⲘⲠⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲤⲀⲦⲞⲦⲞⲨ ⲠⲈ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϢⲪⲎⲢⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲚϨⲀⲚⲘⲎϢ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ϨⲖⲒ ⲈⲘⲒ ⲈⲪⲀⲒ ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲚⲦⲞⲨϮⲞⲨⲰⲘ ⲚⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲦⲈϤⲂⲀⲔⲒ ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲀⲂⲂⲀⲦⲞⲚ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϮⲤⲂⲰ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲀⲨⲤⲰⲦⲈⲘ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲀ ⲪⲀⲒ ϪⲈⲘ ⲚⲀⲒ ⲐⲰⲚ ⲞⲨⲞϨ ⲞⲨ ⲦⲈ ⲦⲀⲒⲤⲞⲪⲒⲀ ⲈⲦⲀⲨⲦⲎⲒⲤ ⲘⲪⲀⲒ ⲚⲈⲘ ⲚⲀⲒⲔⲈϪⲞⲘ ⲘⲠⲀⲒⲢⲎϮ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲈϤϪⲒϪ ");
INSERT INTO copbhc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲠⲒⲀⲘϢⲈ ⲠϢⲎⲢⲒ ⲘⲘⲀⲢⲒⲀ ⲞⲨⲞϨ ⲠⲤⲞⲚ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲤⲎⲦⲞⲤ ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲞⲨⲞϨ ⲚⲈϤⲤⲰⲚⲒ ⲚⲤϨⲒⲘⲒ ⲚⲀⲨϨⲀⲘⲚⲀⲒ ϨⲀⲢⲞⲚ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϢⲎϢ ⲈⲂⲎⲖ ϦⲈⲚⲦⲈϤⲂⲀⲔⲒ ⲚⲈⲘ ⲦⲈϤⲤⲨⲄⲄⲈⲚⲒⲀ ⲚⲈⲘ ⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ⲞⲨⲞϨ ⲘⲠⲈϤϢϪⲈⲘϪⲞⲘ ⲘⲘⲀⲨ ⲈⲒⲢⲒ ⲞⲨⲆⲈ ⲞⲨⲒ ⲚϪⲞⲘ ⲈⲂⲎⲖ ⲈⲞⲨⲘⲎϢ ⲚⲢⲈϤϢⲰⲚⲒ ⲈⲀϤⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ⲞⲨⲞϨ ⲀϤⲈⲢϢⲪⲎⲢⲒ ⲈⲐⲂⲈ ⲦⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ ⲞⲨⲞϨ ⲀϤⲘⲞⲨϢϮ ⲚⲚⲒϮⲘⲒ ⲈⲦⲈⲘⲠⲔⲰϮ ⲈϤϮⲤⲂⲰ ");
INSERT INTO copbhc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲠⲒⲒⲂ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚⲞⲨⲞⲢⲠⲞⲨ ⲚⲂ ⲂⲞⲨⲞϨ ⲀϤϮⲈⲢϢⲒϢⲒ ⲚⲰⲞⲨ ⲈϪⲈⲚ ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϢⲦⲈⲘⲈⲖ ϨⲖⲒ ⲚⲈⲘⲰⲞⲨ ϨⲒ ⲪⲘⲰⲒⲦ ⲈⲂⲎⲖ ⲈⲞⲨϢⲂⲰⲦ ⲘⲘⲀⲨⲀⲦϤ ⲞⲨⲆⲈ ⲰⲒⲔ ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲞⲨⲆⲈ ϨⲞⲘⲦ ϦⲈⲚⲚⲈⲦⲈⲚⲘⲞϪϦ ");
INSERT INTO copbhc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ⲀⲖⲖⲀ ⲈⲢⲈ ϨⲀⲚⲤⲀⲚⲆⲀⲖⲒⲞⲚ ⲦⲞⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲘⲠⲈⲢϮ ϢⲐⲎⲚ ⲤⲚⲞⲨϮ ϨⲒ ⲐⲎⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲠⲒⲘⲀ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲈϦⲞⲨⲚ ⲈⲞⲨⲎⲒ ⲘⲘⲞϤ ϢⲰⲠⲒ ⲘⲘⲀⲨ ϢⲀⲦⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ⲞⲨⲞϨ ⲘⲀ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚϤⲚⲀϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲆⲈ ⲚⲦⲞⲨϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲈⲢⲰⲦⲈⲚ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚⲈϨ ⲠϢⲰⲒϢ ⲈⲦⲤⲀⲈϦⲢⲎⲒ ⲚⲚⲈⲦⲈⲚϬⲀⲖⲀⲨϪ ⲈⲂⲞⲖ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨϨⲒⲰⲒϢ ϨⲒⲚⲀ ⲚⲤⲈⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ⲞⲨⲞϨ ⲀⲨϨⲒ ⲞⲨⲘⲎϢ ⲚⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲘⲎϢ ⲚⲢⲈϤϢⲰⲚⲒ ⲚⲀⲨⲐⲰϨⲤ ⲘⲘⲰⲞⲨ ⲚⲚⲈϨ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ⲞⲨⲞϨ ⲀϤⲤⲰⲦⲈⲘ ⲚϪⲈⲠⲞⲨⲢⲞ ⲎⲢⲰⲆⲎ ⲤⲠⲈϤⲢⲀⲚ ⲄⲀⲢ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲒϪⲞⲘ ⲤⲈⲈⲢϨⲰⲂ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲎⲖⲒⲀⲤ ⲠⲈ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲒ ⲚⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲚⲀⲢⲬⲈⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲪⲎ ⲀⲚⲞⲔ ⲈⲦⲀⲒⲈⲖ ⲦⲈϤⲚⲀϨⲂⲒ ⲚⲐⲞϤ ⲠⲈⲦⲀϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲚⲈⲀϤⲀⲘⲞⲚⲒ ⲚⲒⲰⲀⲚⲚⲎ ⲤⲞⲨⲞϨ ⲀϤⲤⲞⲚϨϤ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲈⲐⲂⲈ ⲎⲢⲰⲆⲒⲀⲤ ⲦⲤϨⲒⲘⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ ϪⲈⲞⲨⲎ ⲒⲄⲀⲢ ⲚⲈⲀϤϬⲒⲦⲤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ⲚⲀϤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲎⲢⲰⲆⲎⲤ ϪⲈ ⲤϢⲈ ⲚⲀⲔ ⲀⲚ ⲈϬⲒ ⲦⲤϨⲒⲘⲒ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ⲎⲢⲰⲆⲒⲀⲤ ⲆⲈ ⲚⲀⲤⲘⲂⲞⲚ ⲈⲢⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲤⲞⲨⲰϢ ⲈϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲚⲀⲤϢϪⲈⲘϪⲞⲘ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ⲎⲢⲰⲆⲎⲤ ⲄⲀⲢ ⲀϤⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲚⲒⲰⲀⲚⲚⲎ ⲤⲈϤⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲢⲰⲘⲒ ⲚⲆⲒⲔⲈⲞⲤ ⲠⲈ ⲞⲨⲞϨ ϤⲞⲨⲀⲂ ⲞⲨⲞϨ ⲚⲀϤⲀⲢⲈϨ ⲈⲢⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲘⲎϢ ⲚⲦⲞⲦϤ ⲞⲨⲞϨ ⲚⲀϤϢⲞⲖϨ ⲚϨⲎⲦ ⲠⲈ ⲞⲨⲞϨ ϨⲎⲆⲈⲰⲤ ⲚⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ⲈⲦⲀ ⲞⲨⲈϨⲞⲞⲨ ⲆⲈ ϢⲰⲠⲒ ⲚⲈⲨⲔⲈⲢⲒⲀ ϨⲞⲦⲈ ⲈⲦⲀ ⲎⲢⲰⲆⲎⲤ ϦⲈⲚⲠⲈϤⲈϨⲞⲞⲨ ⲘⲘⲒⲤⲒ ⲐⲀⲘⲒⲈ ⲞⲨⲆⲒⲠⲚⲞⲚ ⲚⲚⲈϤⲚⲒϢϮ ⲚⲈⲘ ⲚⲒⲬⲒⲖⲒⲀⲢⲬ ⲞⲤ ⲚⲈⲘ ⲚⲒϨⲞⲨⲀϮ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ⲞⲨⲞϨ ⲈⲦⲀⲤⲒ ⲈϦⲞⲨⲚ ⲚϪⲈⲦϢⲈⲢⲒ ⲚⲎⲢⲰⲆⲒⲀⲤ ⲞⲨⲞϨ ⲈⲦⲀⲤϬⲞⲤϪⲈⲤ ⲀⲤⲢⲀⲚⲀϤ ⲚⲎⲢⲰⲆⲎⲤ ⲚⲈⲘ ⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲚⲈⲘⲀϤ ⲠⲈϪⲈ ⲠⲞⲨⲢⲞ ⲆⲈ ⲚϮⲀⲖⲞⲨ ϪⲈ ⲀⲢⲒⲈⲦⲒⲚ ⲘⲘⲞⲒ ⲘⲠⲈⲦⲈⲞⲨⲀϢϤ ⲚⲦⲀⲦⲎⲒϤ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ⲞⲨⲞϨ ⲀϤⲰⲢⲔ ⲚⲀⲤ ϪⲈ ⲪⲎ ⲈⲦⲈⲢⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ϮⲚⲀϮ ⲚⲈϢⲀ ⲦⲪⲀϢⲒ ⲚⲦⲀⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ⲞⲨⲞϨ ⲈⲦⲀⲤⲒ ⲈⲂⲞⲖ ⲠⲈϪⲀⲤ ⲚⲦⲈⲤⲘⲀⲨ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲐⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲦⲀⲪⲈ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ⲞⲨⲞϨ ⲈⲦⲀⲤⲒ ⲈϦⲞⲨⲚ ϦⲈⲚⲞⲨⲤⲠⲞⲨⲆⲎ ϨⲀ ⲠⲞⲨⲢⲞ ⲀⲤⲈⲢⲈⲦⲒⲚ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ϨⲒⲚⲀ ϮⲚⲞⲨ ⲚⲦⲈⲔϮ ⲚⲎⲒ ⲚⲦⲀⲪⲈ ⲚⲒⲰⲀⲚⲚⲎ ⲤⲠⲒⲢⲈϤϮⲰⲘⲤ ϨⲒ ⲞⲨⲂⲒⲚⲀϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ⲞⲨⲞϨ ⲈⲦⲀ ⲠϨⲎⲦ ⲘⲠⲞⲨⲢⲞ ⲘⲔⲀϨ ⲈⲐⲂⲈ ⲚⲒⲀⲚⲀⲨϢ ⲚⲈⲘ ⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲚⲈⲘⲀϤ ⲘⲠⲈϤⲞⲨⲰϢ ⲈϤⲞϪⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲞⲨⲰⲢⲠ ⲚϪⲈⲠⲞⲨⲢⲞ ⲚⲞⲨⲤⲔⲈⲠⲰⲖⲀⲦⲞⲢ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲦⲈϤⲒⲚⲒ ⲚⲦⲈϤⲀⲪⲈ ϨⲒ ⲠⲒⲂⲒⲚⲀϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ⲞⲨⲞϨ ⲀϤⲦⲎⲒⲤ ⲚϮⲀⲖⲞⲨ ⲞⲨⲞϨ ⲀϮⲀⲖⲞⲨ ⲦⲎⲒⲤ ⲚⲦⲈⲤⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲒ ⲀⲨⲰⲖⲒ ⲘⲠⲒⲤⲰⲘⲀ ⲞⲨⲞϨ ⲀⲨⲬⲀϤ ⲚϦⲞⲨⲚ ϦⲈⲚⲞⲨⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ⲞⲨⲞϨ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨⲦⲀⲘⲞϤ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲀⲒϤ ⲚⲈⲘ ⲪⲎ ⲈⲦⲀⲨϮⲤⲂⲰ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲚⲐⲰⲦⲈⲚ ⲤⲀⲠⲤⲀ ⲈⲞⲨⲘⲀⲚϢⲀϤⲈ ⲞⲨⲞϨ ⲘⲦⲞⲚ ⲘⲘⲰⲦⲈⲚ ⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲎ ⲄⲀⲢ ⲈⲐⲚⲎⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲀⲚⲀⲨⲞϢ ⲠⲈ. ⲞⲨⲞϨ ⲚⲀⲨϪⲈⲘ ⲈⲨⲔⲈⲢⲒⲀ ⲀⲚ ⲠⲈ ⲈⲈⲢ ⲠⲔⲈⲞⲨⲰⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ϨⲒ ⲠⲒϪⲞⲒ ⲈⲞⲨⲘⲀⲚϢⲀϤⲈ ⲤⲀⲠⲤⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ⲞⲨⲞϨ ⲀⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲈⲨϨⲎⲖ ⲞⲨⲞϨ ⲀⲨⲤⲰⲞⲨⲚⲞⲨ ⲚϪⲈⲞⲨⲘⲎϢ ⲞⲨⲞϨ ⲀⲨϬⲞϪⲒ ⲘⲘⲀⲨ ⲚⲢⲀⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲂⲀⲔⲒ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲀⲨⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤⲚⲀⲨ ⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲞⲨⲞϨ ⲀϤϢⲈⲚϨⲎⲦ ϦⲀⲢⲰⲞⲨ ϪⲈ ⲚⲀⲨⲞⲒ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲤⲰⲞⲨ ⲘⲘⲞⲚⲦⲞⲨ ⲘⲀⲚⲈⲤⲰⲞⲨ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϮⲤⲂⲰ ⲚⲰⲞⲨ ⲚϨⲀⲚⲘⲎ Ϣ ");
INSERT INTO copbhc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ⲞⲨⲞϨ ϨⲎⲆⲎ ⲈⲦⲀ ⲞⲨⲚⲒϢϮ ⲚⲞⲨⲚⲞⲨ ϢⲰⲠⲒ ⲈⲦⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲘⲀ ⲞⲨϢⲀϤⲈ ⲠⲈ ⲞⲨⲞϨ ϨⲎⲆⲎ ϮⲞⲨⲚⲞⲨ ⲀⲤⲤⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ⲬⲀⲨ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲈ ⲚⲰⲞⲨ ⲈⲚⲒⲒⲞϨⲒ ⲈⲦⲔⲰϮ ⲚⲈⲘ ⲚⲒϮⲘⲒ ⲚⲦⲞⲨϢⲰⲠ ⲚⲰⲞⲨ ⲘⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲞⲒ ⲚⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲘⲀⲢⲞⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲦⲈⲚⲚⲀϢⲈ ⲚⲀⲚ ⲚⲦⲈⲚϢⲈⲠ ⲤⲚⲤⲀⲐⲈⲢⲒ ⲚⲰⲒⲔ ⲞⲨⲞϨ ⲚⲦⲈⲚϮ ⲚⲰⲞⲨ ⲈⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲚⲰⲒⲔ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲀⲚⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲘⲒ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲈⲚⲰⲒⲔ ⲚⲈⲘ ⲦⲈⲂⲦ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲞⲨ ⲚⲦⲞⲨⲢⲰⲦⲈⲂ ⲚⲤⲒⲘⲠⲞⲤⲒⲞⲚ ⲤⲒⲘⲠⲞⲤⲒⲞⲚ ϨⲒϪⲈⲚ ⲠⲒⲤⲒⲘ ⲈⲐⲞⲨⲈⲦⲞⲨⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ⲞⲨⲞϨ ⲀⲨⲢⲰⲦⲈⲂ ⲦⲎⲢⲞⲨ ⲘⲘⲀ ⲘⲀ ⲔⲀⲦⲀ ⲢⲢ ⲚⲈⲘ ⲔⲀⲦⲀ ⲚⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲈ ⲚⲰⲒⲔ ⲚⲈⲘ ⲚⲒⲦⲈⲂⲦ ⲂⲀϤϪⲞⲨϢⲦ ⲈⲦⲪⲈ ⲞⲨⲞϨ ⲀϤⲤⲘⲞⲨ ⲞⲨⲞϨ ⲀϤⲪⲰϢ ⲚⲚⲒⲰⲒⲔ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲒⲘⲀⲐⲎ ⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲬⲰ ⲚⲀϨⲢⲀⲨ ⲚⲈⲘ ⲚⲒⲔⲈⲦⲈⲂⲦ ⲂⲀϤⲪⲀϢⲞⲨ ⲈϨⲢⲀⲨ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲘ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲀⲨⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ⲞⲨⲞϨ ⲀⲨⲰⲖⲒ ⲘⲒⲂ ⲚⲔⲞⲦ ⲚⲖⲀⲔϨ ⲈⲨⲘⲈϨ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲈⲦⲈⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲞⲨⲰⲘ ⲚⲚⲒⲰⲒⲔ ⲚⲀⲨⲈⲢ ⲈⲚϢⲞ ⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲈⲢⲀⲚⲀⲄⲔⲀⲌⲒⲚ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲤⲰⲔ ϦⲀϪⲰϤ ⲈⲘⲎⲢ ⲈⲂⲎⲐⲤⲀⲒⲆⲀ ϢⲀⲦⲈϤⲬⲀ ⲠⲒⲘⲎ ϢⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲀⲠⲞⲦⲀⲌⲈⲤⲐⲈ ⲚⲰⲞⲨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲒⲦⲰⲞⲨ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ⲞⲨⲞϨ ⲈⲦⲀ ⲢⲞⲨϨⲒ ϢⲰⲠⲒ ⲚⲀⲢⲈ ⲠⲒϪⲞⲒ ϦⲈⲚⲐⲘⲎϮ ⲘⲪⲒⲞⲘ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲚⲀϤⲬⲎ ϨⲒ ⲠⲒⲬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲈⲨⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ϦⲈⲚⲠⲒϪⲒⲚⲤⲰⲔ ⲚⲀⲢⲈ ⲠⲒⲐⲎⲞⲨ ⲄⲀⲢ - ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲨ ⲠⲈ ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚϮⲘⲀϨⲆ ⲚⲞⲨⲈⲢϢⲒ ⲚⲦⲈⲠⲒⲈϪⲰⲢϨ ⲀϤⲒ ϨⲀⲢⲰⲞⲨ ⲈϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ ⲞⲨⲞϨ ⲚⲀϤⲞⲨⲰϢ ⲈⲤⲈⲚⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ⲞⲨϨⲞⲢⲦϤ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲰϢ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ⲚⲈ ⲀⲨⲚⲀⲨ ⲄⲀⲢ ⲈⲢⲞϤ ⲦⲎⲢⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲐⲞϤ ⲆⲈ ⲤⲀⲦⲞⲦϤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲀⲚⲞⲔ ⲠⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ⲞⲨⲞϨ ⲀϤⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ϨⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϤϨⲈⲢⲒ ⲚϪⲈⲠⲒⲐⲎⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲦⲰⲘⲦ ⲈⲘⲀϢⲰ ⲠⲈ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ⲞⲨ ⲄⲀⲢ ⲘⲠⲞⲨⲔⲀϮ ⲈϪⲈⲚ ⲚⲒⲰⲒⲔ ⲀⲖⲖⲀ ⲚⲀⲢⲈ ⲠⲞⲨϨⲎⲦ ⲐⲎⲘ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢϪⲒⲚⲒⲞⲢ ⲈⲘⲎⲢ ⲀⲨⲒ ⲈⲄⲈⲚⲚⲎ ⲤⲀⲢⲈⲐ ⲞⲨⲞϨ ⲀⲨⲘⲞⲚⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒ ⲠⲒϪⲞⲒ ⲀⲨⲤⲞⲨⲰⲚϤ ⲤⲀⲦⲞⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ⲀⲨϬⲞϪⲒ ϦⲈⲚϮⲬⲰⲢⲀ ⲦⲎⲢⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲘϤⲀⲒ ⲚⲚⲎ ⲈⲦⲦϨⲈⲘⲔⲎ ⲞⲨⲦ ϨⲒ ϨⲀⲚϬⲖⲞϪ ⲈⲠⲒⲘⲀ ⲈϢⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ϤⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲈϢⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲈⲚⲒϮⲘⲒ ⲒⲈ ⲚⲒⲂⲀⲔⲒ ⲒⲈ ⲚⲒⲒⲞϨⲒ ⲚⲀⲨⲬⲰ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ϨⲒ ⲚⲒⲀⲄⲞⲢⲀ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲔⲀⲚ ⲚⲦⲞⲨϬⲒ ⲚⲈⲘ ⲠⲒϢⲦⲀϮ ⲚⲦⲈⲚⲈϤϨⲂⲰⲤ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϢⲀⲨϬⲒ ⲚⲈⲘⲀϤ ϢⲀⲨⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ⲞⲨⲞϨ ⲀⲨⲐⲰⲞⲨϮ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲀϦ ⲈⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲒⲖⲎⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈϨⲀⲚⲞⲨⲞⲚ ⲚⲦⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ϪⲈ ⲤⲈⲞⲨⲰⲘ ⲚⲚⲒⲰⲒⲔ ⲈⲢⲈ ⲚⲞⲨϪⲒϪ ⲐⲰⲖⲈⲂ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲚⲀⲦⲒⲀ ⲦⲞⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲄⲀⲢ ⲚⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲘⲠⲀⲨⲞⲨⲰⲘ ⲀⲨϢⲦⲈⲘⲒⲀ ⲦⲞⲦⲞⲨ ⲚⲞⲨⲘⲎ ϢⲚⲤⲞⲠ ⲈⲨⲀⲘⲞⲚⲒ ⲚϮⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲨϢⲦⲈⲘⲞⲘⲤⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚϮⲀⲄⲞⲢⲀ ⲘⲠⲀⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ϨⲀⲚⲔⲈⲘⲎϢ ⲈⲀⲨϬⲒⲦⲞⲨ ⲈⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲰⲞⲨ ϨⲀⲚⲰⲘⲤ ⲚⲦⲈϨⲀⲚⲀⲪⲞⲦ ⲚⲈⲘ ϨⲀⲚⲜⲈⲤⲦⲎⲤ ⲚⲈⲘ ϨⲀⲚⲬⲀⲖⲔⲒⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲤⲈⲘⲞϢⲒ ⲀⲚ ⲚϪⲈⲚⲈⲔⲘⲀⲐⲎ ⲦⲎⲤ ⲔⲀⲦⲀ ϮⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲖⲖⲀ ϦⲈⲚϨⲀⲚϪⲒϪ ⲈⲨⲐⲞⲖⲈⲂ ⲤⲈⲞⲨⲰⲘ ⲘⲠⲒⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲔⲀⲖⲰⲤ ⲀϤⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲚϪⲈⲎⲤⲀⲒⲀⲤ ϦⲀ ⲚⲒϢⲞⲂⲒ ⲘⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲀⲒⲖⲀⲞⲤ ⲈⲢⲦⲒⲘⲀⲚ ⲘⲘⲞⲒ ϦⲈⲚⲚⲞⲨⲤⲪⲞⲦⲞⲨ ⲠⲞⲨϨⲎⲦ ⲆⲈ ϤⲞⲨⲎⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲘⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ⲈⲨⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲘⲞⲒ ⲈⲪⲖⲎⲞⲨ ⲈⲨϮⲤⲂⲰ ⲚϨⲀⲚⲤⲂⲰ ⲚϨⲞⲚϨⲈⲚ ⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ⲈⲀⲦⲈⲦⲈⲚⲬⲀ ϮⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲦⲈⲦⲈⲚⲀⲘⲞⲚⲒ ⲚϮⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲔⲀⲖⲰⲤ ⲦⲈⲦⲈⲚⲈⲢⲀⲐⲈⲦⲒⲚ ⲚϮⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲀⲢⲈϨ ⲈⲦⲈⲦⲈⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲀϤϪⲞⲤ ϪⲈ ⲀⲢⲒⲦⲒⲘⲀⲚ ⲘⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲦⲈⲔⲘⲀⲨ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲤⲀϪⲒ ⲈϤϨⲰⲞⲨ ⲚⲤⲀⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲘⲀⲢⲈϤⲘⲞⲨ ⲚⲞⲨⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨⲢⲰⲘⲒ ϪⲞⲤ ⲘⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ϪⲈ ⲔⲞⲢⲂⲀⲚ ⲈⲦⲈ ⲞⲨⲦⲀⲒⲞ ⲠⲈ ⲀⲔϢⲀⲚϪⲈⲘϨⲎ ⲞⲨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲘⲘⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ⲚⲦⲈⲦⲈⲚⲬⲰ ⲘⲘⲞϤ ⲀⲚ ⲈⲈⲢ ϨⲖⲒ ⲘⲠⲈϤⲒⲰⲦ ⲒⲈ ⲦⲈϤⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ⲈⲢⲈⲦⲈⲚⲔⲰⲢϤ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲦⲈⲦⲈⲚⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲐⲎ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲎⲒⲤ ⲞⲨⲞϨ ϨⲀⲚⲘⲎϢ ⲘⲠⲀⲒⲢⲎϮ ⲈⲨⲞⲚⲒ ⲚⲚⲀⲒ ⲦⲈⲦⲈⲚⲢⲀ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲞⲚ ⲈⲠⲒⲘⲎϢ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ ⲞⲨⲞϨ ⲔⲀϮ ");
INSERT INTO copbhc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ⲘⲘⲞⲚ ϨⲖⲒ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲢⲰⲘⲒ ⲈϤⲚⲀ ⲈϦⲞⲨⲚ ⲈⲢⲰϤ ⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲤⲞϤϤ ⲀⲖⲖⲀ ⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ⲞⲨⲞϨ ϨⲞⲦⲈ ⲈⲦⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘⲎϢ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈϮⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲀⲦⲔⲀϮ ⲚⲐⲰⲦⲈⲚ ⲘⲠⲈⲦⲈⲚⲔⲀϮ ϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲀⲂⲞⲖ ⲈⲐⲚⲀ ⲈϦⲞⲨⲚ ⲈⲢⲰϤ ⲘⲠⲒⲢⲰⲘⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲤⲞϤϤ ");
INSERT INTO copbhc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ϪⲈ ⲤⲈⲚⲀ ⲈϦⲞⲨⲚ ⲈⲠⲈϤϨⲎⲦ ⲀⲚ ⲀⲖⲖⲀ ⲦⲈϤⲚⲈϪⲒ ⲞⲨⲞϨ ϢⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲚⲒⲘⲀⲚϨⲈⲘⲤⲒ ⲈϤⲦⲞⲨⲂⲞ ⲚⲚⲒϦⲢⲎⲞⲨⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲘⲠⲒⲢⲰⲒⲘⲒ ⲚⲐⲞϤ ⲈⲦⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ⲈⲂⲞⲖ ⲄⲀⲢ ⲤⲀϦⲞⲨⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϨⲎ ⲦⲚⲦⲈ ⲚⲒⲢⲰⲘⲒ ϢⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲘⲞⲔⲘⲈⲔ ⲈⲦϨⲰⲞⲨ ⲚⲒⲠⲞⲢⲚⲒⲀ ⲚⲒϬⲒⲞⲨⲒ ⲚⲒϦⲰⲦⲈⲂ ⲚⲒⲘⲈⲦⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ⲚⲒⲘⲈⲦϬⲒⲚϪⲞⲚⲤ ⲚⲒⲘⲈⲦⲠⲈⲦϨⲰⲞⲨ ⲚⲒⲘⲈⲦⲆⲞⲖⲞⲤ ⲚⲒⲤⲰϤ ⲚⲒⲂⲀⲖ ⲈⲦϨⲰⲞⲨ ⲚⲒϪⲈⲞⲨⲀ ⲞⲨϬⲒⲤⲒ ⲚϨⲎⲦ ⲞⲨⲘⲈⲦⲀⲦⲔⲀϮ ");
INSERT INTO copbhc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϨⲰⲞⲨ ⲈⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲤⲀϦⲞⲨⲚ ⲞⲨⲞϨ ⲤⲈⲤⲰϤ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲚⲒⲤⲀ ⲚⲦⲈⲦⲨⲢⲞⲤ ⲚⲈⲦⲤⲒⲆⲰⲚ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲞⲨⲎⲒ ⲚⲀϤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲚⲦⲈϨⲖⲒ ⲈⲘⲒ ⲞⲨⲞϨ ⲘⲠⲈϤϢϪⲈⲘϪⲞⲘ ⲚⲰⲂϢ ");
INSERT INTO copbhc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲤ ⲀⲤⲤⲰⲦⲈⲘ ⲚϪⲈⲞⲨⲤϨⲒⲘⲒ ⲈⲐⲂⲎⲦϤ ⲐⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲈⲘ ⲦⲈⲤϢⲈⲢⲒ ⲈⲦⲀⲤⲒ ⲈϦⲞⲨⲚ ⲀⲤϨⲒⲦⲤ ⲈϦⲢⲎⲒ ϦⲀ ⲚⲈϤϬⲀⲖⲀⲨϪ ");
INSERT INTO copbhc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ϮⲤϨⲒⲘⲒ ⲆⲈ ⲚⲈⲞⲨⲈⲒⲚⲒⲚ ⲚⲦⲈⲚ ⲤⲨⲢⲒⲀ ⲠⲈⲤⲄⲈⲚⲞⲤ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϮⲪⲞⲒⲚⲒⲔⲎ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲤϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤϨⲒ ⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲚⲦⲈⲤϢⲈⲢⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲤ ϪⲈ ⲬⲀⲤ ⲚϢⲞⲢⲠ ⲚⲦⲞⲨⲤⲒ ⲚϪⲈⲚⲒϢⲎⲢⲒ ⲞⲨ ⲄⲀⲢ ⲚⲀⲚⲈⲤ ⲀⲚ ⲈⲈⲖ ⲠⲰⲒⲔ ⲚⲚⲒϢⲎⲢⲒ ⲈⲦⲎⲒϤ ⲚⲚⲒⲞⲨϨⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ⲚⲐⲞⲤ ⲆⲈ ⲀⲤⲈⲢⲞⲨⲰ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠⲀϬⲞⲒⲤ ⲚⲒⲔⲈⲞⲨϨⲰⲢ ⲤⲈⲞⲨⲰⲘ ⲈϦⲢⲎⲒ ⲚϮⲦⲢⲀⲚⲈⲌⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲖⲈϤⲖⲒϤⲒ ⲚⲦⲈⲚⲒⲀⲖⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲈⲐⲂⲈ ⲠⲀⲒⲤⲀϪⲒ ⲘⲀϢⲈ ⲚⲈⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒ ⲦⲈϢⲈⲢⲒ ⲚϪⲈⲠⲒⲆⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ⲞⲨⲞϨ ⲈⲦⲀⲤϢⲈ ⲚⲀⲤ ⲈⲠⲈⲤⲎⲒ ⲀⲤϪⲒⲘⲒ ⲚϮⲀⲖⲞⲨ ϨⲒϪⲈⲚ ⲠⲒϬⲖⲞϪ ⲞⲨⲞϨ ⲠⲒⲆⲈⲘⲰⲚ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲰⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲐⲞϢ ⲚⲦⲈⲦⲨⲢⲞⲤ ⲚⲀϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲦⲤⲒⲆⲰⲚ ⲈⲪⲒⲞⲘ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲦⲈ ⲚⲒⲐⲞϢ ⲚⲦⲈϮⲘⲎϮ ⲘⲂⲀⲔⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲔⲞⲨⲢ ⲚⲈⲂⲞ ⲞⲨⲞϨ ⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲬⲀ ϪⲒϪ ϨⲒϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ⲞⲨⲞϨ ⲀϤⲞⲖϤ ⲤⲀⲠⲤⲀ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘⲎϢ ⲀϤϨⲒ ⲚⲈϤⲦⲎⲂ ⲈϦⲞⲨⲚ ⲈⲚⲈϤⲘⲀϢϪ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲐⲀϤ ⲀϤϬⲒ ⲚⲈⲘ ⲠⲈϤⲖⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲀϤϤⲒⲀϨⲞⲘ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲠⲪⲀⲐⲀ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲀⲞⲨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲚ ⲚϪⲈⲚⲈϤⲘⲀϢϪ ⲞⲨⲞϨ ⲀϤϮⲞⲨⲰ ⲚϪⲈⲠⲒⲤⲚⲀϨ ⲚⲦⲈⲠⲈϤⲖⲀⲤ ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲠⲈ ⲈϤⲤⲞⲨⲦⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘϪⲞⲤ ⲚϨⲖⲒ ϨⲞⲤⲆⲈ ⲘⲀⲖⲖⲞⲚ ⲚⲀⲨϨⲒⲰⲒϢ ⲚϨⲞⲨⲞ ");
INSERT INTO copbhc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲀϤⲀⲒⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲦⲀϤⲐⲢⲈ ⲚⲒⲔⲞⲨⲢ ⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲒⲀⲦⲤⲀϪⲒ ⲚⲦⲞⲨⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ϦⲈⲚ ⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲚ ⲈϤϢⲞⲠ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ⲀϤⲘⲞⲨϮ ⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ϪⲈ ϮϢⲈⲚϨⲎⲦ ϦⲀ ⲠⲀⲒⲘⲎϢ ϪⲈ ⲒⲤ Ⲅ- ⲚⲈϨⲞⲞⲨ ⲤⲈⲞϨⲒ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲠⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ");
INSERT INTO copbhc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲬⲀⲨ ⲈⲂⲞⲖ ⲈⲠⲞⲨⲎⲒ ⲚⲀⲦⲞⲨⲰⲘ ⲤⲈⲚⲀⲂⲰⲖ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲞⲨⲞⲚ ⲚϦⲎⲦⲞⲨ ⲚⲀⲨϨⲒⲪⲞⲨⲈⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ⲞⲨⲞϨ ⲀⲨⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲒⲘ ⲈⲂⲞⲖ ⲐⲰⲚ ϨⲀ ⲘⲚⲀⲒ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲐⲢⲈ ⲚⲀⲒ ⲤⲒ ⲚⲰⲒⲔ ϨⲒ ⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ⲞⲨⲞϨ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲚⲰⲒⲔ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ Ⲍ-. ");
INSERT INTO copbhc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲦⲞⲦϤ ⲘⲠⲒⲘⲎϢ ϨⲒⲚⲀ ⲚⲤⲈⲢⲰⲦⲈⲂ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲞⲨⲞϨ ⲈⲦⲀϤϬ ⲒⲘⲠⲒⲌ ⲚⲰⲒⲔ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤⲪⲀϢⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲬⲰ ϦⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲬⲰ ⲚⲀϨⲢⲈⲚ ⲠⲒⲘⲎϢ ");
INSERT INTO copbhc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ϨⲀⲚⲔⲈⲔⲞⲨϪⲒ ⲚⲦⲈⲂⲦ ⲚⲦⲞⲦⲞⲨ ⲞⲨⲞϨ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲀϤϪⲞⲤ ⲈⲐⲢⲞⲨⲬ ⲰⲚⲚⲀⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲚⲀϨⲢⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲀⲨⲤⲒ ⲞⲨⲞϨ ⲀⲨⲰⲖⲒ ⲚⲚⲒϨⲞⲨⲞ ⲚⲦⲈⲚⲒⲖⲀⲔϨ ⲌⲘⲂⲒⲢ ");
INSERT INTO copbhc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ⲚⲀⲨⲒⲢⲒ ⲚⲆ ⲚϢⲞ ⲞⲨⲞϨ ⲀϤⲬⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲀϤⲒ ⲈⲚⲒⲤⲀ ⲚⲦⲈⲆⲀⲖⲘⲀⲚⲞⲨⲐⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲔⲰϮ ⲚⲈⲘⲀϤ ⲈⲨⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎⲒⲚⲒ ⲚⲦⲞⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ⲞⲨⲞϨ ⲈⲦⲀϤϤⲒⲀϨⲞⲘ ϦⲈⲚⲠⲈϤⲠⲚⲈⲨⲘⲀⲠⲈϪⲀϤ ϪⲈ ⲀϦⲞ ⲠⲀⲒϪⲰⲞⲨ ϤⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎ ⲒⲚⲒ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲚ ⲤⲈⲚⲀϮ ⲚⲞⲨⲘⲎⲒⲚⲒ ⲘⲠⲀⲒϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ⲞⲨⲞϨ ⲈⲦⲀϤⲬⲀⲨ ⲈⲂⲞⲖ ⲀϤⲀⲖⲎⲒ ⲀϤϢⲈ ⲈⲘⲎⲢ ");
INSERT INTO copbhc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ⲞⲨⲞϨ ⲀⲨⲈⲢⲠⲰⲂϢ ⲈϬⲒ ⲰⲒⲔ ⲞⲨⲞϨ ⲚⲈⲘⲘⲞⲚ ϨⲖⲒ ⲚⲦⲞⲦⲞⲨ ϨⲒ ⲠⲒϪⲞⲒ ⲈⲂⲎⲖ ⲈⲞⲨⲰⲒⲔ ⲘⲘⲀⲨⲀⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ⲞⲨⲞϨ ⲚⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲀⲨ ⲞⲨⲞϨ ϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϨⲀ ⲠϢⲈⲘⲎⲢ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲠϢⲈⲘⲎⲢ ⲚⲎⲢⲰⲆⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ⲞⲨⲞϨ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲰⲒⲔ ⲚⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀϦⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ϪⲈ ⲘⲘⲞⲚ ⲰⲒⲔ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲠⲀⲦⲈⲦⲈⲚⲈⲘⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲔⲀϮ ⲀⲚ ϤⲐⲎⲘ ⲚϪⲈⲠⲈⲦⲈⲚϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ⲞⲨⲞϨ ⲞⲨⲞⲚ ϨⲀⲚⲂⲀⲖ ⲘⲘⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲚⲀⲨ ⲘⲂⲞⲖ ⲀⲚ ⲞⲨⲞϨ ⲞⲨⲞⲚ ϨⲀⲚⲘⲀϢϪ ⲈⲢⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲀⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲪⲘⲈⲨⲒ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ⲘⲠⲒⲈ ⲚⲰⲒⲔ ⲈⲦⲀⲒⲪⲀϢⲞⲨ ⲈϨⲢⲈⲚ ⲠⲒⲈ ⲚϢⲞ ϪⲈ ⲀⲦⲈⲦⲈⲚⲈⲖ ⲞⲨⲎⲢ ⲚⲔⲞⲦ ⲚⲖⲀⲔϨ ⲈⲨⲘⲈϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲒⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ⲞⲨⲞϨ ⲠⲒⲌ ⲈϨⲢⲈⲚ ⲠⲒⲆ ⲚϢⲞ ϪⲈ ⲀⲦⲈⲦⲈⲚⲈⲖ ⲞⲨⲎⲢ ⲘⲂⲒⲢ ⲈⲨⲘⲈϨ ⲚⲖⲀⲔϨ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ Ⲍ-. ");
INSERT INTO copbhc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲠⲰⲤ ⲦⲈⲦⲈⲚⲔⲀϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲎⲐⲤⲀⲒⲆⲀ ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲂⲈⲖⲖⲈ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒ ⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ⲞⲨⲞϨ ⲀϤⲀⲘⲞⲚⲒ ⲚⲦϪⲒϪ ⲘⲠⲒⲂⲈⲖⲖⲈ ⲞⲨⲞϨ ⲀϤⲈⲚϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒϮⲘⲒ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲐⲀϤ ϦⲈⲚⲚⲈϤⲂⲀⲖ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ϨⲒϪⲰϤ ⲚⲀϤϢⲒⲚⲒ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲚⲀⲨ ⲈⲚⲒⲢⲰⲘⲒ ⲘⲪⲢⲎϮ ⲚϨⲀⲚϢϢⲎ ⲚⲈⲨⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ⲒⲦⲀ ⲞⲚ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ⲈϪⲈⲚ ⲚⲈϤⲂⲀⲖ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲞⲨϪⲀⲒ ⲀϤⲚⲀⲨ ⲈⲠⲦⲎⲢϤ ϦⲈⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠϤ ⲈⲠⲈϤⲎⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢϢⲈ ⲚⲀⲔ ⲈϦⲞⲨⲚ ⲈⲠⲒϮⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲚⲒϮⲘⲒ ⲚⲦⲈⲔⲈⲤⲀⲢⲒⲀ ⲚⲦⲈⲪⲒⲖⲒⲠⲠⲈ ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲚⲀϤϢⲒⲚⲒ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ. ϪⲈ ⲀⲢⲈ ⲚⲒⲢⲰⲘⲒ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ⲚⲐⲰⲞⲨ ⲀⲨϪⲞⲤ ⲚⲀϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ϪⲈ ⲎⲖⲒⲀⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ϪⲈ ⲞⲨⲀⲒ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘϪⲞⲤ ⲚϨⲖⲒ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϮⲤⲂⲰ ⲚⲰⲞⲨ ϪⲈ ϨⲰϮ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϬⲒ ⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲞϢϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲚⲦⲞⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ Ⲅ- ⲚⲈϨⲞⲞⲨ ⲚⲦⲈϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲘⲠⲒⲤⲀϪⲒ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎ ⲤⲒⲀ ⲞⲨⲞϨ ⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲈⲦⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲞⲒ ⲠⲤⲀⲦⲀⲚⲀⲤ ϪⲈ ⲬⲘⲈⲨⲒ ⲀⲚ ⲈⲚⲀ ⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲈⲚⲀ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲠⲒⲘⲎϢ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲒ ⲤⲀⲘⲈⲚϨⲎⲒ ⲘⲀⲢⲈϤϪⲞⲖϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈϤⲰⲖⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ⲪⲎ ⲄⲀⲢ ⲈⲐⲚⲀⲞⲨⲰϢ ⲈⲚⲞϨⲈⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϤⲈⲦⲀⲔⲞⲤ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲐⲂⲎⲦ ⲚⲈⲘ ⲈⲐⲂⲈ ⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲈϤⲈⲚⲀϨⲘⲈⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ⲞⲨ ⲄⲀⲢ ⲈⲦⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀϪⲈⲘϨⲎⲞⲨ ⲘⲘⲞϤ ⲀϤϢⲀⲚϪⲈⲘϨⲎⲞⲨ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲚⲦⲈϤϮⲞⲤⲒ ⲚⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ⲪⲎ ⲄⲀⲢ ⲈⲦⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀⲦⲎⲒϤ ⲚⲦϢⲈⲂⲒⲰ ⲚⲦⲈϤⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ⲪⲎ ⲄⲀⲢ ⲈⲐⲚⲀϢⲒⲠⲒ ⲈⲞⲨⲞⲚϨⲦ ⲈⲂⲞⲖ ⲚⲈⲘ ⲚⲀⲤⲀϪⲒ ϦⲈⲚⲠⲀⲒϪⲰⲞⲨ ⲚⲚⲰⲒⲔ ⲞⲨⲞϨ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲠϢⲎⲢⲒ ϨⲰϤ ⲘⲪⲢⲰⲘⲒ ⲚⲀϮϢⲒⲠⲒ ⲚⲀϤ ϨⲞⲦⲀⲚ ⲀϤϢⲀⲚⲒ ϦⲈⲚⲠⲰⲞⲨ ⲚⲦⲈⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲐⲞⲨⲀⲂ ");
INSERT INTO copbhc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ϦⲈⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲚⲤⲈⲚⲀϪⲈⲘϮ ⲠⲒ ⲘⲪⲘⲞⲨ ⲀⲚ ϢⲀⲦⲞⲨⲚⲀⲨ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲤⲒ ϦⲈⲚⲞⲨϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲈϨⲞⲞⲨ ⲀϤϬⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲀϤⲞⲖⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲞⲨⲦⲰⲞⲨ ⲈϤϬⲞⲤⲒ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲀϤϢⲞⲂⲦϤ ⲘⲠⲞⲨⲘⲐⲞ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ⲞⲨⲞϨ ⲚⲈϤϨⲂⲰⲤ ⲀⲨϢⲰⲠⲒ ⲈⲨⲪⲞⲢⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲬⲒⲰⲚ ⲞⲨⲞϨ ⲈⲨⲞⲨⲞⲂϢ ⲈⲘⲀϢⲰ ⲚⲎ ⲈⲦⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲢⲀϦⲦ ⲈⲦϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲂⲀϢ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲢⲰⲞⲨ ⲚϪⲈⲎⲖⲒⲀⲤ ⲚⲈⲘ ⲘⲰⲨⲤⲎⲤ ⲞⲨⲞϨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲢⲀⲂⲂⲒ ⲚⲀⲚⲈⲤ ⲚⲀⲚ ⲚⲦⲈⲚϢⲰⲠⲒ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲞϨ ⲚⲦⲈⲚⲐⲀⲘⲒⲞ ⲚⲄ ⲚⲤⲔⲨⲚⲎ ⲞⲨⲒ ⲚⲀⲔ ⲚⲈⲘ ⲞⲨⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲞϨ ⲞⲨⲒ ⲚⲎⲖⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ⲚⲀϤⲈⲘⲒ ⲄⲀⲢ ⲀⲚ ⲠⲈ ϪⲈ ⲞⲨ ⲠⲈⲦⲈϤⲚⲀⲈⲢⲞⲨⲰ ⲘⲘⲞϤ ⲀⲨϢⲰⲠⲒ ⲄⲀⲢ ⲈⲨⲘⲈϨ ⲚϨⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨϬⲎⲠⲒ ⲈⲤⲈⲢϦⲎⲒⲂⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲘⲎ ⲈⲂⲞⲖ ϦⲈⲚϮϬⲎⲠⲒ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲠⲀⲘⲈⲚⲢⲒⲦ ⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲞⲨϢⲦ ⲈⲜⲀⲠⲒⲚⲀ ⲘⲠⲞⲨⲚⲀⲨ ⲈϨⲖⲒ ⲈⲂⲎⲖ ⲈⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨⲀⲦϤ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ⲞⲨⲞϨ ⲈⲨⲚⲎⲞⲨ ⲈϦⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲦⲰⲞⲨ ⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲤⲀϪⲒ ϦⲀⲦⲈⲚ ϨⲖⲒ ⲘⲠⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈⲂⲎⲖ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ⲞⲨⲞϨ ⲀⲨⲀⲘⲞⲚⲒ ⲘⲠⲒⲤⲀϪⲒ ⲚϦⲎⲦⲞⲨ ⲈⲨⲔⲰϮ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲒⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲒⲤⲀϦ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲰϮ ⲠⲈ ⲚⲦⲈⲎⲖⲒⲀⲤ ⲒⲚϢⲞⲢⲠ ");
INSERT INTO copbhc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲎⲖⲒⲀⲤ ⲘⲈⲚ ⲒⲚϢⲞⲢⲠ ⲞⲨⲞϨ ϤⲚⲀⲦⲪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲠⲰⲤ ⲤϦⲎⲞⲨⲦ ⲈϪⲈⲚ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒ ⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲞϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲎⲖⲒⲀⲤ ⲀϤⲒ ⲞⲨⲞϨ ⲀⲨⲒⲢⲒ ⲚⲀϤ ⲘⲠⲈⲦⲞⲨⲞⲨⲀϢϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ϨⲀ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀϤⲚⲀⲨ ⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲘⲠⲞⲨⲔⲰϮ ⲞⲨⲞϨ ϨⲀⲚⲤⲀϦ ⲈⲨⲔⲰϮ ⲚⲈⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲈⲦⲀⲨϬⲞϪⲒ ⲀⲨⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ⲞⲨⲞϨ ⲀϤϢⲈⲚⲞⲨ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲞⲨ ⲚⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲀⲒⲈⲚ ⲠⲀϢⲎⲢⲒ ϨⲀⲢⲞⲔ ⲈⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲦⲤⲀϪⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲈⲦⲈϤⲚⲀⲦⲀϨⲞϤ ⲘⲘⲀⲨ ϢⲀϤⲈⲚϤ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲞϨ ⲚⲦⲈⲢⲰϤ ϪⲈϢ ⲤⲪⲎ ⲒϮ ⲈⲂⲞⲖ ⲈϤϦⲢⲀϪⲢⲈϪ ⲚⲚⲈϤⲚⲀϪϨⲒ ⲞⲨⲞϨ ϢⲀϤϢⲰⲞⲨⲒ ⲞⲨⲞϨ ⲀⲒϪⲞⲤ ⲚⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨϨⲒⲦϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲰⲠⲒϪⲰⲞⲨ ⲚⲀⲐⲚⲀϨϮ ϢⲀ ⲐⲚⲀⲨ ϮⲚⲀϢⲰⲠⲒ ⲚⲈⲘⲰⲦⲈⲚ ϢⲀ ⲐⲚⲀⲨ ϮⲚⲀⲈⲢⲀⲚⲈⲬ ⲈⲤⲐⲈ ⲘⲘⲰⲦⲈⲚ ⲀⲚⲒⲦϤ ϨⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲤⲀⲦⲞⲦϤ ⲀϤϢⲦⲈⲢⲐⲰⲢϤ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲔⲀϨⲒ ⲚⲀϤⲤⲐⲈⲢⲦⲈⲢ ⲠⲈ ⲈⲢⲈ ⲢⲰϤ ϪⲈϢ ⲤⲪⲎⲒϮ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ⲞⲨⲞϨ ⲀϤϢⲈⲚ ⲠⲈϤⲒⲰⲦ ϪⲈ ⲒⲤ ⲞⲨⲎⲢ ⲚⲬⲢⲞⲚⲞⲤ ⲒⲤϪⲈⲚ ⲈⲦⲀ ⲪⲀⲒ ϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲒⲤϪⲈⲚ ⲦⲈϤⲘⲈⲦⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ϢⲀϤϨⲒⲦϤ ⲈⲠⲒⲬⲢⲰⲘ ⲚⲈⲘ ⲠⲒⲘⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈϤⲦⲀⲔⲞϤ ⲀⲖⲖⲀ ⲠⲈⲦⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲢⲞϤ ⲀⲢⲒⲂⲞⲎ ⲐⲒⲚ ⲈⲢⲞⲚ ⲈⲀⲔϢⲈⲚϨⲎⲦ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈ ϪⲈ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲢⲞϤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲘⲪⲎ ⲈⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ⲤⲀⲦⲞⲦϤ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲚϪⲈⲪⲒⲰⲦ ⲘⲠⲒⲀⲖⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲚⲀϨϮ ⲀⲢⲒⲂⲞⲎ ⲐⲒⲚ ⲈⲦⲀⲘⲈⲦⲀⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲒⲘⲎϢ ϬⲞϪⲒ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲒⲀⲦⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲔⲞⲨⲢ ⲘⲠⲚⲈⲨⲘⲀⲀⲚⲞⲔ ⲠⲈϮⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲞⲔ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲘⲠⲈⲢϢⲈ ϪⲈ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ⲞⲨⲞϨ ⲈⲦⲀϤⲰϢ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲦⲈⲢⲐⲰⲢϤ ⲚⲞⲨⲘⲎϢ ⲀϤⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲈⲢ ⲘⲪⲢⲎϮ ⲚⲞⲨⲢⲈϤⲘⲰⲞⲨⲦ ϨⲰⲤⲦⲈ ⲚⲦⲈⲞⲨⲘⲎϢ ϪⲞⲤ ϪⲈ ⲀϤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲀⲘⲞⲚⲒ ⲚⲦⲈϤϪⲒϪ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲎⲒ Ⲁ- ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϢⲈⲚϤ ⲤⲀⲠⲤⲀ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲚⲞⲚ ⲘⲠⲈⲚϢϪⲈⲘϪⲞⲘ ⲚϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲀⲒⲄⲈⲚⲞⲤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϤⲒ ⲈⲂⲞⲖ ϦⲈⲚϨⲖⲒ ⲈⲂⲎⲖ ϦⲈⲚⲞⲨⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲈⲘ ⲞⲨⲚⲎⲤⲦⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲚⲀϤⲤⲒⲚⲒⲰⲞⲨ ⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲀϤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈϨⲖⲒ ⲈⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ⲚⲀϤϮⲤⲂⲰ ⲄⲀⲢ ⲠⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲚⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲤⲈⲚⲀϦⲞⲐⲂⲈϤ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ϤⲚⲀⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲈⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϨⲞϮ ⲈϢⲈⲚϤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲰⲞⲨ ϪⲈ ⲞⲨ ⲈⲚⲀⲢⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ⲈⲢⲰⲞⲨ ϨⲒ ⲪⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲬⲰ ⲚⲢⲰⲞⲨ ⲚⲀⲨⲤⲀϪⲒ ⲄⲀⲢ ⲠⲈ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ϨⲒ ⲪⲘⲰⲒⲦ ϪⲈ ⲚⲒⲘ ⲘⲘⲰⲞⲨ ⲠⲈ ⲠⲒⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲘⲤⲒ ⲀϤⲘⲞⲨϮ ⲈⲠⲒⲒⲂ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲈⲢϨⲞⲨⲒⲦ ⲈϤⲈⲈⲢϦⲀⲈ ⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲆⲒⲀⲔⲰⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲀⲖⲞⲨ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ϪⲈ ⲪⲎ ⲈⲐⲚⲀϢⲈⲠ ⲞⲨⲀⲒ ⲚⲚⲀⲒⲀⲖⲰⲞⲨⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲠⲀⲢⲀⲚ ⲀⲚⲞⲔ ⲠⲈⲦⲈϤϢⲰⲠ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϢⲰⲠ ⲘⲘⲞⲒ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈⲦⲈϤϢⲰⲠ ⲘⲘⲞⲒ ⲀⲖⲖⲀ ⲀϤϢⲰⲠ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲪⲢⲈϤϮ ⲤⲂⲰ ⲀⲚⲚⲀⲨ ⲈⲞⲨⲀⲒ ⲈϤϨⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲞⲨⲞϨ ⲀⲚⲦⲀϨⲚⲞ ⲘⲘⲞϤ ϪⲈ ⲚϤⲞⲨⲈϨ ⲚⲤⲰⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲘⲘⲞϤ ⲘⲘⲞⲚ ϨⲖⲒ ⲄⲀⲢ ⲪⲎ ⲈⲐⲚⲀⲒⲢⲒ ⲚⲞⲨϪⲞⲘ ⲈϪⲈⲚ ⲠⲀⲢⲀⲚ ⲞⲨⲞϨ ⲚⲦⲈϤϢϪⲈⲘϪⲞⲘ ⲚⲬⲰⲖⲈⲘ ⲈⲤⲀϪⲒ ⲈϤϨⲰⲞⲨ ϦⲀⲢⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ⲪⲎ ⲄⲀⲢ ⲈⲦⲈⲚϤⲞⲨⲂⲎⲚ ⲀⲚ ⲀϤϮ ⲈϪⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ⲪⲎ ⲄⲀⲢ ⲈⲐⲚⲀⲦⲤⲈ ⲐⲎⲚⲞⲨ ⲚⲞⲨⲀⲪⲞⲦ ⲘⲘⲰⲞⲨ ϦⲈⲚⲠⲀⲢⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈϤⲦⲀⲔⲞ ⲚϪⲈⲠⲈϤⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ⲈⲐⲚⲀϨϮ ⲚⲀⲚⲈⲤ ⲚⲀϤ ⲘⲀⲖⲖⲞⲚ ⲈⲈϢ ⲞⲨⲰⲚⲒ ⲘⲘⲞⲨⲖⲞⲚ ⲈϦⲎⲦϤ ⲞⲨⲞϨ ⲚⲦⲞⲨϨⲒⲦϤ ⲈⲪⲒⲞⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲦⲈⲔϪⲒϪ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ϪⲞϪⲤ ⲈⲂⲞⲖ ⲚⲀⲚⲈⲤ ⲚⲀⲔ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲰⲚϦ ⲈⲔⲞⲒ ⲚϪⲀϬⲎ ⲒⲈ ⲈⲢⲈ ϪⲒϪ ⲤⲚⲞⲨϮ ⲈⲢⲞⲔ ⲚⲦⲈⲔϢⲈ ⲈϮⲄⲈⲈⲚⲚⲀ ⲈⲠⲒⲬⲢⲰⲘ ⲚⲀⲦϬⲈⲚⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲦⲈⲔϬⲀⲖⲞϪ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ϪⲞϪⲤ ϨⲒⲦⲤ ⲈⲂⲞⲖ ⲚⲀⲚⲈⲤ ⲚⲀⲔ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲰⲚϦ ⲈⲔⲞⲒ ⲚϬⲀⲖⲈ ⲈϨⲞⲦⲈ ⲈⲢⲈ ⲞⲨⲞⲚ ϬⲀⲖⲞϪ ⲤⲚⲞⲨϮ ⲈⲢⲞⲔ ⲚⲤⲈϨⲒⲦⲔ ⲈϮⲄⲈⲈⲚⲚⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲠⲈⲔⲂⲀⲖ ⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲞⲔ ⲪⲞⲢⲔϤ ⲈⲂⲞⲖ ⲚⲀⲚⲈⲤ ⲚⲀⲔ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲞⲨⲂⲀⲖ ⲘⲘⲀⲨⲀⲦϤ ⲈⲦⲈⲢⲞⲔ ⲈϨⲞⲦⲈ ⲈⲞⲨⲞⲚ ⲂⲀⲖ ⲘⲘⲞⲔ ⲚⲤⲈϨⲒⲦⲔ ⲈϮⲄⲈⲈⲚⲚⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ⲠⲒⲘⲀ ⲈⲦⲈ ⲘⲠⲀⲢⲈ ⲠⲞⲨϤⲈⲚⲦ ⲘⲞⲨ ⲞⲨⲞϨ ⲠⲞⲨⲬⲢⲰⲘ ⲘⲠⲀϤϬⲈⲚⲞ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϢⲀⲨⲘⲞⲖϨϤ ⲘⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ⲚⲀⲚⲈ ⲠⲒϨⲘⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲠⲒϨⲘⲞⲨ ⲈⲢⲀⲦϨⲘⲞⲨ ⲈϢⲀⲨⲘⲞⲖϨϤ ϦⲈⲚⲞⲨ ⲘⲀⲢⲈ ϨⲘⲞⲨ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲀⲢⲒϨⲒⲢⲎⲚⲎ ϦⲈⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤⲒ ⲈⲚⲒⲐⲞϢ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎ ⲤⲞⲨⲞϨ ⲀⲨⲒ ⲞⲚ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲘⲎϢ ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲈⲦⲈ ⲦⲈϤⲤⲨⲚⲎⲐⲒⲀ ⲦⲈ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲀⲚ ⲤϢⲈ ⲚⲢⲰⲘⲒ ⲈϨⲒ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲀϤϨⲞⲚϨⲈⲚ ⲘⲘⲞϤ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚϪⲈⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚϪⲈⲘⲰⲨⲤⲎⲤ ⲈⲤϦⲈ ⲞⲨϪⲰⲘ ⲚⲤϦⲒ ⲚⲞⲨⲈⲒ ⲞⲨⲞϨ ⲈⲬⲰ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈ ⲦⲈⲦⲈⲚⲘⲈⲦⲚⲀϢⲦϨⲎ ⲦⲀϤⲤϦⲈ ⲦⲀⲒⲈⲚⲦⲞⲖⲎ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ⲒⲤϪⲈⲚ ⲦⲀⲢⲬⲎ ⲆⲈ ⲘⲠⲒⲤⲰⲚⲦ ⲞⲨϨⲰⲞⲨⲦ ⲚⲈⲘ ⲤϨⲒⲘⲒ ⲠⲈⲦⲀϤⲤⲞⲚⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ⲈⲐⲂⲈⲪⲀⲒ ⲈⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲬⲀ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲈϤⲈⲦⲞⲘϤ ⲈⲦⲈϤⲤϨⲒⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲘⲠⲂ ⲈⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ ϨⲰⲤⲦⲈ ⲤⲈⲞⲒ ⲚⲀⲚ ⲀⲖⲖⲀ ⲞⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ ⲦⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ⲪⲎ ⲞⲨⲚ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲘϤ ⲘⲠⲈⲚⲐⲢⲈ ⲪⲢⲰⲘⲒ ⲪⲞⲢϪϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲎⲒ ⲞⲚ ⲀⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϢⲈⲚϤ ⲈⲐⲂⲈⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲬ ⲀⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈϤϬⲒ ⲚⲔⲈⲞⲨⲒ ϤⲞⲒ ⲚⲚⲰⲒⲔ ⲈϪⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ⲞⲨⲞϨ ⲈϢⲰⲠ ϨⲰⲤ ⲚⲦⲈⲤⲬⲀ ⲠⲈⲤϨⲀⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈⲤϬⲒ ⲚⲔⲈⲞⲨⲀⲒ ⲤⲞⲒ ⲚⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚϨⲀⲚⲀⲖⲰⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒ ⲚⲈⲘⲰⲞⲨ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀⲠⲈϤϨⲎⲦ ⲘⲔⲀϨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲬⲀ ⲚⲒⲀⲖⲰⲞⲨⲒ ⲚⲦⲞⲨⲒ ϨⲀⲢⲞⲒ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ ⲈⲒ ϨⲀⲢⲞⲒ ⲐⲀ ⲚⲀⲒ ⲞⲨⲞⲚ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲎϮ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϢⲈⲠ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲦ ⲈⲢⲞϤ ⲀⲚ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲖⲞⲨ ⲚⲚⲈϤⲒ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲦⲞⲦϤ ⲚⲤⲰⲞⲨ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲀϤⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲈⲞⲨⲘⲰⲒⲦ ⲀϤϬⲞϪⲒ ⲚϪⲈⲞⲨⲀⲒ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲚⲀⲄⲀⲐⲞⲤ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ⲚⲦⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲒ ϪⲈ ⲠⲒⲀⲄⲀⲐⲞⲤ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲄⲀⲐⲞⲤ ⲈⲂⲎⲖ ⲈⲪⲚⲞⲨϮ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ⲚⲒⲈⲚⲦⲞⲖⲎ ⲔⲤⲰⲞⲨⲚ ⲘⲘⲰⲞⲨ ⲘⲠⲈⲢϦⲰⲦⲈⲂ ⲘⲠⲈⲢⲈⲢⲚⲰⲒⲔ ⲘⲠⲈⲢϬⲒⲞⲨⲒ ⲘⲠⲈⲢⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ⲘⲠⲈⲢϤⲰϪⲒ ⲀⲢⲒⲦⲒⲘⲀⲚ ⲘⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲦⲈⲔⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲒⲤϪⲈⲚ ⲦⲀⲘⲈⲦⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲢⲞϤ ⲀϤⲘⲈⲚⲢⲒⲦϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲈⲞⲨⲀⲒ ⲠⲈⲦⲈⲔⲈⲢϦⲀⲈ ⲘⲘⲞϤ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲀ ⲠⲈⲦⲈⲚⲦⲀⲔ ⲈⲂⲞⲖ ⲘⲎⲒⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲈⲔⲈϪⲪⲞ ⲚⲀⲔ ⲚⲞⲨⲀϨⲞ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲀⲘⲞⲨ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲰⲔⲈⲘ ⲈϪⲈⲚ ⲠⲒⲤⲀϪⲒ ⲀϤϢⲈ ⲚⲀϤ ⲈⲢⲈ ⲚⲈϤϨⲎⲦ ⲘⲞⲔϨ ⲚⲀⲢⲈ ⲞⲨⲘⲎ ϢⲄⲀⲢ ⲚϪⲪⲞ ⲚⲦⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲠⲰⲤ ⲤⲘⲞⲔϨ ⲚⲚⲎ ⲈⲦⲈ ⲚⲒⲬⲢⲎⲘⲀ ⲚⲦⲰⲞⲨ ⲈⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲀⲨⲈⲢϨⲞϮ ⲠⲈ ⲈϪⲈⲚ ⲠⲒⲤⲀϪⲒ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲞⲚ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀϢⲎⲢⲒ ⲠⲰⲤ ⲤⲘⲞⲔϨ ⲚⲦⲈⲚⲎ ⲈⲦⲈ ϨⲐⲎⲞⲨ ⲬⲎ ⲈϨⲀⲚⲬⲢⲎⲘⲀ ⲈⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ⲤⲘⲞⲦⲈⲚ ⲚⲞⲨϬⲀⲘⲞⲨⲖ ⲈⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲞⲨⲰⲦⲈⲚ ⲚⲞⲨⲘⲀⲚⲐⲰⲢⲠ ⲒⲈ ⲞⲨⲢⲀⲘⲀⲞ ⲚⲦⲈϤⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲒⲘ ⲈⲐⲚⲀϢⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ϦⲀⲦⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲘⲈⲦⲀⲦϪⲞⲘ ⲀⲖⲖⲀ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲀⲚ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲘⲠⲦⲎ ⲢϤ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚⲀϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲚⲞⲚ ⲀⲚⲬⲀ ⲠⲦⲎⲢϤ ⲚⲤⲰⲚ ⲞⲨⲞϨ ⲀⲚⲞⲨⲀϨⲦⲈⲚ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ⲠⲈϪⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲀϤⲬⲀ ⲎⲒ ⲚⲤⲰϤ ⲒⲈ ϨⲀⲚⲤⲚⲎⲞⲨ ⲒⲈ ϨⲀⲚⲤⲰⲚⲒ ⲒⲈ ⲘⲀⲨ ⲒⲈ ⲒⲰⲦ ⲒⲈ ϢⲎⲢⲒ ⲒⲈ ⲒⲞϨⲒ ⲈⲐⲂⲎⲦ ⲚⲈⲘ ⲈⲐⲂⲈ ⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ⲀϤϢⲦⲈⲘϬⲒⲦⲞⲨ ⲚⲢ ⲚⲔⲰⲂ ⲚⲤⲞⲠ ϮⲚⲞⲨ ϦⲈⲚⲠⲀⲒⲤⲎⲞⲨ ϨⲀⲚⲎⲒ ⲚⲈⲘ ϨⲀⲚⲤⲚⲎⲞⲨ ⲚⲈⲘ ϨⲀⲚⲤⲰⲚⲒ ⲚⲈⲘ ϨⲀⲚⲘⲀⲨ ⲚⲈⲘ ϨⲀⲚⲒⲰⲦ ⲚⲈⲘ ϨⲀⲚϢⲎⲢⲒ ⲚⲈⲘ ϨⲀⲚⲒⲞϨⲒ ϦⲈⲚⲚⲒⲆⲒⲰⲄⲘⲞⲤ ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲈⲰⲚ ⲈⲐⲚⲎⲞⲨ ⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ϨⲀⲚⲘⲎϢ ⲆⲈ ⲚϢⲞⲢⲠ ⲈⲨⲈⲈⲢϦⲀⲈ ⲞⲨⲞϨ ϨⲀⲚϦⲀⲈⲨ ⲈⲨⲚⲀⲈⲢϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ⲚⲀⲨϨⲒ ⲪⲘⲰⲒⲦ ⲆⲈ ⲠⲈ ⲈⲨⲚⲎⲞⲨ ⲈϨⲢⲎ ⲒⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲚⲀϤⲘⲞϢⲒ ϦⲀϪⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϨⲞϮ ⲚⲎ ⲆⲈ ⲈⲚⲀⲨⲈⲢⲀⲔⲞⲖⲞⲨⲐⲒⲚ ⲚⲀⲨⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲀϤⲒⲚⲒ ⲘⲠⲒⲒⲂ ⲈⲦⲞⲦϤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲈⲚⲎ ⲈⲐⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ϪⲈ ϨⲎⲠⲠⲈ ⲦⲈⲚⲚⲀϢⲈ ⲚⲀⲚ ⲈϨⲢⲎⲒ ⲈⲒⲖⲎ ⲘⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲤⲈⲚⲀϮϨⲀⲚ ⲘⲘⲞⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲎⲒϤ ⲚⲚⲒⲈⲐⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ⲞⲨⲞϨ ⲤⲈⲚⲀⲤⲰⲂⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲈⲚⲀϨⲒⲐⲀϤ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲈⲚⲀϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ϤⲚⲀⲦⲰⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲦⲈⲚⲞⲨⲰϢ ϨⲒⲚⲀ ⲪⲎ ⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲦⲈⲔⲀⲒϤ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲦⲈⲦⲈⲚⲞⲨⲀϢϤ ⲚⲦⲀⲀⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ⲚⲐⲰⲞⲨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲎⲒⲤ ⲚⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲀⲒ ϨⲈⲘⲤⲒ ⲤⲀⲦⲈⲔⲞⲨⲒⲚⲀⲘ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲘⲘⲞⲚ ⲤⲀⲦⲈⲔϪⲀϬⲎ ϦⲈⲚⲠⲈⲔⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲤⲈ ⲠⲒⲀⲪⲞⲦ ⲈϮⲤⲰ ⲘⲘⲞϤ ⲒⲈ ⲠⲒⲰⲘⲤ ⲈϮⲰⲘⲤ ⲘⲘⲞⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲒⲀⲪⲞⲦ ⲈϮⲤⲰ ⲘⲘⲞϤ ⲈⲢⲈⲦⲈⲚⲈⲤⲞϤ ⲞⲨⲞϨ ⲠⲒⲰⲘⲤ ⲈϮⲰⲘⲤ ⲘⲘⲞⲒ ⲘⲘⲞϤ ⲈⲢⲈⲦⲈⲚⲈⲈⲘⲤ ⲐⲎⲚⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ⲠⲒϨⲈⲘⲤⲒ ⲆⲈ ⲚⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲘⲞⲒ ⲒⲈ ϪⲀϬⲎ ⲘⲪⲰⲒ ⲀⲚ ⲠⲈ ⲈⲦⲎⲒϤ ⲀⲖⲖⲀ ⲪⲀ ⲚⲎ ⲠⲈ ⲈⲦⲀϤⲤⲈⲂⲦⲰⲦϤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲠⲒⲔⲈⲒ ⲀⲨⲈⲢϨⲎ ⲦⲤ ⲚⲬⲢⲈⲘⲢⲈⲘ ⲈⲐⲂⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲚⲎ ⲈⲐⲘⲈⲨⲒ ϪⲈ ⲤⲈⲞⲒ ⲚⲀⲢⲬⲰⲚ ⲈⲚⲒⲈⲐⲚⲞⲤ ⲤⲈⲞⲒ ⲚϬⲞⲒⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲞⲨⲚⲒϢϮ ⲤⲈⲞⲒ ⲚⲈⲢϢⲒϢⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲀⲚ ⲠⲈⲦϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲖⲖⲀ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰϢ ⲈⲈⲢⲚⲒϢϮ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲈⲈⲢⲆⲒⲀⲔⲰⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰϢ ⲈⲈⲢϨⲞⲨⲒⲦ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲈⲈⲢⲂⲰⲔ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ⲞⲨ ⲄⲀⲢ ⲠⲰⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲈⲦⲀϤⲒ ⲀⲚ ⲈⲐⲢⲞⲨϢⲈⲘϢⲎⲦϤ ⲀⲖⲖⲀ ⲈϢⲈⲘϢⲒ ⲞⲨⲞϨ ⲈϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲚⲤⲰϮ ⲚϢⲈⲂⲒⲰ ⲚⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲒⲈⲢⲒⲬⲰ ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲒⲬⲰ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲂⲀⲢⲦⲒⲘⲈⲞⲤ ⲠϢⲎⲢⲒ ⲚⲦⲒⲘⲈⲞⲤ ⲈⲞⲨⲂⲈⲖⲖⲈ ⲠⲈ ⲚⲢⲈϤⲦⲰⲂϨ ⲚⲀϤϨⲈⲘⲤⲒ ⲈⲤⲔⲈⲚ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲠⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲈϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲚⲀⲒ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲚϪⲈϨⲀⲚⲘⲎϢ ϨⲒⲚⲀ ⲚⲦⲈϤⲬⲀⲢⲰϤ ⲚⲐⲞϤ ⲆⲈ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲚⲀϤⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲚⲀⲒ ⲚⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ⲞⲨⲞϨ ⲈⲦⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲘⲞⲨϮ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨϮ ⲘⲠⲒⲂⲈⲖⲖⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲦⲰⲚⲔ ⲀⲘⲞⲨ ϤⲘⲞⲨϮ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲈⲦ ⲠⲈϤϨⲂⲞⲤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤϤⲞϪϤ ⲈⲠϢⲰⲒ ⲀϤⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲞⲨⲀϢϤ ⲚⲦⲀⲀⲒϤ ⲚⲀⲔ ⲠⲒⲂⲈⲖⲖⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲞⲨⲚⲒ ϨⲒⲚⲀ ⲚⲦⲀⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲠⲈⲔⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲈⲔ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲚⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ϦⲈⲚⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤϦⲰⲚⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀϤⲒ ⲈⲂⲎ ⲐⲪⲀⲄⲎ ⲚⲈⲘ ⲂⲎⲐⲀⲚⲒⲀ ϦⲀⲦⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲀϤⲞⲨⲰⲢⲠ ⲚⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲠⲀⲒϮⲘⲒ ⲈⲦⲬⲎ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲞⲨⲞϨ ⲤⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲚⲀϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲚⲞⲨⲤⲎϪ ⲈϤⲤⲞⲚϨ ⲪⲀⲒ ⲈⲦⲈⲘⲠⲀⲦⲈ ϨⲖⲒ ⲚⲢⲰⲘⲒ ⲀⲖⲎⲒ ⲈⲢⲞϤ ⲘⲀϮⲞⲨⲰ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲚⲒⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲞⲨⲀⲒ ϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲞϤ ⲀϪⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ϤⲚⲀⲞⲨⲞⲢⲠϤ ⲘⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨϪⲒⲘⲒ ⲚⲞⲨⲤⲎϪ ⲈϤⲤⲞⲚϨ ϦⲀⲦⲈⲚ ⲞⲨⲢⲞ ⲤⲀⲂⲞⲖ ⲘⲠⲒϦⲒⲢ ⲞⲨⲞϨ ⲀⲨϮⲞⲨⲰ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ⲞⲨⲞϨ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲘⲘⲀⲨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲞϤ ⲈⲢⲈⲦⲈⲚϮⲞⲨⲰ ⲘⲠⲒⲤⲎ Ϫ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϪⲞⲤ ⲚⲰⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨⲬⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲘⲠⲒⲤⲎϪ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨⲦⲀⲖⲈ ⲚⲞⲨϨⲂⲰⲤ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲀϤϨⲈⲘⲤⲒ ϨⲒϪⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ⲞⲨⲞϨ ϨⲀⲚⲘⲎϢ ⲀⲨⲪⲰⲢϢ ⲚⲚⲞⲨϨⲂⲰⲤ ϨⲒ ⲠⲒⲘⲰⲒⲦ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨⲔⲰⲢϪ ⲚϨⲀⲚϪⲀⲖ ⲚϢϢⲎⲚ ϦⲈⲚⲚⲒⲒⲞϨⲒ ⲞⲨⲞϨ ⲚⲀⲨⲪⲰⲢϢ ⲘⲘⲰⲞⲨ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲘⲞϢⲒ ϨⲒⲦϨⲎ ⲚⲈⲘ ⲚⲎ ⲈⲚⲀⲨⲘⲞϢⲒ ϨⲒⲪⲀϨⲞⲨ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲰⲤⲀⲚⲚⲀ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ⲤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲈⲐⲚⲎ ⲞⲨ ⲚⲦⲈⲠⲈⲚⲒⲰⲦ ⲆⲀⲨⲒⲆ ⲰⲤⲀⲚⲚⲀ ϦⲈⲚⲚⲎ ⲈⲦϬⲞⲤⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲞⲘⲤ ⲈⲠⲦⲎⲢϤ ⲈⲦⲀ ⲢⲞⲨϨⲒ ϨⲎⲆⲎ ϢⲰⲠⲒ ⲚⲦⲈⲞⲨⲞⲨⲚⲞⲨ ⲀϤⲒ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲚⲈⲘ ⲠⲒⲒⲂ ");
INSERT INTO copbhc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ⲞⲨⲞϨ ⲈⲠⲈϤⲢⲀⲤϮ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲂⲎⲐⲀⲚⲒⲀ ⲀϤϨⲔⲞ ");
INSERT INTO copbhc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ⲈⲦⲀϤⲚⲀⲨ ⲈⲞⲨⲂⲰ ⲚⲔⲈⲚⲦⲈ ϨⲒⲪⲞⲨⲈⲒ ⲈⲞⲨⲞⲚ ϨⲀⲚϪⲰⲂⲒ ϨⲒⲰⲦⲤ ⲀϤⲒ ϪⲈ ϨⲀⲢⲀ ϤⲚⲀϪⲈⲘ ϨⲖⲒ ϨⲒⲰⲦⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϪⲰⲤ ⲘⲠⲈϤϪⲈⲘ ϨⲖⲒ ⲈⲂⲎⲖ ⲈϨⲀⲚϪⲰⲂⲒ ⲚⲈⲠⲤⲎⲞⲨ ⲄⲀⲢ ⲚⲔⲈⲚⲦⲈ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲚⲚⲈ ϨⲖⲒ ϪⲈⲘ ⲞⲨⲦⲀϨ ϨⲒⲰϮ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲚⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲚⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦϮ ⲈⲂⲞⲖ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲰⲠ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲚⲒⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲚⲒⲔⲞⲖⲨⲂⲒⲤⲦⲎ ⲤⲚⲈⲘ ⲚⲒⲔⲀⲐⲈⲆⲢⲀ ⲚⲦⲈⲚⲎ ⲈⲦϮ ϬⲢⲞⲘⲠⲒ ⲈⲂⲞⲖ ⲀϤⲤⲞⲤⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ⲞⲨⲞϨ ⲚⲀϤⲬⲰ ⲚϨⲖⲒ ⲀⲚ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲚ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲀⲎⲒ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲎⲒ ⲘⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚⲀⲒϤ ⲘⲂⲎⲂ ⲚⲤⲞⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ϪⲈ ⲀⲨⲚⲀⲦⲀⲔⲞϤ ⲚⲀϢ ⲚⲢⲎϮ ⲚⲀⲨⲈⲢϨⲞϮ ⲄⲀⲢ ϦⲀⲦⲈϤϨⲎ ⲠⲒⲘⲎϢ ⲄⲀⲢ ⲦⲎⲢϤ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ⲦⲈϤⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲢⲞⲨϨⲒ ϢⲰⲠⲒ ⲚⲀϤϨⲎⲖ ⲤⲀⲂⲞⲖ ⲚϮⲂⲀⲔⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ⲞⲨⲞϨ ⲈⲨⲤⲒⲚⲒⲰⲞⲨ ⲚϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲀⲨⲚⲀⲨ ⲈϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲀⲤϢⲰⲞⲨⲒ ϨⲒ ⲦⲈⲤⲚⲞⲨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲪⲘⲈⲨⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲒⲤ ϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲈⲦⲀⲔⲤⲀϨⲞⲨⲒ ⲈⲢⲞⲤ ⲀⲤϢⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲬⲀ ⲞⲨⲚⲀϨϮ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ⲀⲘⲎⲚ ⲄⲀⲢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϪⲞⲤ ⲘⲠⲀⲒⲦⲰⲞⲨ ϪⲈ ϤⲒⲦⲔ ⲞⲨⲞϨ ϨⲒⲦⲔ ⲈⲪⲒⲞⲘ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲦⲈⲘϬⲒⲤⲀⲚⲒⲤ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲀⲖⲖⲀ ⲚⲦⲈϤⲚⲀϨϮ ϪⲈ ⲪⲎ ⲈⲦⲈϤϪⲰ ⲘⲘⲞϤ ϤⲚⲀϢⲰⲠⲒ ⲈϤⲈϢⲰⲠⲒ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ⲈⲐⲂⲈⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲀϨϮ ϪⲈ ⲀⲢⲈⲦⲈⲚϬⲒ ⲞⲨⲞϨ ⲈⲤⲈϢⲰⲠⲒ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲬⲰ ⲈⲂⲞⲖ ⲘⲠⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲰⲦⲈⲚ ⲈⲢⲞϤ ϨⲒⲚⲀ ϨⲰϤ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲚⲦⲈϤⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲚⲠⲀⲢⲀⲠⲦⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ⲞⲨⲞϨ ϨⲞⲦⲀⲚ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲬⲰ ⲈⲂⲞⲖ ⲞⲨⲆⲈ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲚⲚⲈϤⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲀⲚ ⲘⲠⲈⲦⲈⲚⲠⲀⲢⲀⲠⲦⲰⲘⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ⲞⲨⲞϨ ⲀⲨⲒ ⲞⲚ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲈϤⲘⲞϢⲒ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲔⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ ⲒⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϮ ⲚⲀⲔ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ϨⲒⲚⲀ ⲚⲦⲈⲔⲒⲢⲒ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲀϢⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲞⲨⲤⲀϪⲒ ⲚⲞⲨⲰⲦ ⲀⲢⲒⲞⲨⲰ ⲚⲎⲒ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲒⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϢⲀⲚ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲀⲢⲒⲞⲨⲰ ⲚⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ⲞⲨⲞϨ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϢⲀⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϤⲚⲀϪⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ⲀⲖⲖⲀ ⲚⲦⲈⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲦⲈⲚⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲘⲎϢ ⲚⲀⲢⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲄⲀⲢ ⲚⲦⲞⲦⲞⲨ ⲦⲎⲢⲞⲨ ϪⲈ ⲞⲚⲦⲰⲤ ⲚⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢⲞⲨⲰ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲞⲨⲞϨ ⲒⲎⲤⲞⲨⲤ ϨⲰϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲀⲒⲒⲢⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲀϤϬⲞ ⲚⲞⲨⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲀϤⲔⲰⲦ ⲚⲞⲨϪⲞⲒ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲀϤϢⲰⲔ ⲚⲞⲨϨⲢⲰⲦ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤⲔⲰⲦ ⲚⲞⲨⲠⲨⲢⲄⲞⲤ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚϨⲀⲚⲞⲨⲒⲎ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ ");
INSERT INTO copbhc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ϨⲀ ⲚⲒⲞⲨⲒⲎ ϦⲈⲚⲠⲤⲎ ⲞⲨ ⲚⲞⲨⲂⲰⲔ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲒⲞⲨⲒⲎ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ⲞⲨⲞϨ ⲈⲦⲀⲨϬⲒⲦϤ ⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲢⲠϤ ⲈϤϢⲞⲨⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲞⲚ ϨⲀⲢⲰⲞⲨ ⲚⲔⲈⲂⲰⲔ ⲞⲨⲞϨ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲀⲨⲪⲞⲖϨϤ ⲞⲨⲞϨ ⲀⲨϢⲞϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲚⲔⲈⲞⲨⲀⲒ ⲞⲨⲞϨ ⲠⲒⲬⲈⲦ ⲀⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲚϨⲀⲚⲔⲈⲘⲎ ϢϨⲀⲚⲞⲨⲞⲚ ⲀⲨϨⲒⲰⲚⲒ ⲈⲢⲰⲞⲨ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨϦⲰⲦⲈⲂ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ⲈⲦⲒ ⲞⲨϢⲎⲢⲒ ⲘⲘⲈⲚⲢⲒⲦ ⲈⲚⲀϤⲚⲦⲀϤ ⲀϤⲞⲨⲞⲢⲠϤ ⲈⲠϦⲀⲈ ϨⲀⲢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲚⲀϢⲪⲒⲦ ϦⲀⲦϨⲎ ⲘⲠⲀϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ⲚⲒⲞⲨⲒⲎ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲀⲘⲰⲒⲚⲒ ⲘⲀⲢⲈⲚϦⲞⲐⲂⲈϤ ⲚⲦⲈϮⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ⲈⲢⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ⲞⲨⲞϨ ⲈⲦⲀⲨϬⲒⲦϤ ⲀⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲀⲨϨⲒⲦϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ⲞⲨ ⲠⲈ ⲈⲦⲈϤⲚⲀⲀⲒϤ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ϤⲚⲀⲒ ⲞⲨⲞϨ ϤⲚⲀⲦⲀⲔⲞ ⲚⲚⲒⲞⲨⲒⲎ ⲞⲨⲞϨ ⲚⲦⲈϤϮ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ⲞⲨⲆⲈ ⲦⲀⲒⲄⲢⲀⲪⲎ ⲘⲠⲈⲦⲈⲚⲰϢ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲰⲚⲒ ⲈⲦⲀⲨϢⲞϢϤ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰⲦ ⲪⲀⲒ ⲀϤϢⲰⲠⲒ ⲚⲞⲨϪⲰϪ ⲚⲖⲀⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ⲈⲦⲀ ⲪⲀⲒ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠϬⲞⲒⲤ ⲞⲨⲞϨ ϤⲞⲒ ⲚϢⲪⲎⲢⲒ ϦⲈⲚⲚⲈⲚⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲚⲤⲀⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲘⲎϢ ⲀⲨⲈⲘⲒ ⲄⲀⲢ ϪⲈ ⲈⲦⲀϤϪⲈ ⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲐⲂⲎ ⲦⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨⲬⲀϤ ⲀⲨϢⲈ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϨⲀⲚⲞⲨⲞⲚ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲎⲢⲰⲆⲒⲀⲚⲞⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨϪⲞⲢϪϤ ⲚⲞⲨⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮ ⲤⲂⲰ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲐⲘⲎⲒ ⲞⲨⲞϨ ⲤⲈⲢⲘⲈⲖⲒⲚ ⲚⲀⲔ ⲀⲚ ϦⲀ ϨⲖⲒ ⲞⲨ ⲄⲀⲢ ⲔϪⲞⲨϢⲦ ⲈϨⲞ ⲚⲢⲰⲘⲒ ⲀⲚ ⲀⲖⲖⲀ ⲔϮⲤⲂⲰ ⲘⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲤϢⲈ ⲚϮϨⲰϮ ⲘⲠⲞⲨⲢⲞ ϢⲀⲚ ⲘⲘⲞⲚ ⲚⲦⲈⲚϮ ϢⲀⲚ ⲚⲦⲈⲚϢⲦⲈⲘϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ⲚⲐⲞϤ ⲆⲈ ⲈϤⲤⲰⲞⲨⲚ ⲚⲦⲞⲨⲘⲈⲦϢⲞⲂⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϬⲰⲚⲦ ⲘⲘⲞⲒ ⲀⲚⲒⲞⲨⲒ ⲚⲎⲒ ⲚⲞⲨⲤⲀⲐⲈⲢⲒ ϨⲒⲚⲀ ⲚⲦⲀⲚⲀⲨ ⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲒⲚⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲐⲀ ⲚⲒⲘ ⲦⲈ ⲦⲀⲒϨⲒⲔⲰⲚ ⲚⲈⲘ ⲦⲀⲒⲈⲠⲒⲄⲢⲀⲪⲎ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲀ ⲠⲞⲨⲢⲞ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲀ ⲠⲞⲨⲢⲞ ⲘⲎⲒⲦⲞⲨ ⲘⲠⲞⲨⲢⲞ ⲞⲨⲞϨ ⲚⲀ ⲪⲚⲞⲨϮ ⲘⲎⲒⲦⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϪⲰϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϢⲞⲠ ⲞⲨⲞϨ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲘⲰⲨⲤⲎⲤ ⲀϤⲤϦⲀⲒ ⲚⲀⲚ ϪⲈ ⲈϢⲰⲠ ⲚⲦⲈⲠⲤⲞⲚ ⲚⲞⲨⲀⲒ ⲘⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲈϪⲠ ⲞⲨⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲦⲈⲘⲬ ⲀϢⲎⲢⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈϤⲤⲞⲚ ϬⲒ ⲚϮⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲞⲨⲚⲞⲤ ⲞⲨϪⲢⲞϪ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ⲚⲈ ⲞⲨⲞⲚ ⲌⲆⲈ ⲚⲤⲞⲚ ϦⲀⲦⲞⲦⲈⲚ ⲠⲈ ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲒⲦ ϬⲒⲤϨⲒⲘⲒ ⲚⲀϤⲘⲞⲨ ⲘⲠⲈϤⲬⲀ ϪⲢⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ⲞⲨⲞϨ ⲠⲒⲘⲀϨⲂ ⲀϤϬⲒⲦⲤ ⲞⲨⲞϨ ⲀϤⲘⲞⲨ ⲘⲠⲈϤⲬⲀ ϪⲢⲞϪ ⲞⲨⲞϨ ⲠⲒⲘⲀϨⲄ ⲘⲠⲀⲒⲢⲎϮ ⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ⲞⲨⲞϨ ⲠⲒⲘⲀϨⲌ ⲘⲠⲞⲨⲬⲀ ϪⲢⲞϪ ⲈⲠϦⲀⲈ ⲆⲈ ⲘⲘⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲤⲘⲞⲨ ⲚϪⲈϮⲔⲈⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ϦⲈⲚ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲀⲤⲚⲀⲈⲢ ⲤϨⲒⲘⲒ ⲚⲚⲒⲘ ⲘⲘⲰⲞⲨ ⲠⲒⲌ ⲄⲀⲢ ⲀⲨϬⲒⲦⲤ ⲚⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲎ ⲈⲐⲂⲈⲪⲀⲒ ⲀⲚ ⲦⲈⲦⲈⲚⲤⲞⲢⲈⲘ ⲚⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ⲚϮⲄⲢⲀⲪⲎ ⲞⲨⲆⲈ ϮϪⲞⲘ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ϨⲞⲦⲀⲚ ⲄⲀⲢ ⲀⲨϢⲀⲚⲦⲰⲞⲨⲚⲞⲨ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲞⲨⲆⲈ ⲘⲠⲀⲨϬⲒ ⲞⲨⲆⲈ ⲘⲠⲀⲨϬ ⲒⲦⲞⲨ ⲀⲖⲖⲀ ⲀⲨⲘⲪⲢⲎϮ ⲚⲚⲒⲀⲄⲄⲈⲖⲞⲤ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ⲈⲐⲂⲈ ⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲆⲈ ϪⲈ ⲤⲈⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲘⲠⲈⲦⲈⲚⲰϢ ϨⲒ ⲠϪⲰⲘ ⲘⲘⲰⲨⲤⲎⲤ ⲠⲰⲤ ⲀϤϪⲞⲤ ⲚⲀϤ ϨⲒϪⲈⲚ ⲠⲒⲂⲀⲦⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲪⲚⲞⲨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ⲪⲚⲞⲨϮ ⲪⲀ ⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲚⲎ ⲈⲦⲞⲚϦ ⲦⲈⲦⲈⲚⲤⲞⲢⲈⲘ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ⲞⲨⲞϨ ⲀϤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲀⲒ ⲚⲚⲒⲤⲀϦ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲈⲨⲔⲰϮ ⲈϤⲈⲘⲒ ϪⲈ ⲔⲀⲖⲰⲤ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲀϤϢⲈⲚϤ ϪⲈ ⲀϢ ⲦⲈ ϮⲈⲚⲦⲞⲖⲎ ⲈⲦⲞⲒ ⲚϢⲞⲢⲠ ⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϮϢⲞⲢⲠ ⲦⲈ ⲐⲀⲒ ⲤⲰⲦⲈⲘ ⲠⲒⲤⲖ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲠϬⲞⲒⲤ ⲞⲨⲀⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ⲞⲨⲞϨ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔϨⲎⲦ ⲦⲎⲢϤ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲔⲘⲈⲨⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲔϪⲞⲘ ⲦⲎⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ϮⲘⲀϨⲤⲚⲞⲨϮ ⲦⲈ ⲐⲀⲒ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ ⲘⲘⲞⲚ ⲔⲈⲈⲚⲦⲞⲖⲎ ⲈⲤⲞⲒ ⲚⲚⲒϢϮ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϪⲈⲠⲒⲤⲀϦ ϪⲈ ⲔⲀⲖⲰⲤ ⲠⲒⲢⲈϤϮⲤⲂⲰ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲀⲔϪⲞⲤ ϪⲈ ⲞⲨⲀⲒ ⲠⲈ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲔⲈⲞⲨⲀⲒ ⲈⲂⲎⲖ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ⲞⲨⲞϨ ⲠⲒⲘⲈⲚⲢⲒⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔϨⲎ ⲦⲦⲎⲢϤ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲔϪⲞⲘ ⲦⲎⲢⲤ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲀϮ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲠⲒⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ ⲤⲈⲞⲒ ⲚⲚⲒϢϮ ⲈⲚⲒϬⲖⲒⲖ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϢⲞⲨϢⲰⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀϤⲈⲢⲞⲨⲰ ⲈⲞⲨⲞⲚ ϨⲎⲦ ⲘⲘⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲬⲞⲨⲎⲞⲨ ⲀⲚ ⲈⲂⲞⲖ ϨⲀ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ϢⲈⲢⲦⲞⲖⲘⲀⲚ ⲈϢⲈⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲠⲰⲤ ⲤⲈϪⲰ ⲘⲘⲞⲤ ⲚϪⲈⲚⲒⲤⲀϦ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ⲚⲐⲞϤ ⲆⲀⲨⲒⲆ ⲀϤϪⲞⲤ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ϪⲈ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲀϬⲞⲒⲤ ϪⲈ ϨⲈⲘⲤⲒ ⲤⲀⲦⲀⲞⲨⲒⲚⲀⲘ ϢⲀϮⲬⲀ ⲚⲈⲔϪⲀϪⲒ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈⲔϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ⲚⲐⲞϤ ⲆⲀⲨⲒⲆ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈϤϢⲎⲢⲒ ⲠⲈ ⲞⲨⲞϨ ⲠⲒⲘⲎϢ ⲈⲦⲞϢ ⲚⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ϨⲎⲆⲈⲰⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ⲞⲨⲞϨ ϦⲈⲚⲦⲈϤⲤⲂⲰ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲀⲨ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲎ ⲈⲐⲞⲨⲰϢ ⲈⲘⲞϢⲒ ϦⲈⲚϨⲀⲚⲤⲦⲞⲖⲎ ⲚⲈⲘ ϨⲀⲚⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲚⲒⲀⲄⲞⲢⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ⲚⲈⲘ ϨⲀⲚϢⲞⲢⲠ ⲘⲘⲀⲚϨⲈⲘⲤⲒ ϦⲈⲚⲚⲒⲔⲀⲐⲈⲆⲢⲀ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ϨⲀⲚϢⲞⲢⲠ ⲚⲢⲰⲦⲈⲂ ϦⲈⲚⲚⲒⲆⲒⲠⲚⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ⲚⲎ ⲈⲐⲞⲨⲰⲘ ⲚⲚⲒⲎⲒ ⲚⲦⲈⲚⲒⲬⲎⲢⲀ ⲞⲨⲞϨ ϦⲈⲚⲞⲨⲖⲰⲒϪⲒ ⲈⲤⲞⲨⲎⲞⲨ ⲤⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲚⲀⲒ ⲈⲐⲚⲀϬⲒ ⲚⲞⲨϨⲞⲨⲞ ϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲘⲤⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲚⲀϤⲚⲀⲨ ϪⲈ ⲠⲰⲤ ⲚⲒⲘⲎϢ ϨⲒ ϨⲞⲘⲦ ⲈⲠⲒⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲚⲢⲀⲘⲀⲞ ⲚⲀⲨϨⲒⲞⲨⲒ ⲚϨⲀⲚⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ⲈⲦⲀⲤⲒ ⲆⲈ ⲚϪⲈⲞⲨⲬⲎⲢⲀ ⲚϨⲎⲔⲒ ⲀⲤϨⲒⲞⲨⲒ ⲚⲦⲈⲂⲒ ⲤⲚⲞⲨϮ ⲈⲦⲈ ⲞⲨⲔⲞⲚⲆⲢⲀⲚⲦⲎⲤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲀⲒⲬⲎⲢⲀ ⲚϨⲎⲔⲒ ⲀⲤϨⲒⲞⲨⲒ ⲈϨⲞⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϨⲒⲞⲨⲒ ⲈⲠⲒⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲢϨⲞⲨⲞ ⲈⲢⲰⲞⲨ ⲐⲀⲒ ⲆⲈ ⲚⲐⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲤⲈⲢϦⲀⲈ ⲘⲘⲞϤ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲀⲤ ⲀⲤϨⲒⲦⲞⲨ ⲠⲈⲤⲰⲚϦ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲬⲚⲀⲨ ϪⲈ ϨⲀⲚⲀϢ ⲚⲢⲎϮ ⲚⲈⲚⲀⲒⲰⲚⲒ ⲞⲨⲞϨ ϨⲀⲚⲔⲰⲦ ⲚⲀϢ ⲚⲢⲎϮ ");
INSERT INTO copbhc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲬⲚⲀⲨ ⲈⲚⲀⲒⲚⲒϢϮ ⲚⲰⲚⲒ ⲚⲚⲞⲨⲬⲀ ⲞⲨⲰⲚⲒ ⲈϪⲈⲚ ⲞⲨⲰⲚⲒ ⲘⲠⲀⲒⲘⲀ ⲚⲤⲈⲚⲀⲂⲞⲖϤ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ⲞⲨⲞϨ ⲈϤϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲈⲢⲪⲈⲒ ⲀⲨϢⲈⲚϤ ⲚⲤⲀⲠⲤⲀ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ϪⲈ ⲀϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲀⲢⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲒ ⲚⲐⲚⲀⲨ ⲞⲨⲞϨ ⲞⲨ ⲠⲈ ⲠⲒⲘⲎⲒⲚⲒ ⲀⲢⲈϢⲀⲚ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲞⲨⲒ ⲈϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ⲤⲈⲢⲈⲘ ⲐⲎⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚⲀⲒ ϦⲈⲚⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲤⲈⲢⲈⲘ ⲞⲨⲘⲎϢ ");
INSERT INTO copbhc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ϨⲞⲦⲀⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲠⲞⲖⲈⲘⲞⲤ ⲚⲈⲘ ϨⲀⲚⲤⲘⲎ ⲘⲠⲞⲖⲈⲘⲞⲤ ⲘⲠⲈⲢϢⲐⲞⲢⲦⲈⲢ ϨⲰϮ ⲠⲈ ⲚⲦⲞⲨϢⲰⲠⲒ ⲀⲖⲖⲀ ⲘⲠⲀⲦⲈϤⲒ ⲚϪⲈⲠⲒϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ⲈϤⲈⲦⲰⲚϤ ⲄⲀⲢ ⲚϪⲈⲞⲨⲈⲐⲚⲞⲤ ⲈϪⲈⲚ ⲞⲨⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲈϪⲈⲚ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚⲘⲞⲚⲘⲈⲚ ⲔⲀⲦⲀ ⲘⲀ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚϨⲂⲰⲚ ϨⲎ ⲚⲚⲒⲚⲀⲔϨⲒ ⲚⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ⲀⲚⲀⲨ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲤⲈⲚⲀϮ ⲐⲎⲚⲞⲨ ⲈϨⲀⲚⲘⲀⲚϮϨⲀⲠ ⲞⲨⲞϨ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲤⲈⲚⲀϨⲒⲞⲨⲒ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲚⲦⲞⲨⲦⲀϨⲰⲦⲈⲚ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲀϨⲢⲈⲚ ϨⲀⲚϨⲎⲄⲈⲘⲰⲚ ⲚⲈⲘ ϨⲀⲚⲞⲨⲢⲰⲞⲨ ⲈⲐⲂⲎⲦ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ϨⲰϮ ⲚϢⲞⲢⲠ ⲚⲦⲞⲨϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲞⲨⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲨϮ ⲘⲘⲰⲦⲈⲚ ⲘⲠⲈⲢⲈⲢϢⲞⲢⲠ ⲚϤⲒⲢⲰⲞⲨϢ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲤⲀϪⲒ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲠⲈⲦⲞⲨⲚⲀⲦⲎ ⲒϤ ⲚⲰⲦⲈⲚ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲀⲒ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲤⲀϪⲒ ⲘⲘⲞϤ ⲚⲐⲰⲦⲈⲚ ⲄⲀⲢ ⲀⲚ ⲠⲈⲐⲚⲀⲤⲀϪⲒ ⲀⲖⲖⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲤⲞⲚ ϮⲚⲞⲨⲤⲞⲚ ⲈⲪⲘⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲒⲰⲦ ⲈϤⲈϮ ⲚⲞⲨϢⲎⲢⲒ ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲚϪⲈϨⲀⲚϢⲎⲢⲒ ⲈϪⲈⲚ ϨⲀⲚⲒⲞϮ ⲞⲨⲞϨ ⲤⲈⲚⲀϦⲞⲐⲂⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϢⲰⲠⲒ ⲈⲨⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲀⲘⲞⲚⲒ ⲚⲦⲞⲦϤ ϢⲀ ⲈⲂⲞⲖ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲐⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲠⲒⲤⲰϤ ⲚⲦⲈⲠⲒϢⲰϤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲤϢⲈ ⲀⲚ ⲪⲎ ⲈⲦⲰϢ ⲘⲀⲢⲈϤⲔⲀϮ ⲦⲞⲦⲈ ⲚⲎ ⲈⲦⲬⲎ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲘⲀⲢⲞⲨⲪⲰⲦ ⲈϪⲈⲚ ⲚⲒⲦⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ⲪⲎ ⲈⲦϨⲒϪⲈⲚ ⲠϪⲈⲚⲈⲪⲰⲢ ⲘⲠⲈⲚⲐⲢⲈϤⲒ ⲈϦⲢⲎⲒ ⲞⲨⲆⲈ ⲘⲠⲈⲚⲐⲢⲈϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲈⲖ ϨⲖⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ⲞⲨⲞϨ ⲪⲎ ⲈⲦϦⲈⲚ ⲦⲔⲞⲒ ⲘⲠⲈⲚⲐⲢⲈϤⲒ ⲈⲪⲀϨⲞⲨ ⲈⲈⲖ ⲠⲈϤϨⲂⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲎ ⲈⲦⲈⲘⲂⲞⲔⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϮϬⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ⲀⲢⲒⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲆⲈ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘϢⲰⲠⲒ ϦⲈⲚⲦⲪⲢⲰ ⲚϪⲈⲠⲈⲦⲈⲚⲪⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ⲈⲨⲈϢⲰⲠⲒ ⲄⲀⲢ ⲚϪⲈⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ϨⲞϪϨⲈϪ ⲘⲠⲈ ⲞⲨⲞⲚ ϢⲰⲠⲒ ⲘⲠⲈϤⲢⲎϮ ⲒⲤϪⲈⲚ ϨⲎ ⲘⲠⲒⲤⲰⲚⲦ ⲈⲦⲀϤⲤⲞⲚⲦϤ ⲚϪⲈⲪⲚⲞⲨϮ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ⲞⲨⲞϨ ⲚⲚⲈ ⲞⲨⲞⲚ ϢⲰⲠⲒ ⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ⲞⲨⲞϨ ⲈⲚⲈ ⲘⲠⲈ ⲠϬⲞⲒⲤ ⲈⲐⲢⲈ ⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲔⲞⲨϪⲒ ⲚⲀⲨⲚⲀⲚⲞϨⲈⲘ ⲀⲚ ⲠⲈ ⲚϪⲈⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲚⲒⲤⲰⲦⲠ ⲈⲦⲀϤⲤⲞⲦⲠⲞⲨ ⲀϤϪⲈϪⲈⲂ ⲚⲒⲈϨⲞⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲞⲨⲀⲒ ϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲒⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲀⲘⲚⲀⲒ ⲒⲈ ϨⲀⲘⲚⲎ ⲘⲠⲈⲢⲚⲀϨϮ ");
INSERT INTO copbhc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ⲈⲨⲈⲦⲰⲞⲨⲚⲞⲨ ⲄⲀⲢ ⲚϪⲈϨⲀⲚⲬⲢⲒⲤⲦⲞⲤ ⲚⲚⲞⲨϪ ⲚⲈⲘ ϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲞⲨⲞϨ ⲚⲦⲞⲨϮ ⲚϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ⲈⲠϪⲒⲚⲤⲰⲢⲈⲘ ⲀⲨϢⲀⲚϢϪⲈⲘϪⲞⲘ ⲚⲚⲒⲔⲈⲤⲰⲦⲠ ");
INSERT INTO copbhc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲚⲀⲨ ϪⲈ ⲀⲒⲈⲢϢⲞⲢⲠ ⲚϪⲈϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ⲀⲖⲖⲀ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲘⲈⲚⲈⲚⲤⲀ ⲠϨⲞϪϨⲈϪ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲒⲢⲎ ⲈϤⲈⲈⲢⲬ ⲀⲔⲒ ⲞⲨⲞϨ ⲠⲒⲒⲞϨ ⲚⲚⲈϤϮ ⲘⲠⲈϤⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ⲞⲨⲞϨ ⲚⲒⲤⲒⲞⲨ ⲈⲨⲈϢⲰⲠⲒ ⲈⲨϨⲒⲰⲞⲨⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲚⲒϪⲞⲘ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲈⲨⲈⲔⲒⲘ ");
INSERT INTO copbhc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲨⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲎⲞⲨ ϦⲈⲚϨⲀⲚϬⲎⲠⲒ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚϪⲞⲘ ⲚⲈⲘ ⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ⲦⲞⲦⲈ ϤⲚⲀⲞⲨⲰⲢⲠ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲞϨ ϤⲚⲀⲐⲰⲞⲨϮ ⲚⲚⲈϤⲤⲰⲦⲠ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϤⲦⲞⲨ ⲐⲎⲞⲨ ⲒⲤϪⲈⲚ ⲀⲨⲢⲎϪϤ ⲘⲠⲔⲀϨⲒ ϢⲀ ⲀⲨⲢⲎϪⲤ ⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ⲈⲂⲞⲖ ⲆⲈ ϦⲈⲚϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲀⲢⲒⲈⲘⲒ ⲈϮⲠⲀⲢⲞⲂⲞⲖⲎ ⲈϢⲰⲠ ϨⲎⲆⲎ ⲚⲦⲈⲚⲈⲤϪⲀⲖ ϬⲚⲞⲚ ⲞⲨⲞϨ ⲚⲦⲈⲤϨⲒ ϪⲰⲂⲒ ⲈⲂⲞⲖ ϢⲀⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ϤϦⲈⲚⲦ ⲚϪⲈⲠⲒϢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲘ ϨⲰⲦⲈⲚ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲈⲀⲨϢⲰⲠⲒ ⲀⲢⲒⲈⲘⲒ ϪⲈ ϤϦⲰⲚⲦ ⲈⲚⲒⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲤⲒⲚⲒ ϢⲀⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲔⲀϨⲒ ⲤⲈⲚⲀⲤⲒⲚⲒ ⲚⲀⲤⲀϪⲒ ⲆⲈ ⲚⲚⲞⲨⲤⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ⲈⲐⲂⲈ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲘ ϮⲞⲨⲚⲞⲨ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲘⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲆⲈ ⲀⲄⲄⲈⲖⲞⲤ ϦⲈⲚⲦⲪⲈ ⲞⲨⲆⲈ ⲠϢⲎⲢⲒ ⲈⲂⲎⲖ ⲈⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ϪⲞⲨϢⲦ ⲈⲂⲞⲖ ⲢⲰⲒⲤ ⲀⲢⲒⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲚⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲐⲚⲀⲨ ⲠⲈ ⲠⲒⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ⲘⲪⲢⲎϮ ⲚⲞⲨⲢⲰⲘⲒ ⲈⲀϤⲘⲞϢⲒ ⲈⲠϢⲈⲘⲘⲞ ⲈⲀϤⲬⲰ ⲘⲠⲈϤⲎⲒ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲘⲠⲒⲈⲢϢⲒϢⲒ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲠⲈϤϨⲰⲂ ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦϤ ⲘⲠⲒⲈⲘⲚⲞⲨⲦ ϨⲒⲚⲀ ⲚⲦⲈϤⲢⲰⲒⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ⲢⲰⲒⲤ ⲞⲨⲚ ⲚⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲀⲢⲈ ⲠϬⲞⲒⲤ ⲘⲠⲒⲎⲒ ⲚⲎⲞⲨ ⲚⲐⲚⲀⲨ ⲒⲈ ϨⲀⲚⲀⲢⲞⲨϨⲒ ⲒⲈ ⲦⲪⲀϢⲒ ⲘⲠⲒⲈϪⲰⲢϨ ⲒⲈ ⲈⲢⲈ ⲠⲒⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲒⲈ ϨⲀⲚⲀⲦⲞⲞⲨⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ⲘⲎⲠⲰⲤ ⲚⲦⲈϤⲒ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲚⲦⲈϤϪⲈⲘ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ ϮϪⲰ ⲘⲘⲞϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲢⲰⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ⲚⲈ ⲚⲒⲠⲀⲤⲬⲀ ⲆⲈ ⲠⲈ ⲚⲈⲘ ⲚⲒⲀⲦϢⲈⲘⲎ ⲢⲘⲈⲚⲈⲚⲤⲀ ⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ϪⲈ ⲠⲰⲤ ⲚⲦⲞⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲬⲢⲞϤ ⲚⲦⲞⲨϦⲞⲐⲂⲈϤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ⲚⲀⲨϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲀⲒⲤ ϦⲈⲚⲠϢⲀⲒ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲞⲨϢⲐⲞⲢⲦⲈⲢ ϢⲰⲠⲒ ϦⲈⲚⲠⲒⲖⲀⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ⲞⲨⲞϨ ⲈϤⲬⲎ ϦⲈⲚⲂⲎⲐⲀⲚⲒⲀ ϦⲈⲚⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲔⲀⲔⲤⲈϨⲦ ⲈϤⲢⲰⲦⲈⲂ ⲀⲤⲒ ⲚϪⲈⲞⲨⲤϨⲒⲘⲒ ⲈⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲞⲔⲒ ⲚⲤⲞϪⲈⲚ ⲚⲚⲀⲢⲆⲞⲤ ⲚⲦⲞⲦⲤ ⲘⲠⲒⲤⲦⲒⲔⲎ ⲈⲚⲀϢⲈ ⲚⲤⲞⲨⲈⲚϤ ⲈⲀⲤϦⲞⲘϦⲈⲘ ⲘⲠⲒⲘⲞⲔⲒ ⲈⲀⲤϪⲞϢϤ ⲈϪⲈⲚ ⲦⲈϤⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ⲚⲀⲢⲈ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲬⲢⲈⲘⲢⲈⲘ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ Ⲁ- ⲠⲀⲒⲦⲀⲔⲞ ⲚⲦⲈⲠⲀⲒⲤⲞϪⲈⲚ ϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ⲚⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲈϮ ⲘⲪⲀⲒ ⲈⲂⲞⲖ ⲤⲀⲠϢⲰⲒ ⲚⲦ ⲚⲤⲀⲐⲈⲢⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲦⲎ ⲒⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲚⲀⲨⲘⲂⲞⲚ ⲈⲢⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲬⲀⲤ ⲀϦⲰⲦⲈⲚ ⲦⲈⲦⲈⲚϮϦⲒⲤⲒ ⲚⲀⲤ ⲞⲨϨⲰⲂ ⲄⲀⲢ ⲈⲚⲀⲚⲈϤ ⲈⲦⲀⲤⲈⲢϨⲰⲂ ⲈⲢⲞϤ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲚⲒϨⲎⲔⲒ ⲤⲈⲚⲈⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲚⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲰⲞⲨ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲀⲚⲞⲔ ⲆⲈ ϮⲚⲈⲘⲰⲦⲈⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ⲪⲎ ⲈⲦⲀⲤϬⲒⲦϤ ⲀⲤⲀⲒϤ ⲀⲤⲈⲢϢⲞⲢⲠ ⲄⲀⲢ ⲚⲐⲀϨⲤ ⲠⲀⲤⲰⲘⲀ ⲘⲠⲀⲒⲤⲞϪⲈⲚ ⲈⲠϪⲒⲚⲔⲞⲤⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲠⲒⲘⲀ ⲈⲦⲞⲨⲚⲀϨⲒⲰⲒϢ ⲘⲠⲀⲒⲈⲨⲀⲄⲄⲖⲒⲞⲚ ⲘⲘⲞϤ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲪⲎ ϨⲰϤ ⲈⲦⲈ ⲐⲀⲒ ⲀⲒϤ ⲈⲨⲈⲤⲀϪⲒ ⲘⲘⲞϤ ⲈⲨⲘⲈⲨⲒ ⲚⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ⲞⲨⲞϨ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲠⲒⲞⲨⲀⲒ ⲚⲦⲈⲠⲒⲒ ⲀϤϢⲈ ⲚⲀϤ ϨⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϨⲒⲚⲀ ⲚⲦⲈϤⲦⲎⲒϤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲀⲨⲢⲀϢⲒ ⲞⲨⲞϨ ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨϨⲀⲦ ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ϪⲈ ⲠⲰⲤ ϤⲚⲀⲦⲎⲒϤ ϦⲈⲚⲞⲨⲈⲨⲔⲈⲢⲒⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲒⲦ ⲚⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲀⲦϢⲈⲘⲎ ⲢϨⲞⲦⲈ ⲈⲨϢⲰⲦ ⲘⲠⲒⲠⲀⲤⲬⲀ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲬⲞⲨⲰϢ ⲚⲦⲈⲚϢⲈ ⲈⲐⲰⲚ ⲚⲦⲈⲚⲤⲞⲂϮ ϨⲒⲚⲀ ⲚⲦⲈⲔⲞⲨⲰⲘ ⲘⲠⲒⲠⲀⲤⲬ Ⲁ ");
INSERT INTO copbhc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲚⲚⲦⲈ ⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϮⲂⲀⲔⲒ ⲞⲨⲞϨ ϤⲚⲀⲈⲢⲀⲠⲀⲚⲦⲀⲚ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈϤϤⲀⲒ ⲚⲞⲨϢⲞϢⲞⲨ ⲘⲘⲰⲞⲨ ⲘⲞϢⲒ ⲚⲤⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲈⲦⲈϤⲚⲀϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲀϪⲞⲤ ⲘⲠⲒⲚⲈⲂⲎⲒ ϪⲈ ⲠⲈϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ϪⲈ ⲀϤⲐⲰⲚ ⲠⲒⲘⲀⲚⲘⲦⲞⲚ ⲠⲒⲘⲀ ⲈϮⲚⲀⲞⲨⲰⲘ ⲘⲠⲒⲠⲀⲤⲬⲀ ⲘⲘⲞϤ ⲚⲈⲘ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ⲞⲨⲞϨ ⲚⲐⲞϤ ϤⲚⲀⲦⲀⲘⲈ ⲐⲎⲚⲞⲨ ⲈⲞⲨⲚⲒϢϮ ⲘⲘⲀ ⲈϤϬⲞⲤⲒ ⲈϤⲪⲞⲢϢ ⲈϤⲤⲈⲂⲦⲰⲦ ⲞⲨⲞϨ ⲤⲈⲂⲦⲰⲦϤ ⲚⲀⲚ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲀⲨⲒ ⲈϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲀⲨϪⲒⲘⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲤⲈⲂⲦⲈ ⲠⲒⲠⲀⲤⲬⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ⲞⲨⲞϨ ⲈⲦⲀ ⲢⲞⲨϨⲒ ϢⲰⲠⲒ ⲀϤⲒ ⲚⲈⲘ ⲠⲒⲒⲂ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ⲈⲨⲢⲞⲦⲈⲂ ⲆⲈ ⲞⲨⲞϨ ⲈⲨⲞⲨⲰⲘ ⲠⲈϪⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲠⲈⲐⲚⲀⲦⲎ ⲒⲦ ϦⲀ ⲚⲎ ⲈⲐⲞⲨⲰⲘ ⲚⲈⲘⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ⲞⲨⲞϨ ⲈϪⲞⲤ ⲚⲀϤ ⲚⲞⲨⲀⲒ ⲞⲨⲀⲒ ϪⲈ ⲘⲎⲦⲒ ⲀⲚⲞⲔ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲀⲒ ⲚⲦⲈⲠⲒⲒⲂ ⲪⲎ ⲈⲦⲀϤⲤⲈⲠ ⲦⲈϤϪⲒϪ ⲚⲈⲘⲎⲒ ϦⲈⲚϮϪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ϪⲈ ⲠⲰⲎⲢⲒ ⲘⲈⲚ ⲘⲪⲢⲰⲘⲒ ϤⲚⲀϢⲈ ⲚⲀϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦϤ ⲞⲨⲀⲒ ⲆⲈ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲎ ⲈⲦⲞⲨⲚⲀϮ ⲘⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲀⲚⲈⲤ ⲚⲀϤ ⲠⲈ ⲘⲠⲞⲨⲘⲀⲤϤ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ⲞⲨⲞϨ ⲈⲨⲞⲨⲰⲘ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲰⲒⲔ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲦⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲀϤⲪⲀϢϤ ⲞⲨⲞϨ ⲀϤϮ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϬⲒ ⲪⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲀⲪⲞⲦ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤϮ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲤⲰ ⲚϦⲎⲦϤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀⲤⲚⲞϤ ⲚⲦⲈϮⲆⲒⲀⲐⲎⲔⲎ ⲈⲦⲞⲨⲚⲀⲪⲞⲚϤ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲞⲨⲘⲎϢ ⲈⲠϪⲒⲚⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲞⲨⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲀⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲦⲀⲒⲂⲰ ⲚⲀⲖⲞⲖⲒ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲦⲎ ϨⲞⲦⲀⲚ ⲀⲒϢⲀⲚⲤⲞϤ ⲘⲂⲈⲢⲒ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲘⲞⲨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲦⲎⲢⲞⲨ ϪⲈ ⲞⲨⲎⲒ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ϮⲚⲀϢⲀⲢⲒ ⲘⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲞⲨⲞϨ ⲚⲤⲈϪⲰⲢ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ⲀⲖⲖⲀ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲒⲦⲰⲚⲦ ϮⲚⲀⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲈⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲀⲚ ⲀⲨϢⲀⲚⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲦⲎⲢⲞⲨ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲐⲞⲔ ⲘⲪⲞⲞⲨ ϦⲈⲚⲠⲀⲒⲈϪⲰⲢϨ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲚⲤⲞⲠ ⲬⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲚⲤⲞⲠ ");
INSERT INTO copbhc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲤⲀϪⲒ ϦⲈⲚⲞⲨⲘⲈⲦϨⲞⲨⲞ ϪⲈ ⲔⲀⲚ ⲀⲤϢⲀⲚⲪⲞϨ ⲚⲦⲀⲘⲞⲨ ⲚⲈⲘⲀⲔ ⲚⲚⲀϪⲞⲖⲔ ⲈⲂⲞⲖ ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲞⲚ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲨⲒⲞϨⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲄⲈⲐⲤⲎⲘⲀⲚⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲈⲘⲤⲒ ϨⲀⲘⲚⲀⲒ ϨⲰⲤ ϮⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ⲞⲨⲞϨ ⲀϤⲰⲖⲒ ⲚⲈⲘⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚϢⲐⲞⲢⲦⲈⲢ ⲞⲨⲞϨ ⲚⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲘⲞⲔϨ ϢⲀ ⲈϦⲢⲎⲒ ⲈⲪⲘⲞⲨ ⲞϨⲒ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲞϨ ⲢⲰⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲦϨⲎ ⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲀϤϨⲒ ⲘⲘⲞϤ ⲚϦⲢⲎⲒ ⲈϪⲈⲚ ⲠⲔⲀϨⲒ ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ϨⲒⲚⲀ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϮⲞⲨⲚⲞⲨ ⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲂⲂⲀ ⲪⲒⲰⲦ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ϦⲀⲦⲞⲦⲔ ⲘⲀⲢⲈ ⲠⲒⲀⲪⲞⲦ ⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲀⲖⲖⲀ ⲘⲪⲢⲎϮ ⲈⲦⲈϨⲚⲎⲒ ⲀⲚⲞⲔ ⲀⲚ ⲀⲖⲖⲀ ⲘⲪⲢⲎϮ ⲈⲦⲈϨⲚⲀⲔ ⲚⲐⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ⲞⲨⲞϨ ⲀϤⲒ ⲀϤϪⲈⲘⲞⲨ ⲈⲨⲚⲔⲞⲦ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲤⲒⲘⲰⲚ ⲔⲚⲔⲞⲦ ⲘⲠⲈⲔϢϪⲈⲘϪⲞⲘ ⲚⲢⲰⲒⲤ ⲚⲈⲘⲎⲒ ⲚⲞⲨⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ⲢⲰⲒⲤ ⲞⲨⲚ ⲞⲨⲞϨ ⲀⲢⲒⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ ⲠⲒⲠⲚⲈⲨⲘⲀⲘⲈⲚ ϤⲢⲰⲞⲨⲦ ϮⲤⲀⲢⲜ ⲆⲈ ⲞⲨⲀⲤⲐⲈⲚⲎⲤ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲚⲀϤⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲀϤϪⲈ ⲠⲀⲒⲤⲀϪⲒ ⲢⲰ ");
INSERT INTO copbhc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ⲞⲨⲞϨ ⲀϤⲒ ⲞⲚ ⲀϤϪⲈⲘⲞⲨ ⲈⲨⲚⲔⲞⲦ ⲚⲀⲢⲈ ⲚⲞⲨⲂⲀⲖ ⲄⲀⲢ ϨⲞⲢϢ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲈⲘⲒ ⲀⲚ ⲠⲈ ϪⲈ ⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲈⲢⲞⲨⲰ ⲘⲘⲞϤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ⲞⲨⲞϨ ⲀϤⲒ ⲘⲠⲒⲘⲀϨⲄ ⲚⲤⲞⲠ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲔⲞⲦ ϪⲈ ⲀⲤⲒ ⲚϪⲈϮⲞⲨⲚⲞⲨ ϨⲎⲠⲠⲈ ⲤⲈⲚⲀϮ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲦⲈⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲀⲢⲞⲚ ϨⲎⲠⲠⲈ ⲀϤϦⲰⲚⲦ ⲚϪⲈⲪⲎ ⲈⲐⲚⲀⲦⲎⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ⲀϤⲒ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲈⲘⲀϤ ⲚⲈⲘ ϨⲀⲚⲤⲎϤⲒ ⲚⲈⲘ ϨⲀⲚϢⲈ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ϪⲈ ⲀϤϮ ⲚⲞⲨⲘⲎⲒⲚⲒ ⲚⲰⲞⲨ ⲚϪⲈⲪⲎ ⲈⲐⲚⲀⲦⲎⲒϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈϮⲚⲀϮ ⲚⲞⲨⲪⲒ ⲈⲢⲰϤ ⲚⲐⲞϤ ⲠⲈ ⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ϬⲒⲦϤ ⲀⲤⲪⲀⲖⲰⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲞⲨⲞϨ ⲀϤϮⲪⲒ ⲈⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲈⲚ ⲚⲞⲨϪⲒϪ ⲈϪⲰϤ ⲞⲨⲞϨ ⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ⲞⲨⲀⲒ ⲆⲈ ⲚⲦⲈⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲀϤⲐⲈⲔⲈⲘ ϮⲤⲎϤⲒ ⲈⲀϤϮ ⲚⲞⲨϢⲀϢ ⲘⲪⲂⲰⲔ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲀϤⲰⲖⲒ ⲘⲠⲈϤⲘⲀϢϪ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲈⲢⲈⲦⲈⲚⲚⲎ ⲞⲨ ⲚⲤⲀⲞⲨⲤⲞⲚⲒ ⲚⲈⲘ ϨⲀⲚⲤⲎϤⲒ ⲚⲈⲘ ϨⲀⲚϢⲈ ⲈⲦⲀϨⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ⲚⲀⲒⲬⲎ ϨⲀⲢⲰⲦⲈⲚ ⲘⲘⲎⲚⲒ ⲈⲒϮⲤⲂⲰ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲀⲘⲞⲚⲒ ⲘⲘⲞⲒ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲄⲢⲀⲪⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ⲞⲨⲞϨ ⲈⲦⲀⲨⲬⲀϤ ⲀⲨⲪⲰⲦ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲞⲨⲞⲚ ⲞⲨϦⲈⲖϢⲒⲢⲒ ⲘⲞϢⲒ ⲚⲤⲰϤ ⲈϤϪⲎⲖ ⲚⲞⲨⲤⲨⲚⲆⲞⲚⲒⲞⲚ ⲈϪⲈⲚ ⲠⲈϤⲂⲰϢ ⲞⲨⲞϨ ⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲤⲰϪⲠ ⲚϮⲤⲨⲚⲆⲞⲚⲒⲞⲚ ⲀϤⲪⲰⲦ ⲈϤⲂⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ⲞⲨⲞϨ ⲀⲨϬⲒ ⲚⲒⲎⲤⲞⲨⲤ ϨⲀ ⲚⲒⲀⲢⲬⲈⲒⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ⲞⲨⲞϨ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ϨⲒⲪⲞⲨⲈⲒ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲀⲨⲖⲎ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲚⲀϤⲈⲢϢⲪⲎⲢ ⲚϨⲈⲘⲤⲒ ⲚⲈⲘ ⲚⲒϨⲨⲠⲎ ⲢⲈⲦⲎⲤ ⲞⲨⲞϨ ⲈϤⲦϦⲘⲞⲘ ⲘⲘⲞϤ ϦⲀⲦⲈⲚ ⲠⲒⲞⲨⲰⲒⲚⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲚⲈⲘ ⲠⲒⲘⲀⲚϮϨⲀⲚ ⲦⲎⲢϤ ⲚⲀⲨⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲈⲦⲘⲈⲐⲢⲈ ϦⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲠϪⲒⲚϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲚⲀⲨϪⲒⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ⲚⲀⲢⲈ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ϦⲀⲢⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲞⲒ ⲚϨⲨⲤⲞⲤ ⲀⲚ ⲠⲈ ⲚϪⲈⲚⲞⲨⲘⲈⲦⲘⲈⲐⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲀⲨⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ϦⲀⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀⲂⲰⲖ ⲘⲠⲀⲒⲈⲢⲪⲈⲒ ⲈⲂⲞⲖ ⲠⲀⲒⲘⲞⲨⲚⲔ ⲚϪⲒϪ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ Ⲅ- ⲚⲈϨⲞⲞⲨ ⲔⲈⲞⲨⲀⲒ ⲚⲀⲐⲘⲞⲨⲚⲔ ⲚϪⲒϪ ϮⲚⲀⲔⲞⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ⲞⲨⲆⲈ ⲠⲀⲒⲢⲎϮ ⲚⲀⲤⲞⲒ ⲚϨⲨⲤⲞⲤ ⲀⲚ ⲚϪⲈⲦⲞⲨⲘⲈⲦⲘⲈⲐⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲐⲘⲎϮ ⲀϤϢⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲔⲈⲢⲞⲨⲰ ⲚϨⲖⲒ ⲀⲚ ϪⲈ ⲚⲀⲒ ⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲬⲰ ⲚⲢⲰϤ ⲠⲈ ⲞⲨⲞϨ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲚϨⲖⲒ ⲠⲀⲖⲒⲚ ⲀⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϢⲈⲚϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲎ ⲈⲦⲤⲘⲀⲢⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲚϮϪⲞⲘ ⲞⲨⲞϨ ⲈϤⲚⲎⲞⲨ ⲚⲈⲘ ⲚⲒϬⲎⲠⲒ ⲚⲦⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲈⲦⲀϤⲪⲰϦ ⲚⲚⲈϤϨⲂⲰⲤ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲞⲚ ⲈⲦⲈⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ ⲘⲘⲈⲐⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ⲀⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲠⲒϪⲈⲞⲨⲀ ⲞⲨ ⲈⲐⲞⲨⲞⲚϨ ⲚⲰⲦⲈⲚ ⲚⲐⲰⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨⲢⲔⲀⲦⲀⲔⲢⲒⲚⲒⲚ ⲘⲘⲞϤ ϪⲈ ϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲈⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢϨⲎⲦⲤ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈϨⲒⲐⲀϤ ϦⲈⲚϨⲢⲀϤ ⲞⲨⲞϨ ⲈϨⲰⲂⲤ ⲘⲠⲈϤϨⲞ ⲞⲨⲞϨ ⲈϮⲔⲈϨ ⲚⲀϤ ⲞⲨⲞϨ ⲈϪⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲢⲒⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲚⲀⲚ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϨⲒⲞⲨⲒ ⲈⲢⲞⲔ ϮⲚⲞⲨ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨϬⲒⲦϤ ⲚϨⲀⲚⲀⲖⲰϪ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ⲞⲨⲞϨ ⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲚϦⲢⲎⲒ ϦⲈⲚϮⲀⲨⲖⲎ ⲀⲤⲒ ⲚϪⲈⲞⲨⲒ ⲚⲚⲒⲂⲰⲔⲒ ⲚⲦⲈⲠⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ⲞⲨⲞϨ ⲈⲦⲀⲤⲚⲀⲨ ⲈⲠⲈⲦⲢⲞⲤ ⲈϤⲦϦⲘⲞⲘ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲦⲀⲤϪⲞⲨϢⲦ ⲈⲢⲞϤ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ϨⲰⲔ ⲚⲀⲔⲬⲎ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ⲚⲐⲞϤ ⲆⲈ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲆⲈ ⲚϮⲈⲘⲒ ⲀⲚ ⲞⲨⲆⲈ ⲚϮⲤⲰⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨ ⲚⲐⲞ ⲠⲈⲦⲈϪⲰ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲈⲠⲒⲘⲀ ⲈⲦⲤⲀⲂⲞⲖ ⲚⲦⲈϮⲀⲨⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ⲞⲨⲞϨ ⲈⲦⲀⲤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈϮⲬⲈϮ ⲠⲈϪⲀⲤ ⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϪⲈ ⲪⲀⲒ ⲞⲨⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ⲚⲐⲞϤ ⲆⲈ ⲞⲚ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲘⲈⲚⲈⲚⲤⲀ ⲞⲨⲔⲞⲨϪⲒ ⲠⲀⲖⲒⲚ ⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲀⲖⲎⲐⲰⲤ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲔⲈ ⲄⲀⲢ ⲚⲐⲞⲔ ⲞⲨⲄⲀⲖⲒⲖⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲀⲚⲀⲐⲈⲘⲀⲦⲒⲌⲒⲚ ⲚⲈⲘ ⲰⲢⲔ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲘⲠⲀⲒⲢⲰⲘⲒ ⲀⲚ ⲈⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲚϪⲈⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲪⲘⲀϨⲤⲞⲠⲂ ⲞⲨⲞϨ ⲀϤⲈⲢⲪⲘⲈⲨⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲘⲠⲒⲤⲀϪⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲚⲤⲞⲠⲂ ⲬⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲦⲞⲦϤ ⲀϤⲢⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲤⲞϬⲚⲒ ⲚⲞⲨⲤⲞϬⲚⲒ ⲚϢⲰⲢⲠ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲠⲒⲘⲀⲚϮϨⲀⲠ ⲦⲎⲢϤ ⲀⲨⲤⲰⲚϨ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨϬⲒⲦϤ ⲀⲨⲦⲎⲒϤ ⲘⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ⲞⲨⲞϨ ⲀϤϢⲈⲚϤ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲚϨⲀⲚⲘⲎϢ ϦⲀⲢⲞϤ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲞⲚ ⲚⲀϤϢⲈⲚϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲆⲈ ⲚⲔⲈⲢⲞⲨⲰ ⲚϨⲖⲒ ⲀⲚ ⲀⲚⲀⲨ ϪⲈ ⲤⲈⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞⲔ ⲚⲞⲨⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲠⲈϤϪⲈ ⲈⲢⲞⲨⲰ ⲚϨⲖⲒ ϨⲰⲤⲦⲈ ⲚⲦⲈϤⲈⲢϢⲪⲎⲢⲒ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ⲔⲀⲦⲀ ⲠϢⲀⲒ ⲆⲈ ⲚⲀϤⲬⲰ ⲚⲞⲨⲀⲒ ⲈϤⲤⲞⲚϨ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲪⲎ ⲈϢⲀⲨⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ⲪⲎ ⲆⲈ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲀⲂⲂⲀⲤ ⲚⲀϤⲤⲞⲚϨ ⲠⲈ ⲚⲈⲘ ⲚⲎ ⲈⲦⲀⲨⲒⲢⲒ ⲚⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲎ ⲈⲚⲀⲨⲒⲢⲒ ⲚⲞⲨϦⲰⲦⲈⲂ ϦⲈⲚⲠϢⲐⲞⲢⲦⲈⲢ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲠϢⲰⲒ ⲚϪⲈⲠⲒⲘⲎϢ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲈⲦⲒⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲚⲀϤⲒⲢⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲚⲦⲀⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲘⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ⲚⲀϤⲈⲘⲒ ⲄⲀⲢ ⲠⲈ ϪⲈ ⲈⲦⲀⲨⲦⲎⲒϤ ⲈⲐⲂⲈ ⲞⲨⲪⲐⲞⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲨⲔⲒⲘ ⲘⲠⲒⲘⲎϢ ϨⲒⲚⲀ ⲘⲀⲖⲖⲞⲚ ⲚⲦⲈϤⲬⲀ ⲂⲀⲢⲂⲂⲀⲤ ⲚⲰⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲞⲨⲚ ⲠⲈϮⲚⲀⲀⲒϤ ⲘⲪⲎ ⲈⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ⲚⲐⲰⲞⲨ ⲆⲈ ⲞⲚ ⲀⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ⲠⲒⲖⲀⲦⲞⲤ ⲄⲀⲢ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲄⲀⲢ ⲘⲠⲈⲦϨⲰⲞⲨ ⲠⲈⲦⲀϤⲀⲒϤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲚϨⲞⲨⲞ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲈⲢ ⲠⲈⲦⲈϨⲚⲈ ⲠⲒⲘⲎϢ ⲀϤⲬⲀ ⲂⲀⲢⲀⲂⲂⲀⲤ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲀϤϮ ⲆⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲈⲢⲪⲢⲄⲈⲖⲖⲒⲚ ⲘⲘⲞϤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ⲚⲒⲘⲀⲦⲞⲒ ⲆⲈ ⲀⲨϬⲒⲦϤ ⲈϦⲞⲨⲚ ⲈϮⲀⲨⲖⲎ ⲚⲦⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨϮ ⲈϮⲤⲠⲒⲢⲀ ⲦⲎⲢⲤ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ⲞⲨⲞϨ ⲀⲨϮ ϨⲒⲰⲦϤ ⲚⲞⲨϨⲂⲞⲤ ⲚϬⲎϪⲒ ⲞⲨⲞϨ ⲀⲨϢⲰⲚⲦ ⲚⲞⲨⲬⲖⲞⲘ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲤⲞⲨⲢⲒ ⲀⲨⲬⲀϤ ϨⲒϪⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲘⲘⲞϤ ϪⲈ ⲬⲈⲢⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ⲞⲨⲞϨ ⲀⲨϨⲒⲞⲨⲒ ϦⲈⲚⲦⲈϤⲀⲪⲈ ⲚⲞⲨⲔⲀϢ ⲞⲨⲞϨ ⲚⲀⲨϨⲒⲐⲀϤ ϦⲈⲚⲠⲈϤϨⲞ ⲞⲨⲞϨ ⲈⲨϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈϪⲈⲚ ⲚⲞⲨⲔⲈⲖⲒ ⲈⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ⲞⲨⲞϨ ϨⲞⲦⲈ ⲈⲦⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲀⲨⲂⲀϢϤ ⲘⲠⲒϨⲂⲞⲤ ⲚϬⲎϪⲒ ⲞⲨⲞϨ ⲀⲨϮ ⲚⲚⲈϤϨⲂⲰⲤ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲤⲈⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ⲞⲨⲞϨ ⲀⲨϬⲒ ⲚⲞⲨⲀⲒ ⲚⲬⲂⲀ ⲈϤⲤⲒⲚⲒⲰⲞⲨ ⲤⲒⲘⲰⲚ ⲠⲒⲔⲨⲢⲒⲚⲚⲈⲞⲤ ⲈϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲔⲞⲒ ⲪⲒⲰⲦ ⲚⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲚⲈⲘ ⲢⲞⲨⲪⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤⲰⲖⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲈⲠⲒⲘⲀ ⲚⲦⲈⲄⲞⲖⲄⲞⲐⲀ ⲪⲀⲒ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲒⲘⲀ ⲚⲦⲈⲠⲒⲔⲢⲀⲚⲒⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ⲞⲨⲞϨ ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨⲎⲢⲠ ⲈϤⲘⲞϪⲦ ⲚⲈⲘ ⲞⲨϢⲀϢⲒ ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲈϤϬⲒⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ⲞⲨⲞϨ ⲀⲨⲀϢϤ ⲞⲨⲞϨ ⲀⲨⲪⲰϢ ⲚⲚⲈϤϨⲂⲰⲤ ⲈϨⲢⲀⲨ ⲈⲀⲨϨⲒⲰⲠ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲒⲘ ⲈⲐⲚⲀⲞⲖⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ⲚⲈ ⲪⲚⲀⲨ ⲆⲈ ⲚⲀϪⲠⲄ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲀϢϤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ⲞⲨⲞϨ ϮⲈⲠⲒⲄⲢⲀⲪⲎ ⲚⲦⲈⲦⲈϤⲈⲦⲒⲀ ⲚⲀⲤⲤϦⲎⲞⲨⲦ ⲠⲈ ϪⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ⲞⲨⲞϨ ⲀⲨⲈϢ ⲔⲈⲤⲞⲚⲒ ⲂⲚⲈⲘⲀϤ ⲞⲨⲀⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲞⲨⲀⲒ ⲤⲀϪⲀϬⲎ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ⲞⲨⲞϨ ϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲀⲨⲞⲠϤ ⲚⲈⲘ ⲚⲒⲀⲚⲞⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲤⲒⲚⲒ ⲚⲀⲨϪⲈⲞⲨⲀ ⲈⲢⲞϤ ⲈⲨⲔⲒⲘ ⲚⲚⲞⲨⲀⲪⲎⲞⲨⲒ ⲞⲨⲞϨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲂⲈⲖ ⲠⲒⲈⲢⲪⲈⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲐⲚⲀⲔⲞⲦϤ ⲚⲄ ⲚⲈϨⲞⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ⲚⲀϨⲘⲈⲔ ⲈⲀⲔⲒ ⲈϦⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ⲠⲀⲒⲢⲎϮ ⲚⲒⲔⲈⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲨⲤⲰⲂⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲚⲞϨⲈⲘ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲚⲀϨⲘⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲞⲨⲢⲞ ⲘⲠⲒⲤⲖ ⲘⲀⲢⲈϤⲒ ⲈϦⲢⲎⲒ ϮⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲚⲚⲀⲨ ⲞⲨⲞϨ ⲚⲦⲈⲚⲚⲀϨϮ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀⲨⲀϢⲞⲨ ⲚⲈⲘⲀϤ ⲚⲀⲨϮϢⲰϢ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ⲞⲨⲞϨ ⲈⲦⲀ ⲪⲚⲀⲨ ⲚⲀϪⲠ ϢⲰⲠⲒ Ⲁ- ⲞⲨⲬⲀⲔⲒ ϢⲰⲠⲒ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲦⲎⲢϤ ϢⲀ ⲪⲚⲀⲨ ⲚⲀϪⲠⲐ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ⲞⲨⲞϨ ϦⲈⲚⲪⲚⲀⲨ ⲚⲀϪⲠⲐ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲈⲖⲰⲒ ⲈⲖⲰⲒ ⲖⲈⲘⲀ ⲤⲀⲂⲀⲬⲐⲀⲚⲒ ⲈⲦⲈ ⲘⲠⲈϤⲞⲨⲰϨⲈⲘ ⲠⲈ ϪⲈ ⲠⲀⲚⲞⲨϮ ⲠⲀⲚⲞⲨϮ ⲈⲐⲂⲈⲞⲨ ⲀⲔⲬⲀⲦ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ⲞⲨⲞϨ ϨⲀⲚⲞⲨⲞⲚ ⲚⲦⲈⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲀⲨ ϤⲘⲞⲨϮ ⲈⲎⲖⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ⲈⲦⲀϤϬⲞϪⲒ ⲚϪⲈⲞⲨⲀⲒ ⲀϤⲘⲀϨ ⲞⲨⲤⲪⲞⲄⲄⲞⲤ ⲚϨⲈⲘϪ ⲀϤⲦⲀⲖⲞϤ ⲈϪⲈⲚ ⲞⲨⲔⲀϢ ⲀϤⲦⲤⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀϤ ⲚⲦⲈⲚⲚⲀⲨ ϪⲈ ⲎⲖⲒⲀⲤ ⲚⲎⲞⲨ ⲚⲦⲈϤⲈⲚϤ ⲈϦⲢⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲘⲞⲨϮ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲀϤϮ ⲘⲠⲒⲠⲚⲀ ");
INSERT INTO copbhc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ⲞⲨⲞϨ ⲠⲒⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲪⲰϦ ϦⲈⲚⲂⲒⲤϪⲈⲚ ⲠϢⲰⲒ ⲈϦⲢⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲪⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲠⲈϤⲘⲐⲞ ϪⲈ ⲀϤϮ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲠⲈϪⲀϤ ϪⲈ ⲀⲖⲎⲐⲰⲤ ⲠⲀⲒⲢⲰⲘⲒ ⲚⲈⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲔⲈϨⲒⲞⲘⲒ ⲆⲈ ⲠⲈ ⲈⲨⲚⲀⲨ ϨⲒⲪⲞⲨⲈⲒ ⲚⲈⲈⲚⲀⲢⲈ ⲘⲀⲢⲒⲀ ⲚϦⲎⲦⲞⲨ ⲠⲈ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲚⲦⲈⲒⲀⲔⲰⲂⲞⲤ ⲠⲒⲔⲞⲨϪⲒ ⲚⲈⲘ ⲐⲘⲀⲨ ⲚⲒⲰⲤⲎⲦⲞⲤ ⲚⲈⲘ ⲤⲀⲖⲰⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ⲚⲀⲒ ⲈⲚⲀⲨⲞⲨⲈϨ ⲚⲤⲰϤ ϨⲞⲦⲈ ⲈϤⲬⲎ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲚⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ ⲚⲈⲘ ⲔⲈⲘⲎϢ ⲈⲀⲨⲒ ⲚⲈⲘⲀϤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ⲞⲨⲞϨ ϨⲎⲆⲎ ⲈⲦⲀ ⲢⲞⲨϨⲒ ϢⲰⲠⲒ ⲈⲠⲒⲆⲎ ⲚⲈϮⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ⲈⲦϦⲀϪⲰϤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ⲈⲦⲀϤⲒ ⲚϪⲈⲒⲰⲤⲎⲪ ⲠⲒⲈⲂⲞⲖ ϦⲈⲚⲀⲢⲒⲘⲀⲐⲈⲀⲤ ⲈⲞⲨⲈⲨⲤⲬⲎⲘⲰⲚ ⲠⲈ ⲘⲂⲞⲨⲖⲈⲨⲦⲎ ⲤⲪⲀⲒ ⲈⲦⲈ ⲚⲐⲞϤ ϨⲰϤ ⲚⲀϤϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤⲈⲢⲦⲞⲖⲘⲀⲚ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ϨⲀ ⲠⲒⲖⲀⲦⲞⲤ ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲦⲒⲚ ⲘⲠⲤⲰⲘⲀ ⲚⲒⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲀϤⲈⲢϢⲪⲎⲢⲒ ϪⲈ ϨⲎⲆⲎ ⲀϤⲘⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬ ⲞⲤ ⲀϤϢⲈⲚϤ ϪⲈ ⲀⲚ ⲀϤⲞⲨⲰ ⲀϤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ⲚⲦⲞⲦϤ ⲘⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬ ⲞⲤ ⲀϤϮ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲚⲒⲰⲤⲎⲪ ");
INSERT INTO copbhc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈⲠ ⲞⲨϢⲈⲚⲦⲰ ⲀϤⲈⲚϤ ⲈϦⲢⲎⲒ ⲀϤⲔⲞⲨⲖⲰⲖϤ ϦⲈⲚⲞⲨϢⲈⲚⲦⲰ ⲞⲨⲞϨ ⲀϤⲬⲀϤ ϦⲈⲚⲞⲨⲘϨⲀⲨ ⲪⲎ ⲈⲦϢⲎⲔ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲈⲦⲢⲀ ⲞⲨⲞϨ ⲀϤⲤⲔⲈⲢⲔⲈⲢ ⲘⲠⲒⲰⲚⲒ ⲈⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ⲘⲀⲢⲒⲀ ⲆⲈ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲚⲦⲈⲒⲰⲤⲎⲦⲞⲤ ⲚⲀⲨⲚⲀⲨ ⲠⲈ ϪⲈ ⲈⲦⲀⲨⲬⲀϤ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲰⲠⲒ ⲚϪⲈⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲚⲦⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲤⲀⲖⲰⲘⲎ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲀⲨϢⲰⲠ ⲚϨⲀⲚⲤⲐⲞⲒⲚⲞⲨϤⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲒ ⲚⲦⲞⲨⲐⲀϨⲤϤ ");
INSERT INTO copbhc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ⲞⲨⲞϨ ⲚϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲈⲘⲀϢⲰ ⲘⲪⲞⲨⲀⲒ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲨⲒ ⲈⲠⲒⲘϨⲀⲨ ⲈⲦⲀ ⲪⲢⲎ ϢⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲚⲒⲘ ⲈⲐⲚⲀⲤⲔⲈⲢⲔⲈⲢ ⲘⲠⲒⲰⲚⲒ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲒⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ⲞⲨⲞϨ ⲈⲦⲀⲨϤⲀⲒ ⲚⲚⲞⲨⲂⲀⲖ ⲈⲠϢⲰⲒ ⲀⲨⲚⲀⲨ ⲈⲠⲒⲰⲚⲒ ϪⲈ ⲀⲨⲤⲔⲈⲢⲔⲰⲢϤ ⲚⲈⲞⲨⲚⲒϢϮ ⲄⲀⲢ ⲈⲘⲀϢⲰ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘϨⲀⲨ ⲀⲨⲚⲀⲨ ⲈⲞⲨϦⲈⲖϢⲒⲢⲒ ⲈϤϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲈϤϪⲎⲖ ⲚⲞⲨⲤⲦⲞⲖⲎ ⲈⲤⲞⲨⲞⲂϢ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰϤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲪⲎ ⲈⲦⲀⲨⲀϢϤ ⲀϤⲦⲰⲚϤ ϤϨⲀⲘⲚⲀⲒ ⲀⲚ ⲒⲤ ⲠⲒⲘⲀ ⲈⲦⲀⲨⲬⲀϤ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ⲀⲖⲖⲀ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲀϪⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲚⲈⲘ ⲠⲈⲦⲢⲞⲤ ϪⲈ ϤⲚⲀⲈⲢϢⲞⲢⲠ ⲈⲢⲰⲦⲈⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀⲢⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨⲪⲰⲦ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘϨⲀⲨ ⲚⲈⲀⲞⲨⲤⲐⲈⲢⲦⲈⲢ ⲄⲀⲢ ⲦⲀϨⲰⲞⲨ ⲠⲈ ⲚⲈⲘ ⲞⲨⲦⲰⲘⲦ ⲞⲨⲞϨ ⲘⲠⲞⲨϪⲈ ϨⲖⲒ ⲚϨⲖⲒ ⲚⲀⲨⲈⲢϨⲞϮ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϢⲞⲢⲠ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚϨⲞⲨⲒⲦ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀϤⲞⲨⲞⲚϨϤ ⲚϢⲞⲢⲠ ⲘⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲐⲎ ⲈⲦⲀϤϨⲒ ⲠⲒⲌ ⲚⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϨⲒⲰⲦⲤ ");
INSERT INTO copbhc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ⲐⲀⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲤϢⲈ ⲚⲀⲤ ⲀⲤϪⲞⲤ ⲚⲚⲎ ⲈⲚⲀⲨϢⲰⲠⲒ ⲚⲈⲘⲀϤ ⲈⲨⲈⲢϨⲎⲂⲒ ⲞⲨⲞϨ ⲈⲨⲢⲒⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ϤⲞⲚϦ ⲞⲨⲞϨ ϪⲈ ⲀⲚⲚⲀⲨ ⲈⲢⲞϤ ⲚⲀⲨⲞⲒ ⲚⲀⲐⲚⲀϨϮ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲞⲚ ⲚⲀⲢⲈ Ⲃ- ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲨⲘⲞϢⲒ ϨⲒ ⲞⲨⲘⲰⲒⲦ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲰⲞⲨ ϦⲈⲚⲔⲈⲘⲞⲢⲪⲎ ϦⲈⲚⲦⲔⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ⲞⲨⲞϨ ⲚⲀⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲀⲨϪⲞⲤ ⲚⲚⲒⲤⲰϪⲠ ⲞⲨⲞϨ ⲚⲀⲒ ⲞⲚ ⲘⲠⲞⲨⲚⲀϨϮ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ⲈⲠϦⲀⲈ ⲆⲈ ⲈⲨⲢⲞⲦⲈⲂ ⲚϪⲈⲠⲒⲒⲀ ⲘⲘⲀⲐⲎ ⲦⲎⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀϤϮϢⲰϢ ⲚⲦⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ ⲚⲈⲘ ⲦⲞⲨⲘⲈⲐⲚⲀϢⲦϨⲎ ⲦϪⲈ ⲘⲠⲞⲨⲚⲀϨϮ ⲈⲚⲎ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈⲦⲀϤⲦⲰⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲘⲠⲒⲤⲰⲚⲦ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ⲪⲎ ⲈⲦⲀϤⲚⲀϨϮ ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒⲰⲘⲤ ⲈϤⲈⲚⲞϨⲈⲘ ⲪⲎ ⲆⲈ ⲈⲦⲀϤⲈⲢⲀⲐⲚⲀϨϮ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ⲚⲀⲒⲘⲎⲒⲚⲒ ⲆⲈ ⲈⲨⲈⲘⲞϢⲒ ⲚⲤⲀⲚⲎ ⲈⲐⲚⲀϨϮ ϦⲈⲚⲠⲀⲢⲀⲚ ⲈⲨⲈϨⲒ ϨⲀⲚⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲈⲨⲈⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲀⲤⲠⲒ ⲚⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ⲞⲨⲞϨ ϨⲀⲚϨⲞϤ ⲈⲨⲈϤⲒⲦⲞⲨ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲞⲨϪⲒϪ ⲔⲀⲚ ⲀⲨϢⲀⲚⲞⲨⲰⲘ ⲚⲞⲨⲈⲚⲬⲀⲒ ⲈⲪⲘⲞⲨ ⲚⲚⲈϤⲈⲢⲂⲖⲀⲠⲦⲒⲚ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈⲬⲰ ⲚⲚⲞⲨϪⲒϪ ⲈϪⲈⲚ ϨⲀⲚⲞⲨⲞⲚ ⲈⲨϢⲰⲚⲒ ⲞⲨⲞϨ ⲈⲨⲈⲞⲨϪⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ⲠϬⲞⲒⲤ ⲞⲨⲚ ⲒⲎⲤⲞⲨⲤ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲈϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲀⲨⲞⲖϤ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲞⲨⲞϨ ⲀϤϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ⲚⲎ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨϨⲒⲰⲒϢ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠϬⲞⲒⲤ ⲈⲢϨⲰⲂ ⲚⲈⲘⲰⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲈϤⲦⲀϪⲢⲞ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲚⲒⲘⲎⲒⲚⲒ ⲈⲐⲘⲞϢⲒ ⲚⲤⲰⲞⲨ ϢⲀ ⲈⲚⲈϨ ⲚⲦⲈⲚⲒⲈⲚⲈϨ ⲦⲎⲢⲞⲨ ⲀⲘⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ⲈⲠⲒⲆⲎ ⲞⲨⲘⲎϢ ⲀⲨϨⲒⲦⲞⲦⲞⲨ ⲈⲤϦⲈ ϨⲀⲚⲤⲀϪⲒ ⲈⲐⲂⲈ ⲚⲒϨⲂⲎⲞⲨⲒ ⲈⲦⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨϮ ⲈⲦⲞⲦⲈⲚ ⲘⲘⲞϤ ⲚϪⲈⲚⲒϢⲞⲢⲠ ⲈⲦⲀⲨⲚⲀⲨ ⲞⲨⲞϨ ⲀⲨϢⲰⲠⲒ ⲈⲨⲞⲒ ⲚⲢⲈϤϢⲈⲘϢⲒ ⲘⲠⲒⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ⲀⲤⲢⲀⲚⲎⲒ ϨⲰ ⲈⲀⲒⲘⲞϢⲒ ⲚⲤⲀϨⲰⲂ ⲚⲒⲂⲈⲚ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲈⲤϦⲀⲒ ⲚⲀⲔ ⲈⲪⲢⲎϮ ⲔⲢⲀⲦⲒⲤⲦⲈ ⲐⲈⲞⲪⲒⲖⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ϨⲒⲚⲀ ⲚⲦⲈⲔⲤⲞⲨⲈⲚ ⲠⲒⲦⲀϪⲢⲞ ⲚⲦⲈⲚⲒⲤⲀϪⲒ ⲚⲎ ⲈⲦⲀⲨⲈⲢⲔⲀⲐⲎⲬⲒⲚ ⲘⲘⲞⲔ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ ⲠⲞⲨⲢⲞ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲞⲨⲎⲂ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲌⲀⲬⲀⲢⲒⲀⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚϢⲈⲘϢⲒ ⲚⲦⲈⲀⲂⲒⲀ ⲞⲨⲞϨ ⲦⲈϤⲤϨⲒⲘⲒ ⲚⲈⲞⲨⲈⲂⲞⲖ ⲦⲈ ϦⲈⲚⲚⲒϢⲈⲢⲒ ⲚⲦⲈⲀⲀⲢⲰⲚ ⲞⲨⲞϨ ⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲈⲖⲒⲤⲀⲂⲈⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ⲚⲈ ϨⲀⲚⲐⲘⲎⲒ ⲆⲈ ⲘⲠⲂ ⲚⲈⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲈⲨⲘⲞϢⲒ ϦⲈⲚⲚⲒⲈⲚⲦⲞⲖⲎ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲈⲨⲞⲒ ⲚⲀⲦⲀⲢⲒⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ⲞⲨⲞϨ ⲚⲈⲘⲘⲞⲚⲦⲞⲨ ϢⲎⲢⲒ ⲘⲘⲀⲨ ⲠⲈ ϪⲈ ⲞⲨⲎⲒ ⲚⲈⲞⲨⲀⲦϬⲢⲎⲚ ⲦⲈ ⲈⲖⲒⲤⲀⲂⲈⲦ ⲞⲨⲞϨ ⲚⲈⲀⲨⲀⲒⲀⲒ ⲘⲠⲂ ⲠⲈ ϦⲈⲚⲚⲞⲨⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈϤⲒⲢⲒ ⲚⲦⲈϤⲘⲈⲦⲞⲨⲎⲂ ϦⲈⲚϮⲦⲀⲜⲒⲤ ⲚⲦⲈⲚⲈϤⲈϨⲞⲞⲨ ⲚϢⲈⲘϢⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ⲔⲀⲦⲀ ϮⲔⲀϨⲤ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲎⲂ ⲀⲠⲒⲰⲠ ⲒⲈⲢⲞϤ ⲈⲈⲚ ⲤⲐⲞⲒⲚⲞⲨϤⲒ ⲈϨⲢⲎⲒ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲦⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲀⲨⲦⲰⲂϨ ⲤⲀⲂⲞⲖ ⲘⲪⲚⲀⲨ ⲘⲠⲒⲤⲐⲞⲒⲚⲞⲨϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ⲀϤⲞⲨⲰⲚϨ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲚⲦⲈⲠⲒⲤⲐⲞⲒⲚⲞⲨϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲌⲀⲬⲀⲢⲒⲀⲤ ⲀϤϢⲐⲞⲢⲦⲈⲢ ⲞⲨⲞϨ ⲞⲨϨⲞϮ ⲀⲤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲌⲀⲬⲀⲢⲒⲀⲤ ϪⲈ ⲞⲨⲎⲒ ⲀⲨⲤⲰⲦⲈⲘ ⲈⲠⲈⲔⲦⲰⲂϨ ⲞⲨⲞϨ ⲦⲈⲔⲤϨⲒⲘⲒ ⲈⲖⲒⲤⲀⲂⲈⲦ ⲈⲤⲈⲘⲒⲤⲒ ⲚⲀⲔ ⲚⲞⲨϢⲎⲢⲒ ⲞⲨⲞϨ ⲈⲔⲈⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲢⲀϢⲒ ϢⲰⲠⲒ ⲚⲀⲔ ⲚⲈⲘ ⲞⲨⲐⲈⲖⲎⲖ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲘⲎϢ ⲢⲀϢⲒ ⲈϪⲈⲚ ⲠⲈϤϪⲒⲚⲘⲒⲤⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ϤⲚⲀϢⲰⲠⲒ ⲄⲀⲢ ⲈϤⲞⲒ ⲚⲚⲒϢϮ ⲘⲠⲈⲘⲐⲞ ⲘⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲞⲨⲎⲢⲠ ⲚⲈⲘ ⲞⲨⲤⲒⲔⲈⲢⲀ ⲚⲚⲈϤⲤⲰⲞⲨ ⲞⲨⲞϨ ϤⲚⲀⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲒⲤϪⲈⲚ ⲈϤϦⲈⲚ ⲐⲚⲈϪⲒ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ⲞⲨⲞϨ ⲈϤⲈⲐⲢⲈ ⲞⲨⲘⲎϢ ⲚⲦⲈⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ⲔⲞⲦⲞⲨ ⲈⲠϬⲞⲒⲤ ⲠⲞⲨⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ⲞⲨⲞϨ ⲚⲐⲞϤ ϤⲚⲀⲈⲢϢⲞⲢⲠ ⲚⲒ ϦⲀϪⲰϤ ⲘⲠⲈϤⲘⲐⲞ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲞⲨϪⲞⲘ ⲚⲦⲈⲎⲖⲒⲀⲤ ⲈⲦⲀⲤⲐⲈ ⲠϨⲎⲦ ⲚϨⲀⲚⲒⲞϮ ⲈⲚⲞⲨϢⲎⲢⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲞⲒ ⲚⲀⲦⲐⲰⲦ ⲚϨⲎⲦ ϦⲈⲚⲪⲘⲈⲨⲒ ⲚⲦⲈⲚⲒⲐⲘⲎⲒ ⲈⲤⲈⲂⲦⲈ ⲞⲨⲖⲀⲞⲤ ⲘⲠϬⲞⲒⲤ ⲈⲀⲨⲐⲘⲀⲒⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲌⲀⲬⲀⲢⲒⲀⲤ ⲘⲠⲒⲀⲄⲄⲈⲖⲞⲤ ϪⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲞⲨ ϮⲚⲀⲈⲘⲒ ⲈⲪⲀⲒ ⲀⲚⲞⲔ ⲄⲀⲢ ⲞⲨϦⲈⲖⲖⲞ ⲞⲨⲞϨ ⲦⲀⲤϨⲒⲘⲒ ⲀⲤⲀⲒⲀⲒ ϦⲈⲚⲚⲈⲤⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲄⲀⲂⲢⲒⲎⲖ ⲪⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀⲨⲦⲀⲞⲨⲞⲒ ⲈⲤⲀϪⲒ ⲚⲈⲘⲀⲔ ⲞⲨⲞϨ ⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲀⲔ ⲚⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲈⲔⲈϢⲰⲠⲒ ⲈⲔⲬⲰ ⲚⲢⲰⲔ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲤⲀϪⲒ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲘⲪⲘⲀ ϪⲈ ⲘⲠⲈⲔⲚⲀϨϮ ⲈⲚⲀⲤⲀϪⲒ ⲚⲀⲒ ⲈⲐⲚⲀϪⲰⲔ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎ ⲢⲒ ⲠⲈ ⲈⲐⲂⲈϪⲈ ⲀϤⲰⲤⲔ ⲚϦⲞⲨⲚ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚⲀϤϢϪⲈⲘϪⲞⲘ ⲚⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲀⲚ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲈⲘⲒ ϪⲈ ⲞⲨⲞⲨⲰⲚϨ ⲠⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϦⲞⲨⲚ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤϬⲰⲢⲈⲘ ⲈⲢⲰⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲞϨⲒ ⲈϤⲞⲒ ⲚⲈⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀⲨⲘⲞϨ ⲈⲂⲞⲖ ⲚϪⲈⲚⲈϤⲈϨⲞⲞⲨ ⲚϢⲈⲘϢⲒ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲤⲈⲢⲂⲞⲔⲒ ⲚϪⲈⲈⲖⲒⲤⲀⲂⲈⲦ ⲦⲈϤⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲚⲀⲤϨⲰⲠ ⲘⲘⲞⲤ ⲠⲈ ⲚⲈⲚⲀⲂⲞⲦ ⲈⲤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ϪⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈⲦⲀ ⲠϬⲞⲒⲤ ⲀⲒϤ ⲚⲎⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲢⲞⲒ ⲚϦⲎⲦⲞⲨ ⲈⲰⲖⲒ ⲘⲠⲀϢⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ϦⲈⲚ ⲠⲒⲀⲂⲞⲦ ⲆⲈ ⲘⲘⲀϨ ⲀⲨⲞⲨⲰⲢⲠ ⲚⲄⲀⲂⲢⲒⲎⲖ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈⲞⲨⲂⲀⲔⲒ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲚⲀⲌⲀⲢⲈⲐ ");
INSERT INTO copbhc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ϨⲀ ⲞⲨⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲀⲨⲰⲠ ⲚⲤⲰⲤ ⲚⲞⲨⲢⲰⲘⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ ⲈⲂⲞⲖ ϦⲈⲚⲠⲎⲒ ⲚⲆⲀⲨⲒⲆ ⲞⲨⲞϨ ⲪⲢⲀⲚ ⲚϮⲠⲀⲢⲐⲈⲚⲞⲤ ⲠⲈ ⲘⲀⲢⲒⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ϢⲀⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲬⲈⲢⲈ ⲐⲎ ⲈⲐⲘⲈϨ ⲚϨⲘⲞⲦ ⲠϬⲞⲒⲤ ⲚⲈⲘⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ⲚⲐⲞⲤ ⲆⲈ ⲀⲤϢⲐⲞⲢⲦⲈⲢ ⲈϪⲈⲚ ⲠⲀⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲀⲤⲘⲞⲔⲘⲈⲔ ⲠⲈ ϪⲈ ⲞⲨ ⲀϢ ⲚⲢⲎϮ ⲠⲈ ⲠⲀⲒⲀⲤⲠⲀⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲀⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲘⲀⲢⲒⲀⲘ ⲀⲢⲈϪⲒⲘⲒ ⲄⲀⲢ ⲚⲞⲨϨⲘⲞⲦ ⲘⲠⲈⲘⲐⲞ ⲘⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲦⲈⲢⲀⲈⲢⲂⲞⲔⲒ ⲞⲨⲞϨ ⲚⲦⲈⲘⲒⲤⲒ ⲚⲞⲨϢⲎⲢⲒ ⲞⲨⲞϨ ⲈⲢⲈⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ⲪⲀⲒ ⲈϤⲈⲈⲢⲞⲨⲚⲒϢϮ ⲞⲨⲞϨ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠϢⲎⲢⲒ ⲘⲠⲈⲦϬⲞⲤⲒ ⲞⲨⲞϨ ⲈϤⲈϮ ⲚⲀϤ ⲚϪⲈⲠϬⲞⲒⲤ ⲪⲚⲞⲨϮ ⲘⲠⲐⲢⲞⲚⲞⲤ ⲚⲆⲀⲨⲒⲆ ⲠⲈϤⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ⲞⲨⲞϨ ϤⲚⲀⲈⲢⲞⲨⲢⲞ ⲈϪⲈⲚ ⲠⲎⲒ ⲚⲒⲀⲔⲰⲂ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲚⲚⲈ ϦⲀⲈ ϢⲰⲠⲒ ⲚⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ⲠⲈϪⲈ ⲘⲀⲢⲒⲀⲘ ⲆⲈ ⲘⲠⲒⲀⲄⲄⲈⲖⲞⲤ ϪⲈ ⲠⲰⲤ ⲪⲀⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞⲒ ⲈⲠⲒⲆⲎ ϮⲤⲰⲞⲨⲚ ⲚϨⲀⲒ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ϤⲚⲀⲒ ⲈϨⲢⲎⲒ ⲈϪⲰ ⲞⲨⲞϨ ⲞⲨϪⲞⲘ ⲚⲦⲈⲠⲈⲦϬⲞⲤⲒ ⲈⲐⲚⲀⲈⲢϦⲎ ⲒⲂⲒ ⲈⲢⲞ ⲈⲐⲂⲈⲪⲀⲒ ⲪⲎ ⲈⲦⲞⲨⲚⲀⲘⲀⲤϤ ϤⲞⲨⲀⲂ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲈⲖⲒⲤⲀⲂⲈⲦ ⲦⲈⲤⲤⲨⲄⲄⲈⲚⲎ ⲤⲀⲤⲈⲢⲂⲞⲔⲒ ϨⲰⲤ ⲚⲞⲨϢⲎⲢⲒ ϦⲈⲚⲦⲈⲤⲘⲈⲦϦⲈⲖⲖⲰ ⲞⲨⲞϨ ⲪⲀⲒ ⲠⲈⲤⲘⲀϨ ⲚⲀⲂⲞⲦ ⲠⲈ ⲐⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ϮⲀⲦϬⲢⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲤⲀϪⲒ ⲞⲒ ⲚⲀⲦϪⲞⲘ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ⲠⲈϪⲈ ⲘⲀⲢⲒⲀⲘ ⲆⲈ ϪⲈ ⲒⲤ ϮⲂⲰⲔⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲈⲤⲈϢⲰⲠⲒ ⲚⲎⲒ ⲔⲀⲦⲀ ⲠⲈⲔⲤⲀϪⲒ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲞⲤ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ⲀⲤⲦⲰⲚⲤ ⲆⲈ ⲚϪⲈⲘⲀⲢⲒⲀⲘ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲤϢⲈ ⲚⲀⲤ ϦⲈⲚⲞⲨⲒⲎⲤⲞⲨⲤ ⲈⲠⲒⲒⲀⲚⲦⲰⲞⲨ ⲈⲞⲨⲂⲀⲔⲒ ⲚⲦⲈⲒⲞⲨⲆⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ⲞⲨⲞϨ ⲀⲤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲞⲨⲞϨ ⲀⲤⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚⲈⲖⲒⲤⲀⲂⲈⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀⲤⲤⲰⲦⲈⲘ ⲚϪⲈⲈⲖⲒⲤⲀⲂⲈⲦ ⲈⲠⲀⲤⲠⲀⲤⲘⲞⲤ ⲘⲘⲀⲢⲒⲀⲘ ⲀϤⲔⲒⲘ ⲚϪⲈⲠⲒⲘⲀⲤ ϦⲈⲚⲦⲈⲤⲚⲈϪⲒ ⲞⲨⲞϨ ⲀⲤⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲚϪⲈⲈⲖⲒⲤⲀⲂⲈⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ⲞⲨⲞϨ ⲀⲤⲰϢ ⲈⲠϢⲰⲒ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲞⲨⲞϨ ⲠⲈϪⲀⲤ ⲦⲈⲤⲘⲀⲢⲰⲞⲨⲦ ⲚⲐⲞ ϦⲈⲚⲚⲒϨⲒⲞⲘⲒ ⲞⲨⲞϨ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲦⲈⲚⲈϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ⲪⲀⲒ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲚⲎⲒ ⲠⲈ ϪⲈ ⲚⲦⲈⲐⲘⲀⲨ ⲘⲠⲀϬⲞⲒⲤ ⲒϨⲀⲢⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ϨⲎⲠⲠⲈ ⲄⲀⲢ ⲒⲤϪⲈⲚ ⲈⲦⲀⲤϢⲰⲠⲒ ⲚϪⲈⲦⲤⲘⲎ ⲚⲦⲈⲠⲈⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲚⲀⲘⲀϢϪ ⲀϤⲔⲒⲘ ⲚϪⲈⲠⲒⲘⲀⲤ ϦⲈⲚⲞⲨⲐⲈⲖⲎⲖ ϦⲈⲚⲦⲀⲚⲈϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ⲞⲨⲞϨ ⲰⲞⲨⲚⲒⲀⲦⲤ ⲚⲐⲎ ⲈⲦⲀⲤⲚⲀϨϮ ϪⲈ ⲠϪⲰⲔ ⲈⲂⲞⲖ ⲚⲀϢⲰⲠⲒ ⲚⲚⲎ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚⲀⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲘⲀⲢⲒⲀⲘ ⲀⲦⲀⲮⲨⲬⲎ ϬⲒⲤⲒ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ⲞⲨⲞϨ ⲀⲠⲀⲠⲚⲈⲨⲘⲀⲐⲈⲖⲎⲖ ⲈϪⲈⲚ ⲪⲚⲞⲨϮ ⲠⲀⲤⲰⲦⲎⲢ ");
INSERT INTO copbhc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ϪⲈ ⲀϤϪⲞⲨϢⲦ ⲈϦⲢⲎⲒ ⲈϪⲈⲚ ⲠⲐⲈⲂⲒⲞ ⲚⲦⲈⲦⲈϤⲂⲰⲔⲒ ϨⲎⲠⲠⲈ ⲄⲀⲢ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲤⲈⲚⲀⲈⲢⲘⲀⲔⲀⲢⲒⲌⲒⲚ ⲘⲘⲞⲒ ⲚϪⲈⲚⲒⲄⲈⲚⲈⲀ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ϪⲈ ⲀϤⲒⲢⲒ ⲚⲎⲒ ⲚϨⲀⲚⲘⲈⲐⲚⲒϢϮ ⲚϪⲈⲪⲎ ⲈⲦϪⲞⲢ ⲞⲨⲞϨ ϤⲞⲨⲀⲂ ⲚϪⲈⲠⲈϤⲢⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ⲞⲨⲞϨ ⲠⲈϤⲚⲀⲒ ϢⲰⲠⲒ ϢⲀ ϨⲀⲚϪⲰⲞⲨ ⲚⲈⲘ ϨⲀⲚϪⲰⲞⲨ ⲚⲚⲎ ⲈⲦⲈⲢϨⲞϮ ϦⲀⲦⲈϤϨⲎ ");
INSERT INTO copbhc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ⲀϤⲒⲢⲒ ⲚⲞⲨⲀⲘⲀϨⲒ ϦⲈⲚⲠⲈϤϪⲪⲞⲒ ⲀϤϪⲰⲢ ⲈⲂⲞⲖ ⲚⲚⲒϬⲀⲤⲒϨⲎⲦ ϦⲈⲚⲪⲘⲈⲨⲒ ⲚⲦⲈⲠⲞⲨϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ⲀϤⲢⲰϦⲦ ⲚϨⲀⲚϪⲰⲢⲒ ⲈⲂⲞⲖ ϨⲒ ϨⲀⲚⲐⲢⲞⲚⲞⲤ ⲞⲨⲞϨ ⲀϤϬⲒⲤⲒ ⲚⲚⲎ ⲈⲦⲐⲈⲂⲒⲎⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ⲚⲎ ⲈⲦϨⲞⲔⲈⲢ ⲀϤⲐⲢⲞⲨⲤⲒ ⲚⲀⲄⲀⲐⲞⲚ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲞⲒ ⲚⲢⲀⲘⲀⲞ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ⲈⲨϢⲞⲨⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ⲀϤϮ ⲦⲞⲦϤ ⲘⲠⲒⲤⲖ ⲠⲈϤⲀⲖⲞⲨ ⲈⲈⲢⲪⲘⲈⲨⲒ ⲘⲠⲈϤⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲈⲚⲒⲞϮ ⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲠⲈϤϪⲢⲞϪ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲚⲈⲘⲀⲤ ⲚϪⲈⲘⲀⲢⲒⲀⲘ ⲚⲄ ⲚⲀⲂⲞⲦ ⲞⲨⲞϨ ⲀⲤⲔⲞⲦⲤ ⲈⲠⲈⲤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ⲀⲠⲒⲤⲎⲞⲨ ⲆⲈ ⲘⲞϨ ⲈⲂⲞⲖ ⲚⲦⲈⲈⲖⲒⲤⲀⲂⲈⲦ ⲈⲐⲢⲈⲤⲘⲒⲤⲒ ⲞⲨⲞϨ ⲀⲤⲘⲒⲤⲒ ⲚⲞⲨϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ⲞⲨⲞϨ ⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲎ ⲈⲦⲈⲘⲠⲔⲰϮ ⲘⲠⲈⲤⲎⲒ ⲚⲈⲘ ⲚⲈⲤⲤⲨⲄⲄⲈⲚⲎⲤ ϪⲈ ⲀⲠϬⲞⲒⲤ ⲈⲢ ⲠⲈϤⲚⲀⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲈⲘⲀⲤ ⲞⲨⲞϨ ⲚⲀⲨⲢⲀϢⲒ ⲚⲈⲘⲀⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲘⲘⲀϨⲎ ⲀⲨⲒ ϪⲈ ⲚⲦⲞⲨⲤⲞⲨⲂⲈ ⲠⲒⲀⲖⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ⲠⲈ ⲈⲪⲢⲀⲚ ⲘⲠⲈϤⲒⲰⲦ ⲌⲀⲬⲀⲢⲒⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ⲞⲨⲞϨ ⲀⲤⲈⲢⲞⲨⲰ ⲚϪⲈⲦⲈϤⲘⲀⲨ ⲠⲈϪⲀⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀⲤ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ϦⲈⲚⲦⲈⲤⲨⲄⲄⲈⲚⲒⲀ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞϤ ⲘⲠⲀⲒⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ⲀⲨϬⲰⲢⲈⲘ ⲆⲈ ⲈⲠⲈϤⲒⲰⲦ ϪⲈ ⲀⲬⲞⲨⲰϢ ⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲈⲦⲒⲚ ⲚⲞⲨⲠⲒⲚⲀⲔⲒⲤ ⲀϤⲤϦⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈ ⲠⲈϤⲢⲀⲚ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ⲀⲢⲰϤ ⲆⲈ ⲞⲨⲰⲚ ⲚϮϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲚⲈⲘ ⲠⲈϤⲖⲀⲤ ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲠⲈ ⲈϤⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨϨⲞϮ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ⲘⲠⲞⲨⲔⲰϮ ⲞⲨⲞϨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ϨⲒ ⲠⲒⲒⲀⲚⲦⲰⲞⲨ ⲚⲦⲈⲒⲞⲨⲆⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ⲞⲨⲞϨ ⲚⲀⲨⲘⲞⲔⲘⲈⲔ ⲦⲎⲢⲞⲨ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲚϪⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ϨⲀⲢⲀ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ⲘⲠⲀⲒⲀⲖⲞⲨ ⲔⲈ ⲄⲀⲢ ⲚⲀⲢⲈ ⲦϪⲒϪ ⲘⲠϬⲞⲒⲤ ⲬⲎ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ⲞⲨⲞϨ ⲌⲀⲬⲀⲢⲒⲀⲤ ⲠⲈϤⲒⲰⲦ ⲀϤⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲞⲨⲞϨ ⲀϤⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠϬⲞⲒⲤ ⲪⲚⲞⲨϮ ⲘⲠⲒⲤⲖ ϪⲈ ⲀϤϪⲈⲘⲠϢⲒⲚⲒ ⲞⲨⲞϨ ⲀϤⲒⲢⲒ ⲚⲞⲨⲤⲰϮ ⲘⲠⲈϤⲖⲀⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ⲞⲨⲞϨ ⲀϤⲦⲞⲨⲚⲞⲤ ⲞⲨⲦⲀⲠ ⲚⲚⲞϨⲈⲘ ⲚⲀⲚ ϦⲈⲚⲠⲎⲒ ⲚⲆⲀⲨⲒⲆ ⲠⲈϤⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲤⲀϪⲒ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲐⲞⲨⲀⲂ ⲒⲤϪⲈⲚ ⲠⲈⲚⲈϨ ");
INSERT INTO copbhc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ⲞⲨⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲚϪⲀϪⲒ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲚϪⲒϪ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲘⲞⲤϮ ⲘⲘⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ⲈⲒⲢⲒ ⲚⲞⲨⲚⲀⲒ ⲚⲈⲘ ⲚⲈⲚⲒⲞϮ ⲞⲨⲞϨ ⲈⲈⲢⲪⲘⲈⲨⲒ ⲚⲦⲈϤⲆⲒⲀⲐⲎⲔⲎ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ⲠⲒⲀⲚⲀϢ ⲈⲦⲀϤⲰⲢⲔ ⲘⲘⲞϤ ⲚⲀⲂⲢⲀⲀⲘ ⲠⲈⲚⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ⲈⲠϪⲒⲚⲦⲎⲒⲤ ⲚⲀⲚ ⲚⲀⲦⲈⲢϨⲞϮ ⲈⲀⲚⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲚϪⲒϪ ⲚⲚⲈⲚϪⲀϪⲒ ⲈϢⲈⲘϢⲒ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ϦⲈⲚ ⲞⲨⲦⲞⲨⲂⲞ ⲚⲈⲘ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲘⲠⲈϤⲘⲐⲞ ⲚⲚⲈⲚⲈϨⲞⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ⲞⲨⲞϨ ⲚⲐⲞⲔ ⲆⲈ ⲠⲒⲀⲖⲞⲨ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞⲔ ϪⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲦⲈⲠⲈⲦϬⲞⲤⲒ ⲬⲚⲀⲈⲢϢⲞⲢⲠ ⲄⲀⲢ ⲘⲘⲞϢⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲠϬⲞⲒⲤ ⲈⲤⲈⲂⲦⲈ ⲚⲈϤⲘⲰⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ⲈϮ ⲚⲞⲨⲈⲘⲒ ⲚⲦⲈⲪⲚⲞϨⲈⲘ ⲘⲠⲈϤⲖⲀⲞⲤ ϦⲈⲚⲞⲨⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈϨⲀⲚⲚⲞⲂⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ⲈⲐⲂⲈ ⲚⲒⲘⲈⲦϢⲈⲚϨⲎⲦ ⲚⲦⲈⲪⲚⲀⲒ ⲘⲠⲈⲚⲚⲞⲨϮ ϦⲈⲚⲚⲀⲒ ⲈⲦⲀϤⲚⲀϢⲒⲚⲒ ⲈⲢⲞⲚ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲀⲚⲀⲦⲞⲖⲎ ⲈⲂⲞⲖ ϦⲈⲚⲠϬⲒⲤⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ⲈⲈⲢⲞⲨⲰⲒⲚⲒ ⲚⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ϦⲈⲚⲠⲬⲀⲔⲒ ⲚⲈⲘ ⲦϦⲎⲒⲂⲒ ⲘⲪⲘⲞⲨ ⲈⲠϪⲒⲚⲤⲞⲨⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲈⲪⲘⲰⲒⲦ ⲚⲦⲈϮϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ⲠⲒⲀⲖⲞⲨ ⲆⲈ ⲀϤⲀⲒⲀⲒ ⲞⲨⲞϨ ⲚⲀϤⲀⲘⲀϨⲒ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲠⲈ ϨⲒ ⲚⲒϢⲀϤⲈⲨ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϢⲀ ⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲞⲨϨⲰⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲞⲨⲢⲞ ⲀⲨⲄⲞⲨⲤⲦⲞⲤ ϪⲈ ⲚⲦⲈϮⲞⲒⲔⲞⲒⲘⲈⲚⲎ ⲦⲎⲢⲤ ϮⲢⲈⲚⲤ ⲈϦⲞⲨⲚ ⲈⲤϦⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ⲐⲀⲒ ⲦⲈ ϮⲀⲠⲞⲄⲢⲀⲪⲎ ⲚϨⲞⲨⲒϮ ⲈⲦⲀⲤϢⲰⲠⲒ ⲈϤⲞⲒ ⲚϨⲎⲄⲈⲘⲰⲚ ⲈϮⲤⲨⲢⲒⲀ ⲚϪⲈⲔⲨⲢⲒⲚⲚⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ⲞⲨⲞϨ ⲚⲀⲨⲚⲀ ⲦⲎⲢⲞⲨ ⲈⲤϦⲈ ⲠⲞⲨⲢⲀⲚ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲚⲤⲀⲦⲈϤⲂⲀⲔⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ⲀϤⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲚϪⲈⲠⲔⲈⲒⲰⲤⲎⲪ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲂⲀⲔⲒ ϪⲈ ⲚⲀⲌⲀⲢⲈⲐ ⲈϦⲞⲨⲚ ⲈⲞⲨⲂⲀⲔⲒ ⲚⲦⲈⲆⲀⲨⲒⲆ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲂⲎⲐⲖⲈⲈⲘ ⲈⲐⲂⲈϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲎⲒ ⲚⲈⲘ ⲐⲘⲈⲦⲒⲰⲦ ⲚⲆⲀⲨⲒⲆ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ⲈⲤϦⲈ ⲠⲈϤⲢⲀⲚ ⲚⲈⲘ ⲘⲀⲢⲒⲀⲘ ⲐⲎ ⲈⲦⲀⲨⲰⲠ ⲚⲤⲰⲤ ⲚⲀϤ ⲈⲤⲘⲂⲞⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲨⲬⲎ ⲘⲘⲀⲨ ⲀⲨⲘⲞϨ ⲈⲂⲞⲖ ⲚϪⲈⲚⲈⲤⲈϨⲞⲞⲨ ⲈⲐⲢⲈⲤⲘⲒⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ⲞⲨⲞϨ ⲀⲤⲘⲒⲤⲒ ⲘⲠⲈⲤϢⲎⲢⲒ ⲠⲒϢⲞⲢⲠ ⲘⲘⲒⲤⲒ ⲞⲨⲞϨ ⲀⲤⲔⲞⲨⲖⲰⲖϤ ⲀⲤⲬⲀϤ ϦⲈⲚⲞⲨⲞⲨⲞⲚϨϤ ϪⲈ ⲞⲨⲎⲒ ⲚⲈⲘⲘⲞⲚⲦⲞⲨ ⲘⲀ ⲘⲘⲀⲨ ⲠⲈ ϦⲈⲚⲠⲒⲘⲀⲚⲞⲨⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ϨⲀⲚⲘⲀⲚⲈⲤⲰⲞⲨ ⲈⲨⲘⲞⲚⲒ ϦⲈⲚϮⲬⲰⲢⲀ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲦⲔⲞⲒ ⲞⲨⲞϨ ⲈⲨⲢⲰⲒⲤ ϦⲈⲚⲚⲒⲢⲰⲒⲤ ⲚⲦⲈⲠⲒⲈϪⲰⲢϨ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲠⲞⲨⲞϨⲒ ⲚⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲞⲨⲰⲞⲨ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ϨⲎⲠⲠⲈ ⲄⲀⲢ ϮϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲦⲈⲚ ⲚⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ⲪⲀⲒ ⲈⲐⲚⲀϢⲰⲠⲒ ⲘⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ϪⲈ ⲀⲨⲘⲒⲤⲒ ⲚⲰⲦⲈⲚ ⲘⲪⲞⲞⲨ ⲚⲞⲨⲤⲰⲦⲎ ⲢⲈⲦⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϬⲞⲒⲤ ⲠⲈ ϦⲈⲚⲐⲂⲀⲔⲒ ⲚⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ⲞⲨⲞϨ ⲪⲀⲒ ⲠⲈ ⲠⲒⲘⲎⲒⲚⲒ ⲚⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲚⲞⲨⲀⲖⲞⲨ ⲈϤⲔⲞⲨⲖⲰⲖ ⲞⲨⲞϨ ⲈϤⲬⲎ ϦⲈⲚⲞⲨⲞⲨⲞⲚϨϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲚϪⲈⲞⲨⲘⲎϢ ⲘⲘⲈⲦⲘⲀⲦⲞⲒ ⲚⲦⲈⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲈⲨϨⲰⲤ ⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ϪⲈ ⲞⲨⲰⲞⲨ ϦⲈⲚⲚⲎ ⲈⲦϬⲞⲤⲒ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲞⲨϨⲒⲢⲎⲚⲎ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲚⲈⲘ ⲞⲨϮⲘⲀϮ ϦⲈⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲦⲪⲈ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲀⲨⲤⲀϪⲒ ⲚϪⲈⲚⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀⲢⲞⲚ ϢⲀ ⲂⲎⲐⲖⲈⲈⲘ ⲞⲨⲞϨ ⲚⲦⲈⲚⲚⲀⲨ ⲈⲐⲂⲈ ⲠⲀⲒⲤⲀϪⲒ ⲈⲦⲀϤϢⲰⲠⲒ ⲪⲀⲒ ⲈⲦⲀ ⲠϬⲞⲒⲤ ⲦⲀⲘⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲨⲒⲎⲤⲞⲨⲤ ⲀⲨϪⲒⲘⲒ ⲘⲘⲀⲢⲒⲀ ⲚⲈⲘ ⲒⲰⲤⲎⲪ ⲚⲈⲘ ⲠⲒⲀⲖⲞⲨ ⲈϤⲬⲎ ϦⲈⲚⲠⲒⲞⲨⲞⲚϨϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲀⲨⲈⲘⲒ ⲈⲐⲂⲈ ⲠⲒⲤⲀϪⲒ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲘⲞϤ ⲚⲈⲘⲰⲞⲨ ⲈⲐⲂⲈ ⲠⲒⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲀⲨⲈⲢϢⲪⲎ ⲢⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚⲈⲘⲰⲞⲨ ⲚϪⲈⲚⲒⲘⲀⲚⲈⲤⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲐⲞⲤ ⲚⲀⲤⲀⲢⲈϨ ⲈⲚⲀⲒⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ⲈⲤⲤⲞϬⲚⲒ ϦⲈⲚⲠⲈⲤϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ⲞⲨⲞϨ ⲀⲨⲦⲀⲤⲐⲞ ⲚϪⲈⲚⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲈⲨϮⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨϨⲰⲤ ⲈⲪⲚⲞⲨϮ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲤⲞⲐⲘⲞⲨ ⲚⲈⲘ ⲚⲎ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ⲞⲨⲞϨ ⲈⲦⲀⲨⲘⲞϨ ⲈⲂⲞⲖ ⲚϪⲈⲎⲚⲈϨⲞⲞⲨ ϪⲈ ⲚⲦⲞⲨⲤⲞⲨⲂⲎⲦϤ ⲀⲨⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲢⲞϤ ⲘⲘⲞϤ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲒⲤϪⲈⲚ ⲘⲠⲀⲦⲞⲨⲈⲢⲂⲞⲔⲒ ⲘⲘⲞϤ ϦⲈⲚⲐⲚⲈϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ⲞⲨⲞϨ ⲈⲦⲀ ⲚⲒⲈϨⲞⲞⲨ ⲘⲞϨ ⲈⲂⲞⲖ ⲚⲦⲈⲠⲒⲦⲞⲨⲂⲞ ⲔⲀⲦⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲘⲰⲨⲤⲎⲤ ⲀⲨⲈⲚϤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲘⲠϬⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ϪⲈ ϨⲰⲞⲨⲦ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲞⲨⲰⲚ ⲈⲦⲞϮ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲐⲞⲨⲀⲂ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ⲞⲨⲞϨ ⲈϮ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨϪⲞⲤ ϨⲒ ⲪⲚⲞⲘⲞⲤ ⲘⲠϬⲞⲒⲤ ϪⲈ ⲞⲨϢⲰϢ ⲚϬⲢⲞⲘⲠϢⲀⲖ ⲒⲈ ⲘⲀⲤ ⲂⲚϬⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ⲞⲨⲞϨ ⲒⲤ ϨⲎⲠⲠⲈ ⲚⲈⲞⲨⲢⲰⲘⲒ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲞϨ ⲠⲀⲒⲢⲰⲘⲒ ⲚⲈⲞⲨⲆⲒⲔⲈⲞⲤ ⲠⲈ ⲚⲢⲈϤⲈⲢϨⲞϮ ⲈϤϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠϮⲚⲞⲘϮ ⲘⲠⲒⲤⲖ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲬⲎ ϨⲒϪⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ⲞⲨⲞϨ ⲚⲈⲀⲨⲦⲀⲘⲞϤ ⲠⲈ ϦⲈⲚⲞⲨⲬⲢⲎⲘⲀⲦⲒⲤⲘⲞⲤ ⲚⲦⲞⲦϤ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈϢⲦⲈⲘⲈⲐⲢⲈϤⲚⲀⲨ ⲈⲪⲘⲞⲨ ⲘⲠⲀⲦⲈϤⲚⲀⲨ ⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ⲞⲨⲞϨ ⲀϤⲒ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈϨⲢⲎⲒ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ϦⲈⲚⲠϪⲒⲚⲦⲞⲨⲈⲚ ⲠⲒⲀⲖⲞⲨ ⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲚϪⲈⲚⲈϤⲒⲞϮ ⲈⲒⲢⲒ ⲈϪⲰϤ ⲔⲀⲦⲀ ⲠⲈⲦⲤϢⲈ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ⲀϤⲞⲖϤ ⲈϪⲈⲚ ⲚⲈϤϬⲚⲀⲨϨ ⲚϪⲈⲤⲒⲘⲰⲚ ⲞⲨⲞϨ ⲀϤⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ϮⲚⲞⲨ ⲠⲀⲚⲎⲂ ⲬⲚⲀⲬⲀ ⲠⲈⲔⲂⲰⲔ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲔⲀⲦⲀ ⲠⲈⲔⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ϪⲈ ⲀⲨⲚⲀⲨ ⲚϪⲈⲚⲀⲂⲀⲖ ⲈⲠⲈⲔⲚⲞϨⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ⲪⲎ ⲈⲦⲀⲔⲤⲈⲂⲦⲰⲦϤ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲖⲀⲞⲤ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ⲞⲨⲞⲨⲰⲒⲚⲒ ⲈⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚⲦⲈϨⲀⲚⲈⲐⲚⲞⲤ ⲚⲈⲘ ⲞⲨⲰⲞⲨ ⲚⲦⲈⲠⲈⲔⲖⲀⲞⲤ ⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ⲞⲨⲞϨ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲚϪⲈⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲞⲨϪⲰ ⲘⲘⲰⲞⲨ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ⲞⲨⲞϨ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲚϪⲈⲤⲒⲘⲰⲚ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲘⲀⲢⲒⲀ ⲐⲘⲀⲨ ⲘⲠⲒⲀⲖⲞⲨ ϪⲈ ⲒⲤ ⲪⲀⲒ ϤⲬⲎ ⲈⲞⲨϨⲈⲒ ⲚⲈⲘ ⲞⲨⲦⲰⲚϤ ⲚⲦⲈϨⲀⲚⲘⲎϢ ϦⲈⲚⲠⲒⲤⲖ ⲚⲈⲘ ⲞⲨⲘⲎⲒⲚⲒ ⲈⲨϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ⲞⲨⲞϨ ⲚⲐⲞ ϨⲰⲒ ⲈⲢⲈ ⲞⲨⲤⲎϤⲒ ⲤⲒⲚⲒ ⲚⲦⲈⲮⲨⲬⲎ ϨⲞⲠⲰⲤ ⲚⲦⲞⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲘⲎϢ ⲚϨⲎⲦ ⲚϪⲈϨⲀⲚⲘⲈⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲀⲚⲚⲀ ϮⲠⲢⲞⲪⲎⲦⲎⲤ ⲦϢⲈⲢⲒ ⲚⲪⲀⲚⲞⲨⲎⲖ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲨⲖⲎ ⲚⲀⲤⲤⲎ ⲢⲐⲀⲒ ⲚⲀⲤⲀⲒⲀⲒ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲚⲀⲤⲰⲚϦ ⲚⲈⲘ ϨⲀⲒ ⲚⲌ ⲚⲢⲞⲘⲠⲒ ⲒⲤϪⲈⲚ ⲦⲈⲤⲘⲈⲦⲠⲀⲢⲐⲈⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ⲞⲨⲞϨ ⲐⲀⲒ ⲚⲈⲀⲤⲈⲢⲬⲎⲢⲀ ϢⲀ ⲠⲆ ⲚⲢⲞⲘⲠⲒ ⲐⲎ ⲈⲚⲀⲤⲤⲒⲚⲒ ⲘⲠⲒⲈⲢⲪⲈⲒ ⲈⲂⲞⲖ ⲀⲚ ⲠⲈ ϦⲈⲚϨⲀⲚⲚⲎⲤⲦⲒⲀ ⲚⲈⲘ ϨⲀⲚⲦⲰⲂϨ ⲈⲤϢⲈⲘϢⲒ ⲚϪⲰⲢϨ ⲚⲈⲘ ⲘⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ⲞⲨⲞϨ ⲘⲠⲒ ⲠⲚⲀⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲤⲒ ⲘⲠⲈϤⲘⲐⲞ ⲀⲤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲀⲤⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ ⲠⲈ ϦⲀⲦⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲚⲞⲨⲤⲰϮ ⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲰⲔ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ⲔⲀⲦⲀ ⲪⲚⲞⲘⲞⲤ ⲘⲠϬⲞⲒⲤ ⲀⲨⲔⲞⲦⲞⲨ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲈⲦⲞⲨⲂⲀⲔⲒ ⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ⲠⲒⲀⲖⲞⲨ ⲆⲈ ⲚⲈⲀϤⲀⲒⲀⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤⲀⲘⲀϨⲒ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲤⲞⲪⲒⲀ ⲞⲨⲞϨ ⲞⲨϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀϤⲬⲎ ϨⲒϪⲰϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ⲞⲨⲞϨ ⲚⲈϢⲀⲨϢⲈ ⲚⲰⲞⲨ ⲚϪⲈⲚⲈϤⲒⲞϮ ⲚⲦⲈⲚ ⲢⲞⲘⲠⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲠⲒϢⲀⲒ ⲚⲦⲈⲠⲒⲠⲀⲤⲬⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲒⲂ ⲚⲢⲞⲘⲠⲒ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲠⲒϢⲀⲒ ⲔⲀⲦⲀ ϮⲔⲀϨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲈϨⲞⲞⲨ ϦⲈⲚⲠϪⲒⲚⲦⲞⲨⲦⲀⲤⲐⲞ ⲀϤⲤⲰϪⲠ ⲚⲤⲰⲞⲨ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚϪⲈⲠⲒⲀⲖⲞⲨ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲘⲠⲞⲨⲈⲘⲒ ⲚϪⲈⲚⲈϤⲒⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ⲈⲨⲘⲈⲨⲒ ⲆⲈ ϪⲈ ⲚⲀϤⲘⲞϢⲒ ⲚⲈⲘ ⲚⲎ ⲈⲐⲘⲞϢⲒ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲀⲨⲒ ⲚⲞⲨⲈϨⲞⲞⲨ ⲘⲘⲞϢⲒ ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ϦⲈⲚⲚⲞⲨⲤⲨⲄⲄⲈⲚⲎ ⲤⲚⲈⲘ ⲚⲎ ⲈⲦⲞⲨⲤⲰⲞⲨⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲞⲨϪⲈⲘϤ ⲀⲨⲦⲀⲤⲐⲞ ⲈⲒⲖⲎ ⲘⲈⲨⲔⲰϮ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ⲀⲨϪⲈⲘϤ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈϤϨⲈⲘⲤⲒ ϦⲈⲚⲐⲘⲎϮ ⲚⲚⲒⲢⲈϤϮⲤⲂⲰ ⲈϤⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈϤϢⲒⲚⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ⲚⲀⲨⲦⲰⲘⲦ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚϪⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲈⲘⲒ ⲚⲈⲘ ⲦⲈϤϪⲒⲚⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲞⲨⲞϨ ⲠⲈϪⲈ ⲦⲈϤⲘⲀⲨ ⲚⲀϤ ϪⲈ ⲠⲀϢⲎⲢⲒ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲀⲔⲀⲒϤ ⲚⲀⲚ ⲘⲠⲀⲒⲢⲎϮ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲀⲚⲞⲔ ⲚⲀⲚⲞⲒ ⲚⲈⲘⲔⲀϨ ⲚϨⲎⲦ ⲠⲈ ⲈⲚⲔⲰϮ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲚⲀⲢⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲠⲈ ϪⲈ ϨⲰϮ ⲈⲢⲞⲒ ⲚⲦⲀϢⲰⲠⲒ ϦⲈⲚⲚⲀ ⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ⲚⲐⲰⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲔⲀϮ ⲈⲠⲈϤⲤⲀϪⲒ ⲈⲦⲀϤϪⲞϤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲢⲎⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲚⲀⲌⲀⲢⲈⲐ ⲞⲨⲞϨ ⲚⲀϤϬⲚⲞ ⲚϪⲰϤ ⲚⲰⲞⲨ ⲠⲈ ⲦⲈϤⲘⲀⲨ ⲆⲈ ⲚⲀⲤⲀⲢⲈϨ ⲈⲚⲀⲒⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ⲠⲈ ϦⲈⲚⲠⲈⲤϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ⲞⲨⲞϨ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤⲈⲢⲠⲢⲞⲔⲞⲠⲦⲒⲚ ⲠⲈ ϦⲈⲚϮⲘⲀⲒⲎ ⲚⲈⲘ ϮⲤⲞⲨⲪⲒⲀ ⲚⲈⲘ ⲠⲒϨⲘⲞⲦ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲐⲘⲀϨ ⲒⲈ ⲚⲢⲞⲘⲠⲒ ⲚⲦⲈⲐⲘⲈⲦϨⲎⲄⲈⲘⲰⲚ ⲚⲦⲒⲂⲈⲢⲒⲞⲤ ⲠⲞⲨⲢⲞ ⲈϤⲞⲒ ⲚϨⲎⲄⲈⲘⲰⲚ ⲚϪⲈⲠⲞⲚⲦⲒⲞⲤ ⲠⲒⲖⲀⲦⲞⲤ ⲈϮⲒⲞⲨⲆⲈⲀ ⲞⲨⲞϨ ⲈϤⲞⲒ ⲚⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲠⲈϤⲤⲞⲚ ⲈϤⲞⲒ ⲚⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈⲦϨⲒⲆⲞⲨⲘⲈⲀ ⲚⲈⲘ ϮⲦⲈⲦⲢⲀⲄⲰⲚⲒⲦⲎⲤ ⲚⲬⲰⲢⲀ ⲚⲈⲘ ⲖⲒⲤⲀⲚⲒⲞⲤ ⲈϤⲞⲒ ⲚⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈϮⲀⲂⲒⲖⲒⲚⲎ ");
INSERT INTO copbhc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ⲚⲀϨⲢⲀϤ ⲚⲀⲚⲚⲀ ⲚⲈⲘ ⲔⲀⲒⲀⲪⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈϪⲈⲚ ⲒⲰⲀⲚⲚⲎⲤ ⲠϢⲎⲢⲒ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ϨⲒ ⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ⲞⲨⲞϨ ⲀϤⲒ ⲈϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲚⲦⲈⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ⲈϤϨⲒⲰⲒϢ ⲚⲞⲨⲰⲘⲤ ⲚⲦⲈⲞⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲈⲠⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ⲘⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϨⲒ ⲠϪⲰⲘ ⲚⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲤⲘⲎ ⲘⲠⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϢⲀϤⲈ ϪⲈ ⲤⲈⲂⲦⲈ ⲪⲘⲰⲒⲦ ⲘⲠϬⲞⲒⲤ ⲤⲞⲨⲦⲰⲚ ⲚⲚⲈϤⲘⲀⲚⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ϦⲈⲖⲖⲞⲦ ⲚⲒⲂⲈⲚ ⲈⲨⲈⲘⲞϨ ⲞⲨⲞϨ ⲦⲰⲞⲨ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲐⲀⲖ ⲚⲒⲂⲈⲚ ⲈⲨⲈⲐⲈⲂⲒⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈⲚⲎ ⲈⲦⲔⲞⲖϪ ⲈⲨⲤⲞⲨⲦⲰⲚ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲀϢⲦ ⲈϨⲀⲚⲘⲰⲒⲦ ⲈⲨϪⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ⲞⲨⲞϨ ⲈⲨⲈⲚⲀⲨ ⲚϪⲈⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ⲈⲠⲒⲤⲰⲦⲎ ⲢⲚⲦⲈ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ⲚⲀϤϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲚⲚⲒⲘⲎϢ ⲈⲐⲚⲎ ⲞⲨ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲈϬⲒⲰⲘⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲒⲘⲒⲤⲒ ⲚⲦⲈⲚⲒⲀϪⲰ ⲚⲒⲘ ⲀϤⲦⲀⲘⲈ ⲐⲎⲚⲞⲨ ⲈⲪⲰⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲒϪⲰⲚⲦ ⲈⲐⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ⲘⲀⲦⲀⲞⲨⲈ ⲞⲨⲦⲀϨ ⲞⲨⲚ ⲈⲂⲞⲖ ⲈϤⲘⲠϢⲀ ⲚϮⲘⲈⲦⲀⲚⲞⲒⲀ ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚϦⲢⲎⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ϪⲈ ⲠⲈⲚⲒⲰⲦ ⲚⲦⲀⲚ ⲀⲂⲢⲀⲀⲘ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲨⲚⲞⲤ ϨⲀⲚϢⲎⲢⲒ ⲚⲀⲂⲢⲀⲀⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲒⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ϨⲎⲆⲎ ⲆⲈ ⲠⲒⲔⲈⲖⲈⲂⲒⲚ ϤⲬⲎ ϦⲀ ⲐⲚⲞⲨⲚⲒ ⲚⲚⲒϢϢⲎⲚ ϢϢⲎⲚ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲦⲈϤⲚⲀⲈⲚ ⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ ⲈⲂⲞⲖ ⲀⲚ ⲤⲈⲚⲀⲔⲞⲢϪϤ ⲚⲤⲈϨⲒⲦϤ ⲈⲠⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ⲞⲨⲞϨ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲠⲈ ⲚϪⲈⲚⲒⲘⲎ ϢⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢⲐⲎⲚ ⲤⲚⲞⲨϮ ⲚⲦⲀϤ ⲘⲀⲢⲈϤϮ ⲘⲪⲎ ⲈⲦⲈⲘⲘⲞⲚⲦⲀϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲞⲨⲞⲚ ϨⲀⲚϦⲢⲎ ⲞⲨⲒ ⲚⲦⲀϤ ⲘⲀⲢⲈϤⲒⲢⲒ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ⲀⲨⲒ ⲆⲈ ⲞⲚ ⲚϪⲈϨⲀⲚⲔⲈⲦⲈⲖⲰⲚⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨϬⲒⲰⲘⲤ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲈⲢ ϨⲖⲒ ⲤⲀⲂⲞⲖ ⲘⲠⲈⲦⲐⲎϢ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ⲚⲀⲨϢⲒⲚⲒ ⲆⲈ ⲘⲘⲞϤ ⲚϪⲈϨⲀⲚⲔⲈⲘⲀⲦⲞⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ϨⲰⲚ ⲠⲈⲦⲈⲚⲚⲀⲀⲒϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲖⲈϢϪ ϨⲖⲒ ⲞⲨⲆⲈ ⲘⲠⲈⲢϬⲒ ϨⲖⲒ ⲚϪⲞⲚⲤ ⲞⲨⲞϨ ⲘⲀⲢⲞⲨⲢⲀϢ ⲐⲎⲚⲞⲨ ⲚϪⲈⲚⲈⲦⲈⲚⲞⲮⲰⲚⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ⲈϤϪⲞⲨϢⲦ ⲆⲈ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲈⲨⲘⲞⲔⲘⲈⲔ ⲦⲎⲢⲞⲨ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲈⲐⲂⲈ ⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲘⲎⲠⲞⲦⲈ ⲚⲐⲞϤ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ϮⲰⲘⲤ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ϤⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈⲠⲈⲦϪⲞⲢ ⲈⲢⲞⲒ ⲪⲎ ⲈⲦⲈ ⲚϮⲘⲠϢⲀ ⲀⲚ ⲈϮⲞⲨⲰ ⲚⲞⲨⲘⲞⲨⲤⲈⲢ ⲚⲦⲈⲠⲈϤⲐⲰⲞⲨⲒ ⲚⲐⲞϤ ⲈϤⲈⲈⲘⲤ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲚⲈⲘ ⲞⲨⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ⲪⲎ ⲈⲦⲈ ⲠⲈϤϦⲀⲒ ⲚⲞⲨⲰⲦⲈⲂ ϦⲈⲚⲦⲈϤϪⲒϪ ⲈⲦⲞⲨⲂⲞ ⲘⲠⲈϤϬⲚⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϤⲐⲰⲞⲨϮ ⲘⲠⲈϤⲤⲞⲨⲞ ⲈϮⲀⲠⲞⲐⲎⲔⲎ ⲠⲒⲦⲞϨ ⲆⲈ ϤⲚⲀⲢⲞⲔϨϤ ϦⲈⲚⲞⲨⲬⲢⲰⲘ ⲚⲀⲦϬⲈⲚⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ϨⲀⲚⲘⲎϢ ⲘⲈⲚ ⲞⲨⲚ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈϤϮⲚⲞⲘϮ ⲚⲰⲞⲨ ⲚⲀϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲘⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲠⲒⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲈϤⲤⲞϨⲒ ⲘⲘⲞϤ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲈⲐⲂⲈ ⲎⲢⲰⲆⲒⲀⲤ ⲦⲤϨⲒⲘⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲈϤⲤⲞⲚ ⲚⲈⲘ ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚϪⲈⲎⲢⲰⲆⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ⲀϤⲦⲞⲨϨⲞ ⲘⲠⲀⲒⲬⲈⲦ ⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀϤϨⲒⲞⲨⲒ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲈⲠⲒϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀϤϬⲒⲰⲘⲤ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲠⲒⲔⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀϤϬⲒⲰⲘⲤ ⲞⲨⲞϨ ⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲀⲤⲞⲨⲰⲚ ⲚϪⲈⲦⲪⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲢⲎⲒ ⲈϪⲰϤ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲠⲤⲘⲞⲦ ⲚⲞⲨⲤⲰⲘⲀ ⲘⲪⲢⲎϮ ⲚⲞⲨϬⲢⲞⲘⲠⲒ ⲞⲨⲞϨ ⲞⲨⲤⲘⲎ ⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲠⲀⲘⲈⲚⲢⲒⲦ ⲈⲦⲀⲒϮ ⲘⲀϮ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϢⲰⲠⲒ ϦⲈⲚⲐⲘⲀϨ ⲖⲚⲢⲞⲘⲠⲒ ϨⲰⲤ ⲈⲨⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ⲠϢⲎⲢⲒ ⲚⲒⲰⲤⲎⲪ ⲪⲀ ⲎⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ⲪⲀ ⲘⲀⲦⲐⲀⲦ ⲪⲀ ⲖⲈⲨⲒ ⲪⲀ ⲘⲈⲖⲬⲒ ⲪⲀ ⲒⲀⲚⲚⲎ ⲪⲀ ⲒⲰⲤⲎⲪ ");
INSERT INTO copbhc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ⲪⲀ ⲘⲀⲦⲐⲀⲐⲒⲞⲨ ⲪⲀ ⲀⲘⲰⲤ ⲪⲀ ⲚⲀⲞⲨⲘ ⲪⲀ ⲈⲤⲢⲒⲘ ⲪⲀ ⲀⲄⲄⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ⲪⲀ ⲘⲀⲀⲦ ⲪⲀ ⲘⲀⲦⲐⲀⲐⲒⲞⲨ ⲪⲀ ⲤⲎⲘⲈⲒⲚ ⲪⲀ ⲒⲰⲤⲎⲬ ⲪⲀ ⲒⲰⲆⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ⲪⲀ ⲒⲰⲚⲀⲚ ⲪⲀ ⲢⲎⲤⲀ ⲪⲀ ⲌⲞⲢⲞⲂⲀⲂⲈⲖ ⲪⲀ ⲤⲀⲖⲀⲐⲒⲎⲖ ⲪⲀ ⲚⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ⲪⲀ ⲘⲈⲖⲬⲒ ⲪⲀ ⲀⲆⲆⲒ ⲪⲀ ⲔⲰⲤⲀⲘ ⲪⲀ ⲀⲖⲘⲀⲆⲀⲘ ⲪⲀ ⲎⲢ ");
INSERT INTO copbhc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ⲪⲀ ⲒⲎⲤⲞⲨ ⲪⲀ ⲈⲖⲈⲌⲈⲢ ⲪⲀ ⲒⲰⲢⲒⲘ ⲪⲀ ⲘⲀⲦⲐⲀⲦ ⲪⲀ ⲖⲈⲨⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ⲪⲀ ⲤⲒⲘⲈⲰⲚ ⲪⲀ ⲒⲞⲨⲆⲀ ⲪⲀ ⲒⲰⲤⲎⲪ ⲪⲀ ⲒⲰⲚⲀⲘ ⲪⲀ ⲈⲖⲒⲀⲔⲒⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ⲪⲀ ⲘⲈⲖⲈⲀ ⲪⲀ ⲘⲈⲚⲚⲀ ⲪⲀ ⲘⲀⲦⲦⲀⲐⲀ ⲪⲀ ⲚⲀⲐⲀⲚ ⲪⲀ ⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ⲪⲀ ⲒⲈⲤⲤⲎ ⲪⲀ ⲒⲰⲂⲎⲆ ⲪⲀ ⲂⲞⲈⲤ ⲪⲀ ⲤⲀⲖⲘⲰⲚ ⲪⲀ ⲚⲀⲤⲤⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ⲪⲀ ⲀⲘⲒⲚⲀⲆⲀⲂ ⲪⲀ ⲀⲆⲘⲒⲚ ⲪⲀ ⲀⲢⲚⲒ ⲪⲀ ⲀⲤⲢⲰⲘ ⲪⲀ ⲪⲀⲢⲈⲤ ⲪⲀ ⲒⲞⲨⲆⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ⲪⲀ ⲒⲀⲔⲰⲂ ⲪⲀ ⲒⲤⲀⲀⲔ ⲪⲀ ⲀⲂⲢⲀⲀⲘ ⲪⲀ ⲐⲀⲢⲢⲀ ⲪⲀ ⲚⲀⲬⲰⲢ ");
INSERT INTO copbhc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ⲪⲀ ⲤⲀⲢⲞⲨⲬ ⲪⲀ ⲢⲀⲄⲀⲨ ⲪⲀ ⲪⲀⲖⲈⲬ ⲪⲀ ⲈⲂⲈⲢ ⲪⲀ ⲤⲀⲖⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ⲪⲀ ⲔⲀⲒⲚⲀⲘ ⲪⲀ ⲀⲢⲪⲀⲜⲀⲆ ⲪⲀ ⲤⲈⲘ ⲪⲀ ⲚⲰⲈ ⲪⲀ ⲖⲀⲘⲈⲬ ");
INSERT INTO copbhc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ⲪⲀ ⲘⲀⲐⲨⲤⲀⲖⲀ ⲪⲀ ⲈⲚⲰⲬ ⲪⲀ ⲒⲀⲢⲆ ⲪⲀ ⲘⲀⲖⲈⲖⲈⲎⲖ ⲪⲀ ⲔⲀⲒⲚⲀⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ⲪⲀ ⲈⲚⲰⲤ ⲪⲀ ⲤⲎⲐ ⲪⲀ ⲀⲆⲀⲘ ⲪⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲀϤⲦⲀⲤⲐⲞ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ⲞⲨⲞϨ ⲀϤⲞⲖϤ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ⲚⲘ ⲚⲈϨⲞⲞⲨ ⲈϤⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲞⲨⲞϨ ⲘⲠⲈϤⲞⲨⲈⲘ ϨⲖⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲀϤϨⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲀϪⲞⲤ ⲘⲠⲀⲒⲰⲚⲒ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲤⲤϦⲎ ⲞⲨⲦ ϪⲈ ⲚⲀⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀⲰⲚϦ ⲈⲰⲒⲔ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲖϤ ⲈⲠϢⲰⲒ ⲀϤⲦⲀⲘⲞϤ ⲈⲚⲒⲘⲈⲦⲞⲨⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲚⲦⲈϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ϦⲈⲚⲞⲨⲤⲦⲒⲄⲘⲎ ⲚⲦⲈⲞⲨⲬⲢⲞⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ϪⲈ ϮⲚⲀϮ ⲚⲀⲔ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ⲦⲎⲢϤ ⲚⲈⲘ ⲠⲞⲨⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲈⲦⲈϤⲦⲞⲒ ⲈⲦⲞⲦ ⲞⲨⲞϨ ⲪⲎ ⲈϮⲞⲨⲀϢϤ ϢⲀⲒⲦⲎⲒϤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ⲚⲐⲞⲔ ⲞⲨⲚ ⲀⲔϢⲀⲚⲞⲨⲰϢⲦ ⲘⲠⲀⲘⲐⲞ ⲈⲂⲞⲖ ⲈϤⲈϢⲰⲠⲒ ⲚⲀⲔ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲠⲈ ⲈⲦⲈⲔⲈⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲠⲈⲦⲈⲔⲈϢⲈⲘϢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ⲀϤⲈⲚϤ ⲆⲈ ⲞⲚ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲈϪⲈⲚ ⲠⲦⲈⲚϨ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ϨⲒⲦⲔ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ⲦⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ⲈϤⲈϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲐⲂⲎⲦⲔ ϪⲈ ⲚⲦⲞⲨⲀⲢⲈϨ ⲈⲢⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ⲞⲨⲞϨ ⲚⲦⲞⲨϤⲒⲦⲔ ⲈϪⲈⲚ ⲚⲞⲨϬⲚⲀⲨϨ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈⲔϬⲒϬⲢⲞⲠ ⲈⲞⲨⲰⲚⲒ ⲚⲦⲈⲔϬⲀⲖⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲨϪⲞⲤ ϪⲈ ⲚⲚⲈⲔⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈⲔ ⲠⲒⲢⲀⲤⲘⲞⲤ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ϢⲀ ⲞⲨⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ⲞⲨⲞϨ ⲀϤⲦⲀⲤⲐⲞ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϦⲞⲨⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ϦⲈⲚϮϪⲞⲘ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲞⲨⲤⲘⲎ ⲀⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤϮⲤⲂⲰ ϦⲈⲚⲚⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲨϮⲰⲞⲨ ⲚⲀϤ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲚⲀⲌⲀⲢⲈⲐ ⲠⲒⲘⲀ ⲈⲦⲀⲨϢⲀⲚⲞⲨϢϤ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲔⲀⲦⲀ ϮⲔⲀϨⲤ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲈⲰϢ ");
INSERT INTO copbhc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ⲞⲨⲞϨ ⲀⲨϮ ⲚⲀϤ ⲘⲠϪⲰⲘ ⲚⲦⲈⲎⲤⲀⲎⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲰⲚ ⲈⲠⲒϪⲰⲘ ⲀϤϪⲒⲘⲒ ⲘⲠⲒⲘⲀ ⲈⲚⲀϤⲤϦⲎⲞⲨⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ϪⲈ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠϬⲞⲒⲤ ⲠⲈⲦⲬⲎ ϨⲒϪⲰⲒ ⲈⲐⲂⲈ ⲪⲀⲒ ⲀϤⲐⲀϨⲤⲦ ⲀϤⲞⲨⲰⲢⲠ ⲘⲘⲞⲒ ⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲚⲒϨⲎⲔⲒ ⲈϨⲒⲰⲒϢ ⲚⲚⲒⲈⲬⲘⲀⲖⲰⲦⲞⲤ ⲚⲞⲨⲬⲰ ⲈⲂⲞⲖ ⲚⲈⲘ ⲞⲨⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲚⲒⲂⲈⲖⲖⲈⲨ ⲈⲞⲨⲰⲢⲠ ⲚⲚⲎ ⲈⲦⲤⲞⲚϨ ϦⲈⲚⲞⲨⲬⲰ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ⲈϨⲒⲰⲒϢ ⲚⲞⲨⲢⲞⲘⲠⲒ ⲈⲤϢⲎⲠ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ⲞⲨⲞϨ ⲈⲦⲀϤⲔⲈⲖ ⲠⲒϪⲰⲘ ⲀϤⲦⲎⲒϤ ⲘⲠⲒϨⲨⲠⲎ ⲢⲈⲦⲎⲤ ⲀϤϨⲈⲘⲤⲒ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϦⲈⲚ ϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲀⲢⲈ ⲚⲞⲨⲂⲀⲖ ϪⲞⲨϢⲦ ⲈϨⲢⲎⲒ ϨⲰⲒⲦϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲤϪⲰⲔ ⲈⲂⲞⲖ ⲘⲪⲞⲞⲨ ⲚϪⲈⲦⲀⲒⲄⲢⲀⲪⲎ ϦⲈⲚⲚⲈⲦⲈⲚⲘⲀϢϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲘⲈⲐⲢⲈ ⲚⲀϤ ⲦⲎⲢⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲠⲒϨⲘⲞⲦ ⲚⲎ ⲈⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲠϢⲎⲢⲒ ⲚⲒⲰⲤⲎⲪ ");
INSERT INTO copbhc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲀⲚⲦⲰⲤ ⲦⲈⲦⲈⲚⲚⲀϪⲈ ⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲎⲒ ϪⲈ ⲠⲒⲤⲎⲒⲚⲒ ⲀⲢⲒⲪⲀϦⲢⲒ ⲈⲢⲞⲔ ⲘⲘⲀⲨⲀⲦⲔ ⲚⲎ ⲈⲦⲀⲚⲤⲞⲐⲘⲞⲨ ⲈⲀⲨϢⲰⲠⲒ ϦⲈⲚⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲀⲢⲒⲦⲞⲨ ⲘⲠⲀⲒⲘⲀ ϨⲰϤ ϦⲈⲚⲦⲈⲔⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤϢⲎⲠ ϦⲈⲚⲦⲈϤⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ⲦⲀⲪⲘⲎⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲬⲎⲢⲀ ⲠⲈ ϦⲈⲚⲠⲒⲤⲖ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲎⲖⲒⲀⲤ ϨⲞⲦⲈ ⲈⲦⲀⲤϢⲐⲀⲘ ⲚϪⲈⲦⲪⲈ ⲚⲄ ⲚⲢⲞⲘⲠⲒ ⲚⲈⲘ ⲚⲀⲂⲞⲦ ϨⲰⲤⲦⲈ ⲚⲦⲈϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϨⲂⲰⲚ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ⲞⲨⲞϨ ⲘⲠⲞⲨⲞⲨⲰⲢⲠ ⲚⲎⲖⲒⲀⲤ ϨⲀ ϨⲖⲒ ⲘⲘⲰⲞⲨ ⲈⲂⲎⲖ ϨⲀ ⲞⲨⲤϨⲒⲘⲒ ⲚⲬⲎⲢⲀ ⲐⲎ ⲈⲦϦⲈⲚ ⲤⲀⲢⲈⲠⲦⲀ ⲚⲦⲈϮⲤⲒⲆⲰⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲔⲀⲔⲤⲈϨⲦ ⲠⲈ ϦⲈⲚⲠⲒⲤⲖ ⲚⲀϨⲢⲀϤ ⲚⲈⲖⲒⲤⲈⲞⲤ ⲠⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ⲚϦⲎⲦⲞⲨ ⲦⲞⲨⲂⲞ ⲈⲂⲎⲖ ⲈⲚⲈⲘⲀⲚ ⲠⲒⲤⲨⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ⲞⲨⲞϨ ⲀⲨⲘⲞϨ ⲦⲎⲢⲞⲨ ⲚϪⲰⲚⲦ ⲈⲨⲤⲰⲦⲈⲘ ⲈⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ⲞⲨⲞϨ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲀⲨϨⲒⲦϤ ⲤⲀⲂⲞⲖ ⲚϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲠϬⲒⲤⲒ ⲘⲠⲒⲦⲰⲞⲨ ⲪⲎ ⲈⲚⲀⲢⲈ ⲦⲞⲨⲂⲀⲔⲒ ⲬⲎ ϨⲒϪⲰϤ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨϪⲞⲖⲔϤ ⲈϦⲢⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲢⲎⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲞⲨⲂⲀⲔⲒ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲚⲰⲞⲨ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ⲞⲨⲞϨ ⲚⲀⲨⲦⲰⲘⲦ ⲈϪⲈⲚ ⲦⲈϤⲤⲂⲰ ϪⲈ ⲚⲀⲢⲈ ⲠⲈϤⲤⲀϪⲒ ⲬⲎ ϦⲈⲚⲞⲨⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲀϤⲰϢ ⲈⲠϢⲰⲒ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϦⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ϪⲈ ⲀϦⲞⲔ ⲚⲈⲘⲀⲚ ϨⲰⲔ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲈⲦⲀⲔⲒ ⲈⲦⲀⲔⲞⲚ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞⲔ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠⲒⲀⲄⲒⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲐⲰⲘ ⲚⲢⲰⲔ ⲞⲨⲞϨ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲈⲦⲀ ⲠⲒⲆⲈⲘⲰⲚ ⲤⲀⲦϤ ⲈⲐⲘⲎϮ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲘⲠⲈϤϮ ϨⲖⲒ ⲚⲈⲘⲔⲀϨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ⲞⲨⲞϨ ⲀⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ϢⲰⲠⲒ ϨⲒϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎ ⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲀⲒⲤⲀϪⲒ ϪⲈ ϦⲈⲚⲞⲨⲈⲢϢⲒϢⲒ ⲚⲈⲘ ⲞⲨϪⲞⲘ ϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲤⲈⲚⲎⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲤⲘⲎ ⲤⲎⲢ ⲈⲂⲞⲖ ⲈⲐⲂⲎⲦϤ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲚⲦⲈϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ⲀϤⲦⲰⲚϤ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲦϢⲰⲘⲒ ⲆⲈ ⲚⲤⲒⲘⲰⲚ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲚϦⲘⲞⲘ ⲚⲈⲘⲀⲤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ⲞⲨⲞϨ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲠϢⲰⲒ ⲘⲘⲞⲤ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲒϦⲘⲞⲘ ⲞⲨⲞϨ ⲀϤⲬⲀⲤ ⲤⲀⲦⲞⲦⲤ ⲆⲈ ⲀⲤⲦⲰⲚⲤ ⲞⲨⲞϨ ⲀⲤϢⲈⲘϢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ⲈⲦⲀ ⲪⲢⲎ ⲆⲈ ϨⲰⲦⲠ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲢⲈϤϢⲰⲚⲒ ⲘⲘⲀⲨ ϦⲈⲚϨⲀⲚϢⲰⲚⲒ ⲚⲞⲨⲘⲎϢ ⲚⲢⲎϮ ⲈⲨⲈⲚⲞⲨ ϨⲀⲢⲞϤ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲬⲀ ϪⲒϪ ⲈϪⲈⲚ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ⲚⲀⲨⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈϨⲀⲚⲔⲈⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲘⲎϢ ⲈⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ⲠⲈ ⲚϤⲬⲰ ⲘⲘⲰⲞⲨ ⲀⲚ ⲈⲤⲀϪⲒ ϪⲈ ⲚⲀⲨⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲚⲐⲞϤ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ϢⲰⲠⲒ ⲀϤⲒ ⲈⲂⲞⲖ ⲀϤϢⲈ ⲚⲀϤ ⲈⲞⲨⲘⲀ ⲚϢⲀϤⲈ ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ⲠⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲚⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲠⲈ ⲈϢⲦⲈⲘⲈⲐⲢⲈϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲰϮ ⲠⲈ ⲚⲦⲀϨⲒϢⲈⲚⲚⲞⲨϤⲒ ϦⲈⲚⲚⲒⲔⲈⲂⲀⲔⲒ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ϪⲈ ⲞⲨⲎⲒ ⲈⲦⲀⲨⲦⲀⲞⲨⲞⲒ ⲈⲐⲂⲈ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ⲞⲨⲞϨ ⲚⲀϤϨⲒⲰⲒϢ ⲠⲈ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲈϪⲰϤ ⲚϪⲈⲚⲒⲘⲎϢ ⲞⲨⲞϨ ⲈⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲠⲈ ϦⲀⲦⲈⲚ ϮⲖⲨⲘⲚⲎ ⲚⲦⲈⲄⲈⲚⲚⲎⲌⲀⲢⲈⲐ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈϪⲞⲒ ⲂⲈⲨⲘⲞⲚⲒ ϦⲀⲦⲈⲚ ϮⲖⲨⲘⲚⲎ ⲚⲒⲞⲨⲞϨⲒ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈϨⲢⲎⲒ ϨⲒⲰⲦⲞⲨ ⲚⲀⲨⲢⲰϦⲒ ⲚⲚⲞⲨϢⲚⲎⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ⲀϤⲞⲖϤ ⲚⲞⲨⲀⲒ ⲚⲚⲒϪⲞⲒ ⲈⲪⲀ ⲤⲒⲘⲰⲚ ⲠⲈ ⲀϤϪⲞⲤ ⲚⲀϤ ⲈⲐⲢⲈϤϨⲈⲚϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲬⲢⲞ ⲚⲞⲨⲔⲞⲨϪⲒ ⲈⲦⲀϤϨⲈⲘⲤⲒ ⲆⲈ ⲚⲀϤϮⲤⲂⲰ ⲚⲚⲒⲘⲎ ϢⲈⲂⲞⲖ ϨⲒ ⲠⲒϪⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ⲈⲦⲀϤⲞⲨⲰ ⲆⲈ ⲈϤⲤⲀϪⲒ ⲠⲈϪⲀϤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ⲈⲠⲈⲦϢⲎⲔ ⲞⲨⲞϨ ⲬⲀ ⲚⲈⲦⲈⲚϢⲚⲎ ⲞⲨ ⲈϦⲢⲎⲒ ⲈⲞⲨϪⲞⲢϪⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈϪⲀϤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲠⲒⲈϪⲰⲢϨ ⲦⲎⲢϤ ⲀⲚⲀⲒϤ ⲚϦⲞⲤⲒ ⲘⲠⲈⲚⲦⲀϨⲞ ϦⲈⲚⲠⲈⲔⲤⲀϪⲒ ⲆⲈ ⲦⲈⲚⲚⲀⲬ ⲰⲚⲚⲒϢⲚⲎⲞⲨ ⲈϦⲢⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ⲈⲦⲀⲨⲒⲢⲒ ⲆⲈ ⲘⲪⲀⲒ ⲀⲨⲐⲰⲞⲨϮ ⲚⲞⲨⲘⲎ ϢⲚⲦⲈⲂⲦ ⲈⲚⲀϢⲰϤ ⲚⲀⲨⲚⲀⲪⲰϦ ⲆⲈ ⲠⲈ ⲚϪⲈⲚⲒϢⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ⲞⲨⲞϨ ⲀⲨϬⲰⲢⲈⲘ ⲈⲚⲞⲨϢⲪⲎⲢ ⲚⲎ ⲈⲦϨⲒ ⲠⲒⲔⲈϪⲞⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲒ ⲚⲦⲞⲨϮⲦⲞⲦⲞⲨ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲒ ⲀⲨⲘⲀϨ ⲠⲒϪⲞⲒ ⲂϨⲰⲤⲦⲈ ⲚⲦⲞⲨⲈⲢϨⲎⲦⲤ ⲚⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲀϤϨⲒⲦϤ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲠⲀϬⲞⲒⲤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ⲞⲨϨⲞϮ ⲄⲀⲢ ⲀⲤⲦⲀϨⲞϤ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲈⲘⲀϤ ⲈϪⲈⲚ ϮϪⲞⲢϪⲤ ⲚⲦⲈⲚⲒⲦⲈⲂⲦ ⲈⲦⲀⲨⲦⲀϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲞⲚ ⲠⲒⲔⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲎ ⲈⲚⲀⲨⲞⲒ ⲚϢⲪⲎⲢ ⲈⲤⲒⲘⲰⲚ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲄⲀⲢ ⲈⲔⲈϢⲰⲠⲒ ⲚⲞⲨⲞϨⲒ ⲚⲢⲈϤⲦⲀϨⲈ ⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲈⲔ ⲚⲒϢⲚⲎⲞⲨ ⲈⲠⲒⲬⲢⲞ ⲀⲨⲬⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲤⲰⲞⲨ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲞⲨⲒ ⲚⲚⲒⲂⲀⲔⲒ ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈϤⲘⲈϨ ⲚⲤⲈϨⲦ ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ⲈϤϮϨⲞ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲔϢⲀⲚⲞⲨⲰϢ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲦⲞⲨⲂⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ⲞⲨⲞϨ ⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤϬⲒ ⲚⲈⲘⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲞⲨⲰϢ ⲘⲀⲦⲞⲨⲂⲞ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲚϪⲈⲠⲒⲤⲈϨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ⲚⲐⲞϤ ⲆⲈ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲀϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢϪⲞⲤ ⲚϨⲖⲒ ⲀⲖⲖⲀ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲀⲦⲀⲘⲈ ⲠⲒⲞⲨⲎⲂ ⲈⲢⲞⲔ ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒ ⲈϪⲈⲚ ⲠⲈⲔⲦⲞⲨⲂⲞ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚϪⲈⲘⲰⲨⲤⲎⲤ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ⲀϤⲤⲰⲢ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲞⲨⲞ ⲚϪⲈⲠⲒⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞϨ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲈⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ϦⲈⲚⲚⲞⲨϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ⲚⲐⲞϤ ⲆⲈ ⲚⲈϢⲀϤϢⲈ ⲚⲀϤ ⲈⲚⲒⲘⲀⲚϢⲀϤⲈ ⲚⲦⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲀⲒ ⲚⲚⲒⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤϮⲤⲂⲰ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨϨⲈⲘⲤⲒ ⲚϪⲈϨⲀⲚⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ϨⲀⲚⲢⲈϤϮⲤⲂⲰ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲈⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲞⲨϪⲞⲘ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲀⲤϢⲞⲠ ⲈⲠϪⲒⲚⲦⲀⲖϬⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ⲞⲨⲞϨ ⲒⲤ ϨⲎⲠⲠⲈ ⲀⲨⲒⲚⲒ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲚⲞⲨⲀⲒ ⲈϤϢⲎⲖ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲞⲨϬⲖⲞϪ ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚⲤⲀⲈⲚϤ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲈⲬⲀϤ ⲘⲠⲈϤⲘⲐⲞ ");
INSERT INTO copbhc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲞⲨϪⲈⲘ ⲠⲒⲢⲎϮ ⲚⲈⲚϤ ⲈϦⲞⲨⲚ ⲈⲐⲂⲈ ⲠⲒⲘⲎϢ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒϪⲈⲚⲈⲪⲰⲢ ⲀⲨⲬⲀϤ ⲈϦⲢⲎⲒ ⲚⲈⲘ ⲠⲒϬⲖⲞϪ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲖⲰⲂϢ ϦⲈⲚⲐⲘⲎϮ ⲘⲠⲈⲘⲐⲞ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲞⲨⲚⲀϨϮ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ⲪⲢⲰⲘⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ⲚϪⲈⲚⲈⲔⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲘⲘⲞⲔⲘⲈⲔ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲪⲀⲒ ⲈⲦⲤⲀϪⲒ ⲘⲠⲀⲒϪⲈⲞⲨⲀ ⲚⲒⲘ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ⲈⲂⲎⲖ ⲈⲠⲒⲞⲨⲀⲒ ⲘⲘⲀⲨⲀⲦϤ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲞⲨⲘⲞⲔⲘⲈⲔ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ϦⲈⲚⲚⲈⲦⲈⲚϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ⲞⲨ ⲈⲐⲘⲞⲦⲈⲚ ⲈϪⲞⲤ ϪⲈ ⲚⲈⲔⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲀⲔ ⲈⲂⲞⲖ ⲒⲈ ⲈϪⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲞⲨⲞϨ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨⲞⲚ ⲈⲢϢⲒϢⲒ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲘⲪⲎ ⲈⲦϢⲎⲖ ⲈⲂⲞⲖ ϪⲈ ⲚⲐⲞⲔ ⲠⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲦⲰⲚⲔ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲈⲔⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲦⲰⲚϤ ⲘⲠⲞⲨⲘⲐⲞ ⲈⲂⲞⲖ ⲀϤⲰⲖⲒ ⲘⲪⲎ ⲈⲚⲀϤⲚⲔⲞⲦ ϨⲒϪⲰϤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲈϤⲎⲒ ⲈϤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ⲞⲨⲞϨ ⲞⲨⲦⲰⲘⲦ ⲀϤϬⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀⲨⲘⲞϨ ⲚϨⲞϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈϨⲀⲚϢⲪⲎⲢⲒ ⲘⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲀϤⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲞⲨⲦⲈⲖⲰⲚⲎⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲖⲈⲨⲒ ⲈϤϨⲈⲘⲤⲒ ϨⲒ ⲞⲨⲦⲈⲖⲰⲚⲒⲞⲚ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ⲞⲨⲞϨ ⲀϤⲬⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀϤⲦⲰⲚϤ ⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ⲞⲨⲞϨ ⲖⲈⲨⲒ ⲀϤⲈⲢ ⲞⲨⲚⲒϢϮ ⲚϢⲞⲠⲤ ⲈⲢⲞϤ ⲚϦⲞⲨⲚ ϦⲈⲚⲠⲈϤⲎⲒ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲚⲦⲈⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬ ⲰⲞⲨⲚⲒ ⲈⲨⲢⲞⲦⲈⲂ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ⲞⲨⲞϨ ⲚⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲂⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲰ ⲚⲈⲘ ⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲎ ⲈⲦϪⲞⲢ ⲤⲈⲈⲢⲬⲢⲒⲀ ⲘⲠⲒⲤⲎⲒⲚⲒ ⲀⲚ ⲀⲖⲖⲀ ⲚⲎ ⲈⲐⲘⲞⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ⲚⲈⲦⲀⲒⲒ ⲄⲀⲢ ⲀⲚ ⲈⲐⲀϨⲈⲘ ⲚⲒⲐⲘⲎⲒ ⲀⲖⲖⲀ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲒⲘⲀⲐⲎ ⲦⲎⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲤⲈⲒⲢⲒ ⲚϨⲀⲚⲘⲎϢ ⲚⲚⲎⲤⲦⲒⲀ ⲚⲈⲘ ϨⲀⲚⲦⲰⲂϨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲐⲰⲞⲨ ⲤⲈⲞⲨⲰⲘ ⲤⲈⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲎ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲐⲢⲈ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲎ ⲦⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ϨⲰⲤ ⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ⲤⲈⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲰⲖⲒ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ ⲦⲞⲦⲈ ⲈⲨⲈⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ⲚⲀⲨϪⲰ ⲆⲈ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲀⲢⲈ ϨⲖⲒ ⲪⲈϦ ⲞⲨⲦⲰⲒⲤ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲂⲞⲤ ⲘⲂⲈⲢⲒ ⲚⲦⲈϤϨⲒⲦⲤ ⲈⲞⲨϨⲂⲞⲤ ⲚⲀⲠⲀⲤ ⲘⲘⲞⲚ ϢⲀⲤⲪⲈϦ ⲠⲒⲔⲈⲂⲈⲢⲒ ⲞⲨⲞϨ ⲘⲠⲀⲤϮⲘⲀϮ ⲚⲈⲘ ⲠⲒⲀⲠⲀⲤ ⲚϪⲈϮⲦⲰⲒⲤ ⲈⲦⲀⲨⲞⲖⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲂⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ⲞⲨⲆⲈ ⲘⲠⲀⲢⲈ ϨⲖⲒ ϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲚⲀⲠⲀⲤ ⲘⲘⲞⲚ ϢⲀⲢⲈ ⲠⲒⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲪⲈϦ ⲚⲒⲀⲤⲔⲞⲤ ⲞⲨⲞϨ ⲚⲐⲞϤ ϢⲀϤⲪⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒⲀⲤⲔⲞⲤ ⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ⲀⲖⲖⲀ ⲈϢⲀⲨϨⲒ ⲎⲢⲠ ⲘⲂⲈⲢⲒ ⲈⲀⲤⲔⲞⲤ ⲘⲂⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲈϤⲤⲰ ⲀⲠⲀⲤ ⲚⲀⲞⲨⲰϢ ⲂⲈⲢⲒ ϤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ϤϨⲞⲖϪ ⲚϪⲈⲠⲒⲀⲠⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀϤⲤⲒⲚⲒ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲢⲞϮ ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϤⲰϪⲒ ⲚⲚⲒϦⲈⲘⲤ ⲈⲨⲤⲀϨⲤⲀϨ ⲘⲘⲰⲞⲨ ϦⲈⲚⲚⲞⲨϪⲒϪ ⲞⲨⲞϨ ⲈⲨⲞⲨⲰⲘ ⲘⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲠⲈⲦⲤⲈⲘⲠϢⲀ ⲚⲀⲒϤ ⲀⲚ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲆⲈ ⲪⲀⲒ ⲘⲠⲈⲦⲈⲚⲞϢϤ ⲪⲎ ⲈⲦⲀ ⲆⲀⲨⲒⲆ ⲀⲒϤ ϨⲞⲦⲈ ⲈⲦⲀϤϨⲔⲞ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ⲠⲰⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲒⲰⲒⲔ ⲚⲦⲈϮⲠⲢⲞⲐⲈⲤⲒⲤ ⲀϤϬⲒⲦⲞⲨ ⲀϤⲞⲨⲞⲘⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲐⲚⲈⲘⲀϤ ⲚⲎ ⲈⲦⲈⲚⲤϢⲈ ⲚⲰⲞⲨ ⲀⲚ ⲈⲞⲨⲞⲘⲞⲨ ⲈⲂⲎⲖ ⲈⲚⲒⲞⲨⲎⲂ ⲘⲘⲀⲨⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲠⲒⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲦⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲀϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲘⲘⲀⲨ ⲠⲈ ⲈⲢⲈ ⲦⲈϤϪⲒϪ ⲚⲞⲨⲒⲚⲀⲘ ϢⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ⲚⲀⲨϮⲚⲒⲀⲦⲞⲨ ⲚⲀϤ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲀⲚ ϤⲚⲀⲈⲢⲪⲀϦⲢⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲒⲚⲀ ⲚⲦⲞⲨϪⲈⲘ ⲔⲀⲦⲎⲄⲞⲢⲒⲀ ϦⲀⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲈⲘⲒ ⲈⲚⲞⲨⲘⲞⲔⲘⲈⲔ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲚⲀⲢⲈ ⲦⲈϤϪⲒϪ ϢⲞⲨⲰⲞⲨ ϪⲈ ⲦⲰⲚⲔ ⲞϨⲒ ⲈⲢⲀⲦⲔ ϦⲈⲚⲐⲘⲎϮ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ϮϢⲒⲚⲒ ⲘⲘⲰⲦⲈⲚ ϪⲈ ⲀⲚ ⲤϢⲈ ⲚⲈⲢ ⲠⲈⲐⲚⲀⲚⲈϤ ϦⲈⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϢⲀⲚ ⲈⲈⲢ ⲠⲈⲦϨⲰⲞⲨ ⲞⲨⲮⲨⲬⲎ ⲈⲚⲀϨⲘⲈⲤ ϢⲀⲚ ⲈⲦⲀⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲈϪⲀϤ ⲘⲠⲒⲢⲰⲘⲒ ϪⲈ ⲤⲞⲨⲦⲈⲚ ⲦⲈⲔϪⲒϪ ⲈⲂⲞⲖ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲤⲞⲨⲦⲰⲚⲤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀⲤⲞⲨϪⲀⲒ ⲚϪⲈⲦⲈϤϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦⲔⲀϮ ⲞⲨⲞϨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲀⲒϤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲒ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲞⲨⲞϨ ⲚⲀϤⲞⲒ ⲚϢⲢⲰⲒⲤ ϦⲈⲚϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ⲞⲨⲞϨ ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ϢⲰⲠⲒ ⲀϤⲘⲞⲨϮ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲀϤⲤⲰⲦⲠ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲘⲒⲂ ⲚⲎ ⲈⲦⲀϤϮⲢⲈⲚⲞⲨ ϪⲈ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲐⲞⲖⲞⲘⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ⲚⲈⲘ ⲘⲀⲦⲐⲈⲞⲤ ⲚⲈⲘ ⲐⲰⲘⲀⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲦⲈⲀⲖⲪⲈⲞⲤ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲢⲈϤⲬⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲚⲦⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϦⲢⲎⲒ ⲚⲈⲘⲰⲞⲨ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲞⲨ ⲘⲀⲚⲔⲞⲒ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲚⲦⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲘ ⲔⲈⲘⲎϢ ⲈϤⲞϢ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚϮⲠⲀⲢⲀⲖⲒⲞⲤ ⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ⲚⲎ ⲈⲦⲀⲨⲒ ⲈⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲀⲖϬⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨϢⲰⲚⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲦϨⲈⲘⲔⲞ ⲘⲘⲰⲞⲨ ⲚϪⲈⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲔⲰϮ ⲚⲤⲀϬⲒ ⲚⲈⲘⲀϤ ϪⲈ ⲞⲨⲎⲒ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚϪⲈⲞⲨϪⲞⲘ ⲞⲨⲞϨ ⲚⲀϤⲦⲀⲖϬⲞ ⲘⲘⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲈⲦⲀϤϤⲀⲒ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲒϨⲎⲔⲒ ϪⲈ ⲐⲰⲦⲈⲚ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲎ ⲈⲦϨⲞⲔⲈⲢ ϮⲚⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲤⲒ ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲎ ⲈⲦⲢⲒⲘⲒ ϮⲚⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲤⲰⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϢⲰⲠ ⲚⲦⲞⲨⲘⲈⲤⲦⲈ ⲐⲎⲚⲞⲨ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲞⲨⲈⲦ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲈϢ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨϨⲒ ⲠⲈⲦⲈⲚⲢⲀⲚ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲚⲞⲨⲠⲈⲦϨⲰⲞⲨ ⲈⲐⲂⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ⲢⲀϢⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲐⲈⲖⲎⲖ ϨⲎⲠⲠⲈ ⲄⲀⲢ ⲠⲈⲦⲈⲚⲂⲈⲬⲈ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲪⲈ ⲚⲀⲒ ⲄⲀⲢ ⲈⲚⲀⲨⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚϪⲈⲚⲞⲨⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϦⲀ ⲚⲒⲢⲀⲘⲀⲞ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲎⲚ ⲈⲢⲈⲦⲈⲚϬⲒ ⲘⲠⲈⲦⲈⲚϮϨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦⲤⲎⲞⲨ ϮⲚⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀϨⲔⲞ ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦⲤⲰⲂⲒ ϮⲚⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲈⲢϨⲎⲂⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲢⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲈϢⲰⲠ ⲀⲨϢⲀⲚϪⲞⲤ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲦⲎⲢⲞⲨ ϪⲈ ⲔⲀⲖⲰⲤ ⲚⲀⲒ ⲄⲀⲢ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ⲈⲚⲀⲨⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲚⲞⲨϪ ⲚϪⲈⲚⲞⲨⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ϪⲈ ⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚϪⲀϪⲒ ⲀⲢⲒ ⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲚⲎ ⲈⲐⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ⲤⲘⲞⲨ ⲈⲚⲎ ⲈⲦⲤⲀϨⲞⲨⲒ ⲈⲢⲰⲦⲈⲚ ⲦⲰⲂϨ ⲈϪⲈⲚ ⲚⲎ ⲈⲦϬⲞϪⲒ ⲚⲤⲀⲐⲎⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ⲪⲎ ⲈⲐⲚⲀϨⲒⲞⲨⲒ ϦⲈⲚⲦⲀⲒⲞⲨⲞϪⲒ ⲬⲀ ϮⲬⲈϮ ϦⲀⲦⲞⲦϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲰⲖⲒ ⲘⲠⲈⲔϨⲂⲞⲤ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲘⲘⲞϤ ⲈⲰⲖⲒ ⲚⲦⲈⲔⲔⲈϢⲐⲎ Ⲛ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞⲔ ⲘⲞⲒ ⲚⲀϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲈⲖ ⲚⲈⲦⲈⲚⲞⲨⲔ ⲘⲠⲈⲢϢⲀⲦϤ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲚⲦⲞⲨⲒⲢⲒ ⲚⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲀⲢⲒⲞⲨⲒ ⲚⲰⲞⲨ ϨⲰⲦⲈⲚ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲀⲢⲈⲦⲈⲚⲚⲀⲘⲈⲚⲢⲈ ⲚⲎ ⲈⲐⲘⲈⲒ ⲘⲘⲰⲦⲈⲚ ⲀϢ ⲠⲈ ⲠⲈⲦⲈⲚϨⲘⲞⲦ ⲔⲈ ⲄⲀⲢ ⲚⲒⲔⲈⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲀⲨⲘⲈⲒ ⲚⲚⲎ ⲈⲐⲘⲈⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚⲚⲀⲈⲢ ⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲚⲎ ⲈⲦⲈⲢ ⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲈⲘⲰⲦⲈⲚ ⲀϢ ⲠⲈ ⲠⲈⲦⲈⲚϨⲘⲞⲦ ⲚⲒⲔⲈⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲤⲈⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲈⲢⲆⲀⲚⲒⲌⲒⲚ ⲚϨⲀⲚⲞⲨⲞⲚ ⲈⲢⲈⲦⲈⲚϨⲈⲖⲠⲒⲤ ⲈϬⲒ ⲚⲦⲞⲦⲞⲨ ⲀϢ ⲠⲈ ⲠⲈⲦⲈⲚϨⲘⲞⲦ ⲚⲒⲔⲈⲢⲈϤⲈⲢⲚⲞⲂⲒ ϨⲰⲞⲨ ⲤⲈⲈⲢⲆⲀⲚⲒⲌⲒⲚ ⲚⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨϬⲒ ⲚⲦⲞⲦⲞⲨ ⲚⲦⲞⲨϢⲈⲂⲒⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ⲠⲖⲎⲚ ⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚϪⲀϪⲒ ⲞⲨⲞϨ ⲀⲢⲒ ⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲘⲞⲒ ⲚⲦⲈⲦⲈⲚⲈⲢⲀⲠⲈⲖⲠⲒⲌⲒⲚ ⲀⲚ ⲚϨⲖⲒ ⲞⲨⲞϨ ϤⲚⲀϢⲰⲠⲒ ⲚϪⲈⲠⲈⲦⲈⲚⲂⲈⲬⲈ ⲈⲚⲀϢⲰϤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϢⲰⲠⲒ ⲚϢⲎⲢⲒ ⲘⲠⲈⲦϬⲞⲤⲒ ϪⲈ ⲚⲐⲞϤ ⲞⲨⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲈϪⲈⲚ ⲚⲒⲀⲦϨⲘⲞⲦ ⲚⲈⲘ ⲚⲒⲠⲞⲚⲎⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲚⲀⲎⲦ ⲘⲪⲢⲎϮ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲈϤⲞⲒ ⲚⲚⲀⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ⲘⲠⲈⲢϮϨⲀⲠ ⲞⲨⲞϨ ⲚⲚⲞⲨϮϨⲀⲠ ⲈⲢⲰⲦⲈⲚ ⲘⲠⲈⲢϨⲒⲞⲨⲒ ⲘⲠϨⲀⲠ ⲞⲨⲞϨ ⲤⲈⲚⲀϨⲒ ⲐⲎⲚⲞⲨ ⲘⲠϨⲀⲠ ⲀⲚ ⲬⲰ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲞⲨⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ⲘⲞⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϮ ⲚⲰⲦⲈⲚ ⲞⲨϢⲒ ⲈⲚⲀⲚⲈϤ ⲈϤⲘⲈϨ ⲈϤϨⲈⲚϨⲰⲚ ⲈϤⲪⲈⲚⲪⲰⲚ ⲈⲂⲞⲖ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲈⲔⲈⲚ ⲐⲎⲚⲞⲨ ⲠⲒϢⲒ ⲄⲀⲢ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲘⲘⲞϤ ⲀⲨⲚⲀϢⲒ ⲚⲰⲦⲈⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ⲀϤϪⲈ ⲔⲈⲠⲀⲢⲀⲂⲞⲖⲎ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲘⲎⲦⲒ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲞⲨⲂⲈⲖⲖⲈ ⲈϬⲒⲘⲰⲒⲦ ϦⲀϪⲰϤ ⲚⲞⲨⲂⲈⲖⲖⲈ ⲘⲎ ⲤⲈⲚⲀϨⲈⲒ ⲀⲚ ⲈϦⲢⲎⲒ ⲚⲞⲨϢⲒⲔ ⲘⲠⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ⲘⲎ ⲞⲨⲞⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲈϤⲞⲨⲞⲦ ⲈⲠⲈϤⲢⲈϤϮⲤⲂⲰ ⲘⲀⲢⲈϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϤⲤⲈⲂⲦⲰⲦ ⲘⲪⲢⲎϮ ⲘⲠⲒⲢⲈϤϮⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ⲈⲐⲂⲈⲞⲨ ϪⲈ ⲬⲚⲀⲨ ⲈⲠⲒϪⲎⲒ ϦⲈⲚⲪⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ ⲠⲒⲤⲞⲒ ⲆⲈ ⲈⲦϦⲈⲚ ⲠⲈⲔⲂⲀⲖ ⲚⲔϮⲚⲒⲀⲦⲔ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ⲒⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈϪⲞⲤ ⲘⲠⲈⲔⲤⲞⲚ ϪⲈ ⲠⲀⲤⲞⲚ ⲬⲀⲦ ⲚⲦⲀϨⲒ ⲠⲒϪⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲂⲀⲖ ⲚⲐⲞⲔ ⲆⲈ ϨⲰⲔ ⲬⲚⲀⲨ ⲀⲚ ⲈⲠⲒⲤⲞⲒ ⲈⲦϦⲈⲚ ⲠⲈⲔⲂⲀⲖ ⲠⲒϢⲞⲂⲒ ϨⲒ ⲠⲒⲤⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲂⲀⲖ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲔⲈⲚⲀⲨ ⲘⲂⲞⲖ ⲈϨⲒ ⲠⲒϪⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲂⲀⲖ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ⲞⲨ ⲄⲀⲢ ⲘⲘⲞⲚ ⲞⲨϢϢⲎⲚ ⲈⲚⲀⲚⲈϤ ⲈϤⲒⲢⲒ ⲚⲞⲨⲞⲨⲦⲀϨ ⲈϤϨⲰⲞⲨ ⲠⲀⲖⲒⲚ ⲘⲘⲞⲚ ⲞⲨϢϢⲎⲚ ⲈϤϨⲰⲞⲨ ⲈϤⲒⲢⲒ ⲚⲞⲨⲞⲨⲦⲀϨ ⲈⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ⲠⲒⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲒⲞⲨⲀⲒ ⲚⲚⲒϢϢⲎⲚ ⲈϢⲀⲨⲤⲞⲨⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲞⲨⲦⲀϨ ⲞⲨ ⲄⲀⲢ ⲘⲠⲀⲨⲤⲈⲔ ⲔⲈⲚⲦⲈ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲤⲞⲨⲢⲒ ⲞⲨⲞϨ ⲘⲠⲀⲨϬⲈⲖ ⲀⲖⲞⲖⲒ ⲈⲂⲞⲖ ϨⲒ ⲞⲨⲂⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ⲠⲒⲀⲄⲀⲐⲞⲤ ⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲀϨⲞ ⲚⲀⲄⲀⲐⲞⲚ ⲚⲦⲈⲠⲈϤϨⲎⲦ ϢⲀϤⲒⲚⲒ ⲘⲠⲒⲀⲄⲀⲐⲞⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲒⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲀϨⲞ ⲈⲦϨⲰⲞⲨ ϢⲀϤⲒⲚⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ⲈⲂⲞⲖ ϦⲈⲚⲠϨⲞⲨⲞ ⲘⲠϨⲎⲦ ϢⲀⲢⲈ ⲠⲒⲢⲰϤ ⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ⲈⲐⲂⲈⲞⲨ ⲆⲈ ⲦⲈⲦⲈⲚⲘⲞⲨϮ ⲈⲢⲞⲒ ϪⲈ ⲠϬⲞⲒⲤ ⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲀⲚ ⲚⲚⲎ ⲈϮϪⲰ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲒ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲀⲒⲦⲞⲨ ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ϪⲈ ⲀϤⲦⲈⲚⲐⲰⲚⲦ ⲈⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ⲀⲦⲈⲚⲐⲰⲚⲦ ⲈⲞⲨⲢⲰⲘⲒ ⲈϤⲔⲰⲦ ⲚⲞⲨⲎⲒ ⲪⲎ ⲈⲦⲀϤϪⲰϪⲒ ⲞⲨⲞϨ ⲀϤϢⲰⲔⲒ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲀϤⲬⲰ ⲚⲞⲨⲤⲈⲚϮ ϨⲒϪⲈⲚ ϮⲠⲈⲦⲢⲀ ⲈⲦⲀⲨϢⲰⲠⲒ ⲆⲈ ⲚϪⲈϨⲀⲚⲘⲞⲨⲚϨⲰⲞⲨ ⲈⲨⲞϢ ⲀϤⲔⲰⲖϨ ⲚϪⲈⲠⲒⲀⲢⲞ ⲈϦⲞⲨⲚ ⲚⲤⲀⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲘⲠⲈϤϢϪⲈⲘϪⲞⲘ ⲚⲔⲒⲘ ⲈⲢⲞϤ ⲈⲐⲂⲈϪⲈ ⲚⲀϤⲔⲎⲦ ⲚⲔⲀⲖⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲦⲈⲘⲀⲒⲦⲞⲨ ⲀϤⲦⲈⲚⲐⲰⲚⲦ ⲈⲞⲨⲢⲰⲘⲒ ⲈⲀϤⲔⲰⲦ ⲚⲞⲨⲎⲒ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲬⲰⲢⲒⲤ ⲤⲈⲚϮ ⲪⲎ ⲈⲦⲀ ⲠⲒⲒⲀⲢⲞ ⲔⲰⲖϨ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤϨⲈⲒ ⲞⲨⲞϨ ⲀⲠϨⲈⲒ ⲘⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢⲞⲨⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ⲈⲦⲀϤⲞⲨⲰ ⲆⲈ ⲈϤϪⲰⲔ ⲚⲚⲈϤⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲚⲘⲀϢϪ ⲘⲠⲒⲖⲀⲞⲤ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ⲞⲨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲈϤⲘⲞⲔϨ ⲚϪⲈⲠⲈϤⲂⲰⲔ ⲚⲀϤⲚⲀⲘⲞⲨ ⲠⲈ ⲪⲎ ⲈⲦⲀϤⲦⲀⲒⲎⲞⲨⲦ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲐⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲀϤⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϨⲀⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϤϮϨⲞ ⲈⲢⲞϤ ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲒ ⲚⲦⲈϤⲦⲞⲨϪⲈ ⲠⲈϤⲂⲰⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲤⲠⲞⲨⲆⲈⲰⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲈⲘⲠϢⲀ ⲚϪⲈⲪⲎ ⲈⲦⲈⲔⲚⲀⲈⲢ ⲪⲀⲒ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ϤⲘⲈⲒ ⲄⲀⲢ ⲘⲠⲈⲚⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲐⲞϤ ⲀϤⲔⲞⲦⲤ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤⲘⲞϢⲒ ⲚⲈⲘⲰⲞⲨ ⲠⲈ ϨⲎⲆⲎ ⲆⲈ ⲈϤⲞⲨⲎⲞⲨ ⲘⲠⲒⲎⲒ ⲀⲚ ⲀϤⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϨⲀⲚϢⲪⲎⲢ ⲚϪⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲈⲢϮϦⲒⲤⲒ ⲚⲀⲔ ϮⲘⲠϢⲀ ⲄⲀⲢ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈⲔⲒ ⲈϦⲞⲨⲚ ϦⲀ ⲐⲞⲨⲀϨⲤⲞⲒ ⲘⲠⲀⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲘⲠⲒⲀⲒⲦ ⲚⲈⲘⲠϢⲀ ⲚⲒ ϢⲀⲢⲞⲔ ⲀⲖⲖⲀ ⲀϪⲞⲤ ϦⲈⲚⲠⲤⲀϪⲒ ⲞⲨⲞϨ ϤⲚⲀⲞⲨϪⲀⲒ ⲚϪⲈⲠⲀⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ⲔⲈ ⲄⲀⲢ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ϨⲰ ⲈⲨⲈⲢⲦⲀⲤⲤⲒⲚ ⲘⲘⲞϤ ϦⲀ ⲞⲨⲈⲢϢⲒϢⲒ ⲈⲞⲨⲞⲚ ϨⲀⲚⲘⲀⲦⲞⲒ ϦⲀⲢⲀⲦ ⲞⲨⲞϨ ϮϪⲰ ⲘⲘⲞⲤ ⲘⲪⲀⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ϢⲀϤϢⲈ ⲚⲀϤ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲀⲘⲞⲨ ⲞⲨⲞϨ ϢⲀϤⲒ ⲞⲨⲞϨ ⲠⲀⲂⲰⲔ ϪⲈ ⲀⲢⲒ ⲪⲀⲒ ⲞⲨⲞϨ ϢⲀϤⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲢϢⲪⲎ ⲢⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲠⲈϪⲀϤ ϪⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲆⲈ ϦⲈⲚⲠⲒⲤⲖ ⲦⲎⲢϤ ⲘⲠⲒϪⲈⲘ ⲞⲨⲚⲀϨϮ ⲚⲦⲀⲒⲘⲀⲒⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ⲞⲨⲞϨ ⲈⲦⲀⲨⲔⲞⲦⲞⲨ ⲈⲠⲒⲎⲒ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ ⲀⲨϪⲒⲘⲒ ⲘⲠⲒⲂⲰⲔ ⲈⲀϤⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲠⲈϤⲢⲀⲤϮ ⲀϤϢⲈ ⲚⲀϤ ⲈⲞⲨⲂⲀⲔⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲚⲀⲒⲚ ⲞⲨⲞϨ ⲚⲀⲨⲘⲞϢⲒ ⲚⲈⲘⲀϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ϨⲰⲤⲆⲈ ⲈⲦⲀϤϦⲰⲚⲦ ⲈϮⲠⲨⲖⲎ ⲚⲦⲈϮⲂⲀⲔⲒ ϨⲎⲠⲠⲈ ⲚⲀⲨⲰⲖⲒ ⲚⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲈⲀϤⲘⲞⲨ ⲈⲞⲨϢⲎⲢⲒ ⲘⲘⲀⲨⲀⲦϤ ⲠⲈ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲐⲀⲒ ⲚⲈⲞⲨⲬⲎⲢⲀ ⲦⲈ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲚⲦⲈϮⲂⲀⲔⲒ ⲚⲈⲘⲀⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞⲤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϢⲈⲚϨⲎ ⲦϦⲀⲢⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲘⲠⲈⲢⲢⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ⲞⲨⲞϨ ⲀϤⲒ ⲀϤϬⲒ ⲚⲈⲘ ϮⲤⲖⲎ ⲚⲎ ⲆⲈ ⲈⲦϤⲀⲒ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲠⲒϦⲈⲖϢⲒⲢⲒ ⲚⲐⲞⲔ ⲠⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲦⲰⲚⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ⲞⲨⲞϨ ⲀϤϨⲈⲘⲤⲒ ⲚϪⲈⲠⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲤⲀϪⲒ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲚⲦⲈϤⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ⲞⲨϨⲞϮ ⲆⲈ ⲀⲤϬⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚⲒϢϮ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲀϤⲦⲰⲚϤ ⲚϦⲎⲦⲈⲚ ⲞⲨⲞϨ ϪⲈ ⲀⲪⲚⲞⲨϮ ϪⲈⲘⲠϢⲒⲚⲒ ⲘⲠⲈϤⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲦⲎⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ⲞⲨⲞϨ ⲀⲨⲦⲀⲘⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲐⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ⲀϤⲞⲨⲞⲢⲠⲞⲨ ϨⲀ ⲠϬⲞⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲐⲚⲎⲞⲨ ϢⲀⲚ ⲚⲦⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲚⲔⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ⲈⲦⲀⲨⲒ ⲆⲈ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲀϤⲞⲨⲞⲢⲠⲦⲈⲚ ϨⲀⲢⲞⲔ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ϢⲀⲚ ⲚⲦⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲚⲔⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ϦⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈϨⲀⲚⲘⲎϢ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϢⲰⲚⲒ ⲚⲈⲘ ϨⲀⲚⲘⲀⲤⲦⲒⲄⲄⲞⲤ ⲚⲈⲘ ϨⲀⲚⲠⲚⲈⲨⲘⲀⲈⲨϨⲰⲞⲨ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲘⲂⲈⲖⲖⲈ ⲀϤⲈⲢϨⲘⲞⲦ ⲚⲰⲞⲨ ⲘⲠⲒⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲦⲀⲘⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲞⲐⲘⲞⲨ ⲚⲒⲂⲈⲖⲖⲈⲨ ⲤⲈⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲒϬⲀⲖⲈⲨ ⲤⲈⲘⲞϢⲒ ⲚⲒⲔⲀⲔⲤⲈϨⲦ ⲤⲈⲦⲞⲨⲂⲎⲞⲨⲦ ⲚⲒⲔⲞⲨⲢ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲤⲈⲦⲰⲞⲨⲚⲞⲨ ⲚⲒϨⲎⲔⲒ ⲤⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ⲞⲨⲞϨ ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲪⲎ ⲈⲦⲈⲚϤⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲀⲚ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲆⲈ ⲚϪⲈⲚⲒⲢⲈⲘⲚϨⲰⲂ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚⲚⲒⲘⲎϢ ⲈⲐⲂⲈ ⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲠϢⲀϤⲈ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲞⲨⲔⲀϢ ⲈⲨⲔⲒⲘ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲐⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ⲀⲖⲖⲀ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲞⲨⲢⲰⲘⲒ ⲈⲞⲨⲞⲚ ϨⲀⲚϨⲈⲂⲤⲰ ⲈⲨϪⲎⲚ ⲦⲞⲒ ϨⲒⲰⲦϤ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲀ ⲚⲒϨⲂⲰⲤ ⲚⲦⲈⲠⲰⲞⲨ ⲚⲈⲘ ⲠⲞⲨⲚⲞϤ ⲤⲈⲬⲎ ϦⲈⲚⲠⲎⲒ ⲚⲚⲒⲞⲨⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ⲀⲖⲖⲀ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲞⲨ ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲀϨⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨϨⲞⲨⲞ ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦϤ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲞⲨⲞⲢⲠ ⲘⲠⲀⲄⲄⲈⲖⲞⲤ ϦⲀⲦϨⲎ ⲘⲠⲈⲔϨⲞ ⲪⲎ ⲈⲐⲚⲀⲤⲞⲂϮ ⲘⲠⲈⲔⲘⲰⲒⲦ ⲘⲠⲈⲔⲘⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϦⲈⲚⲠϪⲒⲚⲘⲒⲤⲒ ⲚⲦⲈⲚⲒϨⲒⲞⲘⲒ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲀϤ ⲈⲒⲰⲀⲚⲚⲎ ⲤⲠⲒⲔⲞⲨϪⲒ ⲆⲈ ⲈⲢⲞϤ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲚⲒϢϮ ⲈⲢⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ⲞⲨⲞϨ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲈⲘ ⲚⲒⲦⲈⲖⲰⲚⲎ ⲤⲀⲨⲐⲘⲀⲒⲈ ⲪⲚⲞⲨϮ ⲈⲦⲀⲨϬⲒⲰⲘⲤ ϦⲈⲚⲠⲒⲰⲘⲤ ⲚⲒⲰⲀⲚⲚⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲚⲞⲘⲒⲔⲞⲤ ⲀⲨⲈⲢⲀⲐⲈⲦⲒⲚ ⲘⲠⲒⲤⲞϬⲚⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲘⲠⲞⲨϬⲒⲰⲘⲤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ⲀⲒⲚⲀⲦⲈⲚⲐⲰⲚⲦ ⲈⲚⲒⲢⲰⲘⲒ ⲚⲦⲈⲠⲀⲒϪⲰⲞⲨ ⲈⲞⲨ ⲞⲨⲞϨ ⲞⲨ ⲠⲈ ⲈⲦⲞⲨⲞⲚⲒ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ⲤⲈⲞⲚⲒ ⲚϨⲀⲚⲀⲖⲰⲞⲨⲒ ⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ϦⲈⲚⲞⲨⲀⲄⲞⲢⲀ ⲞⲨⲞϨ ⲈⲨⲘⲞⲨϮ ⲞⲨⲂⲈ ⲚⲞⲨⲈⲢⲎ ⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲰ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚϬⲞⲤϪⲈⲤ ⲀⲚⲈⲢϨⲎⲂⲒ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲢⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ⲀϤⲒ ⲄⲀⲢ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ⲈϤⲞⲨⲈⲘ ⲰⲒⲔ ⲀⲚ ⲞⲨⲞϨ ⲚϤⲤⲈ ⲎⲢⲠ ⲀⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲈϤⲤⲰ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲤⲀⲨⲎⲢⲠ ⲈϤⲞⲒ ⲚϢⲪⲎⲢ ⲈⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ⲞⲨⲞϨ ⲀⲤⲐⲘⲀⲒⲞ ⲚϪⲈϮⲤⲞⲪⲒⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲤϢⲎⲢⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲰⲘ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀϤⲢⲰⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲤϨⲒⲘⲒ ⲚⲀⲤⲞⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ϦⲈⲚϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲈⲦⲀⲤⲈⲘⲒ ϪⲈ ϤⲢⲞⲦⲈⲂ ϦⲈⲚⲠⲎⲒ ⲘⲠⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲤϬⲒ ⲚⲞⲨⲀⲖⲀⲂⲀⲤⲦⲢⲞⲚ ⲚⲤⲞϪⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ⲞⲨⲞϨ ⲈⲦⲀⲤⲞϨⲒ ⲈⲢⲀⲦⲤ ⲤⲀⲪⲀϨⲞⲨ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲈⲤⲢⲒⲘⲒ ⲀⲤⲈⲢϨⲎⲦⲤ ⲚϨⲰⲢⲠ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ϦⲈⲚⲚⲈⲤⲈⲢⲘⲰⲞⲨⲒ ⲞⲨⲞϨ ⲀⲤϤⲞⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϤⲰⲒ ⲚⲦⲈⲦⲈⲤⲀⲪⲈ ⲞⲨⲞϨ ⲚⲀⲤϮⲪⲒ ⲈⲚⲈϤϬⲀⲖⲀⲨϪ ⲈⲤⲐⲰϨⲤ ⲘⲘⲰⲞⲨ ⲘⲠⲒⲤⲞϪⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲠⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲦⲀϤⲐⲀϨⲘⲈϤ ⲠⲈϪⲀϤ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ⲪⲀⲒ ⲚⲀϤⲚⲀⲈⲘⲒ ϪⲈ ⲞⲨ ⲦⲈ ⲞⲨⲞϨ ϪⲈ ⲞⲨ ⲀϢ ⲚⲢⲎϮ ⲦⲈ ⲦⲀⲒⲤϨⲒⲘⲒ ⲈⲦⲀⲤϬⲒ ⲚⲈⲘⲀϤ ϪⲈ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲚⲞⲨⲤⲀϪⲒ ⲈϪⲞϤ ⲚⲀⲔ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲀϪⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲬⲢⲈⲰⲤⲦⲎⲤ ⲂⲈⲞⲨⲞⲚⲦⲈ ⲞⲨⲆⲀⲚⲒⲤⲦⲎⲤ ⲈⲢⲰⲞⲨ ⲠⲒⲞⲨⲀⲒ ⲚⲈⲞⲨⲞⲚ ⲪⲚⲤⲀⲐⲈⲢⲒ ⲈⲢⲞϤ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲚⲈⲞⲨⲞⲚ ⲚⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ⲘⲘⲞⲚ ⲚⲦⲰⲞⲨ ⲆⲈ ⲘⲘⲀⲨ ⲈⲐⲢⲞⲨⲦⲞⲂⲞⲨ ⲀϤⲬⲀⲨ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲘⲠⲂ ⲚϨⲘⲞⲦ ⲚⲒⲘ ⲞⲨⲚ ⲚϦⲎⲦⲞⲨ ⲈⲐⲚⲀⲘⲈⲚⲢⲒⲦϤ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈϪⲀϤ ϪⲈ ϮⲘⲈⲨⲒ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲬⲀ ⲠⲒϨⲞⲨⲞ ⲚⲀϤ ⲈⲂⲞⲖ ⲚϨⲘⲞⲦ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲔϮϨⲀⲠ ϦⲈⲚⲞⲨⲤⲰⲞⲨⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲈϮⲤϨⲒⲘⲒ ⲠⲈϪⲀϤ ⲚⲤⲒⲘⲰⲚ ϪⲈ ⲬⲚⲀⲨ ⲈⲦⲀⲒⲤϨⲒⲘⲒ ⲀⲒⲒ ⲈϦⲞⲨⲚ ⲈⲠⲈⲔⲎⲒ ⲘⲠⲈⲔϮ ⲚⲞⲨⲘⲰⲞⲨ ⲈⲚⲀϬⲀⲖⲀⲨϪ ⲐⲀⲒ ⲆⲈ ⲚⲐⲞⲤ ⲀⲤϨⲰⲢⲠ ⲚⲚⲀϬⲀⲖⲀⲨϪ ϦⲈⲚⲚⲈⲤⲈⲢⲘⲰⲞⲨⲒ ⲞⲨⲞϨ ⲀⲤϤⲞⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲤϤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ⲘⲠⲈⲔϮ ⲚⲞⲨⲪⲒ ⲈⲢⲰⲒ ⲐⲀⲒ ⲆⲈ ⲚⲐⲞⲤ ⲒⲤϪⲈⲚ ⲈⲦⲀⲒⲒ ⲈϦⲞⲨⲚ ⲘⲠⲈⲤⲬⲀⲦⲞⲦⲤ ⲈⲂⲞⲖ ⲈⲤϮⲪⲒ ⲈⲚⲀϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ⲘⲠⲈⲔⲐⲰϨⲤ ⲚⲦⲀⲀⲪⲈ ⲚⲞⲨⲚⲈϨ ⲐⲀⲒ ⲆⲈ ⲚⲐⲞⲤ ⲀⲤⲐⲰϨⲤ ⲚⲚⲀϬⲀⲖⲀⲨϪ ⲚⲞⲨⲤⲞϪⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ⲈⲐⲂⲈⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲈⲤⲚⲞⲂⲒ ⲈⲦⲞϢ ⲤⲈⲬⲎ ⲚⲀⲤ ⲈⲂⲞⲖ ϪⲈ ⲀⲤⲈⲢⲀⲄⲀⲠⲀⲚ ⲈⲘⲀϢⲰ ⲪⲎ ⲄⲀⲢ ⲈϢⲀⲨⲬⲀ ⲞⲨⲔⲞⲨϪⲒ ⲚⲀϤ ⲈⲂⲞⲖ ϢⲀϤⲈⲢⲀⲄⲀⲠⲀⲚ ⲚⲞⲨⲔⲞⲨϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀⲤ ϪⲈ ⲚⲈⲚⲞⲂⲒ ⲤⲈⲬⲎ ⲚⲈⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲚϪⲈⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲪⲀⲒ ⲈⲦⲈⲢ ⲠⲔⲈⲬⲀⲚⲞⲂⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ⲠⲈϪⲀϤ ⲆⲈ ⲚϮⲤϨⲒⲘⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲈϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲠⲈⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤⲘⲞϢⲒ ⲔⲀⲦⲀ ⲂⲀⲔⲒ ⲚⲈⲘ ϮⲘⲒ ⲈϤϨⲒⲰⲒϢ ⲞⲨⲞϨ ⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲠⲒⲒⲂ ⲈⲨⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ⲚⲈⲘ ϨⲀⲚⲔⲈϨⲒⲞⲘⲒ ⲚⲎ ⲈⲦⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲠⲚⲈⲨⲘⲀⲈⲨϨⲰⲞⲨ ⲚⲈⲘ ϨⲀⲚϢⲰⲚⲒ ⲘⲀⲢⲒⲀ ⲐⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲐⲎ ⲈⲦⲀϤϨⲒ ⲠⲒⲌ ⲚⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϨⲒⲰⲦⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ⲚⲈⲘ ⲒⲰⲀⲚⲚⲀ ⲦⲤϨⲒⲘⲒ ⲚⲬⲞⲨⲌⲀ ⲠⲒⲈⲠⲒⲦⲢⲞⲠⲞⲤ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ ⲚⲈⲘ ⲤⲞⲨⲤⲀⲚⲚⲀ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲨⲞϢ ⲚⲎ ⲈⲚⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ⲈϤⲐⲞⲨⲎⲦ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲚⲈⲘ ⲚⲎ ⲈⲚⲀⲨⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲔⲀⲦⲀ ⲂⲀⲔⲒ ⲠⲈϪⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲤⲒϮ ⲈⲤⲒϮ ⲘⲠⲈϤϪⲢⲞϪ ⲞⲨⲞϨ ϦⲈⲚⲠϪⲒⲚⲐⲢⲈϤⲤⲒϮ ⲞⲨⲀⲒ ⲘⲈⲚ ⲀϤϨⲈⲒ ϦⲀⲦⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲀⲨϨⲈⲘϨⲰⲘϤ ⲞⲨⲞϨ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲀⲨⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲞⲨⲠⲈⲦⲢⲀ ⲞⲨⲞϨ ⲀϤⲢⲰⲦ ⲀϤϢⲰⲞⲨⲒ ⲈⲐⲂⲈϪⲈ ⲘⲘⲞⲚⲦⲈϤ ϬⲚⲞⲚⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲀϤϨⲈⲒ ϦⲈⲚⲐⲘⲎϮ ⲚⲚⲒⲤⲞⲨⲢⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲢⲰⲦ ⲚⲈⲘⲀϤ ⲚϪⲈⲚⲒⲤⲞⲨⲢⲒ ⲀⲨⲞϪϨϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲢⲰⲦ ⲀϤⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ⲚⲢ ⲚⲔⲰⲂ ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲚⲀϤⲘⲞⲨϮ ⲠⲈ ϪⲈ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ⲚⲀⲨϢⲒⲚⲒ ⲆⲈ ⲘⲘⲞϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲞⲨ ⲦⲈ ⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲤⲦⲞⲒ ⲚⲰⲦⲈⲚ ⲈⲈⲘⲒ ⲈⲚⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲤⲰϪⲠ ⲆⲈ ϦⲈⲚϨⲀⲚⲠⲀⲢⲀⲂⲞⲖⲎ ϨⲒⲚⲀ ⲈⲨⲚⲀⲨ ⲚⲦⲞⲨϢⲦⲈⲘⲚⲀⲨ ⲞⲨⲞϨ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲦⲞⲨϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ϮⲠⲀⲢⲀⲂⲞⲖⲎ ⲆⲈ ⲐⲀⲒ ⲦⲈ ⲠⲒϪⲢⲞϪ ⲠⲈ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ⲚⲎ ⲆⲈ ⲈⲦϦⲀⲦⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲚⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲒⲦⲀ ϢⲀϤⲒ ⲚϪⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲞⲨⲞϨ ϢⲀϤⲰⲖⲒ ⲘⲠⲒⲤⲀϪⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨϨⲎ ⲦϨⲒⲚⲀ ⲘⲎⲠⲰⲤ ⲚⲤⲈⲚⲀϨϮ ⲞⲨⲞϨ ⲚⲤⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ⲚⲎ ⲆⲈ ⲈⲦϨⲒϪⲈⲚ ϮⲠⲈⲦⲢⲀ ⲚⲈⲚⲎ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲤⲰⲦⲈⲘ ϢⲀⲨϢⲈⲠ ⲠⲒⲤⲀϪⲒ ⲈⲢⲰⲞⲨ ϦⲈⲚⲞⲨⲢⲀϢⲒ ⲞⲨⲞϨ ⲚⲀⲒ ⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲨⲚⲒ ⲘⲘⲀⲨ ⲚⲎ ⲈⲐⲚⲀϨϮ ⲠⲢⲞⲤ ⲞⲨⲤⲎⲞⲨ ⲞⲨⲞϨ ϦⲈⲚⲠⲤⲎⲞⲨ ⲚⲞⲨⲠⲒⲢⲀⲤⲘⲞⲤ ϢⲀⲨⲬⲀⲦⲞⲦⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ⲪⲎ ⲆⲈ ⲈⲦⲀϤϨⲈⲒ ϦⲈⲚⲚⲒⲤⲞⲨⲢⲒ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲒⲢⲰⲞⲨϢ ⲚⲈⲘ ⲚⲒⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲈⲘ ⲚⲒϨⲨⲆⲞⲚⲎ ⲚⲦⲈⲠⲀⲒϪⲒⲚⲰⲚϦ ⲈⲨⲘⲞϢⲒ ⲚϦⲎⲦⲞⲨ ϢⲀⲨⲞϪϨⲞⲨ ⲞⲨⲞϨ ⲘⲠⲀⲨⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ⲪⲎ ⲆⲈ ⲈⲦⲀϤϨⲈⲒ ϦⲈⲚⲠⲒⲔⲀϨⲒ ⲈⲐⲚⲀⲚⲈϤ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ϦⲈⲚⲞⲨϨⲎⲦ ⲈⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲚⲀⲄⲀⲐⲞⲚ ⲈⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ϢⲀⲨⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲨⲠⲞⲘⲞⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ⲘⲠⲀⲢⲈ ϨⲖⲒ ϬⲈⲢⲈ ⲞⲨϦⲎⲂⲤ ⲚⲦⲈϤϨⲞⲂⲤϤ ϦⲈⲚⲞⲨⲤⲔⲈⲨⲞⲤ ⲒⲈ ⲚⲦⲈϤⲬⲀϤ ⲤⲀⲈϦⲢⲎ ⲒⲚⲞⲨϬⲖⲞϪ ⲀⲖⲖⲀ ⲈϢⲀⲨⲬⲀϤ ϨⲒϪⲈⲚ ⲞⲨⲖⲨⲬⲚⲒⲀ ϨⲒⲚⲀ ⲚⲎ ⲈⲐⲚⲀⲒ ⲈϦⲞⲨⲚ ⲚⲦⲞⲨⲚⲀⲨ ⲈⲠⲒⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ⲘⲘⲞⲚ ⲠⲈⲦϨⲎⲠ ⲄⲀⲢ ϪⲈ ϤⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲀⲚ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲠⲈⲦⲬⲎⲠ ϪⲈ ⲤⲈⲚⲀⲈⲘⲒ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲞϨ ⲚⲦⲈϤⲒ ⲈⲐⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ⲀⲚⲀⲨ ⲞⲨⲚ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲚⲀϢ ⲚⲢⲎϮ ⲪⲎ ⲄⲀⲢ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲈⲨⲈϮ ⲚⲀϤ ⲞⲨⲞϨ ⲈⲦⲈⲘⲘⲞⲚ ⲚⲦⲀϤ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲈⲦⲈϤⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ϤⲈⲚⲦⲞⲦϤ ⲈⲨⲈⲞⲖϤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ⲀⲤⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨϢϪⲈⲘϪⲞⲘ ⲀⲚ ⲠⲈ ⲈϮⲘⲀϮ ⲈⲢⲞϤ ⲈⲐⲂⲈ ⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ⲀⲨⲦⲀⲘⲞϤ ⲆⲈ ϪⲈ ⲒⲤ ⲦⲈⲔⲘⲀⲨ ⲚⲈⲘ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲤⲈⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲈⲨⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲀⲘⲀⲨ ⲚⲈⲘ ⲚⲀⲤⲚⲎⲞⲨ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲦⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲞⲨⲀⲒ ⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲐⲞϤ ⲀϤⲀⲖⲎⲒ ⲈⲞⲨϪⲞⲒ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀⲢⲈⲚϢⲈ ⲚⲀⲚ ⲈⲘⲎⲢ ⲈϮⲖⲨⲘⲚⲎ ⲞⲨⲞϨ ⲀⲨⲤⲰⲔ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ⲈⲨⲈⲢϨⲰⲦ ⲆⲈ ⲈϤⲈⲚⲔⲞⲦ ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲢⲎⲒ ⲈϮⲖⲨⲘⲚⲎ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲐⲎⲞⲨ ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲈⲢⲰⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲔⲒⲚⲆⲨⲚⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ⲈⲦⲀⲨⲒ ⲆⲈ ⲀⲨⲚⲈϨⲤⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲦⲈⲚⲚⲀⲦⲀⲔⲞ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲦⲰⲚϤ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲒⲐⲎⲞⲨ ⲚⲈⲘ ⲚⲒϨⲰⲒⲘⲒ ⲚⲦⲈⲠⲒⲘⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨϨⲈⲢⲒ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϪⲀⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀϤⲐⲰⲚ ⲠⲈⲦⲈⲚⲚⲀϨϮ ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲈⲢϨⲞϮ ⲀⲨⲈⲢϢⲪⲎ ⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲠⲈ ⲪⲀⲒ ϪⲈ ϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲚⲒⲔⲈⲐⲎⲞⲨ ⲚⲈⲘ ⲚⲒⲘⲰⲞⲨ ⲞⲨⲞϨ ⲤⲈⲤⲰⲦⲈⲘ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲰⲦ ⲈⲦⲬⲰⲢⲀ ⲚⲦⲈⲚⲒⲄⲈⲢⲄⲈⲤⲎ ⲚⲞⲤ ⲈⲦⲈ ⲐⲎ ⲦⲈ ⲈⲦϨⲒⲘⲎⲢ ⲞⲨⲂⲈ ϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲈⲠⲒⲔⲀϨⲒ ⲀϤⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲂⲀⲔⲒ ⲈⲞⲨⲞⲚ ϨⲀⲚⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲈⲀϤⲈⲢⲞⲨⲚⲒϢϮ ⲚⲬⲢⲞⲚⲞⲤ ⲘⲠⲈϤϮϨⲂⲞⲤ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲘⲠⲈϤϢⲰⲠⲒ ϦⲈⲚⲎⲒ ⲀⲖⲖⲀ ϦⲈⲚⲚⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲀϤϨⲒⲦϤ ⲈϦⲢⲎⲒ ϦⲀⲢⲀⲦϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲀϦⲞⲔ ⲚⲈⲘⲎⲒ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ ϮϮϨⲞ ⲈⲢⲞⲔ ⲘⲠⲈⲢϮⲘⲔⲀϨ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ⲚⲈ ⲀϤϨⲞⲚϨⲈⲚ ⲄⲀⲢ ⲠⲈ ⲈⲦⲞⲦϤ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲰⲘⲒ ⲚⲈⲀϤϨⲞⲖⲘⲈϤ ⲄⲀⲢ ⲠⲈ ⲚϨⲀⲚⲘⲎϢ ⲚⲬⲢⲞⲚⲞⲤ ⲞⲨⲞϨ ⲚⲈϢⲀⲨⲤⲞⲚϨϤ ⲠⲈ ⲚϨⲀⲚϨⲀⲖⲨⲤⲒⲤ ⲚⲈⲘ ϨⲀⲚⲠⲈⲆⲎⲤ ⲈⲨⲀⲢⲈϨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲈϢⲀϤⲤⲰⲖⲠ ⲚⲚⲒⲤⲚⲀⲨϨ ⲠⲈ ⲚⲦⲈϤϬⲰⲢⲈⲘ ⲚⲤⲰϤ ⲚϪⲈⲠⲒⲆⲈⲘⲰⲚ ⲈⲚⲒϢⲀϤⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ⲀϤϢⲈⲚϤ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲈⲔⲢⲀⲚ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲖⲈⲄⲒⲰⲚ ϪⲈ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲘⲎϢ ⲚⲆⲈⲘⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲞⲨ ⲈϢⲈ ⲈⲪⲚⲞⲨⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲞϨⲒ ⲆⲈ ⲚⲢⲒⲢ ⲘⲘⲀⲨ ⲈⲨⲘⲞⲚⲒ ϦⲈⲚⲠⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲬⲀⲨ ⲈϢⲈ ⲈϦⲞⲨⲚ ⲈⲚⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀϤⲬⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲢⲰⲘⲒ ⲚϪⲈⲚⲒⲆⲈⲘⲰⲚ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲈϢⲀⲨ ⲞⲨⲞϨ ⲀⲤⲒ ⲚϪⲈϮⲀⲄⲈⲖⲎ ⲚⲢⲒⲢ ⲈϦⲢⲎⲒ ⲈϮⲖⲨⲘⲚⲎ ϦⲈⲚⲠⲒϪⲀϪⲢⲒⲘ ⲞⲨⲞϨ ⲀⲨⲰϪϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲎ ⲈⲐⲘⲞⲚⲒ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲀⲨⲪⲰⲦ ⲞⲨⲞϨ ⲀⲨⲦⲀⲘⲈ ⲚⲎ ⲈⲦϦⲈⲚ ϮⲂⲀⲔⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϦⲈⲚ ⲦⲔⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ⲀⲨⲒ ⲈⲂⲞⲖ ⲈⲚⲀⲨ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨϪⲒⲘⲒ ⲘⲠⲒⲢⲰⲘⲒ ⲈϤϨⲈⲘⲤⲒ ⲪⲎ ⲈⲦⲀ ⲚⲒⲆⲈⲘⲰⲚ ⲒⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲈϤⲞⲒ ⲚⲤⲀⲂⲈ ⲈⲢⲈ ⲚⲈϤϨⲂⲰⲤ ⲦⲞⲒ ϨⲒⲰⲦϤ ⲈϤⲬⲎ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ⲀⲨⲦⲀⲘⲰⲞⲨ ⲆⲈ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲚⲀⲨ ϪⲈ ⲈⲦⲀϤⲚⲞϨⲈⲘ ⲚⲀϢ ⲚⲢⲎϮ ⲚϪⲈⲪⲎ ⲈⲚⲀⲢⲈ ⲚⲒⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ⲞⲨⲞϨ ⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲚⲦⲈϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ⲚⲦⲈⲚⲒⲄⲈⲢⲄⲈⲤⲎⲚⲞⲤ ϪⲈ ⲚⲦⲈϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ ϪⲈ ⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ⲠⲈ ⲈⲚⲀⲨⲬⲎ ⲚϦⲎⲦⲤ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲀⲖⲎⲒ ⲈⲠϪⲞⲒ ⲀϤⲦⲀⲤⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲪⲎ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲚϪⲈⲚⲒⲆⲈⲘⲰⲚ ϨⲒⲚⲀ ⲚⲦⲈϤⲞϨⲒ ⲚⲈⲘⲀϤ ⲀϤⲞⲨⲞⲢⲠϤ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ϪⲈ ⲘⲀⲦⲀⲤⲐⲞ ⲈⲠⲈⲔⲎⲒ ⲞⲨⲞϨ ⲤⲀϪⲒ ⲚⲚⲎ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚⲈⲘⲀⲔ ⲚϪⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲂⲀⲔⲒ ⲦⲎⲢⲤ ⲈϤϨⲒⲰⲒϢ ⲚⲚⲎ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚⲀϤ ⲚϪⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ⲈⲦⲀϤⲦⲀⲤⲐⲞ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϢⲞⲠϤ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲘⲎϢ ⲚⲀⲨϪⲞⲨϢⲦ ⲄⲀⲢ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲀϤⲒ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲀⲒⲢⲞⲤ ⲞⲨⲞϨ ⲪⲀⲒ ⲚⲈⲞⲨⲀⲢⲬ ⲰⲚ ⲠⲈ ⲚⲦⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲦϤ ⲈϦⲢⲎⲒ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲒⲎⲤⲞⲨⲤ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲈⲐⲢⲈϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ϪⲈ ⲞⲨϢⲈⲢⲒ ⲘⲘⲀⲨⲀⲦⲤ ⲈⲚⲀⲤⲚⲦⲀϤ ⲠⲈ ⲈⲤϦⲈⲚ ⲒⲂ ⲚⲢⲞⲘⲠⲒ ⲞⲨⲞϨ ⲐⲀⲒ ⲚⲀⲤⲚⲀⲘⲞⲨ ⲠⲈ ⲈϤⲚⲀⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨϨⲞϪϨⲈϪ ⲘⲘⲞϤ ⲠⲈ ⲚϪⲈⲚⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ⲞⲨⲞϨ ⲞⲨⲤϨⲒⲘⲒ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲤⲚⲞϤ ⲬⲎ ϦⲀⲢⲞⲤ ⲘⲒⲂ ⲚⲢⲞⲘⲠⲒ ⲐⲀⲒ ⲈⲦⲀⲤϬⲞ ⲘⲠⲈⲤⲰⲚϦ ⲦⲎⲢϤ ⲈⲂⲞⲖ ⲚⲚⲒⲤⲎⲒⲚⲒ ⲞⲨⲞϨ ⲘⲠⲈⲤϢϪⲈⲘϪⲞⲘ ⲈⲐⲢⲞⲨⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ⲈⲦⲀⲤⲒ ⲈⲂⲞⲖ ϨⲒⲪⲀϨⲞⲨ ⲀⲤϬⲒ ⲚⲈⲘ ⲠϢⲦⲀϮ ⲚⲦⲈⲠⲈϤϨⲂⲞⲤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲞϨⲒ ⲚϪⲈⲠⲒⲤⲚⲞϤ ⲈⲚⲀϤϢⲀⲦ ⲈⲂⲞⲖ ϦⲀⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϬⲒ ⲚⲈⲘⲎⲒ ⲈⲨϪⲰⲖ ⲆⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲒⲘⲎϢ ⲈⲦⲔⲰϮ ⲈⲢⲞⲔ ⲞⲨⲞϨ ⲈⲦϨⲞϪϨⲈϪ ⲘⲘⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲞⲚ ⲠⲈⲦⲀϤϬⲒ ⲚⲈⲘⲎⲒ ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒⲈⲘⲒ ⲈⲞⲨϪⲞⲘ ⲀⲤⲒ ⲈⲂⲞⲖ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ⲈⲦⲀⲤⲚⲀⲨ ⲆⲈ ⲚϪⲈϮⲤϨⲒⲘⲒ ϪⲈ ⲘⲠⲈϤⲈⲢⲠⲰⲂϢ ⲀⲤⲒ ⲈⲤⲤⲐⲈⲢⲦⲈⲢ ⲞⲨⲞϨ ⲈⲦⲀⲤϨⲒⲦⲤ ⲈϦⲢⲎⲒ ϦⲀⲢⲀⲦϤ ⲀⲤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲈⲦⲒⲀ ⲀⲤϬⲒ ⲚⲈⲘⲀϤ ⲚⲈⲘ ⲠⲒⲢⲎϮ ⲈⲦⲀⲤⲞⲨϪⲀⲒ ⲘⲘⲞϤ ⲤⲀⲦⲞⲦⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ⲚⲐⲞϤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲦⲀϢⲈⲢⲒ ⲠⲈⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲒ ⲘⲀϢⲈ ⲚⲈϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ⲀϤⲒ ⲚϪⲈⲞⲨⲀⲒ ⲚⲦⲈⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲤⲘⲞⲨ ⲚϪⲈⲦⲈⲔϢⲈⲢⲒ ⲘⲠⲈⲢϮϦⲒⲤⲒ ⲘⲠⲒⲢⲈϤϮⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲘⲞⲚⲞⲚ ⲚⲀϨϮ ⲞⲨⲞϨ ⲤⲚⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲠⲒⲎⲒ ⲘⲠⲈϤⲬⲀ ϨⲖⲒ ⲈⲒ ⲈϦⲞⲨⲚ ⲚⲈⲘⲀϤ ⲈⲂⲎⲖ ⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘ ⲪⲒⲰⲦ ⲚϮⲀⲖⲞⲨ ⲚⲈⲘ ⲦⲈⲤⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ⲚⲀⲨⲢⲒⲘⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲚⲈϨⲠⲒ ⲈⲢⲞⲤ ⲠⲈ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲈⲢⲢⲒⲘⲒ ⲘⲠⲈⲤⲘⲞⲨ ⲄⲀⲢ ⲚϪⲈϮⲀⲖⲞⲨ ⲀⲖⲖⲀ ⲀⲤⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ⲞⲨⲞϨ ⲚⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲠⲈ ⲈⲨⲈⲘⲒ ϪⲈ ⲀⲤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤϨⲒⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲀⲘⲞⲚⲒ ⲚⲦⲈⲤϪⲒϪ ⲀϤⲘⲞⲨϮ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲀⲖⲞⲨ ⲦⲰⲞⲨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ⲞⲨⲞϨ ⲀϤⲔⲞⲦϤ ⲈⲢⲞⲤ ⲚϪⲈⲠⲈⲤⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲤ ⲀⲤⲦⲰⲚⲤ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲦⲞⲨϮ ⲚⲀⲤ ⲈⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ⲞⲨⲞϨ ⲀⲨⲦⲰⲘⲦ ⲚϪⲈⲚⲈⲤⲒⲞϮ ⲚⲐⲞϤ ⲆⲈ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϢⲦⲈⲘϪⲈ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲚϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ⲈⲦⲀϤⲘⲞⲨϮ ⲆⲈ ⲈⲠⲒⲒⲂ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀϤϮϪⲞⲘ ⲚⲰⲞⲨ ⲚⲈⲘ ⲞⲨⲈⲢϢⲒϢⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲒⲆⲈⲘⲰⲚ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϢⲰⲚⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲈϨⲒⲰⲒϢ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲦⲀⲖϬⲞ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲈⲖ ϨⲖⲒ ⲈⲪⲘⲰⲒⲦ ⲞⲨⲆⲈ ϢⲂⲰⲦ ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲞⲨⲆⲈ ⲰⲒⲔ ⲞⲨⲆⲈ ϨⲀⲦ ⲞⲨⲆⲈ ⲘⲠⲈⲢⲬⲀ ϢⲐⲎⲚ ⲤⲚⲞⲨϮ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ⲞⲨⲞϨ ⲠⲒⲎⲒ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ϢⲰⲠⲒ ⲘⲘⲀⲨ ϢⲀⲦⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲚⲤⲈⲚⲀϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲰⲞⲨ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈϨ ⲠϢⲰⲒϢ ⲚⲚⲈⲦⲈⲚϬⲀⲖⲀⲨϪ ⲈⲂⲞⲖ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ⲈⲨⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲀⲨⲘⲞϢⲦ ⲠⲈ ⲔⲀⲦⲀ ϮⲘⲒ ⲈⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲞⲨⲞϨ ⲈⲨⲈⲢⲪⲀϦⲢⲒ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ⲀϤⲤⲰⲦⲈⲘ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲠⲒⲦⲈⲦⲢⲀⲀⲢⲬⲎ ⲤⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲚⲀⲨϢⲞⲠ ⲞⲨⲞϨ ⲚⲀϤⲞⲒ ⲚϢⲖⲀϨ ⲚϨⲎⲦ ⲈⲐⲂⲈϪⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲎⲖⲒⲀⲤ ⲠⲈⲦⲀϤⲞⲨⲞⲚϨϤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲦⲈⲚⲒⲀⲢⲬⲈⲞⲤ ⲠⲈⲦⲀϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ⲠⲈϪⲈ ⲎⲢⲰⲆⲎⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲀⲚⲞⲔ ⲀⲒⲈⲖ ⲦⲈϤⲚⲀϨⲂⲒ ⲚⲒⲘ ⲆⲈ ⲠⲈ ⲪⲀⲒ ⲈϮⲤⲰⲦⲈⲘ ⲈⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲚⲤⲀⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲀⲤⲐⲞ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨⲤⲀϪⲒ ϦⲀⲦⲞⲦϤ ⲚⲚⲎ ⲈⲦⲀⲨⲀⲒⲦⲞⲨ ⲞⲨⲞϨ ⲀϤⲞⲖⲞⲨ ⲚⲈⲘⲀϤ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦϤ ⲈⲞⲨⲂⲀⲔⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲂⲎⲐⲤⲀⲒⲆⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ⲚⲒⲘⲎϢ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲞⲠⲞⲨ ⲈⲢⲞϤ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲢⲬⲢⲒⲀ ⲚⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲚⲀϤⲦⲀⲖϬⲞ ⲘⲘⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲚⲀϤⲈⲢϨⲎⲦⲤ ⲚⲢⲒⲔⲒ ⲠⲈ ⲈⲦⲀϤⲒ ⲆⲈ ϨⲀⲢⲞϤ ⲚϪⲈⲠⲒⲒⲂ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲬⲀ ⲚⲒⲘⲎϢ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲈ ⲚⲰⲞⲨ ⲈⲚⲒϮⲘⲒ ⲈⲦⲈ ⲘⲠⲔⲰϮ ⲚⲈⲘ ⲚⲒⲒⲞϨⲒ ⲚⲦⲞⲨⲘⲦⲞⲚ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲞⲨϪⲈⲘ ⲪⲎ ⲈⲦⲞⲨⲚⲀⲞⲨⲞⲘϤ ϪⲈ ⲦⲈⲚⲬⲎ ⲘⲠⲀⲒⲘⲀ ϦⲈⲚⲞⲨⲘⲀ ⲚϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲘⲞⲒ ⲚⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲈⲐⲢⲞⲨⲞⲨⲰⲘ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲘⲘⲞⲚ ϨⲞⲨⲞ ⲈⲈ ⲚⲰⲒⲔ ⲚⲦⲞⲦⲈⲚ ⲚⲈⲘ ⲦⲈⲂⲦ ⲂⲈⲂⲎⲖ ⲀⲚⲞⲚ ⲚⲦⲈⲚϢⲈ ⲚⲀⲚ ⲚⲦⲈⲚϢⲰⲠ ⲚϨⲀⲚϦⲢⲎⲞⲨⲒ ⲘⲠⲀⲒⲖⲀⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ⲚⲀⲨⲞⲒ ⲆⲈ ⲚⲀⲨ ⲈⲚϢⲞ ⲚⲢⲰⲘⲒ ⲀϤϪⲞⲤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲘⲀⲢⲞⲨⲢⲰⲦⲈⲂ ⲔⲀⲦⲀ ⲘⲀ ⲚϨⲀⲚⲚ ⲈⲪⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ⲞⲨⲞϨ ⲀⲨⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ ⲀϤⲐⲢⲞⲨⲢⲰⲦⲈⲂ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ⲈⲦⲀϤϬⲒ ⲆⲈ ⲘⲠⲒⲈ ⲚⲰⲒⲔ ⲚⲈⲘ ⲠⲒⲦⲈⲂⲦ ⲂⲈⲦⲀϤⲤⲞⲘⲤ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϤⲪⲀϢⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲚⲒⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲐⲢⲞⲨⲬⲰ ϦⲀⲢⲰⲞⲨ ⲘⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲀⲨⲤⲒ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲀⲨⲰⲖⲒ ⲘⲪⲎ ⲈⲦⲀϤⲈⲢϨⲞⲨⲞ ⲈⲢⲰⲞⲨ ⲒⲂ ⲚⲔⲞⲦ ⲚⲖⲀⲔϨ ⲈⲨⲘⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈϤⲬⲎ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦϤ ⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲚⲀⲨⲬⲎ ⲚⲈⲘⲀϤ ⲠⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲀϤϢⲈⲚⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲈ ⲚⲒⲢⲰⲘⲒ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲒⲢⲈϤϮⲰⲘⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲎⲖⲒⲀⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲦⲈⲚⲒⲀⲢⲬⲈⲞⲤ ⲠⲈ ⲈⲦⲀϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ⲀϤϨⲞⲚϨⲈⲚ ⲈϢⲦⲈⲘϪⲈ ⲪⲀⲒ ⲚϨⲖⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ⲈⲀϤϪⲞⲤ ϪⲈ ϨⲰϮ ⲠⲈ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϬⲒ ⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲞϢϤ ⲚϪⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲚⲦⲞⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲰⲚϤ ϦⲈⲚⲠⲒⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰϢ ⲈⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲘⲀⲢⲈϤϪⲞⲖϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲀⲢⲈϤⲰⲖⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲘⲘⲎ ⲚⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ⲪⲎ ⲄⲀⲢ ⲈⲐⲞⲨⲰϢ ⲈⲚⲞϨⲈⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲦⲀⲔⲞⲤ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈⲐⲂⲎⲦ ⲈϤⲈⲚⲀϨⲘⲈⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ⲞⲨ ⲄⲀⲢ ⲈⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀϪⲈⲘϨⲎⲞⲨ ⲘⲘⲞϤ ⲀϤϢⲀⲚϪⲈⲘϨⲎⲞⲨ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲚⲐⲞϤ ⲆⲈ ⲚⲦⲈϤⲦⲀⲔⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲒⲈ ⲚⲦⲈϤϮⲞⲤⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ⲪⲎ ⲄⲀⲢ ⲈⲐⲚⲀϢⲒⲠⲒ ϦⲀⲦϨⲎ ⲚⲈⲘ ⲚⲀⲤⲀϪⲒ ⲪⲀⲒ ϨⲰϤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲀϮϢⲒⲠⲒ ⲚⲀϤ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ϦⲈⲚⲠⲈϤⲰⲞⲨ ⲚⲈⲘ ⲪⲀ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲚⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲦⲀⲪⲘⲎⲒ ϪⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ϦⲈⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲚⲎ ⲈⲦⲈⲚⲤⲈⲚⲀϪⲈⲘϮⲠⲒ ⲘⲪⲘⲞⲨ ⲀⲚ ϢⲀⲦⲞⲨⲚⲀⲨ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒⲤⲀϪⲒ ⲚⲀⲨ ⲎⲚⲈϨⲞⲞⲨ ⲀϤⲰⲖⲒ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲠϪⲒⲚⲐⲢⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲀϤϢⲰⲂⲦ ⲚϪⲈⲠⲀⲞⲨⲀⲚ ⲚⲦⲈⲠⲈϤϨⲞ ⲞⲨⲞϨ ⲠⲈϤϬⲒϨⲂⲞⲤ ⲀϤⲞⲨⲂⲀϢ ⲘⲪⲢⲎϮ ⲚⲚⲈϤϨⲒⲤⲈⲦⲈⲂⲢⲎϪ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲢⲰⲘⲒ ⲂⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲈⲦⲈ ⲘⲰⲨⲤⲎⲤ ⲠⲈ ⲚⲈⲘ ⲎⲖⲒⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲚϨⲞⲨ ϦⲈⲚⲞⲨⲰⲞⲨ ⲚⲀⲨⲤⲀϪⲒ ⲘⲠⲈϤⲘⲰⲒⲦ ⲈⲂⲞⲖ ⲪⲎ ⲈⲚⲀϤⲚⲀϪⲞⲔϤ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲀϤ ⲚⲈⲀⲨϨⲢⲞϢ ⲚϨⲒⲚⲒⲘ ⲠⲈ ⲈⲦⲀⲨⲈⲢϢⲢⲰⲒⲤ ⲆⲈ ⲀⲨⲚⲀⲨ ⲈⲠⲈϤⲰⲞⲨ ⲚⲈⲘ ⲠⲒⲢⲰⲘⲒ ⲂⲚⲎ ⲈⲚⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲨⲚⲀⲪⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲀⲚⲈⲤ ⲚⲀⲚ ⲚⲦⲈⲚϢⲰⲠⲒ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲞϨ ⲒⲤϪⲈ ⲬⲞⲨⲰϢ ⲚⲦⲈⲚⲐⲀⲘⲒⲞ ⲚⲄϮ ⲚⲤⲔⲨⲚⲎ ⲞⲨⲒ ⲚⲀⲔ ⲚⲈⲘ ⲞⲨⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲞϨ ⲞⲨⲒ ⲚⲎⲖⲒⲀⲤ ⲘϤⲈⲘⲒ ⲀⲚ ⲈⲠⲈⲦⲀϤϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ⲚⲀⲒ ⲆⲈ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨϬⲎⲠⲒ ⲞⲨⲞϨ ⲀⲤⲈⲢϦⲎⲒⲂⲒ ⲈϪⲰⲞⲨ ⲀⲨⲈⲢϨⲞϮ ⲆⲈ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈϮϬⲎⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ⲞⲨⲞϨ ⲞⲨⲤⲘⲎ ⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚϮϬⲎⲠⲒ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲈⲦⲤⲞⲦⲠ ⲤⲰⲦⲈⲘ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ⲞⲨⲞϨ ⲈⲦⲀⲤϢⲰⲠⲒ ⲚϪⲈϮⲤⲘⲎ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨⲀⲦϤ ⲠⲈⲦⲀⲨϪⲈⲘϤ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲀⲨⲬⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨⲦⲀⲘⲈ ϨⲖⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈϨⲖⲒ ⲚⲚⲎ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲠⲈϤⲢⲀⲤϮ ⲈⲦⲀⲨⲒ ⲈϦⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒ ⲠⲒⲦⲰⲞⲨ ⲀⲨⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ⲀϤⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ϮϮϨⲞ ⲈⲢⲞⲔ ϪⲞⲨϢⲦ ⲈⲠⲀϢⲎⲢⲒ ϪⲈ ⲞⲨϢⲎⲢⲒ ⲘⲘⲀⲨⲀⲦϤ ⲚⲎⲒ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ϤⲚⲎⲞⲨ ⲈϪⲰϤ ⲚϪⲈⲞⲨⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ϤⲰϢ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϤϢⲐⲞⲢⲦⲈⲢ ⲘⲘⲞϤ ⲞⲨⲞϨ ϤⲢⲰϦⲦ ⲘⲘⲞϤ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲢⲰϤ ϪⲈϢ ⲤⲪⲎⲒϮ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲞⲄⲒⲤ ϢⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲈϤϦⲞⲘϦⲈⲘ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ⲞⲨⲞϨ ⲀⲒϮϨⲞ ⲈⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨϨⲒⲦϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲰⲠⲒϪⲰⲞⲨ ⲚⲀⲐⲚⲀϨϮ ⲞⲨⲞϨ ⲈⲦⲪⲞⲚϨ ϢⲀ ⲐⲚⲀⲨ ϮⲚⲀϢⲰⲠⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲚⲦⲀⲈⲢⲀⲚⲈⲬ ⲈⲤⲐⲈ ⲘⲘⲰⲦⲈⲚ ⲀⲚⲒ ⲠⲈⲔϢⲎⲢⲒ ⲚⲎⲒ ⲘⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ⲈⲦⲒ ⲈϤⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ϨⲀⲢⲞϤ ⲀϤⲢⲀϦⲦϤ ⲈϦⲢⲎⲒ ⲚϪⲈⲠⲒⲆⲈⲘⲰⲚ ⲞⲨⲞϨ ⲀϤϢⲦⲈⲢⲐⲰⲢϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲘⲠⲒⲆⲈⲘⲰⲚ ⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲞⲨⲞϨ ⲀϤⲦⲞⲨϪⲈ ⲠⲒⲀⲖⲞⲨ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲈⲠⲈϤⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ⲚⲀϤⲈⲢϢⲪⲎⲢⲒ ⲦⲎⲢⲞⲨ ⲈϪⲈⲚ ϮⲘⲈⲐⲚⲒϢϮ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲨⲈⲢϢⲪⲎⲢⲒ ⲆⲈ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲚⲀϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲬⲀ ⲚⲀⲒⲤⲀϪⲒ ϦⲈⲚⲚⲈⲦⲈⲚⲘⲀϢϪ ⲠϢⲎⲢⲒ ⲄⲀⲢ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚϨⲀⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲰⲂϢ ⲈⲠⲀⲒⲤⲀϪⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤϨⲎⲠ ⲈⲢⲰⲞⲨ ⲠⲈ ⲞⲨⲞϨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲔⲀϮ ⲈⲢⲞϤ ⲚⲀⲨⲈⲢϨⲞϮ ⲈϢⲈⲚϤ ⲠⲈ ⲈⲐⲂⲈ ⲠⲀⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ⲀϤⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰⲞⲨ ⲚϪⲈⲞⲨⲘⲞⲔⲘⲈⲔ ϪⲈ ⲚⲒⲘ ⲘⲘⲰⲞⲨ ⲠⲈ ⲠⲒⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲒⲘⲞⲔⲘⲈⲔ ⲚⲦⲈⲠⲞⲨϨⲎⲦ ⲀϤⲀⲘⲞⲚⲒ ⲚⲞⲨⲀⲖⲞⲨ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϦⲀⲦⲞⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϢⲈⲠ ⲠⲀⲒⲀⲖⲞⲨ ⲈⲢⲞϤ ϦⲈⲚⲠⲀⲢⲀⲚ ⲀⲚⲞⲔ ⲠⲈⲦⲀϤϢⲰⲠ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϢⲰⲠ ⲘⲘⲞⲒ ⲀϤϢⲰⲠ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲪⲎ ⲄⲀⲢ ⲈⲦⲞⲒ ⲚⲔⲞⲨϪⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲦⲎⲢⲞⲨ ⲪⲀⲒ ⲠⲈ ⲠⲒⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲀⲚⲚⲀⲨ ⲈⲞⲨⲀⲒ ⲈϤϨⲒ ⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲞⲨⲞϨ ⲀⲚⲦⲀϨⲚⲞ ⲘⲘⲞϤ ϪⲈ ϤⲘⲞϢⲒ ⲚⲈⲘⲀⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲞⲨ ⲄⲀⲢ ϤϮ ⲀⲚ ⲞⲨⲂⲈ ⲐⲎⲚⲞⲨ ⲪⲎ ⲄⲀⲢ ⲈⲦⲈⲚϤϮ ⲞⲨⲂⲈ ⲐⲎⲚⲞⲨ ⲀⲚ ⲀϤϮ ϨⲒ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲦⲈϤⲀⲚⲀⲖⲨⲘⲮⲒⲤ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲀϤⲤⲈⲘⲚⲈ ⲠⲈϤϨⲞ ⲈϢⲈ ⲈⲒⲖⲎⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲚϨⲀⲚⲢⲈⲘⲚϨⲰⲂ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲈ ⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲞⲨϮⲘⲒ ⲚⲦⲈⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎⲤ ϨⲰⲤⲦⲈ ⲈⲤⲞⲂϮ ⲚⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ⲞⲨⲞϨ ⲘⲠⲞⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲀⲢⲈ ϨⲢⲀϤ ⲞⲨⲈϨ ⲠⲈ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲬⲞⲨⲰϢ ⲚⲦⲈⲚϪⲞⲤ ⲞⲨⲞϨ ⲚⲦⲈϤⲒ ⲚϪⲈⲞⲨⲬⲢⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲚⲦⲈϤⲢⲞⲔϨⲞⲨ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲈⲢϨⲰⲂ ⲚϪⲈⲎⲖⲒⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ⲈⲦⲀϤⲪⲞⲚϨϤ ⲆⲈ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲀϢ ⲘⲠⲚⲈⲨⲘⲀⲚⲦⲈϤⲒ ⲀⲚ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲦⲀⲔⲈ ⲚⲒⲮⲨⲬⲎ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲀⲖⲖⲀ ⲈⲦⲀⲚϦⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲔⲈϮⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ⲞⲨⲞϨ ⲈⲨⲘⲞϢⲒ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲚⲀϤ ϪⲈ ⲚⲦⲀⲘⲞϢⲒ ⲚⲤⲰⲔ ⲈⲪⲘⲀ ⲈⲦⲈⲔϢⲈ ⲚⲀⲔ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ⲚⲒⲂⲀϢⲞⲢ ⲞⲨⲞⲚⲦⲞⲨ ⲂⲎⲂ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲘⲀⲚⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲆⲈ ⲚⲐⲞϤ ⲘⲪⲢⲰⲘⲒ ⲘⲘⲞⲚⲦⲈϤ ⲘⲀⲚⲞⲨⲀϨϪⲰϤ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲔⲈⲞⲨⲀⲒ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲎⲒ ⲚϢⲞⲢⲠ ⲚⲦⲀϢⲈ ⲚⲦⲀⲐⲰⲘⲤ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲬⲀ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲘⲀⲢⲞⲨⲔⲈⲤ ⲚⲞⲨⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲐⲞⲔ ⲆⲈ ⲘⲀϢⲈ ⲚⲀⲔ ϨⲒⲰⲒϢ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϮⲚⲀⲘⲞϢⲒ ⲚⲤⲰⲔ ⲠϬⲞⲒⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲎⲒ ⲚϢⲞⲢⲠ ⲚⲦⲀⲈⲢⲀⲠⲞⲦⲀⲌⲈⲤⲐⲈ ⲚⲚⲎ ⲈⲦϦⲈⲚ ⲠⲀⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲀϤϨⲒⲦⲞⲦϤ ⲈⲞⲨϨⲈⲂⲒ ⲚⲦⲈϤϪⲞⲨϢⲦ ⲈⲪⲀϨⲞⲨ ⲚⲀϢⲰⲠⲒ ⲈϤⲤⲞⲨⲦⲰⲚ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲀⲠϬⲞⲒⲤ ⲞⲨⲰⲚϨ ⲚⲔⲈⲞ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲚⲂ ⲂⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲈϦⲞⲨⲚ ⲈⲞⲨⲂⲀⲔⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲚⲀϤⲚⲀϢⲈ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲠⲈ ϪⲈ ⲠⲒⲰⲤϦ ⲘⲈⲚ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲆⲈ ϨⲀⲚⲔⲞⲨϪⲒ ⲚⲈⲦⲰⲂϨ ⲞⲨⲚ ⲘⲠϬⲞⲒⲤ ⲘⲠⲒⲰⲤϦ ϨⲞⲠⲰⲤ ⲚⲦⲈϤϨⲒⲞⲨⲒ ⲚϨⲀⲚⲈⲢⲄⲀⲦⲎⲤ ⲈⲂⲞⲖ ⲈⲠⲈϤⲰⲤϦ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮⲞⲨⲰⲢⲠ ⲘⲘⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚϨⲒⲎⲂ ϦⲈⲚⲐⲘⲎϮ ⲚϨⲀⲚⲞⲨⲰⲚϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ⲘⲠⲈⲢϤⲀⲒ ⲚⲀⲤⲞⲨⲒ ⲞⲨⲆⲈ ⲠⲎⲢⲀ ⲞⲨⲆⲈ ⲐⲰⲞⲨⲒ ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚϨⲖⲒ ϨⲒ ⲪⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ⲠⲒⲎⲒ ⲆⲈ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲀϪⲞⲤ ⲚϢⲞⲢⲠ ϪⲈ ⲦϨⲒⲢⲎⲚⲎ ⲘⲠⲀⲒⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲈⲠϢⲎⲢⲒ ⲚϮϨⲒⲢⲎⲚⲎ ⲘⲘⲀⲨ ⲦⲈⲦⲈⲚϨⲒⲢⲎⲚⲎ ⲈⲤⲈⲘⲦⲞⲚ ⲘⲘⲞⲤ ⲈϪⲰϤ ⲈϢⲰⲠ ⲘⲘⲞⲚ ⲦⲈⲦⲈⲚϨⲒⲢⲎⲚⲎ ⲈⲤⲈⲔⲞⲦⲤ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲈⲦⲈⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲤⲰ ⲚⲚⲎ ⲈⲦⲈⲚⲦⲰⲞⲨ ⲠⲒⲈⲢⲄⲀⲦⲎⲤ ⲄⲀⲢ ϤⲘⲠϢⲀ ⲚⲦⲈϤϦⲢⲈ ⲘⲠⲈⲢⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲎⲒ ⲈⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ⲞⲨⲞϨ ϮⲂⲀⲔⲒ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲰⲘ ⲚⲚⲎ ⲈⲦⲞⲨⲚⲀⲬⲀⲨ ϦⲀⲢⲰⲦⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ⲞⲨⲞϨ ⲚⲎ ⲈⲦϢⲰⲚⲒ ⲚϦⲎⲦⲤ ⲀⲢⲒⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ϮⲂⲀⲔⲒ ⲆⲈ ⲈⲦⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲰⲞⲨ ⲀⲘⲰⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲤⲠⲖⲀⲦⲒⲀ ⲀϪⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ϪⲈ ⲠⲒⲔⲈϢⲰⲒϢ ⲈⲦⲀϤⲦⲰⲘⲒ ⲈⲚⲈⲚϬⲀⲖⲀⲨϪ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲦⲈⲚⲂⲀⲔⲒ ⲦⲈⲚⲚⲀⲚⲈϨϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲠⲖⲎⲚ ⲪⲀⲒ ⲀⲢⲒⲈⲘⲒ ⲈⲢⲞϤ ϪⲈ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲈⲘⲦⲞⲚ ⲚⲀϢⲰⲠⲒ ⲚⲤⲞⲆⲞⲘⲀ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈϨⲞⲦⲈ ϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ⲞⲨⲞⲒ ⲚⲈⲬⲞⲢⲀⲌⲒⲚ ⲞⲨⲞⲒ ⲚⲈⲂⲎⲐⲤⲀⲒⲆⲀ ϪⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲈⲚⲈ ⲀⲨϢⲰⲠⲒ ⲚϪⲈⲚⲀⲒϪⲞⲘ ⲈⲦⲀⲨϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲈⲒⲤⲐⲚⲈⲒ ⲀⲨⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲈⲨϨⲈⲘⲤⲒ ϦⲈⲚⲞⲨⲤⲞⲔ ⲚⲈⲘ ⲞⲨⲔⲈⲢⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ⲠⲖⲎⲚ ⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲞⲨⲞⲚ ⲞⲨⲈⲘⲦⲞⲚ ⲚⲀϢⲰⲠⲒ ⲚⲰⲞⲨ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲈϨⲞⲦⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ⲞⲨⲞϨ ⲚⲐⲞ ϨⲰⲒ ⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲘⲎ ⲦⲈⲢⲀϬⲒⲤⲒ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ⲤⲈⲚⲀⲐⲈⲂⲒⲞ ϢⲀ ⲈⲠⲈⲤⲎⲦ ⲈⲀⲘⲈⲚϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ⲪⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲚⲤⲰⲦⲈⲚ ⲀϤⲤⲰⲦⲈⲘ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϢⲰϢ ⲘⲘⲰⲦⲈⲚ ⲀϤϢⲰϢ ⲘⲘⲞⲒ ⲪⲎ ⲈⲦϢⲰϢ ⲘⲘⲞⲒ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ⲀⲨⲦⲀⲤⲐⲞ ⲆⲈ ⲚϪⲈⲠⲒⲞ ϦⲈⲚⲞⲨⲢⲀϢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲒⲔⲈⲆⲈⲘⲰⲚ ⲤⲈϬⲚⲞ ⲚϪⲰⲞⲨ ⲚⲀⲚ ϦⲈⲚⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲀⲒⲚⲀⲨ ⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲀϤϨⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲤⲈⲦⲈⲂⲢⲎϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ϨⲎⲠⲠⲈ ⲀⲒϮ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲈⲢϢⲒϢⲒ ⲈϨⲰⲘⲒ ⲈϪⲈⲚ ϨⲀⲚϨⲞϤ ⲚⲈⲘ ϨⲀⲚϬⲖⲎ ⲚⲈⲘ ⲈϪⲈⲚ ϮϪⲞⲘ ⲦⲎⲢⲤ ⲚⲦⲈⲠⲒϪⲀϪⲒ ⲞⲨⲞϨ ⲚⲚⲈϤϬⲒ ⲐⲎⲚⲞⲨ ⲚϪⲞⲚⲤ ⲚϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ⲠⲖⲎⲚ ⲘⲠⲈⲢⲢⲀϢⲒ ϦⲈⲚⲪⲀⲒ ϪⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲤⲈϬⲚⲞ ⲚϪⲰⲞⲨ ⲚⲰⲦⲈⲚ ⲢⲀϢⲒ ⲆⲈ ⲚⲐⲞϤ ϪⲈ ⲚⲈⲦⲈⲚⲢⲀⲚ ⲤⲈⲤϦⲎⲞⲨⲦ ϦⲈⲚⲚⲒⲪⲎ ⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲐⲈⲖⲎⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϮⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ⲪⲒⲰⲦ ⲠϬⲞⲒⲤ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲔⲀϨⲒ ϪⲈ ⲀⲔϨⲈⲠ ⲚⲀⲒ ⲈϨⲀⲚⲤⲀⲂⲈⲨ ⲚⲈⲘ ϨⲀⲚⲔⲀⲦϨⲎⲦ ⲞⲨⲞϨ ⲀⲔϬⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ ⲀϨⲀ ⲪⲒⲰⲦ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲘⲠⲒϮⲘⲀϮ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲠⲈⲔⲘⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲨⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲚⲦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲤⲰⲞⲨⲚ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠϢⲎⲢⲒ ⲈⲂⲎⲖ ⲈⲪⲒⲰⲦ ⲞⲨⲞϨ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲪⲒⲰⲦ ⲈⲂⲎⲖ ⲈⲠϢⲎⲢⲒ ⲚⲈⲘ ⲪⲎ ⲈⲦⲈ ⲠϢⲎⲢⲒ ⲞⲨⲰϢ ⲈϬⲰⲢⲠ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲔⲞⲦϤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲤⲀⲠⲤⲀ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲂⲀⲖ ⲈⲐⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲀⲚⲘⲎ ϢⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ϨⲀⲚⲞⲨⲢⲰⲞⲨ ⲀⲨⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨⲚⲀⲨ ⲞⲨⲞϨ ⲈⲤⲰⲦⲈⲘ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲚⲞⲘⲒⲔⲞⲤ ⲀϤⲦⲰⲚϤ ⲀϤⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲞⲨ ⲠⲈϮⲚⲀⲚⲀⲒϤ ⲚⲦⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲈⲦⲤϦⲎⲞⲨⲦ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲒⲈ ⲀⲔⲰϢ ⲚⲀϢ ⲚⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲈⲔⲈⲘⲈⲚⲢⲈ ⲠϬⲞⲒⲤ ⲠⲈⲔⲚⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔϨⲎ ⲦⲦⲎⲢϤ ⲚⲈⲘ ⲦⲈⲔⲮⲨⲬⲎ ⲦⲎⲢⲤ ⲚⲈⲘ ⲦⲈⲔϪⲞⲘ ⲦⲎⲢⲤ ⲚⲈⲘ ϦⲈⲚⲚⲈⲔⲘⲈⲨⲒ ⲦⲎⲢϤ ⲚⲈⲘ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲀⲔⲈⲢⲞⲨⲰ ϦⲈⲚⲞⲨⲤⲰⲞⲨⲦⲈⲚ ⲪⲀⲒ ⲀⲢⲒⲦϤ ⲞⲨⲞϨ ⲬⲚⲀⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ⲚⲐⲞϤ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲐⲘⲀⲒⲞ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ϨⲰϤ ⲠⲈ ⲠⲀϢⲪⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲒⲈⲢⲒⲬⲰ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲦⲞⲦⲞⲨ ⲚϨⲀⲚⲤⲒⲚⲰⲞⲨⲒ ⲞⲨⲞϨ ⲈⲦⲀⲨⲂⲀϢϤ ⲀⲨϮ ⲚϨⲀⲚⲈⲢϦⲰⲦ ⲚⲀϤ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲀⲨⲬⲀϤ ⲈϤⲞⲒ ⲘⲪⲀϢⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ⲔⲀⲦⲀ ⲞⲨϮⲘⲀϮ ⲆⲈ ⲞⲨⲞⲨⲎⲂ ⲚⲀϤⲚⲎ ⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤⲤⲈⲚϤ ⲀϤⲬⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ⲔⲈⲖⲈⲨⲒⲦⲎⲤ ⲈⲦⲀϤⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤⲬⲀϤ ⲀϤⲤⲈⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ⲞⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲆⲈ ⲀϤⲘⲞϢⲒ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲀϤϢⲈⲚϨⲎ Ⲧ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲀϤⲘⲞⲨⲢ ⲚⲚⲈϤⲈⲢϦⲰⲦ ⲀϤϮ ⲚⲈϨ ϨⲒ ⲎⲢⲠ ⲚⲤⲰⲞⲨ ⲈⲦⲀϤⲦⲀⲖⲞϤ ⲈⲠⲈⲦⲈⲪⲰϤ ⲚⲦⲈⲂⲚⲎ ⲀϤⲈⲚϤ ⲈⲞⲨⲠⲀⲚⲦⲞⲬⲒⲞⲚ ⲞⲨⲞϨ ⲀϤϤⲒ ⲠⲈϤⲢⲰⲞⲨϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ⲞⲨⲞϨ ⲈⲠⲈϤⲢⲀⲤϮ ⲀϤⲈⲚ ⲆⲎⲚⲀⲢⲒⲞⲚ ⲂⲈⲂⲞⲖ ⲀϤⲦⲎⲒⲦⲞⲨ ⲘⲠⲒⲠⲀⲚⲦⲞⲬⲈⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϤⲒ ⲠⲈϤⲢⲰⲞⲨϢ ϦⲈⲚⲚⲀⲒ ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲞ ⲈⲦⲈⲔⲚⲀϬⲞϤ ⲈⲂⲞⲖ ⲈⲢⲞϤ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚⲦⲀⲤⲐⲞ ϮⲚⲀⲦⲎⲒϤ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ⲚⲒⲘ ⲞⲨⲚ ϦⲈⲚⲠⲀⲒⲄ ⲈⲦⲈⲔⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ⲀϤⲈⲢϢⲪⲎⲢ ⲘⲪⲎ ⲈⲦⲀϤⲒ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲤⲒⲚⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲒⲢⲒ ⲘⲠⲒⲚⲀⲒ ⲚⲈⲘⲀϤ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲀⲢⲒⲞⲨⲒ ϨⲰⲔ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ⲈⲨⲘⲞϢⲒ ⲆⲈ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲞⲨϮⲘⲒ ⲞⲨⲤϨⲒⲘⲒ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲘⲀⲢⲐⲀ ⲀⲤϢⲞⲠϤ ⲈⲢⲞⲤ ⲈϦⲞⲨⲚ ⲈⲠⲈⲤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚⲦⲈ ⲐⲀⲒ ⲚⲞⲨⲤⲰⲚⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲘⲀⲢⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲤϨⲈⲘⲤⲒ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲘⲠϬⲞⲒⲤ ⲚⲀⲤⲤⲰⲦⲈⲘ ⲈⲠⲈϤⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ⲘⲀⲢⲐⲀ ⲆⲈ ⲚⲀⲤϬⲒ ⲚϨⲢⲀⲤ ⲠⲈ ⲘⲠⲔⲰϮ ⲚⲞⲨⲘⲎϢ ⲚϢⲈⲘϢⲒ ⲈⲦⲀⲤⲞϨⲒ ⲈⲢⲀⲦⲤ ⲠⲈϪⲀⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲤⲈⲢⲘⲈⲖⲒ ⲚⲀⲔ ⲀⲚ ϪⲈ Ⲁ- ⲦⲀⲤⲰⲚⲒ ⲬⲀⲦ ⲘⲘⲀⲨⲀⲦ ⲈⲒϢⲈⲘϢⲒ ⲀϪⲞⲤ ⲞⲨⲚ ⲚⲀⲤ ϨⲒⲚⲀ ⲚⲦⲈⲤϮⲦⲞⲦⲤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲘⲀⲢⲐⲀ ⲘⲀⲢⲐⲀ ⲦⲈϤⲒⲢⲰⲞⲨϢ ⲞⲨⲞϨ ⲦⲈϢⲦⲈⲢⲐⲰⲢ ⲈⲐⲂⲈ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ϨⲀⲚⲔⲞⲨϪⲒ ⲆⲈ ⲠⲈ ϮⲬⲢⲒⲀ ⲒⲈ ⲞⲨⲀⲒ ⲘⲀⲢⲒⲀ ⲆⲈ ⲀⲤⲤⲰⲦⲠ ⲚⲀⲤ ⲚϮⲦⲞⲒ ⲈⲐⲚⲀⲚⲈⲤ ⲐⲎ ⲈⲦⲈⲚⲤⲈⲚⲀϢⲞⲖϤ ⲚⲦⲞⲦⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈϤⲬⲎ ϦⲈⲚⲞⲨⲘⲀ ⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲈⲦⲀϤⲔⲎⲚ ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲘⲀⲦⲤⲀⲂⲞⲚ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲦⲤⲀⲂⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ϨⲞⲦⲀⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲀϪⲞⲤ ⲠⲈⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲚⲒⲪⲎⲞⲨⲒ ⲘⲀⲢⲈϤⲦⲞⲨⲂⲞ ⲚϪⲈⲠⲈⲔⲢⲀⲚ ⲘⲀⲢⲈⲤⲒ ⲚϪⲈⲦⲈⲔⲘⲈⲦⲞⲨⲢⲞ ⲠⲈⲦⲈϨⲚⲀⲔ ⲘⲀⲢⲈϤϢⲰⲠⲒ ⲘⲪⲢⲎϮ ϦⲈⲚⲦⲪⲈ ⲚⲈⲘ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ⲠⲈⲚⲰⲒⲔ ⲈⲐⲚⲎⲞⲨ ⲘⲎⲒϤ ⲚⲀⲚ ⲘⲘⲎⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ⲞⲨⲞϨ ⲬⲀ ⲚⲈⲚⲚⲞⲂⲒ ⲚⲀⲚ ⲈⲂⲞⲖ ⲔⲈ ⲄⲀⲢ ⲀⲚⲞⲚ ϨⲰⲚ ⲦⲈⲚⲬⲰ ⲈⲂⲞⲖ ⲚⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀⲚ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲚⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲈϤ ϢⲪⲎⲢ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲈ ϢⲀⲢⲞϤ ⲚⲦⲪⲀϢⲒ ⲘⲠⲒⲈϪⲰⲢϨ ⲞⲨⲞϨ ⲚⲦⲈϤϪⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲀϢⲪⲎⲢ ⲘⲀ Ⲅ- ⲚⲰⲒⲔ ⲚⲎⲒ ⲈⲠⲞⲨϢⲀⲠ ");
INSERT INTO copbhc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ϪⲈ ⲞⲨϢⲪⲎⲢ ⲚⲦⲎⲒ ⲀϤⲒ ϢⲀⲢⲞⲒ ⲈⲂⲞⲖ ϨⲒ ⲪⲘⲰⲒⲦ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲪⲎ ⲈϮⲚⲀⲬⲀϤ ϦⲀⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ⲞⲨⲞϨ ⲚⲦⲈⲪⲎ ϨⲰϤ ⲈⲦⲤⲀϦⲞⲨⲚ ⲈⲢⲞⲨⲰ ⲚⲦⲈϤϪⲞⲤ ϪⲈ ⲘⲠⲈⲢϮϦⲒⲤⲒ ⲚⲎⲒ ⲀⲒⲞⲨⲰ ⲄⲀⲢ ⲀⲒⲘⲀϢⲐⲀⲘ ⲘⲠⲀⲢⲞ ⲞⲨⲞϨ ⲚⲀⲀⲖⲰⲞⲨⲒ ⲤⲈⲬⲎ ⲚⲈⲘⲎⲒ ϨⲒϪⲈⲚ ⲠⲀⲘⲀⲚⲚⲔⲞⲦ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲦⲰⲚⲦ ⲚⲦⲀϮ ⲚⲀⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲔⲀⲚ ⲀϤϢⲦⲈⲘⲦⲰⲚϤ ⲈϮ ⲚⲀϤ ϪⲈ ⲠⲈϤϢⲪⲎⲢ ⲠⲈ ⲈⲐⲂⲈ ⲦⲈϤⲘⲈⲦⲖⲀϪⲒ ⲆⲈ ⲈϤⲈⲦⲰⲚϤ ⲚⲦⲈϤϮ ⲚⲀϤ ⲚⲚⲎ ⲈⲦⲀϤⲈⲢⲬⲢⲒⲀ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ⲀⲚⲞⲔ ϨⲰ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲒⲈⲦⲒⲚ ⲞⲨⲞϨ ⲤⲈⲚⲀϮ ⲚⲰⲦⲈⲚ ⲔⲰϮ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϪⲒⲘⲒ ⲔⲰⲖϨ ⲞⲨⲞϨ ⲤⲈⲚⲀⲞⲨⲰⲚ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲢⲈⲦⲒⲚ ϢⲀϤϬⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲔⲰϮ ϢⲀϤϪⲒⲘⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲔⲰⲖϨ ϢⲀⲨⲞⲨⲰⲚ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ⲚⲒⲘ ⲆⲈ ⲚⲒⲰⲦ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲠⲈϤϢⲎⲢⲒ ⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲞⲨⲰⲒⲔ ⲘⲎ ϤⲚⲀϮ ⲚⲞⲨⲰⲚⲒ ⲚⲀϤ ⲒⲈ ⲚⲦⲈϤⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲞⲨⲦⲈⲂⲦ ⲘⲎ ⲚⲦⲈϤϢⲈⲂⲒⲰ ⲚⲞⲨⲦⲈⲂⲦ ϤⲚⲀϮ ⲚⲞⲨϨⲞϤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ⲒⲈ ⲚⲦⲈϤⲈⲢⲈⲦⲒⲚ ⲚⲞⲨⲤⲰⲞⲨϨⲒ ⲘⲎ ϤⲚⲀϮ ⲚⲞⲨϬⲖⲎ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ⲒⲤϪⲈ ⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲈϮ ⲚϨⲀⲚⲦⲀⲒⲞ ⲈⲚⲀⲚⲈⲨ ⲚⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲪⲒⲰⲦ ϤⲚⲀϮ ⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ϦⲈⲚⲦⲪⲈ ⲚⲚⲎ ⲈⲦⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ⲞⲨⲞϨ ⲚⲀϤϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲚⲞⲨⲆⲈⲘⲰⲚ ⲚⲔⲞⲨⲢ ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲆⲈⲘⲰⲚ ⲀϤⲤⲀϪⲒ ⲚϪⲈⲠⲒⲔⲞⲨⲢ ⲞⲨⲞϨ ⲀⲨⲈⲢϢⲪⲎ ⲢⲒ ⲚϪⲈⲚⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲠⲈϪⲰⲞⲨ ϪⲈ ϦⲈⲚⲂⲈⲖⲌⲈⲂⲞⲨⲖ ⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ ⲀϤϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲚⲀⲨⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎⲒⲚⲒ ⲚⲦⲞⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ⲚⲐⲞϤ ⲆⲈ ⲈϤⲤⲰⲞⲨⲚ ⲚⲚⲞⲨⲘⲈⲨⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲈⲦⲞⲨⲢⲞ ⲚⲒⲂⲈⲚ ⲀⲤϢⲀⲚⲪⲰϢ ⲈϪⲰⲤ ϢⲀⲤϢⲰϤ ⲞⲨⲞϨ ⲞⲨⲎⲒ ⲈϪⲈⲚ ⲞⲨⲎⲒ ϢⲀϤϨⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ⲒⲤϪⲈ ⲆⲈ ⲠⲤⲀⲦⲀⲚⲀⲤ ϨⲰϤ ⲀϤⲪⲰϢ ⲈϪⲰϤ ⲘⲘⲀⲨⲀⲦϤ ⲠⲰⲤ ϪⲈ ⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ ⲚⲀϢⲞϨⲒ ⲈⲢⲀⲦⲤ ϪⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ϦⲈⲚⲂⲈⲖⲌⲈⲂⲞⲨⲖ ϮϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ⲒⲤϪⲈ ⲆⲈ ⲀⲚⲞⲔ ϦⲈⲚⲂⲈⲖⲌⲈⲂⲞⲨⲖ ϮϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲀⲨϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲐⲰⲞⲨ ⲤⲈⲈⲢⲢⲈϤϮϨⲀⲠ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ⲒⲤϪⲈ ⲆⲈ ⲀⲚⲞⲔ ϦⲈⲚⲞⲨⲦⲎⲂ ⲚⲦⲈⲪⲚⲞⲨϮ ϮϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ϨⲀⲢⲀ ⲀⲤⲪⲞϨ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ⲈϢⲰⲠ ⲄⲀⲢ ⲀⲢⲈϢⲀⲚ ⲠⲒϪⲰⲢⲒ ϦⲞⲔϤ ⲚⲦⲈϤⲀⲢⲈϨ ⲈⲦⲈϤⲀⲨⲖⲎ ϢⲀⲢⲈ ⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ϢⲰⲠⲒ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈⲞⲨϪⲰⲢⲒ ⲈⲢⲞϤ Ⲓ- ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲞⲨⲞϨ ⲚⲦⲈϤϬⲢⲞ ⲈⲢⲞϤ ϢⲀϤⲰⲖⲒ ⲘⲠⲈϤϦⲰⲔ ⲪⲎ ⲈⲚⲀⲢⲈ ϨⲐⲎϤ ⲬⲎ ⲈⲢⲞϤ ⲞⲨⲞϨ ϢⲀϤϪⲰⲢ ⲚⲚⲈϤϢⲰⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ⲪⲎ ⲈⲦⲈⲚϤⲚⲈⲘⲎⲒ ⲀⲚ ⲀϤϮⲞⲨⲂⲎⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚϤⲈⲢⲤⲨⲚⲀⲄⲒⲤⲐⲈ ⲚⲈⲘⲎⲒ ϤϪⲰⲢ ⲘⲘⲞⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲰⲘⲒ ϢⲀϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲘⲀⲚⲀⲐⲘⲰⲞⲨ ⲈϤⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲀⲚⲘⲦⲞⲚ ⲞⲨⲞϨ ⲀϤϢⲦⲈⲘϪⲒⲘⲒ ⲦⲞⲦⲈ ⲀϤϪⲞⲤ ϪⲈ ϮⲚⲀⲦⲀⲤⲐⲞ ⲈⲠⲀⲎⲒ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ⲞⲨⲞϨ ⲀϤϢⲀⲚⲒ ⲚⲦⲈϤϪⲈⲘϤ ⲈϤⲤⲢⲰϤⲦ ⲈϤⲤⲢⲀϨ ⲈϤⲤⲈⲖⲤⲰⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ⲦⲞⲦⲈ ϢⲀϤϢⲈ ⲚⲀϤ ⲞⲨⲞϨ ϢⲀϤϪⲒⲘⲒ ⲚⲔⲈⲌ ⲘⲠⲚⲈⲨⲘⲀⲈⲨϨⲰⲞⲨ ⲈϨⲞⲦⲈⲢⲞϤ ⲞⲨⲞϨ ⲀⲨϢⲀⲚϢⲈ ⲈϦⲞⲨⲚ ϢⲀⲨϢⲰⲠⲒ ⲘⲘⲀⲨ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒϦⲀⲈⲨ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲦϨⲰⲞⲨ ⲈⲚⲈϤϨⲞⲨⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈϤϪⲰ ⲚⲚⲀⲒ ⲀⲞⲨⲤϨⲒⲘⲒ ϤⲀⲒ ⲚⲞⲨⲤⲘⲎ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲰⲞⲨⲚⲒⲀⲦⲤ ⲚϮⲚⲈϪⲒ ⲈⲦⲀⲤϤⲒⲦⲔ ⲚⲈⲘ ⲚⲒⲈⲘⲚⲞϮ ⲈⲦⲀⲨϢⲀⲚⲞⲨϢⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲘⲈⲚⲞⲨⲚⲄⲈ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲦⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ⲈⲨⲚⲀⲐⲰⲞⲨϮ ⲆⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚϪⲞⲤ ϪⲈ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲞⲨⲄⲈⲚⲈⲀ ⲈⲤϨⲰⲞⲨ ⲦⲈ ⲈⲤⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎⲒⲚⲒ ⲞⲨⲞϨ ⲞⲨⲘⲎ ⲒⲚⲒ ⲚⲚⲞⲨⲦⲎⲒϤ ⲚⲀⲤ ⲈⲂⲎⲖ ⲈⲠⲒⲘⲎⲒⲚⲒ ⲚⲦⲈⲒⲰⲚⲀ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲀ ⲒⲰⲚⲀ ϢⲰⲠⲒ ⲚⲞⲨⲘⲎⲒⲚⲒ ⲚⲚⲒⲢⲈⲘⲚⲒⲚⲈⲨⲎ ⲠⲀⲒⲢⲎϮ ϨⲰϤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲀϢⲰⲠⲒ ⲚⲦⲀⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ϮⲞⲨⲢⲰ ⲚⲦⲈⲤⲀⲢⲎⲤ ⲈⲤⲈⲦⲰⲚⲤ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ ⲚⲦⲈⲦⲀⲒⲄⲈⲚⲈⲀ ⲞⲨⲞϨ ⲈⲤⲈϮϨⲀⲠ ⲈⲢⲰⲞⲨ ϪⲈ ⲀⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲀⲦ ⲘⲠⲔⲀϨⲒ ⲈⲤⲰⲦⲈⲘ ⲈϮⲤⲞⲪⲒⲀ ⲚⲦⲈⲤⲞⲖⲞⲘⲰⲚ ⲞⲨⲞϨ ⲒⲤ ϨⲞⲨⲞ ⲈⲤⲞⲖⲞⲘⲰⲚ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ⲚⲒⲢⲰⲘⲒ ⲚⲦⲈⲚⲒⲚⲈⲨⲎ ⲤⲈⲚⲀⲦⲰⲞⲨⲚⲞⲨ ϦⲈⲚϮⲔⲢⲒⲤⲒⲤ ⲚⲈⲘ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲞⲨⲞϨ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲞⲤ ϪⲈ ⲀⲨⲈⲢⲘⲈⲦⲀⲚⲒⲞⲚ ⲈⲠⲒϨⲒⲰⲒϢ ⲚⲦⲈⲒⲰⲚⲀ ⲞⲨⲞϨ ⲒⲤ ϨⲞⲨⲞ ⲈⲒⲰⲚⲀ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ⲘⲠⲀⲢⲈ ϨⲖⲒ ⲆⲈ ϬⲈⲢⲈ ⲞⲨϦⲎⲂⲤ ⲚⲦⲈϤⲬⲀϤ ϦⲈⲚⲞⲨⲘⲀⲚϨⲰⲠ ⲞⲨⲆⲈ ϦⲀ ⲞⲨⲘⲈⲚⲦ ⲀⲖⲖⲀ ϨⲒϪⲈⲚ ϮⲖⲨⲬⲚⲒⲀ ϨⲒⲚⲀ ⲚⲎ ⲈⲐⲚⲀⲈϦⲞⲨⲚ ⲚⲦⲞⲨⲚⲀⲨ ⲈⲠⲒⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ⲠϦⲎⲂⲤ ⲘⲠⲈⲔⲤⲰⲘⲀ ⲠⲈ ⲠⲈⲔⲂⲀⲖ ⲈϢⲰⲠ ⲈⲠⲈⲔⲂⲀⲖ ⲞⲨⲀⲠⲖⲞⲨⲤ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲈϤⲈⲈⲢⲞⲨⲰⲒⲚⲒ ⲈϢⲰⲠ ⲆⲈ ⲞⲨⲠⲞⲚⲎⲢⲞⲤ ⲠⲈ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ϤⲞⲒ ⲚⲬⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ⲀⲚⲀⲨ ⲘⲎⲠⲰⲤ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲈⲦⲈⲚϦⲎⲦⲔ ⲞⲨⲬⲀⲔⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ⲒⲤϪⲈ ⲞⲨⲚ ⲠⲈⲔⲤⲰⲘⲀ ⲦⲎⲢϤ ⲞⲨⲞⲨⲰⲒⲚⲒ ⲠⲈ ⲘⲘⲞⲚ ⲦⲞⲒ ⲚⲦⲀϤ ⲞⲒ ⲚⲬⲈⲘⲤ ⲈϤⲈϢⲰⲠⲒ ⲦⲎⲢϤ ⲈϤⲞⲒ ⲚⲞⲨⲰⲒⲚⲒ ⲘⲪⲢⲎϮ ⲘⲠⲒϦⲎⲂⲤ ϦⲈⲚⲠⲒⲤⲈⲦⲈⲂⲢⲎϪ ⲈϤⲈⲈⲢⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ⲈⲦⲀϤⲤⲀϪⲒ ⲆⲈ ⲀϤϮϨⲞ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲪⲀⲢⲒⲤⲈⲞⲤ ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲞⲨⲰⲘ ϦⲀⲦⲞⲦϤ ⲈⲦⲀϤϢⲈ ⲆⲈ ⲈϦⲞⲨⲚ ⲀϤⲢⲰⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ⲠⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ⲀϤⲈⲢϢⲪⲎ ⲢⲒ ϪⲈ ⲘⲠⲈϤϬⲒⲰⲘⲤ ⲚϢⲞⲢⲠ ϦⲀϪⲈⲚ ⲠⲒⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϮⲚⲞⲨ ⲚⲐⲰⲦⲈⲚ ϦⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲦⲈⲦⲈⲚⲦⲞⲨⲂⲞ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲀⲪⲞⲦ ⲚⲈⲘ ⲠⲒⲂⲒⲚⲀϪ ⲤⲀϦⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲦⲈⲚ ⲘⲈϨ ⲚϨⲰⲖⲈⲘ ⲚⲈⲘ ⲠⲞⲚⲎⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ⲚⲒⲀⲦϨⲎⲦ ⲘⲎ ⲪⲎ ⲀⲚ ⲈⲦⲀϤⲐⲀⲘⲒⲈ ⲤⲀⲂⲞⲖ ⲚⲐⲞϤ ⲞⲚ ⲀϤⲐⲀⲘⲒⲈ ⲤⲀϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ⲠⲖⲎⲚ ⲚⲎ ⲈⲦϢⲞⲠ ⲘⲎⲒⲦⲞⲨ ⲈⲐⲘⲈⲦⲚⲀⲎ ⲦⲞⲨⲞϨ ⲒⲤ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲤⲈⲦⲞⲨⲂⲎⲞⲨⲦ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ⲀⲖⲖⲀ ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚϮ ⲘⲪⲢⲈⲘⲎⲦ ⲘⲠⲒⲀϬⲒⲚⲚⲤⲐⲞⲒ ⲚⲈⲘ ⲠⲒⲂⲀϢⲞⲨϢ ⲚⲈⲘ ⲞⲨⲞϮ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲬⲰ ⲚⲤⲰⲦⲈⲚ ⲘⲠⲒϨⲀⲠ ⲚⲈⲘ ϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲒ ⲆⲈ ⲚⲀⲤⲘⲠϢⲀ ⲚⲦⲈⲦⲈⲚⲀⲒⲦⲞⲨ ⲞⲨⲞϨ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲬⲀⲨ ⲚⲤⲀⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲘⲈⲒ ⲚⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚϨⲈⲘⲤⲒ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ⲚⲒⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲚⲒⲀⲄⲞⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲞⲒ ⲘⲪⲢⲎϮ ⲚⲚⲒⲘϨⲀⲨ ⲈⲦⲈⲚⲤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲀⲚ ⲞⲨⲞϨ ⲚⲒⲢⲰⲘⲒ ⲈⲐⲘⲞϢⲒ ϨⲒϪⲰⲞⲨ ⲚⲤⲈⲈⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲞⲨⲀⲒ ⲚⲚⲒⲚⲞⲘⲒⲔⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲀⲒ ⲈⲔϪⲰ ⲘⲘⲰⲞⲨ ⲔϢⲰϢ ⲘⲘⲞⲚ ϨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ϦⲀ ⲚⲒⲚⲞⲘⲒⲔⲞⲤ ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲦⲀⲖⲞ ⲚϨⲀⲚⲈⲦⲪⲰⲞⲨⲒ ⲈⲨⲘⲞⲔϨ ⲘϤⲒⲦⲞⲨ ⲈϪⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚϬⲒ ⲚⲈⲘ ⲚⲒⲈⲦⲪⲰⲞⲨⲒ ⲀⲚ ⲚⲞⲨⲀⲒ ⲚⲚⲈⲦⲈⲚⲦⲎⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲔⲰⲦ ⲚⲚⲒⲘϨⲀⲨ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲦⲈⲚⲒⲞϮ ⲀⲨϦⲞⲐⲂⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ϨⲀⲢⲀ ⲦⲈⲦⲈⲚⲈⲢⲘⲈⲐⲢⲈ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚϮⲘⲀϮ ⲈϪⲈⲚ ⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲚⲈⲦⲈⲚⲒⲞϮ ϪⲈ ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲀⲨϦⲞⲐⲂⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲔⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ⲈⲐⲂⲈⲪⲀⲒ ⲀϮⲔⲈⲤⲞⲪⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ϪⲞⲤ ϪⲈ ϮⲚⲀⲞⲨⲰⲢⲠ ϨⲀⲢⲰⲞⲨ ⲚϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ϨⲀⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲞⲨⲞϨ ⲈⲨⲈϦⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈϬⲞϪⲒ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ϨⲒⲚⲀ ⲚⲤⲈϬⲒ ⲘⲠϢⲒϢ ⲘⲠⲤⲚⲞϤ ⲚⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲈⲦⲀⲨⲪⲞⲚϤ ⲈⲂⲞⲖ ⲒⲤϪⲈⲚ ⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲦⲞⲦⲤ ⲚⲦⲀⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ⲒⲤϪⲈⲚ ⲠⲤⲚⲞϤ ⲚⲀⲂⲈⲖ ϢⲀ ⲠⲤⲚⲞϤ ⲚⲌⲀⲬⲀⲢⲒⲀⲤ ⲠϢⲎⲢⲒ ⲘⲂⲀⲢⲀⲬⲒⲀⲤ ⲪⲎ ⲈⲦⲀⲨⲦⲀⲔⲞϤ ⲞⲨⲦⲈ ⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ⲚⲈⲘ ⲠⲒⲎⲒ ⲤⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲤⲈⲚⲀⲔⲰϮ ⲚⲤⲰϤ ⲚⲦⲞⲦⲤ ⲚⲦⲀⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ⲞⲨⲞⲒ ⲚⲰⲦⲈⲚ ⲚⲚⲒⲚⲞⲘⲒⲔⲞⲤ ϪⲈ ⲀⲦⲈⲦⲈⲚⲰⲖⲒ ⲚⲚⲒϢⲰϢⲦ ⲚⲦⲈⲠⲤⲰⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲘⲠⲈⲦⲈⲚⲒ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ⲦⲈⲦⲈⲚⲈⲢⲔⲰⲖⲒⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲤⲞⲘⲤ ⲚⲔⲀⲔⲰⲤ ⲞⲨⲞϨ ⲈⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲈⲐⲂⲈ ϨⲀⲚⲘⲎϢ ");
INSERT INTO copbhc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ⲈⲨϬⲒⲬⲢⲞϤ ⲈϪⲞⲢϪϤ ⲚⲞⲨⲤⲀϪⲒ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ⲈⲚ ⲞⲒⲤ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈϨⲀⲚⲐⲂⲀ ⲘⲘⲎϢ ϨⲰⲤⲦⲈ ⲚⲦⲞⲨϨⲰⲘⲒ ⲈϪⲈⲚ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚϢⲞⲢⲠ ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲠϢⲈⲘⲎⲢ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲦⲈ ⲦⲞⲨⲘⲈⲦϢⲞⲂⲒ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ⲘⲘⲞⲚ ϨⲖⲒ ⲈϤϨⲞⲂⲤ ϪⲈ ϤⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ⲀⲚ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲠⲈⲦϨⲎⲠ ϪⲈ ⲤⲈⲚⲀⲈⲘⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ⲚⲎ ⲄⲀⲢ ⲈⲦⲈⲦⲈⲚⲚⲀϪⲞⲦⲞⲨ ϦⲈⲚⲠⲬⲀⲔⲒ ⲤⲈⲚⲀⲤⲞⲐⲘⲞⲨ ϦⲈⲚⲪⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲀϪⲒ ⲘⲘⲞϤ ϦⲈⲚⲪⲘⲀϢϪ ϦⲈⲚⲚⲒⲦⲀⲘⲒⲞⲚ ⲈⲨⲈϨⲒⲰⲒϢ ⲘⲘⲞϤ ϨⲒϪⲈⲚ ⲚⲒϪⲈⲚⲈⲪⲰⲢ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲚⲀϢⲪⲎⲢ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲚⲚⲎ ⲈⲐⲚⲀϦⲰⲦⲈⲂ ⲘⲠⲈⲦⲈⲚⲤⲰⲘⲀ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲘⲘⲞⲚ ⲚⲦⲰⲞⲨ ⲘⲘⲀⲨ ⲚϨⲖⲒ ⲚϨⲞⲨⲞ ⲈⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲆⲈ ϪⲈ ⲀⲢⲒϨⲞϮ ϦⲀⲦϨⲎ ⲚⲚⲒⲘ ⲀⲢⲒϨⲞϮ ϦⲀⲦϨⲎ ⲘⲪⲎ ⲈⲦⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲈⲐⲢⲈϤϦⲰⲦⲈⲂ ⲞⲨⲞⲚⲦⲈϤ ⲈⲢϢⲒϢⲒ ⲈϨⲒⲞⲨⲒ ⲈϮⲄⲈⲈⲚⲚⲀ ⲀϨⲀ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲒϨⲞϮ ϦⲀⲦϨⲎ ⲘⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ⲘⲎ ⲈⲚϬⲀϪ ⲀⲚ ⲈⲦⲞⲨϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲀ ⲦⲈⲂⲒ ⲤⲚⲞⲨϮ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲤⲈⲞⲂϢ ⲈⲢⲞϤ ⲀⲚ ⲘⲠⲈⲘⲐⲞ ⲘⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ⲀⲖⲖⲀ ⲚⲒⲔⲈϤⲰⲒ ⲚⲦⲈⲦⲈⲚⲀⲪⲈ ⲤⲈⲎⲠ ⲦⲎⲢⲞⲨ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲦⲈⲦⲈⲚⲞⲨⲞⲦ ⲈⲞⲨⲘⲎϢ ⲚϬⲀϪ ");
INSERT INTO copbhc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲎⲦ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲠϢⲎⲢⲒ ϨⲰϤ ⲘⲪⲢⲰⲘⲒ ⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲤⲈⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ϨⲰϤ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϪⲈ ⲞⲨⲤⲀϪⲒ ⲚⲤⲀⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲤⲈⲚⲀⲬⲀϤ ⲚⲀϤ ⲈⲂⲞⲖ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϪⲈⲞⲨⲀ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲚⲞⲨⲬⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲈⲚ ⲐⲎⲚⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲎ ⲚⲈⲘ ⲚⲒⲈⲜⲞⲨⲤⲒⲀ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ϪⲈ ⲠⲰⲤ ⲒⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲞⲨⲰ ⲘⲘⲞϤ ⲒⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀϪⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ⲠⲒⲠⲚⲈⲨⲘⲀⲄⲀⲢ ⲈⲐⲞⲨⲀⲂ ⲚⲀⲦⲤⲀⲂⲰⲦⲈⲚ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲚⲎ ⲈⲐⲚⲀⲤⲈⲘⲠϢⲀ ⲚϪⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲆⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲀϪⲞⲤ ⲘⲠⲀⲤⲞⲚ ⲈⲐⲢⲈϤⲪⲰϢ ⲈϨⲢⲀϤ ⲚⲈⲘⲎⲒ ⲚϮⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲪⲢⲰⲘⲒ ⲚⲒⲘ ⲠⲈⲦⲀϤⲬⲀⲦ ⲚⲢⲈϤϮϨⲀⲠ ⲒⲈ ⲚⲢⲈϤⲪⲰϢ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲀⲨ ⲞⲨⲞϨ ⲀⲢⲈϨ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ϬⲒⲚϪⲞⲚⲤ ⲚⲒⲂⲈⲚ ϪⲈ ⲚⲀⲢⲈ ⲠⲰⲚϦ ϢⲞⲠ ⲘⲠⲒⲢⲰⲘⲒ ⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠϨⲞⲨⲞ ⲘⲠⲈⲦⲈⲚⲦⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ⲀϤϪⲈ ⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲆⲈ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲀⲘⲀⲞ ⲈⲀⲤⲈⲢϢⲀⲨ ⲚϪⲈⲦⲈϤⲬⲰⲢⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ⲞⲨⲞϨ ⲚⲀϤⲘⲞⲔⲘⲈⲔ ⲠⲈ ⲚϦⲢⲎⲒ ⲚϦⲎ ⲦϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ϪⲈ ⲘⲘⲞⲚϮ ⲘⲀ ⲘⲘⲀⲨ ⲈⲐⲢⲒⲐⲰⲞⲨϮ ⲚⲚⲀⲞⲨⲦⲀϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲪⲀⲒ ϮⲚⲀⲀⲒϤ ϮⲚⲀϢⲞⲢϢⲈⲢ ⲚⲚⲀⲀⲠⲞⲐⲎⲔⲎ ⲞⲨⲞϨ ϮⲚⲀⲔⲞⲦⲞⲨ ⲚⲚⲒϢϮ ⲚϨⲞⲨⲞ ⲞⲨⲞϨ ⲚⲦⲀⲐⲰⲞⲨϮ ⲈⲘⲀⲨ ⲘⲠⲀⲤⲞⲨⲞ ⲦⲎⲢϤ ⲚⲈⲘ ⲚⲀⲀⲄⲀⲐⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ⲞⲨⲞϨ ϮⲚⲀϪⲞⲤ ⲚⲦⲀⲮⲨⲬⲎ ϪⲈ ⲦⲀⲮⲨⲬⲎ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲀⲄⲀⲐⲞⲚ ⲬⲎ ⲚⲈⲚⲞⲨⲘⲎϢ ⲚⲢⲞⲘⲠⲒ ⲘⲦⲞⲚ ⲘⲘⲞ ⲞⲨⲰⲘ ⲤⲰ ⲞⲨⲚⲞϤ ⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ⲠⲈϪⲈ ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠⲒⲀⲦϨⲎⲦ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲈϪⲰⲢϨ ⲤⲈⲚⲀⲰⲖⲒ ⲚⲦⲈⲔⲮⲨⲬⲎ ⲈⲂⲞⲖ ⲚϦⲎⲦⲔ ⲚⲎ ⲈⲦⲀⲔⲐⲞⲨⲰⲦⲞⲨ ⲈⲨⲚⲀϢⲰⲠⲒ ⲚⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲘⲪⲎ ⲈⲦϨⲒⲞⲨⲒ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲈϤⲞⲒ ⲚⲢⲀⲘⲀⲞ ⲀⲚ ϦⲈⲚⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲈⲐⲂⲈⲪⲀⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲦⲈⲦⲈⲚⲮⲨⲬⲎ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲞⲨⲞⲘϤ ⲞⲨⲆⲈ ϦⲀ ⲠⲈⲦⲈⲚⲤⲰⲘⲀ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲦⲎⲒϤ ϨⲒ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ϮⲮⲨⲬⲎ ⲄⲀⲢ ⲞⲨⲞⲦ ⲈϮϦⲢⲈ ⲞⲨⲞϨ ⲠⲒⲤⲰⲘⲀ ⲈϮϨⲈⲂⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ⲘⲀⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲚⲒⲀⲂⲰⲔ ϪⲈ ⲤⲈⲤⲒϮ ⲀⲚ ⲞⲨⲞϨ ⲤⲈⲰⲤϦ ⲀⲚ ⲚⲎ ⲈⲦⲈⲘⲘⲞⲚ ⲦⲀⲘⲒⲞⲚ ⲚⲦⲰⲞⲨ ⲞⲨⲆⲈ ⲀⲠⲞⲐⲎⲔⲎ ⲞⲨⲞϨ ⲪⲚⲞⲨϮ ϢⲀⲚϢ ⲘⲘⲰⲞⲨ ⲀⲨⲎⲢ ⲘⲀⲖⲖⲞⲚ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞⲨⲞⲦ ⲈⲚⲒϨⲀⲖⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ⲚⲒⲘ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤϤⲒⲢⲰⲞⲨϢ ⲈⲦⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲦⲀⲖⲈ ⲞⲨⲘⲀϨⲒ ⲚϢⲒⲎ ⲈϪⲈⲚ ⲦⲈϤⲘⲀⲒⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ⲒⲤϪⲈ ⲞⲨⲚ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲞⲨⲔⲞⲨϪⲒ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲠⲤⲈⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ⲘⲀⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲚⲒϨⲢⲎⲢⲒ ϪⲈ ⲠⲰⲤ ⲤⲈⲀⲒⲀⲒ ⲚⲤⲈϦⲞⲤⲒ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲈⲢⲒⲞⲠⲎ ⲀⲚ ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲆⲈ ⲤⲞⲖⲞⲘⲰⲚ ϦⲈⲚⲠⲈϤⲰⲞⲨ ⲦⲎⲢϤ ⲘⲠⲈϤϮ ϨⲒⲰⲦϤ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ⲒⲤϪⲈ ⲆⲈ ⲠⲒⲤⲒⲘ ϤϢⲞⲠ ⲘⲪⲞⲞⲨ ϦⲈⲚⲦⲔⲞⲒ ⲞⲨⲞϨ ⲢⲀⲤϮ ϢⲀⲨϨⲒⲦϤ ⲈϮⲐⲢⲒⲢ ⲠⲀⲒⲢⲎϮ ⲪⲚⲞⲨϮ ϮϨⲈⲂⲤⲰ ϨⲒⲰⲦϤ ⲠⲞⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲚⲀ ⲠⲒⲔⲞⲨϪⲒ ⲚⲚⲀϨϮ ");
INSERT INTO copbhc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲘⲠⲈⲢⲔⲰϮ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲞⲨⲞⲘϤ ⲞⲨⲞϨ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲤⲞϤ ⲞⲨⲞϨ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ");
INSERT INTO copbhc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ⲚⲀⲒ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲒⲈⲐⲚⲒⲔⲞⲤ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲤⲈⲔⲰϮ ⲚⲤⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲤⲰⲞⲨⲚ ϪⲈ ⲦⲈⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲚⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ⲠⲖⲎⲚ ⲔⲰϮ ⲚⲤⲀⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲈⲚⲀⲞⲨⲀϨⲞⲨ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲠⲒⲔⲞⲨϪⲒ ⲚⲞϨⲒ ϪⲈ ⲀϤϮⲘⲀϮ ⲚϪⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲈϮ ⲚⲰⲦⲈⲚ ⲚϮⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ⲘⲀ ⲚⲈⲦⲈⲚϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲈⲂⲞⲖ ⲘⲎⲒⲦⲞⲨ ⲈⲐⲘⲈⲦⲚⲀⲎⲦ ⲘⲀⲐⲀⲘⲒⲞ ⲚⲰⲦⲈⲚ ⲚϨⲀⲚⲀⲤⲞⲨⲒ ⲘⲠⲀⲨⲈⲢⲀⲠⲀⲤ ⲚⲞⲨⲀϨⲞ ⲚⲀⲐⲘⲞⲨⲚⲔ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲠⲒⲘⲀ ⲈⲦⲈⲘⲠⲀⲢⲈ ⲢⲈϤϬⲒⲞⲨⲒ ϦⲰⲚⲦ ⲈⲢⲞϤ ⲞⲨⲆⲈ ⲘⲠⲀⲢⲈ ϨⲞⲖⲒ ⲦⲀⲔⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ⲠⲒⲘⲀ ⲄⲀⲢ ⲈⲦⲈ ⲠⲈⲦⲈⲚⲀϨⲞ ⲘⲘⲞϤ ⲈϤⲈϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚϪⲈⲠⲈⲦⲈⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ⲘⲀⲢⲞⲨϢⲰⲠⲒ ⲈⲨϦⲎⲔ ⲚϪⲈⲚⲈⲦⲈⲚϮⲠⲒ ⲞⲨⲞϨ ⲚⲈⲦⲈⲚϦⲎⲂⲤ ⲈⲨⲘⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲞⲚⲒ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲨϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲞⲨϬ ⲤϪⲈ ϤⲚⲀϮⲞⲨⲰ ⲚⲐⲚⲀⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϨⲞⲠ ϨⲒⲚⲀ ⲀϤϢⲀⲚⲒ ⲚⲦⲈϤⲔⲰⲖϨ ⲤⲀⲦⲞⲦⲞⲨ ⲚⲤⲈⲀⲞⲨⲰⲚ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲈⲂⲒⲀⲒⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲎ ⲈⲦⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲞⲨϬⲞⲒⲤ ⲚⲦⲈϤϪⲈⲘⲞⲨ ⲈⲨⲢⲎ ⲤⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϤⲚⲀϦⲞⲔϤ ⲞⲨⲞϨ ⲚⲦⲈϤⲐⲢⲞⲨⲢⲰⲦⲈⲂ ⲞⲨⲞϨ ⲚⲦⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲦⲈϤϢⲈⲘϢⲒ ⲘⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ⲔⲀⲚ ⲀϤϢⲀⲚⲒ ϦⲈⲚϮⲘⲀϨⲤⲚⲞⲨϮ ⲔⲀⲚ ⲀϤϢⲀⲚⲒ ϦⲈⲚϮⲘⲀϨⲄϮ ⲚⲞⲨⲈⲢϢⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϪⲈⲘⲞⲨ ⲈⲨⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ⲪⲀⲒ ⲆⲈ ⲀⲢⲒⲈⲘⲒ ⲈⲢⲞϤ ϪⲈ ⲈⲚⲀⲢⲈ ⲠⲒⲚⲈⲂⲎⲒ ⲈⲘⲒ ϪⲈ ϦⲈⲚⲀϢ ⲚⲞⲨⲚⲞⲨ ϤⲚⲎⲞⲨ ⲚϪⲈⲠⲒⲢⲈϤϬⲒⲞⲨⲒ ⲚⲀϤⲚⲀⲢⲰⲒⲤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤⲚⲀⲬⲀⲨ ⲀⲚ ⲠⲈ ⲈⲈⲢϢⲀⲦⲤ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲤⲈⲂⲦⲰⲦ ϪⲈ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ϤⲚⲎⲞⲨ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲀⲔϪⲰ ⲚⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲢⲞⲚ ϢⲀⲚ ⲀⲔϪⲰ ⲘⲘⲞⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲠⲈ ⲠⲒⲠⲒⲤⲦⲞⲤ ⲚⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲞⲨⲞϨ ⲚⲤⲀⲂⲈ ⲪⲎ ⲈⲦⲈ ⲠⲈϤϬⲞⲒⲤ ⲚⲀⲬⲀϤ ⲈϪⲈⲚ ⲚⲈϤⲈⲂⲒⲀⲒⲔ ϪⲈ ⲚⲦⲈϤϮ ⲚⲦⲞⲨϦⲢⲈ ⲚⲰⲞⲨ ϦⲈⲚⲠⲤⲎⲞⲨ ⲚⲦⲎⲒⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲎ ⲈⲦⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲈϤϬⲞⲒⲤ ⲚⲦⲈϤϪⲈⲘϤ ⲈϤⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ⲦⲀⲪⲘⲎⲒ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϤⲚⲀⲬⲀϤ ⲈϪⲈⲚ ⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚϪⲞⲤ ⲚϪⲈⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲠⲈϤϨⲎⲦ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲚⲀⲰⲤⲔ ⲘⲠⲀⲦⲈϤⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲞⲨⲒ ⲚⲚⲒⲂⲰⲔ ⲚⲈⲘ ⲚⲒⲂⲰⲔⲒ ⲚⲦⲈϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰ ⲚⲦⲈϤⲐⲒϦⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ϤⲚⲀⲒ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲂⲰⲔ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈϤⲤⲞⲘⲤ ϦⲀϪⲰϤ ⲀⲚ ⲚⲈⲘ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈϤⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ⲞⲨⲞϨ ϤⲚⲀⲪⲞⲢϪϤ ϦⲈⲚⲦⲈϤⲘⲎϮ ⲞⲨⲞϨ ⲦⲈϤⲦⲞⲒ ⲚⲀⲬⲀⲤ ⲚⲈⲘ ⲚⲒⲀⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ⲠⲒⲂⲰⲔ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲦⲀϤⲈⲘⲒ ⲈⲪⲞⲨⲰϢ ⲘⲠⲈϤϬⲞⲒⲤ ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲈϤⲤⲞⲂϮ ⲞⲨⲞϨ ⲘⲠⲈϤⲒⲢⲒ ⲔⲀⲦⲀ ⲚⲈϤⲞⲨⲰϢ ⲤⲈⲚⲀϮ ⲚϨⲀⲚⲘⲎϢ ⲚϢⲀϢ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ⲪⲎ ⲆⲈ ⲈⲦⲈⲘⲠⲈϤⲈⲘⲒ ⲚⲦⲈϤⲒⲢⲒ ⲆⲈ ⲚⲚⲎ ⲈⲦⲤⲈⲘⲠϢⲀ ⲚϨⲀⲚϢⲎϢⲒ ⲤⲈⲚⲀϮ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲚϢⲀϢ ⲚⲀϤ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨϮ ⲞⲨⲘⲎϢ ⲚⲀϤ ⲤⲈⲚⲀⲔⲰϮ ⲚⲤⲀⲞⲨⲘⲎϢ ⲚⲦⲞⲦϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀⲨϪⲀⲖⲈ ⲞⲨⲘⲎϢ ⲈⲢⲞϤ ⲤⲈⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ⲞⲨⲬⲢⲰⲘ ⲠⲈ ⲈⲦⲀⲒⲒ ⲈϨⲒⲦϤ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲞⲨⲞϨ ⲞⲨ ⲠⲈ ⲈϮⲚⲀⲞⲨⲀϢϤ ⲒⲈ ϨⲎⲆⲎ ⲀϤⲘⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲆⲈ ⲚⲞⲨⲰⲘⲤ ⲈϬⲒⲦϤ ⲞⲨⲞϨ ⲠⲰⲤ ϮⲈⲢⲤⲨⲚⲈⲬⲈⲤⲐⲈ ϢⲀⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ⲀⲢⲈⲦⲈⲚⲘⲈⲨⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈϨⲒⲞⲨⲒ ⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲘⲘⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲖⲖⲀ ⲞⲨⲪⲰⲢϪ ");
INSERT INTO copbhc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ⲈⲨⲈϢⲰⲠⲒ ⲄⲀⲢ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲚϪⲈⲈ- ϦⲈⲚⲞⲨⲎⲒ ⲚⲞⲨⲰⲦ ⲈⲨⲪⲞⲢϪ ⲄⲈϪⲈⲚ Ⲃ- ⲞⲨⲞϨ ⲂⲈϪⲈⲚ Ⲅ- ");
INSERT INTO copbhc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ⲈⲨⲈⲪⲰⲢϪ ⲚϪⲈⲞⲨⲒⲰⲦ ⲈϪⲈⲚ ⲞⲨϢⲎ ⲢⲒ ⲞⲨⲞϨ ⲞⲨϢⲎⲢⲒ ⲈϪⲈⲚ ⲞⲨⲒⲰⲦ ⲞⲨⲘⲀⲨ ⲈϪⲈⲚ ⲞⲨϢⲈⲢⲒ ⲞⲨⲞϨ ⲞⲨϢⲈⲢⲒ ⲈϪⲈⲚ ⲞⲨⲘⲀⲨ ⲞⲨϢⲰⲘⲒ ⲈϪⲈⲚ ⲞⲨϢⲈⲖⲈⲦ ⲞⲨⲞϨ ⲞⲨϢⲈⲖⲈⲦ ⲈϪⲈⲚ ⲞⲨϢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲚⲒⲔⲈⲘⲎϢ ϪⲈ ϨⲞⲦⲀⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲞⲨϬⲎⲠⲒ ⲈⲀⲤⲒ ⲈⲂⲞⲖ ⲤⲀⲠⲈⲘⲈⲚⲦ ϢⲀⲢⲈⲦⲈⲚϪⲞⲤ ⲤⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲞⲨⲘⲞⲨⲚϨⲰⲞⲨ ⲈⲐⲚⲎⲞⲨ ⲞⲨⲞϨ ϢⲀⲤϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ⲞⲨⲞϨ ϨⲞⲦⲀⲚ ⲞⲨⲐⲞⲨⲢⲎⲤ ⲈϤⲚⲒϤⲒ ϢⲀⲢⲈⲦⲈⲚϪⲞⲤ ϪⲈ ⲔⲀⲨⲤⲰⲚ ⲠⲈⲐⲚⲀϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ⲚⲒϢⲞⲂⲒ ⲠϨⲞ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲒⲔⲀϨⲒ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲚⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲞϤ ⲠⲀⲒⲤⲎ ⲞⲨ ⲆⲈ ⲚⲐⲞϤ ⲠⲰⲤ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ⲚⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ⲈⲐⲂⲈ ⲞⲨ ⲦⲈⲦⲈⲚϮϨⲀⲠ ⲀⲚ ⲚϮⲘⲈⲐⲘⲎ ⲒⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ϨⲰⲤ ⲄⲀⲢ ⲬⲚⲀϢⲈ ⲚⲈⲘ ⲠⲈⲔⲀⲚⲦⲒⲆⲒⲔⲞⲤ ϢⲀ ⲞⲨⲀⲢⲬⲰⲚ ⲘⲞⲒ ⲚⲞⲨϨⲰⲂ ⲚⲚⲞⲨϤⲦ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲈϤⲤⲞⲔⲔ ϨⲀ ⲠⲒⲢⲈϤϮϨⲀⲠ ⲞⲨⲞϨ ⲚⲦⲈⲠⲒⲢⲈϤϮ ϨⲀⲠ ⲦⲎⲒⲔ ⲈⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲀⲔⲦⲰⲢ ⲞⲨⲞϨ ⲚⲦⲈⲠⲒⲠⲢⲀⲔⲦⲰⲢ ϨⲒⲦⲔ ⲈⲠⲒϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈⲔⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ϢⲀⲦⲈⲔϮ ⲘⲠⲒϦⲀⲈ ⲚⲖⲈⲠⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ⲚⲈ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲠⲈ ⲘⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲨⲦⲀⲘⲞ ⲘⲘⲞϤ ⲈⲐⲂⲈ ⲚⲒⲄⲀⲖⲒⲖⲈⲞⲤ ⲚⲎ ⲈⲦⲀ ⲠⲒⲖⲀⲦⲞⲤ ⲘⲞⲨϪⲦ ⲘⲠⲞⲨⲤⲚⲞϤ ⲚⲈⲘ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲢⲈⲦⲈⲚⲘⲈⲨⲒ ϪⲈ ⲚⲀⲒⲄⲀⲖⲒⲖⲈⲞⲤ ⲀⲨϢⲰⲠⲒ ⲈⲨⲞⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲈⲂⲞⲖ ⲞⲨⲦⲈ ⲚⲒⲄⲀⲖⲒⲖⲈⲞⲤ ⲦⲎⲢⲞⲨ ϪⲈ ⲀⲨϬⲒ ⲚⲚⲀⲒⲘⲔⲀⲨϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ⲘⲘⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲦⲈⲦⲈⲚⲚⲀⲦⲀⲔⲞ ⲦⲎⲢⲞⲨ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ⲒⲈ ⲠⲒⲒⲎ ⲚⲢⲰⲘⲒ ⲈⲦⲀ ⲠⲒⲠⲨⲢⲄⲞⲤ ϨⲈⲒ ⲈϪⲰⲞⲨ ϦⲈⲚⲠⲒⲤⲒⲖⲰⲀⲘ ⲞⲨⲞϨ ⲀϤϦⲞⲐⲂⲞⲨ ⲀⲢⲈⲦⲈⲚⲘⲈⲨⲒ ϪⲈ ⲀⲚⲀⲒ ϢⲰⲠⲒ ⲈⲞⲨⲞⲚ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲦⲈ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲖⲎⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ⲘⲘⲞⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲦⲈⲦⲈⲚⲚⲀⲦⲀⲔⲞ ⲦⲎⲢⲞⲨ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ⲚⲀϤϪⲰ ⲆⲈ ⲚⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲰⲞⲨ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲞⲨⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲈⲤϬⲎⲞⲨⲦ ϦⲈⲚⲠⲈϤⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲀϤⲒ ⲀϤⲔⲰϮ ⲚⲤⲀⲞⲨⲦⲀϨ ϨⲒⲰⲦⲤ ⲞⲨⲞϨ ⲘⲠⲈϤϪⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ⲠⲈϪⲀϤ ⲆⲈ ⲘⲠⲒⲞⲨⲰⲒ ⲚⲀⲖⲞⲖⲒ ϪⲈ ⲒⲤ ⲄϮ ⲚⲢⲞⲘⲠⲒ ⲒⲤϪⲈⲚ ⲈⲒⲚⲎⲞⲨ ⲈⲒⲔⲰϮ ⲚⲤⲀⲞⲨⲦⲀϨ ϦⲈⲚⲦⲀⲒⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲞⲨⲞϨ ϮϪⲒⲘⲒ ⲀⲚ ⲔⲞⲢϪⲤ ⲞⲨⲚ ϨⲒⲚⲀ ⲞⲨ ϪⲈ ⲤⲈⲢⲠⲔⲈⲔⲰⲢϤ ⲘⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲬⲀⲤ ⲚⲦⲀⲒⲔⲈⲢⲞⲘⲠⲒ ϢⲀϮϬⲢⲎ ϦⲀⲢⲀⲦⲤ ⲞⲨⲞϨ ⲚⲦⲀϮⲘⲀϨⲢⲞ ⲚⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ⲀⲢⲎⲞⲨ ⲚⲦⲈⲤⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ⲚϮⲔⲈⲢⲞⲘⲠⲒ ⲈⲐⲚⲎⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲀⲤϢⲦⲈⲘⲒⲚⲒ ⲈⲔⲈⲔⲞⲢϪⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ⲚⲀϤϮⲤⲂⲰ ⲆⲈ ⲠⲈ ϦⲈⲚⲞⲨⲒ ⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲤϨⲒⲘⲒ ⲈⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚϢⲰⲚⲒ ⲬⲎ ⲚⲈⲘⲀⲤ ⲘⲒⲎ ⲚⲢⲞⲘⲠⲒ ⲞⲨⲞϨ ⲚⲀⲤⲔⲞⲖϪ ⲠⲈ ⲚϢⲤⲰⲞⲨⲦⲈⲚ ⲘⲘⲞⲤ ⲀⲚ ⲈⲠⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞⲤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲘⲞⲨϮ ⲈⲢⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ϮⲤϨⲒⲘⲒ ⲦⲈⲬⲎ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ⲞⲨⲞϨ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ϨⲒϪⲰⲤ ⲞⲨⲞϨ ⲀⲤⲤⲰⲞⲨⲦⲈⲚ ⲤⲀⲦⲞⲦⲤ ⲞⲨⲞϨ ⲀⲤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲈϤϪⲰⲚⲦ ϪⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲈϤⲪⲀϦⲢⲒ ⲈⲢⲞⲤ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲘⲠⲒⲘⲎϢ ϪⲈ 6- ⲚⲈϨⲞⲞⲨ ⲈⲦⲈⲤϢⲈ ⲚⲈⲢϨⲰⲂ ⲚϦⲎⲦⲞⲨ ⲚϦⲢⲎⲒ ⲞⲨⲚ ⲚϦⲎⲦⲞⲨ ⲀⲘⲰⲒⲚⲒ ⲚⲦⲞⲨⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲚⲒϢⲞⲂⲒ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ϤϮⲞⲨⲰ ⲚⲦⲈϤⲈϨⲈ ⲈⲂⲞⲖ ⲀⲚ ⲒⲈ ⲠⲈϤⲒⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲞⲨⲞⲚϨϤ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲞⲨⲞϨ ⲚⲦⲈϤϬⲒⲦⲞⲨ ⲚⲦⲈϤⲦⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ⲐⲀⲒ ⲆⲈ ⲚⲐⲞⲤ ⲞⲨϢⲈⲢⲒ ⲚⲦⲈⲀⲂⲢⲀⲀⲘ ⲦⲈ ⲈⲀ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲤⲞⲚϨⲤ ⲒⲤ ⲒⲎ ⲚⲢⲞⲘⲠⲒ ⲚⲈⲠⲈⲦⲤϢⲈ ⲀⲚ ⲠⲈ ⲈⲂⲞⲖⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲤⲚⲀϨ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ⲞⲨⲞϨ ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲚⲀⲨϢⲒⲠⲒ ⲦⲎⲢⲞⲨ ⲠⲈ ⲚϪⲈⲚⲎ ⲈⲦϮ ⲞⲨⲂⲎϤ ⲞⲨⲞϨ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀϤⲢⲀϢⲒ ⲠⲈ ⲈϪⲈⲚ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲦⲀⲒⲎⲞⲨⲦ ⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ⲚⲀϤϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲀⲢⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲤⲞⲚⲒ ⲚⲞⲨ ⲞⲨⲞϨ ⲀⲒⲚⲀⲦⲈⲚⲐⲰⲚⲤ ⲈⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ⲤⲞⲚⲒ ⲚⲞⲨⲚⲀⲪⲢⲒ ⲚϢⲈⲖⲦⲀⲘ ⲐⲎ ⲈⲦⲀ ⲞⲨⲢⲰⲘⲒ ϬⲒⲦⲤ ⲀϤⲤⲀⲦⲤ ϦⲈⲚⲠⲈϤϬⲰⲘ ⲞⲨⲞϨ ⲀⲤⲀⲒⲀⲒ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲞⲨϢϢⲎⲚ ⲞⲨⲞϨ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ ⲀⲨⲞⲨⲞϨ ⲈϪⲈⲚ ⲚⲈⲤϪⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲠⲈϪⲀϤ ϪⲈ ⲀⲒⲚⲀⲦⲈⲚⲐⲰⲚ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ⲤⲞⲚⲒ ⲚⲞⲨϢⲈⲘⲎⲢ ⲪⲎ ⲈⲦⲀ ⲞⲨⲤϨⲒⲘⲒ ϬⲒⲦϤ ⲀⲤⲬⲞⲠϤ ϦⲈⲚⲄⲚϢⲒ ⲚⲚⲰⲒⲦ ϢⲀⲦⲈϤϬⲒϢⲈⲘⲎⲢ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ⲞⲨⲞϨ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ⲔⲀⲦⲀ ⲂⲀⲔⲒ ⲚⲈⲘ ϮⲘⲒ ⲈϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲈϤⲒⲢⲒ ⲘⲠⲈϤϪⲒⲚⲘⲞϢⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ϨⲀⲚⲔⲞⲨϪⲒ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ϪⲈ ⲀⲢⲒⲀⲄⲰⲚⲒⲌⲈⲤⲐⲈ ⲈⲒ ⲈϦⲞⲨⲚ ϨⲒⲦⲈⲚ ⲠⲒⲢⲞ ⲈⲦϪⲎⲞⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲚⲀⲔⲰϮ ⲚⲤⲀⲒⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲚⲚⲞⲨϢϪⲈⲘϪⲞⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ⲀϤϢⲀⲚⲪⲞϨ ⲈⲦⲰⲚϤ ⲚϪⲈⲠⲒⲚⲈⲂⲎⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲐⲀⲘ ⲘⲠⲒⲢⲞ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲈⲢϨⲎ ⲦⲤ ⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲞⲨⲞϨ ⲈⲔⲰⲖϨ ⲈⲠⲒⲢⲞ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲀⲞⲨⲰⲚ ⲚⲀⲚ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲢⲞⲨⲰ ⲚⲦⲈϤϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚϮⲤⲰⲞⲨⲚ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲈⲂⲞⲖ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ⲦⲞⲦⲈ ⲈⲢⲈⲦⲈⲚⲈⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ϪⲈ ⲀⲚⲞⲨⲰⲘ ⲘⲠⲈⲔⲘⲐⲞ ⲞⲨⲞϨ ⲀⲚⲤⲰ ⲞⲨⲞϨ ⲀⲔϮⲤⲂⲰ ϦⲈⲚⲚⲈⲚⲠⲖⲀⲦⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ⲞⲨⲞϨ ϤⲚⲀϪⲞⲤ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲈⲂⲞⲖ ⲐⲰⲚ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲦⲎⲢⲞⲨ ⲚⲒⲈⲢⲄⲀⲦⲎⲤ ⲚⲦⲈϮⲀⲆⲒⲔⲒⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ϤⲚⲀϢⲰⲠⲒ ⲚϪⲈⲪⲢⲒⲘⲒ ⲚⲈⲘ ⲠⲤⲐⲈⲢⲦⲈⲢ ⲚⲦⲈⲚⲒⲚⲀϪϨⲒ ϨⲞⲦⲀⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲒⲀⲔⲰⲂ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲈⲨϨⲒⲞⲨⲒ ⲘⲘⲰⲦⲈⲚ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ⲞⲨⲞϨ ⲈⲨⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘⲀⲚϢⲀⲒ ⲚⲈⲘ ⲚⲒⲘⲀⲚϨⲰⲦⲠ ⲚⲈⲘ ⲠⲈⲘϨⲒⲦ ⲚⲈⲘ ⲤⲀⲢⲎⲤ ⲞⲨⲞϨ ⲈⲨⲈⲢⲞⲐⲂⲞⲨ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲞⲨⲞⲚ ϨⲀⲚϦⲀⲈⲨ ⲈⲨⲚⲀⲈⲢϢⲞⲢⲠ ⲞⲨⲞϨ ϨⲀⲚϢⲞⲢⲠ ⲈⲨⲚⲀⲈⲢϦⲀⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲞⲨⲞϨ ϨⲰⲖ ⲦⲀⲒ ϪⲈ ⲎⲢⲰⲆⲎⲤ ⲞⲨⲰϢ ⲈϦⲞⲐⲂⲈⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲀϪⲞⲤ ⲚⲦⲀⲒⲂⲀϢⲞⲢ ϪⲈ ϨⲎⲠⲠⲈ ϮϨⲒ ⲆⲈⲘⲰⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϮϪⲰⲔ ⲚϨⲀⲚⲦⲀⲖϬⲞ ⲘⲪⲞⲞⲨ ⲚⲈⲘ ⲢⲀⲤϮ ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲘⲀϨⲄ ϮⲚⲀϪⲰⲔ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ⲠⲖⲎⲚ ϨⲰϮ ⲈⲢⲞⲒ ⲚⲦⲀⲈⲢ ⲪⲞⲞⲨ ⲚⲈⲘ ⲢⲀⲤϮ ⲞⲨⲞϨ ⲠⲈⲐⲚⲎⲞⲨ ⲚⲦⲀϢⲈ ⲚⲎⲒ ϪⲈ ⲤⲬⲎ ⲀⲚ ⲚⲦⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲀⲔⲞ ⲤⲀⲂⲞⲖ ⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲐⲎ ⲈⲦⲀⲤϦⲰⲦⲈⲂ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲞⲨⲞϨ ⲈⲦϨⲒ ⲰⲚⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ ϨⲀⲢⲞⲤ ⲞⲨⲎⲢ ⲚⲤⲞⲠ ⲀⲒⲞⲨⲰϢ ⲈⲐⲞⲨⲈⲦ ⲚⲈϢⲎⲢⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨϨⲀⲖⲎⲦ ⲘⲠⲈϤⲘⲞϨ ϦⲀ ⲚⲈϤⲦⲈⲚϨ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲞⲨⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲈⲦⲈⲚⲎⲒ ϤⲬⲎ ⲚⲰⲦⲈⲚ ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ϢⲀⲦⲈⲦⲈⲚϪⲞⲤ ϪⲈ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲞⲨⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲞⲨⲰⲘ ⲚⲞⲨⲰⲒⲔ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲚⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚϨⲨⲆⲢⲰⲠⲒⲔⲞⲤ ⲈϤⲬⲎ ⲘⲠⲈϤⲘⲐⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲚⲒⲚⲞⲘⲒⲔⲞⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲤϢⲈ ⲚⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϢⲀⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲬⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲀϤⲦⲀⲖϬⲞϤ ⲀϤⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲠⲈϤⲒⲰ ⲒⲈ ⲦⲈϤⲈϨⲈ ⲚⲀϨⲈⲒ ⲈϦⲢⲎⲒ ⲈⲞⲨϢⲰϮ ⲞⲨⲞϨ ϤⲚⲀⲈⲚϤ ⲈⲠϢⲰⲒ ⲀⲚ ⲤⲀⲦⲞⲦϤ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚⲈⲢⲞⲨⲰ ⲚⲀϤ ⲞⲨⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ⲚⲀϤϪⲰ ⲆⲈ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲈϤⲚⲀⲨ ϪⲈ ⲠⲰⲤ ⲚⲀⲨⲤⲰⲦⲠ ⲚⲰⲞⲨ ⲚⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚⲢⲰⲦⲈⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ϪⲈ ϨⲞⲦⲀⲚ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲐⲀϨⲘⲈⲔ ⲈϨⲀⲚϨⲞⲠ ⲘⲠⲈⲢⲢⲰⲦⲈⲂ ⲈⲠⲒϢⲞⲢⲠ ⲘⲘⲀⲚⲢⲰⲦⲈⲂ ⲘⲎⲠⲰⲤ ⲀⲨⲐⲀϨⲈⲘ ⲔⲈⲞⲨⲀⲒ ⲈϤⲦⲀⲒⲎ ⲞⲨⲦ ⲈϨⲞⲦⲈⲢⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ⲞⲨⲞϨ ⲚⲦⲈϤⲒ ⲚϪⲈⲪⲎ ⲈⲦⲀϤⲐⲀϨⲘⲈⲔ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲚⲦⲈϤϪⲞⲤ ⲚⲀⲔ ϪⲈ ⲬⲀ ⲠⲒⲘⲀ ⲘⲪⲀⲒ ⲦⲞⲦⲈ ⲬⲚⲀⲈⲢϨⲎⲦⲤ ϦⲈⲚⲞⲨϢⲒⲠⲒ ⲈⲀⲘⲞⲚⲒ ⲘⲠⲒϦⲀⲈ ⲘⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ⲀⲖⲖⲀ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲐⲀϨⲘⲈⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲢⲰⲦⲈⲂ ⲘⲠⲒϦⲀⲈ ϨⲒⲚⲀ ϨⲞⲦⲀⲚ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲪⲎ ⲈⲦⲀϤⲐⲀϨⲘⲈⲔ ⲚⲦⲈϤϪⲞⲤ ⲚⲀⲔ ϪⲈ ⲠⲀϢⲪⲎⲢ ⲞⲨⲞⲐⲂⲈⲔ ⲈⲠϢⲰⲒ ⲦⲞⲦⲈ ⲈⲢⲈ ⲞⲨⲰⲞⲨ ϢⲰⲠⲒ ⲚⲀⲔ ⲘⲠⲈⲘⲐⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲢⲰⲦⲈⲂ ⲚⲈⲘⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϬⲀⲤϤ ⲤⲈⲚⲀⲐⲈⲂⲒⲞϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲐⲈⲂⲒⲞϤ ⲤⲈⲚⲀϬⲀⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲘⲪⲎ ⲈⲦⲀϤⲐⲀϨⲘⲈϤ ϪⲈ ϨⲞⲦⲀⲚ ⲀⲔϢⲀⲚⲒⲢⲒ ⲚⲞⲨⲀⲢⲒⲤⲦⲞⲚ ⲒⲈ ⲞⲨⲆⲒⲠⲚⲞⲚ ⲘⲠⲈⲢⲘⲞⲨϮ ⲈⲚⲈⲔϢⲪⲎⲢ ⲞⲨⲆⲈ ⲚⲈⲔⲤⲚⲎⲞⲨ ⲞⲨⲆⲈ ⲚⲈⲔⲤⲨⲄⲄⲈⲚⲎⲤ ⲞⲨⲆⲈ ⲚⲈⲔⲐⲈϢⲈⲨ ⲚⲢⲀⲘⲀⲞ ⲘⲎⲠⲰⲤ ⲚⲤⲈⲐⲀϨⲘⲈⲔ ϨⲰⲔ ⲞⲨⲞϨ ⲚⲦⲈⲞⲨϢⲈⲂⲒⲰ ϢⲰⲠⲒ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ⲀⲖⲖⲀ ⲀⲔϢⲀⲚⲒⲢⲒ ⲚⲞⲨϢⲞⲠⲤ ⲘⲞⲨϮ ⲈϨⲀⲚϨⲎⲔⲒ ϨⲀⲚⲀⲦϪⲞⲘ ϨⲀⲚϬⲀⲖⲈⲨ ϨⲀⲚⲂⲈⲖⲖⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ⲞⲨⲞϨ ⲬⲚⲀⲈⲢⲞⲨⲘⲀⲔⲀⲢⲒⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲚⲦⲰⲞⲨ ⲘⲘⲀⲨ ⲈϮϢⲈⲂⲒⲰ ⲚⲀⲔ ⲤⲈⲚⲀϮ ⲄⲀⲢ ⲚⲀⲔ ⲚⲦⲞⲨϢⲈⲂⲒⲰ ϦⲈⲚϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲚϪⲈⲞⲨⲀⲒ ⲚⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲠⲈϪⲀϤ ϪⲈ ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲚⲞⲨⲰⲒⲔ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨⲢⲰⲘⲒ ⲈⲀϤⲒⲢⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲆⲒⲠⲚⲞⲚ ⲞⲨⲞϨ ⲀϤⲐⲀϨⲈⲘ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲘⲠⲈϤⲂⲰⲔ ⲘⲪⲚⲀⲨ ⲚⲆⲒⲠⲚⲞⲚ ⲈϪⲞⲤ ⲚⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲈⲐⲢⲞⲨⲒ ϪⲈ ϨⲎⲆⲎ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲤⲈⲤⲈⲂⲦⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲠⲀⲢⲈⲦⲒⲤⲐⲈ ϦⲈⲚⲞⲨϦⲢⲰⲞⲨ ⲚⲞⲨⲰⲦ ⲦⲎⲢⲞⲨ ⲠⲒϨⲞⲨⲒⲦ ⲀϤϪⲞⲤ ϪⲈ ⲀⲒϢⲰⲠ ⲚⲞⲨⲒⲞϨⲒ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲀⲚⲀⲄⲔⲎ ⲦⲞⲒ ⲈⲢⲞⲒ ⲈⲐⲢⲒϢⲈ ⲈⲂⲞⲖ ⲚⲦⲀⲚⲀⲨ ⲈⲢⲞϤ ϮϮϨⲞ ⲈⲢⲞⲔ ⲬⲀⲦ ⲚⲦⲞⲦⲔ ϨⲰⲤ ⲚϮⲚⲎⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲠⲈϪⲀϤ ϪⲈ ⲀⲒϢⲈⲠ Ⲉ- ⲚϨⲈⲂⲒ ⲚⲈϨⲈ ⲞⲨⲞϨ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲚⲦⲀⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲰⲞⲨ ϮϮϨⲞ ⲈⲢⲞⲔ ⲬⲀⲦ ⲚⲦⲞⲦⲔ ϨⲰⲤ ϮⲚⲎⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲠⲈϪⲀϤ ϪⲈ ⲀⲒϬⲒ ⲚⲞⲨⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲈⲐⲂⲈⲪⲀⲒ ϮⲚⲀⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲚϪⲈⲠⲒⲂⲰⲔ ⲀϤⲦⲀⲘⲈ ⲠⲈϤϬⲞⲒⲤ ⲦⲞⲦⲈ ⲈⲦⲀϤϪⲰⲚⲦ ⲚϪⲈⲠⲒⲚⲈⲂⲎⲒ ⲠⲈϪⲀϤ ⲘⲠⲈϤⲂⲰⲔ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲂⲞⲖ ⲚⲬⲰⲖⲈⲘ ⲈⲚⲒⲠⲖⲀⲦⲒⲀ ⲚⲈⲘ ⲚⲒϦⲒⲢ ⲚⲦⲈϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲚⲒϨⲎⲔⲒ ⲚⲈⲘ ⲚⲒⲀⲦϪⲞⲘ ⲚⲈⲘ ⲚⲒⲂⲈⲖⲖⲈⲨ ⲀⲚⲒⲦⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲂⲰⲔ ϪⲈ ⲠϬⲞⲒⲤ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲪⲎ ⲈⲦⲀⲔⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲦⲒ ⲞⲨⲞⲚ ⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲒⲂⲰⲔ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲂⲞⲖ ⲈⲚⲒⲘⲰⲒⲦ ⲚⲈⲘ ⲚⲒⲪⲢⲀⲄⲘⲞⲤ ⲞⲨⲞϨ ⲀⲢⲒⲀⲚⲀⲄⲔⲀⲌⲒⲚ ⲈⲒ ⲈϦⲞⲨⲚ ϨⲒⲚⲀ ⲚⲦⲈϤⲘⲞϨ ⲚϪⲈⲠⲀⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈ ϨⲖⲒ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ϪⲈⲘϮⲠⲒ ⲘⲠⲀⲆⲒⲠⲚⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ⲚⲀⲨⲘⲞϢⲒ ⲆⲈ ⲚⲈⲘⲀϤ ⲚϪⲈϨⲀⲚⲚⲒϢϮ ⲘⲘⲎϢ ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ϪⲈ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲈⲦⲈⲚϤⲚⲀⲘⲈⲤⲦⲈ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲦⲈϤⲤϨⲒⲘⲒ ⲚⲈⲘ ⲚⲈϤϢⲎⲢⲒ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ ⲚⲈⲘ ⲚⲈϤⲤⲰⲚⲒ ⲈⲦⲒ ⲆⲈ ⲚⲈⲘ ⲦⲈϤⲔⲈⲮⲨⲬⲎ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲈⲢ ⲘⲀⲐⲎⲦⲎⲤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ⲪⲎ ⲈⲦⲈⲚϤⲚⲀⲦⲀⲖⲈ ⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲞϨ ⲚⲦⲈϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲈⲢⲘⲀⲐⲎⲦⲎⲤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ⲚⲒⲘ ⲄⲀⲢ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲞⲨⲰϢ ⲈⲔⲈⲦ ⲞⲨⲠⲨⲢⲄⲞⲤ ⲘⲎ ϤⲚⲀϨⲈⲘⲤⲒ ⲚϢⲞⲢⲠ ⲚⲦⲈϤϤⲒⲰⲠ ⲚϮⲆⲀⲠⲀⲚⲎ ϪⲈ ⲀⲚ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲘⲀⲨ ⲈⲈⲢ ⲠⲈϤⲤⲞⲂϮ ");
INSERT INTO copbhc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ϨⲒⲚⲀ ⲘⲎⲠⲰⲤ ⲚⲦⲈϤⲬⲀ ϮⲤⲈⲚϮ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲦⲞⲨⲈⲢϨⲎⲦⲤ ⲚⲤⲰⲂⲒ ⲘⲘⲞϤ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲢⲰⲘⲒ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚⲔⲰⲦ ⲞⲨⲞϨ ⲘⲠⲈϤϢϪⲈⲘϪⲞⲘ ⲚϪⲞⲔϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ⲒⲈ ⲚⲒⲘ ⲚⲞⲨⲢⲞ ⲈⲐⲚⲀϢⲈ ⲚⲀϤ ⲈⲠⲠⲞⲖⲈⲘⲞⲤ ⲈϮ ⲚⲈⲘ ⲔⲈⲞⲨⲢⲞ ⲘⲎ ϤⲚⲀϨⲈⲘⲤⲒ ⲀⲚ ⲚϢⲞⲢⲠ ⲚⲦⲈϤⲤⲞϬⲚⲒ ϪⲈ ⲀⲚ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ϦⲈⲚⲒⲚϢⲞ ⲈⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲘⲠⲈⲐⲚⲎ ⲞⲨ ⲈϪⲰϤ ⲚⲈⲘ ⲔⲚϢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ⲘⲘⲞⲚ ⲈⲦⲒ ⲒⲤϪⲈⲚ ⲈϤⲞⲨⲎⲞⲨ ⲘⲘⲞϤ ϢⲀϤⲞⲨⲰⲢⲠ ⲚⲞⲨⲠⲢⲈⲤⲂⲒⲀ ⲈϤⲔⲰϮ ⲚⲤⲀⲞⲨϨⲒⲢⲎ ⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ⲠⲀⲒⲢⲎϮ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈⲚϤⲚⲀⲈⲢⲀⲠⲞⲦⲀⲌⲈⲤⲐⲈ ⲀⲚ ⲚⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲦⲎⲢⲞⲨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲈⲢ ⲘⲀⲐⲎⲦⲎⲤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ⲚⲀⲚⲈ ⲠⲒϨⲘⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲚⲦⲈϤⲖⲰϤ ⲚϪⲈⲠⲒϨⲘⲞⲨ ⲀⲨⲚⲀⲘⲞⲖϨϤ ⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ⲞⲨⲆⲈ ⲠⲒⲔⲀϨⲒ ⲞⲨⲆⲈ ϮⲔⲞⲠⲢⲒⲀ ϤⲈⲢϢⲀⲨ ⲀⲚ ⲀⲖⲖⲀ ⲈϢⲀⲨϨⲒⲦϤ ⲈⲂⲞⲖ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲀϢϪ ⲘⲘⲞϤ ⲈⲤⲰⲦⲈⲘ ⲘⲀⲢⲈϤⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ⲚⲀⲨϦⲰⲚⲦ ⲆⲈ ⲘⲘⲰⲞⲨ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲦⲈⲖⲰⲚⲎⲤ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲈⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ⲞⲨⲞϨ ⲚⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ϢⲰⲠ ⲚⲚⲒⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲈⲢⲞϤ ⲞⲨⲞϨ ϤⲞⲨⲰⲘ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ⲀϤϪⲈ ⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ϪⲈ ⲚⲒⲘ ⲚⲢⲰⲘⲒ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲈϤ ⲢⲚⲈⲤⲰⲞⲨ ⲘⲘⲀⲨ ⲀϤϢⲀⲚⲦⲀⲔⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲘⲎ ⲘⲠⲀϤⲬⲀ ⲠⲒϤⲐ ⲚⲤⲰϤ ϨⲒ ⲠϢⲀϤⲈ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲈ ⲚⲀϤ ⲚⲦⲈϤⲔⲰϮ ⲚⲤⲀⲪⲎ ⲈⲦⲀϤⲦⲀⲔⲞ ϢⲀⲦⲈϤϪⲈⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ⲞⲨⲞϨ ⲀϤϢⲀⲚϪⲈⲘϤ ϢⲀϤⲦⲀⲖⲞϤ ⲈϪⲈⲚ ⲚⲈϤⲘⲞϮ ⲈϤⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ⲞⲨⲞϨ ⲀϤϢⲀⲚⲒ ⲈⲠⲒⲎⲒ ϢⲀϤⲘⲞⲨϮ ⲈⲚⲈϤϢⲪⲎⲢ ⲚⲈⲘ ⲚⲈϤⲐⲈϢⲈⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲢⲀϢⲒ ⲚⲈⲘⲎⲒ ⲦⲎⲢⲞⲨ ϪⲈ ⲀⲒϪⲒⲘⲒ ⲘⲠⲀⲈⲤⲰⲞⲨ ⲈⲦⲀϤⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲀϢⲒ ⲚⲀϢⲰⲠⲒ ϦⲈⲚⲦⲪⲈ ⲈϪⲈⲚ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚⲞⲨⲰⲦ ⲈϤⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲒⲈ ⲈϪⲈⲚ ⲠⲒϤⲐ ⲚⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ⲒⲈ ⲚⲒⲘ ⲚⲤϨⲒⲘⲒ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲈⲤ ⲒⲚϪⲈⲤⲔⲒϮ ⲘⲘⲀⲨ ⲈϢⲰⲠ ⲀⲤϢⲀⲚⲦⲀⲔⲈ ⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲘⲎ ⲘⲠⲀⲤϬⲈⲢⲈ ⲞⲨϦⲎⲂⲤ ⲞⲨⲞϨ ⲚⲦⲈⲤⲤⲀⲢϨ ⲠⲒⲎⲒ ⲞⲨⲞϨ ⲚⲦⲈⲤⲔⲰϮ ϦⲈⲚⲞⲨϤⲒⲢⲰⲞⲨϢ ϢⲀⲦⲈⲤϪⲈⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲤϢⲀⲚϪⲈⲘⲤ ϢⲀⲤⲘⲞⲨϮ ⲈⲚⲈⲤϢⲪⲎⲢ ⲚⲈⲘ ⲚⲈⲤⲐⲈϢⲈⲨ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲢⲀϢⲒ ⲚⲈⲘⲎⲒ ϪⲈ ⲀⲒϪⲒⲘⲒ ⲚⲦⲀϪⲈⲤⲔⲒϮ ⲈⲦⲀⲤⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ⲠⲀⲒⲢⲎϮ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϢⲀⲢⲈ ⲞⲨⲢⲀϢⲒ ϢⲰⲠⲒ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈϪⲈⲚ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚⲞⲨⲰⲦ ⲈϤⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲈⲞⲨⲞⲚⲦⲈϤ ϢⲎⲢⲒ ⲂⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲔⲞⲨϪⲒ ⲈⲦⲈⲚϦⲎⲦⲞⲨ ⲘⲠⲈϤⲒⲰⲦ ϪⲈ ⲠⲀⲒⲰⲦ ⲘⲞⲒ ⲚⲎⲒ ⲚⲦⲀⲦⲞⲒ ⲚⲦⲈϮⲞⲨⲤⲒⲀ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲪⲰϢ ⲘⲠⲒⲰⲚϦ ⲈϨⲢⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲀⲚ ⲀϤⲐⲰⲞⲨⲦ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚϪⲈⲠⲒⲔⲞⲨϪⲒ ⲚϢⲎⲢⲒ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ ⲈⲞⲨⲬⲰⲢⲀ ⲈⲤⲞⲨⲎⲞⲨ ⲞⲨⲞϨ ⲀϤϪⲈⲢ ⲦⲈϤⲞⲨⲤⲒⲀ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈϤⲞⲚϦ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ⲈⲦⲀϤⲞⲨⲰ ⲆⲈ ⲈϤϬⲞ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϨⲂⲰⲚ ϦⲈⲚϮⲬⲰⲢⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲐⲞϤ ϨⲰϤ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚⲈⲢϦⲀⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲦⲞⲘϤ ⲈⲞⲨⲀⲒ ⲚⲚⲒⲢⲈⲘⲂⲀⲔⲒ ⲚⲦⲈϮⲬⲰⲢⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠϤ ⲈⲦⲔⲞⲒ ⲈⲘⲞⲚⲒ ⲚϨⲀⲚⲈϢⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲘⲀϨ ϦⲎⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒϪⲒⲚⲒⲢⲒ ⲚⲎ ⲈⲚⲀⲨⲞⲨⲞⲘⲞⲨ ⲚϪⲈⲚⲒⲈϢⲀⲨ ⲞⲨⲞϨ ⲚⲈⲘⲘⲞⲚ ϨⲖⲒ ϮⲚⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ⲈⲦⲀ ⲠⲈϤϨⲎⲦ ⲆⲈ ⲒⲈⲢⲞϤ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲚⲢⲈⲘⲂⲈⲬⲈ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲠⲒⲰⲒⲔ ⲞⲒ ⲚϨⲞⲨⲞ ⲈⲢⲰⲞⲨ ⲀⲚⲞⲔ ⲆⲈ ϮⲚⲀⲦⲀⲔⲞ ⲘⲠⲀⲒⲘⲀ ϦⲈⲚⲞⲨϨⲂⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ϮⲚⲀⲦⲰⲚⲦ ⲚⲦⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲚⲦⲀϪⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲀⲒⲈⲢⲚⲞⲂⲒ ⲈⲦⲪⲈ ⲚⲈⲘ ⲠⲈⲔⲘⲐⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ⲚϮⲘⲠϢⲀ ⲀⲚ ϪⲈ ⲈⲐⲢⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲒ ϪⲈ ⲠⲈⲔϢⲎⲢⲒ ⲀⲢⲒⲦ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲒ ⲚⲚⲈⲔⲢⲈⲘⲂⲈⲬ Ⲉ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤⲒ ϨⲀ ⲠⲈϤⲒⲰⲦ ⲈⲦⲒ ⲆⲈ ⲒⲤϪⲈⲚ ⲈϤⲞⲨⲎⲞⲨ ⲘⲘⲞϤ ⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲠⲈϤⲒⲰⲦ ⲞⲨⲞϨ ⲀϤϢⲈⲚϨⲎⲦ ⲀϤϬⲞϪⲒ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲦⲈϤⲚⲀϨⲂⲒ ⲞⲨⲞϨ ⲀϤϮⲪⲒ ⲈⲢⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ⲠⲈϪⲈ ⲠⲈϤϢⲎⲢⲒ ⲆⲈ ⲚⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲀⲒⲈⲢⲚⲞⲂⲒ ⲈⲦⲪⲈ ⲚⲈⲘ ⲠⲈⲔⲘⲐⲞ ⲈⲂⲞⲖ ⲚϮⲘⲠϢⲀ ⲀⲚ ϪⲈ ⲈⲐⲢⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲒ ϪⲈ ⲠⲈⲔϢⲎ ⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ⲠⲈϪⲈ ⲠⲈϤⲒⲰⲦ ⲆⲈ ⲚⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲬⲰⲖⲈⲘ ⲀⲚⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲚϮϨⲞⲨⲒϮ ⲚⲤⲦⲞⲖⲎ ⲞⲨⲞϨ ⲘⲎⲒⲤ ϨⲒⲰⲦϤ ⲞⲨⲞϨ ⲘⲀ ⲞⲨϢϬⲞⲨⲢ ⲈⲦⲈϤϪⲒϪ ⲚⲈⲘ ⲞⲨⲐⲰⲞⲨⲒ ⲈⲚⲈϤϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒ ⲘⲠⲒⲘⲀⲤⲒ ⲈⲦϢⲀⲚⲈⲨϢ ϢⲀⲦϤ ⲞⲨⲞϨ ⲚⲦⲈⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈⲚⲞⲨⲚⲞϤ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ϪⲈ ⲠⲀϢⲎⲢⲒ ⲪⲀⲒ ⲚⲀϤⲘⲰⲞⲨⲦ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲰⲚϦ ⲚⲀϤⲦⲀⲔⲎⲞⲨⲦ ⲠⲈ ⲞⲨⲞϨ ⲀⲚϪⲈⲘϤ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲞⲨⲚⲞϤ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ⲠⲈϤⲚⲒϢϮ ⲆⲈ ⲚϢⲎⲢⲒ ⲚⲀϤⲬⲎ ϦⲈⲚⲦⲔⲞⲒ ⲞⲨⲞϨ ϨⲰⲤ ⲈϤⲚⲎⲞⲨ ⲈϨⲢⲎⲒ ⲀϤϦⲰⲚⲦ ⲈⲠⲒⲎⲒ ⲀϤⲤⲰⲦⲈⲘ ⲈⲞⲨⲤⲨⲘⲪⲰⲚⲒⲀ ⲚⲈⲘ ϨⲀⲚⲬⲞⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲞⲨⲀⲒ ⲚⲚⲒⲀⲖⲰⲞⲨⲒ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲞⲨ ⲚⲈⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈⲔⲤⲞⲚ ⲀϤⲒ ⲞⲨⲞϨ ⲠⲈⲔⲒⲰⲦ ϢⲰⲦ ⲘⲠⲒⲘⲀⲤⲒ ⲈⲦϢⲀⲚⲈⲨϢ ϪⲈ ⲀϤϬⲒⲦϤ ⲈϤⲞⲨⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ⲀϤϪⲰⲚⲦ ⲆⲈ ⲞⲨⲞϨ ⲘⲠⲈϤⲞⲨⲰϢ ⲈⲒ ⲈϦⲞⲨⲚ ⲠⲈϤⲒⲰⲦ ⲆⲈ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲘⲠⲈϤⲒⲰⲦ ϪⲈ ⲒⲤ ⲞⲨⲎⲢ ⲚⲢⲞⲘⲠⲒ ϮⲞⲒ ⲘⲂⲰⲔ ⲚⲀⲔ ⲞⲨⲞϨ ⲘⲠⲒⲈⲢⲤⲀⲂⲞⲖ ⲚⲞⲨⲈⲚⲦⲞⲖⲎ ⲚⲦⲀⲔ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲘⲠⲈⲔϮ ⲚⲞⲨⲘⲀⲤⲒ ⲘⲂⲀⲈⲘⲠⲒ ⲚⲎⲒ ⲈⲚⲈϨ ϨⲒⲚⲀ ⲚⲦⲀⲞⲨⲚⲞϤ ⲘⲘⲞⲒ ⲚⲈⲘ ⲚⲀϢⲪⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀϤⲒ ⲚϪⲈⲠⲈⲔϢⲎⲢⲒ ⲪⲀⲒ ⲈⲦⲀϤⲞⲨⲰⲘ ⲘⲠⲈϤⲰⲚϦ ⲚⲈⲘ ⲚⲒⲠⲞⲢⲚⲞⲤ ⲀⲔϢⲰⲦ ⲚⲀϤ ⲘⲠⲒⲘⲀⲤⲒ ⲈⲦϢⲀⲚⲈⲨϢ ");
INSERT INTO copbhc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϢⲎⲢⲒ ⲚⲐⲞⲔ ⲬⲎ ⲚⲈⲘⲎⲒ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲚⲞⲨⲒ ⲦⲎⲢⲞⲨ ⲚⲞⲨⲔ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ⲚⲀⲤⲘⲠϢⲀ ⲚⲦⲈⲚⲞⲨⲚⲞϤ ⲘⲘⲞⲚ ⲞⲨⲞϨ ⲚⲦⲈⲚⲢⲀϢⲒ ϪⲈ ⲠⲈⲔⲤⲞⲚ ⲪⲀⲒ ⲚⲀϤⲘⲰⲞⲨⲦ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲰⲚϦ ⲚⲀϤⲦⲀⲔⲎⲞⲨⲦ ⲠⲈ ⲞⲨⲞϨ ⲀⲚϪⲈⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲀⲘⲀⲞ ⲈⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲞⲨⲞϨ ⲪⲀⲒ ⲀⲨⲈⲢⲆⲒⲀⲂⲞⲖⲒⲚ ⲘⲘⲞϤ ϦⲀⲦⲞⲦϤ ϨⲰⲤ ⲈϤϪⲰⲢ ⲚⲚⲈϤϨⲨⲠⲀⲢⲬ ⲞⲚⲦⲀ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈϮⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈⲐⲂⲎⲦⲔ ⲘⲀ ⲠⲰⲠ ⲚϮⲘⲈⲦⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲞⲨ ⲄⲀⲢ ⲬⲚⲀⲈⲢⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲀⲚ ϪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ⲠⲈϪⲀϤ ⲆⲈ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲚϪⲈⲠⲒⲞⲒⲔⲞⲚⲞⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ⲠⲀϬⲞⲒⲤ ⲚⲀⲰⲖⲒ ⲚϮⲘⲈⲦⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲦⲞⲦ ⲚϮⲚⲀϢϪⲈⲘϪⲞⲘ ⲀⲚ ⲈϬⲢⲎ ⲞⲨⲞϨ ϮϢⲒⲠⲒ ⲈϢⲀⲦ ⲘⲈⲐⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ⲀⲒⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ϨⲒⲚⲀ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚϨⲒⲦ ⲈⲂⲞⲖ ϦⲈⲚϮⲘⲈⲦⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲤⲈϢⲞⲠⲦ ⲈⲢⲰⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲞⲨⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲚⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲈⲠⲈϤϬⲞⲒⲤ ⲈⲢⲰⲞⲨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲘⲠⲒϨⲞⲨⲒⲦ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲈⲢⲞⲔ ⲚⲦⲈⲠⲀϬⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲢⲘⲂⲀⲦⲞⲤ ⲚⲚⲈϨ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲞ ⲈⲚⲈⲔⲤϦⲀⲒ ⲞⲨⲞϨ ϨⲈⲘⲤⲒ ⲚⲬⲰⲖⲈⲘ ⲤϦⲀⲒ ⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ⲒⲦⲀ ⲠⲈϪⲀϤ ⲚⲔⲈⲞⲨⲀⲒ ϪⲈ ⲚⲐⲞⲔ ⲆⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲈⲢⲞⲔ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ Ⲣ- ⲚⲔⲞⲢⲞⲤ ⲚⲤⲞⲨⲞ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞ ⲈⲚⲈⲔⲤϦⲀⲒ ⲞⲨⲞϨ ⲤϦⲀⲒ ⲈⲠ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ⲞⲨⲞϨ ⲀⲠϬⲞⲒⲤ ϢⲞⲨϢⲞⲨ ⲈϪⲈⲚ ⲠⲒⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲦⲈϮⲀⲆⲒⲔⲒⲀ ϪⲈ ⲀϤⲒⲢⲒ ϦⲈⲚⲞⲨⲘⲈⲦⲤⲀⲂⲈ ϪⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ϨⲀⲚⲤⲀⲂⲈⲨ ⲚⲈⲈϨⲞⲦⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲞⲨⲰⲒⲚⲒ ϦⲈⲚⲦⲞⲨⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲀⲐⲀⲘⲒⲞ ⲚⲰⲦⲈⲚ ⲚϨⲀⲚϢⲪⲎⲢ ⲈⲂⲞⲖ ϦⲈⲚⲘⲀⲘⲰⲚⲀ ⲚⲦⲈⲦⲀⲆⲒⲔⲒⲀ ϨⲒⲚⲀ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲘⲞⲨⲚⲔ ⲚⲦⲞⲨϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒⲤⲔⲨⲚⲎ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ⲠⲒⲠⲒⲤⲦⲞⲤ ϦⲈⲚⲞⲨⲔⲞⲨϪⲒ ⲞⲨⲠⲒⲤⲦⲞⲤ ⲞⲚ ⲠⲈ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϬⲒⲚϪⲞⲚⲤ ϦⲈⲚⲞⲨⲔⲞⲨϪⲒ ϤϬⲒⲚϪⲞⲚⲤ ⲞⲚ ϦⲈⲚⲞⲨⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ⲒⲤϪⲈ ⲞⲨⲚ ϦⲈⲚⲠⲒⲀⲆⲒⲔⲞⲤ ⲘⲀⲘⲰⲚⲀ ⲘⲠⲈⲦⲈⲚϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲚϨⲞⲦ ⲠⲒⲦⲀⲪⲘⲎⲒ ⲆⲈ ⲚⲒⲘ ⲈⲐⲚⲀϢⲦⲈⲚϨⲈⲦ ⲐⲎⲚⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ⲞⲨⲞϨ ⲒⲤϪⲈ ϦⲈⲚⲠⲈⲦⲈⲪⲰⲦⲈⲚ ⲀⲚ ⲠⲈ ⲘⲠⲈⲦⲈⲚϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲚϨⲞⲦ ⲠⲈⲦⲈⲪⲰⲦⲈⲚ ⲚⲒⲘ ⲈⲐⲚⲀϢⲦⲎⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ⲘⲘⲞⲚ ϨⲖⲒ ⲘⲂⲰⲔ ⲚⲀϢϪⲈⲘϪⲞⲘ ⲚⲈⲢⲂⲰⲔ ⲚϬⲞⲒⲤ ⲂⲒⲈ ⲄⲀⲢ ⲚⲦⲈϤⲘⲈⲤⲦⲈ ⲞⲨⲀⲒ ⲞⲨⲞϨ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲚⲦⲈϤⲘⲈⲚⲢⲒⲦϤ ⲒⲈ ⲚⲦⲈϤⲤⲰⲦⲈⲘ ⲚⲤⲀⲞⲨⲀⲒ ⲞⲨⲞϨ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲚⲦⲈϤⲈⲢⲔⲀⲦⲀⲪⲢⲞⲚⲒⲚ ⲘⲘⲞϤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲈⲢⲂⲰⲔ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲘⲀⲘⲰⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ⲚⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲦⲞⲒ ⲘⲘⲀⲒϨⲀⲦ ⲞⲨⲞϨ ⲚⲀⲨⲈⲖⲔϢⲀⲒ ⲚⲤⲰϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲈⲚⲎ ⲈⲦⲐⲘⲀⲒⲞ ⲘⲘⲰⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲢⲰⲘⲒ ⲪⲚⲞⲨϮ ⲆⲈ ϤⲤⲰⲞⲨⲚ ⲚⲚⲈⲦⲈⲚϨⲎⲦ ϪⲈ ⲠϬⲒⲤⲒ ⲚϨⲎ ⲦⲈⲦϦⲈⲚ ⲠⲒⲢⲰⲘⲒ ⲞⲨⲤⲰϤ ⲠⲈ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϢⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲒⲤϪⲈⲚ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲈϨⲒⲰⲒϢ ⲘⲘⲞⲤ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲤⲈϬⲒ ⲘⲘⲞϤ ⲚϪⲞⲚⲤ ⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ⲤⲘⲞⲦⲈⲚ ⲆⲈ ⲚⲦⲈⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲤⲒⲚⲒ ⲈϨⲞⲦⲈ ⲚⲦⲈⲞⲨⲔⲈⲢⲈⲀ ϨⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϨⲒⲞⲨⲒ ⲚⲦⲈϤⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦϬⲒ ⲚⲔⲈⲞⲨⲀⲒ ϤⲞⲒ ⲚⲚⲰⲒⲔ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϬⲒ ⲚⲐⲎ ⲈⲦϨⲰⲞⲨⲒ ⲈⲂⲞⲖ ⲚⲦⲈⲚ ⲠⲈⲤϨⲀⲒ ϤⲞⲒ ⲚⲚⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲠⲈ ⲚⲢⲀⲘⲀⲞ ⲞⲨⲞϨ ⲚⲈϢⲀϤϮ ⲚⲞⲨⲠⲞⲢⲪⲨⲢⲀ ϨⲒⲰⲦϤ ⲚⲈⲘ ⲞⲨϢⲈⲚⲤ ⲈϤⲞⲨⲚⲞϤ ⲘⲘⲎⲒⲚⲒ ϦⲈⲚⲞⲨⲤⲞⲖⲤⲈⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ⲞⲨϨⲎⲔⲒ ⲆⲈ ϨⲰϤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲈϤϨⲰⲞⲨⲒ ⲈⲠⲈϤⲠⲨⲖⲰⲚ ⲈϤⲞⲒ ⲚϢⲀϢ ");
INSERT INTO copbhc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ⲞⲨⲞϨ ⲈϤⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲘⲀϨ ϦⲎⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈϢⲀⲨϨⲈⲒ ⲈⲂⲞⲖ ϨⲒ ϮⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲠⲒⲢⲀⲘⲀⲞ ⲀⲖⲖⲀ ⲚⲒⲔⲈⲞⲨϨⲰⲢ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲨⲖⲰϪϨ ⲚⲚⲈϤϢⲀϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲐⲢⲈϤⲘⲞⲨ ⲚϪⲈⲠⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲞⲖϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲀⲄⲄⲈⲖⲞⲤ ⲈⲔⲈⲚϤ ⲚⲀⲂⲢⲀⲀⲘ ⲀϤⲘⲞⲨ ⲆⲈ ϨⲰϤ ⲚϪⲈⲠⲒⲢⲀⲘⲀⲞ ⲞⲨⲞϨ ⲀⲨⲔⲞⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ⲞⲨⲞϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲀⲘⲈⲚϮ ⲈⲦⲀϤϤⲀⲒ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲈϤⲬⲎ ϦⲈⲚϨⲀⲚⲘⲔⲀⲨϨ ⲀϤⲚⲀⲨ ⲈⲀⲂⲢⲀⲀⲘ ϨⲒⲪⲞⲨⲈⲒ ⲞⲨⲞϨ ⲖⲀⲌⲀⲢⲞⲤ ϦⲈⲚⲔⲈⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲈⲦⲀϤⲘⲞⲨϮ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ⲚⲀⲒ ⲚⲎⲒ ⲞⲨⲞϨ ⲞⲨⲰⲢⲠ ⲚⲖⲀⲌⲀⲢⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤⲤⲈⲠ ϨⲐⲎϤ ⲘⲠⲈϤⲦⲎⲂ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϤϮⲬⲂⲞⲂ ⲘⲠⲀⲖⲀⲤ ϪⲈ ϮⲘⲞⲔϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒϢⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ⲠⲈϪⲈ ⲀⲂⲢⲀⲀⲘ ϪⲈ ⲠⲀϢⲎⲢⲒ ⲀⲢⲒⲪⲘⲈⲨⲒ ϪⲈ ⲀⲔⲞⲨⲰ ⲈⲔϬⲒ ⲚⲚⲈⲔⲀⲄⲀⲐⲞⲚ ϦⲈⲚⲠⲈⲔⲰⲚϦ ⲞⲨⲞϨ ⲖⲀⲌⲀⲢⲞⲤ ϨⲰϤ ⲚⲚⲒⲠⲈⲦϨⲰⲞⲨ ϮⲚⲞⲨ ⲆⲈ ⲤⲈⲐⲰⲦ ⲘⲠⲈϤϨⲎⲦ ⲘⲠⲀⲒⲘⲀ ⲚⲐⲞⲔ ⲆⲈ ⲬⲎ ϦⲈⲚⲞⲨⲘⲔⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ⲞⲨⲞϨ ϦⲈⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲚϢⲒⲔ ⲈϤⲦⲀϪⲢⲎⲞⲨⲦ ⲞⲨⲦⲰⲚ ⲚⲈⲘⲰⲦⲈⲚ ϨⲞⲠⲰⲤ ⲚⲎ ⲈⲐⲞⲨⲰϢ ⲈⲤⲒⲚⲒ ⲈⲂⲞⲖ ⲦⲀⲒ ϨⲀⲢⲰⲦⲈⲚ ⲚⲦⲞⲨϢⲦⲈⲘϪⲈⲘϪⲞⲘ ⲞⲨⲆⲈ ⲚⲎ ⲈⲦϨⲀⲢⲰⲦⲈⲚ ⲈⲈⲢϪⲒⲚⲒⲞⲢ ϨⲀⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ϮϮϨⲞ ⲈⲢⲞⲔ ⲠⲀⲒⲰⲦ ϨⲒⲚⲀ ⲚⲦⲈⲔⲞⲨⲞⲢⲠϤ ⲈⲠⲎⲒ ⲘⲠⲀⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ⲞⲨⲞⲚ ⲄⲀⲢ ⲈⲚⲤⲞⲚ ⲚⲦⲎⲒ ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘⲒ ϨⲰⲞⲨ ⲈⲠⲀⲒⲘⲀ ⲚⲦⲈⲠⲀⲒⲘⲔⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ⲠⲈϪⲀϤ ⲆⲈ ⲚϪⲈⲀⲂⲢⲀⲀⲘ ϪⲈ ⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲘⲘⲀⲨ ⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲘⲀⲢⲞⲨⲤⲰⲦⲈⲘ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ ⲠⲀⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ϢⲈ ⲚⲀϤ ϨⲀⲢⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲤⲈⲚⲀⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲤⲈⲚⲀⲤⲰⲦⲈⲘ ⲀⲚ ⲚⲤⲀⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲞⲨⲆⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲠⲞⲨϨⲎⲦ ⲚⲀⲐⲰⲦ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲰϮ ⲚⲦⲞⲨⲒ ⲚϪⲈⲚⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲪⲎ ⲈⲦⲈ ⲠⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ⲚⲀⲚⲈⲤ ⲚⲀϤ ⲚⲦⲞⲨⲈϢ ⲞⲨⲰⲚⲒ ⲘⲘⲞⲨⲖⲞⲚ ⲈϦⲎⲦϤ ⲞⲨⲞϨ ⲚⲦⲞⲨϨⲒⲦϤ ⲈϦⲢⲎⲒ ⲈⲪⲒⲞⲘ ⲈϨⲞⲦⲈ ⲚⲦⲈϤⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲚⲞⲨⲀⲒ ⲚⲚⲀⲒⲔⲞⲨϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲀⲢⲈϢⲀⲚ ⲠⲈⲔⲤⲞⲚ ⲈⲢⲚⲞⲂⲒ ⲀⲢⲒⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲬⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲈⲢⲚⲞⲂⲒ ⲈⲢⲞⲔ ⲚⲌ ⲚⲤⲞⲠ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈϤⲔⲞⲦϤ ⲈⲢⲞⲔ ⲚⲌ ⲚⲤⲞⲠ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲬⲰ ⲚⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲠϬⲞⲒⲤ ϪⲈ ⲞⲨⲀϨⲚⲀϨϮ ⲈⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ϪⲈ ⲈⲚⲈ ⲞⲨⲞⲚⲦⲈⲦⲈⲚ ⲚⲀϨϮ ⲘⲘⲀⲨ ⲘⲪⲢⲎϮ ⲚⲞⲨⲚⲀⲪⲢⲒ ⲚϢⲈⲖⲦⲀⲘ ⲚⲀⲢⲈⲦⲈⲚⲚⲀϪⲞⲤ ⲚϮⲚⲞⲨϨⲒ ϪⲈ ϤⲰϪⲒ ⲞⲨⲞϨ ⲢⲰⲦ ϦⲈⲚⲪⲒⲞⲘ ⲞⲨⲞϨ ⲚⲀⲤⲚⲀⲤⲰⲦⲈⲘ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ⲚⲒⲘ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲈϤ ⲞⲨⲂⲰⲔ ⲘⲘⲀⲨ ⲈϤⲤⲬⲀⲒ ⲒⲈ ⲈϤⲘⲞⲚⲒ ⲪⲎ ⲈⲦⲈ ⲀϤϢⲀⲚⲒ ⲈϦⲞⲨⲚ ⲈⲂⲞⲖ ϦⲈⲚⲦⲔⲞⲒ ⲘⲎ ϤⲚⲀϪⲞⲤ ⲚⲀϤ ⲤⲀⲦⲞⲦϤ ϪⲈ ⲀⲘⲞⲨ ⲈⲠϢⲰⲒ ⲢⲰⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ⲘⲎ ϤⲚⲀϪⲞⲤ ⲚⲀϤ ⲀⲚ ϪⲈ ⲤⲞⲂϮ ⲘⲪⲎ ⲈϮⲚⲀⲞⲨⲞⲘϤ ⲞⲨⲞϨ ⲘⲞⲢⲔ ϢⲈⲘϢⲒ ⲘⲘⲞⲒ ϢⲀϮⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲀⲤⲰ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ϨⲰⲔ ⲚⲦⲈⲔⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈⲔⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ⲘⲎ ⲞⲨⲞⲚ ϨⲘⲞⲦ ⲈⲢⲞϤ ⲚⲦⲈⲠⲒⲂⲰⲔ ϪⲈ ⲀϤⲒⲢⲒ ⲚⲚⲎ ⲈⲦⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲰⲞⲨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲒⲢⲒ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲰⲞⲨ ⲚⲰⲦⲈⲚ ⲀϪⲞⲤ ϪⲈ ⲀⲚⲞⲚ ϨⲀⲚⲂⲰⲔ ⲚⲀⲦϢⲀⲨ ⲠⲈⲦⲈⲢⲞⲚ ⲈⲀⲒϤ ⲀⲚⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ⲀⲤϢⲰⲠⲒ ⲈϤϢⲈ ⲚⲀϤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲚⲀϤⲤⲒⲚⲒⲰⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲦⲈ ⲐⲘⲎϮ ⲚⲦⲀⲤⲀⲘⲀⲢⲒⲀ ⲚⲈⲘ ϮⲄⲀⲖⲒⲖⲈⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ⲞⲨⲞϨ ⲈϤⲚⲀϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲞⲨϮⲘⲒ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲚϪⲈⲒⲚⲢⲰⲘⲒ ⲚⲔⲀⲔⲤⲈϨⲦ ⲞⲨⲞϨ ⲚⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϨⲒⲪⲞⲨⲈⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲚⲀⲨϬⲒⲤⲒ ⲚⲦⲞⲨⲤⲘⲎ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲀⲒ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲘⲀⲦⲀⲘⲈ ⲠⲒⲞⲨⲎⲂ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲨϢⲈ ⲚⲰⲞⲨ ⲀⲨⲦⲞⲨⲂⲞ ");
INSERT INTO copbhc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ⲞⲨⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲦⲀϤⲚⲀⲨ ϪⲈ ⲀϤⲖⲞϪϤ ⲀϤⲦⲀⲤⲐⲞ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲈϤϮⲰⲞⲨ ⲘⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ⲞⲨⲞϨ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ϦⲀⲦⲈⲚ ⲚⲈϤϬⲀⲖⲀⲨϪ ⲈϤϢⲈⲠϨⲘⲞⲦ ⲚⲦⲞⲦϤ ⲞⲨⲞϨ ⲪⲀⲒ ⲚⲈⲞⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲘⲎ ⲘⲠⲈ ⲠⲒⲒ ⲦⲞⲨⲂⲞ ⲠⲒⲔⲈⲐ ⲀⲨⲐⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ⲞⲨⲞϨ ⲘⲠⲞⲨϪⲈⲘⲞⲨ ⲈⲀⲨⲔⲞⲦⲞⲨ ⲈϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈⲂⲎⲖ ⲈⲪⲀⲒ ⲀⲖⲖⲞⲄⲈⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲠⲈⲔⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲈⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ⲈⲦⲀⲨϢⲈⲚϤ ⲆⲈ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲀⲤⲚⲀⲒ ⲚⲐⲚⲀⲨ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲢⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲒ ⲀⲚ ϦⲈⲚⲞⲨⲘⲈⲦⲢⲈϤϮ ϨⲐⲎϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ⲞⲨⲆⲈ ⲤⲈⲚⲀϪⲞⲤ ⲀⲚ ϪⲈ ⲤⲦⲀⲒ ⲒⲈ ⲤⲦⲎ ϨⲎⲠⲠⲈ ⲄⲀⲢ ⲒⲤ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲀϦⲞⲨⲚ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲤⲈⲚⲎ ⲞⲨ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ϨⲞⲦⲈ ⲈⲢⲈⲦⲈⲚⲚⲀⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲚⲀⲨ ⲈⲞⲨⲀⲒ ⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲞⲨⲞϨ ⲚⲚⲈⲦⲈⲚⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ⲞⲨⲞϨ ⲈⲨⲈϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲎⲠⲠⲈ ϤⲦⲎ ⲒⲈ ϤⲦⲀⲒ ⲘⲠⲈⲢϢⲈ ⲚⲰⲦⲈⲚ ⲞⲨⲆⲈ ⲘⲠⲈⲢϬⲞϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ⲘⲪⲢⲎϮ ⲘⲠⲒⲤⲈⲦⲈⲂⲢⲎϪ ⲈϢⲀϤⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲢⲞⲨⲰⲒⲚⲒ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲦⲪⲈ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲈⲦⲈ ⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲀϢⲰⲠⲒ ⲘⲘⲞϤ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲈϤⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ϢⲞⲢⲠ ⲆⲈ ϨⲰϮ ⲈⲢⲞϤ ⲚⲦⲈϤϬⲒ ⲞⲨⲘⲎ ϢⲚϦⲒⲤⲒ ⲞⲨⲞϨ ⲚⲤⲈϢⲞϢϤ ⲚϪⲈⲦⲀⲒⲄⲈⲚⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲰⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ⲚⲀⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲀⲨⲤⲰ ⲚⲀⲨϬⲒ ⲤϨⲒⲘⲒ ⲚⲀⲨϬⲒ ϨⲀⲒ ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲀ ⲚⲰⲈ ϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈϮⲔⲒⲂⲰⲦⲞⲤ ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲠⲒⲔⲀⲦⲀⲔⲖⲨⲤⲘⲞⲤ ⲞⲨⲞϨ ⲀϤⲦⲀⲔⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ⲘⲪⲢⲎϮ ⲞⲚ ⲈⲦⲀⲤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲖⲰⲦ ⲚⲀⲨⲞⲨⲰⲘ ⲚⲀⲨⲤⲰ ⲚⲀⲨϢⲰⲠ ⲚⲀⲨϮ ⲈⲂⲞⲖ ⲚⲀⲨϬⲞ ⲚⲀⲨⲔⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲀ ⲖⲰⲦ Ⲓ- ⲈⲂⲞⲖ ϦⲈⲚⲤⲞⲆⲞⲘⲀ ⲀϤϨⲰⲞⲨ ⲚⲞⲨⲬⲢⲰⲘ ⲚⲈⲘ ⲞⲨⲐⲎⲚ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲀϤⲦⲀⲔⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ⲔⲀⲦⲀ ⲚⲀⲒ ⲢⲰ ⲞⲚ ⲀⲤⲚⲀϢⲰⲠⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲎ ⲈⲦⲬⲎ ϨⲒϪⲈⲚ ⲠϪⲈⲚⲈⲪⲰⲢ ⲞⲨⲞϨ ⲈⲢⲈ ⲚⲈϤⲤⲔⲈⲨⲞⲤ ϦⲈⲚⲠⲒⲎⲒ ⲘⲠⲈⲚⲐⲢⲈϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲞⲖⲞⲨ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲬⲎ ϦⲈⲚⲦⲔⲞⲒ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲘⲠⲈⲚⲐⲢⲈϤⲔⲞⲦϤ ⲈⲪⲀϨⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ⲀⲢⲒⲪⲘⲈⲨⲒ ⲚⲦⲤϨⲒⲘⲒ ⲚⲖⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ⲪⲎ ⲈⲐⲚⲀⲔⲰϮ ⲚⲤⲀⲚⲞϨⲈⲘ ⲚⲦⲈϤⲮⲨⲬⲎ ϤⲚⲀⲦⲀⲔⲞⲤ ⲪⲎ ⲈⲐⲚⲀⲦⲀⲔⲞⲤ ⲈϤⲈⲦⲀⲚϦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲈϪⲰⲢϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈⲂϨⲒϪⲈⲚ ⲞⲨϬⲖⲞϪ ⲚⲞⲨⲰⲦ ⲠⲒⲞⲨⲀⲒ ⲈⲨⲈⲞⲖϤ ⲞⲨⲞϨ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲈⲨⲈⲬⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈⲤⲚⲞⲨϮ ⲈⲨⲚⲞⲨⲦ ϦⲈⲚⲞⲨⲘⲀ ⲞⲨⲒ ⲈⲨⲈⲞⲖⲤ ⲞⲨⲞϨ ϮⲔⲈⲞⲨⲒ ⲈⲨⲈⲬⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ⲞⲨⲞϨ ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ϦⲈⲚⲀϢ ⲘⲘⲀ ⲠϬⲞⲒⲤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲒⲘⲀ ⲈⲦⲈ ⲠⲤⲰⲘⲀ ⲘⲘⲞϤ ⲤⲈⲚⲀⲐⲰⲞⲨϮ ⲈⲘⲀⲨ ⲚϪⲈⲚⲒⲔⲈⲀϦⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ⲚⲀϤϪⲰ ⲆⲈ ⲚⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲰⲞⲨ ⲈⲠϪⲒⲚⲦⲞⲨⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘⲈⲢⲈⲚⲔⲀⲔⲒⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲈϤϮϨⲀⲠ ⲠⲈ ϦⲈⲚⲞⲨⲂⲀⲔⲒ ⲚϤⲈⲢϨⲞϮ ⲀⲚ ϦⲀⲦϨⲎ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚϤϢⲒⲠⲒ ⲀⲚ ϦⲀⲦϨⲎ ⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲬⲎⲢⲀ ⲆⲈ ⲠⲈ ϦⲈⲚϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲀⲤⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲠⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϬⲒ ⲘⲠⲀⲘϢⲒϢ ⲚⲈⲘ ⲪⲎ ⲈⲦϬⲒ ⲘⲘⲞⲒ ⲚϪⲞⲚⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ⲞⲨⲞϨ ⲚⲀϤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ϢⲀ ⲞⲨⲤⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲠⲈϪⲀϤ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ϪⲈ ⲬⲀⲤ ϪⲈ ⲪⲚⲞⲨϮ ϮⲈⲢϨⲞϮ ⲀⲚ ϦⲀⲦⲈϤϨⲎ ⲞⲨⲞϨ ⲚϮϢⲒⲠⲒ ⲀⲚ ϦⲀⲦϨⲎ ⲚⲚⲒⲢⲰⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ⲈⲐⲂⲈϪⲈ ⲦⲀⲒⲬⲎⲢⲀ ϮϦⲒⲤⲒ ⲚⲎⲒ ϮⲚⲀϬⲒ ⲘⲠⲈⲤⲘϢⲒϢ ϨⲒⲚⲀ ⲚⲦⲈⲤϢⲦⲈⲘⲒ ϢⲀ ⲈⲂⲞⲖ ⲈⲤϮϦⲒⲤⲒ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ϪⲈ ⲤⲰⲦⲈⲘ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ⲠⲒⲢⲈϤϮϨⲀⲠ ⲚⲦⲈϮⲀⲆⲒⲔⲒⲀ ϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ⲪⲚⲞⲨϮ ⲆⲈ ϤⲚⲀϬⲒ ⲘⲠⲈⲘϢⲒϢ ⲀⲚ ⲚⲚⲈϤⲤⲰⲦⲠ ⲚⲀⲒ ⲈⲦⲰϢ ⲞⲨⲂⲎϤ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲈⲘ ⲠⲒⲈϪⲰⲢϨ ⲞⲨⲞϨ ϤⲰⲞⲨⲚϨⲎⲦ ⲈϪⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ⲤⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϤⲚⲀϬⲒ ⲘⲠⲞⲨⲘϢⲒϢ ⲚⲬⲰⲖⲈⲘ ⲠⲖⲎⲚ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲀϤϢⲀⲚⲒ ϨⲀⲢⲀ ϤⲚⲀϪⲈⲘ ⲪⲚⲀϨϮ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ⲀϤϪⲞⲤ ⲈⲐⲂⲈ ϨⲀⲚⲞⲨⲞⲚ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲐⲘⲎⲒ ⲚⲈⲞⲨⲞϨ ⲈⲨϢⲞϢϤ ⲚⲚⲒⲔⲈⲤⲰϪⲠ ⲚⲦⲀⲠⲀⲢⲀⲂⲞⲖⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ⲀⲢⲰⲘⲒ ⲂϢⲈ ⲚⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲠⲒⲞⲨⲀⲒ ⲚⲈⲞⲨⲪⲀⲢⲒⲤⲈⲞⲤ ⲠⲈ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲚⲈⲞⲨⲦⲈⲖⲰⲚⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ⲠⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲈⲦⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲀⲒ ⲚⲀϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲘⲘⲰⲞⲨ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ϪⲈ ⲪⲚⲞⲨϮ ϮϢⲈⲠϨⲘⲞⲦ ⲚⲦⲞⲦⲔ ϪⲈ ϮⲞⲒ ⲀⲚ ⲘⲪⲢⲎϮ ⲘⲠⲤⲰϪⲠ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲢⲈϤϨⲰⲖⲈⲘ ⲚⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲚⲚⲰⲒⲔ ⲒⲈ ⲘⲪⲢⲎϮ ⲘⲠⲀⲒⲔⲈⲦⲈⲖⲰⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ϮⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲚⲤⲞⲠⲂ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ϮϮ ⲘⲪⲢⲈⲘⲎⲦ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈϮϪⲪⲞ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ⲠⲒⲦⲈⲖⲰⲚⲎⲤ ⲆⲈ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ϨⲒⲪⲞⲨⲈⲒ ⲚⲀϤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲞⲨⲆⲈ ⲈϤⲀⲒ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲀⲖⲖⲀ ⲚⲀϤⲔⲰⲖϨ ⲠⲈ ϦⲈⲚⲦⲈϤⲘⲈⲤⲦⲈⲚϨⲎⲦ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲚⲞⲨϮ ⲬⲰ ⲚⲎⲒ ⲈⲂⲞⲖ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲪⲀⲒ ϢⲈ ⲚⲀϤ ⲈⲠⲈⲤⲎⲦ ⲈϤⲐⲘⲀⲒⲎⲞⲨⲦ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ⲈϨⲞⲦⲈ ⲪⲎ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϬⲀⲤϤ ⲤⲈⲚⲀⲐⲈⲂⲒⲞϤ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀⲐⲈⲂⲒⲞϤ ⲤⲈⲚⲀϬⲀⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ⲚⲀⲨⲒⲚⲒ ⲆⲈ ⲚⲀϤ ⲚϨⲀⲚⲀⲖⲰⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲨⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀ ⲚⲒⲀⲖⲰⲞⲨⲒ ⲚⲦⲞⲨⲒ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ ⲚⲒⲞⲨⲞⲚ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲎϮ ⲐⲰⲞⲨ ⲦⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϢⲈⲠ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲢⲞϤ ⲀⲚ ⲘⲪⲢⲎϮ ⲘⲠⲀⲒⲀⲖⲞⲨ ⲚⲚⲈϤⲒ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ⲞⲨⲞϨ ⲀϤϢⲈⲚϤ ⲚϪⲈⲞⲨⲀⲢⲬⲰⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲀⲄⲀⲐⲞⲤ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ⲚⲦⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ");
INSERT INTO copbhc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲒ ϪⲈ ⲠⲒⲀⲄⲀⲐⲞⲤ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲄⲀⲐⲞⲤ ⲈⲂⲎⲖ ⲈⲪⲚⲞⲨϮ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ⲚⲒⲈⲚⲦⲞⲖⲎ ⲔⲤⲰⲞⲨⲚ ⲘⲘⲰⲞⲨ ⲘⲠⲈⲢⲈⲢⲚⲰⲒⲔ ⲘⲠⲈⲢϦⲰⲦⲈⲂ ⲘⲠⲈⲢϬⲒⲞⲨⲒ ⲘⲠⲈⲢⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ⲘⲀⲦⲀⲒⲈ ⲠⲈⲔⲒⲰⲦ ⲚⲈⲘ ⲦⲈⲔⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲀⲒⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲒⲤϪⲈⲚ ⲦⲀⲘⲈⲦⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲦⲒ ⲔⲈⲞⲨⲀⲒ ⲠⲈ ⲈⲦⲈⲔϢⲀⲦ ⲘⲘⲞϤ ⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲀⲔ ⲘⲎⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲤⲞⲢⲞⲨ ⲚⲚⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲈⲔⲈϪⲪⲞ ⲚⲀⲔ ⲚⲞⲨⲀϨⲞ ϦⲈⲚⲚⲒⲪⲎⲞⲨⲒ ⲞⲨⲞϨ ⲀⲘⲞⲨ ⲘⲞϢⲒ ⲚⲤⲰⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲀⲠⲈϤϨⲎⲦ ⲘⲔⲀϨ ⲚⲈⲞⲨⲢⲀⲘⲀⲞ ⲄⲀⲢ ⲠⲈ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲠⲰⲤ ⲤⲘⲞⲔϨ ⲚⲦⲈⲚⲎ ⲈⲦⲈ ⲚⲒⲬⲢⲎⲘⲀ ⲚⲦⲰⲞⲨ ⲈⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ⲤⲘⲞⲦⲈⲚ ⲄⲀⲢ ⲚⲦⲈⲞⲨϬⲀⲘⲞⲨⲖⲒ Ⲓ- ⲈϦⲞⲨⲚ ϨⲒⲦⲈⲚ ⲐⲞⲨⲀⲐⲚⲒ ⲘⲠⲒⲘⲀⲚⲐⲰⲢⲠ ⲈϨⲞⲦⲈ ⲚⲦⲈⲞⲨⲢⲀⲘⲀⲞ ⲒⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ⲠⲈϪⲰⲞⲨ ⲆⲈ ⲚϪⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ϪⲈ ⲚⲒⲘ ϨⲰϤ ⲈⲦⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲒⲀⲦϪⲞⲘ ⲚⲦⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲚⲞⲚ ⲀⲚⲬⲀ ⲠⲈⲦⲈⲚⲦⲀⲚ ⲀⲚⲘⲞϢⲒ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲀϤⲬⲀ ⲎⲒ ⲚⲤⲰϤ ⲒⲈ ⲞⲨⲤϨⲒⲘⲒ ⲒⲈ ϨⲀⲚⲤⲚⲎⲞⲨ ⲒⲈ ϨⲀⲚⲒⲞϮ ⲒⲈ ϨⲀⲚϢⲎⲢⲒ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ϪⲈ ϤⲚⲀϬⲒⲦⲞⲨ ⲚⲞⲨⲘⲎϢ ⲚⲔⲰⲂ ϦⲈⲚⲠⲀⲒⲤⲎⲞⲨ ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲈⲚⲈϨ ⲈⲐⲚⲎⲞⲨ ⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ⲈⲦⲀϤⲒⲚⲒ ⲆⲈ ⲈⲦⲞⲦϤ ⲘⲠⲒⲒⲂ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲎⲠⲠⲈ ⲦⲈⲚⲚⲀϢⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲤⲈⲚⲀϪⲰⲔ ⲈⲂⲞⲖ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲤϦⲎ ⲞⲨⲦ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲐⲂⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ⲤⲈⲚⲀⲦⲎⲒϤ ⲄⲀⲢ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲤⲰⲂⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲈⲚⲀϢⲞϢϤ ⲞⲨⲞϨ ⲤⲈⲚⲀϨⲒⲐⲀϤ ⲈⲠⲈϤϨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ⲞⲨⲞϨ ⲀⲨϢⲀⲚⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲞϤ ⲤⲈⲚⲀϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ϤⲚⲀⲦⲰⲚϤ ϦⲈⲚⲠⲒⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲘⲠⲞⲨⲔⲀϮ ⲈϨⲖⲒ ⲚⲚⲀⲒ ⲞⲨⲞϨ ⲚⲀϤϨⲎⲠ ⲈⲢⲰⲞⲨ ⲠⲈ ⲚϪⲈⲠⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲀⲨⲈⲘⲒ ⲀⲚ ⲠⲈ ⲈⲚⲎ ⲈⲚⲀϤϪⲰ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀϤϦⲰⲚⲦ ⲈⲒⲈⲢⲒⲬⲰ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲂⲈⲖⲖⲈ ⲠⲈ ⲈϤϨⲈⲘⲤⲒ ϦⲀⲦⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲈϤϢⲀⲦⲘⲈⲐⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲞⲨⲘⲎϢ ⲈϤⲤⲒⲚⲒⲰⲞⲨ ⲚⲀϤϢⲒⲚⲒ ⲠⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ⲀⲨⲦⲀⲘⲞϤ ⲆⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲤⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ⲞⲨⲞϨ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲚⲀⲒ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ⲞⲨⲞϨ ⲚⲎ ⲈⲚⲀⲨⲘⲞϢⲒ ⲈⲦϨⲎ ⲚⲀⲨⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲬⲀⲢⲰϤ ⲚⲐⲞϤ ⲆⲈ ⲘⲀⲖⲖⲞⲚ ⲚϨⲞⲨⲞ ⲚⲀϤⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲚⲀⲒ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ⲈⲦⲀϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲈⲚϤ ϨⲀⲢⲞϤ ⲈⲦⲀϤϦⲰⲚⲦ ⲆⲈ ⲈⲢⲞϤ ⲀϤϢⲈⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲞⲨⲀϢϤ ⲚⲦⲀⲀⲒϤ ⲚⲀⲔ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ϨⲒⲚⲀ ⲚⲦⲀⲚⲀⲨ ⲘⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲨ ⲘⲂⲞⲖ ⲠⲈⲔⲚⲀϨϮ ⲠⲈⲦⲀϤⲚⲀϨⲘⲈⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲈϤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲈⲦⲀⲨⲚⲀⲨ ⲀⲨⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ϦⲈⲚⲒⲈⲢⲒⲬⲰ ");
INSERT INTO copbhc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲨⲘⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ϪⲈ ⲌⲀⲔⲬⲈⲞⲤ ⲞⲨⲞϨ ⲪⲀⲒ ⲚⲈⲞⲨⲀⲢⲬⲒⲦⲈⲖⲰⲚⲎ ⲤⲠⲈ ⲞⲨⲞϨ ⲚⲈⲞⲨⲢⲀⲘⲀⲞ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲈⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤϢϪⲈⲘϪⲞⲘ ⲀⲚ ⲠⲈ ⲈⲐⲂⲈ ⲠⲒⲘⲎϢ ϪⲈ ⲚⲈⲞⲨⲔⲞⲨϪⲒ ⲠⲈ ϦⲈⲚⲦⲈϤⲘⲀⲒⲎ ");
INSERT INTO copbhc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ⲈⲦⲀϤϬⲞϪⲒ ⲈⲦϨⲎ ⲀϤϢⲈ ⲚⲀϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲞⲨⲤⲨⲔⲞⲘⲞⲢⲈⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲚⲀⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲀϤⲤⲒⲚⲒ ⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀ ⲀϤⲤⲞⲘⲤ ⲈⲢⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲌⲀⲔⲬⲈⲞⲤ ⲬⲰⲖⲈⲘ ⲘⲘⲞⲔ ⲀⲘⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲘⲪⲞⲞⲨ ⲄⲀⲢ ϨⲰϮ ⲈⲢⲞⲒ ⲚⲦⲀϢⲰⲠⲒ ϦⲈⲚⲠⲈⲔⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ⲞⲨⲞϨ ⲀϤⲬⲰⲖⲈⲘ ⲘⲘⲞϤ ⲀϤⲒ ⲈⲠⲈⲤⲎ ⲦⲞⲨⲞϨ ⲀϤϢⲞⲠϤ ⲈⲢⲞϤ ⲈϤⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ⲞⲨⲞϨ ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲀⲨⲚⲀⲨ ⲀⲨⲈⲢⲬⲢⲈⲘⲢⲈⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚⲢⲰⲘⲒ ⲈⲘⲦⲞⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲌⲀⲔⲬⲈⲞⲤ ⲠⲈϪⲀϤ ⲘⲠϬⲞⲒⲤ ϪⲈ ⲠϬⲞⲒⲤ ϨⲎⲠⲠⲈ ϮϮ ⲚⲦⲪⲀϢⲒ ⲚⲚⲀϨⲨⲠⲀⲢⲬ ⲞⲚⲦⲀ ⲚⲚⲒϨⲎⲔⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀⲒϬⲒⲦϤ ⲚϪⲞⲚⲤ ⲚϨⲖⲒ ϮⲚⲀⲔⲞⲂⲞⲨ ⲚⲀϤ ⲚⲆ ⲚⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲘⲪⲞⲞⲨ ⲠⲞⲨϪⲀⲒ ϢⲰⲠⲒ ϦⲈⲚⲠⲀⲒⲎⲒ ϪⲈ ⲚⲐⲞϤ ϨⲰϤ ⲞⲨϢⲎⲢⲒ ⲚⲦⲈⲀⲂⲢⲀⲀⲘ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ⲀϤⲒ ⲄⲀⲢ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈⲔⲰϮ ⲞⲨⲞϨ ⲈⲚⲞϨⲈⲘ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ⲈⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀϤⲞⲨⲀϨⲦⲞⲦϤ ⲚϪⲈⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲐⲂⲈϪⲈ ⲚⲀϤϦⲈⲚⲦ ⲠⲈ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲤⲀⲦⲞⲦⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ⲠⲈϪⲀϤ ⲞⲨⲚ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲈⲨⲄⲈⲚⲎⲤ ⲀϤϢⲈ ⲚⲀϤ ⲈⲞⲨⲬⲰⲢⲀ ⲈⲤⲞⲨⲎⲞⲨ ⲈϬⲒ ⲚⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈⲦⲀⲤⲐⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ⲈⲦⲀϤⲘⲞⲨϮ ⲆⲈ ⲈⲒ ⲘⲂⲰⲔ ⲚⲦⲀϤ ⲀϤϮ ⲘⲒ ⲚⲈⲘⲚⲀ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲒⲒⲈⲂϢⲰⲦ ϦⲈⲚⲚⲀⲒ ϢⲀϮⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ⲚⲈϤⲠⲞⲖⲒⲦⲎⲤ ⲆⲈ ⲚⲀⲨⲘⲞⲤϮ ⲘⲘⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ⲚⲞⲨⲠⲢⲈⲤⲂⲒⲀ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲚⲞⲨⲈϢ ⲪⲀⲒ ⲀⲚ ⲈⲐⲢⲈϤⲈⲢⲞⲨⲢⲞ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤⲦⲀⲤⲐⲞ ⲈⲀϤϬⲒ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲀϤϪⲞⲤ ⲈⲐⲢⲞⲨⲘⲞⲨϮ ⲈⲚⲒⲈⲂⲒⲀⲒⲔ ⲚⲀⲒ ⲈⲦⲀϤϮ ⲘⲠⲒϨⲀⲦ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲘⲒ ϪⲈ ⲞⲨ ⲘⲘⲈⲦⲒⲈⲂϢⲰⲦ ⲈⲦⲀⲨⲀⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲠⲒϨⲞⲨⲒⲦ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲠⲈⲔⲈⲘⲚⲀ ⲀϤⲈⲢ ⲒⲚⲈⲘⲚⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲀⲖⲰⲤ ⲠⲒⲂⲰⲔ ⲈⲐⲚⲀⲚⲈϤ ⲈⲐⲂⲈϪⲈ ⲀⲔϢⲰⲠⲒ ⲈⲔⲈⲚϨⲞⲦ ϦⲈⲚϨⲀⲚⲔⲞⲨϪⲒ ϢⲰⲠⲒ ⲈⲞⲨⲞⲚⲦⲈⲔ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈϪⲈⲚ ⲒⲘⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲠⲒⲘⲀϨⲂ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲠⲈⲔⲘⲚⲀ ⲀϤⲈⲢ ⲈⲚⲘⲚⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ⲠⲈϪⲀϤ ⲆⲈ ⲞⲚ ⲘⲠⲀⲒⲬⲈⲦ ϪⲈ ϢⲰⲠⲒ ϨⲰⲔ ⲈϪⲈⲚ ⲈⲘⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲠⲒⲔⲈⲞⲨⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲈⲔⲘⲚⲀ ϤⲬⲎ ⲚⲦⲞⲦ ⲀⲒⲔⲞⲨⲖⲰⲖϤ ϦⲈⲚⲞⲨⲤⲞⲨⲆⲀⲢⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ⲚⲀⲒⲈⲢϨⲞϮ ϦⲀⲦⲈⲔϨⲎ ⲠⲈ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲈϤⲚⲀϢⲦ ⲔⲰⲖⲒ ⲘⲪⲎ ⲈⲦⲈⲘⲠⲈⲔⲬⲀϤ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲔⲰⲤϦ ⲘⲪⲎ ⲈⲦⲈⲘⲠⲈⲔⲤⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲔ ϮⲚⲀϮϨⲀⲠ ⲈⲢⲞⲔ ⲠⲒⲂⲰⲔ ⲈⲦϨⲰⲞⲨ ⲒⲤϪⲈ ⲔⲤⲰⲞⲨⲚ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲈϤⲚⲀϢⲦ ⲈⲒⲰⲖⲒ ⲘⲪⲎ ⲈⲦⲈⲘⲠⲒⲬⲀϤ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲈⲒⲰⲤϦ ⲘⲪⲎ ⲈⲦⲈⲘⲠⲒⲤⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ⲈⲐⲂⲈⲞⲨ ⲘⲠⲈⲔϮ ⲘⲠⲀϨⲀⲦ ⲈϮⲦⲢⲀⲠⲈⲌⲀ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚⲒ ⲚⲀⲒⲚⲀⲈⲢⲠⲢⲀⲤⲤⲒⲚ ⲘⲘⲞϤ ⲚⲈⲘ ⲦⲈϤⲘⲎⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϪⲈ ⲀⲖⲒⲞⲨⲒ ⲘⲠⲒⲘⲚⲀ ⲚⲦⲞⲦϤ ⲘⲪⲀⲒ ⲞⲨⲞϨ ⲘⲎⲒϤ ⲘⲪⲎ ⲈⲦⲈ ⲠⲒⲒ ⲚⲘⲚⲀ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲞⲨⲞⲚ ⲒⲚⲈⲘⲚⲀ ⲚⲦⲞⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲈⲨⲈϮⲚⲀϤ ⲪⲎ ⲆⲈ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲦⲀϤ ⲠⲈⲦⲈⲚⲦⲞⲦϤ ⲤⲈⲚⲀⲞⲖϤ ⲚⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ⲠⲖⲎⲚ ⲚⲀϪⲀϪⲒ ⲚⲀⲒ ⲈⲦⲈⲘⲠⲞⲨⲞⲨⲰϢ ⲈⲐⲢⲒⲈⲢⲞⲨⲢⲞ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲀⲚⲒⲦⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲞⲨⲞϨ ϦⲈⲖϦⲰⲖⲞⲨ ⲘⲠⲀⲘⲐⲞ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈ ⲚⲀⲒ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ϨⲒⲦϨⲎ ⲈϤⲚⲀ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤϦⲰⲚⲦ ⲈⲂⲎⲐⲪⲀⲄⲎ ⲚⲈⲘ ⲂⲎⲐⲀⲚⲒⲀ ϦⲀⲦⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲪⲀⲚⲒϪⲰⲒⲦ ⲀϤⲞⲨⲰⲢⲠ ⲘⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲠⲀⲒϮⲘⲒ ⲈⲦⲬⲎ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲦⲈⲦⲈⲚⲚⲀϪⲒⲘⲒ ⲚⲞⲨⲤⲎϪ ⲈϤⲤⲞⲚϨ ⲪⲎ ⲈⲦⲈ ⲘⲠⲈ ϨⲖⲒ ⲚⲢⲰⲘⲒ ⲀⲖⲎⲒ ⲈⲢⲞϤ ⲈⲚⲈϨ ⲂⲞⲖϤ ⲈⲂⲞⲖ ⲀⲚⲒⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ϢⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲂⲰⲖ ⲘⲘⲞϤ ⲀϪⲞⲤ ⲘⲠⲀⲒⲢⲎϮ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲆⲈ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ ⲀⲨϪⲒⲘⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ⲈⲨⲂⲰⲖ ⲆⲈ ⲘⲠⲒⲤⲎϪ ⲈⲂⲞⲖ ⲠⲈϪⲈ ⲚⲈϤϬⲒⲤⲈⲨ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲂⲰⲖ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲎϪ ");
INSERT INTO copbhc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲂⲞⲢⲂⲈⲢ ⲚⲚⲞⲨϨⲂⲰⲤ ⲈϪⲈⲚ ⲠⲒⲤⲎϪ ⲀⲨⲦⲀⲖⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ⲈⲨⲘⲞϢⲒ ⲆⲈ ⲚⲀⲨⲪⲰⲢϢ ⲚⲚⲞⲨϨⲂⲰⲤ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ⲈϤⲚⲀϦⲰⲚⲦ ⲆⲈ ϨⲎⲆⲎ ⲈⲠⲒⲘⲀ ⲚⲒ ⲈⲠⲈⲤⲎⲦ ⲚⲦⲈⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲀϤⲈⲢϨⲎ ⲦⲤ ⲚϪⲈⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲚⲦⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲨⲢⲀϢⲒ ⲈⲨⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲈⲐⲂⲈ ⲚⲒϪⲞⲘ ⲦⲎⲢⲞⲨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲠⲒⲞⲨⲢⲞ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲞⲨϨⲒⲢⲎ ⲚⲎ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲞⲨⲰⲞⲨ ϦⲈⲚⲚⲎ ⲈⲦϬⲞⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ⲞⲨⲞϨ ϨⲀⲚⲞⲨⲞⲚ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠⲒⲢⲈϤϮ ⲤⲂⲰ ⲀⲢⲒⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ⲞⲨⲞϨ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲈϢⲀⲚ ⲚⲀⲒ ⲬⲀⲢⲰⲞⲨ ⲤⲈⲚⲀⲰϢ ⲈⲂⲞⲖ ⲚϪⲈⲚⲀⲒⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ⲞⲨⲞϨ ϨⲰⲤ ⲈⲦⲀϤϦⲰⲚⲦ ⲈⲦⲀϤⲚⲀⲨ ⲈϮⲂⲀⲔⲒ ⲀϤⲢⲒⲘⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲚⲀⲢⲈⲈⲘⲒ ϨⲰⲒ ⲠⲈ ϦⲈⲚⲠⲀⲒⲈϨⲞⲞⲨ ⲈⲚⲀ ⲦⲈϨⲒⲢⲎⲚⲎ ϮⲚⲞⲨ ⲆⲈ ⲀⲨϨⲰⲠ ⲈⲂⲞⲖ ϨⲀ ⲚⲈⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ϪⲈ ⲤⲈⲚⲀⲒ ⲈϨⲢⲎⲒ ⲈϪⲰ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲀⲔⲦⲈ ⲔⲀϢ ⲈⲢⲞ ⲚϪⲈⲚⲈϪⲀϪⲒ ⲞⲨⲞϨ ⲤⲈⲚⲀⲔⲰϮ ⲈⲢⲞ ⲞⲨⲞϨ ⲤⲈⲚⲀϨⲈϪϨⲰϪⲒ ⲤⲀⲤⲀ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ⲞⲨⲞϨ ⲈⲨⲈⲢⲰϦⲦ ⲘⲘⲞ ⲈⲠⲈⲤⲎⲦ ⲚⲈⲘ ⲚⲈϢⲎⲢⲒ ⲚϦⲎϮ ⲞⲨⲞϨ ⲚⲚⲞⲨⲬⲀ ⲞⲨⲰⲚⲒ ⲈϪⲈⲚ ⲞⲨⲰⲚⲒ ⲚϦⲎϮ ⲈⲪⲘⲀ ϪⲈ ⲘⲠⲈⲈⲘⲒ ⲈⲠⲤⲎⲞⲨ ⲚⲦⲈⲠⲈϪⲈⲘⲠϢⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲚⲚⲎ ⲈⲦϮ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲀⲎⲒ ⲈϤⲈϢⲰⲠⲒ ⲚⲞⲨⲎⲒ ⲘⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚⲀⲒϤ ⲘⲂⲎⲂ ⲚⲤⲞⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲘⲘⲎⲒⲚⲒ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒϨⲞⲨⲀϮ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚⲤⲀⲦⲀⲔⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ⲞⲨⲞϨ ⲚⲀⲨϪⲒⲘⲒ ⲀⲚ ⲠⲈ ⲘⲪⲎ ⲈⲦⲞⲨⲚⲀⲀⲒϤ ⲠⲒⲖⲀⲞⲤ ⲄⲀⲢ ⲦⲎⲢϤ ⲚⲀⲨⲀϢⲒ ⲚⲤⲰϤ ⲈⲨⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲀⲒ ⲚⲚⲒⲈϨⲞⲞⲨ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀϪⲞⲤ ⲚⲀⲚ ϪⲈ ⲀⲔⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ ⲒⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϮ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲀϢⲈⲚ ⲐⲎⲚⲞⲨ ϨⲰ ⲈⲞⲨⲤⲀϪⲒ ⲞⲨⲞϨ ⲀϪⲞϤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϢⲀⲚ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲤⲞϬⲚⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲀⲚϢⲀⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ ϤⲚⲀϪⲞⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ⲈϢⲰⲠ ⲆⲈ ⲀⲚϢⲀⲚϪⲞⲤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲠⲈ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀϤϨⲒⲰⲚⲒ ⲈⲢⲞⲚ ⲠⲞⲨϨⲎⲦ ⲄⲀⲢ ⲐⲎⲦ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ⲞⲨⲞϨ ⲀⲨⲈⲢⲞⲨⲰ ϪⲈ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲚϮⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲀⲒⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲀϢ ⲚⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ⲀϤⲈⲢϨⲎⲦⲤ ⲆⲈ ⲚⲤⲀϪⲒ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ⲚⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲈⲀϤϬⲞ ⲚⲞⲨⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲚϨⲀⲚⲞⲨⲒⲎ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠϢⲈⲘⲘⲞ ⲚⲞⲨⲚⲒϢϮ ⲚⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ⲞⲨⲞϨ ϦⲈⲚⲠⲤⲎⲞⲨ ⲀϤⲞⲨⲰⲢⲠ ⲚⲞⲨⲂⲰⲔ ϨⲀ ⲚⲒⲞⲨⲒⲎ ϨⲒⲚⲀ ⲚⲤⲈϮ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲚⲒⲞⲨⲒⲎ ⲆⲈ ⲈⲦⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ ⲀⲨϮⲦⲞⲦϤ ⲈⲂⲞⲖ ⲈϤϢⲞⲨⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲦⲞⲦϤ ⲞⲚ ⲈⲞⲨⲰⲢⲠ ⲚⲰⲞⲨ ⲚⲔⲈⲂⲰⲔ ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨϨⲒⲞⲨⲒ ⲈⲠⲒⲬⲈⲦ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲞϢϤ ⲀⲨϮⲦⲞⲦϤ ⲈⲂⲞⲖ ⲈϤϢⲞⲨⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲦⲞⲦϤ ⲞⲚ ⲈⲞⲨⲰⲢⲠ ⲘⲠⲒⲘⲀϨⲄ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲪⲰⲖϨ ⲘⲠⲀⲒⲬⲈⲦ ⲀⲨϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ϮⲚⲀⲞⲨⲰⲢⲠ ⲘⲠⲀϢⲎⲢⲒ ⲘⲘⲈⲚⲢⲒⲦ ⲀⲢⲎⲞⲨ ⲚⲤⲈϢⲒⲠⲒ ϦⲀⲦⲈϤϨⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲞⲨⲒⲎ ⲚⲀⲨⲤⲞϬⲚⲒ ⲠⲈ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲀⲘⲰⲒⲚⲒ ⲘⲀⲢⲈⲚϦⲞⲐⲂⲈϤ ϨⲒⲚⲀ ⲚⲦⲈⲤϢⲰⲠⲒ ⲚⲀⲚ ⲚϪⲈϮⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲒⲦϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲀⲨϦⲞⲐⲂⲈϤ ⲞⲨ ⲠⲈⲦⲈϤⲚⲀⲀⲒϤ ⲚⲰⲞⲨ ⲚϪⲈⲠϬⲞⲒⲤ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ϤⲚⲀⲒ ⲞⲨⲞϨ ϤⲚⲀⲦⲀⲔⲈ ⲚⲒⲞⲨⲒⲎ ⲞⲨⲞϨ ϤⲚⲀϮ ⲘⲠⲒⲒⲀϨⲀⲖⲞⲖⲒ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲚⲈⲤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲞⲘⲤ ⲈⲢⲰⲞⲨ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲒⲰⲚⲒ ⲈⲦⲀⲨϢⲞϢϤ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰⲦ ⲪⲀⲒ ⲀϤϢⲰⲠⲒ ⲈⲨϪⲰϪ ⲚⲖⲀⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨⲈⲒ ⲈϪⲈⲚ ⲠⲀⲒⲰⲚⲒ ⲈⲦⲈⲘⲘⲀⲨ ϤⲚⲀⲖⲰⲤ ⲪⲎ ⲆⲈ ⲈⲦⲈϤⲚⲀϨⲈⲒ ⲈϪⲰϤ ϤⲚⲀϢⲀϢϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚϪⲈⲚⲒⲤⲀϦ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲈⲚ ⲚⲞⲨϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲞⲨⲞϨ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲠⲒⲖⲀⲞⲤ ⲀⲨⲈⲘⲒ ⲄⲀⲢ ϪⲈ ⲈⲦⲀϤϪⲈ ⲦⲀⲒⲠⲀⲢⲀⲂⲞⲖⲎ ⲈⲐⲂⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ⲞⲨⲞϨ ⲈⲦⲀⲨϮϨⲐⲎⲞⲨ ⲀⲨⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϨⲀⲚⲢⲈϤⲬⲢⲞϤ ⲈⲨⲈⲢⲘⲈⲦϢⲞⲂⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲈⲢⲰⲞⲨ ϪⲈ ϨⲀⲚⲐⲘⲎⲒ ϨⲒⲚⲀ ⲚⲤⲈⲦⲀϨⲞϤ ⲚⲞⲨⲤⲀϪⲒ ϨⲰⲤⲦⲈ ⲈⲦⲎⲒϤ ⲚϮⲀⲢⲬⲎ ⲚⲈⲘ ϮⲈⲜⲞⲨⲤⲒⲀ ⲚⲦⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲔⲤⲀϪⲒ ϦⲈⲚⲞⲨⲤⲰⲞⲨⲦⲈⲚ ⲞⲨⲞϨ ⲔϮⲤⲂⲰ ⲞⲨⲞϨ ⲔϬⲒ ϨⲞ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲔϮⲤⲂⲰ ⲘⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ⲤϢⲈ ⲚϮϨⲰϮ ⲘⲠⲞⲨⲢⲞ ϢⲀⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ⲈⲦⲀϤϮϨⲐⲎϤ ⲆⲈ ⲈⲦⲞⲨⲘⲈⲦⲠⲀⲚⲞⲨⲢⲄⲞⲤ ⲠⲈϪⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ϪⲈ ⲘⲀⲦⲀⲘⲞⲒ ⲈⲞⲨⲤⲀⲐⲈⲢⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲦⲀⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮϨⲒⲔⲰⲚ ⲚⲈⲘ ϮⲈⲠⲒⲄⲢⲀⲪⲎ ⲈⲦϨⲒⲰⲦⲤ ⲚⲀ ⲚⲒⲘ ⲚⲈⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲀ ⲠⲞⲨⲢⲞ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲞⲨ ⲘⲀ ⲚⲀ ⲠⲞⲨⲢⲞ ⲘⲠⲞⲨⲢⲞ ⲞⲨⲞϨ ⲘⲀ ⲚⲀ ⲪⲚⲞⲨϮ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲈⲀⲘⲀϨⲒ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲤⲀϪⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈϤϪⲒⲚⲈⲢⲞⲨⲰ ⲀⲨⲬⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ⲈⲦⲀⲨⲒ ⲆⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲚϪⲈϨⲀⲚⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲀⲨϢⲈⲚϤ ");
INSERT INTO copbhc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ Ⲁ- ⲘⲰⲨⲤⲎⲤ ⲤϦⲀⲒ ⲚⲀⲚ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠⲤⲞⲚ ⲚⲞⲨⲀⲒ ⲘⲞⲨ ⲈⲞⲨⲞⲚⲦⲈϤ ⲤϨⲒⲘⲒ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲪⲀⲒ ⲘⲘⲞⲚⲦⲈϤ ϢⲎⲢⲒ ⲘⲘⲀⲨ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈϤⲤⲞⲚ ϬⲒ ⲚⲦⲈϤⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲞⲨⲚⲞⲤ ⲞⲨϪⲢⲞϪ ⲘⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ⲚⲈ ⲞⲨⲞⲚ ⲌⲞⲨⲚ ⲚⲤⲞⲚ ⲠⲈ ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲒⲦ ⲈⲦⲀϤϬⲒ ϮⲤϨⲒⲘⲒ ⲀϤⲘⲞⲨ ⲈϤⲞⲒ ⲚⲀⲦϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ⲞⲨⲞϨ ⲠⲒⲘⲀϨⲂ ⲀϤϬⲒⲦⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ⲚⲈⲘ ⲠⲒⲘⲀϨⲄ ⲠⲀⲒⲢⲎϮ ⲆⲈ ϢⲀ ⲠⲒⲘⲀϨⲌ ⲘⲠⲞⲨⲬⲀ ϢⲎⲢⲒ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ⲈⲠϦⲀⲈ ⲆⲈ ⲀⲤⲘⲞⲨ ϨⲰⲤ ⲚϪⲈϮⲔⲈⲤϨⲒⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ⲚϨⲢⲎⲒ ⲞⲨⲚ ϦⲈⲚϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲀⲤⲚⲀⲈⲢⲤϨⲒⲘⲒ ⲚⲚⲒⲘ ⲘⲘⲰⲞⲨ ⲀⲠⲒⲌ ⲄⲀⲢ ϬⲒⲦⲤ ⲈⲨⲤϨⲒⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ϢⲀⲨϬⲒ ⲞⲨⲞϨ ϢⲀⲨϬⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ⲚⲎ ⲆⲈ ⲈⲦⲀⲨⲈⲢⲠⲈⲘⲠϢⲀ ⲘⲠⲒⲈⲚⲈϨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲘ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϮⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲞⲨⲆⲈ ⲘⲠⲀⲨϬⲒ ⲞⲨⲆⲈ ⲘⲠⲀⲨϬⲒⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ⲞⲨⲆⲈ ⲄⲀⲢ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲤⲈⲘⲞⲨ ϪⲈ ϨⲀⲚϨⲒⲤⲞⲤ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲄⲀⲢ ⲚⲈⲞⲨⲞϨ ϨⲀⲚϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲈⲨⲞⲒ ⲚϢⲎⲢⲒ ⲚⲦⲈϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ⲞⲦⲒ ⲆⲈ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲘⲰⲨⲤⲎⲤ ϨⲰϤ ⲀϤϮⲘⲎⲒⲚⲒ ϨⲒ ⲠⲒⲂⲀⲦⲞⲤ ⲘⲪⲢⲎϮ ⲈⲦⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲪⲚⲞⲨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ⲪⲚⲞⲨϮ ⲪⲀ ⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲚⲎ ⲈⲦⲞⲚϦ ⲠⲈ ⲤⲈⲞⲚϦ ⲄⲀⲢ ⲚⲀϤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ⲀⲨⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲀϦ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲔⲀⲖⲰⲤ ⲀⲔϪⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ⲚⲀⲨϢⲈⲢⲦⲞⲖⲘⲀⲚ ⲄⲀⲢ ⲀⲚ ϪⲈ ⲈϢⲈⲚϤ ⲈϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲠⲰⲤ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲚⲆⲀⲨⲒⲆ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ⲚⲐⲞϤ ⲄⲀⲢ ⲆⲀⲨⲒⲆ ϤϪⲰ ⲘⲘⲞⲤ ϦⲈⲚⲠϪⲰⲘ ⲚⲚⲒⲮⲀⲖⲘⲞⲤ ϪⲈ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲀϬⲞⲒⲤ ϪⲈ ϨⲈⲘⲤⲒ ⲤⲀⲦⲀⲞⲨⲒⲚⲀⲘ ");
INSERT INTO copbhc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ϢⲀϮⲬⲀ ⲚⲈⲔϪⲀϪⲒ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈⲔϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ⲆⲀⲨⲒⲆ ⲞⲨⲚ ϤⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲞⲨⲞϨ ⲠⲰⲤ ⲠⲈϤϢⲎⲢⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ⲈϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ϪⲈ ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲤⲀϦ ⲚⲎ ⲈⲐⲞⲨⲰϢ ⲈⲘⲞϢⲒ ϦⲈⲚϨⲀⲚⲤⲦⲞⲖⲎ ⲞⲨⲞϨ ⲈⲨⲘⲈⲒ ⲚⲚⲒⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲚⲒⲀⲄⲞⲢⲀ ⲚⲈⲘ ⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚϨⲈⲘⲤⲒ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ⲚⲒϢⲞⲢⲠ ⲘⲘⲀⲚⲢⲰⲦⲈⲂ ϦⲈⲚⲚⲒⲆⲒⲠⲚⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ⲚⲎ ⲈⲐⲞⲨⲰⲘ ⲚⲚⲒⲎⲒ ⲚⲦⲈⲚⲒⲬⲎⲢⲀ ⲞⲨⲞϨ ϦⲈⲚⲞⲨⲖⲰⲒϪⲒ ⲈⲤⲞⲨⲎⲞⲨ ⲤⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲚⲀⲒ ⲈⲨⲈϬⲒ ⲚⲞⲨϨⲀⲠ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ⲈⲦⲀϤⲤⲞⲘⲤ ⲆⲈ ⲈϨⲢⲎⲒ ⲀϤⲚⲀⲨ ⲈϨⲀⲚⲢⲀⲘⲀⲞ ⲈⲨϨⲒⲞⲨⲒ ⲚⲚⲞⲨⲆⲰⲢⲞⲚ ⲈⲚⲒⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ⲀϤⲚⲀⲨ ⲈⲞⲨⲬⲎⲢⲀ ϨⲰⲤ ⲚϨⲎⲔⲒ ⲈⲤϨⲒⲞⲨⲒ ⲈⲘⲀⲨ ⲚⲖⲈⲠⲦⲞⲚ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲖⲎⲐⲰⲤ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲀⲒⲬⲎⲢⲀ ⲚϨⲎⲔⲒ ⲀⲤϨⲒⲞⲨⲒ ⲈϨⲞⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ⲈⲦⲀ ⲚⲀⲒ ⲄⲀⲢ ϨⲒⲞⲨⲒ ⲚⲚⲒⲆⲰⲢⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲢϨⲞⲨⲞ ⲈⲢⲰⲞⲨ ⲐⲀⲒ ⲚⲐⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲤⲈⲢϦⲀⲈ ⲘⲘⲞϤ ⲠⲈⲤⲰⲚϦ ⲦⲎⲢϤ ⲈⲚⲀϤⲚⲦⲀⲤ ⲀⲤϨⲒⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ⲞⲨⲞϨ ⲈⲢⲈ ϨⲀⲚⲞⲨⲞⲚ ϪⲰ ⲘⲘⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲈⲢⲪⲈⲒ ϪⲈ ⲀⲨⲤⲈⲖⲤⲰⲖϤ ⲚϦⲢⲎⲒ ϦⲈⲚϨⲀⲚⲰⲚⲒ ⲈⲚⲀⲚⲈⲨ ⲚⲈⲘ ϨⲀⲚⲀⲚⲀⲐⲎⲘⲀ ⲠⲈϪⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ϪⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲤⲈⲚⲎⲞⲨ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ⲚⲤⲈⲚⲀⲬⲀ ⲞⲨⲰⲚⲒ ⲀⲚ ⲚϦⲎⲦⲞⲨ ⲈϪⲈⲚ ⲞⲨⲰⲚⲒ ⲘⲠⲀⲒⲘⲀ ⲚⲤⲈⲚⲀⲂⲞⲖϤ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ⲀⲨϢⲈⲚϤ ⲆⲈ ϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲀⲢⲈ ⲚⲀⲒ ⲚⲀϢⲰⲠⲒ ⲚⲐⲚⲀⲨ ⲞⲨⲞϨ ⲞⲨ ⲠⲈ ⲠⲒⲘⲎⲒⲚⲒ ⲀⲢⲈϢⲀⲚ ⲚⲀⲒ ⲚⲞⲨⲒ ⲈϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲀⲨ ⲘⲠⲈⲢⲤⲰⲢⲈⲘ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲄⲀⲢ ⲚⲀⲒ ⲈⲠⲀⲢⲀⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲞⲨⲞϨ ⲀⲠⲤⲎⲞⲨ ϦⲰⲚⲦ ⲘⲠⲈⲢⲘⲞϢⲒ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ϨⲞⲦⲀⲚ ⲆⲈ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲠⲞⲖⲈⲘⲞⲤ ⲚⲈⲘ ϨⲀⲚϢⲐⲞⲢⲦⲈⲢ ⲘⲠⲈⲢⲚⲞⲨϢⲠ ⲀⲖⲖⲀ ⲤⲀⲦⲞⲦϤ ⲀⲚ ⲠⲈ ⲠⲒϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ⲦⲞⲦⲈ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲠⲈ ϪⲈ ⲈϤⲈⲦⲰⲚϤ ⲚϪⲈⲞⲨⲈⲐⲚⲞⲤ ⲈϪⲈⲚ ⲞⲨⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ ⲈϪⲈⲚ ⲞⲨⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ϨⲀⲚⲚⲒϢϮ ⲆⲈ ⲘⲘⲞⲚⲘⲈⲚ ⲈⲨⲈϢⲰⲠⲒ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚϨⲂⲰⲚ ⲚⲈⲘ ϨⲀⲚⲘⲞⲨ ⲔⲀⲦⲀ ⲘⲀ ϨⲀⲚϨⲞϮ ⲆⲈ ⲚⲈⲘ ϨⲀⲚⲚⲒϢϮ ⲘⲘⲎⲒⲚⲒ ⲈⲨⲈϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ϦⲀϪⲈⲚ ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲨⲈⲈⲚ ⲚⲞⲨϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲤⲈⲚⲀϬⲞϪⲒ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲈⲨϮ ⲘⲘⲰⲦⲈⲚ ⲈϨⲀⲚⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲈⲘ ϨⲀⲚϢⲦⲈⲔⲰⲞⲨ ⲈⲨⲒⲚⲒ ⲘⲘⲰⲦⲈⲚ ⲚⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲈⲘ ⲚⲒϨⲎⲄⲈⲘⲰⲚ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ⲈϤⲈϢⲰⲠⲒ ⲆⲈ ⲚⲰⲦⲈⲚ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ⲬⲀⲤ ⲞⲨⲚ ϦⲈⲚⲚⲈⲦⲈⲚϨⲎⲦ ⲈϢⲦⲈⲘⲈⲢϢⲞⲢⲠ ⲚⲈⲢⲘⲈⲖⲈⲦⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ⲀⲚⲞⲔ ⲄⲀⲢ ϮⲚⲀϮ ⲚⲰⲦⲈⲚ ⲚⲞⲨⲢⲞ ⲚⲈⲘ ⲞⲨⲤⲞⲪⲒⲀ ⲐⲎ ⲈⲦⲈⲚⲤⲈⲚⲀϢϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲤ ⲀⲚ ⲞⲨⲆⲈ ⲚⲤⲈⲚⲀϢⲞⲨⲰϨⲈⲘ ⲞⲨⲂⲎⲤ ⲀⲚ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϮ ⲞⲨⲂⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ⲤⲈⲚⲀϮ ⲐⲎⲚⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲒⲞϮ ⲚⲈⲘ ϨⲀⲚⲤⲚⲎⲞⲨ ⲚⲈⲘ ϨⲀⲚⲤⲨⲄⲄⲈⲚⲎⲤ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢ ⲞⲨⲞϨ ⲤⲈⲚⲀϦⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϢⲰⲠⲒ ⲈⲨⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ⲞⲨⲞϨ ⲞⲨϤⲰⲒ ⲚⲦⲈⲦⲈⲚⲀⲪⲈ ⲚⲚⲈϤⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲦⲈⲦⲈⲚϨⲨⲠⲞⲘⲞⲚⲎ ⲈⲢⲈⲦⲈⲚϪⲪⲞ ⲚⲚⲈⲦⲈⲚⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ϨⲞⲦⲀⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲢⲈ ϨⲀⲚⲘⲀⲦⲞⲒ ⲔⲰϮ ⲈⲢⲞⲤ ⲦⲞⲦⲈ ⲀⲢⲒⲈⲘⲒ ϪⲈ ⲀϤϦⲰⲚⲦ ⲚϪⲈⲠⲈⲤϢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ⲦⲞⲦⲈ ⲚⲎ ⲈⲦⲬⲎ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲘⲀⲢⲞⲨⲪⲰⲦ ϨⲒϪⲈⲚ ⲚⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲚⲎ ⲈⲦϦⲈⲚ ⲦⲈⲤⲘⲎϮ ⲘⲀⲢⲞⲨⲪⲰⲦ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲎ ⲈⲦϦⲈⲚ ⲚⲒⲬⲰⲢⲀ ⲘⲠⲈⲚⲐⲢⲞⲨϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ϪⲈ ⲚⲀⲒ ⲚⲈⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠϬⲒⲘϢⲒϢ ⲈⲐⲢⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲤϦⲎ ⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ⲞⲨⲞⲒ ⲆⲈ ⲚⲚⲎ ⲈⲦⲘⲂⲞⲔⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϬⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲤⲈϢⲰⲠⲒ ⲄⲀⲢ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲀⲚⲀⲄⲔⲎ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲚⲈⲘ ⲞⲨϪⲰⲚⲦ ⲘⲠⲀⲒⲖⲀⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ⲞⲨⲞϨ ⲈⲨⲈϨⲈⲒ ϦⲈⲚⲢⲰϤ ⲚⲦⲤⲎϤⲒ ⲞⲨⲞϨ ⲈⲨⲈⲈⲢⲈⲬⲘⲀⲖⲰⲦⲈⲨⲒⲚ ⲘⲘⲰⲞⲨ ⲈⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲈⲤⲈϢⲰⲠⲒ ⲚϪⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲨϨⲰⲘⲒ ⲈϪⲰⲤ ⲚϪⲈϨⲀⲚⲈⲐⲚⲞⲤ ϢⲀⲦⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈϨⲀⲚⲤⲎⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚⲤⲎⲞⲨ ⲚⲦⲈϨⲀⲚⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲚϪⲈϨⲀⲚⲘⲎⲒⲚⲒ ϦⲈⲚⲪⲢⲎ ⲚⲈⲘ ⲠⲒⲒⲞϨ ⲚⲈⲘ ⲚⲒⲤⲒⲞⲨ ⲞⲨⲞϨ ⲞⲨϨⲞϪϨⲈϪ ⲚⲦⲈϨⲀⲚⲈⲐⲚⲞⲤ ⲈϤⲈϢⲰⲠⲒ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ϦⲈⲚⲞⲨⲀⲠⲞⲢⲒⲀ ⲚⲦⲈⲦⲤⲘⲎ ⲘⲪⲒⲞⲘ ⲚⲈⲘ ⲪⲘⲞⲚⲘⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ϨⲀⲚⲢⲰⲘⲒ ⲈⲢⲈ ⲦⲞⲨⲮⲨⲬⲎ ⲒⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲦϨⲞϮ ⲚⲈⲘ ⲠⲤⲞⲘⲤ ⲈⲂⲞⲖ ϦⲀϪⲰⲞⲨ ⲚⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲈϪⲈⲚ ϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲚⲒϪⲞⲘ ⲄⲀⲢ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ⲤⲈⲚⲀⲔⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ⲞⲨⲞϨ ⲈⲨⲈⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲎⲞⲨ ϦⲈⲚⲞⲨϬⲎⲠⲒ ⲚⲈⲘ ⲞⲨϪⲞⲘ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ⲈⲢⲈ ⲚⲀⲒ ⲆⲈ ⲚⲀⲈⲢϨⲎⲦⲤ ⲚϢⲰⲠⲒ ϪⲞⲨϢⲦ ⲈⲠϢⲰⲒ ⲞⲨⲞϨ ⲦⲰⲞⲨⲚ ⲚⲚⲈⲦⲈⲚⲀⲪⲎ ⲞⲨⲒ ϪⲈ ϤϦⲈⲚⲦ ⲚϪⲈⲠⲈⲦⲈⲚⲤⲰϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ⲞⲨⲞϨ ⲀϤϪⲈ ⲞⲨⲠⲀⲢⲀⲂⲞⲖⲎ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲀⲨ ⲈϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲚⲈⲘ ⲚⲒϢϢⲎⲚ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ⲈϢⲰⲠ ϨⲎⲆⲎ ⲈⲨⲚⲀϮⲞⲨⲰ ⲈⲂⲞⲖ ⲈⲢⲈⲦⲈⲚⲚⲀⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ϢⲀⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲀϤϦⲰⲚⲦ ⲚϪⲈⲠⲒϢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲚⲀⲒ ⲈⲨⲚⲀϢⲰⲠⲒ ⲀⲢⲒⲈⲘⲒ ϪⲈ ⲀⲤϦⲰⲚⲦ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲈ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲤⲒⲚⲒ ϢⲀⲦⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲤⲈⲚⲀⲤⲒⲚⲒ ⲚⲀⲤⲀϪⲒ ⲆⲈ ⲚⲚⲞⲨⲤⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ⲘⲀϨⲐⲎⲦⲈⲚ ⲆⲈ ⲈⲢⲰⲦⲈⲚ ⲘⲎⲠⲞⲦⲈ ⲚⲦⲞⲨϨⲢⲞϢ ⲚϪⲈⲚⲈⲦⲈⲚϨⲎⲦ ϦⲈⲚϨⲀⲚϬⲒⲘⲈ ⲚⲈⲘ ϨⲀⲚⲐⲒϦⲒ ⲚⲈⲘ ϨⲀⲚⲢⲰⲞⲨϢ ⲘⲂⲒⲰⲦⲒⲔⲞⲚ ⲞⲨⲞϨ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲈⲦⲈϤⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚϪⲈⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ⲘⲪⲢⲎϮ ⲚⲞⲨⲪⲀϢ ⲈϤⲈⲒ ⲄⲀⲢ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ⲠϨⲞ ⲘⲠⲔⲀϨⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ⲢⲰⲒⲤ ⲞⲨⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲈⲢⲈⲦⲈⲚⲦⲰⲂϨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ ⲚⲈⲢⲈⲂⲞⲖ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲀϢⲰⲠⲒ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ⲚⲀϤⲒⲢⲒ ⲆⲈ ⲚⲚⲒⲈϨⲞⲞⲨ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲒⲈϪⲰⲢϨ ⲆⲈ ⲚⲀϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲈϤⲘⲞⲦⲈⲚ ⲘⲘⲞϤ ϨⲒϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲪⲀ ⲚⲒϪⲰⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ⲞⲨⲞϨ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲀϤϢⲰⲢⲠ ⲘⲘⲞϤ ϨⲀⲢⲞϤ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ⲚⲀϤϦⲈⲚⲦ ⲆⲈ ⲠⲈ ⲚϪⲈⲠϢⲀⲒ ⲚⲦⲈⲚⲒⲀⲦϢⲘⲎⲢ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲠⲀⲤⲬ Ⲁ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ⲞⲨⲞϨ ⲚⲀⲨⲔⲰϮ ⲠⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ϪⲈ ⲀⲨⲚⲀⲦⲀⲔⲞϤ ⲚⲀϢ ⲚⲢⲎϮ ⲚⲀⲨⲈⲢϨⲞϮ ⲄⲀⲢ ⲠⲈ ϦⲀⲦϨⲎ ⲘⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲆⲈ ϢⲈ ⲈϦⲞⲨⲚ ⲈⲠϨⲎⲦ ⲚⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎ ⲤⲈⲞⲨⲈⲂⲞⲖ ⲠⲈ ϦⲈⲚⲠⲒⲒⲂ ");
INSERT INTO copbhc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲦⲎⲄⲞⲤ ⲈⲐⲂⲈ ⲪⲢⲎϮ ⲈⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ⲞⲨⲞϨ ⲀⲨⲢⲀϢⲒ ⲞⲨⲞϨ ⲀⲨⲤⲈⲘⲚⲎⲦⲤ ⲚⲈⲘⲀϤ ⲈϮ ⲚⲀϤ ⲚⲞⲨϨⲀⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ⲞⲨⲞϨ ⲀϤⲈⲢⲈⲜⲞⲘⲞⲖⲞⲄⲒⲚ ⲞⲨⲞϨ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲚⲤⲀⲞⲨⲈⲨⲔⲈⲢⲒⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲀⲦϬⲚⲈ ⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲀⲦϢⲘⲎ ⲢⲪⲎ ⲈⲦⲈⲤϢⲈ ⲈϢⲀⲦ ⲠⲒⲠⲀⲤⲬⲀ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲢⲠ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎ ⲤϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲤⲈⲂⲦⲈ ⲠⲒⲠⲀⲤⲬⲀ ⲚⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈⲚⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲬⲞⲨⲰϢ ⲈⲤⲈⲂⲦⲰⲦϤ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲎⲠⲠⲈ ⲈⲢⲈⲦⲈⲚⲚⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈϮⲂⲀⲔⲒ ϤⲚⲀⲒ ⲈⲂⲞⲖ ⲈϨⲢⲈⲚ ⲐⲎⲚⲞⲨ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈϤϤⲀⲒ ⲚⲞⲨϢⲞϢⲞⲨ ⲘⲘⲰⲞⲨ ⲘⲞϢⲒ ⲚⲤⲰϤ ⲈⲠⲒⲎⲒ ⲈⲦⲈϤⲚⲀϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ⲞⲨⲞϨ ⲀϪⲞⲤ ⲘⲠⲒⲚⲈⲂⲎⲒ ⲚⲦⲈⲠⲒⲎⲒ ϪⲈ ⲠⲈϪⲈ ⲠⲒⲢⲈϤϮⲤⲂⲰ ⲚⲀⲔ ϪⲈ ⲀϢ ⲠⲈ ⲠⲒⲘⲀ ⲈϮⲚⲀⲞⲨⲰⲘ ⲘⲠⲀⲠⲀⲤⲬⲀ ⲘⲘⲞϤ ⲚⲈⲘ ⲚⲀⲘⲀⲐⲎ ⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ϤⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲈⲞⲨⲚⲒϢϮ ⲘⲘⲀ ⲈϤⲤⲀⲠϢⲰⲒ ⲈϤⲪⲞⲢϢ ⲤⲈⲂⲦⲰⲦϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲆⲈ ⲀⲨϪⲒⲘⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲤⲈⲂⲦⲈ ⲠⲒⲠⲀⲤⲬ Ⲁ ");
INSERT INTO copbhc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲚϪⲈϮⲞⲨⲚⲞⲨ ⲀϤⲢⲰⲦⲈⲂ ⲚⲈⲘ ⲠⲒⲒⲂ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϦⲈⲚⲞⲨⲈⲠⲒⲐⲨⲘⲒⲀ ⲀⲒⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲞⲨⲰⲘ ⲘⲠⲀⲠⲀⲤⲬⲀ ⲚⲈⲘⲰⲦⲈⲚ ⲘⲠⲀϮϬⲒⲘⲔⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲀⲞⲨⲞⲘϤ ϢⲀⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ϦⲈⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲀⲪⲞⲦ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲠⲈϪⲀϤ ϪⲈ ⲘⲰⲒⲚⲒ ⲈⲪⲀⲒ ⲪⲞϢϤ ⲈϨⲢⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲚⲀⲤⲰ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲦⲀⲒⲂⲰ ⲚⲀⲖⲞⲖⲒ ϢⲀⲦⲈⲤⲒ ⲚϪⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲰⲒⲔ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤⲪⲀϢϤ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲚⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲎ ⲒϤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲪⲀⲒ ⲀⲢⲒⲦϤ ⲈⲠⲀⲘⲈⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ⲞⲨⲞϨ ⲠⲒⲀⲪⲞⲦ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲆⲒⲠⲚⲞⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲀⲪⲞⲦ ϮⲆⲒⲀⲐⲎⲔⲎ ⲘⲂⲈⲢⲒ ⲦⲈ ϦⲈⲚⲠⲀⲤⲚⲞϤ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ⲠⲖⲎⲚ ⲒⲤ ⲦϪⲒϪ ⲘⲪⲎ ⲈⲐⲚⲀⲦⲎⲒⲦ ⲤⲬⲎ ⲚⲈⲘⲎⲒ ϨⲒϪⲈⲚ ϮⲦⲢⲀⲠⲈⲌⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ϪⲈ ⲠϢⲎⲢⲒ ⲘⲈⲚ ⲘⲪⲢⲰⲘⲒ ϤⲚⲀϢⲈ ⲚⲀϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲐⲎϢ ⲠⲖⲎⲚ ⲞⲨⲞⲒ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲎ ⲈⲦⲞⲨⲚⲀⲦⲎⲒϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚϢⲒⲚⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲚⲒⲘ ϨⲀⲢⲀ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲐⲚⲀⲈⲢ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲞⲚ ⲚϪⲈⲞⲨⲪⲒⲖⲞⲚⲒⲔⲒⲀ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲚⲒⲘ ⲘⲘⲰⲞⲨ ⲠⲈ ⲠⲒⲚⲒϢϮ ");
INSERT INTO copbhc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲤⲈⲞⲒ ⲚϬⲞⲒⲤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲢϢⲒϢⲒ ⲈϪⲰⲞⲨ ⲤⲈⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲒⲢⲈϤⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲘⲠⲀⲒⲢⲎϮ ⲀⲚ ⲀⲖⲖⲀ ⲠⲒⲚⲒϢϮ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲀⲢⲈϤⲈⲢ ⲘⲪⲢⲎϮ ⲘⲠⲒϦⲈⲖϢⲒⲢⲒ ⲞⲨⲞϨ ⲠⲒϨⲎⲄⲞⲨⲘⲈⲚⲞⲤ ⲘⲪⲢⲎϮ ⲘⲠⲒⲆⲒⲀⲔⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈ ⲠⲒⲚⲒϢϮ ⲪⲎ ⲈⲐⲢⲰⲦⲈⲂ ϢⲀⲚ ⲪⲎ ⲈⲦⲈⲢⲆⲒⲀⲔⲰⲚ ⲘⲎ ⲪⲎ ⲈⲐⲢⲰⲦⲈⲂ ⲀⲚ ⲠⲈ ⲀⲚⲞⲔ ⲠⲈϮⲬⲎ ϦⲈⲚⲦⲈⲦⲈⲚⲘⲎϮ ⲘⲪⲢⲎϮ ⲘⲪⲎ ⲈⲦⲈⲢⲆⲒⲀⲔⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲎ ⲈⲦⲀⲨⲞϨⲒ ⲚⲈⲘⲎⲒ ϦⲈⲚⲚⲀⲠⲒⲢⲀⲤⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀⲤⲈⲘⲚⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲤⲈⲘⲚⲒ ⲚⲈⲘⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲚⲞⲨⲘⲈⲦⲞⲨⲢⲞ ");
INSERT INTO copbhc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲤⲰ ϨⲒ ⲦⲀⲦⲢⲀⲠⲈⲌⲀ ϦⲈⲚⲦⲀⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ϨⲀⲚⲐⲢⲞⲚⲞⲤ ⲈⲢⲈⲦⲈⲚⲈϮ ϨⲀⲠ ⲈϮⲒⲂ ⲘⲪⲨⲖⲎ ⲚⲦⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ⲤⲒⲘⲰⲚ ⲤⲒⲘⲰⲚ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲈϤⲈⲈⲢⲈⲦⲒⲚ ⲘⲘⲰⲦⲈⲚ ⲈϢⲈⲖϢⲈⲖ ⲐⲎⲚⲞⲨ ⲘⲪⲢⲎϮ ⲘⲠⲒⲤⲞⲨⲞ ");
INSERT INTO copbhc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲦⲰⲂϨ ⲈϪⲰⲔ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘⲘⲞⲨⲚⲔ ⲚϪⲈⲠⲈⲔⲚⲀϨϮ ⲞⲨⲞϨ ⲚⲐⲞⲔ ϨⲰⲔ ⲔⲞⲦⲔ ⲚⲞⲨⲤⲎⲞⲨ ⲘⲀⲦⲀϪⲢⲈ ⲚⲈⲔⲤⲚⲎ ⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ϮⲤⲈⲂⲦⲰⲦ ⲈϢⲈ ⲈⲠϢⲦⲈⲔⲞ ⲚⲈⲘⲀⲔ ⲚⲈⲘ ⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ⲠⲈⲦⲢⲈ ϪⲈ ⲚⲚⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲘⲪⲞⲞⲨ ϢⲀⲦⲈⲔϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ ⲈⲐⲢⲈⲔⲈⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲞⲦⲈ ⲈⲦⲀⲒⲞⲨⲈⲢⲠ ⲐⲎⲚⲞⲨ ⲀϬⲚⲈ ⲀⲤⲞⲨⲒ ⲚⲈⲘ ⲠⲎⲢⲀ ⲚⲈⲘ ⲐⲰⲞⲨⲒ ⲘⲎ ⲀⲦⲈⲦⲈⲚⲈⲢϦⲀⲈ ⲚϨⲖⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲘⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲀⲖⲖⲀ ϮⲚⲞⲨ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲚⲞⲨⲀⲤⲞⲨⲒ ⲘⲘⲀⲨ ⲘⲀⲢⲈϤⲞⲖⲤ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲞⲨⲠⲎⲢⲀ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲦⲀϤ ⲘⲀⲢⲈϤϮ ⲠⲈϤϨⲂⲞⲤ ⲈⲂⲞⲖ ⲘⲀⲢⲈϤϢⲈⲠ ⲞⲨⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲦⲤϦⲎⲞⲨⲦ ϨⲰϮ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ϪⲈ ⲀⲨⲞⲠϤ ⲚⲈⲘ ⲚⲒⲀⲚⲞⲘⲞⲤ ⲔⲈ ⲄⲀⲢ ⲠⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦ ⲞⲨⲞⲚⲦⲈ ⲠⲈϤϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲤ ⲤⲎϤⲒ ⲤⲚⲞⲨϮ ⲘⲠⲀⲒⲘⲀ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲈⲢⲰϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤϢⲈ ⲚⲀϤ ⲔⲀⲦⲀ ϮⲔⲀϨⲤ ⲈⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ⲀⲨⲘⲞϢⲒ ⲆⲈ ⲚⲤⲰϤ ⲚϪⲈⲚⲒⲔⲈⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲠⲒⲘⲀ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲰⲂϨ ϪⲈ ⲚⲚⲈⲦⲈⲚⲒ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲞⲨⲰϮ ⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲚⲀⲨ ⲪⲞⲨⲰϢ ⲚϨⲒ ⲞⲨⲰⲚⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲀϤⲦⲰⲂϨ ");
INSERT INTO copbhc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲰⲦ ⲒⲤϪⲈ ⲬⲞⲨⲰϢ ⲘⲀⲢⲈ ⲠⲒⲀⲪⲞⲦ ⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞⲒ ⲠⲖⲎⲚ ⲠⲈⲦⲈϨⲚⲎⲒ ⲀⲚ ⲀⲖⲖⲀ ⲪⲰⲔ ⲘⲀⲢⲈϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲚϨ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈⲐⲢⲈϤϮϪⲞⲘ ⲚⲀϤ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈϤϬⲒϢϢⲰⲞⲨ ⲈϤⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ϦⲈⲚⲚⲈϤⲔⲈⲖⲒ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲢⲈ ⲚⲈϤϤⲰϮ ⲘⲪⲢⲎϮ ⲘⲠⲒⲞⲨⲀⲚ ⲚⲦⲈⲠⲤⲚⲞϤ ⲈϤϢⲞⲨⲞ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ⲞⲨⲞϨ ⲀϤⲦⲰⲂϨ ϦⲈⲚⲞⲨⲘⲞⲨⲚ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲈϤϤⲰϮ ⲀϤⲈⲢ ⲘⲪⲢⲎϮ ⲘⲠϢⲞⲨⲞ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲚⲞϤ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ⲞⲨⲞϨ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲀϤⲒ ϨⲀ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀϤϪⲈⲘⲞⲨ ⲈⲨⲚⲔⲞⲦ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲔⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲚⲔⲞⲦ ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲀⲢⲒⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲘⲎϢ ⲚⲈⲘ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲒⲞⲨⲆⲀⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ ⲚⲀϤⲘⲞϢⲒ ϦⲀϪⲰⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲀϤϦⲰⲚⲦ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤϮⲪⲒ ⲈⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲞⲨⲆⲀⲤ ⲀⲔⲚⲀϮ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϦⲈⲚⲞⲨⲪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲎ ⲈⲦⲔⲰϮ ⲈⲢⲞϤ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲦⲈⲚϨⲒⲞⲨⲒ ⲚⲦⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ⲞⲨⲞϨ ⲀⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀϤϨⲒⲞⲨⲒ ⲚⲤⲀⲪⲂⲰⲔ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲀϤⲈⲖ ⲠⲈϤⲘⲀϢϪ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲔⲎⲚ ϢⲀ ⲘⲚⲀⲒ ⲞⲨⲞϨ ⲈⲦⲀϤϬⲞϨ ⲈⲠⲈϤⲘⲀϢϪ ⲀϤⲦⲀⲖϬⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲚⲎ ⲈⲦⲀⲨⲒ ⲚⲤⲰϤ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲦⲎⲄⲞⲤ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲈⲢⲈⲦⲈⲚⲚⲎⲞⲨ ⲚⲤⲀⲞⲨⲤⲞⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲂⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ⲈⲒⲬⲎ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲘⲘⲎ ⲒⲚⲒ ⲘⲠⲈⲦⲈⲚⲤⲞⲨⲦⲈⲚ ⲚⲈⲦⲈⲚϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲀⲖⲖⲀ ⲐⲀⲒ ⲦⲈ ⲦⲈⲦⲈⲚⲞⲨⲚⲞⲨ ⲚⲈⲘ ⲠⲈⲢϢⲒϢⲒ ⲚⲦⲈⲠⲬⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ⲈⲦⲀⲨⲀⲘⲞⲚⲒ ⲆⲈ ⲘⲘⲞϤ ⲀⲨⲈⲚϤ ⲞⲨⲞϨ ⲀⲨϬⲒⲦϤ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ϨⲒⲪⲞⲨⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ⲈⲦⲀⲨϬⲈⲢⲈ ⲞⲨⲬⲢⲰⲘ ⲆⲈ ϦⲈⲚⲐⲘⲎϮ ⲚϮⲀⲨⲖⲎ ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲈⲘⲤⲒ ⲚⲀⲢⲈ ⲠⲈⲦⲢⲞⲤ ϨⲰϤ ϨⲈⲘⲤⲒ ϦⲈⲚⲦⲞⲨⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ⲈⲦⲀⲤⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲞⲨⲀⲖⲞⲨ ⲘⲂⲰⲔⲒ ⲈϤϨⲈⲘⲤⲒ ϦⲀⲦⲈⲚ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲈⲦⲀⲤⲤⲞⲘⲤ ⲠⲈϪⲀⲤ ϪⲈ ⲚⲀⲢⲈ ⲪⲀⲒ ϨⲰϤ ⲬⲎ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ⲚⲐⲞϤ ⲆⲈ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ϮⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲔⲈⲔⲞⲨϪⲒ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲔⲈⲞⲨⲀⲒ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ϨⲰⲔ ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲪⲢⲰⲘⲒ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ⲞⲨⲞϨ ⲈⲦⲀ ⲪⲞⲨⲰϢ ⲚⲞⲨⲞⲨⲚⲞⲨ ϢⲰⲠⲒ ⲚⲀⲢⲈ ⲔⲈⲞⲨⲀⲒ ⲦⲀϪⲢⲞ ⲚⲦⲞⲦϤ ⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲚⲀⲢⲈ ⲪⲀⲒ ϨⲰϤ ⲬⲎ ⲚⲈⲘⲀϤ ⲔⲈ ⲄⲀⲢ ⲞⲨⲄⲀⲖⲒⲖⲈⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ⲠⲈϪⲀϤ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ϪⲈ ⲪⲢⲰⲘⲒ ϮⲈⲘⲒ ⲀⲚ ⲈⲠⲈⲦⲈⲔϪⲰ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ⲀⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲞⲚϨϤ ⲚϪⲈⲠϬⲞⲒⲤ ⲀϤⲤⲞⲘⲤ ⲈⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲀⲠⲈⲦⲢⲞⲤ ⲈⲢⲪⲘⲈⲨⲒ ⲘⲠⲤⲀϪⲒ ⲘⲠϬⲞⲒⲤ ⲘⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲀϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ⲘⲪⲞⲞⲨ ⲬⲚⲀϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤⲢⲒⲘⲒ ϦⲈⲚⲞⲨⲚϢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ⲞⲨⲞϨ ⲚⲒⲢⲰⲘⲒ ⲈⲚⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲚⲀⲨⲤⲰⲂⲒ ⲘⲘⲞϤ ⲠⲈ ⲈⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ⲞⲨⲞϨ ⲈⲦⲀⲨϨⲞⲂⲤϤ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲒⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲚⲀⲚ ϪⲈ ⲚⲒⲘ ⲠⲈⲦⲀϤϨⲒⲞⲨⲒ ⲈⲢⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲘⲎϢ ⲚⲀⲨϪⲰ ⲘⲘⲰⲞⲨ ⲈⲢⲞϤ ⲈⲨϪⲈⲞⲨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ⲞⲨⲞϨ ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ϢⲰⲠⲒ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲈϦⲞⲨⲚ ⲈⲠⲞⲨⲘⲀⲚϮϨⲀⲠ ");
INSERT INTO copbhc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϪⲞⲤ ⲚⲀⲚ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲒϢⲀⲚϪⲞⲤ ⲚⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀⲚⲀϨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ⲈϢⲰⲠ ⲆⲈ ⲞⲚ ⲀⲒϢⲀⲚϢⲈⲚ ⲐⲎⲚⲞⲨ ⲦⲈⲦⲈⲚⲚⲀⲈⲢⲞⲨⲰ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲈϤⲈϢⲰⲠⲒ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲚϮϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ⲠⲈϪⲰⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲚ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲈⲚⲈⲢⲬⲢⲒⲀ ϪⲈ ⲚⲞⲨⲘⲈⲐⲢⲈ ⲀⲚⲞⲚ ⲄⲀⲢ ⲀⲚⲤⲰⲦⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲠⲞⲨⲘⲎϢ ⲦⲎⲢϤ ⲀⲨⲈⲚϤ ϨⲀ ⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ⲀⲨⲈⲢϨⲎⲦⲤ ⲆⲈ ⲚⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲀⲚϪⲈⲘϤ ⲈⲦⲪⲰⲚϨ ⲘⲠⲈⲚⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤⲦⲀϨⲚⲞ ⲈϢⲦⲈⲘϮ ϨⲰϮ ⲘⲠⲞⲨⲢⲞ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲀϤϢⲈⲚϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲘⲎϢ ϪⲈ ⲚϮϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ⲀⲚ ϦⲈⲚⲠⲀⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨϪⲈⲘϪⲞⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤϢⲐⲞⲢⲦⲈⲢ ⲘⲠⲒⲖⲀⲞⲤ ⲈϤϮⲤⲂⲰ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲈⲀϤⲈⲢϨⲎⲦⲤ ⲒⲤϪⲈⲚ ϮⲄⲀⲖⲒⲖⲈⲀ ϢⲀ ⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲚⲀϤϢⲒⲚⲒ ϪⲈ ⲀⲚ ⲞⲨⲄⲀⲖⲒⲖⲈⲞⲤ ⲠⲈ ⲠⲀⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲢϢⲒϢⲒ ⲚⲎⲢⲰⲆⲎⲤ ⲠⲈ ⲀϤⲞⲨⲞⲢⲠϤ ϨⲀ ⲎⲢⲰⲆⲎⲤ ⲈϤⲬⲎ ϨⲰϤ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ⲎⲢⲰⲆⲎⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲢⲀϢⲒ ⲈⲘⲀϢⲰ ⲚⲀϤⲞⲨⲰϢ ⲄⲀⲢ ⲠⲈ ⲈⲚⲀⲨ ⲈⲢⲞϤ ⲒⲤϪⲈⲚ ⲞⲨⲘⲎϢ ⲚⲬⲢⲞⲚⲞⲤ ⲈⲐⲂⲈϪⲈ ⲚⲀϤⲤⲰⲦⲈⲘ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞϨ ⲚⲀϤⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲚⲀⲨ ⲈⲞⲨⲘⲎⲒⲚⲒ ⲚⲦⲞⲦϤ ⲈϤⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ⲚⲀϤϢⲒⲚⲒ ⲆⲈ ⲘⲘⲞϤ ϦⲈⲚϨⲀⲚⲘⲎϢ ⲚⲤⲀϪⲒ ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲈⲢⲈⲢⲞⲨⲰ ⲚϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ⲚⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲈⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲈⲘⲀϢⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ⲈⲦⲀϤϢⲞϢϤ ⲆⲈ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲦⲞⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲰⲂⲒ ⲘⲘⲞϤ ⲀϤϪⲞⲖϨϤ ⲚⲞⲨϨⲈⲂⲤⲰ ⲈⲤⲪⲈⲢⲒⲰⲞⲨ ⲀϤⲞⲨⲞⲢⲠϤ ⲈⲠⲒⲖⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ⲀⲨⲈⲢϢⲪⲎⲢ ⲆⲈ ⲈⲚⲞⲨⲈⲢⲎⲞⲨ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲚⲈⲘ ⲎⲢⲰⲆⲎⲤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲨϢⲞⲠ ⲄⲀⲢ ⲚϢⲞⲢⲠ ⲠⲈ ϦⲈⲚⲞⲨⲘⲈⲦϪⲀϪⲒ ⲈⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈⲦⲀϤⲘⲞⲨϮ ⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲰⲚ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲦⲈⲦⲈⲚⲒⲚⲒ ⲚⲎⲒ ⲘⲠⲀⲒⲢⲰⲘⲒ ϨⲰⲤ ⲈϤⲪⲰⲚϨ ⲘⲠⲒⲖⲀⲞⲤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ⲈⲦⲀⲒϢⲈⲚϤ ⲈϨⲢⲀϤ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲘⲠⲒϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ϦⲈⲚⲠⲀⲒⲢⲰⲘⲒ ⲚⲚⲎ ⲈⲦⲈⲦⲈⲚⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ⲀⲖⲖⲀ ⲞⲨⲆⲈ ⲠⲔⲈⲎⲢⲰⲆⲎⲤ ⲀϤⲞⲨⲞⲢⲠϤ ⲄⲀⲢ ϨⲀⲢⲞⲚ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲚϨⲰⲂ ⲚϦⲎⲦϤ ⲈⲀϤⲀⲒϤ ⲈϤⲘⲠϢⲀ ⲘⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ⲚⲦⲀϮⲤⲂⲰ ⲞⲨⲚ ⲚⲀϤ ⲚⲦⲀⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ⲚⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲔⲀϨⲤ ⲆⲈ ⲘⲘⲀⲨ ⲈⲐⲢⲈϤⲬⲰ ⲚⲞⲨⲀⲒ ⲚⲚⲎ ⲈⲦⲤⲞⲚϨ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲔⲀⲦⲀ ⲠϢⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ⲀⲠⲒⲘⲎϢ ⲆⲈ ⲦⲎⲢϤ ⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲀⲖⲒ ⲪⲀⲒ ⲬⲀ ⲂⲀⲢⲀⲂⲂⲀⲤ ⲚⲀⲚ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ⲪⲀⲒ ⲈⲦⲀⲨϨⲒⲦϤ ⲈⲠϢⲦⲈⲔⲞ ⲈⲐⲂⲈ ⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲈⲘ ⲞⲨϦⲰⲦⲈⲂ ⲈⲀϤϢⲰⲠⲒ ϦⲈⲚϮⲠⲞⲖⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ⲠⲀⲖⲒⲚ ⲆⲈ ⲞⲚ ⲀⲠⲒⲖⲀⲦⲞⲤ ⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲈϤⲞⲨⲰϢ ⲈⲬⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϢϤ ⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲘⲪⲘⲀϨⲄ ⲚⲤⲞⲠ ϪⲈ ⲞⲨ ⲄⲀⲢ ⲘⲠⲈⲦϨⲰⲞⲨ ⲠⲈⲦⲀ ⲪⲀⲒ ⲀⲒϤ ⲘⲠⲒϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ⲚⲦⲈⲪⲘⲞⲨ ⲚϦⲎⲦϤ ⲚⲦⲀϮⲤⲂⲰ ⲞⲨⲚ ⲚⲀϤ ⲚⲦⲀⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲞⲨⲀϨⲦⲞⲦⲞⲨ ϦⲈⲚϨⲀⲚⲚⲒϢϮ ⲚⲤⲘⲎ ⲈⲨⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲈⲐⲢⲞⲨⲀϢϤ ⲞⲨⲞϨ ⲚⲀⲨϪⲈⲘϪⲞⲘ ⲠⲈ ⲚϪⲈⲚⲞⲨⲤⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ⲞⲨⲞϨ ⲀⲠⲒⲖⲀⲦⲞⲤ ϮϨⲀⲠ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲚϪⲈⲠⲞⲨⲈⲦⲎⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ⲀϤⲬⲰ ⲆⲈ ⲈⲂⲞⲖ ⲘⲪⲎ ⲈⲦⲀⲨϨⲒⲦϤ ⲈⲠϢⲦⲈⲔⲞ ⲈⲐⲂⲈ ⲞⲨϦⲰⲦⲈⲂ ⲚⲈⲘ ϢⲐⲞⲢⲦⲈⲢ ⲪⲎ ⲈⲦⲀⲨⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲦⲎⲒϤ ⲔⲀⲦⲀ ⲠⲞⲨⲞⲨⲰϢ ");
INSERT INTO copbhc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ⲞⲨⲞϨ ϨⲰⲤ ⲈⲨⲒⲚⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲀⲨⲀⲘⲞⲚⲒ ⲚⲞⲨⲀⲒ ϪⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲔⲨⲢⲒⲚⲈⲞⲤ ⲈϤⲚⲎ ⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲔⲞⲒ ⲀⲨⲦⲀⲖⲈ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲈⲢⲞϤ ⲈⲐⲢⲈϤⲦⲰⲞⲨⲚ ⲘⲘⲞϤ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ⲚⲀϤⲘⲞϢⲒ ⲆⲈ ⲚⲤⲰϤ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ ⲚⲎ ⲈⲚⲀⲨⲦⲰⲒⲦ ⲞⲨⲞϨ ⲚⲀⲨⲚⲈϨⲠⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ⲈⲦⲀϤⲪⲞⲚϨϤ ⲆⲈ ⲈⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲚⲒϢⲈⲢⲒ ⲚⲦⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲘⲠⲈⲢⲢⲒⲘⲒ ⲈϪⲰⲒ ⲠⲖⲎⲚ ⲢⲒⲘⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲈⲘ ⲈϪⲈⲚ ⲚⲈⲦⲈⲚϢⲎⲢⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ϪⲈ ϨⲎⲠⲠⲈ ⲤⲈⲚⲎⲞⲨ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ⲚⲎ ⲈⲦⲞⲨⲚⲀϪⲞⲤ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲒⲀⲦϬ ⲢⲎⲚ ⲚⲈⲘ ⲚⲒⲚⲈϪⲒ ⲈⲦⲈⲘⲠⲞⲨⲘⲒⲤⲒ ⲚⲈⲘ ⲚⲒⲈⲘⲚⲞϮ ⲈⲦⲈⲘⲠⲞⲨϢⲀⲚϢ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ⲦⲞⲦⲈ ⲤⲈⲚⲀⲈⲢϨⲎⲦⲤ ⲚϪⲞⲤ ⲚⲚⲒⲦⲰⲞⲨ ϪⲈ ϨⲈⲒ ⲈϪⲰⲚ ⲚⲈⲘ ⲚⲒⲔⲀⲖⲀⲘⲪⲞ ϪⲈ ϨⲞⲂⲤⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ϪⲈ ⲒⲤϪⲈ ⲤⲈⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲠⲒϢⲈ ⲈⲦⲖⲎ ⲔⲒⲈ ⲞⲨ ⲠⲈⲐⲚⲀϢⲰⲠⲒ ϦⲈⲚⲠⲈⲦϢⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ⲚⲀⲨⲒⲚⲒ ⲆⲈ ⲚⲔⲈⲢⲈϤⲈⲢⲠⲈⲦϨⲰⲞⲨ Ⲃ- ⲚⲈⲘⲀϤ ⲈϦⲞⲐⲂⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈϪⲈⲚ ⲠⲒⲘⲀ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲔⲢⲀⲚⲒⲞⲚ ⲀⲨⲀϢϤ ⲘⲘⲀⲨ ⲚⲈⲘ ⲚⲒⲔⲀⲔⲞⲨⲢⲄⲞⲤ ⲞⲨⲀⲒ ⲘⲈⲚ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲞⲨⲀⲒ ⲆⲈ ⲤⲀϪⲀϬⲎ ⲀⲨⲪⲰϢ ⲆⲈ ⲚⲚⲈϤϨⲂⲰⲤ ⲈϨⲢⲀⲨ ⲀⲨϨⲒⲰⲠ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲬⲰ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ϪⲈ ⲘⲠⲞⲨⲈⲘⲒ ⲈⲚⲎ ⲈⲦⲞⲨⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ⲞⲨⲞϨ ⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲠⲈ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲈϤⲚⲀⲨ ⲚⲀⲨⲈⲖⲔϢⲀⲒ ⲆⲈ ⲠⲈ ⲚϪⲈⲚⲒⲔⲈⲀⲢⲬ ⲰⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤⲚⲞϨⲈⲘ ⲚϨⲀⲚⲔⲈⲬ ⲰⲞⲨⲚⲒ ⲘⲀⲢⲈϤⲚⲀϨⲘⲈϤ ϨⲰϤ ⲒⲤϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲠⲒⲤⲰⲦⲠ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ⲚⲀⲨⲤⲰⲂⲒ ⲆⲈ ⲘⲘⲞϤ ⲚϪⲈⲚⲒⲔⲈⲘⲀⲦⲞⲒ ⲈⲨⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲀⲨⲒⲚⲒ ⲚⲞⲨϨⲈⲘϪ ⲚⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲀϨⲘⲈⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ⲚⲈ ⲞⲨⲞⲚ ⲔⲈⲈⲠⲒⲄⲢⲀⲪⲎ ⲆⲈ ⲠⲈ ϨⲒϪⲰϤ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲘⲘⲈⲦⲢⲰⲘⲈⲞⲤ ⲘⲘⲈⲦⲞⲨⲈⲒⲚⲒⲚ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ⲞⲨⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲀⲔⲞⲨⲢⲄⲞⲤ ⲈⲦⲀⲨⲀϢⲞⲨ ⲚⲈⲘⲀϤ ϪⲈⲞⲨⲀ ⲈⲢⲞϤ ⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲚⲐⲞⲔ ⲀⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲀϨⲘⲈⲔ ⲞⲨⲞϨ ⲚⲀϨⲘⲈⲚ ϨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒⲔⲈⲞⲨⲀⲒ ⲀϤⲈⲢⲈⲠⲒⲦⲒⲘⲀⲚ ⲚⲀϤ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲆⲈ ⲪⲚⲞⲨϮ ⲚⲐⲞⲔ ⲔⲈⲢϨⲞϮ ⲀⲚ ϦⲀⲦⲈϤϨⲎ ϪⲈ ⲀⲚⲬⲎ ϦⲈⲚⲠⲀⲒϨⲀⲠ ⲚⲞⲨⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲘⲈⲚ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲈⲦⲀⲚϬⲒ ⲔⲀⲦⲀ ⲠⲈⲘⲠϢⲀ ⲚⲚⲎ ⲈⲦⲀⲚⲀⲒⲦⲞⲨ ⲪⲀⲒ ⲆⲈ ⲘⲠⲈϤⲈⲢ ϨⲖⲒ ⲘⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲢⲒⲠⲀⲘⲈⲨⲒ ϨⲞⲦⲀⲚ ⲀⲔϢⲀⲚⲒ ϦⲈⲚⲦⲈⲔⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲘⲪⲞⲞⲨ ⲈⲔⲈϢⲰⲠⲒ ⲚⲈⲘⲎⲒ ϦⲈⲚⲠⲒⲠⲀⲢⲀⲆⲒⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ⲞⲨⲞϨ ⲚⲈⲪⲚⲀⲨ ϨⲎⲆⲎ ⲚⲀϪⲠ 6- ⲠⲈ ⲞⲨⲞϨ ⲀⲞⲨⲬⲀⲔⲒ ϢⲰⲠⲒ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲦⲎⲢϤ ϢⲀ ⲪⲚⲀⲨ ⲚⲀϪⲠ Ⲯ-. ");
INSERT INTO copbhc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ⲈϤⲚⲀⲘⲞⲨⲚⲔ ⲆⲈ ⲚϪⲈⲠⲒⲢⲎ ⲀⲠⲒⲔⲀⲦⲀⲠⲈⲦⲀⲤⲘⲀ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲪⲰϦ ϦⲈⲚⲦⲈϤⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨϮ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ϮϮ ⲘⲠⲀⲠⲚⲈⲨⲘⲀⲈϦⲢⲎⲒ ⲈⲚⲈⲔϪⲒϪ ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲀϤϮ ⲘⲠⲒⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬ ⲞⲤ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲚⲀϤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲚⲦⲰⲤ ⲚⲈⲠⲀⲒⲢⲰⲘⲒ ⲞⲨⲐⲘⲎ ⲒⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ⲞⲨⲞϨ ⲚⲒⲘⲎϢ ⲦⲎⲢⲞⲨ ⲈⲦⲀⲨⲒ ⲈϪⲈⲚ ⲦⲀⲒⲐⲈⲰⲢⲒⲀ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲀⲨⲦⲀⲤⲐⲞ ⲈⲨⲔⲰⲖϨ ϦⲈⲚⲦⲞⲨⲘⲈⲤⲦⲈⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ⲚⲀⲨⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ϨⲒⲪⲞⲨⲈⲒ ⲠⲈ ⲚϪⲈⲚⲈϤⲢⲈⲘⲚⲤⲰⲞⲨⲚ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ϨⲀⲚⲔⲈϨⲒⲞⲘⲒ ⲚⲎ ⲈⲦⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲒⲤϪⲈⲚ ϮⲄⲀⲖⲒⲖⲈⲀ ⲈⲨⲚⲀⲨ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲤⲎⲪ ⲈⲞⲨⲂⲞⲨⲖⲈⲨⲦⲎⲤ ⲠⲈ ⲈⲞⲨⲢⲰⲘⲒ ⲚⲀⲄⲀⲐⲞⲤ ⲠⲈ ⲞⲨⲞϨ ⲚⲐⲘⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ⲪⲀⲒ ⲚⲀϤϮⲘⲀϮ ⲀⲚ ⲠⲈ ϦⲈⲚⲠⲞⲨⲤⲞϬ ⲚⲒ ⲚⲈⲘ ⲦⲞⲨⲠⲢⲀⲜⲒⲤ ⲚⲈⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲀⲢⲒⲘⲀⲐⲈⲀⲤ ⲠⲈ ⲞⲨⲂⲀⲔⲒ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲪⲎ ⲈⲚⲀϤϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲈⲚ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ⲪⲀⲒ ⲈⲦⲀϤⲒ ϨⲀ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲈⲢⲈⲦⲒⲚ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲚϤ ⲈⲠⲈⲤⲎⲦ ⲀϤⲔⲞⲨⲖⲰⲖϤ ϦⲈⲚⲞⲨϢⲈⲚⲦⲰ ⲞⲨⲞϨ ⲀϤⲬⲀϤ ϦⲈⲚⲞⲨⲘϨⲀⲨ ⲈⲀϤϢⲞⲔϤ ⲘⲠⲀⲦⲞⲨⲬⲀ ϨⲖⲒ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀϤⲤⲔⲈⲢⲔⲈⲢ ⲚⲞⲨⲚⲒϢϮ ⲚⲰⲚⲒ ϨⲒⲢⲈⲚ ⲪⲢⲞ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ⲞⲨⲞϨ ⲚⲈⲞⲨⲈϨⲞⲞⲨ ⲠⲈ ⲘⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲞⲨⲞϨ ⲚⲈⲀ ϢⲰⲢⲠ ϢⲰⲠⲒ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ⲈⲦⲀⲨⲘⲞϢⲒ ⲆⲈ ⲚⲤⲰϤ ⲚϪⲈⲚⲒϨⲒⲞⲘⲒ ⲚⲎ ⲈⲦⲀⲨⲒ ⲚⲈⲘⲀϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲀⲨⲚⲀⲨ ⲈⲠⲒⲈⲘϨⲀⲨ ⲚⲈⲘ ⲠⲒⲢⲎϮ ⲈⲦⲀⲨⲬⲀ ⲠⲈϤⲤⲰⲘⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ⲈⲦⲀⲨⲦⲀⲤⲐⲞ ⲆⲈ ⲀⲨⲤⲈⲂⲦⲈ ϨⲀⲚⲤⲐⲞⲒ ⲚⲈⲘ ϨⲀⲚⲤⲞϪⲈⲚ ⲞⲨⲞϨ ⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲈⲚ ⲀⲨⲈⲢⲎⲤⲨⲬⲀⲌⲒⲚ ⲔⲀⲦⲀ ϮⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ϦⲈⲚ ⲪⲞⲨⲀⲒ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲚϢⲞⲢⲠ ⲈⲘⲀϢⲰ ⲀⲨⲒ ⲈⲠⲒⲘϨⲀⲨ ⲈⲀⲨⲒⲚⲒ ⲚⲚⲒⲤⲐⲞⲒ ⲈⲦⲀⲨⲤⲈⲂⲦⲰⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ⲀⲨϪⲒⲘⲒ ⲆⲈ ⲘⲠⲒⲰⲚⲒ ⲈⲀⲨⲤⲔⲈⲢⲔⲰⲢϤ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ⲈⲦⲀⲨϢⲈ ⲆⲈ ⲈϦⲞⲨⲚ ⲘⲠⲞⲨϪⲈⲘ ⲠⲤⲰⲘⲀ ⲚⲦⲈⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲨⲈⲢⲀⲠⲞⲢⲒⲤⲐⲈ ⲈⲐⲂⲈⲪⲀⲒ ϨⲎⲠⲠⲈ ⲒⲤ ⲢⲰⲘⲒ ⲂⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲤⲀⲠϢⲰⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚϨⲀⲚϨⲈⲂⲤⲰ ⲈⲨϨⲒⲤⲈⲦⲈⲂⲢⲎϪ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ⲈⲦⲀⲨϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲞⲨϨⲞϮ ⲞⲨⲞϨ ⲈⲨⲢⲒⲔⲒ ⲘⲠⲞⲨϨⲞ ⲈⲠⲔⲀϨⲒ ⲠⲈϪⲰⲞⲨ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲠⲈⲦⲞⲚϦ ⲚⲈⲘ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ⲚϤⲬⲎ ⲘⲠⲀⲒⲘⲀ ⲀⲚ ⲀⲖⲖⲀ ⲀϤⲦⲰⲚϤ ⲀⲢⲒⲪⲘⲈⲨⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲈⲦⲒ ⲈϤϦⲈⲚ ϮⲄⲀⲖⲒⲖⲈⲀ ");
INSERT INTO copbhc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲰϮ ⲚⲦⲞⲨϮ ⲘⲠϢⲎ ⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚϨⲀⲚⲢⲰⲘⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲞⲨⲞϨ ⲚⲤⲈⲀϢϤ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲰⲚϤ ϦⲈⲚⲠⲒⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ⲞⲨⲞϨ ⲀⲨⲈⲢⲪⲘⲈⲨⲒ ⲚⲚⲈϤⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲀⲤⲐⲞ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘϨⲀⲨ ⲀⲨⲦⲀⲘⲈ ⲠⲒⲒⲀ ⲈⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒⲤⲰϪⲠ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ⲚⲈ ⲘⲀⲢⲒⲀ ⲆⲈ ⲦⲈ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲀ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲚⲦⲈⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲠⲤⲰϪⲠ ⲈⲐⲚⲈⲘⲰⲞⲨ ⲚⲎ ⲈⲚⲀⲨϪⲰ ⲚⲚⲀⲒ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲚϨ ⲚϪⲈⲚⲀⲒⲤⲀϪⲒ ⲘⲠⲞⲨⲘⲐⲞ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲚⲞⲨⲈⲂϢⲒ ⲞⲨⲞϨ ⲚⲀⲨⲦⲈⲚϨⲞⲦⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲦⲰⲚϤ ⲀϤϬⲞϪⲒ ⲈⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲞⲘⲤ ⲈϦⲞⲨⲚ ⲀϤⲚⲀⲨ ⲈⲚⲒϨⲂⲰⲤ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲈϤⲎⲒ ⲈϤⲈⲢϢⲪⲎⲢⲒ ⲘⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲂⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲚⲀⲨⲘⲞϢⲒ ⲠⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲚⲀ ⲈⲞⲨϮⲘⲒ ⲈⲤⲞⲨⲎⲞⲨ ⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲀⲨ ⲜⲚⲤⲦⲀⲆⲒⲞⲚ ⲈⲠⲈⲤⲢⲀⲚ ⲈⲘⲘⲀⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎ ⲞⲨ ⲈⲐⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲨⲤⲀϪⲒ ⲞⲨⲞϨ ⲈⲨⲔⲰϮ ⲚⲐⲞϤ ϨⲰϤ ⲒⲎⲤⲞⲨⲤ ⲀϤϦⲰⲚⲦ ⲈⲢⲰⲞⲨ ⲀϤⲘⲞϢⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ⲚⲀⲨⲀⲘⲞⲚⲒ ⲆⲈ ⲚⲚⲞⲨⲂⲀⲖ ⲈϢⲦⲈⲘⲤⲞⲨⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲚⲀⲒⲤⲀϪⲒ ⲞⲨ ⲚⲈⲈⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲰⲞⲨ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲈⲢⲈⲦⲈⲚⲘⲞϢⲒ ⲞⲨⲞϨ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲈⲨⲞⲔⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲞⲨⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲔⲖⲈⲞⲠⲀⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲘⲘⲀⲨⲀⲦⲔ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲘⲠⲈⲔⲈⲘⲒ ⲈⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲚϦⲎⲦⲤ ϦⲈⲚⲚⲀⲒⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲚⲈⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲎ ⲈⲦⲀⲨϢⲰⲠⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲘⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ϦⲈⲚⲠϨⲰⲂ ⲚⲈⲘ ⲠⲤⲀϪⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ");
INSERT INTO copbhc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ϨⲰⲤⲆⲈ ⲀⲨⲦⲎⲒϤ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲰⲚ ⲈⲨϨⲀⲠ ⲚⲦⲈⲪⲘⲞⲨ ⲞⲨⲞϨ ⲀⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲈⲢϨⲈⲖⲠⲒⲤ ϪⲈ ⲪⲀⲒ ⲠⲈⲐⲚⲀⲤⲰϮ ⲘⲠⲒⲤⲖ ⲀⲖⲖⲀ ⲚⲈⲘ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲦⲈϤⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ ⲠⲈ ⲪⲀⲒ ⲒⲤϪⲈⲚ ⲈⲦⲀ ⲚⲀⲒ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ⲀⲖⲖⲀ ⲚⲈⲘ ϨⲀⲚⲔⲈϨⲒⲞⲘⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲈⲚ ⲀⲨⲐⲢⲈⲚⲈⲢϢⲪⲎⲢⲒ ⲈⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲠⲒⲘϨⲀⲨ ⲚϢⲰⲢⲠ ");
INSERT INTO copbhc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲞⲨϪⲈⲘ ⲠⲈϤⲤⲰⲘⲀ ⲀⲨⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈⲞⲨⲞⲨⲰⲚϨ ⲚⲦⲈϨⲀⲚⲀⲄⲄⲈⲖⲞⲤ ⲚⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ϤⲞⲚϦ ");
INSERT INTO copbhc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲈⲚ ⲈⲠⲒⲘϨⲀⲨ ⲀⲨϪⲒⲘⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀ ⲚⲒⲔⲈϨⲒⲞⲘⲒ ϪⲞⲤ ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ Ⲱ- ⲚⲒⲀⲚⲞⲎⲦⲞⲤ ⲞⲨⲞϨ ⲈⲦⲞⲤⲔ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲈⲚⲀϨϮ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚϪⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ⲘⲎ ⲚⲀⲤⲬⲎ ⲀⲚ ⲈⲐⲢⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ϬⲒ ⲚⲚⲀⲒⲘⲔⲀⲨϨ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢϨⲎⲦⲤ ⲈⲂⲞⲖ ϦⲈⲚⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲚⲀϤⲈⲢⲘⲎ ⲚⲈⲨⲒⲚ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲚⲈⲚⲎ ⲈⲦϦⲈⲚ ⲚⲒⲄⲢⲀⲪⲎ ⲦⲎⲢⲞⲨ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ⲞⲨⲞϨ ⲀⲨϦⲰⲚⲦ ⲈⲠⲒϮⲘⲒ ⲈⲚⲀⲨⲚⲀϢⲈ ⲈⲢⲞϤ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢ ⲘⲪⲢⲎϮ ⲈϤⲚⲀⲞⲨⲈⲒ ⲈϤⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ⲞⲨⲞϨ ⲚⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲚϪⲞⲚⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞϨⲒ ⲚⲈⲘⲀⲚ ϪⲈ ⲢⲞⲨϨⲒ ⲞⲨⲞϨ ϨⲎⲆⲎ ⲀϤⲢⲒⲔⲒ ⲚϪⲈⲠⲒⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ϪⲈ ⲚⲦⲈϤⲞϨⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤⲢⲰⲦⲈⲂ ⲚⲈⲘⲰⲞⲨ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲰⲒⲔ ⲀϤⲤⲘⲞⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲀϢϤ ⲚⲀϤϮ ⲚⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲚⲞⲨⲂⲀⲖ ⲞⲨⲰⲚ ⲞⲨⲞϨ ⲀⲨⲤⲞⲨⲰⲚϤ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲀϤⲈⲢⲀⲐⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲘⲎ ⲚⲀⲢⲈ ⲚⲈⲚϨⲎⲦ ⲢⲞⲔϨ ⲀⲚ ⲠⲈ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ϨⲰⲤ ⲈϤⲤⲀϪⲒ ⲚⲈⲘⲀⲚ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲈϤⲞⲨⲰⲚϨ ⲚⲚⲒⲄⲢⲀⲪⲎ ⲚⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ⲞⲨⲞϨ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲦⲀⲤⲐⲞ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲀⲨϪⲒⲘⲒ ⲘⲠⲒⲒⲀ ⲈⲨⲐⲞⲨⲎⲦ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲚⲦⲰⲤ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲤⲒⲘⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲚⲀⲨⲤⲀϪⲒ ⲚⲚⲎ ⲈⲦϦⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲚⲈⲘ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲰⲚϨ ⲈⲢⲰⲞⲨ ϦⲈⲚⲠⲒⲪⲰϢ ⲚⲦⲈⲠⲒⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ⲚⲀⲒ ⲆⲈ ⲈⲨⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚⲐⲞϤ ⲒⲎⲤⲞⲨⲤ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϮϨⲒⲢⲎⲚⲎ ⲚⲰⲦⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ⲈⲦⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲆⲈ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲰⲠⲒ ϦⲈⲚⲞⲨϨⲞϮ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ⲞⲨⲠⲚⲈⲨⲘⲀⲠⲈ ⲈⲦⲞⲨⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϢⲦⲈⲢⲐⲰⲢ ⲞⲨⲞϨ ⲈⲐⲂⲈⲞⲨ ⲤⲈⲚⲎⲞⲨ ⲚϪⲈϨⲀⲚⲘⲈⲨⲒ ⲈϪⲈⲚ ⲚⲈⲦⲈⲚϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ⲀⲚⲀⲨ ⲈⲚⲀϪⲒϪ ⲚⲈⲘ ⲚⲀϬⲀⲖⲀⲨϪ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ϪⲞⲘϪⲈⲘ ⲈⲢⲞⲒ ⲞⲨⲞϨ ⲀⲚⲀⲨ ϪⲈ ⲘⲘⲞⲚ ⲠⲚⲈⲨⲘⲀⲈⲞⲨⲞⲚⲦⲈϤ ⲤⲀⲢⲜ ϨⲒ ⲔⲀⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲈⲞⲨⲞⲚ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲀϤⲦⲀⲘⲰⲞⲨ ⲈⲚⲈϤϪⲒϪ ⲚⲈⲘ ⲚⲈϤϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ⲈⲦⲒ ⲆⲈ ⲈⲨⲞⲒ ⲚⲀⲐⲚⲀϨϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲀϢⲒ ⲞⲨⲞϨ ⲈⲨⲈⲢϢⲪⲎⲢⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲞⲚⲦⲈⲦⲈⲚ ⲚⲬⲀⲒ ⲚⲞⲨⲰⲘ ⲘⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϮ ⲚⲀϤ ⲚⲞⲨⲘⲈⲢⲞⲤ ⲚⲦⲈⲞⲨⲦⲈⲂⲦ ⲈϤϪⲈϤϪⲰϤ ⲚⲈⲘ ⲞⲨⲘⲞⲨⲖϨ ⲚⲈⲂⲒⲰ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒ ⲘⲠⲞⲨⲘⲐⲞ ⲀϤⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲚⲀⲒ ⲚⲈⲚⲀⲤⲀϪⲒ ⲈⲦⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲈⲦⲒ ⲈⲒⲬⲎ ⲚⲈⲘⲰⲦⲈⲚ ϪⲈ ϨⲰϮ ⲚⲦⲞⲨϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲤϦⲎⲞⲨⲦ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ⲚⲒⲮⲀⲖⲘⲞⲤ ⲈⲐⲂⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ⲦⲞⲦⲈ ⲀϤⲞⲨⲰⲚ ⲘⲠⲞⲨϨⲎⲦ ⲈⲐⲢⲞⲨⲔⲀϮ ⲈⲚⲒⲄⲢⲀⲪⲎ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ϪⲈ ⲀⲤⲤϦⲎⲞⲨⲦ ⲘⲠⲀⲒⲢⲎϮ ⲈⲐⲢⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ϢⲈⲠⲘⲔⲀϨ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ϦⲈⲚⲠⲒⲘⲀϨⲄ ⲚⲈϨⲞⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ⲞⲨⲞϨ ⲚⲦⲞⲨϨⲒⲰⲒϢ ⲚⲞⲨⲘⲈⲦⲀⲚⲞⲒⲀ ϦⲈⲚⲠⲈϤⲢⲀⲚ ⲈⲠⲬⲀ ⲚⲞⲂⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲀⲦⲈⲦⲈⲚⲈⲢϨⲎⲦⲤ ⲒⲤϪⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲢⲘⲈⲐⲢⲈ ϦⲀ ⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ⲞⲨⲞϨ ⲀⲚⲞⲔ ϮⲚⲀⲞⲨⲰⲢⲠ ⲘⲠⲒⲰϢ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ϨⲈⲘⲤⲒ ϦⲈⲚϮⲂⲀⲔⲒ ϢⲀⲦⲈⲦⲈⲚϬⲒ ⲚⲞⲨϪⲞⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠϬⲒⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ⲞⲨⲞϨ ⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ ϢⲀ ⲂⲎⲐⲀⲚⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀϤϤⲀⲒ ⲚⲚⲈϤϪⲒϪ ⲈⲠϢⲰⲒ ⲀϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲠϪⲒⲚⲦⲈϤⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲀϤⲞⲨⲰϮ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲰⲖⲒ ⲘⲘⲞϤ ⲠⲈ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲈⲦⲀⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ");
INSERT INTO copbhc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ⲞⲨⲞϨ ⲚⲀⲨⲬⲎ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈⲨⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ϦⲈⲚ ⲦⲀⲢⲬⲎ ⲚⲈⲠⲒⲤⲀϪⲒ ⲠⲈ ⲞⲨⲞϨ ⲠⲒⲤⲀϪⲒ ⲚⲀϤⲬⲎ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲈⲞⲨⲚⲞⲨϮ ⲠⲈ ⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ⲪⲀⲒ ⲈⲚⲀϤⲬⲎ ⲒⲤϪⲈⲚ ϨⲎ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲨϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲀⲦϬⲚⲞⲨϤ ⲘⲠⲈ ϨⲖⲒ ϢⲰⲠⲒ ϦⲈⲚⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ⲚⲈ ⲠⲰⲚϦ ⲠⲈⲦⲈⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲠⲰⲚϦ ⲚⲈⲪⲞⲨⲰⲒⲚⲒ ⲚⲚⲒⲢⲰⲘⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ⲞⲨⲞϨ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ϦⲈⲚⲠⲒⲬⲀⲔⲒ ⲞⲨⲞϨ ⲘⲠⲈ ⲠⲒⲬⲀⲔⲒ ⲦⲀϨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈⲀⲨⲞⲨⲞⲢⲠϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ⲪⲀⲒ ⲀϤⲒ ⲈⲨⲘⲈⲦⲘⲈⲐⲢⲈ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢⲘⲈⲐⲢⲈ ϦⲀ ⲠⲒⲞⲨⲰⲒⲚⲒ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲚⲀϨϮ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ⲚⲈ ⲚⲐⲞϤ ⲀⲚ ⲠⲈ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢⲘⲈⲐⲢⲈ ϦⲀ ⲠⲒⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ⲚⲀϤϢⲞⲠ ⲚϪⲈⲠⲒⲞⲨⲰⲒⲚⲒ ⲚⲦⲀⲪⲘⲎⲒ ⲪⲎ ⲈⲦⲈⲢⲞⲨⲰⲒⲚⲒ ⲈⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲎⲞⲨ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ⲚⲀϤⲬⲎ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲠⲈ ⲞⲨⲞϨ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲀϤϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲘⲠⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ⲀϤⲒ ϨⲀ ⲚⲎ ⲈⲦⲈⲚⲞⲨϤ ⲞⲨⲞϨ ⲚⲈⲦⲈⲚⲞⲨϤ ⲘⲠⲞⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ⲚⲎ ⲆⲈ ⲈⲦⲀⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ ⲀϤϮⲈⲢϢⲒϢⲒ ⲚⲰⲞⲨ ⲈⲈⲢϢⲎⲢⲒ ⲚⲚⲞⲨϮ ⲚⲎ ⲈⲐⲚⲀϨϮ ⲈⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ⲚⲎ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲤⲚⲞϤ ⲀⲚ ⲚⲈⲞⲨⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲪⲞⲨⲰϢ ⲚⲤⲀⲢⲜ ⲀⲚ ⲚⲈⲞⲨⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲪⲞⲨⲰϢ ⲚⲢⲰⲘⲒ ⲀⲚ ⲚⲈⲀⲖⲖⲀ ⲈⲦⲀⲨⲘⲀⲤⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ⲞⲨⲞϨ ⲠⲒⲤⲀϪⲒ ⲀϤⲈⲢⲞⲨⲤⲀⲢⲜ ⲞⲨⲞϨ ⲀϤϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ⲞⲨⲞϨ ⲀⲚⲚⲀⲨ ⲈⲠⲈϤⲰⲞⲨ ⲘⲪⲢⲎϮ ⲘⲠⲰⲞⲨ ⲚⲞⲨϢⲎⲢⲒ ⲘⲘⲀⲨⲀⲦϤ ⲚⲦⲞⲦϤ ⲘⲠⲈϤⲒⲰⲦ ⲈϤⲘⲈϨ ⲚϨⲘⲞⲦ ⲚⲈⲘ ⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ⲒⲰⲀⲚⲚⲎⲤ ϤⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞϨ ϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲪⲎ ⲈⲦⲀⲒϪⲞϤ ⲈⲐⲂⲎⲦϤ ϪⲈ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ⲀϤⲈⲢϢⲞⲢⲠ ⲈⲢⲞⲒ ϪⲈ ⲚⲈⲞⲨϢⲞⲢⲠ ⲈⲢⲞⲒ ⲢⲰ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ϪⲈ ⲀⲚⲞⲚ ⲦⲎⲢⲈⲚ ⲀⲚϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲘⲞϨ ⲚⲈⲘ ⲞⲨϨⲘⲞⲦ ⲚⲦϢⲈⲂⲒⲰ ⲚⲞⲨϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ϪⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲀⲨⲦⲎⲒϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲘⲰⲨⲤⲎⲤ ⲠⲒϨⲘⲞⲦ ⲆⲈ ⲚⲈⲘ ϮⲘⲈⲐⲘⲎⲒ ⲀⲨϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ⲪⲚⲞⲨϮ ⲘⲠⲈ ϨⲖⲒ ⲚⲀⲨ ⲈⲢⲞϤ ⲈⲚⲈϨ ⲠⲒⲘⲞⲚⲞⲄⲈⲚⲎ ⲤⲚⲚⲞⲨϮ ⲪⲎ ⲈⲦⲬⲎ ϦⲈⲚⲔⲈⲚϤ ⲘⲠⲈϤⲒⲰⲦ ⲚⲐⲞϤ ⲠⲈⲦⲀϤⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ⲞⲨⲞϨ ⲐⲀⲒ ⲦⲈ ϮⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ϨⲞⲦⲈ ⲈⲦⲀⲨⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚϨⲀⲚⲞⲨⲎⲂ ⲚⲈⲘ ϨⲀⲚⲖⲈⲨⲒⲦⲎⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲈⲚϤ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲚϨ ⲘⲠⲈϤϪⲰⲖ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲚϨ ϪⲈ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲎⲖⲒⲀⲤ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ ⲚⲐⲞⲔ ⲠⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲀϤⲈⲢⲞⲨⲰ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲞⲨⲚ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ϨⲒⲚⲀ ⲚⲦⲈⲚϪⲈⲘⲠϢⲒⲚⲒ ⲚⲚⲎ ⲈⲦⲀⲨⲦⲀⲞⲨⲞⲚ ⲞⲨ ⲠⲈⲦⲈⲔϪⲰ ⲘⲘⲞϤ ⲈⲐⲂⲎⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ϮⲤⲘⲎ ⲈⲦⲰϢ ⲈⲂⲞⲖ ϨⲒ ⲠϢⲀϤⲈ ϪⲈ ⲤⲞⲨⲦⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲠϬⲞⲒⲤ ⲘⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚϪⲈⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ⲞⲨⲞϨ ⲚⲈⲀⲨⲞⲨⲰⲢⲠ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔϮⲰⲘⲤ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲀⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲆⲈ ⲎⲖⲒⲀⲤ ⲞⲨⲆⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ϮⲰⲘⲤ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲈⲦⲈⲚⲘⲎϮ ⲚϪⲈⲪⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ⲪⲎ ⲈⲦⲈⲚϮⲘⲠϢⲀ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲀϮⲞⲨⲰ ⲚⲞⲨⲘⲞⲨⲤⲈⲢ ⲚⲦⲈⲠⲈϤⲐⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ⲚⲀⲒ ⲀⲨϢⲰⲠⲒ ϦⲈⲚⲂⲎⲐⲀⲚⲒⲀ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲒⲰⲀⲚⲚⲎⲤ ϮⲰⲘⲤ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲒⲤ ⲠⲒϨⲒⲎⲂ ⲚⲦⲈⲪⲚⲞⲨϮ ⲪⲎ ⲈⲐⲚⲀⲰⲖⲒ ⲘⲪⲚⲞⲂⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲀⲒϪⲞⲤ ⲀⲚⲞⲔ ⲈⲐⲂⲎⲦⲔ ϪⲈ ϤⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ⲚϪⲈⲞⲨⲢⲰⲘⲒ ⲈⲀϤⲈⲢϢⲞⲢⲠ ⲈⲢⲞⲒ ϪⲈ ⲞⲨϢⲞⲢⲠ ⲈⲢⲞⲒ ⲢⲰ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲚⲀⲒⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲠⲒⲤⲖ ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲒⲒ ⲈϮⲰⲘⲤ ϦⲈⲚⲞⲨⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ⲞⲨⲞϨ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲚⲀⲨ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈϤⲚⲎⲞⲨ ⲈϦⲢⲎ ⲒⲈϪⲰϤ ⲘⲪⲢⲎϮ ⲚⲞⲨϬⲢⲞⲘⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲀϤⲞϨⲒ ϨⲒϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲚⲀⲒⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲈϮⲰⲘⲤ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲚⲐⲞϤ ⲠⲈⲦⲀϤϪⲞⲤ ⲚⲎⲒ ϪⲈ ⲪⲎ ⲈⲦⲈⲔⲚⲀⲨ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈϤⲚⲎⲞⲨ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲞϨⲒ ϨⲒϪⲰϤ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲐⲚⲀϮⲰⲘⲤ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ");
INSERT INTO copbhc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲀⲒⲚⲀⲨ ⲞⲨⲞϨ ⲀⲒⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲞⲚ ⲚⲀⲢⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲈⲘ ⲂⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲘⲞϢⲒ ⲠⲈϪⲀϤ ϪⲈ ⲒⲤ ⲠⲒϨⲎⲒⲂ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ⲞⲨⲞϨ ⲀⲨⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈϤⲤⲀϪⲒ ⲚϪⲈⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲂⲚⲦⲀϤ ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ⲈⲦⲀϤⲪⲞⲚϨϤ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲈⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲪⲎ ⲈⲦⲈ ϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲀⲔϢⲞⲠ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲞⲨⲞϨ ⲀⲚⲀⲨ ⲀⲨⲒ ⲞⲨⲚ ⲞⲨⲞϨ ⲀⲨⲚⲀⲨ ϪⲈ ⲀϤϢⲞⲠ ⲐⲰⲚ ⲞⲨⲞϨ ⲀⲨϢⲰⲠⲒ ϦⲀⲦⲞⲦϤ ⲘⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲪⲚⲀⲨ ⲆⲈ ⲚⲀϪⲠ Ⲓ- ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ⲀⲚⲆⲢⲈⲀⲤ ⲆⲈ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲞⲨⲀⲒ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲂ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ⲪⲀⲒ ⲆⲈ ⲀϤϪⲒⲘⲒ ⲚϢⲞⲢⲠ ⲘⲠⲈϤⲤⲞⲚ ⲤⲒⲘⲰⲚ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚϪⲒⲘⲒ ⲘⲘⲈⲤⲒⲀⲤ ⲪⲎ ⲈⲦⲈ ⲠⲈϤⲞⲨⲰϨⲈⲘ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ⲪⲀⲒ ⲀϤⲈⲚϤ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀϤϪⲞⲨϢⲦ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲤⲒⲘⲰⲚ ⲠϢⲎⲢⲒ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲚⲐⲞⲔ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲞⲔ ϪⲈ ⲔⲎⲪⲀ ⲪⲎ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤⲞⲨⲰϢ ⲈⲒ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲀϤϪⲒⲘⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲚⲈⲞⲨⲢⲈⲘⲂⲎⲐⲤⲀⲒⲆⲀ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲐⲂⲀⲔⲒ ⲚⲀⲚⲆⲢⲈⲀⲤ ⲚⲈⲘ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲀϤϪⲒⲘⲒ ⲚⲚⲀⲐⲀⲚⲀⲎⲖ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲎ ⲈⲦⲀ ⲘⲰⲨⲤⲎⲤ ⲤϦⲀⲒ ⲈⲐⲂⲎⲦϤ ϨⲒ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲚϪⲈⲘϤ ⲈⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲠϢⲎⲢⲒ ⲚⲒⲰⲤⲎⲪ ⲠⲒⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲌⲀⲢⲈⲐ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲚⲀⲐⲀⲚⲀⲎⲖ ⲚⲀϤ ϪⲈ ⲀⲚ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲞⲨⲀⲄⲀⲐⲞⲚ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲌⲀⲢⲈⲐ ⲠⲈϪⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲞⲨⲞϨ ⲀⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲀⲐⲀⲚⲀⲎⲖ ⲈϤⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲈⲐⲂⲎⲦϤ ϪⲈ ⲒⲤ ϨⲎⲠⲠⲈ ⲦⲀⲪⲘⲎⲒ ⲒⲤ ⲞⲨⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲘⲘⲞⲚ ⲆⲞⲖⲞⲤ ⲚϦⲎⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ⲠⲈϪⲈ ⲚⲀⲐⲀⲚⲀⲎⲖ ⲚⲀϤ ϪⲈ ⲀⲔⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲐⲰⲚ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲠⲀⲦⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲘⲞⲨϮ ⲈⲢⲞⲔ ⲈⲔⲬⲎ ϦⲀⲦⲞⲦⲤ ⲚϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲀⲒⲚⲀⲨ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲚⲀⲐⲀⲚⲀⲎⲖ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲀⲒ ⲚⲐⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲀⲔ ϪⲈ ⲀⲒⲚⲀⲨ ⲈⲢⲞⲔ ϦⲀⲢⲀⲦⲤ ⲚϮⲂⲰ ⲚⲔⲈⲚⲦⲈ ⲬⲚⲀϨϮ ϨⲀⲚⲚⲒϢϮ ⲈⲚⲀⲒ ⲈⲔⲈⲚⲀⲨ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈⲢⲈⲦⲈⲚⲈⲚⲀⲨ ⲈⲦⲪⲈ ⲈⲤⲞⲨⲎ ⲚⲞⲨⲞϨ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲨⲚⲀ ⲈⲠϢⲰⲒ ⲞⲨⲞϨ ⲈⲨⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲚⲤⲀⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ⲞⲨⲞϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲘⲘⲀϨⲄ ⲞⲨϨⲞⲠ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲦⲔⲀⲚⲀ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲐⲘⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ⲀⲨⲐⲀϨⲈⲘ ⲠⲔⲈⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲠⲒϨⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲨⲚⲔ ⲚϪⲈⲠⲒⲎⲢⲠ ⲠⲈϪⲈ ⲐⲘⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲘⲞⲚⲦⲞⲨ ⲎⲢⲠ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲀϦⲞ ⲚⲈⲘⲎⲒ ϨⲰⲒ ϮⲤϨⲒⲘⲒ ⲘⲠⲀⲦⲈⲤⲒ ⲚϪⲈⲦⲀⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ⲠⲈϪⲈ ⲦⲈϤⲘⲀⲨ ⲆⲈ ⲚⲚⲒⲆⲒⲀⲔⲰⲚ ϪⲈ ⲪⲎ ⲈⲦⲈϤⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲢⲒⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ⲚⲀⲨⲬⲎ ⲆⲈ ⲘⲘⲀⲨ ⲠⲈ ⲚϪⲈⲚϨⲨⲆⲢⲒⲀ ⲚⲰⲚⲒ ⲔⲀⲦⲀ ⲠⲦⲞⲨⲂⲞ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲈⲨⲰⲖⲒ ⲘⲘⲈⲦⲢⲒⲦⲎⲤ ⲂⲒⲈ ⲄⲈⲐⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲞϨ ⲚⲚⲒϨⲨⲆⲢⲒⲀ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲘⲀϨⲞⲨ ϢⲀⲠϢⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲰⲦϨ ϮⲚⲞⲨ ⲞⲨⲞϨ ⲀⲚⲒⲞⲨⲒ ⲘⲠⲒⲀⲢⲬⲎⲦⲢⲒⲔⲖⲒⲚⲞⲤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ϨⲰⲤ ⲆⲈ ⲈⲦⲀϤϪⲈⲘϮⲠⲒ ⲘⲠⲒⲘⲰⲞⲨ ⲚϪⲈⲠⲒⲀⲢⲬⲎⲦⲢⲒⲔⲖⲒⲚⲞⲤ ⲈⲀϤⲈⲢ ⲎⲢⲠ ⲞⲨⲞϨ ⲚⲀϤⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ ⲚⲒⲆⲒⲀⲔⲰⲚ ⲆⲈ ⲚⲀⲨⲈⲘⲒ ⲚⲎ ⲈⲦⲀⲨⲘⲀϨ ⲠⲒⲘⲰⲞⲨ ⲀⲠⲒⲀⲢⲬⲎⲦⲢⲒⲔⲖⲒⲚⲞⲤ ⲆⲈ ⲘⲞⲨϮ ⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈϢⲀⲨⲬⲰ ⲘⲠⲒⲎⲢⲠ ⲈⲐⲚⲀⲚⲈϤ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲨϢⲀⲚⲐⲒϦⲒ ϢⲀⲨⲒⲚⲒ ⲘⲠⲈⲦⲤⲂⲞⲔ ⲈⲢⲞϤ ⲚⲐⲞⲔ ⲆⲈ ⲀⲔⲀⲢⲈϨ ⲈⲠⲒⲎⲢⲠ ⲈⲐⲚⲀⲚⲈϤ ϢⲀ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ⲪⲀⲒ ⲠⲈ ⲠⲒϨⲞⲨⲒⲦ ⲘⲘⲎⲒⲚⲒ ⲈⲦⲀϤⲀⲒϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲦⲔⲀⲚⲀ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲚϨ ⲘⲠⲈϤⲰⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀⲨⲚⲀϨϮ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ⲘⲈⲚⲈⲚⲤⲀ ⲪⲀⲒ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲚⲐⲞϤ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲀϤⲞϨⲒ ⲘⲘⲀⲨ ⲚⲞⲨⲘⲎ ϢⲚⲈϨⲞⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ⲞⲨⲞϨ ⲚⲀϤϦⲈⲚⲦ ⲠⲈ ⲚϪⲈⲠϢⲀⲒ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎⲒ ⲈⲒⲖⲎⲘ ");
INSERT INTO copbhc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ⲞⲨⲞϨ ⲀϤϪⲒⲘⲒ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲚⲎ ⲈⲦϮ ⲈϨⲈ ⲈⲂⲞⲖ ⲚⲈⲘ ⲈⲤⲰⲞⲨ ⲚⲈⲘ ϬⲢⲞⲘⲠⲒ ⲚⲈⲘ ⲚⲒϤⲀⲒⲔⲈⲢⲘⲀ ⲈⲨϨⲈⲘⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ⲞⲨⲞϨ ⲀϤⲐⲀⲘⲒⲞ ⲚⲞⲨⲪⲢⲀⲄⲈⲖⲖⲒⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲚⲞϨ ⲀϤϨⲒⲦⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲒⲈⲤⲰⲞⲨ ⲚⲈⲘ ⲚⲒⲈϨⲰⲞⲨ ⲞⲨⲞϨ ⲚⲒⲔⲈⲢⲘⲀ ⲚⲦⲈⲚⲒϤⲀⲒⲔⲈⲢⲘⲀ ⲀϤⲪⲞⲚⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲞⲨⲦⲢⲀⲠⲈⲌⲀ ⲀϤⲪⲞⲚϪⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲚⲎ ⲈⲦϮ ϬⲢⲞⲘⲠⲒ ⲈⲂⲞⲖ ϪⲈ ⲀⲖⲒⲞⲨⲒ ⲚⲚⲀⲒ ⲈⲂⲞⲖ ⲦⲀⲒ ⲘⲠⲈⲢⲈⲢ ⲠⲎⲒ ⲘⲠⲀⲒⲰⲦ ⲚⲞⲨⲎⲒ ⲚϢⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ⲀⲨⲈⲢⲪⲘⲈⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲤⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲬⲞϨ ⲘⲠⲈⲔⲎⲒ ϤⲚⲀⲞⲨⲞⲘⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲞⲨ ⲘⲘⲎⲒⲚⲒ ⲈⲦⲈⲔⲚⲀⲦⲀⲘⲞⲚ ⲈⲢⲞϤ ϪⲈ ⲔⲒⲢⲒ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲂⲈⲖ ⲠⲀⲒⲈⲢⲪⲈⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ϮⲚⲀⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϦⲈⲚⲄⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ⲠⲈϪⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲀⲨⲈⲢ ⲘⲚⲢⲞⲘⲠⲒ ⲈⲨⲔⲰⲦ ⲘⲠⲀⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲚⲐⲞⲔ ⲬⲚⲀⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ϦⲈⲚⲄⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲠⲈ ⲈⲐⲂⲈ ⲠⲒⲈⲢⲪⲈⲒ ⲚⲦⲈⲠⲈϤⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲀⲨⲈⲢⲪⲘⲈⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲪⲀⲒ ⲈⲚⲀϤϪⲰ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲨⲚⲀϨϮ ⲈϮⲄⲢⲀⲪⲎ ⲚⲈⲘ ⲠⲒⲤⲀϪⲒ ⲈⲦⲀϤϪⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ⲈϤⲬⲎ ⲆⲈ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϦⲈⲚⲠϢⲀⲒ ⲚⲦⲈⲠⲒⲠⲀⲤⲬⲀ ⲞⲨⲘⲎϢ ⲀⲨⲚⲀϨϮ ⲈⲠⲈϤⲢⲀⲚ ⲈⲨⲚⲀⲨ ⲈⲚⲒⲘⲎⲒⲚⲒ ⲈⲚⲀϤⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ⲚⲐⲞϤ ⲆⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤⲦⲈⲚϨⲞⲨⲦ ⲘⲘⲞϤ ⲈⲢⲰⲞⲨ ⲀⲚ ⲠⲈ ⲈⲐⲂⲈϪⲈ ⲚⲀϤⲤⲰⲞⲨⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ⲞⲨⲞϨ ⲚⲀϤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲀⲒ ⲈⲢⲘⲈⲐⲢⲈ ⲚⲀϤ ϦⲀ ⲞⲨⲢⲰⲘⲒ ⲚⲐⲞϤ ⲄⲀⲢ ⲚⲀϤⲤⲰⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈⲦϦⲈⲚ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲞⲨⲀⲢⲬⲰⲚ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ⲪⲀⲒ ⲀϤⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲚⲈϪⲰⲢϨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲈⲦⲀⲔⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲚⲢⲈϤϮⲤⲂⲰ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲚϨⲖⲒ ⲈⲈⲢ ⲚⲀⲒⲘⲎⲒⲚⲒ ⲈⲦⲈⲔⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲀⲢⲈϢⲦⲈⲘ ⲪⲚⲞⲨϮ ϢⲰⲠⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲀⲨϢⲦⲈⲘⲘⲈⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲔⲈⲤⲞⲠ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲚⲀⲨ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ⲠⲈϪⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲞⲨⲘⲈⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲔⲈⲤⲞⲠ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲈϤⲈⲢϦⲈⲖⲖⲞ ⲘⲎ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲈⲐⲢⲈϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲐⲚⲈϪⲒ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ⲘⲪⲘⲀϨ ⲤⲞⲠ ⲂⲞⲨⲞϨ ⲚⲦⲞⲨⲘⲀⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲀⲨϢⲦⲈⲘⲘⲈⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲚⲈⲘ ⲞⲨⲠⲚⲈⲨⲘⲀⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲒ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ⲠⲒⲘⲒⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲤⲀⲢⲜ ⲞⲨⲤⲀⲢⲜ ⲠⲈ ⲠⲒⲘⲒⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲠⲚⲈⲨⲘⲀⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ⲘⲠⲈⲢⲈⲢϢⲪⲎⲢⲒ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲀⲔ ϪⲈ ϨⲰϮ ⲚⲦⲞⲨⲘⲈⲤ ⲐⲎⲚⲞⲨ ⲚⲔⲈⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ⲠⲒⲠⲚⲈⲨⲘⲀϤⲚⲒϤⲒ ⲈⲪⲘⲀ ⲈⲦⲈϨⲚⲀϤ ⲞⲨⲞϨ ⲔⲤⲰⲦⲈⲘ ⲈⲦⲈϤⲤⲘⲎ ⲀⲖⲖⲀ ⲔⲈⲘⲒ ⲀⲚ ϪⲈ ⲀϤⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲐⲰⲚ ⲞⲨⲞϨ ⲈϤⲚⲀ ⲈⲐⲰⲚ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨⲘⲒⲤⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲚⲀⲒ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲤⲀϦ ⲘⲠⲒⲤⲖ ⲞⲨⲞϨ ⲚⲀⲒ ⲔⲈⲘⲒ ⲈⲢⲰⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲪⲎ ⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲦⲈⲚⲤⲀϪⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ ⲦⲈⲚⲈⲢⲘⲈⲐⲢⲈ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲦⲈⲚⲘⲈⲦⲘⲈⲐⲢⲈ ⲦⲈⲦⲈⲚϬⲒ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ⲒⲤϪⲈ ⲀⲒϪⲈ ⲚⲀ ⲠⲔⲀϨⲒ ⲚⲰⲦⲈⲚ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲠⲰⲤ ⲀⲒϢⲀⲚϪⲈ ⲚⲀ ⲦⲪⲈ ⲚⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ϢⲈ ⲚⲀϤ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲈⲂⲎⲖ ⲈⲪⲎ ⲈⲦⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈⲦⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲠⲈ ⲪⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲈⲦⲀ ⲘⲰⲨⲤⲎⲤ ϬⲈⲤ ⲠⲒϨⲞϤ ⲚϨⲢⲎⲒ ϨⲒ ⲠϢⲀϤⲈ ⲠⲀⲒⲢⲎϮ ϨⲰϮ ⲠⲈ ⲚⲦⲞⲨϬⲈⲤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ϨⲒⲚⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲦⲈϤϬⲒ ⲘⲠⲒⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ⲠⲀⲒⲢⲎϮ ⲄⲀⲢ ⲀⲪⲚⲞⲨϮ ⲘⲈⲚⲢⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲰⲤⲦⲈ ⲠⲈϤϢⲎⲢⲒ ⲘⲘⲀⲨⲀⲦϤ ⲚⲦⲈϤⲦⲎⲒϤ ϨⲒⲚⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲦⲈϤϢⲦⲈⲘⲦⲀⲔⲞ ⲀⲖⲖⲀ ⲚⲦⲈϤϬⲒ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ⲚⲈⲦⲀ ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲀⲚ ⲞⲨⲰⲢⲠ ⲘⲠⲈϤϢⲎ ⲢⲒ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤϮϨⲀⲠ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ⲀⲚ ⲪⲎ ⲆⲈ ⲈⲦⲈⲚϤⲚⲀϨϮ ⲈⲢⲞϤ ⲀⲚ ϨⲎⲆⲎ ⲀⲨⲞⲨⲰ ⲈⲨϮϨⲀⲠ ⲈⲢⲞϤ ϪⲈ ⲘⲠⲈϤⲚⲀϨϮ ⲈⲪⲢⲀⲚ ⲘⲠⲒⲘⲞⲚⲞⲄⲈⲚⲎⲤ ⲚϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ⲪⲀⲒ ⲠⲈ ⲠⲒϨⲀⲠ ϪⲈ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲀϤⲒ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲚⲒⲢⲰⲘⲒ ⲀⲨⲘⲈⲚⲢⲈ ⲠⲒⲬⲀⲔⲒ ⲘⲀⲖⲖⲞⲚ ⲈϨⲞⲦⲈ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲚⲞⲨϨⲂⲎⲞⲨⲒ ⲄⲀⲢ ⲚⲀⲨϨⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲒⲢⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ϤⲘⲞⲤϮ ⲘⲠⲒⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲘⲠⲀϤⲒ ϨⲀ ⲠⲒⲞⲨⲰⲒⲚⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲤⲞϨⲒ ⲚⲚⲈϤϨⲂⲎⲞⲨⲒ ϪⲈ ⲤⲈϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ⲪⲎ ⲆⲈ ⲈⲦⲒⲢⲒ ⲚϮⲘⲈⲐⲘⲎⲒ ϢⲀϤⲒ ϨⲀ ⲠⲒⲞⲨⲰⲒⲚⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϪⲈⲚⲈϤϨⲂⲎⲞⲨⲒ ϪⲈ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ϦⲈⲚⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲠⲔⲀϨⲒ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲞⲨⲞϨ ⲚⲀϤⲬⲎ ⲘⲘⲀⲨ ⲚⲈⲘⲰⲞⲨ ⲠⲈ ⲈϤϮⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ⲚⲀⲢⲈ ⲠⲔⲈⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ϮⲰⲘⲤ ⲠⲈ ϦⲈⲚⲈⲚⲰⲚ ϦⲀⲦⲈⲚ ⲤⲀⲖⲒⲘ ϪⲈ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲘⲘⲰⲞⲨ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨϬⲒⲰⲘⲤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ⲚⲈ ⲘⲠⲀⲦⲞⲨϨⲒⲞⲨⲒ ⲆⲈ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲈⲠϢⲦⲈⲔⲞ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ⲀⲤϢⲰⲠⲒ ⲞⲨⲚ ⲚϪⲈⲞⲨⲌⲎⲦⲎⲤⲒⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲐⲂⲈ ⲞⲨⲦⲞⲨⲂⲞ ");
INSERT INTO copbhc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲪⲎ ⲈⲦⲬⲎ ⲚⲈⲘⲀⲔ ϨⲒⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎⲤ ⲪⲎ ⲚⲐⲞⲔ ⲈⲦⲈⲔⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞϤ ϨⲎⲠⲠⲈ ⲒⲤ ⲪⲀⲒ ϤϮⲰⲘⲤ ⲞⲨⲞϨ ⲤⲈⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲞⲨⲢⲰⲘⲒ ϬⲒ ϨⲖⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲨϢⲦⲈⲘⲦⲎ ⲒⲤ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲈⲢⲘⲈⲐⲢⲈ ⲚⲎⲒ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲚⲞⲔ ⲀⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ϪⲈ ⲈⲦⲀⲨⲦⲀⲞⲨⲞⲒ ϦⲀϪⲰϤ ⲘⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ⲪⲎ ⲈⲦⲈ ϮϢⲈⲖⲈⲦ ⲚⲦⲞⲦϤ ⲚⲐⲞϤ ⲠⲈ ⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲠϢⲪⲎⲢ ⲆⲈ ⲘⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲠⲈⲦⲞϨⲒ ⲈⲢⲀⲦϤ ⲠⲈ ⲞⲨⲞϨ ⲈϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ϦⲈⲚⲞⲨⲢⲀϢⲒ ϤⲢⲀϢⲒ ⲈⲐⲂⲈ ⲦⲤⲘⲎ ⲚⲦⲈⲠⲒⲠⲀⲦϢⲈⲖⲈⲦ ⲪⲀⲒ ⲞⲨⲚ ⲠⲈ ⲠⲀⲢⲀϢⲒ ⲀⲚⲞⲔ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ϨⲰϮ ⲞⲨⲚ ⲚⲦⲈⲪⲎ ⲀⲒⲀⲒ ⲀⲚⲞⲔ ⲆⲈ ⲚⲦⲀⲐⲈⲂⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲈⲠϢⲰⲒ ϤⲤⲀⲠϢⲰⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲠⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲠⲈ ⲞⲨⲞϨ ϢⲀϤⲤⲀϪⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ϤⲤⲀⲠϢⲰⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ⲪⲎ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲞⲐⲘⲈϤ ⲪⲀⲒ ⲈⲦⲈϤⲈⲢⲘⲈⲐⲢⲈ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲦⲈϤⲘⲈⲦⲘⲈⲐⲢⲈ ⲘⲘⲞⲚ ϨⲖⲒ ϬⲒ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ⲪⲎ ⲈⲐⲚⲀϬⲒ ⲚⲦⲈϤⲘⲈⲦⲘⲈⲐⲢⲈ ⲪⲀⲒ ⲀϤⲈⲢⲤⲪⲢⲀⲄⲒⲌⲒⲚ ϪⲈ ⲪⲚⲞⲨϮ ⲞⲨⲐⲘⲎⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ⲪⲎ ⲄⲀⲢ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲞⲨⲞⲢⲠϤ ⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲈϤⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚⲀⲢⲈ ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲀⲚ ϮⲘⲠⲒⲠⲚⲈⲨⲘⲀϦⲈⲚⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ⲪⲒⲰⲦ ⲘⲈⲒ ⲘⲠϢⲎⲢⲒ ⲞⲨⲞϨ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀϤⲦⲎⲒⲦⲞⲨ ⲈϦⲢⲎⲒ ⲈⲚⲈϤϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲠⲒϢⲎⲢⲒ ⲞⲨⲞⲚⲦⲈϤ ⲰⲚϦ ⲚⲈⲚⲈϨ ⲘⲘⲀⲨ ⲪⲎ ⲆⲈ ⲈⲦⲞⲒ ⲚⲀⲦⲐⲰⲦ ⲚϨⲎⲦ ⲈⲠⲒϢⲎⲢⲒ ⲚⲚⲈϤⲚⲀⲨ ⲈⲠⲰⲚϦ ⲀⲖⲖⲀ ⲠϪⲰⲚⲦ ⲘⲪⲚⲞⲨϮ ⲈϤⲈϢⲰⲠⲒ ϨⲒϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲈⲘⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲀⲒⲎⲤⲞⲨⲤ ⲐⲀⲘⲒⲈ ⲞⲨⲘⲎϢ ⲘⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ⲞⲨⲞϨ ϤϮⲰⲘⲤ ⲈϨⲞⲦⲈ ⲒⲰⲀⲚⲚⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ⲔⲈⲦⲞⲒ ⲒⲎⲤⲞⲨⲤ ⲚⲐⲞϤ ⲀⲚ ⲈⲚⲀϤϮⲰⲘⲤ ⲀⲖⲖⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ⲀϤⲬⲰ ⲚϮⲒⲞⲨⲆⲈⲀ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲞⲚ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ⲚⲈ ϨⲰϮ ⲆⲈ ⲈⲢⲞϤ ⲠⲈ ⲈⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲦⲤⲀⲘⲀⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ⲀϤⲒ ⲞⲨⲚ ⲈⲞⲨⲂⲀⲔⲒ ⲚⲦⲈⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲤⲨⲬⲀⲢ ⲈⲤϦⲈⲚⲦ ⲈⲠⲒⲒⲞϨⲒ ⲈⲦⲀ ⲒⲀⲔⲰⲂ ⲦⲎⲒϤ ⲚⲒⲰⲤⲎⲪ ⲠⲈϤϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ⲚⲀⲤⲬⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚϪⲈⲞⲨⲘⲞⲨⲘⲒ ⲘⲘⲰⲞⲨ ⲚⲦⲈⲒⲀⲔⲰⲂ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲈⲦⲀϤϦⲒⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲒⲦ ⲘⲘⲞϢⲒ ⲀϤϨⲈⲘⲤⲒ ⲠⲀⲒⲢⲎϮ ϨⲒϪⲈⲚ ϮⲘⲞⲨⲘⲒ ⲚⲈⲪⲚⲀⲨ ⲚⲀϪⲠ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ⲀⲤⲒ ⲞⲨⲚ ⲚϪⲈⲞⲨⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲘⲀϨ ⲘⲰⲞⲨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲞⲒ ⲚⲎⲒ ⲚⲦⲀⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲈⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϮⲂⲀⲔⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠ ⲚϨⲀⲚϦⲢⲎⲞⲨⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ⲠⲈϪⲈ ϮⲤϨⲒⲘⲒ ⲚⲀϤ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ϪⲈ ⲠⲰⲤ ⲚⲐⲞⲔ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲔⲈⲢⲈⲦⲒⲚ ⲚⲦⲞⲦ ⲈⲤⲰ ⲀⲚⲞⲔ ⲞⲨⲤϨⲒⲘⲒ ⲚⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲞⲨ ⲄⲀⲢ ⲘⲠⲀⲢⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲞⲨϪⲦ ⲚⲈⲘ ⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲈⲚⲀⲢⲈⲈⲘⲒ ⲈϮⲆⲰⲢⲈⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ϪⲈ ⲚⲒⲘ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ⲚⲈϪⲈ ⲘⲞⲒ ⲚⲎⲒ ⲚⲦⲀⲤⲰ ⲚⲐⲞ ⲚⲀⲢⲈⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲦⲈϤϮ ⲚⲈⲚⲞⲨⲘⲰⲞⲨ ⲈϤⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ⲠⲈϪⲈ ϮⲤϨⲒⲘⲒ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲀⲚⲦⲖⲎⲘⲀ ⲚⲦⲞⲦⲔ ⲞⲨⲞϨ ϮϢⲰϮ ϢⲎⲔ ⲈϤⲈⲚⲦⲞⲦⲔ ⲞⲨⲚ ⲈⲂⲞⲖ ⲐⲰⲚ ⲚϪⲈⲠⲒⲘⲰⲞⲨ ⲈⲦⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ⲘⲎ ⲚⲐⲞⲔ ⲞⲨⲚⲒϢϮ ⲚⲐⲞⲔ ⲈⲠⲈⲚⲒⲰⲦ ⲒⲀⲔⲰⲂ ⲪⲎ ⲈⲦⲀϤϮ ⲚⲀⲚ ⲚⲦⲀⲒϢⲰϮ ⲞⲨⲞϨ ⲚⲐⲞϤ ϨⲰϤ ⲀϤⲤⲰ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲚⲈⲘ ⲚⲈϤϢⲎⲢⲒ ⲚⲈⲘ ⲚⲈϤϢⲀⲚϢ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲞⲨ ⲪⲎ ⲀⲚⲞⲔ ⲈϮⲚⲀⲦⲎⲒϤ ⲚⲀϤ ⲚⲚⲈϤⲒⲂⲒ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ⲀⲖⲖⲀ ⲠⲒⲘⲰⲞⲨ ⲈϮⲚⲀⲦⲎⲒϤ ⲚⲀϤ ⲈϤⲈϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲚⲞⲨⲘⲞⲨⲘⲒ ⲘⲘⲰⲞⲨ ⲈϤⲈϬⲒⲪⲈⲒ ⲈⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ⲠⲈϪⲈ ϮⲤϨⲒⲘⲒ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲘⲞⲒ ⲚⲎⲒ ⲘⲠⲀⲒⲘⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲀϢⲦⲈⲘⲒⲂⲒ ϪⲈ ⲞⲨⲆⲈ ⲚⲦⲀϢⲦⲈⲘⲒ ⲈⲘⲚⲀⲒ ⲈⲘⲀϨ ⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲈⲘⲞⲨϮ ⲈⲠⲈϨⲀⲒ ⲞⲨⲞϨ ⲀⲘⲎ ⲈⲘⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ⲀⲤⲈⲢⲞⲨⲰ ⲚϪⲈϮⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲠⲈϪⲀⲤ ϪⲈ ⲘⲘⲞⲚϮ ϨⲀⲒ ⲘⲘⲀⲨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲔⲀⲖⲰⲤ ⲀⲢⲈϪⲞⲤ ϪⲈ ⲘⲘⲞⲚϮ ϨⲀⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ⲈⲄⲀⲢ ⲚϨⲀⲒ ⲀⲢⲈϬⲒⲦⲞⲨ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲈⲘⲈ ϮⲚⲞⲨ ⲠⲈϨⲀⲒ ⲀⲚ ⲠⲈ ⲪⲀⲒ ⲞⲨⲘⲎⲒ ⲠⲈ ⲈⲦⲀⲢⲈϪⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ⲠⲈϪⲈ ϮⲤϨⲒⲘⲒ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ϮⲚⲀⲨ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ⲚⲈⲚⲒⲞϮ ⲀⲨⲞⲨⲰϢⲦ ϨⲒϪⲈⲚ ⲠⲀⲒⲦⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲈ ⲠⲒⲘⲀⲚⲞⲨⲰϢⲦ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲠⲒⲘⲀ ⲈⲦⲈⲤϢⲈ ⲚⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ϮⲤϨⲒⲘⲒ ⲦⲈⲚϨⲞⲨⲦ ϪⲈ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ϨⲞⲦⲈ ⲞⲨⲆⲈ ϨⲒϪⲈⲚ ⲠⲀⲒⲦⲰⲞⲨ ⲞⲨⲆⲈ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲨⲚⲀⲞⲨⲰϢⲦ ⲘⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞⲨⲰϢⲦ ⲘⲪⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲀⲚⲞⲚ ⲆⲈ ⲦⲈⲚⲞⲨⲰϢⲦ ⲘⲪⲎ ⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲠⲒⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ⲀⲖⲖⲀ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ⲈⲦⲈ ϮⲚⲞⲨ ⲦⲈ ϨⲞⲦⲈ ⲚⲒⲢⲈϤⲞⲨⲰϢⲦ ⲚⲦⲀⲪⲘⲎⲒ ⲈⲨⲚⲀⲞⲨⲰϢⲦ ⲘⲪⲒⲰⲦ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲞⲨⲘⲈⲐⲘⲎ ⲒⲔⲈ ⲄⲀⲢ ⲪⲒⲰⲦ ⲀϤⲔⲰϮ ⲚⲤⲀⲚⲀⲒ ⲞⲨⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ⲚⲎ ⲈⲐⲞⲨⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ⲞⲨⲠⲚⲈⲨⲘⲀⲠⲈ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲀⲞⲨⲰϢⲦ ⲘⲘⲞϤ ⲤⲈⲘⲠϢⲀ ⲚⲦⲞⲨⲞⲨⲰϢⲦ ⲘⲘⲞϤ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲞⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ⲠⲈϪⲈ ϮⲤϨⲒⲘⲒ ⲚⲀϤ ϪⲈ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲘⲈⲤⲒⲀⲤ ⲚⲎⲞⲨ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲚⲐⲞϤ ⲈⲐⲚⲀⲦⲀⲘⲞⲚ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲪⲎ ⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ⲞⲨⲞϨ ϦⲈⲚⲪⲀⲒ ⲀⲨⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ϪⲈ ϤⲤⲀϪⲒ ⲚⲈⲘ ⲞⲨⲤϨⲒⲘⲒ ⲘⲠⲈ ϨⲖⲒ ⲘⲈⲚⲦⲞⲒ ϪⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲔⲔⲰϮ ⲚⲤⲀⲞⲨ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲔⲤⲀϪⲒ ⲚⲈⲘⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ⲀⲤⲬⲰ ⲞⲨⲚ ⲚⲦⲈⲤϨⲨⲆⲢⲒⲀ ⲚϪⲈϮⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲀⲤϢⲈ ⲚⲀⲤ ⲈϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲠⲈϪⲀⲤ ⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲀⲚⲀⲨ ⲈⲠⲀⲒⲢⲰⲘⲒ ⲈⲀϤϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲎⲒ ⲈⲦⲀⲒⲀⲒⲦⲞⲨ ⲘⲎⲦⲒ ⲪⲀⲒ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ⲚⲀⲨⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ϨⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲦⲰⲞⲨ ⲚⲈⲘⲀϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲢⲀⲂⲂⲒ ⲦⲰⲚⲔ ⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲞⲚϮ ⲞⲨϦⲢⲈ ⲘⲘⲀⲨ ⲈⲞⲨⲞⲘⲤ ⲐⲎ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲘⲎⲦⲒ ⲀⲚ ⲀⲞⲨⲀⲒ ⲒⲚⲒ ⲚⲀϤ ⲈⲐⲢⲈϤⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲦⲀϦⲢⲈ ⲀⲚⲞⲔ ⲦⲈ ϨⲒⲚⲀ ⲚⲦⲀⲈⲢ ⲪⲞⲨⲰϢ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲞⲨⲞϨ ⲚⲦⲀϪⲰⲔ ⲘⲠⲈϤϨⲰⲂ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ⲘⲎ ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲦⲒ ⲔⲈⲆ ⲚⲀⲂⲞⲦ ϤⲚⲎⲞⲨ ⲚϪⲈⲠⲒⲰⲤϦ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϤⲀⲒ ⲚⲚⲈⲦⲈⲚⲂⲀⲖ ⲈⲠϢⲰⲒ ⲞⲨⲞϨ ⲀⲚⲀⲨ ⲈⲚⲒⲬⲰⲢⲀ ϪⲈ ⲀⲨⲞⲨⲂⲀϢ ⲈⲠⲞⲤϦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ϨⲎⲆⲎ ⲪⲎ ⲈⲐⲚⲀⲰⲤϦ ϤⲚⲀϬⲒ ⲘⲠⲈϤⲂⲈⲬ ⲈⲞⲨⲞϨ ϤⲚⲀⲐⲰⲞⲨϮ ⲚⲞⲨⲞⲨⲦⲀϨ ⲈⲨⲰⲚϦ ⲚⲈⲚⲈϨ ϨⲒⲚⲀ ⲪⲎ ⲈⲦⲤⲒϮ ⲚⲦⲈϤⲢⲀϢⲒ ⲈⲨⲤⲞⲠ ⲚⲈⲘ ⲪⲎ ⲈⲦⲰⲤϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ϦⲈⲚ ⲪⲀⲒ ⲄⲀⲢ ⲞⲨⲦⲀⲪⲘⲎⲒ ⲠⲈ ⲠⲒⲤⲀϪⲒ ϪⲈ ⲔⲈⲞⲨⲀⲒ ⲠⲈⲦⲤⲒϮ ⲞⲨⲞϨ ⲔⲈⲞⲨⲀⲒ ⲠⲈⲦⲰⲤϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ⲀⲚⲞⲔ ⲀⲒⲞⲨⲈⲢⲠ ⲐⲎⲚⲞⲨ ⲈⲰⲤϦ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲈⲦⲈⲚϦⲒⲤⲒ ⲈⲢⲞϤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲠⲈⲦⲀⲨϦⲒⲤⲒ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϢⲈ ⲚⲰⲦⲈⲚ ⲈϦⲞⲨⲚ ⲈⲠⲞⲨϦⲒⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ⲈⲂⲞⲖ ⲆⲈ ϦⲈⲚϮⲂⲀⲔⲒ ⲈⲦⲈⲘⲘⲀⲨ Ⲁ- ⲞⲨⲘⲎϢ ⲚⲀϨϮ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎ ⲤⲈⲐⲂⲈ ⲠⲤⲀϪⲒ ⲚϮⲤϨⲒⲘⲒ ⲈⲤⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲀϤϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲎ ⲈⲦⲀⲒⲀⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎ ⲤⲀⲨϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲞϨⲒ ϦⲀⲦⲞⲦⲞⲨ ⲞⲨⲞϨ ⲀϤⲞϨⲒ ⲘⲘⲀⲨ ⲚⲈϨⲞⲞⲨ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲘⲎϢ ⲚϨⲞⲨⲞ ⲀⲨⲚⲀϨϮ ⲈⲐⲂⲈ ⲠⲈϤⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲠⲈ ⲚϮⲤϨⲒⲘⲒ ϪⲈ ⲈⲐⲂⲈ ⲦⲈⲚϪⲒⲚⲤⲀϪⲒ ⲀⲚ ϪⲈ ⲦⲈⲚⲚⲀϨϮ ⲀⲚⲞⲚ ⲄⲀⲢ ϨⲰⲚ ⲀⲚⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲦⲈⲚⲈⲘⲒ ⲦⲀⲪⲘⲎⲒ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒⲤⲰⲦⲎⲢ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲂⲀϤⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ⲚⲐⲞϤ ⲄⲀⲢ ⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲈϤⲦⲀⲒⲎⲞⲨⲦ ϦⲈⲚⲐⲎ ⲈⲦⲈⲐⲰϤ ⲘⲂⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲒ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲒⲄⲀⲖⲒⲖⲈⲞⲤ ⲈⲦⲀⲨⲚⲀⲨ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϦⲈⲚⲠϢⲀⲒ ⲚⲈⲀⲨⲒ ⲄⲀⲢ ϨⲰⲞⲨ ⲈⲠϢⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ⲀϤⲒ ⲞⲚ ⲈⲦⲔⲀⲚⲀ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲠⲒⲘⲀ ⲈⲦⲀϤⲐⲢⲈ ⲠⲒⲘⲰⲞⲨ ⲈⲢⲎⲢⲠ ⲘⲘⲞϤ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲂⲀⲤⲒⲖⲒⲔⲞⲤ ⲠⲈ ⲈⲞⲨⲞⲚ ⲚⲦⲀϤ ⲚⲞⲨϢⲎ ⲢⲒ ⲘⲘⲀⲨ ⲈϤϢⲰⲚⲒ ϦⲈⲚⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ⲪⲀⲒ ⲀϤⲤⲰⲦⲈⲘ ϪⲈ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲀϤϢⲈ ⲚⲀϤ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲚⲀϤϮϨⲞ ⲈⲢⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ⲈϦⲢⲎⲒ ⲚⲦⲈϤⲦⲞⲨϪⲈ ⲠⲈϤϢⲎⲢⲒ ⲚⲀϤⲚⲀⲘⲞⲨ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲚⲀϤ ϪⲈ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲚⲀⲨ ⲈϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ⲠⲈϪⲈ ⲠⲒⲂⲀⲤⲒⲖⲒⲔⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲘⲞⲨ ⲈϦⲢⲎⲒ ⲘⲠⲀⲦⲈϤⲘⲞⲨ ⲚϪⲈⲠⲀⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ϤⲞⲚϦ ⲚϪⲈⲠⲈⲔϢⲎⲢⲒ ⲞⲨⲞϨ ⲀϤⲚⲀϨϮ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲈⲠⲒⲤⲀϪⲒ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞϤ ⲚⲀϤ ⲞⲨⲞϨ ⲀϤⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ϨⲎⲆⲎ ⲈϤⲚⲎⲞⲨ ⲈϦⲢⲎⲒ ⲒⲤ ⲚⲈϤⲈⲂⲒⲀⲒⲔ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲞⲚϦ ⲚϪⲈⲠⲈⲔϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ⲚⲀϤϢⲒⲚⲒ ⲆⲈ ⲚⲦⲞⲦⲞⲨ ⲚⲤⲀϮⲞⲨⲚⲞⲨ ⲐⲎ ⲈⲦⲀϤⲀⲤⲒⲀⲒ ⲚϦⲎⲦⲤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ϦⲈⲚⲀϪⲠ ⲌⲚⲤⲀϤ ⲀϤⲬⲀϤ ⲚϪⲈⲠⲒϦⲘⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ⲀϤⲈⲘⲒ ⲞⲨⲚ ⲚϪⲈⲠⲈϤⲒⲰⲦ ϪⲈ ⲚⲈϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲦⲈ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϪⲞⲤ ⲚⲀϤ ϪⲈ ϤⲞⲚϦ ⲚϪⲈⲠⲈⲔϢⲎⲢⲒ ⲞⲨⲞϨ ⲀϤⲚⲀϨϮ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ⲪⲀⲒ ⲠⲈ ⲠⲒⲘⲎⲒⲚⲒ ⲘⲘⲀϨ ⲂⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲈϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲚⲈⲠϢⲀⲒ ⲚⲦⲈⲚⲒⲞⲨⲆⲀⲒ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϨⲒϪⲈⲚ ϮⲠⲢⲞⲂⲀⲦⲒⲔⲎ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ⲐⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ϪⲈ ⲂⲎⲐⲤⲀⲒⲆⲀ ⲈⲞⲨⲞⲚ ⲚⲦⲀⲤ ⲘⲘⲀⲨ ⲚⲈⲚⲤⲦⲞⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ⲞⲨⲞϨ ⲚⲀⲨⲢⲞϪⲠ ⲠⲈ ϦⲈⲚⲚⲀⲒ ⲚϪⲈⲚⲒⲘⲎ ϢⲚⲦⲈ ⲚⲎ ⲈⲦϢⲰⲚⲒ ϨⲀⲚⲂⲈⲖⲖⲈⲨ ⲚⲈⲘ ϨⲀⲚϬⲀⲖⲈⲨ ⲚⲈⲘ ϨⲀⲚⲞⲨⲞⲚ ⲈⲨϢⲞⲨⲰⲞⲨ ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ⲈⲨϪⲞⲨϢⲦ ⲈⲂⲞⲖ ⲈⲨⲔⲒⲘ ⲘⲠⲒⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲈϤⲈⲒ ⲈⲠⲈⲤⲎⲦ ⲚⲚⲀⲨ ⲚⲒⲂⲈⲚ ϦⲈⲚϮⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ⲞⲨⲞϨ ⲈϤⲔⲒⲘ ⲘⲠⲒⲘⲰⲞⲨ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϤⲈⲒ ⲈⲠⲈⲤⲎ ⲦⲚϢⲞⲢⲠ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲔⲒⲘ ⲘⲠⲒⲘⲰⲞⲨ ⲈϤⲈⲈⲢⲪⲀϦⲢⲒ ⲈϢⲰⲚⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲘⲘⲀⲨ ⲠⲈ ⲈⲀϤⲈⲢ ⲖⲎ ⲚⲢⲞⲘⲠⲒ ϦⲈⲚⲠⲈϤϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲪⲀⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲚⲔⲞⲦ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ϪⲈ ⲀϤⲈⲢ ⲞⲨⲘⲎϢ ⲚⲬⲢⲞⲚⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲬⲞⲨⲰϢ ⲈⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲪⲎ ⲈⲦϢⲰⲚⲒ ⲠⲈϪⲀϤ ⲠⲀϬⲞⲒⲤ ⲘⲘⲞⲚϮ ⲢⲰⲘⲒ ⲘⲘⲀⲨ ϨⲒⲚⲀ ⲀϤϢⲀⲚⲐⲞϨ ⲚϪⲈⲠⲒⲘⲰⲞⲨ ⲚⲦⲈϤϨⲒⲦ ⲈϦⲢⲎⲒ ⲈϮⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ϨⲰⲤ ⲆⲈ ⲈⲒⲚⲎⲞⲨ ⲀⲚⲞⲔ ϢⲀⲢⲈ ⲔⲈⲞⲨⲀⲒ ⲈⲢϢⲞⲢⲠ ⲈⲢⲞⲒ ⲈϦⲢⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲦⲰⲚⲔ ⲀⲖⲒⲞⲨⲒ ⲘⲠⲈⲔϬ ⲖⲞϪ ⲞⲨⲞϨ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲞⲨϪⲀⲒ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲀϤⲰⲖⲒ ⲘⲠⲈϤϬⲖⲞϪ ⲀϤⲘⲞϢⲒ ⲚⲈⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲪⲎ ⲈⲦⲀϤⲈⲢⲪⲀϦⲢⲒ ⲈⲢⲞϤ ϪⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲠⲈ ⲞⲨⲞϨ ⲤϢⲈ ⲚⲀⲔ ⲀⲚ ⲈⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲐⲢⲒⲞⲨϪⲀⲒ ⲚⲐⲞϤ ⲠⲈⲦⲀϤϪⲞⲤ ⲚⲎⲒ ϪⲈ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲘⲀϢⲈ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ⲀⲨϢⲈⲚϤ ⲆⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲀϤϪⲞⲤ ⲚⲀⲔ ϪⲈ ⲰⲖⲒ ⲘⲠⲈⲔϬⲖⲞϪ ⲞⲨⲞϨ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ⲪⲎ ⲆⲈ ⲈⲦⲀϤⲞⲨϪⲀⲒ ⲚⲀϤⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲈⲀϤⲒ ⲈⲂⲞⲖ ⲈⲞⲨⲞⲚ ⲞⲨⲘⲎ ϢⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲀϤϪⲈⲘϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲔⲞⲨϪⲀⲒ ⲘⲠⲈⲢⲈⲢⲚⲞⲂⲒ ϪⲈ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲈⲦϨⲰⲞⲨ ⲚϨⲞⲨⲞ ϢⲰⲠⲒ ⲘⲘⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ⲀϤϢⲈ ⲚⲀϤ ⲞⲨⲚ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲀϤⲐⲢⲒⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲚ ⲚⲀⲨϬⲞϪⲒ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲚⲀϤⲒⲢⲒ ⲚⲚⲀⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ⲠⲀⲒⲰⲦ ⲈⲢϨⲰⲂ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮⲈⲢϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲚ ⲚϨⲞⲨⲞ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϦⲞⲐⲂⲈϤ ϪⲈ ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲀϤⲂⲰⲖ ⲘⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲖⲖⲀ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲚⲞⲨϮ ⲠⲈ ⲠⲀⲒⲰⲦ ⲈϤⲒⲢⲒ ⲘⲘⲞϤ ⲚϨⲒⲤⲞⲤ ⲚⲈⲘ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲠϢⲎⲢⲒ ⲈⲢ ϨⲖⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲀϤϢⲦⲈⲘⲚⲀⲨ ⲈⲪⲒⲰⲦ ⲈϤⲒⲢⲒ ⲘⲘⲞϤ ⲚⲎ ⲄⲀⲢ ⲈⲦⲈ ⲪⲒⲰⲦ ⲢⲀ ⲘⲘⲰⲞⲨ ⲚⲀⲒ ⲞⲚ ⲈⲦⲈ ⲠⲒⲔⲈϢⲎⲢⲒ ⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ⲪⲒⲰⲦ ⲄⲀⲢ ϤⲘⲈⲒ ⲘⲠϢⲎⲢⲒ ⲞⲨⲞϨ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ϤⲚⲀⲦⲀⲘⲞϤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ϨⲀⲚϨⲂⲎⲞⲨⲒ ⲈⲨⲞⲒ ⲚⲚⲒϢϮ ⲈⲚⲀⲒ ϤⲚⲀⲦⲀⲘⲞϤ ⲈⲢⲰⲞⲨ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲈⲢϢⲪⲎ ⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ⲪⲒⲰⲦ ⲦⲞⲨⲚⲞⲤ ⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ϤⲦⲀⲚϦⲞ ⲘⲘⲰⲞⲨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲔⲈϢⲎⲢⲒ ⲚⲎ ⲈⲦⲈϤⲞⲨⲀϢⲞⲨ ϤⲦⲀⲚϦⲞ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ⲞⲨ ⲄⲀⲢ ⲪⲒⲰⲦ ϤⲚⲀϮϨⲀⲠ ⲈϨⲖⲒ ⲀⲚ ⲀⲖⲖⲀ ⲠⲒϨⲀⲠ ⲦⲎⲢϤ ⲀϤⲦⲎⲒϤ ⲘⲠⲒϢⲎⲢⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲢⲦⲒⲘⲀⲚ ⲘⲠⲒϢⲎ ⲢⲒ ⲘⲪⲢⲎϮ ⲈⲦⲞⲨⲈⲢⲦⲒⲘⲀⲚ ⲘⲪⲒⲰⲦ ⲪⲎ ⲈⲦⲈⲚϤⲈⲢⲦⲒⲘⲀⲚ ⲀⲚ ⲘⲠⲒϢⲎⲢⲒ ϤⲈⲢⲦⲒⲘⲀⲚ ⲀⲚ ⲞⲚ ⲘⲠⲒⲔⲈⲒⲰⲦ ⲈⲦⲀϤⲦⲀⲞⲨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲚⲀϨϮ ⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲞⲨⲞⲚⲦⲈϤ ⲰⲚϦ ⲚⲈⲚⲈϨ ⲘⲘⲀⲨ ⲞⲨⲞϨ ϤⲚⲀⲒ ⲀⲚ ⲈⲠϨⲀⲠ ⲀⲖⲖⲀ ϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲪⲘⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ⲈⲦⲈ ϮⲚⲞⲨ ⲦⲈ ϨⲞⲦⲈ ⲈⲢⲈ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲤⲰⲦⲈⲘ ⲈⲦⲤⲘⲎ ⲘⲠϢⲎ ⲢⲒ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲀⲤⲰⲦⲈⲘ ⲈⲨⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲰⲚϦ ϢⲞⲠ ϦⲈⲚⲪⲒⲰⲦ ⲠⲀⲒⲢⲎϮ ⲀϤⲦⲎⲒⲤ ⲘⲠⲒⲔⲈϢⲎ ⲢⲒ ⲈⲐⲢⲈ ⲞⲨⲰⲚϦ ϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ⲞⲨⲞϨ ⲀϤϮⲈⲢϢⲒϢⲒ ⲚⲀϤ ⲈⲐⲢⲈϤⲒⲢⲒ ⲚⲞⲨϨⲀⲠ ϪⲈ ⲞⲨϢⲎⲢⲒ ⲚⲢⲰⲘⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ⲘⲠⲈⲢⲈⲢϢⲪⲎⲢⲒ ϦⲈⲚⲪⲀⲒ ϪⲈ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ϨⲞⲦⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲬⲎ ϦⲈⲚⲚⲒⲘϨⲀⲨ ⲈⲨⲈⲤⲰⲦⲈⲘ ⲈⲦⲈϤⲤⲘⲎ ");
INSERT INTO copbhc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ⲞⲨⲞϨ ⲈⲨⲈⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲒⲢⲒ ⲚⲚⲒⲠⲈⲐⲚⲀⲚⲈⲨ ⲈⲨⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲰⲚϦ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀⲨⲒⲢⲒ ⲚⲚⲒⲠⲈⲦϨⲰⲞⲨ ⲈⲨⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲔⲢⲒⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲀⲈⲢ ϨⲖⲒ ⲀⲚⲞⲔ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲪⲢⲎϮ ⲈϮⲤⲰⲦⲈⲘ ϮϮϨⲀⲠ ⲞⲨⲞϨ ⲠⲀϨⲀⲠ ⲀⲚⲞⲔ ⲞⲨⲘⲎⲒ ⲠⲈ ϪⲈ ⲚϮⲔⲰϮ ⲀⲚ ⲚⲤⲀⲠⲀⲞⲨⲰϢ ⲀⲖⲖⲀ ⲪⲞⲨⲰϢ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ⲈϢⲰⲠ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ ⲦⲀⲘⲈⲦⲘⲈⲐⲢⲈ ⲞⲨⲘⲎⲒ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ⲔⲈⲞⲨⲀⲒ ⲠⲈⲦⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ ⲞⲨⲞϨ ϮⲈⲘⲒ ϪⲈ ⲦⲈϤⲘⲈⲦⲘⲈⲐⲢⲈ ⲞⲨⲘⲎⲒ ⲦⲈ ⲐⲎ ⲈⲦⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲘⲘⲞⲤ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ⲚⲐⲰⲦⲈⲚ ⲀⲦⲈⲦⲈⲚⲞⲨⲰⲢⲠ ϨⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ⲀⲚⲞⲔ ⲆⲈ ⲚⲀⲒϬⲒ ⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲀⲚ ⲀⲖⲖⲀ ⲚⲀⲒ ϮϪⲰ ⲘⲘⲰⲞⲨ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲚⲐⲞϤ ⲠⲈ ⲠⲒϦⲎⲂⲤ ⲈⲐⲘⲞϨ ⲞⲨⲞϨ ⲈⲦⲈⲢⲞⲨⲰⲒⲚⲒ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲈⲐⲈⲖⲎⲖ ⲘⲘⲰⲦⲈⲚ ⲠⲢⲞⲤ ⲞⲨⲞⲨⲚⲞⲨ ϦⲈⲚⲠⲈϤⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ⲀⲚⲞⲔ ⲆⲈ ⲞⲨⲞⲚϮ ⲘⲈⲦⲘⲈⲐⲢⲈ ⲈⲚⲀⲀⲤ ⲈⲐⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲒϨⲂⲎⲞⲨⲒ ⲄⲀⲢ ⲈⲦⲀϤⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ϨⲒⲚⲀ ⲚⲦⲀϪⲞⲔⲞⲨ ⲈⲂⲞⲖ ⲚⲐⲰⲞⲨ ⲚⲒϨⲂⲎⲞⲨⲒ ⲈϮⲢⲀ ⲘⲘⲰⲞⲨ ⲤⲈⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲒ ϪⲈ ⲪⲒⲰⲦ ⲠⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ⲞⲨⲞϨ ⲪⲒⲰⲦ ⲠⲈⲦⲀϤⲞⲨⲞⲢⲠⲦ ⲚⲐⲞϤ ⲠⲈⲦⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ ⲞⲨⲆⲈ ⲘⲠⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲤⲘⲎ ⲚⲦⲀϤ ⲈⲚⲈϨ ⲞⲨⲆⲈ ⲘⲠⲈⲦⲈⲚⲚⲀⲨ ⲈⲤⲘⲞⲦ ⲚⲦⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ⲞⲨⲞϨ ⲠⲈϤⲤⲀϪⲒ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲚ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞϤ ⲘⲠⲈⲦⲈⲚⲚⲀϨϮ ⲚⲐⲰⲦⲈⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ϦⲞⲦϦⲈⲦ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ϢⲞⲠ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲈⲦⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲀⲚ ⲈⲒ ϨⲀⲢⲞⲒ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲰⲚϦ ϢⲰⲠⲒ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ⲚϮⲚⲀϬⲒⲰⲞⲨ ⲚⲦⲈⲚ ⲢⲰⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ⲀⲖⲖⲀ ⲀⲒⲈⲘⲒ ⲈⲢⲰⲦⲈⲚ ϪⲈ ϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ⲀⲚⲞⲔ ⲀⲒⲒ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚϬⲒ ⲘⲘⲞⲒ ⲀⲚ ⲀⲢⲈϢⲀⲚ ⲔⲈⲞⲨⲀⲒ ⲆⲈ Ⲓ- ϦⲈⲚⲠⲈⲦⲈⲪⲰϤ ⲚⲢⲀⲚ ⲦⲈⲦⲈⲚⲚⲀϬⲒⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲚⲀϨϮ ⲈⲢⲈⲦⲈⲚϬⲒⲰⲞⲨ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲞⲨⲞϨ ⲠⲰⲞⲨ ⲚⲦⲈⲠⲒⲞⲨⲀⲒ ⲘⲘⲀⲨⲀⲦϤ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ⲘⲎ ⲦⲈⲦⲈⲚⲘⲈⲨⲒ ϪⲈ ⲀⲚⲞⲔ ⲈⲐⲚⲀⲈⲢⲔⲀⲦⲎ ⲄⲞⲢⲒⲚ ⲈⲢⲰⲦⲈⲚ ϦⲀⲦⲈⲚ ⲪⲒⲰⲦ ⲞⲨⲞⲚ ⲪⲎ ⲈⲐⲚⲀⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲰⲦⲈⲚ ⲘⲰⲨⲤⲎⲤ ⲪⲎ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ⲈⲚⲀⲢⲈⲦⲈⲚⲚⲀϨϮ ⲄⲀⲢ ⲈⲘⲰⲨⲤⲎⲤ ⲚⲀⲢⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞⲒ ϨⲰ ⲠⲈ ⲈⲦⲀ ⲪⲎ ⲄⲀⲢ ⲤϦⲀⲒ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ⲒⲤϪⲈ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲀⲚ ⲈⲚⲒⲤϦⲀⲒ ⲚⲦⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲰⲤ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲚⲀⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲘⲎ ⲢⲘⲪⲒⲞⲘ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲚⲦⲈⲦⲒⲂⲈⲢⲒⲀⲆⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ⲚⲀϤⲘⲞϢⲒ ⲆⲈ ⲚⲤⲰϤ ⲠⲈ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ϪⲈ ⲚⲀⲨⲚⲀⲨ ⲈⲚⲒⲘⲎⲒⲚⲒ ⲈⲚⲀϤⲒⲢⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚⲚⲎ ⲈⲦϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀϤϨⲈⲘⲤⲒ ⲘⲘⲀⲨ ⲠⲈ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ⲚⲈ ⲀϤϦⲰⲚⲦ ⲆⲈ ⲠⲈ ⲚϪⲈⲠⲒⲠⲀⲤⲬⲀ ⲠϢⲀⲒ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ⲈⲦⲀϤϤⲀⲒ ⲞⲨⲚ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲘⲘⲎ ϢⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲠⲈϪⲀϤ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ⲀⲚⲚⲀϪⲈⲘ ⲰⲒⲔ ⲐⲰⲚ ⲈϢⲰⲠ ϨⲒⲚⲀ ⲚⲦⲞⲨⲞⲨⲰⲘ ⲚϪⲈⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ⲪⲀⲒ ⲆⲈ ⲀϤϪⲞϤ ⲈϤⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ⲚⲐⲞϤ ⲄⲀⲢ ⲚⲀϤⲤⲰⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲀϤⲢⲰⲞⲨϢ ⲈⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲤⲚⲤⲀⲐⲢⲈⲒ ⲚⲰⲒⲔ ⲚⲀⲢⲀϢⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϬ ⲒⲚⲞⲨⲔⲞⲨϪⲒ ⲈⲪⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲦⲈ ⲀⲚⲀⲆⲢⲈⲀⲤ ⲠⲈ ⲠⲤⲞⲚ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲖⲞⲨ ⲘⲠⲀⲒⲘⲀ ⲈⲞⲨⲞⲚ Ⲉ- ⲚⲰⲒⲔ ⲚⲒⲰⲦ ⲚⲦⲞⲦϤ ⲚⲈⲘ ⲦⲈⲂⲦ ⲂⲀⲖⲖⲀ ⲈⲢⲈ ⲚⲀⲒ ⲚⲀⲪⲞϨ ⲈⲐⲰⲚ ⲚⲚⲀⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲀⲢⲈ ⲚⲒⲢⲰⲘⲒ ⲢⲞⲐⲂⲞⲨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲆⲈ ⲚⲤⲒⲘ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲢⲞⲐⲂⲞⲨ ⲞⲨⲚ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲈϪⲈⲚ ⲠⲒⲤⲒⲘ ⲦⲞⲨⲎⲠⲒ ⲈⲨⲈⲢ ⲈⲚϢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ⲀϤϬⲒ ⲞⲨⲚ ⲚⲚⲒⲰⲒⲔ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤϮ ⲚⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲈⲦⲈⲂⲦ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲞⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲤⲒ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ϪⲈ ⲐⲰⲞⲨϮ ⲚⲚⲒⲖⲀⲔϨ ⲈⲦⲀⲨⲈⲢϨⲞⲨⲞ ϪⲈ ⲚⲚⲈ ⲞⲨⲞⲚ ⲦⲀⲔⲞ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ⲀⲨⲐⲰⲞⲨϮ ⲚⲚⲎ ⲈⲦⲀⲨⲈⲢϨⲞⲨⲞ ⲞⲨⲞϨ ⲀⲨⲘⲀϨ ⲒⲂ ⲚⲔⲞⲦ ⲚⲖⲀⲔϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈ ⲚⲰⲒⲔ ⲚⲒⲰⲦ ⲚⲎ ⲈⲦⲀⲨⲈⲢϨⲞⲨⲞ ⲈⲚⲎ ⲈⲦⲀⲨⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲚⲀⲨ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ⲈⲚⲒⲘⲎⲒⲚⲒ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲦⲀⲪⲘⲎⲒ ⲪⲀⲒ ⲠⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲐⲚⲎⲞⲨ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ϪⲈ ⲤⲈⲢⲰⲞⲨϢ ⲈⲒ ⲈϨⲞⲖⲘⲈϤ ⲈⲀⲒϤ ⲚⲞⲨⲢⲞ ⲀϤⲈⲢⲀⲚⲀⲬⲰⲢⲒⲚ ⲈϪⲈⲚ ⲠⲒⲦⲰⲞⲨ ⲚⲐⲞϤ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ⲈⲦⲀ ⲢⲞⲨϨⲒ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲒ ⲈϦⲢⲎⲒ ⲈⲪⲒⲞⲘ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ⲞⲨⲞϨ ⲈⲦⲀⲨⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲘⲎⲢ ⲘⲪⲒⲞⲘ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ ⲞⲨⲞϨ ⲚⲈⲀ ⲦⲬⲈⲘⲤ ϨⲎⲆⲎ ϢⲰⲠⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲈⲘⲠⲀⲦⲈϤⲒ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ⲪⲒⲞⲘ ⲆⲈ ⲚⲀϤⲚⲎⲞⲨ ⲚⲚⲈϨⲤⲒ ⲠⲈ ⲈϤⲚⲒϤⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲐⲎⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ⲈⲦⲀⲨⲞⲨⲈⲒ ⲞⲨⲚ ⲈⲂⲞⲖ ⲚⲀⲨ ⲔⲈ ⲚⲤⲦⲀⲆⲒⲞⲚ ⲒⲈ ⲖⲀⲨⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲘⲞϢⲒ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ ⲞⲨⲞϨ ⲈϤϦⲰⲚⲦ ⲘⲘⲞϤ ⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲀⲨⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ⲚⲀⲨⲞⲨⲰϢ ⲞⲨⲚ ⲠⲈ ⲈⲦⲀⲖⲞϤ ⲚⲈⲘⲰⲞⲨ ⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲠⲒϪⲞⲒ ⲀϤⲒ ⲈⲠⲒⲬⲢⲞ ⲈⲠⲒⲔⲀϨⲒ ⲈⲚⲀⲨⲚⲀϢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲠⲒⲘⲎϢ ⲈⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϨⲒⲘⲎⲢ ⲘⲪⲒⲞⲘ ⲀⲨⲚⲀⲨ ϪⲈ ⲘⲘⲞⲚ ⲔⲈϪⲞⲒ ⲘⲘⲀⲨ ⲈⲂⲎⲖ ⲈⲞⲨⲀⲒ ⲞⲨⲞϨ ϪⲈ ⲘⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲖⲖⲀ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲘⲘⲀⲨⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ⲀⲨⲒ ⲚϪⲈϨⲀⲚⲔⲈⲈϪⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲒⲂⲈⲢⲒⲀⲆⲞⲤ ϦⲀⲦⲈⲚ ⲠⲒⲘⲀ ⲈⲦⲀⲨⲞⲨⲰⲘ ⲘⲠⲒⲰⲒⲔ ⲘⲘⲞϤ ⲈⲦⲀϤϢⲈⲠϨⲘⲞⲦ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲚϪⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲚⲀⲨ ⲚϪⲈⲚⲒⲘⲎϢ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨ ⲀⲚ ⲞⲨⲆⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲀⲖⲎⲒ ⲚⲐⲰⲞⲨ ⲈⲚⲒⲈϪⲎⲞⲨ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲔⲀⲪⲀⲢⲚⲀⲞⲨⲰⲘ ⲈⲨⲔⲰϮ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ⲞⲨⲞϨ ⲈⲦⲀⲨϪⲈⲘϤ ϨⲒⲘⲎⲢ ⲘⲪⲒⲞⲘ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲢⲀⲂⲂⲒ ⲈⲦⲀⲔⲒ ⲈⲘⲚⲀⲒ ⲚⲐⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲀⲚ ϪⲈ ⲀⲢⲈⲦⲈⲚⲚⲀⲨ ⲈϨⲀⲚⲘⲎⲒⲚⲒ ⲀⲖⲖⲀ ϪⲈ ⲀⲢⲈⲦⲈⲚⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲰⲒⲔ ⲞⲨⲞϨ ⲀⲢⲈⲦⲈⲚⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ⲀⲢⲒϨⲰⲂ ⲈϮϦⲢⲈ ⲀⲚ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲀⲖⲖⲀ ϮϦⲢⲈ ⲈⲐⲚⲀϢⲰⲠⲒ ⲈⲨⲰⲚϦ ⲚⲈⲚⲈϨ ⲐⲎ ⲈⲦⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲀⲦⲎⲒⲤ ⲚⲰⲦⲈⲚ ⲪⲀⲒ ⲄⲀⲢ ⲀⲪⲚⲞⲨϮ ⲪⲒⲰⲦ ⲈⲢⲤⲪⲢⲀⲄⲒⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ⲠⲈϪⲰⲞⲨ ⲞⲨⲚ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀⲀⲒϤ ϨⲒⲚⲀ ⲚⲦⲈⲚⲈⲢϨⲰⲂ ⲈⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲒϨⲰⲂ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲞⲨⲚ ϪⲈ ⲞⲨ ⲘⲘⲎⲒⲚⲒ ⲈⲦⲈⲔⲒⲢⲒ ⲘⲘⲞϤ ⲚⲐⲞⲔ ϨⲒⲚⲀ ⲚⲦⲈⲚⲚⲀⲨ ⲚⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞⲔ ⲞⲨ ⲚϨⲰⲂ ⲈⲦⲈⲔⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ⲀⲚⲈⲚⲒⲞϮ ⲞⲨⲰⲘ ⲘⲠⲒⲘⲀⲚⲚⲀ ⲚϨⲢⲎⲒ ϨⲒ ⲠϢⲀϤⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲞⲨⲰⲒⲔ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲀϤⲦⲎⲒϤ ⲚⲰⲞⲨ ⲈⲐⲢⲞⲨⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲰⲨⲤⲎⲤ ⲀⲚ ⲀϤϮ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲰⲒⲔ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲀⲖⲖⲀ ⲠⲀⲒⲰⲦ ⲈⲐⲚⲀϮ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲰⲒⲔ ⲚⲦⲀⲪⲘⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ⲠⲒⲰⲒⲔ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲈϤϮ ⲘⲠⲰⲚϦ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲘⲞⲒ ⲚⲀⲚ ⲘⲠⲀⲒⲰⲒⲔ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲰⲒⲔ ⲚⲦⲈⲠⲰⲚϦ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ϨⲀⲢⲞⲒ ⲚⲚⲈϤϨⲔⲞ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲚⲚⲈϤⲒⲂⲒ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ⲀⲖⲖⲀ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ⲞⲨⲞϨ ⲀⲢⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲀ ⲠⲀⲒⲰⲦ ⲦⲎⲒϤ ⲚⲎⲒ ϤⲚⲀⲒ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲒ ϨⲀⲢⲞⲒ ⲚⲚⲀϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ϪⲈ ⲞⲨⲎⲒ ⲄⲀⲢ ⲈⲦⲀⲒⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ϨⲒⲚⲀ ⲀⲚ ⲚⲦⲀⲒⲢⲒ ⲘⲠⲈⲦⲈϨⲚⲎⲒ ⲀⲖⲖⲀ ⲠⲈⲦⲈⲚⲀϤ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ⲪⲀⲒ ⲠⲈ ⲪⲞⲨⲰϢ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ϨⲒⲚⲀ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲦⲎⲒϤ ⲚⲎⲒ ⲚⲦⲀϢⲦⲈⲘⲦⲀⲔⲈ ϨⲖⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀⲖⲖⲀ ⲚⲦⲀⲦⲞⲨⲚⲞⲤϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲪⲞⲨⲰϢ ⲘⲠⲀⲒⲰⲦ ϨⲒⲚⲀ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲨ ⲈⲠⲒϢⲎⲢⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲦⲈϤϢⲰⲠⲒ ⲈⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ⲞⲨⲞϨ ⲚⲦⲀⲦⲞⲨⲚⲞⲤϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ⲚⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲞⲨⲚ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲐⲂⲎⲦϤ ϪⲈ ⲀϤϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲰⲒⲔ ⲈⲦⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠϢⲎⲢⲒ ⲚⲒⲰⲤⲎⲪ ⲪⲎ ⲀⲚⲞⲚ ⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲠⲰⲤ ϤϪⲰ ⲘⲘⲞⲤ ϮⲚⲞⲨ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲘⲠⲈⲢⲬⲢⲈⲘⲢⲈⲘ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲒϨⲀⲢⲞⲒ ⲀⲢⲈϢⲦⲈⲘ ⲪⲒⲰⲦ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲤⲞⲔϤ ϨⲀⲢⲞⲒ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲚⲦⲀⲦⲞⲨⲚⲞⲤϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ⲤⲤϦⲎⲞⲨⲦ ϦⲈⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲈⲨⲈϢⲰⲠⲒ ⲦⲎⲢⲞⲨ ⲚⲢⲈϤϬⲒⲤⲂⲰ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲚⲦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ϤⲚⲀⲒ ϨⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲀⲞⲨⲀⲒ ⲚⲀⲨ ⲈⲪⲒⲰⲦ ⲈⲂⲎⲖ ⲈⲪⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲪⲀⲒ ⲠⲈ ⲈⲦⲀϤⲚⲀⲨ ⲈⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲞⲨⲞⲚⲦⲈϤ ⲰⲚϦ ⲚⲈⲚⲈϨ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲰⲒⲔ ⲚⲦⲈⲠⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ⲚⲈⲦⲈⲚⲒⲞϮ ⲀⲨⲞⲨⲰⲘ ⲘⲠⲒⲘⲀⲚⲚⲀ ⲚϨⲢⲎ ⲒϨⲒ ⲠϢⲀϤⲈ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ⲪⲀⲒ ⲆⲈ ⲠⲈ ⲠⲒⲰⲒⲔ ⲈⲐⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ϨⲒⲚⲀ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚⲦⲈϤϢⲦⲈⲘⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲰⲒⲔ ⲈⲦⲞⲚϦ ⲪⲎ ⲈⲦⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲰⲒⲔ ⲈϤⲈⲰⲚϦ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲠⲒⲰⲒⲔ ⲀⲚⲞⲔ ⲈϮⲚⲀⲦⲎⲒϤ ⲦⲀⲤⲀⲢⲜ ⲦⲈ ⲐⲎ ⲈϮⲚⲀⲦⲎⲒⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲰⲚϦ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ⲚⲀⲨϮ ⲞⲨⲚ ⲠⲈ ⲞⲨⲂⲈ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲪⲀⲒ ϮⲚⲦⲈϤⲤⲀⲢⲜ ⲚⲀⲚ ⲈⲐⲢⲈⲚⲞⲨⲞⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲞⲨⲰⲘ ⲚⲦⲤⲀⲢⲜ ⲘⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲤⲰ ⲘⲠⲈϤⲤⲚⲞϤ ⲘⲘⲞⲚⲦⲈⲦⲈⲚ ⲰⲚϦ ⲘⲘⲀⲨ ⲚϦⲢⲎⲒ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ⲪⲎ ⲈⲐⲞⲨⲰⲘ ⲚⲦⲀⲤⲀⲢⲜ ⲞⲨⲞϨ ⲈⲦⲤⲰ ⲘⲠⲀⲤⲚⲞϤ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϮⲚⲀⲦⲞⲨⲚⲞⲤϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ⲦⲀⲤⲀⲜ ⲄⲀⲢ ⲞⲨϦⲢⲈ ⲚⲦⲀⲪⲘⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲠⲀⲤⲚⲞϤ ⲞⲨⲤⲰ ⲚⲦⲀⲪⲘⲎⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ⲪⲎ ⲈⲐⲞⲨⲰⲘ ⲚⲦⲀⲤⲀⲢⲜ ⲞⲨⲞϨ ⲈⲦⲤⲰ ⲘⲠⲀⲤⲚⲞϤ ϤⲚⲀϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϢⲰⲠⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲪⲎ ⲈⲦⲞⲚϦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮⲰⲚϦ ⲈⲐⲂⲈ ⲪⲒⲰⲦ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲞⲨⲰⲘ ⲘⲘⲞⲒ ⲈϤⲈⲰⲚϦ ϨⲰϤ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ⲪⲀⲒ ⲠⲈ ⲠⲒⲰⲒⲔ ⲈⲦⲀϤⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲘⲪⲢⲎϮ ⲀⲚ ⲚⲚⲒⲒⲞϮ ⲈⲦⲀⲨⲞⲨⲰⲘ ⲞⲨⲞϨ ⲀⲨⲘⲞⲨ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲘⲠⲀⲒⲰⲒⲔ ⲈϤⲈⲰⲚϦ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ⲚⲀⲒ ⲀϤϪⲞⲦⲞⲨ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲦⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ϦⲈⲚⲔⲀⲪⲀⲢⲚⲀⲞⲨⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ϨⲀⲚⲘⲎϢ ⲞⲨⲚ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ϤⲚⲀϢⲦ ⲚϪⲈⲠⲀⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲒⲘ ⲈⲐⲚⲀϢϪⲈⲘϪⲞⲘ ⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚϦⲢⲎⲒ ⲚϦⲎ ⲦϤ ϪⲈ ⲤⲈⲬⲢⲈⲘⲢⲈⲘ ⲈⲐⲂⲈⲪⲀⲒ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈⲦⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲚⲀⲨ ⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲚⲀ ⲈⲠϢⲰⲒ ⲈⲠⲒⲘⲀ ⲈⲚⲀϤⲬⲎ ⲘⲘⲞϤ ⲚϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ⲠⲒⲠⲚⲈⲨⲘⲀⲠⲈⲦⲦⲀⲚϦⲞ ϮⲤⲀⲢⲜ ⲤϮ ϨⲖⲒ ⲚϨⲎⲞⲨ ⲀⲚ ⲚⲒⲤⲀϪⲒ ⲀⲚⲞⲔ ⲈⲦⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲠⲈ ⲞⲨⲞϨ ⲞⲨⲰⲚϦ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ⲀⲖⲖⲀ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲤⲈⲚⲀϨϮ ⲀⲚ ⲚⲀϤⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲒⲤϪⲈⲚ ϨⲎ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲒⲘ ⲚⲈⲚⲎ ⲈⲦⲈⲚⲤⲈⲚⲀϨϮ ⲀⲚ ⲞⲨⲞϨ ϪⲈ ⲚⲒⲘ ⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲠⲈ ϪⲈ ⲈⲐⲂⲈⲪⲀⲒ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲒϨⲀⲢⲞⲒ ⲀⲨϢⲦⲈⲘⲦⲎⲒⲤ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲘⲎϢ ⲚⲦⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲀⲨⲪⲰⲦ ⲈⲪⲀϨⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲘⲞϢⲒ ⲚⲈⲘⲀϤ ⲀⲚ ϪⲈ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲘⲠⲒⲒⲂ ϪⲈ ⲘⲎ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲈϢⲈ ⲚⲰⲦⲈⲚ ϨⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲀⲚⲚⲀϢⲈ ⲚⲀⲚ ϨⲀ ⲚⲒⲘ ϨⲀⲚⲤⲀϪⲒ ⲄⲀⲢ ⲚⲰⲚϦ ⲚⲈⲚⲈϨ ⲈⲦⲈⲚⲦⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲀⲚⲈⲘⲒ ⲞⲨⲞϨ ⲀⲚⲚⲀϨϮ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲐⲞⲨⲀⲂ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲘⲎ ⲀⲚⲞⲔ ⲀⲚ ⲀⲒⲤⲈⲦⲠ ⲐⲎⲚⲞⲨ ϦⲀ ⲠⲒⲒⲂ ⲞⲨⲞϨ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲞⲨⲆⲒⲀⲂⲞⲖⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ⲚⲀϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲠⲈ ⲈⲒⲞⲨⲆⲀⲤ ⲤⲒⲘⲰⲚ ⲠⲒⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲪⲀⲒ ⲄⲀⲢ ⲈⲚⲀϤⲢⲰⲞⲨϢ ⲈⲦⲎⲒϤ ⲈⲞⲨⲀⲒ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨ ⲄⲀⲢ ⲚⲀϤⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲈⲘⲞϢⲒ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ϪⲈ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ⲚⲀϤϦⲈⲚⲦ ⲆⲈ ⲚϪⲈⲠϢⲀⲒ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϮⲤⲔⲎⲚⲞⲠⲎⲄⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲞⲨⲚ ⲚϪⲈⲚⲈϤⲤⲚⲎⲞⲨ ϪⲈ ⲞⲨⲞⲐⲂⲈⲔ ⲈⲂⲞⲖ ⲦⲀⲒ ⲞⲨⲞϨ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϮⲒⲞⲨⲆⲈⲀ ϨⲒⲚⲀ ⲚⲦⲈⲚⲈⲔⲘⲀⲐⲎⲦⲎⲤ ⲚⲀⲨ ⲈⲚⲈⲔϨⲂⲎⲞⲨⲒ ⲈⲦⲈⲔⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ⲞⲨ ⲄⲀⲢ ⲘⲠⲀⲢⲈ ϨⲖⲒ ⲈⲢϨⲰⲂ ϦⲈⲚⲠⲈⲦϨⲎⲠ ⲞⲨⲞϨ ⲚⲦⲈϤⲔⲰϮ ⲚⲤⲰϤ ϦⲈⲚⲠⲈⲐⲞⲨⲰⲚϨ ⲒⲤϪⲈ ⲬⲚⲀⲈⲢ ⲚⲀⲒ ⲞⲨⲞⲚϨⲔ ⲈⲂⲞⲖ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ⲞⲨⲆⲈ ⲄⲀⲢ ⲚⲈϤⲔⲈⲤⲚⲎⲞⲨ ⲚⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲚⲰⲞⲨ ϪⲈ ⲠⲀⲤⲎⲞⲨ ⲀⲚⲞⲔ ⲘⲠⲀⲦⲈϤⲒ ⲠⲈⲦⲈⲚⲤⲎⲞⲨ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ϤⲤⲈⲂⲦⲰⲦ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲘⲈⲤⲦⲈ ⲐⲎⲚⲞⲨ ⲀⲚⲞⲔ ⲆⲈ ϤⲘⲞⲤϮ ⲘⲘⲞⲒ ϪⲈ ⲀⲚⲞⲔ ϮⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦϤ ϪⲈ ⲚⲈϤϨⲂⲎⲞⲨⲒ ⲤⲈϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈϨⲢⲎⲒ ⲈⲠϢⲀⲒ ⲀⲚⲞⲔ ⲆⲈ ⲚϮⲚⲀⲒ ⲀⲚ ⲈϨⲢⲎⲒ ⲈⲠⲒϢⲀⲒ ϪⲈ ⲘⲠⲀⲦⲈ ⲠⲀⲤⲎⲞⲨ ⲀⲚⲞⲔ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚⲐⲞϤ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈⲠϢⲀⲒ ⲚϪⲈⲚⲈϤⲤⲚⲎⲞⲨ ⲦⲞⲦⲈ ⲚⲐⲞϤ ϨⲰϤ ⲀϤⲒ ⲈϨⲢⲎⲒ ϦⲈⲚⲞⲨⲞⲨⲰⲚϨ ⲀⲚ ⲀⲖⲖⲀ ϨⲰⲤ ϦⲈⲚⲞⲨⲬⲰⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲚ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ⲠⲈ ϦⲈⲚⲠϢⲀⲒ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϤⲐⲰⲚ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲚⲬⲢⲈⲘⲢⲈⲘ ⲠⲈ ϦⲈⲚⲠⲒⲘⲎϢ ⲈⲐⲂⲎⲦϤ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲄⲀⲐⲞⲤ ⲠⲈ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲀϤⲤⲰⲢⲈⲘ ⲘⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ⲘⲠⲈ ϨⲖⲒ ⲘⲈⲚⲦⲞⲒ ⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ ϦⲈⲚⲞⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲐⲂⲈ ⲦϨⲞϮ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ϨⲎⲆⲎ ⲆⲈ ⲈⲦⲀ ⲠⲒϢⲀⲒ ⲈⲢⲪⲀϢⲒ ⲀϤⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎⲒ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲞⲨⲚ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲰⲤ ⲪⲀⲒ ⲤⲰⲞⲨⲚ ⲚⲤϦⲀⲒ ⲘⲠⲈϤⲤⲀⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲦⲀⲤⲂⲰ ⲀⲚⲞⲔ ⲐⲰⲒ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ⲪⲎ ⲈⲐⲚⲀⲈⲢⲪⲞⲨⲰϢ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲈϤⲈⲤⲞⲨⲈⲚ ⲦⲀⲤⲂⲰ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲦⲈ ϢⲀⲚ ⲀⲚⲞⲔ ⲠⲈⲦⲤⲀϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ⲪⲎ ⲈⲦⲤⲀϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲘⲀⲨⲀⲦϤ ⲀϤⲔⲰϮ ⲚⲤⲀⲠⲈϤⲰⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲪⲎ ⲆⲈ ⲈⲦⲔⲰϮ ⲚⲤⲀⲠⲰⲞⲨ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞϤ ⲪⲀⲒ ⲞⲨⲐⲘⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲀⲆⲒⲔⲒⲀ ⲚϦⲎ ⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ⲘⲎ ⲘⲰⲨⲤⲎⲤ ⲀⲚ ⲀϤϮ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϤⲒⲢⲒ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲈϦⲞⲐⲂⲈⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒⲘⲎϢ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀⲔ ⲚⲒⲘ ⲠⲈⲦⲔⲰϮ ⲚⲤⲰⲔ ⲈϦⲞⲐⲂⲈⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨϨⲰⲂ ⲚⲞⲨⲰⲦ ⲠⲈⲦⲀⲒⲀⲒϤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲈⲢϢⲪⲎ ⲢⲒ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲘⲰⲨⲤⲎⲤ ϮⲚⲰⲦⲈⲚ ⲘⲠⲒⲤⲈⲂⲒ ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲘⲰⲨⲤⲎⲤ ⲠⲈ ⲠⲒⲤⲈⲂⲒ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞϮ ⲠⲈ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲈⲂⲒ ⲚⲞⲨⲢⲰⲘⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲀϬⲒ ⲘⲠⲒⲤⲈⲂⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲒⲚⲀ ϪⲈ ⲚⲚⲈϤⲂⲰⲖ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲘⲰⲨⲤⲎⲤ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϪⲰⲚⲦ ⲈⲢⲞⲒ ϪⲈ ⲀⲒⲐⲢⲈ ⲞⲨⲢⲰⲘⲒ ⲦⲎⲢϤ ⲞⲨϪⲀⲒ ϦⲈⲚⲠⲤⲀⲂⲂⲀⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ⲘⲠⲈⲢϮϨⲀⲠ ⲔⲀⲦⲀ ϨⲞ ⲀⲖⲖⲀ ⲘⲀϨⲀⲠ ϦⲈⲚⲞⲨϨⲀⲠ ⲘⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲪⲎ ⲈⲦⲞⲨⲔⲰϮ ⲚⲤⲰϤ ⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ϨⲎⲠⲠⲈ ϤⲤⲀϪⲒ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲞⲨⲞϨ ⲤⲈϪⲈ ϨⲖⲒ ⲚⲀϤ ⲀⲚ ⲘⲎⲠⲰⲤ ⲢⲰ ⲀⲨⲈⲘⲒ ⲦⲀⲪⲘⲎⲒ ⲚϪⲈⲚⲒⲀⲢⲬⲰⲚ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ⲀⲖⲖⲀ ⲪⲀⲒ ⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲀϤϢⲀⲚⲒ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲈⲘⲒ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ⲀϤⲰϢ ⲞⲨⲚ ⲈⲂⲞⲖ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈϤϮⲤⲂⲰ ⲞⲨⲞϨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ⲐⲰⲚ ⲞⲨⲞϨ ⲚⲈⲦⲀⲒⲒ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲞⲨⲐⲘⲎⲒ ⲠⲈ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲪⲎ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ⲀⲚⲞⲔ ⲆⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲪⲎ ⲠⲈ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ⲚⲀⲨⲔⲰϮ ⲞⲨⲚ ⲈⲦⲀϨⲞϤ ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ⲈⲚ ⲚⲈϤϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ϪⲈ ⲞⲨⲎⲒ ⲚⲈⲘⲠⲀⲦⲈⲤⲒ ⲚϪⲈⲦⲈϤⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ϨⲀⲚⲘⲎϢ ⲞⲨⲚ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲘⲎ ϤⲚⲀⲈⲢ ϨⲞⲨⲞ ⲢⲰ ⲈⲚⲀⲒⲘⲎⲒⲚⲒ ⲈⲦⲀ ⲪⲀⲒ ⲀⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲚⲒⲘⲎϢ ⲈⲨⲬⲢⲈⲘⲢⲈⲘ ⲚⲚⲀⲒ ⲈⲐⲂⲎⲦϤ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚϨⲀⲚϨⲨⲠⲎ ⲢⲈⲦⲎⲤ ϨⲒⲚⲀ ⲚⲤⲈⲦⲀϨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ϪⲈ ⲈⲦⲒ ⲔⲈⲔⲞⲨϪⲒ ⲚⲬⲢⲞⲚⲞⲤ ϮϢⲞⲠ ⲚⲈⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϪⲈⲘⲦ ⲀⲚ ⲞⲨⲞϨ ⲪⲘⲀ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ⲠⲈϪⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲚ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲀⲢⲈ ⲪⲀⲒ ⲚⲀϢⲈ ⲚⲀϤ ⲈⲐⲰⲚ ⲚⲦⲈⲚϢⲦⲈⲘϪⲈⲘϤ ⲘⲎ ϤⲚⲀϢⲈ ⲚⲀϤ ⲈⲠⲒϪⲰⲢ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲞⲨⲞϨ ⲚⲦⲈϤϮⲤⲂⲰ ⲚⲚⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ⲠⲀⲒⲤⲀϪⲒ ⲞⲨ ⲠⲈ ⲈⲦⲀϤϪⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲔⲰϮ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϪⲈⲘⲦ ⲀⲚ ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ ⲚⲦⲈⲠⲒⲚⲒϢϮ ⲚϢⲀⲒ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲚⲀϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲦⲞⲂⲒ ⲘⲀⲢⲈϤⲒ ϨⲀⲢⲞⲒ ⲚⲦⲈϤⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲤϪⲞⲤ ⲚϪⲈϮⲄⲢⲀⲪⲎ ϪⲈ ϨⲀⲚⲒⲀⲢⲰⲞⲨ ⲘⲘⲰⲞⲨ ⲚⲰⲚϦ ⲈⲐⲚⲀϦⲀϮ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈϤⲚⲈϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ⲪⲀⲒ ⲆⲈ ⲀϤϪⲞϤ ⲈⲐⲂⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲚⲀⲨⲚⲀϬ ⲒⲦϤ ⲚϪⲈⲚⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲈⲘⲠⲀⲦⲈ ⲠⲚⲈⲨⲘⲀⲄⲀⲢ ϢⲰⲠⲒ ⲠⲈ ϪⲈ ⲚⲈⲘⲠⲀⲦⲈ ⲒⲎⲤⲞⲨⲤ ϬⲒⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲎϢ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲚⲀⲒⲤⲀϪⲒ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲀⲪⲘⲎⲒ ⲪⲀⲒ ⲠⲈ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲀⲢⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ⲘⲎ ⲚⲈⲦⲀⲤϪⲞⲤ ⲀⲚ ⲚϪⲈϮⲄⲢⲀⲪⲎ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠϪⲢⲞϪ ⲚⲆⲀⲨⲒⲆ ⲠⲈ ⲞⲨⲞϨ ϪⲈ ⲀⲢⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲂⲎⲐⲖⲈⲈⲘ ⲠⲒϮⲘⲒ ⲈⲚⲀⲢⲈ ⲆⲀⲨⲒⲆ ⲬⲎ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ⲞⲨⲤⲬⲒⲤⲘⲀ ⲞⲨⲚ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲠⲒⲘⲎ ϢⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲚϦⲎⲦⲞⲨ ⲚⲀⲨⲞⲨⲰϢ ⲈⲦⲀϨⲞϤ ⲠⲈ ⲀⲖⲖⲀ ⲘⲠⲈ ϨⲖⲒ ϢⲈⲚ ⲚⲈϤϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ⲀⲨⲒ ⲞⲨⲚ ⲚϪⲈⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ϨⲀ ⲚⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲰⲞⲨ ⲚϪⲈⲚⲎ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲘⲠⲈⲦⲈⲚⲈⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈ ⲢⲰⲘⲒ ⲤⲀϪⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ⲀⲨⲈⲢⲞⲨⲰ ⲆⲈ ⲚⲰⲞⲨ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲀⲢⲈⲦⲈⲚⲤⲰⲢⲈⲘ ϨⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ⲘⲎ ⲀϨⲖⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲀⲢⲬⲰⲚ ⲚⲀϨϮ ⲈⲢⲞϤ ⲒⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ⲀⲖⲖⲀ ⲠⲀⲒⲘⲎϢ ⲈⲦⲈⲚⲤⲈⲤⲰⲞⲨⲚ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲀⲚ ⲤⲈⲬⲎ ϦⲀ ⲠⲤⲀϨⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ⲠⲈϪⲈ ⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲚⲰⲞⲨ ⲪⲎ ⲈⲦⲀϤⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲚϢⲞⲢⲠ ⲚϪⲰⲢϨ ⲈⲞⲨⲀⲒ ⲠⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ϪⲈ ⲘⲎ ⲠⲈⲚⲚⲞⲘⲞⲤ ⲚⲀϮϨⲀⲠ ⲈⲠⲒⲢⲰⲘⲒ ⲀϤϢⲦⲈⲘⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲚⲦⲈϤⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈⲦⲈϤⲒⲢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ⲀⲨⲈⲢⲞⲨⲰ ⲚⲀϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ϨⲰⲔ ϦⲞⲦϦⲈⲦ ⲞⲨⲞϨ ⲀⲚⲀⲨ ϪⲈ ⲘⲘⲞⲚ ⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲀⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ⲞⲨⲞϨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲈⲠⲈϤⲘⲀ ");
INSERT INTO copbhc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲒⲦⲰⲞⲨ ⲚⲦⲈⲚⲒϪⲰⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ⲒⲦⲀ ⲀϤⲒ ⲚϨⲀⲚⲀⲦⲞⲞⲨⲒ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲒⲘⲎ ϢⲆⲈ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲀϤϨⲈⲘⲤⲒ ⲈϮⲤⲂⲰ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲆⲈ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲒⲚⲒ ⲚⲀϤ ⲚⲞⲨⲤϨⲒⲘⲒ ⲀⲨϪⲈⲘⲤ ϦⲈⲚⲞⲨⲠⲞⲢⲚⲒⲀ ⲞⲨⲞϨ ⲀⲨⲦⲀϨⲞⲤ ⲈⲢⲀⲦⲤ ϦⲈⲚⲐⲘⲎϮ ");
INSERT INTO copbhc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ ⲦⲀⲒⲤϨⲒⲘⲒ ⲐⲀⲒ ⲀⲚϪⲈⲘⲤ ϦⲈⲚⲞⲨⲠⲞⲢⲚⲒⲀ ");
INSERT INTO copbhc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ⲞⲨⲞϨ ⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈϨⲒⲰⲚⲒ ⲈϪⲰⲤ ⲞⲨ ⲠⲈ ⲆⲈ ⲈⲦⲈⲔϪⲰ ⲘⲘⲞϤ ⲚⲐⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ⲪⲀⲒ ⲆⲈ ⲀⲨϪⲰϤ ⲈⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲞϤ ϨⲒⲚⲀ ⲚⲦⲞⲨϪⲈⲘ ⲖⲰⲒϪⲒ ϨⲒϪⲰϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲢⲒⲔⲒ ⲚⲚⲈϤⲂⲀⲖ ⲀϤⲤϦⲀⲒ ⲘⲠⲈϤⲦⲎⲂ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ⲈⲦⲀⲨⲰⲤⲔ ⲆⲈ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲀϤϤⲀⲒ ⲚⲦⲈϤⲀⲪⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲘ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀϬⲚⲈ ⲚⲞⲂⲒ ⲘⲀⲢⲈϤϨⲒⲰⲚⲒ ⲈϪⲰⲤ ⲚϢⲞⲢⲠ ⲚⲞⲨⲰⲚⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ⲦⲞⲦⲈ ⲀϤⲢⲈⲔ ϪⲰϤ ⲞⲨⲞϨ ⲀϤⲤϦⲀⲒ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲀⲨⲔⲀϮ ⲈⲠⲈϤⲤⲞϨⲒ ⲀⲨⲈⲢϨⲎⲦⲤ ⲚⲒ ⲈⲂⲞⲖ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ϢⲀⲦⲞⲨⲒ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲠⲞⲨⲘⲎϢ ⲞⲨⲞϨ ⲀϤⲤⲰϪⲠ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨⲀⲦϤ ⲚⲈⲘ ϮⲤϨⲒⲘⲒ ⲐⲎ ⲈⲚⲀⲤⲬⲎ ϦⲈⲚⲐⲘⲎϮ ");
INSERT INTO copbhc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ⲀⲒⲎⲤⲞⲨⲤ ϤⲀⲒ ⲚⲦⲈϤⲀⲪⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲰϮⲤϨⲒⲘⲒ ⲀⲨⲐⲰⲚ ⲚⲎ ⲈⲦⲀⲨϮϨⲀⲠ ⲈⲢⲞ ⲘⲘⲞⲚ ⲞⲨⲀⲒ ⲈϤϮϨⲀⲠ ⲈⲢⲞ ");
INSERT INTO copbhc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ϮⲚⲀⲨ ⲀⲚ ⲈⲞⲨⲀⲒ ⲠⲀϬⲞⲒⲤ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲈⲒϮϨⲀⲠ ⲈⲢⲞ ⲘⲀϢⲈ ⲚⲈⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲘⲠⲈⲢⲦⲀⲤⲐⲞ ⲈⲈⲢⲚⲞⲂⲒ ϪⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲪⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲪⲎ ⲈⲐⲚⲀⲘⲞϢⲒ ⲚⲤⲰⲒ ⲚⲚⲈϤⲘⲞϢⲒ ϦⲈⲚⲠⲒⲬⲀⲔⲒ ⲀⲖⲖⲀ ⲈϤⲈϬⲒ ⲘⲪⲞⲨⲰⲒⲚⲒ ⲚⲦⲈⲠⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ⲠⲈϪⲈ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲞⲨⲚ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲘⲘⲀⲨⲀⲦⲔ ⲈⲦⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲔ ⲦⲈⲔⲘⲈⲦⲘⲈⲐⲢⲈ ⲞⲨⲘⲎⲒ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲔⲀⲚ ⲈϢⲰⲠ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲒ ⲞⲨⲘⲎⲒ ⲦⲈ ⲦⲀⲘⲈⲦⲘⲈⲐⲢⲈ ϪⲈ ϮⲈⲘⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ⲐⲰⲚ ⲞⲨⲞϨ ⲀⲒⲚⲀϢⲈ ⲚⲎⲒ ⲈⲐⲰⲚ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ⲐⲰⲚ ⲒⲈ ⲀⲒⲚⲀϢⲈ ⲚⲎⲒ ⲈⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ⲚⲐⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϮϨⲀⲠ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲀⲚⲞⲔ ⲆⲈ ϮϮϨⲀⲠ ⲈϨⲖⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚϮϨⲀⲠ ⲠⲀϨⲀⲠ ⲀⲚⲞⲔ ⲞⲨⲘⲎⲒ ⲠⲈ ϪⲈ ⲚϮⲬⲎ ⲘⲘⲀⲨⲀⲦ ⲀⲚ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲚⲈⲘ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ⲞⲨⲞϨ ⲤⲤϦⲎⲞⲨⲦ ⲆⲈ ⲞⲚ ϦⲈⲚⲠⲈⲦⲈⲚⲚⲞⲘⲞⲤ ϪⲈ ⲐⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲢⲰⲘⲒ ⲂⲞⲨⲐⲘⲎⲒ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ⲀⲚⲞⲔ ϮⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲒ ⲞⲨⲞϨ ϤⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲒ ⲚϪⲈⲪⲒⲰⲦ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲀϤⲐⲰⲚ ⲠⲈⲔⲒⲰⲦ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲚⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲀⲚ ⲞⲨⲆⲈ ⲠⲀⲔⲈⲒⲰⲦ ⲈⲚⲀⲢⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲚⲀⲢⲈⲦⲈⲚⲚⲀⲤⲞⲨⲈⲚ ⲠⲀⲔⲈⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ⲚⲀⲒⲤⲀϪⲒ ⲀϤϪⲞⲦⲞⲨ ϦⲈⲚⲠⲒⲄⲀⲌⲞⲪⲨⲖⲀⲔⲒⲞⲚ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ϢⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲚⲈⲘⲠⲀⲦⲈⲤⲒ ⲚϪⲈⲦⲈϤⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ⲠⲀⲖⲒⲚ ⲞⲚ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲔⲰϮ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϪⲈⲘⲦ ⲀⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲘⲞⲨ ϦⲈⲚⲚⲈⲦⲈⲚⲚⲞⲂⲒ ⲞⲨⲞϨ ⲠⲒⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲘⲎ ⲀϤⲚⲀϦⲞⲐⲂⲈϤ ⲘⲘⲀⲨⲀⲦϤ ϪⲈ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲒⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲠⲈ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲦⲈⲚϦⲢⲎⲒ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲘⲠϢⲰⲒ ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ⲀⲒϪⲞⲤ ⲞⲨⲚ ⲚⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲘⲞⲨ ϦⲈⲚⲚⲈⲦⲈⲚⲚⲞⲂⲒ ⲈϢⲰⲠ ⲄⲀⲢ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲚⲀϨϮ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲦⲈⲦⲈⲚⲚⲀⲘⲞⲨ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲈⲦⲈⲚⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚⲀϤ ⲠⲈ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲚϮⲀⲢⲬⲎ ⲀⲒⲈⲢ ⲠⲔⲈⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ⲞⲨⲞⲚϮ ⲞⲨⲘⲎϢ ⲈϪⲞⲦⲞⲨ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲈϮϨⲀⲠ ⲀⲖⲖⲀ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲞⲨⲐⲘⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲚⲎ ⲈⲦⲀⲒⲤⲞⲐⲘⲞⲨ ⲚⲦⲞⲦϤ ⲚⲀⲒ ϮⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ⲘⲠⲞⲨⲈⲘⲒ ϪⲈ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲐⲂⲈ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚϬ ⲈⲤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲦⲞⲦⲈ ⲈⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲞⲨⲞϨ ϮⲈⲢ ϨⲖⲒ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲦⲤⲀⲂⲞⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲚⲀⲒ ϮⲤⲀϪⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ϤⲬⲎ ⲚⲈⲘⲎⲒ ⲞⲨⲞϨ ⲘⲠⲈϤⲬⲀⲦ ⲘⲘⲀⲨⲀⲦ ϪⲈ ⲀⲚⲞⲔ ϮⲒⲢⲒ ⲚⲚⲎ ⲈⲐⲢⲀⲚⲀϤ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ϨⲀⲚⲘⲎϢ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ⲚⲀϤϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ϪⲈ ⲈϢⲰⲠ ⲚⲐⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲞϨⲒ ϦⲈⲚⲠⲀⲤⲀϪⲒ ⲦⲀⲪⲘⲎⲒ ⲚⲐⲰⲦⲈⲚ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈⲤⲞⲨⲈⲚ ⲐⲘⲎⲒ ⲞⲨⲞϨ ⲈⲢⲈ ⲐⲘⲎⲒ ⲈⲢ ⲐⲎⲚⲞⲨ ⲚⲢⲈⲘϨⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ⲀⲨⲈⲢⲞⲨⲰ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲚ ⲚⲀ ⲠⲤⲠⲈⲢⲘⲀ ⲚⲀⲂⲢⲀⲀⲘ ⲞⲨⲞϨ ⲘⲠⲈⲚⲈⲢⲂⲰⲔ ⲚϨⲖⲒ ⲈⲚⲈϨ ⲠⲰⲤ ⲚⲐⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲢⲈⲦⲈⲚⲈⲢⲢⲈⲘϨⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲒⲢⲒ ⲘⲪⲚⲞⲂⲒ ⲞⲨⲂⲰⲔ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ⲠⲒⲂⲰⲔ ⲆⲈ ⲘⲠⲀϤⲞϨⲒ ϦⲈⲚⲠⲒⲎⲒ ϢⲀ ⲈⲚⲈϨ ⲠⲒϢⲎⲢⲒ ⲆⲈ ⲚⲐⲞϤ ϢⲀϤⲞϨⲒ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ⲈϢⲰⲠ ⲞⲨⲚ ⲀⲢⲈϢⲀⲚ ⲠⲒϢⲎⲢⲒ ⲈⲢ ⲐⲎⲚⲞⲨ ⲚⲢⲈⲘϨⲈ ⲞⲚⲦⲰⲤ ⲦⲈⲦⲈⲚⲚⲀⲈⲢⲢⲈⲘϨⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ϮⲈⲘⲒ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲀ ⲠϪⲢⲞϪ ⲚⲀⲂⲢⲀⲀⲘ ⲀⲖⲖⲀ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲈϦⲞⲐⲂⲎⲦ ϪⲈ ⲠⲀⲤⲀϪⲒ ϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ⲚⲎ ⲞⲨⲚ ⲀⲚⲞⲔ ⲈⲦⲀⲒⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲚⲦⲞⲦϤ ⲘⲠⲀⲒⲰⲦ ⲚⲀⲒ ϮⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲚⲎ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲞⲐⲘⲞⲨ ⲚⲦⲞⲦϤ ⲘⲠⲈⲦⲈⲚⲒⲰⲦ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲈⲚⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲈⲚϢⲎⲢⲒ ⲚⲀⲂⲢⲀⲀⲘ ⲠⲈ ⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲀⲂⲢⲀⲀⲘ ⲚⲀⲢⲈⲦⲈⲚⲚⲀⲀⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ϮⲚⲞⲨ ⲆⲈ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲈϦⲞⲐⲂⲎ ⲦⲞⲨⲢⲰⲘⲒ ⲈϤϪⲰ ⲚⲐⲘⲎⲒ ⲚⲰⲦⲈⲚ ⲐⲎ ⲈⲦⲀⲒⲤⲞⲐⲘⲈⲤ ⲚⲦⲞⲦϤ ⲘⲪⲚⲞⲨϮ ⲪⲀⲒ ⲘⲠⲈ ⲀⲂⲢⲀⲀⲘ ⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲚⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲚ ϨⲀⲚϪⲪⲞ ⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚⲦⲠⲞⲢⲚⲒⲀ ⲞⲨⲒⲰⲦ ⲘⲘⲀⲨⲀⲦϤ ⲈⲦⲈⲚⲦⲀⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈⲚⲈ ⲪⲚⲞⲨϮ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲠⲈ ⲚⲀⲢⲈⲦⲈⲚⲚⲀⲘⲈⲚⲢⲒⲦ ⲠⲈ ⲀⲚⲞⲔ ⲄⲀⲢ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀⲒⲒ ⲞⲨ ⲄⲀⲢ ⲚⲈⲦⲀⲒⲒ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲚⲐⲞϤ ⲠⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ⲈⲐⲂⲈⲞⲨ ⲦⲀϪⲒⲚⲤⲀϪⲒ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ϪⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲤⲰⲦⲈⲘ ⲈⲠⲀⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲚⲒⲰⲦ ⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲞⲨⲞϨ ⲚⲒⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲦⲈⲠⲈⲦⲈⲚⲒⲰⲦ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲈⲀⲒⲦⲞⲨ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲞⲨⲢⲈϤϦⲀⲦⲈⲂ ⲢⲰⲘⲒ ⲠⲈ ⲒⲤϪⲈⲚ ϨⲎ ⲞⲨⲞϨ ⲘⲠⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲐⲘⲎⲒ ⲈⲚⲈϨ ϪⲈ ⲘⲘⲞⲚ ⲘⲈⲐⲘⲎⲒ ϢⲞⲠ ⲚϦⲎⲦϤ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲤⲀϪⲒ ⲚϪⲈⲠⲒⲘⲈⲐⲚⲞⲨϪ ϢⲀϤⲤⲀϪⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲦⲈⲚⲞⲨϤ ϪⲈ ⲞⲨⲤⲀⲘⲈⲐⲚⲞⲨϪ ⲠⲈ ⲚⲈⲘ ⲠⲈϤⲔⲈⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ⲀⲚⲞⲔ ⲆⲈ ϮϪⲰ ⲚⲐⲘⲎⲒ ⲚⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ⲚⲒⲘ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲐⲚⲀⲤⲞϨⲒ ⲘⲘⲞⲒ ⲈⲐⲂⲈ ⲞⲨⲚⲞⲂⲒ ⲒⲤϪⲈ ⲐⲘⲎⲒ ⲦⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ⲠⲒⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ ⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϢⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲔⲀⲖⲰⲤ ⲀⲚⲞⲚ ⲀⲚϪⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲤⲀⲘⲀⲢⲒⲦⲎⲤ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲘⲘⲞⲚ ⲆⲈⲘⲰⲚ ⲚⲈⲘⲎⲒ ⲀⲖⲖⲀ ϮⲈⲢⲦⲒⲘⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚϢⲰϢ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ⲀⲚⲞⲔ ⲆⲈ ⲚⲀⲒⲔⲰϮ ⲚⲤⲀⲠⲀⲰⲞⲨ ⲘⲘⲀⲨⲀⲦ ⲀⲚ ϤϢⲞⲠ ⲚϪⲈⲪⲎ ⲈⲦⲔⲰϮ ⲞⲨⲞϨ ⲈⲦϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲀⲢⲈϨ ⲈⲠⲀⲤⲀϪⲒ ⲚⲚⲈϤⲚⲀⲨ ⲈⲪⲘⲞⲨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ⲠⲈϪⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ϮⲚⲞⲨ ⲀⲚⲈⲘⲒ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀⲔ ⲀⲂⲢⲀⲀⲘ ⲀϤⲘⲞⲨ ⲚⲈⲘ ⲚⲒⲔⲈⲠⲢⲞⲪⲎⲦⲎⲤ ⲞⲨⲞϨ ⲚⲐⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀⲀⲢⲈϨ ⲈⲠⲀⲤⲀϪⲒ ⲚⲚⲈϤϪⲈⲘϮⲠⲒ ⲘⲪⲘⲞⲨ ϢⲀ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ⲘⲎ ⲚⲐⲞⲔ ⲞⲨⲚⲒϢϮ ⲚⲐⲞⲔ ⲈⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ⲪⲎ ⲈⲦⲀϤⲘⲞⲨ ⲞⲨⲞϨ ⲚⲒⲔⲈⲠⲢⲞⲪⲎ ⲦⲎⲤ ⲀⲨⲘⲞⲨ ⲀⲔⲒⲢⲒ ⲘⲘⲞⲔ ⲚⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲀⲚⲞⲔ ⲀⲒϢⲀⲚϮⲰⲞⲨ ⲚⲎⲒ ⲘⲘⲀⲨⲀⲦ ⲠⲀⲰⲞⲨ ϨⲖⲒ ⲠⲈ ϤϢⲞⲠ ⲚϪⲈⲠⲀⲒⲰⲦ ⲈⲐⲚⲀϮⲰⲞⲨ ⲚⲎⲒ ⲪⲎ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚⲚⲞⲨϮ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲤⲞⲨⲰⲚϤ ⲀⲚⲞⲔ ⲆⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲒϢⲀⲚϪⲞⲤ ϪⲈ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲈⲒⲈϢⲰⲠⲒ ⲈⲒⲞⲚⲒ ⲘⲘⲰⲦⲈⲚ ⲚⲤⲀⲘⲈⲐⲚⲞⲨϪ ⲀⲖⲖⲀ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϤⲤⲀϪⲒ ϮⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ⲀⲂⲢⲀⲀⲘ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲚⲀϤⲐⲈⲖⲎⲖ ⲠⲈ ⲈϤⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲞⲨⲈϨⲞⲞⲨ ⲚⲦⲎⲒ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲀϤⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ⲠⲈϪⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲀϤ ϪⲈ ⲘⲠⲀⲦⲈⲔⲈⲢ ⲚⲚⲢⲞⲘⲠⲒ ⲞⲨⲞϨ ⲀⲔⲚⲀⲨ ⲈⲀⲂⲢⲀⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲠⲀⲦⲈ ⲀⲂⲢⲀⲀⲘ ϢⲰⲠⲒ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ⲀⲨⲈⲖ ⲰⲚⲒ ⲞⲨⲚ ϨⲒⲚⲀ ⲚⲤⲈϨⲒⲞⲨⲒ ⲈϪⲰϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲬⲞⲠϤ ⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲀϤⲤⲒⲚⲒ ⲚⲀϤⲘⲞϢⲒ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲞⲨⲞϨ ⲚⲀϤⲤⲒⲚⲒⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ⲞⲨⲞϨ ⲈϤⲤⲒⲚⲒ ⲀϤⲚⲀⲨ ⲈⲞⲨⲢⲰⲘⲒ ⲘⲂⲈⲖⲖⲈ ⲘⲘⲒⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ⲞⲨⲞϨ ⲀⲨϢⲈⲚϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲢⲀⲂⲂⲒ ⲚⲒⲘ ⲠⲈⲦⲀϤⲈⲢⲚⲞⲂⲒ ⲪⲀⲒ ⲠⲈ ϢⲀⲚ ⲚⲈϤⲒⲞϮ ⲚⲈϪⲈ ⲀⲨⲘⲀⲤϤ ⲈϤⲞⲒ ⲘⲂⲈⲖⲖⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲞⲨⲆⲈ ⲪⲀⲒ ⲘⲠⲈϤⲈⲢⲚⲞⲂⲒ ⲞⲨⲆⲈ ⲚⲈϤⲒⲞϮ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ⲀⲚⲞⲚ ϨⲰϮ ⲈⲢⲞⲚ ⲠⲈ ⲚⲦⲈⲚⲈⲢϨⲰⲂ ⲈⲚⲒϨⲂⲎ ⲞⲨⲒ ⲚⲦⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲚ ϨⲰⲤ ⲠⲒⲈϨⲞⲞⲨ ⲠⲈ ϤⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈⲠⲒⲈϪⲰⲢϨ ϨⲞⲦⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲈⲢϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ϨⲰⲤ ⲈⲒϦⲈⲚ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚⲞⲔ ⲠⲈ ⲪⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲀϤϨⲒⲞⲨⲒ ⲚⲞⲨⲐⲀϤ ⲈⲠⲈⲤⲎ ⲦⲞⲨⲞϨ ⲀϤⲐⲀⲘⲒⲞ ⲚⲞⲨⲞⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲐⲀϤ ⲞⲨⲞϨ ⲀϤⲖⲀⲖⲰϤ ⲈⲚⲈⲚⲂⲀⲖ ⲘⲠⲒⲂⲈⲖⲖⲈ ⲘⲘⲒⲤⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲒⲀ ⲠⲈⲔϨⲞ ⲈⲂⲞⲖ ϦⲈⲚϮⲔⲞⲖⲨⲘⲂⲎⲐⲢⲀ ⲚⲦⲈⲠⲒⲤⲒⲖⲰⲀⲘ ⲪⲎ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲪⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠϤ ⲀϤϢⲈ ⲚⲀϤ ⲞⲨⲚ ⲀϤⲒⲰⲒ ⲘⲠⲈϤϨⲞ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲒ ⲈϤⲚⲀⲨ ⲘⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ⲚⲈϤⲐⲈϢⲈⲨ ⲞⲨⲚ ⲚⲈⲘ ⲚⲎ ⲈⲦⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲚϢⲞⲢⲠ ϪⲈ ⲚⲈⲞⲨϢⲀⲦ ⲘⲈⲐⲚⲀⲒ ⲠⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲪⲎ ⲈⲚⲀϤϨⲈⲘⲤⲒ ⲈϤϢⲀⲦ ⲘⲈⲐⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞϤ ⲠⲈ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲀϤⲞⲚⲒ ⲘⲘⲞϤ ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚⲀϤ ⲠⲈ ϪⲈ ⲠⲰⲤ ⲀⲨⲞⲨⲰⲚ ⲚϪⲈⲚⲈⲔⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲈϪⲀϤ ϪⲈ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲀϤⲐⲀⲘⲒⲞ ⲚⲞⲨⲞⲘⲒ ⲀϤⲖⲀⲖⲰϤ ⲈⲚⲀⲂⲀⲖ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲎⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲒⲀ ⲠⲈⲔϨⲞ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲒⲖⲰⲀⲘ ⲀⲒϢⲈ ⲚⲎⲒ ⲞⲨⲚ ⲀⲒⲒⲰⲒ ⲘⲠⲀϨⲞ ⲈⲂⲞⲖ ⲀⲒⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀϤⲐⲰⲚ ϨⲰϤ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲈϪⲀϤ ϪⲈ ϮⲈⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ⲀⲨⲈⲚϤ ⲞⲨⲚ ϨⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲪⲎ ⲈⲚⲀϤⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲚⲞⲨⲤⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ⲚⲈ ⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲆⲈ ⲠⲈⲦⲀϤⲐⲀⲘⲒⲞ ⲘⲠⲒⲞⲘⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀϤⲐⲢⲈ ⲚⲈϤⲂⲀⲖ ⲞⲨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ⲠⲀⲖⲒⲚ ⲞⲨⲚ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲚϪⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲠⲰⲤ ⲀⲔⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲞⲘⲒ ⲠⲈⲦⲀϤⲬⲀϤ ⲈϪⲈⲚ ⲚⲀⲂⲀⲖ ⲞⲨⲞϨ ⲀⲒⲒⲀⲦ ⲈⲂⲞⲖ ⲀⲒⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲠⲀⲒⲢⲰⲘⲒ ⲚⲞⲨⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲀⲚ ⲠⲈ ϪⲈ ⲚϤⲀⲢⲈϨ ⲀⲚ ⲈⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲞⲨⲢⲰⲘⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲈⲢ ⲚⲀⲒⲘⲎⲒⲚⲒ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲞϨ ⲞⲨⲤⲬⲒⲤⲘⲀ ⲚⲀϤϢⲞⲠ ⲚϦⲎⲦⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ⲠⲀⲖⲒⲚ ⲞⲨⲚ ⲠⲈϪⲰⲞⲨ ⲘⲠⲒⲂⲈⲖⲖⲈ ϪⲈ ⲞⲨ ⲚⲐⲞⲔ ⲈⲦⲈⲔϪⲰ ⲘⲘⲞϤ ⲈⲐⲂⲎⲦϤ ϪⲈ ⲀϤⲞⲨⲰⲚ ⲚⲚⲈⲔⲂⲀⲖ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ⲘⲠⲞⲨⲦⲈⲚϨⲞⲨⲦϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲚⲀϤⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ϢⲀⲦⲞⲨⲘⲞⲨϮ ⲈⲚⲈϤⲒⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲈⲚⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚ ⲪⲀⲒ ⲠⲈ ⲠⲈⲦⲈⲚϢⲎⲢⲒ ⲪⲎ ⲈⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲘⲀⲤϤ ⲈϤⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲠⲰⲤ ϪⲈ ϮⲚⲞⲨ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲈϤⲒⲞϮ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲈⲚϢⲎⲢⲒ ⲞⲨⲞϨ ϪⲈ ⲀⲚⲘⲀⲤϤ ⲈϤⲞⲒ ⲘⲂⲈⲖⲖⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ⲠⲰⲤ ϪⲈ ϮⲚⲞⲨ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲒⲈ ⲚⲒⲘ ⲀϤⲞⲨⲰⲚ ⲚⲚⲈϤⲂⲀⲖ ⲀⲚⲞⲚ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ϢⲈⲚϤ ⲦⲈϤⲘⲀⲒⲎ ⲚⲦⲀϤ ⲘⲘⲀⲨⲀⲦϤ ϨⲰϤ ⲈⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ⲚⲀⲒ ⲀⲨϪⲞⲦⲞⲨ ⲚϪⲈⲚⲈϤⲒⲞϮ ⲈⲠⲒⲆⲎ ⲚⲀⲨⲈⲢϨⲞϮ ⲠⲈ ϦⲀⲦϨⲎ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲚⲈⲀⲨⲤⲈⲘⲚⲎ ⲦⲤ ⲄⲀⲢ ⲠⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϨⲒⲚⲀ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲚⲦⲞⲨⲀⲒϤ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲨϪⲞⲤ ⲚϪⲈⲚⲈϤⲒⲞϮ ϪⲈ ⲦⲈϤⲘⲀⲒⲎ ⲚⲦⲀϤ ϨⲰϤ ϢⲈⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ⲀⲨⲘⲞⲨϮ ⲞⲨⲚ ⲈⲠⲒⲢⲰⲘⲒ ⲘⲪⲘⲀϨⲤⲞⲠ ⲂⲪⲀⲒ ⲈⲚⲀϤⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲀⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲀⲚⲞⲚ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲠⲀⲒⲢⲰⲘⲒ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲪⲎ ⲈⲚⲀϤⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲠⲈ ⲚϮⲈⲘⲒ ⲀⲚ ⲞⲨⲀⲒ ⲆⲈ ⲠⲈϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲚⲀⲒⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲠⲈ ϮⲚⲞⲨ ⲆⲈ ϮⲚⲀⲨ ⲘⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲀϤⲀⲒϤ ⲚⲀⲔ ⲠⲰⲤ ⲀϤⲞⲨⲰⲚ ⲚⲚⲈⲔⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ϪⲈ ϨⲎⲆⲎ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ⲞⲨⲞϨ ⲘⲠⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲞⲨ ⲞⲚ ⲈⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲈⲤⲞⲐⲘⲈϤ ⲘⲎ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ϨⲰⲦⲈⲚ ⲈⲈⲢⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϨⲰⲞⲨϢ ⲈⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲞⲚ ϨⲀⲚⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ⲀⲚⲞⲚ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲀⲪⲚⲞⲨϮ ⲤⲀϪⲒ ⲚⲈⲘ ⲘⲰⲨⲤⲎⲤ ⲪⲀⲒ ⲆⲈ ⲚⲐⲞϤ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲐⲀⲒ ⲢⲰ ⲦⲈ ϮϢⲪⲎⲢⲒ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲠⲈ ⲞⲨⲞϨ ⲀϤⲞⲨⲰⲚ ⲚⲚⲀⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲘⲠⲀⲢⲈ ⲪⲚⲞⲨϮ ⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲈⲞⲨϢⲀⲘϢⲈ ⲚⲞⲨϮ ⲠⲈ ⲞⲨⲀⲒ ⲞⲨⲞϨ ⲈϤⲒⲢⲒ ⲘⲠⲈϤⲞⲨⲰϢ ⲪⲀⲒ ϢⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ⲒⲤϪⲈⲚ ⲠⲈⲚⲈϨ ⲘⲠⲈⲚⲤⲰⲦⲈⲘ ϪⲈ Ⲁ- ⲞⲨⲀⲒ ⲞⲨⲰⲚ ⲚⲚⲈⲚⲂⲀⲖ ⲚⲞⲨⲂⲈⲖⲖⲈ ⲘⲘⲒⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ⲈⲚⲈ ⲪⲀⲒ ⲞⲨⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ ⲀⲚ ⲠⲈ ⲚⲀϤⲚⲀϢϪⲈⲘϪⲞⲘ ⲀⲚ ⲠⲈ ⲈⲈⲢ ϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ⲀⲨⲈⲢⲞⲨⲰ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨϪⲪⲞ ⲦⲎⲢⲔ ϦⲈⲚⲪⲚⲞⲂⲒ ⲞⲨⲞϨ ⲚⲐⲞⲔ ⲈⲐⲚⲀϮⲤⲂⲰ ⲚⲀⲚ ⲞⲨⲞϨ ⲀⲨϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲨϨⲒⲦϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈⲘϤ ⲠⲈϪⲀϤ ϪⲈ ⲬⲚⲀϨϮ ⲚⲐⲞⲔ ⲈⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲠⲀϬⲞⲒⲤ ϨⲒⲚⲀ ⲚⲦⲀⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲬⲚⲀⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲪⲎ ⲠⲈ ⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϮⲚⲀϨϮ ⲠⲀϬⲞⲒⲤ ⲞⲨⲞϨ ⲀϤⲞⲨⲰϢⲦ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲈⲦⲀⲒⲒ ⲀⲚⲞⲔ ⲈⲨϨⲀⲠ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲒⲚⲀ ⲚⲎ ⲈⲦⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲚⲦⲞⲨⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲦⲞⲨⲈⲢⲂⲈⲖⲖⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ⲀⲨⲤⲰⲦⲈⲘ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲦⲬⲎ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲎ ⲀⲚⲞⲚ ϨⲀⲚⲂⲈⲖⲖⲈⲨ ϨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲈⲚⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲂⲈⲖⲖⲈⲨ ⲠⲈ ⲚⲈⲘⲘⲞⲚⲦⲈⲦⲈⲚ ⲚⲞⲂⲒ ⲘⲘⲀⲨ ⲠⲈ ϮⲚⲞⲨ ⲆⲈ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲚⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ϤϢⲞⲠ ⲚϪⲈⲠⲈⲦⲈⲚⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲦⲈⲚϤⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲢⲞ ⲈϮⲀⲨⲖⲎ ⲚⲦⲈⲚⲒⲈⲤⲰⲞⲨ ⲀⲖⲖⲀ ⲈϤⲚⲎⲞⲨ ⲈⲠϢⲰⲒ ⲚϬⲞϤⲦⲈⲚ ⲪⲀⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲢⲈϤϬⲒⲞⲨⲒ ⲠⲈ ⲞⲨⲞϨ ⲞⲨⲤⲞⲚⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ⲪⲎ ⲆⲈ ⲈⲐⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲢⲞ ⲪⲀⲒ ⲞⲨⲘⲀⲚⲈⲤⲰⲞⲨ ⲠⲈ ⲚⲦⲈⲚⲒⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ⲪⲀⲒ ϢⲀⲢⲈ ⲠⲒⲈⲘⲚⲞⲨϮ ⲞⲨⲰⲚ ⲚⲀϤ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒⲈⲤⲰⲞⲨ ⲤⲰⲦⲈⲘ ⲈⲦⲈϤⲤⲘⲎ ⲞⲨⲞϨ ϢⲀϤⲘⲞⲨϮ ⲈⲚⲈϤⲈⲤⲰⲞⲨ ⲔⲀⲦⲀ ⲚⲞⲨⲢⲀⲚ ⲞⲨⲞϨ ϢⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲒⲚⲒ ⲚⲚⲎ ⲈⲦⲈⲚⲞⲨϤ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϢⲀϤⲘⲞϢⲒ ϦⲀϪⲰⲞⲨ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲚⲒⲈⲤⲰⲞⲨ ⲘⲞϢⲒ ⲚⲤⲰϤ ϪⲈ ⲞⲨⲎⲒ ⲤⲈⲤⲰⲞⲨⲚ ⲚⲦⲈϤⲤⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ⲠⲒϢⲈⲘⲘⲞ ⲆⲈ ⲘⲠⲀⲨⲘⲞϢⲒ ⲚⲤⲰϤ ⲀⲖⲖⲀ ⲈⲨⲈⲪⲰⲦ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ϪⲈ ⲤⲈⲤⲰⲞⲨⲚ ⲀⲚ ⲚⲦⲤⲘⲎ ⲘⲠⲒϢⲈⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ⲦⲀⲒⲠⲀⲢⲞⲒⲘⲒⲀ ⲀϤϪⲞⲤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲈⲘⲒ ϪⲈ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲐⲂⲈⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ⲠⲀⲖⲒⲚ ⲞⲚ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲤⲂⲈ ⲚⲦⲈⲚⲒⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲒ ϦⲀϪⲰⲒ ϨⲀⲚⲤⲞⲚⲒ ⲚⲈⲞⲨⲞϨ ϨⲀⲚⲢⲈϤϬⲒⲞⲨⲒ ⲚⲈⲀⲖⲖⲀ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ ⲚⲤⲰⲞⲨ ⲚϪⲈⲚⲒⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲤⲂⲈ ⲚⲦⲈⲚⲒⲈⲤⲰⲞⲨ ⲪⲎ ⲈⲐⲚⲀⲒ ⲈϦⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲈϤⲈⲚⲞϨⲈⲘ ⲞⲨⲞϨ ⲈϤⲈⲒ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲈϤⲈⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤⲈϪⲒⲘⲒ ⲚⲞⲨⲘⲀⲘⲘⲞⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ⲠⲒⲢⲈϤϬⲒⲞⲨⲒ ⲆⲈ ⲚⲐⲞϤ ⲘⲠⲀϤⲒ ⲈⲂⲎⲖ ⲀⲢⲎⲞⲨ ⲚⲦⲈϤϬⲒⲞⲨⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲰⲦ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲀⲔⲞ ⲀⲚⲞⲔ ⲈⲦⲀⲒⲒ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲰⲚϦ ϢⲰⲠⲒ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈⲞⲨϨⲞⲨⲞ ϢⲰⲠⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲈⲐⲚⲀⲚⲈϤ ⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲈⲐⲚⲀⲚⲈϤ ϢⲀϤϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲈϤⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ⲠⲒⲢⲈⲘⲂⲈⲬⲈ ⲆⲈ ⲚⲐⲞϤ ⲞⲨⲞϨ ⲈⲦⲈⲚⲞⲨⲘⲀⲚⲈⲤⲰⲞⲨ ⲀⲚ ⲠⲈ ⲪⲎ ⲈⲦⲈ ⲚⲒⲈⲤⲰⲞⲨ ⲚⲞⲨϤ ⲀⲚ ⲚⲈⲀϤϢⲀⲚⲚⲀⲨ ⲈⲠⲒⲞⲨⲰⲚϢ ⲈϤⲚⲎⲞⲨ ϢⲀϤⲪⲰⲦ ⲞⲨⲞϨ ϢⲀϤⲬⲀ ⲚⲒⲈⲤⲰⲞⲨ ⲞⲨⲞϨ ϢⲀⲢⲈ ⲠⲒⲞⲨⲰⲚϢ ϨⲞⲖⲘⲞⲨ ⲞⲨⲞϨ ϢⲀϤϪⲞⲢⲞⲨ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ϪⲈ ⲞⲨⲢⲈⲘⲂⲈⲬⲈ ⲠⲈ ⲞⲨⲞϨ ⲤⲈⲢⲘⲈⲖⲒⲚ ⲚⲀϤ ⲀⲚ ϦⲀ ⲚⲒⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲘⲀⲚⲈⲤⲰⲞⲨ ⲈⲐⲚⲀⲚⲈϤ ϮⲤⲰⲞⲨⲚ ⲚⲚⲎ ⲈⲦⲈⲚⲞⲨⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲚⲞⲨⲒ ⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲀⲚⲞⲔ ϨⲰ ϮⲤⲰⲞⲨⲚ ⲘⲪⲒⲰⲦ ⲞⲨⲞϨ ϮⲚⲀⲬⲰ ⲚⲦⲀⲮⲨⲬⲎ ⲈϪⲈⲚ ⲚⲀⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲚϨⲀⲚⲔⲈⲈⲤⲰⲞⲨ ⲘⲘⲀⲨ ⲈϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲒⲀⲨⲖⲎ ⲀⲚ ⲚⲈϨⲰϮ ⲈⲢⲞⲒ ⲈⲈⲚ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲞⲨⲞϨ ⲈⲨⲈⲤⲰⲦⲈⲘ ⲈⲦⲀⲤⲘⲎ ⲞⲨⲞϨ ⲈⲨⲈϢⲰⲠⲒ ⲈⲨⲞϨⲒ ⲚⲞⲨⲰⲦ ⲞⲨⲘⲀⲚⲈⲤⲰⲞⲨ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ⲈⲐⲂⲈⲪⲀⲒ ϤⲘⲈⲒ ⲘⲘⲞⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ϪⲈ ⲀⲚⲞⲔ ϮⲬⲰ ⲚⲦⲀⲮⲨⲬⲎ ϨⲒⲚⲀ ⲞⲚ ⲚⲦⲀϬⲒⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ⲘⲘⲞⲚ ϨⲖⲒ ⲰⲖⲒ ⲘⲘⲞⲤ ⲚⲦⲞⲦ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲈⲦⲬⲰ ⲘⲘⲞⲤ ⲚϦⲢⲎⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲞⲨⲞⲚϮ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈⲬⲀⲤ ⲞⲨⲞⲚϮ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲞⲚ ⲈϬⲒⲦⲤ ⲐⲀⲒ ⲦⲈ ϮⲈⲚⲦⲞⲖⲎ ⲈⲦⲀⲒϬⲒⲦⲤ ⲚⲦⲞⲦϤ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ⲞⲨⲤⲬⲒⲤⲘⲀ ⲞⲨⲚ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲐⲂⲈ ⲚⲀⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ϨⲀⲚⲘⲎϢ ⲆⲈ ⲞⲨⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ϤⲖⲞⲂⲒ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒⲤⲀϪⲒ ⲚⲀ ⲞⲨⲢⲰⲘⲒ ⲀⲚ ⲚⲈⲈⲞⲨⲞⲚ ⲞⲨⲆⲈⲘⲰⲚ ⲚⲈⲘⲀϤ ⲘⲎ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲞⲨⲆⲈⲘⲰⲚ ⲈⲀⲞⲨⲰⲚ ⲚⲚⲈⲚⲂⲀⲖ ⲚϨⲀⲚⲂⲈⲖⲖⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ⲀϤϢⲰⲠⲒ ⲘⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚϪⲈⲞⲨⲀⲒⲔ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲦⲪⲢⲰ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ⲞⲨⲞϨ ⲚⲀϤⲘⲞϢⲒ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ϦⲀ ϮⲤⲦⲞⲀ ⲚⲦⲈⲤⲞⲖⲞⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ⲀⲨⲦⲀⲔⲦⲞ ⲞⲨⲚ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ϢⲀ ⲐⲚⲀⲨ ⲔⲰⲖⲒ ⲚⲦⲈⲚⲮⲨⲬⲎ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϪⲞⲤ ⲚⲀⲚ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲀⲚ ⲚⲒϨⲂⲎⲞⲨⲒ ⲈϮⲢⲀ ⲘⲘⲰⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲚⲐⲰⲞⲨ ⲈⲦⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ⲀⲖⲖⲀ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞⲒ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲈⲤⲰⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ⲚⲀⲈⲤⲰⲞⲨ ⲀⲚⲞⲔ ϢⲀⲨⲤⲰⲦⲈⲘ ⲈⲦⲀⲤⲘⲎ ⲞⲨⲞϨ ϢⲀⲨⲘⲞϢⲒ ⲚⲤⲰⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϮⲚⲀϮ ⲚⲰⲞⲨ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ⲞⲨⲞϨ ⲚⲚⲞⲨⲦⲀⲔⲞ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲚⲚⲈϢ ϨⲖⲒ ϨⲞⲖⲘⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ⲪⲎ ⲈⲦⲀ ⲠⲀⲒⲰⲦ ⲦⲎⲒϤ ⲚⲎⲒ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀϢϨⲞⲖⲘⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦϪⲒϪ ⲘⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ⲀⲚⲞⲔ ⲚⲈⲘ ⲠⲀⲒⲰⲦ ⲀⲚⲞⲚ ⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ⲀⲨⲈⲖ ⲰⲚⲒ ⲞⲨⲚ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϨⲒⲚⲀ ⲚⲤⲈϨⲒⲞⲨⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲘⲎϢ ⲚϨⲰⲂ ⲈⲚⲀⲚⲈⲨ ⲀⲒⲦⲀⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲀⲒⲰⲦ ⲈⲐⲂⲈ ⲀϢ ⲞⲨⲚ ⲚϨⲰⲂ ⲦⲈⲦⲈⲚⲚⲀϨⲒⲰⲚⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ⲀⲨⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲈⲐⲂⲈ ⲞⲨϨⲰⲂ ⲈⲚⲀⲚⲈϤ ⲦⲈⲚⲚⲀϨⲒⲰⲚⲒ ⲈϪⲰⲔ ⲀⲚ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ϪⲈⲞⲨⲀ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲢⲰⲘⲒ ϨⲰⲔ ⲔⲒⲢⲒ ⲘⲘⲞⲔ ⲚⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲘⲎ ⲤⲤϦⲎⲞⲨⲦ ⲀⲚ ϦⲈⲚⲠⲈⲦⲈⲚⲚⲞⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲀⲒϪⲞⲤ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ⲒⲤϪⲈ ⲀϤϪⲞⲤ ⲈⲚⲎ ϪⲈ ⲚⲞⲨϮ ⲚⲎ ⲈⲦⲀ ⲠⲤⲀϪⲒ ⲘⲪⲚⲞⲨϮ ϢⲰⲠⲒ ϨⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ⲪⲎ ⲈⲦⲀ ⲪⲒⲰⲦ ⲦⲞⲨⲂⲞϤ ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲢⲠϤ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲔϪⲈⲞⲨⲀ ϪⲈ ⲀⲒϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ⲒⲤϪⲈ ϮⲒⲢⲒ ⲀⲚ ⲈⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲘⲠⲈⲢⲚⲀϨϮ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ⲒⲤϪⲈ ⲆⲈ ϮⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲔⲀⲚ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲚⲀϨϮ ⲈⲢⲞⲒ ⲚⲀϨϮ ⲈⲚⲒϨⲂⲎⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲀⲚⲞⲔ ϮϦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲠⲀⲒⲰⲦ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ⲠⲀⲖⲒⲚ ⲞⲚ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰϤ ⲠⲈ ⲈⲦⲀϨⲞϤ ⲞⲨⲞϨ ⲀϤⲪⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨϪⲒϪ ");
INSERT INTO copbhc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ⲞⲨⲞϨ ⲀϤϢⲈ ⲚⲀϤ ⲞⲚ ⲈⲘⲎⲢ ⲘⲠⲒⲒⲞⲢⲆⲀⲚⲎ ⲤⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲒⲰⲀⲚⲚⲎⲤ ϮⲰⲘⲤ ⲘⲘⲞϤ ⲚϢⲞⲢⲠ ⲞⲨⲞϨ ⲀϤϢⲰⲠⲒ ⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ⲞⲨⲞϨ ⲀⲨⲒ ϨⲀⲢⲞϤ ⲚϪⲈϨⲀⲚⲘⲎϢ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲘⲠⲈϤⲈⲢ ϨⲖⲒ ⲘⲘⲎⲒⲚⲒ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲈⲐⲂⲈ ⲪⲀⲒ ϨⲀⲚⲘⲈⲐⲘⲎⲒ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ⲞⲨⲞϨ ϨⲀⲚⲘⲎϢ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲆⲈ ⲈϤϢⲰⲚⲒ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲂⲎⲐⲀⲚⲒⲀ ⲈⲂⲞⲖ ϦⲈⲚⲠϮⲘⲒ ⲘⲘⲀⲢⲒⲀ ⲚⲈⲘ ⲘⲀⲢⲐⲀ ⲦⲈⲤⲤⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ⲚⲈ ⲐⲀⲒ ⲆⲈ ⲦⲈ ⲘⲀⲢⲒⲀ ⲐⲎ ⲈⲦⲀⲤⲐⲀϨⲤ ⲘⲠϬⲞⲒⲤ ⲘⲠⲒⲤⲞϪⲈⲚ ⲞⲨⲞϨ ⲀⲤϤⲰϮ ⲚⲚⲈϤϬ ⲀⲖⲀⲨϪ ⲘⲠⲈⲤϤⲰⲒ ⲐⲎ ⲈⲚⲀⲢⲈ ⲠⲈⲤⲤⲞⲚ ⲖⲀⲌⲀⲢⲞⲤ ϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ⲀⲨⲞⲨⲰⲢⲠ ⲞⲨⲚ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲈϤⲤⲰⲚⲒ ⲚⲤϨⲒⲘⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲤ ⲪⲎ ⲈⲦⲈⲔⲘⲈⲒ ⲘⲘⲞϤ ϤϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲦⲀⲒⲒⲀⲂⲒ ⲚⲞⲨⲒⲀⲂⲒ ⲘⲪⲘⲞⲨ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒⲰⲞⲨ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤⲘⲈⲒ ⲘⲘⲀⲢⲐⲀ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲦⲈⲤⲤⲰⲚⲒ ⲚⲈⲘ ⲖⲀⲌⲀⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ⲦⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ϪⲈ ϤϢⲰⲚⲒ ⲀϤϢⲰⲠⲒ ⲘⲠⲒⲘⲀ ⲈⲚⲀϤⲬⲎ ⲘⲘⲞϤ ⲚⲈϨⲞⲞⲨ Ⲃ-. ");
INSERT INTO copbhc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ⲘⲈⲚⲈⲚⲤⲀ ⲪⲀⲒ ⲠⲈϪⲀϤ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲘⲀⲢⲞⲚ ⲈϮⲒⲞⲨⲆⲈⲀ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲢⲀⲂⲂⲒ ϮⲚⲞⲨ ⲚⲀⲨⲔⲰϮ ⲚⲤⲰⲔ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϨⲒⲰⲚⲒ ⲈϪⲰⲔ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲬⲚⲀϢⲈ ⲚⲀⲔ ⲈⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲎ ⲒⲂ ⲚⲞⲨⲚⲞⲨ ⲈⲦⲬⲎ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲪⲎ ⲈⲐⲘⲞϢⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲘⲠⲀϤϬⲒϬⲢⲞⲠ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲪⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ⲪⲎ ⲆⲈ ⲈⲐⲘⲞϢⲒ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ϢⲀϤϬⲒϬⲢⲞⲠ ϪⲈ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲚϦⲎⲦϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲠⲈⲚϢⲪⲎⲢ ⲀϤⲚⲔⲞⲦ ⲀⲖⲖⲀ ⲈⲒⲈϢⲈ ⲚⲎⲒ ⲚⲦⲀⲦⲞⲨⲚⲞⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ⲠⲈϪⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲤϪⲈ ⲀϤⲚⲔⲞⲦ ⲈϤⲈⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤϪⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲈⲚⲔⲞⲦ ⲚⲦⲈⲠⲈϤⲘⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲘⲈⲨⲒ ⲠⲈ ϪⲈ ⲀϤϪⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲚⲔⲞⲦ ⲚⲦⲈⲠⲒϨⲒⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ⲦⲞⲦⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲀϤⲘⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ⲞⲨⲞϨ ϮⲢⲀϢⲒ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲚⲀⲒⲬⲎ ⲘⲘⲀⲨ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲘⲀⲢⲞⲚ ϢⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ⲠⲈϪⲈ ⲐⲰⲘⲀⲤ ⲞⲨⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲚⲚⲈϤϢⲪⲎⲢ ⲘⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲘⲀⲢⲞⲚ ϨⲰⲚ ϨⲒⲚⲀ ⲚⲦⲈⲚⲘⲞⲨ ⲚⲈⲘⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ⲈⲦⲀϤⲒ ⲞⲨⲚ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϪⲈⲘϤ ⲈⲠⲈϤⲆ ⲠⲈ ⲈϤⲬⲎ ϦⲈⲚⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ⲂⲎⲐⲀⲚⲒⲀ ⲆⲈ ⲚⲀⲤϦⲈⲚⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲀⲨ ⲒⲈ ⲚⲤⲦⲀⲆⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ⲞⲨⲘⲎϢ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲀⲨⲒ ⲠⲈ ϨⲀ ⲘⲀⲢⲒⲀ ⲚⲈⲘ ⲘⲀⲢⲐⲀ ⲈⲐⲂⲈ ⲠⲞⲨⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ⲈⲦⲀⲤⲤⲰⲦⲈⲘ ⲞⲨⲚ ⲚϪⲈⲘⲀⲢⲐⲀ ϪⲈ ϤⲚⲎⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀⲤⲦⲰⲚⲤ ⲀⲤⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲀⲤϨⲈⲘⲤⲒ ϦⲈⲚⲠⲒⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ⲞⲨⲚ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲈⲚⲀⲔⲬⲎ ⲘⲠⲀⲒⲘⲀ ⲚⲀⲢⲈ ⲠⲀⲤⲞⲚ ⲚⲀⲘⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ⲀⲖⲖⲀ ϮⲚⲞⲨ ⲞⲨⲚ ϮⲈⲘⲒ ϪⲈ ⲪⲎ ⲈⲦⲈⲔⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ϤⲚⲀⲦⲎⲒϤ ⲚⲀⲔ ⲚϪⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ϤⲚⲀⲦⲰⲚϤ ⲚϪⲈⲠⲈⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ⲚⲀϤ ϪⲈ ϮⲈⲘⲒ ϪⲈ ϤⲚⲀⲦⲰⲚϤ ϦⲈⲚϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲈⲘ ⲠⲒⲰⲚϦ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲔⲀⲚ ⲀϤϢⲀⲚⲘⲞⲨ ⲈϤⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲚϦ ⲞⲨⲞϨ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲚⲚⲈϤⲘⲞⲨ ϢⲀ ⲈⲚⲈϨ ⲦⲈⲚⲀϨϮ ⲈⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲚⲞⲔ ϮⲚⲀϨϮ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀⲤϪⲞϤ ⲀⲤϢⲈ ⲚⲀⲤ ⲀⲤⲘⲞⲨϮ ⲈⲘⲀⲢⲒⲀ ⲦⲈⲤⲤⲰⲚⲒ ⲚⲬⲰⲠ ⲈⲀⲤϪⲞⲤ ⲚⲀⲤ ϪⲈ ϤⲦⲀⲒ ⲚϪⲈⲠⲒⲢⲈϤϮⲤⲂⲰ ⲞⲨⲞϨ ϤⲘⲞⲨϮ ⲈⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ⲚⲐⲞⲤ ⲆⲈ ⲈⲦⲀⲤⲤⲰⲦⲈⲘ ⲀⲤⲦⲰⲚⲤ ⲚⲬⲰⲖⲈⲘ ⲞⲨⲞϨ ⲀⲤⲒ ϨⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ⲚⲈ ⲘⲠⲀⲦⲈϤⲒ ⲄⲀⲢ ⲠⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϨⲢⲎ ⲒⲈⲠϮⲘⲒ ⲀⲖⲖⲀ ⲚⲀϤⲬⲎ ⲞⲨⲚ ⲠⲈ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲀ ⲘⲀⲢⲐⲀ ⲒϨⲀⲢⲞϤ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲚ ⲚⲎ ⲈⲚⲀⲨⲬⲎ ⲚⲈⲘⲀⲤ ⲈϦⲞⲨⲚ ϦⲈⲚⲠⲒⲎⲒ ⲈⲨⲐⲰⲦ ⲘⲠⲈⲤϨⲎⲦ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲘⲀⲢⲒⲀ ϪⲈ ⲀⲤⲦⲰⲚⲤ ⲚⲬⲰⲖⲈⲘ ⲞⲨⲞϨ ⲀⲤⲒ ⲈⲂⲞⲖ ⲀⲨⲘⲞϢⲒ ⲚⲤⲰⲤ ⲈⲨⲘⲈⲨⲒ ⲚⲰⲞⲨ ϪⲈ ⲀⲤⲚⲀϨⲰⲖ ⲈⲠⲒⲘϨⲀⲨ ϨⲒⲚⲀ ⲚⲦⲈⲤⲢⲒⲘⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ⲘⲀⲢⲒⲀ ⲞⲨⲚ ⲈⲦⲀⲤⲒ ⲈⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲬⲎ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲈⲦⲀⲤⲚⲀⲨ ⲈⲢⲞϤ ⲀⲤϨⲒⲦⲤ ⲈϦⲢⲎⲒ ϦⲀⲦⲈⲚ ⲚⲈϤϬⲀⲖⲀⲨϪ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲈⲚⲀⲔⲬⲎ ⲘⲠⲀⲒⲘⲀ ⲚⲀⲢⲈ ⲠⲀⲤⲞⲚ ⲚⲀⲘⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞⲤ ⲈⲤⲢⲒⲘⲒ ⲚⲈⲘ ⲚⲒⲔⲈⲒⲞⲨⲆⲀⲒ ⲈⲦⲀⲨⲒ ⲚⲈⲘⲀⲤ ⲈⲨⲢⲒⲘⲒ ⲀϤⲘⲔⲀϨ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲀϤϢⲐⲞⲢⲦⲈⲢ ");
INSERT INTO copbhc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲬⲀϤ ⲐⲰⲚ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲀⲘⲞⲨ ⲞⲨⲞϨ ⲀⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ⲞⲨⲞϨ ⲀⲚⲈϤⲂⲀⲖ ϮⲈⲢⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲀⲚⲀⲨ ⲠⲰⲤ ϤⲘⲈⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲒⲈ ⲚⲈⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲪⲀⲒ ⲠⲈ ⲈⲦⲀϤⲞⲨⲰⲚ ⲚⲚⲈⲚⲂⲀⲖ ⲘⲠⲒⲂⲈⲖⲖⲈ ⲘⲘⲒⲤⲒ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘⲬⲀ ⲠⲀⲒⲬⲈⲦ ⲈⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲀϤϢⲈⲚϨⲎⲦ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲀϤⲒ ⲈⲠⲒⲘϨⲀⲨ ⲚⲈⲞⲨⲂⲎⲂ ⲆⲈ ⲠⲈ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲚⲰⲚⲒ ⲦⲞⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ϢⲰⲠ ⲘⲠⲀⲒⲰⲚⲒ ⲘⲘⲀⲨ ⲠⲈϪⲈ ⲘⲀⲢⲐⲀ ⲚⲀϤ ⲦⲤⲰⲚⲒ ⲘⲪⲎ ⲈⲦⲀϤⲘⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲀϤⲬⲰⲚⲤ ⲠⲈϤⲆ ⲄⲀⲢ ⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲠⲒϪⲞⲤ ⲚⲈϪⲈ ⲀⲢⲈϢⲀⲚⲚⲀϨϮ ⲦⲈⲢⲀⲚⲀⲨ ⲈⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ⲀⲨⲰⲖⲒ ⲞⲨⲚ ⲘⲠⲒⲰⲚⲒ ⲈⲂⲞⲖ ϨⲒ ⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤϤⲀⲒ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ϮϢⲈⲠϨⲘⲞⲦ ⲚⲦⲞⲦⲔ ϪⲈ ⲀⲔⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ⲀⲚⲞⲔ ⲆⲈ ⲚⲀⲒⲈⲘⲒ ⲠⲈ ϪⲈ ⲔⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲠⲀⲒⲘⲎϢ ⲈⲦⲔⲰϮ ⲈⲢⲞⲒ ⲀⲒϪⲞⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲚⲀϨϮ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲀⲘⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ⲀϤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲪⲎ ⲈⲦⲀϤⲘⲞⲨ ⲈϤⲘⲎⲢ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲚⲈⲘ ⲚⲈϤϪⲒϪ ⲚϨⲀⲚⲤⲈⲂⲈⲚ ⲞⲨⲞϨ ⲠⲈϤϨⲞ ⲘⲎⲢ ⲚⲞⲨⲤⲞⲆⲀⲢⲒⲞⲚ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲀϮⲞⲨⲰ ⲘⲘⲞϤ ⲬⲀϤ ⲈⲂⲞⲖ ⲘⲀⲢⲈϤϢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ⲞⲨⲘⲎϢ ⲞⲨⲚ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲎ ⲈⲦⲀⲨⲒ ϨⲀ ⲘⲀⲢⲒⲀ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ϨⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲦⲀⲘⲰⲞⲨ ⲈⲪⲎ ⲈⲦⲀϤⲀⲒϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ⲀⲨⲐⲰⲞⲨϮ ⲞⲨⲚ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲞⲨⲐⲰⲞⲨⲦⲤ ⲞⲨⲞϨ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲚⲀⲀⲒϤ ⲚⲀϢⲈ ⲚⲒⲘⲎⲒⲚⲒ ⲈⲦⲈ ⲠⲀⲒⲢⲰⲘⲒ ⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ⲈϢⲰⲠ ⲀⲚϢⲀⲚⲬⲀϤ ⲘⲠⲀⲒⲢⲎϮ ⲤⲈⲚⲀϨϮ ⲈⲢⲞϤ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲤⲈⲚⲀⲒ ⲚϪⲈⲚⲒⲢⲰⲘⲈⲞⲤ ⲤⲈⲚⲀⲰⲖⲒ ⲘⲠⲈⲚⲦⲞⲠⲞⲤ ⲚⲈⲘ ⲚⲈⲚϢⲖⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎ ⲦⲞⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲔⲀⲒⲀⲪⲀ ⲈϤⲞⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚϮⲢⲞⲘⲠⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲚϨⲖⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ⲞⲨⲆⲈ ⲦⲈⲦⲈⲚⲘⲞⲔⲘⲈⲔ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲤⲈⲢⲚⲞϤⲢⲒ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲢⲰⲘⲒ ⲘⲘⲀⲨⲀⲦϤ ⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲚⲦⲈϢⲦⲈⲘ ⲠⲒⲈⲐⲚⲞⲤ ⲦⲎⲢϤ ⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ⲚⲈⲦⲀϤϪⲈ ⲪⲀⲒ ⲆⲈ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲖⲖⲀ ϪⲈ ⲚⲀϤⲞⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲦⲈϮⲢⲞⲘⲠⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ ϪⲈ ϨⲰϮ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒϢⲖⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ⲞⲨⲞϨ ⲈϪⲈⲚ ⲠⲒϢⲖⲞⲖ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲀⲖⲖⲀ ⲚⲒⲔⲈϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦϪⲎⲢ ⲈⲂⲞⲖ ⲚⲦⲈϤⲐⲞⲨⲰⲦⲞⲨ ⲈⲨⲘⲈⲦⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲤⲞϬⲚⲒ ϨⲒⲚⲀ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲚⲀϤⲘⲞϢⲒ ⲀⲚ ϪⲈ ⲠⲈ ⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲀⲖⲖⲀ ⲀϤϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈⲞⲨⲬⲰⲢⲀ ϦⲀⲦⲈⲚ ⲠⲒϢⲀϤⲈ ⲈⲞⲨⲂⲀⲔⲒ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲈⲪⲢⲈⲘ ⲞⲨⲞϨ ⲀϤϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ⲚⲀϤϦⲈⲚⲦ ⲆⲈ ⲠⲈ ⲚϪⲈⲠⲒⲠⲀⲤⲬⲀ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲀⲨⲒ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϨⲢⲎ ⲒⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲂⲞⲖ ϦⲈⲚϮⲬⲰⲢⲀ ϦⲀϪⲈⲚ ⲠⲒⲠⲀⲤⲬⲀ ϨⲒⲚⲀ ⲚⲦⲞⲨⲦⲞⲨⲂⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ⲚⲀⲨⲔⲰϮ ⲞⲨⲚ ⲠⲈ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ϤⲚⲀⲒ ⲀⲚ ⲈⲠϢⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ⲚⲈ ⲀⲨϮ ⲈⲚⲦⲞⲖⲎ ⲠⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϨⲒⲚⲀ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲈⲘⲒ ϪⲈ ⲀϤⲐⲰⲚ ⲚⲦⲈϤⲦⲀⲘⲰⲞⲨ ⲈⲢⲞϤ ⲚⲤⲈⲦⲀϨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ϦⲀϪⲈⲚ ⲚⲈϨⲞⲞⲨ ⲚⲦⲈⲠⲒⲠⲀⲤⲬ ⲀⲀϤⲒ ⲈⲂⲎⲐⲀⲚⲒⲀ ⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲖⲀⲌⲀⲢⲞⲤ ⲘⲘⲞϤ ⲪⲎ ⲈⲦⲀϤⲘⲞⲨ ⲪⲎ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ⲀⲨⲈⲢ ⲞⲨⲆⲒⲠⲚⲞⲚ ⲈⲢⲞϤ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲘⲀⲢⲐⲀ ⲚⲀⲤϢⲈⲘϢⲒ ⲞⲨⲞϨ ⲖⲀⲌⲀⲢⲞⲤ ⲚⲈⲞⲨⲀⲒ ⲠⲈ ⲚⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ⲘⲀⲢⲒⲀ ⲞⲨⲚ ⲀⲤϬⲒ ⲚⲞⲨⲖⲒⲦⲢⲀ ⲚⲤⲞϪⲈⲚ ⲚⲦⲈⲞⲨⲚⲀⲢⲆⲞⲤ ⲘⲠⲒⲤⲦⲒⲔⲎ ⲈⲚⲀϢⲈ ⲚⲤⲞⲨⲈⲚϤ ⲞⲨⲞϨ ⲀⲤⲐⲰϨⲤ ⲚⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲒⲎⲤⲞⲨⲤ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲤϤⲞⲦⲞⲨ ⲘⲠϤⲰⲒ ⲚⲦⲈⲦⲈⲤⲀⲪⲈ ⲀⲠⲒⲎⲒ ⲆⲈ ⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲐⲞⲒ ⲚⲦⲈⲠⲒⲤⲞϪⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲦⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲈ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲠⲀⲒⲤⲞϪⲈⲚ ⲘⲠⲞⲨⲦⲎⲒϤ ⲈⲂⲞⲖ ϦⲀ ⲦⲚⲤⲀⲐⲈⲢⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲦⲎⲒⲦⲞⲨ ⲚⲚⲒϨⲎⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ⲪⲀⲒ ⲆⲈ ⲀϤϪⲞϤ ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲤⲈⲢⲘⲈⲖⲒⲚ ⲚⲀϤ ϦⲀ ⲚⲒϨⲎⲔⲒ ⲀⲖⲖⲀ ϪⲈ ⲚⲈⲞⲨⲢⲈϤϬ ⲒⲞⲨⲒ ⲠⲈ ⲞⲨⲞϨ ⲈⲢⲈ ⲠⲒⲄⲖⲰⲤⲞⲔⲞⲘⲞⲚ ⲚⲦⲞⲦϤ ⲚⲎ ⲈϢⲀϤϨⲒⲦⲞⲨ ⲈⲢⲞϤ ⲚⲈϢⲀϤⲦⲰⲞⲨⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ϪⲈ ⲬⲀⲤ ϨⲒⲚⲀ ⲚⲦⲈⲤⲀⲢⲈϨ ⲈⲢⲞϤ ⲈⲠⲈϨⲞⲞⲨ ⲘⲠⲀⲔⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ⲚⲒϨⲎⲔⲒ ⲄⲀⲢ ⲤⲈⲚⲈⲘⲰⲦⲈⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲀⲚⲞⲔ ⲆⲈ ϮⲚⲈⲘⲰⲦⲈⲚ ⲀⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ⲀⲨⲈⲘⲒ ⲆⲈ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ϤⲬⲎ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲐⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲀⲖⲖⲀ ⲚⲈⲘ ⲈⲐⲂⲈ ⲠⲔⲈⲖⲀⲌⲀⲢⲞⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲚⲀⲨ ⲈⲢⲞϤ ⲪⲎ ⲈⲦⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ⲀⲨⲈⲢⲞⲨⲤⲞϬⲚⲒ ⲆⲈ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ϨⲒⲚⲀ ⲚⲤⲈϦⲰⲦⲈⲂ ⲘⲠⲔⲈⲖⲀⲌⲀⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ϪⲈ ⲈⲐⲂⲎⲦϤ ⲚⲀⲢⲈ ⲞⲨⲘⲎϢ ϨⲎⲖ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲚⲀⲨⲚⲀϨϮ ⲠⲈ ⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲠⲒⲘⲎϢ ⲈⲦⲞϢ ⲈⲦⲀⲨⲒ ⲈⲠϢⲀⲒ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲎⲞⲨ ⲈϨⲢⲎⲒ ⲈⲒⲖⲎⲘ ");
INSERT INTO copbhc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ⲀⲨϬⲒ ⲚϨⲀⲚⲂⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲂⲈⲚⲒ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀϤ ⲞⲨⲞϨ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲰⲤⲀⲚⲚⲀ ϤⲤⲘⲀⲢⲰⲞⲨⲦ ⲚϪⲈⲪⲎ ⲈⲐⲚⲎⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲠⲞⲨⲢⲞ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤϪⲒⲘⲒ ⲚⲞⲨⲈⲰ ⲀϤⲀⲖⲎⲒ ⲈⲢⲞϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲦϢⲈⲢⲒ ⲚⲤⲒⲰⲚ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲈⲞⲨⲢⲞ ϤⲚⲎⲞⲨ ⲈϤⲦⲀⲖⲎⲞⲨⲦ ⲈⲞⲨⲤⲎ ϪⲠϢⲎⲢⲒ ⲚⲞⲨⲈⲰ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ⲚⲀⲒ ⲆⲈ ⲘⲠⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲘⲒ ⲈⲢⲰⲞⲨ ⲚϢⲞⲢⲠ ⲀⲖⲖⲀ ϨⲞⲦⲈ ⲈⲦⲀϤϬⲒⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲦⲞⲦⲈ ⲀⲨⲈⲢⲪⲘⲈⲨⲒ ϪⲈ ⲚⲀⲒ ⲚⲈⲈⲦⲀⲨⲀⲒⲦⲞⲨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ⲚⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲞⲨⲚ ⲠⲈ ⲚϪⲈⲠⲒⲘⲎϢ ⲈⲚⲀϤⲚⲈⲘⲀϤ ϪⲈ ⲀϤⲘⲞⲨϮ ⲈⲖⲀⲌⲀⲢⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ⲈⲐⲂⲈⲪⲀⲒ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ ⲠⲈ ⲚϪⲈⲠⲒⲘⲎϢ ϪⲈ ⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ⲀϤⲈⲢ ⲠⲀⲒⲘⲎⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ⲠⲈϪⲈ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲞⲨⲚ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲦⲈⲚⲚⲀⲨ ϪⲈ ⲦⲈⲚⲚⲀϪⲈⲘϨⲎⲞⲨ ⲚϨⲖⲒ ⲀⲚ ⲒⲤ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ⲀϤϢⲈ ⲚⲀϤ ⲤⲀⲘⲈⲚϨⲎϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲈⲒⲚⲒⲚ ⲆⲈ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲈϨⲢⲎⲒ ⲈⲠϢⲀⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲞⲨⲰϢⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ⲚⲀⲒ ⲞⲨⲚ ⲚⲀⲨⲒ ϨⲀ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲒⲢⲈⲘⲂⲎ ⲐⲤⲀⲒⲆⲀ ⲚⲦⲈϮⲄⲀⲖⲒⲖⲈⲀ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲚϬⲞⲒⲤ ⲦⲈⲚⲞⲨⲰϢ ⲈⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ⲀϤⲒ ⲚϪⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲀϤϪⲞⲤ ⲚⲀⲚⲆⲢⲈⲀⲤ ⲀⲚⲆⲢⲈⲀⲤ ⲞⲚ ⲚⲈⲘ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲀⲨⲒ ⲀⲨϪⲞⲤ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲤⲒ ⲚϪⲈϮⲞⲨⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ϬⲒⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲢⲈϢⲦⲈⲘ ϮⲚⲀⲪⲢⲒ ⲚⲤⲞⲨⲞ ϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲞⲨⲞϨ ⲚⲦⲈⲤⲘⲞⲨ ⲚⲐⲞⲤ ⲘⲘⲀⲨⲀⲦⲤ ⲈϢⲀⲤϢⲰⲠⲒ ⲈϢⲰⲠ ⲆⲈ ⲀⲤϢⲀⲚⲘⲞⲨ ϢⲀⲤⲈⲚ ⲞⲨⲘⲎϢ ⲚⲞⲨⲦⲀϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ⲪⲎ ⲈⲐⲘⲈⲒ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϤⲈⲦⲀⲔⲞⲤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲘⲞⲤϮ ⲚⲦⲈϤⲮⲨⲬⲎ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲈϤⲈⲀⲢⲈϨ ⲈⲢⲞⲤ ⲈⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ⲪⲎ ⲈⲐⲚⲀϢⲈⲘϢⲒ ⲘⲘⲞⲒ ⲘⲀⲢⲈϤⲞⲨⲀϨϤ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲪⲘⲀ ⲈϮϢⲞⲠ ⲘⲘⲞϤ ⲈϤⲈϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚⲈⲘⲎⲒ ⲚϪⲈⲠⲀⲢⲈϤϢⲈⲘϢⲒ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲈⲢⲢⲈϤϢⲈⲘϢⲒ ⲚⲎⲒ ϤⲚⲀⲈⲢⲦⲒⲘⲀⲚ ⲘⲘⲞϤ ⲚϪⲈⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ϮⲚⲞⲨ ⲀⲦⲀⲮⲨⲬⲎ ϢⲐⲞⲢⲦⲈⲢ ⲞⲨⲞϨ ⲞⲨ ⲠⲈϮⲚⲀϪⲞϤ ⲠⲀⲒⲰⲦ ⲚⲀϨⲘⲈⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲒⲞⲨⲚⲞⲨ ⲀⲖⲖⲀ ⲈⲐⲂⲈⲪⲀⲒ ⲀⲒⲒ ⲈⲦⲀⲒⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ⲪⲒⲰⲦ ⲘⲀⲰⲞⲨ ⲘⲠⲈⲔϢⲎⲢⲒ ⲞⲨⲤⲘⲎ ⲀⲤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒϮⲰⲞⲨ ⲠⲀⲖⲒⲚ ⲞⲚ ϮⲚⲀϮⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ⲠⲒⲘⲎϢ ⲞⲨⲚ ⲈⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨϦⲀⲢⲀⲂⲀⲒ ⲠⲈⲦⲀⲤϢⲰⲠⲒ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲠⲈⲦⲀϤⲤⲀϪⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲈⲦⲀⲤϢⲰⲠⲒ ⲀⲚ ⲈⲐⲂⲎⲦ ⲚϪⲈⲦⲀⲒⲤⲘⲎ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ϮⲚⲞⲨ ⲠϨⲀⲠ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ϮⲚⲞⲨ ⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲈⲨⲈϨⲒⲦϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲀⲒϢⲀⲚϬⲒⲤⲒ ⲈⲂⲞⲖ ϨⲀ ⲠⲔⲀϨⲒ ⲈⲒⲈⲤⲈⲔ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ⲪⲀⲒ ⲆⲈ ⲚⲀϤϪⲰ ⲘⲘⲞϤ ⲈϤϮⲘⲎⲒⲚⲒ ϪⲈ ϦⲈⲚⲀϢ ⲘⲘⲞⲨ ϤⲚⲀⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲠⲒⲘⲎϢ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲰⲦⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ϢⲞⲠ ϢⲀ ⲈⲚⲈϨ ⲞⲨⲞϨ ⲠⲰⲤ ⲔϪⲰ ⲘⲘⲞⲤ ⲚⲐⲞⲔ ϪⲈ ϨⲰϮ ⲠⲈ ⲚⲦⲞⲨϬⲈⲤ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲚⲒⲘ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲈⲦⲒ ⲔⲈⲔⲞⲨϪⲒ ⲚⲤⲎ ⲞⲨ ⲠⲒⲞⲨⲰⲒⲚⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲘⲞϢⲒ ⲞⲨⲚ ϦⲈⲚⲠⲒⲞⲨⲰⲒⲚⲒ ϨⲰⲤ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲒⲬⲀⲔⲒ ⲦⲀϨⲈ ⲐⲎⲚⲞⲨ ϪⲈ ⲪⲎ ⲈⲐⲘⲞϢⲒ ϦⲈⲚⲠⲒⲬⲀⲔⲒ ϤⲈⲘⲒ ⲀⲚ ϪⲈ ⲀϤⲘⲞϢⲒ ⲈⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ϨⲰⲤ ⲠⲒⲞⲨⲰⲒⲚⲒ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲞϢⲒ ϦⲈⲚⲠⲒⲞⲨⲰⲒⲚⲒ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲢϢⲎⲢⲒ ⲘⲠⲒⲞⲨⲰⲒⲚⲒ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϢⲈ ⲚⲀϤ ⲀϤⲬⲞⲠϤ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ⲚⲀⲒⲘⲎϢ ⲆⲈ ⲘⲘⲎⲒⲚⲒ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲘⲠⲞⲨⲘⲐⲞ ⲘⲠⲞⲨⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲠⲤⲀϪⲒ ⲚⲎⲤⲀⲒⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲪⲎ ⲈⲦⲀϤϪⲞϤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲒⲘ ⲈⲦⲀϤⲚⲀϨϮ ⲈⲦⲈⲚⲤⲘⲎ ⲞⲨⲞϨ ⲠϢⲰⲂϢ ⲘⲠϬⲞⲒⲤ ⲈⲦⲀϤϬⲰⲢⲠ ⲈⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ⲈⲐⲂⲈⲪⲀⲒ ⲚⲈⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲚⲀϨϮ ⲠⲈ ⲞⲨⲞϨ ⲀϤϪⲞⲤ ⲞⲚ ⲚϪⲈⲎⲤⲀⲒⲀⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ϪⲈ ⲀϤⲐⲰⲘ ⲚⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲀϤⲐⲰⲘ ⲘⲠⲞⲨϨⲎⲦ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲚⲀⲨ ⲚⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲚⲦⲞⲨϢⲦⲈⲘⲔⲀϮ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲞⲨⲞϨ ⲚⲦⲞⲨⲔⲞⲦⲞⲨ ϨⲀⲢⲞⲒ ⲚⲦⲀⲦⲞⲨϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ⲚⲀⲒ ⲀϤϪⲞⲦⲞⲨ ⲚϪⲈⲎⲤⲀⲒⲀⲤ ϪⲈ ⲀϤⲚⲀⲨ ⲈⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀϤⲤⲀϪⲒ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ⲞⲘⲰⲤ ⲘⲈⲚⲦⲞⲒ ⲞⲨⲘⲎϢ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲈⲀⲢⲬⲰⲚ ⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲚⲀⲨⲞⲨⲰⲚϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲀⲚ ⲠⲈ ⲈⲐⲂⲈ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ϪⲈ ⲚⲚⲞⲨⲀⲒⲦⲞⲨ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ⲀⲨⲘⲈⲚⲢⲈ ⲠⲰⲞⲨ ⲄⲀⲢ ⲚⲚⲒⲢⲰⲘⲒ ⲘⲀⲖⲖⲞⲚ ⲈϨⲞⲦⲈ ⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲀϤⲰϢ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲀϤⲚⲀϨϮ ⲈⲢⲞⲒ ⲀⲚ ⲀⲖⲖⲀ ⲀϤⲚⲀϨϮ ⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲨ ⲈⲢⲞⲒ ⲀϤⲚⲀⲨ ⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ⲀⲚⲞⲔ ⲀⲒⲒ ⲈⲨⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲒⲚⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲚⲦⲈϤϢⲦⲈⲘⲞϨⲒ ϦⲈⲚⲠⲬⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈϤϢⲦⲈⲘⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲀⲚⲞⲔ ⲀⲚ ⲈⲐⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ⲚⲈⲦⲀⲒⲒ ⲄⲀⲢ ϨⲒⲚⲀ ⲚⲦⲀϮϨⲀⲠ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲀⲚⲞϨⲈⲘ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ⲪⲎ ⲈⲦϪⲰⲖ ⲘⲘⲞⲒ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲈⲚϤϬ ⲒⲚⲚⲀⲤⲀϪⲒ ⲀⲚ ⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲪⲎ ⲈⲐⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ⲠⲒⲤⲀϪⲒ ⲈⲦⲀⲒⲤⲀϪⲒ ⲘⲘⲞϤ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲐⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ϪⲈ ⲀⲚⲞⲔ ⲘⲠⲒⲤⲀϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚⲐⲞϤ ⲠⲈⲦⲀϤϮ ⲈⲚⲦⲞⲖⲎ ⲚⲎⲒ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀϪⲞϤ ⲒⲈ ⲞⲨ ⲠⲈϮⲚⲀⲤⲀϪⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ⲞⲨⲞϨ ϮⲈⲘⲒ ϪⲈ ⲦⲈϤⲈⲚⲦⲞⲖⲎ ⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ⲦⲈ ⲚⲎ ⲞⲨⲚ ⲀⲚⲞⲔ ⲈϮϪⲰ ⲘⲘⲰⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϪⲞⲤ ⲚⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲠⲀⲒⲢⲎϮ ϮⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ϦⲀϪⲈⲚ ⲠϢⲀⲒ ⲆⲈ ⲚⲦⲈⲠⲒⲠⲀⲤⲬⲀ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲤⲒ ⲚϪⲈⲦⲈϤⲞⲨⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲈϤⲚⲀϢⲈ ⲚⲀϤ ϨⲀ ⲪⲒⲰⲦ ⲈⲀϤⲘⲈⲚⲢⲈ ⲚⲎ ⲈⲦⲈⲚⲞⲨϤ ⲈⲦϦⲈⲚ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲀϤⲘⲈⲚⲢⲒⲦⲞⲨ ϢⲀ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ⲞⲨⲞϨ ⲈⲦⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲆⲒⲠⲚⲞⲚ ⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ϨⲎⲆⲎ ⲚⲈⲀϤⲞⲨⲰ ⲈϤϨⲒⲞⲨⲒ ⲈⲠϨⲎ ⲦⲘⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ ⲈⲦⲈ ⲒⲞⲨⲆⲀⲤ ⲠⲈ ⲤⲒⲘⲰⲚ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲪⲒⲰⲦ - ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈϦⲢⲎⲒ ⲈⲚⲈϤϪⲒϪ ⲞⲨⲞϨ ϪⲈ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀϤⲚⲀϢⲈ ⲚⲀϤ ϨⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲆⲒⲠⲚⲞⲚ ⲀϤⲬⲰ ⲚⲚⲈϤϨⲂⲰⲤ ⲈϦⲢⲎⲒ ⲞⲨⲞϨ ⲀϤϬⲒ ⲚⲞⲨⲖⲈⲚⲦⲒⲞⲚ ⲀϤⲘⲞⲢϤ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ⲞⲨⲞϨ ⲀϤϨⲒⲞⲨⲒ ⲚⲞⲨⲘⲰⲞⲨ ⲈⲞⲨⲖⲀⲔⲀⲚⲎ ⲞⲨⲞϨ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲒⲰⲒ ⲚⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲈϤϤⲰϮ ⲘⲘⲰⲞⲨ ⲘⲠⲒⲖⲈⲚⲦⲒⲞⲚ ⲈⲚⲀϤⲘⲎⲢ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ⲀϤⲒ ⲞⲨⲚ ϨⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϤⲚⲀⲒⲀ ⲢⲀⲦϤ ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲐⲞⲔ ⲈⲐⲚⲀⲒⲀ ⲢⲀⲦ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲪⲎ ⲈϮⲢⲀ ⲘⲘⲞϤ ⲚⲐⲞⲔ ⲔⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ϮⲚⲞⲨ ⲈⲔⲈⲈⲘⲒ ⲆⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲚⲚⲈⲔⲒⲀ ⲢⲀⲦ ⲈⲂⲞⲖ ϢⲀ ⲈⲚⲈϨ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲀⲒϢⲦⲈⲘⲒⲀ ⲢⲀⲦⲔ ⲘⲘⲞⲚⲦⲈⲔ ⲦⲞⲒ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ⲠⲈϪⲈ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲀϬⲀⲖⲀⲨϪ ⲀⲖⲖⲀ ⲚⲈⲘ ⲚⲀⲔⲈϪⲒϪ ⲚⲈⲘ ⲦⲀⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲪⲎ ⲈⲦⲀϤϪⲞⲔⲈⲘ ⲚϤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲈⲂⲎⲖ ⲈⲒⲀ ⲢⲀⲦϤ ⲀⲖⲖⲀ ϤⲞⲨⲀⲂ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞⲨⲀⲂ ⲀⲖⲖⲀ ⲦⲎⲢⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ⲚⲀϤⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲘⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲦⲈⲚⲞⲨⲀⲂ ⲦⲎⲢⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲒⲰⲒ ⲚⲚⲞⲨϬⲀⲖⲀⲨϪ ⲀϤϬⲒ ⲚⲚⲈϤϨⲂⲰⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲢⲞⲐⲂⲈϤ ⲞⲚ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈⲦⲀⲒⲀⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲘⲞⲨϮ ⲈⲢⲞⲒ ϪⲈ ⲪⲢⲈϤϮ ⲤⲂⲰ ⲞⲨⲞϨ ⲠⲈⲚϬⲞⲒⲤ ⲔⲀⲖⲰⲤ ⲦⲈⲦⲈⲚϪⲰ ⲘⲘⲞⲤ ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ⲒⲤϪⲈ ⲞⲨⲚ ⲀⲚⲞⲔ ⲀⲒⲒⲰⲒ ⲚⲚⲈⲦⲈⲚϬⲀⲖⲀⲨϪ ⲈⲂⲞⲖ ⲠⲈⲦⲈⲚϬⲞⲒⲤ ⲞⲨⲞϨ ⲠⲈⲦⲈⲚⲢⲈϤϮⲤⲂⲰ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲤⲈⲘⲠϢⲀ ⲚⲦⲈⲦⲈⲚⲒⲀ ⲢⲀⲦⲞⲨ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ⲞⲨⲤⲘⲞⲦ ⲄⲀⲢ ⲠⲈⲦⲀⲒⲀⲒϤ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲀⲚⲞⲔ ⲈⲦⲀⲒⲀⲒⲤ ⲚⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲀⲒⲤ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲂⲰⲔ ⲈϤⲞⲒ ⲚⲚⲒϢϮ ⲈⲠⲈϤϬⲞⲒⲤ ⲞⲨⲆⲈ ⲞⲨⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈϤⲞⲒ ⲚⲚⲒϢϮ ⲈⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ⲒⲤϪⲈ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲈⲚⲀⲒ ⲰⲞⲨⲚⲒⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲀⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ⲚⲀⲒϪⲰ ⲘⲘⲞⲤ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲚ ϮⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲀⲚⲞⲔ ⲚⲚⲎ ⲈⲦⲀⲒⲤⲞⲦⲠⲞⲨ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲪⲎ ⲈⲐⲞⲨⲰⲘ ⲘⲠⲀⲰⲒⲔ ⲚⲈⲘⲎⲒ ⲀϤⲦⲰⲞⲨⲚ ⲘⲠⲈϤⲐⲒⲂⲤ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲘⲠⲀⲦⲈⲤϢⲰⲠⲒ ϨⲒⲚⲀ ⲀⲤϢⲀⲚϢⲰⲠⲒ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲦϢⲰⲠ ⲘⲪⲎ ⲈϮⲚⲀⲞⲨⲞⲢⲠϤ ⲀϤϢⲰⲠ ⲘⲘⲞⲒ ⲪⲎ ⲆⲈ ⲈⲦϢⲰⲠ ⲘⲘⲞⲒ ⲀϤϢⲰⲠ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϢⲐⲞⲢⲦⲈⲢ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲠⲈⲐⲚⲀⲦⲎⲒⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ⲚⲀⲨⲤⲞⲘⲤ ⲞⲨⲚ ⲠⲈ ⲈⲚⲞⲨⲈⲢⲎⲞⲨ ⲚϪⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲤⲈⲈⲘⲒ ⲀⲚ ϪⲈ ⲀϤϪⲪⲈ ⲈⲢⲈ ⲚⲒⲘ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ⲚⲀϤⲢⲞⲦⲈⲂ ⲆⲈ ⲠⲈ ⲚϪⲈⲞⲨⲀⲒ ϦⲈⲚⲔⲈⲚϤ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲪⲎ ⲈⲚⲀⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈⲒ ⲘⲘⲞϤ ");
INSERT INTO copbhc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ⲀϤϬⲰⲢⲈⲘ ⲞⲨⲚ ⲈⲪⲀⲒ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲈⲚϤ ϪⲈ ⲀϤϪⲈ ⲈⲢⲈ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲦⲀϤⲞⲨⲀϨϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲘⲈⲤⲦⲈⲚϨⲎⲦ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲚⲒⲘ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲎ ⲀⲚⲞⲔ ⲈϮⲚⲀⲤⲈⲠ ⲠⲒⲖⲰⲘ ⲚⲦⲀⲦⲎⲒϤ ⲚⲀϤ ⲚⲐⲞϤ ⲠⲈ ⲞⲨⲞϨ ⲈⲦⲀϤⲤⲈⲠ ⲠⲒⲖⲰⲘ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲚⲒⲞⲨⲆⲀⲤ ⲤⲒⲘⲰⲚ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲖⲰⲘ ⲀϤϢⲈ ⲚⲀϤ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲚϪⲈⲠⲤⲀⲦⲀⲚⲀⲤ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲚⲀϤ ϪⲈ ⲪⲎ ⲈⲦⲈⲔⲚⲀⲀⲒϤ ⲀⲢⲒⲦϤ ⲚⲬⲰⲖⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ⲠⲀⲒⲤⲀϪⲒ ⲆⲈ ⲘⲠⲈ ϨⲖⲒ ⲈⲘⲒ ⲈⲢⲞϤ ϦⲈⲚⲚⲎ ⲈⲐⲢⲞⲦⲈⲂ ϪⲈ ⲈⲦⲀϤϪⲞⲤ ⲚⲀϤ ⲈⲐⲂⲈⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲚⲀⲨⲘⲈⲨⲒ ⲠⲈ ϪⲈ ⲈⲠⲒⲆⲎ ⲚⲀⲢⲈ ⲠⲒⲄⲖⲰⲤⲞⲔⲞⲘⲞⲚ ⲚⲦⲞⲦϤ ⲚⲒⲞⲨⲆⲀⲤ ϪⲈ ⲀⲢⲎⲞⲨ ⲈⲢⲈ ⲒⲎⲤⲞⲨⲤ ϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ϢⲰⲠ ⲘⲪⲎ ⲈⲦⲈⲚⲚⲀⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ ⲈⲠϢⲀⲒ ⲒⲈ ϪⲈ ϨⲒⲚⲀ ⲚⲦⲈϤϮ ⲚⲞⲨⲈⲚⲬⲀⲒ ⲚⲚⲒϨⲎⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ⲈⲦⲀϤϬⲒ ⲞⲨⲚ ⲘⲠⲒⲖⲰⲘ ⲚϪⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲒ ⲈⲂⲞⲖ ⲤⲀⲦⲞⲦϤ ⲚⲈⲈϪⲰⲢϨ ⲆⲈ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ϪⲈ ϮⲚⲞⲨ ⲀϤϬⲒⲰⲞⲨ ⲚϪⲈⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲞⲨⲞϨ ⲀⲪⲚⲞⲨϮ ϬⲒⲰⲞⲨ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ⲒⲤϪⲈ ⲀⲪⲚⲞⲨϮ ϬⲒⲰⲞⲨ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲪⲚⲞⲨϮ ⲚⲀϮⲰⲞⲨ ⲚⲀϤ ⲚϨⲢⲎⲒ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲈϤⲈϮⲰⲞⲨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ⲚⲀϢⲎⲢⲒ ⲈⲦⲒ ⲔⲈⲔⲞⲨϪⲒ ϮⲬⲎ ⲚⲈⲘⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲈⲔⲰϮ ⲚⲤⲰⲒ ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲒϪⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ⲠⲒⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲚⲦⲈⲦⲈⲚⲚⲀϢⲒ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲞϨ ϮⲚⲞⲨ ϨⲰⲦⲈⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ⲞⲨⲈⲚⲦⲞⲖⲎ ⲘⲂⲈⲢⲒ ⲈϮϮ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲒⲘⲈⲚⲢⲈ ⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ⲚϨⲢⲎⲒ ϦⲈⲚⲪⲀⲒ ⲤⲈⲚⲀⲈⲘⲒ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲀⲘⲀⲐⲎⲦⲎⲤ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲀⲔⲚⲀϢⲈ ⲚⲀⲔ ⲈⲐⲰⲚ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲒⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲘⲞϢⲒ ⲚⲤⲰⲒ ϮⲚⲞⲨ ⲈⲠϦⲀⲈ ⲆⲈ ⲈⲔⲈⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲘⲞϢⲒ ⲚⲤⲰⲔ ϮⲚⲞⲨ ⲦⲀⲮⲨⲬⲎ ϮⲚⲀⲬⲀⲤ ⲈϨⲢⲎⲒ ⲈϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲈⲔⲮⲨⲬⲎ ⲬⲚⲀⲬⲀⲤ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲚⲚⲈ ⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ ϢⲀⲦⲈⲔϪⲞⲖⲦ ⲈⲂⲞⲖ ⲚⲄ ⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ⲘⲠⲈⲚⲐⲢⲈ ⲠⲈⲦⲈⲚϨⲎⲦ ϢⲐⲞⲢⲦⲈⲢ ⲚⲀϨϮⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲀϨϮ ⲈⲢⲞⲒ ϨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲘⲘⲞⲚⲎ ϦⲈⲚⲠⲎⲒ ⲘⲠⲀⲒⲰⲦ ⲈⲚⲈⲘⲘⲞⲚ ⲚⲀⲒⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ⲠⲈ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲚⲦⲀⲤⲈⲂⲦⲈ ⲞⲨⲘⲀ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ⲞⲨⲞϨ ⲀⲒϢⲀⲚϢⲈ ⲚⲎⲒ ⲚⲦⲀⲤⲈⲂⲦⲈ ⲞⲨⲘⲀ ⲚⲰⲦⲈⲚ ⲠⲀⲖⲒⲚ ⲞⲚ ⲈⲒⲈⲒ ⲚⲦⲀⲈⲖ ⲐⲎⲚⲞⲨ ϨⲀⲢⲞⲒ ϨⲒⲚⲀ ⲘⲪⲘⲀ ⲀⲚⲞⲔ ⲈϮϢⲞⲠ ⲘⲘⲞϤ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ⲞⲨⲞϨ ⲪⲘⲀ ⲀⲚⲞⲔ ⲈϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ⲠⲈϪⲈ ⲐⲰⲘⲀⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲔⲚⲀϢⲈ ⲚⲀⲔ ⲈⲐⲰⲚ ⲞⲨⲞϨ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ ⲈⲤⲞⲨⲈⲚ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲒⲘⲰⲒⲦ ⲚⲈⲘ ϮⲘⲈⲐⲘⲎⲒ ⲚⲈⲘ ⲠⲒⲰⲚϦ ⲘⲠⲀⲢⲈ ϨⲖⲒ Ⲓ- ϨⲀ ⲪⲒⲰⲦ ⲀϤϢⲦⲈⲘⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ⲒⲤϪⲈ ⲀⲢⲈⲦⲈⲚⲤⲞⲨⲰⲚⲦ ⲈⲢⲈⲦⲈⲚⲈⲤⲞⲨⲈⲚ ⲠⲀⲔⲈⲒⲰⲦ ⲞⲨⲞϨ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ⲠⲈϪⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲘⲀⲦⲀⲘⲞⲚ ⲈⲪⲒⲰⲦ ⲞⲨⲞϨ ⲔⲎⲚ ⲈⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲠⲀⲒⲤⲎⲞⲨ ⲦⲎⲢϤ ϮⲚⲈⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲘⲠⲈⲔⲤⲞⲨⲰⲚⲦ ⲪⲒⲖⲒⲠⲠⲈ ⲪⲎ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞⲒ ⲀϤⲚⲀⲨ ⲈⲪⲒⲰⲦ ⲠⲰⲤ ⲚⲐⲞⲔ ⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀⲦⲀⲘⲞⲚ ⲈⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ⲬⲚⲀϨϮ ⲀⲚ ϪⲈ ⲀⲚⲞⲔ ϮϦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲠⲀⲒⲰⲦ ⲚϦⲎⲦ ⲚⲀⲒⲤⲀϪⲒ ⲈϮϪⲰ ⲘⲘⲰⲞⲨ ⲚⲰⲦⲈⲚ ⲚⲀⲒⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲪⲒⲰⲦ ⲈⲦϢⲞⲠ ⲚϦⲎ ⲦⲚⲐⲞϤ ⲠⲈ ⲈⲦⲒⲢⲒ ⲚⲚⲈϤϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ⲚⲀϨϮ ⲈⲢⲞⲒ ϪⲈ ⲀⲚⲞⲔ ϮϦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲠⲀⲒⲰⲦ ⲚϦⲎⲦ ⲘⲘⲞⲚ ⲔⲀⲚ ⲈⲐⲂⲈ ⲚⲒϨⲂⲎ ⲞⲨⲒ ⲚⲀϨϮ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲚⲒϨⲂⲎⲞⲨⲒ ⲀⲚⲞⲔ ⲈϮⲢⲀ ⲘⲘⲰⲞⲨ ⲈϤⲈⲀⲒⲦⲞⲨ ϨⲰϤ ⲞⲨⲞϨ ϨⲀⲚⲚⲒϢϮ ⲈⲚⲀⲒ ⲈϤⲈⲀⲒⲦⲞⲨ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ϦⲈⲚⲠⲀⲢⲀⲚ ⲈⲒⲈⲀⲒϤ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈϤϬⲒⲰⲞⲨ ⲚϪⲈⲪⲒⲰⲦ ϦⲈⲚⲠϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ϦⲈⲚⲠⲀⲢⲀⲚ ⲪⲀⲒ ϮⲚⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ⲈϢⲰⲠ ⲦⲈⲦⲈⲚⲘⲈⲒ ⲘⲘⲞⲒ ⲦⲈⲦⲈⲚⲚⲀⲀⲢⲈϨ ⲈⲚⲀⲈⲚⲦⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲈⲐⲚⲀϮϨⲞ ⲈⲪⲒⲰⲦ ⲞⲨⲞϨ ⲈϤⲈϮ ⲚⲰⲦⲈⲚ ⲘⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲰⲠⲒ ⲚⲈⲘⲰⲦⲈⲚ ϢⲀ ⲈⲚⲈϨ ");
INSERT INTO copbhc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲪⲎ ⲈⲦⲈⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲈϢⲞⲠϤ ϪⲈ ϤⲚⲀⲨ ⲈⲢⲞϤ ⲀⲚ ⲞⲨⲆⲈ ϤⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ϪⲈ ⲀϤϢⲞⲠ ⲚⲈⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲈϤⲈϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ⲚⲚⲀⲬⲀ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲞⲢⲪⲀⲚⲞⲤ ϮⲚⲎⲞⲨ ϨⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ⲈⲦⲒ ⲔⲈⲔⲞⲨϪⲒ ⲞⲨⲞϨ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞⲒ ϪⲈ ⲀⲚⲞⲔ ϮⲞⲚϦ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲈⲦⲈⲚⲈⲈⲘⲒ ⲚⲐⲰⲦⲈⲚ ϪⲈ ⲀⲚⲞⲔ ϮϦⲈⲚ ⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲚϨⲢⲎⲒ ⲚϦⲎⲦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ⲪⲎ ⲈⲦⲈ ⲚⲀⲈⲚⲦⲞⲖⲎ ⲚⲦⲞⲦϤ ⲞⲨⲞϨ ⲈⲦⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲐⲘⲈⲒ ⲘⲘⲞⲒ ⲪⲎ ⲆⲈ ⲈⲐⲘⲈⲒ ⲘⲘⲞⲒ ⲈϤⲈⲘⲈⲚⲢⲒⲦϤ ⲚϪⲈⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲈⲒⲈⲘⲈⲚⲢⲒⲦϤ ⲞⲨⲞϨ ⲈⲒⲈⲞⲨⲞⲚϨⲦ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ⲠⲈϪⲈ ⲒⲞⲨⲆⲀⲤ ⲚⲀϤ ⲠⲒⲤⲔⲀⲢⲒⲰⲦⲎⲤ ⲀⲚ ϪⲈ ⲠϬⲞⲒⲤ ⲞⲨ ⲠⲈⲦⲀϤϢⲰⲠⲒ ϪⲈ ⲬⲚⲀⲞⲨⲞⲚϨⲔ ⲈⲢⲞⲚ ⲀⲚⲞⲚ ⲞⲨⲞϨ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲐⲞϤ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲪⲎ ⲈⲐⲘⲈⲒ ⲘⲘⲞⲒ ⲈϤⲈⲀⲢⲈϨ ⲈⲠⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲈϤⲈⲘⲈⲚⲢⲒⲦϤ ⲚϪⲈⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲈⲚⲈⲒ ϨⲀⲢⲞϤ ⲞⲨⲞϨ ⲈⲚⲈⲐⲀⲘⲒⲞ ⲘⲠⲈⲚⲘⲀⲚϢⲰⲠⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ⲪⲎ ⲈⲦⲈⲚϤⲘⲈⲒ ⲘⲘⲞⲒ ⲀⲚ ϤⲚⲀⲀⲢⲈϨ ⲀⲚ ⲈⲚⲀⲤⲀϪⲒ ⲞⲨⲞϨ ⲠⲒⲤⲀϪⲒ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲪⲰⲒ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲪⲒⲰⲦ ⲠⲈ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ⲚⲀⲒ ⲆⲈ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲈⲒϢⲞⲠ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲒⲠⲀⲢⲀⲔⲖⲎ ⲦⲞⲤ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲪⲎ ⲈⲦⲈ ⲪⲒⲰⲦ ⲚⲀⲞⲨⲞⲢⲠϤ ϦⲈⲚⲠⲀⲢⲀⲚ ⲚⲐⲞϤ ⲈⲐⲚⲀⲦⲤⲀⲂⲈ ⲐⲎⲚⲞⲨ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ϤⲚⲀϮ ⲘⲪⲘⲈⲨⲒ ⲚⲰⲦⲈⲚ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ϮⲚⲀⲬⲰ ⲚⲦⲀϨⲒⲢⲎⲚⲎ ⲚⲰⲦⲈⲚ ⲦⲀϨⲒⲢⲎ ⲚⲎ ⲀⲚⲞⲔ ϮⲚⲀⲦⲎⲒⲤ ⲚⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲀⲚ ⲈⲦⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ϮⲘⲘⲞⲤ ⲈϮⲚⲀϮ ⲘⲠⲈⲚⲐⲢⲈϤϢⲐⲞⲢⲦⲈⲢ ⲚϪⲈⲠⲈⲦⲈⲚϨⲎⲦ ⲞⲨⲆⲈ ⲘⲠⲈⲢⲈⲢϢⲖⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲚ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲞⲨⲞϨ ϮⲚⲎⲞⲨ ϨⲀⲢⲰⲦⲈⲚ ⲈⲚⲀⲢⲈⲦⲈⲚⲘⲈⲒ ⲘⲘⲞⲒ ⲚⲀⲢⲈⲦⲈⲚⲚⲀⲢⲀϢⲒ ⲠⲈ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲒⲰⲦ ϪⲈ ⲠⲀⲒⲰⲦ ⲞⲨⲚⲒϢϮ ⲈⲢⲞⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ⲘⲠⲀⲦⲈⲤϢⲰⲠⲒ ϨⲒⲚⲀ ⲀⲤϢⲀⲚϢⲰⲠⲒ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ⲚϮⲚⲀϪⲈ ⲞⲨⲘⲎϢ ⲚⲤⲀϪⲒ ⲚⲰⲦⲈⲚ ⲀⲚ ϪⲈ ϤⲚⲎⲞⲨ ⲄⲀⲢ ⲚϪⲈⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲦⲀϤ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲘⲒ ⲚϪⲈⲠⲒⲔⲞⲤⲘⲞⲤ ϪⲈ ϮⲈⲢⲀⲄⲀⲠⲀⲚ ⲘⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϨⲞⲚϨⲈⲚ ⲚⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ϮⲒⲢⲒ ⲘⲠⲀⲒⲢⲎϮ ⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲘⲀⲢⲞⲚ ⲈⲂⲞⲖ ⲦⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ⲀⲚⲞⲔ ⲠⲈ ϮⲂⲰ ⲚⲀⲖⲞⲖⲒ ⲚⲦⲀⲪⲘⲎⲒ ⲞⲨⲞϨ ⲠⲀⲒⲰⲦ ⲠⲈ ⲠⲒⲞⲨⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ⲔⲖⲎⲘⲀ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲚϦⲎⲦ ⲈⲦⲈⲚϤⲚⲀⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ⲀⲚ ϤⲚⲀⲔⲞⲢϪϤ ⲞⲨⲞϨ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲈⲚ ⲞⲨⲦⲀϨ ϤⲚⲀⲦⲞⲨⲂⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲚ ϨⲞⲨⲞ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ϨⲎⲆⲎ ⲚⲐⲰⲦⲈⲚ ⲀⲦⲈⲦⲈⲚⲦⲞⲨⲂⲞ ⲈⲐⲂⲈ ⲠⲀⲒⲤⲀϪⲒ ⲈⲦⲀⲒⲤⲀϪⲒ ⲘⲘⲞϤ ⲚⲈⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ϦⲈⲚⲐⲎⲚⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲘⲠⲒⲔⲖⲎⲘⲀ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϤⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲘⲀⲨⲀⲦϤ ⲀϤϢⲦⲈⲘϢⲰⲠⲒ ϦⲈⲚϮⲂⲰ ⲚⲀⲖⲞⲖⲒ ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ⲀⲚⲞⲔ ⲠⲈ ϮⲂⲰ ⲚⲀⲖⲞⲖⲒ ⲚⲐⲰⲦⲈⲚ ⲚⲈⲚⲒⲔⲖⲎⲘⲀ ⲪⲎ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚϦⲎⲦ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲚϦⲎⲦϤ ⲪⲀⲒ ⲈϤⲈⲈⲚ ⲞⲨⲘⲎϢ ⲚⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ϪⲈ ⲀⲦϬⲚⲞⲨⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲈⲢ ϨⲖⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ⲀⲢⲈϢⲦⲈⲘ ⲞⲨⲀⲒ ϢⲰⲠⲒ ⲚϦⲎⲦ ⲤⲈⲚⲀϨⲒⲦϤ ⲈⲂⲞⲖ ⲘⲪⲢⲎϮ ⲘⲠⲒⲔⲖⲎⲘⲀ ⲞⲨⲞϨ ϢⲀϤϢⲰⲞⲨⲒ ⲞⲨⲞϨ ϢⲀⲨⲐⲞⲨⲰⲦⲞⲨ ⲚⲤⲈϨⲒⲦⲞⲨ ⲈⲠⲒⲬⲢⲰⲘ ⲞⲨⲞϨ ϢⲀⲨⲢⲰⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈⲦⲈⲚϢⲀⲚϢⲰⲠⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲞⲨⲞϨ ⲚⲦⲈⲚⲀⲤⲀϪⲒ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲞⲨⲀϢϤ ⲀⲢⲒⲈⲦⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ϤⲚⲀϢⲰⲠⲒ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ϦⲈⲚ ⲪⲀⲒ ⲀϤϬⲒⲰⲞⲨ ⲚϪⲈⲠⲀⲒⲰⲦ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲚ ⲞⲨⲘⲎϢ ⲚⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲚⲎⲒ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲘⲈⲚⲢⲒⲦ ⲚϪⲈⲠⲀⲒⲰⲦ ⲀⲚⲞⲔ ϨⲰ ⲀⲒⲘⲈⲚⲢⲈ ⲐⲎⲚⲞⲨ ϢⲰⲠⲒ ⲚϦⲢⲎⲒ ϦⲈⲚⲦⲀⲀⲄⲀⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ⲈϢⲰⲠ ⲚⲦⲈⲦⲈⲚⲀⲢⲈϨ ⲈⲚⲀⲈⲚⲦⲞⲖⲎ ⲦⲈⲦⲈⲚⲚⲀϢⲰⲠⲒ ϦⲈⲚⲦⲀⲀⲄⲀⲠⲎ ⲘⲪⲢⲎϮ ϨⲰ ⲈⲦⲀⲒⲀⲢⲈϨ ⲈⲚⲒⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲠⲀⲒⲰⲦ ⲞⲨⲞϨ ϮϢⲞⲠ ϦⲈⲚⲦⲈϤⲀⲄⲀⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ⲚⲀⲒ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲠⲀⲢⲀϢⲒ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈⲠⲈⲦⲈⲚⲢⲀϢⲒ ϨⲰⲦⲈⲚ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ⲐⲀⲒ ⲀⲚⲞⲔ ⲦⲈ ⲦⲀⲈⲚⲦⲞⲖⲎ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲘⲪⲢⲎϮ ⲈⲦⲀⲒⲘⲈⲚⲢⲈ ⲐⲎⲚⲞⲨ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ⲘⲘⲞⲚ ⲠⲈⲐⲚⲀⲀⲤ ⲈⲦⲀⲒⲀⲄⲀⲠⲎ ⲚⲦⲈⲚ ϨⲖⲒ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨⲀⲒ ⲬⲰ ⲚⲦⲈϤⲮⲨⲬⲎ ⲈϪⲈⲚ ⲠⲈϤϢⲪⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ⲚⲀϢⲪⲎⲢ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲈⲢ ⲚⲎ ⲈϮϨⲞⲚϨⲈⲚ ⲘⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ⲚϮⲚⲀⲘⲞⲨϮ ⲈⲢⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲂⲰⲔ ϪⲈ ⲘⲠⲀⲢⲈ ⲠⲒⲂⲰⲔ ⲈⲘⲒ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ⲠⲈϤϬⲞⲒⲤ ⲢⲀ ⲘⲘⲞϤ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲀⲒⲚⲀⲘⲞⲨϮ ⲈⲢⲰⲦⲈⲚ ϪⲈ ⲚⲀϢⲪⲎⲢ ϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲒⲤⲞⲐⲘⲞⲨ ⲚⲦⲞⲦϤ ⲘⲠⲀⲒⲰⲦ ⲀⲒⲦⲀⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲀⲢⲈⲦⲈⲚⲤⲞⲦⲠⲦ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲀⲒⲤⲈⲦⲠ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲀⲒⲬⲀ ⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲈ ⲚⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲈⲚ ⲞⲨⲦⲀϨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲈⲦⲈⲚⲞⲨⲦⲀϨ ⲚⲦⲈϤⲞϨⲒ ϨⲒⲚⲀ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲦⲞⲦϤ ⲘⲪⲒⲰⲦ ϦⲈⲚⲠⲀⲢⲀⲚ ⲚⲦⲈϤⲦⲎⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ⲚⲀⲒ ⲆⲈ ϮϨⲞⲚϨⲈⲚ ⲘⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ⲒⲤϪⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ ⲀⲢⲒⲈⲘⲒ ϪⲈ ⲀⲚⲞⲔ ⲚϢⲞⲢⲠ ⲠⲈⲦⲀϤⲘⲞⲤϮ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ⲈⲚⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀⲢⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀⲘⲈⲚⲢⲈ ⲠⲈⲦⲪⲰϤ ⲞⲦⲒ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲀⲒⲤⲈⲦⲠ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲐⲂⲈⲪⲀⲒ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲘⲞⲤϮ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ⲀⲢⲒⲪⲘⲈⲨⲒ ⲘⲠⲒⲤⲀϪⲒ ⲈⲦⲀⲒⲤⲀϪⲒ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲂⲰⲔ ⲈⲚⲀⲀϤ ⲈⲠⲈϤϬⲞⲒⲤ ⲒⲤϪⲈ ⲀⲨϬⲞϪⲒ ⲚⲤⲰⲒ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲨⲈϬⲞϪⲒ ⲚⲤⲰⲦⲈⲚ ⲒⲤϪⲈ ⲀⲨⲀⲢⲈϨ ⲈⲠⲀⲤⲀϪⲒ ⲈⲨⲈⲀⲢⲈϨ ⲈⲪⲰⲦⲈⲚ ϨⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ⲀⲖⲖⲀ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲈⲚⲀⲀⲒⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲠⲀⲢⲀⲚ ϪⲈ ⲤⲈⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ⲈⲚⲈ ⲘⲠⲒⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲦⲀⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲚⲈⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲂⲒ ⲘⲘⲀⲨ ϮⲚⲞⲨ ⲆⲈ ⲘⲘⲞⲚⲦⲞⲨ ⲖⲰⲒϪⲒ ⲘⲘⲀⲨ ⲈⲐⲂⲈ ⲠⲞⲨⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ⲪⲎ ⲈⲐⲘⲞⲤϮ ⲘⲘⲞⲒ ϤⲘⲞⲤϮ ⲘⲠⲀⲔⲈⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ⲈⲚⲈ ⲘⲠⲒⲒⲢⲒ ⲚⲚⲒϨⲂⲎⲞⲨⲒ ⲚϦⲢⲎⲒ ⲚϦⲎ ⲦⲞⲨ ⲚⲎ ⲈⲦⲈⲘⲠⲈ ⲔⲈⲞⲨⲀⲒ ⲀⲒⲦⲞⲨ ⲚⲈⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲂⲒ ⲘⲘⲀⲨ ϮⲚⲞⲨ ⲆⲈ ⲀⲨⲚⲀⲨ ⲞⲨⲞϨ ⲀⲨⲘⲈⲤⲦⲰⲒ ⲚⲈⲘ ⲠⲀⲔⲈⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲤⲀϪⲒ ⲈⲦⲤϦⲎⲞⲨⲦ ϨⲒ ⲠⲞⲨⲚⲞⲘⲞⲤ ϪⲈ ⲀⲨⲘⲈⲤⲦⲰⲒ ⲚϪⲒⲚϪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲒⲠⲀⲢⲀⲔⲖⲎⲦⲞⲤ ⲪⲎ ⲀⲚⲞⲔ ⲈϮⲚⲀⲞⲨⲞⲢⲠϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲀⲒⲰⲦ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲪⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲪⲒⲰⲦ ⲚⲐⲞϤ ⲈⲐⲚⲀⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲦⲈⲦⲈⲚⲬⲎ ⲚⲈⲘⲎⲒ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ⲚⲀⲒ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ⲀⲨϢⲀⲚⲈⲢ ⲐⲎⲚⲞⲨ ⲚⲀⲠⲞⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀⲖⲖⲀ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ϨⲒⲚⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϦⲰⲦⲈⲂ ⲘⲘⲰⲦⲈⲚ ⲚⲦⲈϤⲘⲈⲨⲒ ϪⲈ ⲀϤⲒⲚⲒ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲈϨⲢⲎⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲨⲈⲀⲒⲦⲞⲨ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲎⲒ ⲘⲠⲞⲨⲤⲞⲨⲈⲚ ⲪⲒⲰⲦ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲘⲠⲞⲨⲤⲞⲨⲰⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ⲀⲖⲖⲀ ⲚⲀⲒ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲀⲤϢⲀⲚⲒ ⲚϪⲈϮⲞⲨⲚⲞⲨ ⲚⲦⲈⲦⲈⲚⲈⲢⲠⲞⲨⲘⲈⲨⲒ ϪⲈ ⲀⲒⲞⲨⲰ ⲀⲚⲞⲔ ⲈⲒϪⲰ ⲘⲘⲰⲞⲨ ⲚⲰⲦⲈⲚ ⲚⲀⲒ ⲆⲈ ⲘⲠⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲒⲤϪⲈⲚ ϨⲎ ϪⲈ ⲚⲀⲒⲬⲎ ⲚⲈⲘⲰⲦⲈⲚ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ϮⲚⲞⲨ ⲆⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲎ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ϢⲒⲚⲒ ⲘⲘⲞⲒ ϪⲈ ⲬⲚⲀϢⲈ ⲚⲀⲔ ⲈⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ⲀⲖⲖⲀ ϪⲈ ⲀⲒϪⲈ ⲚⲀⲒ ⲚⲰⲦⲈⲚ ⲀⲠⲈⲘⲔⲀϨ ⲚϨⲎⲦ ⲘⲀϨ ⲠⲈⲦⲈⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ⲀⲖⲖⲀ ⲀⲚⲞⲔ ⲐⲘⲎⲒ ⲠⲈϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲤⲈⲢⲚⲞϤⲢⲒ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲀⲚⲞⲔ ⲚⲦⲀϢⲈ ⲚⲎⲒ ⲈϢⲰⲠ ⲄⲀⲢ ⲀⲒϢⲦⲈⲘϢⲈ ⲚⲎⲒ ⲠⲒⲠⲀⲢⲀⲔⲖⲎ ⲦⲞⲤ ⲚⲀⲒ ϨⲀⲢⲰⲦⲈⲚ ⲀⲚ ⲈϢⲰⲠ ⲆⲈ ⲀⲒϢⲀⲚϢⲈ ⲚⲎⲒ ϮⲚⲀⲞⲨⲞⲢⲠϤ ϨⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ⲞⲨⲞϨ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲈϤⲈⲤⲞϨⲒ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲐⲂⲈ ⲪⲚⲞⲂⲒ ⲚⲈⲘ ⲈⲐⲂⲈ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲚⲈⲘ ⲈⲐⲂⲈ ⲞⲨϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ⲈⲐⲂⲈ ⲪⲚⲞⲂⲒ ⲘⲈⲚ ϪⲈ ⲤⲈⲚⲀϨϮ ⲈⲢⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ⲈⲐⲂⲈ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲆⲈ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲒⲰⲦ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ ϪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ⲈⲐⲂⲈ ⲞⲨϨⲀⲠ ⲆⲈ ϪⲈ ⲠⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲀⲨⲞⲨⲰ ⲈⲨϮϨⲀⲠ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ⲞⲨⲞⲚϮ ϨⲀⲚⲔⲈⲘⲎϢ ⲈϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ⲀⲖⲖⲀ ⲦⲈⲦⲈⲚⲚⲀϢϤⲀⲒ ϦⲀⲢⲰⲞⲨ ϮⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲈϤⲈϬⲒⲘⲰⲒⲦ ⲚⲰⲦⲈⲚ ϦⲈⲚⲘⲈⲐⲘⲎⲒ ⲚⲒⲂⲈⲚ ⲀϤⲚⲀⲤⲀϪⲒ ⲄⲀⲢ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲖⲖⲀ ⲚⲎ ⲈⲦⲀϤⲚⲀⲤⲞⲐⲘⲞⲨ ⲈⲦⲈϤⲚⲀⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲚⲎⲞⲨ ⲈϤⲈⲦⲀⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲐⲚⲀϮⲰⲞⲨ ⲚⲎⲒ ϪⲈ ⲀϤⲚⲀϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲪⲰⲒ ⲞⲨⲞϨ ϤⲚⲀⲦⲀⲘⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲈ ⲠⲀⲒⲰⲦ ⲚⲞⲨⲒ ⲚⲈⲈⲐⲂⲈⲪⲀⲒ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀϤⲚⲀϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲪⲰⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲀⲘⲈ ⲐⲎⲚⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ⲠⲈϪⲈ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎ ⲦⲎⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲠⲀⲒⲤⲀϪⲒ ⲞⲨ ⲠⲈ ⲈⲦⲈϤϪⲰ ⲘⲘⲞϤ ⲚⲀⲚ ϪⲈ ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲞⲨⲞϨ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲈϤϪⲰ ⲘⲘⲞϤ ϪⲈ ⲔⲈⲔⲞⲨϪⲒ ⲚⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ⲀϤⲈⲘⲒ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲀⲨⲞⲨⲰϢ ⲈϢⲈⲚϤ ⲠⲈ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲠⲀⲒⲤⲀϪⲒ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲚ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲔⲈⲔⲞⲨϪⲒ ⲦⲈⲦⲈⲚⲀⲚⲀⲨ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀⲢⲒⲘⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲈⲢϨⲎ ⲂⲒ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲆⲈ ⲚⲐⲞϤ ϤⲚⲀⲢⲀϢⲒ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲚⲀⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ⲀⲖⲖⲀ ⲠⲈⲦⲈⲚⲘⲔⲀϨ ⲚϨⲎⲦ ϤⲚⲀϢⲰⲠⲒ ⲚⲰⲦⲈⲚ ⲈⲨⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ϮⲤϨⲒⲘⲒ ⲀⲤϢⲀⲚⲚⲞⲨⲒ ⲈⲘⲒⲤⲒ ϢⲀⲤⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ϪⲈ ⲀⲤⲒ ⲚϪⲈⲦⲈⲤⲞⲨⲚⲞⲨ ⲈϢⲰⲠ ⲆⲈ ⲀⲤϢⲀⲚⲘⲒⲤⲒ ⲘⲠⲒϢⲎⲢⲒ ⲘⲠⲀⲤⲈⲢⲪⲘⲈⲨⲒ ⲘⲠⲒϨⲞϪϨⲈϪ ⲈⲐⲂⲈ ⲠⲒⲢⲀϢⲒ ϪⲈ ⲀⲤⲘⲈⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ϮⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲈϬ ⲒⲚⲞⲨⲘⲔⲀϨ ⲚϨⲎⲦ ⲠⲀⲖⲒⲚ ⲞⲚ ϮⲚⲀⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲢⲀϢⲒ ⲞⲨⲞϨ ⲠⲈⲦⲈⲚⲢⲀϢⲒ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲞⲖϤ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲦⲈⲦⲈⲚⲚⲀϢⲈⲚⲦ ⲈϨⲖⲒ ⲀⲚ ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲈⲦⲒⲚ ⲘⲘⲞϤ ⲚⲦⲞⲦϤ ⲘⲪⲒⲰⲦ ϦⲈⲚⲠⲀⲢⲀⲚ ⲈϤⲈⲦⲎⲒϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ϢⲀ ϮⲚⲞⲨ ⲘⲠⲀⲦⲈⲦⲈⲚⲈⲢⲈⲦⲒⲚ ⲚϨⲖⲒ ϦⲈⲚⲠⲀⲢⲀⲚ ⲀⲢⲒⲈⲦⲒⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϬⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈⲦⲈⲚⲢⲀϢⲒ ϢⲰⲠⲒ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ⲚⲀⲒ ⲆⲈ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ϦⲈⲚϨⲀⲚⲠⲀⲢⲞⲒⲘⲒⲀ ⲤⲚⲎⲞⲨ ⲆⲈ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ϨⲞⲦⲈ ⲈⲒⲚⲀⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ϦⲈⲚϨⲀⲚⲠⲀⲢⲞⲒⲘⲒⲀ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲪⲒⲰⲦ ");
INSERT INTO copbhc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲢⲈⲦⲈⲚⲈⲈⲢⲈⲦⲒⲚ ϦⲈⲚⲠⲀⲢⲀⲚ ⲞⲨⲞϨ ϮⲚⲀϪⲞⲤ ⲚⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲀⲚⲞⲔ ⲈⲐⲚⲀϮϨⲞ ⲈⲪⲒⲰⲦ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ⲚⲐⲞϤ ⲄⲀⲢ ϨⲰϤ ⲪⲒⲰⲦ ϤⲘⲈⲒ ⲘⲘⲰⲦⲈⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚⲘⲈⲚⲢⲒⲦ ⲞⲨⲞϨ ⲀⲢⲈⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ϨⲀ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ⲀⲒⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲒⲰⲦ ⲞⲨⲞϨ ⲀⲒⲒ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲠⲀⲖⲒⲚ ⲞⲚ ϮⲚⲀⲬⲰ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ϮⲚⲀϢⲈ ⲚⲎⲒ ϨⲀ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ⲠⲈϪⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲞⲨ ⲔⲤⲀϪⲒ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲞⲨⲞϨ ⲔϪⲈ ϨⲖⲒ ⲀⲚ ⲘⲠⲀⲢⲞⲒⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ϮⲚⲞⲨ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲔⲤⲰⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲔⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲈⲐⲢⲈ ⲞⲨⲀⲒ ϢⲈⲚⲔ ϦⲈⲚⲪⲀⲒ ⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲀⲔⲒ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϮⲚⲞⲨ ⲦⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ϨⲎⲠⲠⲈ ⲤⲚⲎⲞⲨ ⲚϪⲈⲞⲨⲞⲨⲚⲞⲨ ⲞⲨⲞϨ ⲀⲤⲒ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϪⲰⲢ ⲈⲂⲞⲖ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲈⲠⲈϤⲘⲀ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲬⲀⲦ ⲘⲘⲀⲨⲀⲦ ⲞⲨⲞϨ ϮⲬⲎ ⲘⲘⲀⲨⲀⲦ ⲀⲚ ϪⲈ ϤⲬⲎ ⲚⲈⲘⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ⲚⲀⲒ ⲀⲒϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲞⲨϨⲒⲢⲎⲚⲎ ϢⲰⲠⲒ ⲚⲰⲦⲈⲚ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲞⲨⲞⲚ ⲚⲦⲰⲦⲈⲚ ⲘⲘⲀⲨ ⲚⲞⲨϨⲞϪϨⲈϪ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϪⲈⲘⲚⲞⲘϮ ⲀⲚⲞⲔ ⲀⲒϬⲢⲞ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ⲚⲀⲒ ⲀϤⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲦⲀϤϤⲀⲒ ⲚⲚⲈϤⲂⲀⲖ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀⲒⲰⲦ ⲘⲀⲰⲞⲨ ⲘⲠⲈⲔϢⲎⲢⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈⲔϢⲎⲢⲒ ϮⲰⲞⲨ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ⲘⲪⲢⲎϮ ⲈⲦⲀⲔϮ ⲈⲢϢⲒϢⲒ ⲚⲀϤ ⲈϪⲈⲚ ⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ϨⲒⲚⲀ ⲪⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲔⲦⲎⲒϤ ⲚⲀϤ ⲚⲦⲈϤϮ ⲚⲰⲞⲨ ⲚⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ⲪⲀⲒ ⲆⲈ ⲠⲈ ⲠⲒⲰⲚϦ ⲚⲈⲚⲈϨ ϨⲒⲚⲀ ⲚⲦⲞⲨⲤⲞⲨⲰⲚⲔ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲀⲨⲀⲦϤ ⲪⲚⲞⲨϮ ⲚⲦⲀⲪⲘⲎ ⲒⲚⲈⲘ ⲪⲎ ⲈⲦⲀⲔⲞⲨⲞⲢⲠϤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ⲀⲚⲞⲔ ⲀⲒϮⲰⲞⲨ ⲚⲀⲔ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈⲦⲀⲒϪⲰⲔ ⲈⲂⲞⲖ ⲘⲠⲒϨⲰⲂ ⲈⲦⲀⲔⲦⲎⲒϤ ⲚⲎⲒ ϪⲈ ⲚⲦⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲘⲀⲰⲞⲨ ⲚⲎⲒ ⲚⲐⲞⲔ ⲠⲀⲒⲰⲦ ϦⲀⲦⲞⲦⲔ ϦⲈⲚⲠⲒⲰⲞⲨ ⲈⲚⲀϤⲚⲦⲎⲒ ⲚϢⲞⲢⲠ ⲘⲠⲀⲦⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ϢⲰⲠⲒ ϦⲀⲦⲞⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ⲀⲒⲞⲨⲰⲚϨ ⲘⲠⲈⲔⲢⲀⲚ ⲈⲂⲞⲖ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲎ ⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲞⲨⲔ ⲚⲈⲞⲨⲞϨ ⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲞⲨⲞϨ ⲠⲈⲔⲤⲀϪⲒ ⲀⲨⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲀⲨⲈⲘⲒ ϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ϨⲀⲚⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ⲚⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ϪⲈ ⲚⲒⲤⲀϪⲒ ⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲀⲒⲦⲎⲒⲦⲞⲨ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲀⲨϬⲒⲦⲞⲨ ⲞⲨⲞϨ ⲀⲨⲈⲘⲒ ⲦⲀⲪⲘⲎⲒ ϪⲈ ⲈⲦⲀⲒⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ⲞⲨⲞϨ ⲀⲨⲚⲀϨϮ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ⲀⲚⲞⲔ ϮⲦⲰⲂϨ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚⲀⲒⲦⲰⲂϨ ⲀⲚ ⲈⲐⲂⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲚⲎ ⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ϪⲈ ⲚⲞⲨⲔ ⲚⲈ ");
INSERT INTO copbhc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲚⲞⲨⲒ ⲚⲞⲨⲔ ⲚⲈⲞⲨⲞϨ ⲀⲒϬⲒⲰⲞⲨ ⲚϨⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ⲞⲨⲞϨ ϮⲬⲎ ⲀⲚ ϪⲈ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀⲒ ⲆⲈ ⲚⲐⲰⲞⲨ ⲤⲈⲬⲎ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϮⲚⲎⲞⲨ ϨⲀⲢⲞⲔ ⲠⲀⲒⲰⲦ ⲠⲒⲀⲄⲒⲞⲤ ⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲪⲎ ⲈⲦⲀⲔⲦⲎⲒϤ ⲚⲎⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠⲒ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ ⲘⲠⲈⲚⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ϨⲞⲦⲈ ⲀⲚⲞⲔ ⲈⲒⲬⲎ ⲚⲈⲘⲰⲞⲨ ⲚⲀⲒⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲈⲔⲢⲀⲚ ⲪⲎ ⲈⲦⲀⲔⲦⲎ ⲒϤ ⲚⲎⲒ ⲀⲒⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲘⲠⲈ ϨⲖⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲦⲀⲔⲞ ⲈⲂⲎⲖ ⲈⲠϢⲎⲢⲒ ⲚⲦⲈⲠⲦⲀⲔⲞ ϨⲒⲚⲀ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ϮⲚⲞⲨ ⲆⲈ ⲀⲒⲚⲎⲞⲨ ϨⲀⲢⲞⲔ ⲞⲨⲞϨ ⲚⲀⲒ ϮⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲠⲀⲢⲀϢⲒ ϢⲰⲠⲒ ⲈϤϪⲎⲔ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ⲀⲚⲞⲔ ⲀⲒϮ ⲚⲰⲞⲨ ⲘⲠⲈⲔⲤⲀϪⲒ ⲞⲨⲞϨ ⲀⲠⲒⲔⲞⲤⲘⲞⲤ ⲘⲈⲤⲦⲰⲞⲨ ϪⲈ ϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲚⲈⲘⲠⲀⲢⲎϮ ϨⲰ ⲈⲦⲈ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ⲚⲀⲒϮϨⲞ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈⲔⲞⲖⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈⲔⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲚⲈⲘⲠⲀⲢⲎϮ ϨⲰ ⲈⲦⲈ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ⲘⲀⲦⲞⲨⲂⲰⲞⲨ ⲚϨⲢⲎⲒ ϦⲈⲚϮⲘⲈⲐⲘⲎⲒ ⲠⲈⲦⲈⲪⲰⲔ ⲚⲤⲀϪⲒ ⲠⲈ ϮⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲔⲞⲨⲞⲢⲠⲦ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚⲞⲔ ϨⲰ ⲀⲒⲞⲨⲞⲢⲠⲞⲨ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ⲞⲨⲞϨ ϮⲦⲞⲨⲂⲞ ⲘⲘⲞⲒ ⲀⲚⲞⲔ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠⲒ ϨⲰⲞⲨ ⲈⲨⲦⲞⲨⲂⲎ ⲞⲨⲦ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ⲚⲀⲒϮϨⲞ ⲆⲈ ⲀⲚ ⲈⲐⲂⲈ ⲚⲀⲒ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲀⲖⲖⲀ ⲚⲈⲘ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲞⲨⲤⲀϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠⲒ ⲦⲎⲢⲞⲨ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲪⲒⲰⲦ ⲈⲦⲈⲔϢⲞⲠ ⲚϨⲢⲎ ⲒⲚϦⲎⲦ ⲀⲚⲞⲔ ϨⲰ ⲚϨⲢⲎⲒ ⲚϦⲎⲦⲔ ϨⲒⲚⲀ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲚⲦⲞⲨϢⲰⲠⲒ ⲚϦⲎⲦⲈⲚ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀϨϮ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲠⲒⲰⲞⲨ ⲈⲦⲀⲔⲦⲎⲒϤ ⲚⲎⲒ ⲀⲒⲦⲎⲒϤ ⲚⲰⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠⲒ ϨⲰⲞⲨ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ ⲘⲠⲈⲚⲢⲎϮ ϨⲰⲚ ⲈⲚϢⲞⲠ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲰⲠⲒ ⲈⲨϪⲎⲔ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲀⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲘⲒ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲦⲀⲞⲨⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ⲠⲀⲒⲰⲦ ⲪⲎ ⲈⲦⲀⲔⲦⲎⲒϤ ⲚⲎⲒ ϮⲞⲨⲰϢ ϨⲒⲚⲀ ⲪⲘⲀ ⲈϮϢⲞⲠ ⲘⲘⲞϤ ⲀⲚⲞⲔ ⲚⲦⲞⲨϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚⲈⲘⲎⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲚⲀⲨ ⲈⲠⲀⲰⲞⲨ ⲈⲦⲀⲔⲦⲎ ⲒϤ ⲚⲎⲒ ϪⲈ ⲀⲔⲘⲈⲚⲢⲒⲦ ϦⲀϪⲈⲚ ⲦⲔⲀⲦⲀⲂⲞⲖⲎ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ⲠⲀⲒⲰⲦ ⲠⲒⲐⲘⲎⲒ ⲞⲨⲞϨ ⲘⲠⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲰⲚⲔ ⲀⲚⲞⲔ ⲀⲒⲤⲞⲨⲰⲚⲔ ⲞⲨⲞϨ ⲚⲀⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲨⲈⲘⲒ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲦⲀⲞⲨⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ⲞⲨⲞϨ ⲀⲒⲦⲀⲘⲰⲞⲨ ⲈⲠⲈⲔⲢⲀⲚ ⲞⲨⲞϨ ϮⲚⲀⲦⲀⲘⲰⲞⲨ ϨⲒⲚⲀ ϮⲀⲄⲀⲠⲎ ⲈⲦⲀⲔⲘⲈⲚⲢⲒⲦ ⲚϦⲎⲦⲤ ⲚⲦⲈⲤϢⲰⲠⲒ ⲚϨⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲚϨⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲚϨⲢⲎⲒ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲒ ⲈⲂⲞⲖ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲘⲎⲢ ⲘⲠⲒⲘⲞⲨⲚⲤⲰⲢⲈⲘ ⲚⲦⲈⲚⲒϢⲈⲚⲤⲒϤⲒ ⲠⲒⲘⲀ ⲈⲦⲈⲞⲨⲞⲚ ⲞⲨϬⲰⲘ ⲘⲘⲞϤ ⲪⲀⲒ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ⲞⲨⲞϨ ⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ ⲚⲀϤⲤⲰⲞⲨⲚ ϨⲰϤ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ⲞⲨⲘⲎ ϢⲚⲤⲞⲠ ⲀϤⲐⲰⲞⲨϮ ⲈⲘⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ⲒⲞⲨⲆⲀⲤ ⲞⲨⲚ ⲈⲦⲀϤϬⲒ ⲘⲠⲒⲘⲎϢ ⲚⲈⲘ ϨⲀⲚϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀϤⲒ ⲈⲘⲀⲨ ⲚⲈⲘ ϨⲀⲚⲪⲀⲚⲞⲤ ⲚⲈⲘ ϨⲀⲚⲖⲀⲘⲠⲀⲤ ⲚⲈⲘ ϨⲀⲚϨⲞⲠⲖⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈϤⲤⲰⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲎ ⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲀϤⲒ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲈⲘⲰⲞⲨ ⲠⲈ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲚⲀϤⲚⲀⲦⲎⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲪⲰⲦ ⲈⲪⲀϨⲞⲨ ⲞⲨⲞϨ ⲀⲨϨⲈⲒ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϢⲈⲚⲞⲨ ϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲚⲒⲘ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲀⲒϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲤϪⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲬⲀ ⲚⲀⲒ ⲈⲂⲞⲖ ⲘⲀⲢⲞⲨϢⲈ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲤⲀϪⲒ ϪⲰⲔ ⲈⲂⲞⲖ ⲈⲦⲀϤϪⲞϤ ϪⲈ ⲚⲎ ⲈⲦⲀⲔⲦⲎⲒⲦⲞⲨ ⲚⲎⲒ ⲘⲠⲒⲦⲀⲔⲈ ϨⲖⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ⲤⲒⲘⲰⲚ ⲞⲨⲚ ⲠⲈⲦⲢⲞⲤ ⲈⲞⲨⲞⲚ ⲞⲨⲤⲎϤⲒ ⲚⲦⲞⲦϤ ⲀϤⲐⲞⲔⲘⲈⲤ ⲞⲨⲞϨ ⲀϤϨⲒⲞⲨⲒ ⲚⲤⲀⲪⲂⲰⲔ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲀϤϪⲰϪⲒ ⲘⲠⲈϤⲘⲀϢϪ ⲚⲞⲨⲒⲚⲀⲘ ⲈⲂⲞⲖ ⲪⲢⲀⲚ ⲆⲈ ⲘⲠⲒⲂⲰⲔ ⲠⲈ ⲘⲀⲖⲬⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ϨⲒⲞⲨⲒ ⲚϮⲤⲎϤⲒ ⲈⲦⲈⲤⲐⲎⲔⲎ ⲠⲒⲀⲪⲞⲦ ⲈⲦⲀϤⲦⲎⲒϤ ⲚⲎⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲀⲚ ϮⲚⲀⲤⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ⲠⲒⲘⲎϢ ⲞⲨⲚ ⲚⲈⲘ ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲈⲘ ⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲀⲘⲞⲚⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲤⲞⲚϨϤ ");
INSERT INTO copbhc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲚϢⲞⲢⲠ ϨⲀ ⲀⲚⲚⲀ ⲚⲈⲠϢⲞⲘ ⲄⲀⲢ ⲚⲔⲀⲒⲀⲪⲀ ⲪⲎ ⲈⲚⲀϤⲞⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲦⲈϮⲢⲞⲘⲠⲒ ⲈⲦⲈⲘⲘⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ⲚⲈ ⲪⲀⲒ ⲆⲈ ⲠⲈ ⲔⲀⲒⲀⲪⲀ ⲪⲎ ⲈⲦⲀϤⲤⲞϬ ⲚⲒ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲢⲚⲞϤⲢⲒ ⲚⲦⲈⲞⲨⲢⲰⲘⲒ ⲚⲞⲨⲰⲦ ⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ⲚⲀϤⲘⲞϢⲒ ⲆⲈ ⲠⲈ ⲚⲤⲀⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲠⲒⲘⲀⲐⲎ ⲦⲎⲤ ⲆⲈ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀϤⲞⲒ ⲚⲤⲞⲨⲒⲚ ⲠⲈ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲈϮⲀⲨⲖⲎ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ⲠⲈⲦⲢⲞⲤ ⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲂⲞⲖ ϦⲀⲦⲈⲚ ⲠⲒⲢⲞ ⲀϤⲒ ⲞⲨⲚ ⲚϪⲈⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲪⲎ ⲈⲚⲀϤⲞⲒ ⲚⲢⲈⲘⲤⲰⲞⲨⲚ ⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘ ϮⲈⲘⲚⲞⲨⲦ ⲞⲨⲞϨ ⲀϤⲒⲚⲒ ⲘⲠⲈⲦⲢⲞⲤ ⲈϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ⲠⲈϪⲈ ϮⲀⲖⲞⲨ ⲚⲈⲘⲚⲞⲨⲦ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲘⲎ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲚⲘⲀⲐⲎⲦⲎⲤ ⲘⲠⲀⲒⲢⲰⲘⲒ ϨⲰⲔ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ⲚⲀⲨⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ⲠⲈ ⲚϪⲈⲚⲒⲈⲂⲒⲀⲒⲔ ⲚⲈⲘ ⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲀⲨϬⲈⲢⲞ ⲚⲞⲨⲢⲀⲔϨⲒ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲈⲦⲪⲢⲰ ⲦⲈ ⲞⲨⲞϨ ⲚⲀⲨⲦϦⲘⲞ ⲘⲘⲰⲞⲨ ⲠⲈ ⲚⲀϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚⲈⲘⲰⲞⲨ ϨⲰϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲈϤⲦϦⲘⲞ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲨⲚ ⲀϤϢⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲈⲐⲂⲈ ⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲈⲘ ⲈⲐⲂⲈ ⲦⲈϤⲤⲂⲰ ");
INSERT INTO copbhc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ⲀϤⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲀⲒⲤⲀϪⲒ ⲚⲈⲘ ⲠⲒⲔⲞⲤⲘⲞⲤ ϦⲈⲚⲞⲨⲠⲀⲢⲢⲎⲤⲒⲀ ⲞⲨⲞϨ ⲚⲀⲒϮⲤⲂⲰ ⲠⲈ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲠⲒⲘⲀ ⲈϢⲀⲢⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲐⲰⲞⲨϮ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲘⲠⲒϪⲈ ϨⲖⲒ ⲚⲤⲀϪⲒ ϦⲈⲚⲠⲈⲦϨⲎⲠ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ⲈⲐⲂⲈⲞⲨ ⲔϢⲒⲚⲒ ⲘⲘⲞⲒ ϢⲈⲚ ⲚⲎ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ⲞⲨ ⲠⲈⲦⲀⲒϪⲞϤ ⲚⲰⲞⲨ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲀⲒ ⲤⲈⲈⲘⲒ ⲈⲚⲎ ⲈⲦⲀⲒϪⲞⲦⲞⲨ ⲀⲚⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀⲞⲨⲀⲒ ⲚⲦⲈⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲀϤϮ ⲚⲞⲨⲔⲞⲨⲢ ⲚⲒⲎⲤⲞⲨⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚ ⲪⲀⲒ ⲠⲈ ⲪⲢⲎϮ ⲚⲈⲢⲞⲨⲰ ⲘⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲒⲤϪⲈ ⲔⲀⲔⲰⲤ ⲀⲒⲤⲀϪⲒ ⲀⲢⲒⲈⲢⲘⲈⲐⲢⲈ ⲘⲠⲒⲔⲀⲔⲰⲤ ⲒⲤϪⲈ ⲆⲈ ⲔⲀⲖⲰⲤ ⲈⲐⲂⲈⲞⲨ ⲔϨⲒⲞⲨⲒ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ⲦⲞⲦⲈ ⲀϤⲞⲨⲞⲢⲠϤ ⲚϪⲈⲀⲚⲚⲀ ⲈϤⲤⲞⲚϨ ϨⲀ ⲔⲀⲒⲀⲪⲀ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ⲚⲀϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϤⲦϦⲘⲞ ⲘⲘⲞϤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲘⲎ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲰⲔ ⲚⲐⲞϤ ⲆⲈ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ⲠⲈϪⲈ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲂⲒⲀⲒⲔ ⲚⲦⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲞⲨⲤⲨⲄⲄⲈⲚⲎⲤ ⲠⲈ ⲚⲦⲈⲪⲎ ⲈⲦⲀ ⲠⲈⲦⲢⲞⲤ ϪⲰϪⲒ ⲘⲠⲈϤⲘⲀϢϪ ⲈⲂⲞⲖ ϪⲈ ⲘⲎ ⲀⲚⲞⲔ ⲀⲚ ⲀⲒⲚⲀⲨ ⲈⲢⲞⲔ ⲚⲈⲘⲀϤ ϦⲈⲚⲠⲒϬⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤϪⲰⲖ ⲈⲂⲞⲖ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀⲞⲨⲀⲖⲈⲔⲦⲰⲢ ⲘⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ⲀⲨⲒⲚⲒ ⲞⲨⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲀ ⲔⲀⲒⲀⲪⲀ ⲈϦⲞⲨⲚ ⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲚⲈϢⲰⲢⲠ ⲆⲈ ⲠⲈ ⲚⲐⲰⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ϨⲒⲚⲀ ϪⲈ ⲚⲚⲞⲨⲤⲰϤ ϢⲀⲦⲞⲨⲞⲨⲰⲘ ⲘⲠⲒⲠⲀⲤⲬⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ⲀϤⲒ ⲞⲨⲚ ⲈⲂⲞⲖ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲞⲨ ⲚⲔⲀⲦⲎ ⲄⲞⲢⲒⲀ ⲈⲦⲈⲦⲈⲚⲒⲚⲒ ⲘⲘⲞⲤ ϦⲀ ⲠⲀⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ⲀⲨⲈⲢⲞⲨⲰ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲈⲚⲈ ⲪⲀⲒ ⲞⲨⲤⲀⲘⲠⲈⲦϨⲰⲞⲨ ⲀⲚ ⲠⲈ ⲚⲀⲚⲚⲀⲦⲎⲒϤ ⲚⲀⲔ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ϪⲈ ϬⲒⲦϤ ⲚⲐⲰⲦⲈⲚ ⲘⲀϨⲀⲠ ⲈⲢⲞϤ ⲔⲀⲦⲀ ⲠⲈⲦⲈⲚⲚⲞⲘⲞⲤ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲀⲚⲞⲚ ⲤϢⲈ ⲚⲀⲚ ⲀⲚ ⲈϦⲰⲦⲈⲂ ⲚϨⲖⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲤⲀϪⲒ ⲚⲒⲎⲤⲞⲨⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈϤⲈⲢⲤⲎⲘⲈⲚⲒⲚ ϪⲈ ϦⲈⲚⲀϢ ⲘⲘⲞⲨ ϤⲚⲀⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲒ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲚⲐⲞⲔ ⲈⲦϪⲰ ⲘⲪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ϢⲀⲚ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲠⲈⲦⲀⲨϪⲞⲤ ⲚⲀⲔ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲀⲚⲞⲔ ⲞⲨⲒⲞⲨⲆⲀⲒ ϨⲰ ⲠⲈⲔⲈⲐⲚⲞⲤ ⲘⲘⲒⲚ ⲘⲘⲞⲔ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲐⲰⲞⲨ ⲠⲈⲦⲀⲨⲦⲎ ⲒⲔ ⲞⲨ ⲠⲈⲦⲀⲔⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲦⲀⲘⲈⲦⲞⲨⲢⲞ ⲚⲐⲀ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲦⲈ ⲈⲚⲈ ⲦⲀⲘⲈⲦⲞⲨⲢⲞ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲦⲈ ⲚⲀⲢⲈ ⲚⲀϨⲨⲠⲈⲢⲈⲦⲎ ⲤⲚⲀⲨⲚⲀϮ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲦⲎ ⲒⲦ ⲚⲚⲒⲞⲨⲆⲀⲒ ϮⲚⲞⲨ ⲆⲈ ⲦⲀⲘⲈⲦⲞⲨⲢⲞ ⲐⲀ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ⲠⲒⲖⲀⲦⲞⲤ ⲞⲨⲚ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨⲔⲞⲨⲚ ⲚⲐⲞⲔ ⲞⲨⲞⲨⲢⲞ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲞⲨⲢⲞ ⲔⲈ ⲄⲀⲢ ⲈⲦⲀⲨⲘⲀⲤⲦ ⲀⲚⲞⲔ ⲈⲠⲀⲒϨⲰⲂ ⲞⲨⲞϨ ⲈⲐⲂⲈⲪⲀⲒ ⲀⲒⲒ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲠϪⲒⲚⲦⲀⲈⲢⲘⲈⲐⲢⲈ ⲚϮⲘⲈⲐⲘⲎⲒ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ϨⲀⲚⲈⲂⲞⲖ ϦⲈⲚϮⲘⲈⲐⲘⲎⲒ ⲚⲈϢⲀⲨⲤⲰⲦⲈⲘ ⲈⲦⲀⲤⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀϤ ϪⲈ ⲞⲨ ⲠⲈ ϮⲘⲈⲐⲘⲎⲒ ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲒ ⲈⲂⲞⲖ ϨⲀ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲞⲔ ⲚϮϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ⲀⲚ ϦⲈⲚⲠⲀⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ⲦⲈⲦⲈⲚⲤⲨⲚⲎⲐⲒⲀ ⲆⲈ ⲦⲈ ϨⲒⲚⲀ ⲚⲦⲈⲬⲀ ⲞⲨⲀⲒ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲀⲤⲬⲀ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲞⲨⲚ ⲚⲦⲀⲬⲰ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲘⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ⲀⲨⲰϢ ⲆⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲬⲀ ⲪⲀⲒ ⲈⲂⲞⲖ ⲀⲖⲖⲀ ⲬⲀ ⲂⲀⲢⲀⲂⲂⲀⲤ ⲠⲀⲒⲂⲀⲢⲀⲂⲂⲀⲤ ⲆⲈ ⲚⲈⲞⲨⲤⲞⲚⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ⲦⲞⲦⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲀϤϬⲒ ⲚⲒⲎⲤⲞⲨⲤ ⲀϤⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ⲞⲨⲞϨ ⲚⲒⲘⲀⲦⲞⲒ ⲀⲨϢⲰⲚⲦ ⲚⲞⲨⲬⲖⲞⲘ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚⲤⲞⲨⲢⲒ ⲀⲨⲦⲎⲒϤ ⲈϪⲈⲚ ⲦⲈϤⲀⲪⲈ ⲞⲨⲞϨ ⲀⲨϪⲞⲖϨϤ ⲚⲞⲨϨⲂⲞⲤ ⲚϬⲎϪⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ϨⲀⲢⲞϤ ⲠⲈ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲈⲢⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲚⲀⲨϮⲔⲞⲨⲢ ⲚⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀϤⲒ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲈⲚϤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ϮϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ⲦⲞⲦⲈ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲈⲢⲪⲞⲢⲒⲚ ⲘⲠⲒⲬⲖⲞⲘ ⲚⲤⲞⲨⲢⲒ ⲚⲈⲘ ⲠⲒϨⲂⲞⲤ ⲚϬⲎϪⲒ ⲞⲨⲞϨ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒϨⲨⲠⲎⲢⲈⲦⲎⲤ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀϢϤ ⲀϢϤ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ϪⲈ ⲘⲰⲒⲚⲒ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲀϢϤ ⲀⲚⲞⲔ ⲄⲀⲢ ⲚϮϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ϬⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ⲀⲨⲈⲢⲞⲨⲰ ⲚⲀϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲞⲚ ⲚⲦⲀⲚ ⲚⲞⲨⲚⲞⲘⲞⲤ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲠⲈⲚⲚⲞⲘⲞⲤ ϤⲈⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ϪⲈ ⲀϤⲀⲒϤ ⲚϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲈⲠⲀⲒⲤⲀϪⲒ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲀϤⲈⲢϨⲞϮ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ⲞⲨⲞϨ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ⲐⲰⲚ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲘⲠⲈϤⲈⲢⲞⲨⲰ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲔⲤⲀϪⲒ ⲚⲈⲘⲎⲒ ⲀⲚ ϢⲀⲚ ⲔⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲞⲚϮ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈⲀϢⲔ ⲞⲨⲞⲚϮ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲞⲚ ⲈⲬⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲘⲞⲚⲦⲈⲔ ϨⲖⲒ ⲚⲈⲢϢⲒϢⲒ ⲈϦⲞⲨⲚ ⲈⲢⲞⲒ ⲈⲚⲈ ⲘⲠⲞⲨⲦⲎⲒⲤ ⲚⲀⲔ ⲈⲂⲞⲖ ⲘⲠϢⲰⲒ ⲈⲐⲂⲈⲪⲀⲒ ⲪⲎ ⲈⲦⲀϤⲦⲎⲒⲦ ⲚⲀⲔ ⲞⲨⲞⲚⲦⲈϤ ⲚⲒϢϮ ⲚⲚⲞⲂⲒ ⲘⲘⲀⲨ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲚ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲀϤⲔⲰϮ ⲚⲤⲀⲬⲀϤ ⲈⲂⲞⲖ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲚ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲀⲔϢⲀⲚⲬⲀ ⲪⲀⲒ ⲈⲂⲞⲖ ⲚⲐⲞⲔ ⲠϢⲪⲎⲢ ⲘⲠⲞⲨⲢⲞ ⲀⲚ ⲞⲨⲞⲚ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲒⲢⲒ ⲘⲘⲞϤ ⲚⲞⲨⲢⲞ ⲘⲘⲀⲨⲀⲦϤ ⲈϤϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ⲠⲒⲖⲀⲦⲞⲤ ⲆⲈ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲈⲚⲀⲒⲤⲀϪⲒ ⲀϤⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤϨⲈⲘⲤⲒ ϨⲒ ⲠⲒⲂⲎ ⲘⲀ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲖⲒⲐⲞⲤⲦⲢⲰⲦⲞⲚ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲆⲈ ϪⲈ ⲄⲀⲂⲂⲀⲐⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ⲚⲈ ⲦⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲆⲈ ⲦⲈ ⲚⲦⲈⲠⲒⲠⲀⲤⲬ ⲀⲚⲈ ⲪⲚⲀⲨ ⲆⲈ ⲚⲀϪⲠ ⲠⲈ ⲞⲨⲞϨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲠⲈ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲚⲚⲒⲞⲨⲆⲀⲒ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲠⲈⲦⲈⲚⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲀⲖⲒⲦϤ ⲀⲖⲒⲦϤ ⲀϢϤ ⲠⲈϪⲈ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲰⲞⲨ ⲚⲦⲀⲈϢ ⲠⲈⲦⲈⲚⲞⲨⲢⲞ ⲀⲨⲈⲢⲞⲨⲰ ⲚϪⲈⲚⲒⲀⲢⲬ ⲒⲈⲢⲈⲨⲤ ϪⲈ ⲘⲘⲞⲚⲦⲈⲚ ⲞⲨⲢⲞ ⲘⲘⲀⲨ ⲈⲂⲎⲖ ⲈⲔⲈⲤⲀⲢ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ⲦⲞⲦⲈ ⲞⲨⲚ ⲀϤϮ ⲚⲰⲞⲨ ⲚⲒⲎⲤⲞⲨⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲀϢϤ ⲀⲨϬⲒ ⲞⲨⲚ ⲚⲒⲎⲤ ");
INSERT INTO copbhc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲈϤϤⲀⲒ ⲘⲠⲈϤⲤⲦⲀⲨⲢⲞⲤ ⲀϤⲒ ⲈⲠⲒⲘⲀ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲒⲔⲢⲀⲚⲒⲞⲚ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲆⲈ ϪⲈ ⲄⲞⲖⲄⲞⲐⲀ ");
INSERT INTO copbhc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ⲠⲒⲘⲀ ⲈⲦⲀⲨⲀϢϤ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀⲨⲒϢⲒ ⲚⲔⲈⲤⲞⲚⲒ ⲂⲚⲈⲘⲀϤ ⲤⲀⲘⲚⲀⲒ ⲚⲈⲘ ⲤⲀⲘⲚⲀⲒ ⲘⲘⲞϤ ⲒⲎⲤⲞⲨⲤ ⲆⲈ ϦⲈⲚⲐⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ⲀϤⲤϦⲈ ⲔⲈⲦⲒⲦⲖⲞⲤ ⲆⲈ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲞⲨⲞϨ ⲀϤⲬⲀϤ ϨⲒϪⲈⲚ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲚⲀϤⲤϦⲎ ⲞⲨⲦ ⲆⲈ ⲠⲈ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ⲞⲨⲘⲎϢ ⲆⲈ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲰϢ ⲘⲠⲒⲦⲒⲦⲖⲞⲤ ϪⲈ ⲚⲀϤϦⲈⲚⲦ ⲠⲈ ⲈϮⲂⲀⲔⲒ ⲚϪⲈⲠⲒⲘⲀ ⲈⲦⲀⲨⲈϢ ⲒⲎⲤⲞⲨⲤ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲀϤⲤϦⲎ ⲞⲨⲦ ⲠⲈ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲘⲘⲈⲦⲢⲰⲘⲈⲞⲤ ⲘⲘⲈⲦⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲠⲈ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲘⲠⲈⲢⲤϦⲀⲒ ϪⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲖⲖⲀ ϪⲈ ⲚⲐⲞϤ ⲀϤϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲠⲞⲨⲢⲞ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ϪⲈ ⲪⲎ ⲈⲦⲀⲒⲤϦⲎⲦϤ ⲀⲒⲤϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ⲚⲒⲘⲀⲦⲞⲒ ⲞⲨⲚ ⲈⲦⲀⲨⲈϢ ⲒⲎⲤⲞⲨⲤ ⲀⲨϬⲒ ⲚⲚⲈϤϨⲂⲰⲤ ⲀⲨⲀⲒⲦⲞⲨ ⲚⲆ ⲚⲦⲞⲒ ⲚⲈⲘ ϮⲔⲈϢⲐⲎ ⲚϮϢⲐⲎⲚ ⲆⲈ ⲚⲈⲞⲨⲀⲦⲐⲰⲢⲠ ⲦⲈ ⲚⲤⲰϦⲒ ⲈⲂⲞⲖ ⲘⲠϢⲰⲒ ⲦⲎⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ⲠⲈϪⲰⲞⲨ ⲞⲨⲚ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲪⲀϦⲤ ⲀⲖⲖⲀ ⲘⲀⲢⲈⲚϨⲒⲰⲠ ⲈⲢⲞⲤ ϪⲈ ⲀⲤⲚⲀⲈⲢ ⲐⲀ ⲚⲒⲘ ⲘⲘⲞⲚ ϨⲒⲚⲀ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨⲪⲰϢ ⲚⲚⲀϨⲂⲰⲤ ⲈϨⲢⲀⲨ ⲞⲨⲞϨ ⲦⲀϨⲈⲂⲤⲰ ⲀⲨϨⲒⲰⲠ ⲈⲢⲞⲤ ⲚⲀⲒ ⲞⲨⲚ ⲈⲦⲀⲨⲀⲒⲦⲞⲨ ⲚϪⲈⲚⲒⲘⲀⲦⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ⲚⲀⲨⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦⲞⲨ ⲠⲈ ϦⲀⲦⲈⲚ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲦⲤⲰⲚⲒ ⲚⲦⲈϤⲘⲀⲨ ⲘⲀⲢⲒⲀ ⲐⲎ ⲚⲦⲈⲔⲖⲈⲞⲠⲀ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ⲒⲎⲤⲞⲨⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ⲈⲦⲈϤⲘⲀⲨ ⲚⲈⲘ ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲀϤⲘⲈⲒ ⲘⲘⲞϤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲠⲈϪⲀϤ ⲚⲦⲈϤⲘⲀⲨ ϪⲈ ⲒⲤ ⲠⲈϢⲎⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ⲒⲦⲀ ⲠⲈϪⲀϤ ⲘⲠⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲦⲈⲔⲘⲀⲨ ⲞⲨⲞϨ ⲒⲤϪⲈⲚ ϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀϤⲞⲖⲤ ⲚϪⲈⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲠⲈϤⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϨⲎⲆⲎ ⲀϨⲰⲂ ⲚⲒⲂⲈⲚ ϪⲰⲔ ⲈⲂⲞⲖ ϨⲒⲚⲀ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ϪⲈ ϮⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲞⲔⲒ ⲆⲈ ⲠⲈ ⲈϤⲘⲈϨ ⲚϨⲈⲘϪ ⲈϤⲬⲎ ⲈϦⲢⲎⲒ ⲀⲨⲘⲞϨ ⲚⲞⲨⲤⲪⲞⲄⲄⲞⲤ ⲚϨⲈⲘϪ ⲀⲨⲦⲀⲖⲞϤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲞⲨϨⲨⲤⲤⲰⲠⲞⲤ ⲀⲨϨⲒⲦϤ ϦⲀⲦⲈⲚ ⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀϤϪⲈⲘϮⲠⲒ ⲘⲠⲒϨⲈⲘϪ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲠⲈϪⲀϤ ϪⲈ ⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀϤⲢⲈⲔ ϪⲰϤ ⲀϤϮ ⲘⲠⲒⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲚ ⲈⲠⲒⲆⲎ ⲚⲈϮⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲞϨⲒ ⲚϪⲈⲚⲒⲤⲰⲘⲀ ϨⲒϪⲈⲚ ⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲘⲠⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲈⲞⲨⲚⲒϢϮ ⲄⲀⲢ ⲠⲈ ⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨϮϨⲞ ⲈⲠⲒⲖⲀⲦⲞⲤ ϨⲒⲚⲀ ⲚⲦⲞⲨⲔⲰϢ ⲚⲚⲞⲨⲔⲈⲖⲒ ⲞⲨⲞϨ ⲚⲦⲞⲨⲞⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ⲀⲨⲒ ⲞⲨⲚ ⲚϪⲈⲚⲒⲘⲀⲦⲞⲒ ⲞⲨⲞϨ ⲠⲒϨⲞⲨⲒⲦ ⲘⲈⲚ ⲀⲨⲔⲰϢ ⲚⲚⲈϤⲔⲈⲖⲒ ⲞⲨⲞϨ ⲀⲨⲔⲰϢ ⲚⲚⲀ ⲠⲒⲔⲈⲞⲨⲀⲒ ⲈⲦⲀⲨⲀϢϤ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ⲈⲦⲀⲨⲒ ⲆⲈ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲀⲨϪⲈⲘϤ ϨⲎⲆⲎ ⲀϤⲞⲨⲰ ⲈϤⲘⲞⲨ ⲘⲠⲞⲨⲔⲰϢ ⲚⲚⲈϤⲔⲈⲖⲒ ⲚⲐⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ⲀⲖⲖⲀ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘⲀⲦⲞⲒ ⲀϤⲐⲞⲨⲜ ⲘⲠⲈϤⲤⲪⲒⲢ ⲚⲦⲈϤⲖⲞⲄⲬⲎ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲞⲨⲘⲰⲞⲨ ⲚⲈⲘ ⲞⲨⲤⲚⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀϤⲚⲀⲨ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲞⲨⲞϨ ⲞⲨⲘⲎⲒ ⲦⲈ ⲦⲈϤⲘⲈⲦⲘⲈⲐⲢⲈ ⲞⲨⲞϨ ⲚⲐⲞϤ ϨⲰϤ ⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ ϤⲈⲘⲒ ϪⲈ ⲀϤϪⲈ ⲘⲈⲐⲘⲎⲒ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ⲚⲀⲒ ⲄⲀⲢ ⲀⲨϢⲰⲠⲒ ϨⲒⲚⲀ ⲚⲦⲈϮⲄⲢⲀⲪⲎ ϪⲰⲔ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲔⲀⲤ ⲚⲦⲀϤ ⲚⲚⲞⲨⲔⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ϮⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲈⲨⲈⲚⲀⲨ ⲈⲪⲎ ⲈⲦⲀⲨⲐⲞⲔⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲀϤⲒ ⲚϪⲈⲒⲰⲤⲎⲪ ⲠⲒⲢⲈⲘⲀⲢⲒⲘⲀⲐⲈⲀⲤ ⲀϤϮϨⲞ ⲈⲠⲒⲖⲀⲦⲞⲤ ⲈⲞⲨⲘⲀⲐⲎ ⲦⲎⲤ ϨⲰϤ ⲠⲈ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲚⲀϤⲬⲎⲠ ⲆⲈ ⲠⲈ ⲈⲐⲂⲈ ⲦϨⲞϮ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϨⲒⲚⲀ ⲚⲦⲈϤⲰⲖⲒ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚϪⲈⲠⲒⲖⲀⲦⲞⲤ ⲈⲦⲎⲒϤ ⲀϤⲒ ⲞⲨⲚ ⲞⲨⲞϨ ⲀϤⲰⲖⲒ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ⲀϤⲒ ⲆⲈ ϨⲰϤ ⲚϪⲈⲚⲒⲔⲞⲆⲎⲘⲞⲤ ⲪⲎ ⲈⲦⲀϤⲒ ϨⲀ ⲒⲎⲤⲞⲨⲤ ⲚϪⲰⲢϨ ⲚϢⲞⲢⲠ ⲈⲞⲨⲞⲚ ⲞⲨⲘⲒⲄⲘⲀ ⲚⲦⲞⲦϤ ⲞⲨϢⲀⲖ ⲚⲈⲘ ⲞⲨⲀⲖⲖⲞⲎ ⲚⲀⲨⲢ ⲚⲖⲒⲦⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ⲀⲨϬⲒ ⲞⲨⲚ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲀⲨⲔⲞⲨⲖⲰⲖϤ ⲚϨⲀⲚϢⲈⲚⲦⲰ ⲚⲒⲀⲨ ⲚⲈⲘ ⲚⲒⲤⲐⲞⲒ ⲔⲀⲦⲀ ϮⲔⲀϨⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨⲔⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨϬⲰⲘ ⲆⲈ ⲠⲈ ⲘⲠⲒⲘⲀ ⲈⲦⲀⲨⲀϢϤ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘϨⲀⲨ ⲘⲂⲈⲢⲒ ϦⲈⲚⲠⲒϬⲰⲘ ⲘⲠⲀⲦⲞⲨϨⲒ ϨⲖⲒ ⲈϦⲞⲨⲚ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ⲈⲠⲒⲆⲎ ⲚⲀϤϦⲈⲚⲦ ⲈⲢⲰⲞⲨ ⲚϪⲈⲠⲒⲘϨⲀⲨ ⲈⲐⲂⲈϪⲈ ⲚⲈϮⲠⲀⲢⲀⲤⲔⲈⲨⲎ ⲦⲈ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲬⲀ ⲒⲎⲤⲞⲨⲤ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲪⲞⲨⲀⲒ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲀⲤⲒ ⲈⲠⲒⲘϨⲀⲨ ⲚϢⲰⲢⲠ ⲈⲦⲒ ⲈⲢⲈ ⲦⲬⲈⲘⲤ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲀⲤⲚⲀⲨ ⲈⲠⲒⲰⲚⲒ ⲈⲀⲨⲞⲖϤ ⲈⲂⲞⲖ ϨⲒⲢⲰϤ ⲘⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ⲀⲤϬⲞϪⲒ ⲞⲨⲚ ⲀⲤⲒ ϨⲀ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ϨⲀ ⲠⲒⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲀⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϪⲀⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲨⲰⲖⲒ ⲘⲠⲈⲚϬ ⲤⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲨⲬⲀϤ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ⲀϤⲒ ⲞⲨⲚ ⲈⲂⲞⲖ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲠⲒⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ⲚⲀⲨϬⲞϪⲒ ⲆⲈ ⲘⲠⲂ ϨⲒⲞⲨⲤⲞⲠ ⲞⲨⲞϨ ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲀϤϬⲞϪⲒ ⲈⲦϨⲎ ⲘⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲀϤⲈⲢϢⲞⲢⲠ ⲈⲢⲞϤ ⲈⲠⲒⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ⲞⲨⲞϨ ⲀϤⲤⲞⲘⲤ ⲈϦⲞⲨⲚ ⲀϤⲚⲀⲨ ⲈⲚⲒϨⲂⲰⲤ ⲈⲨⲬⲎ ⲈϦⲢⲎⲒ ⲘⲈⲚⲦⲞⲒ ⲘⲠⲈϤϢⲈ ⲈϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ⲀϤⲒ ⲆⲈ ϨⲰϤ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲈϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲀϤϨⲰⲖ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲚⲒϨⲂⲰⲤ ⲈⲨⲬⲎ ⲈϦⲢⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ⲚⲈⲘ ⲠⲒⲤⲞⲨⲆⲀⲢⲒⲞⲚ ⲈⲚⲀϤⲬⲎ ϨⲒϪⲈⲚ ⲦⲈϤⲀⲪⲈ ⲚⲀϤⲬⲎ ⲀⲚ ⲚⲈⲘ ⲚⲒϨⲂⲰⲤ ⲀⲖⲖⲀ ⲈϤⲔⲞⲨⲖⲰⲖ ⲈϤⲬⲎ ⲤⲀⲞⲨⲤⲀ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ⲦⲞⲦⲈ ⲀϤⲒ ⲈϦⲞⲨⲚ ϨⲰϤ ⲚϪⲈⲠⲒⲔⲈⲘⲀⲐⲎ ⲦⲎⲤ ⲈⲦⲀϤⲒ ⲚϢⲞⲢⲠ ⲈⲠⲒⲘϨⲀⲨ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲀϤⲚⲀϨϮ ");
INSERT INTO copbhc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ⲚⲈ ⲘⲠⲀⲦⲞⲨⲤⲞⲨⲈⲚ ϮⲄⲢⲀⲪⲎ ⲄⲀⲢ ⲠⲈ ϪⲈ ϨⲰϮ ⲈⲢⲞϤ ⲠⲈ ⲈⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲞⲚ ⲈⲠⲞⲨⲘⲀ ⲚϪⲈⲚⲒⲘⲀⲐⲎ ⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ⲘⲀⲢⲒⲀ ⲆⲈ ⲚⲀⲤⲞϨⲒ ⲈⲢⲀⲦⲤ ⲤⲀⲂⲞⲖ ⲠⲈ ϦⲀⲦⲈⲚ ⲠⲒⲘϨⲀⲨ ⲈⲤⲢⲒⲘⲒ ϨⲰⲤ ⲆⲈ ⲈⲤⲢⲒⲘⲒ ⲀⲤϪⲞⲨϢⲦ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘϨⲀⲨ ");
INSERT INTO copbhc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ⲀⲤⲚⲀⲨ ⲈⲀⲄⲄⲈⲖⲞⲤ ⲂⲈⲨϨⲈⲘⲤⲒ ϦⲈⲚϨⲀⲚϬⲒϨⲂⲞⲤ ⲚⲞⲨⲰⲂϢ ⲞⲨⲀⲒ ϦⲀϪⲰϤ ⲞⲨⲞϨ ⲞⲨⲀⲒ ϦⲀⲢⲀⲦϤ ⲘⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲠⲒⲤⲰⲘⲀ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲬⲎ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ⲚⲀⲤ ⲚϪⲈⲚⲎ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ϮⲤϨⲒⲘⲒ ⲀϦⲞ ⲦⲈⲢⲒⲘⲒ ⲠⲈϪⲀⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲨⲰⲖⲒ ⲘⲠⲀϬⲞⲒⲤ ⲞⲨⲞϨ ⲚϮⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲨⲬⲀϤ ⲐⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ⲚⲀⲒ ⲈⲦⲀⲤϪⲞⲦⲞⲨ ⲀⲤⲪⲞⲚϨⲤ ⲈⲪⲀϨⲞⲨ ⲀⲤⲚⲀⲨ ⲈⲒⲎⲤⲞⲨⲤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲞⲨⲞϨ ⲚⲀⲤⲈⲘⲒ ⲀⲚ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ϮⲤϨⲒⲘⲒ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲢⲒⲘⲒ ⲀⲢⲈⲔⲰϮ ⲚⲤⲀⲚⲒⲘ ⲚⲐⲞⲤ ⲆⲈ ⲈⲤⲘⲈⲨⲒ ϪⲈ ⲠⲒϬⲘⲎ ⲘⲠⲒϬⲰⲘ ⲠⲈ ⲠⲈϪⲀⲤ ⲚⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲀⲔϤⲀⲒ ⲘⲘⲞϤ ⲘⲀⲦⲀⲘⲞⲒ ϪⲈ ⲀⲔⲬⲀϤ ⲐⲰⲚ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲈⲐⲚⲀⲞⲖϤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲀⲢⲒⲀⲘ ⲚⲐⲞⲤ ⲆⲈ ⲀⲤⲪⲞⲚϨⲤ ⲠⲈϪⲀⲤ ⲚⲀϤ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ϪⲈ ⲢⲀⲂⲂⲞⲨⲚⲒ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲪⲢⲈϤϮⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀⲤ ϪⲈ ⲘⲠⲈⲢϬⲒ ⲚⲈⲘⲎⲒ ⲘⲠⲀϮϢⲈ ⲚⲎⲒ ⲄⲀⲢ ⲈⲠϢⲰⲒ ϨⲀ ⲠⲀⲒⲰⲦ ⲘⲀϢⲈ ⲚⲈⲆⲈ ϨⲀ ⲚⲀⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲀϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲠϢⲰⲒ ϨⲀ ⲠⲀⲒⲰⲦ ⲈⲦⲈ ⲠⲈⲦⲈⲚⲒⲰⲦ ⲠⲈ ⲚⲈⲘ ⲠⲀⲚⲞⲨϮ ⲈⲦⲈ ⲠⲈⲦⲈⲚⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ⲀⲤⲒ ⲆⲈ ⲚϪⲈⲘⲀⲢⲒⲀ ϮⲘⲀⲄⲆⲀⲖⲒⲚⲎ ⲀⲤⲦⲀⲘⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲒⲚⲀⲨ ⲈⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ⲚⲈ ⲢⲞⲨϨⲒ ⲆⲈ ⲠⲈ ⲘⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲘⲪⲞⲨⲀⲒ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲞⲨⲞϨ ⲈⲢⲈ ⲚⲒⲢⲰⲞⲨ ϢⲞⲦⲈⲘ ⲚⲦⲈⲠⲒⲘⲀ ⲈⲚⲀⲢⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲐⲞⲨⲎⲦ ⲚϦⲎⲦϤ ⲈⲐⲂⲈ ⲦϨⲞϮ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀϤⲒ ⲆⲈ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦϨⲒⲢⲎⲚⲎ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲀϤⲦⲀⲘⲰⲞⲨ ⲈⲚⲈϤϪⲒϪ ⲚⲈⲘ ⲠⲈϤⲤⲪⲒⲢ ⲀⲨⲢⲀϢⲒ ⲞⲨⲚ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲞⲚ ϪⲈ ⲦϨⲒⲢⲎ ⲚⲎ ⲚⲰⲦⲈⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲚϪⲈⲠⲀⲒⲰⲦ ⲀⲚⲞⲔ ϨⲰ ϮⲞⲨⲰⲢⲠ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲀϤⲚⲒϤⲒ ⲈϦⲞⲨⲚ ϦⲈⲚⲠⲞⲨϨⲞ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϬⲒ ⲚⲰⲦⲈⲚ ⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲬⲀ ⲚⲞⲨⲚⲞⲂⲒ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲤⲈⲬⲎ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ ⲈⲨⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ⲐⲰⲘⲀⲤ ⲆⲈ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲒⲂ ⲚⲀϤⲬⲎ ⲘⲘⲀⲨ ⲚⲈⲘⲰⲞⲨ ⲀⲚ ⲠⲈ ⲈⲦⲀϤⲒ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ⲚⲀⲨϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲚⲀϤ ⲠⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲀⲚⲚⲀⲨ ⲈⲠϬⲞⲒⲤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲒϢⲦⲈⲘⲚⲀⲨ ⲈⲠⲦⲨⲠⲞⲤ ⲚⲦⲈⲚⲒⲒϤⲦ ϦⲈⲚⲚⲈϤϪⲒϪ ⲞⲨⲞϨ ⲚⲦⲀϨⲒⲞⲨⲒ ⲘⲠⲀⲦⲎ ⲂⲈⲠⲦⲨⲠⲞⲤ ⲚⲦⲈⲚⲒⲒϤⲦ ⲞⲨⲞϨ ⲚⲦⲀϨⲞⲨⲒ ⲚⲦⲀϪⲒϪ ⲈⲠⲈϤⲤⲪⲒⲢ ⲚϮⲚⲀⲚⲀϨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲎⲚⲈϨⲞⲞⲨ ⲠⲀⲖⲒⲚ ⲞⲚ ⲚⲀⲨⲐⲞⲨⲎⲦ ⲈϦⲞⲨⲚ ⲠⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲚⲀϤⲚⲈⲘⲰⲞⲨ ⲠⲈ ⲚϪⲈⲐⲰⲘⲀⲤ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲢⲈ ⲚⲒⲢⲰⲞⲨ ϢⲞⲦⲈⲘ ⲞⲨⲞϨ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲦϨⲒⲢⲎⲚⲎ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ⲒⲦⲀ ⲠⲈϪⲀϤ ⲚⲐⲰⲘⲀⲤ ϪⲈ ⲘⲀ ⲠⲈⲔⲦⲎ ⲂⲈⲘⲚⲀⲒ ⲞⲨⲞϨ ⲀⲚⲀⲨ ⲈⲚⲀϪⲒϪ ⲞⲨⲞϨ ⲀⲨⲒⲤ ⲦⲈⲔϪⲒϪ ϨⲒⲦⲤ ⲈⲠⲀⲤⲪⲒⲢ ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲢⲀⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲐⲰⲘⲀⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲞⲨⲞϨ ⲠⲀⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲈⲦⲀⲔⲚⲀⲨ ⲈⲢⲞⲒ ⲀⲔⲚⲀϨϮ ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲚⲀⲨ ⲞⲨⲞϨ ⲀⲨⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ⲔⲈⲘⲎϢ ⲘⲈⲚ ⲘⲘⲎⲒⲚⲒ ⲀϤⲀⲒⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲚⲎ ⲈⲦⲈ ⲚⲤⲈⲤϦⲎ ⲞⲨⲦ ⲀⲚ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲀⲒϪⲰⲘ ");
INSERT INTO copbhc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ⲚⲀⲒ ⲆⲈ ⲀⲨⲤϦⲎⲦⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲠⲈ ⲞⲨⲞϨ ϨⲒⲚⲀ ⲈⲢⲈⲦⲈⲚⲚⲀϨϮ ⲚⲦⲈⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ ϢⲰⲠⲒ ⲚⲰⲦⲈⲚ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲆⲈ ⲞⲚ ⲚⲀϤⲞⲨⲞⲚϨϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ϨⲒϪⲈⲚ ⲪⲒⲞⲘ ⲚⲦⲈⲦⲒⲂⲈⲢⲒⲀⲆⲞⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲆⲈ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ⲚⲀⲨⲬⲎ ϨⲒϪⲈⲚ ⲞⲨⲘⲀ ⲠⲈ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲐⲰⲘⲀⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲆⲒⲆⲨⲘⲞⲤ ⲚⲈⲘ ⲚⲈⲚϢⲎⲢⲒ ⲚⲌⲈⲂⲈⲆⲈⲞⲤ ⲚⲈⲘ ⲔⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ⲠⲈϪⲈ ⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲚⲰⲞⲨ ϪⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲚⲦⲀⲦⲀϨⲈ ⲦⲈⲂⲦ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲦⲈⲚⲚⲎⲞⲨ ϨⲰⲚ ⲚⲈⲘⲀⲔ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ⲈⲦⲈⲘⲘⲀⲨ ⲘⲠⲞⲨⲦⲀϨⲈ ϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ⲈⲢⲈ ϢⲰⲢⲠ ⲆⲈ ⲚⲀϢⲰⲠⲒ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϨⲒ ⲠⲒⲬⲢⲞ ⲘⲈⲚⲦⲞⲒ ⲘⲠⲞⲨⲈⲘⲒ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲚ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲀⲖⲰⲞⲨⲒ ⲘⲎ ⲞⲨⲞⲚ ϨⲖⲒ ⲚⲈⲚⲬⲀⲒ ⲚⲞⲨⲰⲘ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲀⲨⲈⲢⲞⲨⲰ ϪⲈ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ϨⲒⲞⲨⲒ ⲘⲠⲒϢⲚⲈ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲈϪⲒⲘⲒ ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨϨⲒⲞⲨⲒ ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚⲤⲞⲔϤ ⲈⲠϢⲰⲒ ⲚⲦⲈⲚ ⲠⲀϢⲀⲒ ⲚⲦⲈⲚⲒⲦⲈⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ⲠⲈϪⲈ ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲪⲎ ⲈⲚⲀⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈⲒ ⲘⲘⲞϤ ⲘⲠⲈⲦⲢⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈ ⲤⲒⲘⲰⲚ ⲞⲨⲚ ⲠⲈⲦⲢⲞⲤ ⲈⲦⲀϤⲤⲰⲦⲈⲘ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈ ⲀϤⲘⲞⲢϤ ⲘⲠⲈϤⲈⲠⲈⲚⲆⲨⲦⲎⲤ ⲚⲀϤⲂⲎϢ ⲄⲀⲢ ⲠⲈ ⲞⲨⲞϨ ⲀϤϨⲒⲦϤ ⲈⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ⲚⲒⲔⲈⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲀⲨⲒ ϦⲈⲚⲠⲒϪⲞⲒ ⲚⲀⲨⲞⲨⲎⲞⲨ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲬⲢⲞ ⲀⲖⲖⲀ ϨⲰⲤ ⲚⲀⲨⲤ ⲘⲘⲀϨⲒ ⲈⲨⲤⲰⲔ ⲘⲠⲒϢⲚⲈ ⲚⲦⲈⲚⲒⲦⲈⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲠⲒⲔⲀϨⲒ ⲀⲨϪⲞⲨϢⲦ ⲀⲨⲚⲀⲨ ⲈⲞⲨⲢⲀⲔϨⲒ ⲈⲤⲬⲎ ⲈϦⲢⲎⲒ ⲚⲈⲘ ⲞⲨⲦⲈⲂⲦ ϨⲒϪⲰⲤ ⲚⲈⲘ ⲞⲨⲰⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲦⲈⲂⲦ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲀϨⲰⲞⲨ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ⲀϤⲒ ⲞⲨⲚ ⲈⲠϢⲰⲒ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ⲞⲨⲞϨ ⲀϤⲤⲈⲔ ⲠⲒϢⲚⲈ ⲈⲠϢⲰⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲈϤⲘⲈϨ ⲚⲚⲒϢϮ ⲚⲦⲈⲂⲦ ⲈⲞⲨⲞⲚ ⲢⲚⲄ ⲚϦⲎ ⲦϤ ⲞⲨⲞϨ ⲈⲢⲈ ⲦⲀⲒⲎⲠⲒ ⲚϦⲎⲦϤ ⲘⲠⲈϤⲪⲰϦ ⲚϪⲈⲠⲒϢⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲰⲞⲨ ϪⲈ ⲀⲘⲰⲒⲚⲒ ⲞⲨⲰⲘ ⲚⲈⲘⲘⲞⲚ ϨⲖⲒ ⲆⲈ ⲠⲈ ⲚⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲢⲦⲞⲖⲘⲀⲚ ⲈϢⲈⲚϤ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲈⲨⲈⲘⲒ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ⲀϤⲒ ⲞⲨⲚ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲀϤϬⲒ ⲘⲠⲒⲰⲒⲔ ⲞⲨⲞϨ ⲀϤϮ ⲚⲰⲞⲨ ⲚⲈⲘ ⲠⲒⲦⲈⲂⲦ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ⲪⲀⲒ ⲆⲈ ⲠⲈ ⲪⲘⲀϨⲄ ⲚⲤⲞⲠ ⲈⲦⲀϤⲞⲨⲞⲚϨϤ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲈⲚⲈϤⲘⲀⲐⲎⲦⲎⲤ ⲈⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ϨⲞⲦⲈ ⲞⲨⲚ ⲈⲦⲀⲨⲞⲨⲰⲘ ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲤⲒⲘⲰⲚ ⲠⲈⲦⲢⲞⲤ ϪⲈ ⲤⲒⲘⲰⲚ ⲪⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲔⲈⲢⲀⲄⲀⲠⲀⲚ ⲘⲘⲞⲒ ⲈϨⲞⲦⲈ ⲚⲀⲒ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠⲀϬⲞⲒⲤ ⲚⲐⲞⲔ ⲈⲦⲈⲘⲒ ϪⲈ ϮⲘⲈⲒ ⲘⲘⲞⲔ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞⲚⲒ ⲚⲚⲀϨⲒⲎⲂ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ⲠⲀⲖⲒⲚ ⲞⲚ ⲠⲈϪⲀϤ ⲚⲀϤ ⲘⲪⲘⲀϨⲤⲞⲠ ⲂϪⲈ ⲤⲒⲘⲰⲚ ⲪⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲔⲈⲢⲀⲄⲀⲠⲀⲚ ⲘⲘⲞⲒ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲤⲈ ⲠⲀϬⲞⲒⲤ ⲚⲐⲞⲔ ⲈⲦⲈⲘⲒ ϪⲈ ϮⲘⲈⲒ ⲘⲘⲞⲔ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞⲚⲒ ⲚⲚⲀⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ⲠⲈϪⲀϤ ⲚⲀϤ ⲞⲚ ⲘⲪⲘⲀϨⲄ ⲚⲤⲞⲠ ϪⲈ ⲤⲒⲘⲰⲚ ⲪⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲬⲘⲈⲒ ⲘⲘⲞⲒ ⲀϤⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ϪⲈ ⲀϤϪⲞⲤ ⲚⲀϤ ⲘⲪⲘⲀϨⲄ ⲚⲤⲞⲠ ϪⲈ ⲬⲘⲈⲒ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲐⲞⲔ ⲈⲦⲤⲰⲞⲨⲚ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲐⲞⲔ ⲈⲦⲈⲘⲒ ϪⲈ ϮⲘⲈⲒ ⲘⲘⲞⲔ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞⲚⲒ ⲚⲚⲀⲈⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ⲀⲘⲎⲚ ⲀⲘⲎⲚ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲀⲔ ϪⲈ ⲈⲔⲞⲒ ⲚⲀⲖⲞⲨ ϢⲀⲔⲘⲞⲢⲔ ⲘⲘⲀⲨⲀⲦⲔ ⲞⲨⲞϨ ϢⲀⲔϢⲈ ⲚⲀⲔ ⲈⲪⲘⲀ ⲈⲦⲈϨⲚⲀⲔ ⲈϢⲰⲠ ⲆⲈ ⲀⲔϢⲀⲚⲈⲢϦⲈⲖⲖⲞ ⲈⲔⲈⲤⲞⲨⲦⲈⲚ ⲚⲈⲔϪⲒϪ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲢⲈ ⲔⲈⲞⲨⲀⲒ ⲘⲞⲢⲔ ⲞⲨⲞϨ ⲈⲨⲈⲞⲖⲔ ⲈⲪⲘⲀ ⲈⲦⲈϨⲚⲀⲔ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ⲪⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞϤ ⲀϤⲈⲢⲤⲎⲘⲈⲚⲒⲚ ϪⲈ ⲀϤⲚⲀϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲚϦⲢⲎⲒ ϦⲈⲚⲀϢ ⲘⲘⲞⲨ ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀϤϪⲞϤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ⲀϤⲪⲞⲚϨϤ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲚⲀⲨ ⲈⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲀⲢⲈ ⲒⲎⲤⲞⲨⲤ ⲘⲈⲒ ⲘⲘⲞϤ ⲪⲎ ⲈⲦⲀϤⲢⲞⲐⲂⲈϤ ⲈϪⲈⲚ ⲦⲈϤⲘⲈⲤⲦⲈⲚϨⲎⲦ ϦⲈⲚⲠⲒⲆⲒⲠⲚⲞⲚ ⲈⲀϤϪⲞⲤ ⲚⲀϤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲒⲘ ⲠⲈⲐⲚⲀⲦⲎ ⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ⲈⲦⲀϤⲚⲀⲨ ⲞⲨⲚ ⲈⲪⲀⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ϪⲈ ⲠⲀϬⲞⲒⲤ ⲪⲀⲒ ⲆⲈ ⲚⲐⲞϤ ⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ⲠⲈϪⲈ ⲒⲎⲤⲞⲨⲤ ⲚⲀϤ ϪⲈ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲞⲨⲰϢ ⲈⲬⲀϤ ϢⲀϮⲒ ⲀϦⲞⲔ ⲚⲐⲞⲔ ⲚⲐⲞⲔ ⲆⲈ ⲞⲨⲀϨⲔ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ⲀⲠⲀⲒⲤⲀϪⲒ ⲆⲈ ⲒⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲚⲎ ⲞⲨ ϪⲈ ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲈⲘⲘⲀⲨ ϤⲚⲀⲘⲞⲨ ⲀⲚ ⲚⲈⲦⲀϤϪⲞⲤ ⲆⲈ ⲚⲀϤ ⲀⲚ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ϪⲈ ϤⲚⲀⲘⲞⲨ ⲀⲚ ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲞⲨⲰϢ ⲈⲬⲀϤ ϢⲀϮⲒ ⲀϦⲞⲔ ⲚⲐⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ⲠⲀⲒ ⲠⲈ ⲠⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀϤⲈⲢⲘⲈⲐⲢⲈ ϦⲀ ⲚⲀⲒ ⲞⲨⲞϨ ⲚⲐⲞϤ ⲀϤⲤϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨⲘⲎⲒ ⲦⲈ ⲦⲈϤⲘⲈⲦⲘⲈⲐⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲘⲎϢ ⲆⲈ ⲞⲚ ⲈⲀϤⲀⲒⲦⲞⲨ ⲚϪⲈⲒⲎⲤⲞⲨⲤ ⲚⲀⲒ ⲈⲚⲈ ⲀⲨⲤϦⲎⲦⲞⲨ ⲠⲈ ⲔⲀⲦⲀ ⲞⲨⲀⲒ ⲞⲨⲀⲒ ϮⲈⲘⲒ ϪⲈ ⲚⲀⲢⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲀϢⲈⲢⲬⲰⲢⲒⲚ ⲀⲚ ⲠⲈ ⲚⲚⲒϪⲰⲘ ⲈⲦⲞⲨⲚⲀⲤϦⲎ ⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ⲠⲒϨⲞⲨⲒⲦ ⲘⲈⲚ ⲚⲤⲀϪⲒ ⲀⲒⲀⲒϤ ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲰⲐⲈⲞⲪⲨⲖⲖⲈ ϦⲈⲚⲚⲎ ⲈⲦⲀ ⲒⲎⲤⲞⲨⲤ ϨⲒⲦⲞⲦϤ ⲈⲀⲒⲦⲞⲨ ⲞⲨⲞϨ ⲈϮⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ϢⲀ ⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲎ ⲈⲦⲀϤⲤⲞⲦⲠⲞⲨ ⲀⲨⲞⲖϤ ⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ⲚⲀⲒ ⲈⲦⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲰⲞⲨ ⲈϤⲞⲚϦ ⲘⲈⲚⲈⲚⲤⲀ ⲈⲦⲀϤϢⲈⲠⲘⲔⲀϨ ϦⲈⲚⲞⲨⲘⲎϢ ⲘⲘⲎⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲘⲚⲈϨⲞⲞⲨ ⲈϤⲞⲨⲞⲚϨ ⲘⲘⲞϤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ⲞⲨⲞϨ ⲈϤⲞⲨⲰⲘ ⲚⲈⲘⲰⲞⲨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϢⲦⲈⲘⲪⲰⲢϪ ⲤⲀⲂⲞⲖ ⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲖⲖⲀ ⲈⲞϨⲒ ⲘⲠⲒⲰϢ ⲚⲦⲈⲪⲒⲰⲦ ⲪⲎ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲞⲐⲘⲈϤ ⲚⲦⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲀϤϮⲰⲘⲤ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲤⲈⲚⲀⲈⲘⲤ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲘⲈⲚⲈⲚⲤⲀ ⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲀⲚ ⲀⲚⲀⲒ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲤⲎⲞⲨ ⲬⲚⲀⲦⲪⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲪⲰⲦⲈⲚ ⲀⲚ ⲠⲈ ⲈⲈⲘⲒ ⲈϨⲀⲚⲬⲢⲞⲚⲞⲤ ⲒⲈ ϨⲀⲚⲤⲎⲞⲨ ⲚⲀⲒ ⲈⲦⲀ ⲪⲒⲰⲦ ⲬⲀⲨ ϦⲀ ⲠⲈϤⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ⲀⲖⲖⲀ ⲈⲢⲈⲦⲈⲚⲈϬⲒ ⲚⲞⲨϪⲞⲘ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲒⲈϦⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϢⲰⲠⲒ ⲚⲎⲒ ⲘⲘⲈⲐⲢⲈ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲚⲈⲘ ϢⲀ ⲀⲨⲢⲎϪϤ ⲘⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲈⲨⲤⲞⲘⲤ ⲀⲨϤⲒⲦϤ ⲈⲠϢⲰⲒ ⲞⲨⲞϨ ⲞⲨϬⲎⲠⲒ ⲀⲤϢⲞⲠⲤ ⲈⲢⲞⲤ ⲈⲂⲞⲖ ϨⲀ ⲚⲞⲨⲂⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ⲚⲀⲨⲞⲒ ⲆⲈ ⲘⲪⲢⲎϮ ⲈⲚⲀⲨⲒⲞⲢⲈⲘ ⲞⲨⲀⲒ ⲞⲨⲂⲈ ⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ⲈϤⲘⲞϢⲒ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲢⲰⲘⲒ ⲂⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲀϨⲢⲀⲨ ϦⲈⲚϨⲀⲚϨⲈⲂⲤⲰ ⲈⲨⲞⲨⲞⲂϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ⲞⲨⲞϨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲄⲀⲖⲒⲖⲈⲞⲤ ⲀϦⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲤⲞⲘⲤ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲪⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀⲨⲞⲖϤ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϨⲀⲢⲰⲦⲈⲚ ⲪⲀⲒ ⲞⲚ ⲠⲈ ⲘⲪⲢⲎϮ ⲈⲦⲈϤⲚⲎⲞⲨ ⲘⲘⲞϤ ⲘⲪⲢⲎϮ ⲈⲦⲀⲢⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲘⲞϢⲒ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ⲦⲞⲦⲈ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲦⲰⲞⲨ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲪⲀⲚⲒϪⲰⲒⲦ ⲈⲦϦⲈⲚⲦ ⲈϦⲞⲨⲚ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲞⲨⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ⲦⲞⲦⲈ ⲈⲦⲀⲨϢⲈ ⲈϦⲞⲨⲚ ⲀⲨϢⲈ ⲈϨⲢⲎⲒ ⲈⲞⲨⲘⲀ ⲈϤⲤⲀⲠϢⲰⲒ ⲠⲒⲘⲀ ⲈⲚⲀϤϢⲞⲠ ⲚϦⲎⲦϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲀⲚⲆⲢⲈⲀⲤ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲈⲘ ⲐⲰⲘⲀⲤ ⲂⲀⲢⲐⲞⲖⲞⲘⲈⲞⲤ ⲚⲈⲘ ⲘⲀⲦⲐⲈⲞⲤ ⲒⲀⲔⲰⲂⲞⲤ ⲪⲀ ⲀⲖⲪⲈⲞⲤ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲠⲒⲢⲈϤⲬⲞϨ ⲚⲈⲘ ⲒⲞⲨⲆⲀⲤ ⲪⲀ ⲒⲀⲔⲰⲂⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲨⲘⲎⲚ ⲈⲨⲤⲞⲠ ⲈϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ ⲚⲈⲘ ⲘⲀⲢⲒⲀ ⲐⲘⲀⲨ ⲚⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲚⲈϤⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ⲞⲨⲞϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲀⲒⲈϨⲞⲞⲨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ϦⲈⲚⲐⲘⲎϮ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲆⲈ ⲈⲨⲐⲞⲨⲎⲦ ϨⲒ ⲪⲀⲒ ⲈⲪⲀⲒ ⲈⲚⲀⲨⲚⲀⲈⲢⲢⲔ ⲚⲢⲀⲚ ⲠⲈϪⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ⲚⲒⲢⲰⲘⲒ ⲚⲒⲤⲚⲎⲞⲨ ϨⲰϮ ⲠⲈ ⲚⲦⲈⲤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈϮⲄⲢⲀⲪⲎ ⲐⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚϪⲞⲤ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲚⲆⲀⲨⲒⲆ ⲈⲐⲂⲈ ⲒⲞⲨⲆⲀⲤ ⲪⲎ ⲈⲦⲀϤⲈⲢϬⲀⲨⲘⲰⲒⲦ ⲚⲚⲎ ⲈⲦⲀⲨⲀⲘⲀϨⲒ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ϪⲈ ⲚⲀϤⲎⲠ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ⲠⲈ ⲞⲨⲞϨ ⲀⲠⲒⲰⲠ ⲒⲈⲢⲞϤ ⲘⲠⲒⲔⲖⲎⲢⲞⲤ ⲚⲦⲈⲦⲀⲒⲆⲒⲀⲔⲞⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ⲪⲀⲒ ⲘⲈⲚ ⲞⲨⲚ ⲀϤϢⲰⲠ ⲚⲞⲨⲒⲞϨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲂⲈⲬⲈ ⲚⲦⲈⲦⲀⲆⲒⲔⲒⲀ ⲞⲨⲞϨ ⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ⲀϤⲔⲰϢ ϦⲈⲚⲦⲈϤⲘⲎϮ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲤⲀϦⲞⲨⲚ ⲘⲘⲞϤ ⲦⲎⲢⲞⲨ ⲀⲨⲪⲰⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϨⲰⲤⲦⲈ ⲚⲤⲈⲘⲞⲨϮ ⲈⲪⲢⲀⲚ ⲘⲠⲒⲒⲞϨⲒ ⲈⲦⲈⲘⲘⲀⲨ ϦⲈⲚⲦⲞⲨⲀⲤⲠⲒ ϪⲈ ⲀⲬⲈⲖⲆⲀⲘⲀⲄ ⲈⲦⲈ ⲠⲒⲒⲞϨⲒ ⲚⲦⲈⲠⲒⲤⲚⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϨⲒ ⲠϪⲰⲘ ⲚⲦⲈⲚⲒⲮⲀⲖⲘⲞⲤ ϪⲈ ⲦⲈϤⲈⲢⲂⲒ ⲘⲀⲢⲈⲤϢⲰϤ ⲞⲨⲞϨ ⲘⲠⲈⲚⲐⲢⲈϤϢⲰⲠⲒ ⲚϪⲈⲪⲎ ⲈⲦϢⲞⲠ ⲚϦⲎⲦⲤ ⲦⲈϤⲘⲈⲦⲈⲠⲒⲤⲔⲞⲠⲞⲤ ⲘⲀⲢⲈ ⲔⲈⲞⲨⲀⲒ ϬⲒⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ϨⲰϮ ⲞⲨⲚ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲈⲦⲀⲨⲒ ⲈϦⲞⲨⲚ ⲚϦⲎⲦⲈⲚ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲦⲎⲢϤ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ϨⲒϪⲰⲚ ⲚϪⲈⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ⲈⲀϤⲈⲢϨⲎⲦⲤ ⲒⲤϪⲈⲚ ⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲀⲨⲞⲖϤ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϨⲀⲢⲞⲚ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲚⲀⲒ ⲈⲢⲘⲈⲐⲢⲈ ⲚⲈⲘⲀⲚ ϦⲀ ⲦⲈϤⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ⲞⲨⲞϨ ⲀⲨⲦⲀϨⲈ ⲂⲈⲢⲀⲦⲞⲨ ⲒⲰⲤⲎⲪ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲤⲀⲂⲂⲀⲤ ⲪⲎ ⲈⲦⲀⲨϮⲢⲈⲚϤ ϪⲈ ⲒⲞⲨⲤⲦⲞⲤ ⲚⲈⲘ ⲘⲀⲐⲒⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲂϨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲐⲞⲔ ⲠⲈⲦⲤⲰⲞⲨⲚ ⲘⲠϨⲎⲦ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞⲚϨ ⲘⲪⲎ ⲈⲦⲀⲔⲤⲞⲦⲠϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲂ ⲞⲨⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ⲈϬⲒ ⲈⲪⲘⲀ ⲚⲦⲈⲦⲀⲒⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲈⲘ ⲦⲀⲒⲘⲈⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲐⲎ ⲈⲦⲀϤⲈⲢⲠⲀⲢⲀⲂⲈⲚⲒⲚ ⲘⲘⲞⲤ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲈⲀϤϢⲈ ⲚⲀϤ ⲈⲠⲈϤⲘⲀ ⲈⲦⲈ ⲪⲰϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ⲞⲨⲞϨ ⲀⲨϮⲔⲖⲎⲢⲞⲤ ⲚⲰⲞⲨ ⲀⲠⲒⲔⲖⲎⲢⲞⲤ ⲒⲈϪⲈⲚ ⲘⲀⲐⲒⲀⲤ ⲀⲨⲞⲠϤ ⲚⲈⲘ ⲠⲒⲒⲀ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲰⲔ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈϮⲠⲈⲚⲦⲎⲔⲞⲤⲦⲎ ⲚⲀⲨⲐⲞⲨⲎⲦ ⲦⲎⲢⲞⲨ ⲠⲈ ϨⲒ ⲞⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲘⲎ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲐⲎⲞⲨ ⲈⲨⲒⲚⲒ ⲘⲘⲞϤ ⲚϪⲞⲚⲤ ⲞⲨⲞϨ ⲀϤⲘⲞϨ ⲘⲠⲒⲎⲒ ⲦⲎⲢϤ ⲈⲚⲀⲨϨⲈⲘⲤⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲢⲰⲞⲨ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲖⲀⲤ ⲚⲬⲢⲰⲘ ⲈⲨⲪⲎϢ ⲞⲨⲞϨ ⲀⲨϨⲈⲘⲤⲒ ⲈϪⲈⲚ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ⲞⲨⲞϨ ⲀⲨⲘⲞϨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲞⲨⲞϨ ⲀⲨⲞⲨⲀϨⲦⲞⲦⲞⲨ ⲈⲤⲀϪⲒ ⲚϨⲀⲚⲔⲈⲖⲀⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤϮ ⲚⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲢⲞⲨⲈⲢⲞⲨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲨϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϨⲀⲚⲢⲰⲘⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲨⲈⲢϨⲞϮ ⲈⲂⲞⲖ ϦⲈⲚϢⲖⲰⲖ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲀⲠⲈⲤⲎⲦ ⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ⲈⲦⲀⲤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲦⲀⲒⲤⲘⲎ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲘⲎϢ ⲞⲨⲞϨ ⲀⲨϢⲐⲞⲢⲦⲈⲢ ϪⲈ ⲚⲀⲢⲈ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲈⲨⲤⲀϪⲒ ϦⲈⲚⲦⲞⲨⲀⲤⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ⲚⲀⲨⲦⲰⲘⲦ ⲆⲈ ⲦⲎⲢⲞⲨ ⲠⲈ ⲈⲨⲈⲢϢⲪⲎⲢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲬⲒ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲤⲀϪⲒ ϨⲀⲚⲄⲀⲖⲒⲖⲈⲞⲤ ⲀⲚ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ⲠⲰⲤ ⲀⲚⲞⲚ ⲦⲈⲚⲤⲰⲦⲈⲘ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲞⲚ ϦⲈⲚⲦⲈⲚⲀⲤⲠⲒ ⲈⲦⲀⲨϪⲪⲞⲚ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ⲚⲒⲠⲀⲢⲐⲞⲤ ⲚⲈⲘ ⲚⲒⲘⲎⲆⲞⲤ ⲚⲈⲘ ⲚⲒⲈⲖⲀⲘⲒⲦⲎ ⲤⲚⲈⲘ ⲚⲎ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲘⲈⲤⲞⲠⲞⲦⲀⲘⲒⲀ ϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ϮⲔⲀⲠⲠⲞⲆⲞⲔⲒⲀ ⲠⲞⲚⲦⲞⲤ ⲚⲈⲘ ϮⲀⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ϮⲪⲢⲒⲔⲒⲀ ⲚⲈⲘ ϮⲠⲀⲘⲪⲒⲖⲒⲀ ⲬⲎⲘⲒ ⲚⲈⲘ ⲚⲒⲤⲀ ⲚⲦⲈϮⲖⲨⲂⲎ ⲐⲎ ⲈⲦϨⲒ ⲚⲒⲤⲀ ⲚⲦⲈϮⲔⲨⲢⲒⲚⲚⲎ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲈⲞⲤ ⲈⲦϢⲞⲠ ⲚϦⲎⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒϢⲈⲘⲘⲰⲞⲨ ⲚⲒⲔⲢⲒⲦⲎⲤ ⲚⲈⲘ ⲚⲒⲀⲢⲀⲂⲞⲤ ⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲈⲨⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲚⲚⲒⲘⲈⲦⲚⲒϢϮ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ⲚⲀⲨⲦⲰⲘⲦ ⲆⲈ ⲦⲎⲢⲞⲨ ⲠⲈ ⲈⲨⲒⲞⲢⲈⲘ ⲞⲨⲀⲒ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲞⲨⲀⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨⲈⲢϢⲈⲢϢⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲀⲒ ⲘⲀϨ ϦⲎⲦⲞⲨ ⲚⲈⲘⲂⲢⲒⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲈ ⲚⲀⲒ ⲐⲀϦⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ⲀϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲠⲒⲔⲈⲒⲀ ⲀϤϬⲒⲤⲒ ⲚⲦⲈϤⲤⲘⲎ ⲈϨⲢⲎⲒ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲦⲎⲢⲞⲨ ⲪⲀⲒ ⲘⲀⲢⲈϤⲞⲨⲰⲚϨ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ϬⲒⲤⲘⲎ ⲈⲚⲀⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ⲞⲨ ⲄⲀⲢ ⲘⲪⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲈⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ⲀⲢⲈ ⲚⲀⲒ ⲐⲀϦⲒ ⲀϪⲠⲄϮ ⲄⲀⲢ ⲘⲠⲒⲈϨⲞⲞⲨ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ⲀⲖⲖⲀ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲀϤϪⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲒⲰⲎⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ϪⲈ ⲈⲤⲈϢⲰⲠⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚϦⲀⲈ ⲠⲈϪⲈ ⲪⲚⲞⲨϮ ⲈⲒⲈⲪⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲠⲚⲈⲨⲘⲀⲈϪⲈⲚ ⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲈⲨⲈⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲚϪⲈⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲚⲈⲘ ⲚⲈⲦⲈⲚϢⲈⲢⲒ ⲞⲨⲞϨ ⲚⲈⲦⲈⲚϦⲈⲖϢⲒⲢⲒ ⲈⲨⲈⲚⲀⲨ ⲈϨⲀⲚϨⲞⲢⲀⲤⲒⲤ ⲞⲨⲞϨ ⲚⲈⲦⲈⲚϦⲈⲖⲖⲞⲒ ⲈⲨⲈⲪⲰⲢ ⲚϨⲀⲚⲢⲀⲤⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ⲔⲈⲄⲈ ⲈⲒⲈⲪⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲠⲚⲈⲨⲘⲀⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲀⲂⲰⲔ ⲚⲈⲘ ⲚⲀⲂⲰⲔⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲨⲈⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ⲈⲒⲈϮ ⲚϨⲀⲚϢⲪⲎⲢⲒ ϦⲈⲚⲦⲪⲈ ⲈⲠϢⲰⲒ ⲚⲈⲘ ϨⲀⲚⲘⲎⲒⲚⲒ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲤⲚⲞϤ ⲚⲈⲘ ⲞⲨⲬⲢⲰⲘ ⲚⲈⲘ ⲞⲨⲬⲢⲈⲘⲦⲤ ⲚⲔⲀⲠⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ⲪⲢⲎ ⲈϤⲈⲞⲨⲰⲦⲈⲂ ⲈϤⲈⲈⲢⲬⲀⲔⲒ ⲞⲨⲞϨ ⲠⲒⲒⲞϨ ⲈϤⲈⲈⲢⲤⲚⲞϤ ⲘⲠⲀⲦⲈϤⲒ ⲚϪⲈⲠⲒⲚⲒϢϮ ⲚⲈϨⲞⲞⲨ ⲚⲦⲈⲠϬⲞⲒⲤ ⲈⲐⲞⲨⲞⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ⲞⲨⲞϨ ⲈⲤⲈϢⲰⲠⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲦⲰⲂϨ ⲘⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲈϤⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ⲚⲒⲢⲰⲘⲒ ⲚⲒⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲤⲰⲦⲈⲘ ⲈⲚⲀⲤⲀϪⲒ ⲚⲀⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲀ ⲪⲚⲞⲨϮ ⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϢⲀⲢⲰⲦⲈⲚ ⲠⲈ ϦⲈⲚϨⲀⲚϪⲞⲘ ⲚⲈⲘ ϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲀⲒⲦⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ϦⲈⲚⲦⲈⲦⲈⲚⲘⲎϮ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ⲪⲀⲒ ϦⲈⲚⲠⲒⲤⲞϬⲚⲒ ⲈⲦⲐⲎϢ ⲚⲈⲘ ⲠⲒϢⲞⲢⲠ ⲚⲈⲘⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲀⲦⲈⲦⲈⲚⲦⲎⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲚⲒⲀⲚⲞⲘⲞⲤ ⲈⲀⲢⲈⲦⲈⲚⲀϢϤ ⲞⲨⲞϨ ⲀⲢⲈⲦⲈⲚϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ⲪⲀⲒ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲈⲀϤⲂⲰⲖ ⲈⲂⲞⲖ ⲚⲚⲒⲚⲀⲔϨⲒ ⲚⲦⲈⲀⲘⲈⲚϮ ϪⲈ ⲚⲈⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲤⲈⲀⲘⲀϨⲒ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ⲆⲀⲨⲒⲆ ⲄⲀⲢ ϤϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲀⲒⲈⲢϢⲞⲢⲠ ⲚⲚⲀⲨ ⲘⲠϬⲞⲒⲤ ⲘⲠⲀⲘⲐⲞ ⲈⲂⲞⲖ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲈϤⲬⲎ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲘⲞⲒ ϪⲈ ⲚⲚⲀⲔⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲠⲀϨⲎⲦ ⲞⲨⲚⲞϤ ⲞⲨⲞϨ Ⲁ- ⲠⲀⲖⲀⲤ ⲐⲈⲖⲎⲖ ⲈⲦⲒ ⲆⲈ ⲚⲈⲘ ⲦⲀⲔⲈⲤⲀⲢⲜ ⲈⲤⲈϢⲰⲠⲒ ϦⲈⲚⲞⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ϪⲈ ⲚⲚⲈⲔⲤⲰϪⲠ ⲚⲦⲀⲮⲨⲬⲎ ϦⲈⲚⲀⲘⲈⲚϮ ⲞⲨⲆⲈ ⲚⲚⲈⲔϮ ⲘⲠⲈⲐⲞⲨⲀⲂ ⲚⲦⲀⲔ ⲈⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ⲚⲒⲘⲰⲒⲦ ⲚⲦⲈⲠⲰⲚϦ ⲀⲔⲞⲨⲞⲚϨⲞⲨ ⲚⲎⲒ ⲈⲂⲞⲖ ⲈⲔⲈⲘⲀϨⲦ ⲚⲞⲨⲚⲞϤ ⲚⲈⲘ ⲠⲈⲔϨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲤϢⲈ ⲈⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲈⲐⲂⲈ ⲠⲈⲚⲠⲀⲦⲢⲒⲀⲢⲬⲎ ⲤⲆⲀⲨⲒⲆ ϪⲈ ⲀϤⲘⲞⲨ ⲞⲨⲞϨ ⲀⲨⲔⲞⲤϤ ⲞⲨⲞϨ ⲠⲈϤⲘϨⲀⲨ ⲚϦⲎⲦⲈⲚ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲞⲨⲚ ⲠⲈ ⲞⲨⲞϨ ⲈϤⲤⲰⲞⲨⲚ ϪⲈ ϦⲈⲚⲞⲨⲀⲚⲀϢ ⲀⲪⲚⲞⲨϮ ⲰⲢⲔ ⲚⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲦⲀϨ ⲚⲦⲈⲦⲈϤϮⲠⲒ ⲈⲐⲢⲈϤϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ⲠⲈϤⲐⲢⲞⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ⲈⲦⲀϤⲚⲀⲨ ⲞⲨⲚ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ⲀϤⲤⲀϪⲒ ⲈⲐⲂⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ϪⲈ ⲘⲠⲈϤⲤⲞϪⲠϤ ϦⲈⲚⲀⲘⲈⲚϮ ⲞⲨⲆⲈ ⲘⲠⲈⲦⲈϤⲤⲀⲢⲜ ⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ⲪⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲪⲀⲒ ⲈⲦⲈ ⲀⲚⲞⲚ ⲦⲎⲢⲈⲚ ⲦⲈⲚⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ⲈⲀϤϬⲒⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲪⲚⲞⲨϮ ⲀϤϬⲒ ⲘⲠⲒⲰϢ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲪⲒⲰⲦ ⲀϤⲪⲰⲚ ⲘⲘⲞϤ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ⲆⲀⲨⲒⲆ ⲄⲀⲢ ⲘⲠⲈϤϢⲈ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ⲚⲐⲞϤ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲘⲠⲀϬⲞⲒⲤ ϪⲈ ϨⲈⲘⲤⲒ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ϢⲀϮⲬⲀ ⲚⲈⲔϪⲀϪⲒ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈⲔϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ⲀⲤⲪⲀⲖⲰⲤ ⲞⲨⲚ ⲘⲀⲢⲈϤⲈⲘⲒ ⲚϪⲈⲠⲎⲒ ⲦⲎⲢϤ ⲘⲠⲒⲤⲖ ϪⲈ ⲀϤⲀⲒϤ ⲚϬⲞⲒⲤ ⲞⲨⲞϨ ⲀϤⲀⲒϤ ⲚⲬⲢⲤ ⲚϪⲈⲪⲚⲞⲨϮ ⲪⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲀⲠⲞⲨϨⲎⲦ ⲘⲔⲀϨ ⲠⲈϪⲰⲞⲨ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲠⲤⲰϪⲠ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲚⲚⲀⲀⲒϤ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲞⲨⲞϨ ⲘⲀⲢⲈ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ⲞⲘⲤϤ ⲈⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲈⲦⲈⲚⲚⲞⲂⲒ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀϬⲒ ⲚϮⲆⲰⲢⲈⲀ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ⲪⲰⲦⲈⲚ ⲄⲀⲢ ⲠⲈ ⲠⲒⲰϢ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲒⲞϮ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲞⲨⲎⲞⲨ ⲚⲎ ⲈⲦⲈ ⲠϬⲞⲒⲤ ⲠⲈⲚⲚⲞⲨϮ ⲚⲀⲐⲀϨⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲔⲈⲘⲎϢ ⲚⲤⲀϪⲒ ⲚⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀϤϦⲰⲚϪ ⲈⲢⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀϨⲈⲘ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲦⲀⲒⲄⲈⲚⲈⲀ ⲈⲦⲔⲞⲖϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ⲚⲎ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨϢⲈⲠ ⲠⲒⲤⲀϪⲒ ⲈⲢⲰⲞⲨ ⲀⲨⲞⲘⲤⲞⲨ ⲞⲨⲞϨ ⲀⲨⲞⲨⲞϨ ⲈⲢⲰⲞⲨ ⲘⲠⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚϪⲈⲄⲚϢⲞ ⲘⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ⲚⲀⲨⲘⲎⲚ ⲆⲈ ⲈϮⲤⲂⲰ ⲚⲦⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ϮⲘⲈⲦϢⲪⲎⲢ ⲚⲦⲈⲠⲒⲪⲰϢ ⲚⲦⲈⲠⲒⲰⲒⲔ ⲚⲈⲘ ϮⲠⲢⲞⲤⲈⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ⲞⲨϨⲞϮ ⲆⲈ ⲚⲀⲤϢⲞⲠ ⲘⲮⲨⲬⲎ ⲚⲒⲂⲈⲚ ϨⲀⲚⲘⲎϢ ⲆⲈ ⲘⲘⲎⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ⲚⲀⲨϢⲞⲠ ⲠⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲚϨⲞϮ ⲚⲀⲤϢⲞⲠ ϨⲒϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ⲚⲎ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲦⲀⲨⲚⲀϨϮ ⲚⲀⲨϨⲒⲞⲨⲘⲀ ⲠⲈ ⲞⲨⲞϨ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲀⲨϢⲞⲠ ⲚⲰⲞⲨ ⲠⲈ ϦⲈⲚⲞⲨⲘⲈⲦϢⲪⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ⲞⲨⲞϨ ⲚⲞⲨⲒⲞϨⲒ ⲚⲈⲘ ⲚⲞⲨϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ⲚⲀⲨϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲚⲀⲨⲪⲰϢ ⲘⲘⲰⲞⲨ ⲈϨⲢⲀⲨ ⲦⲎⲢⲞⲨ ⲔⲀⲦⲀ ⲠⲈⲦⲈ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ⲚⲀⲨⲘⲎⲚ ⲆⲈ ⲘⲘⲎⲚⲒ ⲠⲈ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲈⲨⲪⲰϢ ⲚⲞⲨⲰⲒⲔ ⲔⲀⲦⲀ ⲎⲒ ⲞⲨⲞϨ ⲚⲀⲨϬⲒ ⲚⲞⲨϦⲢⲈ ϦⲈⲚⲞⲨⲐⲈⲖⲎⲖ ⲚⲈⲘ ⲞⲨϨⲎⲦ ⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ⲈⲨⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ ⲈⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲘⲘⲀⲨ ⲚⲞⲨϨⲘⲞⲦ ϦⲀⲦⲈⲚ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲠϬⲞⲒⲤ ⲆⲈ ϢⲀϤⲞⲨⲞϨ ⲈⲚⲎ ⲈⲦⲈϢⲀⲨⲚⲞϨⲈⲘ ⲘⲘⲎⲚⲒ ϨⲒ ⲪⲀⲒ ⲈⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲀⲨⲚⲀ ⲈϨⲢⲎⲒ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲘⲪⲚⲀⲨ ⲚϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲦⲈⲀϪⲠⲐϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲈϤⲞⲒ ⲚϬⲀⲖⲈ ⲒⲤϪⲈⲚ ⲈϤϦⲈⲚ ⲐⲚⲈϪⲒ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ⲪⲀⲒ ⲚⲈϢⲀⲨⲦⲰⲞⲨⲚ ⲘⲘⲞϤ ⲘⲘⲎⲚⲒ ⲚⲤⲈⲬⲀϤ ϦⲀⲦⲈⲚ ⲪⲢⲞ ⲚϮⲠⲨⲖⲎ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲐⲎ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲦⲤⲀⲒⲎ ⲈⲐⲢⲈϤϬⲒ ⲚⲞⲨⲘⲈⲐⲚⲀⲎⲦ ⲚⲦⲈⲚ ⲚⲎ ⲈⲐⲚⲀ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ⲪⲀⲒ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲈⲨⲚⲀ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲀϤⲦⲰⲂϨ ⲘⲘⲰⲞⲨ ⲈϤⲞⲨⲰϢ ⲈϬⲒ ⲚⲞⲨⲘⲈⲐⲚⲀⲎⲦ ⲚⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲤⲞⲘⲤ ⲈⲢⲞϤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϪⲀϤ ϪⲈ ⲤⲞⲘⲤ ⲈⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ⲚⲐⲞϤ ⲆⲈ ⲚⲀϤⲘⲈⲨⲒ ϪⲈ ⲀϤⲚⲀϬⲒ ⲚⲞⲨⲘⲈⲐⲚⲀⲎⲦ ⲚⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲞⲨϨⲀⲦ ⲚⲈⲘ ⲞⲨⲚⲞⲨⲂ ⲚϤϢⲞⲠ ⲚⲎⲒ ⲀⲚ ⲠⲈⲦⲈⲚⲦⲎⲒ ⲆⲈ ϮϮ ⲘⲘⲞϤ ⲚⲀⲔ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲦⲰⲚⲔ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ⲀϤⲀⲘⲀϨⲒ ⲆⲈ ⲚⲦⲈϤϪⲒϪ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲚϮⲞⲨⲚⲞⲨ ⲆⲈ ⲀⲨⲦⲀϪⲢⲞ ⲚϪⲈⲚⲈϤⲂⲀⲤⲒⲤ ⲚⲈⲘ ⲚⲒϬⲞⲠ ⲚⲦⲈⲢⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ⲀϤϬⲒⲪⲈⲒ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲀϤⲘⲞϢⲒ ⲞⲨⲞϨ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘⲰⲞⲨ ⲈϤⲘⲞϢⲒ ⲈϤϬⲒⲪⲈⲒ ⲈϤⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲈϤⲘⲞϢⲒ ⲈϤⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ⲚⲀⲨⲤⲰⲞⲨⲚ ⲆⲈ ⲘⲘⲞϤ ⲠⲈ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲚⲀϤϨⲈⲘⲤⲒ ⲈϤϢⲀⲦ ⲘⲈⲐⲚⲀⲒ ϦⲀⲦⲈⲚ ϮⲤⲀⲒⲎ ⲘⲠⲨⲖⲎ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲀⲨⲘⲞϨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲞϮ ⲚⲈⲘ ⲞⲨⲘⲈⲦⲈⲂⲎ ⲚϦⲢⲎⲒ ⲈϪⲈⲚ ⲪⲀⲒ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ⲀϤⲀⲘⲀϨⲒ ⲆⲈ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎ ⲤⲀϤⲪⲰⲦ ϨⲀⲢⲰⲞⲨ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ϦⲀⲦⲈⲚ ϮⲤⲦⲞⲀ ⲐⲎ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲐⲀ ⲤⲞⲖⲞⲘⲰⲚ ⲈⲨⲚϦⲢⲎⲒ ϦⲈⲚⲞⲨϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲈⲢⲞⲨⲰ ⲘⲠⲒⲖⲀⲞⲤ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ⲪⲀⲒ ⲒⲈ ⲀϦⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲞⲘⲤ ⲈⲢⲞⲚ ϨⲰⲤ ϪⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲦⲈⲚϪⲞⲘ ⲒⲈ ⲦⲈⲚⲘⲈⲦⲈⲨⲤⲈⲂⲎⲤ ⲀⲚⲒⲢⲒ ⲘⲪⲀⲒ ⲈⲐⲢⲈ ⲪⲀⲒ ⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ⲪⲚⲞⲨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ ⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲀϤϮⲰⲞⲨ ⲘⲠⲈϤⲀⲖⲞⲨ ⲒⲎⲤⲞⲨⲤ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲎ ⲒϤ ⲀⲦⲈⲦⲈⲚϪⲞⲖϤ ⲈⲂⲞⲖ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲈⲀ ⲪⲎ ⲘⲈⲚ ϮϨⲀⲠ ⲈⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲠⲈⲐⲞⲨⲀⲂ ⲠⲒⲐⲘⲎⲒ ⲀⲦⲈⲦⲈⲚϪⲞⲖϤ ⲈⲂⲞⲖ ⲀⲢⲈⲦⲈⲚⲈⲢⲈⲦⲒⲚ ⲈⲐⲢⲞⲨⲬⲀ ⲞⲨⲢⲰⲘⲒ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲚⲢⲈϤϦⲰⲦⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ⲠⲀⲢⲬⲎⲄⲞⲤ ⲆⲈ ⲚⲦⲈⲠⲰⲚϦ ⲀⲢⲈⲦⲈⲚϦⲞⲐⲂⲈϤ ⲪⲀⲒ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲪⲀⲒ ⲀⲚⲞⲚ ⲦⲈⲚⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ⲞⲨⲞϨ ⲚϦⲢⲎⲒ ϦⲈⲚⲪⲚⲀϨϮ ⲚⲦⲈⲠⲈϤⲢⲀⲚ ⲪⲀⲒ ⲈⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲦⲀϤⲦⲀⲖϬ ⲞϤ ⲞⲨⲞϨ ⲠⲒⲚⲀϨϮ ⲞⲨⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲠⲈ ⲀϤϮ ⲚⲀϤ ⲘⲠⲒⲞⲨϪⲀⲒ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ϮⲚⲞⲨ ⲆⲈ ⲚⲀⲤⲚⲎⲞⲨ ϮⲤⲰⲞⲨⲚ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲀⲒⲤ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦⲈⲘⲒ ⲘⲪⲢⲎϮ ⲚⲚⲈⲦⲈⲚⲔⲈⲀⲢⲬⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲎ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲈⲐⲢⲈ ⲠⲈϤⲬⲢⲤ ϢⲈⲠⲘⲔⲀϨ ⲀϤϪⲞⲔⲞⲨ ⲈⲂⲞⲖ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲞⲨⲚ ⲞⲨⲞϨ ⲔⲈⲦ ⲐⲎⲚⲞⲨ ⲈⲐⲢⲞⲨϤⲰϮ ⲈⲂⲞⲖ ⲚⲚⲈⲦⲈⲚⲚⲞⲂⲒ ϨⲞⲠⲰⲤ ⲚⲤⲈⲒ ⲚⲰⲦⲈⲚ ⲚϪⲈϨⲀⲚⲤⲎⲞⲨ ⲚⲬⲂⲞⲂ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠϨⲞ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ⲞⲨⲞϨ ⲈϤⲈⲦⲀⲞⲨⲞ ⲚⲰⲦⲈⲚ ⲘⲪⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲐⲀϢϤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ⲪⲀⲒ ⲈⲦⲈ ϨⲰϮ ⲠⲈ ⲚⲦⲈⲚⲒⲪⲎⲞⲨⲒ ϢⲞⲠϤ ⲈⲢⲰⲞⲨ ϢⲀ ⲠⲤⲎⲞⲨ ⲚⲦⲀⲪⲈ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ⲒⲤϪⲈⲚ ⲠⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ⲘⲰⲨⲤⲎⲤ ⲘⲈⲚ ⲀϤϪⲞⲤ ϪⲈ ⲈⲢⲈ ⲠϬⲞⲒⲤ ⲪⲚⲞⲨϮ ⲈϤⲈⲦⲞⲨⲚⲞⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲦⲈⲚⲤⲚⲎⲞⲨ ⲚⲀⲠⲀⲢⲎϮ ⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ⲔⲀⲦⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈϤⲚⲀϪⲞⲦⲞⲨ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ⲈⲤⲈϢⲰⲠⲒ ⲆⲈ ⲘⲮⲨⲬⲎ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲤⲚⲀⲤⲰⲦⲈⲘ ⲀⲚ ⲚⲤⲀⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲈϤⲰϮ ⲚϮⲮⲨⲬⲎ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲤⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ⲞⲨⲞϨ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲒⲤϪⲈⲚ ⲤⲀⲘⲞⲨⲎⲖ ⲚⲈⲘ ⲚⲎ ⲈⲦⲀⲨⲒ ⲘⲈⲚⲈⲚⲤⲰϤ ⲀⲨⲤⲀϪⲒ ⲞⲨⲞϨ ⲀⲨϨⲒⲰⲒϢ ⲈⲐⲂⲈ ⲚⲀⲒⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲈⲚϢⲎⲢⲒ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ϮⲆⲒⲀⲐⲎⲔⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲤⲈⲘⲚⲎⲦⲤ ⲚⲈⲘ ⲚⲈⲚⲒⲞϮ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲀⲂⲢⲀⲀⲘ ϪⲈ ⲈⲨⲈϢⲰⲠⲒ ⲈⲨⲤⲘⲀⲢⲰⲞⲨⲦ ϦⲈⲚⲠⲈⲔϪⲢⲞϪ ⲚϪⲈⲚⲒⲠⲀⲦⲢⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ⲚϢⲞⲢⲠ ⲘⲈⲚ ⲀⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤ ⲠⲈϤⲀⲖⲞⲨ ⲚⲰⲦⲈⲚ ⲀϤⲦⲀⲞⲨⲞϤ ⲈⲤⲘⲞⲨ ⲈⲢⲰⲦⲈⲚ ϪⲈⲬⲀⲤ ⲚⲦⲈⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ϨⲈⲚϤ ⲤⲀⲂⲞⲖ ⲚⲚⲈϤⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ⲈⲨⲤⲀϪⲒ ⲆⲈ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚϪⲈⲚⲒⲞⲨⲎⲂ ⲚⲈⲘ ⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ⲈⲨϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲨ ϪⲈ ⲚⲀⲨϮⲤⲂⲰ ⲘⲠⲒⲖⲀⲞⲤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨϨⲒⲰⲒϢ ϦⲈⲚⲒⲎⲤⲞⲨⲤ ⲚϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ϮⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲚⲞⲨϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲀⲨϨⲒⲦⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ϢⲀ ⲠⲈϤⲢⲀⲤϮ ⲚⲈⲀ ⲢⲞⲨϨⲒ ϨⲎⲆⲎ ϢⲰⲠⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ⲞⲨⲘⲎϢ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲀⲨⲚⲀϨϮ ⲞⲨⲞϨ ⲀⲨϢⲰⲠⲒ ⲚϪⲈⲦⲎⲠⲒ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲨⲈⲢ Ⲉ- ⲚϢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀ ⲠⲈϤⲢⲀⲤϮ ϢⲰⲠⲒ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲀⲢⲬⲰⲚ ⲚⲈⲘ ⲚⲞⲨⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ⲚⲈⲘ ⲀⲚⲚⲀ ⲚⲈⲘ ⲔⲀⲒⲀⲪⲀ ⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘ ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲠⲄⲈⲚⲞⲤ ⲚⲦⲈϮⲘⲈⲦⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲀϨⲰⲞⲨ ⲈⲢⲀⲦⲞⲨ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲚⲀⲨϢⲒⲚⲒ ⲘⲘⲰⲞⲨ ⲠⲈ ϪⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲀϢ ⲚϪⲞⲘ ⲒⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲀϢ ⲚⲢⲀⲚ ⲀⲢⲈⲦⲈⲚⲒⲢⲒ ⲘⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ⲦⲞⲦⲈ ⲠⲈⲦⲢⲞⲤ ⲀϤⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚⲒⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ⲒⲤϪⲈ ⲀⲚⲞⲚ ⲘⲪⲞⲞⲨ ⲤⲈⲈⲢⲀⲚⲀⲔⲢⲒⲚⲒⲚ ⲘⲘⲞⲚ ⲈⲐⲂⲈⲞⲨ ϨⲰⲂ ⲈⲚⲀⲚⲈϤ ⲈⲀϤϢⲰⲠⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚϪⲰⲂ ϪⲈ ⲈⲦⲀ ⲪⲀⲒ ⲞⲨϪⲀⲒ ϦⲈⲚⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ⲘⲀⲢⲈ ⲠⲒϨⲰⲂ ⲞⲨⲞⲚϨ ⲈⲢⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲦⲈⲠⲒⲤⲖ ϪⲈ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲦⲈⲚⲀϢϤ ⲪⲀⲒ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲚϦⲢⲎⲒ ϦⲈⲚⲪⲀⲒ ϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲪⲀⲒ ⲘⲠⲈⲦⲈⲚⲘⲐⲞ ⲈϤⲞⲨⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ⲪⲀⲒ ⲠⲈ ⲠⲒⲰⲚⲒ ⲈⲦⲀⲨϢⲞϢϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲎ ⲈⲦⲔⲰⲦ ⲪⲀⲒ ⲀϤϢⲰⲠⲒ ⲚⲞⲨϪⲰϪ ⲚⲖⲀⲔϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ⲞⲨⲞϨ ⲘⲘⲞⲚ ⲔⲈⲞⲨⲀⲒ ⲈⲢⲈ ⲪⲚⲞϨⲈⲘ ϢⲞⲠ ⲚϦⲎⲦϤ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲔⲈⲢⲀⲚ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲦⲪⲈ ⲈⲀⲨⲦⲎⲒϤ ⲚⲚⲒⲢⲰⲘⲒ ⲪⲎ ⲈⲦⲈϨⲰϮ ⲚⲦⲞⲨⲚⲞϨⲈⲘ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲦⲠⲀⲢⲢⲎⲤⲒⲀ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲘⲒ ϪⲈ ϨⲀⲚⲢⲰⲘⲒ ⲚⲈⲚⲤⲈⲤⲰⲞⲨⲚ ⲚⲤϦⲀⲒ ⲀⲚ ⲞⲨⲞϨ ϨⲀⲚⲒⲆⲒⲰⲦⲎⲤ ⲚⲈⲚⲀⲨⲈⲢϢⲪⲎⲢⲒ ⲠⲈ ⲚⲀⲨⲤⲰⲞⲨⲚ ⲆⲈ ⲘⲘⲰⲞⲨ ϪⲈ ⲚⲀⲨⲬⲎ ⲚⲈⲘ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ⲠⲒⲔⲈⲢⲰⲘⲒ ⲆⲈ ⲚⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲈⲘⲰⲞⲨ ⲈⲀϤⲞⲨϪⲀⲒ ⲚⲀⲨϢϮ ⲆⲈ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲨ ⲚϨⲖⲒ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ⲈⲦⲀⲨⲞⲨⲀϨⲤⲀϨⲚⲒ ⲆⲈ ⲚⲤⲈϨⲒⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲚⲚⲀⲀⲒϤ ⲚⲚⲀⲒⲢⲰⲘⲒ ⲞⲦⲒ ⲘⲈⲚ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲘⲎⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲤⲈⲤⲰⲞⲨⲚ ⲚϪⲈⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ ⲈϪⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ⲀⲖⲖⲀ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲒϨⲰⲂ ⲤⲰⲢ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲖⲀⲞⲤ ⲚϨⲞⲨⲞ ⲘⲀⲢⲈⲚⲚⲞϢⲠⲞⲨ ϨⲒⲚⲀ ⲚⲦⲞⲨϢⲦⲈⲘⲤⲀϪⲒ ⲚⲈⲘ ϨⲖⲒ ⲚⲢⲰⲘⲒ ϦⲈⲚⲠⲀⲒⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ⲞⲨⲞϨ ⲈⲦⲀⲨⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲀⲨϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϢⲦⲈⲘⲈⲢⲞⲨⲰ ⲈⲠⲦⲎⲢϤ ⲞⲨⲆⲈ ⲈϢⲦⲈⲘϮ ⲤⲂⲰ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ⲠⲈϪⲰⲞⲨ ⲚⲰⲞⲨ ⲒⲤϪⲈ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲦⲈ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲈⲤⲰⲦⲈⲘ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲈϨⲞⲦⲈ ⲪⲚⲞⲨϮ ⲘⲀϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲘⲘⲞⲚ ⲀⲚⲞⲚ ⲚⲎ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲚⲤⲞⲐⲘⲞⲨ ⲈϢⲦⲈⲘⲤⲀϪⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲚⲞϢⲠⲞⲨ ⲀⲨⲬⲀⲨ ⲈⲂⲞⲖ ⲘⲠⲞⲨϪⲈⲘ ϨⲖⲒ ⲚⲖⲰⲒϪⲒ ⲈⲢⲰⲞⲨ ⲈⲐⲂⲈ ⲠⲒⲢⲎϮ ⲚⲈⲢⲔⲞⲖⲀⲌⲒⲚ ⲘⲘⲰⲞⲨ ⲈⲐⲂⲈ ⲠⲒⲖⲀⲞⲤ ϪⲈ ⲚⲀⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈⲐⲂⲈ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ⲚⲈ ⲀϤⲈⲢϨⲞⲨⲞ ⲘⲚⲢⲞⲘⲠⲒ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲈⲦⲀ ⲠⲀⲒϨⲰⲂ ⲘⲘⲎⲒⲚⲒ ⲚⲞⲨϪⲀⲒ ϢⲰⲠⲒ ϨⲒⲰⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ⲈⲦⲀⲨⲬⲀⲨ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲒ ϢⲀ ⲚⲎ ⲈⲦⲈⲚⲰⲞⲨ ⲀⲨⲦⲀⲘⲰⲞⲨ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲒⲦⲞⲨ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲀⲨϬⲒⲤⲒ ⲚⲦⲞⲨⲤⲘⲎ ⲈϨⲢⲎⲒ ϨⲀ ⲪⲚⲞⲨϮ ⲈⲨⲤⲞⲠ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲈⲚⲚⲎⲂ ⲚⲐⲞⲔ ⲠⲈⲦⲀⲔⲐⲀⲘⲒⲞ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲪⲒⲞⲘ ⲚⲈⲘ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ⲪⲎ ⲈⲦⲀϤϪⲞⲤ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ ⲘⲠⲈⲚⲒⲰⲦ ⲆⲀⲨⲒⲆ ⲈⲐⲂⲈ ⲠⲈⲔⲀⲖⲞⲨ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲚϪⲈϨⲀⲚⲈⲐⲚⲞⲤ ϨⲀⲚⲖⲀⲞⲤ ⲀⲨⲈⲢⲘⲈⲖⲈⲦⲀⲚ ⲚϨⲀⲚⲠⲈⲦϢⲞⲨⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚϪⲈⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲦⲈⲠⲔⲀϨⲒ ⲚⲒⲔⲈⲀⲢⲬⲰⲚ ⲀⲨⲐⲰⲞⲨϮ ⲈⲨⲘⲀ ⲈϮ ⲞⲨⲂⲈ ⲠϬⲞⲒⲤ ⲚⲈⲘ ⲠⲈϤⲬⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ϦⲈⲚ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲄⲀⲢ ⲀⲨⲐⲰⲞⲨϮ ϦⲈⲚⲦⲀⲒⲠⲞⲖⲒⲤ ⲈϪⲈⲚ ⲠⲈⲔⲀⲖⲞⲨ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲀⲔⲐⲀϨⲤϤ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ⲚⲈⲘ ⲠⲞⲚⲦⲒⲞⲤ ⲠⲒⲖⲀⲦⲞⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲈⲐⲚⲞⲤ ⲚⲈⲘ ϨⲀⲚⲖⲀⲞⲤ ⲚⲦⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ⲈⲒⲢⲒ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀ ⲦⲈⲔϪⲒϪ ⲚⲈⲘ ⲠⲈⲔⲤⲞϬⲚⲒ ⲈⲢϢⲞⲢⲠ ⲈⲐⲢⲞⲨϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲠϬⲞⲒⲤ ⲤⲞⲘⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲞⲨϪⲰⲚⲦ ⲘⲎⲒⲤ ⲚⲚⲈⲔⲈⲂⲒⲀⲒⲔ ⲈⲐⲢⲞⲨⲤⲀϪⲒ ϦⲈⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ϦⲈⲚ ⲠϪⲒⲚⲐⲢⲈⲔⲤⲞⲨⲦⲰⲚ ⲦⲈⲔϪⲒϪ ⲈⲂⲞⲖ ⲈϨⲀⲚⲦⲀⲖϬⲞ ⲚⲈⲘ ϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎ ⲢⲒ ⲈⲐⲢⲞⲨϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲔⲀⲖⲞⲨ ⲈⲐⲞⲨⲀⲂ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲂϨ ⲀϤⲔⲒⲘ ⲚϪⲈⲠⲒⲘⲀ ⲈⲚⲀⲨⲐⲞⲨⲎⲦ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀⲨⲘⲞϨ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲚⲀⲨⲤⲀϪⲒ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲘⲠⲀⲢⲢⲎ ⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ⲚⲒⲘⲎϢ ⲆⲈ ⲈⲦⲀⲨⲚⲀϨϮ ⲚⲀⲨⲞⲒ ⲚⲞⲨϨⲎ ⲦⲚⲞⲨⲰⲦ ⲚⲈⲘ ⲞⲨⲮⲨⲬⲎ ⲚⲞⲨⲰⲦ ⲚⲈⲘⲘⲞⲚ ϨⲖⲒ ⲠⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲞⲨϨⲖⲒ ⲚⲦⲈⲚⲈϤϨⲨⲠⲀⲢⲬⲞⲚⲦⲀ ϪⲈ ⲚⲞⲨϤ ⲚⲈⲀⲖⲖⲀ ⲚⲀⲢⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ϢⲞⲠ ⲚⲰⲞⲨ ϦⲈⲚⲞⲨⲘⲈⲦϢⲪⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ⲈϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϪⲞⲘ ⲚⲀⲢⲈ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ϮⲚϮⲘⲈⲦⲘⲈⲐⲢⲈ ϦⲀ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲚϨⲘⲞⲦ ⲚⲀϤϨⲒϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ⲚⲈ ⲘⲘⲞⲚ ⲠⲈⲦⲈⲢⲬⲢⲒⲀ ⲄⲀⲢ ⲚϦⲎⲦⲞⲨ ⲠⲈ ⲚⲎ ⲄⲀⲢ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲒⲞϨⲒ ⲘⲘⲀⲨ ⲚⲀⲨϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ⲚⲀⲨⲒⲚⲒ ⲚⲦⲦⲒⲘⲎ ⲚⲚⲎ ⲈϢⲀⲨⲦⲎⲒⲦⲞⲨ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ⲚⲀⲨⲬⲰ ⲘⲘⲰⲞⲨ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲀⲨϮ ⲆⲈ ⲘⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲠⲈⲦⲈϤⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ⲒⲰⲤⲎⲪ ⲆⲈ ⲪⲎ ⲈⲦⲀⲨϮⲢⲈⲚϤ ϪⲈ ⲂⲀⲢⲤⲀⲂⲀⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦⲈ ⲪⲎ ⲠⲈ ⲈϢⲀⲨⲞⲨⲀϨⲘⲈϤ ϪⲈ ⲠϢⲎⲢⲒ ⲘⲠϮϨⲞ ⲈⲞⲨⲖⲈⲨⲒⲦⲎⲤ ⲠⲈ ⲚⲔⲨⲠⲢⲒⲞⲤ ϦⲈⲚⲠⲈϤⲄⲈⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ⲈⲞⲨⲞⲚⲦⲈϤ ⲒⲞϨⲒ ⲘⲘⲀⲨ ⲀϤⲦⲎⲒϤ ⲈⲂⲞⲖ ⲀϤⲒⲚⲒ ⲚⲚⲒⲬⲢⲎⲘⲀ ⲀϤⲬⲀⲨ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ⲞⲨⲢⲰⲘⲒ ⲆⲈ ϨⲰϤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲚⲈⲘ ⲤⲀⲠⲪⲒⲢⲀ ⲦⲈϤⲤϨⲒⲘⲒ ⲀϤϮ ⲚⲞⲨⲒⲞϨⲒ ⲈⲂⲞⲖ ϦⲀ ⲦⲈϤⲦⲒⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ⲈⲤⲤⲰⲞⲨⲚ ⲚϪⲈⲦⲈϤⲤϨⲒⲘⲒ ⲀϤⲰⲖⲒ ⲚϬⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲦⲒⲘⲎ ⲚⲦⲈⲠⲒⲒⲞϨⲒ ⲀϤⲒⲚⲒ ⲆⲈ ⲚⲞⲨⲘⲈⲢⲞⲤ ⲀϤⲬⲀⲨ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲈⲐⲂⲈⲞⲨ ⲀⲠⲤⲀⲦⲀⲚⲀⲤ ⲘⲀϨ ⲠⲈⲔϨⲎⲦ ⲈⲐⲢⲈⲔϪⲈⲘⲈⲐⲚⲞⲨϪ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲈⲐⲢⲈⲔⲰⲖⲒ ⲚϬⲒⲞⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲦⲒⲘⲎ ⲚⲦⲈⲠⲒⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ⲘⲎ ⲈϤϢⲞⲠ ⲚⲀϤϢⲞⲠ ⲚⲀⲔ ⲀⲚ ⲠⲈ ⲞⲨⲞϨ ⲈⲦⲀⲔⲦⲎⲒϤ ⲈⲂⲞⲖ ⲚⲀϤⲬⲎ ⲀⲚ ϦⲀ ⲦⲈⲔⲈⲜⲞⲨⲤⲒⲀ ⲈⲐⲂⲈⲞⲨ ϪⲈ ⲈⲦⲀⲔⲬⲀ ⲠⲀⲒϨⲰⲂ ϦⲈⲚⲠⲈⲔϨⲎⲦ ⲈⲦⲀⲔϪⲈⲘⲈⲐⲚⲞⲨϪ ⲈⲢⲰⲘⲒ ⲀⲚ ⲀⲖⲖⲀ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ⲈϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲀⲚⲀⲚⲒⲀⲤ ⲈⲚⲀⲒⲤⲀϪⲒ ⲀϤϨⲒ ⲀϤϨⲒ ⲠⲈϤⲐⲎⲞⲨ ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲚϪⲈⲚⲒⲀⲖⲰⲞⲨⲒ ⲀⲨϪⲞⲖϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲚϤ ⲈⲂⲞⲖ ⲀⲨⲐⲞⲘⲤϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀ ⲄϮ ⲚⲞⲨⲚⲞⲨ ⲚⲈⲤⲔⲒ ϢⲰⲠⲒ ⲀⲤⲒ ⲈϦⲞⲨⲚ ⲚϪⲈⲦⲈϤⲤϨⲒⲘⲒ ⲚⲤⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲦⲀϤϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ⲠⲈϪⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀⲤ ϪⲈ ⲀϪⲞⲤ ⲚⲎⲒ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚϮ ⲘⲠⲒⲒⲞϨⲒ ⲈⲂⲞⲖ ϦⲀ ⲚⲀⲒϨⲀⲦ ⲚⲐⲞⲤ ⲆⲈ ⲠⲈϪⲀⲤ ϪⲈ ⲀϨⲀ ϦⲀ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀⲤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲠⲀⲒϨⲰⲂ ϮⲘⲀϮ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠϬⲞⲒⲤ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲒϬⲀⲖⲀⲨϪ ⲚⲦⲈⲚⲎ ⲈⲦⲀⲨⲐⲰⲘⲤ ⲘⲠⲈϨⲀⲒ ⲤⲈⲬⲎ ϨⲒⲢⲈⲚ ⲚⲒⲢⲰⲞⲨ ⲤⲈⲚⲀϤⲒϮ ⲈⲂⲞⲖ ϨⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ⲀⲤϨⲈⲒ ⲆⲈ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲀⲤϨⲒ ⲠⲈⲤⲐⲎⲞⲨ ⲈⲦⲀⲨⲒ ⲈϦⲞⲨⲚ ⲚϪⲈⲚⲒϦⲈⲖϢⲒⲢⲒ ⲀⲨϪⲈⲘⲤ ⲈⲤⲘⲰⲞⲨⲦ ⲈⲦⲀⲨⲞⲖⲤ ⲈⲂⲞⲖ ⲀⲨⲬⲀⲤ ϦⲀⲦⲈⲚ ⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϨⲞϮ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ⲈⲂⲞⲖ ⲆⲈ ϨⲒⲦⲈⲚ ⲚⲈⲚϪⲒϪ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲀⲨϢⲞⲠ ⲠⲈ ⲚϪⲈϨⲀⲚⲘⲎϢ ⲘⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲚⲀⲨⲐⲞⲨⲎⲦ ⲦⲎⲢⲞⲨ ⲈⲨⲤⲞⲠ ϦⲀⲦⲈⲚ ϮⲤⲦⲞⲀ ⲚⲦⲈⲤⲞⲖⲞⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲚⲒⲤⲰϪⲠ ⲘⲘⲞⲚ ϨⲖⲒ ⲈⲢⲦⲞⲖⲘⲀⲚ ⲈⲦⲞⲘϤ ⲈⲢⲰⲞⲨ ⲀⲖⲖⲀ ⲚⲀⲢⲈ ⲠⲒⲖⲀⲞⲤ ϬⲒⲤⲒ ⲘⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ⲘⲀⲖⲖⲞⲚ ⲆⲈ ⲚⲀⲨⲞⲨⲞϨ ⲘⲘⲰⲞⲨ ⲈⲠϬⲞⲒⲤ ⲈⲨⲚⲀϨϮ ⲚϪⲈϨⲀⲚⲘⲎϢ ⲚⲢⲰⲘⲒ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ϨⲰⲤⲦⲈ ⲚⲤⲈⲒⲚⲒ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲈⲂⲞⲖ ϨⲒ ⲚⲒⲠⲖⲀⲦⲒⲀ ⲞⲨⲞϨ ⲚⲤⲈⲬⲀⲨ ϨⲒϪⲈⲚ ϨⲀⲚϬⲖⲞϪ ⲚⲈⲘ ϨⲀⲚⲘⲀ ⲚⲈⲚⲔⲞⲦ ϨⲒⲚⲀ ⲈϤⲚⲀⲤⲒⲚⲒⲰⲞⲨ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲔⲀⲚ ⲚⲦⲈⲦⲈϤϦⲎⲒⲂⲒ Ⲓ- ⲈϪⲈⲚ ⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ⲚⲀⲨⲚⲎⲞⲨ ⲆⲈ ⲠⲈ ⲚϪⲈⲚⲒⲘⲎϢ ⲚⲦⲈⲚⲒⲠⲞⲖⲒⲤ ⲈⲦⲔⲰϮ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲨⲒⲚⲒ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦϨⲎϢ ⲚⲦⲈⲚ ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ϢⲀⲨⲞⲨϪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲈⲘⲀϤ ⲈⲦⲈ ⲦϨⲈⲢⲈⲤⲒⲤ ⲚⲦⲈⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲀⲨⲘⲞϨ ⲚⲬⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ⲀⲨⲒⲚⲒ ⲚⲚⲞⲨϪⲒϪ ⲈϪⲈⲚ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲞⲨⲞϨ ⲀⲨⲬⲀⲨ ⲈⲠⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲚⲆⲎⲘⲞⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲞⲨⲰⲚ ⲚⲚⲒⲢⲰⲞⲨ ⲚⲦⲈⲠⲒϢⲦⲈⲔⲞ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ϪⲈ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲤⲀϪⲒ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲠⲒⲖⲀⲞⲤ ⲚⲚⲒⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲀⲒⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲀⲨϢⲞⲢⲠⲞⲨ ⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲀⲨϮⲤⲂⲰ ⲠⲈ ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲈⲘⲀϤ ⲀⲨⲐⲰⲞⲨϮ ⲈⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲚⲈⲘ ⲚⲒϦⲈⲖⲖⲞⲒ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ⲈⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ⲈⲐⲢⲞⲨⲒⲚⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ⲈⲦⲀⲨⲒ ⲆⲈ ⲚϪⲈⲚⲒϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲘⲠⲞⲨϪⲈⲘⲞⲨ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲈⲦⲀⲨⲔⲞⲦⲞⲨ ⲆⲈ ⲀⲨⲦⲀⲘⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚϪⲒⲘⲒ ⲘⲈⲚ ⲘⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ⲈϤϢⲞⲦⲈⲘ ϦⲈⲚⲦⲀϪⲢⲞ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲒⲢⲈϤⲀⲢⲈϨ ⲈⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲀⲦⲈⲚ ⲚⲒⲢⲰⲞⲨ ⲈⲦⲀⲨⲞⲨⲰⲚ ⲆⲈ ⲘⲠⲈⲚϪⲈⲘ ϨⲖⲒ ⲚϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒⲤⲀϪⲒ ⲚϪⲈⲚⲒⲤⲀⲦⲎ ⲄⲞⲨⲤ ⲚⲦⲈⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲀⲨⲦⲰⲘⲦ ⲈⲐⲂⲎⲦⲞⲨ ⲠⲈ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲀⲒ ⲈⲦⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲞⲨⲀⲒ ⲀϤⲦⲀⲘⲰⲞⲨ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲒⲢⲰⲘⲒ ⲈⲦⲀⲢⲈⲦⲈⲚⲬⲀⲨ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲤⲈⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈⲨϮⲤⲂⲰ ⲘⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ⲦⲞⲦⲈ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲚⲈⲘ ⲚⲒϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲀⲨⲈⲚⲞⲨ ⲚϪⲞⲚⲤ ⲀⲚ ⲚⲀⲨⲈⲢϨⲞϮ ⲄⲀⲢ ⲠⲈ ϦⲀⲦϨⲎ ⲘⲠⲒⲖⲀⲞⲤ ⲘⲎⲠⲰⲤ ⲚⲤⲈϨⲒⲰⲚⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ⲈⲦⲀⲨⲈⲚⲞⲨ ⲆⲈ ⲀⲨⲦⲀϨⲰⲞⲨ ⲈⲢⲀⲦⲞⲨ ϦⲈⲚⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲀϤϢⲈⲚⲞⲨ ⲚϪⲈⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϦⲈⲚⲞⲨϨⲞⲚϨⲈⲚ ⲀⲚϨⲞⲚϨⲈⲚ ⲈⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϢⲦⲈⲘϮⲤⲂⲰ ϦⲈⲚⲠⲀⲒⲢⲀⲚ ϨⲎⲠⲠⲈ ⲀⲦⲈⲦⲈⲚⲘⲞϨ ⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲦⲎⲢⲤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲦⲈⲚⲤⲂⲰ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲈⲚ ⲠⲤⲚⲞϤ ⲘⲠⲀⲒⲢⲰⲘⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲤⲈⲘⲠϢⲀ ⲚⲤⲰⲦⲈⲘ ⲚⲤⲀⲪⲚⲞⲨϮ ⲈϨⲞⲦⲈ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲀϤⲦⲞⲨⲚⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲈⲚ ⲚⲈⲦⲈⲚϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲈⲀⲢⲈⲦⲈⲚⲀϢϤ ⲈϪⲈⲚ ⲞⲨϢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ⲪⲀⲒ ⲀϤϬⲀⲤϤ ⲚϪⲈⲪⲚⲞⲨϮ ⲚϨⲞⲨⲒⲦ ⲚⲤⲰⲦⲎⲢ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲈϤⲞⲨⲒⲚⲀⲘ ⲈⲐⲢⲈϤϮ ⲚⲞⲨⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲒⲤⲖ ⲚⲈⲘ ⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈϨⲀⲚⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲦⲈⲚⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲦⲈⲚⲀⲒⲤⲀϪⲒ ⲚⲀⲒ ⲪⲚⲞⲨϮ ⲆⲈ ⲀϤϮ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲨϦⲢⲀϪⲢⲈϪ ⲚⲚⲞⲨⲚⲀϪϨⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨⲞⲨⲰϢ ⲈϦⲞⲐⲂⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ⲀϤⲦⲰⲚϤ ⲚϪⲈⲞⲨⲀⲒ ϦⲈⲚⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲞⲨⲪⲀⲢⲒⲤⲈⲞⲤ ⲠⲈ ⲠⲈϤⲢⲀⲚ ⲠⲈ ⲄⲀⲘⲀⲖⲒⲎ ⲖⲞⲨⲢⲈϤϮⲤⲂⲰ ⲠⲈ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲈϤⲦⲀⲒⲎ ⲞⲨⲦ ⲚⲦⲈⲚ ⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈϨⲒ ⲚⲒⲢⲰⲘⲒ ⲈⲂⲞⲖ ⲚⲞⲨⲔⲞⲨϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲚⲀⲒⲢⲰⲘⲒ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ϦⲀϪⲰⲞⲨ ⲄⲀⲢ ⲚⲚⲀⲒⲈϨⲞⲞⲨ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲞⲨⲀⲒ ϪⲈ ⲐⲈⲨⲦⲎⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲀⲨⲞⲨⲀϨⲞⲨ ⲚⲤⲰϤ ⲚϪⲈⲨⲚⲎⲠⲒ ⲚⲢⲰⲘⲒ ⲞⲨⲞϨ ⲈⲦⲀⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲚⲀⲢⲈ ⲠⲞⲨϨⲎⲦ ⲐⲎⲦ ⲚⲈⲘⲀϤ ⲀⲨⲂⲰⲖ ⲈⲂⲞⲖ ⲈⲀⲨϢⲰⲠⲒ ⲈϨⲀⲚϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ⲘⲈⲚⲈⲚⲤⲀ ⲪⲀⲒ ⲀϤⲦⲰⲚϤ ⲚϪⲈⲒⲞⲨⲆⲀⲤ ⲠⲒⲄⲀⲖⲒⲖⲈⲞⲤ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈϮⲈⲠⲒⲄⲢⲀⲪⲎ ⲞⲨⲞϨ ⲀϤⲤⲈⲔ ⲞⲨⲘⲎϢ ⲤⲀⲪⲀϨⲞⲨ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲒⲬⲈⲦ ⲀϤⲦⲀⲔⲞ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲚⲀⲢⲈ ⲠⲞⲨϨⲎⲦ ⲐⲎⲦ ⲚⲈⲘⲀϤ ⲀⲨⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ⲞⲨⲞϨ ϮⲚⲞⲨ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ϨⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲚⲀⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ⲬⲀⲨ ⲈⲂⲞⲖ ϪⲈ ⲈϢⲰⲠ ⲠⲀⲒⲤⲞϬⲚⲒ ⲒⲈ ⲠⲀⲒϨⲰⲂ ⲞⲨⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲠⲈ ⲒⲈ ϤⲚⲀⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ⲒⲤϪⲈ ⲞⲨⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲠⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲂⲞⲖϤ ⲈⲂⲞⲖ ⲘⲎⲠⲞⲦⲈ ⲚⲤⲈϪⲈⲘ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲢⲈϤϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ⲀⲨⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ⲀⲨⲘⲞⲨϮ ⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲰⲞⲨ ⲀⲨϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲈϢⲦⲈⲘϮⲤⲂⲰ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲀⲨⲬⲀϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲚⲀⲨⲘⲞϢⲒ ⲈⲨⲢⲀϢⲒ ⲈⲂⲞⲖ ϨⲀ ⲠϨⲞ ⲘⲠⲒⲘⲀ ⲚϮϨⲀⲠ ϪⲈ ⲀⲨⲈⲢⲠⲈⲘⲠϢⲀ ⲚϢⲞϢⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲀⲒⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ⲚⲀⲨϦⲈⲚ ⲠⲒⲈⲢⲪⲈⲒ ⲘⲘⲎⲚⲒ ⲠⲈ ⲞⲨⲞϨ ⲚⲤⲈⲬⲰ ⲚⲦⲞⲦⲞⲨ ⲈⲂⲞⲖ ⲀⲚ ⲈⲨϮⲤⲂⲰ ⲔⲀⲦⲀ ⲎⲒ ⲈⲨϨⲒⲰⲒϢ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲚⲀⲒⲈϨⲞⲞⲨ ⲈⲦⲀⲨⲀϢⲀⲒ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲬⲢⲈⲘⲢⲈⲘ ⲚⲦⲈⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲞⲨⲂⲈ ⲚⲒϨⲈⲂⲢⲈⲞⲤ ϪⲈ ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲀⲚ ⲠⲈ ⲈⲠⲒϢⲈⲘϢⲒ ⲘⲘⲎⲒⲚⲒ ⲚⲦⲈⲚⲞⲨⲬⲎⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ⲀⲠⲒⲒⲂ ⲆⲈ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲞⲨϮ ⲈⲠⲒⲘⲎϢ ⲚⲦⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲠⲈϪⲰⲞⲨ ⲚⲰⲞⲨ ⲠⲒϨⲰⲂ ⲢⲀⲚⲀⲚ ⲀⲚ ⲈⲐⲢⲈⲚⲬⲰ ⲚⲤⲰⲚ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲦⲈⲚϢⲈⲘϢⲒ ⲚϨⲀⲚⲦⲢⲀⲠⲈⲌⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ϪⲈⲘⲠϢⲒⲚⲒ ⲞⲨⲚ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲚⲌ ⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲨⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲰⲞⲨ ⲈⲨⲘⲈϨ ⲘⲠⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲤⲞⲪⲒⲀ ⲚⲦⲈⲚⲬⲀⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϮⲬⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ⲀⲚⲞⲚ ⲆⲈ ⲚⲦⲈⲚⲤⲢⲰϤⲦ ⲈϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲈⲘ ⲠⲒϢⲈⲘϢⲒ ⲚⲦⲈⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ⲞⲨⲞϨ ⲀⲠⲒⲤⲀϪⲒ ⲢⲀⲚⲰⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲀⲨⲤⲰⲦⲠ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲞⲨⲢⲰⲘⲒ ⲠⲈ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ⲚⲈⲘ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲈⲘ ⲠⲢⲞⲬⲰⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲔⲀⲚⲰⲢ ⲚⲈⲘ ⲦⲒⲘⲰⲚ ⲚⲈⲘ ⲠⲀⲢⲘⲈⲚⲀ ⲚⲈⲘ ⲚⲒⲔⲞⲖⲀⲞⲤ ⲠⲒϢⲈⲘⲘⲞ ⲚⲢⲈⲘⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ⲚⲀⲒ ⲈⲦⲀⲨⲦⲀϨⲰⲞⲨ ⲈⲢⲀⲦⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲂϨ ⲀⲨⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ⲞⲨⲞϨ ⲀⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲒⲀⲒ ⲀⲤⲀϢⲀⲒ ⲚϪⲈⲦⲎⲠⲒ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲘⲀϢⲰ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲘⲘⲎϢ ⲚⲦⲈⲚⲒⲞⲨⲎⲂ ⲀⲨⲤⲰⲦⲈⲘ ⲚⲤⲀⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ⲤⲦⲈⲪⲀⲚⲞⲤ ⲆⲈ ⲈϤⲘⲈϨ ⲚϨⲘⲞⲦ ⲚⲈⲘ ϪⲞⲘ ⲚⲀϤⲒⲢⲒ ⲚϨⲀⲚⲚⲒϢϮ ⲘⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎ ⲢⲒ ⲚⲈⲘ ϨⲀⲚϪⲞⲘ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲆⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲦⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲒⲖⲒⲂⲈⲢⲦⲒⲚⲞⲤ ⲚⲈⲘ ⲚⲒⲔⲨⲢⲒⲚⲚⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲢⲈⲘⲢⲀⲔⲞϮ ⲚⲈⲘ ⲚⲒⲢⲈⲘⲦⲔⲨⲖⲒⲔⲒⲀ ⲚⲈⲘ ϮⲀⲤⲒⲀ ⲈⲨⲔⲰϮ ⲚⲈⲘ ⲤⲦⲈⲪⲀⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ⲞⲨⲞϨ ⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ϮⲤⲞⲪⲒⲀ ⲚⲈⲘ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲦⲈⲚⲀϤⲤⲀϪⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ⲦⲞⲦⲈ ⲀⲨⲒ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈϤϪⲰ ⲚϨⲀⲚⲤⲀϪⲒ ⲚϪⲈⲞⲨⲀ ⲈⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ⲀⲨⲔⲒⲘ ⲆⲈ ⲈⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀϦ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲀⲨϨⲞⲖⲘⲈϤ ⲀⲨⲈⲚϤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘⲀ ⲚϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ⲀⲨⲦⲀϨⲞ ⲚϨⲀⲚⲘⲈⲦⲘⲈⲐⲢⲈⲨ ⲚⲚⲞⲨϪ ⲈⲢⲀⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲢⲰⲘⲒ ⲚϤⲬⲰ ⲚⲦⲞⲦϤ ⲈⲂⲞⲖ ⲀⲚ ⲈϤϪⲰ ⲚϨⲀⲚⲤⲀϪⲒ ⲚⲤⲀⲠⲀⲒⲘⲀ ⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ⲀⲚⲤⲰⲦⲈⲘ ⲄⲀⲢ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲚⲐⲞϤ ⲈⲐⲚⲀⲂⲈⲖ ⲠⲀⲒⲘⲀ ⲈⲐⲞⲨⲀⲂ ⲈⲂⲞⲖ ϤⲚⲀϢⲒⲂϮ ⲚⲚⲒⲤⲨⲚⲎⲐⲒⲀ ⲈⲦⲀϤⲦⲎ ⲒⲦⲞⲨ ⲈⲦⲞⲦⲈⲚ ⲚϪⲈⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ⲈⲦⲀⲨⲤⲞⲘⲤ ⲦⲎⲢⲞⲨ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲚϪⲈⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ϦⲈⲚⲠⲒⲘⲀⲚϮϨⲀⲠ ⲀⲨⲚⲀⲨ ⲈⲠⲈϤϨⲞ ⲘⲪⲢⲎϮ ⲘⲠϨⲞ ⲚⲞⲨⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ϪⲈ ⲀⲚ ⲚⲀⲒ ϢⲞⲠ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲚⲈⲚⲒⲞϮ ⲤⲰⲦⲈⲘ ⲪⲚⲞⲨϮ ⲚⲦⲈⲠⲰⲞⲨ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ ⲈϤⲬⲎ ⲈϨⲢⲎⲒ ϦⲈⲚϮⲘⲈⲤⲞⲠⲞⲦⲀⲘⲒⲀ ⲘⲠⲀⲦⲈϤϢⲰⲠⲒ ϦⲈⲚⲬⲀⲢⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲘⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲔⲔⲀϨⲒ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲔⲤⲨⲄⲄⲈⲚⲒⲀ ⲀⲘⲞⲨ ⲈⲠⲒⲔⲀϨⲒ ⲈϮⲚⲀⲦⲀⲘⲞⲔ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ⲦⲞⲦⲈ ⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲚⲦⲈⲚⲒⲬⲀⲖⲆⲈⲞⲤ ⲀϤϢⲰⲠⲒ ϦⲈⲚⲬⲀⲢⲢⲀⲚ ⲈⲂⲞⲖ ⲆⲈ ⲘⲘⲀⲨ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲈϤⲘⲞⲨ ⲚϪⲈⲠⲈϤⲒⲰⲦ ⲀϤⲞⲨⲞⲐⲂⲈϤ ⲈⲂⲞⲖ ⲈⲐⲢⲈϤϢⲰⲠⲒ ϦⲈⲚⲠⲀⲒⲔⲀϨⲒ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲈⲦⲈⲚϢⲞⲠ ϨⲒⲰⲦϤ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ⲘⲠⲈϤϮ ⲚⲀϤ ⲚⲞⲨⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ⲚϦⲎⲦϤ ⲞⲨⲆⲈ ⲞⲨϢⲈⲚⲦⲀⲦⲤⲒ ⲚⲦⲈⲞⲨϬⲀⲖⲞϪ ⲀϤⲰϢ ⲈⲦⲎⲒϤ ⲚⲀϤ ϦⲈⲚⲞⲨⲀⲘⲀϨⲒ ⲚⲈⲘ ⲠⲈϤϪⲢⲞϪ ⲘⲈⲚⲈⲚⲤⲰϤ ⲘⲘⲞⲚⲦⲈϤ ϢⲎⲢⲒ ⲆⲈ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ⲀⲪⲚⲞⲨϮ ⲆⲈ ⲤⲀϪⲒ ⲘⲠⲀⲒⲢⲎϮ ϪⲈ ⲈⲢⲈ ⲠⲈⲔϪⲢⲞϪ ⲈⲢⲢⲈⲘⲚϪⲰⲒⲖⲒ ϦⲈⲚⲞⲨⲔⲀϨⲒ ⲚϢⲈⲘⲘⲞ ⲞⲨⲞϨ ⲈⲨⲈⲀⲒⲦⲞⲨ ⲘⲂⲰⲔ ⲞⲨⲞϨ ⲈⲨⲈⲦϨⲈⲘⲔⲰⲞⲨ ⲚⲨ ⲚⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ⲞⲨⲞϨ ⲠⲒϢⲖⲰⲖ ⲈⲦⲞⲨⲚⲀⲈⲢⲂⲰⲔ ⲚⲀϤ ⲈⲒⲈϮϨⲀⲠ ⲈⲢⲞϤ ⲀⲚⲞⲔ ⲠⲈϪⲈ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲈⲨⲈⲒ ⲈⲂⲞⲖ ⲈⲨⲈϢⲈⲘϢⲒ ⲘⲘⲞⲒ ϦⲈⲚⲠⲀⲒⲘⲀ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ⲞⲨⲞϨ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨⲆⲒⲀⲐⲎⲔⲎ ⲚⲦⲈⲠⲤⲈⲂⲒ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀϤϪⲪⲈ ⲒⲤⲀⲀⲔ ⲞⲨⲞϨ ⲀϤⲤⲞⲨⲂⲎⲦϤ ϦⲈⲚⲠⲒⲘⲀϨⲎ ⲚⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲒⲤⲀⲀⲔ ⲀϤϪⲪⲈ ⲒⲀⲔⲰⲂ ⲒⲀⲔⲰⲂ ⲀϤϪⲪⲞ ⲘⲠⲒⲒⲂ ⲘⲠⲀⲦⲢⲒⲀⲢⲬⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ⲞⲨⲞϨ ⲚⲒⲠⲀⲦⲢⲒⲀⲢⲬⲎⲤ ⲀⲨⲬⲞϨ ⲈⲒⲰⲤⲎⲪ ⲀⲨⲦⲎⲒϤ ⲈⲂⲞⲖ ⲈϨⲢⲎⲒ ⲈⲬⲎⲘⲒ ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲪⲚⲞⲨϮ ⲬⲎ ⲚⲈⲘⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ⲀϤⲚⲀϨⲘⲈϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲐⲖⲨⲮⲒⲤ ⲦⲎⲢⲞⲨ ⲀϤϮ ⲚⲀϤ ⲚⲞⲨϨⲘⲞⲦ ⲚⲈⲘ ⲞⲨⲤⲞⲪⲒⲀ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲀⲢⲀⲰ ⲠⲞⲨⲢⲞ ⲚⲬⲎⲘⲒ ⲀϤⲬⲀϤ ⲚϨⲨⲄⲞⲨⲘⲈⲚⲞⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲬⲎⲘⲒ ⲚⲈⲘ ⲈϪⲈⲚ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲞⲨϨⲂⲰⲚ ⲈϪⲈⲚ ⲬⲎⲘⲒ ⲦⲎⲢϤ ⲚⲈⲘ ⲬⲀⲚⲀⲀⲚ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚⲐⲖⲨⲮⲒⲤ ⲞⲨⲞϨ ⲚⲀⲨϪⲈⲘ ⲤⲞⲨⲞ ⲀⲚ ⲠⲈ ⲚϪⲈⲚⲈⲚⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲒⲀⲔⲰⲂ ϪⲈ ⲤⲈϮ ⲤⲞⲨⲞ ⲈⲂⲞⲖ ϦⲈⲚⲬⲎⲘⲒ ⲀϤⲦⲀⲞⲨⲞ ⲚⲚⲈⲚⲒⲞϮ ⲚϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ⲞⲨⲞϨ ϦⲈⲚⲠⲒⲘⲀϨⲤⲞⲠ ⲂⲀϤⲞⲨⲞⲚϨϤ ⲚϪⲈⲒⲰⲤⲎⲪ ⲈⲚⲈϤⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲀⲠⲄⲈⲚⲞⲤ ⲚⲒⲰⲤⲎⲪ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲪⲀⲢⲀⲰ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ⲀϤⲞⲨⲰⲢⲠ ⲆⲈ ⲚϪⲈⲒⲰⲤⲎⲪ ⲀϤⲘⲞⲨϮ ⲈⲒⲀⲔⲰⲂ ⲠⲈϤⲒⲰⲦ ⲚⲈⲘ ⲦⲈϤⲤⲨⲄⲄⲈⲚⲒⲀ ⲦⲎⲢⲤ ⲈϨⲢⲎⲒ ϦⲈⲚⲞⲈ ⲘⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ⲀϤⲒ ⲆⲈ ⲚϪⲈⲒⲀⲔⲰⲂ ⲈϦⲢⲎⲒ ⲈⲬⲎⲘⲒ ⲞⲨⲞϨ ⲀϤⲘⲞⲨ ⲚⲐⲞϤ ⲚⲈⲘ ⲚⲈⲚⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ⲞⲨⲞϨ ⲀⲨⲞⲨⲞⲐⲂⲈϤ ⲈⲤⲨⲬⲈⲘ ⲀⲨⲬⲀϤ ϦⲈⲚⲠⲒⲘϨⲀⲨ ⲈⲦⲀϤϢⲞⲠϤ ⲚϪⲈⲀⲂⲢⲀⲀⲘ ϦⲀ ⲞⲨⲦⲒⲘⲎ ⲚϨⲀⲦ ⲚⲦⲞⲦⲞⲨ ⲚⲚⲈⲚϢⲎⲢⲒ ⲚⲈⲘⲰⲢ ϦⲈⲚⲤⲨⲬⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲆⲈ ⲈⲦⲀϤϦⲰⲚⲦ ⲚϪⲈⲠⲤⲎⲞⲨ ⲚⲦⲈϮⲈⲠⲀⲄⲄⲈⲖⲒⲀ ⲐⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲰⲢⲔ ⲈⲐⲂⲎⲦⲤ ⲚⲀⲂⲢⲀⲀⲘ ⲀϤⲀⲒⲀⲒ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲀϤⲀⲘⲀϨⲒ ⲀϤⲀϢⲀⲒ ⲚϨⲢⲎⲒ ϦⲈⲚⲬⲎⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ϢⲀⲚⲦⲈϤⲦⲰⲚϤ ⲚϪⲈⲔⲈⲞⲨⲢⲞ ⲈϪⲈⲚ ⲬⲎⲘⲒ ⲚϤⲤⲰⲞⲨⲚ ⲀⲚ ⲚⲒⲰⲤⲎⲪ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ⲪⲀⲒ ⲀϤϪⲈⲘ ⲞⲨⲤⲂⲰ ⲈϦⲞⲨⲚ ⲈⲠⲈⲚⲄⲈⲚⲞⲤ ⲀϤⲦϨⲈⲘⲔⲞ ⲚⲚⲈⲚⲒⲞϮ ⲈⲐⲢⲞⲨϨⲒⲞⲨⲒ ⲚⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ ⲈⲂⲞⲖ ⲈϢⲦⲈⲘⲦⲀⲚϦⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲘⲒⲤⲒ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲈⲞⲨⲀⲤⲦⲒⲞⲤ ⲠⲈ ⲘⲪⲚⲞⲨϮ ⲪⲀⲒ ⲀⲨϢⲀⲚⲞⲨϢϤ ⲚⲄ ⲚⲀⲂⲞⲦ ϦⲈⲚⲠⲎⲒ ⲘⲠⲈϤⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ⲈⲦⲀⲨϨⲒⲦϤ ⲆⲈ ⲈⲂⲞⲖ ⲀⲤⲞⲖϤ ⲚϪⲈⲦϢⲈⲢⲒ ⲘⲪⲀⲢⲀⲰ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ⲞⲨⲞϨ ⲀⲨⲦⲤⲀⲂⲈ ⲘⲰⲨⲤⲎⲤ ⲈⲤⲂⲰ ⲚⲒⲂⲈⲚ ⲚⲦⲈⲚⲒⲢⲈⲘⲚⲬⲎⲘⲒ ⲚⲀϤϪⲞⲢ ⲠⲈ ϦⲈⲚⲚⲈϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲈϤϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲘⲚⲢⲞⲘⲠⲒ ⲚⲤⲎⲞⲨ ⲀⲤⲒ ⲈϪⲈⲚ ⲠⲈϤϨⲎⲦ ⲈϪⲈⲘⲠϢⲒⲚⲒ ⲚⲚⲈϤⲤⲚⲎ ⲞⲨ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲞⲨⲀⲒ ⲈⲨϬⲒ ⲘⲘⲞϤ ⲚϪⲞⲚⲤ ⲀϤϢⲈⲚϨⲎⲦ ⲀϤⲒⲢⲒ ⲚⲞⲨϬⲒ ⲘⲠϢⲒϢ ⲘⲪⲎ ⲈⲚⲀⲨⲦϨⲈⲘⲔⲞ ⲘⲘⲞϤ ⲀϤϦⲰⲦⲈⲂ ⲘⲠⲒⲢⲈⲘⲚⲬⲎ ⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ⲈⲚⲀϤⲘⲈⲨⲒ ⲆⲈ ⲠⲈ ϪⲈ ⲤⲈⲚⲀⲔⲀϮ ⲚϪⲈⲚⲈϤⲤⲚⲎⲞⲨ ϪⲈ ⲪⲚⲞⲨϮ ⲚⲀϮ ⲚⲞⲨⲞⲨϪⲀⲒ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲐⲰⲞⲨ ⲆⲈ ⲘⲠⲞⲨⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤⲞⲨⲞⲚϨϤ ⲈϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲨⲘⲖⲀϦ ⲞⲨⲞϨ ⲚⲀϤϨⲰⲦⲠ ⲘⲘⲰⲞⲨ ⲠⲈ ⲈⲞⲨϨⲒⲢⲎⲚⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲢⲰⲘⲒ ⲚⲤⲚⲎⲞⲨ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚϬⲒ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲚϪⲞⲚⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ⲪⲎ ⲆⲈ ⲈⲦϬⲒ ⲘⲠⲈϤϢⲪⲎⲢ ⲚϪⲞⲚⲤ ⲀϤϪⲞⲖϤ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲈⲦⲀϤⲬⲀⲔ ⲚⲀⲢⲬⲰⲚ ⲒⲈ ⲢⲈϤϮϨⲀⲠ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ⲘⲎ ⲈⲔⲞⲨⲰϢ ⲈϦⲞⲐⲂⲈⲦ ⲚⲐⲞⲔ ⲘⲪⲢⲎϮ ⲈⲦⲀⲔϦⲰⲦⲈⲂ ⲘⲠⲒⲢⲈⲘⲚⲬⲎⲘⲒ ⲚⲤⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ⲀϤⲪⲰⲦ ⲆⲈ ⲚϪⲈⲘⲰⲨⲤⲎⲤ ϦⲈⲚⲠⲀⲒⲤⲀϪⲒ ⲀϤⲈⲢⲢⲈⲘⲚϪⲰⲒⲖⲒ ϦⲈⲚⲠⲔⲀϨⲒ ⲘⲘⲀⲆⲒⲀⲘ ⲠⲒⲘⲀ ⲈⲦⲀϤϪⲪⲈ ϢⲎⲢⲒ ⲂⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲘⲚⲢⲞⲘⲠⲒ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲞϤ ϦⲈⲚⲠϢⲀϤⲈ ⲚⲦⲈⲠⲦⲰⲞⲨ ⲚⲤⲒⲚⲀ ⲚϪⲈⲞⲨⲀⲄⲄⲈⲖⲞⲤ ϦⲈⲚⲞⲨϢⲀϨ ⲚⲬⲢⲰⲘ ϨⲒϪⲈⲚ ⲞⲨⲂⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ⲘⲰⲨⲤⲎⲤ ⲆⲈ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲒϨⲞⲢⲀⲘⲀ ⲀϤⲈⲢϢⲪⲎⲢⲒ ⲈϤⲚⲀⲒ ⲆⲈ ⲈϮⲚⲒⲀⲦϤ ⲀⲤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲘⲎ ⲚⲦⲈⲠϬⲞⲒⲤ ⲈⲤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲈⲔⲒⲞϮ ⲪⲚⲞⲨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲤⲀⲀⲔ ⲚⲈⲘ ⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ ⲀϤⲤⲐⲈⲢⲦⲈⲢ ⲆⲈ ⲚϪⲈⲘⲰⲨⲤⲎⲤ ⲘⲠⲈϤⲈⲢⲦⲞⲖⲘⲀⲚ ⲈϮⲚⲒⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲂⲰⲖ ⲘⲠⲒⲐⲰⲞⲨⲒ ⲈⲂⲞⲖ ϨⲒ ⲚⲈⲔϬⲀⲖⲀⲨϪ ⲠⲒⲘⲀ ⲄⲀⲢ ⲈⲦⲈⲔⲞϨⲒ ⲈⲢⲀⲦⲔ ϨⲒϪⲰϤ ⲞⲨⲔⲀϨⲒ ⲈϤⲞⲨⲀⲂ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ϦⲈⲚ ⲞⲨⲚⲀⲨ ⲀⲒⲚⲀⲨ ⲈⲠⲦϨⲈⲘⲔⲞ ⲘⲠⲀⲖⲀⲞⲤ ⲈⲦϦⲈⲚ ⲬⲎⲘⲒ ⲞⲨⲞϨ ⲀⲒⲤⲰⲦⲈⲘ ⲈⲠⲞⲨϤⲒⲀϨⲞⲘ ⲀⲒⲒ ⲈⲠⲈⲤⲎⲦ ⲈⲚⲀϨⲘⲞⲨ ϮⲚⲞⲨ ⲆⲈ ⲀⲘⲞⲨ ⲚⲦⲀⲞⲨⲞⲢⲠⲔ ⲈϨⲢⲎⲒ ⲈⲬⲎⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ⲪⲀⲒ ⲠⲈ ⲘⲰⲨⲤⲎⲤ ⲈⲦⲀⲨϪⲞⲖϤ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲘ ⲀϤⲬⲀⲔ ⲚⲀⲢⲬⲰⲚ ⲒⲈ ⲢⲈϤϮϨⲀⲠ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ⲪⲀⲒ ⲆⲈ ⲀⲪⲚⲞⲨϮ ⲦⲀⲞⲨⲞϤ ⲚⲀⲢⲬⲰⲚ ⲚⲈⲘ ⲢⲈϤⲤⲰϮ ϦⲈⲚⲦϪⲒϪ ⲘⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲪⲎ ⲈⲦⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲞϤ ϦⲈⲚⲠⲒⲂⲀⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ⲪⲎ ⲈⲦⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ ⲈⲀϤⲒⲢⲒ ⲚϨⲀⲚⲘⲎ ⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ϦⲈⲚⲠⲔⲀϨⲒ ⲚⲬⲎⲘⲒ ⲚⲈⲘ ⲪⲒⲞⲘ ⲚϢⲀⲢⲒ ⲚⲈⲘ ϦⲈⲚⲠϢⲀϤⲈ ⲚⲘⲚⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ⲪⲀⲒ ⲠⲈ ⲘⲰⲨⲤⲎⲤ ⲈⲦⲀϤϪⲞⲤ ⲚⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ϪⲈ ⲈⲢⲈ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲦⲈⲚⲤⲚⲎⲞⲨ ⲚⲀ ⲠⲀⲢⲎϮ ⲤⲰⲦⲈⲘ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ⲪⲀⲒ ⲠⲈⲦⲀϤϢⲰⲠⲒ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ϨⲒ ⲠϢⲀϤⲈ ⲚⲈⲘ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲀϤ ϨⲒϪⲈⲚ ⲠⲦⲰⲞⲨ ⲚⲤⲒⲚⲀ ⲚⲈⲘ ⲚⲈⲚⲒⲞϮ ⲪⲀⲒ ⲈⲦⲀϤϬⲒ ⲚϨⲀⲚⲤⲀϪⲒ ⲚⲰⲚϦ ⲈⲦⲎⲒⲦⲞⲨ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ⲪⲀⲒ ⲈⲦⲈ ⲘⲠⲞⲨⲞⲨⲰϢ ⲈⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ⲚϪⲈⲚⲈⲚⲒⲞϮ ⲀⲖⲖⲀ ⲀⲨⲬⲀϤ ⲞⲨⲞϨ ⲀⲨⲔⲞⲦⲞⲨ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲈϨⲢⲎⲒ ⲈⲬⲎⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲀⲀⲢⲰⲚ ϪⲈ ⲘⲀⲐⲀⲘⲒⲞ ⲚⲀⲚ ⲚϨⲀⲚⲚⲞⲨϮ ⲚⲀⲒ ⲈⲐⲚⲀⲤⲰⲔ ϦⲀϪⲰⲚ ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲘⲰⲨⲤⲎⲤ ⲈⲦⲀϤⲈⲚⲦⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲚⲬⲎⲘⲒ ⲚⲦⲈⲚⲤⲰⲞⲨⲚ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ⲞⲨⲞϨ ⲀⲨⲐⲀⲘⲒⲞ ⲚⲰⲞⲨ ⲚⲞⲨⲘⲀⲤⲒ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲈϨⲢⲎⲒ ⲘⲠⲒⲒⲆⲰⲖⲞⲚ ⲞⲨⲞϨ ⲀⲨⲞⲨⲚⲞϤ ϦⲈⲚⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲚⲞⲨϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ⲀϤⲔⲞⲦⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϢⲈⲘϢⲒ ⲚϮⲤⲦⲢⲀⲦⲒⲀ ⲚⲦⲈⲦⲪⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎ ⲞⲨⲦ ϨⲒ ⲠϪⲰⲘ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲈ ⲘⲎ ϨⲀⲚϦⲞⲖϦⲈⲖ ⲚⲈⲘ ϨⲀⲚϢⲞⲨϢⲰⲞⲨϢⲒ ⲀⲢⲈⲦⲈⲚⲈⲚⲞⲨ ⲚⲎⲒ ⲚϨⲢⲎⲒ ϨⲒ ⲠϢⲀϤⲈ ⲚⲘⲚⲢⲞⲘⲠⲒ ⲠⲎⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚϬⲒ ⲚϮⲤⲔⲨⲚⲎ ⲚⲦⲈⲘⲞⲖⲞⲬ ⲚⲈⲘ ⲠⲒⲤⲒⲞⲨ ⲚⲦⲈⲠⲈⲦⲈⲚⲚⲞⲨϮ ⲢⲎⲪⲀⲚ ⲚⲒⲦⲨⲠⲞⲤ ⲈⲦⲀⲢⲈⲦⲈⲚⲐⲀⲘⲒⲰⲞⲨ ⲈⲞⲨⲰϢⲦ ⲘⲘⲰⲞⲨ ⲈⲒⲈⲞⲨⲈⲦⲈⲂ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ⲈⲚⲒⲤⲀ ⲚⲦⲈⲂⲀⲂⲨⲖⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ϮⲤⲔⲨⲚⲎ ⲚⲦⲈϮⲘⲈⲦⲘⲈⲐⲢⲈ ⲐⲎ ⲈⲚⲀⲤ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ϨⲒ ⲠϢⲀϤⲈ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚϪⲈⲪⲎ ⲈⲦⲤⲀϪⲒ ⲚⲈⲘ ⲘⲰⲨⲤⲎⲤ ⲈⲐⲀⲘⲒⲞⲤ ⲔⲀⲦⲀ ⲠⲒⲦⲨⲠⲞⲤ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ⲐⲀⲒ ⲈⲦⲀⲨⲞⲖⲤ ⲈϦⲞⲨⲚ ⲚⲈⲘⲰⲞⲨ ⲈⲀⲨϢⲞⲠⲤ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲈⲚⲒⲞϮ ⲚⲈⲘ ⲒⲎⲤⲞⲨ ϦⲈⲚⲠⲒⲀⲘⲀϨⲒ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠϨⲞ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ϢⲀ ⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲆⲀⲨⲒⲆ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ⲪⲎ ⲈⲦⲀϤϪⲒⲘⲒ ⲚⲞⲨϨⲘⲞⲦ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲀϤⲈⲢⲈⲦⲒⲚ ⲈⲐⲀⲘⲒⲞ ⲚⲞⲨⲘⲀ ⲚϢⲰⲠⲒ ⲘⲪⲚⲞⲨϮ ⲚⲒⲀⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ⲤⲞⲖⲞⲘⲰⲚ ⲆⲈ ⲀϤⲔⲈⲦ ⲞⲨⲎⲒ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ⲀⲖⲖⲀ ⲚⲀⲢⲈ ⲠⲈⲦϬⲞⲤⲒ ϢⲞⲠ ⲀⲚ ϦⲈⲚϨⲀⲚⲘⲞⲨⲚⲔ ⲚϪⲒϪ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈ ⲠⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ϪⲈ ⲦⲪⲈ ⲠⲈ ⲠⲀⲐⲢⲞⲚⲞⲤ ⲠⲔⲀϨⲒ ⲆⲈ ⲠⲈ ⲪⲘⲀ ⲚⲤⲈⲘⲚⲒ ⲚⲦⲈⲚⲀϬⲀⲖⲀⲨϪ ⲀϢ ⲚⲎⲒ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲔⲞⲦϤ ⲚⲎⲒ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲒⲈ ⲀϢ ⲠⲈ ⲪⲘⲀ ⲚⲦⲈⲠⲀⲘⲀ ⲚⲈⲘⲦⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ⲘⲎ ⲦⲀϪⲒϪ ⲀⲚ ⲀⲤⲐⲀⲘⲒⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ⲚⲒⲚⲀϢϮ ⲚⲀϨⲂⲒ ⲞⲨⲞϨ ⲚⲀⲦⲤⲈⲂⲒ ϦⲈⲚⲠⲞⲨⲔⲈϨⲎⲦ ⲚⲈⲘ ⲚⲞⲨⲔⲈⲘⲀϢϪ ⲚⲐⲰⲦⲈⲚ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲦⲈⲦⲈⲚϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲪⲢⲎϮ ⲚⲚⲈⲦⲈⲚⲔⲈⲒⲞϮ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ⲚⲒⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲦⲈ ⲘⲠⲈ ⲚⲈⲦⲈⲚⲒⲞϮ ϬⲞϪⲒ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲀⲨϦⲰⲦⲈⲂ ⲚⲚⲎ ⲈⲦⲀⲨⲈⲢϢⲞⲢⲠ ⲚϨⲒⲰⲒϢ ⲘⲠϪⲒⲚⲒ ⲚⲦⲈⲠⲒⲐⲘⲎⲒ ⲪⲀⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲎⲒϤ ⲞⲨⲞϨ ⲀⲢⲈⲦⲈⲚϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ⲚⲐⲰⲦⲈⲚ ⲀⲢⲈⲦⲈⲚϬⲒ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲈϨⲀⲚⲐⲰϢ ⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲠⲈⲦⲈⲚⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀⲨⲤⲞⲐⲘⲞⲨ ⲚⲀⲨϢⲞⲠϢⲈⲠ ⲘⲠⲞⲨϨⲎⲦ ⲞⲨⲞϨ ⲚⲀⲨϦⲢⲀϪⲢⲈϪ ⲚⲚⲞⲨⲚⲀϪϨⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ⲤⲦⲈⲪⲀⲚⲞⲤ ⲆⲈ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲪⲚⲀϨϮ ⲀϤⲤⲞⲘⲤ ⲈϨⲢⲎⲒ ⲈⲦⲪⲈ ⲀϤⲚⲀⲨ ⲈⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲒⲎⲤⲞⲨⲤ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲨ ⲈⲚⲒⲪⲎⲞⲨⲒ ⲈⲨⲞⲨⲎⲚ ⲞⲨⲞϨ ⲠϢⲎⲢⲒ ⲘⲪⲢⲰⲘⲒ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ⲀⲨⲰϢ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲀⲨⲀⲘⲀϨⲒ ⲚⲚⲞⲨⲘⲀϢϪ ⲞⲨⲞϨ ⲀⲨϬⲞϪⲒ ⲈⲨⲤⲞⲠ ⲦⲎⲢⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ⲀⲨϨⲒⲦϤ ⲤⲀⲂⲞⲖ ⲚϮⲂⲀⲔⲒ ⲀⲨϨⲒⲰⲚⲒ ⲈϪⲰϤ ⲞⲨⲞϨ ⲚⲒⲘⲈⲐⲢⲈⲨ ⲀⲨⲬⲰ ⲚⲚⲞⲨϨⲂⲰⲤ ϦⲀⲢⲀⲦϤ ⲚⲞⲨϦⲈⲖϢⲒⲢⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ⲞⲨⲞϨ ⲀⲨϨⲒⲰⲚⲒ ⲈϪⲈⲚ ⲤⲦⲈⲪⲀⲚⲞⲤ ⲈϤϮϨⲞ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ϢⲈⲠ ⲠⲀⲠⲚⲈⲨⲘⲀⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲚⲈⲔⲈⲠ ⲠⲀⲒⲚⲞⲂⲒ ⲈⲢⲰⲞⲨ ⲪⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞϤ ⲀϤⲈⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲀϤϮⲘⲀϮ ⲠⲈ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈϤϦⲰⲦⲈⲂ ⲀϤϢⲰⲠⲒ ⲆⲈ ⲘⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲆⲒⲰⲄⲘⲞⲤ ⲈϪⲈⲚ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨⲤⲰⲢ ⲆⲈ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲈⲚⲒⲬⲰⲢⲀ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ⲦⲤⲀⲘⲀⲢⲒⲀ ϢⲀⲦⲈⲚ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲘⲘⲀⲨⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ⲀⲨⲰⲖⲒ ⲆⲈ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲈⲂⲞⲖ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲚⲢⲈϤⲈⲢϨⲞϮ ⲞⲨⲞϨ ⲀⲨⲒⲢⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲚⲈϨⲠⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲀϤϮ ⲞⲨⲂⲈ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈϤⲚⲀ ⲈϦⲞⲨⲚ ⲈⲚⲒⲎⲒ ⲈϤⲰϢϮ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ ⲈϤϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈⲠϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ⲚⲎ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲤⲰⲢ ⲈⲂⲞⲖ ⲚⲀⲨⲤⲒⲚⲒ ⲠⲈ ⲈⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲘⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲈⲦⲀϤⲒ ⲈϨⲢⲎⲒ ⲈⲞⲨⲠⲞⲖⲒⲤ ⲚⲦⲈⲦⲤⲀⲘⲀⲢⲒⲀ ⲀϤϨⲒⲰⲒϢ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲚϪⲈⲚⲒⲘⲎϢ ⲈⲨⲤⲞⲠ ⲈⲚⲎ ⲈⲚⲀⲢⲈ ⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲰ ⲘⲘⲰⲞⲨ ϦⲈⲚⲠϪⲒⲚⲐⲢⲞⲨⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲤⲈⲚⲀⲨ ⲈⲚⲒⲘⲎⲒⲚⲒ ⲈⲚⲀϤⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ⲞⲨⲘⲎϢ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲈ ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲀⲔⲀⲐⲀⲢⲦⲞⲚ ⲚⲈⲘⲰⲞⲨ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲰⲦⲞⲨ ⲈⲨⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϨⲀⲚⲔⲈⲘⲎϢ ⲆⲈ ⲈⲨϢⲎⲖ ⲈⲂⲞⲖ ⲚⲈⲘ ϨⲀⲚⲞⲨⲞⲚ ⲈⲨⲞⲒ ⲚϬⲀⲖⲈ ⲚⲀϤⲦⲀⲖϬⲞ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ϦⲈⲚϮⲠⲞⲖⲒⲤ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲒⲘⲰⲚ ⲚⲀϤϢⲞⲠ ⲚϢⲞⲢⲠ ⲠⲈ ϦⲈⲚϮⲠⲞⲖⲒⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲈϤⲞⲒ ⲚⲀⲬⲰ ⲈϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲠⲒϢⲖⲰⲖ ⲦⲎⲢϤ ⲚⲦⲈⲦⲤⲀⲘⲀⲢⲒⲀ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ⲪⲀⲒ ⲆⲈ ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲚⲀϤ ⲦⲎⲢⲞⲨ ⲠⲈ ⲚϪⲈⲚⲒⲔⲞⲨϪⲒ ⲚⲈⲘ ⲚⲒⲚⲒϢϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲐⲀⲒ ⲦⲈ ϮϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ ⲐⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ϮⲚⲒϢϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ⲚⲀⲨϮ ⲚϨⲐⲎⲞⲨ ⲚⲀϤ ⲦⲎⲢⲞⲨ ⲠⲈ ϪⲈ ⲚⲈⲀϤⲈⲢ ⲞⲨⲚⲒϢϮ ⲚⲬⲢⲞⲚⲞⲤ ⲠⲈ ⲈϤⲈⲢϨⲀⲖ ⲘⲘⲰⲞⲨ ϦⲈⲚⲚⲈϤⲘⲈⲦϨⲒⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ϨⲞⲦⲈ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲞⲨ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲀⲨⲚⲎⲞⲨ ⲠⲈ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ ⲈⲨϬⲒⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ⲤⲒⲘⲰⲚ ⲆⲈ ϨⲰϤ ⲈⲦⲀϤⲚⲀϨϮ ⲞⲨⲞϨ ⲈⲦⲀϤϬⲒⲰⲘⲤ ⲚⲀϤⲘⲎⲚ ⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲈϤⲚⲀⲨ ⲈⲚⲒⲘⲎⲒⲚⲒ ⲚⲈⲘ ⲚⲒⲚⲒϢϮ ⲚϪⲞⲘ ⲈⲨϢⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲀϤⲞⲒ ⲚϢⲪⲎⲢⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϪⲈ ⲀϮⲔⲈⲤⲀⲘⲀⲢⲒⲀ ϢⲈⲠ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲢⲞⲤ ⲀⲨⲞⲨⲰⲢⲠ ⲘⲠⲈⲦⲢⲞⲤ ⲚⲈⲘ ⲒⲰⲀⲚⲚⲎⲤ ϢⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ⲚⲀⲒ ⲈⲦⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲘⲀⲨ ⲚⲀⲨⲦⲰⲂϨ ⲈϪⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ⲚⲈⲘⲠⲀⲦⲈϤⲒ ⲄⲀⲢ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲘⲘⲰⲞⲨ ⲘⲀⲖⲖⲞⲚ ⲆⲈ ⲚⲀⲨϬⲒⲰⲘⲤ ⲠⲈ ⲈⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ⲦⲞⲦⲈ ⲀⲨⲬⲀϪⲒϪ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀⲨϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲚϪⲈⲤⲒⲘⲰⲚ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲬⲀϪⲒϪ ⲚⲦⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲤⲈϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲀϤⲒⲚⲒ ⲚⲰⲞⲨ ⲚϨⲀⲚⲬⲢⲎⲘⲀ ");
INSERT INTO copbhc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀ ⲠⲀⲒⲈⲢϢⲒϢⲒ ⲚⲎⲒ ϨⲰ ϨⲒⲚⲀ ⲪⲎ ⲈϮⲚⲀⲬⲀϪⲒϪ ⲈϪⲰϤ ⲚⲦⲈϤϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲠⲈⲔϨⲀⲦ ⲚⲈⲘⲀⲔ ⲈϤⲈϢⲰⲠⲒ ⲈⲠⲦⲀⲔⲞ ϪⲈ ϮⲆⲰⲢⲈⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲔⲘⲈⲨⲒ ⲈϪⲪⲞⲤ ⲚⲀⲔ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲬⲢⲎⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ⲚⲚⲈ ⲦⲞⲒ ϢⲰⲠⲒ ⲚⲀⲔ ⲞⲨⲆⲈ ⲔⲖⲎⲢⲞⲤ ϦⲈⲚⲠⲀⲒⲤⲀϪⲒ ⲠⲈⲔϨⲎⲦ ⲄⲀⲢ ⲤⲞⲨⲦⲰⲚ ⲀⲚ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ⲀⲢⲒⲘⲈⲦⲀⲚⲞⲒⲚ ⲞⲨⲚ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲔⲔⲀⲔⲒⲀ ⲐⲀⲒ ⲞⲨⲞϨ ⲦⲰⲂϨ ⲘⲠϬⲞⲒⲤ ⲀⲢⲎⲞⲨ ⲤⲈⲚⲀⲬⲀ ⲠⲀⲒⲘⲈⲨⲒ ⲚⲦⲈⲠⲈⲔϨⲎⲦ ⲚⲀⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ϮⲚⲀⲨ ⲈⲢⲞⲔ ϦⲈⲚⲞⲨⲬⲞⲖⲎ ⲚⲦⲈⲞⲨⲚϢⲀϢⲒ ⲚⲈⲘ ⲞⲨⲤⲚⲀⲨϨ ⲚⲦⲈⲦⲀⲆⲒⲔⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲤⲒⲘⲰⲚ ⲠⲈϪⲀϤ ϪⲈ ⲦⲰⲂϨ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲚⲐⲰⲦⲈⲚ ϨⲀ ⲠϬⲞⲒⲤ ϨⲒⲚⲀ ϪⲈ ⲚⲚⲈ ϨⲖⲒ ⲚⲚⲎ ⲈⲦⲀⲢⲈⲦⲈⲚϪⲞⲦⲞⲨ ⲒⲈϨⲢⲎⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲈⲢⲘⲈⲐⲢⲈ ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲘⲎϢ ⲚϮⲘⲒ ⲚⲦⲈⲚⲒⲤⲀⲘⲀⲢⲒⲦⲎ ⲤⲚⲀⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲪⲒⲖⲒⲠⲠⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲘⲪⲚⲀⲨ ⲘⲘⲈⲢⲒ ⲈϪⲈⲚ ⲠⲒⲘⲰⲒⲦ ⲈⲦⲈⲔⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲄⲀⲌⲀ ⲪⲀⲒ ⲞⲨϢⲀϤⲈ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤϢⲈ ⲚⲀϤ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲈⲐⲰϢ ⲚⲤⲒⲞⲨⲢ ⲚⲢⲈⲘⲚϪⲞⲘ ⲚⲔⲀⲚⲆⲀⲔⲎⲤ ⲚⲦⲈϮⲞⲨⲢⲰ ⲚⲦⲈⲚⲒⲈⲐⲀⲨϢ ⲪⲀⲒ ⲚⲀϤⲬⲎ ϨⲒϪⲈⲚ ⲦⲈⲤⲄⲀⲌⲀ ⲦⲎⲢⲤ ⲚⲈⲀϤⲒ ⲠⲈ ⲈⲞⲨⲰϢⲦ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ⲚⲈⲀϤⲔⲞⲦϤ ⲆⲈ ⲠⲈ ⲈϤϨⲈⲘⲤⲒ ϨⲒ ⲠⲈϤϨⲀⲢⲘⲀ ⲞⲨⲞϨ ⲚⲀϤⲰϢ ⲠⲈ ϨⲒ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲎⲤⲀⲎⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ⲠⲈϪⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲆⲈ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲦⲞⲘⲔ ⲈⲠⲀⲒϨⲀⲢⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ⲀϤϬⲞϪⲒ ⲆⲈ ⲚϪⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈϤⲰϢ ϨⲒ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲎⲤⲀⲎⲀⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ϨⲀⲢⲀ ⲔⲤⲰⲞⲨⲚ ⲚⲚⲎ ⲈⲦⲈⲔⲰϢ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲠⲰⲤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲒ ⲈⲈⲘⲒ ⲀⲢⲈϢⲦⲈⲘ ⲞⲨⲀⲒ ϬⲒⲘⲰⲒⲦ ⲚⲎⲒ ⲀϤⲦⲰⲂϨ ⲆⲈ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈϤⲀⲖⲎ ⲒⲚⲦⲈϤϨⲈⲘⲤⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ⲪⲘⲀ ⲆⲈ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲦⲈⲚⲀϤⲰϢ ⲘⲘⲞϤ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲈⲤⲰⲞⲨ ⲈⲨⲚⲀⲈⲚϤ ⲈⲠϦⲞⲖϦⲈⲖ ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲚⲞⲨϨⲒⲎⲂ ⲚⲀⲦϦⲢⲰⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲎ ⲈⲦϦⲰⲔ ⲘⲘⲞϤ ⲠⲀⲒⲢⲎϮ ⲚϤⲞⲨⲰⲚ ⲚⲢⲰϤ ⲀⲚ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ⲀⲨⲰⲖⲒ ⲘⲠⲈϤϨⲀⲠ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲈϤⲐⲈⲂⲒⲞ ⲦⲈϤⲄⲈⲚⲈⲀ ⲆⲈ ⲚⲒⲘ ⲠⲈⲐⲚⲀϢⲤⲀϪⲒ ⲈⲢⲞⲤ ϪⲈ ⲤⲈⲚⲀⲰⲖⲒ ⲘⲠⲈϤⲰⲚϦ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒⲤⲒⲞⲨⲢ ⲠⲈϪⲀϤ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ϪⲈ ϮϮϨⲞ ⲈⲢⲞⲔ ⲘⲀⲦⲀⲘⲞⲒ ϪⲈ ⲈⲢⲈ ⲠⲀⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲰ ⲘⲪⲀⲒ ⲈⲐⲂⲈ ⲚⲒⲘ ⲈⲐⲂⲎⲦϤ ϢⲀⲚ ⲈⲐⲂⲈ ⲔⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ⲀϤⲞⲨⲰⲚ ⲆⲈ ⲚⲢⲰϤ ⲚϪⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲀϤ ⲚⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲒⲄⲢⲀⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ϨⲰⲤ ⲆⲈ ⲈⲨⲘⲞϢⲒ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲀⲨⲒ ϨⲒϪⲈⲚ ⲞⲨⲘⲰⲞⲨ ⲠⲈϪⲈ ⲠⲒⲤⲒⲞⲨⲢ ϪⲈ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲘⲰⲞⲨ ⲞⲨ ⲠⲈ ⲈⲦⲦⲀϨⲚⲞ ⲘⲘⲞⲒ ⲈϬⲒⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲦⲀϨⲚⲞ ⲘⲠⲒϨⲀⲢⲘⲀ ⲞⲨⲞϨ ⲀⲨⲒ ⲈϦⲢⲎⲒ ⲈⲠⲒⲘⲰⲞⲨ ⲘⲠⲂ ⲚϪⲈⲪⲒⲖⲒⲠⲠⲞⲤ ⲚⲈⲘ ⲠⲒⲤⲒⲞⲨⲢ ⲞⲨⲞϨ ⲀϤϮⲰⲘⲤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲰⲞⲨ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤϨⲰⲖⲈⲘ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲞⲨⲞϨ ⲘⲠⲈϤϪⲈⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲠⲒⲤⲒⲞⲨⲢ ⲚⲀϤⲘⲞϢⲒ ⲄⲀⲢ ϨⲒ ⲠⲈϤⲘⲰⲒⲦ ⲈϤⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ⲪⲒⲖⲒⲠⲠⲞⲤ ⲆⲈ ⲀⲨϪⲈⲘϤ ϦⲈⲚⲀⲌⲰⲦⲞⲤ ⲚⲀϤⲔⲰϮ ⲠⲈ ⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ϦⲈⲚⲚⲒⲠⲞⲖⲒⲤ ⲦⲎⲢⲞⲨ ϢⲀⲦⲈϤⲒ ⲈϨⲢⲎⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲒ ⲈϤⲘⲈϨ ⲚϪⲰⲚⲦ ⲚⲈⲘ ϦⲰⲦⲈⲂ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲒ ϢⲀ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ⲀϤⲈⲢⲈⲦⲒⲚ ⲚϨⲀⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲞⲦϤ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ϢⲀ ⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ϨⲒⲚⲀ ⲚⲎ ⲈⲦⲈϤⲚⲀϪⲈⲘⲞⲨ ⲈⲚⲀ ⲠⲒⲘⲰⲒⲦ ⲚⲈⲚⲒⲢⲰⲘⲒ ⲚⲈⲘ ⲚⲒϨⲒⲞⲘⲒ ⲚⲦⲈϤⲤⲞⲚϨⲞⲨ ⲚⲦⲈϤⲈⲚⲞⲨ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ⲈⲦⲀϤⲘⲞϢⲒ ⲆⲈ ⲀⲤϢⲰⲠⲒ ⲈⲦⲀϤϦⲰⲚⲦ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲚϪⲈⲞⲨⲞⲨⲰⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲒ ⲈϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲀϤⲤⲰⲦⲈⲘ ⲈⲞⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ϪⲈ ⲤⲀⲞⲨⲖ ⲤⲀⲞⲨⲖ ⲀϦⲞⲔ ⲈⲔϬⲞϪⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ⲠⲈϪⲀϤ ⲆⲈ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠϬⲞⲒⲤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲚⲐⲞⲔ ⲈⲦⲈⲔϬⲞϪⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ⲀⲖⲖⲀ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϨⲢⲎⲒ ⲈϮⲠⲞⲖⲒⲤ ⲈⲨⲈⲤⲀϪⲒ ⲚⲈⲘⲀⲔ ⲘⲠⲈⲦⲤϢⲈ ⲚⲦⲈⲔⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ⲚⲒⲢⲰⲘⲒ ⲆⲈ ⲈⲚⲀⲨⲘⲞϢⲒ ⲚⲈⲘⲀϤ ⲚⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲈⲨⲦⲰⲘⲦ ⲈⲨⲤⲰⲦⲈⲘ ⲈϮⲤⲘⲎ ⲈⲚⲀⲨⲚⲀⲨ ⲈϨⲖⲒ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲤⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲚⲀⲨⲞⲨⲎⲚ ⲠⲈ ⲚϪⲈⲚⲈϤⲂⲀⲖ ⲚⲀϤⲚⲀⲨ ⲆⲈ ⲈϨⲖⲒ ⲀⲚ ⲠⲈ ⲀⲨⲀⲘⲀϨⲒ ⲆⲈ ⲚⲦⲈϤϪⲒϪ ⲀⲨⲞⲖϤ ⲈϨⲢⲎⲒ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ⲀϤⲈⲢⲄ ⲚⲈϨⲞⲞⲨ ⲘⲘⲀⲨ ⲚϤⲚⲀⲨ ⲘⲂⲞⲖ ⲀⲚ ⲘⲠⲈϤⲞⲨⲰⲘ ⲞⲨⲆⲈ ⲘⲠⲈϤⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ϦⲈⲚⲆⲀⲘⲀⲤⲔⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ⲚⲀϤ ϦⲈⲚⲞⲨϨⲞⲢⲀⲘⲀ ϪⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲒϦⲒⲢ ⲈⲦⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲤⲞⲨⲦⲰⲚ ⲔⲰϮ ϦⲈⲚⲠⲎⲒ ⲚⲞⲨⲒⲞⲨⲆⲀⲒ ⲚⲤⲀⲪⲎ ⲈⲦⲈ ⲠⲈϤⲢⲀⲚ ⲠⲈ ⲤⲀⲨⲖⲞⲤ ⲠⲒⲢⲈⲘⲐⲀⲢⲤⲞⲤ ϨⲎⲠⲠⲈ ⲈⲦⲀϤⲦⲰⲂϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲞⲨⲢⲰⲘⲒ ϦⲈⲚⲞⲨϨⲞⲢⲀⲘⲀ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ϨⲒϪⲰϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲚⲀⲨ ⲘⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ⲀϤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈⲀⲚⲀⲚⲒⲀⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲀⲒⲤⲰⲦⲈⲘ ⲈⲐⲂⲈ ⲠⲀⲒⲢⲰⲘⲒ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲈⲐⲂⲈ ⲚⲒⲠⲈⲦϨⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲚⲦⲀⲔ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ⲞⲨⲞϨ ϦⲈⲚⲠⲀⲒⲔⲈⲘⲀ ⲞⲚ ⲞⲨⲞⲚⲦⲈϤ ⲈⲢϢⲒϢⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲤⲰⲚϨ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲦⲰⲂϨ ⲘⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ϪⲈ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲚⲤⲰⲦⲠ ⲚⲎⲒ ⲠⲈ ⲪⲀⲒ ⲈϤⲚⲀⲦⲰⲞⲨⲚ ϦⲀ ⲠⲀⲢⲀⲚ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲚⲈⲘ ⲚⲒⲞⲨⲢⲰⲞⲨ ⲚⲈⲘ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ⲀⲚⲞⲔ ⲄⲀⲢ ϮⲚⲀⲦⲀⲘⲞϤ ⲈⲚⲒⲘⲔⲀⲨϨ ⲦⲎⲢⲞⲨ ⲈⲦⲈϤⲚⲀϬⲒⲦⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲀⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ⲀϤϢⲈ ⲚⲀϤ ⲆⲈ ⲚϪⲈⲀⲚⲀⲚⲒⲀⲤ ⲞⲨⲞϨ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲎⲒ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ⲈϪⲰϤ ⲠⲈϪⲀϤ ϪⲈ ⲤⲀⲞⲨⲖ ⲠⲀⲤⲞⲚ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲪⲎ ⲈⲦⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲞⲔ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲈⲦⲈⲔⲚⲎⲞⲨ ϨⲒⲰⲦϤ ϨⲒⲚⲀ ⲚⲦⲈⲔⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲦⲈⲔⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ⲞⲨⲞϨ ⲚⲬⲰⲖⲈⲘ ⲀⲨϨⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤⲂⲀⲖ ⲚϪⲈϨⲀⲚⲔⲎⲔⲤ ⲀϤⲚⲀⲨ ⲘⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲀϤϬⲒⲰⲘⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ⲈⲦⲀϤϬⲒ ⲚⲞⲨϦⲢⲈ ⲀϤϪⲈⲘϪⲞⲘ ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϨⲀⲚⲈϨⲞⲞⲨ ⲚⲈⲘ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲦϦⲈⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤϨⲒⲰⲒϢ ⲚⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ⲚⲀⲨⲦⲰⲘⲦ ⲆⲈ ⲦⲎⲢⲞⲨ ⲠⲈ ⲚϪⲈⲚⲎ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲪⲀⲒ ⲀⲚ ⲠⲈ ⲪⲎ ⲈⲚⲀϤϢⲐⲞⲢⲦⲈⲢ ⲚⲚⲎ ⲈⲦⲦⲰⲂϨ ⲘⲠⲀⲒⲢⲀⲚ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲠⲀⲒⲘⲀ ⲈⲠⲀⲒϨⲰⲂ ϨⲒⲚⲀ ⲚⲦⲈϤⲤⲞⲚϨⲞⲨ ⲚⲦⲈϤϬⲒⲦⲞⲨ ⲈϨⲢⲎⲒ ϢⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲘⲀⲖⲖⲞⲚ ⲚⲀϤⲚⲎⲞⲨ ⲚϪⲈⲘϪⲞⲘ ⲞⲨⲞϨ ⲚⲀϤϢⲐⲞⲢⲦⲈⲢ ⲚⲚⲒⲞⲨⲆⲀⲒ ⲈⲦϦⲈⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲈϤⲦⲀⲘⲞ ⲘⲘⲰⲞⲨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲀⲨⲈⲢ ⲞⲨⲤⲞϬⲚⲒ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϨⲒⲚⲀ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ⲀⲨⲦⲀⲘⲈ ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲠⲞⲨⲤⲞϬⲚⲒ ⲚⲀⲨⲀⲢⲈϨ ⲆⲈ ⲈⲚⲒⲠⲨⲖⲎ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲈⲘ ⲠⲒⲈϪⲰⲢϨ ϨⲒⲚⲀ ⲚⲤⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ⲀⲨⲞⲖϤ ⲆⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚϪⲰⲢϨ ⲀⲨⲬⲀϤ ⲈϦⲢⲎⲒ ϦⲈⲚⲞⲨⲂⲒⲢ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒⲤⲞⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ⲈⲦⲀϤⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲀϤϬⲰⲚⲦ ⲘⲘⲞϤ ⲈⲦⲞⲘϤ ⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϨⲞϮ ϦⲀⲦⲈϤϨⲎ ⲦⲎⲢⲞⲨ ⲠⲈ ⲚⲤⲈⲦⲈⲚϨⲞⲨⲦ ⲘⲘⲞϤ ⲀⲚ ϪⲈ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲀϤⲀⲘⲀϨⲒ ⲘⲘⲞϤ ⲀϤⲈⲚϤ ϢⲀ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ϪⲈ ⲚⲀϢ ⲚⲢⲎϮ ⲀϤⲚⲀⲨ ⲈⲠϬⲞⲒⲤ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ϪⲈ ⲚⲀϢ ⲚⲢⲎϮ ⲀϤⲞⲨⲞⲚϨϤ ϦⲈⲚⲆⲀⲘⲀⲤⲔⲞⲤ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ⲞⲨⲞϨ ⲚⲀϤϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲠⲈ ⲈϤⲚⲀ ⲈϦⲞⲨⲚ ⲚⲈⲘ ⲈⲂⲞⲖ ⲚⲈⲘⲰⲞⲨ ⲈϤⲞⲨⲰⲚϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ⲚⲀϤⲤⲀϪⲒ ⲆⲈ ⲠⲈ ⲚⲀϤϢⲒⲚⲒ ⲚⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲞⲨⲰϢ ⲈⲒⲚⲒ ⲚⲚⲞⲨϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ⲈⲦⲀⲨⲈⲘⲒ ⲆⲈ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲀⲨⲈⲚϤ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲀⲨⲞⲨⲞⲢⲠϤ ⲈϨⲢⲎⲒ ⲈⲐⲀⲢⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲈⲚ ⲞⲨⲚ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ϮⲄⲀⲖⲒⲖⲈⲀ ⲚⲈⲘ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲚⲈⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲘⲘⲀⲨ ⲈⲨⲔⲎⲦ ⲞⲨⲞϨ ⲈⲨⲘⲎⲚ ϦⲈⲚϮϨⲞϮ ⲚⲦⲈⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ⲚⲀⲒⲀⲒ ϦⲈⲚⲠⲒⲐⲰⲦ ⲚϨⲎⲦ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲢⲈ ⲠⲈⲦⲢⲞⲤ ⲚⲀⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲤⲚⲎⲞⲨ ⲦⲎⲢⲞⲨ ⲀϤⲒ ϢⲀ ⲚⲒⲀⲄⲒⲞⲤ ⲈⲦϢⲞⲠ ϦⲈⲚⲖⲨⲆⲆⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ⲀϤϪⲈⲘ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ⲘⲘⲀⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲚⲈⲀ ⲈⲀϤⲈⲢ ⲎⲚⲢⲞⲘⲠⲒ ⲈϤϢⲦⲎⲞⲨⲦ ϨⲒϪⲈⲚ ⲞⲨϬⲖⲞϪ ⲪⲀⲒ ⲆⲈ ⲚⲀϤϢⲎⲖ ⲈⲂⲞⲖ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲈⲚⲈⲀ ϤⲦⲀⲖϬⲞ ⲘⲘⲞⲔ ⲚϪⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲦⲰⲚⲔ ⲪⲰⲢϢ ϦⲀⲢⲞⲔ ⲤⲀⲦⲞⲦϤ ⲀϤⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ⲀⲨⲚⲀⲨ ⲆⲈ ⲈⲢⲞϤ ⲦⲎⲢⲞⲨ ⲚϪⲈⲚⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲖⲨⲆⲆⲀ ⲚⲈⲘ ⲤⲀⲢⲰⲚ ⲚⲎ ⲈⲦⲀⲨⲔⲞⲦⲞⲨ ⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲒⲞⲠⲠⲎ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲚⲤϨⲒⲘⲒ ⲘⲘⲀⲨ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲦⲀⲂⲒⲐⲀ ⲐⲎ ⲈⲦⲈϢⲀⲨⲞⲨⲀϨⲘⲈⲤ ⲚⲤⲈⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ϮϬⲀϨⲤⲒ ⲐⲀⲒ ⲚⲀⲤⲘⲈϨ ⲚϨⲰⲂ ⲚⲀⲄⲀⲐⲞⲚ ⲚⲈⲘ ⲚⲒⲘⲈⲐⲚⲀⲎⲦ ⲈⲚⲀⲤⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲤϢⲰⲚⲒ ⲀⲤⲘⲞⲨ ⲈⲦⲀⲨϪⲞⲔⲘⲈⲤ ⲆⲈ ⲀⲨⲬⲀⲤ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲤⲀⲠϢⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ⲚⲀⲢⲈ ⲖⲨⲆⲆⲀ ⲆⲈ ⲚⲀⲤϦⲈⲚⲦ ⲈⲒⲞⲠⲠⲎ ⲠⲈ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲚ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ϤⲘⲘⲀⲨ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀⲨⲞⲨⲰⲢⲠ ⲚⲢⲰⲘⲒ Ⲃ- ϨⲀⲢⲞϤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲈⲨⲦⲰⲂϨ ⲘⲘⲞϤ ϪⲈ ⲘⲠⲈⲢϬⲚⲀⲨ ⲈⲒ ϨⲀⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤⲘⲞϢⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲦⲀϤⲒ ⲆⲈ ⲀⲨⲞⲖϤ ⲈϨⲢⲎⲒ ⲈⲚⲒⲘⲀ ⲈⲦⲤⲀⲠϢⲰⲒ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲀϨⲢⲀϤ ⲚϪⲈⲚⲒⲬⲎⲢⲀ ⲦⲎⲢⲞⲨ ⲈⲨⲢⲒⲘⲒ ⲈⲨⲦⲀⲘⲞ ⲘⲘⲞϤ ⲈⲚⲒϢⲐⲎⲚ ⲚⲈⲘ ⲚⲒϨⲂⲰⲤ ⲈⲤⲐⲀⲘⲒⲞ ⲘⲘⲰⲞⲨ ⲈⲤϢⲞⲠ ⲚⲈⲘⲰⲞⲨ ⲚϪⲈϮϬⲀϨⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ⲀϤϨⲒⲦⲞⲨ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲈⲦⲀϤϨⲒⲦϤ ϨⲒϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲀϤⲦⲰⲂϨ ⲈⲦⲀϤⲔⲞⲦϤ ⲈⲠⲒⲤⲰⲘⲀ ⲠⲈϪⲀϤ ϪⲈ ⲦⲀⲂⲒⲐⲀ ⲦⲰⲞⲨⲚⲒ ⲚⲐⲞⲤ ⲆⲈ ⲀⲤⲞⲨⲰⲚ ⲚⲚⲈⲤⲂⲀⲖ ⲈⲦⲀⲤⲚⲀⲨ ⲆⲈ ⲈⲠⲈⲦⲢⲞⲤ ⲀⲤϨⲈⲘⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ⲀϤϮⲦⲞⲦⲤ ⲆⲈ ⲀϤⲦⲀϨⲞⲤ ⲈⲢⲀⲦⲤ ⲈⲦⲀϤⲘⲞⲨϮ ⲆⲈ ⲈⲚⲒⲀⲄⲒⲞⲤ ⲚⲈⲘ ⲚⲒⲬⲎⲢⲀ ⲀϤⲦⲀϨⲞⲤ ⲚⲰⲞⲨ ⲈⲤⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ⲀⲠⲀⲒϨⲰⲂ ⲆⲈ ⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϦⲈⲚⲒⲞⲠⲠⲎ ⲦⲎⲢⲤ ⲞⲨⲞϨ ⲞⲨⲘⲎϢ ⲀⲨⲚⲀϨϮ ⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ϦⲈⲚⲒⲞⲠⲠⲎ ϦⲀⲦⲈⲚ ⲞⲨⲀⲒ ϪⲈ ⲤⲒⲘⲰⲚ ⲠⲒⲂⲀⲔϢⲀⲢ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲆⲈ ϦⲈⲚⲔⲈⲤⲀⲢⲒⲀ ⲈⲠⲈϤⲢⲀⲚ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲈⲞⲨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲠⲨⲢⲀ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ϮϨⲨⲆⲀⲖⲒⲔⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ⲈⲞⲨⲈⲨⲤⲈⲂⲎⲤ ⲠⲈ ⲈϤⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ ⲈϤⲒⲢⲒ ⲚⲞⲨⲘⲎϢ ⲘⲘⲈⲐⲚⲀⲎⲦ ⲘⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲈϤⲦⲰⲂϨ ⲘⲪⲚⲞⲨϮ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ⲀϤⲚⲀⲨ ϦⲈⲚⲞⲨϨⲞⲢⲀⲘⲀ ϦⲈⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ϢⲀⲢⲞϤ ϦⲈⲚⲪⲚⲀⲨ ⲚⲀϪⲠ ⲐⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲞⲘⲤ ⲈⲢⲞϤ ⲈⲦⲀϤϢⲰⲠⲒ ϦⲈⲚⲞⲨϨⲞϮ ⲠⲈϪⲀϤ ϪⲈ ⲞⲨ ⲠⲈⲦϢⲞⲠ ⲠϬⲞⲒⲤ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲚⲈⲔⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲈⲘ ⲚⲈⲔⲘⲈⲐⲚⲀⲎⲦ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲞⲨⲈⲢⲪⲘⲈⲨⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ϮⲚⲞⲨ ⲞⲨⲚ ⲞⲨⲰⲢⲠ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲒⲞⲠⲠⲎ ⲘⲀⲢⲞⲨⲘⲞⲨϮ ⲈⲞⲨⲀⲒ ϪⲈ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ⲪⲀⲒ ϤϪⲀⲖⲎⲞⲨⲦ ⲈⲞⲨⲀⲒ ϪⲈ ⲤⲒⲘⲰⲚ ⲠⲒⲂⲀⲔϢⲀⲢ ⲪⲀⲒ ⲈⲦⲈ ⲠⲈϤⲎⲒ ϦⲀⲦⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ⲈⲦⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲀϤⲘⲞⲨϮ ⲈⲂⲰⲔ ⲂⲚⲦⲀϤ ⲚⲈⲘ ⲞⲨⲘⲀⲦⲞⲒ ⲚⲈⲨⲤⲈⲂⲎⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲎⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ⲈⲦⲀϤϪⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ϦⲀⲦⲞⲦⲞⲨ ⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲈⲒⲞⲠⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲈⲨⲘⲞϢⲒ ϨⲒ ⲠⲒⲘⲰⲒⲦ ⲞⲨⲞϨ ⲈⲦⲀⲨϦⲰⲚⲦ ⲈϮⲠⲞⲖⲒⲤ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒϪⲈⲚⲈⲪⲰⲢ ⲈⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲘⲪⲚⲀⲨ ⲚⲀϪⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ⲚⲈ ⲀϤϨⲔⲞ ⲆⲈ ⲠⲈ ⲚⲀϤⲞⲨⲰϢ ⲈⲞⲨⲰⲘ ⲈⲨⲤⲞⲂϮ ⲆⲈ ⲚⲀϤ ⲀϤⲒ ⲚϪⲈⲞⲨⲦⲰⲘⲦ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ⲀϤⲚⲀⲨ ⲈⲦⲪⲈ ⲈⲤⲞⲨⲎⲚ ⲞⲨⲞϨ ⲞⲨⲤⲔⲈⲨⲞⲤ ⲈⲨⲬⲰ ⲘⲘⲞϤ ⲈϦⲢⲎⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲚⲒϢϮ ⲚϨⲂⲰⲤ ⲚⲒⲀⲨ ⲚⲆ ⲚⲀⲢⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ⲈⲨⲬⲎ ⲚϨⲢⲎⲒ ⲚϦⲎⲦϤ ⲚϪⲈⲚⲒϤⲦⲈⲪⲀⲦ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϬⲀⲦϤⲒ ⲚⲦⲈⲠⲔⲀϨⲒ ⲚⲈⲘ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ⲞⲨⲞϨ ⲀⲤϢⲰⲠⲒ ϨⲀⲢⲞϤ ⲚϪⲈⲞⲨⲤⲘⲎ ϪⲈ ⲦⲰⲚⲔ ⲠⲈⲦⲢⲈ ϢⲰⲦ ⲞⲨⲞϨ ⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲘⲪⲰⲢ ⲠϬⲞⲒⲤ ϪⲈ ⲘⲠⲒⲞⲨⲈⲘ ϨⲖⲒ ⲚⲈⲚⲬⲀⲒ ⲈⲚⲈϨ ⲈϤϬⲀϦⲈⲘ ⲒⲈ ⲈϤⲤⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ⲠⲀⲖⲒⲚ ⲞⲚ ⲀⲤϢⲰⲠⲒ ϨⲀⲢⲞϤ ⲚϪⲈϮⲤⲘⲎ ⲘⲪⲘⲀϨⲤⲞⲠⲂ ϪⲈ ⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲂⲰⲞⲨ ⲚⲐⲞⲔ ⲆⲈ ⲘⲠⲈⲢϬⲀϦⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ⲪⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲒ ϢⲀ ⲄⲚⲤⲞⲠ ⲞⲨⲞϨ ⲀⲨⲰⲖⲒ ⲘⲠⲒⲤⲔⲈⲨⲞⲤ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ϨⲰⲤ ⲆⲈ ⲈϤⲘⲈⲨⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚϦⲢⲎ ⲒⲚϦⲎⲦϤ ϪⲈ ⲞⲨ ⲠⲈ ⲠⲒϨⲞⲢⲀⲘⲀ ⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ ϨⲎⲠⲠⲈ ⲒⲤ ⲚⲒⲢⲰⲘⲒ ⲈⲦⲀϤⲞⲨⲞⲢⲠⲞⲨ ⲚϪⲈⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲈⲀⲨϢⲒⲚⲒ ⲚⲤⲀⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϨⲒⲢⲈⲚ ⲠⲒⲠⲨⲖⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ⲈⲦⲀⲨⲘⲞⲨϮ ⲚⲀⲨϢⲒⲚⲒ ⲠⲈ ϪⲈ ⲀⲚ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ϤϪⲀⲖⲎⲞⲨⲦ ⲈⲠⲀⲒⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲈϤⲤⲞϬⲚⲒ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲈⲐⲂⲈ ⲠⲒϨⲞⲢⲀⲘⲀ ⲠⲈϪⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲆⲈ ⲚⲀϤ ϪⲈ ⲒⲤ ⲄⲚⲢⲰⲘⲒ ⲤⲈⲔⲰϮ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ⲀⲖⲖⲀ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲞϨ ⲘⲞϢⲒ ⲚⲈⲘⲰⲞⲨ ⲚⲔⲞⲒ ⲚϨⲎⲦ ⲂⲀⲚ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲈⲦⲀⲒⲞⲨⲞⲢⲠⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ϢⲀ ⲚⲒⲢⲰⲘⲒ ⲠⲈϪⲀϤ ϪⲈ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ⲠⲈⲦⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲰⲒ ⲠⲒϨⲰⲂ ⲞⲨ ⲠⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲒ ⲈⲐⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲐⲘⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲈϤⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲘⲪⲚⲞⲨϮ ⲈⲨⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞϤ ⲚϪⲈⲠⲒϢⲖⲞⲖ ⲦⲎⲢϤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲦⲀⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲈϤⲞⲨⲀⲂ ⲈⲞⲨⲰⲢⲠ ⲚⲤⲰⲔ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ⲈⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲤⲀϪⲒ ⲚⲦⲞⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ⲀϤⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ⲈϦⲞⲨⲚ ⲀϤϢⲞⲠⲞⲨ ⲈⲢⲞϤ ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤⲦⲰⲚϤ ⲀϤⲒ ⲈⲂⲞⲖ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲞⲖ ⲚⲈⲘⲀϤ ⲚϪⲈϨⲀⲚⲔⲈⲤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲒⲞⲠⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲨⲒ ⲈϦⲞⲨⲚ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲆⲈ ⲚⲀϤⲤⲞⲘⲤ ⲈⲂⲞⲖ ϦⲀϪⲰⲞⲨ ⲈⲦⲀϤⲘⲞⲨϮ ⲆⲈ ⲈⲚⲈϤⲤⲨⲄⲄⲈⲚⲎⲤ ⲚⲈⲘ ⲚⲈϤϢⲪⲎ ⲢⲚⲀⲚⲀⲄⲔⲈⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀϤⲒ ⲈϦⲞⲨⲚ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀϤϮⲘⲀϮ ⲈⲢⲞϤ ⲚϪⲈⲔⲞⲢⲚⲎⲖⲒⲞⲤ ⲀϤϨⲒⲦϤ ⲈⲠⲈⲤⲎⲦ ϦⲀⲢⲀⲦⲞⲨ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲀϤⲞⲨⲰϢⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲀⲚⲞⲔ ϨⲰ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ⲞⲨⲞϨ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲀϤϪⲒⲘⲒ ⲚⲞⲨⲘⲎϢ ⲈⲀⲨⲐⲰⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲞⲨⲂⲞϮ ⲠⲈ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲦⲞⲘϤ ⲒⲈ ⲈⲘⲞϢⲒ ⲚⲈⲘ ⲞⲨⲀⲖⲖⲞⲪⲨⲖⲞⲤ ⲞⲨⲞϨ ⲀⲚⲞⲔ ⲀⲪⲚⲞⲨϮ ⲦⲀⲘⲞⲒ ⲈϢⲦⲈⲘϪⲞⲤ ⲚϨⲖⲒ ⲚⲢⲰⲘⲒ ϪⲈ ϤϬⲀϦⲈⲘ ⲒⲈ ϤⲤⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲒⲒ ⲈⲦⲀⲢⲈⲦⲈⲚⲞⲨⲰⲢⲠ ⲚⲤⲰⲒ ⲘⲠⲒⲈⲢⲀⲚⲦⲒⲖⲈⲄⲒⲚ ϮϢⲒⲚⲒ ⲞⲨⲚ ϪⲈ ⲈⲐⲂⲈ ⲀϢ ⲚϨⲰⲂ ⲀⲦⲈⲦⲈⲚⲞⲨⲰⲢⲠ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲞⲤ ϪⲈ ⲒⲤ ϤⲦⲞⲨ ⲪⲞⲞⲨ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲦⲀⲒⲞⲨⲚⲞⲨ ⲚⲀⲒⲦⲰⲂϨ ⲘⲪⲚⲀⲨ ⲚⲀϪⲠ ⲐϮ ϦⲈⲚⲠⲀⲎⲒ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲠⲀⲘⲐⲞ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲈⲂⲤⲰ ⲈⲤⲞⲨⲞⲂϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲔⲞⲢⲚⲎⲖⲒⲈ ⲀⲨⲤⲰⲦⲈⲘ ⲈⲦⲈⲔⲠⲢⲞⲤⲈⲨⲬⲎ ⲞⲨⲞϨ ⲚⲈⲔⲘⲈⲐⲚⲀⲎⲦ ⲀⲨⲈⲢⲠⲞⲨⲘⲈⲨⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ⲞⲨⲰⲢⲠ ⲞⲨⲚ ⲈϨⲢⲎⲒ ⲈⲒⲞⲠⲠⲎ ⲘⲀⲢⲞⲨⲘⲞⲨϮ ⲈⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲪⲀⲒ ϤϪⲀⲖⲎⲞⲨⲦ ⲈⲠⲎⲒ ⲚⲤⲒⲘⲰⲚ ⲠⲒⲂⲀⲔϢⲀⲢ ϦⲀⲦⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ⲚϮⲚⲞⲨ ⲞⲨⲚ ⲀⲒⲞⲨⲰⲢⲠ ⲚⲤⲰⲔ ⲚⲐⲞⲔ ⲆⲈ ⲔⲀⲖⲰⲤ ⲀⲔⲀⲒⲤ ⲈⲦⲀⲔⲒ ϮⲚⲞⲨ ⲀⲚⲞⲚ ⲦⲎⲢⲈⲚ ⲦⲈⲚⲘⲠⲀⲒⲘⲀ ⲈⲚⲬⲎ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲈⲤⲰⲦⲈⲘ ⲈⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲀ ⲠϬⲞⲒⲤ ⲐⲀϢⲞⲨ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ⲈⲦⲀϤⲞⲨⲰⲚ ⲆⲈ ⲚⲢⲰϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ϮⲚⲀⲨ ϪⲈ ⲞⲨⲢⲈϤϬⲒϨⲞ ⲀⲚ ⲠⲈ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ⲀⲖⲖⲀ ⲚϨⲢⲎⲒ ϦⲈⲚϢⲖⲰⲖ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲢϨⲞϮ ϦⲀⲦⲈϤϨⲎ ⲞⲨⲞϨ ⲈⲦⲈⲢϨⲰⲂ ⲈϮⲘⲈⲐⲘⲎⲒ ϤϢⲎⲠ ⲚⲀϨⲢⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ⲀϤⲞⲨⲰⲢⲠ ⲘⲠⲈϤⲤⲀϪⲒ ⲚⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲀⲒ ⲠⲈ ⲠϬⲞⲒⲤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲠⲒⲤⲀϪⲒ ⲈⲦⲀϤϢⲰⲠⲒ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲦⲎⲢⲤ ⲈⲀϤⲈⲢϨⲎ ⲦⲤ ⲒⲤϪⲈⲚ ϮⲄⲀⲖⲒⲖⲈⲀ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲰⲘⲤ ⲈⲦⲀϤϨⲒⲰⲒϢ ⲘⲘⲞϤ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ⲒⲎⲤⲞⲨⲤ ⲠⲒⲢⲈⲘⲚⲀⲌⲀⲢⲈⲐ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲐⲀϨⲤϤ ⲚϪⲈⲪⲚⲞⲨϮ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲚⲈⲘ ⲞⲨϪⲞⲘ ⲪⲀⲒ ⲈⲦⲀϤⲒ ⲈⲈⲢⲠⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲈϤⲦⲀⲖϬⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲀ ⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ϪⲈⲘϪⲞⲘ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ϪⲈ ⲚⲀⲢⲈ ⲪⲚⲞⲨϮ ⲬⲎ ⲚⲈⲘⲀϤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲦⲈⲚⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ϦⲈⲚⲦⲬⲰⲢⲀ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲪⲎ ⲈⲦⲀⲨϦⲞⲐⲂⲈϤ ⲞⲨⲞϨ ⲀⲨⲀϢϤ ⲈϪⲈⲚ ⲞⲨϢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ⲪⲀⲒ ⲀⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲘⲘⲀϨⲄ ⲞⲨⲞϨ ⲀϤⲦⲎⲒϤ ⲈⲐⲢⲈϤⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ⲘⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲀⲚ ⲀⲖⲖⲀ ⲚⲚⲒⲘⲈⲐⲢⲈⲨ ⲚⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲤⲞⲦⲠⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈⲦⲈ ⲀⲚⲞⲚ ⲠⲈ ϦⲀ ⲚⲎ ⲈⲦⲀⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲀⲚⲤⲰ ⲚⲈⲘⲀϤ ⲘⲈⲚⲈⲚⲤⲀ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ⲞⲨⲞϨ ⲀϤϨⲞⲚϨⲈⲚ ⲚⲀⲚ ⲈϨⲒⲰⲒϢ ⲘⲠⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲈⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲐⲀϢϤ ⲚⲢⲈϤϮϨⲀⲠ ⲈⲚⲎ ⲈⲦⲞⲚϦ ⲚⲈⲘ ⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ⲪⲀⲒ ⲈⲦⲈ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞϤ ⲈⲐⲢⲞⲨϬⲒ ⲘⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲞⲨⲚⲞⲂⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲈϤⲢⲀⲚ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ⲈⲦⲒ ⲈϤⲤⲀϪⲒ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲚⲀⲒⲤⲀϪⲒ ⲀϤⲒ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ⲞⲨⲞϨ ⲀⲨⲦⲰⲘⲦ ⲚϪⲈⲚⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲈⲂⲒ ⲚⲒⲠⲒⲤⲦⲞⲤ ⲈⲦⲀⲨⲒ ⲚⲈⲘ ⲠⲈⲦⲢⲞⲤ ϪⲈ Ⲁ- ϮⲆⲰⲢⲈⲀ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲀⲤⲪⲰⲚ ⲈⲂⲞⲖ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲒⲔⲈⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ⲚⲀⲨⲤⲰⲦⲈⲘ ⲄⲀⲢ ⲈⲢⲰⲞⲨ ⲠⲈ ⲈⲨⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲞⲨⲞϨ ⲈⲨϬⲒⲤⲒ ⲘⲪⲚⲞⲨϮ ⲦⲞⲦⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ϪⲈ ⲘⲎⲦⲒ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲦⲀϨⲚⲞ ⲘⲠⲒⲘⲰⲞⲨ ⲈϢⲦⲈⲘⲐⲢⲈ ⲚⲀⲒ ϬⲒⲰⲘⲤ ⲚⲀⲒ ⲈⲦⲀⲨϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲠⲈⲚⲢⲎϮ ϨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲆⲈ ⲚⲰⲞⲨ ⲈⲐⲢⲞⲨⲞⲘⲤⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲞⲦⲈ ⲀⲨϮϨⲞ ⲈⲢⲞϤ ⲈⲐⲢⲈϤϢⲰⲠⲒ ϦⲀⲦⲞⲦⲞⲨ ⲚϨⲀⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ϪⲈ Ⲁ- ⲚⲒⲈⲐⲚⲞⲤ ϢⲈⲠ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ϨⲞⲦⲈ ⲈⲦⲀϤϢⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨϬⲒϨⲀⲠ ⲚⲈⲘⲀϤ ⲚϪⲈⲚⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲈⲂⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲔϢⲈ ⲈϦⲞⲨⲚ ϢⲀ ϨⲀⲚⲢⲰⲘⲒ ⲚⲀⲦⲤⲈⲂⲒ ⲞⲨⲞϨ ⲀⲔⲞⲨⲰⲘ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ⲈⲦⲀϤⲈⲢϨⲎⲦⲤ ⲆⲈ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈϤϪⲰ ⲘⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ⲀⲚⲞⲔ ⲚⲀⲒϦⲈⲚ ⲒⲞⲠⲠⲎ ϮⲠⲞⲖⲒⲤ ⲈⲒⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ⲞⲨⲞϨ ⲀⲒⲚⲀⲨ ϦⲈⲚⲞⲨⲦⲰⲘⲦ ⲈⲞⲨϨⲞⲢⲀⲘⲀ ⲈϤⲚⲎⲞⲨ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲞⲨⲤⲔⲈⲨⲞⲤ ⲘⲪⲢⲎϮ ⲚⲞⲨⲚⲒϢϮ ⲚϨⲂⲰⲤ ⲚⲒⲀⲨ ⲈⲨⲬⲰ ⲘⲘⲞϤ ⲈϦⲢⲎⲒ ⲚⲆ ⲚⲀⲢⲬⲎ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲞⲨⲞϨ ⲀϤⲒ ϢⲀⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ⲪⲀⲒ ⲈⲦⲀⲒⲤⲞⲘⲤ ⲈⲢⲞϤ ⲚⲀⲒϮ ⲚϨⲐⲎⲒ ⲠⲈ ⲞⲨⲞϨ ⲀⲒⲚⲀⲨ ⲈⲚⲒⲦⲈⲂⲚⲰⲞⲨⲒ ⲚⲦⲈⲠⲔⲀϨⲒ ⲚⲈⲘ ⲚⲒⲐⲎⲢⲒⲞⲚ ⲚⲈⲘ ⲚⲒϬⲀⲦϤⲒ ⲚⲈⲘ ⲚⲒϨⲀⲖⲀϮ ⲚⲦⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ⲀⲒⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲔⲈⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲠⲈⲦⲢⲈ ϢⲰⲦ ⲞⲨⲞϨ ⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ⲠⲈϪⲎⲒ ⲆⲈ ⲘⲪⲰⲢ ⲠϬⲞⲒⲤ ϪⲈ ⲘⲠⲈ ϨⲖⲒ ⲚⲈⲚⲬⲀⲒ ⲈϤϬⲀϦⲈⲘ ⲒⲈ ⲈϤⲤⲞϤ ϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰⲒ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ⲀⲤⲈⲢⲞⲨⲰ ⲆⲈ ⲚϪⲈϮⲤⲘⲎ ⲘⲪⲘⲀϨⲤⲞⲠ ⲂⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲂⲰⲞⲨ ⲚⲐⲞⲔ ⲘⲠⲈⲢϬⲀϦⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ⲪⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲒ ϢⲀ ⲄⲚⲤⲞⲠ ⲞⲨⲞϨ ⲀⲨϤⲒ ⲞⲚ ⲚⲔⲈⲤⲞⲠ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ϮⲞⲨⲚⲞⲨ ⲒⲤ ⲄⲚⲢⲰⲘⲒ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϨⲒⲢⲈⲚ ⲪⲢⲞ ⲘⲠⲒⲎⲒ ⲈⲚⲀⲒⲬⲎ ⲚϦⲎⲦϤ ⲈⲀⲨⲦⲀⲞⲨⲰⲞⲨ ϨⲀⲢⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲔⲈⲤⲀⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ⲠⲈϪⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲆⲈ ⲚⲎⲒ ϪⲈ ⲘⲀϢⲈ ⲚⲀⲔ ⲚⲈⲘⲰⲞⲨ ⲚⲔⲞⲒ ⲚϨⲎⲦ ⲂⲀⲚ ⲚϨⲖⲒ ⲀⲨⲒ ⲆⲈ ⲚⲈⲘⲎⲒ ⲚϪⲈⲠⲀⲒⲔⲈ ⲚⲤⲞⲚ ⲞⲨⲞϨ ⲀⲚϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ⲀϤⲦⲀⲘⲞⲚ ⲆⲈ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ϦⲈⲚⲠⲈϤⲎⲒ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲞⲨⲞϨ ⲈϤϪⲞⲤ ϪⲈ ⲞⲨⲰⲢⲠ ⲈⲒⲞⲠⲠⲎ ⲞⲨⲞϨ ⲘⲞⲨϮ ⲈⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ⲪⲀⲒ ⲈⲐⲚⲀⲤⲀϪⲒ ⲚⲈⲘⲀⲔ ⲚϨⲀⲚⲤⲀϪⲒ ⲚⲀⲒ ⲈⲦⲈⲔⲚⲀⲚⲞϨⲈⲘ ⲚϦⲎⲦⲞⲨ ⲚⲐⲞⲔ ⲚⲈⲘ ⲠⲈⲔⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ⲈⲦⲀⲒⲈⲢϨⲎⲦⲤ ⲆⲈ ⲚⲤⲀϪⲒ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ⲚϢⲞⲢⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ⲀⲒⲈⲢⲪⲘⲈⲨⲒ ⲆⲈ ⲘⲠⲤⲀϪⲒ ⲘⲠϬⲞⲒⲤ ⲘⲪⲢⲎϮ ⲈⲚⲀϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲀϤϮⲰⲘⲤ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲤⲈⲚⲀⲈⲘⲤ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ⲒⲤϪⲈ ⲞⲨⲚ ⲀⲪⲚⲞⲨϮ ⲀϤϮ ⲚⲰⲞⲨ ⲚϮϨⲨⲤⲞⲤ ⲚϮⲆⲰⲢⲈⲀ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲠⲈⲚⲢⲎϮ ϨⲰⲚ ⲀⲚⲞⲔ ⲚⲒⲘ ⲆⲈ ⲈⲦⲀϨⲚⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲀⲨⲬⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲢⲀ ⲀⲪⲚⲞⲨϮ ⲀϤϮ ⲚϮⲘⲈⲦⲀⲚⲞⲒⲀ ⲚⲚⲒⲔⲈⲈⲐⲚⲞⲤ ⲈⲠⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ⲚⲎ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲤⲰⲢ ⲈⲂⲞⲖ ⲒⲤϪⲈⲚ ⲠⲒϨⲞϪϨⲈϪ ⲈⲦⲀϤϢⲰⲠⲒ ϨⲒ ⲤⲦⲈⲪⲀⲚⲞⲤ ⲀⲨⲒ ϢⲀ ⲈϨⲢⲎⲒ ⲈϮⲪⲞⲒⲚⲒⲔⲎ ⲚⲈⲘ ⲔⲨⲠⲢⲞⲤ ⲚⲈⲘ ⲦⲀⲚϮⲞⲬⲒⲀ ⲚⲤⲈⲤⲀϪⲒ ⲚⲈⲘ ϨⲖⲒ ⲀⲚ ⲘⲠⲒⲤⲀϪⲒ ⲈⲂⲎⲖ ⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲘⲀⲨⲀⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ϨⲀⲚⲢⲰⲘⲒ ⲚⲔⲨⲠⲢⲒⲞⲤ ⲚⲈⲘ ϨⲀⲚⲔⲨⲢⲒⲚⲚⲈⲞⲤ ⲚⲀⲒ ⲈⲦⲀⲨⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲈⲨϨⲒⲰⲒϢ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲦϪⲒϪ ⲘⲠϬⲞⲒⲤ ⲬⲎ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲘⲘⲎϢ ⲀⲨⲚⲀϨϮ ⲞⲨⲞϨ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ⲀⲠⲒⲤⲀϪⲒ ⲆⲈ ϢⲈ ϢⲀ ⲚⲈⲚⲘⲀϢϪ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲐⲂⲎⲦⲞⲨ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰⲢⲠ ⲘⲂⲀⲢⲚⲀⲂⲀⲤ ϢⲀ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ⲪⲀⲒ ⲈⲦⲀϤⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤⲢⲀϢⲒ ⲞⲨⲞϨ ⲚⲀϤϮⲚⲞⲘϮ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϦⲈⲚⲠⲒⲐⲰⲦ ⲚϨⲎⲦ ⲈⲐⲢⲞⲨⲞϨⲒ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ϪⲈ ⲚⲈⲞⲨⲢⲰⲘⲒ ⲚⲀⲄⲀⲐⲞⲤ ⲠⲈ ⲈϤⲘⲈϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲪⲚⲀϨϮ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨϤ ⲚⲤⲀⲠϬⲞⲒⲤ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ⲈⲦⲀϤⲒ ⲆⲈ ⲈⲐⲀⲢⲤⲞⲤ ⲈϤⲔⲰϮ ⲚⲤⲀⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈⲘϤ ⲀϤⲈⲚϤ ⲈϨⲢⲎⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲨⲈⲢ ⲞⲨⲢⲞⲘⲠⲒ ⲦⲎⲢⲤ ⲈⲨⲐⲞⲨⲎⲦ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲀⲨϮⲤⲂⲰ ⲚⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲀⲨϮⲢⲈⲚ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲈⲦϦⲈⲚ ⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚϢⲞⲢⲠ ϪⲈ ⲚⲒⲬⲢⲎⲤⲦⲒⲀⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲚⲀⲒⲈϨⲞⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲒ ⲚϪⲈϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲄⲀⲂⲞⲤ ⲀϤϮⲘⲎⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲞⲨⲚⲒϢϮ ⲚϨⲂⲰⲚ ⲈϤⲚⲀϢⲰⲠⲒ ⲈϪⲈⲚ ϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ ⲈⲦⲈ ⲪⲎ ⲠⲈ ⲈⲦⲀϤϢⲰⲠⲒ ϨⲒ ⲔⲖⲀⲨⲆⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲚⲀⲢⲈ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲈϨ ⲘⲘⲞϤ ⲀϤⲐⲰϢ ⲚϪⲈⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ⲈⲞⲨⲆⲒⲀⲔⲰⲚⲒⲀ ⲈⲞⲨⲰⲢⲠ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ⲪⲀⲒ ⲈⲦⲀⲨⲀⲒϤ ⲈⲞⲨⲰⲢⲠ ⲚϨⲀⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲤⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ Ⲁ- ⲎⲢⲰⲆⲎⲤ ⲠⲞⲨⲢⲞ ⲀϤⲒⲚⲒ ⲚⲦⲈϤϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈϮⲘⲔⲀϨ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ⲞⲨⲞϨ ⲀϤϦⲰⲦⲈⲂ ⲚⲒⲀⲔⲰⲂⲞⲤ ⲠⲤⲞⲚ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲚⲦⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ϪⲈ ⲠⲒϨⲰⲂ ⲢⲀⲚⲰⲞⲨ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲀϤⲞⲨⲀϨⲦⲞⲦϤ ⲈϬⲰⲠⲒ ⲘⲠⲔⲈⲠⲈⲦⲢⲞⲤ ⲚⲈⲚⲒⲈϨⲞⲞⲨ ⲆⲈ ⲚⲈⲚⲦⲈⲚⲒⲀⲦⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ⲪⲀⲒ ⲈⲦⲀϤϬⲞⲠϤ ⲀϤⲬⲀϤ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲈⲀϤⲦⲎⲒϤ ⲈⲦⲞⲦⲞⲨ ⲚⲆ ⲚϢⲰⲠ ⲘⲘⲀⲦⲞⲒ ⲈⲐⲢⲞⲨⲀⲢⲈϨ ⲈⲢⲞϤ ⲈϤⲘⲈⲨⲒ ⲈⲈⲚϤ ⲈϨⲢⲎⲒ ⲘⲠⲒⲖⲀⲞⲤ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲠⲀⲤⲬⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ⲠⲈⲦⲢⲞⲤ ⲘⲈⲚ ⲞⲨⲚ ⲚⲀⲨⲀⲢⲈϨ ⲈⲢⲞϤ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲚⲀⲤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲆⲈ ⲈⲐⲂⲎⲦϤ ⲈⲘⲀϢⲰ ϨⲀ ⲪⲚⲞⲨϮ ⲚϪⲈϮⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ϨⲞⲦⲈ ⲆⲈ ⲈϤⲚⲀⲈⲚϤ ⲈϨⲢⲎⲒ ⲚϪⲈⲎⲢⲰⲆⲎⲤ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀϤⲈⲚⲔⲞⲦ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲞⲨⲦⲈ ⲘⲀⲦⲞⲒ ⲂⲈϤⲘⲎⲢ ⲚϨⲀⲖⲨⲤⲒⲤ ⲂϮ ⲚⲈⲞⲨⲞⲚ ⲚϨⲀⲚⲀⲢⲈϨ ⲆⲈ ϨⲒⲢⲈⲚ ⲚⲒⲢⲰⲞⲨ ⲈⲨⲀⲢⲈϨ ⲈⲠⲒϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲒⲤ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤⲒ ⲞⲨⲞϨ ⲞⲨⲞⲨⲰⲒⲚⲒ ⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ϦⲈⲚⲠⲒⲎⲒ ⲈⲦⲀϤⲔⲒⲘ ⲆⲈ ⲈⲠⲤⲪⲒⲢ ⲘⲠⲈⲦⲢⲞⲤ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲰⲚⲔ ⲚⲬⲰⲖⲈⲘ ⲞⲨⲞϨ ⲀⲨϨⲈⲒ ⲚϪⲈⲚⲒϨⲀⲖⲨⲤⲒⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈϤϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ⲠⲈϪⲈ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲆⲈ ⲚⲀϤ ϪⲈ ⲘⲞⲢⲔ ⲞⲨⲞϨ ⲘⲀ ⲠⲈⲔⲤⲨⲚⲆⲀⲖⲒⲞⲚ ⲈⲢⲀⲦⲔ ⲀϤⲒⲢⲒ ⲆⲈ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ϪⲞⲖϨⲔ ⲘⲠⲈⲔϨⲂⲰⲤ ⲞⲨⲞϨ ⲘⲞϢⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲚⲀϤⲘⲞϢⲒ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲚⲀϤⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲘⲎⲒ ⲠⲈⲦⲈ ⲚⲀϤϢⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲀϤⲘⲈⲨⲒ ⲆⲈ ϪⲈ ⲞⲨϨⲞⲢⲀⲘⲀ ⲠⲈⲦⲀϤⲚⲀⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ⲈⲦⲀⲨⲤⲒⲚⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲀ ⲚⲀⲢⲈϨ ⲚϨⲞⲨⲒⲦ ⲚⲈⲘ ⲠⲒⲘⲀϨⲂ ⲀⲨⲒ ⲈϮⲠⲨⲖⲎ ⲘⲂⲈⲚⲒⲠⲒ ⲐⲎ ⲈⲐⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲈϮⲠⲞⲖⲒⲤ ⲐⲀⲒ ⲀⲤⲞⲨⲰⲚ ⲚⲰⲞⲨ ⲚⲞⲨⲀⲦⲤ ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲂⲞⲖ ⲀⲨⲤⲈⲚ ⲞⲨⲀⲒ ⲚⲚⲒϦⲒⲢ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤϢⲈ ⲚⲀϤ ⲚϪⲈⲠⲒⲀⲄⲄⲈⲖⲞⲤ ⲈⲂⲞⲖ ϨⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲈⲦⲀ ⲠⲈϤϨⲎⲦ ⲒⲈⲢⲞϤ ⲠⲈϪⲀϤ ϪⲈ ϮⲚⲞⲨ ⲀⲒⲈⲘⲒ ⲦⲀⲪⲘⲎ ϪⲈ ⲀⲠϬⲞⲒⲤ ⲞⲨⲰⲢⲠ ⲘⲠⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲞϨ ⲀϤⲚⲀϨⲘⲈⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦϪⲒϪ ⲚⲎⲢⲰⲆⲎⲤ ⲚⲈⲘ ⲠⲤⲞⲘⲤ ⲈⲂⲞⲖ ⲦⲎⲢϤ ⲘⲠⲒⲖⲀⲞⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲀϤⲒ ⲈⲠⲎⲒ ⲘⲘⲀⲢⲒⲀ ⲐⲘⲀⲨ ⲚⲒⲰⲀⲚⲚⲎⲤ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ ⲠⲒⲘⲀ ⲈⲚⲀⲨⲐⲞⲨⲎⲦ ⲘⲘⲞϤ ⲚϪⲈⲞⲨⲘⲎ ϢⲈⲨⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ⲈⲦⲀϤⲔⲰⲖϨ ⲆⲈ ϨⲒⲢⲈⲚ ⲪⲢⲞ ⲘⲠⲒⲠⲨⲖⲰⲚ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲀⲤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲞⲨⲀⲖⲞⲨ ⲘⲂⲰⲔⲒ ⲈⲈⲢⲞⲨⲰ ⲚⲀϤ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲢⲰⲆⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ⲞⲨⲞϨ ⲈⲦⲀⲤⲤⲞⲨⲈⲚ ⲦⲤⲘⲎ ⲘⲠⲈⲦⲢⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲀϢⲒ ⲘⲠⲈⲤⲞⲨⲰⲚ ⲘⲠⲒϢⲐⲰⲘ ⲈⲦⲀⲤϬⲞϪⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲀⲤⲦⲀⲘⲰⲞⲨ ϪⲈ ⲠⲈⲦⲢⲞⲤ ⲞϨⲒ ⲈⲢⲀⲦϤ ϨⲒⲢⲈⲚ ⲠⲒⲠⲨⲖⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀⲤ ϪⲈ ⲀⲢⲈⲖⲞⲂⲒ ⲚⲐⲞⲤ ⲆⲈ ⲚⲀⲤⲦⲀϪⲢⲞ ⲚⲦⲞⲦⲤ ⲠⲈ ϪⲈ ⲠⲀⲒⲢⲎϮ ⲠⲈⲦϢⲞⲠ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲈϤⲀⲄⲄⲈⲖⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ⲠⲈⲦⲢⲞⲤ ⲆⲈ ⲚⲀϤⲘⲎⲚ ⲈϤⲔⲰⲖϨ ⲠⲈ ⲈⲦⲀⲨⲞⲨⲰⲚ ⲆⲈ ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲀⲨⲦⲰⲘⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ⲀϤϬⲰⲢⲈⲘ ⲆⲈ ⲈⲢⲰⲞⲨ ⲚⲦⲈϤϪⲒϪ ϪⲈ ⲬⲀⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲀϤⲤⲀϪⲒ ϦⲀⲦⲞⲦⲞⲨ ϪⲈ ⲚⲀϢ ⲚⲢⲎϮ ⲀⲠϬⲞⲒⲤ ⲈⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲰⲞⲨ ϪⲈ ⲘⲀⲦⲀⲘⲈ ⲒⲀⲔⲰⲂⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲈⲚⲀⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ⲀϤϢⲈ ⲈⲔⲈⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ϢⲰⲠⲒ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀⲚ ϦⲈⲚⲚⲒⲘⲀⲦⲞⲒ ϪⲈ ⲞⲨ ϨⲀⲢⲀ ⲠⲈⲦⲀϤϢⲰⲠⲒ ⲘⲠⲈⲦⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ⲎⲢⲰⲆⲎⲤ ⲈⲦⲀϤⲔⲰϮ ⲚⲤⲰϤ ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲈϤϪⲈⲘϤ ⲀϤϮⲘⲔⲀϨ ⲚⲚⲒⲢⲈϤⲀⲢⲈϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈϦⲞⲐⲂⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲈϨⲢⲎⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲀϤϢⲰⲠⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ⲚⲀϤϢⲞⲠ ⲆⲈ ϦⲈⲚⲞⲨⲘⲂⲞⲚ ⲈϤϮ ⲞⲨⲂⲈ ⲚⲀ ⲦⲨⲢⲞⲤ ⲚⲈⲘ ⲦⲤⲒⲆⲰⲚ ⲀⲨⲒ ⲆⲈ ⲈⲨⲤⲞⲠ ϢⲀⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲐⲈⲦ ⲠϨⲎⲦ ⲘⲠⲖⲀⲤⲦⲞⲤ ⲪⲎ ⲈⲦⲬⲎ ϨⲒϪⲈⲚ ⲠⲒⲔⲞⲒⲦⲰⲚ ⲚⲦⲈⲠⲞⲨⲢⲞ ⲚⲀⲨⲈⲢⲈⲦⲒⲚ ⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲈⲐⲂⲈ ϪⲈ ⲚⲀⲨϢⲀⲚϢ ⲚⲦⲞⲨⲬⲰⲢⲀ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲤ ⲚⲦⲈϤⲘⲈⲦⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲞⲨⲈϨⲞⲞⲨ ⲈϤⲐⲎϢ Ⲁ- ⲎⲢⲰⲆⲎⲤ ϮϨⲒⲰⲦϤ ⲚⲞⲨϨⲈⲂⲤⲰ ⲚⲞⲨⲢⲞ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲈⲘⲤⲒ ϨⲒϪⲈⲚ ⲠⲒⲂⲎⲘⲀ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ⲠⲒⲘⲎϢ ⲆⲈ ⲚⲀϤⲰϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲤⲘⲎ ⲚⲚⲞⲨϮ ⲦⲈ ⲐⲀⲒ ⲞⲨⲞϨ ⲐⲀ ⲢⲰⲘⲒ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ⲤⲀⲦⲞⲦϤ ⲆⲈ ⲀⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲀϤϢⲀⲢⲒ ⲈⲢⲞϤ ⲈⲪⲘⲀ ϪⲈ ⲘⲠⲈϤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢϬⲒϤⲈⲚⲦ ⲀϤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ⲠⲒⲤⲀϪⲒ ⲆⲈ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤⲀⲒⲀⲒ ⲞⲨⲞϨ ⲚⲀϤⲚⲎⲞⲨ ⲚⲀϢⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲚⲈⲘ ⲤⲀⲨⲖⲞⲤ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚϮⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲂⲞⲖ ⲈⲀⲨⲒⲚⲒ ⲘⲠⲔⲈⲒⲰⲀⲚⲚⲎⲤ ⲪⲎ ⲈⲦⲀⲨϮⲢⲈⲚϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ⲚⲈ ⲞⲨⲞⲚ ϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲆⲈ ⲚⲈⲘ ϨⲀⲚⲢⲈϤϮⲤⲂⲰ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲦⲀⲚϮⲞⲬⲒⲀ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲤⲒⲘⲰⲚ ⲪⲎ ⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲚⲒⲔⲈⲢ ⲚⲈⲘ ⲖⲞⲨⲔⲒⲞⲤ ⲠⲒⲔⲨⲢⲒⲚⲚⲈⲞⲤ ⲚⲈⲘ ⲘⲀⲚⲀⲎ ⲠⲒϢⲪⲎⲢ ⲚϢⲀⲚϢ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ ⲠⲒⲦⲈⲦⲢⲀⲀⲢⲬⲎⲤ ⲚⲈⲘ ⲤⲀⲨⲖⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ⲈⲨϢⲈⲘϢⲒ ⲆⲈ ⲘⲠϬⲞⲒⲤ ⲈⲨⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲠⲈϪⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ϪⲈ ⲪⲰⲢϪ ⲚⲎⲒ ⲈⲂⲞⲖ ⲘⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲤⲀⲨⲖⲞⲤ ⲈⲠⲒϨⲰⲂ ⲈⲦⲀⲒⲐⲀϨⲘⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ⲦⲞⲦⲈ ⲈⲦⲀⲨⲈⲢⲚⲎⲤⲦⲈⲨⲒⲚ ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲂϨ ⲀⲨⲬⲀϪⲒϪ ⲈϪⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲬⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲤⲈⲖⲈⲨⲔⲒⲀ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲨⲈⲢϨⲰⲦ ⲈⲔⲨⲠⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈⲤⲀⲖⲀⲘⲒⲚⲎ ⲚⲀⲨϨⲒⲰⲒϢ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲀⲢⲈ ⲠⲔⲈⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ⲚⲈⲘⲰⲞⲨ ⲈϤⲞⲒ ⲚⲢⲈϤϢⲈⲘϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ⲈⲦⲀⲨⲤⲈⲚ ϮⲚⲎⲤⲞⲤ ⲆⲈ ⲦⲎⲢⲤ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲠⲀⲪⲞⲨ ⲀⲨϪⲒⲘⲒ ⲚⲞⲨⲢⲰⲘⲒ ⲚⲀⲬⲰ ⲘⲮⲈⲆⲞⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲒⲞⲨⲆⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲂⲀⲢⲒⲎⲤⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ⲪⲀⲒ ⲈⲚⲀϤⲬⲎ ⲚⲈⲘ ⲠⲒⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲤⲈⲢⲄⲒⲞⲤ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲢⲰⲘⲒ ⲚⲔⲀⲦϨⲎⲦ ⲪⲀⲒ ⲆⲈ ⲀϤⲘⲞⲨϮ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲤⲀⲨⲖⲞⲤ ⲚⲀϤⲔⲰϮ ⲈⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ⲚⲀϤϮ ⲆⲈ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲨ ⲚϪⲈⲈⲖⲨⲘⲀⲤ ⲠⲒⲀⲬⲰ ⲈϢⲀⲨⲞⲨⲀϨⲈⲘ ⲠⲈϤⲢⲀⲚ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲎϮ ⲈϤⲔⲰϮ ⲚⲤⲀⲪⲈⲚϨ ⲠⲒⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ⲤⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲠⲈ ⲈⲦⲀϤⲘⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ");
INSERT INTO copbhc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ⲠⲈϪⲀϤ ⲰⲪⲎ ⲈⲐⲘⲈϨ ⲚⲬⲢⲞϤ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲠⲈⲦϨⲰⲞⲨ ⲚⲒⲂⲈⲚ ⲠϢⲎⲢⲒ ⲚⲦⲈⲠⲒⲆⲒⲀⲂⲞⲖⲞⲤ ⲠⲒϪⲀϪⲒ ⲚⲦⲈⲐⲘⲎⲒ ⲚⲒⲂⲈⲚ ⲚⲔⲬⲰ ⲚⲦⲞⲦⲔ ⲈⲂⲞⲖ ⲀⲚ ⲈⲔⲪⲰⲚϨ ⲚⲚⲒⲘⲰⲒⲦ ⲈⲦⲤⲞⲨⲦⲰⲚ ⲚⲦⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ⲞⲨⲞϨ ϮⲚⲞⲨ ϨⲎⲠⲠⲈ ⲒⲤ ⲦϪⲒϪ ⲘⲠϬⲞⲒⲤ ⲈⲤⲈⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲔ ⲞⲨⲞϨ ⲈⲔⲈϢⲰⲠⲒ ⲈⲔⲞⲒ ⲘⲂⲈⲖⲖⲈ ⲚⲬⲚⲀⲨ ⲘⲪⲢⲎ ⲀⲚ ϢⲀ ⲞⲨⲤⲎⲞⲨ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦϤ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲚϪⲈⲞⲨϨⲖⲞⲖ ⲚⲈⲘ ⲞⲨⲬⲀⲔⲒ ⲚⲀϤⲔⲰϮ ⲈϤϢⲒⲚⲒ ⲚⲤⲀⲪⲎ ⲈⲐⲚⲀϮⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ⲦⲞⲦⲈ ⲈⲦⲀϤⲚⲀⲨ ⲚϪⲈⲠⲒⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲈⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲀϤⲚⲀϨϮ ⲀϤⲈⲢϢⲪⲎⲢⲒ ⲈϪⲈⲚ ϮⲤⲂⲰ ⲚⲦⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲪⲞⲨ ⲚϪⲈⲚⲀ ⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲠⲀⲢⲚⲀⲂⲀⲤ ⲀⲨⲒ ⲈⲠⲈⲢⲄⲎ ⲚⲦⲈϮⲠⲀⲘⲪⲒⲖⲒⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ⲀϤⲪⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲀϤⲔⲞⲦϤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲢⲄⲎ ⲀⲨⲒ ⲈⲦⲀⲚϮⲞⲬⲒⲀ ⲚⲦⲈϮⲠⲒⲤⲒⲆⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲨϨⲈⲘⲤⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲰϢ ⲆⲈ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨⲞⲨⲰⲢⲠ ⲚϪⲈⲚⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ϨⲀⲢⲰⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲀϪⲒ ⲚⲚⲞⲘϮ ⲠⲈ ϦⲈⲚⲐⲎⲚⲞⲨ ϢⲀ ⲠⲒⲖⲀⲞⲤ ⲀϪⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀϤϬⲰⲢⲈⲘ ⲚⲦⲈϤϪⲒϪ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈⲢϨⲞϮ ϦⲈⲚⲐⲎⲚⲞⲨ ϦⲀⲦϨⲎ ⲘⲪⲚⲞⲨϮ ⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ⲪⲚⲞⲨϮ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲠⲒⲤⲖ ⲀϤⲤⲰⲦⲠ ⲚⲚⲈⲚⲒⲞϮ ⲞⲨⲞϨ ⲀϤϬⲒⲤⲒ ⲘⲠⲒⲖⲀⲞⲤ ϦⲈⲚϮⲠⲀⲢⲞⲒⲔⲒⲀ ϦⲈⲚⲠⲔⲀϨⲒ ⲚⲬⲎⲘⲒ ⲞⲨⲞϨ ϦⲈⲚⲞⲨϢⲰⲂϢ ⲈϤϬⲞⲤⲒ ⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ⲞⲨⲞϨ ⲀϤϢⲀⲚⲞⲨϢⲞⲨ ⲚⲘⲚⲢⲞⲘⲠⲒ ⲚⲤⲎⲞⲨ ϨⲒ ⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ⲞⲨⲞϨ ⲈⲦⲀϤⲢⲰϦⲦ ⲚⲌ ⲚϢⲖⲰⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲚⲬⲀⲚⲀⲀⲚ ⲀϤⲐⲢⲞⲨⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲘⲠⲞⲨⲔⲀϨⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ⲚⲨ ⲚⲢⲞⲘⲠⲒ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲀϤϮ ⲚϨⲀⲚⲔⲢⲒⲦⲎⲤ ϢⲀ ⲤⲀⲘⲞⲨⲎⲖ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ⲞⲨⲞϨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲨⲈⲢⲈⲦⲒⲚ ⲚⲞⲨⲞⲨⲢⲞ ⲞⲨⲞϨ ⲀϤϮ ⲚⲰⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲚⲤⲀⲞⲨⲖ ⲠϢⲎⲢⲒ ⲚⲔⲒⲤ ⲞⲨⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲨⲖⲎ ⲘⲂⲈⲚⲒⲀⲘⲒⲚ ⲚⲘⲚⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲞⲐⲂⲈϤ ⲈⲂⲞⲖ ⲀϤⲦⲞⲨⲚⲞⲤ ⲆⲀⲨⲒⲆ ⲚⲰⲞⲨ ⲚⲞⲨⲢⲞ ⲪⲀⲒ ⲈⲦⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦϤ ⲈⲀϤϪⲞⲤ ϪⲈ ⲀⲒϪⲒⲘⲒ ⲚⲆⲀⲨⲒⲆ ⲠϢⲎⲢⲒ ⲚⲒⲈⲤⲤⲈ ⲞⲨⲢⲰⲘⲒ ⲔⲀⲦⲀ ⲠⲀϨⲎⲦ ⲪⲀⲒ ⲈⲐⲚⲀⲒⲢⲒ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈϨⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ⲞⲨⲞϨ ⲈⲂⲞⲖ ϦⲈⲚⲠϪⲢⲞϪ ⲘⲪⲀⲒ Ⲁ- ⲪⲚⲞⲨϮ ⲔⲀⲦⲀ ⲞⲨⲰϢ ⲀϤⲒⲚⲒ ⲘⲠⲒⲤⲖ ⲚⲞⲨⲤⲰⲦⲎⲢ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ⲈⲀϤⲈⲢϢⲞⲢⲠ ⲚϨⲒⲰⲒϢ ϦⲀϪⲈⲚ ⲠⲈϤⲘⲰⲒⲦ ⲈϦⲞⲨⲚ ⲚϪⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲞⲨⲰⲘⲤ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲚⲦⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ⲈⲦⲀ ⲒⲰⲀⲚⲚⲎⲤ ⲆⲈ ϪⲰⲔ ⲘⲠⲈϤⲆⲢⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲚⲀϤⲬⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲢⲈⲦⲈⲚⲘⲈⲨⲒ ϪⲈ ⲀⲚⲞⲔ ⲚⲒⲘ ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ϨⲎⲠⲠⲈ ⲈϤⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰⲒ ⲚϪⲈⲪⲎ ⲈⲦⲈⲚϮⲘⲠϢⲀ ⲀⲚ ⲈϮⲞⲨⲰ ⲘⲠⲒⲐⲰⲞⲨⲒ ⲚⲦⲈⲚⲈϤϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲄⲈⲚⲞⲤ ⲚⲀⲂⲢⲀⲀⲘ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲢϨⲞϮ ϦⲈⲚⲐⲎⲚⲞⲨ ϦⲀⲦϨⲎ ⲘⲪⲚⲞⲨϮ ⲈⲦⲀⲨⲞⲨⲰⲢⲠ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲠⲀⲒⲞⲨϪⲀⲒ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ⲚⲎ ⲄⲀⲢ ⲈⲦϢⲞⲠ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ⲚⲞⲨⲔⲈⲀⲢⲬⲰⲚ ⲪⲀⲒ ⲀⲨⲈⲢⲀⲦⲈⲘⲒ ⲈⲢⲞϤ ⲚⲈⲘ ⲚⲒⲔⲈⲤⲘⲎ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲀⲒ ⲈⲦⲞⲨⲰϢ ⲘⲘⲰⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲀⲨϮϨⲀⲠ ⲈⲀⲨϪⲞⲔⲞⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ⲞⲨⲞϨ ⲈⲦⲈⲘⲠⲞⲨϪⲈⲘ ϨⲖⲒ ⲚⲖⲰⲒϪⲒ ⲚⲦⲈⲪⲘⲞⲨ ⲚϦⲎⲦϤ ⲀⲨⲈⲢⲈⲦⲒⲚ ⲘⲠⲒⲖⲀⲦⲞⲤ ⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲤϦⲎⲞⲨⲦ ⲈⲐⲂⲎⲦϤ ⲀⲨⲬⲀϤ ⲈⲠⲈⲤⲎⲦ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲒϢⲈ ⲀⲨⲬⲀϤ ⲚϦⲞⲨⲚ ϦⲈⲚⲞⲨⲘϨⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ⲪⲚⲞⲨϮ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ⲪⲀⲒ ⲈⲦⲀϤⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲚⲚⲎ ⲈⲦⲀⲨⲒ ⲚⲈⲘⲀϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲄⲀⲖⲒⲖⲈⲀ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲀⲒ ϮⲚⲞⲨ ⲈⲦⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲀϤ ϢⲀ ⲠⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲦⲈⲚϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲰϢ ⲈⲦⲀϤϢⲰⲠⲒ ϦⲈⲚⲚⲒⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ϪⲈ ⲪⲀⲒ ⲀⲪⲚⲞⲨϮ ϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲚⲒϢⲎⲢⲒ ⲈⲦⲀϤⲦⲞⲨⲚⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲘⲪⲢⲎϮ ⲈⲦⲤϦⲎ ⲞⲨⲦ ϦⲈⲚⲠⲒⲘⲀϨⲂ ⲘⲮⲀⲖⲘⲞⲤ ϪⲈ ⲚⲐⲞⲔ ⲠⲈ ⲠⲀϢⲎⲢⲒ ⲀⲚⲞⲔ ⲀⲒϪⲪⲞⲔ ⲘⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ⲞⲦⲒ ⲆⲈ ϪⲈ ⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ϤⲚⲀⲦⲀⲤⲐⲞ ⲀⲚ ϪⲈ ⲈⲠⲦⲀⲔⲞ ⲀϤϪⲞⲤ ⲘⲠⲀⲒⲢⲎϮ ϪⲈ ⲈⲒⲈϮ ⲚⲰⲦⲈⲚ ⲚⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲚⲦⲈⲆⲀⲨⲒⲆ ⲈⲦⲈⲚϨⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲚ ϤϪⲰ ⲘⲘⲞⲤ ϦⲈⲚⲔⲈⲘⲀ ϪⲈ ⲚⲚⲈⲔϮ ⲘⲠⲈⲐⲞⲨⲀⲂ ⲚⲦⲀⲔ ⲈⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ⲆⲀⲨⲒⲆ ⲘⲈⲚ ⲄⲀⲢ ⲚϦⲢⲎⲒ ϦⲈⲚⲦⲈϤⲄⲈⲚⲈⲀ ⲚⲀϤϢⲈⲘϢⲒ ⲘⲠⲒⲤⲞϬⲚⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤⲈⲚⲔⲞⲦ ⲞⲨⲞϨ ⲀⲨⲬⲀϤ ϦⲀⲦⲈⲚ ⲚⲈϤⲒⲞϮ ⲞⲨⲞϨ ⲀϤⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ⲪⲎ ⲆⲈ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲘⲠⲈϤⲚⲀⲨ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ⲘⲀⲢⲈ ⲠⲒϨⲰⲂ ⲞⲨⲚ ⲞⲨⲰⲚϨ ⲈⲢⲰⲦⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲀⲒ ⲤⲈϨⲒⲰⲒϢ ⲚⲰⲦⲈⲚ ⲘⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲈⲦⲈⲚⲚⲞⲂⲒ ⲚⲈⲘ ⲈⲂⲞⲖ ϨⲀ ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲘⲠⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ ⲈⲐⲀⲘⲒⲞ ⲚϦⲎⲦⲞⲨ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ϦⲈⲚ ⲪⲀⲒ ⲆⲈ ⲚⲐⲞϤ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲤⲈⲚⲀⲐⲘⲀⲒⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ⲀⲚⲀⲨ ⲞⲨⲚ ⲘⲎⲠⲰⲤ ⲚⲦⲈϤⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚϪⲈⲪⲎ ⲈⲦⲀϤϪⲞϤ ϦⲈⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ϪⲈ ⲀⲚⲀⲨ ⲚⲒⲔⲀⲦⲀⲪⲢⲞⲚⲒⲦⲎⲤ ⲞⲨⲞϨ ⲀⲢⲒϢⲪⲎⲢⲒ ⲞⲨⲞϨ ⲘⲀⲔⲈⲦ ⲐⲎⲚⲞⲨ ϪⲈ ϮⲚⲀⲒⲢⲒ ⲚⲞⲨϨⲰⲂ ϦⲈⲚⲚⲈⲦⲈⲚⲈϨⲞⲞⲨ ⲞⲨϨⲰⲂ ⲚⲦⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲞϤ ⲀⲚ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ⲪⲒⲢⲒ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ⲈⲨⲚⲎⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚⲀⲨⲈⲢⲀⲜⲒⲞⲒⲚ ϨⲒⲚⲀ ⲚⲤⲈⲤⲀϪⲒ ϦⲈⲚⲠⲒⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲐⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ⲈⲦⲀⲤⲂⲰⲖ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲀⲨⲘⲞϢⲒ ⲚⲤⲀⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚϪⲈⲞⲨⲘⲎϢ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈⲢⲤⲈⲂⲈⲤⲐⲈ ϦⲈⲚⲚⲒϢⲈⲘⲘⲰⲞⲨ ⲈⲨⲐⲰⲦ ⲘⲠⲞⲨϨⲎⲦ ⲈⲐⲢⲞⲨϢⲰⲠⲒ ϦⲈⲚⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ⲚϦⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲔⲈⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲐⲚⲎⲞⲨ ⲤⲬⲈⲆⲞⲚ ⲀϮⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲐⲰⲞⲨϮ ⲈⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲚⲒⲘⲎ ϢⲀⲨⲘⲞϨ ⲚⲬⲞϨ ⲞⲨⲞϨ ⲚⲀⲨϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲚⲎ ⲈⲚⲀⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲰⲞⲨ ⲈⲨϪⲈⲞⲨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ⲈⲦⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲈⲞⲨⲀⲚⲀⲄⲔⲈⲞⲚ ⲠⲈ ⲈⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲚϢⲞⲢⲠ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲠⲒⲆⲎ ⲦⲈⲦⲈⲚϨⲒⲞⲨⲒ ⲘⲘⲞϤ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲰⲠ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ⲈⲈⲢⲠⲈⲘⲠϢⲀ ⲘⲠⲒⲰⲚϦ ⲚⲈⲚⲈϨ ϨⲎⲠⲠⲈ ⲦⲈⲚⲚⲀⲔⲞⲦⲦⲈⲚ ⲈⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ⲪⲀⲒ ⲄⲀⲢ ⲠⲈ ⲘⲪⲢⲎϮ ⲈⲦⲀϤϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲈⲚ ⲚϪⲈⲠϬⲞⲒⲤ ϪⲈ ⲀⲒⲬⲀⲔ ⲈⲨⲞⲨⲰⲒⲚⲒ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲈⲐⲢⲈⲔϢⲰⲠⲒ ⲈⲨⲞⲨϪⲀⲒ ϢⲀ ⲀⲨⲢⲎϪϤ ⲘⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲈⲐⲚⲞⲤ ⲀⲨⲢⲀϢⲒ ⲞⲨⲞϨ ⲚⲀⲨϮⲰⲞⲨ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀⲨⲚⲀϨϮ ⲚϪⲈⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲐⲎϢ ⲈⲠⲒⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ⲚⲀⲨⲔⲰϮ ⲆⲈ ⲚⲈⲘ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ϦⲈⲚϮⲬⲰⲢⲀ ⲦⲎⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲚⲀⲨϢⲞⲠϢⲈⲠ ⲚⲚⲒϨⲒⲞⲘⲒ ⲈⲦⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲚⲈⲘ ⲚⲒⲈⲨⲤⲬⲎⲘⲰⲚ ⲚⲈⲘ ⲚⲒϨⲞⲨⲀϮ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ⲞⲨⲞϨ ⲀⲨⲦⲞⲨⲚⲞⲤ ⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲞⲨⲞϨ ⲀⲨϨⲒⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲚⲚⲞⲨⲐⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ⲚⲐⲰⲞⲨ ⲆⲈ ⲀⲨⲚⲈϨ ⲠϢⲰⲒϢ ⲚⲚⲞⲨϬⲀⲖⲀⲨϪ ⲈⲂⲞⲖ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲒⲔⲞⲚⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲆⲈ ⲚⲀⲨⲘⲈϨ ⲚⲢⲀϢⲒ ⲚⲈⲘ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲒⲔⲞⲚⲒⲞⲚ ⲔⲀⲦⲀ ⲠⲀⲒⲢⲎϮ ⲢⲰ ⲈⲐⲢⲞⲨϢⲈ ⲈϦⲞⲨⲚ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲚⲤⲈⲤⲀϪⲒ ⲘⲠⲀⲒⲢⲎϮ ϨⲰⲤⲆⲈ ⲚⲤⲈⲚⲀϨϮ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ⲚⲒⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲈⲦⲀⲨⲈⲢⲀⲦⲐⲰⲦ ⲚϨⲎⲦ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲞⲨⲞϨ ⲀⲨϮⲘⲔⲀϨ ⲚⲚⲒⲮⲨⲬⲎ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲈⲐⲂⲈ ⲚⲒⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ⲀⲨⲈⲢ ⲞⲨⲚⲒϢϮ ⲘⲈⲚ ⲞⲨⲚ ⲚⲬⲢⲞⲚⲞⲤ ⲘⲘⲀⲨ ⲈⲨⲞⲨⲞⲚϨ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲪⲀⲒ ⲈⲦⲈⲢⲘⲈⲐⲢⲈ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲤⲀϪⲒ ⲚⲦⲈⲠⲈϤϨⲘⲞⲦ ⲈϤϮ ⲚϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎ ⲢⲒ ⲈⲐⲢⲞⲨϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲞⲨϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ⲀϤⲪⲰⲢϪ ⲆⲈ ⲚϪⲈⲠⲒⲘⲎϢ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲚⲀⲨⲬⲎ ⲚⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨⲬⲎ ⲚⲈⲘ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ⲈⲦⲀⲨϬⲞϪⲒ ⲆⲈ ⲚϪⲈⲚⲒⲈⲐⲚⲞⲤ ⲚⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲞⲨⲔⲈⲀⲢⲬⲰⲚ ⲈϢⲞϢⲞⲨ ⲞⲨⲞϨ ⲈⲤⲈⲦⲰⲚⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ⲈⲦⲀⲨⲚⲀⲨ ⲀⲨⲪⲰⲦ ⲈϨⲢⲎⲒ ⲈⲚⲒⲠⲞⲖⲒⲤ ⲚⲦⲈⲖⲨⲔⲀⲞⲚⲒⲀ ⲖⲨⲤⲦⲢⲀ ⲚⲈⲘ ⲦⲈⲢⲂⲎ ⲚⲈⲘ ϮⲠⲈⲢⲒⲬⲰⲢⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ⲚⲀⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲘⲘⲀⲨ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ⲞⲨⲞϨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲀⲦϪⲞⲘ ϦⲈⲚⲚⲈϤϬⲀⲖⲀⲨϪ ϦⲈⲚⲖⲨⲤⲦⲢⲀ ⲚⲀϤϨⲈⲘⲤⲒ ⲈϤⲞⲒ ⲚϬⲀⲖⲈ ⲒⲤϪⲈⲚ ⲈϤϦⲈⲚ ⲐⲚⲈϪⲒ ⲚⲦⲈⲦⲈϤⲘⲀⲨ ⲘⲠⲈϤⲘⲞϢⲒ ⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ⲞⲨⲞϨ ⲪⲀⲒ ⲀϤⲤⲰⲦⲈⲘ ⲈⲠⲀⲨⲖⲞⲤ ⲈϤⲤⲀϪⲒ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤⲤⲞⲘⲤ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ϪⲈ ⲞⲨⲞⲚ ⲚⲀϨϮ ⲚϦⲎⲦϤ ⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ⲠⲈϪⲀϤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲦⲰⲚⲔ ⲞϨⲒ ⲈⲢⲀⲦⲔ ⲈϪⲈⲚ ⲚⲈⲔϬⲀⲖⲀⲨϪ ⲞⲨⲞϨ ⲚⲀϤϬⲒⲪⲈⲒ ⲞⲨⲞϨ ⲚⲀϤⲘⲞϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ⲚⲒⲘⲎϢ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲪⲎ ⲈⲦⲀϤⲀⲒϤ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲀⲨϬⲒⲤⲒ ⲚⲦⲞⲨⲤⲘⲎ ⲈϨⲢⲎⲒ ⲘⲘⲈⲦⲖⲨⲔⲀⲰⲚ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ Ⲁ- ⲚⲒⲚⲞⲨϮ ⲈⲢ ⲘⲪⲢⲎϮ ⲚⲚⲒⲢⲰⲘⲒ ⲀⲨⲒ ⲈⲠⲈⲤⲎⲦ ϢⲀⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ⲚⲀⲨⲘⲞⲨϮ ⲘⲈⲚ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ϪⲈ ⲠⲒⲌⲈⲨⲤ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ϪⲈ ⲠⲒⲈⲢⲘⲎⲤ ⲈⲠⲒⲆⲎ ⲚⲐⲞϤ ⲈⲦⲞⲒ ⲚϨⲨⲄⲞⲨⲘⲈⲚⲞⲤ ⲚⲦⲈⲠⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ⲠⲒⲞⲨⲎⲂ ⲆⲈ ⲚⲦⲈⲠⲒⲌⲈⲨⲤ ⲪⲎ ⲈⲚⲀϤⲬⲎ ϦⲀϪⲰⲤ ⲚϮⲠⲞⲖⲒⲤ ⲀϤⲒⲚⲒ ⲚϨⲀⲚⲘⲀⲤⲒ ⲚⲈⲘ ϨⲀⲚⲬⲖⲞⲘ ⲈϨⲢⲎⲒ ⲈⲠⲒⲠⲨⲖⲰⲚ ⲚⲀϤⲞⲨⲰϢ ⲈϢⲰⲦ ⲠⲈ ⲚⲈⲘ ⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ ⲀⲨⲪⲰϦ ⲚⲚⲞⲨϨⲂⲰⲤ ⲀⲨϬⲞϪⲒ ϢⲀ ⲠⲒⲘⲎϢ ⲈⲨⲰϢ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲚⲒⲢⲰⲘⲒ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲚⲚⲀⲒ ⲀⲚⲞⲚ ϨⲰⲚ ⲀⲚⲞⲚ ϨⲀⲚⲢⲰⲘⲒ ⲚⲢⲈϤϢⲈⲠⲘⲔⲀϨ ⲘⲠⲈⲦⲈⲚⲢⲎϮ ⲈⲚϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲦⲈⲚ ⲈϨⲈⲚ ⲐⲎⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲚⲚⲒⲘⲈⲦⲈⲪⲖⲎⲞⲨ ⲞⲨⲞϨ ⲈⲔⲈⲦ ⲐⲎⲚⲞⲨ ⲈⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ ⲪⲎ ⲈⲦⲀϤⲐⲀⲘⲒⲞ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲚⲈⲘ ⲪⲒⲞⲘ ⲚⲈⲘ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ⲪⲎ ⲈⲦⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲒⲄⲈⲚⲈⲀ ⲈⲦⲀⲨⲤⲒⲚⲒ ⲀϤⲬⲰ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲐⲢⲞⲨⲘⲞϢⲒ ϨⲒ ⲚⲞⲨⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ⲔⲈⲦⲞⲒ ⲘⲠⲈϤⲬⲀϤ ⲈϤⲞⲒ ⲚⲀⲦⲘⲈⲐⲢⲈ ⲈϤⲒⲢⲒ ⲚϨⲀⲚⲠⲈⲐⲚⲀⲚⲈⲨ ⲀϤϮ ⲚⲰⲞⲨ ⲚϨⲀⲚⲘⲞⲨⲚϨⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲚⲈⲘ ϨⲀⲚⲤⲎⲞⲨ ⲘⲘⲀⲤⲞⲨⲦⲀϨ ⲈϤⲦⲤⲒⲞ ⲚⲚⲈⲦⲈⲚϨⲎⲦ ⲚϦⲢⲈ ⲚⲈⲘ ⲞⲨⲚⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲨϪⲰ ⲘⲘⲰⲞⲨ ⲘⲞⲄⲒⲤ ⲀⲨⲐⲢⲈ ⲠⲒⲘⲎϢ ϨⲈⲢⲒ ⲈϢⲦⲈⲘϢⲰⲦ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ⲀⲨϢⲈ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚⲈⲘ ⲒⲔⲞⲚⲒⲞⲚ ⲚϪⲈϨⲀⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲐⲈⲦ ϨⲎⲦ ⲚⲚⲒⲘⲎϢ ⲀⲨϨⲒⲰⲚⲒ ⲈϪⲈⲚ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲀⲨⲰϢϮ ⲘⲘⲞϤ ⲤⲀⲂⲞⲖ ⲚϮⲠⲞⲖⲒⲤ ⲈⲨⲘⲈⲨⲒ ϪⲈ ⲀϤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ⲈⲨⲔⲰϮ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲦⲀϤⲦⲰⲚϤ ⲆⲈ ⲀϤⲒ ⲈϦⲞⲨⲚ ⲈϮⲂⲀⲔⲒ ⲞⲨⲞϨ ⲠⲈϤⲢⲀⲤϮ ⲀϤⲒ ⲈⲂⲞⲖ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈϨⲢⲎⲒ ⲈⲦⲈⲢⲂⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ⲈⲦⲀⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲆⲈ ϦⲈⲚϮⲠⲞⲖⲒⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨϮⲤⲂⲰ ⲚⲞⲨⲚⲒϢϮ ⲘⲘⲎ ϢⲀⲨⲦⲀⲤⲐⲞ ⲈϨⲢⲎⲒ ⲈⲖⲨⲤⲦⲢⲀ ⲚⲈⲘ ⲒⲔⲞⲚⲒⲞⲚ ⲚⲈⲘ ⲦⲀⲚϮⲞⲬⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ⲈⲨⲦⲀϪⲢⲞ ⲚⲚⲒⲮⲨⲬⲎ ⲚⲦⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲨϮⲚⲞⲘϮ ⲚⲰⲞⲨ ⲈⲐⲢⲞⲨⲞϨⲒ ϦⲈⲚⲠⲒⲚⲀϨϮ ⲞⲨⲞϨ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲚϨⲞϪϨⲈϪ ϨⲰϮ ⲈⲢⲞⲚ ⲈϢⲈ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ⲀⲨⲬⲀϪⲒϪ ⲆⲈ ⲈϪⲈⲚ ϨⲀⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲰⲞⲨ ⲔⲀⲦⲀ ⲈⲔⲔⲖⲎⲤⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨⲦⲰⲂϨ ϦⲈⲚϨⲀⲚⲚⲎⲤⲦⲒⲀ ⲀⲨⲬⲀⲨ ϦⲀⲦⲈⲚ ⲠϬⲞⲒⲤ ⲪⲎ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ⲈⲦⲀⲨⲤⲈⲚ ϮⲠⲒⲤⲒⲆⲒⲀ ⲆⲈ ⲀⲨⲒ ⲈϮⲠⲀⲘⲪⲨⲖⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲀϪⲒ ⲘⲠⲒⲤⲀϪⲒ ϦⲈⲚⲠⲈⲢⲄⲎ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲀⲦⲦⲀⲖⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ⲞⲨⲞϨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲨⲈⲢϨⲰⲦ ⲈⲦⲀⲚϮⲞⲬⲒⲀ ⲠⲒⲘⲀ ⲈⲦⲀⲨⲦⲎⲒⲦⲞⲨ ⲚϦⲎⲦϤ ϦⲈⲚⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲠⲒϨⲰⲂ ⲈⲦⲀⲨϪⲞⲔϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ⲈⲦⲀⲨⲒ ⲆⲈ ⲞⲨⲞϨ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲀⲨⲦⲀⲘⲞ ⲘⲘⲰⲞⲨ ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀϤⲀⲒⲦⲞⲨ ⲚⲈⲘⲰⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ϪⲈ ⲀϤⲞⲨⲰⲚ ⲚⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲀϨϮ ⲚⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ⲀⲨϢⲰⲠⲒ ⲆⲈ ⲘⲘⲀⲨ ⲚⲈⲘ ⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲤⲎⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲚⲀⲨϮⲤⲂⲰ ⲚⲚⲒⲤⲚⲎⲞⲨ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲦⲈⲘⲤⲞⲨⲂⲈ ⲐⲎⲚⲞⲨ ⲔⲀⲦⲀ ⲦⲤⲨⲚⲎ ⲐⲒⲀ ⲘⲘⲰⲨⲤⲎⲤ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ⲈⲦⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀⲚ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀⲨⲐⲰϢ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲐⲢⲞⲨϢⲈ ϢⲀ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲚⲀⲨ ⲈⲐⲂⲈ ⲠⲀⲒⲌⲎⲦⲎⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲦⲪⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲀⲨⲤⲒⲚⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲪⲞⲒⲚⲒⲔⲎ ⲚⲈⲘ ⲦⲤⲀⲘⲀⲢⲒⲀ ⲈⲨⲤⲀϪⲒ ⲈⲐⲂⲈ ⲠⲦⲀⲤⲐⲞ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ⲚⲀⲨⲒⲢⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲢⲀϢⲒ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨϢⲞⲠⲞⲨ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲀ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲈⲘ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲀⲨⲦⲀⲘⲰⲞⲨ ⲆⲈ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲀⲒⲦⲞⲨ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ⲀⲨⲦⲰⲞⲨⲚ ⲆⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲦϨⲈⲢⲈⲤⲒⲤ ⲚⲦⲈⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲎ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤϢⲈ ⲚⲤⲈⲤⲞⲨⲂⲎⲦⲞⲨ ⲞⲨⲞϨ ⲈϨⲞⲚϨⲈⲚ ⲈⲀⲢⲈϨ ⲈⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ⲀⲨⲐⲰⲞⲨϮ ⲆⲈ ⲚϪⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲚⲀⲨ ⲈⲐⲂⲈ ⲠⲀⲒⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ⲈⲦⲀⲤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲌⲎⲆⲎⲤⲒⲤ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲠⲈⲦⲢⲞⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲒⲤϪⲈⲚ ⲚⲒⲈϨⲞⲞⲨ ⲚⲀⲢⲬⲈⲞⲤ ⲀⲪⲚⲞⲨϮ ⲤⲰⲦⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲒ ⲈⲐⲢⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲤⲰⲦⲈⲘ ⲈⲠⲤⲀϪⲒ ⲚⲦⲈⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲞⲨⲞϨ ⲚⲤⲈⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ⲞⲨⲞϨ ⲠⲈⲦⲤⲰⲞⲨⲚ ⲚⲚⲒϨⲎⲦ ⲪⲚⲞⲨϮ ⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ⲞⲨⲞϨ ⲀϤϮ ⲚⲰⲞⲨ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲘⲪⲢⲎϮ ϨⲰⲚ ⲈⲦⲀϤⲦⲎⲒϤ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ⲞⲨⲞϨ ⲘⲠⲈϤⲬⲀ ϨⲖⲒ ⲚϢⲒⲂϮ ⲞⲨⲦⲰⲚ ⲚⲈⲘⲰⲞⲨ ⲈⲀϤⲦⲞⲨⲂⲞ ⲚⲚⲞⲨϨⲎⲦ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲒⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ϮⲚⲞⲨ ⲞⲨⲚ ⲈⲐⲂⲈⲞⲨ ⲦⲈⲦⲈⲚⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲪⲚⲞⲨϮ ⲈⲦⲀⲖⲈ ⲞⲨⲚⲀϨⲂⲈϤ ⲈϪⲈⲚ ⲚⲈⲚⲘⲞϮ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲪⲀⲒ ⲈⲦⲈⲘⲠⲈ ⲚⲈⲚⲒⲞϮ ⲞⲨⲆⲈ ⲀⲚⲞⲚ ϢϪⲈⲘϪⲞⲘ ⲚⲦⲰⲞⲨⲚ ϦⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲦⲈⲚⲚⲀϨϮ ⲈⲚⲞϨⲈⲘ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲚⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ⲀⲨⲬⲀⲢⲰϤ ⲆⲈ ⲚϪⲈⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲚⲀⲨⲤⲰⲦⲈⲘ ⲈⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ ⲈⲨⲤⲀϪⲒ ⲚⲚⲒⲘⲎⲒⲚⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϢⲪⲎⲢⲒ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲀⲒⲦⲞⲨ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ⲘⲈⲚⲈⲚⲤⲀ ⲈⲦⲀⲨⲬⲀⲢⲰⲞⲨ ⲆⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲒⲀⲔⲰⲂⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ⲤⲨⲘⲈⲰⲚ ⲀϤⲤⲀϪⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ⲈⲦⲀ ⲪⲚⲞⲨϮ ϪⲈⲘⲠϢⲒⲚⲒ ⲈϬⲒ ⲚⲞⲨⲖⲀⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ϦⲈⲚⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ⲞⲨⲞϨ ⲪⲀⲒ ⲤⲈϮⲘⲀϮ ⲚⲈⲘⲀϤ ⲚϪⲈⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ϪⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲈⲒⲈⲦⲀⲤⲐⲞ ⲞⲨⲞϨ ⲈⲒⲈⲔⲰⲦ ⲚϮⲤⲔⲎⲚⲎ ⲚⲦⲈⲆⲀⲨⲒⲆ ⲐⲎ ⲈⲦⲀⲤϨⲈⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀⲨⲤⲰⲤ ⲚⲦⲀⲤ ⲈⲒⲈⲔⲞⲦⲞⲨ ⲞⲨⲞϨ ϮⲚⲀⲦⲀϨⲞⲤ ⲈⲢⲀⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ϨⲞⲠⲰⲤ ⲚⲤⲈⲔⲰϮ ⲚⲤⲀⲠϬⲞⲒⲤ ⲚϪⲈⲠⲤⲰϪⲠ ⲚⲚⲒⲢⲰⲘⲒ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲎ ⲈⲦⲀⲨⲘⲞⲨϮ ⲈⲠⲀⲢⲀⲚ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲪⲎ ⲈⲦⲐⲢⲞ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲒⲤϪⲈⲚ ⲠⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ⲈⲐⲂⲈⲪⲀⲒ ϮϮϨⲀⲠ ⲀⲚⲞⲔ ⲈϢⲦⲈⲘⲞⲨⲀϨϦⲒⲤⲒ ⲚⲚⲎ ⲈⲐⲚⲀⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ⲀⲖⲖⲀ ⲈⲞⲨⲰⲢⲠ ⲚⲰⲞⲨ ⲈⲐⲢⲞⲨϨⲈⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲚⲚⲒϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲚⲈⲘ ϮⲠⲞⲢⲚⲒⲀ ⲚⲈⲘ ⲚⲒⲰϪϨ ⲚⲈⲘ ⲚⲒⲤⲚⲞϤ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲒⲤϪⲈⲚ ⲚⲒⲄⲈⲚⲈⲀ ⲚⲀⲢⲬⲈⲞⲤ ⲞⲨⲞⲚⲦⲀϤ ⲚⲚⲎ ⲈⲦϨⲒⲰⲒϢ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲨⲰϢ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ⲦⲞⲦⲈ ⲀⲤⲈⲢⲆⲞⲔⲒⲚ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲈⲤⲰⲦⲠ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲞⲨⲞⲢⲠⲞⲨ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲒⲞⲨⲆⲀⲤ ⲠⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲂⲀⲢⲤⲀⲂⲂⲀⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ϨⲀⲚⲢⲰⲘⲒ ⲚϨⲨⲄⲞⲨⲘⲈⲚⲞⲤ ϦⲈⲚⲚⲒⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ⲈⲀⲨⲤϦⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲚⲎ ⲈⲦⲬⲎ ϦⲈⲚⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲚⲈⲘ ϮⲔⲨⲖⲒⲔⲒⲀ ⲚⲈⲘ ϮⲤⲨⲢⲒⲀ ⲚⲒⲤⲚⲎⲞⲨ ⲚⲒⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲬⲈⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ⲈⲠⲒⲆⲎ ⲀⲚⲤⲰⲦⲈⲘ ϪⲈ ϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨϢⲐⲈⲢⲦⲈⲢ ⲐⲎⲚⲞⲨ ⲈⲨⲪⲰⲚϨ ⲚⲚⲈⲦⲈⲚⲮⲨⲬⲎ ϦⲈⲚϨⲀⲚⲤⲀϪⲒ ⲚⲀⲒ ⲈⲦⲈ ⲘⲠⲈⲚϪⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ⲀⲤⲈⲢⲆⲞⲔⲒⲚ ⲞⲨⲚ ⲚⲀⲚ ⲈⲀⲚⲒ ⲈⲨⲘⲀ ⲈⲨⲤⲞⲠ ⲈⲤⲰⲦⲠ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲞⲨⲞⲢⲠⲞⲨ ϨⲀⲢⲰⲦⲈⲚ ⲚⲈⲘ ⲚⲈⲚⲀⲄⲀⲠⲎⲦⲞⲤ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ϨⲀⲚⲢⲰⲘⲒ ⲈⲀⲨϮ ⲚⲦⲞⲨⲮⲨⲬⲎ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲪⲢⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ⲀⲚⲞⲨⲰⲢⲠ ⲆⲈ ⲚⲒⲞⲨⲆⲀⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲈⲨⲦⲀⲘⲰⲦⲈⲚ ⲈⲚⲀⲒ ⲢⲰ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ⲀⲤⲢⲀⲚⲀϤ ⲄⲀⲢ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲀⲚⲞⲚ ϨⲰⲚ ⲈϢⲦⲈⲘⲞⲨⲀϨⲂⲀⲢⲞⲤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚϨⲞⲨⲞ ⲠⲖⲎⲚ ⲚⲀⲒ ϦⲈⲚⲞⲨⲀⲚⲀⲄⲔⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ⲀⲢⲈϨ ⲈⲢⲰⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲚⲒϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲚⲈⲘ ⲚⲒⲤⲚⲞϤ ⲈⲐⲘⲰⲞⲨⲦ ⲚⲈⲘ ⲚⲒⲰϪϨ ⲚⲈⲘ ⲚⲒⲠⲞⲢⲚⲒⲀ ⲚⲀⲒ ⲈⲢⲈⲦⲈⲚⲀⲢⲈϨ ⲈⲢⲰⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲚⲦⲈⲦⲈⲚⲈⲢϨⲰⲂ ⲚⲔⲀⲖⲰⲤ ⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ⲚⲐⲰⲞⲨ ⲘⲈⲚ ⲞⲨⲚ ⲈⲦⲀⲨⲬⲀⲨ ⲈⲂⲞⲖ ⲀⲨⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲘⲠⲒⲘⲎ ϢⲀⲨϮ ⲚϮⲈⲠⲒⲤⲦⲞⲖⲎ ");
INSERT INTO copbhc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ⲈⲦⲀⲨⲰϢ ⲆⲈ ⲀⲨⲢⲀϢⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲒⲐⲰⲦ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ⲒⲞⲨⲆⲀⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ϨⲰⲞⲨ ⲚⲈⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲤⲀϪⲒ ⲈϤⲞϢ ⲀⲨⲐⲈⲦ ⲠϨⲎⲦ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲀⲨⲦⲀϪⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ⲈⲦⲀⲨⲈⲢ ⲞⲨⲬⲢⲞⲚⲞⲤ ⲆⲈ ϦⲀⲦⲞⲦⲞⲨ ⲀⲨⲬⲀⲨ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ ⲈⲐⲢⲞⲨϢⲈ ϢⲀ ⲚⲎ ⲈⲦⲀⲨⲞⲨⲞⲢⲠⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ⲤⲒⲖⲀⲤ ⲆⲈ ⲀϤⲞⲨⲰϢ ⲈϢⲰⲠⲒ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲀⲨϢⲰⲠⲒ ϦⲈⲚⲦⲀⲚⲦⲒⲞⲬⲒⲀ ⲈⲨϮⲤⲂⲰ ⲞⲨⲞϨ ⲈⲨϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲈⲘ ⲔⲈⲘⲎϢ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ⲘⲈⲚⲈⲚⲤⲀ ϨⲀⲚⲈϨⲞⲞⲨ ⲆⲈ ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲂⲀⲢⲚⲀⲂⲀⲤ ϪⲈ ⲘⲀⲢⲈⲚⲔⲞⲦⲦⲈⲚ ⲚⲦⲈⲚϪⲈⲘⲠϢⲒⲚⲒ ⲚⲚⲈⲚⲤⲚⲎⲞⲨ ⲔⲀⲦⲀ ⲂⲀⲔⲒ ⲚⲒⲂⲈⲚ ⲚⲎ ⲈⲦⲀⲚϨⲒⲰⲒϢ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚϦⲎⲦⲞⲨ ϪⲈ ⲞⲨ ⲠⲈⲦϢⲞⲠ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲚⲀϤⲞⲨⲰϢ ⲈⲰⲖⲒ ⲘⲠⲔⲈⲒⲰⲀⲚⲚⲎⲤ ⲚⲈⲘⲰⲞⲨ ⲠⲈⲦⲞⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲘⲀⲢⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲀϤⲈⲢⲀⲜⲒⲞⲒⲚ ϪⲈⲬⲀⲤ ⲪⲎ ⲈⲦⲀϤⲪⲰⲢϪ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲒⲤϪⲈⲚ ⲦⲠⲀⲘⲪⲨⲖⲒⲀ ⲞⲨⲞϨ ⲈⲦⲈ ⲘⲠⲈϤⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲠⲒϨⲰⲂ ⲈϢⲦⲈⲘⲞⲖϤ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨϪⲰⲚⲦ ϨⲰⲤⲦⲈ ⲚⲤⲈⲪⲰⲢϪ ⲈⲂⲞⲖ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲆⲈ ⲀϤϬⲒ ⲘⲘⲀⲢⲔⲞⲤ ⲀϤⲈⲢϨⲰⲦ ⲈⲔⲨⲠⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲀϤⲤⲰⲦⲠ ⲚⲤⲒⲖⲀⲤ ⲀϤⲒ ⲈⲂⲞⲖ ⲈⲀⲨⲦⲎⲒϤ ⲚⲦⲈⲚ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ⲚⲀϤⲤⲒⲚⲒ ⲆⲈ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲦⲤⲨⲢⲒⲀ ⲚⲈⲘ ⲦⲔⲨⲖⲒⲔⲒⲀ ⲈϤⲦⲀϪⲢⲞ ⲚⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ⲀϤⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲦⲔⲈⲦⲈⲢⲂⲎ ⲚⲈⲘ ⲖⲨⲤⲦⲢⲀ ⲞⲨⲞϨ ⲒⲤ ⲞⲨⲘⲀⲐⲎⲦⲎⲤ ⲈⲚⲀϤⲬⲎ ⲘⲘⲀⲨ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲠϢⲎⲢⲒ ⲚⲞⲨⲤϨⲒⲘⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲘⲠⲒⲤⲦⲎ ⲠⲈϤⲒⲰⲦ ⲆⲈ ⲚⲈⲞⲨⲈⲒⲚⲒⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ⲪⲀⲒ ⲚⲀⲨⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦϤ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲈⲦϦⲈⲚ ⲖⲨⲤⲦⲢⲀ ⲚⲈⲘ ⲒⲔⲞⲚⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ⲪⲀⲒ ⲀϤⲞⲨⲰϢ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲐⲢⲈϤⲒ ⲈⲂⲞⲖ ⲚⲈⲘⲀϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲖϤ ⲀϤⲤⲞⲨⲂⲎⲦϤ ⲈⲐⲂⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲦϢⲞⲠ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲨⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ϪⲈ ⲠⲈϤⲒⲰⲦ ⲞⲨⲞⲨⲈⲒⲚⲒⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ⲈⲨⲔⲰϮ ⲆⲈ ϦⲈⲚⲚⲒⲠⲞⲖⲒⲤ ⲚⲀⲨϮ ⲘⲘⲞⲤ ⲈⲦⲞⲦⲞⲨ ⲈⲀⲢⲈϨ ⲈⲚⲒϨⲰⲚ ⲈⲦⲀⲨⲤⲈⲘⲚⲎ ⲦⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲈⲚ ⲞⲨⲚ ⲚⲀⲨⲚⲎⲞⲨ ⲚⲦⲀϪⲢⲞ ϦⲈⲚⲠⲒⲚⲀϨϮ ⲞⲨⲞϨ ⲚⲀⲨⲚⲎⲞⲨ ⲚⲀϢⲀⲒ ϦⲈⲚⲦⲞⲨⲎⲠⲒ ⲘⲘⲎⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ⲀⲨⲤⲒⲚⲒ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲪⲢⲒⲔⲒⲀ ⲚⲈⲘ ϮⲬⲰⲢⲀ ⲚⲦⲈϮⲄⲀⲖⲀⲦⲒⲀ ⲈⲀϤⲦⲀϨⲚⲞ ⲘⲘⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈϢⲦⲈⲘⲤⲀϪⲒ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚϮⲀⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲚⲒⲘⲀ ⲚⲦⲈϮⲘⲨⲤⲒⲀ ⲚⲀⲨϬⲰⲚⲦ ⲘⲘⲰⲞⲨ ⲈϢⲈ ⲈϮⲂⲎⲐⲈⲚⲒⲀ ⲞⲨⲞϨ ⲚⲀϤⲬⲰ ⲘⲘⲰⲞⲨ ⲀⲚ ⲠⲈ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ⲈⲦⲀⲨⲤⲒⲚⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚϮⲘⲨⲤⲒⲀ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈⲦⲢⲰⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲚϨ ⲈⲠⲀⲨⲖⲞⲤ ⲚϪⲈⲞⲨϨⲞⲢⲀⲘⲀ ⲘⲠⲒⲈϪⲰⲢϨ ⲞⲨⲢⲰⲘⲒ ⲘⲘⲀⲔⲈⲆⲰⲚ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲈϤⲦⲰⲂϨ ⲘⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲘⲞⲨ ⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲀⲢⲒⲂⲞⲎⲐⲒⲚ ⲈⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ϨⲰⲤ ⲆⲈ ⲈⲦⲀⲚⲚⲀⲨ ⲈⲠⲒϨⲞⲢⲀⲘⲀ ⲤⲀⲦⲞⲦⲈⲚ ⲀⲚⲔⲰϮ ⲚⲤⲀⲒⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲈⲚⲤⲞϬⲚⲒ ϪⲈ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲐⲀϨⲘⲈⲚ ⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ⲈⲦⲀⲚⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲦⲢⲰⲀⲤ ⲀⲚϢⲈ ⲚⲬⲰⲖⲈⲘ ⲈⲤⲀⲘⲞⲐⲢⲀⲔⲎ ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲚⲒ ⲈϨⲢⲎⲒ ⲈⲚⲈⲀⲠⲞⲖⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ⲞⲨⲞϨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲚⲒ ⲈⲪⲒⲖⲒⲠⲠⲞⲒⲤ ⲈⲦⲈ ⲚⲐⲞⲤ ⲦⲈ ϮϨⲞⲨⲒϮ ⲚⲦⲈϮⲦⲞⲒ ⲚⲦⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲞⲨⲠⲞⲖⲒⲤ ⲚⲔⲞⲖⲰⲚⲒⲀ ⲚⲀⲚϢⲞⲠ ⲆⲈ ⲠⲈ ϦⲈⲚϮⲠⲞⲖⲒⲤ ⲈⲦⲈⲘⲘⲀⲨ ⲚϨⲀⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲀⲚⲒ ⲤⲀⲂⲞⲖ ⲚϮⲠⲞⲖⲒⲤ ϦⲀⲦⲈⲚ ⲪⲒⲀⲢⲞ ⲠⲒⲘⲀ ⲈⲚⲀⲚⲘⲈⲨⲒ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲢⲞⲤⲈⲨⲬⲎ ⲚⲀϢⲰⲠⲒ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀⲚϨⲈⲘⲤⲒ ⲚⲀⲚⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒϨⲒⲞⲘⲒ ⲈⲦⲀⲨⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ⲞⲨⲞϨ ⲞⲨⲤϨⲒⲘⲒ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲖⲨⲆⲒⲀ ⲈⲞⲨⲤⲀⲚϬⲎϪⲒ ⲦⲈ ⲚⲦⲈⲞⲨⲠⲞⲖⲒⲤ ϪⲈ ⲐⲨⲀⲦⲎⲢⲰⲚ ⲈⲤⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲪⲚⲞⲨϮ ⲚⲀⲤⲤⲰⲦⲈⲘ ⲐⲀⲒ Ⲁ- ⲪⲚⲞⲨϮ ⲞⲨⲰⲚ ⲘⲠⲈⲤϨⲎⲦ ⲈϮϨⲐⲎⲤ ⲈⲚⲎ ⲈⲚⲀⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ⲈⲦⲀⲤϬⲒⲰⲘⲤ ⲆⲈ ⲚⲈⲘ ⲠⲈⲤⲎⲒ ⲀⲤϮϨⲞ ⲈⲢⲞⲚ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲀⲦⲈⲦⲈⲚⲞⲠⲦ ⲈⲞⲨⲠⲒⲤⲦⲎ ⲘⲠϬⲞⲒⲤ ⲀⲘⲰⲒⲚⲒ ⲈϦⲞⲨⲚ ⲈⲠⲀⲎⲒ ϢⲰⲠⲒ ⲞⲨⲞϨ ⲀⲤϬⲒⲦⲦⲈⲚ ⲚϪⲞⲚⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲚⲚⲀ ⲈϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲀⲤⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀⲚ ⲚϪⲈⲞⲨⲀⲖⲞⲨ ⲘⲂⲰⲔⲒ ⲈⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲢⲈϤϢⲒⲚⲒ ⲚⲈⲘⲀⲤ ⲐⲀⲒ ⲈⲚⲀⲤϮ ⲚⲞⲨⲘⲎϢ ⲚⲈⲢⲄⲀⲤⲒⲀ ⲚⲚⲈⲤϬⲒⲤⲈⲨ ⲈⲤⲞⲒ ⲚⲢⲈϤϢⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ⲐⲀⲒ ⲈⲦⲀⲤⲘⲞϢⲒ ⲚⲤⲀⲠⲀⲨⲖⲞⲤ ⲚⲈⲘⲀⲚ ⲚⲀⲤⲰϢ ⲈⲂⲞⲖ ⲈⲤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲀⲒⲢⲰⲘⲒ ϨⲀⲚⲈⲂⲒⲀⲒⲔ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦϬⲞⲤⲒ ⲚⲈⲚⲀⲒ ⲈⲦϨⲒⲰⲒϢ ⲚⲰⲦⲈⲚ ⲚⲞⲨⲘⲰⲒⲦ ⲚⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ⲪⲀⲒ ⲆⲈ ⲚⲀⲤⲢⲀ ⲘⲘⲞϤ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲈⲦⲀϤⲈⲢⲘⲔⲀϨ ⲚϨⲎⲦ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲔⲞⲦϤ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲠⲈϪⲀϤ ϪⲈ ϮϨⲞⲚϨⲈⲚ ⲚⲀⲔ ϦⲈⲚⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲤ ⲞⲨⲞϨ ⲀϤⲒ ⲈⲂⲞⲖ ⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲈⲤϬⲒⲤⲈⲨ ϪⲈ ⲀⲤⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲤ ⲚϪⲈⲦϨⲈⲖⲠⲒⲤ ⲚⲦⲈⲠⲞⲨϨⲰⲂ ⲀⲨⲀⲘⲞⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ⲀⲨⲰϢϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ⲈϮⲀⲄⲞⲢⲀ ϢⲀ ⲚⲒⲀⲢⲬⲰⲚ ");
INSERT INTO copbhc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲚⲞⲨ ϨⲀ ⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲀⲒⲢⲰⲘⲒ ⲤⲈϢⲐⲞⲢⲦⲈⲢ ⲚⲦⲈⲚⲠⲞⲖⲒⲤ ⲈϨⲀⲚⲒⲞⲨⲆⲀⲒ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ⲞⲨⲞϨ ⲤⲈϨⲒⲰⲒϢ ⲚⲀⲚ ⲚϨⲀⲚⲔⲈⲔⲀϨⲤ ⲚⲀⲒ ⲈⲦⲈⲤϢⲈ ⲚⲀⲚ ⲀⲚ ⲈϢⲞⲠⲞⲨ ⲞⲨⲆⲈ ⲈⲀⲒⲦⲞⲨ ⲈⲀⲚⲞⲚ ϨⲀⲚⲢⲰⲘⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚϪⲈⲠⲒⲘⲎϢ ⲞⲨⲞϨ ⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲀⲨⲪⲰϦ ⲚⲚⲞⲨϨⲂⲰⲤ ⲀⲨⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲚⲤⲈϨⲒⲞⲨⲒ ⲈⲢⲰⲞⲨ ⲘⲠϢⲂⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ⲈⲦⲀⲨϮ ⲚⲞⲨⲘⲎϢ ⲚϢⲀϢ ⲚⲰⲞⲨ ⲀⲨϨⲒⲦⲞⲨ ⲈⲠⲒϢⲦⲈⲔⲞ ⲈⲀⲨϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦϤ ⲘⲠⲒⲢⲈϤⲀⲢⲈϨ ⲚⲦⲈⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ⲈⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ⲪⲀⲒ ⲈⲦⲀϤϬⲒ ⲚⲞⲨϨⲞⲚϨⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ⲀϤϨⲒⲦⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲒϢⲦⲈⲔⲞ ⲈⲦⲤⲀϦⲞⲨⲚ ⲞⲨⲞϨ ⲀϤⲦⲀϪⲢⲞ ⲚⲚⲞⲨϬⲀⲖⲀⲨϪ ⲈⲠⲒϢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲦⲪⲀϢⲒ ⲘⲠⲒⲈϪⲰⲢϨ ⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ⲈⲨⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲚⲀⲨⲤⲘⲞⲨ ⲈⲪⲚⲞⲨϮ ⲚⲀⲨⲤⲰⲦⲈⲘ ⲈⲢⲰⲞⲨ ⲚϪⲈⲚⲎ ⲈⲦⲤⲞⲚϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲞⲚⲘⲈⲚ ϨⲰⲤⲆⲈ ⲚⲤⲈⲔⲒⲘ ⲚϪⲈⲚⲒⲤⲈⲚϮ ⲚⲦⲈⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ⲚϮⲞⲨⲚⲞⲨ ⲆⲈ ⲀⲨⲞⲨⲰⲚ ⲚϪⲈⲚⲒⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲒⲤⲚⲀⲨϨ ⲚⲦⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲂⲰⲖ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ⲈⲦⲀϤⲚⲈϨⲤⲒ ⲆⲈ ⲚϪⲈⲠⲒⲢⲈϤⲀⲢⲈϨ ⲚⲦⲈⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ⲞⲨⲞϨ ⲈⲦⲀϤⲚⲀⲨ ⲈⲚⲒⲢⲰⲞⲨ ⲚⲦⲈⲠⲒϢⲦⲈⲔⲞ ⲈⲨⲞⲨⲎⲚ ⲀϤⲐⲰⲔⲈⲘ ⲚⲦⲈϤⲤⲎϤⲒ ⲈϤⲚⲀϦⲞⲐⲂⲈϤ ⲈϤⲘⲈⲨⲒ ϪⲈ ⲀⲨⲪⲰⲦ ⲚϪⲈⲚⲎ ⲈⲦⲤⲰⲚϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ⲀϤⲰϢ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢ ϨⲖⲒ ⲘⲠⲈⲦϨⲰⲞⲨ ⲚⲀⲔ ⲦⲈⲚⲘⲠⲀⲒⲘⲀ ⲄⲀⲢ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ⲀϤϬⲒ ⲆⲈ ⲚⲞⲨⲰⲒⲚⲒ ⲀϤϬⲞϪⲒ ⲈϦⲞⲨⲚ ⲞⲨⲞϨ ⲈⲦⲀϤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲤⲐⲈⲢⲦⲈⲢ ⲀϤϨⲒⲦϤ ⲈϦⲢⲎⲒ ϦⲀⲢⲀⲦϤ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲚⲞⲨ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲀϬⲒⲤⲈⲨ ⲞⲨ ⲠⲈⲦⲤⲈⲘⲠϢⲀ ⲚⲦⲀⲀⲒϤ ϨⲒⲚⲀ ⲚⲦⲀⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲚⲀϨϮ ⲈⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲈⲔⲈⲚⲞϨⲈⲘ ⲚⲐⲞⲔ ⲚⲈⲘ ⲠⲈⲔⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ⲞⲨⲞϨ ⲀⲨⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲐⲞϤ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ⲞⲨⲞϨ ⲀϤⲞⲖⲞⲨ ⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲦⲈⲠⲒⲈϪⲰⲢϨ ⲀϤϪⲞⲔⲘⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲞⲨⲈⲢϦⲰⲦ ⲞⲨⲞϨ ⲀϤϬⲒⲰⲘⲤ ⲚⲐⲞϤ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ⲈⲦⲀϤⲈⲚⲞⲨ ⲆⲈ ⲈϦⲞⲨⲚ ⲈⲠⲈϤⲎⲒ ⲀϤⲬⲀ ⲞⲨⲦⲢⲀⲠⲈⲌⲀ ϦⲀⲦⲞⲦⲞⲨ ⲞⲨⲞϨ ⲚⲀϤⲐⲈⲖⲎ ⲖⲘⲘⲞϤ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ ⲈⲦⲀϤⲚⲀϨϮ ⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲞⲨⲰⲢⲠ ⲚϪⲈⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲚϨⲀⲚⲢⲀⲂⲆⲞⲨⲬⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲬⲀ ⲚⲒⲢⲰⲘⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ⲀϤⲦⲀⲘⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲚⲀⲒⲤⲀϪⲒ ⲚϪⲈⲠⲒⲢⲈϤⲀⲢⲈϨ ⲚⲦⲈⲠⲒⲘⲀ ⲚⲤⲰⲚϨ ϪⲈ Ⲁ- ⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲞⲨⲰⲢⲠ ϨⲒⲚⲀ ⲚⲤⲈⲬⲀ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϮⲚⲞⲨ ⲞⲨⲚ ⲀⲘⲰⲒⲚⲒ ⲈⲂⲞⲖ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲈⲦⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞⲚ ⲚⲆⲎⲘⲞⲤⲒⲀ ⲈⲀⲚⲞⲚ ϨⲀⲚⲢⲰⲘⲒ ⲚⲢⲰⲘⲈⲞⲤ ⲚⲦⲈⲚⲈⲢⲠⲔⲈϨⲰⲞⲨⲒ ⲘⲠϨⲀⲠ ⲀⲚ ⲀⲨϨⲒⲦⲦⲈⲚ ⲈⲠϢⲦⲈⲔⲞ ⲞⲨⲞϨ ⲤⲈϨⲒⲞⲨⲒ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲚⲬⲰⲠ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲘⲀⲢⲞⲨⲒ ⲚⲐⲰⲞⲨⲒ ⲚⲤⲈⲈⲚⲦⲈⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ⲀⲨⲦⲀⲘⲈ ⲚⲒⲤⲀⲦⲎⲄⲞⲨⲤ ⲆⲈ ⲈⲚⲀⲒⲤⲀϪⲒ ⲚϪⲈⲚⲒⲢⲀⲂⲆⲞⲨⲬⲞⲤ ⲀⲨⲈⲢϨⲞϮ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ϪⲈ ϨⲀⲚⲢⲰⲘⲈⲞⲤ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ⲞⲨⲞϨ ⲈⲦⲀⲨⲒ ⲀⲨϦⲰⲚϪ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲚⲞⲨ ⲈⲂⲞⲖ ⲀⲨϮϨⲞ ⲈⲢⲰⲞⲨ ⲈⲐⲢⲞⲨϢⲈ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲦⲞⲨⲠⲞⲖⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒϢⲦⲈⲔⲞ ⲀⲨϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲚⲖⲨⲆⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ⲀⲨϮⲚⲞⲘϮ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲀⲨⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ⲈⲦⲀⲨⲤⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲀⲘⲪⲒⲠⲞⲖⲒⲤ ⲚⲈⲘ ϮⲀⲠⲞⲖⲖⲰⲚⲒⲀ ⲀⲨⲒ ⲈⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ⲠⲒⲘⲀ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲨⲚⲀⲄⲰⲄⲎ ⲚϦⲎⲦϤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ⲔⲀⲦⲀ ϮⲤⲨⲚⲎⲐⲒⲀ ⲆⲈ ⲚⲦⲈⲠⲀⲨⲖⲞⲤ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ϢⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ϢⲀ Ⲅ- ⲚⲤⲀⲂⲂⲀⲦⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤⲬⲰ ϦⲀⲦⲞⲦⲞⲨ ϪⲈ ϨⲰϮ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ϬⲒⲘⲔⲀϨ ⲞⲨⲞϨ ⲚⲦⲈϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲀⲒ ⲀⲚⲞⲔ ⲈϮϨⲒⲰⲒϢ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ⲞⲨⲞϨ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀⲨⲚⲀϨϮ ⲞⲨⲞϨ ⲀⲨⲰⲠ ⲈⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ⲚϪⲈⲞⲨⲘⲎϢ ⲈϤⲞϢ ⲚⲦⲈⲚⲎ ⲈⲦⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲚⲦⲈⲚⲒⲞⲨⲈⲒⲚⲒⲚ ϨⲀⲚϨⲒⲞⲘⲒ ⲆⲈ ⲚⲦⲈⲚⲒϨⲞⲨⲀϮ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ⲀⲨⲬⲞϨ ⲆⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲀⲨϬⲒ ⲚϨⲀⲚⲢⲰⲘⲒ ⲈⲨϨⲰⲞⲨ ⲚⲦⲈⲚⲒⲀⲄⲞⲢⲢⲈⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲐⲞⲨⲈⲦ ⲞⲨⲘⲎϢ ⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲚϮⲠⲞⲖⲒⲤ ⲞⲨⲞϨ ⲀⲨⲒ ⲈϨⲢⲈⲚ ⲠⲎⲒ ⲚⲒⲀⲤⲤⲰⲚ ⲈⲨⲔⲰϮ ⲚⲤⲰⲞⲨ ⲚⲤⲈⲈⲚⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ⲈⲦⲈⲘⲠⲞⲨϪⲈⲘⲞⲨ ⲆⲈ ⲀⲨⲰϢϮ ⲚⲒⲀⲤⲤⲰⲚ ⲈⲂⲞⲖ ⲚⲈⲘ ϨⲀⲚⲔⲈⲤⲚⲎⲞⲨ ϢⲀ ⲚⲒⲀⲢⲬⲰⲚ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ⲈⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲚϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲞⲨⲞϨ ⲤⲈϢⲞⲠ ⲦⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ⲈⲀ ⲒⲀⲤⲤⲰⲚ ϢⲞⲠⲞⲨ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲤⲈϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲚⲒϨⲰⲚ ⲚⲦⲈⲠⲞⲨⲢⲞ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤϢⲞⲠ ⲚϪⲈⲔⲈⲞⲨⲢⲞ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲆⲈ ⲘⲠⲒⲘⲎϢ ⲚⲈⲘ ⲚⲒⲀⲢⲬ ⲰⲚ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ⲈⲨⲤⲰⲦⲈⲘ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ⲞⲨⲞϨ ⲈⲦⲀⲨϬⲒ ⲘⲠⲈⲦⲤⲈⲘⲠϢⲀ ⲚⲦⲈⲚ ⲒⲀⲤⲤⲰⲚ ⲚⲈⲘ ⲚⲒⲔⲈⲤⲰϪⲠ ⲀⲨⲬⲀⲨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ⲚⲒⲤⲚⲎⲞⲨ ⲆⲈ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲦⲪⲈ ⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ⲚⲈⲘ ⲤⲒⲖⲀⲤ ⲚϪⲰⲢϨ ⲈϨⲢⲎⲒ ⲈⲂⲈⲢⲞⲒⲀ ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲘⲀⲨ ⲀⲨϢⲈ ⲈϦⲞⲨⲚ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ⲚⲀⲒ ⲆⲈ ⲚⲈϨⲀⲚⲈⲨⲄⲈⲚⲎⲤ ⲚⲈⲈϨⲞⲦⲈ ⲚⲎ ⲈⲦϦⲈⲚ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ⲚⲀⲒ ⲈⲦⲀⲨϢⲈⲠ ⲠⲒⲤⲀϪⲒ ⲈⲢⲰⲞⲨ ϦⲈⲚⲢⲰⲞⲨⲦϤ ⲚϨⲎⲦ ⲚⲒⲂⲈⲚ ⲈⲨϦⲞⲦϦⲈⲦ ⲘⲘⲎⲚⲒ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ϪⲈ ⲀⲚ ⲚⲀⲒ ϢⲞⲠ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ⲞⲨⲘⲎϢ ⲘⲈⲚ ⲞⲨⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲀⲨⲚⲀϨϮ ⲚⲈⲘ ϨⲀⲚⲔⲈⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲚϨⲒⲞⲘⲒ ⲚⲈⲨⲤⲬⲎⲘⲰⲚ ⲚⲈⲘ ϨⲀⲚⲔⲈⲢⲰⲘⲒ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ⲈⲦⲀⲨⲈⲘⲒ ⲆⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲦⲈⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ϪⲈ ⲀⲠⲀⲨⲖⲞⲤ ϨⲒⲰⲒϢ ϦⲈⲚⲦⲔⲈⲂⲈⲢⲞⲒⲀ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲨⲒ ⲈⲠⲒⲔⲈⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲔⲒⲘ ⲚⲚⲒⲘⲎϢ ⲈⲨϢⲐⲞⲢⲦⲈⲢ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ⲦⲞⲦⲈ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲦⲪⲈ ⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲈⲐⲢⲈϤϢⲈ ⲈϪⲈⲚ ⲪⲒⲞⲘ ⲀⲨⲤⲰϪⲠ ⲆⲈ ⲘⲘⲀⲨ ⲚϪⲈⲤⲒⲖⲀⲤ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ⲚⲎ ⲆⲈ ⲈⲚⲀⲨⲦⲪⲞ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ⲀⲨⲈⲚϤ ⲈϨⲢⲎⲒ ⲈⲀⲐⲎⲚⲚⲀⲤ ⲞⲨⲞϨ ⲈⲦⲀⲨϬⲒ ⲈⲚⲦⲞⲖⲎ ⲈϬⲒⲠϢⲒⲚⲒ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲤⲒⲖⲀⲤ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ ϨⲒⲚⲀ ⲚⲤⲈⲒ ϨⲀⲢⲞϤ ⲚⲬⲰⲖⲈⲘ ⲀⲨⲒ ⲈⲂⲞⲖ ⲀⲨϢⲈ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲚⲀϤϦⲈⲚ ⲀⲐⲎⲚⲚⲀⲤ ⲈϤⲤⲞⲘⲤ ⲈⲂⲞⲖ ϦⲀϪⲰⲞⲨ ⲀϤϪⲰⲚⲦ ⲆⲈ ⲚϪⲈⲠⲈϤⲠⲚⲈⲨⲘⲀⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ⲈϤⲚⲀⲨ ⲈϮⲠⲞⲖⲒⲤ ⲈⲤⲞϢ ⲘⲘⲈⲦϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ⲚⲀϤⲤⲀϪⲒ ⲘⲈⲚ ⲞⲨⲚ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈϢⲀⲨⲐⲰⲞⲨϮ ⲘⲘⲎⲚⲒ ϨⲒ ϮⲀⲄⲞⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲠⲒⲔⲞⲨⲢⲒⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲦⲞⲒⲬⲞⲤ ⲘⲪⲒⲖⲞⲤⲞⲪⲞⲤ ⲚⲀⲨϮ ⲞⲨⲂⲎϤ ⲞⲨⲞϨ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈϤⲞⲨⲰϢ ⲈϪⲞϤ ⲚϪⲈⲠⲀⲒⲤⲠⲈⲢⲘⲞⲖⲞⲄⲞⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲢⲈϤϨⲒⲰⲒϢ ⲠⲈ ⲚⲦⲈϨⲀⲚⲆⲈⲘⲰⲚ ⲚϢⲈⲘⲘⲞ ϪⲈ ⲚⲀϤϨⲒⲰⲒϢ ⲚⲰⲞⲨ ⲠⲈ ⲚⲒⲎⲤⲞⲨⲤ ⲚⲈⲘ ⲦⲈϤⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ⲀⲨⲀⲘⲞⲚⲒ ⲆⲈ ⲘⲘⲞϤ ⲀⲨⲈⲚϤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲀⲢⲒⲞⲠⲀⲄⲞⲤ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ ⲈⲈⲘⲒ ϪⲈ ⲦⲀⲒⲤⲂⲰ ⲘⲂⲈⲢⲒ ⲞⲨ ⲦⲈ ⲈⲦⲈⲔⲤⲀϪⲒ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ⲔⲒⲚⲒ ⲚϨⲀⲚⲤⲀϪⲒ ⲚϢⲈⲘⲘⲞ ⲈϦⲞⲨⲚ ⲈⲚⲈⲚⲘⲀϢϪ ⲦⲈⲚⲞⲨⲰϢ ⲈⲈⲘⲒ ϪⲈ ⲞⲨ ⲚⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ⲚⲒⲀⲐⲎⲚⲚⲈⲞⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒϢⲈⲘⲘⲰⲞⲨ ⲈⲐⲚⲎⲞⲨ ⲈⲘⲀⲨ ⲚⲀⲨⲤⲢⲰϤⲦ ⲈϨⲖⲒ ⲀⲚ ⲠⲈ ⲈⲂⲎⲖ ⲈⲤⲀϪⲒ ⲚⲈⲘ ⲈⲤⲰⲦⲈⲘ ⲈϨⲰⲂ ⲘⲂⲈⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ⲀϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϦⲈⲚⲐⲘⲎϮ ⲘⲠⲒⲀⲢⲒⲞⲠⲀⲄⲞⲤ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲀⲐⲎⲚⲚⲈⲞⲤ ⲔⲀⲦⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ϮⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲞⲒ ⲚⲢⲈϤϢⲀⲘϢⲈ ⲒϦ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ⲈⲒⲤⲒⲚⲒ ⲄⲀⲢ ⲞⲨⲞϨ ⲈⲦⲀⲒⲚⲀⲨ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲘⲰⲞⲨ ⲀⲒϪⲒⲘⲒ ⲚⲞⲨϢⲎ ⲞⲨⲒ ⲈⲤⲤϦⲎⲞⲨⲦ ⲈϨⲢⲎⲒ ϨⲒⲰⲦⲤ ϪⲈ ⲪⲚⲞⲨϮ ⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲪⲎ ⲞⲨⲚ ⲈⲦⲈⲦⲈⲚⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲘⲞϤ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲪⲀⲒ ⲀⲚⲞⲔ ⲈϮϨⲒⲰⲒϢ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ⲪⲚⲞⲨϮ ⲈⲦⲀϤⲐⲀⲘⲒⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲈⲘ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ⲚϦⲎⲦϤ ⲪⲀⲒ ⲠⲈ ⲠϬⲞⲒⲤ ⲚⲦⲪⲈ ⲚⲈⲘ ⲠⲔⲀϨⲒ ⲚⲀϤϢⲞⲠ ⲀⲚ ϦⲈⲚϨⲀⲚⲈⲢⲪⲎⲞⲨⲒ ⲘⲘⲞⲨⲚⲔ ⲚϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ⲞⲨⲆⲈ ⲚⲈϢⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞϤ ⲀⲚ ⲚϪⲈϨⲀⲚϪⲒϪ ⲚⲢⲰⲘⲒ ⲚϤⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲚϨⲖⲒ ⲚⲐⲞϤ ⲠⲈⲦϮ ⲘⲠⲰⲚϦ ⲚⲈⲘ ⲪⲚⲒϤⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ⲈⲀϤⲐⲀⲘⲒⲈ ϢⲖⲞⲖ ⲚⲒⲂⲈⲚ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲀⲒ ⲈⲐⲢⲞⲨϢⲰⲠⲒ ϨⲒϪⲈⲚ ⲠϨⲞ ⲘⲠⲔⲀϨⲒ ⲦⲎⲢϤ ⲈⲀϤⲐⲰϢ ⲚϨⲀⲚⲤⲎ ⲞⲨ ⲈⲨⲐⲎϢ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ⲚⲈⲘ ⲠⲒⲐⲰϢ ⲚⲦⲈⲠⲞⲨϪⲒⲚϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ⲈⲐⲢⲞⲨⲔⲰϮ ⲚⲤⲀⲪⲚⲞⲨϮ ϪⲈ ϨⲀⲢⲀ ⲄⲈ ⲤⲈⲚⲀϪⲞⲘϪⲈⲘ ⲚⲤⲰϤ ⲚⲤⲈϪⲈⲘϤ ⲔⲈⲦⲞⲒ ϤⲞⲨⲎⲞⲨ ⲀⲚ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ⲀⲚⲰⲚϦ ⲄⲀⲢ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲀⲚⲔⲒⲘ ⲞⲨⲞϨ ⲀⲚϢⲞⲠ ⲘⲪⲢⲎϮ ⲈⲦⲀⲨϪⲞⲤ ⲚϪⲈϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲠⲞⲒⲦⲎⲤ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲀⲚⲞⲚ ⲠⲈϤⲄⲈⲚⲞⲤ ⲄⲀⲢ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ⲈⲀⲚⲞⲚ ⲞⲨⲄⲈⲚⲞⲤ ⲞⲨⲚ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤϢⲈ ⲚⲀⲚ ⲀⲚ ⲈⲐⲢⲈⲚⲘⲈⲨⲒ ⲈⲚⲞⲨⲂ ⲒⲈ ϨⲀⲦ ⲒⲈ ⲰⲚⲒ ⲘⲪⲰⲦϨ ⲚⲦⲈⲬⲚⲎ ⲒⲈ ⲘⲞⲔⲘⲈⲔ ⲚⲢⲰⲘⲒ ϪⲈ ⲀϤⲞⲚⲒ ⲘⲘⲰⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ⲚⲒⲤⲎⲞⲨ ⲘⲈⲚ ⲚⲦⲈϮⲘⲈⲦⲀⲦⲈⲘⲒ ⲀϤⲬⲀⲨ ⲈⲂⲞⲖ ⲚϪⲈⲪⲚⲞⲨϮ ϮⲚⲞⲨ ⲆⲈ ϤϨⲒⲰⲒϢ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲐⲢⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ⲔⲀⲦⲀ ⲪⲢⲎϮ ϪⲈ ⲀϤⲤⲈⲘⲚⲈ ⲞⲨⲈϨⲞⲞⲨ ⲈϤⲚⲀϮϨⲀⲠ ⲈϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲚϦⲎⲦϤ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲀϤⲐⲀϢϤ ⲈⲀϤϮ ⲘⲪⲚⲀϨϮ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲀϤⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ϪⲈ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲀⲨⲤⲰⲂⲒ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨϪⲞⲤ ϪⲈ ⲈⲚⲈⲤⲰⲦⲈⲘ ⲈⲢⲞⲔ ⲈⲐⲂⲈⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲀⲠⲀⲨⲖⲞⲤ Ⲓ- ⲈⲂⲞⲖ ϦⲈⲚⲦⲞⲨⲘⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ⲀⲨⲦⲞⲘⲞⲨ ⲆⲈ ⲈⲢⲞϤ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲈⲀⲨⲚⲀϨϮ ⲚⲀⲒ ⲈⲦⲈⲚⲀⲢⲈ ⲆⲒⲞⲚⲎⲤⲒⲞⲤ ⲚϦⲎⲦⲞⲨ ⲠⲒⲀⲢⲒⲞⲠⲀⲄⲒⲦⲎⲤ ⲚⲈⲘ ⲞⲨⲤϨⲒⲘⲒ ⲈⲠⲈⲤⲢⲀⲚ ⲠⲈ ⲆⲀⲘⲀⲢⲒⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ⲈⲦⲀϤⲒ ⲈⲂⲞⲖ ϦⲈⲚⲀⲐⲎⲚⲚⲎⲤ ⲀϤⲒ ⲈⲔⲞⲢⲒⲚⲐⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ⲀϤϪⲒⲘⲒ ⲚⲞⲨⲒⲞⲨⲆⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲔⲨⲖⲖⲀⲤ ⲈⲞⲨⲠⲞⲚⲦⲒⲞⲤ ⲠⲈ ϦⲈⲚⲠⲈϤⲄⲈⲚⲞⲤ ⲈⲀϤⲒ ⲤⲀⲦⲞⲦϤ ⲈⲂⲞⲖ ϦⲈⲚϮϨⲨⲦⲀⲖⲒⲀ ⲚⲈⲘ ⲠⲢⲒⲤⲔⲨⲖⲖⲀ ⲦⲈϤⲤϨⲒⲘⲒ ϪⲈ ⲚⲈⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲠⲈ ⲚϪⲈⲔⲖⲀⲨⲆⲒⲞⲤ ⲈⲐⲢⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲪⲰⲢϪ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲘⲎ ⲀϤⲒ ϢⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ⲞⲨⲞϨ ⲀϤϢⲰⲠⲒ ϦⲀⲦⲞⲦⲞⲨ ⲈⲐⲂⲈ ϪⲈ ⲞⲨϢⲪⲎⲢ ⲚⲦⲈⲬⲚⲎ ⲚⲦⲀϤ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢϨⲰⲂ ⲠⲈ ⲚⲈϨⲀⲚⲢⲈϤⲐⲀⲘⲒⲈ ⲤⲔⲨⲚⲎ ⲄⲀⲢ ⲚⲈϦⲈⲚⲦⲞⲨⲦⲈⲬⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ⲚⲀⲨⲤⲀϪⲒ ⲆⲈ ⲠⲈ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲔⲀⲦⲀ ⲤⲀⲂⲂⲀⲦⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲚⲀⲨⲐⲰⲦ ⲘⲠϨⲎⲦ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚϪⲈⲤⲒⲖⲀⲤ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲚⲀϤⲘⲎⲚ ⲆⲈ ⲠⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϦⲈⲚⲠⲒⲤⲀϪⲒ ⲈϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ⲈⲨϮ ⲆⲈ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲞⲨⲞϨ ⲈⲨϪⲈⲞⲨⲀ ⲀϤⲚⲈϨ ⲚⲈϤϨⲂⲰⲤ ⲈⲂⲞⲖ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲤⲚⲞϤ ⲈϪⲈⲚ ⲦⲈⲦⲈⲚⲀⲪⲈ ϮⲞⲨⲀⲂ ⲀⲚⲞⲔ ⲒⲤϪⲈⲚ ϮⲚⲞⲨ ⲈⲒⲈϢⲈ ⲚⲎⲒ ⲈⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ⲞⲨⲞϨ ⲈⲦⲀϤⲞⲨⲰⲦⲈⲂ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀϤⲒ ⲈⲠⲎⲒ ⲚⲞⲨⲀⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲦⲒⲦⲞⲤ ⲪⲀⲒ ⲞⲨⲠⲒⲤⲦⲞⲤ ⲈϤⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲪⲚⲞⲨϮ ⲪⲀⲒ ⲈⲚⲀⲢⲈ ⲠⲈϤⲎⲒ ⲦⲞⲘⲒ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ⲔⲢⲒⲤⲠⲞⲤ ⲆⲈ ⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀϤⲚⲀϨϮ ⲈⲠϬⲞⲒⲤ ⲚⲈⲘ ⲠⲈϤⲎⲒ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲞⲨⲘⲎ ϢⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲞⲢⲒⲚⲐⲞⲤ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲀⲨⲚⲀϨϮ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲨϬⲒⲰⲘⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ⲆⲈ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨϨⲞⲢⲀⲘⲀ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲀⲖⲖⲀ ⲤⲀϪⲒ ⲞⲨⲞϨ ⲘⲠⲈⲢⲬⲀⲢⲰⲔ ");
INSERT INTO copbhc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ϪⲈ ⲀⲚⲞⲔ ϮⲬⲎ ⲚⲈⲘⲀⲔ ⲞⲨⲞϨ ⲚⲚⲈ ϨⲖⲒ ⲦⲰⲚϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲔ ⲈϮⲘⲔⲀϨ ⲚⲀⲔ ϪⲈ ⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲖⲀⲞⲤ ϦⲈⲚⲦⲀⲒⲠⲞⲖⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ⲀϤϨⲈⲘⲤⲒ ⲆⲈ ⲚⲞⲨⲢⲞⲘⲠⲒ ⲚⲈⲘ ⲚⲀⲂⲞⲦ ⲈϤϮⲤⲂⲰ ⲚϦⲎⲦⲞⲨ ⲘⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ⲄⲀⲖⲒⲰⲚ ⲆⲈ ⲈϤⲞⲒ ⲚⲀⲚⲐⲨⲠⲀⲦⲞⲤ ⲈϮⲀⲬⲀⲒⲀ ⲀⲨⲒ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨⲤⲞⲠ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲀⲨⲈⲚϤ ⲈⲠⲒⲘⲀ ⲚϮϨⲀⲠ ");
INSERT INTO copbhc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲪⲀⲒ ⲐⲰⲦ ⲘⲠϨⲎⲦ ⲚⲚⲒⲢⲰⲘⲒ ⲈⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲪⲚⲞⲨϮ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ⲈϤⲚⲀⲞⲨⲰⲚ ⲆⲈ ⲚⲢⲰϤ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲠⲈϪⲈ ⲄⲀⲖⲒⲰⲚ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲈⲚⲈ ⲞⲨⲞⲚ ϬⲒ ⲚϪⲞⲚⲤ ⲒⲈ ⲞⲨϨⲰⲂ ⲈϤϨⲰⲞⲨ ⲘⲠⲞⲚⲎⲢⲞⲚ Ⲱ- ⲚⲒⲒⲞⲨⲆⲀⲒ ⲔⲀⲖⲰⲤ ⲚⲀⲒⲚⲀⲈⲢⲀⲚⲈⲬⲈⲤⲐⲈ ⲘⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ⲒⲤϪⲈ ⲆⲈ ϨⲀⲚⲌⲎⲦⲎⲘⲀ ⲚⲈⲈⲐⲂⲈ ⲞⲨⲤⲀϪⲒ ⲚⲈⲘ ϨⲀⲚⲢⲀⲚ ⲚⲈⲘ ⲠⲈⲦⲈⲚⲚⲞⲘⲞⲤ ⲈⲢⲈⲦⲈⲚⲈⲢⲰϢⲒ ⲚⲐⲰⲦⲈⲚ ϮⲞⲨⲰϢ ⲀⲚⲞⲔ ⲀⲚ ⲈⲈⲢⲢⲈϤϮϨⲀⲠ ⲚⲦⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ⲞⲨⲞϨ ⲀⲨϨⲒⲦⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲂⲎⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ⲀⲨⲀⲘⲞⲚⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲤⲰⲤⲐⲈⲚⲎⲤ ⲠⲒⲀⲢⲬⲎⲤⲨⲚⲀⲄⲰⲄⲞⲤ ⲀⲨϨⲒⲞⲨⲒ ⲈⲢⲞϤ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲂⲎⲘⲀ ⲞⲨⲞϨ ⲚⲀⲤⲈⲢⲘⲈⲖⲈⲤⲐⲈ ⲀⲚ ⲚⲄⲀⲖⲒⲰⲚ ⲈⲐⲂⲈ ϨⲖⲒ ⲚⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲀϤϢⲰⲠⲒ ⲚⲔⲈⲘⲎϢ ⲚⲈϨⲞⲞⲨ ϦⲀⲦⲈⲚ ⲚⲒⲤⲚⲎⲞⲨ ⲀϤⲈⲢⲀⲠⲞⲆⲀⲌⲈⲤⲐⲈ ⲚⲰⲞⲨ ⲀϤⲈⲢϨⲰⲦ ⲈⲦⲤⲨⲢⲒⲀ ⲈⲤⲚⲈⲘⲀϤ ⲚϪⲈⲠⲢⲒⲤⲔⲨⲖⲖⲀ ⲚⲈⲘ ⲀⲔⲨⲖⲖⲀⲤ ⲈⲀϤϢⲈⲠ ϪⲰϤ ϦⲈⲚⲔⲈⲚⲬⲢⲈⲈⲤ ⲚⲀϤϦⲈⲚ ⲞⲨⲈⲨⲬⲎ ⲄⲀⲢ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ⲀϤⲒ ⲆⲈ ⲈⲈⲪⲈⲤⲞⲤ ⲞⲨⲞϨ ⲀϤⲤⲈϪⲠ ⲚⲎ ⲘⲘⲀⲨ ⲚⲐⲞϤ ⲆⲈ ⲈⲦⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ⲈⲨⲦⲰⲂϨ ⲆⲈ ⲘⲘⲞϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢ ⲞⲨⲚⲒϢϮ ⲚⲤⲎⲞⲨ ϦⲀⲦⲞⲦⲞⲨ ⲘⲠⲈϤⲞⲨⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ⲀⲖⲖⲀ ⲀϤⲈⲢⲀⲠⲞⲆⲀⲌⲈⲤⲐⲈ ⲚⲰⲞⲨ ⲈⲀϤϪⲞⲤ ϪⲈ ϮⲚⲀⲔⲞⲦⲦ ϨⲀⲢⲰⲦⲈⲚ ϦⲈⲚⲠⲈⲦⲈϨⲚⲈ ⲪⲚⲞⲨϮ ⲀϤⲈⲢϨⲰⲦ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲈⲪⲈⲤⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ⲈⲦⲀϤⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈⲦⲀⲚⲦⲒⲞⲬⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲞⲨⲤⲎⲞⲨ ⲘⲘⲀⲨ ⲀϤⲒ ⲈⲂⲞⲖ ⲈϤⲤⲒⲚⲒ ⲔⲀⲦⲀ ⲘⲀ ⲚⲦⲈϮⲬⲰⲢⲀ ⲚⲦⲈϮⲄⲀⲖⲀⲦⲒⲀ ⲚⲈⲘ ϮⲪⲢⲒⲔⲒⲀ ⲈϤⲦⲀϪⲢⲞ ⲚⲚⲒⲘⲀⲐⲎ ⲦⲎⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲠⲈ ⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲠⲈⲖⲖⲎⲤ ⲈⲞⲨⲢⲈⲘⲢⲀⲔⲞϮ ⲠⲈ ϦⲈⲚⲠⲈϤⲄⲈⲚⲞⲤ ⲈⲞⲨⲢⲰⲘⲒ ⲠⲈ ⲚⲖⲞⲄⲒⲘⲞⲤ ⲈⲀϤⲈⲢⲔⲀⲦⲀⲚⲦⲀⲚ ⲈⲈⲪⲈⲤⲞⲤⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ⲪⲀⲒ ⲚⲈⲀⲨⲈⲢⲔⲀⲐⲎⲔⲒⲚ ⲘⲘⲞϤ ⲈⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲈϤϦⲎⲘ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲚⲀϤⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲀϤϮⲤⲂⲰ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲈⲐⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ ⲘⲘⲀⲨⲀⲦϤ ⲈⲦⲈϤⲤⲰⲞⲨⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ⲪⲀⲒ ⲆⲈ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲚϪⲈⲠⲢⲒⲤⲔⲨⲖⲖⲀ ⲚⲈⲘ ⲀⲔⲨⲖⲖⲀ ⲀⲨϢⲞⲠϤ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲦⲀⲘⲞϤ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲈⲠⲒⲘⲰⲒⲦ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ⲈϤⲞⲨⲰϢ ⲆⲈ ⲈⲒ ⲈⲂⲞⲖ ⲈϮⲀⲬⲀⲒⲀ ⲀⲨϮⲈⲢⲞⲨⲞⲦ ⲚⲀϤ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲀⲨⲤϦⲀⲒ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ϪⲈ ⲚⲤⲈϢⲞⲠϤ ⲈⲢⲰⲞⲨ ⲪⲀⲒ ⲆⲈ ⲈⲦⲀϤⲒ ⲀϤⲈⲢ ⲞⲨⲚⲞϤⲢⲒ ⲈⲘⲀϢⲰ ⲚⲚⲎ ⲈⲦⲀⲨⲚⲀϨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ⲚⲀϤⲤⲞϨⲒ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲈϤⲦⲀⲘⲞ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲢⲈ ⲀⲠⲈⲖⲖⲎⲤ ϦⲈⲚⲔⲞⲢⲒⲚⲐⲞⲤ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲈⲦⲀϤⲤⲈⲠ ⲚⲒⲘⲀ ⲈⲦⲤⲀⲠϢⲰⲒ ⲈⲐⲢⲈϤⲒ ⲈⲈⲪⲈⲤⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀϤϪⲒⲘⲒ ⲚϨⲀⲚⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲀⲚ ⲀⲢⲈⲦⲈⲚϬⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲦⲀⲢⲈⲦⲈⲚⲚⲀϨϮ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲀⲖⲖⲀ ⲞⲨⲆⲈ ⲘⲠⲈⲚⲤⲰⲦⲈⲘ ⲢⲰ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ϢⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲈⲦⲀⲨⲈⲘⲤ ⲐⲎⲚⲞⲨ ⲈⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲠⲒⲰⲘⲤ ⲚⲦⲈⲒⲰⲀⲚⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲒⲰⲀⲚⲚⲎⲤ ⲘⲈⲚ ⲀϤϮⲰⲘⲤ ϦⲈⲚⲞⲨⲘⲰⲞⲨ ⲘⲘⲈⲦⲀⲚⲞⲒⲀ ⲘⲠⲒⲖⲀⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϨⲒⲚⲀ ⲚⲤⲈⲚⲀϨϮ ⲈⲠⲈⲐⲚⲎⲞⲨ ⲘⲈⲚⲈⲚⲤⲰϤ ⲈⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲀⲨϬⲒⲰⲘⲤ ⲈⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ⲞⲨⲞϨ ⲈⲦⲀ ⲠⲀⲨⲖⲞⲤ ⲬⲀ ϪⲒϪ ⲈϪⲰⲞⲨ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲚⲀⲨⲤⲀϪⲒ ⲆⲈ ϦⲈⲚⲪⲖⲀⲤ ⲞⲨⲞϨ ⲚⲀⲨⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ⲚⲐⲰⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲀⲨⲈⲢ ⲒⲂ ⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ⲈⲦⲀϤϢⲈ ⲆⲈ ⲈϦⲞⲨⲚ ⲈϮⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲀϤⲞⲨⲞⲚϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲚⲄ ⲚⲀⲂⲞⲦ ⲈϤⲤⲀϪⲒ ⲞⲨⲞϨ ⲈϤⲐⲰⲦ ⲘⲠⲞⲨϨⲎⲦ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ⲈⲦⲀ ϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲈⲢⲚⲀϢⲦϨⲎⲦ ⲈⲨⲞⲒ ⲚⲀⲦⲤⲰⲦⲈⲘ ⲈⲨⲤⲀϪⲒ ⲈϤϨⲰⲞⲨ ⲚⲤⲀⲠⲒⲘⲰⲒⲦ ⲘⲠⲈⲘⲐⲞ ⲘⲠⲒⲘⲎϢ ⲀϤⲪⲰⲦ ⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲈⲀϤⲪⲰⲢϪ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲂⲞⲖ ⲈϤⲤⲀϪⲒ ⲘⲘⲎ ⲚⲒ ϦⲈⲚϮⲤⲬⲞⲖⲎ ⲚⲦⲈⲦⲨⲢⲀⲚⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ⲪⲀⲒ ⲆⲈ ⲚⲀϤⲢⲀ ⲘⲘⲞϤ ⲚⲢⲞⲘⲠⲒ ⲂϮ ϨⲰⲤⲦⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲀⲤⲒⲀ ⲚⲦⲞⲨⲤⲰⲦⲈⲘ ⲈⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ");
INSERT INTO copbhc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ⲚⲀϤⲒⲢⲒ ⲆⲈ ⲚϨⲀⲚϪⲞⲘ ⲚϪⲈⲪⲚⲞⲨϮ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲈⲚϪⲒϪ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ϨⲰⲤⲆⲈ ⲚⲤⲈϬⲒ ⲚϨⲀⲚⲤⲞⲨⲆⲀⲢⲒⲞⲚ ⲚⲈⲘ ϨⲀⲚⲤⲒⲘⲒⲔⲨⲚⲐⲒⲚⲞⲚ ⲈⲂⲞⲖ ϨⲒ ⲠⲈϤⲤⲰⲘⲀ ⲚⲤⲈⲬⲀⲨ ϨⲒϪⲈⲚ ⲚⲎ ⲈⲦϢⲰⲚⲒ ⲞⲨⲞϨ ⲚⲈϢⲀⲨϢⲈ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲰⲦⲞⲨ ⲚϪⲈⲚⲒϢⲰⲚⲒ ⲞⲨⲞϨ ⲚⲒⲠⲚⲈⲨⲘⲀⲈⲦϨⲰⲞⲨ ⲚⲀⲨⲚⲎⲞⲨ ⲈⲂⲞⲖ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ⲀⲨϨⲒⲦⲞⲦⲞⲨ ⲆⲈ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨⲔⲰϮ ⲚⲈⲜⲞⲢⲄⲒⲤⲦⲎⲤ ⲈϪⲈ ⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲈ ⲚⲒⲠⲚⲈⲨⲘⲀⲈⲦϨⲰⲞⲨ ϨⲒⲰⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϮⲦⲀⲢⲔⲞ ⲘⲘⲰⲦⲈⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲈ ⲠⲀⲨⲖⲞⲤ ϨⲒⲰⲒϢ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ⲚⲈ ⲞⲨⲞⲚ ⲌⲆⲈ ⲚϢⲎⲢⲒ ⲚⲦⲈⲞⲨⲀⲒ ϪⲈ ⲤⲔⲈⲨⲀ ⲈⲞⲨⲒⲞⲨⲆⲀⲒ ⲚⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲈⲨⲒⲢⲒ ⲘⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲦϨⲰⲞⲨ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲒⲎⲤⲞⲨⲤ ϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲔⲈⲠⲀⲨⲖⲞⲤ ϮⲈⲘⲒ ⲈⲢⲞϤ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ⲞⲨⲞϨ ⲀϤϨⲒⲦϤ ⲈϦⲢⲎⲒ ⲈϪⲰⲞⲨ ⲚϪⲈⲠⲒⲢⲰⲘⲒ ⲈⲦⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲦϨⲰⲞⲨ ⲚⲈⲘⲀϤ ⲀϤⲈⲢϬⲞⲒⲤ ⲈⲢⲰⲞⲨ ⲈⲨⲤⲞⲠ ⲀϤϪⲈⲘϪⲞⲘ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ϨⲰⲤⲦⲈ ⲚⲤⲈⲪⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲎⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲂⲎϢ ⲈⲢⲈϪⲰⲞⲨ ⲪⲎϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ⲪⲀⲒ ⲆⲈ ⲀϤϢⲰⲠⲒ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲈⲪⲈⲤⲞⲤ ⲞⲨⲞϨ ⲞⲨϨⲞϮ ⲀⲤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲀϤⲚⲎⲞⲨ ⲚϬⲒⲤⲒ ⲚϪⲈⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ⲞⲨⲘⲎϢ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲦⲀⲨⲚⲀϨϮ ⲚⲀⲨⲚⲎⲞⲨ ⲠⲈ ⲈⲨⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲨϪⲰ ⲚⲚⲞⲨϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ϨⲀⲚⲘⲎϢ ⲆⲈ ϦⲈⲚⲚⲎ ⲈⲚⲀⲨⲒⲢⲒ ⲚⲚⲒⲘⲈⲦⲠⲈⲢⲒⲈⲢⲄⲞⲤ ⲈⲀⲨⲒⲚⲒ ⲚⲚⲞⲨϪⲰⲘ ⲀⲨⲢⲞⲔϨⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲀⲨϤⲒⲰⲠ ⲚⲚⲞⲨⲦⲒⲘⲎ ⲈⲀⲨϪⲈⲘⲞⲨ ⲈⲞⲨⲞⲚ ⲈⲚⲐⲂⲀ ⲚϨⲀⲦ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ⲠⲀⲒⲢⲎϮ ⲆⲈ ϦⲈⲚⲞⲨⲀⲘⲀϨⲒ ⲀϤⲀⲒⲀⲒ ⲚϪⲈⲠⲤⲀϪⲒ ⲘⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲀϤϪⲈⲘϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲚⲀⲒ Ⲁ- ⲠⲀⲨⲖⲞⲤ ⲬⲀⲤ ϦⲈⲚⲠⲈϤⲠⲚⲈⲨⲘⲀϪⲈ ⲀϤϢⲀⲚⲘⲞⲨϢⲦ ⲚⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚⲈⲘ ϮⲀⲬⲀⲒⲀ ⲚⲦⲈϤϢⲈ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲀϤϪⲞⲤ ϪⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲒϢⲈ ⲘⲘⲀⲨ ϨⲰϮ ⲚⲦⲀⲚⲀⲨ ⲈⲦⲔⲈⲢⲰⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ⲀϤⲞⲨⲰⲢⲠ ⲆⲈ ⲚⲂ ⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ϦⲈⲚⲚⲎ ⲈⲦϢⲈⲘϢⲒ ⲘⲘⲞϤ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲚⲈⲘ ⲈⲢⲀⲤⲦⲞⲤ ⲚⲐⲞϤ ⲆⲈ ⲀϤⲈⲢ ⲞⲨⲬⲢⲞⲚⲞⲤ ϦⲈⲚϮⲀⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲘⲠⲒⲤⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲚϪⲈⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀⲚ ⲈⲐⲂⲈ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ⲞⲨⲀⲒ ⲄⲀⲢ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲆⲒⲘⲎⲦⲢⲒⲞⲤ ⲞⲨⲘⲀⲚⲔ ϨⲀⲦ ⲈϤⲘⲞⲚⲔ ⲚϨⲀⲚⲈⲢⲪⲎⲞⲨⲒ ⲚϨⲀⲦ ⲚⲦⲈϮⲀⲢⲦⲈⲘⲒⲤ ⲚⲀϤϮ ⲚϨⲀⲚⲘⲎϢ ⲚϨⲰⲂ ⲚⲚⲒⲦⲈⲬⲚⲒⲦⲎⲤ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ⲚⲀⲒ ⲈⲦⲀϤⲐⲞⲨⲰⲦⲞⲨ ⲚⲈⲘ ⲚⲒⲔⲈⲈⲢⲄⲀⲦⲎ ⲤⲈⲦⲈⲘⲠⲔⲰϮ ⲚⲚⲀⲒ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲒϪⲒⲚⲈⲢϨⲰⲂ ⲀⲢⲈ ϮⲘⲈⲦⲢⲈϤϪⲪⲈ ϨⲎⲞⲨ ϢⲞⲠ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ϪⲈ ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲈⲪⲈⲤⲞⲤ ⲘⲘⲀⲨⲀⲦⲤ ⲀⲖⲖⲀ ⲤⲬⲈⲆⲞⲚ ϦⲈⲚϮⲀⲤⲒⲀ ⲦⲎⲢⲤ ⲀⲪⲀⲒ ϪⲈ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲰⲦⲈⲂ ⲚⲞⲨⲚⲒϢϮ ⲘⲘⲎϢ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲚⲚⲞⲨϮ ⲀⲚ ⲚⲈⲚⲀⲒ ⲈⲦⲞⲨⲐⲀⲘⲒⲞ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲘⲞⲨⲚⲔ ⲚϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ⲞⲨ ⲘⲞⲚⲞⲚ ⲠⲀⲒⲘⲈⲢⲞⲤ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚⲀⲚ ⲈⲞⲨⲔⲨⲚⲆⲒⲚⲞⲤ ⲈⲐⲢⲈⲚⲒ ⲈⲨⲤⲞϨⲒ ⲀⲖⲖⲀ ⲠⲒⲔⲈⲈⲢⲪⲈⲒ ⲚⲦⲈϮⲚⲒϢϮ ⲚⲚⲞⲨϮ ϮⲀⲢⲦⲈⲘⲒⲤ ⲚⲤⲈⲚⲀⲞⲠϤ ⲀⲚ ϪⲈ ⲈϨⲖⲒ ⲞⲨⲞϨ ⲤⲈⲚⲀϢⲞⲢϢⲈⲢ ⲚⲦⲈⲤⲘⲈⲦⲚⲒϢϮ ⲐⲀⲒ ⲈⲦⲈ ϮⲀⲤⲒⲀ ⲦⲎⲢⲤ ⲚⲈⲘ ϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲦⲎⲢⲤ ⲈⲢⲤⲈⲂⲈⲤⲐⲈ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲞⲨⲞϨ ⲈⲦⲀⲨⲘⲞϨ ⲚϪⲰⲚⲦ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲚⲒϢϮ ⲦⲈ ϮⲀⲢⲦⲈⲘⲒⲤ ⲚⲦⲈⲚⲀ ⲈⲪⲈⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ⲞⲨⲞϨ ⲀⲤⲘⲞϨ ⲚϪⲈϮⲠⲞⲖⲒⲤ ⲚϢⲐⲞⲢⲦⲈⲢ ⲀⲨϬⲞϪⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ϦⲈⲚⲞⲨⲞⲨⲞⲒ ⲈⲨⲤⲞⲠ ⲈⲠⲒⲐⲈⲀⲦⲢⲞⲚ ⲀⲨϨⲰⲖⲈⲘ ⲚⲄⲀⲒⲞⲤ ⲚⲈⲘ ⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ⲈϨⲀⲚⲢⲈⲘⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚⲈⲀⲨⲒ ⲈⲠϢⲈⲘⲘⲞ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ⲈϤⲞⲨⲰϢ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲒ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘⲎϢ ⲚⲀⲨⲬⲰ ⲘⲘⲞϤ ⲀⲚ ⲠⲈ ⲚϪⲈⲚⲒⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲀⲢⲬ ⲰⲚ ⲚⲦⲈϮⲀⲤⲒⲀ ⲈⲨⲞⲒ ⲚϢⲪⲎⲢ ⲈⲢⲞϤ ⲀⲨⲞⲨⲰⲢⲠ ϨⲀⲢⲞϤ ⲈⲨϮϨⲞ ⲈϢⲦⲈⲘⲐⲢⲈϤⲦⲎⲒϤ ⲘⲘⲀⲨⲀⲦϤ ⲈⲠⲒⲐⲈⲀⲦⲢⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲘⲈⲚ ⲞⲨⲚ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲚⲔⲈϨⲰⲂ ⲚⲈⲀ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲄⲀⲢ ϢⲐⲞⲢⲦⲈⲢ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲢⲈ ⲠⲞⲨϨⲞⲨⲞ ⲤⲰⲞⲨⲚ ⲀⲚ ϪⲈ ⲈⲦⲀⲨⲐⲰⲞⲨϮ ⲈⲐⲂⲈⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ⲈⲂⲞⲖ ⲆⲈ ϦⲈⲚⲠⲒⲘⲎϢ ⲀⲨⲒⲚⲒ ⲚⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲈⲂⲞⲖ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲖⲈⲜⲀⲚⲆⲢⲞⲤ ⲀϤϬⲰⲢⲈⲘ ⲈⲢⲰⲞⲨ ⲚⲦⲈϤϪⲒϪ ⲈϤⲞⲨⲰϢ ⲈⲈⲢⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ ⲘⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ⲈⲦⲀⲨⲈⲘⲒ ⲆⲈ ϪⲈ ⲞⲨⲒⲞⲨⲆⲀⲒ ⲠⲈ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨϦⲢⲰⲞⲨ ⲚⲞⲨⲰⲦ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲚⲀⲨ ⲞⲨⲚⲞⲨ ⲤⲚⲞⲨϮ ⲈⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲞⲨⲚⲒϢϮ ⲦⲈ ϮⲀⲢⲦⲈⲘⲒⲤ ⲚⲦⲈⲚⲀ ⲈⲪⲈⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ⲈⲦⲀϤⲐⲢⲈ ⲠⲒⲘⲎϢ ⲆⲈ ϨⲈⲢⲒ ⲚϪⲈⲠⲒⲄⲢⲀⲘⲘⲀⲦⲈⲨⲤ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲢⲈⲘⲈⲪⲈⲤⲞⲤ ⲚⲒⲘ ⲄⲀⲢ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲈⲦⲈⲚϤⲤⲰⲞⲨⲚ ⲀⲚ ⲚⲦⲠⲞⲖⲒⲤ ⲚⲚⲒⲢⲈⲘⲈⲪⲈⲤⲞⲤ ϪⲈ ⲤⲞⲒ ⲚⲚⲈⲰⲔⲈⲢⲞⲤ ⲚⲦⲈϮⲚⲒϢϮ ⲚⲀⲢⲦⲈⲘⲒⲤ ⲚⲈⲘ ⲠⲒⲆⲒⲞⲠⲈⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ⲘⲘⲞⲚ ϨⲖⲒ ⲞⲨⲚ ϮⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲚⲀⲒ ⲤⲈⲘⲠϢⲀ ⲞⲨⲚ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲤⲘⲞⲚⲦ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲈⲢ ϨⲖⲒ ⲚϨⲰⲂ ϦⲈⲚⲞⲨⲀⲤⲒⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ⲀⲦⲈⲦⲈⲚⲒⲚⲒ ⲄⲀⲢ ⲚⲚⲀⲒⲢⲰⲘⲒ ⲈⲘⲚⲀⲒ ⲞⲨⲆⲈ ϨⲀⲚⲔⲀⲖⲠ ⲈⲢⲪⲈⲒ ⲀⲚ ⲚⲈⲞⲨⲆⲈ ⲤⲈϪⲈⲞⲨⲀ ⲀⲚ ⲈⲚⲈⲦⲈⲚⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ⲒⲤϪⲈ ⲞⲨⲚ ⲆⲒⲘⲎⲦⲢⲒⲞⲤ ⲚⲈⲘ ⲚⲒⲔⲈⲦⲈⲬ ⲚⲒⲦⲎⲤ ⲈⲐⲚⲈⲘⲀϤ ⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲚⲞⲨⲤⲀϪⲒ ϦⲀ ⲞⲨⲀⲒ ⲤⲈⲚⲀⲒⲚⲒ ⲚⲚⲒⲀⲄⲞⲢⲈⲞⲤ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲀⲚⲐⲨⲠⲀⲦⲞⲤ ϢⲞⲠ ⲘⲀⲢⲞⲨⲤⲈⲘⲒ ⲈⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ⲒⲤϪⲈ ⲆⲈ ⲀⲢⲈⲦⲈⲚⲔⲰϮ ⲚⲤⲀⲔⲈϨⲰⲂ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲚⲞⲘⲒⲘⲞⲚ ⲈⲨⲈⲂⲞⲖϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ⲔⲈ ⲄⲀⲢ ⲦⲈⲚⲈⲢⲔⲨⲚⲆⲒⲚⲈⲨⲒⲚ ⲈⲐⲢⲞⲨⲈⲢⲔⲀⲦⲎ ⲄⲞⲢⲒⲚ ⲈⲢⲞⲚ ⲈⲐⲂⲈ ⲠⲒϢⲐⲞⲢⲦⲈⲢ ⲚⲦⲈⲪⲞⲞⲨ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲖⲰⲒϪⲒ ϢⲞⲠ ⲐⲀⲒ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲚ ⲈϮⲖⲞⲄⲞⲤ ⲈⲐⲂⲎⲦⲤ ϦⲀ ⲠⲒϢⲐⲞⲢⲦⲈⲢ. ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲀϤⲬⲰ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲈϤⲞⲨⲰ ⲆⲈ ⲚϪⲈⲠⲒϢⲐⲞⲢⲦⲈⲢ ⲀⲠⲀⲨⲖⲞⲤ ⲞⲨⲰⲢⲠ ⲚⲤⲀⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲞⲨⲞϨ ⲀϤϮⲚⲞⲘϮ ⲚⲰⲞⲨ ⲀϤⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲘⲘⲰⲞⲨ ⲀϤⲒ ⲈⲂⲞⲖ ⲈϢⲈ ⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ⲈⲦⲀϤⲤⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲞⲨⲞϨ ⲈⲦⲀϤϮⲚⲞⲘϮ ⲚⲰⲞⲨ ϦⲈⲚⲞⲨⲤⲀϪⲒ ⲈϤⲞϢ ⲀϤⲒ ⲈϮⲈⲖⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ⲈⲦⲀϤⲈⲢ ⲄⲆⲈ ⲚⲀⲂⲞⲦ ⲘⲘⲀⲨ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲞϬⲚⲒ ⲈϤϨⲰⲞⲨ ⲈⲐⲂⲎⲦϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲈϤⲚⲀⲒ ⲈϨⲢⲎⲒ ⲈⲦⲤⲨⲢⲒⲀ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨⲤⲞϬⲚⲒ ⲈⲐⲢⲈϤⲔⲞⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ⲚⲀϤⲚⲈⲘⲀϤ ⲆⲈ ⲠⲈ ⲚϪⲈⲤⲰⲤⲒⲠⲀⲦⲢⲞⲤ ⲚⲦⲈⲠⲨⲢⲢⲞⲤ ⲠⲒⲢⲈⲘⲂⲈⲢⲞⲒⲀ ⲚⲀ ⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ ⲆⲈ ⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ⲚⲈⲘ ⲤⲈⲔⲞⲨⲚⲐⲞⲤ ⲚⲈⲘ ⲄⲀⲒⲞⲤ ⲠⲒⲢⲈⲘⲦⲈⲢⲂⲎ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲚⲀ ϮⲀⲤⲒⲀ ⲆⲈ ⲦⲨⲬⲒⲔⲞⲤ ⲚⲈⲘ ⲦⲢⲞⲪⲎⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀⲨⲈⲢϢⲞⲢⲠ ⲈⲢⲞⲚ ⲀⲨⲞϨⲒ ⲚⲀⲚ ϦⲈⲚⲦⲢⲰⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ⲀⲚⲞⲚ ⲆⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲚⲒⲀⲦϢⲈⲘⲎⲢ ⲀⲚⲈⲢϨⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚⲪⲒⲖⲒⲠⲠⲞⲒⲤ ⲞⲨⲞϨ ⲀⲚⲒ ϢⲀⲢⲰⲞⲨ ⲈⲦⲢⲰⲀⲤ ⲘⲠⲈⲚⲈ ⲞⲨⲞϨ ⲀⲚϢⲰⲠⲒ ⲘⲘⲀⲨ ϦⲀⲦⲞⲦⲞⲨ ⲚⲌ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ϦⲈⲚ ⲪⲞⲨⲀⲒ ⲆⲈ ⲚⲦⲈⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲈⲦⲀⲚⲐⲰⲞⲨϮ ⲈⲪⲰϢ ⲚⲞⲨⲰⲒⲔ ⲚⲀϤⲤⲀϪⲒ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲚⲈⲘⲰⲞⲨ ⲈϤⲚⲀⲒ ⲈⲂⲞⲖ ⲈⲠⲈϤⲢⲀⲤϮ ⲚⲀϤⲪⲰⲢϢ ⲆⲈ ⲘⲠⲒⲤⲀϪⲒ ⲈⲂⲞⲖ ϢⲀ ⲦⲪⲀϢⲒ ⲘⲠⲒⲈϪⲰⲢϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ⲚⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲆⲈ ⲚⲖⲀⲘⲠⲀⲤ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲤⲀⲠϢⲰⲒ ⲠⲒⲘⲀ ⲈⲚⲀⲨⲐⲞⲨⲎⲦ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ⲚⲀϤϨⲈⲘⲤⲒ ⲆⲈ ⲠⲈ ⲚϪⲈⲞⲨϦⲈⲖϢⲒⲢⲒ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲈⲨⲦⲨⲬⲞⲤ ϨⲒϪⲈⲚ ⲠⲒϢⲞⲨϢⲦ ⲈϤⲞⲂϢ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲈⲚⲔⲞⲦ ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲤⲀϪⲒ ⲀⲠⲒⲈⲚⲔⲞⲦ ⲤⲞⲔϤ ⲚϨⲞⲨⲞ ⲀϤϨⲈⲒ ⲈⲠⲈⲤⲎⲦ ϦⲈⲚϮⲘⲀϨⲄϮ ⲚⲞⲨⲀϨⲘⲒ ⲞⲨⲞϨ ⲀⲨϤⲒⲦϤ ⲈϤⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ⲀϤⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲀϤϨⲒⲦϤ ⲈϦⲢⲎⲒ ⲈϪⲰϤ ⲞⲨⲞϨ ⲈⲦⲀϤⲘⲞⲖϪϤ ⲈϦⲎⲦϤ ⲠⲈϪⲀϤ ϪⲈ ⲘⲠⲈⲢϢⲐⲞⲢⲦⲈⲢ ⲦⲈϤⲮⲨⲬⲎ ⲄⲀⲢ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ⲈⲦⲀϤϢⲈ ⲆⲈ ⲈϨⲢⲎⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲰϢ ⲘⲠⲒⲰⲒⲔ ⲞⲨⲞϨ ⲈⲦⲀϤϪⲈⲘϮⲠⲒ ⲀϤⲤⲰⲔ ⲘⲠⲒⲤⲀϪⲒ ϢⲀⲦⲈ ⲪⲞⲨⲰⲒⲚⲒ ⲒⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀϤⲒ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ⲀⲨⲒⲚⲒ ⲆⲈ ⲘⲠⲒⲀⲖⲞⲨ ⲈϤⲰⲚϦ ⲞⲨⲞϨ ⲀⲨϬⲒ ⲚⲞⲨⲘⲈⲦⲐⲀⲦϨⲎⲦ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲀⲖⲎⲒ ⲚϢⲞⲢⲠ ⲈⲠⲒϪⲞⲒ ⲀⲚⲒ ⲈϨⲢⲎⲒ ⲈⲀⲤⲤⲞⲤ ⲈⲚⲐⲰϢ ⲈⲦⲀⲖⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲀϤϨⲞⲚϨⲈⲚ ⲄⲀⲢ ⲈⲦⲞⲦⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ⲈϤⲚⲀⲘⲞϢⲒ ⲚⲢⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ⲈⲦⲀϤϮⲘⲀϮ ⲆⲈ ⲈⲢⲞⲚ ϦⲈⲚⲀⲤⲤⲞⲤ ⲀⲚⲦⲀⲖⲞϤ ⲀⲚⲒ ⲈⲘⲒⲖⲒⲦⲒⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲚⲈⲢϨⲰⲦ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲚϮⲘⲀϮ ⲘⲠⲈⲘⲐⲞ ⲚⲬⲒⲞⲤ ⲚϨⲀⲚⲀⲢⲞⲨϨⲒ ⲆⲈ ⲀⲚⲒ ⲈⲤⲀⲘⲞⲤ ⲘⲈⲚⲈⲚⲤⲰϤ ⲀⲚⲒ ⲈⲘⲒⲖⲎⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ⲚⲈ ⲀϤⲐⲰϢ ⲄⲀⲢ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲈⲢϨⲰⲦ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲈⲪⲈⲤⲞⲤ ϨⲞⲠⲰⲤ ϪⲈ ⲚⲚⲈϤⲰⲤⲔ ϦⲈⲚϮⲀⲤⲒⲀ ⲚⲀϤⲒⲎⲤⲞⲨⲤ ⲄⲀⲢ ⲠⲈ ϨⲒⲚⲀ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϤⲈⲢ ⲠⲈϨⲞⲞⲨ ⲚϮⲠⲈⲚⲦⲎ ⲔⲞⲤⲦⲎ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ⲈⲂⲞⲖ ⲆⲈ ϦⲈⲚⲘⲒⲖⲎⲦⲞⲤ ⲀϤⲞⲨⲰⲢⲠ ⲈⲈⲪⲈⲤⲞⲤ ⲀϤⲘⲞⲨϮ ⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈϮⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ⲈⲦⲀⲨⲒ ⲆⲈ ϢⲀⲢⲞϤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲒⲤϪⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲚϨⲞⲨⲒⲦ ⲈⲦⲀⲒⲒ ⲈϮⲀⲤⲒⲀ ϪⲈ ⲀⲒϢⲰⲠⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲚⲀϢ ⲚⲢⲎϮ ⲘⲠⲀⲒⲤⲎⲞⲨ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ⲈⲒⲞⲒ ⲘⲂⲰⲔ ⲘⲠϬⲞⲒⲤ ϦⲈⲚⲐⲈⲂⲒⲞ ⲚϨⲎⲦ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϨⲀⲚⲈⲢⲘⲰⲞⲨⲒ ⲚⲈⲘ ⲚⲒⲠⲒⲢⲀⲤⲘⲞⲤ ⲈⲦⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ϦⲈⲚⲚⲒⲤⲞϬⲚⲒ ⲈⲦϨⲰⲞⲨ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ⲘⲪⲢⲎϮ ⲈⲦⲈⲘⲠⲒϨⲈⲠ ϨⲖⲒ ϦⲈⲚⲚⲎ ⲈⲦⲈⲢⲚⲞϤⲢⲒ ⲚⲞⲨϢⲈⲚ ⲦⲀⲘⲰⲦⲈⲚ ⲈⲢⲰⲞⲨ ⲚⲈⲘ ⲈϮⲤⲂⲰ ⲚⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ⲈⲒⲈⲢⲘⲈⲐⲢⲈ ⲚⲆⲎⲘⲞⲤⲒⲀ ⲚⲈⲘ ⲔⲀⲦⲀ ⲎⲒ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲚϮⲘⲈⲦⲀⲚⲞⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ⲠⲒⲚⲀϨϮ ⲈⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ⲞⲨⲞϨ ϮⲚⲞⲨ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ⲈⲒⲤⲞⲚϨ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϮⲤⲰⲞⲨⲚ ⲀⲚ ⲘⲠⲈⲐⲚⲀⲒ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲒ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ⲠⲖⲎⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲎⲒ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲤⲈⲞϨⲒ ⲚⲀⲔ ⲚϪⲈϨⲀⲚⲤⲚⲀⲨϨ ⲚⲈⲘ ϨⲀⲚⲐⲖⲨⲮⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ⲀⲖⲖⲀ ⲦⲀⲮⲨⲬⲎ ϮⲬⲰ ⲘⲘⲞⲤ ⲀⲚ ϪⲈ ⲤⲦⲀⲒⲎⲞⲨⲦ ⲚⲦⲞⲦ ϦⲈⲚϨⲖⲒ ⲚⲤⲀϪⲒ ϢⲀ ϮϪⲰⲔ ⲘⲠⲀⲆⲢⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲚⲈⲘ ϮⲆⲒⲀⲔⲞⲚⲒⲀ ⲐⲎ ⲈⲦⲀⲒϬⲒⲦⲤ ⲚⲦⲈⲚ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲈⲢⲘⲈⲐⲢⲈ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ⲞⲨⲞϨ ϮⲚⲞⲨ ϨⲎⲠⲠⲈ ⲀⲚⲞⲔ ϮⲈⲘⲒ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲠⲀϨⲞ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲚⲎ ⲈⲦⲀⲒⲤⲒⲚⲒ ⲚϦⲎⲦⲞⲨ ⲈⲒϨⲒⲰⲒϢ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ⲈⲐⲂⲈⲪⲀⲒ ϮⲈⲢⲘⲈⲐⲢⲈ ⲚⲰⲦⲈⲚ ϦⲈⲚⲠⲀⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲪⲞⲞⲨ ϪⲈ ϮⲞⲨⲀⲂ ⲀⲚⲞⲔ ⲈⲂⲞⲖ ϨⲀ ⲠⲈⲦⲈⲚⲤⲚⲞϤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ⲞⲨ ⲄⲀⲢ ⲘⲠⲒϨⲞⲠⲦ ⲈϢⲦⲈⲘⲦⲀⲘⲰⲦⲈⲚ ⲈⲪⲞⲨⲰϢ ⲦⲎⲢϤ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ⲘⲀϨⲐⲎⲦⲈⲚ ⲈⲢⲰⲦⲈⲚ ⲚⲈⲘ ⲠⲒⲞϨⲒ ⲦⲎⲢϤ ⲈⲦⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲬⲀ ⲐⲎⲚⲞⲨ ⲚⲈⲠⲒⲤⲔⲞⲠⲞⲤ ⲚϦⲎⲦϤ ⲈⲀⲘⲞⲚⲒ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲠϬⲞⲒⲤ ⲐⲎ ⲈⲦⲀϤϪⲪⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈϤⲤⲚⲞϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ⲀⲚⲞⲔ ⲆⲈ ϮⲈⲘⲒ ϪⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲐⲢⲒϢⲈ ⲚⲎⲒ ⲤⲈⲚⲀⲒ ⲈϦⲞⲨⲚ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈϨⲀⲚⲞⲨⲰⲚϢ ⲈⲨϨⲞⲢϢ ⲚⲤⲈⲚⲀϮⲀⲤⲞ ⲀⲚ ⲈⲠⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲰⲞⲨⲚ ⲚϪⲈϨⲀⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲨϪⲰ ⲚϨⲀⲚⲤⲀϪⲒ ⲈⲨⲪⲰⲚϨ ⲈⲐⲢⲞⲨⲤⲰⲔ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲤⲀⲘⲈⲚϨⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲚ ⲢⲰⲒⲤ ⲈⲢⲰⲦⲈⲚ ⲈⲢⲈⲦⲈⲚⲒⲢⲒ ⲘⲪⲘⲈⲨⲒ ϪⲈ ⲀⲒⲈⲢ ⲄϮ ⲚⲢⲞⲘⲠⲒ ⲘⲠⲒⲬⲀⲦⲞⲦ ⲈⲂⲞⲖ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲈⲘ ⲠⲒⲈϪⲰⲢϨ ⲈⲒϮⲤⲂⲰ ⲘⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚϨⲀⲚⲈⲢⲘⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ⲞⲨⲞϨ ϮⲚⲞⲨ ϮⲬⲰ ⲘⲘⲰⲦⲈⲚ ϦⲀⲦⲈⲚ ⲠϬⲞⲒⲤ ⲚⲈⲘ ⲠⲤⲀϪⲒ ⲚⲦⲈⲠⲈϤϨⲘⲞⲦ ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲐⲰϢ ⲞⲨⲞϨ ⲈϮⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ϦⲈⲚⲚⲎ ⲈⲦⲀⲨⲦⲞⲨⲂⲰⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ⲞⲨϨⲀⲦ ⲒⲈ ⲞⲨⲚⲞⲨⲂ ⲒⲈ ⲞⲨϨⲂⲰⲤ ⲘⲠⲒⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲈⲞⲨⲞⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲚⲀϪⲒϪ ⲚⲀⲒ ⲀⲨϢⲈⲘϢⲒ ⲚⲦⲀⲬⲢⲒⲀ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ⲀⲒⲦⲀⲘⲰⲦⲈⲚ ⲈϨⲰⲂ ⲚⲒⲂⲈⲚ ϪⲈ ⲤϢⲈ ⲚϦⲞⲤⲒ ⲘⲠⲀⲒⲢⲎϮ ⲚⲦⲈⲚϮⲦⲞⲦⲞⲨ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲚⲦⲈⲦⲈⲚⲈⲢⲪⲘⲈⲨⲒ ⲚⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲚⲐⲞϤ ⲀϤϪⲞⲤ ϪⲈ ⲞⲨⲘⲈⲦⲘⲀⲔⲀⲢⲒⲞⲤ ⲦⲈ ⲘⲀⲖⲖⲞⲚ ⲈϮ ⲈϨⲞⲦⲈ ⲈϬⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ⲞⲨⲞϨ ⲚⲀⲒ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲀϤϨⲒⲦϤ ⲈϪⲈⲚ ⲚⲈϤⲔⲈⲖⲒ ⲚⲈⲘⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲨⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲢⲒⲘⲒ ⲚⲦⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲀⲨϨⲒⲦⲞⲨ ⲈϦⲢⲎⲒ ⲈϪⲈⲚ ⲐⲚⲀϨⲂⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲀⲨϮⲪⲒ ⲈⲢⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ⲈⲨⲞⲒ ⲚⲘⲔⲀϨ ⲚϨⲎⲦ ⲘⲀⲖⲒⲤⲦⲀ ⲈⲐⲂⲈ ⲠⲒⲤⲀϪⲒ ⲈⲦⲀϤϪⲞϤ ϪⲈ ⲤⲈⲚⲀⲚⲀⲨ ⲈⲠⲀϨⲞ ⲀⲚ ϪⲈ ⲚⲀⲨⲦⲪⲞ ⲆⲈ ⲘⲘⲞϤ ⲈϪⲈⲚ ⲠⲒϪⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲚϪⲰⲞⲨⲚ ⲈⲂⲞⲖ ⲀⲚⲪⲰⲢϪ ⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲀⲚⲈⲢϨⲰⲦ ⲈⲚⲤⲰⲞⲨⲦⲈⲚ ⲀⲚⲒ ⲈϨⲢⲎⲒ ⲈⲔⲰ ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲚⲒ ⲈⲢⲞⲆⲞⲤ ⲞⲨⲞϨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲚⲒ ⲈⲠⲀⲦⲀⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ⲞⲨⲞϨ ⲈⲦⲀⲚϪⲒⲘⲒ ⲚⲞⲨϪⲞⲒ ⲈϤⲚⲀⲈⲢϪⲒⲚⲒⲞⲢ ⲈϮⲪⲞⲒⲚⲒⲔⲎ ⲀⲚⲀⲖⲎⲒ ⲀⲚϪⲰⲞⲨⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ⲈⲦⲀⲚⲚⲀⲨ ⲆⲈ ⲈⲔⲨⲠⲢⲞⲤ ⲀⲚⲤⲞϪⲠⲤ ⲤⲀϪⲀϬⲎ ⲘⲘⲞⲚ ⲀⲚⲈⲢϨⲰⲦ ⲈⲦⲤⲨⲢⲒⲀ ⲞⲨⲞϨ ⲀⲚⲒ ⲈⲦⲨⲢⲞⲤ ⲚⲀⲢⲈ ⲠⲒϪⲞⲒ ⲄⲀⲢ ⲚⲀϨⲒⲞⲨⲒ ⲘⲠⲈϤⲀⲞⲨⲒⲚ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ⲈⲦⲀⲚϪⲒⲘⲒ ⲆⲈ ⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲀⲚϢⲰⲠⲒ ⲘⲘⲀⲨ ϦⲀⲦⲞⲦⲞⲨ ⲚⲌ ⲚⲈϨⲞⲞⲨ ⲚⲀⲒ ⲈⲦⲈⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈϢⲦⲈⲘⲐⲢⲈϤϢⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲚϪⲰⲔ ⲚⲚⲒⲈϨⲞⲞⲨ ⲈⲂⲞⲖ ⲀⲚⲒ ⲈⲂⲞⲖ ⲀⲚⲘⲞϢⲒ ⲈⲨⲦⲪⲞ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ϨⲀⲚⲔⲈϨⲒⲞⲘⲒ ⲚⲈⲘ ⲚⲞⲨϢⲎ ⲢⲒ ϢⲀ ⲤⲀⲂⲞⲖ ⲚϮⲠⲞⲖⲒⲤ ⲞⲨⲞϨ ⲀⲚϨⲒⲦⲈⲚ ϨⲒϪⲈⲚ ⲚⲈⲚⲔⲈⲖⲒ ϨⲒϪⲈⲚ ⲠⲒⲬⲢⲞ ⲀⲚⲈⲢⲠⲢⲞⲤⲈⲨⲬ ⲈⲤⲐⲈ ");
INSERT INTO copbhc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ⲞⲨⲞϨ ⲀⲚⲈⲢⲀⲠⲞⲦⲀⲌⲈⲤⲐⲈ ⲈⲂⲞⲖ ϨⲀ ⲚⲈⲚⲈⲢⲎⲞⲨ ⲀⲚⲀⲖⲎⲒ ⲈⲠⲒϪⲞⲒ ⲚⲎ ⲆⲈ ⲀⲨⲔⲞⲦⲞⲨ ⲈⲚⲎ ⲈⲦⲈⲚⲞⲨⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ⲀⲚⲞⲚ ⲆⲈ ⲀⲚⲈⲢϨⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚⲦⲨⲢⲞⲤ ⲀⲚⲒ ⲈϨⲢⲎⲒ ⲈⲠⲦⲞⲖⲈⲘⲀⲒⲤ ⲞⲨⲞϨ ⲈⲦⲀⲚⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲀⲚϢⲰⲠⲒ ϦⲀⲦⲞⲦⲞⲨ ⲚⲞⲨⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲈⲦⲀⲚⲒ ⲈⲂⲞⲖ ⲀⲚⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲚϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲎⲒ ⲘⲪⲒⲖⲒⲠⲠⲞⲤ ⲠⲒⲢⲈϤϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲈⲞⲨⲀⲒ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲌ ⲀⲚϢⲰⲠⲒ ϦⲀⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ⲪⲀⲒ ⲆⲈ ⲚⲈⲞⲨⲞⲚ ⲚⲦⲀϤ ⲘⲘⲀⲨ ⲚⲆ ⲚϢⲈⲢⲒ ⲘⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲨⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ⲈⲦⲀⲚϢⲰⲠⲒ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲀϤⲒ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲈⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲀⲄⲀⲂⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ⲞⲨⲞϨ ⲈⲦⲀϤⲒ ϢⲀⲢⲞⲚ ⲀϤⲰⲖⲒ ⲚϮⲌⲰⲚⲎ ⲚⲦⲈⲠⲀⲨⲖⲞⲤ ⲀϤⲘⲞⲨⲢ ⲚⲚⲈϤϪⲒϪ ⲚⲈⲘ ⲚⲈϤϬⲀⲖⲀⲨϪ ⲠⲈϪⲀϤ ⲚⲀⲒ ⲚⲈⲚⲎ ⲈⲦⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲚϪⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ϪⲈ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲈⲪⲰϤ ⲠⲈ ⲠⲀⲒⲘⲞϪϦ ⲤⲈⲚⲀⲤⲞⲚϨϤ ⲘⲠⲀⲒⲢⲎϮ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲤⲈⲚⲀⲦⲎ ⲒϤ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚϨⲀⲚⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ⲈⲦⲀⲚⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲚⲀⲒ ⲚⲀⲚϮϨⲞ ⲠⲈ ⲀⲚⲞⲚ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲚⲦⲈⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲈϢⲦⲈⲘⲐⲢⲈϤϢⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ⲦⲞⲦⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲦⲈⲚⲢⲀ ⲘⲘⲞϤ ⲈⲢⲈⲦⲈⲚⲢⲒⲘⲒ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚϮⲘⲔⲀϨ ⲘⲠⲀϨⲎⲦ ⲀⲚⲞⲔ ⲄⲀⲢ ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲤⲞⲚϨⲦ ⲀⲖⲖⲀ ϮⲤⲈⲂⲦⲰⲦ ⲈⲘⲞⲨ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ⲈⲦⲈ ⲘⲠⲈ ⲠⲈϤϨⲎⲦ ⲆⲈ ⲐⲰⲦ ⲀⲚⲬⲀⲢⲰⲚ ⲈⲚϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲈⲦⲈϨⲚⲀϤ ⲘⲠϬⲞⲒⲤ ⲘⲀⲢⲈϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒⲈϨⲞⲞⲨ ⲆⲈ ⲈⲦⲀⲚⲤⲈⲂⲦⲰⲦⲈⲚ ⲚⲀⲚⲚⲀ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ⲀⲨⲒ ⲆⲈ ⲚⲈⲘⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚⲔⲈⲤⲀⲢⲒⲀ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲘⲀⲐⲎⲦⲎⲤ ⲈⲀⲨⲒⲚⲒ ⲘⲪⲎ ⲈⲦⲈⲚⲚⲀϪⲰⲒⲖⲒ ⲈⲢⲞϤ ⲞⲨⲀⲒ ϪⲈ ⲚⲀⲤⲤⲰⲚ ⲞⲨⲔⲨⲠⲢⲒⲞⲤ ⲞⲨⲀⲢⲬⲈⲞⲤ ⲘⲘⲀⲐⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ⲈⲦⲀⲚⲒ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨϢⲞⲠⲦⲈⲚ ⲈⲢⲰⲞⲨ ϦⲈⲚⲞⲨⲢⲀϢⲒ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤⲒ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲚⲈⲘⲀⲚ ϢⲀ ⲒⲀⲔⲰⲂⲞⲤ ⲀⲨⲒ ⲆⲈ ϨⲀⲢⲞϤ ⲚϪⲈⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲘⲘⲰⲞⲨ ⲚⲀϤⲤⲀϪⲒ ϦⲀⲦⲞⲦⲞⲨ ⲔⲀⲦⲀ ⲞⲨⲀⲒ ⲞⲨⲀⲒ ⲚⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲀⲒⲦⲞⲨ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲦⲈϤⲆⲒⲀⲔⲞⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲀⲨϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲠⲈϪⲰⲞⲨ ⲆⲈ ⲚⲀϤ ϪⲈ ⲬⲚⲀⲨ ⲠⲈⲚⲤⲞⲚ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲎⲢ ⲚⲐⲂⲀ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲀⲨⲚⲀϨϮ ⲞⲨⲞϨ ϨⲀⲚⲢⲈϤⲬⲞϨ ⲦⲎⲢⲞⲨ ⲚⲈⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ⲀⲨⲦⲀⲘⲰⲞⲨ ⲆⲈ ⲈⲐⲂⲎⲦⲔ ϪⲈ ⲔϮⲤⲂⲰ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲦ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲈⲐⲢⲞⲨϨⲈⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲨⲤⲎⲤ ⲈⲔϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲤⲞⲨⲂⲈ ⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲞⲨⲆⲈ ⲘⲠⲈⲢⲘⲞϢⲒ ⲔⲀⲦⲀ ⲚⲒⲤⲨⲚⲎⲐⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ⲞⲨ ϪⲈ ⲠⲀⲚⲦⲞⲤ ⲤⲈⲚⲀⲤⲰⲦⲈⲘ ϪⲈ ⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ⲪⲀⲒ ⲞⲨⲚ ⲀⲢⲒⲦϤ ⲈⲦⲈⲚⲚⲀϪⲞϤ ⲚⲀⲔ ⲞⲨⲞⲚⲦⲀⲚ ⲚⲆ ⲚⲢⲰⲘⲒ ⲈⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲚⲞⲨⲈⲨⲬⲎ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ϬⲒ ⲚⲚⲀⲒ ⲘⲀⲦⲞⲨⲂⲞⲔ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ϬⲈ ⲆⲀⲠⲀⲚⲎ ⲈⲂⲞⲖ ⲈⲢⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϦⲈⲔ ϪⲰⲞⲨ ⲞⲨⲞϨ ⲈⲨⲈⲈⲘⲒ ⲦⲎⲢⲞⲨ ϪⲈ ⲚⲎ ⲈⲦⲀⲨϪⲞⲦⲞⲨ ⲈⲐⲂⲎⲦⲔ ϨⲀⲚϨⲖⲒ ⲚⲈⲀⲖⲖⲀ ϪⲈ ⲔϮⲘⲀϮ ϨⲰⲔ ⲈⲀⲢⲈϨ ⲈⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ⲈⲐⲂⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲆⲈ ⲈⲦⲀⲨⲚⲀϨϮ ⲀⲚⲞⲚ ⲀⲚⲞⲨⲰⲢⲠ ⲈⲀⲚϮϨⲀⲠ ⲈⲐⲢⲞⲨⲀⲢⲈϨ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲚⲒϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲚⲈⲘ ⲚⲒⲤⲚⲞϤ ⲚⲈⲘ ⲚⲒⲰϪϨ ⲚⲈⲘ ϮⲠⲞⲢⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤϬⲒ ⲚⲚⲒⲢⲰⲘⲒ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲈⲐⲚⲎⲞⲨ ⲀϤⲦⲞⲨⲂⲞϤ ⲚⲈⲘⲰⲞⲨ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲘⲠⲒϪⲰⲔ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠⲒⲦⲞⲨⲂⲞ ϢⲀⲦⲞⲨⲒⲚⲒ ⲚϮⲠⲢⲞⲤⲪⲰⲢⲀ ⲚⲦⲈⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ⲈⲨⲚⲀϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲠⲒⲌ ⲚⲈϨⲞⲞⲨ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲦⲈϮⲀⲤⲒⲀ ⲈϤϦⲈⲚ ⲠⲒⲈⲢⲪⲈⲒ ⲀⲨϢⲐⲞⲢⲦⲈⲢ ⲘⲠⲒⲘⲎ ϢⲦⲎⲢϤ ⲞⲨⲞϨ ⲀⲨⲒⲚⲒ ⲚⲚⲞⲨϪⲒϪ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ");
INSERT INTO copbhc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲚⲒⲢⲰⲘⲒ ⲚⲒⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲀⲢⲒⲂⲞⲎⲐⲒⲚ ⲪⲀⲒ ⲠⲈ ⲠⲒⲢⲰⲘⲒ ⲈⲦϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲠⲀⲒⲘⲀ ⲈϤϮⲤⲂⲰ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲒ ⲆⲈ ⲚⲈⲘ ϨⲀⲚⲔⲈⲞⲨⲈⲒⲚⲒⲚ ⲈⲀϤⲈⲚⲞⲨ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲀϤⲤⲰϤ ⲘⲠⲒⲘⲀ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ⲚⲈ ⲀⲨⲈⲢϢⲞⲢⲠ ⲄⲀⲢ ⲠⲈ ⲚⲚⲀⲨ ⲈⲦⲢⲞⲪⲎ ⲘⲞⲤ ⲚⲈⲘⲀϤ ϦⲈⲚϮⲠⲞⲖⲒⲤ ⲠⲒⲢⲈⲘⲈⲪⲈⲤⲞⲤ ⲪⲀⲒ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ⲀⲠⲀⲨⲖⲞⲤ ⲞⲖϤ ⲈϦⲞⲨⲚ ⲈⲠⲒⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ⲀⲤⲔⲒⲘ ⲆⲈ ⲚϪⲈϮⲠⲞⲖⲒⲤ ⲦⲎⲢⲤ ⲞⲨⲞϨ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨϬⲞϪⲒ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲦⲎⲢϤ ⲈⲨⲤⲞⲠ ⲞⲨⲞϨ ⲈⲦⲀⲨⲀⲘⲀϨⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲀⲨⲤⲞⲔϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲤⲀⲦⲞⲦⲞⲨ ⲀⲨⲘⲀϢⲐⲀⲘ ⲚⲚⲒⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ⲈⲨⲔⲰϮ ⲆⲈ ⲚⲤⲀϦⲞⲐⲂⲈϤ ⲀⲠⲒϢⲒⲚⲒ ⲆⲈ ϢⲈ ⲈϨⲢⲎⲒ ⲘⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲦⲈϮⲤⲠⲒⲢⲀ ϪⲈ ⲀⲤϢⲐⲞⲢⲦⲈⲢ ⲦⲎⲢⲤ ⲚϪⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ⲤⲀⲦⲞⲦϤ ⲆⲈ ⲀϤϬⲒ ⲚϨⲀⲚⲘⲀⲦⲞⲒ ⲚⲈⲘ ϨⲀⲚⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲀϤϬⲞϪⲒ ⲈϪⲰⲞⲨ ⲚⲐⲰⲞⲨ ⲆⲈ ⲈⲦⲀⲨⲚⲀⲨ ⲈⲚⲒⲘⲀⲦⲞⲒ ⲚⲈⲘ ⲠⲒⲬⲒⲖⲒⲀⲢⲬ ⲞⲤ ⲀⲨⲖⲞϪⲞⲨ ⲈⲨϨⲒⲞⲨⲒ ⲈⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ⲦⲞⲦⲈ ⲈⲦⲀϤϦⲰⲚⲦ ⲈϦⲞⲨⲚ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲤⲞⲚϨϤ ⲚϨⲀⲖⲨⲤⲒⲤ ⲂϮ ⲞⲨⲞϨ ⲚⲀϤϢⲒⲚⲒ ϪⲈ ⲚⲒⲘ ⲠⲈ ⲞⲨⲞϨ ϪⲈ ⲞⲨ ⲠⲈⲦⲀϤⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨⲰϢ ⲈⲂⲞⲖ ⲈⲨϪⲰ ⲚⲔⲈϨⲰⲂ ⲈⲦⲈ ⲘⲠⲈϤϢϪⲈⲘϪⲞⲘ ⲆⲈ ⲚⲈⲘⲒ ⲈⲠⲒⲦⲀϪⲢⲞ ⲈⲐⲂⲈ ⲠⲒϢⲐⲞⲢⲦⲈⲢ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲞⲖϤ ⲈϨⲢⲎⲒ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀϤⲀⲖⲎⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲒⲦⲰⲦⲈⲢ ⲀⲤϢⲰⲠⲒ ⲈⲐⲢⲞⲨⲦⲰⲞⲨⲚ ⲘⲘⲞϤ ⲚϪⲈⲚⲒⲘⲀⲦⲞⲒ ⲈⲐⲂⲈ ⲠϬⲒⲚϪⲞⲚⲤ ⲚⲦⲈⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ⲚⲀⲨⲘⲞϢⲒ ⲄⲀⲢ ⲚⲤⲰϤ ⲚϪⲈⲠⲒⲘⲎϢ ⲚⲦⲈⲠⲒⲖⲀⲞⲤ ⲈⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ⲀⲖⲒⲦϤ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ⲈⲨⲚⲀⲈⲚϤ ⲆⲈ ⲈϦⲞⲨⲚ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ϪⲈ ⲀⲚ ⲤϢⲈ ⲚⲎⲒ ⲚⲦⲀϪⲈ ϨⲖⲒ ⲚⲀⲔ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲔⲤⲰⲞⲨⲚ ⲢⲰ ⲘⲘⲈⲦⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ϨⲀⲢⲀ ⲚⲐⲞⲔ ⲀⲚ ⲠⲈ ⲠⲒⲢⲈⲘⲚⲬⲎⲘⲒ ⲈⲦϦⲀϪⲰⲞⲨ ⲚⲚⲀⲒ ⲈϨⲞⲞⲨ ⲀⲔⲒⲢⲒ ⲚϨⲀⲚϢⲐⲞⲢⲦⲈⲢ ⲞⲨⲞϨ ⲀⲔϬⲒ ⲘⲠⲒⲆ ⲚϢⲞ ⲚⲢⲰⲘⲒ ⲚⲦⲈⲚⲒⲤⲒⲔⲀⲢⲒⲞⲤ ⲈⲂⲞⲖ ⲈⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲞⲨⲢⲈⲘⲦⲀⲢⲤⲞⲤ ⲚⲦⲈϮⲔⲨⲖⲒⲔⲒⲀ ⲞⲨⲢⲈⲘⲘⲂⲀⲔⲒ ⲚⲦⲈⲞⲨⲂⲀⲔⲒ ⲈⲤⲞⲒ ⲚⲀⲦⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲀⲚ ϮⲦⲰⲂϨ ⲞⲨⲚ ⲘⲘⲞⲔ ⲈⲐⲢⲈⲔⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲎⲒ ⲚⲦⲀⲤⲀϪⲒ ⲚⲈⲘ ⲠⲀⲒⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ⲈⲦⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲆⲈ ⲚⲀϤ ⲈⲢⲈ ⲠⲀⲨⲖⲞⲤ ⲞϨⲒ ⲈⲢⲀⲦϤ ϨⲒϪⲈⲚ ⲚⲒⲦⲰⲦⲈⲢ ⲀϤⲔⲒⲘ ⲚⲦⲈϤϪⲒϪ ⲞⲨⲂⲈ ⲠⲒⲖⲀⲞⲤ ⲈⲦⲀ ⲞⲨⲚⲒϢϮ ⲆⲈ ⲚⲬⲀⲢⲰϤ ϢⲰⲠⲒ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚϮⲀⲤⲠⲒ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ⲚⲒⲢⲰⲘⲒ ⲚⲒⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲚⲒⲒⲞϮ ⲤⲰⲦⲈⲘ ⲈⲦⲀⲀⲠⲞⲖⲞⲄⲒⲀ ⲈⲦⲈ ⲚⲦⲎⲒ ϢⲀⲢⲰⲦⲈⲚ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ϪⲈ ⲀϤⲈⲢⲞⲨⲰ ⲚⲰⲞⲨ ϦⲈⲚϮⲀⲤⲠⲒ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ⲘⲀⲖⲖⲞⲚ ⲆⲈ ⲀⲨⲬⲀⲢⲰⲞⲨ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲞⲔ ⲞⲨⲢⲰⲘⲒ ⲚⲒⲞⲨⲆⲀⲒ ⲀⲨⲘⲀⲤⲦ ϦⲈⲚⲦⲀⲢⲤⲞⲤ ⲚⲦⲈϮⲔⲨⲖⲒⲔⲒⲀ ⲈⲀⲨϢⲀⲚⲞⲨϢⲦ ϦⲈⲚⲦⲀⲒⲠⲞⲖⲒⲤ ϦⲀⲦⲈⲚ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲄⲀⲘⲀⲖⲒⲎⲖ ⲪⲀⲒ ⲈⲦⲀϤⲦⲤⲀⲂⲞⲒ ⲈⲠⲦⲀϪⲢⲞ ⲚⲦⲈⲪⲚⲞⲘⲞⲤ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲈⲒⲞⲒ ⲚⲢⲈϤⲬⲞϨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰⲦⲈⲚ ⲈⲦⲈⲦⲈⲚⲞⲒ ⲘⲘⲞⲤ ⲚⲐⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲘⲪⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ⲈⲀⲒϬⲞϪⲒ ⲚⲤⲀⲠⲀⲒⲘⲰⲒⲦ ϢⲀ ⲈϦⲢⲎⲒ ⲈⲪⲘⲞⲨ ⲈⲒⲤⲰⲚϨ ⲚϨⲀⲚⲢⲰⲘⲒ ⲚⲈⲘ ϨⲀⲚϨⲒⲞⲘⲒ ⲈⲒϨⲒⲞⲨⲒ ⲘⲘⲰⲞⲨ ⲈⲠϢⲦⲈⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ⲘⲪⲢⲎϮ ⲈⲦⲈ ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲎⲒ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲦⲎⲢⲞⲨ ⲚⲎ ⲈⲦⲀⲒϬⲒ ⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲞⲦⲞⲨ ϢⲀ ⲚⲒⲤⲚⲎⲞⲨ ⲚⲀⲒⲚⲀ ⲆⲈ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲈⲒⲚⲒ ⲚⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲤⲞⲚϨ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϨⲒⲚⲀ ⲚⲤⲈϮⲘⲔⲀϨ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲘⲘⲞⲒ ⲈⲒⲘⲞϢⲒ ⲞⲨⲞϨ ⲈⲦⲀⲒϦⲰⲚⲦ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲘⲠⲔⲰϮ ⲘⲘⲈⲢⲒ ⲚⲞⲨϨⲞϮ ϦⲈⲚⲞⲨϨⲞϮ ⲀϤⲈⲢⲞⲨⲰⲒⲚⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲞⲨⲰⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ⲀⲒϨⲈⲒ ⲆⲈ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲞϨ ⲀⲒⲤⲰⲦⲈⲘ ⲈⲞⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲎⲒ ϪⲈ ⲤⲀⲞⲨⲖ ⲤⲀⲞⲨⲖ ⲀϦⲞⲔ ⲔϬⲞϪⲒ ⲚⲤⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲈⲢⲞⲨⲰ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠϬⲞⲒⲤ ⲠⲈϪⲀϤ ⲆⲈ ⲚⲎⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ ⲪⲎ ⲚⲐⲞⲔ ⲈⲦⲈⲔϬⲞϪⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ⲚⲎ ⲆⲈ ⲈⲚⲀⲨⲚⲈⲘⲎⲒ ⲚⲀⲨⲚⲀⲨ ⲘⲈⲚ ⲈⲠⲒⲞⲨⲰⲒⲚⲒ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲦⲤⲘⲎ ⲘⲠⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ⲠⲈϪⲎⲒ ⲆⲈ ϪⲈ ⲞⲨ ⲠⲈϮⲚⲀⲀⲒϤ ⲠϬⲞⲒⲤ ⲠϬⲞⲒⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲎⲒ ϪⲈ ⲦⲰⲚⲔ ⲘⲀϢⲈ ⲚⲀⲔ ⲈϨⲢⲎⲒ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲞⲨⲞϨ ⲤⲈⲚⲀⲤⲀϪⲒ ⲚⲈⲘⲀⲔ ⲘⲘⲀⲨ ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲐⲀϢⲞⲨ ⲚⲀⲔ ⲈⲐⲢⲈⲔⲀⲒⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲚϮⲚⲀⲨ ⲘⲂⲞⲖ ⲀⲚ ⲚⲦⲈⲚ ⲠⲰⲞⲨ ⲘⲠⲒⲞⲨⲰⲒⲚⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲨⲀⲘⲞⲚⲒ ⲆⲈ ⲚⲦⲀϪⲒϪ ⲚϪⲈⲚⲎ ⲈⲐⲚⲈⲘⲎⲒ ⲀⲒⲒ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ⲞⲨⲀⲒ ⲆⲈ ϪⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲞⲨⲢⲰⲘⲒ ⲈϤⲈⲢϨⲞϮ ⲔⲀⲦⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲈⲨⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϢⲞⲠ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ⲈⲦⲀϤⲒ ⲆⲈ ϢⲀⲢⲞⲒ ⲞⲨⲞϨ ⲈⲦⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲠⲈϪⲀϤ ⲚⲎⲒ ϪⲈ ⲤⲀⲞⲨⲖ ⲠⲀⲤⲞⲚ ⲀⲚⲀⲨ ⲘⲂⲞⲖ ⲀⲚⲞⲔ ⲆⲈ ϨⲰ ϦⲈⲚϮⲞⲨⲚⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲀⲒⲤⲞⲘⲤ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲀϤⲈⲢϢⲞⲢⲠ ⲚⲤⲰⲦⲠⲔ ⲈⲈⲘⲒ ⲈⲠⲈⲦⲈϨⲚⲀϤ ⲞⲨⲞϨ ⲈⲚⲀⲨ ⲈⲠⲒⲐⲘⲎⲒ ⲞⲨⲞϨ ⲈⲤⲰⲦⲈⲘ ⲈⲞⲨⲤⲘⲎ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ϪⲈ ⲬⲚⲀϢⲰⲠⲒ ⲚⲀϤ ⲘⲘⲈⲐⲢⲈ ϦⲀⲦⲈⲚ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲚⲎ ⲈⲦⲀⲔⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲞϨ ⲈⲦⲀⲔⲤⲞⲐⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲞⲨ ⲠⲈⲦⲈⲔⲚⲀⲀⲒϤ ⲦⲰⲚⲔ ϬⲒⲰⲘⲤ ⲞⲨⲞϨ ϪⲞⲔⲘⲈⲔ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲔⲚⲞⲂⲒ ⲈⲔⲦⲰⲂϨ ⲘⲠⲈϤⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲒⲔⲞⲦⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲞϨ ⲈⲒⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲀⲒϢⲰⲠⲒ ϦⲈⲚⲞⲨⲦⲰⲘⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ⲀⲒⲚⲀⲨ ⲈⲢⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲎⲒ ϪⲈ ⲀⲘⲞⲨ ⲚⲬⲰⲖⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ϪⲈ ⲞⲨⲎⲒ ⲤⲈⲚⲀϬⲒ ⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲦⲞⲦⲔ ⲀⲚ ⲈⲐⲂⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ⲀⲚⲞⲔ ϨⲰ ⲠⲈϪⲎⲒ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲐⲰⲞⲨ ⲤⲈⲈⲘⲒ ϪⲈ ⲚⲀⲒϨⲒⲞⲨⲒ ⲈⲠϢⲦⲈⲔⲞ ⲞⲨⲞϨ ⲚⲀⲒϨⲒⲞⲨⲒ ⲔⲀⲦⲀ ⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲚⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ⲞⲨⲞϨ ϨⲞⲦⲈ ⲈⲨⲚⲀⲪⲰⲚ ⲈⲂⲞⲖ ⲘⲠⲤⲚⲞϤ ⲚⲤⲦⲈⲪⲀⲚⲞⲤ ⲠⲈⲔⲘⲀⲢⲦⲨⲢⲞⲤ ⲀⲚⲞⲔ ϨⲰ ⲚⲀⲒⲞϨⲒ ⲈⲢⲀⲦ ⲈⲒϮⲘⲀϮ ⲞⲨⲞϨ ⲚⲀⲒⲀⲢⲈϨ ⲈⲚⲒϨⲂⲰⲤ ⲚⲦⲈⲚⲎ ⲈⲚⲀⲨϦⲰⲦⲈⲂ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ⲞⲨⲞϨ ⲠⲈϪⲀϤ ⲚⲎⲒ ϪⲈ ⲘⲞϢⲒ ϪⲈ ⲀⲚⲞⲔ ϮⲚⲀⲞⲨⲞⲢⲠⲔ ⲈϨⲀⲚⲈⲐⲚⲞⲤ ⲈⲨⲞⲨⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ⲚⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲢⲞϤ ϢⲀ ⲠⲀⲒⲤⲀϪⲒ ⲞⲨⲞϨ ⲀⲨϬⲒⲤⲒ ⲚⲦⲞⲨⲤⲘⲎ ⲈϨⲢⲎⲒ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲖⲒ ⲪⲀⲒ ⲘⲪⲢⲎϮ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲞⲨ ⲄⲀⲢ ϤⲈⲘⲠϢⲀ ⲚⲰⲚϦ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ⲈⲨⲰϢ ⲆⲈ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲨⲤⲒϮ ⲚⲚⲞⲨϨⲂⲰⲤ ⲞⲨⲞϨ ⲈⲨⲤⲈⲦ ϢⲰⲒϢ ⲈⲠⲒⲀⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ⲀϤⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲈⲐⲢⲞⲨϬⲒⲦϤ ⲈϦⲞⲨⲚ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ ⲈⲀϤϪⲞⲤ ⲈⲐⲢⲞⲨϮⲘⲔⲀϨ ⲚⲀϤ ϦⲈⲚϨⲀⲚⲘⲀⲤⲦⲒⲄⲜ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲘⲒ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲚⲖⲰⲒϪⲒ ⲤⲈⲰϢ ⲈⲂⲞⲖ ⲘⲠⲀⲒⲢⲎϮ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀⲨϬⲞⲖⲔϤ ϦⲈⲚⲚⲒϦⲰⲔ ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈⲚⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ϪⲈ ⲞⲨⲢⲰⲘⲒ ⲚⲢⲰⲘⲈⲞⲤ ⲚϤⲈⲢ ⲠⲔⲈϨⲰⲞⲨⲒ ⲘⲠϨⲀⲠ ⲀⲚ ⲠⲈⲦⲤϢⲈ ⲚⲰⲦⲈⲚ ⲠⲈ ⲈⲈⲢⲘⲀⲤⲦⲒⲄⲄⲞⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬ ⲞⲤ ⲀϤϢⲈ ϢⲀ ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲀϤⲦⲀⲘⲞϤ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲚⲀⲀⲒϤ ⲠⲒⲢⲰⲘⲒ ⲄⲀⲢ ⲞⲨⲢⲰⲘⲈⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ⲀϤⲒ ⲆⲈ ϢⲀⲢⲞϤ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ⲚⲀϤ ϪⲈ ⲀϪⲞⲤ ⲚⲎⲒ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲢⲰⲘⲈⲞⲤ ⲚⲐⲞϤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀϨⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲀⲒϢⲰⲠ ⲚⲦⲀⲒⲠⲞⲖⲎⲦⲒⲀ ⲚⲎⲒ ϦⲀ ⲞⲨⲘⲎ ϢⲚⲔⲈⲪⲀⲖⲈⲞⲚ ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲀⲚⲞⲔ ⲈⲦⲀⲨⲘⲀⲤⲦ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ⲤⲀⲦⲞⲦⲞⲨ ⲞⲨⲚ ⲀⲨϨⲈⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲘⲞϤ ⲚϪⲈⲚⲎ ⲈⲦϮⲘⲔⲀϨ ⲚⲀϤ ⲞⲨⲞϨ Ⲁ- ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲈⲢϨⲞϮ ⲈⲦⲀϤⲈⲘⲒ ϪⲈ ⲞⲨⲢⲰⲘⲈⲞⲤ ⲠⲈ ⲞⲨⲞϨ ϪⲈ ⲀϤⲤⲞⲚϨϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲈⲘⲒ ⲈⲠⲒⲦⲀϪⲢⲞ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀϤⲂⲞⲖϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲒ ⲚϪⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲀϤⲈⲚ ⲠⲀⲨⲖⲞⲤ ⲈⲠⲈⲤⲎⲦ ⲀϤⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ⲈⲦⲀϤⲤⲞⲘⲤ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲠⲈϪⲀϤ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲀⲚⲞⲔ ⲚϦⲢⲎⲒ ϦⲈⲚⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲚⲈⲨ ⲀⲒⲈⲢⲠⲞⲖⲒⲦⲈⲨⲈⲤⲐⲈ ⲘⲪⲚⲞⲨϮ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲠⲀⲒⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ⲠⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲆⲈ ⲀⲚⲀⲚⲒⲀⲤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲚⲎ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲀϨⲢⲀϤ ⲈⲐⲢⲞⲨϨⲒⲞⲨⲒ ϦⲈⲚⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ⲦⲞⲦⲈ ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲀϤ ϪⲈ ⲪⲚⲞⲨϮ ⲚⲀϨⲒⲞⲨⲒ ⲈⲢⲞⲔ ⲘⲠⲀⲒⲢⲎϮ ϮϪⲞⲒ ⲈⲦⲞϢϪ ⲚⲔⲞⲚⲒⲀ ⲔⲈⲢⲠⲔⲈϨⲈⲘⲤⲒ ⲈⲔϮϨⲀⲠ ⲈⲢⲞⲒ ⲔⲀⲦⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲞϨ ⲔⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲈⲐⲢⲞⲨϨⲒⲞⲨⲒ ⲈⲢⲞⲒ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ⲚⲎ ⲆⲈ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲠⲈϪⲰⲞⲨ ϪⲈ ⲀⲔϨⲰⲞⲨϢ ⲈⲠⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲒⲤⲰⲞⲨⲚ ⲠⲈ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲞⲨⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲠⲈ ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ⲞⲨⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲈⲔⲖⲀⲞⲤ ⲚⲚⲈⲔϪⲈ ⲠⲈⲦϨⲰⲞⲨ ϦⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ⲈⲦⲀϤⲈⲘⲒ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲈⲢⲞⲤ ⲘⲈⲚ ⲈⲪⲀ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲠⲈ ⲠⲒⲔⲈⲘⲈⲢⲞⲤ ⲆⲈ ⲈⲪⲀ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲠⲈ ⲀϤⲰϢ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲀ ⲚϮϨⲀⲠ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲀⲚⲞⲔ ⲞⲨⲪⲀⲢⲒⲤⲈⲞⲤ ⲈⲐⲂⲈ ⲞⲨϨⲈⲖⲠⲒⲤ ⲚⲈⲘ ⲞⲨⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲀⲚⲞⲔ ⲤⲈϮϨⲀⲠ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ⲪⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞϤ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲞⲨⲦⲈ ⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲞⲨⲞϨ ⲀϤⲪⲰⲢϪ ⲚϪⲈⲠⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ⲚⲒⲤⲀⲆⲆⲞⲨⲔⲈⲞⲤ ⲘⲈⲚ ⲄⲀⲢ ⲤⲈϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲞⲨⲆⲈ ⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲆⲈ ⲠⲚⲈⲨⲘⲀⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲆⲈ ⲤⲈⲞⲨⲰⲚϨ ⲘⲘⲰⲞⲨ ⲈⲨⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϦⲢⲰⲞⲨ ⲞⲨⲞϨ ⲀⲨⲦⲰⲞⲨⲚ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲪⲀⲢⲒⲤⲈⲞⲤ ⲀⲨⲘⲖⲀϦ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲦⲈⲚϪⲈⲘ ϨⲖⲒ ⲘⲠⲈⲦϨⲰⲞⲨ ⲀⲚ ϦⲈⲚⲠⲀⲒⲢⲰⲘⲒ ⲒⲤϪⲈ ⲞⲨⲠⲚⲈⲨⲘⲀⲀϤⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲒⲈ ⲞⲨⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ⲈⲦⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚϢⲐⲞⲢⲦⲈⲢ ⲀϤⲈⲢϨⲞϮ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲘⲎⲠⲰⲤ ⲚⲤⲈϤⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲀϤⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲘⲠⲒⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲚⲦⲞⲨϢⲈ ⲈϨⲢⲎⲒ ⲚⲦⲞⲨϨⲰⲖⲈⲘ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲚⲦⲞⲨⲈⲚϤ ⲈϨⲢⲎⲒ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲈϪⲰⲢϨ ⲈⲐⲚⲎⲞⲨ ⲀⲠϬⲞⲒⲤ ⲞϨⲒ ⲈⲢⲀⲦϤ ⲚⲀϨⲢⲀϤ ⲠⲈϪⲀϤ ϪⲈ ϪⲈⲘⲚⲞⲘϮ ⲘⲪⲢⲎϮ ⲈⲦⲀⲔⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲠⲀⲒⲢⲎϮ ϨⲰϮ ⲈⲢⲞⲔ ⲞⲚ ⲚⲦⲈⲔⲈⲢⲘⲈⲐⲢⲈ ⲈⲐⲂⲎⲦ ϦⲈⲚⲦⲔⲈⲢⲰⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ϢⲰⲠⲒ ⲀⲨⲐⲰⲞⲨϮ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲦⲀⲢⲔⲰⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲈϢⲦⲈⲘⲞⲨⲰⲘ ⲞⲨⲆⲈ ⲈϢⲦⲈⲘⲤⲰ ϢⲀⲦⲞⲨϦⲰⲦⲈⲂ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ⲚⲀⲨⲈⲢϨⲞⲨⲞ ⲆⲈ ⲈⲘ ⲚⲢⲰⲘⲒ ⲚϪⲈⲚⲎ ⲈⲦⲀⲨⲒⲢⲒ ⲘⲠⲀⲒⲀⲚⲀϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ⲚⲀⲒ ⲀⲨⲒ ϢⲀ ⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲠⲈϪⲰⲞⲨ ϪⲈ ϦⲈⲚⲞⲨⲀⲚⲀⲐⲈⲘⲀ ⲀⲚⲦⲀⲢⲔⲞⲚ ⲈϢⲦⲈⲘϪⲈⲘϮⲠⲒ ⲚϨⲖⲒ ϢⲀⲦⲈⲚϦⲰⲦⲈⲂ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ϮⲚⲞⲨ ⲞⲨⲚ ⲞⲨⲞⲚϨ ⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲈⲘ ⲠⲒⲘⲀⲚϮϨⲀⲠ ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲈⲚϤ ϢⲀⲢⲰⲦⲈⲚ ϨⲰⲤ ϪⲈ ⲈⲢⲈⲦⲈⲚⲈⲘⲒ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲈⲐⲂⲎⲦϤ ⲀⲚⲞⲚ ⲆⲈ ⲘⲠⲀⲦⲈϤϦⲰⲚⲦ ⲈⲢⲰⲦⲈⲚ ⲦⲈⲚⲤⲈⲂⲦⲰⲦ ⲈϦⲞⲐⲂⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ⲈⲦⲀϤⲤⲰⲦⲈⲘ ⲆⲈ ⲈϮϪⲞⲢϪⲤ ⲚϪⲈⲠϢⲎⲢⲒ ⲚⲦⲤⲰⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲀϤⲒ ⲀϤϢⲈ ⲈϦⲞⲨⲚ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ ⲀϤⲦⲀⲘⲈ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ⲀϤⲘⲞⲨϮ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲞⲨⲀⲒ ⲚⲚⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ϪⲈ ϬⲒ ⲘⲠⲀⲒϦⲈⲖϢⲒⲢⲒ ⲈϦⲞⲨⲚ ϢⲀ ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲞⲨⲞⲚⲦⲈϤ ⲞⲨϨⲰⲂ ⲄⲀⲢ ⲈϪⲞϤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ⲚⲐⲞϤ ⲘⲈⲚ ⲞⲨⲚ ⲀϤϬⲒⲦϤ ⲀϤⲈⲚϤ ϢⲀ ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲞⲨⲞϨ ⲠⲈϪⲀϤ ϪⲈ ⲠⲈⲦⲤⲞⲚϨ ⲠⲀⲨⲖⲞⲤ ⲀϤⲘⲞⲨϮ ⲈⲢⲞⲒ ⲀϤϪⲞⲤ ⲚⲎⲒ ⲈⲒⲚⲒ ⲘⲠⲀⲒϦⲈⲖϢⲒⲢⲒ ⲈϦⲞⲨⲚ ϢⲀⲢⲞⲔ ⲈⲞⲨⲞⲚⲦⲈϤ ⲞⲨϨⲰⲂ ⲈϪⲞϤ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ⲀϤⲀⲘⲀϨⲒ ⲆⲈ ⲚⲦⲈϤϪⲒϪ ⲚϪⲈⲠⲒⲬⲒⲖⲒⲀⲢⲬ ⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲀⲚⲀⲬⲰⲢⲒⲚ ⲤⲀⲞⲨⲤⲀ ⲘⲘⲀⲨⲀⲦϤ ⲚⲀϤϢⲒⲚⲒ ⲘⲘⲞϤ ϪⲈ ⲞⲨ ⲠⲈⲦⲈⲔⲞⲨⲰϢ ⲈϪⲞϤ ⲚⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ⲠⲈϪⲀϤ ϪⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲨⲤⲈⲘⲚⲎⲦⲤ ⲈⲦⲞⲂϨⲔ ⲚⲢⲀⲤϮ ϨⲞⲠⲰⲤ ⲚⲦⲈⲔⲒⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲠⲒⲘⲀⲚϮϨⲀⲠ ϨⲰⲤ ⲈⲔⲚⲀⲈⲘⲒ ⲈⲐⲂⲎⲦϤ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ⲚⲐⲞⲔ ⲞⲨⲚ ⲘⲠⲈⲚⲐⲢⲈ ⲠⲈⲔϨⲎⲦ ⲐⲰⲦ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞⲚ ϨⲞⲨⲞ ⲄⲀⲢ ⲈⲘ ⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲨϪⲰⲢϪ ⲈⲢⲞϤ ⲚⲀⲒ ⲈⲦⲀⲨⲦⲀⲢⲔⲈ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈϢⲦⲈⲘⲞⲨⲰⲘ ⲞⲨⲆⲈ ⲈϢⲦⲈⲘⲤⲰ ϢⲀⲦⲞⲨϦⲰⲦⲈⲂ ⲘⲘⲞϤ ⲞⲨⲞϨ ϮⲚⲞⲨ ⲤⲈⲤⲈⲂⲦⲰⲦ ⲈⲨϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲒⲰϢ ⲈⲐⲚⲀϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲞⲨⲚ ⲀϤⲬⲀ ⲠⲒϦⲈⲖϢⲒⲢⲒ ⲈⲂⲞⲖ ⲈⲀϤϨⲞⲚϨⲈⲚ ⲚⲀϤ ⲈϢⲦⲈⲘϪⲞⲤ ⲚϨⲖⲒ ϪⲈ ⲀⲔⲦⲀⲘⲞⲒ ⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ⲞⲨⲞϨ ⲀϤⲘⲞⲨϮ ⲈⲂ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲠⲈϪⲀϤ ⲚⲰⲞⲨ ϪⲈ ⲤⲈⲂⲦⲈ ⲤⲘⲘⲀⲦⲞⲒ ϨⲞⲠⲰⲤ ⲚⲤⲈϢⲈ ϢⲀ ⲔⲈⲤⲀⲢⲒⲀ ⲚⲈⲘ ⲞⲚϨⲒⲠⲈⲨⲤ ⲚⲈⲘ ⲤⲚⲢⲈϤϨⲒⲖⲞⲄⲬⲎ ⲒⲤϪⲈⲚ ⲪⲚⲀⲨ ⲚⲀϪⲠⲄ ⲘⲠⲒⲈϪⲰⲢϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ⲚⲤⲈϬⲒ ⲚϨⲀⲚⲔⲈⲦⲈⲂⲚⲰⲞⲨⲒ ϨⲒⲚⲀ ⲚⲦⲞⲨⲦⲀⲖⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲦⲞⲨⲚⲀϨⲘⲈϤ ϢⲀ ⲪⲨⲖⲒⲜ ⲠⲒϨⲎⲄⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ⲀϤⲤϦⲀⲒ ⲆⲈ ⲚⲞⲨⲈⲠⲒⲤⲦⲞⲖⲎ ⲈⲞⲨⲞⲚ ⲚⲦⲀⲤ ⲘⲘⲀⲨ ⲚⲞⲨⲦⲨⲠⲞⲤ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ⲔⲖⲀⲨⲆⲒⲞⲤ ⲖⲨⲤⲒⲀ ⲘⲠⲒⲔⲢⲀⲦⲒⲤⲦⲞⲤ ⲚϨⲎⲄⲈⲘⲰⲚ ⲪⲨⲖⲒⲜ ⲬⲈⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ⲠⲀⲒⲢⲰⲘⲒ ⲀⲨⲦⲀϨⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲈⲨⲘⲈⲨⲒ ⲈϦⲞⲐⲂⲈϤ ⲀⲒϢⲈ ⲚⲈⲘ ⲠⲒⲤⲦⲢⲀⲦⲈⲨⲘⲀ ⲀⲒⲚⲀϨⲘⲈϤ ⲈⲦⲀⲒⲈⲘⲒ ϪⲈ ⲞⲨⲢⲰⲘⲈⲞⲤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ⲈⲒⲞⲨⲰϢ ⲆⲈ ⲈⲈⲘⲒ ⲈϮⲖⲰⲒϪⲒ ⲈⲦⲞⲨϪⲈⲘ ⲀⲢⲒⲔⲒ ⲈⲢⲞϤ ⲈⲐⲂⲎⲦⲤ ⲀⲒⲈⲚϤ ⲈϪⲈⲚ ⲠⲞⲨⲘⲀⲚϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ⲪⲀⲒ ⲈⲦⲀⲒϪⲈⲘϤ ⲈⲨϪⲈⲘ ⲀⲢⲒⲔⲒ ⲈⲢⲞϤ ⲈⲐⲂⲈ ϨⲀⲚⲌⲎⲦⲎⲘⲀ ⲚⲦⲈⲠⲞⲨⲚⲞⲘⲞⲤ ⲘⲠⲒϪⲈⲘ ⲚⲞⲂⲒ ⲆⲈ ⲚϦⲎⲦϤ ⲈϤⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ⲒⲈ ϨⲀⲚⲤⲚⲀⲨϨ ⲚⲦⲈⲞⲨⲈⲄⲔⲖⲎⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ⲈⲦⲀⲨⲦⲀⲘⲞⲒ ⲆⲈ ⲈⲐⲂⲈ ⲞⲨⲤⲞϬⲚⲒ ⲈϤϨⲰⲞⲨ ⲈϤⲚⲀϢⲰⲠⲒ ϦⲀ ⲠⲀⲒⲢⲰⲘⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲤⲀⲦⲞⲦ ⲀⲒⲞⲨⲞⲢⲠϤ ϨⲀⲢⲞⲔ ⲈⲀⲒϨⲞⲚϨⲈⲚ ⲈⲦⲞⲦⲞⲨ ⲚⲚⲈϤⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲈⲐⲢⲞⲨⲤⲀϪⲒ ⲚⲀϨⲢⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ⲚⲒⲘⲀⲦⲞⲒ ⲘⲈⲚ ⲞⲨⲚ ⲔⲀⲦⲀ ⲠⲈⲦⲀⲨⲐⲀϢ ⲚⲰⲞⲨ ⲀⲨⲰⲖⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲚϪⲰⲢϨ ⲈⲀⲨⲈⲚϤ ⲈⲀⲚⲦⲒⲠⲀⲦⲢⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲨⲬⲰ ⲚⲚⲒϨⲒⲠⲈⲨⲤ ⲈⲐⲢⲞⲨϢⲈ ⲚⲈⲘⲀϤ ⲀⲨⲔⲞⲦⲞⲨ ⲈϮⲠⲀⲢⲈⲘⲂⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀⲨⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨϮ ⲚϮⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲀⲨⲦⲀϨⲞ ⲘⲠⲔⲈⲠⲀⲨⲖⲞⲤ ⲚⲀϨⲢⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ⲈⲦⲀϤⲰϢ ⲆⲈ ⲚϮⲈⲠⲒⲤⲦⲞⲖⲎ ⲀϤϢⲒⲚⲒ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲀϢ ⲚⲈⲠⲀⲢⲬⲒⲀ ⲠⲈ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲘⲒ ϪⲈ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϮⲔⲨⲖⲒⲔⲒⲀ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ⲈⲒⲈⲤⲰⲦⲈⲘ ⲈⲢⲞⲔ ⲠⲈϪⲀϤ ϨⲞⲦⲀⲚ ⲀⲨϢⲀⲚⲒ ⲚϪⲈⲚⲈⲔⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲞⲨⲞϨ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲀⲢⲈϨ ⲈⲢⲞϤ ϦⲈⲚⲠⲒⲠⲢⲈⲦⲰⲢⲒⲞⲚ ⲚⲦⲈⲎⲢⲰⲆⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ⲘⲈⲚⲈⲚⲤⲀ ⲈⲆⲈ ⲚⲈϨⲞⲞⲨ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲚϪⲈⲠⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲀⲚⲀⲚⲒⲀⲤ ⲚⲈⲘ ϨⲀⲚⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲈⲘ ⲔⲈⲢⲎⲦⲰⲢ ϪⲈ ⲦⲈⲢⲦⲨⲖⲖⲞⲤ ⲚⲀⲒ ⲈⲦⲀⲨⲒ ⲀⲨⲞⲨⲰⲚϨ ⲘⲠⲒϨⲎⲄⲈⲘⲰⲚ ϦⲀ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ⲈⲦⲀⲨⲘⲞⲨϮ ⲆⲈ ⲈⲢⲞϤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲚϪⲈⲦⲈⲢⲦⲨⲖⲖⲞⲤ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲤϢⲞⲠ ⲚϪⲈⲞⲨϨⲒⲢⲎⲚⲎ ⲈⲤⲞϢ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ⲚⲈⲘ ϨⲀⲚⲦⲀϨⲞ ⲈⲢⲀⲦⲞⲨ ⲈⲨϢⲞⲠ ⲘⲠⲀⲒⲈⲐⲚⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲔϤⲒⲢⲰⲞⲨϢ ");
INSERT INTO copbhc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ⲤⲀⲤⲀ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲦⲈⲚϢⲰⲠ ⲘⲘⲞⲔ ⲔⲢⲀⲦⲒⲤⲐⲈ ⲪⲨⲖⲒⲜ ϦⲈⲚϢⲈⲠϨⲘⲞⲦ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ϨⲒⲚⲀ ⲆⲈ ⲚⲦⲀϢⲦⲈⲘⲦⲀϨⲚⲞ ⲘⲘⲞⲔ ⲚϨⲞⲨⲞ ϮⲦⲰⲂϨ ⲘⲘⲞⲔ ⲈⲐⲢⲈⲔⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ ϦⲈⲚⲞⲨϢⲰⲦ ⲈⲂⲞⲖ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲈⲔⲘⲈⲦⲈⲠⲒⲔⲎ Ⲥ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ⲀⲚϪⲒⲘⲒ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲰⲘⲒ ⲚⲖⲞⲒⲘⲞⲤ ⲈϤⲔⲒⲘ ⲚϨⲀⲚϢⲐⲞⲢⲦⲈⲢ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ ⲈϤⲞⲒ ⲚϨⲞⲨⲒⲦ ⲈⲦϨⲈⲢⲈⲤⲒⲤ ⲚⲦⲈⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ⲪⲀⲒ ⲈⲦⲀϤϬⲰⲚⲦ ⲈⲤⲰϤ ⲘⲠⲒⲔⲈⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲀⲚⲀⲘⲞⲚⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ⲪⲀⲒ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲈⲘⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲐⲞⲔ ⲀⲔϢⲀⲚϦⲈⲦϦⲰⲦϤ ⲈⲐⲂⲈ ⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲈⲦⲈⲚⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ⲀⲨⲞⲨⲀϨⲦⲞⲦⲞⲨ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ϪⲈ ⲚⲀⲒ ϢⲞⲠ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ⲀϤⲈⲢⲞⲨⲰ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲈⲦⲀϤϬⲰⲢⲈⲘ ⲈⲢⲞϤ ⲚϪⲈⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲈⲐⲢⲈϤⲤⲀϪⲒ ⲈⲒⲤⲰⲞⲨⲚ ⲘⲘⲞⲔ ⲒⲤ ⲞⲨⲘⲎϢ ⲚⲢⲞⲘⲠⲒ ⲈⲔⲞⲒ ⲚⲢⲈϤϮϨⲀⲠ ⲈⲠⲀⲒϢⲖⲰⲖ ϮⲚⲀⲈⲢⲞⲨⲰ ϦⲈⲚⲞⲨⲞⲨⲚⲞϤ ⲚϨⲎⲦ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲈⲘⲒ ϪⲈ ⲘⲠⲀⲚⲦⲈ ϨⲞⲨⲞ ⲒⲂ ⲚⲈϨⲞⲞⲨ ϢⲰⲠⲒ ⲒⲤϪⲈⲚ ⲈⲦⲀⲒϢⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲞⲨⲰϢⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ⲞⲨⲆⲈ ⲘⲠⲞⲨϪⲈⲘⲦ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲈⲒⲤⲀϪⲒ ⲚⲈⲘ ⲞⲨⲀⲒ ⲞⲨⲆⲈ ⲈⲒϢⲐⲞⲢⲦⲈⲢ ⲚⲞⲨⲘⲎ ϢⲞⲨⲆⲈ ϦⲈⲚⲚⲒⲤⲨⲚⲀⲄⲰⲄⲎ ⲞⲨⲆⲈ ⲔⲀⲦⲀ ⲠⲞⲖⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ⲞⲨⲆⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲦⲀϨⲈ ⲚⲀⲒ ⲈⲢⲀⲦⲞⲨ ⲚⲀⲒ ⲈⲦⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲘⲘⲰⲞⲨ ϦⲀⲢⲞⲒ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ϮⲞⲨⲰⲚϨ ⲆⲈ ⲘⲪⲀⲒ ⲚⲀⲔ ⲈⲂⲞⲖ ϪⲈ ⲔⲀⲦⲀ ⲠⲀⲒⲘⲰⲒⲦ ⲈⲦⲈ ⲚⲀⲒ ϪⲰ ⲘⲘⲞϤ ϪⲈ ϨⲈⲢⲈⲤⲒⲤ ⲀⲒϢⲈⲘϢⲒ ⲘⲠⲀⲒⲢⲎϮ ⲘⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲀⲒⲞϮ ⲈⲒⲚⲀϨϮ ⲈⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲤϦⲎⲞⲨⲦ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ⲈⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲘⲘⲀⲨ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲈⲪⲚⲞⲨϮ ⲐⲎ ⲈⲦⲈ ⲚⲀⲒ ϨⲰⲞⲨ ⲤⲞⲘⲤ ⲈⲂⲞⲖ ϦⲀϪⲰⲤ ϮⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚⲚⲒⲐⲘⲎⲒ ⲚⲈⲘ ⲚⲒⲢⲈϤϬⲒⲚϪⲞⲚⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ⲚϨⲢⲎⲒ ϦⲈⲚⲪⲀⲒ ϮⲚⲀⲈⲢⲀⲤⲔⲒⲚ ϨⲰ ⲈⲐⲢⲈⲤϢⲰⲠⲒ ⲚⲎⲒ ⲚϪⲈⲞⲨⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲚⲀⲦϬⲢⲞⲠ ⲚⲀϨⲢⲈⲚ ⲪⲚⲞⲨϮ ⲚⲈⲘ ⲚⲀϨⲢⲈⲚ ⲚⲒⲢⲰⲘⲒ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ⲈⲂⲞⲖ ⲆⲈ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲚⲢⲞⲘⲠⲒ ⲀⲒⲒ ⲈⲒⲢⲒ ⲚϨⲀⲚⲘⲈⲐⲚⲀⲎⲦ ⲘⲠⲀⲈⲐⲚⲞⲤ ⲚⲈⲘ ϨⲀⲚⲠⲢⲞⲤⲪⲰⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ⲚⲀⲒ ⲈⲦⲀⲨϪⲈⲘⲦ ⲈⲒⲦⲞⲨⲂⲎⲞⲨⲦ ⲚϦⲎⲦⲞⲨ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲀⲚ ⲞⲨⲆⲈ ⲚⲈⲘ ⲞⲨϢⲐⲞⲢⲦⲈⲢ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ϨⲀⲚⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚϮⲀⲤⲒⲀ ⲚⲀⲒ ⲈⲦⲈⲚⲀⲤⲤϢⲈ ⲚⲤⲈⲒ ⲚⲀϨⲢⲀⲔ ⲞⲨⲞϨ ⲚⲤⲈⲈⲢⲔⲀⲦⲎ ⲄⲞⲢⲒⲚ ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲚⲞⲨϨⲰⲂ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ⲘⲘⲞⲚ ⲚⲀⲒ ⲚⲐⲰⲞⲨ ⲘⲀⲢⲞⲨϪⲞⲤ ϪⲈ ⲞⲨ ⲚϬⲒⲚϪⲞⲚⲤ ⲀⲨϪⲈⲘϤ ⲚϦⲎⲦ ⲈⲒⲞϨⲒ ⲈⲢⲀⲦ ϦⲈⲚⲠⲒⲘⲀ ⲚϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ⲒⲈ ⲈⲐⲂⲈ ⲦⲀⲒⲤⲘⲎ ⲚⲞⲨⲰⲦ ⲐⲀⲒ ⲈⲦⲀⲒⲞϢⲤ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲒⲞϨⲒ ⲈⲢⲀⲦ ϪⲈ ⲈⲐⲂⲈ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲀⲚⲞⲔ ⲤⲈϮϨⲀⲠ ⲈⲢⲞⲒ ⲘⲪⲞⲞⲨ ϨⲒ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ⲀϤϨⲒⲦⲞⲨ ⲆⲈ ⲈⲪⲀϨⲞⲨ ⲚϪⲈⲪⲨⲖⲒⲜ ⲈϤⲈⲘⲒ ϦⲈⲚⲞⲨⲦⲀϪⲢⲞ ⲈⲐⲂⲈ ⲚⲀ ⲠⲒⲘⲰⲒⲦ ⲈⲀϤϪⲞⲤ ϪⲈ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲒ ⲈϨⲢⲎⲒ ⲚϪⲈⲖⲨⲤⲒⲀⲤ ⲠⲒⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲈⲒⲈⲈⲘⲒ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ⲈⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲈⲦⲀⲢⲈϨ ⲈⲢⲞϤ ⲈϮⲘⲦⲞⲚ ⲆⲈ ⲚⲀϤ ⲞⲨⲞϨ ⲈϢⲦⲈⲘϢⲈϢⲦ ϨⲖⲒ ⲚⲚⲎ ⲈⲦⲈⲚⲞⲨϤ ⲈϢⲈⲘϢⲎ ⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ⲘⲈⲚⲈⲚⲤⲀ ϨⲀⲚⲈϨⲞⲞⲨ ⲆⲈ ⲀϤⲒ ⲚϪⲈⲪⲨⲖⲒⲜ ⲚⲈⲘ ⲆⲢⲞⲨⲤⲒⲖⲖⲀ ⲦⲈϤⲤϨⲒⲘⲒ ⲈⲞⲨⲒⲞⲨⲆⲀⲒ ⲦⲈ ⲀϤⲞⲨⲰⲢⲠ ⲚⲤⲀⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲀϤⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ⲈⲐⲂⲈ ⲠⲒⲚⲀϨϮ ⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ⲈϤⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲈⲐⲂⲈ ϮⲘⲈⲐⲘⲎⲒ ⲚⲈⲘ ϮⲈⲄⲔⲢⲀⲦⲒⲀ ⲚⲈⲘ ⲠⲒϨⲀⲠ ⲈⲐⲚⲀϢⲰⲠⲒ ⲈⲦⲀϤϢⲰⲠⲒ ⲆⲈ ϦⲈⲚⲞⲨϨⲞϮ ⲚϪⲈⲪⲨⲖⲒⲜ ⲀϤⲈⲢⲞⲨⲰ ϪⲈ ⲘⲞϢⲒ ϮⲚⲞⲨ ⲀⲒϢⲀⲚϬⲒ ⲆⲈ ⲚⲞⲨⲤⲎⲞⲨ ϮⲚⲀⲞⲨⲰⲢⲠ ⲚⲤⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ⲀⲘⲀ ⲆⲈ ⲚⲀϤⲈⲢϨⲈⲖⲠⲒⲤ ϪⲈ ⲠⲀⲨⲖⲞⲤ ⲚⲀϮ ⲚϨⲀⲚⲬⲢⲎⲘⲀ ⲚⲀϤ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲚⲦⲈϤⲬⲀϤ ⲈⲂⲞⲖ ⲈⲐⲂⲈⲪⲀⲒ ⲚⲀϤⲞⲨⲰⲢⲠ ⲚⲤⲰϤ ⲚⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ⲈϤⲤⲀϪⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ⲈⲦⲀⲨϪⲰⲔ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈⲢⲞⲘⲠⲒ ⲤⲚⲞⲨϮ ⲀϤϬⲒ ⲚⲞⲨⲆⲒⲀⲦⲞⲬⲞⲤ ⲚϪⲈⲪⲨⲖⲒⲜ ⲠⲞⲢⲔⲒⲞⲤ ⲪⲎⲤⲦⲞⲤ ⲈϤⲞⲨⲰϢ ⲆⲈ ⲈϮ ⲚⲞⲨϨⲘⲞⲦ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚϪⲈⲪⲨⲖⲒⲜ ⲀϤⲤⲰϪⲠ ⲘⲠⲀⲨⲖⲞⲤ ⲈϤⲤⲞⲚϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ⲪⲎⲤⲦⲞⲤ ⲞⲨⲚ ⲈⲦⲀϤⲒ ⲈϮⲈⲠⲀⲢⲬⲒⲀ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ⲀϤϢⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲂⲞⲖ ϦⲈⲚⲔⲈⲤⲀⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒϨⲞⲨⲀϮ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲐⲂⲈ ⲠⲀⲨⲖⲞⲤ ⲞⲨⲞϨ ⲚⲀⲨϮϨⲞ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ⲈⲨⲈⲢⲈⲦⲒⲚ ⲚⲞⲨϨⲘⲞⲦ ϦⲀⲢⲞϤ ϨⲞⲠⲰⲤ ⲚⲦⲈϤⲞⲨⲰⲢⲠ ⲚⲤⲰϤ ⲈⲈⲚϤ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲨⲒⲢⲒ ⲚⲞⲨⲬⲢⲞϤ ⲈϦⲞⲐⲂⲈϤ ϨⲒ ⲠⲒⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ⲪⲎⲤⲦⲞⲤ ⲞⲨⲚ ⲀϤⲈⲢⲞⲨⲰ ϪⲈ ⲤⲈⲀⲢⲈϨ ⲈⲠⲀⲨⲖⲞⲤ ϦⲈⲚⲔⲈⲤⲀⲢⲒⲀ ⲚⲐⲞϤ ⲆⲈ ⲈϤⲘⲈⲨⲒ ⲈϢⲈ ⲈⲘⲀⲨ ⲚⲬⲰⲖⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ⲚⲎ ⲞⲨⲚ ⲠⲈϪⲀϤ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ϦⲈⲚⲐⲎⲚⲞⲨ ⲘⲀⲢⲞⲨⲒ ⲈϦⲢⲎⲒ ⲚⲈⲘⲎⲒ ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨϨⲰⲂ ⲈϤϨⲰⲞⲨ ϦⲈⲚⲠⲀⲒⲢⲰⲘⲒ ⲘⲀⲢⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ⲈⲦⲀϤϢⲰⲠⲒ ⲆⲈ ⲚϦⲎⲦⲞⲨ ⲚϨⲞⲨⲞ /- ⲚⲈϨⲞⲞⲨ ⲀⲚ ⲒⲈ ⲒⲀϤⲒ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲈⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀϤϨⲈⲘⲤⲒ ϨⲒ ⲠⲒⲂⲎⲘⲀ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲒⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ⲈⲦⲀϤⲒ ⲆⲈ ⲀⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲀⲢⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲦⲀⲨⲒ ⲈϦⲢⲎⲒ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈⲨⲒⲚⲒ ⲚⲞⲨⲘⲎϢ ⲚⲖⲰⲒϪⲒ ⲈⲨϨⲞⲢϢ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ⲚⲀⲒ ⲈⲦⲈⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚⲦⲀϨⲰⲞⲨ ⲈⲢⲀⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ⲈϤⲈⲢⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϪⲈ ⲞⲨⲆⲈ ⲘⲠⲒⲈⲢⲚⲞⲂⲒ ⲈⲪⲚⲞⲘⲞⲤ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲆⲈ ⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲆⲈ ⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ⲪⲎⲤⲦⲞⲤ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲈⲢϨⲘⲞⲦ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲀϤⲈⲢⲞⲨⲰ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ⲬⲞⲨⲰϢ ⲈϢⲈ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈϬⲒϨⲀⲠ ⲘⲘⲀⲨ ϦⲀⲦⲞⲦⲞⲨ ⲈⲐⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϮⲞϨⲒ ⲈⲢⲀⲦ ϨⲒϪⲈⲚ ⲠⲒⲂⲎⲘⲀ ⲚⲦⲈⲠⲞⲨⲢⲞ ⲠⲒⲘⲀ ⲈⲦⲤϢⲈ ⲚⲦⲞⲨϮϨⲀⲠ ⲈⲢⲞⲒ ⲘⲘⲞϤ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲆⲈ ⲘⲠⲒϬⲒⲦⲞⲨ ⲚϪⲞⲚⲤ ⲚϨⲖⲒ ⲘⲪⲢⲎϮ ϨⲰⲔ ⲈⲦⲈⲔⲤⲰⲞⲨⲚ ⲈⲘⲀϢⲰ ");
INSERT INTO copbhc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ⲒⲤϪⲈ ⲞⲨⲚ ϮϬⲒⲚϪⲞⲚⲤ ⲞⲨⲞϨ ⲒⲤϪⲈ ⲀⲒⲈⲢϨⲖⲒ ⲚϨⲰⲂ ⲈϤⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ⲒⲈ ϮⲈⲢⲠⲀⲢⲀⲦⲒⲤⲐⲈ ⲀⲚ ⲈⲘⲞⲨ ⲒⲤϪⲈ ⲆⲈ ⲘⲘⲞⲚ ϨⲖⲒ ϢⲞⲠ ϦⲈⲚⲚⲎ ⲈⲦⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞⲒ ⲚϪⲈⲚⲀⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ⲦⲎⲒⲦ ⲚⲰⲞⲨ ⲚϨⲘⲞⲦ ϮⲈⲢⲈⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ⲦⲞⲦⲈ ⲀⲪⲎⲤⲦⲞⲤ ⲤⲀϪⲒ ⲚⲈⲘ ⲠⲒⲤⲨⲘⲂⲞⲨⲖⲞⲚ ⲀϤⲈⲢⲞⲨⲰ ⲀⲔⲈⲢⲈⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ ⲈⲔⲈϢⲈ ϢⲀ ⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ⲈⲦⲀⲨⲤⲒⲚⲒ ⲆⲈ ⲚϪⲈϨⲀⲚⲈϨⲞⲞⲨ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲠⲞⲨⲢⲞ ⲚⲈⲘ ⲂⲈⲢⲚⲒⲔⲎ ⲀⲨⲈⲢⲔⲀⲦⲀⲚⲦⲀⲚ ⲈⲔⲈⲤⲀⲢⲒⲀ ⲀⲨⲈⲢⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲘⲪⲎⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ⲈⲦⲀⲨⲈⲢ ⲞⲨⲘⲎϢ ⲆⲈ ⲚⲈϨⲞⲞⲨ ⲘⲘⲀⲨ ⲀⲪⲎⲤⲦⲞⲤ ⲬⲀ ⲠϨⲰⲂ ⲘⲠⲀⲨⲖⲞⲤ ϦⲀⲦⲞⲦϤ ⲘⲠⲞⲨⲢⲞ ⲈϤϪⲰ ⲘⲘⲞⲤ ⲞⲨⲞⲚ ⲞⲨⲢⲰⲘⲒ ⲈϤⲤⲞⲚϨ ⲈⲀϤⲤⲰϪⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲨⲖⲒⲜ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ⲈⲦⲀⲒϢⲈ ⲆⲈ ⲈϨⲢⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨⲞⲨⲞⲚϨⲞⲨ ⲚϪⲈⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲈⲤⲂⲨⲦⲈⲢⲞⲤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲨⲈⲢⲈⲦⲒⲚ ϦⲀⲢⲞϤ ⲚⲞⲨⲔⲀⲦⲀⲦⲒⲔⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ⲀⲒⲞⲨⲰϨⲈⲘ ⲆⲈ ⲚⲰⲞⲨ ⲈⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲤⲨⲚⲎⲐⲒⲀ ⲀⲚ ⲦⲈ ⲚⲦⲈⲚⲒⲢⲰⲘⲈⲞⲤ ⲈϮ ⲚⲞⲨⲢⲰⲘⲒ ⲚϨⲘⲞⲦ ⲘⲠⲀⲦⲞⲨⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ⲚϪⲈⲚⲒⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲎ ⲈⲦⲞⲨⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲚⲦⲈϤϪⲈⲘ ⲘⲀ ⲚϮ ⲚⲦⲈϤⲀⲠⲞⲖⲞⲄⲒⲀ ⲈⲐⲂⲈ ⲠⲒⲀⲢⲒⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ⲈⲦⲀⲨⲒ ⲞⲨⲚ ⲚⲈⲘⲎⲒ ⲈⲠⲀⲒⲘⲀ ⲘⲠⲒⲈⲢ ϨⲖⲒ ⲚϬⲒϨⲞ ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲒϨⲈⲘⲤⲒ ϨⲒ ⲠⲒⲂⲎⲘⲀ ⲀⲒⲞⲨⲀϨⲤⲀϨⲚⲒ ⲈⲐⲢⲞⲨⲒⲚⲒ ⲘⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲦⲀ ⲚⲒⲔⲀⲦⲎⲄⲞⲢⲞⲤ ⲞϨⲒ ⲈⲢⲀⲦⲞⲨ ϦⲀⲢⲞϤ ⲚⲀⲨⲒⲚⲒ ⲚϨⲀⲚⲖⲰⲒϪⲒ ⲀⲚ ϦⲈⲚⲚⲎ ⲀⲚⲞⲔ ⲈϮⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ϪⲈ ⲤⲈϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ϨⲀⲚⲌⲎⲦⲎⲘⲀ ⲞⲨⲚ ⲚⲰⲞⲨ ⲞⲨⲦⲰⲞⲨ ⲚⲈⲘⲀϤ ⲈⲐⲂⲈ ⲞⲨⲤⲂⲰ ⲚⲒϦ ⲚⲦⲰⲞⲨ ⲚⲈⲘ ⲈⲐⲂⲈ ⲞⲨⲀⲒ ϪⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲀϤⲘⲞⲨ ⲪⲀⲒ ⲈⲚⲀⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ⲚⲀⲒⲦⲰⲘⲦ ⲆⲈ ⲀⲚⲞⲔ ⲈⲐⲂⲈ ⲚⲀⲒⲌⲎⲦⲎⲘⲀ ⲚⲦⲈⲚⲀⲒ ⲚⲀⲒϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤϪⲈ ⲬⲞⲨⲰϢ ⲈϢⲈ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲤⲈϮϨⲀⲠ ⲈⲢⲞⲔ ⲘⲘⲀⲨ ⲈⲐⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ⲈⲦⲀ ⲠⲀⲨⲖⲞⲤ ⲈⲢⲈ ⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ ⲀⲒⲀⲢⲈϨ ⲈⲢⲞϤ ⲈⲠⲤⲞⲨⲈⲚ ⲠⲞⲨⲢⲞ ⲀⲒⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲈⲐⲢⲞⲨⲀⲢⲈϨ ⲈⲢⲞϤ ϢⲀ ϮⲞⲨⲞⲢⲠϤ ⲘⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲪⲎⲤⲦⲞⲤ ϪⲈ ⲚⲀⲒⲞⲨⲰϢ ϨⲰ ⲠⲈ ⲈⲤⲰⲦⲈⲘ ⲈⲠⲒⲢⲰⲘⲒ ⲢⲀⲤϮ ⲄⲀⲢ ⲠⲈϪⲀϤ ⲈⲔⲈⲤⲰⲦⲈⲘ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ⲠⲈϤⲢⲀⲤϮ ⲞⲨⲚ ⲈⲦⲀϤⲒ ⲚϪⲈⲀⲄⲢⲒⲠⲠⲀ ⲚⲈⲘ ⲂⲈⲢⲚⲒⲔⲎ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲘⲪⲀⲚⲦⲀⲤⲒⲀ ⲞⲨⲞϨ ⲈⲦⲀⲨϢⲈ ⲈϦⲞⲨⲚ ⲈⲠⲒⲘⲀ ⲚϬⲒⲤⲘⲎ ⲚⲈⲘ ϨⲀⲚⲬⲒⲖⲒⲀⲢⲬⲞⲤ ⲚⲈⲘ ϨⲀⲚⲢⲰⲘⲒ ⲈⲨⲞⲒ ⲚⲚⲒϢϮ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ⲞⲨⲞϨ ⲈⲦⲀϤⲈⲢⲔⲈⲖⲈⲨⲒⲚ ⲚϪⲈⲪⲎⲤⲦⲞⲤ ⲀⲨⲒⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ⲞⲨⲞϨ ⲠⲈϪⲈ ⲪⲎⲤⲦⲞⲤ ϪⲈ ⲠⲞⲨⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲈⲘⲀⲚ ⲦⲈⲦⲈⲚⲚⲀⲨ ⲈⲪⲀⲒ ⲈⲐⲂⲎⲦϤ ⲀⲠⲒⲘⲎϢ ⲦⲎⲢϤ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲤⲈⲘⲒ ⲚⲎⲒ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ϦⲈⲚⲠⲀⲒⲔⲈⲘⲀ ⲈⲨⲰϢ ⲈⲂⲞⲖ ϪⲈ ϤⲈⲘⲠϢⲀ ⲚⲰⲚϦ ⲀⲚ ϪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲈⲘⲒ ⲈⲢⲞϤ ϪⲈ ⲘⲠⲈϤⲈⲢ ϨⲖⲒ ⲈϤⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ⲪⲀⲒ ⲆⲈ ⲚⲐⲞϤ ⲈⲦⲀϤⲈⲢⲈⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ ⲀⲒϮϨⲀⲠ ⲈⲞⲨⲞⲢⲠϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ⲪⲀⲒ ⲈⲦⲈⲘⲘⲞⲚ ⲠⲈϮⲚⲀⲤϦⲎⲦϤ ⲚⲦⲀϪⲢⲞ ⲈⲐⲂⲎⲦϤ ⲘⲠⲀϬⲞⲒⲤ ⲠⲞⲨⲢⲞ ⲈⲐⲂⲈⲪⲀⲒ ⲀⲒⲈⲚϤ ⲚⲀϨⲢⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲘⲀⲖⲒⲤⲦⲀ ⲚⲀϨⲢⲀⲔ ⲠⲞⲨⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ϨⲞⲠⲰⲤ ⲈⲀⲔϢⲈⲚϤ ⲈϨⲢⲀϤ ⲚⲦⲀϪⲈⲘ ⲠⲈϮⲚⲀⲤϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ϮⲘⲈⲨⲒ ⲄⲀⲢ ϪⲈ ⲞⲨϨⲰⲂ ⲚⲀⲦⲤⲀϪⲒ ⲠⲈ ⲈⲞⲨⲞⲢⲠ ⲘⲠⲈⲦⲤⲞⲚϨ ⲈϢⲦⲈⲘⲈⲢⲤⲨⲘⲈⲚⲒⲚ ⲚⲚⲈϤⲔⲈⲖⲰⲒϪⲒ ⲈⲦϬⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ⲤⲈⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲀⲔ ⲈⲤⲀϪⲒ ⲈϪⲰⲔ ⲦⲞⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲀϤⲤⲞⲨⲦⲈⲚ ⲦⲈϤϪⲒϪ ⲈⲂⲞⲖ ⲀϤⲈⲢⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ ");
INSERT INTO copbhc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ⲈⲐⲂⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨϪⲈⲘ ⲀⲢⲒⲔⲒ ⲈⲢⲞϤ ⲚϦⲎⲦⲞⲨ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲠⲞⲨⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ϮⲘⲈⲨⲒ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲘⲀⲔⲀⲢⲒⲞⲤ ⲈⲒⲚⲀⲈⲢⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ ⲘⲪⲞⲞⲨ ϦⲀⲦⲞⲦⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ⲘⲀⲖⲒⲤⲦⲀ ⲈⲔⲤⲰⲞⲨⲚ ⲚⲚⲒⲤⲨⲚⲎⲐⲒⲀ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲞⲨⲌⲎⲦⲎⲘⲀ ⲈⲐⲂⲈⲪⲀⲒ ϮⲦⲰⲂϨ ⲘⲘⲞⲔ ⲈⲐⲢⲈⲔⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ ϦⲈⲚⲞⲨⲘⲈⲦⲢⲈϤⲰⲞⲨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ⲠⲀϪⲒⲚⲰⲚϦ ⲒⲤϪⲈⲚ ⲦⲀⲘⲈⲦⲀⲖⲞⲨ ⲈⲦⲀϤϢⲰⲠⲒ ⲒⲤϪⲈⲚ ϨⲎ ϦⲈⲚⲠⲀⲈⲐⲚⲞⲤ ⲚϨⲢⲎⲒ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲤⲈⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ⲈⲨⲈⲢϢⲞⲢⲠ ⲚⲤⲰⲞⲨⲚ ⲘⲘⲞⲒ ⲒⲤϪⲈⲚ ⲤⲀⲠϢⲰⲒ ⲀⲨϢⲀⲚⲞⲨⲰϢ ⲈⲈⲢⲘⲈⲐⲢⲈ ϪⲈ ⲔⲀⲦⲀ ϮϨⲈⲢⲈⲤⲒⲤ ⲈⲦⲦⲀϪⲢⲎⲞⲨⲦ ⲚⲦⲈⲠⲈⲚϢⲈⲘϢⲒ ⲀⲒⲰⲚϦ ⲘⲪⲀⲢⲒⲤⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲈⲐⲂⲈ ⲦϨⲈⲖⲠⲒⲤ ⲘⲠⲒⲰϢ ⲈⲦⲀϤϢⲰⲠⲒ ⲚⲚⲈⲚⲒⲞϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ϮⲞϨⲒ ⲈⲢⲀⲦ ⲈⲨϮϨⲀⲠ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ⲈⲦⲈ ⲦⲀⲒϨⲈⲖⲠⲒⲤ ⲦⲈ ⲈⲚⲀⲢⲈ ϮⲒⲂ ⲘⲪⲨⲖⲎ ϢⲈⲘϢⲒ ϦⲈⲚⲞⲨⲘⲞⲨⲚ ⲈⲂⲞⲖ ⲘⲠⲒⲈϨⲞⲞⲨ ⲚⲈⲘ ⲠⲒⲈϪⲰⲢϨ ⲈⲨⲞⲨⲰϢ ⲈⲐⲢⲈ ⲦⲞⲦⲞⲨ ϮⲘⲀϮ ⲈⲢⲞⲤ ⲈⲐⲂⲈ ⲦⲀⲒϨⲈⲖⲠⲒⲤ ⲠⲞⲨⲢⲞ ⲤⲈϪⲈⲘ ⲀⲢⲒⲔⲒ ⲈⲢⲞⲒ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ⲞⲨ ⲘⲈⲦⲀⲐⲚⲀϨϮ ⲦⲈ ⲘⲀϨⲀⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲒⲤϪⲈ ⲪⲚⲞⲨϮ ⲚⲀⲦⲞⲨⲚⲞⲤ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ⲀⲚⲞⲔ ⲘⲈⲚ ⲞⲨⲚ ⲚⲀⲒⲘⲈⲨⲒ ⲈⲢⲞⲒ ⲈⲈⲢ ⲞⲨⲘⲎϢ ⲚϨⲰⲂ ⲈⲨϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲪⲢⲀⲚ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲒⲚⲀⲌⲰⲢⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ⲪⲀⲒ ⲈⲦⲀⲒⲀⲒϤ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲞⲨⲘⲎϢ ϦⲈⲚⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲀⲚⲞⲔ ⲀⲒϨⲒⲦⲞⲨ ⲈϦⲞⲨⲚ ⲈⲚⲒϢⲦⲈⲔⲰⲞⲨ ⲈⲀⲒϬⲒ ⲘⲠⲒⲈⲢϢⲒϢⲒ ϨⲒⲦⲈⲚ ⲚⲒⲀⲢⲬⲎⲈⲢⲈⲨⲤ ⲈⲨϦⲰⲦⲈⲂ ⲘⲘⲰⲞⲨ ϢⲀⲒϮⲰⲠ ϦⲀⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ⲔⲀⲦⲀ ⲤⲨⲚⲀⲄⲰⲄⲎ ⲚⲒⲂⲈⲚ ⲈⲒϮⲘⲔⲀϨ ⲚⲰⲞⲨ ⲚⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ⲚⲀⲒϬⲒ ⲘⲘⲰⲞⲨ ⲚϪⲞⲚⲤ ⲈⲐⲢⲞⲨϪⲈⲞⲨⲀ ϦⲈⲚⲞⲨⲘⲈⲦϨⲞⲨⲞ ⲆⲈ ⲈⲒϦⲈⲚ ⲞⲨⲖⲒⲂⲒ ⲈϦⲞⲨⲚ ⲈⲢⲰⲞⲨ ϢⲀⲒϬⲞϪⲒ ⲚⲤⲰⲞⲨ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲚⲒⲔⲈⲠⲞⲖⲒⲤ ⲈⲦⲤⲀⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ⲞⲨⲞϨ ϦⲈⲚⲚⲀⲒ ⲈⲒⲘⲞϢⲒ ⲈⲆⲀⲘⲀⲤⲔⲞⲤ ⲚⲈⲘ ⲞⲨⲈⲜⲞⲨⲤⲒⲀ ⲚⲈⲘ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲦⲈⲚⲒⲀⲢⲬⲒⲈⲢⲈⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ⲈⲒϨⲒ ⲠⲒⲘⲰⲒⲦ ⲆⲈ ϦⲈⲚⲦⲪⲀϢⲒ ⲘⲠⲒⲈϨⲞⲞⲨ ⲀⲒⲚⲀⲨ ⲠⲞⲨⲢⲞ ⲈⲞⲨⲞⲨⲰⲒⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈϤⲪⲞⲢⲒ ⲈϨⲞⲦⲈ ⲪⲢⲎ ⲀϤⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ⲚⲈⲘ ⲚⲎ ⲈⲐⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ⲈⲦⲀⲚϨⲈⲒ ⲆⲈ ⲦⲎⲢⲈⲚ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲀⲒⲤⲰⲦⲈⲘ ⲈⲞⲨⲤⲘⲎ ⲈⲤϪⲰ ⲘⲘⲞⲤ ⲚⲎⲒ ϦⲈⲚϮⲀⲤⲠⲒ ⲘⲘⲈⲦϨⲈⲂⲢⲈⲞⲤ ϪⲈ ⲤⲀⲞⲨⲖ ⲤⲀⲞⲨⲖ ⲀϦⲞⲔ ⲔϬⲞϪⲒ ⲚⲤⲰⲒ ⲞⲨϨⲰⲂ ⲈϤⲚⲀϢⲦ ⲚⲀⲔ ⲠⲈ ⲈϮϢⲈⲚⲪⲀⲦ ⲈϦⲞⲨⲚ ϦⲈⲚϨⲀⲚⲤⲞⲨⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ⲀⲚⲞⲔ ⲆⲈ ⲠⲈϪⲎⲒ ϪⲈ ⲚⲐⲞⲔ ⲚⲒⲘ ⲠϬⲞⲒⲤ ⲠϬⲞⲒⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲚⲎⲒ ϪⲈ ⲀⲚⲞⲔ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲚⲐⲞⲔ ⲈⲦⲈⲔϬⲞϪⲒ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ⲀⲖⲖⲀ ⲦⲰⲚⲔ ⲞϨⲒ ⲈⲢⲀⲦⲔ ⲈϪⲈⲚ ⲚⲈⲔϬⲀⲖⲀⲨϪ ⲈⲐⲂⲈⲪⲀⲒ ⲄⲀⲢ ⲀⲒⲞⲨⲞⲚϨⲦ ⲈⲢⲞⲔ ⲈⲤⲞⲦⲠⲔ ⲚⲞⲨϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲚⲎⲒ ⲞⲨⲞϨ ⲚⲦⲈⲔⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲎ ⲈⲦⲀⲔⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲚⲎ ⲈϮⲚⲀⲞⲨⲞⲚϨⲦ ⲈⲢⲞⲔ ⲚϦⲎⲦⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ⲈⲒⲈⲚⲀϨⲘⲈⲔ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲚⲎ ⲀⲚⲞⲔ ⲈϮⲚⲀⲞⲨⲞⲢⲠⲔ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ⲈⲀⲞⲨⲰⲚ ⲚⲚⲞⲨⲂⲀⲖ ⲈⲐⲢⲞⲨⲔⲞⲦⲞⲨ ⲈⲂⲞⲖ ϨⲀ ⲠⲬⲀⲔⲒ ⲈϦⲞⲨⲚ ⲈⲪⲞⲨⲰⲒⲚⲒ ⲚⲈⲘ ⲈⲂⲞⲖ ϨⲀ ⲠⲈⲢϢⲒϢⲒ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲪⲚⲞⲨϮ ⲈⲐⲢⲞⲨϬⲒ ⲘⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲞⲨⲚⲞⲂⲒ ⲚⲈⲘ ⲞⲨⲔⲖⲎⲢⲞⲚⲞⲘⲒⲀ ϦⲈⲚⲚⲎ ⲈⲦⲦⲞⲨⲂⲎⲞⲨⲦ ϦⲈⲚⲠⲒⲚⲀϨϮ ⲈⲢⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ⲈⲐⲂⲈⲪⲀⲒ ⲠⲞⲨⲢⲞ ⲀⲄⲢⲒⲠⲠⲀ ⲘⲠⲒϢⲈⲢⲀⲦⲤⲰⲦⲈⲘ ⲚⲤⲀⲠⲒⲚⲀⲨ ⲚⲦⲈⲦⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ⲀⲖⲖⲀ ⲚⲎ ⲈⲦϦⲈⲚ ⲆⲀⲘⲀⲤⲔⲞⲤ ⲚϢⲞⲢⲠ ⲚⲈⲘ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ⲦⲬⲰⲢⲀ ⲦⲎⲢⲤ ⲚⲦⲈϮⲒⲞⲨⲆⲈⲀ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ ⲀⲒϨⲒⲰⲒϢ ⲚⲰⲞⲨ ⲈⲐⲢⲞⲨⲈⲢⲘⲈⲦⲀⲚⲞⲒⲚ ⲞⲨⲞϨ ⲈⲐⲢⲞⲨⲔⲞⲦⲞⲨ ⲈⲪⲚⲞⲨϮ ⲈⲒⲢⲒ ⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲈⲨⲘⲠϢⲀ ⲚϮⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ⲈⲐⲂⲈⲪⲀⲒ ⲀⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲘⲞⲚⲒ ⲘⲘⲞⲒ ϦⲈⲚⲠⲒⲈⲢⲪⲈⲒ ⲚⲀⲨϬⲰⲚⲦ ⲈⲒⲚⲒ ⲚⲦⲞⲦⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ⲈⲦⲀⲒϬⲒ ⲆⲈ ⲚⲞⲨⲂⲞⲎⲐⲒⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲀⲒⲞϨⲒ ⲈⲢⲀⲦ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ ⲈⲒⲈⲢⲘⲈⲐⲢⲈ ⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲈⲘ ⲞⲨⲚⲒϢϮ ⲚϮϪⲈ ϨⲖⲒ ⲀⲚ ⲤⲀⲂⲞⲖ ⲚⲚⲎ ⲈⲦⲀ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϪⲞⲦⲞⲨ ⲚⲈⲘ ⲘⲰⲨⲤⲎⲤ ϪⲈ ⲤⲈⲚⲀϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ⲒⲤϪⲈ ⲞⲨⲢⲈϤϬⲒⲘⲔⲀϨ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲤϪⲈ ⲞⲨϨⲞⲨⲒⲦ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ϤⲚⲀϨⲒⲰⲒϢ ⲚⲞⲨⲰⲒⲚⲒ ⲘⲠⲒⲖⲀⲞⲤ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ⲚⲀⲒ ⲈϤϪⲰ ⲘⲘⲰⲞⲨ ⲠⲈϪⲈ ⲪⲎⲤⲦⲞⲤ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲤⲘⲎ ϪⲈ ⲀⲔⲖⲒⲂⲒ ⲠⲀⲨⲖⲈ Ⲁ- ⲠⲒⲘⲎϢ ⲚⲤϦⲀⲒ ⲐⲢⲈⲔⲖⲒⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϮⲖⲞⲂⲒ ⲀⲚ ⲔⲢⲀⲦⲒⲤⲐⲈ ⲪⲎⲤⲦⲈ ⲀⲖⲖⲀ ϨⲀⲚⲤⲀϪⲒ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲈⲘ ϮⲘⲈⲦⲈⲨⲤⲈⲂⲎⲤ ⲚⲎ ⲈϮϪⲰ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ϤⲤⲰⲞⲨⲚ ⲄⲀⲢ ⲚϪⲈⲠⲒⲔⲈⲞⲨⲢⲞ ⲈⲐⲂⲈ ⲚⲀⲒ ⲪⲀⲒ ⲈϮⲞⲨⲞⲚϨ ⲘⲘⲞⲒ ⲈⲂⲞⲖ ⲈⲒⲤⲀϪⲒ ⲚⲈⲘⲀϤ ⲠⲀϨⲎⲦ ⲄⲀⲢ ⲐⲎⲦ ϪⲈ ⲞⲨⲞⲚ ϨⲖⲒ ⲚⲚⲀⲒ ⲞⲂϢ ⲈⲢⲞϤ ⲀⲚ ⲚⲈⲦⲀ ⲪⲀⲒ ⲄⲀⲢ ⲀⲚ ϢⲰⲠⲒ ϦⲈⲚⲞⲨⲈⲖⲔⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ⲬⲚⲀϨϮ ⲠⲞⲨⲢⲞ ⲀⲄⲢⲒⲠⲠⲀⲤ ⲈⲚⲒⲠⲢⲞⲪⲎ ⲦⲎⲤ ϮⲤⲰⲞⲨⲚ ϪⲈ ⲬⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲠⲀⲨⲖⲞⲤ ϪⲈ ⲔⲈⲔⲞⲨϪⲒ ⲬⲚⲀⲐⲈⲦ ⲠⲀϨⲎⲦ ⲈⲀⲒⲦ ⲚⲬⲢⲎⲤⲦⲒⲀⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ⲠⲀⲨⲖⲞⲤ ⲆⲈ ⲠⲈϪⲀϤ ϪⲈ ϮⲦⲰⲂϨ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ϦⲈⲚⲞⲨⲔⲞⲨϪⲒ ⲚⲈⲘ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲞⲨ ⲘⲞⲚⲞⲚ ⲚⲐⲞⲔ ⲀⲖⲖⲀ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲤⲰⲦⲈⲘ ⲈⲢⲞⲒ ⲘⲪⲞⲞⲨ ⲈⲐⲢⲞⲨϢⲰⲠⲒ ⲘⲠⲀⲢⲎϮ ⲘⲠⲒⲢⲎϮ ⲈϮⲞⲒ ⲘⲘⲞϤ ϨⲰ ϢⲀⲦⲈⲚ ⲚⲀⲤⲚⲀⲨϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ⲀϤⲦⲰⲚϤ ⲆⲈ ⲚϪⲈⲠⲞⲨⲢⲞ ⲚⲈⲘ ⲠⲒϨⲎⲄⲈⲘⲰⲚ ⲚⲈⲘ ⲂⲈⲢⲚⲒⲔⲎ ⲚⲈⲘ ⲚⲎ ⲈⲦϨⲈⲘⲤⲒ ⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ⲞⲨⲞϨ ⲈⲦⲀⲨⲈⲢⲀⲚⲀⲬⲰⲢⲒⲚ ⲚⲀⲨⲤⲀϪⲒ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϤⲈⲢ ϨⲖⲒ ⲚϨⲰⲂ ⲀⲚ ⲚϪⲈⲠⲀⲒⲢⲰⲘⲒ ⲈϤⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ⲒⲈ ϨⲀⲚⲤⲚⲀⲨϨ. ");
INSERT INTO copbhc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ⲀⲄⲢⲒⲠⲠⲀⲤ ⲆⲈ ⲠⲈϪⲀϤ ⲘⲪⲎⲤⲦⲞⲤ ϪⲈ ⲚⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲠⲈ ⲈⲬⲀ ⲠⲀⲒⲢⲰⲘⲒ ⲈⲂⲞⲖ ⲈⲚⲈ ⲘⲠⲈϤⲈⲢⲈⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀⲨϮϨⲀⲠ ⲈⲐⲢⲈⲚⲈⲢϨⲰⲦ ⲈϮϨⲨⲦⲀⲖⲒⲀ ⲀϤϮ ⲘⲠⲀⲨⲖⲞⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲨⲤⲞⲚϨ ⲈⲦⲞⲦϤ ⲚⲞⲨⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬ ⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲒⲞⲨⲖⲒⲞⲤ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲠⲒⲢⲀ ⲚⲦⲈⲤⲀⲂⲀⲤⲦⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ⲀⲚⲀⲖⲎⲒ ⲆⲈ ⲈⲞⲨϪⲞⲒ ⲚⲀⲚⲆⲢⲀⲘⲀⲚⲦⲒⲚⲈⲞⲤ ⲈϤⲚⲀⲈⲢϨⲰⲦ ⲈⲚⲒⲘⲀ ⲚⲦⲈϮⲀⲤⲒⲀ ⲀⲚϪⲰⲞⲨⲚ ⲈⲂⲞⲖ ⲈϤⲚⲈⲘⲀⲚ ⲚϪⲈⲠⲒⲔⲈⲀⲢⲒⲤⲦⲀⲢⲬⲞⲤ ⲚⲦⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲠⲒⲢⲈⲘⲐⲈⲤⲤⲀⲖⲞⲚⲒⲔⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲀⲚⲒ ⲈⲦⲤⲨⲆⲰⲚ ⲀϤⲒⲢⲒ ⲆⲈ ⲚⲞⲨⲘⲈⲦⲘⲀⲒⲢⲰⲘⲒ ⲚⲈⲘ ⲠⲀⲨⲖⲞⲤ ⲚϪⲈⲒⲞⲨⲖⲒⲞⲤ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲀϤ ⲈⲐⲢⲈϤϢⲈ ϢⲀ ⲚⲈϤϢⲪⲎⲢ ⲚⲤⲈϤⲒ ⲠⲈϤⲢⲰⲞⲨϢ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ⲞⲨⲞϨ ⲈⲦⲀⲚϪⲰⲞⲨⲚ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲚⲈⲢϨⲰⲦ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲔⲨⲠⲢⲞⲤ ⲈⲐⲂⲈϪⲈ ⲚⲀⲢⲈ ⲠⲒⲐⲎⲞⲨ ϮⲈϦⲞⲨⲚ ⲈϨⲢⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ⲈⲦⲀⲚⲈⲢϨⲰⲦ ⲆⲈ ⲈⲂⲞⲖ ⲈⲠⲒⲠⲈⲖⲀⲄⲞⲤ ⲈⲦⲞⲨⲦⲰϤ ⲚⲔⲨⲠⲢⲞⲤ ⲚⲈⲘ ϮⲠⲀⲘⲪⲨⲖⲒⲀ ⲀⲚⲒ ⲈⲖⲨⲤⲦⲢⲀ ⲚⲦⲈϮⲔⲨⲖⲒⲔⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ⲞⲨⲞϨ ⲀⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ϪⲒⲘⲒ ⲚⲞⲨϪⲞⲒ ⲘⲘⲀⲨ ⲚⲦⲈⲢⲀⲔⲞϮ ⲈϤⲚⲀⲈⲢϨⲰⲦ ⲈϮϨⲨⲦⲀⲖⲒⲀ ⲀϤⲦⲀⲖⲞⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ⲈⲦⲀⲚⲰⲤⲔ ⲆⲈ ⲚⲈⲢϨⲰⲦ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲘⲞⲄⲒⲤ ⲈⲦⲀⲚⲒ ⲘⲠⲈⲘⲐⲞ ⲚⲬⲚⲒⲆⲞⲤ ⲚϤⲬⲰ ⲘⲘⲞⲚ ⲀⲚ ⲚϪⲈⲠⲒⲐⲎⲞⲨ ⲀⲚⲈⲢϨⲰⲦ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲔⲢⲎⲦⲎ ⲘⲠⲈⲘⲐⲞ ⲚⲤⲀⲖⲘⲞⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ⲘⲞⲄⲒⲤ ⲈⲦⲀⲚⲬⲀⲤ ⲚⲤⲰⲚ ⲀⲚⲒ ⲈⲨⲘⲀ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲚⲒⲖⲨⲘⲎⲚ ⲈⲐⲚⲀⲚⲈⲨ ⲚⲀⲤϦⲈⲚⲦ ⲆⲈ ⲈⲢⲰⲞⲨ ⲚϪⲈⲞⲨⲠⲞⲖⲒⲤ ϪⲈ ⲖⲀⲤⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ⲈⲦⲀϤⲤⲒⲚⲒ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲬⲢⲞⲚⲞⲤ ⲞⲨⲞϨ ϨⲎⲆⲎ ⲚⲈⲠⲤⲎⲞⲨ ⲀⲚ ϪⲈ ⲠⲈ ⲚⲈⲢⲠⲖⲈⲒⲚ ⲚⲈⲀ ⲠⲒϪⲞⲒ ⲄⲀⲢ ⲤⲰⲢⲈⲘ ⲠⲈ ⲈⲐⲂⲈ ϪⲈ ⲚⲈⲀ ϮⲔⲈⲚⲎⲤⲦⲒⲀ ⲤⲒⲚⲒ ⲠⲈ ⲚⲀϤϮⲚⲞⲘϮ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲚⲒⲢⲰⲘⲒ ϮⲚⲀⲨ ϪⲈ ⲞⲨⲞⲚ ⲞⲨϢⲰϢ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲚⲞⲤⲒ ⲚⲀϢⲰⲠⲒ ⲞⲨ ⲘⲞⲚⲞⲚ ⲘⲠⲒϪⲞⲒ ⲚⲈⲘ ⲠⲒⲀⲞⲨⲒⲚ ⲀⲖⲖⲀ ⲚⲈⲘ ⲚⲈⲚⲔⲈⲮⲨⲬⲎ ϦⲈⲚⲠⲀⲒϪⲒⲚⲈⲢϨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲚⲀϤⲐⲎⲦ ⲚϨⲎⲦ ⲚⲈⲘ ⲠⲒⲢⲈϤⲈⲢϨⲈⲘⲒ ⲚⲈⲘ ⲠⲒⲚⲀⲨⲔⲖⲎⲢⲞⲤ ⲈϨⲞⲦⲈ ⲚⲎ ⲈⲚⲀⲢⲈ ⲠⲀⲨⲖⲞⲤ ϪⲰ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ⲈⲚϤⲤⲘⲞⲚⲦ ⲆⲈ ⲀⲚ ⲚϪⲈⲠⲒⲖⲨⲘⲎⲚ ⲈⲐⲢⲈⲚⲈⲢⲠⲀⲢⲀⲬⲒⲘⲀⲌⲒⲚ ⲀⲠⲞⲨϨⲞⲨⲞ ⲒⲢⲒ ⲚⲞⲨⲤⲞϬⲚⲒ ⲈⲬⲀⲨ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ϪⲈ ⲀⲢⲎⲞⲨ ⲚⲤⲈϢϪⲞⲘϪⲈⲘ ⲚⲈⲢⲔⲀⲦⲀⲚⲦⲀⲚ ⲈⲪⲞⲒⲚⲒⲜ ⲈⲈⲢⲠⲀⲢⲀⲬ ⲒⲘⲀⲌⲒⲚ ϦⲈⲚⲞⲨⲖⲨⲘⲎⲚ ⲚⲦⲈϮⲔⲢⲎⲦⲎ ⲈϤⲤⲞⲘⲤ ⲈⲠⲒⲤⲀ ⲚⲈⲘⲈⲚⲦ ⲈⲞⲨⲘⲀ ⲚⲬⲰⲢⲀ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ⲈϤⲚⲒϤⲒ ⲆⲈ ⲚϪⲈⲞⲨⲐⲞⲨⲢⲎⲤ ⲚⲀⲨⲘⲈⲨⲒ ⲠⲈ ϪⲈ ⲤⲈⲚⲀϢⲦⲀϨⲈ ⲠⲒϢⲞⲢⲠ ⲚⲐⲰϢ ⲈⲦⲀⲨⲀⲒϤ ⲀⲨϪⲰⲞⲨⲚ ⲈⲂⲞⲖ ϦⲈⲚⲀⲤⲤⲰⲤ ⲀⲨⲬⲀ ϮⲔⲢⲎⲦⲎ ⲚⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ⲘⲠⲈⲤⲰⲤⲔ ⲆⲈ ⲀϤⲚⲒϤⲒ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲚ ⲚϪⲈⲞⲨⲐⲎⲞⲨ ⲈϤϬⲞⲤⲒ ⲪⲎ ⲈϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞϤ ϪⲈ ⲈⲨⲢⲀⲔⲨⲖⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ⲈⲦⲀϤϨⲰⲖⲈⲘ ⲆⲈ ⲘⲠⲒϪⲞⲒ ⲈⲦⲈⲘⲠⲞⲨϢϪⲈⲘϪⲞⲘ ⲚϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲘⲠⲒⲐⲎ ⲞⲨ ⲀⲚϮⲦⲞⲦⲈⲚ ⲀⲚⲤⲰⲔ ");
INSERT INTO copbhc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ⲈⲦⲀⲚⲪⲰⲦ ⲆⲈ ⲈⲞⲨⲚⲎⲤⲞⲤ ⲈⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲔⲖⲀⲨⲆⲀ ⲘⲞⲄⲒⲤ ⲀⲚϢϪⲈⲘϪⲞⲘ ⲈⲀⲘⲀϨⲒ ⲚϮϦⲈⲖⲘⲈϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ⲐⲀⲒ ⲈⲦⲀⲨⲞⲖⲤ ⲚⲀⲨⲈⲢⲂⲞⲎⲐⲒⲚ ⲈⲨⲘⲞⲨⲢ ⲘⲠⲒϪⲞⲒ ⲈⲨⲈⲢϨⲞϮ ⲆⲈ ⲘⲎⲠⲰⲤ ⲚⲤⲈϨⲈⲒ ⲈϦⲢⲎⲒ ⲈϮⲤⲒⲢⲦⲎⲤ ⲀⲚⲬⲰ ⲘⲠⲒⲤⲔⲈⲨⲞⲤ ⲈⲠⲈⲤⲎⲦ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀⲚⲖⲰⲒⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ⲈⲢⲈ ⲂⲞⲖ ⲆⲈ ⲪⲞⲚϨ ⲈⲢⲞⲚ ⲈⲘⲀϢⲰ ⲠⲈϤⲢⲀⲤϮ ⲆⲈ ⲚⲀⲨⲂⲞⲢⲂⲈⲢ ⲈⲂⲞⲖ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ⲞⲨⲞϨ ϦⲈⲚⲪⲘⲀϨ ⲄⲚⲈϨⲞⲞⲨ ⲀⲨϨⲒⲦⲞⲦⲞⲨ ⲚⲤⲀⲚⲒⲤⲔⲈⲨⲞⲤ ⲚⲦⲈⲠⲒϪⲞⲒ ⲀⲨⲤⲀⲦⲞⲨ ⲈⲂⲞⲖ ");
INSERT INTO copbhc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ⲈϤⲞⲨⲞⲚϨ ⲆⲈ ⲀⲚ ⲚϪⲈⲪⲢⲎ ⲚⲈⲘ ⲚⲒⲤⲒⲞⲨ ⲚⲞⲨⲘⲎϢ ⲚⲈϨⲞⲞⲨ ⲚⲞⲨⲔⲞⲨϪⲒ ⲘⲪⲰⲚϨ ⲀⲚ ⲠⲈ ⲈⲚⲀϤϢⲞⲠ ⲖⲞⲒⲠⲞⲚ ⲚⲈⲀⲤϢⲈ ⲚⲀⲤ ⲠⲈ ⲚϪⲈⲦⲈⲚϨⲈⲖⲠⲒⲤ ⲦⲎⲢⲤ ⲈⲐⲢⲈⲚⲞⲨϪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ⲤϢⲞⲠ ⲆⲈ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲘⲘⲈⲦⲀⲐⲞⲨⲰⲘ ⲦⲞⲦⲈ ⲀϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϦⲈⲚⲦⲞⲨⲘⲎϮ ⲠⲈϪⲀϤ ϪⲈ ⲚⲀⲤⲘⲠϢⲀ ⲘⲈⲚ ⲠⲈ ⲰⲚⲒⲢⲰⲘⲒ ⲈⲀⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲚⲤⲰⲒ ⲈϢⲦⲈⲘϪⲰⲞⲨⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲔⲢⲎⲦⲎ ⲚⲦⲈⲦⲈⲚϪⲈⲘ ϨⲎⲞⲨ ⲘⲠⲀⲒϢⲰϢ ⲚⲈⲘ ⲠⲀⲒⲞⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ⲞⲨⲞϨ ϮⲚⲞⲨ ⲞⲚ ϮϦⲰⲚϪ ⲈⲢⲰⲦⲈⲚ ⲰⲞⲨⲚϨⲎⲦ ⲞⲨⲮⲨⲬⲎ ⲄⲀⲢ ⲚⲞⲨⲰⲦ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ⲤⲚⲀⲦⲀⲔⲞ ⲀⲚ ⲈⲂⲎⲖ ⲈⲠⲒϪⲞⲒ ⲘⲘⲀⲨⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ⲀϤⲞϨⲒ ⲄⲀⲢ ⲈⲢⲀⲦϤ ⲚⲀϨⲢⲀⲒ ⲘⲠⲀⲒⲈϪⲰⲢϨ ⲚϪⲈⲞⲨⲀⲄⲄⲈⲖⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲈ ⲀⲚⲞⲔ ⲪⲰϤ ⲞⲨⲞϨ ϮϢⲈⲘϢⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢϨⲞϮ ⲠⲀⲨⲖⲈ ϨⲰϮ ⲚⲤⲈⲦⲀϨⲞⲔ ⲈⲢⲀⲦⲔ ⲚⲀϨⲢⲀϤ ⲘⲠⲞⲨⲢⲞ ⲞⲨⲞϨ ϨⲎⲠⲠⲈ ⲚⲎ ⲈⲦⲈⲢϨⲰⲦ ⲚⲈⲘⲀⲔ ⲦⲎⲢⲞⲨ ⲀⲒⲦⲎⲒⲦⲞⲨ ⲚⲀⲔ ⲚϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ⲈⲐⲂⲈⲪⲀⲒ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲚⲞϤ ⲚϨⲎⲦ ϮⲚⲀϨϮ ⲄⲀⲢ ⲈⲪⲚⲞⲨϮ ϪⲈ ⲤⲈⲚⲀϢⲰⲠⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀⲨⲤⲀϪⲒ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ϨⲰϮ ⲄⲀⲢ ⲚⲦⲈⲚⲒ ⲈϪⲈⲚ ⲞⲨⲚⲎⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ⲈⲦⲀ ⲒⲆ ⲆⲈ ⲚⲈϪⲰⲢϨ ϢⲰⲠⲒ ⲈⲚⲬⲎ ⲤⲀⲠⲒϨⲰⲒⲘⲒ ϦⲈⲚⲠⲒⲀⲚⲆⲢⲒⲀⲤ ϦⲈⲚⲦⲪⲀϢⲒ ⲆⲈ ⲘⲠⲒⲈϪⲰⲢϨ ⲚⲀⲨⲘⲈⲨⲒ ⲆⲈ ⲚϪⲈⲚⲒⲚⲈϤ ϪⲈ ⲀⲨϦⲰⲚⲦ ⲈϦⲞⲨⲚ ⲈⲞⲨⲬⲰⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲒϮ ⲈⲠⲈⲤⲎⲦ ⲚϮⲂⲞⲖⲒⲤ ⲀⲨϪⲈⲘ ⲔⲚϨϤⲞⲦ ⲘⲘⲰⲞⲨ ⲈⲦⲀⲨⲈⲢ ⲞⲨⲔⲞⲨϪⲒ ⲆⲈ ⲚⲞⲨⲰϢ ⲀⲨⲤⲒϮ ⲚϮⲂⲞⲖⲒⲤ ⲈⲠⲈⲤⲎⲦ ⲀⲨϪⲈⲘ ⲒⲈ ⲚϨϤⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ⲈⲚⲈⲢϨⲞϮ ⲆⲈ ⲘⲎⲠⲰⲤ ⲚⲦⲈⲚϨⲈⲒ ⲈϦⲢⲎⲒ ⲈϨⲀⲚⲘⲀ ⲈⲨⲚⲀϢⲦ ⲀⲨϨⲒ ⲆⲚⲀⲨϪⲀⲖ ⲤⲀⲪⲀϨⲞⲨ ⲘⲠⲒϪⲞⲒ ⲚⲀⲨⲦⲰⲂϨ ⲈⲐⲢⲈ ⲠⲒⲈϨⲞⲞⲨ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ⲈⲨⲔⲰϮ ⲆⲈ ⲚϪⲈⲚⲒⲚⲈϤ ⲚⲤⲈⲪⲰⲦ ⲈⲂⲞⲖ ϨⲀ ⲠⲒϪⲞⲒ ⲀⲨⲬⲰ ⲚϮⲤⲔⲀⲪⲎ ⲈϦⲢⲎⲒ ⲈⲪⲒⲞⲘ ϦⲈⲚⲞⲨⲖⲰⲒϪⲒ ϨⲰⲤ ϪⲈ ⲈⲨⲚⲀϨⲒⲞⲨⲒ ⲚϨⲀⲚⲀⲨϪⲀⲖ ⲈⲂⲞⲖ ⲤⲀⲦϨⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ⲠⲈϪⲈ ⲠⲀⲨⲖⲞⲤ ⲘⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲚⲈⲘ ⲚⲒⲘⲀⲦⲞⲒ ϪⲈ ⲈϢⲰⲠ ⲀⲢⲈϢⲦⲈⲘ ⲚⲀⲒ ⲞϨⲒ ϨⲒ ⲠⲒϪⲞⲒ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ⲦⲞⲦⲈ ⲚⲒⲘⲀⲦⲞⲒ ⲀⲨⲤⲰⲖⲠ ⲚⲚⲒⲚⲞϨ ⲚⲦⲈϮⲤⲔⲀⲪⲎ ⲀⲨⲬⲀⲤ ⲈⲐⲢⲈⲤϨⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ϢⲀⲦⲈ ⲠⲒⲈϨⲞⲞⲨ ϢⲰⲠⲒ ⲚⲀϤⲐⲰⲦ ⲘⲠⲞⲨϨⲎⲦ ⲦⲎⲢⲞⲨ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϨⲒⲚⲀ ⲚⲤⲈϬⲒ ⲚⲞⲨϦⲢⲈ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲒⲤ ⲒⲆ ⲚⲈϨⲞⲞⲨ ⲀⲢⲈⲦⲈⲚϪⲞⲔⲞⲨ ⲈⲂⲞⲖ ⲈⲢⲈⲦⲈⲚⲤⲞⲘⲤ ⲈⲂⲞⲖ ⲘⲠⲈⲦⲈⲚⲞⲨⲈⲘ ϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ⲈⲐⲂⲈⲪⲀⲒ ϮⲦⲰⲂϨ ⲘⲘⲰⲦⲈⲚ ⲈⲐⲢⲈⲦⲈⲦⲈⲚϬ ⲒⲚⲦⲈⲦⲈⲚϦⲢⲈ ⲪⲀⲒ ⲄⲀⲢ ϤϢⲞⲠ ⲚϢⲞⲢⲠ ⲈⲠⲈⲦⲈⲚⲞⲨϪⲀⲒ ⲞⲨϤⲰⲒ ⲄⲀⲢ ⲚⲦⲈⲦⲀⲪⲈ ⲚⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ϤⲚⲀⲦⲀⲔⲞ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ⲚⲀⲒ ⲆⲈ ⲈⲦⲀϤϪⲞⲦⲞⲨ ⲀϤϬⲒ ⲚⲞⲨⲰⲒⲔ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲘⲠⲈⲘⲐⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲈⲦⲀϤⲪⲀϢϤ ⲀϤⲈⲢϨⲎⲦⲤ ⲚⲞⲨⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ⲈⲦⲀ ⲠⲞⲨϨⲎⲦ ⲆⲈ ⲞⲨⲚⲞϤ ⲦⲎⲢⲞⲨ ⲚⲐⲰⲞⲨ ϨⲰⲞⲨ ⲀⲨϬⲒ ⲚⲦⲞⲨϦⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ⲚⲒⲮⲨⲬⲎ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲚⲀⲨϨⲒ ⲠⲒϪⲞⲒ ⲚⲀⲨⲈⲢ ⲤⲞ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ⲈⲦⲀⲨⲤⲒ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚϮϦⲢⲈ ⲚⲀⲨⲐⲢⲞ ⲘⲠⲒϪⲞⲒ ⲈⲀⲤⲒⲀⲒ ⲠⲈ ⲈⲨⲤⲒϮ ⲘⲠⲒⲤⲞⲨⲞ ⲈⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀ ⲠⲒⲈϨⲞⲞⲨ ϢⲰⲠⲒ ⲘⲠⲞⲨⲤⲞⲨⲈⲚ ⲠⲒⲔⲀϨⲒ ⲚⲀⲨϮ ⲆⲈ ⲚϨⲐⲎⲞⲨ ⲚⲞⲨⲔⲞⲖⲠⲤ ⲈⲞⲨⲞⲚ ⲞⲨⲬⲢⲞ ⲚϦⲎⲦϤ ⲚⲀⲨⲤⲞϬⲚⲒ ⲆⲈ ϪⲈ ⲀⲢⲎⲞⲨ ⲤⲈⲚⲀϢⲚⲞϨⲈⲘ ⲘⲠⲒϪⲞⲒ ⲈⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ⲞⲨⲞϨ ⲈⲦⲀⲨϤⲒ ⲚⲚⲒⲀⲨϪⲀⲖ ⲚⲀⲨⲬⲰ ⲘⲘⲰⲞⲨ ⲈϦⲢⲎⲒ ⲈⲪⲒⲞⲘ ⲀⲘⲀ ⲆⲈ ⲀⲨⲬⲀ ϪⲰⲞⲨ ⲚⲚⲒϨⲒⲎⲞⲨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀⲨⲤⲞⲤⲒ ⲘⲠⲒⲀⲢⲦⲈⲘⲰⲚ ⲘⲠⲒⲐⲎⲞⲨ ⲈⲐⲚⲒϤⲒ ⲀⲨⲘⲞⲚⲒ ⲈⲠⲒⲬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ⲈⲦⲀⲨϨⲈⲒ ⲆⲈ ⲈⲞⲨⲘⲀ ⲈϤⲞⲒ ⲚⲐⲀⲖⲀⲤⲤⲀ ⲤⲚⲞⲨϮ ⲀⲨϨⲈⲢϢ ⲠⲒϪⲞⲒ ⲈⲘⲀⲨ ⲞⲨⲞϨ ϨⲒⲦϨⲎ ⲘⲈⲚ ⲘⲘⲞϤ ⲀϤⲦⲀϪⲢⲞ ⲀϤⲞϨⲒ ⲚϤⲔⲒⲘ ⲀⲚ ⲪⲀϨⲞⲨ ⲆⲈ ⲘⲘⲞϤ ⲀϤⲂⲰⲖ ⲈⲂⲞⲖ ⲚⲦⲈⲚ ⲠϬⲒⲚϪⲞⲚⲤ ⲚⲦⲈⲚⲒϨⲰⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ⲀⲨⲒⲢⲒ ⲆⲈ ⲚⲞⲨⲤⲞϬⲚⲒ ⲚϪⲈⲚⲒⲘⲀⲦⲞⲒ ϨⲒⲚⲀ ⲚⲤⲈϦⲰⲦⲈⲂ ⲚⲚⲎ ⲈⲦⲤⲞⲚϨ ⲘⲎⲠⲰⲤ ⲚⲦⲈⲞⲨⲀⲒ ⲚⲎⲂⲒ ⲚⲦⲈϤⲪⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ⲠⲒⲈⲔⲀⲦⲞⲚⲦⲀⲢⲬⲞⲤ ⲆⲈ ⲈϤⲞⲨⲰϢ ⲈⲚⲞϨⲈⲘ ⲘⲠⲀⲨⲖⲞⲤ ⲀϤϢⲀϢⲦⲞⲨ ⲈϢⲦⲈⲘⲒⲢⲒ ⲘⲠⲞⲨⲤⲞϬⲚⲒ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲆⲈ ⲚⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲚⲤⲈϤⲒⲦⲞⲨ ⲈⲪⲒⲞⲘ ⲚⲤⲈⲚⲎⲂⲒ ⲚϢⲞⲢⲠ ⲈⲠⲒⲬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ⲞⲨⲞϨ ⲠⲔⲈⲤⲰϪⲠ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ϨⲒ ϨⲀⲚⲤⲀⲚⲒⲤ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ϨⲒ ϨⲀⲚⲔⲈⲈⲚⲬ ⲀⲒ ⲚⲦⲈⲠⲒϪⲞⲒ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀⲤϢⲰⲠⲒ ⲈⲐⲢⲈⲚⲚⲞϨⲈⲘ ⲦⲎⲢⲈⲚ ⲈⲠⲒⲬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ⲞⲨⲞϨ ⲈⲦⲀⲚⲚⲞϨⲈⲘ ⲦⲞⲦⲈ ⲀⲚⲈⲘⲒ ϪⲈ ϢⲀⲨⲘⲞⲨϮ ⲚϮⲚⲎⲤⲞⲤ ⲈⲦⲈⲘⲘⲀⲨ ϪⲈ ⲘⲈⲖⲒⲦⲒⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ⲚⲒⲂⲀⲢⲂⲀⲢⲞⲤ ⲆⲈ ⲚⲦⲈⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲀⲨⲒⲢⲒ ⲚⲞⲨⲘⲈⲦⲘⲀⲒⲢⲰⲘⲒ ⲚⲈⲘⲀⲚ ⲚⲞⲨⲔⲞⲨϪⲒ ⲀⲚ ⲈⲦⲀⲨϬⲈⲢⲈ ⲞⲨⲬⲢⲰⲘ ⲄⲀⲢ ⲀⲨϢⲞⲠⲦⲈⲚ ⲦⲎⲢⲈⲚ ⲈⲢⲰⲞⲨ ⲈⲐⲂⲈ ⲠⲒⲘⲞⲨⲚϨⲰⲞⲨ ⲈⲦⲈ ⲚⲀϤϢⲞⲠ ⲚⲈⲘ ⲈⲐⲂⲈ ⲠⲒⲰϪⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ⲀϤⲔⲞⲦϤ ⲆⲈ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲀϤϪⲒⲘⲒ ⲚⲞⲨⲘⲎϢ ⲚⲖⲈⲠϢ ⲞⲨⲞϨ ⲈⲦⲀϤϨⲒⲦⲞⲨ ⲈⲠⲒⲬⲢⲰⲘ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒϦⲘⲞⲘ ⲀⲤⲒ ⲈⲂⲞⲖ ⲚϪⲈⲞⲨⲀϪⲰ ⲀⲤϪⲈⲔϨ ⲦⲈϤϪⲒϪ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ⲈⲦⲀⲨⲚⲀⲨ ⲆⲈ ⲚϪⲈⲚⲒⲂⲀⲢⲂⲀⲢⲞⲤ ⲈⲠⲒⲐⲎ ⲢⲒⲞⲚ ⲈϤⲀϢⲒ ⲚⲤⲀⲦⲈϤϪⲒϪ ⲚⲀⲨϪⲰ ⲘⲘⲞⲤ ⲚⲚⲞⲨⲈⲢⲎⲞⲨ ϪⲈ ⲠⲀⲚⲦⲰⲤ ⲠⲀⲒⲢⲰⲘⲒ ⲞⲨⲢⲈϤϦⲰⲦⲈⲂ ⲠⲈ ⲪⲀⲒ ⲈⲦⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲈⲦⲀϤⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲪⲒⲞⲘ ⲘⲠⲈ ⲠⲈϤϨⲀⲠ ⲬⲀϤ ⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ⲚⲐⲞϤ ⲘⲈⲚ ⲞⲨⲚ ⲀϤⲚⲈϨ ⲠⲒⲐⲎⲢⲒⲞⲚ ⲈⲠⲒⲬⲢⲰⲘ ⲘⲠⲈ ϨⲖⲒ ⲘⲠⲈⲦϨⲰⲞⲨ ϢⲰⲠⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ⲚⲐⲰⲞⲨ ⲆⲈ ⲚⲀⲨⲘⲈⲨⲒ ϪⲈ ϤⲚⲀⲪⲰϪⲒ ⲒⲈ ϤⲚⲀϨⲈⲒ ⲤⲀⲦⲞⲦϤ ⲚⲦⲈϤⲘⲞⲨ ⲈⲦⲀⲨⲰⲤⲔ ⲆⲈ ⲈⲨⲤⲞⲘⲤ ⲈⲢⲞϤ ⲞⲨⲞϨ ⲈⲦⲀⲨⲚⲀⲨ ϪⲈ ⲘⲠⲈ ϨⲖⲒ ⲚϨⲰⲂ ⲈϤϨⲰⲞⲨ ⲦⲀϨⲞϤ ⲀⲨⲔⲞⲦⲞⲨ ⲤⲀⲦⲞⲦⲞⲨ ⲈⲨϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲚⲈⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲒⲞϨⲒ ϢⲞⲠ ⲚⲦⲈⲠⲒϨⲞⲨⲒⲦ ⲚⲦⲈϮⲚⲎⲤⲞⲤ ⲈⲠⲈϤⲢⲀⲚ ⲠⲈ ⲠⲞⲨⲠⲖⲒⲞⲤ ⲪⲀⲒ ⲈⲦⲀϤϬⲒⲦⲦⲈⲚ ⲈϨⲢⲎⲒ ⲀϤϢⲞⲠⲦⲈⲚ ⲈⲢⲞϤ ϦⲈⲚⲞⲨⲘⲈⲒ ⲘⲘⲈⲦϢⲀⲠϢⲈⲘⲘⲞ ⲚⲄ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲈⲦⲀ ⲪⲒⲰⲦ ⲘⲠⲞⲨⲠⲖⲒⲞⲤ ϢⲰⲠⲒ ϦⲈⲚϨⲀⲚϦⲘⲞⲘ ⲚⲈⲘ ϨⲀⲚϢⲀⲚⲘⲀϦⲦ ⲈϤϢⲦⲎⲞⲨⲦ ϦⲀⲢⲰⲞⲨ ⲪⲀⲒ ⲆⲈ ⲀⲠⲀⲨⲖⲞⲤ ϢⲈ ⲈϦⲞⲨⲚ ϢⲀⲢⲞϤ ⲀϤⲈⲢⲠⲢⲞⲤⲈⲨⲬⲈⲤⲐⲈ ⲀϤⲬⲀ ⲚⲈϤϪⲒϪ ϨⲒϪⲰϤ ⲀϤⲦⲀⲖϬⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ⲈⲦⲀ ⲪⲀⲒ ⲆⲈ ϢⲰⲠⲒ ⲠⲤⲰϪⲠ ⲈⲦϦⲈⲚ ϮⲚⲎⲤⲞⲤ ⲈⲦⲈ ⲞⲨⲞⲚ ϢⲰⲚⲒ ϢⲞⲠ ⲘⲘⲰⲞⲨ ⲚⲀⲨⲚⲎⲞⲨ ϢⲀⲢⲞϤ ⲞⲨⲞϨ ⲚⲀϤⲦⲀⲖϬⲞ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ⲚⲀⲒ ⲆⲈ ⲀⲨⲦⲀⲒⲞⲚ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚⲦⲀⲒⲞ ⲞⲨⲞϨ ⲈⲨⲚⲀⲈⲚⲦⲈⲚ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲨⲤⲈⲂⲦⲰⲦⲈⲚ ⲘⲠⲈⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ⲘⲈⲚⲈⲚⲤⲀ ⲄⲆⲈ ⲚⲀⲂⲞⲦ ⲀⲚⲒ ϨⲒ ⲞⲨϪⲞⲒ ⲚⲦⲈⲢⲀⲔⲞϮ ⲈⲢⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎⲒⲚⲒ ϨⲒⲰⲦϤ ⲚⲦⲈϨⲀⲚⲆⲒⲞⲤⲔⲞⲢⲞⲤ ⲈⲀϤⲈⲢⲠⲀⲢⲀⲬⲒⲘⲀⲌⲒⲚ ϦⲈⲚϮⲚⲎⲤⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ⲞⲨⲞϨ ⲀⲚⲘⲞⲚⲒ ⲈⲤⲒⲢⲀⲔⲞⲨⲤⲀⲤ ⲀⲚϢⲰⲠⲒ ⲘⲘⲀⲨ ⲚⲄ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ⲞⲨⲞϨ ⲈⲦⲀⲚⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲀⲚⲈⲢⲔⲀⲦⲀⲚⲦⲀⲚ ⲈⲢⲎⲄⲒⲞⲚ ⲞⲨⲞϨ ⲘⲈⲚⲈⲚⲤⲀ ⲞⲨⲈϨⲞⲞⲨ ⲀϤⲀⲘⲀϨⲒ ⲈϦⲞⲨⲚ ⲈϪⲰⲚ ⲚϪⲈⲞⲨⲐⲞⲨⲢⲎ ⲤⲀⲚⲒ ⲘⲠⲈⲚⲂ ⲈⲠⲞⲚⲦⲒⲞⲖⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ⲞⲨⲞϨ ⲈⲦⲀⲚϪⲒⲘⲒ ⲚⲚⲒⲤⲚⲎⲞⲨ ⲘⲘⲀⲨ ⲀⲨⲐⲈⲦ ⲠⲈⲚϨⲎⲦ ⲈⲐⲢⲈⲚϢⲰⲠⲒ ϦⲀⲦⲞⲦⲞⲨ ⲚⲌ ⲚⲈϨⲞⲞⲨ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀⲚⲒ ⲈⲢⲰⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ⲈⲦⲀⲨⲤⲰⲦⲈⲘ ⲆⲈ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲐⲂⲎⲦⲈⲚ ⲀⲨⲒ ⲈⲂⲞⲖ ⲈϨⲢⲀⲚ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲀⲠⲠⲒⲞⲪⲞⲢⲞⲨ ⲚⲄ ⲚⲦⲀⲂⲈⲢⲚⲰⲚ ⲈⲦⲀϤⲚⲀⲨ ⲆⲈ ⲈⲢⲰⲞⲨ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀϤϬⲒ ⲚⲞⲨⲘⲈⲦϪⲀⲢϨⲎ Ⲧ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ϨⲞⲦⲈ ⲆⲈ ⲈⲦⲀⲚϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰⲘⲎ ⲀϤⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲠⲀⲨⲖⲞⲤ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲘⲘⲀⲨⲀⲦϤ ⲚⲈⲘ ⲠⲒⲘⲀⲦⲞⲒ ⲈⲦⲀⲢⲈϨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ⲀⲤϢⲰⲠⲒ ⲆⲈ ⲘⲈⲚⲈⲚⲤⲀ ⲄⲚⲈϨⲞⲞⲨ ⲀϤⲘⲞⲨϮ ⲈⲚⲒϨⲞⲨⲀϮ ⲚⲦⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲈⲦϢⲞⲠ ⲘⲘⲀⲨ ⲈⲦⲀⲨⲒ ⲆⲈ ⲈⲘⲀⲨ ⲚⲀϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲀⲚⲞⲔ ⲚⲒⲢⲰⲘⲒ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲘⲠⲒⲈⲢϨⲖⲒ ⲈⲒϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀϤ ⲘⲠⲒⲖⲀⲞⲤ ⲒⲈ ⲚⲒⲤⲨⲚⲎⲐⲒⲀ ⲚⲦⲈⲚⲈⲚⲒⲞϮ ⲀⲨⲤⲞⲚϨⲦ ⲈⲂⲞⲖ ϦⲈⲚⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲀⲨⲦⲎⲒⲦ ⲈϦⲢⲎⲒ ⲈⲚⲈⲚϪⲒϪ ⲚⲚⲒⲢⲰⲘⲈⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ⲚⲀⲒ ⲈⲦⲀⲨϦⲈⲦϦⲰⲦ ⲚⲀⲨⲞⲨⲰϢ ⲈⲬⲀⲦ ⲈⲂⲞⲖ ⲠⲈ ϪⲈ ⲘⲠⲞⲨϪⲈⲘ ϨⲖⲒ ⲚⲈⲦⲒⲀ ⲚⲦⲈⲪⲘⲞⲨ ⲈϤϢⲞⲠ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ⲈⲨⲈⲢⲀⲚⲦⲒⲖⲈⲄⲒⲚ ⲆⲈ ⲚϪⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲤⲈⲢⲀⲚⲀⲄⲔⲎ ⲈⲢⲞⲒ ⲈⲈⲢⲈⲠⲒⲔⲀⲖⲒⲤⲐⲈ ⲘⲠⲞⲨⲢⲞ ⲘⲪⲢⲎϮ ⲀⲚ ϪⲈ ⲞⲨⲞⲚ ϨⲖⲒ ⲚⲔⲀⲦⲎⲄⲞⲢⲒⲀ ⲈⲒⲢⲒ ⲘⲠⲀϢⲖⲰⲖ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ⲈⲐⲂⲈ ⲦⲀⲒⲖⲰⲒϪⲒ ⲞⲨⲚ ⲚⲀⲒⲦⲰⲂϨ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲈⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲦϨⲈⲖⲠⲒⲤ ⲄⲀⲢ ⲘⲠⲒⲤⲖ ϮⲤⲞⲚϨ ⲚⲦⲀⲒϨⲀⲖⲨⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ⲚⲐⲰⲞⲨ ⲆⲈ ⲠⲈϪⲰⲞⲨ ⲚⲀϤ ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲆⲈ ⲘⲠⲈ ⲤϦⲀⲒ ⲒⲚⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲞⲨⲆⲈ ⲘⲠⲈϤⲒ ⲚϪⲈⲞⲨⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲤⲚⲎⲞⲨ ⲚⲦⲈϤⲦⲀⲘⲞⲚ ⲒⲈ ⲚⲦⲈϤϪⲈ ⲞⲨⲤⲀϪⲒ ⲈϤϨⲰⲞⲨ ϦⲀⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ⲦⲈⲚⲈⲢⲀⲜⲒⲞⲒⲚ ⲆⲈ ⲈⲤⲰⲦⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲔ ⲚⲚⲎ ⲈⲦⲈⲔⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ⲈⲐⲂⲈ ⲦⲀⲒϨⲈⲢⲈⲤⲒⲤ ⲄⲀⲢ ⲠⲒϨⲰⲂ ⲞⲨⲞⲚϨ ⲈⲢⲞⲚ ϪⲈ ⲤⲈⲈⲢⲀⲚⲦⲒⲖⲈⲄⲒⲚ ⲈⲐⲂⲎⲦⲤ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ⲀⲨϮⲚⲈⲒ ⲆⲈ ⲚⲀϤ ⲚⲞⲨⲈϨⲞⲞⲨ ⲀⲨⲒ ϢⲀⲢⲞϤ ⲈϮⲈⲜⲈⲚⲒⲀ ⲈⲨⲈⲢⲞⲨⲘⲎϢ ⲞⲨⲞϨ ⲀϤⲤⲀϪⲒ ϦⲀⲦⲞⲦⲞⲨ ⲈϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲰⲞⲨ ⲈⲐⲂⲈ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈϤⲐⲰⲦ ⲘⲠⲞⲨϨⲎⲦ ⲈⲐⲂⲈ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ϢⲀ ⲢⲞⲨϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ⲞⲨⲞϨ ϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲚⲀⲢⲈ ⲠⲞⲨϨⲎⲦ ⲐⲎⲦ ⲚⲈⲘ ⲚⲎ ⲈⲚⲀϤϪⲰ ⲘⲘⲰⲞⲨ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲚⲀⲨⲞⲒ ⲚⲀⲦⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ⲈⲨⲞⲒ ⲆⲈ ⲚⲀⲦϮⲘⲀϮ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎ ⲞⲨ ⲀϤⲬⲀⲨ ⲈⲂⲞⲖ ⲈϤϪⲰ ⲚⲞⲨⲤⲀϪⲒ ⲚⲞⲨⲰⲦ ⲚⲰⲞⲨ ⲚϪⲈⲠⲀⲨⲖⲞⲤ ϪⲈ ⲔⲀⲖⲰⲤ Ⲁ- ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲤⲀϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲎⲤⲀⲎⲀⲤ ⲠⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲒⲞϮ ");
INSERT INTO copbhc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲞϢⲒ ϢⲀ ⲠⲀⲒⲖⲀⲞⲤ ⲀϪⲞⲤ ⲚⲰⲞⲨ ϪⲈ ϦⲈⲚⲞⲨⲤⲘⲎ ⲈⲢⲈⲦⲈⲚⲈⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ⲚⲚⲈⲦⲈⲚⲔⲀϮ ϦⲈⲚⲞⲨⲚⲀⲨ ⲈⲢⲈⲦⲈⲚⲚⲀⲨ ⲞⲨⲞϨ ⲚⲚⲈⲦⲈⲚⲚⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ⲀϤⲞⲨⲘⲞⲦ ⲄⲀⲢ ⲚϪⲈⲠϨⲎⲦ ⲘⲠⲀⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲀⲨϨⲢⲰϢ ⲈⲠⲤⲰⲦⲈⲘ ϦⲈⲚⲚⲞⲨⲘⲀϢϪ ⲞⲨⲞϨ ⲀⲨⲘⲀϢⲐⲀⲘ ⲚⲚⲞⲨⲂⲀⲖ ⲘⲎⲠⲰⲤ ⲚⲤⲈⲚⲀⲨ ⲚⲚⲞⲨⲂⲀⲖ ⲞⲨⲞϨ ⲚⲤⲈⲤⲰⲦⲈⲘ ϦⲈⲚⲚⲞⲨⲘⲀϢϪ ⲞⲨⲞϨ ⲚⲤⲈⲔⲀϮ ϦⲈⲚⲠⲞⲨϨⲎ ⲦⲚⲤⲈⲔⲞⲦⲞⲨ ⲚⲦⲀⲦⲞⲨϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ⲘⲀⲢⲈ ⲠⲒϨⲰⲂ ⲞⲨⲞⲚϨ ⲈⲢⲰⲦⲈⲚ ϪⲈ ⲀⲪⲚⲞⲨϮ ⲦⲀⲞⲨⲞ ⲘⲠⲈϤⲤⲰⲦⲎⲢ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲚⲐⲰⲞⲨ ⲞⲚ ⲈⲐⲚⲀⲤⲰⲦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ⲀϤϢⲰⲠⲒ ⲆⲈ ⲚⲢⲞⲘⲠⲒ ⲤⲚⲞⲨϮ ⲦⲎⲢⲞⲨ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲀϤϬⲒⲦϤ ⲈⲠⲈϤϢϬⲞⲢ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲚⲀϤϢⲞⲠ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲎⲞⲨ ⲈϦⲞⲨⲚ ϢⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ⲈϤϨⲒⲰⲒϢ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈϤϮⲤⲂⲰ ϦⲈⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲂⲈ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ϢⲰϢⲦ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲪⲂⲰⲔ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦⲐⲀϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ⲪⲎ ⲈⲦⲀⲨⲐⲀϢϤ ⲈⲠⲒϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲰϢ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲈϤⲠⲢⲞⲪⲎⲦⲎⲤ ϦⲈⲚⲚⲒⲄⲢⲀⲪⲎ ⲈⲐⲞⲨⲀⲂ ");
INSERT INTO copbhc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ⲈⲐⲂⲈ ⲠⲈϤϢⲎⲢⲒ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠϪⲢⲞϪ ⲚⲆⲀⲨⲒⲆ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ⲠϢⲎⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲐⲎϢ ϦⲈⲚⲞⲨϪⲞⲘ ⲔⲀⲦⲀ ⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ⲈⲂⲞⲖ ϦⲈⲚⲠⲦⲰⲚϤ ⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ⲪⲎ ⲈⲦⲀⲚϬⲒ ⲚⲞⲨϨⲘⲞⲦ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲈⲘ ⲞⲨⲘⲈⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲦⲈⲪⲚⲀϨϮ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈϤⲢⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚϨⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ϨⲰⲦⲈⲚ ⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲢⲰⲘⲎ ⲚⲒⲘⲈⲚⲢⲀϮ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲐⲀϨⲈⲘ ⲈⲐⲞⲨⲀⲂ ⲠϨⲘⲞⲦ ⲚⲰⲦⲈⲚ ⲚⲈⲘ ⲦϨⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲠⲈⲚⲒⲰⲦ ⲚⲈⲘ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ⲚϢⲞⲢⲠ ⲘⲈⲚ ϮϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲠⲀⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲦⲎⲢⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϨϮ ⲤⲈϨⲒⲰⲒϢ ⲘⲘⲞϤ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ⲠⲀⲘⲈⲐⲢⲈ ⲄⲀⲢ ⲠⲈ ⲪⲚⲞⲨϮ ⲪⲎ ⲈϮϢⲈⲘϢⲒ ⲘⲘⲞϤ ϦⲈⲚⲠⲀⲠⲚⲈⲨⲘⲀϦⲈⲚⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲠⲈϤϢⲎⲢⲒ ϨⲰⲤ ⲚϮⲬⲰ ⲚⲦⲞⲦ ⲀⲚ ⲈⲒⲒⲢⲒ ⲘⲠⲈⲦⲈⲚⲘⲈⲨⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ϦⲈⲚⲚⲀⲠⲢⲞⲤⲈⲨⲬⲎ ⲈⲒⲦⲰⲂϨ ϪⲈ ⲀⲢⲎⲞⲨ ⲚⲦⲈⲠⲀⲘⲰⲒⲦ ⲤⲞⲂϮ ϦⲈⲚⲠⲒⲞⲨⲰϢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ϮⲞⲨⲰϢ ⲄⲀⲢ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲀϮ ⲚⲰⲦⲈⲚ ⲚⲞⲨϨⲘⲞⲦ ⲘⲠⲚⲀⲦⲒⲔⲞⲚ ⲈⲠϪⲒⲚⲦⲀϪⲢⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ⲈⲈⲢϢⲪⲎⲢ ⲚⲦⲀϪⲢⲞ ⲚϨⲎ ⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲀϨϮ ⲪⲎ ⲈⲦϢⲞⲠ ⲚϦⲎⲦⲈⲚ ⲚⲈⲘ ⲚⲈⲚⲈⲢⲎⲞⲨ ⲪⲰⲦⲈⲚ ⲚⲈⲘ ⲪⲰⲒ ϨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲒⲤ ⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ϮⲤⲞⲂϮ ⲘⲘⲞⲒ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲀⲨⲦⲀϨⲚⲞ ⲘⲘⲞⲒ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲀϬⲒ ⲚⲞⲨⲞⲨⲦⲀϨ ϦⲈⲚⲐⲎⲚⲞⲨ ϨⲰⲦⲈⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲘⲠⲤⲰϪⲠ ⲚⲚⲒⲔⲈⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲚⲈⲘ ⲚⲒⲂⲀⲢⲂⲀⲢⲞⲤ ⲚⲒⲤⲀⲂⲈⲨ ⲚⲈⲘ ⲚⲒⲀⲦϨⲎⲦ ⲞⲨⲞⲚ ⲈⲢⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ⲠⲀⲒⲢⲎϮ ⲠⲈ ⲠⲀⲢⲰⲞⲨⲦϤ ⲈⲦϢⲞⲠ ⲘⲘⲞⲒ ⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲢⲰⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ϮϢⲒⲠⲒ ⲄⲀⲢ ⲀⲚ ϦⲈⲚⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲞⲨϪⲞⲘ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ ⲈⲨⲚⲞϨⲈⲘ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲚϢⲞⲢⲠ ⲚⲈⲘ ⲠⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ⲞⲨⲘⲈⲐⲘⲎⲒ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈⲐⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲀϨϮ ⲈⲨⲚⲀϨϮ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲒⲐⲘⲎ ⲒϤⲚⲀⲰⲚϦ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ⲠⲒϪⲰⲚⲦ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ϤⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲘⲈⲦⲀⲤⲈⲂⲎⲤ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲐⲘⲈⲦϬⲒⲚϪⲞⲚⲤ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲚⲎ ⲈⲦⲀⲘⲞⲚⲒ ⲚϮⲘⲈⲐⲘⲎⲒ ϦⲈⲚϮⲘⲈⲦⲢⲈϤϬⲒⲚϪⲞⲚⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ϪⲈ ⲠⲒⲈⲘⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ⲚⲒⲀⲐⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲚⲦⲀϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲰⲚⲦ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲈϤⲐⲀⲘⲒⲞ ⲈⲨⲔⲀϮ ⲈⲢⲰⲞⲨ ⲤⲈⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲈⲦⲈ ⲦⲈϤϪⲞⲘ ⲚⲈⲚⲈϨ ⲦⲈ ⲚⲈⲘ ⲦⲈϤⲘⲈⲐⲚⲞⲨϮ ⲈⲠϪⲒⲚⲦⲞⲨϢⲰⲠⲒ ⲚⲀⲦⲖⲰⲒϪⲒ ⲚⲀⲦⲈⲢⲞⲨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ϪⲈ ⲈⲦⲀⲨⲤⲞⲨⲈⲚ ⲪⲚⲞⲨϮ ⲘⲠⲞⲨϮⲰⲞⲨ ⲚⲀϤ ϨⲰⲤ ⲚⲞⲨϮ ⲞⲨⲆⲈ ⲘⲠⲞⲨϢⲈⲠϨⲘⲞⲦ ⲚⲦⲞⲦϤ ⲀⲖⲖⲀ ⲀⲨⲈⲢⲈⲪⲖⲎⲞⲨ ϦⲈⲚⲚⲞⲨⲘⲞⲔⲘⲈⲔ ⲞⲨⲞϨ ⲀϤⲈⲢⲬⲀⲔⲒ ⲚϪⲈⲠⲞⲨⲀⲦⲔⲀϮ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ⲈⲨϪⲰ ⲘⲘⲞⲤ ϪⲈ ϨⲀⲚⲤⲀⲂⲈⲨ ⲚⲈⲀⲨⲈⲢⲤⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ⲞⲨⲞϨ ⲀⲨϢⲈⲂⲒⲈ ⲠⲒⲰⲞⲨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲈ ⲘⲠⲈϤⲦⲀⲔⲞ ϦⲈⲚⲞⲨⲒⲚⲒ ⲚⲦⲈⲞⲨϨⲒⲔⲰⲚ ⲚⲢⲰⲘⲒ ⲈϢⲀϤⲦⲀⲔⲞ ⲚⲈⲘ ϨⲀⲚϨⲀⲖⲀϮ ⲚⲈⲘ ϨⲀⲚⲦⲈⲂⲚⲰⲞⲨⲒ ⲚⲈⲘ ϨⲀⲚϬⲀⲦϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀϤⲦⲎⲒⲦⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϦⲢⲎⲒ ϦⲈⲚⲚⲒⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲦⲈⲠⲞⲨϨⲎⲦ ⲈⲠϬⲰϦⲈⲘ ⲈⲠϪⲒⲚⲐⲢⲞⲨϢⲰϢ ⲚϪⲈⲚⲞⲨⲤⲰⲘⲀ ⲚϦⲢⲎ ⲒⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ⲚⲎ ⲈⲦⲀⲨϢⲒⲂϮ ⲚϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚϮⲘⲈⲐⲚⲞⲨϪ ⲞⲨⲞϨ ⲀⲨⲞⲨⲰϢⲦ ⲞⲨⲞϨ ⲀⲨϢⲈⲘϢⲒ ⲘⲠⲒⲤⲰⲚⲦ ⲠⲀⲢⲀ ⲪⲎ ⲈⲦⲀϤⲤⲰⲚⲦ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ⲪⲎ ⲈⲦⲤⲘⲀⲢⲰⲞⲨⲦ ϢⲀ ⲚⲒⲈⲚⲈϨ ⲀⲘⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀϤⲦⲎⲒⲦⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϦⲢⲎ ⲒⲈϨⲀⲚⲠⲀⲐⲞⲤ ⲚϢⲰϢ ⲚⲞⲨϨⲒⲞⲘⲒ ⲄⲀⲢ ⲀⲨϢⲈⲂⲒⲈ ⲦⲞⲨⲪⲨⲤⲒⲔⲎ ⲚⲬⲢⲎⲤⲒⲤ ⲈϦⲢⲎⲒ ⲈⲨⲠⲀⲢⲀ ⲪⲨⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲒⲔⲈϨⲰⲞⲨⲦ ⲀⲨⲬⲰ ⲚⲤⲰⲞⲨ ⲚϮⲪⲨⲤⲒⲔⲎ ⲚⲬⲢⲎⲤⲒⲤ ⲚⲦⲈϮⲤϨⲒⲘⲒ ⲀⲨⲢⲰⲔϨ ϦⲈⲚⲠⲞⲨⲞⲨⲰϢ ⲈⲚⲞⲨⲈⲢⲎⲞⲨ ϨⲀⲚϨⲰⲞⲨⲦ ϦⲈⲚϨⲀⲚϨⲰⲞⲨⲦ ⲈⲨⲈⲢϨⲰⲂ ⲈⲠϢⲒⲠⲒ ⲈⲨⲈϬⲒ ⲈⲠϢⲈⲂⲒⲈ ⲂⲈⲬⲈ ⲈⲦⲤϢⲈ ⲚⲦⲈⲦⲞⲨⲠⲖⲀⲚⲎ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈ ⲘⲠⲞⲨⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲈⲬⲀ ⲪⲚⲞⲨϮ ⲚⲦⲞⲦⲞⲨ ϦⲈⲚⲞⲨⲈⲘⲒ ⲀϤⲦⲎⲒⲦⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϦⲢⲎⲒ ⲈⲞⲨϨⲎⲦ ⲚⲀⲆⲞⲔⲒⲘⲞⲤ ⲈⲐⲢⲞⲨⲒⲢⲒ ⲚⲚⲎ ⲈⲦⲤϢⲈ ⲚⲀⲒⲦⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ⲈⲨⲘⲈϨ ⲚⲀⲆⲒⲔⲒⲀ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲔⲀⲔⲒⲀ ⲚⲈⲘ ⲠⲞⲚⲎⲢⲒⲀ ⲚⲈⲘ ⲘⲈⲦϬⲒⲚϪⲞⲚⲤ ⲈⲨⲘⲈϨ ⲚⲪⲐⲞⲚⲞⲤ ϨⲒ ϦⲰⲦⲈⲂ ⲚⲈⲘ ϢϬⲚⲎⲚ ⲚⲈⲘ ⲬⲢⲞϤ ⲚⲈⲘ ⲘⲈⲨⲒ ⲈϤϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ⲈⲨⲞⲒ ⲚⲢⲈϤⲬⲀⲤⲔⲈⲤ ⲚⲢⲈϤⲈⲢⲔⲀⲦⲀⲖⲀⲖⲒⲚ ⲘⲘⲀⲤⲦⲈ ⲚⲞⲨϮ ⲚⲢⲈϤϮϢⲰϢ ⲚϬⲀⲤⲒϨⲎⲦ ⲚⲢⲈϤϨⲒⲠϨⲞ ⲚⲢⲈϤϪⲒⲘⲒ ⲚⲚⲒⲠⲈⲦϨⲰⲞⲨ ⲚⲀⲦⲤⲰⲦⲈⲘ ⲚⲤⲀⲚⲞⲨⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ⲚⲀⲦⲔⲀϮ ⲚⲀⲦϮⲘⲀϮ ⲚⲀⲦϢⲈⲚϨⲎⲦ ⲚⲀⲦⲚⲀⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ⲚⲎ ⲈⲦⲤⲰⲞⲨⲚ ⲚϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϪⲈ ⲚⲎ ⲈⲦⲒⲢⲒ ⲚⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲤⲈⲘⲠϢⲀ ⲘⲪⲘⲞⲨ ⲞⲨ ⲘⲞⲚⲞⲚ ϪⲈ ⲤⲈⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲀⲖⲖⲀ ⲤⲈϮⲘⲀϮ ⲞⲚ ⲚⲈⲘ ⲚⲎ ⲈⲦⲒⲢⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ⲈⲐⲂⲈ ⲪⲀⲒ ⲬⲚⲀϢⲈⲢⲞⲨⲰ ⲀⲚ ⲰⲪⲢⲰⲘⲒ ϦⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϮϨⲀⲠ ϦⲈⲚⲠⲒϨⲀⲠ ⲄⲀⲢ ⲈⲦⲈⲔϮ ⲘⲘⲞϤ ⲈⲠⲈⲔϢⲪⲎⲢ ⲀⲔϨⲒⲞⲨⲒ ⲘⲘⲞⲔ ⲈⲠϨⲀⲠ ⲘⲘⲀⲨⲀⲦⲔ ⲚⲀⲒ ⲄⲀⲢ ϨⲰⲔ ⲞⲚ ⲈⲦⲈⲔⲒⲢⲒ ⲘⲘⲰⲞⲨ ϦⲀ ⲪⲎ ⲈⲦϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ⲦⲈⲚⲈⲘⲒ ⲄⲀⲢ ϪⲈ ⲠⲒϨⲀⲠ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤϢⲞⲠ ⲔⲀⲦⲀ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲒⲢⲒ ⲚⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ⲬⲘⲈⲨⲒ ⲆⲈ ⲚⲐⲞⲔ ⲈⲪⲀⲒ ⲰⲪⲢⲰⲘⲒ ⲪⲎ ⲈⲦϮϨⲀⲠ ⲈⲚⲎ ⲈⲦⲒⲢⲒ ⲚⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲞϨ ⲬⲢⲀ ⲘⲘⲰⲞⲨ ϨⲰⲔ ⲞⲚ ϪⲈ ⲀⲚ ⲬⲚⲀϢⲪⲰⲦ ⲚⲐⲞⲔ ⲚⲦⲈⲚ ⲠⲒϨⲀⲠ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ϢⲀⲚ ⲔⲈⲢⲔⲀⲦⲀⲪⲢⲞⲚⲒⲚ ⲚϮⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲦⲈⲦⲈϤⲘⲈⲦⲬⲢⲤ ⲚⲈⲘ ⲦⲈϤⲘⲈⲦⲢⲈϤⲈⲢⲀⲚⲈⲬⲈⲤⲐⲈ ⲚⲈⲘ ⲦⲈϤⲘⲈⲦⲢⲈϤⲰⲞⲨ ⲚϨⲎⲦ ⲚⲔⲈⲘⲒ ⲀⲚ ϪⲈ ϮⲘⲈⲦⲬⲢⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲒⲚⲒ ⲘⲘⲞⲔ ⲈⲨⲘⲈⲦⲀⲚⲞⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ⲔⲀⲦⲀ ⲆⲈ ⲦⲈⲔⲘⲈⲦⲚⲀϢⲦϨⲎⲦ ⲚⲈⲘ ⲠⲈⲔϨⲎⲦ ⲚⲀⲦⲞⲨⲈⲘϨⲐⲎϤ ⲔϨⲒ ϪⲰⲚⲦ ⲚⲀⲔ ⲈϦⲞⲨⲚ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲠϪⲰⲚⲦ ⲚⲈⲘ ⲠⲒϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚⲦⲈⲠⲒϨⲀⲠ ⲘⲘⲎⲒ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ⲪⲎ ⲈⲐⲚⲀϮ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲚⲈϤϨⲂⲎⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ⲚⲎ ⲘⲈⲚ ⲈⲦⲀⲨⲀⲘⲞⲚⲒ ⲚⲦⲞⲦⲞⲨ ϦⲈⲚⲞⲨϨⲰⲂ ⲈⲚⲀⲚⲈϤ ⲞⲨⲰⲞⲨ ⲚⲈⲘ ⲞⲨⲦⲀⲒⲞ ⲚⲈⲘ ⲞⲨⲘⲈⲦⲀⲦⲦⲀⲔⲞ ⲚⲚⲎ ⲈⲦⲔⲰϮ ⲚⲤⲀⲞⲨⲰⲚϦ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ⲚⲎ ⲆⲈ ⲈⲦⲈ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϢϬⲚⲎⲚ ⲚⲈⲞⲨⲞϨ ⲚⲤⲈϮⲘⲀϮ ⲀⲚ ⲚⲈⲘ ⲐⲘⲎⲒ ⲈⲨⲐⲎⲦ ⲆⲈ ⲚϨⲎⲦ ⲚⲈⲘ ϮⲘⲈⲦϬⲒ ⲚϪⲞⲚⲤ ⲞⲨϪⲰⲚⲦ ⲚⲈⲘ ⲞⲨⲘⲂⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ⲞⲨϨⲞϪϨⲈϪ ⲚⲈⲘ ⲞⲨⲘⲔⲀϨ ⲈϪⲈⲚ ⲮⲨⲬⲎ ⲚⲒⲂⲈⲚ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲚⲎ ⲈⲦⲒⲢⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲚϢⲞⲢⲠ ⲚⲈⲘ ⲠⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ⲞⲨⲰⲞⲨ ⲆⲈ ⲚⲈⲘ ⲞⲨⲦⲀⲒⲞ ⲚⲈⲘ ⲞⲨϨⲒⲢⲎ ⲚⲎ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲢϨⲰⲂ ⲈⲠⲒⲀⲄⲀⲐⲞⲚ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲚϢⲞⲢⲠ ⲚⲈⲘ ⲠⲒⲞⲨⲈⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ⲘⲘⲞⲚ ⲘⲈⲦⲢⲈϤϬⲒϨⲞ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ⲚⲎ ⲄⲀⲢ ⲈⲦⲀⲨⲈⲢⲚⲞⲂⲒ ⲀⲚⲞⲘⲞⲤ ⲀⲚⲞⲘⲞⲤ ⲞⲚ ⲤⲈⲚⲀⲦⲀⲔⲰⲞⲨ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀⲨⲈⲢⲚⲞⲂⲒ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ⲞⲨ ⲄⲀⲢ ⲚⲒⲢⲈϤⲤⲰⲦⲈⲘ ⲈⲠⲒⲚⲞⲘⲞⲤ ⲀⲚ ⲚⲈⲚⲒⲐⲘⲎⲒ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲚⲎ ⲈⲦⲒⲢⲒ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲈⲦⲞⲨⲚⲀⲐⲘⲀⲒⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ⲈϢⲰⲠ ⲄⲀⲢ ⲚⲈⲚⲒⲈⲐⲚⲞⲤ ⲚⲎ ⲈⲦⲈ ⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲘⲞⲤ ⲘⲘⲀⲨ ⲪⲨⲤⲒⲤ ⲤⲈⲒⲢⲒ ⲚⲚⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲀⲒ ⲈⲦⲈ ⲘⲘⲞⲚⲦⲞⲨ ⲚⲞⲘⲞⲤ ⲘⲘⲀⲨ ⲤⲈⲞⲒ ⲚⲚⲞⲘⲞⲤ ⲚⲰⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ⲚⲀⲒ ⲈⲐⲞⲨⲰⲚϨ ⲘⲠⲒϨⲰⲂ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲈϤⲤϦⲎⲞⲨⲦ ϦⲈⲚⲠⲞⲨϨⲎⲦ ⲞⲨⲞϨ ⲈⲢⲈ ⲦⲞⲨⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲈⲢⲘⲈⲐⲢⲈ ⲈⲢⲰⲞⲨ ⲚⲈⲘⲰⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈ ⲚⲞⲨⲘⲈⲨⲒ ⲈⲢⲔⲀⲦⲎⲄⲞⲢⲒⲚ ⲞⲨⲦⲰⲞⲨ ⲚⲈⲘ ⲚⲞⲨⲈⲢⲎⲞⲨ ⲒⲈ ⲈⲨⲚⲀⲈⲢⲠⲔⲈⲀⲠⲞⲖⲞⲄⲒⲤⲐⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀϮϨⲀⲠ ⲈⲚⲎ ⲈⲦϨⲎⲠ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲔⲀⲦⲀ ⲠⲀⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲔϮⲢⲀⲚ ⲈⲢⲞⲔ ϪⲈ ⲒⲞⲨⲆⲀⲒ ⲔⲘⲞⲦⲈⲚ ⲘⲘⲞⲔ ⲈϪⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲞϨ ⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ϦⲈⲚⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ⲞⲨⲞϨ ⲔⲤⲰⲞⲨⲚ ⲘⲠⲈϤⲞⲨⲰϢ ⲞⲨⲞϨ ⲔⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲚⲚⲎ ⲈⲦⲤⲰⲦⲠ ⲔⲈⲢⲔⲀⲐⲎⲔⲒⲚ ⲘⲘⲞⲔ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ϨⲐⲎⲔ ⲬⲎ ⲈⲢⲞⲔ ϪⲈ ⲚⲐⲞⲔ ⲞⲨⲢⲈϤϬⲒⲘⲰⲒⲦ ⲚⲚⲒⲂⲈⲖⲖⲈⲨ ⲞⲨⲞⲨⲰⲒⲚⲒ ⲚⲦⲈⲚⲎ ⲈⲦϦⲈⲚ ⲠⲬⲀⲔⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ⲪⲢⲈϤϮⲤⲂⲰ ⲚⲦⲈⲚⲒⲀⲦϨⲎⲦ ⲞⲨⲞϨ ⲠⲤⲀϦ ⲚⲚⲒⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ ⲈⲢⲈ ⲐⲘⲞⲢⲪⲎ ⲚⲦⲈⲠⲈⲘⲒ ⲚⲦⲞⲦⲔ ⲚⲈⲘ ϮⲘⲈⲐⲘⲎⲒ ⲈⲦϦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ⲪⲎ ⲞⲨⲚ ⲈⲦϮⲤⲂⲰ ⲚⲔⲈⲞⲨⲀⲒ ⲔϮⲤⲂⲰ ⲚⲀⲔ ⲘⲘⲀⲨⲀⲦⲔ ⲀⲚ ⲪⲎ ⲈⲦϨⲒⲰⲒϢ ⲈϢⲦⲈⲘϬⲒⲞⲨⲒ ⲔϬⲒⲞⲨⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ⲪⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲠⲈⲢⲈⲢⲚⲰⲒⲔ ⲔⲞⲒ ⲚⲚⲰⲒⲔ ⲪⲎ ⲈⲦⲤⲰϤ ⲚⲚⲒⲒⲆⲰⲖⲞⲚ ⲔⲞⲒ ⲚⲔⲀⲖⲠ ⲈⲢⲪⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ⲪⲎ ⲈⲦϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲠⲀⲢⲀⲂⲀⲤⲒⲤ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲔϢⲰϢ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ⲪⲢⲀⲚ ⲄⲀⲢ ⲘⲪⲚⲞⲨϮ ⲤⲈϪⲈⲞⲨⲀ ⲈⲢⲞϤ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ⲞⲨⲞⲚ ϨⲎⲞⲨ ⲄⲀⲢ ⲘⲠⲒⲤⲈⲂⲒ ⲈϢⲰⲠ ⲀⲔϢⲀⲚⲒⲢⲒ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲈϢⲰⲠ ⲆⲈ ⲈⲔⲞⲒ ⲘⲠⲀⲢⲀⲂⲀⲦⲎ ⲤⲚⲦⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲀⲠⲈⲔⲤⲈⲂⲒ ⲀϤϢⲰⲠⲒ ⲈⲨⲘⲈⲦⲀⲦⲤⲈⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ⲈϢⲰⲠ ⲞⲨⲚ ⲀⲢⲈϢⲀⲚ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲀⲢⲈϨ ⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲬⲒ ⲦⲈϤⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲤⲈⲚⲀⲞⲠⲤ ⲈⲨⲤⲈⲂⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ⲞⲨⲞϨ ϮⲪⲨⲤⲒⲔⲎ ⲘⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲈⲤϪⲰⲔ ⲘⲠϨⲰⲂ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ⲤⲚⲀϮϨⲀⲠ ⲈⲢⲞⲔ ϦⲀ ⲠⲒⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲤϦⲀⲒ ⲚⲈⲘ ⲠⲒⲤⲈⲂⲒ ϪⲈ ⲀⲔⲈⲢ ⲞⲨⲠⲀⲢⲀⲂⲀⲦⲎ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ⲠⲒⲒⲞⲨⲆⲀⲒ ⲄⲀⲢ ⲀⲚ ⲈⲦϦⲈⲚ ⲠⲈⲐⲞⲨⲞⲚϨ ⲠⲈ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲆⲈ ⲠⲤⲈⲂⲒ ⲀⲚ ⲈⲐⲞⲨⲞⲚϨ ϦⲈⲚⲦⲤⲀⲢⲜ ⲠⲈ ⲠⲒⲤⲈⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ⲀⲖⲖⲀ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲈⲦϨⲎⲠ ⲪⲀⲒ ⲠⲈ ⲠⲒⲒⲞⲨⲆⲀⲒ ⲞⲨⲞϨ ⲠⲒⲤⲈⲂⲒ ⲚⲦⲈⲠⲒϨⲎⲦ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀϦⲈⲚⲞⲨⲤϦⲀⲒ ⲀⲚ ⲪⲎ ⲈⲦⲈ ⲠⲈϤϢⲞⲨϢⲞⲨ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲘⲒ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ⲞⲨ ϪⲈ ⲠⲈ ⲠϨⲞⲨⲞ ⲘⲠⲒⲒⲞⲨⲆⲀⲒ ⲒⲈ ⲀϢ ⲠⲈ ⲠϨⲎⲞⲨ ⲘⲠⲒⲤⲈⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ⲞⲨⲚⲒϢϮ ⲠⲈ ⲔⲀⲦⲀ ⲤⲀ ⲚⲢⲎϮ ⲚⲒⲂⲈⲚ ⲚϢⲞⲢⲠ ⲘⲈⲚ ϪⲈ ⲀⲨⲦⲈⲚϨⲞⲨⲦⲞⲨ ⲈⲚⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ⲞⲨ ⲄⲀⲢ ⲒⲤϪⲈ ⲀⲨⲈⲢⲀⲦⲚⲀϨϮ ⲚϪⲈϨⲀⲚⲞⲨⲞⲚ ⲘⲎ ⲦⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ ⲚⲀⲔⲈⲢϤ ⲠⲒⲚⲀϨϮ ⲚⲦⲈⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ⲚⲚⲈⲤϢⲰⲠⲒ ⲘⲀⲢⲈ ⲪⲚⲞⲨϮ ⲆⲈ ϢⲰⲠⲒ ⲚⲢⲈϤϪⲈⲘⲈⲐⲘⲎ ⲒⲞⲨⲞϨ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲚⲢⲈϤϪⲈⲘⲈⲐⲚⲞⲨϪ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϨⲞⲠⲰⲤ ⲚⲦⲈⲔⲘⲀⲒ ϦⲈⲚⲚⲈⲔⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲦⲈⲔϬⲢⲞ ⲈⲨⲚⲀϮ ϨⲀⲠ ⲈⲢⲞⲔ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ⲒⲤϪⲈ ⲦⲈⲚⲘⲈⲦϬⲒⲚϪⲞⲚⲤ ⲈⲐⲚⲀⲦⲀϨⲈ ϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲢⲀⲦⲤ ⲞⲨ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲘⲎ ⲞⲨⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲠⲈ ⲪⲚⲞⲨϮ ⲈϤⲚⲀⲒⲚⲒ ⲘⲠⲈϤϪⲰⲚⲦ ⲀⲒϪⲰ ⲘⲪⲀⲒ ϦⲈⲚⲞⲨⲘⲈⲦⲢⲰⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ⲚⲚⲈⲤϢⲰⲠⲒ ⲘⲘⲞⲚ ⲠⲰⲤ ⲪⲚⲞⲨϮ ⲚⲀϮϨⲀⲠ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ⲒⲤϪⲈ ⲆⲈ ϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲤⲈⲢϨⲞⲨⲞ ⲈⲠⲈϤⲰⲞⲨ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲀⲘⲈⲐⲚⲞⲨϪ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲤⲈϮϨⲀⲠ ⲈⲢⲞⲒ ϨⲰ ⲘⲪⲢⲎϮ ⲚⲞⲨⲢⲈϤⲈⲢⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲀⲚ ⲈⲦⲞⲨϪⲈⲞⲨⲀ ⲈⲢⲞⲚ ⲘⲘⲞϤ ⲘⲪⲢⲎϮ ⲈⲦⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ϪⲰ ⲘⲘⲞⲤ ⲈⲢⲞⲚ ϪⲈ ϢⲀⲚϪⲞⲤ ϪⲈ ⲘⲀⲢⲈⲚⲒⲢⲒ ⲚⲚⲒⲠⲈⲦϨⲰⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈⲒ ⲚⲀⲚ ⲚϪⲈⲚⲒⲠⲈⲐⲚⲀⲚⲈⲨ ⲚⲎ ⲈⲦⲈ ⲠⲞⲨϨⲀⲠ ⲬⲎ ϦⲀ ⲠϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ⲞⲨ ϪⲈ ⲞⲨⲞⲚ ϨⲞⲨⲞ ⲚⲦⲞⲦⲈⲚ ⲞⲨ ⲠⲀⲚⲦⲰⲤ ⲀⲚ ⲈⲢϢⲞⲢⲠ ⲚϪⲈⲘ ⲀⲢⲒⲔⲒ ⲈⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ϪⲈ ⲤⲈⲬⲎ ϦⲀ ⲪⲚⲞⲂⲒ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲐⲘⲎⲒ ⲘⲘⲀⲨⲀⲦϤ ");
INSERT INTO copbhc_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ⲘⲘⲞⲚ ⲠⲈⲦⲔⲀϮ ⲘⲘⲞⲚ ⲠⲈⲦϢⲒⲚⲒ ⲚⲤⲀⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ⲀⲨⲢⲒⲔⲒ ⲈⲂⲞⲖ ⲦⲎⲢⲞⲨ ⲀⲨⲈⲢⲀⲦϢⲀⲨ ⲈⲨⲤⲞⲠ ⲘⲘⲞⲚ ⲠⲈⲦⲒⲢⲒ ⲚⲞⲨⲘⲈⲦⲬⲢⲤ ⲘⲘⲞⲚ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ⲞⲨⲘϨⲀⲨ ⲈϤⲞⲨⲎⲚ ⲠⲈ ⲦⲞⲨϢⲂⲰⲂⲒ ⲀⲨⲈⲢⲬⲢⲞϤ ⲈⲂⲞⲖ ϦⲈⲚⲠⲞⲨⲖⲀⲤ ⲞⲨⲘⲀⲐⲞⲨⲒ ⲚϨⲞϤ ⲈⲦⲬⲎ ϦⲀ ⲚⲞⲨⲤⲪⲞⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ⲚⲀⲒ ⲈⲦⲈ ⲢⲰⲞⲨ ⲘⲈϨ ⲚⲤⲀϨⲞⲨⲒ ⲚⲈⲘ ϢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ⲤⲈⲒⲎⲤⲞⲨⲤ ⲚϪⲈⲚⲞⲨϬⲀⲖⲀⲨϪ ⲈⲪⲈⲚ ⲤⲚⲞϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ⲠϦⲞⲘϦⲈⲘ ⲚⲈⲘ ⲠⲦⲀⲖⲈⲠⲰⲢⲒⲀ ⲈⲦⲬⲎ ϨⲒ ⲚⲞⲨⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ⲞⲨⲞϨ ⲪⲘⲰⲒⲦ ⲚⲦⲈϮϨⲒⲢⲎⲚⲎ ⲘⲠⲞⲨⲤⲞⲨⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ϮϨⲞϮ ⲚⲦⲈⲪⲚⲞⲨϮ ⲬⲎ ⲘⲠⲈⲘⲐⲞ ⲚⲚⲞⲨⲂⲀⲖ ⲈⲂⲞⲖ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ⲦⲈⲚⲈⲘⲒ ⲆⲈ ϪⲈ ⲚⲎ ⲦⲎⲢⲞⲨ ⲈⲦⲈ ⲠⲒⲚⲞⲘⲞⲤ ϪⲰ ⲘⲘⲰⲞⲨ ⲀϤϪⲰ ⲘⲘⲰⲞⲨ ⲚⲚⲎ ⲈⲦϦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲢⲰϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲐⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲦⲎⲢϤ ϢⲰⲠⲒ ϦⲀ ⲠⲒϨⲀⲠ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲤⲀⲢⲜ ⲚⲀⲘⲀⲒ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ⲀⲠⲤⲞⲨⲈⲚ ⲪⲚⲞⲂⲒ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ϮⲚⲞⲨ ⲆⲈ ⲀⲦϬⲚⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲀϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲈⲨⲈⲢⲘⲈⲐⲢⲈ ϦⲀⲢⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ϮⲘⲈⲐⲘⲎⲒ ⲆⲈ ⲚⲦⲈⲪⲚⲞⲨϮ ϮⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲀϨϮ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϦⲈⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲘⲘⲞⲚ ⲪⲰⲢϪ ⲄⲀⲢ ϢⲞⲠ ");
INSERT INTO copbhc_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ⲀⲨⲈⲢⲚⲞⲂⲒ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲤⲈϢⲀⲦ ⲘⲠⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ⲈⲨⲐⲘⲀⲒⲞ ⲘⲘⲰⲞⲨ ⲚϪⲒⲚϪⲎ ϦⲈⲚⲠⲈϤϨⲘⲞⲦ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲤⲰϮ ⲪⲎ ⲈⲦϦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ⲪⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲬⲀϤ ⲚϪⲈⲪⲚⲞⲨϮ ⲚⲞⲨⲢⲈϤⲬ ⲰⲈⲂⲞⲖ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲀϨϮ ⲚϨⲢⲎ ⲒϦⲈⲚ ⲠⲈϤⲤⲚⲞϤ ⲈⲪⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈⲦⲈϤⲘⲈⲐⲘⲎⲒ ⲈⲐⲂⲈ ⲠⲬⲰ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒϢⲞⲢⲠ ⲚⲚⲞⲂⲒ ⲈⲦⲀⲨϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ϦⲈⲚ ϮⲘⲈⲦⲢⲈϤⲰⲞⲨ ⲚϨⲎⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲐⲢⲈⲤϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚϪⲈⲦⲈϤⲘⲈⲐⲘⲎⲒ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲤⲎⲞⲨ ⲚⲦⲈϮⲚⲞⲨ ϪⲈ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲐⲘⲎⲒ ⲞⲨⲞϨ ⲈϤⲐⲘⲀⲒⲞ ⲘⲠⲒⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ⲀϤⲐⲰⲚ ⲞⲨⲚ ⲠⲒϢⲞⲨϢⲞⲨ ⲀⲨⲘⲀϢⲐⲀⲘ ⲈⲢⲰϤ ϨⲒⲦⲈⲚ ⲀϢ ⲚⲚⲞⲘⲞⲤ ⲪⲀ ⲚⲒϨⲂⲎⲞⲨⲒ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ⲦⲈⲚⲚⲀⲈⲠ ⲞⲨⲢⲰⲘⲒ ⲄⲀⲢ ϪⲈ ϤⲚⲀⲘⲀⲒ ϦⲈⲚⲪⲚⲀϨϮ ⲀⲦϬⲚⲈ ⲚⲒϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ϢⲀⲚ ⲪⲚⲞⲨϮ ⲪⲀ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲠⲈ ⲞⲨⲞϨ ⲪⲀ ⲚⲒⲔⲈⲈⲐⲚⲞⲤ ⲚⲐⲰⲞⲨ ⲀⲚ ⲠⲈ ⲀϨⲀ ⲪⲀ ⲚⲒⲔⲈⲈⲐⲚⲞⲤ ϨⲰⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ⲒⲤϪⲈ ϨⲀⲢⲀ ⲞⲨⲀⲒ ⲠⲈ ⲪⲚⲞⲨϮ ⲪⲎ ⲈⲐⲚⲀⲐⲘⲀⲒⲈ ⲠⲤⲈⲂⲒ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ⲚⲈⲘ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ⲦⲈⲚⲚⲀⲔⲈⲢϤ ⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲀϨϮ ⲚⲚⲈⲤϢⲰⲠⲒ ⲀⲖⲖⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲦⲈⲚⲚⲀⲦⲀϨⲞ ⲘⲘⲞϤ ⲈⲢⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲈⲐⲂⲈ ⲀⲂⲢⲀⲀⲘ ϪⲈ ⲀⲨϪⲈⲘϤ ⲠⲈⲚϢⲞⲢⲠ ⲚⲒⲰⲦ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ⲒⲤϪⲈ ⲄⲀⲢ ⲀⲂⲢⲀⲀⲘ ⲀϤⲘⲀⲒ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲒⲈ ⲞⲨⲞⲚⲦⲈϤ ϢⲞⲨϢⲞⲨ ⲘⲘⲀⲨ ⲀⲖⲖⲀ ⲞⲨⲂⲈ ⲪⲚⲞⲨϮ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ⲞⲨ ⲄⲀⲢ ⲈⲦⲈ ϮⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞϤ ⲀⲂⲢⲀⲀⲘ ⲆⲈ ⲀϤⲚⲀϨϮ ⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲀⲨⲞⲠⲤ ⲚⲀϤ ⲈⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ⲪⲎ ⲈⲦⲈⲢϨⲰⲂ ⲘⲠⲀⲨⲈⲠ ⲠⲈϤⲂⲈⲬⲈ ⲚⲀϤ ⲔⲀⲦⲀ ⲞⲨϨⲘⲞⲦ ⲀⲖⲖⲀ ϪⲈ ϤⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ⲪⲎ ⲆⲈ ⲈⲦⲈⲚϤⲈⲢϨⲰⲂ ⲀⲚ ⲈϤⲚⲀϨϮ ⲆⲈ ⲈⲪⲎ ⲈⲦⲐⲘⲀⲒⲞ ⲘⲠⲒⲀⲤⲈⲂⲎⲤ ϢⲀⲨⲈⲠ ⲠⲈϤⲚⲀϨϮ ⲚⲀϤ ⲈⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰϤ ⲈⲦⲀ ⲆⲀⲨⲒⲆ ϪⲰ ⲘⲠⲒⲘⲀⲔⲀⲢⲒⲞⲤ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲪⲎ ⲈⲦⲈ ⲪⲚⲞⲨϮ ⲚⲀⲰⲠ ⲚϮⲘⲈⲐⲘⲎⲒ ⲚⲀϤ ⲀⲦϬⲚⲈ ϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ⲰⲞⲨⲚⲒⲀⲦⲞⲨ ⲚⲚⲎ ⲈⲦⲀⲨⲬⲰ ⲚⲚⲞⲨⲀⲚⲞⲘⲒⲀ ⲚⲰⲞⲨ ⲈⲂⲞⲖ ⲚⲈⲘ ⲚⲎ ⲈⲦⲀⲨϨⲰⲂⲤ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲚⲞⲨⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲦⲈ ⲠϬⲞⲒⲤ ⲚⲀⲈⲠ ⲚⲞⲂⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ⲠⲀⲒⲘⲀⲔⲀⲢⲒⲤⲘⲞⲤ ⲞⲨⲚ ⲀϤⲬⲎ ⲈϪⲈⲚ ⲠⲤⲈⲂⲒ ϢⲀⲚ ⲈϪⲈⲚ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲦⲈⲚϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲀⲨⲈⲠ ⲪⲚⲀϨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲚⲀϤ ⲈⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ⲠⲰⲤ ⲞⲨⲚ ⲀⲨⲞⲠϤ ⲈϤⲬⲎ ϦⲈⲚⲠⲤⲈⲂⲒ ϢⲀⲚ ⲈϤⲬⲎ ϦⲈⲚϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲈϤⲬⲎ ϦⲈⲚⲠⲤⲈⲂⲒ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ⲞⲨⲞϨ ⲀϤϬⲒ ⲚⲞⲨⲘⲎⲒⲚⲒ ⲚⲦⲈⲠⲤⲈⲂⲒ ⲞⲨⲤⲪⲢⲀⲄⲒⲤ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲀϨϮ ⲐⲎ ⲈⲦϦⲈⲚ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲚⲒⲰⲦ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲈⲠϪⲒⲚⲦⲞⲨⲰⲠ ⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ⲞⲨⲞϨ ⲚⲒⲰⲦ ⲚⲦⲈⲠⲤⲈⲂⲒ ⲚⲚⲒⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲈⲂⲒ ⲘⲘⲀⲨⲀⲦⲞⲨ ⲀⲚ ⲀⲖⲖⲀ ⲚⲈⲘ ⲚⲎ ⲈⲐⲘⲞϢⲒ ϨⲒ ⲚⲒϢⲈⲚⲦⲀⲦⲤⲒ ⲚⲦⲈⲪⲚⲀϨϮ ⲈⲦϦⲈⲚ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲚⲦⲈⲠⲈⲚⲒⲰⲦ ⲀⲂⲢⲀⲀⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ⲞⲨ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ⲀⲚ ⲀⲨϮ ⲘⲠⲒⲰϢ ⲚⲀⲂⲢⲀⲀⲘ ⲒⲈ ⲠⲈϤϪⲢⲞϪ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲘⲞⲤ ⲚⲈⲚⲒⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ϨⲀⲢⲀ ⲀϤϢⲰⲠⲒ ⲈϤϢⲞⲨⲒⲦ ⲚϪⲈⲠⲒⲚⲀϨϮ ⲞⲨⲞϨ ⲀϤⲔⲰⲢϤ ⲚϪⲈⲠⲒⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ⲪⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲀϤⲈⲢϨⲰⲂ ⲈⲨϪⲰⲚⲦ ⲪⲘⲀ ⲆⲈ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲞⲘⲞⲤ ⲘⲘⲀⲨ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲠⲀⲢⲀⲂⲀⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ⲈⲐⲂⲈ ⲪⲀⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲚⲀϨϮ ϨⲒⲚⲀ ⲔⲀⲦⲀ ⲞⲨϨⲘⲞⲦ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲚϪⲈⲠⲒⲰϢ ⲈϤⲦⲀϪⲢⲎⲞⲨⲦ ⲘⲠⲒϪⲢⲞϪ ⲦⲎⲢϤ ⲘⲪⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲀⲖⲖⲀ ⲚⲈⲘ ⲪⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ⲚⲀⲂⲢⲀⲀⲘ ⲈⲦⲈ ⲠⲈⲚⲒⲰⲦ ⲦⲎⲢⲈⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲀⲒⲬⲀⲔ ⲚⲒⲰⲦ ⲚⲞⲨⲘⲎϢ ⲚⲈⲐⲚⲞⲤ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲀϤⲚⲀϨϮ ⲈⲢⲞϤ ⲪⲎ ⲈⲦⲦⲀⲚϦⲞ ⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ⲈⲦⲐⲰϨⲈⲘ ⲚⲚⲎ ⲈⲦⲈ ⲚⲤⲈϢⲞⲠ ⲀⲚ ⲘⲪⲢⲎϮ ⲚⲈⲈⲨϢⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ⲪⲎ ⲈⲚⲀϤⲞⲒ ⲚⲀⲦϨⲈⲖⲠⲒⲤ ⲈⲨϨⲰⲂ ⲀϤⲚⲀϨϮ ⲈⲨϨⲈⲖⲠⲒⲤ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲚⲒⲰⲦ ⲚⲞⲨⲘⲎ ϢⲚⲈⲐⲚⲞⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨϪⲞⲤ ⲚⲀϤ ϪⲈ ⲈⲢⲈ ⲠⲈⲔϪⲢⲞϪ ⲈϤⲈϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ⲞⲨⲞϨ ⲈⲦⲈ ⲘⲠⲈϤϢⲰⲚⲒ ϦⲈⲚⲠⲒⲚⲀϨϮ ⲈⲀϤϮⲚⲒⲀⲦϤ ⲘⲠⲈϤⲤⲰⲘⲀ ⲀϤϪⲈⲘϤ ϨⲎⲆⲎ ⲀϤⲘⲞⲨ ⲀϤⲚϨⲢⲎⲒ ϦⲈⲚⲚⲀⲨ ⲢⲚⲢⲞⲘⲠⲒ ⲚⲈⲘ ϮⲔⲈⲘⲈⲦⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲦⲈⲐⲘⲈⲦⲢⲀ ⲚⲤⲀⲢⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ⲞⲨⲞϨ ⲈⲦⲈ ⲘⲠⲈϤⲈⲢϨⲎⲦ ⲂϦⲈⲚ ⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ ⲈⲠⲒⲰϢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲀϤϪⲈⲘϪⲞⲘ ϦⲈⲚⲠⲒⲚⲀϨϮ ⲈⲀϤϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ⲞⲨⲞϨ ⲀⲠⲈϤϨⲎⲦ ⲐⲎⲦ ϪⲈ ⲪⲎ ⲈⲦⲀϤⲰϢ ⲘⲘⲞϤ ⲚⲀϤⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲨⲞⲠⲤ ⲚⲀϤ ⲈⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ⲚⲈⲦⲀⲨⲤϦⲎⲞⲨⲦ ⲆⲈ ⲀⲚ ⲈⲐⲂⲎⲦϤ ⲘⲘⲀⲨⲀⲦϤ ϪⲈ ⲀⲨⲞⲠⲤ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ⲀⲖⲖⲀ ⲚⲈⲘ ⲈⲐⲂⲎⲦⲈⲚ ϨⲰⲚ ϦⲀ ⲚⲎ ⲈⲦⲀⲨⲞⲠⲤ ⲚⲰⲞⲨ ⲚⲎ ⲈⲐⲚⲀϨϮ ⲈⲪⲎ ⲈⲦⲀϤⲦⲞⲨⲚⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ⲪⲎ ⲈⲦⲀⲨⲦⲎⲒϤ ⲈⲐⲂⲈ ⲚⲈⲚⲚⲞⲂⲒ ⲞⲨⲞϨ ⲀϤⲦⲰⲚϤ ⲈⲐⲂⲈ ⲠⲈⲚⲐⲘⲀⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ⲈⲦⲀⲨⲐⲘⲀⲒⲞⲚ ⲞⲨⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲀϨϮ ⲘⲀⲢⲈⲚⲒⲢⲒ ⲚⲞⲨϨⲒⲢⲎⲚⲎ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ⲪⲎ ⲈⲦⲀ ⲠϪⲒⲚⲒ ⲈϦⲞⲨⲚ ϢⲰⲠⲒ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ϦⲈⲚⲪⲚⲀϨϮ ⲈⲠⲀⲒϨⲘⲞⲦ ⲪⲎ ⲈⲦⲈⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲚϦⲎⲦϤ ⲞⲨⲞϨ ⲈⲚϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ϦⲈⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲚⲦⲈⲠⲰⲞⲨ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲈⲚⲈⲢⲠⲔⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲒϨⲞϪϨⲈϪ ⲈⲚⲈⲘⲒ ϪⲈ ⲠⲒϨⲞϪϨⲈϪ ⲀϤⲈⲢϨⲰⲂ ⲈⲨϨⲨⲠⲞⲘⲞⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ϮϨⲨⲠⲞⲘⲞⲚⲎ ⲆⲈ ⲈⲨⲆⲞⲔⲒⲘⲎ ϮⲆⲞⲔⲒⲘⲎ ⲆⲈ ⲈⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ϮϨⲈⲖⲠⲒⲤ ⲆⲈ ⲘⲠⲀⲤϬⲒϢⲒⲠⲒ ϪⲈ ϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲤⲪⲰⲚ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲈⲚϨⲎⲦ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲈⲦⲀϤⲦⲎ ⲒϤ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲦⲒ ⲈⲚⲞⲒ ⲚⲀⲤⲐⲈⲚⲎⲤ ⲚⲞⲨⲤⲎ ⲞⲨ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲒⲀⲤⲈⲂⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ⲘⲞⲄⲒⲤ ⲄⲀⲢ ϢⲀⲦⲈ ⲞⲨⲀⲒ ⲘⲞⲨ ⲈϪⲈⲚ ⲞⲨⲐⲘⲎⲒ ⲦⲀⲬⲀ ⲄⲀⲢ ⲚⲦⲈⲞⲨⲀⲒ ⲈⲢⲦⲞⲖⲘⲀⲚ ⲈⲘⲞⲨ ⲈϪⲈⲚ ⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ϤⲦⲀϨⲞ ⲆⲈ ⲚⲦⲈϤⲀⲄⲀⲠⲎ ⲈϦⲞⲨⲚ ⲈⲢⲞⲚ ⲚϪⲈⲪⲚⲞⲨϮ ϪⲈ ⲈⲦⲒ ⲈⲚⲞⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲈⲦⲀⲨⲐⲘⲀⲒⲞⲚ ϮⲚⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈϤⲤⲚⲞϤ ⲈⲚⲈⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲤⲀⲂⲞⲖ ⲘⲠϪⲰⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲚⲞⲒ ⲚϪⲀϪⲒ ⲀⲚϨⲰⲦⲠ ⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲘⲞⲨ ⲚⲦⲈⲠⲈϤϢⲎⲢⲒ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲈⲦⲀⲚϨⲰⲦⲎ ⲈⲢⲞϤ ⲈⲚⲈⲚⲞϨⲈⲘ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲈϤⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲀⲚⲈⲢⲠⲔⲈϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚ ϦⲈⲚⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲀⲒ ⲈⲦⲀⲚϬⲒ ⲘⲠⲒϨⲰⲦⲠ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ⲈⲐⲂⲈ ⲪⲀⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲪⲚⲞⲂⲒ ⲒⲈϦⲞⲨⲚ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲞⲨⲰⲦ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲂⲒ ⲀⲪⲘⲞⲨ ϢⲰⲠⲒ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀⲠⲒⲘⲞⲨ ϢⲈ ⲈϦⲞⲨⲚ ⲈⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲪⲎ ⲈⲦⲀⲨⲈⲢⲚⲞⲂⲒ ⲚϦⲎ ⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ϢⲀ ⲪⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲚⲀⲢⲈ ⲪⲚⲞⲂⲒ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲪⲚⲞⲂⲒ ⲆⲈ ⲚⲀⲨⲰⲠ ⲘⲘⲞϤ ⲀⲚ ⲈⲘⲘⲞⲚ ⲚⲞⲘⲞⲤ ϢⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ⲀⲖⲖⲀ ⲪⲘⲞⲨ ⲀϤⲈⲢⲞⲨⲢⲞ ⲒⲤϪⲈⲚ ⲀⲆⲀⲘ ϢⲀ ⲘⲰⲨⲤⲎⲤ ⲚⲈⲘ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲈⲢⲚⲞⲂⲒ ϦⲈⲚⲠⲒⲚⲒ ⲚϮⲠⲀⲢⲀⲂⲀⲤⲒⲤ ⲚⲦⲈⲀⲆⲀⲘ ⲈⲦⲈ ⲠⲦⲨⲠⲞⲤ ⲚⲦⲈⲠⲈⲐⲚⲎⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲀⲚ ⲘⲠⲒⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲪⲀⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲘⲠⲒϨⲘⲞⲦ ⲒⲤϪⲈ ⲄⲀⲢ ϦⲈⲚⲠⲒⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲚⲦⲈⲞⲨⲀⲒ ⲀⲞⲨⲘⲎ ϢⲘⲞⲨ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ϮⲆⲰⲢⲈⲀ ϦⲈⲚⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲚⲞⲨⲰⲦ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲈⲢϨⲞⲨⲞ ⲈⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲀⲚ ⲈⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲀⲒ ⲈⲀϤⲈⲢⲚⲞⲂⲒ ⲠⲈ ⲠⲒⲦⲀⲒⲞ ⲠⲒϨⲀⲠ ⲘⲈⲚ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲀⲒ ⲠⲈ ⲈⲨⲔⲀⲦⲀⲔⲢⲒⲘⲀ ⲠⲒϨⲘⲞⲦ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲘⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲈⲨⲐⲘⲀⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲂⲒ ⲚⲦⲈⲠⲒⲞⲨⲀⲒ ⲀⲪⲘⲞⲨ ⲀϤⲈⲢⲞⲨⲢⲞ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲚⲎ ⲈⲐⲚⲀϬⲒ ⲘⲠⲒϨⲞⲨⲞ ⲚⲦⲈⲠⲒϨⲘⲞⲦ ⲚⲈⲘ ϮⲆⲰⲢⲈⲀ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲈⲨⲈⲈⲢⲞⲨⲢⲞ ϦⲈⲚⲞⲨⲰⲚϦ ϢⲀ ⲈⲚⲈϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲢⲰⲘⲒ ⲚⲞⲨⲰⲦ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ϨⲀⲢⲀ ⲞⲨⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲪⲚⲞⲂⲒ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲞⲨⲀⲒ ⲀϤⲒ ⲈϪⲈⲚ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲨϨⲒⲞⲨⲒ ⲘⲠϨⲀⲠ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲐⲘⲀⲒⲞ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲀⲒ ⲠⲈ ⲈϪⲈⲚ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲨⲐⲘⲀⲒⲞ ⲚⲦⲈⲠⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲘⲈⲦⲀⲦⲤⲰⲦⲈⲘ ⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲚⲞⲨⲰⲦ ⲀⲨϢⲰⲠⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚϪⲈⲚⲒⲘⲎϢ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲘⲈⲦⲢⲈϤⲤⲰⲦⲈⲘ ⲚⲦⲈⲠⲒⲞⲨⲀⲒ ⲤⲈⲚⲀϢⲰⲠⲒ ⲚⲐⲘⲎⲒ ⲚϪⲈⲚⲒⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ⲪⲚⲞⲘⲞⲤ ⲆⲈ ⲀϤⲒ ⲈϦⲞⲨⲚ ϨⲒⲚⲀ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲀϢⲀⲒ ⲪⲎ ⲆⲈ ⲈⲦⲀ ⲠⲈϤⲚⲞⲂⲒ ⲈⲢϨⲞⲨⲞ ⲀϤⲈⲢϨⲞⲨⲞ ⲀϢⲀⲒ ⲚⲀϤ ⲚϪⲈⲠⲒϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ϨⲒⲚⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲪⲚⲞⲂⲒ ⲈⲢⲞⲨⲢⲞ ϦⲈⲚⲪⲘⲞⲨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈϤⲈⲢⲞⲨⲢⲞ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲘⲈⲐⲘⲎⲒ ⲈⲨⲰⲚϦ ϢⲀ ⲈⲚⲈϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲦⲈⲚⲚⲀϢⲰⲠⲒ ϦⲈⲚⲪⲚⲞⲂⲒ ϨⲒⲚⲀ ⲚⲦⲈⲠⲒϨⲘⲞⲦ ⲈⲢϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ⲚⲚⲈⲤϢⲰⲠⲒ ⲚⲎ ⲈⲦⲀⲚⲘⲞⲨ ⲘⲪⲚⲞⲂⲒ ⲠⲰⲤ ⲞⲚ ⲦⲈⲚⲚⲀⲰⲚϦ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲚⲞⲚ ϦⲀ ⲚⲎ ⲈⲦⲀⲚϬⲒⲰⲘⲤ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲦⲀⲚϬⲒⲰⲘⲤ ⲈⲠⲈϤⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ⲀⲨⲔⲰⲤⲈⲚ ⲞⲨⲚ ⲚⲈⲘⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲰⲘⲤ ⲈⲠⲈϤⲘⲞⲨ ϨⲒⲚⲀ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲰⲞⲨ ⲘⲪⲒⲰⲦ ⲠⲀⲒⲢⲎϮ ⲀⲚⲞⲚ ϨⲰⲚ ⲚⲦⲈⲚⲘⲞϢⲒ ϦⲈⲚⲞⲨⲘⲈⲦⲂⲈⲢⲒ ⲚⲦⲈⲞⲨⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ⲒⲤϪⲈ ⲄⲀⲢ ⲀⲚⲈⲢϢⲪⲎⲢ ⲚⲦⲰϪⲒ ϦⲈⲚⲠⲤⲘⲞⲦ ⲚⲦⲈⲠⲈϤⲘⲞⲨ ⲀⲖⲖⲀ ⲈⲚⲈϢⲰⲠⲒ ⲞⲚ ⲈⲦⲈϤⲔⲈⲀⲚⲀⲤⲦⲀⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ⲈⲚⲈⲘⲒ ⲈⲪⲀⲒ ϪⲈ ⲠⲈⲚⲢⲰⲘⲒ ⲚⲀⲠⲀⲤ ⲀⲨⲀϢϤ ⲚⲈⲘⲀϤ ϨⲒⲚⲀ ⲚⲦⲈϤⲔⲰⲢϤ ⲚϪⲈⲠⲤⲰⲘⲀ ⲘⲪⲚⲞⲂⲒ ⲈϢⲦⲈⲘⲈⲢⲂⲰⲔ ⲘⲪⲚⲞⲂⲒ ϪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ⲪⲎ ⲄⲀⲢ ⲈⲦⲀϤⲘⲞⲨ ⲀϤⲘⲀⲒ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ⲒⲤϪⲈ ⲆⲈ ⲀⲚⲘⲞⲨ ⲚⲈⲘ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲈⲚⲚⲀϨϮ ϪⲈ ⲦⲈⲚⲚⲀⲰⲚϦ ⲚⲈⲘⲀϤ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ⲈⲚⲈⲘⲒ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ϤⲚⲀⲘⲞⲨ ⲀⲚ ϪⲈ ⲪⲘⲞⲨ ϪⲈ ⲚⲀⲈⲢϬⲞⲒⲤ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ⲪⲎ ⲄⲀⲢ ⲈⲦⲀϤⲘⲞⲨ ⲘⲘⲞϤ ⲀϤⲘⲞⲨ ⲈⲪⲚⲞⲂⲒ ⲚⲞⲨⲤⲞⲠ ⲪⲎ ⲆⲈ ⲈⲦⲈϤⲰⲚϦ ⲘⲘⲞϤ ϤⲰⲚϦ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ⲠⲀⲒⲢⲎϮ ϨⲰⲦⲈⲚ ⲘⲈⲨⲒ ⲈⲢⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲘⲰⲞⲨⲦ ⲈⲪⲚⲞⲂⲒ ⲈⲢⲈⲦⲈⲚⲰⲚϦ ⲆⲈ ⲘⲪⲚⲞⲨϮ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ⲘⲠⲈⲚⲐⲢⲈ ⲪⲚⲞⲂⲒ ⲞⲨⲚ ⲈⲢⲞⲨⲢⲞ ϦⲈⲚⲚⲈⲦⲈⲚⲤⲰⲘⲀ ⲈⲐⲚⲀⲘⲞⲨ ⲈⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲚⲤⲀⲚⲈϤⲈⲠⲒⲐⲨⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ⲞⲨⲆⲈ ⲘⲠⲈⲢⲦⲀϨⲈ ⲚⲈⲦⲈⲚⲘⲈⲖⲞⲤ ⲚϨⲞⲠⲖⲞⲚ ⲚⲦⲈϮⲀⲆⲒⲔⲒⲀ ⲘⲪⲚⲞⲂⲒ ⲀⲖⲖⲀ ⲘⲀⲦⲀϨⲈ ⲐⲎⲚⲞⲨ ⲘⲪⲚⲞⲨϮ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲞⲨⲞⲚ ⲈⲨⲞⲚϦ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲞⲨⲞϨ ⲚⲈⲦⲈⲚⲘⲈⲖⲞⲤ ⲚϨⲞⲠⲖⲞⲚ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ⲪⲚⲞⲂⲒ ⲄⲀⲢ ⲚⲀⲈⲢϬⲞⲒⲤ ⲈⲢⲰⲦⲈⲚ ⲀⲚ ⲚⲀⲢⲈⲦⲈⲚⲬⲎ ⲄⲀⲢ ϦⲀ ⲪⲚⲞⲘⲞⲤ ⲀⲚ ⲀⲖⲖⲀ ϦⲀ ⲠⲒϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ⲞⲨ ϪⲈ ⲚⲦⲈⲚⲈⲢⲚⲞⲂⲒ ϪⲈ ⲦⲈⲚⲬⲎ ϦⲀ ⲪⲚⲞⲘⲞⲤ ⲀⲚ ⲀⲖⲖⲀ ϦⲀ ⲠⲒϨⲘⲞⲦ ⲚⲚⲈⲤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲪⲎ ⲈⲦⲈⲦⲈⲚⲦⲀϨⲞ ⲘⲘⲰⲦⲈⲚ ⲘⲂⲰⲔ ⲚⲀϤ ⲈⲠⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲂⲰⲔ ⲚⲦⲈⲪⲎ ⲈⲦⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲚⲤⲰϤ ⲒⲦⲈ ⲪⲚⲞⲂⲒ ⲈⲨⲘⲞⲨ ⲒⲦⲈ ⲠⲤⲰⲦⲈⲘ ⲈϮⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ⲠϨⲘⲞⲦ ⲆⲈ ⲘⲪⲚⲞⲨϮ ϢⲎⲠ ϪⲈ ⲚⲀⲢⲈⲦⲈⲚⲞⲒ ⲘⲂⲰⲔ ⲘⲪⲚⲞⲂⲒ ⲠⲈ ⲀⲢⲈⲦⲈⲚⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲚϨⲎⲦ ⲈⲠⲒⲦⲨⲠⲞⲤ ⲚⲤⲂⲰ ⲪⲎ ⲈⲦⲀⲨϮ ⲐⲎⲚⲞⲨ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ⲀⲢⲈⲦⲈⲚⲈⲢⲢⲈⲘϨⲈ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲂⲒ ⲀⲢⲈⲦⲈⲚⲈⲢⲂⲰⲔ ⲆⲈ ⲚϮⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ⲞⲨⲘⲈⲦⲢⲰⲘⲒ ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲈⲐⲂⲈ ⲠϢⲰⲚⲒ ⲚⲦⲈⲦⲈⲚⲤⲀⲢⲜ ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲀϨⲈ ⲚⲈⲦⲈⲚⲘⲈⲖⲞⲤ ⲘⲂⲰⲔ ⲘⲠϬⲰϦⲈⲘ ⲚⲈⲘ ϮⲀⲚⲞⲘⲒⲀ ⲈϦⲢⲎⲒ ⲈϮⲀⲚⲞⲘⲒⲀ ⲠⲀⲒⲢⲎϮ ⲞⲚ ϮⲚⲞⲨ ⲘⲀⲦⲀϨⲈ ⲚⲈⲦⲈⲚⲘⲈⲖⲞⲤ ⲘⲂⲰⲔ ⲚϮⲘⲈⲐⲘⲎⲒ ⲈϨⲢⲎⲒ ⲈⲠⲦⲞⲨⲂⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ϨⲞⲦⲈ ⲄⲀⲢ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲘⲂⲰⲔ ⲘⲪⲚⲞⲂⲒ ⲚⲀⲢⲈⲦⲈⲚⲞⲒ ⲚⲢⲈⲘϨⲈ ⲠⲈ ⲚϮⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ⲞⲨ ϪⲈ ⲚⲞⲨⲦⲀϨ ⲈⲚⲀϤϢⲞⲠ ⲚⲰⲦⲈⲚ ⲘⲠⲒⲤⲎⲞⲨ ϦⲈⲚⲚⲎ ⲈⲦⲈⲦⲈⲚϬⲒϢⲒⲠⲒ ⲈϪⲰⲞⲨ ϮⲚⲞⲨ ⲦϦⲀⲈ ⲄⲀⲢ ⲚⲚⲎ ⲪⲘⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ϮⲚⲞⲨ ⲆⲈ ⲀⲢⲈⲦⲈⲚⲈⲢⲢⲈⲘϨⲈ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲂⲒ ⲀⲢⲈⲦⲈⲚⲈⲢⲂⲰⲔ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞⲚ ⲚⲦⲰⲦⲈⲚ ⲘⲘⲀⲨ ⲘⲠⲈⲦⲈⲚⲞⲨⲦⲀϨⲈ ⲈⲠⲦⲞⲨⲂⲞ ⲠϪⲰⲔ ⲆⲈ ⲞⲨⲰⲚϦ ϢⲀ ⲈⲚⲈϨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ⲚⲒⲞⲮⲰⲚⲒⲞⲚ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲪⲘⲞⲨ ⲠⲈ ⲠⲒϨⲘⲞⲦ ⲆⲈ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲰⲚϦ ϢⲀ ⲈⲚⲈϨ ⲠⲈ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ϢⲀⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲀⲒⲤⲀϪⲒ ⲄⲀⲢ ⲚⲈⲘ ⲚⲎ ⲈⲦⲤⲰⲞⲨⲚ ⲘⲠⲒⲚⲞⲘⲞⲤ ϪⲈ ⲠⲒⲚⲞⲘⲞⲤ ϤⲞⲒ ⲚϬⲞⲒⲤ ⲈⲠⲒⲢⲰⲘⲒ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲈϤⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ϮⲤϨⲒⲘⲒ ϦⲀ ϨⲀⲒ ⲄⲀⲢ ⲤⲤⲞⲚϨ ⲈⲠⲈⲤϨⲀⲒ ⲈⲦⲞⲚϦ ϦⲈⲚⲠⲒⲚⲞⲘⲞⲤ ⲈϢⲰⲠ ⲆⲈ ⲀϤⲘⲀⲚⲘⲞⲨ ⲚϪⲈⲠⲒϨⲀⲒ ⲀⲤⲔⲰⲢϤ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲘⲞⲤ ⲚⲦⲈⲠⲒϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ϨⲀⲢⲀ ⲞⲨⲚ ⲈϤⲞⲚϦ ⲚϪⲈⲠⲒϨⲀⲒ ϢⲀⲨⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲤϨⲒⲘⲒ ⲚⲚⲰⲒⲔ ⲀⲤϢⲀⲚϢⲰⲠⲒ ⲚⲈⲘ ⲔⲈϨⲀⲒ ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲘⲞⲨ ⲚϪⲈⲠⲒϨⲀⲒ ⲞⲨⲢⲈⲘϨⲎ ⲦⲈ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲘⲞⲤ ⲈϢⲦⲈⲘⲘⲞⲨϮ ⲈⲢⲞⲤ ϪⲈ ⲤϨⲒⲘⲒ ⲚⲚⲰⲒⲔ ⲀⲤϢⲀⲚϢⲰⲠⲒ ⲚⲈⲘ ⲔⲈϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ϨⲰⲤⲦⲈ ⲞⲨⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲀⲦⲈⲦⲈⲚⲘⲞⲨ ϨⲰⲦⲈⲚ ⲘⲪⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲤⲰⲘⲀ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲐⲢⲈⲦⲈⲚϢⲰⲠⲒ ⲚⲔⲈⲞⲨⲀⲒ ⲈⲦⲈ ⲪⲎ ⲠⲈ ⲈⲦⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϮⲞⲨⲦⲀϨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ⲈⲚϢⲞⲠ ⲄⲀⲢ ϦⲈⲚϮⲤⲀⲢⲜ ⲚⲀⲢⲈ ⲚⲒⲠⲀⲐⲞⲤ ⲚⲦⲈⲚⲒⲚⲞⲂⲒ ⲚⲒⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲀⲨⲈⲢϨⲰⲂ ϦⲈⲚⲚⲈⲚⲘⲈⲖⲞⲤ ⲈⲠϮⲞⲨⲦⲀϨ ⲘⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ϮⲚⲞⲨ ⲆⲈ ⲀⲚⲔⲰⲢϤ ⲈⲂⲞⲖ ϨⲀ ⲪⲚⲞⲘⲞⲤ ⲈⲀⲚⲘⲞⲨ ϦⲈⲚⲪⲎ ⲈⲚⲀⲨⲀⲘⲞⲚⲒ ⲘⲘⲞⲚ ⲚϦⲎⲦϤ ϨⲰⲤⲦⲈ ⲚⲦⲈⲚⲈⲢⲂⲰⲔ ϦⲈⲚⲞⲨⲘⲈⲦⲂⲈⲢⲒ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲞⲨⲞϨ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲠⲀⲤ ⲀⲚ ⲚⲦⲈⲞⲨⲤϦⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲪⲚⲞⲘⲞⲤ ⲪⲚⲞⲂⲒ ⲠⲈ ⲚⲚⲈⲤϢⲰⲠⲒ ⲀⲖⲖⲀ ⲪⲚⲞⲂⲒ ⲚⲈⲘⲠⲒⲤⲞⲨⲰⲚϤ ⲠⲈ ⲈⲂⲎⲖ ϪⲈ ⲀⲒⲤⲞⲨⲰⲚϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲚⲞⲘⲞⲤ ϮⲈⲠⲒⲐⲨⲘⲒⲀ ⲄⲀⲢ ⲚⲀⲒⲤⲰⲞⲨⲚ ⲘⲘⲞⲤ ⲀⲚ ⲠⲈ ⲈⲂⲎⲖ ϪⲈ ⲀⲪⲚⲞⲘⲞⲤ ϪⲞⲤ ⲚⲚⲈⲔⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ⲪⲚⲞⲂⲒ ⲆⲈ ⲈⲦⲀϤϬⲒ ⲚⲞⲨⲖⲰⲒϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲈⲚⲦⲞⲖⲎ ⲀϤⲈⲢϨⲰⲂ ⲈⲠⲒⲐⲨⲘⲒⲀ ⲚⲒⲂⲈⲚ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲀⲦϬⲚⲈ ⲪⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲪⲚⲞⲂⲒ ⲚⲀϤⲘⲰⲞⲨⲦ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ⲀⲚⲞⲔ ⲆⲈ ⲚⲀⲒⲰⲚϦ ⲚⲞⲨⲤⲎⲞⲨ ⲀⲦϬⲚⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲈⲦⲀⲤⲒ ⲆⲈ ⲈⲂⲞⲖ ⲚϪⲈϮⲈⲚⲦⲞⲖⲎ Ⲁ- ⲪⲚⲞⲂⲒ ⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ⲀⲚⲞⲔ ⲆⲈ ⲀⲒⲘⲞⲨ ⲞⲨⲞϨ ⲀⲨϪⲈⲘ ϮⲈⲚⲦⲞⲖⲎ ⲈⲦϬⲒ ⲚⲎⲒ ⲈⲠⲰⲚϦ ⲐⲀⲒ ⲀⲤϢⲰⲠⲒ ⲚⲎⲒ ⲈⲨⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ⲪⲚⲞⲂⲒ ⲄⲀⲢ ⲀϤϬⲒ ⲚⲞⲨⲖⲰⲒϪⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲈⲚⲦⲞⲖⲎ ⲀϤⲈⲢϨⲀⲖ ⲘⲘⲞⲒ ⲞⲨⲞϨ ⲀϤϦⲞⲐⲂⲈⲦ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ϨⲰⲤⲦⲈ ⲪⲚⲞⲘⲞⲤ ⲘⲈⲚ ϤⲞⲨⲀⲂ ⲞⲨⲞϨ ϮⲈⲚⲦⲞⲖⲎ ⲤⲞⲨⲀⲂ ⲞⲨⲞϨ ⲞⲨⲐⲘⲎⲒ ⲦⲈ ⲞⲨⲞϨ ⲚⲀⲚⲈⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲚ ⲀϤϢⲰⲠⲒ ⲚⲎⲒ ⲈⲨⲘⲞⲨ ⲚⲚⲈⲤϢⲰⲠⲒ ⲀⲖⲖⲀ ⲪⲚⲞⲂⲒ ⲠⲈ ϨⲒⲚⲀ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲦⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚϪⲈⲪⲚⲞⲂⲒ ⲈϤⲈⲢϨⲰⲂ ⲚⲎⲒ ⲈⲨⲘⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲪⲚⲞⲂⲒ ϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲢⲈϤⲈⲢⲚⲞⲂⲒ ⲚϨⲞⲨⲞ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲈⲚⲦⲞⲖⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲈⲚ ⲄⲀⲢ ϪⲈ ⲠⲒⲚⲞⲘⲞⲤ ⲞⲨⲠⲚⲀⲦⲒⲔⲞⲤ ⲠⲈ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲞⲨⲤⲀⲢⲔⲒⲔⲞⲤ ⲈⲀⲨⲦⲎⲒⲦ ⲈⲂⲞⲖ ϦⲀ ⲪⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ⲪⲎ ⲄⲀⲢ ⲈϮⲈⲢϨⲰⲂ ⲈⲢⲞϤ ⲚϮⲤⲰⲞⲨⲚ ⲘⲘⲞϤ ⲀⲚ ⲘⲪⲎ ⲄⲀⲢ ⲀⲚ ⲈϮⲞⲨⲀϢϤ ⲪⲀⲒ ⲠⲈϮⲢⲀ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲪⲎ ⲈϮⲘⲞⲤϮ ⲘⲘⲞϤ ⲠⲈϮⲢⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ⲒⲤϪⲈ ⲪⲎ ⲈⲦⲈ ⲚϮⲞⲨⲀϢϤ ⲀⲚ ⲪⲀⲒ ⲠⲈϮⲢⲀ ⲘⲘⲞϤ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲈⲘ ⲠⲒⲚⲞⲘⲞⲤ ϪⲈ ⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ϮⲚⲞⲨ ⲆⲈ ⲀⲚⲞⲔ ⲀⲚ ⲈⲦⲈⲢϨⲰⲂ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲪⲚⲞⲂⲒ ⲠⲈ ⲈⲦϢⲞⲠ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ϮⲤⲰⲞⲨⲚ ⲄⲀⲢ ϪⲈ ϤϢⲞⲠ ⲚϦⲎⲦ ⲀⲚ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϦⲈⲚⲦⲀⲤⲀⲢⲜ ⲚϪⲈⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲠⲒⲞⲨⲰϢ ⲄⲀⲢ ϤⲬⲎ ⲚⲀϨⲢⲀⲒ ⲈⲈⲢϨⲰⲂ ⲆⲈ ⲈⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲘⲘⲞⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ⲠⲈϮⲞⲨⲀϢϤ ⲄⲀⲢ ⲘⲠⲈⲐⲚⲀⲚⲈϤ ⲪⲀⲒ ⲠⲈϮⲢⲀ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲠⲈⲦⲈⲚϮⲞⲨⲀϢϤ ⲀⲚ ⲘⲠⲈⲦϨⲰⲞⲨ ⲚⲐⲞϤ ⲠⲈϮⲢⲀ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ⲒⲤϪⲈ ⲆⲈ ⲠⲈⲦⲈ ⲚϮⲞⲨⲀϢϤ ⲀⲚ ⲀⲚⲞⲔ ⲪⲀⲒ ϮⲢⲀ ⲘⲘⲞϤ ⲒⲈ ⲀⲚⲞⲔ ⲀⲚ ϪⲈ ⲈⲦⲈⲢϨⲰⲂ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲪⲚⲞⲂⲒ ⲠⲈ ⲈⲦϢⲞⲠ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ϮϪⲒⲘⲒ ϨⲀⲢⲀ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲪⲎ ⲈⲐⲞⲨⲰϢ ⲈⲒⲢⲒ ⲘⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲚⲈⲘⲎⲒ ϪⲈ ⲠⲒⲠⲈⲦϨⲰⲞⲨ ϤⲬⲎ ⲚⲀϨⲢⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ϮϮⲘⲀϮ ⲄⲀⲢ ⲚⲈⲘ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲔⲀⲦⲀ ⲠⲒⲢⲰⲘⲒ ⲈⲦⲤⲀϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ϮⲚⲀⲨ ⲆⲈ ⲈⲔⲈⲚⲞⲘⲞⲤ ϦⲈⲚⲚⲀⲘⲈⲖⲞⲤ ⲈϤϦⲎⲔ ⲞⲨⲂⲈ ⲪⲚⲞⲘⲞⲤ ⲚⲦⲈⲠⲀϨⲎⲦ ⲈϤⲈⲢⲈⲬ ⲘⲀⲖⲰⲦⲈⲨⲒⲚ ⲘⲘⲞⲒ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲪⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲚⲀⲘⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ⲠⲦⲀⲖⲈⲠⲰⲢⲞⲤ ⲀⲚⲞⲔ ⲪⲢⲰⲘⲒ ⲚⲒⲘ ⲈⲐⲚⲀϢⲚⲀϨⲘⲈⲦ ⲈⲂⲞⲖ ϨⲀ ⲠⲤⲰⲘⲀ ⲚⲦⲈⲠⲀⲒⲘⲞⲨ ⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ⲠϨⲘⲞⲦ ⲆⲈ ⲘⲪⲚⲞⲨϮ ϢⲎⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲀⲢⲀ ⲞⲨⲚ ⲀⲚⲞⲔ ϦⲈⲚⲠⲀϨⲎ ⲦⲘⲈⲚ ϮⲞⲒ ⲘⲂⲰⲔ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲦⲀⲤⲀⲢⲜ ⲆⲈ ϮⲞⲒ ⲘⲂⲰⲔ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ϨⲀⲢⲀ ⲞⲨⲚ ϮⲚⲞⲨ ⲘⲘⲞⲚ ϨⲖⲒ ⲚϨⲀⲠ ϬⲒ ⲈⲚⲎ ⲈⲦϦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ⲠⲒⲚⲞⲘⲞⲤ ⲄⲀⲢ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲰⲚϦ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲀϤⲀⲒⲦⲈⲚ ⲚⲢⲈⲘϨⲈ ⲈⲂⲞⲖ ϨⲀ ⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲚⲈⲘ ⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ϮⲘⲈⲦⲀⲦϪⲞⲘ ⲄⲀⲢ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ⲐⲎ ⲈⲚⲀϤϢⲰⲚⲒ ⲚϦⲎⲦⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲤⲀⲢⲜ Ⲁ- ⲪⲚⲞⲨϮ ⲦⲀⲞⲨⲞ ⲘⲠⲈϤϢⲎⲢⲒ ϦⲈⲚⲞⲨⲒⲚⲒ ⲚⲤⲀⲢⲜ ⲚⲦⲈⲪⲚⲞⲂⲒ ⲞⲨⲞϨ ⲈⲐⲂⲈ ⲪⲚⲞⲂⲒ ⲀϤϨⲒ ⲪⲚⲞⲂⲒ ⲈⲠϨⲀⲠ ϦⲈⲚⲦⲤⲀⲢⲜ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲐⲘⲀⲒⲞ ⲚⲦⲈⲠⲒⲚⲞⲘⲞⲤ ϪⲰⲔ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ϦⲀ ⲚⲎ ⲈⲦⲈⲚⲤⲈⲘⲞϢⲒ ⲀⲚ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲠⲚⲈⲨⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ⲚⲎ ⲈⲦϢⲞⲠ ⲄⲀⲢ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲚⲀⲦⲤⲀⲢⲜ ⲠⲈⲦⲞⲨⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ⲚⲈⲦⲘⲞϢⲒ ⲆⲈ ⲔⲀⲦⲀ ⲠⲚⲈⲨⲘⲀⲚⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲠⲈⲦⲞⲨⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ⲪⲘⲈⲨⲒ ⲄⲀⲢ ⲚⲦⲈϮⲤⲀⲢⲜ ⲪⲘⲞⲨ ⲠⲈ ⲪⲘⲈⲨⲒ ⲆⲈ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲠⲰⲚϦ ⲠⲈ ⲚⲈⲘ ϮϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ϪⲈ ⲪⲘⲈⲨⲒ ⲚⲦⲈϮⲤⲀⲢⲜ ⲞⲨⲘⲈⲦϪⲀϪⲒ ⲠⲈ ⲈⲪⲚⲞⲨϮ ⲘⲠⲀϤϬⲚⲈ ϪⲰϤ ⲄⲀⲢ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ⲚⲎ ⲆⲈ ⲈⲦϦⲈⲚ ⲦⲤⲀⲢⲜ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲢⲀⲚⲀϤ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲀⲢⲈⲦⲈⲚⲬⲎ ϦⲈⲚⲦⲤⲀⲢⲜ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲪⲎ ⲆⲈ ⲈⲦⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ϢⲞⲠ ⲚϦⲎⲦϤ ⲀⲚ ⲪⲀⲒ ⲈⲦⲈⲘⲘⲀⲨ ⲪⲰϤ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ⲒⲤϪⲈ ⲆⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ϦⲈⲚⲐⲎⲚⲞⲨ ⲠⲒⲤⲰⲘⲀ ⲘⲈⲚ ϤⲘⲰⲞⲨⲦ ⲈⲐⲂⲈ ⲪⲚⲞⲂⲒ ⲠⲒⲠⲚⲈⲨⲘⲀⲆⲈ ⲞⲨⲰⲚϦ ⲠⲈ ⲈⲐⲂⲈ ϮⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ⲒⲤϪⲈ ⲆⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲎ ⲈⲦⲀϤⲦⲞⲨⲚⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ϤϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲒⲈ ⲪⲎ ⲈⲦⲀϤⲦⲞⲨⲚⲞⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲈϤⲈⲦⲀⲚϦⲈ ⲚⲈⲦⲈⲚⲔⲈⲤⲰⲘⲀ ⲈⲦⲈϢⲀⲨⲘⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈϤⲠⲚⲈⲨⲘⲀⲈⲦϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ϨⲀⲢⲀ ⲞⲨⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲞⲨⲞⲚ ⲈⲢⲞⲚ ϦⲈⲚⲤⲀⲢⲜ ⲀⲚ ⲈⲐⲢⲈⲚⲰⲚϦ ⲔⲀⲦⲀ ⲤⲀⲢⲜ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲢⲈⲦⲈⲚⲞⲚϦ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲦⲈⲦⲈⲚⲚⲀⲘⲞⲨ ⲒⲤϪⲈ ⲆⲈ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲚⲒϨⲂⲎ ⲞⲨⲒ ⲚⲦⲈⲠⲒⲤⲰⲘⲀ ⲦⲈⲦⲈⲚϦⲰⲦⲈⲂ ⲘⲘⲰⲞⲨ ⲦⲈⲦⲈⲚⲚⲀⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ⲚⲎ ⲄⲀⲢ ⲈⲐⲘⲞϢⲒ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲒ ⲚⲈⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ⲚⲀⲢⲈⲦⲈⲚϬⲒ ⲄⲀⲢ ⲀⲚ ⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲞⲨⲘⲈⲦⲂⲰⲔ ⲈϦⲢⲎⲒ ⲞⲚ ⲈⲨϨⲞϮ ⲀⲖⲖⲀ ⲀⲢⲈⲦⲈⲚϬ ⲒⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲞⲨⲘⲈⲦϢⲎⲢⲒ ⲪⲀⲒ ⲈⲦⲈⲚⲰϢ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ ϪⲈ ⲀⲂⲂⲀ ⲪⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ⲞⲨⲞϨ ⲚⲐⲞϤ ⲠⲒⲠⲚⲈⲨⲘⲀϤⲈⲢⲘⲈⲐⲢⲈ ⲚⲈⲘ ⲠⲈⲚⲠⲚⲈⲨⲘⲀϪⲈ ⲀⲚⲞⲚ ϨⲀⲚϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ⲒⲤϪⲈ ⲆⲈ ⲀⲚⲞⲚ ϨⲀⲚϢⲎⲢⲒ ⲒⲈ ⲀⲚⲞⲚ ϨⲀⲚⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲞⲚ ϨⲀⲚⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲘⲈⲚ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲀⲚϢⲪⲎⲢ ⲚⲔⲖⲎⲢⲞⲚⲞⲘⲞⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲤϪⲈ ⲦⲈⲚϬⲒⲘⲔⲀϨ ⲚⲈⲘⲀϤ ϨⲒⲚⲀ ⲚⲦⲈⲚϬⲒⲰⲞⲨ ⲚⲈⲘⲀϤ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ϮⲘⲈⲨⲒ ⲄⲀⲢ ϪⲈ ⲤⲈⲘⲠϢⲀ ⲀⲚ ⲚϪⲈⲚⲒⲘⲔⲀⲨϨ ⲚⲦⲈⲠⲀⲒⲤⲎⲞⲨ ⲚⲦⲈϮⲚⲞⲨ ⲘⲠⲒⲰⲞⲨ ⲈⲐⲚⲀϬⲰⲢⲠ ⲚⲀⲚ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ⲠϢⲀⲤⲞⲘⲤ ⲄⲀⲢ ⲚⲦⲈⲠⲒⲤⲰⲚⲦ ⲀϤⲤⲞⲘⲤ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲒϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚⲦⲈⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ⲠⲒⲤⲰⲚⲦ ⲄⲀⲢ ⲀϤϬⲚⲈϪⲰϤ ⲚϮⲘⲈⲦⲈⲪⲖⲎ ⲞⲨ ⲚϤⲞⲨⲰϢ ⲀⲚ ⲀⲖⲖⲀ ⲈⲐⲂⲈ ⲪⲎ ⲈⲦⲀϤⲐⲢⲈϤϬⲚⲈϪⲰϤ ϦⲈⲚⲞⲨϨⲈⲖⲠⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ϪⲈ ⲚⲐⲞϤ ϨⲰϤ ⲠⲒⲤⲰⲚⲦ ϤⲚⲀⲈⲢⲢⲈⲘϨⲈ ⲈⲂⲞⲖ ϨⲀ ϮⲘⲈⲦⲂⲰⲔ ⲚⲦⲈⲠⲦⲀⲔⲞ ⲈϦⲢⲎⲒ ⲈϮⲘⲈⲦⲢⲈⲘϨⲈ ⲚⲦⲈⲠⲰⲞⲨ ⲚⲦⲈⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲈⲚ ⲄⲀⲢ ϪⲈ ⲠⲒⲤⲰⲚⲦ ⲦⲎⲢϤ ϤⲒⲀϨⲞⲘ ⲚⲈⲘⲀⲚ ⲞⲨⲞϨ ϤϮⲚⲀⲔϨⲒ ⲚⲈⲘⲀⲚ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲚⲈⲘ ⲀⲚⲞⲚ ϨⲰⲚ ⲈϮⲀⲠⲀⲢⲬⲎ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲞⲦⲈⲚ ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲦⲈⲚϤⲒⲀϨⲞⲘ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲚϮⲘⲈⲦϢⲎⲢⲒ ⲠⲒⲤⲰϮ ⲚⲦⲈⲠⲈⲚⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ⲈⲦⲀⲚⲚⲞϨⲈⲘ ⲄⲀⲢ ϦⲈⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲞⲨϨⲈⲖⲠⲒⲤ ⲆⲈ ⲈⲨⲚⲀⲨ ⲈⲢⲞⲤ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲀⲚ ⲦⲈ ⲪⲎ ⲄⲀⲢ ⲈϢⲀⲢⲈ ⲞⲨⲀⲒ ⲚⲀⲨ ⲈⲢⲞϤ ϢⲀϤⲈⲢϨⲨⲠⲞⲘⲞⲚⲒⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ⲒⲤϪⲈ ⲆⲈ ⲪⲎ ⲈⲦⲈⲚⲚⲀⲨ ⲈⲢⲞϤ ⲀⲚ ⲦⲈⲚⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲢⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨϨⲨⲠⲞⲘⲞⲚⲎ ⲦⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲞⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲀϤϮⲦⲞⲦⲤ ⲚⲦⲈⲚⲘⲈⲦϪⲰⲂ ⲞⲨ ⲄⲀⲢ ⲚⲦⲰⲂϨ ⲈⲦⲈⲚⲚⲀⲀⲒϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϢⲈ ⲚⲦⲈⲚⲈⲘⲒ ⲀⲚ ⲀⲖⲖⲀ ⲚⲐⲞϤ ⲠⲒⲠⲚⲈⲨⲘⲀϤⲈⲢϨⲞⲨⲞ ⲤⲈⲘⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ϦⲈⲚϨⲀⲚϤⲒⲀϨⲞⲘ ⲚⲀⲦⲤⲀϪⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ⲪⲎ ⲆⲈ ⲈⲦϦⲞⲦϦⲈⲦ ⲚⲚⲒϨⲎⲦ ϤⲤⲰⲞⲨⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲘⲈⲨⲒ ⲘⲠⲒⲠⲚⲈⲨⲘⲀϪⲈ ⲀϤⲤⲈⲘⲒ ⲈⲪⲚⲞⲨϮ ⲈϪⲈⲚ ⲪⲎ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ⲦⲈⲚⲤⲰⲞⲨⲚ ⲆⲈ ϪⲈ ⲚⲎ ⲈⲦⲈⲢⲀⲄⲀⲠⲀⲚ ⲘⲪⲚⲞⲨϮ ϢⲀϤⲈⲢϨⲰⲂ ⲚⲈⲘⲰⲞⲨ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲚⲈⲨ ⲚⲎ ⲈⲦⲀϤⲐⲀϨⲘⲞⲨ ⲔⲀⲦⲀ ⲠⲈϤϢⲞⲢⲠ ⲚⲐⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ϪⲈ ⲚⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲤⲞⲨⲰⲚⲞⲨ ⲚⲀⲒ ⲞⲚ ⲀϤⲈⲢϢⲞⲢⲠ ⲚⲐⲀϢⲞⲨ ⲚϢⲪⲎⲢ ⲚⲤⲘⲞⲦ ⲚⲦⲈⲦϨⲒⲔⲰⲚ ⲘⲠⲈϤϢⲎⲢⲒ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲈϤⲞⲒ ⲚϢⲞⲢⲠ ⲘⲘⲒⲤⲒ ⲚⲞⲨⲘⲎϢ ⲚⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ⲚⲎ ⲆⲈ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲐⲀϢⲞⲨ ⲚⲀⲒ ⲞⲚ ⲚⲎ ⲈⲦⲀϤⲐⲀϨⲘⲞⲨ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀϤⲐⲀϨⲘⲞⲨ ⲚⲀⲒ ⲞⲚ ⲀϤⲐⲘⲀⲒⲰⲞⲨ ⲚⲎ ⲆⲈ ⲈⲦⲀϤⲐⲘⲀⲒⲰⲞⲨ ⲚⲀⲒ ⲞⲚ ⲀϤϮⲰⲞⲨ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲞⲨⲂⲈ ⲚⲀⲒ ⲒⲤϪⲈ ⲪⲚⲞⲨϮ ⲠⲈⲦϮ ⲈϪⲰⲚ ⲚⲒⲘ ⲈⲐⲚⲀϢϮ ⲞⲨⲂⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ⲪⲎ ⲈⲦⲈⲘⲠⲈϤϮⲀⲤⲞ ⲈⲠⲈϤϢⲎⲢⲒ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲀϤⲦⲎⲒϤ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ⲦⲎⲢⲈⲚ ⲠⲰⲤ ϪⲈ ⲚⲚⲈϤϮ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲚⲀⲚ ⲚϨⲘⲞⲦ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ⲚⲒⲘ ⲈⲐⲚⲀϢⲤⲈⲘⲒ ⲈⲚⲒⲤⲰⲦⲠ ⲚⲦⲈⲪⲚⲞⲨϮ ⲪⲚⲞⲨϮ ⲠⲈⲦⲐⲘⲀⲒⲞ ");
INSERT INTO copbhc_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ⲚⲒⲘ ⲈⲐⲚⲀϢϨⲒⲞⲨⲒ ⲘⲠϨⲀⲠ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈ ⲈⲦⲀϤⲘⲞⲨ ⲘⲀⲖⲖⲞⲚ ⲆⲈ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲪⲎ ⲈⲦⲬⲎ ⲤⲀⲞⲨⲒⲚⲀⲘ ⲘⲪⲚⲞⲨϮ ⲚⲐⲞϤ ⲈⲦⲤⲈⲘⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ⲚⲒⲘ ⲈⲐⲚⲀϢⲪⲞⲢϪⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲚϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨϨⲞϪϨⲈϪ ⲠⲈ ⲒⲈ ⲞⲨⲦⲀⲦϨⲞ ⲒⲈ ⲞⲨⲆⲒⲰⲄⲘⲞⲤ ⲒⲈ ⲞⲨϨⲔⲞ ⲒⲈ ⲞⲨⲂⲰϢ ⲒⲈ ⲞⲨⲔⲨⲚⲆⲒⲚⲞⲤ ⲒⲈ ⲞⲨⲤⲎϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲈⲐⲂⲎⲦⲔ ⲤⲈϦⲰⲦⲈⲂ ⲘⲘⲞⲚ ⲘⲠⲒⲈϨⲞⲞⲨ ⲦⲎⲢϤ ⲀⲨⲞⲠⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲤⲰⲞⲨ ⲈⲠϦⲞⲖϦⲈⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ⲀⲖⲖⲀ ϦⲈⲚⲚⲀⲒ ⲦⲎⲢⲞⲨ ⲦⲈⲚⲈⲢϨⲞⲨⲞ ϬⲢⲞ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲎ ⲈⲦⲀϤⲘⲈⲚⲢⲒⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲀϨⲎⲦ ⲐⲎⲦ ϪⲈ ⲞⲨⲆⲈ ⲪⲘⲞⲨ ⲞⲨⲆⲈ ⲠⲰⲚϦ ⲞⲨⲆⲈ ⲀⲄⲄⲈⲖⲞⲤ ⲞⲨⲆⲈ ⲀⲢⲬⲎ ⲞⲨⲆⲈ ⲚⲈⲦϢⲞⲠ ⲞⲨⲆⲈ ⲚⲈⲦⲚⲀϢⲰⲠⲒ ⲞⲨⲆⲈ ϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ⲞⲨⲆⲈ ϬⲒⲤⲒ ⲞⲨⲆⲈ ϢⲰⲔ ⲞⲨⲆⲈ ⲔⲈⲤⲰⲚⲦ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲈⲪⲞⲢϪⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲚϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲪⲚⲞⲨϮ ⲐⲎ ⲈⲦϦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ⲐⲘⲎⲒ ⲠⲈϮϪⲰ ⲘⲘⲞⲤ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲚϮϪⲈⲘⲈⲐⲚⲞⲨϪ ⲀⲚ ⲈⲤⲈⲢⲘⲈⲐⲢⲈ ⲈⲢⲞⲒ ⲚⲈⲘⲎⲒ ⲚϪⲈⲦⲀⲤⲨⲚⲎⲆⲈⲤⲒⲤ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲚⲒϢϮ ⲚⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲈⲘⲎ ⲒⲚⲈⲘ ⲞⲨϢⲈⲚϨⲎⲦ ⲘⲠⲀϤⲘⲞⲨⲚⲔ ϦⲈⲚⲠⲀϨⲎ Ⲧ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ⲚⲀⲒⲦⲰⲂϨ ⲄⲀⲢ ⲀⲚⲞⲔ ⲈⲈⲢⲀⲚⲀⲐⲎⲘⲀ ⲈⲂⲞⲖ ϨⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈϪⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲚⲀⲤⲨⲚⲄⲈⲚⲎⲤ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ");
INSERT INTO copbhc_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ⲈⲦⲈ ⲚⲒⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲚⲈⲚⲎ ⲈⲦⲈ ⲐⲰⲞⲨ ⲦⲈ ϮⲘⲈⲦϢⲎⲢⲒ ⲚⲈⲘ ⲠⲒⲰⲞⲨ ⲚⲈⲘ ⲚⲒⲆⲒⲀⲐⲎⲔⲎ ⲚⲈⲘ ⲠⲒⲤⲈⲘⲚⲈ ⲚⲞⲘⲞⲤ ⲚⲈⲘ ⲠⲒϢⲈⲘϢⲒ ⲚⲈⲘ ⲚⲒⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ⲚⲎ ⲈⲦⲈ ⲚⲞⲨⲞⲨ ⲚⲈⲚⲒⲒⲞϮ ⲞⲨⲞϨ ⲚⲐⲰⲞⲨ ⲞⲚ ⲀⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲪⲎ ⲈⲦⲬⲎ ϨⲒϪⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲪⲚⲞⲨϮ ⲈⲦⲤⲘⲀⲢⲰⲞⲨⲦ ϢⲀ ⲈⲚⲈϨ ⲀⲘⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲘⲠⲈ ⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲈⲒ ⲈⲂⲞⲖ ⲞⲨ ⲄⲀⲢ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲀⲚ ⲈⲦⲈ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲖ ⲚⲀⲒ ⲚⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ⲞⲨⲆⲈ ϪⲈ ϨⲀⲚϪⲢⲞϪ ⲚⲦⲈⲀⲂⲢⲀⲀⲘ ⲚⲈϨⲀⲚϢⲎⲢⲒ ⲦⲎⲢⲞⲨ ⲚⲈⲀⲖⲖⲀ ϦⲈⲚⲒⲤⲀⲀⲔ ⲈⲨⲈⲐⲀϨⲈⲘ ⲞⲨϪⲢⲞϪ ⲚⲀⲔ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲦⲤⲀⲢⲜ ⲀⲚ ⲚⲀⲒ ⲚⲈⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲚⲒϢⲎⲢⲒ ⲚⲦⲈⲠⲒⲰϢ ⲈⲦⲞⲨⲚⲀⲞⲠⲞⲨ ⲈⲨϪⲢⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ⲠⲀⲒⲤⲀϪⲒ ⲄⲀⲢ ⲪⲀ ⲞⲨⲰϢ ⲠⲈ ϪⲈ ⲔⲀⲦⲀ ⲠⲀⲒⲤⲎⲞⲨ ⲪⲀⲒ ⲈⲒⲈⲒ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨϢⲎⲢⲒ ϢⲰⲠⲒ ⲚⲤⲀⲢⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ⲞⲨ ⲘⲞⲚⲞⲚ ⲆⲈ ⲀⲖⲖⲀ ⲚⲈⲘ ⲦⲔⲈⲈⲢⲈⲂⲈⲔⲔⲀ ⲈⲀⲤϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨϢⲀⲒⲢⲒ ⲚⲞⲨⲰⲦ ⲚⲦⲈⲒⲤⲀⲀⲔ ⲠⲈⲚⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ⲈⲘⲠⲀⲚⲦⲞⲨⲘⲀⲤⲞⲨ ⲄⲀⲢ ⲞⲨⲆⲈ ⲘⲠⲀⲦⲞⲨⲒⲢⲒ ⲚⲞⲨϨⲰⲂ ⲈⲚⲀⲚⲈϤ ⲒⲈ ⲈϤϨⲰⲞⲨ ϨⲒⲚⲀ ϮⲘⲈⲦⲤⲰⲦⲠ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲐⲀϢⲤ ⲒⲤϪⲈⲚ ϢⲞⲢⲠ ⲚⲦⲈⲤϢⲰⲠⲒ ⲈⲤⲤⲘⲞⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ⲈⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲐⲰϨⲈⲘ ⲀⲨϪⲞⲤ ⲚⲀⲤ ϪⲈ ⲈⲢⲈ ⲠⲒⲚⲒϢϮ ⲈⲢⲂⲰⲔ ⲘⲠⲒⲔⲞⲨϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲒⲀⲔⲰⲂ ⲘⲈⲚ ⲀⲒⲘⲈⲚⲢⲒⲦϤ ⲎⲤⲀⲨ ⲆⲈ ⲀⲒⲘⲈⲤⲦⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ⲘⲎ ⲞⲨⲞⲚ ⲞⲨⲘⲈⲦϬ ⲒⲚϪⲞⲚⲤ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ ⲚⲚⲈⲤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ϤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ϪⲈ ϮⲚⲀⲚⲀⲒ ⲘⲪⲎ ⲈϮⲚⲀⲚⲀⲒ ⲚⲀϤ ⲞⲨⲞϨ ϮⲚⲀϢⲈⲚϨⲎ ⲦϦⲀ ⲪⲎ ⲈϮⲚⲀϢⲈⲚϨⲎⲦ ϦⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ϨⲀⲢⲀ ⲞⲨⲚ ⲪⲀ ⲠⲈⲐⲞⲨⲰϢ ⲀⲚ ⲠⲈ ⲞⲨⲆⲈ ⲘⲪⲀ ⲠⲈⲦϬⲞϪⲒ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲪⲚⲞⲨϮ ⲈⲐⲚⲀⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ⲤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚϪⲈϮⲄⲢⲀⲪⲎ ⲘⲪⲀⲢⲀⲰ ϪⲈ ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲒⲦⲞⲨⲚⲞⲤⲔ ϨⲒⲚⲀ ⲚⲦⲀⲞⲨⲰⲚϨ ⲚⲦⲀϪⲞⲘ ⲈⲂⲞⲖ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲔ ⲞⲨⲞϨ ⲚⲤⲈⲪⲒⲢⲒ ⲈⲠⲀⲢⲀⲚ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲦⲎⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ϨⲀⲢⲀ ⲞⲨⲚ ⲠⲈⲦⲈϤⲞⲨⲀϢϤ ϢⲀϤⲚⲀⲒ ⲚⲀϤ ⲪⲎ ⲆⲈ ⲈⲦⲀϤⲞⲨⲀϢϤ ⲀⲚ ϢⲀϤⲈⲐⲢⲈϤⲈⲚϢⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ⲬⲚⲀϪⲞⲤ ⲞⲨⲚ ⲚⲎⲒ ϪⲈ ⲈⲐⲂⲈⲞⲨ ϤϪⲈⲘ ⲀⲢⲒⲔⲒ ⲚⲒⲘ ⲄⲀⲢ ⲈϤϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲈϤⲤⲞϬ ⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ⲘⲈⲚⲞⲨⲚⲄⲈ ⲰⲪⲢⲰⲘⲒ ⲚⲐⲞⲔ ⲚⲒⲘ ⲚⲐⲞⲔ ⲪⲎ ⲈⲦⲈⲢⲞⲨⲰ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲪⲚⲞⲨϮ ⲘⲎ ⲈⲢⲈϢ ⲠⲒⲘⲞⲚⲔ ϪⲞⲤ ⲘⲪⲎ ⲈⲦⲀϤⲘⲞⲚⲔϤ ϪⲈ ⲈⲐⲂⲈⲞⲨ ⲀⲔⲐⲀⲘⲒⲞⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ϢⲀⲚ ⲘⲘⲞⲚ ⲚⲦⲈⲠⲒⲔⲈⲢⲀⲘⲈⲨⲤ ⲘⲠⲈⲢϢⲒϢⲒ ⲘⲠⲈϤⲞⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲞⲨⲰϢⲈⲘ ⲢⲰ ⲈⲐⲀⲘⲒⲞ ⲚⲞⲨⲤⲔⲈⲨⲞⲤ ⲞⲨⲀⲒ ⲘⲈⲚ ⲈⲠⲦⲀⲒⲞ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲈⲨϢⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ⲒⲤϪⲈ ⲆⲈ ⲀϤⲞⲨⲰϢ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϤⲞⲨⲰⲚϨ ⲘⲠⲈϤϪⲰⲚⲦ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈⲦⲀⲘⲞⲚ ⲈⲦⲈϤϪⲞⲘ ⲀϤⲒⲚⲒ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲘⲘⲈⲦⲢⲈϤⲰⲞⲨ ⲚϨⲎⲦ ⲚϨⲀⲚⲤⲔⲈⲨⲞⲤ ⲚⲦⲈⲠϪⲰⲚⲦ ⲈⲨⲤⲈⲂⲦⲰⲦ ⲈⲠⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ϨⲒⲚⲀ ⲚⲦⲈϤⲞⲨⲰⲚϨ ⲚϮⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲦⲈⲠⲈϤⲰⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ϨⲀⲚⲤⲔⲈⲨⲞⲤ ⲚⲚⲀⲒ ⲈⲦⲈ ⲚⲎ ⲚⲈⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲤⲈⲂⲦⲰⲦⲞⲨ ⲈⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ⲈⲦⲈ ⲀⲚⲞⲚ ⲠⲈ ϦⲀ ⲚⲎ ⲈⲦⲀϤⲐⲀϨⲘⲞⲨ ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲖⲖⲀ ⲚⲈⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲔⲈⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ⲘⲪⲢⲎϮ ⲞⲚ ⲈⲦⲈϤϪⲰ ⲘⲘⲞⲤ ⲚⲰⲤⲒⲈ ϪⲈ ϮⲚⲀⲘⲞⲨϮ ⲈⲪⲎ ⲈⲦⲈ ⲠⲀⲖⲀⲞⲤ ⲀⲚ ⲠⲈ ϪⲈ ⲠⲀⲖⲀⲞⲤ ⲞⲨⲞϨ ⲐⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲘⲈⲚⲢⲒⲦⲤ ϪⲈ ⲀⲨⲘⲈⲚⲢⲒⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ⲞⲨⲞϨ ⲈⲤⲈϢⲰⲠⲒ ϦⲈⲚⲠⲒⲘⲀ ⲈⲦⲀⲨϪⲞⲤ ⲚⲰⲞⲨ ⲘⲘⲞϤ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲠⲀⲖⲀⲞⲤ ⲀⲚ ⲘⲠⲒⲘⲀ ⲈⲦⲈⲘⲘⲀⲨ ⲈⲨⲈⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲈⲚϢⲎ ⲢⲒ ⲘⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ⲎⲤⲀⲎⲀⲤ ⲆⲈ ⲈϤⲰϢ ⲈⲂⲞⲖ ⲈϪⲈⲚ ⲠⲒⲤⲖ ϪⲈ ⲈϢⲰⲠ ⲈⲢⲈ ⲦⲎⲠⲒ ⲚⲦⲈⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ⲈⲤⲞⲒ ⲘⲪⲢⲎϮ ⲘⲠⲒϢⲰ ⲚⲦⲈⲪⲒⲞⲘ ⲠⲤⲰϪⲠ ⲈϤⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ⲞⲨⲤⲀϪⲒ ⲄⲀⲢ ⲈϤϪⲰⲔ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲈϤϢⲰⲦ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲪⲎ ⲈⲦⲈ ⲠϬⲞⲒⲤ ⲚⲀⲀⲒϤ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲞⲚ ⲈⲦⲀϤϪⲞⲤ ⲚϪⲈⲎⲤⲀⲎⲀⲤ ϪⲈ ⲈⲚⲈⲘⲠⲈ ⲠϬⲞⲒⲤ ⲤⲀⲂⲀⲰⲐ ⲤⲰϪⲠ ⲚⲞⲨϪⲢⲞϪ ⲚⲀⲚ ⲚⲀⲚⲚⲀⲈⲢ ⲘⲪⲢⲎϮ ⲚⲤⲞⲆⲞⲘⲀ ⲠⲈ ⲞⲨⲞϨ ⲚⲀⲚⲚⲀⲒⲚⲒ ⲚⲄⲞⲘⲞⲢⲢⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲚⲚⲀϪⲞϤ ϪⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲈⲦⲈ ⲘⲠⲞⲨϬⲞϪⲒ ⲚⲤⲀϮⲘⲈⲐⲘⲎⲒ ⲀⲨⲦⲀϨⲈ ϮⲘⲈⲐⲘⲎ ⲒϮⲘⲈⲐⲘⲎⲒ ⲆⲈ ϮⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ⲠⲒⲤⲖ ⲆⲈ ⲈϤϬⲞϪⲒ ⲚⲤⲀⲠⲒⲚⲞⲘⲞⲤ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲘⲠⲈϤⲪⲞϨ ⲈⲠⲒⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ⲈⲐⲂⲈⲞⲨ ϪⲈ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲀⲨϬⲒϬⲢⲞⲠ ⲈⲠⲒⲰⲚⲒ ⲚϬⲢⲞⲠ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ϪⲈ ϨⲎⲠⲠⲈ ϮⲚⲀⲬⲰ ϦⲈⲚⲤⲒⲰⲚ ⲚⲞⲨⲰⲚⲒ ⲚϬⲢⲞⲠ ⲚⲈⲘ ⲞⲨⲠⲈⲦⲢⲀ ⲚⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲞⲨⲞϨ ⲪⲎ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲚⲈϤϬⲒϢⲒⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ⲚⲀⲤⲚⲎⲞⲨ ⲠϮⲘⲀϮ ⲚⲦⲈⲠⲀϨⲎⲦ ⲚⲈⲘ ⲠⲀⲦⲰⲂϨ ⲈϮⲢⲀ ⲘⲘⲞϤ ϨⲀ ⲪⲚⲞⲨϮ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ ⲈⲨⲚⲞϨⲈⲘ ");
INSERT INTO copbhc_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ϮⲈⲢⲘⲈⲐⲢⲈ ⲄⲀⲢ ⲚⲰⲞⲨ ϪⲈ ⲞⲨⲬⲞϨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦϢⲞⲠ ⲚϦⲎⲦⲞⲨ ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲞⲨⲈⲘⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ⲈⲨⲞⲂϢ ⲄⲀⲢ ⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲈⲨⲔⲰϮ ⲚⲤⲀⲤⲈⲘⲚⲈ ⲐⲰⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ ⲘⲠⲞⲨϬⲚⲈϪⲰⲞⲨ ⲈϮⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ⲠϪⲰⲔ ⲄⲀⲢ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲈⲨⲘⲈⲐⲘⲎ ⲒⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ⲘⲰⲨⲤⲎⲤ ⲄⲀⲢ ⲀϤⲤϦⲀⲒ ϪⲈ ϮⲘⲈⲐⲘⲎⲒ ϮⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲪⲢⲰⲘⲒ ⲈⲐⲚⲀⲀⲒⲤ ⲈϤⲈⲰⲚϦ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ϮⲘⲈⲐⲘⲎⲒ ⲆⲈ ϮⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲀϨϮ ϤϪⲰ ⲘⲘⲞⲤ ⲘⲠⲀⲒⲢⲎϮ ⲘⲠⲈⲢϪⲞⲤ ϦⲈⲚⲠⲈⲔϨⲎ ⲦϪⲈ ⲚⲒⲘ ⲈⲨⲚⲀϢϢⲈ ⲈⲠϢⲰⲒ ⲈⲦⲪⲈ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲚⲦⲈϤⲒⲚⲒ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲠⲈⲤⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ⲒⲈ ⲚⲒⲘ ⲈⲐⲚⲀϢϢⲈ ⲈⲠⲈⲤⲎⲦ ⲈⲪⲚⲞⲨⲚ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ϪⲈ ⲚⲦⲈϤⲒⲚⲒ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲠϢⲰⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ⲀⲖⲖⲀ ⲞⲨ ⲠⲈⲦⲈ ϮⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞϤ ϤϦⲈⲚⲦ ⲈⲢⲞⲔ ⲚϪⲈⲠⲒⲤⲀϪⲒ ϤⲬⲎ ϦⲈⲚⲢⲰⲔ ⲞⲨⲞϨ ϤⲬⲎ ϦⲈⲚⲠⲈⲔϨⲎⲦ ⲈⲦⲈ ⲪⲀⲒ ⲠⲈ ⲠⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲀϨϮ ⲈⲦⲈⲚϨⲒⲰⲒϢ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ϪⲈ ⲈϢⲰⲠ ⲀⲔϢⲀⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϦⲈⲚⲢⲰⲔ ϪⲈ ⲠϬⲞⲒⲤ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲚⲦⲈⲔⲚⲀϨϮ ϦⲈⲚⲠⲈⲔϨⲎⲦ ϪⲈ ⲀⲪⲚⲞⲨϮ ⲦⲞⲨⲚⲞⲤϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲈⲔⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ϦⲈⲚ ⲠⲒϨⲎⲦ ⲄⲀⲢ ⲤⲈⲚⲀϨϮ ⲈⲢⲞϤ ⲈⲨⲘⲈⲐⲘⲎⲒ ϦⲈⲚⲢⲰⲞⲨ ⲆⲈ ⲤⲈⲞⲨⲰⲚϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ⲈⲨⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ⲤϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲚϪⲈϮⲄⲢⲀⲪⲎ ϪⲈ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀϨϮ ⲈⲢⲞϤ ⲚⲚⲈϤϬⲒϢⲒⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ⲘⲘⲞⲚ ⲪⲰⲢϪ ⲄⲀⲢ ϢⲞⲠ ⲘⲠⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲠⲒⲞⲨⲈⲒⲚⲒⲚ ⲠⲀⲒϬⲞⲒⲤ ⲄⲀⲢ ⲠⲈ ⲚⲦⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϤⲞⲒ ⲚⲢⲀⲘⲀⲞ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲰϢ ⲈϨⲢⲎⲒ ⲞⲨⲂⲎϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲚⲀⲦⲰⲂϨ ⲘⲪⲢⲀⲚ ⲘⲠϬⲞⲒⲤ ⲈϤⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ⲠⲰⲤ ⲞⲨⲚ ⲤⲈⲚⲀⲦⲰⲂϨ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲚⲀϨϮ ⲈⲢⲞϤ ⲠⲰⲤ ⲆⲈ ⲤⲈⲚⲀⲚⲀϨϮ ⲘⲪⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲤⲞⲐⲘⲈϤ ⲠⲰⲤ ⲆⲈ ⲤⲈⲚⲀⲤⲰⲦⲈⲘ ⲀⲦϬⲚⲈ ⲪⲎ ⲈⲦϨⲒⲰⲒϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ⲠⲰⲤ ⲆⲈ ⲤⲈⲚⲀϨⲒⲰⲒϢ ⲀⲨϢⲦⲈⲘⲞⲨⲞⲢⲠⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ϨⲰⲤ ⲈⲚⲈⲤⲈ ⲚⲈⲚϬⲀⲖⲀⲨϪ ⲚⲚⲎ ⲈⲦϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲚⲒⲠⲈⲐⲚⲀⲚⲈⲨ ");
INSERT INTO copbhc_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ⲀⲖⲖⲀ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ ⲦⲎⲢⲞⲨ ⲚⲤⲀⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲎⲤⲀⲎⲀⲤ ⲄⲀⲢ ϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲚⲒⲘ ⲠⲈⲦⲀϤⲚⲀϨϮ ⲈⲦⲈⲚⲤⲘⲎ ⲞⲨⲞϨ ⲠϢⲰⲂϢ ⲘⲠϬⲞⲒⲤ ⲈⲦⲀϤϬⲰⲢⲠ ⲈⲚⲒⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ϨⲀⲢⲀ ⲪⲚⲀϨϮ ⲈⲂⲞⲖ ϦⲈⲚⲠⲤⲰⲦⲈⲘ ⲠⲈ ⲠⲤⲰⲦⲈⲘ ⲆⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲤⲀϪⲒ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ ⲘⲈⲚ ⲞⲨⲚ ⲄⲈ ⲀⲠⲞⲨϦⲢⲰⲞⲨ ϢⲈ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒϪⲈⲚ ⲠⲔⲀϨⲒ ⲦⲎⲢϤ ⲞⲨⲞϨ ⲚⲞⲨⲤⲀϪⲒ ⲀⲨⲪⲞϨ ϢⲀ ⲀⲨⲢⲎϪⲤ ⲚϮⲞⲒⲔⲞⲨⲘⲈⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ⲀⲖⲖⲀ ϮϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲎ ⲘⲠⲈ ⲠⲒⲤⲖ ⲘⲠⲈϤⲈⲘⲒ ⲚϢⲞⲢⲠ ⲘⲰⲨⲤⲎⲤ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲈⲒⲈϮⲬⲞϨ ⲚⲰⲦⲈⲚ ⲈϪⲈⲚ ⲠⲈⲦⲈ ⲚⲞⲨⲈⲐⲚⲞⲤ ⲀⲚ ⲠⲈ ⲈϪⲈⲚ ⲞⲨⲈⲐⲚⲞⲤ ⲚⲀⲦⲔⲀϮ ⲈⲒⲈⲐⲢⲈⲦⲈⲚϪⲰⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ⲎⲤⲀⲎⲀⲤ ⲆⲈ ⲀϤⲈⲢⲦⲞⲖⲘⲀⲚ ⲞⲨⲞϨ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲨϪⲈⲘⲦ ⲚⲚⲎ ⲈⲦⲈⲚⲤⲈⲔⲰϮ ⲚⲤⲰⲒ ⲀⲚ ⲀⲒⲞⲨⲞⲚϨⲦ ⲈⲚⲎ ⲈⲦⲈⲚⲤⲈϢⲒⲚⲒ ⲘⲘⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ϤϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲤⲖ ϪⲈ ⲀⲒⲪⲰⲢϢ ⲚⲚⲀϪⲒϪ ⲈⲂⲞⲖ ⲘⲠⲒⲈϨⲞⲞⲨ ⲦⲎⲢϤ ⲞⲨⲂⲈ ⲞⲨⲖⲀⲞⲤ ⲚⲀⲦⲤⲰⲦⲈⲘ ⲞⲨⲞϨ ϤⲈⲢⲀⲚⲦⲒⲖⲈⲄⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ϮϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲘⲎ ⲀⲪⲚⲞⲨϮ ⲬⲀ ⲠⲈϤⲖⲀⲞⲤ ⲚⲤⲰϤ ⲚⲚⲈⲤϢⲰⲠⲒ ⲔⲈⲄⲀⲢ ⲀⲚⲞⲔ ϨⲰ ⲀⲚⲞⲔ ⲞⲨⲎⲤⲢⲀⲎⲖⲒⲦⲎⲤ ⲈⲂⲞⲖ ϦⲈⲚⲠϪⲢⲞϪ ⲚⲀⲂⲢⲀⲀⲘ ⲦⲪⲨⲖⲎ ⲘⲂⲈⲚⲒⲀⲘⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ⲘⲠⲈ ⲪⲚⲞⲨϮ ⲬⲀ ⲠⲈϤⲖⲀⲞⲤ ⲚⲤⲰϤ ⲪⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲤⲞⲨⲰⲚϤ ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨ ⲠⲈⲦⲈ ϮⲄⲢⲀⲪⲎ ϪⲰ ⲘⲘⲞϤ ϦⲈⲚⲎⲖⲒⲀⲤ ⲘⲪⲢⲎϮ ⲈⲦⲀϤⲤⲈⲘⲒ ⲘⲪⲚⲞⲨϮ ⲈⲠⲒⲤⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ϪⲈ ⲠϬⲞⲒⲤ ⲚⲈⲔⲠⲢⲞⲪⲎⲦⲎⲤ ⲀⲨϦⲞⲐⲂⲞⲨ ⲚⲈⲔⲘⲀⲚⲈⲢϢⲞⲨϢⲰⲞⲨϢⲒ ⲀⲨⲞⲨⲞϪⲠⲞⲨ ⲀⲚⲞⲔ ⲘⲘⲀⲨⲀⲦ ⲀⲒⲤⲰϪⲠ ⲞⲨⲞϨ ⲤⲈⲔⲰϮ ⲚⲤⲀⲦⲀⲮⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ⲀⲖⲖⲀ ⲞⲨ ⲠⲈⲦⲈ ⲠⲒⲬⲢⲎⲘⲀⲦⲒⲤⲘⲞⲤ ϪⲰ ⲘⲘⲞⲤ ⲚⲀϤ ⲀⲒⲤⲰϪⲠ ⲚⲎⲒ ⲚⲌ ⲚϢⲞ ⲚⲢⲰⲘⲒ ⲚⲀⲒ ⲈⲦⲈ ⲘⲠⲞⲨⲔⲈⲖϪ ⲔⲈⲖⲒ ⲚϮⲂⲀⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ⲠⲀⲒⲢⲎϮ ⲞⲚ ϦⲈⲚⲠⲀⲒⲤⲎⲞⲨ ⲚⲦⲈϮⲚⲞⲨ ⲞⲨⲖⲨⲘⲘⲀ ⲔⲀⲦⲀ ⲞⲨⲘⲈⲦⲤⲰⲦⲠ ⲚⲞⲨϨⲘⲞⲦ ⲀϤϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ⲒⲤϪⲈ ⲆⲈ ϦⲈⲚⲞⲨϨⲘⲞⲦ ⲒⲈ ⲈⲂⲞⲖ ϦⲈⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲀⲚ ⲠⲈ ⲘⲘⲞⲚ ⲠⲒϨⲘⲞⲦ ϤⲚⲀⲈⲢϨⲘⲞⲦ ⲀⲚ ϪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ⲞⲨ ϪⲈ ⲪⲎ ⲠⲈⲦⲈ ⲠⲒⲤⲖ ⲔⲰϮ ⲚⲤⲰϤ ⲪⲀⲒ ⲘⲠⲈϤϢⲀϢⲚⲒ ⲈⲢⲞϤ ϮⲘⲈⲦⲤⲰⲦⲠ ⲆⲈ ⲀⲤϮⲘⲀϮ ⲠⲤⲈⲠⲒ ⲆⲈ ⲀⲨⲐⲰⲘ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲀⲪⲚⲞⲨϮ ϮⲚⲰⲞⲨ ⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲰⲘⲦ ⲚⲈⲘ ϨⲀⲚⲂⲀⲖ ⲈϢⲦⲈⲘⲚⲀⲨ ⲘⲂⲞⲖ ⲚⲈⲘ ϨⲀⲚⲘⲀϢϪ ⲈϢⲦⲈⲘⲤⲰⲦⲈⲘ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ ⲚⲈϨⲞⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ⲞⲨⲞϨ ⲆⲀⲨⲒⲆ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲘⲀⲢⲈ ⲦⲞⲨⲦⲢⲀⲠⲈⲌⲀ ϢⲰⲠⲒ ⲚⲰⲞⲨ ⲚⲞⲨⲪⲀϢ ⲚⲈⲘ ⲞⲨϪⲞⲢϪⲤ ⲚⲈⲘ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲈⲘ ⲞⲨϮϢⲈⲂⲒⲰ ⲚⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ⲚⲞⲨⲂⲀⲖ ⲘⲀⲢⲞⲨⲈⲢⲬⲢⲈⲘⲦⲤ ⲈϢⲦⲈⲘⲚⲀⲨ ⲘⲂⲞⲖ ⲦⲞⲨϬⲒⲤⲒ ⲘⲀⲢⲈⲤⲔⲰⲖϪ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ϮϪⲰ ⲞⲨⲚ ⲘⲘⲞⲤ ⲘⲎ ⲀⲨⲤⲖⲀϮ ϨⲒⲚⲀ ⲚⲤⲈϨⲈⲒ ⲚⲚⲈⲤϢⲰⲠⲒ ⲀⲖⲖⲀ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲞⲨⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲀⲠⲞⲨϪⲀⲒ ϢⲰⲠⲒ ⲚⲚⲒⲈⲐⲚⲞⲤ ϪⲈ ⲚⲤⲈϮⲬⲞϨ ⲚⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ⲒⲤϪⲈ ⲠⲞⲨⲠⲀⲢⲀⲠⲦⲰⲘⲀ ⲀϤⲈⲢ ⲞⲨⲘⲈⲦⲢⲀⲘⲀⲞ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲠⲞⲨϬⲢⲞϨ ⲀϤⲈⲢ ⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲒⲈ ⲀⲨⲎⲢ ⲠⲈ ⲠⲞⲨϪⲰⲔ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ϦⲀ ⲚⲒⲈⲐⲚⲞⲤ ⲈⲪⲞⲤⲞⲚ ⲘⲈⲚ ⲞⲨⲚ ⲀⲚⲞⲔ ϮⲞⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ϮϮⲰⲞⲨ ⲚⲦⲀⲆⲒⲀⲔⲞⲚⲒⲀ ");
INSERT INTO copbhc_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ϪⲈ ϨⲒⲚⲀ ⲚⲦⲀϮⲬⲞϨ ⲚⲦⲀⲤⲀⲢⲜ ⲞⲨⲞϨ ⲚⲦⲀⲚⲞϨⲈⲘ ⲚϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ⲒⲤϪⲈ ⲄⲀⲢ ⲀⲠⲞⲨϨⲒⲞⲨⲒ ⲈⲂⲞⲖ ⲀϤⲈⲢ ⲞⲨϨⲰⲦⲠ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲒⲈ ⲀϢ ⲠⲈ ⲠⲞⲨⲒⲚⲒ ⲈϦⲞⲨⲚ ⲈⲂⲎⲖ ⲈⲠⲰⲚϦ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲐⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ⲒⲤϪⲈ ⲆⲈ ϮⲀⲠⲀⲢⲬⲎ ⲞⲨⲀⲂ ⲒⲈ ϤⲞⲨⲀⲂ ⲞⲚ ⲚϪⲈⲠⲒⲔⲈⲞⲨⲰϢⲈⲘ ⲞⲨⲞϨ ⲒⲤϪⲈ ϮⲚⲞⲨⲚⲒ ⲞⲨⲀⲂ ⲒⲈ ⲤⲞⲨⲀⲂ ⲞⲚ ⲚϪⲈⲚⲒⲔⲈϪⲀⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ⲒⲤϪⲈ ⲆⲈ ⲀϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒϪⲀⲖ ⲀⲨⲔⲰⲢϪ ⲚⲐⲞⲔ ⲆⲈ ⲚⲐⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϮⲂⲰ ⲚϪⲰⲒⲦ ⲚϢⲀϢⲒ ⲀⲨⲈⲢⲔⲒⲚⲆⲢⲒⲌⲒⲚ ⲘⲘⲞⲔ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲞⲨ ⲞⲨⲞϨ ⲀⲔⲈⲢϢⲪⲎⲢ ⲘⲠⲒⲔⲈⲚⲒ ⲚⲦⲈⲐⲚⲞⲨⲚⲒ ⲚϮⲂⲰ ⲚϪⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ⲘⲠⲈⲢϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ⲈϪⲈⲚ ⲚⲒϪⲀⲖ ⲒⲤϪⲈ ⲆⲈ ⲚⲐⲞⲔ ⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ⲚⲐⲞⲔ ⲀⲚ ⲈⲦϤⲀⲒ ϦⲀ ϮⲚⲞⲨⲚⲒ ⲀⲖⲖⲀ ϮⲚⲞⲨⲚⲒ ⲈⲦⲦⲰⲞⲨⲚ ϦⲀⲢⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ⲬⲚⲀϪⲞⲤ ⲞⲨⲚ ϪⲈ ϨⲀⲚⲞⲨⲞⲚ ⲔⲰⲢϪ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒϪⲀⲖ ϨⲒⲚⲀ ⲀⲚⲞⲔ ⲚⲦⲞⲨⲈⲢⲔⲨⲚⲆⲢⲒⲌⲒⲚ ⲘⲘⲞⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ⲔⲀⲖⲰⲤ ⲀⲨⲔⲰⲢϪ ϦⲈⲚⲦⲞⲨⲘⲈⲦⲀⲐⲚⲀϨϮ ⲚⲐⲞⲔ ⲆⲈ ⲔⲞϨⲒ ⲈⲢⲀⲦⲔ ϦⲈⲚⲪⲚⲀϨϮ ⲘⲠⲈⲢϬⲒⲤⲒ ⲚϨⲎⲦ ⲀⲖⲖⲀ ⲀⲢⲒϨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ⲒⲤϪⲈ ⲄⲀⲢ ⲘⲠⲈ ⲪⲚⲞⲨϮ ϮⲀⲤⲞ ⲈϪⲈⲚ ⲚⲒⲔⲀⲦⲀⲪⲨⲤⲒⲤ ⲚϪⲀⲖ ⲞⲨⲆⲈ ⲚⲐⲞⲔ ϨⲰⲔ ⲚⲚⲈϤϮⲀⲤⲞ ⲈⲢⲞⲔ ");
INSERT INTO copbhc_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ⲀⲚⲀⲨ ⲞⲨⲚ ⲈϮⲘⲈⲦⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ϮⲘⲈⲦⲢⲈϤϢⲰⲦ ⲈⲂⲞⲖ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈϪⲈⲚ ⲚⲎ ⲘⲈⲚ ⲈⲦⲀⲨϨⲈⲒ ⲞⲨϢⲰⲦ ⲈⲂⲞⲖ ⲈϨⲢⲎⲒ ⲆⲈ ⲈϪⲰⲔ ⲞⲨⲘⲈⲦⲬⲢⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈϢⲰⲠ ⲆⲈ ⲀⲔϢⲀⲚⲞϨⲒ ϦⲈⲚϮⲘⲈⲦⲬⲢⲤ ⲘⲘⲞⲚ ⲚⲐⲞⲔ ϨⲰⲔ ⲤⲈⲚⲀⲔⲞⲢϪⲔ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ⲞⲨⲞϨ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲨϢⲦⲈⲘⲞϨⲒ ϦⲈⲚϮⲘⲈⲦⲀⲐⲚⲀϨϮ ⲤⲈⲚⲀⲈⲢⲔⲨⲚⲆⲢⲒⲌⲒⲚ ⲘⲘⲰⲞⲨ ⲚⲔⲈⲤⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ⲒⲤϪⲈ ⲚⲐⲞⲔ ⲀⲨⲔⲞⲢϪⲔ ⲈⲂⲞⲖ ϨⲀ ϮⲔⲀⲦⲀⲪⲨⲤⲒⲤ ⲘⲂⲰ ⲚϪⲰⲒⲦ ⲚϢⲀϢⲒ ⲞⲨⲞϨ ⲀⲨⲈⲢⲔⲨⲚⲆⲢⲒⲌⲒⲚ ⲘⲘⲞⲔ ⲠⲀⲢⲀ ⲦⲈⲔⲪⲨⲤⲒⲤ ⲈϮⲂⲰ ⲚϪⲰⲒⲦ ⲚⲚⲞⲨⲦⲈⲘ ⲠⲰⲤⲞ ⲘⲀⲖⲖⲞⲚ ⲚⲀⲒ ⲈⲨⲚⲀⲈⲢⲔⲨⲚⲆⲢⲒⲌⲒⲚ ⲘⲘⲰⲞⲨ ⲔⲀⲦⲀ ⲦⲞⲨⲪⲨⲤⲒⲤ ⲈⲦⲞⲨⲂⲰ ⲚϪⲰⲒⲦ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ⲚϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲀⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲈⲠⲀⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲤⲀⲂⲈ ⲚⲰⲦⲈⲚ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲞⲨⲐⲰⲘ ⲚϨⲎⲦ ⲀϤϢⲰⲠⲒ ⲘⲠⲒⲤⲖ ϦⲈⲚⲞⲨⲀⲠⲞⲘⲈⲢⲞⲤ ϢⲀⲦⲈ ⲠϪⲰⲔ ⲚⲚⲒⲈⲐⲚⲞⲤ ⲒⲈϦⲞⲨⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲠⲒⲤⲖ ⲦⲎⲢϤ ⲈϤⲈⲚⲞϨⲈⲘ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲈϤⲈⲒ ⲈⲂⲞⲖ ϦⲈⲚⲤⲒⲰⲚ ⲚϪⲈⲪⲎ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲈϤⲈⲦⲀⲤⲐⲞ ⲚⲚⲒⲘⲈⲦⲀⲤⲈⲂⲎⲤ ⲈⲂⲞⲖ ϨⲀ ⲒⲀⲔⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ⲞⲨⲞϨ ⲐⲀⲒ ⲦⲈ ⲦⲀⲆⲒⲀⲐⲎⲔⲎ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚⲰⲞⲨ ϨⲞⲦⲀⲚ ⲀⲒϢⲀⲚⲰⲖⲒ ⲚⲚⲞⲨⲚⲞⲂⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ⲔⲀⲦⲀ ⲘⲈⲚ ⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϨⲀⲚϪⲀϪⲒ ⲚⲈⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲔⲀⲦⲀ ϮⲘⲈⲦⲤⲰⲦⲠ ⲆⲈ ϨⲀⲚⲘⲈⲚⲢⲀϮ ⲚⲈⲈⲐⲂⲈ ⲚⲞⲨⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ϨⲀⲚⲀⲐⲞⲨⲰⲘ ⲚϨⲐⲎⲞⲨ ⲄⲀⲢ ⲚⲈⲚⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ⲠⲒⲐⲰϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲚⲐⲰⲦⲈⲚ ⲈⲦⲀⲢⲈⲦⲈⲚⲈⲢⲀⲦⲤⲰⲦⲈⲘ ⲚⲤⲀⲪⲚⲞⲨϮ ⲚⲞⲨⲤⲎⲞⲨ ϮⲚⲞⲨ ⲆⲈ ⲀⲨⲚⲀⲒ ⲚⲰⲦⲈⲚ ϦⲈⲚϮⲘⲈⲦⲀⲦⲤⲰⲦⲈⲘ ⲚⲦⲈⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ⲠⲀⲒⲢⲎϮ ⲚⲀⲒ ϨⲰⲞⲨ ϮⲚⲞⲨ ⲀⲨⲈⲢⲀⲦⲤⲰⲦⲈⲘ ⲚⲤⲀⲠⲈⲦⲈⲚⲚⲀⲒ ϨⲒⲚⲀ ⲚⲤⲈⲚⲀⲒ ⲚⲰⲞⲨ ϨⲰⲞⲨ ϮⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ⲀⲪⲚⲞⲨϮ ⲄⲀⲢ ⲘⲀϢⲐⲀⲘ ⲈϨⲢⲈⲚ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈϦⲞⲨⲚ ϦⲀ ⲞⲨⲘⲈⲦⲀⲦⲤⲰⲦⲈⲘ ϨⲒⲚⲀ ⲚⲦⲈϤⲚⲀⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ⲰⲠϢⲰⲔ ⲚϮⲘⲈⲦⲢⲀⲘⲀⲞ ⲚⲈⲘ ϮⲤⲞⲪⲒⲀ ⲚⲈⲘ ⲠⲒⲈⲘⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲰⲤ ϨⲀⲚⲀⲦϦⲈⲦϦⲰⲦⲞⲨ ⲚⲈⲚⲈϤϨⲀⲠ ⲞⲨⲞϨ ϨⲀⲚⲀⲦϬⲒⲦⲀⲦⲤⲒ ⲚⲤⲰⲞⲨ ⲚⲈⲚⲈϤⲘⲰⲒⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲦⲀϤⲈⲘⲒ ⲈⲠϨⲎⲦ ⲘⲠϬⲞⲒⲤ ⲒⲈ ⲚⲒⲘ ⲀϤⲈⲢϢⲪⲎⲢ ⲚⲤⲞϬⲚⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ⲒⲈ ⲚⲒⲘ ⲀϤⲈⲢϢⲞⲢⲠ ⲚϮ ⲚⲀϤ ⲞⲨⲞϨ ⲚⲦⲈϤϮ ⲚⲀϤ ⲚⲦⲞⲨϢⲈⲂⲒⲰ. ");
INSERT INTO copbhc_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ϪⲈ ϨⲀⲚⲈⲂⲞⲖ ⲘⲘⲞϤ ⲚⲈⲞⲨⲞϨ ϨⲀⲚⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲚⲈⲞⲨⲞϨ ϨⲀⲚⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲦⲎⲢⲞⲨ ⲚⲈⲪⲰϤ ⲠⲈ ⲠⲒⲰⲞⲨ ϢⲀ ⲈⲚⲈϨ ⲀⲘⲎⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ϮϮϨⲞ ⲆⲈ ⲈⲢⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲘⲈⲦϢⲈⲚϨⲎⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲐⲢⲈⲦⲈⲚⲦⲀϨⲈ ⲚⲈⲦⲈⲚⲤⲰⲘⲀ ⲈⲢⲀⲦⲞⲨ ⲚⲞⲨϢⲞⲨϢⲰⲞⲨϢⲒ ⲈϤⲞⲚϦ ⲈϤⲞⲨⲀⲂ ⲈϤⲢⲀⲚⲀϤ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲠⲈⲦⲈⲚϢⲈⲘϢⲒ ⲚⲖⲞⲄⲒⲔⲞⲚ ⲈϤⲢⲀⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲈⲢϢⲪⲎⲢ ⲚⲤⲬⲎⲘⲀ ϪⲈ ⲚⲈⲘ ⲠⲀⲒⲈⲚⲈϨ ⲀⲖⲖⲀ ⲚⲦⲈⲦⲈⲚϢⲈⲂⲦ ⲠⲈⲦⲈⲚⲤⲘⲞⲦ ϦⲈⲚⲞⲨⲘⲈⲦⲂⲈⲢⲒ ⲚⲦⲈⲠⲒⲔⲀϮ ⲈⲐⲢⲈⲦⲈⲚⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ϪⲈ ⲞⲨ ⲠⲈ ⲪⲞⲨⲰϢ ⲘⲪⲚⲞⲨϮ ⲠⲒⲀⲄⲀⲐⲞⲚ ⲈⲐⲢⲀⲚⲀϤ ⲞⲨⲞϨ ⲈⲦϪⲎⲔ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒϨⲘⲞⲦ ⲈⲦⲦⲞⲒ ⲚⲎⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈϢⲦⲈⲘⲈⲢϨⲞⲨⲞ ⲘⲈⲨⲒ ⲤⲀⲂⲞⲖ ⲘⲠⲈⲦⲤϢⲈ ⲈⲘⲈⲨⲒ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲈⲘⲈⲨⲒ ⲈϬⲒⲤⲂⲰ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲪⲰϢ ⲚⲀϤ ⲚⲞⲨϢⲒ ⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲞⲨⲞⲚⲦⲀⲚ ⲚⲞⲨⲘⲎϢ ⲘⲘⲈⲖⲞⲤ ⲘⲘⲀⲨ ⲚⲒⲘⲈⲖⲞⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲞⲨϨⲰⲂ ⲚⲞⲨⲰⲦ ⲀⲚ ⲠⲈⲦⲈⲚⲦⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ⲠⲀⲒⲢⲎϮ ⲀⲚⲞⲚ ϨⲰⲚ ϦⲀ ⲚⲒⲘⲎϢ ⲀⲚⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲞⲚ ⲀⲚⲞⲚ ϨⲀⲚⲘⲈⲖⲞⲤ ⲚⲦⲈⲚⲈⲚⲈⲢⲎ ⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ⲈⲞⲨⲞⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚϨⲀⲚϨⲘⲞⲦ ⲈⲨϢⲈⲂⲒⲎⲞⲨⲦ ⲔⲀⲦⲀ ⲠϢⲒ ⲘⲠⲒϨⲘⲞⲦ ⲈⲦⲦⲞⲒ ⲚⲀⲚ ⲒⲦⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲔⲀⲦⲀ ⲠⲒⲐⲞⲚⲦⲈⲚ ⲚⲦⲈⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ⲒⲦⲈ ⲞⲨⲆⲒⲀⲔⲞⲚⲒⲀ ϦⲈⲚϮⲆⲒⲀⲔⲞⲚⲒⲀ ⲒⲦⲈ ⲠⲈⲦϮⲤⲂⲰ ϦⲈⲚϮⲘⲈⲦⲢⲈϤϮⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ⲒⲦⲈ ⲠⲈⲦϮⲚⲞⲘϮ ϦⲈⲚϮⲘⲈⲦⲐⲀⲦϨⲎⲦ ⲪⲎ ⲈⲦϮ ϦⲈⲚⲞⲨⲘⲈⲦϨⲀⲠⲖⲞⲨⲤ ⲪⲎ ⲈⲦⲬⲎ ϦⲀϪⲰⲞⲨ ϦⲈⲚⲞⲨⲤⲠⲞⲨⲆⲎ ⲪⲎ ⲈⲐⲚⲀⲒ ϦⲈⲚⲞⲨⲢⲀϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ϮⲀⲄⲀⲠⲎ ⲘⲘⲞⲚ ⲘⲈⲦϢⲞⲂⲒ ⲚϦⲎⲦⲤ ⲈⲢⲈⲦⲈⲚⲪⲎⲦ ⲤⲀⲂⲞⲖ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲈⲢⲈⲦⲈⲚⲦⲞⲘⲒ ⲘⲘⲰⲦⲈⲚ ⲈⲠⲒⲀⲄⲀⲐⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ϦⲈⲚ ϮⲘⲈⲦⲘⲀⲒⲤⲞⲚ ⲈⲢⲈⲦⲈⲚⲬⲎ ϦⲈⲚⲞⲨⲘⲈⲒ ⲈϦⲞⲨⲚ ⲈⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲈⲢⲈⲦⲈⲚⲈⲢϢⲞⲢⲠ ⲚⲬⲀ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨⲦⲀⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚϬⲚⲀⲨ ⲀⲚ ϦⲈⲚϮⲤⲠⲞⲨⲆⲎ ⲈⲢⲈⲦⲈⲚϦⲎⲘ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲈⲢⲈⲦⲈⲚⲞⲒ ⲘⲂⲰⲔ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ⲈⲢⲈⲦⲈⲚⲢⲀϢⲒ ϦⲈⲚϮϨⲈⲖⲠⲒⲤ ⲈⲢⲈⲦⲈⲚⲈⲢϨⲨⲠⲞⲘⲈⲚⲒⲚ ϦⲈⲚⲚⲒϨⲞϪϨⲈϪ ⲈⲢⲈⲦⲈⲚⲘⲎ ⲚⲈϮⲠⲢⲞⲤⲈⲨⲬⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚϢⲪⲎⲢ ⲈⲚⲒⲬⲢⲒⲀ ⲚⲦⲈⲚⲒⲀⲄⲒⲞⲤ ⲈⲢⲈⲦⲈⲚϬⲞϪⲒ ⲚⲤⲀⲦⲘⲈⲦⲘⲀⲒϢⲈⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ⲤⲘⲞⲨ ⲈⲚⲎ ⲈⲦϬⲞϪⲒ ⲚⲤⲀⲐⲎⲚⲞⲨ ⲤⲘⲞⲨ ⲞⲨⲞϨ ⲘⲠⲈⲢⲤⲀϨⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ⲢⲀϢⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲢⲀϢⲒ ⲞⲨⲞϨ ⲢⲒⲘⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲢⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ⲞⲨⲘⲈⲨⲒ ⲚⲞⲨⲰⲦ ⲈⲢⲈⲦⲈⲚⲢⲀ ⲘⲘⲞϤ ⲈⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲚⲦⲈⲦⲈⲚⲘⲈⲨⲒ ⲀⲚ ⲈⲚⲒⲘⲈⲦϬⲀⲤⲒϨⲎ ⲦⲀⲖⲖⲀ ⲈⲢⲈⲦⲈⲚⲘⲞϢⲒ ⲚⲈⲘ ⲚⲎ ⲈⲦⲐⲈⲂⲒⲎ ⲞⲨⲦ ⲘⲠⲈⲢϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲤⲀⲂⲈ ⲚⲰⲦⲈⲚ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ⲚⲦⲈⲦⲈⲚϮ ⲚⲞⲨⲠⲈⲦϨⲰⲞⲨ ⲀⲚ ⲚϨⲖⲒ ⲚⲦϢⲈⲂⲒⲰ ⲚⲠⲞⲨⲠⲈⲦϨⲰⲞⲨ ⲈⲢⲈⲦⲈⲚϤⲒ ⲘⲪⲢⲰⲞⲨϢ ⲚϨⲀⲚⲠⲈⲐⲚⲀⲚⲈⲨ ⲘⲠⲈⲘⲐⲞ ⲚⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲀⲢⲒⲀⲨⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲈⲢϨⲒⲢⲎⲚⲎ ⲚⲈⲘ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ⲚⲦⲈⲦⲈⲚϬⲒ ⲘⲠⲈⲦⲈⲚⲘⲠϢⲒϢ ⲀⲚ ⲚⲀⲘⲈⲚⲢⲀϮ ⲀⲖⲖⲀ ⲘⲀⲘⲀ ⲘⲠϪⲰⲚⲦ ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ⲚϬⲒⲘⲠϢⲒϢ ⲪⲰⲒ ⲀⲚⲞⲔ ⲠⲈ ⲀⲚⲞⲔ ⲈⲐⲚⲀϮϢⲈⲂⲒⲰ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ⲀⲖⲖⲀ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠⲈⲔϪⲀϪⲒ ϨⲔⲞ ⲘⲀⲦⲈⲘⲘⲞϤ ⲀϤϢⲀⲚⲒⲂⲒ ⲘⲀⲦⲤⲞϤ ⲪⲀⲒ ⲄⲀⲢ ⲈⲔⲢⲀ ⲘⲘⲞϤ ⲈⲔⲈⲐⲰⲞⲨϮ ⲚϨⲀⲚϪⲈⲂⲤ ⲚⲬⲢⲰⲘ ϨⲒϪⲈⲚ ⲦⲈϤⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ⲘⲠⲈⲚⲐⲢⲈ ⲠⲒⲠⲈⲦϨⲰⲞⲨ ϬⲢⲞ ⲈⲢⲰⲦⲈⲚ ⲀⲖⲖⲀ ϦⲈⲚⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ϬⲢⲞ ⲈⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ⲮⲨⲬⲎ ⲚⲒⲂⲈⲚ ⲘⲀⲢⲞⲨϬⲚⲈϪⲰⲞⲨ ⲈⲚⲒⲈⲜⲞⲨⲤⲒⲀ ⲈⲦϬⲞⲤⲒ ⲘⲘⲞⲚ ⲈⲜⲞⲨⲤⲒⲀ ⲄⲀⲢ ϢⲞⲠ ⲈⲂⲎⲖ ⲈⲚⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲚⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲤⲈⲐⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ϨⲰⲤⲦⲈ ⲪⲎ ⲈⲦϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ϮⲈⲜⲞⲨⲤⲒⲀ ⲀϤϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲈⲚ ⲠⲒⲐⲰϢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲎ ⲆⲈ ⲈⲦϮ ⲈϦⲞⲨⲚ ⲈϨⲢⲀⲨ ⲈⲨⲈϬⲒ ⲚⲞⲨϨⲀⲠ ");
INSERT INTO copbhc_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ⲚⲒⲀⲢⲬⲎ ⲄⲀⲢ ⲚⲀⲨⲬⲎ ⲈⲨϨⲞϮ ⲀⲚ ⲘⲠⲒϨⲰⲂ ⲈⲐⲚⲀⲚⲈϤ ⲀⲖⲖⲀ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲬⲞⲨⲰϢ ⲆⲈ ⲈϢⲦⲈⲘⲈⲢϨⲞϮ ϦⲀⲦϨⲎ ⲚϮⲈⲜⲞⲨⲤⲒⲀ ⲀⲢⲒⲞⲨⲒ ⲘⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲞⲨⲞϨ ⲈⲢⲈ ⲞⲨⲦⲀⲒⲞ ϢⲰⲠⲒ ⲚⲀⲔ ⲈⲂⲞⲖ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ⲞⲨⲆⲒⲀⲔⲰⲚ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲔ ⲦⲈ ⲈⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲈϢⲰⲠ ⲆⲈ ⲀⲔϢⲀⲚⲒⲢⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲀⲢⲒϨⲞϮ ⲚⲀⲤⲈⲢⲪⲞⲢⲒⲚ ⲄⲀⲢ ⲀⲚ ⲚϮⲤⲎϤⲒ ϨⲒⲔⲎ ⲞⲨⲆⲒⲀⲔⲰⲚ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ ⲈⲤϬⲒⲘⲠϢⲒϢ ⲘⲠϪⲰⲚⲦ ⲘⲪⲎ ⲈⲦⲒⲢⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲚⲀⲄⲔⲎ ⲈϬⲚⲈϪⲰⲦⲈⲚ ⲞⲨ ⲘⲞⲚⲞⲚ ⲈⲐⲂⲈ ⲠϪⲰⲚⲦ ⲀⲖⲖⲀ ⲚⲈⲘ ⲈⲐⲂⲈ ϮⲤⲨⲚⲎⲆⲈⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ⲈⲐⲂⲈ ⲪⲀⲒ ⲄⲀⲢ ⲦⲈⲚϮϨⲰϮ ϨⲀⲚⲢⲈϤⲪⲰϢⲈⲚ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲈⲈⲨⲘⲎⲚ ⲈⲠⲀⲒϨⲰⲂ ");
INSERT INTO copbhc_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ⲘⲀ ⲚⲈⲦⲈⲢⲰⲦⲈⲚ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲘⲀ ⲠⲒϨⲰϮ ⲘⲪⲀ ⲠⲒϨⲰϮ ⲘⲀ ⲠⲒⲦⲈⲖⲞⲤ ⲘⲪⲀ ⲠⲒⲦⲈⲖⲞⲤ ⲘⲀϮϨⲞϮ ⲘⲪⲀ ϮϨⲞϮ ⲘⲀ ⲠⲒⲦⲀⲒⲞ ⲘⲪⲀ ⲠⲒⲦⲀⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ⲘⲠⲈⲢⲬⲀ ϨⲖⲒ ⲚⲦⲈϨⲖⲒ ⲈⲢⲰⲦⲈⲚ ⲈⲂⲎⲖ ⲈⲘⲈⲚⲢⲈ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲪⲎ ⲄⲀⲢ ⲈⲐⲘⲈⲒ ⲘⲠⲈϤϢⲪⲎⲢ ⲀϤϪⲈⲔ ⲠⲒⲚⲞⲘⲞⲤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ⲪⲀⲒ ⲄⲀⲢ ϪⲈ ⲚⲚⲈⲔⲈⲢⲚⲰⲒⲔ ⲚⲚⲈⲔϦⲰⲦⲈⲂ ⲚⲚⲈⲔϬⲒⲞⲨⲒ ⲚⲚⲈⲔⲈⲢⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ⲚⲚⲈⲔⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲚⲈⲘ ⲔⲈⲞⲨⲒ ⲔⲈⲞⲨⲒ ⲚⲚⲒⲈⲚⲦⲞⲖⲎ ⲀⲨϪⲎⲔ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲤⲀϪⲒ ϦⲈⲚⲪⲘⲈⲚⲢⲈ ⲠⲈⲔϢⲪⲎⲢ ⲘⲠⲈⲔⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ϮⲀⲄⲀⲠⲎ ⲘⲠⲈⲤⲈⲢⲠⲈⲦϨⲰⲞⲨ ⲘⲠⲈⲤϢⲪⲎ ⲢⲠϪⲰⲔ ⲞⲨⲚ ⲘⲠⲒⲚⲞⲘⲞⲤ ⲠⲈ ϮⲀⲄⲀⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲢⲈⲦⲈⲚⲈⲘⲒ ⲈⲠⲒⲤⲎⲞⲨ ϪⲈ ϮⲞⲨⲚⲞⲨ ⲦⲈ ϨⲎⲆⲎ ⲈⲐⲢⲈⲦⲈⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲚⲔⲞⲦ ϮⲚⲞⲨ ⲆⲈ ⲀϤϦⲰⲚⲦ ⲈⲢⲞⲚ ⲚϪⲈⲠⲈⲚⲚⲞϨⲈⲘ ⲈϨⲞⲦⲈ ⲠⲒⲤⲎⲞⲨ ⲈⲦⲀⲚⲚⲀϨϮ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ⲀⲠⲒⲈϪⲰⲢϨ ⲈⲢⲠⲢⲞⲔⲞⲠⲦⲒⲚ ⲠⲒⲈϨⲞⲞⲨ ⲆⲈ ⲀϤϦⲰⲚⲦ ⲘⲀⲢⲈⲚⲬⲰ ⲞⲨⲚ ⲚϦⲢⲎⲒ ⲚⲚⲒϨⲂⲎ ⲞⲨⲒ ⲚⲦⲈⲠⲬⲀⲔⲒ ⲘⲀⲢⲈⲚϮ ⲆⲈ ϨⲒⲰⲦⲈⲚ ⲚⲚⲒϨⲞⲠⲖⲞⲚ ⲚⲦⲈⲠⲒⲞⲨⲰⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ϨⲰⲤ ⲈⲚϦⲈⲚ ⲠⲒⲈϨⲞⲞⲨ ⲘⲀⲢⲈⲚⲘⲞϢⲒ ⲈⲚⲤⲞⲨⲂⲎⲦ ϦⲈⲚϨⲀⲚϪⲈⲢϪⲈⲢ ⲀⲚ ⲚⲈⲘ ϨⲀⲚⲐⲒϦⲒ ϦⲈⲚϨⲀⲚϢⲀⲒⲢⲒ ⲀⲚ ⲚⲈⲘ ϨⲀⲚⲤⲰϤ ϦⲈⲚⲞⲨϢϬⲚⲎⲚ ⲀⲚ ⲚⲈⲘ ⲞⲨⲬⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ⲀⲖⲖⲀ ⲘⲞⲒ ϨⲒ ⲐⲎⲚⲞⲨ ⲘⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲘⲠⲈⲢϤⲒⲢⲰⲞⲨϢ ϦⲀ ϮⲤⲀⲢⲜ ϦⲈⲚϨⲀⲚⲈⲠⲒⲐⲨⲘⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ⲠⲈⲦϢⲰⲚⲒ ϦⲈⲚⲪⲚⲀϨϮ ϢⲞⲠϤ ⲈⲢⲰⲦⲈⲚ ϦⲈⲚϨⲀⲚϨⲒⲞⲒ ⲀⲚ ⲚⲦⲈϨⲀⲚⲘⲞⲔⲘⲈⲔ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ⲞⲨⲞⲚ ⲠⲈⲐⲚⲀϨϮ ⲘⲈⲚ ⲈⲞⲨⲈⲘ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲠⲈⲦϢⲰⲚⲒ ⲆⲈ ϢⲀϤⲞⲨⲈⲘ ⲞⲨⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ⲪⲎ ⲈⲐⲞⲨⲰⲘ ⲘⲠⲈⲚⲐⲢⲈϤϢⲈϢϤ ⲪⲎ ⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲪⲎ ⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ⲘⲠⲈⲚⲐⲢⲈϤϮ ϨⲀⲠ ⲈⲠⲈⲐⲞⲨⲰⲘ ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲀϤϢⲞⲠϤ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ⲚⲐⲞⲔ ⲚⲒⲘ ⲚⲐⲞⲔ ⲪⲎ ⲈⲦϮϨⲀⲠ ⲈⲞⲨⲂⲰⲔ ⲚϢⲈⲘⲘⲞ ⲈϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲈⲠⲈϤϬⲞⲒⲤ ⲒⲈ ⲈϤⲚⲀϨⲈⲒ ⲈϤⲞϨⲒ ⲆⲈ ⲈⲢⲀⲦϤ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲠϬⲞⲒⲤ ⲈⲦⲀϨⲞϤ ⲈⲢⲀⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ⲞⲨⲞⲚ ⲠⲈϮϨⲀⲠ ⲄⲀⲢ ⲘⲈⲚ ⲚⲈϨⲞⲞⲨ ϦⲀⲦϨⲎ ⲚⲈϨⲞⲞⲨ ⲞⲨⲞⲚ ⲠⲈⲦϮϨⲀⲠ ⲆⲈ ⲚⲈϨⲞⲞⲨ ⲚⲒⲂⲈⲚ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲀⲢⲈϤⲐⲰⲦ ⲚϨⲎⲦ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ⲪⲎ ⲈⲐⲘⲈⲨⲒ ⲈⲠⲒⲈϨⲞⲞⲨ ⲀϤⲘⲈⲨⲒ ⲈⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲠⲈⲐⲞⲨⲰⲘ ⲀϤⲞⲨⲰⲘ ⲘⲠϬⲞⲒⲤ ϤϢⲈⲠϨⲘⲞⲦ ⲄⲀⲢ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚϤⲞⲨⲰⲘ ⲀⲚ ϤⲞⲨⲰⲘ ⲀⲚ ⲘⲠϬⲞⲒⲤ ⲞⲨⲞϨ ϤϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ⲘⲘⲞⲚ ϨⲖⲒ ⲄⲀⲢ ⲘⲘⲞⲚ ⲚⲀⲰⲚϦ ⲚⲀϤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲀⲘⲞⲨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ⲈϢⲰⲠ ⲄⲀⲢ ⲈⲚⲚⲀⲰⲚϦ ⲈⲚⲚⲀⲰⲚϦ ⲘⲠϬ ⲤⲈϢⲰⲠ ⲆⲈ ⲈⲚⲚⲀⲘⲞⲨ ⲈⲚⲚⲀⲘⲞⲨ ⲘⲠϬⲞⲒⲤ ⲒⲦⲈ ⲞⲨⲚ ⲈⲚⲚⲀⲰⲚϦ ⲒⲦⲈ ⲈⲚⲚⲀⲘⲞⲨ ⲀⲚⲞⲚ ⲚⲀ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ⲈⲐⲂⲈ ⲪⲀⲒ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲘⲞⲨ ⲞⲨⲞϨ ⲀϤⲰⲚϦ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢϬⲞⲒⲤ ⲈⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲚⲈⲘ ⲚⲎ ⲈⲦⲞⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ⲚⲐⲞⲔ ⲆⲈ ⲈⲐⲂⲈⲞⲨ ⲔϮϨⲀⲠ ⲈⲠⲈⲔⲤⲞⲚ ⲘⲘⲞⲚ ⲚⲐⲞⲔ ϨⲰⲔ ⲈⲐⲂⲈⲞⲨ ⲔϢⲰϢ ⲘⲠⲈⲔⲤⲞⲚ ⲀⲚⲞⲚ ⲄⲀⲢ ⲦⲎⲢⲈⲚ ⲤⲈⲚⲀⲦⲀϨⲞⲚ ⲈⲢⲀⲦⲈⲚ ⲚⲀϨⲢⲈⲚ ⲠⲒⲂⲎⲘⲀ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ϮⲞⲚϦ ⲀⲚⲞⲔ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ ϪⲈ ⲔⲈⲖⲒ ⲚⲒⲂⲈⲚ ⲈⲨⲈⲔⲰⲖϪ ⲚⲎⲒ ⲞⲨⲞϨ ⲚⲦⲈⲖⲀⲤ ⲚⲒⲂⲈⲚ ⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ϨⲀⲢⲀ ⲞⲨⲚ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲞⲚ ϤⲚⲀϮⲖⲞⲄⲞⲤ ⲈϪⲰϤ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ⲘⲠⲈⲚⲐⲢⲈⲚϮϨⲀⲠ ⲞⲨⲚ ϪⲈ ⲈⲚⲈⲚⲈⲢⲎⲞⲨ ⲀⲖⲖⲀ ⲪⲀⲒ ⲘⲀⲖⲖⲞⲚ ⲘⲀϨⲀⲠ ⲈⲢⲞϤ ⲈϢⲦⲈⲘⲬ ⲀⲞⲨϬⲢⲞⲠ ⲒⲈ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲘⲠⲈⲔⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ϮⲈⲘⲒ ⲞⲨⲞϨ ⲠⲀϨⲎⲦ ⲐⲎⲦ ϦⲈⲚⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲈϤϬⲀϦⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲈⲂⲎⲖ ⲈⲪⲎ ⲈⲐⲘⲈⲨⲒ ⲈⲞⲨⲈⲚⲬⲀⲒ ϪⲈ ϤϬⲀϦⲈⲘ ϤϬⲀϦⲈⲘ ⲚⲦⲞⲦϤ ⲘⲪⲎ ⲈⲦⲈⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ⲒⲤϪⲈ ⲄⲀⲢ ⲈⲐⲂⲈ ⲞⲨϦⲢⲈ ⲀⲢⲈ ⲠⲈⲔⲤⲞⲚ ⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲈⲤⲐⲈ ⲒⲈ ⲔⲘⲞϢⲒ ⲀⲚ ϪⲈ ⲔⲀⲦⲀ ⲞⲨⲀⲄⲀⲠⲎ ⲘⲠⲈⲢⲦⲀⲔⲈ ⲪⲎ ⲈⲦⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰϤ ϦⲈⲚⲦⲈⲔϦⲢⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ⲘⲠⲈⲚⲐⲢⲞⲨϪⲈⲞⲨⲀ ⲞⲨⲚ ⲈⲠⲈⲦⲈⲚⲠⲈⲐⲚⲀⲚⲈϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ϮⲘⲈⲦⲞⲨⲢⲞ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲤϦⲈⲚ ⲞⲨⲰⲘ ⲀⲚ ⲚⲈⲘ ⲞⲨⲤⲰ ⲀⲖⲖⲀ ⲀⲤϦⲈⲚ ⲞⲨⲘⲈⲐⲘⲎ ⲒⲚⲈⲘ ⲞⲨϨⲒⲢⲎⲚⲎ ⲚⲈⲘ ⲞⲨⲢⲀϢⲒ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ⲪⲎ ⲄⲀⲢ ⲈⲦⲞⲒ ⲘⲂⲰⲔ ϦⲈⲚⲚⲀⲒ ⲈⲠⲬⲢⲒⲤⲦⲞⲤ ϤⲢⲀⲚⲀϤ ⲘⲪⲚⲞⲨϮ ⲞⲨⲞϨ ϤⲤⲞⲨⲦⲰⲚ ⲠⲈ ϦⲈⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ϨⲀⲢⲀ ⲞⲨⲚ ⲘⲀⲢⲈⲚϬⲞϪⲒ ⲚⲤⲀⲚⲀ ϮϨⲒⲢⲎⲚⲎ ⲚⲈⲘ ⲚⲀ ⲠⲒⲔⲰⲦ ⲈⲚⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ⲘⲠⲈⲢⲂⲈⲖ ⲠⲒϨⲰⲂ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ⲈⲐⲂⲈ ⲞⲨϦⲢⲈ ⲤⲈⲞⲨⲀⲂ ⲘⲈⲚ ⲦⲎⲢⲞⲨ ⲀⲖⲖⲀ ⲞⲨⲠⲈⲦϨⲰⲞⲨ ⲠⲈ ⲘⲠⲒⲢⲰⲘⲒ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨϬⲢⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ⲚⲀⲚⲈⲤ ⲈϢⲦⲈⲘⲞⲨⲈⲘ ⲀϤ ⲞⲨⲆⲈ ⲈϢⲦⲈⲘⲤⲈ ⲎⲢⲠ ⲚⲈⲘ ⲪⲎ ⲈⲦⲈ ⲠⲈⲔⲤⲞⲚ ⲚⲀϬⲒϬⲢⲞⲠ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ⲚⲐⲞⲔ ⲞⲨⲞⲚⲦⲀⲔ ⲚⲞⲨⲚⲀϨϮ ⲘⲘⲀⲨ ⲬⲀϤ ⲚϦⲎⲦⲔ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ⲰⲞⲨⲚⲒⲀⲦϤ ⲘⲪⲎ ⲈⲦⲈⲚϤⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ⲀⲚ ϦⲈⲚⲪⲎ ⲈⲦⲈϤⲚⲀⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ⲪⲎ ⲆⲈ ⲈⲦⲞⲒ ⲚϨⲎⲦ ⲂⲈϢⲰⲠ ⲀϤϢⲀⲚⲞⲨⲰⲘ ⲀϤϨⲒⲦϤ ⲈⲠϨⲀⲠ ϪⲈ ⲚⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲀϨϮ ⲀⲚ ⲠⲈ ϨⲰⲂ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲚⲀϨϮ ⲀⲚ ⲠⲈ ⲞⲨⲚⲞⲂⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ⲤⲈⲘⲠϢⲀ ⲆⲈ ⲚⲀⲚ ⲀⲚⲞⲚ ϦⲀ ⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲞⲨ ⲚⲦⲈⲚϤⲀⲒ ϦⲀ ⲚⲒϢⲰⲚⲒ ⲚⲦⲈⲚⲒⲀⲦϪⲞⲘ ⲞⲨⲞϨ ⲚⲦⲈⲚϢⲦⲈⲘⲢⲀⲚⲀⲚ ⲘⲘⲀⲨⲀⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ⲘⲀⲢⲈϤⲢⲀⲚⲀϤ ⲘⲠⲈϤϢⲪⲎⲢ ϦⲈⲚⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲈⲨⲔⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ⲔⲈ ⲄⲀⲢ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲦⲀϤⲢⲀⲚⲀϤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚ ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲚⲒϢⲰϢ ⲚⲦⲈⲚⲎ ⲈⲦϮϢⲪⲒⲦ ⲚⲀⲔ ⲀⲨⲒ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ϨⲰⲂ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲀⲨⲈⲢϢⲞⲢⲠ ⲚⲤϦⲎ ⲦⲞⲨ ⲀⲨⲤϦⲎⲦⲞⲨ ⲈⲦⲈⲚⲤⲂⲰ ϨⲒⲚⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮϨⲨⲠⲞⲘⲞⲚⲎ ⲚⲈⲘ ϮⲘⲈⲦⲢⲈϤϮⲚⲞⲘϮ ⲚⲦⲈⲚⲒⲄⲢⲀⲪⲎ ⲚⲦⲈϮϨⲈⲖⲠⲒⲤ ϢⲰⲠⲒ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲦⲈϮϨⲒⲢⲎⲚⲎ ⲚⲈⲘ ϮⲠⲀⲢⲀⲔⲖⲎ ⲤⲒⲤ ⲈϤⲈϮ ⲚⲞⲨⲘⲈⲨⲒ ⲚⲞⲨⲰⲦ ⲚⲰⲦⲈⲚ ⲈⲚⲈⲦⲈⲚⲈⲢⲎ ⲞⲨ ⲔⲀⲦⲀ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ϨⲒⲚⲀ ϦⲈⲚⲞⲨϨⲎⲦ ⲚⲞⲨⲰⲦ ⲚⲈⲘ ⲞⲨⲢⲰ ⲚⲞⲨⲰⲦ ⲚⲦⲈⲦⲈⲚϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲪⲒⲰⲦ ⲘⲠⲈⲚϬ ⲤⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ⲈⲐⲂⲈ ⲪⲀⲒ ϢⲈⲠ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲈⲢⲰⲦⲈⲚ ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰϤ ⲈⲦⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ϢⲈⲠ ⲐⲎⲚⲞⲨ ⲈⲢⲞϤ ⲈⲨⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ϮϪⲰ ⲄⲀⲢ ⲘⲘⲞⲤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤϢⲰⲠⲒ ⲚⲞⲨⲆⲒⲀⲔⲰⲚ ⲚⲦⲈⲠⲤⲈⲂⲒ ⲈϪⲈⲚ ϮⲘⲈⲐⲚⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϪⲈⲬⲀⲤ ⲈϤⲈⲦⲀϪⲢⲈ ⲚⲒⲰϢ ⲚⲦⲈⲚⲒⲒⲞϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ⲚⲒⲈⲐⲚⲞⲤ ⲆⲈ ⲈⲐⲂⲈ ⲞⲨⲚⲀⲒ ⲈϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲈⲐⲂⲈ ⲪⲀⲒ ϮⲚⲀⲞⲨⲰⲚϨ ⲚⲀⲔ ⲈⲂⲞⲖ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲞⲨⲞϨ ϮⲚⲀⲈⲢⲮⲀⲖⲒⲚ ⲈⲠⲈⲔⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ⲞⲨⲞϨ ϤϪⲰ ⲘⲘⲞⲤ ⲞⲚ ϪⲈ ⲞⲨⲚⲞϤ ⲘⲘⲰⲦⲈⲚ ⲚⲒⲈⲐⲚⲞⲤ ⲚⲈⲘ ⲠⲈϤⲖⲀⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ⲞⲨⲞϨ ϤϪⲰ ⲘⲘⲞⲤ ⲞⲚ ϪⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ⲤⲘⲞⲨ ⲈⲠϬⲞⲒⲤ ⲘⲀⲢⲞⲨⲤⲘⲞⲨ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲖⲀⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ⲞⲨⲞϨ ϤϪⲰ ⲘⲘⲞⲤ ⲞⲚ ⲚϪⲈⲎⲤⲀⲎⲀⲤ ϪⲈ ⲈⲤⲈϢⲰⲠⲒ ⲚϪⲈⲐⲚⲞⲨⲚⲒ ⲚⲒⲈⲤⲤⲈ ⲚⲈⲘ ⲪⲎ ⲈⲐⲚⲀⲦⲰⲚϤ ⲈⲈⲢⲀⲢⲬⲰⲚ ⲈⲚⲒⲈⲐⲚⲞⲤ ⲈⲨⲈⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲢⲞϤ ⲚϪⲈⲚⲒⲈⲐⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲦⲈϮϨⲈⲖⲠⲒⲤ ⲈϤⲈⲘⲀϨ ⲐⲎⲚⲞⲨ ⲚⲢⲀϢⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϮϨⲒⲢⲎⲚⲎ ϦⲈⲚⲠϪⲒⲚⲐⲢⲈⲦⲈⲚⲚⲀϨϮ ⲈⲢⲈⲦⲈⲚⲈⲢϨⲞⲨⲞ ϦⲈⲚϮϨⲈⲖⲠⲒⲤ ϦⲈⲚϮϪⲞⲘ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ⲀⲚⲞⲔ ϨⲰ ⲚⲀⲤⲚⲎⲞⲨ ⲠⲀϨⲎⲦ ⲐⲎⲦ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲘⲈϨ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲀⲄⲀⲐⲞⲚ ⲈⲢⲈⲦⲈⲚⲘⲈϨ ϦⲈⲚⲈⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈϮⲤⲂⲰ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ϦⲈⲚ ⲞⲨⲘⲈⲦⲦⲞⲖⲘⲈⲢⲞⲤ ⲆⲈ ⲀⲒⲤϦⲀⲒ ⲚⲰⲦⲈⲚ ⲚⲞⲨⲀⲠⲞⲘⲈⲢⲞⲤ ϨⲰⲤ ⲈⲒϮ ⲘⲪⲘⲈⲨⲒ ⲚⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲠⲒϨⲘⲞⲦ ⲈⲦⲀⲨⲦⲎⲒϤ ⲚⲎⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪϮ ");
INSERT INTO copbhc_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ⲈⲐⲢⲒϢⲰⲠⲒ ⲈⲒⲞⲒ ⲚⲢⲈϤⲪⲰϢⲈⲚ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲚⲒⲈⲐⲚⲞⲤ ⲈⲒⲈⲢϨⲰⲂ ϦⲈⲚⲞⲨⲘⲈⲦⲞⲨⲎ ⲂⲈⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈϮⲠⲢⲞⲤⲪⲰⲢⲀ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ϢⲰⲠⲒ ⲈⲤϢⲎⲠ ⲞⲨⲞϨ ⲈⲤⲦⲞⲨⲂⲎⲞⲨⲦ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ⲞⲨⲞⲚⲦⲎⲒ ⲘⲘⲀⲨ ⲚⲞⲨϢⲞⲨϢⲞⲨ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ϨⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ⲞⲨ ⲄⲀⲢ ⲚⲚⲀⲈⲢⲦⲞⲖⲘⲀⲚ ⲈϪⲈ ⲞⲨⲤⲀϪⲒ ϦⲈⲚⲚⲎ ⲈⲦⲈ ⲘⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲢϨⲰⲂ ⲚϦⲎ ⲦⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ϦⲈⲚⲠⲤⲀϪⲒ ϦⲈⲚⲠϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ϦⲈⲚ ⲦϪⲞⲘ ⲚⲦⲈϨⲀⲚⲘⲎⲒⲚⲒ ⲚⲈⲘ ϨⲀⲚϢⲪⲎⲢⲒ ϦⲈⲚⲞⲨϪⲞⲘ ⲚⲦⲈⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ ϨⲰⲤⲦⲈ ⲒⲤϪⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲈⲘ ⲠⲈⲤⲔⲰϮ ϢⲀ ⲈϨⲢⲎⲒ ⲈⲠⲒⲀⲖⲖⲨⲢⲒⲔⲞⲚ ⲚⲦⲀⲘⲀϨⲞⲨ ⲈⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲚⲀⲒⲘⲈⲒ ⲚϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲠⲈ ⲈⲪⲘⲀ ⲀⲚ ⲈⲦⲀⲨϪⲈ ⲪⲢⲀⲚ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲘⲞϤ ϨⲒⲚⲀ ⲚⲦⲀϢⲦⲈⲘⲔⲰⲦ ⲈϪⲈⲚ ⲞⲨⲤⲈⲚϮ ⲚϢⲈⲘⲘⲞ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲈⲨⲈⲚⲀⲨ ⲚϪⲈⲚⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲦⲀⲘⲰⲞⲨ ⲈⲐⲂⲎ ⲦϤ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈ ⲘⲠⲞⲨⲤⲰⲦⲈⲘ ⲈⲨⲈⲔⲀϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲒⲦⲀϨⲚⲞ ⲚⲞⲨⲘⲎϢ ⲚⲤⲞⲠ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ϮⲚⲞⲨ ⲆⲈ ⲘⲘⲞⲚϮ ⲘⲀ ϦⲈⲚⲚⲀⲒⲤⲀ ⲞⲨⲞⲚ ⲞⲨⲘⲈⲒ ⲚϨⲞⲨⲞ ⲆⲈ ϢⲞⲠ ⲚϦⲎⲦ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ ⲒⲤ ⲞⲨⲘⲎϢ ⲚⲢⲞⲘⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ϨⲰⲤ ⲈⲒⲚⲀϢⲈⲚⲎⲒ ⲈϮⲤⲠⲀⲚⲒⲀ ϮⲈⲢϨⲈⲖⲠⲒⲤ ⲄⲀⲢ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ⲈⲒⲚⲀϢⲈ ⲚⲎⲒ ⲈⲘⲀⲨ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲦⲪⲞⲒ ⲚⲐⲰⲦⲈⲚ ⲈⲘⲀⲨ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲤⲒ ⲘⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲀⲠⲞⲘⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ϮⲚⲞⲨ ⲆⲈ ϮⲚⲀϢⲈ ⲚⲎⲒ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲈϢⲈⲘϢⲒ ⲚⲚⲎ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ⲀⲨϮⲘⲀϮ ⲄⲀⲢ ⲚϪⲈⲚⲀⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲚⲈⲘ ⲀⲬⲀⲒⲀ ⲈⲒⲢⲒ ⲚⲞⲨⲘⲈⲦϢⲪⲎⲢ ⲈⲚⲒϨⲎⲔⲒ ⲚⲦⲈⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲚⲎ ⲈⲦϦⲈⲚ ⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ⲀⲨϮⲘⲀϮ ⲄⲀⲢ ⲞⲨⲞϨ ⲞⲨⲞⲚ ⲈⲢⲰⲞⲨ ⲚⲦⲰⲞⲨ ⲒⲤϪⲈ ⲄⲀⲢ ⲚⲒⲈⲐⲚⲞⲤ ⲈⲢϢⲪⲎⲢ ⲈⲢⲰⲞⲨ ϦⲈⲚⲞⲨⲠⲚⲀⲦⲒⲔⲞⲚ ⲤⲈⲘⲠϢⲀ ⲚⲤⲈϢⲈⲘϢⲎⲦⲞⲨ ϦⲈⲚⲚⲒⲔⲈⲤⲀⲢⲔⲒⲔⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ⲪⲀⲒ ⲞⲨⲚ ⲀⲒϢⲀⲚϪⲞⲔϤ ⲈⲂⲞⲖ ⲚⲦⲀⲈⲢⲤⲪⲢⲀⲄⲒⲌⲒⲚ ⲘⲠⲀⲒⲞⲨⲦⲀϨ ⲚⲰⲞⲨ ⲈⲒⲈϢⲈ ⲚⲎⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϮⲤⲠⲀⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ϮⲤⲰⲞⲨⲚ ⲆⲈ ϪⲈ ⲀⲒⲚⲎⲞⲨ ϨⲀⲢⲰⲦⲈⲚ ⲀⲒⲚⲎⲞⲨ ϦⲈⲚⲞⲨⲘⲞϨ ⲚⲤⲘⲞⲨ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ϮϮϨⲞ ⲞⲨⲚ ⲈⲢⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲀⲄⲀⲠⲎ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲢⲈⲦⲈⲚⲈⲢⲀⲄⲰⲚⲒⲌⲈⲤⲐⲈ ⲚⲈⲘⲎⲒ ϦⲈⲚⲚⲈⲦⲈⲚⲠⲢⲞⲤⲈⲨⲬⲎ ⲈϨⲢⲎⲒ ⲈϪⲰⲒ ϨⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ϨⲒⲚⲀ ⲚⲦⲀⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϨⲀ ⲚⲎ ⲈⲦⲞⲒ ⲚⲀⲦⲤⲰⲦⲈⲘ ϦⲈⲚϮⲒⲞⲨⲆⲈⲀ ⲞⲨⲞϨ ⲦⲀⲆⲒⲀⲔⲞⲚⲒⲀ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ ⲚⲦⲈⲤϢⲰⲠⲒ ⲈⲤϢⲎⲠ ⲈⲚⲒⲀⲄⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ϨⲒⲚⲀ ⲀⲒϢⲀⲚⲒ ϨⲀⲢⲰⲦⲈⲚ ϦⲈⲚⲞⲨⲢⲀϢⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲦⲈϨⲚⲈ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲦⲀⲘⲦⲞⲚ ⲘⲘⲞⲒ ⲚⲈⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲦⲈϮϨⲒⲢⲎⲚⲎ ϤⲬⲎ ⲚⲈⲘⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲀⲘⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ϮϮϨⲞ ⲆⲈ ⲘⲪⲞⲒⲂⲎ ⲦⲈⲚⲤⲰⲚⲒ ⲈⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲦⲈ ⲞⲨⲢⲈϤϢⲈⲘϢⲒ ϨⲰⲤⲦⲈ ⲚⲦⲈϮⲈⲔⲔⲖⲎ ⲤⲒⲀ ⲈⲦϦⲈⲚ ⲔⲈⲚⲬⲢⲈⲈⲤ ");
INSERT INTO copbhc_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲞⲠⲤ ⲈⲢⲰⲦⲈⲚ ϦⲈⲚⲠϬⲞⲒⲤ ϦⲈⲚⲠⲈⲘⲠϢⲀ ⲚⲦⲈⲚⲎ ⲈⲐⲞⲨⲀⲂ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϮⲦⲞⲦⲤ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲤⲚⲀⲈⲢⲬ ⲢⲒⲀ ⲘⲘⲰⲦⲈⲚ ⲚϦⲎⲦⲞⲨ ⲔⲈ ⲄⲀⲢ ⲚⲐⲞⲤ ϨⲰⲤ ⲀⲤϢⲰⲠⲒ ϦⲀϪⲈⲚ ⲞⲨⲘⲎϢ ⲠⲈⲘⲎⲒ ϨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ϢⲒⲚⲒ ⲈⲠⲢⲒⲤⲔⲨⲖⲖⲀ ⲚⲈⲘ ⲀⲔⲨⲖⲖⲀ ⲚⲀϢⲪⲎⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ⲚⲀⲒ ⲈⲦⲀⲨϮ ⲚⲦⲞⲨⲚⲀϨⲂⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲦⲀⲮⲨⲬⲎ ⲚⲀⲒ ⲈⲦⲈ ⲀⲚⲞⲔ ⲘⲘⲀⲨⲀⲦ ⲀⲚ ⲈⲦϢⲈⲠϨⲘⲞⲦ ⲚⲦⲞⲦⲞⲨ ⲀⲖⲖⲀ ⲚⲈⲘ ⲚⲒⲔⲈⲈⲔⲔⲖⲎ ⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲚⲒⲈⲐⲚⲞⲤ ⲚⲈⲘ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲠⲞⲨⲎⲒ ");
INSERT INTO copbhc_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ϢⲒⲚⲒ ⲈⲠⲈⲚⲈⲦⲞⲤ ⲠⲀⲀⲄⲀⲠⲎⲦⲞⲤ ⲈⲦⲈ ⲚⲐⲞϤ ⲠⲈ ϮⲀⲢⲬⲎ ⲚⲦⲈϮⲀⲤⲒⲀ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ϢⲒⲚⲒ ⲈⲘⲀⲢⲒⲀ ⲐⲎ ⲈⲦⲀⲤϬⲒ ⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ϦⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ϢⲒⲚⲒ ⲈⲀⲚⲆⲢⲞⲚⲒⲔⲞⲤ ⲚⲈⲘ ⲒⲞⲨⲖⲒⲀ ⲚⲀⲤⲨⲄⲄⲈⲚⲎ ⲤⲞⲨⲞϨ ⲚⲀϢⲪⲎⲢ ⲚⲈⲬⲘⲀⲖⲰⲦⲞⲤ ⲈⲦⲈ ϨⲀⲚⲤⲞⲨⲒⲚ ⲚⲈϦⲈⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲀⲒ ⲈⲦⲈ ϨⲀⲚϢⲞⲢⲠ ⲈⲢⲞⲒ ⲚⲈϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ϢⲒⲚⲒ ⲈⲀⲘⲠⲖⲒⲀⲦⲞⲤ ⲠⲀⲀⲄⲀⲠⲎⲦⲞⲤ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ϢⲒⲚⲒ ⲈⲞⲨⲢⲂⲀⲚⲞⲤ ⲚⲈⲚϢⲪⲎⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ⲤⲦⲀⲬⲎⲤ ⲠⲀⲀⲄⲀⲠⲎⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ϢⲒⲚⲒ ⲈⲀⲠⲈⲖⲖⲎⲤ ⲠⲒⲤⲰⲦⲠ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ϢⲒⲚⲒ ⲈⲚⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲀⲢⲒⲤⲦⲞⲂⲞⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ϢⲒⲚⲒ ⲈⲎⲢⲰⲆⲒⲞⲚ ⲠⲀⲤⲨⲄⲄⲈⲚⲎⲤ ϢⲒⲚⲒ ⲈⲚⲎ ⲈⲦϢⲞⲠ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀⲚⲀⲢⲔⲨⲤⲞⲤ ⲚⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ϢⲒⲚⲒ ⲈⲦⲢⲒⲪⲰⲚⲀ ⲚⲈⲘ ⲦⲢⲨⲪⲰⲤⲀ ⲚⲎ ⲈⲦϦⲞⲤⲒ ϦⲈⲚⲠϬⲞⲒⲤ ϢⲒⲚⲒ ⲈⲠⲈⲢⲤⲒⲆⲀ ϮⲘⲈⲚⲢⲒⲦ ⲐⲎ ⲈⲦⲀⲤϬⲒ ⲞⲨⲘⲎϢ ⲚϦⲒⲤⲒ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ϢⲒⲚⲒ ⲈⲢⲞⲨⲪⲞⲤ ⲠⲒⲤⲰⲦⲠ ϦⲈⲚⲠϬⲞⲒⲤ ⲚⲈⲘ ⲦⲈϤⲘⲀⲨ ⲞⲨⲞϨ ⲐⲰⲒ ϨⲰ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ϢⲒⲚⲒ ⲈⲀⲤⲨⲚⲔⲢⲒⲦⲞⲤ ⲪⲖⲎⲄⲞⲚⲦⲀ ⲈⲢⲘⲎ ⲠⲀⲦⲢⲞⲂⲀ ⲈⲢⲘⲀ ⲚⲈⲘ ⲚⲒⲔⲈⲤⲚⲎⲞⲨ ⲈⲐⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ϢⲒⲚⲒ ⲈⲪⲨⲖⲞⲖⲞⲄⲞⲤ ⲚⲈⲘ ⲒⲞⲨⲖⲒⲀ ⲚⲈⲢⲈⲀ ⲚⲈⲘ ⲦⲈϤⲤⲰⲚⲒ ⲚⲈⲘ ⲞⲨⲨⲘⲠⲀⲚ ⲚⲈⲘ ⲚⲒⲀⲄⲒⲞⲤ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲈⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ⲀⲢⲒⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ϦⲈⲚⲞⲨⲪⲒ ⲈⲤⲞⲨⲀⲂ ⲤⲈϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲈⲔⲔⲖⲎ ⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ϮϮϨⲞ ⲈⲢⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲐⲢⲈⲦⲈⲚϮϨⲐⲎⲦⲈⲚ ⲈⲚⲎ ⲈⲦⲒⲢⲒ ⲚⲚⲒⲪⲰⲢϪ ⲚⲈⲘ ⲚⲒⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲤⲀⲂⲞⲖ ⲚϮⲤⲂⲰ ⲈⲦⲀⲢⲈⲦⲈⲚⲦⲤⲀⲂⲞ ⲈⲢⲞⲤ ⲞⲨⲞϨ ⲢⲈⲔ ⲐⲎⲚⲞⲨ ⲤⲀⲂⲞⲖ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ⲚⲀⲒ ⲄⲀⲢ ⲘⲠⲀⲒⲢⲎϮ ⲤⲈⲞⲒ ⲘⲂⲰⲔ ⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ⲚⲦⲞⲨⲚⲈϪⲒ ⲞⲨⲞϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲦⲞⲨϪⲒⲚⲤⲀϪⲒ ⲈⲦϨⲞⲖϪ ⲚⲈⲘ ⲠⲞⲨⲤⲘⲞⲨ ϢⲀⲨⲈⲢϨⲀⲖ ⲘⲠϨⲎⲦ ⲚⲚⲒⲀⲦⲔⲀⲔⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ⲦⲈⲦⲈⲚⲘⲈⲦⲢⲈϤⲤⲰⲦⲈⲘ ⲄⲀⲢ ⲀⲤϢⲈ ⲚⲀⲤ ϢⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϮⲢⲀϢⲒ ⲞⲨⲚ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲤⲀⲂⲈ ϦⲈⲚⲠⲒⲠⲈⲐⲚⲀⲚⲈϤ ⲀⲔⲈⲢⲈⲞⲤ ⲆⲈ ⲈⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ⲪⲚⲞⲨϮ ⲆⲈ ⲚⲦⲈϮϨⲒⲢⲎⲚⲎ ⲈϤⲈϦⲞⲘϦⲈⲘ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ϦⲀ ⲚⲈⲦⲈⲚϬⲀⲖⲀⲨϪ ⲚⲬⲰⲖⲈⲘ ⲠϨⲘⲞⲦ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ϤϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲦⲒⲘⲞⲐⲈⲞⲤ ⲠⲀϢⲪⲎ ⲢⲚⲢⲈϤⲈⲢϨⲰⲂ ⲚⲈⲘ ⲖⲞⲨⲔⲒⲞⲤ ⲚⲈⲘ ⲒⲀⲤⲤⲰⲚ ⲚⲈⲘ ⲤⲰⲤⲒⲠⲀⲦⲢⲞⲤ ⲠⲀⲤⲨⲄⲄⲈⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ϮϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲀⲚⲞⲔ ⲦⲈⲢⲦⲒⲞⲤ ⲪⲎ ⲈⲦⲀϤⲤϦⲈ ⲦⲀⲒⲈⲠⲒⲤⲦⲞⲖⲎ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ϤϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲄⲀⲒⲞⲤ ⲠⲀϢⲈⲘⲘⲞ ⲚⲈⲘ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ϤϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲀⲢⲀⲤⲦⲞⲤ ⲠⲒⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲦⲈϮⲠⲞⲖⲒⲤ ⲚⲈⲘ ⲔⲞⲨⲀⲢⲦⲞⲤ ⲠⲒⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ⲠϨⲘⲞⲦ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲀⲘⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲦⲀϪⲢⲈ ⲐⲎⲚⲞⲨ ⲔⲀⲦⲀ ⲠⲀⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲈⲘ ⲠⲒϨⲒⲰⲒϢ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲔⲀⲦⲀ ⲞⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚⲦⲈⲞⲨⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲈⲀⲨⲬⲀⲢⲰⲞⲨ ⲈⲢⲞϤ ⲈϨⲀⲚⲤⲎ ⲞⲨ ⲚⲈⲚⲈϨ. ");
INSERT INTO copbhc_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ϮⲚⲞⲨ ⲆⲈ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲒⲄⲢⲀⲪⲎ ⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ⲔⲀⲦⲀ ⲠⲒⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲒϢⲀ ⲈⲚⲈϨ ⲈⲀⲨⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ⲈⲨⲤⲰⲦⲈⲘ ⲚⲦⲈⲪⲚⲀϨϮ ϦⲈⲚⲚⲒⲈⲐⲚⲞⲤ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ⲠⲒⲞⲨⲀⲒ ⲘⲘⲀⲨⲀⲦϤ ⲠⲒⲤⲀⲂⲈ ⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲀⲒ ⲈⲦⲈ ⲪⲰϤ ⲠⲈ ⲠⲒⲰⲞⲨ ϢⲀ ⲈⲚⲈϨ ⲚⲦⲈⲚⲒⲈⲚⲈϨ ⲀⲘⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲦⲐⲀϨⲈⲘ ⲚⲦⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲞⲨⲰϢ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲤⲰⲤⲐⲈⲚⲎⲤ ⲠⲒⲤⲞⲚ ");
INSERT INTO copbhc_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲐⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲔⲞⲢⲒⲚⲐⲞⲤ ⲚⲎ ⲈⲦⲀⲨⲦⲞⲨⲂⲰⲞⲨ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲚⲎ ⲈⲦⲐⲀϨⲈⲘ ⲈⲐⲞⲨⲀⲂ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲘⲞⲨϮ ⲈⲪⲢⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ⲚⲦⲰⲞⲨ ⲚⲈⲘ ⲚⲦⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ⲠϨⲘⲞⲦ ⲚⲰⲦⲈⲚ ⲚⲈⲘ ⲦϨⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲠⲈⲚⲒⲰⲦ ⲚⲈⲘ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ϮϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲠⲀⲚⲞⲨϮ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲈⲘ ⲈϪⲈⲚ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲀⲨⲦⲎⲒϤ ⲚⲰⲦⲈⲚ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ϪⲈ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲦⲈⲦⲈⲚⲈⲢⲢⲀⲘⲀⲞ ⲚϦⲢⲎⲒ ⲚϦⲎⲦϤ ϦⲈⲚⲤⲀϪⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲈⲘⲒ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ϮⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲀϪⲢⲞ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ϨⲰⲤⲦⲈ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲚⲦⲈⲦⲈⲚϢⲀⲦ ⲀⲚ ϦⲈⲚϨⲖⲒ ⲚϨⲘⲞⲦ ⲈⲢⲈⲦⲈⲚϪⲞⲨϢⲦ ⲈⲂⲞⲖ ϦⲀⲦϨⲎ ⲘⲠⲒϬⲰⲢⲠ ⲈⲂⲞⲖ ⲚⲦⲈⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲤ ");
INSERT INTO copbhc_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ⲪⲀⲒ ⲈⲦⲈ ⲈϤⲈⲦⲀϪⲢⲈ ⲐⲎⲚⲞⲨ ϢⲀ ⲈⲂⲞⲖ ⲚⲀⲦⲀⲢⲒⲔⲒ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ϤⲈⲚϨⲞⲦ ⲚϪⲈⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲀϤⲐⲀϨⲈⲘ ⲐⲎⲚⲞⲨ ⲈϦⲞⲨⲚ ⲈϮⲘⲈⲦϢⲪⲎⲢ ⲚⲦⲈⲠⲈϤϢⲎⲢⲒ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ϮϮϨⲞ ⲞⲨⲚ ⲈⲢⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲢⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲒⲚⲀ ⲞⲨⲤⲀϪⲒ ⲚⲞⲨⲰⲦ ⲈⲢⲈⲦⲈⲚϪⲰ ⲘⲘⲞϤ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲦⲈϢⲦⲈⲘ ϨⲀⲚⲪⲰⲢϪ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲆⲈ ⲈⲢⲈⲦⲈⲚⲤⲈⲂⲦⲰⲦ ϦⲈⲚⲞⲨϨⲎⲦ ⲚⲞⲨⲰⲦ ⲚⲈⲘ ⲞⲨⲄⲚⲰⲘⲎ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ⲀⲨⲦⲀⲘⲞⲒ ⲄⲀⲢ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ⲚⲀⲤⲚⲎ ⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲚⲀⲬⲖⲞⲎⲤ ϪⲈ ⲞⲨⲞⲚ ϨⲀⲚϢϬⲚⲎⲚ ϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ⲪⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ϪⲈ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲞⲔ ⲪⲀ ⲠⲀⲨⲖⲞⲤ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲪⲀ ⲀⲠⲞⲖⲖⲰ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲪⲀ ⲔⲎⲪⲀ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚⲞⲔ ⲪⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ⲀⲨⲪⲈϢ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲎ ⲠⲀⲨⲖⲞⲤ ⲀⲨⲀϢϤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲒⲈ ⲀⲚ ⲀⲢⲈⲦⲈⲚϬⲒⲰⲘⲤ ⲈⲪⲢⲀⲚ ⲘⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ϮϢⲈⲠϨⲘⲞⲦ ϪⲈ ⲘⲠⲒϮⲰⲘⲤ ⲚϨⲖⲒ ⲘⲘⲰⲦⲈⲚ ⲈⲂⲎⲖ ⲈⲔⲢⲒⲤⲠⲞⲤ ⲚⲈⲘ ⲄⲀⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲞⲨⲀⲒ ϪⲞⲤ ϪⲈ ⲀⲢⲈⲦⲈⲚϬ ⲒⲰⲘⲤ ⲈⲠⲀⲢⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ⲀⲒϮⲰⲘⲤ ⲆⲈ ⲘⲠⲔⲈⲎⲒ ⲚⲤⲦⲈⲪⲀⲚⲀ ⲖⲞⲒⲠⲞⲚ ⲚϮⲈⲘⲒ ⲀⲚ ϪⲈ ⲀⲚ ⲀⲒϮⲰⲘⲤ ⲚⲔⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ⲚⲈⲦⲀϤⲦⲀⲞⲨⲞⲒ ⲄⲀⲢ ⲀⲚ ⲚϪⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲈϮⲰⲘⲤ ⲀⲖⲖⲀ ⲈϨⲒϢⲈⲚⲚⲞⲨϤⲒ ϦⲈⲚⲞⲨⲤⲂⲰ ⲚⲤⲀϪⲒ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲦⲈⲘϢⲰⲠⲒ ⲈϤϢⲞⲨⲒⲦ ⲚϪⲈⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ⲠⲒⲤⲀϪⲒ ⲄⲀⲢ ⲚⲦⲈⲠⲒⲤⲦⲀⲨⲢⲞⲤ ⲚⲦⲈⲚ ⲚⲎ ⲘⲈⲚ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲞⲨⲘⲈⲦⲤⲞϪ ⲠⲈ ⲚⲀⲚ ⲆⲈ ⲀⲚⲞⲚ ϦⲀ ⲚⲎ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲞⲨϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ϮⲚⲀⲦⲀⲔⲞ ⲚⲦⲤⲞⲪⲒⲀ ⲚⲦⲈⲚⲒⲤⲀⲂⲈⲨ ⲞⲨⲞϨ ⲠⲈⲘⲒ ⲚⲦⲈⲚⲒⲔⲀⲦϨⲎ ⲦϮⲚⲀϢⲞϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ⲀϤⲐⲰⲚ ⲞⲨⲤⲀⲂⲈ ⲀϤⲐⲰⲚ ⲞⲨⲤⲀϦ ⲀϤⲐⲰⲚ ⲞⲨⲢⲈϤϦⲞⲦϦⲈⲦ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲘⲎ ⲘⲠⲈ ⲪⲚⲞⲨϮ ⲈⲢ ⲦⲤⲞⲪⲒⲀ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲤⲞϪ. ");
INSERT INTO copbhc_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ⲈⲠⲒⲆⲎ ⲄⲀⲢ ⲈⲂⲞⲖ ϦⲈⲚϮⲤⲞⲪⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲘⲠⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲤⲞⲨⲈⲚ ⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲤⲞⲪⲒⲀ ⲀϤϮⲘⲀϮ ⲚϪⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲘⲈⲦⲤⲞϪ ⲚⲦⲈⲠⲒϨⲒⲰⲒϢ ⲈⲚⲞϨⲈⲘ ⲚⲚⲎ ⲈⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ⲈⲠⲒⲆⲎ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲤⲈⲈⲢⲈⲦⲒⲚ ⲚϨⲀⲚⲘⲎⲒⲚⲒ ⲞⲨⲞϨ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲤⲈⲔⲰϮ ⲚⲤⲀϮⲤⲞⲪⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ⲀⲚⲞⲚ ⲆⲈ ⲦⲈⲚϨⲒⲰⲒϢ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲀⲨⲀϢϤ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲈⲚ ⲞⲨⲤⲔⲀⲚⲆⲀⲖⲞⲚ ⲚⲰⲞⲨ ⲠⲈ ⲚⲒⲈⲐⲚⲞⲤ ⲆⲈ ⲞⲨⲘⲈⲦⲤⲞϪ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ⲚⲀⲚ ⲆⲈ ⲀⲚⲞⲚ ϦⲀ ⲚⲎ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ ⲚⲈⲘ ⲞⲨⲤⲞⲪⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ϪⲈ ϮⲘⲈⲦⲤⲞϪ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲞⲒ ⲚⲤⲀⲂⲈ ⲈϨⲞⲦⲈ ⲚⲒⲢⲰⲘⲒ ⲞⲨⲞϨ ϮⲘⲈⲦⲀⲤⲐⲎⲚⲎⲤ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲞⲒ ⲚϪⲰⲢⲒ ⲈϨⲞⲦⲈ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ⲀⲚⲀⲨ ⲄⲀⲢ ⲈⲠⲈⲦⲈⲚⲐⲰϨⲈⲘ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲘⲘⲞⲚ ⲞⲨⲘⲎϢ ⲚⲤⲀⲂⲈ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲘⲘⲞⲚ ⲞⲨⲘⲎϢ ⲚϪⲰⲢⲒ ⲘⲘⲞⲚ ⲞⲨⲘⲎϢ ⲚⲈⲨⲄⲈⲚⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ⲀⲖⲖⲀ ⲚⲒⲤⲞϪ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀϤⲤⲞⲦⲠⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈϤϮϢⲒⲠⲒ ⲚⲚⲒⲤⲀⲂⲈⲨ ⲞⲨⲞϨ ⲚⲒⲘⲈⲦϪⲰⲂ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲀϤⲤⲞⲦⲠⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈϤϮϢⲒⲠⲒ ⲚⲚⲒϪⲰⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ⲞⲨⲞϨ ⲚⲒⲘⲈⲦⲀⲄⲈⲚⲎⲤ ⲚⲦⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲞϢϤ ⲀϤⲤⲞⲦⲠⲞⲨ ⲚϪⲈⲪⲚⲞⲨϮ ⲚⲈⲘ ⲚⲎ ⲈⲦⲈⲚⲤⲈϢⲞⲠ ⲀⲚ ϨⲒⲚⲀ ⲚⲦⲈϤⲔⲞⲢϤ ⲚⲚⲎ ⲈⲦϢⲞⲠ. ");
INSERT INTO copbhc_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ϨⲞⲠⲰⲤ ⲚⲦⲈϢⲦⲈⲘ ⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ϢⲞⲨϢⲞⲨ ⲘⲘⲰⲞⲨ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ⲚⲐⲰⲦⲈⲚ ⲈⲂⲞⲖ ⲘⲘⲞϤ ϨⲰⲦⲈⲚ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲪⲎ ⲈⲦⲀϤϢⲰⲠⲒ ⲚⲀⲚ ⲚⲞⲨⲤⲞⲪⲒⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲚⲈⲘ ⲞⲨⲦⲞⲨⲂⲞ ⲚⲈⲘ ⲞⲨⲤⲰϮ. ");
INSERT INTO copbhc_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ϨⲒⲚⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲠⲈⲦϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ⲘⲀⲢⲈϤϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ⲞⲨⲞϨ ⲀⲚⲞⲔ ϨⲰ ⲈⲦⲀⲒⲒ ϨⲀⲢⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲚⲈⲦⲀⲒⲒ ⲀⲚ ⲔⲀⲦⲀ ⲞⲨϬⲒⲤⲒ ⲚⲦⲈⲞⲨⲤⲀϪⲒ ⲒⲈ ⲞⲨⲤⲞⲪⲒⲀ ⲀⲒⲦⲀⲘⲞ ⲘⲘⲰⲦⲈⲚ ⲈⲠⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ⲘⲠⲒϮϨⲀⲠ ⲄⲀⲢ ⲈⲈⲘⲒ ⲈϨⲖⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲂⲎⲖ ⲈⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲪⲀⲒ ⲀⲨⲀϢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ⲀⲚⲞⲔ ϨⲰ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲤⲐⲈⲚⲎⲤ ⲚⲈⲘ ⲞⲨϨⲞϮ ⲚⲈⲘ ⲞⲨⲤⲐⲈⲢⲦⲈⲢ ⲈⲚⲀϢⲰϤ ⲀⲒⲒ ϨⲀⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ⲞⲨⲞϨ ⲠⲀⲤⲀϪⲒ ⲚⲈⲘ ⲠⲀϨⲒⲰⲒϢ ⲚⲀϤϦⲈⲚ ϨⲀⲚⲐⲰⲦ ⲚϨⲎⲦ ⲀⲚ ⲚⲦⲈϨⲀⲚⲤⲀϪⲒ ⲚⲤⲞⲪⲒⲀ ⲚⲢⲰⲘⲒ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈⲞⲨⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲞⲨϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ϨⲒⲚⲀ ⲠⲈⲦⲈⲚⲚⲀϨϮ ⲚⲦⲈϤϢⲦⲈⲘϢⲰⲠⲒ ϦⲈⲚⲞⲨⲤⲞⲪⲒⲀ ⲚⲢⲰⲘⲒ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨϪⲞⲘ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ⲞⲨⲤⲞⲪⲒⲀ ⲆⲈ ⲠⲈⲦⲈⲚⲤⲀϪⲒ ⲘⲘⲞⲤ ϦⲈⲚⲚⲎ ⲈⲦϪⲎⲔ ⲈⲂⲞⲖ ⲞⲨⲤⲞⲪⲒⲀ ⲆⲈ ⲚⲐⲀ ⲠⲀⲒⲈⲚⲈϨ ⲀⲚ ⲦⲈ ⲞⲨⲆⲈ ⲚⲐⲀ ⲚⲒⲀⲢⲬⲰⲚ ⲀⲚ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲚⲀⲒ ⲈⲐⲚⲀⲔⲰⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ⲀⲖⲖⲀ ⲞⲨⲤⲞⲪⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲈⲚⲤⲀϪⲒ ⲘⲘⲞⲤ ϦⲈⲚⲞⲨⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲐⲎ ⲈⲦϨⲎⲠ ⲐⲎ ⲈⲦⲀϤⲈⲢϢⲞⲢⲠ ⲚⲐⲀϢⲤ ⲚϪⲈⲪⲚⲞⲨϮ ϦⲀϪⲰⲞⲨ ⲚⲚⲒⲈⲚⲈϨ ⲈⲨⲰⲞⲨ ⲚⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ⲐⲎ ⲈⲦⲈ ⲘⲠⲈ ϨⲖⲒ ⲚⲚⲒⲀⲢⲬⲰⲚ ⲚⲦⲈⲠⲀⲒⲈⲚⲈϨ ⲤⲞⲨⲰⲚⲤ ⲈⲚⲈⲀⲨⲤⲞⲨⲰⲚⲤ ⲄⲀⲢ ⲚⲀⲨⲚⲀⲈϢ ⲠϬⲞⲒⲤ ⲚⲦⲈⲠⲰⲞⲨ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ⲀⲖⲖⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲚⲎ ⲈⲦⲈ ⲘⲠⲈ ⲂⲀⲖ ⲚⲀⲨ ⲈⲢⲰⲞⲨ ⲞⲨⲆⲈ ⲘⲠⲈ ⲘⲀϢϪ ⲤⲞⲐⲘⲞⲨ ⲞⲨⲞϨ ⲘⲠⲞⲨϢⲈ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠϨⲎⲦ ⲚⲢⲰⲘⲒ ⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲤⲈⲂⲦⲰⲦⲞⲨ ⲚⲚⲎ ⲈⲐⲚⲀⲘⲈⲚⲢⲒⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ⲀⲚⲞⲚ ⲆⲈ ⲀϤϬⲞⲢⲠⲞⲨ ⲚⲀⲚ ⲈⲂⲞⲖ ⲚϪⲈⲪⲚⲞⲨϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀⲠⲒⲠⲚⲈⲨⲘⲀⲄⲀⲢ ϤϦⲞⲦϦⲈⲦ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲚⲎ ⲈⲦϢⲎⲔ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ⲚⲒⲘ ⲄⲀⲢ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲈⲦⲤⲰⲞⲨⲚ ⲚⲚⲀ ⲠⲒⲢⲰⲘⲒ ⲈⲂⲎⲖ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲒⲢⲰⲘⲒ ⲈⲦϢⲞⲠ ⲚϦⲎⲦϤ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲀ ⲪⲚⲞⲨϮ ⲘⲠⲈ ϨⲖⲒ ⲈⲘⲒ ⲈⲢⲰⲞⲨ ⲈⲂⲎⲖ ⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ⲀⲚⲞⲚ ⲆⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲀⲚ ⲠⲈⲦⲀⲚϬⲒⲦϤ ⲀⲖⲖⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲠⲒⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ϨⲒⲚⲀ ⲚⲦⲈⲚⲈⲘⲒ ⲈⲚⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲦⲎⲒⲦⲞⲨ ⲚⲀⲚ ⲚϨⲘⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ⲈⲦⲈ ⲚⲀⲒ ⲚⲈⲈⲦⲈⲚⲤⲀϪⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚϨⲀⲚⲘⲈⲦⲢⲈϤϮⲤⲂⲰ ⲚⲚⲒⲢⲰⲘⲒ ⲀⲚ ⲚⲦⲈϨⲀⲚⲤⲀϪⲒ ⲚⲤⲞⲪⲒⲀ ⲀⲖⲖⲀ ϦⲈⲚϨⲀⲚⲘⲈⲦⲢⲈϤϮⲤⲂⲰ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲚⲈⲢⲤⲨⲚⲔⲢⲒⲚⲒⲚ ⲚϨⲀⲚⲠⲚⲀⲦⲒⲔⲞⲚ ⲚⲚⲒⲠⲚⲀⲦⲒⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ⲠⲒⲮⲨⲬⲒⲔⲞⲤ ⲆⲈ ⲚⲢⲰⲘⲒ ⲘⲠⲀϤϢⲈⲠ ⲚⲀ ⲠⲒⲠⲚⲈⲨⲘⲀⲪⲚⲞⲨϮ ⲈⲢⲞϤ ⲞⲨⲘⲈⲦⲤⲞϪ ⲄⲀⲢ ⲚⲀϤ ⲠⲈ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲈⲘⲒ ϪⲈ ⲀⲨϦⲞⲦϦⲈⲦ ⲘⲘⲞϤ ⲠⲚⲀⲦⲒⲔⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ⲠⲒⲠⲚⲀⲦⲒⲔⲰⲤ ⲆⲈ ⲚⲐⲞϤ ϢⲀϤϦⲈⲦϦⲈⲦ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲚⲐⲞϤ ⲆⲈ ⲘⲠⲀⲢⲈ ϨⲖⲒ ϢϦⲈⲦϦⲰⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲦⲀϤⲈⲘⲒ ⲈⲠϨⲎⲦ ⲘⲠϬⲞⲒⲤ ⲈⲘⲘⲞⲚ ⲚⲒⲘ ⲈⲐⲚⲀϢⲦⲤⲀⲂⲞϤ ⲀⲚⲞⲚ ⲆⲈ ⲠϨⲎⲦ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲦⲈⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ⲀⲚⲞⲔ ⲆⲈ ϨⲰ ⲚⲀⲤⲚⲎⲞⲨ ⲘⲠⲒϢϪⲈⲘϪⲞⲘ ⲈⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲠⲚⲀⲦⲒⲔⲰⲤ ⲀⲖⲖⲀ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲤⲀⲢⲔⲒⲔⲰⲤ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲚⲀⲖⲰⲞⲨⲒ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ⲀⲒⲦⲤⲈ ⲐⲎⲚⲞⲨ ⲚⲞⲨⲈⲢⲰϮ ⲚⲞⲨϦⲢⲈ ⲀⲚ ⲦⲈ ⲚⲈⲘⲠⲀⲦⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ ⲄⲀⲢ ⲠⲈ ⲀⲖⲖⲀ ⲞⲨⲆⲈ ϮⲚⲞⲨ ⲘⲠⲀⲦⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ⲈⲦⲒ ⲄⲀⲢ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲀⲢⲔⲒⲔⲞⲤ ϨⲰⲤ ⲄⲀⲢ ⲈⲞⲨⲞⲚ ⲞⲨⲬⲞϨ ⲚⲈⲘ ⲞⲨϢϬⲚⲎⲚ ϦⲈⲚⲐⲎⲚⲞⲨ ⲘⲎ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲀⲢⲔⲒⲔⲞⲤ ⲀⲚ ⲞⲨⲞϨ ⲀⲦⲈⲦⲈⲚⲘⲞϢⲒ ⲔⲀⲦⲀ ⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ⲈϢⲰⲠ ⲄⲀⲢ ⲚⲦⲈⲞⲨⲀⲒ ϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲘⲈⲚ ⲀⲚⲞⲔ ⲪⲀ ⲠⲀⲨⲖⲞⲤ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ϪⲈ ⲀⲚⲞⲔ ⲪⲀ ⲀⲠⲞⲖⲖⲰ ⲞⲨⲬⲒ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ⲞⲨ ⲞⲨⲚ ⲠⲈ ⲀⲠⲞⲖⲖⲰ ⲞⲨ ⲆⲈ ⲠⲀⲨⲖⲞⲤ ϨⲀⲚⲆⲒⲀⲔⲰⲚ ⲚⲈⲈⲀⲢⲈⲦⲈⲚⲚⲀϨϮ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲠϬⲞⲒⲤ ϮⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ⲀⲚⲞⲔ ⲀⲒⲦⲰϪⲒ ⲀⲠⲞⲖⲖⲰ ⲀϤⲦⲤⲞ ⲀⲖⲖⲀ ⲪⲚⲞⲨϮ ⲀϤⲐⲢⲞⲨⲀⲒⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ϨⲰⲤⲦⲈ ⲞⲨⲆⲈ ⲪⲎ ⲈⲦⲦⲰϪⲒ ⲞⲨⲆⲈ ⲪⲎ ⲈⲦⲦⲤⲞ ϨⲖⲒ ⲠⲈ ⲀⲖⲖⲀ ⲪⲚⲞⲨϮ ⲈⲦⲐⲢⲞ ⲘⲘⲰⲞⲨ ⲈⲀⲒⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ⲪⲎ ⲆⲈ ⲈⲦⲦⲰϪⲒ ⲚⲈⲘ ⲪⲎ ⲈⲦⲤⲞ ⲞⲨⲀⲒ ⲠⲈ ⲠⲒⲞⲨⲀⲒ ⲆⲈ ⲠⲒⲞⲨⲀⲒ ϤⲚⲀϬⲒ ⲘⲠⲈϤⲂⲈⲬⲈ ⲔⲀⲦⲀ ⲠⲈϤϦⲒⲤⲒ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ⲀⲚⲞⲚ ϨⲀⲚϢⲪⲎⲢ ⲄⲀⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲒⲈⲪⲞⲨⲰⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲐⲰⲦⲈⲚ ⲞⲨⲔⲰⲦ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ⲔⲀⲦⲀ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲦⲞⲒ ⲚⲎⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲤⲀⲂⲈ ⲚⲀⲢⲬⲎⲆⲈⲔⲦⲰⲚ ⲀⲒⲬⲰ ⲚⲞⲨⲤⲈⲚϮ ⲈϦⲢⲎⲒ ⲔⲈⲞⲨⲀⲒ ⲠⲈⲐⲞⲨⲀϨⲈⲘ ⲔⲰⲦ ⲠⲒⲞⲨⲀⲒ ⲆⲈ ⲠⲒⲞⲨⲀⲒ ⲘⲀⲢⲈϤⲤⲞⲘⲤ ϪⲈ ⲀϤⲔⲰⲦ ⲚⲀϢ ⲚⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ⲔⲈⲤⲈⲚϮ ⲄⲀⲢ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲔⲈⲞⲨⲀⲒ ⲬⲀⲤ ⲈϦⲢⲎⲒ ⲤⲀⲂⲞⲖ ⲚⲐⲎ ⲈⲦⲬⲎ ⲈⲦⲈ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲠⲈⲦⲔⲰⲦ ⲈϪⲈⲚ ⲦⲀⲒⲤⲈⲚϮ ⲚⲞⲨⲂ ϨⲀⲦ ⲀⲚⲀⲘⲎⲒ ⲢⲰⲔϨ ⲤⲰⲞⲨⲂⲈⲚ ⲢⲰⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ⲠϨⲰⲂ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲈϤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲠⲒⲈϨⲞⲞⲨ ⲄⲀⲢ ϤⲚⲀⲞⲨⲞⲚϨϤ ⲈⲂⲞⲖ ϪⲈ ϤⲚⲀϬⲰⲢⲠ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲬⲢⲰⲘ ⲞⲨⲞϨ ⲠϨⲰⲂ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲬⲢⲰⲘ ⲚⲀⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲞϤ ϪⲈ ⲞⲨⲀϢ ⲚⲢⲎϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ⲪⲎ ⲈⲦⲈ ⲠⲈϤϨⲰⲂ ⲚⲀⲞϨⲒ ⲈⲢⲀⲦϤ ⲈⲦⲀϤⲔⲞⲦϤ ϤⲚⲀϬⲒ ⲘⲠⲈϤⲂⲈⲬⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ⲪⲎ ⲈⲦⲈ ⲠⲈϤϨⲰⲂ ⲚⲀⲢⲰⲔϨ ϤⲚⲀϮⲞⲤⲒ ⲚⲐⲞϤ ⲆⲈ ϤⲚⲀⲚⲞϨⲈⲘ ⲠⲀⲒⲢⲎϮ ⲆⲈ ϨⲰⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲞⲨⲈⲢⲪⲈⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲀϤϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ⲪⲎ ⲞⲨⲚ ⲈⲐⲚⲀⲤⲈϤ ⲠⲒⲈⲢⲪⲈⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲪⲀⲒ ⲪⲚⲞⲨϮ ⲚⲀⲦⲀⲔⲞϤ ⲠⲒⲈⲢⲪⲈⲒ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ϤⲞⲨⲀⲂ ⲈⲦⲈ ⲚⲐⲰⲦⲈⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ⲈⲢϨⲀⲖ ⲘⲘⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲪⲎ ⲈⲐⲘⲈⲨⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ϪⲈ ⲞⲨⲤⲀⲂⲈ ⲠⲈ ϦⲈⲚⲠⲀⲒⲈⲚⲈϨ ⲘⲀⲢⲈϤⲈⲢⲤⲞϪ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢⲤⲀⲂⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ⲦⲤⲂⲰ ⲄⲀⲢ ⲘⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲘⲈⲦⲤⲞϪ ⲦⲈ ⲚⲀϨⲢⲈⲚ ⲪⲚⲞⲨϮ ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϪⲈ ⲪⲎ ⲈⲦⲀⲘⲀϨⲒ ⲚⲚⲒⲤⲀⲂⲈⲨ ϦⲈⲚⲦⲞⲨⲘⲈⲦⲤⲈⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ϪⲈ ⲠϬⲞⲒⲤ ⲤⲰⲞⲨⲚ ⲚⲚⲒⲘⲞⲔⲘⲈⲔ ⲚⲦⲈϨⲀⲚⲤⲀⲂⲈⲨ ϪⲈ ϨⲀⲚⲈⲪⲖⲎⲞⲨ ⲚⲈ ");
INSERT INTO copbhc_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ϨⲰⲤⲦⲈ ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ϢⲞⲨϢⲞⲨ ⲘⲘⲞϤ ϦⲈⲚⲚⲒⲢⲰⲘⲒ ⲈⲚⲬⲀⲒ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲚⲞⲨⲦⲈⲚ ⲚⲈ ");
INSERT INTO copbhc_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ⲒⲦⲈ ⲠⲀⲨⲖⲞⲤ ⲒⲦⲈ ⲀⲠⲞⲖⲖⲰ ⲒⲦⲈ ⲔⲎⲪⲀ ⲒⲦⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲒⲦⲈ ⲠⲰⲚϦ ⲒⲦⲈ ⲪⲘⲞⲨ ⲒⲦⲈ ⲚⲎ ⲈⲦϢⲞⲠ ⲒⲦⲈ ⲚⲎ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚⲞⲨⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ⲚⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲆⲈ ⲪⲀ ⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲘⲀⲢⲞⲨⲘⲈⲨⲒ ⲈⲢⲞⲚ ⲚϪⲈⲚⲒⲢⲰⲘⲒ ϨⲰⲤ ϨⲀⲚϨⲨⲠⲈⲢⲈⲦⲎⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ϨⲀⲚⲞⲒⲔⲞⲚⲞⲘⲞⲤ ⲚⲦⲈⲚⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ⲖⲞⲒⲠⲞⲚ ⲤⲈⲔⲰϮ ⲘⲠⲀⲒⲘⲀ ϦⲈⲚⲚⲒⲞⲒⲔⲞⲚⲞⲘⲞⲤ ϨⲒⲚⲀ ⲚⲤⲈϪⲈⲘ ⲞⲨⲀⲒ ⲈϤⲈⲚϨⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ⲀⲚⲞⲔ ⲞⲨⲘⲈⲦⲔⲞⲨϪⲒ ⲚⲎⲒ ⲦⲈ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϮϨⲀⲠ ⲈⲢⲞⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲒⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲈϨⲞⲞⲨ ⲚⲦⲈⲞⲨⲘⲈⲦⲢⲰⲘⲒ ⲀⲖⲖⲀ ⲞⲨⲆⲈ ⲀⲚⲞⲔ ⲚϮϮϨⲀⲠ ⲈⲢⲞⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ⲞⲨⲆⲈ ⲄⲀⲢ ⲀⲚⲞⲔ ⲚϮⲤⲰⲞⲨⲚ ⲚϨⲖⲒ ⲀⲚ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲀⲖⲖⲀ ⲞⲨⲆⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲪⲀⲒ ⲚϮⲐⲘⲀⲒⲎⲞⲨⲦ ⲀⲚ ⲪⲎ ⲆⲈ ⲈⲐⲚⲀϮϨⲀⲠ ⲈⲢⲞⲒ ⲠϬⲞⲒⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ϨⲰⲤⲦⲈ ⲘⲠⲈⲢϮϨⲀⲠ ⲈϨⲖⲒ ϦⲀⲦϨⲎ ⲘⲠⲒⲤⲎⲞⲨ ϢⲀⲦⲈϤⲒ ⲚϪⲈⲠϬⲞⲒⲤ ⲪⲎ ⲈⲐⲚⲀⲐⲢⲈ ⲚⲎ ⲈⲦϨⲎⲠ ⲚⲦⲈⲠⲬⲀⲔⲒ ⲈⲢⲞⲨⲰⲒⲚⲒ ⲞⲨⲞϨ ⲚⲦⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲚⲚⲒⲤⲞϬⲚⲒ ⲚⲦⲈⲚⲒϨⲎⲦ ⲞⲨⲞϨ ⲦⲞⲦⲈ ⲈⲢⲈ ⲠⲦⲀⲒⲞ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ϢⲰⲠⲒ ⲚⲀϤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ⲚⲀⲒ ⲆⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲀⲒϢⲞⲠⲦⲞⲨ ⲚⲤⲬⲎⲘⲀ ⲈⲢⲞⲒ ⲚⲈⲘ ⲀⲠⲞⲖⲖⲰ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ⲚⲦⲈⲦⲈⲚϬⲒⲤⲂⲰ ⲈϢⲦⲈⲘⲈⲢⲤⲀⲂⲞⲖ ⲚⲚⲎ ⲈⲦⲤϦⲎⲞⲨⲦ ϨⲒⲚⲀ ϪⲈ ⲚⲚⲈ ⲞⲨⲀⲒ ϬⲒⲤⲒ ⲘⲘⲞϤ ⲈⲐⲂⲈ ⲞⲨⲀⲒ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈϤϢⲪⲎ Ⲣ. ");
INSERT INTO copbhc_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ⲚⲒⲘ ⲄⲀⲢ ⲠⲈⲦⲈⲢⲆⲒⲀⲔⲢⲒⲚⲒⲚ ⲘⲘⲞⲔ ⲞⲨ ⲆⲈ ⲠⲈⲦⲈⲚⲦⲞⲦⲔ ⲈⲦⲈ ⲘⲠⲈⲔϬⲒⲦϤ ⲒⲤϪⲈ ⲆⲈ ⲀⲔⲈⲢ ⲠⲔⲈϬⲒ ⲈⲐⲂⲈⲞⲨ ⲈⲔϢⲞⲨϢⲞⲨ ⲘⲘⲞⲔ ϨⲰⲤ ⲞⲨⲀⲒ ⲘⲠⲈⲔϬⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ϨⲎⲆⲎ ⲀⲦⲈⲦⲈⲚⲤⲒ ϨⲎⲆⲎ ⲀⲦⲈⲦⲈⲚⲈⲢⲢⲀⲘⲀⲞ ⲀⲦϬⲚⲞⲨⲚ ⲀⲢⲈⲦⲈⲚⲈⲢⲞⲨⲢⲞ ⲞⲨⲞϨ ⲀⲘⲞⲒ ⲚⲈⲀⲢⲈⲦⲈⲚⲈⲢⲞⲨⲢⲞ ϨⲒⲚⲀ ⲀⲚⲞⲚ ϨⲰⲚ ⲚⲦⲈⲚⲈⲢϢⲪⲎⲢ ⲚⲞⲨⲢⲞ ⲚⲈⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ϮⲘⲈⲨⲒ ⲄⲀⲢ ϪⲈ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲞⲨⲞⲚϨⲦⲈⲚ ⲈⲂⲞⲖ ⲀⲚⲞⲚ ϦⲀ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚϨⲀⲚϦⲀⲈⲨ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲠⲒⲐⲀⲚⲀⲦⲒⲞⲤ ϪⲈ ⲀⲚⲈⲢⲐⲈⲀⲦⲢⲞⲚ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ⲚⲈⲘ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ⲀⲚⲞⲚ ϨⲀⲚⲤⲞϪ ⲈⲐⲂⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲐⲰⲦⲈⲚ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲤⲀⲂⲈⲨ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲚⲞⲚ ϨⲀⲚϪⲰⲂ ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ϨⲀⲚϪⲰⲢⲒ ⲚⲐⲰⲦⲈⲚ ⲦⲈⲦⲈⲚⲦⲀⲒⲎⲞⲨⲦ ⲀⲚⲞⲚ ⲆⲈ ⲦⲈⲚϢⲎϢ ");
INSERT INTO copbhc_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ϢⲀ ⲈϦⲞⲨⲚ ⲈⲦⲀⲒⲞⲨⲚⲞⲨ ⲦⲈⲚϨⲞⲔⲈⲢ ⲞⲨⲞϨ ⲦⲈⲚⲞⲂⲒ ⲦⲈⲚⲂⲎϢ ⲞⲨⲞϨ ⲤⲈϮⲔⲈϨ ⲚⲀⲚ ⲞⲨⲞϨ ⲦⲈⲚⲤⲈⲘⲚⲎⲞⲨⲦ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ⲦⲈⲚϦⲞⲤⲒ ⲈⲚⲈⲢϨⲰⲂ ⲚⲚⲈⲚϪⲒϪ ⲘⲘⲒⲚ ⲘⲘⲞⲚ ⲤⲈϨⲰⲞⲨϢ ⲈⲢⲞⲚ ⲞⲨⲞϨ ⲦⲈⲚⲤⲘⲞⲨ ⲈⲢⲰⲞⲨ ⲈⲨϬⲞϪⲒ ⲚⲤⲰⲚ ⲦⲈⲚⲰⲞⲨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ⲈⲨϪⲈⲞⲨⲀ ⲈⲢⲞⲚ ⲦⲈⲚϮϨⲞ ⲈⲢⲰⲞⲨ ⲀⲚⲈⲢ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲈⲠⲒⲔⲀⲐⲈⲢⲘⲀ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲀⲚⲈⲢϢⲂⲈ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲦⲀⲒⲞⲨⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ⲚⲀⲒϪⲪⲒⲞ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ⲈⲒⲤϦⲀⲒ ⲚⲚⲀⲒ ⲚⲰⲦⲈⲚ ⲀⲖⲖⲀ ⲈⲒϮⲤⲂⲰ ⲚⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚϢⲎⲢⲒ ⲘⲘⲈⲚⲢⲒⲦ ⲚⲦⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ⲈϢⲰⲠ ⲄⲀⲢ ⲈⲞⲨⲞⲚⲦⲰⲦⲈⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲐⲂⲀ ⲚϬⲀⲨⲘⲰⲒⲦ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲖⲖⲀ ⲚⲞⲨⲘⲎϢ ⲚⲒⲰⲦ ⲀⲚ ⲚϨⲢⲎⲒ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲀⲚⲞⲔ ⲀⲒϪⲪⲈ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ϮϮϨⲞ ⲞⲨⲚ ⲈⲢⲰⲦⲈⲚ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲚⲒ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ⲈⲐⲂⲈ ⲪⲀⲒ ⲀⲒⲞⲨⲰⲢⲠ ⲚⲰⲦⲈⲚ ⲚⲦⲒⲘⲞⲐⲈⲞⲤ ⲈⲦⲈ ⲠⲀϢⲎⲢⲒ ⲘⲘⲈⲚⲢⲒⲦ ⲠⲈ ⲞⲨⲞϨ ⲘⲠⲒⲤⲦⲞⲤ ϦⲈⲚⲠϬⲞⲒⲤ ⲪⲀⲒ ⲈⲐⲚⲀⲐⲢⲈⲦⲈⲚⲈⲢⲪⲘⲈⲨⲒ ⲚⲚⲀⲘⲰⲒⲦ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈϮϮⲤⲂⲰ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ ϦⲈⲚⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ϨⲰⲤ ⲚϮⲚⲎⲞⲨ ⲆⲈ ϨⲀⲢⲰⲦⲈⲚ ⲀⲚ Ⲁ- ϨⲀⲚⲞⲨⲞⲚ ϬⲒⲤⲒ ⲚϨⲎⲦ ");
INSERT INTO copbhc_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ⲈⲒⲈⲒ ⲆⲈ ϨⲀⲢⲰⲦⲈⲚ ⲚⲬⲰⲖⲈⲘ ⲈϢⲰⲠ ⲈⲪⲞⲨⲰϢ ⲘⲠϬⲞⲒⲤ ⲠⲈ ⲞⲨⲞϨ ⲈⲒⲈⲈⲘⲒ ⲈⲠⲤⲀϪⲒ ⲀⲚ ⲚⲚⲎ ⲈⲦⲀⲨϬⲒⲤⲒ ⲚϨⲎⲦ ⲀⲖⲖⲀ ⲈⲦⲞⲨϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ϮⲘⲈⲦⲞⲨⲢⲞ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲀⲤϦⲈⲚ ⲠⲤⲀϪⲒ ⲀⲚ ⲀⲖⲖⲀ ⲀⲤϦⲈⲚ ⲞⲨϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ⲞⲨ ϪⲈ ⲠⲈⲦⲈⲦⲈⲚⲞⲨⲀϢϤ ⲚⲦⲀⲒ ϨⲀⲢⲰⲦⲈⲚ ϦⲈⲚⲞⲨϢⲂⲰⲦ ϢⲀⲚ ϦⲈⲚⲞⲨⲀⲄⲀⲠⲎ ⲘⲠⲚⲈⲨⲘⲀⲘⲘⲈⲦⲢⲈⲘⲢⲀⲨϢ. ");
INSERT INTO copbhc_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ϨⲞⲖⲰⲤ ⲤⲈⲤⲰⲦⲈⲘ ⲈⲞⲨⲠⲞⲢⲚⲒⲀ ϦⲈⲚⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲞⲨⲠⲞⲢⲚⲒⲀ ⲘⲠⲀⲒⲢⲎϮ ⲐⲀⲒ ⲈⲦⲈⲚⲤϢⲞⲠ ⲀⲚ ϦⲈⲚⲚⲒⲔⲈⲈⲐⲚⲞⲤ ϨⲰⲤⲦⲈ ⲚⲦⲈⲞⲨⲀⲒ ϬⲒ ⲦⲤϨⲒⲘⲒ ⲘⲠⲈϤⲒⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲦⲈⲦⲈⲚϬⲞⲤⲒ ⲚϨⲎⲦ ⲞⲨⲞϨ ⲈⲐⲂⲈⲞⲨ ⲘⲀⲖⲖⲞⲚ ⲘⲠⲈⲦⲈⲚⲈⲢϨⲎ ⲂⲒ ϨⲒⲚⲀ ⲚⲤⲈⲰⲖⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲈⲦⲈⲚⲘⲎϮ ⲘⲪⲎ ⲈⲦⲀϤⲒⲢⲒ ⲘⲠⲀⲒϨⲰⲂ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ⲀⲚⲞⲔ ⲘⲈⲚ ⲄⲀⲢ ⲚϮⲚⲈⲘⲰⲦⲈⲚ ⲀⲚ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ϮⲚⲈⲘⲰⲦⲈⲚ ⲆⲈ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϨⲎⲆⲎ ⲈⲒϮϨⲀⲠ ϨⲰⲤ ⲈⲒⲚⲈⲘⲰⲦⲈⲚ ⲘⲪⲎ ⲈⲦⲀϤⲒⲢⲒ ⲘⲠⲀⲒϨⲰⲂ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ϦⲈⲚ ⲪⲢⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲦⲈⲦⲈⲚⲐⲰⲞⲨϮ ⲈⲨⲘⲀ ⲚⲈⲘ ⲠⲀⲠⲚⲈⲨⲘⲀⲚⲈⲘ ϮϪⲞⲘ ⲚⲦⲈⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ⲈϮ ⲘⲪⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲦⲞⲦϤ ⲘⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲠⲦⲀⲔⲞ ⲚⲦⲈϮⲤⲀⲢⲜ ϨⲒⲚⲀ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲚⲞϨⲈⲘ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ⲚⲀⲚⲈ ⲠⲈⲦⲈⲚϢⲞⲨϢⲞⲨ ⲀⲚ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲞⲨⲔⲞⲨϪⲒ ⲚϢⲈⲘⲎⲢ ϢⲀϤⲐⲢⲈ ⲠⲒⲞⲨⲰϢⲈⲘ ⲦⲎⲢϤ ϬⲒϢⲈⲘⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ⲘⲀⲦⲞⲨⲂⲈ ⲠⲒϢⲈⲘⲎⲢ ⲚⲀⲠⲀⲤ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲰⲠⲒ ⲚⲞⲨⲰϢⲈⲘ ⲘⲂⲈⲢⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲞⲒ ⲚⲀⲦϢⲈⲘⲎⲢ ⲔⲈ ⲄⲀⲢ ⲠⲈⲚⲠⲀⲤⲬⲀ ⲀⲨϢⲀⲦϤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ϨⲰⲤⲦⲈ ⲘⲀⲢⲈⲚⲈⲢϢⲀⲒ ϦⲈⲚⲞⲨϢⲈⲘⲎⲢ ⲚⲀⲠⲀⲤ ⲀⲚ ⲞⲨⲆⲈ ϦⲈⲚⲞⲨϢⲈⲘⲎⲢ ⲚⲔⲀⲔⲒⲀ ⲀⲚ ⲚⲈⲘ ⲠⲞⲚⲎⲢⲒⲀ ⲀⲖⲖⲀ ϦⲈⲚϨⲀⲚⲘⲈⲦⲀⲦϢⲈⲘⲎ ⲢⲚⲦⲈ ⲞⲨⲦⲞⲨⲂⲞ ⲚⲈⲘ ⲞⲨⲘⲈⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ⲀⲒⲤϦⲀⲒ ⲚⲰⲦⲈⲚ ϨⲒ ϮⲈⲠⲒⲤⲦⲞⲖⲎ ⲈϢⲦⲈⲘⲘⲞⲨϪⲦ ⲚⲈⲘ ⲚⲒⲠⲞⲢⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ⲚⲀⲒϪⲈⲢⲈ ⲚⲒⲠⲞⲢⲚⲞⲤ ⲀⲚ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲒⲈ ⲚⲒⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲒⲈ ⲚⲒⲢⲈϤϨⲰⲖⲈⲘ ⲒⲈ ⲚⲒⲢⲈϤϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ ⲘⲘⲞⲚ ⲚⲀⲤⲘⲠϢⲀ ⲚⲰⲦⲈⲚ ⲠⲈ ⲚⲦⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ϮⲚⲞⲨ ⲆⲈ ⲀⲒⲤϦⲀⲒ ⲚⲰⲦⲈⲚ ⲈϢⲦⲈⲘⲘⲞⲨϪⲦ ⲚⲈⲘⲰⲞⲨ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲈⲨϮⲢⲀⲚ ⲈⲢⲞϤ ϪⲈ ⲤⲞⲚ ⲈⲞⲨⲠⲞⲢⲚⲞⲤ ⲒⲈ ⲞⲨⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲒⲈ ⲞⲨⲢⲈϤϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ ⲒⲈ ⲞⲨⲢⲈϤϨⲰⲞⲨϢ ⲒⲈ ⲞⲨⲢⲈϤⲐⲒϦⲒ ⲒⲈ ⲞⲨⲢⲈϤϨⲰⲖⲈⲘ ⲪⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲆⲈ ⲘⲠⲈⲢⲈⲢϢⲪⲎⲢ ⲚⲞⲨⲰⲘ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ⲈⲢⲞⲨ ⲄⲀⲢ ⲚⲎⲒ ⲈϮϨⲀⲠ ⲈⲚⲎ ⲈⲦⲤⲀⲂⲞⲖ ⲚⲎ ⲈⲦⲤⲀϦⲞⲨⲚ ⲚⲐⲰⲦⲈⲚ ⲘⲀϨⲀⲠ ⲈⲢⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ⲚⲎ ⲈⲦⲤⲀⲂⲞⲖ ⲆⲈ ⲪⲚⲞⲨϮ ⲈϤⲈϮϨⲀⲠ ⲈⲢⲰⲞⲨ ⲀⲖⲒⲞⲨⲒ ⲘⲠⲒⲠⲈⲦϨⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲚⲀⲈⲢⲦⲞⲖⲘⲀⲚ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲞⲨⲞⲚⲦⲈϤ ⲞⲨϨⲰⲂ ⲞⲨⲦⲰϤ ⲚⲈⲘ ⲠⲈϤϢⲪⲎⲢ ⲈϬⲒϨⲀⲠ ϨⲒ ⲚⲒⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲞⲨⲞϨ ϨⲒ ⲚⲒⲀⲄⲒⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲒⲀⲄⲒⲞⲤ ⲈⲐⲚⲀϮ ϨⲀⲠ ⲈⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲒⲤϪⲈ ⲠⲒⲔⲞⲤⲘⲞⲤ ⲈⲨⲚⲀϮϨⲀⲠ ⲈⲢⲞϤ ϦⲈⲚⲐⲎⲚⲞⲨ ⲚⲀⲢⲈⲦⲈⲚⲘⲠϢⲀ ⲀⲚ ϪⲈ ⲚϨⲀⲚⲔⲞⲨϪⲒ ⲘⲘⲀ ⲚϮϨⲀⲠ. ");
INSERT INTO copbhc_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲈⲚⲚⲀϮϨⲀⲠ ⲈϨⲀⲚⲀⲄⲄⲈⲖⲞⲤ ⲘⲎⲦⲒ ⲄⲈ ϨⲀⲚϨⲂⲎⲞⲨⲒ ⲚⲦⲈⲠⲀⲒⲂⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ⲈϢⲰⲠ ⲘⲈⲚ ⲞⲨⲚ ⲈⲞⲨⲞⲚⲦⲰⲦⲈⲚ ⲘⲘⲀⲨ ⲚϨⲀⲚⲘⲀⲚϮϨⲀⲠ ⲚⲦⲈⲠⲀⲒⲂⲒⲞⲤ ⲚⲎ ⲈⲦϢⲎϢ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲀⲒ ⲘⲀⲦϨⲈⲘⲤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ⲈⲒϪⲰ ⲘⲘⲞⲤ ⲈⲨϪⲪⲒⲞ ⲚⲰⲦⲈⲚ ⲠⲀⲒⲢⲎϮ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲤⲀⲂⲈ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞϤ ⲈⲈⲢⲆⲒⲀⲔⲢⲒⲚⲒⲚ ⲞⲨⲦⲈ ⲠⲈϤⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ⲀⲖⲖⲀ ⲞⲨⲤⲞⲚ ⲚⲈⲘ ⲞⲨⲤⲞⲚ ⲈϤϬⲒϨⲀⲠ ⲞⲨⲞϨ ⲪⲀⲒ ϨⲒ ⲚⲒⲀⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ϨⲎⲆⲎ ⲘⲈⲚ ϨⲞⲖⲰⲤ ⲞⲨⲐⲈⲂⲒⲞ ⲚⲰⲦⲈⲚ ⲠⲈ ϪⲈ ⲞⲨⲞⲚⲦⲈⲦⲈⲚ ϨⲀⲠ ⲘⲘⲀⲨ ⲞⲨⲦⲰⲦⲈⲚ ⲚⲈⲘ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲈⲐⲂⲈⲞⲨ ⲘⲀⲖⲖⲞⲚ ⲤⲈϬⲒ ⲘⲘⲰⲦⲈⲚ ⲚϪⲞⲚⲤ ⲀⲚ ⲈⲐⲂⲈⲞⲨ ⲘⲀⲖⲖⲞⲚ ⲤⲈϤⲰϪⲒ ⲘⲘⲰⲦⲈⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ⲀⲖⲖⲀ ⲚⲐⲰⲦⲈⲚ ⲈⲦϬⲒⲚϪⲞⲚⲤ ⲞⲨⲞϨ ⲈⲦϤⲰϪⲒ ⲞⲨⲞϨ ⲪⲀⲒ ⲚⲚⲈⲦⲈⲚⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲒⲢⲈϤϬⲒⲚϪⲞⲚⲤ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲈⲚⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲘⲘⲞⲤ ⲀⲚ ⲘⲠⲈⲢⲤⲰⲢⲈⲘ ϪⲈ ⲞⲨⲆⲈ ⲠⲞⲢⲚⲞⲤ ⲞⲨⲆⲈ ⲢⲈϤϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ ⲞⲨⲆⲈ ⲚⲰⲒⲔ ⲞⲨⲆⲈ ⲘⲀⲖⲀⲔⲞⲤ ⲞⲨⲆⲈ ⲢⲈϤⲈⲚⲔⲞⲦ ⲚⲈⲘ ϨⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ⲞⲨⲆⲈ ⲢⲈϤϬⲒⲞⲨⲒ ⲞⲨⲆⲈ ⲢⲈϤϬⲒⲚϪⲞⲚⲤ ⲞⲨⲆⲈ ⲢⲈϤⲐⲒϦⲒ ⲞⲨⲆⲈ ⲢⲈϤϮϢⲰϢ ⲞⲨⲆⲈ ⲢⲈϤϨⲰⲖⲈⲘ ϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲤⲈⲚⲀⲈⲢⲔⲖⲎ ⲢⲞⲚⲞⲘⲒⲚ ⲘⲘⲞⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ⲔⲈ ⲦⲀⲨⲦⲀ ⲚⲈⲚⲐⲰⲦⲈⲚ ϨⲀⲚⲞⲨⲞⲚ ⲠⲈ ⲀⲖⲖⲀ ⲀⲨϪⲈⲔⲈⲘ ⲐⲎⲚⲞⲨ ⲀⲖⲖⲀ ⲀⲨⲦⲞⲨⲂⲈ ⲐⲎⲚⲞⲨ ⲀⲖⲖⲀ ⲀⲨⲐⲘⲀⲒⲈ ⲐⲎⲚⲞⲨ ϦⲈⲚⲪⲢⲀⲚ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠⲈⲦⲈⲚⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ⲈⲜⲈⲤⲦⲒⲚ ⲚⲎⲒ ⲈⲈⲢϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲤⲈⲈⲢⲚⲞϤⲢⲒ ⲦⲎⲢⲞⲨ ⲀⲚ ⲈⲜⲈⲤⲦⲒⲚ ⲚⲎⲒ ⲈⲈⲢϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲚⲚⲈϢ ϨⲖⲒ ⲒⲢⲒ ⲘⲠⲀⲈⲢϢⲒϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ⲚⲒϦⲢⲎⲞⲨⲒ ⲀⲨⲬⲎ ⲚϮⲚⲈϪⲒ ⲞⲨⲞϨ ϮⲚⲈϪⲒ ⲚⲚⲒϦⲢⲎⲞⲨⲒ ⲐⲀⲒ ⲆⲈ ⲚⲈⲘ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲪⲚⲞⲨϮ ⲚⲀⲔⲞⲢϤⲞⲨ ⲠⲒⲤⲰⲘⲀ ⲆⲈ ⲚⲀϤⲬⲎ ⲚϮⲠⲞⲢⲚⲒⲀ ⲀⲚ ⲀⲖⲖⲀ ⲘⲠϬⲞⲒⲤ ⲞⲨⲞϨ ⲠϬⲞⲒⲤ ⲘⲠⲒⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ⲪⲚⲞⲨϮ ⲆⲈ ⲀϤⲦⲞⲨⲚⲞⲤ ⲠⲈⲚϬⲞⲒⲤ ⲞⲨⲞϨ ⲀⲚⲞⲚ ϨⲰⲚ ⲈϤⲈⲦⲞⲨⲚⲞⲤⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲦⲈϤϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲈⲦⲈⲚⲤⲰⲘⲀ ϨⲀⲚⲘⲈⲖⲞⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲚⲦⲀⲰⲖⲒ ⲞⲨⲚ ⲚⲚⲒⲘⲈⲖⲞⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲦⲀⲀⲒⲦⲞⲨ ⲘⲘⲈⲖⲞⲤ ⲘⲠⲞⲢⲚⲎ ⲚⲚⲈⲤϢⲰⲠⲒ ");
INSERT INTO copbhc_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲪⲎ ⲈⲦⲦⲰⲘⲒ ⲘⲘⲞϤ ⲈϮⲠⲞⲢⲚⲎ ⲞⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲠⲈ ⲈⲨⲈϢⲰⲠⲒ ⲄⲀⲢ ⲠⲈϪⲀϤ ⲘⲠⲂ ⲈⲨⲤⲀⲢⲜ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ⲪⲎ ⲈⲦⲦⲰⲘⲒ ⲘⲘⲞϤ ⲈⲠϬⲞⲒⲤ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ⲪⲰⲦ ⲤⲀⲂⲞⲖ ⲚϮⲠⲞⲢⲚⲒⲀ ⲚⲞⲂⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲈ ⲠⲒⲢⲰⲘⲒ ⲚⲀⲀⲒϤ ϤⲤⲀⲂⲞⲖ ⲘⲠⲒⲤⲰⲘⲀ ⲪⲎ ⲆⲈ ⲈⲦⲈⲢⲠⲞⲢⲚⲈⲨⲒⲚ ⲀϤⲈⲢⲚⲞⲂⲒ ⲈⲠⲈϤⲤⲰⲘⲀ ⲘⲘⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ϢⲀⲚ ⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲈⲦⲈⲚⲤⲰⲘⲀ ⲞⲨⲈⲢⲪⲈⲒ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈⲐⲞⲨⲀⲂ ⲠⲈ ⲪⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲪⲎ ⲈⲦⲀⲢⲈⲦⲈⲚϬⲒⲦϤ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲚⲐⲰⲦⲈⲚ ⲪⲰⲦⲈⲦⲈⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ⲀⲨϢⲈⲠ ⲐⲎⲚⲞⲨ ϦⲀ ⲞⲨⲦⲒⲘⲎ ⲘⲀⲰⲞⲨ ⲘⲪⲚⲞⲨϮ ϦⲈⲚⲚⲈⲦⲈⲚⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ⲈⲐⲂⲈ ⲚⲎ ⲆⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲤϦⲎⲦⲞⲨ ⲚⲎⲒ ⲚⲀⲚⲈⲤ ⲘⲠⲒⲢⲰⲘⲒ ⲈϢⲦⲈⲘϬⲒ ⲚⲈⲘ ⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ⲈⲐⲂⲈ ⲚⲒⲠⲞⲢⲚⲒⲀ ⲆⲈ ⲘⲀⲢⲈ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲬⲀ ⲦⲈϤⲤϨⲒⲘⲒ ⲚⲀϤ ⲞⲨⲞϨ ⲘⲀⲢⲈ ϮⲞⲨⲒ ϮⲞⲨⲒ ⲬⲀ ⲠⲈⲤϨⲀⲒ ⲚⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ⲠⲒϨⲀⲒ ⲘⲀⲢⲈϤϮ ⲘⲠⲈⲦⲈⲢⲞϤ ⲚϮⲤϨⲒⲘⲒ ⲠⲀⲒⲢⲎϮ ⲞⲚ ϮⲤϨⲒⲘⲒ ⲘⲀⲢⲈⲤϮ ⲘⲠⲈⲦⲈⲢⲞⲤ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ϮⲤϨⲒⲘⲒ ⲘⲘⲞⲚⲦⲈⲤ ⲈⲢϢⲒϢⲒ ⲘⲠⲈⲤⲤⲰⲘⲀ ⲘⲘⲒⲚ ⲘⲘⲞⲤ ⲀⲖⲖⲀ ⲠⲒϨⲀⲒ ⲠⲈ ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲞⲚ ⲠⲒⲔⲈϨⲀⲒ ⲘⲘⲞⲚⲦⲈϤ ⲈⲢϢⲒϢⲒ ⲘⲠⲈϤⲤⲰⲘⲀ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲀⲖⲖⲀ ϮⲤϨⲒⲘⲒ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ⲘⲠⲈⲢϤⲈϪ ⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ ⲈⲂⲎⲖ ⲀⲢⲎⲞⲨ ϦⲈⲚⲞⲨϮⲘⲀϮ ⲠⲢⲞⲤ ⲞⲨⲤⲎⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲤⲢⲞϤⲦ ⲈϮⲠⲢⲞⲤⲈⲨⲬⲎ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲚⲦⲈⲦⲈⲚⲒ ⲈⲨⲘⲀ ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲤⲀⲦⲀⲚⲀⲤ ⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲰⲦⲈⲚ ⲈⲐⲂⲈ ⲦⲈⲦⲈⲚⲘⲈⲦⲀⲦⲐⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ⲪⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ⲔⲀⲦⲀ ⲞⲨⲤⲨⲚⲄⲚⲰⲘⲎ ⲔⲀⲦⲀ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ϮⲞⲨⲰϢ ⲆⲈ ⲚⲦⲈⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ϢⲰⲠⲒ ⲘⲠⲀⲢⲎϮ ⲀⲖⲖⲀ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲞⲨⲚⲞⲦⲈϤ ⲞⲨϨⲘⲞⲦ ⲘⲘⲀⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲠⲒⲞⲨⲀⲒ ⲘⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲘⲠⲀⲒⲔⲈⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ϮϪⲰ ⲆⲈ ⲘⲘⲞⲤ ⲚⲚⲎ ⲈⲦⲈⲘⲠⲞⲨϬⲒ ⲚⲈⲘ ⲚⲒⲬⲎⲢⲀ ϪⲈ ⲚⲀⲚⲈⲤ ⲚⲰⲞⲨ ⲀⲨϢⲀⲚϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ⲒⲤϪⲈ ⲆⲈ ⲤⲈⲚⲀϢⲈⲢⲈⲄⲔⲢⲀⲦⲈⲨⲈⲤⲐⲈ ⲀⲚ ⲘⲀⲢⲞⲨϬⲒ ⲚⲀⲚⲈⲤ ⲄⲀⲢ ⲈϬⲒ ⲈϨⲞⲦⲈ ⲚⲤⲈϬⲒⲬⲢⲰⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ⲚⲎ ⲆⲈ ⲈⲦⲀⲨϬⲒ ϮϨⲞⲚϨⲈⲚ ⲚⲰⲞⲨ ⲀⲚⲞⲔ ⲀⲚ ⲀⲖⲖⲀ ⲠϬⲞⲒⲤ ϮⲤϨⲒⲘⲒ ⲚⲦⲈⲤϢⲦⲈⲘⲪⲰⲢϪ ⲤⲀⲂⲞⲖ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ⲔⲀⲚ ⲈϢⲰⲠ ⲀⲤϢⲀⲚⲪⲰⲢϪ ⲘⲀⲢⲈⲤⲞϨⲒ ⲚⲞⲨⲈϢⲈⲚ ϬⲒ ⲘⲘⲞⲚ ⲘⲀⲢⲈⲤϨⲰⲦⲠ ⲈⲠⲈⲤϨⲀⲒ ⲞⲨⲞϨ ⲠⲒϨⲀⲒ ⲚⲦⲈϤϢⲦⲈⲘⲬⲀ ϮⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ⲠⲤⲈⲠⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞⲤ ⲚⲰⲞⲨ ⲀⲚⲞⲔ ⲠϬⲞⲒⲤ ⲀⲚ ϪⲈ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚ ⲞⲨⲤⲞⲚ ⲈⲞⲨⲞⲚⲦⲈϤ ⲞⲨⲤϨⲒⲘⲒ ⲚⲀⲐⲚⲀϨϮ ⲘⲘⲀⲨ ⲞⲨⲞϨ ⲐⲀⲒ ⲈⲤϮⲘⲀϮ ⲈϢⲰⲠⲒ ⲚⲈⲘⲀϤ ⲘⲠⲈⲚⲐⲢⲈϤⲬⲀⲤ ⲚⲤⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ⲞⲨⲞϨ ⲞⲨⲤϨⲒⲘⲒ ⲈⲞⲨⲞⲚⲦⲀⲤ ⲘⲘⲀⲨ ⲚⲞⲨϨⲀⲒ ⲚⲀⲦⲚⲀϨϮ ⲞⲨⲞϨ ⲪⲀⲒ ⲈϤϮⲘⲀϮ ⲈϢⲰⲠⲒ ⲚⲈⲘⲀⲤ ⲘⲠⲈⲚⲐⲢⲈⲤⲬⲀ ⲠⲒϨⲀⲒ ⲚⲤⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ⲀϤⲦⲞⲨⲂⲞ ⲄⲀⲢ ⲚϪⲈⲠⲒϨⲀⲒ ⲚⲀⲐⲚⲀϨϮ ϦⲈⲚϮⲤϨⲒⲘⲒ ⲞⲨⲞϨ ⲀⲤⲦⲞⲨⲂⲞ ⲚϪⲈϮⲤϨⲒⲘⲒ ⲚⲀⲐⲚⲀϨϮ ϦⲈⲚⲠⲒⲤⲞⲚ ⲘⲘⲞⲚ ϨⲀⲢⲀ ⲚⲈⲦⲈⲚϢⲎⲢⲒ ⲤⲈϬⲀϦⲈⲘ ϮⲚⲞⲨ ⲆⲈ ⲤⲈⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ⲞⲨⲞϨ ⲒⲤϪⲈ ⲠⲒⲀⲐⲚⲀϨϮ ⲚⲀⲪⲰⲢϪ ⲘⲀⲢⲈϤⲪⲰⲢϪ ⲚϤⲞⲒ ⲘⲂⲰⲔ ⲀⲚ ⲚϪⲈⲠⲒⲤⲞⲚ ⲒⲈ ϮⲤⲰⲚⲒ ϦⲈⲚⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲪⲚⲞⲨϮ ⲀϤⲐⲀϨⲈⲘ ⲐⲎⲚⲞⲨ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ⲀⲢⲈⲈⲘⲒ ⲄⲀⲢ ⲐⲰⲚ ϮⲤϨⲒⲘⲒ ϪⲈ ⲀⲢⲎⲞⲨ ⲦⲈⲢⲀϢⲚⲞϨⲈⲘ ⲘⲠⲈϨⲀⲒ ⲒⲈ ⲀⲔⲤⲰⲞⲨⲚ ⲐⲰⲚ ⲠⲒⲢⲰⲘⲒ ϪⲈ ⲀⲢⲎⲞⲨ ⲬⲚⲀϢⲚⲞϨⲈⲘ ⲚⲦⲈⲔⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ⲒⲘⲎϮ ⲈⲠⲒⲢⲎϮ ⲈⲦⲀ ⲠϬⲞⲒⲤ ⲐⲀϢϤ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲐⲀϨⲈⲘ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲠⲀⲒⲢⲎϮ ⲘⲀⲢⲈϤⲘⲞϢⲒ ⲚϦⲎⲦϤ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲈϮⲞⲨⲀϨⲤⲀϨⲚⲒ ϦⲈⲚⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ⲀⲨⲐⲀϨⲈⲘ ⲞⲨⲀⲒ ⲈϤⲤⲞⲨⲂⲎⲦ ⲘⲠⲈⲚⲐⲢⲈϤⲤⲈⲔ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲚⲀϤ ⲀⲨⲐⲀϨⲈⲘ ⲞⲨⲀⲒ ϦⲈⲚϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ⲘⲠⲈⲚⲐⲢⲈϤⲤⲞⲨⲂⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ⲠⲤⲈⲠⲒ ⲄⲀⲢ ϨⲖⲒ ⲠⲈ ⲞⲨⲞϨ ϮⲘⲈⲦⲀⲦⲤⲈⲂⲒ ϨⲖⲒ ⲦⲈ ⲀⲖⲖⲀ ⲠⲒⲀⲢⲈϨ ⲈⲚⲒⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ϦⲈⲚⲠⲒⲐⲰϨⲈⲘ ⲈⲦⲀⲨⲐⲀϨⲘⲈϤ ⲚϦⲎⲦϤ ⲘⲀⲢⲈϤϢⲰⲠⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ⲀⲨⲐⲀϨⲘⲈⲔ ⲈⲔⲞⲒ ⲘⲂⲰⲔ ⲘⲠⲈⲚⲐⲢⲈⲤⲈⲢⲘⲈⲖⲒ ⲚⲀⲔ ⲀⲖⲖⲀ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲞⲔ ⲈⲈⲢⲢⲈⲘϨⲈ ⲘⲀⲖⲖⲞⲚ ⲀⲢⲒⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ⲠⲒⲂⲰⲔ ⲄⲀⲢ ⲈⲦⲀⲨⲐⲀϨⲘⲈϤ ϦⲈⲚⲠϬⲞⲒⲤ ⲞⲨⲀⲠⲈⲖⲈⲨⲐⲈⲢⲞⲤ ⲚⲦⲈⲠϬⲞⲒⲤ ⲠⲈ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲢⲈⲘϨⲈ ⲈⲦⲀⲨⲐⲀϨⲘⲈϤ ⲞⲨⲂⲰⲔ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ⲀⲨϢⲈⲠ ⲐⲎⲚⲞⲨ ϦⲀ ⲞⲨⲦⲒⲘⲎ ⲘⲠⲈⲢⲈⲢⲂⲰⲔ ⲚⲚⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲚⲀⲤⲚⲎⲞⲨ ϦⲈⲚⲪⲎ ⲈⲦⲀⲨⲐⲀϨⲘⲈϤ ⲚϦⲎⲦϤ ϦⲈⲚⲪⲀⲒ ⲘⲀⲢⲈϤϢⲰⲠⲒ ϦⲀⲦⲈⲚ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ⲈⲐⲂⲈ ⲚⲒⲠⲀⲢⲐⲈⲚⲞⲤ ⲆⲈ ⲘⲘⲞⲚϮ ⲞⲨⲀϨⲤⲀϨⲚⲒ ⲘⲘⲀⲨ ⲚⲦⲈⲚ ⲠϬⲞⲒⲤ ⲞⲨⲄⲚⲰⲘⲎ ⲆⲈ ⲠⲈϮϮ ⲘⲘⲞⲤ ϨⲰⲤ ⲈⲀⲨⲚⲀⲒ ⲚⲎⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠϬⲞⲒⲤ ⲈⲐⲢⲒϢⲰⲠⲒ ⲘⲠⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ϮⲘⲈⲨⲒ ⲞⲨⲚ ϪⲈ ⲚⲀⲚⲈ ⲪⲀⲒ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲈⲐⲂⲈ ϮⲀⲚⲀⲄⲔⲎ ⲈⲦϢⲞⲠ ϪⲈ ⲚⲀⲚⲈⲤ ⲘⲠⲒⲢⲰⲘⲒ ⲈⲐⲢⲈϤϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ⲔⲤⲞⲚϨ ⲈⲤϨⲒⲘⲒ ⲘⲠⲈⲢⲔⲰϮ ⲚⲤⲀⲂⲞⲖⲔ ⲔⲂⲎⲖ ⲈⲂⲞⲖ ⲚⲤϨⲒⲘⲒ ⲘⲠⲈⲢⲔⲰϮ ⲚⲤⲀⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ⲔⲀⲚ ⲈϢⲰⲠ ⲀⲔϢⲀⲚϬⲒ ⲘⲠⲈⲔⲈⲢⲚⲞⲂⲒ ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲤϢⲀⲚϬⲒ ⲚϪⲈϮⲠⲀⲢⲐⲈⲚⲞⲤ ⲘⲠⲀⲤⲈⲢⲚⲞⲂⲒ ⲈⲨⲈϬⲒ ⲆⲈ ⲚⲞⲨϨⲞϪϨⲈϪ ⲚⲦⲞⲨⲤⲀⲢⲜ ⲚϪⲈⲚⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲀⲚⲞⲔ ⲆⲈ ϮϮⲀⲤⲞ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ⲪⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲠⲤⲎⲞⲨ ⲘⲠⲰⲢϤ ⲠⲈ ⲦⲞⲖⲞⲒⲠⲞⲚ ϨⲒⲚⲀ ⲚⲎ ⲈⲦⲈ ⲞⲨⲞⲚⲦⲞⲨ ⲤϨⲒⲘⲒ ⲘⲘⲀⲨ ⲚⲤⲈⲈⲢ ⲘⲪⲢⲎϮ ⲚⲚⲎ ⲈⲦⲈ ⲘⲘⲞⲚⲦⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ⲚⲎ ⲈⲦⲢⲒⲘⲒ ϨⲰⲤ ⲚⲤⲈⲢⲒⲘⲒ ⲀⲚ ⲚⲎ ⲈⲦⲢⲀϢⲒ ϨⲰⲤ ⲚⲤⲈⲢⲀϢⲒ ⲀⲚ ⲚⲎ ⲈⲦϢⲰⲠ ϨⲰⲤ ⲚⲤⲈⲀⲘⲞⲚⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ⲚⲎ ⲈⲦⲈⲢⲬⲢⲀⲤⲐⲈ ⲘⲠⲒⲔⲞⲤⲘⲞⲤ ϨⲰⲤ ⲚⲤⲈⲈⲢⲔⲀⲦⲀⲬⲢⲀⲤⲐⲈ ⲀⲚ ϤⲚⲀⲤⲒⲚⲒ ⲄⲀⲢ ⲚϪⲈⲠⲒⲤⲬⲎⲘⲀ ⲚⲦⲈⲠⲀⲒⲔⲞⲤⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲢⲰⲞⲨϢ ⲪⲎ ⲈⲦⲈⲘⲠⲈϤϬⲒ ⲀϤϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲚⲀ ⲠϬⲞⲒⲤ ϪⲈ ⲠⲰⲤ ϤⲚⲀⲢⲀⲚⲀϤ ⲘⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ⲪⲎ ⲆⲈ ⲈⲦⲀϤϬⲒ ⲀϤϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲠⲒⲔⲞⲤⲘⲞⲤ ϪⲈ ⲠⲰⲤ ϤⲚⲀⲢⲀⲚⲀⲤ ⲚⲦⲈϤⲤϨⲒⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ⲞⲨⲞϨ ϤⲪⲎϢ ϮⲤϨⲒⲘⲒ ⲈⲦⲈⲘⲠⲈⲤϬⲒ ⲚⲈⲘ ϮⲠⲀⲢⲐⲈⲚⲞⲤ ⲐⲎ ⲈⲦⲈ ⲘⲠⲈⲤϬⲒ ⲀⲤϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲚⲀ ⲠϬⲞⲒⲤ ϨⲒⲚⲀ ⲚⲦⲈⲤϢⲰⲠⲒ ⲈⲤⲞⲨⲀⲂ ϦⲈⲚⲠⲈⲤⲤⲰⲘⲀ ⲚⲈⲘ ⲠⲈⲤⲠⲚⲈⲨⲘⲀⲐⲎ ⲆⲈ ⲈⲦⲀⲤϬⲒ ⲀⲤϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲚⲀ ⲠⲒⲔⲞⲤⲘⲞⲤ ϪⲈ ⲠⲰⲤ ⲤⲚⲀⲢⲀⲚⲀϤ ⲘⲠⲈⲤϨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ⲪⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ⲈⲐⲂⲈ ⲠⲈⲦⲈⲢⲚⲞϤⲢⲒ ⲚⲰⲦⲈⲚ ⲞⲨⲬⲒ ϨⲒⲚⲀ ⲚⲦⲀϨⲒⲞⲨⲒ ⲚⲞⲨϨⲀϪⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲀⲖⲖⲀ ϪⲈ ϨⲒⲚⲀ ⲚⲦⲈⲠⲈⲦⲈⲚⲤⲬⲎⲘⲀ ϢⲰⲠⲒ ⲈϤⲤⲞⲨⲂⲎⲦ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲘⲦⲞⲚ ⲘⲘⲞⲨⲚ ⲈⲠϬⲞⲒⲤ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦϬⲒϨⲢⲀϤ ");
INSERT INTO copbhc_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ⲒⲤϪⲈ ⲆⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲘⲈⲨⲒ ⲈϬⲒϢⲒⲠⲒ ⲈϪⲈⲚ ⲦⲈϤⲠⲀⲢⲐⲈⲚⲞⲤ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲈⲢⲀⲔⲘⲎ ⲚϨⲞⲨⲞ ⲞⲨⲞϨ ⲪⲀⲒ ⲠⲈⲦⲈⲘⲠϢⲀ ⲚⲦⲈϤϢⲰⲠⲒ ⲠⲈⲦⲈϨⲚⲀϤ ⲘⲀⲢⲈϤⲀⲒϤ ⲚϤⲈⲢⲚⲞⲂⲒ ⲀⲚ ⲘⲀⲢⲞⲨϬ Ⲓ. ");
INSERT INTO copbhc_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ⲪⲎ ⲆⲈ ⲈⲦⲞϨⲒ ⲈⲢⲀⲦϤ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲈϤⲦⲀϪⲢⲎⲞⲨⲦ ⲘⲘⲞⲚ ⲀⲚⲀⲄⲔⲎ ⲦⲞⲒ ⲈⲢⲞϤ ⲞⲨⲞⲚⲦⲈϤ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈⲐⲂⲈ ⲠⲈⲦⲈϨⲚⲀϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲪⲀⲒ ϤϮϨⲀⲠ ⲈⲢⲞϤ ⲘⲘⲒⲚ ⲘⲘⲞϤ ϦⲈⲚⲠⲈϤϨⲎⲦ ⲈⲀⲢⲈϨ ⲈⲦⲈϤⲠⲀⲢⲐⲈⲚⲞⲤ ⲔⲀⲖⲰⲤ ϤⲚⲀⲀⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ϨⲰⲤⲦⲈ ⲪⲎ ⲈⲦϮ ⲚⲦⲈϤⲠⲀⲢⲐⲈⲚⲞⲤ ⲈⲨⲄⲀⲘⲞⲤ ⲔⲀⲖⲰⲤ ϤⲢⲀ ⲘⲘⲞⲤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲈⲚϤϮ ⲚⲐⲰϤ ⲀⲚ ⲞⲨϨⲞⲨⲞ ⲔⲀⲖⲰⲤ ⲠⲈⲦⲈϤⲚⲀⲀⲒϤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ϮⲤϨⲒⲘⲒ ⲤⲞⲚϨ ⲈⲠⲈⲤϨⲀⲒ ⲈⲪⲞⲤⲞⲚ ⲬⲢⲞⲚⲞⲚ ⲈϤⲞⲚϦ ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲈⲚⲔⲞⲦ ⲚϪⲈⲠⲈⲤϨⲀⲒ ⲞⲨⲢⲈⲘϨⲎ ⲦⲈ ⲈϬⲒ ⲘⲠⲈⲦⲈϨⲚⲀⲤ ⲘⲞⲚⲞⲚ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ⲰⲞⲨⲚⲒⲀⲦⲤ ⲆⲈ ⲚϨⲞⲨⲞ ⲀⲤϢⲀⲚⲞϨⲒ ⲘⲠⲀⲒⲢⲎϮ ⲔⲀⲦⲀ ⲦⲀⲄⲚⲰⲘⲎ ϮⲘⲈⲨⲒ ⲆⲈ ϨⲰ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲚϨⲢⲎⲒ ⲚϦⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ⲈⲐⲂⲈ ⲚⲒϢⲰⲦ ⲆⲈ ⲚⲒⲆⲰⲖⲞⲚ ⲦⲈⲚⲤⲰⲞⲨⲚ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲈⲘⲒ ⲚϦⲎⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲠⲈⲘⲒ ϢⲀϤϬⲒⲤⲒ ϮⲀⲄⲀⲠⲎ ⲆⲈ ϢⲀⲤⲔⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ⲪⲎ ⲈⲦϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲀⲒⲈⲘⲒ ⲈϨⲖⲒ ⲘⲠⲀⲦⲈϤⲈⲘⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲤϢⲈ ⲚⲈⲘⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ⲪⲎ ⲆⲈ ⲈⲦⲈⲢⲀⲄⲀⲠⲀⲚ ⲘⲪⲚⲞⲨϮ ⲪⲀⲒ ⲀⲨⲤⲞⲨⲰⲚϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ⲈⲐⲂⲈ ⲚⲒϦⲢⲎⲞⲨⲒ ⲞⲨⲚ ⲚⲦⲈⲚⲒϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲦⲈⲚⲈⲘⲒ ϪⲈ ϨⲖⲒ ⲠⲈ ⲚⲒⲆⲰⲖⲞⲚ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲚⲚⲞⲨϮ ⲈⲂⲎⲖ ⲈⲞⲨⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ⲔⲈ ⲄⲀⲢ ⲒⲤϪⲈ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ⲈⲨⲘⲞⲨϮ ⲈⲢⲰⲞⲨ ϪⲈ ⲚⲞⲨϮ ⲒⲦⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲪⲈ ⲒⲦⲈ ϨⲒϪⲈⲚ ⲠⲒⲔⲀϨⲒ ⲘⲪⲢⲎϮ ⲈⲦⲈ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚⲚⲞⲨϮ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ⲚⲀⲚ ⲆⲈ ⲀⲚⲞⲚ ⲞⲨⲀⲒ ⲠⲈ ⲪⲚⲞⲨϮ ⲪⲒⲰⲦ ⲪⲎ ⲈⲦⲀ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲀⲚⲞⲚ ϨⲰⲚ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ ⲞⲨⲀⲒ ⲠⲈ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲎ ⲈⲦⲀ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲞⲨⲞϨ ⲀⲚⲞⲚ ϨⲰⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ⲀⲖⲖⲀ ⲠⲈⲘⲒ ϦⲈⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲀⲚ ϨⲀⲚⲞⲨⲞⲚ ⲄⲀⲢ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ϦⲈⲚϮⲔⲀϨⲤ ⲚⲦⲈⲚⲒⲒⲆⲰⲖⲞⲚ ⲤⲈⲞⲨⲰⲘ ⲘⲪⲢⲎϮ ⲚϨⲀⲚϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲞⲨⲞϨ ⲦⲞⲨⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲈⲤϢⲰⲚⲒ ⲈⲢⲰⲞⲨ ϢⲀⲤϬⲰϦⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ⲞⲨϦⲢⲈ ⲆⲈ ⲀⲚ ⲈⲐⲚⲀⲦⲀϨⲞⲚ ⲈⲢⲀⲦⲈⲚ ⲘⲪⲚⲞⲨϮ ⲞⲨⲆⲈ ⲀⲚϢⲦⲈⲘⲞⲨⲰⲘ ⲦⲈⲚⲚⲀϬⲢⲞϨ ⲀⲚ ⲞⲨⲆⲈ ⲀⲚϢⲀⲚⲞⲨⲰⲘ ⲦⲈⲚⲚⲀⲈⲢϨⲞⲨⲞ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ⲀⲚⲀⲨ ⲆⲈ ⲘⲎⲠⲰⲤ ⲚⲦⲈⲠⲈⲦⲈⲚⲈⲢϢⲒϢⲒ ⲪⲀⲒ ⲚⲦⲈϤϢⲰⲠⲒ ⲚϬⲢⲞⲠ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ⲀϤϢⲀⲚⲚⲀⲨ ⲈⲢⲞⲔ ⲚϪⲈⲞⲨⲀⲒ ϦⲀ ⲪⲎ ⲈⲦⲈ ⲠⲈⲘⲒ ⲚⲦⲞⲦϤ ⲈⲔⲢⲰⲦⲈⲂ ϦⲈⲚⲞⲨⲘⲀ ⲚⲒⲆⲰⲖⲞⲚ ⲞⲨⲬⲒ ⲦⲈϤⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲈⲤⲞⲒ ⲚⲢⲈϤϢⲰⲚⲒ ⲤⲚⲀⲔⲰⲦ ⲈⲠϪⲒⲚⲐⲢⲈϤⲞⲨⲈⲘ ϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ϢⲀϤⲦⲀⲔⲞ ⲄⲀⲢ ⲚϪⲈⲪⲎ ⲈⲦϢⲰⲚⲒ ϦⲈⲚⲠⲈⲔⲈⲘⲒ ⲠⲒⲤⲞⲚ ⲈⲦⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ⲠⲀⲒⲢⲎϮ ⲆⲈ ⲈⲢⲈⲦⲈⲚⲈⲢⲚⲞⲂⲒ ⲈⲚⲒⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲈⲢⲈⲦⲈⲚⲘⲒϢⲒ ⲈⲦⲞⲨⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲈⲦϢⲰⲚⲒ ⲀⲢⲈⲦⲈⲚⲈⲢⲚⲞⲂⲒ ⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ⲈⲐⲂⲈⲪⲀⲒ ⲒⲤϪⲈ ⲞⲨϦⲢⲈ ⲈⲐⲚⲀⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲒⲚ ⲘⲠⲀⲤⲞⲚ ⲚⲚⲀⲞⲨⲈⲘ ⲀϤ ϢⲀ ⲈⲚⲈϨ ϨⲒⲚⲀ ⲚⲦⲀϢⲦⲈⲘⲈⲢⲤⲔⲀⲚⲆⲀⲖⲒⲌⲒⲚ ⲘⲠⲀⲤⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ⲘⲎ ⲀⲚⲞⲔ ⲞⲨⲢⲈⲘϨⲈ ⲀⲚ ⲘⲎ ⲀⲚⲞⲔ ⲞⲨⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲚ ⲘⲎ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈⲚϬⲞⲒⲤ ⲘⲠⲒⲚⲀⲨ ⲈⲢⲞϤ ⲘⲎ ⲚⲐⲰⲦⲈⲚ ⲀⲚ ⲠⲈ ⲠⲀϨⲰⲂ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ⲒⲤϪⲈ ϮⲞⲒ ⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲀⲚ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲖⲖⲀ ϮⲞⲒ ⲚⲰⲦⲈⲚ ϮⲤⲪⲢⲀⲄⲒⲤ ⲄⲀⲢ ⲚⲦⲈⲦⲀⲘⲈⲦⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲐⲰⲦⲈⲚ ⲠⲈ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ⲦⲀⲀⲠⲞⲖⲞⲄⲒⲀ ⲚⲚⲎ ⲈⲦϦⲞⲦϦⲈⲦ ⲘⲘⲞⲒ ⲐⲀⲒ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ⲘⲎ ⲘⲘⲞⲚⲦⲈⲚ ⲈⲢϢⲒϢⲒ ⲈⲞⲨⲰⲘ ⲚⲈⲘ ⲈⲤⲰ. ");
INSERT INTO copbhc_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ⲘⲎ ⲞⲨⲞⲚⲦⲈⲚ ⲈⲢϢⲒϢⲒ ⲈⲐⲢⲈ ⲞⲨⲤⲰⲚⲒ ⲚⲤϨⲒⲘⲒ ⲘⲞϢⲒ ⲚⲤⲰⲚ ⲘⲪⲢⲎϮ ⲘⲠⲤⲈⲠⲒ ⲚⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲈⲘ ⲔⲎⲪⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ϢⲀⲚ ⲀⲚⲞⲔ ⲘⲘⲀⲨⲀⲦ ⲚⲈⲘ ⲂⲀⲢⲚⲀⲂⲀⲤ ⲈⲦⲈ ⲘⲘⲞⲚⲦⲈⲚ ⲈⲢϢⲒϢⲒ ⲘⲘⲀⲨ ⲈϢⲦⲈⲘⲈⲢϨⲰⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ⲚⲒⲘ ⲈϢⲀϤⲈⲢⲘⲀⲦⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲚⲈⲦⲈⲚⲞⲨϤ ⲚⲞⲮⲰⲚⲒⲞⲚ ⲈⲚⲈϨ ⲚⲒⲘ ⲈϢⲀϤϬⲞ ⲚⲞⲨⲒⲀϨⲀⲖⲞⲖⲒ ⲞⲨⲞϨ ⲘⲠⲀϤⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲞⲨⲦⲀϨ ⲒⲈ ⲚⲒⲘ ⲈϢⲀϤⲘⲞⲚⲒ ⲚⲞⲨⲞϨⲒ ⲚⲈⲤⲰⲞⲨ ⲚⲦⲈϤϢⲦⲈⲘⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲢⲰϮ ⲚⲦⲈⲠⲒⲞϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ⲘⲎ ⲀⲒⲤⲀϪⲒ ⲚⲚⲀⲒ ⲔⲀⲦⲀ ⲢⲰⲘⲒ ϢⲀⲚ ⲠⲒⲔⲈⲚⲞⲘⲞⲤ ⲚⲐⲞϤ ϤϪⲰ ⲚⲚⲀⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϦⲈⲚⲪⲚⲞⲘⲞⲤ ⲘⲘⲰⲨⲤⲎⲤ ϪⲈ ⲚⲚⲈⲔϮ ⲤⲀⲬⲞⲖ ⲈϨⲢⲈⲚ ⲈϨⲈ ⲈϤϨⲒ ⲘⲎ ⲀⲤⲈⲢⲘⲈⲖⲒⲚ ⲘⲪⲚⲞⲨϮ ϦⲀ ⲚⲒⲈϨⲰⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ϢⲀⲚ ⲠⲀⲚⲦⲰⲤ ⲀϤϪⲰ ⲘⲘⲞⲤ ⲈⲐⲂⲎ ⲦⲈⲚ ⲈⲦⲀⲨⲤϦⲎⲦⲞⲨ ⲄⲀⲢ ⲈⲐⲂⲎⲦⲈⲚ ϪⲈ ⲤⲈⲘⲠϢⲀ ⲚⲦⲈⲪⲎ ⲈⲦⲤⲬⲀⲒ ⲚⲦⲈϤⲤⲬⲀⲒ ϦⲈⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲞⲨⲞϨ ⲪⲎ ⲈⲦϨⲒ ⲚⲦⲈϤⲈⲢϨⲈⲖⲠⲒⲤ ⲈϬⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ⲒⲤϪⲈ ⲀⲚⲞⲚ ⲀⲚⲤⲒϮ ⲚⲰⲦⲈⲚ ⲚⲚⲒⲠⲚⲀⲦⲒⲔⲞⲚ ⲞⲨⲚⲒϢϮ ⲠⲈ ⲈϢⲰⲠ ⲀⲚϢⲀⲚⲰⲤϦ ⲚⲦⲈⲦⲈⲚⲤⲀⲢⲔⲒⲔⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ⲒⲤϪⲈ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈⲦϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈⲦⲈⲚⲈⲢϢⲒϢⲒ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲀⲚⲞⲚ ⲀⲖⲖⲀ ⲘⲠⲈⲚⲬⲢⲀⲤⲐⲈ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ⲀⲖⲖⲀ ⲦⲈⲚⲰⲞⲨ ⲚϨⲎⲦ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϨⲒⲚⲀ ⲚⲦⲈⲚϢⲦⲈⲘϮ ϨⲖⲒ ⲚϬⲢⲞⲠ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲎ ⲈⲦⲈⲢϨⲰⲂ ⲈⲚⲒⲈⲢⲪⲎⲞⲨⲒ ϢⲀⲨⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲚⲀ ⲠⲒⲈⲢⲪⲈⲒ ⲞⲨⲞϨ ⲚⲎ ⲈⲐⲘⲎⲚ ⲈⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ ϢⲀⲨⲪⲰϢ ⲈϨⲢⲀⲨ ⲚⲈⲘ ⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ⲠⲀⲒⲢⲎϮ ϨⲰϤ ⲠϬⲞⲒⲤ ⲀϤⲐⲰϢ ⲚⲚⲎ ⲈⲦϨⲒⲰⲒϢ ⲘⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲈⲰⲚϦ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ⲀⲚⲞⲔ ⲆⲈ ⲘⲠⲒⲈⲢⲬⲢⲀⲤⲐⲈ ⲚⲞⲨⲞⲚ ⲚⲚⲀⲒ ⲚⲈⲦⲀⲒⲤϦⲈ ⲚⲀⲒ ⲆⲈ ⲀⲚ ϨⲒⲚⲀ ⲚⲤⲈϢⲰⲠⲒ ⲘⲠⲀⲒⲢⲎϮ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲚⲀⲚⲈⲤ ⲄⲀⲢ ⲚⲎⲒ ⲘⲀⲖⲖⲞⲚ ⲈⲘⲞⲨ ⲒⲈ ⲠⲀϢⲞⲨϢⲞⲨ ⲚⲦⲈϢⲦⲈⲘ ϨⲖⲒ ϢⲞⲨⲰϤ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ⲈϢⲰⲠ ⲄⲀⲢ ⲀⲒϢⲀⲚϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲞⲨϢⲞⲨϢⲞⲨ ⲚⲎⲒ ⲀⲚ ⲠⲈ ⲞⲨⲀⲚⲀⲄⲔⲎ ⲄⲀⲢ ⲈⲦⲬⲎ ϨⲒϪⲰⲒ ⲞⲨⲞⲒ ⲄⲀⲢ ⲚⲎⲒ ⲈϢⲰⲠ ⲀⲒϢⲦⲈⲘϨⲒϢⲈⲚⲚⲞⲨϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ⲒⲤϪⲈ ⲄⲀⲢ ⲀⲒⲒⲢⲒ ⲘⲪⲀⲒ ⲈϨⲚⲎⲒ ⲒⲈ ⲞⲨⲞⲚϮ ⲂⲈⲬⲈ ⲘⲘⲀⲨ ⲒⲤϪⲈ ⲈϨⲚⲎⲒ ⲀⲚ ⲒⲈ ⲞⲨⲞⲒⲔⲞⲚⲞⲘⲒⲀ ⲠⲈⲦⲀⲨⲦⲈⲚϨⲞⲨⲦ ⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ⲀϢ ⲞⲨⲚ ⲠⲈ ⲠⲀⲂⲈⲬⲈ ϨⲒⲚⲀ ⲈⲒϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲦⲀⲬⲀ ⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲀϬⲚⲈ ⲦⲀⲠⲀⲚⲎ ⲈϢⲦⲈⲘⲈⲢⲬⲢⲀⲤⲐⲈ ⲘⲠⲀⲒⲈⲢϢⲒϢⲒ ϦⲈⲚⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ⲈⲒⲞⲒ ⲄⲀⲢ ⲚⲢⲈⲘϨⲈ ⲈⲂⲞⲖ ϨⲀ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲀⲒⲀⲒⲦ ⲘⲂⲰⲔ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ϨⲒⲚⲀ ⲚⲦⲀϪⲈⲘϨⲎⲞⲨ ⲘⲠⲒϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ⲀⲒϢⲰⲠⲒ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲒⲞⲨⲆⲀⲒ ϨⲒⲚⲀ ⲚⲦⲀϪⲈⲘϨⲎⲞⲨ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲀⲒϢⲰⲠⲒ ⲚⲚⲎ ⲈⲦⲬⲎ ϦⲀ ⲪⲚⲞⲘⲞⲤ ⲘⲪⲢⲎϮ ⲚⲈⲒⲬⲎ ϦⲀ ⲪⲚⲞⲘⲞⲤ ⲚϮⲬⲎ ⲀⲚⲞⲔ ⲀⲚ ϦⲀ ⲪⲚⲞⲘⲞⲤ ϨⲒⲚⲀ ⲚⲦⲀϪⲈⲘϨⲎⲞⲨ ⲚⲚⲎ ⲈⲦⲬⲎ ϦⲀ ⲪⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ⲀⲒϢⲰⲠⲒ ⲚⲚⲒⲀⲚⲞⲘⲞⲤ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲚⲞⲘⲞⲤ ⲈⲀⲚⲞⲔ ⲞⲨⲀⲚⲞⲘⲞⲤ ⲀⲚ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ⲈⲒⲬⲎ ϦⲀ ⲪⲚⲞⲘⲞⲤ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲒⲚⲀ ⲚⲦⲀϪⲈⲘϨⲎⲞⲨ ⲚⲚⲒⲀⲚⲞⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ⲀⲒϢⲰⲠⲒ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲘⲪⲢⲎϮ ⲚⲞⲨⲢⲈϤϢⲰⲚⲒ ϨⲒⲚⲀ ⲚⲦⲀϪⲈⲘϨⲎⲞⲨ ⲚⲚⲎ ⲈⲦϢⲰⲚⲒ ⲀⲒϢⲰⲠⲒ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲚⲢⲎϮ ⲚⲒⲂⲈⲚ ϨⲒⲚⲀ ⲠⲀⲚⲦⲰⲤ ⲚⲦⲀⲚⲞϨⲈⲘ ⲚϨⲀⲚⲞⲨⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ϮⲒⲢⲒ ⲘⲘⲰⲞⲨ ⲈⲐⲂⲈ ⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ϨⲒⲚⲀ ⲚⲦⲀⲈⲢϢⲪⲎⲢ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲀⲚ ϪⲈ ⲚⲎ ⲈⲦϬⲞϪⲒ ϦⲈⲚⲠⲒⲤⲦⲀⲆⲒⲞⲚ ⲤⲈϬⲞϪⲒ ⲘⲈⲚ ⲦⲎⲢⲞⲨ ⲞⲨⲀⲒ ⲆⲈ ⲈϢⲀϤϬⲒ ⲘⲠⲒⲂⲀⲒ ⲠⲀⲒⲢⲎϮ ⲆⲈ ϬⲞϪⲒ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲦⲀϨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ⲞⲨⲞⲚ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲢⲀⲄⲰⲚⲒⲌⲈⲤⲐⲈ ϢⲀϤⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲚⲎ ⲘⲈⲚ ϨⲒⲚⲀ ⲚⲤⲈϬⲒ ⲚⲞⲨⲬⲖⲞⲘ ⲈϤⲚⲀⲦⲀⲔⲞ ⲀⲚⲞⲚ ⲆⲈ ⲞⲨⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ⲀⲚⲞⲔ ⲆⲈ ϮϬⲞϪⲒ ⲘⲠⲀⲒⲢⲎϮ ϨⲰⲤ ϦⲈⲚⲞⲨϨⲰⲠ ⲀⲚ ⲠⲀⲒⲢⲎϮ ϮϮ ϨⲰⲤ ⲈⲒϨⲒⲞⲨⲒ ⲀⲚ ⲈⲠⲒⲀⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ⲀⲖⲖⲀ ϮⲰϤⲒ ⲘⲠⲀⲤⲰⲘⲀ ⲞⲨⲞϨ ϮⲒⲢⲒ ⲘⲘⲞϤ ⲘⲂⲰⲔ ⲘⲎⲠⲰⲤ ⲈⲀⲒϨⲒⲰⲒϢ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲀⲚⲞⲔ ϨⲰ ⲚⲤⲈϪⲈⲘⲦ ⲈⲒⲞⲒ ⲚⲀⲆⲞⲔⲒⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ⲚϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲄⲀⲢ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲚⲈⲚⲒⲞϮ ⲦⲎⲢⲞⲨ ⲚⲀⲨⲬⲎ ϦⲀ ϮϬⲎⲠⲒ ⲠⲈ ⲞⲨⲞϨ ⲀⲨⲤⲒⲚⲒ ⲦⲎⲢⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ⲞⲨⲞϨ ⲀⲨϬⲒⲰⲘⲤ ⲦⲎⲢⲞⲨ ⲈⲘⲰⲨⲤⲎⲤ ϦⲈⲚϮϬⲎⲠⲒ ⲚⲈⲘ ϦⲈⲚⲪⲒⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ⲞⲨⲞϨ ⲦⲀⲒϦⲢⲈ ⲚⲞⲨⲰⲦ ⲘⲠⲚⲀⲦⲒⲔⲞⲚ ⲀⲨⲞⲨⲞⲘⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ⲞⲨⲞϨ ⲠⲀⲒⲤⲰ ⲚⲞⲨⲰⲦ ⲘⲠⲚⲀⲦⲒⲔⲞⲚ ⲀⲨⲤⲞϤ ⲦⲎⲢⲞⲨ ⲚⲀⲨⲤⲰ ⲄⲀⲢ ⲠⲈ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲠⲚⲀⲦⲒⲔⲎ ⲘⲠⲈⲦⲢⲀ ⲈⲤⲘⲞϢⲒ ⲚⲤⲰⲞⲨ ϮⲠⲈⲦⲢⲀ ⲆⲈ ⲚⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ⲀⲖⲖⲀ ⲘⲠⲈ ⲪⲚⲞⲨϮ ϮⲘⲀϮ ϦⲈⲚⲠⲞⲨϨⲞⲨⲞ ⲀⲨⲪⲰϢ ⲄⲀⲢ ⲚϨⲢⲎⲒ ϨⲒ ⲠϢⲀϤⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ⲚⲀⲒ ⲆⲈ ⲀⲨϢⲰⲠⲒ ⲚⲀⲚ ⲚϨⲀⲚⲦⲨⲠⲞⲤ ϪⲈ ⲚⲦⲈⲚϢⲦⲈⲘϢⲰⲠⲒ ⲈⲚⲞⲒ ⲚⲢⲈϤⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ ⲚϨⲀⲚⲠⲈⲦϨⲰⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀ ⲚⲎ ⲈⲢⲈⲠⲒⲐⲨⲘⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ⲞⲨⲆⲈ ⲘⲠⲈⲢϢⲰⲠⲒ ⲚϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲞⲨⲞⲚ ⲚϦⲎⲦⲞⲨ ⲘⲪⲢⲎϮ ⲈⲦⲤϦⲎ ⲞⲨⲦ ϪⲈ ⲀϤϨⲈⲘⲤⲒ ⲚϪⲈⲠⲒⲖⲀⲞⲤ ⲈⲞⲨⲰⲘ ⲚⲈⲘ ⲈⲤⲰ ⲞⲨⲞϨ ⲀⲨⲦⲰⲞⲨⲚⲞⲨ ⲈⲤⲰⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ⲞⲨⲆⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲈⲢⲠⲞⲢⲚⲈⲨⲒⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲞⲨⲞⲚ ⲚϦⲎⲦⲞⲨ ⲈⲀⲨⲈⲢⲠⲞⲢⲚⲈⲨⲒⲚ ⲞⲨⲞϨ ⲀⲨϨⲈⲒ ϦⲈⲚⲞⲨⲈϨⲞⲞⲨ ⲚⲞⲨⲰⲦ ⲚϪⲈⲔⲄ ⲚϢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ⲞⲨⲆⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲚϨⲀⲚⲞⲨⲞⲚ ⲚϦⲎⲦⲞⲨ ⲈⲀⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲞⲨⲞϨ ⲀⲨⲦⲀⲔⲞ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲞⲨ ⲚⲚⲒϨⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ⲞⲨⲆⲈ ⲘⲠⲈⲚⲐⲢⲈⲚⲈⲢⲢⲈϤⲈⲢⲬⲢⲈⲘⲢⲈⲘ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲚϨⲀⲚⲞⲨⲞⲚ ⲈⲂⲞⲖ ⲚϦⲎⲦⲞⲨ ⲈⲀⲨⲬⲢⲈⲘⲢⲈⲘ ⲞⲨⲞϨ ⲀⲨⲦⲀⲔⲞ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲘⲠⲒⲢⲈϤⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲀⲨϢⲰⲠⲒ ⲚⲦⲨⲠⲞⲤ ⲚⲚⲎ ⲀⲨⲤϦⲎⲦⲞⲨ ⲆⲈ ⲚⲀⲚ ⲈⲨⲤⲂⲰ ϦⲀ ⲚⲎ ⲈⲦⲀ ⲠϪⲰⲔ ⲚⲚⲒⲈⲚⲈϨ ⲈⲢⲔⲀⲦⲀⲚⲦⲀⲚ ⲈⲢⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ϨⲰⲤⲦⲈ ⲪⲎ ⲈⲐⲘⲈⲨⲒ ϪⲈ ϤⲞϨⲒ ⲈⲢⲀⲦϤ ⲘⲀⲢⲈϤⲚⲀⲨ ⲘⲎⲠⲰⲤ ⲚⲦⲈϤϨⲈⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ⲘⲠⲈ ⲠⲒⲢⲀⲤⲘⲞⲤ ⲦⲀϨⲈ ⲐⲎⲚⲞⲨ ⲈⲂⲎⲖ ⲈⲠⲒⲢⲀⲤⲘⲞⲤ ⲚⲢⲰⲘⲒ ϤⲈⲚϨⲞⲦ ⲚϪⲈⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲈⲚϤⲚⲀⲬⲀ ⲐⲎⲚⲞⲨ ⲀⲚ ⲈⲐⲢⲞⲨⲈⲢⲠⲒⲢⲀⲌⲒⲚ ⲘⲘⲰⲦⲈⲚ ⲤⲀⲂⲞⲖ ⲘⲪⲎ ⲈⲦⲈ ⲞⲨⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲢⲞϤ ⲀⲖⲖⲀ ⲈϤⲈϮⲦⲞⲦϤ ⲚⲈⲘⲰⲦⲈⲚ ϦⲈⲚⲠⲒⲢⲀⲤⲘⲞⲤ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢϪⲈⲘϪⲞⲘ ⲚϤⲀⲒ ϢⲀⲦⲈⲦⲈⲚⲒ ⲈⲂⲞⲖ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ⲈⲐⲂⲈ ⲪⲀⲒ ⲚⲀⲘⲈⲚⲢⲀϮ ⲪⲰⲦ ⲈⲂⲞⲖ ϨⲀ ϮⲘⲈⲦϢⲀⲘϢⲈ ⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ⲀⲒϪⲰ ⲘⲘⲞⲤ ⲚⲰⲦⲈⲚ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲤⲀⲂⲈⲨ ⲘⲀϨⲀⲠ ⲚⲐⲰⲦⲈⲚ ⲈⲠⲈϮϪⲰ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ⲠⲒⲀⲪⲞⲦ ⲚⲦⲈϮⲈⲨⲖⲞⲄⲒⲀ ⲪⲎ ⲈⲦⲈⲚⲤⲘⲞⲨ ⲈⲢⲞϤ ⲘⲎ ϮⲘⲈⲦϢⲪⲎⲢ ⲀⲚ ⲦⲈ ⲚⲦⲈⲠⲤⲚⲞϤ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲒⲰⲒⲔ ⲈⲦⲈⲚⲪⲰϢ ⲘⲘⲞϤ ⲘⲎ ϮⲘⲈⲦϢⲪⲎⲢ ⲀⲚ ⲦⲈ ⲚⲦⲈⲠⲤⲰⲘⲀ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ϪⲈ ⲀⲚⲞⲚ ⲦⲈⲚⲞⲒ ⲚⲞⲨⲀⲒ ⲚⲞⲨⲰⲒⲔ ⲞⲨⲀⲒ ⲚⲤⲰⲘⲀ ϦⲀ ⲚⲒⲘⲎϢ ⲀⲚⲞⲚ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲦⲈⲚϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲰⲒⲔ ⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ⲀⲚⲀⲨ ⲈⲠⲒⲤⲖ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ⲘⲎ ⲚⲎ ⲀⲚ ⲈⲐⲞⲨⲰⲘ ⲚⲚⲒϢⲞⲨϢⲰⲞⲨϢⲒ ⲈⲦⲞⲒ ⲚϢⲪⲎⲢ ⲈⲠⲒⲘⲀⲚⲈⲢϢⲰⲞⲨϢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ⲞⲨ ϪⲈ ⲠⲈⲦϮϪⲰ ⲘⲘⲞϤ ϪⲈ ϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲞⲨ ⲠⲈ ⲒⲈ ϪⲈ ⲞⲨ ⲚⲐⲞϤ ⲠⲈ ⲒⲆⲰⲖⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ⲀⲖⲖⲀ ϪⲈ ⲚⲈⲦⲞⲨϢⲰⲦ ⲘⲘⲰⲞⲨ ⲚϪⲈⲚⲒⲈⲐⲚⲞⲤ ⲀⲨϢⲰⲦ ⲘⲘⲰⲞⲨ ⲚⲚⲒⲒⲆⲰⲖⲞⲚ ⲞⲨⲞϨ ⲪⲚⲞⲨϮ ⲀⲚ ⲚϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚϢⲪⲎⲢ ⲚⲚⲒⲆⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲀⲪⲞⲦ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲈⲘ ⲠⲒⲀⲪⲞⲦ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲘⲘⲰⲦⲈⲚ ⲈϬⲒ ⲈⲂⲞⲖ ϦⲈⲚϮⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲈⲘ ϮⲦⲢⲀⲠⲈⲌⲀ ⲚⲦⲈⲚⲒⲆⲈⲘⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ϢⲀⲚ ⲀⲚⲚⲀϮⲬⲞϨ ⲘⲠϬⲞⲒⲤ ⲘⲎ ⲀⲚⲞⲚ ϨⲀⲚϪⲰⲢⲒ ⲈϨⲞⲦⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ⲤϢⲈ ⲚⲈⲢ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲤⲈⲢⲚⲞϤⲢⲒ ⲦⲎⲢⲞⲨ ⲀⲚ ⲈⲜⲈⲤⲦⲒⲚ ⲈⲈⲢ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲀⲖⲖⲀ ⲤⲈⲔⲰⲦ ⲦⲎⲢⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ⲔⲰϮ ⲚⲤⲀⲠⲈⲦⲈⲪⲰϤ ⲘⲘⲀⲨⲀⲦϤ ⲀⲖⲖⲀ ⲚⲤⲀⲪⲀ ⲠⲈϤϢⲪⲎⲢ ");
INSERT INTO copbhc_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨϮ ⲘⲘⲰⲞⲨ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲘⲀⲔⲈⲖⲖⲞⲤ ⲞⲨⲘⲞⲨ ⲚⲦⲈⲦⲈⲚϦⲞⲦϦⲈⲦ ⲀⲚ ⲚϨⲖⲒ ⲈⲐⲂⲈ ϮⲤⲨⲚⲎⲆⲈⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ⲪⲀ ⲠϬⲞⲒⲤ ⲄⲀⲢ ⲠⲈ ⲠⲒⲔⲀϨⲒ ⲚⲈⲘ ⲠⲈϤⲘⲞϨ. ");
INSERT INTO copbhc_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲚⲚⲒⲀⲐⲚⲀϨϮ ⲐⲰϨⲈⲘ ⲘⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲞⲨⲰϢ ⲘⲀϢⲈ ⲚⲰⲦⲈⲚ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲨⲚⲀⲬⲀⲨ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲞⲨⲞⲘⲞⲨ ⲚⲦⲈⲦⲈⲚϦⲞⲦϦⲈⲦ ⲀⲚ ⲚϨⲖⲒ ⲈⲐⲂⲈ ϮⲤⲨⲚⲎⲆⲈⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨⲀⲒ ϪⲞⲤ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨϢⲰⲦ ⲚⲒⲆⲰⲖⲞⲚ ⲠⲈ ⲪⲀⲒ ⲘⲠⲈⲢⲞⲨⲰⲘ ⲈⲐⲂⲈ ⲪⲎ ⲈⲦⲀϤⲦⲀⲘⲰⲦⲈⲚ ⲚⲈⲘ ⲈⲐⲂⲈ ϮⲤⲨⲚⲎⲆⲈⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ϮϪⲰ ⲆⲈ ⲈⲐⲂⲈ ⲞⲨⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲚⲐⲰⲔ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲐⲀ ⲠⲈⲔϢⲪⲎⲢ ⲈⲐⲂⲈⲞⲨ ⲄⲀⲢ ⲦⲀⲘⲈⲦⲢⲈⲘϨⲈ ⲤⲈⲚⲀϮϨⲀⲠ ⲈⲢⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲔⲈⲤⲨⲚⲎⲆⲈⲤⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ⲒⲤϪⲈ ⲀⲚⲞⲔ ϮϬⲒ ϦⲈⲚⲞⲨϢⲈⲠϨⲘⲞⲦ ⲈⲐⲂⲈⲞⲨ ⲤⲈϪⲈⲞⲨⲀ ⲈⲢⲞⲒ ⲈϪⲈⲚ ⲪⲎ ⲀⲚⲞⲔ ⲈϮϢⲈⲠϨⲘⲞⲦ ⲈϨⲢⲎⲒ ⲈϪⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ⲒⲦⲈ ⲞⲨⲚ ⲦⲈⲦⲈⲚⲞⲨⲰⲘ ⲒⲦⲈ ⲦⲈⲦⲈⲚⲤⲰ ⲒⲦⲈ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲚⲔⲈϨⲰⲂ ⲀⲢⲒ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲠϮⲰⲞⲨ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ⲞⲨⲞϨ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦϬⲢⲞⲠ ⲚⲚⲒⲒⲞⲨⲆⲀⲒ ⲚⲈⲘ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲚⲈⲘ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰ ⲈⲦⲈ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϮⲢⲀⲚⲀϤ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲚϮⲔⲰϮ ⲀⲚ ⲚⲤⲀⲦⲀⲚⲞϤⲢⲒ ⲘⲘⲀⲨⲀⲦ ⲀⲖⲖⲀ ⲐⲀ ⲚⲒⲘⲎϢ ϨⲒⲚⲀ ⲚⲤⲈⲚⲞϨⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲞⲚⲒ ⲘⲘⲞⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰ ⲈϮⲞⲚⲒ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ϮⲦⲀⲒⲞ ⲆⲈ ⲘⲘⲰⲦⲈⲚ ϪⲈ ⲦⲈⲦⲈⲚⲒⲢⲒ ⲘⲠⲀⲘⲈⲨⲒ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲒϮ ⲚⲚⲒⲠⲀⲢⲀⲆⲞⲤⲒⲤ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲦⲈⲦⲈⲚⲀⲘⲞⲚⲒ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲈⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲦⲀⲪⲈ ⲚⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲀⲪⲈ ⲆⲈ ⲚϮⲤϨⲒⲘⲒ ⲠⲈⲤϨⲀⲒ ⲠⲈ ⲦⲀⲪⲈ ⲆⲈ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ⲈⲦⲦⲰⲂϨ ⲒⲈ ⲈϤⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ ⲈⲢⲈ ϪⲰϤ ϨⲰⲂⲤ ⲈϤϮϢⲒⲠⲒ ⲚⲦⲈϤⲀⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ⲤϨⲒⲘⲒ ⲆⲈ ⲚⲒⲂⲈⲚ ⲈⲤⲦⲰⲂϨ ⲒⲈ ⲈⲤⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ ⲚϪⲰⲤ ϨⲰⲂⲤ ⲀⲚ ⲤϮϢⲒⲠⲒ ⲚⲦⲈⲤⲀⲪⲈ ⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲈ ⲞⲨⲞϨ ⲪⲀⲒ ⲢⲰ ⲠⲈ ⲚⲐⲎ ⲈⲦⲈ ϪⲰⲤ ϦⲞⲔϨⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ⲒⲤϪⲈ ⲄⲀⲢ ⲘⲘⲞⲚ ⲞⲨⲤϨⲒⲘⲒ ⲚⲀϨⲈⲂⲤ ϪⲰⲤ ⲒⲈ ⲘⲀⲢⲈⲤϦⲞⲔϨϤ ⲒⲤϪⲈ ⲞⲨϢⲰϢ ⲠⲈ ⲈⲞⲨⲤϨⲒⲘⲒ ⲈϪⲈⲂⲤ ϪⲰⲤ ⲒⲈ ⲈϦⲞⲔϨϤ ⲒⲈ ⲘⲀⲢⲈⲤϨⲈⲂⲤ ϪⲰⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ⲠⲒⲢⲰⲘⲒ ⲘⲈⲚ ⲄⲀⲢ ⲤⲈⲘⲠϢⲀ ⲚⲀϤ ⲀⲚ ⲚⲦⲈϤϨⲈⲂⲤ ϪⲰϤ ϪⲈ ⲞⲨϨⲒⲔⲰⲚ ⲚⲈⲘ ⲞⲨⲰⲞⲨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲈ ϮⲤϨⲒⲘⲒ ⲆⲈ ⲚⲐⲞⲤ ⲞⲨⲰⲞⲨ ⲚⲦⲈⲠⲈⲤϨⲀⲒ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ⲚⲈⲦⲀⲨⲈⲚ ⲠⲒⲢⲰⲘⲒ ⲄⲀⲢ ⲀⲚ ⲈⲂⲞⲖ ϦⲈⲚϮⲤϨⲒⲘⲒ ⲀⲖⲖⲀ ϮⲤϨⲒⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ⲔⲈ ⲄⲀⲢ ⲚⲈⲦⲀⲨⲤⲈⲚⲦ ⲠⲒⲢⲰⲘⲒ ⲀⲚ ⲈⲐⲂⲈ ϮⲤϨⲒⲘⲒ ⲀⲖⲖⲀ ϮⲤϨⲒⲘⲒ ⲈⲐⲂⲈ ⲠⲒⲢⲰⲘⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ⲈⲐⲂⲈⲪⲀⲒ ⲤⲈⲘⲠϢⲀ ⲚⲦⲈϮⲤϨⲒⲘⲒ ⲬⲀ ⲞⲨⲈⲢϢⲰⲚ ⲈϪⲈⲚ ⲦⲈⲤⲀⲪⲈ ⲈⲐⲂⲈ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ⲠⲖⲎⲚ ⲞⲨⲆⲈ ⲘⲘⲞⲚ ⲞⲨⲤϨⲒⲘⲒ ⲬⲰⲢⲒⲤ ⲢⲰⲘⲒ ⲞⲨⲆⲈ ⲢⲰⲘⲒ ⲬⲰⲢⲒⲤ ⲤϨⲒⲘⲒ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ϮⲤϨⲒⲘⲒ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲢⲰⲘⲒ ⲠⲈ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲢⲰⲘⲒ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚϮⲤϨⲒⲘⲒ ⲠⲈ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϨⲀⲚⲈⲂⲞⲖ ⲘⲪⲚⲞⲨϮ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ⲘⲀϨⲀⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲦⲈⲚ ϪⲈ ⲀⲤⲤϢⲈ ⲚⲞⲨⲤϨⲒⲘⲒ ⲈⲐⲢⲈⲤⲦⲰⲂϨ ⲘⲪⲚⲞⲨϮ ⲚϪⲰⲤ ϨⲞⲂⲤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ⲞⲨⲆⲈ ⲚⲐⲞⲤ ϮⲪⲨⲤⲒⲤ ϮⲤⲂⲰ ⲚⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲠⲒⲢⲰⲘⲒ ⲘⲈⲚ ⲄⲀⲢ ⲈϢⲰⲠ ⲈⲢⲈ ϪⲰϤ ϢⲎⲞⲨ ⲞⲨϢⲰϢ ⲚⲀϤ ⲠⲈ ");
INSERT INTO copbhc_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ϮⲤϨⲒⲘⲒ ⲆⲈ ⲚⲐⲞⲤ ⲈϢⲰⲠ ⲈⲢⲈ ϪⲰⲤ ϢⲎⲞⲨ ⲞⲨⲰⲞⲨ ⲚⲀⲤ ⲠⲈ ϪⲈ ⲈⲦⲀⲨϮ ⲘⲠⲒϤⲰⲒ ⲚⲀⲤ ⲚⲦϢⲈⲂⲒⲰ ⲚⲞⲨⲈⲢϢⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ⲒⲤϪⲈ ⲆⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲘⲈⲨⲒ ⲈⲈⲢⲢⲈϤϢϬ ⲚⲎⲚ ⲀⲚⲞⲚ ⲆⲈ ⲘⲘⲞⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲚⲞⲨⲔⲀϨⲤ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲆⲈ ⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ⲪⲀⲒ ⲆⲈ ⲈⲒϨⲞⲚϨⲈⲚ ⲘⲘⲞϤ ⲚⲀⲒⲐⲘⲀⲒⲞ ⲘⲘⲰⲦⲈⲚ ⲀⲚ ϪⲈ ⲈⲦⲀⲢⲈⲦⲈⲚⲐⲰⲞⲨϮ ⲈⲠⲈⲦⲤⲰⲦⲠ ⲀⲚ ⲀⲖⲖⲀ ⲪⲎ ⲈⲦⲐⲈⲂⲒⲎⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ⲚϢⲞⲢⲠ ⲘⲈⲚ ⲄⲀⲢ ⲈⲢⲈⲦⲈⲚⲚⲀⲐⲰⲞⲨϮ ϨⲒ ⲞⲨⲘⲀ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ϮⲤⲰⲦⲈⲘ ⲈϨⲀⲚⲪⲰⲢϪ ⲈⲨϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ϮⲚⲀϨϮ ϦⲈⲚⲞⲨⲘⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ϨⲰϮ ⲄⲀⲢ ⲚⲦⲈϨⲀⲚϨⲈⲢⲈⲤⲒⲤ ϢⲰⲠⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ϨⲒⲚⲀ ⲚⲒⲤⲰⲦⲠ ϨⲰⲞⲨ ⲈⲦϦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲤⲈⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ⲈⲢⲈⲦⲈⲚⲚⲀⲐⲰⲞⲨϮ ⲞⲨⲚ ϨⲒ ⲞⲨⲘⲀ ⲚⲞⲨⲔⲨⲢⲒⲀⲔⲞⲚ ⲚⲆⲒⲠⲚⲞⲚ ⲀⲚ ⲠⲈ ⲈⲞⲨⲞⲘϤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ⲠⲒⲞⲨⲀⲒ ⲄⲀⲢ ⲠⲒⲞⲨⲀⲒ ϤⲈⲢϢⲞⲢⲠ ⲚϬⲒ ⲈⲂⲞⲖ ϦⲈⲚⲠⲈϤⲆⲒⲠⲚⲞⲚ ⲈⲞⲨⲰⲘ ⲞⲨⲞⲚ ⲠⲈⲦϨⲞⲔⲈⲢ ⲘⲈⲚ ⲞⲨⲞⲚ ⲠⲈⲦⲐⲀϦⲒ ⲆⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ⲘⲎ ⲄⲀⲢ ⲘⲘⲞⲚⲦⲈⲦⲈⲚ ⲎⲒ ⲘⲘⲀⲨ ⲈⲞⲨⲰⲘ ⲚⲈⲘ ⲈⲤⲰ ϢⲀⲚ ⲀⲢⲈⲦⲈⲚⲈⲢⲔⲀⲦⲀⲪⲢⲞⲚⲒⲚ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲦⲈⲦⲈⲚϮϢⲒⲠⲒ ⲚⲚⲎ ⲈⲦⲈ ⲘⲘⲞⲚ ⲚⲦⲰⲞⲨ ⲞⲨ ⲠⲈϮⲚⲀϪⲞϤ ⲚⲰⲦⲈⲚ ⲚⲦⲀⲐⲘⲀⲒⲈ ⲐⲎⲚⲞⲨ ϦⲈⲚⲪⲀⲒ ⲚϮⲚⲀⲐⲘⲀⲒⲈ ⲐⲎⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ⲀⲚⲞⲔ ⲄⲀⲢ ⲀⲒϬⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠϬⲞⲒⲤ ⲘⲪⲎ ⲈⲦⲀⲒⲦⲎⲒϤ ⲈⲦⲈⲚ ⲐⲎⲚⲞⲨ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ϦⲈⲚⲠⲒϪⲰⲢϨ ⲈⲚⲀⲨⲚⲀⲦⲎⲒϤ ⲚϦⲎⲦϤ ⲀϤϬⲒ ⲚⲞⲨⲰⲒⲔ ");
INSERT INTO copbhc_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ⲞⲨⲞϨ ⲀϤϢⲈⲠϨⲘⲞⲦ ⲀϤⲪⲀϢϤ ⲞⲨⲞϨ ⲀϤϪⲞⲤ ϪⲈ ⲪⲀⲒ ⲠⲈ ⲠⲀⲤⲰⲘⲀ ⲈⲦⲞⲨⲚⲀⲦⲎⲒϤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲪⲀⲒ ⲀⲢⲒⲦϤ ⲈⲠϪⲒⲚⲈⲢⲠⲀⲘⲈⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲒⲔⲈⲀⲪⲞⲦ ⲘⲈⲚⲈⲚⲤⲀ ⲠⲒⲆⲒⲠⲚⲞⲚ ⲈϤϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲠⲀⲒⲀⲪⲞⲦ ϮⲆⲒⲀⲐⲎⲔⲎ ⲘⲂⲈⲢⲒ ⲦⲈ ϦⲈⲚⲠⲀⲤⲚⲞϤ ⲪⲀⲒ ⲀⲢⲒⲦϤ ⲚⲤⲞⲠ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲤⲰ ⲘⲘⲞϤ ⲈⲢⲈⲦⲈⲚⲒⲢⲒ ⲘⲠⲀⲘⲈⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ⲤⲞⲠ ⲄⲀⲢ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲞⲨⲰⲘ ⲘⲠⲀⲒⲰⲒⲔ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲤⲰ ⲘⲠⲀⲒⲀⲪⲞⲦ ⲈⲢⲈⲦⲈⲚϨⲒⲰⲒϢ ⲘⲪⲘⲞⲨ ⲘⲠϬⲞⲒⲤ ϢⲀⲦⲈϤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ϨⲰⲤⲦⲈ ⲪⲎ ⲈⲐⲚⲀⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲰⲒⲔ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲀⲪⲞⲦ ⲚⲦⲈⲠϬⲞⲒⲤ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦⲘⲠϢⲀ ⲈϤⲈϢⲰⲠⲒ ⲈϤⲞⲒ ⲚⲈⲚⲞⲬⲞⲤ ⲘⲠⲒⲤⲰⲘⲀ ⲚⲈⲘ ⲠⲒⲤⲚⲞϤ ⲚⲦⲈⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ⲘⲀⲢⲈ ⲠⲒⲢⲰⲘⲒ ⲆⲈ ⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲘⲀⲢⲈϤⲞⲨⲰⲘ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲰⲒⲔ ⲞⲨⲞϨ ⲚⲦⲈϤⲤⲰ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲀⲪⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ⲪⲎ ⲄⲀⲢ ⲈⲐⲞⲨⲰⲘ ⲞⲨⲞϨ ⲈⲦⲤⲰ ⲀϤⲞⲨⲰⲘ ⲞⲨⲞϨ ⲀϤⲤⲰ ⲈⲨϨⲀⲠ ⲚⲀϤ ⲚⲢⲈϤⲈⲢⲆⲒⲀⲔⲢⲒⲚⲒⲚ ⲘⲠⲒⲤⲰⲘⲀ ⲀⲚ ");
INSERT INTO copbhc_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ⲈⲐⲂⲈⲪⲀⲒ ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ϢⲰⲚⲒ ϦⲈⲚⲐⲎⲚⲞⲨ ⲞⲨⲞϨ ⲤⲈⲘⲞⲔϨ ⲞⲨⲞϨ ⲤⲈⲚⲔⲞⲦ ⲚϪⲈⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ⲈⲚⲀⲚⲈⲢⲆⲒⲀⲔⲢⲒⲚⲒⲚ ⲄⲀⲢ ⲘⲘⲞⲚ ⲚⲀⲨⲚⲀϮ ϨⲀⲠ ⲈⲢⲞⲚ ⲀⲚ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ⲈϤϮϨⲀⲠ ⲄⲀⲢ ⲈⲢⲞⲚ ⲚϪⲈⲪⲚⲞⲨϮ ⲈϤϮⲤⲂⲰ ⲚⲀⲚ ϨⲒⲚⲀ ⲚⲤⲈϢⲦⲈⲘϨⲒⲦⲈⲚ ⲘⲠϨⲀⲠ ⲚⲈⲘ ⲚⲒⲈⲐⲚⲞⲤ ");
INSERT INTO copbhc_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ϨⲰⲤⲦⲈ ⲞⲨⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲐⲰⲞⲨϮ ⲈⲞⲨⲰⲘ ⲞϨⲒ ⲚⲚⲈⲦⲈⲚⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲠⲈⲦϨⲞⲔⲈⲢ ⲘⲀⲢⲈϤⲞⲨⲰⲘ ϦⲈⲚⲠⲈϤⲎⲒ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϢⲦⲈⲘⲐⲰⲞⲨϮ ⲈⲨϨⲀⲠ ⲠⲤⲈⲠⲒ ⲆⲈ ⲀⲒϢⲀⲚⲒ ⲈⲒⲈⲐⲀϢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ⲈⲐⲂⲈ ⲚⲒⲠⲚⲀⲦⲒⲔⲞⲚ ⲆⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲚϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲈⲘⲒ ");
INSERT INTO copbhc_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ⲦⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲈⲐⲚⲞⲤ ⲈⲢⲈⲦⲈⲚⲬⲎ ϦⲀ ⲚⲒⲒⲆⲰⲖⲞⲚ ⲚⲀⲦϦⲢⲰⲞⲨ ⲚⲀⲢⲈⲦⲈⲚⲘⲞϢⲒ ⲘⲪⲢⲎϮ ⲈⲦⲀⲨⲈⲚ ⲐⲎⲚⲞⲨ ⲈϨⲢⲎⲒ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ⲈⲐⲂⲈ ⲪⲀⲒ ϮⲦⲀⲘⲞ ⲘⲘⲰⲦⲈⲚ ϪⲈ ⲘⲘⲞⲚ ϨⲖⲒ ⲈϤⲤⲀϪⲒ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ϪⲰ ⲘⲘⲞⲤ ϪⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲚⲀⲐⲈⲘⲀ ⲠⲈ ⲒⲎⲤⲞⲨⲤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈϨⲖⲒ ϪⲞⲤ ϪⲈ ⲠϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲒⲘⲎϮ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ⲞⲨⲞⲚ ϨⲀⲚⲦⲞⲒ ⲆⲈ ⲘⲪⲰϢ ⲈⲨϢⲞⲠ ⲚⲦⲈϨⲀⲚϨⲘⲞⲦ ⲈⲠⲀⲒⲠⲚⲈⲨⲘⲀⲢⲰ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ⲞⲨⲞϨ ⲞⲨⲞⲚ ϨⲀⲚⲦⲞⲒ ⲘⲪⲰϢ ⲈⲨϢⲞⲠ ⲚⲦⲈϨⲀⲚⲆⲒⲀⲔⲰⲚⲒⲀ ⲈⲠⲀⲒϬⲞⲒⲤ ⲢⲰ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ⲞⲨⲞϨ ⲞⲨⲞⲚ ϨⲀⲚⲦⲞⲒ ⲘⲪⲰϢ ⲚⲦⲈϨⲀⲚϨⲂⲎⲞⲨⲒ ⲈⲠⲀⲒⲚⲞⲨϮ ⲢⲰ ⲠⲈ ⲈⲦⲈⲢϨⲰⲂ ⲚⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϦⲈⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ⲠⲒⲞⲨⲀⲒ ⲆⲈ ⲠⲒⲞⲨⲀⲒ ⲤⲈϮ ⲚⲀϤ ⲘⲪⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲔⲀⲦⲀ ⲠⲈⲦⲈⲢⲚⲞϤⲢⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ⲞⲨⲀⲒ ⲘⲈⲚ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲒⲠⲚⲈⲨⲘⲀϢⲀⲨϮ ⲚⲀϤ ⲚⲞⲨⲤⲀϪⲒ ⲚⲤⲞⲪⲒⲀ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲚⲞⲨⲤⲀϪⲒ ⲚⲈⲘⲒ ⲔⲀⲦⲀ ⲠⲀⲒⲠⲚⲈⲨⲘⲀⲪⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲚⲞⲨⲚⲀϨϮ ϦⲈⲚⲠⲀⲒⲠⲚⲈⲨⲘⲀⲢⲰ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲚϨⲀⲚϨⲘⲞⲦ ⲚⲦⲀⲖϬⲞ ϦⲈⲚⲠⲀⲒⲠⲚⲈⲨⲘⲀⲢⲰ ⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲚϨⲀⲚϨⲂⲎⲞⲨⲒ ⲚϪⲞⲘ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ϨⲀⲚⲂⲰⲖ ⲘⲠⲚⲈⲨⲘⲀⲔⲈⲞⲨⲀⲒ ⲆⲈ ϨⲀⲚⲄⲈⲚⲞⲤ ⲚⲖⲀⲤ ⲔⲈⲞⲨⲀⲒ ⲆⲈ ⲞⲨⲈⲢⲘⲎⲚⲒⲀ ⲚⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ⲚⲀⲒ ⲆⲈ ⲦⲎⲢⲞⲨ ⲠⲒⲞⲨⲀⲒ ⲈⲦⲈⲢϨⲰⲂ ⲚϦⲎⲦⲞⲨ ⲠⲀⲒⲠⲚⲈⲨⲘⲀⲢⲰ ⲠⲈ ⲈϤⲪⲰϢ ⲘⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈϨⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ⲠⲒⲤⲰⲘⲀ ⲞⲨⲀⲒ ⲠⲈ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨⲘⲎϢ ⲘⲘⲈⲖⲞⲤ ⲘⲘⲀⲨ ⲚⲒⲘⲈⲖⲞⲤ ⲆⲈ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲠⲒⲤⲰⲘⲀ ⲈⲨⲞⲒ ⲚⲞⲨⲘⲎϢ ⲞⲨⲀⲒ ⲆⲈ ⲚⲤⲰⲘⲀ ⲠⲈ ⲠⲀⲒⲢⲎϮ ϨⲰϤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ⲔⲈ ⲄⲀⲢ ⲀⲚⲞⲚ ⲦⲎⲢⲈⲚ ⲈⲦⲀⲚϬⲒⲰⲘⲤ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲞⲨⲰⲦ ⲈⲨⲤⲰⲘⲀ ⲚⲞⲨⲰⲦ ⲒⲦⲈ ⲚⲒⲒⲞⲨⲆⲀⲒ ⲒⲦⲈ ⲚⲒⲞⲨⲈⲒⲚⲒⲚ ⲒⲦⲈ ⲂⲰⲔ ⲒⲦⲈ ⲢⲈⲘϨⲈ ⲞⲨⲞϨ ⲀⲚⲞⲚ ⲦⲎⲢⲈⲚ ⲀⲨⲦⲤⲞⲚ ⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲞⲨⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ⲔⲈ ⲄⲀⲢ ⲠⲒⲤⲰⲘⲀ ⲚⲞⲨⲘⲈⲖⲞⲤ ⲚⲞⲨⲰⲦ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ϮϬⲀⲖⲞϪ ϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨϪⲒϪ ⲀⲚ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲀⲚ ⲞⲨ ⲠⲀⲢⲀ ⲦⲞⲨⲦⲞ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠⲒⲘⲀϢϪ ϪⲞⲤ ϪⲈ ⲀⲚⲞⲔ ⲞⲨⲂⲀⲖ ⲀⲚ ⲀⲚⲞⲔ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲀⲚ ⲞⲨ ⲠⲀⲢⲀ ⲦⲞⲨⲦⲞ ⲈⲂⲞⲖ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲀⲚ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ⲈⲚⲈ ⲠⲒⲤⲰⲘⲀ ⲦⲎⲢϤ ⲞⲨⲂⲀⲖ ⲠⲈ ⲚⲈⲀϤⲐⲰⲚ ϨⲰϤ ⲠⲒⲤⲰⲦⲈⲘ ⲈⲚⲈ ⲞⲨⲤⲰⲦⲈⲘ ⲦⲎⲢϤ ⲠⲈ ⲀϤⲐⲰⲚ ϨⲰϤ ⲠⲒϢⲰⲖⲈⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ϮⲚⲞⲨ ⲆⲈ ⲀⲪⲚⲞⲨϮ ⲬⲰ ⲚⲚⲒⲘⲈⲖⲞⲤ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲞⲨ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲰϢ. ");
INSERT INTO copbhc_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ⲈⲚⲈ ⲞⲨⲘⲈⲖⲞⲤ ⲚⲞⲨⲰⲦ ⲦⲎⲢⲞⲨ ⲠⲈ ⲚⲈⲀϤⲐⲰⲚ ϨⲰϤ ⲠⲒⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ϮⲚⲞⲨ ⲆⲈ ⲞⲨⲘⲎϢ ⲘⲈⲚ ⲚⲈⲚⲒⲘⲈⲖⲞⲤ ⲞⲨⲀⲒ ⲆⲈ ⲠⲈ ⲠⲒⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ⲘⲘⲞⲚ ϢϪⲞⲘ ⲚⲦⲈⲠⲒⲂⲀⲖ ϪⲞⲤ ⲚϮϪⲒϪ ϪⲈ ϮⲈⲢⲬⲢⲒⲀ ⲘⲘⲞ ⲀⲚ ⲒⲈ ⲠⲀⲖⲒⲚ ϮⲀⲪⲈ ⲚⲚⲒϬⲀⲖⲀⲨϪ ϪⲈ ϮⲈⲢⲬⲢⲒⲀ ⲘⲘⲰⲦⲈⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ⲀⲖⲖⲀ ⲘⲀⲖⲖⲞⲚ ⲚⲒⲘⲈⲖⲞⲤ ⲈⲦⲞⲨⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ⲚⲦⲈⲠⲒⲤⲰⲘⲀ ϪⲈ ⲤⲈⲞⲒ ⲚϪⲰⲂ ⲚⲀⲒ ϨⲀⲚⲀⲚⲀⲄⲔⲈⲞⲚ ⲚϨⲞⲨⲞ ⲚⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲈⲚⲘⲈⲨⲒ ⲈⲢⲰⲞⲨ ⲚⲦⲈⲠⲒⲤⲰⲘⲀ ϪⲈ ⲤⲈϢⲎϢ ⲚⲀⲒ ⲆⲈ ⲚϮ ⲚⲰⲞⲨ ⲚⲞⲨⲦⲀⲒⲞ ⲚϨⲞⲨⲞ ⲞⲨⲞϨ ⲚⲎ ⲈⲦⲀϪⲀⲒⲰⲞⲨ ⲚⲦⲀⲚ ⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲚϨⲞⲨⲞ ⲈⲤⲀⲒ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ⲚⲎ ⲆⲈ ⲈⲦⲤⲀⲒⲰⲞⲨ ⲚⲦⲀⲚ ⲤⲈⲈⲢⲬⲢⲒⲀ ⲀⲚ ⲀⲖⲖⲀ ⲪⲚⲞⲨϮ ⲀϤⲐⲈⲦ ⲠⲒⲤⲰⲘⲀ ⲈⲀϤϮ ⲚⲞⲨϨⲞⲨⲞ ⲦⲀⲒⲞ ⲘⲪⲎ ⲈⲦϢⲀⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘⲪⲰⲢϪ ϢⲰⲠⲒ ϦⲈⲚⲠⲒⲤⲰⲘⲀ ⲀⲖⲖⲀ ⲚⲦⲈⲚⲒⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ϤⲒⲢⲰⲞⲨϢ ϦⲀ ⲚⲞⲨⲈⲢⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ⲞⲨⲞϨ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚ ⲞⲨⲘⲈⲖⲞⲤ ϬⲒⲘⲔⲀϨ ϢⲀⲢⲈ ⲚⲒⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ϬⲒⲘⲔⲀϨ ⲚⲈⲘⲀϤ ⲈϢⲰⲠ ⲈⲞⲨⲞⲚ ⲞⲨⲘⲈⲖⲞⲤ ϬⲒⲰⲞⲨ ϢⲀⲢⲈ ⲚⲒⲘⲈⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲢⲀϢⲒ ⲚⲈⲘⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ⲚⲐⲰⲦⲈⲚ ⲆⲈ ⲚⲐⲰⲦⲈⲚ ⲠⲤⲰⲘⲀ ⲘⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘ ⲚⲈϤⲘⲈⲖⲞⲤ ϦⲈⲚⲞⲨⲘⲈⲢⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ⲚⲎ ⲘⲈⲚ ⲈⲦⲀ ⲪⲚⲞⲨϮ ⲬⲀⲨ ϦⲈⲚⲚⲒⲈⲔⲔⲖⲎ ⲤⲒⲀ ϢⲞⲢⲠ ϨⲀⲚⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲪⲘⲀϨ Ⲃ- ϨⲀⲚⲠⲢⲞⲪⲎⲦⲎⲤ ⲪⲘⲀϨ ⲄϨⲀⲚⲢⲈϤϮⲤⲂⲰ ⲘⲈⲚⲈⲚⲤⲀ ⲚⲀⲒ ϨⲀⲚϪⲞⲘ ⲒⲦⲀ ϨⲀⲚϨⲘⲞⲦ ⲚⲦⲀⲖϬⲞ ϨⲀⲚⲘⲈⲦⲢⲈϤϮⲦⲞⲦⲞⲨ ϨⲀⲚⲘⲈⲦⲢⲈϤⲈⲢϨⲈⲘⲒ ϨⲀⲚⲄⲈⲚⲞⲤ ⲚⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ⲘⲎ ⲤⲈⲚⲀⲈⲢⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲘⲎ ⲤⲈⲚⲀⲈⲢⲠⲢⲞⲪⲎⲦⲎⲤ ⲦⲎⲢⲞⲨ ⲘⲎ ⲤⲈⲚⲀⲈⲢⲢⲈϤϮⲤⲂⲰ ⲦⲎⲢⲞⲨ ⲘⲎ ⲤⲈⲚⲀⲈⲢϪⲞⲘ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ⲘⲎ ⲞⲨⲞⲚ ⲚⲦⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲚϨⲀⲚϨⲘⲞⲦ ⲚⲦⲀⲖϬⲞ ⲘⲎ ⲤⲈⲚⲀⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲘⲎ ⲤⲈⲚⲀⲈⲢⲘⲈⲚⲈⲨⲒⲚ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ⲬⲞϨ ⲆⲈ ⲈⲚⲒϨⲘⲞⲦ ⲈⲐⲚⲀⲀⲨ ⲞⲨⲞϨ ⲈⲦⲒ ⲞⲚ ϮⲚⲀⲦⲀⲘⲰⲦⲈⲚ ⲈⲔⲈⲘⲰⲒⲦ ⲈⲚⲀⲀϤ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲚⲈⲘ ⲪⲀ ⲚⲒⲀⲄⲄⲈⲖⲞⲤ ⲘⲘⲞⲚϮ ⲀⲄⲀⲠⲎ ⲆⲈ ⲘⲘⲀⲨ ⲀⲒⲈⲢ ⲘⲪⲢⲎϮ ⲚⲞⲨϨⲞⲘⲦ ⲈϤⲤⲈⲚⲤⲈⲚ ⲒⲈ ⲞⲨⲔⲨⲘⲂⲀⲖⲞⲚ ⲈϤⲈϢⲖⲎⲖⲞⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ⲔⲀⲚ ⲈⲞⲨⲞⲚ ⲚⲦⲎⲒ ⲚⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲈⲒⲤⲰⲞⲨⲚ ⲚⲚⲒⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲦⲎⲢⲞⲨ ⲚⲈⲘ ⲠⲈⲘⲒ ⲦⲎⲢϤ ⲔⲀⲚ ⲈⲢⲈ ⲪⲚⲀϨϮ ⲦⲎⲢϤ ⲚⲦⲞⲦ ϨⲰⲤⲦⲈ ⲈⲞⲨⲰⲦⲈⲂ ⲚϨⲀⲚⲦⲰⲞⲨ ⲈⲂⲞⲖ ⲘⲘⲞⲚϮ ⲀⲄⲀⲠⲎ ⲆⲈ ⲘⲘⲀⲨ ⲀⲚⲞⲔ ϨⲖⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ⲔⲀⲚ ⲀⲒϢⲀⲚϮ ⲚⲚⲎ ⲈⲦⲈ ⲚⲞⲨⲒ ⲦⲎⲢⲞⲨ ⲈⲐⲢⲞⲨⲞⲨⲞⲘⲞⲨ ⲞⲨⲞϨ ⲚⲦⲀϮ ⲘⲠⲀⲔⲈⲤⲰⲘⲀ ϨⲒⲚⲀ ⲚⲦⲀϢⲞⲨϢⲞⲨ ⲘⲘⲞⲚϮ ⲀⲄⲀⲠⲎ ⲆⲈ ⲘⲘⲀⲨ ⲚϮϪⲈⲘϨⲎⲞⲨ ⲚϨⲖⲒ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ϮⲀⲄⲀⲠⲎ ϢⲀⲤⲰⲞⲨ ⲚϨⲎⲦ ϢⲀⲤⲈⲢϨⲈⲖϪⲈ ϮⲀⲄⲀⲠⲎ ⲘⲠⲀⲤⲬⲞϨ ϮⲀⲄⲀⲠⲎ ⲘⲠⲀⲤⲈⲢⲠⲈⲢⲠⲈⲢⲞⲤ ⲘⲠⲀⲤϬⲒⲤⲒ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ⲘⲠⲀⲤϬⲒϢⲒⲠⲒ ⲘⲠⲀⲤⲔⲰϮ ⲚⲤⲀⲚⲎ ⲈⲦⲈ ⲚⲞⲨⲤ ⲘⲠⲀⲤϪⲰⲚⲦ ⲘⲠⲀⲤⲘⲈⲨⲒ ⲈⲠⲒⲠⲈⲦϨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ⲘⲠⲀⲤⲢⲀϢⲒ ⲈϪⲈⲚ ⲐⲘⲈⲦϬⲒⲚϪⲞⲚⲤ ϢⲀⲤⲢⲀϢⲒ ⲆⲈ ⲈϪⲈⲚ ⲐⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ϢⲀⲤⲰⲞⲨ ⲚϨⲎⲦ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϢⲀⲤⲚⲀϨϮ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϢⲀⲤⲈⲢϨⲈⲖⲠⲒⲤ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ ϢⲀⲤⲀⲘⲞⲚⲒ ⲚⲦⲞⲦⲤ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ϮⲀⲄⲀⲠⲎ ⲘⲠⲀⲤϨⲈⲒ ⲈⲚⲈϨ ⲒⲦⲈ ⲚⲒⲠⲢⲞⲪⲎ ⲦⲒⲀ ⲤⲈⲚⲀⲔⲰⲢϤ ⲒⲦⲈ ⲚⲒⲖⲀⲤ ⲤⲈⲚⲀⲖⲞϪⲞⲨ ⲒⲦⲈ ⲞⲨⲈⲘⲒ ⲠⲈ ϤⲚⲀⲔⲰⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ϦⲈⲚ ⲞⲨⲘⲈⲢⲞⲤ ⲄⲀⲢ ⲦⲈⲚⲈⲘⲒ ⲞⲨⲞϨ ϦⲈⲚⲞⲨⲘⲈⲢⲞⲤ ⲦⲈⲚⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲒ ⲚϪⲈⲠⲒⲦⲈⲖⲒⲞⲚ ⲠⲒⲀⲠⲞⲘⲈⲢⲞⲤ ϤⲚⲀⲔⲰⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ⲈⲒⲞⲒ ⲚⲀⲖⲞⲨ ⲚⲀⲒⲤⲀϪⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲖⲞⲨ ⲚⲀⲒⲤⲞϬⲚⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲖⲞⲨ ⲚⲀⲒⲘⲈⲨⲒ ⲠⲈ ⲘⲪⲢⲎϮ ⲚⲞⲨⲀⲖⲞⲨ ϨⲞⲦⲈ ⲈⲦⲀⲒⲈⲢⲢⲰⲘⲒ ⲀⲒⲔⲰⲢϤ ⲚⲚⲀ ϮⲘⲈⲦⲀⲖⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ⲦⲈⲚⲚⲀⲨ ⲄⲀⲢ ϮⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲒⲀⲖ ϦⲈⲚⲞⲨⲐⲞⲚⲦⲈⲚ ⲦⲞⲦⲈ ⲦⲈⲚⲚⲀⲚⲀⲨ ⲚϨⲞ ⲞⲨⲂⲈ ϨⲞ ⲀⲒⲈⲘⲒ ϮⲚⲞⲨ ϦⲈⲚⲞⲨⲘⲈⲢⲞⲤ ϦⲈⲚⲠⲒⲤⲎⲞⲨ ⲆⲈ ϮⲚⲀⲈⲘⲒ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨⲤⲞⲨⲰⲚⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ϮⲚⲞⲨ ⲆⲈ ⲠⲀⲒⲄ ⲤⲈⲤⲘⲞⲚⲦ ⲪⲚⲀϨϮ ϮϨⲈⲖⲠⲒⲤ ⲦⲀⲄⲀⲠⲎ ⲠⲈⲐⲚⲀⲀϤ ⲆⲈ ϦⲈⲚⲚⲀⲒ ⲠⲈ ϮⲀⲄⲀⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ϬⲞϪⲒ ⲚⲤⲀϮⲀⲄⲀⲠⲎ ⲬⲞϨ ⲆⲈ ⲈⲚⲒⲠⲚⲀⲦⲒⲔⲞⲚ ⲘⲀⲖⲖⲞⲚ ⲆⲈ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲢⲠⲢⲞⲪⲎ ⲦⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ⲠⲈⲦⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲈϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ ⲀⲚ ⲀⲖⲖⲀ ⲪⲚⲞⲨϮ ⲘⲘⲞⲚ ϨⲖⲒ ⲄⲀⲢ ⲤⲰⲦⲈⲘ ⲈⲢⲞϤ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϪⲈ ϤⲤⲀϪⲒ ⲚϨⲀⲚⲘⲨⲤⲦⲎ ⲢⲒⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ⲪⲎ ⲆⲈ ⲈⲦⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲀϤⲤⲀϪⲒ ⲚⲈⲘ ⲚⲒⲢⲰⲘⲒ ⲚⲞⲨⲔⲰⲦ ⲚⲈⲘ ⲞⲨⲚⲞⲘϮ ⲚⲈⲘ ⲞⲨⲐⲰⲦ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ⲠⲈⲦⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲀϤⲔⲰⲦ ⲘⲘⲞϤ ⲘⲘⲀⲨⲀⲦϤ ⲪⲎ ⲆⲈ ⲈⲦⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲀϤⲔⲰⲦ ⲚⲞⲨⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲦⲎⲢⲞⲨ ⲈⲢⲈⲦⲈⲚⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲘⲀⲖⲖⲞⲚ ⲆⲈ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲚⲀⲀ ⲠⲈⲦⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲆⲈ ⲈϨⲞⲦⲈ ⲠⲈⲦⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲤⲀⲂⲞⲖ ⲒⲘⲎⲦⲒ ⲚⲦⲈϤⲈⲢⲘⲈⲚⲈⲨⲒⲚ ϨⲒⲚⲀ ⲚⲦⲈϮⲈⲔⲔⲖⲎⲤⲒⲀ ϬⲒ ⲚⲞⲨⲔⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ϮⲚⲞⲨ ⲆⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲒ ϨⲀⲢⲰⲦⲈⲚ ⲈⲒⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲞⲨ ⲚϨⲎⲞⲨ ⲠⲈϮⲚⲀⲦⲎⲒϤ ⲚⲰⲦⲈⲚ ⲀⲒϢⲦⲈⲘⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ⲒⲈ ϦⲈⲚⲞⲨⲈⲘⲒ ⲒⲈ ϦⲈⲚⲞⲨⲠⲢⲞⲪⲎⲦⲒⲀ ⲒⲈ ϦⲈⲚⲞⲨⲤⲂⲰ. ");
INSERT INTO copbhc_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ⲞⲘⲰⲤ ⲚⲒⲀⲦⲮⲨⲬⲎ ⲈⲨϮ ⲚⲦⲞⲨⲤⲘⲎ ⲒⲦⲈ ⲞⲨⲤⲎⲂⲒ ⲚϪⲰ ⲒⲦⲈ ⲞⲨⲔⲨⲐⲀⲢⲀ ⲀⲨϢⲦⲈⲘϢⲒⲂϮ ⲚⲦⲞⲨⲤⲘⲎ ⲠⲰⲤ ⲤⲈⲚⲀⲈⲘⲒ ⲈⲠⲈⲦⲞⲨϪⲰ ⲘⲘⲞϤ ⲒⲈ ⲪⲎ ⲈⲦⲞⲨⲈⲢⲔⲨⲐⲀⲢⲒⲌⲒⲚ ⲘⲘⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ⲔⲈ ⲄⲀⲢ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲞⲨⲤⲀⲖⲠⲒⲄⲜ ϮⲚⲞⲨⲤⲘⲎ ⲈⲤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲀⲚ ⲚⲒⲘ ⲈⲐⲚⲀϢⲤⲈⲂⲦⲰⲦϤ ⲈⲠⲠⲞⲖⲈⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ⲠⲀⲒⲢⲎϮ ϨⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲖⲀⲤ ⲈϢⲰⲠ ⲀⲢⲈϢⲦⲈⲘϪⲈ ⲞⲨⲤⲀϪⲒ ⲈϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲠⲰⲤ ⲤⲈⲚⲀⲈⲘⲒ ⲈⲠⲈⲦⲈⲚϪⲰ ⲘⲘⲞϤ ⲦⲈⲦⲈⲚⲚⲀϢⲰⲠⲒ ⲄⲀⲢ ⲈⲢⲈⲦⲈⲚⲤⲀϪⲒ ⲈⲠⲀⲎⲢ. ");
INSERT INTO copbhc_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ⲞⲨⲞⲚ ⲞⲨⲘⲎϢ ⲚϢⲖⲰⲖ ⲚⲤⲘⲎ ϦⲈⲚⲠⲀⲒⲔⲞⲤⲘⲞⲤ ⲞⲨⲞϨ ⲘⲘⲞⲚ ϨⲖⲒ ⲈϤⲞⲒ ⲚⲀⲦⲤⲘⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ⲈϢⲰⲠ ⲀⲒϢⲦⲈⲘⲈⲘⲒ ⲈⲦϪⲞⲘ ⲚⲦⲈϮⲤⲘⲎ ϮⲚⲀϢⲰⲠⲒ ⲈⲒⲞⲒ ⲘⲂⲀⲢⲂⲀⲢⲞⲤ ⲚⲦⲞⲦϤ ⲘⲠⲈⲦⲤⲀϪⲒ ⲞⲨⲞϨ ⲠⲈⲦⲤⲀϪⲒ ⲚⲈⲘⲎⲒ ϤⲚⲀϢⲰⲠⲒ ⲈϤⲞⲒ ⲘⲂⲀⲢⲂⲀⲢⲞⲤ ⲚⲦⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ⲠⲀⲒⲢⲎϮ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲈⲠⲒⲆⲎ ⲦⲈⲦⲈⲚⲞⲒ ⲚⲢⲈϤⲬⲞϨ ⲚⲚⲒⲠⲚⲀⲦⲒⲔⲞⲚ ⲈⲠⲔⲰⲦ ⲚⲦⲈϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲔⲰϮ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚⲈⲢϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ⲈⲐⲂⲈⲪⲀⲒ ⲠⲈⲦⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲘⲀⲢⲈϤⲦⲰⲂϨ ϨⲒⲚⲀ ⲚⲦⲈϤⲈⲢⲘⲈⲚⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ⲈϢⲰⲠ ⲄⲀⲢ ⲀⲒϢⲀⲚⲦⲰⲂϨ ϦⲈⲚⲪⲖⲀⲤ ⲠⲀⲠⲚⲈⲨⲘⲀⲠⲈⲦⲦⲰⲂϨ ⲠⲀϨⲎⲦ ⲆⲈ ϤⲞⲒ ⲚⲀⲦⲞⲨⲦⲀϨ. ");
INSERT INTO copbhc_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ⲞⲨ ϪⲈ ⲠⲈϮⲚⲀⲀⲒϤ ϮⲚⲀⲦⲰⲂϨ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϮⲚⲀⲦⲰⲂϨ ⲆⲈ ⲞⲚ ϦⲈⲚⲠⲒⲔⲈϨⲎⲦ ϮⲚⲀⲈⲢⲮⲀⲖⲒⲚ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀϮⲚⲀⲈⲢⲮⲀⲖⲒⲚ ⲆⲈ ⲞⲚ ϦⲈⲚⲠⲒⲔⲈϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ⲒⲈ ⲘⲘⲞⲚ ⲀⲔϢⲀⲚⲤⲘⲞⲨ ϦⲈⲚⲠⲒⲠⲚⲈⲨⲘⲀⲠⲈⲦϪⲰⲔ ⲘⲪⲘⲀ ⲘⲠⲒⲒⲆⲒⲰⲦⲎⲤ ⲈⲂⲞⲖ ⲠⲰⲤ ϤⲚⲀϪⲈ ⲠⲒⲀⲘⲎⲚ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲠⲈⲔϢⲈⲠϨⲘⲞⲦ ⲈⲠⲒⲆⲎ ⲠⲈⲦⲈⲔϪⲰ ⲘⲘⲞϤ ϤⲈⲘⲒ ⲈⲢⲞϤ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ⲚⲐⲞⲔ ⲄⲀⲢ ⲘⲈⲚ ⲔⲀⲖⲰⲤ ⲔϢⲈⲠϨⲘⲞⲦ ⲀⲖⲖⲀ ⲠⲒⲔⲈⲞⲨⲀⲒ ϤⲔⲎⲦ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ϮϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ϪⲈ ϮⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲘⲀⲖⲖⲞⲚ ⲈϨⲞⲦⲈⲢⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ⲀⲖⲖⲀ ϮⲞⲨⲰϢ ⲈϪⲈ ⲈⲚⲤⲀϪⲒ ϦⲈⲚⲠⲀⲔⲀϮ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ϨⲒⲚⲀ ⲚⲦⲀⲈⲢⲔⲀⲦⲎⲬⲒⲚ ⲚϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲈϨⲞⲦⲈ ⲞⲨⲐⲂⲀ ⲚⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ⲚⲀⲤⲚⲎⲞⲨ ⲘⲠⲈⲢⲈⲢⲀⲖⲞⲨ ϦⲈⲚⲚⲈⲦⲈⲚⲔⲀϮ ⲀⲖⲖⲀ ⲀⲢⲒⲀⲖⲞⲨ ϦⲈⲚϮⲔⲀⲔⲒⲀ ⲚϨⲢⲎⲒ ⲆⲈ ϦⲈⲚⲚⲈⲦⲈⲚⲔⲀϮ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚϪⲎ ϪⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ⲤⲤϦⲎⲞⲨⲦ ⲄⲀⲢ ϨⲒ ⲪⲚⲞⲘⲞⲤ ϪⲈ ϦⲈⲚϨⲀⲚⲔⲈⲖⲀⲤ ⲚⲈⲘ ϨⲀⲚⲔⲈⲤⲪⲞⲦⲞⲨ ϮⲚⲀⲤⲀϪⲒ ⲚⲈⲘ ⲠⲀⲒⲖⲀⲞⲤ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲚⲞⲨⲤⲰⲦⲈⲘ ⲚⲤⲰⲒ ⲠⲈϪⲈ ⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ϨⲰⲤⲦⲈ ⲚⲒⲖⲀⲤ ⲚⲀⲨⲬⲎ ⲈⲨⲘⲎⲒⲚⲒ ⲚⲚⲎ ⲈⲐⲚⲀϨϮ ⲀⲚ ⲀⲖⲖⲀ ⲚⲒⲀⲐⲚⲀϨϮ ϮⲠⲢⲞⲪⲎⲦⲒⲀ ⲆⲈ ⲚⲀⲤⲬⲎ ⲚⲚⲒⲀⲐⲚⲀϨϮ ⲀⲚ ⲀⲖⲖⲀ ⲚⲎ ⲈⲐⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ⲈϢⲰⲠ ⲞⲨⲚ ⲀⲤϢⲀⲚⲒ ⲈⲨⲘⲀ ⲚϪⲈϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲤ ⲞⲨⲞϨ ⲚⲤⲈⲤⲀϪⲒ ⲦⲎⲢⲞⲨ ϦⲈⲚϨⲀⲚⲖⲀⲤ ⲚⲤⲈⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲚϪⲈϨⲀⲚⲒⲆⲒⲰⲦⲎⲤ ⲒⲈ ϨⲀⲚⲀⲐⲚⲀϨϮ ⲘⲎ ⲤⲈⲚⲀϪⲞⲤ ⲀⲚ ϪⲈ ⲀⲢⲈ ⲚⲀⲒ ⲖⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ⲈϢⲰⲠ ⲆⲈ ⲈⲨⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲦⲎⲢⲞⲨ ⲚⲦⲈϤⲒ ⲆⲈ ⲈϦⲞⲨⲚ ⲚϪⲈⲞⲨⲀⲐⲚⲀϨϮ ⲒⲈ ⲞⲨⲒⲆⲒⲰⲦⲎⲤ ⲤⲈⲚⲀⲤⲀϨⲰϤ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲤⲈⲚⲀϦⲈⲦϦⲰⲦϤ ⲚϪⲈⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ⲚⲎ ⲈⲦϨⲎⲠ ⲚⲦⲈⲠⲈϤϨⲎⲦ ⲤⲈⲚⲀⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ϤⲚⲀϨⲒⲦϤ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ⲚⲦⲈϤⲞⲨⲰϢⲦ ⲘⲪⲚⲞⲨϮ ⲈϤⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ϪⲈ ⲞⲚⲦⲰⲤ ⲪⲚⲞⲨϮ ϢⲞⲠ ϦⲈⲚⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ⲞⲨ ϪⲈ ⲠⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲈϢⲰⲠ ⲀⲢⲈⲦⲈⲚϢⲀⲚⲐⲰⲞⲨϮ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨⲮⲀⲖⲘⲞⲤ ⲘⲘⲀⲨ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨⲤⲂⲰ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨⲀⲤⲠⲒ ⲚⲖⲀⲤ ⲞⲨⲞⲚⲦⲀϤ ⲚⲞⲨⲈⲢⲘⲎⲚⲒⲀ ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲘⲀⲢⲞⲨϢⲰⲠⲒ ϦⲈⲚⲞⲨⲔⲰⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ⲒⲦⲈ ⲠⲈⲦⲤⲀϪⲒ ϦⲈⲚⲪⲖⲀⲤ ⲔⲀⲦⲀ ⲂⲂ ⲒⲈ ⲠⲒϨⲞⲨⲞ ⲄⲞⲨⲞϨ ⲞⲨⲘⲈⲢⲞⲤ ⲈⲪⲞⲨⲀⲒ ⲞⲨⲞϨ ⲘⲀⲢⲈ ⲞⲨⲀⲒ ⲈⲢⲘⲈⲚⲈⲨⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ⲈϢⲰⲠ ⲆⲈ ⲚⲞⲨⲈⲢⲘⲈⲚⲈⲨⲦⲎⲤ ⲀⲚ ⲠⲈ ⲘⲀⲢⲈϤⲬⲀⲢⲰϤ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲘⲀⲢⲈϤⲤⲀϪⲒ ⲆⲈ ⲞⲨⲦⲰϤ ⲚⲈⲘ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ⲠⲢⲞⲪⲎⲦⲎⲤ ⲆⲈ ⲂⲒⲈ ⲄⲘⲀⲢⲞⲨⲤⲀϪⲒ ⲞⲨⲞϨ ⲚⲒⲔⲈⲬⲰⲞⲨⲚⲒ ⲘⲀⲢⲞⲨⲈⲢⲆⲒⲀⲔⲢⲒⲚⲒⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲞⲨϬⲰⲢⲠ ⲈⲂⲞⲖ ϢⲰⲠⲒ ϦⲈⲚⲔⲈⲞⲨⲀⲒ ⲈϤϨⲈⲘⲤⲒ ⲠⲒϨⲞⲨⲒⲦ ⲘⲀⲢⲈϤⲬⲀⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ⲞⲨⲞⲚ ϢϪⲞⲘ ⲄⲀⲢ ⲘⲘⲰⲦⲈⲚ ⲔⲀⲦⲀ ⲞⲨⲀⲒ ⲞⲨⲀⲒ ⲈⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲦⲎⲢⲞⲨ ϨⲒⲚⲀ ⲚⲤⲈϬⲒⲤⲂⲰ ⲦⲎⲢⲞⲨ ⲞⲨⲞϨ ⲚⲤⲈϪⲈⲘⲚⲞⲘϮ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ⲚⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ ϢⲀⲨϬⲚⲈϪⲰⲞⲨ ⲚⲚⲒⲠⲢⲞⲪⲎⲦⲎⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲪⲀ ⲪⲰⲢϪ ⲀⲚ ⲠⲈ ⲀⲖⲖⲀ ⲪⲀ ⲦϨⲒⲢⲎⲚⲎ ⲠⲈ ⲘⲪⲢⲎϮ ⲈⲦϢⲞⲠ ϦⲈⲚⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲚⲎ ⲈⲐⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ⲚⲒϨⲒⲞⲘⲒ ⲘⲀⲢⲞⲨⲬⲀⲢⲰⲞⲨ ϦⲈⲚϮⲈⲔⲔⲖⲎ ⲤⲒⲀ ⲚⲤⲈⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲰⲞⲨ ⲀⲚ ⲈⲤⲀϪⲒ ⲀⲖⲖⲀ ⲘⲀⲢⲞⲨϬⲚⲈϪⲰⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈ ⲠⲒⲔⲈⲚⲞⲘⲞⲤ ϪⲰ ⲘⲘⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ⲒⲤϪⲈ ⲆⲈ ⲤⲈⲞⲨⲰϢ ⲈⲈⲘⲒ ⲈⲞⲨϨⲰⲂ ⲘⲀⲢⲞⲨϢⲈⲚ ⲚⲞⲨⲢⲰⲘⲒ ϦⲈⲚⲚⲞⲨⲎⲒ ⲞⲨϢⲰϢ ⲄⲀⲢ ⲠⲈ ⲚⲞⲨⲤϨⲒⲘⲒ ⲈⲤⲀϪⲒ ϦⲈⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ϢⲀⲚ ⲈⲦⲀ ⲠⲤⲀϪⲒ ⲘⲪⲚⲞⲨϮ ⲒⲈⲂⲞⲖ ϦⲈⲚⲐⲎⲚⲞⲨ ϢⲀⲚ ⲈⲦⲀϤⲪⲞϨ ⲈⲢⲰⲦⲈⲚ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲈϤⲘⲈⲨⲒ ⲈⲢⲞϤ ϪⲈ ⲞⲨⲠⲢⲞⲪⲎⲦⲎⲤ ⲠⲈ ⲒⲈ ⲞⲨⲠⲚⲀⲦⲒⲔⲞⲤ ⲠⲈ ⲘⲀⲢⲈϤⲈⲘⲒ ⲈⲚⲎ ⲈϮⲤϦⲀⲒ ⲘⲘⲰⲞⲨ ⲚⲰⲦⲈⲚ ϪⲈ ⲞⲨⲈⲚⲦⲞⲖⲎ ⲚⲦⲈⲠϬⲞⲒⲤ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ⲒⲤϪⲈ ⲆⲈ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲈϤⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲤⲈⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲬⲞϨ ⲈⲈⲢⲠⲢⲞⲪⲎⲦⲈⲨⲒⲚ ⲞⲨⲞϨ ⲘⲠⲈⲢⲦⲀϨⲚⲞ ⲈⲤⲀϪⲒ ϦⲈⲚϨⲀⲚⲖⲀⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ϨⲰⲂ ⲆⲈ ⲚⲒⲂⲈⲚ ⲘⲀⲢⲞⲨϢⲰⲠⲒ ⲈⲨⲔⲰⲦ ⲞⲨⲞϨ ⲈⲨⲐⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ϮⲦⲀⲘⲞ ⲆⲈ ⲘⲘⲰⲦⲈⲚ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲪⲎ ⲈⲦⲀⲒϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ ⲈⲦⲈ ⲪⲎ ⲠⲈ ⲈⲦⲀⲢⲈⲦⲈⲚϬⲒⲦϤ ⲪⲀⲒ ⲈⲦⲈⲦⲈⲚⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ⲪⲀⲒ ⲞⲚ ⲈⲦⲈⲦⲈⲚⲚⲀⲚⲞϨⲈⲘ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ϪⲈ ϦⲈⲚⲞⲨⲤⲀϪⲒ ⲀⲒϨⲒϢⲈⲚⲚⲞⲨϤⲒ ⲚⲰⲦⲈⲚ ⲒⲤϪⲈ ⲦⲈⲦⲈⲚⲀⲘⲞⲚⲒ ⲘⲘⲞϤ ⲤⲀⲂⲞⲖ ⲒⲘⲎⲦⲒ ϨⲒⲔⲎ ⲀⲢⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ⲀⲒϮ ⲄⲀⲢ ⲚⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚϢⲞⲢⲠ ⲘⲪⲎ ⲈⲦⲀⲒϬⲒⲦϤ ϪⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀϤⲘⲞⲨ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲚⲈⲚⲚⲞⲂⲒ ⲔⲀⲦⲀ ⲚⲒⲄⲢⲀⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ⲞⲨⲞϨ ϪⲈ ⲀⲨⲔⲞⲤϤ ⲞⲨⲞϨ ϪⲈ ⲀϤⲦⲰⲚϤ ϦⲈⲚⲠⲒⲈϨⲞⲞⲨ ⲘⲘⲀϨⲄ ⲔⲀⲦⲀ ⲚⲒⲄⲢⲀⲪⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ⲞⲨⲞϨ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲔⲎⲪⲀ ⲒⲦⲀ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲠⲒⲒⲂ ");
INSERT INTO copbhc_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ⲘⲈⲚⲈⲚⲤⲰⲤ ⲀϤⲞⲨⲞⲚϨϤ ⲤⲀⲠϢⲰⲒ ⲚⲪ ⲚⲤⲞⲚ ⲈⲨⲤⲞⲠ ⲚⲀⲒ ⲈⲦⲈ ⲠⲞⲨϨⲞⲨⲞ ϢⲞⲠ ϢⲀ ⲈϦⲞⲨⲚ ⲈϮⲚⲞⲨ ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲆⲈ ⲀⲨⲈⲚⲔⲞⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ⲒⲦⲀ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲒⲀⲔⲰⲂⲞⲤ ⲒⲦⲀ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ⲈⲠϦⲀⲈ ⲆⲈ ⲘⲘⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲘⲪⲢⲎϮ ⲘⲠⲒⲞⲨϦⲈ ⲀϤⲞⲨⲞⲚϨϤ ⲈⲢⲞⲒ ϨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ⲀⲚⲞⲔ ⲄⲀⲢ ⲠⲈ ⲠⲒⲔⲞⲨϪⲒ ⲈⲂⲞⲖ ⲞⲨⲦⲈ ⲚⲒⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲦⲎⲢⲞⲨ ⲚϮⲈⲘⲠϢⲀ ⲀⲚ ⲈⲐⲢⲞⲨⲘⲞⲨϮ ⲈⲢⲞⲒ ϪⲈ ⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲈⲐⲂⲈ ϪⲈ ⲀⲒϬⲞϪⲒ ⲚⲤⲀϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ϦⲈⲚ ⲞⲨϨⲘⲞⲦ ⲆⲈ ⲚⲦⲈⲪⲚⲞⲨϮ ϮⲞⲒ ⲘⲠⲈϮⲞⲒ ⲘⲘⲞϤ ⲞⲨⲞϨ ⲠⲈϤϨⲘⲞⲦ ⲈⲦⲈⲚϦⲎⲦ ⲘⲠⲈϤϢⲰⲠⲒ ⲈϤϢⲞⲨⲒⲦ ⲀⲖⲖⲀ ⲀⲒϬⲒϦⲒⲤⲒ ⲈϨⲞⲦⲈⲢⲰⲞⲨ ⲦⲎⲢⲞⲨ ⲀⲚⲞⲔ ⲆⲈ ⲀⲚ ⲀⲖⲖⲀ ⲠⲒϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲐⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ⲒⲦⲈ ⲞⲨⲚ ⲀⲚⲞⲔ ⲒⲦⲈ ⲚⲎ ⲦⲈⲚϨⲒⲰⲒϢ ⲘⲠⲀⲒⲢⲎϮ ⲞⲨⲞϨ ⲠⲀⲒⲢⲎϮ ⲀⲦⲈⲦⲈⲚⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ⲒⲤϪⲈ ⲆⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲤⲈϨⲒⲰⲒϢ ⲘⲘⲞϤ ϪⲈ ⲀϤⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲠⲰⲤ ⲞⲨⲞⲚ ϨⲀⲚⲞⲨⲞⲚ ϪⲰ ⲘⲘⲞⲤ ϦⲈⲚⲐⲎⲚⲞⲨ ϪⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ⲒⲤϪⲈ ⲆⲈ ⲘⲘⲞⲚ ⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀϢⲰⲠⲒ ⲒⲈ ⲞⲨⲆⲈ ⲘⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ⲒⲤϪⲈ ⲆⲈ ⲘⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚϤ ϨⲀⲢⲀ ϤϢⲞⲨⲒⲦ ⲚϪⲈⲠⲈⲚϨⲒⲰⲒϢ ϤϢⲞⲨⲒⲦ ⲞⲚ ⲚϪⲈⲠⲈⲦⲈⲚⲔⲈⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ⲤⲈⲚⲀϪⲈⲘⲈⲚ ⲆⲈ ⲞⲚ ⲈⲚⲞⲒ ⲘⲘⲈⲐⲢⲈ ⲚⲚⲞⲨϪ ϦⲀ ⲪⲚⲞⲨϮ ϪⲈ ⲀⲚⲈⲢⲘⲈⲐⲢⲈ ϦⲀ ⲪⲚⲞⲨϮ ϪⲈ ⲀϤⲦⲞⲨⲚⲞⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲀⲒ ⲈⲦⲈⲘⲠⲈϤⲦⲞⲨⲚⲞⲤϤ ⲒⲤϪⲈ ϨⲀⲢⲀ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ⲒⲤϪⲈ ⲄⲀⲢ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲀⲚ ⲒⲈ ⲘⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚϤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ⲒⲤϪⲈ ⲆⲈ ⲘⲠⲈ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚϤ ⲞⲨⲈⲪⲖⲎ ⲞⲨ ⲠⲈ ⲠⲈⲦⲈⲚⲚⲀϨϮ ⲈⲦⲒ ⲞⲚ ⲦⲈⲦⲈⲚⲬⲎ ⲚϦⲢⲎⲒ ϦⲈⲚⲚⲈⲦⲈⲚⲚⲞⲂⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ⲒⲈ ϨⲀⲢⲀ ⲚⲎ ⲈⲦⲀⲨⲈⲚⲔⲞⲦ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲨⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ⲒⲤϪⲈ ⲆⲈ ⲚϦⲢⲎⲒ ϦⲈⲚⲠⲀⲒⲰⲚϦ ⲘⲘⲀⲨⲀⲦϤ ⲀⲚⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲈ ⲦⲈⲚϬⲒ ⲚⲞⲨⲚⲀⲒ ⲈⲢⲞⲚ ⲈϨⲞⲦⲈ ⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ϮⲚⲞⲨ ⲆⲈ ⲀⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲰⲚϤ ⲈⲂⲞⲖ ϦⲈⲚⲚⲎ ⲈⲐⲘⲰⲞⲨⲦ ⲦⲀⲠⲀⲢⲬⲎ ⲚⲦⲈⲚⲎ ⲈⲦⲀⲨⲈⲚⲔⲞⲦ ");
INSERT INTO copbhc_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ⲈⲠⲒⲆⲎ ⲄⲀⲢ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲢⲰⲘⲒ ⲀⲪⲘⲞⲨ ϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲔⲈⲢⲰⲘⲒ ⲦⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ⲘⲪⲢⲎϮ ⲄⲀⲢ ⲈⲦⲈ ϦⲈⲚⲀⲆⲀⲘ ⲤⲈⲚⲀⲘⲞⲨ ⲦⲎⲢⲞⲨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲤⲈⲚⲀⲰⲚϦ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ϦⲈⲚⲠⲈϤⲦⲀⲄⲘⲀ ⲀⲠⲀⲢⲬⲎ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲦⲀ ⲚⲀ ⲠⲬⲢⲒⲤⲦⲞⲤ ϦⲈⲚⲠⲈϤϪⲒⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ⲒⲦⲀ ⲚⲀ ⲠⲒϪⲰⲔ ϨⲞⲦⲀⲚ ⲀϤϢⲀⲚϮ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲞϨ ⲪⲒⲰⲦ ⲈϢⲰⲠ ⲀϤϢⲀⲚⲔⲰⲢϤ ⲚⲀⲢⲬⲎ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ⲈⲜⲞⲨⲤⲒⲀ ⲚⲒⲂⲈⲚ ⲚⲈⲘ ϪⲞⲘ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ϨⲰϮ ⲄⲀⲢ ⲈⲢⲞϤ ⲚⲦⲈϤⲈⲢⲞⲨⲢⲞ ϢⲀⲦⲈϤⲬⲀ ⲚⲈϤϪⲀϪⲒ ⲦⲎⲢⲞⲨ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ. ");
INSERT INTO copbhc_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ⲠⲒϦⲀⲈ ⲆⲈ ⲚϪⲀϪⲒ ϤⲚⲀⲔⲰⲢϤϤ ⲈⲦⲈ ⲪⲘⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ⲀϤⲈⲐⲢⲈ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϬⲚⲈϪⲰⲞⲨ ⲤⲀⲠⲈⲤⲎⲦ ⲚⲚⲈϤϬⲀⲖⲀⲨϪ ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚϪⲞⲤ ϪⲈ ⲀⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϬⲚⲈϪⲰⲞⲨ ⲚⲀϤ ϤⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϪⲈ ϢⲀⲦⲈⲚ ⲪⲎ ⲈⲦⲀϤⲐⲢⲈ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϬⲚⲈϪⲰⲞⲨ ⲚⲀϤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϬⲚⲈϪⲰⲞⲨ ⲚⲀϤ ⲦⲞⲦⲈ ⲚⲐⲞϤ ϨⲰϤ ⲠⲒϢⲎⲢⲒ ⲈϤⲈϬⲚⲈϪⲰϤ ⲘⲪⲎ ⲈⲦⲀϤⲐⲢⲈ ⲈⲚⲬⲀⲒ ⲚⲒⲂⲈⲚ ϬⲚⲈϪⲰⲞⲨ ⲚⲀϤ ϨⲒⲚⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲚⲐⲞϤ ⲠⲈ ϨⲰⲂ ⲚⲒⲂⲈⲚ ϦⲈⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ⲈⲘⲘⲞⲚ ⲞⲨ ⲠⲈⲦⲞⲨⲚⲀⲀⲒϤ ⲚϪⲈⲚⲎ ⲈⲦϬⲒⲰⲘⲤ ⲈϪⲈⲚ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲒⲤϪⲈ ϨⲞⲖⲰⲤ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲀⲚ ⲒⲈ ⲈⲐⲂⲈⲞⲨ ⲤⲈⲈⲢⲠⲔⲈϬⲒⲰⲘⲤ ⲈϨⲢⲎⲒ ⲈϪⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ⲈⲐⲂⲈ ⲞⲨ ⲀⲚⲞⲚ ϨⲰⲚ ⲦⲈⲚⲈⲢⲔⲨⲚⲆⲒⲚⲈⲨⲒⲚ ⲚⲞⲨⲚⲞⲨ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ϮⲘⲰⲞⲨⲦ ⲘⲘⲎⲚⲒ ϢⲀ ⲠⲈⲦⲈⲚϢⲞⲨϢⲞⲨ ⲚⲀⲤⲚⲎⲞⲨ ⲪⲀⲒ ⲈⲦⲈⲚⲦⲎⲒ ⲘⲘⲀⲨ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲈⲚϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ⲒⲤϪⲈ ϦⲈⲚⲞⲨⲘⲈⲦⲢⲰⲘⲒ ⲀⲒϮ ⲞⲨⲂⲈ ⲠⲒⲐⲎⲢⲒⲞⲚ ϦⲈⲚⲈⲪⲈⲤⲞⲤ ⲞⲨ ⲠⲈ ⲠⲀϨⲎⲞⲨ ⲒⲤϪⲈ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲀⲚ ⲘⲀⲢⲈⲚⲞⲨⲰⲘ ⲞⲨⲞϨ ⲚⲦⲈⲚⲤⲰ ⲢⲀⲤϮ ⲄⲀⲢ ⲦⲈⲚⲚⲀⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ⲘⲠⲈⲢⲤⲰⲢⲈⲘ ϢⲀⲢⲈ ⲚⲒⲤⲀϪⲒ ⲄⲀⲢ ⲈⲦϨⲰⲞⲨ ϢⲀⲨⲦⲀⲔⲈ ⲚⲒϨⲎⲦ ⲈⲐⲚⲀⲚⲈⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲢⲎⲤ ϦⲈⲚⲞⲨⲘⲈⲐⲘⲎⲒ ⲞⲨⲞϨ ⲘⲠⲈⲢⲈⲢⲚⲞⲂⲒ ⲞⲨⲘⲈⲦⲀⲦⲤⲞⲨⲈⲚ ⲪⲚⲞⲨϮ ⲄⲀⲢ ⲈⲦϢⲞⲠ ϦⲈⲚϨⲀⲚⲞⲨⲞⲚ ⲀⲒⲤⲀϪⲒ ⲚⲈⲘⲰⲦⲈⲚ ϦⲈⲚⲞⲨϪⲪⲒⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ⲀⲖⲖⲀ ⲞⲨⲞⲚ ⲞⲨⲀⲒ ⲚⲀϪⲞⲤ ϪⲈ ⲠⲰⲤ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲚⲀⲦⲰⲞⲨⲚⲞⲨ ⲀⲨⲚⲎⲞⲨ ⲆⲈ ϦⲈⲚⲀϢ ⲚⲤⲰⲘⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ⲠⲒⲀⲦϨⲎⲦ ⲠⲈⲦⲈⲔⲤⲒϮ ⲘⲘⲞϤ ⲚⲐⲞⲔ ⲘⲠⲀϤⲰⲚϦ ⲀϤϢⲦⲈⲘⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ⲞⲨⲞϨ ⲠⲈⲦⲈⲔⲤⲒϮ ⲘⲘⲞϤ ⲠⲒⲤⲰⲘⲀ ⲈⲐⲚⲀϢⲰⲠⲒ ⲚⲐⲞϤ ⲀⲚ ⲠⲈⲦⲈⲔⲤⲒϮ ⲘⲘⲞϤ ⲀⲖⲖⲀ ⲞⲨⲚⲀⲪⲢⲒ ⲦⲈ ⲈⲤⲂⲎϢ ⲒⲦⲈ ⲞⲨⲤⲞⲨⲞ ⲒⲦⲈ ⲔⲈⲞⲨⲀⲒ ⲘⲠⲤⲈⲠⲒ ⲚⲚⲒϪⲰⲢϪ. ");
INSERT INTO copbhc_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ⲪⲚⲞⲨϮ ⲆⲈ ϢⲀϤϮ ⲤⲰⲘⲀ ⲚⲀϤ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀϤⲞⲨⲰϢ ⲞⲨⲞϨ ⲪⲞⲨⲀⲒ ⲪⲞⲨⲀⲒ ⲚⲚⲒϪⲰⲢϪ ϤϮ ⲘⲠⲞⲨⲤⲰⲘⲀ ⲚⲰⲞⲨ ⲘⲘⲒⲚ ⲘⲘⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ⲤⲀⲢⲜ ⲚⲒⲂⲈⲚ ⲦⲀⲒⲤⲀⲢⲜ ⲦⲀⲒⲤⲀⲢⲜ ⲀⲚ ⲦⲈ ⲀⲖⲖⲀ ⲞⲨⲈⲦ ⲤⲀⲢⲜ ⲘⲈⲚ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲞⲨⲈⲦ ⲤⲀⲢⲜ ⲚⲦⲈⲚⲒⲦⲈⲂⲚⲰⲞⲨⲒ ⲞⲨⲈⲦ ⲤⲀⲢⲜ ⲚⲦⲈⲚⲒϨⲀⲖⲀϮ ⲞⲨⲈⲦ ⲐⲀ ⲚⲒⲦⲈⲂⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ⲞⲨⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲞⲚ ⲚⲦⲈⲦⲪⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲚⲦⲈⲠⲔⲀϨⲒ ⲀⲖⲖⲀ ⲞⲨⲈⲦ ⲠⲰⲞⲨ ⲘⲈⲚ ⲚⲦⲈⲚⲀ ⲦⲪⲈ ⲞⲨⲈⲦ ⲠⲰⲞⲨ ⲆⲈ ⲚⲦⲈⲚⲀ ⲠⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ⲞⲨⲈⲦ ⲠⲰⲞⲨ ⲘⲪⲢⲎ ⲞⲨⲈⲦ ⲠⲰⲞⲨ ⲘⲠⲒⲒⲞϨ ⲞⲨⲈⲦ ⲠⲰⲞⲨ ⲚⲚⲒⲤⲒⲞⲨ ⲞⲨⲞⲚ ⲞⲨⲤⲒⲞⲨ ⲄⲀⲢ ⲈϤⲞⲨⲞⲦ ⲈⲤⲒⲞⲨ ϦⲈⲚⲠⲈϤⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲠⲈ ϮⲔⲈⲀⲚⲀⲤⲦⲀⲤⲒⲤ ⲚⲦⲈⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲤⲈⲤⲒϮ ⲘⲘⲞⲤ ϦⲈⲚⲞⲨⲦⲀⲔⲞ ⲤⲚⲀⲦⲰⲚⲤ ϦⲈⲚⲞⲨⲘⲈⲦⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ⲤⲈⲤⲒϮ ⲘⲘⲞⲤ ϦⲈⲚⲞⲨϢⲰϢ ⲤⲚⲀⲦⲰⲚⲤ ϦⲈⲚⲞⲨⲰⲞⲨ ⲤⲈⲤⲒϮ ⲘⲘⲞⲤ ϦⲈⲚⲞⲨϪⲰⲂ ⲤⲚⲀⲦⲰⲚⲤ ϦⲈⲚⲞⲨϪⲞⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ⲤⲈⲤⲒϮ ⲚⲞⲨⲤⲰⲘⲀ ⲘⲮⲨⲬⲒⲔⲞⲚ ϤⲚⲀⲦⲰⲚϤ ⲚϪⲈⲞⲨⲤⲰⲘⲀ ⲘⲠⲚⲀⲦⲒⲔⲞⲚ ⲒⲤϪⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲘⲮⲨⲬⲒⲔⲞⲚ ⲒⲈ ⲞⲨⲞⲚ ⲞⲨⲤⲰⲘⲀ ⲞⲚ ⲘⲠⲚⲀⲦⲒⲔⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ⲀⲤⲤϦⲎⲞⲨⲦ ⲢⲰ ⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ϪⲈ ⲀϤϢⲰⲠⲒ ⲚϪⲈⲀⲆⲀⲘ ⲠⲒⲢⲰⲘⲒ ⲚϨⲞⲨⲒⲦ ⲈⲨⲮⲨⲬⲎ ⲈⲤⲰⲚϦ ⲠⲒϦⲀⲈ ⲆⲈ ⲀⲆⲀⲘ ⲞⲨⲠⲚⲈⲨⲘⲀⲈϤⲦⲀⲚϦⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ⲀⲖⲖⲀ ⲠⲒⲠⲚⲀⲦⲒⲔⲞⲚ ⲀⲚ ⲠⲈ ⲠⲒϢⲞⲢⲠ ⲀⲖⲖⲀ ⲠⲒⲮⲨⲬⲒⲔⲞⲚ ⲘⲈⲚⲈⲚⲤⲰϤ ⲠⲒⲠⲚⲀⲦⲒⲔⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ⲠⲒⲢⲰⲘⲒ ⲚϨⲞⲨⲒⲦ ⲈⲂⲞⲖ ϦⲈⲚⲠⲔⲀϨⲒ ⲠⲈ ⲚⲢⲈⲘⲚⲔⲀϨⲒ ⲠⲒⲘⲀϨⲂ ⲚⲢⲰⲘⲒ ⲈⲂⲞⲖ ϦⲈⲚⲦⲪⲈ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ⲘⲪⲢⲎϮ ⲘⲠⲒⲢⲈⲘⲚⲔⲀϨⲒ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲒⲔⲈⲢⲈⲘⲚⲔⲀϨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲘⲠⲒⲢⲈⲘⲘⲪⲈ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲚⲒⲔⲈⲢⲈⲘⲘⲪⲈ ⲞⲨⲞϨ ⲘⲪⲢⲎϮ ⲈⲦⲀⲚⲈⲢⲪⲞⲢⲒⲚ ⲚⲦϨⲒⲔⲰⲚ ⲘⲠⲒⲢⲈⲘⲚⲔⲀϨⲒ ⲘⲀⲢⲈⲚⲈⲢⲪⲞⲢⲒⲚ ⲚϮϨⲒⲔⲰⲚ ⲚⲦⲈⲠⲒⲢⲈⲘⲘⲪⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ⲪⲀⲒ ⲆⲈ ϮϪⲰ ⲘⲘⲞϤ ⲚⲀⲤⲚⲎⲞⲨ ϪⲈ ⲤⲀⲢⲜ ϨⲒ ⲤⲚⲞϤ ⲤⲈⲚⲀⲈⲢⲔⲖⲎⲢⲞⲚⲞⲘⲒⲚ ⲀⲚ ⲚϮⲘⲈⲦⲞⲨⲢⲞ ⲚⲦⲈⲪⲚⲞⲨϮ ⲞⲨⲆⲈ ⲠⲦⲀⲔⲞ ϤⲚⲀⲈⲢⲔⲖⲎ ⲢⲞⲚⲞⲘⲒⲚ ⲀⲚ ⲚϮⲘⲈⲦⲀⲦⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ϨⲎⲠⲠⲈ ⲞⲨⲘⲨⲤⲦⲎⲢⲒⲞⲚ ⲠⲈϮϪⲰ ⲘⲘⲞϤ ⲚⲰⲦⲈⲚ ⲦⲈⲚⲚⲀⲈⲚⲔⲞⲦ ⲘⲈⲚ ⲦⲎⲢⲞⲨ ⲀⲚ ⲤⲈⲚⲀϢⲞⲂⲦⲈⲚ ⲆⲈ ⲦⲎⲢⲞⲨ ");
INSERT INTO copbhc_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ϦⲈⲚ ⲞⲨⲤⲞⲨⲤⲞⲨ ϦⲈⲚⲞⲨⲢⲒⲔⲒ ⲘⲂⲀⲖ ϦⲈⲚϮϦⲀⲈ ⲚⲤⲀⲖⲠⲒⲄⲄⲞⲤ ⲈⲤⲈⲘⲞⲨϮ ⲄⲀⲢ ⲚϪⲈϮⲤⲀⲖⲠⲒⲄⲜ ⲞⲨⲞϨ ⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ⲈⲨⲈⲦⲰⲞⲨⲚⲞⲨ ⲈⲨⲞⲒ ⲚⲀⲦⲀⲔⲞ ⲞⲨⲞϨ ⲀⲚⲞⲚ ϨⲰⲚ ⲤⲈⲚⲀϢⲞⲂⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ϨⲰϮ ⲄⲀⲢ ⲚⲦⲈⲪⲀⲒ ⲈⲐⲚⲀⲦⲀⲔⲞ ⲚⲦⲈϤϮϨⲒⲰⲦϤ ⲚϮⲘⲈⲦⲀⲦⲦⲀⲔⲞ ⲞⲨⲞϨ ⲪⲀⲒ ⲈⲐⲚⲀⲘⲞⲨ ⲚⲦⲈϤϮϨⲒⲰⲦϤ ⲚϮⲘⲈⲦⲀⲦⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ϨⲞⲦⲀⲚ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲪⲀⲒ ⲈⲐⲚⲀⲘⲞⲨ ϮϨⲒⲰⲦϤ ⲚϮⲘⲈⲦⲀⲐⲘⲞⲨ ⲦⲞⲦⲈ ⲈϤⲈϢⲰⲠⲒ ⲚϪⲈⲠⲒⲤⲀϪⲒ ⲈⲦⲤϦⲎⲞⲨⲦ ϪⲈ ⲀⲨⲰⲘⲔ ⲘⲪⲘⲞⲨ ⲈⲨϬⲢⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ⲀϤⲐⲰⲚ ⲠⲈⲔϬⲢⲞ ⲪⲘⲞⲨ ⲀⲤⲐⲰⲚ ⲦⲈⲔⲤⲞⲨⲢⲒ ⲪⲘⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ⲦⲤⲞⲨⲢⲒ ⲄⲀⲢ ⲘⲪⲘⲞⲨ ⲪⲚⲞⲂⲒ ⲠⲈ ⲦϪⲞⲘ ⲆⲈ ⲘⲪⲚⲞⲂⲒ ⲪⲚⲞⲘⲞⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ⲠϨⲘⲞⲦ ⲆⲈ ⲘⲪⲚⲞⲨϮ ϢⲎⲠ ⲪⲀⲒ ⲈⲦϮ ⲘⲠⲒϬⲢⲞ ⲚⲀⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ϨⲰⲤⲦⲈ ⲚⲀⲤⲚⲎⲞⲨ ⲘⲘⲈⲚⲢⲀϮ ϢⲰⲠⲒ ⲈⲢⲈⲦⲈⲚⲦⲀϪⲢⲎⲞⲨⲦ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲔⲒⲘ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚϨⲞⲨⲞ ϦⲈⲚⲠⲒϨⲰⲂ ⲚⲦⲈⲠϬⲞⲒⲤ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ⲈⲢⲈⲦⲈⲚⲈⲘⲒ ϪⲈ ⲠⲈⲦⲈⲚϦⲒⲤⲒ ϤϢⲞⲨⲒⲦ ⲀⲚ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ⲈⲐⲂⲈ ⲠⲒⲤⲰⲢ ⲆⲈ ⲈⲦⲀϤϢⲰⲠⲒ ⲈⲐⲂⲈ ⲚⲒⲀⲄⲒⲞⲤ ⲘⲪⲢⲎϮ ⲈⲦⲀⲒⲞⲨⲀϨⲤⲀϨⲚⲒ ⲚⲚⲒⲈⲔⲔⲖⲎ ⲤⲒⲀ ⲚⲦⲈⲦⲄⲀⲖⲀⲦⲒⲀ ⲀⲢⲒⲞⲨⲒ ϨⲰⲦⲈⲚ ⲘⲠⲀⲒⲢⲎϮ ");
INSERT INTO copbhc_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ⲔⲀⲦⲀ ⲪⲞⲨⲀⲒ ⲚⲚⲒⲤⲀⲂⲂⲀⲦⲞⲚ ⲘⲀⲢⲈ ⲠⲒⲞⲨⲀⲒ ⲠⲒⲞⲨⲀⲒ ⲘⲘⲰⲦⲈⲚ ⲬⲰ ⲚⲦⲞⲦϤ ⲈϤϨⲒⲞⲨⲒ ⲈϦⲞⲨⲚ ⲘⲪⲎ ⲈⲦⲈ ⲠⲈϤⲘⲰⲒⲦ ⲚⲀⲤⲰⲞⲨⲦⲈⲚ ⲚϦⲎⲦϤ ϨⲒⲚⲀ ⲘⲎⲠⲰⲤ ⲀⲒϢⲀⲚⲒ ⲦⲞⲦⲈ ⲚⲦⲈϨⲀⲚⲰⲠ ϢⲰⲠⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ⲈϢⲰⲠ ⲆⲈ ⲀⲒϢⲀⲚⲒ ⲚⲎ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢⲆⲞⲔⲒⲘⲀⲌⲒⲚ ⲘⲘⲰⲞⲨ ⲚⲀⲒ ⲈⲒⲈⲞⲨⲞⲢⲠⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϨⲀⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲈϬⲒ ⲘⲠⲈⲦⲈⲚϨⲘⲞⲦ ⲈⲒⲈⲢⲞⲤⲀⲖⲎⲘ. ");
INSERT INTO copbhc_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ⲈϢⲰⲠ ⲆⲈ ⲈⲠⲒϨⲰⲂ ⲘⲠϢⲀ ⲈⲐⲢⲒϢⲈ ϨⲰ ⲈⲨⲈⲘⲞϢⲒ ⲚⲈⲘⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ⲈⲒⲈⲒ ⲆⲈ ϨⲀⲢⲰⲦⲈⲚ ⲈϢⲰⲠ ⲀⲒϢⲀⲚⲤⲈⲚ ⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲄⲀⲢ ϮⲚⲀⲤⲈⲚⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ⲦⲀⲬⲀ ⲆⲈ ⲚⲦⲀⲞϨⲒ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲒⲈ ⲚⲦⲀⲈⲢϮⲪⲢⲰ ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚⲦⲪⲞⲒ ⲈⲠⲒⲘⲀ ⲈϮⲚⲀϢⲈ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ϮⲞⲨⲰϢ ⲄⲀⲢ ⲈⲚⲀⲨ ⲈⲢⲰⲦⲈⲚ ϮⲚⲞⲨ ⲈⲒⲬⲎ ϨⲒ ⲪⲘⲰⲒⲦ ϮⲈⲢϨⲈⲖⲠⲒⲤ ⲄⲀⲢ ⲈⲈⲢⲬⲢⲞⲚⲞⲤ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲈϢⲰⲠ ⲀⲢⲈϢⲀⲚ ⲠϬⲞⲒⲤ ⲞⲨⲀϨⲤⲀϨⲚⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ϮⲚⲀϢⲰⲠⲒ ϦⲈⲚⲈⲪⲈⲤⲞⲤ ϢⲀ ϮⲠⲈⲚⲦⲎ ⲔⲞⲤⲦⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ⲀϤⲞⲨⲰⲚ ⲄⲀⲢ ⲚⲎⲒ ⲚϪⲈⲞⲨⲚⲒϢϮ ⲚⲢⲞ ⲈϤⲈⲢϨⲰⲂ ⲚⲈⲘ ⲞⲨⲘⲎϢ ⲚⲀⲚⲦⲒⲔⲒⲘⲈⲚⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ⲈϢⲰⲠ ⲆⲈ ⲀⲢⲈϢⲀⲚ ⲦⲒⲘⲞⲐⲈⲞⲤ Ⲓ- ⲀⲚⲀⲨ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ϨⲀⲢⲰⲦⲈⲚ ⲀⲦϬⲚⲈ ϨⲞϮ ⲠⲒϨⲰⲂ ⲄⲀⲢ ⲚⲦⲈⲠϬⲞⲒⲤ ⲠⲈⲦⲈϤⲈⲢϨⲰⲂ ⲈⲢⲞϤ ⲘⲠⲀⲢⲎϮ ϨⲰ. ");
INSERT INTO copbhc_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ⲘⲠⲈⲚⲐⲢⲈ ϨⲖⲒ ⲞⲨⲚ ϢⲞϢϤ ⲘⲀϮⲪⲞϤ ⲆⲈ ϦⲈⲚⲞⲨϨⲒⲢⲎⲚⲎ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ϨⲀⲢⲞⲒ ϮⲤⲞⲘⲤ ⲄⲀⲢ ⲈⲂⲞⲖ ϦⲀϪⲰϤ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ⲈⲐⲂⲈ ⲀⲠⲞⲖⲖⲰ ⲆⲈ ⲠⲒⲤⲞⲚ ⲀⲒϮϨⲞ ⲈⲢⲞϤ ⲈⲘⲀϢⲰ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ϨⲀⲢⲰⲦⲈⲚ ⲚⲈⲘ ⲚⲒⲤⲚⲎⲞⲨ ⲞⲨⲞϨ ⲠⲀⲚⲦⲰⲤ ⲠⲈ ⲪⲞⲨⲰϢ ⲀⲚ ⲠⲈ ϨⲒⲚⲀ ⲚⲦⲈϤⲒ ϮⲚⲞⲨ ⲈϤⲈⲒ ⲆⲈ ϨⲀⲢⲰⲦⲈⲚ ⲀϤϢⲀⲚϪⲈⲘ ⲦⲈⲨⲔⲈⲢⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ⲢⲰⲒⲤ ⲞⲨⲚ ⲞⲨⲞϨ ⲞϨⲒ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ϦⲈⲚⲪⲚⲀϨϮ ϬⲢⲞ ⲘⲘⲰⲦⲈⲚ ⲞⲨⲞϨ ϪⲈⲘⲚⲞⲘϮ. ");
INSERT INTO copbhc_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ϨⲰⲂ ⲚⲒⲂⲈⲚ ⲈⲦⲈⲚⲦⲰⲦⲈⲚ ⲘⲀⲢⲞⲨϢⲰⲠⲒ ϦⲈⲚⲞⲨⲀⲄⲀⲠⲎ. ");
INSERT INTO copbhc_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ϮϮϨⲞ ⲞⲨⲚ ⲈⲢⲰⲦⲈⲚ ⲚⲈⲚⲤⲚⲎⲞⲨ ⲦⲈⲦⲈⲚⲤⲰⲞⲨⲚ ⲘⲠⲎⲒ ⲚⲤⲦⲈⲪⲀⲚⲀ ⲚⲈⲘ ⲪⲞⲢⲦⲞⲨⲚⲀⲦⲞⲤ ϪⲈ ⲦⲀⲢⲬⲎ ⲚⲦⲈϮⲀⲬⲀⲒⲀ ⲦⲈ ⲞⲨⲞϨ ⲀⲨⲐⲀϢⲞⲨ ⲈⲨⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲚⲒⲀⲄⲒⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ϨⲒⲚⲀ ⲚⲐⲰⲦⲈⲚ ϨⲰⲦⲈⲚ ⲚⲦⲈⲦⲈⲚϬⲚⲈϪⲰⲦⲈⲚ ⲚⲚⲀⲒⲞⲨⲞⲚ ⲘⲠⲀⲒⲢⲎϮ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲞⲒ ⲚϢⲪⲎⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ⲞⲨⲞϨ ⲈⲦϦⲞⲤⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ϮⲢⲀϢⲒ ⲆⲈ ⲈϪⲈⲚ ⲦⲠⲀⲢⲞⲨⲤⲒⲀ ⲚⲤⲦⲈⲪⲀⲚⲀ ⲚⲈⲘ ⲪⲞⲢⲦⲞⲨⲚⲀⲦⲞⲤ ⲚⲈⲘ ⲀⲬⲀⲒⲔⲞⲤ ϪⲈ ⲠⲈⲦⲈⲚϬⲢⲞϨ ⲚⲀⲒ ⲀⲨϪⲈⲔⲢⲰϤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ⲀⲨϮⲘⲦⲞⲚ ⲄⲀⲢ ⲘⲠⲀⲠⲚⲈⲨⲘⲀⲚⲈⲘ ⲪⲰⲦⲈⲚ ⲤⲞⲨⲈⲚ ⲚⲀⲒⲞⲨⲞⲚ ⲞⲨⲚ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ⲤⲈϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈϮⲀⲤⲒⲀ ⲤⲈϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲈⲘⲀϢⲰ ϦⲈⲚⲠϬⲞⲒⲤ ⲚϪⲈⲀⲔⲨⲖⲀ ⲚⲈⲘ ⲠⲢⲒⲤⲔⲀ ⲚⲈⲘ ϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲠⲞⲨⲎⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ⲤⲈϢⲒⲚⲒ ⲈⲢⲰⲦⲈⲚ ⲚϪⲈⲚⲒⲤⲚⲎⲞⲨ ⲦⲎⲢⲞⲨ ⲈⲐⲚⲈⲘⲎⲒ ⲀⲢⲒⲀⲤⲠⲀⲌⲈⲤⲐⲈ ⲚⲚⲈⲦⲈⲚⲈⲢⲎ ⲞⲨ ϦⲈⲚⲞⲨⲪⲒ ⲈⲤⲞⲨⲀⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ⲠⲀⲀⲤⲠⲀⲤⲘⲞⲤ ϦⲈⲚⲦⲀϪⲒϪ ⲀⲚⲞⲔ ⲠⲀⲨⲖⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ⲪⲎ ⲈⲦⲈⲚϤⲘⲈⲒ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲀⲚ ⲘⲀⲢⲈϤϢⲰⲠⲒ ⲚⲞⲨⲀⲚⲀⲐⲈⲘⲀ ⲘⲀⲢⲀⲚⲀⲐⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ⲠϨⲘⲞⲦ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲚⲈⲘⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ⲦⲀⲀⲄⲀⲠⲎ ⲚⲈⲘⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲀⲘⲎⲚ ");
INSERT INTO copbhc_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ⲠⲀⲨⲖⲞⲤ ⲠⲀⲠⲞⲤⲦⲞⲖⲞⲤ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲞⲨⲰϢ ⲘⲪⲚⲞⲨϮ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲠⲒⲤⲞⲚ ⲚϮⲈⲔⲔⲖⲎⲤⲒⲀ ⲚⲦⲈⲪⲚⲞⲨϮ ⲐⲎ ⲈⲦϢⲞⲠ ϦⲈⲚⲔⲞⲢⲒⲚⲐⲞⲤ ⲚⲈⲘ ⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲐⲞⲨⲀⲂ ⲈⲦϢⲞⲠ ϦⲈⲚϮⲀⲬⲀⲒⲀ ⲦⲎⲢⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ⲠϨⲘⲞⲦ ⲚⲰⲦⲈⲚ ⲚⲈⲘ ⲦϨⲒⲢⲎⲚⲎ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲪⲚⲞⲨϮ ⲠⲈⲚⲒⲰⲦ ⲚⲈⲘ ⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ϤⲈⲚϨⲞⲦ ⲚϪⲈⲪⲚⲞⲨϮ ⲪⲒⲰⲦ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲪⲒⲰⲦ ⲚⲦⲈⲚⲒⲘⲈⲦϢⲈⲚϨⲎⲦ ⲞⲨⲞϨ ⲪⲚⲞⲨϮ ⲚⲦⲈⲚⲞⲘϮ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ⲪⲀⲒ ⲈⲦⲀϤϮⲚⲞⲘϮ ⲚⲀⲚ ϦⲈⲚⲠⲈⲚϨⲞϪϨⲈϪ ⲦⲎⲢϤ ⲈⲐⲢⲈⲚϪⲈⲘϪⲞⲘ ϨⲰⲚ ⲈϮⲚⲞⲘϮ ⲚⲞⲨⲞⲚ ⲚⲒⲂⲈⲚ ⲈⲦⲬⲎ ϦⲈⲚϨⲞϪϨⲈϪ ⲚⲒⲂⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ϮⲚⲞⲘϮ ⲐⲎ ⲈⲦⲀ ⲪⲚⲞⲨϮ ϮⲚⲞⲘϮ ⲚⲀⲚ ⲚϦⲎⲦⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ϪⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈ ⲚⲒⲘⲔⲀⲨϨ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲒ ⲚϨⲞⲨⲞ ⲈϦⲞⲨⲚ ⲈⲢⲞⲚ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲤⲞⲒ ⲚϨⲞⲨⲞ ⲚϪⲈⲦⲈⲚⲔⲈⲚⲞⲘϮ. ");
INSERT INTO copbhc_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ⲒⲦⲈ ⲆⲈ ⲤⲈϨⲞϪϨⲈϪ ⲘⲘⲞⲚ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲦⲈⲦⲈⲚⲚⲞⲘϮ ⲚⲈⲘ ⲠⲈⲦⲈⲚⲞⲨϪⲀⲒ ⲒⲦⲈ ⲤⲈⲐⲰⲦ ⲘⲠⲈⲚϨⲎⲦ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲦⲈⲦⲈⲚⲚⲞⲘϮ ⲐⲎ ⲈⲦⲈⲢϨⲰⲂ ϦⲈⲚⲞⲨⲀⲘⲞⲚⲒ ⲚⲦⲞⲦϤ ⲚⲦⲈⲚⲀⲒⲘⲔⲀⲨϨ ⲚⲞⲨⲰⲦ ⲚⲀⲒ ⲈⲦⲈⲚⲘⲞⲔϨ ⲚϦⲎⲦⲞⲨ ϨⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ⲞⲨⲞϨ ⲦⲈⲚϨⲈⲖⲠⲒⲤ ⲦⲀϪⲢⲎⲞⲨⲦ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲈⲚⲈⲘⲒ ϪⲈ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲈⲦⲈⲚⲞⲒ ⲚϢⲪⲎⲢ ⲈⲚⲒⲘⲔⲀⲨϨ ⲠⲀⲒⲢⲎϮ ⲞⲚ ⲈϮⲔⲈⲚⲞⲘϮ. ");
INSERT INTO copbhc_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ⲚϮⲞⲨⲈϢ ⲐⲎⲚⲞⲨ ⲆⲈ ⲀⲚ ⲈⲢⲈⲦⲈⲚⲞⲒ ⲚⲀⲦⲈⲘⲒ ⲚⲀⲤⲚⲎⲞⲨ ⲈⲐⲂⲈ ⲠⲒϨⲞϪϨⲈϪ ⲈⲦⲀϤϢⲰⲠⲒ ⲘⲘⲞⲚ ϦⲈⲚϮⲀⲤⲒⲀ ϪⲈ ϦⲈⲚⲞⲨⲘⲈⲦϨⲞⲨⲞ ⲀⲨϨⲢⲞϢ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ⲚϨⲞⲨⲞ ⲈⲦⲈⲚϪⲞⲘ ϨⲰⲤⲦⲈ ⲚⲦⲈⲚϢⲦⲈⲘϪⲈⲘϨⲎⲞⲨ ⲘⲠⲒⲔⲈⲰⲚϦ. ");
INSERT INTO copbhc_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ⲀⲖⲖⲀ ⲚϦⲢⲎⲒ ⲚϦⲎⲦⲈⲚ ⲀⲚϬⲒ ⲘⲠⲒⲈⲢⲞⲨⲰ ⲚⲦⲈⲪⲘⲞⲨ ϨⲒⲚⲀ ⲚⲦⲈⲚϢⲦⲈⲘϢⲰⲠⲒ ⲈⲢⲈϨⲐⲎⲚ ⲬⲎ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲀⲖⲖⲀ ⲈⲪⲚⲞⲨϮ ⲪⲎ ⲈⲦⲦⲞⲨⲚⲞⲤ ⲚⲚⲒⲢⲈϤⲘⲰⲞⲨⲦ ");
INSERT INTO copbhc_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ⲪⲀⲒ ⲈⲦⲀϤⲚⲀϨⲘⲈⲚ ⲈⲂⲞⲖ ϦⲈⲚⲠⲀⲒⲘⲞⲨ ⲚⲦⲀⲒⲘⲀⲒⲎ ⲞⲨⲞϨ ϤⲚⲀⲚⲀϨⲘⲈⲚ ⲪⲎ ⲈⲦⲀⲚⲈⲢϨⲈⲖⲠⲒⲤ ⲈⲢⲞϤ ϪⲈ ⲈⲦⲒ ⲞⲚ ϤⲚⲀⲚⲀϨⲘⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ⲈⲢⲈⲦⲈⲚⲞⲒ ϨⲰⲦⲈⲚ ⲚϢⲪⲎⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ϦⲈⲚⲠⲒⲦⲰⲂϨ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ ϨⲒⲚⲀ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲚϨⲞ ⲠⲒϨⲘⲞⲦ ⲈⲦϨⲀⲢⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲚⲤⲈϢⲈⲠϨⲘⲞⲦ ⲚⲦⲈⲚ ⲪⲚⲞⲨϮ ⲈϨⲢⲎⲒ ⲈϪⲰⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ⲠⲈⲚϢⲞⲨϢⲞⲨ ⲄⲀⲢ ⲪⲀⲒ ⲠⲈ ϮⲘⲈⲦⲘⲈⲐⲢⲈ ⲚⲦⲈⲦⲈⲚⲤⲨⲚⲎⲆⲈⲤⲒⲤ ϪⲈ ⲚϨⲢⲎⲒ ϦⲈⲚⲞⲨⲦⲞⲨⲂⲞ ⲚⲈⲘ ⲞⲨⲘⲈⲐⲘⲎⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ϦⲈⲚⲞⲨⲤⲂⲰ ⲚⲤⲀⲢⲔⲒⲔⲎ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨϨⲘⲞⲦ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲚⲘⲞϢⲒ ϦⲈⲚⲠⲒⲔⲞⲤⲘⲞⲤ ⲚϨⲞⲨⲞ ⲆⲈ ϦⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ϨⲀⲚⲔⲈⲬⲰⲞⲨⲚⲒ ⲄⲀⲢ ⲀⲚ ⲈⲦⲀⲚⲤϦⲀⲒ ⲘⲘⲰⲞⲨ ⲚⲰⲦⲈⲚ ⲈⲂⲎⲖ ⲈⲚⲎ ⲈⲦⲈⲦⲈⲚⲰϢ ⲘⲘⲰⲞⲨ ⲞⲨⲞϨ ⲦⲈⲦⲈⲚⲈⲢⲠⲔⲈⲤⲰⲞⲨⲚ ⲘⲘⲰⲞⲨ ϮⲈⲢϨⲈⲖⲠⲒⲤ ϪⲈ ⲦⲈⲦⲈⲚⲚⲀⲈⲘⲒ ϢⲀ ϦⲀⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲢⲈⲦⲈⲚⲤⲞⲨⲰⲚⲈⲚ ϦⲈⲚⲞⲨⲀⲠⲞⲘⲈⲢⲞⲤ ϪⲈ ⲀⲚⲞⲚ ⲠⲈ ⲠⲈⲦⲈⲚϢⲞⲨϢⲞⲨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ϨⲰⲦⲈⲚ ⲈⲦⲈ ⲚⲐⲰⲦⲈⲚ ⲪⲰⲚ ϦⲈⲚⲠⲈϨⲞⲞⲨ ⲘⲠⲈⲚϬⲞⲒⲤ ⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ⲞⲨⲞϨ ϦⲈⲚⲠⲀⲒⲐⲰⲦ ⲚϨⲎⲦ ⲀⲒⲞⲨⲰϢ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ ⲚϢⲞⲢⲠ ϨⲒⲚⲀ ⲚⲦⲈⲦⲈⲚϬⲒ ⲘⲠⲒⲢⲀϢⲒ ⲘⲘⲀϨⲂ. ");
INSERT INTO copbhc_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ⲞⲨⲞϨ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ ⲚⲦⲀϢⲈ ⲚⲎⲒ ⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲞⲨⲞϨ ⲠⲀⲖⲒⲚ ⲞⲚ ⲈⲂⲞⲖ ϦⲈⲚⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ ⲈⲒ ϨⲀⲢⲰⲦⲈⲚ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚⲦⲪⲞⲒ ⲚⲐⲰⲦⲈⲚ ⲈϮⲒⲞⲨⲆⲈⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ⲪⲀⲒ ⲞⲨⲚ ⲈⲒⲞⲨⲀϢϤ ⲘⲎⲦⲒ ϨⲀⲢⲀ ⲀⲒⲒⲢⲒ ϦⲈⲚⲞⲨⲀⲤⲒⲀⲒ ⲒⲈ ⲚⲎ ⲈϮⲤⲞϬⲚⲒ ⲈⲢⲰⲞⲨ ⲀⲒⲤⲞϬⲚⲒ ⲈⲢⲰⲞⲨ ⲔⲀⲦⲀ ⲤⲀⲢⲜ ϨⲒⲚⲀ ⲚⲦⲈϤϢⲰⲠⲒ ⲚⲦⲞⲦ ⲚϪⲈⲠⲒⲀϨⲀ ⲀϨⲀ ⲚⲈⲘ ⲠⲒⲘⲘⲞⲚ ⲘⲘⲞⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ϤⲈⲚϨⲞⲦ ⲚϪⲈⲪⲚⲞⲨϮ ϪⲈ ⲠⲈⲚⲤⲀϪⲒ ⲈⲦⲀϤϢⲰⲠⲒ ϨⲀⲢⲰⲦⲈⲚ ⲚⲞⲨⲀϨⲀ ⲀⲚ ⲠⲈ ⲚⲈⲘ ⲞⲨⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲞⲨⲀϨⲀ ⲠⲈⲦⲀϤϢⲰⲠⲒ ⲚϦⲎ ⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ⲠⲒϢⲎⲢⲒ ⲄⲀⲢ ⲚⲦⲈⲪⲚⲞⲨϮ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲒⲎⲤⲞⲨⲤ ⲪⲀⲒ ⲈⲦⲀⲚϨⲒⲰⲒϢ ⲘⲘⲞϤ ϦⲈⲚⲐⲎⲚⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦ ⲚⲈⲘ ⲤⲒⲖⲞⲨⲀⲚⲞⲤ ⲚⲈⲘ ⲦⲒⲘⲞⲐⲈⲞⲤ ⲘⲠⲈϤϢⲰⲠⲒ ⲚⲞⲨⲀϨⲀ ⲚⲈⲘ ⲞⲨⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲞⲨⲀϨⲀ ⲠⲈⲦⲀϤϢⲰⲠⲒ ⲚϦⲎⲦϤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ⲚⲒⲰϢ ⲄⲀⲢ ⲦⲎⲢⲞⲨ ⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲈⲚϦⲎ ⲦϤ ⲞⲨⲀϨⲀ ⲠⲈ ⲈⲐⲂⲈⲪⲀⲒ ⲞⲚ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦϤ ⲠⲈ ⲠⲒⲀⲘⲎⲚ ⲪⲚⲞⲨϮ ⲈⲨⲰⲞⲨ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ⲪⲎ ⲆⲈ ⲈⲦⲦⲀϪⲢⲞ ⲘⲘⲞⲚ ⲚⲈⲘⲰⲦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ⲠⲈ ⲞⲨⲞϨ ⲪⲎ ⲈⲦⲀϤⲐⲀϨⲘⲈⲚ ⲪⲚⲞⲨϮ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ⲞⲨⲞϨ ⲀϤⲈⲢⲤⲪⲢⲀⲄⲒⲌⲒⲚ ⲘⲘⲞⲚ ⲞⲨⲞϨ ⲀϤϮ ⲚⲀⲚ ⲘⲠⲀⲢⲎⲂ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀⲈϦⲢⲎⲒ ⲈⲚⲈⲚϨⲎ Ⲧ. ");
INSERT INTO copbhc_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ⲀⲚⲞⲔ ⲆⲈ ϮⲰϢ ⲞⲨⲂⲈ ⲪⲚⲞⲨϮ ⲘⲘⲈⲐⲢⲈ ⲈϪⲈⲚ ⲦⲀⲮⲨⲬⲎ ϪⲈ ⲈⲒϮⲀⲤⲞ ⲈⲢⲰⲦⲈⲚ ⲘⲠⲒⲒ ϪⲈ ⲈⲔⲞⲢⲒⲚⲐⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲀⲚⲞⲒ ⲚϬⲞⲒⲤ ⲈⲠⲈⲦⲈⲚⲚⲀϨϮ ⲀⲖⲖⲀ ⲦⲈⲚⲞⲒ ⲚϢⲪⲎⲢ ⲚⲢⲈϤⲈⲢϨⲰⲂ ⲈⲠⲈⲦⲈⲚⲢⲀϢⲒ ⲀⲢⲈⲦⲈⲚⲞϨⲒ ⲄⲀⲢ ⲈⲢⲀⲦⲈⲚ ⲐⲎⲚⲞⲨ ϦⲈⲚⲪⲚⲀϨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ⲪⲀⲒ ⲀⲒϮϨⲀⲠ ⲈⲢⲞϤ ⲚϦⲢⲎⲒ ⲚϦⲎⲦ ⲈϢⲦⲈⲘⲐⲢⲒⲒ ϨⲀⲢⲰⲦⲈⲚ ⲞⲚ ϦⲈⲚⲞⲨⲘⲔⲀϨ ⲚϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ⲒⲤϪⲈ ⲄⲀⲢ ⲀⲚⲞⲔ ⲈⲦϮⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲰⲦⲈⲚ ⲒⲈ ⲚⲒⲘ ⲈⲦⲐⲢⲞ ⲘⲘⲞⲒ ⲈⲢⲀϢⲒ ⲈⲂⲎⲖ ⲈⲪⲎ ⲈⲐⲘⲞⲔϨ ⲚϨⲎⲦ ⲈⲂⲞⲖ ⲘⲘⲞⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ⲞⲨⲞϨ ⲪⲀⲒ ⲀⲒⲤϦⲎⲦϤ ϨⲒⲚⲀ ⲀⲒϢⲀⲚⲒ ϨⲀⲢⲰⲦⲈⲚ ⲞⲚ ⲚⲦⲀϢⲦⲈⲘϬⲒ ⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲦⲈⲚⲎ ⲈⲦⲈⲤⲘⲠϢⲀ ⲚⲎⲒ ⲚⲦⲀⲢⲀϢⲒ ⲈⲂⲞⲖ ⲘⲘⲰⲞⲨ ⲈⲢⲈ ⲠⲀϨⲎⲦ ⲐⲎⲦ ⲈϨⲢⲎⲒ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲦⲎⲢⲞⲨ ϪⲈ ⲠⲀⲢⲀϢⲒ ⲪⲰⲦⲈⲚ ⲦⲎⲢⲞⲨ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ⲈⲂⲞⲖ ⲄⲀⲢ ϦⲈⲚⲞⲨⲚⲒϢϮ ⲚϨⲞϪϨⲈϪ ⲚⲈⲘ ⲞⲨⲘⲔⲀϨ ⲚϨⲎⲦ ⲀⲒⲤϦⲀⲒ ⲚⲰⲦⲈⲚ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ ⲚⲈⲢⲘⲎ ϪⲈ ⲚⲦⲈⲠⲈⲦⲈⲚϨⲎⲦ ⲘⲔⲀϨ ⲀⲚ ⲀⲖⲖⲀ ϪⲈⲬⲀⲤ ⲚⲦⲈⲦⲈⲚⲈⲘⲒ ⲈϮⲀⲄⲀⲠⲎ ⲈⲦⲈⲢϨⲞⲨⲞ ⲚϦⲎⲦ ⲈⲢⲰⲦⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ⲒⲤϪⲈ ⲆⲈ ⲀⲞⲨⲀⲒ ϮⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲈⲦⲀϤϮ ⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲎⲒ ⲀⲚ ⲀⲖⲖⲀ ⲀⲠⲞⲘⲈⲢⲞⲤ ϨⲒⲚⲀ ⲚⲦⲀϢⲦⲈⲘⲞⲨⲀϨ ⲂⲀⲢⲞⲤ ⲈϪⲈⲚ ⲐⲎⲚⲞⲨ ⲦⲎⲢⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ⲔⲎⲚ ⲈⲪⲀⲒ ⲘⲠⲀⲒⲢⲎϮ ⲈⲦⲀⲒⲈⲠⲒⲦⲒⲘⲒⲀ ⲐⲀⲒ ⲈⲦⲀⲤϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲘⲎϢ. ");
INSERT INTO copbhc_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ϨⲰⲤⲦⲈ ⲠⲈⲦⲞⲨⲂⲎϤ ⲘⲀⲖⲖⲞⲚ ⲚⲦⲈⲦⲈⲚⲈⲢϨⲘⲞⲦ ⲞⲨⲞϨ ⲚⲦⲈⲦⲈⲚϮⲚⲞⲘϮ ⲚⲀϤ ⲘⲎⲠⲰⲤ ϦⲈⲚⲠⲒϨⲞⲨⲞ ⲘⲔⲀϨ ⲚϨⲎⲦ ⲚⲤⲈⲰⲘⲔ ⲘⲪⲀⲒ ⲘⲠⲀⲒⲢⲎϮ. ");
INSERT INTO copbhc_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ⲈⲐⲂⲈⲪⲀⲒ ϮϮϨⲞ ⲈⲢⲰⲦⲈⲚ ⲈⲦⲀϪⲢⲈ ⲞⲨⲀⲄⲀⲠⲎ ⲈϦⲞⲨⲚ ⲈⲢⲞϤ. ");
INSERT INTO copbhc_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ⲈⲐⲂⲈⲪⲀⲒ ⲄⲀⲢ ⲀⲒⲤϦⲀⲒ ⲚⲰⲦⲈⲚ ϨⲒⲚⲀ ⲚⲦⲀⲈⲘⲒ ⲈⲦⲈⲦⲈⲚⲆⲞⲔⲒⲘⲎ ⲒⲤϪⲈ ⲦⲈⲦⲈⲚⲞⲒ ⲚⲢⲈϤⲤⲰⲦⲈⲘ ϦⲈⲚϨⲰⲂ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ⲪⲎ ⲆⲈ ⲈⲦⲈⲦⲈⲚⲚⲀⲈⲢϨⲘⲞⲦ ⲚⲀϤ ⲀⲚⲞⲔ ϨⲰ ϮⲒⲢⲒ ⲚⲀϤ ⲔⲈ ⲄⲀⲢ ⲀⲚⲞⲔ ⲠϨⲘⲞⲦ ⲈⲦⲀⲒⲀⲒϤ ⲪⲎ ⲈⲦⲀⲒⲀⲒϤ ⲚϨⲘⲞⲦ ⲀⲒⲀⲒϤ ⲈⲐⲂⲈ ⲐⲎⲚⲞⲨ ϦⲈⲚⲠϨⲞ ⲚⲒⲎⲤⲞⲨⲤ ⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ϨⲒⲚⲀ ⲚⲦⲈϢⲦⲈⲘ ⲠⲤⲀⲦⲀⲚⲀⲤ ϬⲒⲦⲦⲈⲚ ⲚϪⲞⲚⲤ ⲦⲈⲚⲞⲂϢ ⲄⲀⲢ ⲀⲚ ⲚⲚⲈϤⲘⲈⲨⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ⲈⲦⲀⲒⲒ ⲆⲈ ⲈⲦⲢⲰⲀⲤ ⲈⲠⲒⲈⲨⲀⲄⲄⲈⲖⲒⲞⲚ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲈⲦⲀ ⲞⲨⲢⲞ ⲞⲨⲰⲚ ⲚⲎⲒ ϦⲈⲚⲠϬⲞⲒⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ⲘⲠⲈ ⲠⲀⲠⲚⲈⲨⲘⲀⲘⲦⲞⲚ ⲈⲦⲈ ⲘⲠⲒϪⲒⲘⲒ ⲚⲦⲒⲦⲞⲤ ⲠⲀⲤⲞⲚ ⲞⲨⲞϨ ⲈⲦⲀⲒⲈⲢⲀⲠⲞⲆⲀⲌⲈⲤⲐⲈ ⲚⲰⲞⲨ ⲀⲒⲒ ⲈⲂⲞⲖ ⲘⲘⲀⲨ ⲈⲐⲘⲀⲔⲈⲆⲞⲚⲒⲀ. ");
INSERT INTO copbhc_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ⲠϨⲘⲞⲦ ⲆⲈ ⲘⲪⲚⲞⲨϮ ϢⲎⲠ ⲪⲀⲒ ⲈⲐⲞⲨⲞⲚϨ ⲘⲘⲞⲚ ⲈⲂⲞⲖ ⲚⲤⲎⲞⲨ ⲚⲒⲂⲈⲚ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲞⲨⲞϨ ⲚⲤⲐⲞⲒ ⲚⲦⲈⲠⲈϤⲈⲘⲒ ⲈϤⲞⲨⲞⲚϨ ⲘⲘⲞϤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲈⲚ ϦⲈⲚⲘⲀⲒ ⲚⲒⲂⲈⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ϪⲈ ⲀⲚⲞⲚ ⲞⲨⲤⲐⲞⲒⲚⲞⲨϤⲒ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲘⲪⲚⲞⲨϮ ϦⲈⲚⲚⲎ ⲈⲐⲚⲀⲚⲞϨⲈⲘ ⲚⲈⲘ ϦⲈⲚⲚⲎ ⲈⲐⲚⲀⲦⲀⲔⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ⲚϨⲀⲚⲞⲨⲞⲚ ⲘⲈⲚ ⲚⲞⲨⲤⲐⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲘⲞⲨ ⲈⲨⲘⲞⲨ ⲚϨⲀⲚⲞⲨⲞⲚ ⲆⲈ ⲚⲞⲨⲤⲐⲞⲒ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲰⲚϦ ⲈⲨⲰⲚϦ ⲞⲨⲞϨ ⲚⲒⲘ ⲈⲦⲞⲒ ⲚϨⲒⲔⲀⲚⲞⲤ ⲞⲨⲂⲈ ⲚⲀⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ⲚⲀⲚⲞⲒ ⲄⲀⲢ ⲀⲚ ⲘⲪⲢⲎϮ ⲚⲞⲨⲘⲎϢ ⲈⲨⲈⲢⲒⲈⲂϢⲰⲦ ⲘⲠⲤⲀϪⲒ ⲘⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲦⲞⲨⲂⲞ ⲀⲖⲖⲀ ϨⲰⲤ ⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ ⲦⲈⲚⲤⲀϪⲒ. ");
INSERT INTO copbhc_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ⲦⲈⲚⲈⲢϨⲎⲦⲤ ⲞⲚ ⲚⲦⲀϨⲞⲚ ⲈⲢⲀⲦⲈⲚ ⲒⲈ ⲘⲎ ⲦⲈⲚⲈⲢⲬⲢⲒⲀ ⲚϨⲀⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲘⲪⲢⲎϮ ⲚϨⲀⲚⲔⲈⲬ ⲰⲞⲨⲚⲒ ⲈⲨⲦⲀϨⲞ ⲘⲘⲞⲚ ⲈⲢⲀⲦⲈⲚ ϨⲀⲢⲰⲦⲈⲚ ⲒⲈ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲐⲎⲚⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ϪⲈ ⲞⲨⲎⲒ ⲦⲈⲚⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲐⲰⲦⲈⲚ ⲠⲈ ⲈⲤⲤϦⲎⲞⲨⲦ ϦⲈⲚⲚⲈⲚϨⲎⲦ ⲈⲨⲈⲘⲒ ⲈⲢⲞϤ ⲈⲨⲰϢ ⲘⲘⲞⲤ ⲚϪⲈⲢⲰⲘⲒ ⲚⲒⲂⲈⲚ ");
INSERT INTO copbhc_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ⲦⲈⲦⲈⲚⲞⲨⲞⲚϨ ⲈⲂⲞⲖ ϪⲈ ⲚⲐⲰⲦⲈⲚ ⲞⲨⲈⲠⲒⲤⲦⲞⲖⲎ ⲚⲦⲈⲠⲬⲢⲒⲤⲦⲞⲤ ⲈⲀⲨϢⲈⲘϢⲒ ⲘⲘⲞⲤ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲈⲚ ⲈⲤⲤϦⲎⲞⲨⲦ ϦⲈⲚⲞⲨⲘⲈⲖⲀ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲪⲚⲞⲨϮ ⲈⲦⲞⲚϦ ϦⲈⲚϨⲀⲚⲠⲖⲀⲜ ⲚⲰⲚⲒ ⲀⲚ ⲀⲖⲖⲀ ϦⲈⲚϨⲀⲚⲠⲖⲀⲜ ⲚϨⲎⲦ ⲚⲤⲀⲢⲜ. ");
INSERT INTO copbhc_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ⲞⲨⲞⲚⲦⲀⲚ ⲆⲈ ⲘⲘⲀⲨ ⲚⲞⲨⲐⲰⲦ ⲚϨⲎⲦ ⲘⲠⲀⲒⲢⲎϮ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲠⲬⲢⲒⲤⲦⲞⲤ ϨⲀ ⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ⲞⲨⲬ ⲞⲦⲒ ϪⲈ ⲈⲂⲞⲖ ϨⲒⲦⲞⲦⲈⲚ ⲘⲘⲀⲨⲀⲦⲈⲚ ⲦⲈⲦⲈⲚⲞⲒ ⲚϨⲒⲔⲀⲚⲞⲤ ⲈⲘⲈⲨⲒ ⲈⲨϨⲰⲂ ϨⲰⲤ ϪⲈ ⲈⲂⲞⲖ ⲘⲘⲞⲚ ⲀⲖⲖⲀ ⲦⲈⲚⲘⲈⲦϨⲒⲔⲀⲚⲞⲤ ⲞⲨⲈⲂⲞⲖ ϦⲈⲚⲪⲚⲞⲨϮ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ⲪⲀⲒ ⲈⲦⲀϤⲐⲢⲈⲚⲈⲢⲠⲈⲘⲠϢⲀ ⲚⲈⲢⲆⲒⲀⲔⲰⲚ ⲈϮⲆⲒⲀⲐⲎⲔⲎ ⲘⲂⲈⲢⲒ ⲚⲦⲈⲞⲨⲤϦⲀⲒ ⲀⲚ ⲀⲖⲖⲀ ⲚⲦⲈⲞⲨⲠⲚⲈⲨⲘⲀⲠⲒⲤϦⲀⲒ ⲄⲀⲢ ϤϦⲰⲦⲈⲂ ⲠⲒⲠⲚⲈⲨⲘⲀϤⲦⲀⲚϦⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ⲒⲤϪⲈ ϮⲆⲒⲀⲔⲰⲚⲒⲀ ⲚⲦⲈⲪⲘⲞⲨ ϦⲈⲚϨⲀⲚⲤϦⲀⲒ ⲈⲨⲪⲰⲦϨ ϦⲈⲚϨⲀⲚⲰⲚⲒ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲰⲞⲨ ϨⲰⲤⲦⲈ ⲚⲦⲈϢⲦⲈⲘ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ϢϪⲈⲘϪⲞⲘ ⲚϪⲞⲨϢⲦ ⲈϦⲞⲨⲚ ϦⲈⲚⲠϨⲞ ⲘⲘⲰⲨⲤⲎⲤ ⲈⲐⲂⲈ ⲠⲰⲞⲨ ⲚⲦⲈⲠⲈϤϨⲞ ⲪⲎ ⲈⲐⲚⲀⲔⲰⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ⲠⲰⲤⲰ ⲘⲀⲖⲖⲞⲚ ⲚⲦⲈϢⲦⲈⲘ ⲠϢⲈⲘϢⲒ ⲚⲦⲈⲠⲒⲠⲚⲈⲨⲘⲀϢⲰⲠⲒ ϦⲈⲚⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ⲒⲤϪⲈ ⲄⲀⲢ ϮⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲦⲈⲠⲒϨⲒⲞⲨⲒ ⲘⲠϨⲀⲠ ⲀⲤϢⲰⲠⲒ ϦⲈⲚⲞⲨⲰⲞⲨ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲤⲚⲀⲈⲢϨⲞⲨⲞ ⲚϪⲈϮⲆⲒⲀⲔⲞⲚⲒⲀ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ϦⲈⲚⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ⲔⲈ ⲄⲀⲢ ⲘⲠⲈϤϬⲒⲰⲞⲨ ⲚϪⲈⲪⲎ ⲈⲦⲀⲨϮ ⲰⲞⲨ ⲚⲀϤ ϦⲈⲚⲠⲀⲒⲘⲈⲢⲞⲤ ⲈⲐⲂⲈ ⲠⲒⲰⲞⲨ ⲈⲐⲞⲨⲰⲦⲈⲂ ⲚϨⲞⲨⲞ. ");
INSERT INTO copbhc_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ⲒⲤϪⲈ ⲄⲀⲢ ⲠⲈⲐⲚⲀⲔⲰⲢϤ ⲀϤϢⲰⲠⲒ ⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲰⲞⲨ ⲚϨⲞⲨⲞ ⲘⲀⲖⲖⲞⲚ ⲠⲈⲦϢⲞⲠ ϦⲈⲚⲞⲨⲰⲞⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ⲈⲞⲨⲞⲚⲦⲀⲚ ⲞⲨⲚ ⲚⲞⲨϨⲈⲖⲠⲒⲤ ⲘⲠⲀⲒⲢⲎϮ ⲘⲀⲢⲈⲚⲒⲢⲒ ⲚⲞⲨⲚⲒϢϮ ⲚⲞⲨⲰⲚϨ ⲈⲂⲞⲖ. ");
INSERT INTO copbhc_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲀⲚ ⲘⲘⲰⲨⲤⲎⲤ ⲈϢⲀϤⲬⲰ ⲚⲞⲨⲔⲀⲖⲨⲘⲘⲀ ⲈϪⲈⲚ ⲠⲈϤϨⲞ ⲈϢⲦⲈⲘⲐⲢⲈ ⲚⲈⲚϢⲎⲢⲒ ⲘⲠⲒⲤⲖ ϢϪⲈⲘϪⲞⲘ ⲚϪⲞⲨϢⲦ ⲈⲠⲒⲰⲞⲨ ⲚⲦⲈⲠⲈϤϨⲞ ⲪⲎ ⲈⲐⲚⲀⲔⲰⲢϤ. ");
INSERT INTO copbhc_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ⲀⲖⲖⲀ ⲀⲨⲐⲰⲘ ⲚϪⲈⲚⲞⲨⲘⲈⲨⲒ ϢⲀ ⲈϦⲞⲨⲚ ⲄⲀⲢ ⲈⲪⲞⲞⲨ ⲚⲈϨⲞⲞⲨ ⲠⲒⲔⲀⲖⲨⲘⲘⲀ ⲚⲞⲨⲰⲦ ϤⲬⲎ ϨⲒϪⲈⲚ ⲠⲒⲰϢ ⲚⲦⲈϮⲆⲒⲀⲐⲎⲔⲎ ⲚⲀⲠⲀⲤ ⲚϤϬⲰⲢⲠ ⲈⲂⲞⲖ ⲀⲚ ϪⲈ ⲈϤⲚⲀⲔⲰⲢϤ ϦⲈⲚⲠⲬⲢⲒⲤⲦⲞⲤ. ");
INSERT INTO copbhc_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ⲀⲖⲖⲀ ϢⲀ ⲈϦⲞⲨⲚ ⲈⲪⲞⲞⲨ ⲈϢⲰⲠ ⲀⲨϢⲀⲚⲰϢ ⲘⲘⲰⲨⲤⲎⲤ ⲠⲒⲔⲀⲖⲨⲘⲘⲀ ⲞⲚ ϤⲬⲎ ⲈϪⲈⲚ ⲠⲞⲨϨⲎⲦ. ");
INSERT INTO copbhc_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ⲈϢⲰⲠ ⲆⲈ ⲀϤϢⲀⲚⲔⲞⲦϤ ⲈⲠϬⲞⲒⲤ ϢⲀϤⲰⲖⲒ ⲘⲠⲒⲔⲀⲖⲨⲘⲘⲀ ⲘⲘⲀⲨ. ");
INSERT INTO copbhc_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ⲠϬⲞⲒⲤ ⲆⲈ ⲠⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲠⲒⲘⲀ ⲈⲦⲈ ⲠⲒⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠϬⲞⲒⲤ ⲘⲘⲞϤ ⲞⲨⲘⲈⲦⲢⲈⲘϨⲈ ⲦⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ⲀⲚⲞⲚ ⲆⲈ ⲦⲎⲢⲞⲨ ϦⲈⲚⲞⲨϨⲞ ⲈϤϬⲰⲢⲠ ⲈⲂⲞⲖ ⲦⲈⲚϪⲞⲨϢⲦ ⲈⲠⲰⲞⲨ ⲘⲠϬⲞⲒⲤ ϦⲈⲚⲞⲨⲒⲀⲖ ⲈⲚϢⲒⲂϮ ⲘⲘⲞⲚ ⲚϨⲢⲎⲒ ϦⲈⲚⲦⲀⲒϨⲒⲔⲰⲚ ⲦⲀⲒϨⲒⲔⲰⲚ ⲈⲂⲞⲖ ϦⲈⲚⲞⲨⲰⲞⲨ ⲈⲨⲰⲞⲨ ⲞⲨⲞϨ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲚⲈⲈⲂⲞⲖ ϨⲒⲦⲈⲚ ⲞⲨⲠⲚⲈⲨⲘⲀⲚⲦⲈⲠϬⲞⲒⲤ ⲠⲈ. ");
INSERT INTO copbhc_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ⲈⲐⲂⲈⲪⲀⲒ ⲈⲞⲨⲞⲚⲦⲀⲚ ⲘⲘⲀⲨ ⲚⲦⲀⲒⲆⲒⲀⲔⲞⲚⲒⲀ ⲔⲀⲦⲀ ⲪⲢⲎϮ ⲈⲦⲀⲨⲚⲀⲒ ⲚⲀⲚ ⲚⲦⲈⲚⲈⲢⲚⲔⲀⲔⲒⲚ ⲀⲚ. ");
INSERT INTO copbhc_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ⲀⲖⲖⲀ ⲈⲚⲬⲰ ⲚⲤⲰⲚ ⲚⲚⲎ ⲈⲦϨⲎⲠ ⲚⲦⲈⲠϢⲒⲠⲒ ⲚⲦⲈⲚⲘⲞϢⲒ ⲀⲚ ϦⲈⲚⲞⲨⲘⲈⲦⲤⲈⲂ ⲞⲨⲞϨ ⲚⲦⲈⲚⲈⲢⲬⲢⲞϤ ⲀⲚ ϦⲈⲚⲠⲒⲤⲀϪⲒ ⲚⲦⲈⲪⲚⲞⲨϮ ⲀⲖⲖⲀ ϦⲈⲚⲠⲒⲞⲨⲰⲚϨ ⲈⲂⲞⲖ ⲚⲦⲈϮⲘⲈⲐⲘⲎⲒ ⲈⲚⲦⲀϨⲞ ⲘⲘⲞⲚ ⲈⲢⲀⲦⲈⲚ ⲚⲀϨⲢⲈⲚ ⲤⲨⲚⲎⲆⲈⲤⲒⲤ ⲚⲒⲂⲈⲚ ⲚⲦⲈⲚⲒⲢⲰⲘⲒ ⲘⲠⲈⲘⲐⲞ ⲘⲪⲚⲞⲨϮ. ");
INSERT INTO copbhc_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ⲒⲤϪⲈ ⲆⲈ Ⲉ