﻿USE sofia;
DROP TABLE IF EXISTS sofia.conNTpo_vpl;
CREATE TABLE conNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES conNTpo_vpl WRITE;
INSERT INTO conNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Me'ttia'ye Chigaja sefacco, andeve'qque agattoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Me'ttia'ye agattoensi andeja ñotssimbiqquia'caen jincho. Nane pa'cco sinttiopa tsu na'enca'en jincho. Tsa'ma Chiga Qquendya'paja tsambe ombani can'jemba pa'cco tsama zivaen'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tsa'caen ñoñamba Chigaja su: “A'tatssia've daja.” Chiga tsa'caen su'ninda pa'cco a'tatssia've da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Pa'cco a'tatssia've dapa ñotssisi Chigaja attepa in'jamba avujatssi. Avujatssipa Chigaja a'tatssia'ma attufaen sinttia'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Sinttia'ye attufaemba a'tatssia'ma a'tave inisian. Toya'caen sinttiamajan coseve inisian. Tsa'caen inisiansi cosepa a'tapa primer a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Tsonsi Chigaja su: “Sefacco'su qquendya'pave attianjan na'en'su tsa'ccuma unjimba'ye attufaeñe.” ");
INSERT INTO conNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tsa'caen supa Chigaja sefacco'su qquendya'pave ñoña. Ñoñasi tsa'caen tsu da. Sefacco'su qquendya'pambe ombani tsu unjimbaja jin. Sefacco'su qquendya'pambe tsosiccuni tsu na'en'su tsa'ccuja jin. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tsonsi tsu Chigaja qquendya'pama sefaccove inisian. Nane cosepa a'tapa segundo a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Tsonsi Chigaja su: “Na'en'su shave'pa fae'ttinga bosi san'ame attianjan.” Tsa'caen susi tsa'caen tsu da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tsa'caen dasi Chigaja san'ama andeve inisian. Tsa'caen na'en fa'enga bo'choma'qque marve inisian. Inisiamba pa'ccoma camba ñotssisi attepa avujatssi. Avujatssipa ");
INSERT INTO conNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","su: “Ande'ye shoshovive sho'yoja. Toya'caen te'ta tise'pa chove'qque sho'yoja. Nane anqque'su teta'cho'qque sho'yopa tise'pa naqque'suve tsu naña'cho. Nane nanda tsu chove an'biaña'cho tsai'ccu atapaye.” Tsa'caen susi tsa'caen tsu da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nane shoshovi ande'ye sho'yosi te'ta tise'pa chove'qque sho'yo'fa. Anqque'su teta'cho'qque tise'pa naqque'suve tsu na'fa. Na tsu chove an'bian tsai'ccu atapaye. Tsa'caen dasi Chigaja attepa avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Cosepa a'tasi tercer a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tsonsi Chigaja su: “Sefaccone chanjunqque'su a'tatssia've chanjunjan cuintsu a'taja cose'ye joqquitssiye. Tsa'caen chanjumba tsu a'tave, canqque'fave'qque canjaeña. Osha'cho naiteve'qque tsu canjaeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Toya'caen tsa'caen sefacconi chanjumba tsu andema attiaña.” Tsa'caen susi tsa'caen tsu da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nane Chigaja dos rande chanjunqque'suve agattoemba ti'tsse randemajan coe'jeve ancaen cuintsu a'tave attiañe. Bove'ccoa'ma tsu ancaen cuintsu coseve attiañe. Toya'caen o'feve'qque agattoemba ancan'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tsa'caen agattoemba sefacconga ancaen cuintsu andenga attiamba ");
INSERT INTO conNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","a'ta, cosema'qque canjaeñe. Tsa'caen canjaemba tsu a'ta, cose'ye joqquitssi'choma canjaen. Tsa'caen dasi Chigaja attepa avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Cosepa a'tasi cuarto a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tsonsi Chigaja su: “Na'eñe osha'cho cansian jincho'chove attianjan. Toya'caen sefacconi'su qquendya'pa'ye osha'cho chhiririave attianjan cuintsu ande omba'ye chhaje'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tsa'caen supa Chigaja osha'cho rande na'en'su cansian jincho'chove agattoen. Nane osha'cho na'eni canse'pa jacanqque'suma ccaningandeqquiave agattoen. Toya'caen osha'cho sefacconi chhajeqque'su chhiririama'qque ccaningandeqquiave agattoen. Chigaja tsa'caen agattoemba attepa avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Avujatssipa tise'pama ñotsse afapa su: “Ñotsse canse'pa atapa'faja cuintsu na'en on'batssiye. Chhiriria'qque atapapa poi andeni can'jen'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tsa'caen susi cosepa a'tasi quinto a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tsonsi Chigaja su: “Andeni osha'cho cansian jincho'cho ccaningandeqquiave attianjan. Nane aiña'cho vaura'can, andenga manguqque'su, tsampini canseqque'su'qque ccaningandeqquiave attianjan.” Tsa'caen susi tsu tsa'caen da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nane Chigaja osha'cho tsampini canseqque'suma ccaningandeqquiave agattoemba osha'cho aiña'cho vaura'can'ma ccaningandeqquiave agattoen. Osha'cho andeni manguqque'suma'qque ccaningandeqquiave agattoen. Tsama agattoemba attepa avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Avujatssipa su: “Jinge a'ive agattoeñe. Nane ingi'caeñi agattoeña'cho cuintsu tiseja na'en'su avuma, sefani'su chhiririama, aiña'cho vaura'can'ma'qque mandaye. Nane pa'cco andema, osha'cho andeni manguqque'suma'qque mandaye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Chigaja tisu'caeñi a'ive agattoen. Nane Chiga'caeñi tsu Chigaja a'ive agattoen. Tsandie, pushesuve tsu a'ive agattoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Agattoemba tise'pama ñotsse afapa su: “Ñotsse canse'pa atapa'faja cuintsu pa'cco ande on'batssiye. Nane pa'cco andeni can'jemba osha'choma patsupa manda'faja. Na'en'su avu, sefani'su chhiriria, osha'cho andeni canseqque'suma'qque patsupa manda'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Toya'caen tsu Chigaja su: “Que canjan, tayo gi que'inga pa'cco teta'choma afe. Pa'cco tsu tise'pa choma an'bian tsai'ccu atapaye. Poi quini'ccoma'qque tise'pa nanga atapoenqque'su choi'ccu gi tayo afe. Tise'pa najan que'i anqque'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Toya'caen poiyi'cco va andeni cansian jincho'chonga gi inzia shoshovima afe tise'pa anqque'suve. Nane sefani'su chhiririanga, andenga manguqque'sunga osha'cho majan qquendya'jeqque'sunga'qque gi inzia shoshovima afe tise'pa anqque'suve.” Tsa'caen susi tsu tsa'caen da. ");
INSERT INTO conNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Chigaja osha'choma attepa avujatssi. Cosepa a'tasi sexto a'ta tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tsa'caen tsu Chigaja pa'cco sefacco andeve'qque agattoemba osha'cho tsani jincho'chove nanitsse agattoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nanimba septimo a'tave dasi tsequi a'ta pa'cco tise sema'bama nanimba ño'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tsa'camba “Septimo a'taja ña ñotssi a'ta tsu” qquen supa Chigaja “Tsa a'taja sema'ma'quia a'ta tsu” qquen su. Nane tsequi a'ta Chigaja osha'cho agattoen'cho sema'bama nanimba ño'fapa tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Qquen tsu Chiga agattoen'choja, ma'caen tiseja ande sefaccoma'qque agattoen: Na'su Chiga tsa'caen ande, sefaccove'qque agattointeja ");
INSERT INTO conNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","toya tsu ande'su te'ta, ande'su shoshovi'qque sho'yombi. Nane Na'su Chiga toya unjima moembisi tsu toya sho'yombi. Toya'caen a'i'qque toya can'jembi andema semañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tsa'ma ccuttopa'si ande'ye sombopa ansundepa surunome dapa pa'cco andema tssipoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tsa'caen tssipoensi Na'su Chigaja andema mandyiccoemba a'ive ñoña. Ñoñamba tsofatunga tise qquendya'pama ufapa tisema qquendyaen. Tsa'caen qquendyaen a'imajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tsomba Na'su Chigaja coejechiga sombo'jeni Edén andenga osha'cho ñotssiama jombachoccunga jon. Jomba tseni tsu Tise agattoen'cho a'ima ccutsian. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tsomba ande'ye Chigaja osha'choma shoyo'yaen. Nane osha'cho ñotsse atteqque'su quini'cco majama ñotssia anqque'suma shoyo'yaen. Toya'caen jombachoccumbe enttingenga tsu tiseja Cansiaña'cho Quini'ccoma sho'yaen. Faesu quini'ccoma'qque tseni sho'yaen. Tsa quini'ccoma an'da majan ñotssia, majan egave atesuya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edén andene tsu na'enjan sombo jombachoccuma tssipoeñe. Sombopa tsu cuatro na'eme da. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Fae'ccoma tsu Pisónme inisian. Tsaja pa'cco Havila andema shoquendí ja'je'cho. Cori tsu jin tsa andeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tsa corija ñotssi tsu. Toya'caen bedelio patu, ónice patu'qque tseni jin. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Faesu na'emanda tsu Gihónme inisian. Tsaja pa'cco Cus andema shoquendí ja'je'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Faesu na'ema tsu Tigrisve inisian. Tsa na'en ja'je'choja Asiria joccani chiga sombo'jefa tsu. Toya'caen faesu na'ema tsu Eufratesve inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tsonsi Na'su Chigaja a'ima Edéni'su jombachoccunga ccutsian cuintsu tsama semamba coiraye. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ccutsiamba a'ima su: “Poiyi'cco jombachoccu'su tetachoma qui añe osha. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tsa'ma tsa ñotssia, egama atesuya'cho quini'cco'su tetachomajan anjama. Nane maqui a'ta tsama an'da qui paya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tsomba Na'su Chigaja asi'ttaemba in'jan: “Ñotssimbi tsu tsandie tisuyi can'jeñe. Tisema fuite'suve gi ñoñaña tisia'can'me cuintsu tisei'ccu fae'ngae canseye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tsa'caen in'jamba Na'su Chigaja tayo andema osha'cho ande'ye jacanqque'su, sefa'ye chhajeqque'su chhiririave'qque ñoña'choma tsandienga i. Ipa tsandiema manda cuintsu osha'chove inisiañe. Tsa'cansi osha'cho tsu tsandie tise'pama inisianqquia'caen tsangae jincho. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nane tsandie tsu poiyi'cco aiña'cho vaura'can'ma sefani'su chhiririama, tsampini canseqque'suma'qque inisian. Tsa'ma ñoa'me tsandiei'ccu fae'ngae cansepa fuite'suve me'i'on. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tsa'cansi Na'su Chiga tisema anaesi tsandieja ana. Ana'jensi Chigaja tsandie utuccu'su tsu'ttama somboemba ttonoi'ccu changoma picco. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Utuccu'su tsu'ttama Na'su Chigaja pushesuve ñoña. Ñoñamba tsandienga afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Afesi tsandieja pushesuma attepa su: “¡Va tsu ñoa'me ña tsu'ttai'ccu, ña ttonoi'ccu ñama'caen ñoña'cho! Tisemanda gi inisiaña pushesuve. Nane Chigaja tsandie'suma tise've isusi ‘pushesu’ tsu.” ");
INSERT INTO conNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tsa'cansi tsu ja'ño tsandieja tise yaya, tise mamama catipa tise pushei'ccu can'jen'faya. Nane tsa dos tsu fae a'ia'caeñi da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Toya'caen tsa'caen ñoñasi tsandie, pushesu'qque chu'cco can'jen'fa. Tsa'ma tsa'caen can'jen'ma ansangembe'yi can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nane canjansi tsu poi Na'su Chiga agattoen'cho tsampini canseqque'suma ti'tsse injama'pa'can. Canjansija jipa pushesuma iñajampaña: —¿Ñoa'me ti Chigaja jombachoccu'su quini'cco nama añe se'pi? ");
INSERT INTO conNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Iñajampañasi pushesuja su: —Jombachoccu'su quini'cco namajan añe gi osha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tsa'ma tsa jombachoccumbe enttinge'su quini'cco nameñi tsu Chigaja añe se'pi. Ni pporaeñe'qque tsu se'pi. Nane tsa'caen tson'da gi pa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tsa'ma canjansija pushesuma su: —Ñoa'me paya'bi qui. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nane Chiga tsu atesu que'ija tsama an'da qui ñotsse injiengepa Chiga'caen osha'cho majan ñotssia, majan egave atesu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pushesuja tsama pañamba quini'ccoma camba ñotssi tsu qquen in'jan. Toya'caen tsambe na ñotssia anqque'susi an'da ñotssiave toya'caen egave'qque atesuye qquen in'jamba nama pishopa an. Amba faesuma pishopa tise tsa'ndunga afe. Afesi tise'qque an. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Amba, tso'fe fettayeqquia'caen, injama'choni tisupa chu'cco can'jen'choma in'jamba ansange'fa. Ansangepa higuera ccaquejema anchon setsaemba tise'pa ai'vonga tandamba picco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tsonsi sime tayo tumbiansi Na'su Chiga Quitsaja andenga andepa jombachoccu'ye tsui ja'je. Tsandie, pushesu tisema pañamba jombachoccu sheque'chombe enttingenga a'tu'fa, Na'su Chiga tise'pama attesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tsa'ma Na'su Chiga Quitsaja tsandiema ttu'sepa su: —¿Mani qui can'jen? ");
INSERT INTO conNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tsandieja su: —Que jombachoccunga pasia'je'choma pañamba gi chu'cco can'jemba dyopa a'tu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tsonsi Chigaja su: —¿Majan tsu que'inga conda chu'cco can'jen'chove? ¿An'fa ti qui ña se'pi'cho quini'cco'su tetachoma? ");
INSERT INTO conNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A'ija pañamba su: —Que ñanga afe'cho pushesu tsu tsa quini'cco'su nama ñanga afesi gi an. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tsonsi Na'su Chiga Quitsaja pushesuma iñajampaña: —¿Jongoesie qui tsa'caen tson? Pushesuja su: —Canjansi ñama afopoensi gi an. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tsonsi Na'su Chigaja canjansima su: —Queja tsa'caen egae tsincomba qui poiyi'cco aiña'cho vaura'can'ma, poiyi'cco tsampini canse'chondeccuma bove me'detsse vanaña. Nane tisu injamáccui'ccu qui mangú jacamba andema amba canseya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Toya'caen queja pushesui'ccu chi'gaccopa iyicco'fasi tsu que dushundeccu'qque tise dushundeccui'ccu chi'gaccopa iyicco'faya. Nane tsambe du'shu tsu que tsove'ye tsui sapiaña. Tsa'ma queja tise tsutuccu'choma sinttuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tsomba Chigaja pushesuma su: —Ja'ño gi ti'tsse quema vanaeña cuintsu vanamba du'shuma isuye. Nane ti'tsse aiye'jepa qui dushundeccuma isuya. Tsa'ma que tsa'nduma ñotsse in'jamba qui tisema pañaña. Tise tsu quema mandaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tsomba Chigaja tsandie, Adánma su: —Queja que pushema pañamba ña se'pi'cho quini'cco'su nama ansi gi quema'qque vanaeña. Nane andema egae tsonsi ñotsse sho'yombisi qui paya'ngae vanamba semamba que anqque'suma taipa aña. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ñoa'me tsu nopa'siyi atapaya. Tsa'cansi qui vanamba tta'ttapa aqquia sho'yo'cho tetachoma taipa an'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Poipa'sui'ccu quian'me semamba qui que cui'ccuma cu'i'faya. Nane papa queve ñoña'cho andeve ccase daya'ngae qui tsa'caen vana'jeña. Nane andema ñoña'chopa qui ccase andeve daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tsonsi tsandie, Adán, tise pushema inisian Evave. Nane tiseja poi a'imbe chaña'si tsa'caen inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Tsomba Na'su Chiga Quitsa tise'pama ondiqquian. Nane ttonoma ondiccu'jeve ñoñamba tsandie, tise pushema'qque ondiqquian. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ondiqquiamba asi'ttaemba su: —Ja'ño tsu a'ija ingi'caeñi da. Nane pa'cco ñotssia, pa'cco egave tsu atesu. ¿Jongoesu tsu tisema se'piya tsa Cansiaña'cho Quini'cco'su nama'qque añe? Tsama an'choecan'da tsu tsangae canseye'can. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tsa'caen asi'ttaemba Na'su Chigaja a'ima Edéni'su jombachoqquie tteyamañamba manda tise've ñoñaqque'su andema semañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tsandiema tteyamañamba dos Chiga sefacconi'su sundarondeccuma ccutsian Edéni'su jombachoccu sombo'ttinga. Nane tseni Edénima chiga sombo'jefanga tise'pama ccutsiamba si'nge matichima'qque manda cuintsu ccafa ccafa ccafa jaye majan tsa Cansiaña'cho Quini'cconga já catsesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Tsomba tse'i Adán tise pushe, Evai'ccu ccuisi Evaja surie dapa tsandie du'shuve isu. Tisema inisian Caínme. Evaja Caínma isupa su: “Na'su Chiga ñanga afesi gi tsandieve isu.” ");
INSERT INTO conNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Omboe tsambe quinshin, Abelve isu. Nane coemba Abelja oveja coira'suve da. Caínjan andema nasipave sema'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Can'jemba jai'ngae Caínjan andenga sho'yoqque'su nama taipa Na'su Chiganga afeye i. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Toya'caen Abelja tseyi isu'cho oveja du'shuma fi'ttipa yayapatssi nama ipa afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tsa'caen afe'fasi Chigaja Abelma in'jamba tise afe'choma'qque in'jan. Tsa'ma Caínma ni tise afe'choma'qque tiseja in'jambi. Tsa'cansi Caín iyicca'yesi ");
INSERT INTO conNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na'su Chigaja tisema su: —¿Jongoesie qui iyicca'ye? ");
INSERT INTO conNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nane que ñotsse tson'ninda gi queve ñotsse in'jaña. Tsa'ma ñotsse tsombi'ta —injama'tse, ñoa'me tsu egae tsincon'cho quema qqueñañe tson'jen. Nane quema patsuye tsu in'jan. Tsa'ma queja egae tsincon'choma patsuya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tsomba tse'i fae a'ta Caínjan tise quinshin Abelma ttu'se nasipani pasia'ngaye. Tsomba nasipani can'jemba Caínjan iyicca'yepa jangipa tise quinshin Abelma fi'tti. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tsa'caen fi'ttipa jisi Na'su Chigaja Caínma iñajampaña: —¿Mani tsu que quinshin, Abelja? Caínjan su: —¿Ma'caen gi atesuya? ¿Ñanda ti gi ña quinshinma coira'su? ");
INSERT INTO conNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tsonsi Na'su Chigaja su: —¿Jongoesie qui tsa'caen tson? Que quinshimbe anjampa tsu andenga tssamba ñama fundopa ttu'se ccane'qque quema fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tsa'cansi qui ja'ñojan ti'tsse vana'ma va ande'ye teyamoeñemba ñotsse isuya'bi. Nane andeja, aya'fama sharuqquia'caen que quinshin anjampama que tive'ye cu'ipa tsu quenga afeye se'piya. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ja'ño andema dyan'dyapa jon'ni'qque tsu sho'yaeñe se'piya que jongoesuma taisa'ne. Ñoa'me qui biani injanga jacamba poiyi'ccoma dyopa ccuyin ja'suve daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tsa'caen susi Caínjan Na'sunga su: —Ñoa'me gi oshambi tsa'caen canseye. Panshaen qui ñama vanae. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ja'ño qui ñama tteyamoeña va ande'ye. Biani poiyi'ccoma dyopa ccuyin japa injanga jacan'suve dasi majan ñama atte'ta tsu fi'ttiya. Ni quema gi ccase atteya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tsonsi Na'su Chigaja tisema su: —Tsa'caña'bi tsu. Nane majan Caínma fi'tti'ninda gi tisema ñoa'me ti'tsse vanaeña. Siete se ti'tsse tsu vanaña. Tsa'caen supa Na'suja canjaeña'choma Caínga afe cuintsu poiyi'cco majan tisema cachui'a'qque fi'ttimbecañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tsonsi Caínjan tseni Na'su Chigai'ccu condase'jene sombopa Edénima chiga sombo'jefanga Nod andeni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Tsomba tse'i Caín tise pushei'ccu ccui'jesi surie dapa Enocve isu. Omboe Caínjan canqqueve canqquian. Tsa canqqueve canqquiamba inisian tise du'shu Enoc iniseningae. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enocja Irad quitsa tsu. Iradja Mehujael Quitsa. Mehujaelja Metusal quitsa. Metusalja Lamec quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamecja dos pusheve tsu pushe. Fae'ccombe iniseja Adave. Faesuja Zila. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adaja Jabalve isu. Isusi tiseja poiyi'cco carpani canjensundeccumbe yayave tsu da. Poiyi'cco tsu vaura'can'ma'qque coirasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal quinshinjan Jubal tsu. Tsambe dushundeccu tsu poiyi'cco majan gitara'cain'ccu, fendo'ccoi'ccu'qque jeñasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Toya'caen Lamec faesu pushe Zilaja Tubal-caínme isu. Tsaja coemba yoshava, cu'a yoshavama'qque semamba osha'chove ñoña'su tsu. Tubal-caín que'tteja Naama tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Fae a'ta Lamecja tise dos pushendeccuma ttu'sepa su: “Ada, toya'caen Zila, que'ima gi pushe. Ña su'choma ñotsse paña'faja. Tsandie ñama iñaccaensi gi tisema fi'tti. Nane tsa chu'a tsandie ñama tssaisi gi tisema fi'tti. ");
INSERT INTO conNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tsa'cansi majan Caínma fi'tti'suja siete se ti'tsse vanaña'cho qquen su'chomanda ñoa'me majan ñama fi'tti'ta setenta y siete se tsu ti'tsse vanaña'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ccase Adán tise pushe Evai'ccu ccuisi faesu tsandie du'shuve isu. Tisema inisian Setve. Nane Evaja su: “Caín Abelma fi'ttisi pasi tsu Chiga Quitsaja ñanga faesu du'shuma afe.” ");
INSERT INTO conNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Toya'caen Set'qque coemba pushepa du'shuve an'biamba tisema inisian Enósve. Tise can'jeinte tsu aindeccuja Na'suma iñajañe ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Va tsu Adán omba'su dutssiyendeccumbe inisema tevaen'cho. Chigaja a'ima agattoemba tsu tisia'caen agattoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Toya'caen tsu tsandie, pushesuve agattoen. Agattoemba tise'pama ñotsse tsoña'chove afapa a'ive inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adánjan ciento treinta canqque'fave an'bian'ni tise dutssi'ye Setve isu. Ñoa'me tsu tiseja tise yaya Adán'cañi. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Omboe Adánjan faesu ochociento canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nane noveciento treinta canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Setja ciento cinco canqque'fave an'bian'ni tise dutssi'ye Enósve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Omboe Setja faesu ochociento siete canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nane noveciento doce canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enósja noventa canqque'fave an'bian'ni tise dutssi'ye Cainánme isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Omboe Enósja faesu ochociento quince canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nane noveciento cinco canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainánjan setenta canqque'fave an'bian'ni tise dutssi'ye Mahalaleelve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Omboe Cainán faesu ochociento cuarenta canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nane noveciento diez canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleelja sesenta y cinco canqque'fave an'bian'ni tise dutssi'ye Jaredve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Omboe Mahalaleelja faesu ochociento treinta canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nane ochociento noventa y cinco canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredja ciento sesenta y dos canqque'fave an'bian'ni tise dutssi'ye Enocve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Omboe Jaredja faesu ochociento canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nane noveciento sesenta y dos canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enocja sesenta y cinco canqque'fave an'bian'ni tise dutssi'ye Matusalénme isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enocja ñoa'me Chiga in'janqquia'caen canse. Matusalénme isusi Enocja faesu tresciento canqque'fave tsa'caen can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Nane Enocja tresciento sesenta y cinco canqque'fave can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tsa'ma Chiga in'janqquia'caen cansesi Chigaja tisema anga. Nane pambe'yi tsu metsse da. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalénjan ciento ochenta y siete canqque'fave an'bian'ni tise dutssi'ye Lamecve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Omboe Matusalénjan faesu seteciento ochenta y dos canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nane noveciento sesenta y nueve canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamecja ciento ochenta y dos canqque'fave an'bian'ni tise dutssi'yeve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Isusi tisema inisian Noéme. Nane Lamecja su: “Na'su Chiga andema egae tsonsi ñotsse sho'yombisi gi paya'ngae vanamba sema'jen'fa. Tsa'ma va du'shuja ingima ño'faen'su tsu ingi tive quimbisa'ne,” qquen supa du'shuma inisian Noéme. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noéme isusi Lamecja faesu quiniento noventa y cinco canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nane seteciento setenta y siete canqque'fave can'jemba tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noéjan quiniento canqque'fave an'biamba du'siañe ashaemba tise dutssiyendeccu Sem, Cam, toya'caen Jafetve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aindeccuja poi andenga atapapa pushesu du'shuve'qque an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tsonsi Chigave in'jan'cho tsandiendeccuja in'jambindeqquiambe onquengendeccu me'detssisi in'jamba tise'pama pushe'fa majame in'jan'da. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tsa'caen tson'fasi Na'su Chigaja su: “In'jambi gi aindeccu egae tsincomba tsangae canse'faye. Nane ciento veinte canqque'fave can'jemba tsu pa'je'faya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tsa'caen Chigave in'jan'cho tsandiendeccu faesu aindeccumbe onquengendeccuma pushepa du'shuve isu'fasi tsu rande quin'an aindeccuja andenga attian'fa. Nane bo'tsse tsa'caen pushe'je'fasi tise'pa dushundeccuja tayopi'su ti'tsse'tssia aindeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Poi ande'su aindeccu egae tsincomba canse'fasi Na'su Chigaja attepa in'jan. Nane aindeccu poi a'ta injama'choni egaveyi asi'ttaemba in'jansi ");
INSERT INTO conNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","attepa in'jamba ñombi'ye aindeccuve tayo agattoemba. Nane Tise agattoen'chone asi'ttaemba injama'choni ñombi'yepa ");
INSERT INTO conNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","su: “Pa'cco andema gi ccuchaya poiyi'cco ña agattoen'cho aindeccuma sefaeñe. Nane a'i, osha'cho cansepa andenga jacanqque'su, andenga manguqque'su, sefani chhajeqque'suma'qque gi ccucha fi'ttiya. Ñombi'ye gi tise'pave tayo ñoñamba.” ");
INSERT INTO conNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tsa'ma Na'su Chigaja Noéma ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Va tsu Noéne condase'cho: Noéjan ño'an a'isi poiyi'cco tise cansuite'su aindeccu'suma tise'veyi tsu Chigaja in'jan. Nane tiseja Chigama ñotsse pañamba canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noéjan tres dutssi'yeve an'bian: Sem, Cam, toya'caen Jafet. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Chigane'da poi ande tsu dañongeqquia'caen egae da. Nane a'ija iyiccopa fi'ttipa egae tsincomba canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Poi aindeccu tsa'caen egae tsincomba osha'choma daño'jensi attepa Chigaja ");
INSERT INTO conNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Noéma su: “Asi'ttaemba gi in'jan poi aindeccuma fi'tti sefaeñe. Tise'paja egae tsincomba poi andeni jacamba fi'ttipa daño'fa. Ñoa'me gi tise'pama fi'tti sefaemba pa'cco andema'qque sefaeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ñotssia congo'masia quini'ccoma shavoñajan rande tsa'o shavove. Tsain'bitssi cuartove ñoñajan. Toya'caen naccuma, sepaccoma'qque ccoqqui'ccu ñotsse ccoqquianjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Qquen tsu ñoñaña'cho randeve: Bia'suve ciento treinta y cinco metro. Attaja'suve veinte tres metro. Sefa'suve catorce metro. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nane tres ppappaccove ñoñajan. Tsaocajepa'fa jin'fanga ventaname'qque ñoñajan enttinge metro attaja'suve. Toya'caen faefangayi fae rande sombo'ttive ñoñajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ñoa'me gi mandaye tson'jen cuintsu na'en ñoa'me bo'iave jipa pa'cco andema piccoye. Piccopa tsu osha'cho cansepa jincho'choma pa'cco andengae fitti'ttiya. Nane osha'cho andeni jinqque'su tsu pa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tsa'ma que'i'ccu gi qquen fae'ngae injanccoya: Rande tsa'o shavonga qui que pushei'ccu, que dutssiyendeccu'qque tise'pa pushendeccui'ccu ca'nimba ccusha'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Toya'caen tsu rande tsa'o shavonga poiyi'cco cansepa jacanqque'suma fae quitsa'ye, fae pushema angaya'cho. Nane tsendeccu'qque que'ia'caeñi tsu ccusha'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Fae'ngae que'i'ccu tsu poiyi'cco cansepa jincho'cho'qque dosyi ca'nimba ccusha'faya. Nane chhiriria, aiña'cho vaura'can, andenga manguqque'su, poiyi'cco tsu que'i'ccu ca'niña'cho ccushapa canseye. ");
INSERT INTO conNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Toya'caen osha'cho anqque'suve'qque tsu boñamba angaya'cho cuintsu que'i toya'caen canse'pa jinchoqque'su'qque an'jeña'chove.” ");
INSERT INTO conNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noéjan ñotsse pañamba pa'ccoma Chiga mandaqquia'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Omboe tsu Na'su Chigaja Noéma su: “Tsa'o shavonga ca'ni'faja que aindeccui'ccu. Nane que'iyi qui va ja'ño cansuite'su aindeccu'suma ño'amba ñama paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Poi anqque'su vaura, oveja'can'ma'qque siete quitsa'ye, siete pusheveyi poiyi'cco'suma ca'niajan. Tsa'ma an'masia'ma aqquia fae quitsa'ye, fae pusheveyi poiyi'cco'suma ca'niaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Toya'caen osha'cho chhiririama'qque poiyi'cco'suma siete quitsa'ye, siete pusheveyi tsu ca'niaña'cho. Nane pa'cco jincho'choma tsu ca'niaña'cho fae jincho'cho qquesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ñoa'me gi su siete a'tave pasasi tsu unjin tuiye ashaeña. Nane cuarenta a'ta, cuarenta cose'qque tsu unjinjan tuiya. Pa'cco va ande'su cansian jincho'choma tsu ccuchapa fi'ttiya, pa'cco ña agattoen'choma.” ");
INSERT INTO conNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na'su Chiga mandaqquia'caen tsu Noéjan tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Na'en tsa'caen andenga bo'iave ji'jeni Noéjan seisciento canqque'fave an'biamba ");
INSERT INTO conNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","shavonga ca'ni. Tise pushe, tise dutssiyendeccu, tise'pa pushendeccu'qque tsu poiyi'cco Noéi'ccu fae'ngae ca'ni'fa na'eñe ccushaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Cansian jincho'cho, majan anqque'su, majan an'masia, majan chhajeqque'su, majan manguqque'su ");
INSERT INTO conNTpo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Noéi'ccu fae'ngae ca'ni'fa. Nane dos, dosveyi, quitsa'yeja tise pushei'ccu tsu Chiga mandaqquia'caen ca'ni'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Siete a'ta pasasi na'enjan andema piccoye ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nane Noéjan seisciento canqque'fave an'biansi segundo ccovu, a'ta diez y sieteni tsu pa'cco ande'su tsa'ccu sombo'je'ttija fettaye cuintsu ande tsosini'su tsa'ccu somboye. Toya'caen sefacconi'qque fettayeqquia'caen tsu sefacconi'su tsa'ccu amppi. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nane cuarenta a'ta, cuarenta cose'qque tsu tsa'caen tui'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tsa'caen unjin tuiyaqui a'ta tsu Noé, tise dutssiyendeccu, Sem, Cam, Jafet'qque ca'nisi Noé pushe, dutssiyendeccumbe pushendeccu'qque ca'ni'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tsendeccu toya'caen poiyi'cco cansian jincho'cho, poiyi'cco vaura'can, poiyi'cco andenga manguqque'su poiyi'cco chhiriria'qque tsu ca'ni'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Noéi'ccu dos, dosveyi poiyi'cco cansian jincho'choja quitsa'ye tise pushei'ccu Chiga mandaqquia'caen ca'ni'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Poiyi'cco ca'nisi Na'su Chigaja sombo'ttima picco. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Cuarenta a'ta tsu na'enjan bo'iave ji. Bo'iave jipa tsa'o shavoma sufottoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ti'tsse, ti'tsse tsu tsa'ccuja ji. Tsa'ma tsa'o shavoja ombanga sufotto. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nane tsa'ccu jipa pa'cco biani'su ande'su se'fatssia ccotta'ccoma'qque picco. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Pa'cco ccotta'ccoma piccopa toya tsu tsa'ccuja faesu siete metrove ji. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tsa'caen jisi poiyi'cco andeni can'jen'cho aindeccuja pa'fa. Chhiriria, osha'cho vaura'can, tsampini canseqque'su, andenga manguqque'su'qque pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pa'cco va andeni cansian jincho'cho tsu pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nane Noéñi, tisei'ccu tsa'o shavonga ca'ni'chondeccuyi tsu ccushapa canse'fa. Poiyi'cco cca'indeccuja pa'fa —a'i, vaura'can, sefani'su chhiriria, andenga manguqque'su'qque pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Na'enjan tsa'caen jipa ciento cincuenta a'ta sambambe'yi andema picco. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tsomba tse'i Chigaja Noé, poiyi'cco tisei'ccu tsa'o shavoni can'jen'cho cansian jincho'choma'qque injan'jemba fingiama mandamoen cuintsu andema samboeñe. Fingiansi na'enjan sambaye ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nane ande tsosini'su tsa'ccu sombo'je'tti piccoyepa sefacconi'su unjin'qque piccoyeqquia'caen panshan. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ti'tsse, ti'tsse tsu na'enjan samba. Ciento cincuenta a'ta pasasi tayo sambaji. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nane septimo ccovu a'ta diez y sieteni tsu tsa'o shavoja andenga pporopa Ararat ccotta'cconga ccui. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tsa'caen ccuisi toya tsu na'enjan ti'tsse sambaji. Nane decimo ccovu, primer a'ta tsu pa'cco ccotta'cco'su piyiccuja sombopa atteye. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Faesu cuarenta a'ta pasasi tsu Noéjan tise ñoña'cho ventanama fettapa ");
INSERT INTO conNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","seña'bama fettamaña. Fettamañasi tsaja chhaje jacan ande sambaya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Omboe ppuppuju'choma fettamaña, na'en sambaji'chove atesuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tsa'ma ppuppuju'choja mani andepa dyaiya'chove attembipa toequi tsa'o shavonga ji. Nane na'en tsu toya pa'cco andema picco'cho. Tsa'caen jisi Noéjan tise tivema yasapa ppuppuju'choma indipa tsa'o shavonga ca'nia. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Faesu siete a'ta pasasi ccase tsu Noéjan ppuppuju'choma fettamaña tsa'o shavo'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Fettamañasi japa sime toequi ji. Jipa olivo ccaque cunama ttetto'choi'ccu isi Noéjan attepa in'jan ande tayo sambayeji'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","In'jamba faesu siete a'tave ron'dapa ccase ppuppuju'choma fettamaña. Tsa'caen fettamañasi toequi tiseni jimbi. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noéjan seisciento uno canqque'fave an'bian'ni, primer ccovu, primer a'ta tsu andema picco'je'cho na'enjan tayo samba. Tsa'cansi Noéjan shavo tsa'oma fettapa can ccutsu. Can ccutsupa atte ande samba'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Segundo ccovu, a'ta veinte y sieteni tsu pa'cco andeja samba. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tsonsi Chigaja Noéma su: ");
INSERT INTO conNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tsa'o shavo'ye sombo'faja que pushei'ccu, que dutssiyendeccu'qque tise'pa pushendeccui'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Toya'caen que'i'ccu can'jen'cho poiyi'cco cansian jincho'choma somboenjan. Nane chhiriria, andenga jacanqque'su, andenga manguqque'suma'qque somboenjan cuintsu pa'cco andenga japa dundutssia've atapaye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tsonsi Noéjan sombo. Nane tise pushe, tise dushundeccu, tise'pa pushendeccu'qque fae'ngae tisei'ccu sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Toya'caen poiyi'cco vaura'can, tsampini can'jenqque'su, andenga manguqque'su, chhiriria'qque tsa'o shavo'ye sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tsonsi Noéjan Na'su Chiganga afeye oque'je'chove ccutsiamba osha'cho anqque'su vaura, oveja'can'ma, osha'cho anqque'su chhiririama'qque isupa oquepa Na'su Chiganga afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tsa'caen oque oraensi ansundesi Na'su Chigaja avujapa asi'ttaemba su: “Ccatsse gi andema tsa'caen egae tsoña'bi a'i egae tsincon'chone. Nane tsaveqque'su tsu a'ija chuitepie tsa'caen egaveyi in'jañe. Toya'caen ccatsse gi poiyi'cco cansian jincho'choma tsa'caen fi'ttiya'bi, ña ja'ño tsonqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nane ande toya jin'ninda joña'cho taiya'cho'qque pasaya'bi. Chan'dia, coe'je'qque pasaya'bi. Coejefa, sanfan'qque pasaya'bi. A'ta, cose'qque pasaya'bi.” ");
INSERT INTO conNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Chigaja Noé, tise dutssiyendeccuma'qque ñotsse tsoñe in'jamba qquen su: “Pa'cco andeni japa can'jemba atapa'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Toya'caen tsu poiyi'cco va andeni canseqque'su, sefani chhajeqque'su chhiriria, andenga manguqque'su, marni'su avu'qque que'ima dyoe'sui'ccu in'jan'faya. Nane ña que'inga afesi qui poiyi'cco tsendeccuma manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Toya'caen pa'cco cansian jincho'cho tsu que'i anqque'su. Nane ande'ye sho'yoqque'su tetachoma anqque'suve que'inga afeqquia'caeñi gi osha'cho cansian jincho'choma'qque que'inga afe cuintsu amba canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tsa'ma aña'cho na toya canseqquia'caen anjampapama qui an'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Toya'caen poi a'i shacama, poi cansian jincho'cho shacama'qque gi iñajaña. Nane que'i anjampai'ccu qui afepoeña'cho. Poiyi'ccoma gi shacave iñajaña tisupapora canse'chone. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Majan faesu a'ima fi'tti'ninda faesu a'i tsu tsama'qque fi'ttiya. Nane Chiga tisia'caen a'ive agattoen'choma fi'ttipa tsu tsa'caen paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tsa'ma que'ija poi andenga japa tsain'bio du'shuve isupa ñotsse atapa'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Toya'caen Chigaja Noéma, tise dutssiyendeccuma'qque su: ");
INSERT INTO conNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Que canjan. Que'i'ccu gi fae'ngae injanccopa toya'caen que'i omba'su dutssiyendeccui'ccu'qque fae'ngae injancco'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nane poiyi'cco que'i'ccu tsa'o shavo'ye sombopa can'jendeccu —chhiriria, vaura'can, poi tsampini jincho'choi'ccu'qque gi fae'ngae injancco'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Que'i'ccu cambian'masia've fae'ngae injanccopa gi su: Ccatsse gi poiyi'cco cansian jincho'choma ccase na'ei'ccu fi'ttiya'bi. Ni ccatsse gi pa'cco andema ccase na'ei'ccu piccopa dañoña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Uttufasima gi canjaeña unjimbanga cuintsu que'i attepa Ña que'i'ccu ja'ño jai'ngae'qque poi cansian jincho'choi'ccu injancco'fa'choma injan'jeñe. Tsama attepa qui in'jan'faya Ña va ande'sui'ccu injancco'fa'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nane ña mandasi unjimba jangisi uttufasima attepa ");
INSERT INTO conNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","gi Ña que'i'ccu, poi cansian jincho'choi'ccu fae'ngae injancco'fa'choma injan'jeña. Ccatsse tsu na'enjan ccase andema piccoya'bi poi cansian jincho'choma fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nane uttufasi unjimbanga attiansi gi tsama attepa ña poi ande'su osha'cho cansian jincho'choi'ccu fae'ngae injancco'fa'choma injan'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tsa uttufasi tsu ña poi ande'su osha'cho cansian jincho'choi'ccu fae'ngae injancco'fa'choma canjaen'cho.” Tsa'caen tsu Chigaja Noéma su. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé dutssiyendeccu tisei'ccu tsa'o shavo'ye sombo'chondeccu tsu Sem, Cam, toya'caen Jafet. Camjan Canaán quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tsa tres Noé dutssiyendeccupa tise'pa omba'su dutssiyendeccui'ccu tsu pa'cco andenga atapa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noéjan andema sema'su tsu. Tise tsu o'tie ofa tsajama joñe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Jomba tsa nasi nama taipa vinome cupaen. Vinome cupaemba cu'ipa ccusi. Ccusipa chu'cco ccui tise carpa tsaoni. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Tsa'caen ccuisi Cam, tsa Canaán quitsa, tise yaya chu'cco ccui'choma atte. Attepa sombopa tise antiandeccuma conda. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Pañamba Sem, Jafeti'ccu sarupama sepaccofanga indipa sepaccopayi carpa tsa'onga ca'nimba tise'pa yaya chu'cco ccui'choma picco'fa. Nane ccanima camba tise'pa yaya chu'cco ccui'choma atte'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ccusipa pasasi qquendyapa Noéjan in'jan tise du'shu chu'a tisema tson'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","In'jamba su: “Egae tsu tsoña Canaánga. Nane tise antiandeccu tisema mandasi me'detssia sema'suve tsu daya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Toya'caen tsu Noéjan su: “Na'su ña Chiga tsu Semnga ñotsse tsoña. Nane Sem tsu Canaánma semoeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Chiga anttesi Jafetja ñoa'me atapaya. Atapapa Semi'ccu fae'ngae can'jemba tise'qque Canaánma semoeña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Na'en tsa'caen pa'cco andema piccopa sambasi Noéjan ti'tsse tresciento cincuenta canqque'fave can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nane noveciento cincuenta canqque'fave an'biamba pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Va tsu Noé dutssiyendeccu Sem, Cam, Jafet omba'su dutssiyendeccu. Na'en andema piccopa sambasi vandeccuma isu'fasi canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet dutssiyendeccu tsu Gomer, Magog, Madai, Javán, Tubal, Mesec toya'caen Tiras. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer dutssiyendeccu tsu Askenaz, Rifat toya'caen Togarma. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javán dutssiyendeccu tsu Elisa, Tarsis, quiteondeccu toya'caen rodaneondeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Tsendeccuja Jafet dutssiyendeccu tsu mar otafani can'jen'fa. Poiyi'cco tsu tisupa andeni can'jemba tisupa aya'fangae afa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam dutssiyendeccu tsu Cus, Mizraim, Fut toya'caen Canaán. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cus dutssiyendeccu tsu Seba, Havila, Sabta, Raama toya'caen Sabteca. Raama dutssiyendeccu tsu Seba toya'caen Dedán. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus tsu Nimrod quitsa. Nimrodja aishe ñoa'me va ande'su joccapitssia a'i tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Na'su Chiga anttesi tiseja tsampini jacamba ñotsse panzaye atesu. Tisene tsu qquen su'cho ashaen: “Tsaja Nimrod'caen Na'su Chiga anttesi tsampini jacamba ñotsse panzaye atesu.” ");
INSERT INTO conNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tise manda'je'cho canqque tsu Babel, Erec, Acad toya'caen Calne. Poiyi'cco tsa canqque tsu Sinar andei'ccu pporotsse jincho. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nane Sinar ande'ye tsu Asurja sombopa faesu canqqueve canqquian. Tise tsu Nínive canqque, Rehobot-ir, Cala toya'caen tsa rande Resén canqqueve canqquian. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resén tsu Nínive, Cala enttingeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraimjan Ludeo aindeccumbe yaya tsu. Toya'caen anameondeccu, lehabitandeccu, naftuhitandeccu, ");
INSERT INTO conNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseondeccu, casluhítandeccu toya'caen caftorítandeccumbe yaya tsu. Filisteondeccu tsu caftorítandeccu'ye sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaánjan Sidón quitsa tsu. Tsaja tise dutssi'ye coenza. Tise faesu dutssi'yeja Het tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Toya'caen tise tsu faesu aindeccu'su yaya. Nane jebuseondeccu, amorreondeccu, gergeseondeccu, ");
INSERT INTO conNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveondeccu, araceondeccu, sineondeccu ");
INSERT INTO conNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeondeccu, zemareondeccu toya'caen hamateondeccu tsu tise omba'su dutssiyendeccu. Omboe tsu tsa cananeondeccuja biani japa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Nane cananeondeccu ande tsu Gerar andeni já shoquendi Gazani. Toya'caen Sidón canqqueni já shoquendipa Sodoma, Gomorra, Adma, Zeboimma pashamba Lazani nepi. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tsendeccuja Cam omba'su dutssiyendeccu tsu. Poiyi'cco tsu tisupa andeni can'jemba tisupa aya'fangae afa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semjan Jafet quindya tsu. Tise'qque du'shupasi tise omba'su dutssi'ye tsu Heber. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Nane Sem dutssiyendeccu tsu Elam, Asur, Arfaxad, Lud toya'caen Aram. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram dutssiyendeccu tsu Uz, Hul, Geter toya'caen Mas. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxadja Sala quitsa tsu. Salaja Heber quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Tse'i tsu Heberja dos dutssiyendeccuve an'bian. Fae'cco tsu Peleg. Nane tisema isusi poiyi'cco aindeccu attufaccosi tsu tsa'caen tisema inisian. Tise quinshin tsu Joctán. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán dutssiyendeccu tsu Almodad, Selef, Hazar-mavet, Jera, ");
INSERT INTO conNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO conNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO conNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila toya'caen Jobab. Poiyi'cco tsendeccu tsu Joctán dutssiyendeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tise'pa andeja Mesa andeni já shoquendi Sefar andeni. Tsa tsu chiga sombo'jeni'su ccotta'cco'su ande. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tsendeccuja Sem omba'su dutssiyendeccu tsu. Poiyi'cco tsu tisupa andeni can'jemba tisupa aya'fangae afa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Poiyi'cco tsendeccu tsu Noé omba'su dutssiyendeccu. Nane tise dutssiyendeccumbe dushundeccuma agattopa tevaen'cho tsu. Tise'pa can'jen'cho andema tevaen'cho tsu. Nane na'en andema piccopa sambasi tsu tsa'caen atapapa poi andenga japa attufa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nane tsendeccu can'jeinteja poiyi'cco a'i tsu fae aya'faveyi afa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tsomba majan a'i chiga sombo'jene sombopa Sinar andeni japa fae'ngatssia andema atte'fa. Attepa tse'tti can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Fae a'ta fae'ngae condaseccopa su'fa: “Jinge apichama ladriyove ñoñamba si'ngei'ccu ta'etssia've oque'faya.” Patu me'i'onsi tsesui'ccu tsao'ña'fa. Toya'caen tsu breave an'bian'fa ladriyoma setsaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Omboe tsu su'fa: “Jinge rande canqqueve canqquiamba ñoa'me se'fatssia tsa'ove'qque tsao'ñañe sefacconi pporotsse. Tsa'caen tsao'ña'ninda tsu poiyi'cco cca'indeccuja ingima in'jan'faya joccapitssia've. Toya'caen tsa'caen tsomba gi biani attufambe'yi fae'ngae can'jen'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tsa'ma Na'su Chigaja a'i ñoña'cho canqquema atteye ande. Toya'caen tsu a'i ñoña'cho se'fatssia tsa'oma atteye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Attepa Na'su Chigaja asi'ttaen: “Tsendeccuja fae a'iyi tsu. Nane fae aya'fangae tsu afa'je'fa. Tsa'camba fae'ngae in'jamba tsu qquen tsoñe ashaen'fa. Aqquia ashaen'cho tsu. Nane osha'chove in'jan'da tsu tsa'caen tson'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Jinge andepa tise'pa aya'fama ccaningae cambiamba qqueñañe cuintsu poiyi'cco tisupapora ñotsse pañambe'yi can'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tsa'caen supa tsu Na'su Chigaja poiyi'cco a'ima attufaemba maña poi andeni. Attufaensi tise'pa canqqueve ñoña'jen'choma antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nane tsa'caen Na'su Chiga tise'pa aya'fama ccaningae cambiansi tsa canqquema inisian'fa Babelve “aya'fa qque'fa'cho” qquen su'chove. Tsene Na'su tise'pama somboensi poi andeni japa cca'tti cca'tti can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Qquen tsu Sem dutssiyendeccu: Na'en andema piccopa sambasi dos canqque'fa pasasi Semjan cien canqque'fave an'bian'ni tsu tise dutssi'ye Arfaxadve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Omboe Semjan faesu quiniento canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxadja treinta y cinco canqque'fave an'bian'ni tise dutssi'ye Salave isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Omboe Arfaxadja faesu cuatrociento tres canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Salaja treinta canqque'fave an'bian'ni tise dutssi'ye Heberve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Omboe Salaja faesu cuatrociento tres canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heberja treinta y cuatro canqque'fave an'bian'ni tise dutssi'ye Pelegve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Omboe Haberja faesu cuatrociento treinta canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegja treinta canqque'fave an'bian'ni tise dutssi'ye Reuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Omboe Pelegja faesu dosciento nueve canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reuja treinta y dos canqque'fave an'bian'ni tise dutssi'ye Serugve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Omboe Reuja faesu dosciento siete canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugja treinta canqque'fave an'bian'ni tise dutssi'ye Nacorve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Omboe Serugja faesu dosciento canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacorja veinte y nueve canqque'fave an'bian'ni tise dutssi'ye Taréve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Omboe Nacorja faesu ciento diez y nueve canqque'fave can'jemba ti'tsse tsu tsandie, pushesu du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taréja setenta canqque'fave an'bian'ni tise dutssiyendeccu Abram, Nacor toya'caen Haránme isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Qquen tsu Taré dutssiyendeccu: Tiseja Abram, Nacor toya'caen Haránmbe yaya. Haránjan Lot quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Taré toya canse'ni tsu Haránjan pa Caldea ande'su Ur canqqueni. Nane tisuma isu'cho canqqueni tsu pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramjan Saraima pushe. Nacorja Milcama pushe. Nane Milcaja Harán onque'nge tsu. Harán faesu dutssi'ye tsu Isca. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraija du'shuve isuye oshambipa du'shuve me'cco canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taréja Canaán andeni jaye in'jamba Caldea ande'su Urne sombopa ja. Tisei'ccu tsu tise dutssi'ye Abram'qque ja. Toya'caen tsu tise du'shu Lot, tise china Sarai'qque jaja'fa. Canaán andeni jaye in'jan'ma Harán canqqueni nepipa tse'tti can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taréja dosciento cinco canqque'fave an'biamba pa Harán canqqueni. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Fae a'ta tsu Na'su Chigaja Abramma su: “Que andema catipa ña quenga can'jeña'cho andenga jaja. Nane que antiandeccu, que yaya tsa'oma'qque catipa jaja. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Quema ñotsse tsomba gi que dutssiyendeccui'ccu ti'tsse'tssi a'ive tsoña. Nane quei'ccu ña poiyi'cco a'ima ñotsse tsonsi tsu poiyi'cco a'i que inisema ñotsse afa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Majan quema in'jamba ñotsse afa'ninda gi tise'pama ñotsse tsoña. Tsa'ma majan quema afase'ninda gi tise'pama egae tsoña. Nane quei'ccu tsu poi ande'su aindeccuja Ña ñotssiama isu'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tayo setenta y cinco canqque'fave an'bian'ni Na'su Chiga Abramma mandasi Haráne sombopa ja. Lot'qque tisei'ccu fae'ngae ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nane tsa'caen japa Abramjan tise pushe Saraima, toya'caen tise quinshimbe du'shu Lotma'qque anga. Toya'caen pa'cco tise'pa Haráni can'jemba isu'cho andu'choma, tseni an'bian'cho semasundeccuma'qque angapa Canaán andeni jaye ashaen'fa. Canaánni nepipa ");
INSERT INTO conNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","tsa ande enttingeni japa Siquem canqqueni nepi'fa. Nane Siquemni tsu More roble quini'ccoccuja jin, tsa chigama iñajan'jen'tti. Cananeondeccu tsu tsa canqqueni can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Abram tseni can'jensi tsu Na'su Chigaja tisenga attiamba su: “Va andema gi que dutssiyendeccunga afeya.” Tsa'caen tisenga attiamba susi Abramjan Na'su Chiganga afeye oque'je'chove tse'ttinga ccutsian. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Omboe tsene sombopa Betel canqquema chiga sombo'jefa'su ccotta'cconga japa tise carpama ccutsian. Tseni can'jen'ninda tsu Betel canqqueja chiga amppi'jefani. Toya'caen chiga sombo'jefani tsu Hai canqque. Abram tseni can'jemba faesu Chiganga afeye oque'je'chove ccutsian Na'su Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Omboe ccase jaye ashaemba cca'tti cca'tti canjen'ñacca ja Néguev andeni nepiye. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tsonsi tse'i tsu qquipoesuiteve da poi Canaán andeni. Nane aña'cho me'i'onsi Abramjan sombopa Egiptoni jaye ashaen tseni japa can'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egiptoni pan nepijipa tsu tise pushe Saraima su: “Que canjan. Atesu gi queja me'detssia pushesusi. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nane Egiptondeccu quema atte'ta tsu su'faya: ‘Va pushesu tsu va tsandiembe pushe.’ Tsa'caen in'jamba tsu ñama fi'ttiya quema canseveyi itsapa an'biañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tsa'caen dasa'ne chigáne queja ña que'tte qquen suja cuintsu tsa'caen in'jamba ñama ñotsse tson'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tsomba Abram Egiptoni nepisi poi Egiptondeccuja Saraima attepa me'detssisi in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Toya'caen Egipto ande na'su faraónma shondosundeccu'qque tisema attepa tisene na'sunga conda'fa. Conda'fasi faraónjan manda cuintsu Saraima i'faye tise tsaoni. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","I'fasi na'su faraónjan Saraima ñotsse in'jamba Abramnga ñotsse tson. Nane oveja, vaura, sema'su tsandiendeccu, sema'su pushesundeccu, boro, toya'caen cameyo tsain'bitsse afe Abramnga. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tsa'ma tsa'caen Saraima itsa'fasi tsu Na'su Chigaja na'su faraón, tise tsa'osundeccuma'qque osha'cho paqque'sui'ccu da'ño. ");
INSERT INTO conNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tsonsi faraónjan in'jamba Abramma ttu'sepa tisema su: “¿Jongoesie qui tsa'caenjan ñama tson? ¿Mingapa qui ñanga tansintsse condambi va pushesuja que pushe qquen? ");
INSERT INTO conNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nane que que'tte qquen susi gi ti'tssecan'da tisema pusheye'can. Ja'ñojan va'tti tsu que pushe. ¡Junde tisema angapa jaja!” ");
INSERT INTO conNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tsa'caen supa faraónjan tise tsandiendeccuma manda cuintsu Abram, tise pushe, pa'cco tise an'bian'choma'qque junde Egiptone somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramjan tise pushei'ccu, pa'cco tise an'bian'choi'ccu Egipto ande'ye sombopa toequi Néguev andeni ja'fa. Tise quinshimbe du'shu Lot'qque fae'ngae tise'pai'ccu ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramjan ñoa'me rico. Nane cori, totoacori, tsain'bia vaura'can'ma'qque an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Néguevni japa cca'tti cca'tti can'jemba Betel canqqueni nepi'fa. Nane toequi tise'pa tayoe can'jeni japa can'jen'fa. Tsaja Betel, Hai canqque enttingeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tse'ttinga tsu tayoeja Chiganga afeye oque'je'choma ccutsian. Tsa'camba tsu toe'ttingayi Na'su Chigama iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Toya'caen Lot'qque ñoa'me rico. Nane tise ton'ton Abram'caen osha'cho vaura, ovejama'qque an'bian. Toya'caen tsain'bio a'i tisei'ccu can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tsa'cansi tsu Abram, Loti'ccu can'jen'ttija ñoa'me on'ba'o. Nane shoshovi shacasi tsain'bio vaurama tseni fae'ngae o'fiañe oshambi. Tsa'camba ti'tsse tsa'caen fae'ngae can'jeñe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Toya'caen Abram vaurama coirasundeccuja Lot vaurama coirasundeccui'ccu sepiccopa tssetssecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tsa'cansi fae a'ta Abramjan Lotma su: “Quei'ccuja antiandeccu gi. Tsa'cansi tsu ingi iyiccoyeja ega. Ni ingimbe coirasundeccu'qque tsa'caen iyicco'faye ega tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tsain'bitssi ande tsu jin manima in'jan'da ingi isuya'cho. Chigáne ña'ñe joqquitssija. Que tansinfanga ja'ninda gi ñajan pavefanga jaya. Tsambi'ta que pavefanga ja'ninda gi ñajan tansinfanga jaya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tsa'caen susi Lotja pa'cco Jordán na'en'su andema camba tsama in'jan. Nane Zoar canqquepi tsu tsain'bio tsa'ccu jin. Nane ñoa'me ñotssia jombachoqquiacan'omba tsu Egipto andian'caeñi attian. Lot tsa'caen camba in'jainteja toya Na'su Chiga Sodoma canqque, Gomorra canqquema joqquitssian catimbi'te tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tsa'caen in'jamba Lotja Jordán na'en'su andeni jaye qquen supa tise'pa can'jen'tti'ye sombopa chiga sombo'jefanga ja. Tsa'caen tsu Abram, Lot'qque attufacco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram toya Canaán andeni can'jensi Lotja Jordán na'en jini'su canqqueni can'jeñe ja. Nane Sodoma canqque pporotsse tsu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tseni'su aindeccuja ñoa'me egae in'jamba Na'su Chigama chi'gapa osha'cho tson'choi'ccu egae tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot tsa'caen jasi, Na'su Chigaja Abramnga su: “Que can'jene ñotsse canjan. Nane tansinfanga, pavefanga chiga sombo'jefanga, chiga amppi'jefanga'qque camba in'janjan: ");
INSERT INTO conNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Quenga gi afeya pa'cco que camba atte'cho andema. Tsangae qui queja, que omba'su dutssiyendeccu'qque va andema an'bian'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ña anttesi tsu tsendeccuja ande'su sisipa'caen tsain'bitssia've da'faya. Nane sisipafo'choma agattoye oshambiqquia'caen tsu que dutssiyendeccuja agatto'ma'sia've da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tsa'cansi jangipa pa'cco ande bia'sunga attaja'sunga'qque jacamba canjan ña quenga afe'cho andema.” ");
INSERT INTO conNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tsa'caen susi Abramjan pa'cco tise an'bian'choma ñoñamba Hebrón canqque pporotsse japa ccotta'cco'su roble quini'ccoccuni can'jen. Tseni'su na'suja Mamre tsu. Tseni can'jemba Abramjan Chiganga afeye oque'je'choma ccutsian Na'su Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tsaite tsu Amrafelja Sinar canqque na'su. Ariocja Elasar canqque na'su tsu. Quedorlaomerja Elam canqque na'su tsu. Toya'caen Tidalja Goim canqque na'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Tsendeccu tsu fae'ngae in'jamba faesundeccui'ccu geraen'fa. Nane Beraja Sodoma canqque na'su tsu. Birsaja Gomorra canqque na'su tsu. Sinabja Adma canqque na'su tsu. Semeberja Zeboim canqque na'su tsu. Tsendeccui'ccu geraemba toya'caen Bela canqque'su na'sui'ccu'qque geraen'fa. Tsa Bela canqquema tsu Zoarve inisian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tsa cinco canqque'su nasundeccu tsu tise'pa sundarondeccui'ccu Sidim ande'su sinjunccuni bo'fa. Tsa sinjunccu tsu ja'ño a'taja Pa'cho marve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nane doce canqque'fave tsu na'su Quedorlaomerja tise'pama patsu. Patsusi somboye in'jamba tsu canqque'fa trece tsa cinco nasundeccuja bo'fa Quedorlaomerja catiye na'suve. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Faesu canqque'fa tsa Quedorlaomerja tisei'ccu fae'ngae in'jan'cho nasundeccui'ccu jipa faesu aindeccuma patsu'fa. Nane Astarot-karnaim andeni japa refaítandeccuma patsu'fa. Toya'caen Ham andeni japa zuzitandeccuma patsu'fa. Tsomba Save-quiriataim andeni japa emitandeccuma patsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Tsomba Seir ccotta'cconi japa horeondeccuma patsupa omboen'fa Parán'su fae'ngatssia andeni. Tsa fae'ngatssia ande tsu a'i meniai'ccu pporotssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tsa'caen patsupa toequi shandapa jipa Quedorlaomer, tisei'ccu fae'ngae geraen'fa'chondeccu'qque En-mispatni nepi'fa. Tsa canqquembe faesu iniseja Cades. Tseni nepipa pa'cco amalecitandeccu andema da'ñomba sefaen cati'fa. Toya'caen tsa'caeñi tsu tson'fa amorreondeccumbe Hazezon-tamar andema'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Tsa'caen faesuma patsusi tsu Sodoma, Gomorra, Adma, Zeboim, toya'caen Bela canqque'su nasundeccu tsa Sidim sinjunccuni bo'fa'cho. Tsa'caen bopa tsu tsa cinco nasundeccu tise'pa sundarondeccui'ccu na'su Quedorlaomeri'ccu geraen'fa. Quedorlaomeri'ccu fae'ngae tsu fuite'fa Tidal, Amarafel toya'caen Arioc. Tsendeccuja cuatroyi'cco tsu Elam, Goim, Sinar toya'caen Elasar canqque'su nasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nane tsa Sidim sinjunccuni tsu tsain'bio rande chango sheque, brea jincho. Quedorlaomer tise'pama patsusi tsa Sodoma, Gomorra nasundeccuja ccuyin japa majanda tsesu changonga amppi ca'ni'fa. Cca'indeccuja ccotta'cconga ccuyin ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tsomba tsu patsusundeccuja Sodoma, Gomorra canqquenga japa pa'cco anqque'su, toya'caen osha'cho bare'choma'qque taipa jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nane Lot, Abram antianmbe du'shuja, Sodomani can'jensi tisema'qque indipa anga'fa pa'cco tise an'bian'choma'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tsa'ma fae'cco tseni'su a'ija ccushapa sombopa Hebreo a'i Abramnga conda'su ji. Nane Abramjan toya tsa Amorreo a'i Mamrembe roble quini'ccoccuni can'jen. Mamre antiandeccu Escol, toya'caen Aner'qque Abramma fuitesundeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Jipa condasi Abramjan paña tise antianmbe du'shu Lotma indipa anga'choma. Pañamba poiyi'cco tise'be semasundeccuma ttu'se. Nane tsendeccu chuitepie Abrami'ccu can'jensi Abramjan tise'pama ñotsse atesu. Nane poiyi'ccota tsu tresciento diez y ocho tsandiendeccu. Tsendeccui'ccu tsu Abramjan tsa Quedorlaomer aindeccuma mandian'fa Dan canqqueni. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tseni nepipa tise aindeccuma dos naccuve attufaemba a'tutsse can'jemba cose tsa nasundeccuma patsupa biani mandian'fa. Nane Damasco canqquema panshamba ti'tsse joccani japa Hoba canqqueni tise'pama mandian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Tsa'caen patsupa pa'cco tise'pa itsapa anga'choma itsa'fa. Tsa'caen tsu Abramjan tise antianmbe du'shu Lotma ccushaen. Pa'cco Lotmbema itsa'choma'qque atte'fa. Toya'caen pushesundeccuma, cca'indeccuma'qque ccushaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram tisema fuite'su nasundeccu'qque Quedorlaomerma patsupa jiña'fasi Sodoma canqque'su na'suja sombopa tise'pama cachui Save sinjunccuni. Tsa Save sinjunccumajan “Ande na'sumbe sinjunccu” qquen tsu su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Toya'caen Melquisedec tsa Salem canqque'su na'su'qque tisema cachuiye ji. Tiseja Sefacconi'su Joccapitssia Chigama afa'supa pan, vinoma'qque ipa ");
INSERT INTO conNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abramma ñotsse afapa qquen su: “Cuintsu Sefacconi'su Joccapitssia Chiga sefacco, andema'qque agattoen'su quema ñotsse tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nane Sefacconi'su Joccapitssia Chiga ñotssipa quema fuitesi quema iyiccayesundeccuma patsu'ta tisema ñotsse afa'faja.” Tsa'caen susi Abramjan tise patsupa itsapa angaji'choma fae chonga'ccoeyi Melquisedecnga afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tsa'caen afesi omboe Sodoma na'suja Abramnga su: —Que ña aindeccuma ccushaen'choma ñanga afepa pa'cco osha'cho que itsa'choma que'iyi isu'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tsa'ma Abramjan tisenga su: —Nane Na'su Sefacconi'su Joccapitssia Chiga sefacco, andema agattoen'su paña'jen'ni gi su: ");
INSERT INTO conNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Quembemajan isuya'bi gi, fae iro, ni sapato tandan'faveyi'qque, queja que afesi ñajan ricove da qquen su'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nane ñajan tayo ña aindeccu an'fa'chosi jongoesuveyi'qque ti'tsse isuya'bi gi. Tsa'ma ñama fuitesundeccu, Aner, Escol, toya'caen Mamre tsu ingi itsa'choma attufaemba isu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Tsama omboe Na'su Chigaja Abramnga attiamba tisema su: —Dyombe canjan Abram. Ña gi quema fuite'su. Ña quenga afeya'choja ñoa'me injan'tssiya tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tsa'ma Abramjan tisema su: —Na'su Chiga, ¿jongoesune tsu bare ña osha'choma injan'tsse isuye? Ñajan dutssi'yeve me'choa gi. Nane Queja ñanga du'shuma afembisi me'cco pa'ninda tsu tsa Damasco canqque'su Eliezer–ñambe sema'su a'i–pa'cco ña an'bian'choma isuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tsa'ma Na'su Chigaja tisema su: —Que an'bian'choma isuya'choja ñoa'me quembetsse dutssi'yeya tsu. Nane Eliezer isuya'bi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tsa'caen supa Na'suja Abramma tsoteni angapa su: —Sefacconima ñotsse camba o'fema agattocanjan; da osha've'se qui. Nane tsa'caen tsu que dutssiyendeccuja agattoye oshambi'tsse atapaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Na'su Chiga tsa'caen susi Abramjan tise su'choma ñotssi pañamba in'jan. Tsa'caen in'jansi Na'su Chigaja “Abram tsu ño'an” qquen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Toya'caen tsu Chigaja Abramnga su: —Ña gi Na'su. Quema gi Caldea ande'su Ur canqquene somboemba vani i, va andema quenga afeye que an'biañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tsonsi Abramjan iñajampaña: —Na'su Chiga, ¿ma'caen gi atesuya va andeja ñambeve? ");
INSERT INTO conNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tsa'caen iñajampañasi Chigaja su: —Ñani ija fae vaura pushema tres canqque'fave an'bian'choma. Toya'caen chivo pushema, quitsa'yema'qque ija tres canqque'fave an'bian'choma. Toya'caen fae manambe, fae ppuppuju'choma'qque ija. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramjan pa'ccoma Chiga mandaqquia'caen Chigani ipa enttinge'ye gettipa isevetsse isevetsse ccuiña. Tsa'ma sanccopapamajan gettimbe'yi ccuiña. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tsa'caen ccuiña'chonga ccompanajan ande'fa. Tsa'ma Abramjan tsa ccompanama dyoña'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tayo cose jisi Abramjan ñoa'me anae'supa pa'ye'e ana. Tsa'caen ana'jen'ni pa'cco tise ccui'tti sintsse dasi Abramjan ñoa'me dyo. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tsa'caen dyosi Na'suja tisema su: —Atesuya'cho tsu que dutssiyendeccu faesu andeni can'jemba tsenima aqquiatsse ganambe semasundeccuve da'faya'choma. Tsa'caen dapa tsu cuatro ciento canqque'fave me'detsse vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tsa'ma tise'pama vanaesundeccumbe injama'choma gi somboeña. Nane tsa andema gi vanaeña que dutssiyendeccuma ccushaeñe. Ccushapa sombopa tsu osha'cho ñotssia bare'choma an'bian'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","(Tsa'ma queja coenza ccashe'yeve dapa qui opatsse papa que tayopi'su coenzandeccuni jaya.) ");
INSERT INTO conNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Cuatro ciento canqque'fave tsa andeni can'jemba tsu que omba'su dutssiyendeccuja ccase vani ji'faya. Nane toya tsu amorreondeccuja nanitsse egae tsincon'fambi ña tise'pa andema itsaya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tsonsi chiga amppipa tayo si'en dasi oro'je'cho si'ngema angaqque'su api, si'nge anchanda'je'cho'qque attiamba tsa gettipa ccuiña'cho enttinge'ye panshan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tsa'caen tsu tsequi a'ta Na'su Chigaja Abrami'ccu injanccopa tisema su: —Va andema gi que omba'su dutssiyendeccunga afeya. Egipto'su naene pa'cco tsa Eufrates na'en jimpi. ");
INSERT INTO conNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nane tsa andeta tsu ja'ñojan, ceneondeccu, cenezeondeccu, cadmoneondeccu, ");
INSERT INTO conNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hititandeccu, ferezeondeccu, refaítandeccu, ");
INSERT INTO conNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreondeccu, cananeondeccu, gergeseondeccu toya'caen jebuseondeccu ande. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram pushe Saraija du'shuve isuye oshambi. Tsa'ma tise'be sema'su pushesuve an'bian, egipto'su pushesu, Agar, qquen inisecho'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tsa'caen an'biamba asi'ttaemba Abramnga su: —Que canjan, Na'su Chiga se'pisi gi ñajan du'shuve me'cho. Tsa'camba gi in'jan que ña sema'su pushesui'ccu can'jen'ninda tsu osha'ta ñambe du'shuve isuya'bi. Tsa'caen susi Abramjan Sarai suqquia'caen in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tsonsi Abram pushe Saraija Egipto ande'su pushesu Agarma tise tsa'ndu Abramnga afe cuintsu tisei'ccu fae'ngae can'jeñe. Tsa'caen afesi tsu Abramjan diez canqque'fave Canaán andeni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram tsa'caen Agari'ccu can'jensi surive da. Tsa'caen dapa Agarja tise na'su Saraima patsu qquen in'jamba quinsepoemba can'boen. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tsa'caen in'jansi attepa Saraija Abramma su: —Que qui shacapa Agar ñama patsu'chone. Nane ña gi tisema quenga afe fae'ngae can'jeñe. Tsa'ma ja'ño surie dapa tiseja ñama patsu qquen in'jan. Tsa'cansi Na'su Chiga tsu atesu majan tsu shacapa–que, tsambi'ta ña. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tsama pañamba Abramjan su: —Que canjan, va pushesuja quembe sema'su tsu. Tisema ma'caen tsoñe in'jan'da tsa'caen tsonjan. Tsa'caen susi Saraija Agarma tsain'bitsse egae tsincoñe ashaen. Tsa'caen tsinconsi Agarja ccuyin ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tsa'ma Na'su Chigama sefacconi'su shondo'suja pushesu a'i menia jayipa Shur tsaiqui'su tsa'ccu sombo'je'ttini can'jen'choma cachuipa ");
INSERT INTO conNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","iñajampaña: —Agar, Saraimbe sema'su, ¿mane qui ji? Toya'caen, ¿mani qui jayi? Agarja pañamba su: —Ña na'su Saraine gi ccuyapa jayi. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tsonsi Na'su Chigama shondo'suja su: —Toequi que na'suni japa tisema ñotsse pañajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Toya'caen tsu Na'su Chigama shondo'suja su: “Tsain'bitsse gi atapoeña que dushundeccuma. Nane majañi'qque agattoye osha'faya'bi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tayo qui suri. Tsandie du'shuve isupa qui Ismael qquen inisiaña. Nane Na'su Chiga que ina'jen'choma pañamba in'jansi qui tsa'caen inisiaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tiseja tsampi'su cavayoa'caen injansuya tsu. Cca'indeccuma iyicca'yesi tsu ccane'qque tisema iyicca'ye'faya. Nane tise antian se'pi'ni'qque toya tsu tiseja tise'pa utufani can'jeña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tsonsi Agarja Na'su Chigama afapa su: “Chiga tsu atte'su.” Nane tayo Chigai'ccu condasepa tsu tiseja su: “Chiga ñama atte'ni'qque gi toya canse.” ");
INSERT INTO conNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tsa'caen tsonsi tsu tsa tsa'ccu posoma inisian'fa Lajairoi poso, “Ñama atte'su Cansian Chigambe poso” qquen su'chove. Tsa posoja Cadesne Beredni ja'je'cho enttingeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Can'jemba Agar Abram du'shuve isusi Abramjan tisema inisian Ismaelve. ");
INSERT INTO conNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramjan ochenta y seis canqque'fave an'bian'ni tsu Ismaelma isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tsomba Abram noventa y nueve canqque'fave an'bian'ni Na'su Chigaja tisenga attiamba su: —Ña gi Chiga Osha'choma Oshacho'cho. Ña in'janqquia'caen shacave me'cho canseja. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tsa'caen cansesi gi ñajan quei'ccu injanccopa tsain'bitssi dushundeccuve quei'ccu atapoeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tsama pañamba Abramjan andenga puntssan ccui. Puntssan ccui'ni'qque toya tsu Chigaja afapa su: ");
INSERT INTO conNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Ña quei'ccu injanccoya'choja qquen tsu: Que qui tsain'bitssi aindeccumbe quitsaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tsa'cansi tsu ti'tsse Abram qquen quema su'faya'bi. Tsa'ma ja'ñonda tsu quema inisian'faya Abrahamme. Nane tsain'bitssi aindeccumbe yayasi tsu tsa'caen su'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ñoñaña gi que dutssiyendeccu tsain'bitsse atapa'faya'chove. Nane tise'pa'ye tsu nasundeccuja sombopa tsain'bio andema manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ñajan quei'ccu injanccopa gi tsangae que Chigave da. Toya'caen que omba'su dutssiyendeccui'ccu injanccopa gi tsangae tise'pa Chigave daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Quenga, toya'caen poiyi'cco tsendeccunga gi pa'cco Canaán andema afeya. Nane que'i ja'ño can'jen'cho andema gi tsangae que'inga afepa tsangae que'i Chigave daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Toya'caen tsu Chigaja Abrahamma su: —Tsa'ma queja, poiyi'cco que omba'su dushundeccu'qque ña que'i'ccu injancco'fa'choma injan'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nane qquen tsu ña que'i'ccu injanccopa manda'choja: Poiyi'cco tsandiendeccu tsu que'suja tise'pa ttonoma chhiyi tevaen'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nane shondusu'cho tsutopa'su ttonoma tsu chattuya'cho ña que'i'ccu injancco'fa'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ja'ño ashaemba tsangae tsu tsa'caen tsoña'cho. Poi tsandie du'shuma tsu que'i'suja tsa'caen chhiyi tevaeña'cho ocho a'tave nepisi. Nane ñoa'me que'i aindeccu toya'caen faesunima chavapa sema'suve an'biandeccumbe du'shuma'qque tsu tsa'caen tsoña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Poiyi'ccoma tsu fae'ngatsse tsa'caen tsoña'cho. Tsa'caen tevaemba qui pa'cco que'i canse'cho canqque'fa ña que'i'ccu injancco'fa'choma injan'jen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tsa'ma majan tsa'caen tevaembi'choaja que'i'ccu can'jeñe oshambi. Nane ña que'i'ccu injancco'fa'choma chi'gapa tsu que'i'ccu can'jeñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Toya'caen tsu Chigaja Abrahamma su: —Que pushe Saraima'qque ti'tsse tsa'caen su'faya'bi. Nane ja'ño ashaemba tsangae tsu Sarave inisian'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ñajan tisema ñotsse tsoñe in'jamba gi du'shuve tisenga afeya. Ju, ñoa'me gi tisema ñotsse tsoña. Tise tsu tsain'bitssi aindeccumbe mamaña. Nane tise omba'su dushundeccu tsu tsain'bio ande'su nasundeccuve dapa manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tsonsi Abrahamjan ccase andenga puntssan ccuipa qquen asi'ttaemba feña: “¿Oshaya ti fae tsandie cien canqque'fave an'bian'cho du'shuve an'biañe? Toya'caen ¿oshaya ti Sara'qque noventa canqque'fave an'bian'cho du'shuve isuye'ta?” ");
INSERT INTO conNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tsa'caen asi'ttaemba Chiganga su: —Isha tsu Ismaelja que ñotsse tsoña'choi'ccu canseya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tsa'caen susi Chigaja su: —Tsa'ma Ñanda gi su que pushe Sarata tsu tsandie du'shuve isuya. Tsonsi qui inisiaña Isaacve. Tisei'ccu gi Ña quei'ccu injancco'fa'choma a'tatsse canjeña. Toya'caen tise dutssiyendeccui'ccu gi tsangae tsama canjeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Toya'caen tayo gi paña que Ismaelne in'jan'choma. Tsane'qque gi ñotsse tsoña. Tisei'ccu'qque gi tsain'bitssi du'shuve atapoeña. Tise omba'su dutssiyendeccu'qque tsain'bitssi'faya tsu. Nane Ismael tsu doce ti'tsse'tssia nasundeccumbe quitsaya. Tisei'ccu gi fae rande ande'su aindeccuve atapoeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tsa'ma ña injancco'fa'chomanda gi Isaac dushundeccui'ccuyi injan'jeña. Nane fae canqque'fa pasambi'te tsu Saraja tsandie du'shu Isaacve isuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Chigaja tsa'caen Abrahamnga supa ansundin ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ansundin jasi tsequi a'ta Abraham poiyi'cco tise tsaoni can'jen'cho tsandiendeccumbe shondusu'cho tsutopa'su ttonoma cha'ttu. Nane tise du'shu Ismael, poiyi'cco tisei'ccu can'jen'cho semasundeccuma'qque Chiga suqquia'caen tsa'caen chhiyitevaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham noventa y nueve canqque'fave an'biansi tsa'caen tisu ttonoma chhiyitevaenge. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tise du'shu, Ismael, trece canqque'fave an'biansi ttonoma chhiyitevaenge. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nane fae a'ta tsu yaya Abraham, tise du'shu Ismael'qque fae'ngae ttonoma chhiyitevaenge'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Toya'caen tise tsaoni isu'chondeccu, cca'inima chavasi can'jendeccu'qque tsequi a'tayi tise'pa na'sui'ccu fae'ngae ttonoma chhiyitevaenge'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Tsonsi Na'su Chiga ccase Abrahamnga attian Mamrembe roble quini'ccoccuni. Enttinge a'ta a'que'osi Abrahamjan tise carpa tsa'o'su sombo'ttini dyai. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Dyaipa asuccocamba tres tsandiema atte tse'tti pporotsse ccutsu'fa'choma. Tise'pama attepa carpa'ye butto jangipa chigambiañe catse. Buttopa japa tise'panga catsepa tise tsovema andenga puntssamba ccuipa ");
INSERT INTO conNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","su: —Ña na'su, chigáne va'tti re'riccone dyaiccaja. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Quema shondo'su gi. Que in'jan'ninda gi tsa'ccuve iñajamba afeya que'i tsu'ttema cashiye. Cashipa quini'cco'su tumbianccuni dyaicca'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Que'i tsa'caen ño'fa dyai'ninda gi panma iya cuintsu que'i an tteppuye. Nane va quema shondo'su tsaoni jipa qui tsa'caen an tteppupa ti'tsse jaya. Tsa'caen susi tise'paja Abrahamnga su'fa: —Ñotssi tsu. Tsa'caen tsonjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tsonsi Abrahamjan carpanga ca'nimba Sarama su: —Uta'tsseyi ñotssia harinama cuarenta librave isupa panme ñoñajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tsa'caen supa Abrahamjan vaura ttuccuni buttopa japa bove ñotssia vaura du'shuma indipa tise'be sema'sunga afe cuintsu fi'ttipa sho'ccoeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tsonsi sho'ccoen nanimba chocho, quesoma'qque ipa pasiasundeccunga afe vaura nai'ccu añe. Tsendeccu quini'cco tumbianccuni dyaipa an'jen'fasi Abrahamjan tise'pama shondo'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","An nanimba Abrahamnga su'fa: —¿Mani tsu que pushe Saraja? Iñajampañasi Abrahamjan su: —Carpani tsu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tsonsi fae'cco tsendeccu'suja su: —Fae canqque'fa panshansi gi ccase queni jiya. Ña jisi tsu que pushe Saraja tsandie du'shuve isuya. Tsa'caen su'je'choma Saraja Abraham sepaccofae a'tutsse carpani pañá ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nane Abrahamjan, Sara'qque coenza. Saraja coenza ccasheve dapa tayo samboen'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tsa'camba Saraja pañamba feña. Nane feñamba asi'ttaen: “¿Ñoa'me ti gi tsa'caen avujaya? Ña, ña tsa'ndu'qque coenzata, ¿ma'caen?” ");
INSERT INTO conNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tsa'ma Na'su Chigaja tise asi'ttaen'choma in'jamba Abrahamnga su: —¿Micomba tsu Saraja feñamba “¿Ñoa'me ti gi coenza ccasheve dapa du'shuve isuya?” qquen su? ");
INSERT INTO conNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Oshambi ti Na'su Chigaja osha'choma oshapa tsa'caen tsoñe? Nane ñoa'me fae canqque'fa pasasi ña ccase jisi tsu Saraja tsandie du'shuve isuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tsa'caen susi pañamba Saraja dyopa a'tiemba su: —Me'in, feñambi gi. Tsa'ma Na'su Chigaja su: —Atte gi que feña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tsa'caen condasepa an nanimba pasiasundeccu jangipa Sodoma canqqueni jaye ashaen'fa. Abrahamjan camoeñe in'jamba re'riccoe tise'pai'ccu fae'ngae ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tsonsi Na'su Chigaja qquen asi'ttaen: “Ñotssi tsu ña tsoña'choma Abrahamnga condaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nane tiseja tsain'bitssi a'ive atapasi joccapitssia aindeccuve tsu da'faya. Tisei'ccu gi poi ande'su aindeccuma ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nane tisema gi in'jan cuintsu tise mandasi tise dushundeccu, tise omba'su dutssiyendeccu'qque ña su'choma pañamba ñotsse canse'faye. Tsa'caen tson'ninda gi pa'cco ña su'choma tsoña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tsa'caen asi'ttaemba Na'su Chigaja su: —Sodoma canqque'su aindeccu, Gomorra canqque'su aindeccu'qque ñoa'me dyo'oe egae tsincon'fa. Tsa'caen tsincon'choma poi ande'su aindeccu in'jamba condasecco'fasi gi paña. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tsane gi japa atesuya tise'pa ña pañaqquia'caen tsincon'choma. Attepa gi in'jaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tsa'caen su'je'ni tsa faesu dos pasiasundeccuja Sodomani jaye ja'fa. Tsa'ma Abrahamjan toya Na'su Chigai'ccu ccutsupa ");
INSERT INTO conNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ti'tsse catsepa iñajampaña: —¿Ñoa'me ti qui egae tsinconsundeccui'ccu fae'ngae ño'andeccuma'qque fi'ttiya? ");
INSERT INTO conNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Nane cincuenta ño'andeccu tseni can'jen'ni'qque ti qui poiyi'cco tsa canqquesundeccuma fi'ttiya? Tsambi'ta, ¿ño'andeccuma ccushaeñe ti qui antteya? ");
INSERT INTO conNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ñoa'me qui oshambi tsa'caen ño'andeccuma egae tsinconsundeccui'ccu fae'ngae fi'ttiye. Nane tsendeccuja fae'ngae egae tsincon'fambi. Me'in, tsa'caen qui tsoña'bi. Nane queja poi aindeccu injama'choma somboen'su, ¿poiyi'ccoma ñotsse in'jan'da ti qui ñotsse tsoña? ");
INSERT INTO conNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Pañamba Na'suja su: —Cincuenta ño'andeccuma tseni atte'ta gi poiyi'cco tsa canqque'su aindeccuma ccushaeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Toya'caen tsu Abrahamjan su: —Queja Chiga. Ñajan aqquia a'i gi. Tsa'ma ña injanga qquen afasi ñama iyicca'yejama. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","¿Cinco ño'andeccu cincuentave nepiya'cho shaca'ni'qque ti qui poiyi'cco tsa canqque'suma fi'ttiya? Tsonsi Na'suja su: —Cuarenta y cinco ño'andeccuma atte'ta gi poiyi'ccoma ccushaeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Toya'caen Abrahamjan su: —Da, ¿cuarenta ño'andeccuma tseni atte'ta–? Tsonsi Na'suja su: —Cuarenta can'jen'ninda gi antteya. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ccase Abrahamjan su: —Ñama iyicca'yejama. Tsa'ma, ¿aqquia treintaveyi atte'ta–? Na'suja su: —Treintave atte'ta gi antteya. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ti'tsse tsu Abrahamjan su: —Ñoa'me opa gi ya'caen ña Na'suma afaye. Tsa'ma, ¿veinteveyi atte'ta ti qui antteya? Na'suja su: —Ju, veinteveyi atte'ta gi tsa canqque'su a'ima fi'ttiya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Toya'caen Abrahamjan su: —Chigáne, ña Na'su, ñama iyicca'yejama. Tsa'ma ti'tsse fae seyi gi afaya. ¿Mingae qui tsoña aqquia diez ño'andeccuma atte'ta? Tsonsi Na'suja su: —Nane ñoa'me ño'andeccuma diezve atte'ta gi tsa canqquesundeccuma fi'ttiya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Na'suja tsa'caen Abrahami'ccu afa nanimba ja. Abraham'qque toequi tise carpa tsaoni shanda. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tayo cosesi tsa dos Chigama sefacconi'su shondosundeccuja pasiasundeqquia'caen Sodoma canqquenga nepi'fa. Lot, Abraham antianmbe du'shu, tseni can'jemba canqque ttuccu sombo'tti'su atandunduni dyai. Dyaipa pasiasundeccuma attepa jangipa tise'pama cachui'su ja. Cachuipa tise camba'juma andenga puntssamba chigambiamba ");
INSERT INTO conNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","qquen su: —Nasundeccu, chigáne ña tsaoni ji'faja. Tseni que'i tsu'ttema cashipa, ana qquendyapa qui tu'i sinte'yi ccase tsaiqui'ye ja'faya. Tsa'ma tise'paja su'fa: —Me'in. Vani atandundunga gi ana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tsa'caen susi Lot toya ti'tsse iñajansi tsu japa Lot tsa'onga ca'ni'fa. Tseni ca'ni'fasi Lotja anqque'suve sho'ccoemba cupana'cco me'choa panme matssamba tise'pama o'fian. O'fiansi an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tsomba toya anañe ccuimbi'te tsu poiyi'cco tsa Sodoma'su tsandiendeccu, nane chu'a, coenza'qque Lot tsa'oma shoquendipa ");
INSERT INTO conNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","qquen fundondo'e Lotma afaye ashaen'fa: —¿Mani tsu tsa dos tsandie, que tsa'onga ja'ño cose ca'ni'chondeccuja? Tise'pama somboenjan ingi tise'pai'ccu ccui'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tsonsi Lotja afaye sombopa sombo'ttima ñotsse picco cca'i ca'nisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tsa'caen sombopa su: —Chigáne ña amigondeccu, tsa'caen egae tson'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nane an'bian gi dos onque'ngeve, toya tsandiema atesumbindeqquiama. Tsendeccuma gi somboemba que'inga afeya cuintsu que'i in'janqquia'caen tise'pai'ccu tsoñe. Tsa'ma va tsandiendeccuma pporaen'fajama. Nane ñajan tise'pama coira'su gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tsa'ma aindeccuja su'fa: —¡Joqquitssija! Queja vani'sumbi qui. ¿Ma'caen qui ingima manda'je? Ja'ño gi tise'pama tsoñe in'janqquia'caen quema ti'tsse tsa'caen tson'faya. Tse'faei'ccuyi Lotma dañoñe ashaemba tsa'o sombo'ttinga catse'fa u'ccapa ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tsa'ma pasiasundeccuja sombo'tti'ye yasapa Lotma indipa tsa'onga ca'niamba ccushaen. Tisema ca'niamba sombo'ttima piccopa ");
INSERT INTO conNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","aindeccuma binime tson'fa. Tsa'caen poiyi'cco, chu'a, coenzandeccu'qque binime dapa sombo'ttima atteye oshambipa quimbipa antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tsonsi pasiasundeccu Lotma iñajampaña: —¿Faesu que antiandeccuta ti vani can'jen'fa? Nane que dutssiyendeccu, que onquengendeccu, dushundeccu, toya'caen poiyi'cco que'imbema angapa vane joqquitssipa biani jaja'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ñoa'me gi va canqquema sefaen catiya. Nane va canqque'su aindeccu tsain'bitsse egae tsincon'fasi tsu Na'su Chigaja shacama isuqquia'caen tise'pama sefaen catiya'chove ingima manda. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tsa'caen susi Lotja tise dusundeccunga japa conda. Nane tayo tsu antteye su cuintsu tsendeccu tise onquengendeccuma pusheye. Tise'pama su: —Jangipa va'ttie joqquitssipa ja'faja. Ñoa'me tsu Na'su Chiga va canqquema sefaen catiye tson'jen. Tsa'ma tise dusundeccu pañambipa feña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tayo a'taye tson'jensi sefacconi'su shondosundeccuja Lotma quian'me su'fa: —Uta'tsseyi jangipa que pushe, que onquengendeccuma'qque angapa ja'faja va canqque'su aindeccui'ccu fae'ngae pasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tsa'ma Lot jaye in'jambiqquia'caen vasia've ñoña'jensi sefacconi'su shondosundeccu tise tivema indipa qquitssapa somboen'fa. Nane Na'su Chiga tisema in'jamba mende'ye. Toya'caen Lot pushe, tise onquengendeccuma'qque qquitssapa somboen'fa tise'pama ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tsomba canqque'ye somboemba sefacconi'su shondosundeccu tise'pama su'fa: —Buttopa jaja'faja tisuma ccushaeñe. Sepacconima can'fajama. Ni va sinjunccuni can'jen'fajama. Nane ccotta'cconga jaja'faja tisuma ccushaeñe in'jan'da. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tsa'ma Lotja su: —Me'in, nasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Que'i ñama ñotsse tsomba mende'yepa ccushaen'fa. Tsa'ma oshambi gi ccotta'cconga buttoye. Nane ña toya nepimbi'te Chiga Sodomama sefaen cati'ninda gi paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Que can'faja. Joni tsu ñoa'me chipiri canqque. Biambi'cco tsu. Tseni gi buttopa nepiye osha tisuma ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tsonsi fae'cco shondo'su tsu su: —Quema pañamba gi tsa'caen antte. Tsa, que su'cho canqquema sefaen catiya'bi gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Uta'tsseyi tseni japa ca'nijan. Nane que toya tseni nepimbi'ta Na'su Chiga mandaqquia'caen tsoñe osha'fambi gi. Tsa canqqueja chipirisi tsu inisian'fa Zoarve. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Coejechiga tayo sombosi tsu Lotja Zoarni nepi. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tseni nepisi tsu Na'su Chigaja unjima tuiñaqquia'caen si'ngema asufrei'ccu amppian moe Sodoma toya'caen Gomorra canqquenga. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tsa'caen ju'rusi tsu tsa canqquema sefaen catipa tseni can'jensundeccuma'qque fitti'tti. Nane poiyi'cco majan tsa Jordán na'en sinjunccuni can'jen'da tsu pa'fa. Osha'cho sho'yoqque'su'qque tsu pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tsa'ma Lot pushe Lotma omboe jiñamba sepacconima piyicamba ansimeñi da ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ccaqui a'ta sinte'yi Abraham ccase tise Na'su Chigai'ccu ccutsupa condase'je'ni japa ");
INSERT INTO conNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","can Jordán na'en'su sinjunccunima, toya'caen Sodoma, Gomorranima. Camba onfen'bama atte. Nane pa'cco sinjunccu tsu si'nge ju'ruqquia'caen oro'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tsa'caen tsu Chigaja tsa Jordán na'en sinjunccu'su canqquema sefaen cati. Abraham antianmbe du'shu Lot tseni can'jen'choma Na'su Chigaja Abrahamma in'jamba Lotma ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Omboe Lotja dyojo ti'tsse Zoarni can'jeñe. Tsa'caen dyojopa ccotta'cconi japa tise dos onquengendeccui'ccu tseni fattocco changoni can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Can'jemba fae a'ta sheshe'yeja tise que'ttenga su: —Ingi yayaja ñoa'me coenza ccashe'yeve da. Toya'caen vani me'i'on tsu majan ingima pushesi du'shuma isuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tsa'camba jinge tse'tse'pama cui'ñamba yayama ccusiañe cuintsu ingija tisei'ccu ccuipa du'shuve isuye ingi aindeccu sefasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tsequi cose tise yayanga tse'tse'pama cui'ñamba ccusiamba sheshe'yeja tise yayai'ccu ccui. Tise yayaja ñoa'me ccusipa atesumbi tise ccui'cho ni tise jangi'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ccaqui a'ta sheshe'yeja tise que'ttenga su: —Que canjan. Cose ña yayai'ccu ccuiqquia'caen qui ja'ño cose ccase tisema tse'tse'pai'ccu ccusiaña'cho que'qque tisei'ccu ccuipa du'shuve isuye ingi aindeccu sefasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tsequi cose'qque ccase tise yayanga tse'tse'pama cui'ñamba ccusian'fa. Ccusiamba que'tte tsu tise yayai'ccu ccui. Tsa'ma tise yayaja ñoa'me ccusipa atesumbi tise ccui'cho ni tise jangi'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tsa'caen tsomba Lot dos onquengendeccu surie da'fa tise'pa yayambeyi. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Sheshe'yeja tsandie du'shuve isusi tisema inisian'fa Moabve. Tsambe omba'su dutssiyendeccu tsu ja'ño can'jen'cho moabitandeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Toya'caen que'tte'ye'qque tsandie du'shuve isusi tisema inisian'fa Ben-amime. Tsambe omba'su dutssiyendeccu tsu ja'ño can'jen'cho amonitandeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Tsonsi Abraham tise can'jen'cho'ye sombopa Néguev andeni ja. Tseni japa Gerar canqqueni ca'nimba can'jen. Gerar tsu Cades canqque, Shur canqque enttingeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Tseni can'jemba Abrahamjan tise pushe Sarama tise que'tte qquen poiyi'cconga conda. Tsa'caen condasi tsa canqque'su na'su Abimelecja manda cuintsu Sarama isi tise pusheve daye. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tsa'ma tsa'caen tsomba cosesi Abimelecja anamba ayo'o. Ayo'osi Chiga tisenga attiamba su: “Queja paye qui tson'jen. Nane que i'cho pushesuja faesumbe pushe tsu.” ");
INSERT INTO conNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tsa'ma Abimelec toya Sarai'ccu ccuimbipa Chiganga su: “Ña Na'su, ¿queta ti qui egae tsincombi'choama fi'ttiya? ");
INSERT INTO conNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham tsu su tsa pushesuja tise que'tte. Pushesu'qque Abrahamjan tise quindya qquen tsu su. Tsa'caen su'fasi gi afopoembi qquen in'jamba atesumbipa pushesuma i. Tsa'ma egae tsincombi qquen gi asi'ttaen.” ");
INSERT INTO conNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tsonsi Chiga ayo'oni tisema su: “In'jan gi queja atesumbipa tsa'caen tson. Tsa'cansi gi que injama'choma in'jaemba se'pi que tisei'ccu ccuipa ñama egae tsinconsa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tsa'ma ja'ño tsa pushesuma tise tsa'ndunga afeja. Nane tise tsa'nduja ñane afa'su tsu. Tise que'ine ñama iñajan'ninda qui ccusha'faya. Tsa'ma tise pushema afembi'ta qui ñoa'me que, que aindeccu'qque pa'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tsa'caen ayo'opa sinte'yi jangipa Abimelecja poiyi'cco tisema shondosundeccuma ttu'sepa pa'tssi tise ayo'o'choma conda. Tsama pañamba poiyi'cco dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Omboe Abimelecja Abrahamma ttu'sepa su: —¿Mingae qui inginga tson? ¿Jongoesui'ccu gi quema egae tsonsi qui tsa'caen ñama tson cuintsu va egae tsincon'cho ñanga, ña aindeccunga'qque shacave daye? Nane ñoa'me tsa'caen faesunga tsoñe ega tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Jongoesu qquen asi'ttaemba qui ingima tsa'caen tson? Tsa'caen tsu Abimelecja Abrahamma su. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tsonsi Abrahamjan su: —Ñajan ‘Vani'su a'i Chigave in'jambipa ñama fi'ttipa ña pushema itsa'faya’ qquen in'jamba gi tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tsa'ma afopoembi gi. Ñoa'me tsu tiseja ña que'tte. Nane ña yaya onque'nge tsu. Tsa'ma ña mamambembi. Tsa'cansi gi tisema pusheye osha. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Toya'caen Chiga mandasi ña yaya tsaone sombopa cca'tti cca'tti jacamba gi tisema su cuintsu mani jacan'an'qque ñajan tise quindya qquen suye. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tsonsi Abimelecja Abrahamnga tise pushe Sarama afe. Toya'caen tsu oveja, vaura, sema'su tsandiendeccu, sema'su pushesundeccuma'qque Abrahamnga aqquia afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Afepa su: —Que canjan pa'cco ña andema. Ma'ttima ñotssiave atte'ta tseni can'jenjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Toya'caen Saranga su: —Ña que tsa'ndunga afe'cho tsu mil totoacori corifin'dive bare. Tsa'caen afepa gi poiyi'cco quei'ccu jacansundeccunga canjaen queja ñotssia. Nane quema afaseye osha'fambi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Tsonsi Abrahamjan Abimelecne Chigama iñajan. Iñajansi Chigaja Abimelec, tise pushema'qque ccushaen. Poiyi'cco tise'pambe sema'su pushesundeccuma'qque ccushaen cuintsu ccase surie da'je'faye. Nane Abimelec Sarama tsa'caen itsasi tsu Na'su Chigaja poiyi'cco tseni'su pushesundeccuma pporaen cuintsu surive dambe'yi canse'faye. Tsa'ma ccushaensi ccase surie da'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Na'su Chiga Abrahamnga suqquia'caen Sarama pporaen cuintsu tise suqquia'caen daye. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tsa'caen tsonsi surie dapa tsandie du'shuve isu. Nane Abraham tayo coenzasi tsu Saraja tise'be du'shuve isu. Chiga su'cho a'ta tsu tsama isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sara isusi Abraham tise dutssi'yema attepa Isaacve inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Toya'caen du'shu ocho a'tave an'bian'ni tsu Abrahamjan Chiga mandaqquia'caen tise du'shumbe shondusu'cho ttonoma chhiyitevaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham cien canqque'fave an'bian'ni tsa'caen Isaacma isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tsonsi Saraja asi'ttaen: “Chiga ñama in'jaensi gi avujapa feña. Nane poiyi'cco majan ña du'shuma isu'chone paña'da tsu ñai'ccu fae'ngae feña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Majan ya'caen tson'chove paña'choecan'da tsu Abrahamnga ‘Saraja isuye oshambi’ qquen suye'can. Tsa'ma tiseja coenza ccashe'yeve dasi gi tsandie du'shuma tisenga afe.” ");
INSERT INTO conNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Du'shu Isaacja coemba chochoma antte. Chochoma antte'cho a'ta Abrahamjan poiyi'cco a'ima ttu'sepa boñasi fiestaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tsa'ma Abraham faesu dutssi'ye, tsa egipto'su pushesu Agar du'shu, Isaacma fe'ñasi Saraja attepa injama'choni iyicca'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Iyicca'yepa Abrahamnga su: “Va sema'su pushesu, tise du'shuma'qque joqquitssianjan. Nane va sema'su pushesumbe du'shuja fae'ngae ña du'shu Isaacui'ccu dutssi'ye osha'choma isuqquia'caen isuya'bi.” ");
INSERT INTO conNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tsama pañamba Abrahamjan ñoa'me ñombi'ye. Nane Ismael'qque tise dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tsa'ma Chigaja tisema su: “Ñombi'yejama que du'shune ni que sema'su pushesune. Tsa'ma Sara in'jamba iñajanqquia'caen tsonjan. Ñoa'me Isaacne que omba'su dutssiyendeccuve atapasi gi agattoya. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Toya'caen sema'su pushesumbe du'shu'qque quembesi gi tise omba'su dutssiyendeccuve tsain'bitsse atapoensi tise'pa'qque joccapitssia a'ive da'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Chiga tsa'caen susi ccaqui a'ta sinte'yi Abrahamjan panma Agarnga afepa ttono botiyanga'qque tsa'ccuma on'boemba tise opipa'chonga ottaen. Tsomba du'shui'ccu tisema joqquitssian moe tise tsa'o'ye. Tsa'caen joqquitssiangepa Agarja Beerseba'su a'i menia jacan. Mani jaya'chove atesumbipa injanga jacan. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ttono botiyani an'bian'cho tsa'ccuma sefaemba tsaqquie'supa Agarja du'shuma cati quini'ccosi tsosiccunga. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Catipa biaccaccatsse japa dyai, du'shu paye tson'jen'choma caña'jeñe in'jambipa. Du'shu i'nañe ashaensi ");
INSERT INTO conNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Chigaja pañamba tisema sefacconi'su shondo'suma moe. Sefaccone tsu Chigama shondo'suja Agarma ttu'sepa su: “¿Micomba qui tsa'caen dyai, Agar? Dyombe canjan. Tayo tsu Chigaja paña du'shu tseni ccuipa ina'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Jangipa du'shunga japa tise tivema indipa tisema jangianjan. Ñoa'me gi tisema ccushaemba fuiteya cuintsu tise dutssiyendeccu joccapitssia aindeccuve da'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tsa'caen supa Chigaja Agarma canjaen tsa'ccu posoma. Tseni japa ttono botiyanga tsa'ccuma on'boen. Toya'caen Ismaelma cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tise suqquia'caen Chigaja du'shu Ismaelma fuite. Fuitesi quin'anme dapa a'i menia can'jen. Battittianccui'ccu battiañe ñotsse atesupa canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nane Parán a'i menia can'jemba tise mama anttesi egipto'su pushesuma pushe. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tsa'caen tsonsi Abimelec, tise sundaro na'su, Ficoli'ccu Abrahamni can'su jipa tisema chigambiamba su: —Chiga quema fuite'je'choma gi poiyi'cco in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tsa'cansi ingi vani can'jensi Chiga pa'ccoma paña'jen'ninda, ingi'ccu fae'ngae injancco'faja. Chigáne, ñama egae tsonjama, ni ña dushundeccuma, ni ña omba'su dutssiyendeccuma'qque egae tsonjama. Nane ña quema ñotsse tsonqquia'caen ccane'qque ñama, ña ande'su a'ima'qque ñotsse tsonjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tsonsi Abrahamjan su: —Chiga caña'jen qquen in'jamba gi tsa'caen tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tsa'ma tsa'caen condasepa Abraham tise tsa'ccu posone Abimelecnga conda. Nane Abrahambema tsu Abimelecmbe semasundeccuja itsa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Pañamba Abimelecja su: —Ja'ño gi tsane me'ttia'ye paña. Nane que ñanga condambisi gi atesumbe can'jen. Atesumbi gi majan tsu tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tsonsi Abraham ovejandeccuma vaurandeccuma'qque i'ngapa Abimelecnga afe. Afepa tsequi a'ta tsu fae'ngae injancco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Tsa'ma Abraham siete oveja pushema tsa afe'cho'sumbe cca'ttinga attufaemba ccutsian. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ovejama attepa Abimelecja iñajampaña: —¿Jongoesie qui tsa siete ovejama attufaemba ccutsian? ");
INSERT INTO conNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iñajampañasi Abrahamjan su: —Ña afesi va siete oveja pushema isu'ta qui va posoja ña changoemba an'bian'cho qquen canjaeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tseni tsa'caen tsomba tsa posomajan inisian'fa Beersebave. Nane tseni fae'ngae injanccopa “injancco'fa'cho poso” qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tsa'caen Beersebani Abrahami'ccu fae'ngae injanccopa Abimelec, tise sundaro na'su, Ficol'qque toequi ja'fa filisteo andeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ja'fasi Abrahamjan tseni tamarisco quini'jima jon. Quini'jima jomba Tsangae Canse'cho Na'su Chiga Quitsama iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Bo'tssingae tsu Abrahamjan filisteo andeni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Omboe Chigaja Abraham tise've in'jan'chove atesuye in'jamba mandacan. Tsa'caen in'jamba tise inisei'ccu tisema ttu'sesi Abrahamjan su: —Vani gi can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tsonsi Chigaja su: —Que dutssi'ye fae'ccoa Isaacma qui ñotsse in'jan. Tisema angapa Moriah andeni jaja. Tseni japa ña quema canjaen'cho ccotta'cconga ansundepa que du'shuma fi'ttipa oqueja ñanga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ccaqui a'ta sinte'yi Abrahamjan jangipa tise boronga ñoñamba Chiga tisema conda'cho andeni ja. Tisei'ccu tsu dos tise'be semasundeccu, toya'caen tise dutssi'ye Isaac'qque ja'fa. Si'tsima'qque anga'fa Chiganga afe'choma oqueye. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tres a'ta japa Abrahamjan bianima camba tsesu ccotta'ccoma atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Attepa tise'be semasundeccuma su: —Vani boroi'ccu can'jen'faja. Ña, ña du'shui'ccu gi ti'tsse joccani japa Chigama iñajamba toequi ji'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tsa'caen supa Abrahamjan Chiganga afe'choma oque'je'cho si'tsima isupa Isaacnga afe cuintsu anduye. Tsomba si'ngema, chhichhi'ccoma'qque isupa fae'ngae Isaacui'ccu ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Japa Isaacja tise yayama iñajampaña: —¡Yaya! Abrahamjan su: —¿Jongoesie qui in'jan ña dutssi'ye? Isaacja su: —Que canjan, si'tsi, si'ngema'qque gi an'bian'fa. Tsa'ma, ¿mani tsu oveja du'shu ingi oquepa Chiganga afeye? ");
INSERT INTO conNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iñajampañasi Abrahamjan su: —Jaricho, Chiga Quitsa tsu ovejama afeya cuintsu ingi tsama oquepa tisenga afeya. Tsa'caen supa fae'ngae ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tsomba Chiga su'cho oque'jeni nepipa Abrahamjan oque'je'chove ñoñamba si'tsima'qque tsanga ñoña ccuiña. Tsa'caen ñoñamba tise dutssi'ye Isaacma tandamba oque'je'chonga ccuiña si'tsi ombanga. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ccuiñamba chhichhi'ccoma isu tise dutssi'yema fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tsa'ma tse'faei'ccuyi Na'su Chigama sefacconi'su shondo'su sefaccone ttu'sepa su: —¡Abraham! ¡Abraham! —Vani gi can'jen, —qquen tsu Abrahamjan su. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tsonsi sefacconi'su shondo'suja se'pipa su: —Du'shuma pporaenjama. Ja'ño gi atesu que Chigave ñotsse in'jan'choma. Nane Chigama pañamba qui que du'shu fae'ccoama se'pimbi ñanga afe'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tsa'caen susi Abraham piyicamba atte oveja quitsa'yema. Nane tsaja tise can'cho quini'ccosinga indiyepa ccutsu. Attepa japa ovejama indipa fi'tti. Fi'ttipa oque o'raemba Chiganga afe. Nane tise du'shuma ccushaen'su ovejama tsa'caen fi'ttipa afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Omboe Abrahamjan tsa oque'je'nima inisian “Jongoesuve shaca'ninda Chigaja afeya.” Nane toya tsu a'ija su'fa: “Jongoesuve shaca'ninda tise ccotta'ccone tsu Na'su Chigaja afeya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tsonsi ccase tsu Na'su Chigama sefacconi'su shondo'suja sefaccone Abrahamma ");
INSERT INTO conNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ttu'se: —Na'su Chigaja su: ‘Queja tsa'caen tsomba que du'shu fae'ccoama'qque se'pimbe'yi ñanga afesi gi quema ñotsse tsoña. Nane tisu injama'choi'ccu in'jamba gi tsa'caen tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Que omba'su dutssiyendeccuma gi tsain'bitsse ñotsse tsoña. Nane tise'pama gi atapoeña cuintsu sefacconi'su o'fema agattoye oshambiqquia'caen, marni'su sisipafo'choma agattoye oshambiqquia'caen, tise'pama'qque agattoye osha'fambiye. Toya'caen tise'pama egae tsonsundeccuma'qque tsu patsu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Que omba'su dutssiyendeccu ñama ñotsse paña'ninda gi tise'pai'ccu poi ande'su aindeccuma ñotsse tsoña.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tsama pañamba Abrahamjan Isaacui'ccu toequi tise'be semasundeccuma catini shanda. Shandapa poiyi'cco fae'ngae Beersebani toequi japa Abrahamjan ti'tsse tseni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Tsa'caen tsomba omboe Abrahamjan paña tise quinshin Nacorne. Nacor pushe Milca'qque dushundeccuve an'bian'choma paña. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Nane coenza tsu Uz. Tsambe quinshin tsu Buz toya'caen Kemuel. Kemuel tsu Aram quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ti'tsse omboe Milca faesu dushundeccu, Quesed, Hazo, Pildas, Jidlaf, toya'caen Betuelve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Tsa Betuel tsu Rebeca yaya. Nane Milca tsu Abraham quinshin Nacormbe ocho dutssiyendeccuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Toya'caen Nacor faesu pushesu Reúmai'ccu can'jemba faesu dushundeccuve an'bian: Teba, Gaham, Tahas, toya'caen Maaca. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saraja ciento veinte y siete canqque'fave an'biamba ");
INSERT INTO conNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Quiriat-arbani pa. Tsa Quiriat-arba tsu Canaán andeni'su Hebrón canqque. Sara pasi Abrahamjan ñombi'yepa i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tsa'caen i'namba omboe Abrahamjan pa'chombe ai'vo ccuine sombopa japa tsa ande'su hitita aindeccui'ccu condase: ");
INSERT INTO conNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Ñajan faesu ande'su que'i'ccu can'jemba gi asi'ttaen: Chigáne a'ima atuqque'su fattocco changoma ñanga chavaen'faja ña pushema tsanga a'tuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tsa'caen susi tsesu hitita aindeccuja su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Na'su, chigáne ingima pañajan. Queja ingi'ccu can'jemba qui ñoa'me Chiga in'jan'cho. Tsa'cansi mani in'jan'da que pushema a'tuja ingi atu'ttinga. Nane ingi bove ñotssia atu'ttinga a'tuja. Majañi'qque tsu quema se'pi'faya'bi que tsa'caen tsonsi. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tsonsi Abraham jangi ccutsupa hititandeccuma chigambiamba su: ");
INSERT INTO conNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","—Que'i ñoa'me vani ña pushema a'tuye in'jan'da chigáne ñambe afa'faja Efrón, tsa Zohar dutssi'yema. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Tisema afapa iñajan'faja cuintsu tiseja tsa Macpela fattocco changoma ñanga chavaeñe. Nane tise ande'su utufani tsu tsa fattocco changoja jin. Mi'nge'tsse iñajan'ninda gi tsa'caen afepoeña. Nane tsa'caen pa'ccoma afepoemba gi tsa fattocco changombe na'suve daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tse'i, hitita a'i, Efrón, tse'tti cca'indeccui'ccu fae'ngae can'jemba pañamba Abrahamma quian'me afa. Nane cuintsu poiyi'cco tise antiandeccu, canqque sombo'je'tti'ye panshansundeccu'qque tisema paña'faye tsu quian'me afapa su: ");
INSERT INTO conNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Isha, ña na'su. Aqquia gi quenga afeya va ande, toya'caen tsa ande'su fattocco changoma'qque. Poiyi'cco ña antiandeccu tsu ña su'choma pañamba in'jan'fa tansintsse su'chove. Toya'caen canqque sombo'tti'ye panshansundeccu'qque tsu pañamba tansintsse su'chove in'jan'fa. Tsa'cansi injanga tseni a'tuja que pushema. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tsa'ma Abrahamjan pañamba ccase tsa canqque'su aindeccuma chigambiamba ");
INSERT INTO conNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","poiyi'cco paña'jen'ni Efrónma su: —Chigáne ñama paña'faja. Quian'me gi quema iñajan cuintsu ande bare'cho corifin'dima isuye. Nane corifin'dima isusi gi omboe ña pushema tseni a'tuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tsonsi Efrón pañamba su: ");
INSERT INTO conNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Ña na'su, ñama pañajan. Va andeja aqquia cuatro ciento corifin'diveyi tsu bare. ¿Jongoesune gi tsa re'riccoa'ne panshaen afacco'faya? Tsa'cansi injanga tseni que pushema a'tuja. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tsa'caen susi poiyi'cco a'i caña'jen'ni Abrahamjan Efrón suqquia'cantsse corifin'dima afepoen. Nane chavaensundeccu agattoye in'janqquia'caen tsu corifin'dima agattopa afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tsa'caen chavasi tsu Efrón ande–tsa Mamre canqque jin'tti'su ande–nane Macpela fattocco chango, toya'caen ande, pa'cco tseni jincho quini'cco'qque– ");
INSERT INTO conNTpo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham andeve da. Abraham na'suve dasi tsu poi hititandeccu, canqque sombo'je'tti'ye panshansundeccu'qque pañamba tsa'caen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Tsa'caen chavapa Abrahamjan Sarama a'tu tsa Macpela fattocco changonga. Nane tsa fattocco chango tsu Mamre canqqueni chiga sombo'jefani. Tsa Mamre Canaán ande'su Hebrón canqque. ");
INSERT INTO conNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tsa'caen tsu Abrahamjan tsa ande, toya'caen tsa fattocco changoma an'bian, hititandeccuma chavapa. Tse'ttinga tsu tise'pa'su pa'chondeccuma atu'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na'su Chiga osha'choi'ccu tisema ñotsse tsonsi tsu Abrahamjan coenza ccashe'yeve dapa canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Tsa'caen dapa tsu tisema shondo'su ti'tsse coenzama ttu'se. Tsaja pa'cco tise tsa'o'suma, pa'cco tise an'bian'choma'qque coira'su tsu. Tisema ttu'sepa su: —Que tivei'ccu ña ttena'go tsosiccufama pporaemba ");
INSERT INTO conNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","tansintsse su'chove afaja que ña mandaqquia'caen tsoña'chove. Nane Na'su tsa sefacco, andema'qque agattoen'su Chiga paña'jen'ni tansintsse suja. Nane antteya'bi qui cuintsu ña dutssi'ye Isaac va ña can'jeni'su Canaán ande'su pushesuma pusheye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tsa'ma ñama isu'cho andeni japa ña antian'su pushesundeccu'su pushesuve tta'ttaja cuintsu tsama Isaac pusheye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tsa'caen mandasi shondo'suja su: —Pushesuma attesi jiye in'jambian'da ¿ma'caen gi tsoña? ¿Que dutssi'ye Isaacma ti gi angaya tsa que sombo'cho andeni? ");
INSERT INTO conNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tsonsi Abrahamjan su: —Isha, ¡ña dutssi'yema tseni angajama! ");
INSERT INTO conNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Na'su Chiga tsu quema o'tie tisema sefacconi'su shondo'suma moeña. Nane Sefacconi'su Na'su Chigaja ñama somboen ña yaya tsa'o'ye, ña antian ande'ye'qque. Ñama somboemba tsu ñoa'me su va andema afeye ña dushundeccunga. Tsa Chiga tsu tisema sefacconi'su shondo'suma quema o'tie moeña cuintsu in'jaensi tseni'su pushesuma iye ña dutssi'ye pusheve. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pushesuma attesi jiye chi'ga'ni'qque qui ccushaya va mandasi tsoña'chone. Tsa'ma ña dutssi'yema tseni angajama. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tsa'caen susi shondo'suja tise tivei'ccu tise na'su Abraham ttena'go tsosiccufama pporaen tise suqquia'caen ñoa'me tsoña qquen canjaeñe. Tsa'caen tsomba aya'fai'ccu pa'ccoma tsoña qquen tansintsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tsomba tse'i shondo'suja tise na'su an'bian'cho'su osha'cho ñotssia afeya'choma isupa chonga tise na'sumbe cameyoi'ccu sombopa ja Nacor can'jen'cho canqquenga. Tsa canqque tsu Mesopotamia ande'su canqque. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Bo'tssingae jacamba Nacor canqque utufanga nepisi tayo sime da. Nane tayo sime dasi tsu pushesundeccuja tsa'ccuve ichhoi'su ji'fa. Tseni nepipa shondo'suja manda ccuiña tise jacan'cho cameyondeccuma tsa'ccu poso jin'ttinga. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Manda ccuiñamba Chigama iñajan: “Na'su Chiga, ña na'su Abraham Chiga, ja'ño ñama fuitepa na'su Abrahamma ñotsse tsonjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Que canjan. Ñajan va poso jin'tti ccutsusi va canqque'su chu'a pushesundeccu tsu vani ji'faya tsa'ccuma ichhoiye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Antteja majan pushesu vani jisi, ‘Chigáne que tsoripama andiamba ñama cui'ñajan,’ qquen ña susi, ‘Cu'ija,’ qquen supa, ‘Toya'caen gi que cameyondeccuma'qque cui'ñaña,’ qquen su'ta, tsaya tsu que in'jan'cho pushesu quema shondo'su Isaac pusheve daya'cho. Que tsa'caen tsonsi gi in'jaña queja ñotsse tson ña na'su Abrahamnga.” ");
INSERT INTO conNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Toya tise Chigama iñajan'jen'ni tsu Rebecaja ji. Tise tsoripama opipa'chonga opipa ji. Nane Rebeca tsu Betuel onque'nge. Betuel tsu Abraham quinshin Nacor dutssi'ye. Tise mama tsu Nacor pushe Milca. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Pushesuja ñoa'me me'detssi tsu, toya tsandiema atesumbi'choa. Nane toya tsu majan tsandieyi'qque tisema pporaen'fambi. Jipa posonga andepa tise tsoripama ichhoi on'boemba sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Sombosi coenza shondo'suja butto catsepa su: —Chigáne ñanga cui'ñajan que tsoripa'su tsa'ccuma. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Pushesuja su: —Cu'ija ña na'su. Tsa'caen supa tse'faei'ccuyi tise tsoripama andiamba tivei'ccu indipa tsa'ccuma fiña cuintsu shondo'su cu'i'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Shondo'su cu'i nanisi tsu Rebecaja tisema su: —Toya'caen gi tsa'ccuma ichhoiya que cameyondeccuma cui'ñasi cuintsu tise'pa'qque tteppu'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tsa'caen supa tise tsoripa'su tsa'ccuma fiña cameyo cui'je'cho shavonga. Fiña ccutsiamba buttopa ccase posonga ande ti'tsse tsa'ccuma ichhoiye. Tsa'caen fechochoemba nanitsse cameyondeccuma cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Rebeca tsa'caen tsonsi coenza shondo'suja can'boen ccutsupa afambe'yi asi'ttaen Na'su Chiga ñoa'me tisema pañamba tsa'caen antte qquen in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Cameyondeccu cu'i nanisi shondo'suja tsofatu'su cori sotija seis gramosve tssaiña'choma tisenga afe. Toya'caen dos rande cori tivenga ancaenqque'su cien gramosma ti'tsse tssaiña'choma'qque afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Afepa su: —Chigáne ñanga condaja, ¿majambe onque'nge qui queja? Toya'caen ñanga condaja, ¿cuartota ti jin que yaya tsaoni cuintsu ña, ñama shondosundeccu'qque tseni anañe? ");
INSERT INTO conNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Tsa'caen iñajampañasi tsu su: —Ña gi Betuel onque'nge. Ña yaya tsu Nacor dutssi'ye, tise mamajan Milca. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Toya'caen ingi tsaoni tsu cuarto jin cuintsu que'i ana'faye. Cameyo ccuipa anaña'chove shoshovi samba, cameyo anqque'su'qque tsu jin. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tsa'caen susi shondo'suja ccaru dyaipa Na'su Chigama iñajan ");
INSERT INTO conNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","qquen supa: “Ñoa'me ñotssi qui Na'su ña na'su Chiga. Nane queja que suqquia'caen qui ña na'sunga ñotsse tson. Ñotsse tsomba qui tansintsse ñama i tise antian tsaoni.” ");
INSERT INTO conNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tise tsa'caen Na'suma iñajan'jen'ni Rebecaja buttopa ja tise mama tsaoni pa'cco tisei'ccu tson'choma condaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Tsa pushesuja fae quindyave an'bian, Labán, qquen inisecho'choma. Tsa tsu posoni buttopa ji shondo'suma atteye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nane tise que'tte anga'cho sotija, tivenga ancaenqque'suma'qque tayo attepa, toya'caen pa'cco tsandie su'choma tise que'tte condasi pañamba atteye buttopa ji. Abrahamma shondo'suja toe poso jin'tti pa'cco tise cameyoi'ccu can'jen'ni Labánjan jipa ");
INSERT INTO conNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","tisema su: —Jija, Na'su Chiga Quitsa in'jan'cho. ¿Ma'caen qui ca'nimbipa toya vani can'jen? Tayo gi tsa'oma ñoña'fa quene toya'caen que cameyone'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tsa'caen susi shondo'suja tise'pa tsaoni ja. Tseni nepisi Labánjan cameyo'su andu'choma sombomboemba shoshovi sambama ccuipapoen cameyo anaña'chove. Tsomba cameyondeccuma o'fian. Tsa'caen tsomba omboe tsa'ccuma'qque i cuintsu shondo'su tisei'ccu jacansundeccu'qque tise'pa tsu'ttema cashi'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tse'i o'fiaña'cho ashaen'fasi Abrahamma shondo'suja su: —Ña afaye ji'choma toya afambi'teja añe oshambi gi. Tsa'caen susi Labánjan su: —Afaja jongoesuve in'jan'da. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tsonsi shondo'suja su: —Ña gi Abrahamma shondo'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Na'su Chiga tsu ña na'suma ñotsse in'jamba ricove tson. Nane osha'choma tsu tisenga afe: ovejandeccu, vaurandeccu, cori, totoacori, sema'su tsandiendeccu, sema'su pushesundeccu, cameyondeccu, toya'caen borondeccuma'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Toya'caen tsu tise pushe Sara coenza ccasheve da'chonga fae tsandie du'shuve afe. Tsa tise dutssi'yenga tsu ña na'suja pa'cco tisu an'bian'choma afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ña na'suja ñoa'me su'chove ña suye in'jamba tsu ñama su: ‘Antteya'bi qui cuintsu ña dutssi'ye Isaac va ña can'jeni'su Canaán ande'su pushesuma pusheye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tsa'ma ña yaya'ye antiandeccuni japa ña antian'su pushesundeccu'su pushesuve tta'ttaja cuintsu tsama pusheye.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tsa'caen susi gi su: ‘Ña na'su, pushesuma attesi ñai'ccu jiye in'jambian'da, ¿ma'caen gi tsoña?’ ");
INSERT INTO conNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Qquen ña iñajampañasi tsu tiseja su: ‘Ñanda gi Na'su Chigave in'jamba canse. Tsa'cansi tise tsu tisema shondo'suma quei'ccu moeña cuintsu quema fuitepa ñotsse angasi queja tseni'su pushesuma ña dutssi'yembe iye ña antiandeccu'suma, nane, ña yaya'ye antiandeccu'suma. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mapán ña antiandeccu pushesuma afeye chi'ga'ni'qque cuintsu pasaja ña mandaqquia'caen que tsoñe su'choja.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Tsa'caen susi jipa gi ja'ño a'ta posonga nepipa Na'su Chiga, tsa ña na'su Abraham Chigama qquen iñajan: ‘Ñoa'me ñama fuitepa ñotsse i'ta ");
INSERT INTO conNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","chigáne, ña vani poso jin'tti ccutsusi qquen tsonjan: Antteja majan chu'a pushesu tsa'ccuma ichhoi'su jisi: Chigáne que tsoripama andiamba ñama cui'ñajan, qquen ña susi: ");
INSERT INTO conNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Cu'ija. Toya'caen gi que cameyondeccuma'qque cui'ñaña, qquen su'ta, tsaya tsu que in'jan'cho pushesu ña na'su dutssi'yembe pusheve daya'cho.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Toya iñajan'jen'ttie gi Rebeca jiña'choma atte tise tsoripama opipa. Jipa posonga andepa tsa'ccuma ichhoipa sombosi gi su: ‘Chigáne tsa'ccuma ñanga cui'ñajan.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tse'faei'ccuyi tise tsoripama andiamba ñama su: ‘Cu'ija. Toya'caen gi que cameyondeccuma'qque cui'ñaña.’ Tsa'caen supa ñama cui'ñamba ña cameyondeccuma'qque cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Cui'ña nanisi gi iñajampaña: ‘¿Majambe onque'nge qui queja?’ qquen susi tiseja su: ‘Ñanda gi Betuel onque'nge, tsa Nacor dutssi'yembe, tise mama tsu Milca.’ Tsa'caen susi gi tisenga indian tsofatu'su sotijama, toya'caen tivenga ancaenqque'suma. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Afepa gi ccaru dyaipa Na'su Chigama iñajan. Nane ña na'su Abraham Na'su Chiga Quitsama gi ñotsse afa tise ñama isi tansintsse ña na'su antiandeccunga jipa tsa'su pushesuma tise dutssi'yembe angaya'pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tsa'cansi que'ija ñotssipa ña na'suma ñotsse tsoñe in'jan'da ñanga conda'faja. Tsambi'ta se'pi'a'qque ñanga conda'faja cuintsu ña jongoesuve tsoñe atesuye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tsa'caen susi Labán toya'caen Betuel'qque su'fa: —Pa'cco va tson'choja Na'su Chiga tson'cho tsu. Tsa'cansi ingimbembi tsu ‘ju’ ni ‘me'in’ qquen afaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Chiga tsa'caen susi que canjan, va'tti tsu Rebeca. Tisema qui angaye osha cuintsu que na'sumbe dutssi'yema tsa'nduye Na'su Chiga in'jamba antteqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tsa'caen su'fasi pañamba Abrahamma shondo'suja ccaru dyaipa andenga puntssan ccui, Na'su Chigama ñotsse afaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Afa nanimba osha'cho ñotssia cori, totoacorima ñoñajan'choma, pushesu ondiccuqque'suma'qque somboemba Rebecanga afe. Toya'caen tise quindyanga, tise mamanga'qque osha'cho ñotssiama afe'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Afe'je nanimba shondo'su toya'caen tisei'ccu jacansundeccu'qque an nanimba tse'ttinga ana'fa. Ccaqui a'ta poiyi'cco jangi'fasi shondo'suja su: —Antte'faja ña na'su tsaoni ña jaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tsa'ma Rebeca quindya, tise mama'qque su'fa: —Diez a'taqquia'caen tise ingi'ccu can'jenccasi qui tisema angaye osha. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tsa'ma shondo'suja su: —Ti'tsse ñama an'bian'fajama. Nane Chiga fuitesi vani ñotsse jipa gi ña in'janqquia'caen tson. Tsa'cansi antte'faja ña na'su tsaoni ña jaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tsa'caen susi tsendeccuja su'fa: —Jinge pushesuma ttu'sepa pañañe jongoesu qquen su've'se. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tsa'caen supa Rebecama ttu'sepa iñajampaña'fa: —¿Jayeta ti qui in'jan va tsandiei'ccu? Tsa'caen iñajampañasi pushesuja “ju” qquen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tsa'caen susi Rebecama moeñe ashaen'fa, tisema coira'su pushesuma'qque cuintsu Abrahamma shondo'su tsai'ccu jacansundeccui'ccu ja'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tsa'caen moe'jemba qquen Rebecama ñotsse afa'fa: “Que ingi antianjan ¡tsain'bitssi aindeccumbe chanme qui daya! ¡Que omba'su dushundeccu tsu poiyi'cco que enemigondeccu canqquema patsu'faya!” ");
INSERT INTO conNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tsa'caen afa nani'fasi Rebecaja, tisema coira'su pushesui'ccu cameyonga otse Abrahamma shondo'sui'ccu jaye. Tsa'caen tsu shondo'suja Rebecama isupa tsa canqque'ye sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaacja Lajairoi posone jipa Néguev andeni can'jen. Nane tsa posoja “Chiga cansepa ñama atte” qquen inisecho'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tsa'caen can'jemba tayo cose jisi pasiaye sombo. Tsa'caen jacamba tsu atte cameyondeccu jiña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca'qque, cameyoni dyai'cho camba Isaacma atte. Attepa cameyo'ye andepa ");
INSERT INTO conNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","shondo'suma iñajampaña: —¿Majan tsu jova tsandie potrero'ye inginingae jiña'cho? Shondo'suja su: —Tsaja ña na'su tsu. Tsa'caen susi pañamba Rebecaja tise oppoen'jen'cho sarupai'ccu tisu camba'juma picco. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Catsepa shondo'suja pa'cco tise tson'choma Isaacnga condase. ");
INSERT INTO conNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Omboe Isaacja Rebecama anga tise mama Sara'ye carpa tsaoni. Tsa'caen angapa tisema pushe. Isaacja Rebecama ñotsse in'jamba tise mama'ñe pa'choma aqque'pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamjan faesu pushesuma pushe, Cetura qquen inisecho'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tsa'caen pushepa tsu ti'tsse dushundeccuve atapa. Nane tsendeccumbe inise tsu Zimram, Jocsán, Medán, Madián, Isbac toya'caen Súa. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán tsu Seba toya'caen Dedán yaya. Dedán omba'su dutssiyendeccu tsu asureo'su, letuseo'su, toya'caen leumeo'su aindeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madián dutssiyendeccu tsu Efa, Efer, Hanoc, Abida toya'caen Elda. Nane pa'cco vandeccu tsu Cetura dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Isaac tsu isu pa'cco tise yaya Abraham pasi isuya'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tsa'ma Abraham faesuma pushepa du'sian'chondeccuja aqquia afe'choma tsu isu'fa. Nane Abraham toya cansuite tise faesu dushundeccuma Isaac'ye joqquitssiamba chiga sombo'jefanga moe cuintsu tseni canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamjan ciento setenta y cinco canqque'fa an'biamba pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nane opatsse cansé coenza ccashe'yeve dapa pa. Papa tise tayopi'su coenzandeccu can'jen'ni (Chiga sefacconi) ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Pasi tise dutssiyendeccu Isaac toya'caen Ismael tisema a'tu'fa Macpela fattocco changonga, tsa Mamre canqque chiga sombo'jefani'su chango. Nane Abrahamjan tsa changoma chava hitita aindeccu'su Zohar dutssi'ye Efrómbema. Tse'ttinga Abrahamma a'tu'fa tise pushe Sara'yei'ccu pporotsse. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham tayo pasi Chigaja Isaacma ñotsse tson. Nane Isaacja “Chiga cansepa ñama atte” qquen inisecho'cho Lajairoi poso jin'ttini canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Vandeccu tsu Ismael dushundeccu, tsa Abraham Sarambe egipto'su sema'su Agarnga du'sian'chombe dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Nane coenzai'ccu ashaensi tsu: Nebaiot, Cedar, Adbeel, Mibsam, ");
INSERT INTO conNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO conNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis toya'caen Cedema. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Tsa'caen tsu inisian'fa Ismael doce dushundeccuma. Tise'pa iniseningae tsu tisu ande tise aindeccuma'qque inisian'fa. Nane poiyi'cco tsu tisupa ande'su na'suve da'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelja ciento treinta y siete canqque'fave an'biamba papa Chiga sefacconi tise tayopi'su coenzandeccu can'jen'ni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tise dushundeccuja Asiriani ja'jequini can'jen'fa. Nane tsaja Egipto isevetssi tsu Havila, Sur enttingeni. Tise antiandeccumbe utufani can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Va tsu Abraham dutssi'ye Isaacne condase'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac cuarenta canqque'fave an'biamba Rebecama pushe, Betuel onque'nge tsa Labán que'ttema. Tsendeccuja arameondeccu, Padan-aramni cansesundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca du'shuma isuye oshambisi Isaacja Na'su Chigama iñajan tise pushene. Iñajan'choma Chigaja pañasi Rebecaja surie da. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Dos du'shuve an'biansi toya isumbi'te tto'pani iyicco'je'fasi Rebecaja asi'ttaen: “¿Ma'camba tsu ña'ñejan qquen tsincon?” Tsa'caen asi'ttaemba Na'suma iñajansi tsu ");
INSERT INTO conNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","tiseja su: “Que tto'panijan dos aindeccu tsu can'jen'fa. Nane dos canqquepa tsu toya isumbi'te iyicco'je'fa. Fae'cco tsu faesuma ti'tsse'tssiya. Nane coenza tsu chu'ama shondoya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tise du'shuma isuya'cho nepisi Rebecaja dos du'shuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","O'tie isu'choja cu'apa tosa'vu'cho'oyisi tisema inisian'fa Esaú. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Omboe tise quinshinme isusi tivei'ccu tise quindya Esaú tsu'ttema indi'cho. Tsa'caen sombosi tsu inisian'fa Jacob. Isaac sesenta canqque'fave an'bian'ni tsu Rebecaja tsa'caen du'shuma isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Dushundeccuja coen'fa. Esaúja ñoa'me tsampini japa panzaye atesu'chove da. Tsa'ma Jacobja ppimppintssia a'ipa tsa'caen jacambipa pa'cco a'ta carpa tsaoni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaacja Esaúma ñotsse in'jan tise panzapa i'je'choma an'jemba. Tsa'ma Rebecaja Jacobma ti'tsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Fae a'ta Jacob shoccoen'jen'ni Esaúja tsampine quimbipa jipa ");
INSERT INTO conNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","su: —Chigáne ñanga afeja que sho'ccoen'cho'su cu'a se'vama. Qquipoe'supa gi paye tson'jen. (Tsa'caen'qque tsu Esaúma su'fa Edom, “cu'a” qquen suye.) ");
INSERT INTO conNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tsa'caen iñajansi Jacobja su: —Otie ñanga afeye suja quenga afeye su'choma, tsa dutssi'ye coenza isuya'choma, jai'ngae ña isuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tsa'caen susi Esaúja su: —¿Jongoesune gi dutssi'ye coenza isuya'choma in'jaña qquipoe'supa paye tson'jen'da? ");
INSERT INTO conNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tsa'caen susi Jacobja su: —Ja'ñoñi ñoa'metsse su'chove suja. Tsonsi Esaú ñoa'metsse supa dutssi'ye coenza isuya'choma Jacobnga antte cuintsu jai'ngae isuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tsa'caen susi Jacobja pan toya'caen cu'a se'vama Esaúnga afe. Esaúja amba cu'i nanimba jangipa ja. Ni minga'vieyi'qque tisu isuya'choma afe'chone asi'ttaembe ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tsa'caen tson'jen'ni qquipoesuiteve da pa'cco tsa ande, Abraham can'jeinte daqquia'caen. Tsa'caen dasi Isaacja filisteo ande'su Gerar canqqueni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tsa filisteo'su na'suja Abimelec. Tseni tsu Na'su Chigaja attiamba su: “Egiptoni jajama. Ma'ttinga ña su'ninda tse'ttini can'jenjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ja'ñojan va andeni can'jenjan. Ñajan quei'ccu can'jemba gi quenga ñotsse tsoña. Nane pa'cco va andema gi quenga toya'caen que dushundeccunga'qque afeya. Tsa'caen gi tsoña que yaya Abrahamnga su'choma naniñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Que omba'su dushundeccuma gi atapoeña sefacconi'su o'feacan'tsse. Tsomba gi pa'cco va andema afeya. Toya'caen gi que omba'su dushundeccui'ccu poi ande'su aindeccuma ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nane Abrahamjan ñama pañamba pa'cco ña mandapa antte'choma nanitsse tson. Tsa'caen ña atesian'choma pañamba tsonsi gi tise dushundeccui'ccu poi ande'su aindeccuma ñotsse tsoña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tsa'caen susi Isaacja Gerarni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tsa'caen can'jensi tseni can'jensundeccu Rebecane iñajampaña'fasi Isaacja “Ña pushe” qquen suye dyojopa “Ña que'tte” qquen su. Nane Rebecaja me'detssisi tsu tsa'caen su tseni'su tsandiendeccu tisema fi'ttipa Rebecama itsa'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bo'tsse tsu tseni canse'fa. Tsa'ma fae a'ta Abimelec ventana'ñe caña'jen'ni Isaac tise pushe Rebecai'ccu cofe'je'choma atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tsa'caen attepa Isaacma ttu'seye mandapa tise jisi su: —Tiseja ñoa'me que pushe tsu. Tsa'camanda, ¿jongoesie qui ‘tisu que'tte’ qquen afopoen? Tsa'caen susi Isaacja su: —Tisene ñama fi'tti'fasa'ne dyopa gi tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tsa'ma Abimelecja tisema su: —¿Ma'caen qui inginga tsa'caen tson'jen? Ti'tssecan'da tsu va canqque'su majan tsandie que pushei'ccu ccuiye'can. Tsa'caen tson'choecan'da queyi qui ingima egae tsincoeñe'can. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tsa'caen supa Abimelecja manda antte tise canqque'suma: —Majan tsa tsandiema noñangiamba, tise pushema noñangian'ninda junde fi'ttiya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tsa canqque'fa Isaacja tseni jomba ñotsse tai Na'su Chiga tisema ñotsse tsonsi. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nane ricove dapa pa'cco osha'choma an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tsain'bi oveja, vaura, semasundeccuma'qque an'biansi filisteondeccuja tise'pa injama'choni se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tsa'caen ganasi injamáchoni se'pipa filisteondeccuja Abraham cansuite Abrahambe semasundeccu dyan'dya'cho posoma andei'ccu ovi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tsa'caen tson'fasi Abimelecja Isaacma su: —Va'ttie joqquitssipa jaja. Ingima ti'tsse joccapitssia ricove qui da. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tsa'caen susi Isaacja tsa canqque'ye sombopa Gerar'su sinjunccuni japa canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tsa'caen japa toe tise yaya'ye cansuite dyan'dya'fa'cho tsa'ccu posoma ccase dyan'dya. Nane tsa posoma tsu filisteondeccu Abraham pasi andei'ccu ovi'fa. Tsaveyi tsu ccase dyan'dyapa tise yaya'ye inisianqquia'caeñi inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Fae a'ta Isaacmbe semasundeccuja tsa sinjunccuni tsa'ccu posove dyandya'jepa tsa'ccu sombo'je'ttima atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tsa'ma cca'i tsa sinjunccuni ovejama coirasundeccu Isaacmbe coirasundeccui'ccu tssetssecco'fa, tsa tsa'ccuja tise'pambe qquen supa. Tsa'caen tssetssecco'fasi Isaacja “Tssetssecco'cho” qquen tsa posoma inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tsa'caen tsomba omboe tise'be semasundeccuja faesu posove dyan'dya'fa. Tsane'qque ccase iyicco'fasi Isaacja tsa posoma inisian “Iyicco'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Tsa'caen tsincon'fasi Isaacja tse'ttie sombopa biani japa faesu posove dyan'dya. Tsa posonejan iyicco'fambisi “Se'piccombi'choa” qquen inisian. Tsa'caen inisiamba su: “Ja'ño tsu Na'su Chigaja antte ingi se'piccombe va andeni cansepa ti'tsse'tssia've daye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Tse'tti can'jemba Isaacja Beersebani ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tsequi cose Na'su Chigaja tisenga attiamba su: “Ña gi que yaya Abrahambe Chiga. Dyombe can'jenjan. Ña gi quei'ccu can'jen. Nane ñama shondo'su Abrahamma in'jamba gi quema'qque in'jamba ñotsse tsoña. Toya'caen gi que omba'su dushundeccuve ti'tsse atapoeña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tsa'caen susi pañamba Isaacja Chiganga afeye oque'je'chove ñoñamba tsanga Na'su Chigama iñajan'jen. Tse'tti cansesi tisema shondosundeccuja faesu tsa'ccu posove dyan'dya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Fae a'ta Abimelecja Gerarne ji Isaacma afaye. Tisei'ccu tsu ji'fa tise amigo Ahuzat, toya'caen Ficol, tise'be sundarondeccumbe capitán. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tsa'caen ji'fasi Isaacja su: —Tisupa ñama chi'gapa que'i ande'ye joqquitssian'da, ¿jongoese qui ñama can'su ji'fa? ");
INSERT INTO conNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tsendeccuja su'fa: —Atte'fa gi quei'ccu Na'su Chiga can'jen'choma. Tsa'cansi gi in'jan'fa quei'ccu fae'ngae injanccoye. Nane injanccoye in'jamba su'choja qquen tsu: ");
INSERT INTO conNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ingi quema noñangian'ma'caen queja ingima egae tsonjama. Nane ingija quema noñangian'ma ñotsse tsomba quema ñotsse afapa moe'fa. Tsa'ma ja'ñojan Na'su Chiga tsu quema ñotsse tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tsa'caen su'fasi Isaacja rande fiestave tson. Nane amba cu'ipa ");
INSERT INTO conNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ccaqui a'ta sinte jangipa ñoa'me su'choi'ccu ñotsse tsoña'chove injanccoye su'fa. Tsa'caen supa Isaacja “Chigái'ccu” qquen susi tsendeccu'qque tisu amigoma'caen chigambiamba ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tsequi a'tayi Isaacmbe semasundeccu'qque jipa conda'fa tise'pa dyandya'je'cho'ye tsa'ccu sombo'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaacja tsama pañamba tsu posoma “Seba” qquen inisian. Tsa'cansi tsu tsa canqqueja ja'ño pán Beerseba qquen inisecho'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaúja cuarenta canqque'fave an'biamba Juditma pushe. Tsaja hitita a'i'su Beeri onque'nge. Toya'caen tsu faesu pushesu, Basematma pushe. Tsaja faesu hitita'su onque'nge, Elón qquen inisecho'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tsa dos pushesundeccu tsu Isaac Rebecama'qque panshaen vanae'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaacja coenza ccashe'yeve dapa atte'jeye oshambi. Fae a'ta tise dutssi'ye coenza Esaúma ttu'sepa su: —¡Jaricho! Qquen susi Esaúja su: —Afaja, yaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tsonsi Isaacja su: —Tayo qui atte ña coenza ccashe'yeve da'choma. Maqui a'ta pa'ngae gi paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tsa'camba gi in'jan tsampini que battittianccui'ccu japa jongoesuveyi'qque fi'ttipa iye. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ipa ña añe in'janqquia'caen ya'yatssia aña'chove sho'ccoemba ija ña añe. Tsonsi gi toya pambi'te quenga ñotsse tsoña'chove afaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Tsa'ma Rebecaja Isaac Esaúnga tsa'caen su'je'choma paña. Tsa'camba Esaú tsampini tise yayambe panza'su jasi ");
INSERT INTO conNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Jacob, tise dutssi'ye chu'ama ttu'sepa su: —Paña gi que quindya Esaúnga que yaya qquen su'je'choma: ");
INSERT INTO conNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tsampini japa jongoesuveyi'qque fi'ttipa ña añe in'janqquia'caen ya'yatssia aña'chove sho'ccoemba ija ña añe. Amba gi toya pambi'te quenga ñotsse tsoña'chove afaya Na'su Chiga caña'jen'ni.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tsa'cansi, jaricho, ña quenga su'choma ñotsse pañajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Chivo ttuccuni japa dos chivo du'shu ñotssiama ñani ija. Ña gi que yaya in'janqquia'caen ya'yatssia aña'chove sho'ccoeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Que qui ña sho'ccoen'choma angaya cuintsu amba quenga ñotsse tsoña'chove afaye toya tise pambi'te. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tsa'ma Jacob tise mamanga su: —Ña quindyaja tosecco'oyi pa'cco ai'vo. Tsa'ma ñajan me'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nane ña yaya ñama pporaemba atte'ta tsu in'jaña ñajan tisei'ccu cofe'je'chove. Tsomba tsu ñama ñotsse afambipa egave afaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tsa'ma tise mamajan su: —Jaricho, tsa egae afa'choja ñanga tsu antteyeya. Queja asi'ttaembe'yi ña suqquia'caen chivo du'shuma i'ngapa ija. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tsa'caen susi Jacobja chivo dushundeccuma i'ngapa afe tise mamanga. Tise mamajan isupa Isaac añe in'janqquia'caen ya'yatssia aña'chove sho'ccoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tsomba dutssi'ye coenza Esaú carpani an'bian'cho ñotssia ondiccu'jema somboemba dutssi'ye chu'a Jacobnga ondiqquian. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Toya'caen chivo ttonoi'ccu Jacob tivenga tise catai'chonga'qque oppoen ma'tti tose me'ttianga. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tsa'caen ñoñamba tise sho'ccoen'cho, panma'qque tisenga afe cuintsu tise yayanga angapa afeye. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tsonsi Jacobja tise yaya can'jeni ca'nimba su: —¡Yaya! Tsonsi Isaacja su: —Va'tti gi can'jen. ¿Ma'can ña du'shu qui ji? ");
INSERT INTO conNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tsonsi Jacobja su: —Ña gi que dutssi'ye coenza Esaú. Tayo gi que suqquia'caen ñoñamba i. Chigáne jangi dyaipa ña panza'choma anjan. An nanimba Chiga ñanga ñotsse tsoña'chove afaja. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tsonsi Isaacja iñajampaña: —¿Ma'caen qui jundeyi cachuipa panzapa ji, jaricho? Jacobja su: —Na'su que Chiga ñama fuitesi gi junde panza. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tsa'ma Isaacja su: —Ñanga catsepa antteja ña pporaencañe ñoa'me ña dutssi'ye Esaúve'se qui. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tsa'caen susi Jacobja catse cuintsu tise yaya pporaencañe. Pporaencamba Isaacja su: “Aya'faja Jacob aya'fa. Tsa'ma tiveja Esaú tive'can.” ");
INSERT INTO conNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nane Jacob tive tise quindya Esaú tive'caen tosa'vupasi Isaacja tisema atesuye oshambi. Tsa'ma tisenga ñotsse tsoña'chove afaye tson'jemba ");
INSERT INTO conNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ccase iñajampaña: —¿Ñoa'metsse ti qui ña dutssi'ye Esaú? Jacobja su: —Ju, ñanda gi Esaú. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tsonsi tise yayaja su: —Afeja, jaricho, ña añe que panza'choma. An nanimba gi quenga ñotsse tsoña'chove afaya. Tsa'caen susi Jacobja aña'choma afe cuintsu añe. Toya'caen vinoma'qque afe cuintsu cui'ye. Isaacja amba cu'i nanimba ");
INSERT INTO conNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","su: —Jaricho, ñanga catsepa mochaja. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob mochaye catsesi Isaacja tise ondiccu'jema shonchhan. Tsa'caen shonchhamba tisenga ñotsse tsoña'chove qquen afa: “Ju, ña dutssi'yema shonchhansi Na'su Chiga nasipa'su andema ñotsse tsonsi ñoa'metsse tssu'jianqquia'can tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Chiga tsu quenga sefani'su unjima afeya, Toya'caen ñotsse sho'yoya'cho andema. Tsonsi qui tsain'bio trigo, tsain'bio vinoma'qque an'biaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tsain'bio a'i tsu quema paña'faya. Nane faesu ande'su aindeccu'qque quenga ccaru dyai'faya. Que antiandeccuma'qque qui mandaya. Nane que mamambe dushundeccu'qque quenga ccaru'faya. Majan quenga egae tsoña'chove afa'ninda Chiga tsu tisenga egae tsoña. Tsa'ma majan quenga ñotsse tsoña'chove afa'ninda Chiga tsu tisenga ñotsse tsoña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac Jacobnga ñotsse tsoña'chove afa nanisi Jacob tise yayane somboin jasi tse'faei'ccuyi tsu Esaúja tsampine ji. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Jipa tsa'qque ya'yatssia aña'chove sho'ccoemba tise yayani anga. Angapa su: —Yaya, jangipa anjan que dutssi'ye panzapa i'choma. Tsomba ñanga afaja ñanga ñotsse tsoña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tsa'caen susi Isaacja iñajampaña: —¿Majan qui queja? Tsonsi Esaúja su: —Ña gi que dutssi'ye coenza, Esaú. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tsa'caen susi pañamba Isaacja dyopa ttun'dundu'je afa: —Tsa'caenda, ¿majan tsu panzapa sho'ccoemba ya'yatssia aña'choma i? Que toya jimbi'te gi pa'cco tsa i'choma amba tsa i'suma ñotsse tsoña'chove afa. Tsa'caen ña susi tsu tisenga ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaúja tise yaya su'choma pañamba quian'me i'namba fundopa afa: —Ñanga'qque ñotsse tsoña'chove afaja, yaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tsa'ma Isaacja su: —Tayo tsu que antian jipa afopoemba quenga ñotsse tsoña'chove afaya'choma anga. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tsonsi Esaúja su: —¡Ñoa'me tsa'cañasi ti qui Jacobve inisian'fa! Nane ja'ñojan dos se tsu ñambema qqueñamba itsa. Otie tsu dutssi'ye coenza isuya'choma itsa. Tsomba ja'ñojan ñanga ñotsse tsoña'chove afaya'choma'qque itsa. ¿An'biambi ti qui faesu afa'choveyi'qque ñanga ñotsse tsoña'chove afaye? ");
INSERT INTO conNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tsa'caen susi Isaacja su: —Que canjan. Tayo gi Jacobnga afe que na'suve daya'chove. Nane poiyi'cco tise antiandeccu'qque tisema paña'faya. Toya'caen gi in'jan cuintsu tsain'bio trigo, tsain'bio vinoma'qque an'biañe. Tsa'camba, ¿jongoesuma gi quenga tsoña, jaricho? ");
INSERT INTO conNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tsa'ma Esaúja quian'me iñajamba su: —¿Aqquia fae afa'choveyi ti qui an'bian, yaya? Chigáne ñanga'qque ñotsse tsoña'chove afaja. Tsa'caen supa ccase i'na fundo. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tsa'caen i'nasi Isaacja su: “Nane queja ñotssia ande'ye joqquitssipa biani can'jeña, ni unjin'qque tui'jembinia. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Sundaroa'caen tisu matichi'ccu iyicco'jepa qui tisu andema an'biaña. Nane que antianma shondo'suve qui daya. Tsa'ma maqui a'ta quin'ame tson'da qui tise'ye ccushaya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isaac Jacobma ñotsse tsoña'chove afasi Esaúja Jacobma chi'gapa qquen asi'ttaeñe ashaen: “Junde tsu ña yaya pasi i'naña'cho. I'na pasapa gi ña quinshin Jacobma fi'ttiya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esaú tsa'caen in'jan'choma pañamba Rebecaja Jacobma ttu'seye manda. Ttu'sesi jisi tisema su: —Que canjan. Que quindya Esaú tsu que tson'chone quema fi'ttiye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tsa'cansi, jaricho, ñama pañajan: Jundeyi ccuyapa jaja Harán canqqueni, ña quindya Labán can'jeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tseni canseccaja que quindya tise iyicca'ye'choma pasaya'ngae; ");
INSERT INTO conNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","que tisenga tson'choma aqque'paya'ngae. Pasasi gi conda'suma moeña que ccase vani jiye. In'jambi gi fae a'tayi dos ña dushundeccu nepi'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Omboe Rebecaja Isaacnga su: —Esaú pushe hititandeccu panshaen noñangiansi gi ñoa'me quimbipa paye in'jan. Jacob'qque va Canaán ande'su hititama pushe'ninda ñoa'me gi paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tsa'caen Rebeca su'choma pañamba Isaacja Jacobma ttu'sepa ti'tsse tisenga ñotsse tsoña'chove afapa qquen conda: “Va Canaán ande'su pushesuma pushejama. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tsa'ma Padan-aram andeni jaja que yaya ccashe'ye Betuel tsaoni. Tseni japa que ton'ton Labán onque'nge'suma pusheja. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Chiga Osha'choma Oshacho'cho quenga ñotsse tsonsi qui tsain'bio omba'su dushundeccuve atapoeña. Nane que'ye tsu tsain'bio aindeccu atapapa fae naccuve da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Chigaja Abrahamnga ñotsse tsoñe su'chopa tsu quenga ñotsse tsomba que omba'su dushundeccunga'qque ñotsse tsoña. Nane ja'ñoñi gi ccane ji'choa'caen va andeni canse'fa. Tsa'ma Chiga Abrahamnga suqquia'caen tsonsi qui va ande'su nasundeccuve dapa canse'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tsa'caen tsu Isaacja Jacobma manda maña Padan-aram andeni. Tsa'caen japa Jacobja nepi tise ton'ton Labán tsaoni. Nane Labán tsu arameo'su a'i Betuel dutssi'ye. Toya'caen tsu Jacob, Esaú mama Rebeca quindya. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isaac tsa'caen Jacobma Chiga tisenga ñotsse tsoña'chove afapa Padan-aram andeni japa pusheye moe'choma Esaúja atte. Toya'caen tsu atte ñotsse afa'cho nanimba Canaán ande'su pushesuma pusheye se'pi'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tise yaya tise mama manda'fasi Jacob ñotsse pañamba tsa'caen Padan-aram andeni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tsama'qque attepa tsu Esaúja in'jan tise yayaja in'jambi Canaán'su pushesundeccuma. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tsa'caen in'jamba Esaúja tayo dos Canaán'su pushesuma pushepa Ismael, tsa Abraham dutssi'ye, can'jeni japa tsambe onque'nga, Mahalatma'qque pushe. Tsaja Mebaiot antian tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacobja Beersebane sombopa Haráni ja'je'cho tsaiqui'ye ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tsa'caen jayisi tayo chiga amppisi tse'ttinga ana. Patu tse'tti sheque'cho'suma isupa asusu'chove ccuiñamba tsanga anañe ccui. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Anamba qquen ayo'o: Canchanama tsu atte andene sefacconi ppo'rotsse ccutsu'choma. Tsa'ye tsu Chigama sefacconi'su shondosundeccuja ansundepa ande'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Toya'caen tsu atte Na'su Chiga tsai'ccu pporotsse ccutsupa qquen afa'je'choma: “Ña gi Na'su que yaya ccashe'ye Abrahambe Chiga. Toya'caen que yaya Isaacmbe Chiga. Quenga toya'caen que omba'su dushundeccunga gi que ja'ño ccui'cho andema afeya. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nane tsendeccu tsu atapa'faya tsain'bitssi sisipa andeni jinqquia'cantsse. Tsa'caen atapapa tsu attufacco'faya majandeccuja cambajufanga, majandeccuja sepaccofanga, majandeccuja tansinfanga, toya'caen majandeccuja pavefanga. Nane tsa'caen attufapa tsu que, tisu omba'su dushundeccu'qque poi ande'su aindeccuma ñotsse tson'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ñanda gi quei'ccu can'jen. Coiraya gi que mani jacan'ni'qque. Toya'caen gi tsoña que ccase vani jiya'chove. Quenga su'choma nanimbiteja quema catiya'bi gi.” ");
INSERT INTO conNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tsa'caen ayo'opa bittapa Jacobja qquen asi'ttaen: “Ñoa'me tsu Na'suja va'tti can'jen'ma gi ñajan atesumbi.” ");
INSERT INTO conNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tsa'caen in'jamba dyopa asi'ttaen: “¡Ñoa'me dyo'tssi ti va'ttija! ¡Va'tti tsu Chiga Tsa'o! ¡Sefacconi Cani'jen'tti tsu!” ");
INSERT INTO conNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ccaqui a'ta sinte'yi Jacobja jangipa tise asusupa ana'cho patuma jangian dyaiñamba asetei'ccu tsanga fiñamba feti Chigambe qquen canjeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tse'ttija tayopi'su canqque jin, Luz qquen inisecho'cho. Tsa'ma Jacobja tsa inisema cambiamba Betel qquen inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tse'ttinga tsu Jacobja ñoa'me su'chove afa: “Chiga ñai'ccu jacamba ña qquen jacan'choma coirapa angacamba jongoesu anqque'su toya'caen ondiccuqque'suma afesi ");
INSERT INTO conNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ccushapa quinsetssi toequi ña yaya tsaoni nepi'ta gi in'jaña Na'suja ñoa'me ña Chiga tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Va patuma ña jangian dyaiña'cho tsu Chiga tsa'oya. Toya'caen, Chiga, osha'cho que ñanga afe'cho'suma enttingeve fae chongayi'ccoveyi gi quenga afe'jeya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacobja tise jayi'cho tsaiqui'ye japa chiga sombo'jeni'su andeni nepi. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tseni'su potreronga nepipa posoma atte. Tsa poso jin'tti tsu tres naccu oveja bojin ccui'fa. Nane tsa poso'su tsa'ccuma tsu tsendeccuja cu'iye atesu'fa. Poso chango'ttimajan rande patui'ccu picco'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nane poi naccu'su oveja tse'ttinga bosi tsu coirasundeccuja tsa patuma joqquitssiañe atesu'fa tise'pa ovejanga tsa'ccuma cui'ñañe. Oveja cu'i nanisi ccase tsu piccoya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacobja catsepa oveja coirasundeccuma iñajampaña: —Antiandeccu, ¿que'ija manisundeccu qui? Tise'paja su'fa: —Ingija Harán'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tsonsi Jacob ccase iñajampaña: —¿Que'ita ti qui atesu'fa Labán, tsa Nacor dutssi'yema? —Ju, atesu'fa gi —qquen tsu su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacobja su: —¿Quinse'tssi ti can'jen? Coirasundeccuja su'fa: —Ju, Labánjan quinsetssi tsu. Que canjan, jovoe tsu tise onque'nge, Raquel, tise ovejandeccui'ccu vani jiña. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tsonsi Jacobja su: —Toya a'ta tsu. Nane toya tsu nepimbi ovejama piccoya'cho. ¿Mingapa qui tsa'ccuma cui'ñamba anga'fambi cuintsu shoshovima an'faye? ");
INSERT INTO conNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tsa'ma tsendeccuja su'fa: —Tsa'caen tsoñe osha'fambi gi. Nane ronda'jeya'cho tsu poi naccu'su oveja bosi coirasundeccuja va patuma joqquitssiamba ovejanga tsa'ccuma cui'ñañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tsa'caen Jacob tsendeccui'ccu afa'je'ni Raquelja nepi tise yaya ovejandeccui'ccu. Nane tise tsu ovejama coira'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tsa'caen tise ton'ton Labán ovejai'ccu jisi attepa tse'faei'ccuyi Jacobja posoma picco'cho patuma joqquitssiamba tise ton'ton Labán ovejandeccunga tsa'ccuma cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Cui'ña nanimba Raquelma chigambiamba mochapa i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tsomba Jacob tiseja Rebeca dutssi'ye, Labán quinshin qquen condasi pañamba Raquelja buttopa ja tise yayanga condaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labánjan tise que'ttembe du'shu Jacob ji'choma pañamba sombopa buttoin ja tisema cachuiye. Nepipa munsimba chigambiamba mocha. Tsomba tise tsaoni anga. Can'jemba Jacobja condase pa'cco tisu can'jeni tsomba ji'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Condase nanisi Labánjan su: “Ñoa'me qui queja ña anjampa'suyi.” Jacobja fae ccovu pa'cco Labáni'ccu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tsa'caen can'jensi Labánjan su: —Queja ña antian jipa aqquia ganambe'yi ñambe semaña'bi qui. Mi'nge'tsse in'jan'da ñanga condaja. Afepoeña gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labánjan dos onque'ngeme an'bian. Coenza tsu Lea; chu'aja Raquel. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leaja tise tso'fe ñotssimbi. Tsa'ma Raquelja tsu'ttene tsovepi me'detssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacobja Raquelma injanchopa qquen su: —Que onque'nge chu'a Raquelne gi siete canqque'fa pa'cco quembe semaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tsa'caen susi Labánjan su: —Quenga afeye tsu ñotssi, faesu atesumbi'choanga afesa'ne. Ñai'ccu can'jemba semajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tsa'caen susi Jacobja siete canqque'fa pa'cco Raquelne sema. Tsa'ma Raquelma ñotsse in'jamba tsa siete canqque'fama aqquia siete a'ta'canccoeyi in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Siete canqque'fa pasasi Jacobja Labánma su: —Afeja ña pushema ña tisema pusheye. Tayo gi nani ña tisene semañe su'cho a'tama. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tsa'caen susi Labánjan poiyi'cco tisei'ccu pporotsse canjensundeccuma ttu'se pushe'je'cho fiestave tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tsa'ma tsequi cose Labánjan Leama Jacobni anga. Angasi Jacobja tsai'ccu ana. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Toya'caen Labánjan tise'be sema'su pushesu Zilpama afe, Leama coira'suve.) ");
INSERT INTO conNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ccaqui a'ta sinte Jacobja tise Leai'ccu ana'choma in'jamba iyicca'yepa Labánma afa: —¿Ma'caen qui ñanga qquen tson? Ñajan Raquelne quembe sema. Tsa'camanda, ¿jongoesie qui ñanga afopoen? ");
INSERT INTO conNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tsa'caen susi Labánjan su: —Vanisundeccuja coenzama otie chu'a tsa'nduye atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tsa'cansi va avuja'qui pushe'je'choma nanijan Leane. Tsomba faesu siete canqque'fave ñambe semañe in'jan'ninda gi Raquelma'qque quenga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob pañamba in'jansi tsa Leane fiestaen'cho avuja'qui pasasi Raquelma'qque pusheye afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Toya'caen Labánjan tise'be sema'su pushesu Bilhama afe, Raquelma coira'suve.) ");
INSERT INTO conNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacobja Raquelma'qque pushepa tise've Leama ti'tsse in'jamba faesu siete canqque'fave Labánmbe sema. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Na'su Chigaja Jacob Leama chi'ga'choma attepa tisenga tson cuintsu du'shuma isuya'chove. Tsa'ma Raquelmajan dusumbive tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leaja surive dapa fae tsandie du'shuve isu. Isupa su: “Na'su Chigaja ña ñombi'ye'choma atte. Tsa'cansi ja'ño tsu ña tsa'nduja ñama in'jaña.” Tsa'caen supa tsu tsa du'shuma inisian Rubén. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Can'jemba Leaja faesu tsandie du'shuve isu. Tsamajan inisian Simeón qquen supa: “Na'suja ñama chi'ga'choma pañamba faesu du'shuve ñanga afe.” ");
INSERT INTO conNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Toya'caen ccase tsandie du'shuve isupa su: “Ja'ño tsu ña tsa'nduja ñama in'jaña tres du'shuve an'biansi.” Tsa'caen supa tsu tsa du'shuma inisian Leví. ");
INSERT INTO conNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea ccase faesu tsandie du'shuve isupa su: “Ja'ño gi Na'su Chigama ñotsse afaya.” Tsa'caen supa tsu tsa du'shuma inisian Judá. Tse'ccoeyi isupa ti'tsse isumbe antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquelja tisu Jacob du'shuve isuye oshambipa tise she'she Leama iyicca'yepa injamáchoni se'pi. Tsa'caen se'pipa tisu tsa'nduma su: —Ñanga'qque du'sianjan. Tsambi'ta gi paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tsa'caen susi Jacobja tisema iyicca'yepa su: —¿Ñanda ti gi Chiga? Tsa tsu quemajan tsa'caen du'shu me'cco canseye antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tsa'caen susi Raquelja su: —Que canjan. Ñambe sema'su Bilhai'ccu canseja. Tise du'shuve isu'ninda ña quei'ccu cansepa isuqquiacaña tsu. Tsa'caen tson'da gi du'shuve an'biaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tsomba Raquelja tisu suqquia'caen tise'be sema'su pushesu Bilhama Jacobnga afe tise pushe'can'me. Tsonsi Jacob tsa Bilhai'ccu cansesi ");
INSERT INTO conNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","fae tsandie du'shuve Jacobmbe isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Isusi Raquelja su: “Iñajansi Chiga ñama pañamba tansintsse tsoñe tsandie du'shuve ñanga afe. Tsa'cansi gi va du'shuma inisiaña Dan.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Omboe ccase Bilha Jacobmbe faesu tsandie du'shuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Isusi Raquelja su: “Ña she'shei'ccu iyicco'jepa gi patsu. Tsa'camba gi va du'shuma inisiaña Neftalí.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leaja tisu du'shuma isu'je'choma antte qquen in'jamba tise'be sema'su pushesu Zilpama Jacobnga pushe'can'me afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tsa'caen tsonsi Zilpaja tsandie du'shuve Jacobmbe isusi ");
INSERT INTO conNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leaja su: “¡Ñajan gana! Tsa'camba gi va du'shuma inisiaña Gad.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Can'jemba Zilpaja ccase tsandie du'shuve Jacobmbe isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Isusi Leaja su: “¡Ñoa'me avuja'cho tsu! Ja'ño tsu pushesundeccuja su'faya ñajan avujatssi. Tsa'cansi gi va du'shuma inisiaña Aser.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Fae a'ta Rubénjan nasipani ja trigoma tai'su. Tsa'caen japa tsenima du'shuve isuqque'su teta'choma atte, mandrágoras qquen su'choma. Tsa'suma isupa tise mama Leani anga. Tsa'caen isi Raquelja tsa teta'choma attepa Leama su: —Chigáne va que dutssi'ye i'cho mandrágoras enttingeve ñanga afeja. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tsa'ma Leaja se'pipa su: —Tayo qui ña tsa'nduma itsa. ¿Tsomba ja'ñojan ña du'shu i'cho mandrágorasma'qque ti qui itsaye in'jan? Tsa'caen susi Raquelja asi'ttaemba su: —Que dutssi'ye i'cho mandrágorasma afe'ta qui ja'ño cose Jacobi'ccu anañe oshaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Cose jisi Jacob nasipane jisi Leaja cachuiye sombopa su: —Ña dutssi'ye i'cho mandrágorasma Raquelnga afe'chone qui ja'ñojan ñai'ccu anaña. Tsequi cose Jacobja Leai'ccu ana. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tsa'caen fae'ngae anasi surie dapa Leaja faesu tsandie du'shuve isu, Chiga ñoa'me tise iñajan'choma pañasi. Nane tsai'ccu tsu Leaja cinco du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tsa'caen isupa Leaja su: “Ñambe sema'su pushesuma ña tsa'ndunga afe'chone tsu Chigaja ñanga ccase ñotsse afe. Tsa'cansi gi va du'shuma inisiaña Isacar.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Omboe Leaja ccase Jacobmbe du'shuve isu. Tsai'ccu tsu Leaja seis du'shuve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tsa'caen isupa su: “Chiga tsu ñanga ñocca'tssiama afe. Ja'ño gi seis tsandie du'shuve ña tsa'ndumbe isu. Tsa'cansi tsu ña tsa'nduja ja'ño ñama ti'tsse in'jaña. Tsa'cansi gi va du'shuma inisiaña Zabulón.” ");
INSERT INTO conNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Osefa'poe Leaja fae pushesu du'shuve isupa Diname inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tsa'ma Chigaja Raquelma injan'jemba tise iñajan'choma paña. Tsa'caen pañamba antte cuintsu du'shuve isuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tsa'cansi aisheve isupa su: “Chiga tsu ña du'shu me'cco cansepa ansange'choma joqquitssian. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Isha tsu antteya ña faesuve'qque isuye.” Tsa'caen supa Joséve inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel tsa'caen Joséve isusi Jacobja Labánma su: —Antteja ña tisu andeni jaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Toya'caen ña dushundeccu ña pushendeccuma'qque ñanga afeja cuintsu ñai'ccu ja'faye. Nane tise'pane gi ñajan quembe sema. Queja ñoa'me qui atesu ña quembe sema'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tsa'ma Labánjan su: —Chigáne ti'tsse ñai'ccu can'jenjan. Nane asi'ttaemba gi in'jan que ñai'ccu can'jensi tsu Na'su Chigaja ñama ñotsse tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mi'nge'tsse in'jan'da iñajanjan. Afepoeña gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Tsonsi Jacobja su: —Tayo qui atesu ña ma'caen quembe semamba que aiña'choma coira'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ña jimbi'teja re'riccoe an'bian'choma gi tsain'bitsse atapoen. Nane ña jisi tsu Na'su Chigaja ja'ño pan quema ñotsse tson'jen. Tsa'ma, ¿minga'ni gi tisumbetsseja semaña? ");
INSERT INTO conNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labánjan ccase su: —¿Mi'nge'tsse ña afepoeñe qui in'jan? Tsa'ma Jacobja su: —Me'in, afepoeña'bi qui. Que ña in'janqquia'caen tsoñe in'jan'ninda gi ccase que ovejama coiraya. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ja'ño antteja ña que oveja naccu'suma attufaeñe. Nane pa'cco si'an oveja du'shuma gi attufaeña. Toya'caen pa'cco chivo du'shu ze'nzia, chhifama'qque gi attufaeña. Tsendeccu tsu que ñanga afepoen'choya. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tsa'caen tsonsi jai'ngae jipa ña gana'choma atte'ta qui in'jaña ñajan cca'nambi'ma ñotsse tsonsi tsa'caen da'chove. Nane ña oveja naccuni si'ambi, majan chivo naccu ze'nziambi, chhifambi'choa'qque can'jen'da ccana'choya tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","—Que tsa'caen tsoñe su'choja ñotssi tsu–qquen Labánjan su. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tsequi a'tayi tiseja poiyi'cco chivo quitsa'ye ze'nzia, chhifama'qque attufaen. Tsa'caeñi poiyi'cco chivo pushema'qque majan ze'nzia, chhifa, toya'caen majan re'ricco totoave an'bian'choma'qque attufaen. Toya'caen poiyi'cco oveja si'andeccuma'qque attufaemba tise dushundeccunga afe cuintsu coira'je'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tsa'caen tsonsi dushundeccuja tsa oveja naccuma isupa Jacob can'jen'ttie tres a'ta pa'cco japa can'jen'fa. Tsa'ma Jacobja Labán faesu ovejandeccuma coirá canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tsa'caen cansepa álomo quini'jin'su ttemba, almendro quini'jin'su ttemba, toya'caen castaño quini'jin'su ttembama cha'ttupa re'riqui'ccoe qque'sho cuintsu totoa si'an, totoa si'ame attiañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Tsa'caen qque'shopa oveja naccu tsa'ccuma cui'je'ttinga ccutsutsian. Tse'ttinga tsa'ccuma cui'ye bopa tsu quitsayeja pushema tandange'je'cho. Tsa'caen tson'jemba tsa quini'cco ccutsian'choma attesi tsu tise du'shuja ze'nzia, chhifa, toya'caen pi'piave somboya qquen tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Toya'caen tsu Labánbe oveja quitsayema cca'ttinga attufaen cuintsu Labán oveja pushendeccu Jacob quitsaye ze'nzia, tsambi'ta si'ani'ccuyi tandangeye. Tsa'caen tsu Jacobja Labán oveja naccu'suma tisu oveja naccuve attufaemba atapoen. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Toya'caen oveja ppu'chotssianaccu tandange'je'fa'ninda Jacobja tsa qque'sho'cho quini'ccoma tsa'ccuma cui'je'ttinga dyaiña cuintsu tsa quini'ccoma atte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tsa'ma cuñosinaccu tandange'je'fa'ninda tsa quini'ccoma dyaiñambi. Tsa'cansi tsu du'shu cuñosija Labánmbe tsa'ma du'shu ppu'chotssiaja Jacobmbe. ");
INSERT INTO conNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Tsa'caen tsomba tsu Jacobja ñoa'me ricove dapa tsain'bio oveja, tsain'bio sema'su tsandiendeccu, pushesundeccuma'qque, tsain'bio cameyo, toya'caen tsain'bio boroma'qque an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Tsa'ma Jacobja tayo atesucho Labán dushundeccu tisene qquen su'choma: “Jacobja pa'cco ingi yayambema isupa tsai'ccu ricove da.” ");
INSERT INTO conNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Toya'caen tsu Jacobja atesu Labán tayoe tisema in'janqquia'caen in'jambipa chi'ga'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tsa'cansi Na'su Chigaja Jacobnga su: “Que yayandeccu andeni ccase jaja, que antiandeccu can'jeni. Ña gi fuitepa angaya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tsama pañamba Jacobja manda cuintsu Raquel, Leama'qque ttu'sesi ji'faye tise ovejandeccui'ccu can'jen'cho potreroni. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ji'fasi su: —Tayo gi atesu que'i yaya tayoe ñama in'janqquia'caen in'jambipa chi'ga'chove. Tsa'ma ña yayambe Chiga tsu anttembe'yi ñama fuite'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Que'i'qque qui atesu'fa ñajan tisu osha'fanga que yayambe ñotsse sema'jen'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tsa'caen semasi tiseja ñama afopoemba tsu anttembe'yi ña afepoen'choma cambi'bian. Tsa'ma Chiga Quitsaja se'pi cuintsu tise ñama egae tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nane que'i yaya ‘Ze'nzetssiai'ccu gi ñajan quenga afepoeña’ qquen susi poiyi'cco oveja tsu ze'nzetssia du'shuve isu'fa. Toya'caen ‘Chhifai'ccu gi ñajan quenga afepoeña’ qquen susi poiyi'cco tsu chhifave isu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tsa'caen tsu Chiga Quitsa tise'be'suma ñanga afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Toya'caen fae a'ta ovejandeccu foña'jen'ni anamba gi qquen ayo'o: atte gi oveja quitsaye ze'nzia, chhifa, pi'piayi pushei'ccu tandange'je'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tsa'caen ayo'o'je'ni tsu Chigama sefacconi'su shondo'su ña inisei'ccu ñama ttu'se. Ttu'sesi gi su: ‘Va'tti gi can'jen.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tsa'caen susi tsu Chigama shondo'suja su: ‘Ñotsse camba qui atteya poiyi'cco oveja quitsaye pushei'ccu tandange'je'cho tsu ze'nzia, chhifa, toya'caen pi'piayi. Nane tayo gi atte pa'cco Labán quenga tson'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ña gi quenga Betelni attian'cho Chiga. Nane tseni qui que asusupa ana'cho patuma ccutsiamba ñoa'me su'chove ñanga afa. Jangija, jinge jaye, quema isu'cho andeni.’–qquen tsu Chigama shondo'suja Chiga su'choma conda.” ");
INSERT INTO conNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tsa'caen susi pañamba Raquel, toya'caen Lea'qque su'fa: —Ingija jongoesu isuya'chove an'bian'fambi gi ingi yaya tsaoni. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nane tiseja faesu ande'suma'caen ingima tsincon. Toya'caen ingima chavaemba que ingima pusheye afepoen'choma tise'yi isupa sefaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tsa'cansi pa'cco ingi yaya an'bian'choma itsapa Chiga quenga afe'cho tsu ingimbe toya'caen ingi dushundeccumbe. Nane Chiga quenga tsa'caen su'choma pa'ccoma tsonjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tsa'caen susi tse'i Jacobja ñoñañe ashaen tise yaya Isaac can'jen'cho ande Canaánni jaye. Nane tise dushundeccu, tise pushendeccuma'qque cameyondeccunga otsian pa'cco tise an'bian'choma'qque. Tsa'caen tsomba tise aiña'chondeccu, Padan-aramni semamba gana'choma angaye ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Jacob tsa'caen jaye ashaenqui Labánjan biani can'jen tise oveja tosema chattu'su japa. Tsa'caen biani jacansi Raquelja tise yaya an'bian'cho ñoña'cho chigama cca'namba anga. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Tsa'caen tsu Jacobja arameo ande'su Labánga tisu jaya'choma condambe'yi ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nane pa'cco tisu an'bian'choma a'tutsseyi anga. Junde tsu Eufrates Na'ema cca'ya isepa tansintsse Galaad ccotta'cconga jaye ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tres a'ta pasasi Labánjan in'jan Jacob ccuyapa ja'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tsomba tise antiandeccui'ccu sombopa mandiañe ashaemba siete a'ta pa'cco japa Galaad ccotta'cconga nepi. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tsa'ma tsequi cose Chigaja ayo'oni, Labán, tsa arameo'su a'inga attiamba su: “¡Injama'tse! Jacobma iyicca'yeye'tsse afajama.” ");
INSERT INTO conNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob Galaad Ccotta'cconi toya can'jen'choma Labán nepipa cachui. Cachuipa Labán'qque tise antiandeccui'ccu tse'ttini can'jen'fa. Tsa'caen can'jemba ");
INSERT INTO conNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Jacobma su: —¿Jongoesie qui qquen tson? ¿Ma'caen qui ñama afopoemba ña onquengendeccuma an'bian geraemba indi'chondeccuma'caen? ");
INSERT INTO conNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Jongoesie qui ñama afopoenqquia'caen condambe'yi a'tutsse vani ccuyin ji? Nane que qquen jiya'chove atesu'choecan'da gi avujatsse ccosha, gitarai'ccu jeñamba can moeñe'can. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Toya'caen ña onquengendeccu ña jarichondeccuma'qque mochapa chigambiañe qui anttembi. Ñoa'me sumbia'caen qui tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nane ñoa'me gi ñajan que'ima egae tsoñe osha. Tsa'ma ja'ño cose tsu que yayambe Chiga ñama afapa qquen su: ‘¡Injama'tse! Jacobma iyicca'yeye'tsse afajama.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tsa'ma pashaen tisu yayani jaye in'jamba jayi'a'qque, ¿jongoesie qui ña chigandeccuma cca'namba i? ");
INSERT INTO conNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tsa'caen susi Jacobja Labánma su: —Dyojopa gi a'tutsse sombo, que ñama fi'ttipa tisu onquengendeccuma itsasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tsa'ma majan va'tti canjen'su que chigandeccuma an'bian'da, ¡cuintsu paja! Nane ingi antiandeccu tsu paña'jen'fa. ¡Tta'ttapa atteja jongoesu quembema ña an'bian'chove! Tsa'ma Jacobja Raquel tsa chigandeccuma cca'na'chove atesumbipa tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tsonsi Labán Jacob carpa tsa'onga ca'nimba tse'ttieja Leambenga'qque, toya'caen tsa dos sema'su pushesundeccumbenga'qque ca'nimba tta'tta'ma attembi. Lea carpa'ye sombopa Raquelmbenga ca'ni. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Toya ca'nimbi'ta Raquelja tsa chigandeccuma cameyonga ottaemba dyai'je'chombe tsosiccufa'su bosanga ppiñamba tsambe ombanga dyai. Labánjan tsa'caen ca'nimba pa'cco tsa'oma tta'tta'ma attembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tsonsi Raquelja su: —Yaya, ñama iyicca'yejama que caña'jen'ni jangiye oshambi gi tisu ñotssimbipa. Labán tsa'caen pa'cco ettima tta'tta nani'ma tisu chigandeccuve attembisi ");
INSERT INTO conNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacobja iyicca'yepa su: —¿Jongoesie gi egae tson'an? ¿Jongoesuma egae tsinconsi qui ñama mandiamba ji? ");
INSERT INTO conNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pa'cco ña an'bian'choma asitta'a'qque, ¿jongoesu quembema qui atte? ¡Va'ttinga tsama ccuiñajan! Tsonsi que antiandeccu, ña antiandeccu'qque tsu su'faya majan ingi ñotsse injienge'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nane veinte canqque'fa pa'cco quembe semamba ñotsse coirasi tsu majan ovejayi'qque ni chivo pusheyi'qque toya chu'ama cati'fambi. Ni fae oveja quitsayeveyi'qque gi que oveja naccu'suma ambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ttesi ovejama fi'tti'ni'qque queni imbi gi tsa pa'choma. Nane ñañi gi tsa qque'chone afepoen. Toya'caen maqui cose maqui a'ta que oveja naccu'suma cca'na'fa'ni'qque ñama qui tsane iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","A'taja coe'jenga gi pa'ma ccusha. Coseja chandi'supa gi pa'ma ccusha. Toya'caen anae'sui'ccu gi ata'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nane veinte canqque'fa pa'cco que tsaoni can'jensi qui tsa'caen ñanga tson. Catorce canqque'fa pa'cco gi que onquengendeccune sema. Toya'caen seis canqque'fa pa'cco que aiña'chondeccuma coiraye semasi qui anttembe'yi ña afepoen'choma cambi'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nane Abraham Chiga, tsa ña yaya Isaac iñajan'jen'cho Chiga ñai'ccu can'jembiecan'da qui ñama itsapa me'ccoe moeñe'can. Tsa'ma Chiga tsu ña ñombi'ye'cho, ña ñotsse sema'choma'qque attepa ja'ño cose quema tsa'caen iyu'u. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tsa'caen susi Labánjan Jacobnga su: —Pushesundeccuja ña onquengendeccu tsu. Dushundeccuja ña jarichondeccu tsu. Oveja'qque ña ovejandeccu tsu. Nane pa'cco va'ttima atte'choja ñambeyi tsu. Tsa'ma, ¿ma'caen gi va ña onquengendeccu, tise'pa an'bian'cho dushundeccuma'qque tsoña? ");
INSERT INTO conNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tsa'cansi jinge que ñai'ccu fae'ngae injanccoye tisupanaccui'ccu ingi'su ma'caen canseya'chove atesuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tsa'caen susi Jacobja patuma isupa tansintsse ccutsiamba ");
INSERT INTO conNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","tise antiandeccuma su: —¡Patuma boña'faja! Poiyi'cco tsu patuma fae'ttinga boñamba, tsa boña'cho pporotsse dyaipa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labánjan tse'ttima inisian, tise aya'fangae, Jegar Sahaduta. Jacob'qque, tisu aya'fangae, tse'ttima inisian Galaad. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Tsa'caen tsomba Labánjan su: —Ja'ñojan va patu boña'cho tsu ingi fae'ngae injancco'choma canjaeña. Tsa'camba tsu Galaad qquen va'ttija inisecho. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Toya'caen tsu inisecho Mizpa, Labán qquen su'ttipa: —Nane Na'su Chiga tsu ingima caña'jeña ingi fae'ngae can'jembi'ni'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ña onquengendeccuma que egae tsincon'ninda, tsambi'ta faesu pushesundeccuma pushe'ñacca'ninda ingi'suja me'i'oña tsu tsane afaye. Tsa'ma Chigayi tsu tsane afaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labán tsa'caen supa ti'tsse qquen afa'je: —Que canjan, va patu boña'cho, toya'caen patuma ingi ccutsian'cho ");
INSERT INTO conNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","tsu poiyi'cco canjaen'faya ingi va'ttima panshansa'ne. Nane que qui ñani panshamba ni ña gi queni panshamba iyiccoye osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Chiga Quitsa, tsa que yaya ccashe'ye Abraham, ña yaya ccashe'ye Nacormbe Chiga tsu ingima camba ingi ma'caen tson'chone afaya. Tsa'caen pañamba Jacobja, tise yaya Isaac iñajan'jen'cho Chiga paña'jen'ni tansintsse supa “Ñotssi tsu” qquen afa. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Tsa'caen tsomba Jacobja ccotta'cconga ansundepa Chiganga afeya'choma oque o'raemba tise antiandeccuma ttu'se cuintsu tseni an'faye. Ansundepa tseni amba cosesi tseniñi poiyi'cco ana'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ccaqui a'ta sinte'yi Labánjan jangipa tise jarichondeccu, tise onquengendeccuma'qque mochapa chigambiamba Chiga tise'panga ñotsse tsoña'chove afapa toequi tisu andeni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob ti'tsse tisu jayi'ningae jayi'ni Chigama sefacconi'su shondosundeccu tisema cachuiye sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacobja tsendeccuma attepa su: “Vandeccu tsu Chiga sefacconi'su sundarondeccu.” Tsa'caen supa tse'ttima inisian Mahanaim. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacobja condasundeccuma moe Edom ande'su Seir ccotta'cconi cuintsu Esaúma cachuipa conda'faye tise jiña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Esaúnga qquen su'faya'chove condapa moe: “Que antian Jacobja quema shondo'su tsu. Ingima tsu quenga manda qquen suye: Ñajan bo'tsse gi Labán tsaoni can'jemba ");
INSERT INTO conNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","atapoemba an'bian tsain'bio vaura, boro, oveja, sema'su tsandiendeccu, toya'caen sema'su pushesundeccuma'qque. Ña na'sunga gi tsa'caen su'faya'chove mandapa moe. Ronda'jeya gi que jisi mingae tsombe'yi avujatsse cachuiccoye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tsa'caen susi ja'chondeccu toequi jipa Jacobnga su'fa: —Que quindya Esaúni ingi ja'fasi tsu ja'ño tiseja jiña cuatro ciento a'i tisema fuitesundeccui'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tsama pañamba Jacobja ñoa'me dyopa asi'ttaeñe ashaen. Asi'ttaemba dos naccuve a'i tse'tti sheque'choma attufaen. Toya'caen oveja, vaura, cameyoma'qque tsa'caen attufaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nane qquen tsu in'jan: “Esaú jipa fae naccui'ccu iyiccopa patsu'ninda cuintsu faesu naccuja ccushaye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tsa'caen tsomba Chigama iñajañe ashaemba qquen su: “Na'su Chiga, ña yaya ccashe'ye Abraham, ña yaya Isaacmbe Chiga qui. Que qui ñama su ña toequi tisu andeni, tisu antiandeccuni ja'ni'qque queja ñama ñotsse tson'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ñajan ñotssimbi'ma qui anttembe'yi ñama tsa'caen in'jamba ñotsse tson. Ñajan vane jayipa Jordán na'ema fae accuicco'choi'ccuyi gi ise'a. Tsa'ma ja'ñojan tsain'bio a'i dos naccuve gi an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Chigáne ña antian Esaú fi'ttisa'ne ñama ccushaenjan. Ñoa'me gi dyojo tise jipa ingima patsupa pushesundeccu, dushundeccuma'qque fittittisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Que qui ñoa'me a'tatsse ñanga conda ñama ñotsse tsomba ña omba'su dushundeccune'qque tsain'bitsse atapa'faya marni'su sisipa sheque'choma agattoye oshambiqquia'cantsse.” ");
INSERT INTO conNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tsequi cose Jacobja tse'ttingayi ana. Ana a'tapa tise tse'tti an'bian'cho'suma tise quindya Esaúnga afeya'chove qquen isu: ");
INSERT INTO conNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","dosciento chivo pushe, veinte chivo quitsaye, dosciento oveja pushe, veinte oveja quitsaye, ");
INSERT INTO conNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","treinta cameyo pushe chochopa tise'pa dushundeccui'ccu, cuarenta vaura pushe, diez vaura quitsaye, veinte boro pushe, toya'caen diez boro quitsaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Tsa'caen isupa tise'be semasundeccunga attufaemba fa'enga fae naccu, faesunga tsa'caen afe'jepa su: —Fae naccu faesu naccuma biaccaccatsse ñoñamba tsa'caen ña otufanga ja'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Otufani ccutsuya'choma qquen manda: —Ña quindya Esaú quenga nepipa qquen iñajampaña'ninda: ‘¿Majan tsu que na'su?’ ‘¿Mani qui jayi?’ toya'caen, ‘¿Majambe aiña'chondeccu tsu vaja?’ —qquen iñajampaña'ninda ");
INSERT INTO conNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","queja qquen suja: ‘Vaja quema shondo'su Jacob quenga afeya'cho tsu, ña na'su Esaú. Tiseja ñoa'me tsu ingi sepaccofae jiña.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Toya'caen sepaccofani ccutsuya'cho, vacca'tti ccutsuya'cho, nane poiyi'cco afeye angasundeccunga qquen su: —Que'i'qque Esaúma cachui'ta tsa'caeñi supa ");
INSERT INTO conNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","toya'caen: ‘Quema shondo'su Jacob ingi sepaccofae jiña’ —qquen su'faja. Nane Jacobja qquen asi'ttaemba tsa'caen tson: “Afe'choma otie moemba tise ñoquisi gi cambajunaccu tisei'ccu cachuiccoya. Isha tsu ña tsa'caen tsonsi ñama ñotsse tsona.” ");
INSERT INTO conNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tsa'caen asi'ttaemba afe'choma angasundeccuma o'tie moe. Tsomba tiseja tse'ttingayi ana. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tsequi cose'yi Jacobja jangipa tise dos pushe, tise dos sema'su pushesundeccu, tise once dushundeccui'ccu japa Jacob na'en'su sinjunccuma ise. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pa'cco tise an'bian'choma'qque fae'ngae isian. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tsa'caen pa'ccoma isiamba tisuyi can'jen'ni fae tsandie, a'iacan'choa tisei'ccu iyiccoye ashaen a'tatsse. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tsa'ma tsa a'i Jacobma patsuye oshambi qquen in'jamba Jacob tsimbochoccuma tssai. Tsa'caen tssaisi tsimbochoccu'su tsu'ttaja batti. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tsa'caen tsomba tsa a'ija su: —Antteja tayo tsu a'taye tson'jen. —Que ñama ñotsse tsoña'chove afambi'ninda antteya'bi gi –qquen tsu su Jacobja. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tsonsi a'ija iñajampaña: —¿Jongoesu inise qui? —Ña gi Jacob–qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tsa'caen susi a'ija su: —Ti'tsse quema Jacob qquen afambipa Israel qquen tsu afa'faya. Nane queja Chigai'ccu, aindeccui'ccu iyiccopa patsusi tsu tsa'caen quema afa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tsonsi Jacobja ccane'qque iñajampaña: —Ja'ño condaja jongoesu inise qui queja. Tsa'ma tsa a'ija su: —¿Jongoesie qui ña iniseve iñajampaña? Tsa'caen supa tsa a'ija tse'ttingayi Chiga tisema ñotsse tsoña'chove afa. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Afasi Jacobja: “Tayo Chigama cambajunaccu atte'ma gi toya canse”–qquen supa tse'ttima inisian Penuel. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Chiga sombo ji'ni Jacobja Penuelma panshamba tise tsimbochoccu iñesi ccaré jaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tsa'cansi tsu ja'ño'su israendeccu'qque aña'cho'su tsimbochoccu'su tsain'fama añe osha'fambi, Chiga Jacobma tsesu'tte tssai'chosi. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacobja Esaú cuatrociento a'i'ccu jiña'choma attepa tise du'shuma attufaen tise'pa mamandeccui'ccu, nane Lea, Raquel, toya'caen tsa dos sema'su pushesundeccui'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","O'tie tsu dos sema'su pushesundeccuma tise'pa dushundeccui'ccu ccutsian. Tsendeccumbe sepaccofanga Leama tise dushundeccui'ccu ccutsian. Tsutopani Raquelmajan tise du'shu Joséi'ccu ccutsian. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tsa'caen tsomba tsendeccumbe otufanga japa siete se andenga puntssa'ñacca tise antianga catseye jayi. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tsa'ma Esaúja Jacobma attepa buttoin jipa munsin ancamba mocha. Tsa'caen tsomba poiyi'cco fae'ngae i'na'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","I'na pasapa Esaúja pushesundeccu, dushundeccuma'qque attepa iñajampaña: —Vandeccuja, ¿ma'candeqquia tsu? Tsonsi Jacobja su: —Chiga quema shondo'suma ñotsse in'jamba afe'cho dushundeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tsonsi dos sema'su pushesundeccuja tise'pa dushundeccui'ccu catsepa andenga puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Omboe Leaja tise dushundeccui'ccu catsepa tsa'caeñi puntssan'fa. Tsambe omboe José, tise mama Raqueli'ccu catsepa tsa'caeñi tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tse'faei'ccuyi Esaúja iñajampaña: —¿Ma'caen tsoñe qui in'jan tsa tsain'bitssi naccuve ña jiñamba atte'choma? Tsa'caen iñajampañasi Jacobja su: —Tsata tsu que ñama ñotsse tsoñe afe'je'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tsa'ma Esaúja su: —Me'in, ña antian, nanitsse gi ña'qque an'bian. Quembema queyi an'bianjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tsa'ma Jacobja ccase su: —Me'in, que ñama ñotsse in'jan'da, chigáne tsa afe'choma isuja. Nane que tayo ñama ñotsse chigambiamba in'jansi gi avujatsse Chigama atteqquia'caen quema atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tsa'cansi gi iñajan quenga afeye i'choma isuja. Nane Chiga tsu ñama ricove tsonsi gi osha'choma shacambitsse an'bian. Tsain'bitsse tsa'caen iñajansi Esaúja tsa afe'choma in'jamba isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Isupa su: —Ñotssi tsu. Jinge va'ttie jaye. Ñajan quema o'tie gi jaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tsa'ma Jacobja su: —In'jan'cho antian, que'qque qui atesu du'shuja oshaya'bi. Toya'caen oveja suri, vaura surimanda tsu in'jaña'cho. Nane quian'me anga'nijan junde tsu quimbipa fae a'tayi poiyi'cco oveja paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Bove ñotssi tsu queja injanga quema shondo'suma o'tie jaye. Tsonsi ñajan vasia've ma'caen ñama o'tie jayi'cho aiña'cho, toya'caen dushundeccu oshaqquia'caen jipa quema Seirni cachuiya. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tsonsi Esaúja su: —Ñotssi tsu. Tsa'ma antteja ñai'ccu ji'cho aindeccu'suma quenga catiye cuintsu quema fuite'faye. Tsa'ma Jacobja su: —Me'in, quema noñangiañe in'jambi gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tsequi a'tayi Esaúja toequi Seirni ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tsa'ma Jacobja Sucotni ja. Tse'ttinga tisumbe tsao'ñamba aiña'cho ttuccuve'qque ñoña. Tsa'cansi tsu tse'ttima inisian Sucot. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacobja Padan-aramne sombopa quinsetssi mingae dambe'yi Canaán andeni nepipa Siquem canqque pporotsse tise carpama ccutsian. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nane cien corifin'di'ccu Hamor dutssiyendeccuma andeve chava tseni tise carpama ccutsiañe. Siquem'qque tsu Hamor dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Can'jemba tsu Chiganga afe'jeya'chove ñoñamba inisian El-Elohe-Israel. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Tsa'caen can'jemba, Dina, tsa Lea Jacobmbe isu'cho onque'ngeja tsa ande'su chu'a pushesundeccuni pasia'su ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tsa'caen jasi Hamor dutssi'ye, Siquem, tisema atte. Tsa Hamorja, heveo'su a'i tsu tsa canqque na'su. Siquemjan Dinama attepa cunshangopa indipa tisei'ccu ccuipa egae tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tsa'ma tsa'caen tsomba Siquem ñoa'me Dinama ñotsse in'jamba osha'choma tson cuintsu ccane'qque tise've in'jañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Toya'caen tise yaya Hamorma Siquemjan su: —Tise yayanga japa iñajanjan. Va pushesuma gi pusheye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacobja tayo tise onque'nge Dinama Siquem egae tson'chove atesu'ma afambi tise dutssiyendeccu ccani oveja coira'su japa can'jene jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tsa'caen can'jeni Siquem yaya Hamorja Jacobni ja tisei'ccu afaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tsa'ma Jacob dutssiyendeccu tise'pa coiraye japa can'jene jipa tise antianma tson'choma atesupa ñombi'yepa ñoa'me iyicca'ye'fa. Nane Siquem tsa'caen Jacob onque'ngei'ccu ccuipa ñoa'me tsu Israel a'ima egae tson. Israendeccu'sumajan tsa'caen tson'masia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tsa'ma Hamorja tsendeccui'ccu afapa su: —Ña dutssi'ye Siquem tsu ñoa'me in'jan que'i antianma. Chigáne antte'faja cuintsu tisema tsa'nduye. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tsa'caen tsomba ingi antiandeccuve da'faja. Tsonsi ingi'suja que'i onquengendeccuma pushe'je'faye. Toya'caen que'i'qque ingi'su onquengendeccuma pushe'je'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ingi'ccu tsangae canse'faja. Pa'cco va ande tsu que'imbe. Vani can'jemba, chavaemba ganamba andema chava'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Toya'caen Siquem'qque Dina yayanga, pushesu antiandeccunga'qque su: —Chigáne ñama in'jamba que'i antianma ñanga afe'faja. Jongoesuve in'jamba iñajan'ninda gi afeya. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nane que'i ma'caen atesucho'choma ti'tsse iñajamba faesu afe'chove iñajan'ni'qque gi tsa'caen afeya. Tsa'ma antte'faja cuintsu que'i antian ñama tsa'nduye. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tsa'ma Siquem Dinama egae tson'chosi in'jamba Jacob dutssiyendeccuja Siquem, tise yaya Hamornga'qque aqquia afopoemba ");
INSERT INTO conNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","qquen su'fa: —Ñoa'me osha'fambi gi ingi antianma chhiyitevaembi'choa tsandienga antteye. Nane tsa'caen tsoñe tsu ingine'ja egae tsincon'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Qquen tsoña'ccoyi tsu que ingi in'janqquia'caen tsoña'cho poiyi'cco que'i ingia'caeñi daye. Nane poiyi'cco que'i'su tsandiendeccu tsu ingia'caen chhiyitevaenge'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tsa'caen tson'da qui que'i'qque ingi dushundeccuma pushe'faya. Toya'caen ingi'qque que'i dushundeccuma pushe'faya. Tsomba gi que'i'ccu cansepa fae naccuve da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tsa'ma ingi mandaqquia'caen chhiyitevaembian'da va'ttie sombopa gi ingi antianma'qque ccani anga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tsama pañamba Hamor, tise dutssi'ye Siquem tsa'caen tsoñe ñotssi qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nane ti'tsse canjenccambe'yi Siquemjan tsa'caen tsoñe ashaen Jacob onque'ngeme in'jamba. Siquemjan tise yaya dutssiyendeccu'su ti'tsse'tssiapa ");
INSERT INTO conNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","tise yaya Hamori'ccu canqqueni cani'jen'ttinga ja faengasundeccui'ccu condaseye. Japa qquen su: ");
INSERT INTO conNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Va aindeccu ingi amigondeccupa tsu vani cansepa chavapa chavaen'jen'faya. Tsain'bio ande tsu jin cuintsu tsendeccu can'jensi ingija tise'pa dushundeccuma pusheye; toya'caen tise'pa'qque ingi dushundeccuma pushe'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tsa'ma tsendeccu ingi'ccu cansepa fae naccuve daye in'jan'ninda ingi tise'pa suqquia'caen tsu tsoña'cho. Poiyi'cco ingi'su tsandiendeccu tsu tise'pa atesuqquia'caen chhiyitevaenge'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tsa'caen tson'ninda tsu pa'cco tise'pa an'bian'cho tise'pa aiña'cho'qque ingimbeve'qque daya. Tsa'cansi jinge tise'pa in'janqquia'caen tson'faye cuintsu ingi'ccu canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hamor, tise dutssi'ye Siquem tsa'caen susi poiyi'cco tsa canqque'su tsandiendeccu tsa'caen in'jamba tsendeccu suqquia'caen chhiyitevaenge'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tsa'ma tres a'ta pasasi Jacob dutssiyendeccu, Simeón, toya'caen Leví, tsa Dina quindyandeccu tsu canqqueni ja'fa. Toya tsandiendeccu tise'pama chhiyitevaen'cho iñesi jangiye osha'fambisi matichi'ccu poiyi'cco tsendeccuma fittitti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nane matichi'ccu Hamor, tise dutssi'ye Siquema'qque fi'ttipa Dinama Siquem tsa'o'ye somboemba anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tsonsi Jacob faesu dutssiyendeccu'qque tseni nepipa pa'chondeccu ai'voma panshamba pa'cco tsa canqqueni jincho'choma cca'namba somboen'fa. Tise'pa antianma egae tson'chone tsu ccane'qque tsa'caen tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Toya'caen oveja, vaura, boro, pa'cco tsa canqqueni jincho, potreroni can'jen'chondeccuma'qque anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nane pa'cco tsaoni bare'cho jinchoma somboemba pa'cco dushundeccu, pushesundeccuma'qque indipa anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tsa'caen tson'fasi Jacobja Simeón, Levíma su: —Que'ija tsa'caen tsomba qui tayo ñama daño'fa. Ja'ño tsu va andeni canjensundeccu, tsa cananeondeccu, ferezeondeccu'qque ñama chi'ga'faya. Tsa'caen chi'gapa tisupanaccu bopa ñai'ccu iyiccoye ashaen'faya. Ñajan tsain'bitssi a'ive an'biambisi tsu ñama fi'ttipa poiyi'cco ñai'ccu canjensundeccuma fi'tti'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tsa'ma dutssiyendeccuja su'fa: —¿Ñotssi ti tiseja ingi antianma tsa'caen tisu ai'voi'ccu gana'su pushesuma'caen tsoñe? ");
INSERT INTO conNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Chiga Jacobma su: “Jangipa Betelni japa tseni canseja. Tseni japa Chiganga afe'je'chove ñoñajan. Nane que antian Esaúma dyopa ccuyapa jayisi quenga attian'cho Chiganga afe'je'chove ñoñajan.” ");
INSERT INTO conNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tsa'caen susi pañamba Jacobja tisu antiandeccu toya'caen poiyi'cco tisema fuitesundeccuma'qque qquen afa: —Pa'cco que'i an'bian'cho faesu chigama somboemba catipa tisupa'qque onjomba faesu giya'tssiama ondiccu'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Junde tsu Betelni jaya'cho. Tseni japa gi Chiganga afe'je'chove ñoñamba ña vana'jensi fuite'su Chigama iñajaña. Nane tise tsu ña mani jacan'ni'qque ñama fuitepa angacan. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tsonsi poiyi'cco tise'pa an'bian'cho faesu chigama Jacobnga afe'fa. Toya'caen tise'pa sasiyoma'qque Jacobnga afesi tiseja pa'ccoma isupa pa'cco tsama a'tu Siquem canqque pporotssi'su roble quini'jin tsosiccunga. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tsa'caen a'tupa tsa canqque'ye sombo'fasi Chigaja poiyi'cco tse'tti pporotsse canjensundeccuma dyo'faya'chove in'jaen cuintsu Jacob dushundeccuma mandiambe can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob toya'caen poiyi'cco tisei'ccu jasundeccu Luz canqqueni nepi'fa. Tsa canqqueyi tsu Betel qquen inisecho'cho, Canaán ande'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tseni nepipa Chiganga afe'je'chove ñoñamba tse'ttima inisian El-betel. Nane tise antianma dyopa jayisi Chiga tse'ttinga attian'chosi tsu tsa'caen inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Toya'caen tse'ttinga tsu Rebecama coira'su pushesu, Débora'qque pa. Pasi Betel pporotssi'su roble quini'jin tsosiccunga a'tu'fa'cho. Jacobja tse'ttima inisian “Roble quini'jin inamba'tti.” ");
INSERT INTO conNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tsa'caen Jacob Padan-aramne sombopa tseni jisi Chigaja ccase tisenga attiamba tisenga ñotsse tsoña'chove ");
INSERT INTO conNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","qquen afa: “Queta qui Jacob ‘A'tutsse afopoen'su’ qquen su'cho. Tsa'ma ja'ñojan ti'tsse tsesuya'bi qui. Ja'ño a'ta ashaemba tsangae qui Israelve daya ‘Chigai'ccu iyicco'su’ qquen su'chove.” Tsa'caen tise inisema cambiamba Chigaja ");
INSERT INTO conNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ti'tsse qquen su: “Ña gi Osha'choma Oshacho'cho Chiga. Tsain'bitssi du'shuve an'biamba qui omba'su dushundeccuve'qque tsain'bitsse atapaja. Nane que'ye tsu tsain'bio aindeccuve sombopa fae naccuve da'faya. Tsa que omba'su dutssiyendeccu'su tsu nasundeccuve da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Va ande tayo Abraham Isaacnga afe'cho andeveyi gi quenga'qque afeya. Toya'caen gi que omba'su dutssiyendeccunga'qque afeya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Jacobi'ccu afa nanimba Chiga tsse'ttie jasi, ");
INSERT INTO conNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacobja patuma isupa tansintsse ccutsian tsa Chiga tisei'ccu afapa ja'ttinga. Tsomba aseite, vinoi'ccu patunga fiñamba fetipa ");
INSERT INTO conNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","tse'ttima inisian Betel. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Can'jemba Betelne sombo'fa Efratani jaye. Tsa'ma toya Efratani nepimbi'te Raquel du'shuma isuya'cho nepi. Nane ñoa'me vanamba isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nane ñoa'me vana'jensi tisema fuite'suja su: “Dyombe canjan. Faesu tsandie du'shuve qui isu.” ");
INSERT INTO conNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tsama pañamba Raquelja ñoa'me paye tson'jemba du'shuma inisian Benoni “Ña vana'cho du'shu” qquen suye. Tsa'ma tise yaya Jacobja tisema inisian Benjamín “Ña tansinfa'su du'shu” qquen suye. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tsa'caen Raquel pasi Efrata'su tsaiquinga a'tu'fa. Tsa tsu ja'ñojan Belén. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tsa'caen a'tupa Jacobja pa'choma injan'jeña'cho patuve tsa atu'ttinga ñoña. Tsa ñoña'cho tsu ja'ño pán Raquelma atu'ttive canjaen'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israelja tisu jayi'ningae japa Edar'su ccotta'ccoma pashamba tse'ttinga canqquian. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tsa'caen Israel tse'ttini canqquiamba can'jensi Rubénjan tise yaya ambian'cho pushesu Bilhai'ccu ccuipa egae tson. Tsa'caen tson'choma pañamba Israelja ñoa'me iyicca'ye. Jacob dutssiyendeccu tsu doce tsandie du'shu. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leanga du'sian'cho tsu aisheja Rubén, tse'ttija Simeón, Leví, Judá, Isacar toya'caen Zabulón. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquelnga du'sian'cho tsu José toya'caen Benjamín. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquelmbe sema'su pushesu Bilhanga du'sian'cho tsu Dan toya'caen Neftalí. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Toya'caen Leambe sema'su pushesu Zilpanga du'sian'cho tsu Gad toya'caen Aser. Vandeccu tsu Jacob dutssiyendeccu Padan-aram andeni isu'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacobja tise yaya Isaacma can'su ja Mamre canqqueni. Tsayi tsu inisecho'cho Arba, toya'caen Hebrón. Tse'tti tsu Abraham'ye Isaac'qque can'jemba'tti. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaacja ciento ochenta canqque'fave an'biamba coenza ccashe'yeve dapa pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Papa tise tayopi'su coenzandeccu Chiga sefacco can'jeni ja. Tsa'caen pasi tise dushundeccu Esaú toya'caen Jacob tisema a'tu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Vandeccu tsu Esaú omba'su dushundeccu. Nane Esaú faesu inise tsu Edom. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaúja Canaán ande'su pushesundeccuma pushe. Fae'cco tsu hitita'su a'i Elón onque'nge Ada. Faesu tsu Aholibama. Tsa tsu heveo'su a'i Zibeon dutssi'ye Aná onque'nge. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Toya'caen faesu tsu Ismael onque'nge Basemat. Tsaja Nebaiot antian. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adanga Esaú du'sian'cho tsu Elifaz. Basematnga du'sian'cho tsu Reuel. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Toya'caen Aholibamanga du'sian'cho tsu Jeús, Jaalam toya'caen Coré. Vandeccu tsu Esaú toya Canaán andeni can'jeinte du'sian'chondeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaúja tise antian Jacob'ye joqquitssiye in'jamba poiyi'cco tise pushendeccu, tise dutssiyendeccu, onquengendeccu toya'caen poiyi'cco tisei'ccu canjensundeccuma'qque ccani anga. Pa'cco tise Canaán andeni can'jemba gana'cho toya'caen tise atapoen'cho aiña'choma'qque anga. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nane dos tsa'caen tsain'bitsse an'biamba osha'fambi fae'tti can'jeñe. Toya'caen tise'pa can'jen'cho ande'qque poimbe aiña'chondeccu an'jeña'chove nepimbi. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tsa'cansi Esaú, tsa Edomjan, ccotta'cco'su Seir andeni canseye ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Vandeccu tsu Esaú omba'su dushundeccu ccotta'cco'su Seir andeni cansesundeccu. Esaú omba'su dushundeccuma tsu inisian'fa edomitandeccuve. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Va tsu Esaú dutssiyendeccu inise: Tise pushe Ada du'shu, Elifaz; tise pushe Basemat du'shu, Reuel. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz dushundeccu tsu Temán, Omar, Zefo, Gatam toya'caen Cenaz. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Toya'caen Elifaz tise ambian'cho Timnanga du'sian'cho tsu Amalec. Vandeccu tsu Esaú pushe Adambe omba'su dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel dushundeccu tsu Nahat, Zera, Sama toya'caen Miza. Vandeccu tsu Esaú faesu pushe Basemat omba'su dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Toya'caen Esaú faesu pushe Aholibama dushundeccu inise tsu Jeús, Jaalam toya'caen Coré. Aholibama tsu Zibeón dutssi'ye Aná onque'nge. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaú omba'su dutssiyendeccumbe nasundeccu tsu qquen: Esaú dutssi'ye coenza Elifaz dutssiyendeccumbe nasundeccu tsu Temán, Omar, Zefo, Cenaz, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam toya'caen Amalec. Tsendeccu tsu Elifaz dutssiyendeccu, Edom andeni'su nasundeccu. Poiyi'cco tsu Esaú pushe Ada omba'su dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú dutssi'ye Reuel dutssiyendeccumbe nasundeccu tsu Nahat, Zera, Sama toya'caen Miza. Tsendeccu tsu Reuel dutssiyendeccu, Edom andeni'su nasundeccu. Poiyi'cco tsa Esaú pushe Basemat omba'su dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Toya'caen Esaú pushe Aholibama, tsa Aná onque'nge dushundeccumbe nasundeccu tsu Jeús, Jaalam toya'caen Coré. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Poiyi'cco tsendeccu tsu Esaú, tsa Edom, aindeccu'su nasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Horeo'su Seir aindeccu tseni canjensundeccu tsu Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer toya'caen Disán. Vandeccu tsu horeo'su nasundeccu, tsa Edom ande'su Seir omba'su dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán dushundeccu tsu Hori toya'caen Hemam. Lotán que'tte tsu Timna. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal dushundeccu tsu Alván, Nanahat, Ebal, Sefo toya'caen Onam. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeón dutssiyendeccu tsu Aja toya'caen Aná. Tsa Aná tsu tise yaya Zibeón borondeccuma a'i menia coira'jepa tsa'ccu sombo'ttima atte'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná dutssi'ye tsu Disón, tise onque'ngeja Aholibama. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disón dutssiyendeccu tsu Hemdán, Esbán, Itrán toya'caen Querán. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer dutssiyendeccu tsu Bilhán, Zaaván toya'caen Acán. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disán dutssiyendeccu tsu Uz toya'caen Arán. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeondeccu'su nasundeccu tsu Lotar, Sabal, Zibeón, Aná, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer toya'caen Disán. Tsendeccu tsu Seir andeni canjen'su Horeo antiandeccu'su nasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israendeccu toya na'suve ccutsiambi'te tsu vandeccuja Edom ande'su nasundeccuve dapa manda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","O'tie tsu Beor dutssi'ye Belaja Edom na'su. Tise canqque tsu Dinaba qquen inisecho'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela pasi tsu Bosra canqque'su Zera dutssi'ye Jobabja na'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab pasi Temán ande'su Husam na'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam pasi Bedad dutssi'ye Hadad na'suve da. Tiseja Moabni japa Madián aindeccuma patsu'su. Tise canqque tsu Avit qquen inisecho'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad pasi Masreca canqque'su Samla na'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla pasi Rehobot canqque'su Saúl na'suve da. Tsa Rehobot canqque tsu na'en otafani. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl pasi Acbor dutssi'ye Baal-hanán tsu na'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanán pasi Pau canqque'su Hadadja na'suve da. Tise pushe tsu Mehetabel, tsa Mezaab dutssi'ye Matred onque'nge. ");
INSERT INTO conNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Vandeccu tsu Esaú dutssiyendeccu'su antiandeccumbe inise. Nane tise'pa inise tsu tise'pa canqque inise toya'caen tise'pa aindeccumbe inise: Timna, Alva, Jetet, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO conNTpo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel toya'caen Iram. Esaú faesu inise tsu Edom. Tsendeccu tsu Edom'su nasundeccu. Tise'pa can'jen'cho ande tsu tise'pa iniseningae inisian'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacobja tise yaya canse'pani'su Canaán andeni canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jacob dutssiyendeccune condase'cho tsu qquen: Joséja diez y siete canqque'fave an'biamba tise yaya ambian'chondeccu isu'cho dushundeccui'ccu fae'ngae ovejama coira'je. Nane Bilha dutssiyendeccu, Zilpa dutssiyendeccui'ccu coira'jepa tsendeccu egae tsincon'choma Joséja tise yayanga conda'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israelja poiyi'cco faesu tise dushundeccuma ti'tsse tsu Joséma in'jan nane tise coenza ccashe'yeve dasi isu'chosi. Tsa'camba ñotssia ondiccu'jeve tise'be anchon. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tsa'ma tise quindyandeccuja tise'pama ti'tsse tise yaya Joséma in'jansi attepa tisupa antianma chi'gaye ashaemba ni chigambian'boeyi'qque chigambian'jen'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Fae cose Joséja ayo'opa tise quindyandeccunga condase. Tsa'ma tsendeccuja ti'tsse tisema chi'ga'fa ");
INSERT INTO conNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","qquen condasesi pañamba: —Paña'faja ña tisu ayo'o'choma que'inga condasesi. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Poiyi'cco gi nasipani sema'jemba trigoma taipa tandan'jen'fa. Tse'faei'ccuyi tsu ña tandan'choja jangipa na'sia'caen tansintsse ccutsu. Tsa'ma que'i tandan'choja ñambenga shoquendi'e ccutsupa utu'ccoandeqquia'caen ñambenga puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tsa'caen susi tise quindyandeccuja su'fa: —¿Ingi na'suve dapa ingima mandaya qquen ti qui in'jan? Tsa'caen supa ti'tsse tisema chi'ga'fa. Nane tise tsa'caen ayo'opa toya'caen patsuqquia'caen dyombe tsama condasesi tsu ti'tsse tisema chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Can'jemba Joséja ccase ayo'opa tsama'qque tise antiandeccunga qquen condase: —¿Atesu'fa ti qui ccase gi ayo'o? Nane coejechiga, cose'suchiga, toya'caen once o'fe'qque ñanga puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","José tsa'caen tise quindyandeccunga, tise yayanga'qque condasesi pañamba tise yayaja iyu'upa qquen su: —¿Jongoesune qui tsa'caen ayo'o? ¿Tsui'da ti gi que mama, que antiandeccu, ña'qque quenga puntssan'faya? ");
INSERT INTO conNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tise quindyandeccuja tisupa injamáchoni tisema ti'tsse se'pi'fa. Tsa'ma tise yayaja tsa ayo'o'chone tsain'bitsse asi'ttaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","José quindyandeccuja Siquemni ja'fa tise yaya ovejandeccumbe shoshovive ttatta'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tsa'caen japa canjen'fasi Israelja Joséma su: —Que canjan, que quindyandeccuta tsu Siquemni oveja coira'su japa can'jen'fa. In'jan gi que japa can'gaye. Joséja su: —Ju, avujatsse gi jaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tsonsi Israelja su: —Ñotssi tsu. Japa que quindyandeccuma attepa ovejandeccuma'qque attepa ñani jipa condaja. Israel Hebron'su sinjunccuni can'jemba mandasi Joséja japa Siquemni nepipa ");
INSERT INTO conNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","quindyandeccuma attembipa injanga tta'ttá jacan. Tsa'caen injanga jacan'ni fae a'i tisema cachuipa iñajampaña: —¿Jongoesuve qui ttattacan? ");
INSERT INTO conNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joséja su: —Ña quindyandeccuve gi ttattacan. ¿Queta ti qui condaye osha mani tise'pa ovejama coira'je'chove? ");
INSERT INTO conNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tsonsi a'ija su: —Tayo tsu va'ttie ja'fa. Paña gi “Dotánni jayi” qquen su'fa'choma. Tsa'caen susi Joséja tta'tta japa Dotánni tise quindyandeccuma cachui. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tsendeccuja toya biane jiña'choma attepa toya tise catsembi'te tisema fi'ttiya'chove in'jamba ñoña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nane tisupanaccu qquen afacco'fa: —Que can'faja, ¡jovoe tsu ayo'suja jiña! ");
INSERT INTO conNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tise jisi jinge fi'ttiye. Fi'ttipa tise ai'voma posonga ttova catipa ‘Ttesi an’ qquen jinge su'faye. Tsa'caen tsomba jinge atesuye tise ayo'opa ma'caen da've'se. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tsa'caen su'fasi pañamba Rubénjan tise quinshinma ccushaeñe in'jamba qquen su: —Jinge fi'ttimbe can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ni tise anjampama tssañambe can'faye. Va a'i menia jincho posonga amppian moe'faja. Tsa'ma tisema mingae tsombe'yi can'faja. Rubénjan tise quinshin Joséma ccushaemba toequi tise yayani moeñe in'jamba tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tsa'ma José tise quindyandeccunga nepisi tsendeccuja tise ñotssia ondiccu'jema oshichhaemba ");
INSERT INTO conNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","indipa tsa'ccu me'choa posonga tisema amppian moe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Omboe (Rubén ccani jasi) tsa poso jin'ttinga añe dyai'fa. Tsa'caen an dyaipa cameyondeccu jiña'choma atte'fa. Nane tsa ismaelitandeccu tsu tise'pa cameyonga ñome'ba, balsa'mo seje'pa toya'caen mirra seje'pama'qque Galaad andene iña'fa Egipto andeni angaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tsama attepa Judája tise antiandeccunga su: —¿Jongoesuma gi gana'faya ingi antianma fi'ttipa tise pa'chone a'tie'an'qque? ");
INSERT INTO conNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nane bove ñotssi tsu fi'ttimbe'yi jova ismaelitandeccunga chavaeñe. Nane ñoa'me ingi antian tsu. Tsa'caen susi tise antiandeccu'qque Judá in'janqquia'caen fae'ngae in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tsa'caen in'jamba tsangae madianita'su chavaensundeccu jiña'fasi José quindyandeccuja Joséma poso'ye somboemba chavaen'fa tsa ismaelitandeccunga veinte totoacori corifin'dive. Tsa'caen chavaen'fasi Joséma Egiptoni anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tsa'caen tson'fa'chove atesumbipa Rubénjan toequi posoni jipa Joséve attembipa tise ondiccu'jema chitta tisu ñombi'ye'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Tsa'caen tsomba tise antiandeccuni jipa qquen su: —Tsa du'shuveja me'i'on tsu. Ja'ñojan, ¿ma'caen gi tsoña? ");
INSERT INTO conNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tsa'caen susi tisenga condapa José ondiccu'jema isupa tisupa fi'tti'cho chivo anjampai'ccu ondiccu'jema onjoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Onjoemba tise yayani moe'fa qquen su'choi'ccu: “Vaveyi gi atte'fa. Ñotsse camba in'janjan, ¿vata ti que du'shu José ondiccu'jembi?” ");
INSERT INTO conNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacobni nepisi tsama attepa su: “Ju, ña du'shu ondiccu'je tsu. Nane ttesi tsu tisema fi'ttipa an.” ");
INSERT INTO conNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tsa'caen supa Jacobja tisu ondiccu'jema chittapa pasi ñombi'ye'choma canjaenqque'su ondiccu'jema ondiccu. Tsa'caen ondiccupa tsain'bio a'ta tise dutssi'ye pa'chone inambani canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Inambani cansesi tise dutssiyendeccu onquengendeccu'qque tisema ziyaemba vuiquiañe in'jan'fa. Tsa'ma tiseja tsa'caen vuiquian'faya'chove in'jambipa tise dutssi'yene ina'jemba qquen su: “Papa pa'chondeccu can'jeni japa tisei'ccu cachuiccoya'ngae gi qquen ñombi'yepa inambani canseya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Egiptoni japa madianitandeccuja Potifarnga Joséma chavaen'fa. Nane Potifarja Egipto'su na'su faraónma shondo'su tsu. Na'su faraóni'ccu pporotsse ccutsu'su sundarondeccumbe capitán tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tseite Judája tise antiandeccu'ye joqquitssipa Adulam canqque'su a'i Hira tsaoni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tseni can'jemba cananeo'su a'i Súa onque'ngema attepa tsama pushe. Tisei'ccu can'jensi ");
INSERT INTO conNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","surie dapa tsandie du'shuve isusi tsa du'shuma inisian Er. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Can'jemba ccase surie dapa faesu tsandie du'shuve isusi tsa du'shuma inisian Onán. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Toya'caen ccase faesu tsandie du'shuve isusi tisema inisian Sela. Nane Judá Quezibni can'jen'ni tsu Selama isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Dutssi'ye coenza Er coensi Judája fae pushesu Tamarnga tisema antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tsa'ma Na'su Chigaja Er egae tsincomba cansesi chi'gapa tisema fi'tti. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Er pasi tise yaya Judája Onánma su: —Que quindya'ye pa'nijan tsa panjen'choma pushepa du'sianjan cuintsu que quindya'ye'qque omba'su dushundeccuve an'biañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tsa'ma Onánjan du'siansi tsa du'shuja tise'beya'bi qquen in'jan. Tsa'caen in'jamba ñoa'me du'siañe in'jambipa aqquia tsincon tise du'siansi tise quindya'yembe omba'su dushundeccuve sombosa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Tsa'caen tsinconsi Na'su Chigaja tise tsincon'choma chi'gapa Onánma'qque fi'tti. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tsonsi Judája tise china Tamarma su: —Panjen'choyi canseja que yaya tsaoni ña dutssi'ye Sela coenzave dasi tisema afeya'ngae. Nane Judája Sela'qque tise quindyandeqquia'caen paya qquen in'jamba tsa'caen su. Tsa'caen susi Tamarja tise yaya tsaoni can'jeñe ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tsa'caen jasi can'jemba Judá pushe, tsa Súa onque'ngeja pa. Tise pushe pasi ñombi'ye'choma pasapa Judája Timnat canqqueni ja tise ovejandeccu tosema chattujeni. Adulamita'su a'i Hira'qque tise amigopa tisei'ccu fae'ngae ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamarja tise quitsa ccashe'ye Timnatni tise ovejandeccu tosema chattu'su jayi qquen pañamba ");
INSERT INTO conNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","panjen'chove canjaeñe ondiccucho'choma oshichhapa tisu camba'juma oppoen cuintsu majañi'qque tise've attembe can'faye. Tsa'caen oppoemba japa Enaim canqqueni cani'jen'tti dyai, Timnatni ja'je'cho tsaiquini. Nane tayo Sela coenzave dasi tise yaya tisenga afembisi tsu tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judája tsangaé panshaenjimba tsa pushesuma attepa in'jan tisu ai'voi'ccu gana'su pushesu qquen. Nane tsa pushesuja tisu camba'juma picco'chosi tsu tsa'caen in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tsa'caen in'jamba tsaiqui utufa'ye tsa pushesunga catseye ja, tsa pushesuja tise china qquen atesumbipa. Catsepa su: —¿Antte ti qui ña quei'ccu ccuiye? Pushesuja su: —Ñai'ccu ccui'ta, ¿jongoesuma qui ñanga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Tsonsi Judája su: —Ña chivo naccu'suma gi fae'ccoe afeya. Tsonsi pushesuja su: —Ñotssi tsu. Tsa'ma, jongoesu quembema ñanga afeja que chivoma moeña'ngae ña an'biañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Tsonsi Judá iñajampaña: —¿Jongoesu ñambema quenga catiye qui in'jan? Pushesuja su: —Que pisa tevaen'jen'choma tise andu'fai'ccu, toya'caen que accuicco'choma'qque ñanga afeja. Tsa'caen susi Judája tsesuma afepa tisei'ccu ccuipa jasi Tamarja toequi tise yaya tsaoni japa tisu oppoen'choma fettapa panjen'cho ondiccucho'choma ccase ondiccu. Can'jemba surie da. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Omboe Judája tise amigo adulamitanga chivoma moe cuintsu pushesunga angapa afesi ccane'qque tise afe'choma toequi moeñe. Tsa'ma tise amigoja japa tsa pushesuve attembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Attembipa tseni'su tsandiendeccuma qquen iñajampaña: —¿Mani tsu tsa Enaini'su pushesu, tisu ai'voi'ccu gana'suja can'jen, tsa tsaiqui utufani dyai'su? Tsa'ma tsendeccuja su'fa: —Va canqquenija ni fae tisu ai'voi'ccu gana'su pushesuyi'qque can'jen'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tsa'caen su'fasi toequi Judá can'jeni jipa su: —Attembi gi tsa pushesuve. Toya'caen tseni'su tsandiendeccuja su'fa tsenijan tsesu pushesu can'jen'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tsonsi Judája su: —Cuintsu tsa osha'cho ñambeja tsangae nepija aindeccu pañamba ingi'ccu feña'fasa'ne. Ñoa'metsse tisenga afeya gi ñajan chivoma moe'ma qui tisema attembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tres ccovu pasasi Judánga jipa conda'fa: —Tamar, tsa que china, tsu faesu tsandiei'ccu ccuipa ja'ñojan surie dapa can'jen. Pañamba Judája fundopa su: —¡Tsa'o'ye somboemba tisema oque cati'faja! ");
INSERT INTO conNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tsa'ma tisema oqueye somboenjin'fasi Tamarja tise quitsa ccashe'yeve aya'fae moe: “Va osha'chombe na'su tsu ñamajan surive tson. Ñotsse camba atesuja majambe tsu va pisa tevaen'jen'cho tise andu'fai'ccu toya'caen va accuicco'choja.” ");
INSERT INTO conNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judája tsama attepa tise'be qquen atesupa su: “Va pushesuja ñotsse tsu tson. Tsa'ma ña gi egae tson. Nane ña dutssi'ye Selama tisenga afembisi tsu tsa'caen tson.” Tsa'caen supa ni minga'ni'qque ccase tisei'ccu tsa'caen cansembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Isuya'cho a'ta nepisi Tamarja dos du'shuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ñoa'me isu'jequi fae du'shuja tiveyi sombo. Sombosi isian'suja iro cu'ai'ccu du'shu tivema tandamba su: “Va tsu o'tie sombo'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tsa'ma tse'faei'ccuyi tsa du'shuja tise tivema toequi zuña. Tsa'caen zuñasi faesu du'shuja ñoa'me sombo. Tsa'cansi tsu fuite'suja “¿Ma'caen qui pashamba ji?” qquen supa Faresve inisian. ");
INSERT INTO conNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Omboe faesu du'shuja sombo, tsa cu'a iroi'ccu tivema tandan'cho. Tsama inisian Zara. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismaelitandeccu Joséma Egiptoni anga'fasi Egipto'su na'su faraónma shondo'su, Potifarja tisema chava. Tsa Potifar tsu na'su faraóni'ccu pporotsse ccutsu'su sundarondeccumbe capitán. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tsa'ma Na'su Chiga Joséi'ccu can'jensi tisema chava'su Egipto'sumbe tsaoni can'jen'an'qque ñotsse'yi can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nane tise na'suja Na'su Chiga Joséni can'jensi pa'cco José tson'cho ñotsse sombosi atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tsa'caen attepa Joséma ñotsse in'jamba tisema fuite'suve tsomba tise tsa'o na'suve'qque tson. Tsa'o na'suve tsomba pa'cco tisu an'bian'choma tisenga antte cuintsu mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tsa'caen Joséma tsa'o na'suve tsomba pa'cco tisu an'bian'choma tisenga anttesi tsequi a'ta Na'su Chiga'qque Potifarma ñotsse tsoñe ashaen. Nane tise tsa'o'su, tise nasipa'suma'qque ñotsse tsoñe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","José tsa'caen pa'cco tise'bema ñotsse manda'jesi Potifarja jo'su añeñi jipa an'jen. Joséja quinsetssipa me'detssia a'i. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tsa'caen bo'tsse can'jensi tise na'su pushe tisema camba in'jan. In'jamba fae a'ta tisema su: —Ñai'ccu ccuija. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tsa'ma Joséja in'jambipa qquen su: —Que canjan, ña na'su tsu pa'cco tise an'bian'choma ñanga antte tsama ña coiraye. Ña vani can'jensi tiseja jongoesuve asi'ttaemba manda'jembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Va tsaonijan majañi'qque me'i'on tsu ña'can'me. Ña na'suja jongoesuveyi'qque ñama se'pimbi. Aqquia queveyi tsu ñanga afembi queja tise pushesi. Tsa'cansi, ¿ma'caen gi oshaya quema egae tsomba Chiganga'qque egae tsoñe? ");
INSERT INTO conNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tsa'caen su'ni'qque toya tsu tsa pushesuja poi a'ta tisema ti'tsse noñangian cuintsu tisei'ccu ccuiye. Tsa'ma Joséja tise su'choma pañambi ni tisei'ccu pporotsse can'jembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tsa'ma fae a'ta, a'i me'i'ani, Joséja cuartonga ca'ni tseccuni semañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ca'nisi Potifar pusheja tise omba'su ondiccu'jeye qquitssa indipa su: —Ñai'ccu ccuija. Tsa'ma Joséja dyopa tise omba'su ondiccu'jema pushesunga oshichha catipa butto somboin ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tsa'caen tise tivenga tsa ondiccu'jema cati jasi attepa ");
INSERT INTO conNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","pushesuja tisu etti'su semasundeccuma ttu'sepa su: —Que can'faja, ña tsa'ndu va hebreo'su a'ima isi ja'ño ingima tsu noñangiañe ashaen. Nane ñaccuni ca'nimba ñai'ccu ccuiye in'jansi gi quian'me fundo. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Quian'me pa'cco tsain'fai'ccu ña fundosi pañamba tsu tise sarupama cati somboin ja. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tsomba José ondiccu'jema ñoñamba an'bian tisu tsa'ndu tsaoni jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tise jisi o'tie condaqquia'caeñi condapa su: —Tsa hebreo'su a'ima sema'suve que i'cho tsu ñaccuni ca'nimba ñai'ccu ccuipa egae tsoñe in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tsa'ma pa'cco tsain'fai'ccu ña fundosi tsu tise sarupama cati butto somboin ja. Tsa'caen tsu que i'cho sema'suja ñama tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tise pushe tsa'caen condase'jesi pañamba Joséma ambian'su na'suja ñoa'me iyicca'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iyicca'yepa Joséma qquitssa indipa cca'ima manda cuintsu picco'je'cho ettinga picco'faye, na'su faraónga indiyepa dyai'jeccuni. Tsa'ma picco'jeccuni can'jen'ni'qque ");
INSERT INTO conNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Na'su Chigaja Joséi'ccu can'jemba tisu ñotsse tsoña'chove canjaen'jen. Nane cuintsu picco'jeccuni'su na'su Joséma ñotsse in'jaña'chove Chigaja antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tsa'caen anttesi picco'jeccuni'su na'suja pa'cco indiye'chondeccuma Josénga antte cuintsu camba coira'jeye. Nane José tsu pa'cco tseccuni'suma manda'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","José ñotsse mandasi indiyeccuni'su na'suja jongoesuve iñajampañambi Na'su Chiga Joséi'ccu can'jensi ñotsse tsu somboya qquen in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Can'jensi omboen tsu Egipto'su na'su faraónga tasama afe'su toya'caen panma matssan'su'qque tise'pa na'su in'jambi'choa've tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tsa'caen tson'fasi na'su faraón tsa dos tisema shondosundeccuma, tasama afe'su na'su toya'caen panma matssan'su na'suma'qque iyicca'yepa ");
INSERT INTO conNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","piccoye manda. Piccoye mandasi tsu na'sui'ccu pporotsse ccutsu'su sundarondeccumbe capitán tsaoni'su picco'je'ttinga picco'fa. Tse'tti tsu José'qque piccoyepa can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tsonsi faraón sundarondeccumbe capitánjan tsa dos na'suma shondosundeccuma Josénga antte cuintsu coiraye. Tsa'caen indiyepa tsain'bitssi a'ta piccoyepa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Fae cose tsa dos indiye'cho, na'sunga tasama afe'su toya'caen panma matssan'su'qque, ayo'o'fa. Poimbe ayo'ocho tsu jongoesu qquen condaya'chove an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sinte Joséja tise'pama can'su jipa atte asi'ttaen dyai'fa'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Attepa iñajampaña: —¿Micomba qui ja'ño a'taja jova'caen ñombi'ye dyai'fa? ");
INSERT INTO conNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tsonsi tsu su'fa: —Ayo'o'fa gi tsa'ma me'i'on tsu majan ingi ayo'opa in'jan'choma condaye. Tsonsi Joséja iñajampaña: —¿Isha tsu Chiga Quitsaja condaye oshaya? Tsa'ma ñanga condasecan'faja que'i ayo'o'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tsa'caen susi tasama afe'su na'suja Josénga tise ayo'o'choma qquen condase: —Ayo'opa gi atte o'fa tsaja o'fama, ");
INSERT INTO conNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","tres ttembave an'bian'choma. Toya'caen tsa ttemba chu'papa te'tave sombo. Te'ta pasapa ñoa'me tsaja sin'chove sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ñajan na'su faraón tasama an'biamba tsanga tsaja tsa'ccuma mandyipa on'boen. On'boemba ñañi gi tsa tasama angapa afe na'su faraón tivenga. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joséja pañamba su: —Qquen tsu que ayo'ochoja condaye in'jan: Tres ttembata tsu canjaen tres a'tave. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nane tres a'ta pasasi faraónjan quene injanjangipa ccase que semaqque'sungayi quema ca'niaña. Tsonsi qui tayoa'caeñi na'su faraónga que tivei'ccu angapa cuiña'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tsa'caen da'ta ñama in'jamba mende'yeja. Chigáne ñane afaja na'su faraónga cuintsu ñama va'ttie somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nane ñajan hebreo ande'suma cca'namba vani ipa ña mingae egae tsincoma'caen piccopa an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Panma matssan'su na'suja faesu ayo'o'chone José condase'choja ñotsse daya'chosi pañamba tise'qque su: —Ña'qque gi ayo'o. Nane tres saparoni totoa pan jinchoma gi ña tsoveni ontsembipa angacan. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ombani otta'cho saparoja osha'cho ya'yatssia pan tsu jin faraónmbeve. Tsa'ma chhiriria tsu jipa ña ontsembicho saparo'su panma an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tsama pañamba Joséja su: —Qquen tsu que ayo'ochoja condaye in'jan: Tres saparo tsu tres a'tave canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tres a'ta pasasi quene injanjangipa na'su faraónjan mandasi quema quini'cconga fi'ttiya. Fi'ttisi chhiriria que ai'voma an'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tres a'ta pasasi tsu na'su faraón canqque'fa nepi. Nepisi rande fiestave tisema shondosundeccui'ccu tson. Tise ttu'sesi ji'chondeccu caña'jen'ni faraónjan manda cuintsu picco'je'tti'ye tasama afe'su na'su toya'caen panma matssan'su na'suma'qque somboemba tiseni i'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Isi tasama afe'su na'suma ccase tise semaqque'sungayi ca'niansi ccase faraónga tayoa'caeñi angapa cuiña'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tsa'ma panma matssan'suma isi manda cuintsu quini'cconga tisema fi'tti'faye. Nane José ayo'ochone suqquia'caen tsu tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tsa'caen ccusha'ma tasama afe'su na'suja Joséne in'jambitssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dos canqque'fa pasasi faraónjan anamba qquen ayo'o: Nilo na'en otafani tiseja ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tsa'caen ccutsu'ni na'eñe tsu siete vaura me'detssipa ppu'chotssia sombo. Sombopa naifa'su shoshovima an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tsendeccumbe sepaccoe tsu siete vaura egapa ñoa'me cuñosi na'eñe sombo'fa. Sombopa naifani ccutsu'fa faesu vaurandeccu pporotsse. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tsomba tsu egapa cuñosi vaurandeccuja tsa siete vaura me'detssipa ppu'chotssia'ma an'fa. Tsa'caen ayo'opa faraónjan qquendya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ccase anamba faesuve ayo'o: Nane fae trigo na'jiñe siete na'si me'detssipa zutssia sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tsama omboe tsu siete na'si sambapa chiga sombo'jene ju'rutssia fingiain'ccu oque'cho sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tsa'caen oque'cho na'si sombopa tsu tsa siete na'si zutssipa me'detssiama an'fa. Faraónjan qquendyapa in'jan tisu ñoa'me ayo'ochove. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tsa'ma ccaqui a'ta sinte'ye ñoa'me asi'ttaén dyaipa manda cuintsu poiyi'cco Egipto'su jai'ngae ma'caen daya'chove condasundeccu, injama'pandeqquiama'qque ttu'se'faye. Ttu'sesi ji'fasi faraónjan tise ayo'o'choma condase. Tsa'ma majan tsendeccu'suyi'qque ayo'opa in'jan'choma condaye osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tsa'caen osha'fambisi tasama afe'su na'suja faraónga su: —Ja'ño gi injanjangi ña aqque'papa egae tson'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Na'su faraón ingima iyicca'yepa panma matssan'su na'su toya'caen ña, quema shondo'suma'qque piccopa an'bian tise sundarondeccumbe capitán tsaoni'su picco'je'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Fae cose tsa panma matssan'suja ayo'o. Toya'caen gi ña'qque ayo'o. Poi ayo'o'cho tsu jongoesu qquen condaya'chove an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nane tseccuniñi tsu ingi'ccu fae hebreo'su dusunga piccoyepa can'jen. Tsaja capitánmbe sema'su. Tisenga gi ingi ayo'o'choma condase'fasi tise tsu ma'caen daya'chove tansintsse conda. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tise ma'caen su'choja, ¡tsa'caen tsu pasa! Ñajan ccase tisu sema'banga ca'nisi faesuja quini'cconga pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tsama pañamba faraónjan manda cuintsu Joséma ttusengaye. Tsa'caen mandasi japa jundeyi Joséma somboen'fa. Joséja tsojin'bama fuchhapa faesu ondiccu'jema ondiccupa na'su faraónga japa ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ccutsusi faraónjan tisema su: —Ayo'o'choma gi ayo'o tsa'ma majañi'qque tsu tsa ayo'opa in'jan'choma condaye osha'fambi. Tayo gi paña queja ayo'o'choma pañamba condaye osha. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tsonsi Joséja su: —Tisutsseyi ñajan oshambi. Tsa'ma Chiga tsu na'su faraónga ñotssiave condaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tsonsi faraón Josénga qquen condase: —Nane ñajan Nilo na'en otafani ccutsu qquen gi ayo'o: ");
INSERT INTO conNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tsa na'eñe tsu sombo'fa siete vaura ppu'chotssipa me'detssia. Sombopa naifa'su shoshovima an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tsendeccumbe sepaccoe tsu siete vaura egapa ñoa'me cuñosi na'eñe sombo'fa. ¡Minguite'qque gi vaura tsa'caen egama va Egiptonima attepa cansembi! ");
INSERT INTO conNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tsa vaura cuñosipa ega tsu o'tie sombo'cho siete vaura ppu'chotssia'ma an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tsa'ma tsa'caen an'ma tise'pa ai'voja toenga cuñosi'fa tsu. Nane tsa'caen an'ni'qque tise'pa an'chove atesu'faya'bi. “Tsa'caen ayo'opa gi qquendya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Tsomba ccase anamba gi faesuve ayo'o. Nane fae trigo na'jiñe siete na'si zutssipa me'detssia sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Tsama omboe tsu siete na'si sambapa, vuvutssia, chiga sombo'jene ji'cho fingian oque'cho sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tsa na'si samba tsu siete na'si me'detssiama an'fa. Pa'cco va ña ayo'o'choma gi jai'ngae ma'caen daya'chove condasundeccunga condase. Tsa'ma majañi'qque tsu tsa ayo'opa in'jan'choma condaye osha'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joséja pa'ccoma pañamba faraónga su: —Tsa faraón dos ayo'opata tsu fae tsoña'choneñi ayo'o'cho. Chiga tsu quenga conda tisu ma'caen tsoña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tsa siete vaura me'detssiata tsu siete canqque'fave canjaen. Tsa'caeñi tsu siete me'detssia na'si'qque canjaen. Nane fa'eveyi ayo'o'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Toya'caen tsa tsendeccuma omboe sombo'cho siete vaura cuñosipa ega'qque tsu siete canqque'fave canjaen'cho. Tsa'caeñi tsu tsa siete na'si samba chiga sombo'jene ji'cho fingian oque'cho'qque canjaen. Va siete canqque'fa pa'cco tsu ñoa'me qquipoesuiteve daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nane ña suqquia'caen tsu Chigaja faraónga conda tisu ma'caen tsoña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nepiya tsu siete canqque'fa pa'cco anqque'su shacambitssia've pa'cco Egiptoni. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tsama omboe tsu siete canqque'fa pa'cco ñoa'me qquipoesuiteve daya. Nane qquipoesuiteve dapa ñoa'me pa'cco andema dañosi tsu aindeccuja tsa ñotssia shacambitssia canqque'fama aqque'pa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ñoa'me qquipoesuiteve dasi shacambitssia canqque'fani boña'choma metsse sefaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nane Chigaja tsa'caen tsoñe qquen in'jamba toya'caen junde tsa'caen tsoñasi tsu dos se faraónjan tsane ayo'o. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nane tsa'caen daya'si tsu ja'ño faraónjan tta'ttaya'cho fae tsandie injama'papa atesu'choma cuintsu Egipto'suma mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Toya'caen tsu faraónjan qquen tsoña'cho: governarorondeccuve ccutsiaña'cho cuintsu pa'cco andenga japa pa'cco Egipto ande'su tai'fa'choma fae quinta'su enttingeccoeyi isu'faye. Nane siete canqque'fa tsa'caen shacambitsse jincho'niñi tsu tsa'caen isu'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Isupa tsu pa'cco ñotssia canqque'fa jincho'su trigoma boñaña'cho majan canqqueni an'biaña'chove na'su faraón su'nijan. Tseni an'biaña'cho cuintsu aindeccu an'jeña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tsa'caen boñamba an'biansi tsu trigoja jiña aindeccu siete canqque'fa pa'cco qquipoesuiteve Egiptoni dasi qquipoe'supa pa'fasa'ne.” ");
INSERT INTO conNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","José in'jamba su'choja faraóne toya'caen tisema shondosundeccune'qque ñotsse injienge. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tsa'camba faraónjan su: —¿Osha'fa ti gi faesu tsandie qquen Chiga Qquendya'pama an'bian'chove atteye? ");
INSERT INTO conNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tsomba Josénga su: —Me'i'on tsu quia'caen injama'papa ñotsse atesu'chove. Nane Chiga tsu quenga tson que pa'cco tsesuma atesuchoye. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Que qui va na'su tsa'o'suma manda'jeya. Toya'caen pa'cco ña aindeccu tsu que manda'choma paña'faya. Tsa'ma ñajan ñoa'me na'su faraónmba jo'su ñañi gi quema ti'tsse'tssiya. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Que canjan, quema gi ccutsian pa'cco va Egipto ande'sumbe na'su governarorve. Tsa'caen afa nanimba ");
INSERT INTO conNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","na'su faraónjan tisu tiveni ejian'cho sotija, na'su pisa tevaen'jen'cho sotijama shichhapa José tivenga ejian. Tsa'caen tsomba manda cuintsu ñotssia totoa lino sarupama ondiqquiamba cori andu'fama tsifonga andian'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Tsa'caen ondiqquian nanimba na'su faraón omboe ja'je'cho caronga otsiamba aindeccuma manda cuintsu tisema o'tie jayipa qquen fundo'faye: “¡Joqquitssi'faja cuintsu panshañe!” Tsa'cansi tsu poiyi'cco a'i José Egipto'su na'suve da'choma atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Omboe faraónjan Josénga su: —Ñajan quema ti'tsse'tssia faraón. Tsa'ma que mandambiya'da ni fae a'iyi'qque fae tsimian'ccove oyaeñe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tsomba faraónjan Joséma Zafnat-paneame inisiamba On canqque'su chigama afa'su Potifera onque'nge Asenatnga antte. Tsa'caen tsonsi poiyi'cco a'i tsu in'jan'fa José ti'tsse'tssia've da'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joséja treinta canqque'fave an'bian'ni tsu tsa'caen tisema Egipto'su na'su faraónga anga'fa. Tsonsi Joséja faraónma chigambiamba pa'cco Egipto'su andenga jacañe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tsa siete canqque'fa pa'cco shacambitssia've dasi tsain'bitssi taiya'cho nepi. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Siete canqque'fa pa'cco, Joséja ñoa'me injan'tsse tsa ande'su trigoma taipa canqquenga boña. Nane poi canqquenga tsu tsa canqque jini'su nasipa'su trigoma taipa boña. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joséja mar'su sisipa'can'tsse trigoma tai. Nane panshaen tsain'bio trigosi agattopa injan'jeñe oshambipa agattombe'yi antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Qquipoesuiteve daya'cho canqque'fa toya nepimbi'te José pushe Asenatja dos tsandie du'shuve isu Josémbe. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Aisheve isusi “Chiga ñama ñotsse tsonsi gi ña antiandeccu, ña vana'jen'choma'qque aqque'pa” qquen supa tisema inisian Manasésve. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Faesuve isusi “Chiga anttesi gi ña vana'jen'cho andeni du'shuve an'bian” qquen supa tisema inisian Efraínme. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Siete canqque'fa shacambitsse Egiptoni jincho pasasi ");
INSERT INTO conNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","siete canqque'fa pa'cco qquipoesuiteve daye ashaen ma'caen José suqquia'caen. Tsa'caen dasi Egiptoniñi anqque'su jinsi a'i an'fa. Tsa'ma poi faesu andeni tsu qquipoe'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Jai'ngae Egipto'su'qque qquipoe'supa faraóni ja'fa trigove iñajañe. Tsa'caen ji'fasi faraónjan poiyi'cco egiptondeccunga su: “Joséni japa tise suqquia'caen tson'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pa'cco ande tsa'caen qquipoesuiteve dasi Joséja trigoma boña'cho tsa'o sheque'choma fettapa Egiptondeccunga chavaen'jeñe ashaen. Nane poi canqque'fa tsu ti'tsse ega qquipoesuiteve da'ñacca. ");
INSERT INTO conNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Poi andenga tsa'caen dasi tsenisundeccu'qque Egiptoni ji'je'fa José an'bian'cho trigoma chavaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacobja Egiptoni trigo jinchoma pañamba tise dutssiyendeccuma su: —¿Micon'jemba qui aqquia tisupanaccu camboencco dyai'fa? ");
INSERT INTO conNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ñanda gi paña Egiptoni trigo jinchoma. Tseni japa trigoma chava'faja ingi qquipoe'supa pa'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tise yaya tsa'caen mandasi diez José antiandeccu tisupanaccu Egiptoni trigove chava'su ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tsa'ma Benjamín, tsa José quinshin jaye Jacobja anttembi, tisema angapa mingae tson'fasa'ne asi'ttaemba. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nane pa'cco Canaán ande'ye qquipoesuiteve dasi Israel dutssiyendeccuja faesu aindeccui'ccu fae'ngae chava'su ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joséja ande na'suve dapa poiyi'cco ccane ji'chondeccunga trigoma chavaen'su tsu. Tsa'cansi tise antiandeccuja tisenga jipa andenga camba'jui'ccu puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tsa'caen tisenga puntssan'fasi attepa Joséja junde tise quindyandeccu qquen in'jan. Tsa'caen atte'ma tise'pama atesumbiqquia'caen tsomba iyicca'yepa afaqquia'caen tise'pama iñajampaña: —¡Que'ija! ¿mane qui ji'fa? Tise'paja su'fa: —Canaán andene gi ji'fa trigo chava'su. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José tise quindyandeccuma attepa atesu'ni'qque tsendeccuja tisema atte'ma atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tsa'caen atesu'fambisi Joséja tayoe tise'pane ayo'o'choma injanjangi in'jamba su: —Que'i qui a'tutsse jacamba attesundeccu. Nane aqquia qui ji'fa ma'caen ingi andema patsuya'chove atteye. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tsa'ma tsendeccuja su'fa: —Me'in na'su. Ingi quema shondosundeccuja trigoma chava'su gi ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ingi poiyi'cco gi fae yaya'su'fa. Ñotssia a'i'fa gi. Minga'ni'qque gi a'tutsse atteye jacan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tsonsi Joséja su: —Me'in, que'ita qui ma'caen ingi andema patsuya'chove atteye ji'chondeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tsa'ma tsendeccuja su'fa: —Quema shondosundeccuta gi doce antiandeccu. Fae yaya'su'fa gi. Toya'caen Canaánni gi canse'fa. Ingi quinshin chu'aja ingi yayai'ccu toeni catiye. Tsa'ma faesu quinshinjan ingi'ccu can'jembi. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tsa'ma José ccase afapa su: —Nane ña suqquia'caen qui que'ija a'tutsse ttattasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Qquen tsomba gi que'i ñoa'me su'chove atesuya. Nane faraón canse'choma poiyi'cco atesuqquia'caen ña qquen su'choma atesu'faya: Va'ttie sombo'faya'bi qui que'i antian chu'a jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Cuintsu fae'cco que'i'su japa i'ngaja. Faesundeccuja piccoyepa can'jen'faya'cho. Tsa'caen tsomba gi que'i ñoa'me su'chove atesuya. Que'i su'cho tansintssimbian'da qui a'tutsse ttattasundeccu. Nane faraón canse'choma atesupa gi tansintsse su. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tsa'caen supa Joséja tres a'ta pa'cco tsendeccuma piccopa an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tres a'ta pasasi tise'pama su: —Ñajan Chiga Quitsave in'jamba gi tisema dyojo. Qquen tson'faja ña que'ima ccushaeñe: ");
INSERT INTO conNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ñoa'me ñotssia aindeccu'ta fae'cco que'i antianme picco'je'ttinga catipa poiyi'cco cca'ija trigoma isupa anga'faja cuintsu que'i tsaonisundeccu an'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tsa'caen japa que'i antian chu'ama i'faja ña tisema cachuipa que'i ñoa'me su'chove atesuye. Imbi'ta qui pa'faya. Tsendeccuja tise suqquia'caen tsoñe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tsa'ma tisupanaccu afaccopa su'je'fa: —Ñoa'me gi ingi quinshin Joséma egae tson'fa. Nane tise injamáchoni vana'jemba mendeye'faya'ma'caen iñajan'ni'qque gi tisema paña'fambi. Tsane gi ja'ño vanañe tson'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tsonsi Rubénjan su: —Tayo gi ñajan su tsa du'shuma dañombe can'faye. Tsa'ma que'ija ña su'choma paña'fambi. Tsa'cansi ja'ño tsu tise pa'chone ingi'qque vana'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tsendeccuja atesu'fambi José tise'pa hebreo aya'fangae su'je'choma paña'jen'chove. Nane Joséja egipto'su aya'fangae afasi tsu faesu a'i poi aya'fama pañamba afa'su tise'panga conda'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tsa'ma Joséja tise'pa su'choma pañamba tse'ttie sombopa ccani japa i'na. Nane afaye oshambi'tsse da'cho pasapa ccase tise'pani jipa Simeónma joqquitssiamba tise'pa caña'jen'ttinga tandan'faye manda. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tsa'caen tsomba manda cuintsu tsendeccumbe saquiyonga trigoma on'boen'faye. Toya'caen tsu manda cuintsu nasundeccuma a'tutsseyi tise'pa corifin'dima toyaquiañe tise'pa saquiyo tsosini ppiñamba. Toya'caen tise'pa jayipa an jaya'chove'qque cuintsu afeye. Tsa'caen mandasi tsa'caen tsu tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tsa'caen afesi tsendeccuja tise'pa borondeccunga otta'ttaemba tse'ttie sombopa ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tisupa anaña'ttinga nepipa fae'cco tsendeccu'su tise saquiyoma fetta boronga o'fiañe. Fettapa atte tise corifin'di toeningatssi saquiyoni ppi'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Attepa tise antiandeccunga su: —¡Que can'faja! ¡Ña corifin'dima toyaquiansi va'tti ña saquiyoni ppi'choma! Tsama attepa poiyi'cco tsendeccu dyopa tisupa injamáchoni chapepa tisupanaccu afacco'fa: —¿Jongoesie tsu Chigaja ingima qquen tson? ");
INSERT INTO conNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Canaánni nepipa tise'pa yaya Jacobnga pa'cco tisupa ma'caen da'choma condasepa su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Tsa andema manda'su tsandie tsu ingima iyicca'yeqquia'caen afa ingija tise andema patsuye a'tutsse ttattasundeccu qquen supa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tsa'ma ingija tisenga su'fa ingija ñotssia a'ipa minga'ni'qque gi a'tutsse ttatta'suve dapa jacan'fambi; ");
INSERT INTO conNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","toya'caen doce antiandeccu'fa gi fae yaya'su'fa; fae antian toya ingi'ccu can'jembisi faesuja quei'ccu Canaánni can'jen, qquen gi su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tsa'caen su'fasi tsu tiseja su: ‘Qquen tsomba gi atesuya que'i ñoa'me ñotssia a'ive: fae'cco que'i antianme ñanga catipa trigoma isupa anga'faja cuintsu que'i tsaonisundeccu qquipoe'supa an'jen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tsa'ma que'i antian chu'ama ñani i'faja ña atteye. Attepa gi in'jaña que'ija ñoa'me ñotssia a'ipa ingi andema patsuye a'tutsse jacan'fambi. Tsomba gi faesu que'i antianma somboensi qui se'piyembitsse va andeni jacañe osha'faya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tsa'caen condase nanimba José antiandeccuja tise'pa saquiyo'su trigoma somboeñe tson'jemba atte'fa tise'pa corifin'di bosa poimbe saquiyoni toengatssi ppi'fa'choma. Tsa corifin'di bosama attepa tsendeccu tise'pa yaya'qque ñoa'me dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tsa'caen dyopa Jacobja su: —Du'shu me'ccoe qui ñama tsonjin'fa. Joséja ingi'ccu can'jembi. Simeón'qque tsa'cañi. ¡Ja'ñonda qui Benjamínma'qque itsaye in'jan'fa! ¡Pa'cco tsa nepi'cho tsu ña vanaña'chove da! ");
INSERT INTO conNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tsa'caen susi Rubénjan tise yayanga su: —Ñanga antteja Benjamínma ña coirapa angapa ccase queni iye. Ña ccase imbian'da qui ña dos dutssiyendeccuma fi'ttiye osha. ");
INSERT INTO conNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tsa'ma Jacobja su: —Ña dutssi'yeja que'i'ccu jaye oshambi tsu. Tise quindya José pasi tise'yi tsu ñai'ccu can'jen. Nane tisema angasi mingae da'nijan que'i qui shacapave da'faya va coenza ccashe'ye ñombi'yepa pa'chone. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tsa qquipoesuite ti'tsse egave da'ñaccasi ");
INSERT INTO conNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jacob tise dutssiyendeccu'qque Egiptone anga'cho trigoma sefaen'fa. Sefasi Jacobja su: —Ccase japa re'ricco trigove chavanga'faja poiyi'cco ingimbe. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tsa'ma Judája su: —Tsa tsandieja a'tatsse inginga qquen su: ‘Que'i antian chu'ama imbi'ta ¡ccase vani ji'fajama!’ ");
INSERT INTO conNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tsa'cansi cuintsu Benjamín ingi'ccu jaye que antte'ninda gi japa trigoma chavanga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tsa'ma que tisema moembian'da gi ja'faya'bi. Nane tsa a'ita tsu su: ‘¡Que'i antian chu'ama imbi'ta ccase vani ji'fajama!’ ");
INSERT INTO conNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tsonsi Israelja su: —¿Micoñe qui ñama tsa'caen egae tson'fa? ¿Jongoesie qui tsa a'inga faesu antianme'qque an'bian qquenjan su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tsendeccuja su'fa: —Nane tise'yi panshaen ingine, ingi antiandeccune'qque iñajanse'poensi gi conda'fa. Nane tiseja qquen iñajampaña: ‘¿Toya ti canse que yayaja? ¿Faesu antianmenda ti qui an'bian'fa?’ Qquen susi aqquia injanga gi tise iñajampaña'choma conda'fa. ¿Ma'caen gi atesu'faya ‘Que antianma i'faja’ qquen suya'chove? ");
INSERT INTO conNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tsonsi Judája tise yaya Israelnga su: —Poiyi'cco ingi canseccaye in'jan'da antteja cuintsu quinshin ña coirasi jacañe. Tsayita gi junde ja'faya. Tsa'caen tson'da gi ni que, ni ingi, ni ingi dushundeccu'qque pa'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ñajan tise've toyaquian'su. Ñama qui tise mingae da'ninda itsaya. Nane tisema vani toequi imbi'ta tsangae tisene quei'ccu shacapae dapa gi canseya. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Que se'pisi ronda'jembiecan'da, ¡tayo gi dos se japa ji'faye'can! ");
INSERT INTO conNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tsa'caen susi tise yayaja su: —Ccaningae tsoñe oshambi'ta qquen tson'faja: Tsa a'inga afeya'chove que'i saquiyonga anga'faja. Nane va ande'su bove ñotsse jincho'cho'suma anga'faja, re'ricco balsa'mo seje'pa, re'ricco tuño cuñajun'cho, ñome'ba, mirra seje'pa, ccasepa'cho toya'caen almendra. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Toya'caen dos se afepoeña'cho corifin'dive angapa cambajunaccu tise que'i corifin'dima toyaquian'choma afe'faja, in'jamba'qque ñotsse agattombipa ppiña'chosa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dasu' qui que quinshinma angapa ccase japa can'ga'faja tsa a'ima. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Tsa Chiga Osha'choma Oshacho'cho tsu tisema in'jaeña cuintsu que'ima mendeyepa faesu que'i antian Simeónma fettapa Benjamínma'qque mingae tsombe'yi antteye. Ñajan, mapán du'shu me'ccoe da'a'qque cuin'qque gi tsa'caen me'ccoe daya. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tsonsi Jacob dutssiyendeccuja afeya'cho, dos se afepoeña'cho corifin'di toya'caen Benjamínma'qque angapa Egiptoni ja'fa. José can'jeni nepi'fasi ");
INSERT INTO conNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joséja Benjamín tsendeccui'ccu ji'chove attepa tise tsa'o coira'suma su: —Va aindeccuma ña tsaoni angapa fae vaurave fi'ttipa sho'ccoenjan. Nane ja'ño enttinge a'taja ñai'ccu tsu an'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","José tsa'oma coira'suja José suqquia'caen tsendeccuma fae'ngae anga tise tsaoni. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tsa'ma tsendeccuja José tsaoni anga jisi ñoa'me dyopa tisupapora qquen su'fa: —¿Aqquiata ti afopoen'fambi? ¿Isha tsu ingi tayoe jisi corifin'dima toyaquian'chone'ja vani iya? Nane ingima indipa tsu tsangae semoen'jen'faya ingi borondeccui'ccu fae'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tsa'caen supa José tsa'o'su sombo'ttinga nepipa tsa'oma coira'sunga catse'fa tisenga ");
INSERT INTO conNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","qquen afaye: —Chigáne na'su, tayoe'qque gi ñoa'metsse trigoma chava'su ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tsa'ma chavapa japa ingi anañani nepipa gi poiyi'cco tisu saquiyoma fettapa atte'fa tsani poi ingi corifin'di ppi'choma. Tsa corifin'dimajan toengatsse gi i'fa ja'ño tsama toyaquiañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Toya'caen ti'tsse'tssi corifin'dive gi i'fa trigoma chavaye. Tsa'ma atesu'fambi gi majan ingi tayoe jipa chava'cho corifin'dima saquiyonga ppiña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tsa'ma tsa'oma coira'suja tise'pama su: —Vuiquipa dyombe can'faja. ¿Isha tsu que'i Chiga, tsa que yaya Chigaja, tsa'caen que'i corifin'dima saquiyonga ppiña'ña? Nane tayo gi tsa que'i afepoen'cho corifin'dima isu. Tsomba tsa'oma coira'suja Simeónma somboemba tise'pani anga. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tse'i José tsa'onga ca'niamba tsa'ccuma afe cuintsu tise'pa tsu'ttema cashi'faye. Toya'caen tise'pa borondeccunga'qque o'fian. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","José antiandeccu tise'pa Josénga afeya'choma ñoñamba ronda'je'fa José enttinge a'ta tseni añe su'chosi pañamba. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tsa'caen ronda'je'fani José tisu tsaoni jisi tsendeccuja tisenga afeya'choma afepa andenga camba'jui'ccu puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joséja tise'pa ma'caen canse'chove iñajampañamba ti'tsse iñajampaña: —¿Mingae tsu can'jen que'i yaya, tsa coenza ccashe'ye qquen que'i su'choja? ¿Toya ti canse? ");
INSERT INTO conNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tsendeccuja ccase puntssamba su'fa: —Ingi yaya, quema shondo'suja ñotssi tsu. Toya tsu canse. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joséja poiyi'cco tsendeccuma camba atte tise antian Benjamínma. Nane tsaja tise yaya'supa tise mama'suyi. Tisema attepa su: —¿Va ti que'i antian chu'a'qque can'jen qquen que'i ñanga su'cho? Ju, qquen su'fasi Joséja Benjamínma qquen su: —Jaricho, Chiga tsu quema ñotsse tsoña. Tsa'caen supa ");
INSERT INTO conNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joséja tise quinshinma camba injamáchoni chapepa i'nañe tson'jemba junde tisu ttuccuni ca'nimba tseccuni i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I'na'choma vuiquipa tisu camba'juma ovashipa sombopa manda: “¡Anqque'suma ccutsian'faja añe!” ");
INSERT INTO conNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Josémbeja fae mesanga ccutsian'fa. Jacob dutssiyendeccumbeja faesu mesanga, toya'caen Joséi'ccu ji'cho egiptondeccumbeja faesu mesanga ccutsian'fa. Nane egiptondeccuja hebreondeccui'ccu fae'ngae dyaipa añe chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José antiandeccuja ma'caen José su'nijan tsa'caen dyai'fa. Nane atesuqquia'caen coenzama otuni dyaiñamba du'shumajan tsutopani dyaiña. Tsa'caen dyaiñasi asi'ttaemba tisupanaccu camboencco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tsa'caen dyaiñamba Joséja tisu mesani sheque'cho aña'choma afeye ashaemba Benjamíngaja cca'inga afe'choma ñoa'me ti'tsse nama afe. Tsa'caen tsu Joséja tisu antiandeccui'ccu cu'ipa avujatsse pasa. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tsomba tse'i Joséja tise tsa'oma coira'suma manda: —Va tsandiendeccumbe saquiyonga trigoma on'boenjan mangae tise'pa angaye o'shatsse. Toya'caen poi tsandiembe corifin'dima ppiñajan tise'pa angaya'cho saquiyonga. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tsa tise'pa quinshin chu'ambengaja trigone afepoen'cho corifin'di toya'caen ña totoacori tasama'qque ppiñajan. Tsa'caen mandasi coira'suja José suqquia'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Caqui a'tasi sinte Joséja antte cuintsu tise'pa boroi'ccu ja'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Toya canqquema biani ja'fambi'te Joséja tise tsa'oma coira'sunga su: —Va tsandiendeccuma omboemba cachuiccopa qquen suja: “¿Jongoesie qui ñotssiama egai'ccu afepoenqquia'caen tson'fa? ¿Jongoesie qui totoacori tasama cca'na'fa? ");
INSERT INTO conNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tsa tasanga tsu ña na'suja cu'ipa camba ma'caen daya'chove atesu'je'cho. ¡Ñoa'me egave qui tson'fa!” ");
INSERT INTO conNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tsa'caen susi japa tsa'oma coira'suja José antiandeccuma José mandaqquia'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tsa'caen susi tsandiendeccuja su'fa: —¿Jongoesie qui ingima ya'caen afase? ¿Minguite'qque gi ingija tsa'caen tsomba canse'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nane tsa ingi saquiyoni pi'cho corifin'dima Canaánne toyaquiañe ji'je'chondeccu'ta, ¿ma'caen gi que na'su tsa'o'su cori ni totoacorima cca'na'faya? ");
INSERT INTO conNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ingi'su majan quema shondosundeccu tsa tasama an'biamba atteye'ta cuintsu paja. Nane ingi'qque gi quembe sema'suve dapa tsangae canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tsa'caen su'fasi José tsa'oma coira'suja su: —Que'i suqquia'caen tsu tsoña'cho. Tsa'ma majan tsa tasama an'bian'choyi tsu ñambe tsangae sema'suve daya. Poiyi'cco cca'indeccuja shacave me'cho'faya tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tsa'caen susi junde poiyi'cco tise'pa saquiyoma andenga andiamba fetta'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Fetta'fasi José tsa'oma coira'suja poimbe saquiyoma tta'ttaye ashaen. Nane coenzane ashaemba tta'ttá chu'ani nepi. Tsa'caen nepipa Benjamín saquiyoni tsa tasa ppi'choma atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tsa'caen attesi tsendeccuja tisupa ondiccu'jema chitta'fa ñombi'ye'choma canjaeñe. Tsa'caen tsomba poiyi'cco tisumbema boronga andiamba toequi canqqueni ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judá, tise antiandeccui'ccu jipa José tsaoni nepisi Joséja toya can'jen. Tsa'caen can'jensi poiyi'cco tisenga ccaru'fa. Nane camba'ju andenga ppo'rotsse puntssan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Tsa'caen ccarupa puntssan'fasi Joséja tise'pama su: —¿Jongoesuma qui tson'fa? ¿Atesu'fambi ti qui majan a'i ña'caen osha'chove atesucho'choma? ");
INSERT INTO conNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tsa'caen susi Judája su: —¿Ma'caen gi quenga conda'faya? ¿Ma'caen gi ingija shaca me'choave canjaen'faya? Chiga tsu ingi egae tsincon'choma tayo atte. Va'tti qui ingima an'bian tsangae quembe semasundeccuve, tsa tasama an'bian'choi'ccu fae'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tsa'ma Joséja su: —Tsa'caenjan tson'masia tsu. Jo'su tsa tasama an'bian'choyi tsu ñambe tsangae sema'suve daya'cho. Que'ija opatsse qui que yaya tsaoni ja'faya'cho. Ni majañi'qque tsu que'ima noñangiaña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tsonsi Judája Josénga catsepa su: —Na'su, quema gi iñajan, chigáne antteja ña re'riccoe quenga a'tutsse afaye. Nane ñama iyicca'yembe'yi ñotsse pañajan. Queja ñoa'me qui na'su faraóni'ccu fae'ngatssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Que qui ingima tayoe iñajampaña: ‘¿Yaya'pa'fa ti qui? ¿Faesu antianmenda ti qui an'bian'fa?’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tsonsi gi conda'fa ingi yaya coenza ccashe'ye, toya'caen ingi antian chu'a'qque can'jen'chove. Nane tsaja ingi yaya coenza ccashe'yeve dapa du'sian'cho. Toya'caen gi conda'fa ingi yaya tsa du'shuve ñotsse in'jan'choma. Nane fae chan'su ccoangi'ccoa, fae'cco pasi tsayi tisei'ccu can'jensi tsu tsama ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tsama pañamba qui ingima iñajan tsa du'shuma isi atteye in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tsonsi gi su'fa tsa du'shumajan tise yaya antteya'bi cuintsu jiye. Nane tisema moeñe antte'ta tsu tise yayaja paya. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tsa'ma queja ingima su: ‘Tsa du'shu que'i'ccu jimbian'da ccase qui ñama atte'faya'bi.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Tsa'caen que su'choma gi pa'ccoma yayani japa conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Can'jemba yayaja ingima ccase su: ‘Ccase japa trigoma chavanga'faja.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tsa'ma ingija su'fa: ‘Ingi antian chu'a ingi'ccu jayimbian'da jaye osha'fambi gi. Nane tise ingi'ccu jambian'da tsa na'suma atte'faya'bi gi.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tsonsi ingi yayaja su: ‘Que'ija atesu'fa ña pushe dos du'shuve an'bian'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tsa'su fae'cco tsu ña'ñe tayo joqquitssi. Tsa'cansi gi tisema atte'jembi. Tsampi'su ttesi tisema ansi tsa'caen nepi qquen gi in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tsa'caeñi faesu ña du'shuma'qque ña'ñe joqquitssiamba angasi mingae egae da'ninda que'i qui va ccashe'ye ñombi'yepa pa'chone shacapa'faya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Tsa'caen tsu ña yayaja pa'cco tise canse'pai'ccu va du'shuma in'jamba canse. Nane va du'shu ingi'ccu toequi jambian'da ");
INSERT INTO conNTpo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ingi yaya tsu tisema attembipa paya. Tsa'caen ñombi'yepa ingi yaya coenza ccashe'ye pa'ninda ingi gi tise pa'chone shacapa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nane tsa'caen ña yaya se'pisi ña gi tisenga su: ‘Ña gi tsa du'shuve toyaquian'su.’ Toya'caen gi su: ‘Nane tisema vani toequi imbi'ta tsangae tisene quei'ccu shacapae dapa gi canseya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tsa'camba gi quema iñajan antteja cuintsu tsa du'shu tise antiandeccui'ccu jasi ñajan tsa du'shuve daqquia'caen can'jemba tsangae quembe sema'suve daye. ");
INSERT INTO conNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Ma'caen gi tsa du'shuve me'cco toequi ña yayani jaya? Nane in'jambi gi ña yaya ñombi'ye'choma atteye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Majan tisema shondosundeccu tseni can'jen'fasi Joséja ti'tsse injama'choni osha'chove a'tuye oshambipa quian'me fundo: “¡Poiyi'cco va'ttie sombo'faja!” Tsa'caen tteya moesi poiyi'cco tisema shondosundeccu me'i'en ja'fasi Joséja tise antiandeccunga tisuma attian. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nane i'nañe ashaemba quian'me i'nasi poiyi'cco tseni can'jen'cho egiptondeccu paña'fa. Pañamba conda'fasi na'su faraón'qque paña. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Tsa'caen i'namba Joséja tise antiandeccunga tisungae su: —Ña gi José. ¿Ña yayata ti toya canse? Tsa'caen susi tsendeccuja tise caña'jen'tti ccutsupa ñoa'me dyopa afaye'qque osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Tsa'ma Joséja su: —Chigáne, ¡ñanga catse'faja! Tise'pa catse'fasi Joséja su: —Ña gi que'i antian, José, que'i egiptondeccunga chavaen'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tsa'ma chigáne ñoquimbi'fajama ni tisupama iyicca'ye'fajama ñama chavaen'chone. Nane Chiga Quitsa tsu ñama manda que'ima o'tie vani jipa que'ima ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tayo tsu dos canqque'fa va andeni qquipoesuiteve da'cho. Toya tsu cinco canqque'fa tsa'caen da'jeya. Nane jon'an'qque qui tai'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tsa'ma Chigaja que'ima o'tie ñama vani moe cuintsu ña tsonsi ingi dushundeccu ccushapa canse'faye; toya'caen tsain'bio que'i'suma ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tsa'camba Chiga tsu ñama vani moe'su. Que'ija me'in. Tise tsu ñama tson faraónga conda'suve; toya'caen faraón tsa'o na'suve; toya'caen pa'cco Egipto andema manda'suve. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Junde ña yaya can'jeni ja'faja. Japa tisenga su'faja: ‘Qquen tsu que dutssi'ye Joséja su: Chiga mandasi gi pa'cco Egipto ande'su na'suve da. Jundeyi ñani jija. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Jipa qui Gosén andeni canseya. Nane que dutssiyendeccu, que du'tssiyembe dushundeccu, pa'cco que aiña'cho, toya'caen pa'cco que an'bian'choi'ccu fae'ngae qui tseni canseya. Tsa'caen jipa qui ñai'ccu pporotsse canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Vani gi quenga, que etti'sunga, poiyi'cco que'i'ccu canjensundeccunga anqque'suma afeya cuintsu que'i jongoesuve shacambitsse canse'faye. Nane toya tsu cinco canqque'fa pa'cco qquipoesuite jinchoya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tsa'caen condaye japa ña quinshin Benjamin, toya'caen que'i'qque qui ñoa'me ñotsse su'choma pañamba condasundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ña yayanga condase'faja ma'caen ña egipto'suma manda'je'choma, toya'caen pa'cco que'i vani atte'choma. ¡Junde japa ña yayama i'nga'faja! ");
INSERT INTO conNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tsa'caen supa Joséja tise quinshin Benjamínma munsimba i'nañe ashaen. Benjamín'qque Joséma munsimba i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Omboe poiyi'cco tisu antiandeccuma munsimba mochapa i'na. Tsa'caen tson nanisi poiyi'cco tise antiandeccu Joséi'ccu condasecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tsa'caen tsonsi faraón tsaone'qque José antiandeccu ji'chove paña'fa. Tsama pañamba faraón toya'caen poiyi'cco tisema shondosundeccu'qque avuja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tsa'caen avujapa faraónjan Joséma su: —Que antiandeccuma suja cuintsu tise'pa borondeccunga andu'choma andiamba toequi Canaánni japa ");
INSERT INTO conNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","que yayama i'nga'faye; toya'caen tisei'ccu canjensundeccuma'qque. Ña gi va Egipto ande'su bove ñotssia andema afeya. Tsonsi tsu va ande'su bove ñotssia anqque'suma amba canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","20","Tise'panga condaja cuintsu va Egipto andeni'su qquitssa'je'cho caroma anga'faye tsanga tise'pa pushendeccu, tise'pa dushundeccuma'qque vani iye; toya'caen que yayama'qque cuintsu i'faye. Condaja cuintsu tise'pa tseni an'bian'chone asi'ttaembe'yi catipa vani ji'faye. Nane pa'cco va Egipto ande'su bove ñotssia tsu tise'pambe. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Faraón suqquia'caen tsu Israel dutssiyendeccuja tson'fa. Joséja faraón mandaqquia'caen qquitssa'je'cho caroma afepa anqque'suma'qque afe tise'pa jayipa aña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Toya'caen cuna ondiccu'je ñotssiama poiyi'cconga afe cuintsu ondiccu'faye. Tsa'ma Benjamíngaja tresciento corifin'dima afepa cinco ondiccu'je ñotssiama afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tise yayangaja moe diez boro Egipto ande'su bove ñotssiama andu'suve. Toya'caen faesu diez boro trigo, pan, anqque'suma'qque andu'suve moe tise yaya jiñamba tsaiquiningae aña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Joséja tise antiandeccuma chigambiamba moe'jemba qquen su: —¡Tsaiqui'ye jayipa tisupanaccu iyicco'fajama! Tsonsi japa ");
INSERT INTO conNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Egipto ande'ye sombopa Canaán andeni nepi'fa tise'pa yaya Jacob can'jeni. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Tseni nepipa tise'pa yaya Jacobnga conda'fa José toya canse'choma. Toya'caen tsu condase'fa José pa'cco Egipto ande'su na'suve da'choma. Condasesi paña'ma ñoa'me su'chove in'jambi. Nane ma'caen tsomba suya'chove atesumbi. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tsa'ma pa'cco José su'choma condase'fasi toya'caen José moe'cho tise'pama angaya'cho qquitssa'je'cho caroma attepa vuiquipa ñoa'me avuja. ");
INSERT INTO conNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Avujapa su: “¡Nanitssi tsu ña dutssi'ye José toya canse'choma ña pañasi! Toya pambi'te gi japa tisema atteya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tsomba Israelja pa'cco tise an'bian'choi'ccu tsaiqui'ye sombopa japa Beersebani nepipa tise yaya'ye, Isaacmbe Chiganga oque oraemba afe. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tsa'caen afepa ana'jensi Chigaja tisenga attiamba condase. Nane Jacob inisema afasi Jacobja su: —Va'tti gi. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tsa'caen susi Chigaja su: —Ña gi Chiga Quitsa, que yaya'yembe Chiga. Dyombe'yi Egiptoni jaja. Nane tseni gi que omba'su dushundeccuve tsain'bitsse atapoeña. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Quei'ccu fae'ngae gi Egiptoni jaya. Toya'caen ñañi gi que omba'su dushundeccuma tsa ande'ye somboeña. Nane que pa'ni'qque tsu Joséja quei'ccu jinchoya. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tsa'caen Chiga afasi pañamba Jacobja Beerseba'ye sombo. Nane Israel dutssiyendeccuja tise'pa yaya, tise'pa dushundeccu, toya'caen tise'pa pushendeccuma'qque otsiamba anga'fa faraón moe'cho tise'pama angaya'cho caronga. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tsa'caen tsu Jacobja pa'cco tise aindeccui'ccu Egiptoni ja. Toya'caen vaura, oveja, pa'cco tise'pa Canaán andeni atapoemba an'bian'choma'qque anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nane poiyi'cco tise dutssiyendeccu, onquengendeccu, tsambe dushundeccu'qque fae'ngae tisei'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Va tsu poiyi'cco Israendeccu Egipto andeni ja'chondeccumbe inise, nane Jacob, tise dutssiyendeccumbe inise: Rubén tsu Jacob dutssi'ye coenza. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubén dutssiyendeccu tsu Hanoc, Falú, Hezrón toya'caen Carmi. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeón dutssiyendeccu tsu Jemuel, Jamín, Ohad, Jaquín, Zohar toya'caen Saúl. Saúl tsu cananeo'su pushesumbe du'shu. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leví dutssiyendeccu tsu Gersón, Coat toya'caen Merari. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá dutssiyendeccu tsu Er, Onán, Sela, Fares toya'caen Zara. (Er, toya'caen Onán tsu Canaán andeni pa'fa'cho.) Fares dutssiyendeccu tsu Hezrón toya'caen Hamul. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacar dutssiyendeccu tsu Tola, Fúa, Job toya'caen Simrón. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulón dutssiyendeccu tsu Sered, Elón toya'caen Jahleel. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tsendeccu tsu Leanga Jacob du'sian'chondeccu toya Padan-aram andeni can'jemba isu'chondeccu, toya'caen fae pushesu Dina'qque. Pa'cco Lea omba'su dushundeccu tsu treinta y tres a'i, tsandie, pushesuma'qque agattosi. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad dutssiyendeccu tsu Zifión, Hagui, Ezbón, Suni, Eri, Arodi toya'caen Areli. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser dutssiyendeccu tsu Imna, Isúa, Isúi, Bería toya'caen tise'pa que'tte Sera. Bería dutssiyendeccu tsu Heber toya'caen Malquiel. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tsendeccu tsu Zilpanga Jacob du'sian'chondeccu. Zilpa tsu Labán tise onque'nge Leama coira'suve afe'cho pushesu. Pa'cco Zilpa omba'su dushundeccu tsu diez y seis a'i. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob pushe Raquel dutssiyendeccu tsu José toya'caen Benjamín. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José dutssiyendeccu tsu Manasés toya'caen Efraín, Egipto isu'chondeccu. Tise'pa mama tsu Asenat, On canqque'su chigama afa'su Potifera onque'nge. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamín dutssiyendeccu tsu Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim toya'caen Ard. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tsendeccu tsu Jacob pushe Raquel omba'su dushundeccu. Pa'cco tsu catorce a'i. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan dutssi'ye tsu Husim. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftalí dutssiyendeccu tsu Jahzeel, Guni, Jezer toya'caen Silem. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tsendeccu tsu Bilhanga Jacob du'sian'chondeccu. Bilha tsu Labán tise onque'nge Raquelma coira'suve afe'cho pushesu. Pa'cco Bilha omba'su dushundeccu tsu siete a'i. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Poiyi'cco Jacobi'ccu Egiptoni ji'chondeccuta tsu sesenta y seis a'i. Nane tise dutssiyendeccumbe pushendeccuma agattombe'yi jo'su tise atapoen'choveyi tsu agatto. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Toya'caen José dos dutssi'ye Egipto andeni isuye'chondeccu. Tsendeccui'ccu tsu setenta a'ive nepi Jacob atapoen'cho Egiptoni nepi'cho aindeccu. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacobja o'tie Judáma moe Joséma can'su cuintsu José jipa Goséni tise'pama cachuiye. Tsendeccu Goséni nepipa ");
INSERT INTO conNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José manda tise caroma ñoña'fasi tise yayama cachui'ngaye. Tise yayanga nepipa opipa'chonga munsin ccutsupa tsain'bitsse i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Tsonsi Israelja Joséma su: —Ja'ñonda gi asi'ttaembe'yi paya. Tayo gi que camba'juma attepa, toya qui canse qquen atesupa. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tsonsi Joséja tise antiandeccunga toya'caen tise yaya'su aindeccunga qquen su: —Faraóni gi jaya que'i ji'chone qquen condaseye: ‘Nane ña antiandeccu toya'caen poiyi'cco ña yaya aindeccu Canaán andeni cansesundeccu tsu vani ji'fa ñai'ccu canseye. ");
INSERT INTO conNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Toya'caen tsu i'fa tise'pa oveja, vaura, pa'cco tise'pa an'bian'choma. Nane tsendeccu semambata tsu ovejama coiraye, toya'caen vaurama atapoeña'cho.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tsa'caen condasesi Faraón que'ima ttu'sepa jongoesuma semañe qui atesu'fa qquen iñajampaña'ninda ");
INSERT INTO conNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","que'ija su'faja: ‘Ingija ovejama atapoeñe gi atesu'fa ingi tayopi'su coenzandeqquia'caeñi.’ Tsa'caen su'yita qui Gosén andene can'jeñe osha'faya. Nane Egiptondeccuja se'pi'fa tsu oveja coirasundeccu fae'ngae tise'pai'ccu can'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joséja faraónga condaye ja. Japa tise yaya, tise antiandeccu Canaánne jipa Gosén andeni nepi'choma condase. Nane tise'pa oveja, tise'pa vaura, pa'cco tise'pa an'bian'choma i'fa'chone condase. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tise antiandeccu'suma cincoveyi ttu'sepa faraónga canjaeñe anga cuintsu tise'pama atesuye. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tsonsi faraónjan José antiandeccuma iñajampaña: —¿Jongoesuma qui semamba canse'fa? Tsendeccuja condase'fa: —Ingi quema shondosundeccuta gi ovejama coirasundeccu ingi tayopi'su coenzandeqquia'caeñi. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ingita gi ji'fa va andeni canseye. Nane Canaán andenijan tsain'bitssi qquipoesuite tsu ni ingi oveja an'jeña'cho shoshovive'qque me'i'on. Tsa'cansi chigáne ingi quema shondosundeccuma antteja Gosén andeni canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tsonsi faraónjan Joséma su: —Que yaya, que antiandeccu tsu quei'ccu canseye ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Va Egipto ande tsu pa'cco que ande. Tsendeccunga afeja Gosén andema cuintsu tseni canse'faye. Tsa tsu ti'tsse ñotssia ande. Toya'caen majama que ñotsse atesupa in'jan'da tsama mandaja cuintsu ña vaurama'qque coira'jeye. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joséja tise yaya Jacobma'qque faraónga anga cuintsu tisema'qque atteye. Jacobja faraónma ñotsse afapa chigambian. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Chigambiansi faraónjan iñajampaña: —¿Mañi canqque'fave qui an'bian? ");
INSERT INTO conNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacobja su: —Tayo gi ciento treinta canqque'fa va andeni jacamba canse. Nane re'riccoe vana'jen'ma canse. Tsa'ma toya gi ña tayopi'su coenzandeqquia'caen nepiaña'cho shaca. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tsa'caen afapa Jacobja faraónma chigambiamba tse'ttie sombo. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Tsonsi Joséja faraón mandaqquia'caen tise'panga afe Egipto ande'su bove ñotssia andema cuintsu tseni canse'faye. Tsa'caen tsu tise yaya tise antiandeccu'qque Ramsés canqque jin'tti'su andema isupa canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Toya'caen Joséja anqque'suma'qque poiyi'cco tise antiandeccunga afe'je. Nane mañi'cco a'i fae ettini can'jen'chonga tsa'caen tsu afe'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nane pa'cco andeni trigove metsse da. Qquipoesuiteja ti'tsse atapa'ñacca. Nane Egipto ande'su a'i toya'caen Canaán ande'su aindeccu'qque qquipoe'supa pa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joséja pa'cco a'i corifin'dima, egipto'su toya'caen canaán'su aindeccu trigoma chava'cho corifin'dima, boñamba faraón tsa'onga ñoñamba an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tsa'caen tsu egipto'su aindeccu, canaán'su aindeccu'qque corifin'dima metsse sefaen'fa. Sefaemba egiptosundeccuja Josénga japa su'fa: —Chigáne inginga anqque'suma afeja. Ñotssimbi tsu que can anttesi ingi corifin'di me'chopa qquipoe'supa paye. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joséja pañamba su: —Tsa'caen corifin'di me'chota que'i aiña'choma i'faja trigoi'ccu cambiañe. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tsa'caen susi egiptondeccuja tise'pa cavayo, oveja, vaura toya'caen boroma'qque Joséni anga'fa. Tsa'caen tsu Joséja trigoma cambian'jen pa'cco tsa canqque'fani. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tsa'ma tsa canqque'fa pasapa faesu canqque'fani ccase japa Josénga su'fa: —Ñoa'me corifin'di metsse dapa gi quenga a'tieñe osha'fambi. Toya'caen ingi aiña'chondeccu'qque pa'cco tsu quembe'yi. Ja'ñojan me'cho'fa gi jongoesuma quenga afeya'chove. Jo'su ingi ande ingi ai'voveyi gi an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ingi ai'vo, ingi andema'qque chavaja. Nane que trigoma afesi gi faraónmbe tsangae semasundeccuve dapa ingi andema'qque tise'beyi sema'faya. Toya'caen que qui inginga choma afe'jeya'cho ingi tsama jomba cansesi cuintsu tsa ande catiyembe cañe. ¿Ma'caen qui can antteya ingi tisu andei'ccu fae'ngae pa'faye? ");
INSERT INTO conNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tsa'caen su'fasi Joséja pa'cco Egipto andema faraónmbe chava. Nane tsa'caen tsu poiyi'cco egipto'su aindeccuja qquipoe'supa tise'pa andema chavaen'fa. Chavaensi pa'cco ande tsu faraónmbeve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tsa'caen tsomba tsu poiyi'cco egiptondeccu tsangae semasundeccuve da'fa. Nane poi Egipto canqqueni'su tsu tsa'caen da'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Jo'su egipto'su chigama afasundeccumbeveyi tsu Joséja chavambe pasa. Nane tsendeccungaja faraón tsu nanitsse trigoma afe'je. Tsa'caen faraón afe'jesi nanitsse an'jemba tsendeccuja tise'pa andema chavaen'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Omboe Joséja aindeccunga su: —Ja'ñojan que'i toya'caen que'i ande tsu faraónmbe. Tise'be gi ñajan chava. Voe gi afe'je choma que'i semamba andenga joñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tsa'ma tsama taipa cinco boñame boña'da tsu fae boñama faraónga afeya'cho. Faesu cuatro boña tsu que'i andenga jomba toya'caen que'i, que'i dushundeccu, poiyi'cco que'i'ccu canjensundeccu'qque an'jeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tsama pañamba tsendeccuja su'fa: —¡Queja ño'amba ingima ccushaensi gi avujatssi'fa faraónmbe tsangae semasundeccuve daye! ");
INSERT INTO conNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tsa'caen tsu Joséja manda antte cuintsu poi egiptondeccu tise'pa tai'cho'suma fae cincoccoeyi faraónga afe'je'faye. Tsa manda'choja toya tsu jincho. Tsa'ma egipto'su chigama afasundeccuja afepoen'jen'faya'bi, nane tise'pa andeja faraón isumbi'choa ande. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israendeccuja Egipto ande'su Gosén andeni can'jemba tsao'ñamba canse'fa. Tsa'caen cansepa tsain'bitssi a'ive atapa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacobja diez y siete canqque'fa pa'cco Egiptoni cansepa ciento cuarenta y siete canqque'fave nepian. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Fae a'ta Israelja tise junde paya'choma atesupa tise dutssi'ye Joséma ttusengaye manda. Tise jisi su: —Queja ñoa'metsse ñama ñotsse tsoñe in'jan'da que tivei'ccu ña ttena'go tsosiccufama pporaemba tansintsse su'chove afaja ñoa'me ña iñajan'choma tsoña'chove ña atesuye. Chigáne ña pasi ñama Egiptoni a'tujama. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ña tayopi'su coenzandeqquia'caen ña pa'ninda va Egipto ande'ye somboemba angapa tsendeccumbe atu'ttingayi ñama a'tuja. Tsonsi Joséja su: —Tsa'caen gi tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tsa'ma tise yayaja ccase quian'me su: —¡Ñoa'metsse suja! Tsonsi José ñoa'metsse susi Israelja tise ana'jen'cho'su asusu'chonga ccui. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tsa'caen tsonsi can'jencca'ta Joséja paña tise yaya paji'choma. Pañamba can'su jayipa tise dos du'shuma, Manasés toya'caen Efraínma anga. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tise dutssi'ye José ji'choma conda'fasi pañamba Jacobja vanamba tise ana'jen'cho'ye jangi dyai. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jangi dyaipa Josénga su: —Tsa Chiga Osha'choma Oshacho'cho tsu Canaán ande'su Luz canqqueni ñanga attiamba ñotsse afapa ");
INSERT INTO conNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","qquen su: ‘Que canjan, ña gi tsoña cuintsu queja tsain'bio du'shuve atapasi que omba'su dushundeccu'qque tsain'bio ande'suve dapa fae naccufaya'chove. Toya'caen gi que omba'su dushundeccunga va andema afeya. Afesi tsangae tsu tise'pambeve daya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ja'ñojan ñotssi tsu. Mapán ña toya va Egiptoni quei'ccu canseye toya jimbi'te Efraín toya'caen Manasésve isu'cho'qque, ñambe'fa tsu. Tsendeccu tsu ñoa'me ñambe'fa ña Rubén toya'caen Simeóncan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Que vandeccuma omboe isu'cho tsu quembe'faya. Tsa'ma tsendeccu Efraín, Manasés antiandeccupa tsu tise'pa quindyandeccu aindeccui'ccu fae'ngae isu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nane ñajan Padan-aramni japa shandapa jiñasi que mama Raquelja pa. Nane Canaán andeni nepipa toya Efratani nepimbe'yi tsu pa. Tsa'caen pasi gi Efrata'su tsaiquinga a'tu. Tse'tti tsu ja'ñojan Belén. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tse'faei'ccuyi Israelja José dushundeccuma attepa iñajampaña: —Vandeccuja, ¿ma'candeqquia tsu? ");
INSERT INTO conNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joséja su: —Vandeccu tsu Chiga va Egiptoni ñanga afe'cho dushundeccu. Tsa'caen susi tise yayaja su: —Chigáne tise'pama ñanga catsianjan ña pporaemba tise'panga ñotsse tsoña'chove afaye. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israelja coenza ccashe'yeve dapa tso'fe dañongepa ñotsse atteye oshambi. Tsa'cansi Joséja tise dushundeccuma tise yayanga catsian. Catsiansi Israelja tise'pama mochapa munsin. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tsomba Joséma su: —Minga'ni'qque quema atteya'bi qquen in'jan'cho gi Chiga anttesi quema attepa toya'caen que dushundeccuma'qque atte. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tsa'caen susi Joséja tise dushundeccuma tise yáya'ye joqquitssiamba camba'jui'ccu andenga puntssan ccui. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Omboe Joséja tansinfa'su tivei'ccu Efraínma indipa ccutsian tise yayambe pavefanga. Tsomba pavefa'su tivei'ccu Manasésma indipa ccutsian tise yayambe tansinfanga. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tsa'ma Israelja tise tivema avujaccove yasapa tansinfai'ccu Efraín, tsa chu'ambe tsovema pporaen. Toya'caen pavefai'ccuja Manasés, tsa aisheve isu'chombe tsovema pporaen. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tsa'caen pporaen'chopa Josénga ñotsse tsoña'chove qquen afa: “Chiga Quitsa, ña yayandeccu Abraham'ye toya'caen Isaac'ye quema ñotsse pañamba canse'fa. Que qui ñama isu'cho a'ta ashaemba ja'ñoa'ngae ñama ñotsse coira'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Toya'caen quema sefacconi'su shondo'suja osha'cho ega'ye ñama ccushaen. Chigáne va ña dushundeccuma ñotsse tsonjan cuintsu tsendeccu'ye ña inisema aqque'pambitsse canse'faye; toya'caen ña yayandeccu, Abraham'ye toya'caen Isaac'ye inisema'qque injan'jen'faye. Va dushundeccuma ñotsse tsonjan cuintsu tsain'bie atapapa poi ande on'batsse canse'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tsa'ma Josénejan tsa'caen tise yaya tansinfa'su tivei'ccu Efraín tsovema pporaen'choja ega qquen in'jan. Tsa'caen in'jamba tise yaya tivema indi, Efraín tsove'ye itsapa Manasés tsovenga indiañe in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Indipa su: —¡Me'in, qquen tsonjama, yaya! Va tsu coenza. Vambe tsovenga tansinfa'su tivei'ccu pporaenjan. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tsa'ma tise yayaja tsa'caen tsoñe in'jambipa su: —¡Tayo gi in'jan, jaricho, tayo gi in'jan! Toya'caen tsa'qque tsu joccapitssia aindeccuve atapaya. Tsa'ma tise quinshin tsu tisema ti'tsse joccapitssiya. Nane tsambe omba'su dushundeccu tsu ti'tsse tsain'bitsse atapa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tsequi a'tayi Jacobja ñotsse tsoña'chone afapa qquen su: —Poi israendeccu ñotsse tsoña'chone su'choma afaye in'jan'da tsu que'i inisema afapa qquen su'faya: ‘Cuintsu Chiga Quitsaja Efraín toya'caen Manasésnga tsonqquia'caen quenga'qque tsoñe.’ Tsa'caen tsu Israelja Manasésma ti'tsse'tssia've Efraínma afa antte. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Omboe Joséma su: —Que canjan, paye gi tson'jen. Tsa'ma Chiga tsu quei'ccu can'jemba toequi que tayopi'su coenzandeccu'ye canse'cho andeni angaya. ");
INSERT INTO conNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Toya'caen quenga gi que antiandeccuma ti'tsse'tsse afe. Nane Siquem canqquema gi quenga afe, tsa amorreo aindeccui'ccu ña iyiccopa itsa'cho andema. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacobja poiyi'cco tise dutssiyendeccuma ttu'sepa su: “Ñanga catse'faja ña que'inga condaye jai'ngae ma'caen daya'choma: ");
INSERT INTO conNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ñanga catse'faja Jacob dutssiyendeccu. Catsepa paña'faja que yaya Israel su'choma. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubén, que qui ña dutssi'ye coenza. Que qui ña quin'sui'ccu me'ttia'ye tetacho naqquia'caen ña quin'sui'ccu aisheve isu'cho. Que qui o'tie joccapitssipa osha'choma oshacho. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tsa'ma ja'ñota qui tsa'cambi. Jongoesu shave'pa'caen qui injansembe injangae tsincon. Nane tsa'camba qui ña ambian'choi'ccu ña ana'jen'chonga ccuipa egae tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón toya'caen Levíta tsu antianaccu. Tise'pa matichija faesuma dañoñe'ñi tson'jen'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Minga'ni'qque gi tise'pa tsa'onga fae'ngae boye in'jambi. Nane iyicca'yepa qui aindeccuma fi'tti'fa. Aqquia injanga iyicca'yepa qui vaura tsu'ttema uccasho'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ega tsu. Ñoa'me ega tsu que'i ttesia'caen iyicca'ye'fa'choja. Ña gi que'ima metsse attufaeña poi Israel andeni canse'faya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, que antiandeccu tsu quema ñotsse in'jamba afa'faya. Tsifoye indipa patsuqquia'caen qui quema iyiccayesundeccuma patsuya. Ñoa'me que antiandeccu'qque tsu quenga ccarupa dyai'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Queta qui ttesi du'shua'can. Que indipa an'choma catipa ansundepa ccuipa ronda'je. Nane rande ttesia'caen qui andenga ccui. Tsa'caen ccui'ninda, ¿majan tsu quema noñangiaña? ");
INSERT INTO conNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ni majañi'qque tsu Judá manda'je'choma itsaya'bi. Ni tise tiveni an'bian'cho coen quini'ccoma'qque itsa'faya'bi tsa quini'cco na'su jiya'ngae. Tsama tsu poi canqquesundeccu paña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Tsa tsu tise boro du'shuma ofatsajanga tandaña. Tise ondiccu'jema tsu vinoi'ccu ma'ppaña. Nane bochoatsaja tsa'ccui'ccu tsu cashiya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tise tso'feta tsu vinoma ti'tsse si'an. Tise tte'ttoja vaura chochoma ti'tsse tototssi. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulónda tsu mar otafani canseya. Tse'tti tsu barco ccattufa'je'ttiya. Nane tise ande utufaja Sidón andepi nepiya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacarta tsu andu'choma andu'su boro'can. Tise ñofaje'cho tsu oveja ttuccu enttinge. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nane ande ñotssiama attepa tseni ño'faye ñotssimanda tise sepaccoma canjaen andupa angaye. Ni poini afambe'yi tsangae sema'suve da. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Danda tsu tise aindeccuma mandaya fae'ngae faesu Israe'su aindeqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Toya'caen Danda tsu iyoa'caen tsoña. Nane iyo tsaiquini tsu ccui cavayo tsu'ttema sinttuye cuintsu tsani dyai'suja amppiye. Tsa'caen tsu Danjan patsuya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ña Na'su, ¡ronda'je qui que ñama ccushaeñe! ");
INSERT INTO conNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadmanda tsu sundarondeccu iyiccoye ji'faya. Tsa'ma omboe tsu tiseja patsupa mandiaña. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aserta tsain'bitsse panme an'biamba nasundeccunga'qque anqque'suma afe'jeya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalíta tsu shan'ccoa'caen opatsse jacan. Tise dushundeccu'qque me'detssi'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joséta tsu quini'cco na'en otafani ccutsupa ñotsse namba ttuccu ccafanga'qque furiqquia'can. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Battittiansundeccu tsu tisema chi'gapa noñangiamba pa'cco a'ta battittian'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tsa'ma Joséja tise tive quin'amba oyambitsse tise battittianccuma indipa poini battittian'jen. ¡Ñotssi tsu Jacobmbe Chiga Osha'choma Oshacho'cho! ¡Ñotssi tsu coira'sumbe inise. Tise tsu israendeccuma angacan! ");
INSERT INTO conNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","José, ¡ñotssi tsu que yaya'yembe Chiga! Tsa tsu quema fuiteya. Tsa Chiga Osha'choma Oshacho'cho tsu quema ñotsse tsoña'chone afaya. ¡Nane sefaccone tsu quema ñotsse tsoña! ¡Mar tsosine'qque tsu quema ñotsse tsoña! Toya'caen quema ñotsse tsonsi tsu que'su pushesundeccuja tsain'bio du'shuve isupa chochoemba coeña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ña que yayata gi ña yaya'ye ñama ñotsse tsoña'chove su'choma ti'tsse quema ñotsse tsoña'chove afa'je. Nane Chiga Joséma tise antiandeccu'ye ttu'sesi tsu ccotta'cco sefaya'ngae va ñotsse tsoña'cho su'choja José aindeccunga tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamínda tsu putsa'su ain'can. Nane sinte tise indi'choma amba sime tise an antteye'choma attufaen.” ");
INSERT INTO conNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Vandeccu tsu Israel aindeccu'su doce naccu. Toya'caen tsa'caen tsu tise'pa yayaja poiyi'cco tise dutssiyendeccunga tise'pa jai'ngae ma'caen daya'chove afa. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Fae a'ta Jacobja tise dutssiyendeccunga qquen manda: —Ca'tsa tsu ña paya'cho nepiji. Ña pa'ninda ña tayopi'su coenzandeccuyi'ccu pporotsse ñama'qque a'tu'faja. Nane hitita'su a'i Efrón ande'su fattocco changonga ñama a'tu'faja. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Tsa tsu Macpela fattocco chango Mamre canqque isevetsse Canaán andeni. Abraham'ye tsu tsa fattocco chango, toya'caen tse'tti'su andema'qque Efrómbema chava tise aindeccuma tsanga atu'jeye. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tse'ttinga tsu a'tu'fa Abraham, tise pushe Sarama'qque, toya'caen Isaac, tise pushe Rebecama'qque. Toya'caen gi ña'qque tse'ttinga Leama a'tu. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tsa ande toya'caen tsa changota tsu hititandeccuma chava'cho. ");
INSERT INTO conNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacobja tsa'caen tise dutssiyendeccunga condase nanimba ccase ana'jen'chonga ccuipa pa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tsa'caen pasi Joséja tise yaya ai'voma munsimba i'namba mocha. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Omboe tise mandasi sejesundeccuma manda cuintsu tise yaya Israel ai'voma tseni'su balsa'mo ñome'bai'ccu onjoen'faye junde congonsa'ne. Tsa'caen mandasi tsa'caen tsu tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nane tsa'caen pa'chombe ai'voma onjoeñe cuarenta a'ta tsa balsa'mo ñome'bai'ccu onjoen'jeña'cho. Nane tsa'caen tsu injienge. Tsonsi egiptondeccuja setenta a'ta pa'cco Israelne i'na'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ina'jen'cho pasapa Joséja faraón tsa'o'su joccapindeqquiama qquen su: —Que'ija ñama ñotsse in'jan'da chigáne faraónga qquen conda'faja: ");
INSERT INTO conNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ña yayaja tise paya'cho nepiji tsu ñama su cuintsu ñajan ñoa'metsse su'choma afaye tise in'jan'chove tsoñe. Nane tiseja atu'ttima Canaán andeni tayo ñoñamba tseni a'tuyeye in'jansi gi ñoa'metsse su'choi'ccu tsa'caen tsoñe su. Tsa'camba gi iñajan chigáne ñama antteja ña yayama atu'ngaye. Japa mangae a'tu nani'da gi ccase vani jiya.’ ");
INSERT INTO conNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pañamba faraónjan su: —Jujú, japa que yayama atungaja tise iñajanqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Faraón anttesi José tise yayama a'tu'su jayisi poiyi'cco faraónma shondosundeccu, Egipto ande'su coenzandeccu'qque Joséma fuiteye ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Toya'caen Jacob dutssiyendeccu, nane José tsa'o'su aindeccu, José antiandeccumbe aindeccu'qque jaja'fa. Gosén andenijan jo'su dushundeccu toya'caen tise'pa aiña'chondeccuveyi cati'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Toya'caen faesu aindeccu'qque qquitssa'je'cho carongae majanda cavayongae japa tsain'bio a'i tsu Joséma fuite'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jordán na'ema chiga sombo'jefanga Atad trigo ttonoma qquesho'je'ttinga nepipa ñoa'me ñombi'yepa i'nañe ashaen'fa. Nane tse'ttinga tsu Joséja tise yaya pa'chone asi'ttaemba siete a'ta pa'cco ñombi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tsa'caen i'na'fa'choma attepa tse'tti'su canjaen'su cananeondeccuja su'fa: “Nane egiptondeccuja tise'pa'su joccapitssia pasi tsa'caen i'namba a'tu'fa.” Tsa'caen supa tse'ttima inisian'fa Abed-mizraim, “Egiptondeccu ñombi'ye'tti” qquen suye. Tse'tti tsu Jordán na'ema chiga sombo'jefa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tsa'caen tsu Jacob dutssiyendeccuja pa'cco tise'pa yaya iñajan'choma tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nane Canaánni angapa Macpela ande'su fattocco changonga a'tu'fa. Abraham tayoe tise aindeccuma atu'jeya'chove tsa fattocco changoma hitita'su a'i Efrómbema chava'chonga tsu Jacobma'qque a'tu'fa. Tsa ande toya'caen changota tsu Mamre canqquema chiga sombo'jefani. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tise yayama a'tu nanimba Joséja tise antiandeccui'ccu toya'caen poiyi'cco tisei'ccu jacansundeccu'qque toequi Egiptoni ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tsa'caen Jacob pasi José antiandeccuja qquen in'jan'fa: “Isha tsu ja'ñonda Joséja ingima chi'gapa ccane'qque ingi tisema egae tsonqquia'caenjan tsoña.” ");
INSERT INTO conNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tsa'caen asi'ttaemba faesuma manda'fa cuintsu Josénga japa qquen condaye: “Toya pambi'te tsu que yayaja ingima manda ");
INSERT INTO conNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","quenga qquen suye: ‘Quema gi iñajan chigáne que antiandeccu egae tsincon'choma aqque'papa ñoquija. Nane ñoa'me tsu tsendeccu quema egae tson.’ Tsa'caen su'chosi gi quema iñajan'fa ingi egae tsincon'choma aqque'paja. Nane ingita gi que yayambe Chigama shondosundeccu.” Tsa'caen su'fa'choma conda'fasi pañamba Joséja i'na. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","José ina'jen'ni ñoa'me tise antiandeccu'qque jipa andenga camba'jui'ccu puntssan ccuipa qquen su'fa: —Que canjan, va'tti qui ingima an'bian tsangae quembe semasundeccuve. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tsa'ma Joséja tise'panga su: —¡Dyombe can'faja! Ñajan Chigambi gi injama'choma somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Que'ita qui ñama egae tsoñe in'jan'fa. Tsa'ma Chiga tsu tsa ega'ye cambiamba ñotssiave canjaemba tsain'bio a'ima ccushaen, ingi ja'ño a'ta atteqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tsa'cansi dyombe can'faja. Ña gi anqque'suma afe'jeya que'inga toya'caen que'i dushundeccunga'qque. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José toya'caen tise yaya Jacob dutssiyendeccu'qque bo'tsse Egipto andeni canse'fa. Joséja ciento diez canqque'fave cansepa ");
INSERT INTO conNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","tise dutssi'ye Efraíne tercer omba'su dutssi'yema'qque atte. Toya'caen Manasés dutssi'ye Maquirmbe dushundeccuma'qque tsu attepa mende'je. ");
INSERT INTO conNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Fae a'ta Joséja tise antiandeccunga su: “Re'ricco tsu shaca ña paya'cho. Tsa'ma Chiga Quitsa tsu jipa que'ima fuite'jeya. Toya'caen tise tsu va ande'ye que'ima somboemba Abrahamnga, Isaacnga, toya'caen Jacobnga afeye su'cho andenga que'ima angaya.” ");
INSERT INTO conNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tsa'caen supa Israel dutssiyendeccuma su cuintsu ñoa'metsse su'choi'ccu tise in'janqquia'caen tsoñe qquen su'faye: “Ñoa'me gi su Chiga Quitsa jipa tsu fuiteya. Tsa'caen ashaensi jayi'ta ña tsu'ttama'qque somboemba anga'faya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joséja ciento diez canqque'fave an'biamba Egiptoni pa. Tsa'caen pasi tise ai'voma tseni'su balsa'mo ñome'bai'ccu onjoemba cafonga ppiña'fa.");
INSERT INTO conNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Qquen tsu Jesucristo tayopi'su antiandeccu. Tiseja tayopi'su David omba'su dutssi'ye tsu. Tayopi'su Abram omba'su dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamjan Isaac quitsa tsu. Isaacja Jacob quitsa. Tiseja Judá quitsa. Judá antiandeccu'qque tsu Jacob dushundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá tsu Fares quitsa. Tise faesu du'shuja Zara. Tsendeccumbe mamajan Tamar tsu. Fares tsu Esrom quitsa. Esrom tsu Aram quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramja Aminadab quitsa tsu. Aminadabja Naasón quitsa. Naasónjan Salmón quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón tsu Booz quitsa. Booz mama tsu Rahab. Booz tsu Obed quitsa. Obed mama tsu Rut. Obedja Isaí quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíja na'su David quitsa tsu. Davidja Urías'ye pasi tsandupajen'choma pushepa Salomón quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónjan Roboam quitsa tsu. Roboam tsu Abías quitsa. Abías tsu Asa quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tsu Josafat quitsa. Josafat tsu Joram quitsa. Joram tsu Uzías quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasja Jotam quitsa tsu. Tiseja Acaz quitsa. Acazja Ezequías quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasja Manasés quitsa. Manasésja Amón quitsa. Tiseja Josías quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Israendeccuma indipa Babilonia andeni angai'te Josíasja Jeconías, tise antiandeccuma'qque isupa Jeconías quitsa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Omboe Babiloniani japa Jeconíasja Salatiel quitsa tsu. Salatiel tsu Zorobabel quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tiseja Abiud quitsa. Abiudja Eliaquim quitsa. Tiseja Azor quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor tsu Sadoc quitsa. Sadocja Aquim quitsa. Tiseja Eliud quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tiseja Eleasar quitsa. Tiseja Matán quitsa. Matán tsu Jacob quitsa. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobja José quitsa tsu. José tsu Maríama pushe. Maríaja Jesús mama tsu. Jesúsja Cristo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsa'caen Abrahamne Davidngae catorce yayandeccu'su du'shuve tsu agatto. Davidne Babiloniani anga'chongae catorce yayandeccu'su du'shuve tsu agatto. Babiloniani anga'chone Cristo jiya'ngae'qque catorce yayandeccu'su du'shuve tsu agatto. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Qquen tsu Jesucristoma isu'cho. Tise chanjan, María Josénga tayo iñajañemba toya tsandiei'ccu fae'ngae can'jembe'yi surie da. Chiga Quendya'pa tisenga jisi surie da. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Surie dasi Joséja ño'a a'ipa tsama atesupa Maríama pusheye in'jambi. Tsa'ma poiyi'cco a'inga tsama condaseye in'jambipa a'tutsse Maríama catiye asi'ttaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsa'caen asi'ttaen'jen'ni Na'su Chigama sefacconi'su shondo'su tisenga ji. José anamba ayo'osi sefacconi'su shondo'su attiamba su: —¡José, David dutssi'ye! Dyombe'yi que pushe Maríama que tsaoni angaja. Tise ttopanga an'du'cho du'shuja Chiga Qquendya'pa du'shu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tsandie du'shuve tsu isuya. Tise aindeccuma tsu tise'pa egae tsincon'cho'ye ccushaeña. Tsa'cansi tisema qui inisian'faya Jesúsve. Jesús qquenda tsu ccushaen'su qquen su. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Qquen tsu Jesúsma isu'choja, Na'su Chiga tayopi suqquia'caen tsoñe. Nane Na'su Chigaja Tise Aya'fama afa'sui'ccu qquen tsu su: ");
INSERT INTO conNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Toya tsandiei'ccu cansembi'choa pushesu tsu surie dapa tsandie du'shuve isuya. Du'shumbe iniseja Emanuelya tsu. Chiga ingi'ccu can'jen, qquen tsu suye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsonsi José ana qquendyapa Na'su Chigama sefacconi'su shondo'su suqquia'caen tson. Maríama i'ngapa tise pusheve tsaoni i. ");
INSERT INTO conNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fae'ngae tsaoni can'je'an'qque du'shuma isuya'ngae toya fae'ngae canse'fambi. Tsandie du'shuve isupa tisema inisian'fa Jesúsve. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesúsja Belén canqqueni isu'cho. Judea ande'su canqque tsu. Herodes na'suite tsu Jesúsma isu'cho. Tsa'caen isusi biani'su injama'pandeqquia tisema can'su ji'fa. Chiga sombo'jene jipa Jerusaléni ca'nimba ");
INSERT INTO conNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","iñajampaña'fa: —¿Mani tsu voeyi isu'cho israe na'suja can'jen? Coejechiga sombo'jeni can'jemba gi tise o'fema attepa ttatta'su ji'fa Tisema iñajamba ñotsse afaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ande na'su Herodesja tsama pañamba dyo, faesu na'su tisema joqquitssiansa'ne. Poiyi'cco Jerusaléni can'jensundeccu'qque asi'ttaemba dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodesja Chigama afa'su nasundeccuma ttu'se. Toya'caen Chiga manda'choma atesiansundeccuma'qque ttu'sepa tsendeccuma iñajampaña Cristoja mani isuyeya'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsendeccuja su'fa: —Judea ande'su Belén canqqueni tsu tisemajan isuya'cho. Nane qquen tsu tayopi'su Chiga Aya'fama afa'suja Chiga Aya'fama tevaemba su: ");
INSERT INTO conNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Queja Judá ande'su Belén canqque, Faesu Judá'su canqquema bove'ccombi qui. Nane que'ye tsu ande na'suja somboya. Tiseja ña aindeccuma tsu coirapa mandaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsonsi Herodesja a'tutsse injama'pandeqquiama ttu'sepa iñajampaña: —¿Minga'ni qui na'su o'fema tseyi atte'fa? Qquen susi tise'pa condasesi pañamba ");
INSERT INTO conNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","injama'pandeqquiama manda maña Beléni. Mandapa su: —Japa du'shuve ñotsse ttatta'faja. Atte'ta tse'faei'ccuyi ñama'qque conda'faja ña'qque japa tisema iñajamba ñotsse afaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na'su Herodes tsa'caen mandasi Beléni ja'fa. Tise'pa chiga sombo'jeni can'jemba atte'cho o'fema'qque ccase atte'fa. Tsa o'feja tise'pama o'tie japa du'shu can'jeni napipa tsambe ombanga chanjun. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsa o'fema attepa ñoa'me avuja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tsaoni ca'nimba du'shu Jesúsma atte'fa, tise mama Maríama'qque. Du'shuma attepa ccaru dyaipa tisema iñajamba ñotsse afa'fa. Ñotsse afapa tise'pa cafoma'qque fettapa osha'cho ñotssiama afe'fa. Nane cori, toya'caen bare'cho oque oraenqque'su ñome'ba, toya'caen mirra ñome'bama'qque afe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsa'ma na'su Herodes mandaqquia'caen toequi ja'fambi. Nane ayoni in'jamba Herodesni jambe'yi ccafae tise'pa andeni ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tsa'caen tise'pa andeni ja'fasi Na'su Chigama sefacconi'su shondo'su jipa Josénga attian. José anamba ayo'osi attiamba su: —Qquendyapa jangija. Du'shuma, tise chama'qque angapa Egipto andeni ccuyaja. Tseni can'jen'faja ña condaya'ngae. Nane Herodesja iyicca'yepa du'shuve tta'ttaye ashaen fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tse'faei'ccuyi José qquendyapa jangi. Jangipa toya sinttia'ni du'shu Jesúsma, tise chama'qque qquendyaemba sombo'fa Egipto andeni jaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tseni japa Herodes paya'ngae can'jen'fa. Tsa'caen tsu tson'fa Na'su Chiga tayopi suqquia'caen tsoñe. Nane Na'suja Tise Aya'fama afa'sungae tsu su: “Ña Dutssi'yema ttu'sepa gi Egipto ande'ye somboen.” ");
INSERT INTO conNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Injama'pandeqquia ccafaeyi ja'fasi ande na'su Herodes pañamba afopoen'fa qquen in'jamba ñoa'me iyicca'ye. Iyicca'yepa manda cuintsu poiyi'cco Beléni'su tsandie du'shuma fitti'tti'faye. Toya'caen Belén canqque pporotsse can'jensundeccumbe tsandie du'shuma'qque fitti'ttiye manda. Nane injama'pandeqquiai'ccu tayo condasepa o'fe maqui attian'choma agattopa poiyi'cco tsandie dushundeccu majan dos canqque'fama bove'ccoama fitti'ttiye manda. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tsa'caen tsu fittitti'fa, tayopi'su Chiga Aya'fama afa'su Jeremías suqquia'caen tsoñe: ");
INSERT INTO conNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá andene aya'fama paña'fa, i'namba ñombi'yepa ñoa'me fundo'je'choma. Raquel tsu tise dushundeccune ñombi'yepa ina'jen. In'jambi tsu tise ina'jen'choma vuiquiya. Nane tsangae tsu tise dushundeccuja pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Omboe Herodes pasi Na'su Chigama sefacconi'su shondo'suja ccase Josénga attian. José Egiptoni can'jemba anamba ayo'osi attiamba ");
INSERT INTO conNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","su: —Qquendyapa jangija. Du'shu Jesús, tise chama'qque qquendyaemba toequi israe andeni jaja'faja. Nane du'shuma fi'ttiye in'jan'chondeccu tayo tsu pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsonsi José jangipa du'shuma, tise chama'qque qquendyaemba israe andeni jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tsa'ma Herodes dutssi'ye, Arquelao, Judea na'suve da'choma pañamba tseni jaye dyojo. Dyojopa ccase ayo'opa in'jamba Judeani jambe'yi Galilea andeni japa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nane Nasaret canqqueni japa can'jen'fa. Tse'tti can'jemba tsu tayopi'su Chiga aya'fama afa'su suqquia'caen tson. “Tiseja Nasareno tsu” qquen tsu tayópija su. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tsomba tse'i bo'tssingae feti'su Juan Judea ande'su a'i menia jipa a'ima candusiañe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Qquen tsu candusian: —Que'i egae tsincon'choma chi'gapa cati'faja. Ca'tsa tsu napiji ingi Chigama na'sian'cho aindeccuve da'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juane tsu tayopi'su Chiga Aya'fama afa'su Isaíasja conda. Qquen tsu Isaías tayopi tevaen: A'i aya'fama qui paña'faya a'i menia'ñe qquen fundo'je'choma: “Na'su jiya'chove ñoña'faja. Tise tsaiquima tansianqquia'caen que'i injama'choma tansian'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan ondiccu'jeja camello tosema otata'cho tsu. Ttono utuqui'fai'ccu tsu utuquicho. Tise anqque'suja ttombu, tuño cuñajun'cho'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tse'tti can'jensi a'ija Jerusaléne, poi Judea'su canqquene'qque, tisenga bo'fa. Toya'caen Jordán na'en'su andene'qque jipa tisenga bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bopa Juan candusian'choma pañamba tise'pa egae tsincon'choma chi'gapa tsane conda'fa. Conda'fasi Juanjan tise'pama feti Jordán na'enga. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tsain'bio “fariseo gi” qquen in'jan'chondeccu, “saduseo gi” qquen in'jan'chondeccu'qque Juan feti'je'ni ji'fasi Juanjan tise'pama su: —Que'ija ñoa'me iyo dushundeqquia'can'fa qui. ¿Majan tsu que'imajan dyoña? Chiga iyicca'yepa fi'ttiya'choma pañamba ¿fetiyepa ccushaye'ta ti qui in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Injama'choni egae tsincon'choma catiye in'jan'da tsa'caen egae tsincombe'yi canse'faya'cho tisu in'jan'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Injanga “Tayopi'su Abraham ingi yayasi gi ccusha'faya” qquen su'fajama tisupa injama'choma ñoquiañe. Nane israendeccuja cca'indeccuma bove ñotssimbi tsu. Chiga in'jan'da va patundundu'ye a'ive tsoñe osha Abraham dushundeccuve dapa Chigama shondocañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Quini'jin ñotsse nambisi a'ija tsama ttuttupa si'tsipa oque'faya. Ovacco'choma tsuiñaqquia'caen Chigaja tayo ñoña que'i injama'choma somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Que'i egae tsincon'choma chi'gapa catiye in'jansi gi tsa'ccui'ccu que'ima feti'je. Tsa'ma ñama ti'tsse'tssia tsu jiña. Ñajan utu'ccoa. Shaca gi tise sapatoma anga'suve ca'niñe. Tise jipa tsu Chiga Qquendya'pai'ccu que'ima fetiya. Tsambi'ta si'ngei'ccu fetiqquia'caen tsu injama'choma somboeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigoma qque'shopa parai'ccu chhoi ttovapa fingiain'ccu ttonoma catiqquia'caen tiseja jiña tise'be aindeccu'ye cca'ima attufaeñe. Ñotssia trigoma tsa'onga boñaqquia'caen tsu tise aindeccuma ñoñaña. Tsa'ma trigo ttonoma oque catiqquia'caen tsu tise've in'jambindeqquiama pa'masia si'ngenga tsangae catiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juan tsa'caen candusiamba feti'je'ni Jesúsja Galilea andene Jordán naeni ande Juanga fetiyeye. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsa'ma Juanjan tisema se'piye in'jamba qquen su: —Ña gi quenga fetiyeya'cho. ¿Jongoesie qui queja ñanga fetiyeye ji? ");
INSERT INTO conNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsa'ma Jesúsja Juanga su: —Cuintsu queja ñama fetiya'cho. Tsa'caen tsomba gi ingija pa'cco Chiga in'jan'chove ñotsse tson'faya. Tsa'caen susi Juanjan ti'tsse se'pimbe'yi Jesúsma feti. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús fetiyepa na'eñe sombojisi tse'faei'ccuyi Chigaja sefaccoma fetta. Fettasi Jesúsja Chiga Qquendya'pama atte. Nane Chiga Qquendya'pa ppuppuju'choa'caen attiamba tisunga andeji'choma atte. ");
INSERT INTO conNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sefaccone aya'fa'qque afapa qquen su: —Vaja ña in'jan'cho Dutssi'ye tsu. Ñoa'me gi tisema ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsomba tse'i Chiga Quendya'paja Jesúsma fendepa anga a'i menia cuintsu cocoya na'su tisema qqueñacañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tseni cuarenta a'ta cuarenta cose'qque ambe'yi can'jen. Ambe'yi can'jemba ñoa'me qquipoe'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Qquipoe'susi cocoya na'suja tisenga jipa qqueñacañe in'jamba su: —Queja ñoa'me Chiga Dutssi'ye'ta mandaja cuintsu va patu sheque'cho anqque'su panme dasi añe. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tsa'ma Jesúsja su: —Chiga Tevaen'jeni qquen tsu tevaen: “Aqquia'yi anqque'suma amba a'ija canse'faya'bi. Tsa'ma Chiga Aya'fa a'ima in'jaensi tsu canse'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsonsi cocoya na'suja Jesúsma Jerusaléni anga. Angapa Chiga etti'su tansinfanga ccutsiamba ");
INSERT INTO conNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tisema su: —Queja ñoa'me Chiga Dutssi'yeta vane butto amppija. Chiga Tevaen'jenga qquen tsu tevaen: Chigaja Tisema sefacconi'su shondosundeccuma mandaya quema coiraye. Tise'pa tivei'ccu quema opipa ñotsse coira'faya que tsu'tte patunga iñaccasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesúsja su: —Toya'caen tsu Chiga Tevaen'jenjan qquen su: “Chigaja que Na'su tsu. Tisema qqueñambe canjan.” ");
INSERT INTO conNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ccase qqueñacañe in'jamba cocoya na'suja Jesúsma se'fatssia ccotta'cco tansinfanga angapa tse'faei'ccuyi pa'cco a'i can'jen'cho andema canjaen. Tise'pa ñotssiama canjaemba ");
INSERT INTO conNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","su: —Que qui ñanga ccarupa iñajan'ninda gi pa'cco va andema quenga afeya que na'suve dapa pa'tssima mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsa'ma Jesús tisema su: —Satana, ña'ñe biani jaja. Chiga Tevaen'jenga qquen tsu tevaen: “Na'su Chiga Quitsaveyi iñajaña'cho. Tise'veyi shondocaña'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsonsi cocoya na'suja Jesúsma catipa ja. Jasi Chigama sefacconi'su shondosundeccu Jesúsnga jipa tisema quiñaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na'su Herodes Juanma iyicca'yepa indipa picco. Jesús tsane pañamba Galilea andeni toequi ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaretni can'jembipa Capernaumni japa can'jen. Galilea mar'su canqque tsu. Tayopi'su israe'su Zabulóndeccu, Neftalíndeccumbe ande tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesúsja tseni can'jen Chiga Tevaen'jen suqquia'caen tsoñe. Nane tayopi'su Isaíasja qquen tevaen: ");
INSERT INTO conNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón ande, Neftalí ande'qque, Marni ja'je'cho tsaiqui jin'tti, toya'caen Jordán na'en jonifani'qque, Israembindeqquia can'jen'cho Galilea ande tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nane tseni'su aindeccuja sinttia'ni can'jenqquia'caen Chigane atesu'fambi. Atesumbi'choa tsu a'tatssia'ma attepa in'jan'fa. Injanga can'jemba paye ronda'je'fa'a. Tsa'ma a'tatssia tise'panga attiansi attepa in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús tseni japa candusiañe ashaemba su: —Que'i egae tsincon'choma chi'ga'faja. Ca'tsa qui Chigama na'sian'cho a'ive daji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesúsja Galilea mar otafa'ye jacamba dos tisu antianaccu jacan'fa'choma atte. Simón –tsambe faesu inise Pedro– tise quinshin Andrési'ccu marma avuve vachocan'fa. Tsa'caen semamba ganamba canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesúsja tise'pama attepa ttu'sepa su: —Ñai'ccu jipa jacan'faja. Ña gi que'ima tsoña avuma ttuqquia'caen a'ima ttu'sesundeccuve. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tse'faei'ccuyi tise'pa vacho'vama catipa Jesúsi'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ti'tsse joccani japa faesu dos tsa'candeqquiaveyi atte. Santiagoma –tsa Zebedeo dutssi'ye– tise quinshin Juanma'qque. Tsendeccuja, tise'pa yaya Zebedeoi'ccu shavoni dyai'fa. Dyaipa tise'pa vacho'vama uga'je'fa. U'gá dyai'fasi Jesúsja tsendeccuma'qque ttu'se. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ttu'sesi tse'faei'ccuyi tise'pa yayama shavonga catipa Jesúsi'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesúsja pa'cco Galilea ande'ye jacan. Jacamba tseni'su Chiga Aya'fama atesian'jen'ttinga ca'nimba Chigambe aindeccuve daya'chone ñotsse condase'choma atesian'jen. Toya'caen aindeccu osha'cho paqque'sui'ccu paji'fasi Jesúsja tise'pama ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pa'cco Siria ande'ye Jesús ji'choma pañamba pajisundeccuma tisenga i'fa. Majan a'ija osha'cho paqque'sui'ccu, osha'cho iña'sui'ccu, toya'caen cocoya ca'ni'cho'qque, shanccopajashendeccu, ishopa paqque'sunga dañongendeccuma'qque tisenga isi tsu poiyi'ccoma ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tsain'bio a'i pa'cco Galilea ande'ye, Decápolis ande'su canqque'su'qque tisenga ji'fa. Nane Jerusaléne, pa'cco Judea andene'qque, Jordán na'en jonifane'qque tisenga jipa bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesúsja poiyi'cco a'ima attepa ccotta'cconga ansundepa dyai. Dyaipa tisema shondosundeccu tisenga bo'fasi ");
INSERT INTO conNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tise'pama atesiañe ashaen: ");
INSERT INTO conNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Que'i majan tisutsseyi Chiganga catseye oshambi qquen in'jan'da ñoa'me qui avujatssi'fa. Chigama na'sian'cho aindeccuve qui da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Que'i majan ñombi'yepa ina'jen'da ñoa'me qui avujatssi'fa. Chigaja que'ima mendeyepa ñombiye'choma tsu vuiquiaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Que'i majan injama'choni cca'ima patsumbe'yi can'jen'da ñoa'me qui avujatssi'fa. Pa'cco andema que'inga afesi isupa qui manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Que'i majan qquipoe'supa toya'caen tsaqquie'supa ttepuye in'janqquia'caen ño'ame daye in'jan'da ñoa'me qui avujatssi'fa. Chiga tsu que'ima ño'ame tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Que'i majan cca'ima mende'ye'ta ñoa'me qui avujatssi'fa. Chiga'qque que'ima mende'yepa ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Que'i majan injama'choni egama in'jambi'ta ñoa'me qui avujatssi'fa. Chiga Quitsama qui atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Que'i majan opatsse canseye in'jan'chondeccuta ñoa'me qui avujatssi'fa. Chiga tsu que'ima Tise dutssiyendeccu qquen suya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Que'i majan ñotsse tsonsi cca'indeccu que'ima chi'gapa noñangiansi vana'je'an'qque ñoa'me qui avujatssi'fa. Chigama na'sian'cho aindeccuve qui da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Que'i majan ñame in'jansi cca'indeccu que'ima afasepa, noñangiamba osha'cho egave afopoen'ni'qque qui ñoa'me avujatssi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nane avujatsse can'jen'faja. Chiga sefacconi qui tsain'bitssia'ma isu'faya. Que'ima afaseqquia'caen tsu tayopi'su a'i'qque que'ima otien'su Chiga Aya'fama afasundeccuma'qque afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Que'ija va ande'su a'ine patu ansiancan'fa qui. Tsa'ma patu ansi'ñe ansin tssutssu catiye'ninda ¿ma'caen tsu ccase ansinpave daya? Ñoa'me barembi tsu. Tsa patuma injanga catiya'cho cuintsu a'i tsangae tsui jacan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Que'ija va ande'su a'ine tuñoacan'fa qui. Majan canqquema ccotta'cco ombanga canqquian'nijan ¿ma'caen tsu a'tutssiya? ");
INSERT INTO conNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Toya'caen a'ija tuñoma setsaemba cafon puvian'cho tsosiccunga ccutsian'fambi. Tsa'ma sefani tsu pisa ancaeña'cho poi tsaoni can'jensundeccu ñotsse atte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Que'i'qque tsa'caen tuño chanjunqquia'caen poiyi'cco a'inga attiaña'cho. Ñotsse canseya'cho cuintsu a'i que'i ñotsse tson'choma attepa in'jamba que'i Yaya sefacconi can'jen'cho Chiga Quitsama ñotsse afa'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jimbi gi Chiga manda'choma joqquitssiañe; ni tayopi'su Chiga Aya'fama afasundeccu su'choma joqquitssiañe. Tsa'caen in'jan'fajama. Ñanda gi ji tsama joqquitssiambe'yi pa'cco Chiga manda'cho, pa'cco Chiga Aya'fa su'choma'qque tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ñoa'me gi que'ima su: Sefacco ande'qque osefaeña'cho napiya'ngae tsu Chiga manda'choja toya jinchoya. Ni fae tevaen'tti'cco tsu pasaya'bi. Nane Chiga in'jamba manda'chove tsoña'gae ni fae e'e'qque pasaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Majan a'i va manda'cho utu'ccoe su'choma catipa ccaningae tsomba cca'indeccuma tsa'caen atesian'da Chigama na'sian'cho aindeccuve da'je'fasi tsaja utu'ccoe daya'cho. Tsa'ma majan a'i Chiga manda'choma pañamba cca'indeccuma tsa'caen atesian'da Chigama na'sian'cho aindeccuve da'je'fasi tsaja joccapitssia've tsu daya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nane ñoa'me gi su que'ija fariseondeccuma ti'tsse ñotssimbipa Chiga manda'choma atesiansundeccuma ti'tsse ñotssimbi'ta, ñoa'me qui Chigama na'sian'cho a'ive da'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Que'i pañaqquia'caen tayopi Chigaja a'ima manda: “Faenga'su a'ima fi'ttijama.” Majan a'i faesu a'ima fi'tti'ninda tsama na'sunga angaya'cho cuintsu injama'choma somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tsa'ma ñanda gi que'ima su: Majan a'i tise faenga'sui'ccu iyicca'ye'ninda tsama'qque tsu na'sunga angaya'cho cuintsu injama'choma somboeñe. Nane majan a'i tise faenga'suma “sumbi” qquen afase'ninda nasundeccu bo'fa'chonga tsu angaya'cho tise injama'choma somboeñe. Toya'caen tise faenga'suma “injamambi” qquen afase'ja tsa a'ija si'nge anchanda'je'chonga catiyeye tsu tsa'caen tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tsa'cansi que'ija Chiga ettini japa que'i Chiganga afeya'choma oque'je'chonga afeye tson'jen'da tsu ñotsse in'jaña'cho. “Ña faenga'suja ñama iyiccaye'je” qquen in'jan'da ");
INSERT INTO conNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","que Chiganga afe'je'choma afembe'yi tse'ttinga catija. Catipa tsu tse'faei'ccuyi junde faenga'sunga japa ñoquiaña'cho. Tayo ñoquiamba toequi jipa que afe'je'choma Chiganga afeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","A'i quema iyicca'yepa que egae tson qquen supa na'sunga angaji'ninda tsu toya na'sunga napimbi'te tisema ñoquiaña'cho. Ñoquiambian'da tsu na'sunga quema afeya. Na'su'qque capitáma tsu mandaya quema indiye. Indipa tsu picco'je'cho ettinga quema piccoya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ñoa'me gi su: Tseni piccoye'ta tsu pa'ccoma nane reama'qque afepoeña'cho tisu somboye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Que'ija tayo paña'fa qquen su'choma: “Quenga casarambichoi'ccu fae'ngae can'jenjama.” ");
INSERT INTO conNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tsa'ma ñanda gi que'ima su: Majan a'i pushesuma camba in'jangae in'jan'da tayo tsu tisu injama'choni tisei'ccu fae'ngae can'jen'ma'caen in'jamba egae tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nane que tansinfa'su tso'fe quema egae tsincoe'ninda tsu tsefama quiccu tssan'jaña'cho. Bove ñotssi tsu fa'e que ai'voni jincho'choma qqueñamba ccushaye. Tsambi'ta pa'cco ai'vo tsu si'nge anchanda'je'chonga catiyeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Toya'caen que tansinfa'su tive quema egae tsincoe'ninda chattupa catija. Bove ñotssi tsu fa'e que ai'voni jincho'choma qqueñamba ccushaye. Tsambi'ta pa'cco ai'vo tsu si'nge anchanda'je'chonga catiyeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Toya'caen tsu tayoe su: “Majan a'i tise pushema catiye in'jan'da tsu catiya'cho tevaen'jema tevaemba pushesunga afeya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tsa'ma ñanda gi que'ima su: Majan a'i tise pushe faesui'ccu can'jemba tsa'caen egae tsincon'ninda tisema catiye osha. Tsa'ma tise pushe ñotsse tisei'ccuyi can'jen'choma, tsandie chi'gapa catiye in'jan'da egae tsu tsincoen pushesuma. Toya'caen faesu tsandie tsa catiye'cho pushesuma pushe'ta tise'qque tsai'ccu can'jemba egae tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Toya'caen qui paña'fa tayopi'su a'inga qquen su'choma: “ ‘Chiga paña'je'ni gi tansintsse su’ qquen su'ta afopoembe'yi tsu suya'cho. Ñoa'me que suqquia'caen tsu tsoña'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tsa'ma ja'ño gi que'ima su: Tsa'caen afa'fajama tansintsse su'cho qquen canjaeñe in'jamba. Nane “Sefacco paña'jen'ni gi tansintsse afa'je” qquen tsu su'fa tise'pa su'choja tansintssi qquen canjaeñe. Tsa'ma Chiga Quitsa tsani dyaipa manda'jesi tsa'caen su'cho'qque “Chiga paña'jen'ni gi afa” qquen su'choa'cañi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Toya'caen “Ande paña'jen'ni gi tansintsse afa'je” qquen su'cho'qque tsani Chigambe tsu'tte tsuicho'chopa tsa'caeñi tsu afaye. Toya'caen “Jerusalén paña'jen'ni gi tansintsse afa'je” qquen su'cho'qque osha'chone Ti'tsse'tssia Na'sumbe canqquepa tsa'caeñi tsu afaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Toya'caen que tsovema tansintsse su'choma canjaeñe afa'fajama. ¿Oshaya ti qui fae tosema si'ame tsoñe'da? ¿Oshaya ti qui fae tosema totoave tsoñe'da? Nane tsa'caen tsoñe oshambi'ta que tsovema tansintsse su'choma canjaeñe afa'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tsa'ma jongoesuma afambe'yi aqquia'yi “ju” qquen su'faya'cho. Tsambi'ta “me'i” qquen su'faya'cho. Osha'cho ti'tsse afa'je'choja cocoya na'su in'jaensi afa'je'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Que'ija paña'fa qquen su'choma: “Tso'fema tssaña'nijan ccane'qque tsambe tso'fema tssañaña'cho. Tte'ttoma ucca'nijan ccane'qque tsambe tte'ttoma uccaya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tsa'ma ñanda gi que'ima su: Cca'i quema egae tsincon'ni'qque tsama se'pijama. Nane a'i quema faefa'su tsovejuma tssai'ninda ccafa'su tsovejuma canjaen'faja cuintsu tsama'qque tssaiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A'i que contoma itsaye in'jamba na'sunga quema angaji'ninda que ondiccu'jema'qque se'pimbe'yi afeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Andu'choma fae kilometrove angaye manda'ninda dos kilometrove angaja. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Quema iñajan'sunga afeja. Toya'caen a'i quema osha'choma re'riccone afeye iñajan'ninda se'pimbe'yi afeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Que'ija paña'fa tayoe qquen su'choma: “Tisupapora ñotsse injancco'faja. Que'ima chi'ga'choma chi'ga'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tsa'ma ñanda gi que'ima su: Que'ima chi'ga'fa'niqque ñotsse in'jan'faja. Que'ima afasesundeccuma ñotsse afa'faja. Que'ima chi'gasundeccuma ñotsse tson'faja. Que'ima afasepa noñangiansundeccuma in'jamba tise'pane Chigama iñajan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsa'caen tsomba qui ñoa'me Chigama na'sian'cho dushundeccuve da'faya. Nane Chigaja se'pimbe'yi tsu coejechigama manda cuintsu egandeqquianga ño'andeccunga'qque chanjuñe. Unjima'qque se'pimbe'yi tsu manda ño'a tsonsundeccumbe nasipanga tuiye. Egae tsinconsundeccumbe nasipanga'qque tuiye tsu manda. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tisuma in'jan'chondeccuve'yi ñotsse in'jan'da ¿jongoesu ñotssiave qui isuye in'jan'fa? Nane govierno impuestoma isusundeccu'qque egae tsincomba tsa'caen tisupapora ñotsse in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aqquia que antiandeccuve'yi chigambian'da ¿bove ñotsse ti qui tson'jen'fa? Nane israembindeqquia'qque tsa'caen chigambiañe atesu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chiga que'i sefacconi'su Quitsaja tsangae ño'a tsu. Que'i'qque Tisia'caen in'jamba tsangae ño'ame dapa canse'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Injama'tse, aqquia cca'i queja ño'a qquen in'jañe tsu ñotsse tson'choma tson'masia. Tsa'caen tso'ninda Chiga que'i Quitsa sefacconi canjen'su'qque que'inga ñotsse afeya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tsa'cansi va'chandeccunga afeye tson'jen'da poiyi'cco a'ima ttu'se'fajama tsendeccu caña'jeni afeye. Nane ñotsse attiañe in'jan'chondeccuja Chiga Aya'fama atesian'jen'ttinga, tsaiquinga'qque fendo'ccoma fendo'fa poiyi'cco a'ima canjaeñe cuintsu tise'paja ño'a'fa qquen in'jan'faye. Nane ñoa'me gi su, tsendeccuja tsa'caen a'i ñotsse afa'choma pañamba Chiga ñotsse afa'chomajan paña'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tsa'ma que'i va'chandeccunga afe'je'ta pavefa'su tive tansinfa'su tive tson'jen'chove atesumbiqquia'caen a'tutsse afeya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A'tutsse afe'ni'qque tsu que'i Yaya Chiga Quitsaja pa'cco a'tutsse tson'choma attepa que'ima ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Que'i Chigama iñajañe in'jan'da ñotsse attiañe qquen afopoensundeqquia'caen iñajan'fajama. Tsendeccuja Chiga Aya'fama atesian'jen'ttinga ccutsupa Chigama iñajan'fa cuintsu poiyi'cco tise'pama atte'faye. A'i ja'je'cho tsaiquinga'qque ccutsupa Chigama iñajan'fa cuintsu tsangaé jasundeccu tisema atte'faye. Nane ñoa'me gi su tsa'caen a'i ñotsse afa'choveyi pañamba tsu Chiga ñotsse afa'choma paña'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Chigama iñajañe'da que cuartonga ca'nimba sombo'ttima piccopa que Quitsanga a'tutsse iñajan'faja. Tiseja que'i'ccu can'jen. Tsa'caen can'jemba que a'tutsse tson'choma attepa quenga ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Chigama iñajan'jen'da panshaen toeveyi injanga afa'fajama. Chigave atesumbindeqquiaja tsa'caen afa'fa. Ti'tsse toeveyi afasi Chiga ti'tsse paña qquen in'jamba tsa'caen afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tsendeqquia'caen tsincon'fajama. Nane toya iñajambi'te Chiga que'i Quitsa que'ima in'jamba que'i jongoesuma shacapa in'jan'choma tsu atesu. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tsa'cansi tsu qquen Chigama iñajaña'cho: Sefacconi Canjen'su Na'su, ingi Quitsa, Que qui ñoa'me joccapitssia. Que inise tsu egave metssipa ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Queyi na'suve dapa poima mandaja. Que in'janqquia'caeñi pa'cco tsu jinchoja. Que sefacconi mandaqquia'caen va andeni'qque mandaja. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Poi a'ta coirapa ingima an'bianjan ingi cu'ipa amba canseye. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ingi quema egae tsincomba shacaen'choma aqquepoenjan, ingi ingima egae tsincomba shacaensundeccuma aqquepoenqquia'caeñi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ingi egae tsinconsa'ne ottuni ttupa coiraja. Tsomba osha'cho ega'ye ingima ccushaenjan. Queyi qui Na'supa tsa'caen tsoñe osha. Queyi qui osha'choma oshacho. Queyi qui tsangae ti'tsse joccapitssia Na'su. Tsangaeyi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nane cca'indeccu que'ima egae tsinconsi tsa'caen egama aqque'papa ñoquia'ninda Chiga que'i sefacconi'su Quitsa'qque que'i egae tsincon'choma joqquitssiaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tsa'ma que'ija que'ima egae tsincon'suma ñoquiambian'da Chiga que'i Quitsa'qque que'i egae tsincon'choma joqquitssiaña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Asettupa ambe ca'an'qque ñombi'ye'fajama qquipoe'su'choma canjaeñe. Ñotsse attiañe qquen afopoensundeccuja tsa'caen ñombi'yepa tise'pa ambe can'fa'choma poiyi'cconga canjaen'fa. Tsa'caen tsincon'da tsangae ti'tsse'tssia've Chigane ñotsse isu'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tsa'ma que'ija asettupa ambe ca'an'qque Chigama iñajañe, que cambajuma ovashipa tosema'qque fuchhaja ccaningae attiansa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsa'caen tson'ninda cca'indeccuja que'i asettupa ambe can'jen'fa'choma atesu'faya'bi. Tsa'ma Chiga que'i Quitsa tsu atesu. Tiseja que'i'ccu can'jemba que'i a'tutsse tson'choma ñotsse in'jamba que'ima ñotsse tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Va andeni osha'cho jinqque'suma patsupa panshaen an'bian'fajama. Va andeni jinqque'suja ccopapaje'e daye atesu. Shipicco'qque amba da'ñoñe atesu. Ccanambandeccu a'tutsse ca'nimba cca'na'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsa'ma Chiga sefacconi tsu an'bian'faya'cho. Tsenijan shipicco can'jembipa amba dañoñe oshambi. Tseni jincho'choja ccopapaje'e daya'bi. Ccanambandeccu'qque can'jembipa ca'nimba cca'nañe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mani que'i an'bian'cho ji'nijan tsenima qui ti'tsse in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tso'fe tsu ai'vo'su tuño'can ingi in'jan'choma canjaeñe. Que tso'fe ñotssija pa'cco que ai'vo'qque a'tatssia'caen ñotsse tsu tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tsa'ma que tso'fe ñotssimbipa ega've ttatta'ninda pa'cco que ai'vo'qque sinttiani can'jenqquia'caen egae tsu tsoña. Que tuño tsa'caen sinttie da'ninda ñoa'me qui egae tsincomba sinttiani can'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sema'suja dos na'suma shondoye oshambi. Nane fa'ema chi'gapa faesuma tsu in'jaña. Tsambi'ta fa'ema ñotsse in'jamba faesuma tsu chi'gaya. Chigama in'jamba que'i corifin'dima'qque fae'ngatsse in'jañe osha'fambi qui. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tsa'cansi gi que'ima su: Que'i vani canse'chone panshaen asi'ttaen'fajama. Nane que'i anqque'su, que'i cuiqque'sune panshaen asi'ttaen'fajama. Que'i ai'vonga ondiccuqque'su sarupave'qque panshaen asi'ttaen'fajama. Ingi canse'cho tsu ingi anqque'suma ti'tsse'tssia. Ingi ai'vo tsu ingi ondiccuqque'suma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chhiririama canjan. Tsendeccuja jon'fambi ni tai'fambi. Ni taipa boña'je'cho tsa'ove an'bian'fambi. Tsa'ma Chiga Quitsa tsu tise'pama ofian'jen. Que'ita qui ñoa'me chhiririama ti'tsse joccapitssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Toya'caen ¿majan qui que'i'yeja aqquia in'jamba fae a'ta ti'tsse canseye'ta oshaya? Ñoa'me qui osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Micomba qui ondiccuqque'suve panshaen asi'ttaen'fa? Ñotssia te'tama can'faja. Aqquia tsu sho'yopa te'ta. Semambipa tise'pa ondiccu'jema anchombi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsa'ma ¿majan tsu tisia'caen ondiccucho? Nane ti'tsse'tssia na'su Salomón'qque tisia'caen ñotsse ondiccu'chombi. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Shoshovija ja'ño injanga sho'yopa cansesi tu'i a'ija tsama taipa panma matssañe tsu oque'faya. Tsa'ma Chiga Quitsaja tsa'caen te'tai'ccu shoshovima ñotsse ondiqquian'da ti'tsse tsu que'ima ondiqquiamba coira'je. ¿Micomba qui Chigave in'jambe canse'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tsa'cansi panshaen asi'ttaen'fajama qquen supa: “Aña'cho me'i'anda ¿ma'caen gi amba canse'faya?” “Cui'ccu me'i'anda ¿ma'caen gi cu'ipa canse'faya?” Toya'caen “¿Jongoesuma gi ondiccu'faya?” ");
INSERT INTO conNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nane Chigave in'jambindeqquia'qque tsa'caen in'jamba canse'fa. Tsa'ma que'ija Chiga dutssiyendeccu qui. Que'i sefani'su Quitsaja atesu'cho tsu que'i tsa osha'chove in'jan'fa'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tsa'cansi que'ija o'tie Chiga Quitsama na'suve in'jan'faja. Tsa'caen in'jamba Tise in'janqquia'caen cansesi tsu Chiga Quitsaja que'inga osha'cho jongoesu shaca'ninda afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nane ñoa'me gi su: Tu'i tsoña'chone panshaen asi'ttaenjama. Tu'i a'tasi tsu tsane asi'ttaeña'cho. Nane poi a'ta a'tasi nanitssi tsu tsequi a'ta vanaña'choveyi asi'ttaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Cca'i egae tsincon'choma ttatta'fajama. Tsa'caen tta'ttambian'da Chiga'qque que'i egae tsincon'choma tta'ttaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nane que'i cca'i shacama tta'ttapa suqquia'caen tsu Chiga'qque que'i shacama attepa suya. Que'i cca'indeccu egae tsincon'choma agattoqquia'caen tsu Tiseja que'i egae tsincon'choma'qque agattopa shacama atteya. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Mingapa qui faenga'su tso'fe ccappi'choma atteqquia'caen tise egae tsincon'choma atte'fa? Tsa'ma tsama attepa tisu tso'feni quini'cco eje'choma qui atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tsa'cansi toya'caen qui que faenga'suma su: “Faenga'su, ñajan que tso'fe ccappi'choma somboeña.” Tsa'ma qquen supa tisu tso'feni quini'cco eje'choma atesumbiqquia'caen que'i egae tsincon'choma qui atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Queja ño'a qquen attiamba ñoa'me afopoen'su qui. O'tie que tso'feni quini'cco eje'choma somboemba ñotsse atteya'cho. Tisu ñotsse atte'ta qui faenga'suma fuitepa tso'fe ccappi'choma somboeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","¿Osha'cho Chiga etti'sumanda ti ainga afeqque'su? ¿Ñoa'me bare'cho moyo ti cochinga afeqque'su? Me'i. Tsa'caen afeqquia'caen a'i in'jambinga osha'cho Chiga Ayafa'su ñotssiama condase'masia. Ain piyipa sinttuqquia'caen tsu quema catsepa iyicca'yeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iñajan'da qui isu'faya. Ttatta'ta qui atte'faya. Sombo'ttima tssai jeña'ninda na'su tsu fettaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Poiyi'cco majan Chigama iñajan'da tsu isu'faya. Poiyi'cco majan Chiganima jongoesuve tta'tta'ta tsu atte'faya. Poiyi'cco majan tssai jeña'ninda Na'su Chiga tsu fettaya cuintsu ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Majan que'i'ye du'shuma an'bian'fa. ¿Que du'shu panme iñajan'ninda ti qui patuma tisenga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Avuve iñajan'ninda ti qui avuma se'pipa iyoma tisenga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Me'i. Que'ija tsa'caen ño'ambi. Tsa'ma tisu dushundeccunga ñotssiama afeye qui atesu'fa. Tsa'caen tson'fasi ñoa'me tsu que'i Sefacconi'su Na'su Chiga Quitsaja bove ñotssiama afeya. Nane majan Tisema iñajansi tsanga tsu ñotsse afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Que'i in'janqquia'caen cuintsu cca'indeccu que'ima tsoñe in'jan'da tise'panga'qque tsa'caen tson'faja. Qquen tsu Chiga manda'cho, Chiga Aya'fama afasundeccu su'cho'qque atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Aiye'pambi tsu tsangae catiyeya'chove jaye. Attajatssia sombo'tti'ye ca'niqquia'caen chonde'tssia tsaiquipa aiye'pambi tsu jacañe. Tsain'bio a'i tsangae ca'nimba jacan'fa. Tsa'ma aiye'pa tsu tsangae canseya'chove jaye. Ta'yoquiccoa sombo'tti'ye ca'niqquia'caen vanamba tsu tsa tsaiqui'ye jacaña'cho. Re'ricco a'i tsu tsangaé jaya'chove atte'fa. Tsa'ma que'ija tsa ta'yoquiccoa sombo'tti'ye ca'ni'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Injama'tse Chiga Aya'fama afa'su qquen supa afopoensundeccu que'ima qqueñasa'ne. Nane tsendeccuja oveja'caen opave attiamba injama'choni putsa'su ain'caen que'ima dañoñe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Quini'jin teta'choma attepa qui quini'jima atesu'fa. ¿Anccosi'jinga ja'ta ti a'ija tsajama pisho'fa? ¿Nojansifaccunga ja'ta ti a'ija higuera teta'choma pisho'fa? Me'i. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nane ñotssia teta'choja ñotssia quini'jinga tsu na. Tsa'ma ega teta'cho tsu ega quini'jinga na. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ñotssia quini'jinjan ega teta'chove nambi. Ni ega quini'jin'qque ñotssia teta'chove nambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Majan quini'jin ñotsse nambian'da a'ija tsama ttuttupa si'tsipa oque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tsa'caen gi ccase que'ima su: Chiga Aya'fama afa'su qquen supa afasi tise'pa tson'choma attepa qui tise'pama atesu'faya afopoen'jen'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Poiyi'cco majan ñama “Na'su, na'su” qquen afasundeccuta tsu Chigama na'sian'cho a'ive da'faya'bi. Tsa'ma majan ña Quitsa sefacconi canjen'suma pañamba Tise in'jan'chove tsonsundeccu tsu Tise a'ive da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nane tsequi osefaeña'cho a'ta napisi majan a'i tsu ñama su'faya: “Na'su, na'su, que iniseningae gi Chiga Aya'fama a'inga condase'fa. Que iniseningae gi cocoyama'qque a'i'ye joqquitssian'fa. Nane que inisema ttu'sepa gi agattoemba canjaen'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tsonsi gi tise'pama tansintsse suya: “Ña'ñe joqquitssi'faja, egae tsinconsundeccu. Ña a'i'fambi qui.” ");
INSERT INTO conNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Majan a'i ña aya'fama pañamba tson'da injama'pa tsao'ñasia'can tsu. Tso'sitsse dya'dyapa fattocconga ta'etsse tsa'oma dyaiña. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tsonsi unjin tuisi na'en tsu ji. Jisi quia'me tsa'onga zonzoensi fingian'qque tsa'oma oyaen. Tsa'ma fattocconga tsao'ñasi tsa tsa'oja osuimbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tsa'ma majan a'ija ña aya'fama paña'ma tsa'caen tsombi'ta faesu sumbi tsao'ñasia'can tsu. Tsaja sisipandunduni tsao'ñasi ");
INSERT INTO conNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","unjin tuisi na'en jipa tsa'onga zonzoen. Fingian'qque oyaensi tsa'oja osui. Nane osuipa “ppo” qquen aijapa metsse da. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús tsa'caen atesian nanisi poiyi'cco a'i tise atesian'choma pañamba can'boen ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chiga manda'choma atesiansundeqquia'cambipa Jesúsja na'sia'caen in'jamba atesian. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús atesian nanimba ccotta'cco'ye ande. Andesi tsain'bio a'i toya tisei'ccu jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na congomba paji'su tisenga catsepa ccaru dyai. Jesúsnga ccaru dyaipa iñajan: —Na'su, que in'jan'da qui ñama giya'tsse ccushaeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Qquen susi Jesús tise tivema yasapa paji'suma pporaemba su: —In'jan gi ñajan. Giya'tsse qui ccusha. Tse'faei'ccuyi giya'tsse ccushasi ");
INSERT INTO conNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús tisema manda: —Cca'indeccunga condajama. Tsa'ma japa Chigama afa'sunga tisuma canjaenjan. Moisés mandaqquia'caen ccusha'chone afe'choma afeja cuintsu tsa'caen tsonsi poiyi'cco a'i que ccusha'chone in'jan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaumni ca'nisi romano sundaro capitán tisenga jipa ");
INSERT INTO conNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","iñajan: —Na'su, ñambe sema'su tsu ishopa paqque'sunga setsayepa paji. Pajipa iña'me iñesi tsaoni ccui. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús tisema su: —Jipa gi tisema ccushaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Qquen susi capitán tsu su: —Na'su, ñotssimbi gi cuintsu queja ña tsaoni jiye. Tsa'ma queja toe'tti ccutsupa mandaja cuintsu ñambe sema'su ccushaye. Mandasi tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ñajan sundaro a'i. Ña nasundeccu ñama manda'fa. Ña'qque ñama bove'ccoa sundarondeccuma manda. Fae'ccoma “Jaja” qquen mandasi tiseja ja'je. Faesuma “Jija” qquen mandasi tiseja ji'je. Ña sema'suma “Qquen tsonjan” qquen mandasi tsa'caen tiseja tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús tsama pañamba sundaro capitáne asi'ttaén ccutsu. Tsomba piyicamba tisei'ccu jacansundeccuma su: —Ñoa'me gi su, va a'ija ñoa'me tsu ñame in'jan. Ni fae israe'su tsa'caen ñama in'jambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Toya'caen gi su: Tsain'bio a'i coejechiga sombo'jene, chiga amppi'jene'qque jipa Chigama na'sian'cho aindeccuve dapa Abraham, Isaac, Jacobi'ccu fae'ngae dyaipa an'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tsa'ma israendeccuja joqquitssiañe'faya. Nane Chigaja tise'pama aisheve in'jamba ñoña Tise aindeccuve da'faye. Tsa'ma israendeccuja tsama chi'gapa tsangae sinttianga biani catiyepa i'na'faya. Vana'jemba ttun'dundu'je'e iyicca'yepa i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsomba Jesús capitáma su: —Que tsaoni jaja. Que in'janqquia'caen tsu da. Tse'faei'ccuyi capitámbe sema'suja ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsomba Jesús Pedro tsaoni ja. Japa Pedro chanccashema atte ajepa ccui'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús catsepa tise tivema pporaen. Pporaensi aje chattian. Aje chattiansi ccushapa jangipa poiyi'ccoma cui'ñañe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tayo chiga amppisi tsain'bio cocoya ca'ni'chondeccuma tisenga i'fa. Jesús fae aya'fave afapa cocoyama joqquitssian. Poiyi'cco pajisundeccuma'qque ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Qquen tsu tson tayopi'su Chiga Aya'fama afa'su Isaías suqquia'caen tsoñe: “Tiseja ingi pajipa iña'su'choma joqquitssian. Ingi paqque'suma angapa cati.” ");
INSERT INTO conNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tsain'bio a'i Jesúsnga shonquendi'e bo'fa. Jesús tsama attepa tisema shondosundeccuma manda cuintsu shavonga otsepa mar jonifani tisei'ccu ise'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Toya ja'fambi'te Chiga manda'choma atesian'su Jesúsnga catsepa su: —Atesian'su, mani que jaca'ni'qque ña'qque fae'ngae jacaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús tisema su: —Quiya tsu tise'pa ana'jen'cho changove an'bian'fa. Chhiriria'qque tise'pa tsao'pave an'bian'fa. Tsa'ma Sefaccone Ji'cho A'i gi mani japa anaña'chove mecho. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Faesu Jesúsma shondo'suja su: —Na'su, ña yaya pasi a'tupa gi quei'ccu fae'ngae jacaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsa'ma Jesús tisema su: —Antteja cuintsu ñame in'jambindeqquia tsa'caen pa'chondeccuma a'tuye. Tsa'ma queja ñai'ccu jacanjan. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsomba shavonga otsesi tisema shondosundeccu'qque otse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ñoa'nga a'tasi opatsse jayi'fa. Opatsse jayi'fasi tse'faei'ccuyi fingian quia'me fingiansi tsa'ccu shave'pa shavonga zonzoemba ca'ni. Tsa'ma Jesús pa'ccoma atesumbe'yi ana'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tisema shondosundeccu dyopa Jesúsnga catsepa qquendyaemba su'fa: —Na'su ingima ccushaenjan. Cu'nomba gi paye tson'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsonsi Jesús su: —¿Jongoesie qui ñame in'jambipa dyo'fa? Qquen supa jangi ccutsupa fingiama iyu'usi vuiqui. Shave'pama'qque iyu'usi ñoa'me ppimppianccuve da. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tisema shondosundeccu attepa can'boemba iñajampañacco'fa: —¿Ma'ca tsu va a'ija? Mandasi fingian, mar'qque tisema paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tsomba mar jonifani isepa Gadara andeni ccattufa'fa. Ccattufasi dos cocoya ca'ni'chondeccu ayama atu'ttini can'jemba Jesúsma cachuiye ji'fa. Ñoa'me putsa'su'fasi cca'indeccu dyojopa tsangae jacan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesúsma attepa fundondo'e afa'fa: —Queja Chiga Dutssi'yeta ¿jongoesie qui ingini ji? ¿Toya osefaeña'cho a'ta napimbi'te ingima vanaeñe ti qui ji? ");
INSERT INTO conNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tse'tti biaccaccatsseyi tsain'bitssia cochi an sheque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsa'cansi cocoyandeccu Jesúsma iñajan'fa qquen supa: —Ingima somboen'da antteja cuintsu ingija cochi sheque'fa'chonga ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús tise'pama su: —Jujú, japa ca'ni'faja. Qquen susi cocoyandeccu aindeccu'ye sombopa cochinga ca'ni'fa. Ca'ni'fasi pa'cco cochi sheque'fa'cho sumbie dapa ccotta'cco piyiccu'fanga buttopa marnga amppippi ja'fa. Tsa'caen amppippi japa tsu andeccopa pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cochima coirasundeccu cochi sumbie dasi attepa buttopa ja'fa canqqueni. Japa canqqueni can'jensundeccunga pa'cco ma'caen da'choma conda'fa. Cocoya ca'ni'chondeccu ccusha'chone'qque conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsa'caen condasi poiyi'cco tsa canqque'su aindeccu sombopa Jesúsma cachuiye ji'fa. Jipa tisema attepa dyopa iñajan'fa cuintsu Jesús tise'pa'ye joqquitssiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsonsi Jesús ccase shavonga otsepa marma isepa tisu canqqueni ji. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jisi ishopa paji'suma tisupa ana'jen'chonga opi i'fa Jesúsnga. Jesúsja tise'pa Chigave in'jan'choma in'jamba ishopa paji'suma su: —Jaricho dyojama. Tayo tsu que egae tsincon'choma joqquitssian. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsa'caen susi majan Chiga manda'choma atesiansundeccu tisu injama'choni asi'ttaen'fa: —Va a'ita tiseja Chiga qquen in'jamba tsu egae afa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesúsja tise'pa in'jan'choma in'jamba su: —¿Jongoesie qui injama'choni qquen egae asi'ttaemba in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tayo gi su: “Que egae tsincon'choma tayo joqquitssian.” ¿Bove aiye'pambi ti qquen suye: “Jangipa tsui jaja.”? ");
INSERT INTO conNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tsa'ma Na'su Chigaja antte Sefaccone Ji'cho A'i va ande'su a'i egae tsincon'choma joqquitssiañe. Ñajan Sefaccone jipa tsa'caen oshapa que'inga canjaeñe tson'jen. Qquen supa Jesús ishopa paji'suma su: —Ña quema manda: Jangipa que ana'jen'choma isupa tisu tsaoni tsui jaja. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tse'faei'ccuyi tiseja ana'jen'cho'ye jangipa sombopa tisu tsaoni ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jasi poiyi'cco a'i tsa'caen ccushaen'choma attepa dyo'fa. Chiga tsa'caen a'ima anttesi osha qquen in'jamba Chigama ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsomba Jesús tse'ttie sombopa govierno impuestoma isu'je'ttima panshamba a'ima atte. Tsa a'ija, Mateo, impuestoma isuye dyaisi Jesús tisema avuse: —Ñai'ccu jipa jacanjan. Qquen susi Mateo jangipa Jesúsi'ccu jacan. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsonsi Jesús tsaoni japa an'jen'cho mesa jin'tti piyive ccuipa an'jen. An'jen'ni tsain'bio impuestoma isusundeccu, egae tsinconsundeccu'qque fae'ngae Jesús, tisema shondosundeccui'ccu an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseondeccu tsama attepa Jesúsma shondosundeccuma iñajampaña'fa: —¿Micomba tsu que'ima atesian'suja va impuestoma isusundeccui'ccu an'jen? Egae tsinconsundeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Tsa'ma Jesús tise'pa iñajampaña'choma pañamba su: —Pajimbi'choa ccushaen'suma in'jambiqquia'caen ñajan jimbi gi “Ña gi ño'a” qquen in'jan'chondeccuma ccushaeñe. Japa atesu'faja Chiga qquen supa in'jan'choma: “Osha'cho fi'ttipa oque oraemba afe'choma in'jambipa gi que'i tisupapora injancco'fa'choma in'jan.” Tsa'cansi ccushaen'su paji'suma ccushaeñe jiqquia'caen ñajan egae tsinconsundeccuma ccushaeñe ji. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tsonsi feti'su Juanma shondosundeccuja Jesúsnga jipa iñajampaña'fa: —Ingija, fariseondeccu'qque asettupa zutsse ambe'yi Chigama iñajan'fa. ¿Micomba tsu quema shondosundeccuja tsa'caen ambe'yi asettu'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús tise'pama su: —Tsandie pusheye tson'jemba a'ima ttu'sesi bojin shequepa fae'ngae tsandiei'ccu amba cui'je'ta ¿ma'caen tsu ñombi'ye'faya? Ña gi tsa tsandieca'on ja'ño can'jen. Tsa'ma maqui a'ta cca'indeccu tsandiema tise'pa'ye joqquitssiansi tsequi tsu ambe'yi asettu'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","A'ija cuna sarupai'ccu tssoru ondiccu'jema pi'pimbi. Nane qquen tson'da ondiccu'jema ñoñañe in'jamba ti'tsse tsu dañoña. Ma'ppa'ninda, cuna sarupa zupa ti'tsse tsu tssoruma chittaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Toya'caen tsu a'ija vinoma cupoemba tssoru ttono botiyanga fiñaña'mbi. Vinojan omppantssimba ttonoma chittaemba tsu catiyeya. Toya'caen ttono'qque tsangae dañongeya. Tsa'ma cuna vinomanda tsu cuna ttono botiyanga fiñaña'cho. Tsa'caen fiñasi vino ttono'qque dañongembe'yi ccutsuya. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús tsa'caen atesian'jen'ni fa'e israe'su na'su tisenga jipa andenga ccarupa iñajan: —Tayo tsu ña onque'nge pa. Tsa'ma que jipa que tivei'ccu tisema pporaenjan. Pporaensi tsu ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Qquen susi Jesús jangipa tisei'ccu ja. Jesúsma shondosundeccu'qque fae'ngae ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jayi'fasi pushesu a'i bo'fa'choi'ccu japa sepaccofae Jesúsnga catse. Tsa pushesuja tise egapai'ccu dañongepa doce canqque'fa me'detsse canse. Jesúsnga catsepa tise ondiccu'je utufama pporaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Tise ondiccu'jeve'yi pporaen'da gi ccushaya” qquen asi'ttaemba pporaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tsa'ma Jesús in'jamba piyicamba pushesuma attepa su: —Shim'ppi, dyojama. Ñame in'jamba qui ccusha. Tse'faei'ccuyi pushesuja quinsetsse ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsonsi Jesús na'su tsaoni napipa ca'ni. Ca'nimba a'i bo'fa'choma atte. Du'shu pasi ñombi'yepa qquejian'fa. A'tuye tson'jemba fendo'ccoma ñoquimbi'e fendo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús attepa su: —Va'ttie joqquitssi'faja. Du'shuja pambi'tsse'yi tsu ana'jen. Qquen susi tayo pa'chosi atesupa tisema feña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tsa'ma aindeccu joqquitssi'fasi Jesúsja cuartonga ca'nimba catsepa du'shu tive'ye indi. Indisi du'shuja jangi ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jesús tsa'caen ccushaensi pa'cco tsa ande'ye tsu tsane condasecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús tsene sombosi dos bini tisema omboemba japa fundondo'e su'fa: —Na'su David Dutssi'ye, ingima mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tsonsi Jesús tsa'onga ca'nisi tise'pa'qque ca'nimba Jesúsnga catse'fa. Catsesi Jesús tise'pama iñajampaña: —¿In'jan'fa ti qui ña que'ima ccushaeñe osha? Tise'paja su'fa: —Ju, na'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsonsi Jesús tise'pa tso'fema pporaemba su: —Que'i in'janqquia'caen tsu que'inga tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Qquen pporaemba susi binindeccu ccase atteye osha'fa. Tsonsi Jesús tise'pama quia'me manda: —Que can'faja. Cca'indeccunga que'i ccusha'choma conda'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tsa'ma tsendeccuja tsaone sombopa pa'cco tsa ande'ye japa tise'pa ccusha'chone conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesús tsao'ye sombo jisi cca'indeccu cocoya ca'ni'choma tisenga i'fa. Cocoya ca'nisi tsa a'i ayafambie da. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús cocoyama joqquitssiansi ayafambija afa. Bo'fa'cho aindeccuja can'boen ccutsupa su'fa: —Nane mingui'te'qque va'ca'ma israe andenima atte'fambi gi. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tsa'ma fariseondeccuja su'fa: Cocoya na'su tisema fuitesi tsu cocoyama joqquitssian. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesúsja poi canqque'ye, poi a'i can'jen'tti'ye japa Chiga manda'choma atesian'jen'ttinga ca'nimba atesian'jen. Chigama na'sian'cho aindeccuve daya'chone ñotsse jinchoya'choma atesian. A'i osha'choi'ccu paji'choma, toya'caen osha'cho paqque'sui'ccu vana'suma'qque ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aindeccuja bo'fasi Jesús attepa tise'pama mende'ye. Nane oveja coira'suve mechoqquia'caen injanga ñoquimbicco jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tise'pama mende'yepa tisema shondosundeccuma su: —Vandeccuja Chigama na'sian'cho aindeccuve daye ronda'je'fa. Tsa'ma taiya'cho injantssisi semasundeccu shacasi majan tise'panga atesiaña'chove tsu me'i'on. ");
INSERT INTO conNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsa'cansi Taiñaña'cho Na'su Chiganga iñajan'faja cuintsu faesu semasundeccuma manda moensi tsendeccu taiqquia'caen tise'panga atesiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Qquen supa Jesús tisema doce shondosundeccuma ttu'sepa antte cuintsu cocoyama joqquitssian'faye. Toya'caen antte cuintsu a'i osha'choi'ccu paji'choma osha'cho paqque'sui'ccu vana'suma'qque ccushaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesúsma doce shondosundeccumbe inise tsu qquen: Simón (tise faesu inise Pedro), tsambe quinshin Andrés, Santiago, tsambe quinshin Juan (tsa dosja Zebedeo dutssiyendeccu tsu). ");
INSERT INTO conNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (tsaja govierno impuestoma isu'su tsu), Santiago (tsa Alfeo dutssi'ye tsu), Tadeo, ");
INSERT INTO conNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (tsaja cananeo gi qquen in'jan'cho a'i tsu), Judas Iscariote (tsaja Jesúsma jai'ngae chi'gapa afe'su tsu). ");
INSERT INTO conNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Qquen tsu Jesús va docema mandapa maña: —Israembindeqquiambe ande ni samaritano canqqueni ja'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tsa'ma israendeccungayi japa candusian'faja. Tsendeccu Chigambe qque'cho ovejandeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Japa candusian'faja qquen: “Ja'ño tsu Chiga que'ima ttu'se Tisema na'sian'cho aindeccuve da'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Toya'caen pajisundeccuma ccushaen'faja. Pa'chondeccuma ccase qquendyaen'faja. Na congomba pajisundeccuma giya'tsse ccushaen'faja. Cocoyama'qque joqquitssian'faja. Chiga aqquia afeqquiacaen que'ima tsa'caen oshaensi jongoesuma iñajambe'yi tsu aqquia afeqquia'caen tsoña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ni cori, ni corifin'di, ni reama'qque que'i utuqui'fa'su bosanga anga'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","O'vama'qque andu'fajama. Ni faesu ondiccu'je, ni faesu sapato, ni faesu jacan'cho accuicco'choma anga'fajama. Nane sema'su sema'ninda tsu tsa fuiteye'su ccane'qque tisema fuitepa o'fiaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Majan canqque, majan a'i can'jen'ttinga napi'ta ñotssia a'ive ttatta'faja. Tsambe tsa'onga ca'nimba tisei'ccu can'jeña'cho tisu jaya'cho napiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsa tsa'osundeccuma in'jamba chigambian'faja cuintsu opatsse canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsa'caen chigambiansi tsa tsa'osundeccu ñoa'me ñotssi'ta que'i suqquia'caen tsu opatsse canse'faya. Ñotssimbi'ta que'i su'cho toequi shandaqquia'caen Chiga tsu antte que'iyi opatsse canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Majandeccu que'ima chi'gapa que aya'fama paña'fambi'nijan tsambe tsa'o'ye sombopa, tsa canqque'ye sombopa, ja'faja. Jayipa que tsu'ttenga ancamba totopa'ma fanttundu cati'faja tise'pa egae tson'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ñoa'me gi que'ima su: Osefaeña'cho a'ta napijisi tsa canqquesundeccu tsu bove dyo'tsse da'faya. Nane tayopi'su Sodoma canqquesundeccu, Gomorra canqquesundeccu'qque ñoa'me egae tsincomba tsequi a'ta ñoa'me vana'faya. Tsa'ma que'ima chi'gasundeccuja tise'pama ti'tsse tsu vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Que canjan, opa ovejama mandamoenqquia'caen gi que'ima ega aindeccunga moeñe tson'jen. Tsendeccuja putsa'su ain'caen que'ima noñangian'faya. Noñangia'nijan iyo injama'pa'caen ñotsse in'jan'faja. Ppuppuju'cho egave atesumbiqquia'caen can'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tsa'ma injama'tse tsendeccu que'ima indipa nasundeccu bo'fa'chonga anga'fasa'ne. Nane Chiga manda'choma atesian'jen'ttinga que'ima angapa ma'ppi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ju, que'i ñame in'jansi tsu governarorondeccunga, ande nasundeccunga'qque que'ima indipa anga'faya. Angasi qui tsendeccunga'qque ñane conda'faya. Israembindeqquianga qui ñane conda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tsa'ma que'ima indipa nasundeccunga anga'ninda asi'ttaen'fajama jongoe qquen suya'chove. Nane tsequi tsu Chiga que'ima in'jaemba afaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nane que'ija afa'faya'bi. Tsa'ma Chiga que'i Quitsambe Qquendya'pa tsu que'inga ca'nimba afaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nane quindya tsu tise quinshima chi'gapa afeya cuintsu fi'ttiye. Quitsa tise du'shuma chi'gapa afeya. Dushundeccu tise'pa quitsandeccuma chi'gapa fi'ttiye afe'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Que'i ñame in'jamba ña a'i'fasi poiyi'cco a'i tsu que'ima chi'ga'faya. Tsa'ma majan osefaeña'gae ñoa'me ta'etsse ñame in'jan'da ñoa'me tsu ccushaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Fae canqqueni que'ima noñangiansi faesu canqquenga tsu ccuyapa ja'faya'cho. Ñoa'me gi que'ima su: Tsa'caen cca'tti cca'ttinga japa poiyi'cco israe'su canqquenga toya ja'fambi'te Sefaccone Ji'cho A'i gi ccase jiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Shondo'suja tisema atesian'suma ti'tsse'tssimbi tsu. Ni sema'su tise na'suma ti'tsse'tssimbi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tsa'ma atesian'su vanaqquia'caen tsu shondo'su'qque vanaña'cho. Na'su vanaqquia'caen tsu sema'su'qque vanaña'cho. Nane ña gi tsa'o na'su. Ñama “Cocoya na'su Beelzebú tsu” qquen afasepa ña aindeccuma'qque ti'tsse tsu tsa'caen afase'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tsa'cansi aindeccuma dyo'fajama. Nane osha'cho ja'ño a'tu'chota jai'ngae canjaeña'cho. Ja'ño atesumbi'choja jai'ngae atesuya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ñajan que'inga a'tutsse cose condasi a'ta'nijan conda'faja. Opitsse afasi pañamba que paña'choma tsa'o sefani'su ppappacconga ccutsupa fundo'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dyo'fajama majan que'i ai'voma fi'ttiye osha'fa. Nane tsendeccuja que'i qquendya'pama fi'ttiye osha'fambi. Tsa'ma Chiga tsu a'i qquendya'pama, a'i ai'voma'qque si'nge anchanda'je'chonga catipa fi'ttiye osha. Tisema qui dyo'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A'ija chhiririama baratove chavaen'fa. Nane dos chhiririama tsu fae chipiri corifi'dive chavaen'fa. Tsa'ma tsa'caen baratosi toya tsu Chigaja tsesu chhiririama injan'jen. Nane tsesu chhiriria andenga amppi'ninda Chigaja in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Toya'caen Chigaja que'i tsove'su tosema agattopa injan'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tsa'cansi dyombe can'faja. Que'ija Chiganga tsain'bio chhiririama ti'tsse qui bare'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Majan ñame in'jamba dyombi'tsse cca'indeccunga condase'ninda ccane'qque ñajan Chiga ña Quitsa, sefacconi canjen'sunga tsa a'ine ñotsse condaseya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tsa'ma majan ñama chi'gapa tsa'caen cca'indeccunga ñama a'tie'ninda ccane'qque ñajan tsa a'ima chi'gapa Chiga ña Quitsa, Sefacconi canjen'sunga tisema a'tieña. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","¿Ña jisi ti poiyi'cco a'i opatsse canse'fa? Me'i. Tsa'caen asi'ttaen'fajama. Nane ña ji'ni'qque ñoquimbe'yi tsu iyicco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ña jisi dutssi'ye tsu tise yayai'ccu iyicco'fa; onque'nge tsu tise mamai'cu iyicco'fa; china tsu tise chanccashei'ccu iyicco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nane a'i ñame in'jansi tisema ti'tsse iyiccaye'suja tisu tsaoni tsu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Majan a'ija tise yayama, tise mamama ñama ti'tsse in'jan'da ñotssimbi tsu ña a'ive daye. Majan tise dutssi'yema, tise onque'ngema ñama ti'tsse in'jan'da ñotssimbi tsu ña a'ive daya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Majan a'i tisu avuja'ccoma opiqquia'caen poi a'ta ña'caen paya'ngae vanañe chi'gapa ñai'ccu fae'ngae jacañe in'jambi'ta ñoa'me ñotssimbi tsu ña a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Majan a'i tisuma ccushaeñe in'jan'da papa catiyeya. Tsa'ma majan ñame in'jamba pa'ta ñoa'me tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Majan a'i que'ima in'jamba paña'da tsu ñama'qque in'jamba paña'fa. Ñama in'jamba paña'da tsu Chiga ñama moen'suma'qque in'jamba paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Majan a'i Chiga Aya'fama afa'suma pañamba “Chiga Aya'fama tsu afa” qquen in'jan'da tise'qque Chiga Aya'fama afasia'caen Chigane ñotsse isu'faya. Majan a'i ño'a a'ima in'jamba “Tiseja Chigave in'jamba ño'a tsu” qquen in'jan'da tise'qque fae'ngae tsa a'i'ccu Chigane ñotsse isu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Majan ñama shondosundeccu du'shuaca'on joccapitssiambi tsu. Tsa'ma majan a'i “Tsendeccu Jesúsve in'jan'fa” qquen in'jamba cha'ndia tsa'ccuma cui'ña'da tise'qque Chigane ñotsse tsu isu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús tsa'caen tisene doce afasundeccuma candusian nanimba tsa canqque'ye sombo. Sombopa faesu Galilea'su canqqueni jacan tseni'qque atesiamba candusiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Feti'su Juan indiyepa picco'je'ttini piccoyepa can'jemba Cristo tson'jen'choma paña. Pañamba tisema shondosundeccuma ttu'sepa Jesúsnga moen ");
INSERT INTO conNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","cuintsu tisema qquen iñajampaña'faye: —¿Que ti qui Cristo, jiya'cho qquen su'choja? Tsambi'ta ¿faesuve ti gi ronda'je'faya? ");
INSERT INTO conNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús pañamba tise'pama su: —Japa que'i attepa paña'choma Juanga conda'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Binindeccu tsu atte'fa. Ccutsumbindeccu tsu tsui jacan'fa. Na congomba pajisundeccu tsu giya'tsse ccushapa ja'fa. Tsonsinambindeccu tsu paña'fa. Nane pajin ccui'chondeccu ccase tsu qquendya'fa. Va'chandeccu'qque ñotsse condase'choma tsu paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Majan ñame in'jamba ansangembi'ta ñoa'me tsu avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tsendeccu pañamba toequi ja'fasi Jesús aindeccu bo'fa'chonga Juane qquen condase: —Que'ija ¿jongoesuma atteye qui a'i menia ja'fa? ¿A'i quin'su mechoama atteye ti qui ja'fa fingian canttini'ccoma oyaen'jenqquia'ca'ma? ");
INSERT INTO conNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsambi'ta ¿jongoesuve qui atteye'ta ja'fa? ¿A'i ñotssia sarupama ondiccu'choma cañe ti qui ja'fa? Me'i, ñotssiama ondiccucho'chondeccuja na'su tsaoni can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsa'ma ¿jongoesuve qui atteye'ta ja'fa? ¿Chiga Aya'fama afa'suma atteye ti qui ja'fa? Ju, tsa'caen qui japa atte'fa. Tsa'ma Juanjan Chiga Aya'fama afa'suma ti'tsse'tssia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tisene tsu Chiga Aya'fa su: Que canjan. Quema o'tie gi ñama afa'suma manda moeña. Tiseja o'tie tsu jaya que ji'je'choma ñoñañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñoa'me gi que'ima su: Va andeni faesu a'i Feti'su Juanma ti'tsse'tssiaja me'i'on tsu. Tsa'ma Chigama na'sian'cho a'i, tsa ñoa'me utu'ccoa tsu Juanma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nane Feti'su Juan candusiañe ashaensi ja'ñongae aindeccuja qquejian'fa Chigama na'sian'cho aindeccuve daye. Injanga patsupa ca'niñe tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nane Juan jiya'ngae poi Chiga Aya'fama afa'su afa'choja Chiga manda'cho'qque Chigama na'sian'cho aindeccuve daya'chone conda. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Que'i ñoa'me pañañe in'jan'ninda Juanjan Elías tsu, tsa tayopi jiya'cho qquen su'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Majan tsosinapa'ta ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jongoesiacan'fa tsu ja'ño'su aindeccuja? ¿Ma'caen gi canjaeña cuintsu que'i ñotsse in'jan'faye? Ñoa'me dushundeccu chavaen'jen'tti'su atandunduni dyaipa fae'ngae co'fembiqquia'caen tsu ja'ño'su aindeccuja fae'ngae in'jan'fambi. Dushundeccu tisupaporai'ccu ");
INSERT INTO conNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","fundocco'fa: “Casara qquen co'feye fendo'jesi qui boira'fambi. Pa'choma a'tu qquen ñombi'ye co'fesi qui i'na'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Feti'su Juan jipa aña'choma ambipa asettu. Tse'tse'pama'qque cu'imbi. Tsa'ma que'ija su'fa: “Tsaja cocoya ca'ni'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja'ño ñajan Sefaccone Ji'cho A'i jipa gi osha'choma amba cu'i. Tsa'ma que'ija su'fa: “Va a'i ñoa'me panshaen an'jemba tse'tse'pa singo tsu. Egae tsinconsundeccu, govierno impuestoma isusundeccu'qque tisei'ccu fae'ngae jacan'fa.” Qquen qui su'fa. Tsa'ma Chigaja ñotsse in'jamba tsomba tsu Tise tansintsse in'jan'choma canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús majan canqquenga zutsse jacamba osha'cho canjaen'choma canjan'jen. Tsa'ma tsesu canqquesundeccu paña'ma tise'pa egae tsincon'choma cati'fambi. Tsa'cansi Jesús tise'pama iyu'uye ashaemba qquen su: ");
INSERT INTO conNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Vana'faya qui Corazín canqquesundeccu! ¡Vana'faya qui Betsaida canqquesundeccu! Que'ija ñotsse Chiga tson'choma atte'fa. Chiga tsa'caen Tiro, Sidón canqquenga tsoña'choecan'da ñoa'me tsu junde tseni'su aindeccu tise'pa egae tsincon'choma chi'gapa Chigama iñajan'faye'can. Ñombi'yepa canjaen'cho sarupai'ccu ondiccupa cusepai'ccu tsu onjon'faye'can tisu egae tsincon'choma catiye in'jan'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nane ñoa'me gi su: Injama'choma somboeña'cho a'ta napisi Tiro, Sidón canqquesundeccu tsu que'i aindeccuma bove aiye'pambi'ccoe vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Toya'caen que'i Capernaum canqquesundeccu: ¿Asi'ttaen'fa ti qui Chiga que'ima in'jamba sefacconi angaye'ja? Me'i, tsa'ma si'nge anchanda'je'chonga tsu que'ima catiya. Que'ija ñotsse Chiga tson'choma atte'fa. Nane Chiga tsa'caen Sodoma canqquenga tsoña'choecan'da ñoa'me tsu tsa canqque toya ja'ño'qque jiñe'can. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tsa'ma ñoa'me gi que'ima su: Injama'choma somboeña'cho a'ta napisi Sodoma canqquesundeccu tsu que'i aindeccuma bove aiye'pambi'ccoe vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tse'i Jesús Chiga Quitsama qquen iñajan: —Yaya Chiga Quitsa, Que qui Sefacconi'su Na'su. Pa'cco ande'su Na'su qui. Va ande'su injama'pandeqquianga qui Tisuma canjaembi. Tsa'ma injama'pandeqquianga Tisuma canjaembipa qui va du'shiacandeqquianga Tisuma canjaen. Nane ñotssia du'shu pañaqquia'caen tise'paja ñotsse pañamba in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ju, Yaya, tsa'caen in'jamba ñotsse qui tson. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús Chigama iñajan nanimba aindeccunga su: —Tayo tsu ña Yaya osha'choma ñanga afe. Ni fae a'iyi'qque ñama atesu'fambisi Chiga Quitsayi tsu ñama atesu. Ñajan Tise Dutssi'ye. Toya'caen ni fae a'iyi'qque Chiga Quitsama atesu'fambisi ñañi gi Tisema atesu. Tiseja ña yaya tsu. Toya'caen ñajan Chiga Dutssi'yepa gi majama in'jamba ña condase'nijan tsendeccu'qque Chiga Quitsama atesu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñani ji'faja poiyi'cco que'i majan semamba vanasundeccu. Ñani jisi gi que'ima ño'faeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñai'ccu fae'ngae semamba ñama atesupa ti'tsse in'jan'faja. Nane ña injama'choni gi iyu'upa patsumbe'yi que'ima ñotsse atesiaña. Ñai'ccu semamba qui que'i injama'choma'qque ño'faen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ñai'ccu fae'ngae sema'da panshaen vana'faya'bi qui. Andu'cho fava'ccoa'ma andianqquia'caen gi ñajan que'ima panshaen mandaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tse'i Jesús sema'ma'qquia a'ta nasipa'ye panshan jayi. Panshan jayipa tisema shondosundeccu qquipoe'supa trigoma sintti isupa shuju qque'shopa añe ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tsa'ma fariseondeccu attepa Jesúsnga su'fa: —¿Micomba tsu quema shondosundeccuja qquen sema'jen'fa? Chiga manda'cho tsu se'pi sema'ma'qquia a'ta tsa'caen semañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsa'ma Jesús tise'pama su: —¿Can'fambi ti qui Chiga Aya'fani ma'caen tayopi'su David tson'choma? Tiseja, tisei'ccu jacansundeccu'qque qquipoe'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Qquipoe'supa tise'paja Chiga ettinga ca'nimba Chiganga afe'cho panma isupa an'fa. Tsa panmajan Chigama afasundeccuyi an'faya'cho. Chiga manda'choja se'pi faesu añe. Anttembi cuintsu David, tisei'ccu jacansundeccu'qque tsa'caen an'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Toya'caen ¿can'fambi ti qui Chiga manda'choni ma'caen Chigama afasundeccu sema'ma'qquia a'ta'qque Chiga ettinga sema'fa afe'choma oque oraeñe? Tsa'ma shacapa mechoyi tsu sema'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsa'cansi que'inga gi su: Chiga ettima ti'tsse'tssia tsu ja'ño can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tayopi Chigaja a'inga su: “Osha'cho fi'ttipa oque oraemba afe'choma in'jambipa gi que'i tisupapora injancco'fa'choma in'jan.” Tsa'ma que'ija tsa su'choma paña'ma in'jan'fambi. In'jan'choecan'da qui ñotssia a'imbe injama'choma somboen'fambiye'can. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sefaccone Ji'cho A'i gi sema'ma'qquia a'ta se'pi'cho manda'choma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús tse'ttie sombopa Chigane atesian'jen'ttinga ca'ni. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ca'nisi fae tsandie tive dañonge'cho'qque tseni can'jen. Cca'indeccu Jesúsma iñajampaña'fa qqueñamba iyu'uye: —¿Chiga manda'chota ti sema'ma'qquia a'ta paji'suma ccushaeñe'da antte? ");
INSERT INTO conNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús qquen su: —Majan que'i'su fae ovejama an'biansi tsaja sema'ma'qquia a'ta ande changonga amppi'ninda ¿somboeña'bi ti qui? Nane sema'ma'qquia a'ta'qque japa indipa somboeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A'i tsu ovejama ñoa'me ti'tsse bare. Tsa'cansi Chigaja se'pimbi a'i sema'ma'qquia a'ta ñotsse tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Qquen supa tsandienga Jesús su: —Que tivema yasaja. Qquen susi tsandie tise tivema yasa. Yasasi ñoa'me tayo ccusha tise ccafa'su tivei'ccu fae'ngatsse. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesús tsa'caen ñotsse ccushaensi fariseondeccuja sombopa iyicca'yepa condasecco'fa ma'caen Jesúsma fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Fariseondeccu tsa'caen fi'ttiye condasecco'fasi Jesús in'jamba tse'ttie sombo. Tsain'bio tisema shondosundeccu'qque fae'ngae ja'fa. Tsendeccu'ye majan paji'susi tiseja ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ccushaemba tsu aindeccuma manda cuintsu tisene condambe can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Qquen tsu Jesús manda, tayopi'su Isaías, Chiga Aya'fama afapa qquen su'choma canjaeñe: ");
INSERT INTO conNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Vaja ñambe sema'su. Tisema gi ttu'se. Tisema in'jamba tsa'caen ttu'sepa gi avujatssi. Ña Qquendya'pai'ccu gi tisema in'jaeña cuintsu tiseja poi ande'su aindeccunga ña ccushaen'choma condaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tiseja afaccoya'bi ni fundoya'bi. Nane canqque'su tsaiqui'ye fundoya'bi cuintsu aindeccu tisema pañangiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Canttini'cco fentendecco'ccoama uccambiqquia'caen barembi'choama tsu fuiteya. Tuño paye tson'jen'choma ccase setsaenqquia'caen tsu quin'su mechoama quiñeña. Nane anttembe'yi tsu sema'jen osha'cho ñotssiayi patsuya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tsa'caen patsuya'si poi ande'su aindeccu tisema in'jamba ronda'je'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsonsi Jesúsnga cocoya ca'ni'choma i'fa. Cocoya tisenga ca'nisi binimba afaye oshambi. Jesús tisema ccushaensi ayafambija afa. Afapa atteye'qque osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Poiyi'cco a'i can'boemba su'fa: —¿Vambi ti David Dutssi'ye jiya'cho qquen su'cho? ");
INSERT INTO conNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsa'ma fariseondeccu Jesús ccushaen'choma pañamba su'fa: —Cocoya na'su Beelzebú va Jesúsma in'jaensi tsu tsa'caen cocoyama joqquitssiañe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tise'pa asi'ttaen'choma atesupa Jesús tise'pama su: —Majan ande'su nasundeccu tisupanaccui'ccu iyicco'ta tsangae tsu pasa'faya. Fae canqque'su a'i faenga'sui'ccu iyicco'ta fae'ttini can'jeñe osha'fambi. Toya'caen fae ettisundeccu faenga'sui'ccu iyicco'ta fae'ngae can'jeñe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsa'cansi Satanajan Satanama joqquitssian'choecan'da ñoa'me tsu tisuma chi'gaye'can. Tisuma chi'ga'ta ¿ma'caen tsu tiseja na'sia'caen mandaya? ");
INSERT INTO conNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Cocoya na'su Beelzebú Jesúsma in'jaensi cocoyama joqquitssian'jen” qquen qui su'fa. Ñoa'me ña tsa'caen tso'ninda ¿majan tsu que'ima shondosundeccuma in'jaen tise'pa'qque cocoyama joqquitssian'faye? ");
INSERT INTO conNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tsa'ma Chiga Qquendya'pa ñama in'jaensi gi cocoyama joqquitssian'jen. Tsa'caen ñama in'jaemba Chigaja que'ima tayo canjaen ma'caen Tise aindeccuve da'faya'chone. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Quin'an a'i tise tsa'oma ñotsse coira'ninda ¿ma'caen tsu tise an'bian'choma cca'naña? Tsa'ma o'tie tsama indipa tandamba tise'bema cca'nañe osha. Nane ñajan tsa'caen Satanama patsupa gi tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Majan ñai'ccu fae'ngae semambi'ta ñai'ccu iyicco'su tsu. Toya'caen majan ñai'ccu fae'ngae taimbi'ta ñoa'me shequian cati'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tsa'cansi gi que'ima su: Osha'cho egae tsincon'cho, osha'cho Chiganga afase'cho'qque a'i'ye joqquitssiqque'su tsu. Tsa'ma majan Chiga Qquendya'pama afase'ninda ñoa'me tsu tise egae tsincon'choja joqquitssi'masia. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nane poiyi'cco majan Sefaccone Ji'cho A'ima afase'ninda tise tsa'caen egae tsincon'choja joqquitssiqque'su tsu. Tsa'ma majan Chiga Qquendya'pama afase'ninda ñoa'me tsu tise egae tsincon'choja joqquitssi'masia. Ni ja'ño ni jai'ngae tsangae joqquitssi'masia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ñotsse in'jan'faja. Teta'cho ñotssianda quini'jin'qque ñotssi tsu. Teta'cho ega'ta quini'jin'qque ega. Teta'choma attepa quini'jima in'janqquia'caen a'i tson'choma attepa tise in'jan'choma'qque in'jan'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Que'ija iyo dushundeqquia'caen ega'fa. ¿Ma'caen qui ñotsse afa'faya? Nane tisu injama'cho in'jan'choma tsu a'ija in'jamba aya'fai'ccu afa. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ño'a a'ija tise injama'cho ñotsse in'jan'cho'suma somboemba ñotssiama tsu canjaen. Tsa'ma ega a'ija tise injama'cho egae in'jan'cho'suma somboemba egama tsu canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Toya'caen gi que'ima su: Chigaja osha'cho a'i injanga afa'choma agattopa osefaeña'cho a'ta tsendeccuma vanaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nane que'i aya'fa su'choma canjaensi ñotssi'ta qui ccusha'faya; ega'ta qui shacapa qque'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsonsi majan Chiga Tevaen'jema atesusundeccu fariseondeccu'qque Jesúsma su'fa: —Atesian'su, sefacconi'su canjaen'choma canjaenjan ingi atte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tiseja su: —Ja'ño'su aindeccu tise'pa Chigave in'jan'choma catipa egave in'jamba sefacconi'su canjaen'choma iñajan'fa. Tsa'ma tayopi'su Chiga Aya'fama afa'su Jonás canjaen'chove'yi canjaemba Chigaja faesu canjaen'chove canjaeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nane Jonás tres a'ta, tres cose'qque rande avu ttopani can'jenqquia'caen gi Sefaccone Ji'cho A'i'qque papa tres a'ta, tres cose'qque andenga a'tu'fasi can'jeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Osefaeña'cho a'ta napisi Nínive canqquesundeccuja va ja'ño'su aindeccu shacama tsu canjaen'faya. Tsendeccuja Jonásma pañamba tisupa egae tsincon'choma chi'gapa Chigama iñajan'fa. Jonásma ti'tsse'tssia gi ja'ño can'jen. Can'jensi toya qui que'i egae tsincon'choma chi'ga'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Toya'caen tayopi'su Sabá ande'su na'su pushesuja biane ji israe'su na'su Salomón ñotsse in'jamba su'choma pañañe. Osefaeña'cho a'ta napisi tsu tise'qque ja'ño'su aindeccu shacama canjaeña. Va'tti gi Salomóma ti'tsse'tssia can'jen'ma qui ñama paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Cocoya a'i'ye joqquitssipa cocoya can'jeni ñombi'ye jacán. Tsa'ma tsa'caen ñombi'ye jacamba oshambipa ");
INSERT INTO conNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tisuma tsu su: “Ña mane sombopa jini gi toequi jaya.” Toequi japa atte tayo tsa'oma funduipa ñoñaqquia'caen tsa a'ija ñotsse injienge. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Attepa japa tisema ti'tsse egandeqquiama siete cocoyama i'ngasi poiyi'cco tsu tsa a'inga ca'nimba can'jen'fa. Tsa'cansi tayoema bove ega'o tsu tsa a'ine. Nane ja'ño'su aindeccu'qque tsa'caen ega'ta tsa'caeñi tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús toya a'i bo'fa'chonga atesian'jen'ni tise mama, tise quinshingendeccu'qque tseni ji'fa. Jipa tsa'o tsotefangayi ccutsu'fa Jesúsi'ccu afaye in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tsa'caen ccutsu'fasi cca'ija Jesúsnga conda: —Que mama, que quinshingendeccu'qque jipa tsotefangayi ccutsupa quei'ccu afaye ronda'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tsa'ma Jesúsja conda'sunga su: —¿Majan tsu ña mama? ¿Majan tsu ña quinshingendeccu? ");
INSERT INTO conNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Qquen supa tivei'ccu poiyi'cco tisema shondosundeccuma canjaemba su: —Vandeccu tsu ña mama, ña quinshingendeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nane poiyi'cco majan Chiga ña Sefacconi'su Quitsa aya'fama pañamba tsa'caen tson'da ñoa'me ña quinshin, ña que'tte, ña mama'can'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsequi a'ta Jesús tsaone sombopa mar otafani japa dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dyaisi tsain'bio a'i tisenga jipa bo'fa. Panshaen bo'fasi Jesúsja shavonga otsepa dyai. Dyaipa atesian'jen. A'i bo'fa'choja otafa'ye ccutsupa paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Condase'chongae osha'chone qquen atesian: —Jon'su gaiña jon'su ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gaiñasi enttingeja tsaiqui utufanga sheque. Tse'ttinga shequesi chhiriria jipa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Enttingeja fattocconga sheque. Tse'ttija ande re'ricco jin. Nane ande sai'ccosi utatsse sho'yo. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tsa'ma coejechiga desi setsa'fa me'i'onsi pandipa samba. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Enttingeja anccosiccunga sheque. Tsa'ma anccosi fae'ngae coensi nambe'yi pa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Faesu enttingeja ñotssia andenga shequepa sho'yopa ñotsse na'fa. Fae cho tsu cieme na'fa. Faesuja sesentave; faesuja treintave tsu na'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Majan tsonsina'pata ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesúsma shondosundeccu tisenga jipa su'fa: —¿Micomba qui condase'chongae aindeccuma atesian'jen? ");
INSERT INTO conNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tiseja su: —Tayoe ma'caen Chigama na'sian'cho aindeccuve dapa canse'faya'chone Chigaja condambi. Ja'ño tsu que'inga pañaeñe in'jan. Tsa'ma toya tsu cca'indeccuja pañañe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nane majan a'i tayo in'jamba ti'tsse tsu in'jan'faya. Osha'choma an'bianqquia'caen tsain'bitsse tsu in'jan'faya. Tsa'ma majan in'jambiqquia'caen injanga in'jan'chomanda tsu itsaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsa'cansi gi condase'chongae aindeccuma atesian'jen cuintsu in'jambe'yi paña'faye. Tso'fei'ccu can'ma atte'fambi. Tsonsinai'ccu paña'ma in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsendeccune tsu tayopi'su Chiga Aya'fama afa'su Isaíasja qquen su: Ñoa'me tsonsinai'ccu paña'ma qui in'jan'faya'mbi. Ñoa'me tso'fei'ccu atte'ma qui in'jan'faya'mbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nane va aindeccumbe injama'choja tombu'fa. Tsonsinai'ccu pañañe in'jambipa picco'fa. Tise'pa tso'fema tsu tsapi'fa. Nane tso'fei'ccu attesa'ne tsapi'fa. Tsonsinai'ccu pañasa'ne tsu picco'fa. Injama'choi'ccu in'jansa'ne tsu tombu'fa, ñame in'jamba ccushaengesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tsa'ma que'ija ñoa'me avujatssi'fa. Que'i tso'fei'ccu attepa qui in'jan'fa. Que'i tsonsinai'ccu pañamba qui in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ñoa'me gi que'inga tansintsse su: Tsain'bio tayopi'su Chiga Aya'fama afasundeccu, tayopi'su Chigave in'jamba ño'a aindeccu'qque que'i ja'ño atte'choma atteye ñombi'ye'ma atte'fambi. Que'i ja'ño paña'choma'qque pañañe ñombi'ye'ma paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Paña'faja gaiña jon'sune condase'choma. Ñotsse pañamba in'jan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Majan a'ija Chigama na'sian'cho aindeccuve daya'chone paña'ma in'jan'fambi. Tsendeccuja tsaiqui utufanga gaiñasi sheque'choacan'fa tsu. In'jambisi cocoya na'su jipa chhiriria choma anqquia'caen tise'pa injama'cho'ye tsa Chiga Aya'fama paña'jen'choma aqquepoen. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fattocconga sheque'choacan'fa tsu majan a'i Chiga Aya'fama pañamba avujatsse in'jan'chondeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsa'ma setsa'fa shacaqquia'caen injama'cho ta'etssimbi. Re'riccone in'jamba cca'indeccu Chiga Aya'fama pañasundeccuma noñangiansi me'detsse canse'ta tsu antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Cca'ija cho anccosiccunga sheque'choacan'fa tsu. Tsendeccuja Chiga Aya'fama paña'ma panshaen va ande'su jincho'choma in'jamba asi'ttaen'fa. Ricove daye in'jamba Chiga Aya'fama paña'choma fi'ttiqquia'caen tise in'jan'choma nañámbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tsa'ma majan a'ija ñotssia andenga jon'choacan'fa tsu Chiga Aya'fama pañamba injama'choi'ccu aqque'pambi'tsse in'jan'chondeccu. Ñotsse naqquia'caen cca'indeccunga condapa atapa'fa. Majan cieme atapa'fa. Majan sesentave, majan treintave atapa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús faesu condase'choma conda: —Chigama na'sian'cho aindeccuve daya'cho tsu qquen: A'i tise nasipanga ñotssia trigo choma jonqquia'caen tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A'i trigoma jon nanimba poiyi'cco ana'jensi tisema iyiccaye'su jipa trigoaca'ma ancco'si choma'qque tsa nasipanga jon. Jomba ccuyin ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ñotssia cho sho'yopa te'tasi fae'ngatsse ancco'si'qque sho'yo. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na'sumbe semasundeccu attepa na'sunga japa su'fa: “Na'su, ñotssia choma jonsi ancco'si'qque tsu fae'ngatsse sho'yo.” ");
INSERT INTO conNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na'su pañamba su: “Majan ñama iyiccaye'su tsu tsama jon.” Tsonsi semasundeccu iñajampaña'fa: “¿In'jan ti qui ingi japa tsa ancco'sima sa'sapa catiye?” ");
INSERT INTO conNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tsa'ma na'suja su: “Me'i, tsa'caen ancco'sima sa'sa'ta ño'a trigoma'qque qui fae'ngae saipa daño'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cuintsu antteja fae'ngae coen'faye. Taiya'cho napijisi gi taisundeccuma mandaya: ‘O'tie ancco'sima taipa boñamba tandanjan oqueya'chove. Tsama tai nanimba ñotssia trigoma taipa ña trigoma coira'je'ttinga boña'faja.’ ” ");
INSERT INTO conNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Faesu condase'choma'qque tise'panga qquen conda: —A'i Chigama na'sian'cho aindeccuve dapa ti'tsse tsu atapa'faya. Nane mostasa cho'ca'on tsu. A'ija mostasa choma tise nasipanga jon. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Poi choma bove'cco tsu mostasa cho. Tsa'ma sho'yopa tise na'jin faesu teta'choma ti'tsse rande tsu. Nane quini'jime daqquia'caen randesi chhiriria'qque chhajepa jipa ttembanga tsao'paen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Faesu condase'choma'qque tise'panga qquen conda: A'i Chigama na'sian'cho aindeccuve dapa ti'tsse atapa'fa'choja cupana'ccoa'ca'on tsu. Pushesu tsa re'riccoa cupana'ccoi'ccu harinama tres agatto'chove cupoensi injantsse tsu atapa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tsa'caen tsu Jesús condase'chongae aindeccu bo'fa'chonga osha'choma atesian'jen. Nane a'tatsse afambipa condase'chongaeyi tsu atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsa'caen tsu atesian'jen tayopi'su Chiga Aya'fama afa'su qquen suqquia'caen tsoñe: Condase'chongaeyi gi condapa atesiaña. Andema agattointene condambi'choama gi ja'ño condaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsomba Jesús a'i bo'fa'choma catipa tsaoni ja. Jasi tisema shondosundeccu tisenga jipa su'fa: —Ancco'sima nasipanga jon'cho condase'choma inginga a'tatsse condaja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Qquen su'fasi Jesúsja su: —Ñotssia trigo choma jon'suja Sefaccone Ji'cho A'i tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tise nasipa tsu pa'cco ande. Ñotssia trigo cho tsu poiyi'cco Chigambe aindeccu. Trigoaca'ma ancco'si cho tsu cocoya na'su aindeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Satana, tsa cocoya na'su, tsu iyicca'yepa ega choma jon'su. Taiya'cho tsu osefaeña'cho a'ta. Chigama sefacconi'su shondosundeccu tsu tai'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nane trigoaca'ma ancco'sima taipa si'ngenga oqueqquia'caen tsu tsequi a'ta ega aindeccuma oque'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sefaccone Ji'cho A'i mandasi tise'be sefacconi'su shondosundeccu japa Chigama na'sian'cho aindeccuma boñamba poiyi'cco cca'indeccuma egae tsincoensundeccuma, poiyi'cco egae tsinconsundeccuma'qque attufaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Attufaemba si'nge anchanda'je'chonga cati'faya. Tseni catiyepa i'na'faya. Nane vana'jemba ttun'dundu'je'e iyicca'yepa i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tsonsi Chigambe ño'a aindeccu tise'pa yaya Chiga Quitsai'ccu fae'ngae can'jemba coejechiga'caen tsu chanjun'faya. Majan tsonsina'pata ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Chigama na'sian'cho aindeccuve daya'cho tsu coria'caen ñoa'me bare. Nane tayopi'su a'i corima andenga a'tupa pasi ja'ño'su a'i pa'fupa atte. Attepa junde ccase piccopa avujatsse japa pa'cco tise an'bian'choma chavaen. Chavaemba corifin'dima isupa japa cori ccui'ttima chava. Andema chavapa pa'cco corima'qque tise'be an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Toya'caen Chigama na'sian'cho aindeccuve daya'cho tsu bare'cho totoa moyo erani jinchoa'caen ñoa'me bare. Totoa moyoma chava'su tsama chavaye japa fae'ccoma atte osha'cho faesuma bove ñotssiama. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Attepa chavaye in'jamba japa pa'cco tise an'bian'choma chavaemba corifin'dima isupa jipa tsa totoa moyoma chava. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Toya'caen Chigama na'sian'cho aindeccuve daya'cho tsu avuma vachoqquia'caen. Vacho'vama marnga vachosi osha'cho ccaninga avu tsu tsanga indiye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","On'basi avuma vachosundeccu vacho'vama sa'anga qquitssa somboemba indi'fa. Indipa ñotssiama tsu saparonga boña'fa. Tsa'ma barembi'choama tsu cati'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tsa'caen tsu osefaeña'cho a'ta. Chigama sefacconi'su shondosundeccu tsu ja'fa Chigambe ño'andeccuma boñamba egae tsinconsundeccuma attufaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Attufaemba tsu egae tsinconsundeccuma si'nge anchanda'je'chonga tsangae cati'faya. Tseni catiyepa tsu i'na'faya. Nane vana'jemba ttun'dundu'je'e iyicca'yepa i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsomba Jesús tisema shondosundeccuma iñajampaña: —¿Poiyi'cco va condase'choma ti qui paña'fa? Tise'paja su'fa: —Ju, Na'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsonsi tsu su: —Poi Chiga manda'choma atesian'su majan pañamba Chigama na'sian'cho a'ive da'ta tsa'o nasiaca'on tsu. Tsa tsa'o na'su tise'pa an'bian'chone tayopi'su ñotssia jincho'choma canjaeñe osha. Toya'caen tsu cuna ñotssiama canjaeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús tsa'caen condase'chongae atesian nanimba tse'ttie sombopa ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tise coen'cho canqquenga napipa Chiga manda'chone atesian'jen'ttinga ca'nimba atesian'jen. Aindeccu pañamba can'boen'fa. Can'boemba su'fa: —¿Majan tsu va tsandiema atesiansi injama'pae da? ¿Majan tsu tisema oshaen sefacconi'su agattoen'choma canjaeñe? ");
INSERT INTO conNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tiseja mesama sema'sumbe dutssi'ye tsu. Tise mama tsu María. Tise quinshingendeccu tsu Santiago, José, Simón, Judas'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tise que'ttendeccu'qque vani ingi'ccu can'jen'fa. Tsa'cansi ¿mani tsu japa tsa'caen osha'choma atesupa ji? ");
INSERT INTO conNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsa'caen in'jamba Jesúsma paña'fambi. Tsa'ma Jesúsja tise'panga su: —Chiga Aya'fama afa'su ccani jasi tsenisundeccu tisema pañamba in'jan'fa. Tsa'ma tisu andeni, tisu tsaoni jisi tisema paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tsenisundeccu tisema in'jambisi Jesúsja tsain'bio canjaen'choma tse'ttinga canjaembi. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tse'i Galilea ande na'su Herodes osha'cho Jesús tson'chone paña. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pañamba tisema fuitesundeccunga su: —Va a'ija Feti'su Juan. Papa tsu ccase qquendya. Tsa'caen ccase qquendyapa tsu osha'cho agattoen'choma canjaeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nane Herodesja tise quinshi Felipe pushema in'jamba itsa tisumbeve. Tsa'caen egae tsinconsi Juan tisema iyu'u: —Manda'cho tsu se'pi tsa pushesuma pusheye. Qquen iyu'usi tsa pushesu, Herodíasja, Juanma iyicca'yepa fi'ttiye in'jan. Tsa'caen in'jansi na'su Herodes Juanma indipa candenai'ccu tandamba picco'je'ttinga picco. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsa'ma fi'ttiye in'jan'ma tsa andesundeccuma dyojopa antte. Nane poiyi'cco a'i tsu in'jan'fa Juanjan Chiga Aya'fama afa'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsonsi Herodes canqque'fa napisi fiestaen'jen'fa. Herodías onque'ngeja fiestani bo'fa'chonga jipa boira'je. Boira'jesi Herodes camba avuja. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Camba avujapa ñoa'me su'choi'ccu, “Osha'cho jongoesuve que in'jan'ninda gi afeya,” qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodes qquen susi pushesuja, tise chan Herodíasi'ccu condasepa chan in'janqquia'caen japa Herodesma su: Ñanga afeja Feti'su Juan tsovema. Patiyanga ppiñamba ñanga afeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Qquen susi Herodes ñombi'ye. Tsa'ma ñoa'me su'choi'ccu afeye supa poiyi'cco fiestani jisundeccu paña'fasi tiseja manda pushesu in'janqquia'caen tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mandasi sundarondeccu picco'je'ttinga japa Juan tsovema chattu. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chattupa patiyanga ppiñamba ipa pushesunga afe. Pushesu isupa tise changa angapa afe. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsonsi Feti'su Juanma shondosundeccu jipa Juan ai'voma angapa a'tu'fa. A'tupa japa Jesúsnga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesúsja Juanma fi'tti'chone pañamba tse'ttie sombopa shavonga otsepa a'i menia ja tisuyi can'jenccaye. Tsa'ma aindeccu pañamba poi canqquene sombopa tsu'ttengae tisema omboemba a'i menia o'tie ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tsa'cansi Jesús shavo'ye sombopa tsain'bio a'ima atte. Attepa injama'cho tsosipie tise'pama mende'ye. Mende'yepa tise'pa pajisundeccuma'qque ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tayo cose jisi Jesúsma shondosundeccu Jesúsnga jipa su'fa: —Vani a'i menia gi can'jen'fa. Tayo tsu cose. Aindeccu bo'fa'choma mandamañajan cuintsu chipiri canqqueni japa aña'choma chavapa an'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsa'ma Jesús tise'pama su: —¿Ma'caen tsu moeña'cho? Que'i tise'pama o'fian'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsa'ma tisema su'fa: —Nane cinco pan, dos avuveyi gi an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Qquen susi Jesús su: —Ipa afe'faja ñanga que'i aña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Afesi Jesús a'i bo'fa'choma manda cuintsu shoshovinga dyai'faye. Tsa'caen mandapa cinco panma, dos avuma'qque isupa Chiga sefacconima asuccocamba aña'chone Chigama ñotsse afa. Qquen afapa panma doñamba tisema shondosundeccunga afe cuintsu aindeccunga attufaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Poiyi'cco a'i isupa an'fa. An tteppu'fasi Jesúsma shondosundeccu japa an antteye'cho sheque'pama taipa doce saparove on'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","An'fa'chondeccu tsu tsandienaccuyi cinco milca'on. Toya'caen tsain'bio pushesundeccu, dushundeccu'qque an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","An nanimba tse'faei'ccuyi Jesús tisema shondosundeccuma manda shavonga otsepa tisema catipa mar jonifani o'tie ja'faye. Jesúsja can'jemba aindeccuma mandamañamba omboe jaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tsomba a'i bo'fa'choma mandamañamba Jesús ccotta'cconga ansunde tisuyi Chigama iñajañe. Tayo cosesi tisuyi tse'tti can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tsa'ma tisema shondosundeccu shavongae tayo enttinge marni can'jen'fa. Fingian toeningae fingiansi shave'pa'qque jangipa shavonga zonzoen. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsa'caen vana'jensi ñoa'me enttinge cose, toya a'ta ccutsumbi'te Jesús mar na'en omba'ye tsui jipa tise'panga catse. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tsa'caen na'en omba'ye tsui jisi attepa tisema shondosundeccu ñoa'me dyo'fa. Dyopa quia'me fundo'fa: —¡Aya tsu! ");
INSERT INTO conNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsa'ma Jesús tise'pama afapa su: —Dyombe can'faja. Ña gi. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Qquen susi Pedro asi'ttaemba su: —Na'su, ñoa'me queja, ñama mandaja na'en omba'ye ña queni jiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Qquen susi Jesús tisema su: —Jujú, ¡jija! Tsonsi Pedro shavo'ye sombopa na'en omba'ye tsui ja Jesúsnga jaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tsa'ma tsui jayipa fingiama in'jamba dyo. Dyopa andeccoye ashaen. Andeccoye tson'jemba quia'me fundo qquen supa: —Na'su, ¡ñama ccushaenjan! ");
INSERT INTO conNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tse'faei'ccuyi Jesús catsepa tise tivema yasapa Pedroma indi. Indipa tisema su: —Aqquia re'riccoe qui ñame in'jan. ¿Micomba tsu que injama'choja shaca? ");
INSERT INTO conNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsomba Jesús Pedro'qque shavonga otsesi fingianjan vuiqui. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Shavoni can'jensundeccu Jesúsnga catsepa ccaru dyaipa tisema ñotsse afa'fa qquen supa: —Que qui ñoa'me Chiga Dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Marma isepa Genesaret andeni cattufa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tseni can'jensundeccu “Jesús tsu” qquen in'jamba pa'cco tsa andesundeccunga tise ji'chone conda'fa. Condasi poiyi'cco tise'pani'su pajisundeccuma Jesúsnga i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ipa tisema iñajan'fa cuintsu tise ondiccu'je utufama pporaeñe antteye. Tsaveyi pporaemba tsu ccusha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsonsi majan fariseondeccu, majan Chiga manda'choma atesiansundeccu'qque Jerusaléne jipa Jesúsnga catsepa iñajampaña'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Micomba tsu quema shondosundeccuja tayopi'su coenzandeccu nafattian'choma cati'fa? Nane asettu'choma injiengembe'yi tsu an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsa'ma Jesús tise'pama ccane'qque iñajampaña: —Que'i'qque, ¿micomba qui Chiga manda'choma cati'fa que'i nafattu'choma in'jamba tsoñe? ");
INSERT INTO conNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nane Chiga manda'cho tsu su: “Que yaya, que mamama ñotsse in'jamba paña'faja.” Toya'caen: “Majan a'i tise yaya, tise mamama chi'gapa afase'ninda tisema tsu fi'ttiya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tsa'ma que'ija su'fa, a'i tise yaya, tise mamama fuiteye in'jambi'ta qquen suye osha: “Pa'cco ña an'bian'choma tayo Chiganga afepa gi que'ima fuiteye oshambi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tsa'caen supa fuitembe'yi tsu can'fa. Nane tsa'caen supa qui Chiga Aya'fama catipa que'i nafattu'choma in'jamba tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ño'ame attiamba afopoensundeccu qui! Tansintsse tsu tayopi'su Isaíasja que'ine tevaen. Chiga su'choma tsu qquen tevaen: ");
INSERT INTO conNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Va aindeccu tise'pa aya'fai'ccu ñama ñotsse afa'fa. Tsa'ma injama'cho tsosipieja biani can'jenqquia'caen ñama chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Injanga tsu ñama iñajamba ñotsse afa'fa. Tise'pa atesian'cho'qque a'i asi'ttaemba manda'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Fariseondeccunga qquen supa Jesús poiyi'cco a'ima ttu'sepa tise'panga su: —Ñama paña'faja. Pañamba in'jan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Me'i tsu a'i aña'choma ansi injama'choma dañoñe. Tsa'ma egae in'jamba afasi egae afa'je'cho tsu tise injama'choma dañoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Omboe tisema shondosundeccu tisenga jipa su'fa: —¿Atesu ti qui que tsa'caen susi fariseondeccu quema iyicca'ye'choma? ");
INSERT INTO conNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús pañamba su: —Majan jon'choja ña Sefacconi'su Quitsa jombi'choa, tsamajan sai isuya'cho. Nane setsa'fama'qque sai catiya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tsa'cansi fariseondeccu iyicca'ye'choma in'jan'fajama. Nane tise'paja binindeqquia'caen atesumbipa faesu atesumbi'chondeqquiama atesian qquen tson'fa. Fae bini faesu binima fendepa angacan'da poiyi'cco tsu fae'ngae ande changonga amppi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsonsi Pedro Jesúsma su: —Inginga tsa condase'choma tansintsse condaja. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesúsja su: —Que'i'qque ¿toya in'jan'fambi ti qui? ");
INSERT INTO conNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Atesu'fambi ti qui osha'cho an'choja aya'fanga ca'nimba ttopanga japa ccopai'ccu catiyeya'cho? ");
INSERT INTO conNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tsa'ma aya'fa'ye sombopa egae afa'choja ñoa'me injama'chone sombopa injama'cho in'jan'cho tsu. Tsa injama'cho in'jan'cho tsu a'ima dañoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nane injama'choi'ccu tsu a'ija egae in'jan'fa. Egae in'jamba tsu fi'tticco'fa. Casara'chondeccu tsu faesui'ccu egae can'se'fa. Injanga tsandie pushesu anttembi'chondeqquia fae'ngae can'se'fa. Nane Cca'na'fa. Afopoen'fa. Afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Qquen tson'cho tsu a'i injama'choma daño. Tsa'ma aqquia tivema otishimbe'yi an'fa'ni'qque a'i injama'choma dañoña'mbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tse'ttie sombopa Jesús Tiro, Sidón canqque jini'su andeni ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tseni jasi Cananea ande'su pushesu tse'tti can'jemba Jesúsnga jipa fundondo'e afa: —Na'su, David Dutssi'ye, ñama mende'yeja. Cocoya ña onque'ngenga ca'nisi tiseja dyo'oe vana'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Qquen fundo'jesi Jesús pañambiqquia'caen tisema afambi. Afambisi tisema shondosundeccu Jesúsnga catsepa su'fa: —Jovama mandamañajan. Panshaen tsu ingi'ccu omboencamba fundocan. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsa'caen su'fasi Jesúsja su: —Chigaja ñama moen Tise oveja qque'cho israendeccuveyi ttattapa ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pushesu tise su'choma pañamba catsepa Jesús tsutteccofanga ccaru dyaipa su: —Na'su, ñama fuiteja. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesúsja su: —Ñotssimbi tsu du'shu an'jen'choma itsapa ainga o'fiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pañamba pushesuja su: —Ju, na'su, ñotsse qui su. Tsa'ma ainshavaja an'jen'cho mesa tsosiccuni ccuipa an'jensi sheque'je'choma tsu an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Qquen susi Jesús tisema su: —Pushesu, ñoa'me qui ñame in'jan. Que in'janqquia'caen tsu tayo tson. Jesús qquen su'je'ni pushesumbe onque'ngeja ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús tse'ttie sombopa Galilea mar otafa'ye japa ccotta'cconga ansundepa dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dyaisi tsain'bio a'i tisenga bo'fa. Bopa ccareshendeccu, binindeccu, chafurundeccu, ayafambindeccu, osha'cho faesu pajisundeccuma'qque tisenga ipa tise tsutteccofanga ccuiña'fa cuintsu ccushaeñe. Jesúsja poiyi'cco pajisundeccuma ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ayafambindeccuja afa'fa. Chafurundeccuja cuname ccusha'fa. Ccareshendeccuja tsui ja'fa. Binindeccuja atte'fa. Poiyi'cco a'i tsama attepa israendeccu Chigama ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tsonsi Jesús tisema shondosundeccuma ttu'sepa su: —Va aindeccuma gi mende'ye. Tres a'ta ingi'ccu can'jemba ja'ño aña'chove an'bian'fambi tisupa añe. Injanga manda moeñe in'jambi gi tteppiambe'yi tise'pa tsaoni. Nane toya tsaiqui'ye jayipa quin'su me'i'en dasi amppi'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesúsma shondosundeccuja su'fa: —Vani a'i menia can'jemba ¿mani gi japa panma chavanga'faya va tsain'bio a'ima o'fiañe? ");
INSERT INTO conNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsonsi Jesús iñajampaña: —¿Mañi'cco panme qui an'bian'fa? Tise'paja su'fa: —Siete. Toya'caen re'ricco sambirima'qque gi an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsonsi Jesúsja aindeccuma manda cuintsu andenga dyai'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Siete panma, avuma'qque tise tivenga isupa Chigama ñotsse afa. Afapa aña'choma doñañacca tisema shondosundeccunga attufaemba afe. Shondosundeccu'qque aindeccunga attufaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Poiyi'cco a'i an teppu'fasi Jesúsma shondosundeccuja an antteyesi sheque'choma taipa siete rande saparove tsu on'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","An'fa'chondeccuja tsandienaccu'yi tsu cuatro milca'on. Toya'caen pushesundeccu, dushundeccu'qque an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","An nanimba Jesús poiyi'cco a'ima mandamañamba tise'qque shavonga otsepa Magdala andeni ise'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tsonsi fariseondeccu, saduseondeccu'qque Jesúsnga ji'fa. Jipa tisema qqueñañe in'jamba sefacconi'su canjaen'chove atteye iñajan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tsa'ma Jesús tise'pama su: —Cose jisi sefaccoja cu'asi qui su'fa: “Tu'i tsu ñoa'ngatssiya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tsa'ma maqui a'ta sinte'yi sefaccoja cu'asi unjimba jangisi qui su'fa: “Ja'ño a'ta tsu unjin tuiye tson'jen.” Ñoa'me qui injama'paqquia'caen sefaccoma camba a'tave ñotsse atesu'fa. Tsa'ma Chiga Quitsa Tise in'jan'chone que'inga canjaen'choan qui toya atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Va ja'ño'su aindeccu egave in'jamba Chigave in'jambipa sefacconi'su canjaen'chove tsu iñajan'fa. Tsa'ma tayopi'su Chiga Aya'fama afa'su Jonás canjaen'chove'yi canjaemba Chigaja faesu canjaen'chove canjaeña'bi. Qquen supa Jesús tise'pa'ye joqquitssipa ccani ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesúsma shondosundeccu panma aqque'pa ja'fa mar jonifani. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tayo isepa tse'i in'jan'fasi Jesús tise'pama su: —Injama'tse fariseondeccu, saduseondeccumbe cupana'ccoma in'jan'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesús qquen susi tisema shondosundeccuja asi'ttaemba afacco'fa: —¡Panma i'fambisi tsu ya'caen su! ");
INSERT INTO conNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tsa'ma Jesús tise'pa asi'ttaen'choma in'jamba su: —¿Toya ti qui ñame ñotsse in'jambipa shaca'fa? ¿Jongoesie qui panma i'fambi'choane afacco'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Toya ti qui paña'fambi? ¿Tayo ti qui aqque'pa'fa cincoyi'cho'cco panma cinco mil a'inga o'fian'choma? ¿Mañi'cco saparove qui an antteye'cho sheque'pama on'boen'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Toya'caen, ¿tayo ti qui aqque'pa'fa sieteyi'cho'cco panma cuatro mil a'inga o'fian'choma? ¿Mañi'cco rande saparove qui an antteye'cho sheque'pama on'boen'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tsa'ca'ma ¿micomba qui toya paña'fambi? Ñajan ja'ño panne afambi. Tsa'ma fariseo cupana'cco, saduseo cupana'ccone gi su. Injama'tse tsama pañamba qque'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Qquen susi tise'paja in'jan'fa. Jesúsja panme suforaenqque'su cupana'ccone afambipa poine fariseo atesian'jen'cho, saduseo atesian'jen'choma pañamba in'jan'fasa'ne tsu tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tsomba Jesús Cesarea Filipo canqque jincho andeni napipa tisema shondosundeccuma qquen iñajampaña: —Ñajan Sefaccone Ji'cho A'i. Tsa'ma ¿majan qquen tsu ñama faesu a'ita su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tise'paja su'fa: —Majandeccu'ta tsu su'fa: “Feti'su Juan.” Cca'ija: “Tayopi'su Elías.” Cca'ija: “Tayopi'su Jeremías.” Tsambi'ta: “Tayopi'su Chiga Aya'fama afa'su,” qquen tsu su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsonsi Jesús tise'pama iñajampaña: —Tsa'ma que'ija, ¿majan qquen qui ñama su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsonsi Pedroja su: —Queja Cristo. Tsangae canse'cho Chigambe Dutssi'ye qui. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsonsi Jesúsja su: —Simón, Jonás dutssi'ye, Chiga tsu quema ñotsse tson. A'i in'jan'choi'ccu ya'caen afambipa qui Chiga ña Quitsa quenga canjaen'choi'ccu afa. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Toya'caen gi quenga su: Que qui Pedro, “patu”, qquen su'cho. Tsa patuvo'chonga gi ñame in'jan'chondeccuma ta'iyaña. Tsa'caen ta'etsse ña ñoñasi pa'cho na'su si'nge anchanda'je'cho quin'sui'ccu ña aindeccuma osefaeñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Quenga gi Chigama na'sian'cho a'ive daya'cho yavema afeya. Yavei'ccu fettaqquia'caen osha'cho jongoesuma qui va andenga in'jamba mandasi tsa'caen tsu Chiga sefacconi'qque fettayeya. Yavei'ccu piccoqquia'caen osha'cho jongoesuma qui va andenga in'jamba se'pisi tsa'caen tsu Chiga sefacconi'qque piccoyeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Qquen supa Jesús tisema shondosundeccuma su cca'inga tiseja Cristo qquen condambe'yi can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsequi a'ta ashaemba Jesúsja tisema shondosundeccunga jai'ngae tsoña'chone conda. Tiseja Jerusaléni japa osha'chove tsu vanaña. Israe'su coenzandeccu, Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu'qque tisema indipa fi'ttiye afe'faya. Fi'ttisi tsu papa tres a'tagae ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Qquen susi Pedro tisema cca'ttinga angapa iyu'uye ashaemba su: —Na'su, Chigaja tsa'caen in'jambi. Minguite'qque tsu quenga tsa'caen tsoña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tsa'ma Jesús pañamba piyicamba Pedroma su: —Satana, ¡ña'ttie joqquitssija! ¿Ñama qqueñañe ti qui in'jan? Ñoa'me Chiga in'janqquia'caen qui in'jambi. A'i in'janqquia'caen qui in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsa'caen supa Jesús poiyi'cco tisema shondosundeccunga su: —Majan a'i ñai'ccu fae'ngae jiye in'jan'chota, tisu in'jan'choma catiya'cho. Tisu avuja'ccoma opiqquia'caen tsu tiseja ña'caen paya'ngae vanaña'cho. Ñai'ccu fae'ngae jacaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Majan a'i paye in'jambipa tisu canse'choma in'jan'da tsangae papa catiyeya. Tsa'ma majan ñame in'jamba vani canse'choma se'pimbe pa'ta ñoa'me tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿A'ija jongoesune tsu bareya poiyi'ccoma patsupa osha'choma an'biamba toya'caen tisu canse'choma qqueña'da? Nane ¿mi'getsse tsu afepoeña'cho a'ija tise canse'choma chavaye? ");
INSERT INTO conNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ñajan Sefaccone Ji'cho A'i joccapitssia've dapa ccase jiya. Chiga ña Quitsaja ñama ñotssiave canjaensi Chigama sefacconi'su shondosundeccui'ccu jipa gi attiaña. Ñajan tsa'caen attiamba a'i tsonqquia'caen poiyi'cco a'inga afeya. Ñotsse tso'ninda ñotssiama gi afeya. Ega tso'ninda egama gi afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ñoa'me gi que'inga su: Majan que'i'suja toya pambi'te qui Sefaccone Ji'cho A'i na'suve dapa jiya'choma atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tsa'caen supa seis a'ta pasasi Jesús ccotta'cco se'fatssia'nga ansunde'jepa Pedro, Santiagoma, toya'caen Santiago quinshin Juanma'qque anga tisupayi can'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tseni ansundepa tsendeccu camboen'jen'ni Jesús ccaningae tsu da. Tise camba'ju coejechiga'caen a'tatsse chanjun. Tise ondiccu'je'qque chhariccotssia tototssia've tsu da. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dos a'i'qque a'tatssia've attiamba Jesúsi'ccu condase'je'fa. Tayopi'su Moisés, tayopi'su Elías'qque ccutsupa condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro attepa Jesúsma su: —Na'su, ñotssi tsu ingija va'tti can'jen'faye. Que in'jan'ninda gi tres tsao'cho'ccoe tsao'ñaña –fae'cco quembe, faesuja Moisésmbe, faesuja Elíasmbe. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro toya afa'je'ni unjimba tototssia ccuttopa'sia'caen tise'pama picco. Tsonsi ccuttopa'si'ye aya'faja su: —Vaja ña in'jan'cho Dutssi'ye. Tisema gi ñotsse in'jan. Tisema paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsa'caen afa'choma pañamba Jesúsma shondosundeccu dyopa andenga amppipa puvie ccui'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsonsi Jesús tise'panga catsepa pporaemba su: —Jangipa ccutsu'faja. Dyombe can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Qquen susi asuccocamba Jesúsveyi atte'fa. Faesuma atte'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ccotta'cco'ye ande jipa Jesús tise'pama manda: —Que atte'choma ña toya can'jen'ni majangayi'qque conda'fajama. Sefaccone Ji'cho A'i gi ccase qquendyasi condaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsonsi shondosundeccuja Jesúsma iñajampaña'fa: —¿Micomba tsu Chiga manda'choma atesiansundeccuja su'fa: “Elías tsu Ccushaen'su Cristoma o'tie jiya”? ");
INSERT INTO conNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús pañamba su: Ñoa'me tsu Elíasja o'tie jiya. Tise jipa tsu a'i injama'choma in'jaeña cuintsu ccushaen'suma paña'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tsa'ma que'inga gi su, tayo tsu Elíasja ji. Jisi aindeccuja tisema atesumbipa tise'pa in'janqquia'caen injanga tisenga osha'cho egae tson'fa. Sefaccone Ji'cho A'ima'qque tsu tsa'caen vanaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús qquen susi tisema shondosundeccuja atesu'fa Jesús Feti'su Juanma Elías qquen su'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A'i bo'fa'chonga ccase jisi fa'e tse'tti can'jen'cho Jesúsnga catsepa tisenga ccarupa dyaipa ");
INSERT INTO conNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","iñajan: —Na'su, ña dutssi'yema mende'yeja. Shanccopajasheve da'cho tsu. Ñoa'me tsu vana'jen. Cunshomboen dapa si'ngenga amppi'pa. Na'enga'qque amppi'pa. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Quema shondosundeccuma ccushaeñe iñajansi tise'paja osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Qquen iñajansi Jesúsja su: —Que'i ja'ño'su aindeccuja tansintsse Chigave in'jambipa ccaningae qui in'jan'fa. ¿Min'ge'e gi tsuin'da quei'ccu can'jemba angacaña? I'ngaja du'shuma. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Du'shuma isi Jesús cocoyama iyu'upa joqquitssian. Iyu'usi du'shu'ye sombosi tse'faei'ccuyi du'shuja ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Omboe Jesús tisuyi can'jensi tisema shondosundeccu catsepa iñajampaña'fa: —Ingija ¿micomba gi cocoyama joqquitssiañe osha'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesúsja su: —Que'ija toya ñame ñoa'me in'jan'fambi. Nane ñame aqquia re'riccoe in'jan'da ñoa'me osha'choma qui osha'faya. Mostasa cho ñoa'me'qque chipiri tsu. Que in'jan'choja tsa'caen chipirisi va rande ccotta'ccoma “Joqquitssipa cca'ttinga japa ccutsuja” qquen mandasi tsa'caen tsu jaya. Que'i tsa'caen ñame in'jamba nane osha'choma qui osha'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nane ambe'yi tsu tsain'bitsse Chigama iñajaña'cho va cocoya'ca'ma joqquitssiañe; ");
INSERT INTO conNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tse'i Jesús, tisema shondosundeccu'qque Galileani fae'ngae jacamba Jesúsja tise'panga su: —Ña, Sefaccone Ji'cho A'ima afopoemba cca'indeccunga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Afesi tsu tsendeccu ñama fi'tti'faya. Ñama fi'ttisi tres a'tangae Chigaja ñama ccase qquendyaeña. Qquen susi tisema shondosundeccu ñoa'me ñombi'ye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús, tisema shondosundeccui'ccu Capernaumni napisi Chiga ettima ñoñaña'cho impuestoma isusundeccu jipa Pedroma iñajampaña'fa: —¿Quema atesian'suta ti Chiga ettima ñoñaña'cho impuestoma afepoen'jen? ");
INSERT INTO conNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedroja su: —Ju, afepoen'jen tsu. Tsonsi Pedro tsa'onga ca'nimba toya afambi'te Jesús tisema o'tie afapa iñajampaña: —Simón, asi'ttaemba ñanga condaja: ¿Majama tsu ande nasundeccuja impuestoma iñajamba isu'fa? ¿Tisupa dushundeccuma ti isu'fa? Tsambi'ta ¿cca'indeccuma ti isu'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro asi'ttaemba su: —Cca'indeccuma tsu isu'fa. Tsonsi Jesús su: —Tsa'caen cca'indeccuma isu'ninda tisupa dushundeccu afepoen'faya'bi. Qquen tsu Chiga'qque in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsa'ma in'jambi gi majameñi'qque iyiccoeñe. Marni japa pacoma simbaja. Asi'ta aya'fama shariamba qui corifin'dima atteya. Tsama isupa isusundeccunga japa afeja. Tsai'ccu qui ñane, quene'qque shacan'choma afepoeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tse'i Jesúsma shondosundeccu tisenga catsepa su'fa: —Chigama na'sian'cho a'ive dapa can'jemba ¿majan tsu ti'tsse'tssia've daya? ");
INSERT INTO conNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsonsi Jesús du'shu re'richo'ccoama ttu'sepa ccutsian tise'pa enttingenga. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tisema ccutsiamba shondosundeccuma su: —Ñoa'me gi que'ima su: Va du'shua'caen da'ta qui Chigama na'sian'cho a'ive da'faya. Tsambi'ta joccapitssia've daye in'jan'da ni ca'ni'faya'bi qui. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tsa'cansi majan tisuja ti'tsse'tssimbi qquen in'jamba va du'shua'caen da'ta tsaja Chigama na'sian'cho a'ima joccapitssia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Toya'caen majan ña a'ive dapa va du'shuma ñoa'me in'jan'da ñama'qque tsu ñoa'me in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tsa'ma majan va ñame in'jan'cho du'shuma egae tsoñe in'jaen'ninda bove ñotssi tsu tisema toya tsa'caen in'jaembite rande sunda'cho patuma tise tsifonga tandamba marnga andeccoemoeñe tsosini. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Va andeni osha'cho tsu jin a'ima qqueñañe cuintsu egae tsincon'faye. ¡Va'cha tsu va ande'su aindeccu! Tsaveqque'su egae tsincoñe qqueñasi tsu egae tsincon'faya. Tsa'ma ti'tsse va'cha tsu tsa a'ija majan cca'ima egae tsoñe injaen'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tisu tive, tisu tsu'tteyi quema in'jangae tsoñe in'jaen'ninda chattupa catija. Chafuru tsangae canseya'chonga ca'niñe tsu ti'tsse ñotssi, poifa'su tive, poifa'su tsu'ttepa si'nge anchanda'je'chonga catiye'chonga in'jaen'ninda. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tisu tso'fe'qque quema in'jangae tsoñe in'jaen'ninda tsefama tssan'jaña'cho. Nane faefa'su tso'fei'ccu tsangae canseya'chonga ca'niñe tsu ti'tsse ñotssi, poifa'su tso'fei'ccu si'nge anchanda'je'chonga catiye'chonga in'jaen'ninda. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Injama'tse majan va du'shua'can'ma chi'gasa'ne. Nane ñoa'me gi su: Tise'pama coira'su Chigama sefacconi'su shondosundeccu ña sefacconi'su Quitsai'ccu fae'ngae can'jemba cambajunaccunga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ñoa'me Sefaccone Ji'cho A'i gi qque'chondeccuma ccushaeñe ji. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ñotsse in'jan'faja: A'ija cien ovejama an'biamba fae'ccoma qqueña'da ¿mingae tsu tsoña? Ñoa'me fae'ccoma qqueña'da tsu noventa y nuevema toe'ttinga catipa ccotta'cconga jaya qque'choma tta'ttaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ñoa'me gi que'ima su, tta'ttapa qque'choma atte'ta ñoa'me tsu avujatssiya. Nane qquembi'choa noventa y nuevei'ccu tiseja tsa'caen avujatssimbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tsa'cañi tsu que'i sefacconi'su Quitsa'qque chi'ga, fa'e va du'shuacama'qque queñasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Faenga'su Chigave in'jan'cho quema egae tsincon'ninda tisuyi tisenga japa tise egae tsincon'choma condaja. Quema paña'ninda qui tsa'caen tisema fuitesi tsu quema ti'tsse in'jaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tsa'ma quema pañañe in'jambian'da ccase japa faesuma, tsambi'ta faesu dosma, fae'ngae tisenga angaja. Nane tsa'caen dos, tsambi'ta tres tsu tise egae tsincon'choma pañamba atesu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tsendeccuma'qque toya pañañe in'jambian'da poi Chigave in'jamba bo'fa'chondeccunga condaja. Tsa'ma tsendeccuma'qque pañañe in'jambian'da bo'je'cho'ye tisema joqquitssian'faja. Nane Chigave in'jambi'choama'caen tisema in'jan'faja. Nane impuestoma isu'suma'caen tisema in'jamba chi'ga'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tansintsse gi que'ima su: Osha'cho jongoesuve qui va andenga se'pi'ninda tsa'caen tsu Chiga sefacconi'qque se'piya'cho. Osha'cho jongoesuma qui va andenga in'jamba manda'ninda tsa'caen tsu Chiga sefacconi'qque in'jaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Toya'caen gi que'inga su: Dos que'i va andenga can'jemba fae'ngae in'jamba Chigama iñajan'ninda que'i in'janqquia'caen tsu Chiga ña sefacconi'su Quitsaja tsa'caen tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nane tres, tsambi'ta dosyi ñame in'jamba bo'fa'nijan ñajan tise'pai'ccu fae'ngae can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsonsi Pedro japa Jesúsma iñajampaña: —Na'su, faenga'su Cristove in'jan'cho ñama panshaen egae tsincon'ninda ¿mañi se gi tise egae tsincon'chone ñoquiya? ¿Siete seta ti ñotssi naniña? ");
INSERT INTO conNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús tisema su: —Quema gi su: Aqquia siete seyi tise egae tsincon'chone japa ñoqui'nijan naniñeña'bi. Nane setenta por siete se ja'ni'qque toya tsu naniñeña'bi. Agattombe'yi tsu tisema ñoquiya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ande na'su tise'be semasundeccu shacama fi'ttiqquia'caen tsu Chigama na'sian'cho aindeccuve dapa ñoquiya'cho. Nane ande na'su in'jamba mandasi tisema shacaensundeccuma i'fa cuintsu shacama afepoen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Fae a'i tsu cien mil rande corifin'dive shacaen'cho. Tisema isi ");
INSERT INTO conNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","afepoeñe oshambisi na'suja manda tisema chavaeñe. Nane tisema chavaemba toya'caen tsambe pushe, dushundeccuma, pa'cco tise an'bian'choma'qque chavaemba tsai'ccu corifin'dima isupa tise shacama fi'ttiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na'su qquen mandasi shacaen'choja na'su tsutteccofanga andenga amppi ccuipa iñajan: “Na'su, ñama mende'yepa ronda'jeja. Ñajan pa'ccoma afepoeña.” ");
INSERT INTO conNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Qquen iñajansi na'suja tisema mende'yepa pa'cco tise'be shacama injanga fi'tti. Shacama fi'ttipa tisema fetta maña. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Fettasi tiseja sombopa tisei'ccu fae'ngae sema'suma cachui. Tsa fae'ngae sema'suja tisema tsu cien chipiri corifin'dive shacaen'cho. Tisema cachuipa tise tsifoma mandyi indipa su: “Ñanga afeja que shacama.” ");
INSERT INTO conNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsa'caen susi fae'ngae sema'suja tise tsutteccofanga amppi ccuipa iñajan: “Ñama mende'yepa ronda'jeja. Ñajan pa'ccoma afepoeña.” ");
INSERT INTO conNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Qquen iñajansi shacama iñajan'suja pañambipa anttembi. Tisei'ccu fae'ngae sema'suma indipa piccoye afe cuintsu pa'cco shacama afepoemba somboye. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tsa'caen egae tson'jensi cca'i fae'ngae semasundeccu attepa ñoa'me ñombi'yepa na'sunga japa pa'ccoma conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na'su pañamba tsa a'ima ttu'sepa su: “Queja ñoa'me ega sema'su qui. Queja ñama iñajansi mende'yepa gi pa'cco que shacama fi'tti. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Que'qque ñotsse tsoña'choecan'da qui faenga'suma'qque tsa'caen mende'yepa tise shacama fi'ttiye'can.” ");
INSERT INTO conNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na'su tsa'caen supa iyicca'yepa manda cuintsu tsa ega sema'suma indipa iñaccaensundeccunga afesi tisema noñangiamba iñaccaen'faye pa'cco tise rande shacama afepoeña'gae. ");
INSERT INTO conNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Condase'choma qquen condasepa Jesúsja su: —Que'i'qque injama'chone faenga'suma ñotsse ñoqui'fambian'da ña Sefacconi'su Quitsa'qque tsa'caen que'ima vanaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús tsa'caen atesian nanimba Galileane sombopa Jordán na'en jonifani isepa ja. Tsa ande'qque Judea ande. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsain'bio a'i bopa tisei'ccu ja'fa. Tseni japa can'jemba Jesús pajisundeccuma ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Majan fariseondeccu Jesúsma qqueñañe in'jamba jipa iñajampaña'fa: —¿Manda'chota ti se'pi tsandie jongoesuve in'jan'da tise pushema catiye? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús ccane'qque tise'pama iñajampaña: —¿Attembi ti qui Chiga Tevaen'jen qquen su'choma: “Me'ttia'ye tsu Agattoen'su Chigaja a'ima agattoen. Tsandie, pushesuve'qque tsu agattoen.”? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Toya'caen tsu su: “Tsa'cansi tsu tsandieja tise yayama, tise mamama'qque catipa tise pushei'ccu fae'ngae canseya'cho. Tsa'caen fae'ngae cansepa tsu dos a'i fae a'iveyi da'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chiga Tevaen'jen tsa'caen susi dos a'imbipa ñoa'me fae a'iyi tsu. Chiga tise'pama fa'engayi tsonsi a'ija tsa'caen fae'ccoe da'choma attufaembe can'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesús qquen susi ccase tsu iñajampaña'fa: —Chiga tsa'caen in'jan'da ¿micomba tsu Tiseja Moisésma manda cuintsu a'i tise pushema catiye in'jan'da catiya'cho tevaen'jema tevaemba tise pushenga afepa catiye? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús pañamba su: —Nane que'i injama'cho shacasi tsu Moisésja tsa'caen que'ima manda antte que'i pushema cati'faye. Tsa'ma tseyi me'ttia'ye ande meinte tsu tsa'caen anttembi. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ñoa'me gi que'ima su: Tsandu'pa faesu tsandiei'ccu japa can'jemba egae tsincon'ninda tise tsa'ndu tevaen'jema tevaemba tise pushenga afepa catiye ñotssi. Tsa'ma osha'cho ccaningae tson'chone injanga tisema catiye oshambi. Nane tsa'caen injanga tevaemba catipa faesu pushesuma pushe'ta tsa tsandie'qque egae tsincon. Toya'caen majan tsandie tsa catiye'cho pushesuma pushe'ta tsa tsandie'qque egae tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Qquen susi Jesúsma shondosundeccu tisema su'fa: —Tsandie tise pushei'ccu tsa'caen tsinconsa'ne bove ñotssi tsu tsandie pushembe'yi canseye. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús pañamba su: —Nane poiyi'cco a'i tsu va atesian'choma paña'ma tsa'caen tsoñe osha'fambi. Majanga Chiga anttesi tsa'caen canseye osha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nane majan tsandie chuitepie ai'vo dañongepa ñotsse coembipa pusheye osha'fambi. Faesuja cca'indeccunga dañoñemba pusheye osha'fambi. Toya'caen majan a'ija Chigama na'sian'cho a'ive dapa pusheye in'jan'fambi. Tsa'cansi tsu majan osha'ta va atesian'jen'choma pañamba tsa'caen tsoña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsonsi chambanaccu tise'pa dushundeccuma Jesúsnga i'fa cuintsu Jesús dushundeccuma pporaeñe. Pporaemba tise'pane Chigama iñajañe. Tsa'ma toya jiña'fasi Jesúsma shondosundeccu Jesúsnga catseye se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús attepa su: —Antte'faja cuintsu dushundeccu ñanga ji'faye. Se'pimbe can'faja. Nane Chigama na'sian'cho aindeccuja va dushundeqquia'caen ñame in'jamba ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Qquen supa tise tivei'ccu dushundeccuma pporaemba Chigama iñajan. Iñajan nanimba ccani ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tse'i chu'a tsandie Jesúsnga catsepa iñajampaña: —Ñotssia atesian'su, ¿jongoesu ñotssiama gi tsoña tsangae canseye? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús tisema su: —¿Jongoesie qui ñamajan ñotssia qquen inisian? Fae'ccoyi tsu ñotssia. Chiga Quitsayi tsu. Tsa'ma queja tsangae canseye in'jan'da manda'choma pañamba tsoña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Qquen susi tsandie iñajampaña: —¿Majan manda'choma tsu pañamba tsoña'cho? Tsonsi Jesús su: —Cca'ima fi'ttijama. Faesumbe pushei'ccu cansejama. Cca'najama. Afopoenjama. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Que yaya, que mamama ñotsse in'jamba pañajan. Tisuma in'janqquia'caen faenga'suma ñotsse in'janjan. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Qquen susi chu'a tsandie Jesúsnga su: —Tsa'caen gi pañamba canse. ¿Jongoesuma tsoña'cho tsu shaca? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Qquen iñajampañasi Jesús su: —Ñoa'me ño'ame daye in'jan'da japa que an'bian'choma chavaemba corifin'dima isupa va'chandeccunga attufaenjan. Tsa'caen pa'ccoma afepa qui tsain'bitsse Chiga sefacconi an'biaña. Tsa'caen tsomba ñai'ccu fae'ngae jija. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsa'ma chu'a tsandie tsama pañamba ñoquimbi'ccoe dapa ja. Nane osha'choma an'biamba ñombi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsonsi Jesús tisema shondosundeccuma su: —Ñoa'me gi su: Aiye'pa tsu rico a'i Chigama na'sian'cho a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ju, ccase gi que'ima su: Ti'tssecan'da tsu oshambi'ye'can rico a'i Chigama na'sian'cho a'ive daye. Nane bove aiye'pambi tsu camelloja nojan'cco chango'ye panshañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Shondosundeccu tsama pañamba asi'ttaemba su'fa: —Tsa'caenda ¿majan tsu ccushaya? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tsa'ma Jesús tise'pama camba su: —A'ija tsa'caen osha'fambi. Tsa'ma Chigaja osha'choma oshacho. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsonsi Pedro su: —Na'su, ingija osha'cho ingi an'bian'choma catipa gi quei'ccu fae'ngae jacan'fa. ¿Jongoesuma gi isu'faya? ");
INSERT INTO conNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Qquen susi Jesús su: —Ñoa'me gi su: Jai'ngae osha'cho cuname dasi Sefaccone Ji'cho A'i tise ñotssia dyaipa'chonga dyaipa manda'nijan que'i'qque doce dyaipa'chonga dyaipa doce israendeccu'su aindeccuma manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nane poiyi'cco majan tise'pa tsa'o, tise'pa quindya, quinshin, she'she, que'tte, yaya, mama, pushe, dushundeccuma tise'pa andema'qque catipa ñame in'jan'da, tsaja cien se ti'tsse tsu isu'faya. Toya'caen tsu tsangae ñotsse canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tsa'ma tsain'bio majan ja'ño joccapitssiandeccu utu'ccoe tsu da'faya. Toya'caen tsain'bio ja'ño utu'ccoandeqquia tsequi a'ta joccapitssia've tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nasipa na'su tise'be semasundeccuma ttu'sepa afepoenqquia'caen tsu Chigaja tisema na'sian'cho aindeccuma ttu'sepa afepoeña. Nane nasipa na'su sinte'yi japa semasundeccuma ttu'se cuintsu tise ovaccuni japa sema'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ttu'sepa fae'ngae condasesi in'jan'fa. Fae a'ta sema'chone na'su fae corifin'dima tsu afepoeña. Qquen fae'ngae in'jan'fasi ovaccuni manda maña. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chiga toya tansimbite na'suja canqque atandundunga japa faesu aindeccuma atte, sema'jembindeqquia'ma. Attepa ");
INSERT INTO conNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","na'su tise'pama su: “Que'i'qque ña ovaccuni japa semasi gi que'inga ñotsse afepoeña.” Qquen susi tsu japa sema'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsonsi enttinge a'ta, toya'caen chiga ondusesi na'su japa faesu semasundeccuma'qque tsa'caen ttu'sepa semoen. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chiga amppijisi ccase japa faesu aindeccuma atte sema'jembindeqquia'ma. Attepa tise'pama iñajampaña: “¿Micomba qui pa'cco a'ta semambe'yi va'tti ccutsu'fa?” ");
INSERT INTO conNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tise'paja su'fa: “Majañi'qque ingima semañe mandambisi gi ronda'je'fa.” Qquen susi tsu manda: “Que'i'qque japa ña ovaccuni sema'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tsonsi tayo cosesi ovaccu na'su tisema shondo'suma ttu'sepa su: “Semasundeccuma ttu'sepa tise'panga afepoenjan. Omboe jisundeccunga o'tie afepoemba já tsa'yeyi o'tie jisundeccunga'qque afepoenjan.” ");
INSERT INTO conNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsonsi chiga amppiji'ni semañe ashaensundeccu jipa poiyi'cco tsu fae corifin'dima isu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsa'caen afepoensi sinte'yi ttu'sesi semasundeccu jipa ti'tsse isuye qquen asi'ttaen'fa. Tsa'ma tsendeccu'qque poiyi'cco tsu fae'ngatsse fae corifin'dima isu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Isupa tsu na'suma iyicca'yepa iyu'uye ashaen'fa qquen supa: ");
INSERT INTO conNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Va chiga amppiji'ni semañe ashaensundeccuja aqquia fae hora'ccoe semamba tsu ingi'ccu fae'ngatsse isu'fa. Ingija pa'cco a'ta coe'jenga quinsetsse semasi qui ingima tise'pai'ccu fae'ngae in'jamba afepoen.” ");
INSERT INTO conNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tsa'ma na'su pañamba fae'ccoma su: “Faenga'su, ña suqquia'caen gi tson. Fae a'ta semamba qui fae corifin'dima isuya qquen condasesi ¿tsama in'jamba ti qui sema? ");
INSERT INTO conNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tsa'cansi quenga afepoen'choma isupa jaja. In'jamba gi va omboe jipa sema'sunga quenga afepoenqquia'caeñi afepoen. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Corifin'dija ñambesi ¿oshambi ti gi ña in'janqquia'caen tsama afeye? Tsambi'ta ña ñotsse afesi ¿aqquia ti qui injama'choni cca'ima se'pi?” ");
INSERT INTO conNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nane omboe jisundeccu tsu o'tien'suve da'faya. O'tie jisundeccu tsu omba'suve da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusaléni jayipa tisema doce shondosundeccuma ccani angapa tisuyi can'jemba tise'pama su: ");
INSERT INTO conNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Que'i in'janqquia'caen gi Jerusaléni jayi'fa. Ñajan, Sefaccone Ji'cho A'i, tseni jasi ñama tsu afeya Chigama afa'su nasundeccunga, Chiga manda'choma atesiansundeccunga'qque. Tsendeccu tsu ñama fi'ttiye manda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Fi'ttiye mandapa tsu israembindeqquianga ñama afe'faya. Tsendeccu ñama afasepa ma'ppi'faya. Ma'ppipa ñama avuja'cconga otipa fi'tti'faya. Papa tres a'tangae gi ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsonsi Santiago chan Jesúsnga catse. Tsaja Zebedeo pushe. Tise dos dutssi'ye, Santiago, Juan'qque, Jesúsnga catse'fa. Catsepa pushesu tisenga ccarupa dyai tisu in'jan'choma iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iñajañe tson'jensi Jesúsja tisema iñajampaña: —¿Jongoesuve qui in'jan? Tiseja su: —Queja ande na'suve dapa chigáne antteja cuintsu va ña dos dutssiyendeccu ti'tsse joccapitssia nasundeccuve dapa que tansinfanga, que pavefanga pporotsse dyaipa manda'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Qquen iñajansi Jesús tsendeccuma su: —Que'i tsa'caen iñajamba atesu'fambi qui jongoesuve tisu iñajan'choma. ¿Osha'fa ti qui ña cui'ccuma cu'iqquia'caen vana'faye? ¿Osha'fa ti qui ña fetiye'chonga fetiyeqquia'caen vana'faye? Tise'paja su'fa: —Ju, osha'fa gi. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tsonsi Jesús su: —Ju, ñoa'me ña cui'ccuma qui cu'iya'cho. Ña fetiye'chonga que'i'qque fetiyeya'cho. Tsa'ma ña tansinfanga, ña pavefanga dyaiya'choveta ñajan antteye oshambi. Tsamajan antteya'cho majanga Chiga ña Quitsa tayo in'jamba ñoña'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Qquen iñajansi faesu diez shondosundeccuja pañamba tsa dos antiama iyicca'ye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iyicca'yesi Jesús poiyi'ccoma ttu'sepa su: —Que'i in'janqquia'caen tsu majan cocama na'suve dapa ti'tsse mandaye atesu'fa. Majan ti'tsse ñoa'me'qque na'su tsu faesu bove'ccoama manda. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tsa'can'faya'bi qui que'ija. Majan que'i ti'tsse na'suve daye in'jan'chota, faesuma fuiteya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Que'i majan joccapitssia na'suve daye in'jan'chota poimbe sema'suve daya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsa'caen ñajan, Sefaccone Ji'cho A'ita gi faesuma mandaye jimbi. Nane faesuma fuiteye gi ji. Tisuma afepa poimbe shacama afepoeñe gi ji ccushaya'chone. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó canqquene sombopa jayi'fasi tsain'bio a'i tise'pai'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jayi'fasi dos bini ja'je'cho tsaiqui utufani dyaipa a'i ja'je'choma paña'fa. Jesús'qque panshanjin qquen pañamba fundondo'e afa'fa: —Na'su, David Dutssi'ye, ingima mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Qquen fundo'je'fasi cca'indeccuja tise'pama iyu'u'fa cuintsu ziya'faye. Tsa'ma ziyambe'yi ti'tsse quia'me afa'fa: —Na'su, David Dutssi'ye, ingima mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsonsi Jesús já ccutsupa tise'pama ttu'se. Ttu'sepa iñajampaña: —¿Jongoesuve que'inga tsoñe qui in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tise'paja su'fa: —Na'su, in'jan'fa gi tso'fe bittaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Qquen susi Jesús tise'pama mende'yepa tise'pa tso'fema pporaen. Pporaensi tse'faei'ccuyi tise'pa tso'fe bittasi atteye osha'fa. Atteye oshapa fae'ngae Jesúsi'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusaléni ca'tsa napijipa Betfagéni napi'fa. Tsaja Olivo ccotta'cco pporotssi. Tseni napipa Jesúsja dos tisema shondosundeccuma manda ");
INSERT INTO conNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","qquen supa: —Va pporotssia chipiri canqqueni ja'faja. Tseni japa qui boro dusuchama atte'faya, tandan ccutsian'choma. Chan, tise du'shu'qque tse'tti ccutsu'choma qui atte'faya. Attepa ccupapa ñani i'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Majan a'i que'i tson'jensi jongoesu qquen iñajampaña'nijan, “Na'su tsu vanga dyaipa japa ccase i afeya,” qquen su'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Qquen tsu tson'fa tayopi'su Chiga Aya'fama afa'su qquen suqquia'caen tsoñe: ");
INSERT INTO conNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Zión canqquesundeccuma conda'faja: Que canjan, que'i Na'suja que'inga ji'je. Nane patsumbe'yi boronga dyaipa ji'je. Boro du'shunga, tsa semamba andu'choma andu'sumbe du'shungayi tsu ji'je. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús qquen susi shondosundeccuja japa tsa'caen tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Boro chama, toya'caen tise du'shuma'qque i'fa. Ipa tise'pa ondiccu'je'cho sarupama oshichhapa shondosundeccuja tsama ñoña'fa boro, boro du'shunga cuintsu Jesús tsanga dyaiye. Jesús otsepa dyaisi ");
INSERT INTO conNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tsain'bio a'i fae'ngae jayipa tise'pa ondiccu'je'cho sarupama oshichhapa tsaiquinga ppappa'fa cuintsu boro tsa'ye tsui jaye. Cca'indeccu ccaquejema chattupa tsama'qque tsaiquinga ppappa'fa, jaya'chove ñotsse ñoñañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Majan a'i o'tie jayi'fa. Cca'indeccu sepaccofae jiña'fa. Poiyi'cco tsu fundondo'e qquen afa'fa: —¡Avuja'faja! Ñotssi tsu na'su David Dutssi'ye. Na'su Chiga tisema mandasi jipa ñoa'me avujatssi tsu. Ñotssi tsu Chiga Quitsa sefacconi canjen'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tsonsi Jesús Jerusaléni ca'nisi poiyi'cco a'i attepa asi'ttaen'fa. Tsa'caen asi'ttaemba tsain'bio a'i qquen iñajampaña'fa: —¿Majan tsu va? ");
INSERT INTO conNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cca'indeccuja su'fa: —Vaja Chiga Aya'fama afa'su Jesús tsu. Galilea ande'su Nasaret canqque'su Chiga Aya'fama afa'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tsomba tse'i Jesús Chiga ettinga ca'nimba tse'ttini chavaensundeccuma atte. Chavasundeccu'qque tseni jipa chava'je'fa. Tsendeccuma attepa poiyi'ccoma tteya maña. Toya'caen corifin'dima cambiansundeccu tseni can'jensi Jesús tise'pa corifin'di mesama ccofetta amppian. Ppuppuju'choma chavaensundeccumbe dyaipa'choma'qque ccofetta amppian. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ccofetta amppiamba su: —Chiga Tevaen'jengae Chiga tsu su: “Ña tsa'oja ñama iñajan'jen'tti tsu.” Tsa'ma que'ija va Chiga ettima ccanamba tsa'ove tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsonsi binindeccu, ccareshendeccu'qque Chiga ettini tisenga ji'fa. Jisi Jesús tise'pama ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsa'ma Jesús tsa'caen ñotsse tsonsi Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu'qque attepa iyicca'ye'fa. Nane dushunaccu'qque Chiga ettini fundondo'e afa'fa: “Ñotssi tsu na'su David Dutssi'ye.” Qquen afa'fasi nasundeccu ti'tsse iyicca'yepa ");
INSERT INTO conNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesúsma su'fa: —¿Pañambi ti qui tise'pa su'chomajan? Jesús tise'pama su: —Ju, paña. Tsa'ma paña'fambi ti qui Chiga Aya'fa tsane qquen su'choma: Que anttesi dushunaccu, nane toya chocho'jendeccu'qque quema tansintsse ñotsse settapoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsomba Jesús tise'pama catipa ja. Canqquene sombopa Betaniani japa cosesi ana. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ccaqui a'ta sinte'ye toequi Jerusaléni jayipa Jesúsja qquipoe'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsaiqui utufa'su higuera'jima attepa catse teta'choma pi'shopa añe. Tsa'ma catsepa cansi name me'sionsi ccaquejeve'yi atte. Tsa'caen attepa quini'jima su: —Minga'ni'qque ccase na'faya'bi qui. Tse'faei'ccuyi quini'jinjan pandipa samba. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsama attepa Jesúsma shondosundeccu asi'ttaemba can'boen'fa. Can'boemba Jesúsma iñajampaña'fa: —¿Minga'osi tsu higuera'jinjan jova'caen junde samba? ");
INSERT INTO conNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús tise'pama su: —Ñoa'me gi que'ima su: Ñame in'jamba injama'cho shacambi'ta que'i'qque ña higuera'jima tsonqquia'caen qui tson'faya. Toya'caen ti'tsse tsomba qui va ccotta'ccoma suye osha'faya: “Va'ttie joqquitssipa marnga japa andeccoja.” Qquen mandasi tsu tsa'caen tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nane ñame in'jamba osha'cho jongoesuve iñajan'da qui tsa'caen isu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chiga ettini ccase ca'nimba Jesús a'ima atesian'jen. Atesian'jensi Chigama afa'su nasundeccu, israendeccu coenzandeccu'qque tiseni jipa qquen iñajampaña'fa: —¿Majan na'su in'jaensi qui queja tsa'caen tsincon? ¿Majan tsu quema manda antte na'sia'caen mandaye? ");
INSERT INTO conNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús pañamba su: —Ña'qque que'ima iñajampañaña. Ñanga conda'ninda gi que'inga'qque condaya majan in'jaensi ña tsa'caen tsincon'chove: ");
INSERT INTO conNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Juan feti'chota sefacconi'su Chiga mandasi feti'cho ti? Tsambi'ta ¿a'i mandasi feti'cho ti? Pañamba tisupanaccu condasecco'fa: —Ingija “Sefacconi'su Chiga mandasi feti'cho tsu” qquen su'ninda tise tsu suya: “¿Micomba qui Juanma pañamba in'jan'fambi?” ");
INSERT INTO conNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tsa'ma: “A'i mandasi feti'cho” qquen su'ninda, poiyi'cco a'i iyicca'yesi gi dyo'faya. Ñoa'me poiyi'cco a'i tsu Juanjan Chiga Aya'fama afa'su qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsa'caen asi'ttaemba Jesúsma qquen su'fa: —Majan Juanma fetiye manda'chove atesu'fambi gi. Tsonsi Jesús'qque tise'pama qquen su: —Jen'da ña'qque que'inga condaya'bi gi majan mandasi ña tsa'caen tsincon'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesúsja su: —¿Jongoe qquen qui in'jan'fa? Fae tsandie dos dutssiyendeccuve an'bian. Tsomba fae'ccoma su: “Jaricho, ja'ño japa semajan ña ovaccunima.” ");
INSERT INTO conNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dutssi'yeja su: “In'jambi gi.” Tsa'ma ti'tsse camba asi'ttaemba sema'su ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ja'i du'shumbe yayaja faesu dutssi'yeni ja. Japa tsa'caeñi tisema'qque su. Tsa'caen susi dutssi'yeja su: “Ju, na'su, jaya gi.” Tsa'ma jambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tsa dos dutssi'ye, ¿majan tsu tise yaya in'janqquia'caen tson? Pañasundeccuja su'fa: —Otien'su. Tsonsi Jesúsja su: —Ñoa'me gi su, govierno impuestoma isusundeccu, tisu ai'voi'ccu gana'su pushesundeccu'qque que'ima o'tie tsu Chigama na'sian'cho a'ive da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Feti'su Juanjan ji ma'caen canseya'chove atesiañe. Atesiansi que'ija in'jan'fambi. Tsa'ma govierno impuestoma isusundeccu, tisu ai'voi'ccu gana'su pushesundeccu'qque tisema pañamba in'jan'fa. Nane que'ija tsa'caen atte'ma que'i egae tsincon'choma chi'ga'fambi tisema pañamba in'jañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Paña'faja va faesu condase'choma: Fae ande na'su tise andenga ovaccuve jon. Jomba tseccuma ttu. Ttupa patu changove ñoña ova tsa'ccuma somboeña'chove. Toya'caen se'fatssia tsa'ove'qque tsao'ña tsa'ye tisu caña'jeña'chove. Pa'ccoma ñoñamba na'suja faesu semasundeccunga tsa ovaccuma afe cuintsu sema'faye. Semamba taipa enttingeve na'sunga'qque afe'faya'choe. Andema afepa ccani japa can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ovaite napijisi ande na'su tisema shondosundeccuma manda moen toequi cuintsu semasundeccuni japa na'sumbe enttingeve isu'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tsa'ma semasundeccuja na'sumbe shondosundeccuma qquitssa indipa fae'ccomajan tsse'tsse'fa; faesumajan fi'tti'fa; faesumajan patui'ccu ttovaccoen moen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsa'caen tson'fasi ande na'su ccase ti'tsse'tssi tisema shondosundeccuma moen. Tsa'ma tsendeccu'qque ji'fasi semasundeccuja faesundeccuma tsonqquia'caeñi tsendeccuma'qque egae tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jai'ngae na'suja tise dutssi'yema manda moen qquen asi'ttaemba: “Ña dutssi'yema tsu paña'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tsa'ma semasundeccuja na'sumbe dutssi'yema attepa tisupapora afacco'fa: “Va tsu ñoa'me na'sumbe dutssi'ye. Na'su pa'nijan vaja pa'cco na'su an'bian'choma tsu isuya. Jinge tisema fi'ttipa ovaccuma tisupambe isu'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Qquen asi'ttaemba dutssi'yema qquitssa indipa ovaccu'ye joqquitssipa fi'tti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tsa'caen condasepa Jesúsja pañasundeccuma iñajampaña: —Ovaccu na'su ji'ta ¿mingae tsu tsoña tsa semasundeccuma? ");
INSERT INTO conNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pañasundeccuja su'fa: —Mende'yembe'yi tsu tsa ega semasundeccuma fitti'ttiya. Tise'pama fi'ttipa ovaccuma faesu bove ñotssia semasundeccunga tsu afeya. Tsendeccunga afesi ovaite napisi tsu na'sunga enttingeve afe'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Qquen susi Jesús tise'pama su: —¿Can'fambi ti qui Chiga Tevaen'jen tsane qquen su'choma? Qquen tsu su: Tsaoñasundeccu in'jambipa joqquitssian'fa'cho patu tsu ñoa'me ti'tsse joccapitssia patuve da. Tsa'caen tsu Na'suja tson. Ingija attepa can'boemba “Ñotssi tsu” qquen asi'ttaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chiga Tevaen'jen tsa'caen susi gi que'ima su: Chigaja que'i'su Tise'be aindeccuve da'choma itsapa tsu faesunga afeya. Tsendeccuja Chigambe aindeccuve dapa tsu Chiganga tisumbema afe'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Patuve su'chone gi que'ima su: Majan pañambiqquia'caen tsa patunga zuccopanshan amppi'ta ñoa'me ucaqquia'caen tsu tisuma daño. Tsa'ma tsa patu majanga amppi'ninda ñoa'me vuvuqquia'caen tsangae tsu qqueya. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chigama afa'su nasundeccu, fariseondeccu'qque Jesús condase'je'choma pañamba tise'pane Jesúsja afa qquen tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsa'caen in'jamba Jesúsma indipa piccoye in'jan'ma dyopa antte aindeccu tise'pama iyicca'yesa'ne dyojopa. Nane poiyi'cco a'i tsu Jesúsja Chiga Aya'fama afa'su qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ccase Jesús condase'chongae atesiañe ashaemba qquen su: ");
INSERT INTO conNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ande na'su tise dutssi'ye pusheye tson'jensi fiestaeñe a'ima ttu'sepa tsonqquia'caen tsu Chigaja Tise'be aindeccuma'qque ttu'sepa tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsa na'suja tise'be semasundeccuma mandamaña tayo ttu'se'chondeccuma ttu'seye cuintsu ji'faye. Mandamañasi ttu'se'chondeccu jiye chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsonsi ti'tsse'tssi tise'be semasundeccuma mandamañamba qquen suye manda: “Tayo gi ña vaurama, faesu yayapatssia aña'choma'qque fi'tti. Tayo fi'ttipa osha'choma tayo ñoña fiestaeñe. Anqque'suma tayo ñoñamba que'ima ttu'se casara'cho fiestani ji'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsa'ma ttu'se'chondeccuja pañambiqquia'caen ccani ja'fa. Fae'cco tise nasipama semañe ja. Faesu tise tiendani ja chavaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Cca'indeccuja na'sumbe semasundeccuma indipa egae tsomba fi'tti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tsa'caen tson'fasi ande na'su pañamba ñoa'me iyicca'ye. Tise'be sundarondeccuma manda moen fi'ttisundeccuma ccane'qque fi'ttiye, tsendeccuma fi'ttipa tise'pa canqquema'qque oque catiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsomba na'su tise'be semasundeccuma su: “Casara'cho fiestaja tayo ñoña'cho tsu. Tsa'ma ttuse'chondeccuja ñotssimbipa jiye osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tsa'cansi canqque tsaiqui atandundunga japa poiyi'cco a'ima majama atte'ta ttu'se'faja cuintsu casara'cho fiestani ji'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tsa'caen mandasi semasundeccu canqque tsaiquinga japa tta'ttá jacamba majama attepa ttu'se'fa. Ño'a a'ima, ega a'ima'qque fae'ngae ttu'se'fa. Poiyi'ccoma ttu'sesi jipa casara'je'cho fiesta tsa'o on'ba'e bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Poiyi'cco a'i bo'fasi ande na'su jipa camba fae a'ima atte. Tsa a'ija casara'cho fiesta ondiccu'jema ondiccumbe'yi ca'nimba can'jen. Na'su tisema attepa ");
INSERT INTO conNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","su: “Faenga'su, queja casara'cho fiesta ondiccu'jema ondiccumbe'yi ¿ma'caen qui vani ca'ni?” Qquen iñajampañasi tsa a'ija afambe'yi ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Afambisi na'suja tisema semasundeccuma manda: “Jovama indipa tive, tsu'ttema'qque tandamba tsoteni sintssianga ttova cati'faja. Catiyepa tsu i'naña. Nane vana'jemba ttun'dundu'je'e iyicca'yepa i'naña.” ");
INSERT INTO conNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsain'bio a'i tsu ttu'se'chondeccu. Tsa'ma pañamba in'jan'chondeccuja tsain'biombi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús qquen atesiansi fariseondeccu pañamba japa tisupanaccui'ccu condasecco'fa. Condaseccopa tta'tta'fa ma'caen aya'fa su'choi'ccu Jesúsma qqueñamba shacapave atteye. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsa'caen condasepa majan tise'pama shondosundeccuma moen'fa cuintsu Herodes aindeccui'ccu Jesúsnga japa su'faye. Moensi japa Jesúsma su'fa: —Atesian'su, queja poiyi'cco a'i fae'ngatssi qquen in'jamba qui Chiga tsaiquine tansintsse atesian'jen. Nane a'i ccaningae su'choma pañambipa qui dyombi'tsse tansintsse atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tsa'caen atesian'jen'da que in'jan'choma inginga condaja: ¿Chiga manda'chota ti antte cuintsu ingija na'su César iñajansi impuestoma afeye? ¿Tsambi'ta se'pi ti? ");
INSERT INTO conNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tsa'caen Jesúsma qqueñañe iñajampañasi Jesúsja tise'pa egae in'jan'choma in'jamba qquen tise'pama su: —Que'ija ño'ame attianqquia'caen afopoensundeccu qui. ¿Jongoesie qui ñama qqueñañe in'jamba ya'caenjan iñajampaña'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","César iñajansi afepoen'cho corifin'dima ñanga canjaen'faja. Qquen susi denario corifin'dima tisenga ipa canjaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Canjaensi tsu iñajampaña: —¿Majambe tsovema tsu va corifin'dinga tevaen'cho? Toya'caen ¿majambe inisema tsu vanga tevaen'cho? ");
INSERT INTO conNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Qquen iñajampañasi tsu su'fa: —Na'su Césarmbe tsu. Tsonsi Jesús su: —Tsa'caenda Césarmbemajan Césarnga afe'faja. Toya'caen Chigambemajan Chiganga afe'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsama pañamba ñoa'me asi'ttaemba can'boemba ti'tsse iñajansepoembe'yi ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Toya'caen tsequi a'ta majan saduseondeccu Jesúsma can'su ji'fa. Saduseondeccuja a'i papa ccase qquendyaya'chone in'jan'fambi. Tsa'caen in'jambipa Jesúsni jipa ");
INSERT INTO conNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","qquen iñajampaña'fa: —Atesian'su, tayopi Moisés ingima mandapa tevaen cuintsu a'i du'shu mechoyi pasi tsambe pushe toya canse'nijan pa'chombe quinshiñi tsu pa'chombe pushema pusheya'cho. Tsomba tsu du'siaña'cho tise quindya'yembe inisema aqque'pasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nane vani ingi'ccu siete tsandie fae antian'suyi can'jen'fa. Coenzaja o'tie pushepa du'shuve mechoyi pa. Pasi tsandupajen'choma quinshin coenza pushe. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsa'qque pasi faesu quinshin bove'ccoa tsa pushesuma pushepa tise'qque pasi faesu, faesu poiyi'cco siete antiandeccu tsa'caeñi pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Poiyi'cco pa'fasi pushesu'qque pa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tsa'caen tsomba a'i ñoa'me ccase qquendya'ninda ¿majambe pusheve tsu daya? Ñoa'me poiyi'cco siete antiandeccu tsu tisema pushe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pañamba Jesús tise'pama su: —Que'ija Chiga Tevaen'jema ñotsse atesumbipa qui tsa'caen qque'fa. Toya'caen Chiga osha'choma oshachosi qui tsama'qque atesumbipa qque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nane a'i papa ccase qquendyapa Chigai'ccu can'jen'da pushe'masia, tsa'ndu'masia tsu. Tise'pa dushundeccuma'qque antte'faya'bi pusheye, tsa'nduye. Nane Chigambe sefacconi'su shondosundeqquia'caen pa'masiave dapa canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tsa'ma pa'chondeccu ccase qquendyaya'chone, ¿can'fambi ti qui Chiga tayopi que'inga su'choma? Nane Chigaja que'ima su: ");
INSERT INTO conNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ña gi Abraham, Isaac, Jacobmbe Chiga.” Nane Na'su Chigaja pa'chombe Chigambi tsu. Tsa'ma cansendeccumbe Chiga tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Qquen pañamba poiyi'cco a'i Abraham, Isaac, Jacob'qque toya canse'fa qquen in'jamba Jesús atesian'jen'choma asi'ttaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús tsa'caen saduseondeccu su'choma patsusi fariseondeccu pañamba bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bopa fa'eja Chiga Aya'fama atesian'supa Jesúsnga ji. Jipa aya'fai'ccu Jesúsma qqueñañe in'jamba iñajampaña: ");
INSERT INTO conNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Atesian'su, ¿majan Chiga manda'cho tsu ti'tsse'tssia? ");
INSERT INTO conNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesúsja su: —“Pa'cco que injama'choi'ccu Chiga Quitsa que na'suma ñotsse in'janjan. Pa'cco que canse'pai'ccu, pa'cco que in'jan'choi'ccu Tisema ñotsse in'janjan.” ");
INSERT INTO conNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tsa tsu o'tie tsoña'chove manda'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Toya'caen faesu manda'cho'qque fae'ngatssiqquia'can tsu: “Tisuma in'janqquia'caen faengasundeccuma'qque in'jaña'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Va dos manda'cho mandaqquia'caeñi tsu pa'cco Moisés manda'cho'qque atesiamba manda. Pa'cco Chiga Aya'fama afasundeccu'qque va dos manda'chone atesian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseondeccu toya tse'tti sheque'fasi ");
INSERT INTO conNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús tise'pama qquen iñajampaña: —¿Jongoesu qquen qui Cristone asi'ttaemba in'jan'fa? ¿Majambe dutssi'ye tsu? Qquen iñajampañasi tsu su'fa: —Na'su David Dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsonsi Jesús su: —David dutssi'yemanda ¿ma'caen tsu David'yeja Chiga Qquendya'pa tisema in'jaensi Cristoma afa: “Ña Na'su”? Nane qquen tsu David'ye tevaemba su: ");
INSERT INTO conNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Na'su Chigaja ña Na'sunga su: Ñai'ccu fae'ngae na'suve dapa va'ttinga dyaija ña tansinfanga. Ña quema iyiccayesundeccuma patsusi que tsu'tte tsosiccunga ccuiqquia'caen oshambipa quema paña'faya'gae. ");
INSERT INTO conNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David tsa'caen “Ña na'su” qquen susi ¿ma'caen tsu tiseja David dutssi'yeya? ");
INSERT INTO conNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Qquen iñajampañasi pañasundeccu jongoesu qquen suye in'jambipa afaye osha'fambi. Tsequi a'tangayi Jesúsma iñajansepoemba dyopa tsangae antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tsonsi Jesús aindeccunga tisema shondosundeccunga'qque su: ");
INSERT INTO conNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Manda'choma atesiansundeccu, fariseondeccu'qque tisuja injama'pa qquen tsu in'jan'fa. Chiga tise'pama anttesi Moisés manda'cho su'cho in'jan'choma tansintsse atesian'jen qquen tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tsa'cansi tise'pama pañamba tise'pa suqquia'caen tson'faja. Tsa'ma tise'pa canseqquia'caen canse'fajama. Nane tsendeccu tise'pa atesianqquia'caen tsombipa ccaningae tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Andu'cho tssai'ama andianqquia'caen osha'cho manda'choi'ccu aindeccuma tsain'bitsse vanaen'fa. Vana'jemba tsoñe osha'fambisi atesiansundeccuja ni fae tsimian'ccoi'ccuyi'qque fuite'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nane pa'cco tise'pa tson'choja aqquia canjaen'cho tsu cca'indeccu atte'faye. Tise'pa camba'junga, tise'pa tivenga'qque Chiga Aya'fa su'cho tevaen'cho ppiñaccuma panshaen randeve ancaen'fa. Tise'pa Chigama iñajañe oppoen'jen'cho sarupanga'qque botona'choma biáfavoe dusian'fa cca'imbema ti'tsse. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiestama panshaen'jen'niqque ñotssia dyaipa'chonga dyaipa añe in'jan'fa. Manda'choma atesian'jen'ttinga ja'a'qque bove ñotssia siyetanga dyaipa pañañe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Toya'caen canqque tsaiqui'ye jacan'fasi cca'indeccu tise'pama ñotsse in'jamba chigambian'faye in'jan'fa. Nane ñotsse in'jamba tise'pama “injama'pa atesian'su” qquen chigambiañe tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tsa'ma que'ija tsa'caen afaye'faya'bi qui. Tsa'caen tson'fajama a'i que'ima “injama'pa atesian'su” qquen afa'faye. Que'ija poiyi'cco faengasundeccu qui. Fae injama'pa atesian'suve qui an'bian'fa. Tsaja Cristo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Toya'caen faesu va ande'su a'ima ni fae'ccoveyi'qque “ño'a quitsa” qquen afa'fajama. Nane fae Sefacconi Canjen'su Chiga Quitsaveyi tsu tsa'caen afaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni que'imajan “na'su” qquen afa'faya'bi. Fae'cco tsu que'i na'su. Tsaja Cristo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Majan que'i'su ti'tsse'tssiaja que'ima shondopa fuiteya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nane poiyi'cco majan tisuma joccapitssia've tson'da ñoa'me utu'ccoa've tsu daya. Tsa'ma poiyi'cco majan tisuma utu'ccoe tson'da tsaja joccapitssia've tsu daya. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Sombo'ttima piccoqquia'caen qui se'pi'fa cca'indeccu Chigave in'jamba Tisema na'sian'cho aindeccuve da'fasa'ne. Nane que'ija Chiga sefacconi ca'nimbipa cca'indeccu ca'niñe in'jan'fasi qui tise'pama se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Tsandupajen'chondeccuma afopoemba tise'pa tsa'oma cca'namba itsa'fa. Tsa'caen egae tsomba qui injan'tsse Chigama iñajan'fa poiyi'cco a'i pañamba que'ija ño'a'fa qquen in'jan'faye. Tsa'caen tson'chone tsu Chigaja que'ima ti'tsse vanaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Biani'su andenga japa, mar jonifani'qque qui ja'fa fae'cco a'ima in'jaeñe cuintsu que'i in'janqquia'caen in'jañe. Tisema tsa'caen in'jaen'da qui tisuma ti'tsse egave tson'fa. Nane tiseja tsa'caen dapa ti'tsse tsu shacaen si'nge anchanda'je'chonga jaya'choe. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Vana'faya qui cca'ima angacansundeccu! Binindeccu qui. Qquen qui su'fa: “A'i tise su'cho ñoa'me su'cho qquen canjaeñe in'jamba Chiga ettima afa'a'qque ñoa'me su'chove canjaembi. Tsa'ma ‘Chiga etti'su cori caña'jen'ni’ qquen su'ta ñoa'me su'chove tsu canjaen.” ");
INSERT INTO conNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Binimba qui sumbi'fa! Tsa corima Chiga ettinga afesi Chigambe cori tsu. Tsambi'ta aqquia cori tsu. Tsa'cansi Chiga etti tsu tsa corima ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Toya'caen qui su'fa: “A'i tise su'cho ñoa'me su'cho qquen canjaeñe in'jamba Chiganga oque oraen'jen'cho mesama afa'a'qque ñoa'me su'chove canjaembi. Tsa'ma ‘Chiganga afe'je'cho oque oraen'jen'cho mesanga ota'cho caña'jen'ni’ qquen su'ta ñoa'me su'chove tsu canjaen.” ");
INSERT INTO conNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ñoa'me bini'fa qui! Afe'cho aña'cho oque oraen'jen'cho mesanga ccuipa Chigambe tsu. Tsambi'ta aqquia aña'cho tsu. Tsa'cansi oque oraen'jen'cho mesa tsu afe'je'cho aña'choma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nane majan oque oraen'jen'cho mesama tise su'cho ñoa'me su'cho qquen canjaeñe in'jamba iñajan'da mesama toya'caen mesanga ccui'choma'qque tsu iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Toya'caen majan Chiga ettima tise su'cho ñoa'me su'cho qquen canjaeñe in'jamba iñajan'da Chiga ettima toya'caen Chiga etti'su corima'qque tsu iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Toya'caen majan Chiga sefaccoma tise su'cho ñoa'me su'cho qquen canjaeñe in'jamba iñajan'da Chigambe dyaipa'choma tsu iñajan. Dyaipa'chonga dyai'su Chiga Quitsama'qque tsu iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Que'ija osha'choma decimo enttingeccoeyi Chiganga afeye atesu'fa, Tisema avujaeñe. Nane pa'cco ccoma, pa'cco cuña, pa'cco shinccapama'qque qui Chiganga decimo enttingeccoeyi afeye atesu'fa. Tsa'ma tsa'caen afe'a'qque manda'cho ti'tsse in'jan'choma qui cati'fa. Nane poiyi'ccoma fae'ngatsse tsoñe qui in'jan'fambi. Mendeqquiama qui ñotsse mende'ye'fambi. Ñoa'me tisu suqquia'caen tsombipa qui injanga canse'fa. Aqque'pa'fajama Chiganga afeye. Tsa'ma Chiga mandaqquia'caen canseye tsu ñoa'me tsoña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Bini angacansundeccu qui! ¡Nane ocuma cundesa'ne osha'choma ofi catipa qui camelloma cunde'fa! Tsa'caeñi utu'ccoa manda'choma pañamba joccapitssiama qui aqque'pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Tasama sepaccofaveyi giya'tsse cashisi naccunijan toya amundetssiqquia'caen qui ñotsse attiamba cca'indeccumbema cca'namba in'jangae canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Bini qui fariseo! Tasa naccuma o'tie cashiqquia'caen tisu injama'choma o'tie ñoñaña'cho. Injama'choni ñotssi'ta qui ñoa'me ñotssi. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Pa'choma atu'tti totoai'ccu onjoensi ñotsse attianqquia'caen qui ñotsse attian'fa. Tsa'ma tsosini pa'chondeccu tsu'tta, osha'cho congomba'qque shequeqquia'caen ");
INSERT INTO conNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tsu que'i injama'chonijan jincho. Tsa'cansi qui que'ija ñotssia a'ive attiamba injama'chonijan aqquia afopoemba egae tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Vana'faya qui manda'choma atesiansundeccu! ¡Vana'faya qui fariseondeccu! Ño'ame attiamba ega'fa qui. Chiga Aya'fama afasundeccu a'tu'ttima qui ñotssia atu'ttive ñoña'fa. Majan pa'chondeccuja tise'pa canseite ñotssia a'isi qui tise'pa atu'ttima te'taen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Toya'caen qui su'fa: “Ingi tayopi'su coenzandeccu canseite can'je'an'qque gi tise'pai'ccu fae'ngae Chiga Aya'fama afasundeccuma fi'tti'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","¿Ñoa'me ti qui su? Nane que'i su'cho tsu que'i shacama canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Que'i tayopi'su coenzandeccu Chiga Aya'fama afasundeccuma fi'ttiqquia'caen que'i'qque naniña'gae tson'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Ñoa'me iyoacan'fa qui! ¡Iyombe a'i'fa qui! ¿Ma'caen qui tisuma ccushaen'faya? Si'nge anchanda'je'chonga qui ja'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsa'can'fayasi gi Chiga Aya'fama afasundeccuma, injama'pa aindeccuma, atesiansundeccuma'qque que'inga moeña. Majanjan tsendeccu'suma qui fi'tti'faya. Majandeccumanda qui avuja'cconga otipa fi'tti'faya. Majandeccumanda qui Chigane atesian'jen'ttinga angapa ma'ppi'faya. Majandeccumanda qui fae canqquene faesu canqquenga mandian'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Que'i'qque tsa'caen ña que'inga moensi ji'chondeccuma chi'gapa qui poiyi'cco tayopi'su ño'andeccuma fi'tti'chone'qque shacaen'faya. Nane me'ttia'ye Abel ño'ama fitti'ttie ashaemba Zacaríasma fi'tti'chongae qui shacaen'faya. Zacarías –tsa Berequías dutssi'ye– Chigai'ccu cachuicco'je'cho cuarto jin'tti Chiganga afeye oque oraen'jen'tti ccutsusi qui tisema fi'tti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tsa'cansi ñoa'me gi su pa'cco tsaite fi'tti'chone'qque ja'ño'su aindeccuja shacaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Jerusalén, Jerusalén, Chiga Aya'fama afasundeccuma qui fi'tti! Chiga quenga moensi ji'chondeccuma qui patui'ccu ttovaccoen. Nane arapa tise dushundeccuma sanccopai'ccu sa'vianqquia'caen gi que dushundeccuma me'deye in'jan. Tsa'ma tsa'caen ña in'jansi qui se'pi. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tsa'cansi que metsse sefasi tsa'oja tisuyi ottaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ñoa'me gi su: Ccatsse'qque ñama atte'faya'bi qui qquen suya'ngae: “¡Ñoa'me ñotssi tsu Na'su Chiga Quitsa moensi ji'cho!” ");
INSERT INTO conNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Chiga etti'ye sombopa jayisi tisema shondosundeccu catsepa tsa Chiga ettine Jesúsi'ccu condaseye ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Condasesi Jesús tise'pama pañamba su: —¿Va tsa'oma ti qui atte'fa? Ñoa'me gi su: Ni fae patuyi'qque faesu patumbe ombani ottaya'bi tsu. Pa'ccoma tsu asitta'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivo ccotta'cconi japa Jesús tisuyi dyaisi tisema shondosundeccu catsepa a'tutsse iñajampaña'fa: —Chigáne inginga condaja ¿minga'ni tsu que suqquia'caen tsoña'cho? ¿Jongoesuma attepa gi que na'suve dapa jiña'chove atesu'faya? ¿Jongoesuma attepa gi osefaeña'cho a'ta napiji'chove atesu'faya? ");
INSERT INTO conNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Qquen iñajampañasi Jesús su: —Injama'tse majandeccu que'ima afopoemba qqueñasa'ne. Chigaja ñama moen a'ima ccushaen'suve. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsa'ma tsain'bio a'i tsu jipa: “Ña gi Chiga in'jan'cho Cristo” qquen afopoen'faya. Qquen supa tsain'bio a'ima qqueña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Toya'caen geraen'jen'fa'choma pañamba ja'i geraen'faya'choma paña'an'qque dyombe can'faja. Tsaveqque'su tsu. O'tie tsu tsa'caen tsoña'cho. Tsa'ma tse'faei'ccuyi osefaeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fae ande'su faesu ande'sui'ccu iyicco'faya'cho. Fae na'su faesu na'sui'ccu iyiccopa geraen'faya'cho. Cca'tti, cca'tti aindeccuja qquipoe'su'faya. Osha'cho paqque'sunga setsaye'faya. Ande'qque cca'tti, cca'tti oya'jeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tseyi du'shuma tteyaeñe ashaenqquia'caen tsu vanaen'jeña. Tsaja aqquia ashaen'jen'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tsomba que'ima indipa vanaen'faya. Vanaemba fi'tti'faya. Que'i ñame in'jansi poi ande'su a'i tsu que'ima chi'ga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tsonsi tsain'bio a'i ñame in'jan'chondeccu vana'jemba tsu ñama chi'ga'faya. Nane ñama chi'gapa cca'i ñame in'jan'chondeccuma'qque chi'gapa afe'faya cuintsu fi'tti'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Afopa'cho Chiga Aya'fama afasundeccu'qque afopoemba tsain'bio a'ima qqueña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Injantssia a'i tsa'caen ti'tsse egae tsincomba tsu tisupapora injancco'fa'choma antte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tsa'ma majan ta'etssia injama'chopa osefaeña'gae anttembe'yi in'jan'da tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Toya'caen va Chiga aindeccuve daya'chone ñotsse condase'choma poi andenga japa condasesi poi ande'su aindeccu paña'fasi tsu osefaeña'cho napiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Tayopi'su Chiga Aya'fama afa'su Daniel egae dyoña'sune condase. Tsa dyoña'su napipa tsangae tsu dañoña. Majan Jerusaléni can'jen'ni tsa su'cho Chigai'ccu cachuicco'jeccuni ca'nisi atte'ta ccotta'cconga japa tsu ccuya'faya'cho. (Va tevaen'jema camba afa'su ñotsse in'janjan.) ");
INSERT INTO conNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nane majan tsao'cco omba'su ppappacconi can'jen'da tsosiccuni'su cuartonga jongoesuve isuye andembe'yi tsu japa ccuya'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Majan nasipani can'jen'da tsaoni tise sarupave jimbe'yi tsu japa ccuya'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Va'cha pushesundeccuja majan suri, majan du'shuma chochoen'jen'cho'qque. Tsequi a'ta tsu vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nane Chigama iñajaña'cho cuintsu ni sanfainte ni sema'ma'qquia a'ta tsa ccuyaya'cho a'ta napisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nane sanfainte, sema'ma'qquia a'ta tsesu a'ta napi'ninda ñoa'me tsu a'i ti'tsse vana'faya. Nane andeve agattointe ashaen'cho ja'ño'qque a'ija tsa'caen vana'fambi. Jai'ngae'qque a'i tsa'caen ccase vana'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nane Chiga tsa'caen vanaña'cho a'tave agattoccoeyi anttembiecan'da ñoa'me tsu poi a'i pa'faye'can. Tsa'ma Chigaja Tise ttu'se'cho aindeccuma ccushaeñe in'jamba tsa'caen vanaña'chove agattoccoeyi antte panshaen vana'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tsa'cansi que'inga majan a'i: “Que canjan, va'tti tsu Cristoja can'jen”; tsambi'ta: “Que canjan, tseni tsu can'jen,” qquen su'ni'qque tisema paña'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nane afopa'cho cristondeccu, afopa'cho “Chiga Aya'fama afasundeccu” tsu attian'faya. Attiamba ñoa'me ti'tsse'tssia canjaen'cho, osha'cho agattoen'choma'qque tsu canjaen'faya a'ima qqueñañe. Nane osha'ta tsu Chiga ttu'se'chondeccuma'qque qqueña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tsa'caen toya tsombi'te gi que'inga conda que'i injan'jen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tsa'cansi majan que'inga: “Cristo tsu a'i menia can'jen,” qquen su'ni'qque tseni ja'fajama. Tsambipa: “Va tsa'o enttinge'su cuartoni Cristoja can'jen,” qquen su'ni'qque tise'pama paña'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nane Sefaccone Ji'cho A'i ñoa'me jiya'cho tsu qquen: Tsanda chiga sombo'jene chiga amppi'jeni'qque veyaensi atteqquia'caen tsu Cristo jisi poiyi'cco a'i tisema fae'ngatsse atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A'i pa'cho ai'vo ccui'chonga ccompana boqquia'caen tsu poiyi'cco in'jan'chondeccu Na'sunga bo'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tsequi a'ta vana'jen'cho pasasi coejechiga tsu si'ame daya. Cose'suchiga'qque chanjuña'bi. Sefacconi'su o'fe'qque amppi'faya. Nane pa'cco sefacconi'su jincho'cho'qque oya'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsa'caen tson'jen'ni tsu Sefaccone Ji'cho A'i jiña'chove canjaen'choja attiaña. Tsa'caen sefaccone attiansi poi ande'su aindeccu attepa i'na'faya. Nane Sefaccone Ji'cho A'i sefacconi'su unjimba'cco'ye dyai jiñasi poiyi'cco tsu tisema atte'faya. Ñoa'me joccapitssia a'tatssiai'ccu jiñamba ");
INSERT INTO conNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tisema sefacconi'su shondosundeccuma tsu mandamoeña. Nane moensi jeña'choma quia'me jeñamba poi biani'su andeni japa Cristo ttu'sepa in'jan'chondeccuma tsu i'nga'faya. Nane sefacco já ccutsuni'qque japa i'nga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Higuera tetachojima camba atesu'faja. Ttemba cuname sombosi ccaqueje'qque chu'pasi coejefave daji qquen qui in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tsa'caen que'i ña su'choma attepa qui in'jan'faya ña jiya'chove ca'tsa napiji. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ñoa'me gi su: Ja'ño cansesundeccu toya pa sefambi'te tsu pa'cco ña su'choja napiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nane sefacco, ande'qque pasaya. Tsa'ma ña aya'faja pasaya'bi. Ñoa'me su'cho tsu. Ña suqquia'caen tsu daya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tsa'ma maqui a'ta ma'can horani jiya'chove majañi'qque atesu'fambi. Nane Chigama sefacconi'su shondosundeccu, ni ña, Chiga Dutssi'ye'qque gi atesumbi. Tsamajan Chiga Quitsayi tsu atesucho. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tayopi'su Noé can'jeinte tsinconqquia'caen tsu ña ccase jiqui tson'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nane Noé tsa'o shavonga otse'cho a'tangae tayopi'su a'ija an'jemba cui'je'fa. Tsandie tsu pushe'fa. Pushesu tsu tsa'ndu'fa. Tisupa dushundeccuma'qque antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tsa'caen atesumbe injanga canse'fa'ni na'en jipa poiyi'ccoma tsangae picco cati. Tsa'caen tsu a'ija Chigave in'jambe injanga canse'faya ña Sefaccone Ji'cho A'i jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nane tsequi a'ta dos tsandie nasipani sema'jen'fa'choma fae'ccoma angapa faesumajan catiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dos pushesu'qque fae'ngae sunda'je'fa'choma fae'ccoma angapa faesumajan catiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tsa'cansi ñotsse qquendyaqquia'caen ronda'je'faja. Atesu'fambi qui maqui a'ta que'i na'su jiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ñotsse in'jan'faja: Tsa'o na'suja ccanamba mi'getssi horani cose jiya'chove atesu'choecan'da ñoa'me tsu bittapa caña'jeñe'can tise tsa'o'suma cca'nasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Que'i'qque tsa'caen bittapa caña'jenqquia'caen ronda'je'faja que'i in'jambi'te Sefaccone Ji'cho A'i jisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tsa'cansi ¿majan tsu ño'a injama'pa semoen'su? ¿Majan tsu ño'aña cuintsu tise na'su tisema in'jamba mandaye poiyi'cco semasundeccunga tise'pa anqque'suma aña'cho hora napi'ninda cuintsu afeye? ");
INSERT INTO conNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nane avujatssiya tsu tsa semoen'su, tise na'su toequi jisi na'su mandaqquia'caen tson'da. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nane ñoa'me gi su: Na'su mandaqquia'caen tsonsi attepa tsu pa'cco tisu an'bian'choma tsanga afeya cuintsu coiraye. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tsa'ma tsa semoen'su ño'ambi'ta tise na'su uta jiya'bi qquen tsu in'jan. Nane na'su uta jiya'bi qquen in'jamba ");
INSERT INTO conNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","semasundeccuma ma'ppipa ccusipasundeccui'ccu tsu fae'ngae amba cu'i. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tsa'caen tson'jemba tise in'jambi'te tsu tise na'su condambe'yi jiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jipa iyicca'yepa quia'me tsa semoen'suma ma'ppiya. Ma'ppipa tsu tisema tsangae catiya cuintsu ño'ame attiamba afopoensundeccui'ccu fae'ngae vanañe. Tseni tsu i'na'faya. Ñoa'me ttun'dundu'je'e iyicca'yepa i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chigama na'sian'cho aindeccuve daye tson'jen'da tsu ñotsse in'jamba ronda'jeya'cho. Diez pushesundeccu, casara'choma shondosundeccu, tise'pa rampariama isupa pusheya'cho tsandiema cachuiccoye ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco pushesundeccu injama'pa'fa tsu. Faesu cinco sumbi'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Injamambindeccu tise'pa rampariama anga'ma setsaenqque'su aseite botiyama anga'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tsa'ma cca'i injama'pandeqquiaja rampariama setsaenqque'su aseite botiyama'qque anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsonsi pusheya'cho tsandie uta jimbisi poiyi'cco diez shondo'su pushesundeccu anae'supa ana'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ana'jensi ñoa'me enttinge cose cca'ija fundo: “¡Pusheya'cho tsandie tsu jiña! Japa cachui'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Qquen pañamba pushesundeccu qquendyapa tise'pa rampariama setsaemba ñoña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Injamambindeccuja injama'pandeqquiama iñajan'fa: “Ingi ramparia tsu paji. Chigáne que'i aseitema inginga afe'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tsa'ma “Me'i” qquen tsu su'fa. “Que'inga afe'nijan ni ingine ni que'ine tsu napiya'bi. Bove ñotssi tsu chavaensundeccuni japa tisumbe chava'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Qquen susi cinco injamambindeccu chavaensundeccuni ja'fa. Tsa'ma tise'pa chava'su ja'ninda pusheya'cho tsandie ji. Jisi cinco tayo ñoña'cho pushesundeccu tisema cachuipa shondoye ca'ni'fa. Casara'jeccuni poiyi'cco ca'nisi sombo'ttima picco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tayo picco'fasi chava'su jasundeccuja jipa su'fa: “¡Na'su, na'su, sombo'ttima fettaja!” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tsa'ma na'su pañamba su: “Ñoa'me gi ñajan que'ima atesumbi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Qquen condasepa Jesús su: —Tsa'caeñi qui minga'ni na'su jiya'chove ni maqui a'ta jiya'chove'qque atesu'fambi. Atesumbipa ñotsse camba tise jiya'chove ronda'je'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Toya'caen Chigama na'sian'cho a'ive daye ronda'je'choja qquen na'su tise shondosundeccuma mandasi ron'daqquia'can tsu. Tsa na'su biani'su andenga jaye tson'jemba tisema shondosundeccuma ttu'se. Ttu'sepa ji'fasi tise an'bian'choma tsendeccunga afe cuintsu coira'je'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Fa'enga tsu cinco mil corifin'dive afe tise ccase jiya'ngae an'biañe. Faesunga dos milve afe. Faesunga milve afe. Poiyi'cconga tsu tise'pa osha'ccoeyi afe. Pa'ccoma afepa sombopa ja. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco mil corifin'dive isu'suja tse'faei'ccuyi isu'cho corifin'di'ccu chavapa chavaemba faesu cinco milve tsu gana. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Toya'caen dos milve isu'suja tise isu'cho corifin'di'ccu faesu dos milve tsu gana. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tsa'ma milve isu'suja japa andema changoemba na'sumbe corifin'dima a'tu. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bo'tssingae na'su toequi jipa coirasundeccuma iñajan tise afe'choma cuintsu toyaquian'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cinco mil corifin'dive isu'suja tsama afepa tise faesu cinco milve gana'choma'qque afe. Afepa su: “Ñama in'jamba cinco mil corifin'dive qui afe. Que canjan. Tsai'ccu gi faesu cinco milve gana.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na'su pañamba su: “Ñotsse qui tson. Queja ñotssia shondo'susi gi dyombi'tsse quenga osha'cho jongoesuma afeye osha. Re'riccoi'ccu ñotsse tsonsi gi quenga ti'tsse'tssiama afeya que coiraye. Jipa ñai'ccu fae'ngae avujatssija.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Omboe tsu dos milve isu'suja jipa su: “Na'su, ñama in'jamba dos milve qui afe. Que canjan. Tsai'ccu gi faesu dos milve gana.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na'su pañamba su: “Ñotsse qui tson. Queja ñotssia shondo'susi gi dyombi'tsse quenga osha'cho jongoesuma afeye osha. Re'riccoi'ccu ñotsse tsonsi gi quenga ti'tsse'tssiama afeya que coiraye. Jipa ñai'ccu avujatssija.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tsambe omboe milve isu'suja jipa su: “Na'su, queja dyo'tssia a'i. Jombi'ma qui tai'je. Choma gaiñambe'yi qui isu'je. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsa'cansi gi ñajan quema dyopa japa que corifin'dima andenga a'tu. Que canjan, va'tti tsu quembeja.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Qquen susi na'su iyicca'yepa su: “Noe'supa ega shondo'su qui. Ñajan jombi'ma tai'su, gaiñambe'yi isu'su qquen qui su. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tsa'caenda ¿micomba qui ña corifin'dima banconga ppiñambi ña jipa ñambema isupa corifin'di gana'choma'qque isuye?” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Qquen supa cca'i tse'tti ccutsu'chondeccuma su: “Tsambe mil corifin'dima itsapa diez milve an'bian'sunga afeja. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nane poiyi'cco majan an'bian'da ti'tsse tsu isu'faya injantsse an'biañe. Tsa'ma majan mechoan'da tise re'riccoama'qque tsu tisema itsaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Toya'caen tsa barembi'choa shondo'sumajan tsoteni sintssianga ttova moen'faja. Tseni tsu i'naña. Nane ñoa'me ttun'dundu'je'e iyicca'yepa tsu i'naña.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús ti'tsse atesiamba su: —Sefaccone Ji'cho A'i na'suve dapa tise sefacconi'su shondosundeccui'ccu jipa tise ñotssia dyaipa'chonga tsu dyaiya. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsanga dyaisi poi ande'su aindeccu tisenga ccutsu'faya. Poiyi'cco aindeccu tisenga ccutsu'fasi tsu tise'pama attufaeña. Nane coira'suja ovejaveyi chivoveyi attufaenqquia'caen tsu ");
INSERT INTO conNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","tise in'jan'cho a'ima ovejama'caen tise tansinfanga ccutsiaña. In'jambi'chondeqquiama chivoma'caen tsu tise pavefanga ccutsiaña. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsa'caen attufaemba na'su tsu tise tansinfani ccutsu'chondeccuma suya: “Ña Yaya tsu que'inga ñotsse tson. Ji'faja. Jipa Tise que'imbe ñoña'choma isu'faja. Nane andeve agattointene que'i Tise aindeccuve daya'chove in'jamba ñoña'choma jipa isu'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ña qquipoe'susi qui ñanga añe afe'fa. Tsaqquie'susi qui ñanga cui'ña'fa. Antiame mechosi qui ñama ansundiamba tsa'oma afe'fa ña anañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sarupave mechosi qui ñanga ondiqquian'fa. Pajisi qui ñama coirapa se'je'fa. Ñama indipa picco'je'ttinga piccosi qui dyombi'tsse ñama can'su ji'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Qquen susi ño'andeccu tsu su'faya: “Na'su, ¿minga'ni gi quema attepa qquipoe'susi o'fiamba, tsaqquie'susi cui'ña'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Minga'ni qui antiame meccoa jisi gi quema ansundian? ¿Minga'ni qui sarupave mechosi gi attepa ondiqquian'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Minga'ni qui pajisi, tsambi'ta piccoyesi gi attepa quema can'su ji'fa?” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Qquen iñajampañasi na'su tsu suya: “Ñoa'me gi su: Osha'cho jongoesuve qui va ñame in'jamba utu'ccoandeqquianga ñotsse tson'da qui ñanga'qque tson.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tsomba tsu na'suja tise pavefani ccutsu'chondeccuma suya: “Ña'ñe joqquitssipa si'nge anchanda'je'chonga tsangae ja'faja. Cocoya na'sune tisema shondosundeccune'qque tsu si'nge anchanda'je'chove tayo ñoña. Tsama Chiga que'ima'qque chi'gasi tseni japa tsangae can'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ñajan qquipoe'susi qui aña'choma se'pi'fa. Tsaqquie'susi qui ñanga cui'ña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Antian mechosi qui tsa'o sombo'ttima picco ña ca'nisa'ne. Sarupave mechosi qui ondiccu'jema afe'fambi. Pajipa, tsambi'ta picco'je'ttini can'jensi qui ñama chi'gapa coira'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Qquen susi pañamba su'faya: “Na'su, ¿minga'ni qui que'ja qquipoe'su, tsaqquie'su, ni antian mechopa, ni sarupave mechopa ni pajipa ni picco'je'ttini can'jensi attepa gi quema fuite'fambi?” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Qquen iñajampaña'fasi Na'su tise'pama suya: “Que'i va ñame in'jamba utu'ccoandeqquianga jongoesuve fuitembi'ta qui ñama'qque fuite'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na'su tsa'caen susi tsendeccuja tsangae vanaña'chonga ja'faya. Tsa'ma ño'andeccuja tsangae canseya'chonga ja'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús pa'cco tsesu atesian'choma nanimba tisema shondosundeccuma su: ");
INSERT INTO conNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Que'i atesuqquia'caen dos a'ta tsu shaca Chiga panshaensi injienge'cho fiestama panshaeñe. Fiestama panshaen'jen'qui aindeccuja Sefaccone Ji'cho A'ima indipa afe'faya avuja'cconga otipa fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tsa'caen Jesús su'je'qui tsu cca'ttinga Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu, israe'su coenzandeccui'ccu fae'ngae bo'fa. Ti'tsse'tssia Chigama afa'su na'su, Caifás tsaoni bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na'su tsaofa'su atandundunga bopa ma'caen a'tutsse Jesúsma indipa fi'ttiya'chove condasecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Condaseccopa su'fa: —Fiestama panshaen'jenquita tsu tisema indiye ega. Panshaen a'i bopa qquejian'fasa'ne indimbe'yi ron'daya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betaniani japa na congomba pajipa ccusha'cho Simón tsaoni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tse'ttini can'jen'ni pushesu tisenga catsepa ñotssia arabastro patu botiyama i, ñome'ba caro jincho botiyama. Jesúsja an'jen'cho mesa jin'tti piyive ccui'ni pushesuja catsepa botiyama fettapa ñome'bama Jesús tsovenga fiña onjoen. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tsa'caen onjoensi Jesúsma shondosundeccu attepa iyicca'yepa qquen suye ashaen'fa: —¿Micomba tsu ñome'bama tsa'caen aqquia cati? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nane ñome'bama chavaen'choecan'da tsain'bio corifin'dima isupa va'chandeccunga afeya'an. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Qquen asi'ttaen'jen'fasi Jesús atesupa tise'pama su: —¿Jongoesie qui va pushesuma noñangian'fa? Ñoa'me ñotsse tsu tiseja ñama tson. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tsangae tsu va'chandeccuja que'i'ccu can'jen'faya. Tsa'ma ñajan tsangae que'i'ccu can'jeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nane va pushesu ña ai'voma ñome'bai'ccu onjoemba ñama a'tuya'chone tsu ña ai'voma ñoña. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ñoa'me gi su: Poi ande'ye mani va ñotsse condase'choma condase'ta va pushesu tson'choma'qque tsu condase'faya. Tisema injan'jeñe tsu condase'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tsonsi fa'e Jesúsma doce shondosundeccu'su, tsa Judas Iscariote qquen inisecho'cho, ");
INSERT INTO conNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Chigama afa'su nasundeccunga japa su: —Ña Jesúsma que'i indiye afe'nijan ¿mi'getsse qui ñanga afepoeña? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Qquen susi treinta totoa cori corifin'dima agattopa afepoen'fa. Judas tsama isupa tse'faei'ccuyi tta'tta maqui osha'ta Jesúsma tise'panga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pan cupana'cco mechoa fiestama ashaen'jen'qui Jesúsma shondosundeccu tisenga jipa iñajampaña'fa: —¿Mani qui in'jan ingi japa Chiga panshaen'cho injienge'cho fiestane aña'choma sho'ccoen'faye que añe? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Qquen iñajampañasi tsu su: —Jerusaléni ca'nimba ingi in'jan'chonga japa su'faja: “Atesian'su tsu quema su: Tayo tsu ña hora napiji. Tsa'cansi gi ñama shondosundeccui'ccu Chiga panshaen'cho injienge'cho aña'choma que tsa'onga añe in'jan.” ");
INSERT INTO conNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesúsma shondosundeccu tise suqquia'caen japa tson'fa. Tsa'caen tsomba Chigama panshaen'cho aña'choma sho'ccoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tayo cose jisi Jesús poiyi'cco doce tisema shondosundeccu'qque añe piyiccui'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","An'jen'fa'ni Jesúsja su: —Ñoa'me gi su, fa'e que'i'suyi tsu ñama chi'gapa cca'indeccunga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Qquen susi tisema shondosundeccu ñombi'yepa faesu, faesu, tisema iñajampañañe ashaen'fa: —Na'su, ¿ñambi ti gi? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsonsi Jesúsja su: —Ñai'ccu fa'e apisho'ttongayi an'su tsu ñama afeye tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nane Chiga tevaen'jen suqquia'caen Sefaccone Ji'cho A'ima afesi indi'faya. Tsa'ma va'cha tsu tisema afe'su. Tise've tise mama isumbiecan'da tsu tisene bove ñotssiye'can. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsonsi Judas, Jesúsma afeya'choja su: —Atesian'su, ¿ñambi ti gi? Jesúsja su: —Ju, que qui. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Toya an'jen'fa'ni Jesús panma isupa Chigama ñotsse afa. Afa nanimba panma doñamba tisema shondosundeccunga afepa su: —Va panma isupa an'faja. Ña ai'vo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsomba tasama isupa ccase Chigama ñotsse afa. Afa nanimba tisema shondosundeccunga afepa su: —Va tasa'suma poiyi'cco cu'i'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Va cui'ccuja ña anjampa tsu. Chiga a'i'ccu fae'ngae injancco'fa'chove canjaen'cho anjampa tsu. Tsain'bio a'ine ña anjampa tssamba catiyeya tise'pa egae tsincon'choma joqquitssiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Que'ima gi su: Ja'ño va o'fa tsaja vinoma cu'ipa gi ccase vani cui'ya'bi. Ña yaya cuname ñoñasi que'i'ccu tseni cui'ya'gae gi catsa va ofa tsaja vinoma cui'ya'mbi. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Settapoen nanimba sombopa Olivo ccotta'cconga ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tseni japa Jesús tise'panga su: —Que'i poiyi'cco ja'ño cose qui injama'cho qque'faya. Ñame in'jamba indiyesa'ne qui dyopa ccuya'faya. Nane Chiga Tevaen'jen suqquia'caen tsu tsoña: “Coira'suma fi'ttisi oveja tsu shequequin ja'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tsa'ma ñajan ccase qquendyapa que'ima o'tie Galileani jaya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Qquen susi Pedroja su: —Poiyi'cco queve in'jan'chondeccu dyopa injama'cho qque'fa'ni'qque ñajan qqueya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tsa'ma Jesúsja su: —Ñoa'me gi su: Ja'ño cose toya arapa seyo'bi'te qui ñane tres se a'tieña. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsonsi Pedroja su: —Nane quei'ccu fae'ngae paya'ngae ñajan quene a'tieña'bi. Poiyi'cco Jesúsma shondosundeccu'qque tsa'caeñi quia'me su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsomba Jesús tisema shondosundeccui'ccu Getsemaní quini'ccosiccojini ja'fa. Japa tise'pama su: —Vani dyai'faja. Ña ti'tsse joccani japa Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Qquen supa Jesús Pedroma, Zebedeo dutssiyendeccuma'qque joccani anga. Joccani japa Jesús ñombi'yeye ashaen. Injama'cho tsosipie ñoquimbipa ");
INSERT INTO conNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tsendeccuma su: —Injama'cho tsosipie paqquia'caen gi asi'ttaemba ñombi'ye. Va'ttinga catiyepa anambe caña'jen'faja ña'caen. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Qquen supa ti'tsse jocca'tticcoe japa camba'jui'ccu andenga amppi ccuipa Chigama iñajan: —Ña Yaya, Chiga Quitsa, Que osha'ta va ña vanaña'choma joqquitssianjan. Tsa'ma joqquitssiañe in'jambi'ta que in'janqquia'caen tsonjan. Ña in'jan'chomajan me'i. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Qquen Chigama iñajamba toequi jipa tise tres shondosundeccu ana'jensi attepa Pedroma su: —¿Oshambi ti qui que'ija fae horaveyi'qque ña'caen anambe can'faye? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Anambe'yi Chigama iñajan'faja qquepa egae tsinconsa'ne. Nane que injama'cho tsosipie in'jan'ma qui ai'voni shacapa tsa'caen tsoñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tsomba ccase Jesús japa Chigama iñajan: —Ña Yaya, ña vanaña'choma joqquitssiañe oshambi'ta antteja cuin'qque ña vanañe. Que in'janqquia'caen tsonjan. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iñajamba toequi ji'ni'qque toyayi ana'jen'fa. Tise'pa tso'feja anae'sui'ccuyipa caña'jeñe oshambipa ana'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ana'jen'fasi attepa tise'pama catipa ccase Chigama iñajañe ja. Ccase japa toesuveyi iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iñajan nanimba toequi tisema shondosundeccunga jipa su: —¿Toya ti qui anambani ccui'fa? ¿Toya ti qui ñofa'je'fa? Que can'faja. Tayo tsu hora napi. Ja'ño tsu Sefaccone Ji'cho A'ima egae tsinconsundeccunga chi'gapa afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jangi'faja. Jinge jaye. ¡Ñama chi'gapa afe'su tayo tsu ji! ");
INSERT INTO conNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús toya afa'je'ni Judas, fa'e Jesúsma doce shondosundeccu'su, ji. Tsain'bio a'i tisei'ccu fae'ngae ji'fa. Chigama afa'su nasundeccu, israe'su coenzandeccu tise'pama manda moen'fasi matichi'ccu, quini'ccoi'ccu ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Toya napimbe'yi Jesúsma afe'su Judas cca'indeccunga su: —Majama ña mocha'nijan tsaya tsu. Tsama qui indi'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsa'caen toeni supa Judas jipa tse'faei'ccuyi Jesúsnga catsepa su: —¿Vani ti qui can'jen, na'su? Qquen supa Jesúsma mocha. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mochasi Jesús tisema su: —In'jan'cho, que jongoesuve tsoñe in'jamba ji'ta tsa'caen tsonjan. Qquen susi poiyi'cco a'i Jesúsnga catsepa qquitssa indi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tse'faei'ccuyi fa'e Jesúsma shondosundeccu'su tisu matichima qquitsa somboemba Chigama afa'su joccapitssia na'sumbe sema'suma atui. Atuipa tise tsonsinama qquerui ttova. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsonsinama qquerui ttovasi Jesúsja su: —Que matichima toengayi ppiñajan. Poiyi'cco majan matichi'ccu iyicco'ta matichi'ccu tsu pa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Atesu'fambi ti qui ña in'jan'da gi ña Yayama iñajansi Tise tsu cuarenta milma ti'tsse Tise'be sefacconi'su shondo'su sundarondeccuma moeña ñama fuite'faye? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tsa'ma tsendeccu tsa'caen ejeca'ni'fa'nijan ¿ma'caen tsu Chiga Tevaen'jen suqquia'caen tson'faya? Voe tsoña'chone tayo tsu conda'a. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsomba Jesús poiyi'cco a'ima su: —¿Ñanda ti gi fi'ttipa ccana'su? ¿Tsa'cansi ti qui matichi, quini'ccoi'ccu ñama indiye ji'fa? Nane poi a'ta gi Chiga ettinga dyaipa atesian'jen'ma qui ñama indi'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tsa'ma tayopi'su Chiga Aya'fama afasundeccu ñama fi'ttiya'chone tevaensi ja'ño tsu tsa'caen tsoña'cho ñoa'me su'cho qquen canjaeñe. Qquen su'je'ni poiyi'cco Jesúsma shondosundeccu tisuveyi tisema catipa ccuya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsomba Jesúsma indisundeccu joccapitssia Chigama afa'su na'su Caifásnga anga'fa. Chiga manda'choma atesiansundeccu, israe'su coenzandeccu'qque tayo Caifás tsaoni bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesúsma anga ji'fa'ni Pedro'qque biaccayi jiña. Jipa Caifás tsa'o atandundunga ca'nimba sundarondeccui'ccu dyai ma'caen tson'jen'chove atteye. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tsonsi Chigama afa'su nasundeccu, israe'su coenzandeccu bo'fa'cho'qque ma'caen Jesúsma afopoeña'chove ttatta'fa cuintsu Jesúsja tsesuma shacaen qquen supa tisema fi'ttiye mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tsain'bio camba afopoensundeccu afa'je'fa'ni'qque toya tsu nasundeccuja ma'caen fi'ttiya'chove atte'fambi. Tsa'ma jai'ngae dos afaccopa fae'ngatsse afopoen'fa ");
INSERT INTO conNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","qquen supa: —Va a'ija su: “Ñajan Chiga ettima osiamba tres a'tangae ccase jangi ccutsiaña.” ");
INSERT INTO conNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Qquen su'fasi joccapitssia Chigama afa'su na'su jangi ccutsupa Jesúsma iñajampaña: ¿Tansintsse ti va aindeccuja quene su'fa? ¿Tsa'caen ti qui su? ¿Afaya'bi ti qui? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsa'ma tsa'caen iñajampaña'ni'qque Jesúsja afambi. Afambisi joccapitssia Chigama afa'su na'suja su: —Cansia Chiga caña'jen'ni gi quema manda: Inginga tansintsse condaja: ¿Queta ti qui Cristo? ¿Chiga Dutssi'ye ti qui? ");
INSERT INTO conNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsja su: —Ju, que suqquia'can gi. Nane que'i poiyi'cconga gi conda: Jai'ngae qui Sefaccone Ji'cho A'ima Chigai'ccu fae'ngae dyai'choma atte'faya. Osha'chove tson'su Chigambe tansinfanga dyaipa fae'ngae mandaya. Tise sefacconi'su unjimba'cco'ye jiña'choma qui atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesús tsa'caen susi joccapitssia Chigama afa'su na'su iyicca'yepa tsama canjaeñe in'jamba tisu ondiccu'jema chi'ttapa su: —¡Chigama tsu afase'je! ¿Micomba gi camba afasundeccuveyi ti'tsse ronda'je'fa? Tayo gi paña'fa tise Chigama afase'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mingae gi tson'faya? Tsonsi poiyi'cco tsu su'fa: —Tisema fi'ttiya'chove tsu shacaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Qquen supa tise tsovejunga bo'chiccoen'fa. Tivei'ccu tisema tssai'fa. Cca'indeccuja tivei'ccu tise tsovejuma a'tutsse tssaipa ");
INSERT INTO conNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","su'fa: —Ja'ño, Cristo, que qui ñoa'me Chiga Aya'fama afa'suta injama'choi'ccu in'jamba condaja majan tsu quemajan tssai. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsa'caen Jesúsma iñajampaña'jen'fa'ni Pedro tsotefa'su atandunduni dyai. Dyaisi sema'su pushesu tisenga catsepa su: —Que'qque tsa Galilea'su a'i, tsa Jesúsi'ccu jacan'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsa'ma poiyi'cco paña'je'ni Pedro tsama a'tien qquen supa: —Atesumbi gi jongoesuma qui su. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsomba sombo'ttinga sombo jisi faesu sema'su pushesu tisema attepa tseni can'jensundeccunga su: —Va tsandieja Jesús Nasarenoi'ccu jacan'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Qquen susi Pedro quia'me afapa ccase Jesúsma a'tien: —Atesumbi gi tsa a'ima. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Omboe cca'i tse'tti ccutsusundeccu Pedronga catsepa su'fa: —Ñoa'me qui tsa'suyi. Que'qque tsendeqquia'caen afa'jesi gi tsa'caen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Qquen susi Pedro Chigama iñajan tise tansintsse su'choma canjaeñe. Nane afopoen'ninda Chiga tisema egae tsoña'chove ttu'se. Tsa'caen ttu'sepa tsu su: —Atesumbi gi tsa a'ima. Tse'faei'ccuyi arapa gayo se'yo. ");
INSERT INTO conNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Se'yosi Pedroja Jesús su'choma in'jan: “Toya arapa seyo'jembi'te qui ñane tres se a'tieña.” Qquen su'choma in'jamba sombopa quia'me i'na. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A'tasi toya ñoa'me sinte'yi poiyi'cco Chigama afa'su nasundeccu, israe'su coenzandeccui'ccu bopa fae'ngae su'fa Jesúsma fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Fi'ttiye in'jamba candenai'ccu Jesúsma tandamba governaror Pilatonga anga'fa. Angapa Pilatonga afe'fa cuintsu fi'ttiye mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesúsma chi'gapa afe'su, Jesúsma fi'ttiye tson'jen'choma attepa tisu injama'choni se'pi. Se'pipa ñombi'yepa treinta totoa cori corifin'dima afepoen'choma toequi Chigama afa'su nasundeccunga, israe'su coenzandeccunga ");
INSERT INTO conNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","angapa afepa su: —Egae tsincombi'choama fi'ttiye afepa gi egae tsincon. Tsa'ma Chigama afa'su nasundeccuja su'fa: —¿Jongoesie qui ingingata ji? Que tsa'caen tson'choja que in'jan'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Qquen susi Judas corifin'dima Chiga etti'su ppappacconga ttova shequian. Ttova shequiamba somboin ja. Japa tisu tsifoma tandamba amppi dusepa pa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Judas jasi Chigama afa'su nasundeccu ttova cati'cho corifin'dima taipa condasecco'fa: —Va corifin'di a'ima fi'ttiye afepoen'cho tsu. Tsa'caen anjampai'ccu dañonge'choma Chiga manda'cho tsu se'pi Chiga etti'su corifin'dima ppiña'jen'chonga ppiñañe. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsa'caen condaseccopa faesu a'ta in'jamba apive ñoña'sumbe andema chava'fa. Tseni israembindeqquia pa'nijan atu'jeya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsa'caen chavasi toya ja'ño pán tsu tsa andema “Anjampa ande” qquen su'cho'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nane tsa'caen tsomba tsu tayopi'su Chigama afa'su Jeremías suqquia'caen tson'fa: “Israendeccu in'jamba tisene afepoen'cho treinta totoa cori corifin'di tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na'su Chiga ñama mandaqquia'caen tise'paja tsa corifin'di'ccu apive ñoña'su andema chava'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesúsma governarornga anga'fasi Pilatoja Jesúsma iñajampaña: —¿Que ti qui israendeccu na'su? Jesúsja su: —Que suqquia'can tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tsa'ma Chigama afa'su nasundeccu, israe'su coenzandeccu'qque Jesúsja egae tsincon qquen afa'je'fa'ni'qque Jesúsja afambi. Afambisi ");
INSERT INTO conNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatoja tisema iñajampaña: —¿Pañambi ti qui tise'pa queja osha'cho egae tsincon qquen afa'je'choma? ");
INSERT INTO conNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesúsja tisema da'ñomba afa'je'fa'ni'qque afambisi governaror asi'ttaemba can'boen. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Poi canqque'fa fiestama panshaen'jenqui governarorja fa'e indiye'choma ccupaye atesu. Majama aindeccu bo'fa'cho ccupaye in'jan'nijan tsama ccupaye atesu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsequi a'ta indiyesundeccu'su, fa'e, Barrabás, qquen inisecho'cho, can'jensi poiyi'cco a'i tise egae tsincon'choma atesu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsa'camba ccupaye iñajañe bo'fasi Pilato tise'pama iñajampaña: —¿Majame qui in'jan'fa ña ccupaye? ¿Barrabásma ccupayeta ti qui in'jan'fa? Tsambi'ta ¿Jesús, tsa Chigambe Cristo qquen su'choma ccupaye ti qui in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nane israe'su nasundeccu injama'choni Jesúsma se'pipa afe'fa qquen in'jamba Pilatoja tsa'caen aindeccunga Jesúsma ccupaye su. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsa'ma Pilato tsa'caen tise dyaipa'chonga dyaipa aindeccuma afa'je'ni tise pusheja qquen su'choma tisenga moen: “Va Jesús egae tsincombi'choa tsu. Tisene gi ja'ño cose dyo'oe ayo'o. Tisema egae tsonjama.” ");
INSERT INTO conNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilatoja aindeccu in'jan'chove ronda'je'ni Chigama afa'su nasundeccu, israe'su coenzandeccu'qque aindeccuma in'jaen'fa cuintsu Barrabásma ccupaye afapa Jesúsmajan fi'ttiye afa'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsonsi governaror ccase aindeccuma iñajampaña: —Ñanga condaja. ¿Majame qui in'jan'fa va dos indiye'suma ña ccupaye? Iñajampañasi tsu su'fa: —¡Barrabásma ccupaja! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Qquen susi Pilatoja iñajampaña: —Barrabásma ccupa'ta ¿mingae gi Jesúsmajan tsoña? Tsaja Chigambe Cristo qquen tsu poiyi'cco su'fa. Tsa'ma aindeccuja su'fa: —¡Avuja'cconga fi'ttija! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoja su: —¿Jongoesune gi tisemajan fi'ttiya? ¿Jongoesuma tsu egae tsincon? Qquen susi ti'tsse tsu fundondo'e afa'fa: —¡Avuja'cconga fi'ttija! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsa'caen fundo'je'fasi Pilatoja ti'tsse afa'a'qque patsuya'bi qquen tsu in'jan. Tsa'caen in'jamba tsu ziya aindeccu panshaen qquejian'fasa'ne. Ziyapa tsa'ccuma iñajamba isupa poiyi'cco aindeccu caña'jen'ni tisu tivema otishipa su: —In'jambi gi mandaye va a'ima fi'ttiye. Tsa'ma que'i in'jamba manda'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsa'caen canjaemba susi aindeccuja su'fa: —¡Ingi tisema fi'ttiye in'jamba fi'tti'chone inginga tsu shacave antte! ¡Ingi dushundeccunga'qque tsu shacave antte! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aindeccu tsa'caen su'fasi Pilatoja Barrabásma ccupapa Jesúsma ma'ppiye manda. Ma'ppi'fasi Pilatoja Jesúsma sundaronga afe cuintsu avuja'cconga oti'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsonsi governarormbe sundarondeccu Jesúsma governaror etti'su cuartonga anga'fa. Angapa poiyi'cco faenga'su sundarondeccuma ttu'sesi bopa Jesúsma shoquendi'e ttu ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ttupa tise ondiccu'jema oshichhaemba cu'a sarupai'ccu tise opipa'choma na'su oppoen'jenqquia'caen oppoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Boicco nojama'qque otifaccuve ugapa tisema otifaen'fa. Caofa'ccoma'qque na'su quini'cco'pa'ca'en tise tivenga indian'fa. Tsomba afase co'feye ashaemba tisenga ccarupa dyaipa su'fa: —¡Ti'tsse canseja israe'su na'su! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Qquen supa tisenga attupoen'fa. Tisenga afe'cho caofa'ccoma'qque itsapa tsai'ccu tise tsovema ochhachha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsa'caen tisema afase co'fepa cu'a sarupama oppoen'choma oshichhaemba tise ondiccu'jema ccase tisenga ondiqquian'fa. Ondiqquiamba tisema anga'fa avuja'cconga otiye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sombopa fi'ttiye jayipa Cirene'su a'ima cachui'fa. Tsaja Simón tsu. Tisema cachuipa manda Jesús avuja'ccoma opipa angaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tsonsi japa ccotta'cconga napi'fa. Tsa ccotta'cco Gólgota qquen inisecho'cho. Tsove tsu'tta ccotta'cco qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tseni napipa Jesúsnga vinoma cui'ñañe afe'fa. Tsa vinojan asingu'cho tsa'ccui'ccu eyeppu'cho tsu, ai'vo injiengembi'e daqque'su. Tsa'ma Jesús cuicamba vinoma chi'ga. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesúsma avuja'cconga oti ccutsiamba sundarondeccu tise ondiccu'je'cho sarupama isupa attufaen'fa. Gana qquen co'fepa isu'fa. Nane tayopi'su Chiga Aya'fama afa'su suqquia'caen tsu tson'fa: “Gana qquen co'fepa tsu ña ondiccu'je'cho sarupama attufaemba isu'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsomba tse'i sundarondeccu tse'tti dyaipa caña'jen'fa cca'i jipa tisema andiansa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús tsove omba'ttinga tise egae tsincon'chove su'cho tevaen'jema avuja'cconga oti'fa. Qquen tsu tevaen'fa: Vaja Jesús, israendeccu na'su. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Toya'caen dos ccanambandeccuma'qque Jesúsi'ccu fae'ngae oti'fa. Fa'ema avuja'cconga otipa Jesús tansinfanga ccutsian'fa. Faesumajan Jesús pavefanga ccutsian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aindeccu majan tsangae panshanjimba Jesúsma camba tise tsovema fenonomba afase'fa ");
INSERT INTO conNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","qquen supa: —¡Queja Chiga ettima osaemba tres a'tangae ccase ñoñañe qquen su'chota tisuma ccushaenjan! ¡Que qui ñoa'me Chiga Dutssi'yeta avuja'cco'ye andeja! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Toya'caen Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu, israe'su coenzandeccu'qque tsa'caen tisema afasepa su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Cca'indeccuma ccushaemba tisumajan ccushaeñe oshambi. Tiseja israe'su na'su qquen tsu su. ¡Tise ja'ño avuja'cco'ye andesi gi tise've in'jamba paña'faya! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tiseja Chigave in'jan qquen tsu su. Tsa'cansi Chiga tisema ñoa'me in'jan'da cuintsu Chigaja tisema ja'ño ccushaenjan. Nane tayo tsu tiseja su: “Ña gi Chiga Dutssi'ye.” ");
INSERT INTO conNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nasundeccu qquen afasesi fae'ngae Jesúsi'ccu otiye'chondeccu'qque tsa'caen tisema afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Enttinge a'ta pa'cco ande'ye tsu sintsse coseqquia'ca'en da. Sintsse dapa ondusesi ccase coe'jeja de. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tayo ondusesi Jesúsja fundondo'e afapa su: —Elí, Elí, ¿lema sabactani? —qquen tsu su: Ña Chiga, ña Chiga, ¿jongoesie qui ñama cati'je? ");
INSERT INTO conNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Majan tse'tti ccutsusundeccu tise su'choma pañamba su'fa: —Tiseja Chiga Aya'fama afa'su Elíasve tsu ttuse'je. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tse'faei'ccuyi fa'e tse'tti'su buttopa chanchanchan'choa'nga inzatssia vinoma tssi'poemba canttini'cconga ejiamba Jesús aya'fanga canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tsa'ma cca'indeccuja su'fa: —Cuintsu antteja. Jinge ron'dapa atteye ma'caen Elías tisema ccushaen'me'se. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsonsi Jesús ccase fundondo'e afapa pa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tise pasi tse'faei'ccuyi Chiga etti'su Chigai'ccu cachuicco'je'cho cuartoma picco'je'cho sarupa'qque chittain ja. Sefane chitta ashaemba andepaningae chittain ja. Ande'qque oyasi patuvo'cho'qque do'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A'i atu'tti'qque fettayesi majan Chigave in'jamba pa'chondeccumbe ai'voja ccase qquendyapa jangi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tsendeccu Jesús ccase qquendyasi atu'tti'ye sombopa Chiga in'jan'cho Jerusalén canqqueni japa tsain'bio a'inga attian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tsa'caen tsonsi sundaro capitán, faesu Jesúsma caña'jen'cho sundarondeccu'qque osha'choma atte'fa. Ande oya'je'choma'qque in'jamba dyo'fa. Dyopa su'fa: —¡Va tsandieja ñoa'me Chiga Dutssi'ye tsu! ");
INSERT INTO conNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Toya'caen tsain'bio pushesundeccu'qque tseni can'jemba biane camboen'jen'fa. Nane Galileane Jesúsi'ccu jacamba tisema fuitecansundeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tise'pa'su tsu María Magdalena; faesu María, tsa Santiago, José chan; toya'caen Zebedeo dutssiyendeccumbe mama'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tayo cose jisi Arimatea canqque'su a'i, José, ji. Tiseja ricopa osha'choma an'biamba toya'caen Jesúsve'qque in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jipa Pilatonga japa Jesús ai'vove iñajan. Iñajansi Pilato manda cuintsu tisenga afe'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joséja Jesús ai'voma isupa ñotssia totoa sarupanga findi. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Findipa tisumbe ñoña'cho cuna fattocco chango atu'ttinga ccuiña. Ccuiñamba rande patuma mutsinoemba sombo'ttima picco. Piccopa jasi ");
INSERT INTO conNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena faesu Maríai'ccu atu'tti isevetsse dyaipa camboen'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ccaqui a'ta, Chiga panshaen'cho injienge'cho ñoña'cho a'ta pasasi, Chigama afa'su nasundeccu, fariseondeccu'qque Pilatonga japa ");
INSERT INTO conNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","su'fa: —Na'su, tsa afopoen'su toya canseite tsu su: “Papa tres a'tangae gi ccase qquendyaya.” ");
INSERT INTO conNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ya'caen su'chosi gi in'jan'fa: Mandaja cuintsu atu'ttima fettasa'ne setsaenqque'sui'ccu setsaen'faye. Tsomba tres a'tave coira'faye. Tsa'caen coirambi'nijan tisema shondosundeccu jipa tsu ai'voma cca'namba tiseja ccase qquendya qquen a'inga condase'faya. Tsa'caen afopoen'da tayo'su afopoen'choma bove egae tsu afopoen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsa'caen su'fasi Pilatoja su: —Que in'jan'ninda gi sundarondeccuma moeña. Japa tsendeccui'ccu ma'caen osha'ta atu'ttima ñoña'faja cca'i tisema somboensa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsa'caen mandasi japa setsaenqque'sui'ccu patuma setsaen ancaen'fa, patuma joqquitssiansa'ne. Sundaroma'qque ccutsian'fa cca'indeccu jipa cca'na'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sema'ma'qquia a'ta pasasi faesu avujaquive a'tasi coe'je tseyi deji'ni María Magdalena, faesu Maríai'ccu atu'ttima can'su ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jayi'ni tse'faei'ccuyi ande quia'me oya. Oyasi Chigama sefacconi'su shondo'su Chiga sefaccone andepa patuma mutsinoe joqquitssian. Joqquitssiamba tsanga dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsanda veyaenqquia'caen tiseja a'tatssia've chanjun. Tise ondiccu'je'qque chandisu'ccoa'caen tototssi. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Coira'su sundarondeccu'qque tisema attepa ttun'dundu'je'e dyopa paqquia'caen amppi ccui'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tsomba pushesundeccu catsesi Chigama sefacconi'su shondo'suja tise'pama su: —Dyombe can'faja. In'jan gi que'ija avuja'cconga fi'tti'fa'cho Jesúsve qui ttattacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tiseja vani can'jembi. Tise tayoe suqquia'caen ccase qquendya. Jipa tise ccui'ttima can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Can'gipa utatsseyi japa tisema shondosundeccunga conda'faja: “Tiseja papa tayo ccase qquendyapa que'ima o'tie tsu Galileani jaya. Tseni japa qui tisema atte'faya.” Tayo gi conda ña suya'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Qquen susi pushesundeccu utatsseyi atu'tti'ye sombopa dyopa ja'fa. Dyo'a'qque ñoa'me avujatsse Jesúsma shondosundeccunga condaye ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jayi'fasi tse'faei'ccuyi Jesús tise'pama cachuipa chigambian. Chigambiansi tisenga catsepa ccaru dyaipa tise tsu'ttema munsin indi'fa. Munsin indipa tisema in'jamba ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsonsi Jesús tise'panga su: —Dyombe can'faja. Japa ña faengasundeccunga conda'faja cuintsu Galileani ja'faye. Tseni japa tsu ñama atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pushesundeccu ja'je'ni atu'ttima coira'su sundarondeccu'su'qque canqqueni japa Chigama afa'su nasundeccunga conda'fa ma'caen da'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Conda'fasi Chigama afa'su nasundeccu, israe'su coenzandeccui'ccu asi'ttaemba condasecco'fa jongoe qquen suya'chove. Asi'ttaemba in'jan'fa. In'jamba sundarondeccunga tsain'bitssia corifin'dima afepa ");
INSERT INTO conNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","su'fa: —Qquen cca'indeccunga su'faja: “Enttinge cose ingi ana'jen'ni Jesúsma shondosundeccu jipa tise ai'voma cca'namba anga'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Qquen susi governaror paña'ninda gi tisema afaya que'ima noñangiansa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Qquen su'fasi sundarondeccu corifin'dima isupa tsendeccu mandaqquia'caen tsu su'fa. Tsa'caen su'fasi ja'ño a'ta pán tsu poi israendeccu tsa'caen pañamba in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús mandaqquia'caen tisema once shondosundeccu Galileani ja'fa. Jesús su'cho ccotta'cconga japa ");
INSERT INTO conNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tse'ttinga tisema cachui'fa. Cachuipa tisema in'jamba ñotsse afa'fa. Tsa'ma majan tisema attepa injama'cho shacasi ñoa'me Jesús tsu qquen in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tsonsi Jesús tise'panga catsepa su: —Chiga Quitsa tsu ñanga antte pa'cco Chiga sefacconima, pa'cco andenima'qque mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsa'cansi que'i poi ande'su aindeccunga japa tise'pama in'jaen'faja cuintsu ñama shondosundeccuve da'faye. Nane Chiga Quitsa, Tise Dutssi'ye, Chiga Qquendya'pama'qque in'jan'fasi tsu tise'pama feti'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Toya'caen pa'cco ña que'ima mandaqquia'caen qui tise'pama'qque atesiaña'cho cuintsu tsa'caen pañamba tson'faye. Tsa'caen in'jaemba ñotsse in'jan'faja: Tsangae osefaeña'gae gi que'i'ccu can'jeña. Tsangaeyi.");
INSERT INTO conNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Qquen tsu Jesucristone ñotsse condase'choja ashaen. Tiseja Chiga Dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tayopi Chiga Aya'fama afa'su Isaíasja Chiga su'choma qquen tevaen: ¡Que canjan! Quema o'tie gi moeña ña mandasi afa'suma que jiya'chove ñoñañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A'i aya'fama qui paña'faya a'i menia'ñe qquen fundo'je'choma: “Na'su jiya'chove ñoña'faja. Tise tsaiquima tansianqquia'caen que'i injama'choma tansian'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan a'ima feti'su ji a'i menia. Jipa qquen candusian: —Majan ño'ame daye in'jamba tise in'jangae canse'choma catiye in'jan'da ñotssi tsu fetiyeye. Chiga tsu que'i egae tsincon'choma joqquitssiaña. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Poiyi'cco Judea ande'su a'i, Jerusalén canqque'su a'i'qque jiji'fa. Tise'pa egae canse'choma condase'fasi Juan Jordán na'enga tsendeccuma feti. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan ondiccu'jeja camello tosema otata'cho. Tise utuqui'faja ttono utuqui'fa. Tise anqque'suja ttombu, tsampi'su tuño cuñajun'cho'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan candusiamba su: —Ñama omboe tsu jiya ñama ti'tsse'tssiaja. Ñajan utu'ccoapa gi shaca tise sapatoma uga'choma ccupa'suve ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tsa'ccui'ccu gi que'ima feti'je. Tsa'ma tise jipa Chiga Qquendya'pai'ccu tsu que'ima fetiya. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tsonsi tse'i Jesúsja Galilea ande'su Nasaret canqquene ji. Jisi Juan Jesúsma feti Jordán na'enga. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesúsja na'eñe sombojipa sefacco fettaye'choma atte. Chiga Qquendya'pa ppuppuju'choa'caen tisenga andeji. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tsa'caen andeji'ni Jesús sefaccone afa'choma paña qquen su'choma: —Que qui Ña Dutssi'ye, Ña In'jan'cho. Quene gi avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tse'faei'ccuyi Chiga Qquendya'pa Jesúsma manda moen a'i menia. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesúsja cuarenta a'tave tseni can'jen. Tsenijan osha'cho ttesiaca'moa can'jen'fa. Tseni can'jensi cocoya na'su, Satana, jipa Jesúsma qqueña qquen tson. Tsa'ma Chiga sefacconi'su shondosundeccu Jesúsma coira'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ande na'su Herodes tayo Juanma indipa piccosi Jesús Galileani japa Chiga aindeccuve daya'chone ñotsse condase'choma candusiañe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesúsja su: —Tayo tsu napiji. Ti'tssecan tsu napiya Chiga aindeccuve daya'choe. Que'i in'janga canse'choma catipa ño'ame daye in'jan'faja. Tsa'caen in'jamba va ccushaya'chone ñotsse condase'choma in'jan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea mar otafa'ye jayipa Simón, tise quinshin Andrésma atte. Tsendeccuja avuve vachoye atesundeccupa vacho'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús tise'pama attepa su: —Ñai'ccu jipa jacan'faja. Ña gi tsoña que'imajan avuma ttuqquia'caen a'ima ttu'sesundeccuve. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Qquen susi tise'pa vacho'vama catipa Jesúsi'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ti'tsse joccani jayipa Santiago, Zebedeo dutssi'ye, tise quinshin Juanma'qque atte. Tsendeccuja shavoni dyaipa vacho'vama uga'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","U'gá dyai'fasi Jesúsja tsendeccuma'qque ttu'se. Tsonsi tise'pa yayama, semasundeccuma'qque shavonga catipa Jesúsi'ccu ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Napi'fa Capernaum canqqueni. Tsomba sema'ma'qquia a'ta Jesús Chiga manda'choma atesian'jen'ttinga ca'nimba atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesús atesian'jensi a'i pañamba can'boen'fa. Tevavaensundeqquia'cambipa na'sia'caen tsu atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsa'caen tson'jen'ni cocoya ca'ni'cho a'i atesian'jen'ttinga ca'ni. Ca'nimba fundo: ");
INSERT INTO conNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Mincoñe qui ingingata ji, Jesús Nasareno'su? ¿Ji ti qui ingima sefaeñe? Ñanda gi quema atesu. Queta qui Ño'a Chigani'su. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Qquen susi Jesús cocoyama iyu'upa su: —¡Ziyaja! ¡Joqquitssija va tsandie'ye! ");
INSERT INTO conNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsa'caen susi cocoyaja tsa a'ima pan'jaemba quia'me fundopa somboin ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Somboin jasi a'i pa'cho qquendyasi poiyi'cco a'i dyopa can'boen'fa. Tsomba tisupanaccu iñajampañacco'fa: —¿Jongoesu tsu vaja? ¿Jongoesu tsu va cuname atesian'jen'cho? Jovaja ti'tsse'tsse manda. Nane cocoyandeccuma'qque iyu'usi tisema paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tse'faei'ccuyi poiyi'cco tsa Galilea ande'su aindeccuja Jesúsne paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chiga manda'choma atesian'jen'ttie sombopa Simón, Andrés Jesúsi'ccu tisupa tsaoni jayi'fasi Santiago, Juan'qque jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tseni japa Simón chanccashema atte, ajepa pajipa ccui'choma. Tsonsi attepa Jesúsnga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pañamba Jesús paji'sunga catsepa tive'ye indipa jangian. Tse'faei'ccuyi aje chattian. Aje chattiansi tsa pushesuja poiyi'cconga cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Tayo sime, chiga amppisi, sema'ma'qquia a'ta pasasi poiyi'cco tsa canqque'su a'i tsa'o sombo'ttinga bo'fa. Pa'cco pajisundeccuma, cocoya ca'ni'chondeccuma'qque Jesúsnga i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I'fasi Jesús tsain'bitssia osha'choi'ccu pajisundeccuma ccusha'shaen. Tsain'bitssia cocoyama'qque joqquitssian. Tsa'caen ccusha'shaemba Jesúsja cocoya afaye se'pi, tisema atesuchosi. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tsomba a'taningae, toya sinttia'ni Jesús jangipa ccani ja, a'i menia, Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tisema attembe moemba, Simón, toya'caen tisei'ccu can'jensundeccu'qque, Jesúsve ttattacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ttattacamba attepa su'fa: —Poiyi'cco tsu queve ttattacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsa'ma Jesúsja su: —Jinge ccani jaye, faesu canqque, faesu canqquenga ñotssiave candusiañe. Tsa'caen in'jamba gi vani ji. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsa'caen supa pa'cco Galilea andenga jacan. Tsa'caen jacamba pa'cco Chiga manda'choma atesian'jen'ttinga japa candusian. Cocoyama'qque joqquitssian mañajan. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsa'caen tson'jen'ni fae tsandie, na congomba paji'cho, Jesúsnga catsepa ccarupa dyaipa su: —Que in'jan'da qui ñama ccushaeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsa'caen susi Jesús tisema mende'yepa tivei'ccu yasapa pporaemba su: —In'jan gi. Tayo qui ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesús tsa'caen susi tse'faei'ccuyi tise na giya'tsse dapa ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tse'i Jesús tisema qquen iyu'upa manda moen: ");
INSERT INTO conNTpo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Que canjan. Majangayi'qque condambeyi jaja Chigama afa'suni. Tseni japa tisuma tisenga canjaenjan. Canjaemba Moisés tayopi mandaqquia'caen ccusha'chone afeya'choma Chiganga afeja. Tsa'caen afeja cuintsu poiyi'cco a'i in'jan'faye que ccusha'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsa'ma tsa a'i ccushapa jayipa condasé ja. Poiyi'cconga condase ma'caen da'choma. Tsa'caen tsonsi Jesúsja canqquenga ca'niñe oshambi a'i panshaen tisema atteye in'jamba bo'fasa'ne. Tsa'ma ccafaeyi a'i menia jaca'ni'qque tseni poiyi'cco a'i bo'fa, tisema atteye. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsomba tse'i, boyi a'tangae, ccase Jesús Capernaumni ji. Jisi tse'tti'su a'i paña'fa Jesús tsaoni can'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pañamba tsain'bio a'i sombo'ttima'qque on'ba'e bo'fa. Tsa'caen bo'fasi Jesúsja Chiga Aya'fama atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tson'jen'ni ishopa paji'suma Jesúsnga i'fa. Cuatro a'i tsa paji'suma andú i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tsa'ma Jesúsnga catseye osha'fambi panshaen a'i bo'fasi. Catseye oshambipa tsa'o tansinfa'su ppappacconga ansundepa tsene fetta'fa Jesús ccutsu'cho tansintsse. Tsa'caen fettapa tsangaé a'i paji'choma tise ana'jen'chonga andian'fa Jesús ccutsu'ttinga. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús tsama attepa tise'pa in'jan'choma in'jamba ishopa paji'suma su: —Jaricho, que egae tsincon'choma tayo joqquitssian. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsa'ma majan Chiga manda'choma atesiansundeccu tse'tti dyaipa in'jan'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jongoesie tsu jova tsandieja ya'caenjan su? Egae tsu afa'je. ¿Majan tsu oshaya egae tsincon'choma joqquitssiañe'jan? Nane Na'su Chiga Quitsayi tsu oshaya.” ");
INSERT INTO conNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsa'ma Jesúsja tise'pa in'jan'choma atesupa su: —¿Jongoesie qui injama'choni tsa'caen in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tayo gi su: “Que egae tsincon'choma tayo joqquitssian.” ¿Bove aiye'pambi ti qquen suye: “Jangipa que ana'jen'choma isupa tsui jaja que tsaoni”? ");
INSERT INTO conNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tsa'ma Na'su Chigaja antte Sefaccone Ji'cho A'ija egae tsincon'choma'qque joqquitssiañe. Ñajan sefaccone jipa tsa'caen oshapa que'inga canjaeñe tson'jen. Qquen supa paji'suma su: ");
INSERT INTO conNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Quema gi su: Jangipa que ana'jen'choma isupa jaja que tsaoni. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tse'faei'ccuyi paji'suja jangipa tise ana'jen'choma isupa tse'ttie sombopa ja. Poiyi'cco a'i tsama atte'fa. Attepa can'boen ccutsupa Chigane ñotsse afa'fa qquen supa: —¿Minga'ni'qque atte'fambi gi qquia'ma? ");
INSERT INTO conNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsomba Jesús tsene sombopa ccase mar otafani ja. Tseni jasi poiyi'cco a'i tisenga bo'fa. Bosi Jesús tise'pama atesian. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Atesian nanimba govierno impuestoma isu'je'ttima panshamba Levíma atte. Tiseja Alfeo dutssi'ye tsu. Impuestoma isuye dyaisi Jesúsja tisema ttu'se: —Jija ñai'ccu. Ttu'sesi Leví jangipa Jesúsi'ccu ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsonsi Jesús Leví tsaoni japa an'jen'cho mesa jin'tti piyive ccuipa an'jen. Toya'caen tsain'bio impuestoma isusundeccu, egae tsinconsundeccu'qque jipa fae'ngae Jesús, tisema shondosundeccui'ccu piyiccuipa an'jen'fa. Nane tsain'bio tsendeccu'su Jesúsi'ccu jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsonsi Chiga manda'choma atesiansundeccu, fariseondeccu'qque tsama attepa Jesúsma shondosundeccuma iñajampaña'fa: —¿Micomba tsu que'ima atesian'suja va impuestoma isusundeccui'ccu, egae tsinconsundeccui'ccuja amba cui'je? ");
INSERT INTO conNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús tsama pañamba su: —Pajimbi'choa ccushaen'suma in'jambiqquia'caen ñajan jimbi gi tayo ño'a qquen in'jan'chondeccuma ccushaeñe. Tsa'ma ccushaen'suja paji'suma ccushaeñe jiqquia'caen ñajan egae tsinconsundeccuma ccushaeñe gi ji. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Feti'su Juanma shondosundeccu, fariseoma shondosundeccu'qque ambe'yi asettuye atesu'fa Chigama iñajañe. Tsonsi cca'indeccu Jesúsnga jipa iñajampaña'fa: —¿Micomba tsu Juanma shondosundeccu, fariseoma shondosundeccuja zutsse ambe'yi Chigama iñajan'ma quema shondosundeccuja tsa'caen asettu'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Qquen iñajampañasi Jesúsja su: —Tsandie pusheye tson'jemba a'ima ttu'sesi bojin sheque'ta ¿ma'caen tsu ambe'yi asettu'faya? Nane tsa tsandie toya can'jen'ni tsu fae'ngae tisei'ccu avujatsse amba cui'je'fa. Ña gi tsa tsandieca'on ja'ño can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tsa'ma maqui a'ta cca'indeccu tsandiema tise'pa'ye joqquitssiansi tsequi tsu ambe'yi asettu'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","A'ija cuna sarupai'ccu tssoru ondiccu'jema pi'pimbi. Nane qquen tson'da ondiccu'jema ñoñañe in'jamba tsu ti'tsse dañoña. Ma'ppa'ninda, cuna sarupaja zuruchopa tsu ti'tsse tssoruma chittaeña. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Toya'caen tsu a'ija vinoma cupoemba tssoru ttono botiyanga fiñaña'bi. Vinojan omppantssimba ttonoma chi'ttapa tsu catiyeya. Toya'caen ttono'qque tsangae tsu dañongeya. Tsa'ma cuna vinomanda tsu cuna ttono botiyanga fiñaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tse'i Jesúsja sema'ma'qquia a'ta nasipa'ye panshan jayi. Jayipa tisema shondosundeccuja qquipoe'supa trigoma sintti isupa shuju qque'shoemba añe ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsonsi fariseondeccu attepa Jesúsnga su'fa: —¡Canjan! ¿Jongoesie tsu quema shondosundeccuja qquen sema'jen'fa? Nane Chiga manda'cho tsu se'pi sema'ma'qquia a'ta tsa'caen semañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tsa'ma tiseja su: —¿Can'fambi ti qui Chiga Aya'fangae tayopi'su David tson'choma? Tiseja tisei'ccu jacansundeccu'qque qquipoe'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tayopi'su Abiatar Chigama afa'su na'suite David qquipoe'supa Chiga ettinga ca'nimba Chiganga afe'cho panma isupa an. Nane tsesu panmajan Chigama afasundeccuyi an'faya'cho. Chiga manda'choja se'pi faesu a'i añe. Tsa'ma David amba tisei'ccu jacansundeccunga'qque afe. Afesi isupa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Toya'caen tsu Jesúsja su: —Sema'ma'qquia a'taveja a'ima fuiteye tsu antte. Tsa'ma tsa a'tama Chigaja anttembi a'i panshaen se'piye. ");
INSERT INTO conNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tsa'cansi Sefaccone Ji'cho A'i gi sema'ma'qquia a'ta se'piye manda'choma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Faesu sema'ma'qquia a'ta Jesús Chiga manda'choma atesian'jen'ttinga ca'ni. Tse'tti tsu fae tsandie, tive samba dañonge'choja ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Cca'indeccuja ron'da dyai'fa Jesús sema'ma'qquia a'ta ccushaen'ninda “Queja egae tsincon” qquen suye. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsonsi Jesús tive dañonge'choma su: —Jangipa jipa ccutsuja enttingenga. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsomba cca'indeccuma iñajampaña: —Chiga manda'chota sema'ma'qquia a'ta egae tsoñe se'pisi ¿ñotsse tsoñe'ta ti ñotssi? Fi'ttiye se'pisi ¿ccushaeñe'da ti ñotssi? Tsa'ma tise'paja afambe ziya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsonsi Jesús piyicamba iyicca'yepa ñombi'ye, tsendeccu injama'cho shacapa in'jan'fambisi. Tsomba paji'suma su: —Yasaja que tivema. Yasapa tise tiveja ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsonsi fariseondeccu sombopa na'su Herodes aindeccui'ccu condasecco'fa ma'caen Jesúsma osha'ta fi'ttiye. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesúsja tisema shondosundeccui'ccu mar otafanga ja'fa. Tsain'bio Galilea ande'su a'i Jesúsi'ccu jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea ande'su'qque jaja'fa. Nane Jerusalén canqque'su, Idumea ande'su, Jordán na'en jonifani'su, Tiro, Sidón canqque pporotsse can'jensundeccu, nane pa'o a'i Jesús tson'choma pañamba can'su jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesús tsain'bio a'ima ccushaensi attepa faesu pajisundeccu'qque tisema pporaeñe ji'fa pporaemba ccushaye. Tsa'caen ji'fasi Jesúsja tisema shondosundeccuma manda cuintsu shavoma i dusiamba ronda'je'faye a'i panshaen bosi tsanga otseya'choe. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tsa'caen tson'jen'ni majan cocoya a'inga ca'nimba can'jen'cho Jesúsma attepa tise tsovejufanga ccaru dyaipa qquen fundo'fa: —¡Queta qui Chiga Dutssi'ye! ");
INSERT INTO conNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tsa'ma Jesús tise'pama iyu'upa se'pi: —Majangayi'qque tsa'caen conda'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesúsja ccotta'cconga ansundepa tise in'jan'chondeccuma ttu'se. Ttu'sesi Jesúsnga ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nane doce a'ive tsu ttu'se tisei'ccu jacan'faye; tise mandasi ccani japa candusian'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Toya'caen Jesús tsendeccunga antte cuintsu tisia'caeñi paji'suma ccushaeñe, cocoyama'qque joqquitssiañe osha'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsendeccu tsu Jesúsma doce shondosundeccu. Tise'pa inise tsu qquen: Simón (tsayi Pedro qquen inisecho'cho), ");
INSERT INTO conNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, toya'caen tise quinshin, Juan (va dosja Zebedeo dutssiyendeccu –tsendeccuveyi co'fepa inisian'fa Boanergesve– tsanda dushundeccu qquen tsu su'fa), ");
INSERT INTO conNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","toya'caen Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago (Tsaja Alfeo dutssi'ye), Tadeo, Simón (tsaja cananeandeccu'su a'i) ");
INSERT INTO conNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","toya'caen Judas Iscariote (tsaja Jesúsma chi'gapa afe'su tsu). Tsomba Jesúsja tsaoni ja tisema shondosundeccui'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsaoni ja'ni'qque ccase a'ija bo'fa. Nane panshaen bo'fasi añe'qque osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsa'caen tson'jen'ni Jesús antiandeccu osha'choma pañamba tisema angaye ji'fa, sumbie da qquen supa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Toya'caen Chiga manda'choma atesiansundeccu Jerusaléne jipa su'fa: —Va a'ingaja cocoya na'su Beelzebú tsu ca'ni. Tsa tisema in'jaensi tsu cocoyama joqquitssiañe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsonsi Jesúsja poiyi'cco a'ima ttu'sepa condase'choi'ccu afa: —¿Ma'caen tsu cocoya na'su Satana tisumajan joqquitssiaña? ");
INSERT INTO conNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Majan ande'su nasundeccu tisupanaccui'ccu iyicco'ta tsangae tsu pasa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Toya'caen fae etti'sundeccu faenga'sui'ccu iyicco'ta fae'ngae can'jeñe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsa'cansi Satanajan Satanama joqquitssian'choecan'da ñoa'me tsu tisuma chi'gaye'can. Tsa'caen tisuma chi'ga'ta ¿ma'caen tsu tiseja na'sia'caen mandaya? Nane tsa'caen tson'da tsangae tsu pasaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Qui'ambe tsa'o'suma tsu ca'nañe osha'fambi na'suma otie tandan ccuiñambi'ta. Nane o'tie tisema tandaña'cho. Tandan'ninda tise'bema cca'nañe osha. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nane ñoa'me gi su: Osha'cho egae tsincon'cho, osha'cho Chiganga afase'cho'qque a'i'ye joqquitssiqque'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tsa'ma majan Chiga Qquendya'pama afase'ninda ñoa'me tsu tise egae tsincon'choja joqquitssi'masia. Tsa'cansi tsangae tsu tsaja shacapa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Qquen tsu Jesúsja su a'i tisema cocoya ca'ni'cho qquen su'fasi. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsa'caen tson'jen'ni Jesús chan, tise quinshingendeccu ji'fa. Tsa'ma tsain'bio a'isi ca'nimbe'yi tsotefani ccutsupa faesuma manda maña Jesúsma ttusengaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsonsi Jesúsi'ccu dyaisundeccu su'fa: —Que mama, que quinshingendeccu tsu tsotefani ccutsupa queve ttuse'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tsa'caen su'fasi Jesúsja su: —¿Majan tsu ña mama? ¿Majan tsu ña quinshingendeccu? ");
INSERT INTO conNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsomba tisei'ccu dyaisundeccuma piyicamba canjaemba su: —Vandeccu, ñai'ccu can'jensundeccu tsu ña mama, ña quinshingendeccu. ");
INSERT INTO conNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nane poiyi'cco majan Chiga in'jan'choma pañamba canse'ta tsa tsu ña quinshi, ña que'tte, ña mama. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tsomba ccase Jesús mar otafanga japa atesiañe ashaen. Tseni jasi tsain'bio a'i tisenga bo'fa. Panshaen bo'fasi Jesús marni duse'cho shavonga otsepa dyai. Jesús tsa'caen otsesi a'ija sa'ani ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsa'caen dyaipa a'inga condase'chongae osha'choma atesian'jen. Tsa'caen atesian'jemba qquen conda: ");
INSERT INTO conNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Paña'faja vama. Fae a'i gaiña jon'su ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Gaiñasi enttingeja tsaiqui utufanga sheque. Tsa'caen shequesi chhiriria jipa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Enttingeja fattocconga sheque. Tse'ttija ande tombutssimbi. Tsa'cansi utatsse sho'yo. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tsa'ma setsa'fa mechopa coe'je desi pandipa samba. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Enttingeja anccosiccunga sheque. Tsonsi anccosi fae'ngatsse coensi ñotsse jon'cho nambe'yi pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Majanjan ñotssia andenga sheque. Tsaja sho'yopa coemba na'fa. Majan choja treintave na'fa. Majan sesentave na'fa. Majan cieme na'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tsomba Jesús tsendeccuma su: —Majan tsosinapaja, ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tse'i a'i bo'fa'cho ja'fasi, Jesúsi'ccu jacansundeccu, tisema doce shondosundeccu tisei'ccu tisuyi can'jemba iñajampaña'fa: —¿Jongoesu qquen tsu suye in'jan tsa condase'cho? ");
INSERT INTO conNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsonsi Jesúsja su: —Tayoe ma'caen Chigama na'sian'cho aindeccuve dapa canse'faya'chove Chigaja a'inga condambi. Ja'ño tsu que'inga pañaeñe in'jan. Tsa'ma cca'indeccu toya pañañe osha'fambisi condase'choi'ccu gi tise'pama atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nane tsendeccuja can'ma atte'fambi. Paña'ma in'jan'fambi. Tsa'cansi gi condase'choi'ccu tise'pama atesian'jen. Tsa'ma ñame in'jan'ma ccusha'faya'bi. Nane Chiga'qque tise'pa egae tsincon'choma joqquitssiaña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Toya'caen Jesúsja su: —¿Que'i'qque ti qui paña'fambi va condase'choma? Vama pañambi'ta ¿ma'caen qui faesu condase'choma paña'faya? ");
INSERT INTO conNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Choma gaiña'su tsu Chiga Aya'fama condase'su. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Majan a'ija tsaiqui utufanga gaiñasi sheque'choacan'fa tsu. Chiga Aya'fama paña'fasi cocoya na'su, Satana, jipa choma itsaqquia'caen tise'pa injama'cho'ye tsa Chiga Aya'fama paña'jen'choma aqquepoen. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Majan a'ija fattocconga sheque'choacan'fa tsu. Chiga Aya'fama pañamba avujatsse in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tsa'ma setsa'fa shacaqquia'caen injama'cho ta'etssimbi. Re'riccone in'jamba, cca'indeccu Chiga Aya'fama pañasundeccuma noñangiansi me'detsse canse'ta injama'cho chapiansi tsu antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Majanjan anccosiccunga sheque'choacan'fa tsu. Tsendeccuja Chiga Aya'fama paña'ma ");
INSERT INTO conNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","panshaen va ande'su jincho'choma in'jamba asi'ttaen'fa. Ti'tsse ricove daye in'jamba osha'chove ti'tsse in'jan'fa. Tsa'caen in'jamba Chiga Aya'fama paña'choma fi'ttiqquia'caen tise'pa in'jan'choma nañámbi. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tsa'ma majan a'ija ñotssia andenga jon'choa'caen Chiga Aya'fama pañamba injama'choi'ccu in'jan'fa. Ñotsse naqquia'caen cca'indeccunga condapa atapa'fa. Majan treintave atapa'fa. Majan sesentave, majan cieme atapa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Toya'caen tsu su: —¿A'ita ti tuñoma setsaemba cafon tsosiccunga ccutsiaña? Tsambi'ta ¿anambacco tsosiccunga ti ccutsiaña? Me'i. Tuñomajan sefani ancaeña'cho cuintsu a'tatssiye. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tsa'cansi tsangae a'tuya'choja jimbi. Tsa'ma osha'choja jai'ngae attiansi qui atte'faya. Ni tsangae condaya'bi'choaja jimbi. Jai'ngae condasesi qui a'tatsse paña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Majan tsosinapaja ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Toya'caen tsu su: —Ñotsse in'jamba paña'faja. Que'i agattopa cca'indeccunga afeqquia'caen tsu Chigaja agattopa que'inga afeya. Toya'caen ti'tsse'qque tsu que'i pañasundeccunga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nane majan an'bian'ninda ti'tsse tsu tisenga afeya. Tsa'ma majan mechomajan itsaya'cho. Nane tise re'riccoama'qque tsu tisema itsaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Toya'caen Jesúsja su: —A'i choma andenga jonsi sho'yoqquia'caen tsu a'ija Chiga aindeccuve da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nane jon'suja, choma jomba anamba qquendyapa, cosepa a'ta'ni'qque tiseja atesumbi cho ma'caen da'je'choma. Jon'su atesumbi'te choja sho'yopa coen'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nane ande'ye tsu tisuyi sho'yopa coen. Tseyija naje sombopa tse'ttieja canttini'cco sombo. Tse'i tsu na'chove da. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na cu'chosi taiya'cho napisi a'ija japa tai'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Toya'caen Jesúsja su: —¿Ma'can tsu a'i Chiga aindeccuve daya'cho? ¿Jongoesu condase'choi'ccu gi tsane condaseya? ");
INSERT INTO conNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nane tsata tsu mostasa choma andenga jonqquia'can. Pa'cco va andeni jinchombe choma bove'cco tsu mostasa choja. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tsa'ma jonsi sho'yopa poi teta'cho na'jima ti'tsse randeve da. Nane ttemba'qque randesi chhiriria chhajepa jipa tise tumbianccunga ño'fa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ya'caen tsu Jesúsja osha'cho condase'choi'ccu Chiga Aya'fama atesian. Nane ma'caen a'i pañañe osha'fa'nijan tsa'caen tsu tise'panga atesian. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A'tatsse afambeyi condase'choi'ccuyi tsu atesian. Tsa'ma tisema shondosundeccui'ccu tisuyi can'jemba pa'tssima a'tatsse conda. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsequi a'ta cosesi Jesúsja tisema shondosundeccuma su: —Jinge mar jonifani jaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Qquen supa Jesúsja toya shavo duse'choni dyaisi bo'fa'choma catipa tisema anga'fa. Toya'caen cca'indeccu faesu shavongae fae'ngae ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tise'pa jayisi fingian quia'me jangi. Shave'pa'qque jangipa shavonga ca'nimba on'baye tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsja shavo setsanga asusu'choemba ana'jen. Tsa'caen shave'pa jangisi tisema shondosundeccu Jesúsma qquendyaemba su'fa: —Atesian'su, ¿injiengembi ti qui? ¡Cu'nomba gi paye tson'jen'fa! ");
INSERT INTO conNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsonsi Jesús qquendyapa, fingiama iyu'upa, marma manda: —¡Vuiquija! ¡Ppimppianccuve daja! Qquen susi fingian pasasi mar'qque ppimppi'en da. ");
INSERT INTO conNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsomba tisema shondosundeccunga su: —¿Jongoesie qui panshaen dyo'fa? ¿Ñame in'jan'fambi ti qui? ");
INSERT INTO conNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsa'ma tise'paja dyopa can'boen'fa. Tsomba tisupapora su'fa: —¿Ma'can tsu va a'i? Mandasi fingian, mar'qque tisema paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsomba mar jonifani isepa ccattufa'fa Gadara andeni. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Ccattufapa shavo'ye sombosi fae a'i cocoya ca'ni'cho Jesúsnga ji. Nane tsa tsandieja ayama atú'ttini can'jemba ji. Tiseni cocoya can'jensi a'ija tisema tandañe osha'fambi. Ni candenai'ccu tandañe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nane tsain'bitsse candenai'ccu tisema tandandan'fa. Tive, tsu'ttema'qque yoshavai'ccu tandandan'fa. Tsa'ma oppattu shequiamba ja. Tsa'cansi majañi'qque tisema atesiañe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nane pa'cco a'ta, pa'cco cose ccotta'cconi ayama atú'ttini'qque jacamba fundo'je. Patunga'qque amppipa iña'cca. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsa'ma Jesúsma bianima attepa buttopa japa ccarupa dyai Jesús tsutteccofanga. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tsonsi Jesúsja su: —Cocoya, ¡joqquitssija va a'i'ye! Tsa'caen susi cocoyaja a'ima afaensi quia'me fundopa su: —¡Joccapitssia Chigambe Dutssi'ye qui, Jesús! ¿Jongoesie qui ñangata ji? ¡Chigáne ñama noñangianjama! ");
INSERT INTO conNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Qquen susi Jesúsja iñajampaña: —¿Jongoesu inise qui? Tiseja su: —Legión (Injantssia Sundarondeccu), qquen gi inisecho'cho, ingija tsain'bitssipa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsa'caen supa tsain'bitsse Jesúsma iñajan cuintsu biani moembe cañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tse'ttini tsain'bitssi cochi ccotta'cco piyiccu'fani an sheque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsa'cansi cocoyandeccu Jesúsma iñajan'fa: —Ingima mandaja cochinga, ingi tsendeccunga ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tsonsi Jesús tsa'caen manda anttesi cocoyandeccu tsa a'i'ye sombopa cochinga ca'ni'fa. Tse'ttija dos mil cochi can'jemba cocoyandeccu tise'panga ca'nisi buttopa amppippi ja'fa marnga. Marnga amppipa andeccopa pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsonsi cochima coirasundeccu tsama attepa buttopa ja'fa condaye. Nane canqquenga japa conda'fa. Biacca can'jensundeccunga'qque conda'fa. Tsa'caen conda'fasi a'i can'su ji'fa ma'caen tsu da'fa qquen in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesúsnga jipa tsa tayoe cocoya ca'ni'cho a'ima atte'fa. Nane tsa tayoe Tsain'bitssi Cocoya Sundarondeccu qquen inisecho'cho tayo ñotsse in'jamba ondiccupa dyai. Tsama attepa dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tsonsi tse'tti can'jensundeccu osha'choma attepa condase'fa. Nane cocoya ca'ni'choma ccushaen'chone, cochi ma'caen da'chone'qque condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aindeccu tsa'caen pañamba Jesúsma iñajan'fa cuintsu tise'pa ande'ye sombopa jaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsa'caen su'fasi Jesús shavonga otsesi tsa cocoya ca'ni'cho ccusha'cho Jesúsnga catsepa su: —Ña'qque quei'ccu jacañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Qquen susi Jesús se'pipa su: —Que tsaoni, que antiandeccuni jaja. Japa condaseja ma'caen Na'su quema mende'yepa ñotssiave tson'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsonsi tsa a'i japa condaseye ashaen. Nane pa'cco Decápolis andenga condasé jacan ma'caen Jesús tisema ñotsse tson'choma. Condasesi poiyi'cco a'i pañamba asi'ttaemba can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsomba Jesús shavonga otsepa toefanga isesi tsain'bio a'i tisenga bo'fa. Tsa'caen bo'fasi Jesúsja mar otafaniñi can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tseni can'jen'ni fae'cco, Chiga manda'choma atesian'jen'tti'su na'su, Jesúsnga ji. Tise iniseja Jairo. Jipa Jesúsma attepa tise tsutteccofanga amppi ccui. Amppi ccuipa tsain'bitsse iñajamba su: ");
INSERT INTO conNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Ña onque'nge tsu paye tson'jen. Jipa que tivei'ccu pporaenjan cuintsu ccushapa canseye. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Qquen susi Jesús tisei'ccu ja. Tsa'ma tsain'bio a'i'qque jayipa ta'yo'o. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bo'fa'cho enttinge'ye fae'cco pushesu ji. Tise egápai'ccu dañongepa doce canqque'fave me'detsse canse. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nane poi sejesundeccunga jasi tisema ti'tsse vanaen'fa. Tsa'ma ccushambe'yi pa'cco tise corifin'dima afepoen cati. Nane ccushambe'yi bove da. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsomba Jesús ñotsse ccushaen'jen qquen pañamba tsa pushesu bo'fa'cho enttinge'ye sepaccofae catsepa Jesús ondiccu'jema pporaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nane qquen asi'ttaemba pporaen: “Tise ondiccu'jeve'yi pporae'an'qque gi ccushaya.” ");
INSERT INTO conNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Qquen asi'ttaemba pporaensi tse'faei'ccuyi tise egápaja samba. Tsa'caen dasi tisu ai'vo ñotsse ccusha'choma atesu. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsa'ma Jesús'qque tisu ccushaen'choma atesupa piyicamba iñajampaña: —¿Majan tsu ña ondiccu'jema pporaen? ");
INSERT INTO conNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Qquen susi tisema shondosundeccuja su'fa: —Vui'o a'imbipa pporaensi qui “¿Majan tsu ñama pporaen?” qquenjan su'ya. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsa'ma Jesús poifama piyicamba majan pporaen'chove atteye tta'tta. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsa'caen ttatta'jesi pushesuja tisu ccusha'choma atesupa ttun'dundu'je'e dyo'ma Jesúsnga ji. Jipa Jesús tsutteccofanga ccarupa dyaipa pa'ccoma tansintsse conda. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Condasi pañamba Jesúsja su: —Shim'ppi, ñame in'jamba qui ccusha. Opatsse canseja. Ccatsse'qque tsa'caen vanaña'bi qui. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tsa'caen Jesús toya afa'je'ni atesian'jen'tti'su na'su tsaone ji'fa. Jipa Jaironga su'fa: —Tayo tsu que onque'ngeja pa'ya. Tayo pa'nijan ¿jongoesie qui ti'tsseja na'suma noñagian? ");
INSERT INTO conNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsa'ma Jesús tsa'caen su'je'fa'choma pañamba Jaironga su: —Dyombe canjan. Aqquia in'janjan. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsomba Jesús cca'indeccuma se'pipa –Pedro, Santiago, Juan (tsaja Santiago quinshin)– tsendeccuveyi anga. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsendeccuma angapa atesian'jen'tti'su na'su tsaoni napipa atte poiyi'cco a'i qquejian'fa'choma, fundopa i'na sheque'fa'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tsa'onga ca'nimba Jesúsja su: —¿Jongoesie qui qquejian'fa? ¿Jongoesie qui ina'jen'fa? Va du'shuja pambe'yi ana'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsa'caen susi tsendeccuja feña'fa. Feñasi Jesús poiyi'ccoma manda cuintsu sombo'faye. Tsomba du'shumbe yaya, du'shumbe mama, tisei'ccu ji'fa'chondeccui'ccuyi ca'ni'fa du'shu pa'cho ccuini. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ca'nimba Jesúsja du'shumbe tive'ye indipa su: —Tarita comi (Qquen tsu su: Du'shu, quema gi su, Jangija). ");
INSERT INTO conNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tse'faei'ccuyi du'shuja jangipa tsui ja'je. Tsa pushesu du'shuja doce canqque'fave an'bian'cho. Tsonsi poiyi'cco a'i dyo'oe can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tsa'ma Jesús tise'pama iyu'upa su: —Majangayi'qque conda'fajama. Tsa'caen supa du'shuma o'fian'faye manda. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús tse'ttie sombopa tise canqqueni ja. Tisema shondosundeccu'qque ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tseni can'jemba sema'ma'qquia a'ta napisi Jesús Chiga manda'choma atesian'jen'ttinga ca'nimba atesiañe ashaen. Tsain'bio a'i tise atesian'jen'choma pañamba can'boemba su'fa: —¿Mani tsu va a'ija japa osha'choma atesupa ji? Tseni jasi ¿jongoesu atesian'jen'choma tsu tisenga atesian'fa? ¿Majan tsu tisema oshaen tise tivei'ccu tsa'caen sefacconi'su agattoen'choma canjaeñe? ");
INSERT INTO conNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tiseja vani'su mesama sema'su tsu, María dutssi'ye. Tise quinshingendeccu, Santiago, José, Judas, Simón, toya'caen tise que'ttendeccu'qque vani ingi'ccu can'jen'fa. Tsa'caen supa Jesúsma iyicca'yepa paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsa'ma Jesús tise'panga su: —Chiga Aya'fama afa'su ccani jasi tsenisundeccu tisema in'jamba paña'fa. Tsa'ma tisu canqquenisundeccu, tisu antiandeccu, tisu tsa'osundeccu'qque tisema paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsa'can'fasi Jesúsja tise'panga minga'vieyi'qque canjaen'choma canjaembi. Nane aqquia enttingeve pajisundeccuma pporaemba ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tsendeccuja in'jan'cho shacasi Jesús asi'ttáen antte. Tsomba Jesús faesu chipiri canqquengae jacamba atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tisema doce shondosundeccuma ttu'sepa manda cuintsu dosve dosveyi jacan'faye. Mandapa tise'panga antte cuintsu cocoyama joqquitssian'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Toya'caen manda osha'choma angambe'yi fae accuicco'choveyi angaye. Nane pan, o'va, ni corifin'dive'qque meccoyi ja'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fae tisu ejian'cho sapatoi'ccuyi, fae ondiccu'jei'ccuyi jaya'cho –dosveja me'i. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Qquen mandapa su: —Majan tsa'onga ca'ni'da tse'ttini can'jen'faja tisu jaya'cho napiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Majandeccu que'ima chi'gapa que aya'fama paña'fambi'nijan tsa canqque'ye sombopa ja'faja. Jayipa que tsu'ttenga ancamba totopa'ma fanttundu cati'faja tise'pa egae tson'choma canjaeñe. Ñoa'me gi que'ima su: Osefaeña'cho a'ta napijisi tsa canqquesundeccu tsu bove dyo'tsse da'faya. Nane tayopi'su Sodoma canqquesundeccu, Gomorra canqquesundeccu'qque ñoa'me egae tsincomba tsequi a'ta ñoa'me vana'faya. Tsa'ma que'ima chi'gasundeccuja tise'pama ti'tsse tsu vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesús tsa'caen mandasi tsa doce tisema shondosundeccu japa candusian'fa cuintsu a'i tise'pa egae tsincon'choma catiye in'jamba ño'ame da'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Toya'caen tsain'bitssia cocoyama'qque joqquitssian'fa. Tsain'bitssia pajisundeccuma'qque cambajuma yayapoemba ccusha'shaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Poiyi'cco a'i Jesúsne ñotsse afa'fasi Na'su Herodes'qque paña. Nane majandeccu su'fa: —Feti'su Juan pa'cho tsu ccase qquendya. Tsa'camba tsu osha'choma oshacho. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Cca'indeccuja su'fa: —Tayopi Chiga Aya'fama afa'su Elías tsu. Toya'caen cca'indeccuja su'fa: —Faesu Chiga Aya'fama afa'su tsu, tayopi Chiga Aya'fama afasundeqquia'can. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Qquen su'fasi Herodes pañamba su: —Va a'ija Juan. Ñajan tise tsovema chattuye mandasi chattupa fi'tti'fa. Tsa tsu ccase qquendya. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nane Herodesja tise quinshin Felipe pushema itsa tisumbeve. Tsa pushesu inise tsu Herodías. Tsa'caen tsonsi Juanjan Herodesma su: —Ega tsu que antian pushema an'biañe. Qquen susi tsa pushesu, Herodíasja, Juanma iyicca'yepa fi'ttiye in'jan. Tsa'caen in'jansi na'su Herodes Juanma indipa candenai'ccu tandamba picco'je'ttinga picco. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodíasja tsa'caen Juanma iyicca'yepa fi'ttiye in'jan'ma Herodes se'pisi oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nane na'su Herodesja Juan egae jinchombipa ño'asi atesupa fi'ttiye dyojo. Tsa'caen in'jamba tsu se'pi Herodías Juanma fi'ttiye. Tsa'camba na'su Herodes Juanma pañañe in'jan'ma tise injama'choni dyojoqquia'caen asi'ttaen. Tsa'ma toya tsu avujatsse tisema paña. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsonsi Herodías ronda'je'cho a'ta napi. Tsequi a'ta na'su Herodes canqque'fa napisi fiestaen'jen'fa. Nane fiestaemba poiyi'cco nasundeccu, sundaro capitándeccu, Galilea'su joccapindeqquiama'qque ofian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tsa'caen ofian'jen'ni Herodías onque'nge ca'nimba boirasi Herodes, pa'o tisei'ccu dyaisundeccu avuja'fa. Na'su Herodes avujapa pushesunga su: —Jongoesuve in'jamba iñajan'ninda gi afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Toya'caen tsu ñoa'me su'choi'ccu qquen su: —Ñoa'me gi su, jongoesuve que iñajan'ninda afeya gi –nane pa'cco ña na'su manda'cho andema enttingeveja. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Qquen susi pushesuja japa tise chama iñajampaña: —¿Jongoesuve gi iñajaña? Chanjan su: —Iñajanjan Feti'su Juan tsovema. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Qquen susi tse'faei'ccuyi pushesuja na'su can'jeni japa su: —In'jan gi ja'ñoñi Feti'su Juan tsovema chattupa patiyanga ppiñamba ñanga i'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Qquen iñajansi na'su Herodes ñoa'me ñoquimbi. Tsa'ma ñoa'me su'choi'ccu tayo susi tisei'ccu dyaisundeccu'qque paña'fachosi afopoeñe in'jambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsa'camba tse'faei'ccuyi sundaroma manda cuintsu Feti'su Juan tsovema chattupa iye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsonsi sundaroja picco'je'ttinga japa Juan tsovema chattu. Chattupa patiyanga ppiñamba ipa afe pushesunga. Pushesuja isupa tise changa afe. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsa'caen fi'tti'fasi tisema shondosundeccu pañamba jipa tise ai'voma angapa a'tu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesúsja tisema shondosundeccuma candusiañe mandasi japa toequi ji'fa. Jipa Jesúsnga bopa conda'fa tise'pa ma'caen tson'choma, tise'pa ma'caen atesian'choma'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Conda'fasi Jesúsja su: —Jinge jaye a'i menia tseni japa tisuyi ño'faye. Nane tsain'bio a'i ja'nga ja'nga ji'je'fasi añe'qque osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsa'cansi Jesús tisema shondosundeccui'ccu tisupayi shavongae ja'fa a'i menia. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tsa'ma ja'fasi tsain'bio a'i attepa asi'ttaemba in'jan'fa tise maningae ja'choma. Tsa'caen in'jamba poi canqqueni buttopa tisema o'tie napi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tsonsi Jesúsja napipa shavo'ye sombopa a'i bo'fa'choma attepa tise'pama mende'ye. Nane oveja coira'suve mechondeqquia'caen injanga jacan'fa. Tise'pama mende'yepa osha'choma atesiañe ashaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tayo sime da jisi tisema shondosundeccu jipa su'fa: —Tayo tsu sime. Me'i'on tsu vani can'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aindeccuma manda mañajan cuintsu majan canqqueni, faesu tsa'o pporotssianga japa jongoesuma chavapa an'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tsa'ma Jesúsja su: —O'fian'faja que'i. Tise'paja su'fa: —¿Osha'faya ti gi ingija dosciento denario corifin'di'ccu chavapa tise'panga o'fiañe? ");
INSERT INTO conNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesúsja su: —¿Mañi'cco panme qui an'bian'fa? Can'ga'faja. Can'gapa su'fa: —Cinco pan, toya'caen dos avu san'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsonsi Jesús manda cuintsu poiyi'cco a'i shoshovinga dyai'faye; enttingeve va'tti, enttingeve cca'tti cca'tti dyai'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Fae'fanga cien, cca'fanga tsa'caen, fae'fanga cincuenta cca'fanga tsa'caen dyai'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A'i dyai'fasi Jesúsja cinco pan, dos avuma isupa Chiga sefacconima camba tsane Chigama ñotsse afa. Afa nanimba panma doñamba tisema shondosundeccunga afe cuintsu poiyi'cco a'inga attufaen'faye. Avuma'qque tsa'caen doñamba afesi attufaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Poiyi'cco a'i amba tteppu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tsa'caen tteppu'fasi doce saparove pan, avu antteye'choma on'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nane panma an'fa'chondeccuja tsain'bitssia a'i. Tsandienaccuveyi agattosi cinco mil tsu an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsomba Jesúsja tisema shondosundeccuma manda cuintsu shavonga otsepa mar jonifani, Betsaidani isepa tise've ronda'je'faye. Tiseja shanda aindeccuma can moeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tsa'caen can moemba Jesúsja ccotta'cconga ansunde Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tayo cosesi shavoja mar enttingeni duse. Toya'caen Jesúsja tisuyi sa'ani can'jemba ");
INSERT INTO conNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","tise'pa vana'jen'choma atte. Nane fingian indisi chho'chho'a'qque jaye osha'fambi. Tsa'caen vana'jen'fa'choma attepa Jesúsja a'taningae mar omba'ye tsui japa tise'panga catse. Nane tise'pama panshañe qquen in'jamba jayi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Tsa'caen tsui na'eñe jayisi tisema attepa “Aya tsu” qquen in'jamba dyopa fundo'fa. Tsa'ma Jesúsja tse'faei'ccuyi afapa su: —Quinse'tssi'faja. Ña gi. Dyombe can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsa'caen supa Jesús shavonga otsesi fingian'qque vuiqui. Tisema shondosundeccuja dyopa can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nane panma agattoen'choma toya injiengembipa dyo'fa, tise'pa injama'cho shacasi. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Marma isepa Genesaret andeni cattufa'fa. Cattufapa shavoma tandan dusiamba shavo'ye sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sombo'fasi tseni'su aindeccu “Jesús tsu” qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tsomba buttopa japa conda'fa pa'cco tsa andenga. Conda'fasi pajisundeccuma fechochoeñe ashaen'fa. Nane tise'pa ana'jen'chonga ppiñamba andupa Jesús can'jeni i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tsa'caen boña'fasi mani Jesús ja'ni'qque tseni pajisundeccuja ccui'fa. Nane rande canqque, chipiri canqque, biacca can'jen'choni ja'ni'qque pajisundeccu tisema iñajan'fa cuintsu tise ondiccu'je utufama pporaeñe antteye. Nane poiyi'cco majan pporaen'choja ccusha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsonsi majan fariseondeccu Jesúsnga catse'fa. Toya'caen majan Chiga manda'choma atesiansundeccu'qque Jerusaléne jipa tisenga catse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsa'caen jipa atte'fa majan Jesúsma shondosundeccu asettumbe'yi injanga otishimbe an'fa. Tise'pa nafattian'choma injiengembe'yi an'fasi afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nane fariseondeccu, poiyi'cco israendeccu'qque tise'pa tayopi'su coenzandeccu nafattian'choma in'jan'fa. Tsa'camba tsain'bitsse otishimbi'ta an'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Toya'caen anqque'su tiendane ji'a'qque otishimbi'ja an'fambi. Tsain'bitsse asettuye atesu'fa. Nane tasa, api, canderoma'qque tsa'caen giya'tsse cashi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsa'camba fariseondeccu, Chiga manda'choma atesiansundeccu Jesúsma iñajampaña'fa: —¿Micomba tsu quema shondosundeccuja tayopi'su coenzandeccu nafattian'choma cati'fa? Nane asettu'choma injiengembe'yi tsu otishimbe an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesúsja su: —Tansintsse tsu tayopi'su Isaíasja que'i ño'ame attiamba afopoensundeccune condase. Nane qquen tsu tiseja Chiga su'choma tevaen: Va a'ija aqquia aya'fai'ccuyi Ñane ñotsse afa'fa. Tsa'ma tisupa injama'chonijan Ñama chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aqquia tsu Ñame in'janqquia'caen tsincon'fa. Nane tise'pa atesian'jen'cho aqquia a'i in'jamba manda'choma tsu atesian'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Que'ija Chiga manda'choma catipa a'i nafattian'choma nafattu'fa. Tsa'camba qui tasa, api, canderoma'qque tsain'bitsse cashiye atesu'fa. Nane osha'choma'qque qui tsa'caen atesu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Toya'caen tsu Jesúsja su: —Ñoa'me Chiga manda'choma qui cati'fa que'i coenzandeccu nafattian'choma nafattuye. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tayopi'su Moisésta tsu su: “Paña'faja que yaya, que mamama.” Toya'caen “Majan tise yaya, tise mamama egae afa'ta tsu paya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tsa'ma que'ita qui antte'fa cuintsu dutssi'ye tise yaya, tise mamama suye: “Oshambi gi quema fuiteye. Pa'cco ña quema fuiteya'cho tsu ‘Corban’.” (Nane ‘Corban’ tsu ‘Chiganga afe'cho’ qquen su'cho.) ");
INSERT INTO conNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tsa'caen su'ta qui que yaya, que mamama fuitembe cañe atesu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nane tsa'camba qui Chiga Aya'fa su'choma pañambiqquia'caen antte'fa que'i a'i nafattian'choma pañañe. Tsa'caeñi qui osha'choma'qque tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Qquen supa Jesús ccase aindeccuma ttu'sepa su: —Poiyi'cco pañamba in'jan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Me'i tsu a'i aña'choma ansi injama'choma dañoñe. Tsa'ma egae in'jamba afasi egae afa'je'cho tsu tise injama'choma dañoña. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Majan tsosinapaja paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesúsja afa nanimba a'i'ye joqquitssipa tsa'onga ca'ni. Ca'nisi tisema shondosundeccu tsa condase'chone tisema iñajampaña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iñajampañasi Jesúsja su: —¿Que'i'qque ti qui paña'fambi? Atesu'fambi ti qui osha'cho an'choja a'i injama'choma dañoña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nane an'choja injama'chonga ca'nimbi. Tsa'ma ttopanga japa ccopai'ccu catiyeya'cho. Jesúsja tsa'caen supa, osha'cho anqque'suja añe ñotssi qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Toya'caen tsu su: —A'i egae in'jamba afasi egae afa'je'cho tsu tise injama'choma dañoña. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nane injama'cho tsosine egae in'jaensi a'ija egae in'jan'fa. Tsa'caen in'jamba tsu casara'chondeccu faesui'ccu egae can'se'fa. Injanga tsandie pushesu anttembi'chondeqquia fae'ngae egae can'se'fa. Cca'na'fa. Fi'tticco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Faesumbema an'biañe in'jan'fa. Egae canse'fa. Afopoen'fa faesuma egae tsoñe. A'tatsse egae tsincon'fa. Tisu injama'choni faesuma se'pi'fa. Afase'fa. Quinsepoen'fa. Nane sumbie daqquia'caen injanga tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pa'cco tsa'caen tson'cho tsu injama'cho tsosine sombo'cho. Sombopa tsu a'ima dañoña. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tse'ttie sombopa Jesúsja Tiro, Sidón canqque jini'su andeni ja. Napipa tsa'onga ca'nimba a'tutsse can'jeñe in'jan. Tsa'ma tayo a'i paña'fa tise can'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tse'faei'ccuyi fae pushesu tisema pañamba jipa Jesús tsutteccofanga ccaru dyai. Tsambe onque'ngeja cocoya ca'ni'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tsa pushesuja griego a'i Sirofenisia andenga isu'cho. Tsa jipa Jesúsma iñajan cuintsu tise onque'nge'ye cocoyama joqquitssiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsa'ma Jesúsja tisema su: —Antteja cuintsu o'tie dushundeccu an tteppu'faye. Ñotssimbi tsu du'shu an'jen'choma itsapa ainga o'fiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsa'ma tsa pushesuja su: —Ju, na'su, ñotsse qui su. Tsa'ma ainshavaja an'jen'cho mesa tsosiccuni ccuipa dushundeccu an'jensi sheque'je'choma an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Qquen susi Jesúsja su: —Ñotsse qui su. Jaye qui osha. Tayo tsu cocoyaja que onque'nge'ye joqquitssi. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsa'caen susi tsaoni japa tise onque'ngema atte tayo cocoya joqquitssisi ana'jen'choni ccui'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tsomba Jesúsja Tiro ande'ye sombopa Sidón canqquengae panshamba Decápolis andengae panshamba Galilea marnga napi. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tseni napisi fae tsandie ayafambipa tsonsinambima Jesúsnga i'fa. Ipa Jesúsma iñajan'fa cuintsu tise tivei'ccu pporaemba ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsonsi Jesúsja tsonsinambima a'i sheque'cho ccafanga anga. Angapa tisu tsimian'ccoi'ccu tsambe tsonsinama tsomi. Tsomba attuipa menzanza'fama'qque pporaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsomba sefacconima camba qquendyaccopa su: —¡Efata! (Fettayeja, qquen tsu su.) ");
INSERT INTO conNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tse'faei'ccuyi tsonsina fettayesi paña. Menzanza'fa'qque ccushasi tsu ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tsomba Jesús poiyi'ccoma mandapa su: —Majangayi'qque conda'fajama. Tsa'ma ti'tsse'tsse se'pi'choma tise'paja ti'tsse condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nane ñotsse can'boemba su'fa: —Osha'choma tsu ñotsse tson. Tsonsinambima'qque pañaen. Ayafambima'qque afaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tsequi a'ta tsain'bitssi a'i ccase bo'fa. Bo'tsse can'jen'fasi aña'chove me'i'onsi Jesúsja tisema shondosundeccuma ttu'sepa su: ");
INSERT INTO conNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Mende'ye gi va aindeccuma tres a'ta ñai'ccu can'jemba ja'ño aña'chove an'bian'fambi tisupa añe. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tise'pa tsaoni manda'nijan qquipoe'su'ta jongoesu quin'sui'ccu tsu tsaiqui'ye jaye osha'faya. Nane majandeccuja biane ji'fa'choja. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tisema shondosundeccuja su'fa: —Tsa'ma ¿ma'caen tsu o'fiaña'cho vanijan a'i meniamajan? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Qquen su'fasi Jesúsja iñajampaña: —¿Mañi'cco panme qui an'bian'fa? Tise'paja su'fa: —Sieteve. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsonsi Jesúsja manda cuintsu poiyi'cco a'i andenga dyai'faye. Dyai'fasi panma isupa tsane Chigama ñotsse afa. Afa nanimba panma doñamba tisema shondosundeccunga afe cuintsu cca'inga attufaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Toya'caen avuma'qque an'bian'fa. Tsama'qque isupa Chigama ñotsse afapa manda cuintsu tsama'qque attufaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsonsi poiyi'cco a'i an tteppu'fa. An nani'fasi antteye'choma taipa siete saparove on'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","An'fa'chondeccuja cuatro mil a'ia'ca'on tsu. Tsomba Jesús a'ima manda cuintsu tise'pa tsaoni ja'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Manda mañamba tisema shondosundeccui'ccu shavonga otsepa Dalmanuta andeni ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tseni napisi fariseondeccu jipa Jesúsi'ccu condaseye ashaen'fa qqueñañe in'jamba. Tsa'caen in'jamba iñajan'fa cuintsu sefacconi'su canjaen'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús injama'chone ñombi'yepa qquendyaccopa su: —¿Jongoesie tsu va aindeccuja sefacconi'su canjaen'chove iñajan'fa? Ñoa'me gi su, mingavieyi'qque tise'panga canjaen'chove canjaeña'bi gi. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsa'caen supa joqquitssipa shavonga otsepa mar jonifani ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsa'caen japa anqque'suma aqque'pa meccoyi ja'fa. Jo'su fae pancho'ccoeyi an'bian'fa shavoni. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tsonsi Jesúsja tise'pama mandapa su: —¡Can'faja! Injama'tse in'jan'fajama fariseondeccu cupana'ccoma, ni Herodes cupana'ccoma'qque. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Qquen susi tisema shondosundeccuja tisupapora afaccoye ashaen'fa: —Ingi panma imbisi tsu ya'caenjan su'ya. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Qquen afacco'je'fasi Jesús in'jamba su: —¿Jongoesie qui panma i'fambi'choane afacco'fa? ¿Toya ti qui paña'fambi? ¿Toya ti qui in'jan'fambi? ¿Toya ti qui injama'cho shacapa in'jan'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Atte'fambi ti qui tisupa tso'fei'ccu? ¿Ni paña'fambi ti qui tisupa tsonsinai'ccu? ¿Injan'jen'fambi ti qui? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nane cincoyi'cho'cco panma cinco mil a'inga attufaen'choma, ¿mañi'cco saparove qui an antteye'choma on'boen'fa? Tsonsi su'fa: —Doceve. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Toya'caen ¿sieteyi'cho'cco panma cuatro mil a'inga attufaen'choma, mañi'cco saparove qui on'boen'fa? Tsonsi su'fa: —Sieteve. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsonsi Jesúsja su: —¿Toya ti qui paña'fambi fariseondeccu atesian'jen'chone gi afa? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsomba napi'fa Betsaida canqqueni. Napi'fasi Jesúsnga i'fa fae binima. Ipa iñajan'fa cuintsu pporaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsonsi Jesús binima tive'ye indipa canqque joccani anga. Angapa bini tso'fema achaccui'ccu tssipoemba tivei'ccu tisema pporaen. Pporaemba iñajampaña: —¿Osha ti qui atteye? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Binijan camba su: —Atte gi aindeccuma quini'jian'caen. Tsa'ma tsui'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsonsi Jesús ccase tise tivei'ccu tso'fema pporaen. Pporaensi ñotsse can'boeñe ashaemba ccusha. Nane bianima osha'choma ñotsse atteye osha. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsa'caen ccushaemba Jesúsja manda cuintsu tisu tsaoni jaye. Mandapa su: —Canqquenga jajama. Majangayi'qque condajama tseni. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsomba Jesús, tisema shondosundeccu'qque Cesarea Filipo canqque jincho andeni jayi'fa. Toya tsaiqui'ye jayipa Jesúsja tisema shondosundeccuma iñajampaña: —¿Majan qquen tsu cca'ija su'fa ñamajan? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Qquen susi tise'paja su'fa: —Majandeccuta tsu su'fa, Feti'su Juan. Cca'ija su'fa, tayopi'su Elías. Toya'caen cca'ija Chiga Aya'fama afa'su qquen tsu su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsonsi Jesúsja iñajampaña: —¿Que'ija majan qquen qui ñama su'fa? Tsonsi Pedroja su: —Queja Chiga in'jan'cho Cristo. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsa'ma Pedro tsa'caen susi Jesúsja mandapa su: —Majangayi'qque tsama conda'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsomba Jesúsja atesiañe ashaemba su: —Sefaccone Ji'cho A'i gi me'detsse vanaña. Nane coenzandeccu, Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu'qque ñama chi'gapa fi'tti'faya. Tsa'ma ñama fi'tti'fa'ni'qque tres a'tangae gi ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tsamajan Jesús a'tatsse conda. Tsonsi Pedro Jesúsma cca'ttinga angapa iyu'uye ashaemba su: —Ya'caen afajama. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsa'ma Jesús poiyi'cco tisema shondosundeccuma piyicamba Pedroma ccane'qque iyu'u: —¡Joqquitssija ña'ñe Satana! Nane Chiga in'janqquia'caen qui in'jambi. A'i in'janqquia'caen qui in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ya'caen supa Jesús tisema shondosundeccuma, aindeccuma'qque ttu'sepa su: —Majan a'i ñai'ccu fae'ngae jiye in'jan'chota tsu tisu in'jan'choma aqque'paya'cho. Tisu avuja'ccoma opiqquia'caen tsu tiseja ñai'ccu fae'ngae jacamba paya'ngae vanaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Majan tisuma ccushaeñe in'jamba pa'ta catiyeya'cho. Tsa'ma majan ñame in'jamba ña ñotsse condase'choma in'jamba pa'ta tsata tsu ñoa'me ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A'ija poiyi'ccoma patsupa osha'choma an'biamba toya'caen tisu canse'choma qqueña'da, ¿jongoesune tsu bareya? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nane ¿mi'getsse tsu afepoeña'cho a'ija tise canse'choma chavaye? ");
INSERT INTO conNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Majan a'ija ñama, ña aya'fama'qque chi'gapa ansangepa va ñame in'jambipa egae tsinconsundeccunga ñane tansintsse condaye dyojo'fa. Tsa'caen ñama ansange'fa'nijan ñajan, Sefaccone Ji'cho A'i, jipa ccane'qque tsendeccuma ansangeya. Nane Chiga ña Quitsa ñama ñotssiave tsonsi, Tisema sefacconi'su ño'a shondosundeccui'ccu jipa gi tsendeccuma ansangeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Toya'caen tsu Jesúsja su: —Ñoa'me gi su, majan que'i'su toya pambi'ta Chiga Quitsa que'i na'suve dapa manda'choma qui atesu'faya. Nane tsequi a'ta osha'choma tsu mandaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsomba seis a'ta pasasi Jesúsja ccotta'cco sefatssia'nga ansundepa Pedro, Santiago, Juanma'qque anga tisupayi can'jeñe. Tseni can'jemba tsendeccu caña'jen'ni Jesúsja ccaningae da. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tise ondiccu'je chhariccotsse chandisu'ccoa'caen tototssie da. Nane majañi'qque va ande'su mappan'su tsa'cantsse totoeñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Toya'caen tayopi'su Elías, tayopi'su Moisés attiamba Jesúsi'ccu condase'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsama attepa Pedroja Jesúsma su: —Atesian'su, ñotsse gi vani can'jen'fa. Tsao'ña'faya gi tres tsa'ocho'ccoe –fae'cco quembe, faesuja Moisésmbe, faesuja Elíasmbe. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nane shondosundeccuja poiyi'cco ñoa'me dyo'fa. Tsa'camba Pedroja jongoesu qquen suye in'jaembiosi injanga afa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Qquen su'je'ni unjimba'cco tise'pama picco. Piccosi tsa unjimba'cco'ye aya'fa afa'choma paña'fa qquen su'choma: —Va tsu ña in'jan'cho Dutssi'ye. Tisema paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Unjimba'cco pasasi tse'faei'ccuyi camba faesu a'ive atte'fambi. Jo'su Jesúsveyi atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsa'caen tsomba ccotta'cco'ye ande jipa Jesús tisema shondosundeccuma manda cuintsu tise'pa atte'choma condambe can'faye. Ja'i Sefaccone Ji'cho A'i papa ccase qquendyasi condaseye ñotssi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tsa'caen mandasi condambeyi can'fa. Tsa'ma tisupayi iñajampañacco'fa Jesús su'chone “papa ccase qquendyaya” qquen susi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsa'caen asi'ttaemba Jesúsma iñajampaña'fa: —¿Mingasi tsu Chiga manda'choma atesiansundeccuja “Elías tsu Cristoma o'tie jiya” qquenjan su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Qquen iñajampaña'fasi Jesúsja su: —Ñoa'me tsu Elíasja o'tie jiya'cho pa'ccoma ñoñañe. Tsa'ma ñanda gi su tayo tsu Elíasja ji. Jisi a'ija tisema osha'choe ma'caen in'jangae tson'fa. Nane Chiga Tevaen'jen tisene suqquia'caen tsu tisenga tson'fa. Toya'caen ¿jongoesu qquen tsu Chiga Tevaen'jenjan su Sefaccone Ji'cho A'ine? Nane tiseja chigayepa vanaña'cho, qquen tsu tevaen. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tsa'caen supa ccotta'cco'ye andepa tisema shondosundeccuni ji'fa. Jipa tsendeccunga a'i bojin sheque'choma atte'fa. Nane Chiga manda'choma atesiansundeccu can'jemba tsendeccui'ccu condase'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsomba tse'i Jesúsma attepa can'boen'fa. Can'boemba butto'fa tisema chigambiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chigambian nanimba Jesúsja tisema shondosundeccuma iñajampaña: —¿Jongoesu qquen qui condase'fa jondeccui'ccu? ");
INSERT INTO conNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsonsi fa'e tse'tti canjen'suja su: —Atesian'su, vani gi i ña du'shuma, cocoya ca'nisi ayafambie da'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nane tise mani jaca'ni'qque cocoya indisi andenga amppi. Amppipa tse'ttinga aya'fae'qque ttottomboemba tte'ttoma tsai indipa ai'vo ishopa pa'je. Tayo gi iñajan quema shondosundeccu cuintsu cocoyama joqquitssiañe. Tsa'ma osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús pañamba su: —¡Ay, que'ija injienge'fambi! ¿Min'ge'e gi que'i'ccuta can'jeña? ¿Min'ge'e gi tsuin'da angacaña? ¡I'faja du'shuma! ");
INSERT INTO conNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsonsi i'fa. I'fasi cocoya Jesúsma attepa du'shuma indi pan'jaen. Tsa'caen pan'jaensi du'shu andenga amppipa mutsinomba aya'fae ttottomboemba pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pasi Jesúsja tsambe yayama iñajampaña: —¿Minguite tsu jova'caen dapa canse? Du'shumbe yayaja su: —Chuitepie tsu jova'caen dapa canse. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nane tsain'bitsse cocoya ña du'shuma si'ngenga, na'enga amppiamba fi'tti qquen tsincon. Tsa'cansi que osha'ta ingima mende'yepa fuiteja. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsja su: —¿Jongoesie qui su “osha'ta”? Nane pa'cco tsu oshayeya tise in'jan'nijan. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsonsi du'shumbe yayaja fundondo'e afa: —In'jan gi ñajan. ¡Ñama fuiteja ña ti'tsse in'jañe! ");
INSERT INTO conNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsa'caen su'je'ni ti'tsse'o a'i bojisi Jesús attepa cocoyama iyu'upa su: —Cocoya, ayafambie, tsonsinambie tsonqque'su, ña gi manda joqquitssija va du'shu'ye. Ccatsse tisenga ca'nijama. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsa'caen susi cocoyaja fundopa du'shuma ccase pan'jaemba somboin ja. Tsa'caen jasi du'shuja paqquia'caen ccui. Tsonsi cca'ija su'fa: —¡Tayo tsu pa'ya! ");
INSERT INTO conNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tsa'ma Jesús du'shu tive'ye indipa qquitssa jangian. Jangiansi du'shuja jangi ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsa'caen tsomba Jesús tsa'onga ca'nisi tisema shondosundeccu tisupayi tisei'ccu can'jemba iñajampaña'fa: —¿Ma'camba gi ingija cocoyama joqquitssiañe osha'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Qquen su'fasi Jesúsja su: —Tsesu cocoyamajan ambe'yi Chigama iñajamba tsu joqquitssianqque'su. Tsa'caen tsombija joqquitssiañe oshaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Tsa'caen tsomba tse'ttie sombopa Galileangae panshan'fa. Jesúsja tisema shondosundeccuma atesian'jemba in'jambi majañi'qque paña'faye tise ja'chove. Tsa'caen atesian'jemba tise paya'chone qquen condase: —Sefaccone Ji'cho A'ima indipa tsu afe'faya aindeccunga cuintsu fi'tti'faye. Tsa'ma fi'tti'fasi papa tres a'tangae gi ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsa'ma tise'paja jongoesu qquen su'chove atesu'fambi. Tsa'camba Jesúsma ti'tsse iñajampañañe dyojo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsa'caen sú japa Capernaum canqquenga napi'fa. Napipa tsa'onga ca'nimba Jesúsja iñajampaña: —¿Jongoesu qquen qui que'ija tsaiquingae condase ji'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tsa'ma tise'paja afa'fambi, tsaiquingae qquen condasepa: “¿Majan te ingi doce'su ti'tsse joccapitssia?” ");
INSERT INTO conNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsa'caen afa'fambisi Jesúsja dyaipa tsa docema ttu'sepa su: —Majan que'i'su ti'tsse joccapitssia've daye in'jan'da tsu cca'ima bove omba'suya. Tsaja cca'ima coira'suya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsa'caen supa Jesúsja du'shuma ttu'sepa tise'pa enttingenga ccutsian. Tsomba du'shuma munsin dyaipa su: ");
INSERT INTO conNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Majan a'i ña iniseningae afayepa du'shu qquen'cho'ccoa'ma ñotsse in'jan'da ñama'qque tsu ñotsse in'jan. Toya'caen majan ñama ñotsse in'jan'da jo'su ñameñi in'jambi. Tsa'ma ñama moen'suma'qque tsu in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsonsi Juanjan su: —Atesian'su, atte'fa gi fae a'i que inisema afapa cocoyama joqquitssian'jen'choma. Tsa'ma ingi'ccu jacambisi gi tisema se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Qquen susi Jesúsja su: —Se'pimbe can'faja. Majan ña inisema afapa ñotsse canjaen'da tsaja ja'i ñama egae afaye oshaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nane majan ingima chi'gambi'ta ingima fuite'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Majan a'i ñame in'jamba que'inga ñotsse afe'ninda Chigaja tsanga ñotsse afeya. Nane que'ija Cristombe a'i qquen in'jamba aqquia tsa'ccuma cui'ña'a'qque ñotsse tsu isuya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Majan va ñame in'jan'cho du'shuma egae tsoñe in'jaen'ninda bove ñotssi tsu tisema toya tsa'caen in'jaembite rande sunda'cho patuma tise tsifonga tandamba mar singu'ccunga andeccoemoeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tisu tiveyi quema egae tsincoñe in'jaen'ninda bove ñotssi tsu chattuye. Nane bove ñotssi tsu faefa'su tivei'ccuyi Chiga sefacconga ca'nimba canseye poifa'su tivei'ccu cococcuni si'nge anchanda'je'chonga catiyesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tsenijan minsin'qque pa'masia, si'nge'qque paya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Toya'caen que tsu'tte quema egae tsincoñe in'jaen'ninda bove ñotssi tsu chattuye. Nane bove ñotssi tsu faefa'su tsu'ttei'ccuyi Chiga sefacconga ca'nimba canseye poifa'su tsu'ttei'ccu cococcuni si'nge anchanda'je'chonga catiyesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tsenijan minsin'qque pa'masia, si'nge'qque paya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nane que tso'fe'qque quema egae tsincoñe in'jaen'ninda bove ñotssi tsu tsefama tssan'jañe. Nane bove ñotssi tsu faefa'su tso'fei'ccuyi Chiga sefacconga ca'nimba canseye poifa'su tso'fei'ccu cococcuni si'nge anchanda'je'chonga catiyesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tsenijan minsin'qque pa'masia, si'nge'qque paya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nane tsenijan poiyi'cco tsu si'ngenga ansiange'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Patu ansin tsu ñotssi. Tsa'ma patu ansi'ñe ansin tssutssu catiye'ninda ¿ma'caen tsu ccase ansinpave daya? Que'ija ansinpapa ñotsse canse'faja. Tisupaporai'ccu opatsse ñotsse canse'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tsa'caen supa Jesúsja Capernaumne sombopa Judea andeni Jordán na'en jonifani ja. Tseni jasi tsain'bio a'i tise can'jeni bo'fa. Tsa'caen bosi Jesúsja atesian tise in'janqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsa'caen tson'jen'ni majan fariseondeccu Jesúsnga catse'fa. Tisema qqueñañe in'jamba qquen iñajampaña'fa: —¿Ñotssi ti tsa'ndu tise pushema catiye? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Qquen su'fasi Jesúsja su: —¿Jongoe qquen tsu manda Moisésja? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tise'paja su'fa: —Moisés tsu manda pushema catiye in'jan'da catiya'cho tevaen'jema tevaemba pushenga afepa catiye. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsonsi Jesúsja su: —Moisés tsu tsa'caen manda antte que'i injama'cho shacapa in'jan'fambisi. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tsa'ma tseyi me'ttia'ye agattoemba Chigaja tsa'caen anttembi. Nane tsandie, pushesuve tsu agattoen. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tsa'cansi tsu tsandieja tise yaya, tise mamama catipa tise pushei'ccu canseya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tsa'caen cansepa tsu dos a'i fae a'iveyi da'fa. Nane dos a'imbi tsu. Jo'su fae'ccoyi. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chiga tsa'caen in'jamba fa'enga tsonsi a'ija tsa'caen fae'ccoe da'choma attufaembe can'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsomba Jesús tsaoni can'jensi tisema shondosundeccuja tsane ccase iñajampaña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iñajampaña'fasi Jesús su: —Majan tise pushema catipa faesuma pushe'ta tise aishe pushema tsu egae tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Toya'caen pushesu tise tsa'nduma catipa faesuma tsa'ndu'ta tise'qque tsu egae tsincon. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsonsi Jesúsnga dushundeccuma i'fa cuintsu Jesús pporaeñe. Tsa'ma tsa'caen iña'fasi Jesúsma shondosundeccu iyu'u'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iyu'je'fasi Jesús attepa iyicca'yepa su: —Antte'faja cuintsu dushundeccu ñanga ji'faye. Nane tise'pama se'pimbe can'faja. Majan Chigambe a'ija va dushundeqquia'can tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nane ñoa'me gi su, majan ñame in'jambipa va dushundeqquia'cambija osha'faya'bi tsu Chiga sefacconi ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsa'caen supa Jesúsja du'shuma munsin dyaipa pporaemba tise'pane Chigama ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsa'caen afa nanimba Jesús jaye tson'jen'ni fae tsandie buttopa jipa Jesús tsovejufanga ccaru dyaipa iñajampaña: —Ño'an atesian'su, ¿ma'caen gi tsoña tsangae canseyeja? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsja su: —¿Jongoesie qui ñama “ño'an” qquenda su? Chigayi tsu ño'an, Faesu ño'ame me'i'on. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Queta ti qui atesu a'inga Chiga manda'choma? Faesumbe pushei'ccu cansejama. A'ima fi'ttijama. Cca'najama. Cca'inga afopoenjama. Afopoenjama tisu ti'tsse isuye. Que yaya, que mamama ñotsse in'jamba pañajan. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Qquen susi tsandieja su: —Atesian'su, tsamajan pa'ccoma gi pañamba canse chuitepie. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús tsandiema ñotsse in'jamba camba su: —Fae tsoña'cho tsu shaca. Japa pa'cco que an'bian'choma chavaenjan. Chavaemba corifin'dima isupa mendeqquianga afeja. Tsayita qui Chiga sefacconi ricove daya. Tsa'caen tsomba jipa ñai'ccu fae'ngae paya'ngae jacanjan. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsama pañamba ñoquimbipa ñombi'yé ja panshaen ricopa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsonsi Jesúsja tisema shondosundeccuma piyicamba su: —Aiye'pa tsu majan osha'choma an'bian'cho Chiga a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsa'caen susi tisema shondosundeccuja asi'ttaemba can'boen'fa. Tsa'ma Jesúsja ccase su: —Dusutssi'pa, majan tise an'bian'choma panshaen in'jan'da ñoa'me aiye'pa tsu tiseja Chiga a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nane bove aiye'pambi tsu camello nojan'cco chango'ye panshañe. Ti'tsse aiye'pa tsu rico Chiga a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Qquen susi pañamba ti'tsse asi'ttaemba can'boen'fa. Asi'ttaemba tisupapora iñajampaña'fa: —Tsa'caenda ¿majan tsu ccushaye'ja osha? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tsa'ma Jesús tise'pama camba su: —Aindeccuja osha'fambi tsa'caen tsoñe. Tsa'ma Chigaja osha. Nane Chigaja osha'choma oshacho. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsonsi Pedro afaye ashaemba su: —Na'su, ingija pa'tssi tisu an'bian'choma catipa gi quei'ccu jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Tsonsi Jesúsja su: —Ñoa'me gi su, majan a'i ñama in'jamba, va ccushaya'chone ñotsse condase'choma in'jamba osha'choma cati'ta ja'i tsu ñoa'me ti'tsse'tssia've isuya. Nane majan tise tsa'o, tise antiandeccu, tise yaya, tise mama, tise pushe, tise dushundeccuma, tise andema'qque cati'ta tsaja toya va andeni cansepa tsu injan'tsse isuya. Nane tsa'o, antiandeccu, mamandeccu, dushundeccu, andeve'qque ti'tsse tsu isuya. Toya'caen tsa'caen da'fasi cca'indeccuja tisema chi'gapa in'jangae tsincon'faya. Tsa'ma jai'ngae tsa chi'ga'cho tsu tsangae canse'pama isuya. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nane tsain'bio majan ja'ño joccapitssiandeccuja utu'ccoe tsu da'faya. Toya'caen tsain'bio majan ja'ño utu'ccoandeqquiaja tsequi a'ta joccapitssia've tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsaiqui'ye Jerusaléni ansunde jipa Jesúsja tisema shondosundeccuma o'tie jayi. Tise'paja asi'ttaen jayi'fa. Nane dyojo'tsse Jesúsma omboen jayi'fa. Tsonsi Jesúsja tisema doce shondosundeccuma ttu'sepa ccase ccani angapa tisuma ma'caen tson'faya'choma conda. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Qquen tsu su: —Que can'faja. Jerusaléni gi jayi'fa. Tseni japa gi Sefaccone Ji'cho A'i indiyepa afeyeya Chigama afa'su nasundeccunga, Chiga manda'choma atesiansundeccunga. Tsendeccu tsu ñama fi'tti'faye mandapa israembindeqquianga ñama afe'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tsendeccu tsu ñama da'ñomba afa'faya. Tsomba ñanga attupoemba tsse'tsse'faya. Tsa'caen tsse'tsse nanimba tsu ñama fi'tti'faya. Tsa'ma papa gi tres a'tangae ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsonsi Santiago, Juan (tsendeccuja Zebedeo dutssiyendeccu) Jesúsnga catsepa su'fa: —Atesian'su, in'jan'fa gi que ingi in'jan'chove tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsa'caen susi Jesúsja iñajampaña: —¿Jongoesuve tsoñe qui in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsonsi su'fa: —In'jan'fa gi que na'suve dasi fa'eja que tansinfanga, faesuja que pavefanga dyaiye. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsonsi Jesúsja su: —Jongoesuve tisu iñajan'chove que'ija atesu'fambi. ¿Osha'fa ti qui ña cui'ccuma cu'iqquia'caen vana'faye? ¿Osha'fa ti qui ña fetiye'chonga fetiyeqquia'caen vana'faye? ");
INSERT INTO conNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Qquen susi tise'paja su'fa: —Osha'fa gi. Tsonsi Jesúsja su: —Ñoa'me ña cui'ccuma cu'iqquia'caen qui vana'faya. Ña fetiye'chonga fetiyeqquia'caen qui vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tsa'ma ña tansinfanga, ña pavefanga dyaiya'choveta ñajan antteye oshambi. Tsamajan antteya'cho majanga Chiga tayo in'jamba ñoña'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Qquen su'je'fasi faesu diez shondosundeccu pañamba Santiago, Juanma iyicca'ye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsa'ma Jesús tsendeccuma ttu'sepa su: —Que'i in'janqquia'caen majan cocama na'suve dapa ti'tsse mandaye tsu atesu'fa. Majan ti'tsse ñoa'me'qque na'su tsu faesu bove'ccoama manda. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tsa'can'faya'bi qui que'ija. Majan que'i'su ti'tsse na'suve daye in'jan'choja faesuma fuiteya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Que'i majan joccapitssia na'suve daye in'jan'choja poimbe sema'suve daya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsa'caen ñajan, Sefaccone Ji'cho A'ita gi faesuma mandaye jimbi. Nane faesuma fuiteye gi ji. Tisuma afepa poimbe shacama afepoeñe gi ji ccushaya'chone. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsomba napi'fa Jericó canqqueni. Napipa can'jenccapa Jesús, tisema shondosundeccu, tsain'bio a'i'qque tse'ttie sombopa jayi'fa. Jayi'fa'ni fae bini, tsaja Bartimeo qquen inisecho'cho, Timeo dutssi'ye, tsaiqui utufani dyai. Tse'tti dyaipa corifin'dima iñajan'jen, va'chapa. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús Nasareno'su panshanjin qquen pañamba binijan fundopa su: —Jesús, David Dutssi'ye, ñama mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Qquen fundo'jesi cca'indeccu tisema iyu'u'fa cuintsu ziyaye. Tsa'ma iyu'u'fa'ni'qque ti'tsse'e fundo'je: —David Dutssi'ye, ñama mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsonsi Jesús ja ccutsupa su: —Tisema ttu'se'faja. Tsonsi japa binima su'fa: —Dyombe jangipa jija. Queve tsu ttuse'je. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tsonsi tise opoi'jema ttova catipa butto jangipa Jesúsnga catse. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tise catsesi Jesúsja iñajampaña: —¿Jongoesuve ña tsoñe qui in'jan? Tsonsi binijan su: —Na'su, atte'jeye gi in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsonsi Jesúsja su: —Jaye qui osha. Tayo qui ccusha ñama in'jamba. Tse'faei'ccuyi binijan atteye osha. Ccushapa Jesúsi'ccu tsaiqui'ye ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusaléni ca'tsa napijipa Betfagéni, Betaniani napi'fa. Tseni Olivo ccotta'cco pporotsse napipa dos tisema shondosundeccuma manda moen ");
INSERT INTO conNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","qquen supa: —Ja'faja tseni tsa canqque pporotsse. Tsenima qui atte'faya boro du'shuma, tandan ccutsian'choma. Tsangaja majañi'qque otsepa dyaipa jacan'fambi. Tsama ccupapa i'faja vani. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Majan jongoesie qui tson'jen'fa qquen iñajampaña'nijan su'faja: “Na'su tsu vanga dyaipa japa ccase ipa afeya.” ");
INSERT INTO conNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsa'caen susi japa atte'fa boro du'shuma, tsa'o sombo'tti pporotsse tsaiqui utufanga tandan ccutsian'choma. Attepa ccupa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ccupa'je'fasi attepa tse'tti can'jensundeccu iñajampaña'fa: —¿Mincon'jen'fa qui? ¿Jongoesie qui boro du'shuma ccupa'je'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsonsi tise'paja Jesús suqquia'caen su'fa. Tsa'caen susi angaye antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsa'caen tsonsi boro du'shuma Jesúsnga angapa tise'pa sarupama boronga oppoen'fa cuintsu Jesús tsanga dyaiye. Tsa'caen ñoña'fasi Jesús otsepa dyaipa ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tsa'caen dyaipa jayisi tsain'bio a'i tise'pa oppoen'jen'cho sarupama tsaiquinga ppappa'fa. Cca'indeccuja japa ccaquejema chattupa ipa tsaiquinga ppappa'fa tsaiquima ñotsse ñoñañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Toya'caen o'tie jayindeccu, sepaccofae jiñadeccu'qque qquen fundo'fa: —Avuja'faja. Ñoa'me ñotssi tsu Na'su Chiga mandasi ji'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ñoa'me ñotssi tsu tayopi'su Na'su David mandaqquia'caen tiseja Na'suve dapa mandaye. Chiga sefacconisundeccu'qque avuja'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús tsa'caen Jerusaléni ca'nimba Chiga ettinga ca'ni. Ca'nimba pa'tssi osha'choma camba sombopa Betaniani ja. Nane tayo simesi tisema shondosundeccui'ccu tseni ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ccaqui a'ta Betaniane sombopa jayipa Jesúsja qquipoe'su. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Qquipoe'supa higuera'jima biane attepa teta'choma pishoye ja. Higuera'jin naje'paja teta'choma an'biaña qquen in'jamba japa najemeñi atte. Nane tise naitembisi name mecho. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsa'caen mechosi Jesúsja higuera'jima su: —Minguite'qque majañi'qque an'faya'bi tsu que teta'choma. Qquen su'je'choma tisema shondosundeccuja paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsomba Jerusaléni napipa Jesúsja Chiga ettinga ca'ni. Ca'nimba tseni chavaensundeccuma, chavasundeccuma'qque tteyaye ashaen. Nane corifin'dima cambiansundeccumbe mesama qqui'tssa ttova'ccoen. Ppuppuju'choma chavaensundeccumbe siyetama'qque tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Majañi'qque Chiga etti'ye andupa jaye anttembi. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsa'caen tsomba atesian'jemba su: —Chiga Tevaen'jenga Chiga tsu su: “Ña tsa'ota tsu poi ande'su a'ine ñama iñajan'jentti.” Tsa'ma que'ija va tsa'oma ccanamba tsa'ove tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús tsa'caen atesian'jensi poiyi'cco a'i pañamba tise atesian'jen'choma in'jan'fa. Tsa'cansi Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu'qque tsama atesupa panshaen paña'fasa'ne dyopa ttatta'fa ma'caen Jesúsma fi'ttiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsa'caen tson'jen'ni tayo cose jisi Jesúsja canqque'ye sombopa ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ccaqui a'ta sinte'yi panshan jimba higuera'jima atte'fa setsa'chone tayo pa'cco samba'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Attepa Pedroja Jesús su'choma in'jamba tisenga su: —Atesian'su, que canjan, que iyu'upa susi ¡higuera'jin tayo samba! ");
INSERT INTO conNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tsonsi Jesúsja su: —Chigave in'jan'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nane ñoa'me gi su, majan a'i va ccotta'ccoma “Joqquitssipa marnga jaja” qquen susi tsa'caen tsu jaya. Nane tisu injama'cho shacambipa, “tisu suqquia'caen tsu daya,” qquen in'jan'ninda tsa'caen tsu daya. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsa'cansi gi su pa'cco jongoesuve qui Chigama iñajamba isuya qquen in'jan'da tsa'caen qui isuya. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chigama iñajan'jen'da tisu majain'ccu iyiccaye'je'choma in'jamba japa ñoquiaña'cho. Tsa'caen tsonsi tsu Chiga que'i Quitsa sefacconi canjen'su'qque que'i egae tsincon'choma joqquitssiamba ñoquiya. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nane que'i ñoquian'fambian'da tsa'caeñi tsu Chiga que'i Quitsa sefacconi canjen'su'qque que'i egae tsincon'choma joqquitssiaña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsomba toequi Jerusaléni ccase ji'fa. Tseni jipa Chiga etti'ye jaca'ni Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu, coenzandeccu'qque Jesúsma can'su jipa ");
INSERT INTO conNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","iñajampaña'fa: —¿Majan na'su in'jaensi qui queja tsa'caen tsincon? ¿Majan tsu quema manda antte na'sia'caen mandaye? ");
INSERT INTO conNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Qquen su'fasi Jesúsja su: —Ña'qque gi que'ima iñajampañaña. Que'i ñanga condasi gi ña'qque condaya ma'caen ña tsincon'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juan feti'chota ¿sefacconi'su Chiga mandasi feti'cho ti? Tsambi'ta ¿a'i mandasi feti'cho ti? Conda'faja ñanga. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsonsi asi'ttaemba tisupapora afacco'fa: —¿Jongoesu qquen gi su'faya? “Sefacconi'su Chiga mandasi feti'cho tsu” qquen su'ninda tsu suya “Tsa'ca'nijan ¿micomba qui Juanma pañamba in'jan'fambi?” ");
INSERT INTO conNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tsambi'ta “a'i fetiye manda qquen su'ninda” ¿...jm jḿ? Nane poiyi'cco a'i Juanjan ñoa'me Chiga Aya'fama afa'su qquen su'fasi atesupa nasundeccuja dyojo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsa'camba Jesúsnga su'fa: —Atesu'fambi gi. Tsonsi Jesúsja su: —Jen'da ña'qque que'inga condaya'bi gi majan mandasi ña tsa'caen tsincon'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsa'caen tsomba Jesúsja condase'choi'ccu condaseye ashaemba su: —Fae a'i can'jemba tise andenga tsajaccuve jon. Tsomba tseccuma ttu. Ttupa patu changove ñoña tsaja tsa'ccuma somboeña'chove. Toya'caen se'fatssia tsa'ove'qque tsao'ña tsa'ye tisu caña'jeña'chove. Pa'ccoma ñoñamba na'suja faesu semasundeccunga tsa tsajaccuma afe cuintsu sema'faye. Afepa ccani japa can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsajaite napisi fa'e tise a'ima manda maña semasundeccuni cuintsu japa tai'fa'choma na'sumbe enttingeve isuye. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tsa'ma semasundeccuja tsama indipa tsse'tssepa me'ccoeyi moen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsonsi na'su faesu tise a'ima manda maña. Tsonsi tsama'qque patupa'e ttovaccoen'fa. Tsa'caen tsomba tsovema iñacaemba afase moen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsonsi na'suja ccase faesuma moensi tsamajan fi'tti'fa. Tsonsi tse'ttieja tsain'bitssi a'ive manda maña. Tsa'ma tsendeccuma'qque majama tsse'tssepa majamajan fi'tti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Toya fae'cco tise dutssi'yeyi can'jen. Tsamajan tise ñotsse in'jan'cho. Jai'ngae tsama'qque manda moen qquen asi'ttaemba “Ña dutssi'yemanda tsu paña'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tsama attepa semasundeccuja tisupapora afacco'fa: “Va tsu ñoa'me na'sumbe dutssi'ye. Na'su pa'nijan vaja pa'cco na'su an'bian'choma tsu isuya. Jinge tisema fi'ttipa tsajaccuma tisupambe isu'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsa'caen in'jamba indipa fi'ttipa tise ai'voma tsajaccumbe ccafanga ttova cati'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsa'caen tson'fa'nijan ¿ma'caen tsu ande na'suja tsoña? Nane tiseja jipa tsa semasundeccuma fitti'tti sefaemba faesundeccunga tsa andema afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Can'fambi ti qui Chiga Tevaen'jen qquen su'choma: Tsaoñasundeccu in'jambipa joqquitssian'fa'cho patu tsu ñoa'me ti'tsse joccapitssia patuve da. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tsa'caen tsu Na'suja tson. Ingija attepa can'boemba “Ñotssi tsu” qquen asi'ttaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsonsi nasundeccu tsama pañamba Jesúsma indiañe in'jan'fa tayo atesupa Jesúsja tise'pama in'jaen su'chosi. Tsa'ma aindeccuma dyojopa anttepa ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsomba tse'i Jesúsnga manda moen'fa majan fariseondeccuma, majan na'su Herodes aindeccuma'qque cuintsu japa Jesúsma iñajampañamba qqueña'faye. Nane qqueñañe in'jan'fa tise shacama atteye. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tsa'caen manda'fasi jipa su'fa: —Atesian'su, queja poiyi'cco a'i fae'ngatssi qquen in'jamba qui Chiga tsaiquine tansintsse atesian'jen. Nane a'i ccaningae su'choma pañambipa qui dyombi'tsse tansintsse atesian'jen. ¿Chiga manda'chota ti antte cuintsu na'su César iñajansi impuestoma afeye? Tsambi'ta ¿se'pi ti? ¿Afepoen'faya'cho ti gi? Tsambi'ta ¿afepoen'faya'bi ti gi? ");
INSERT INTO conNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tsa'ma Jesúsja tise'pa aqquia afa'fa'choma atesupa su: —¿Jongoesie qui ñama qqueña qquenjan tson'jen'fa? I'faja corifin'dima ña atteye. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","I'fasi Jesús attepa iñajampaña: —¿Majambe tsove'ju, majambe inisema tsu vanga tevaen'cho? Tsonsi tise'paja su'fa: —Na'su Césarmbe. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsonsi Jesúsja su: —Tsa'caenda Césarmbemajan Césarnga afe'faja. Toya'caen Chigambemajan Chiganga afe'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Omboe Jesúsnga ji'fa saduseondeccu. Tsendeccuja pa'cho ccase qquendyaya'bi qquen supa Jesúsma iñajampaña'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Atesian'su, tayopi Moisésja ingima mandapa tevaen cuintsu a'i du'shuve mechoyi pasi tsambe pushe toya canse'nijan pa'chombe quinshiñi tsu pa'chombe pushema pusheya'cho. Tsomba tsu du'siaña'cho tise quindya'yembe inisema aqque'pasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nane vani ingi'ccu siete tsandie fae antian'suyi can'jen'fa. Coenzaja o'tie pushepa du'shuve mechoyi pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pasi tsandupajen'choma quinshin coenza pushe. Tsa'qque du'shuve mechoyi pa. Tsonsi faesu quinshin bove chu'a'qque tsandupajen'choma pushepa tsa'caeñi pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nane tsa'caen poiyi'cco siete tsandie tsama pushepa du'shuve mechoyi pa'fa. Sepaccoe tsa pushesu'qque pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tsa'caen tsomba a'i ñoa'me ccase qquendya'ninda ¿majambe pusheve tsu daya? Ñoa'me poiyi'cco siete tsandie tsu tisema pushe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pañamba Jesús tise'pama su: —Que'ija Chiga Tevaen'jema ñotsse atesumbipa qui tsa'caen qque'fa. Toya'caen Chiga osha'choma oshachosi qui tsama'qque atesumbipa qque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nane a'i papa ccase qquendyapa pushe'masia, tsa'ndu'masia tsu. Tise'pa dushundeccuma'qque antte'faya'bi pusheye, tsa'nduye. Tsa'ma Chigambe sefacconi'su shondosundeqquia'caen pa'masiave dapa canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Toya'caen pa'chondeccu ñoa'me ccase qquendya'chone ¿can'fambi ti qui Moisés tayopi tevaen'choma? Nane Moisés tsu tevaen ma'caen Chigaja quini'si anchanda'je'ttie tisenga afa'choma: “Ña gi Abraham, Isaac, Jacob Chiga.” ");
INSERT INTO conNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nane Na'su Chigaja pa'chombe Chigambi tsu. Tsa'ma cansendeqquiambe Chiga tsu. Tsa'cama qui ñoa'me qque'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Toya'caen fa'e Chiga manda'choma atesian'su Jesúsi'ccu condasecco'fa'choma paña. Pañamba Jesús ñotsse afasi atesupa catsepa iñajampaña: —¿Majan tsu Chiga manda'cho ti'tsse'tssia? ");
INSERT INTO conNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tsonsi Jesúsja su: —Ti'tsse'tsse manda'cho tsu qquen: “¡Paña'faja israe aindeccu! Na'su ingi Chiga, tsayi tsu Na'suja. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pa'cco que injama'choi'ccu Chiga que Na'suma ñotsse in'jan'faja. Nane pa'cco que canse'pai'ccu, pa'cco que in'jan'choi'ccu, pa'cco que ai'voi'ccu Tisema ñotsse in'jan'faja.” Tsa tsu o'tie tsoña'chove manda'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Toya'caen faesu manda'cho'qque fae'ngatssiqquia'can tsu: “Tisuma in'janqquia'caen faengasundeccuma'qque in'jaña'cho.” Me'i'on tsu faesu manda'cho vama ti'tsse'tssiave. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsonsi Chiga manda'choma atesian'suja su: —Atesian'su, ñotsse qui su. Ñoa'me tsu fae Chigayi jin. Me'i'on tsu faesu tsama ti'tsse'tssiave. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nane pa'cco injama'choi'ccu, pa'cco canse'pai'ccu, pa'cco in'jan'choi'ccu, pa'cco ai'voi'ccu Chigama in'jañe, toya'caen tisuma in'janqquia'caen tisupapora in'jañe'qque –tsa tsu pa'cco oque oraen'choma bove ñotssi. Tsa tsu pa'cco Chiganga fi'ttipa afe'choma'qque bove ñotssi. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsa'caen susi Jesúsja tsa a'i ñotsse in'jansi atesupa su: —Pan qui napiji Chiga a'ive daye. Tsonsi majañi'qque ccase catsepa iñajampaña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tsomba Jesús Chiga ettinga atesian'jemba su: —¿Ma'caen tsu Chiga manda'choma atesiansundeccuja “Chiga in'jan'cho Cristoja David Dutssi'ye tsu” qquenjan su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nane Davidja Chiga Qquendya'pa tisema in'jaensi qquen afa: Na'su Chigaja ña na'sunga su: “Ñai'ccu fae'ngae na'suve dapa va'ttinga dyaija ña tansinfanga ña quema iyiccayesundeccuma patsusi que tsu'tte tsosiccunga ccuiqquia'caen oshambipa quema paña'faya'gae.” ");
INSERT INTO conNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nane David tsa'caen “Ña na'su” qquen susi ¿ma'caen tsu tiseja David dutssi'yeya? Qquen atesian'jensi tsain'bio a'i Jesúsma avujatsse paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesúsja atesian'jemba su: —Injama'tse in'jan'faja manda'choma atesiansundeqquia'caen tsonsa'ne. Nane tsendeccuja bia'a seda ondiccu'jema ondiccuye in'jan'fa. Tsaiquingae jayi'fasi poiyi'cco tise'pama atte'ta ñotsse tise'pama chigambiañe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tsendeccuja atesian'jenttinga ja'a'qque bove ñotssia dyaipa'chove ttatta'fa. Fiestama panshaen'jeni'qque nasundeccui'ccu fae'ngae dyaipa añe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pajaen'chondeccumbe tsa'oma'qque itsapa'fa. Tsomba cca'indeccu tise'paja ño'a qquen in'jan'faye bia'ave Chigama iñajan'fa. Tsendeccu tsu ti'tsse catiye'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsomba fae a'ta Jesúsja Chiga ettini can dyai Chiganga afe'cho corifin'dima ppiña'jen'cho jin'tti. Ma'caen aindeccu corifin'dima ppiña'jen'choma can dyai. Tsanga majan ricondeccuja tsain'bitssi corifin'dive ppiña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tson'jen'ni fae tsandupajen'cho jipa dos findi'ccoe ppiña fae reave bare'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsama attepa Jesús tisema shondosundeccuma ttu'sepa su: —Ñoa'me gi su, va'cha pajaen'cho tsu cca'ima ti'tsse ppiña corifin'dima ppiña'jen'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nane pa'o a'i tise'pa tayo chavasi antteye'choma ppiña'fa. Tsa'ma tiseja mechopa pa'cco tise chavapa canseye an'bian'cho corifin'dima afe. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Chiga etti'ye sombopa jayisi fa'e tisema shondo'su tisenga su: —Atesian'su, ¡que canjan, va patu randei'ccu tsao'ña'cho ñoncca'osi! ");
INSERT INTO conNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsa'ma Jesús pañamba su: —¿Ñotssiave ti qui atte va rande ettima? Ñoa'me gi su, ni fae patuyi'qque faesu patumbe ombani ottaya'bi. Pa'ccoma tsu asi'tta'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsomba Olivo ccotta'cconga jaja'fa Chiga etti tansien. Jesús tseni japa dyaisi Pedro, Santiago, Juan, Andrés'qque tisuyi tisei'ccu can'jemba qquen iñajampaña'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—In'jan'fa gi que inginga condaye, ¿minga'ni tsu que suqquia'caen napiya? ¿Jongoesuma attepa gi osefaeña'cho a'ta napiji'chove atesu'faya? ");
INSERT INTO conNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Qquen su'fasi Jesúsja su: —Injama'tse majandeccu que'ima afopoemba qqueñasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chigaja ñama moen a'ima ccushaen'suve. Tsa'ma tsain'bio a'i tsu jipa: “Ña gi Chiga in'jan'cho Cristo” qquen afopoen'faya. Qquen supa tsain'bio a'ima tsu qqueña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tsa'ma geraen'jen'fa'choma, toya'caen ja'i geraen'faya'choma paña'an'qque dyombe can'faja. Tsaveqque'su tsu. O'tie tsu tsa'caen tsoña'cho. Tsa'ma tse'faei'ccuyi osefaeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nane fae ande'su faesu ande'sui'ccu iyicco'faya'cho. Fae na'su faesu na'sui'ccu iyiccopa geraen'faya'cho. Ande'qque cca'tti cca'tti oya'jeya. Cca'tti cca'tti aindeccuja qquipoe'su'faya. Toya'caen cca'tti cca'tti aindeccuja qquejian'faya. Tsa'ma tsaja me'detsse canse'faye ashaen'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","¡Que'iyi'qque in'jan'faja! Que'ima indipa nasundeccu bo'fa'chonga afe'faya cuintsu iyu'u'faye. Nane Chigane atesian'jenttinga angapa que'ima ma'ppi'faya. Que'i ñama in'jansi tsu que'ima ccutsian'faya quini'ccopandeqquianga, ande nasundeccunga'qque. Tsa'caen ccutsian'fasi qui tise'panga ñane ñotsse afa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nane osefaeña'cho a'ta napimbi'te tsu va ñotsse condase'choma poi ande'su a'inga condaseya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Que'ima nasundeccunga anga ccutsian'fasi dyombe can'faja ma'caen afaya'choma. In'jambe can'faja. Tsequi a'ta tsu Chiga Qquendya'pa que'ima afaeña. Afaensi tsa'caen conda'faja. Ñoa'me que'ija afa'faya'bi qui. Tsa'ma Chiga Qquendya'pa tsu afaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Antianda tsu tise antiama fi'ttiye afeya. Yayata tise du'shuma; dutssiyendeccuta tise'pa yayandeccuma iyicca'yepa afe'faya cuintsu fi'tti'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nane que'ija ñame in'jamba chigaye'faya poiyi'cconga. Tsa'ma majan ta'etssia injama'chopa osefaeña'gae quiña'da tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tayopi'su Chigama afa'su Daniel egae dyoña'su napiya'chone tevaen. Tsa napi'ta osha'choma tsu tsangae dañoña. Nane tsa ccutsu'ma'ttia'ni ccutsusi atte'ta poiyi'cco majan Judea andeni can'jen'da ccotta'cconga tsu ccuya'faya'cho. (Majan va tevaen'jema can'da ñotsse in'janjan.) ");
INSERT INTO conNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tsequi a'ta majan tsao'cco omba'su ppappacconi can'jen'da tsosiccuni'su cuartonga jongoesuve isuye andembe'yi tsu japa ccuya'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Majan nasipani can'jen'da tsaoni tise sarupave jimbe'yi tsu japa ccuya'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Va'cha pushesundeccuja majan suri, majan du'shuma chochoen'jen'cho'qque. Tsequi a'ta tsu vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chigama tsu iñajaña'cho sanfainte tsa ccuyaya'cho a'ta napisa'ne. Nane sanfainte napi'ninda ñoa'me tsu ti'tsse vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nane andeve agattointe ashaen'cho ja'ño'qque a'ija tsa'caen vana'fambi. Jai'ngae'qque a'ija tsa'caen ccase vana'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nane Chiga tsa'caen vanaña'cho a'tave agattoccoeyi anttembiecan'da ñoa'me tsu poi a'i pa'faye'can. Tsa'ma Chigaja Tise ttu'se'cho aindeccuma ccushaeñe in'jamba tsa'caen vanaña'chove agattoccoeyi antte panshaen vana'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tsa'cansi que'inga majan a'i “Que canjan, va'tti tsu Cristoja can'jen,” tsambi'ta “Que canjan, tseni tsu can'jen,” qquen su'ni'qque tisema paña'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nane afopa'cho Cristondeccu, afopa'cho Chiga Aya'fama afasundeccu tsu attian'faya. Attiamba ñoa'me ti'tsse'tssia canjaen'cho, osha'cho agattoen'choma'qque tsu canjaen'faya a'ima qqueñañe. Nane osha'ta tsu Chiga ttu'se'chondeccuma'qque qqueña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsa'ma ñotsse in'jan'faja. Toya tsa'caen tsombi'te gi que'inga conda que'i injan'jen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tsequi a'ta vana'jen'cho pasasi coejechiga tsu si'ame daya. Cose'suchiga'qque chanjuña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sefacconi'su o'fe'qque amppi'faya. Nane pa'cco sefacconi'su jincho'cho'qque oya'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsonsi qui atte'faya Sefaccone Ji'cho A'i sefacconi'su unjimba'cco'ye dyai jiña'choma. Ñoa'me joccapitssia a'tatssiai'ccu jiñamba ");
INSERT INTO conNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","tisema sefacconi'su shondosundeccuma tsu manda moeña poi biani'su andeni japa Tise ttu'sepa in'jan'chondeccuma cuintsu i'nga'faye. Nane sefacco já ccutsuni'qque japa i'nga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Higuera tetachojima camba atesu'faja. Ttemba cuname sombosi ccaqueje'qque chu'pasi coejefave daji qquen qui in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tsa'caen ña su'choma attepa qui in'jan'faya osefaeña'cho ca'tsa napiji, tayo sombo'ttinga napiqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ñoa'me gi su: Va ja'ño'su aindeccu toya pambi'te tsu pa'cco ña su'choja napiya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nane sefacco, ande'qque pasaya. Tsa'ma ña aya'faja pasaya'bi. Ñoa'me su'cho tsu. Ña suqquia'caen tsu daya. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tsa'ma maqui a'ta ma'can horani jiya'chove majañi'qque atesu'fambi. Nane Chigama sefacconi'su shondosundeccu ni ña, Chiga Dutssi'ye'qque gi atesumbi. Tsamajan Chiga Quitsayi tsu atesucho. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tsa'cansi ñotsse in'jamba caña'jen'faja. Toya'caen Chigama iñajan'jen'faja. Nane atesu'fambi qui maqui tsa hora napiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tsata tsu fae a'i biani jayipa tsa'o'ye toya sombombi'te manda tise aindeccuma. Nane poinga tise'pa sema'bave manda antte. Etti sombo'tti coira'suma'qque manda cuintsu ñotsse caña'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Que'ija atesu'fambi qui minga'ni ña, tsa'o na'sia'caen, jiya'choma. Nane sime, tsambi'ta enttinge cose, arapa seyo'je'ni, sinte ji'ninda qui atesu'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ñotsse in'jamba caña'jen'faja ña que'i ana'jen'fa'chonga jisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nane ña que'inga suqquia'caen gi poiyi'cconga su: ¡Ñotsse injan'jen'faja! ");
INSERT INTO conNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Toya tsu dos a'ta shaca Chiga panshaensi injienge'cho fiestama panshaeñe. Tsa fiestangaja pan cupana'ccove mechoama an'fa. Tsequi a'ta Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccui'ccu bopa ttatta'fa ma'caen Jesúsma afopoemba indipa fi'ttiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsa'ma su'fa: —Fiestama panshaen'jenquija indiye ega, pa'o a'i iyicca'yepa qquejian'fasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsomba Jesús Betaniani japa na congomba pajipa ccusha'cho Simón tsaoni can'jen. Tse'ttini can'jemba an'jen'cho mesa jin'tti piyive ccui'ni fae pushesu tisenga ji. Jipa ñotssia arabastro patu botiyama i. Tsa botiya on'ba'o ñoncca'a nardo ñome'ba jin. Tsaja tsain'bitsse bare'cho. Tsomba tsa botiyama fettapa Jesús tsovenga fiña onjoen. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tsa'caen onjoensi majan tseni can'jensundeccu iyicca'yepa tisupanaccu su'fa: —¿Micomba tsu ñome'bama tsa'caen aqquia cati? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nane chavaen'choecan'da tresciento corifin'dima ti'tsse isupa va'chandeccunga afeya'an. Qquen supa tsa pushesuma ñoa'me iyicca'ye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tsa'ma Jesúsja su: —¡Antte'faja! ¿Jongoesie qui va pushesuma noñangian'fa? Ñoa'me ñotsse tsu tiseja ñama tson. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tsangae tsu va'chandeccuja que'i'ccu can'jen'faya. Tise'pama maqui in'jan'da tsu mende'yeya'cho. Tsa'ma ñajan tsangae que'i'ccu can'jeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Va pushesuja ma'caen oshapa tayo tsu tson. Nane ñome'bai'ccu ña ai'voma onjoemba ñama a'tu'faya'chone tsu tsa'caen tson. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ñoa'me gi su: Poi ande'ye mani va ñotsse condase'choma condase'ta va pushesu tson'choma'qque tsu condase'faya cuintsu tisema injan'jen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsonsi fa'e Jesúsma doce shondosundeccu'su, tsa Judas Iscariote qquen inisecho'cho, Chigama afa'su nasundeccunga ja Jesúsma tise indipa afeya'chove condaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsama pañamba nasundeccu avujapa corifin'dima afeye su'fa. Tsa'caen su'fasi Judasja tta'tta ma'caen Jesúsma tise'panga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan cupana'cco meccoa fiestama ashaen'jen'qui tsu Chiga panshaen'cho ovejama fi'ttiya'cho. Tsequi a'ta Jesúsma shondosundeccuja tisema iñajampaña'fa: —¿Mani qui in'jan ingi japa Chiga panshaen'cho injienge'cho fiestane aña'choma sho'ccoen'faye que añe? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsa'caen su'fasi tisema shondosundeccuma dosve moen'jemba su: —Ja'faja canqqueni. Tseni qui cachui'faya fae tsandie, tsa'ccu tsoripama anga ji'choma. Tsai'ccu jaja'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mani ca'ni'da su'faja tsa'o na'suma: “Atesian'su tsu su: ¿Mani tsu que cuarto cuintsu tseni ñajan ñama shondosundeccui'ccu Chiga panshaen'cho injienge'cho aña'choma añe?” ");
INSERT INTO conNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tsonsi tsu rande cuarto sefani'su ppappaccoma que'inga canjaeña. Tseni osha'cho tsu jin. Tse'ttinga ingimbe sho'ccoen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsa'caen susi tisema shondosundeccu japa osha'choma Jesús suqquia'caen attepa Chiga panshaen'cho injienge'chone aña'choma sho'ccoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tayo cose jisi Jesús tisema doce shondosundeccui'ccu ji. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsomba mesani piyive ccuipa an'jemba Jesúsja su: —Ñoa'me gi su, fa'e que'i'suyi ñai'ccu fae'ngae an'jen'cho, tsa tsu ñama chi'gapa cca'indeccunga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Qquen susi tsendeccuja ñombi'yepa faesu, faesu tisema iñajampañañe ashaen'fa: —¿Ñambi ti gi? Toya'caen faesu'qque: —¿Ñambi ti gi? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Qquen su'fasi Jesúsja su: —Ñai'ccu fa'e apisho'ttongayi panma tssipoemba an'su tsu ñama afeye tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nane Chiga Tevaen'jen suqquia'caen Sefaccone Ji'cho A'ima afesi indi'faya. Tsa'ma ¡va'cha tsu tisema afe'su! Nane tise've Tise mama isumbiecan'da tsu tisene bove ñotssiye'can. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","An'jemba Jesús panma isupa Chigama ñotsse afa. Afa nanimba panma doñamba tise'panga afe. Afepa su: —An'faja. Va tsu ña ai'vo. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Toya'caen tasama isupa ccase Chigama ñotsse afa. Afa nanimba tise'panga afe. Afesi poiyi'cco tsa tasa'suma cu'i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cui'je'fasi Jesúsja su: —Va tsu ña anjampa –Chiga a'i'ccu tseyi fae'ngae injancco'fa'chove canjaen'cho anjampa tsu. Tsain'bio a'ine ña anjampa tssamba catiyeya tise'pa egae tsincon'choma joqquitssiañe. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ñoa'me gi su, ccatsse'qque vani cu'iya'bi gi o'fa tsaja vinoma. Jai'ngae Chiga Quitsa tise aindeccuma mandasi gi tseni tise'pai'ccu cuna vinoma cu'iya. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Settapoen nanimba sombopa Olivo ccotta'cconga ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tseni japa Jesús tise'panga su: —Que'i poiyi'cco ja'ño cose qui dyopa ñama cati'faya. Nane Chiga Tevaen'jen suqquia'caen tsu tson'faya: “Oveja coira'suma ña fi'ttisi oveja tsu shequequin ja'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tsa'ma ña ccase qquendya'pa gi que'ima o'tie Galileani jaya. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Qquen susi Pedroja su: —Mapán cca'i dyopa quema cati'fa'ni'qque ñajan me'i. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsa'ma Jesúsja su: —Ñoa'me gi su, ja'ño cose'yi que'qque toya arapa dos se se'yombi'te tres se qui ñane a'tieña. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tsa'ma Pedroja ti'tsse su: —Nane quei'ccu fae'ngae paya'ngae ñajan quene a'tieña'bi. Tsonsi poiyi'cco tsa'caen su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsomba Jesús, tisema shondosundeccui'ccu Getsemaní quini'ccosiccojini ja'fa. Tseni napipa tise'pama su: —Va'tti dyai'faja. Ña Chigama iñajan'gaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Qquen supa Pedro, Santiago, Juanma ti'tsse joccani anga. Angajipa asi'ttaemba dyojo'ccoye ashaemba injama'cho tsosipie ñoquimbipa ");
INSERT INTO conNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","tsendeccuma su: —Injama'cho tsosipie paqquia'caen gi asi'ttaemba ñombi'ye. Va'ttinga catiyepa anambe caña'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Qquen supa Jesúsja ti'tsse joccani ja. Japa andenga puvi ccuipa Chigama iñajan cuintsu osha'ta tise vanaña'cho hora pasaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chigama iñajamba qquen tsu su: —Yaya, Chiga Quitsa, queja osha'choma oshacho. Cui'ya'choma itsaqquia'caen va ña vanaña'choma joqquitssianjan. Tsa'ma joqquitssiañe in'jambi'ta que in'janqquia'caen tsonjan. Ña in'jan'chomajan me'i. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iñajan nanimba tisema shondosundeccuni ji. Jipa ana'jen'fa'choma attepa Pedroma su: —Simón, ¿ana'jen ti qui? ¿Oshambi ti qui ni fae horaveyi'qque caña'jeñe? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ñotsse qquendyapa Chigama iñajan'jen'faja tisupa qquepa egae tsinconsa'ne. Nane injama'cho tsosipie in'jan'ma qui ai'voni shacapa tsa'caen tsoñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tsa'caen supa ccase japa otia've iñajanqquia'caeñi iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tsomba jipa ccase ana'jen'fa'chongayi ji. Nane anae'sui'ccuyi ccuipa osha'fambi jongoesu qquen afaya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tsonsi ccase Chigama iñajan'gapa jipa su: —¿Toya ti qui anamba ñofa'je'fa? Naniña tsu. Tayo tsu ña vanaña'cho hora napi. Ja'ño tsu Sefaccone Ji'cho A'ima egae tsinconsundeccunga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jangi'faja. Jinge jaye. Ñama chi'gapa afe'su tsu tayo napi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tsa'caen Jesús toya afa'je'ni, Judas, fa'e Jesúsma shondosundeccu'su, ji. Tsai'ccu tsain'bitssi a'i jiji'fa. Nane Chigama afasundeccu, Chiga manda'choma atesiansundeccu, israe'su coenzandeccu tise'pama manda moen'fasi matichi'ccu quini'ccoi'ccu ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, indiye afe'suja, toeni afafaemba su: —Ña gi que'inga canjaeña majama indiya'chove. Majama ña mochapa chigambia'ninda tsama indipa anga'faja. Moensa'ne ñotsse tandamba anga'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tsa'caen su'chopa Judasja Jesúsnga ji catsepa su: —¡Atesian'su! Qquen supa mocha. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsonsi aindeccu attepa Jesúsma qquitssa indi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsa'ma fa'e Jesúsi'ccu ccutsu'su tisu matichima qquitssa somboemba Chigama afa'su na'sumbe sema'su tsonsinama qquerui ttova. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsonsi Jesús aindeccunga su: —¿Ñanda ti gi ccana'su? ¿Tsa'cansi ti qui matichi, quini'ccoi'ccuta ñama indiye ji'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nane poi a'ta gi Chiga ettinga dyaipa atesian'jen'ma qui ñama indi'fambi. Tsa'ma Chiga Tevaen'jen ñama fi'ttiya'chone tevaensi ja'ño tsu tsa'caen tsoña'cho ñoa'me su'cho qquen canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Qquen su'je'ni poiyi'cco Jesúsma shondosundeccu tisuveyi tisema catipa ccuya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tsa'ma fae tsandie chu'a sarupai'ccuyi ai'voma fanangopa omboe jayi. Tsa'caen jayisi a'i tisema qquitssa indi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tsa'ma tiseja sarupama catipa chu'ccoyi ccuyin ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsomba tse'i joccapitssia Chigama afa'su na'suni Jesúsma anga'fa. Toya'caen poi Chigama afa'su nasundeccu, israe'su coenzandeccu, Chiga manda'choma atesiansundeccu'qque tseni bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroja biapie'yi japa joccapitssia na'sumbe tsa'o tsotefaniñi can'jen. Tsomba sundarondeccui'ccu si'ngeccufani sa'vu dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tsonsi Chigama afa'su nasundeccu, pa'o nasundeccu bo'fa'cho'qque ma'caen Jesúsma afopoeña'chove ttatta'fa cuintsu Jesúsja tsesuma shacaen qquen supa tisema fi'ttiye mandaye. Tsa'ma atte'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nane tsain'bio a'i aqquia afopoen'fa Jesúsma. Tsa'ma ñotsse fae'ngatsse afopoen'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsonsi majandeccu jangi ccutsupa Jesúsma aqquia afopoemba su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ingita gi paña'fa tise su'choma: “Ñanda gi a'i tsao'ña'cho Chiga ettima osiamba tres a'tangae a'i tsao'ñambi'choave ccase ccutsiaña.” ");
INSERT INTO conNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tsa'ma toyayi fae'ngatsse afa'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsonsi Chigama afa'su na'suja nasundeccu enttingeye ccutsupa iñajampaña: —¿Minga'osi qui afambi? ¿Jongoesie tsu jondeccuja quema ya'caen su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsa'ma Jesúsja fae ayafaveyi'qque afambi. Afambisi Chigama afa'su na'suja ccase iñajampaña: —¿Que ti qui Chiga in'jan'cho Cristo? ¿Que ti qui Ño'a Chigambe Dutssi'ye? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tsonsi Jesúsja su: —Ju, ña gi. Nane que'ija atte'faya qui Sefaccone Ji'cho A'i gi Osha'choma Oshacho'cho Chigambe tansinfani dyai'choma. Toya'caen qui atte'faya ña unjimba'cco'ye jiña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qquen susi Chigama afa'su na'suja iyicca'yepa tisu ondiccu'jema chi'ttapa su: —¿Toya ti shaca camba afasundeccuja? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Que'i'qque qui tayo paña'fa tise Chigane egae su'choma. ¿Jongoe qquen qui in'jan'fa? Tsonsi poiyi'cco Jesúsma fi'ttiye qquen su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tse'i majanjan Jesúsnga attupoeñe ashaen'fa. Tise tso'fema'qque piccopa tsse'tssepa qquen su'fa: —Injama'choi'ccu atesupa condaja majan tsu quema tssai. Toya'caen sundarondeccu'qque tisema tivei'ccu ma'ppi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Tsa'caen tson'jen'fa'ni Pedroja tsa'o tsotefani can'jemba savu'jesi Chigama afa'su na'suma coira'su pushesu jipa tisema atte. Attepa can'boemba su: —¿Que'qque ti qui tsa Jesús Nasareno'sui'ccu jacan'su? ");
INSERT INTO conNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsa'ma Pedroja a'tiemba su: —Atesumbi gi tsamaja. Atesumbi gi jongoe qquen qui su. Tsa'caen supa tsaofama ttu'cho sombo'ttima somboye jasi arapaja se'yo. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tsa'caen jayisi tsa coira'su pushesuja ccase tisema attepa can'boemba tse'tti can'jensundeccunga su: —Va a'ija tsa'suyi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tsa'ma tiseja ccase a'tien. Omboe tse'tti can'jensundeccu ccase Pedroma su'fa: —Ñoa'me qui queja tsa'su. Queja Galilea'su. Tsambe aya'fangae qui afa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Qquen susi Pedro Chigama iñajan tise tansintsse su'choma canjaeñe. Nane afopoen'ninda Chiga tisema egae tsoña'chove ttu'se. Tsa'caen ttu'sepa tsu su: —Atesumbi gi tsa a'ima, majama qui afa'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tse'faei'ccuyi arapa gayo ccase se'yo. Se'yosi Pedroja Jesús su'choma in'jan: “Toya arapa dos se se'yombi'te tres se qui ñane a'tieña.” Tsama in'jamba Pedroja i'na. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tayo a'tasi toya sinte'yi Chigama afa'su nasundeccuja condasecco'fa coenzandeccui'ccu, Chiga manda'choma atesiansundeccui'ccu. Nane pa'cco nasundeccu bo'fa'choi'ccu condaseccopa in'jamba Jesúsma tandamba angapa governaror Pilatonga afe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tsonsi Pilatoja Jesúsma iñajampaña: —¿Que ti qui israendeccu na'su? Tsonsi Jesúsja su: —Que suqquia'caen tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tsa'caen su'je'ni Chigama afa'su nasundeccu Jesúsja egae tsincon'su qquen afopoen'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tsonsi Pilatoja ccase Jesúsma iñajampaña: —¿Minga'osi qui afambi? ¿Pañambi ti qui que egae tsincon qquen su'fa'choma? ");
INSERT INTO conNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsa'ma Jesúsja tsa'caen su'ni'qque afambi. Afambisi Pilatoja ma'caen tsoña'chove atesumbi. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Poi canqque'fa fiestama panshaen'jenqui Pilatoja fa'e indiye'choma ccupaye atesu, majama a'i in'jamba iñajan'fa'nijan. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tseccuni piccoyepa can'jen fa'e Barrabás, qquen inisecho'cho. Nane Barrabásja tisupaporai'ccu goviernoma iyicca'yepa nasundeccuma joqquitssiañe in'jamba a'ima fi'tti'fa. Tsane indiyepa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsonsi pa'o a'i jipa Pilatoma iñajañe ashaen'fa cuintsu tise fiestanga tson'jen'choma tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iñajan'fasi Pilatoja su: —¿In'jan'fa ti qui ña ccupaye israe'su na'suma? ");
INSERT INTO conNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nane Pilatoja in'jan Chigama afa'su nasundeccuyi Jesúsma chi'gapa injama'choni se'pipa afe'fa. Tsa'caen in'jamba tsu ya'caen aindeccunga su. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tsa'ma Chigama afa'su nasundeccuja aindeccunga afafaen'fa bove ñotsse Barrabásma ccupaye iñajan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Barrabásma iñajan'fasi Pilatoja iñajampaña: —Tsama ccupa'ta ¿ma'caen tsoñe qui in'jan'fa israe na'su qquen que'i su'choma? ");
INSERT INTO conNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsonsi tise'paja fundopa afa'fa: —¡Avuja'cconga otipa fi'ttija! ");
INSERT INTO conNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoja su: —¿Jongoesian tsu egaeta tso'an? Tsa'ma tise'paja ti'tsse fundopa su'fa: —¡Avuja'cconga otipa fi'ttija! ");
INSERT INTO conNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsonsi Pilatoja aindeccu tisema chi'ga'fasa'ne in'jamba tise'pa in'jan'cho Barrabásma ccupa. Barrabásma ccupapa Jesúsmajan ma'ppiye manda. Ma'ppi nani'fasi sundarondeccuma manda cuintsu angapa avuja'cconga oti'faye. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsonsi sundarondeccu Jesúsma governaror etti'su rande enttinge'su cuartonga anga'fa. Tsa cuartoja “pretorio” qquen inisecho'cho. Tseccunga angapa poiyi'cco sundarondeccuma ttu'sesi bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tsa'caen bopa Jesús opipa'chonga cu'a sarupai'ccu oppoen'fa. Toya'caen boicco nojama'qque otifaccuve ugapa tisenga otifaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsa'caen tsomba chigambian co'feye ashaen'fa: —¡Ti'tsse'tsse canseja israe na'su! ");
INSERT INTO conNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Qquen supa tise tsovema caofa'ccoi'ccu ochhachha'fa. Tsomba attupoen'fa. Toya'caen tisenga ccarupa na'suma iñajanqquia'caen qquen tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsa'caen co'fe nanimba cu'a sarupama oshichhaemba ñoa'me tise ondiccu'jema ondiqquian'fa. Tsa'caen ondiqquiamba avuja'cconga otiye somboen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sombopa jayipa fae tsandie, Simón, tise nasipane jiña'choma cachui'fa. Tsaja Cirene'su a'i, Alejandro yaya tsu. Tise faesu du'shuja Rufo. Tsa'caen cachuipa manda'fa cuintsu Jesús avuja'ccoma opipa angaye. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsomba Jesúsma anga'fa Gólgota ccotta'cconga. Gólgota qquenda tsu su tsove tsu'tta. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tseni napipa iñe'sune vinoma mirra seje'pai'ccu eyeppupa cui'ña qquen tson'fasi Jesúsja in'jambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsa'caen tsomba Jesúsma oti'fa avuja'cconga. Oti ccutsiamba tise ondiccu'je'cho sarupama isupa attufaen'fa. Gana qquen co'fe'fa majan jongoesuma isu've'se. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tsa'caen a las nueveqquia'ca'ni Jesúsma avuja'cconga oti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús tsove omba'ttinga tise egae tsincon'chove su'choma avuja'cconga oti'fa. Qquen tsu tevaen'fa: Vaja Jesús, israendeccu na'su. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Toya'caen Jesúsi'ccu dos ccanambandeccuma'qque fae'ngae oti'fa. Nane fa'ema avuja'cconga otipa Jesús tansinfanga ccutsian'fa. Faesumajan Jesús pavefanga ccutsian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tsa'caen tsu tson'fa Chiga Tevaen'jen suqquia'caen: “Tise'qque te egae tsincon'su.” ");
INSERT INTO conNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aindeccu majan tsangae panshanjimba Jesúsma camba tisu tsovema fenonomba afase'fa qquen supa: —¡Ja! Queja Chiga ettima osaemba tres a'tangae ccase ñoñañe qquen su'chota ");
INSERT INTO conNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡tisuma ccushaemba avuja'cco'ye andeja! ");
INSERT INTO conNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Toya'caen Chigama afa'su nasundeccu, Chiga manda'choma atesiansundeccu'qque tsa'caen tisema afasepa su: “Cca'imajan ccushaen. Tsa'ma tisuma ccushaeñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tiseja Cristo, israe'su na'su, qquen tsu su. Tise ja'ño avuja'cco'ye andesi atte'ta gi tise've in'jan'faya.” Toya'caen Jesúsi'ccu pporotsse avuja'cco'ni dusesundeccu'qque tisema afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Enttinge a'ta pa'cco ande'ye tsu sintsse coseqquia'ca'en da. Sintsse dapa ondusesi ccase coe'jeja de. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tayo ondusesi Jesúsja fundondo'e afapa su: —Elí, Elí, ¿lema sabactani? —qquen tsu su: Ña Chiga, ña Chiga, ¿jongoesie qui ñama cati'je? ");
INSERT INTO conNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Majan tse'tti ccutsusundeccu tise su'choma pañamba su'fa: —Tiseja Chiga Aya'fama afa'su Elíasve tsu ttuse'je. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tse'faei'ccuyi fa'e tse'tti'su buttopa chanchanchan'choa'nga inzatssia vinoma tssipoemba canttini'cconga ejiamba Jesús aya'fanga canjaen'fa. Tsa'ma cca'indeccuja su'fa: —Cuintsu antteja. Jinge ron'dapa atteye ma'caen Elías tisema ccushaen'me'se. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsonsi Jesús ccase fundondo'e afapa pa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tise pasi tse'faei'ccuyi Chiga etti'su Chigai'ccu cachuicco'je'cho cuartoma picco'je'cho sarupa'qque chittain ja. Sefane chitta ashaemba andepaningae chittain ja. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sundaro capitán tse'tti Jesúsma can ccutsu'su Jesús ma'caen fundopa pa'choma attepa qquen su: —Va tsandieja ñoa'me Chiga Dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Toya'caen majan pushesundeccu biane can'boen ccutsu'fa. Tise'pa'su tsu María Magdalena, Salomé, faesu María –tsa Santiago chu'ambe, toya'caen Josémbe mama. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nane tsendeccu Jesús Galileani jacansi fae'ngae jacan'fa. Jacamba fuitecan'fa. Toya'caen faesu pushesundeccu, Jesúsi'ccu Jerusaléni ji'chondeccu, can'boen ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsonsi tayo sime dasi tsa a'ta pa'ccoma ñoñaña'cho a'ta, sema'ma'qquia a'tave napijisi ");
INSERT INTO conNTpo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José, Arimatea canqque'su a'i ji. Tsaja israe nasundeccu bo'fa'cho'su. Tiseja ño'amba Chiga tise aindeccuma mandaya'cho a'tave tsu ronda'je. Tsa'camba dyombe'yi Pilatonga japa Jesús ai'vove iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tsonsi Pilatoja “¿Tayo ti pa?” qquen asi'ttaemba capitáma ttu'sepa iñajampaña: —¿Tayo ti pa Jesúsja? Qquen susi ");
INSERT INTO conNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","capitánjan su: —Ju, tayo tsu pa. Tayo pa qquen pañamba Pilatoja manda Jesús ai'voma cuintsu Josénga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Afesi José ñotssia tototssia sarupama chavapa Jesús ai'voma avujacco'ye andiamba findi. Findipa fattocco changove ñoña'cho atu'ttinga a'tu. Tsomba rande patuma mutsinoemba chango sombo'ttima picco. ");
INSERT INTO conNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, faesu María –tsa José mama– ma'ttinga a'tu'choma atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sema'ma'qquia a'ta pasasi María Magdalena, Salomé, faesu María –tsa Santiago mama– ñome'bama chava'fa japa Jesús ai'voma onjoeña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cosepa sinte, faesu avujaquive a'tasi atu'ttinga ja'fa. Chiga tseyi deji'ni napipa ");
INSERT INTO conNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","tisupapora su'je'fa: —¿Majanda sombo'ttima patu randei'ccu picco'choma joqquitssiaña? Ingija osha'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tsa'ma tsa'caen su'jettie atu'ttinima camba atte'fa tsa rande patuma tayo joqquitssian'choma. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsa'cansi ai'yembe ca'nimba chu'a tsandiema attepa dyo'fa. Nane tsaja bia'a totoa ondiccu'jema ondiccu'chopa atu'tti tansinfani dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dyo'fasi tsandieja tise'pama su: —Dyombe can'faja. In'jan gi que'ija avuja'cconga fi'tti'fa'cho Jesúsve qui ttattacan'fa. Tsa'ma tiseja ccase qquendya. Va'ttija me'i'on. Jipa tise ccui'ttima can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Can'gipa japa tisema shondosundeccunga, Pedronga'qque conda'faja: Ccase qquendyapa tise tayoe suqquia'caen que'ima o'tie tsu Galileani jaya. Tseni japa qui tisema atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tsa'caen susi pushesundeccuja atu'ttie sombopa buttopa jaja'fa. Nane ttun'dundu'je'e dyopa majangayi'qque conda'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesúsja cuna avujaquive a'ta ji'ni qquendyapa o'tie María Magdalenanga attian, tise siete cocoyave joqquitssian'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tsaja Jesúsma tsa'caen attepa ja Jesúsi'ccu jacansundeccunga condaseye. Tsendeccuja ñombi'yepa ina'jen'fa'ni jipa condase. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tsa'ma Jesúsja canse, María tisema atte qquen susi paña'ma in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsomba ccase Jesús ccaningae attian, dos a'i, tsaiqui'ye jayi'fa'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsendeccuja, Jesús tsu, qquen in'jamba toequi ja'fa cca'indeccunga condaye. Tsa'ma japa condase'fasi shondosundeccuja tise'pama'qque paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsomba omboe Jesúsja tisema once shondosundeccunga attian mesani an dyai'fa'chonga. Tsa'caen attiamba tise'pa in'jan'fambi'choane iyu'u. Nane cca'i attepa, “tayo qquendya” qquen conda'fasi injama'cho shacapa in'jan'fambi'choane tise'pama iyu'u. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsomba su: —Poi andenga japa va ccushaya'chone ñotsse condase'choma poiyi'cco a'inga candusian'faja. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Majan va ñotsse condase'choma in'jamba fetiye'chota ccushaya'cho. Tsa'ma majan in'jambi'choa'ta catiyeya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Toya'caen va canjaen'chota tsu fuiteya majan ñame in'jan'fa'choma: ña inisema afapa tsu cocoyama joqquitssian'faya; faesu aya'fangae'qque tsu afa'faya; ");
INSERT INTO conNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","iyoma tivei'ccu indi'ni'qque tisema sinttuya'bi; paqque'su seje'pama cu'i'a'qque paji'suve daya'bi; toya'caen pajisundeccuma tivei'ccu pporae'ninda ccusha'faya. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pan tsa'caen afa nanimba Na'su Jesúsja Chiga sefacconi ansunde. Ansundepa ñoa'me na'suve dapa Chiga tansinfanga dyai. ");
INSERT INTO conNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsa'caen jasi tisema shondosundeccu poi andenga japa ccushaya'chone ñotsse condase'choma candusian'fa. Tsa'caen candusiansi Na'su Jesús tise'pama fuite. Nane sefacconi'su canjaen'choma attian tise'pa su'cho ñoa'me Chiga su'cho qquen canjaeñe. Tsangaeyi.");
INSERT INTO conNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","In'jan'cho Teófilo: Majan a'i tseyi me'ttia'ye Jesúsi'ccu can'jemba osha'choma attepa va ñotsse condase'choma inginga conda'fa. Tsain'bio a'i pañamba pa'ccoma tansintsse tevaen'fa. Ña'qque bo'tssingae osha'choma ñotsse atesupa ja'ño asi'ttaemba gi in'jan tansintsse quenga tevaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Qquen tevaensi qui tansintsse que osha'chove paña'choma atesuya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tayopi Herodes Judea ande na'suite Chigama afa'su Zacaríasja can'jen. Tisei'ccu fae'ngae Chigama afaye semasundeccuja Abiasundeccu tsu. Zacarías pushe'qque Chigama afa'su Aarón aindeccu'su pushesu tsu. Tise iniseja Elisabet. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tsendeccuja Chigave in'jamba ño'a'fa. Pa'cco Chiga manda'choma ñotsse pañamba shaca mecho canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabetja du'shuve isumbe'yi coenza ccasheve da. Zacarías'qque ccashe'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tseyi tise Abiasundeccu Chiga ettini semajeinte Zacarías'qque Chigama afa'suve sema'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chigama afasundeccu in'janqquia'caen quini'ccocho'ccoma attufaen'fa majan Chiga ettinga ca'nimba ñome'bama oque oraeña'chove atesuye. Tsequi a'ta tsu quini'ccoja canjaen Zacarías ca'niña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías ca'nimba ñome'bama oque oraen'jen'ni poiyi'cco a'i tsotefanga ccutsupa Chigama iñajan'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsa'caen Zacarías tisuyi ca'nisi Chigama sefacconi'su shondo'suja tisenga attian ñome'bama oque'je'chombe tansinfani ccutsupa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacaríasja tisema attepa asi'ttaemba dyo. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tsa'ma Chigama sefacconi'su shondo'suja tisema su: —Dyojama Zacarías. Tayo tsu Chiga Quitsaja que iñajan'choma paña. Que pushe Elisabetja tsandie du'shuve tsu isuya. Tisema qui inisian'faya Juanme. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Que'i qui avujatssi'faya. Tisema isusi tsain'bio a'i'qque avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nane Tiseja Na'su Chiga joccapitssia a'iya tsu. Osha'cho ccusianqque'suma tiseja cu'iya'bi. Tsa'ma toya isumbi'te tsu Chiga Qquendya'pa tisenga ca'nimba in'jaeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Du'shuja coenzave dapa tsu tsain'bio israendeccuma in'jaeña cuintsu Chiga Quitsama tise'pa Na'suve tta'tta'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tiseja Na'suma o'tie tsu jiya. Tayopi'su Chiga Aya'fama afa'su Elías injama'choma an'bianqquia'caen tise'qque osha'choma oshaya. Tiseja aindeccuma in'jaeña cuintsu yayandeccu tise'pa dushundeccuma in'jan'faye; cuintsu egae tsinconsundeccu'qque ño'a a'i in'jan'chove ttatta'faye. Tsa'caen aindeccuma in'jaensi tise'paja Na'suma shondo'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tsa'ma Zacaríasja Chigama shondo'suma su: —¿Ma'caen gi in'jaña que su'choja tansintssia've? Ñajan coenza ccashe'ye. Ña pushe'qque coenza ccashe. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tsa'caen iñajampañasi Chigama sefacconi'su shondo'suja su: —Ña gi Gabriel. Ña gi Chiga can'jeni ccutsu'cho. Tiseja ñama moen va ñotsse condase'choma quenga condaseye. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tsa'ma ¡que canjan! Ña suqquia'caen tsu ñoa'me tsoña. Tsa'ma queja ña su'choma in'jambipa qui ayafambie dapa can'jeña que pushe du'shuma isuya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tsa'caen condase'je'ni aindeccuja tsotefani Zacaríasve ro'ndá can'jen'fa. Junde sombombisi asi'ttaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tsa'caen asi'ttaen'jen'fani Zacaríasja sombopa afaye oshambipa tise tivei'ccu canjan'jaen. Tsa'caen afaye oshambisi poiyi'cco a'i in'jan'fa tise Chiga ettini can'jemba sefacconi'su attian'choma atte'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsomba Zacarías Chiga ettini sema'jen'choma nanimba tise tsaoni ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Omboe tise pushe Elisabet surie dapa cinco ccovuve tsaoni can'jen. Can'jemba qquen in'jan: ");
INSERT INTO conNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ñajan du'shu mechopa ansangé can'jen. Tsa'ma Na'su Chiga ñama in'jamba ñama ñotsse tson cuintsu cca'i ñama afambe can'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis ccovu pasasi Chigaja Tisema sefacconi'su shondo'su Gabrielma mandamoen Galilea ande'su Nasaret canqqueni. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mandasi ja, chu'a pushesu, Maríanga condaye. Tsaja, toya tsandiema atesumbi'choa. Tsa'ma fae tsandie, José, tisema pusheye tayo iñajan. Joséja tayopi'su israe Na'su David a'i. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrielja jipa Maríama ttu'sepa su: —¡María! Que qui Chiga in'jan'cho. Chigaja quei'ccu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsama pañamba Maríaja injama'choni dyo. Jongoesie tsa'caen chigambian'chove atesumbipa asi'ttaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tsa'caen dyosi Chigama sefacconi'su shondo'suja ti'tsse condase: —Dyombe canjan, María. Chigaja ñoa'me quema ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Surie dapa qui tsandie du'shuve isuya. Tisema qui inisiaña Jesúsve. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tise tsu joccapitssiaya. “Joccapitssia Chigambe Dutssi'ye” qquen tsu poiyi'cco tisema afa'faya. Nane Tayopi'su Na'su Davidnga mandaye antteqquia'caen Na'su Chigaja tisenga'qque antteya cuintsu na'suve dapa mandaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tsangae tsu tiseja israe aindeccuma manda'jeya. Tise na'suve da'choja minga'ni'qque pasaya'bi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsama pañamba Maríaja su: —¿Ma'caen tsu tsa'caen tsoña ñajan tsa'ndu mechoamajan? ");
INSERT INTO conNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tsa'ma Chigama sefacconi'su shondo'suja su: —Chigaja osha'choma joccapitssiapa osha'choma oshacho. Chiga Qquendya'pa quenga ca'nisi Joccapitssia Chigaja quema oppoeña. Tsa'caen oppoensi que du'shuja ñoa'me egave mechosi tsu Chiga Dutssi'ye qquen su'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Toya'caen que antian coenza Elisabet ccasheve dajipa surie da. Tsa du'shuve mechoa qquen su'cho tsu ja'ñojan surie dapa seis ccovuve can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nane Chigaja osha'choma oshacho. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsonsi Maríaja su: —Dasu'. Ña gi Na'su Chigama shondo'su pushesu. Cuintsu Tiseja que suqquia'caen ñanga tsonjan. Tsa'caen susi Chigama sefacconi'su shondo'suja ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsonsi Maríaja ñoñamba Judea ande'su ccotta'cco'su canqqueni pasia'su ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Japa Zacarías tsa'onga ca'nimba Elisabetma chigambian. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María chigambian'choma Elisabet pañasi tise du'shuja ttopa'ye quia'me oya. Tse'faei'ccuyi Chiga Qquendya'pa in'jaensi ");
INSERT INTO conNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabetja quia'me afapa su: —Quema tsu Chigaja poiyi'cco pushesuma ti'tsse'tsse injancho. Que du'shuma'qque tsu ñoa'me injancho. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ña na'su chan ñama can'su jisi gi ñoa'me avuja. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nane que chigambian'choma ña pañasi tsu tse'faei'ccuyi ña du'shu'qque avujapa ña ttopa'ye quia'me oya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chigaja Tise su'choma ñoa'me tsoña. Tsama pañamba in'jamba qui ñoa'me avujatssiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsonsi Maríaja su: —Ña injama'choi'ccu gi Na'su Chigama ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chiga ñama ccushaen'su can'jensi tsu ña qquendya'pa'qque avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ña gi utu'ccoa Chigama shondo'su. Tsa'ma Chigaja ñama attepa ñotsse in'jan. Tsa'cansi poiyi'cco a'i tsu ja'ño, jai'ngae'qque conda'faya ma'caen Chiga ñama ñotsse in'jan'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tiseja Joccapitssiapa ñama ñotsse tson. Tise inise tsu Ño'a. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Poiyi'cco majan Tise've in'jamba canse'nijan tsendeccuma tsu mendeyeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A'i quin'an tisu tivema canjaenqquia'caen Chigaja osha'choma oshapa canjaen. Aindeccu “Ña gi ño'a” qquen in'jan'ni'qque Chigaja tise'pama joqquitssian maña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tiseja Nasundeccuma joqquitssiamba bove'ccondeqquiama tsu ti'tsse'tssia've tson. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Qquipoe'sundeccuma o'fianqquia'caen ñotssiama afe. Tsa'ma osha'choma an'biansundeccumajan me'ccoeyi maña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israendeccuja Tisema shondosundeccusi Chigaja tise'pama fuite. Tayopi suqquia'caen tise'pamajan anttembe'yi tsangae mendeye'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tsa'caen Chigaja ingi tayopi'su coenzandeccuma conda. Nane Abraham, tise dushundeccuma'qque tsa'caen fuiteye conda. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maríaja tsa'caen Chigama ñotsse afapa tres ccovuve Elisabeti'ccu can'jemba toequi tise tsaoni ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet du'shuma isuya'cho napisi tsandie du'shuve isu. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pporotsse can'jensundeccu, antiandeccu'qque Chiga tisema ñotsse tson'choma pañamba fae'ngae avuja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho a'ta pasasi israendeccu in'janqquia'caen du'shumbe ttonoma chhiyitevaeñe poiyi'cco a'i bo'fa. Bopa du'shuma tise yaya iniseningae Zacaríasve inisiañe in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tsa'ma chan tsu su: —Me'i. Tsa'cambi. Juanme tsu inisiaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tsonsi tisema su'fa: —Tsa'ma me'i'on tsu que antian tsesu iniseve. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsomba du'shumbe yaya Zacaríasma iñajampañañe in'jamba tivei'ccu canjan'jen'fa cuintsu du'shuma jongoesuve inisiaña'choma condaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsonsi Zacaríasja canjan'jen'choma in'jamba canjan'jen cuintsu tisenga tevaenqque'suma afe'faye. Isupa tevaen: “Tise iniseja Juan.” Qquen tevaensi poiyi'cco a'i asi'ttaemba can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tse'faei'ccuyi Zacaríasja ccase afaye oshapa Chigama ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsonsi pporotsse can'jensundeccuja dyopa can'boen'fa. Tsa'caen tson'chone tsain'bitsse condasecco'fa. Nane pa'cco ccotta'cco'su Judea ande'ye tsa'caen tson'chone condasecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Poiyi'cco majan tsane pañamba injama'choni in'jamba su'fa: —¿Micoña tsu va du'shuja? Chigaja ñoa'me tisema in'jamba fuitepa angacan. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chiga Qquendya'pa tisenga ca'nisi du'shumbe yaya, Zacaríasja, Chiga in'jaensi afa'choma afa: ");
INSERT INTO conNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ñotssi tsu israe Na'su Chiga Quitsa. Tise aindeccuma can'su jipa ccushaemba Tiseja ñotssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tisema shondo'su David omba'su dutssiyendeccu'su quin'an ccushaen'suma ttu'sepa inginga moen. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tayopi Chiga Tisema afasundeccuma in'jaensi tise'paja ingi ccushaya'chone afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ingima iyiccayesundeccu'ye, ingima chi'gasundeccuye'qque Chigaja ingima ccushaeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ingi tayopi'su coenzandeccuma mende'yeya qquen su'chopa tsu tsa'caen tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nane Chigaja Abrahami'ccu condasepa ñoa'me tsoña'choma tansintsse conda. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ma'caen ingija ingima iyiccayesundeccu'ye ccushapa tisema dyombi'tsse shondo can'faya'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tisema shondocamba gi ño'ame dapa tsangae egae tsincombe'yi tisei'ccu can'jen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Que, ña du'shuja, Sefacconi'su Chigama afa'su qui. Tsa'cansi tsu poiyi'cco a'i su'faya: ‘Na'suma o'tie japa tsu Tise jiya'chove ñoñaña.’ ");
INSERT INTO conNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Egae tsincon'choma joqquitssiaña'chone tsu poiyi'cco a'inga condaya cuintsu atesu'faye tsa'caen Chiga a'ima ccushaeña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chiga Quitsa ñoa'me ingima mende'yepa tsa'caen tsoña. Nane a'ta a'taqquia'caen Chiga sefacconi ingima attiaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsa'caen tsu paya'chondeccunga attiaña cuintsu tise'pa sinttia'ni can'jen'choma catipa a'tatssianga ji'faye. Inginga'qque attiaña cuintsu ingi'qque Tise've in'jamba cansepa dyombi'tsse opatsse canse'faye.” Tsa'caen tsu Zacaríasja Chigama ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Du'shu Juan Chigave in'jamba coen. Tayo coemba a'i menia japa bo'tsse tseni can'jen. Nane tise israendeccuma candusiaña'cho napiya'ngae tseni ro'ndá can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ande na'su Agosto na'suite tiseja manda poi ande'su a'ima agattoye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Me'ttia'ye tsa'caen agattoye mandasi Cirenio tsu Siria ande'su governaror. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Poiyi'cco tsu tise a'i canqqueni ja'faya'cho tseni tise'pa inisema tevaensi cuintsu agatto'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tsa'cansi Joséja Galilea ande'su Nasaret canqquene sombopa Judea andeni ja. Joséja David a'ipa Judeani japa Belén canqqueni ja. Tsa canqque tsu tayopi'su Na'su Davidma isu'cho canqque. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nane tise pushe Maríai'ccu tseni tise'pa inisema tevaeñe ja'fa. Maríaja tayo suri. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tsa'cansi toya Beléni can'jen'ni tayo tsu María du'shuma isuya'cho napi. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A'i ana'jen'cho tsa'o panshaen on'basi vaura ettini can'jemba Maríaja tseni tise aishe tsandie du'shuma isu. Isupa sarupai'ccu findipa vaura an'jen'cho cafonga ppiña. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Beléni pporotsse tsu can'jen'fa oveja coirasundeccu. Cose potreroni can'jen'fa tise'pa ovejama coiraye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tse'faei'ccuyi Na'su Chigama sefacconi'su shondo'su tise'panga attian. Attiansi na'su Chiga a'tatssiaja tise'panga chanjun. Tsa'caen chanjunsi ñoa'me dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tsa'ma Chigama sefacconi'su shondo'suja su: —Dyo'fajama. Ñotsse condase'choma condaye gi ji. Poiyi'cco a'i tsu vama pañamba avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ja'ño a'ta tsu David canqqueni que'ima ccushaen'suve isu. Tsaja Na'su Cristo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nane ña su'cho du'shumanda qui atte'faya sarupai'ccu findipa vaura an'jen'cho cafonga ppiña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tise tsa'caen su'je'ni tse'faei'ccuyi tsain'bio Chigama sefacconi'su shondosundeccu tisei'ccu fae'ngae attian'fa. Tsa'caen attiamba Chigama ñotsse afapa su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Sefacconi'su Chigaja ñoa'me ñotssia tsu. Va ande'su aindeccuma ñotsse in'jamba Chigaja in'jan cuintsu poiyi'cco a'i tisupapora ñotsse in'jamba opatsse canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tsa'caen afa nanimba poiyi'cco Chigama sefacconi'su shondosundeccu ja'fasi oveja coirasundeccu tisupaporai'ccu condasecco'fa: —Jinge Beléni jaye. Na'su Chiga va ñotsse tson'choma inginga condase'choma japa atteye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cunshoa'me japa Maríama, Joséma'qque cachui'fa. Tsomba du'shuma'qque atte'fa, vaura an'jen'cho cafonga ppiña'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Du'shuma attepa du'shune tise'panga condase'choma condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Oveja coirasundeccu tsa'caen condase'fasi poiyi'cco pañasundeccu asi'ttaemba can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tsa'ma Maríaja osha'choma in'jamba injama'choni asi'ttaén can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsomba ovejama coirasundeccu toequi japa Chigama ñotsse afa'fa. Nane Chigama sefacconi'su shondo'su ma'caen conda'choma tayo pañamba tsa'caen attepa Chigama avujatsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho a'ta pasasi du'shumbe ttonoma chhiyitevaemba tisema inisian'fa Jesúsve. Tsa'caen tsu Chigama sefacconi'su shondo'suja tayoe conda María toya surimbi'te. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés manda'cho mandaqquia'caen pushesu asettupa onjoña'chone napisi Maríaja onjon. Onjomba du'shu Jesúsma Jerusaléni anga'fa tisema Chiganga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Na'su Chiga manda'cho tsu su: Majan aisheve isu'cho tsandie du'shumajan tsama Chigaja in'jan Tise'beve.) ");
INSERT INTO conNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Toya'caen Na'su Chiga manda'cho tsu manda dos ppuppuju'choma, tsambi'ta dos manambema Chiganga afeye. Tsa'caen manda'chosi María, José tsama afeye ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tsaite Jerusaléni fae tsandie can'jen, tise inise Simeón. Tiseja ño'amba Chigama ñoa'me in'jan. Chiga Qquendya'pa tisei'ccu can'jensi tiseja israendeccuma ccushaeña'chove ronda'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Toya'caen Chiga Qquendya'pa tisema in'jaemba conda, tiseja toya pambi'te Na'su Chigambe Cristoma atteya. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsa'caen condapa in'jaensi Chiga ettini ja. Tseni japa can'jen'ni María, Joséi'ccu du'shu Jesúsma i'fa manda'cho suqquia'caen tisema tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tsa'caen i'fasi attepa Simeónjan du'shuma opipa Chigama ñotsse afapa qquen su: ");
INSERT INTO conNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Na'su, ja'ñonda gi avujatsse paya. Que suqquia'caen ");
INSERT INTO conNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","gi Que ccushaen'suma tayo atte. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Queja poiyi'cco a'inga tisema moen cuintsu attepa in'jan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nane tiseja israembindeqquianga attiansi tsendeccu'qque queve in'jan'faya. Tise'qque israendeccu'susi israendeccuja ti'tsse'tssia've dapa avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón tsa'caen susi José, María pañamba can'boen ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsonsi Simeón tise'pama ñotsse afapa du'shumbe chan Maríama su: —¡Que canjan! Va du'shuve in'jambi'ta tsain'bio israendeccu tsu qque'faya. Tsa'ma cca'indeccuja tise've in'jamba ti'tsse'tssia've dapa tsu avuja'faya. Aindeccu tisema afase'fasi ");
INSERT INTO conNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","qui dansan'choi'ccu que injama'choma quiccu'fa'ma'caen injama'cho tsosipie ñombi'yeya. Nane tsain'bio a'i tsu tise'pa injama'cho tsosipie in'jan'choma tsa'caen poiyi'cconga canjaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Toya'caen Chiga Aya'fama afa'su pushesuja Chiga ettini can'jen. Aser aindeccu'su Fanuel onque'nge tsu. Tise iniseja Ana. Tiseja ñoa'me ccashe, ochenta y cuatro canqque'fave tsu an'bian. Tseyi coemba tsa'ndupa siete canqque'fave can'jensi tise tsa'nduja pa. Tsa'caen pan'jaemba ja'ñojan Chiga ettini can'jen. Ni sombombi. Tsa'ma a'ta, cose'qque tseni can'jemba Chigama iñajan'jen. Maqui a'taja ambe'yi Chigama iñaján canse. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón toya José, Maríai'ccu condase'je'ni Ana'qque jipa cachui. Cachuipa du'shuma attepa Chigama ñotsse afapa du'shu Jesúsne Jerusalensundeccunga condaseye ashaen. Condasesi majan Chiga ccushaeña'chove ronda'je'chondeccuja ñotsse paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tsonsi pa'ccoma Na'su Chiga manda'cho mandaqquia'caen tsomba María, José, du'shui'ccu toequi Galileani ja'fa. Tise'pa Nasaret canqqueni japa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Du'shu Jesús coenjimba quinsetssia've da. Chiga tisema ñotsse in'jansi osha'choma atesupa in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús chan, tisema coeña'su yaya'qque poi canqque'fa Jerusaléni jaye atesu'fa Chiga panshaen'cho injienge'cho fiestama panshaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce canqque'fave napiansi ccase tise'pa in'janqquia'caen fiestani jayipa Jesúsma'qque anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiestama panshaemba toequi Galileani jayi'fasi Jesúsja toe Jerusaléni shanda. Tsa'caen shandasi tise chan, tise yaya'qque atesumbe'yi tsu jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jesúsja tayo tise amigondeccui'ccu ja qquen in'jamba jaja'fa. Tsa'caen in'jamba fae a'ta já cosepa tise've ttatta'fa. Antiandeccu, amigondeccuni japa ttatta'ma attembi. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Attembipa toequi Jerusaléni ttattaye ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tsa'caen toequi japa tres a'ta tta'ttá jacamba tisema atte Chiga ettini Chiga manda'choma atesiansundeccui'ccu condasé dyai'choma. Nane atesiansundeccu su'choma pañamba osha'chove iñajampaña'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesúsja osha'choma in'jamba tsa'caen condasesi poiyi'cco majan tisema pañasundeccu can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsa'caen tson'jen'ni Jesús chan, tise yaya'qque tisema attepa can'boen ccutsupa Jesús chanjan su: —Jaricho, ¿jongoesie qui ingima a'tu maña? Tsa'caen que a'tu mañasi ingija ñoa'me ñombi'yepa tta'ttá vana'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tsa'ma Jesús tise'pama su: —¿Jongoesie qui ñame ttatta'je'fa? ¿In'jan'fambi ti qui ñajan ña Quitsa tsaoni can'jemba semaña'cho? ");
INSERT INTO conNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tsa'ma tsa'caen susi tise su'choma ñotsse paña'ma in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsa'caen supa Jesúsja tise'pai'ccu Nasaretni ja. Tseni japa tise'pama ñotsse pañamba canse. Toya'caen Jesús chanjan osha'choma in'jamba tisu injama'choni asi'taén can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesúsja ti'tsse coemba osha'choma atesu. Poi a'i tisema ñotsse in'jan'fa. Chiga Quitsa'qque tisema ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Poi ande'suma joccapitssia na'su, Tiberio César, quince canqque'fave tayo mandasi Poncio Pilato, Judea ande'su governarorve can'jemba manda. Toya'caen Herodesja Galilea ande na'su tsu. Tise quinshin, Felipe tsu Iturea ande na'su. Traconite andema'qque manda. Lisaniasja Abilinia ande na'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chigama afa'su nasundeccuja Anas, toya'caen Caifás'qque. Tsendeccu tsu Chiga ettini manda'fa. Poiyi'cco tsendeccu tsa'caen manda'fasi Zacarías dutssi'ye Juan a'i menia ro'ndá can'jen'ni Chigaja Tisu Aya'fai'ccu tisema in'jaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsa'caen in'jaensi pa'cco Jordán na'en utufa'ye candusiancan, a'i cuintsu tisu egae tsincon'choma catipa fettiye'faye, Chiga tise shacama aqquepoeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tsa'caen tsomba tsu tayopi'su Chiga Aya'fa afa'su Isaías qquen tevaenqquia'caen tson: A'i aya'fama qui paña'faya a'i menia'ñe qquen fundo'je'choma: “Na'su jiya'chove ñoña'faja. Tise tsaiquima tansianqquia'caen ñoña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sinjun'ccumajan oviviya'cho. Ccotta'ccomajan joqquitssiamba sefaccoa andema fae'ngaeña'cho. Tsaiqui cca'rutticcoa'ma tansiaña'cho. Ande ccutticcoa'ma ovivipa fae'ngaeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nane tsa'caen tsu injama'choma ñoñaña'cho poiyi'cco a'i Chiga tise'pama ccushaeña'choma in'jañe.” ");
INSERT INTO conNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tsain'bio a'i Juanga fetiyeye bo'fa. Tsa'caen bo'fasi Juanjan tise'pama iyu'upa su: —Ñoa'me qui iyo dushundeqquia'can'fa. ¿Majan tsu que'imajan dyoña? Chiga iyicca'yepa fi'ttiya'choma pañamba ¿fetiyepa ccushaye'ta ti qui in'jan'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Injama'choni egae tsincon'choma catiye qquen in'jamba tsu egae tsincombe'yi canse'faya'cho. Aqquia injanga “Tayopi'su Abraham ingi yayasi gi ccusha'faya” qquen su'fajama tisupa injama'choma ñoquiañe. Israendeccu'qque cca'indeccuma bove ñotssimbi tsu. Chigaja in'jan'da va patundundu'ye a'ive tsoñe osha Abraham dushundeccuve dapa cuintsu Tisema iñajan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nane quini'cco ñotsse nambisi a'ija tsama ttuttupa si'tsive oque'faya. Tsa'caen tsu Chigaja ttuttupoeñe ovacco'choma tsuiñaqquia'caen tayo ñoña que'i injama'choma somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tsonsi a'i bo'fa'chondeccuja Juanma iñajampaña'fa: —Tsa'caenda ¿jongoesuve gi tson'faya? ");
INSERT INTO conNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanjan tise'pama su: —Tisupapora ñotsse tson'faja. Dos contome an'bian'da conto mechoa'nga fae'cco afeja. Aña'choma an'bian'da attufaen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Govierno impuestoma isusundeccu'qque Juanga fetiyeye ji'fa. Juanma tsu iñajampaña'fa: —Atesian'su, ¿jongoesuve gi ingija tson'faya? ");
INSERT INTO conNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan tise'pama su: —Govierno isuye manda'choma pan'sha'en isu'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Toya'caen sundarondeccu'qque jipa iñajampaña'fa: —¿Jongoesuve gi ingija tson'faya? Juanjan su: —A'ima afopoemba cca'na'fajama. Ni cca'indeccuma tssai'fajama ti'tsse corifin'dima itsaye. Tsa'ma que'i na'su afepoen'choi'ccuyi opatsse canse'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Poiyi'cco a'i Cristo jiya'chove ro'ndá canse'fa. Tsa'camba injama'choni “¿Juanda ti Cristo?” qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tsa'ma Juanjan poiyi'cconga conda: —Ñajan tsa'ccui'ccu gi que'ima feti'je. Tsa'ma ñama ti'tsse'tssia tsu jiya. Ñajan utu'ccoa. Nane shaca gi tise sapato uga'choma ccupa'suve ca'niñe. Tise jipa tsu Chiga Qquendya'pai'ccu que'ima fetiya. Tsambi'ta si'ngei'ccu fetiqquia'caen tsu injama'choma somboeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigoma qque'shopa fingiain'ccu ttonoma ufattovaenqquia'caen tiseja jiya fundui'sui'ccu giya'tsse funduipa ñotssia trigoma boñaqquia'caen tise a'ima ñoñañe. Tsa'ma trigo ttonoma oque catiqquia'caen tise've in'jambindeqquiama tsangae catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tsa'caen candusiamba Juanjan Cristo jiya'chone ñotsse condase'choma a'inga conda. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Toya'caen Juanjan ande na'su Herodesma iyu'u. Herodesja osha'cho egave tsomba tise quinshimbe pushe, Herodíasma, itsapa fae'ngae can'jen. Tsa'caen egae tsinconsi Juanjan tisema iyu'u. Iyu'usi Herodesja ti'tsse egae tsincomba iyicca'yepa Juanma picco'je'cho ettinga ca'niamba picco. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanjan toya piccoyembi'te poiyi'cco a'ima fetipa Jesúsma'qque feti. Jesús fetiyepa Chigama iñajansi Chigaja sefaccoma fetta. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Fettasi Chiga Qquendya'pa ppuppuju'choa'caen attiamba Jesúsnga ande. Tsonsi sefaccone afa'choma paña'fa qquen su'choma: —Que qui ña in'jan'cho Dutssi'ye. Ñoa'me gi quema ñotsse in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesúsja treinta canqque'fave napiamba a'ima atesiañe ashaen. Tiseja José dutssi'ye qquen tsu poiyi'cco a'i in'jan'fa. Joséja Elí dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat dutssi'ye. Matatja Leví dutssi'ye. Levíja Melqui dutssi'ye. Tsaja Jana dutssi'ye. Tsaja José dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tsaja Matatías dutssi'ye. Tsaja Amós dutssi'ye. Tsaja Nahúm dutssi'ye. Tsaja Esli dutssi'ye. Tsaja Nagai dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tsaja Maat dutssi'ye. Tsaja Matatías dutssi'ye. Tsaja Semei dutssi'ye. Tsaja Josec dutssi'ye. Tsaja Judá dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Tsaja Joanán dutssi'ye. Tsaja Resa dutssi'ye. Tsaja Zorobabel dutssi'ye. Tsaja Salatiel dutssi'ye. Tsaja Neri dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tsaja Melqui dutssi'ye. Tsaja Adi dutssi'ye. Tsaja Cosam dutssi'ye. Tsaja Elmadam dutssi'ye. Tsaja Er dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tsaja Jesús dutssi'ye. Tsaja Eliezer dutssi'ye. Tsaja Jorim dutssi'ye. Tsaja Matat dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tsaja Leví dutssi'ye. Tsaja Simeón dutssi'ye. Tsaja Judá dutssi'ye. Tsaja José dutssi'ye. Tsaja Jonam dutssi'ye. Tsaja Eliaquim dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Tsaja Melea dutssi'ye. Tsaja Mena dutssi'ye. Tsaja Matata dutssi'ye. Tsaja Natán dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tsaja David dutssi'ye. Tsaja Isaí dutssi'ye. Tsaja Obed dutssi'ye. Tsaja Booz dutssi'ye. Tsaja Sala dutssi'ye. Tsaja Naasón dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Tsaja Aminadab dutssi'ye. Tsaja Admin dutssi'ye. Tsaja Arni dutssi'ye. Tsaja Esrom dutssi'ye. Tsaja Fares dutssi'ye. Tsaja Judá dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tsaja Jacob dutssi'ye. Tsaja Isaac dutssi'ye. Tsaja Abraham dutssi'ye. Tsaja Taré dutssi'ye. Tsaja Nacor dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tsaja Serug dutssi'ye. Tsaja Ragau dutssi'ye. Tsaja Peleg dutssi'ye. Tsaja Heber dutssi'ye. Tsaja Sala dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tsaja Cainán dutssi'ye. Tsaja Arfaxad dutssi'ye. Tsaja Sem dutssi'ye. Tsaja Noé dutssi'ye. Tsaja Lamec dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tsaja Matusalén dutssi'ye. Tsaja Enoc dutssi'ye. Tsaja Jared dutssi'ye. Tsaja Mahalaleel dutssi'ye. Tsaja Cainán dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tsaja Enós dutssi'ye. Tsaja Set dutssi'ye. Tsaja Adán dutssi'ye. Adánjan Chiga dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tsomba tse'i Chiga Qquendya'pa Jesúsnga ca'nimba in'jaen cuintsu a'i menia japa ");
INSERT INTO conNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","cuarenta a'ta can'jeñe. Tseni can'jensi cocoya na'su Satana tisema qqueñacañe ji. Jesús ambe'yi can'jemba ñoa'me qquipoe'susi ");
INSERT INTO conNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satanajan Jesúsma su: —Queja ñoa'me Chiga Dutssi'ye'ta mandaja cuintsu va patu panme dasi añe. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesúsja tisema su: —Chiga Tevaen'jenga qquen tsu tevaen: “A'ija aqquia panmeñi amba canse'faya'bi. Tsa'ma Chiga Aya'fa in'jaensi tsu canse'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsonsi Satanajan Jesúsma ccotta'cco se'fatssia tansin'choni angapa tse'faei'ccuyi pa'cco a'i can'jen'cho andema canjaemba ");
INSERT INTO conNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","conda: —Ñanga anttesi gi pa'cco va ande na'su. Majanga ña in'jan'da tsanga gi afeye osha. Tsa'camba pa'tssima quenga afesi qui ti'tsse'tssia na'suve dapa mandaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Que ñanga ccarupa iñajan'ninda tsu pa'cco vaja quembe. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesúsja pañamba su: —Satana, biani jaja. Chiga Tevaen'jenga qquen tsu tevaen: “Na'su Chiga Quitsaveyi iñajaña'cho. Tise'veyi shondocaña'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsonsi Satana Jerusaléni Jesúsma angapa Chiga etti omba'su tsutopanga ccutsiamba su: —Queja ñoa'me Chiga Dutssi'ye'ta vane butto amppija. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nane Chiga Tevaen'jenga qquen tsu tevaen: Chigaja Tisema shondosundeccuma manda quema coiraye. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tise'pa tivei'ccu quema ñotsse angacaña que tsu'tte patunga desi zuccopanshan amppisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tsa'ma Jesúsja tisema su: —Chiga Tevaen'jenga qquen tsu su: “Chigaja que Na'su tsu. Tisema qqueña qquen tsonjama.” ");
INSERT INTO conNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tsa'caen Satana Jesúsma qqueña qquen tson'ma oshambipa japa ronda'je ja'i ccase qqueñacañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chiga Qquendya'pa tisema in'jaemba quiñaensi Jesús toequi Galileani shanda. Tseni jasi poiyi'cco pporotsse can'jensundeccu tisene pañamba condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nane Jesús tise'pa Chigane atesian'jen'ttinga atesian'jensi poiyi'cco a'i tisene ñoa'me ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsonsi Jesús Nasaretni ja, tise chuite can'jemba coeni. Tise atesuqquia'caen Sabado a'ta Chigane atesian'jen'ttinga japa ca'ni. Ca'nimba Chiga Tevaen'jema camba afaye ccutsusi ");
INSERT INTO conNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chigama afa'su Isaías tevaen'jema tisenga afe. Isupa fettapa tta'ttapa atte qquen tevaen'choma: ");
INSERT INTO conNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Chiga Qquendya'pa tsu ñama in'jaemba manda va ñotsse condase'choma va'chandeccunga candusiañe. Ñama manda injama'choni ñombi'yesundeccuma ccushaeñe. Ñama manda indiye'chondeccunga tise'pama ccupaya'chone condaye. Ñama manda cuintsu binindeccu atte'faye. Ña gi noñangiañesundeccuma ccushaeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na'su Chiga tsu a'ima in'jamba ja'ño fuite'je. Tsane gi condaseye ji. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsomba Jesúsja tevaen'jema findipa tevaen'jen na'sunga afepa dyai a'ima candusiañe. Dyaisi Chigane atesian'jen'ttini can'jensundeccu poiyi'cco tisema can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Can'boen'fasi Jesúsja qquen su: —Ja'ño a'ta tsu va que'i paña'jen'cho Chiga Tevaen'jen su'choja tayo napi. Ñane tsu condase. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesús ñotsse afa'je'choma poiyi'cco pañasundeccu tisene ñotsse afa'fa. Tsa'caen ñotsse afapa can'boemba su'fa: —¿Vaja José dutssi'yembi ti? ");
INSERT INTO conNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsonsi Jesúsja tise'pama su: —Ñoa'me gi in'jan que'ija asi'ttaemba qui tayopi'su condase'cho suqquia'caen ñama qquen su'faya: “Ccushaen'suta, tisuma o'tie ccushaenjan.” Toya'caen que'ija ña Capernaumni japa tson'choma pañamba in'jan'fa vani'qque ña tsa'caen canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Toya'caen Jesúsja ti'tsse candusiamba su: —Ñoa'me gi que'inga su, tisu andeni jisi tsu tisu aindeccu tsa Chiga Aya'fama afa'suma chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tansintssi tsu tayopi'su Elíasne condase'cho. Tise can'jeinte tres canqque'fa pa'cco toya'caen faesu enttingeve unjin tuimbisi poiyi'cco a'i qquipoe'su'fa. Tsain'bio tsandupajen'chondeccu israe andeni can'jemba qquipoe'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tsa'ma Chigaja Elíasma manda cuintsu fae tsandupajen'choveyi fuiteye. Tsaja israe ande joccani Sidón ande'su Sarepta canqqueni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Toya'caen Chigama afa'su Eliseo can'jeinte tsain'bio na congomba pajisundeccu israe andeni can'jen'fa. Tsa'ma Chigaja tsendeccuma ccushaembisi ccushambe canse'fa. Tsa'ma faesuma, Siria ande'su Naamámeñi tsu Chigaja ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ya'caen susi pañamba Nasaretsundeccu iyicca'yepa ");
INSERT INTO conNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jesúsma indipa canqque'ye joqquitssian'fa. Tsa canqqueja ccotta'cconi jin. Tsa'cansi Jesúsma indipa utufani anga'fa tsene cofetta amppiamoensi cuintsu paye. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tsa'ma Jesúsja tise'pa enttinge'ye panshamba ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsomba Jesúsja faesu Galilea'su canqqueni ja. Capernaum canqqueni japa can'jemba Sabado a'ta a'ima atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ñoa'me na'sia'caen atesian'jensi poiyi'cco a'i pañamba asi'ttaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tse'tti Chigane atesian'jen'ttini tsu cocoya ca'ni'cho a'ija can'jen. Tiseja fundondo'e qquen afa: ");
INSERT INTO conNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ingima noñangianjama Jesús Nasareno'su. ¿Ingima fi'ttiye ti qui ji? Quemanda gi atesu. Nane queja Chiga in'jan'cho qui. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsa'ma Jesúsja tisema iyu'upa su: —Ziyapa tsa a'i'ye somboja. Tsonsi poiyi'cco a'i camboen'jen'fa'ni cocoyaja a'ima pan'jaensi andenga amppi. Tsa'caen amppisi a'ima iñacaembe'yi somboin ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Somboin jasi a'i bo'fa'cho can'boemba condasecco'fa: —¿Ma'caen tsu Jesúsja tsa'caen afaye osha? Na'sia'caen quia'me mandasi cocoyandeccu'qque pañamba somboin ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús tsa'caen tsonsi poiyi'cco tsa ande'su a'ija Jesúsne pañamba condasecco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesúsja Chigane atesian'jen'tti'ye sombopa Simón tsaoni ja. Simón chanccasheja ajepa ccui. Si'ngia'ca'en ajepa ccuisi Jesúsnga conda'fa cuintsu ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús catsepa ajema iyu'usi ajeja chattian. Tse'faei'ccuyi pushesuja quinsetsse ccushapa jangipa poiyi'ccoma cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsa'caen tsonsi tayo chiga amppisi poiyi'cco a'i tise'pani'su pajisundeccuma i'fa. Osha'cho paqque'sui'ccu paji'fa'choma isi Jesúsja tise tivei'ccu tise'pama pporaemba ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jesús mandasi cocoyandeccu'qque tsain'bio a'i'ye sombombopa qquen fundo'fa: —¡Queja Chiga Dutssi'ye qui! Tsa'ma Jesúsja cocoyama iyu'upa afaye se'pi. Cocoyandeccu'qque atesu'fa Jesúsja Chiga in'jan'cho Cristo tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cosepa a'tasi Jesúsja Pedro tsaone sombopa a'i menia ja. Aindeccuja tise've tta'ttapa attepa jaye se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tsa'ma Jesúsja su: —Ñanda gi faesu canqqueni jaya'cho tseni'qque Chiga aindeccuve daya'chone condaseye. Tsa ñotsse condase'choma condaseye gi va andeni ji. ");
INSERT INTO conNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsa'caen supa Jesúsja cca'tti cca'tti jacamba Galilea ande'su Chigane atesian'jen'ttinga japa candusian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Fae a'ta Jesúsja Genesaret mar otafani ccutsupa candusian'jen. Tisema pañañe in'jamba aindeccuja panshaen catse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tse'tti avuma vachosundeccu'qque dos rande shavoma tandan dusiamba tise'pa vacho'vama cashi'je'fa. Aindeccuja panshaen catse'fasi Jesúsja tsa shavoma attepa ");
INSERT INTO conNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","otse. Otsepa Jesúsja shavo na'su Simónma afa cuintsu otafane re'riccoe cataemba duseye. Tsonsi shavoccunga dyaipa a'ima atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Atesian nanimba Jesúsja Simónma su: —Mar ti'tsse tso'sinia angapa que vacho'vama ttupa itoyian'faja avuma indiye. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónjan su: —Na'su, pa'cco cose va'chó jaca'ma gi avuma indimbipa quimbi'fa. Tsa'ma que su'ninda gi ña vacho'vama ttuya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tsa'caen supa ttusi tsain'bio avu indiyesi vacho'vaja chittaji. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chittajisi tise'pai'ccu fae'ngae vachosundeccu faesu shavo'ni pporotsse duse'fasi fingi ttu'se'fa cuintsu fuite'faye. Jipa poiyi'cco shavonga avuma on'boen'fa. Ti'tssecan'da tsu poiyi'cco shavo andeccoye'can. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedroja avuma indi'choma attepa dyopa Jesúsnga tsutta'choi'ccu ccaru dyaipa su: —Na'su, ña'ñe joqquitssija. Ñanda gi egae tsincon'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nane Simón, poiyi'cco tisei'ccu can'jensundeccu'qque avuma indi'choma attepa can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tisei'ccu fae'ngae vachosundeccu Juan, Santiago'qque dyopa can'boen'fa. Tsendeccuja Zebedeo dutssiyendeccu. Tsonsi Jesúsja Simónma su: —Dyojama. Ja'ñoñi qui queja avuma ttuqquia'caen a'ima ttu'seya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsonsi tise'pa shavoma ccattufaemba pa'tssima catipa Jesúsi'ccu jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús fae canqqueni can'jen'ni na congomba paji'su tisenga ji. Nane pa'cco ai'vo tsa'caen dapa Jesúsma attepa andenga puntssan ccuipa iñajan: —Na'su, que in'jan'da qui ñama giya'tsse ccushaeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsa'caen susi Jesús tisu tivei'ccu yasapa paji'suma pporaemba su: —In'jan gi ñajan. Giya'tsse qui ccusha. Tse'faei'ccuyi giya'tsse ccushasi ");
INSERT INTO conNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús tisema manda: —Cca'indeccunga condajama. Tsa'ma japa Chigama afa'sunga tisuma canjaenjan. Moisés mandaqquia'caen ccusha'chone afeya'choma afeja cuintsu poiyi'cco a'i que ccusha'choma tsa'caen atesu'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tsa'ma Jesús tson'chone ti'tsse condasecco'fasi tsain'bio a'i bo'fa tisema pañañe. Pajisundeccu'qque bo'fa cuintsu tise'pa paji'choma ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tsa'ma tsa'caen bo'fa'nijan Jesúsja a'i menia japa Chigama iñajan'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Fae a'ta Jesús a'ima atesian'jen'ni fariseo in'jan'chondeccu Chiga manda'choma atesiansundeccu'qque tisenga bo'fa. Nane poi Galilea ande'su canqquene, Judea ande'su canqquene'qque tsu ji'fa. Jerusaléne'qque jipa bopa paña'fa. Tsonsi Na'su Chiga Jesúsma quiñaensi a'ima ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsa'caen a'ima ccushashaen'jen'ni cca'ija ishopa paji'suma Jesúsnga i'fa. Paji'suma tise ana'jen'chonga opi ipa tta'tta'fa ma'caen ca'nimba Jesús tsutteccofanga paji'suma ccuiñañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tsa'ma tsain'bio a'i bo'fasi ca'niañe oshambipa tsao'cco omba'su ppappacconga ansunde'fa. Tsa'o'su patufin'dima shichhapa paji'suma andian'fa tise ana'jen'choi'ccu. A'i enttingenga Jesús tsutteccofanga andiansi ");
INSERT INTO conNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesúsja tise'pa Chigave in'jan'choma in'jamba paji'suma su: —Tsandie, tayo tsu que egae tsincon'cho joqquitssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsa'caen susi Chiga manda'choma atesiansundeccu, fariseondeccu'qque tisupapora iñajampañacco'fa: —¿Jongoesu qquen tsu va a'ija in'jan? Chigayi tsu egae tsincon'choma joqquitssian'su. ¿Tiseja Chiga qquen ti in'jan? ");
INSERT INTO conNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesúsja tise'pa iñajampañacco'fa'choma in'jamba su: —¿Jongoesie qui injama'choni qquen asi'ttaemba iñajampañacco'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tayo gi su: “Que egae tsincon'cho tayo joqquitssi.” ¿Bove aiye'pambi ti qquen suye “Jangipa tsui jaja.”? ");
INSERT INTO conNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tsa'ma Na'su Chigaja antte Sefaccone Ji'cho A'i va ande'su a'i egae tsincon'choma joqquitssiañe. Ñajan Sefaccone jipa tsa'caen oshapa gi que'inga canjaeña. Tsomba Jesús ishopa paji'suma su: —Quema gi manda: Jangipa que ana'jen'choma isupa tisu tsaoni tsui jaja. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tse'faei'ccuyi tiseja jangi. Poiyi'cco camboen'jen'ni tise ana'jen'choma onccamba Chigama ñotsse afapa tisu tsaoni ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsa'caen ccushapa jasi poiyi'cco a'i attepa can'boen ccutsupa Chigama ñotsse afa'fa. Toya'caen dyopa su'fa: —Ñoa'me ccaningae tson'choma gi ja'ño atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsonsi Jesúsja sombopa Levíma atte. Tiseja govierno impuestoma isu'su tsu. Leví impuestoma isu'je'ttini dyaisi Jesús tisema ttu'se: —Ñai'ccu jija. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsonsi Leví jangipa pa'ccoma catipa Jesúsi'ccu ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsomba Leví Jesúsnga pipa poiyi'cco a'ima ttu'se tise tsaoni añe. Tsain'bio govierno impuestoma isusundeccu'qque an'jen'cho mesa jin'tti piyive ccuipa an'jen'fa. Cca'indeccu'qque ccuipa an'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Majan fariseondeccu, toya'caen tsendeqquia'caen in'jamba Chiga manda'choma atesiansundeccu'qque can'jemba camboen'jen'fa. Jesúsma shondosundeccuma attepa iyu'uye ashaen'fa qquen iñajampañamba: —¿Jongoesie qui que'ija va impuestoma isusundeccui'ccu an'jen'fa? Tsendeccuja egae tsinconsundeccu tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Tsama pañamba Jesúsja su: —Pajimbi'choa ccushaen'suma in'jambiqquia'caen ñajan jimbi gi tayo ño'a qquen in'jan'chondeccuma ccushaeñe. Tsa'ma ccushaen'su paji'suma ccushaeñe jiqquia'caen gi egae tsinconsundeccuma ccushaeñe ji cuintsu tise'pa egae tsincon'choma antte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Toya'caen tisema iñajampaña'fa: —Juanma shondosundeccuja asettupa zutsse ambe'yi Chigama iñajan'fa. Fariseoma shondosundeccu'qque tsa'caen atesu'fa. Tsa'ma quema shondosundeccuja asettumbe'yi injanga amba cu'i'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tsonsi Jesúsja tise'pama su: —Tsandie pusheye tson'jemba a'ima ttu'sesi bojin sheque'ta fae'ngae tsandiei'ccu avujatsse amba cui'je'fa. Ña gi tsa tsandieca'on ja'ño can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tsa'ma maqui a'ta cca'indeccu tsandiema joqquitssiansi tsu tisupanaccu asettupa ambe'yi can'jen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsa'caen supa Jesúsja faesu condase'choma condase: —A'ija cuna ondiccu'jema chittaya'bi tssoruma pi'piye. Tsa'caen tson'da cunama'qque tsu dañoña. Toya'caen ma'ppa'ninda tsa pi'pi'cho zupa tssoru ondiccu'jema ti'tsse chittaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Toya'caen tsu a'ija vinoma cupoemba tssoru ttono botiyanga fiñañambi. Vinojan omppantssimba ttonoma chittaemba tsu catiyeya. Toya'caen ttono'qque tsu tsangae dañongeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tsa'ma cuna vinomanda tsu cuna ttono botiyanga fiñaña'cho. Tsa'caen fiñasi vino, ttono'qque dañongembe'yi ccutsuya. ");
INSERT INTO conNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tsa'caen tsu a'ija ñotssia tayoyi ccutsu'cho vinoma cu'ipa cuna ansintssia vinoma in'jambi. Tsa'ma “Tayoyi ccutsu'cho tsu bove ñotssi” qquen tsu suya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jesús sema'ma'qquia a'ta nasipa'ye jacansi tisema shondosundeccu'qque jacamba trigoma sintti isupa shuju qque'shopa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tsama attepa majan fariseondeccuja su'fa: —¿Micomba qui sema'ma'qquia a'ta qquen sema'jen'fa? Chiga manda'chota tsu se'pi sema'ma'qquia a'ta tsa'caen semañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tsama pañamba Jesúsja su: —¿Paña'fambi ti qui tayopi'su David tson'choma? Tiseja tisei'ccu jacansundeccu'qque qquipoe'su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tsomba Davidja Chiga ettinga ca'nimba Chiganga afe'cho panma isupa an. Tisei'ccu jacansundeccunga'qque afesi tise'pa'qque an'fa. Tsa panjan Chigama afasundeccuyi an'faya'cho. Chiga manda'choja se'pi faesu añe. Tsa'ma David tsa'caen tsonsi Chigaja se'pimbi. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Toya'caen Jesúsja su: —Ña, Sefaccone Ji'cho A'i gi sema'ma'qquia a'tane na'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Faesu sema'ma'qquia a'ta Jesúsja Chigane atesian'jen'ttinga ca'nimba atesian'jen. Tse'tti tsu fae tsandie tansinfa'su tive samba dañonge'cho can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseondeccu, Chiga Aya'fama atesiansundeccu'qque Jesúsma camboen'jen'fa. Nane sema'ma'qquia a'ta Jesús se'je ccushaen'ninda, tiseja egae tsincon'su qquen suye ronda'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tsa'ma Jesúsja tise'pa in'jan'choma in'jamba tive dañonge'choma su: —Jipa va'ttinga ccutsuja. Qquen susi tiseja jangipa Jesúsi'ccu ccutsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tsonsi Jesús poiyi'ccoma iñajampaña: —Chiga manda'cho sema'ma'qquia a'ta egae tsoñe se'pi'ta ¿ñotsse tsoñe'qque ti se'pi? Fi'ttiye se'pi'ta ¿ccushaeñe'qque ti se'pi? ");
INSERT INTO conNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Qquen supa piyicamba poiyi'ccoma can'boemba paji'suma su: —Que tivema yasaja. Tsandie tsa'caen yasasi tise tiveja giya'tsse ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tsa'ma tsa'caen tsonsi fariseondeccu, Chiga Aya'fama atesiansundeccu'qque ñoa'me iyicca'yepa condasecco'fa ma'caen Jesúsma patsuya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Faesu a'ta Jesús ccotta'cconi japa ansunde Chigama iñajañe. Pa'cco cose Chigama iñaján can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A'tasi tisema shondosundeccuma ttu'sepa docema tisene afasundeccuve inisian. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tsendeccuja: Simón (Jesús tisema afa, Pedro); tsambe quinshin Andrés; Santiago; Juan; Felipe; Bartolomé; ");
INSERT INTO conNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Santiago (tsaja Alfeo dutssi'ye); Simón (Zelote qquen su'cho); ");
INSERT INTO conNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Santiago antian); Judas Iscariote (Jesúsma jai'ngae chi'gapa afeya'cho). ");
INSERT INTO conNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tsomba Jesús tisema shondosundeccui'ccu ccotta'cco'ye andepa fae'ngatssia andeni ccutsu'fa. Tsain'bio a'i Judea andene, Jerusaléne'qque jipa tseni bo'fa. Toya'caen mar otafani'su Tiro canqque, Sidón canqquene'qque ji'fa Jesúsma pañañe. Tise'pa paji'choma ccushaye in'jamba tsu ji'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesúsja cocoyanga noñangiañesundeccuma'qque ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Poiyi'cco a'i tsu Jesúsma pporaeñe in'jan'fa. Nane pporaen'da tse'faei'ccuyi tsu ccusha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsomba Jesús tisema shondosundeccuma camba su: —Que'i mechondeqquiaja ñoa'me qui avujatssi'fa. Nane Chiga aindeccu qui. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Que'i qquipoe'sundeccu ñoa'me qui avujatssi'fa. Que'i qui tteppu'faya. Que'i inasundeccu ñoa'me qui avujatssi'fa. Que'i qui feña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ñajan Sefaccone Ji'cho A'i. Que'i ñame in'jansi cca'indeccu que'i inisema dañoñe afa'ni'qque ñoa'me qui avujatssi'fa. Aindeccu ñane que'ima chi'ga'fa'ni'qque qui avujatssi'fa. Ñane que'ima se'pipa afase'fa'ni'qque qui avujatssi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nane tayopisundeccu'qque tise'pa can'jeinte'su Chiga Aya'fama afasundeccuma tsa'caen egae tson'fa. Maqui a'ta tsa'caen que'ima afase'nijan ti'tsse avujatssi'faja. Nane Chiga sefacconi qui osha'cho ñotssiama injantsse an'bian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tsa'ma vana'faya qui que'i osha'choma an'biansundeccu. Que'imbe ñotssiama qui tayo an'bia'an. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Vana'faya qui que'i amba tteppu'chondeccu. Qquipoe'su'faya qui. Vana'faya qui que'i ja'ño feñasundeccu. Ñombi'yepa qui i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Vana'faya qui poiyi'cco a'inga ñotsse afayesundeccu. Nane tayopi'su Chiga Aya'fama afa'su qquen afopoensundeccu afopoensi tise'pa can'jeinte'su aindeccu tise'pama tsa'caen ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tsa'ma que'i ñama pañasundeccunga gi conda: Que'ima egae tsinconsundeccuma ñotsse in'jan'faja. Que'ima chi'gasundeccuma ñotsse tson'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Que'ima afasesundeccuma ñotsse afa'faja. Que'ima dañosundeccune Chigama iñajan'faja cuintsu tise'pama ñotsse tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Majan a'i faefa'su tsovejuma tssai'ninda ccafa'su tsovejuma'qque canjaen'faja. Majan a'i que oppoen'cho sarupama itsa'ninda que ondiccu'jema'qque se'pimbe'yi afe'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Majan a'i osha'chove quema iñajan'ninda se'pimbe'yi afe'faja. Majan a'i que an'bian'choma itsa'ninda toequi afeye iñajan'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma'caen cca'i que'ima tsoñe in'jan'da tsa'caen tise'panga'qque tson'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","¿Tisuma in'jan'chondeccuve'yi ñotsse in'jan'da ti qui ñotsse tson'fa? Nane egae tsinconsundeccu'qque tsa'caen tisupapora ñotsse injancco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","¿Tisuma ñotsse tsonsundeccuveyi ñotsse tson'da ti qui ñotsse tson'fa? Nane egae tsinconsundeccu'qque tsa'caen tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","¿Jai'ngae ccase isuye corifin'dima cca'indeccunga afe'ta ti qui ñotsse tson'fa? Nane egae tsinconsundeccu'qque tsa'caen tisupaporanga afeye atesu'fa jai'ngae ccase isuye. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tsa'ma que'ija tisuma egae tsonsundeccuma ñotsse in'jan'faja. Tsendeccuma ñotsse tson'faja. Corifin'dima afe'ta ccase isuye in'jambe can'faja. Tsa'caen tson'da qui Ti'tsse'tssia Chiga que'ima in'jansi Tise dushundeccuve dapa ti'tsse ñotsse osha'choma isu'faya. Chiga Quitsaja Tisema chi'gasundeccuma in'jamba mende'ye. Egae tsinconsundeccuma'qque in'jamba mende'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chiga que'i Quitsa mendeyeqquia'caen que'i'qque cca'indeccuma mende'ye'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Cca'i egae tsincon'choma ttatta'fambian'da Chiga'qque que'i egae tsincon'choma tta'ttaya'bi. Ni cca'imbe egae tsincon'cho shacane qquen afambian'da Chiga'qque que'i egae tsincon'cho shacane afaya'bi. Cca'indeccu que'ima egae tsincon'ninda tise'pama in'jamba tise'pa egae tsincon'choma aqquepoen'faja. Tsa'caen aqquepoe'ninda Chiga'qque que'ima in'jamba que'i egae tsincon'choma aqquepoeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cca'indeccunga tsu afe'faya'cho. Tsa'caen tso'ninda tsu Chiga'qque que'inga afeya. Agatto'cho tasanga on'boemba pisa'ñacca tssai oyae'ñacca on'batsse on'boenqquiacaen tsu Chigaja que'inga afeya. Nane que'i cca'indeccunga afeye agattoqquia'caen tsu Chiga'qque agattopa que'inga afeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tsomba Jesús va condase'choma conda: —¿Bininda ti osha faesu binima angacañe? Me'i, fae'ngae tsu ande changonga amppi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Shondo'suja tisema atesian'suma ti'tsse'tssimbi tsu. Tsa'ma poi shondo'su osha'choma paña'da ñoa'me tise atesian'sia'caen tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Mingapa qui faenga'su tso'fe ccappi'choma atteqquia'caen tise egae tsincon'choma atte'fa? Tsa'ma tisu tso'feni quini'cco eje'choma qui atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Toya'caen qui su'fa: “Faenga'su, ñajan que tso'fe ccappi'choma somboeña.” Tsa'ma tisu tso'feni quini'cco eje'choma atesumbiqquia'caen qui que'i egae tsincon'choma atesu'fambi. Queja ño'a qquen attiamba ñoa'me afopoen'su qui. O'tie tsu que tso'feni quini'cco eje'choma somboemba ñotsse atteya'cho. Tsomba qui faenga'suma fuitepa tise tso'fe ccappi'choma somboeñe osha. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ega teta'choja ñotssia quini'jinga nambi. Ni ñotssia teta'cho'qque ega quini'jinga nambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nane tise teta'choma attepa gi quini'jima atesu'fa. Higuerama pi'sho'fambi gi nojansifanga japa. Ni tsajama gi pi'sho'fambi ancco'singa japa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Toya'caen ño'a a'ija tise injama'cho'su ñotsse in'jan'chone ñotssiama tsu canjaen. Tsa'ma ega a'ija tise injama'cho'su egae jincho'chone egama tsu canjaen. Nane tisu injama'cho jinchoqquia'caen tsu a'ija afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Micomba qui ñama su'fa: “Na'su, Na'su,” ña manda'choma chig'ga'ta? ");
INSERT INTO conNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Qquen tsu ñanga jipa ña su'choma ñoa'me pañamba canse'cho: ");
INSERT INTO conNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Fae a'i tsu tsaoña'jemba tso'sitsse dya'dyapa fattocconga ta'etsse dyaiña. Tsonsi tsu na'en jipa zonzoe'ma osiañe oshambi tise tsa'oma. Ñotssiave tsao'ñasi ta'etssi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tsa'ma majan a'i ña manda'choma pañamba tson'sumbi'ta faesu tsao'ñasia'can tsu. Tsaja sisipandundunga tsao'ñasi na'en jipa tsa'onga zonzoensi junde osui. Osuipa tsa'oja tsangae ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesúsja aindeccuma candusian nanimba Capernaum canqqueni japa ca'ni. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tse'tti tsu romano sundaro capitán can'jen. Tise in'jan'cho sema'su pajipa paye tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tsa'cansi capitánjan Jesúsne pañamba israe'su nasundeccuma manda moen Jesúsma afaye cuintsu tise'be sema'suma ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Manda moensi Jesúsnga catsepa tsain'bitsse iñajan'fa qquen supa: —Va a'ija ñoa'me ñotssia tsu. Ingi a'ima ñotsse in'jamba corifin'dima afe ingi Chigane atesian'jen'ttima tsao'ñañe. Ñotssi tsu que tise in'jan'choma tsoñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsonsi Jesús tsendeccui'ccu japa capitán tsa'onga pan napiji'ni capitánjan tise amigondeccuma manda moen cuintsu Jesúsma cachui'nga'faye. Tsendeccuja jipa capitán qquen su'choma conda'fa: —Na'su, ñotssimbi gi que ña tsaoni jiye. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tsa'camba ñajan cambajunaccu cachuiccoye jambi quema iñajañe. Tsa'ma queja toe'tti ccutsupa mandaja cuintsu ñambe sema'su ccushaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ñajan sundaro a'i. Ña nasundeccuja ñama manda'fa. Ña'qque ñama bove'ccoa sundarondeccuma manda. Fae'ccoma “Jaja” qquen mandasi tiseja ja'je. Faesuma “Jija” qquen mandasi tiseja ji'je. Ña sema'suma “Qquen ñoñaja” qquen mandasi tsa'caen tiseja tson'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús tsama pañamba sundaro capitáne asi'ttaén ccutsu. Tsomba piyicamba tisei'ccu jacansundeccuma su: —Tsa a'ija ñoa'me tsu ñame in'jan. Ni fae israe'suyi'qque qquenda ñame in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsa'caen susi mandasicondasundeccu toequi capitán tsaoni japa sema'su ccusha'choma atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsomba tse'i Jesúsja Naín canqqueni ja. Tisema shondosundeccu, tsain'bio a'i'qque tisei'ccu fae'ngae jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Canqque sombo'ttinga catsepa a'i bo'fa'choma cachuicco'fa. A'i pasi canqque'ye sombo'fa pa'choma angapa a'tuye. Pa'choja tsandupajen'cho du'shu fae'ccoa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na'su Jesús tsandupajen'choma attepa mende'yepa su: —I'nambe canjan. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tsomba Jesús catsepa pa'choma ccuiña'cho asiccoma pporaensi angasundeccuja já ccutsu'fa. Tsonsi Jesúsja pa'choma su: —Jaricho, ¡qquendyaja! ");
INSERT INTO conNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Qquen susi pa'choja jangi dyaipa afaye ashaen. Tsonsi Jesús tisema fuite cuintsu tise mamani jaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Poiyi'cco a'i tsama attepa ñoa'me dyo'fa. Tsa'ma Chigama ñotsse afapa su'fa: —Joccapitssia Chiga Aya'fama afa'su tsu inginga attian. Toya'caen tsu su'fa: —Chigaja Tise aindeccuma in'jamba fuiteye ji. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tsama condasesi poiyi'cco Judea andeni'su a'i'qque paña'fa. Poiyi'cco pporotsse can'jensundeccu'qque tsa'caen Jesúsne paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan toya picco'je'cho ettini piccoyepa can'jen'ni tisema shondosundeccu Jesús tson'choma tisenga condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","Condasesi pañamba Juanjan tsendeccu'suma dosve ttu'sepa Na'su Jesúsni maña. Tsendeccu jipa Jesúsma su'fa: —Feti'su Juan tsu ingima mandamaña quema qquen iñajampañañe: “¿Que ti qui Cristo, jiya'cho qquen su'choja? Tsambi'ta ¿faesuve ti gi ronda'je'faya?” ");
INSERT INTO conNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tsendeccu caña'jen'ni Jesúsja tsain'bio pajisundeccuma ccushaen'jen. Nane osha'cho paqque'sui'ccu pajisundeccuma ccushaen. Cocoyama joqquitssiamba binindeccuma'qque bittaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsa'caen ccushaen'jemba Juanma shondosundeccuma su: —Japa que'i attepa paña'choma Juanga conda'faja. Binindeccu tsu bitta'fa. Ccutsumbindeccu tsu tsui jacan'fa. Na congomba pajisundeccu tsu giya'tsse ccushapa ja'fa. Tsosinambindeccu tsu paña'fa. Nane panjin ccui'chondeccu tsu ccase qquendya'fa. Va'chandeccu'qque tsu Chiga a'ima ccushaeña'chone ñotsse condase'choma paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Majan ñame in'jamba ansangembi'ta ñoa'me tsu avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan mandasi iñajampañasundeccu jasi Jesúsja aindeccunga Juane qquen condase: —Que'ija a'i menia ja'ta ¿jongoesuma atteye qui ja'fa? ¿Fingian canttini'ccoma oyaen'jen'choma cañe ti qui ja'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tsambi'ta ¿jongoesuma atteye qui ja'fa? ¿A'i ñotssia sarupama ondiccucho'choma cañe ti qui ja'fa? Me'i, ñotssiama ondiccucho'chondeccuja na'su tsaoni can'jemba tsa'caen ñotsse canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tsa'ma ¿jongoesuma atteye qui ja'fa? ¿Chiga Aya'fama afa'suma atteye ti qui ja'fa? Ju, tsane qui japa atte'fa. Nane Juanjan Chiga Aya'fa afa'suma ti'tsse'tssia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tisene tsu Chiga Aya'faja su: Que canjan. Quema o'tie gi ñane afa'suma manda moeña. Tise tsu o'tie japa que ji'je'choma ñoñañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Va andeni faesu a'i Feti'su Juanma ti'tsse'tssia've me'i'on tsu. Tsa'ma Chiga aindeccuve da'fasi ñoa'me utu'ccoa tsu Juanma ti'tsse'tssiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesúsma pañamba poiyi'cco a'i, nane govierno impuestoma isusundeccu'qque, “Chigaja ño'a” qquen tsu su'fa. Tsendeccuja tayoe Juanga fetiyepa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tsa'ma fariseondeccu, Chiga manda'choma atesu'chondeccu'qque Juanga fetiyembipa Chiga tsa'caen tise'pama ccushaeña'choma chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tsonsi Na'su Jesúsja su: —¿Jongoesui'ccu gi ja'ño'su aindeccui'ccu fae'ngae canjaeña cuintsu que'i ñotsse in'jan'faye? ¿Jongoesia'caen tsu tson'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ñoa'me dushundeccu chavaen'jen'tti'su atandunduni dyaipa fae'ngae co'fe'fambiqquia'caen tsu ja'ño'su aindeccuja fae'ngae in'jan'fambi. Nane dushundeccuja tisupaporai'ccu fundocco'fa: “Casara'chove co'feqquia'caen fendo'jesi qui boira'fambi. Pa'choma a'tuqquia'caen ñombi'ye cofe'jesi qui i'na'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Feti'su Juan jipa aña'choma ambipa asettu. Tse'tse'pama'qque cu'imbi. Tsa'cansi que'ija su'fa: “Tsaja cocoya ca'ni'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ja'ño ñajan Sefaccone Ji'cho A'i jipa gi osha'choma amba cu'i. Tsa'ma que'ija su'fa: “Va a'ija ñoa'me panshaen an'jemba tse'tse'pa singo tsu. Egae tsinconsundeccu, govierno impuestoma isusundeccu'qque tisei'ccu fae'ngae jacan'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Qquen qui su'fa. Tsa'ma tsaveqque'su tsu. Chiga dushundeccuja Chiga tansintsse in'jan'choma canjaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsonsi fa'e fariseo a'i Jesúsma ttu'se cuintsu tise tsaoni jipa añe. Jesúsja tseni japa cca'indeccui'ccu mesa jin'tti piyive ccui. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tsa'caen ccuipa an'jen'ni pushesuja Jesús fariseo tsaoni can'jen'choma pañamba jipa ca'ni. Tsa pushesuja egae tsincon'su. Patuma ñoña'cho botiyanga ñome'bama ipa Jesús tsutteccofanga ccutsupa i'na. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","I'namba tise inanzaccui'ccu Jesús tsu'ttema tssipoemba cashi. Tsomba tise tosei'ccu Jesús tsu'ttema ccucha. Ccuchapa tsu'ttema mochapa ñome'bai'ccu onjoen. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pushesu tsa'caen tsonsi Jesúsma ttuse'su fariseoja attepa tisu injama'choni asi'ttaen: “Va a'ija ñoa'me Chiga Aya'fa afa'suta tsu tisema pporaen'su pushesuma atesuya. Nane pushesu ma'caen egae tsincon'choma tsu atesuya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsonsi Jesúsja fariseo in'jan'choma in'jamba su: —Simón, ñajan quenga condaye in'jan. Simónjan su: —Atesian'su, ¿jongoesuma qui condaye in'jan? Tsonsi Jesúsja tisema su: ");
INSERT INTO conNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Na'su tsu dos a'inga shacaen. Fae a'i shacaja quiniento corifin'di. Faesu shacaja cincuenta corifin'di. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsendeccu afepoeñe osha'fambisi na'suja poimbe shacama fi'tti. ¿Majan tsa dos a'i'su tsu na'suma ti'tsse in'jaña? ");
INSERT INTO conNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónjan su: —Jm jḿ. ¿Tsa ti'tsse shacaen'sumbi ti? Tsonsi Jesús tisema su: —Ñotsse qui in'jamba su. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tsomba piyicamba pushesuma canjaemba Simónma su: —Va pushesuma canjan. Ña que tsa'onga ca'nisi queja tsa'ccuma afembi ña tsu'ttema cashiye. Tsa'ma va pushesuja tise inanzaccui'ccu ña tsu'ttema tssipoemba cashipa tise tosei'ccu ccucha. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Queja ñama mochapa chigambiambi. Tsa'ma ña tseyi ca'nisi tiseja ánttembe'yi ña tsu'ttema mocha'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Que ña tsovema yayapoembisi tiseja ña tsu'ttema ñome'bai'ccu onjoen. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tsa'cansi gi quema su: Tsa pushesuja tsain'bitsse egae tsincon'chopa pa'ccoma joqquitssiangepa ñame ñotsse in'jan. Tsa'ma majan a'i re'riccoe egae tsincon qquen in'jamba re'riccoe joqquitssiangepa aqquia re'riccoe ñame in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tsomba Jesús pushesuma su: —Que egae tsincon'choja tayo joqquitssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Qquen susi cca'indeccu fae'ngae Jesúsi'ccu ansundeccuja qquen condasecco'fa: —¿Majan gi qquen te tiseja in'jan, tsa'caen egae tsincon'choma joqquitssiañe'jan? ");
INSERT INTO conNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tsonsi Jesús pushesuma su: —Opatsse canseja. Ñame in'jamba qui ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Can'jenccapa Jesúsja faesu canqqueni, faesu a'i can'jen'ttinga japa ma'caen Chiga aindeccuve dapa canseya'chone condasepa candusian'jen. Tisema doce shondosundeccu'qque fae'ngae jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Toya'caen majan pushesundeccu'qque Jesús tise'pama ccushaensi fae'ngae jacan'fa. Majan tsendeccu'suta cocoya can'jensi joqquitssian'cho; majanda pajisi ccushaen'chondeccu. Fa'eja, María Magdalena, tsu siete cocoyave joqquitssian'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Faesuja Juana. Tise tsa'nduja, Choza, tsu ande na'su Herodes tsa'o na'su. Toya'caen Susana, cca'indeccu'qque fae'ngae jacan'fa. Tise'pa an'bian'choi'ccu, tise'pa corifin'di'ccu Jesúsma, tisema shondosundeccuma'qque fuitepa osha'chove ñoña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Poiyi'cco A'i canqquene fae'ngae Jesúsnga bo'fasi tiseja qquen condase'choi'ccu atesian'jen: ");
INSERT INTO conNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jon'suja gaiña jon'su ja. Gaiñasi enttingeja tsaiqui utufanga sheque. A'i tsanga tsuisi chhiriria'qque jipa an'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Enttingeja patupa andenga sheque. Sho'yopa pandipa samba, tsa'ccu me'i'onsi. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Enttingeja anccosiccunga sheque. Tsa'ma anccosi fae'ngae coensi ñotsse jon'cho nambe'yi pa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Faesu enttingeja ñotssia andenga shequepa sho'yopa ñotsse na'fa. Fae cho tsu cieme atapa'fa. Jesúsja tsa'caen atesiamba fundopa afa: —Majan tsosinapaja paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesúsma shondosundeccu condase'cho in'jan'chone tisema iñajampañasi ");
INSERT INTO conNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesúsja qquen su: —Tayoe ma'caen Chiga aindeccuve dapa canse'faya'chone Chigaja condambi. Tsa'ma ja'ño que'inga pañaeñe in'jan. Cca'indeccungaja aqquia condase'choi'ccu condaseya'cho cuintsu atte'ma atesu'fambiye; cuintsu paña'ma in'jan'fambiye. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Condase'cho tsu qquen: Choja Chiga Aya'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Majan a'ija tsaiquinga sheque'choacan'fa tsu. Chiga Aya'fama pañasi cocoya na'su junde jipa choma itsaqquia'caen tise'pa paña'choma aqquepoen tise'pa in'jamba ccushasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Majan a'ija patupa andenga sheque'choacan'fa tsu. Tseyi Chiga Aya'fama pañamba avujatsse in'jan'fa. Tsa'ma setsa'fa shacaqquia'caen injama'cho ta'etssimbi. Re'riccone in'jamba me'detsse canse'ta antte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Cca'ija cho anccosiccunga sheque'choacan'fa tsu. Tsendeccuja Chiga Aya'fama pañamba panshaen va ande'su jincho'choma in'jan'fa. Ricove daye in'jan'fa. In'jangae canseye in'jan'fa. Tsa'caen in'jamba Chiga Aya'fama paña'choma fi'ttiqquia'caen tise in'jan'choma nañámbi. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tsa'ma majan a'ija ñotssia andenga jon'choa'caen Chiga Aya'fama pañamba injama'choi'ccu aqque'pambi'tsse in'jan'fa. Tise'pa injama'choja ñotssisi tsa'caen anttembe'yi ñotsse naqquia'caen canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A'ija tuñoma setsaemba ombanga apima puviaña'bi. Ni anambacco tsosiccunga tuñoma ccutsiaña'bi. Tsa'ma setsaemba sefani ancaeña'cho cuintsu poiyi'cco a'i cuartonga ca'ni'da ñotsse atte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tsa'cansi tsangae a'tuya'choja jinchombi. Tsa'ma osha'cho jai'ngae attiansi qui atte'faya. Ni tsangae condayembitsse pasaye'ta jinchombi. Jai'ngae condasesi qui a'tatsse paña'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tsonsi ñotsse pañamba in'jan'faja. Majan tayo in'jan'chota ti'tsse tsu in'jan'faya. Tsa'ma majan in'jambi'choa'ta tise injanga in'jan'choma'qque tsu qqueñaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsonsi Jesús chan, tise quinshingendeccu'qque can'su ji'fa. Tsa'ma tsain'bio a'i shequesi tisenga catseye osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsa'caen osha'fambisi cca'ija Jesúsma conda'fa: —Que mama, que quinshingendeccu'qque tsu tsotefani ccutsu'fa quema atteye in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tsama pañamba Jesúsja su: —Poiyi'cco majan Chiga Aya'fama pañamba tsa'caen tson'da ñoa'me ña mama, ña quinshingendeqquia'can'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Fae a'ta Jesús, tisema shondosundeccu'qque shavonga otse'fa. Jesúsja tise'pama su: —Jinge mar jonifani ise'faye. Tsa'caen susi ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Fingian shavoma angajisi Jesúsja ana. Fingian ti'tsse quia'me fingiansi tsa'ccu shavonga ca'nisi a'ija cu'nosa'ne dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dyopa Jesúsma qquendyaemba su'fa: —Na'su, Na'su cu'nomba gi paye tson'jen'fa. Tsonsi Jesúsja qquendyapa fingiama iyu'usi pasa. Rande shave'pama'qque iyu'usi ppimppianccuve da. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tsomba Jesúsja su: —¿Mingapa qui ñame in'jan'fambi? Tise'paja dyopa Jesúsma can'boemba qquen condasecco'fa: —¿Majan tsu va a'ija? Tise mandasi fingian, shave'pa'qque tisema paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsomba Galilea ande isevetsse ccattufa'fa Gadara andeni. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús shavo'ye sombosi fa'e tsa ande'su a'i tisema cachuiye ji. Táyoyi cocoyaja tisenga ca'nisi chu'cco jacamba tsaoni can'jembipa ayandeccu atú'ttini can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Jesúsma attepa fundopa Jesús tsutteccofanga ccarupa dyai. Nane tsain'bitssi cocoya tsa a'inga ca'nisi canqquesundeccuja tisema coiraye candena yoshavai'ccu tandamba an'bian'fa. Tsa'ma cocoya ca'ni'choja candenama oppattu catisi cocoya tisema anga a'i menia. Jesúsja tsa a'i'ye joqquitssiye cocoyama mandasi a'ija quia'me fundopa su: —Joccapitssia Chigambe Dutssi'ye qui, Jesús. ¿Jongoesie qui ñani ji? Chigáne ñama noñangianjama. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tsonsi Jesúsja cocoyama iñajampaña: —¿Jongoesu inise qui? Tiseja su: —Legión (Injantssia Sundarondeccu) gi. Tsain'bitssi cocoya ca'ni'chopa tsu tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Qquen supa cocoyandeccuja Jesúsma iñajan'fa cocoya can'jeni tise'pama moembe cañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tse'tti ccotta'cco piyiccu'fani tsain'bitssi cochi an sheque'fasi cocoyandeccuja Jesúsma iñajan'fa cuintsu cochinga tise'pama mandaye. Iñajansi Jesús tsa'caen anttesi ");
INSERT INTO conNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","cocoyandeccuja a'i'ye sombopa cochinga ca'ni'fa. Ca'nisi cochi sheque'cho sumbie dapa fattoccóccufanga butto amppi'fa marnga. Tsomba andeccopa pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cochima coirasundeccu cochi sumbie da'choma attepa buttoccoin ja'fa canqqueni. Tse'tti can'jensundeccu, biacca can'jensundeccunga'qque conda'fasi ");
INSERT INTO conNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","aindeccuja ma'caen da'choma can'su ja'fa. Jesúsni jipa cocoya ca'ni'cho a'i ccusha'choma atte'fa. Tiseja ondiccupa ñotsse in'jamba Jesús tsu'tte jin'ttinga dyai. Tisema attepa poiyi'cco a'i dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dyo'fasi tseni can'jensundeccu cocoya ca'ni'cho ma'caen ccusha'choma attepa poiyi'cco a'inga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsa'caen condasesi poiyi'cco tsa Gadara andesundeccu ñoa'me dyopa Jesúsma iñajan'fa cuintsu tise'pa ande'ye sombopa ccani jaye. Tsonsi Jesúsja shavonga otsepa toequi shanda. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tayoe cocoya ca'ni'cho a'i ccusha'choja Jesúsma iñajan fae'ngae jaye. Tsa'ma Jesúsja tisema mandamaña qquen supa: ");
INSERT INTO conNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Que tsaoni toequi shandapa poiyi'cconga condaseja ma'caen Chiga quema mende'yepa tson'choma. Tsa'caen mandasi tiseja japa poiyi'cco tsa canqquesundeccunga conda ma'caen Jesús tisema ccushaen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús Galilea andeni toequi shandasi a'i bopa tise've rondasundeccu avujatsse tisema chigambian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tson'jen'ni Chigane atesian'jen'tti'su na'su, Jairo, jipa Jesús tsutteccofanga ccaru dyaipa Jesúsma iñajan cuintsu tise tsaoni jaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tseni tise onque'nge fae'ccoa pajipa ccuipa paye tson'jen. Tsaja doce canqque'fave an'bian'cho. Jesús Jairoi'ccu jayisi tsain'bio a'i fae'ngae jayipa ñoa'me ta'yotssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tsendeccu enttinge'ye pushesu'qque jayi. Tsa pushesuja tise egápai'ccu dañongepa doce canqque'fa me'detsse canse. Ccushambe'yi pa'cco tise corifin'dima afepoen cati sejesundeccunga. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tsaja sepaccofae Jesúsnga catsepa tise ondiccu'je utufama pporaen. Pporaensi tse'faei'ccuyi tise egápaja samba. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tsa'caen tsonsi Jesúsja iñajampaña: —¿Majan tsu ñama pporaen? Tsa'ma poiyi'cco a'i pporaembi qquen su'fa. Poiyi'cco tsa'caen su'fasi Pedroja su: —Na'su, vui'o a'imbipa shoquendipa ppororaensi, ¿ma'caen qui su: “¿Majan tsu ñama pporaen?”? ");
INSERT INTO conNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsa'ma Jesúsja su: —Fae'cco ñama pporaemba ccusha. Tayo gi in'jan ña ccushaen'jen'cho ña'ñe somboqquia'caen a'ima ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsonsi pushesuja Jesús tayo atesu qquen in'jamba ttun'dundu'je japa Jesúsnga catsepa tise tsutteccofanga ccaru dyai. Tsomba poiyi'cconga condase tise injama'choni in'jamba Jesúsma pporaemba tse'faei'ccuyi ccusha'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tsonsi Jesúsja tisema su: —Shim'ppi, ñame in'jamba qui ccusha. Opatsse canseja. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús toya pushesui'ccu condase'je'ni faesu a'i na'su Jairo tsaone jipa Jairoma su: —Tayo tsu que onque'ngeja pa'ya. Ti'tsse atesian'suma noñangiambe ántteja. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tsama pañamba Jesúsja Jairoma su: —Dyombe canjan. Que ñame in'jan'ninda tsu que onque'ngeja ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tsaoni napipa Jesúsja se'pi poiyi'cco a'i tisei'ccu ca'niñe. Tsa'ma Pedro, Santiago, Juan, du'shumbe yaya, du'shumbe mamama'qque angapa tsa'onga ca'ni'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Poiyi'cco tsaonisundeccu qquejeccopa ina'jen'fasi Jesúsja su: —Ina'fajama. Du'shuja pambi'tsse'yi ana'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tsa'ma tayo ñoa'me pa'chosi in'jamba Jesúsma feña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tsonsi Jesús du'shu tive'ye indipa tisema qquendyaeñe ttu'se: —Du'shu, jangija. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Qquen susi tise qquendya'pa toequi jisi tse'faei'ccuyi du'shuja jangi. Tsonsi Jesúsja manda cuintsu du'shuma o'fiañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Du'shumbe yaya, du'shumbe mama'qque can'boen ccutsu'fa. Tsa'ma Jesúsja tise'pama manda cuintsu cca'indeccunga condambe can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús tisema doce shondosundeccuma ttu'se boñamba tise'pama in'jaemba manda osha'cho cocoyama joqquitssiañe, pajisundeccuma ccushaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tsomba tise'pama mandamaña cuintsu japa ma'caen Chiga aindeccuve dapa canseya'chone candusiamba pajisundeccuma'qque ccushaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tise'pama su: —Me'ccoyi jaja'faja. Ni jacan'cho accuicco'cho, ni o'va, ni anqque'su, ni corifin'di, ni faesu ondiccu'jema anga'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Majan tsa'onga ca'ni'da tse'ttiniñi can'jen'faja canqqueni sombopa jaya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma'tti pañañe in'jan'fambisi tse'ttie sombo'ta tsu'ttenga ancamba totopa'ma fanttundu'faja tise'pa egae tson'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsonsi tsendeccuja sombopa cca'tti cca'tti poi canqquenga japa Chiga ñotsse condase'choma candusian'fa. Mani ja'a'qque pajisundeccuma ccushaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ande na'su Herodes osha'cho Jesús tson'choma pañamba injama'choni dyo. Majan a'ija “Feti'su Juan'ñe ccase qquendya” qquen tsu in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Cca'indeccuja: “Tayopi'su Chiga Aya'fama afa'su Elías tsu attian” qquen tsu in'jan'fa. Toya'caen: “Tayopi'su Chiga Aya'fama afa'su ccase qquendya,” ");
INSERT INTO conNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tsa'ma Herodesja su: —Tayo gi Juan tsovema chattuye mandasi tsu fi'tti. Tsa'ma ¿majan tsu va ña osha'chone paña'jen'cho? Qquen asi'ttaemba dyopa Jesúsma atteye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesúsne afasundeccu candusiañe japa toequi jipa tise'pa osha'cho tson'choma Jesúsnga condase'fa. Tsonsi Jesúsja tise'pama ccani anga. Betsaida canqque pporotsse japa can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tsa'ma a'i bo'fa'choja Jesús mani ja'choma pañamba omboe jaja'fa. Tsonsi Jesúsja tise'pama avujatsse chigambiamba ti'tsse ma'caen Chiga aindeccuve dapa canseya'chone candusian. Pajisundeccuma'qque Jesúsja ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tayo chiga ondusesi tsa doce Jesúsne afasundeccu tisenga jipa su'fa: —Aindeccu bo'fa'choma mandamañajan cuintsu canqqueni, cca'tti'su tsaoni'qque japa amba ana'faye. Nane vanijan a'i menia gi can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tsa'ma Jesúsja tise'pama su: —Que'i tise'pama o'fian'faja. Tsa'ma su'fa: —Nane cinco panmeñi dos avuveyi gi an'bian'fa. ¿Queta ti qui in'jan ingi japa anqque'suma chavapa poiyi'cco vandeccuma o'fiañe? ");
INSERT INTO conNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nane tsandiendeccuyi tsu cinco milca'on can'jen'fa. Tsa'ma Jesúsja tisema shondosundeccuma su: —Aindeccuma manda'faja cuintsu cca'tti cincuenta cca'tti cincuenta bopa dyai'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tsa'caen mandasi a'i dyai'fasi ");
INSERT INTO conNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesúsja tsa cinco pan, dos avuma isupa Chiga sefacconima asuccocan. Asuccocamba Chiga tsu ñotssia qquen afapa pan, avuma'qque doñamba tisema shondosundeccunga afe cuintsu aindeccunga attufaen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsonsi poiyi'cco a'i amba tteppu'fa. Jesúsma shondosundeccuja pan, avu antteye'cho sheque'pama taipa doce saparove on'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Fae a'ta Jesús tisema shondosundeccui'ccu tisuyi Chigama iñajan'jen. Tsomba Jesúsja tise'pama iñajampaña: —¿Majan qquen tsu ñamajan faesu a'ita su'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tise'paja su'fa: —Majanda tsu su'fa: “Feti'su Juan.” Cca'ija: “Tayopi'su Elías.” Cca'ija: “Tayopi'su Chiga Aya'fama afa'su ccase qquendya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsonsi Jesúsja tise'pama iñajampaña: —Tsa'ma que'ija, ¿majan qquen qui ñamajan su'fa? Tsonsi Pedroja su: —Queja Chiga in'jan'cho Cristo qui. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Qquen susi Jesúsja tise'pama quia'me manda cuintsu majangayi'qque condambe can'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Qquen tsu su: —Sefaccone Ji'cho A'i gi osha'choi'ccu vanaña. Ingi ande'su coenzandeccu, Chigama afa'su nasundeccu, Chiga Aya'fama atesiansundeccu'qque ñama chi'ga'faya. Ñama fi'ttisi papa gi tres a'tangae ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Toya'caen Jesúsja poiyi'cco a'ima su: —Majan a'i ñai'ccu fae'ngae jiye in'jan'chota, tisu in'jan'choma tsu catiya'cho. Tisu avuja'ccoma opiqquia'caen tsu tiseja poi a'ta ña'caen paya'ngae vanaña'cho. Toya'caen ñai'ccu fae'ngae jacaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Majan a'i tisuma ccushaeñe in'jan'da tsu papa catiyeya. Tsa'ma majan ñame in'jamba pa'ta ñoa'me tsu ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A'i poiyi'ccoma patsupa osha'choma an'biamba toya'caen tisuma qqueña'ninda, ¿jongoesune tsu bareya? ");
INSERT INTO conNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Majan a'ija ñane, ña aya'fane'qque ansange'fa. Tsa'ma ña, Sefaccone Ji'cho A'i gi ccase jipa ccane'qque tise'pane ansangeya. Ña joccapitssia've dapa attiansi Chiga ña Quitsaja ñama ñotssiave canjaeña. Sefacconi'su ñotssia Chigama shondosundeccu'qque ñama ñotssiave canjaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jai'ngae tsu tsa'caen tsoña'cho. Tsa'ma majan que'i'su toya pambi'te qui Chiga aindeccuve daya'choma atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tsa'caen supa ocho a'ta'caen pasasi Jesúsja Pedro, Juan, Santiagoma'qque anga ccotta'cconi Chigama iñajañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús Chigama iñajansi tsu tise cambajuja ccaningae da. Tise ondiccu'je'qque chhariccotssia totoave da. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Dos a'i'qque a'tatssia've attiamba Jesúsi'ccu condase'je'fa. Tsendeccuja tayopi'su Moisés, tayopi'su Elías'qque. Jesús Jerusaléni japa paya'chone tsu condase'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, tisei'ccu fae'ngae can'jensundeccu'qque anae'supa anae'su'je'ttie qquendyapa Jesús ñotssia a'tatssia've da'choma atte'fa. Jesúsi'ccu fae'ngae ccutsusundeccuma'qque atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsendeccu Jesúsma chigambiamba jaye tson'jensi Pedroja Jesúsma su: —Na'su, ñotssi tsu ingi va'tti can'jeñe. Jinge tres tsao'cho'ccoe tsao'ña'faye –fae'cco quembe, faesuja Moisésmbe, faesuja Elíasmbe. Pedroja tisu su'choma atesumbi'ma injanga afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsa'caen susi ccuttopa'si tise'pama picco. Tsa'caen piccosi Jesúsma shondosundeccuja dyo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ccuttopa'si'ye aya'faja qquen afa: —Vaja ña in'jan'cho Dutssi'ye tsu. Tisema paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aya'fa qquen afa'nijan Jesúsja tisuyi ccutsu. Shondosundeccuja tsama atte'ma condambi'tsse can'jen'fa. Nane Jesús toya can'jeinte cca'indeccunga tsama conda'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ccaqui a'ta ccotta'cco'ye andesi tsain'bio a'i tisema cachui'cco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Fa'e tse'tti can'jen'choja fundondo'e afa: —Atesian'su, chigáne ña du'shuma mende'yeja. Ña dutssi'yeja fae'ccoa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cocoya tisema indi'nijan tse'faei'ccuyi fundopa cunshomboen dapa aya'fa'ye ttottomboemba pa'je. Cocoyaja anttembe'yi tisema ma'dyisi si'ma'en da. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tsama somboeñe quema shondosundeccuma iñajansi tise'paja osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tsa'caen susi Jesúsja su: —Que'i ja'ño'su aindeccuja itoyetsse in'jamba Chigave in'jambindeqquia qui. ¿Min'ge'e gi tsuin'da quei'ccu can'jemba angacaña? I'ngaja que dutssi'yema. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Du'shu jiñasi cocoyaja tisema mandyi indi pan'jaen. Tsa'ma Jesúsja cocoyama iyu'upa du'shuma ccushaemba tise yayanga afe. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tsa'caen ccushaensi poiyi'cco a'i can'boemba in'jan'fa Chigaja ti'tsse'tssia've. Aindeccu toya tsa'caen Jesús tson'choma camboen'jen'fa'ni Jesúsja tisema shondosundeccuma su: ");
INSERT INTO conNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Va condase'choma ñotsse pañamba in'jan'faja: Ñajan Sefaccone Ji'cho A'i. Tsa'ma ñama indipa a'inga afe'faya cuintsu fi'tti'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesús tsa'caen tisune condasesi paña'ma atesu'fambi. Nane ccaningae in'jamba ñoa'me su'choma atesuye osha'fambi. Toya'caen dyojopa tise su'chone Jesúsma iñajampaña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsomba Jesúsma shondosundeccu tisupaporai'ccu majan tsu ti'tsse'tssia qquen afacco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tsa'ma Jesús tise'pa injama'cho in'jan'choma in'jamba du'shuma ipa tisu'ttinga ccutsiamba ");
INSERT INTO conNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","su: —Majan ña a'ive dapa va du'shuma ñoa'me in'jan'da tsu ñama'qque ñoa'me in'jan. Majan ñama ñoa'me in'jan'da tsu ñama moen'su Chigama'qque ñoa'me in'jan. Majan que'i'su utu'ccoa'ta tsaja ñoa'me ti'tsse'tssia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juanjan pañamba su: —Na'su, atte'fa gi a'i'ma que inisema afapa cocoyama joqquitssian'jen'choma. Tsa'ma tise ingi'ccu fae'ngae jacambisi gi tisema se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tsa'ma Jesúsja su: —Tisema se'pi'fajama. Majan que'ima chi'gambi'ta que'ima fuite'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","52","Tisu papa sefacconi jaya'cho pan napijisi Jesúsja tansintsse Jerusaléni jaye ashaen. Tisema o'tie a'ima moensi japa Samaria ande'su canqqueni ca'ni'fa tsa'ove afaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tsa'ma Samariasundeccuja Jesús Jerusaléni jayi qquen pañamba se'pipa tsa'oma afe'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tsonsi Jesúsma shondosundeccu, tsa Santiago, Juan'qque pañamba iyicca'yepa su'fa: —Na'su, ¿in'jan ti qui ingi Elías'caen Chigama iñajañe cuintsu si'nge sefaccone amppipa va samariasundeccuma oque catiye? ");
INSERT INTO conNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tsa'ma Jesúsja piyicamba tise'pama iyu'upa su: —¿Atesu'fambi ti qui que'inga ca'ni'cho Qquendya'pama? ");
INSERT INTO conNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sefaccone Ji'cho A'i gi jimbi a'ima fitti'ttiye. Tsa'ma a'ima ccushaeñe gi ji. Qquen supa faesu canqqueni ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tsaiqui'ye jayisi a'ija Jesúsma su: —Na'su, mani que ja'ni'qque ña'qque fae'ngae jaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesúsja tisema su: —Quiyata tsu tise'pa ana'jen'cho changove an'bian'fa. Chhiriria'qque tise'pa tsao'pave an'bian'fa. Tsa'ma Sefaccone Ji'cho A'i gi mani japa anaña'chove an'biambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cca'ima Jesús qquen su: —Ñai'ccu fae'ngae jija. Tsa'ma tsa a'ija su: —Na'su, shondo'jeja. Ña yaya pasi a'tupa gi quei'ccu jaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tsa'ma Jesúsja tisema su: —Antteja cuintsu ñame in'jambindeqquia tsa'caen vasepa pa'chondeccuma a'tuye. Tsa'ma queja ñame in'jamba japa ma'caen Chiga aindeccuve dapa canseya'chone condaseja. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Faesu a'ija su: —Na'su, ña gi quei'ccu fae'ngae jaya. Tsa'ma o'tie tsaoni japa gi ña antiama chigambiamba jiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tsa'ma Jesúsja tisema su: —A'ija vaurai'ccu andema chhochho'jepa sepacconima piyican'da tansintsse jaye oshambi. Tsa'caen majan a'i ñame in'jamba toya'caen tayo'su in'jan'choma in'jan'da Chiga a'ive daye oshaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Omboe Jesúsja faesu setenta tisema shondosundeccuma ttu'sepa mani tisu jaye tson'jen'ni dosve dosve mandamaña. Majan canqqueni tise jayani tsendeccuma o'tie mandamaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tise'pama su: —Nasipanga jon'cho cu'chosi taiya'cho napiqquia'caen tsu a'ija pañañe ronda'je'fa. Tsa'ma taisundeccu shacaqquia'caen tsu Chiga ñotsse condase'choma condasesundeccuja shaca. Chiga Quitsaja taiya'cho na'su tsu. Tisema iñajan'faja cuintsu ti'tsse'o a'ima ttu'sesi fuite'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Que'ija vama in'jamba jaja'faja: Oveja du'shuma ttesi andenga mandamañaqquia'caen gi que'ima mandamaña'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tsa'ma corifin'di bosama angajama. Ni o'va, ni sapatoma angajama. Tsaiqui'ye japa cca'indeccuma bia've chigambian'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Majambe tsa'onga ansunde'ta na'suma chigambian'faja cuintsu opatsse canseye. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chigave in'jan'chondeccu tseni can'jen'da tsu que'i chigambian'choma pañamba tsa'caen opatsse canse'faya. Tsambi'ta chi'ga'fasi que'i su'cho toequi shandasi qui que'i opatsse canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Majan tsa'onga ca'ni'da tse'tti can'jen'faja. Can'jemba tise'pa anqque'suma an'faja. Tise'pa cui'ccuma cu'i'faja. Nane sema'su semasi tsu afepoeña'cho. Que'ija atesiansi tsu o'fiaña'cho. Cca'tti cca'tti faesu tsa'onga ja'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tsa'ma fae canqquenga ca'nimba que'ima ñotsse chigambiansi tise'pa que'inga afe'cho anqque'suma an'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tise'pani'su pajisundeccuma ccushaen'faja. Tsenisundeccunga conda'faja: “Ca'tsa tsu napiji que'i Chiga aindeccuve da'faya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tsa'ma majan canqquenga ca'nisi ñotsse chigambian'fambian'da tsa canqque'su atandundunga japa tsa'su a'ima qquen condase'faja: ");
INSERT INTO conNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Que'i ingima chi'gasi ccane'qque gi va canqque'su andema chi'ga'fa. Nane ingi tsu'ttema'qque gi ccucha'fa. Va ccuchaye'je'cho ande tsu que'i egae tsincon'choma canjaen. Tsa'ma Chiga aindeccuve daya'choja ca'tsa napiji qquen condasesi qui ja'ño tayo paña'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ñoa'me gi su maqui a'ta Chiga a'i injama'choma somboe'nijan tsa canqquesundeccu tsu bove dyo'otsse da'faya. Nane tayopi'su Sodoma canqque'su egae tsinconsundeccuma bove dyo'otsse tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Vana'faya qui Corazín canqquesundeccu! ¡Vana'faya qui Betsaida canqquesundeccu! Que'ija ñotsse Chiga tson'choma atte'fa. Nane Chiga tsa'caen Tiro, Sidón canqquema tsoña'choecan'da tsu junde tseni'su aindeccuja tise'pa egae tsincon'choma chi'gapa Chigama iñajan'faye'can. Ñombi'ye'choma canjaenqque'su sarupama ondiccupa cusepai'ccu tsu onjon'faye'can tise'pa in'jan'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsa'ma injama'choma somboeña'cho a'ta napisi Tiro, Sidón canqquesundeccuja que'ima bove aiye'pambi'ccoe vana'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Toya'caen que'i Capernaum canqquesundeccu: ¿Asi'ttaen'fa ti qui Chiga que'ima in'jamba sefacconi angaye'ja? Me'i, tsa'ma si'nge anchanda'je'chonga tsu que'ima catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Majan que'ima paña'da ñama tsu paña'fa. Majan que'ima chi'ga'ta ñama tsu chi'ga'fa. Majan ñama chi'ga'ta ñama moen'su Chiga Quitsama'qque tsu chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsa setenta Jesúsma shondosundeccu ja'fa'cho toequi jipa avujatsse bopa su'fa: —Na'su, que inisema afapa gi osha'choma manda'fa. Cocoyama'qque a'iye somboye mandasi tsu sombo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tsa'caen susi Jesúsja tise'pama su: —Ju ñoa'me tsanda veyenqquia'caen Satana sefaccone amppi'choma gi atte. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Que canjan! Tayo gi antte que'ija tini, iyonga tsui'a'qque qui vana'faya'bi. Que'ima chi'gasundeccuma qui patsu'faya. Me'i'on tsu jongoesu que'ima dañoña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tsa'ma tsa'caen cocoya que'ima pañamba sombo'fa'ni'qque panshaen avuja'fajama. Que'i Chiga a'ive dasi tsu Chigaja que'i inisema sefacconi tevaen. Tsane avujatssi'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tse'faei'ccuyi Chiga Qquendya'pa Jesúsma in'jaensi avujapa Chiga Quitsama qquen afa: —Yaya Chiga Quitsa, Que qui Sefacconi'su Na'su. Pa'cco ande'su Na'su qui. Tsa'ma va ande'su injama'pandeqquianga qui tisuma canjaembi. Atesu'chondeccunga canjaembipa qui va aindeccunga tisuma canjaen. Ñotssia du'shu pañaqquia'caen tise'paja ñotsse pañamba in'jan'fa. Yaya, ñotsse qui tson. In'jamba que tsa'caen anttesi gi avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tsa'caen Chigama iñajamba Jesúsja su: —Tayo tsu ña yayaja osha'choma ñanga afe. Cca'i ñama atesu'fambisi Chiga Quitsayi tsu ñama atesu'cho. Ñajan Tise Dutssi'ye. Toya'caen cca'ija Chiga Quitsama atesu'fambisi ñañi gi Tisema atesu'cho. Tiseja ña yaya tsu. Toya'caen ñajan Chiga Dutssi'yepa gi majama in'jan'da tsanga condase cuintsu tsendeccu'qque Chiga Quitsama atesu'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsomba Jesúsja piyicamba tisema shondosundeccunga a'tutsse su: —Que'i tso'fei'ccu osha'cho va tson'choma attepa qui ñoa'me avujatssi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ñoa'me gi su: Tayopi'su nasundeccu, tayopi'su Chiga Aya'fama afasundeccu'qque que'i atte'choma atteye in'jan'ma osha'fambi. Que'i paña'jen'choma pañañe in'jan'ma osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsonsi Chiga manda'choma atesu'cho jangi ccutsupa Jesúsma qqueñañe in'jamba su: —Na'su, ¿jongoesuma gi tsoña tsangae canseye'ta? ");
INSERT INTO conNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesúsja tisema su: —¿Jongoesu qquen tsu Chiga manda'choja su? Queja Chiga tevaen'jema zutsse can'da ¿jongoesu qquen qui in'jan? ");
INSERT INTO conNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tiseja pañamba su: —Na'su que Chigama ñotsse in'jaña'cho. Nane pa'cco injama'choi'ccu, pa'cco que in'jan'choi'ccu, pa'cco que quin'sui'ccu tsu Na'su Chigama ñotsse in'jaña'cho. Toya'caen faenga'suma tisuma'caen ñotsse in'jaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tsonsi Jesúsja tisema su: —Ñotsse qui in'jamba su. Tsa'caen tson'da qui canseya. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tsa'ma Chiga manda'choma atesu'choja toya Jesúsma qqueñañe in'jamba tsu condase'chone ti'tsse iñanjampaña: —¿Majan tsu “ña faenga'suta”? ");
INSERT INTO conNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsonsi Jesúsja su: —A'i Jerusaléne sombopa Jericó canqqueni ande jisi ccanambandeccuja tisema indi'fa. Indipa tsu pa'tssima cca'na'fa. Tise ondiccu'je'cho sarupama'qque oshichhaemba tisema ochhai iñaccaen'fa. Paye tson'jen qquen in'jamba tisema catipa ja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsama atesumbi'ma Chigama afa'su'qque tsa tsaiqui'ye jayipa ccanange'suma atte'ma catsembe'yi tsaiqui ccafa'su utufa'ye tsui panshamba ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Toya'caen Leví a'i'qque tsangae napipa a'ima atte'ma ccafa'su utufa'ye panshamba ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tsonsi fa'e samaria'su a'i'qque tsu tsaiqui'ye jayipa atte. Nane samariasundeccu israendeccui'ccu ñotsse jincho'fambi. Tsa'ma tsa samaria'su a'ija ccanange'suma attepa mende'ye. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mende'yepa catsepa vino, yayapai'ccu tise iñacca'choma se'je. Se'jepa sarupai'ccu tandan. Tsomba tisu boronga a'ima otsian dyaiñamba anga jacansundeccu ana'jen'cho tsa'onga. Tseni tisema coira'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ccaqui a'ta jaye tson'jemba tsa'o na'suma ttu'sepa cincuenta corifin'dive afepa su: “Tisema ñotsse coiraja. Tisema coiraye ti'tsse chavasi shaca'nijan ña toequi jayipa gi pa'ccoma quenga afepoeña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jen'da, va tres a'i'su, Chigama afa'su, Leví a'i, samaria'su a'i, ¿majan tsu ñoa'me tsa ccanange'suma “tisu faenga'su” qquen in'jan? ");
INSERT INTO conNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chiga manda'choma atesu'choja su: —Tisema mendeye'su tsu “faenga'su” qquen gi in'jan. Tsonsi Jesúsja su: —Que'qque tsa'caen poiyi'ccoma ñotsse in'jamba canseja. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús, tisema shondosundeccu'qque japa faesu canqquenga ca'ni'fa. Fa'e pushesuja, Marta, tseni can'jen. Martaja Jesúsma tisei'ccu jacansundeccuma'qque chigambiamba tise tsa'onga ca'nian. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta que'tte, María, Martai'ccu fae'ngae can'jemba Jesús atesian'jen'choma pañañe in'jamba tise tsutteccofanga dyaipa paña'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tsa'ma Martaja osha'choma ñoñañe tisuyi vase'jepa iyicca'yepa Jesúsnga jipa su: —Na'su, in'jambi ti qui ña que'tte ñama catisi gi tisuyi vase'je. Tisema mandaja cuintsu ñama fuiteye. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tsa'ma Na'su Jesús Martama su: —Marta, Marta, iyicca'yembe canjan. Panshaen qui asi'ttaemba osha'chove ñoñañe vase'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ingima cui'ñambayi antteja. Maríata tsu ñotssiama in'jamba paña'jensi gi tisema se'pimbi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maquita Jesúsja Chigama iñajan'jen. Iñajan nanisi fa'e tisema shondo'suja jipa su: —Na'su, ingima atesianjan ma'caen Chigama iñajañe. Nane feti'su Juanjan tisema shondosundeccuma tsa'caen atesian. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsonsi Jesúsja tise'pama su: —Que'ija Chigama iñajañe in'jan'da qquen su'faja: Sefacconi Canjen'su Na'su, ingi Quitsa, que qui ñoa'me joccapitssia. Que inise tsu egave metssipa ti'tsse'tssia. Queyi Na'suve dapa poima mandaja. Que in'janqquia'caeñi pa'cco tsu jinchoja. Que sefacconi mandaqquia'caen va andeni'qque mandaja. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Poi a'ta coirapa ingima an'bianjan ingi cu'ipa amba canseye. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ingi quema egae tsincomba shacaen'choma aqquepoenjan, ingima egae tsincomba shacaensundeccuma aqquepoenqquia'caeñi. Ingi egae tsinconsa'ne ottuni ttupa coiraja. Tsomba osha'cho ega'ye ingima ccushaenjan. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tsomba Jesús tisema atesiamba su: —Va aqquia condase'choma asi'ttaen'faja: Majan que'i'su enttinge cose faenga'su tsaoni japa qquen tsu su: “Ccashe'ye, tres panme ñanga afeja. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Faesu ña amigo biani jacamba ña tsa'onga napisi gi ñajan jongoesuma o'fiaña'chove mecho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Qquen susi tsu suya: “Ñama noñangianjama. Tayo sombo'ttima piccopa gi ña dushundeccui'ccu ana'jen'fa. ¿Ma'caen gi ja'ñojan jangipa panma quenga afeya?” ");
INSERT INTO conNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tsa'ma ñoa'me gi su, tiseja tisu amigombi'ma'caen jangipa quenga afembipa pashaen noñangiansa'ne tsu jangipa osha'cho que in'jan'choma afeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tsa'cansi gi que'inga su: Iñajan'ninda tsu Chigaja afeya. Ttatta'ta qui atte'faya. Sombo'ttima tssai jeña'ninda na'su tsu fettaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nane poiyi'cco majan iñajan'da tsu isu'faya. Poiyi'cco majan tta'tta'ta tsu atte'faya. Poiyi'cco majan tssai jeña'da na'su fettasi tsu ca'ni'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Majan que'i'suja du'shuma an'bian'fa. ¿Que du'shu panme iñajan'ninda ti qui patuma afeya? ¿Avuve iñajan'ninda ti qui avuma se'pipa iyoma afeya? ");
INSERT INTO conNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Arapandusu'chove iñajan'ninda ti qui tinima afeya? Me'i. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Que'ija ño'ambi'a'qque tsa'caen que'i dushundeccunga ñotssiama afeye atesusi ñoa'me tsu Sefacconi'su Na'su Chiga Quitsaja bove ñotssiama afeya. Nane majan Tisema iñajan'ninda tsu tsanga Tise Qquendya'pama afeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ayafambie da'choma Jesúsja cocoyama joqquitssian. Cocoya joqquitssisi afa'jembi'choa afa'jesi poiyi'cco a'i can'boen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tsa'ma majan a'ija su'fa: —Cocoya na'su Beelzebú va Jesúsma in'jaensi tsu tsa'caen cocoyama joqquitssiañe osha. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tsa'ma cca'indeccuja Jesúsma qqueñañe in'jamba tisema iñajan'fa cuintsu sefacconi'su canjaen'choma canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tsa'ma Jesúsja a'i qqueñañe in'jan'choma in'jamba tise'pama su: —Majan ande'su a'i tisupanaccui'ccu chi'gacco'fa'nijan tsa ande tsu népiya. Fae etti'sunaccu iyicco'ta fae'ttini can'jeñe osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsa'caen Satana tsa Beelzebú qquen su'cho tisuma chi'ga'ta ¿ma'caen tsu tiseja na'sia'caen mandaya? “Beelzebú Jesúsma in'jaensi cocoyama joqquitssian'jen” qquen qui su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ñama tsa'caen tsa in'jaen'ninda ¿majan tsu que'ima shondosundeccuma in'jaen cuintsu tise'pa cocoyama joqquitssian'faye? Nane que'ima shondosundeccuja que'i qque'choma tsu canjaen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tsa'ma Chiga Qquendya'pa ñama in'jaensi gi cocoyama joqquitssian'jen. Tsa'caen in'jaemba canjaensi qui Chiga osha'choma oshachopa ma'caen manda'choma atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Quin'an a'i tise matichi'ccu tisu tsa'oma ñotsse coira'ninda ¿majan tsu tise an'bian'choma cca'nañe oshaya? Nane Satanajan tsa'can tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tsa'ma faesu tisema ti'tsse quin'an iyiccoye ji'ta tisema tsu patsuya. Nane tsa quin'an a'imbe matichima itsa'ninda ¿ma'caen tsu tisuma ccushaeña? Tisema patsupa tise an'bian'choma angapa attufaeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Majan fae'ngae ñai'ccu semambi'ta ñai'ccu iyicco'su tsu. Toya'caen majan ñai'ccu fae'ngae taimbi'ta ñoa'me shequian cati'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Cocoyaja a'i'ye joqquitssipa cocoya can'jeni ñombi'ye jacán. Tsa'ma tsa'caen ñombi'yepa oshambipa tisuma su: “Ña mane somboni gi toequi jaya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Toequi japa atte tayo tsa'oma funduipa ñoñaqquia'caen tsu a'ija ñotsse injienge. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Attepa japa tisema bove ega siete cocoyama'qque i'ngasi poiyi'cco tsu tsa a'inga ca'nimba can'jen'fa. Tsonsi tayoe'ma bove ega tsu tsa a'ine. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús tsa'caen su'je'ni pushesuja a'i bo'cho'ye fundondo'e tisema su: —Que mamajan quema isupa coeña'supa tsu ñoa'me avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tsa'ma Jesúsja su: —Ju, tsa'ma majan Chiga Aya'fama pañamba tson'da tsa tsu ti'tsse avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A'i ti'tsse bo'fasi Jesúsja su: —Ja'ño'su aindeccuja egae in'jamba sefacconi'su canjaen'choma in'jan'fa. Tsa'ma tayopi'su Chiga Aya'fama afa'su Jonás canjaen'chove'yi canjaemba Chigaja faesu canjaen'chove canjaeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tayopi'su Jonásja Nínive canqque'su aindeccunga Chiga canjaen'chove tsu da. Ñajan Sefaccone Ji'cho A'ipa gi ja'ño'su aindeccunga Chiga canjaen'chove daya. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Osefaeña'cho a'ta napisi ja'ño'su aindeccuja Nínivesundeccuma bove egae tsu canjaen'faya. Tsendeccuja Jonásma pañamba tisupa egae tsincon'choma chi'ga'fa. Jonásma ti'tsse'tssia gi ja'ño can'jen'ma qui que'i egae tsincon'choma chi'ga'fambi. Toya'caen tayopi'su Sabá ande na'su pushesuja biane ji Salomón ñotsse in'jamba su'choma pañañe. Osefaeña'cho a'ta napisi tise'qque ja'ño'su aindeccu bove ega qquen canjaeña. Salomónma ti'tsse'tssia gi ja'ño can'jen'ma que'ija ñama paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A'ija tuñoma setsaemba a'tu'faya'mbi. Ni cafon tsosiccunga ccutsian'faya'bi. Tsa'ma sefani tsu ancaeña'cho cuintsu majan ca'ni'da ñotsse atte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Que tso'fe'qque ai'vo'su tuño tsu. Tso'fe ñotssimajan ai'voja a'tatssiani can'jen. Tsa'ma tso'fe ñotssimbian'da ai'voja sinttia'ni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tsa'cansi injama'tse, sinttia'ni can'jenqquia'caen que'i injama'cho egae in'jaensi egae cansesa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tsa'ma ai'vo a'tatssiani can'jenqquia'caen que'i injama'cho ñotsse in'jaensi egae in'jan'chove me'isi qui ñotsse a'tatsse canse'faya. Tuño a'tatsse attianqquia'caen tsu que'i tso'feja que injama'choma attian. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús afa nanisi fa'e fariseo a'i tisema ttu'se tise tsaoni japa añe. Ttu'sesi japa Jesúsja an'jen'cho mesa jin'ttinga dyai. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesús añe tson'jemba fariseo in'janqquia'caen tivema otishimbisi fariseoja can'boen. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tsa'ma Na'su Jesúsja tisema su: —Que'i fariseondeccuja apisho'tto, tasa sepaccoma cashisi naccuja toya amundetssiqquia'caen ñotsse attiamba que'i injama'choni toya egae in'jamba qui egae tsincon'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ñoa'me injamambi'fa qui! ¿Sepaccove ñoña'suta ti naccuve'qque ñoñambi? ");
INSERT INTO conNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bove ñotssi tsu que injama'choni ñotsse in'jamba tsa'caen cca'indeccunga ñotsse tsoña'cho cuintsu Chigama ñoa'me avujaeñe. Que'i injama'cho ñotssimanda qui ñoa'me pa'cco giya'tssi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Tsa'ma vana'faya qui fariseondeccu! Que'ija osha'choma fae decimoveyi Chiganga afeye atesu'fa Tisema avujaeñe. Nane pa'cco ccoma, pa'cco shinccapama'qque qui fae decimoveyi Chiganga afeye atesu'fa. Tsa'ma ñotsse qui tson'fambi ni Chiga a'ima in'janqquia'caen in'jan'fambi qui. Que'i Chiganga afe'je'choma aqque'pambe'yi a'ima in'jamba ñotsse tson'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Vana'faya qui fariseondeccu! Chigane atesian'jen'ttinga japa bove ñotssia dyaipa'chove qui in'jan'fa. Chava'je'cho atandundunga japa qui chigambianccoye in'jan'fa cuintsu poiyi'cco a'i que'ima attepa que'ija ti'tsse'tssia qquen in'jan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Vana'faya qui Chiga Aya'fama atesu'chondeccu, fariseondeccu'qque! ¡Ñotsse attianqquia'caen tsomba injama'choni egae in'jansundeccu qui! A'i atesumbe'yi pa'chombe atu'ttimbe omba'ye tsui jaqquia'caen a'ija que'i egae in'jan'choma atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tsonsi fa'e Chiga Aya'fama atesu'cho Jesúsma su: —Atesian'su, tsa'caen fariseondeccune condasepa qui ingima'qque afase. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Qquen susi Jesúsja su: —¡Vana'faya qui que'i Chiga Aya'fama atesu'chondeccu! Que'i'qque osha'cho manda'choi'ccu a'ima vanaen'fa. Tise'pa oshambi'ni'qque qui fuite'fambi. Ni tive utufa'su tsimian'ccoi'ccuyi'qque qui fuite'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Va'cha'fa qui! Que'i yayandeccu Chiga Aya'fama afasundeccuma fi'ttisi que'i'qque Chiga Aya'fama afasundeccumbe atu'ttive patui'ccu ñotsse ñoña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tsa'caen tsomba qui que'i yayandeqquia'caen fae'ngae ega'fa. Que'i yayandeccu a'ima fi'tti'fasi que'ija ñotssi tsu qquen in'jamba pa'chombe atu'ttive ñoña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chigaja osha'chone in'jamba tayoe su: “Ña aya'fama afasundeccuma ñane condasesundeccuma'qque gi manda moeña. Tsa'ma aindeccuja majan tsendeccu'suma fi'tti'faya. Majan tsendeccu'suma noñangiamba vanaen'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nane Chiga suqquia'caen a'ija tsa'caen ande agattointe ashaemba Chiga Aya'fama afasundeccuma fittitti'fa. Nane Chigaja tsendeccu shacane'qque tsu va ja'ño'su aindeccuma iñajaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Me'ttia'ye tayopi'su Abelma fi'tti ashaemba fitti'tti canse'fa. Voeyiyitsse Zacaríasja Chiga ettini ccutsupa Chiganga oque oraen'jen'cho jin'tti Chiga Aya'fama condase'je. Condase'je'ni tisema fi'tti'fa. Tsa'caen tsomba tsu shacapa'fa. Shacama tsa'caen boñasi tsu Chigaja va ja'ño'su aindeccuma iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Vana'faya qui manda'choma atesu'chondeccu! Que'ija tansintssia Chiga Aya'fama atesupa se'pi'fa cca'indeccu paña'sa'ne. Tansintsse su'choma atesu'ma qui tsama chi'ga'fa. Cca'indeccu atesuye in'jan'ninda qui se'pi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús tsene sombojisi Chiga Aya'fama atesiansundeccu, fariseondeccu'qque iyicca'yepa Jesúsma noñangiamba zutsse iñajansepoen'fa cuintsu Jesús osha'chone afapa qqueye. ");
INSERT INTO conNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ron'da'fa Jesús ccaningae su'chove su'ninda pañamba tise injama'choma somboeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tsomba tse'i ti'tsse'o a'i bopa tayosi tisupapora tsuicco'fa. Tsa'caen bo'fasi Jesúsja tisema shondosundeccuma su: —Injama'tse. Fariseondeccuja ñotsse attiañe in'jamba afopoemba tsa'caen tson'fa. Injama'tse, tise'pa'caen tsonsa'ne. Nane tise'pa egaja cupana'ccoa'caen a'tu'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Osha'cho ja'ño a'tu'chota jai'ngae canjaeña'cho. Ja'ño atesumbi'choa'qque jai'ngae atesuya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Que'i jongoesuma a'tutsse cose condase'ni'qque jai'ngae a'ta'nijan poiyi'cco tsu a'tatsse paña'faya. Que'i tsa'o'su cuarto'ye a'tutsse afa'ni'qque jai'ngae tsao'cco ombanga ccutsupa fundo'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","In'jan'chondeccu, ñoa'me gi su dyo'fajama majanda que'i ai'voma fi'ttiye osha. Tsa'caen fi'tti'ma ti'tsse dañoñe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tsa'ma que'inga gi condaya majama dyo'faya'chove. Chigaja a'ima fi'tti'ta tise canse'pama'qque si'nge anchanda'je'chonga catiye osha. Tsa'cansi gi que'ima su: Chigama tsu dyo'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A'ija chhiririama chavaen'fa. Cinco chhiririama tsu dos reave chavaen'fa. Tsa'ma tsa'caen baratosi toya tsu Chigaja tsesu chhiririave injan'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nane Chigaja que tsove'su tosema agattopa injan'jen. Tsa'cansi dyombe can'faja. Chhiririama ti'tsse tsu Chigaja que'ima in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ñoa'me gi que'inga su: Majan ñame in'jamba dyombi'tsse cca'indeccunga condase'ninda ccane'qque ñajan tsane ñotsse afaya. Chiga sefacconi'su shondosundeccu paña'jen'ni gi afaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tsa'ma majan ñama chi'gapa cca'indeccunga ñama a'tie'ninda ccane'qque ñajan tsa a'ima chi'gapa Chiga sefacconi'su shondosundeccu caña'jen'ni tisema a'tieña. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Poiyi'cco majan Sefaccone Ji'cho A'ima afase'ninda tise tsa'caen egae tsincon'choja joqquitssiqque'su. Tsa'ma majan Chiga Qquendya'pama afase'ninda ñoa'me tsu tise egae tsincon'choja joqquitssi'masia. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ñame in'jansi que'ima indipa Chigane atesian'jen'ttinga anga'faya cuintsu nasundeccu, joccapitssiandeqquia'qque que'i injama'choma somboeñe. Que'ima tsa'caen iñanjansepoen'fa'ni'qque dyo'fajama jongoe qquen asi'ttaemba suya'chove tisuma ccushaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Que'i tseni ccutsu'ninda Chiga Qquendya'pa tsu que'ima in'jaeña jongoe qquen suya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","A'i bo'fa'cho'su fae a'i Jesúsma qquen iñajampaña: —Atesian'su. Ña quindya tsu se'pi. Tisema mandaja cuintsu yaya'ye pasi inginga afe'choma ñai'ccu attufaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tsa'caen susi Jesúsja tisema su: —Ccashe'ye, ñajan jimbi gi tsa'caen a'i injama'choma somboeñe ni osha'choma attufaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsomba Jesúsja poiyi'cconga su: —Injama'tse. Faesumbema in'jan'fajama. Osha'choma an'biambi'a'qque toya qui ñotsse canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tsomba Jesús va condase'choma conda: —Fae a'i osha'choma an'bian. Tise andeja ñotssiasi osha'cho ñotsse sho'yopa na. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsa'cansi a'ija asi'ttaemba tisuma su: “¿Ma'caen gi tsoña? Tayo tsu tsa'o on'ba pa'cco ña tai'choma boñamba an'biañe.” ");
INSERT INTO conNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ti'tsse asi'ttaemba tsu qquen in'jan: “Qquen gi tsoña: Ña taipa boña'cho tsa'oma asittapa gi faesu ti'tsse randeve tsao'ñaña. Tsanga gi pa'cco tai'choma an'biamba osha'cho ña an'bian'choma'qque coiraya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tsa'caen tsomba gi tisu injama'choni asi'ttaemba tisuma qquen suya: ‘Ñoa'me osha'choma an'biamba gi bo'tssingae ñotsse canseya. Semambe'yi gi canseya. An'jemba, cui'jepa avujatsse gi canseya.’ ” ");
INSERT INTO conNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tsa'ma Chiga Quitsaja tisema su: “¡Injamambi! Ja'ño cose qui paya. Que osha'choma boñamba an'bian'choja, ja'ño ¿majambe tsu?” ");
INSERT INTO conNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tsa'caen tsu daya poiyi'cco a'i majan Chiga in'jan'choma in'jambipa tisupa in'jan'choma boña'da. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tsomba Jesúsja tisema shondosundeccuma su: —Tsa'cansi gi que'ima su: Que'i vani canse'chone panshaen asi'ttaen'fajama. Que'i anqque'sune panshaen asi'ttaen'fajama. Que'i ai'voni jinqque'su sarupave'qque jongoesuma ondiccuye panshaen asi'ttaen'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ingi canse'cho tsu ingi anqque'suma ti'tsse'tssia. Ingi ai'vo tsu ingi ondiccu'je'choma ti'tsse'tssia. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pindoma canjan. Tsendeccuja jon'fambi ni tai'fambi. Ni taipa boña'je'cho tsa'ove an'bian'fambi. Tsa'ma Chiga Quitsa tsu tise'pama ofian'jen. Que'i qui ñoa'me pindoma ti'tsse joccapitssia. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Toya'caen ¿majan qui que'i'suja in'jamba fae a'ta ti'tsse canseye'ta oshaya? Ñoa'me qui oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tsa'caen que'ija va re'riccoa'ma oshambi'ta ¿ma'caen qui osha'chone panshaen asi'ttaen'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ñotssia te'tama can'faja. Aqquia tsu sho'yopa te'ta. Semambi ni tise'pa ondiccu'jema anchombi. Tsa'ma ¿majan tsu tisia'caen ondiccucho? Nane ti'tsse'tssia na'su Salomón'qque tisia'caen ñotsse ondiccu'chombi. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Shoshovija ja'ño injanga sho'yopa cansesi tu'i a'ija tsama taipa panme matssañe oque'faya. Tsa'ma Chiga Quitsaja tsa'caen te'tai'ccu shoshovima ñotsse ondiqquiamba ti'tsse tsu que'imajan ondiqquiamba coira'je. ¿Micomba qui in'jambe canse'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Panshaen asi'ttaen'fajama. Que'i anqque'suve, que'i cuiqque'suve ttatta'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Poi ande'su aindeccu tsu tsa'caen in'jamba canse'fa. Tsa'ma Chiga que'i Quitsaja tayo tsu in'jan que'i osha'chove in'jamba shaca'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bove ñotssi tsu Chigave in'jamba Tise in'jan'chove tta'ttaye. Tsa'caen cansesi tsu Chigaja que'ine osha'cho ñotssiave ñoñaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Que'i qui ña in'jan'cho ovejandeccu. Re'ricco'fa qui. Tsa'ma dyombe can'faja. Chiga que'i Quitsave in'jamba Tise in'jan'chove tta'ttasi tsu Tiseja que'ima na'suve tsoña. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Que'i vani an'bian'choma chavaen'faja mendeqquianga afeye. Tsa'caen afepa qui Chiga sefacconi osha'cho ñotssiama boña'faya. Tseni an'bian'choja mingui'te'qque sefaya'bi ni tssoruve daya'bi. Ccanamba'qque cca'nañe oshambi ni shipicco añe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mani que'i an'bian'choma coira'je'ta tsenima qui ti'tsse injan'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ondiccupa que'i tuñoma setsaemba ronda'je'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","A'i tise na'suve ronda'jeqquia'caen canse'faja. Nane tise'pa na'su casara'je'cho fiestane jipa sombo'ttima tssai jeña'nijan junde fettaye ronda'je'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Majan semasundeccuja tise'pa na'su ji'je'ni toya anambi'ta ñoa'me tsu avujatssi'faya. Ñoa'me gi su tsama attepa tsu na'suja mandaya cuintsu an'jen'cho mesanga dyai'faye. Tsomba na'suja osha'choma ñoñamba tise'be semasundeccunga o'fiaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nane enttinge cose tsambi'ta a'taningae na'su jipa tsa'caen ronda'je'choma atte'ninda ñoa'me tsu tsa semasundeccuja avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Toya'caen vama paña'faja: Tsa'o na'suja ccanamba jiya'chove atesuchoecan'da tsu tayo bittapa tise tsa'oma coiraye'can ccanamba ca'nisa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Que'i'qque ñoñamba ron'da'faya'cho. Atesu'fambi qui maqui Sefaccone Ji'cho A'i ccase jiya'choma. Que'i in'jambi'te gi ñajan jiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsa'caen susi Pedroja Jesúsma iñajampaña: —Na'su, ¿ingingayi ti qui va condase'choma condase? Tsambi'ta ¿poiyi'cconga ti qui condase? ");
INSERT INTO conNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tsonsi Na'suja su: —A'ija ñotsse in'janchopa na'su in'janqquia'caen tso'ninda tsama na'suja ti'tsse in'jan. Nane na'suja biani jaye tson'jemba tsanga manda antte cuintsu tise tsa'oma semasundeccuma coirapa poi a'ta tise'pama ofian'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tsomba na'su jai'ngae toequi jisi tsa sema'su, na'su mandaqquia'caen tso'ninda ñoa'me avujatssi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ñoa'me gi su, na'su jipa pa'cco tise an'bian'choma tsu tsa sema'sunga afeya cuintsu coiraye. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tsa'ma majan sema'su: “Ña na'suja uta jiya'bi” qquen in'jamba tsa sema'su faesu semasundeccuma tssaiye ashaemba majan tsandie, majan pushesuma'qque tsse'tsse tsincomba toya'caen an'jemba tse'tse'pama cu'ipa ccusi'ninda ");
INSERT INTO conNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tsa sema'su in'jambi'te tsu na'suja jiya. Na'su jipa tsu tsa sema'suma ma'ppipa in'jambindeccui'ccu fae'ngae tisema catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Majan sema'su na'su in'jan'choma atesu'ma ñoñambipa tsa'caen tsombian'da ñoa'me tsu na'su tisema quia'me ma'ppiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tsa'ma majan sema'su na'su in'jan'choma atesumbipa tsa'caen ñotsse tsombian'da re'riccoe tsu tisema ma'ppiya. Nane poiyi'cco majan ti'tsse isu'ta ti'tsse tsu tsoña'cho. A'ija majanga ti'tsse afe'ta ti'tsse tsu tsendeccune in'jan'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ñajan va andeni ji si'ngema setsaeñe. Ñoa'me tayo anchanda'je'ma'caen gi in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ñajan fetiyeqquia'caen vanaña'cho. Toya tsa'caen fetiyembipa gi injama'choni ñoa'me vana'jen. Tsa'caen gi vanaña'cho tsa feti'cho naniña'gae. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Jongoesu qquen qui asi'ttaemba in'jan'fa? ¿Ñanda ti gi va andeni ji cuintsu poiyi'cco a'i opatsse canse'faye? Me'i. Ñoa'me gi su, ñajan ji a'ima iyiccoeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ja'ño tsu fae tsa'o'su ñoa'me iyicco'faya'cho. Tres ñame in'jansi dos ñama chi'ga'faya. Tsambi'ta dos ñame in'jansi tres tsu ñama chi'ga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yaya tsu tise dutssi'yema iyicca'yeya. Dutssi'ye'qque tise yayama iyicca'yeya. Chanjan tise onque'ngema iyicca'yesi onquenge'qque tise mamama ccane'qque iyicca'yeya. Chan ccashe tise chinama iyicca'yesi china'qque ccane'qque chan ccashema iyicca'yeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Toya'caen tsu Jesúsja a'i bo'fa'chonga su: —Que'ija chiga amppije'ni unjimba jinchoma attepa qui: “Unjin tuiye tson'jen” qquen su'fa. Qquen su'fa'nijan tsa'caen tsu tui. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Neguev andefae fingian jisi que'ija su'fa: “Ñoa'me coe'jeye tson'jen.” Qquen susi tsa'caen tsu coe'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ñotsse in'janqquia'caen supa aqquia afopoensundeccu qui. Que'ija sefaccoma camba qui osha'choma tsa'caen atesu'fa. Tsa'ma ña ja'ño tsoña'choma atte'ma qui atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Micomba qui injama'choni asi'ttaen'fambi ñotsse tsoña'chove in'jañe? ");
INSERT INTO conNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nane a'i quema iyicca'yepa na'sunga angaji'ninda toya na'sunga napimbi'teyi tsu tisema ñoquiaña'cho. Ñoquiambian'da na'su tsu capitáma mandaya cuintsu que'ima indiye. Capitán tsu picco'je'cho ettinga que'ima piccoya. ");
INSERT INTO conNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ñoa'me gi su, tseni picco'ninda pa'ccoma nane reama'qque tsu afepoeña'cho tisu somboye. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tsequi a'ta majan a'i Jesúsnga jipa condase'fa ma'caen ande na'su governaror Pilato Galilea aindeccuma fi'tti'choma. Tsa aindeccuja Chigama iñajañe tise'pa afe'cho ovejama ipa fi'tti'fa. Oveja anjampa tssain jasi pa'fasi Pilatoja sundarondeccuma mandasi tsa aindeccuma fi'tti'fa. Fi'tti'fasi tise'pa anjampa'qque oveja anjampai'ccu echhoen fae'ngae tssain ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesúsja pañamba su: —¿Jongoesu qquen qui asi'ttaen'fa? ¿Va Galileasundeccuta ti cca'i Galileasundeccuma ti'tsse egae tsincon'fa? ¿Tsa'camba ti tsa'caen vaná'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Me'i. Tsa'ma que'i'qque que'i egae tsincon'choma chi'gapa ántteya'cho tsendeqquia'caen pasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Toya'caen voeyi tsu Siloé'su se'fatssia tsa'o osuipa amppisi diez y ocho a'i pa'fa. ¿Tsendeccuta ti poiyi'cco Jerusalensundeccuma ti'tsse shacapa'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Me'i. Tsa'ma que'i egae tsincon'choma chi'gapa ánttembi'ta que'i'qque qui tsa'caen pa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsomba Jesúsja va condase'choma conda: —A'ija higuera teta'choma tise ovaccuni jon. Tise naite na'suja jipa name tta'tta'ma attembi. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsomba ovaccuma coira'sunga su: “Tres canqque'fave gi jipa name tta'tta'ma attembi. Ttuttu catija. Ño'a andenga najema'can qui aqquia aten'jeña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tsa'ma coira'suja su: “Na'su, cuintsu ttuttumbe'yi va canqque'fama ronda'jeja. Ñajan va quini'cco setsa'cho'su andema vuviamba vaura ccopai'ccu echhochhoeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsonsi faesu naite na'ninda tsu ñotssi. Tsa'ma nambian'da ttuttu catiya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Fae sema'ma'qquia a'ta Jesúsja Chigane atesian'jen'ttinga japa atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tse'tti pushesu paji'su can'jen. Diez y ocho canqque'fave cocoya tisenga ca'nisi puntssan antteyepa tansintsse ccutsuye oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesúsja tisema attepa ttu'sepa su: —Pushesu, tayo qui ccusha que paji'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Qquen supa tise tivei'ccu pushesuma pporaen. Tse'faei'ccuyi tise ai'vo tansinsi pushesuja Chigama ñotsse afa. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsa'ma Chigane atesian'jen'tti'su na'suja Jesús sema'ma'qquia a'ta ccushaensi iyicca'yepa a'inga su: —Seis a'ta tsu semaña'choja. Tsesu a'tayi tsu jipa ccushaengeya'cho. Tsa'ma sema'ma'qquia a'taja ji'masia. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsonsi Na'su Jesús su: —Que'ija ñotsse attianqquia'caen supa aqquia afopoensundeccu qui. ¿Majan que'i'su qui sema'ma'qquia a'ta tisupa vaurama tisupa boroma'qque ccupa'fambi naini angapa cui'ñañe? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tsa'candeqquia'ta ¿ma'caen qui cocoya na'su Satana va pushesuma diez y ocho canqque'fave noñangiansi sema'ma'qquia a'ta ña ccupaqquia'caen ccushaen'ninda se'pi'fa? Nane tise'qque tayopi'su Abraham aindeccumbe onque'nge tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús tsa'caen susi poiyi'cco tisema iyiccayesundeccu ansange'fa. Poiyi'cco a'i Jesús ñotsse tson'choma attepa ñoa'me avujatssi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tsa'caen tsonsi Jesúsja su: —A'ija Chiga aindeccuve dapa ti'tsse tsu atapa'faya. Tsane condaseye in'jan'ma ¿jongoesui'ccu gi condaseya? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ñoa'me tsu a'i Chiga aindeccuve da'faya'cho chipiri mostasa cho'can'chocco. A'ija mostasa choma tise nasipanga jonsi sho'yopa quini'jime dasi chhajeqque'su chhiriria jipa ttembanga tsao'paen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Toya'caen Jesúsja su: —Ma'caen a'i Chiga aindeccuve dapa ti'tsse atapa'faya'chone condaseye in'jan'ma ¿jongoesui'ccu gi condaseya? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nane cupana'ccoa'ca'on tsu. Pushesu panme ñoñaqque'su tres agatto'chonga cupoensi coemba pa'ccoma atapoen. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsomba Jesús rande canqque, chipiri canqque'ye jacamba a'ima atesian'jen. Tsa'caen jacamba Jerusaléni napisi ");
INSERT INTO conNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","fae a'i tisema iñajampaña: —Na'su, ¿re'ricco a'i ti ccusha'faya? Jesúsja tisema su: ");
INSERT INTO conNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ta'yoquicco tsu Chiga sefacconi ca'niña'choja. Tsa'ma tsangae ca'nicanjan. Nane tsain'bio a'i ca'niñe in'jan'ma osha'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tsa'o na'su tayo jangipa sombo'ttima piccosi qui que'ija tsotefanga ccutsupa tssai jeñañe ashaen'faya qquen supa: “Na'su, sombo'ttima fettaja ingi ca'niñe.” Tsa'ma tiseja que'ima suya: “Ñanda gi que'ima atesumbi. Ni mane ji'chove'qque gi atesumbi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsonsi qui qquen su'faya: “Tsa'ma fae'ngae quei'ccu an'jemba gi cu'i'fa. Queja ingi tsaiquini japa atesian.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tsa'ma tiseja suya: “Ñoa'me gi su: Ñajan que'i mane ji'chove atesumbi. Que'i egae tsinconsundeccuja, ña'ñe joqquitssi'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahamma qui atte'faya. Isaac, Jacob, nane poiyi'cco Chiga Aya'fama afasundeccuma'qque qui atte'faya. Tsendeccu Chigai'ccu can'jensi que'ija tsotefanga joqquitssiangepa qui i'na'faya. Ñoa'me ttun'dundu'jeve iyicca'yepa qui i'na'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nane poi andene tsu a'ija jipa bo'faya Chigai'ccu an dyaiye. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","¡Que canjan! Majan ja'ño utu'ccoa'ta ti'tsse'tssia've tsu da'faya. Tsa'ma majan ja'ño ti'tsse'tssia'ta utu'ccoa've tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Toya Jesús tsa'caen atesian'jen'ni majan fariseondeccu jipa tisema su'fa: —Va'ttieja junde jaja. Ande na'su Herodes tsu quema fi'ttiye in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesúsja pañamba tise'pama su: —Herodesja afopoen'su tsu. Japa tisenga qquen su'faja: “¡Que canjan! Ñajan ja'ño a'ta, tu'i'qque cocoyama joqquitssiamba a'ima ccushaen'jeña'cho. Tui've gi naniña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tsa'ma que'inga gi su: Ja'ño a'ta, tu'i, tui've'qque gi dyombi'tsse jacaña'cho. Nane Chiga Aya'fama afa'su Jerusaléni can'jembian'da ¿ma'caen tsu tisema fi'tti'faya? ");
INSERT INTO conNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén, Jerusalensundeccu, Chiga Aya'fama afasundeccuma qui fi'tti'fa. Chigaja majama que'inga moensi atesiansi qui patui'ccu fi'tti'fa. Tsain'bitsse gi in'jan que'ima coiraye. Nane arapa chan tise du'shuma sanccopai'ccu piccopa coiraqquia'caen gi que'ima coiraye in'jan. Tsa'ma que'ija in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Que canjan! Chigaja que'i can'jen'ttima tsu catiya. Ñoa'me gi su, Ccatsse qui ñama atte'faya'bi que'i ñama qquen suya'ngae: “Ñoa'me ñotssia tsu Na'su Chiga moensi ji'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Fae sema'ma'qquia a'ta Jesúsja fariseo in'jan'cho na'sumbe tsaoni añe ja. Cca'i fariseondeccu Jesúsma camba ronda'je'fa egae afaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Toya'caen tsa tsaoni tsu can'jen a'i ttun'dundu'je'e dapa paji'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesúsja Chiga Aya'fama atesu'chondeccuma, fariseondeccuma'qque su: —¿Chiga manda'chota ti se'pi sema'ma'qquia a'ta a'ima ccushaeñe'ja? Tsambi'ta ¿se'pimbi ti? ");
INSERT INTO conNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tsa'ma tisema pañasundeccuja ziyapa afa'fambi. Tsonsi Jesúsja paji'choma pporaemba tisema ccushaen. Ccushaemba tisema manda mañamba ");
INSERT INTO conNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","fariseondeccuma su: —¿Majan que'i'su qui tisupa vaura, tisupa boro tsa'ccu posonga amppi ca'ni'ninda junde somboen'fambi? Nane ¿sema'ma'qquia a'ta'qque ti qui somboen'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tsa'caen susi paña'ma jongoesu qquen suye osha'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Añe ttu'sesi ji'chondeccuja bopa poiyi'cco tsu ttatta'fa ti'tsse joccapitssia dyaini dyaipa añe. Tsama attepa Jesúsja va condase'choma tise'panga conda: ");
INSERT INTO conNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—A'i casara'cho fiestanga que'ima ttu'sesi ja'ta ti'tsse joccapitssia dyaipa'chonga dyaijama. Tsa'caen dyai'ninda faesu que'ima ti'tsse joccapitssia jisi ");
INSERT INTO conNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ttuse'suja queni jipa condaya: “Joqquitssija cuintsu va a'i dyaiye.” Tsonsi qui ansangepa utu'ccoa dyaipa'chonga dyaiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tsa'ma ttuseyepa ja'ta utu'ccoa dyaipa'chonga dyaija cuintsu ttuse'su jipa quenga suye: “In'jan'cho, bove ñotssianga dyaija.” Tsonsi tsu fae'ngae mesani dyaisundeccu attepa quene ñotsse afa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Poiyi'cco majan patsuye in'jan'da utu'ccoe tsu da'faya. Tsa'ma poiyi'cco majan patsuye in'jambi'ta ti'tsse joccapitssia've tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tsomba Jesúsja tisema ttuse'suma qquen su: —Queja fiestaemba a'ima o'fiañe in'jan'da que in'jan'chondeccuve'yi ni que antiandeccuve'yi ni pporotsse canjen'su ricondeccuveyi ttu'sejama. Tsendeccuja tise'pa fiestani ccane'qque quema ttu'sepa afepoeñe osha'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tsa'ma fiestaen'jen'da va'chandeccuma ttu'seja. Toya'caen dañonge'chondeccu, ccareshendeccu, binindeccuma'qque ttu'seja. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tsendeccuja ccane'qque quenga afepoeñe oshambisi qui ñoa'me avujatssi'faya. Toya'caen Chigaja ño'andeccuma ccase qquendyaemba que'inga'qque ñotsse afepoeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tsama pañamba fae a'i mesani an dyai'su Jesúsma su: —Majan a'i Chiga aindeccuve dapa tseni'su anqque'suma an'jen'da ñoa'me avujatssiya'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsa'ma Jesúsja tisema su: —A'ija tayoe rande fiestave fiestaemba tsain'bio a'ima ttu'se. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Fiesta pan napijisi tisema shondo'suma manda cuintsu ttuseye'chondeccuma qquen conda'ngaye: “Tayo tsu ñoña osha'choma. Junde ji'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tsa'ma ttuseye'chondeccuja pañamba poiyi'cco ccaningae tsoña'chove condaseye ashaen'fa. Fa'eja tisema su: “Ñajan jiye oshambi. Nasipama chavapa gi can'su jayi. Chigáne ñama anttéja ña jimbecañe.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Faesuja su: “Diez sema'jen'cho vaurama chavapa gi jayi tise'pama semoencañe. Chigáne ñama anttéja ña jimbecañe.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Cca'ija su: “Voeyi pushepa gi jiye oshambi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tsa'caen su'fasi na'suma shondo'suja jipa na'sunga conda. Tsonsi tsa'o na'suja iyicca'yepa tisema shondo'suma su: “Canqqueni japa poi tsaiquima tta'ttapa va'chandeccu, dañonge'chondeccu, binindeccu, ccareshendeccuma'qque ttu'sepa ija.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Shondo'suja tsa'caen tsomba su: “Na'su, que suqquia'caen tso'ma toya on'bambi tsu que tsa'o.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsonsi na'suja shondo'suma manda: “Joccani'su tsaiquinga, nasipanga'qque japa majama cachui'ta ttu'seja cuintsu a'i bosi ña tsa'o on'baye. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ñoa'me tsu o'tie ttuseye'chondeccuja ña aña'choma an'faya'bi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ñoa'me tsain'bio a'i Jesúsi'ccu jacan'fasi tiseja piyicamba tsendeccuma su: ");
INSERT INTO conNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Majan a'i ñani ji'ta cca'ima tsu chi'ga'faya'cho. Nane tisu yaya, tisu mama, tisu pushe, du'shu, quindyandeccu, quinshingendeccu, shesheyendeccu, quetteyendeccu, nane tisuma'qque chi'gambi'ta ñoa'me ñama shondo'suve daye oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Majan ña'caen vanañe tise avuja'ccoma opi angambi'ta ñama shondo'suve daye oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Majan que'i'suja se'fatssia tsa'ove tsao'ñañe in'jan'da o'tie tsu dyaipa bare'choma agattoya'cho naniñe'me'se qquen atesuye. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tsambi'ta dyaiña'choma dyaiñamba ti'tsse tsao'ñamba naniñe oshambian'da poiyi'cco a'i tsu can'boemba ");
INSERT INTO conNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","su'faya: “Tsaja tsa'ove tsao'ñañe ashae'ma naniñe oshambi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Toya'caen majan ande na'su faesu na'sui'ccu geraeñe tson'jen'da o'tie tsu dyaipa asi'ttaeña'cho. Tisema fuitesundeccui'ccu condasecco'faya'cho atesuye tise'paja diez mil sundarondeccui'ccu faesu na'su veinte mil sundarondeccuma patsuve'se. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Asi'ttaemba oshambi qquen in'jan'da faesu na'su toya catsembi'te tsu aindeccuma moeña'cho tisema ñoquiañe cuintsu antte'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tsa'cansi que'i'qque majan tisumbe osha'choma chi'gambi'ta ñama shondo'suve daye osha'fambi qui. ");
INSERT INTO conNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Patu ansinjan ñotssi tsu. Tsa'ma patu ansi'ñe ansin tssutssu catiye'ninda ¿ma'caen tsu ccase ansinpave daya? ");
INSERT INTO conNTpo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñoa'me barembi tsu. Andema tsu daño'jen. Ni vaura ccopa'caen andema fuitembi. Injanga tsu catiya'cho. Majan tsosinapa'ta ñotsse paña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Govierno impuestoma isusundeccu, poiyi'cco egae tsinconsundeccu'qque Jesúsnga catse'fa pañañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tsonsi fariseondeccu, Chiga Tevaen'jema atesu'chondeccu'qque Jesúsma qquen afase'fa: —Va a'ija egae tsinconsundeccuma in'jamba tise'pai'ccu fae'ngae an'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesúsja tsama pañamba va condase'choma conda: ");
INSERT INTO conNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Majan que'i'su cien ovejave an'biamba fae'ccoe qqueña'da noventa y nuevema toeni a'i menia ántteya'cho tsa qque'choveyi tta'ttaye. Nane atteya'ngae tta'ttaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Attepa andu'ta avujatsse shanda. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tsaoni napipa tise amigondeccu, tisei'ccu porotsse can'jendeccuma'qque ttu'sepa tsu su: “Ñai'ccu fae'ngae avujatssi'faja. Tayo gi atte oveja qque'choma.” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ñoa'me gi su tsa'caen tsu Chiga sefacconi. Nane noventa y nueve ño'andeccu egae tsincon'chove mecho'fasi Chiga sefacconisundeccu tise'pai'ccu avujatssipa fae'cco egae tsincon'su tise egae tsincon'choma chi'gapa antte'ninda ti'tsse tsu avujatssi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Toya'caen majan pushesu diez totoa corima ñoña'cho corifin'dive an'biamba fae'ccoe qqueña'da tuñoma setsaemba pa'cco tsa'oma fundu'ndu tta'ttaya atteya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Atte'ta tsu amigondeccuma, pporotsse can'jensundeccuma'qque ttu'sepa qquen suya: “Ñai'ccu avujatssi'faja. Tayo gi atte ña corifin'di qque'choma.” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tsa'cansi gi su, fae egae tsincon'su tise egae tsincon'choma chi'gapa antte'ninda Chiga sefacconi'su shondosundeccuja avujatssi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tsomba Jesúsja su: —A'ija dos dutssi'yeve an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chu'a tsu tise yayama su: “Yaya, junde ñanga afeja que pasi ña jai'ngae isuya'choma.” Yayaja “Ju” qquen supa tsa'caen tise osha'choma dutssiyendeccunga attufaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tise yayai'ccu can'jenccambeyi tsu chu'aja pa'cco tise isu'choi'ccu biani'su andenga ja. Tseni can'jemba in'jangae cansepa tisu an'bian'choma injanga catiti. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pa'cco corifin'dima catiti sefaensi tsa andeni ñoa'me egae qquipoesuite tsu napi. Tsa'cansi tise'qque aña'cho mechoe dapa qquipoe'supa ");
INSERT INTO conNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","japa tsa ande'su a'imbe sema'suve da. Tsa a'ija tisema manda moen cuintsu tise cochima coirapa ofian'jeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Qquipoe'supa ñoa'me cochi anqque'su teta'cho ttonoma añe ñombi'ye. Tsa'ma majan ni fae teta'choveyi'qque tisenga afembi. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tsonsi chu'aja injama'choni tisuma in'jamba su: “Poiyi'cco ña yayambe semasundeccuja ttepupa tsu can'jen'fa. Nane an antteye'choma'qque aqquia cati'je'fa. Tsa'ma ñajan vani ti'tsse can'jen'da qquipoe'supa paya. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ja'ño gi ña yayani jaya. Napi'ta gi tisema suya: ‘Yaya, ñajan egae tsincomba gi Chigama egae tsomba quema'qque egae tson. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Barembi gi que “Ña dutssi'ye” qquen ñama afaye. Ñama mendeye'ta quembe sema'sia'caen ñama an'bianjan.’ ” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tsa'caen asi'ttaemba jangipa tise yayani ja. Tsa'ma toya tise catsembi'te tise yayaja bianima attepa mende'yepa buttoin jipa cachuipa musimba mocha. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsonsi dutssi'yeja su: “Yaya, ñajan egae tsincomba gi Chigama egae tsomba quema'qque egae tson. Barembi gi que ‘Ña dutssi'ye’ qquen ñama afaye...” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tsa'ma yayaja tisema shondosundeccuma su: “Ñotssia ondiccu'jema i'ngapa tisema ondiqquian'faja. Tise tivenga sotijama ejian'faja. Sapatoma'qque tandan'faja tise tsu'ttenga. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yayapatssia vaura du'shuma fi'ttipa sho'ccoen'faja. Jinge avujatsse an'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Va ña dutssi'ye pa'cho'ye qquendyaqquia'caen tsu canse. Tsangae nepi'choma gi atte'fa.” Qquen susi poiyi'cco avujaye ashaen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tsa'caen tson'jen'ni quindyaja nasipani sema'jemba jiñamba tsa'onga catsepa settapoen'jen'choma paña. Boira'je'choma'qque pañamba ");
INSERT INTO conNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","sema'suma ttu'sepa tsane iñajampaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sema'suja tisenga su: “Tayo tsu que quinshinjan ji. Pambe'yi jisi que yayaja avujapa yayapatssia vaura du'shuma fi'ttipa shoccoen'jen avujatsse añe.” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tsa'ma quindyaja iyicca'yepa tsa'onga ca'niñe chi'gapa tsotefani ccutsu. Tsonsi tise yayaja sombopa tisema ca'nian qquen tson. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tsa'ma tiseja tise yayama su: “Tsain'bio canqque'fa gi quema shondopa sema'jen. Que manda'nijan tsa'caeñi gi tson'jen. Tsa'ma ni fae chivo du'shuveyi'qque qui ñanga afembi ña amigondeccui'ccu fiestaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tsa'ma va que dutssi'ye tayo que corifin'dima in'jangae pushesundeccui'ccu injanga catitipa jisi ja'ñojan tisene qui yayapatssia vaura du'shuma fi'ttipa shoccoen'jen.” ");
INSERT INTO conNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tsama pañamba yayaja su: “Ña dutssi'ye, queja tsangae ñai'ccu can'jensi osha'cho ña an'bian'cho tsu quembe'yi. ");
INSERT INTO conNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tsa'ma ja'ñojan ñotssi tsu ingi avujaye. Que quinshinjan tayo paqquia'can tsu ja'ñojan canse. Tsangae nepi'choma gi ccase atte'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Toya'caen Jesúsja tisema shondosundeccuma su: —Ricoja can'jen. Tsambe shondo'suja tise an'bian'choma coira'je. Tsa'ma shondo'su osha'choma ñotsse coirambisi cca'indeccuja na'sunga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsama pañamba na'suja shondo'suma ttu'sepa iñajampaña: “¿Jongoesu tsu va ña quene paña'jen'choja? Pa'cco que chavapa chavaen'choma tevaenjan ña atteye. Tsa'ma queja ti'tsse ña corifin'dima coira'suve can'jeñambi qui.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na'su tsa'caen susi shondo'suja tisuma su: “Ña na'su ñama joqquitssia'ninda ¿jongoesuma gi tsoña? Quin'ambi gi matichi'ccu semañe. Injanga corifin'dima iñajañe'qque gi ansange.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tsa'caen asi'ttaemba in'jamba su: “Unjun, tayo gi in'jan jongoesuma ña tsonsi cca'indeccu ñame in'jamba amigoen'faya'choma. Tsonsi na'su ñama joqquitssia'ninda gi tsendeccumbe tsaoni can'jeña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsa'caen in'jamba fae'cco fae'ccoveyi tise na'suma shacaendeccuma ttu'se. Fa'e jisi tisema iñajampaña: “¿Min'getsse qui shacaen ña na'suma?” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tiseja su: “Yayapa cien rata randeve gi shacaen.” Shondo'suja tisema su: “Que tevaen'jema isupa junde cuname tevaenjan cincuenta rataveyi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tsomba faesu shacaen'suma su: “¿Queja mi'getsse qui shacaen?” Tiseja su: “Cien saparo trigove gi shacaen.” Shondo'suja tisema manda: “Que tevaen'jema isupa junde cuname tevaenjan ochenta saparoveyi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ega shondo'su tsa'caen shacama andiansi tise na'suja pañamba asi'ttaemba iyicca'yembe'yi tisema ñotsse afa. Ñoa'me tsu va ande'su aindeccuja ma'caen tisupanaccu canseya'chove ñotsse in'jan'fa. Tsa'ma Chiga aindeccuja toya tsa'caen tisupanaccu caseya'chove in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ñoa'me gi que'inga su: Corifin'dija ega na'su tsu. Tsa'ma ñotsse in'jamba que'i corifin'di'ccu cca'indeccuma fuite'faja corifin'di sefasi sefacconi osha'choma ñotsse an'biamba tsangae Chigai'ccu canseya. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Majan a'i re'riccoama ñotsse coirapa an'bian'da ti'tsse'tssiama'qque tsu ñotsse coirapa an'biaña. Tsa'ma majan re'riccoama ñotsse coirambi'ta ti'tsse'tssiama'qque ñotsse coirambipa cca'naña. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Que'i va andeni jinchoma ñotsse coirambian'da ¿majan tsu ñoa'me ñotssiama que'inga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Que'i cca'imbema ñotsse coirambian'da ¿majan tsu ñoa'me que'imbetssiama que'inga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni majan sema'suyi'qque dos na'suma shondoye oshambi. Nane fa'ema chi'gapa tsu faesuma in'jaña. Tsambi'ta fa'ema ñotsse in'jamba tsu faesuma chi'gaya. Chigama, que'i corifin'dima'qque fae'ngatsse in'jañe osha'fambi qui. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseondeccuja tsain'bitssi corifin'dive in'jañe atesuchopa Jesús su'choma pañamba tisema feña'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsa'ma Jesúsja tise'pama su: —Que'i afopoensi aindeccuja que'ija ñotssi qquen in'jan'fa. Tsa'ma Chiga Quitsaja que'i injama'choma ñotsse atesu. Nane a'i jongoesuve asi'ttaemba ti'tsse'tssi tsu qquen in'jan'ninda Chigaja tsama chi'ga. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Chiga manda'cho, Chiga Aya'fa afasundeccu tevaen'jen'qque ingima tayoe atesian. Tsa'ma Juan jipa ma'caen Chiga aindeccuve dapa canseya'chone ñotsse condase'choma candusiañe ashaen. Ja'ño tsain'bio a'i pañamba quia'me in'jan'fa Chiga aindeccuve daye. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tsa'ma Chiga manda'choja pasaya'bi. Ni fae tevaen'ttiyi'qque pasaya'bi. Nane bove aiye'pambicco tsu sefacco, ande pasa'faya'cho. Tsa'ma Chiga manda'choja pasaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Poiyi'cco majan tise pushema catipa faesu pushesuma pushe'ta ñoa'me tsu egae tsincomba canse. Toya'caen tsa'caen tise pushema catisi majan tsa pushesuma pushe'ta tsa'qque egae tsincomba canse. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ricoja can'jen. Ñotssia tototssia sarupama ondiccupa na'su cu'a omba'su ondiccu'jema ondiccucho. Poi a'ta tiseja osha'cho ñotssiama an'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tsa'ma tise'pa sombo'tti jin'tti tsu va'cha a'ija pa'cco ai'vo ccopi'pa ccui. Tiseja Lázaro qquen inise'chocho. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tsaja ñombi'ye ricombe mesa'ye amppipa catiye'je'choma añe. Toya'caen ainjan jipa tise cco'pima be'ya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tsa'caen canse va'cha pasi Chiga sefacconi'su shondosundeccu tisema anga'fa cuintsu tayopi'su Abrahami'ccu can'jeñe. Omboe rico'qque pasi a'tu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Papa si'nge anchanda'je'chonga me'detsse vana'jemba bianima camba Abrahamma atte. Tisei'ccu Lázaroma'qque attepa ");
INSERT INTO conNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","quia'me fundo: “¡Yaya Abraham, ñama mende'yeja! Lázaroma mandaja cuintsu tise tsimian'ccoma tsa'ccunga tssipoemba ña menzanza'fama pporaen'giye. Ñoa'me gi vana'jen va si'nge anchanda'je'chonga.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tsa'ma Abrahamjan su: “Dusu'tssi ñotsse in'janjan que canseite osha'cho ñotssiave an'biamba qui ja'ñojan vana'jen. Tsa'ma Lázaroja tise canseite osha'cho egave vana'jemba ja'ño mende'yeyepa vani ñotsse can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Toya'caen ingi enttingeni tsu ampashan'masia changoja jin. Ñajan que'ini jiye in'jan'ma tsama panshañe oshambi. Toya'caen tseni quei'ccu can'jensundeccu'qque vafanga panshañe osha'fambi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tsonsi su: “Yaya Abraham, Chigáne Lázaroma mandamoenjan ña yaya tsaoni ");
INSERT INTO conNTpo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ña cinco quinshingendeccunga. Tsendeccuma tsu condaya'cho vani vana'jen'chonga ji'fasa'ne.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tsa'ma Abrahamjan su: “Tsendeccuja Moisés manda'choma an'bian'fa. Chiga Aya'fama afasundeccu tevaen'jema'qque an'bian'fa. Tsa'suma tsu paña'faya'cho.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tsa'ma tiseja su: “Me'i, Yaya Abraham. Tsa'ma fa'e pa'chondeccu'su tise'panga jasi tsu pañamba tise'pa egae tsincon'choma chi'gapa cati'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tsa'ma Abrahamjan tisema su: “Moisés manda'choma pañambi'ta, Chiga Aya'fama afasundeccu tevaen'jema pañambi'ta ñoa'me pa'cho qquendya'pa ja'ni'qque tisema paña'faya'bi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tsomba Jesúsja tisema shondosundeccuma su: —Tsaveqque'su tsu va andenijan osha'cho tsu jin a'ima qqueñasi cuintsu egae tsincon'faye. Tsa'ma va'cha tsu tsa a'i majan cca'ima egae tsoñe injaen'suja. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Majan va ñame in'jan'cho du'shuma egae tsoñe in'jaen'ninda tisene bove ñotssi tsu toya tsa'caen injaembite sunda'cho patuma tise tsifonga tandamba singu'ccunga andeccoemoeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tisuma ñotsse coira'faja tsa'caen tsonsa'ne. Que faenga'su quema egae tsincon'nijan tisema candusiaña'cho. Tsa'ma tsa a'i tise egae tsincon'choma chi'ga'nijan aqquepoeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tiseja fae a'ta siete se quema egae tsincomba siete se quema ñoquiañe in'jan'ninda tise egae tsincon'choma tsu aqquepoeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tisema shondosundeccuja Na'suma su'fa: —Ingima in'jaenjan queve ti'tsse in'jañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na'su tise'pama su: —Que'ija ñame re'riccoe in'jan'da ñoa'me qui osha'choma osha'faya. Nane mostasa choja ñoa'me'qque chipiri tsu. Que'i in'jan'choja tsa'caen chipiri'ccu qui va rande quini'jin joqquitssiye mandaye osha'faya. “¡Joqquitssipa na'enga amppija!” qquen manda'ninda tsa'caen tsu daya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Majan que'imbe semasundeccuja andema pa'fupa joñe sema'fa. Majan semasundeccuja que'i ovejama coira'je'fa. Tsa'ma sema nanimba tsaoni jisi ¿majan que'i'suja tisema qquen suya: “Junde ca'nimba dyaipa anjan”? ");
INSERT INTO conNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Me'i. Tsa'caen qui su'faya'bi. Ñoa'mejan qquen qui tisema su'faya: “Ña anqque'suma sho'ccoenjan. Osha'chove ñoñamba ñama o'fiamba cui'ñajan. Ña an nanisi qui omboe amba cu'iya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Sema'suja ñotsse pañamba tsa'caen tsonsi ¿na'suta ti sema'suma ñotsse afaya'cho? ");
INSERT INTO conNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Me'i, tsaveqque'su tise'pambe sema'sumajan. Toya'caen que'i'qque osha'cho Chiga manda'choma pañamba tson'da qui qquen su'faya'cho: “Aqquia semasundeccu gi. ¿Ma'caen tsu ingine ñotsse afa'faya? Aqquiatsse ingima mandasi gi tson'jen'fa.” ");
INSERT INTO conNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesúsja Jerusaléni jayipa Galileane sombopa Samariani napipa ");
INSERT INTO conNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","chipiri canqquenga ca'ni. Ca'ni ji'ni diez na congomba pajisundeccu tisema cachui'fa. Biane ccutsupa ");
INSERT INTO conNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","quia'me fundopa afa'fa: —¡Na'su Jesús, ingima mende'yeja! ");
INSERT INTO conNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesúsja tise'pama attepa su: —Japa Chigama afasundeccunga tisuma canjaen'faja. Tise'pa jayi'fa'ni Jesúsja tise'pama ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsonsi fae'cco tsendeccu'su tisu ccusha'choma attepa toequi shanda. Quia'me fundopa Chigane ñotsse afa'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tsomba Jesús tsutteccofanga puntssamba camba'jui'ccu andenga ccuipa Jesúsma ñotsse afa. Tiseja samaria'su a'i. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsonsi Jesúsja su: —¿Diezyi'cco a'i ti ccusha'fa? ¿Mani tsu faesu nueveta? ");
INSERT INTO conNTpo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Aqquia ti va israembi'su toequi jipa Chigama ñotsse afa? ¿Faesuveja me'i'on ti? ");
INSERT INTO conNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsomba Jesúsja tisema su: —Jangipa japa canseja. Queja ñame in'jamba qui ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseondeccuja Jesúsma iñajampaña'fa: “¿Minga'ni tsu a'ija Chiga aindeccuve da'faya?” Tsa'caen iñajampaña'fasi Jesúsja tise'pama su: —A'i Chiga aindeccuve da'faya'choma que'ija atteye osha'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni a'ija qquen su'faya'bi: “Va'tti tsu tsa'caen da,” ni “Tse'tti tsu tsa'caen da.” Ñoa'me tsu Chigaja que'i injama'chonga ca'nisi qui tayo Tise aindeccuve da'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsa'caen supa Jesúsja tisema shondosundeccuma su: —Junde qui que'ija Sefaccone Ji'cho A'i que'i'ccu fae a'tayi'qque can'jeñe in'jan'faya. Tsa'ma ñajan que'i'ccu can'jeña'bisi qui ñombi'ye'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cca'indeccuja que'inga conda'faya: “Joni tsu tiseja can'jen”, Toya'caen “Va'tti tsu Jesúsja can'jen.” Tsa'ma paña'fajama ni ñame ttatta'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ña jiña'nijan poiyi'cco tsu fae'ngatsse ñama atte'faya. Nane tsanda veyaensi poiyi'cco fae'ngatsse atteqquia'caen tsu poiyi'cco ñama atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tsa'ma o'tieta gi ñoa'me vanaña'cho. O'tie tsu poiyi'cco vani'su aindeccuja ñama chi'ga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tayopi'su Noé can'jeinteqquia'caña tsu ña ccase jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé tsa'o shavonga otseya'ngae a'ija an'jemba cui'je'fa. A'ija pushe'fa. Tise'pa onquengendeccuma'qque antte'fa. Tsa'caen canse'fa'ni na'en jipa poiyi'ccoma piccosi tsangae pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Toya'caen tsa'caeñi tsu tayopi'su Lot can'jeinte'qque da'fa. Nane a'ija an'jen'fa, cui'je'fa, chava'je'fa, chavaen'jen'fa, jon'jen'fa, tsaoña'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tsa'ma Lot Sodoma canqque'ye sombosi tsu si'ngeja asufrei'ccu sefaccone amppipa poiyi'ccoma oque cati. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tsa'caeñi tsu ja'ño'su aindeccu'qque Chigave in'jambe'yi injanga canse'faya ña ccase jiya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tsequi a'ta majan a'i tsa'o omba'su ppappacconi dyaipa tise an'bian'choma tsa'onga an'bian'da i'ngambe'yi tsu catipa ccuyaya'cho. Toya'caen majan nasipani sema'jen'da toequi tise tsaoni jimbe'yi ccuyin jaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot pushene condase'choma ñotsse injan'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Majan tisu canse'pama ccushaeñe in'jan'da tsu qqueñaña. Tsa'ma majan tisu canse'pama cati'ta tsu ñoa'me ccushaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nane tsequi cose fae ana'jen'choni dos a'i ana'jen'choma fae'ccoe angapa faesuma catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Toya'caen dos pushesu fae'ngae sunda'je'fa'choma fae'ccoe angapa faesuma catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dos a'i nasipani sema'jen'choma'qque fae'ccoe angapa faesuma catiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsonsi tisema shondosundeccuja Jesúsma su'fa: —Na'su, ¿mani tsu tsa'caenjan daya? Jesúsja tise'panga su: —Congomba ccuini tsu ccompanajan bo'je'fa. Ña su'cho napisi qui in'jan'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Zutsse Chigama iñajaña'chove tisema shondosundeccunga atesiañe in'jamba condase'choi'ccu Jesúsja condase. Nane a'ija anttembe'yi tsu Chigama iñajaña'cho tise'pa iñajan'choma isuya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Qquen tsu Jesúsja condase: —Fae canqqueni ñoquian'suja can'jen. Chigave in'jambipa dyojombipa ni fae a'i faesuma bove ñotssi qquen in'jambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Toya'caen tsandupajen'choqque tsa canqqueni can'jen. Faesu a'i tisema egae tsonsi tsa ñoquian'suma iñajan cuintsu tsambe injama'choma somboeñe. Zutsse jipa iña'jansi ");
INSERT INTO conNTpo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ñoquian'suja fuiteye in'jambi'ma asi'ttaen: “Ñajan Chigave in'jambipa dyojombi ni fae a'i faesuma ti'tsse'o qquen in'jambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tsa'ma va tsandupajen'cho panshaen ñama noñangia'ninda gi tisema fuiteya. Tisema egae tsincon'sumbe injama'choma gi somboeña. Tsa'caen tsombian'da panshaen jipa ñama noñangian'jensi gi quimbiya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Qquen supa Na'su Jesúsja su: —Va ñoquian'suja ega a'i tsu. Tsa'ma paña'fa qui tise su'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nane tiseja ega'ma tsandupajen'choma pañamba fuite'ninda tsu Chiga'qque tisema iñajansundeccuma pañamba ccushaeña. A'ta toya'caen cose'qque Chigave in'jamba iñajan'ninda ¿Chigata ti tise'pama se'piya? ");
INSERT INTO conNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Me'i, se'pimbipa junde tsu tise'pama ccushaeña. Tsa'ma ñajan Sefaccone Ji'cho A'i ccase ji'ta ¿jongoesuma gi va andeni atteya? ¿Ñame in'jamba tsa'caen iñajamba ronda'je'chondeccuma ti gi atteya? ");
INSERT INTO conNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Majan a'i tisuja ño'a qquen in'jamba tisupaporama chi'ga'fa. Jesúsja va condase'pama tsendeccunga condase: ");
INSERT INTO conNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Dos a'i Chiga ettini ja'fa Chigama iñajañe. Fa'eja fariseo in'jan'cho a'i, osha'cho Chiga manda'choma paña'su. Faesuja govierno impuestoma isu'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseoja ccutsupa tisuma afaqquia'caen qquen iñajan: “Chiga, ñajan faesu a'ia'cambipa gi Quema ñotsse afa'je. Cca'indeccuja a'ima dyoña'fa corifin'dima itsaye. Afopoemba a'ima daño'jen'fa. Faesu pushesui'ccu ana'jen'fa. Ñajan tsa'caen tsincombi ni va impuestoma isu'sia'caen tsincombi. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ñajan fae avujaquive dos a'ta ambe can'jen. Toya'caen jongoesuma isu'ta gi enttingeve Chiganga afe'je.” ");
INSERT INTO conNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tsa'ma impuestoma isu'suja ccani catsembe'yi ccutsu. Tsa'caen ccutsupa puntssamba sefanima cambe'yi tivei'ccu tise utu'choma tssaipa su: “¡Chiga Quitsa, ña gi egae tsincon'su! Ñama mende'yeja.” ");
INSERT INTO conNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ñoa'me gi su, impuestoma isu'suja avujatsse tise tsaoni ja tayo Chiga tise egae tsincon'choma joqquitssiansi. Tsa'ma Fariseoja me'i. Injanga afapa ja. Nane poiyi'cco majan patsuye in'jan'da bove'ccoe tsu da'faya. Tsa'ma poiyi'cco majan patsuye in'jambi'ta ti'tsse joccapitssia've tsu da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Toya'caen chambanaccu tise'pa dushundeccuma Jesúsnga i'fa cuintsu tise'pama pporaeñe. Isi Jesúsma shondosundeccuja attepa chambanaccuma iyu'u'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsa'ma Jesúsja tise'pama ttu'sepa su: —Antte'faja cuintsu dushundeccu ñani ji'faye. Se'pi'fajama. Nane Chiga aindeccuta tsu va dushundeqquia'can'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñoa'me gi su: Va dushundeccuja ñame in'jan'fa. Majan tise'pa'caen ñame in'jan'da Chiga aindeccuve dapa Chigama paña'faya. Tsa'ma majan ñame in'jambi'ta ca'ni'faya'bi Chigai'ccu tsangae canseye. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ande nasundeccu'su Jesúsma iñajampaña: —Ñotssia atesian'su, ¿jongoesuma gi tsoña tsangae canseye'ta? ");
INSERT INTO conNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsja tisema su: —¿Jongoesie qui ñama su “Ñotssia”? Chiga Quitsayi tsu ñotssia. A'ija poiyi'cco ñotssimbi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tsa'ma tsangae canseye tsoña'chone iñajampaña'da, ¿queta ti qui atesu Chiga manda'choma? Nane qquen tsu su: Faesumbe pushei'ccu anajama. Cca'ima fi'ttijama. Cca'najama. Afopoenjama. Que yaya, que mamama'qque ñotsse pañajan. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tiseja pañamba su: —Chuitepie gi tsa'caen in'jamba pañamba canse. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesúsja su: —Toya fae'ccoe qui shaca. Que osha'cho an'bian'choma chavaemba pa'cco corifin'dima va'chandeccunga attufaenjan. Tsa'caen afe'ta qui sefacconi ricove daya. Tsomba ñai'ccu fae'ngae jija. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tsa'ma tsama pañamba ande na'suja ñombi'ye osha'choma an'biamba. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesúsja tisema camba su: —Aiye'pa tsu osha'choma an'bian'su Chiga a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bove aiye'pambi tsu camello nojan'cco changoma panshañe. Nane osha'choma ambian'suta tsu ti'tsse vana'jen Chiga a'ive daye. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tsonsi pañasundeccuja su'fa: —Tsa'camanda ¿majan tsu ccushaya? ");
INSERT INTO conNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tsa'ma Jesúsja su: —A'i oshambi'ni'qque tsu Chigaja oshaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsonsi Pedroja su: —Que canjan. Ingija tsa'o, antiama'qque catipa gi quei'ccu fae'ngae jacan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús tise'pama su: —Ñoa'me gi su, majan a'i tise tsa'o, tise pushe, antian, mama, yaya, du'shuma'qque catipa Chiga in'jan'chove in'jan'da ");
INSERT INTO conNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ñoa'me tsu toya vani can'jemba ti'tsse an'biaña. Toya'caen jai'ngae Chiga sefacconi'qque tsu tsangae canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsomba Jesúsja tisema doce shondosundeccuma ttu'sepa su: —Paña'faja. Ingija Jerusaléni jayi'fa. Chiga Aya'fama afasundeccuja Sefaccone Ji'cho A'i vanaña'chone tayopi conda'fa. Ja'ño ingi Jerusaléni jasi tsu pa'cco tsa vanaña'chone su'choja ñanga napiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nane Chiga Tevaen'jen condaqquia'caen israendeccuja israembindeqquianga ñama afe'faya. Tsa'caen afesi ñama afasepa egave noñangiamba chi'gapa ñanga attupoen'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ñama ma'ppipa avuja'cconga fi'tti'faya. Tsa'ma papa tres a'tangae gi ccase qquendyaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tsa'caen Jesús su'choma paña'ma shondosundeccuja atesu'fambi. Nane injama'cho shacapa ñotsse paña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tsomba Jericó canqqueni pan napiji'fa'ni binijan tsaiqui utufani dyaipa corifin'dive iñajan'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsain'bio a'i panshanjin'fasi pañamba faesuma iñajampaña: —¿Jongoesie tsu a'ija panshanjin'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Qquen iñajampañasi tisenga su: —Jesús Nasareno panshanjinsi tsu tsain'bio a'i tisei'ccu jayi'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tsa'caen pañamba tiseja quia'me fundondo'e afa: —¡Jesús, David Dutssi'ye, ñama mende'yeja! ");
INSERT INTO conNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Qquen fundosi o'tie jayisundeccuja tisema se'pipa su'fa: —¡Ziyaja! Tsa'ma ti'tsse quia'me fundo: —David Dutssi'ye, ñama mende'yeja. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tsonsi Jesúsja tse'ttinga napipa ccutsupa manda binima i'faye. Bini catsesi Jesúsja iñajampaña: ");
INSERT INTO conNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Jongoesuve ña quenga tsoñe qui in'jan? Binijan su: —Na'su, atteye gi in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tsonsi Jesúsja tisema su: —¡Tayo qui atteye osha! Queja ñame in'jamba qui ccusha. ");
INSERT INTO conNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tse'faei'ccuyi atteye oshapa tise'qque Jesúsi'ccu fae'ngae ja. Ñoa'me Chigama ñotsse afa. Nane poiyi'cco a'i ccushaen'choma attepa Chigama ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesúsja Jericó canqquema ca'nimba panshanjin. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tse'tti tsu govierno impuestoma isusundeccumbe na'suja can'jen. Tise iniseja Zaqueo. Tiseja osha'choma an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesúsma atteye in'jan'ma panshaen re'richoccopa oshambi tsain'bio a'i bo'fasi. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsa'caen oshambipa tise jayani buttopa japa quini'jinga ansundepa dyai tsene Jesús panshanjin'choma ñotsse atteye. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesúsja tse'ttinga napipa asuccocamba tisema attepa su: —Zaqueo, junde andeja. Ñanda gi ja'ño a'ta que tsaoni japa can'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tse'faei'ccuyi Zaqueoja andepa avujatsse Jesúsma ca'nian tise tsa'onga. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Poiyi'cco a'i can'boemba afaccoye ashaen'fa: “Jesúsja egae tsincon'sumbe tsa'onga ca'nimba can'jen” qquen su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tsa'ma Zaqueoja jangi ccutsupa Na'su Jesúsma su: —Na'su, que canjan. Ña an'bian'choma enttingeve gi va'chandeccunga afeya. Ñajan majama afopoemba cca'na'da gi cuatro se ti'tsse'e'qque toequi afeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tsonsi Jesúsja su: —Zaqueo'qque Abraham dutssi'yepa tisia'caen ñame in'jan. Tsa'cansi ja'ño a'ta tsu va tsa'o'su aindeccuja ccusha'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nane Sefaccone Ji'cho A'i'ta gi a'i qque'chondeccuma ccushaeñe ji. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Jerusaléni pan napijisi a'i tisema pañamba junde Chigaja Jesúsma na'suve tsoña qquen in'jan'fa. Tsa'caen in'jan'fasi Jesúsja va condase'choma condase. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Qquen tsu su: —Ti'tsse'tssia ande na'su ttu'sesi joccapitssia a'i, tise ande'su na'suve dapa jiye, faesu andeni ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tsa'ma toya jambite diez tisema shondosundeccuma ttu'sepa poiyi'cconga mil corifin'dive afe cuintsu tise ccase jiya'ngae chavapa chavaemba ti'tsse gana'jen'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tsa'ma majan tise aindeccuja tisema chi'gapa cca'indeccuma omboe moen'fa ti'tsse'tssia ande na'sunga qquen condaye: “Va a'ima na'suve tsoñe in'jan'fambi gi.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tsa'ma tsa a'ija tisu ande'su na'suve dapa toequi shandapa jipa tise corifin'dima afe'cho a'ima ttu'seye manda. Ttu'sepa mi'getsse gana'chove poiyi'ccoma iñajampaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Fae'ccoja na'sunga jipa su: “Na'su, que mil corifin'di'ccu gi diez mil corifin'dive gana.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Qquen susi na'suja su: “Ñotsse qui tson. Queja ñotssia shondo'su qui. Re'riccoi'ccu ñotsse tsonsi gi quema ccutsiaña na'suve diez canqquema mandaye.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Faesuja jipa su: “Na'su, que mil corifin'di'ccu gi cinco mil corifin'dive gana.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na'suja tisenga su: “Quema gi na'suve ccutsiaña cinco canqquema mandaye.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tsonsi faesuja jipa su: “Na'su, va'tti tsu que mil corifin'di. Pañeronga onccamba gi coira. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Queja dyo'tssia a'i. Afembi'ma qui itsa'je. Jombi'ma qui tai'je. Tsa'cansi gi ñajan quema dyojo.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na'suja tisema su: “Que su'choyi tsu que injama'choma somboeña. Ñoa'me qui queja ega shondo'su. Ñajan dyo'tssia na'su, afembi'ma itsa'su, jombi'ma tai'su, qquen qui in'jan. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsa'caen in'jan'da ¿mingapa qui ña corifin'dima banco na'sunga afembi cuintsu ña jipa ñambema isuye corifin'di gana'choi'ccu?” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tsomba na'suja pporotsse ccutsusundeccuma su: “Tsambe mil corifin'dima itsapa diez mil corifin'dive an'bian'chonga afe'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tsendeccuja su'fa: “Tsa'ma, na'su, tayo tsu tiseja diez mil corifin'dive an'bian.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na'suja su: “Ñoa'me gi su, majan an'bian'nijan ti'tsse tsu tisenga afeya'cho. Tsa'ma majan an'biambian'da tise re'riccoama'qque tsu itsaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Toya'caen ñama chi'gasundeccuma i'faja. Tise'paja na'suve ñama in'jan'fambi. Tsa'ma tise'pama ipa ña caña'jen'ni fi'tti'faja.” ");
INSERT INTO conNTpo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tsa'caen condase nanimba ccase Jerusaléni jaye ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagéni, Betaniani pan napijipa Olivo ccotta'cconi pporotsse can'jemba tisema shondosundeccu'suma dosve manda moen ");
INSERT INTO conNTpo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","qquen supa: —Va canqquenga japa ca'nimba qui boro du'shuma atte'faya. Tsangaja majañi'qque toya dyaipa jacambi. Ccupapa vani i'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Majan a'i: “¿Jongoesie qui boro du'shuma ccupa'je?” qquen iñajampaña'ninda: “Na'su tisenga dyaipa jaye” qquen tsu suya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Manda moensi japa Jesús suqquia'caen atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Attepa ccupa'je'fasi boro du'shumbe nasundeccu tise'pama su'fa: —¿Jongoesie qui boro du'shuma ccupa'je'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsonsi su'fa: —Na'su tisenga dyaipa jaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesúsnga ipa tise'pa ondiccu'jema boro du'shu sepacconga oppoensi Jesúsja otsepa dyai. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tsanga Jesús dyaipa jayisi a'ija tise'pa ondiccu'je'cho sarupama tsaiquinga ppappa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivo ccotta'ccoma andepa Jerusaléni catsesi tsain'bio tisema shondosundeccu bopa avujatsse afaye ashaen'fa. Jesús ñotsse tsonsi attepa quia'me fundopa Chigama ñotsse afa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Qquen tsu su'fa: —Chigaja na'suma inginga afe. Ñoa'me ñotssia tsu. Sefacconi opatsse canse'faja. Pa'cco Chiga sefacconi Chigane ñotsse afa'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsonsi majan fariseondeccu a'i bo'fa'choi'ccu can'jemba Jesúsma su'fa: —Atesian'su, quema shondosundeccuma iyu'uja. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tsa'ma Jesúsja su: —Ñoa'me gi su, tsendeccu ziya'ninda va tsaiqui'su patu'qque fundopa Chigama ñotsse afa'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Canqquenga pan napijipa attepa Jesúsja i'namba ");
INSERT INTO conNTpo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","su: —Ñajan in'jan cuintsu que'i Jerusalensundeccu opatsse canse'faye. Tsa'ma ja'ñonda qui tsa'caen canseye in'jan'ma toya osha'fambi. Nane tso'fema tsapiqquia'caen qui tta'tta'fambi ma'caen opatsse canseya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tayo tsu napiji que'ima iyiccayesundeccu jipa que'i sombosa'ne shoquendi ttu'faya'cho. Toya'caen andema'qque ovivi'faya que'i ttuccuma panshamba ca'niñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ca'nimba que'ima fitti'tti'faya. Que'i dushundeccuma'qque ttova amppian fi'tti'faya. Nane canqque ttu'choma asittapa ni fae patuveyi'qque faesumbe patu ombanga ántte'faya'bi. Nane que'ija Chiga que'ini jipa ccushaen'choma in'jambisi tsu tsa'caen tson'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tsomba Jesús Chiga ettini ca'nimba chavaensundeccuma tteyamoeñe ashaen. Chavasundeccuma'qque joqquitssian. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tise'pama su: —Tise Tevaen'jenga Chigaja su; “Ña tsa'oja ñama iñajan'jen'tti tsu.” Tsa'ma que'ija va Chiga ettima ccanamba tsa'ove cambian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesúsja poi a'ta Chiga ettini can'jemba atesian'jen. Chigama afa'su nasundeccu, Chiga Tevaen'jema atesu'chondeccu, joccapitssia israendeccu'qque ttatta'fa ma'caen Jesúsma fi'ttiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tsa'ma ma'caen tsoña'chove atesu'fambi. Nane poiyi'cco a'i Jesúsma in'jamba tise pa'cco afa'choma paña'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Fae a'ta Jesúsja Chiga ettini can'jemba a'ima atesian'jen. Chiga ccushaeña'chone ñotsse condase'choma candusian'jensi Chigama afa'su nasundeccu, Chiga Tevaen'jema atesu'chondeccu, israe'su coenzandeccu'qque jipa tisema ");
INSERT INTO conNTpo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","su'fa: —Inginga condaja majan na'su tsa'caen in'jaensi qui queja tsa'caen atesian'jen. ¿Majan tsu quema manda antte na'sia'caen afaye? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesúsja pañamba tise'pama su: —Ña'qque gi que'ima iñajampañaña. Ñanga condaja: ");
INSERT INTO conNTpo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juan feti'chota ti sefacconi'su Chiga mandasi feti'cho? ¿Tsambi'ta ti a'i mandasi feti'cho? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tsa'caen susi aindeccuja tisupaporai'ccu qquen condase'cco'fa: —Ingi “Sefacconi'su Chiga mandasi feti'cho tsu” qquen su'ninda tsu tiseja suya: “Tsa'camanda ¿micomba qui Juanma pañamba in'jan'fambi?” ");
INSERT INTO conNTpo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tsa'ma “A'i mandasi feti'cho” qquen su'ninda tsu ñoa'me poiyi'cco a'i iyicca'yepa ingima patui'ccu tovaccoen'faya. Poiyi'cco a'i tsu Juanjan Chiga Aya'fama afa'su qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsa'caen asi'ttaemba Jesúsma qquen su'fa: —Majan Juanma fetiye manda'chove atesu'fambi gi. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsonsi Jesúsja tise'pama su: —Jen'da ña'qque que'inga condaya'bi gi majan na'su mandasi ña qquen atesian'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsomba Jesús va condase'choma a'inga condase: —A'ija o'fa tsa'jaccuve jomba faesu coirasundeccunga afepa faesu andeni japa bo'tsse can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taiya'cho napijisi tisema shondo'suma coirasundeccunga manda moen cuintsu tise'pa tai'fa'cho'suma enttingeve isupa iye. Tsa'ma coirasundeccuja shondo'suma ma'ppipa me'ccoeyi moen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsonsi na'suja faesu shondo'suma moen. Tsama'qque ma'ppipa afasepa me'ccoeyi moen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsonsi ccase tres se faesu shondo'suma'qque moen. Tsendeccuma'qque iñaccaemba joqquitssian'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tsonsi o'fa tsajaccumbe na'suja su: “¿Ma'caen gi tsoña? Ña in'jan'cho dutssi'yema gi moeña. Tisemanda tsu paña'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tsa'ma coirasundeccuja na'sumbe dutssi'yema attepa tisupaporai'ccu qquen condasecco'fa: “Vaja jai'ngae osha'choma isupa na'suve daya'cho. Jinge tisema fi'ttipa o'fa tsajaccuma tisumbe isu'faye.” ");
INSERT INTO conNTpo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsa'caen supa tisema joqquitssiamba fi'tti'fa. Tsa'caen tson'fa'ninda ¿ma'caen tsu na'suja ega coirasundeccuma tsoña? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nane tiseja jipa tsu coirasundeccuma fi'ttiya. Tsendeccuma fi'ttipa o'fa tsajaccuma cca'indeccunga afeya. Chigama afasundeccuja vama pañamba su'fa: —Chigaja tsa'caen ántteya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tsa'ma Jesús tise'pama camba qquen su: —Tsa'cambian'da jongoesie tsu Chiga Tevaen'jenjan qquenda su: Tsaoñasundeccu joqquitssian'fa'cho patu tsu Ñoa'me ti'tsse injienge'cho patuve da. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Majan tsa patunga zuccopanshan amppi'ta tsu tisu uccaya. Tsa'ma tsa patu majan a'inga amppi'ninda tsaja vuviangeya. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chiga Tevaen'jema atesu'chondeccu, Chigama afa'su nasundeccu'qque tse'faei'ccuyi Jesúsma indiye in'jan'ma antte'fa aindeccuma dyojopa. Nane nasundeccuja pañamba in'jan'fa tise'pane Jesús va condase'pama tsa'caen condase. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsa'caen indiye oshambipa a'tutsse tisema can'boen'fa. Toya'caen cca'indeccuma moen'fa Jesúsma shondosundeqquia'caen attian'faye. Tsendeccuja Jesúsma can'boemba tise jongoesu qquen su'choma ttatta'fa tisema afopoemba indipa governaroronga afeye. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jipa Jesúsma iñajampaña'fa: —Atesian'su, queja tansintsse condapa qui tansintsse atesian'jen. Queja poiyi'cco a'i fae'ngatssi qquen in'jamba qui dyombi'tsse Chigane atesian'choma atesian'jen. Tsa'caen in'jamba gi quema iñajampañañe in'jan: ");
INSERT INTO conNTpo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Chiga manda'chota ti antte cuintsu ingija na'su Césarnga impuestoma afeye? ¿Tsambi'ta se'pi ti? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tsa'caen Jesúsma qqueñañe iñajampaña'fasi Jesúsja tise'pa in'jan'choma in'jamba qquen tise'pama su: ");
INSERT INTO conNTpo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Corifin'dima ñanga canjaenjan. ¿Majambe tsove, majambe tevaen'cho tsu vaja? Tise'paja su'fa: —Na'su Césarmbe. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesúsja tise'pama su: —Tsa'caen Césarmbemajan Césarnga afe'faja. Toya'caen Chigambemajan Chiganga afe'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tsa'caen Jesúsma iñajampaña'jen'fa'choma poiyi'cco a'i tsu paña'jen'fa. Tsa'ma nasundeccuja Jesús afa'chone tisema qqueñañe oshambipa “Ñotsse tsu afa” qquen in'jamba ziya'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsonsi majan Saduseondeccu Jesúsni ji'fa. Saduseondeccuja su'fa a'i pa'chota ccase qquendyaya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jipa qquen Jesúsma iñajampaña'fa: —Atesian'su, tayopi'su Moisésta tsu ingima mandapa tevaen cuintsu a'i du'shu mechoyi pasi tise pushe toya canse'ninda pa'chombe quinshiñi tsu tsa pushesuma pusheya'cho. Du'shuma tsu isuya'cho tise quindya'yembe inisema aqque'pasa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nane siete a'i antiandeccuja can'jen'fa. Quindyaja o'tie pushepa du'shuve mechoyi pa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pasi tise quinshin pa'chombe pushema pushepa tsa'caen du'shuve mechoyi pa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tsa'caeñi faesu quinshinjan tisema pushepa pasi ñoa'me poiyi'cco siete antian tsa pushesuma pushepa du'shuve mechoyi tsu pa'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Omboe pushesu'qque pa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tsa'caen tsonsi a'i ñoa'me ccase qquendya'ninda ¿majambe pushe tsu va pushesuja? Ñoa'me poiyi'cco siete antiandeccu tsu tisema pushe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús tise'pama su: —Va andeni tsandiendeccuja pushepa canse'fa. Pushesundeccuja tsa'ndupa canse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tsa'ma Chigaja majan a'ima in'jamba Tisei'ccu can'jeñe ánttesi pa'cho'ye ccase qquendyapa tseni Chiga Sefacconijan pushe'faya'bi ni tsa'ndu'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tsangae pa'masiave dapa Chigama sefacconi'su shondosundeqquia'caen canse'faya. Nane tsendeccuja ccase qquendyapa tsu Chiga dushundeccuve da'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tsa'ma pa'chondeccu ccase qquendyaya'chone Moisés'qque tayopi tevaen. Chigaja quini'si anchanda'je'cho'ye Moisésnga attiansi tevaen'choja qquen tsu su: “Na'su Chigaja Abraham Chiga tsu. Isaac Chiga tsu. Jacob Chiga tsu.” Nane tsa'caen Chigaja tise'pa Chiga qquen supa tsendeccu'qque toya canse'fa qquen tsu su. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nane Na'su Chigaja pa'chombe Chigambi tsu. Tsa'ma cansendeqquiambe Chiga tsu. Nane Chiganejan toya cansendeccu tayo pa'chondeccu'qque toya ñoa'me canse'fa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsonsi majan Chiga Tevaen'jema atesu'chondeccuja su'fa: —Atesian'su, ñotsse qui su. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsa'ma dyojopa tisema ti'tsse iñajampaña'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Toya'caen Jesúsja tise'pama qquen iñajampaña: —¿Ma'caen tsu atesiansundeccuja su'fa Cristoja David Dutssi'ye tsu? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nane Davidja tise settapoen'cho tevaen'jenga qquen tsu su: Na'su Chigaja ña Na'sunga su: Ñai'ccu fae'ngae na'suve dapa va'ttinga dyaija ña tansinfanga ");
INSERT INTO conNTpo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ña quema iyiccayesundeccuma patsusi que tsu'tte tsosiccunga ccuiqquia'caen oshambipa quema paña'faya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David tsa'caen “Ña Na'su” qquen su'ninda ¿ma'caen tsu Cristoja David dutssi'yeya? ");
INSERT INTO conNTpo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tsomba poiyi'cco a'i paña'jen'fa'ni Jesúsja tisema shondosundeccunga su: ");
INSERT INTO conNTpo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Injama'tse, que'i'qque manda'choma atesu'chondeqquia'caen tsonsa'ne. Tsendeccuja bia'a ondiccu'jema ondiccu'fa. Canqque atandundunga a'i chavaeñe bo'fa'ni'qque tsendeccuja bia'ave tisupapora chigambianccoye in'jan'fa. Chigane atesian'jen'ttinga ja'ta ti'tsse joccapitssia dyaipa'chove tsu in'jan'fa. Bopa an'jen'fa'ni ja'ta tsa'caen joccapitssianga dyaiye in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tise'pa coiraye qquen afopoemba tsandupajen'chondeccu an'bian'choma cca'namba itsa'fa. Tsa'caen cca'namba bia'ave Chigama iñajan'fa ño'a qquen attiañe. Tsendeccuma tsu Chigaja ti'tsse tise'pa injama'choma somboeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesúsja ricondeccu tise'pa afe'cho corifin'dima Chiga etti'su corifin'dima ppiña'jen'chonga ppiñasi atte. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Toya caña'jen'ni tsandupajen'cho'qque jipa dos reama ppiña. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tsama attepa Jesúsja su: —Ñoa'me gi su, va tsandupajen'choja poiyi'cco ricondeccuma ti'tsse tsu ppiña. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsendeccuja osha'choma tayo chavapa an'biamba tise'pa antteye'cho corifin'dima afe'fa. Tsa'ma tsandupajen'choja mechopa pa'cco tise chavapa canseye an'bian'cho corifin'dima afe. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Majan a'ija Chiga ettine Jesúsi'ccu condasecco'fa. Nane ñotssia patuma tsao'ñamba osha'cho ñotssia afe'choi'ccu Chiga ettima ñoña'chone condaseccopa Jesúsja su: ");
INSERT INTO conNTpo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Que'ija osha'cho va ñotssiama atte'fa. Tsa'ma jai'ngae ni fae patu faesu patumbe ombani ottaya'bi. Pa'cco tsu osui catiyeya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsonsi tisema iñajampaña'fa: —Atesian'su, ¿minga'ni tsu tsa'caen daya? ¿Jongoesu canjaen'choma attepa gi tsa'caen daya'chove atesu'faya? ");
INSERT INTO conNTpo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tsonsi Jesúsja tise'pama su: —Injama'tse majandeccu que'ima afopoemba qqueñasa'ne. Chigaja ñama moen a'ima ccushaen'suve. Tsa'ma tsain'bio a'i tsu jipa “Ña gi Chiga in'jan'cho Cristo” qquen afopoen'faya. “Ja'ño tsu Chigaja a'ima ccushaeña” qquen tsu su'faya. Tsa'ma tise'pama paña'fajama. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Toya'caen osha'cho gera, iyicco'je'choma paña'an'qque dyombe can'faja. Tsaveqque'su tsu. O'tie tsu tsa'caen tsoña'cho. Tsa'ma tse'faei'ccuyija osefaeña'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tsomba Jesús ti'tsse conda: —Fae ande'su tsu faesu ande'sui'ccu iyicco'faya. Fae na'su tsu faesu na'sui'ccu iyicco'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ande'qque oyaya. Cca'tti, cca'tti aindeccuja qquipoe'su'faya. Osha'cho paqque'suma'qque setsa'faya. Osha'cho dyoqque'sui'ccu tise'pama dyoñansi a'ija sefacconi'su canjaen'choma'qque atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tsa'ma osha'cho tsa'caen toya napimbi'te cca'indeccuja que'ima indipa noñangian'faya. Que'ima Chigane atesian'jen'ttinga anga'faya que'i injama'choma somboeñe. Picco'je'ttinga'qque que'ima picco'faya. Que'ija ña aindeccusi ande nasundeccu, goviernondeccu'qque que'ima iyu'u'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tsa'caen que'ima iyu'uye angasi qui tansintsse ñane conda'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tsa'ma toya tsa'caen tsombi'te asi'ttaen'fajama jongoe qquen supa ccushaya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nane ña gi que'ima in'jaemba afaeña que'i tansintsse afasi cuintsu que'ima noñangiansundeccu ziyaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tsa'ma que'i antiandeccu, nane que'i yaya, mama, quindya, que'i amigondeccu'qque que'ima a'tiemba noñangiansundeccunga afe'faya. Majan que'i'suma'qque fi'tti'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Que'ija ña aindeccusi tsu poiyi'cco que'ima chi'ga'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tsa'ma que'imajan qqueñañe osha'faya'bi. Ni fae tsove'su toseveyi'qque qqueña'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Que'i ñame ta'etsse in'jamba qui ccushapa tsangae canse'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tsa'ma tsain'bio sundarondeccu Jerusalén canqquema shoquendi'je'fasi attepa qui in'jan'faya Jerusalén canqquema osefaeña'cho tsu tayo napi. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Majan Judea andeni can'jen'da ccotta'cconga tsu ccuya'faya'cho. Majan canqqueni can'jen'da tsu sombo'faya'cho. Majan tayo joccani can'jen'da Jerusaléni ca'nimbe'yi tsu jaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nane tsequi a'ta tsu Chigaja israendeccumbe injama'choma somboeña. Osha'cho Tise Aya'fa su'cho tsu napiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Va'cha pushesundeccuja majan suri'je'cho. Majan du'shuma chochoen'jendeccu tsequi a'ta tsu vana'faya. Nane poi andeni'su aindeccu vana'jen'fasi Chigaja israendeccuma iyicca'yepa tise'pa injama'choma somboeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sundarondeccuja matichi'ccu tise'pama fi'tti'faya. Majamanda tsu indipa poi biani'su andeni maña ja'faya cuintsu tseni canse'faye. Toya'caen israembindeqquia tsu Jerusalénma patsupa an'bian'faya tise'pa manda'cho tsangae naningeya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Coejechigai'ccu canjaeña'choma qui atte'faya. Cose'suchigai'ccu, o'fei'ccu'qque tsa'caen canjaensi qui atte'faya. Toya'caen andenga mar'su shave'pa jangipa zonzoemba quia'me jensi poiyi'cco a'i dyopa zucco'faya. Nane govierno nasundeccu'qque ma'caen tsoña'chove atesumbipa dyo'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A'ija jai'ngae tsoña'choma asi'ttaemba tsu dyopa paqquia'caen da'faya. Nane sefacconi'su o'fe'qque ccaningae ja'fasi tsu aindeccuja tsa'caen da'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tsonsi tse'i tsu atte'faya Sefaccone Ji'cho A'i osha'choma oshapa mandaye jiña'choma. Nane osha'cho ñotssiai'ccu unjimba'ye jiña'choma tsu atte'faya. Ña ji'ninda poiyi'cco tsu ñama atte'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Osha'cho tsa'caen daye ashaensi asuccopa can'faja. Ñoa'me tsu que'i ccushaya'choja pan napiji. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tsomba Jesús va condase'choma condase: —Higuera tetachojima can'faja. Nane poi tetachojima can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ccaqueje sho'yosi atte'ta qui qquen in'jan'fa: “Coejefa tsu jiye tson'jen.” ");
INSERT INTO conNTpo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tsa'caeñi qui que'ija osha'cho ña su'choma atte'ta qquen in'jan'faya: “Chiga tsu jiye tson'jen. Ja'ño gi Tise aindeccuve da'faya.” ");
INSERT INTO conNTpo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ñoa'me gi su va ja'ño can'jensundeccu pambi'te tsu osha'cho tsa'caen napiya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chiga sefacconi tsu pasaya. Va ande'qque pasaya. Tsa'ma ña aya'faja tsangae tsu jinchoya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Majan a'ija ñoquimbipa injanga canse'fa. Majan a'ija ccusi'fa. Majan a'ija tise'pa an'bian'choma panshaen in'jan'fa. Tsa'ma injama'tse. Tsa'caen ñoquimbi'fajama. Ña su'choma'qque aqque'pa'fajama pan ña jisi atte jangipa dyosa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ña ji'ninda tsu chhiriria quendecco'chonga indiyeqquia'caen a'ija atte jangi'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tsa'ma que'ija camba ronda'jepa ñama iñajan'jen'faja. Tsayita qui osha'cho va vanaña'cho su'choma vanambe'yi ccushapa Sefaccone Ji'cho A'inga ccutsu'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Poi a'ta Jesúsja Chiga ettini can'jemba atesian'jen. Tsa'ma cose'ninda Olivo ccotta'cconga japa ana'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Poi a'ta sinte'yi poiyi'cco a'i Chiga ettinga bo'fa tisema pañañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Israendeccu pan cupana'cco mechoa fiesta pan napiji. Tsaja Chiga panshaen'cho injienge'cho a'ta'su fiesta. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chigama afa'su nasundeccu, Chiga Tevaen'jema atesu'chondeccu'qque Jesúsma fi'ttive in'jamba tta'tta'fa ma'caen a'tutsse fi'ttiya'chove. A'i bo'fa'choma dyopa tise'pama qquejeccoeñe in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Fa'e Jesúsma shondo'suja, Judas Iscariote tsu. Cocoya na'su, Satana, tise injama'choma in'jaensi ");
INSERT INTO conNTpo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasja japa Chigama afa'su nasundeccui'ccu sundaro capitándeccui'ccu condasecco ma'caen Jesúsma tise'panga afeya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tsendeccuja avujapa Judasnga corifin'dima afeye su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsonsi Judasja afeye qquen supa japa tta'tta maqui a'i bo'fambi'te Jesúsma afeye cuintsu indi'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pan cupana'cco mechoama aña'cho a'ta napi. Tsequi a'ta tsu Chiga panshaen'cho injienge'cho ovejama'qque fi'ttiya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsa'cansi Jesúsja Juani'ccu Pedroma moen qquen supa: —Japa ñoña'faja Chiga panshaen'cho injienge'cho aña'choma aña'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tise'paja su'fa: —¿Mani qui in'jan ingi ñoña'faye? ");
INSERT INTO conNTpo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesúsja tise'pama su: —Que can'faja. Canqquenga ca'nimba qui a'i tsa'ccu tsoripama angaji'choma cachui'faya. Tisema omboemba ja'faja. Mani tise ca'ni'ninda que'i'qque ca'nimba ");
INSERT INTO conNTpo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tsa tsa'o na'sunga conda'faja: “Atesian'su Jesús tsu quema iñajampaña: ¿Mani tsu queni pasiasundeccu cuarto? Tseni gi ñajan ñama shondosundeccui'ccu Chiga panshaen'cho injienge'cho aña'choma aña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sefani'su ppappacco rande cuartoma tsu tiseja que'inga canjaeña. Tseni tsu osha'cho jin que'i sho'ccoemba ñoña'faya'cho ingi añe. Tseni japa ñoña'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tise'paja japa osha'choma Jesús suqquia'caen attepa Chiga panshaen'cho injienge'cho aña'choma sho'ccoen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Añe bopa Jesúsja tisema shondosundeccui'ccu an'jen'cho mesa jin'tti piyive ccuipa ");
INSERT INTO conNTpo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","tise'pama su: —Ñoa'me gi va injienge'cho aña'choma que'i'ccu añe in'jan ña vanaña'cho toya napimbi'te. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ccase añambi gi va panshaen'cho injienge'cho aña'choma Chiga a'i egae tsincon'choma panshaemba joqquitssiaña'gae. Tsequi a'ta gi poiyi'cco Chiga aindeccui'ccu fae'ngae bopa ccase an'faya. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tsomba tasama isupa tsane Chigama ñotsse afapa tisema shondosundeccuma su: —Vama isupa poiyi'cco fae'ngae re'riccoe cu'i'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ñoa'me gi su ja'ño cu'ipa gi ccase va o'fa tsaja tsa'ccuma cu'iya'bi Chigai'ccu poiyi'cco Tise aindeccu fae'ngae bo'faya'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsomba Jesús panma isupa tsane'qque Chigama ñotsse afapa doñamba tise'panga attufaen qquen supa: —Vaja ña ai'vo tsu. Que'ine gi ña ai'voma afe. Tsa'cansi va panma an'da ña que'ine afe'choma injan'jen'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Omboe pa'ccoma an nanimba tasama'qque isupa afe. Tasama afepa qquen tsu su: —Chiga Quitsa aindeccui'ccu cuname injancco'fa'choma condasesi ña anjampa tsu tsane tssaña'cho. Que'ine gi ña anjampama tssañaña. Va o'fa tsaja tasa tsu ña anjampa tssamba ccushaen'choma canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tsa'ma que can'faja ñama chi'gapa afe'su tsu fae'ngae va mesani ñai'ccu an'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ñajan Sefaccone Ji'cho A'i gi Chiga mandaqquia'caen paya. Tsa'ma va'cha tsu ñama chi'gapa afe'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesús qquen susi tisema shondosundeccu tisupaporai'ccu condasecco'fa majan tsu tsa'caen Jesúsma chi'gapa afeya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Toya'caen tsu afacco'fa majan tise'pa'su ti'tsse joccapitssia. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsonsi Jesús tise'pama su: —Israembindeqquia nasundeccuja tise'pa a'ima manda'fa. A'ima fuiteye tsa'caen manda'fa qquen tsu su'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tsa'ma que'inejan tsa'cambi tsu. Que'inejan majan ti'tsse'tssia tsu utu'ccoe daya'cho. Manda'su tsu shondo'sia'caen daya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Majan tsu ñoa'me ti'tsse'tssia? ¿Mesani an dyai'su? Tsambi'ta ¿semamba o'fian'su? Ju, mesani an dyai'su tsu ti'tsse'tssia. Tsa'ma ñajan tsa sema'sia'caen que'i'ccu can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Que'ija ñai'ccu fae'ngae jacamba qui ñai'ccu fae'ngae vana'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chiga ña Quitsaja tayo tsu ñama na'suve manda. Tsonsi tsa'caen gi ña'qque que'ima na'suve manda cuintsu ");
INSERT INTO conNTpo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ña na'suve dasi que'i'qque ñai'ccu ña an'jen'cho mesanga fae'ngae amba cu'i'faye. Que'ija na'su dyaipa'chonga dyaipa qui poiyi'cco israendeccumbe injama'choma somboeñe manda'faya. Toya'caen tsu Na'suja su: ");
INSERT INTO conNTpo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Simón, Simón, vama canjan. Satanajan poiyi'cco que'ima in'jamba iñajan trigoma qque'shoqquia'caen que'ima vanaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tsa'ma ñajan quene gi Chigama iñajan que ñame in'jan'choma qquesa'ne. Vana'jen'cho panshansi ccushapa que faengasundeccuma'qque quiñaenjan. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tsama pañamba Pedro tisema su: —Na'su, quema picco'je'ttinga picco'fa'ninda gi ña'qque quei'ccu fae'ngae piccoyeya. Quema fi'tti'fa'ninda gi ña'qque quei'ccu fae'ngae paya. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesúsja su: —Pedro, ñoa'me gi quenga su: Arapa gayo toya ja'ño a'ta se'yombi'te queja ñane tres se a'tieña “Tisema atesumbi gi” qquen supa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsomba Jesús poiyi'ccoma iñajampaña: —Ña que'ima bosa ni o'va ni sapatove'qque me'ccoe manda moe'ninda ¿jongoesu tsu shaca? Tise'paja su'fa: —Me'i, shaca'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tsonsi Jesúsja su: —Tsa'caen tayoe mandapa gi ja'ñojan que'ima conda: Majan bosapa'ta tsama angaya'cho. O'vama'qque tsa'caen. Majan a'i sundaro matichive mechota bove ñotssi tsa tise omba'su ondiccu'jema chavaemba sundaro matichima chavaye. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ñoa'me gi su: Va Chiga Tevaen'jen ñane su'choja ja'ño tsu napi: “Egae tsinconsundeccui'ccu tisema in'jan'fa.” Pa'cco ñane tevaen'cho tsu junde napiya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tise'paja su'fa: —Na'su, que canjan. Vani gi an'bian'fa dos sundaro matichima. Jesúsja camba su: —Nanitssi tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsomba Jesúsja sombopa tise in'janqquia'caen Olivo ccotta'cconga ja. Tisema shondosundeccu'qque fae'ngae jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tseni napipa Jesús tise'pama su: —Chigama iñajan'jen'faja egae tsinconsa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsomba tiseja ti'tsse joccani ja –biambi'ccoe– patuma ttovaqquia'can'ccoe. Japa ccaru dyaipa Chigama iñajamba ");
INSERT INTO conNTpo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","su: —Yaya, que in'jan'da va ña vanaña'choma joqquitssianjan. Tsa'ma joqquitssiañe in'jambi'ta que in'janqquia'caen tsonjan. Ña in'jan'chomajan me'i. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsonsi Chigama sefacconi'su shondo'su Jesúsnga attiamba tisema quiñaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsa'caen ñoa'me vana'jemba ti'tsse quia'me Chigama iñajan. Poipa'su'qque sombopa ñoa'me injan'tsse anjampa tssanqquia'caen andenga amppi'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chigama iñajan nanimba jangipa tisema shondosundeccunga japa tise'pa ñombi'yepa ana'jen'choma atte. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Attepa tise'pama su: —¿Micomba qui ana'jen'fa? Jangipa Chigama iñajan'jen'faja egae tsinconsa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tise toya afa'je'ni tsain'bio a'i jiña'fa. Jesúsma shondo'su Judas tsu a'ima angacan. Tiseja Jesúsma mochaye catse. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tsa'ma Jesús tisema su: —Judas, ¿Aqquia ti qui in'janqquia'caen mochapa Sefaccone Ji'cho A'ima cca'indeccunga afeya? ");
INSERT INTO conNTpo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsonsi Jesúsi'ccu jacansundeccuja ma'caen tsoña'chove in'jamba su'fa: —Na'su, ¿matichi'ccu iyicco'faya'an ti gi? ");
INSERT INTO conNTpo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Qquen supa fa'e tise'pa'su Chigama afa'su na'sumbe sema'suma atuipa tise tansinfa'su tsosinama qquerui ttova. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tsa'ma Jesúsja su: —¡Anttéja! Panshaen jova'caen tsinconjama. Qquen supa sema'sumbe tsosinama pporaemba toeningatsse ccushaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Omboe Chigama afa'su nasundeccu, sundaro capitándeccu, israe'su coenzandeccu'qque tsa'caen Jesúsma indiye ji'fasi Jesúsja tise'panga su: —¿Ccanambama indiye jiqquia'caen ti qui sundaro matichi, quini'ccoi'ccu ji'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ñajan Chiga ettini poi a'ta que'i'ccu can'jen'ma qui ñama pporaen'fambi. Tsa'ma va tsu que'i patsuya'cho hora. Sinttia'su na'su, Satana, tsu ja'ño patsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsonsi Jesúsma qquitssa indipa anga'fa. Chigama afa'su na'su ettinga angapa ca'nian'fa. Pedroja omboe biacca jacan. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aindeccu tsa'o atandundunga si'ngema setsaemba sa'vuye dyai'fasi Pedro'qque fae'ngae tise'pai'ccu dyai. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pedro si'nge anchanda'cho a'tatssiani dyaisi sema'su pushesu tisema attepa can'boemba su: —Va a'i'qque tsu Jesúsi'ccu canjen'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tsa'ma Pedroja qquen supa a'tien: —Pushesu, ni ñajan tisema atesumbi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Omboe faesu'qque Pedroma attepa su: —Que'qque tsendeccu'su qui. Tsa'ma Pedroja su: —Tsandie, me'i gi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fae hora'ca'en pasasi faesuja quia'me qquen su: —Ñoa'me tsu va tsandieja Jesúsi'ccu canjen'su. Tise'qque Galilea'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tsa'ma Pedroja su: —Tsandie, atesumbi gi que jongoe qquen su'choma. Tse'faei'ccuyi arapa gayoja se'yo. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Se'yosi Na'su Jesúsja piyicamba Pedroma can'boen. Tsonsi Pedroja Na'su Jesús qquen su'choma in'jan: “Arapa gayo toya ja'ño a'ta se'yombi'te queja ñane tres se a'tieña.” ");
INSERT INTO conNTpo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsa'caen in'jamba Pedroja sombopa quia'me i'na. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tsonsi Jesúsma indisundeccuja tisema afasepa tsse'tsse'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tise tso'fema sarupai'ccu tandamba tise cambajuma tssaipa iñajampaña'fa: —Injama'choi'ccu in'jamba condaja majan tsu quema tssai. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Toya'caen osha'cho egae afa'choi'ccu tisema afase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cosepa a'tasi poiyi'cco israe'su coenzandeccuja bo'fa. Poiyi'cco Chigama afa'su nasundeccu, poiyi'cco Chiga Tevaen'jema atesu'chondeccu'qque bo'fa. Tsa'caen bo'fa'chonga Jesúsma angasi nasundeccuja tisema su'fa: ");
INSERT INTO conNTpo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Queta ti qui Chigambe Cristo? Inginga condaja. Tsa'ma Jesúsja su: Que'inga conda'ni'qque qui ñama paña'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ña que'ima iñajampaña'ni'qque qui ñanga conda'faya'bi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tsa'ma Chigaja osha'choma oshacho. Ñajan Sefaccone Ji'cho A'i. Jai'ngae gi Chiga Quitsai'ccu dyaipa fae'ngae osha'choma mandaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsonsi tsu poiyi'cco su'fa: —¿Tsa'caenda ti qui Chiga Dutssi'ye? Jesúsja tise'pama su: —Ju, que'i suqquia'can gi. ");
INSERT INTO conNTpo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsonsi tsu su'fa: —¿Micomba gi camba afasundeccuve ti'tsse ttatta'je'fa? Tayo gi tise aya'fai'ccu tise su'choma paña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsomba tse'i poiyi'cco bo'fa'chondeccu fae'ngae jangipa Jesúsma anga'fa Na'su Pilatonga. Tseni napipa ");
INSERT INTO conNTpo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jesús ma'caen tsincon'choma condaseye ashaemba su'fa: —Ingija va a'ima attepa gi indi'fa. Tiseja ingi aindeccuma afopoemba atesian'jen. Ingima tsu se'pi Na'su César iñajan'cho impuestoma afeye. Tiseja Cristo qquen tsu su, ande na'su qquen su'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsonsi Pilatoja Jesúsma iñajampaña: —¿Queta ti qui israe'su na'su? Jesúsja conda: —Que suqquia'caen, ña gi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsonsi Pilatoja Chigama afa'su nasundeccuma, a'i bo'fa'chondeccuma'qque su: —Ñajan tisene shacapave attembi gi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tsa'ma tise'paja ti'tsse iyicca'yepa qquen su'fa: —Tiseja poiyi'cco Judea aindeccuma qquejeccoen'su tsu. Nane Galileani atesiañe ashaemba ja'ñojan va canqqueni'qque tsa'caen atesian'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatoja tsama pañamba qquen iñajampaña: “¿Jesústa ti Galilea'su?” ");
INSERT INTO conNTpo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ju,” qquen susi Pilatoja Jesúsma angaye manda Herodesnga. Galilea ande na'su Herodesja tsequi a'ta Jerusaléni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodesja Jesúsma attepa ñoa'me avuja. Osha'choma tisene pañamba bo'tssingae tisema atteye ñombi'ye. Toya'caen tsu in'jan cuintsu Jesús majan sefani'su canjaen'choma attiansi atteye. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsa'caen in'jamba tsain'bitsse Jesúsma iñajampaña. Tsa'ma Jesúsja afambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chigama afa'su nasundeccu, Chiga Tevaen'jema atesu'chondeccu Herodesnga fae'ngae ccutsupa ñoa'me Jesúsne osha'cho egave conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes, tise sundarondeccu'qque Jesúsma chi'gapa afase feña'jen'fa. Ñotssia na'su sarupa'cain'ccu tisema ondiqquiamba toequi Pilatonga maña. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tayoeja Herodesja Pilatoi'ccu iyiccaye'su. Tsa'ma tsequi a'ta tsu ñoquicco'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tsomba tse'i Pilatoja Chigama afa'su nasundeccuma, israe'su nasundeccuma, poiyi'cco a'ima'qque ttu'se boñamba ");
INSERT INTO conNTpo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","su: —Tiseja aindeccuma quejeccoen'su qquen supa qui va a'ima ñanga i'fa. Que'i caña'jen'ni gi tisema iñajampaña'ma que'i suqquia'caen egae tsincon'chove attembi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Toya'caen Herodes'qque tisema iñajampaña'ma shacapave attembipa tisema toequi moen. Va a'ija jongoesuma'qque egae tsincombi tisema fi'ttiya'chove. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsa'cansi gi tisema ma'ppipa ccupaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Poi canqque'fa Chiga panshaen'cho injienge'cho fiestama panshaen'jenqui tsu na'su Pilatoja fae indiye'choma ccupaye atesu. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jesúsma ccupaye qquen susi poiyi'cco a'i fae'ngatsse fundondo'e afa'fa: —¡Va a'ima fi'ttipa Barrabásma ccupaja! ");
INSERT INTO conNTpo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nane voeyi Jerusaléni tsa Barrabásja nasundeccuma joqquitssiañe in'jamba a'ima fi'ttisi tisema indipa piccopa an'bian. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoja toya Jesúsma ccupaye in'jamba ccase aindeccunga tsa'caen su. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tsa'ma ti'tsse fundondo'e su'fa: —¡Avuja'cconga otija! ¡Avuja'cconga otipa fi'ttija! ");
INSERT INTO conNTpo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ccase, tres se Pilatoja aindeccunga su: —¿Jongoesune qui tisema fi'ttiye in'jan'fa? ¿Jongoesian tsu egaeta tsincon? Attembi gi jongoesuve egae tsincon'choma tisema fi'ttiya'chove. Tsa'camba gi tisema ma'ppipa ccupaya. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tsa'ma aindeccuja iyicca'yepa quia'me fundondo'e afapa Pilatoma manda'fa cuintsu avuja'cconga Jesúsma fi'ttiye. Tsa'caen fundo'jepa Pilatoma patsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tsonsi Pilatoja Jesúsma fi'ttiye manda tise'pa in'janqquia'caen. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tsomba indiye'cho Barrabásma, tsa nasundeccuma joqquitssiañe in'jamba a'ima fi'tti'su, tsama tiseja ccupa. Tsa'ma Jesúsma a'inga afe cuintsu tise'pa in'janqquia'caen tson'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tsonsi sundarondeccu Jesúsma fi'ttiye angaji'fa'ni Simón, Cirene ande'su a'i, canqquenga ca'nisi cachuiccopa tisema indi'fa. Indipa manda'fa cuintsu Jesús avuja'ccoma andupa Jesús sepaccofae jiye. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Toya'caen tsain'bio a'i Jesús sepaccofae jiña'fa. Tsain'bio pushesundeccu'qque jiñamba ñombi'yepa ina'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tsa'ma Jesúsja piyicamba tise'pama su: —Jerusaléni'su pushesundeccu, ñane i'na'fajama. Tsa'ma que'ine, que'i dushundeccune i'na'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nane jai'ngae napisi tsu a'ija qquen su'faya: “Avujatssiya tsu majan pushesu du'shu mechoaja. Nane majan du'shuve isumbi'ta, majan du'shuma chochoembi'ta avujatssiya tsu.” ");
INSERT INTO conNTpo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsequi a'ta tsu a'ija paye in'jamba ccotta'cco tisenga amppipa a'tuye ñombi'ye'faya. Tsa'caen in'jamba tsu ccotta'ccoma qquen su'faya: “¡Inginga amppi otssija!” ");
INSERT INTO conNTpo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nane cuna ttemba re'riccoe si'ngenga ju'ruqquia'caen ñajan ja'ño vanaña. Tsa'ma quini'cco samba quia'me ju'ruqquia'caen qui que'ija ti'tsse'tsse vana'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Toya'caen faesu dos a'i, egae tsinconsundeccuma'qque Jesúsi'ccu fae'ngae fi'ttiye anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","“Tsove tsu'tta” qquen su'cho ccotta'cconga napipa tse'ttinga Jesúsma avuja'cconga otipa ccutsian'fa. Tsa dos egae tsinconsundeccuma'qque faesu avuja'cconga otipa ccutsian'fa fa'emajan Jesús tansinfanga, faesumajan Jesús pavefanga. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ccutsiansi Jesúsja su: —Yaya, tise'pa'ye va egae tsincon'choma joqquitssianjan. Va aindeccuja tise'pa tson'jen'choma atesu'fambi. Toya'caen sundarondeccuja gana qquen cofe'je'fa Jesús ondiccu'je'cho sarupama attufaenccoye. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aindeccuja can ccutsu'fa. Toya'caen nasundeccuja tisema afase'fa qquen supa: —Tiseja faesuma ccushaen. Cuintsu faesuma ccushaenqquia'caeñi tisuma'qque tsa'caen ccushaenjan. Tiseja ñoa'me Chiga in'jan'cho Cristota tsa'caen tsu canjaeña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sundarondeccu'qque tisenga catsepa inzatssia o'fa tsaja tsa'ccuma cui'ña qquen co'fe'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Toya'caen afasepa tsu qquen su'fa: —¡Queja ñoa'me israe'su na'suta tisuma ccushaenjan! ");
INSERT INTO conNTpo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Toya'caen Jesús tsove omba'ttinga qquen tevaen'choma avuja'cconga ancaen'fa. Vaja israe'su na'su. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Fa'e egae tsincon'su Jesúsi'ccu pporotsse avuja'cconga otiye'choja Jesúsma afasepa su: —¡Queja ñoa'me Cristota Tisuma ccushaemba ingima'qque ccushaenjan! ");
INSERT INTO conNTpo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tsa'ma faesu otiye'choja tise faenga'suma iyu'upa su: —¿Dyombi ti qui Chiganejan? Que'qque va a'ia'caen paya. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ingija egae tsincomba gi ja'ño vanamba tsane afepoen'jen'fa. Nane manda'cho mandaqquia'caen gi pa'faya. Tsa'ma va a'ija egae tsincombi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tsomba tiseja Jesúsma su: —Jesús, que na'suve da'ta ñama injan'jenjan. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesúsja tisema su: —Ñoa'me gi su, ja'ño a'ta qui ñai'ccu Chiga ñotssiani can'jeña. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tayo chiga tansia'ni pa'cco ande'ye sintsse coseqquia'ca'en da. Nane chiga ondu'setsse tsa'caen sintsse da. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tsa'caen coejechiga da'je'ni Chiga etti'su Chigai'ccu cachuicco'je'cho cuartoma picco'je'cho sarupa'qque chittain ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tsonsi Jesúsja quia'me afapa su: —¡Yaya, ña qquendya'pama gi quenga afe'je! Qquen susi tise qquendya'pa somboin jasi pa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tsonsi sundaro capitán tsa'caen da'choma attepa Chigama ñotsse afapa su: —Ñoa'me va a'ija egae tsincombi. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tsain'bio a'i avuja'cconga fi'tti'choma atteye bopa Jesús tayo pasi attepa tise'pa utu'choma tssai'fa ñombi'ye'choma canjaeñe. Tsa'caen ñombi'yepa tise'pa tsaoni jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Toya'caen Jesús amigondeccu'qque biapieyi ccutsupa pa'tssima atte'fa. Majan pushesundeccu'qque, Jesúsi'ccu fae'ngae Galileane ji'chondeccu'qque tsendeccui'ccu fae'ngae ccutsupa atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Israe'su nasundeccu bopa Jesúsma fi'ttiye mandasi fa'eja tansintsse in'jamba fi'ttiye se'pi. Tsaja ño'a a'i, tise iniseja José. Judea ande'su Arimatea canqque'su a'i tsu. Tiseja in'jamba Chiga tisu aindeccuma ccushaemba mandaya'chove ronda'je. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tise tsu Pilatoni japa Jesús ai'vove iñajan. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","“Isupa angaja” qquen susi avuja'cco'ye andiamba totoa sarupai'ccu findipa ñoña'cho fattocco chango atu'ttinga ccuiña'fa. Tseccungaja faesu pa'choma toya a'tumbi'choa. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sema'ma'qquia a'ta tayo napijisi toya tsu ñoña'jen'cho a'ta. ");
INSERT INTO conNTpo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tsonsi pushesundeccu'qque Jesúsi'ccu fae'ngae Galileane ji'chondeccu omboe jipa atu'ttima atte'fa. Ai'voma ma'caen ccuiña'choma'qque attepa ");
INSERT INTO conNTpo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","toequi Jerusaléni ja'fa. Tsa'caen japa pa'chombe ai'voma onjoenqque'su ñome'bama'qque ñoña'fa Jesús ai'voma onjoeñe. Manda'cho mandaqquia'caen sema'ma'qquia a'ta tseni ño'fá can'jen'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cuna avujaquive a'tapa coe'je tseyi deji'ni tsesu pushesundeccuja atu'ttini ja'fa. Ñome'bama tayo ñoñamba anga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Napipa atte'fa picco'cho patuma tayo joqquitssian'choma. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsa'ma atu'ttinga ca'nimba Na'su Jesús ai'voma atte'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Toya dyopa asi'ttaén ccutsu'fa'ni dos a'i, ondiccu'je chhariccotssia'ma ondiccucho'chondeccu, fae'ngae fae'tti ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tsama attepa pushesundeccuja dyopa puntssan ccutsu'fa. Tsa'ma tsa tsandiendeccuja tise'pama su'fa: —¿Jongoesie qui a'ija cansiama pa'cho ccuini ttatta'je'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tiseja va'tti can'jembi. Tayo tsu qquendyapa ja. ¿Injan'jen'fambi ti qui Jesús que'inga su'choma? Nane toya Galileani can'jemba tiseja conda ");
INSERT INTO conNTpo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ma'caen Sefaccone Ji'cho A'i egae tsinconsundeccunga afeyeya'choma. Tsendeccu avuja'cconga tisema fi'ttisi tres a'ta pasasi ccase qquendyaya'chone conda. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsa'caen susi Jesús su'choma in'jamba ");
INSERT INTO conNTpo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","atu'ttine sombopa japa Jesúsma once shondosundeccunga conda'fa. Cca'i Jesús aindeccunga'qque pa'ccoma conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena, Juana, faesu María (tsaja Santiago chan) tise'pai'ccu jacan'su pushesundeccu'qque pa'ccoma attepa Jesúsma shondosundeccunga condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tsa'ma tsendeccuja pañamba “Aqquia su'cho” qquen in'jamba in'jan'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tsa'ma Pedroja tse'faei'ccuyi jangipa buttopa atu'ttini ja. Ccarupa ppoicamba oppoen'cho sarupaveyi atte. Attepa ma'caen da'choma asi'ttaemba toequi tsaoni ji. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tsequi a'ta dos a'i Emaús canqqueni jayi'fa. Tsa canqqueja Jerusaléne once kilometro tsu. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jayipa osha'cho voeyi tson'chone condase'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsa'caen condase'je'fasi Jesúsja catsepa fae'ngae jayi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tsa'ma a'ija Jesúsma atte'ma tise've atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsonsi Jesúsja tise'pama iñajampaña: —¿Jongoesune qui condasé jayi'fa? Tsa'caen iñajampañasi ñombi'yepa zu ccutsu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsa'caen zu ccutsupa fa'e, Cleofás, qquen inisecho'cho, tisema su: —Poiyi'cco biani can'jensundeccu tsu Jerusaléni jipa tseni voeyi tson'choma atesu'fa. ¿Queyi ti qui tsama atesumbi'choa? ");
INSERT INTO conNTpo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tsonsi Jesús tise'pama su: —¿Jongoesuma tsu tson'fa? Tsonsi tisenga conda'fa: —Jesús Nasarenoma tson'cho tsu. Tiseja Chiga Aya'fama afa'su. Osha'cho ñotssiave atesiamba osha'cho ñotssiave tson. Chiga tisei'ccu can'jensi poiyi'cco a'i tise've in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tsa'ma Chigama afa'su nasundeccu, ingi nasundeccu'qque, tsa Jesúsma indipa Na'su Pilatonga afe'fa cuintsu fi'ttiye. Pilato fi'ttiye mandasi sundarondeccu tisema avuja'cconga otipa fi'tti'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ingija asi'ttaemba in'jan'fa'a tiseja israendeccuma ccushaen'su. Tsa'ma ja'ño tres a'ta tsu pasa osha'cho tsa'caen tson'fa'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Toya'caen ja'ño a'ta majan ingi'su pushesundeccu ccaningae tson'choma'qque inginga conda'fa. Ja'ño sinte'yi atu'ttini japa ");
INSERT INTO conNTpo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesús ai'voma atte'fambi. Tsa'ma sefacconi'su Chigama shondosundeccuma attepa “Jesúsja tayo qquendya” qquen paña'fa. Tsa'caen tsu inginga conda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Majan ingi'su tsandiendeccu'qque atu'ttini japa pushesundeccu suqquia'caen atte'fa. Tsa'ma Jesúsma atte'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsonsi Jesúsja tise'pama su: —¡Tsosinambi'fa qui! Ñoa'me qui injama'cho shaca'fa osha'cho Chiga Aya'fama afasundeccu su'choma in'jañe. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nane tsendeccuja tansintsse tsu conda'fa. Cristoja toya joccapitssia've dambi'te tsu tsa'caen osha'chone vanaña'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsomba Moisés condase'choi'ccu ashaemba pa'cco Chiga Aya'fama afasundeccu Cristone condase'choma a'tatsse tise'panga atesian. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús canqqueni pan napijipa Jesúsja ti'tsse joccani jaya'caen jayisi ");
INSERT INTO conNTpo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tisema se'pi'fa qquen supa: —Tayo tsu sime. Coseya tsu. Ingi'ccu can'jenjan. Tsonsi Jesúsja tise'pa tsaoni japa ca'ni. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tise'pai'ccu mesanga dyaipa Jesúsja panma isupa Chigama iñajan. Tsomba panma doñamba tise'panga afe. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Panma afesi tse'faei'ccuyi tise'pa tso'fe fettayeqquia'caen Jesúsve attepa in'jan'fa. In'jan'fasi Jesúsja atte'masiave dapa ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsonsi tisupanaccu condasecco'fa: —¿Injama'cho tsosipie avujatssi'fambi ti gi tiseja tsaiquinga ingi'ccu condase'jesi? Nane Chiga Tevaen'jema inginga atesian'jensi gi ñoa'me avuja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tse'faei'ccuyi jangipa toequi Jerusaléni shanda'fa. Jipa Jesúsma once shondosundeccu faesundeccui'ccu fae'ngae can'jen'choma atte'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tsonsi Jesúsma shondosundeccuja tise'pama su'fa: —Ñoa'me tsu Na'suja ccase qquendya. ¡Simónga tsu Tisuma attian! ");
INSERT INTO conNTpo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsonsi Emaús can'jensundeccu'qque poiyi'cconga condase'fa Jesús tise'pai'ccu tsaiqui'ye ja'choma. Toya'caen Jesús doñamba afesi in'jan'choma'qque condase'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsa'caen condase'je'fa'ni Jesús tise'panga attiamba enttingenga ccutsupa su: —Dyombe can'faja. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Poiyi'cco dyopa can'boen'fa aya qquen in'jamba. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tsa'ma Jesúsja su: —¿Micomba qui dyo'fa? ¿Micomba qui injama'choni asi'ttae'ma toya in'jan'fambi? ");
INSERT INTO conNTpo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ña tive, ña tsu'ttema'qque can'faja. Ñañi gi. Ñama pporaemba can'faja. Camba qui in'jan'faya ñajan nama, tsu'ttama'qque an'bian. Ayaja tsa'caen an'biambi. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Qquen supa tise tive, tsu'ttema'qque canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tsa'ma tsendeccuja avuja'ma toya in'jañe osha'fambi. Toya asi'ttaen'jen'fa'ni Jesúsja su: —¿Aña'chomanda ti qui an'bian'fa? ");
INSERT INTO conNTpo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsonsi avu san'jama, tuño cuñajun'choma'qque afesi ");
INSERT INTO conNTpo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","isupa poiyi'cco caña'jen'ni an. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tsomba Jesúsja tise'pama su: —Ña toya que'i'ccu can'jeinte gi ja'ño tsoña'chone conda'a. Nane Moisés manda'cho, Chiga Aya'fama afasundeccu tevaen'jen, settapoen'cho tevaen'jen'qque ñama tsoña'chone condase'fa. Tsa tayoe ña que'inga condase'choma tsu ja'ño tson'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsomba tise'pa injama'choma in'jaen cuintsu Chiga Tevaen'jema in'jan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Toya'caen tsu su: —Tayo tsu tevaen: Ccushaen'su Cristoja vanamba papa tres a'tangae ccase qquendyaya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Toya'caen tsu tevaen: Jerusaléne ashaemba tsu Cristone ñotsse condase'choma poi ande'su aindeccunga condaseya'cho cuintsu paña'faye. Pañamba tise'pa egae tsincon'choma chi'gapa Cristove in'jan'ninda tiseja a'i egae tsincon'choma joqquitssiaña. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Que'ija pa'cco vama camba cca'indeccunga condase'faya'cho. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ja'ño gi ña Yaya afeya'cho qquen su'choma que'inga afeya. Tsa'ma Jerusaléni ronda'je'faja sefacconi'su Chiga Qquendya'pa que'ima in'jaeña'ngae. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsomba sombopa Jesúsja tise'pama Betaniani angaji. Tsa'caen angajipa tise tivema sefaningae yasapa Chigama iñajan cuintsu Chiga tisema shondosundeccuma fuiteye. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Toya tsa'caen iñajan'jen'ttie Jesúsja tise'pama catipa sefacconi ansundin ja. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tsa'caen jasi shondosundeccuja Jesúsne ñotsse afapa ñoa'me avujapa toequi Jerusaléni shanda'fa. ");
INSERT INTO conNTpo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Poi a'ta Chiga ettini can'jemba Chigama ñotsse afa'je'fa. Tsangaeyi.");
INSERT INTO conNTpo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Me'ttia'ye Chiga Aya'faja jin. Chiga Aya'faja Chigai'ccu can'jemba Chiga tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tsaja me'ttia'ye Chigai'ccu can'jensi ");
INSERT INTO conNTpo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chigaja tisei'ccu osha'chove agattoen. Nane me'i'on tsu osha'cho agattoen'choja tisei'ccu agattoembi'choave. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tiseja qquendyaen'su tsu osha'choma cansiañe. A'ima qquendyaemba tise'pama chanjienqquia'caen tansintssia've in'jaen. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sinttia'ye chanjienqquia'caen va ande'su egae jinchoma attiansi egae sinttiaja tise in'jaen'choma patsuye oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chigaja a'ima moen, tise iniseja Juan. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juanjan condaseye ji chanjien'sune. Qquen tsu condaseye ji cuintsu poiyi'cco a'i tise su'choma pañamba chanjien'suve in'jan'faye. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanjan chanjien'sumbi. Tsa'ma chanjien'sune tsu condaseye ji. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ñoa'me chanjien'su tsu va andeni jiña poi a'i injama'choma attiañe. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chiga Aya'fai'ccu Chiga a'ima agattoensi tayo tsu tiseja a'i'ccu can'jen. Tsa'ma tsa'caen can'jen'ni'qque tise agattoen'cho a'ija tisema atesu'fambi. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nane a'ive dapa jisi tisupanaccuja tisema chi'ga'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tsa'ma majan a'i tise've in'jamba “tiseja Chigambe Cristo tsu” qquen su'ninda tsu tiseja antte cuintsu tsendeccu'qque Chiga dutssiyendeccuve da'faye. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A'i du'shuma isuqquia'cambi tsu. Ni a'i in'jamba tsonqquia'cambi tsu. Tsa'ma Chiga in'jamba mandasi tsu Chiga dutssiyendeccuve da'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chiga Aya'faja a'ive dapa ingi'ccu can'jen. Tiseja ti'tsse'tssiasi gi atte'fa. Nane Chiga Dutssi'yeyi tsu tsa'caen ti'tsse'tssia. Tiseja osha'cho ñotssiaveyi tsomba tansintssia'veyi conda. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nane Juanjan tisene condasepa su: —Va tsu ña condase'cho a'i, ña qquen su'choja: Ñama omba'su a'i tsu ñama ti'tsse'tssia. Ñame meinte tiseja can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tise ñoa'me osha'cho ñotssiaveyi tsonsi ingija ñotsse isu'fa. Nane isupa gi ti'tsse isu'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisésja Chiga manda'choma afapa conda. Tsa'ma Jesucristoma moemba Chigaja Tise ingima in'jamba ñotsse tson'choma tansintsse canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Minguite'qque a'ija Chigama atte'fambi. Tsa'ma Jesucristo Chiga Dutssi'yeyi tsu tise Yayai'ccu fae'ngae jinchopa Chigama inginga canjaen. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusaléni'su israendeccuja a'ima Juanga mandamoen'fa. Chigama afa'su nasundeccu, Chiga etti'suma semasundeccu'qque japa: “¿Majan qui queja?” qquen iñajampaña'fasi ");
INSERT INTO conNTpo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juanjan dyombi'tsse tansintsse conda: —Chiga moen'cho Cristombi gi. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Qquen susi iñajampaña'fa: —Tsambi'ta ¿majan qui queja? ¿Que ti qui Chiga Aya'fama afa'su Elías? Juanjan su: —Tsambi gi. Omboe iñajampaña'fa: —¿Que ti qui ingi ronda'je'cho Chiga Aya'fama afa'su? Ccase tsu Juanjan su: —Me'i. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsonsi ccase iñajampaña'fa: —Tsambi'ta ¿majan qui queja ingi japa condaye ingima mandasundeccunga? ¿Majan qui qquen qui suya queja? ");
INSERT INTO conNTpo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tsonsi Juanjan Chiga Aya'fama afa'su Isaías tayopi suqquia'caen su: —Ña gi chundundu'a'ye fundondo'e afa'su: “Ji'je'choma ñoña'faja na'sune.” ");
INSERT INTO conNTpo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tsonsi mandasi ji'cho fariseondeccuja ");
INSERT INTO conNTpo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","qquen iñajampaña'fa: —Tsa'caen Cristombi'ta ni Elíasmbi'ta ni ingi ronda'je'cho Chiga Aya'fama afa'sumbi'ta, ¿jongoesie qui feti'je? ");
INSERT INTO conNTpo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tsonsi Juanjan su: —Ñajan tsa'ccui'ccu feti'je. Tsa'ma que'i enttingeni tsu ccutsu fa'e que'i atesumbi'choa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tsa tsu ñama omba'su. Tsa'ma tiseja ñoa'me ñama ti'tsse'tssia. Nane ñoa'me gi ñajan tisema coira'suve ca'niñe oshambi ni tise'be sapato tandan'choma yoripa dyaipa ccupaye'qque. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juan Betábara Jordán na'en jonifani feti'jesi tsu tsa'caen tisema iñajampaña'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ccaqui a'ta Jesús Juanga catsesi Juanjan attepa inginga su: —Que canjan: Tsa a'ija Chiganga afe'cho oveja tsu. Poiyi'cco a'i egae jincho'choma joqquitssian'su tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tisene gi afa qquen supa: “Ñama omba'su a'ija ñama ti'tsse'tssia tsu. Ñame meinte tiseja can'jen.” ");
INSERT INTO conNTpo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ña'qque tisema atesumbi'ma gi tsa'ccui'ccu feti'su ji tisema israendeccunga canjaeñe. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Tsomba Juanjan ti'tsse Jesúsne condase: —Ña'qque toya atesumbisi ñama tsa'ccui'ccu fetiye mandamoen'suja su: “Atteya qui Chiga Qquendya'pa majan a'inga andepa can'jen'choma. Tsa tsu ñoa'me Chiga Qquendya'pai'ccu feti'su.” Ña gi atte Chiga Qquendya'pa sefaccone ppuppuju'choa'caen Jesúsnga andepa can'jen'choma. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Attepa gi que'inga conda va Jesúsja ñoa'me Chiga Dutssi'ye tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ccaqui a'ta Juanjan ccutsu dos ingi tisema shondosundeccui'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús tse'fae jayisi Juanjan tisema attepa inginga su: —Que canjan: Tsa a'ija Chiganga afe'cho oveja tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ingija Juan su'choma pañamba Jesúsi'ccu fae'ngae omboe jaja'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tsa'caen jayi'fasi Jesúsja piyicamba ingima attepa su: —¿Jongoesuve qui ttatta'je'fa? Ingija su'fa: —Rabbí, ¿mani qui can'jen? (Rabbí tsu atesian'su qquen su'cho.) ");
INSERT INTO conNTpo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tsonsi Jesúsja su: —Jipa can'gi'faja. Tsonsi tise can'jeni japa gi atte'fa. Chiga tayo ondusesi japa tse'tti can'jen cose. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ñajan, Andrésui'ccu Juan su'choma pañamba gi Jesúsi'ccu ja'fa. Andrésja Simón Pedro quinshin. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tse'faei'ccuyi tise quindya Simónma tta'ttapa attepa su: —Mesíasma gi atte'fa. (Chiga moen'cho Cristo qquen su'cho tise'pa aya'fangae.) ");
INSERT INTO conNTpo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tsomba tisema anga Jesúsnga. Jesúsja Simónma attepa su: —Que qui Simón, Jonás dutssi'ye. Tsa'ma Cefasve tsu inisiaña'cho. (Pedro, qquen tise aya'fangae, patu qquen su'cho.) ");
INSERT INTO conNTpo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ccaqui a'ta Jesúsja Galilea andeni jaye in'jamba Felipema attepa ttu'se: —Jija ñai'ccu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Tsa Felipe tsu Betsaida canqque'su a'i. Andrés, Pedro'qque tsa canqque'su aindeccu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tsonsi Felipe Natanaelma tta'tta'su japa attepa su: —Tayo gi atte'fa a'ima majan'ne Moisés tayopi tevaen manda'cho tevaen'jenga. Tisene tsu Chiga Aya'fama afasundeccu'qque tevaen'fa. Jesús tsu, Nasaret canqque'su, tsa José dutssi'ye. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelja su: —¿Minguite tsu Nasaret'ye ñotssiaja somboya? Tsa'caen susi Felipeja su: —Jipa can'gija. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael catsesi Jesúsja tisema attepa su: —Que canjan: Vaja ñotssia israe'su. Ñoa'me afopoen'masia tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael tisema pañamba iñajampaña: —¿Ma'caen qui ñama atesu? Tsonsi Jesúsja tisema su: —Felipe toya quema ttu'sembi'te gi quema atte, higuera teta'chojin tsosiccuni dyai'choma. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelja pañamba su: —Atesian'su, que qui Chiga Dutssi'ye. Que qui israe Na'su. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tsonsi Jesúsja su: —¿Ñajan higuera teta'chojin tsosiccuni dyai'choma atte qquen susi ti qui ñame in'jan? Nane tsama ti'tsse'tssia'ma qui atteya. ");
INSERT INTO conNTpo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Toya'caen Jesúsja su: —Nane ñoa'me gi que'inga su: Sefacco fettayesi qui atte'faya Chigama sefacconi'su shondosundeccu ñani ji'ngipa ja'je'choma. Sefaccone Ji'cho A'i gi. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tres a'ta pasasi casara'je'fa'cho jin Galilea ande'su Caná canqqueni. Jesús chan'qque tseni can'jen. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesúsma, ingi tisema shondosundeccuma'qque ttu'se'fa casara'je'fa'chonga. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino sefasi Jesús chanjan Jesúsnga conda: —Tayo tsu vino sefa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tsa'ma Jesúsja pañamba su: —Mama, ¿jongoesie qui ñangaja conda? Toya tsu ña attiaña'cho napimbi. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tsa'ma tise chanjan cuiñasundeccuma su: —Ma'caen su'nijan tsa'caen pa'ccoma tson'faja. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tse'tti tsu seis patuma ñoña'cho tsoripa ccutsu'fa. Tsesu tsoripaja israendeccu asettupa onjon'jen'cho tsa'ccuma fiña'jen'cho: Nane majan ochenta, majan cien botiyave on'boeña'ga'o. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsonsi Jesúsja manda cuiñasundeccuma: —Tsa'ccuma va tsoripanga on'boen'faja. Tsonsi on'batsse tsa'ccuma on'boen'fasi ");
INSERT INTO conNTpo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesúsja su: —Ja'ño re'riccoe ichhoipa fiesta na'sunga cui'ñajan. Tsa'caen tson'fasi ");
INSERT INTO conNTpo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","fiesta na'su tsa'ccuma cuicansi tayo tsu vinome da. Tiseja atesumbi mania somboen'chove'qque. Tsa'ma cuiñasundeccuja atesu'fa tsa'ccuma ichhoi somboemba cui'ña'choma. Tsonsi fiesta na'suja casara'su tsandiema ttu'sepa ");
INSERT INTO conNTpo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tisenga su: —Poiyi'cco a'i tsu o'tie ñotssia vinoma cui'ñañe atesu'fa. Tsonsi cu'isundeccu tsain'bitsse cu'i'fasi bove ansimbi'choama tsu cui'ñaña'cho. Tsa'ma queja bove ñotssiama an'biamba ja'ño somboemba cui'ña. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsa'caen tsu Galilea'su Canáni Jesúsja me'ttia'ye canjaen tise osha'choma oshacho'choan. Ingi tisema shondosundeccu'qque attepa gi Tise've in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsomba tse'i Jesús Capernaum canqqueni jayisi tise chan, tise quinshingendeccu, ingi tisema shondosundeccu'qque fae'ngae jaja'fa. Tseni re'riccoe can'jencca'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ingi israendeccu Chiga panshaen'cho injienge'cho fiesta pan napijisi Jesúsja Jerusaléni ja. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chiga ettini japa atte chavaensundeccuma. Majanda vaura, majanda oveja, majanda ppuppuju'choma chavaen'jen'fa. Toya'caen tse'tti corifin'dima cambiansundeccu'qque dyai'fa tise'pa mesa jin'tti. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsama attepa Jesúsja simba'fama ma'ppi'fave ñoñamba chavaensundeccuma ma'ppimañajan Chiga etti'ye. Ovejama, vaurama'qque na'sui'ccu fae'ngae ma'ppimañajan. Corifin'dima cambiansundeccu mesama'qque qquitssa tovaccoemba pa'cco corifin'dima shequian moen. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Toya'caen ppuppuju'choma chavaensundeccunga su: —Pa'cco vama joqquitssian'faja. ¿Ma'caen qui ña Yaya ettima chavaen'jen'ttive tson'fa? ");
INSERT INTO conNTpo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tse'i ingija tayo'su Chiga Tevaen'jen qquen su'choma in'jan'fa: “Chiga Quitsa, Que ettima ñoa'me in'jamba gi paya'ngae dyombi'tsse coiraya.” ");
INSERT INTO conNTpo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsa'caen tsonsi israendeccuja Jesúsma iñajampaña'fa: —¿Jongoesuma qui canjaeña majan quema mandasi jova'caen tsincon'chove ingi atesuye? ");
INSERT INTO conNTpo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Qquen iñajampañasi Jesúsja su: —Va Chiga ettima osian'ninda gi tres a'tangae ccase ccutsiaña. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsa'ma israendeccuja su'fa: —Cuarenta y seis canqque'fanga va Chiga ettima tsao'ña'choanda ¿ma'caen qui queja tres a'tangae ccutsiaña? ");
INSERT INTO conNTpo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tsa'ma Jesúsja Chiga ettine afaqquia'caen ñoa'me tisu ai'vone afa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tsa'caen supa papa ccase qquendyasi ingi tisema shondosundeccuja in'jan'fa Jesús su'choma. Tsa'caen injan'jemba gi Chiga tevaen'jeme in'jan'fa. Jesús su'chove'qque gi in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Chiga pashaen'cho injienge'cho fiesta napisi Jesús Jerusaléni can'jensi tsain'bio a'i tise canjaen'choma attepa tiseja Chiga moen'cho Cristo qquen in'jan'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tsa'ma Jesúsja poimbe injama'choma atesupa anttembi cuintsu tise'pa in'jan'choma tson'faye. ");
INSERT INTO conNTpo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nane Jesúsja poimbe injama'cho ma'caen jincho'choma atesuchosi tsu me'i'on tisenga ti'tsse a'ine conda'suve. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fariseondeccu in'jan'chove in'jan'su a'i tsu can'jen, tise inise Nicodemo. Tsa'qque israe'su nasundeccu'su. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cose Nicodemojan Jesúsni can'su jipa su: —Atesian'su, atesu'fa gi queja ñoa'me Chiga moen'cho atesian'su qui. Majañi'qque quia'caen canjaen'choma canjaeñe oshambi Chiga tisei'ccu can'jembian'da. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsonsi Jesúsja su: —Ñoa'me gi su, majan cuname isumbi'choa'manda ¿ma'caen tsu Chigaja tise na'suve daya? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsonsi Nicodemo iñajampaña: —¿Ma'caen tsu coenza ccasheye'ta cuname isu'chove daya? ¿Oshaya ti tise mamanga ccase ca'nimba ccase somboye'ta? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tsonsi Jesúsja su: —Nane ñoa'me gi su, majan tsa'ccui'ccu toya'caen Qquendya'pai'ccu isumbi'choa'ta tsu Chigama na'siañe oshambi. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ai'vo'ye isucho'ta ai'vo tsu. Qquendya'pa'ye isucho'ta qquendya'pa tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¿Ma'camba qui in'jambe can'boen, “Poiyi'cco tsu ccase cuname isuya'cho,” qquen ña susi? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fingianjan mani in'jan'da tsu fingian. Tise jen'fama paña'ma qui atesumbi mane ji'choma ni mani ja'choma. Tsa'can tsu poiyi'cco majan Qquendya'pai'ccu isu'cho'ta. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsonsi Nicodemo ccase iñajampaña: —Tsa'can'ninda ¿Ma'caen tsu tsoña'cho? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesúsja afapa su: —Queja israe atesian'suta ¿ma'camba qui atesumbi tsama? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nane ñoa'me gi su, tisupa atesucho'choma gi afa'fa. Tisupa atte'choma gi condase'fa. Tsa'ma que'ija paña'fambi qui ingi condase'choma. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Que'inga va ande'suma condasesi pañambi'ta ¿ma'caen qui in'jan'faya sefacconima condase'ninda? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Majañi'qque sefacconi ansundepa andepa conda'fambi. Tsa'ma Sefaccone Ji'cho A'i gi andenga ande'cho condaye osha. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés a'i menia can'jemba ñoña'cho iyoma jangianqquia'caen Sefaccone Ji'cho A'ima jangiaña'cho ");
INSERT INTO conNTpo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","cuintsu poiyi'cco majan tise've in'jan'chota Chigai'ccu tsangae canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nane Chigaja va andeni'su a'ima tsain'bitsse in'jamba Tise Dutssi'ye fae'ccoama a'inga afemoen cuintsu poiyi'cco majan tise've in'jan'chota catiyembe'yi Chigai'ccu tsangae canse'faye. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nane Chigaja Tise Dutssi'yema moembi cuintsu a'i injama'choma somboeñe. Tsa'ma poiyi'cco a'ima ccushaeñe tsu tisema moen. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Majan Chiga Dutssi'yeve in'jan'ninda Chigaja tise injama'choma somboeña'bi tsu. Tsa'ma majan Chiga Dutssi'ye fae'ccoama chi'gapa in'jambian'da tayo tsu tise injama'choma somboen. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Qquen tsu injama'choma somboen'cho: Chiga Dutssi'ye chanjien'suve a'inga jipa a'tatssia've condasesi in'jambi'chondeqquiaja sinttiani can'jeñe in'jan'fa tise'pa egae tsincon'choma attiañe in'jambipa. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Poiyi'cco egae tsinconsundeccu tsu a'tatssia'ma chi'ga'fa. A'tatssianga ji'fambi tise'pa egae tsincon'choma attiansa'ne. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tsa'ma ñotsse cansesundeccu tsu a'tatssianga ji'fa cuintsu cca'indeccu in'jan'faye tise'pa tson'choja ñoa'me Chiga tson'cho tsu. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsomba tse'i Jesús ingi tisema shondosundeccui'ccu Judea andeni japa can'jen'fa. Tseni fae'ngae can'jemba a'ima feti'je'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Feti'su Juan'qque toya picco'je'chonga piccoyembi'te Enóni can'jemba a'ima feti'je. Nane tse'tti Salim canqque jin'tti tsain'bia tsa'ccu jinchosi a'ija tseni jipa fetiye'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tsonsi majan Juanma shondosundeccuja faesu israe'sui'ccu condasecco'fa asettupa onjon'chone. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Condaseccopa Juanga japa su'fa: —Atesian'su, Jordán na'en jonifani quei'ccu jacan'su, tsa Jesús, “Cristo” qquen que su'cho, tsa tsu jipa a'ima feti'je. Nane poiyi'cco tsu tisenga bo'fa. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Qquen susi Juanjan su: —Chiga Quitsa anttembian'da ¿ma'caen tsu a'ija osha'faya? ");
INSERT INTO conNTpo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Que'i'qque ña qquen su'choma pañamba qui in'jan'fa: “Cristombi gi. Tsa'ma tisema o'tie jiye moen'cho gi.” ");
INSERT INTO conNTpo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Casara'ta tsa'nduyi tsu pushema pushe. Shondo'su Quitsaja tsa'ndu afasi pañamba avuja. Ña'qque tsa'caen gi ja'ño avujatssi. ");
INSERT INTO conNTpo_vpl VALUES ("JN3_30","073_3_30","JHN","