﻿USE sofia;
DROP TABLE IF EXISTS sofia.cofNT_vpl;
CREATE TABLE cofNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cofNT_vpl WRITE;
INSERT INTO cofNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucrístori matu to miya Davichi alica jominue. Daviri matu to Abrahanchi alica jominue. Junni in pilabi casale casaleri Jesucrístochi matu tatalachi mumunca jera pila chutechinayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aman Abrahanchi nao Isaac jominue. Junsi Isaachi nao Jacobo jominue. Junsi Jacóbochi nalala Judabe yachi acolabe jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Junsi Judachi naola Fárebe Zárabe jominlanue. Aman yalachi ayanni Tamar jominue. Junsi Fárechi nao Esrom, Esronchi nao Aram, ");
INSERT INTO cofNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aranchi nao Aminadab, Aminadachi nao Naasón, Naasonchi nao Salmón, ");
INSERT INTO cofNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonchi nao Booz jominue. Aman Boochi ayanni Rahab jominue. Junsi Boochi nao Obed jominue. Aman Obechi ayanni Rut jominue. Junsi Obechi nao Isaí jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Junni miya Daviri Isaíchi nao jominue. Junsi Davichi nao Salomón jominue. Aman Salomonchi ayanni casale Uríachi sona jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Junsi Salomonchi nao Roboam jominue. Junsi junte nechi Roboanchi nao Abías, Abíachi nao Asa, ");
INSERT INTO cofNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asachi nao Josafat, Josafachi nao Joram, Joranchi nao Uzías, ");
INSERT INTO cofNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíachi nao Jotam, Jotanchi nao Acaz, Acachi nao Ezequías, ");
INSERT INTO cofNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíachi nao Manasés, Manasechi nao Amón, Amonchi nao Josías jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Junsi Josíachi naola Jeconíabe yachi acolabe jominlanue. Yala sonnalarasanan, uyan tobi chuminlari israelítalaca tanjilainue Babilonia tinun bare to fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Junni Babilonia toca jilaitobi, junsi Jeconíachi nao Salatiel nainue. Junte nechi Salatiélichi nao Zorobabel, ");
INSERT INTO cofNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabélichi nao Abiud, Abiuchi nao Eliaquim, Eliaquinchi nao Azor, ");
INSERT INTO cofNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azórichi nao Sadoc, Sadochi nao Aquim, Aquinchi nao Eliud, ");
INSERT INTO cofNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuchi nao Eleazar, Eleazárichi nao Matán, Matanchi nao Jacobo jominlanue. Junsi Jacóbochi nao José jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aman Joseri Maríachi unila jominue. María mantimini Jesuchi ayan jominue. Ya Jesuca Cristo tinun joe. ");
INSERT INTO cofNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsanque Abrahánchibi nechi chunca junpalu bolon polecabi David nainue. Junsi Davíchibi nechi chunca junpalu bolon polecabi Jeconías nainue. Junnasa israelítalaca Babilonia toca tanjilainue. Junsi Jeconíachibi nechi chunca junpalu bolon polecabi Cristo nainue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucrístori itsanque nainue. Casaleri María tinun sona Josebe casalaino jominue. Junni Joseri yaca cacatusanan, yari napun jominue. Diosichi Tenca yaca na wisa carica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Junni Joseri yabe casalaino jominnan ya na poeque meránue. Junto sen tsachi joto, tsachilachi cale Maríaca purano muquetue tinue. Yaca nosa puranae tinue yape luitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Junni Joseri junca tenca canasanan, Miya Diosichi anjeliri yachi quipibi quiraito itsantinue: —José, miya Davichi alica, nu Maríabe casalainoca natiya luratuna! tinue. Yachi nari tsachi unilachi na itoe tinue. Diosichi Tenca patsa yaca na wisa carinue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Junni Maríari unila na quichunae tinue. Ya na uwaitobi yachi tsachilaca se larichunae tinue yape jutsabe casticailaitusa. Jun tenchi ya náca JESUS mumun pona! tinue. Anjeli Josebe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Aman matu mate Miya Diosichi mantate pamin tsachiri ya náca itsanque pila chuteca jominue: Unila caquituca sonari na wito unila na quichunaeque chuteca jominue. Junsi ya náca Emanuel tinun jochunaeque chuteca jominue. Aman ya matu fiquichi pato “Diosi chiquilabe pejoe” tito “emanuel” tinun joe. Junni Jesuca matu mate tsan jochunae tica josanan, jun tsanquenan patinue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Junni Josechi quipinunsiri mansonhito, Miya Diosichi anjelichi fiquica obedeseito Maríaca caniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Junto María jun na quino fecári Maríabe Josebe pecatsotulajonue. Aman jun na quinunbi yaca JESUS mumun polaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Junni aman Jesús Belén tinun pueblobi nainue Judea tobi. Herodes jun tobi miya josanan nainue. Junni nainunbi, mácola fechi nechi jalainue. Bare tobi nechi jato israelítalachi fe wa puebloca jalainue Jerusalén puebloca. Junni Jerusalenbi féto ");
INSERT INTO cofNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","itsanlatinue: —Fechi tobi chuto uyan quiran tsaboca quiralaquiyoe tilatinue. Junni jun tsaboca quirato, in tobi na manca nainueque miilaiyoe. Ya nari israelítalachi miya jono joe latinue. Junni junca miito ya náca se tibi jalainayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aman junni Herodes tinun miyari yalachi fiquica meráto, duque wepananue. Jerale Jerusalenbi chuminlanan wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Junto Herodes mantá tan israelítalaca jera layaisa carinue. Yala mantaminla weyanlari mantá tan patelela jominlanue; weyanla israelítala tala mantaca micarimin jominlanue. Junni yalaca layaisa caritobi, miya ino jun náca yalabe panhato itsantinue: —¿Ya Cristo tinun miya tile naino jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Junni israelita mantaminlanan itsanlatinue: —In tobinan naino joe latinue Belén pueblobi. Meráde! Matute Diosichi mantate pamin tsachi itsanque pila chuteca joe tilatinue: ");
INSERT INTO cofNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea tobi pueblo mancaca pachinayoeque chuteca joe Belén tinun puebloca. Jun pueblori epe pueblo natiya itoeque chuteca joe. Jun pueblobiri miya naichunaeque chuteca joe. Ya miyari Diosichi israelita tsachilaca jera mantamin jochunaeque chuteca joe. Diosichi mantate pamin tsachiri Crístoca tsanque pila chuteca joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Junni Heróderi jun fiquica meráto, mácolaca nosa jasa carito, yalabe sele panhato itsantinue: —¿Nulari ya tsaboca numasi quiralaquiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Junni junca miisi yalaca Belén puebloca erenue. Junchi jito jeralete neyade! tito erenue. Náca fetobi, inchi manjato, labenan cuenta manquina! tinue lanan yachi cale telenhibi jichun. ");
INSERT INTO cofNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Junni miya tsantinunca meráto, mácolari Belenca jilainue. Aman fechi tobi casale quiranun tsabo yalachi cale jinaminue. Junni ya tsabo miya ino jun na tsonunte chudinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Junto mácolari tsaboca manquirato duque son tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Junsi yabi tamochi wito, nabe yachi ayan Maríabeca quiralaquinue. Junni náca quirato, yachi cale telenhito se tito, ticatiya epe cuwalaquinue. Orobe, insiensobe, mira tinun puban pibe, jera cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Junni ya nachi tsanque cuwanunsi, Diosi yalabe quipibi panue Heródechise natiya manjilaitunaque. Junca meráto yalachi toca manjinato uyanse manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Junni yala manjilainunbi, Miya Diosichi anjeli Josebe quipibi manan manpato itsantinue: —Cupade! tinue. Nabe ayanbeca cato, Egipto toca sutanjide! tinue. Junbi chularana! tinue la manan manpano fecári. Heróderi in náca neyachinae tinue totechun. ");
INSERT INTO cofNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Junni quipibi tsanque merasi, quepen cajosanan cupato nabe ayanbeca tanjito polenue Egipto toca. ");
INSERT INTO cofNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Junni Egipto tobi chularaminue Herodes puyano fecári. Aman matute Diosichi mantate pamin tsachi junca itsanque pila chuteca jominue: Diosi yachi Naoca Egipto tobi nechi manjasa tieque chuteca jominue. Junni matute tsantica josanan, jun tsanquenan patinue Egipto tobi chuminnan manjacalaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Junni aman Herodes mantimini inale tenhinue mácola yaca encanato manjilainueque. Junca miito jelecari painue. Junto paito, soldadolaca erenue yape unila nalalaca jera totelaquisa. Belén pueblobinan, Belén pueblo quelotenan unila nalalaca jera totelaquinue. Aman casale mácolabe miica jominue numasi tsaboca quiraca jonunca. Junto palu wata tan fecári jerale nalalaca totesa mantanue yape miya ino jun nanan junte pepuyasa. ");
INSERT INTO cofNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Aman matute Jeremíari Diosichi mantate pamin joto, junca pila chuteca jominue. Manca Belén quelole puebloca pato itsantinue: Ramá tinun pueblobi warenanunca meralaquichunaeque chuteca joe. Atito warelaquichunae. Junbi chumin sonalari naola tenchi warelaquichunaeque chuteca joe. Naolaca toteca jonan, pansi manhituanae latichunaeque chuteca joe. Junni Jeremías matute tsantica josanan, Herodes nalalaca totesa carinan, jun tsanquenan patinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Junni Josélari Egipto tobi chusanan Herodes puyanue. Aman ya puyanunbi, Miya Diosichi anjeli Josebe quipibi cuenta manquito ");
INSERT INTO cofNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","itsantinue: —Náca totechi timinlari numa puyaca jolajoe tinue. Junni nuri cupato, nabe yachi ayanbeca mancato, israelítalachi toca mantanjide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Junni Joseri cupato, nácanan nachi ayancanan israelítalachi toca mantanjinue. ");
INSERT INTO cofNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tsan josanan miya Herodes puyanunbi, yachi nao Arquelao, yaman israelítalachi tobi miya inue. Junni Joseri junca miito Judea to patsaca manjino jele tinue. Junni quipibi anjeli yabe manan manpanue yape jun tobi chutusa. Junni anjeli pacaca meráto, Judea tobi chuditunue. Galilea tobi chubi jilainue ");
INSERT INTO cofNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasaret tinun pueblobi. Aman matu tote Diosichi mantate pamin tsachiri Jesuca pila chuteto, yaca nasareno tinun jochunaeque pila chutenue. Junni Josélari Nasarebi chusanan jun tsanquenan patinue; Jesuca nasareno tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","3","Aman matu mate manca Diosichi mantate pamin tsachi jominue Isaías mumun. Yari itsanque pila chuteca jominue: Tsachi manca niyanlanantiya chutunun postote sonba pato, tsachilaca itsanque payichunaeque chuteca jominue: Miya jano jonun tenchi jera manseilainade! tichunae tinue. Miya jano jonun tenchi minuca mansenun cuwenta, jun tsanquenan nulachi tencabinan manseilainade! tichunae tinue. Isaías tsanque pila chuteca jominue. Junni Jesús Galilea tobi chusanan, tsachi manca jun tsanhinue Mumunmin Juan tinun. Judea tobi niyanlanantiya chutunun postote chubi jica jominue. Junni junbinan tsachila merábi janaminlaca payinaminue. Junni Juan payinato itsantinue: —Moora jamochi chumin Diosiri ya mantananun tsachi bolon suwachinae tinue. Jun tenchi jutsa quinunca telaquepoto casan tala tenca mancalaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aman Juanchi camisa cameyochi fuca quica jun joto, natiya mica iton camisa jominue. Junsi quidoca sendori quica jun jominue. Finun isube, jelen china pibe, ano fimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Junni Judea tobi chuminlari yaca jera merábi jimin jominlanue. Jerusalenbi nechi, weyanla Jordán pi quelole nechinan jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Junni jutsa quimin joyoe timinlaca Juan Jordán pibi mumunnue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Junni aman Juan mumunnasanan, fariséolabe saduséolabe yachica jalainue. Aman man bolon israelítalari man quiraque Diosica tenca camin jominlaca fariseo tinun jominlanue. Man bolon mantimini man quiraque Diosica tenca camin jominlaca saduseo tinun jominlanue. Junni Juanni duque fariséolabe saduséolabe jalainaminca quirato, itsantinue: —Nulari seiton pini cuwenta jolajoe. ¿Nulari niya jonan tenfelainayun casticaquino mate casticaituchique? ¿Mo nulaca tsanhisa micarin? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Junni nulachi mumunhino muquilaquinari, casale nulachi jutsaca jera telaquepolaquina! Junsi seque nenalarana! yape nulachi jutsaca tsa telaquepocala joeque quereintsan josa. ");
INSERT INTO cofNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Junni nulari matu to Abrahanca tennatuntsan joe. Yari Diosichi tsachi jominue. Junni nulanan yachi alicala jonun tenchi Diosichi tsachila jolajoyoeque tenca calaquichunae. Te, tsanque tenca calaquituna! tinue. Diosi nulaca jera telaquepoto, in sucatiya Abrahanchi alica suwano podeichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tsachila chide pele cuwenta jolajochunae tinue. Toleno ma feca joe. Junni sen puca itumin peleca toleto, ninbi quepochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Junni Juan tsantitobi, aman tsachilabe itsantinue: —Nula jutsa quinunca telaquepoto casan tala tenca mancaminlaca la mumunmin joyoe tinue. Juntonan lari pibiri mumunnayoe. Junni laca benechi manca tsachi jachunae. Laca fécari mantá tan jochunae tinue. Yari tsaracari sen jonan, lari yachi sapatocari leyanto tanjito cuwanotiya sen itoyoe tinue seri sen jotonan. Yari wari pibiri mumuntumin jochunae. Yari Diosichi Tencachi mumunmin jochunae tinue ninchi casimin cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Junni tsachilari trico ni petse pun cuwenta jolajochunae tinue. Junni ya sen tsachi trico petse cuwenta jominlaca jera larito quepochunae. Numa pepe cato rae petse larichun. Junto sen trico nica dunun yaca tanjito sechunae tinue. Petsecari jeraitumin ninbi quepochunae tinue. Juan tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Junni Jesuri Galilea tobi nechi Jordán pica janue yape Juan yaca mumunsa. ");
INSERT INTO cofNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan mantimini yaca mumuntuchi tito itsantinue: —¿Niyaito labe mumunhino muquin? tinue. La nuberi mumunhino joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Junni Jesuri beco tulanto itsantinue: —Diosi mantanue tsachila mumunhilaisa. Junni lacanan mumunniquede! tinue. Jesús tsantinan, Juan yaca mumunniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Junni Jesús mumunhitobi, pibi nechi manlonasanan yoquido lasainue. Junni Diosichi Tenca palomanan quiran ito patanaminca quiranue. Yachi jamo patanunsi, ");
INSERT INTO cofNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","jamochi nechi fiqui mera jominue. Itsantinue: —In lachi duque munatinun Naoe tinue. Ya tenchi duque son joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Junsi aman Diosichi Tenca Jesuca niyanlanantiya chutunun postoca erenue yape yucan yaca jutsa quisa carichique tenfesa. ");
INSERT INTO cofNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Casale junpalu chunca ma fecári malon, quepen ano fitunca ito chuminue. Junpalu chunca ma chusa, ano duque muquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Junni yucan yaca seiton quisa carichi tide janue. Junni yucan yabe itsantinue: —Nuri Diosichi Nao jotori, in suca bibu suwade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Junni Jesuri itsantinue: —Te. Diosichi Pilabi itsanque chuteca joe tinue: Tsachila anobesiri sonnano itolajoyoeque chuteca joe tinue. Jera Diosi paca fiquicanan meráto sonnanola joyoeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jesús tsantinunbi, yucanni yaca Jerusalén puebloca tanjinue ya Diosichi pueblo tinunca. Junni yucan Jesuca Diosichi ya butuchi wirucarito ");
INSERT INTO cofNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","itsantinue: —Nu Diosichi Nao jotori, inte nechi supatiniide! tinue yape tsachila wepanato quiralaquisa. Diosichi Pilabi itsanque chuteca joe tinue: Anjelilaca erechunae yape cuidailaisa. Nuca amanle canilaquichunaeque chuteca joe tinue yape nuchi nede subi icatusa. ");
INSERT INTO cofNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Junni Jesunan itsantinue: —Man fiquinan cachuteca joe tinue. La seiton quinasatiya Diosi laca cuidainiichunae tilatitunaque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Junni Jesuca mantanjito, duque wa du puntabi wirucarinue. Junbi wirucarito, piyanle toca quirawonue. To cura miyala duque mantá tan jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Juncanan Jesuca quirawoto itsantinue: —Lachi cale telenhito, laca se tide! Tsanquinari jerale toca mantasa cariyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Junni yucan tsantinunsi, Jesunan itsantinue: —Satanás, jachi we manjide! Diosichi Pilabi itsanquenan chuteca joe tinue: Miya Diosichi calesiri telenhintsan joeque, yabesiri mantaino joeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesús tsantinunsi yucan numa manjiniinue. Junni aman anjelilari jato, yachi ticatiya munaranunca cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Junni aman Mumunmin Juan doinue. Jesuri junca miisi, Galilea toca manjinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Juntonan Nazaret puebloca chubi manjituto, Capernaum puebloca chubi jinue Galilea wa pipilu fiquile. Aman matu tote Galilea toca uyan mumun to timin jominlanue. Man pequelo Zabulónlachi to jominue; man pequelo Neftalílachi to jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Junni matu tote Diosichi mantate pamin tsachi, Isaías tinun, jun toca itsanque pila chuteca jominue: Zabulón to, Neftalí to, wa pipilu quelote joeque chuteca jominue. Galilea tobi joe Jordán pi becochi. Junbi israelita itonlachi to jominue. Junni jun tobi chuminlachi tenca nemente chularasanan, tsaracari tseichunaeque chuteca jominue. Nemenbi cuwenta padeseito chularasanan, jera tseichunaeque chuteca jominue. Junni Jesús jun tobi micarito chubi jinan, Isaíachi fiqui tsarasica patinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Junni aman Jesuri Capernaum pueblobi chubi jitobi, micarinaminue. Micarinato, itsantinue: —Moora jamochi chumin Diosi ya mantananun tsachi bolon suwachinae tinue. Jun tenchi nulari jutsa quinanunca telaquepoto casan tala tenca mancalaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Junni Jesuri Galilea wa pipilu quelote nenato, paluca acolaca quiranue. Manca Simón jominue. Tensaato mumun Pedro tinun jominue. Aman manca yachi aco Andrés jominue. Yalari watsa caminla joto, atarayaca pibi queponaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Junni Jesuri yalaca quirato, itsantinue: —Labe penenalarana! Lari nulaca watsa canique cuwenta, tsachilaca layato labe cayaisa carimin suwanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jesús tsantinunsi, yalari atarayaca jera tsoreto, Jesube penenabi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Junni Jesús junte nechi jinaminnan, man paluca acolacaman quiranue Jacobo manca, Juan manca. Yalachi apa Zebedéobe canoabi chuto, ataraya mansenaminlanue. Junni Jesuri ya acolacanan oticanue yape yabe penenamin ilaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yaca merasi, apaca canoabi purato, Jesube penenabi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Junni aman Jesuri jerale Galilea tobi nenaminhe. Diosichi fiqui miinun yabi Diosichi sen fiquica micaride nenaminhe Diosi ya mantananun tsachi bolon suwano joeque. Jerale quiyanpunlacanan manse suwanaminhe. ");
INSERT INTO cofNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tsannasanan Siria tinun bare tobinan tsachila jera meralaquinue ya tsantin nenaminca. Yaca miito, tsachilari quiyanpunlacanan, fudan junlacanan, yucanchi ocobe padeseiminlacanan, jancanlacanan, ataque iminlacanan, jera Jesúchica tanjalainan, yalaca manse suwae. ");
INSERT INTO cofNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Junni duque tsachila Galilea tobi nechi, Decápolis tobi nechi, Jordán pi man becochi nechi jato, yalari Jesube penenamin ilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Junni Jesús jun layan tsachilaca quirato, dubi loto chudie. Junni yabe penenaminlanan pelolaiyoe yape chiquilaca micarisa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Junni micarinato itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Diosi ayudaitunari podeitiyoeque tenhiminlari duque son tinola joe tie. Nula tsanque tenhiminla Diosi mantananun tsachi bolonbi pejolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Junsi laquiiminlanan son tinola joe tie. Diosi nulaca laqui polarichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Junsi uyanlaca fe sen joyoe tituminlanan son tinola joe tie. Piyanle toca Diosi nulachi cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Junsi ano, pi muquinun tsansi seque nenachi timinlanan son tinola joe tie. Diosi nulacari ayudaichunae tie seque nenalarasa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Junsi laqui timinlanan son tinola joe tie. Diosi nulacanan laqui tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Junsi sen tenca tanlanan son tinola joe tie. Nulari Diosica quiralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Junsi pa jominlaca manse patariminlanan son tinola joe tie. Diosi nulaca pato, lachi nalala jolajoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Junsi seque nenanun tenchi padeseiminlanan son tinola joe tie. Nula Diosi mantananun tsachi bolonbi pejolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Junni tsachilari nulaca pansile yucacurato seitonque nene pato, nulabe seiton jolajochunae tie lachi tsachila jonun tenchi. Nulari tsanque padeseilainatori, son tinola joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsanque padeseilainari, Diosi jamochi nulachi tsaracari senca cuwachunae tie. Junni pansi joto duque son tilatina! Matu tote Diosichi mantate paminlacanan jun tsanquenan padeseisa carilaquinue tie. Junni nulari in tote yala cuwenta padeseilainatori, son tilatina! Jesuri tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Junni Jesús junbi camicarinato itsantie: —Nulari jerale Diosica tennatumin tsachilabe sen joto quirawonola joe. Tsan joto, pinba cuwenta jolajochunae tie. Junni sen pinba jolajona! Pinba sen jomin epeban inari, niyan quinatotiya saruba mansuwano podeilaituchunae. Epe jochunae. Minubi quepontsan jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Junni nula Diosica tennatuminlachile nenato, tseno cuwentanan jolajoe tie. Jana dubi chumin puebloca tsacarino podeituntsan jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","O lanparinca tulitori, perolichi dilancaritunomanhe; jamobi chutenomanhe yape tamochi jerale chuminlachi tsesa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Junni nulanan jun tseno cuwenta sen jonola jochunae tie yape uyanla nulaca quirato nulachi Apa Diosica duque sen joe tilatisa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Junni Jesuri man fiquicaman micarinato itsantie: —Matu to Diosichi mantate paminlacanan, matu to Moisécanan, tenca calaquede! Yalachi fiquica telaqueposa caribi jatucayoe; yalachi fiquica nanni fe tuca micaribiri jacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nulabe tsarasica pachinayoe: Diosichi mantá pilari natiya epe ituchunae tie. Jeranan tsa patichunae tie. Yoquidobe tobe jeraino fecári Diosichi mantári natiya epe ituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Diosichi mantá manca nacacatiya telaquepotuntsan jochunae. Jun mantaca merátuto, epe mantá joe tilatinari, junni tsantiminlacanan epe tsachila jolajoe tintsan jochunae. Yala Diosi mantananun bolon tsachila tala fécari epe jolajochunae. Junni Diosichi jera mantaca meráto, merántsan joeque micarilaquinari, junni tsantiminlaca sen tsachila jolajoe tilatichunae. Yala Diosi mantananun bolon tsachila tala fe tsachila jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Meralaquinade! Aman israelítala tala mantaca micariminlaca tenca calaquede! Nulari yalaca fe sen jonola jochunae. Fariseo tinunlacanan fe sen jonola jochunae. Yalaca fécari Diosichi mantaca merátutori, Diosi mantananun tsachi bolonbi numanan wino podeilaituchunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Junni Jesús camicarinato itsantie: —¿Matu to tsachilabe itsantica jominuco? Tsachilaca totetulajona! tica jominue tie. Toteminlaca juisio quito casticaquintsan joe tica jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Junni matu tote tsantica josanan, Jesuri uyan quiraque pachinayoe tie. Paiminlanan juisioito casticailaichunae tiyoe tie. Junsi yucacuraminlanan fe mantá tanlachi cale wiruinola jochunae tie. Junsi ti quira tenca iton joe timinlari yucanchi ninbi quepoitotiya ilaichunae tiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","¿Jana nula Diosichi ticatiya epe cuwachun, Diosichi yabi wito Diosichi titiya epe cuwanun mesabi chutenola joco? Junni tencabe tsanlaquina! tiyoe tie. Pansile epe cuwachinato, manca tsachica nulaca pa joeque mantenhilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Tsanque mantenhilaitori, pa jominchica casale jinola jochunae. Cuwano jonunca Diosichi titiya epe cuwanun mesa quelole chuteto, yachica jilaina! Junni ya tsachibe jera manse patitobi, Diosichi yaca manjato, juntobi cuwano jomin jonunca cuwanilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Junni Jesús tsantitobi, man fiquinan pae: —Tsachi manca nulaca culpa quinari, nulaca culpa quiminbe wewe amico manhilaina! Comisariochica parejo jinaminnan amico manhilaina! Tsanhitunari, pansile nulaca comisariochi cuwapochunae. Junni comisariori nulaca polisialachi cuwapochunae tie yape dolaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nulabe tsarasica pachinayoe: Cala jera cacuwatuminnan, numanan manlolaituchunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Junsi Jesús itsantie: —¿Matu to tsachilabe itsantica jominuco? Uyan sonalabe o uyan unilalabe nosa seitonque nenatulajona! tica jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Junni matu tote tsantica josanan, Jesuri uyan quiraque pachinayoe tie. Uyan sonalaca munaito cacachi quiratonan, nulachi tencabi leyan sona tanun cuwenta jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Junto nulachi tsa nanchi cacachi seitonque tenca cato quiratori, ya cacaca larito quepolaquina! Cacaca larito quepono seitosanan, cacachi seiton quinun tenchi yucanchi ninbi quepoinari, cacaca larito quepocaca nantanan fécari seitochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Junsi nulachi tsa tedechinan jutsa quiniquitori, tedeca poreto quepolaquina! Yanan seiton josanan, tedechi seiton quinun tenchi yucanchi ninbi quepoinari, nantanan fécari seitochunae tie. Jesuri tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Junni Jesuri camicarinato itsantie: —Matu tote in fiquicanan micarica jominue: Sonalaca puratori, diborsio pila yalachi cuwanola joe tica jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tsantica josanan Jesuri uyan quiraque pachinayoe tie: Uyan unilalabe nenatunari, sonalaca natiya puratuntsan joe tiyoe tie. Sonalaca tenca mántanan puranatori, yalaca uyanlachi leyan sonala isa carilaquichunae tie. Tsanquenan puraca jun sonalaca calaquinari, leyan sonalaca canun cuwenta jochunae tie. Jesús tsanque pae. ");
INSERT INTO cofNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Junsi Jesuri itsanquenan micarie: —¿Matu to tsachilabe in fiquicanan paca jominuco? Diosi mirasa juraquito pánayoe titori, nene patuntsan joe tica jominue tie. Diosi quiranasa ticatiya queyanae titori, quinola joe tica jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Junni matu tote tsantica josanan, Jesuri uyan quiraque pachinayoe tie. Diosi mirasa juraquito pánayoe natiya titulajona! tie. Aman Diosi jamochi chue. Jun tenchi jamochi chuminni mirasa pánayoenan tituntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Junsi aman tonan Diosichi joe. Jun tenchi to quiminni mirasa pánayoenan tituntsan joe. Junsi aman Jerusalén pueblo Miya Diosichi pueblo joe. Jun tenchi Jerusalén pueblo Miya mirasa pánayoenan tituntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Weyanla mantimini itsantiminlae tie: Nene panari lachi misu yucapiyachunae timinlae. Te, tsantituntsan joe. Nula nin paba a silinca fiba a silinan mansuwanotiya podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Junni tsarasi jonunca pánatori, “jaansiri” tilatina! O nene jonari “tesiri” tilatina! tie. Fécari paminlari yucan mantanasa palaquinachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Junni Jesuri in fiquicaman micarie: —¿Matu to tsachilabe itsantica jominuco? Quicaato, uyanlachi cacaca yucapiyariminlachi cacacanan manyucapiyarinola jochunae tica jominue tie. O quicaato, tefunca baleminlachi tefuncanan manbalenola jochunae tica jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Junni matu tote tsantica josanan, Jesuri uyan quiraque pachinayoe tie: Nulaca seiton quimin tsachilaca beconan seiton quitulajona! tie. Caforobi tsa nanchi quinari, man nanchinan quirawolaquina! yape man nanchinan quiniquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Junsi nulaca juisio quinato, nulachi sacoca josolechi latinari, sacocanan camisacanan cuwanilaquina! ");
INSERT INTO cofNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Junsi romano soldadola nulaca yalachi cosalaca man quilon fecári panása mantalaquinari, palu quilon fecári pananilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Panhaminlachi cuwalaquina! Faricarisa timinlabe faricarituchi titulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","¿Junni matu to tsachilabe itsantica jominuco? Quiranunlaca laquiralarana! tica jominue tie. Pa iminlacari pa jolajona! tica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Junni matu tote tsantica josanan, Jesús uyan quiraque pachinayoe tie: Nulaca paiminlacanan laquiralarana! tie. Nulaca yucaquiminlachi tenchinan Diosibe rocailaina! Nulaca pa jominlabe sen jolajona! Nulaca seiton quiminlachi tenchi Diosibe rocailaina! tie. Nulaca Diosichi tsachila jonun tenchi seiton quilaquinari, yalachi tenchinan Diosibe rocailaina! ");
INSERT INTO cofNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsanlaquitori nula Diosichi nalala jolajochunae tie. Nulachi Apa Diosiri jeralelabe sen joe. Yari jamochi chuto, senlachi tenchinan, seitonlachi tenchinan, pata quisa carimin joe. Seque nenaminlachi tenchinan, seitonque nenaminlachi tenchinan suwa quisa carimin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Junni nulaca laquiraminlacasiri laquiralaratori, seque laquiramin itolajochunae tie. Uyanla cuwentari jonilajochunae. Uyan to miyachi tenchi inpuesto cala caminlanantiya seitonla jotonan tsanque laquiraminlae. Junni nulanan nulaca laquiraminlacasiri laquiralaranari, Diosiri nulaca seitonla joe tito nulachi premio natiya cuwatuchunae. ");
INSERT INTO cofNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Junni nulachi bolon talasiri saludailaitori, sen patsa itolajochunae. Uyanla cuwentari jonilajochunae. Diosica tennatuminlanan jun tsanquenan yalachi bolon tala saludaicaaminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nula mantimini yalaca fe sen jonola joe. Jamochi chumin Diosi nulachi Apa jonan, ya cuwenta sen patsa jonola joe tie. Jesús tsachilaca tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Junni Jesuri camicarinato itsanque micarie: —Weyan tsachilari titiya seque quinatori, uyanla quirasari quiminla joe yape sen jolajoe tilatisa. Junni nulachi Apa Diosi mantimini nulachi premio tsanca natiya cuwatuchunae tsanque jamoleri seque quiminla jonun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tencachique fe sen joyoe timinlari lemosi cala cuwachun, tutu quiminca yalachi caque ereminla joe. Junni tutu quiminca meráto, jeralela miiminla joe lemosi cala cuwaminla jalainaeque. Yalari Diosichi fiqui miinun yabinan, urachinan nenato, tutu quiminca caque ereminlae yape uyanlari yalaca sen jolajoe tilatisa. Junni sen jolajoe tinaminlaca meráchiqueri tsanquiminla joe. Junni yalari senla joe tinanunca meránunberi polelaichunae. Yala cachi tinun premioca numa cayala jonan, Diosi yalachi nantari cuwatuchunae tie. Nula mantimini yala cuwenta itolajona! ");
INSERT INTO cofNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nulari lemosi cala cuwanatori, nosale cuwanola joe ");
INSERT INTO cofNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","yape monantiya miilaitusa lemosi cala cuwaminla joeque. Tsanlaquinari nulachi Apa Diosiri jera nosa jomincanan quiramin joto, nulachi premio tsanca jeralela quiralaquinasanan cuwaniquichunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Junsi Jesuri itsanque micarie: —Tencachique fe sen joyoe timinlari tsachila quiralaquisari Diosibe rocaiminla joe. Diosichi fiqui miinun yabi, o cayete tiletiya Diosibe rocainiiminlae yape jeralela yalaca quirato sen jolajoe tilatisa. Meralaquinade! Yalari sen jolajoe tinaminlaca meráchique tsantiminla joe. Junni yalari senla joe tinanunca meránunberi polelaichunae. Yala cachi tinun premioca numa cayala jonan, Diosi yalachi nantari cuwatuchunae. Nula mantimini yala cuwenta itolajona! ");
INSERT INTO cofNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nula Diosibe rocainatori, tamochi wito tamolan donola joe. Junbi nosale Diosibe rocainola joe. Tsanquinari nulachi Apa Diosiri jera nosa jonuncanan quiramin joto, premio tsanca jeralela quiralaquinasanan cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Diosica tennatuminla Diosibe rocainato, epenan duque baren fiqui rocaiminla joe tie. Fe baren fiqui rocainaminca Diosi fe meráchunae timinla joe tie. Nula mantimini yala cuwenta itolajona! Apa Diosibe carocailaitusanan, yari numa mirae tica munaralaranunca. ");
INSERT INTO cofNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Junni itsanque rocainola jochunae tie: Chiquilachi Apa Diosi, nu jamochi chue. Nuchi mumunca duque respetaino jolajoyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu mantananun tsachi bolonca duque serawode! Jamochi nuchi tenca munate quinanun tsannan, in totenan jun tsannan quino muquilaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amanari chiquilachi ano cuwade! ");
INSERT INTO cofNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Junni chiquilaca jerale seiton quiminlaca perdonaica jonan, nunan chiquilaca perdonaide! ");
INSERT INTO cofNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yucanbe encanaisa caritude! Chiquilaca se laride! yape yucan chiquilaca fe lotusa. Nusiri Miya joe; nusiri tsara poden joe; nusiri tsara sen mantá tae. Amen ");
INSERT INTO cofNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesús tsanque Diosibe rocaino joeque micaritobi itsantie: —Nula uyanlaca perdonailainari, nulachi Apa Diosinan nulacanan perdonaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nula mantimini uyanlaca perdonailaitunari, nulachi Apa Diosinan nulacanan perdonaituchunae tie. Jesús tsantie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Junsi Jesús camicarinato itsantie: —Fe sen joyoe timinlari Diosichi tenchi ano fitunca itori, epenan tsanhiminla joe. Yalachi caforo duque laquinan quiran iminlae yape uyanlari yalaca quirato miilaisa ano fitunca ilainaeque. Tsanhiminlari Diosichi tenchi tsanhituminlae. Tsachila quirasari tsanhiminlae yape yalaca quirato sen jolajoe tilatisa. Meralaquede! Yalari sen jolajoe tinaminlaca meráchique tsanhiminla joe. Junni sen jolajoe tinanunca meránunberi polelaichunae. Yala cachi tinun premioca numa cayala jonan, Diosi yalachi nantari cuwatuchunae tie. Nula mantimini yala cuwenta itolajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nulari Diosichi tenchi ano fitunca itori, caforo tsalen, paran quin, quilaquina! ");
INSERT INTO cofNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsanlaquinari uyanla miitolajochunae ano fitunca ilainaeque. Nulachi Apa Diosiri mirachunae. Ya jera nosa ranuncanan quiramin joto, premio tsanca cuwachunae tie. Jesús micarinato tsantie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Junsi Jesús itsanque micarie: In tote duque tan tsachi ichique cala, panu, ti sencatiya munaito quiralaquituna! Epe jochunae. Inte tanunca julu finiquichunae; titiya jeroca quica jotori warechunae; tarinminla sonbaito wito tarinlaquichunae. Te, in tobi duque tan tsachila itoto ");
INSERT INTO cofNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","jamochi duque tan inola joe. Jamochi seto tanunca julu fituchunae; tinantiya waretuchunae; tarinminla tarinlaquituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nulachi senca man postobi tatori, jun postoca tenca caminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jun tenchi calaca, jera ticatiya quiracaca munaito quiratuntsan joe. Meralaquinade! Nulachi caca tseno cuwenta jochunae. Junto cacachi tencabe quiralaquina! tie. Diosica tenca cato laquirato quiralaquitori, seque nenano podeilaichunae seque quiramin cuwenta. Manan cala ticatiya munaito quiranatori, natiya seque nenano podeilaituchunae. Tseno piyacabe nemente nenamin cuwenta jolajochunae duque nemente nenato. ");
INSERT INTO cofNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","O patronlabe mantainunca tenca calaquede! Calaca munaito quiratori paluca patronlabe mantainun cuwenta jochunae. Junni monantiya paluca patronlabenan mantaino podeilaituchunae. Mancacari seiton joe tito uyanca sen joe tichunae tie. O mancaca merátuto, mancaca meráchunae tie. Junni jun tsanquenan Diosica tenca camin jotori, calaca munaito quiratuntsan jochunae. Calaca munaito quiranatori, Diosica seque tennano numanan podeilaituchunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Junto Jesús man fiquiman itsanque micarie: —Jun tenchi nulaca itsanque payichinayoe tie: Wepanalaituna! tie. Finoca, o cuchinoca, o panuca niyaque cano jonunca natiya wepanalaituna! tie. Niyaque sonnano jonunca tenca canato, anocari tenca canola itochunae tie. O panube seito nenanocari, tenca cato nenatuntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jana pichuca quirato tenca calaquede! tie. Waquetumin joe; setumin joe; dunun yabi dutumin joe tie. Tsan josanan nulachi Apa Diosiri yalachi finoca cuwaniquimin joe tie. Nulaca mantimini pichulaca fécari laquirato cuidaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Wepanacachinan quitsa metro fe uwaino podeinola jochun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Junsi panucanan natiya wepanatuntsan joe. Lulica tenca calaquede! tie. Yanan seque uwaimin joe. Trabajaquitumin joe; sita quitumin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsan jotonan duque uraran joe. Matu to miya Salomón tsara moso panube seitonan, luli tsansi moso itominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lapanan moora yucapiyamin joe tie. Amana moso jominnan nanni ina jequeito ninbi niyamanhe. Junni lapari moora yucapiyamin josanan, Diosi yaca duque moso suwamin joe tie luli isa carito. Junni Diosi epe lapacanan moso suwamin jotori, nulachi sen panucanan cuwachunae tie. Junni aman nulari duque moso jochique wepanalainato, Diosica tennatuchi timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Junni nula ticatiya munaranunca itotori, wepanalaituna! O finoca, o cuchinoca, o panuca ¿Niyaito canan? titulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diosica tennatuminlari junca cachique wepanaminla joe tie. Nulari tsantitulajona! tie. Jamochi chumin Diosi nulachi Apa joto nulaca cuidaimin joe. Nula ticatiya jera munaranunca ya mirae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Junni Diosi mantananun tsachi bolonbi pewito nenachun tenfelaina! tie. Diosichi mantaca meráto nenachunnan tenfelaina! tie. Tsanque tenca cato nenanari, nula jera munaranunca Diosi cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nula ma cura ticatiya tenfeto quinola jochunae. Junni ayuna ticatiya quino jonuncari ayunanan tenca cantsan jochunae; ayuna quino jonuncanan amananan wepanalaituna! tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Junsi Jesuri man fiquiman micarito itsantie: —Uyanlaca culpa quitulajona! yape Diosi nulacanan culpa quitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Itsanque jochunae: Uyanlachi niyaquetiya cuwalaquinari, Diosi nulachi jun tsanquenan mancuwachunae tie. Junto nula uyanlachi jutsaca duque jonhoe latinari, Diosi nulachi jutsacanan jun tsannan tichunae. O nasiri jonhoe latinari, Diosi nulachi jutsaca jun tsannan tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O cacabi wica jun chide petse nacaca tenca calaquede! tie. Jutsari jun chide petse nacá cuwenta jochunae tie. Junni tsanini chide petse nacaca uyanchi cacabi wicaca nula quiranilaquichunae. Juntonan tencachique cacabi fe wa chide petse pomincari natiya tennatuminla jochunae. Ya seitoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tencachique cacabi wa chide petse posanan, uyanlachi cacabi nechi tsanini chide petse nacacari larito cuwachinayoe latichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jun tsanquenan nulari uyanlaca fe seiton jotonan uyanlaca fe sen jolajoyoe timinla joe. Tsantituntsan joe. Casaleri nula tencachique wa chide petse tsan jutsaca larinola jochunae. Junsi aman seque quirano podeilaichunae tie uyanlachi na chide petse tsan jutsa tenchi payichun. ");
INSERT INTO cofNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Junsi Jesús itsantie: —Diosichi jonuncari susuchi cuwatuntsan jochunae. Susuri tenhituchunae tie sen joeque. Junni susu tenca itoto, ya cuwamincanan paito jalichi tichunae tie. Junsi cuchinan tenca iton jochunae tie. Junni cuchichi cale mica winca quepolaquinari, mica joeque tenhituto pipabi tereniquichunae tie. Aman seiton tsachilanan jun tsanquenan tenhituminla jochunae tie. Diosichi sen cosaca sen joeque tenhilaituchunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Junsi Jesús itsantie: —Nula ticatiya munaralaratori, Diosibe panhalaquina! tie. Panhalaquinari, Diosi cuwachunae tie. Junsi titiya canola jotori, neyalaquina! Neyalaquinari, Diosi fesa carichunae tie. Junsi nunchitiya winola jotori, tamolante otilatina! Otilatinari, Diosi lasichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aman jerale panhaminlari calaquichunae. Neyaminlari felaichunae. Tamolante otiminlachi tenchiri lasaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aman tsachilaca tenca calaquede! tie. Nalalari bibuca panhalaquinari, bibuca cuwalaquichunae; sucari cuwalaquituchunae. ");
INSERT INTO cofNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O watsaca panhalaquinari, watsaca cuwalaquichunae; pinica cuwalaquituchunae. ");
INSERT INTO cofNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aman tsachilari seiton tenca tanla jotonan, nalalachi senca cuwaminla joe tie. Junni nulachi Apa Diosi mantimini, sen tenca tan joto, yanan yabe panhaminlachi sencasiri cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Junni uyanla nulabe sen jolajosa tenjanari, nulanan yalabe sen jolajona! In mantaca meralaquitori, jerale Diosichi Pilabi mantaca meráminla jochunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Junsi Jesús micarinato itsantie: —Yucanchica jinun minu wa foron minu joe tie. Jun minuse jichun ayan foron tamolanse poleno joe tie. Natiya tenfe itoe. Jun tenchi duque tsachila junchi jiminla joe tie. Aman Diosibe sonnano jun minuri na foron minu joe tie. Jun minuse jichun, na foron tamolanse poleno joe tie. Tenfe joe. Jun tenchi narin tsachila jun minuse jiminla joe tie. Aman nulari jun na foron tamolanse wilaide! tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Weyan tsachila nulachica jato, Diosichi mantate micariminlayoe latichunae nene pato. Junni yalaca tencabe nenalarana! Yala fiquichiri seque paminla jotonan, tencabiri lobo cuwenta duque yucapiyariminla jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Junni nulari ya nene pato micariminlaca miino muquilaquinari, chide peleca tenca canola jochunae. Chide pelebi pucaca quirato, ti chide pele jonunca miintsan jochunae tie. Ubaca pobi itumanhe tie. O íconan caran tapebi itumanhe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yucapiyaca pelebiri seiton puca jochunae. Sen pelebiri sen puca jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yucapiyaca pelebiri sen puca ino podeituchunae. Sen pelebiri seiton puca ino podeituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aman sen puca itumin peleca toleto nin polaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Junni micariminlari chide pele cuwenta jolajochunae tie. Yala niyaque nenanunca quirato miintsan jochunae. Diosichi mantate palaquinanunca, o tencachique mantate palaquinanunca miintsan jochunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Junni Jesuri capánato itsantie: —Weyan tsachila laca Miya timinla jotonan, Diosi mantananun bolon tsachilabe peitolajochunae to yucapiyarino mate. Jamochi chumin Apa Diosichi mantaca merántsan jochunae. Lachi Diosichi mantaca meráminlasiri yachi bolonbi pejolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jun mate layanla laca pato, Miya tilatichunae. ¿Lachi mantate micarin, yucanchi ocolaca sularin, wepanato quirantsancari quin, quilaquituan? tilatichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yalari tsanlatinasanan, lari beconan pato, Lachi tsachila natiya itolajoe tiyanae tie. Yalaca seiton quiminla joe tito, Jachi jilaide! tiyanae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Junto Jesús cacuenta quinato itsantie: —La mantananunca seque meráminlari tenca tanla jochunae tie. Wa subi ya quimin tsachi cuwenta jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Junbi duque wa suwa quin, pilu fan, wu quin, quinasatiya, yucapiyatuchunae tie subi ya quica jun joto. ");
INSERT INTO cofNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Juntonan la mantananunca jamoleri meráto, seque merátuminlari tenca itonla jochunae tie. Tsalanbi ya quimin tsachi cuwenta jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Junbinan duque wa suwa quin, pilu fan, sonban wu quin, quichunae. Junnasa jun ya mantimini jera yucapiyato arajichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Junni Jesús tsanque jera micarinunbi, tsachilari yachi fiquica wepanalaie. ");
INSERT INTO cofNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús duque mantabe micarimin jominhe. Israelítala tala mantaca micariminlanan quiraque micaritumin jominhe. ");
INSERT INTO cofNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Junni aman Jesús dubi micaritobi manpatanasa, duque tsachilanan pejanaminlae. ");
INSERT INTO cofNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Junte lepra bichi chun tsachi Jesúchica jato telenhito itsantie: —Miya, laca nuchi manse suwano muquinari, manse suwano podeichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesuri junca meráto, yaca tedechi tale quito itsantie: —Munarato, nuca tsaina manse suwanayoe tie. Junni Jesús tsantinunsile, lepra bichi jera manseiniie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Junni Jesuri yaca manse suwatobi, yabe itsantie: —Meráde! Mobenantiya patuminnan patelechica jito, Diosichi ticatiya nasi epe cuwade! tie. Aman matu to Moisés Diosichi Pilabi mantaca jominue lepra bichi manseiminla Diosichi ti cuwanola jonunca. Junni Jesús yaca cuwasa mantaquee yape jeralela miralarasa ya manseica joeque. ");
INSERT INTO cofNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Junni Jesuri Capernaum puebloca jito junbi winasa, soldado capitan jae. Jasi, Jesube itsanque rocaie: ");
INSERT INTO cofNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Miya, lachi peyun lachi yabi quiyanpun tsoe tie. Duque padeseinato, wecaino podeiton tsoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Junni Jesuri manse suwabi jichinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Junni ya capitan mantimini Jesuchi fiquica meráto itsantie: —Te, jacachiri jano itoe tie. Nuri laca duque fécari sen joto, lachibi jatuntsan joe. Junchi jituminnan, inte nechinan mantaquiniquede! tie manseideque. Inte nechi quiyanpunca manseisa mantanari, manseichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jana soldadola tala mantanun cuwenta jochunae tie. Coroneli laca mantamin joe; la mantimini soldadolaca mantamin joyoe tie. Jisa mantanari, jiniiminlae; o jasa mantanari, janiiminlae; o lachi peyunlaca titiya quisa tinari, quiniquiminlae tie. Junni nunan jun tsanquenan quiyanpunca manseide! tinari, manseichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Junni capitan tsantinunca meráto, Jesuri wepanae. Wepanato meráto, jerale yabe pejaca junlabe itsantie: —Nulabe tsarasica pachinayoe tie. In capitan israelita itotonan, israelítalaca fécari Diosica tennamin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Junni aman manca mate jerale Diosichi tsachila jamochi lolaitobi, matu israelítalachi tatalabe fiestabi cuwenta ano pefilaquichunae tie Abrahanbe Isaabe Jacóbobe. Junni nula seque meralaquede! tie. In capitan, junsi duque uyan tsachilanan, israelítala itotonan, junbi jamochi pelolaichunae tie. Uyan tobi nechi, uyan tobi nechi jalaito, yalanan Diosichibi pewito, mesabi chudito ano pefilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Junni weyanlari israelítala jotonan, jamochi pelolaituchunae tie. Yalaca uyanchi nemen minu quepoilaichunae tie. Junbi padeseinato, fudachi warelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Junni Jesuri tsachilabe tsantitobi, capitanbe itsantie: —Jiniide! Nuri seque tennamin jonan, nu rocainunca meracayoe tie. Junni ya capitanchi peyunni jun óratenan manseinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Junsi Pédrochica jito, tamochi wito quiranari, Pédrochi sonachi ayan cupara tan tsonue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Junni Jesús yaca tedele taquiranasale cupara manpolenue. Junto mancupato yalachi ano manpoto cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Junni jun quebi duque tsachilaca Jesúchica tanjalaie. Yucanchi ocola yalachibi wica jominlanue. Junni Jesuri yucanchi ocolaca mantato, jera mansularie. Junsi jerale quiyanpunlacanan manse suwae. ");
INSERT INTO cofNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aman Isaías matu tote Diosichi mantate pato, Jesuca cuenta quica jominue. Chiquila quiyanpun jominca manse suwato, chiquila fuda jomincanan manse suwamin jochunae tica jominue matu mate. Junni Isaías tsantica josa, Jesuri jun tsannan quee quiyanpunlaca manse suwanato. ");
INSERT INTO cofNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Junni duque tsachilari Jesuchi awinta layailaie. Jesuri junca quirato, chiquilabe pato, pipilu becochi jisa! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Junni jilaichinasanan, israelítala tala mantaca micarimin tsachi jato, Jesube itsantie: —Nu seque micarimin jonan, nube penenamin ino muquee tie. Nunchitiya nube pejinoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuri beco manpato itsantie: —Soronantiya foro tamanhe tie catsochun. Pichunan tasen tamanhe tie. La mantimini tsachi ica jun joto, tilenantiya chuno itoyoe tie. Junni labe penenano muquinari, casale duque tenca cano joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jesús tsantinunsi manca tsachiman yabe numa penenamin joto, yabe itsantie: —Miya, nube penenano muqueda tie. Tsan josanan casaleri lachi apachica manjino joyoe tie. Lachi apa puyato menainunbi, lari nube penenabi manjanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús mantimini yabe itsantie: —Yala puyaca cuwenta junlari yala tala menailaichunae tie. Nuri junca tennatuto labe penenana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Junni Jesús tsantisi, yabe yachi tsachilabe canoabi wito jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Junni moorasiri wa pipilubi jelecari duque sonban wu quinue. Latsa lanasa, piri canoabi winaminue. Junnasanan Jesuri catson tsoniraminue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Junni yabe penenaminlari yaca mansoncarito itsantilatinue: —Miya, chiquilaca manse laride! Pibi jadito puyalaichinayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús mantimini beco manpato itsantinue: —¿Niya jonan jele tilatinayun? Diosica natiya tennatumin tsanni jolajoe tinue. Tsantisi aman cupato, wuca jera deisa mantaquiniquinue. Latsacanan jera deisa mantaquinquinue. Tsantinunsiri pi jera owowo inue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Junni Jesube penenaminlari duque wepanalainue. ¿Inni ti tsachi junhun? latinue. Pinan wunan titiya jeralela yaca meráminla joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Junni Jesula wa pipilu man becochi jito, Gadara tinun tobi felainue. Junbi fenasa, paluca tsachila pantiyonbi nechi jato, Jesuca quirabi jalainue. Yucanchi ocola yalachibi wito, loco suwacala jominue. Junnan duque papun tsachila jominlanue. Monantiya junse jitunun jominue yalaca jelechi. ");
INSERT INTO cofNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Junni yalari Jesuca quirato sonba pato itsanlatinue: —¿Jesús, nuri chiquilaca ti quebi jayun? ¿Nu Diosichi Nao joto, chiquilaca pasuwabi janayun? ¿Casticaquino ma caitosanan chiquilaca casticaquebi janayun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsanlatinasanan duque cuchi jabile lapa finaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Junni yucanchi ocola Jesube rocainato itsanlatinue: —Chiquilaca sularitori, ja cuchilachi fecáriri erede! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Junni Jesuri beconan manpato, Joo, jun cuchilachica jinilaide! tinue. Junni yucanchi ocola tsachilachibi nechi manloto, cuchilachibi manwilainue. Jun winunsileri cuchilari wa duse jera supatito wa pipilubi jadito jera puyalainue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Junni cuchica cuidaiminla mantimini junca quirato, puebloca sujito, jera cuenta manpolarilaquinue. Yucanchi oco wica jun tsachilacanan jera cuenta manpolarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Junnan jun pueblobi nechi duque tsachila Jesuca quirabi jalainue. Junni yaca quirasiri, yalachi tobi nechi manjideque rocailainue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Junni yucanchi oco wica jominlaca manse suwatobi, Jesula canoabi manwito, wa pipiluca manpolajalainue Jesús chunun puebloca. ");
INSERT INTO cofNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Junni tsachilari wecaino podeiton tsachi mancaca Jesúchica tanjalainue jali cuyanbi poto nanato. Jesuri yaca tennaminla jonunca miito, ya quiyanpunbe itsantinue: —Lachi nao, son tenca ide! Nuchi jutsaca piyarinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Junni Jesús tsantinasanan, weyan israelítala tala mantaca micariminla chuminlanue. Junni yalari Jesuca meráto duque pailainue Diosica seitonque pánae tito. ");
INSERT INTO cofNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Junni Jesuri yalachi tencaca miito itsantinue: —¿Nulari niya jonan nulachi tencabi seitonque tenca calaquinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿La quiyanpunchi jutsaca piyarinayoe tituan? Tsanque pacachi panori layan tenfe itoe. Juntonan quiyanpunca mancupato mannenasa carino, ya fe tenfe jochunae tinue. La mantimini palu cosacanan quino podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","La tsachi ica jun joto in tote jutsaca piyarinonan mantá tan joyoe tinue. Yape mantá tan jonunca miilaisa, fe tenfe jonunca quechinayoe tinue. Junsi mantaca micariminlabe tsantisi, quiyanpunca itsantinue: —Mancupade! tinue. Jalica mancato yaca manjide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aman Jesús tsantinunsi quiyanpun jomin tsachiri mancupato manjinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsachilari wari junca quirato wepanalainue. Wepananato, Diosica duque sen joe latinue Jesuchi tsanque mantá cuwanun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","La Mateo uyan to miyachi mantate inpuesto cala camin joto, cala canun postote chumanyoe. Junnasa Jesús ya jancanca manse suwatobi mannenato, laca manquirato yabe penenamin ide! tie. Junni lari cupato jito, Jesube penenamin icayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Junni man nete Jesube yachi tsachilabe lachibi ano pefilaquinaminhe. Junni pejasa tica jun amicolari seiton quimin jominlanue. Weyanlari inpuesto camin jominlanue la cuwenta. Weyanlari israelítalachi mantaca tennatumin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Junni fariseo tinun israelítalari yala ano pefinaminlaca quiralaquee. Ya fariséolari ano pefinaminlaca quirato, Jesuchi tsachilabe itsantilatie: —¿Nulaca micarimin tsachiri niyaito in seiton quiminlabe ano pefinan? latie. Israelítalachi mantaca tennatuminla joe. Weyanlari ti quiran uyan to miyachi tenchi chiquilaca inpuesto caminla joe. ¿Niyaito Jesuri tsanquira seitonlabe ano pefinan? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Junni Jesuri junca meráto, fariséolabenan itsantie: —Diosichi Pilabi itsanque chuteca joe tie: Laquirasa munajaeque chuteca joe. Diosichi yabi ticatiya epe cuwanacaca tennatiyoeque chuteca joe. Diosi yachi pilabi tsantica joe tie. Junni tíca tsantica jonunca nula miilaina! tie. Juntonan doctorilaca tenca calaquede! tie. Quiyanpun itonlari doctorilaca munaralaratuchunae tie. Quiyanpunlari doctorilaca munaralarachunae tie. Junni la doctor cuwenta joyoe tie. Junni sen joyoe timinlachi tenchi jatucayoe tie. Jutsa quiminlachi tenchi jacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Junni aman Mumunmin Juanbe penenaminla Jesúchica jato yabe panhato itsanlatie: —Chiquila israelítalachi mite nenato, pansile ano fitunca iminlayoe. Fariséolanan jun tsannan iminlae latie. Aman nube penenaminla mantimini finiquiminla joe latie. ¿Niyaito yalari finiquiminla jun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Junni Jesuri yalachi fiquica meráto beconan itsantie: —La casalainamin cuwenta joyoe tie. Junni casalainanun fiestaca quirabi jaminlari duque son tinato, natiya ano fitunca ilaituchunae. Casalaino jun tsachi yalabe parejo cajosanan, yalari son tito ano fitunca ilaituchunae tie. Jun tenchi lari lachi tsachilabe penenasanan, ano fitunca ituminla joe tie. Junni manca mate mantimini la itoanae tie. Laca josolelaquichunae. Junnunbi labe penenaminla weyante ano fitunca ilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","O yape la micarinanunca fe miilaisa, aman manca cuentaman quechinayoe tie foroica panuca. Unica panu foron jonari, casan panu catachituminnan junbi natiya orotuntsan jochunae tie. Junni tenca iton tsachiri unica panubi casan panu pitica manchuteniquinari, ya casan piti piyanari, nantanan fe ayan foro ichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Junsi binocaman tenca calaquede! tie. ¿Chibo quidoca tolo quito bino pomanco? Aman ya tolo unica inari, junbi casan binoca potuntsan jochunae tie. Tenca iton tsachiri poniquinari, junni bino sonba pi isiri tolo unicaca chilechunae tie. Junto bino fojinan, tolonan yucapiyachunae tie. Jun tenchi casan binoca casan tolobi pontsan jochunae yape palunan sen josa. Jun tsanquenan, la casan micaricaca meráto nenaminlari matu micaricaca tennatuntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Junni Jesuri cuenta caquinasanan, mantamin tsachiri jato Jesuchi cale telenhito yachi namachi tenchi rocainato itsantie: —Lachi nama tsaina puyanue tie. Junni jiniisa! tie. Nu tedechi tale quinari, mansonhichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Junni Jesús cupato, yabe yachi tsachilabe pejilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Junni junchi jilainasanan, quiyanpun sona manca Jesuchi benechi nechi jananue. Ya sona chunca palu watale nechi ma cura luban quiranaminue. Junto Jesuchi benechi nechi jato, yachi camisacatiya taquirasiri manseiyanaeque tenca canue. Tsanque tenca cato, Jesuchi camisa puntabi taquiraniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Junni Jesús mantimini tinpoleto, ya sonaca quirato itsantie: —Nama, wepanatude! Laca seque tennato manseinue tie. Jesús tsantinunsi ya sona manseiniinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Junsi mantaminchica jinilaiyoe. Junni junbi féto, folota quiminlaca quiralaquiyoe. Belainaminlacanan quiralaquiyoe firara tinaminlaca. ");
INSERT INTO cofNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Junni Jesuri yalaca quirasi, manlarito ereto itsantie: —Manjinilaide! tie. Ya na puyaca itoe tie. Catson tson rae tie. Junni belainaminlari miraminlanue tsa puyaca joeque. Jun tenchi Jesuchi fiquica meráto cacarilaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús mantimini tsachilaca urachi manlaritobi, na tsonun tamochi wie. Tamochi wito na puyacaca tedele canunsile, mansonhito mancupanue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Junni jun tobi jeralete jun cuentaca polarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Junni Jesuri junbi nechi jinasanan, paluca quirano podeitonla bene jalaie. Yachi benechi jalainato, sonba pato manse suwasa latie. Nuri matu to miya Davichi alica joto, chiquilaca laquirade! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Junni Jesús tamochi wica josa, quirano podeitonla pewiyalaie. Junni Jesús yalabe panhato itsantie: —¿Niyan tilatinayun? ¿La nulaca manquirasa carino podeino joeque quereilaiyun? tie. Junni quirano podeitonlari Miya tito, quereilaiyoe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsantinunca meráto, Jesuri yalachi cacaca taquirato itsantie: —Podeino joeque quereinun tenchi nula manquirano podeilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsantinunsi manquirano podeilaie. Junsi Jesús yalaca sonba mantaquee junca mobenantiya patulajosa. ");
INSERT INTO cofNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yala mantimini manlotobi, jerale jun tobi chuminlabe Jesús ti quica jonunca cuenta polarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yala manlolaichinasa, manca tsachicaman Jesúchica tanjalaie. Yucanchi oco yachibi wica joto, yaca patumin suwaca jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tsan jonan Jesús yucanchi ococa sularinunsi, ya tsachiri cuenta manquiniquee. Junni yaca cuenta manquinaminca quirato, uyan tsachilari wepanato itsanlatie: —Chiquilachi tobi numanan tsanque seque quinanunca quiratumin jominlayoe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariséola mantimini Jesuca yucacurato, yucanchi mantateri yucanchi ocolaca mansularimin joe tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Junsi Jesús jerale pueblobi micaridede nenaminhe. Diosichi fiqui miinun yabi micarinato, sen fiquica micarinaminhe. Diosi mantananun tsachi bolonca cuenta quito sen fiquica micarinaminhe. Junsi jerale quiyanpunlacanan manse suwanaminhe. ");
INSERT INTO cofNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Junnan Jesuri duque tsachila layaicalaca quirato, yalaca laqui tinaminhe. Wepanato jele tito nenato, cuidaimin iton opisa cuwenta jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Junto chiquilabe itsantie: —Nula ya tsachilaca quiralaquede! tie. Wita cuwenta jolajoe tie. Jun witabi manbaleno ma faca joe tie. Junni nula jun witabi narin peyunla cuwenta jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Junto nula Miya Diosibe mantaito quiminla joto, yabe rocailaina! tie uyanlacanan peeresa yape nulabe peayudailaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Junni chunca paluca tsachila Jesube penenamin jominlayoe. Junni aman Jesuri chiquilaca jasa carito, chiquilaca mantá tan suwae. Yucanchi ocolaca yachi mantate sularino podeilaisa carie. Quiyanpunlacanan yachi mantate manse suwano podeilaisa carie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aman yachi mantá tanla chunca palucala itsanque mumun jominlayoe: Casale Simonbe yachi aco Andrebe jominlae. Aman Simonca Pedro tensaato mumun jominhe. Junsi Jacóbobe yachi aco Juanbe jominlae. Yalari Zebedéochi naola jominlae. ");
INSERT INTO cofNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Junsi Felipe, Bartolomé, Tomás, la Mateo jominlayoe. La Mateo casale miyachi tenchi inpuesto cala camin jomanyoe. Junsi manca Jacobo jominhe Alféochi nao. Junsi Lebeo jominhe; yaca Tadéonan tinun jominhe. ");
INSERT INTO cofNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Junsi manca Simón jominhe; ya cananita bolonbi pejomin jominhe. Junsi Judas Iscariote jominhe. Ya mantimini nanni ina Jesuca pa jominlachi cuwapono jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús chiquila chunca palucaca yachi mantate erechinato itsantie: —Israelita itonlachica jitulajona! tie. Samaria to pueblobinan witulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israelítalachicasiri jilaide! tie. Yala Diosichi topiyaca opisa cuwenta jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Junni junbi nenato micarilaquede! jamochi chumin Diosi ya mantananun tsachi bolon suwanaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Junni tsanque micarinato quiyanpunlaca manse suwan, puyacalaca mansonhisa carin, lepra bichi chunlaca manse suwan, yucanchi ocolaca sularin quilaquina! tie. Jesús nulaca cala catuminnan mantá tan suwayoe tie. Junni nulanan cala catuminnan ticatiya jera quinilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Tsanlaquinasanan nula tsachilaca ayudainan, yalari nulachi ano, ticatiya munaranunca cuwanola jochunae tie. Jun tenchi nula paluqui camisa, nin tolo, nin cala, nin sapato, nin tola tanjitulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Junsi nun pueblobi winatotiya, panhalaquina! mo sen tsachi jonunca. Junto nula jun pueblobi nechi manlono fecári ya senlabe chularana! ");
INSERT INTO cofNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Manca yabi fenato seque saludailaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jun yabi chuminla sen jolajonari, Diosibe rocailaina! yape yalaca seque chusa carisa. Seitonla jonari Diosibe tsanque rocaitulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Weyanlari nulaca facarituto, natiya merátuchi latichunae tie. Junni nulari tsan jominlaca telaqueponilaquina! Yalachi yabi nechi manlonato, o yalachi pueblobi nechi manlonato, to poyo nedebi midicaca jera piquisito manjilaina! Junbi chuminlaca seiton jolajoe tito, to poyoca piquisilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tsara seque meralaquede! To yucapiyarino mate Sodoma pueblobi junsi Gomorra pueblobi chumin jominla duque casticailaichunae. Juntonan nulaca merátuchi timinlari jun pueblobi chumin jominlaca fécari duque animali casticailaichunae tie. Jesús chiquilaca erechinato tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Junni Jesús chiquilaca camicarinato itsantie: —Meralaquede! Opisaca lobo bolonbi erenun cuwenta nulaca erechinayoe tie yape Diosica tennatuminlachibi nenalarasa. Junni tenca tan nenalarana! Junsi paloma cuwenta seque jolajona! ");
INSERT INTO cofNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ya seiton tsachilaca tencabe nenalarana! tie. Mantaminlachi nulaca cuwapolaquichunae yape casticaquilaquisa. Diosichi fiqui miinun yabinan nulaca asotaquilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lachi tsachila jonun tenchi nulaca culpa patarilaquichunae. Culpa patarito, miyachi o mantá tanlachi cale tanjilaichunae yape casticaquilaquisa. Tsanlaquinari nula ya mantá tanlabenan laca cuenta quinola jochunae ya Diosica tennatuminlabe. ");
INSERT INTO cofNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Junni nulaca culpa patarito donari, wepanalaituna! niyaque beconan manpano jonunca. Nula pánasanan, Diosi nulaca tuca pasa carichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nula patsa palaquituchunae; nulachi Apa Diosichi Tenca nulachi fiqui forose pánachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Junni Jesús camicarinato itsantie: —Tsachila duque seiton ilaichunae tie. Acola tala mantaminlachi cuwapocaalaquichunae tie yape totelaquisa. Apalanan yalachi nalalacanan mantaminlachi cuwapolaquichunae tie yape totelaquisa. Nalalanan apabe ayanbeca paito, totesa carilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jeralela nulaca pa jolajochunae lachi tsachila jonun tenchi. Junni niyanlaquinasatiya peleituminlari se lolaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Junni tennatulajona! Manca pueblobi nulabe seiton jolajonari, uyan pueblocaman sujilaina! tie. Jerale israelítala chunun pueblobi cajilaitusanan, la tsachi ica jun joto manpatanae tie. Jesús chiquilaca tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Junsi Jesús chiquilaca erechun capánato itsantie: —Peyunla yalachi patronlaca fécari mantá tanla itochunae tie. Patron tsansinan jolajonari, ya michi jochunae tie. O miiminlanan yalaca micariminlaca fécari minla itochunae tie. Micarimin tsansinan jolajonari, ya michi jochunae tie. Junni jun tsanquenan nulanan laca fe itolajochunae. Seitonlari laca yucan ticala jotori, nulacanan nantanancari seitonque palaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Junni tennatulajona! tie. Amana nosa jonunca ina jera miintsan jochunae. Amana miituntsan jonunca ina jeralela miralarachunae tie. Jun tenchi tsachilaca jeleratulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lari nulabe ticatiya nemente pacaca malonte manpanilaquina! yape jeralela meralaquisa. Nosale ticatiya meránunca jeralelabe cuenta manpolarilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Junni tsachi pucacari toteminlaca jeleratulajona! tie. Ya tsachilari tencacari natiya toteno podeilaituchunae. Diosicari jeleralarana! Yari tsachi pucacanan, tencacanan ninbi casticaquino podeichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pichulaca tenca calaquede! ¿Paluca pichu nacaca nasi calachiri cantsan joco? Aman pichulanan layan mica itomincatiya Diosi cuidaimin joe. Nulachi Apa Diosi mantatunari, pichula mancatiya puyatuchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Jun tenchi jeleratulajona! Nula duque pichulaca fe mica jolajoe. Diosi nulaca seque cuidaimin joto, nulaca ticatiya jera mirae. A sili niyan sili chununcatiya jera mirae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Junsi Jesús ereno junlaca camicarinato itsantie: —Junni tsachilaca jeleratuto, la tenchi natiya luratulajona! tie. Tsachilachi cale lachi tsachi joyoe tinilatina! tie. Tsantiminlaca lanan lachi tsachila jolajoe tiyanae tie lachi Apa Diosichi cale. ");
INSERT INTO cofNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Junnan tsachilachi cale lachi itoyoe titulajona! Tsantiminlaca lanan lachi tsachila itolajoe tiyanae tie lachi Apa Diosichi cale. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Junsi Jesús chiquilaca erechinato capánato, itsanque micarie: —Jeralelaca man parejori tenca casa caribi jatucayoe tie. Tsan josa caribi jaca joeque tenca catulajona! tie. La janunbi, tsachilari uyan tala uyan tala tenca calaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naolari apalaca pa jolajochunae tie. Namalanan ayanlaca pa jolajochunae tie. Nasolanan unilachi ayanca pa jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tsanque familiala talanan pa jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Junni nalalari laca apalaca fécari laquiranola joe tie. Apalanan laca nalalaca fécari laquiranola joe tie. Laca fécari laquiratutori, lachi tsachila pejochun seino cajolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Corosibi puyantsancari padeseino jototiya labe penenanola joe peleituto. Tsanque penenatuminlari lachi tsachila pejochun seino cajolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tenca mánta pansi chuchique tenfeminlari jera piyarito puyanilaichunae. Tsanque chunoca lachi tenchi telaquepominla mantimini jera son tito se lolaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Junsi Jesús capánato itsantie: —Nulaca facariminlari lacanan facarimin cuwenta jolajochunae tie. Junni laca facariminlari laca mantamincanan facarimin cuwenta jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Diosichi mantate paminlaca Diosichi jonun tenchi facarilaquinari, Diosi nulaca se tichunae. Yachi mantate paminlachi premioca cuwanato, nulachinan jun tsancanan pecuwachunae tie. Junni Diosichi sen tsachilacanan Diosichi jonun tenchi facarilaquinari, Diosi ya senlachi premioca cuwanato, nulachinan jun tsancanan pecuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tsarasi meralaquede! tie. Labe penenaminla weyanla epe tsachilari jolajoe. Aman yalacanan Jesuchi jolajoe tito laquiranola joe tie. Ya epe tsanla máncachi isan pi nacátiya cutsawolaquitori, nulachi premioca natiya perdeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús yachi chunca paluca tsachilaca tsanque jera micarito eree. Junni chiquilaca tsanque jera micarito eretobi, yanan chiquilachi pueblo cura micaride jinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Junnasa mantimini Juan dorato, Cristo ticatiya quinanunca meránue. Junni Juan yabe penenaminlaca Jesucrístochica erenue yape yabe jera panhalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Junni Jesúchica jalaito itsantilatinue: —Juan nuca panhato, nu Diosi ereno jomin tsachi joyunque panhana! tie tilatinue. Nu itotori, paniquisa tie tilatinue uyanca neyalaquichun. ");
INSERT INTO cofNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Junni Jesús yalabe tulanto itsantinue: —La ticatiya quinanunca nula quiralaquinae tinue. Junto tenca calaquede! Quirano podeitonlaca, jancanlaca, lepra bichi chunlaca, meráno podeitonlaca mansenayoe tinue. Poperelaca Diosichi sen fiquica micarinayoe tinue. Junni nulari junca jera quirato, aman Juánchibi manfeto yabe jera cuenta quilaquina! tinue. Juanbe cuenta quito itsanlatina! tinue: Laca tennanunca peleituna! tinae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Laca palaque tenca catuminla pansi jolajochunae tinae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Junni Juan erecala manjilainunbi, Jesús uyan duque tsachilabe pato, Mumunmin Juanca itsantinue: —¿Nulari niyanlanantiya chutunun posto minu Juanca quirabi jilaico? ¿Aman yaca quirabi jinato, niyaque tenca canaminlayun? tinue. ¿Juanca ti tsachi joeque tenca canaminlayun? ¿Cumana tenca jonhoe tinato jilaiyun? tinue. Te, Juanni cumana tenca tsachi natiya itoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Junni ti tsachi jonhoe latinamanyun? tinue. ¿Tsara uraran camisa pomin oco tsachi jonhoe latinamanyun? Te, tsan itoe tinue. Otoquin camisa pominla miyalachibiri chuminla joe; niyanlanantiya chutunun postobi chutuminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Junni Juanca quirabi jito, ti tsachi jonhoe tinaminlayun? ¿Diosichi mantate pamin tsachi jonhoe tinato jilaiyun? tinue. Janhan. Diosichi mantate pamin joe. Diosichi mantate tsaracari seque pamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Matu mate Diosi yachi pilabi Juanca panue tinue yaca ereno joyoeque. Diosi yachi fiquica paminca Crístochi caquele ereno joyoe tinue yape yachi tenchi jera se suwanasa. ");
INSERT INTO cofNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mumunmin Juanca tsarasica pachinayoe tinue. Monantiya Mumunmin Juanca natiya fe itomin jominlanue tinue. Tsan josanan, amana mate Diosi casanle nechi mantananun bolon tsachila jeralela Juanca fe jolajoe. Yala talari fécari epe tsachilanan Juanca fe jolajoe. ");
INSERT INTO cofNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","15","Junni in fiquica meráto seque tenca cato meralaquede! tinue. Matu mate Moisés Diosichi mantaca chutenue. Diosichi mantate paminlanan yachi pilabi chutelaquinue. Junni in malate Diosichi mantate pamin tsachi mancaman jano jominue. Elías tinun, yaman in malate manjano jominue. Junni la Mumunmin Juanca nulabe ticatiya pachinayoe meráno muquilaquinari. Elías manjano joe tinato Juanca tsantinaminue. Juanni Diosichi mantate pabi jano jomin tsachi joe tie. Junni jerale Diosichi mantate paminlachi fiquica merántsan fiqui jominue Juan jano fecári. Ya janunle nechi mantimini tsachila canbiyaito, uyan quiraque tenca cachun tenfelainae tie. Diosi jamochi mantamin joto, tobinan ya mantananun tsachi bolon suwanae tinue. Junni Juan micarinunle nechi sonban tenca tanla jun bolonbi pewichun tenfelainae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Junto Jesuri Juanca tsantitobi, tsachilabe itsantinue: —In mate tsachilari uyan quiraque tenca tanla joe tinue. Epelesiri paiminla joe tensaamin nalala cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nalala amicolaca paito, chiquila son tito folota quito teralaquinasanan, nulari peteratuminla joe tilatimanhe tinue. Junsi ya nalalanan laquichi warelaquinasanan nulari pewaretuminla joe tito paiminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aman laca paiminlanan jun nalala cuwenta tenca itonla joe tinue. Meralaquede! Mumunmin Juanni sen anoca fituto, bino cuchitumin jominhe tinue. Junni yaca yucanchi oco yachibi wica jonhoe tito paiminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aman la mantimini tsachi ica jun joto Juan cuwenta nenatiyoe tinue. Lari ano fin, bino cuchin, pequimanyoe tinue. Junni lacanan paito, jilu, junsi winan timinlae. Jutsa quiminlachi amico, tsan quiran inpuesto cala caminlachi amico joe timinlae laca. Diosi mantimini ya seiton curaminlaca natiya tennatue tinue. Yabe tsa miica junla niyaque nenaminlaca quirato miintsan jochunae tinue Diosi sen joeque. Jesús tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Junni Jesús tsantitobi, man pueblobi man pueblobi chuminlaca paito payinue. Jun pueblolabiri Jesuri duque wepanato quirantsancari seque quica jominue. Junni yalari tsanque seque quinaminca quiralaquitonan, jutsa quinunca natiya telaquepolaquitunue. Jun tenchi Jesús yalaca paito payinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Itsanque payinue: —Corazín pueblobi chuminla, nula duque padeseilaichunae. Betsaida pueblobi chuminla, nulanan tsanquenan duque padeseilaichunae tinue. Tiro tinun pueblobi chuminlabe Sidón tinun pueblobi chuminlabe seitonla jotonan, nulaca fe sen jolajoe tinue. Nulachibi duque wepanato quirantsancari seque quinaminca quiraminla jotonan, jutsa quinunca telaquepotucala joe. Junni aman jun pueblolabi tsanque wepanato quirantsancari quica jomanpari, yalachi jutsa tenchi duque laquiito, jutsa quinunca jera telaquepono jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Junni to yucapiyarino mate nulari yalaca fécari padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Junsi Capernaum pueblobi chuminla, nulacanan payichinayoe tinue. Nulari jamochi lonola joyoe tica jotonan, puyan ocolachicari patilaichunae tinue. Matu to Sodoma tinun pueblobi chuminla duque seitonla jotonan, nulaca fe sen jominlanue. Nulachibi duque wepanato quirantsancari seque quinaminca quiraminla jotonan, jutsa quinunca telaquepotucala joe tinue. Jun matu to pueblobi tsanque wepanato quirantsancari quica jomanpari, Diosi yalaca yucapiyarino itono jomin jonhoe. Ya pueblo amananan cajono jomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Junni to yucapiyarino mate nulari yalaca fécari padeseinola jochunae tinue. Jesús tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Tsantitobi Jesús yachi Apa Diosibe itsantinue: —Apa, jamochinan, tobinan nusiri Miya joe. Junto nu duque miraminlaca nuchi sen fiquica miisa caritue. Nuri tsachilaca laquirato, uyan tala quino tenca cae tinue. Nalala cuwenta miratuminlacari nuchi sen fiquica miino podeisa carie tinue. Jun tenchi nube acradeseinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Junni Jesuri yachi Apa Diosibe tsantitobi, tsachilabe itsantinue: —Lachi Apa Diosiri lachi jera cuwaca joe. Yasiri laca tsa mirae tinue. Junsi lasiri yachi Nao joto Apa Diosica tsa mirayoe tinue. Junto uyanlari la entendeisa caritunari, Diosica miino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jun tenchi labe cayailaide! tinue. Cosa tenchi duque wepananaminla jeralela laberi cayainola joe. Nulachi tencabi pepailainae tinue duque jadonca panánamin tsachi cuwenta. La mantimini jun jadonca nulachi tencabi nechi jera patarito, nulaca jasaisa cariyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Jadonca patarito, quefoncari panariyanae yape jado itosa. Panáno tenfe itochunae tinue. Junto labe miilaide! tinue. Oto tenca joto, wantaimin joyoe tinue. Labe miinato nulachi tenca jasailaichunae tinue. Jesús tsachilaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Junni manca jasaino mate Jesula witase polenaminlayoe. Aman yabe penenaminlari ano muquinanan, tricoca nasi balecato fidede polenaminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Junni fariséolari chiquilaca quirato, Jesube itsantilatie: —Jasaino mate trabajaquinola itoe latie. Tsan josanan nube penenaminlari ya tricoca balecato lachilaquinae latie. ¿Niyaito mantaca merátuto tsanlaquinan? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Junni Jesuri yalaca meráto itsantie: —Matu to miya Davica pila chutecaca mantenhilaide! tie. Davibe yachi tsachilabe epe tsachila fitunun bibuca finilaquinue tie. Ya bibu Diosichi cuwaca jun bibu jonan, patelelasiri fino jominlanue. Tsan josanan, Davílari ano mochi pasainato, Diosichi yabi wito, ya bibuca cato finilaquinue tie. Tsanquicala josanan, nula yalaca culpa quituminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","7","Junni Jesús fariséolabe itsantinue: —Tenca calaquede! tie. Diosi yachi pilabi itsantinue: Epe cuwanunca munaratiyoe tinue tie; laquiralarasa munarayoe tinue tie. ¿Nula fariséola Diosi tíca tsantinanunca miralarayun? tie. Te, miitolajoe. Nula miralaramanpari, labe penenaminlaca epele culpa quino itono jominla jonhoe. O patelelaca Diosichi Pilabi chutecaca mantenhilaide! tie. Patelela Diosichi yabiri trabajaquinato, jasaino mate trabajaquilaquitonan culpa itolajoe. Junni nula Diosichi yaca tsanque respetaiminla jotori, laca fécari respetainola joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","La tsachi ica jun joto jasaino matenan titiya quino mantá tanirayoe tie. Jesús fariséolabe tsanque beconan cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Junte nechi jito, Diosichi fiqui miinun yabi wilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Junbi tsachi manca tede encon chunue. Junni israelita mantaminlari Jesuca culpa patarichique itsanlatie: —¿Diosichi mantate amana jasaino ma joco? latie. ¿Junni quiyanpunlaca amana manse suwaniquintsan jun? latie. Junni Jesús manse suwantsan joe tinari, yalari culpa patarino jominlanue jasaino mate trabajaquimin joe tito. ");
INSERT INTO cofNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Junni Jesuri yalaca meráto itsantie: —Nulachi opisa manca jasaino mate forochi queereinari, ¿niyan quilaquinoyun? tie. Wari manlarilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aman tsachila mantimini opisaca fe mica jolajoe. Junni numasitiya sen quiniquintsan joe tie jasaino ma josatiya. ");
INSERT INTO cofNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesuri tsantisi tede encon tsachibe itsantie: —Tedeca mantuquede! tie. Junni tede mantuquesi manseie manca tede tsannan. ");
INSERT INTO cofNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariséola mantimini junca quirato, junte nechi manloto tenpalaquinue Jesuca niyaque totentsan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Junni Jesús ya fariséola tenpananunca miito, junte nechi manjie. Jinasanan duque tsachila yabe pejilaie. Junni Jesuri jerale quiyanpunlaca manse suwato, ");
INSERT INTO cofNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yalaca sonba mantaquee yape yaca palaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aman Jesús tsantin nenachunaeque Diosichi Pilabi chuteca joe. Isaíari matu tote Diosichi mantate pato, yaca itsanque pila chuteca jominue: ");
INSERT INTO cofNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Quiralaquede! Tsachi manca Diosi wenteca jun joto Diosibe mantaimin jochunaeque chuteca joe. Diosi yaca laquirato se tiyoe tichunae. Diosi yachi Tencaca ya tsachichibi wisa carichunaeque chuteca joe. Junni ya tsachi piyanle tote chuminlabe pachunae Diosi yalachi tenchi seque quino joeque. ");
INSERT INTO cofNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Junni ya tsachiri pataatuto epele patuchunaeque chuteca joe. Pueblobi paito paminla cuwenta itochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ya tsachiri cumana tenca tanlaca ayudaito, yalaca sonban tenca mansuwachunaeque chuteca joe. Tsantin nenachunae ya jeraleca tuca mantamin miya ino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Israelita itonlanan yaca tennato meralarachunaeque chuteca joe. Isaías Jesuca tsanque pila chuteca jominue Diosichi Pilabi. ");
INSERT INTO cofNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Junni yucanchi oco tencabi wica jun tsachica tanjalaie Jesús yaca mansularisa. Yucanchi ocori yaca yucapiyarica jominue yape quiratusa, nin patusa. Junni Jesuri yucanchi ococa mansularie yape manquiran, manpan, quino podeisa. ");
INSERT INTO cofNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Junca quiraminlari wepanato, yala tala Jesuca panhalaquinaminhe. ¿In tsachi matu to miya Davichi alica “Cristo” tinun jonhoncan? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariséola mantimini yalachi fiquica meráto, palapochique Jesuca itsanlatie: —Jesús tenca mánta yucanchi ocolaca natiya mansularitumin joe latie. Beelzebú tinunchi mantateri yucanchi ocolaca mansularino podeimin joe latie. (Yalachi miteri yucanca Beelzebú tinun jominue.) ");
INSERT INTO cofNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Junni Jesús miinue yala tsanque palaquinanunca. Junca miito itsanque micarie: —¿Ti quichun laca yucanchi mantate yucanchi ocolaca mansularinae latinayun? tie. La yucanchi mantate yucanchi ocolaca mansularinari, yucanlari sularicaanun cuwenta jochunae tie. Itsanque jochunae: Man tori chunla o man pueblobi chunla tala quera quicaalaquitori, jun to o jun pueblo jeraichunae. O junsi man familiala tala pataalaquitori, layaito chuno podeilaituchunae tie. Junni yucanchi ocola tala sularicaatori, jun cuwenta jochunae tie. Junbe tenhintsan joe la yucanchi mantate yucanchi ocolaca sularimin itoeque. ");
INSERT INTO cofNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","O manca fiquica tenca calaquede! ¿Nula talanan weyanla yucanchi ocolaca mansulariminla joco? Aman lari yucanchi mantate yucanchi ocolaca mansularimin jonari, ¿yalari mochi mantate sulariminla jun? tie. ¿Yalanan yucanchi mantate mansularminla jun? Nula junca tenca catori, tenhilaichunae laca epele culpa quilaquinayoeque. Lari wari yucanchi mantate mansularitiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Diosichi Tencachi mantate yucanchi ocolaca mansularimin joyoe. Nula junca tenca cato miintsan joe tie Diosi nulachitenan ya mantananun tsachi bolon suwanaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Junni Jesús tsantisi, yucanca man fiquiman pato itsantie: —Yucan sonban tsachi cuwenta joe tie. Junni sonban tsachichi yabi wito, ya tanunca josolechun casale yaca fe loto teleno jochunae. Lari wari yucanca fe lotumanpari, yachi ocolaca mansularino podeituno jomin joinhie tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Junni laca peayudaituminlari lachi contra jolajochunae tie. Tsachilaca labe pelayaisa carituminla epele ara cura jisa cariminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Junni Jesús Diosichi Tencachi mantate quinaminca yucanchi mantate quinae tituntsan joeque itsantinue: —Diosichi Tencaca seitonque paminlaca perdonaituntsan jochunae tie. Ti uyan jutsacatiya Diosi perdonaino podeichunae. Ti seiton fiquicatiya Diosi perdonaino podeichunae tie. Laca tsachi ica junca seitonque paminlacanan perdonaino podeichunae tie. Juntonan Diosichi Tencaca seitonque paminlacari numatotiya ya jutsaca perdonaituntsan jochunae tie. Casonnaminca o numa puyaca jominca, numanan perdonaituchunae tie. Jesús yaca yucanchi joe timinlabe tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Junsi Jesús ya fariséolabe cacuenta quinato itsantie: —Jana sen pelebi sen puca ichunae. Pele yucapiyacabi seiton puca ichunae. Junto pucaca quirato miintsan jochunae tie nun pele sen jonunca, nun pele seiton jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Junni lanan, nulanan, weyan tsachilanan jun puca pele cuwenta jolajoichunae tie. Sen tenca tanlari seque paminla jocaichunae. Junni nulari ti quiran pini cuwenta joto, natiya seque pano podeilaituchunae. Tsachilachi tencabi tanunca yalachi fiqui forochi paminla joichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Meralaquede! tie. Tsachilari ti epe fiquicatiya palaquitori, to yucapiyarino mate panola jochunae ti quichun epe paca jototiya. ");
INSERT INTO cofNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Diosi nulachi fiquichinan miichunae tie culpa jonunca o itonunca. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Junni israelita mantá tanlari Jesúchica jalaie. Weyanlari yala tala mantaca micariminla, weyanlari fariséola jolajominue. Junni yalari itsanlatie: —Nu micarimin jotori, wepanato quirantsancari quede! tilatie nu Diosichi mantá tan tsachi joeque miilaichun. ");
INSERT INTO cofNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Junni Jesús yalabe beconan itsantie: —¿Niyaito laca wepanato quirantsancari quisa tilatinayun? tie. Nula seitonla joto, Diosica puracala joe unilaca puramin sona cuwenta. Jun tenchi laca tsanlatinae. Te, nulachi tenchi tsanquitiyoe tie. Nulari laca miino muquinari, man fiquicari tenca calaquede! tie. Jonaca mantenhilaide! tie matu to Diosichi mantate pamin jominca. ");
INSERT INTO cofNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ya Jonari peman quepen, peman ma fecári pi tenpe tsominue wa watsachi pecolobi. Junni lari tsachi ica jun joto Jonás cuwenta peman quepen, peman ma to tenpe tsoanae tie. Laca junbe miintsan jochunae tie Diosichi tsachi joeque. ");
INSERT INTO cofNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Junni Jonaca man fiquicaman meralaquede! tie. Jonari Nínive tinun puebloca jito, Diosichi fiqui micarinasa, junbi chuminla jutsa quinunca telaquepolaquinue. Amana Jonaca fe mantá tan tsachi nulaca micarinasanan, nulari jutsaca natiya telaquepotuchi timinla joe. Junni to yucapiyarino mate nula jun tenchi fe culpa patilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","O miya Salomonca mantenca calaquede! tie. Sabá tobi miya sonari barebi nechi jato, Salomonca merábi janue yape duque miranunca micarisa. Amana wari Salomonca fe miramin tsachi nulaca micarinasanan, nulari natiya merátuchi timinla joe tie. Junni to yucapiyarino mate nula jun tenchi fe culpa patilaichunae tie. Jesús yalaca tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Junto Jesús itsanque cuenta polarie: —Yucanchi oco tsachichi tencabi nechi loto epele nenachunae tie tile jasaino jonunca neyato. Junni jasaino podeituto ");
INSERT INTO cofNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","jun tsachichi tencabinan manchubi wichinayoe tichunae tie. Aman manjato quiranari, ya tsachichi tenca fu tamo cuwenta jochunae. Casica jun cuwenta sen jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Junca quirato manjito, weyan sieteca yucanchi ocolaca cato, ya tsachichi tencabi petanwichunae tie yape junbi pechularasa. Junni jun sietecala ya mancaca fe seiton jolajochunae. Junni ya tsachiri casale mancari yucanchi oco posari, yucapiyaca tsachi jomin jochunae. Nanni wanbile mantimini nantanancari yucanchi ocola winunbi, nantanancari yucapiyachunae tie. Jesús tsanque cuenta polarisi yaca meráminlabe itsantie: —In mate sonnamin tsachila seitonla joto, ya yucanchi oco wica jun tsachi cuwenta ilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús yalabe cacuenta quinasanan, yachi ayanbe yachi acolabe jalaie. Urachi raminlanue yabe cuenta quechique. ");
INSERT INTO cofNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Junni tsachi manca Jesube itsantie: —Nuchi ayan, nuchi acola urachi wiruralarae tie nube cuenta quechique. ");
INSERT INTO cofNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesuri tsantinaminbe beconan itsantie: —Junte wiruraminla lachi tsa ayan, tsa acola josanan, yalacari ayan, aco titumanyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Junto yabe penenaminlaca tedechi micuwato itsantie: —Inlaca lachi ayan, lachi acola timanyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lachi Apa Diosi jamochi chue. Junni jerale yachi mantaca meráminlacanan lachi acola, lachi soquila, lachi ayanla tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jun mate Jesús urachi loto, wa pipilu fiquile chudie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Duque tsachila yachi awinta layailainasa, canoabi wito chudie. Tsachila pi fiquile wiruito meralaquinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Junni Jesús yalabe duque micarinun cuenta polarinato itsantie: —Tsachi manca ni aralebi jichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Junni ni aralenasa, weyan niri minubi queereichunae. Junca pichu jato finiquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Weyan niri nasiri to tson subi arajichunae tie. Junto ya niri moora suchunae. Juntonan nasiri to tsonan, ");
INSERT INTO cofNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pata chibachi moorari jera luban lato jequeichunae tie tenpe telenle quino podeituto. ");
INSERT INTO cofNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Weyan niri tsala minu arajichunae. Junca tape fe uwaito, sunamin nacaca jera doquicaniquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Manan weyan niri sen tobi arajito seque suchunae tie. Ya ni uwaito ni chudichunae tie ni cura patsa ni, weyanbi sota chunca ni, weyanbi peman chunca ni. ");
INSERT INTO cofNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aman Jesús tsanque cuenta polarisi, itsantie: —Nula punqui chunla jotori, seque meralaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Junni Jesús jun cuentaca micarinunbi, yabe penenaminlari yachica jito itsantilatiyoe: —Tsachilaca micarinato, ¿niyaito cuenta quicachisiri micarimin joyun? latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Junni Jesús chiquilaca meráto beconan itsantie: —Duque taminlachi fe cuwanan, nantanancari duque talarachunae. Itonlachica mantimini nasiri tanuncatiya josolenan, natiya iton ilaichunae tie. Jun tsanquenan nulari miraminla joto, fécari miilaichunae. Diosi nulachi mi cuwachunae. Uyanlachi mantimini mi cuwatue. ");
INSERT INTO cofNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","15","Isaías matu mate yalaca panue. Diosichi mantate pánato yalaca itsanque pila chutenue: Ya tsachilari Diosichi fiquica meránatonan, numanan seque miilaituchunaeque chuteca joe. Quiranatonan, numanan seque quiralaquituchunaeque chuteca joe. Punqui don cuwenta ilainue merátuchique. Caca cuniicala cuwenta ilainueque chuteca joe quiratuchique. Yala pele tenca ilainueque chuteca joe miituchique. Miituto uyan tenca ituchi timinla joeque chuteca joe yape yalaca se larino podeitusa. Isaías tsanque pila quica joe Diosichi Pilabi. Junto Isaíachi fiquica manpolaritobi, Jesuri itsantie: —Amana merátuchi timin tsachila Isaías paca junla cuwentanan jolajoe tie. Quiranatonan seque quiratuminlae tie. Meránatonan miituminlae. Tenhituminlae. Jun tenchi yalaca cuenta quicachisiri micarimin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nula mantimini yala cuwenta itolajoe. Nula seque quiran, seque merán quiminlae tie. Junto nulari duque pansi jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Junni tsarasica meralaquinade! Duque Diosichi mantate paminlanan nula quirananunca quirano munaratonan, quiratucalae. Duque sen tsachilanan nula merananunca meráno munaratonan, merátucalae tie. Junni nulari duque pansi jonola joe tie. Jesús chiquilabe tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Junni Jesús tsanque cuenta quesi, Ni aralenun cuentaca jera tuca manmicarichinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Junsi itsantie: —Diosichi fiqui ni cuwenta joe. Junni weyan tsachila Diosichi fiquica meranatonan natiya entendeituminlae. Yalari minubi arajica ni cuwenta jolajoe tie. Yucan yalachica jato, fiqui arajicaca manjosoleniquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Junsi weyanlachi tencari su jamote nasi to tson cuwenta jolajochunae tie. Yalari jun órari Diosichi fiquica son tito meralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Junni telenle potuca jun cuwenta moora fecári tennaminnan peleilaichunae tie. Diosichi fiquica meráto nenamin jonun tenchi padeseinato, peleilaichunae tsachila pasuwalaquinae tito. ");
INSERT INTO cofNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Weyanlachi tenca tsala to cuwenta jolajochunae tie. Yalari Diosichi fiquica meráto, junto niyaque sonnanoca, cala canocanan wepanato nenalarachunae tie. Jun tenchi Diosichi sen fiquica tennatumin joto, natiya sen itulajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Junni weyanlachi tenca mantimini sen to cuwenta jolajochunae tie. Sen fiquica meráto tsara miilaichunae. Yalari sen tobi ni arajica cuwentanan duque sen ilaichunae tie patsa ni chudinun cuwenta, weyanla sota chunca ni chudinun cuwenta, weyanla peman chunca ni chudinun cuwenta. Jesús tsanque manmicarie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Junto Jesús camicarinato itsanque cuenta polarie: —Diosi jamochi mantamin cuwenta tobinan ya mantananun tsachi bolon serawonae. Junni yalaca serawonato, wita tsacumin cuwenta jochunae tie. Ya wita tsacumin sen trico nica yachi witabi waca jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Junni catson tsosa, yaca pa jomin tsachi nosa jato, seiton tape nicanan jera waqueto manjichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Junni trico uwaito ni chudinasa quiranari, seiton tapenan peuwaica jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Junni ya wita tsacuminchi peyunlari yabe itsanlatichunae tie: Nuri sen nica waca josanan, ¿niyaito tsancari seiton tape lan? latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Junni tsacumin beconan pato, Yaca pa jomin tsachi tsanquinue tichunae. Junni peyunlari ¿Seiton tapecari tocun quisa tenjan? latichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te, tocun quilaquitude! Seiton tapeca tocun quinato, tricocanan pemurilaquichunae tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yape palunan parejo parejo uwailaisa tichunae tie tricobe seiton tapebe. Junni tricoca baleno mate baleminlaca mantaqueyanae tichunae tie seiton tapeca casale cato tuntuto, nin posa. Junsi tricocari lachi dunun yabi dusa cariyanae tichunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Junto Jesús micarinato, in cuentacanan polarie. Itsantie: —Mostasa tinun niri fe tsanini ni jotonan, witabi waquenari, duque jelelen imanhe tie. Jerale tapelaca fe uwaito, chide pele tsansi imanhe. Pichula titiya tasen quintsan imanhe. Junni Diosi ya mantananun tsachi bolonca serawonato, jun tsannan quichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús jun cuenta polarisi, manaman cuenta manpolarie bibu quiminca. Itsantie: —Sona manca bibu quichunae tie. Man arowa tsansi arina cato, lebaduracanan pochunae yape bibu ayancaisa. Junsi tsarasi palachunae tie yape lebadura jeralete palaisa. Junni Diosi ya mantananun tsachi bolonca jerale tote serawonato, jun tsannan quichunae. Jesús tsanque cuenta polarie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tsanque Jesuri cuenta polarito micarinaminhe. Junni duque tsachila yaca meráchun, yachite layaimin jominlae. Junni yalaca cuentachisiri micarimin jominhe. ");
INSERT INTO cofNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Junni Diosichi mantate pamin tsachi matu mate junca itsanque pila chuteca jominue: To quinunle nechi camerátunun jonun fiquica cuenta quicachiri micarichunaeque chuteca jominue. Junni matute tsantica josanan, Jesús jun tsanquenan micarimin jominhe. ");
INSERT INTO cofNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Junni Jesuri tsachilaca purato, tamochi manwie. Junni winunsi yabe penenaminla yachica jato, yabe rocailaiyoe seiton tape cuentaca tuca manmicarisa. ");
INSERT INTO cofNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Junni Jesús itsantie: —La tsachi ica jun joto, ya sen nica aralemin cuwenta joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jerale to lachi wita cuwenta jochunae. Junni Diosichi tsachilari sen trico ni cuwenta jolajochunae tie. Yucanchi tsachilari seiton tape cuwenta jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Seiton tapeca aralemin pa jomin tsachi, ya yucan jochunae tie. Baleno mari to yucapiyarino ma jochunae. Balenaminla anjelila jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","¿Ya cuentabi seiton tapeca porecato nin poca jominuco? Junni to yucapiyarino mate jun tsanquenan jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","La tsachi ica jun joto, jun mate anjelilaca ereyanae tie. Junni lachi joyoe timinlachile nechi ya anjelila jera jutsa quiminlaca laricalaquichunae tie. Jutsa quisa carinaminlacanan laricalaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yalaca laricato wa ninbi queerelaquichunae tie. Junbi padeseinato, fudachi warelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Junni senla mantimini yalachi Apa Diosi mantananunbi pansi chuto, yo cuwenta tsen jolajochunae tie. Junni nula punqui chunla jotori, seque tenca cato meralaquede! tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Junni aman Jesús tsachilabe cuenta caquinato, manca cuentacaman meralaquede! tie. Junto itsantie: —Tsachi manca duque mica jonunca fechunae tie. Uyanlachi tobi menaraminca fechunae. Junto son tito, mica jonunca nosa mandoto, jun toca calachi cachun duque tenfechunae. Ticatiya tanunca yape josa! tito jera osito, jun toca caniquichunae tie mica jonuncanan tsacumin ichun. Junni Diosi mantananun tsachi bolonbi wichun jun tsanquenan duque tenfentsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Junni Jesús jun cuenta polaritobi, manca cuentacaman polarito itsantie: —Tsachi manca perla cato manhosimin jochunae tie. Junni perla neyato nenaminnan, duque sen perla manca quirachunae uyanlachica. Junto jun perlaca cachun duque tenfechunae tie. Ticatiya tanunca jera yape josa! tito osito, jun perlaca caniquichunae tie. Junni Diosi mantananun tsachi bolonbi wichun jun tsanquenan duque tenfentsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Junni Jesús jun cuenta polaritobi manca cuentacaman itsanque polarie: —Watsa caminlari wa pipilubi dada quepolaquichunae tie. Dadabi ti watsatiya iniichunae tie weyan fitunun watsa, weyan finun watsa. Junni dada quidile inan, manlarito chudito, watsalaca wentelaquichunae. Finuncari tsalabi pocan, fitununca quepon, quito wentelaquichunae tie. Junni Diosi mantananun tsachi bolonbi jun cuwenta jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","To yucapiyarino mate anjelila jato, tsachilaca wentelaquichunae tie ya watsaca wenteminla cuwenta. Senlacari man nanchi seto, ");
INSERT INTO cofNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","seitonlaca wa ninbi quepolaquichunae tie. Junbi padeseinato fudachi warelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús tsanque cuenta jera polarisi, chiquilabe itsanque panhae: ¿Junca jera meralaquinayun? tie. Chiquilari jera meralaquinayoe tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Junni Jesuri chiquilabe itsantie: —Duque tanla duranun tamochi nechi ticatiya larilaquichunae tie. Numari tanuncanan, casancanan larilaquichunae tie. Junni Diosichi fiquica micariminlari Diosi mantananun tsachi bolonca miitori, jun cuwenta jolajochunae tie. Labe casan fiquica miilaichunae tie. Junni lachi casan fiquicanan, Diosichi matu pilacanan micarilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús ya cuentaca jera polaritobi, junte nechi jito, ");
INSERT INTO cofNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ya uwainun puebloca manjilaiyoe. Junbi Jesús Diosichi fiqui miinun yabi micarinasa, tsachila wepanalaie. Junni wepananato itsanlatie: —¿In Jesuri niyaito tsancari miica junhun? ¿Niyaito wepanato quirantsancari quimin junhun? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Inte carpinterochi naori jotun? ¿Yachi ayanni inte María tinun jotun? ¿Yachi acola Jacobo, José, Simón, Judas jolajotun? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Yachi soquilanan chiquilachi quelote chuminla jotun? ¿Tsan josanan niyaito tsancari poden jun? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Junto Jesuca quereituchi tito pailaie. Jesús mantimini yalabe itsantie: —Diosichi mantate paminlaca piyanlete respetailaichunae tie. Tencachique pueblobisiri, o tencachique yabisiri yalaca natiya respetailaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Junni jun pueblobi layan wepanato quirantsancari seque quino podeitue yala tennatuminla jonun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jun malate tsachilari Jesuca duque cuenta quinaminlaca miya Heródenan meránue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes junca meráto yachi tsachilabe itsantinue: —In Jesús tinun tsachi Mumunmin Juan jonhoe tinue. Juan puyato mansonhito, wepanato quirantsancari seque quimin ica jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Aman Mumunmin Juan itsanque puyaca jominue. Herodes yachi acochi sonaca josoleca jominue. Felípechi sona jominue Herodías tinun mumun. Junni Mumunmin Juan junca meráto Heródeca payica jominue. Acochi sonaca josoletuntsan joe tica jominue. Junni Herodías Heródeca mantasa carica jominue Juanca cadenachi teleto dolaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aman tsachila mantimini Juanca se tito, yaca Diosichi mantate pamin joe tinaminlanue. Junnan Heróderi Juanca totechi tinatonan, casale yaca catoteca itominue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Junni Juan dorasanan, Heródechi wata tula ma fanue. Jun mate Heródela fiesta quilaquinasanan Herodíachi namari teranaminue yape Heródela quiralaquisa. Junni ya nama teranan, Herodes yaca duque se tito ");
INSERT INTO cofNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yabe itsantinue: —Nu tica panhanatiya, la cuwaniqueyanae tinue. Juraquito pánayoe tito tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Junni ya namari yachi ayanbe panhanue. Junni yachi ayanbe panhato, Heródechica manjito, itsantinue: —Mumunmin Juanchi misuca wa nidabi cuwade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Miyari yaca meráto laquiinue. Juntonan juraquito paca joto, junsi junte pechuminlanan meracala jonan, nene patuchique cuwaniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Juan doranun yaca ereniquinue Juanca misu butunsa. ");
INSERT INTO cofNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Junni Juanchi misuca wa nidabi poto tanjato, jun sonachi cuwalaquinue. Junni yari yachi ayanchica tanjinue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Junni Juanbe penenamin jominlari Juan puyacaca mancato menalaquinue. Junto yala Jesúchica jato yabe jera cuenta polarilaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesula Mumunmin Juan puyanueque meráto, niyanlanantiya chutunun postoca jilaiyoe canoachi. Junni uyan tsachilari junca miito, yalanan bene jalaie. Pueblobi nechi nedechi jalaie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Junni Jesús canoabi nechi loto quiranari, duque tsachila méraminlanue. Junni yalaca laquirato, quiyanpunlaca manse suwaniquee. ");
INSERT INTO cofNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Junni quebi inasa Jesube penenaminlari yachica jato, itsanlatiyoe: —Inte niyanlanantiya chutunun posto joe tilatiyoe. Quebi inae tilatiyoe. Junto tsachilaca manherede! tilatiyoe yape quelole puebloca jito ano cato filaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Junni Jesuri chiquilabe beco manpato itsantie: —Tsachilaca manheretuntsan joe. Nulari yalachi ano cufilaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Junca chiquilari wepanato meráto, Ano itolajoyoe tilatiyoe. Manteca biburi, paluca watsari talarayoe tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Junni Jesús ya finoca yachica tanjasa tito, ");
INSERT INTO cofNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","tsachilaca lapate jera chudisa mantaquee. Junsi Jesús manteca bibuca, junsi paluca watsaca cato, jamochi quirato, Diosibe acradeseie. Diosibe acradeseitobi, aman bibuca pisuleto yabe penenaminlachi cuwae yape junte chumin tsachilachi cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Junni jeralela michi fito peyailaiyoe. Junni puchuicaca manlayato, chunca palu tsalabi tuwale manlayalaquiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Junni duque tsachila ito filaquiyoe. Sonalaca, nalalaca mituto, unilalacasiri mito, mante mili tsansi jominlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Junni jeralela ano fitobi, Jesuri yabe penenaminlabe itsantie: —Nulari canoabi wito, laca caquenan wa pipiluca polelainade! Junnasa lari tsachilaca manherechinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Junni Jesús tsachilaca manheretobi, du minu mancasiri jinue Diosibe rocaibi. Junni aman nemeinasa Jesús junte mancasiri rasanan, ");
INSERT INTO cofNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","chiquilari canoachi wa pipilu quitsabi jinaminlayoe. Junni wu quito canoaca quechutenaminhe. Latsanan quechutenaminhe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Junni tseino inasa Jesús pi jamoca nedechi chiquilachica jananue. ");
INSERT INTO cofNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Junni chiquilari tsanque pi jamochi nedechi janaminca quirato, duque jelechi atinato, puyan oco jonhoe latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Junnasaleri Jesuri pato itsantie: —Sonban tenca ilaide! tie. Lanan joyoe; jeleratulajode! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Junni Pédrori otito, Miya tie. Junsi Jesús jotori lacanan nuchica pi jamoca jasa caride! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesuri janiide! tie. Junni Pédrori canoabi nechi loto, pi jamoca Jesúchica nedechi jiniie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Junni Pedro jinaminnan, wu quinanunca quirato jele tie. Junni jele tito, pibi menawinaminhe. Junto Pédrori sonba pato, Miya, laca manse laride! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús mantimini yaca tedechi we mancato itsantie: —Nu tennatumin joe. ¿Niyaito tennano peleiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Junni Jesube Pédrobe canoabi manwiyanunsi, wu mandeie. ");
INSERT INTO cofNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Canoabi chuminlari wari Jesuchi cale telenhito, Nu Diosichi tsa Nao joe tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Junni chiquila pipiluca man becochi poleto, Genesaret pueblobi felaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Junni jun pueblobi chuminlari Jesuca manmiito, jeralete meracarilaquinue yape jerale quiyanpunlaca yachica tanjalaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Junni quiyanpunlari Jesube rocailaie yachi camisa puntabitiya taquirachun. Junni jerale taquiraminla manseilaie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Junnasa Jerusalén pueblobi nechi israelítala tala mantá tanla Jesúchica jalaie. Weyanla fariseo tinun bolonla jominlanue; weyanla israelítala tala mantaca micarimin jominlanue. Yala Jesúchica jato itsantilatie: ");
INSERT INTO cofNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Niyaito nube penenaminlari chiquilachi matu tatalachi mite nenatuminla jun? latie. Nube penenaminlari tedeca tsaletuminnan ano finato, seiton icala joe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","6","Junni Jesuri manpato itsantie: —Nulari wari matu to israelítalachi miteri nenalarachique Diosi mantaca junca telaquepominla joe tie. Meralaquede! Diosi chiquilaca mantanue apacanan, ayancanan seque respetailaisa. Apaca o ayanca seitonque paminlaca niya josatiya totenonan joeque chuteca joe tie. Juntonan nulari itsantiminla joe: Apachi o ayanchi tenchi seque quino muquetunari, nulachi calaca Diosichi jera cuwacayoe tintsan joe timinlae tie. Tsantiminlari apabe ayanbeca ayudaitusanan, se jonijochunae timinlae tie. Junto nulachi mantaca meráchun, Diosichi mantaca telaqueponiquiminla joe. Seitoe. ¿Niyaito tsanquiminla joyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nulari fe sen jolajoyoe titonan, seitonla joe. Matu to Isaías Diosichi mantate pánato, nulaca tuca cuenta quinue. Yari itsanque chutenue Diosichi Pilabi: ");
INSERT INTO cofNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","In tsachila Diosica se tinato, fiqui forochiri se timinla joe; Diosica natiya merátuchi timinla joeque chuteca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nulari Diosichi cale epe telenhiminla joeque chuteca joe tie. Nula micarinato, tsachilachi mantacari micariminla joeque chuteca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Junni Jesús tsachilaca jera layasuwato, itsanque micarie: —Sele quereito meralaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Seiton anoca finatonan, seiton tenca ilaituchunae. Seiton fiqui mantimini, ya fiqui forobi nechi lanato, tencaca seiton suwachunae. ");
INSERT INTO cofNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Junni Jesube penenaminla yachica jato itsanlatiyoe: —Fariséola nuchi fiquica meráto paicala joe tilatiyoe. ¿Yaca tenhiyun? tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesuri chiquilabe tulanto itsantie: —Fariséolaca tennatulajona! tie. Yalari epe tape cuwenta jolajoe. Junni ti tapetiya lachi Apa Diosi waqueca jun itotori, jera muraichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Junni yalaca telaquinilaquede! tie. Jana tsachi manca quirano podeiton jotonan, manca quirano podeitonca minu micuwanaminnan, palunan forochi queereilaichunae tie. Junni fariséola ya quirano podeitonla cuwenta jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Junni Pedro Jesube panhae seiton anoca paca fiquica niyan tito tsantiyunque. ");
INSERT INTO cofNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Junni Jesús itsantie: —¿Nulanan caentendeilaitiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Anori fiqui forose wito, tencabiri witumanhe. Pecolobi wito, poleniimanhe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Fiqui mantimini fiqui forochi nechi lanato, tencabi nechinan joe. Junto seiton fiqui palaquinatori, seiton tenca jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsachilachi tencabi nechiri titiya seiton lochunae tie. Seitonque tenca can, tsachilaca toten, uyan sonalabe o uyan unilalabe nosa seitonque nenan, tarinquin, nene pan, yucacuran, quilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsanquiminla seiton tenca tanla jochunae tie. Tede tsaletuminnan fito mantimini seiton tenca ilaituchunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesula Genesaret pueblobi nechi loto jito, uyanchi jilaiyoe Tiro pueblobe Sidón pueblobe quelote. ");
INSERT INTO cofNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Junni junte chumin cananea sona chiquilachica jato, sonba pato itsantie: —Chiquechi namachibi yucanchi oco wito, duque padeseisa carinae. Nuri matu to miya Davichi alica joto, chiqueca laquirato yucanchi ococa mansularide! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús mantimini yabe jun órari natiya patue. Junni Jesube penenaminlari Jesuchi cale jato itsanlatiyoe: —In sonaca ayudaito manherede! tilatiyoe. Chiquilaca bene jato otito pasuwanae tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Junni Jesús jun sonabe itsantie: —Diosi laca israelítalachi tenchisiri ereca joe tie. Yala Diosi wenteca tsachila jotonan, topiyato nenamin opisa cuwenta jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sona mantimini peleituto, Jesuchi cale telenhito, Miya, yucanchi ococa mansularito cuwade! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Junni Jesuri beco pato itsantie: —Israelítalari Diosichi nalala cuwenta josanan, nuri israelita itoe. Junni nuca ayudaitori, nalalachi anoca josoleto susuchi cuwamin cuwenta patino joichunae tie. Tsantuntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Junni sonari itsantie: —Miya, nuri tsa tie tie. Tsan josanan nalalachi ano nasi nacá tobi darapatinaminca susunan fimanhe. Junni chiquecanan nasi nacá ayudaide! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesuri jun fiquica meráto ya sonabe itsantie: —Nu Diosica duque quereimin sona joe. Diosica quereimin jonun tenchi nuchi namachibi nechi yucanchi oco manlochunae tie. Tsantinunsi, yachi namachibi nechi yucanchi oco numa manlonue. ");
INSERT INTO cofNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Junni aman Jesús junte nechi jito, Galilea tinun wa pipilu quelole poleto, du minu jito chudie. ");
INSERT INTO cofNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Junni duque tsachila yachica jato, quiyanpunlaca tanjalaie. Jancanlaca, quirano podeitonlaca, pano podeitonlaca enconlaca, tanjato, Jesuchi cale tsorecaca manse suwae. ");
INSERT INTO cofNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Manse suwanunbi pano podeiton jominla manpalaquee. Encon jominla manseilaie. Jancan jominla mannenamin ilaie. Quirano podeiton jominla quirano manpodeilaie. Junni junca quiranaminla duque wepanato, israelítachi Diosica duque seque palaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Junni Jesús du minu camicarinaminnan, yabe penenaminlaca jasa tito chiquilabe itsantie: —In tsachilaca duque laquirayoe tie. Peman ma fecári labe inte pechularato, ano fino jeraicala joe tie. Junni ano fituncalaca manhereno muquetue tie yape minute podeiton cayailaitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Junni yabe penenaminlari itsantilatiyoe: —Inte niyanlanantiya chutunun posto joe. ¿Junnan in duque tsachilachi cufichun niyaito ano calaqueyanan? tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesuri chiquila tsanticaca meráto, chiquilabe itsanque panhae: —¿Niyanca bibu talarayun? tie. Junni chiquilari bibu sieteca, watsa nasi talarayoe latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Junni Jesuri tsachilaca tobi jera chudisa mantaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Junto bibube watsabeca cato, Diosibe acradeseito, bibube watsabe pisuleto, chiquilachi cuwanan, chiquilari tsachilachi mancuwalaquiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jeralela junca cato fito, peyailaiyoe. Junni puchuicaca manlayato, sieteca tsalabi tuwale layalaquiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Duque tsachila filaquiyoe. Sonalaca, nalalaca mituto, unilalacasiri mito, junpalu mili jominlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Junni ya ano fitobi, Jesula tsachilaca jera manhereto wa canoabi wito Magdala tinun toca jilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Junni aman fariséolabe saduséolabe Jesúchica jalaie yaca seiton patarichun. Yalari Jesube pato, jamochi nechi mantá tan jonunca miichun, wepanato quirantsancari seque quede! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Junni Jesuri yalabe itsantie: —Yoquidoca tenca calaquede! tie. Quebi inasa yoquido luba quidon jonari, yaca quirato miito, suwa quituchunae timinlae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Quepenan mantimini poyobe yoquidobe luba quidon jonari, yaca quirato miito, suwa quinono tinae timinlae tie. Nula yoquidoca quirato miino podeiminla joe tie suwa quino jonunca. Junni laca niyan quinanunca quirato, jun tsanquenan miintsan joe tie mochi mantate tsannanunca. Nulari wari min jolajoyoe titonan, natiya seque miituminla joe. Yoquidoca sele miino podeilaitonan, Diosi ti quinanunca natiya miino podeitulajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nula piyanlela seitonla joto, Diosica puracala joe unilaca puramin sona cuwenta. Junto wepanato quirantsancari seque quinaminca quirachi tilatinae tie. Nulari junca natiya quirano podeilaituchunae tie. Junni nulari laca tsa miino muquilaquinari, matu to Jonaca tenca calaquede! tie. La Jonás cuwenta ino joyoe. Junca quirato nulari miintsan jochunae tie. Jesús tsantisi, jito polee. ");
INSERT INTO cofNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Junni aman wa pipilu man becochi manpolenato, Jesube penenaminla bibuca tanjano pansica jominlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Junnasa, Jesús chiquilabe itsantie: —¿Bibu quichun jana lebaduraca pono jotun? yape ayancaisa. Junni fariséolabe saduséolabe seiton lebadura talarae tie. Ya lebaduraca tencabe nenalarana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesube penenaminlari jun fiquica meráto tenpalaquiyoe tíca tsantinanunca. Junto bibu tanjatucalayoe tilatiyoe; jun tenchi tsantin tinae tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Junni Jesús chiquila tenpanaminlaca tenhito itsantie: —¿Niyaito laca quereilaitiyun? ¿Ti quichun bibu itolajonunca tenpalaquinayun? tie. ¿Catuilaitiyun? ");
INSERT INTO cofNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manteca bibucari mante mili tsachilachi cufica jonunca mantenhilaitiyun? ¿Duque tsalabi puchuicaca mancalaquitiyun? ");
INSERT INTO cofNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿O sieteca bibucari junpalu mili tsachilachi cufica jonuncanan mantenhilaitiyun? ¿Duque tsalabi puchuicaca mancalaquitiyun? ");
INSERT INTO cofNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nula junca mantenhilaimanpari, lachi fiquica tuino jominla jonhoe. Laberi bibu itosatiya wepanano itochunaeque tenhino jominla jonhoe. Te, lebadura tito bibuca pátiyoe. Uyan cosaca lebadura tinamanyoe. Junto mannan tsantichinayoe: Fariséolabe saduséolabe seiton lebadura tsanca talarae. Yalachi lebadura tsanca tencabe nenalarana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Junni Jesús tsantinan, tenhilaiyoe bibu quinun lebaduraca cuenta quitueque. Yalachi lebaduraca tencabe nenalarana! tinato yala micarinunca tencabe nenalarana! tinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Junni Cesarea Filipo tinun pueblo quelo féto, Jesuri yachi tsachilabe itsantie: —¿La tsachi ica jun jominca niyan latinan? tie. ¿Tsachilari laca mo jonhoe latinan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Junni Jesuchi tsachilari beconan itsantilatiyoe: —Weyanlari nuca Mumunmin Juan jonhoe latinae latiyoe. Aman junsi weyanlari nuca matu to Elías jonhoe, o Jeremías jonhoe, o manca Diosichi mantate pamin tsachi jonhoe latinae latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Junni chiquilabe manpanhato itsantinue: —¿Junni aman nulari laca mo jonhoe latiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","18","Aman Jesucrístobe penenamin manca Simón jominhe Jonachi nao. Tensaato mumun Pedro ino jominue. Yari Jesús panunsi itsantie: —Nuri Diosi wenteca jun Cristo tinun tsachi joe tie. Sonnamin Diosichi Nao joe tie. Junni Jesuri Simonbe itsantie: —Simón, nu tsachilaberi laca tsanque natiya miitue; lachi Apa Diosiri nuca tsanque micarinue. Jun tenchi nu duque son jochunae. Nuca manca mumun pochinayoe; nuca Pedro tichinayoe tie laca tsanque tsarasica panun tenchi. Junni la wenteca jun tsachi bolon jun wa su tsanca tennato seralaichunae. Junni puyan ocolachi postori ya bolonca fe lotuchunae. ");
INSERT INTO cofNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuchi mantá cuwachinayoe yape Diosi mantananun tsachi bolonbi mantá tasa yabe tan cuwenta. Junni in tote ticatiya mantanari, jamochinan tsanquenan mantaca jochunae. O in tote nu ticatiya quiniquintsan joe tinari, jamochinan tsanquenan mantaca jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Junni Jesuri yachi tsachilaca tsanque micaritobi, chiquilaca sonba mantaquee yape yaca Diosi wenteca jun Cristo tinun tsachi joeque mobenantiya capatusa. ");
INSERT INTO cofNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Junni jun male nechi Jesuri yabe penenaminlaca tuca micarinaminue puyano joyoeque. Itsantinue: —Jerusalén puebloca fenunbi, israelita mantaminla laca padesecarilaquichunae tie. Mantá tan unicalabe, mantá tan patelelabe, israelítala tala mantaca micariminlabe, jerale layaito, laca totesa carilaquichunae tie. Junnasanan la peman ma puyaca joto mansonhiichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aman Jesús tsantinasa, Pédrori yaca uyan talale tanjito sonba payie: —Miya tie. Tsantituntsan joe. Nuri natiya padeseino itochunae tie. Diosi nuca isaino joe yape padeseitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Junni Jesús quiraereto, Pédrobe itsantie: —Laca telaquiniquede! tie. Nu Satanás cuwenta pánae tie. Laca pa jomin cuwenta pánae. Diosichi mite patue; tsachilachi miteri pánae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Junni Pédrobe tsantisi, chiquilaca itsanque payie: —Labe penenachi timinlari tenca munate nenanoca telaqueponola jochunae. Corosibi puyano jun tsachi cuwenta jera telaquepoto, labesiri penenanola jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yalachi tenca munatenan pansi chuchiqueri tenfeminlari ticatiya jera piyarito puyanilaichunae tie. Juntonan tsanque pansi chunoca lachi tenchi telaquepominlari numatotiya Diosibe pansi chuto polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Juntonan tsachi manca piyanle toca tsacumin jominnan puyanari, ¿tichi mica jochunan? Puyatobi ticanantiya cuwano itochunae yape yaca mansoncarisa. ");
INSERT INTO cofNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","La tsachi ica jun joto lachi anjelilabenan manpatalaiyanae tie. La lachi Apa Diosichi urara tsenbe manpatanae tie. Junni la manpatatobi, piyanlelachi beconan mancuwanae tie. Sen quiminlachi senca mancuwan, seiton quiminlacari casticaquin, queyanae tie. Junni nulabe tsarasica pachinayoe tie. Nula weyan weyanla inte wiruraminla la mantá tan jananunca quirano fecári puyalaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Junni aman sota ma poletobi, Jesuri Pédrobe Jacóbobe yachi aco Juánbeca tanjito, wa dubi lonue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Junbi lolaitobi, Jesús uyan quiran inue yala quiranasanan. Caforori yo tsancari tsequiniquinue. Camisari fibaquin fibaquin inue tsen cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Junnasa quiranari paluca matu to tsachila quirailainue Moisés manca, Elías manca. ");
INSERT INTO cofNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Junni Pedro yalaca quirato itsantinue: —Miya, chiquilari in dubi rano duque se joe tinue. Nu quisa tinari, pemanca jelen ya quilaquisa! tinue nuchi manca, Moisechi manca, Elíachi manca. ");
INSERT INTO cofNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Junni Pedro tsanque cuenta quinasa, tseban poyo yalaca donue. Junni jun poyobi nechi fiquica itsanque meralaquinue: —Inni lachi munatinun Nao joe tinue. Yaca sen joe tiyoe tinue. Junni yaca meralaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Junni Jesube penenaminlari ya fiquica meráto jele tito, tobi mutsailainue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús mantimini yalachica manjato, taquirato, Mancupalaide! tinue. Jele tilatituna! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Junni yalari manwiruito manquiranari, Jesusiri junte raminue. Moisebe Elíabe manpiyaniica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Junni aman dubi nechi manpatanato, Jesuri yalaca itsanque mantanue: —Nulari dubi quiracaca mobenantiya capatulajona! tinue lari tsachi ica jun joto puyato mansonhino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jesús tsantinunbi, yabe penenaminlari yabe itsanlatinue: —Israelítala tala mantaca micariminlari itsantiminlae latinue: Diosi wenteca jun Cristo tinun tsachica caquenan matu to Elías manjachunae timinlae latinue. ¿Junni tíca tsantiminla jun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Junni Jesuri yalabe beconan manpato itsantinue: —Matu to Elíari manjano jominhe tinue. Ya jato jera manseisa carino jominhe yape la Cristo jasa. ");
INSERT INTO cofNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Junni wari Elías numa jaca jominhe tiyoe tinue. Jaca josanan, mantaminlari ya Elías joeque tenhituto, yaca totesa carilaquinue yalachi tenca munateri nenato. Aman lanan tsachi ica jun joto jun tsanquenan yalabe padeseiichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús tsantinunbi yabe panhaminlari tenhilainue Elías tito Mumunmin Juanca tsantinaminueque. ");
INSERT INTO cofNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesula dubi nechi manpatalainasa, duque tsachila Jesuca méraminlayoe. Junni tsachi manca Jesúchica jato telenhito itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Miya, lachi naoca laquirato manse suwade! nasi. Ya ataque cayaito duque padeseimin joe tie. Pibinan, weyante ninbinan queereimin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Junni nube penenaminlachica tanjayoe yape manse suwalaquisa. Yala mantimini manse suwano podeilaitue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Junni Jesús yaca meráto, itsantie: —Amana mate tsachila Diosica quereituminla joe tie. Natiya seque nenatuminla joe tie. ¿Numasi fecári nulabe penenano joichunan? ¿Numasi fecári nulaca wantaino joichunan? tie. Junni Jesús tsantisi, ataque imin náca tanjasa tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tanjalainunsi yucanchi ococa sonba mantaquee nachibi nechi manlosa. Tsantinunsile, manlonan, manseiniie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aman inale uyanla itolajosanan, Jesube penenaminlari yachica jato panhalaquiyoe niyaito chiquilari ya yucanchi ococa sularino podeilaitununca. ");
INSERT INTO cofNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Junni Jesuri chiquilabe itsantie: —Nulari Diosica tennano cajolajoe tie. Junto ya yucanchi ococa sularino podeilaitunue tie. Nulabe tsarasica pachinayoe tie. Diosica duque tennatutonan, nasiri tennaminla jotori, jera ticatiya quino podeilaichunae. Nula mantimini tsansi nacánantiya tennatulajoe. Aman tsansi nacátiya tennaminla jotori, wa duca mantato, Junchi jide! tilatinari, jiniichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aman ya tsan quiran yucanchi ocolaca sularino tenfe joe. Ano fitunca ito Diosibe rocainola joe. Tsantutori tsan yucanchi ocolaca natiya mansularino podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aman junni Galilea tobi layaito nenaminnan, Jesuri chiquilabe itsantie: —La tsachi ica jun joto puyano joyoe tinue. Tsachi manca laca cuwapochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Junni laca totelaquinan, peman mate mansonhiyanae tie. Junni Jesube penenaminla ya fiquica meráto, duque laquiilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Junni chiquila Capernaum pueblobi felainasa, Diosichi yabi inpuesto cala camin tsachila Pédrochica jato itsanlatie: —¿Nulaca micarimin tsachiri inpuesto cala pecuwamin jun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro janhan tie. Cuwamin joe tie. Tsantisi Pedro manjie Jesube junca panhabi. Junnasa Pedro capatusanan, Jesuri yabe itsantie: —Simón Pedro, ¿nuchi niyaque tenca jan? To mantaminlari inpuesto cala cano munaratori, ¿molaca caminla jochunan? tie. ¿Yalachi tobi tsachilaca caminla jochunan, o uyan tobi nechi jaminlacari caminla jochunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pédrori jun fiquica meráto, uyan tobi nechi jaminlacari calaquichunae tie. Junni Jesús itsantie: —Tsan jonari chiquilari Diosichi tsachila joto, Diosichi yabi inpuesto cala cuwano itolajoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsan josanan chiquilari cuwatunari, pailaichunae. Junni cuwaniquintsan jochunae. Junni nuri wa pipiluca jito, berun poto watsa cade! tie. Jun watsachi fiqui forochi cala pochunae. Paluca tsachilachi tenchi inpuesto cala cuwano michi pochunae tie. Junni ya calaca cato, inpuesto cala cuwade! tie chiquila palucachi tenchi. ");
INSERT INTO cofNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Junni tsanhinunbi Jesube penenaminla yachica jato panhalaquiyoe Diosi mantananun bolon tsachila tala mo fe mantá tan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Junni Jesuri jun fiquica meráto, na mancaca jasa carito, chiquilachi quitsabi wirucarie. Náca quitsabi wirucaritobi ");
INSERT INTO cofNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","itsantie: —Nulabe tsarasica pachinayoe tie. Nula casan tala tenca mancato, nalala cuwenta inola jochunae tie. Tsanhitutori Diosi mantananun tsachi bolonbi nin winotiya podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nalalari fe ichi tituminlae. Junni nalala cuwenta nenamin tsachilari Diosi mantananun bolon tsachila tala fe mantá tanla jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nalala tsanlaca lachi tenchi seque quiminlari laca seque quimin cuwenta jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús man fiquiman micarinato itsantie: —Weyanlari labe cayaica junla jotonan, cumana tenca tan jolajoe nalala cuwenta. Junnan yalaca natiya jutsa quisa carilaquituna! tiyoe tie. Tsachi mancaca wa ila suca cudanle telepoto lamaribi queponari, ¿duque padeseichunaco? Aman ya nalala cuwenta jominla mancaca jutsa quisa cariminla mantimini lamaribi quepoca junca fécari padeseilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Diosica tennatuminlari jutsa quimiyanun tenchi padeseilaichunae tie. Aman jutsa quimiyaminla niya jototiya jonilajochunae tie. Tsannan yalari duque padeseilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Junto nulachi tedechi o nedechi jutsa quiminla jotori, tencachique tedeca o nedeca butunto queponotiya se jono jonhoe tie. Man tederi o man nederi chutotiya Diosibe pesonnato poleno se jochunae; aman palu tede o palu nede chun jototiya, piyatumin ninbi quepoino seitochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jun tsanquenan nulachi cacachi seitonque tenca cato quiratori, tencachique cacaca larinotiya se jono jonhoe tie. Man cacari pototiya Diosibe sonnato poleno se jochunae; paluca caca pun jototiya yucanchi ninbi quepoino natiya seitochunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Junsi Jesús man fiquiman micarie: —Nalalaca natiya yape, epe jolajoeque tenca catulajona! tie. Yalachi anjelila jamochi rato, lachi Apa Diosichi cale numasitiya wiruralarae. ");
INSERT INTO cofNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","12","¿Junni nulachi niyaque tenca jalain? Patsa opisa tan tsachiri opisa mancaca topiyaritori, ¿ti quichunnan? ¿Manneyabi jino itochunan? Aman la tsachi ica jun joto, jun tsanquenan tenca topiyaca nenamin tsachilaca neyato, se laribi jaca joyoe tie. Junni opisa tsacumin nue chunca nueca opisaca epele purato, topiyacaca manneyabi jichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Junni seque meralaquina! tie. Ya opisa topiyacaca manfetori, duque son tichunae. Nue chunca nueca topiyatuto seque raminlaca pansi jochunada. Aman topiyacaca manfeto mantimini, yaca fécari pansi jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Junni nulachi Apa Diosi nalalaca jun tsanquenan tenca camin joe. Mancacanantiya jutsa quito topiyato nenatusa timin joe tie. Jesús opisaca tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Junni Jesús camicarinato chiquilabe itsantie: —Nulachi aco manca nulaca seiton quinari, yachicanan jito, paluito sele cuenta quilaquina! tie. Nulaca meránari, yaca manse patarimin jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nulaca merátunari, uyanlaca manca o palucaca petanjilaina! tie. Uyanla pemeralaquinasanan, monantiya fiqui canbiyaquino podeilaituchunae. ");
INSERT INTO cofNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Junsi ya seiton quimin aco uyanlacanan merátunari, junni Diosichi tsachila layaica junlabenan jera cuenta polarina! tie. Junni yalacanan merátunari, Ya tsachichi parte natiya itolajoyoe tinola jochunae tie. Jana uyan to miyachi tenchi inpuesto cala caminlaca cuwenta seiton joe tintsan jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Junsi Jesús tsantitobi, chiquilabe man fiquiman tsarasica pachinayoe tie: —Nula in tote ticatiya mantalaquinari, jamochinan tsanquenan mantaca jochunae. O in tote nula ticatiya quiniquintsan joe tilatinari, jamochinan tsanquenan mantaca jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Junto Jesús chiquilabe manan manpachinayoe tito itsantie: —Nula palucari o pemancari lachi mantate layailainari, lanan nulabe pejoanae tie. Junni nula tala layaito rocailaina! tie. Paluca nacá jototiya, ticatiya rocainilaina! Man tencari cato rocailainari, lachi Apa Diosi nulaca meráto tsanhisa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Junni Jesús tsanque micarinunbi, Pédrori yachica jato, itsantie: —Miya, ¿laca seiton quimincari niyan ne perdonaintsan jochunan? ¿Siete ne fecári perdonaino joichunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Junni Jesús ya panhacaca meráto itsantie: —Siete necari perdonaituntsan joe tie. Sieteca siete chunca neca perdonaintsan jochunae tiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús Pédrobe tsantisi, jeralelabe itsanque micarie: —Aman nulachi perdonaino miino muquilaquinari, in cuentaca meralaquede! tie. Miya manca yachi tsachilabe cuenta larichi tichunae tie. Aman Diosi yachi tsachilaca mantanato, ya miya cuwenta jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ya miyari yachi tsachilabe jera cuenta larichun manca peyunca tanjasa carichunae. Ya peyun duque animali cala nelorato, ");
INSERT INTO cofNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","natiya mancuwano podeituchunae. Junni miyari ya peyunca, ya ticatiya tanunca, yachi sonaca, yachi nalalaca jera osisa mantachunae yachi cala mancuwasa. ");
INSERT INTO cofNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Junni peyunni wepanato telenhito, Miya tichunae. Nasi camérade! tichunae. Jera pacara manqueyanae tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Miya mantimini ya peyunca duque laquirato, ya nisi neloranuncatiya jera perdonaito, pansi manjiniide! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Junni ya peyun mantimini miyachibi nechi manlonaminnan, manca peyun pejominca quirachunae. Yari miya perdonaicachi cala nasi nacá neloramin jochunae tie. Junni yaca cudanle betepole cato, pacara manquede! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Junni ya peyunni wepanato telenhito, nasi camérade! tichunae. Jera pacara manqueyanae tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tsantinasanan neloranunca mancáchi timin tsachiri te, camératiyoe tichunae. Junto yaca natiya perdonaituto, dosa carichunae pacara manquino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aman yaca dosa carinaminca weyan peyunlari quiralaquichunae tie. Yalari wepanato, miyachica manjito, yabe junca jera cuenta manpolarilaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Junni miyari yalaca merasi, perdonaica jomin peyunca manjasa carito, yaca sonba pachunae tie. Nu natiya seiton peyun joe tichunae. Nu rocainan, lari nu duque neloranunca perdonainiiyoe tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Junni la nuca laquirato perdonaica josa, nunan manca peyuncaman perdonaino jominue tichunae la cuwenta laquirato. ");
INSERT INTO cofNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Junni miya yaca duque paito, dosa carichunae tie yape padeseisa carilaquisa jera neloranunca pacara manquino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús tsanque cuenta polarisi, chiquilabe itsantie: —Lachi Apa Diosi nulacanan jun tsannan quichunae tie. Nula uyanlaca tencabi perdonailaitunari, nulacanan perdonaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús tsanque jera micaritobi, Galilea tobi nechi jito Judea toca jito, Jordán pi man becochi polelaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aman duque tsachilari yachica jaca jominlaca manse suwae. ");
INSERT INTO cofNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Junnasa quiranari fariséolari jato, Jesuca palaque pasa carichique itsanque panhalaquee: —¿Unilalari ti tenchitiya yalachi sonalaca purano mantá jun? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Junni Jesús yalabe beconan pato itsantie: —Diosichi Pilabi itsanque chuteca joe tie: Diosi casale tsachilaca quinato, unila manca, sona manca quinueque chuteca joe tie. Jun tenchi unila tsachi uwaito, yachi apaca, ayanca purato, sona cato, junto unilabe sonabe palunan manca tsachi cuwentari jolajochunaeque chuteca joe tie. Nulanan jun pilaca quiracala jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Junsi Jesús itsantie: —Diosichi Pilabi tsantica jonari, junni unilabe sonabe paluca cuwenta itolajochunae tie; paluca jotonan manca tsachi cuwenta jolajochunae. Junni Diosi patsa unilabe sonabeca cayaisa carimin joe. Jun tenchi unilala yalachi sonalaca puranola itoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Junni fariséolari Jesús tsanticaca beconan pato itsanlatie: —Tsan josanan Moiseri Diosichi Pilabi chuteto, sonalaca purano podeintsan joeque chutenue. Sonaca purachi timinlaca mantanue latie diborsio pilaca quisa carito puraniquintsan joeque. Sonaca natiya puratuno jomanpari, Moisés tsantituno jomin jonhoe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Junni yala tsanlatinunsi, Jesús itsantie: —Nulari merátuchi timinla joe tie. Jun tenchi Moisés nulaca sonaca purasa cariniquinue tie. Tsan josanan Diosiri casale casale tsachilaca quinasa mantimini, tsanque itominue; puratuntsan jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Junni lari junca itsantinayoe tie. Tsachilachi sonala uyan unilalabe seitonque nenalaratunari, sonalaca puratuntsan joe. Tencachique sonaca purato uyan sona mancaminlari seiton quiminla jochunae. Junsi puraca jun sonaca mancaminlanan seiton quiminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Junni Jesús tsantinan, yabe penenaminla itsanlatiyoe: —Sonalaca natiya puranola itonari, junni casalaituto mancari nanano fe se jochunae latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Junni Jesús itsantie: —In fiquica jeralela meránola itochunae tie. Manca mancaca mantimini Diosi in fiquica merása carichunae tie. Yalasiri meralaquichunae tie. Itsanque joe: ");
INSERT INTO cofNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tsachila manca manca na ica mánta yucapiyaca joto, sona cano podeituminla jochunae. Junsi manca mancacari weyan tsachila yucapiyarilaquichunae yape sona cano podeilaitusa. Junsi manca manca sona cano pode jotonan, Diosi mantananun tsachi bolon serawochun sona catuminla jochunae tie. Ya fiquica meráno junlari meránola joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Junni aman weyan tsachila nalalaca tanjanaminlae yape Jesús yalaca tedechi tale quito Diosibe rocaisa. Junni Jesube penenaminlari nalalaca tanjatusa tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Junni Jesús chiquilaca quirato itsantie: —Nalalaca lachica jasa carinilaquede! Nalalaca natiya jatusa tilatitude! Yala tsan tsachilari Diosi mantananun tsachi bolonbi pejolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Junto Jesús nalalaca tedechi tale rato Diosibe rocaisi jie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Junni aman tsachi manca Jesúchica jato itsantie: —Nu sen joto micarimin joe. Junto labe pade! tie. Titiya senca quino muquee numatotiya Diosibe sonnato polechun. ¿Junni lari niyan quino jowan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuri yaca meráto, beco manpato itsantie: —¿Niyaito laca sen joe tiyun? tie. Diosisiri sen joe. Aman numatotiya sonnato poleno muquinari, Diosichi mantaca meráto nenana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Junni ya tsachiri ¿Ti mantaca tiyun? tie. Junni Jesuri itsantie: —Tsachilaca totelaquitunaque, uyan sonalabe nosa seitonque nenatulajonaque, tarinlaquitunaque, uyanlaca nene patulajonaque, ");
INSERT INTO cofNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","apabenan ayanbenan sen jolajonaque, tencachique laquiranun cuwenta uyanlacanan jun tsansinan laquiralaranaque mantaca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Junni Jesuchi fiquica merasi, ya tsachiri itsantie: —Na mánta ya mantaca jera meráto nenamin joyoe tie. ¿Ti quino cajowan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Junni Jesús itsantie: —Jera sen patsa ino muquinari, manjito, titiya tanunca jera osina! tie. Junto jun calaca poperelachi jera cuwana! Tsantori, nu Diosichi tobi duque senca tachunae tie. Junto calaca jera cuwatobi, lachica manjato labe penenana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Junni ya tsachi jun fiquica meráto, duque laqui manjie. Yari duque oco tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Junni ya manjinunsi, Jesús yachi tsachilabe itsantie: —Nulabe tsarasica pachinayoe tie. Fe oco tsachilari Diosi mantananun tsachi bolonbi pewino duque tenfe jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Manan mantsantichinayoe tie. ¿Cameyo acusa forose numanan poleno podeituchunaco? Aman oco tsachila Diosichi bolonbi pewino, junca fécari tenfe jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Junni Jesube penenaminla ya fiquica meráto, wepanato itsanlatiyoe: —Oco tsachilatiya wino podeitulajonari, monantiya se lono podeitulajochunae tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Junni Jesuri chiquilaca tulan quiranato itsantie: —Tsachilari tenca mánta monantiya se lono podeilaituchunae tie. Tsan josanan Diosiri jera quino podeichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Junni Jesús tsantinunsi, Pédrori yabe itsantie: —Meráde! Chiquilari nube penenachun jera tanunca puralaquiyoe tie. ¿Junca puranun tenchi tíca calaqueichunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuri Pédrobe beconan pato itsantie: —Nulabe tsarasica pachinayoe tie. Manca mate jerale to casan ichunae tie. Jun mate la tsachi ica jun joto tsara sen mantá tan joto chudiyanae tie mantachun. Aman jun matenan nulanan chunca paluca mantato chudinunbi pechudilaichunae. Nula chunca paluca bolon israelítalaca mantato chularachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Junni weyan tsachilanan lachi tenchi ticatiya puraca jotori, duque mancanola jochunae tie. Yaca, o acolaca, o soquilaca, o apaca, o ayanca, o nalalaca, o toca labe penenachun puraminlari patsa tsansi mancato, junsi numatotiya Diosibe sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aman duque tsachila amana mate mantá tanla jotonan, jun mate epe tsachila jolajochunae tie. Uyanlari amana mate epe tsachila jolajotonan, jun mate mantá tanla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Junto Jesús camicarinato itsantie: —Diosi mantananun tsachi bolonni uba wita cuwenta jochunae tie. Jun wita tsacumin quepenan peyun neyabi jichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Junni peyunlaca cato, man malon quinun tenchi pacara queyanae tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Junsi aman yotu inasa wita tsacumin manlato quiranari, uyan peyunlanan mercadote wiruralarachunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Junni yalacanan uba witaca erechunae pacara quino jonunca queyanae tito. Junni yalaman jilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Junsi yotute manlato, quebi inasa manlato, uyan peyunlaca jun tsanquenan cato erechunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Junni sinco de la tardete manlato quiranari, uyanlanan epe wiruralarachunae. Yalabe itsantichunae tie: ¿Niyaito man malon epe wiruralarayun? tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yalaca monantiya catulajoe latichunae. Junni wita tsacumiri yalacanan jinilaide! tichunae. Lachi witabi quilaquede! Pacara quino jonunca queyanae tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Junni deino órate tsacumiri mayordomobe itsantichunae tie: Peyunlaca jasa tito, pacara quede! tichunae. Junni benechi jaminlachi casale pacara quito, casale jaminlachi benechi cuwade! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aman benechi jaminlachi man malon entero tenchi pacara quiniquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Junni casale jaminlari junca quirato, yalachi fécari cuwano jochunae latichunae. Junni te, yalachi fécari cuwatuchunae. Yalachinan man malon tenchisiri cuwachunae tie benechi jaminlachi cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Junni ya cala cato, tsacuminca paito, ");
INSERT INTO cofNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","itsanlatichunae tie: Inlari man órasiri quilaquee latichunae. Chiquilari wari man malon sonba quilaquiyoe pata chibanbe. Tsan josanan chiquilachi cuwenta yalachinan jun tsansinan pacara quiniquee latichunae tie. Seitoe latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Junni tsacumiri yalabe beco pato itsantichunae: Amicola, nulaca seiton quitiyoe. ¿Nulari tsansibe man malon queyanae titulajoyun? tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Junni tsansicari cato manjinilaide! Lachi tenca munate weyan peyunlachi nulachi tsansinan cuwaniqueyanae tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lachi calaca la epe cuwano muquinari, cuwaniqueyanae tichunae tie. ¿La seque quinaminca nulari niyaito pailainayun? tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesús tsanque to tsacuminca cuenta quetobi, tsachilabe itsantie: —Diosi jun tsanquenan jochunae tie. Duque tsachilaca yabe cayaisa tichunae. Tsan josanan narin tsachila yabe wentaito tsa cayaiminla jochunae tie. Weyanla amana fela jotonan, jun mate epe tsachila manjolajochunae. Weyanlari amana epe tsachila jominla jun mate fela jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Junni aman Jesula Jerusalén puebloca jinaminlayoe. Jilainato, Jesús yabe chunca paluca penenaminlaca chican larito, chiquilabe itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Meralaquede! tie. Chiquila Jerusalenca jilainayoe. Jerusalenbi fetobi, tsachi manca laca cuwapochunae tie. La tsachi ica junca osichunae tie yape israelita mantaminla laca calaquisa. Mantá tan patelelabe mantaca micariminlabe laca cato, totentsan joe tilatichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Junto laca uyan to mantaminlachi cuwapolaquichunae tie. Junni uyan to tsachilari laca lucarin, asota quin, corosibi toten, quilaquichunae. Tsanquica josanan, peman mate mansonhiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Junni Jesube penenaminla palucari Zebedéochi naola jominlanue Jacobo manca Juan manca. Aman yalachi ayanni yalaca tanjato, Jesuchi cale telenhie rocaichun. ");
INSERT INTO cofNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Junni Jesús ¿Ti munarayun? tie. Junni ya sonari yachi paluca naolachi tenchi rocaie yala Jesuchi fe quelole pechudito fe mantá tan jolajosa. Mancaca tsa tede nanchi chutesa, mancaca jala tede nanchi chutesa rocaie. Jesuri miya itobi ya palucaca tsanque mantá tan suwasa rocaie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Junni Jesús yalabe beconan pato itsantie: —Nulari miitoto tsanque rocailainae tie. ¿Nulanan la cuwenta pepadeseino podeilaichun? tie. Jesús tsantinunsi, yalari podeilaiyanae tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Junni Jesuri yalabe itsantie: —La cuwenta nulanan padeseilaichunae tie. Tsan josanan lachi tsa tede nanchi mantato chudisa, o lachi jala tede nanchi mantato chudisa la mantano podeitiyoe. Lachi Apa Diosiri mantachunae tie moca labe pemantano jonunca. Diosi mantaca junla ya mantá talarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aman weyan chunca Jesube penenaminlari junca meráto, paluca acolaca pailaiyoe fe mantá tanla jochi latinaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Junni Jesús chiquilaca jalaide! tito itsantie: —Diosica tennatuminla tala mantaminlari duque sonbaque mantaminla joe. ");
INSERT INTO cofNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Junni nula tala mantimini uyan quiraque jolajona! tie. Nula tala fe mantá tan jochi timinlari weyanlachi peyun cuwenta jonola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nula tala fe jochi timinlari uyanlabe mantaimin cuwenta jonola joe tie. Tsanque fe jono podeilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","La patsa tsachi ica jun joto, peyunlaca mantaquebi jatucayoe. Lanan peyun cuwenta nenabi jacayoe tie. Duque tsachilachi tenchi puyabi jacayoe tie yape casticailaitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Junni aman Jericó pueblobi nechi manjilainasa, duque tsachila chiquilabe pejinaminlae. ");
INSERT INTO cofNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Junni paluca quirano podeitonla minute chuminlanue. Junni yalari Jesús jananunca meráto, yaca otito, Miya tilatie. Matu to miya Davichi alica joto, chiquilaca laquirato ayudaide! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Junni uyan tsachila yalaca paito, tsanque patulajode! Nosasailaide! tilatinasanan, yalari nantanancari sonba otinilatie. Miya, matu to miya Davichi alica joto, chiquilaca laquirato ayudaide! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Junni Jesús wiruito, yalaca jasa tito, ¿Nulaca niyan quisa tenjalaquin? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Junni quirano podeitonlari Miya tilatie. Manquirano podeino muquilaquee tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsanlatinunsi Jesús yalaca laquirato cacaca taquirae. Taquiranunsi manquirano podeilaie. Junto yabe penenamin ilaie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Junni chiquila Jerusalén puebloca jilainaminnan, Betfagé tinun pueblo minu winte felaiyoe Olibo tinun du quelote. Junto Jesús yabe penenaminla palucaca erenato, ");
INSERT INTO cofNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yalaca itsantie: —Ja pueblobi wilaide! tie. Junbi wito quiranasari, burobe nabe tela jun wirurachunae tie. Yaca wolecato lachica tanjalaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Junni tsachila nulabe ¿Ti quichun tsannato? latinari, Miya buroca munarae tilatina! tie. Moora manherechunae tilatina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","Junni Jesús ereca junlari ya pueblobi wito, buro nabe telaraminca wole cato tanjalaie. Junni tanjanunsi, buro nabi yalachi tsanpaca nancarinan, Jesús chudie. Aman matu mate Diosichi mantate pamin tsachi junca pila chuteca jominue. Jun pilabi Jerusalén puebloca Sion mumun tito, itsanque chuteca jominue: Sionbi chuminlaca meracarilaquina! tinue. Quiralaquede! Nulachi Miya fechinae tilatina! tinue. Mantá iton cuwenta burobiri jachinae tilatina! tinue. Aman matu mate Diosichi Pilabi tsanque chuteca josanan, jun tsanquenan patinue Jesús ya burobi chudito jananun. ");
INSERT INTO cofNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Junni Jesús burochi janasa, duque tsachila yalachi panu tsanlaca minubi lowalaquee yape miya jananun minu uraran josa. Weyanlari japisuca porecato, minubi lowalaquee yape uraran minu josa. ");
INSERT INTO cofNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Junni duque tsachila Jesube pejanaminlayoe. Weyanla yachi caquele, weyanla yachi benele janaminlayoe. Jalainato otito Jesuca itsanlatiyoe: —Inni matu to miya Davichi alica joe. Biba latiyoe. Miya Diosichi mantabe janaminca seque pantsan joe. Diosicanan biba quintsan joe latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Junni tsachila tsanque otilatinasanan, Jesús Jerusalenbi tsanque winasa, jerale jun pueblobi chuminlari wepanato, ¿Tiyan janhinan? latinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aman Jesube pewiminlari manpato, Jesús joe latiyoe. Nasaret pueblobi nechi, Galilea tobi nechi joto, Diosichi mantate pamin tsachi joe latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Junni Jesús Diosichi yabi manwito, jerale junbi osinaminlacanan, canaminlacanan sularieree. Calaca waladaanun mesacanan, paloma osito chununcanan jera tulipoereto cuwae. ");
INSERT INTO cofNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tsanquinato itsantie: —Diosichi Pilabi chuteca joe tie Diosichi ya Diosibe rocainun ya jochunaeque. Diosichi Pilabi tsantica josanan, nulari in yaca tarinnun ya cuwenta suwacala joe tie. Diosichi yabi necosio quiminlabe tsantie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Junni jancanlabe quirano podeitonlabe Jesúchica janan, yalaca manse suwae. ");
INSERT INTO cofNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jesús tsanque duque sen quinaminue. Junni nalala weyanla yaca Diosichi yabi quirato se tinaminlanue. Sonba pato ya sen joe latie. Matu to miya Davichi alica joto duque sen joe latie. Tsanlatinasanan mantá tan patelelabe, israelítala tala mantaca micariminlabe, jalaie. Junni ya mantaminlari nalala tsanque se tilatinaminca meráto paito, ");
INSERT INTO cofNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesube itsantilatie: —¿Ya nalala epe pánanunca meranayun? latie. Jesús meranayoe tisi, yalabe itsantie: —¿Nulari niyaito Diosichi Pilaca miitolajoyun? tie. Junbi itsanque chuteca joe: Diosi nalalacanan micarichunaeque chuteca joe yape jera seque se tilatisa. ");
INSERT INTO cofNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Junni Jesús yalabe Diosichi Pilabi chuteca jun fiquica tsanque manpasi, jito polee. Jerusalenbi nechi manloto jito, Betania pueblo nacabi catsobi jie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Junni ayuna nanchi quepenan Jesús Jerusalenca manjinasa, yachi ano muquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jun quiranari minu quelole ico pele chuminue. Junni aman ico pucaca cabi jinasa, te, itominue. Japisu chutonan, pucari natiya itominue. Junni Jesús junca quirato ya ico peleca itsantie: —Amanale nechi in pelebi puca manhituchunae tie. Jesús tsantinunbi, ico pele moora jequeiniinue. ");
INSERT INTO cofNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Junni Jesube penenaminlari yaca manquirato, wepanato itsanlatiyoe: —¿In ico peleri niyaito moora jequen chun? latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Junni Jesuri chiquilabe beconan itsantie: —Nulabe tsarasica pachinayoe tie. Palaque tenca catuto, Diosica tennanola joe. Tsarasi Diosica quereitori, nula in ico peleca jeque suwano jonunca fécari tenfe jonunca quilaquichunae tie. Ja wa ducatiya mantato, Jalitaito lamaribi quepoide! tito, queposuwano podeilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ticatiya Diosibe rocailainari, tsanquiniquichunae tie Diosica tsarasica tennaminla jonari. ");
INSERT INTO cofNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Junni Jesús Diosichi yabi wito micarinaminhe. Micarinasanan, mantá tan patelelabe, mantamin israelita unicalabe, yachica jalaito itsanlatie: —¿Nuri mochi mantate micarinayun? ¿Mo nuca mantaquin? latie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Junni Jesús yalachi fiquica meráto, itsantie: —Casale la nulabenan man fiqui panhachinayoe tie. La panhanunca palaquinari, lanan nulabe pánae tie ti mantate micarinayoeque. ");
INSERT INTO cofNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jesús tsantisi, israelita mantaminlabe itsanque panhae: —¿Mumunmin Juanni mochi mantate mumunnamiyan? tie. ¿Diosichi mantate, o tsachilachi mantateri mumunnamiyan? tie. Junni Jesús tsantinunca meráto israelita mantaminlari chicanle tenpato itsanlatin tie: —¿Niyan ticaichunan? Juanca Diosichi mantate mumunnaminhe tituntsan joe. Chiquilari tsanlatinari, ¿Niyaito yaca quereilaitiyun? tichunae latin tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Junsi Juan Diosichi mantá itominue latinari, epe tsachila chiquilaca pailaichunae latin tie. Yalari Juanca pato, Diosichi mantate pamin jominhe timinlae. Junni yalaca jelechi Juanca Diosichi mantate patumin jominhe tituntsan joe tilatin tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Junni mantaminlari tsanque tenpatobi, Jesube manpato itsanlatie: —Miituntsan joe latie. Mumunmin Juan Diosichi mantate mumunnamin jonunca, o tsachilachi mantate mumunnamin jonunca miituntsan joe latie. Junni Jesuri lanan nulabe pátiyoe tie la mochi mantate micarinanunca. ");
INSERT INTO cofNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Junni Jesús israelita mantaminlabe tsantisi, in cuentaca meráto tenca calaquede! tie: —Tsachi manca paluca naola tachunae tie. Mancachica jito, Nao tichunae. Amana witabi jayaquebi jide! tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naori jitiyoe titonan, wanbile tenca mancato jichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Junni apa manca naochica jito, yacanan jayaquebi jide! tichunae. Yari Apa, jichinayoe titonan jituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Junni tenca calaquede! ¿Nun nao yachi apa mantananunca merámin jochunan? tie. Israelita mantaminlari junca meráto, Casale mantaca jun naori merámin nao jochunae latie. Junni Jesuri yalabe itsantie: —Junni nulabe tsarasica pachinayoe tie. Nulari jitumin nao cuwenta jolajoe. Mumunmin Juan nulachica jato, tuca micarinaminhe. Tsan josanan nula quereitulajoe. Niyan unilalabetiya seiton imin sonalatiya yaca quereilainue tie. Uyan to miyachi tenchi inpuesto cala caminlanan seitonla jotonan, Juan pacaca quereilainue. Junni nulari junca quirato, nulanan jutsa quinunca telaquepoto, Juanca quereino jominlanue. Tsan josanan tsantulajoe. Junni nulari quereituto purailainasanan, yalari seiton jominla jotonan Diosi mantananun tsachi bolonbi pewinilainae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Junsi Jesús israelita mantaminlabe tsanque cuenta polaritobi, manca cuentacaman meráto tenca calaquede! tie: —Diosi wita tsacumin cuwenta jochunae tie. Aman casale casaleri ya tsachi uba wita quisa carichunae tie. Junni wita awinta serica quin, uba pi larinun foro quin, witaca quirato chuchun ya quin, quisa carichunae. Junni jera sequetobi, ya wita uyan tsachilachi quitsa quitsa cachun cuwato, bareca chubi jichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Junni uba cano mate peyunlaca barebi nechi erechunae yape wita cuidaiminlari quitsaca cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Junni wita cuidaiminlari peyunlaca cato, mancaca chidechi quin, mancaca toten, mancaca su walaca quin, quilaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Junni tsanlaquinan, wita tsacumiri fe duque peyunlacaman erechunae tie. Junni yalacanan jun tsannan quilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Junsi wita tsacumin yachi naocaman erechunae yacari respetailaichunae tito. ");
INSERT INTO cofNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wita cuidaiminla mantimini yachi nao janaminca quirato, yala tala itsanlatichunae: Ja mosori tsacuminchi nao joe latichunae tie. Yari ina tsacumin ichunae. Yaca totebi jisa! latichunae yape wita chiquilachi puraisa. ");
INSERT INTO cofNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsantisi tsacuminchi naoca cato, wita dechi quepoto, totelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Junni Jesús tsanque cuenta quetobi, israelita mantaminlabe itsantie: —Ya wita tsacumin manjatobi, ¿nulachi tencari ya cuidaiminlaca niyan quino jochunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yalari beconan pato itsanlatie: —Ya seiton cuidaiminlaca toteniquito, witaca uyanlachi quitsa cachun mancuwachunae latie. Tsacuminchi seque ubaca quitsa cuwano junlachi mancuwachunae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Tsantinunsi Jesús itsantie: —Tsa tilatie. Junni nulari ya seiton cuidaiminla cuwenta jolajoe. Junni Diosi yachi mantaca nulachica manjosoleto, uyan to tsachilachi mancuwachunae. Uyanla yabe cayaito, seque nenalarachunae. Aman man fiquiman meralaquede! Quepoca jun suca Diosichi Pilabi chutecaca quiraminla jonhoda. Itsanque chuteca joe: Suca ya quiminlari su mancaca seitoe tito quepolaquichunaeque chuteca joe. Juntonan tsanquicala josanan, wanbile ya suri fe munaranun sen su jochunaeque chuteca joe. Miya Diosi tsanhisa carichunae tinue. Junca quiraminla tsara sen joe tilatichunaeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Junni Jesús Diosichi Pilabi chutecaca tsanque manpato, la jun su cuwenta joyoe tie. Junni jun subi tutulaito quepoiminla cojilaichunae tie. Jun su jamo queereinari, dilaito puyalaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesús tsanque micarinato, israelita mantaminlaca seitolajoe tinaminue. Junni mantá tan patelelabe fariséolabe junca tenhito ");
INSERT INTO cofNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","yaca dochi latie. Weyan tsachilari Jesuca se joe timin jominlanue. Diosichi mantate pamin joe timin jominlanue. Junni mantaminlari Jesuca dolaquitue tsachila pailaichunaeque jelechi. ");
INSERT INTO cofNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Junni aman Jesús chiquilabe itsanque cuenta manpolarie: ");
INSERT INTO cofNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Miya manca yachi nao casalainasa, fiesta quichunae tie. Junni Diosi tsachilachi Miya joto ya miya cuwenta jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya miya peyunlaca erechunae yape fiesta quirabi jano junlaca manmeracarisa. Jano jominla mantimini jatuchi latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Junni man weyan peyunlaca manherechunae. Yalari jano junlabe itsanlatichunae: Meralaquede! Ano numa caya joe latichunae tie. Wala mulun suwacaca totesa carica joe. Jera seca joe latichunae fiesta quichun. Junto miya nulaca jasa tie latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aman jano jominlari yalaca meráto, tennatulajochunae. Manca yachi wita minu, manca yachi necosioca jinilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Uyanla wari meracuwabi janaminlaca padesecarito totelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Junca miyari paito, soldadolaca erechunae tie. Soldadolaca ereto peyunlaca toteminlacanan mantotesa carichunae tie. Junsi yalachi pueblocanan nin posa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Junni tsansa caritobi, miya yachi peyunlabe itsantichunae: Fiesta caquintsan joe tichunae. Jano jominla wari lachi fiestaca quirabi jatun tsansi seiton jominlae tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Junto minuchi erechunae yape moca tulaitotiya jera tanjanilaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Miya tsantinan, peyunlari minuse nenato niyanlacatiya tulaisi tanjanilaichunae tie. Senlacanan, seitonlacanan tanjalaichunae tie. Tsanhinansiri fiesta quinanun tamobi quidiichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Junni fiesta quilaquinanun tamochi miyanan wichunae jaca junlaca quirabi. Jun quiranari, tsachi manca jeralela fiestate ponun camisaca poca itochunae tie. Junni miyari yaca quirato ");
INSERT INTO cofNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","itsantichunae: Amico, ¿fiestate ponun camisaca niyaito potuchi tiyun? ¿Niyaito yaca potuminnan pewiyaniiyun? tichunae. Junni ya tsachiri beco pano podeituto, nosa chunirachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Junni miyari ano poto cuwaminlaca mantachunae jun tsachica urachi manlarilaquisa. Tedele, nedele teleto, urachi nemen minu quepolaquede! tichunae tie. Jun nemen minu tsachila padeseinato fudachi warelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Junni Diosi mantananun bolon tsachila jun fiesta quirabi jaca junla cuwenta jolajochunae. Diosi duque tsachilaca yabe cayaisa timin joe tie. Tsannan narin tsachila yabe wentaito tsa cayaiminlae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús tsanque micarinunbi, fariseo mantaminla layaito tenpalaquinue. Jesuca niyaque palaque pasa carino jonunca tenpalaquinue yaca falta patarichun. ");
INSERT INTO cofNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Junto tsachilaca erelaquinue yape Jesube cuenta quito, yaca palaque pasa carichique tenfelaisa. Weyanla fariséolabe penenamin jominlanue; weyanla miya Heródebe penenamin jominlanue. Yalari Jesúchica jato itsantilatie: —Chiquila miralarayoe latie nu tsarasica micarimin joeque. Tsachila niyaquetiya palaquinanunca tennatuto, Diosichi minuca tuca micarimin joe. Mantaminla, epe tsachila, nuberi jun tsannan jolajoe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Junni Jesube tsantisi, jerale toca mantamin romano miyaca panhato itsanlatie: —¿Chiquilari ya uyan to miyachi inpuesto cala cuwanola join? latie. ¿Nuchi niya quiraque tenca jan? Paniquede! latie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Juntonan Jesuri tenhinue yaca falta patarichique tsanlatinaeque. Junto yalabe itsantie: —¿Nula niya jonan laca palaque pasa carichi tilatinayun? tie. Nulari otoque pánatonan, seiton tenca jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Junni inpuesto calaca lachi quirawode! tie. Junni cala manca tanjanan, ");
INSERT INTO cofNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesuri jun calaca quirato itsanque panhae: —¿In calabi mochi misu, mochi mumun chunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jesús tsantinan, yalari Ya romano miyachi joe latie. Tsanlatinunsi Jesús itsantie: —Tsan jonari, miyachi cosateri yaca meralaquina! tie. Aman Diosichi cosateri Diosica meralaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jun fiquica wepanato meráto, yaca telato manjinilaie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Man bolon israelítala uyan quiraque tenca caminla joto, puyacalaca mansonhitulajochunae timinla joe. Tsantiminlaca saduséola tinunla joe. Junni jun matenan saduséola Jesúchica jato yabe ");
INSERT INTO cofNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","itsanlatie: —Nu micarimin joto, chiquilabe pade! latie. Matu tote Moisés israelítalaca itsanque mantanue Diosichi mantate: Manca aco na caitonan puyanari, benechi acoman ya sonabe casalaino jochunae tinue latie aco puyan ocochi tenchi na tachun. ");
INSERT INTO cofNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Junni chiquilachite sieteca acola jominlanue latie. Caque acori sona cato, na caitonan puyae latie. Junsi benele acoman caque aco puyan ocochi sona jominbe casalaito, ");
INSERT INTO cofNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","yanan na caitonan puyanue. Junsi nantanan benechi acoman jun tsannan inue. Jun tsanquenan sieteca acola jera depoleto puyalainue latie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Junsi acola jeralela puyalainunbi, sonaman na caitonan puyae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Junni saduséolari Jesube tsanque cuenta polarito, itsanlatie: —Aman ya sonari sieteca acolabe casalaica jomin joto, ¿puyacala mansonhino mate mochi sona jochunan? latie. Junbe tenhintsan joe latie puyaca junla mansonhilaituchunaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jun fiquica meráto, Jesús itsantie: —Nula Diosichi Pilabi chuteca fiquica miitolajoe tie. Diosi tsaracari sonba quimin joequenan miitolajoe tie. Junto palaque tenca calaquinae. ");
INSERT INTO cofNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Puyacala mansonhito, unilala sona mancalaquituchunae tie. Sonalanan unila manquilaquituchunae tie. Diosichi tobi anjelila cuwenta chularachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Junsi Jesús itsantie: —Aman puyaca junla mansonhinola jonunca cacuenta quilaquisa! tie. Diosi patsanan nulabe junca paca joe yachi Pilabi. Jun fiquicanan nula quiraminla jonhoe. Puyaca junlaca pato Diosi itsantinue tie: ");
INSERT INTO cofNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","La matu to Abrahanchi, Isaachi, Jacóbochi Diosi joyoe tinue tie. Juntonan Diosi puyaca junlachi Diosi itoe; sonnaminlachi Diosi joe. Junto Abraham, Isaac, Jacobo puyaca jotonan, Diosichibi casonnan chularae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús tsanque micarinaminca tsachila wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Junni fariséola meralaquinue saduséolari Jesube beco manpano podeilaitunueque. Junca meráto, yalaman Jesúchite layailaie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Junni fariseo manca Diosichi mantaca duque miramin joto, cuenta quee. Jesuca palaisa carichique itsanque panhae: ");
INSERT INTO cofNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Nu micarimin joto, chiquilabe pade! tie. ¿Nun mantá fécari merántsan mantá jun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Junni Jesuri beconan tulanto itsantie: —In mantá fécari merántsan mantá joe tie: Nulachi Miya Diosica jera tencabi tsarasi laquiranola joe tie. Misubinan tsaracari laquirato, sele tenca cato laquiranola joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ya fiquiri fécari merántsan mantá joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Junto jun benele mantá jun cuwentanan joe. Yari itsanque joe: Nula tencachiqueca laquiranun cuwenta, quiranunlacanan jun tsansinan laquiralarana! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","In paluca mantá fe merántsan joe tie. In mantaca meráminla jotori, jerale Diosichi mantaca meráminla jochunae tie. Diosichi mantate paminlachi fiquicanan jera meráminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Junni fariséola yachi awinta wiruralarasa, Jesús yalabenan itsanque panhae: ");
INSERT INTO cofNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Diosi wenteca Cristo tinunca niya quiraque tenca calaquiyun? ¿Mochi alica jochunan? tie. Aman fariséolari Jesube manpato, matu to miya Davichi alica jochunae tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Junni Jesús itsantie: —Davichi alica jono jonari, ¿niya jonan David patsa yaca Miya tinun? tie. Diosichi Tencachi mantate pato, Daviri Crístoca Miya tinue. Itsanque Diosichi Pilabi chuteca joe: ");
INSERT INTO cofNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Miya Diosi lachi Miyaca mantachunae tinue yape yachi tsa tede nanchi chudito yabe pemantasa. Nuca fe losa cariyanae tichunae. Junni junte mechude! tichunae tinue nuca pa jominlaca fe losa carino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Junni Jesús Diosichi Pilabi chutecaca tsanque manpasi, itsantinue: —Aman junni Cristo tinun tsachi miya Davichi alica jonari, ¿niyaito Davinan yaca Miya tinun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Junni Jesús tsantinunbi, niyanlanantiya beconan manpano podeilaitue. Juntele nechi niyanlanantiya yabe manpanhalaquitue luchi. ");
INSERT INTO cofNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aman Jesube penenaminlabe duque uyan tsachilabe junte peraminlayoe. Junni Jesuri chiquilabe itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Israelítala tala mantaca micariminlacanan, fariséolacanan, nulabe pachinayoe tie. Yala Diosichi mantaca micariminla joe matu to Moisés mantá chutecaca. ");
INSERT INTO cofNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Junnan yalachi fiquica meralaquina! tie. Juntonan yala micaricaca merátonan, yala cuwenta natiya nenatulajona! tie. Seque nenasa mantaminla jotonan, yalanan tsanque seque nenatuminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tsachilaca sonbaque mantamin jolajoe duque jadonca panarinun cuwenta. Yala mantimini tsachila jadonca panananun tsanca natiya peayudaituminla joe; sonba mantanatonan, yalari jun mantaca tennatuminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ticatiya jera quiminla joe yape tsachila yalaca quirato sen jolajoe tilatisa. Weyan israelítala Diosichi Pila chutecaca papabi poto, tedebinan, lesubinan teleminlae. Junsi fariséolabe mantaca micariminlabe mantimini jun papaca fécari ayancan quiminla joe weyanlaca fe sen jolajoyoe tito. Fe baren seyun chun camisa pominla joe tie fe sen jolajoyoe tito. ");
INSERT INTO cofNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiestatenan, Diosichi fiqui miinun yabinan, fe mantá tanla chudinunbi chudichi timinla joe tie fe sen jolajoyoe tito. ");
INSERT INTO cofNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Duque tsachila nenanunte yalaca duque respetaito saludaisa munaralarae. Yalaca micarimin tisa munatiminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Junni nula mantimini natiya tsanhitulajona! Nula tala saludainato micarimin tituntsan joe. Diosi wenteca Cristo tinuncasiri micarimin tinola joe. Nula jeralela man parejo jolajoe acola cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tsachila tala uyanlaca apa titulajona! Jamochi chuminsiri nulachi Apa tinun jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Junsi nula tala miya tituntsan joe. Cristosiri nulachi Miya joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nula tala peyun cuwenta ito ayudaiminlari fe sen jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tencachique fe joyoe timinlaca Diosi epe tsachi mansuwachunae tie. Fe joyoe tituminlaca mantimini Diosi fe josa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Junsi Jesús chiquilaca tsanque micaritobi, israelita mantaminlabe itsantie: —Mantaca micariminlabe fariséolabe, nulari fe sen jolajoyoe timinla jotonan, duque padeseilaichunae tie. Nulari tsachilaca seitonque payiminla joe yape Diosibe cayailaitusa. Nula Diosibe cayaituto, weyanla cayaichi timinlacanan cayaisa carituminlae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nula fe sen jolajoyoe titonan, duque padeseilaichunae tie. Biudalachi yaca nosa josoleminla jotonan, Diosibe wanca rocaiminla joe yape tsachila nulaca quirato duque sen jolajoe latisa. Tsanquinun tenchi nulari nantanancari casticailaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fe sen jolajoyoe timinla jotonan, duque padeseilaichunae tie. Nulari lamari becochi jito, bare tobi nenato, duque tenfeminla joe uyanlacanan nula cuwenta suwachique. Junto tsachilaca nula cuwenta suwatobi, yalaca nantanancari nulaca fe seitonla suwaminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Junni Jesús capánato itsantie: —Nulari telatuchun trato quichun itsantiminla joe tie: Diosichi yabi tsomin oroca tenca canato, juraquito pánayoe tintsan joe timinla joe tie. Tsanque óroca paminlari nene panola itochunae timinla joe tie. Oroca pato trato quica junca mantelatori, culpa patilaichunae timinla joe tie. Junnasa mantimini aman oroca patuminnan, Diosichi yacari juraquito panari epe fiqui jochunae timinla joe tie. Tsanque paminlari nene pato, trato quica junca mantelatori, natiya culpa itolajochunae timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¿Nula tenca itonla jotiyun? Ya orori epe joe. Oroca Diosichi sen yabi tsonun tenchi Diosichi oro ito, jun tenchisiri fe sen imin joe tie. Nula mantimini Diosichi sen yaca epe joe tito, epe óroca fe sen joe timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Junsi nulari manca tenca iton fiquicaman paminla joe. ¿Aman Diosichi yabi Diosichi titiya epe cuwanun mesa tsoco? Junni nulari telatuchun trato quichun, Diosichi epe cuwaca junca tenca canato juraquito pantsan joe timinla joe tie. Diosichi cuwaca jonunca tsanque paminlari nene panola itochunae timinla joe tie. Epe cuwacaca pato trato quica junca telatori, culpa patilaichunae timinla joe tie. Junnasa mantimini aman epe cuwacaca patuminnan, Diosichi titiya epe cuwanun mesacari panari, epe fiqui jochunae timinla joe tie. Tsanque paminlari nene pato, trato quica jomin mantelatori, natiya culpa itolajochunae timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¿Nula tenca itonla jotiyun? tie. Ya cuwanun cosari epe joe. Ya cosa Diosichi sen mesabi tsonun tenchi Diosichi cosa ito fe sen joe tie. Nula mantimini jun sen mesaca epe joe tito, epe cuwanuncari fe sen joe timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Junni Diosichi titiya epe cuwanun mesaca tenca canato juraquiminlari jun mesabi chutecacanan tenca canato juraquiminla cuwenta jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Junsi Diosichi yaca tenca canato juraquiminlari Diosicanan tenca canato juraquiminla cuwenta jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Junsi Diosichi toca tenca canato juraquiminlari Diosi chudinuncanan tenca canato juraquiminla cuwenta jolajochunae tie. Junbi chumincanan tenca canato paminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Junni Jesús israelita mantaminlabe cacuenta quinato itsantie: —Nula mantaca micariminlabe fariséolabe fe sen jolajoyoe titonan duque padeseilaichunae tie. Diosichi mantaca obedeseiminlayoe tito, ti tanuncatiya Diosichi nasi cuwaminlae. Chunca ticatiya cato, Diosichi manca cuwaminlae tie. Danun tape nacá jerale, menta, eneldo, comino, ticatiya nasi nasi cuwaniquiminla joe Diosichi mantá joe tito. Junni nulari jun mantaca meráminla jotonan, Diosichi fe merántsan mantaca natiya tennatuminlae tie. Encanalaquituna! tinunca, laquiralarana! tinunca, uyanlabe sen jolajona! tinunca, nulari natiya tennatuminlae tie. Diosichi weyan mantaca telatuminnan, jun fécari merántsan mantaca meráno jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nulari quirano podeitonla tala minu micuwaminla cuwenta jolajochunae epele nenato. O tenca itonla tunpi fiminla cuwenta jolajochunae. Ya tenca itonla fufu nacá tunpibi wicaca fituchique larito quepolaquichunae tie. Juntonan fe wa petsecari tunpibi wicaca larituto, luwalaquichunae tie. Nulari jun tsanquenan na jutsaca quituchique tenfenatonan, wa jutsaca quiniquiminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nula mantaca micariminlabe fariséolabe fe sen jolajoyoe titonan duque padeseilaichunae tie. Nula jana nidabe tásabeca jamoleri tsaleminla cuwenta jolajoe tie. Nida forochi petse mitan rachunae tie. Nulari jun tsanquenan jamoleri sen jolajotonan, tencabi encanato tarinpunla joe tie nida se tsaleca iton cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nula fariséola tenca iton jolajoe. Casale nulachi tencaca jera tsalenola joe tie. Junsi jamotenan tsalaica cuwenta jonilajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nula mantaca micariminlabe fariséolabe fe sen jolajoyoe titonan duque padeseilaichunae tie. Nula fibapin ilipoca bobeda cuwenta jolajoe. Jamote uraran jochunae. Tenpe mantimini puyan oco chide pun jochunae. Jera petenca jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nula jun tsannan jolajoe tie. Tsachilari nulaca quirato, duque sen jolajoe timinlae tie. Nulachi tencabi mantimini seiton jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nula mantaca micariminlabe fariséolabe fe sen jolajoyoe titonan, duque padeseilaichunae. Sen puyaca junlaca monumento quicaca se quiminlae yala cuwenta senlayoe tito. Matu to Diosichi mantate paminlachi menaranunte ya nacá quiminla joe yalaca laquiralarayoe tito. ");
INSERT INTO cofNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Junni nulachi matu tatalari Diosichi mantate paminlaca totemin jominlanue. Nula mantimini junca tsa joe tito, matu tatala tsan itolajoyoe timinla joe tie. Chiquila jun mate pesonnaminla jomanpari, natiya petoteno itono jominla joinhie timinlae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te, nulachi fiquica meráto nulaca tuca miintsan joe tie. Nulari Diosichi tsachilaca toteminlachi alica joto, yala cuwentanan jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Junni tsanla jotori, niyan quino muquinatiya quinilaquede! Nulachi matu tatalaca nantanancari fe seiton quinilaquede! ");
INSERT INTO cofNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nulari seiton pini cuwenta jolajoe tie. Nulari yucanchi ninbi padeseinoca natiya polarino itolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Junni Jesús tsantisi, yalabe itsanque pae: —La duque tsachilaca nulachica ereyanae tie. Duque miraminlaca, Diosichi mantate paminlaca, duque seque micariminlaca nulachica ereyanae tie. Nula mantimini yalaca seiton quito, man puebloca man puebloca bene tanjilaichunae tie. Weyanlaca Diosichi fiqui miinun yabi asotaquin, weyanlaca toten, quilaquichunae. Weyanlaca corosibinan totelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tsanquinun tenchi duque culpa ilaichunae tie. To quinunle nechi duque sen tsachila totailainue. Jana casale matu to Abel sen jominca yachi aconan totenue. Junte nechi duque wata itsanchi, duque uyan senla totailainasa, Zacarías tinuncaman totelaquinue Berequíachi naoca. Yaca Diosichi yabi totelaquinue Diosichi sen tamobe Diosichi titiya epe cuwanun mesabe jolale. Junni nulari la ereca junlaca toteminla joto, jerale uyanla totachi puyacala tenchinan nulanan culpa talarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nulabe tsarasica pachinayoe: Nulari matu tote sonnalaratutonan, ya matu tote totachi puyacala tenchinan nulanan jera culpa talarachunae tie tsancari seitonla jonun tenchi. Jesús israelítala tala mantaca micariminlabe fariséolabe tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Junsi Jesús itsantie: —Jerusalén puebloca duque laquiito wepananayoe tie. Jerusalenbi chuminla, nulari Diosichi mantate paminlaca toteminla joe. Diosi nulachica ereca junlacanan su walaca quito toteminla joe. Jana walpa ayanni náca panpe tenpe pocanun cuwenta, duque ne nulacanan layano muquiminhe tie. Aman nulari te, munaralaratiyoe tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Junni amana Diosi nulaca puraca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lari Jerusalenbi winaminca Diosichi mantate janae tilatichunae tie. Laca tsara sen joe tilatichunae. Junni aman nula jerusalenla tsantino fecári laca manquiralaquituchunae tie. Jesús Jerusalenbi chuminlabe tsantie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Junni aman Jesús tsantitobi, Diosichi yabi nechi loto manjinasa, yabe penenaminla yachica jato ¿Diosichi ya duque uraran ya joco? tinaminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús mantimini chiquilabe tulanto itsantie: —¿Nula in yaca uraran joe tito quiralaquinaco? tie. Juntonan nulabe tsarasica pachinayoe tie. In ya jera arajito su mancatiya jamo diquiratuchunae tie. Jera aralelaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aman inale Jesús Olibo tinun dubi chusanan yape penenaminla yachica nosa jalaito itsanlatiyoe: —Chiquilabe pade! latiyoe numasi tsanhino jonunca. ¿Niyaito miintsan jochunan? nu numasi manpatano jonunca, numasi to jeraino jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Junnan Jesús chiquilabe itsantie: —Nula tencabe nenalarana! tie. Weyan weyan tsachila Crístoyoe tide jalaichunae tie. Yalari duque tsachilaca encanalaquichunae. Junni nulari tencabe nenalarana! tie yalabe encanailaituchun. ");
INSERT INTO cofNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Quera quicaanaeque mera jochunae. Quera quicaachunaequenan mera jochunae tie. Aman junca merátonan, natiya jeleralaratuna! tie. To cajeraitusanan tsanhiniichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Manca tobe manca tobe pataato quera quicaalaquichunae tie. Weyan postolabe tsachila ano fino itonan padeseilaichunae. Quiyanchinan padeseilaichunae. To duque wechunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsachila tsanque padeseilainatonan, fécari duque padeseino cajolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Junni nulaca cuwapolaquichunae. Padeseilaichunae. Nulaca totelaquichunae. Jerale tobi chuminla nulaca pa jolajochunae lachi tsachila jonun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Junnasa weyanla laca quereiminla jominnan, jutsabi manpatilaichunae tie. Yala talanan pataato cuwapocaalaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Junsi layanla nene pánato Diosichi mantate micarinayoe tito, duque tsachilaca encanalaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsachilari fécari seiton ito, quitsaca fe duque tsachila laquiratumin ilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Junnasa niyanlaquinasatiya peleituminlari se lolaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Junni jerale tote in sen fiquica micarilaquichunae Diosi ya mantananun tsachi bolon suwanaeque. Ya fiquica piyanlete micarilaquichunae tie yape jerale tobi chuminla miilaisa. Junni jerale tobi micarinunsi, to jeraichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesús tsanque micaritobi, man fiquiman pae. In pilaca quiraminlari ya fiquica miichique duque tenfenola joe. Ya fiqui itsanque joe: —Matu to Daniel Diosichi mantate pato, duque seiton suwaminca pato pila chuteca joe tie. Aman jun seiton suwamin tsachi wiruichunae tie Diosichi sen postobi. Junni tsachilari yaca junbi wiruraminca quirasi, we sujinola jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea tobi chuminla du minu sujinola jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ya jamochi raminlari wewe manpatato, tamochi tinantiya mancábi wituminnan sujinola jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Witabi raminlanan panu mancábi jatuminnan, sujinola jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jun mate na punlabe cu cufiminlabe fécari padeseilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Junnan Diosibe rocailaina! tie yape pilute o jasaino mate sujinola itosa. ");
INSERT INTO cofNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jun mate tsaracari duque padeseino ma jochunae. To quinunle nechi jun ma fecári tsansi duque capadeseituca jochunae. Jun male nechi to jeraino fecári tsansi padeseino manhitochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Diosi jun padeseino maca we jeraisa caritumanpari, monantiya puchuino itominla jonhoe tie. Aman Diosiri ya wenteca junlachi tenchi jun maca we jeraisa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aman weyanlari nulabe pato, Quiralaquede! Cristo inte rae tilatichunae tie. O junte rae tilatichunae tie. Tsantinaminlaca tina quereitulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Junni weyanlari nene pato Cristo joyoe latichunae. O weyanlari Diosichi mantate pamin joyoe latichunae tie. Yalari duque wepanato quirantsancari quito quirawolaquichunae Diosichi mantate tsanlaquinayoe tito. Pode jomanpari Diosi wenteca junlacanan encanano jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Junni meralaquede! tie. Catsanhitosanan nulabe jera pánayoe tie yape encanailaitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Jana cunta pindaca tenca calaquede! tie. Cunta pinda quinasa jeralete quirasa imanhe. Fechi nechi pelechi fecári quirasa imanhe. Aman la tsachi ica jun joto manpatanasa, jun tsannan jochunae tie. Jeralete quirasa iyanae. Jun tenchi nulabe pato Cristo jelenchi rae latinari, quirabi pejitulajona! O tamochi rae latinari, tina quereitulajona! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jana baro tiletiya puyan tsonunte layainiimanhe tenca mánta tenhito. Labe penenaminla jun tsanquenan tenca mántanan tenhilaichunae tie la manpatananunca. ");
INSERT INTO cofNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Junni Jesús chiquilabe cacuenta quinato itsantie: —Jun ma padeseinunsi, yo nemenhichunae; penan tsetuchunae; tsabonan jamochi nechi darapatachunae tie. Yoquidobi wetuto chuminla jera welaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsanhinunsi yoquidobi Diosi ticatiya quirawochunae la tsachi ica jun joto manpatachinaeque jeralela tenhilaisa. Junni jerale tote chuminla duque laquiilaichunae tie. Laquiito laca quiralaquichunae. La jamochi nechi duque mantá tan manpatanaminca quiralaquichunae tie. Jamochi poyobi janae tie urara tsenbe. ");
INSERT INTO cofNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Junsi tutu sonba mera jochunae. Junsi lachi anjelilaca ereyanae tie yape la wenteca jun tsachilaca jerale tobi nechi layalaquisa. Fe nuwiri bare tobi nechinan layalaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jana ico peleca cuenta quechinayoe tie. In cuentaca meráto seque miilaide! ¿Aman in tobi wata cura ico pele japisu jera patimin joco? Junni fu manhichinasanan, japisu manquimanhe. Aman japisu manquinaminca quirato, nulari miiminla joe manfu ichinaeque. ");
INSERT INTO cofNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jun tsanquenan la paca jera tsanhinaminca quirato, laca moora manpatachinaeque miilaichunae tie. Laca moora manquiraichinae tintsan jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Junni nulabe tsarasica pachinayoe tie: Ya tsachilari cajerailaitusanan, la paca jun fiqui jera tsanhichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yoquidonan, tonan, jeraichunae. Lachi fiqui mantimini numanan epe fiqui ituchunae tie; la ticatiya tsanhichunae tinari, jun tsannan ichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Junni aman la numasi ti maca manpatano jonunca monantiya miitolajoe tie. Diosichi anjelilanan miitolajoe. Apa Diosisiri mirae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Matute Noeca mantenhilaide! La tsachi ica jun joto manpatano inasa, Noé sonnanun ma cuwenta manjochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ya Noé sonnanun mate tsachila chuniraminlanue. Ano fin, ticatiya cuchin, sona can, unila quin, quinaminlanue. Noé barcobi wino ma fecári tsanque wepanatuto chuniraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ya tsachilari to yucapiyano jonunca tenhitusanan, mapiya jato jera luwa tanjiniinue. Junni aman la manpatano mate jun tsanquenan jochunae tie. La manpatano jonunca tenhituto chunilarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Paluca tsachila witabi rasanan, mancaca tanjinan manca puraichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Paluca sonala titiya ilinasanan, mancaca tanjinan manca puraichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Junni tencabe meralarana! tie. Nulari natiya miitolajochunae la nulachi Miya joto ti maca manpatano jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","O jana tarinminlacanan tenhilaide! tie. Ya tsacuminla miitolajochunae tie numasi quepen tarinquebi jano jonunca. Wari miramanpari, mérato quirano jomin jonhoe yape tarinquebi wiyatusa. ");
INSERT INTO cofNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Junni nulanan jun tsanquenan tencabe méranola jochunae tie la tsachi ica jun manpatano jonunca. Laca manpatatuchunae latinasanan, manpatano joyoe tie. Jesús chiquilaca tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Junni Jesuri chiquilaca camicarinato itsantie: —Jana mayordomolaca tenca calaquede! tie. Ya tsacumin uyanchi jichinato mayordomoca mantachunae peyunlaca cuidaito ano cufin, titiya quin, quisa. Junni nulari lachi mayordomola cuwenta jolajochunae tie. Junni mayordomola senla jolajotori, ");
INSERT INTO cofNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","seque cuidailaichunae tie. Junni patron manjanasa cuidainatori, duque pansi jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nulabe tsarasica pachinayoe. Tsanque seque cuidaimin mayordomolaca fécari mantá tanla suwachunae tie jera tanunca mantalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Junni mayordomola mantimini seiton tsachila jolajotori, seque cuidailaituchunae tie. Patron wanhinae tito ");
INSERT INTO cofNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","peyunlaca asotaquilaquichunae tie. Winanlabe ano pefin, warente pecuchin, quilaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Junni seiton mayordomolari yalachi patronca manjatuchunaeque tenca calaquinasanan manjachunae tie. Miitonun órate jasi, ");
INSERT INTO cofNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","seiton mayordomolaca casticaquichunae tie. Weyan tsachila fe sen joyoe timinla jotonan, duque seitonla joe. Junni yalaca casticaquinato, ya seiton mayordomolacanan pecasticaquichunae tie. Junbi tsachila padeseinato fudachi warelaquichunae tie. Jesús tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Junsi Jesús itsantie: —Diosi yachi tsachilaca jun mate mantanato, itsanque jochunae tie: Chunca nala sonala lanparin manca manca cato jilaichunae tie casalainanun fiesta quirabi. Casalaichinamin unila uyanchi nechi janaminca tulaibi jilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aman manteca sonala tenca iton jolajochunae; mantecari tenca tan jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Junni tenca itonlari lanparin tanjinatonan, aseite tanjilaituchunae tie lanparinbi manpochun. ");
INSERT INTO cofNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tenca tanlari lanparin tanjinato, junto chicanle aseitenan petanjilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Junni aman casalaichinamin unilari we fatuchunae tie. Junnasa ya chunca sonalari capiya cayailaito, catsolainachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jun quiranari quitsa quepenbi otinanunca meralaquichunae. Quiralaquede! Casalaichinamin unila janae tichunae tie. Tulaibi jilaide! tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Junni tsanque merasi, ya chunca sonala jera mansonhito, lanparin silica manselaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Junni mansenato, tenca itonlari tenca tanlabe itsanlatichunae tie: Aseiteca nasi cuwalaquede! latichunae tie. Chiquilachi lanparin piyanae latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Junni tenca tanlari cuwatulajochunae. Itsanlatichunae: Nulachi cuwatori, chiquilanan, nulanan michi itolajoichunae latichunae tie. Nulari osiminlachica jito canilaquede! latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Junni tenca itonla aseite cabi jilainasanan, casalaichinamin unila tamochi winasa, tenca tan sonalanan parejo pewilaichunae fiesta quirabi. Junsi tamolanca dosa carichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Junni inale tenca iton sonalanan manfato quiranari, tamolanca doca jochunae. Aman junca quirato otito, Miya, chiquilaca pocade! latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Casalaichinamin unila mantimini lasituchunae. Tsarasica pánayoe tito nulaca natiya quiratumanyoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Junni Jesús jun cuentaca polaritobi itsantie: —La tsachi ica jun joto manjano joyoe tie ya casalaichinamin unila cuwenta. Junni nula tencabe meralarana! tie. Nula natiya miitolajochunae tie la numasi ti maca manpatano jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tsanque micaritobi, Jesús itsantie: —Diosi mantananun tsachila tala itsanque jochunae tie. Patron manca bare toca jichunae tie. Jun patron jichinato, yachi peyunlaca jalaisa carito, yalachi cala cuwachunae tie yape patronchi tenchi necosio quilaquisa. La ya patron cuwenta joanae; tsachilari ya peyunla cuwenta jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aman manca peyunchi duque cala cuwachunae. Junsi nanni fe poden peyunchi fécari duque cala cuwachunae. Junsi yaca fécari poden peyunchi nantanancari fe duque cala cuwachunae tie. Tsanque cala cuwasi, bare toca jichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Junni aman fécari duque cala camin peyunni ticatiya cato, necosio quito, palu tsansi suwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Junsi nantanancari fe duque cala camin peyun, yanan tsanquenan ticatiya cato necosio quito, palu tsansi suwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Junni tsan josanan nasi camin peyun mantimini necosio quituto, tobi foro quito, patron cuwaca calaca jera menachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aman junni patronni numari manjato, cuenta jera larichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Casale fe duque camin peyun jato, jera calaca tanjato itsantichunae: Patron, ¿nu duque cala cuwaco? Nen, lari palu tsansi mansuwayoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Junni patronni yaca se tichunae. Nu sen peyun joe tichunae. Nasi calaca seque necosio quinue. Junnan nuca fécari mantá tan suwachinayoe tichunae. Labe pansi jona! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Junsi nantanancari fe duque camin peyun jato, yanan jera calaca tanjato itsantichunae: Patron, ¿nu duque cala cuwaco? Nen, lari palu tsansi mansuwayoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Junni patron yacanan se tichunae. Nu sen peyun joe tichunae. Nasi calaca seque necosio quinue. Junnan nuca fécari mantá tan suwachinayoe tichunae. Labe pansi jona! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aman junsi nasi camin peyun jato, itsantichunae: Patron, la nuca mirayoe. Nu sonban necosio quimin tsachi joe. Uyanla waca junca nu mancamin joe. Uyanla aralecaca nu mancamin joe tichunae. ");
INSERT INTO cofNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Junto nuca jele tito, necosio quino jeleramanyoe. Junto nuchi calaca menaca jomanyoe tichunae tie. Nen, nu cuwaca cala tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Junni patron mantimini jun peyunca natiya seitoe tichunae. Lan pun joe tichunae. ¿Laca sonban necosio quimin joe titiyun? tichunae. ¿Laca uyanla waca junlaca mancamin joe titiyun? ¿Uyanla aralecaca la mancamin joe titiyun? tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Junsi patron itsantichunae: Nuri laca tsanque tenca catori, lachi calaca bancobi pontsan jominue. Junni la manjatobi, calabe interebenan mancano jomin joinhie tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Junni patronni jun seiton peyunbe tsantito, uyanlabe itsantichunae: Meralaquede! tichunae. Jerale taminlachi fe cuwanan, nantanancari duque talarachunae tichunae tie. Itonlachi mantimini nasiri tanuncatiya josolenan, natiya iton ilaichunae tichunae tie. Junto inchi calaca josoleto, fécari duque tanchi cuwalaquede! tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Junni yachi calaca josoletobi, lan pun peyunca urachi nemen minu quepolaquede! tichunae tie. Junbi tsachila padeseinato fudachi warelaquichunae tie. Jesús tsanque cuenta polarie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Junni Jesuri jun cuenta polaritobi, man fiquinan pae. Itsantie: —La tsachi ica jun joto uraran tsenbe manpatanae tie jerale Diosichi anjelilabe. Uraran mantato chudinunbi chudiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Junbi chudinunsi, lachi cale jerale tobi chuminla layailaichunae. ¿Aman jana animalica cuidaimin tsachila opisabe chibobeca wenteto palu bolon quiminla joco? tie. Aman lari jun tsanquenan tsachilaca jera miito wenteto, palu bolon queyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Senlacari lachi tsa tede nanchi wirucariyanae tie opisaca cuwenta. Seitonlacari lachi jala tede nanchi wirucariyanae tie chiboca cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Junto la yalachi miya joto, tsa tede nanchi wiruraminlabe itsantiyanae tie: Lachi Apa Diosi nulaca son tisa carica joe. Matu mate in toca quinato, nulachi tenchinan tsara sen to quicae tiyanae tie. Junbi Diosi nulachi Miya jonan seque chunola jochunae tiyanae tie. Junni jalaide! Jun sen tobi wito chularana! tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lachi ano muquinasanan nula cuwalaquee; pi muquinasanan nula cuwalaquee tiyanae. Uyan tobi nenasanan, nulachi yabi facarilaquee tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jali itosanan, cuwalaquee. Quiyanpun josanan, laca quirabi jalaie. Dorasanan, laca ayudaibi jalaie tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Junni jun mate la tsanticabi, senla beconan pato, labe itsanlatichunae tie: Miya, ¿numasi nu ano munaraminca quirato ano cuwalaquewan? latichunae tie. ¿Numasi nu pi munaraminca quirato pi cuwalaquewan? ");
INSERT INTO cofNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Numasi nu bare tobi nenaminca quirato chiquilachi yabi facarilaquewan? latichunae tie. ¿Numasi nu jali itominca quirato cuwalaquewan? ");
INSERT INTO cofNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Numasi nu quiyanpun jominca o doraminca quirabi jilaiwan? latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Junni yala tsantinunsi, la Miya joto yalabe itsantiyanae tie: Meralaquede! Poperela lachi familiala cuwenta jolajoe tiyanae tie. Junto nula yalaca ayudaitori, lacanan ayudaica cuwenta jochunae tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Junni yalabe tsantisi, lachi jala tede nanchi wiruraminlabe itsantiyanae: Jachi jilaide! Diosi piyatumin nin quica joe tiyanae yucancanan yachi seiton ocolacanan casticaquichun. Junni nulanan yucanhicala joto junchi pejilaide! tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Lachi ano muquinasa, natiya cuwalaquitue; pi muquinasa, natiya cuwalaquitue. ");
INSERT INTO cofNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bare tobi nenasanan, nulachi yabi facaritulajoe. Jali itosanan, cuwatulajoe. Quiyanpun josanan, o dorasanan natiya quirabi jatulajoe tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Junni seitonlari lachi fiquica meráto, beconan itsanlatichunae tie: Miya, ¿numasi nu ano munaraminca, o pi munaraminca, o bare tobi nenaminca, o jali itominca, o quiyanpunca, o doraminca quirato ayudailaituwan? latichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Junni lanan beconan itsantiyanae tie: Meralaquede! Poperela lachi familiala cuwenta jolajoe tiyanae tie. Junni yalaca ayudaitutori, lacanan ayudaituca cuwenta joe tiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Junni la tsantinunbi, seitonla ninbi wito, numatotiya padeseito polelaichunae tie. Senla mantimini Diosibe numatotiya pesonnato polelaichunae tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Junni Jesús jun fiquica jera micaritobi, yachi tsachilabe itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—¿Palu mate casa ma fiesta ichinaco? Jun mate tsachi manca laca, tsachi ica junca, cuwapochunae tie yape corosibi totelaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesús tsantinasa mantimini, israelita mantá tanlari patelelachibi layainaminlanue Jesuca tenpachun. Mantá tan patelela, mantaca micariminla, mantá tan unicala layaica jominlanue. Yala Caifás tinun mantá tan patelechibi layaito ");
INSERT INTO cofNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tenpanaminlanue Jesuca niyaque nosa cato toteno jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Junni fiesta órate catuntsan joe latinue. Fiesta órate Jesuca calaquinari, tsachila pansile firara tilatichunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Junni Jesús Betania puebloca jito, Simónchibi chuminue. Aman ya Simonni lepra bichi chumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Junni Jesula junbi ano fito chularasanan, sona manca duque mica puban pica tanjae. Alabastro tinun suca quica jun boteyabi pun jominue. Junni ya sonari jato, puban pica Jesuchi misubi poe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesube penenaminla weyanla junca pa quirato itsanlatie: —Ya mica puban pica epe tsannae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Duque micate osito, duque cala cato, ya calaca poperelachi cuwantsan jominue latie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Junni Jesuri yalachi fiquica meráto itsantie: —¿Ti quichun in sonaca pasuwalaquinayun? tie. Yari laca seque quinae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Poperela numatotiya nulabe pejoto polelaichunae tie. Manan la mantimini numatotiya nulabe chuto poleno itoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","¿Jana puyaca junlaca menachun puban pica pono joco? Aman lacanan menasa ya puban pica numa ponae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nulabe tsarasica pachinayoe tie. Diosichi sen fiquica jerale tote micarinato, in sona tsanquinuncanan palaquichunae tie yape yaca mantenhilaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Junni Jesús tsantinunbi, Judas Iscariote loto jie. Yari chunca paluca Jesube penenaminla manca pejominnan, chiquilachibi nechi loto jie. Loto jito, mantá tan patelelachica jito, ");
INSERT INTO cofNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","itsantinue: —¿Jesuca nulachi cuwaponun tenchi nisi pacara quilaquinoyun? tinue. Junni yalari Júdachi peman chunca cala cuwalaquinue yape Jesuca cuwaposa. ");
INSERT INTO cofNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Junni juntele nechi Júdari tenca cato nenaminue Jesuca niyaque cuwapono jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Junni casa ma fiesta fanue lebadura iton bibuca finun fiesta. Junni caque fiesta mate Jesube penenaminla yachica jato, ¿Chiquilari fiesta anoca tile daquintsan jun? latiyoe nube casa ma fiesta ano filaquichun. ");
INSERT INTO cofNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Junni Jesuri weyanlaca puebloca jisa tito, tsachi mancabe cuenta quisa tie. Jun tsachibe itsantilatina! tie. Chiquilaca micarimin tsachi chiquilaca eree tilatina! tie. La padeseino óra queloinasa, nuchi yabi lachi tsachilabe fiesta ano fino muquee tinae tilatina! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Junni Jesús tsantisa tica josa, yabe penenaminla weyanlari junchi jito, jun tsantilatinue. Junsi casa ma fiesta ano dalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Junni aman quebite Jesús ano fichun chuminhe yabe chunca paluca penenaminlabe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Junni ano fito chuto, Jesuri chiquilabe itsantie: —Nulabe tsarasica pachinayoe tie. Nula manca laca uyanlachi cuwapochinae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Junni Jesube penenaminlari laquiilaito, manca manca yabe itsantilatiyoe: —Miya, ¿la itoiinco? latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesuri chiquilabe beconan itsantie: —Cuwapomin tsachi la finanun nidabi pefinae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","La tsachi ica jun joto puyabi jichinayoe. Diosichi Pilabi laca tsanquenan chuteca joe tie puyano joeque. Junnan la puyano joyoda. Laca cuwapomin tsachi mantimini duque padeseichunae tie. Ya tsachi naica itomanpari, yachi tenchi fe se jono jomin jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aman Judas yaca cuwapono jun jominue. Junni yanan Jesube jun tsanquenan panhae. Miya tie. ¿La itoiinco? tie. Jesús yaberi beconan pato, Nure tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Junni ano filaquinaminnan, Jesuri bibu cato, Diosibe acradeseito, pisuleto, yabe penenaminlachi cuwae. Chiquilachi cuwanato, nen tie. Filaquede! tie. In bibu lachi puca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Junsi Jesús bino copacaman cato, Diosibe acradeseito, chiquilachi cuwanato itsantie: —Aman Diosi tsachilabe trato quinae tie jutsa piyarino joyoeque. Junni in bino lachi asan joe tie. Yaca tenca cato miintsan jochunae Diosi ya trato quica joeque. Lari duque tsachilachi tenchi asan larino joyoe yalachi jutsaca piyarichun. Jesús tsantisi binoca chiquilachi cuwato, jeralela cuchilaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Junsi itsantie: —Meralaquede! La binoca numari fecári cuchituanae tie. Ina lachi Apa Diosichibi nulabe casan tala mancuchiyanae tie. Jun fecári natiya cuchituanae tie. Jesús chiquilabe tsantie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Junni chiquilari fiesta ano fitobi, Diosica canta quetobi, Olibo tinun duca jilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Junbi Jesús chiquilabe itsantie: —Diosichi Pilabi itsanque chuteca joe tie: Opisa cuidaiminca totenan, yachi opisa epele ara cura jera sujilaichunaeque chuteca joe tie. Junni nula amana quepen jun opisa cuwenta laca purato sujilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tsan josanan lari puyato mansonhitobi, nulaca caquenan Galilea toca manjito, junbi nulabe mantulaiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jesús tsantinunsi, Pédrori itsantie: —Weyan jeralela nuca puralaquinasatiya, lari te, numanan nuca puratuanae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Junni Jesús Pédrochi fiquica merasi, itsantie: —Nube tsarasica pachinayoe tie. Nu amana quepen laca purachunae tie. Walpa apaca capatusanan, peman ne laca natiya miitoyoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Junni Pédrori beconan manpato itsantie: —Te, nube puyano jototiya nuca numanan tsantituanae tie. Weyan Jesube penenaminlanan jun tsannan tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Junni Getsemaní tinun postoca jilaito, Jesús yachi tsachilabe itsantie: —Inte chudito meralarade! tie. Junchi jichinayoe tie Diosibe rocaibi. ");
INSERT INTO cofNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Junni weyanlaca junte chuteto, Pédroca, junsi Zebedéochi paluca naolaca nanni jabile tanjie. Jilainato, Jesús duque laquiito wepananaminue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Junto itsantinue: —Lachi tenca puyan tsansi laqui joe tinue. Junni nulanan labe inte quirato chularana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús tsantisi nanni jabile jito, tobi mutsabale telenhito, Diosibe itsanque rocainue: —Lachi Apa Diosi, pode jotori la padeseinoca polaride! Tsan josanan lachi tenca munanan tsanhino muquetue. Nuchi tenca munanan quisa tenjae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Junni Jesús Diosibe tsanque rocaitobi, yachi pemanca tsachilachica manjanasa, catson tsominlanue. Junni Pédrobe itsantinue: —¿Niyaito labe moora nacátiya catsotuto mérano podeilaitiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nulari Diosibe rocaito, tencabe nenalarana! jutsa quituchun. Nulachi tencabiri seque nenano munaratonan, nulachi pucari cumana jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Junni Jesús tsantisi, manan manjito Diosibe manrocainue. Itsantinue: —Lachi Apa, la padeseinoca polaride! Aman padeseinamincanan polarino jotori, yanan se jochunae. Nu tsanque mantanari, tsanhiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Junni Jesús Diosibe tsanque rocaitobi, yabe penenaminlachica manan manjanue. Junni manan manjato quiranari, manan mancatson tsominlanue. Duque capiya taminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Junni Jesús yalachile nechi manjito, Diosibe manan manrocainue jun fiquicanan manpato. Jerale nechi peman ne tsanque rocainue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Juntobi yabe penenaminlachica manan manjato, itsantinue: —¿Catson tsoniralarayun? ¿Cajasainiilainayun? Aman meralaquede! Laca cuwapono óra faca joe tie. La tsachi ica jun joto seitonlachi cuwapoichinayoe tie yape laca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Junni jisa! Mancupalaide! tie. Aman quiralaquede! Laca cuwapomin tsachi jana janae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús cuenta caquinasanan, Judas fae. Yari chunca paluca Jesube penenaminla jominhe. Junni Júdabe duque israelítala pejalaie weyanla espada tanla, weyanla chide tanla. Mantá tan patelelabe mantamin unicalabe layaito ya tsachilaca Júdabe ereca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aman Júdari Jesuca cuwapochun pejaminlabe itsantica jominue yape Jesuca miilaisa: La tsachi mancaca motito saludaiyanae tica jominue. Yari Jesús jochunae; yaca calaquina! tica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Junto Júdari Jesúchica we jato, Miya tito motito saludaie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Junni Jesuri yabe itsantie: —Amico, ¿tibi jayun? tie. Jesús tsantinasale, yachica jato, yaca chuito calaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yaca chuilainasa, Jesube penenamin tsachi manca yachi espadaca laricato, mantá tan patelechi peyunca espadachi quito punquica balequee. ");
INSERT INTO cofNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsanquinunsi Jesús itsantie: —Espadaca manponiquede! tie. Espadachi quicaaminla espadachi puyalaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Laca isaisa tenjamanpari, lachi Apa Diosibe rocaino podeino joinhie anjelila laca isaibi jalaisa. Chunca palu bolon fécari anjelilaca ereno jomin jonhoe soldadola cuwenta laca isailaisa. ");
INSERT INTO cofNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tsan josanan rocaitiyoe tie. Diosichi Pilabi laca chuteca joe tie tsanque padeseino joeque. Tsanque chuteca josa, jun tsanquenan patinae tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Junni Jesús yachi tsachilabe tsantisi, yaca cabi jaminlabe itsantie: —¿Ti quichun laca espada tanla, chide tanla tarinminca cuwenta cabi jalainayun? tie. Diosichi yabi ma cura micarito chumanyoe. ¿Niya jonan junbinan laca calaquitiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Diosichi mantate paminlari Diosichi Pilabi chuteto, nulaca jera chuteca jominlanue nula tsanquinola jonunca. Junni tsanque chuteca josanan, nulari jun tsannan quilaquinae tie. Junni Jesús tsantinunsi yabe penenaminlari yaca purato jera sujilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Junni Júdabe pejaminlari Jesuca cato, fe mantá tan patelechica tanjilainue. Jun patele Caifás mumun jominue. Junni mantaca micariminlabe, mantamin unicalabe, ya Caifáchibi layaica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aman Jesuca junchi tanjilainasa, Pedro comabile benechi jinue patelechi sela fecári. Junni selabinan pewito, polisialabe pechudinue Jesuca niyan quilaquinanunca quirachun. ");
INSERT INTO cofNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Junni mantá tan patelelabe jerale mantaminlabe junbi jera layailaito, testicolaca munaraminlanue yape Jesuca nene pato culpa quilaquisa. Jesuca culpa quito, totesa carichi tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Junni casaleri duque tsachila Jesuca pánatonan, falta patarino podeilaitunue. Tsan josanan wanbileri paluca tsachilari pato ");
INSERT INTO cofNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jesuca itsanlatinue: —In tsachi Diosichi yaca araleno podeinoyoe tie latinue. Araleto, peman mate jera manquino podeinoyoe tie tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Junca meráto, fe mantá tan pateleri wiruito, itsantinue: —¿Niyaito beconan pátiyun? tinue. In testicolari nuca duque culpa quilaquinae tinue. ¿Junni nuri niyan tichun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesuri nosasa wiruraminue. Junnan mantá tan pateleri itsantinue: —Tsa Diosi meranasa tsarasica pade! tiyoe tinue. ¿Nuri Diosi wenteca Cristo tinun tsachi joyun? ¿Diosichi Naoyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Junni ya fiquica merasi, Jesús beconan itsantinue: —Tsan joyoe tinue. Junsi man fiquinan nulabe pachinayoe tinue. Manca mate nulari laca, tsachi ica junca, jamochi manquiralaquichunae tinue. Sonban Diosichi tsa tede nanchi mantato chuminca quiralaquichunae tinue. Laca jamochi poyobi manpatanaminca nulari quiralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesús tsantinunsiri, fe mantá tan pateleri duque paito, tencachique camisaca chilenue painanunca miilaisa. Junto weyan mantaminlabe itsantinue: —In Jesús Diosica epele pánae tinue. Ya fiquica meráto, uyan testicolaca natiya munaralaratiyoe. Chiquilanan meralaquiyoe tinue Diosica seitonque pánaminca. ");
INSERT INTO cofNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Yaca niyan quintsan joe tilatiyun? tinue. Junni mantá tan patele tsantinasari, uyan mantaminlari Jesuca totentsan joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Junni Jesuchi caforole pipichi quito, yaca quilaquinue. Weyanlari yachi cacaca doto, bitile quito, ");
INSERT INTO cofNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","itsanlatinue: —Nu Cristo jotori, Diosichi mantate nuchi tencabi miiniide! latinue mo nuca bitile quinunca. ");
INSERT INTO cofNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Junnasa aman Pedro urachi selabi chuminue. Junni peyun sona manca yachica jato, itsantinue: —Nunan ya Jesús tinun Galilea tsachibe penenaminhe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro mantimini yaca meráto, jeralelachi cale pato, te tito, itsantinue: —¿Nuri tica tsantinayun? Ya Jesuca natiya miitoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Junsi manca peyunni Pédroca quiranue sela tamolanca jinaminca. Junni Pédroca quirato, junbi peraminlabe itsantinue: —In tsachinan Jesús Nazarenobe penenaminhe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Junni Pedro manan manpato itsantinue: —Diosi mirasa juraquito pánayoe tinue. Ya Jesús tinunca natiya quiratumanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Junsi junbi raminla weyanlari Pédrochica jato itsanlatinue: —Nuri Jesube penenamin tsachi joda. Yala cuwentanan Galilea to tsachi joe. Nunan Galilea to tsachi cuwenta pamin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Junni Pédrori ya fiquica meráto, Diosi mirasa pánayoe tito juraquito itsantinue: —Te, ya Jesuca natiya quiratumanyoe tinue. Junni Pedro tsantinasale, walpa apaca panue. ");
INSERT INTO cofNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aman Pedro walpa panunca merasi, Jesuchi fiquica mantenhinue. Jesuri Pédrobe itsantica jominhe: Walpa apaca capatusanan nuri laca peman ne miitoyoe tichunae tica jominhe. Junni Pedro jun fiquica mantenhito, sela urachi loto, duque warenue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aman junni tseinasa jerale israelita mantá tanla layailainue. Weyanla patelela jominlanue; weyanlari mantá tan unicala jominlanue. Yalari layaito tenpalaquinue Jesuca totesa carichun. ");
INSERT INTO cofNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Junto Jesuca teleto, Poncio Pilato tinun miyachica tanjito cuwapolaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Junnasari Judas ya israelita mantaminlachica manjinue. Jesuca totesa cuwapotobi, culpa duque tenhito laquiinue. Junto mantaminlachica manjinue ya peman chunca calaca mancuwabi. ");
INSERT INTO cofNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya calaca yalachica mantanjato itsantinue: —Nen, cala. Lari jutsa quicayoe. Tsara sen tsachica totesa cuwapocayoe tinue. Ya israelita mantaminla mantimini itsanlatinue: —Wari chiquilari junca miratulajoyoe latinue. Nunan junca manse pataride! latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Junni tsanticala josa, Judas jun calaca Diosichi ya tamochi arale quepoto, junbi nechi jito, tencachiquenan cudanle cabo sili wito wiloito, sopeito puyanue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Junni mantá tan patelelari ya calaca mancato, itsanlatinue: —In calari totesa carimin cala joe. Jun tenchi Diosichi yabi tatuntsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Junto aman junca tenpato, ya calachi to calaquinue. Jun tobi to nida quichun to canun to jomin jominue. Junni ya toca cato, pantiyon quilaquinue uyan tobi nechi jaminla puyalainari, junbi yalaca menachun. ");
INSERT INTO cofNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Junni ya toca jun seiton calachi caya jonan, “Asan To” mumun tilatinue. Amanachinan jun toca jun tsannan catiminla joe. ");
INSERT INTO cofNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Aman matu tote Diosichi mantate pamin tsachi manca, Jeremías mumun, ya toca pato itsanque pila chuteca jominue: Miya Diosi labe itsantie tinue. To canola jochunae tie tinue. To nida quichun to canun postoca calaquichunae tie tinue. Junni israelítalari tsachi mancaca osito cato, peman chunca calaca cuwantsan joe tilatichunae tinue. Junni jun calachinan ya toca calaquichunae tinue. Jeremías tsanque pila chuteca jominue. Junni mantá tan patelela jun toca Júdachi calachi canan, Jeremíachi fiqui jun tsanquenan patinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aman junni Jesuri miya Pilátochi cale wiruraminbe Pilato itsantinue: —¿Nuri israelítalachi miyayun? tinue. Junni Jesuri tsan joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Junnasa mantá tan patelelabe mantá tan unicalabe Jesuca culpa quichi tilatinasa Jesuri patunue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Junni Pilátori yabe itsantinue: —Yalari nuca duque culpa quichi latinae tinue. ¿Jun fiquica merátiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús mantimini yala culpa quica fiquica natiya manpatunue. Junnan miya duque wepananue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Junnasa aman casa ma fiestate Pilátori doramin mancaca manlarimin jominue. Tsachilabe panhamin jominue moca manlarisa tenjanque. ");
INSERT INTO cofNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Junni jun mate duque miranun tsachi manca doraminue Barrabás tinun. ");
INSERT INTO cofNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","19","Junnasa quiranari israelítala layailainue jun tsanquenan doramin mancaca larisa carichun. Tsanlainasanan Pilato juisio quito chusanan, yachi sonari fiquica erenue. Yari Jesuca pato, ya sen tsachica tede potudeque fiqui erenue. Quipibi amana quepen Jesús tenchi duque wepanayoe tinue. Junni aman Pilátonan ura tenhinue israelita mantaminla Jesuca pachisiri cuwapolaqueeque. Junto Pilato Jesuca manlarichique israelítalabe itsanque panhanue: —¿Moca manlarisa tenjalaquin? tie. ¿Barrabaca manlarintsan jun, o Cristo tinun Jesuca manlarintsan jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aman tsan josanan, mantá tan patelelabe mantá tan unicalabe jerale layaica jun tsachilaca payica jominlanue. Barrabaca manlarito Jesuca totede! tilatina! tica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Junni miyari manan manpanhato ¿Moca manlarisa latiyun? tie. ¿O Barrabaca o Jesuca manlarisa latiyun? tie. Junni tsantinasa, Barrabaca manlaride! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Junni Pilátori yalabe beconan manpato itsantie: —¿Junni Barrabaca manlarito, Cristo tinun Jesuca niyan quisa tenjalaquin? tie. Aman tsachilari manpato, Yaca corosibi totesa caride! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Junni Pilátori yalabe manan manpato itsantie: ¿Niyaito Jesuca tsanlatiyun? ¿Niyaque seiton quica jun? tie. Junni tsachilari jun fiquica natiya tennatuto, fécari sonba pato, corosibi totesa caride! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Junni Pilátori tenhinue tsachilari yaca natiya merátuto fécari firara tilatichinaeque. Junca tenhito pica tanjasa carie. Junsi jeralelachi cale tede tsalee Jesuca culpa quitiyoe tito. Tede tsaletobi, itsantie: —In tsachi culpa itoe. Yaca totenun tenchi la culpa itoanae tie. Nulari totechi timinla joto, nulanan totesa carilaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsantinunsi jerale tsachilari itsanlatie: —Ya culpaca jeleralaratiyoe latie. Yaca totenun tenchi culpa jono jonari, chiquilabe chiquilachi alicalabe jun culpaca inilaiyanae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Junni tsachila tsanticala josa, Pilátori Barrabaca manlarinue. Junni Jesuca asotaquisa carito, soldadolachi cuwapoe yape corosibi totelaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Junni miyachi soldadola Jesuca casale miyachi yabi wa tamochi tanwito, jerale jun bolon soldadolaca layaisa carilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Junsi Jesuchi camisaca jera larito, miya ponun uraran lubaquin camisaca pocarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Junsi po silica torinca quito, Jesuchi misubi polaquinue yaca Miyae tito. Junsi epe chideca yachi tsa tedebi chumicarilaquinue mantaminchi chide joe tito. Tsantobi Jesuchi cale telenhito, yaca pamiyato quirato, biba tilatinue. Israelítalachi miyaca biba quilaquisa! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Junsi yaca pipichi quito, ya chideca mancato misule quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Junni aman Jesuca michi pamiyato quirato, ya lubaquin camisaca manlarito, yachi camisaca manpocarito, corosibi totebi tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Junte nechi jinato quiranari, Cirene to tsachi manca polenaminue Simón tinun. Junni soldadolari yaca Jesús puyano jun corosica nanasa carilaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Junto Gólgota tinun postobi felaie. Aman israelítalachi fiquichi misu chideca “cólcota” timinlayoe. ");
INSERT INTO cofNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Junni junbi féto, pele binobe cantsa pibe palato, Jesuchi cutsawochi latie. Ya mantimini nasi cuchito quirae miichun. Junsi nantari cuchitue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aman matu tote Diosichi mantate pamin tsachiri Jesuca pila chuteca jominue. Jesuca pato itsantica jominue: Yachi camisa ticatiya quitsalaalaquichunae tica jominue. Apostaito sorteailaichunae tica jominue ¿Mo cachunan? tito. Junni matu mate tsanque chuteca josanan, soldadola jun tsannan quilaquee. Jesuca corosibi wilocarito, yachi camisa ticatiya tsanquenan calaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","Junto ti culpa tenchi Jesús puyananunca pila quito, yachi misu jamo chutelaquee. IN JESUS JOE; ISRAELITALACHI MIYA JOE que pila chuteca jominue. Junto soldadola jera tsanquetobi, Jesuca quirato chuminlae. ");
INSERT INTO cofNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Junni paluca tarinlacanan Jesube parejo corosibi wilocarilaquee manca yachi tsa nanchi, manca yachi jala nanchi. ");
INSERT INTO cofNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Junni junse polenaminlari Jesuca yucacuralaquee. Misuca disi disi quito quiralaquee lucarito. ");
INSERT INTO cofNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Itsantilatie: —Nu Diosichi yaca araleto peman mate manqueyanae timinhe latie. Junni nuri tsanque poden jotori, tenca mántanan se lode! Nu Diosichi Nao jotori, corosibi nechi manpataniide! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Junni israelítala tala mantaminlanan pequiranaminlae. Mantá tan patelelabe mantaca micariminlabe mantá tan unicalabe pequiranaminlae. Yalanan Jesuca seitonque pato, lucarito quirato, itsanlatie: ");
INSERT INTO cofNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ja tsachiri uyanlaca se larimin joyoe titonan, tencachiquenan natiya se lono podeitue. Yari chiquilachi miya jotori, corosibi nechi manpatantsan joe latie. Manse lonari, yaca miya joeque quereinola joyoe latie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yari Diosichi Nao joto, yaca tennayoe timinhe latie. Diosi Jesuca tsa laquiratori, yaca se larino jochunae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ya tarinpunlanan yabe parejo wiloratonan, yaca yucacuralaquee. ");
INSERT INTO cofNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tsan josanan yotute jerale jun tobi nemenhie peman óra fecári. ");
INSERT INTO cofNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Junni tre de la tardete Jesuri sonba pato itsantie: —Lachi Diosi, lachi Diosi, ¿niya jonan laca puraca joyun? tie. Aman israelítalachi fiquichi pato, “Elí, elí, ¿lama sabactaní?” tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Junni jun quelole raminla weyanlari yaca “elí” tinunca meráto yucale meráto, matu to Elíaca otin tinae tilatie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsanlatinunsiri tsachi manca sujito, cuwa tsanbi pele binoca atasuwato, chidebi chuteto, Jesuchi fiqui forole tilicarie yape chusa. ");
INSERT INTO cofNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Uyanla mantimini yaca te, camérantsan joe latie. Pansile Elías yaca se laribi jachunae latie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Junni Jesús manan sonba atito puyae. ");
INSERT INTO cofNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aman Diosichi ya tamo quitsabi wa jali tsan dole tinraminhe. Junni Jesús puyanasaleri, ya jali jamochi nechi jera chile sujinue. Junsi to wenasa, sunan bojinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Junsi menaranunte manforoinan, Diosica tennaminla weyanla puyaca jominlanan mansonhito, ");
INSERT INTO cofNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","menabi nechi manlolainue. Junni Jesús mansonhinunbi, ya puyaca jominla Diosichi pueblobi wilainue Jerusalén tinun pueblobi. Layanla yalaca quiralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aman Jesuca quiramin soldadolabe yalachi capitanbe to wenanunca quiralaquee. Junca quirato, titiya jera niyainanunca quirato, wepanalaito itsanlatie: —In tsachiri Diosichi tsa Nao jominue latie. ");
INSERT INTO cofNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Duque sonalanan jabi nechi Jesús puyanaminca pequiranaminlae. María Magdalena, Zebedéochi naolachi ayan, manca María quiranaminlae. Aman ya María Jacóbochi, Josechi ayan jominhe. Ya sonala uyanlabenan Galilea tobi nechi Jesube pejaca jominlanue. Yabe penenato ano pecufimin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Junni aman quepen inunbi cala tan tsachi manca janue José mumun. Arimatea pueblo tsachi jominue. Junni yari Jesube penenamin joto, ");
INSERT INTO cofNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilátochica jito Jesús puyacaca mancuwasa rocainue. Tsanque rocainan, Pilátori mancuwalaquisa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Junni Joseri Jesús puyacaca cato, sen jalichi lapinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aman José ya menaichun su chupabi bobeda cuwenta foro quisa carica jominue. Junni Josela Jesuca pirato jun forochi tsoreto, wa suca elanpolarito, foroca doto manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tsanlaquinasanan María Magdalénabe manca Maríabe jun foro catenle chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ayuna nanchi jasaino ma jonan, jera seino ma jominue. Aman ayuna nanchi mantá tan patelelabe fariséolabe Pilátochica jito ");
INSERT INTO cofNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","itsanlatinue: —Miya Pilato, Jesús casonnaminnan, duque nene pamin jominue latinue. Yari puyatonan, peman mate mansonhiyanae ticae latinue. Chiquilari jun fiquica mantenhito, nuchica jalainayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Itsanquisa tenjalaquee. Ya menaranun foroca sele cuidaisa carintsan joe yape yachi tsachila quepen jato, Jesuca mantanjilaitusa. Yaca mantanjitori, tsachilabe jera nene pato mansonhinue tilatichunae latinue. Jesús capuyatuminnan seiton quinaminhe latinue tsachilaca encanato. Aman yachi tsachila yaca mansonhinue latinari, nantanancari seitochunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Junni Pilátori itsantinue: —Soldadolaca tanjilaide! tinue. Menaranunca jito, nisi pode jonunca cuidaisa latina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Junni israelita mantaminlari junchi jito, soldadolaca cuidaisa carito, seque dosa carilaquinue. Junsi chinapechi sonba dolaquinue yape monantiya suca lasitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Junni aman israelítala jasainun ma polesi, tominco ma tseinasa, María Magdalénabe manca Maríabe menacaca manquirabi jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yala junchi jilainasa, to duque wenue. Miya Diosichi anjeli manca jamochi nechi patato, su doraminca elanpolarito, jun subi chudinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya anjeliri cunta pinda tsansi tsen jominue. Yachi camisa tsaracari fiban jominue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Junni soldadolari anjelica quirato, jelechi jowinpoto, puyaca cuwenta ito queereica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Junni ya sonala féto quiranari, anjeli yalabe itsantinue: —Jele titulajode! La mirayoe tinue. Nulari Jesús corosibi puyaca jominca quirabi jalainae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Juntonan yari inte itoe tinue. Puyaca jominnan mansonhie. Winilaide! Ya tsonun postoca quiranilaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Junni nulari yachi tsachilachica wewe jilaide! Yalaca meracarichín! tinue Jesús puyaca jominnan mansonhinueque. Junni Jesuri nulaca caquenan Galilea toca jichunae tinue. Junbi yaca manquiralaquichunae tinue. Aman nula yachi tsachilabe in fiquica jera meracarilaquina! tinue. Nulabe tsanqueri pánayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Junni anjeli tsantinunsi, sonalari menaranun forote nechi wewe manjilainue. Jele tinatonan, son tinaminlanue. Junsi Jesube penenaminlaca meracaribi sujilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jilainasa quiranari, Jesús patsanan yalabe manquiraito saludainue. Yala mantimini yachica jato, nedele cato, yachi cale telenhilainue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Junni Jesuri yalabe itsantinue: —Jele titulajode! tinue. Lachi acolaca, soquilaca meracaribi jilaide! tinue yalaca Galilea toca jilaideque. Junbi laca manquiralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Junni ya sonala manjilainasanan, menaca jominca quiramin soldadolari puebloca manjito, mantá tan patelelabe jera cuenta polarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Junni ya patelelabe mantá tan unicalabe layaito tenpalaquinue. Tenpato, soldadolachi duque cala cuwato, ");
INSERT INTO cofNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","itsantilatinue: —Nulari tsachilabe itsantilatina! tilatinue: Jesube penenaminla ya puyacaca mancalaquinue tilatina! latinue. Quepente nula catsocala josa mancalaquinue tilatina! latinue. Tsachilabe jera tsantilatina! latinue. ");
INSERT INTO cofNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aman miyari jun fiquica meránari, chiquila yabe jera cuenta quilaqueyanae latinue yape nulaca catsonun tenchi casticaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Israelita mantaminlari soldadolabe tsanlatinue. Junni soldadolari jun cala casi, tsanque palaquinue. Amanachinan israelítala jun nene cuentaca capolariminla joe. ");
INSERT INTO cofNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Junni chunca manca Jesube penenaminla Galilea toca manjilaiyoe. Aman Jesús chiquilaca mantaca jominhe ya paca duca jilainaque. Junni jun duca jito, ");
INSERT INTO cofNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesuca manquirato, yachi cale telenhilaiyoe. Tsanhinatonan weyan weyanlari miitolajoyoe; ¿tsa jonhoncan? tinamin jominlae. ");
INSERT INTO cofNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Junni aman Jesús chiquilachica jato itsantie: —Jamochinan tobinan jera mantaca lachi cuwaca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jun tenchi nula jerale tote jilaina! Piyanle tote tsachilaca micarilaquina! yape labe penenamin ilaisa. Cayaiminlaca mumunlaquina! tie lachi Apa Diosichinan, la Diosichi Naochinan, Diosichi Tencachinan ilainae tito. ");
INSERT INTO cofNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Junto yalaca micarilaquina! tie la nulaca jera mantacaca meralaquisa. La mantimini nulabe ma cura peranae tie to jeraino fecári. Jesús chiquilabe tsantie.");
INSERT INTO cofNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Itsanque Diosichi sen fiqui joe Diosichi Nao Jesucrístoca panun fiqui. ");
INSERT INTO cofNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Casale casaleri Mumunmin Juan janue. Matu mate Diosichi mantate pamin tsachi, Isaías mumun, Juanca itsanque pila chuteca jominue. Diosi itsantie tinue: Diosi yachi tenchi paminca ereyanae tie tinue nuchi cate yape minu senasa. ");
INSERT INTO cofNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ya Diosichi mantate pamin tsachiri niyanlanantiya chutunun postote sonba pato, tsachilaca itsanque payichunae tinue: Miya jano jonun tenchi jera manseilainade! tichunae tinue. Miya jano jonun tenchi minuca mansenun cuwenta, jun tsanquenan nulachi tencabinan manseilainade! tichunae tinue. Isaías tsanque pila chuteca jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Junni tsanque Juan niyanlanantiya chutunun minu mumunnaminue. Junsi itsantinaminue: —Jutsa quinunca telaquepoto, casan tala tenca mancato mumunhilaide! tinue yape Diosi nulachi jutsaca piyarisa. ");
INSERT INTO cofNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Junni junca merábi jerale Judea tobi nechi jimin jominlanue; aman Jerusalenbi nechinan jimin jominlanue. Junni jerale jutsa quimin joyoeque paminlaca Juan Jordán pibi mumunnaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Junni aman Juanchi camisa cameyo fuca quica jun jominue. Junsi quidoca sendori quica jun jominue. Popere joto, finun isube jelen china pibe ano fimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Junni tsachilaca itsanque micarinaminue: —Laca benechi manca tsachi jachunae tinue. Yari laca fécari mantá tan jochunae. Yari tsaracari sen jonan, lari yachi sapato silica bontoito woleto cuwanotiya sen itoyoe tinue seri sen jotonan. ");
INSERT INTO cofNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Lari nulaca pibiri mumunnayoe. Yari pibiri mumunmin itochunae. Yari nulaca Diosichi Tencachi mumunmin jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan tsanque micarinasanan, Jesús Galilea tobi nechi, Nasaret pueblobi nechi loto, Juánchica jinue. Junni Juanni yaca Jordán pibi mumunnue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Junni Jesús pibi nechi manlonato, yoquido lasainaminca quiranue. Junsi yachi jamo Diosichi Tenca patanaminca quiranue. Palomanan quiran ito patanue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Junsi fiquinan jamochi nechi mera jominue. Yari itsantinue: —Nuri lachi duque munatinun nao joe; nu tenchi duque son joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Junni Jesús mumunhinunsi, Diosichi Tenca yaca niyanlanantiya chutunun postoca tanjinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Junbi Jesuri junpalu chunca ma fecári quela tsanla nenanun postobi chuminca Satanás yaca jutsa quisa carichique tenfenue. Junni anjelilari jato, ti munaranuncatiya jera cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Junni Juanca dolaquinunbi, Jesuri Galilea toca manjito, Diosichi sen fiquica micarinato itsantinaminue: ");
INSERT INTO cofNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Ma feca joe tie. Diosi ya mantananun tsachi bolon suwanae tinue. Jun tenchi jutsa quinunca telaquepoto, casan tala tenca mancato, Diosichi sen fiquica quereilaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Junni Jesuri Galilea wa pipilu dequelote nenaminnan, paluca watsa caminlaca quiranue Simonbe yachi aco Andrébeca. Junni pibi ataraya quepoto nenaminlaca ");
INSERT INTO cofNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús itsantinue: —Labe penenalarana! Lari nulaca watsa canique cuwenta, tsachilaca layato labe cayaisa carimin suwanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Junni yalari atarayaca jera tsoreto, Jesube penenabi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Junni Jesús nasi jinaminnan, paluca tsachilaca quiranue. Zebedéochi naola jominlanue Jacobo manca, Juan manca. Canoabi ataraya mansenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Junni yalaca quirasi, yalacanan oticanue yape yabe penenamin ilaisa. Junni yalari yalachi apa Zebedéoca canoabi peyunlabe purato, Jesube penenabi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Junni Capernaum pueblobi féto, jasaino mate Diosichi fiqui miinun yabi wito micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Junni tsachilari Jesuchi fiquica duque wepananaminlanue. Duque mantabe micarimin jominue. Israelítala tala mantaca micariminla cuwenta micaritumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Junsi Diosichi fiqui miinun yabi layailainasa, yucanchi oco wica jun tsachi manca pewica jominue. Junni yari Jesuca sonba pato itsantie: ");
INSERT INTO cofNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús Nasareno, ¿chiquilaca ti quebi jacayun? ¿Nuri chiquilaca yucapiyaribi jacayun? tinue. Nucari mirayoe tinue. Nuri Diosi ereca jun tsara sen tsachi joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Junni yucanchi oco tsantinaminca Jesús beco pato, yaca nosasa ide! tinue. In tsachichibi nechi manlode! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Junni yucanchi ocori ya tsachica duque jowin posa carito, junsi sonba atito, yachibi nechi manlonue. Junni ya tsachiri manseinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Junni aman tsannunca quirato, piyanlela wepanato, yala tala tenpato quiranaminlanue. ¿Niyan quinan? latinue. Uyan quiraquesiri micarimin joe. Yari casan tala micarimin joe. Ya Jesuri yucanchi ocolacatiya mantánan, meráminla joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Junni moora jerale Galilea tobi Jesuca cuenta polarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jun Diosichi fiqui miinun yabi nechi loto, Jesúlari Simonbe Andrébechi yaca jilainue. Jesube Jacóbobe Juanbe junchi jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Junni aman Simonchi sonachi ayanni cupara tan tsominue. Junca Jesube palaquinue quiyanpun joeque. ");
INSERT INTO cofNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Junni Jesuri quelo féto, tedechi cato mancuparichutenue. Junni jun mancuparichutenasale, ya cupara jera manpolenue. Junni ya sonari yalachi ano poto cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Junni aman yo jera piyanasaleri, jerale quiyanpunlaca, weyanlari yucanchi oco punlaca, Jesúchica tanjalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Junto jeralela tamolan quelote jera layailainue jun pueblobi chuminla. ");
INSERT INTO cofNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Junni Jesuri duque tsachila uyan tala uyan tala quiyanpunlaca manse suwanue. Junsi duque yucanchi ocolaca jera mansularinue. Junni aman yucanchi ocola mantimini Jesuca miraminlanue. Junnan Jesuri yalaca beconan patusa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aman junni ayuna nanchi nemeneme wiruito, Jesuri pueblo dechi jito Diosibe rocainaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Junni Simonbe yachi amicolaberi Jesuca manneyabi jilainue. Junto aman yaca manfeto itsanlatinue: ");
INSERT INTO cofNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","—Jeralela nuca quirachique neyalaquinae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Junni Jesuri itsantinue: —Uyan quelole puebloca jilaisa! tinue. Junchinan micaribi jacayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Junni tsanque Jesús jera Galilea tobi Diosichi fiquica micarito nenaminue. Diosichi fiqui miinun yabi wito micaride nenaminue. Yucanchi ocolaca jera mansularide nenaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Junni man nete lepra bichi chun tsachi Jesube panhabi jato, telenhito itsantinue: —Laca nuchi manse suwano muquinari, manse suwano podeichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Junni Jesuri laqui tito, ya tsachica tedechi tale quito itsantinue: —Munarato, nuca tsaina manse suwanayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsantito tale quinunsileri, lepra bichi jera manseinue. ");
INSERT INTO cofNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Junni manseinunsi, Jesuri ya tsachica itsanque sonba payito manherenue: ");
INSERT INTO cofNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Meráde! tinue. Mobenantiya capatuminnan, patelechica jito, junbi ticatiya nasi epe cuwade! Aman matu tote Moisés Diosichi Pilabi mantaca jominue lepra bichi manseiminla ti cuwanola jonunca. Junni Jesús junca cuwasa mantanue yape jeralela miralarasa ya manseica joeque. ");
INSERT INTO cofNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Juntonan ya tsachiri yape josa! tito, jeralete jito, jeralelabe paniquinue Jesuri yaca mansequeeque. Jun tenchi Jesuri tsachila quiralaquinasa pueblobi wino podeitunue yape tsachila yaca quirachique dilapoilaitusa. Pueblo dechisiri chudito, tsachilabe quiraimin jominue. Juntonan jerale jun tobi nechi tsachila quirabi janaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Junni weyan ma polenunbi Jesuri Capernaum puebloca manjanue. Junni yabi manchueque meráto, ");
INSERT INTO cofNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","duque tsachila tamochi jera layailainue. Tamochi jera quidi poleto, tamolanle jera wiruraminlanue. Junbi Jesuri Diosichi sen fiquica yalaca micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Junnasa junpaluca tsachilari wecaino podeiton tsachi mancaca Jesúchica tanjanaminlanue. Yaca jali cuyanbi poto nanato tanjanaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Junni tsachila dilapowalaranan, Jesuchi fecári wichi tinatonan, podeilaitunue. Junni Jesús wiruranun tule jamochi yaca foroto, jun forose quiyanpun tsachica patarilaquinue jali cuyanbi punca. ");
INSERT INTO cofNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aman junni Jesuri yaca tennaminla jonunca miito, ya quiyanpunbe itsantinue: —Lachi nao, nuchi jutsaca jera piyarinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Junni Jesús tsantinasa, weyan israelítala tala mantaca micariminla juntele chuminlanue. Junni yalari itsanque tenca canaminlanue: ");
INSERT INTO cofNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿In tsachiri niyaito tsanque pánan? Diosica seitonque pánae. Diosisiri jutsa piyarino podeimin joeque tenca canaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Junni Jesuri yala tsanque tenca canaminlaca moora miito itsantinue: —¿Nulari niya jonan tsanque tenca calaquinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿La quiyanpunchi jutsaca piyarinayoe tituan? tinue. Tsanque pacachi panori layan tenfe itoe. Juntonan quiyanpunca mancupato jalica mancato mannenasa carino, ya fe tenfe jochunae tinue. La mantimini palu cosacanan quino podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","La tsachi ica jun joto in tote jutsaca piyarinonan mantá tan joyoe. Yape mantá tan jonunca miilaisa, fe tenfe jonuncanan quechinayoe tinue. Junni mantá micariminlabe tsantisi, quiyanpunbe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—La nuca mancupade! tinayoe tinue. Jalica mancato yaca manjide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jesús tsantinunsi, quiyanpun jomin tsachiri mancupato, jalica mancato, tamochi nechi jeralelachi cale loto manjinue. Piyanlela wepanato quiranaminlanue. Junni aman piyanlela Diosica duque seque pato itsanlatinue: —Itsanquinuncari numatotiya quiratumin jominlayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aman Jesús man nete wa pipilu dequelole jinue. Junnasa duque tsachila yachi quelote jera layailainan, yalaca micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Junni junte nenaminnan, Levica quiranue Alféochi naoca. Yari uyan to miyachi tenchi inpuesto cala camin joto, inpuesto canun postote chuminue. Junni Jesuri Levica junte chuminca quirato, yaca itsantinue: —Labe penenamin ide! tinue. Junni Leviri junte nechi cupato Jesube penenabi pejinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Junni aman Jesube yachi tsachilabe Levíchite ano pefinaminlanue. Junsi duque uyan tsachila ano pefibi jaca jominlanue. Weyanlari inpuesto camin jominlanue Leví cuwenta. Weyanlari israelítalachi mantaca tennatumin jominlanue. Yala layanla Jesube penenamin ica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Junni israelítala tala mantaca micariminlabe fariséolabe quiralaquinue Jesús jun seitonlabe ano pefito chuminca. Junto Jesuchi tsachilabe itsanque panhalaquinue: —¿Jesuri niyaito in seiton quiminlabe ano pefinan? latinue. Israelítalachi mantaca tennatuminla joe. Weyanlari ti quiran uyan to miyachi tenchi chiquilaca inpuesto caminla joe. ¿Niyaito Jesuri tsan quira seiton tsachilabe ano pefinan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Junni Jesuri yalaca tsanque pánanunca meráto itsantinue: —Quiyanpun itonlari doctorilaca munaralaratuchunae tinue. Quiyanpunlari doctorilaca munaralarachunae. Junni la doctor cuwenta joto, Sen joyoe timinlachi tenchi jatucayoe. Jutsa quiminlacari labe cayaisa tibi jacayoe tinue. Jesús fariséolabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Junni Mumunmin Juanbe penenaminlanan, fariséolanan ano fitunca ito nenaminlanue. Junnasa tsachila jato, Jesube itsanque panhalaquinue: —Mumunmin Juanbe penenaminla israelítalachi mi tala nenato, ano fitunca icala joe. Fariséolabe penenaminlanan tsanhicala joe latinue. Aman nube penenaminla mantimini ano ticatiya finiquiminla joe. ¿Niyaito tsanquiminla jun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Junni Jesuri yalachi fiquica meráto, beconan itsantinue: —La casalainamin cuwenta joyoe tinue. Junni casalainanun fiesta quirabi jaminlari duque son tinato, ano fitunca ilaituchunae. Ya casalaino jun tsachi yalabe parejo cajosanan, yalari son tito, ano fitunca ilaituchunae. Jun tenchi lari lachi tsachilabe penenasanan, ano fitunca ituminla joe. ");
INSERT INTO cofNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Juntonan manca mate mantimini la itoanae tinue. Laca josolelaquichunae. Junnunbi labe penenaminla weyante ano fitunca ilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","O yape la micarinanunca fe miilaisa, aman manca cuentaman quechinayoe foroica panuca. Unica panu foron jonari, casan panu catachituminnan junbi natiya orotuntsan jochunae. Junni tenca iton tsachiri unica panubi casan panu pitica manchuteniquinari, ya casan piti piyanari, nantanan fe ayan foron ichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Junsi binocanan tenca calaquede! tinue. ¿Chibo quidoca tolo quito bino pomanco? Aman ya tolo unica jonari, junbi casan binoca potuntsan jochunae tinue. Tenca iton tsachiri poniquinari, junni bino sonba pi isiri, tolo unicaca chilechunae tinue. Junto binonan tolonan yucapiyachunae tinue. Jun tenchi casan binoca casan tolobi pontsan jochunae tinue yape palunan sen josa. Jun tsanquenan la casan micaricaca meráto nenamin tsachila matu micaricaca tennatuntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Junni jasaino mate Jesúlari witase poleto jinaminlanue. Jun jilainaminnan yabe penenaminlari tricoca nasi balecato fidede jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Junni fariséolari junca quirato Jesube itsanlatinue: —Jasaino mate trabajaquinola itoe. Tsan josanan, nube penenaminlari tricoca balecanilaquinae. ¿Niyaito mantaca merátuto tsanquilaquinan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Junni Jesús manpato itsantinue: —Matu to miya Davica pila chutecaca mantenhilaide! tinue. Davibe yachi tsachilabe epe tsachila fitunun bibuca finilaquinue tinue. Mantá jominue patelelasiri ya bibuca filaquisa. Tsan josanan, ano mochi pasainato, David Diosichi yabi wito, Diosichi cuwaca jun bibuca cato fito, yabe penenaminlachinan cuwanue tinue. Abiatar tinun tsachi mantá tan patele josa, tsanque finilaquinue. Junni Davila tsanquicala josanan, nula yalaca culpa quituminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Junsi Jesús fariséolabe itsannan tinue: —Jasaino maca Diosi tsachilachi tenchi quinue tinue. Tsachilaca jasaino ma tenchi quitunue tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Juntonan lari tsachi ica jun joto jasaino matenan titiya quino mantá tanirayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Junni aman man nete Jesuri Diosichi fiqui miinun yabi winue. Junbi tsachi manca tede encon pechunue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aman weyanla junte quiranaminlanue manse suwachunanque quirachun. Junni manse suwanari, Jesuca culpa patarino jominlanue jasaino mate trabajaquimin joe tito. ");
INSERT INTO cofNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Junni Jesuri ya tede encon tsachica intele quitsale wiruide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jun tsantisi, aman culpa quichi timinlabe itsanque panhanue: —¿Diosichi Pilabi niyaque mantaca jun? tinue. ¿Jasaino mate ti quino jun? tinue. ¿Seque quino jun, o seitonque quino jun? ¿Quiyanpunlaca manse suwano jun, o puyasa quiraniquino jun? tinue. Junni yalari nosasa jera wiruraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Junni Jesús yalaca duque pa quiranue. Junsi yalari entendeituchi timinla jonun tenchi duque laquiinue. Junsi ya quiyanpun tsachibe itsantinue: —Tedeca mantuquede! tinue. Junni yari tede mantuquesi manseinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Junni fariséolari junca quirato, junte nechi manloto jito, Heródechi bolonlabe layaito jera tenpalaquinue Jesuca niyaque totentsan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Junni aman Jesuri yabe penenaminlabe wa pipiluca jilainue. Junnasa duque tsachila Galiléabi nechi Jesuca bene pejilainue. Jesús sen cosa quinanunca jera meralaquinue. Junto jeralete nechi jalainue. Judéabi nechi, Jerusalenbi nechi, Iduméabi nechi, Jordán pi becochi nechi, Tírobi nechi, junsi Sidonbi nechi jera quirabi jalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Duque quiyanpunlaca manse suwamin jonunca mirato, quiyanpunlanan Jesuca taquirachique duque tenfelainue. Jun tenchi Jesuri yabe penenaminlaca canoaca quelole tasa mantanue jun canoabi wichun yape layan tsachila dilalaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aman yucanchi ocolari Jesuca numasitiya quirato, yachi cale telenhito itsanque atimin jominlanue: Nuri Diosichi Nao joe timin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Juntonan Jesuri ya yucanchi ocolaca sonba mantanue ya mo jonunca palaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Junni wanbileri Jesuri dubi loto, weyanlaca yachi munate wenteto, yalaca oticanue. Junni yalari Jesúchica jalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Junsi aman chunca palucacari wentenue yape yachi mantá petanla josa. Yabe penenaminla joto, ya ereca jun jito, Diosichi sen fiquica micarino jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Junsi mantá jera cuwanue yape quiyanpunlaca manse suwan, yucanchi ocolaca mansularin, quito nenalarasa. ");
INSERT INTO cofNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inlari chunca paluca jominlanue: Casale Simón; aman yaca Jesús tensaato mumun poto Pedro tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Junsi Zebedéochi naola jominlanue Jacóbobe Juanbe. Jesús ya acola palucaca Boanerjé tinue. Yalachi fiquichi Boanerjé tito “cunta cuwenta tsachila” tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Junsi Andrés, Felipe, Bartolomé, Mateo, Tomás, manca Jacobo jominlanue. Ya Jacobo Alféochi nao jominue. Junsi Tadéobe manca Simonbe jominlanue. Ya Simón cananita tinun bolonbi pejomin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Junsi Judas Iscariote jominue. Ya Judas Iscariote nanni ina Jesuca pa jominlachi cuwapono jominue. Junni Jesube yabe penenaminlabe yachica manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Junni manan junte duque tsachila layailainue. Duque tsachila layailainanan, Jesúlari ano finotiya jola itominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Junni junca meráto Jesuchi familiala Jesuca tanjibi jalainue loco inae tito. ");
INSERT INTO cofNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Junnasa israelítala tala mantaca micariminlanan jalainue Jerusalenbi nechi. Junto yalari Jesuca itsanlatinaminue: —In tsachiri tenca mánta yucanchi ocolaca mansularitumin joe; yucan yachibi wica joe. Junto Beelzebú tinunchi mantateri yucanchi ocolaca mansularino podeimin joe latinue. Aman yalachi miteri yucanca Beelzebú tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Junni Jesuri yalaca jacarito itsanque cuenta polarinue yalaca micarichun: —¿Ti quichun laca yucanchi mantate yucanchi ocolaca sularinae latinayun? La yucanchi mantate yucanchi ocolaca mansularinari, yucanla tala sularicaanun cuwenta jochunae. Yucan numanan tencachique ocolaca mansularituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Itsanque jochunae: Man tori chun tala quera quicaalaquitori, jun to jeraichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O junsi man familia tala pataalaquitori, layaito chuno podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Junni yucanchi ocola tala sularicaalaquitori, jun cuwenta jochunae tinue. Jerailaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Junni Jesús tsantisi, yucanca man fiquiman pato itsantinue: —Yucan sonban tsachi cuwenta joe tinue. Junni sonban tsachi tanunca josolechun, casale yaca fe loto teleno jochunae. Lari wari yucanca fe lotumanpari, yachi ocolaca mansularino podeituno jomin joinhie tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nulabe tsarasica pachinayoe: Tsachila ti jutsatiya quinari, o niyaquetiya seitonque panari, junca perdonaintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Juntonan Diosichi Tencaca seitonque paminlacari numatotiya ya jutsaca piyarituntsan jochunae. Tsantiminlari numatotiya culpa tato polelaichunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yalari Jesús Diosichi Tencachi sonbabe quicaca pato, Yucanchi ocobe tsanquinae tinaminlanue. Jun tenchi Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Junni aman Jesuchi ayan, acola jalainue. Junto urachi wirurato tsachi mancaca erelaquinue yape Jesuca tamochi nechi tanlasa. ");
INSERT INTO cofNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Junni Jesuchi awinta chuminlari itsanlatinue: —Nuchi ayan, nuchi acola urachi wiruralarae latinue nube cuenta quechique. ");
INSERT INTO cofNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Junni Jesuri manpato itsantinue: —Junte wiruraminla lachi tsa ayan, tsa acola josanan, yalacari ayan, aco titumanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Junsi yachi awinta chuminlaca quirato itsantinue: —Inlaca lachi ayanla, lachi acola lachi soquila timanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jeralela Diosichi mantaca meráminlacanan lachi acola, lachi soquila, o lachi ayanla tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Junni mannaman Jesús wa pipilu fiquile micarinaminue. Junni duque tsachila Jesúchica janan, Jesús jun pipilubi canoa tsominbi wito chudinue. Junni jerale tsachila jun pipilu fiquile jera wirurato meranaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Junni yalabe duque micarinun cuenta polarinato, itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Inca meralaquede! tinue. Tsachi manca ni aralebi jichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Junni ni aralenasa, weyan niri minubi queereichunae. Junca pichu jato finiquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Junsi weyan niri nasiri to tson subi arajichunae tinue. Junto ya niri moora suchunae nasiri to tsonan. ");
INSERT INTO cofNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Juntonan pata chibachi jera luban lato jequeichunae tinue tenpe telenle quino podeituto. ");
INSERT INTO cofNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Junsi weyan niri tsala minu arajichunae. Junca tape fe uwaito, sunamin nacaca jera doquicaniquichunae tinue. Jun tenchi ni chudituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Manan weyan niri sen tobi arajito uwaito, duque ni mancuwachunae. Weyan niri ni curanan peman chunca ni mancuwachunae tinue, manan weyan ni sota chunca ni, weyan ni patsa ni mancuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Junni Jesús ya cuenta quesi itsantinue: —Nula punqui chunla jotori, seque meralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nasi wanbile weyan tsachila jera manjinunsi, chunca paluca Jesube penenaminlanan, weyan Jesuca meráminlanan, Jesube cachuminlanue. Junni yalari Jesús cuenta quicaca panhato manmeralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Junni Jesuri yalabe itsanque manpanue: —Diosi ya mantananun tsachi bolonca niyaque serawono jonunca nula miinola joe tinue. Casaleri miituntsan jominue; amanale nechi nulari miralarachunae tinue. Merátuchi timinlaca mantimini cuentabesiri micarimin joyoe tinue ");
INSERT INTO cofNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yape meránatonan entendeilaitusa, yape quiranatonan seque quiralaquitusa. Entendeilaimanpari, Diosibe cayainan, Diosi yalaca perdonaino jomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Junni Jesús itsantinue: —Nulari in micarinun cuentaca entendeitutori, ¿niyaito weyan micarinun cuentacanan entendeilaichun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ni aralemin tsachiri Diosichi fiquica tencabi waquemin cuwenta jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Weyan tsachilachi tencari minubi polo ton cuwenta jolajochunae tinue. Yalari Diosichi fiquica meránasanan, yucan janiichunae. Yucan jato, fiqui tencabi meraca jominca jera manlarichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Junsi weyan tsachilachi tencari su jamote nasi to tson cuwenta jolajochunae tinue. Yalari jun órari Diosichi fiquica son tito meralaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Junni telenle potuca jun cuwenta moora fecári tennaminla joto, peleilaichunae tinue. Diosichi fiquica meráto nenamin jonun tenchi padeseinato, peleilaichunae tsachila pasuwalaquinae tito. ");
INSERT INTO cofNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Junsi weyanlachi tencari tsala to cuwenta jolajochunae. Yalari Diosichi fiquica meránato, ");
INSERT INTO cofNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","junto niyaque sonnanoca, cala canoca, wepanato nenalarachunae tinue. Jun tenchi Diosichi sen fiquica tennatuminla joto, natiya sen itulajochunae tinue. Tsanque titiya munaranunca tenca canato, Diosichi fiquicari jera piyariminla jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Juntonan weyanlachi tencari sen to cuwenta jolajochunae tinue. Yalari Diosichi fiquica seque meráto tennalarachunae. Junto duque sen ilaichunae tinue peman chunca ni chudinun cuwenta, weyanla sota chunca ni chudinun cuwenta, weyanla patsa ni chudinun cuwenta. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Junni Jesuri itsannan tinue: —Lanparin tulitori, perolichi dilancaritunoe. O lowa tenpenan chutetunoe. Lanparinca tulitori, jamobi chutenomanhe yape tsesa. ");
INSERT INTO cofNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Junni la micarica jun fiquiri jun tsanquenan jochunae. Amana miituntsan jonunca inari jera miintsan jochunae. Amana tuca micaritununca man mate jeralelaca tuca micarintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Junni nulari punqui chunla jotori, seque meralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Junni Jesús tsantisi yalabe man fiquiman panue: —Seque tenca cato meralaquede! tinue. Ti medidatetiya cuwalaquinari, jun medidatenan mancuwalaquichunae. Junni tsanquenan nulari nasi meralaquinari, Diosi nulaca nasiri miisa carichunae tinue. Duque meralaquinari, duque miisa carichunae tinue. Junsi nantanan fécari miisa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Junsi fe miraminlacari Apa Diosi fe miisa carichunae; miituchi timinlachicari nasiri miranuncatiya manjosolechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Junni Jesuri itsantinue: —Diosi mantananun tsachi bolonni witabi sumin ni cuwenta jochunae tinue. Nica tobi araleca jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Junni nica araletobi, waquemin tsachiri mérachunae. Quepen catson, malon mansonhin, tin nenato mérachunae. Junni tobi araleca jun niri suto jera uwaichunae tinue. Junni junca ya tsachiri niyaito sunanunca natiya miitochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Junni tori tenca mántanan nica uwaisa carimin joe. Casale japisu larin, junsi aman taran in, junsi taran ayancaitobi aman ni chudiniimin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Junca aman balentsan inunsiri balelaquichunae. Junbiri numa baleno ma faca joe. ");
INSERT INTO cofNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aman junni Jesús itsantinue: —¿Diosi mantananun tsachi bolonca niyaque pantsan jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostasa ni cuwenta jochunae tinue. Mostasa niri waquenasari, piyanle nica fe tsanini nacá joe. ");
INSERT INTO cofNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Juntonan waquenari, uwaitobiri, piyanle uyan tapelaca fe jelelen wa chide pele imanhe. Alinan wa ali imanhe. Pichula titiya jun alibi tasen quino podeintsancari wa chide pele imanhe tinue. Junni Diosi mantananun tsachi bolonca serawonato, jun cuwentanan quichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Junni Jesuri tsanque Diosichi fiquica micarinaminue. Micarinun cuentaca polarinato micarinaminue nisi entendeino podeino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Micarinun cuentaca polarituminnan, micaritumin jominue. Juntonan jun micarinun cuentacari yabe penenamin tsachilaberi jera tuca manmicarimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aman Jesús tsanque micaritobi, jun matenan neme ino inasa, yabe penenaminlabe itsantinue: —Wa pi pilu becochi jilaisa! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Junni tsachilaca junte jera purato, Jesúcari yala ponun canoabi wa pi pilu becochi tanjilainue. Weyan canoanan pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Junnasa duque sonban wu jato, wa pipilu latsaca jera wecacarinue. Junsi pi busuca canoabi jera tuwale winaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Junnasa Jesús mantimini canoabi bene nanchi oton lowabi catson tsominue. Junni yaca mansoncarito itsantilatinue: —Miya, ¿pibi daipatilaichinanunca niyaito tennatiyun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Junni Jesuri mancupato, wucanan, picanan mantato itsantinue: —Nosaide! Deide! Junni Jesús tsantinunsi, wuri jera mandeito jera owowo inue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Junsi Jesuri yabe penenaminlabe itsantinue: —¿Niyaito nulari tsancari jele tinaminlayun? ¿Niyaito Diosica tennalaratiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Junni yalari duque wepananato, Jesuca itsanticaalaquinue: —¿Inni ti tsachi junhun? tilatinue. Yacari wunan, wa pipilunan meráminla joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Junni aman Galilea tobi nechi jito, wa pipilu becochi poleto, Gadara tobi felainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Junni aman Jesúlari wa canoabi nechi manlolainasa, yucanchi ocola wica jun tsachi pantiyonbi nechi janue Jesube tulaibi. ");
INSERT INTO cofNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ya tsachiri yabi chutumin jominue; pantiyonbi chumin jominue. Junsi aman ya tsachicari monantiya mancano podeitumin jominlanue. Nin cadenachitiya teleno podeitunun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Duque neca cadenachi tedebi, nedebi teleto peleimin jominlanue. Juntonan ya tsachiri cadenaca jera daratalulu quimin jominue. Monantiya yaca feino podeilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Quepen, malon du minu junsi pantiyonbi atide nenato, su cato tencachiquenan fudaito nenamin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Junni Jesuca nuwiri nechinan quirato, we sujato Jesuchi cale telenhinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Junni Jesuri yaca mantato itsantinue: —In tsachichibi nechi manloto jide! tinue. Junni yucanchi ocolanan sonba atito pato itsanlatinue: —Jesús, ¿nuri chiquilaca niyan quebi jayun? latinue. Nuri jamochi chumin Diosichi Nao joe. Diosi meránasa rocainayoe tinue chiquilaca yucapiyaritusa. ");
INSERT INTO cofNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Junsi Jesuri ti mumunyunque panhanue. Junni yalari itsanlatinue: —Duque jolajoyoe. Junto chiquilaca Ejersito tinunlayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Junni yucanchi ocolari Jesube duque rocailainue junte nechi nuwiri eretusa. ");
INSERT INTO cofNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Junnasa mantimini wa du depante duque cuchi lapa fito nenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Junni jun cuchichi fecáriri eredeque rocailainue. Jun cuchichibiri manwisa carideque rocailainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Junni Jesuri yucanchi ocolaca cuchichi fecáriri jisa carinue. Junni yucanchi ocolari ya tsachichibi nechi manloto, ya palu mili tsansi cuchichibi jera manwilainue. Jun winunsileri, cuchiri wa duse jera supatito, wa pipilubi jadito, jera puyalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Junni cuchica cuidaiminla mantimini junca quirato, puebloca jera mansujilainue. Jun tsanhicaca piyanlelabe cuenta quede quede sujilainue. Junni jun pueblobi nechi tsachilari quirabi jalainue niyaito tsanhinunca. ");
INSERT INTO cofNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Junto Jesúchite falainue. Junto yucanchi ocola pun jomin tsachica sen manchuminca manquiralaquinue. Camisa manpun, junsi seque tenca tan manchuminue. Junni junca quirato jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Junni manseinaminca quiraminlari jera cuenta quilaquinue Jesuri niyaque yucanchi ocolaca jera mansularinunca. Junsi cuchicanan cuenta jera quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Junni jerale Gadara tobi chuminlari Jesuca rocailainue junte nechi manjideque. ");
INSERT INTO cofNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Junni Jesuri canoabi manwinasa, yucanchi oco pun jomin tsachiri Jesube pato, nube pejino muqueeque rocainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Junni Jesuri yaca petanjituchique yabe itsantinue: —Nuchi yaca manjito, nuchi familialabe jera cuenta quina! tinue. Miyari nuca duque seque queeque yalabe cuenta polarina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Junni ya tsachiri manjito, Decápolis tobi cuenta jera polarinue Jesuri yachi tenchi duque seque queeque. Junni jeralela junca wepanato meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Junni Jesuri canoachi wa pipilu becochi nechi manjanasa, duque tsachila jato méraminlanue. Junni Jesuri wa pipilu fiquite wiruranan, tsachila yachi awinta layailainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Junnasa Diosichi fiqui miinun yabi mantamin tsachi janue Jairo mumun. Junni yari Jesúchica jato, cale telenhito, ");
INSERT INTO cofNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","itsanque pato duque rocainue: —Lachi namari puyachinae. Nuri yaca tedechi tale quito manse suwabi jisa! tinue yape manseito mansonnasa. ");
INSERT INTO cofNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Junni Jesuri ya Jáirobe pejinasa, duque tsachila pejinaminlanue. Duque dilapun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Junnasa quiyanpun sona manca pejominue. Ya sonari chunca palu watale nechi ma cura luban quirato nenamin sona jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Duque padeseito nenamin jominue. Yacari monantiya manseno podeitumin jominlanue. Duque janpeinatotiya nantanan inamin jominue. Calaca jera castainaminue. Titiya tanunca jera iton inaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Junto Jesuca meraca joto, ya sona nosasa Jesuchi bene nanchi nechi jato yachi camisa puntale taquiranue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Duque quiyanpun jotonan, Jesuchi camisacatiya taquirasiri manseiyanaeque tenca canue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Junni Jesuchi camisa puntale taquiranasaleri, luban quirananun mandeinue. Junsi yachi pucabi tenhinue quiyanpun jomin manseiyoeque. ");
INSERT INTO cofNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Junni Jesuri yachi sonbabe tsachi mancaca manse suwayoeque tenhito, bene nanchi manquiraereto panhanue ¿Mo lachi camisaca taquiran? tito. ");
INSERT INTO cofNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Junni yabe penenaminlari itsanlatinue: —Nuri ichiricari tsachilachi quitsabi joe. ¿Junni niyaito ¿Mo taquiran? tinayun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Junni Jesuri piyanlelaca jera quiranue mo yaca taquiraca jonunca miichun. ");
INSERT INTO cofNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Junnasa ya sonari jelechi jowinpode Jesúchile jasi telenhito, tsarasica jera paniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Junni Jesuri ya sonabe itsantinue: —Nama, nuri laca tsarasi tennato manseinue. Pansi manjiniide! tinue. Nuchi quiyan jera manseica joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Junni Jesús ya sonabe cacuenta quinasanan, Diosichi fiqui miinun yabi mantaminchi yabi nechi tsachila jalainue. Junto ya tsachilari nachi apabe itsantilatinue: —Nuchi namari numa puyae tilatinue. Junto Miya Jesuca jasa carituntsan joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Junni Jesuri ya tsachila tsanlatinunca natiya tennatuto, ya nachi apaberi itsantinue: —Natiya jeleratude! Quereicachiri seque quereide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","38","Junni ya nachi apachi yabi fenasari, belainaminlari wareto atito firara tinaminlanue. Junni Jesuri uyanlaca petanjituto, pemanca tsachilacari petanjinue Pédroca, Jacóboca, junsi Jacóbochi aco Juanca. ");
INSERT INTO cofNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aman junni Jesúlari tamochi wito, belainaminlaberi itsantinue: —¿Ti quichun nulari tsancari wareto atito firara tilatinayun? Ya na puyaca itoe. Catson tson rae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Junni belainaminlari miraminlanue tsa puyaca joeque. Jun tenchi Jesuchi fiquica meráto, cacarilaquinue. Junni aman Jesuri ya tsachilaca jera urachi larinue. Junsi ya nachi apabe ayanbeca, junsi Jesuchi pemanca tsachilacari, ya na tsonun tamochi petanwinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Junsi ya puyaca jun náca tedele cato, israelítalachi fiquichi pato itsantinue: —Talita cumi tinue. Tsanque patori, nama, nuca manwiruide! tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jun tsantinunsileri ya nari manwiruito mannenanue. Aman chunca palu wata tan jominue. Junni junca quiraminlari duque wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Juntonan Jesuri ya náca tsanque mansoncarieque mobenantiya patusa sonba mantanue. Junsi aman ya puyaca jomin nachi ano mancufisa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Junni Jesube yachi tsachilabe junte nechi manjito, Jesús uwainun puebloca manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Junni jasaino ma fenunbi, Jesuri Diosichi fiqui miinun yabi wito micarinaminue. Junni duque tsachilari wepanato meráto itsantilatinue: —¿In Jesuri niyaito tsancari miica junhun? Tsancari wepanato quirantsancari seque quimin joe. ");
INSERT INTO cofNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Yari carpintero jotun Maríachi nao? Junsi yachi acolari chiquilachi quelote chularae Jacobo, José, Judas, junsi Simón. Yalanan yalachi soquilanan intele chularae tilatinue. Junto Jesuca quereituchi tito, pailainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsan josanan Jesuri yalabe itsantinue: —Diosichi mantate paminlaca piyanlete respetailaichunae tinue. Tencachique pueblobisiri, o tencachique yabisiri yalaca natiya respetailaituchunae tinue. Jun tsachilanan, junsi yalachi familialanan natiya respetailaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Junni jun pueblobi layan wepanato quirantsancari seque quino podeitunue. Narin quiyanpunlacasiri tedechi tale quito manse suwano podeinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Junnan tsachila quereituminla joeque duque wepananue. Junsi Jesuri jun pueblolate jeralete micaridede nenaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Junni chunca paluca yabe penenaminlaca jera oticato, paluca paluca erenue yape yachi mantate micarito nenalarasa. Junsi yucanchi ocolaca sularilaquisa mantá cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Junsi tsanque micaribi jinato, tinantiya tanjitusa mantanue nin tolo, nin ano, nin cala. Tola mande nacasiri tanjilaisa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapato ponunberi, camisacanan manquiri, natiya paluqui tanjitusa tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Junsi aman itsantinue: —Manca yabi féto, junbisiri chularana! jun pueblobi nechi manlono fecári. ");
INSERT INTO cofNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Junni pansile manca pueblobi nulaca facarituchi latinari, o merátuchi latinari, yalaca telaquepolaquina! Junsi nulari junbi nechi manlonato, to poyo nedebi midicaca jera manpiquisito manjilaina! tinue. Junbi chuminlaca seiton jolajoe tito to poyoca piquisilaquina! tinue. Aman tsarasica pachinayoe: To yucapiyarino mate Sodoma pueblobi, Gomorra pueblobi chumin jominla duque casticailaichunae. Juntonan nulaca facarituchi timinlari jun pueblobi chumin jominlaca fécari duque animali casticailaichunae tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Junni Jesús tsantinunbi, yalari jilainue. Tsachilachi tencari casan tala tenca mancanola joeque micaribi jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Junsi duque yucanchi ocolaca mansularilaquinue. Junsi duque quiyanpunlachibi aseite ilipoto manse suwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Junni Jesuca duque mera jonunca miya Herodes meránue. Junca jera merátonan, mo jonunca miino podeitunue. Junto weyanla pato, Jesuca Mumunmin Juan jonhoe tilatinue. Pansileri yanan puyaca jominnan, mansonhica jonhoe tilatinue. Jun tenchi tsancari wepanato quirantsancari quimin jonhoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Junsi weyanla mantimini matu to Diosichi mantate pamin tsachi puyaca jomin mansonhica jonhoe tilatinue. Weyan weyanla mantimini tsan jonhoe tito, Elías tinun jonhoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Junni Herodes junca meráto itsantinue: —Juáncari misu butunsa caricayoe tinue. Ya mansonhica jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Aman Mumunmin Juan itsanque puyaca jominue: Herodes yachi acochi sonaca josoleca jominue. Felípechi sona jominue Herodías mumun. Junni Mumunmin Juan junca meráto, Heródeca payica jominue. Acochi sonaca josoletuntsan joe tica jominue. Junni ya sona Heródeca mantasa carica jominue Juanca cadenachi teleto dolaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Junni ya sonari Juanca pa jotonan, totesa carichi tinatonan, catotesa carino podeica itominue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heróderi Juanca Diosichi sen tsachi jonunca miraminue. Junto duque jelerato totesa carica itominue. Junni Juan micarinaminca meráto, Herodes layan entendeitunue. Tsan jotonan son tito meraniquimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Junni Heródechi wata tula ma fenan, ya sonari Juanca totesa carino podeinue. Jun mate yari tenientelaca, capitanlaca, junsi Galilea to oco tsachilaca jera meracarito, fiesta ano fimiyanaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Junnasa Herodíachi namari jun tamochi wito teraquinue yape Heródela quiralaquisa. Junni Heródebe yabe pechuminlaberi duque se joe tito quiralaquinue. Junni miyari ya nalalan sonaberi itsantinue: —Nu tica panhanatiya, cuwaniqueyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Junni Diosi mirasa juraquito pánayoe tito itsantinue: —Tica panhanatiya cuwaniqueyanae tinue la tanunca quitsa fecáritiya. ");
INSERT INTO cofNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Junni ya nalalan sonari urachi manloto yachi ayanbe panhato itsantinue: —¿Tica panhano joinhin? tinue. Junni yachi ayan mantimini Mumunmin Juanchi misuca cuwasa tide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Junni ya nalalan sonari wewe tamochi manwito, miyabe itsantinue: —Amananan Mumunmin Juanchi misuca wa nidabi cuwade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Junni ya miyari duque laquiinue. Juntonan juraquito paca joto, junsi junte pechuminlanan meracala jonan, nene patuchique cuwaniquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jun óratenan miyari soldadoca Juanchi misuca tanjasa mantato erenue. Junni soldadori Juan doranunca jito Juanchi misuca porecato, ");
INSERT INTO cofNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","wa nidabi pocato tanjato, ya nalalan sonachi cuwanue. Junsi ya sona yachi ayanchi cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Junni Juanbe penenamin jominlari junca meráto, Juan puyacaca mancato menalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Junni aman Jesús mantato ereca junlari yachica manjato, yabe cuenta jera manquilaquinue titiya jera quinunca junsi jera micarinunca. ");
INSERT INTO cofNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Junni junteri duque tsachilari jan, weyanni manjin, ilainanan, yalari ano finotiya jola itominlanue. Junnan Jesuri yalabe itsantinue: Monantiya chutunun postoca nasi jasaibi jilaisa! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Junni Jesube yabe penenaminlaberi wa canoabi wito, tsachilaca purato, niyanlanantiya chutunun postoca jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Juntonan duque tsachilari Jesuca junchi jinaminca quirato miito, yalanan jerale pueblobi nechi bene jilainue. Nedechi jinato, Jesúlaca caquenan felainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Junni Jesuri canoabi nechi loto quiranari, duque tsachila méraminlanue. Junto yalaca quirato duque laqui tinue cuidaimin iton opisa cuwenta jolajoe tito. Junto yalabe duque sen cosalaca micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Junni wari duque quebi inasa, Jesube penenaminlari yachica jato itsantilatinue: —Inte niyanlanantiya chutunun posto joe latinue. Duque quebi inae. ");
INSERT INTO cofNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Junni tsachilaca jera manherede! tilatinue yape quelote puebloca jito, ano cato filaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Junni Jesuri itsantinue: —Nulari yalachi ano cufilaquede! tinue. Junni yalari manpato, chiquilari duque animali bibu canola joichunae latinue yala jeralelachi michi suwachun. ");
INSERT INTO cofNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Junni Jesuri itsantinue: —¿Nulari niyanca bibu talarayun? tinue. Jera quiralaquechin! tinue. Junni yalari jera quiratobi, itsantilatinue: —Manteca bibu, junsi watsa palucari talarayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Junni aman Jesuri yachi tsachilabe itsantinue: —Ya tsachilaca lapabi chutelaquede! Bolonto, lapabi jeralelaca chutelaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Junni aman tsachilari tsanque patsa tsansi, o mante chunca tsansi bolonhito jera chudilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Junnasa Jesuri ya manteca bibuca, junsi paluca watsaca cato, jamochi quirato, Diosibe acradeseinue. Junsi aman Diosibe acradeseitobi, watsabe bibubeca pisuleto, yabe penenaminlachi cuwanue yape junte chumin tsachilachi cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Junni jeralela peyale filaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Junnasanan puchuicaca manlayato, chunca palu tsalabi tuwale manlayalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Junni yala ano fimin tsachilari, unilalacasiri minan, mante mili tsansi tsachila jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Junni jerale ano fitobi, Jesuri yabe penenaminlabe itsantinue: —Nulari canoabi wito, wa pipiluca polelainade! Laca caquenan Betsaida fecári jilaide! tinue. Junnasa lari tsachilaca manherechinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Junni aman Jesús tsachilaca manheretobi, du minu jinue Diosibe rocaibi. ");
INSERT INTO cofNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Junni nemeinasa, canoachi jun wa pipilu quitsabi jinaminlanue. Junni Jesuri mancasiri jun pipilu fiquitenan cajominue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Junni nuwiri jinaminlaca quiranue. Wu duque quinanan, we jino podeica itominlanue. Yalachi nan talasiri wu duque quinaminue. Junni Jesuri tseino inasa, pi jamoca nedechi yalachica jinue. Juntonan yalaca manpolenaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Junni yalari tsanque pi jamoca nedechi jinaminca quirato, jeralela duque jelechi atinato, puyan oco jonhoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Junnasaleri Jesuri pato itsantinue: —Sonba tenca ilaide! Jeleratulajode! tinue. Lanan joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Junni Jesús canoabi winunsi. duque wu quinaminnan mandeinue. Junni yalari junca duque wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Juntonan bibuca duque suwaca josatiya, Jesuca caquereica itominlanue. Uyan quiraque tenca camin cajominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Junni aman ya pipiluca man becochi poleto, Genesaret pueblobi felainue. Junto canoaca pi fiquite telelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Junni canoabi nechi lonasaleri, tsachilari Jesuca manmiito, ");
INSERT INTO cofNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","junbi sunenato, piyanle jun tote sunenato, quiyanpunlaca cuyanbi poto jera tanjalainue. Jesús nunchi nenaeque meráto, junchi tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Junsi tiletiya Jesús nenasa, na pueblobi o wa pueblobi winari, quiyanpunlaca mercadote jera tsoremin jominlanue. Junni Jesube rocailainue yachi camisa puntacanantiya taquiralaquichun. Junni jerale taquiraminlari manseilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Junni aman Jerusalenbi nechi jamin fariséola, junsi israelítala tala mantaca micariminlari, Jesúchica jalainue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Junni yalari Jesube penenamin tsachilacari tede tsaletuminnan ano pefinaminca quiralaquinue. Jun tenchi ya israelita mantaminlari yalaca duque yucacuralaquinue. Aman israelítalachi miteri tedeca tsaletuminnan ano finari, seiton jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Junni jerale fariséolari, o junsi weyan israelítalari, numatotiya tedeca tsaletuminnan ano fino miitominlanue. Tsanque yalachi tatala micarica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yalachi miteri mercadobi nechi manjatobi, ticatiya jera mantsaletobi ano manfimin jominlanue. Junni yalari itsanlaca tsalemin jominlanue: pi cuchinun tásaca, perolica, ano pocato finun platoca, junsi catsonun lowaca tsalemin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Junto israelita mantaminlari Jesube panhalaquinue: —¿Niyaito nube penenaminlari chiquilachi matu tatalachi mite nenatuminla jun? latinue. Nube penenaminlari tedeca tsaletuminnan ano finato, seiton icala joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Junni Jesuri yalabe manpato itsantinue: —Nulari fe sen jolajoyoe titonan, seitonla joe. Matu to Isaías Diosichi mantate nulaca tsa pato, itsanque pila chuteca joe tinue: In tsachilari Diosica se tinato, fiqui forochiri se timinla joe; yaca natiya merátuchi timinla joeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nulari Diosichi cale epenan telenhiminla joeque chuteca joe. Nula micarinato, tsachilachi mantacari micariminla joeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Junni Jesús Isaíachi fiquica tsanque manpasi, israelita mantaminlabe itsantinue: —Nulari matu to israelítalachi mite tuca nenato, ticatiya jera tsaleniquiminla joe. Perolica junsi pi cuchinun tásaca, tsaleto, junsi ticatiya uyan quiraque quiniquiminla joe. Junni tsanque nenatonan, Diosi mantaca junca telaquepominla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nulachi miteri quilaquechiqueri, Diosi mantacacari telaquepono ura min jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Junni matu tote Moiseri Diosichi Pilabi itsanque pila chuteca joe: Nulachi apaca, nulachi ayanca seque respetailainaque chuteca joe. Apaca o ayanca seitonque paminlaca niya josatiya totenonan joeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Juntonan nulari jun mantaca epe suwachique itsantiminla joe: Tsachi manca yachi calaca “corbán joe” titori, yachi apaca o ayanca ayudaitutonan, se jonijochunae timinla joe. (Aman corbán joe titori, “Diosichi cuwaca joe” tito tsantiminlanue.) Junni apabe ayanbeca ayudaituchi timin tsachilari itsantiminla joe tinue: Apa, ayan, nulaca natiya ayudaino podeitiyoe. Lachi calaca jera Diosichi cuwaca joto corbán joe timinla joe. ");
INSERT INTO cofNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Junni tsantimin tsachilaca nulari apaca o ayanca ayudaisa carituminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsanquesiri nulachi miteri micarinato, nulari Diosi mantacaca epe cuwenta suwaminla joe. Junsi jun matu to mica man quiraque man quiraque jera micariminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Junni Jesuri tsachilaca jera layasuwato itsantinue: —Jeralelanan seque meráto entendeilaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tinantiya tsachilachibi urachi nechi wiminni seiton suwatuchunae tinue. Tsachilachi tencabi nechi lomin, ya seiton suwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nulari punqui chunla jotori, seque meralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Junni Jesús tsanque micarisi, tsachilaca jera purato manjito, tamochi manwinunbi, yabe penenaminlari jun cuentaca niyan tito tsantinayunque manpanhalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Junni Jesuri yalabe manpato itsantinue: —¿Nulanan caentendeilaitiyun? tinue. Titiya tsachilachibi urachi nechi witori, seiton tenca suwano itochunae. ¿Junca entendeilaitiyun? ");
INSERT INTO cofNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ticatiya finari, tencabi wituchunae; pecolobiri wito, nasi inaleri manloniichunae tinue. Jesús tsantinato, titiya ano finori se jonijochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Junsi aman itsantinue: —Tsachichibi nechi lominni, ya seiton suwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsachichi tencabi nechiri titiya seiton lochunae. Seitonque tenca cano, uyan sonalabe o uyan unilalabe nosa seitonque nenano, toteno, ");
INSERT INTO cofNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tarinno, titiya uyanla tanunca munaito quirano, uyanlaca seiton quino, nene pano, seiton quino, uyanla tanun tenchi pa nenano, uyanlaca epele pano, uyanlaca fe joyoe tino, junsi tenca iton jono, yalasiri duque seiton suwano joe tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jera ya seiton cosalari tsachilachibi nechi loto, tsachilaca seiton suwamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Junni Jesuri junte nechi manjito, Tiro pueblobe Sidón pueblobe quelote jinue. Junbi yabi winue. Niyanlacanantiya miratusa tennaminue. Juntonan natiya tsaino podeitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Junnasa sona manca Jesús junte ranunca moora meránue. Ya sonachi namachibi yucanchi oco wica jominue. Junni ya sonari Jesuca quirasi, yachi nedele telenhinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yari Sirofenecia tinun tobi nechi jominue. Uyan to sona jotonan, Jesube rocainue ya sonachi namachibi yucanchi oco pominca mansularisa. ");
INSERT INTO cofNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Junni Jesuri ya sonabe itsantinue: —Casaleri israelítalachi tenchi quino joyoe tinue. Yalari Diosichi nalala cuwenta jolajoe. Junni nuchi tenchi casale quitori, nalalachi anoca josoleto susuchi cuwamin cuwenta joichunae tinue. Tsantuntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Junni ya sonari Jesube manpato itsantinue: —Miya, nuri tsa tie tinue. Juntonan susunan mesa tenpe tsoto, nalala ano nasi nacá aralenacaca layato fimanhe tinue. Junto chiquecanan nasi nacá ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Junni Jesuri itsantinue: —Nu tsarasica pae. Manjiniide! tinue. Nuchi namachibi nechi yucanchi oco manloca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Junni ya sonari yachi yabi manfeto quiranari, ya sona nari lowabi tsominue. Yucanchi oco jera manloca jonan, manseica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Junni Jesuri Tírobi nechi manjito, Sidón pueblose polenue. Junsi Galilea wa pipiluse quelole poleto, Decápolis tobi fenue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Junni junte aman tsachi manca merátumin, junsi fiqui seque patumin, jominue. Yaca tanjato Jesube itsanque rocailainue: —In tsachica nuchi tedechi tale quito, manse suwade! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Junni Jesuri ya tsachica uyan talale tanjito, punqui forochi temisu ponue. Junsi tufaquesi, nicacale taquiranue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Junsi jamochi quirato, wa jasá quito, “Efata” tinue. Tsantinato, foroto meráde! tinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jun tsantinunsileri, ya merátumin tsachichi punquiri manforoinue; junsi yachi nicacanan manseinue. Junnan seque patumin jominnan seque pano manpodeinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aman junni Jesuri yalabe pato, junca mobenantiya patusa mantanue. Juntonan tsanque duque mantaca josanan, yalari fécari duque cuenta quinilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Junni tsachilari junca meráto o quirato, duque wepanalainue. Junto itsantilatinue: —Ticatiya sequesiri quimin joe tilatinue. Seque patumin jominlaca manpasa carimin joe tilatinue. Junsi merátumin jominlaca manmerása carimin joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aman jun malate duque tsachila Jesuca meráchun layailainue. Junto yalari tinantiya ano fino itominlanue. Junni aman Jesuri yabe penenaminlaca jasa tito itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—In tsachilaca duque laquirayoe tinue. Peman ma fecári labe inte pechularato, ano fino jeraicala joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aman ano fituncalaca manherenari, manjinaminnan minu quitsate podeiton cayailaichunae tinue. Weyanlari duque nuwiri nechi jacala joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Junni Jesube penenaminlari manpato, itsantilatinue: —¿Juntonan niyaito inte niyanlanantiya chutununteri ano cufino podeicaichunan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Junni Jesuri yalabe itsanque panhanue: —¿Nulari niyanca bibu talarayun? tinue. Junni yalari sietecari bibu talarayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Junni Jesuri tsachilaca tobi jera chudisa mantaquesi, jun sieteca bibuca cato Diosibe acradeseito pisuleto, yabe penenaminlachi cuwanue yape jun layan tsachilachi jera cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Junsi watsa nasi taminlanue. Junni Jesuri jun watsacanan bendisiquesi, tsanquenan yabe penenaminlachi cuwanue yape tsachilachi cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Junni jerale tsachilanan peyale ano filaquinue. Junni puchuicaca manlayato, sieteca tsalabi tuwale manlayalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ya ano fimin tsachilari junpalu mili tsansi jominlanue. Junni ano fitobi Jesuri jun tsachilaca manhereto, ");
INSERT INTO cofNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yabe penenaminlabe wa canoabi wito, Dalmanuta tinun toca manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Junni fariséolari jalaito, Jesube pacaanaminlanue. Junni Jesuca jamochi nechi mantá tatori, wepanato quirantsancari seque quede! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Junni aman Jesuri yachi tencabi sonba wa jasa quito, aman itsantinue: —¿Ti quichun nulachiri wepanato quirantsancari seque quisa tenjalaquin? tinue. Tsarasica pachinayoe tinue: Nulachi tenchiri natiya wepanato quirantsancari seque quituanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús tsantisiri fariséolaca purato, wa canoabinan manwito, wa pipilu becochi jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Junni wa canoabi jinato, Jesube penenaminlari bibuca tanjano pansica jominlanue; aman bibu manca nacasiri tanjaca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Junni tsanque jinatonan, Jesuri itsanque mantanue: —¿Bibu quichun lebadura pono jotun? yape ayancaisa. Junni fariséolabe Heródebe seiton lebadura talarae tinue. Ya lebaduraca tencabe nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Junni Jesube penenaminlari jun fiquica meráto, yala tala itsanque tenpalaquinue: Bibu tanjatulajoyoe; jun tenchi tsantin tinae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Junni Jesuri tsanque tenpanaminlaca tenhito itsantinue: —¿Ti quichun bibu itonunca tenpalaquinayun? tinue. ¿Caentendeilaitiyun? ¿Catuilaitiyun? tinue. Quereituchi timin tsanni jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Nulari cacachi quiratuminlayun? ¿Junsi punquichi merátuminlayun? tinue. ¿Mantenhilaitiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Manteca bibucari mante mili tsachilachi cufica jonunca mantenhilaitiyun? ¿Puchuicaca niyan tsala manlayacalayun? tinue. Junni yalari chunca paluca tsala manlayacalayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Junni Jesús manpanhato itsantinue: —¿Junni manan sieteca bibuca junpalu mili tsachilachi cufino materi niyan tsala tuwale manlayacalayun? tinue. Junni yabe penenaminlari sieteca tsalabi tuwale manlayacalayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Junni Jesuri yabe penenaminlabe manpato, ¿Juntonan caentendeilaitiyun? tinue. Aman fariséolachi lebadura tito, fariséola micarinun fiquica tsantinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Junsi Jesúlari Betsaida pueblobi felainue. Junnasa quirano podeiton tsachica Jesúchica tanjalainue. Junto taquirato manse suwasa duque rocailainue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Junni Jesuri ya quirano podeiton tsachica tedele cato, pueblo dechi tanjito, junsi cacabi pipi ilipoto, tedechi tale quesi, aman panhanue: —¿Tsa nasi manquirano podeinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Junni aman ya quirano podeiton tsachi jominni manquirato, itsantinue: —Tsachila nenaminlaca quiranayoe tinue. Juntonan chide pelenan quiran jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Junni Jesuri mannaman yachi tedechi quirano podeiton tsachichi cacaca taquiranue. Junni ya tsachiri junca sele manquirasiri, tsanle manquirano podeinue. Nuwiri ticatiya jera seque manquiranue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Junsi Jesuri ya tsachica yachi yaca manherenato itsantinue: —Pueblobi natiya wituna! tinue. Junsi inca junbi mobenantiya patuna! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Junni nasi inale Jesuri yabe penenaminlabe Cesarea Filipo tinun puebloca jilainue. Junni Jesuri minuse jinato, yabe penenaminlabe itsanque panhanue: —¿Tsachilari laca mo jonhoe latinan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Junni yabe penenaminlari manpato itsanlatinue: —Weyanlari nuca Mumunmin Juan jonhoe latinae latinue. Aman junsi weyanlari nuca matu to Elías jonhoe latinae latinue. Junsi weyanlari uyan matute Diosichi mantate pamin tsachi mansonhica jonhoe tilatinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Junsi Jesús yalabe manpanhato itsantinue: —¿Junni aman nulari laca mo jonhoe latiyun? tinue. Junni Pédrori itsantinue: —Nuri Diosi wenteca jun Cristo tinun tsachi joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Juntonan Jesuri junca mobenantiya capatusa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Junni aman Jesuri itsanque micarinue: —Lari tsachi ica jun joto duque padeseino joyoe tinue. Fe mantá tan unicalabe, mantá tan patelelabe, israelítala tala mantaca micariminlabe, jera layaito, laca seiton joe tito, totesa carilaquichunae. Juntonan peman mate mansonhiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aman in fiquica pato, tuca panue. Junni aman Pédrori Jesuca uyan talale tanjito, tsantitude! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Juntonan Jesuri tiwinpoleto, weyan yabe penenaminlaca quirato, Pédroca itsantinue: —Laca telaquiniquede! Nuri laca totaituna! tinato, Satanás cuwenta pánae; Diosichi mite patue; tsachilachi miteri pánae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Junsi aman Jesuri yabe penenaminlaca, junsi weyan tsachilaca oticato, itsantinue: —Labe penenachi timinlari tenca munate nenanoca telaqueponola jochunae. Corosibi puyano jun tsachi cuwenta jera telaquepoto, labesiri penenanola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yalachi tenca munatenan pansi chuchique tenfeminlari ticatiya jera piyarito puyanilaichunae tinue. Juntonan lachi tenchi, o sen fiquica merawomin jonun tenchi, tsanque pansi chunoca telaquepominlari numatotiya pansi chuto polelaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Juntonan tsachi manca piyanle toca tsacumin jominnan puyanari, ¿tichi mica jochunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aman ya tsachiri puyatobi, ticanantiya cuwano itochunae tinue yape yaca mansonhisa carisa. ");
INSERT INTO cofNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Junto meralaquinade! Amana mate sonnamin tsachilari duque seiton jutsa quiminla joe. Junni weyan tsachilari ya seitonlabe cuenta quinato, lachi tsachila jolajoyoe tino lu tilatichunae. Lachi fiqui tenchinan lu tilatichunae. Junni manca mate la tsachi ica jun joto manpatanae tinue. Labe Diosichi sen anjelilabe manpatanae tinue. Lachi Apa Diosichi urara tsenbe manpatanae tinue. Junni jun mate lanan lu tiyanae tinue. La tenchi lu timin jominlacanan lachi tsachila jolajoe tino manlu tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Junni Jesús yachi tsachilabe itsantinue: —Nulabe tsarasica pachinayoe tinue. Nula weyan weyanla inte wiruraminla Diosi sonba mantananunca quirano fecári puyalaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Junni sota ma poletobi, Jesuri Pédrobe Jacóbobe Juánbeca tanjito, wa dubi lolainue. Weyanlaca purato yala pemancabesiri lonue. Junbi lolaitobi, yala quiralaquinasanan, Jesús uyan quiran inue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aman Jesuchi camisa duque tseto, tsaracari fiban fiban inue. Jerale tote tsanpa tachiminla Jesuchi camisa cuwenta mansuwano podeitulajochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Junni yabe penenaminla quiralaquinasanan, paluca matu to tsachila quirailainue Elías manca, Moisés manca. Junsi Elíabe Moisebe Jesube cuenta quinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Junni Pédrori Jesube itsantinue: —Miya, chiquilari in dubi rano duque se joe tinue. Junni pemanca jelen ya quintsan joe tinue nuchi manca, Moisechi manca, Elíachi manca. ");
INSERT INTO cofNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aman Jesube Elíabe Moisebe cuenta quinaminlaca quirato, duque wepanalainue. Jun tenchi Pedro niyan tintsan jonunca miitoto, tsanque epele cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Junni Pedro tsanque cuenta quinasa, poyo yalaca donue. Junni jun poyobi nechi fiqui itsanque meralaquinue: —Inni lachi munatinun Nao joe tinue. Junni yacari meralaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Junni Jesube penenaminlari jun fiquica merasi manquiranari, Elíabe Moisebe itolajonue. Jesús mancasiri manwiruranue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Junni dubi nechi manpatanato, Jesuri yalaca itsanque mantanue: —Nulari dubi quiracaca mobenantiya patulajona! tinue la tsachi ica jun joto puyato mansonhino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Junnan dubi niyanhica jonunca weyanlabe patulajonue, Juntonan Jesuchi man fiquica duque tenca calaquinue. Puyaca jominnan mansonhiichunae ticaca tenpato tenca calaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Junto Jesube penenaminlari yabe itsanque panhalaquinue: —Israelítala tala mantaca micariminlari itsantiminlae latinue. Diosi wenteca jun Cristo tinun tsachica caquenan matu to Elíari manjachunae timinlae latinue. Junni ¿yalari tica tsantiminla jun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Junni Jesús tsanque panhacaca meráto, yalabe itsantinue: —Elíari caquenan jano jominhe tinue. Ya jato, jera manseisa carino jominhe yape la Cristo jasa. Junni wari Elías tito, manca mumun tsachicanan tsantinue. Yari wari numa jaca jominhe tiyoe tinue. Tsan josanan mantaminlari yalachi tenca munateri nenato, yaca totesa carilaquinue tinue. Diosichi Pilabi chuteca joe yaca tsanlaquichunaeque. ¿Aman laca mantimini tsachi ica jun jominca Diosichi Pilabi niyaque chuteca jun? tinue. Itsanque chuteca joe: Tsachilari laca epe tsachi joe tito, duque padeseisa carilaquichunaeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Junni Jesula dubi nechi patato, weyan Jesube penenaminlachica manjalainue. Junni junte manfanasa, layan tsachila yaca méraminlanue. Jesube penenaminlachi awinta layaicala jominue. Junni israelítala tala mantaca micariminlanan junte perato, weyan tsachilabe pacaanaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsanticaanaminnan, jeralela Jesuca quirasi, wepanato yachica sujito saludailainue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Junni Jesús yalabe itsanque panhanue: —¿Lachi tsachilabe tica tenpalaquinamanyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Junni tsachi manca beconan pato itsantinue: —Miya, lachi naoca nuchica tanjayoe tinue. Yucanchi ocori lachi naochibi wito, yaca pano podeiton suwaca joe. ");
INSERT INTO cofNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naoca ti óratiya cato, tobi queereisa carito, pupu larisa carito, dáto dáto quisa carimin joe tinue. Cumana inae tinue. Lari nube penenaminlabe duque rocaiyoe yape yucanchi ococa mansularito cuwasa. Junni yalari podeilaitue tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Junni Jesuri yaca meráto itsantinue: —Amana mate tsachila Diosica quereituminla joe tinue. ¿Numasi fecári nulabe penenano joichunan? ¿Numasi fecári nulaca wantaino joichunan? tinue. Junni Jesús tsantisi, ataque imin náca inte tanjasa tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Junnan naoca Jesúchica tanjanue. Junni yucanchi ocori Jesuca quirasi, naoca moora ataque casa carinue. Nari queereito, pupu larito, soconue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Junni Jesús nachi apabe itsantinue: —¿Numasile nechi yucanchi oco yachibi wica jun? tinue. Junni apari itsantinue: —Na jonunle nechi tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya ocori lachi náca duque neca totechique ninbi quepon, o pibi quepon, quee tinue. Nuri wari titiya quino pode jotori, chiquilaca laquitito ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Junni Jesuri beconan pato, itsantinue: —Nuri quereinari, manseichunae tinue. Diosica quereimin tsachilachi tenchi jera ticatiya podeintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jesuri tsantinunsileri, nachi apari sonba pato itsantinue: —Quereiyoe. Junni laca fécari quereisa ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Junnasanan tsachilari sujato layailainue. Junni Jesuri junca quirato, yucanchi ococa sonba mantato itsantinue: —Nuri pano podeiton suwamin, merása caritumin, seiton oco joe tinue. Junni nachibi nechi loto, yachibi manwituna! tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsantinasale, ocori atito, náca ataque casa carito, nachibi nechi manlonue. Junsi puyaca cuwenta tsominue. Junni duque tsachila na puyanue tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús mantimini náca tedele cato manwirucarinan, nari manwiruinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Junni Jesús tamochi winue. Junni yachi tsachilari yabesiri chuto, yabe itsanque panhalaquinue: —Nu itosanan, ¿niyaito chiquilari ya yucanchi ococa mansularino podeitulajowan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Junni Jesuri yalabe itsantinue: —Aman ya tsan quiran yucanchi ocolaca mansularino tenfe joe. Ano fitunca ito Diosibe rocainola joe. Tsantutori tsan yucanchi ocolaca natiya mansularino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Junni Jesúlari juntele nechi jito, Galilea tose polenaminlanue. Junni jinato Jesús yabe penenaminlaca micarinaminue. Jun tenchi uyan tsachilachi nosa jilainue yabe penenaminlacari micarino podeichun. Junni yalaca micarinato itsantinue: —La tsachi ica jun joto puyano joyoe tinue. Tsachi manca laca cuwapochunae tinue. Junni laca totelaquinan, peman mate mansonhiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aman yabe penenaminlari ya fiquica tuilaituto, Jesube manpanhano jeleraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Junni Jesula jinaminnan, Capernaum pueblobi manfeto, tamochi wilainue. Junsi Jesús yachi tsachilabe itsantinue: —Inchi janato, ¿nulari tica tenpade janaminlayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Junni yalari beconan manpano lurato, patulajoe. Janato, yala tala mo fe mantá tan tsachi jonunca tenpade janaminlanue. Junto beconan manpano luraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Junni Jesuri chudito, chunca paluca yabe penenaminlaca jacarito, yalaca itsanque micarinue: —Nula tala fe mantá tan jochi tinatori, jeralelabe mantaimin jono joe tinue. Jeralelachi peyun cuwenta ino joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Junsi Jesuri na mancaca tanjato, quitsabi wirucarinue. Junsi ya náca amanle cato, yachi tsachilabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Itsan na mancaca lachi tenchi facariminlari lacanan facariminla cuwenta jolajochunae. Junsi laca facariminlari lacasiri facarimin itolajochunae; laca eremincanan facariminla cuwenta jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Junni Juanni Jesube itsantinue: —Miya, tsachi manca yucanchi ocolaca mansularinaminca quiralaquiyoe tinue. Nuchi mantate ocolaca mansularinaminhe. Aman yari chiquilabe penenamin itonan, yaca tsantusa tilatiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Junni Jesús mantimini itsantinue: —Yaca tsantitulajona! tinue. Lachi mantate wepanato quirantsancari seque quiminlari laca seitonque patuminla jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsachila chiquilaca pa itotori, chiquilabe sen jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lari Diosi wenteca jun Cristo tinun tsachi jonan, nulari lachi tsachila jolajoe. Aman weyan tsachilari jun tenchiri nulachi ticatiya epe cuwalaquichunae tiyoe tinue laca laquirato. Aman nulabe tsarasica pachinayoe tinue: Jun tsachilari nulachi ticatiya cuwanari, Diosi pacara mancuwachunae. Pi man baso nacá cuwanatiya, Diosi pacara mancuwachunae tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Junni Jesuri cacuenta quinato itsantinue: —Weyan tsachilari labe cayaica junla jotonan, cumana tenca tan jolajoe nalala cuwenta. Junnan yalaca natiya jutsa quisa carilaquituna! tiyoe tinue. Yalaca jutsa quisa cariminlari duque padeseilaichunae tinue. Jana tsachi mancaca wa ila suca cudanle telepoto, lamaribi queponari, ¿duque padeseichunaco? Aman ya nalala cuwenta jominla mancaca jutsa quisa cariminla mantimini lamaribi quepoca junca fécari padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Juntonan nulari tede máncachi jutsa quiminla jotori, tencachique tedeca butunto queponotiya se jono jonhoe tinue. Man tederi chutotiya, Diosibe pesonnato poleno se jochunae. Aman palu tede chun jototiya, yucanchi ninbi quepoino seitochunae. Ya nin piyatumin nin jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yucanchi nin numatotiya joto polechunae. Junbiri tsachica fimin malunnan numatotiya puyatuto polechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Junsi jun tsanquenan nulari nede máncachi jutsa quiminla jotori, tencachique nedeca butunto queponotiya se jono jonhoe. Man nederi chutotiya, Diosibe pesonnato poleno se jochunae. Aman palu nede chun jototiya, yucanchi ninbi quepoino seitochunae tinue. Ya nin piyatumin nin jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yucanchi nin numatotiya joto polechunae. Junbiri tsachica fimin malunnan numatotiya puyatuto polechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Junsi jun tsanquenan nulari caca máncachi seitonque tenca cato quiratori, tencachique cacaca larito queponotiya se jono jonhoe. Man cacari pototiya, Diosi mantananun tobi wino se jochunae. Aman palu caca pun jototiya, yucanchi ninbi quepoino natiya seitochunae tinue. Ya nin piyatumin nin jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yucanchi nin numatotiya joto polechunae. Junbiri tsachica fimin malunnan numatotiya puyatuto polechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Junni Jesús tsanque micarisi, man fiquiman pato itsantinue: —¿Toteca jun animalica Diosichi cuwalaquinatori, pinba pono joco? tinue. Jun tsanquenan Diosiri nula jeralelaca pinba pun tsachicaca cuwenta, sen josa carichunae tinue. Ninchi cuwenta padeseisa carinato, sen josa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Junni pinba sen joe. Juntonan pinba sen jomin epeban inari, niyan quinatotiya saruba mansuwano podeilaituchunae. Epe jochunae. Junni nulari pinba pun tsachica cuwenta sen jolajona! tinue. Nula tala pataatuto nenalarana! tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Junni Jesús Capernaunbi nechi jito, Judea toca manjito nenaminue. Jordán pi becochi manpolenan, duque tsachila yachite manlayailainue. Junni Jesús micarimin joto, yalaca manmicarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Junnasa quiranari fariséolari jato, Jesuca palaque pasa carichique itsanque panhalaquinue: —¿Unilalari yalachi sonalaca purano mantá jun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Junni Jesuri beconan pato itsanque panhanue: —¿Matu to Moiseri sonalaca puranoca niyaque mantaca jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Junni Jesús tsanque panhanan, fariséolari itsantilatinue: —Moiseri Diosichi Pilabi chuteto, sonaca purano podeintsan joeque chutenue latinue. Unilalari diborsio pilaca chuteto cuwato, purano joeque chuteca joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Junni Jesuri itsantinue: —Nulari merátuchi timinla joe. Jun tenchi Moisés nulaca tsanque mantanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aman nanni matunan, Diosi jerale quinasanan, uyan quiraque jominue. Diosi tsachilaca quinato, unilabe sonabeca quinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jun tenchi unila tsachi uwaito yachi apaca, ayanca purato, yachi sonabe chuno joe. ");
INSERT INTO cofNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Junni yala paluca jotonan, mancari tsachi cuwenta ilaichunae tinue. Tsanque unilabe sonabe paluca cuwenta itolajochunae tinue. Paluca jotonan, manca tsachi cuwenta jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Junni Diosi patsa unilabe sonabeca cayaisa carimin joe. Jun tenchi unilala yalachi sonalaca puranola itoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Junni Jesús tsantitobi, yabe yachi tsachilabe tamochi manwilainue. Junni yalari sonalaca puranoca manpanhalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Junni Jesús yalabe itsantinue: —Tencachique sonaca purato uyan sona mancaminlari yalachi tsa sonaca seiton quiminla jochunae. Leyan sona tan nenamin cuwenta patilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Junni sonalanan yalachi unilaca purato uyan unilabe cayaitori, yala leyan sonala cuwenta patilaichunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Junni weyan tsachilari nalalaca Jesúchica tanjanaminlanue yape Jesús yalaca tedechi tale quisa tito. Junni Jesube penenaminlari yalaca tanjatusa tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús mantimini junca quirato, paito, itsantinue: —Nalalaca lachica jasa carinilaquede! tinue. Nalalaca natiya jatusa titulajona! Yala tsan tsachilari Diosi mantananun tsachi bolonbi jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nulabe tsarasica pachinayoe tinue: Tsachilari nalala cuwenta Diosi mantananun tsachi bolonbi wilaitutori, numanan wilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsantisi Jesús nalalaca amanto, tedechi tale quito, yalaca bendesiquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aman junni Jesuri junchi nechi jinasa, tsachi manca sujato, yachi cale telenhito, itsantinue: —Nu sen joto micarimin joe; junto labe pade! tinue. Lachi numatotiya sonnato poleno muquee tinue. ¿Junni lari niyan quino jowan? numatotiya sonnato polechun. ");
INSERT INTO cofNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Junni Jesuri yaca meráto, beco manpato itsantinue: —¿Niyaito laca sen joe tiyun? tinue. Diosisiri sen joe tinue. Tsachila tala monantiya sen itoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Junni nu Diosichi mantaca mirae tinue: Uyan sonalabe nosa seitonque nenalaratunaque, tsachilaca totelaquitunaque, tarinlaquitunaque, uyanlaca nene patulajonaque, encanalaquitunaque, apabenan ayanbenan sen jolajonaque, mantaca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Junni Jesuchi fiquica merasi, ya tsachiri itsantinue: —Miya, na mánta ya mantaca jera meráto nenamin joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Junni Jesuri yaca laquirato quirato, itsantinue: —Nuri man cosa quino cajoe tinue. Nu manjito, titiya tanunca jera osito, ya calaca poperelachi cuwana! tinue. Tsantori, nu Diosichi tobi duque senca tachunae. Junto calaca jera cuwatobi, lachica manjato, labe penenamin ina! tinue. Corosibi puyano jun tsachi cuwenta ito, labe penenana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesús tsantinan, ya tsachiri Jesuchi fiquica merátuchique duque laqui manjinue. Yari duque oco tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Junni Jesuri yachi awinta quirato, yachi tsachilabe itsantinue: —Fe oco tsachilari Diosi mantananun tsachi bolonbi pewino duque tenfe jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Junni Jesube penenaminlari ya fiquica meráto duque wepanalainue. Junni Jesús yalabe manpato itsantinue: —Nalala, meralaquede! Calaca duque tenca caminlari Diosi mantananun tsachi bolonbi pewino duque tenfe jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jana cameyo acusa forose numanan poleno podeituchunae. Aman oco tsachilari Diosi mantananun tsachi bolonbi pewino fécari tenfe jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Junni Jesube penenaminlari nantanancari wepanato, yabe itsanlatinue: —Tsan jonari, oco tsachilatiya wino podeilaitunari, monantiya se lono podeitulajoanae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Junni Jesuri yalaca tulan quiranato, itsantinue: —Tsachilari tenca mánta natiya se lono podeilaituchunae. Tsan josanan, Diosiri se larino podeimin joe tinue. Diosi jera titiya quino podeimin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Junni Jesús tsantinunsi, Pédrori yabe itsantinue: —Meráde! Chiquilari nube penenachun jera tanunca puralaquiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aman Jesús beconan pato itsantinue: —Nulabe tsarasica pachinayoe tinue: Weyan tsachilari lachi tenchi duque ticatiya puralaquichunae. Acolaca, o soquilaca, o ayanca, o apaca, o sonaca, o nalalaca, o toca, o yaca, puratotiya jinilaichunae tinue. Diosichi sen fiqui tenchinan yalaca jera purato jilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Junni tsanque purato jiminlari in tote casonnato, patsa ne tsansica mancalaquichunae. Acolaca, soquilaca, ayanlaca, nalalaca, toca, yaca, jera patsa ne tsansica mancalaquichunae tinue. Tsan josanan seiton tsachilari yalabe seiton jolajochunae tinue. Junni in to yucapiyarinunbi, ya ticatiya purato jiminlari numatotiya Diosibe sonnato polelaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aman duque tsachila amana mate mantá tanla jotonan, jun mate epe tsachila jolajochunae tinue. Uyanlari amana mate epe tsachila jolajotonan, jun mate mantá tanla jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aman junsi Jerusalén puebloca jilainaminnan, Jesús weyanlaca caque jinaminue. Yabe penenaminla wepananaminlanue. Uyan tsachilanan bene pejinaminlari jele tinaminlanue. Junni tsanque nenaminnan, Jesuri yabe chunca paluca penenaminlaca chican larito, yalaberi cuenta quinue. Yari niyanhino jonunca yalabe jera cuenta polarito itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Meralaquede! tinue. Jerusalenca jilainayoe tinue. Jerusalenbi fenunbi, tsachi manca laca cuwapochunae tinue. La tsachi ica junca osichunae yape israelita mantaminla laca calaquisa. Mantá tan patelelabe mantaca micariminlabe laca cato, totentsan joe tilatichunae. Junto laca uyan to mantaminlachi cuwapolaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Junni uyan to tsachilari laca seitonque pato lucarilaquichunae tinue. Junsi laca asotaquin, pipichi quin, quito totelaquichunae tinue. Junni peman mate mansonhiyanae tinue. Jesús yachi tsachilabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Junnasa mantimini Zebedéochi naola, Jacobo manca, Juan manca, Jesúchica jato itsanlatinue: —Miya, chiquilachi tenchi ticatiya quisa tenjae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Junni Jesús yalachi fiquica merasi, ¿Nulachi niyan quisa tenjalaquin? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Junni itsanlatinue: —Nuri jera mantá catobi, chiquilacanan nuchi quelole pechusa carina! latinue. Mancaca tsa tede nanchi, mancaca jala tede nanchi pechusa carina! latinue pemantaminla jochun. ");
INSERT INTO cofNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuri ya fiquica meráto itsantinue: —Nulari miitoto tsanque rocailainae tinue. ¿Nulanan la cuwenta pepadeseino podeilaichun? Tsanban pica cuchinun cuwenta duque tenfe jochunae. Jana mumunhichun pi tenpe wichun casale duque tenca cantsan joe; aman jun cuwenta jochunae tinue. ¿Junni podeilaichun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Junni Jesús tsantinunsi yalari podeilaiyanae tilatinue. Junni Jesuri yalabe itsantinue: —Nulari la cuwenta pepadeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tsan josanan, lari nulaca pechudisa mantano itoyoe tinue. Mo lachi tsa tede nanchi, o jala tede nanchi chudino jonunca la mantano podeitiyoe. Apa Diosiri paluca tsachilaca wenteca joto, yalachi tenchi jun mantananun postoca jera seca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aman weyan chunca Jesube penenaminlari junca meráto, Jacóbobe Juánbeca pailainue fe mantá tanla jochi latinaeque. ");
INSERT INTO cofNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Junni Jesús yalaca jera jasa carito, yalabe itsantinue: —Diosica tennatuminla tala mantaminlari duque sonbaque mantaminla joe. Nulanan yaca miralaranae. ");
INSERT INTO cofNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Junni nula tala mantimini uyan quiraque jolajona! tinue. Nula tala fe mantá tan jochi timinlari weyanlachi peyunla cuwenta jonola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nula tala fe jochi timinlari jeralelabe mantaimin cuwenta jonola jochunae tinue. Tsanque fe jono podeilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aman la patsa tsachi ica jun joto, peyunlaca mantaquebi jatucayoe tinue. Lanan peyun cuwenta nenabi jacayoe tinue. Duque tsachilachi tenchi puyabi jacayoe tinue yape casticailaitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Junni aman Jesús tsanque cuenta quetobi, Jericó puebloca jilainue. Aman Jesube yachi tsachilabe duque uyan tsachilabe Jericobi nechi manlonaminlanue. Manloto jilainasanan, Bartimeo tinun tsachi minute lemosi cala panhato chuminue. Bartiméori Timéochi nao jominue. Quirano podeiton jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Junni Bartiméori Jesús Nasareno janaeque meráto, yari sonba otito itsantinue: —Miya Jesús, nu matu to miya Davichi alica joto, laca laquirato ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Junni duque tsachilari yaca paito, tsanque patude! Nosasaide! tilatinue. Tsanlatinasatiya, nantanancari sonba otito, manaman itsantinue: —Miya Davichi alica, nu laca laquirato ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Junni Jesuri yaca meráto wiruito, quirano podeiton tsachica otisa carinue. Junni tsachilari ya Bartiméoca oticato itsanlatinue: —Sonba tenca mancade! Cupade! Jesús nuca jasa tinae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Junnan Bartiméori yachi panuca queponiquito, sonba cupato, Jesúchica jinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Junni Jesuri yabe itsanque panhanue: —¿Nuca niyan quisa tenjan? tinue. Junni quirano podeiton tsachiri manpato, Miya, manquirano podeino muquee tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Junni Bartimeo tsantinunsi, Jesuri jiniide! tinue. Nuri laca tennato manseie tinue. Junni Jesús tsantinunsi, Bartimeo manquirano podeinue. Manquirano podeito, Jesube pejinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Junni Jesube yachi tsachilabe Jerusalén pueblo quelo jinaminnan, Olibo tinun du quelote felainue. Aman Olibo du nanle paluca pueblo jominue Betfagé manca, Betania manca. Jun pueblo quelo féto, Jesuri yachi tsachila palucaca junchi erenue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yalaca erechinato itsantinue: —Ja pueblobi wilaide! tinue. Junni pueblobi wisi, buro na telaca quiralaquichunae tinue. Jun burobi niyanlanantiya cachuditunun jochunae tinue. Junni nulari yaca wolecato tanjalaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Junni uyan tsachilari nulabe panhato, ti quichun buroca wolecalaquinayunque panhalaquinari, nulari itsanlatina: Miyari buroca munarae tilatina! tinue. Moora manherechunae tito tanjanilaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Junni Jesús tsantinan, ya ereca tsachila jilainue. Junni jun pueblobi fesi, buro náca quiralaquinue. Buro na minule telaraminue tamolan quelole. Junni buro náca wole canasanan, ");
INSERT INTO cofNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","quelole wiruraminlari ¿Ti quichun buroca wolecalaquinayun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Junni buroca canaminlari Jesús pasa mantacaca palaquinue. Junni tsanlatinunsi yala quelote wiruraminlari tanjinilaide! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Junni yalari buro náca Jesúchica tanjato, yalachi tsanpaca burobi nanlaquinue. Junni Jesús junbi chudinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Junni duque tsachila yalachi tsanpaca minubi lowalaquinue. Uyanlari japisuca witabi nechi porecato, minubi lowalaquinue yape miya jananun minu uraran josa. ");
INSERT INTO cofNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Junni Jesuchi caque jinaminlanan, aman yachi benele jinaminlanan, jeralela layaito itsanque otilatinue: —Biba! latinue. In sen tsachiri Miya Diosi ereca jun janae latinue. Yaca tsara seque pantsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","In tsachiri chiquilachi matu to tata David cuwenta, miya ito mantachunae latinue. Yaca tsara seque pantsan joe latinue. Diosicanan biba quilaquisa! latinue in sen tsachi janaeque. ");
INSERT INTO cofNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Junni Jesús tsanque Jerusalén pueblobi wito, Diosichi yabi winue. Junsi jeraleca quiratobi, quebi inanan, Betania puebloca jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Junni ayuna nanchi Jesúlari Betania pueblobi nechi Jerusalenca manjalainue. Jesuri ano muquinasa manjanaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Junni nuwiri nechi ico peleca quirato, junchi jinue. Japisu jominue; junni puca ranunca miichun quirabi jinue. Junni ico pele quelole féto quiranari, te, puca itominue. Ico rano ma itosanan, japisuri numa jominue. Juntonan pucari itominue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Junni Jesuri ico peleca pato, itsantinue: —Amanale nechi monantiya in pelebi puca cato fituchunae tinue. Aman yabe penenaminlari tsanque pánanunca meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Junni Jesula Jerusalén pueblobi felainue. Junni Jesuri Diosichi yabi manwito, junbi osinaminlacanan, canaminlacanan jera sularierenue. Calaca waladaanun mesacanan lecateponue. Junsi paloma osito chununcanan jera tulipoereto cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Junsi tsachilaca mantanue monantiya Diosichi yase ticanantiya tanpolelaitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsantitobi, tsachilaca micarito itsantinue: —Diosichi Pilabi itsanque chuteca joe tinue: Diosichi ya Diosibe rocainun ya jochunaeque chuteca joe tinue yape jerale tote chuminla Diosibe rocailaisa. Diosichi Pilabi tsantica josanan, nulari in yaca tarinnun ya cuwenta suwacala joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Junni jerale tsachilari Jesús tsanque micarinanunca meráto wepananaminlanue. Tsannasanan mantá tan patelelanan, israelítala tala mantaca micariminlanan Jesuca jelerato, yaca totechun tenpalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsan josanan neme inasa Jesúlari pueblobi nechi manlolainue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Junni aman ayuna nanchi quepenan Jesúlari Jerusalenca manjilainasa, ya ico peleca manquiranari, telenlebi nechi jera jeque pele ica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Junni Pedro Jesuchi fiquica mantenhito, Jesube itsantinue: —Miya, quirade! tinue. Nu yucaquica jun ico pele numa jeque pele ica joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Junni Jesuri beconan pato itsantinue: —Diosica quereilaina! ");
INSERT INTO cofNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nulabe tsarasica pachinayoe: Diosica tsarasi quereiminlari ja wa ducatiya mantato, jalitaito lamaribi quepoideque mantanari, tsanhichunae tinue. Palaque tenca catunari, tsanhichunaeque tenca canari, tsanhichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jun tenchi nulabe itsantichinayoe: Diosibe ticatiya quisa rocainato, Diosi tsanquichunaeque tenca calaquina! tinue. Tsanque quereilainari, Diosi nu rocaicaca quichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Junni Diosibe rocainato perdonailaina! tinue yape nulachi Apa Diosinan nulachi jutsaca perdonaisa. ");
INSERT INTO cofNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nulari perdonailaitunari, nulachi jamobi chumin Apa Diosinan nulachi jutsacanan perdonaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Junni Jesube yachi tsachilaberi Jerusalén pueblobi manfeto, Diosichi yabi manan manwito nenaminlanue. Junni mantá tan patelelabe, mantaca micariminlabe, mantá tan unicalabe, Jesúchica jalainue. Yachica jalaito, ");
INSERT INTO cofNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","itsanque panhalaquinue: —¿Nuri mochi mantate micarinayun? latinue. ¿Mo nuca mantaquin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Junni Jesús yalachi fiquica meráto itsantinue: —Casaleri la nulabenan man fiqui panhachinayoe tinue. La panhanunca manpalaquinari, lanan nulabe pánae tinue ti mantate micarinayoeque. ");
INSERT INTO cofNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jesús tsantisi, israelita mantaminlabe itsanque panhanue: —¿Mumunmin Juanni mochi mantate mumunnamiyan? ¿Diosichi mantate, o tsachilachi mantateri mumunnamiyan? tinue. Palaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Junni Jesús tsantinunca meráto, israelita mantaminlari chicanle tenpato, yala tala itsanlatinue: —Juanca Diosichi mantate mumunnaminhe tituntsan jochunae latinue. Chiquila tsanlatinari, ¿Junni niyaito yaca quereilaitiyun? tichunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Junsi tsachilachi mantateri jominuequenan patuntsan joe latinue. Tsachilaca jelechi tsanque patuntsan joe latinue. Aman jerale epe tsachilari Juanca pato, tsa Diosichi mantate pamin jominhe timin jominlanue. Junto ya tsachilaca jelechi Juan Diosichi mantate patumin jominue tino jeleraminlanue. Junni mantaminlari tsanque tenpatobi, ");
INSERT INTO cofNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jesube itsantilatinue: —Miituntsan joe latinue. Mumunmin Juan Diosichi mantate mumunnamin jonunca, o tsachilachi mantate mumunnamin jonunca miituntsan joe tilatinue. Junni israelita mantaminlari tsanlatinunsi, Jesuri yalabe itsantinue: —Junni lanan nulabe pátiyoe tinue mochi mantate micarinanunca. ");
INSERT INTO cofNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Junni Jesús yalaca micarichun itsanque cuenta polarinue: —Diosi wita tsacumin cuwenta jochunae tinue. Aman casale casaleri ya tsachiri uba wita quisa carichunae tinue. Junni wita quisa carisi, wita awinta serica quin, uba pi larichun foro quin, witaca quirato chuchun ya quin, quisa carichunae tinue. Junni jera se quetobi, ya witaca uyan tsachilachi quitsa quitsa cachun cuwato, bareca chubi jichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Junni uba cano mate peyunca erechunae tinue yape wita cuidaiminlari quitsaca cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Junni wita cuidaiminlari ya peyun janaminca cato, sonba quito, natiya cuwatuminnan manherelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Junni wita tsacumiri manca peyuncaman erechunae. Junni yacaman seitonque pato, misule quito, junsi su walacachi quito, yachinan natiya cuwatuminnan manherelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Junni junsi manca peyuncaman erenan, yaca totelaquichunae tinue. Junsi duque peyunca erenasanan, wita cuidaiminlari weyanlaca sonba quin, weyanlaca toten, quilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Junni wita tsacumin nantari peyun itochunae junchi erechun. Naobesiri puraichunae. Duque munatinun nao jochunae. Junni tenca cato, ya wita cuidaiminlari lachi naoca respetailaichunae tito, yacaman erechunae yape cano jonunca casa. ");
INSERT INTO cofNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Junni wita cuidaiminlari tenpato, itsanlatichunae: Ja mosori tsacuminchi nao joe latichunae tinue. Yari ina tsacumin ichunae. Yaca totebi jisa! latichunae yape wita chiquilachi puraisa. ");
INSERT INTO cofNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsantisi ya naoca cato, toteto, puyacaca witabi nechi quepolaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Junni wita tsacumiri jun cuidaiminlaca niyan quichunan? tinue. Tsacumiri witaca manjito, wita cuidaiminlaca jera totechunae tinue. Yalaca toteto, ya witaca uyan tsachilachi quitsa cachun mancuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesús micarichun ya cuentaca polaritobi, israelita mantaminlabe itsantinue: —¿Diosichi Pilabi itsantinunca natiya quiratuminlayun? Junbi itsanque chuteca joe: Suca ya quiminlari su mancaca seitoe tito quepolaquichunaeque chuteca joe. Juntonan tsanquica josanan, wanbile ya suri fe munaranun sen su jochunaeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Miya Diosi tsanhisa carichunae; junca quiraminla tsara sen joe latiyoe tilatichunaeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Junni Jesuri tsanque micarinato, israelita mantaminlari ya seiton cuidaiminla cuwenta jolajoe tito micarinaminue. Junni ya mantaminlari junca tenhito, Jesuca dochi tinaminlanue. Tsan jotonan, Jesuca dotuminnan manjinilainue tsachila pailaichunaeque jelechi. ");
INSERT INTO cofNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Junni israelita mantaminlari tsachilaca Jesúchica erelaquinue. Aman jaminla weyanlari fariséola jominlanue; weyanlari miya Heródechi tsachila jominlanue. Yalari Jesuca palaque pasa carichique jacala jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Junni Jesúchibi féto, itsanlatinue: —Chiquila miralarayoe latinue nu tsarasica micarimin joeque. Tsachila niyaque palaquinanunca tennatuto, Diosichi minuca tuca micarimin joe latinue. Junni Jesube tsantisi, jerale toca mantamin romano miyaca panhato, itsantinue: —¿Chiquilari ya uyan to miyachi inpuesto cala cuwanola join? latinue. ¿Cala cuwantsan jun, o cuwatuntsan jun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Junni Jesuri junca meráto, yala culpa patarichiqueri tsanlatieque tenhito, itsantinue: —¿Nula niya jonan laca culpa patarichi latinayun? tinue. Cala manca tanjalaide! tinue quirachun. ");
INSERT INTO cofNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Junni cala manca tanjanan, Jesuri jun calaca quirato, itsanque panhanue: —¿In calabi mochi misu, mochi mumun chun? tinue. Jesús tsantinan, yalari ya romano miyachi joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Junni Jesús itsantinue: —Tsan jonari, ya cobierno miyachi cosateri yaca meralaquina! Aman Diosichi cosateri Diosica meralaquina! tinue. Junni Jesús tsantinan, yaca meráminlari duque wepanalainue tsara tenca tanque paeque. ");
INSERT INTO cofNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Junni saduseo tinun bolon israelítalari Jesúchica jalainue. Aman saduséolari tsachila puyato natiya mansonhituminlae timinla joe. Junni saduséola Jesúchica jato, yabe itsanlatinue: ");
INSERT INTO cofNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Nuri micarimin joto, chiquilabe pade! latinue. Aman matu to Moisés Diosichi mantaca pila chutenato, itsanque chiquilachi pila chutenue latinue: Tsachi manca sona taminnan na caitonan puyanari, ya puyan ocochi acori yachi sonabe casalaino joeque chutenue latinue aco puyan ocochi tenchi na tachun. ");
INSERT INTO cofNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aman sieteca acola jominlanue latinue. Caque acori sona cato, casalainue. Junni ya unilari na caitonan puyae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Junnan puyan ocochi benele acoman caque aco puyan ocochi sona jominbe mancasalaie. Junni yanan na caitonan puyae latinue. Junsi nantanan benechi acoman ya sonaca mancato, yanan puyae. ");
INSERT INTO cofNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tsanquenan sieteca acola jera depoleto, jera puyalaie tilatinue. Junni yala jera puyacala josa, ya sonaman na caitonan puyae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Junni Saduséolari Jesube tsanque cuenta polarito, itsanlatinue: —Aman ya sonari sieteca acolabe casalaica jomin joto, ¿puyacala mansonhino mate mochi sona jochunan? latinue. Junbe tenhintsan joe latinue puyaca junla mansonhilaituchunaeque. ");
INSERT INTO cofNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Junni Jesuri yalachi fiquica jera meráto itsantinue: —Nulari palaque tenca calaquinae tinue. Diosichi Pilacanan miitolajoe tinue. Diosi jelecari sonba quimin joequenan miitolajoe tinue. Jun tenchi nulari palaque tenca calaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aman puyacala mansonhito, unilala sona mancalaquituchunae. Sonalanan unila manquilaquituchunae tinue. Diosichi tobi chumin anjelila cuwenta chularachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aman puyacala mansonhilaichunaeque cuenta quilaquisa! ¿Matu to Moisés chuteca pilaca quiratuminlayun? Junbi tape cuentaca chuteca joe tinue. Tapebi nechi Diosi cuenta quito, itsantinueque chuteca joe: Lari matu to Abrahanchi, Isaachi, Jacóbochi Diosi joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Junni Jesuri ya saduséolaca tenca calaquede! tinue. Diosi puyaca junlachi Diosi itoe; sonnaminlachi Diosi joe. Junto Abraham, Isaac, Jacobo puyaca jotonan, Diosichibi casonnan chularae tinue. Nula junca tenhituto, duque palaque tenca caminla joe tinue. Jesuri saduséolabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Junni Jesús tsantinasanan, israelítala tala mantaca micarimin tsachi manca junbi féto, jera meranaminue. Aman yari Jesús seque cuenta quinaminca meráto, yabe panhato ¿Nun mantá fécari merántsan mantá jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Junni Jesuri beconan pato itsantinue: —In mantá fe merántsan mantá joe tinue: Israelítala, meralaquede! Miya Diosi chiquilachi Diosi joe. Yasiri tsa Miya joe. ");
INSERT INTO cofNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Junni nulari Diosica jera tencabi tsarasi laquiralarana! Misubinan tsaracari laquirato, sele tenca cato laquiralarana! Jera sonbabe yaca laquiralarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jun mantá fe merántsan mantá joe tinue. Junsi jun benete mantacanan manpachinayoe tinue: Nula tencachique laquiranun cuwenta, nula quiranunlacanan jun tsansinan laquiralarana! tinue. In paluca mantári jerale uyan mantáca fe merántsan mantá joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Junni Jesús tsantinunsi, mantá micarimin tsachi yabe itsantinue: —Tsa tie tinue. Nuri tsarasica micarimin joe. ¿Diosi mancasiri joco? ¿Uyan Diosi itoco? ");
INSERT INTO cofNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","¿Jera tencabi, misubinan, jera sele tenca cato, jerale sonbabe Diosica laquirantsan joco? ¿Tencachique laquiranun cuwenta, quiranun tsachilacanan laquirano joco? Tsanque laquiraminla seque quiminla jochunae tinue. Tsachilari Diosibe sen jochun, yachi ticatiya epe cuwalaquichunae. O ticatiya nin poto Diosichi cuwalaquichunae. Aman tsanque jera laquiramin tsachila mantimini ya epe cuwaminlaca fécari Diosibe sen jolajochunae tinue. Ya mantaca micarimin tsachi tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Junni Jesús yaca seque tencabe cuenta quinaminca meráto yabe itsantinue: —Nu Diosi mantananun tsachi bolonbi case wiwiyanae tinue. Junni Jesús tsanque micarinan, jeralela lu tito, monantiya yabe manpanhatulajonue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Aman Jesuri Diosichi yabi camicarinato itsantinue: —Israelítala tala mantaca micariminla itsantiminla joe tinue: Diosi wenteca jun Cristo tinun tsachi matu to miya Davichi alica jochunae timinla joe tinue. Junni ¿niya jonan tsantiminla jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tenca calaquede! David patsa Diosichi Tencachi mantate itsanque pila chuteca joe tinue: Miya Diosi lachi miyaca mantachunae tinue yape yachi tsa tede nanchi chudito yabe pemantasa. Nuca fe losa cariyanae tichunae. Junni junte mechude! tichunae tinue nuca pa jominlaca fe lono fecári. ");
INSERT INTO cofNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Junni Jesuri Diosichi Pilabi tsanque chutecaca manpasi, itsantinue: —Aman Cristo tinun tsachi miya Davichi alica jonari, ¿niyaito Davinan yaca Miya tinun? tinue. Junni duque tsachilari Jesús tsanque cuenta quinaminca meráto, son tito meránaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Junni Jesús micarinato itsantinue: —Israelítala tala mantaca micariminlaca tencabe nenalarana! tinue. Yalari baren camisa pochi timinlae tinue yape tsachilari yalaca duque sen jolajoe latisa. Duque tsachila nenanunte yalaca duque respetaito saludaisa munaralarae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Diosichi fiqui miinun yabinan, fiestatenan, fe mantá tanla chudinunbi chudichi timinlae fe jolajoyoe tito. ");
INSERT INTO cofNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Biudalachi yaca nosale josoleminla jotonan, Diosibe wanca rocaiminlae yape tsachila yalaca quirato, duque sen jolajoe latisa. Diosi yalaca fe sonba casticaquichunae tinue. Mantaca micariminla niya jolajonunca miilaisa, Jesús tsanque micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Man nete Jesús Diosichi yabi chuminue cala ponun cajon catenle. Aman tsachila junbi cala ponaminlaca quiranaminue. Junni duque tsachila, oco joto, duque calaca ya cajonbi ponaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Junni cala iton biuda manca jato, paluca cala nacá ponue. Ya paluca cala natiya mica iton cala nacári jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Junni Jesús junca quirato, yabe penenaminlaca jasa tito, itsantinue: —Nulabe tsarasica pachinayoe tinue: In popere biudari nasi nacári calaca cajonbi pototiya, duque cuwaca joe tinue. Uyan pominlaca fe cuwaca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aman uyanlari puchuica calacari cuwalaquinae tinue. In biuda mantimini jera tanun calaca poniquee tinue. Titiya cato fito sonnano jun calaca jera poniquee tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Junni Jesula Diosichi yabi nechi manlonaminnan, Jesube penenamin tsachi manca wepanato quirato, itsantinue: —Miya, Diosichi ya uraran jonunca quirade! tinue. ¿Tsara sen wa suca quica joco? Tsara wa ya quicala joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Junni Jesús yabe beconan manpato itsantinue: —Meralaquede! In tsara moso wa ya jera yucapiyachunae tinue. Tsachila in yaca jera aralelaquichunae. Su mancatiya jamo diquiratuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Junto Jesuri Olibo tinun dubi loto, Diosichi ya catenle chudinue. Junni Pédrobe Jacóbobe Juanbe Andrebe Jesúchica jilaito, yabe itsanque nosa ");
INSERT INTO cofNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","manpanhalaquinue: —Chiquilabe pade! latinue numasi tsanhino jonunca. ¿Niyaito miintsan jochunan latinue tsanhino ma queloinanunca? ");
INSERT INTO cofNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Junni Jesuri yalabe itsantinue: —Nulari tencabe nenalarana! tinue yape nulaca monantiya encanalaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Duque tsachila encanato pato, Cristo joyoe tide jalaichunae. Yalari layanlaca encanalaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Junsi quera quicaanaeque mera jochunae. Quera quicaalaquechinaequenan mera jochunae tinue. Aman junca meráto, natiya jeleralaratuna! tinue. In to cajeraitusanan, tsanhiniichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Manca tobe manca tobe pataato quera quicaalaquichunae tinue. Weyan postolate to duque wechunae tinue. Ano fino itonan, tsachilari ano mochi padeseilaichunae tinue. Firara tide nenalarachunae. Junni tsachilari tsanque padeseilainatonan, fécari duque padeseino cajolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nulari tencabe nenalarana! tinue. Tsachilari nulaca mantaminlachi cuwapolaquichunae. Diosichi fiqui miinun yabi nulaca asotaquilaquichunae. Nulari lachi tsachila joto, mantaminlachi cale, miyalachi cale wirurato, laca jera cuenta polarinola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Diosichi sen fiquica jerale tote camicaritusanan to jeraituchunae. Jerale tote jera micarinunbi, to jeraichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aman nulaca cato doto juisio quilaquinasanan, natiya wepanalaituna! niyaque beco manpano jonunca. Jun óratenan Diosi nulaca ticatiya jera seque pasa carichunae tinue. Junni nula pánatonan, nula patsa palaquituchunae. Diosichi Tenca nulachi fiqui forose pánachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Junni Jesús camicarinato itsantinue: —Aman acola tala mantaminlachi cuwapocaalaquichunae yape totelaquisa. Apalanan yalachi nalalacanan cuwapolaquichunae tinue yape totelaquisa. Nalalanan apabe ayanbeca paito totesa carilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Junni jeralela nulaca pa jolajochunae tinue nulari labe penenaminla jonun tenchi. Tsan josanan, niyanlaquinasatiya peleituminlari se lolaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesús yachi tsachilaca tsanque micarinue. Junsi Jesuri man fiquiman panue. In pilaca quiraminlari in fiquica miichique duque tenfenola joe. Ya fiqui itsanque joe: —Matu to Daniel Diosichi mantate pato, duque seiton suwaminca pato pila chuteca joe. Aman ya seiton suwamin tsachi itono jonunte jochunae tinue. Junni yaca junbi wiruraminca quirasi, Judea tobi chuminla du minu sujinola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jun mate ya jamochi raminlari wewe manpatato, tamochi tinantiya mancábi wituminnan, sujinola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Witabi raminlanan jali mancábi manjituminnan, sujinola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jun mate na punlabe cu cufiminlabe fécari padeseilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Junnan Diosibe rocailaina! yape pilute sujinola itosa. ");
INSERT INTO cofNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jun mate tsachila duque padeseilaichunae tinue. Diosi jerale toca quinunle nechi jun ma fecári tsansi duque capadeseituca jolajochunae. Aman jun male nechi to jeraino fecári tsansi padeseino manhitochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Miya Diosi ya padeseino maca we jeraisa caritumanpari, monantiya puchuino itominla jonhoe tinue. Aman Diosiri weyan tsachilaca wentenue tinue yape yachi tsachila jolajosa. Junni yalachi tenchiri Diosi ya padeseino maca we jeraisa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aman weyan tsachila nulabe pato itsanlatichunae tinue: Cristo inte rae latichunae tinue. O Cristo junte rae latichunae tinue. Tsantinaminlaca tina quereitulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Junni weyan tsachilari nene pato, Cristo joyoe latichunae tinue. O weyanlanan nene pato Diosichi mantate pamin joyoe latichunae tinue. Yalari niyaquetiya duque wepanato quirantsancari quito quirawolaquichunae Diosichi mantate tsanlaquinayoe tito. Tsachilaca encanaquechiqueri tsanlatichunae. Pode jomanpari, Diosi wenteca junlacanan encanano jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Junni meralaquede! tinue. Lari nulabe caquenan jera pánayoe yape tencabe nenalarasa. Jesús yachi tsachilabe tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Junni Jesús cacuenta quinato, itsantinue: —Jun padeseinunsile, yo nemeichunae tinue. Penan tsetuchunae. ");
INSERT INTO cofNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tsabonan jamochi nechi darapatachunae tinue. Yoquidobi wetuto chuminlari welaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsanhinunsile tsachilari laca tsachi ica jun jominca manquiralaquichunae tinue. Urara tsenbe, duque mantá tan joto, poyobi nechi manpatanaminca quiralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Junsi anjelilaca ereyanae tinue yape la wenteca junlaca jera layalaquisa. Fechi nechinan, pelechi nechinan, butunni tala nechinan yalaca jera layalaquichunae tinue. Fe nuwiri bare tobi nechinan yalaca layalaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jana ico peleca cuenta quechinayoe tinue. In cuentaca meráto seque miilaide! tinue. ¿Aman wata cura ico pele japisu jera patimin joco? Junni fu manhichinasanan, japisu manquimanhe. Aman japisu manquinaminca quirato, nulari miiminla joe manfu ichinaeque. ");
INSERT INTO cofNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jun tsanquenan la paca jera tsanhinaminca quirato, laca moora manpatachunaeque miilaichunae tinue. Laca moora manquiraichinae tilatichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nulabe tsarasica pachinayoe: Ya tsachilari cajerailaitusanan, la paca jun fiqui jera tsanhichunae. ");
INSERT INTO cofNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yoquidonan, tonan jeraichunae. Lachi fiqui mantimini numanan epe fiqui ituchunae; la ticatiya tsanhichunae tinari, jun tsannan ichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tsan josanan la numasi ti maca manpatano jonunca monantiya miitolajoe. Diosichi anjelilanan miitolajoe. Lanan Diosichi Nao jotonan, miitoyoe tinue. Apa Diosisiri mirae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Junni nulanan miitolajoe tinue la numasi manpatano jonunca. Jun tenchi tencabe nenato, Diosibe rocaide nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Meralaquede! Lari bare toca nenabi jimin tsachi cuwenta joichunae tinue. Nenabi jimin tsachiri yachi yabi nechi jinato, peyunlaca jera ticatiya cuidaisa mantachunae tinue. Jerale peyunlaca jera ti quinola jonunca mantachunae mancaca mancaca. Junni tamolanca cuidaimin peyunca seque quiranana! tisi, bare toca jichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Junni peyunlari ya tsacumin numasi manjano jonunca natiya miitolajochunae tinue. O nemeinasale, o quitsa quepente, o walpa pánasale, o quepenan tseinasale, numasi manjano jonunca natiya miitolajochunae tinue. Junni Jesús ya cuenta polarisi, yachi tsachilabe manpato itsantinue: —Nulanan ya peyunla cuwenta quira quira nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Lari jun ya tsacumin cuwenta moorasiri manjanari, nulari tenca cato nenaminla jona! Tenca iton catson tsomin cuwenta nenamin itolajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Junni nulabe tsantinato, jeralelabenan jun tsannan tinayoe tinue: Quira quira nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Junni aman casa ma fiesta ichun palu ma cajominue. Jun fiestate lebadura iton bibuca finun jominue. Junnasa mantá tan patelelabe, israelítala tala mantaca micariminlabe Jesuca totechi tito, yaca nosale nechi cachique tenca cade nenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Junni yala tala itsanlatinue: —Fiesta órate catuntsan joe tilatinue yape tsachilari firara tilatitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Junni Jesuri Betania puebloca jito, Simonchi yabi chuminue. Aman ya Simonni lepra bichi chumin jominue. Junni Jesula junbi ano fito chularasanan, sona manca duque mica puban pica tanjanue. Tsara sen nardo tinun puban pi jominue. Alabastro tinun suca quica jun boteyabi pun jominue. Junni ya sonari boteyaca cole ereto foroto, puban pica Jesuchi misubi ponue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Junni tsanquinaminca quirato, weyanlari paito, itsanlatinue: —Ya mica puban picari epe tsannae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ya puban pica osito duque cala cato, ya calaca poperelachi cuwantsan jominue. Seiton quinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Junni Jesuri yalachi fiquica meráto itsantinue: —Nulari in sonaca telaqueponilaquede! tinue. ¿Ti quichun yaca pasuwalaquinayun? Yari laca seque quinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aman popere tsachilari numatotiya nulabe pejoto polelaichunae. Numasitiya yalaca seque quino podeilaichunae tinue. Manan la mantimini numatotiya nulabe chuto poleno itoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","In sonari lachi tenchi jera quino podeinunca quinae. ¿Jana puyaca junlaca menachun puban pica pono joco? Aman la capuyatusanan, lacanan menachun cuwenta ya puban pica numa ponae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nulabe tsarasica pachinayoe: Diosichi sen fiquica jerale tote micarinato, in sona tsanquinanuncanan palaquichunae tinue yape yaca mantenhilaisa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chunca paluca Jesube penenaminla manca Judas Iscariote jominue. Junni yari mantá tan patelelachica jito, Jesuca nulachi cuwapono muquee tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aman mantá tan patelelari junca meráto son tito, cala cuwalaquechinayoe tilatinue. Junni junte nechi Júdari tenca cade nenaminue Jesuca niyaque cuwapono jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Junni casa ma fiesta fanue lebadura iton bibuca finun fiesta. Aman caque fiesta mate opisa náca totenun jominue casa ma fiesta quinato fichun. Aman junni Jesube penenaminlari yabe itsanque panhalaquinue: —¿Chiquilari fiesta anoca tile daquintsan jun? latinue nube casa ma fiesta ano filaquichun. ");
INSERT INTO cofNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Junni Jesuri yala tsantinunsi, yabe penenaminla palucaca jera selaquinasa erenue. Erenato, yalabe itsantinue: —Puebloca jilaide! Aman pueblobi wilainaminnan, pi nana jun janamin unilabe tulailaichunae tinue. Nulari yachi beneca jilaina! ");
INSERT INTO cofNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Junni yari yabi winunsi, nulari jun ya tsacuminbe itsanlatina! Chiquilaca micarimin tsachi rocainae tilatina! fiesta ano fichun tamoca micuwasa. Junbi casa ma fiesta anoca yachi tsachilabe pefino muquee tinae latina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Junni aman nula tsantinunsileri, jamobi wa tamoca micuwachunae tinue. Jun tamochi mesa, plato, titiya jera jochunae tinue. Junni nulari jun tamochi fiesta ano fichun jera selaquinana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Junni Jesús tsantinunsi, yala paluca Jerusalén pueblobi wilainue. Junni Jesús tsanque paca josa, jun tsanquenan patinue. Junni junbi casa ma fiesta ano fichun jera selaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Junni quebite Jesube yachi chunca paluca tsachilabe jun yabi féto wito, ano filaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aman ano fito chuminnan, Jesuri yalabe itsantinue: —Nulabe tsarasica pachinayoe tinue: Nula manca laca uyanlachi cuwapochinae tinue. Cuwapomin tsachi labe tsaina ano pefinae tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Junni Jesube penenaminlari laquiilaito, manca manca Jesube itsantilatinue: —¿La itoiinco? ¿La itoiinco? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Junni Jesús yalachi fiquica meráto, yalabe itsantinue: —Laca cuwapomin tsachi nula chunca palucabi manca tsachi joe tinue. Yari la finanun nidabi pefinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","La tsachi ica jun joto puyabi jichinayoe. Diosichi Pilabi laca tsanquenan chuteca joe tinue puyano joeque. Laca cuwapomin tsachi mantimini duque padeseichunae tinue. Ya tsachi naica itomanpari, yachi tenchi fe se jono jomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Junni ano filaquinaminnan, Jesuri bibuca cato, Diosibe acradeseito, pisuleto, yabe penenaminlachi cuwanue. Cuwanato itsantinue: —Nen, in biburi lachi puca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Junsi bino copacanan cato acradeseito, yalachi cuwanue yape cuchilaquisa. Jeralela cuchilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Junni Jesús yalabe itsantinue: —Amana Diosi tsachilabe trato quinae jutsa piyarino joyoeque. Junni in binori lachi asan joe tinue. In binoca tenca cato miintsan jochunae Diosi ya casan trato quica joeque. Lari layan tsachilachi tenchi asan larino joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Junni nulabe tsarasica pachinayoe tinue: Binoca natiya mancuchituanae tinue Diosi mantananun tobi casan mancuchino fecári. ");
INSERT INTO cofNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Junni Jesula fiesta ano fitobi, Diosica canta quetobi, Olibo tinun duca jilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Junni Jesuri yalabe itsantinue: —Amana quepen nula jeralela laca purato sujilaichunae tinue. Aman Diosichi Pilabinan junca itsanque chuteca joe tinue. Opisaca cuidaiminca totenan, yachi opisa epele ara cura jera sujilaichunaeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tsan josanan, lari puyatonan mansonhitobi, nulaca caquenan Galilea toca manjito, junbi nulabe mantulaiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesús tsantinunsi, Pédrori itsantinue: —Uyan jeralela nuca puralaquinasatiya, lari te, numanan nuca puratuanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Junni Jesuri Pédrochi fiquica merasi itsantinue: —Nube tsarasica pachinayoe tinue: Amana quepen nunan laca purachunae. Walpa apaca palu ne capatusanan, peman ne laca natiya miitoyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro mantimini sonba pato, te, nube puyano jototiya, nuca numanan tsantituanae tinue. Junni weyan Jesube penenaminlanan jun tsanquenan palaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Junni Jesúlari junbi nechi jito, Getsemaní tinun postoca jilainue. Junni Jesús yachi tsachilabe itsantinue: —Intele chudito meralarade! tinue la Diosibe rocainasa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Junni weyanlaca junte chuteto, Pédroca, Jacóboca, Juanca nanni jabile tanjinue. Junni jilainato, Jesuri yalabe cuenta quinue. Duque laquiito wepanato, ");
INSERT INTO cofNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","itsantinue: —Lachi tenca puyan tsansi laqui joto, case puyawiyanayoe tinue. Jun tenchi nulanan inte quirato chularana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Junni Jesuri nasi cajisi, tobi mutsale telenhito, Diosibe rocainue yape jun mate padeseino jonunca polarisa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Rocainato itsantinue: —Apa Diosi, nu jera quino podeimin joe tinue. Junto jana tsanba pin copaca cuchichinaminca mancanun cuwenta, laca padeseisa caritude! Aman la tsantinasatiya, lachi tenca munate quituna! tinue. Nuchi tenca munateri quiniquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Junsi Jesús yachi pemanca tsachilachica manjanasa, catson tsominlanue. Junni Pédrobe itsantinue: —Simón Pedro, ¿nuri catson tsoyun? ¿Moora nacátiya catsotuto mérano podeitiyun? ");
INSERT INTO cofNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nulari Diosibe rocaito, tencabe nenalarana! tinue jutsa quituchun. Nulachi tencabiri seque nenano munaratonan, pucari cumana jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Junsi Jesús manan manjito, Diosibe jun tsanquenan manrocainue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Junni manan manjato quiranari, manan mancatson tsominlanue. Duque capiya taminlanue. Tsan joto, yalari luito Jesube niyaque manpano jonunca miitominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Junni Jesuri tsanque peman ne jin, manjan, itobi, yachi tsachilabe itsantinue: —¿Catson tsoniralarayun? ¿Cajasainiilainayun? tinue. Michi joe. Cuwapono óra fee tinue. Lari tsachi ica jun joto seitonlachi cuwapoichinayoe tinue yape laca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Junni jisa! Mancupalaide! tinue. Aman quiralaquede! Laca cuwapono jun tsachi jana janae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Junni Jesús cacuenta quinasanan, Judas Iscariote fanue. Yari chunca paluca Jesube penenaminla jominue. Junni Júdabe duque israelítala pejalainue weyanlari chide tanla, weyanlari espada tanla. Aman mantá tan patelelabe, israelítala tala mantaca micariminlabe, mantá tan unicalabe, layaito ya tsachilaca Júdabe ereca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aman Júdari Jesuca cuwapochun pejaminlabe itsantica jominue yape Jesuca miilaisa: —La tsachi mancaca motito saludaiyanae. Yari Jesús jochunae tica jominue. Junni yaca cato, sele tanjilaina! tica jominue yape sujitusa. ");
INSERT INTO cofNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Junni Júdari Jesúchica we quelo fato, Miya tito, motito saludainue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsantinunsile uyanlari Jesuca chuito calaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsanlaquinasanan Jesube penenamin tsachi manca quelole wirurato, yachi espadaca laricato, mantá tan patelechi peyunca espadachi quito punquica balequinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Junni Jesuri yaca cachi timinlabe itsantinue: —¿Ti quichun laca espada tanla, chide tanla, tarinminca cuwenta cabi jalainayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lari ma cura nulabe Diosichi yabi micarito chumanyoe tinue. Junteri laca calaquitue. Aman Diosichi Pilabi chuteca joe tinue nulari laca tsanquinola joeque. Jun tenchiri amanari laca canilaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Junni Jesús tsantinasale, jerale yachi tsachilari yaca purato jera sujilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Junnasa juntelenan nalalan tsachi manca jalisiri awi jun Jesube pejinaminue. Junni Jesuca canaminlari yacanan cachinato, ");
INSERT INTO cofNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","jalile chuinasa, jali bale jinan, fupuca sujinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aman junni Jesuca fe mantá tan patelechica tanjilainue. Jerale mantá tan patelelabe, mantá tan unicalabe, mantaca micariminlabe, junbi jera layaica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aman tsan josanan, Pedro comabile benechi jito, patelechi sela fecári fenue. Junni selabi wisi, polisialabe chudito, nin pelobainaminue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Junnasa mantá tan patelelabe, jerale mantaminlabe testicolaca munaraminlanue yape Jesuca culpa quilaquisa. Jesuca culpa quito totesa carichi tilatinue. Junni casaleri epenan culpa quichi tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Layanlari Jesuca nene pato culpa quichi latinatonan, natiya culpa patarino podeilaitunue. Weyanla man tala pan, weyanlari uyan tala pan, quito, man parejori patulajonue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsanlatinasa quiranari, weyanlari wiruito, Jesuca nene pato, itsantilatinue: ");
INSERT INTO cofNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jesús Diosichi yaca seitonque pánaminca meralaquiyoe latinue. ¿Diosichi ya tsachila quica jun yari joco? tie latinue. Junni Jesuri Diosichi yaca jera araleto, peman mate casan ya manqueyanae tie latinue. Ya casan ya tsachila quica jun ya itochunae tie latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Junni ya testicolanan man parejori palaquitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Junni fe mantá tan pateleri quitsale wiruito, Jesube itsanque panhanue: —¿Niyaito beconan pátiyun? tinue. In testicolari nuca duque culpa quilaquinae tinue. ¿Junni nuri niyan tichun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús mantimini nosasa wirurato, natiya beconan patunue. Junni pateleri manan manpanhato itsantinue: —¿Nuri Diosi wenteca Cristo tinun tsachi joyun? tinue. ¿Se tinun Diosichi Nao joyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Junni Jesuri yayoe tinue. Junni nulari laca, tsachi ica junca, jamochi manquiralaquichunae tinue. Sonban Diosichi tsa tede nanchi mantato chuminca quiralaquichunae tinue. Laca jamochi poyobi manpatanaminca nulari quiralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Junni Jesús tsantinunsiri, fe mantá tan pateleri duque paito, tencachique camisaca chilenue painanunca miilaisa. Junto itsantinue: —Amana testicolaca munaralaratiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chiquilanan Jesús Diosica seitonque pánaminca meralaquiyoe tinue. ¿Junni Jesuca niyan tilatinayun? tinue. Junni jerale mantaminlari Jesuca totentsan joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Junni aman weyanlari Jesuca pipichi quilaquinue. Junsi yachi cacaca doto, yaca lucarito tedechi quito quirato, itsantilatinue: —¿Mo nuca tedechi quinan? latinue. Diosichi mantate nuchi tencabiri miiniide! latinue. Junsi polisialanan yaca tedechi quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tsanlaquinasanan Pédrori selabi chusanan, fe mantá tan patelechi peyun sona jun quelole polenue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Junni ya peyun sonari Pedro nin lobainaminca quirato, itsantinue: —Nunan ya Jesús tinun Nasaret tsachibe penenamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Junni Pedro mantimini itsantinue: —Te, yaca miratiyoe tinue. ¿Mo jonhoncan? tinue. Junni Pedro tsantisi, sela tamolan fecári jinue. Junnasari walpa apaca panue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Junni ya peyun sonari Pédroca manan manquirato, junte raminlabe cuenta quito, ja tsachinan Jesube penenamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Junni Pédrori manan manpanue natiya tsan itoyoeque. Junni nasi wanbile junte ramin tsachilari Pédrobe itsanlatinue: —Nuri Jesube penenamin tsachi joda. Yala cuwenta Galilea tsachi joe. Nu Galilea tsachi cuwenta pamin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Junni Pédrori yalachi fiquica meráto Diosi mirasa pánayoe tito juraquito itsantinue: —Lari nula pánanun tsachica natiya miitoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Junni tsantinasaleri, walpa apaca manan manpanue. Aman Pédrori walpa apaca manan panunca merasi, Jesuchi fiquica mantenhinue. Jesuri Pédrobe itsantica jominue: Walpa apaca palu ne capatusanan, nuri laca peman ne miitoyoe tichunae tica jominhe. Junni Pédrori Jesús tsanticaca mantenhito, duque warenue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Junni tseinunbi, mantá tan patelelabe, mantá tan unicalabe, mantaca micariminlabe, uyan mantaminlabe, jeralela tenpalaquinue. Junto Jesuca teleto, miya Pilátochica tanjito cuwapolaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Junni Pilátori Jesube panhato ¿Nuri israelítalachi miya joyun? tinue. Junni Jesuri tsan joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Junni mantá tan patelelari Jesuca Pilátochi cale duque culpa quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Junni Pilátori Jesube manpanhato itsantinue: —Nuca duque culpa quilaquinae tinue. ¿Nuri beconan pátiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aman Jesús mantimini man fiquinantiya beco patunue. Junni Pilátori junca duque wepananue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aman casa ma fiestate Pilátori doramin tsachi mancaca manlarimin jominue. Tsachilabe panhamin jominue moca manlarisa tenjanque. ");
INSERT INTO cofNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Junni jun mate doraminla weyanlari miyachi soldadolabe totaalaquinato, tsachilaca totecala jominue. Junni yala manca Barrabás tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Junni duque tsachila layaica joto, Pilátobe manrocailainue yape jun watatenan doramin mancaca manlarisa. ");
INSERT INTO cofNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Junni Pilato mantimini ura tenhinue israelita mantá tan patelelari pachisiri Jesuca cuwapolaqueeque. Junto israelítalari doramin mancaca manlarisa rocailainasanan, Pilátori itsantinue: —Nulari israelítala joto, ¿nulachi miyaca manlarisa munaralarayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aman tsan josanan mantá tan patelelari jerale layaica jun tsachilaca payica jominlanue niyaque Pilátobe panola jonunca. Jesuca natiya manlarituto, Barrabácari manlarisa carilaquina! tica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Junni tsachilari tsanque Barrabaca manlarisa rocailainasa, Pilátori itsantinue: —Junni Barrabaca laritori, ¿nula israelítalachi miya joe tinun tsachicari niyan quisa tenjalaquin? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Junni layaica jun israelítalari beconan sonba pato, yaca corosibi totesa caride! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Junni Pilato yalabe manan manpato itsantinue: —¿Niya jonan Jesuca tsanlatinayun? tinue. ¿Niyaque seiton quica jun? tinue. Junni tsachilari jun fiquica natiya tennatuto, fécari sonba pato, corosibi totesa caride! latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Junni Pilátori tsachilaca son josa carichique Barrabaca manlarinue. Junto Jesuca asotaquisa carito, soldadolachi cuwaponue yape corosibi totelaquisa. ");
INSERT INTO cofNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Junni soldadolari Jesuca miyachi yabi wa tamochi tanwito, jerale jun bolon soldadolacanan layaisa carilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Junni Jesuca duque lucarilaquinue. Miya ponun uraran morado camisaca yaca pocarilaquinue. Junsi po silica torinca quito, yachi misubi polaquinue yaca miyae tito. ");
INSERT INTO cofNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsanquesiri, Jesuca miyaca cuwenta biba quito, israelítalachi miyaca biba quilaquisa! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Junni misule peso tede tsanchi quin, pipichi quin, quito quiralaquinue. Junsi miyachi cale cuwenta yachi cale telenhilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Junni Jesuca michi pamiyato quiratobi, ya morado camisaca manlarito, yachi camisaca manpocarito, corosibi totebi tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Junni toteno jonun postoca tanjilainasa, Cirene tobi chumin tsachi, Simón tinun, witabi nechi manjanaminue. Ya Simón Alejándrochi, Rúfochi apa jominue. Junni soldadolari yaca Jesús puyano jun corosica nanasa carilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Junni Jesuca Gólgota tinun posto fecári tanjilainue. Aman yalachi fiquichiri misu chide postoca “cólcota” tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Junni binobe mira tinun pilube palato, Jesuchi cutsawochi latinasanan, yari cuchitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Junni quepenan, nuebe tsansite Jesuca corosibi wilocarilaquinue yape puyasa. Junni corosibi wilorasanan, soldadolari yachi panuca, camisaca quitsaleto calaquinue. Apostaito sorteaito miilainue mo yachi tsanpaca cano jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Junsi pila chutelaquinue ti culpa tenchi puyananunca. IN ISRAELITALACHI MIYA JOE que chuteca jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Junnasa mantimini paluca tarinlaca Jesube parejo corosibi wilocarilaquinue manca yachi tsa nanchi, manca yachi jala nanchi. ");
INSERT INTO cofNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aman matu mate Diosichi Pilabi Jesuca itsanque pila chuteca jominue: Yari seitonlabe man parejori joe latichunaeque chuteca jominue. Junni tarinlabe corosibi pepuyanan, ya fiqui tsarasi lonue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Junni junse polenaminlari Jesuca yucacurato, pachi misuca disi disi quito itsantilatinue: —¿Nuri Diosichi yaca araleto peman mate manqueyanae tinuco? ");
INSERT INTO cofNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Junni nuri tsansi poden jotori, tenca mántanan se lode! Corosibi nechi manpataniide! latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Junni mantá tan patelelanan, mantaca micariminlanan Jesuca seitonque pato, lucarito quiralaquinue. Yaca yucacurato, yala tala itsanticaalaquinue: —Ja tsachiri uyanlaca se larimin joyoe titonan, tencachiquenan natiya se lono podeitue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yari Diosi wenteca jun Cristo tinun tsachi joyoe ticae latinue. Chiquilachi miya jotori, corosibi nechi manpatantsan joe latinue yape chiquila yaca quirato quereilaisa. Junni Jesube parejo wiloraminlanan yaca yucacuralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Junnasa aman yotute nechi peman óra fecári jerale jun tote nemen inue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Junni tre de la tardete Jesuri sonba pato itsantinue: —Lachi Diosi, lachi Diosi, ¿niya jonan laca puraca joyun? tinue. Aman yalachi fiquichi pato, “Elí, elí, lama sabactaní” tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Junni jun quelole raminla weyanlari yaca “elí” tinaminca meráto, se merátuto, matu to Elíaca otinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsanlatinunsiri tsachi manca sujito, cuwa tsanbi pele binoca atasuwato, chidebi chuteto, Jesuchi fiqui forole tilicarinue yape chusa. Junto camérantsan joe tinue. Pansile Elías yaca manpataribi jachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús mantimini sonba atito puyanue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Junni soldado capitan Jesuca ca tala ca tala quirato, Jesús atinanunca meráto, niyaque puyananunca quirato, itsantinue: —In tsachiri Diosichi tsa Nao jominue tinue. Aman Diosichi ya tamo quitsabi wa jali tsan dole tinraminue. Junni Jesús puyanasaleri, ya jali jamochi nechi jera chile sujinue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Junni aman sonalanan jabile nechi pequiranaminlanue. María Magdalena, Salomé, manca María jominlanue. Ya María Josechi ayan, junsi nalalan Jacóbochi ayan jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea tobi canenasanan, ya sonala yabe penenato cuidaimin pejominlanue. Junsi duque uyan sonalanan Jerusalén puebloca Jesube pejato, corosite peraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Junni ayuna jasaino ma ichun quebi inaminue. Jasaino ma tenchi jera seno ma jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Junni duque mantá tan tsachi manca jominue José tinun. Yari Arimatea pueblobi chumin jominue. Yanan méraminue yape Diosi ya mantananun tsachi bolon pesuwasa. Ya mantimini sonba tenca ito, Pilátochica jito, Jesús puyacaca mancuwasa rocainue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Junni Pilátori wepananue Jesús numa puyaca junhunque. Junni capitanca jasa carito, yabe panhanue Jesús numa puyanque. ");
INSERT INTO cofNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Junni capitan Jesús numa puyaca joe tinan, Jesús puyacaca Josechi mancuwasa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Junni Joseri sen jalica cato, Jesús puyacaca corosibi nechi patarito, jalichi lapito, menanun forochi tsorenue. Su chupaca bobeda cuwenta foro quisa carica jominue puyacalaca tsorechun. Junni Jesuca jun forochi tsoreto wa suca elanpolarito, jun foroca donue. ");
INSERT INTO cofNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tsanlaquinasanan, María Magdalénabe, Josechi ayan Maríabe, quiraca jominlanue tile Jesús puyacaca tsorecala jonunca. ");
INSERT INTO cofNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Junni aman jasaino ma polenunbi, María Magdalénabe Salomebe Jacóbochi ayan Maríabe puban pi cato, Jesús puyacaca ilipobi jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tominco ma quepenan yo tseinasale Jesús menaranunca jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Junni minute jinato, itsanque tenpalaquinaminue: —¿Mo chiquilachi tenchi tsancari wa suca menaranun forobi nechi larichunan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Junni ya sonalari janasa quiranari, suri numa elanpoleca jonan, forori foro raminue. Duque wa su animali jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Junni ya sonalari menaranun forochi wito quiranasari, tsa tede nanchi moso manca chunue. Fibaquin baren camisa pun junte chuminue. Junni sonalari yaca wepanato quiralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Junni yalabe itsantinue: —Nulari wepanalaituna! ¿Jesús Nasareno corosibi puyaca jominca neyalaquinaco? Aman inte itoe tinue. Mansonhica joe. Yaca tsoreca jonun postoca quiralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Junni nulari Jesuchi tsachilachica jito, Pédrobenan, weyanlabenan itsantilatina! tinue: Jesús nulaca caquenan Galilea toca jichunae latina! Junbi nulari yaca manquiralaquichunae latina! tinue. ¿Jesús nulabe canenatonan tsantica jominuco? Nulabe Galiléabi mantulaicaichunaeque paca jominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Junni anjeli tsantinunsi sonalari menaranun forochi nechi manloto mansujilainue. Junni jelechi jowinponato, mobenantiya junca capatulajonue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Junni Jesús tominco ma quepenanan mansonhica joto, María Magdalénabe casale manquirainue. Matunan sieteca yucanchi ocola jun sonachibi wica jominlaca mansularica jominue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Junni weyan Jesube penenaminlari laquichi warelaquinasanan, ya sonari Jesuca manson nenaminca quirayoe tide janue. Yala mantimini ya sona tsantinaminca meráto, quereilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Junni wanbile Jesús, uyan quiran ito, yachi tsachila palucabe quirainue pueblobi nechi loto jilainasanan. ");
INSERT INTO cofNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yalanan weyanlachica manjito, jera palaquinasanan, te, yalacanan quereilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Junni wanbile chunca manca Jesube penenaminla ano fito chularasanan, Jesús yalabenan manquirainue. Junto yalaca quereitumin uyan tenca punla jonun tenchi sonba pato itsantinue: —La mansonhinunbi, weyanlari laca quirato, nulabe cuenta manpolarilaquinue. ¿Junni nulari niyaito yala pacaca quereilaitiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Junni aman Jesús yachi tsachilabe itsantinue: —Nulaca itsanque mantanayoe tinue: Jerale tote nenato, jeralete Diosichi sen fiquica micarito nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Diosichi sen fiquica quereito mumunhiminlaca Diosi se larichunae tinue. Quereituminlaca casticaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aman laca quereiminla itsanque wepanato quirantsancari quilaquichunae yape uyanla miilaisa Diosibe mantailainaeque. Lachi mantate yucanchi ocolaca tsachilachibi nechi sularilaquichunae tinue. Merátunun fiquichi palaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pini jalinasatiya, o beneno cuchitotiya, padeseitulajochunae tinue. Quiyanpunlacanan tedechi tale quito manse suwalaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Junni Miya Jesús yalabe tsanque cuenta quinunsi, Diosi yaca yachi toca mantanlonue. Junbi Diosichi tsa tede nanchi chudinue Diosibe pemantachun. ");
INSERT INTO cofNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Junni Jesube penenaminlari junbi nechi jito, jeralete micarito nenaminlanue. Tsanlaquinasanan Miya Diosi peayudainue. Diosi wepanato quirantsancari seque quinaminue yape uyan tsachila tenhilaisa Diosichi sen fiquica palaquinaeque. Tsanqueri jominue.");
INSERT INTO cofNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Amico Teófilo, in pilabi Jesuca cuenta polarichinayoe. Casale casaleri yaca cacachi quiraminla chiquilabe cuenta manquilaquee. Yala casalele nechi Jesús niyan quinanunca miralarato, jun fiquica chiquilabe polarilaquee. Junni duque tsachila yalachi fiquica meráto, seque, tuca pila chutechi tilatinue Jesús chiquilachite jera niyan quinanunca. Junni lanan Jesús niyanhica jonunca casalele nechi jera tuca miica joto, jera cuenta pepolarino munarayoe. Casalele nechi jeraicari seque chuteno muquee. Nunan respetainun amico joe. ");
INSERT INTO cofNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jesucrístoca paca cuentaca numa miinae. Junni aman lachi pilaca quirato, jun cuentaca jera tsarasica tuino podeichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Casale casaleri Herodes tinun miya Judea tobi mantamin josa, israelita patele manca jominue Zacarías mumun. Abías tinun bolonbi patele jominue. Ya unilachi sona Elisabet mumun jominue. Elisabechi familialanan Aaronchi alicala joto, patelela pejominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacaríabe Elisabebe Diosichi cale sen jominlanue. Diosichi mantaca jera meráto nenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet mantimini na quitumin jotonan, sinuca jominue. Zacaríanan unica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Junni Zacaríachi bolon patelela ti quino jonatiya quinaminlanue Diosichi cale. ");
INSERT INTO cofNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Patelelachi mite jeralelachi mumunca pilaquidobi chuteto, mancachi mumunca quiratuminnan camin jominlanue mo Diosichi yabi wino jonunca miichun. Junni Zacaríachi mumun chutecaca calaquinan, yari junbi wito, insienso lucuca nin ponaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ya insiensoca nin ponasari, jerale tsachila urachinan mérato Diosibe rocainaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aman jun quiranari pansile nechi Miya Diosichi anjeli quirainue. Jun insienso nin ponanunle tsa nan tala wiruranue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías ya anjelica wepanato quirato, jeletinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anjeli mantimini itsantinue: —Zacarías, wepanatude! tinue. Nu rocainanunca Diosi meraca joe tinue. Junca meránan, nuchi sona Elisabet na quichunae. Junni ya náca Juan mumun polaquina! ");
INSERT INTO cofNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ya naieque layan tsachila son tilatichunae tinue. Nunan duque peson tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jun naoca Diosi fe mantá tan tsachi joe tichunae tinue. Bino, nin warente cuchituchunae tinue. Ya nainunle nechi Diosichi Tenca yaca jera caya jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Duque israelítalaca Miya Diosibe mancayaisa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Matu to Elías cuwenta Diosichi mantaca petachunae yape apalanan, nalalanan parejo seque mantenca calaquisa. Tsachilaca payichunae yape merátuchi timinlari manmeralaquisa. Junsi tenca tanla paca fiquica manmerása carichunae. Tsachilaca micarichunae tinue yape seque mannenalarasa, Miya jano joeque. ");
INSERT INTO cofNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Junni anjeli Zacaríabe tsantica josa, Zacarías itsanque panhanue: —Meráde! La unica joyoe. Lachi sonanan sinuca joe tinue. ¿Junto niyaito miicaichunan? tinue na quirano jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Junni anjeli itsantinue: —Gabriel joyoe. Diosichi cale wiruramin joyoe tinue. Diosi laca erecae yape in sen fiquica nube cuenta polarisa. ");
INSERT INTO cofNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Junni nu meráde! La na quichunae tica jonan, nuchi sonari na quino ma fenan na quichunae. Junni la tsanticaca nuri quereituto, patumin ichunae ya náca mumun pono fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Junni Zacaríabe anjelibe tsanque cuenta quilaquinasa tsachilari urachi méraminlanue. Diosichi ya urachi Zacaríaca mérato, wepananaminlanue ¿Niyaito tsancari piyanhinan? tito. ");
INSERT INTO cofNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Junni Zacarías manlotobi, pano podeitunue. Junto tedechi molde quito quirawonan, miilainue Diosichi yabi yachi quirajanueque. ");
INSERT INTO cofNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Junni Zacarías Diosichi yabi jera quino jonunca quito manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aman junni nanni inale Zacaríachi sona Elisabet na winue. Na witobi, mante pe fecári tsaito chuminue. Junsi ");
INSERT INTO cofNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","itsantinue: —Miya Diosi chiqueca laquirato quirato, seque quee tinue. Na quitumin joyoeque luraminca piyarie tinue na quisa carito. ");
INSERT INTO cofNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sota pe poleto, Gabriel tinun anjeli manpatanue. Diosi ereca jun manpatanue Galilea toca. Nasaret puebloca jato, ");
INSERT INTO cofNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","junto unila iton sonachica janue Maríachica. Ya Maríari unilabe cayaino jotonan, cacayaica itominue. Ya unilari José mumun jominue. Matu to miya Davichi alica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Junni aman ya anjeliri Maríachica jato itsantinue: —Nube saludainayoe tinue. Miya Diosi nube rato, nuca duque laquirae tinue. Diosi nuca duque pansi josa carichunae tinue. Uyan sonalaca fécari pansi josa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Junni María ya anjelica quirato, yachi fiquica meráto, duque wepananue. Ya ti quichun tsanque saludainanque tenca cato wepananue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Junni anjeli itsantinue: —María, jeleratude! tinue. Diosi nuca laquirae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Meráde! tinue. Nu na wito, unila na quichunae tinue. Ya náca Jesús mumun pona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ya na uwaitobi, duque mantá tan tsachi uwaichunae. Ya náca jamochi chumin Diosichi Nao tinun jochunae tinue. Miya Diosi yachi mantá cuwachunae matu to miya Davichi cuwenta. David yachi matu tata joto, israelítalaca mantamin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Junni nuchi nao jun tsanquenan israelítalaca mantamin jochunae tinue. Numatotiya mantato chuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríari jun fiquica meráto, unila itoyoe tinue. ¿Junni niyaito na queichunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Junni anjeli manpato itsantinue: —Diosichi Tenca nuchica jachunae tinue. Diosi fécari mantá tan joto, nuca poyochi cuwenta dochunae tinue. Junnan ya sen náca Diosichi Nao tinun jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Meráde! Nuchi familia Elisabenan, sinuca jotonan na pun joe tinue. Na quitumin joe latica josanan, sota pe na pun joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diosi jera ticatiya quino podeimin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Junni Maríari anjelichi fiquica jera meráto, itsantinue: —Junni tsan jonari, se joe tinue. Miya Diosi panunca meraniquimin joanae tinue. Nu tsantica fiqui se loniisa tenjae tinue. Tsantinunsi anjeli manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Junnasa María du minu wewe jito, Elisabet chunun puebloca jinue Judea tobi. ");
INSERT INTO cofNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Junni Zacaríachica jito, tamochi wito, Elisabebe saludainue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Junni aman Elisaberi Maríachi fiquica meránan, nari Elisabechi pecolobi wecainue. Junni Elisaberi Diosichi Tencabe jera cayaica joto, ");
INSERT INTO cofNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","sonba seque pato, itsantinue: —Diosi nuca pansi josa carichunae tinue yape uyan sonalaca fe pansi josa. Nuchi naocanan pansi josa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nuchi na chiquechi Miya jochunae tinue. Junni chique duque son joyoe tinue nu quirabi jae tito. ");
INSERT INTO cofNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Junni nuchi saludoca meránunsi, chiquechi na wecaie tinue. Duque son tito pecolobinan wecaie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nu Miya Diosichi fiquica quereito, duque son jochunae tinue. Ya fiqui tsarasica jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Junni Elisabechi fiquica meráto, María itsantinue: Chiquechi tencabi Miya Diosica tsaracari seque pánayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Diosi chiqueca se larica joe tinue. Junnan chiquechi tencabi yaca duque son joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Diosiberi mantaimin jotonan, epe sona joyoe tinue. Tsan josanan Diosi chiqueca duque seque quirae tinue. Junni meráde! Amanale nechi jeralela chiqueca pansi joe tilatichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diosi duque sonban joto, chiqueca tsaracari seque quee tinue. Ya tsaracari sen patsa joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yaca jeleraminlaca numatotiya laquirato polechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Junni yari sonba quimin joe yape sonban Diosi joeque miilaisa. Weyanlari tencabi duque sen joyoe tito, mantá tayoe timinla joe tinue. Diosi mantimini yalaca jera arara sueremin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Fécari mantá tan tsachilaca epe suwamin joe; epe tsachila jominlaca mantá tan suwamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ano itonlachi sen ano cuwamin joe; oco tsachilachi natiya cuwatuminnan manheremin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Diosi yachi israelita tsachilaca ayudaica joe. Yalaca laquirano joyoeque mantenhito, ayudaica joe. ");
INSERT INTO cofNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chiquilachi matu to tatalabe junca cuenta quito tsantica jominue. Maríari tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Junto María Elisabebe peman pe tsansi pechuto manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Junni Elisabet na quino ma fenan, unila na quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Familialabe quiranunlabe na quica jonunca miito, son tilatinue. Diosi ya sonaca duque laquirato na quirasa carinue tito yaca son tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Junni ochu mate ya nachi quidoca poreno jominue israelítalachi mite quito. Tsanque poresa caribi jito, jun matenan mumun pono jominue. Junni quirabi pejaminlari ya náca Zacarías mumun pontsan joe latinue yachi apa cuwentanan. ");
INSERT INTO cofNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nachi ayan mantimini te tinue. Yaca Juan mumun polaquechinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Junni amicolari wepanato, itsanlatinue: —¿Ti quichun ya náca Juan polaquichun? tilatinue. Nulachi familiala monantiya Juan mumun itolajoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsantito, nachi apaca quirato tedechi micuwalaquinue ya náca ti mumun pono jonunca miichun. ");
INSERT INTO cofNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Junni nachi apari pilaquido panhato, ya nari Juan mumun joeque chutenue. Junni jeralela junca quirato, wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Junni aman nachi apa tsanque pila chutesi, manpano podeinue. Junto aman Diosica seque panue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Quirabi pejaca junla nachi apa manpano podeinunca quirato jeleilainue. Junni Judea tobi du minu jun cuentaca jeralete mera jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ya cuentaca meráminla junca duque tenca canilaquinue. ¿Jun na niyanhichunancan? tito, duque tenca calaquinue. Junni ya náca Diosi laquirato ayudainaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Junni nachi apa Zacaríari Diosichi Tencabe jera cayaito, Diosichi mantate pato, itsanque panue: ");
INSERT INTO cofNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Miya Diosica duque seque pantsan joe tinue. Israelítala yachi tsachila jolajoyoe. Junni chiquilachica jato, chiquilaca se larichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Matu to miya David Diosibe mantaimin pejominue. Junni yachi alica mancaca Diosi wentechunae tinue. Yaca sonban se larimin suwachunae yape israelítalaca se larisa. ");
INSERT INTO cofNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Matu mate Diosichi mantate paminlaca cuenta quilaquinue tinue. Diosichi sen tsachila joto, ya se lariminca itsanlatinue tinue: ");
INSERT INTO cofNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chiquilaca se larichunae latinue tinue yape chiquilaca pa jominla pasuwalaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aman Diosiri chiquilachi matu tatalabe paca joto, Ya fiquica mantenhino joyoe tica joe tinue. Yalaca laquirato ayudaino joyoe tica joe tinue. Jun tenchi amana mate jun fiquica mantenhito ya se lariminca erechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aman ya matu to paca fiquiri Abrahanbe paca jominue tinue. Diosi Abrahanbe juraquito, tsarasi cuenta quito, itsantica jominue tinue: ");
INSERT INTO cofNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chiquilaca se lariyanae tica jominue yape pa jominla chiquilaca pasuwalaquitusa. Se lariyanae tica jominue yape chiquilari ya pa jominlaca jele tituto, Diosichi tenchi titiya quino podeilaisa. ");
INSERT INTO cofNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tsanquinan, chiquilari Diosica meráto, yabe seque penenano podeilaiichunae tica jominue tinue. Junni Diosi tsanqueyanae tica joto, amana mate tsanquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Junni nachi apa jeralelabe tsantitobi, aman nabeman itsantinue: Nuca jamochi chuminchi mantate pamin joeque palaquichunae tinue. Nu Miyaca caquenan jito, yachi tenchiri tsachilaca manseisa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nu Diosichi tsachilaca micarinato, in fiquica micarichunae tinue. Chiquilaca se larichunaeque micarichunae tinue; jutsaca piyarintsan joeque micarichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Junni Diosi chiquilaca duque laquirato, chiquilachi jutsaca piyarichunae tinue. Chiquilaca laquirato, chiquilachite jamochi nechi tsechunae. ");
INSERT INTO cofNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aman chiquila jutsa quiminla joto, nemente cuwenta jolajoyoe tinue. Junni Diosi chiquilachi tencabi tseisa carichunae yape yachi minubi nenalarasa. Jun minubi nenaminlari wepanatuto pansi nenalarachunae tinue. Ya nachi apa tsanque cuenta polarinue Diosichi mantate pato. ");
INSERT INTO cofNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Junni na uwainato, sonban tenca inue. Niyanlanantiya chutunun postote chuminue israelítalaca micaribi jano fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Ya Mumunmin Juan tsotsoca na cajosanan, jun to miya casale nechi jerale tsachilaca milaquisa mantanue. Fe mantá tan miya, Augusto César mumun, ya tsanque mantanue. Cirenio tinun tsachi Siria tobi miya josanan, Augusto César tsanque mantanue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Junni jerale tsachila matu sonnanun puebloca manjino jominlanue yape milaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Junni Joseri matu to miya Davichi alica joto, Nasaret pueblobi nechi loto, Galilea tobi nechi loto, Davichi puebloca jinue Judea tobi. Ya pueblo Belén tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María Josebe cayaino joto, yanan Josebe Belenca pejinue yape yala palucaca milaquisa. Aman junni María na pun joto, ");
INSERT INTO cofNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenbi moorasiri chusanan, na quino ma fenue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Junni pension quidi jonan, cotonlabi chuminlanue. Junbi casale náca quinue. Unila na jominue. Junto ya náca pirato, animalichi ano cuwanun pateyabi tsorenue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jun tobi opisaca cuidaiminla chuminlanue. Quepen lapa minu chuminlanue opisa cuidaito. ");
INSERT INTO cofNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Junni Miya Diosichi anjeli yalabe quirainue. Diosi yalachi awinta tsenhisa carinue. Junca quirato, duque jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Junni anjeli mantimini jeleratulajode! tinue. Junsi itsantinue: —Meralaquede! tinue. Nulachi sen fiquica tanjanayoe tinue. Junni in fiqui duque son josa carimin fiqui joe tinue yape jeralela son jolajosa. ");
INSERT INTO cofNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Amana Davichi pueblobi na manca nainue. Ya na nulaca se larimin jochunae. Diosi wenteca jun CRISTO tinun Miya joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Junni nula itsanque miilaichunae ya mo na jonunca. Ya nari piraca jun, animalichi ano cuwanun pateyabi tsominca felaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Junni anjeli tsanque panunsi, pansile nechi ya anjelilabe duque anjelila quirailainue. Diosica tsarasica pato itsanlatinue: ");
INSERT INTO cofNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Jamochi chumin Diosica tsara sen patsa joe tintsan joe tilatinue. Diosi tsachilaca pansi chusa carichunae yape wepanatuto chularasa. Diosi tsachilabe sen jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Junni anjelila jamochi manjilainunbi, opisa quiraminla tala cuenta quilaquinue: —Belenca jilaisa! tilatinue. Miya Diosi chiquilabe sen fiquica cuenta quee; junni junca quirabi jilaisa! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aman Belenca jito, Maríaca, Joseca, na nacacanan felainue. Ya na mantimini animalichi ano cuwanun pateyabi tsominue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yaca quirato cuenta quilaquinue. Anjeli jun náca cuenta quinunca jera cuenta manpolarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Junni opisa cuidaiminlachi fiquica meráminla jeralela wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María mantimini jun fiquica tennato, tenca caniquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Junni opisa cuidaiminla manjilainue. Anjelila yalabe tsanque patichunae tica josa jun tsanquenan jera patica jominue. Junni ticatiya jera quiracaca, jera meracaca tenca cato, Diosica duque sen joe tide manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","María na cawitusanan, anjeli yaca mantaca jominue ya náca Jesús mumun posa. Junni ochu ma tanca israelítalachi mite quidoca porenato, yaca JESUS mumun polaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Junni aman matu to Moiseri Miya Diosichi mantaca pila chuteto, na quiminlaca itsanque mantaca jominue: na quicale nechi junpalu chunca mate Na quicaca casinayoe tito, Diosichi ticatiya cuwalaquisaque mantaca jominue. Junni aman unila na quinari, man fiquicanan mantaca jominue. Casale na unila na jonari, yaca Diosichi joe tintsan joeque chuteca jominue. Jun tenchi casale na unila na jonari, Diosichi ticatiya cuwano jominlanue na tenchi pacara quica cuwenta. Miya Diosi paluca juwejuca o paluca palomaca yachi cuwasa mantaca jominue. Junni Maríabe Josebe jun tsanquilaquinue. Junpalu chunca ma polenunbi Jesuca Jerusalén puebloca tanjilainue Diosichi yaca. Junni junchi tanjito, Diosichi jera tsanque cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aman junni unica tsachi manca Jerusalenbi chuminue Simeón mumun. Diosica tenca cato seque nenamin jominue. Junni Diosichi Tenca yachi tencabi jera pejominue. Ya tsachi méraminue yape Diosi israelítalaca laquirato se lariminca eresa. ");
INSERT INTO cofNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","27","Junni Josebe Maríabe Jesús na nacaca Diosichi yaca tanjilainue Diosichi mantacaca quebi. Junni yala wilainasa, Simeón janue. Diosichi Tenca yaca ereca jominue yalabe tulaisa. Junni Diosi ya tsachica tenhisa carica jominue Crístoca quirano fecári puyano itoeque. ");
INSERT INTO cofNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Junni Simeón yalabe tulaisi, náca cato, amanto quirato, Diosica seque pato itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Miya Diosi, la nube penenato, amana pansi puyaniiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nu tenhisa carica jun tsa patinae. Lachi cacachinan nu ereca jun se larimin tsachica quiranayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nu in náca piyanlelachi tenchi eree. ");
INSERT INTO cofNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Israelítala nuchi tsachila joto in nabe tsara se inola jochunae tinue. Yari uyanlachi tenchi tseno cuwenta jochunae. Junni Simeonni ya Jesús na nacaca tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Junni tsanque panunca meráto, yachi ayanbe Josebe wepanato meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Junni Simeón yalacanan seque pato, ya nachi ayan Maríabe itsantinue: —Meráde! tinue. In na tenchi duque israelítala epe tsachi ilaichunae. Uyanla ya tenchi fécari sen ilaichunae tinue. Layanla yabe miituchi tito, duque seitonque palaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","In nabe duque tsachilachi tencaca miintsan jochunae tinue. Seque tenca camin jonunca, o seitonque tenca camin jonunca miintsan jochunae tinue. Junsi nuchi tencabinan duque laquiichunae tinue espada polarica cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simeón tsanque pánasa, Diosichi mantate pamin sona manca janue Ana mumun. Yari Fanuélichi nama joto, Aser bolon israelita sona jominue. Junni aman ya Ana duque sinuca jominue. Moso jono mate casalaica jomin joto, aman siete watate yachi unila puyaca jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Junni ya sonari biuda chuminue ochu chunca junpalu wata tano fecári. Diosichi yabi nechi lotuto, quepen, malon Diosichi tenchi ticatiya quito chuminue. Ano fitunca ito, Diosibe rocaito chumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Junni ya Ana Jesúlachica jato, Diosibe acradeseinue. Aman junni Jerusalenbi weyanlari méraminlanue se larimin tsachi Diosi ereca jun jasa. Junni Ana jerale yalabe Jesuca cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Junni Miya Diosi mantacaca jera quetobi, Jesula Galilea toca manjilainue. Yalachi puebloca manjilainue Nasaret tinun puebloca. ");
INSERT INTO cofNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Junni na uwainato, tenca tan sonban uwainue. Diosi yaca laquirato ayudainaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Junni wata cura Jesuchi ayanbe Josebe Jerusalenca lomin jominlanue casá ma fiesta quirabi. ");
INSERT INTO cofNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Junni Jesús chunca palu wata tasa, tsanque lolainue casá ma fiesta quirabi. ");
INSERT INTO cofNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Junni fiesta jerainunbi, Jesuchi ayanbe Josebe manjilainue. Junni Jesús nalalan jotonan manjitunue. Jerusalenbi purainue. Junni yachi ayanbe Josebe man wa bolonbi nenato, tenhitulajonue Jesús itonunca. Yalari amicolabe manjanhinae tito, man malon quiratuto jinilainue. Aman quebi inasa Jesuca neyalaquinanue. Familialachibinan, quiranunlachibinan neyalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Junto Jesuca manfetuto, Jerusaléncanan manjilainue. Jesuca neyade neyade jilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Junto aman peman mate ya náca Diosichi yabi manfelainue. Diosichi fiquica micariminlabe chuto, yala pánaminca meráto, yalabenan manpanhanaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Junni jerale yaca meráminlari wepanalainue. Niyaito na jotonan duque tenca tato seque manpánanunca wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Junni Josebe Maríabe yaca manquirato wepanalainue. Junni yachi ayanni itsantinue: —Nao, ¿ti quichun chiquilaca wepanarinayun? tinue. Chiquebe nuchi apabe nuca wepanato neyanaminlayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Junni Jesús beconan itsantinue: —¿Niyaito nula laca wepanato neyanaminlayun? tinue. Lachi Apachi yabi rano jomanyoe. ¿Junca miitominlayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Junni aman Josebe Maríaberi jun fiquica tuilaitunue Diosica yachi Apa tinanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Junni Jesús yalabe Nasaret puebloca manpatilainue. Junni Jesuri yalabe merán pun na jominue. Yachi ayan mantimini Jesús pacaca pansitunue; tencabi mantenhimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Junni Jesuri tenca tan uwainue. Junni Diosinan tsachilanan yaca sen joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zacaríachi nao Juan tinun niyanlanantiya chutunun postote chumin jominue. Junni junbi chuminca Diosi yachi fiquica pasa tinue. Aman fe mantá tan miya Tiberio César chunca mante wata mantanasa, tsantinue. Aman Tibériochi mantateri manca tobi manca tobi mantaminlari itsanque jominlanue: Aman Judea tobi Poncio Pilato, Galilea tobi Herodes, Iturea tobinan Traconite tobinan yachi aco Felipe, Abilinia tobi Lisanias, yala miyala jominlanue. Junni aman Anásiobe Caifabe fe mantá tan patelelari jominlanue. Aman yala mantalaquinasanan, ya Juan Diosichi fiquica micaribi janue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Junni Juanni Jordán pi quelole jato, tsachilaca micarinaminue. Jutsa quinunca telaquepoto, casan tala tenca mancato mumunhilaide! tinaminue yape Diosi nulachi jutsaca piyarisa. ");
INSERT INTO cofNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Matu mate Diosichi Pila chutemin Isaíaca Diosi itsanque pila chutesa carinue: Tsachi manca niyanlanantiya chutunun postote sonba pato, tsachilaca itsanque payichunaeque chuteca jominue. Miya jano jonun tenchi jera manseilainade! tichunaeque chuteca jominue. Miya jano jonun tenchi minuca mansenun cuwenta, jun tsanquenan nulachi tenca manseilainade! tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jerale delesaca, jera duca, parejo suwan, minu enconca mantuquin, minubi coso jominca mansequin, quinun cuwenta, aman jun tsanquenan tsachilachi tenca manseilaichunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Junsi jeralela Diosichi mantate se lariminca quiralaquichunae tichunae tinue. Aman Diosichi Pilabi tsanque chuteca jominue Juan tsanque micarino jochunaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Junni Juan mumunnasanan, duque tsachila yabe mumunhibi jalainue. Junni yari weyanlaca quirato itsantinue: —Nulari seiton pini cuwenta jolajoe. Diosi tsachilaca paito casticaquinasa, ¿nulari niyaito se loanaeque tenca calaquinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Junni nulachi mumunhino muquilaquinari, casale nulachi jutsaca jera telaquepolaquede! Junsi seque nenalarana! yape nulachi jutsaca tsa telaquepocala joeque quereintsan josa. Junni nulari matu to Abrahanchi alicalayoe; junto Diosichi tsachilayoeque tenca calaquituna! tinue. Diosi nulaca jera telaquepoto, in sucatiya Abrahanchi alica suwano podeichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tsachila chide pele cuwenta jolajochunae tinue. Junni toleno ma faca joe. Junni sen puca itumin peleri tolaito, ninbi queereichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Junni Juan tsantinasa, tsachilari ¿Ti quino jolajowan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan yala tsantinaminlaca meráto, itsantinue: —Aman paluqui camisa tatori, manquica itonlachi cuwantsan joe tinue. Ano tanlanan itonlachi cuwantsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Weyanlari inpuesto calaca camin jominlanue. Junni yalanan mumunhibi pejalaito itsanlatinue: —Chiquilacanan micaride! ¿Niyan jonola jowan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Junni Juan yalaca itsantinue: —Nisi cala casa tica jonari, tsansiri calaquina! Fécari catulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldadolanan ti quino jonunca panhalaquinue. Yalabe itsantinue: —Tarinlaquituna! Sonbaito, nin encanato tarinlaquituna! tinue. Nulachi nisi pacara quica jun calaca cato, son jolajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juan tsanque micarinasa, tsachila wepanato meralaraminue. ¿Ya Diosi ereca jun Cristo tinun tsachi jonhoncan? tito méraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Junni tsanque tenca calaquinasa, Juanni jeralelabe itsantinue: —Te, ya itoyoe tinue. Lari pibiri mumunnayoe tinue. Aman laca benechi manca tsachi jachunae. Yari laca fécari mantá tan jochunae. Yari tsaracari sen jonan, lari yachi sapato silica woleto cuwanotiya sen itoyoe tinue seri sen jotonan. Yari pibiri mumuntumin jochunae; yari Diosichi Tencachi mumunmin jochunae ninchi casinun cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Junni tsachilari trico ni petse pun cuwenta jolajochunae tinue. Junni ya sen tsachi trico petse cuwenta jominlaca jera larito quepochunae. Numa pepe cato rae petse larichun. Junto sen trico nica dunun yaca tanjito sechunae tinue. Petsecari jeraitumin ninbi quepochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aman junto Juan tsachilaca duque payito, sen fiquica micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Junsi miya Heródecanan payinue. Acochi sonaca josoletuntsan joe tica jominue. Junsi jerale uyan quiraque seiton quinun tenchinan yaca seitoe tito payinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Junni Herodes yaca tsanque paca jonun tenchi paito, Juanca donue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aman Juan cadoituminnan tsachilaca mumunnato, Jesúcanan mumunnue. Junni Jesuca mumunquinunsile, Diosibe rocainasanan, yoquido lasainue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Junni Diosichi Tenca palomanan quiran ito pataca josa, jamochi nechi fiqui mera jominue. Itsantinue: —Nuri lachi duque munatinun naoe tinue. Nu tenchi duque son joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús peman chunca wata tsansi tan micaribi janue. Tsachila yaca Josechi nao joe tilatinasa, Elichi alica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliri Matachi nao jominue; Matat Levichi nao jominue; Leví Mélquichi nao jominue; Melqui Jánachi nao jominue. Junsi, junte nechi Jánari Josechi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatíachi nao, Matatías Amochi nao, Amós Nahunchi nao, Nahum Eslichi nao, Esli Nágaichi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maátichi nao, Maat Matatíachi nao, Matatías Semeichi nao, Semei Josechi nao, José Judachi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joánachi nao, Joana Résachi nao, Resa Zorobabélichi nao, Zorobabel Salatiélichi nao, Salatiel Nérichi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Mélquichi nao, Melqui Adichi nao, Adi Cosanchi nao, Cosam Elmodachi nao, Elmodam Erichi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josuechi nao, Josué Eliezérichi nao, Eliezer Jorinchi nao, Jorim Matachi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Levichi nao, Leví Simeonchi nao, Simeón Judachi nao, Judá Josechi nao, José Jonanchi nao, Jonán Eliaquinchi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Meléachi nao, Melea Mainanchi nao, Mainán Matátachi nao, Matata Natanchi nao jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Junni Natanni miya Davichi nao jominue. Ya Daviri Isaíchi nao jominue. Junte nechi Isaí Obechi nao, Obed Boochi nao, Booz Salmonchi nao, Salmón Naasonchi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadachi nao, Aminadab Aranchi nao, Aram Esronchi nao, Esrom Fárechi nao, Fares Judachi nao jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aman ya Judari Jacóbochi nao jominue; junsi Jacóbori Isaachi nao jominue; junsi Isaari Abrahanchi nao jominue; junsi Abrahanni Tarechi nao jominue. Junte nechi Taré Nacórichi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Seruchi nao, Serug Ragauchi nao, Ragau Pelechi nao, Peleg Hebérichi nao, Heber Sálachi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainanchi nao, Cainán Arfaxachi nao, Arfaxad Sémichi nao, Sem Noechi nao, Noé Lamechi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalenchi nao, Matusalén Enochi nao, Enoc Jarechi nao, Jared Mahalaleélichi nao, Mahalaleel Cainanchi nao, ");
INSERT INTO cofNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enochi nao, Enós Sétichi nao jominlanue. Aman Set Adanchi nao jominue. Junsi Adanni Diosi quica jun jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Junni Diosichi Tenca Jesuchi tencabi sele wica josa, Jesús Jordán pite nechi manjanue. Junni junte nechi manjacabi, Diosichi Tenca yaca niyanlanantiya chutunun postoca erenue. Junni junbi junpalu chunca ma fecári yucan yaca jutsa quisa carichique tenfenue. Ya junpalu chunca ma fecári ano fitunca ito chununbi, duque ano muquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Junni yucan yabe itsantinue: —Nu Diosichi Nao jotori, in suca bibu suwade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesunan itsantinue: —Te, Diosichi Pilabi itsanque chuteca joe: Tsachila anobesiri sonnano itolajoyoe; jera Diosichi fiquica meráto sonnano jolajoyoeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Junni yucan yaca wa du puntabi wirucarinue. Junbi wiruito jerale toca moora quirawonue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Junca quirawoto itsantinue: —Quirade! tinue. ¿To cura miyala duque mantá tan jolajotun? tinue. Junni to cura mantaca lachi cuwaca joe. Lachi tenca munate jerale tobi miya suwamin joyoe. Mocatiya suwano muquinari, suwaniquimin joyoe tinue. Junni lachi nuca jerale toca mantasa carino muquee. ");
INSERT INTO cofNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lachi cale telenhito se tinari, nuca jeraleca mantasa cariyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Junni yucan tsantinunsi Jesunan itsantinue: —Yucan, we jachi manjide! Diosichi Pilabi itsanque chuteca joe: Miya Diosichi calesiri telenhintsan joe; yabesiri mantaino joeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Junni Jesús tsantinunbi, yucanni yaca Jerusalén puebloca tanjito, Diosichi ya butuchi wirucarito, itsantinue: —Nu Diosichi Nao jotori inte nechi supatiniide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diosichi Pilabi itsanque chuteca joe tinue: Anjelilaca erechunae yape nuca cuidailaisa. ");
INSERT INTO cofNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nuca amanle canilaquichunaeque chuteca joe yape nuchi nede subi icatusa. ");
INSERT INTO cofNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aman Jesunan itsantinue: —Man fiquinan chuteca joe: Seiton quinasatiya laca cuidainiichunae titulajonaque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Junni yucan jutsa quisa carichique tenfeto, yaca wan fecári telaquepoto manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Junni Jesús Galilea toca manjinue Diosichi Tencabe mantaimin joto. Junni jerale jun tobi chuminlari Jesuca jera meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Junni israelítala tala Diosichi fiqui miinun yabi Jesús micarinaminca duque se joe tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Junni Jesuri ya uwainun puebloca manjinue Nasaret tinun puebloca. Yachi mite jasaino mate Diosichi fiqui miinun yabi wimin jominue. Junto jun jasaino matenan junbi winue. Aman junni matute Diosichi mantate pamin tsachi jominue Isaías mumun. Yari Diosichi Pila chutemin jominue. Junni Jesús jun miinun yabi winunbi, Isaías chuteca jun pilaca Jesuchi cuwalaquinue yape quirasa. Junni pila quirachun wiruito, pilaca woleto, itsanque pila chuteca jun postoca féto, quiranue: ");
INSERT INTO cofNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tsachi manca Miya Diosichi Tenca labe joe tichunaeque chuteca joe. Ya tsachica Diosi mantá tan suwachunae yape poperelaca sen fiqui micarisa. Diosi yaca erechunae yape tencabi laqui junlaca pansi josa carisa. Doraminlaca manlonola joe tisa erechunae. Quirano podeitonlaca manquiranola joe tisa erechunae. Seitonlabe padeseinaminlaca telasa carisa erechunae. ");
INSERT INTO cofNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Miya Diosi tsachilabe sen jono ma joeque micarisa erechunaeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Junni Jesús Diosichi Pilaca tsanque quiratobi, pilaquidoca mantiwito, junbi cuidaiminchi mancuwato, manchudinue. Junni Diosichi fiqui miinun yabi chuminla jeralela Jesuca wepanato meráto quiranaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsanlajosanan yalabe itsantinue: —Diosichi Pilabi matu mate chuteca junca la tsaina quirayoe. Aman jun pilabi tsanchunae tica josa, amana mate labe jun tsanquenan patinae. Nulaca micarinato, tsanque Diosi ereca jun jato micarinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Junni Jesús tsantinasa, jeralela se tilatinue. Juntonan wepanalainue ¿Niyaito tsancari sen fiqui pamin jun? tito. Wepanato itsanlatinue: —¿Inni Josechi naori jotun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aman Jesús yalabe itsantinue: —La Capernaum pueblobi ticatiya seque wepanato quirantsancari quinunca nula meracala jonhoe. Junni jun pueblobi tsannueque meráto, ¿Intenan tencachique tótenan jun tsannan quede! tilatichunaco? tinue. Junni doctorila cuwenta jochunae. Doctorila tencachique janpeino podeitunari, niyanlanantiya janpeibi jilaituchunae. Jun tsanquenan la inte wepanato quirantsancari quitunari, ¿Niyaito laca quereintsan jochunan? tilatichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tsantisi, Jesús itsantinue: —La nulabe tsarasica pachinayoe tinue: Diosichi mantate paminlaca tiletiya meralaquichunae. Juntonan yalachi pueblobiri yalaca natiya merátuchi latichunae. Junni inte lachi pueblo joe. Jun tenchi nulari laca meralaquituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","La tsarasica pánayoe tinue. Matu to Elíaca mantenhilaide! Ya sonnano mate peman wata man quitsa fecári suwa quitunan, jerale tote ano itonan padeseinaminlanue. Tsanque padeseilainasa, Diosi Elíaca erenue yape biuda mancaca ayudaisa. Junni Elíachi tobinan duque biudala chuminlanue. Uyan tobinan biuda chuminue Sarepta pueblobi, Sidón quelote. Junni Elías israelita josanan, Diosi yaca israelita tobi chuminlachica eretunue. Uyan tobi chumin biudachica erenue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","O manca Diosichi mantate pamin israelítaca tenca calaquede! ya matu to Eliseo tinunca. Eliséochi tobi duque tsachila lepra bichi chun jominlanue. Siria tobinan lepra bichi chun tsachi jominue Naamán tinun. Junni Eliseo tencachique tobi chuminlaca manse suwatuto, uyan tobi chumincari manse suwanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesús Diosichi fiqui miinun yabi layaica junlabe tsantinue. Junni jeralela jun fiquica meráto, duque pailainue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aman paito wiruito, Jesuca cato, pueblo dechi tanjilainue. Aman junni jun pueblori du jamobi jominue. Junsi wa minu tanjilainue jun wabi nechi tulipochique. ");
INSERT INTO cofNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús mantimini yalachisenan poleto manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Junni Jesús Capernaum puebloca manpatinue Galilea tobi. Junni junbi jasaino mate micarinaminca quirato, ");
INSERT INTO cofNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tsachila yachi fiquica wepanalainue duque mantabe micarimin joeque tenhito. ");
INSERT INTO cofNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Junni Diosichi fiqui miinun yabi layailainasa, yucanchi oco wica jun tsachi manca pewica jominue. Junni yucanchi oco Jesuca sonba pato itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús Nasareno, ¿chiquilaca ti quebi jacayun? ¿Nuri chiquilaca yucapiyaribi jacayun? tinue. Nucari mirayoe. Nuri Diosi ereca jun tsara sen tsachi joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Junni Jesuri yucanchi oco pánaminca pato, yaca nosasa ide! tinue. In tsachichibi nechi manlode! tinue. Junni yucanchi oco ya tsachica jeralelachi quitsabi queereisa carito, yachibi nechi manlonue. Jun tsachica natiya fuda suwatuminnan lonue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Junni tsanhinaminca quiranaminla mantimini junca duque wepanato, beco beco itsanticaalaquinue: —Ticatiya tsaracari mantamin joe tinue. Yucanchi ocolacanan mantánan, yalanan manlominla joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Junni jun tobi jeralete yaca mera jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Junni Jesús Diosichi fiqui miinun yabi nechi loto, Simón Pédrochica jito tamochi winue. Aman junni Simonchi sonachi ayan wa cupara tan tsominue. Junni junca Jesube rocailainue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Junni ya sona tsonun quelole wiruito, cuparaca mantanue manpolesa. Tsantinasale cupara manpolenue. Junni cupara manpolenunsi cupato, junte raminlachi ano manpoto cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Junni aman yo winunsi, jerale quiyanpunlachi amicola, o familiala, ya quiyanpunlaca Jesúchica tanjalainue yape manse suwasa. Junni jeralelaca tedechi tale quito manse suwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yucanchi ocolacanan tsachilachibi nechi mansularinue. Yucanchi ocolari miraminlanue Jesús Diosi wenteca jun Cristo tinun tsachi joeque. Junto tsachilachibi nechi lochinato, Jesuca sonba pato, nu Diosichi Nao joe timin jominlanue. Junni Jesús mantimini yalaca nosasa ilaide! timin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aman ayuna nanchi nemeneme Jesús niyanlanantiya chutunun postoca jinue. Junni tsachilari yaca neyato manfeto, yalachite nechi jitusa tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ya mantimini yalabe itsantinue: —Uyan pueblo cura jito, junbinan sen fiquica micarino joyoe tinue Diosi mantananun tsachi bolonbi pewintsan joeque. Jun tenchi ereca jun jacayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Junto Diosichi fiqui miinun ya cura micaride nenaminue Galilea tobi. ");
INSERT INTO cofNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Man mate Jesús Galilea wa pipilu pi fiquite wirurato, tsachilaca Diosichi fiquica micarinaminue. Junni tsachila Jesuca dilaque talulu inato meralaquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Junni Jesús paluca wa canoaca quiranue. Ya watsa caminla canoabi nechi loto, dadaca tsalenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Junni aman ya manca canoari Simonchi jominue. Junni Jesuri junbi wito, pibi nasi eresa carinue. Junto aman canoabi chudito, tsachilaca micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aman jera micarisi, Simonbe itsantinue: —Wapunbi jito, dada quepode! tinue watsa cachun. ");
INSERT INTO cofNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Junni Simonnan itsantinue: —Miya, man quepen dada queponatonan, manca watsanantiya catulajoyoe tinue. Tsannan nu dadaca manquepode! tinari, manan manqueponiquechinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Junto dadaca manquepoto, tsaracari duque watsa calaquinue. Junni watsa jadochi dada chijinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aman manca canoabinan watsa caminla chuminlanue. Junni tede quirawoto, jade! jade! quilaquinue ayudaisa. Junni yalari junchi jito, paluca canoabi watsa tuwale pocalaquinue. Duque watsa ponan, canoa menawinono tinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Junni Simón Pedro mantimini tsaracari duque watsa cayaicaca quirato, duque wepananue. Junsi Zebedéochi paluca naolanan wepanalainue Jacóbobe Juánbenan. Yalanan Simonbe watsa pecamin jominlanue. Jerale Pédrobe pejominlanan duque watsa cayaicaca quirato, wepanalainue. Junni Pedro Jesuchi cale telenhito, itsantinue: —Miya, la duque jutsa pun tsachi joyoe tinue. Junni lachite nechi joqueide! tinue. Junni Jesús yabe itsantinue: —Jeleratude! Nu amanale nechi watsa camin itochunae; amanale nechiri tsachilaca labe cayaisa carimin jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Junni tsantinunsileri, yalari canoaca butuchi mantanloto tsoreto, jera purato, Jesube penenabi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Junni Jesús manca pueblobi nenasanan, duque lepra bichi chun tsachi manca janue. Jesuca quirato, yachi cale tobi mutsaito itsantinue: —Miya, laca nuchi manse suwano muquinari, manse suwano podeichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús junca meráto, tedechi tale quito, itsantinue: —Munarato, nuca tsaina manse suwanayoe tinue. Junni Jesús tsantinunsileri, lepra bichi jera manseinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aman Jesús yaca manse suwasi itsantinue: —Meráde! Mobenantiya patuminnan patelechica jito, Diosichi ticatiya nasi epe cuwade! tinue. Aman matu to Moisés Diosichi Pilabi mantaca jominue lepra bichi manseiminla Diosichi tíca cuwanola jonunca. Junni Jesús junca cuwasa mantanue yape jeralela miralarasa ya manseica joeque. ");
INSERT INTO cofNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Junni aman nosa jona! tica josanan, Jesuca nantanan fécari mera jominue jun tobi. Junni tsachila duque layainaminlanue Jesuca merán, quiyan mansein, ichique. ");
INSERT INTO cofNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Junni Jesús mantimini tsachilaca purato, mancasiri loto jimin jominue Diosibe rocaibi. ");
INSERT INTO cofNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aman man bolon israelítala man tala Diosica tenca caminlaca fariseo tinun jominlanue. Junni aman man nete Jesús micarinasa, fariséolabe israelítala tala mantaca micariminlabe peraminlanue. Weyanla Jerusalén pueblobi nechi jaca jominlanue; weyanla Galilea tobi nechi, Judea tobi nechi jaca jominlanue jerale pueblobi nechi jato. Junnasa Jesús Miya Diosichi sonbabe quiyanpunlaca manse suwanaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Junni tsachila wecaino podeiton tsachi mancaca tanjalainue jali cuyanbi poto nanato. Jesuchi cale tsorebi tamochi wichi tito, ");
INSERT INTO cofNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","podeilaitunue tsachila quidi jonun tenchi. Junto terasabi loto, baldosaca nasi foroto, jun forose quiyanpun jali cuyanbi punca patarilaquinue Jesuchi cale. ");
INSERT INTO cofNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aman Jesuri yaca tennaminla jonunca miito, ya quiyanpunbe itsantinue: —Amico, nuchi jutsaca piyarinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Junni Jesús tsantinasa, israelítala tala mantaca micariminlabe fariséolabe meralaquinue. Junni yala Jesuca meráto pailainue Diosica seitonque pánae tito. Diosisiri jutsaca piyarino podeimin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Junni Jesús yala tsanque nosa pánanunca miito, itsantinue: —¿Nulari niya jonan tsanlatinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿La quiyanpunchi jutsaca piyarinayoe tituan? tinue. Tsanque pacachi panori layan tenfe itoe. Juntonan ya quiyanpunca mancupato mannenasa carino, ya fe tenfe jochunae. La mantimini palu cosacanan quino podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","La tsachi ica jun joto in tote jutsaca piyarinonan mantá tan joyoe. Yape mantá tan jonunca miilaisa, fe tenfe jonuncanan quechinayoe tinue. Junsi mantaca micariminlabe tsantisi, quiyanpunca itsantinue: —La nuca mancupade! tinayoe tinue. Jalica mancato, yaca manjide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jesús tsantinunsi, piyanle tsachila quiralaquinasanan, quiyanpun jomin tsachiri mancupato, jalica mancato, Diosica duque seque pade manjinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Junni jerale tsachila duque wepanato quirato, Diosica duque sen joe latinue. Yaca jele tito, amana wepanato quirantsancari quinanunca quiralaquinayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Junni israelita tsachi manca jominue Leví mumun. Yari uyan to miyachi tenchi inpuesto cala camin joto, inpuesto canun postote chuminue. Aman Jesús jancanca manse suwato, junbi nechi manloto, Levica quirato, yabe penenamin ide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Junni Leví wiruito jera purato Jesube penenabi pejinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Junto Leviri yachibi wa fiesta Jesuchi tenchi quinasa, duque israelítala ano pefibi jaca jominlanue. Weyanla inpuesto camin jominlanue Leví cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aman ano filaquinasanan, israelítala tala mantá micariminlabe fariséolabe yalaca quiranaminlanue. Junni Jesube penenaminlachica jato, paito itsanlatinue: —¿Nulari niyaito in seiton quiminlabe ano pefilaquinayun? tilatinue. Israelítalachi mantaca tennatuminla joe. Weyanlari ti quiran uyan to miyachi tenchi chiquilaca inpuesto cala caminla joe tilatinue. ¿Niyaito nulari tsan quira seiton tsachilabe ano pefilaquinayun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús junca meráto, yalabe itsantinue: —Quiyanpun itonlari doctorilaca munaralaratuchunae tinue. Quiyanpunlari doctorilaca munaralarachunae. Junni la doctor cuwenta joyoe. ");
INSERT INTO cofNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sen jolajoyoe timinlachi tenchi jatucayoe; jutsa quiminlachi tenchi jacayoe tinue yape jutsa quinunca telaquepoto casan tala tenca mancalaquisa. Jesús ya fariséolabe mantaca micariminlabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Junni weyan tsachila Jesube itsantilatinue: —Mumunmin Juanbe penenaminla israelítalachi mi tala nenato, duque ne Diosibe rocaichun ano fitunca iminla joe latinue. Fariséolabe penenaminlanan jun tsannan iminlae tilatinue. Aman nube penenaminla mantimini ano ticatiya finiquiminla joe. ¿Niyaito tsanquiminla jun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús junca meráto, beconan itsantinue: —Lari casalainamin cuwenta joyoe tinue. Junni casalainanun fiesta quirabi jaminlaca wari ano fitunca isa carituntsan joe casalainamin tsachi yalabe peaconpanainasa. Jun tenchi lari lachi tsachilabe penenasanan, yalaca ano fitunca isa carituntsan joe. ");
INSERT INTO cofNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Junni manca mate mantimini la itoanae tinue. Laca josolelaquichunae. Aman junnunbi labe penenaminlari weyan mate ano fitunca ilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús tsantisi, man fiquiman itsanque micarinue: —O la micarinunca yape fe tuca miilaisa, manca cuenta quechinayoe tinue lachi casan fiqui casan panu cuwenta jochunaeque. Aman unica panu foron jonari, casan panuca porecato orotuntsan jochunae tinue. Aman junni tenca iton tsachiri casan panu porecato oroquiniquinari, casan panu chijito yucapiyachunae. Unica panucanan se quiratuntsan ichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Junsi binocaman tenca calaquede! tinue. Aman lachi casan fiqui casan bino cuwenta jochunae tinue. ¿Chibo quidoca tolo quito bino pomanco? Aman ya tolo unica jonari, junbi casan binoca potuntsan jochunae tinue. Aman tenca iton tsachiri poniquinari, junni bino sonba pi isiri toloca chilechunae. Junto bino fojinan, tolonan yucapiyachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jun tenchi casan binoca casan tolobi pontsan jochunae yape palunan sen josa. Jun tsanquenan la casan micaricaca meráto nenaminla matu micaricaca tennatuntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Matu mite nenaminla mantimini casan mantate nenatuchi latichunae. Bino cuchiminla cuwenta jolajochunae. Unica bino cuchiminlari casan bino cuchituchi latichunae unica fe sen joe tito. ");
INSERT INTO cofNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Junni manca jasaino mate Jesula witase poleto jinaminlanue. Junni aman yabe penenaminlari tricoca nasi balecato, tedechi quidoca lachito, fidede polenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Junni fariséolari yala tsannaminlaca quirasi, itsanlatinue: —Jasaino mate trabajaquino itoe. Tsan josanan nulari tricoca balecato lachilaquinae. ¿Niyaito mantaca merátuto tsanlaquinayun? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Junni Jesuri yala tsantinaminca meráto itsantinue: —Meralaquede! Matu to miya Davica pila chutecaca mantenhilaide! Davibe yachi tsachilabe epe tsachila fitunun bibuca finilaquinue. Mantá jominue patelelasiri ya bibuca filaquisa. Tsan josanan ano mochi pasainato, Daviri Diosichi yabi wito, patele itotonan Diosichi cuwaca jun bibuca cato fito, yachi amicolachinan cuwaniquinue tinue yape filaquisa. Junni Davila tsanquicala josanan, nula yalaca culpa quituminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Junni Jesús fariséolabe itsannan tinue: —La tsachi ica jun joto jasaino matenan titiya quino mantá tanirayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Manca jasaino mate Jesús Diosichi fiqui miinun yabi wito micarinaminue. Junni micarinasa, tsachi manca tsa tede encon chunue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Junni israelítala tala mantaca micariminlabe fariséolabe Jesuca quiranaminlanue manse suwachunanque quirachun. Yaca manse suwanari, Jesuca culpa patarino jominlanue jasaino mate trabajaquimin joe tito. ");
INSERT INTO cofNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Junni Jesuri yala tenca calaquinanunca miito, tede encon tsachibe pato, Cupato, intele quitsale wiruide! tinue. Junni yari jasi, junte wiruinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Junni Jesús yaca culpa quichi timinlabe itsantinue: —Nulabe panhachinayoe tinue. ¿Diosichi Pilabi niyaque mantaca jun? tinue. ¿Jasaino mate ti quino jun? ¿Se quino jun, o seiton quino jun? ¿Quiyanpunlaca manse suwano jun, o puyasa quiraniquino jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsantisi Jesús jeralelaca quirato, tede encon tsachibe itsantinue: —Tedeca mantuquede! tinue. Junni tedeca mantuquesi manseinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Junni Jesuca culpa quichi timinla wari junca quirato, duque paito tenpalaquinue Jesuca niyan quintsan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jun malate Jesús du minu loto, man quepen Diosibe rocainaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Junni tseinunbi, yabe penenaminlaca oticato, chunca palucaca wentenue. Junni yalaca mantá tan suwanue yape yachi mantá tan nenalarasa. ");
INSERT INTO cofNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Itsanque mumun jominlanue: Casaleri Simonbe yachi aco Andrebe jominlanue. Aman Simonca Jesuri tensaato mumun poto, Pedro tinue. Junte nechi Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO cofNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás jominlanue. Junsi manca Jacobo jominue Alféochi nao. Junte nechi manca Simón jominue. Yari zelote bolonbi pejomin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Junte nechi manca, Jacóbochi aco Judas jominue. Junsi manca Judas jominue ya Judas Iscariote. Yari nanni ina Jesuca pa jominlachi cuwapono jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aman Jesús dubi nechi manpatanaminnan, jun du quitsate contile wiruinue. Junte wirurasa duque tsachila yachica jalainue. Weyanlari yabe penenamin jominlanue. Junni weyanlari Judea tobi nechi, weyanla Jerusalén pueblobi nechi, weyanla Tiro pueblobi nechi, Sidón pueblobi nechi jalainue. Ya Tírobe Sidonbe nuwiri jominue lamari quelobi. Junni yalaca manse suwan, micarin, quisa jalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yucanchi ocola pasuwanaca junlanan manseilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Junni ya tsaracari seque manse suwamin jonan, duque tsachila dilai talulu layailainue yaca taquirachique. Tsanhilainato jeralela manseinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Junni Jesús yabe penenaminlaca quirato itsantinue: —Poperelanan son tinola joe tinue. Nula Diosi mantananun tsachi bolonbi pejolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Junsi amana mate ano fino itonlanan son tinola joe. Diosi nulachi michi cuwachunae. Junsi amana mate wareminlanan son tinola joe tinue. Diosi nulaca cacarisa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Junsi paito telaquepoca junlanan son tinola joe tinue. Tsachila nulaca pansile yucacurato, seitonque nene palaquichunae la tsachi ica junbe penenaminla jonun tenchi. Tsanlaquinari, nula son tinola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Matu tote Diosichi mantate paminlaca jun tsanquenan padeseisa carilaquinue tinue. Junni nulanan yala cuwenta patitori, pansi joto duque son tilatina! tinue. Aman nulari in tote lachi tenchi padeseinari, Diosi jamochi nulachi tsaracari senca cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Junni Jesús tsantisi, man fiquinan panue: —Oco junlanan laqui jonola joe tinue. Nula laqui itochun duque cosalaca caya jolajoe. Junni junca tatobi laqui manhilaitori, niyaquenantiya laqui polarino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Junsi duque ano tanirayoe timinlanan laqui jonola joe tinue. Aman manca mate nulachinan ano falta jochunae tinue. Junsi pansi chuto cacariminlanan laqui jonola joe. Aman manca mate nulanan laquichi warelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Junsi jeralela nulaca se tilatinari, wepanato nenanola joe tinue. Matu tote sonnaminlanan Diosichi mantaca tayoeque nene paminlacanan jun tsanquenan se timin jominlanue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Junto Jesús itsanque micarinue: —Aman laca meráminlabe itsantichinayoe tinue: Nulaca paiminlaca laquiralarana! tinue. Aman pa jominlabe sen jolajona! ");
INSERT INTO cofNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Junsi nulaca yucaquilaquinari, o yucacuralaquinari, yalachi tenchi Diosibe rocailaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Caforobi man nanchi quinari, man nanchinan quirawolaquina! yape man nanchinan quiniquisa. Junni nulachi sacoca josoleto, camisacanan cachi latinari, quiranilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aman jerale panhaminlachi cuwalaquina! Ticatiya josolecaca manpanhatulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Junni uyanla nulabe niyaquetiya sen jolajosa tenjanari, nulanan yalabe jun tsanquenan sen jolajona! ");
INSERT INTO cofNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nulaca laquiraminlacasiri laquiralaranari, Diosi nulaca sen joe tituchunae tinue. Tsanque beco manlaquiraminla epe laquiralarachunae tinue. Jutsa quiminlanan yalaca laquiranari, beconan laquiralarachunae. ");
INSERT INTO cofNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Junsi nulaca se quiminlacasiri se quilaquinari, Diosi nulaca sen jolajoe tituchunae. Jutsa quiminlanan seiton jotonan, beconan se quiminlae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Junsi mancuwano junlachisiri faricarilaquinari, Diosi nulaca sen jolajoe tituchunae. Jutsa quiminla talanan faricariniquiminlae jun tsansinan mancano joto. ");
INSERT INTO cofNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nulari uyan quiraque nenanola joe. Nulaca paiminlacanan laquiralarana! tinue. Seque quilaquina! Faricarilaquina! Mancatuchun tenca faricarilaquina! tinue. Diosi jun tsannan quimin joe. Aman acradeseituminlabenan, isapunlabenan Diosi tsanquenan sen joe. Junni nula ticatiya tsanquito nenatori, jamochi chumin Diosichi nalala jolajochunae tinue. Ticatiya tsanquito nenanari, Diosi nulachi tsaracari senca cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Junni nulachi Apa Diosi laquiramin cuwenta, nulanan laquiralarana! tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Junto Jesús man fiquinan micarito itsantinue: —Uyanlaca culpa quitunari, Diosi nulacanan culpa quituchunae tinue. Uyanlaca perdonainari, Diosi nulacanan perdonaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uyanlachi niyaquetiya cuwalaquinari, Diosi nulachinan jun tsanquenan mancuwachunae tinue. Cajosale cuwanari, Diosi jun tsanquenan nulachinan cajosalenan cuwachunae tinue. Seque cuwanari, Diosi nulachinan sequenan mancuwachunae tinue. Tunle poto, sitan, sele mito, fécari nulachi cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Junto Jesús itsanque cuenta quinue: —Tsachi manca quirano podeitutonan, manca quirano podeitonca minu micuwachi titori, palunan forochi queereilaichunae tinue. Tenca itonque payiminla jun tsachila cuwenta jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nulari labe miiminla joto, laca fe itolajochunae. Nula jeralela jera miitobi, la cuwenta tenca sen jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","O cacabi wica jun chide petse nacaca tenca calaquede! tinue. Jutsari jun chide petse nacá cuwenta jochunae. Junni tsanini chide petse nacaca uyanchi cacabi wicaca nula quiranilaquichunae. Juntonan tencachique cacabi fe wa chide petse pomincari natiya tenhituminla jochunae. Ya seitoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tencachique cacabi wa chide petse posanan, uyanlachi cacabi nechi tsanini chide petse nacacari larito cuwachinayoe latichunae tinue. Jun tsanquenan nulari uyanlaca fe seiton jotonan, uyanlaca seque nenasa payinola joyoe timinla joe tinue. Tsantituntsan joe. Casaleri nula tencachique wa chide petse tsan jutsaca larinola jochunae. Junsi aman seque quirano podeilaichunae uyanlachi na chide petse tsan jutsa tenchi payichun. ");
INSERT INTO cofNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús tsantisi, camicarinato itsantinue: —Sen chide pelebiri seiton puca itumanhe. Yucapiyaca chide pelebiri sen puca itumanhe. ");
INSERT INTO cofNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Junni aman pucaca quirato ti chide pelebi tsan puca imin jonunca miintsan joe tinue. Uba puca caran tapebi itumanhe. O ico pucanan pobi itumanhe. ");
INSERT INTO cofNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Junni tsachilanan jun puca pele cuwenta jolajoe. Aman sen tenca tanlari seque paminla jochunae tinue. Seiton tenca tanlari seitonque paminla jochunae tinue. Jun tenca canunca fiqui foro pamin joe. ");
INSERT INTO cofNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Junsi Jesús itsantinue: —Nulari laca Miya joe tinatonan, merátuminlae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Junni nulaca micarichinayoe laca seque meráminlari niyanla jonunca. La mantananunca seque meráminlari ");
INSERT INTO cofNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","wa subi ya quimin tsachi cuwenta jolajochunae tinue. Tenpe toca towato, subi ya quichunae tinue. Junni duque pilu fanasa, jun yaca pi quechutainasa, natiya yucapiyatuchunae tinue. Subi ya quica jonan pi tanjituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Juntonan la mantananunca jamoleri meráto seque merátuminlari tobi ya quimin tsachi cuwenta jolajochunae tinue. Te, natiya toca towatuto, tobiri ya quichunae. Aman pilu fato, jun yaca pi quechutainato, moorasiri tanjichunae tinue. Jun yari jera yucapiyato arajiniichunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús tsachilaca jera micaritobi, Capernaum pueblobi winue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Junni aman uyan to capitanchi peyun uran tsominue puyachun. Ya tsachiri duque laquitinun peyun jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Junni capitanni Jesuca meráto, mantá tan israelítalaca erenue yape Jesube rocailaisa yachi peyunca manse suwabi jasa. ");
INSERT INTO cofNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Junni ya mantá tan unicalari Jesúchica jato, duque rocaito itsanlatinue: —Nu capitanchica jiniide! Yari sen tsachi jonan, yaca ayudaintsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Israelita itotonan, israelítalaca duque laquiramin joe. Yachi calachiri chiquilachi tenchi Diosichi fiqui miinun ya quisa caricae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsantinan, Jesús yalabe pejinue. Junni aman capitanchi ya quelo fenasa, capitanni yachi amicolaca erenue yape Jesúlabe tulaibi jilaisa. Junni capitan ereca jun tsachila jalaito, Jesube itsanlatinue: —Miya, capitanni itsanque fiqui eree latinue. Te, jatusa tie latinue. Nuri capitanca fécari sen joto, yachibi jatusa tie latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Junni nuca tulaibi jitiyoe tie latinue seiton joyoe tito. Junni yachica jituminnan, inte nechi mantaquiniquisa tie. Inte nechiri quiyanpunca manseisa mantanari, manseichunae tie latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jana soldadola tala mantanun cuwenta jochunae tie latinue. Coroneli ya capitanca mantamin joe. Ya capitan mantimini soldadolaca mantamin joe. Jisa mantanari, jiniiminlae; o jasa mantanari, janiiminlae. O yachi peyunca titiya quisa tinari, tsanquiniquimin joe latinue. Junni nunan jun tsanquenan quiyanpunca manseide! tinari, manseichunae tie latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Junni capitan tsantinunca wepanato meráto, Jesuri yabe pejaca junlabe itsantinue: —Meralaquinade! tinue. Ya capitan israelita itotonan, israelítalaca fécari Diosica tennamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Junni capitan ereca junla manfanasari, ya quiyanpun peyunni numa manseica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Junni nanni ina Jesús manca puebloca jinue Naín tinunca. Yabe penenaminlabe, junsi layan uyan tsachilabe pejinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jun pueblobi wilaichinasa, puyacaca menabi tanjinaminlanue. Ya puyacachi ayan biuda jominue. Ya tsachiri yachi mancari nao jominue. Junni jun pueblobi chuminla layanla yaca menabi pejinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Junni Miya Jesuri yaca quirato, laqui tito, waretude! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Junni aman Jesús quelo féto, puyaca ponun cajonca taquiranue. Tsanquinasa, nanato tanjinaminla wiruilainue. Junni puyaca mosoca Jesús itsantinue: —Mansonhide! tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Junni Jesús tsantinan, puyaca jomin tsachi manchudito cuenta quinue. Junni yachi ayanchi mancuwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jerale tsachila junca quiraminla jele tito, Diosica duque se tito itsanlatinue: —Diosichi mantate tsarasi pamin tsachi chiquilachica jaca joe latinue. Diosi yachi tsachilaca ayudainae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Junni jerale Judea tobi, uyan quelole totenan tsanque mera jominue Jesús duque wepanato quirantsancari quinanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Junni Mumunmin Juanchi tsachila Juanbe jera cuenta polarilaquinue Jesús niyan quinanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Junni Juan doramin joto, junca meráto, yachi tsachila palucaca jasa carito, yalaca Jesúchica erenue. Junni yalaca erechinato, yalabe itsantinue: —Jesube itsanlatina! tinue. ¿Nu Diosi ereno jomin tsachi joyun? tilatina! tinue. Nu itotori, paniquede! tilatina! tinue uyanca meralarachun. ");
INSERT INTO cofNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Junni ya paluca tsachila Jesúchica jato itsanlatinue: —Mumunmin Juan ereca jun jalaiyoe latinue. Yari nuca miichi tinae. ¿Nu Diosi ereno jomin tsachi joyun? latinue. Junni nu itotori, paniquisa tie latinue uyanca meralarachun. Mumunmin Juan tsanque fiqui eree latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Junnasari Jesús duque quiyanpunlaca jera manse suwanue. Yucanchi ocola tsachilachibi pominlaca mansularinue. Aman quirano podeitonlaca manquirano podeisa carinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Junto aman Juanchi tsachilabe itsantinue: —La ticatiya quinanunca nula quiralaquinae tinue. Junto tenca calaquede! Quirano podeitonlaca, jancanlaca, lepra bichi chunlaca, meráno podeitonlaca mansenayoe. Poperelaca Diosichi sen fiquica micarinayoe. Junni nulari junca jera quirato, aman Juánchibi manfeto yabe jera cuenta quilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Junni Juanbe junca cuenta quito itsanlatina! tinue. Laca tennanoca peleituna! tinae tilatina! tinue. Laca palaque tenca catuminla pansi jolajochunae tinae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jesús tsantinunbi Mumunmin Juan ereca junla manjilainue. Junni manjilainunbi, Jesuri uyan duque tsachilabe Mumunmin Juanca itsantinue: —¿Nulari niyanlanantiya chutunun posto minu Juanca quirabi jilaico? tinue. Junni aman yaca quirabi jinato, ¿niyaque tenca canaminlayun? ¿Juanca ti tsachi joeque tenca canaminlayun? tinue. ¿Cumana tenca jonhoe tinato jilaiyun? Te, Juanni cumana tenca tsachi natiya itoe. ");
INSERT INTO cofNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Junni ti tsachi jonhoe tinaminlayun? ¿Tsara uraran camisa pomin oco tsachi jonhoe tinaminlayun? Te, tsan itoe. Otoquin camisaca poto senbi oco tala chuminlari miyalachibiri chuminla joe; niyanlanantiya chutunun postobi chutuminlae. ");
INSERT INTO cofNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Junni Juanca quirabi jito, ¿ti tsachi jonhoe tinaminlayun? ¿Diosichi mantate pamin tsachi jonhoe tinato jilaiyun? Janhan. Diosichi mantate pamin joe. Ya Juanni Diosichi mantate tsaracari seque pamin joe. ");
INSERT INTO cofNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Matu mate Diosi yachi pilabi Juanca panue yaca ereno joyoeque. Lari lachi fiquica paminca Crístochi caquele ereno joyoe tinue yape yachi tenchi jera se suwanasa. ");
INSERT INTO cofNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Junni meralaquinade! tinue. Diosichi mantate paminla tala monantiya Juanca fe itominue. Tsan josanan, amana mate Diosi casanle nechi mantananun bolon tsachilari Juanca fe jolajoe. Yala tala fécari epe tsachilanan Juanca fe jolajoe tinue. Jesús Juanca tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Junni aman epe israelítala Juanbe mumunhica jominlanue. Inpuesto cala caminlanan Juanbe mumunhica jominlanue. Junto Jesús Juanca tsanque cuenta quinasa, ya tsachilari Diosica se joe tinaminlanue Juanca erenun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mantá tan israelítala mantimini Juanbe mumunhilaitunue. Fariséolabe israelítala tala mantaca duque miraminlabe yabe mumunhituchi latinue. Junni Diosi yalaca Juanchi fiquibe mantachi tinasanan, yalari te, natiya munaratuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Junnan Jesuri Juanca tsantitobi, mantá tan israelítalaca itsantinue: —In mate tsachilari uyan quiraque tenca tanla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Epelesiri paiminla joe tensaamin nalala cuwenta. Nalala amicolaca paito, chiquila son tito folota quito teranasanan, nulari peteratuminla joe tilatimanhe tinue. Junsi ya nalalanan laquichi warelaquinasanan, nulari pewarelaquitue tito pailaimanhe. ");
INSERT INTO cofNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aman laca paiminlanan jun nalala cuwenta tenca itonla joe tinue. Meralaquede! Mumunmin Juanni sen anoca fituto, bino cuchitumin jominue. Junni yaca yucanchi oco yachibi wica jonhoe tito paiminla joe. ");
INSERT INTO cofNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aman la mantimini tsachi ica jun joto Juan cuenta nenatiyoe. Lari ano fin, bino cuchin, pequimanyoe. Junni lacanan paito, jilu, junsi winan timinlae tinue. Laca paito, jutsa quiminlachi amico, ti quira inpuesto cala caminlachi amico joe timinla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Diosi mantimini ya seiton curaminlaca natiya tennatue. Junni tsachila Diosibe tsa miica junlaca quirato miilaichunae Diosi sen joeque. Jesús tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Junni fariseo manca Jesuca jasa tinue yachi yabi ano pefibi jasa. Jesús yachibi féto, tamochi wito, ano fichun chudinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Junni Jesús jun yabi ano pefinaeque meráto, jun pueblobi nechi sona manca pewinue. Ya sonari jutsa quito nenamin sona jominue. Tsan jotonan, yari puban pi cato, duque mica alabastro tinun suca quica jun boteyabi punca tanjanue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Junto Jesuchi benele wiruinue yachi nede quelole. Junsi laquichi wareto, Jesuchi nedebi capinchi ata suwanue. Junto aman achi nedeca manfu suwan, junsi motin, tito puban pica yachi nedebi ponue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Junni Jesuca jacarimin fariséori ya sona tsannaminca quirato, itsanque tenca canaminue: In Jesús Diosi mantaca jun jomanpari, miino jomin jonhoe niyan sona yaca taquirananunca. Seiton sona joe. ");
INSERT INTO cofNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Junni fariseo tsanque tenca canasa, Jesús yachi mumunca pato yabe itsantinue: —Simón, nube ticatiya cuenta quino muquee tinue. Junni fariséori Jesube pato, Maestro, paniquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Junnan Jesús ya fariséoca micarichun, itsanque cuenta polarinue: —Paluca tsachilari tsachi máncachi cala neloralarachunae tinue. Manca duque duque nelorachunae. Manca nasi nacári nelorachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Junni aman palunan cala mancuwano podeitunan, jera perdonaichunae tinue. Junni perdonaiminca duque laquiralarachunae perdonainun tenchi. Junni nuchi tencari, ¿yala palule nechi nun fécari laquirachunae tenjan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Fariséori tulanto itsantinue: —Fécari neloramin jomin tsachi fe laquirachunae tenjae tinue. Junni Jesús tsa tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús tsantisi, jun sonaca quiraereto, fariséobe itsantinue: —In sonaca tenca cato quirade! tinue. Chiquilachi miteri quirabi jaminlachi pi cuwano joe yape nede tsalesa. Nuri tsantue. In sona mantimini yachi capinchi lachi nedeca ata suwato yachi achi manfu suwae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chiquilachi miteri quirabi jaminlaca motito saludaino joe. Nuri tsantue. In sona mantimini la winunle nechi lachi nedeca camotinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chiquilachi miteri quirabi jaminlachi misubi aseite nasi pono joe. Nuri tsantue. In sona mantimini lachi nedebinan puban pinan iliponae. ");
INSERT INTO cofNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Junni nu meráde! tinue. Ya duque laquirae. Junto tsannaminca quirato miintsan joe ya duque jutsa tanunca piyarica joeque. Nu mantimini nasiri jutsa nacá tayoe tinaminca perdonainari, nasiri laquirachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Junni Jesús fariséobe tsantito, jun seiton sonaca nuchi jutsaca piyaricayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Junni junbi ano pefinaminla jun fiquica meráto paito, yala tala itsanlatinue: —¿Niyaito tsantinan? ¿Niyaito jutsaca piyarimin joyoe tinan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús mantimini jun sonabe itsantinue: —Nuri laca tennato se loca joe. Seque manjiniide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Junni man nete Jesús jerale pueblobi micaridede nenaminue. Diosi mantananun tsachi bolonca cuenta quito, sen fiquica micarinaminue. Yachi chunca paluca mantá tanlari Jesube pejinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sonalanan pejinato ayudainaminlanue. Ya sonala weyanlari quiyanpun jomin joto, Jesube manseica jominlanue. Weyanlachibi yucanchi ocola wica jun jominlaca Jesús mansularica jominue. Manca María Magdalena jominue. Jesús sieteca yucanchi ocolaca yachibi nechi mansularica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Junsi manca sonari Juana tinun jominue Chúzachi sona. Chuza Heródechi mayordomo jominue. Junsi manca sona Susana jominue. Uyanlanan duque pejominlanue. Ya sonalari yalachi calachi Jesula ti munaranuncatiya pecamin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Duque tsachilari manca pueblobi nechi, manca pueblobi nechi loto, Jesúchica jalainue. Junni ya tsachilabe duque micarinun cuenta polarinato itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tsachi manca ni aralebi jichunae. Weyan niri minubi arajicaca tsachila terelaquichunae. Pichunan fichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Junni weyan ni su jamote arajichunae. Sunaminnan, luba lato, jequeichunae tinue pi itonan. ");
INSERT INTO cofNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Weyan niri tsala minu arajichunae tinue. Junca tape fe uwaito, sunamin nacaca jera doquicaniquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Weyan niri sen tobi arajito seque suchunae tinue. Junni ya ni uwaito, ni cura patsa ni mancuwachunae tinue. Aman Jesús tsanque cuenta polarisi, sonba pato itsantinue: —Punqui chularatori, seque tenca cato meralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Junni Jesube penenaminla jun cuentaca meráto, yabe manpanhalaquinue tica tsanque pánanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Junni Jesuri itsantinue: —Diosi ya mantananun tsachi bolonca niyaque serawono jonunca nula miinola joe tinue. Casaleri miituntsan jominue; amanale nechi nulari miralarachunae. Merátuchi timinlaca mantimini cuenta quicachisiri micarimin joyoe tinue yape quiranatonan seque quiralaquitusa, yape meránatonan seque meralaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Junsi Jesús tsanque cuenta quetobi, junto ni aralenun cuentacanan jera tuca manmicarichinayoe tinue. Junto itsantinue: —Diosichi fiqui ni cuwenta joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Junni weyan tsachilachi tencari minubi polo ton cuwenta jolajochunae. Yalari Diosichi fiquica meránasanan, yucan janiichunae. Yucan jato, fiqui tencabi meraca jominca jera manlarichunae tinue yape Diosica quereituto manse lolaitusa. Diosichi fiqui yalachi tencabi wito, minubi arajica ni cuwenta joe. ");
INSERT INTO cofNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Junsi weyanlachi tencari su jamote cuwenta jolajochunae. Aman yalari Diosichi fiquica meráto, son tito meralaquichunae tinue. Junto telenle potuca jun cuwenta, moora fecári tennaminla joto peleiyoe tilatichunae tinue. Yucan yalaca jutsa manquisa carichi tinan, Diosichi fiquica mantelaquilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Weyanlachi tencari tsala to cuwenta jolajochunae. Aman yalari Diosichi fiquica meráto, niyaque sonnano jonunca, cala cano jonunca, pansi nenano jonunca wepanato nenalarachunae tinue. Junto peleito, jera sen itulajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Weyanlachi tenca mantimini sen to cuwenta jolajochunae tinue. Junni Diosichi fiquica meráto seque tennalarachunae tinue. Diosichi fiquica seque tenca tato seilaichunae tinue peleituto. Jesús ya cuenta tsanque manmicarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Junto Jesús itsantinue: —Aman lanparin tulitori, perolichi dilancaritunoe. O lowa tenpenan chutetunoe. Lanparinca tulitori, jamobi chutenomanhe yape tamochi jerale wiminla quiralaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aman la micarica jun fiqui jun tsanquenan jochunae. Amana miituntsan jonunca inari jera miintsan jochunae. Amana jera micaritununca man mate jeralelaca tuca micarintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jun tenchi nula amana tenca cato meralaquede! tinue. Fe miraminlacari Apa Diosi fe miisa carichunae. Miituchi timinlachicari nasi mirayoe tinuncatiya manjosolechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Junni Jesús micarinasa, yachi ayanbe yachi acolabe jalainue. Junni aman duque tsachila quidile wiruranan, wino podeilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Junni tsachi manca Jesube itsantinue: —Nuchi ayan, nuchi acola urachi wiruralarae tinue nube cuenta quechique. ");
INSERT INTO cofNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Junni Jesuri itsantinue: —Urachi wiruraminla lachi tsa ayan, acola josanan, yalacari ayan, aco titumanyoe. Jerale Diosichi fiquica meráto obedeseiminlaca lachi ayan, lachi aco timanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Junni man mate Jesube yachi tsachilabe wa canoabi wito, pipilu becochi polelaisa! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Junni aman polenato, Jesús catsonue. Junni duque sonban wu quinue. Junni latsa lato, piri canoabi winaminue. Menawintsancari pi winaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Junni yachi tsachila Jesuca mansoncarito itsanlatinue: —Miya, puyalaichinayoe latinue. Junni Jesús mansonhito wuca deisa mantanue. Latsacanan deisa mantanue. Tsantinunsi wuri jera mandeito owole cayainiinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Junni pica manhowoisa caritobi, yachi tsachilabe itsantinue: —¿Niyaito Diosica tennalaratiyun? tinue. Tsantinan yala jele tito duque wepanato, yala tala itsanticaalaquinue: —¿Inni ti tsachi junhun? tilatinue. Wube pibenan yaca meraniquimin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea tobi nechi jito, wa pipilu becochi poleto, Gadara tobi felainue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Junni canoabi nechi manlolainasa, jun pueblobi chumin tsachi Jesuca tulaibi janaminue. Junni jun tsachichibi duque yucanchi ocola wica jun jominue. Numarile nechi yachibi duque wica jun jominue. Fu puca nenato, yabi chutumin jominue; pantiyonbiri chuminue. Ya tsachica cadenachi teleto doca jominlanue. Junni ya cadenaca daraleto, epele sujimin jominue yucanchi ocolachi mantate. Ya tsachiri Jesuca quirato otito, yachi cale quepoinue. Junni Jesús yucanchi ocolaca mantato, tsachichibi nechi manloto jide! tinue. Junni yucanchi ocolanan sonba atito pato itsanlatinue: —Jesús, ¿nuri chiquilaca ti quebi jayun? latinue. Nuri jamochi chumin Diosichi Nao joe tilatinue. Junni chiquilaca casticaquitusa rocailainayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Junni Jesuri ti mumunyunque panhanue. Yalari itsanlatinue: —“Ejersito” tinun mumunlayoe latinue. Duque animali yucanchi ocola ya tsachichibi wicala jominue. Junni jun tenchi yalaca “Ejersito” tinun mumun jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Junto yala Jesube rocailainue yalaca yucanchi foroca eretusa. ");
INSERT INTO cofNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Junnasa mantimini duque cuchi du depante lapa finaminlanue. Junni yucanchi ocolari Jesube rocaito, cuchichi fecáriri eredeque rocailainue. Junni Jesús cuchichica jinilaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Junni yucanchi ocola tsachichibi nechi manloto, cuchilachibi jera manwilainue. Winunsileri, cuchiri wa duse jera supatito, wa pipilubi wito, pi jadito, jera puyalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Junni cuchi cuidaiminla mantimini junca quirato, puebloca jera mansujilainue. Junca piyanlelabe cuenta quede sujilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Junni jun pueblobi nechi tsachilari quirabi jalainue niyaito tsanhinunca. Junni Jesúchite fato, yucanchi oco pun jominca manquiralaquinue Jesuchi nedele jera sen manchuminca. Camisa manpun, junsi seque tenca tan manchuminue. Junni ya tsachica quirato jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Junni manseinaminca quiraminlari cuenta polarilaquinue Jesús niyaque yucanchi ocolaca sularinunca. ");
INSERT INTO cofNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Junni jerale Gadara tobi chuminla junca meráto, duque jele tito, Jesube rocailainue yape yalachi tobi nechi manjisa. Junni canoabi manwito manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Canoabi wilainasa, yucanchi oco pun jomin tsachiri Jesube pejino muqueeque rocainue. Junni Jesuri yaca manherenato, yaca itsanque mantanue: ");
INSERT INTO cofNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Nuchi yaca manjito cuenta polarina! tinue. Diosi nuca duque seque queeque cuenta polarina! tinue. Junni ya tsachiri manjiniinue. Aman manjito, jun jera pueblobi cuenta polarinue Jesús yachi tenchi duque seque queeque. ");
INSERT INTO cofNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús manjanasa, duque tsachila yaca méraminlanue. Ya manjaeque son tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Junni Diosichi fiqui miinun yaca mantamin tsachi janue Jairo mumun. Ya tsachiri mancari nama taminue. Chunca palu wata tsansi taminue. Ya namari puyachinaminue. Jun tsan jonan, Jesúchica jato, yachi cale telenhito rocainue yape yachica jasa. Junni yachica jinasa, parejo pejinaminla dilapun jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Junnasa quiyanpun sona manca Jesuchi benele nechi janue. Ya sonari chunca palu watale nechi ma cura luban quirato nenamin sona jominue. Junni yari cala jera castaica jominue manseichique. Niyanlanantiya janpeno podeitulajonue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Junni ya sonari Jesuchi benele nechi yachi camisa puntale nosa taquiranue. Tsanquesi manseinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Junni Jesuri ¿Laca mo taquiran? tinue. Junni jeralela taquiratiyoe latinasanan, Pedro itsantinue: —Miya, duque tsachilanan nuca taquiranilaquinae tinue. Nuchi awinta dilapowa ralarae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Junni Jesús itsantinue: —Tsachi manca laca taquirae. Taquiranasa manse suwayoeque tenhiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Junni quiyanpun jomin sona tenhinue Jesús yaca miichinaeque. Junto Jesúchica jowinpode jato, yachi cale telenhinue. Aman telenhito jera tuca cuenta polariniquinue tsachilachi cale. Quiyanpun joto taquirasi manseiyoeque jera cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Junni Jesús ya sonabe itsantinue: —Nama, laca tsarasi quereito manseie. Pansi manjiniide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Junni Jesús ya sonabe cuenta caquinasa, Diosichi fiqui miinun yabi mantaminchi yabi nechi tsachi janue. Junni ya nachi apabe itsantinue: —Nuchi namari numa puyanue tinue. Junto miya Jesuca jasa carituntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús mantimini junca meráto, ya nachi apaberi itsantinue: —Natiya jeleratude! Quereicachiri seque quereide! Nuchi nama mansonhichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Junsi Jáirochica jilainue. Junni belaiminla jeralela laquichi warenaminlanue. Junni Jesús yalabe itsantinue: —Warelaquitude! tinue. Ya na puyaca itoe; catson tson rae tinue. Junni belaiminlari miraminlanue tsa puyaca joeque. Jun tenchi Jesuchi fiquica meráto, cacarilaquinue. Junni Jesús tamochi winue. Jun puyaca tsonun tamochi wito, Pédrobe Juanbe Jacóbobe nachi ayanbe apabecari petanwinue; uyanlacari pewisa caritunue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Junto náca tedele cato, na, mancupade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Junni tsantinunsile, na puyaca jomin mansonhito mancupanue. Junni Jesús mantanue ya nachi ano cufilaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nachi apabe ayanbe son tito wepanalainue. Junni Jesús yalaca mantanue mobenantiya junca patulajosa. ");
INSERT INTO cofNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Junni Jesús chunca paluca yabe penenaminlaca oticato, yalachi mantá cuwanue yape jerale yucanchi ocolaca mansularino podeilaisa. Quiyanpunlacanan manse suwano poden suwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Junni tsanque jera mantá cuwato, yalaca erenue yape micarin, manse suwan, quilaquisa. Junni ya jichinaminlabe itsantinue: —Diosi ya mantananun tsachi bolon suwanaeque micarilaquina! tinue. Quiyanpunlacanan manse suwalaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nula micaribi jinato, tinantiya tanjitulajona! Nin tola, tolo, ano, cala, nin paluqui camisa tanjitulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Manca yabiri féto, junbisiri chularana! jun pueblobi nechi manlono fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Junni pansile manca pueblobi nulaca facarituchi latinari, yalaca telaqueponilaquina! Junsi nulari junbi nechi lonato, to poyo nedebi midicaca jera manpiquisito manjilaina! Junbi chuminlaca seiton jolajoe tito, to poyoca piquisilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesús tsantinunsi, yabe penenaminla ara cura jera jilainue. Diosichi sen fiquica micarito, quiyanpunlaca manse suwato, jera jilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Junnasa miya Herodes jera meránue Jesús niyan quinanunca. Junni junca merátonan, mo tsachi jonunca miino podeitunue. Weyanla patori, Jesuca Mumunmin Juan jonhoe latinue. Pansile yanan puyaca jominnan mansonhica jonhoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Weyanla mantimini matu to Diosichi mantate pamin tsachi mansonhica jonhoe latinue. Weyan weyanlari tsan jonhoe tito, matu to Elías jonhoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Junni Herodes junca meráto itsantinue: —Lari Juanca misu butunsa caricayoe tinue. Junni ¿Jesuri mo jonhoncan? tinue. Yaca duque wepanantsancari fiquica meranayoe tinue. Junto Herodes Jesuca quirachi tinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Junni aman Jesús mantato ereca junlari manjalainue. Manjato, yabe cuenta jera manquilaquinue titiya jera quinunca. Junni Jesús yalaca tanjinan, niyanlanantiya chutunun postoca jilainue Betsaida pueblo quelote. ");
INSERT INTO cofNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Junni tsachila junca miito, yalanan benechi jalainue. Aman Jesús yalaca facarito micarinue Diosi ya mantananun tsachi bolon niyan jono jonunca. Quiyanpunlaca manse suwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Junni quebi inasa chunca paluca Jesube penenaminlari yachica jato, itsantilatinue: —Inte niyanlanantiya chutunun posto joe. Tsachilari catsonoca, ano finoca neyanola joe latinue. Junni yalaca manherede! latinue yape quelole puebloca, o quelole yaca manjilaisa. ");
INSERT INTO cofNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Junni Jesús itsantinue: —Nulari yalachi ano cufilaquede! tinue. Junni junca wepanato meráto itsanlatinue: —Ano itolajoyoe latinue. Manteca biburi, paluca watsari talarayoe latinue. ¿O jeralelachi ano cufichun calachi cabi jinola joichunancan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aman duque tsachila junte raminlanue. Unilalacasiri minan, mante mili tsansi jominlanue. Junni Jesús yachi tsachilabe itsantinue: —Jerale inte ramin tsachilaca bolon cura chutelaquede! tinue. Man bolonbiri mante chunca tsansi chutelaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Junni tsantinunsi, Jesube penenaminlari jerale tsachilaca tsanque chutelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Junni chudica josa, Jesús manteca bibuca, junsi paluca watsaca cato, jamochi quirato, Diosibe acradeseinue. Diosibe acradeseitobi, aman bibube watsabeca pisuleto, yabe penenaminlachi cuwanue yape junte chumin tsachilachi cuwalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jeralela peleicari filaquinue. Junni aman puchuicaca manlayato, chunca palu tsalabi tuwale manlayalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Junni Jesús man mate chicanle Diosibe rocainaminue. Yachi tsachila quelole chuminlanue. Junni yalabe itsantinue: —¿Tsachilari laca mo jonhoe latinan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Junni Jesuchi tsachilanan itsanlatinue: —Weyanlari nuca Mumunmin Juan jonhoe latinae latinue. Aman junsi weyanlari nuca matu to Elías jonhoe latinae latinue. Junsi weyanlari nuca manca matute Diosichi mantate pamin tsachi mansonhica jonhoe latinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Junni Jesuri yalabe manpanhato, itsantinue: —¿Junni aman nulari laca mo jonhoe latiyun? tinue. Jesús panunsile Pedro itsantinue: —Nuri Diosi wenteca jun Cristo tinun tsachi joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Junni Jesús yalaca mantanue yaca Cristo joeque mobenantiya capatusa. ");
INSERT INTO cofNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Junto aman itsantinue: —Aman la tsachi ica jun joto, duque padeseino joyoe tinue. Aman mantá tan unicalabe, mantá tan patelelabe, mantaca micariminlabe, jera layaito, laca seitoe tito totesa carilaquichunae tinue. Aman la peman ma puyaca joto mansonhiichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesús tsantito, jeralelabe itsantinue: —Labe penenachi timinlari tenca munate nenanoca telaqueponola jochunae tinue. Corosibi puyano jun tsachi cuwenta jera telaquepoto, labesiri ma cura penenanola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yalachi tenca munatenan pansi chuchique tenfeminlari jera piyarito puyanilaichunae tinue. Juntonan tsanque pansi chunoca lachi tenchi telaquepominlari numatotiya Diosibe chuto polelaichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Juntonan tsachi manca piyanle toca tsacumin jominnan puyanari, ¿tichi mica jochunan? ");
INSERT INTO cofNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Junni amana mate weyan tsachilari lachi tsachi joyoe tino lu tilatichunae. Lachi fiqui tenchinan amana lu tilatichunae. Junni manca mate la tsachi ica jun joto manpatanae tinue. La manpatano mate labe lachi Apa Diosibe yachi anjelilabe jeralela uraran tsente jolajoanae. Junni jun mate lanan lu tiyanae tinue. La tenchi lu timin jominlacanan lachi tsachila jolajoe tino manlu tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","La nulabe tsarasica pachinayoe tinue: Nula weyan weyanla inte wiruraminla Diosi mantananunca quirano fecári puyalaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Junni ochu ma tsansi poletobi, Jesús dubi lonue Pédrobe Juanbe Jacóbobeca tanjito. Diosibe rocaibi lonue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Junto Diosibe rocainato, yachi caforo uyan quiran inue. Yachi camisari fibaquin fibaquin tse quiniquimin inue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Junnasa quiranari paluca matu to tsachila quirailainue Moisés manca, Elías manca. Yalanan duque tsen joto, Jesube cuenta quinaminlanue Jesús Jerusalenbi puyano joeque. ");
INSERT INTO cofNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Junni aman Pédrolachi duque capiya janasanan, catsolaitunue. Junni Jesús tseinanunca quiralaquinue. Paluca Jesube raminlacanan quiralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Junni ya paluca tsachila Jesúchite nechi manjilainasanan, Pedro paniquinue. Tenca catuminnan pato itsantinue: —Miya, chiquilari in dubi rano duque se joe. Junni pemanca jelen ya quintsan joe tinue nuchi manca, Moisechi manca, Elíachi manca. ");
INSERT INTO cofNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Junni Pedro tsanque cuenta quinasa, poyo jato yalaca donue. Junni yalaca poyo donunsi, jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aman poyobi nechi fiqui itsanque meralaquinue: —In lachi laquiranun Nao joe tinue. Junni yaca meralaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Junni aman tsanque cuenta quinunsi, Jesuri manpurainue. Moisebe Elíabe piyapolenilainue. Aman junca quiraminlari mobenantiya cuenta polarilaquitunue numari ma fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ayuna nanchi Jesula dubi nechi manpatanasa, duque tsachila yaca tulaibi jalainanue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Junni yala manca, sonba pato itsantinue: —Nu Diosichi fiquica micarimin joto, lachi naoca nasi manse suwade! Ya lachi mancari nao joe. ");
INSERT INTO cofNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yucanchi oco yaca cato, moorari atisa carimin joe tinue. Yaca enpo casa carito, fiqui forochi nechi pupu larisa carimin joe. Yaca fuda suwato, telatuchi timin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aman lari nube penenaminlaberi duque rocaiyoe tinue yape yucanchi ococa mansularito cuwasa. Junni yalari podeilaitue tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Junni Jesús yaca meráto, itsantinue: —Amana mate tsachila Diosica quereitumin seiton tsachila jolajoe tinue. ¿Numasi fecári nulabe penenano joichunan? ¿Numasi fecári nulaca wantaino joichunan? tinue. Junni Jesús tsantisi, ataque imin náca tanjasa tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aman naoca tanjananunca yucanchi oco queereisa carito ataque isa carinue. Junni aman Jesús yucanchi ococa sonba mantanue nachibi nechi manlosa. Junto ya náca tsanque manseto, yachi apachi mancuwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Junni jeralela junca quirato wepanalainue Diosi tsanque sonba se quimin jonunca. Junni Jesús ticatiya jera seque quinanunca jeralela wepananaminlanue. Aman tsachila wepanato cuenta quilaquinasa, Jesús yabe penenaminlabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Nula in fiquica tsarasica meralaquinade! tinue. La tsachi ica jun joto puyano joyoe tinue. Tsachi manca laca cuwapochunae tinue yape laca totelaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesuchi tsachila mantimini jun fiquica tuilaitunue. Diosi yalaca camiisa caritunue. Junni yalanan jun fiquica Jesube manpanhano jeleraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Junni Jesube penenaminlari cuenta quinaminlanue yala tala mo fe mantá tan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Junni Jesús miinue yala tsanque tenca calaquinanunca. Miito, na mancaca quelole jasa carito ");
INSERT INTO cofNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yalabe itsantinue: —Itsan nalalaca la tenchi seque quiminlari lacanan seque quiminla cuwenta jolajochunae tinue. Junsi laca seque quiminla laca eremincanan seque quiminla cuwenta jolajochunae tinue. Nula tala peyun cuwenta iminla, yalari mantá tan jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Junni Juan itsantinue: —Miya, tsachi manca yucanchi ocolaca mansularinaminca quiralaquiyoe tinue. Nuchi mantate yucanchi ocolaca mansularinaminhe. Aman yari chiquilabe penenamin itonan, yaca tsantusa tilatiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús mantimini yaca tsantitulajona! tinue. Chiquilachi contra itominla chiquilachi parte jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Junni Jesuri jamochi manlono ma quelo inasa, Jerusalenca jinonan joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Junni jinaminnan tsachilaca caquenan erenue yape pueblobi wito tile catsontsan jonunca neyalaquinasa. Ya pueblori Samaria tobi jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Junni jun pueblobi chumin tsachila jera meralaquinue Jesula Jerusalenca jilainaeque. Junni junca meráto, israelítala jolajoeque tenhito, junto israelítalaca pa joto, yalachi pueblobi pocatulajonue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pocatulajonan, Jesube penenaminla paluca itsanlatinue: —Miya, matu to Elías Diosibe rocainue jamochi nechi ninca ereto seitonlaca jera nin posa. ¿Chiquilanan in seiton Samaria tsachilaca jun tsannan quintsan jotun? latinue. Jacóbobe Juanbe tsantilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Junni Jesús yalaca quirato, itsantinue: —Te, tsanlaquitude! Nulari tenhituto yucanchi mite palaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lari tsachi ica jun joto, tsachilaca totebi jatucayoe tinue. Tsachilaca se laribi jacayoe tinue. Junni tsantitobi, uyan puebloca jito polelainue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aman minute jilainato, tsachi manca Jesube itsantinue: —Nube penenamin ino muquee tinue. Nunchitiya nube pejinoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Junni Jesuri beco manpato itsantinue: —Soronantiya foro tanmanhe catsochun. Pichunan tasen tamanhe. La mantimini tsachi ica jun joto, tilenantiya chuno itoyoe. Junni labe penenamin ino muquinari, casale duque tenca cano joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tsantitobi, manca tsachica labe penenana! tinue. Junni ya tsachiri itsantinue: —Miya, casale lachi apachica manjino joyoe tinue. Lachi apa puyanan menalaquetobi, lari nube penenabi manjanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús mantimini ya tsachibe itsantinue: —Yala puyaca cuwenta joto, yala tala menailaichunae. Nuri junca tennatuto, Diosi ya mantananun tsachi bolon suwanaeque micaribi jina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tsantinunsi, manca tsachi itsantinue: —Miya, lachi nube penenano muquee. Tsan josanan, casale manjino joyoe tinue yabi chuminlabe pansile manquiracaichunae tibi. ");
INSERT INTO cofNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesunan itsantinue: —Labe penenachi titori, juncasiri seque tenca cato nenantsan joe. Palaque tenca tanla Diosi mantananun tsachi bolonbi pewino michi sen itolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Junni tsanque micaritobi, Jesús siete chunca uyan tsachilachi mantá cuwanue yape yaca caquenan nenalarasa. Jerale ya jino jun pueblo cura erenue paluca paluca. ");
INSERT INTO cofNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Erechinato, itsanque mantanue: —Tsachilari duque waca junca balentsan cuwenta jolajoe tinue. Nulari narin peyunla cuwenta jolajoe tinue. Junni nula Diosibe mantaito quiminla joto, yabe rocailaina! uyanlacanan peeresa, yape nulabe peayudailaisa. ");
INSERT INTO cofNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jinilaide! Opisa náca lobo bolonbi erenun cuwenta nulaca erechinayoe tinue yape Diosica tennatuminlachibi nenalarasa. ");
INSERT INTO cofNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nulari nin tolo, nin sapato, nin cala tanjitulajona! tinue. Minute uyan tsachilabe saludainato cuenta quito wanhidede jilaituna! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Niyanlachi yabitiya fenato, seque chularana! tito saludailaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aman seque nenachi timin tsachi junbi chunari, Diosi yaca seque chusa carichunae nula pechularasanan. Junni junbi chuminla seitonla jonari, Diosi yalaca seque chusa carituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Junni nulari nenato, ya cura ano fide nenatulajona! tinue. Manca yabiri wito junbiri chularana! Ti cuwanatiya fin, cuchin, quilaquina! tinue. Jana peyunlari trabajo tenchi pacara quinasa, luratuto canilaquimanhe. Nulanan jun tsanquenan yala ano cuwananunca luratuto finilaquintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pueblo máncabi winasari, nulaca seque facarinari, aman junbi ti cufinatiya filaquina! ");
INSERT INTO cofNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Junbi quiyanpunlaca manse suwalaquina! Junni yalabe itsantilatina! tinue: Diosi nulachitenan ya mantananun tsachi bolon suwanae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aman pueblo máncabi winasa nulaca seque facaritunari, aman nula cayebi loto itsantilatina! ");
INSERT INTO cofNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","In pueblo seiton pueblo jonun tenchi to poyocatiya munaralaratiyoe latina! Junto nedecanan piquisilaquinayoe latina! to poyo caraica junca manbalechun. Tsan josanan, man fiquica miilaide! tilatina! Diosi nulachitenan ya mantananun tsachi bolon suwanae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Junni Jesús tsanque mantaquesi, yachi tenchi micaribi jichinaminlabe man fiquiman pato itsantinue: —Tsarasica meralaquede! tinue. To yucapiyarino mate Sodoma pueblobi chumin tsachila seitonla joto, duque padeseilaichunae. Aman nulaca facarituchi timinla mantimini jun tsachilaca fécari padeseilaichunae tinue to yucapiyarino mate. ");
INSERT INTO cofNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Junni Jesús tsantisi, yaca merátuchi timinlaca itsanque panue: —Corazín pueblobi chuminla, nula duque padeseilaichunae. Betsaida pueblobi chuminla, nulanan tsanquenan duque padeseilaichunae tinue. Tiro pueblobi chuminlabe, Sidón pueblobi chuminlabe seitonla jotonan, nulaca fécari sen jolajoe. Nulachibi duque wepanato quirantsancari seque quinaminca quiraminla jotonan, jutsa quinunca telaquepotucala joe. Junni aman jun pueblolabi tsanquica jomanpari, yalachi jutsa tenchi duque laquiito, jutsa quinunca jera telaquepono jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Junni to yucapiyarino mate nulari yalaca fécari padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Junsi Capernaum pueblobi chuminla, nulacanan payichinayoe. Nulari jamochi lonola joyoe titonan, puyan ocolachicari patilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Junni Jesús jun pueblobi chuminlaca tsantisi, ya ereca jun jichinaminlabe man fiquiman pato, itsantinue: —Nulaca meráminla laca meráminla cuwenta jolajochunae. Aman nulaca merátuchi timinlari laca merátuchi timinla cuwenta jolajochunae tinue. Aman laca merátuchi timinla laca eremincanan merátuchi timinla cuwenta jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Junni siete chunca tsachila ereca junla pansi manjalaito itsanlatinue: —Miya, yucanchi ocolacatiya nuchi mantate mantano podeilaiyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Junni Jesús yala tsantinaminlaca meráto, itsantinue: —Yucan jamochi nechi cunta pinda quinun cuwenta queereinaminca la quirayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Junni meralaquinade! La nulachi jera mantá cuwacayoe seitonlacanan fe lolaisa. Weyan tsachila pini cuwenta o tepin cuwenta seitonla josanan, yalaca fe lolaichunae tinue. Yucan titiya seiton quinanuncatiya nulanan fe lono mantá talarachunae tinue. La nulaca isaiyanae tinue yape nulaca tinantiya seiton quilaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Junni tsan jotonan, yucanchi ocolaca fe joto mantamin joyoeque polencari son titulajona! tinue. Nulachi mumunca Diosichibi chuteca jonunca fécari son tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Junni jun órate Jesús Diosichi Tencabe duque son tito, Apa Diosibe itsantinue: —Apa, jamochinan, tobinan nusiri Miya joe. Junto nuri duque miraminlaca nuchi sen fiquica miino podeisa caritue. Nuri uyan quiraque quino fe se jochunaeque tenca cae. Nalala cuwenta miratuminlacari nuchi sen fiquica miino podeisa carie. Jun tenchi la nube acradeseinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús yachi Apa Diosibe tsantitobi, tsachilabe itsantinue: —Lachi Apa Diosiri lachi jera cuwaca joe. Yasiri laca tsa mirae tinue. Junsi yachi Nao joto, lasiri Apa Diosica tsa mirayoe. Junto uyanlari, la entendeisa caritunari, Diosica miino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jeralelabe tsantitobi, aman yachi tsachilabe nosale itsantinue: —Nula la seque quinanunca quiralaquinae tinue. Junto pansi jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aman meralaquinade! tinue. Duque Diosichi mantate paminlabe, miyalabe, junca quiratucalae. Nula tsanque senca quirananunca yalari quiratucalae. Yalari nula meralaquinanuncanan merátucalae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Junni israelítala tala mantaca duque miramin tsachi Jesube panhanue yaca miiton jonhoe tito falta patarichique. Junni ya tsachiri wiruito Jesube itsanque panhanue: —Aman nu micarimin jotori, labe pade! tinue. Diosibe numatotiya sonnato poleno muquee. ¿Junni lari niyan quino jowan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuri yabe itsantinue: —¿Diosichi mantabi niyaque chuteca jun? tinue. ¿Niyaque mantaca jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Junni mantaca miramin tsachiri itsantinue: —Diosichi Pilabi itsanque chuteca joe tinue: Nulachi Miya Diosica jera tencabi tsaracari laquiranola joe. Misubinan tsaracari laquirato, sele tenca cato laquiranola joe tie tinue. Junsi tencachique laquiranun cuwenta, quiranunlacanan jun tsansinan laquiralarana! tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Junni aman Jesús itsantinue: —Tsa tie tinue. Jun mantaca merátori, numatotiya sonnato polechunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aman ya tsachi mantimini Jesuca meráto, jun mantá tenchi culpa ituchi tinaminue. Junni yari culpa ituchique itsanque panhanue: —¿Niyanlaca “quiranunlae” tinan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Junni Jesús tulanto, itsanque cuenta polarinue: —Israelita tsachi manca Jerusalenbi nechi Jericoca jichunae tinue. Junni aman tarinminla yaca tulaito, titiya tanjinanuncatiya jera tarinto, camisacanan larito, yaca misuto puyachinaminca tsoreto jilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Junni nanni ina israelita patele jun minuse janachunae. Yari ya tsachica quirato, tiwinle poleto, jiniichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Junsi nanni ina manca israelita jun minusenan janachunae. Yari patelelaca ayudaimin lebita tinun tsachi jochunae tinue. Junni yari jun fudan tsominca quiratonan, yanan tiwinle poleto jiniichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Junsi nanni ina Samaria to tsachi jun minusenan janachunae. Junni yari uyan to tsachi jotonan, fudan tsominca quirato laquirachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Junni yaca laquirato, quelo féto, ya fudanca janpechunae tinue. Aseitebe binobe poto, tsanpachi lapichunae. Junni fudanca janpeto, yachi burobi chuteto, pensionca tanjito cuidaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Junni aman ayuna nanchi ya pensión tsacuminchi cala cuwato, itsantichunae tinue: Aman in fudanca cuidainiina! In calari michi itonari, inca manpolenato mancuwaniqueyanae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aman Jesús ya cuentaca polaritobi, itsanque panhanue: —Aman pemanca tsachila ya tarinca jun tsominca quiralaquichunae tinue. Junni aman yala tala ¿mo quiranun jun cuwenta patichunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Junni mantaca miramin tsachiri Jesuchi fiquica jera meráto, itsantinue: —Yaca laquiramin tsachiri yabe quiranun jun cuwenta patichunae tinue. Junni Jesunan itsantinue: —Junni aman nunan jun tsannan jona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Junni Jesula jilainaminnan, pueblo máncabi wilainue. Junni junbi sona manca chuminue Marta mumun. Yari Jesúlaca facaricanue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aman Mártachi miyanni María tinun jominue. Junni yari Miya Jesuchi nede quelole chudito, ya micarinaminca meranaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta mantimini ano danoca duque wepana quinaminue. Aman Marta wepananato, Jesúchica jato, itsantinue: —Miya, chique ano danasanan, chiquechi miyan lan chunirae tinue. ¿Nuchi tencari tsan rano se jono junhun? tinue. Ayudaisa mantade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Junni Miya Jesús yaca meráto, itsantinue: —Marta, nu ticatiya quinoca duque wepananae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aman man cosa quinori fe munarantsan joe. María wari jun senca wentecae. Junni aman yachibi nechi natiya manjosolaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesús Diosibe rocainaminue. Jun deinunsileri, yabe penenamin tsachi manca Jesube itsantinue: —Miya, Mumunmin Juan yabe penenaminlaca Diosibe niyaque rocaino jonunca micarinue. Aman nunan chiquilaca rocaino micaride! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Junni Jesuri itsanque rocaintsan jochunae tinue: Chiquilachi Apa Diosi, nu jamochi chue. Nuchi mumunca duque respetaino jolajoyoe. Nu mantananun tsachi bolonca duque serawode! Jamochi nuchi tenca munate quinanun tsannan, in totenan jun tsanquenan quino muquilaquee. ");
INSERT INTO cofNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amanari chiquilachi ano cuwade! ");
INSERT INTO cofNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aman chiquilaca jerale seiton quiminlaca perdonaica jonan, nunan chiquilacanan perdonaide! Yucanbe encanaisa caritude! Chiquilaca se laride! yape yucan chiquilaca fe lotusa. ");
INSERT INTO cofNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Junni Jesús tsanque Diosibe rocaino micaritobi, itsantinue: —Quitsa quepente nulachi amicochica jito, ano finoca panhalaquichunae. Amico tilatichunae. Manca amico barebi nechi jato, lachibi fae tilatichunae tinue. Aman lari yachi tinantiya fintsanca cuwano itoyoe. Junni pemanca bibuca nasi faricaride! tilatichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aman nula tsanlatinasa, tamochi nechi itsanque tulanchunae. Pasuwatude! tichunae. Tamolanca doca joyoe; catsonayoe; nalalanan catsolainae tichunae tinue. Cupato nuchi cuwano podeitiyoe tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Junni aman ya amico tsantinaminnan, nulachi cuwaniquichunae tinue. Amico jonun tenchi cuwatutonan, nula peleituto panhalaquinari, cuwachunae tinue. Ticatiya jera munaranunca cuwachunae yape nantari pasuwatusa. ");
INSERT INTO cofNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jesús ya cuenta polarito, itsantinue: —Nula ticatiya munaralaratori, Diosibe panhanilaquina! Panhanilaquinari, Diosi cuwachunae tinue. Junsi titiya canola jotori, neyalaquina! tinue. Neyalaquinari, Diosi fesa carichunae tinue. Junsi nunchitiya winola jotori, tamolante otilatina! Otilatinari, Diosi lasichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aman jerale panhaminlari calaquichunae. Neyaminlari felaichunae. Tamolante otiminlachi tenchiri lasaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aman tsachilaca tenca calaquede! Nalala apabe bibuca panhalaquinari, bibuca cuwalaquichunae; suca cuwalaquituchunae. O watsaca panhalaquinari, watsaca cuwalaquichunae; pinica cuwalaquituchunae. ");
INSERT INTO cofNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O pipocaca panhalaquinari, pipocaca cuwalaquichunae; tepinca cuwalaquituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aman tsachilari seiton tenca tanla jotonan, nalalachi senca cuwaminla joe. Junni nulachi Apa Diosi mantimini sen tenca tan joto, yanan yabe panhaminlachi fécari senca cuwachunae. Aman yalachi tencabi yachi Tencaca cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aman man nete Jesús yucanchi ococa sularinue. Junni jun yucanchi ocori tsachi mancaca yucapiyarica jominue yape pano podeitusa. Junni Jesús yucanchi ococa mansularito cuwanan, manpano podeinue. Aman junca quiraminlari wepanalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","Tsan josanan weyanlari Jesuca quereituchi tilatinue. Junni yala weyanlari Jesube itsanlatinue: —Nuri jamochi nechi mantá tatori, wepanato quirantsancari quede! latinue yape junca quirato quereilaisa. Uyanlari Jesuca pato itsanlatinue: —Jesús tenca mánta yucanchi ocolaca mansularitumin joe latinue. Beelzebuchi mantaberi yucanchi ocolaca mansularimin joe latinue. Aman Beelzebú titonan, yucancanan tsantinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","18","Junni Jesús miinue yala seitonque tenca calaquinanunca. Junca miito itsantinue: —¿Ti quichun laca yucanchi mantate yucanchi ocolaca sularinae latinayun? tinue. La yucanchi mantate yucanchi ocolaca sularinari, yucanla tala sularicaanun cuwenta jochunae tinue. Itsanque jochunae. Man tori chun tala quera quicaalaquitori, jun to jeraichunae tinue. O junsi man familia tala pataalaquitori, layaito chuno podeilaituchunae tinue. Junni aman yucanchi ocola tala sularicaatori, jun cuwenta jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aman tenca calaquede! Nula tala weyanlari yucanchi ocolaca sulariminla joe. Aman la yucanchi mantate yucanchi ocolaca sularimin jonari, ¿yalanan yucanchi mantate sulariminla jun? Junca tenca cato tenhintsan joe laca epelenan culpa quilaquinayoeque. Lari wari yucanchi mantate sularitiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Diosichi mantateri yucanchi ocolaca sularimin joyoe. Aman junca tenca cato miintsan joe Diosi nulachitenan ya mantananun tsachi bolon suwanaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesús tsantito, junto yucanca man fiquinan pato itsantinue: —Yucanni sonban tsachi cuwenta joe. Jun sonban tsachiri espada tan joto, tencachique yaca cuidainachunae. Junni tsacumin cuidainasa, ya tanunca monantiya josoleno podeituntsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yari espadabe sonban joyoe tito, pansi chunirachunae tinue. La mantimini yucanca fe sonban joyoe. Yabe quicaato fe locayoe. Lari yachi espadaca josoleniquiyoe tinue. Junto yachi ocolaca mansularino podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Junni lachi parte itonla laca pa jolajochunae. Tsachilaca labe penenasa carituminlari epele nenasa cariminla jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Junsi Jesús itsanque cuenta polarinue: —Yucanchi oco tsachichi tencabi nechi loto, epele nenachunae tinue tile jasaino jonunca neyato. Junni jasaino podeituto, jun tsachichi tencabinan manchubi jichinayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aman manjato quiranari, jun tsachichi tenca casica jun tamo cuwenta sen jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Junca quirato manjito, weyan sieteca yucanchi ocolaca cato, ya tsachichi tencabi petanwichunae yape junbi pechularasa. Junni aman jun sietecala ya mancaca fe seiton jolajochunae tinue. Junni ya tsachiri casale mancari yucanchi oco posari, seiton tsachi jomin jochunae. Nanni wanbile mantimini, nantanancari yucanchi ocola winunbi, nantanancari seiton ichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Junni Jesús tsanque micarinasa, duque tsachila yachi fiquica meranaminlanue. Junto aman sona manca sonba pato, yabe itsantinue: —Nuchi ayanni duque pansi jono joe nuca na quinun tenchi, nuca uwa suwamin jonun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Junni Jesús yaca meráto, itsantinue: —Aman tsan josanan, Diosichi fiquica meráto obedeseiminla fécari pansi jonola joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aman nantanancari tsachila layailainasa, Jesús itsantinue: —Nula seitonla joto, laca wepanato quirantsancari quisa tilatinae tinue. Te, nulachi tenchi tsanquitiyoe. ¿Laca Diosi mantaca jun tsachi joeque miino muquilaquin? tinue. Miino muquilaquinari, man fiquica tenca calaquede! Matu to Jonaca tenca calaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínive tinun pueblobi chuminla Jonaca meráto Diosica miilainue. Ya Jonás niyanhica jonunca meráto, miilainue Diosibe cayaino jonunca. Junni amana mate lari tsachi ica jun joto, Jonás cuwenta joanae tinue. La niyanhica jonunca meráto, nulanan miinola jochunae Diosibe cayainola joyoeque. ");
INSERT INTO cofNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Aman Jonari Nínive puebloca jito, Diosichi fiqui micarinasa, junbi chuminla jutsa quinunca telaquepoto, casan tala tenca mancalaquee. Amana Jonaca fe mantá tan tsachi nulaca micarinasanan, jutsaca natiya telaquepotuchi timinla joe tinue. Junni to yucapiyarino mate nula jun tenchi fe culpa ilaichunae tinue. O Salomón tinun miyaca tenca calaquede! tinue. Sabá tobi miya sonari barebi nechi Salomonca merábi janue yape duque miranunca micarisa. Amana wari Salomonca fe miramin tsachi nulaca micarinasanan, natiya merátuchi timinla joe tinue. Aman to yucapiyarino mate nula jun tenchi fe culpa ilaichunae tinue. Jesús yalaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Junsi aman Jesús itsantinue: —Aman lanparin tulito, forochi potunoe. O perolichinan dilancaritunoe. Aman tulito, jamobi chutenomanhe yape tamochi jerale wiminla quiralaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aman nulachi caca lanparin cuwenta joe. Seque tenca cato quiratori, seque nenano podeilaichunae tinue. Seque tenca catuminnan quiratori, seitonque nenalarachunae tinue. Tseno piyacabe nemente nenamin cuwenta jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Junto tencabe nenalarana! nemente cuwenta nenatuchun. ");
INSERT INTO cofNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aman Diosi nulachi tencaca jera tse suwanari, jera mirato seque nenalarachunae tinue lanparinbe nenamin cuwenta. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Junni Jesús camicarinasa, israelita tsachi manca yabe cuenta quinue. Fariseo jominue. Ya tsachiri Jesube rocainue yachi yabi ano fibi janaque. Junni aman yachica jito, tede tsaletuminnan ano fichun chudinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aman fariséori junca quirato, wepanato, tede tsaletuminnan ano fino Diosibe seitochunaeque tenca canue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Junni Miya Jesús junca tenhito yabe itsantinue: —Nula fariséolari nidaca jamoleri tsaleminla cuwenta jolajoe. Aman nida forochi petse mitan rachunae tinue. Nulari jun tsanquenan jamoleri sen jolajotonan, tencabi encanato tarinpunla joe tinue nida se tsaleca iton cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nula tenca itonla joe. Diosi chiquilachi pucaca quimin joto, chiquilachi tencacanan quica joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Junni aman nulari seque meralaquede! tinue. Sen tenca jolajotori, ticatiya tanunca weyanca itonlachi cuwalaquina! Junni tsanlaquitori, niya quiraquetiya finiquintsan jochunae seiton tenca ino jonunca wepanatuto. ");
INSERT INTO cofNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aman nula fariséolari tsan jonun tenchi duque padeseilaichunae. Diosichi mantaca meráminlayoe tito, ti tanuncatiya Diosichi nasi cuwaminlae. Diosi tsanquisa mantánan, nulari chunca ticatiya cato, Diosichi manca cuwaminlae tinue. Aman danun tape nacá jerale, menta tinun tape, ruda tinun tape nacalaca cuwaniquiminla joe narin nacá jomincatiya. Aman jun mantaca meráminla jotonan, Diosichi fe merántsan mantaca nulari natiya tennatuminlae. Encanalaquituna! tinunca, Diosica laquiralarana! tinunca natiya tennatuminlae tinue. Diosichi weyan mantaca telatuminnan, jun fécari merántsan mantaca meráno jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nula fariséolari duque padeseilaichunae. Aman nulari fe joyoe tito, Diosichi fiqui miinun yabi fela chudinunbi chudichi timinla joe. Plasate nulaca duque respetaito saludaisa tennalarae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aman menaca jonunca tenca calaquede! tinue. Tsachila matu mate menaranun jamote nenatonan, mena joeque tenhilaituchunae. Tenhilaituchunae puyato peteca jun jamote nenalarayoeque. Junni nula fariséola jun tsanquenan jamoleri sen jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Junni aman israelítala tala mantaca duque miramin tsachi junte pechuminue. Junni yari Jesús pacaca meráto, yabe itsantinue: —Nu micarinato, chiquilacanan seitonque pánae tinue. Fariséolaca seitonla joe tinato, chiquilacanan seitonque patarinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Junni tsantinunsi, Jesús itsantinue: —Nula mantaca duque miraminlanan padeseilaichunae tinue. Piyanlelaca meráno tenfe jonunca mantato, jun mantaca meráno natiya ayudaituminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aman nula duque padeseilaichunae tinue. Nulachi matu tatala Diosichi mantate paminlaca jera totelaquinue. Junni amana nula toteca junlachi menate ya nacá quiminla joe yalaca mantenhichun. ");
INSERT INTO cofNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tatala toten, nulari ya nacá quin, quiminla joe. Junni tsanque miintsan joe nulari nulachi tatala cuwenta jolajoeque. Ya tatala totelaquinasa, nula totentsan joe timinla cuwenta jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Junni jun tenchi Diosi duque miramin joto, yachi Pilabi itsantica joe: Yachi mantate paminlaca ereyanaeque chuteca joe. Yalari Diosichi tenchi jalaichunaeque chuteca joe tinue. Junni tsachila mantimini weyanlaca seiton quin, weyanlaca toten, quilaquichunaeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Junni Jesús Diosichi Pilabi chuteca jonunca tsanque pasi, itsantinue: —Aman toca quinunle nechi seiton tsachilari layan sen tsachilaca totecala joe. Diosi ereca junlaca totecala joe. Casale matu to Abel tinunca totenue. Junte nechi layan sen tsachilacanan manca manca toteto, junsi aman Zacarías tinun tsachicanan totelaquinue. Yaca Diosichi sen tamobe Diosichi titiya epe cuwanun mesa jolale totelaquinue. Junni nulanan jerale tota junlachi tenchi culpa ilaichunae. Lari nulabe tsarasica pachinayoe: Nula matute sonnatuminla jotonan, junca jera culpa ilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nula mantaca duque miraminlari duque padeseilaichunae tinue. Aman nulari Diosibe tsa miituto, miichi timinlacanan miisa carituminlae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Junni Jesús jun fariséochi yabi tsanque micarinue. Junni junbi nechi manjinasa, fariséolabe israelítala tala mantaca miraminlabe Jesuca duque paito cuenta manquebi jalainue. Aman duque ticatiya panhato, yaca epele pasa carichique tenfelainue. ");
INSERT INTO cofNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yaca culpa quechiqueri epele panhanaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","3","Fariséolari Jesuca paito cuenta quilaquinasa, duque mili tsachila junte layailainue. Duque joto, yalachi nede tala teraalaquinaminue. Junni tsanlainasa, Jesús yachi tsachilabe casale itsantinue: —Fariséola seitonla jotonan fe sen jolajoyoe timinla joe tinue encanato. Junni aman tenca calaquede! tinue. Amana nosa jonunca, encanaica jonunca, ina jera miintsan jochunae. Tamochi nosa pacaca jeralela ina manmeralaquichunae tinue. Junni aman tencabe nenalarana! tinue fariséola cuwenta nenalaratuchun. ");
INSERT INTO cofNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Junsi Jesús itsantinue: —Lachi amicola, la nulaca tuca micarichinayoe. Tsachi pucacari toteminlaca jeleratulajona! Totetobi, nantari quino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tuca payinayoe. Toteminlaca jeleratuto, Diosicari jeleralarana! tinue. Ya puyasa carito, tencacanan ninbi casticaquino podeimin joe tinue. Yacari jeleralarana! tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Aman manteca pichu nacaca nasiri calachiri cantsan joco? Aman pichulanan layan mica itomincanan Diosi cuidaimin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jun tenchi nula jeleratulajona! Aman nulari duque pichulaca fe mica jolajoe tinue. Aman Diosi nulaca seque cuidaimin joto, nulaca ticatiya jera mirae. A sili niyan sili chununcatiya jera mirae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Junto Jesús itsantinue: —Nulaca tuca payichinayoe: Nulari tsachilaca jeleratuto, la tenchi luratulajona! tinue. Junni tsachilachi cale lachi tsachi joyoe tinilatina! Tsantiminlaca lanan lachi tsachila jolajoe tiyanae. La tsachi ica jun joto Diosichi anjelilachi cale yalaca tsantiyanae. ");
INSERT INTO cofNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Junnan tsachilachi cale lachi itoyoe titulajona! tinue. Tsantiminlaca lanan Diosichi anjelilachi cale pato, lachi tsachila itolajoe tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tsan josanan la tsachi ica junca seitonque paminlaca perdonaintsan jochunae tinue. Juntonan Diosichi Tencaca seitonque paminlacari numatotiya ya jutsaca perdonaituntsan jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nulaca Diosichi fiqui miinun yabi tanjilaichunae nulaca culpa quechique. Miyachi o mantá tanlachi cale tanjilaichunae yape casticaquilaquisa. Junni nulaca culpa quito canari, wepanatulajona! niyaque beconan pano jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aman pánasanan nulaca Diosichi Tenca tuca pano micarichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aman duque tsachila Jesuca meránaminnan, tsachi manca yabe itsanque rocainue: —Nu micarimin joto, lachi acoca payide! tinue yape erensiaca lachi quitsaca cuwasa. ");
INSERT INTO cofNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Junni Jesunan itsantinue: —Amico, erensia quitsaleto cuwamin itoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Junni Jesús ya tsachibe tsantisi, jeralelabe itsantinue: —Aman fécari ticatiya tanla fe pansi itolajochunae tinue. Junto aman tencabe nenalarana! uyanla tanunca natiya munaito quiratuchun. ");
INSERT INTO cofNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Junni Jesús tsantito, man quiraqueman pato cuenta polarinue micarichun. Itsantinue: —Duque cala tan tsachi jochunae tinue. Aman yachi witabi duque ticatiya serachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Junni mancari tenca cato, ¿Niyan queyanan? tichunae. Aman yachi witabi duque cato, ¿Tile duqueyanan? tichunae tinue. Aman tilenantiya duno itoyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsanque tenca cato, dunun yaca manharaleno tenca cachunae tinue. Aman dunun yaca araleto, fécari jelelen ya manqueyanaeque tenca cachunae. Aman junbi jerale finoca, jera ticatiya tanunca duto tanae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aman junbi ticatiya jera duto, pansi chuanaeque tenca cachunae tinue. Duque wata finoca michi tayoe tichunae tinue. Junto pansi chun, fiesta quin, cuchin, queyanae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tsantin chusanan Diosi yabe cuenta quito, tenca iton joe tito epe dunae tichunae tinue. Amana quepen puyano joe. Junni nu puyanunbi, ¿jun duranunca tiyan cachunan? tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Junni Jesús ya cuentaca polaritobi, itsantinue: —In tote calachi oco iminlari jun cuwentanan tenca itonla jochunae tinue Diosichi cale popere tenca jotonan. ");
INSERT INTO cofNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Junni Jesús yachi tsachilabe itsantinue: —Jun tenchi nulaca itsanque payichinayoe tinue: Nula wepanalaituna! Finoca, o panuca niyaque cano jonunca wepanalaituna! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Niyaque sonnano jonunca tenca canato, anocari tenca canola itoe. O panube seito nenanoca tenca cato nenatuntsan joe. ");
INSERT INTO cofNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jana pichuca quirato tenca calaquede! tinue. Waquetumin joe. Setumin joe. Dunun ya itoe. Junni tsan josanan Diosi yalachi finoca cuwaniquimin joe tinue. Nulaca mantimini pichulaca fécari laquirato cuidaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Wepanacachinan quitsa metro fe uwaino podeinola joyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Junni jun nacátiya quino podeitutori, ¿ti quichun uyanca wepanalainayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Junsi panucanan wepanatuntsan joe. Aman lulica tenca calaquede! tinue. Yanan seque uwaimin joe. Trabajaquitumin joe. Sita quitumin joe. Tsan jotonan duque uraran joe tinue. Matu to miya Salomón tsara moso panube seitonan, luli tsansi moso itominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aman lapanan moora yucapiyamin joe. Amana jayacate moso jotonan, nanni ina jequeito ninbi niyamanhe. Junni lapari moora yucapiyamin josanan, Diosi yaca duque moso suwamin joe luli isa carito. Junni Diosi epe lapaca moso suwamin jotori, nulachi sen panucanan cuwachunae tinue. Aman nulari duque moso jochique wepananato, Diosica tennatuchi timin tsanni jolajoe. ");
INSERT INTO cofNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Junni nulari wepanatulajona! tinue. Finoca, o cuchinoca niyaque cano jonunca natiya wepanatulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aman jeralete Diosica tennatuminlari junca cachique wepanaminlae. Aman nulachi Apa Diosi nulaca cuidaimin joto, ticatiya jera munaranunca mirae. ");
INSERT INTO cofNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aman Diosi mantananun tsachi bolonbi pewito nenachun tenfelaina! tinue. Junni tsanque tenca cato nenanari, jera munaranunca Diosi cuwachunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Junsi Jesús yachi tsachilabe itsantinue: —Nula narin tsachila jotonan, jeleratulajona! Nulachi Apa Diosi nulaca laquirato, ya mantananun tsachi bolon isa cariyanae ticae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aman ticatiya tanunca osito, poperelachi lemosi cala cuwalaquina! tinue. In tote tanun cala piyachunae tinue. Junni aman Diosichi tenchi cala cuwatori, ya calaca Diosichica erenun cuwenta jochunae. Junbi yucapiyatuchunae. Junbi ticatiya tanunni jeraituchunae. Nin julunan fituchunae tinue. Nin tarinlanan tarinlaquituchunae tinue. Junni aman in tote layan ticatiya tachique tenfetulajona! tinue. Jamochi ticatiya layan tachique tenfelaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nulachi senca man postobi tatori, jun postoca tenca caminla jochunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Junni Jesús camicarinato, yachi tsachilabe itsantinue: —Lari casalainanun fiesta quirabi jica jun tsachi cuwenta joichunae tinue. Lachi peyunla méranola jochunae yape la manjasa. Junni la manjasi, otiyanae. Junni lachi tenchi tamolanca lasichun méranola jochunae tinue. Aman nula jun tsanquenan meralarana! tinue. Jera seito meralarana! sendori quica jun, lanparin tulica jun cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aman patron manjanasa, weyan peyunla yaca mérato sonnan chularachunae tinue. Yala duque pansi jolajochunae. La nulabe tsarasica pachinayoe tinue: Patron patsa jun sen peyunlaca chuteto, yanan peyun cuwenta ito yalachi ano poto cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wa quepente janari, o quitsa quepente janari, sonnan méranola joe tinue. Sonnan caméraminla duque pansi jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","O tarinlaca tenhilaide! tinue. Ya tsacuminla miitolajoe tarinla niyanque óra janola jonunca. Ya miramanpari, sonnan mérato quirano jominla jonhoe yape tarinquebi wiyalaitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nula jun tsanquenan tencabe méranola joe la tsachi ica jun joto manpatano jonunca. Laca manpatatuchunae tilatinasanan, manpatano joyoe tinue. Jesús yachi tsachilaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Junni Jesús tsanque micarinunbi, Pedro yabe itsantinue: —Miya, ¿nu chiquilaberi tsantinayun, o piyanlelabenan tsantinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Miya Jesuri yabe tulanto itsantinue: —Nulari lachi mayordomola cuwenta jolajoe. Aman ya tsacumin uyanchi jinato, mayordomoca mantachunae peyunlaca cuidaito ano cufisa. Junni aman mayordomori duque tenca tan tsachi jotori, seque cuidaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aman patron manjanasa cuidainatori, pansi jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","La nulabe tsarasica pachinayoe: Ya mayordomoca fécari mantá tan suwachunae yape jera tanunca mantasa. ");
INSERT INTO cofNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mayordomo mantimini seiton jotori, seque cuidaituchunae tinue. Lachi patron manjano wanhinae tito, peyunlaca asota quichunae. Aman jiluito, warente cuchito, winan iniichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Junni ya seiton mayordomo yachi patronca jatuchunaeque tenca canasanan, manjaniichunae tinue. Miitonun órate jato, seiton mayordomoca duque casticaquichunae tinue. Diosica tennatuminlaca casticaquinun cuwenta, ya mayordomocanan casticaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","Junni nulari tencabe jolajona! tinue. Tsachi mancaca duque mantá tan suwanari, yari duque ticatiya quintsan jochunae. Aman nasiri mantá tan suwanari, nasiri ticatiya quintsan jochunae tinue. Junni aman Diosichi mantaca miraminla jun tsanquenan jolajochunae. Miratonan, Diosichi mantaca merátuminla duque casticailaichunae. Aman miitoto seiton quiminla mantimini nasiri casticailaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Junto Jesús yalaca camicarinato itsantinue: —Lari duque padeseiichunae tinue. Padeseino fecári duque wepananayoe. Lari tobi ninca serawobi jamin cuwenta joyoe tinue. Nin lunamin cuwenta lachi bolon tsachila seralaichunae tinue. Junni ya ninca we luquinasa tenjanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Nulari laca ti quebi jacae latiyun? tinue. Jeralelaca man parejori tenca casa caribi jatucayoe. Te, la janunbi tsachilari uyan tala, uyan tala tenca calaquichunae tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Inte nechi man yabiri chuminla talanan pa jolajochunae tinue. Manteca jominla, pemanca lachi parte, paluca lachi contra jolajochunae tinue. O paluca lachi parte, pemanca lachi contra jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lachi tenchi apabe naolabenan pa tala jolajochunae tinue. Ayanbe namalabenan pa tala jolajochunae. Nasobe unilachi ayanbe pa tala jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Junto Jesuri layan tsachila raminlaca micarinato, yalabe itsantinue: —Nula pelechi poyo raminca quiratori, suwa quichunae timinlae. Junni suwa quimanhe. ");
INSERT INTO cofNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","O butunni tala nechi wu quinari, loba loba jochunae timinlae tinue. Junni loba loba jomanhe. ");
INSERT INTO cofNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nula yoquidoca, wuca quirato miino miralarae suwa quino jonunca, o loba loba ino jonunca. Junni la ticatiya quinanuncanan quirato miintsan joe Diosi tsanquisa carinaeque. Nulari wari min jolajoyoe titonan, natiya seque miituminla joe. Yoquidoca, wuca miiminla jotonan, Diosi ti quisa carinanunca miituminla joe tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Junni Jesús tsantisi, man fiquiman itsanque panue: —Nulanan tenca mánta ti sen jonunca tuintsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aman tsachi manca nulaca culpa quinari, nulaca culpa quiminbe wewe amico manhilaina! Comisariochica parejo jinaminnan, amico manhilaina! Tsanhitunari, pansile nulaca comisariochi cuwapochunae tinue. Junni comisariori nulaca polisialachi cuwapochunae yape dolaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nulabe tsarasica pachinayoe: Cala jera cacuwatuminnan, numanan manlolaituchunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Junni Jesús tsanque micarinasa, tsachila jato yabe cuenta quito, Galilea tobi chumin puyacalaca cuenta quilaquinue. Yalari Diosichi cuwachun tito, animalilaca totenaminlaca miya Pilátori yalacanan jera totesa carinue. Yalaca totenan, yalachi asan animalilachi asanbe palaica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Junni Jesús jun cuentaca meráto itsantinue: —¿Ya Pilato toteca jun tsachilaca niyan tilatiyun? ¿Yalari weyan Galilea to tsachilaca fe jutsa tan jominla jonhoe tilatiyun? ¿Jun tenchi puyacala jonhoe tilatiyun? ");
INSERT INTO cofNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","La nulabe tsarasica pachinayoe: Ya toteca junlari fécari jutsa tan itominlanue. Nula cuwentanan jominlanue. Junni nulanan jutsa quinunca telaquepoto casan tala tenca mancantsan joe tinue. Tsantutori nulanan totailaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O uyanlacari tenca calaquede! tinue. Siloé tinun jamo ya arajito, chunca ochuca tsachilaca dilato totenue. ¿Yalaca niyan tilatiyun? tinue. ¿Yalari weyan Jerusalenbi chuminlaca fécari jutsa tan jominla jonhoe tilatiyun? ¿Jun tenchi puyacala jonhoe tilatiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nulabe tsarasica pachinayoe: Ya puyaca junlari fécari jutsa tan itominlanue. Nula cuwentanan jominlanue. Junni nulanan jutsa quinunca telaquepoto, casan tenca mancantsan joe tinue. Tsantutori, nulanan padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Junni Jesús micarinato, itsanque cuenta polarinue Diosi ico pele tsacumin cuwenta joeque: —Aman tsachi manca yachi witabi ico pele tachunae tinue. Junni ico pucaca neyabi janasa, natiya itochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Junto wita cuidaiminbe itsantichunae: Aman quirade! tichunae. Peman wata fecári pucaca neyabi janasa, puca itoe tichunae tinue. Junni toleto quepode! ¿Ti quichun epe chide chuno jochunan? tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Junni wita cuidaiminni yachi patronbe itsantichunae: Nasi camérade! tichunae tinue. Man wata fecári toca towan, peca abono cuwenta tsoren, quechinayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jun fecári puca inari, se jochunae. Aman puca itunari, tolentsan jochunae tichunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Junni jasaino mate Jesús Diosichi fiqui miinun yabi micarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aman junbi sona manca bontoica jun jominue. Chunca ochu wata ya sonaca yucanchi ocori tsan suwato taminue. Yari mantuino natiya podeitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Junni aman Jesuri yaca quirato, jasa tito, nuca manse suwanayoe tinue yape tsanque padeseitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Junto yaca tedechi tale quinunsi, betende manseinue. Junsi ya sonari manseicayoe tito, Diosica duque se tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aman jun Diosichi fiqui miinun yabi mantamin tsachiri ya sonaca mansenanunca quirato, duque painue. Jasaino mate manse suwanun tenchi Jesuca painue. Aman paito, junte layaica junlabe itsantinue: —Sota ma trabajaquino ma joe. Jun málate manseibi jalaina! Jasaino mate manseibi jatuntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aman Miya Jesús junca meráto, beconan pato itsantinue: —Nuri laquiramin joyoe tinatonan, natiya laquiratumin joe. Laca jasaino mate manse suwatuna! titonan, nula jeralela jasaino matenan quiniquiminla joe. ¿Aman jasaino matenan nulachi wala, buro, ticatiya lasito, pi cuchisa tanjimin jolajotiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Junni jasaino mate animalica pi cuchisa lasino jonari, in sonaca jasaino matenan manse suwano jotun? tinue. Aman yanan chiquila cuwenta matu to Abrahanchi alica joe. Yucan yaca chunca ochu wata fecári pasuwanaminue yape teleca jun cuwenta nenasa. ¿Wari jasaino ma josatiya, yacanan manse suwano jotun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús tsantinasanan, yaca pa junlari luilainue. Uyanla mantimini son tinaminlanue ya duque seque quinun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Junni Jesuri tsachilaca micarinato, itsanque cuenta polarinue: —¿Diosi mantananun tsachi bolonca niyaque pantsan jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostasa tinun ni cuwenta jochunae tinue. Mostasa ni tsanini jotonan, witabi wacaito duque seramanhe. Chide pele tsansi seramanhe. Pichula titiya jun alibi tasen quino podeintsancari wa chide pele imanhe tinue. Junni Diosi ya mantananun tsachi bolonca serawonato, jun tsannan quichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aman Jesús jun cuentaca polarisi itsantinue: —Diosi mantananun tsachi bolonla niyan jonunca micarichun in cuentaca polarichinayoe tinue: ");
INSERT INTO cofNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aman sona manca bibu quichunae. Junni man arowa tsansi arina cato, aman lebaduracanan pochunae yape bibu ayancaisa. Junni jera seque palachunae yape lebadura jeralete palaisa. Junni Diosi ya mantananun tsachi bolonca jerale tote serawonato, jun tsannan quichunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Junni Jesús Jerusalenca jinaminnan, pueblolabi micaride nenaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Junni tsachi manca yabe itsanque panhanue: —Miya, ¿se larica junlari narin jolajochunan? tinue. Junni Jesús yaca meráto, itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","—Diosichibi wino tamolan na foro tamolan joe tinue. Junbi wino tenfelaide! tinue. La nulabe tsarasica pachinayoe: Manca mate la, tsacumin joto, jun tamolanca doqueyanae tinue. Junni jun mate duque tsachila wichi tinatonan, podeilaituchunae tinue. Aman nulari urachi puraito otito, Miya, chiquilacanan pocade! latichunae tinue. Junni la, Miya joto, nulaca quiratumanyoe tiyanae tinue. Nunchi nechi jacala jonunca miitoyoe tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Junni nulari beconan pato, nube ano pefiyoe latichunae. Nu chiquilachi pueblobi micarie latichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Junni nula tsanlatinasanan, nulaca pato, nunchi nechi jacala jonunca natiya miitoyoe tiyanae tinue. Nula jeralela seiton quiminla joto, jachi jilaide! tiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Junni nulachi matu to tatalaca Diosi mantananun tsachi bolonbi peranunca quiralaquichunae Abrahanca, Isaaca, Jacóboca. Jerale matu to Diosichi mantate paminlacanan junbi peraminlaca nula quiralaquichunae tinue. Nula mantimini urachi puraicala jochunae tinue. Junbi padeseinato fudachi warelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Junni duque tsachila israelítala itotonan, Diosichibi pewilaichunae tinue. Uyanchi nechi, uyanchi nechi jato, yalanan Diosichibi pewito, mesabi chudito ano pefilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lari nulabe tsarasica pachinayoe tinue: Duque tsachila amana fe jominlatiya jun mate epe tsachila manjolajochunae tinue. Uyanlari amana epe tsachila jominlatiya jun mate fe jolajochunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Junni Jesús tsantinasanan fariséolari jato itsanlatinue: —Nuri sujide! Miya Heróderi nuca totechi tinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Aman Jesús yalabe manpato itsantinue: —Heróderi encanaquica oco joe tinue. Junni meralaquede! Amananan, ayunanan yucanchi ocolaca mansularin, quiyanpunlaca manse suwan, quechinayoe tinue. Junni junhayuna jerano joyoe tinue. Tsannan Diosichi mantate paminla Jerusalénbisiri totailaichunae; junto amana, ayuna, junhayuna Jerusalenca jino joyoe. Junni nulari Heródechica manjito, la pacaca yabe jera manpolarilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aman tsantisi, Jesús camicarinato itsantinue: —Jerusalén puebloca duque laquiito wepananayoe tinue. Aman Jerusalenbi chuminla, nulari Diosichi mantate paminlaca toteminla joe. Diosi nulachica ereca junlacanan su walaca quito toteminla joe. Jana walpa ayanni náca panpe tenpe pocanun cuwenta lachinan nulaca layano muquiminhe tinue. Aman nulari, te, munaralaratiyoe tilatie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Junni amana Diosi nulaca jera telaquepoca joe. La Jerusalenbi winaminca Diosichi mantate janae tilatichunae tinue. Laca tsara sen joe tilatichunae. Junni aman nula Jerusalenla tsantino fecári laca manquiralaquituchunae tinue. Jesús Jerusalenbi chuminlabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Aman mantá tan israelita tsachi Jesuca jasa tica jominue ano pefibi. Junni ya tsachiri fariseo jominue. Aman Jesús yachica jito chusanan, tuwaca jun tsachi manca junbi pewinue. Aman wito, Jesuchi cale wiruraminue. Junte wirurasanan, junbi chuminlari quiranaminlanue jasaino mate Jesús manse suwachunanque, o manse suwatuchunanque. ");
INSERT INTO cofNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Junni israelítala tala mantaca duque miraminlabe fariséolabe Jesuca quiralaquinasanan, Jesús yalabe itsanque panhanue: —¿Diosichi mantá niyan tin? ¿Jasaino mate manse suwano jun, o manse suwano iton? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Junni Jesús tsantinan, yalari nosasa chuniraminlanue. Junni Jesús jun quiyanpunca manse suwaniquito manherenue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aman tsanquetobi, quiranaminlabe itsantinue: —Nulachi wala, o nulachi buro jasaino mate forochi queereinari, jun matenan moorasiri manlarilaquichunae. Tsan jotori, laca pailaituna! tinue jasaino mate tsachicanan manse suwanun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Junni Jesús tsantinan, beco manpano podeilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aman Jesuri fiesta ano fibi pejacalaca quiranaminue. Weyanlari fiesta quiminchi fe quelole chudichi tinaminlanue fe jolajoyoe tito. Junni Jesús junlaca quirato, yalaca micarito, itsanque cuenta quinue: ");
INSERT INTO cofNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Nulaca casalainanun fiesta ano fichun jasa carinari, fiesta quiminchi fe quelole chudilaituna! tinue. Pansileri nulaca fécari respetainun tsachi jachunae. ");
INSERT INTO cofNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Junni fiesta quimin tsachi nulachica jato, nulaca uyanchile manchutechunae tinue. Nu chudica jonunte fe mantá tanlari chudinola joe tichunae tinue. Tsantinari, nula duque luito, uyan postote chudibi manjilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Junni uyan quiraque quintsan jochunae tinue. Nulaca jasa tinari, aman fiesta quinun yabi féto, casale epe postobi chudilaina! tinue. Junni fiesta quimin jato, nulaca amicola tito, ya chunun quelole chudilaide! tichunae tinue. Junni aman jerale fiesta quirabi jaminla quiralaquichunae nulaca fe joe tinaminca. ");
INSERT INTO cofNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aman fe joyoe timinla jeralela epe patilaichunae tinue; fe joyoe tituminlari fe manhilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Junni Jesús fiesta ano fibi jacalabe tsantitobi, fiesta quiminbenan cuenta quito itsantinue: —Nula fiesta ano fimiyatori, amicolaca, acolaca, familialaca, cala tan quiranunlaca jasa carilaquituna! tinue. Aman tsanquinari, yalanan nulaca beconan fiesta quimiyalaquichunae tinue. Beco beco jasa carito, parejo parejo manpatilaichunae tinue. Te, tsanquituntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nulari ano fichun fiesta quinatori, poperelaca, jancanlaca, enconlaca, quirano podeitonlaca jasa carilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yalari beconan fiesta quimiyano podeilaituchunae. Junni Diosichi tsachila puyaca jominnan mansonhino mate Diosiri nulachi beconan mancuwachunae tinue. Tsanque nulari duque pansi jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aman tsachi manca jun fiestate ano pefito chuminnan, Jesuchi fiquica meráto itsantinue: —Diosi mantananun tsachi bolonbi ano pefiminlari duque pansi jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Junni Jesuri yaca meráto itsantinue: —Diosi mantananun tsachi bolonbi pewino itsanqueri jochunae tinue: Tsachi manca wa fiesta quito, ano fimiyachunae tinue. Aman yari duque tsachilaca jasa tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Junni aman ano fino órate peyunca erechunae yape jano jominlaca jalaide! tisa. Fiesta ano fichun jera michi joe latichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jerale jano jominla mantimini jatuchi tilatichunae tinue. Manca tsachiri to cato quirabi jino joyoe tichunae tinue. Junto jano podeitiyoe. Nasi perdonaide! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Junsi manca tsachinan chunca wala cato, se jonunca miibi jino joyoe. Junto jano podeitiyoe. Nasi perdonaide! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Junsi manca tsachinan sona cato jano podeitiyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aman peyunni jun fiquica meráto, fiesta quiminchica manjichunae tinue. Junni yari paito, peyunca puebloca manaman erechunae tinue yape uyan tsachilacari jasa tisa. Patron yachi peyunca erechinato, itsantichunae tinue: Cayebi nenato, poperelacanan, enconlacanan, quirano podeitonlacanan, jancanlacanan, tanjade! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Junni peyunni manjato, yalaca tanjaca josanan, ano finun tamo quidi caitoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Junni aman patronni peyunca manan manherechunae tinue yape wa minubinan, na minubinan tsachilaca neyasa. Tsachilaca jasa caride! tichunae yachi yabi yape quidiisa. ");
INSERT INTO cofNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tsarasica pachinayoe tichunae tinue. Casale jasa tica junlari seitonla joto, yala mancatiya lachi yabi fiesta ano natiya pefilaquituchunae tichunae tinue. Jesús tsanque cuenta polarinue ya jatuchi timinlari Diosibe cayaituchi timinla cuwenta jolajoeque. ");
INSERT INTO cofNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Junnasa duque tsachila Jesube pejinaminlanue. Junto quiraereto, yalabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Labe penenachi timinla laca laquiranola jochunae. Tencachique apalaca, ayanlaca, sonalaca, nalalaca, acolaca, soquilaca laquiralaratonan, laca tsaracari fécari laquirantsan jochunae tinue. Tencachiquenan laquiratonan, laca fécari laquiranola jochunae tinue. Laca tsansi laquiratutori, labe penenano podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Corosibi puyano jun tsachi cuwenta jera telaquepoto, labesiri penenanola jochunae tinue. Tsantuchi timinlari labe natiya penenano podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aman ayancan ya quinoca tenca calaquede! tinue. Ya quichi timin tsachi chudito, jera tenca cato miino jochunae nisi mica jono jonunca. Junto yachi jera calacanan michunae michi tanunca miichun. ");
INSERT INTO cofNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aman ya quino nisi mica jono jonunca miituminnan, ya quiniquitori, seitochunae tinue. Quitsa quinasa cala jerainari, deino jochunae. Junni jeralela yachi yaca quirato, lucarilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","In tsachiri quitsari ya quito, jera quino podeitue tito, lucarilaquichunae tinue. Junni labe nasiri penenato peleiminlari jun ya quimin cuwentanan jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O aman miyalaca tenca calaquede! tinue. Miya manca chunca mili soldadolabe quera quicaabi jilaichunae tinue. Junni manca miya palu chunca mili soldadolabe quera quicaachun tulaibi jalaichunae tinue. Junni manca miyari chunca mili soldadolari tato, casale duque tenca cachunae tinue. Yachi mantá tanlabe tenpato miichunae fe lono podeilaiichunanque. ");
INSERT INTO cofNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Fe lono itotori, junto tsachilaca erechunae yape jamiminque cuenta quito se patarisa. Uyan soldadola nuwiri cajalainasanan, tsachilaca yalachica erechunae quera quicaatuchique. ");
INSERT INTO cofNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Junni Jesús tsanque cuenta polarisi, yaca meráminlabe itsantinue: —Labe penenachi timinlari jun ya quimin cuwenta, o jun miya cuwenta jonola jochunae tinue. Seque tenca catobi, lachi tenchi jera ticatiya telaqueponola jochunae tinue. Tsanquituminla labe penenamin ino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Pinba epeban ica jun cuwenta jolajochunae. Jana pinba sen joe tinue. Junni pinba epeban inari, niyanquinatotiya saruba mansuwano podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Epe jochunae. Sen abono itochunae tinue witabi pochun. Queponiquintsan jochunae tinue. Junni nulari punqui chunla jotori, seque meralaquede! tinue. Jesús tsachilaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Seiton tinunlari Jesuca meráchun yachite layainaminlanue. Weyanlari uyan to miyachi tenchi inpuesto cala camin jominlanue. Weyanlari israelítalachi mantaca tennatumin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Junni fariséolabe mantaca micariminlabe miilainue seiton tinunlari Jesúchica jalainaeque. Aman junca miito, Jesúcanan paito, yaca seitonque palaquinue. Ya tsachi seitonlabe penenan, ano pefin, quimin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Junni Jesuri yaca paiminlabe itsanque cuenta polarinue: ");
INSERT INTO cofNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Patsa opisa tan tsachi opisa mancaca piyaritori, moora manneyabi jichunae tinue. Weyan opisaca epele purato, topiyato nenaminca manneyabi jichunae tinue yaca manfeno fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Aman manfetobi, nanato mantanjato, duque son tichunae tinue. Junni amicolacanan, quiranunlacanan layaisa carito, labe son tilatina! tichunae tinue opisa topiyaca junca manfeyoeque. ");
INSERT INTO cofNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aman junni Jesús tsanque cuenta polarisi, yaca meráminlabe itsantinue: —In seiton quiminlari ya topiyaca jun opisa cuwenta jolajoe. Yala manca jutsa quinunca telaquepoto casan tenca mancanari, Diosichibi duque son tintsan jochunae. Senla mantimini jutsaca telaquepono munaratuntsan joe. Junni duque tsanlaca Diosichibi son tinatonan, jutsaca telaquepomin mancacari fécari duque son tintsan jochunae tinue. Jesús tsanque cuenta polarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Junto aman Jesús tsachilaca micarichun manca cuentaman polarinue. Itsantinue: —Sona manca chunca cala tachunae tinue. Junni ya calari duque mica cala jochunae tinue. Junto mancaca piyaritori, ¿duque neca manneyachunaco? tinue. Lanparin tulito, tapenan casito, duque neca neyachunae ya calaca manfeno fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Junni calaca manfetobi, duque son tichunae tinue. Amicalacanan, quiranunlacanan layaisa carito, chiquebe son tilatina! tichunae tinue cala piyaca junca manfeyoeque. ");
INSERT INTO cofNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Junni Jesús tsanque cuenta polarisi, yaca meráminlabe itsantinue: —Tsachilari jun cala cuwenta jolajoe tinue. Junni jutsa quinunca telaquepoto, casan tenca mancamin mancaca Diosichi anjelila son timinla joe tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Junni Jesuri micarinato, manca cuentaman polarinato itsantinue: —Aman tsachi manca paluca naola tachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nanni nacan nao yachi apabe itsantichunae: Apa, chiquila jera tanunca quitsaleto, lachi erensia jono jonunca amananan lachi cuwaniquede! tichunae tinue. Junni tsantinan, yachi apari aman jera tanunca quitsaleto cuwachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aman inale nanni nacan nao jera tanunca osito, cala catobi, bare toca jichunae tinue. Junni ya tsachiri junbi seitonque nenato, calaca moorasiri jera piyarichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Junni jerale jun tobi ano michi itochunae. Junni junbi yanan ano fituto padeseichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Junni padeseinato, jun tobi tsachi máncachi peyun ichunae. Yari fincaca erechunae tinue yape cuchi cuidaisa. ");
INSERT INTO cofNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Junni duque ano muquinanan, yari cuchisiri finun anocanan sen jonhoe tito, fichun jochunae tinue. Junni monantiya yachi cuwatuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Junni ya nao michi padeseinaminnan, itsanque tenca cachunae: Lachi apachibiri peyunlanan ano finocari puchu michi talarae tichunae tinue. Aman lari inte ano mochi puyachinayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Junto aman cupato, apachica jito, yabe itsantiyanae tichunae tinue. Apa, jutsa quiyoe tiyanae. Diosichi cale, nuchi cale jutsa quiyoe tiyanae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aman seiton jonan, laca nuchi nao tituna! tiyanae. Laca peyun nasi suwade! tiyanae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Junni tsantisi, ya naori cupato, yachi apachica manjichunae. Junni bare quirasanbi janaminca quirato, yachi apari yaca laquirato, yachica tulaibi sujito, ya naoca amanto motito saludaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Junni naori Apa tichunae. Lari Diosichi cale, nuchi cale jutsa quiyoe. Amana la seiton jonan, laca nuchi nao tituna! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Junni nao tsantinasaleri, apari peyunlaca itsantichunae tinue: Fécari sen camisaca tanjato, lachi naoca pocarilaquede! Aniyonan yachi temisubi pocarilaquede! Sapatonan yachi nedebi pocarilaquede! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mulu suwanaca jun walaca tanjato totelaquede! Ano fito, fiesta quilaquisa! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Lachi nao puyaca jominnan, mansonhica cuwenta joe. Topiyaca nenato manfae tichunae tinue. Junni fiesta quilaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Junnasari ya tsachichi caque nao itochunae tinue. Witabi nenachunae tinue. Junni ya manjanato, musica meráchunae tinue. Teranaminlacanan meráchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aman yari peyun mancaca otito panhachunae niyaito tsanlainanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Junni peyun beco pato itsantichunae: Nuchi aco manjacae tichunae tinue. Jun tenchi nuchi apa son tito fiesta quinae. Mulu suwanaca jun walaca toteto, fiesta quilaquinae tichunae tinue seque manjae tito. ");
INSERT INTO cofNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aman caque nao mantimini paito, tamochi wituchi tichunae tinue. Junni yachi apari lato, yabenan rocaichunae yape wiyasa tito. ");
INSERT INTO cofNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Junni yari yachi apabe itsantichunae tinue: Meráde! Lari nube duque wata trabajaquimanyoe. Lari nuchi fiquica man netiya merán iton itomanyoe. Nuri la tsan jonan, lachi nin chibo mancatiya cuwatumin joe yape lachi amicolabe fiesta quisa tito. ");
INSERT INTO cofNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Junni nuri lachi tinantiya cuwatumin jotonan, nuchi tsanquira quimin naochi tenchi sen walaca toteniquito fiesta quinae tichunae tinue. Nuchi calaca cato, jera piyarinue tichunae tinue niyan unilalabetiya seiton imin sonalabe nenato. Tsanni ya manjanunsiri yachi tenchi fiesta quinae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Junni apari yachi naobe itsantichunae: Nao, nu numasitiya labe parejo pejoe. La jera tanun nuchiri joe. ");
INSERT INTO cofNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Junni wepanatuna! Inni nuchi aco joe. Puyaca cuwenta jominnan, mansonhica cuwenta joe. Topiyato nenato manfae. Junni jun tenchi son tito fiesta quino joda tichunae tinue. Jesús tsanque cuenta quito micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Junni man nete Jesús yabe penenaminlaca micarinato itsanque cuenta quinue: —Aman oco tsachi manca jochunae tinue. Junni yachi mayordomo seiton joto, yachi calaca piyarichunae. Aman junca meráto, ");
INSERT INTO cofNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","mayordomoca jasa carito, itsantichunae tinue: La nuchi tenchi duque seiton fiquica meranayoe tichunae tinue. Junni cuenta jera laride! Nuri nantari mayordomo itochunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Junni aman mayordomori wepanato, itsanque tenca cachunae: Patron laca mayordomo suwatununbi, ti quino joinhinque tenca cachunae. To towano podeituto, lemosi cala panhano lurayoe tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aman mirayoe tichunae tinue ti quino jonunca. La tenca oco jonari uyanla laca facarilaquichunae mayordomo manloca mate. ");
INSERT INTO cofNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Junni mayordomo tsanque tenca catobi, patronchi neloraminlaca jasa tichunae tinue. Aman manca neloraminbe cuenta quito, ¿Lachi patronchi nisi nelorayun? tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Junni yari ochu patsa calon aseite nelorayoe tichunae tinue. Junni mayordomori itsantichunae: Ochu patsa neloratonan, junpalu patsacari mancuwana! Nen, nuchi letra cade! Ochu patsa chuminca piyarito, junpalu patsacari manchutede! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Junni aman mancabenan jun tsanquenan panhachunae: ¿Lachi patronchi nisi nelorayun? tichunae. Aman yari patsa quintali trico nelorayoe tichunae tinue. Junni mayordomori itsantichunae: Patsa neloratonan, ochu chuncacari mancuwana! Nen, nuchi letra cade! Patsa chuminca piyarito, ochu chuncari manchutede! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Junni aman patronni junca miichunae tinue. Junni junca miito, ya seiton mayordomoca tenca oco jocachiri jominue tichunae tinue. Junni Jesús yachi tsachilaca tsanque micarisi, itsantinue: —Diosica tennatuminlari ya mayordomo cuwenta jolajoe tinue. Yala tala necosio ticatiya quinato, Diosibe penenaminlacari fécari tenca oco jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jun tenchi la nulaca itsanque payichinayoe tinue: Ya mayordomo ya seiton calaca tencabe nenato, ya calachi amicola suwaca jochunae yape cala itono mate yaca facarilaquisa. Junni nulanan calaca tencabe nenalarana! tinue. To jeraino mate cala itochunae. Junni calachi Diosichi cosa quilaquina! tinue yape Diosi jun mate nulaca yachi jeraitunun tobi facarisa. ");
INSERT INTO cofNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Meralaquede! Mica itonunca seque cuidaiminlari mica jonuncanan seque cuidailaichunae. Mica itonunca tarinminlari mica jonuncanan tarinlaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Calari epenan joe. Mica iton cuwenta joe. Junni calaca seque cuidaitunari, Diosi fe senca nulachi cuwatuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Diosiri nulachi tsara senca cuwachi tinae tinue yape tsa tsacumin jolajosa. Tsanni uyanchi jonunca seque cuidaitunari, tsa tsacumin isa numanan cuwatuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Paluca patronlabe mantainun cuwenta jochunae. Junni monantiya paluca patronlabe mantaino podeilaituchunae tinue. Mancacari seiton joe tito, uyanca sen joe tilatichunae. O mancaca meráto, uyanca meralaquituchunae tinue. Junni jun tsanquenan Diosica tenca camin jotori, calaca munaito quiratuntsan joe. Calaca munaito quiranatori, Diosica seque tennano numanan podeilaituchunae tinue. Jesús tsanque payinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Junni fariséolari calaca duque munapunla joto, Jesuchi fiquica cacarito meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Junni Jesús yalabe itsantinue: —Nulari duque tenfeminlae yape uyan tsachila nulaca sen jolajoe tilatisa. Aman nulachi tencabi mantimini Diosi mirae tinue. Tsachila duque sen joe tinunca Diosi ti quiran seiton joe timin joe tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Junni Jesús camicarinato itsantinue: —Matu mate Diosi yachi mantaca chutesa carinue. Junsi yachi mantate paminlanan yachi pila chutelaquinue tinue. Aman yalachi fiquica Mumunmin Juan jano fecári merántsan jominue tinue. Junni ya janunle nechi mantimini casan fiquica merántsan joe. Diosiri ya mantananun tsachi bolon suwanaeque micarica fiquica merántsan joe tinue. Junni duque tsachila ya fiquica meráto, jun bolonbi pewichique tenfelainae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Junni tsan josanan Diosichi mantá pilari natiya epe ituchunae tinue. Aman yoquidobe, tobe jeraica josatiya, Diosichi mantári natiya epe ituchunae tinue. Jesús tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Junni Jesús micarinato itsantinue: —Aman tencachique sonaca purato, uyan sona mancaminlari seiton quiminla jochunae tinue. Puraca jun sonaca mancaminlanan, yalanan seitonque quiminla jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Junni Jesús manca cuenta polarito itsantinue: —Tsachi manca duque oco jochunae tinue. Yari uraran sen camisa poto, ma cura sen anori fimin jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Junni yachi sela tamolante popere tsachi manca tsomin jochunae tinue Lázaro mumun. Yari duque bichi chun jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ya oco tsachichi ano puchuicaca fichique tsochunae. Junni susu jato, yachi bichica milanchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Junni aman Lázaro puyachunae. Junni anjelila patato, yachi tencaca tanloto, senbi chutelaquichunae matu to Abrahanbe. Junni oco tsachinan puyato, menaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Junto aman puyan ocolachibi duque pasainato, jamochi bareca quirato, Abrahanbe Lázarobeca quirachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Junni yalaca quirato, matu to tata Abrahanca otito, tata Abraham tichunae. Laca laquirade! Lázaroca erede! yape temisu puntaca pibi poto, lachi nicaca taquirasa yape lachi nasi isanle tenjasa. Lari in ninbi duque padeseinayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Junni Abrahanni yachi alica padeseinaminbe itsantichunae tinue: Nuri matuca mantenhide! Cason jominnan, nuri jera sensiri taminue. Lázarori padeseito sonnaminue. Amanari yari pansi josanan, numan padeseinae. ");
INSERT INTO cofNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tsan josanan, Lázaro nuchica jichi timanpari, podeituno jomin jonhoe tichunae tinue. Wa foro quica joe. Natiya poletuntsan joe. Inte nechi nulachica, o nulachibi nechi inchi, natiya pola jatuntsan joe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Junni matu to Abraham tsantinunsi, oco jomin tsachiri beco pato, itsantichunae tinue: Tata Abraham, Lázaroca inchi ereno podeitutori, lachi apachica erede! ");
INSERT INTO cofNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","La manteca acola tayoe. Junni Lázaroca yalaca payisa erede! tichunae tinue yape yalanan inte la padeseinanun postoca jalaitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Junni oco jomin tsachi tsantinan, Abraham beco pato itsantichunae tinue: Te, eretiyoe. Nuchi acola Diosichi Pilaca talarae. Yalari yaca quirato merántsan joe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Junni oco jomin tsachinan beco pato itsantichunae: Te, Diosichi Pilacari yalari tennatulajochunae tichunae tinue. Tsan jotonan tsachi manca puyaca jomin mansonhito, yalachica jinari, yaca meralaquichunae tichunae tinue. Yaca meráto, jutsa quinunca jera telaquepoto, casan tala tenca mancalaquichunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Junni Abraham manaman manpato, itsantichunae: Diosichi Pilaca tennatutori, puyato mansonhimincanan tennalaratuchunae tichunae tinue. Jesús tsachilaca micarinato ya cuentaca polarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aman Jesuri man fiquiman micarinato yachi tsachilabe itsantinue: —Jutsa quisa cariminlari numasitiya junnan jolajochunae. Tsan jotonan, yalari duque padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tsachi mancaca wa ila suca teleto wa pipilubi queponari, jadito puyachunae tinue. Duque padeseichunae. Aman cumana tenca tanlaca jutsa quisa cariminlari junca fécari padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Junni tencabe nenalarana! Junsi Jesús itsantinue: —Tsachi manca nulaca jutsa quinari, yaca payilaquina! tinue. Junni jutsa quinunca telaquepoto casan tala tenca mancanari, yaca perdonaintsan joe. ");
INSERT INTO cofNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aman man malon siete ne nulaca seiton quito, siete neca ya jutsaca telaqueponan perdonaide! tinari, yaca perdonaintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Junni Miya Jesuchi mantá tanlari yabe itsanlatinue: —Chiquilacari Diosica fécari quereisa caride! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Junni Miya Jesús yalabe itsantinue: —Nulari Diosica case natiya quereitumin jolajoe. Nula nasi sele quereiminla jotori, ticatiya quino podeilaichunae tinue. Aman in chide peleca telenlebe muraito, wa pipilubi wacaideque mantanari, tsanhichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Junni Jesús micarinato itsantinue: —Aman peyun wita quito manjanaminca, o opisa cuidaito manjanaminca, ¿yachi patron niyan tichunan? tinue. ¿Wiyato, chudito, ano fide! tichunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Te, tsantituchunae. Casale lachi anoca daquede! tichunae tinue. Junsi seito, ano poto, lachi cuwade! Junni la finunbi numan fina! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Junni patronni mantanunca meránun tenchi peyunbe acradeseituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Junni nulari Diosichi peyun cuwenta jolajoe tinue. Junto Diosi jera mantaca junca quitonan, sen jolajoyoe tituntsan jochunae tinue. Mantanuncasiri quito sen peyunla itolajoyoe tintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Junni Jesula Jerusalenca jinato, Galiléabi nechi loto, Samáriase polenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Junni pueblo máncabi winasa, chunca tsachila yabe tulaibi jalainue. Yalari lepra bichi chunla joto, jabi nechi ");
INSERT INTO cofNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sonba pato, Miya Jesús latinue. Nuri chiquilaca laquirade! latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aman Jesuri yalaca quirato, yalabe itsantinue: —Israelita patelelachica jilaide! tinue yape nulaca quirato manse icala joe tilatisa. Aman ya quiyanpunlari patelelachica jinaminleri, lepra bichi jera manseilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Junto yalabe jominla mancari manseiyoeque tenhito, Jesúchica manjanue. Yari sonba pato, Diosica duque se tide manjanue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Junni yari Jesuchi cale tobi mutsaito, yabe acradeseinue. Aman jun acradeseimin tsachiri israelita itominue; Samaria to tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Junni Jesuri yaca quirato, itsantinue: —Chunca tsachila manseica jotonan, in mancasiri acradeseibi manjaca joe tinue. ¿Weyanlari niyaito manjalaitun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Insiri uyan to tsachi jotonan, Diosibe acradeseibi manjacae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús jeralelabe tsantitobi, tobi mutsaraminbe itsantinue: —Manwiruito jiniide! Nuri Diosica tennato manseie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Junni fariséolari Jesube panhalaquinue Diosi numasi ya mantananun tsachi bolon suwano jonunca. Junni Jesuri yalaca meráto itsantinue: —Diosi ya mantananun tsachi bolon suwanasa, quirasa itochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Inte Diosi mantananun posto joe tituntsan jochunae tinue. O Juntenan Diosi mantananun joe tituntsan jochunae tinue. Meralaquede! Nulachi tencabi Diosi mantananun posto joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Junni Jesuri yachi tsachilaca chicante itsanque micarinue: —Manca mate nulari laca duque manquirachi latichunae. Laca, tsachi ica jun jominca, man malon nacátiya manjasa munaralarachunae tinue. Junni tsan josanan, camanjaca itoanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aman jun mate weyanlari nulabe pato, quiralaquede! Laca inte rae tilatichunae tinue. O junte rae latichunae. Junni tsanlatinasanan, natiya quirabi jitulajona! tinue. Tsantiminlabe natiya pejitulajona! ");
INSERT INTO cofNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jana cunta pindaca tenca calaquede! tinue. Cunta pinda quinasa, jeralete quirasa imanhe. Yoquido titiya jera tsenhimanhe. Fechi nechi pelechi fecári tsemanhe. Aman la tsachi ica jun joto manpatano mate jun tsannan jochunae. Jeralete quirasa iyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Junni tsan josanan casale in tsachilari laca seitoe tito, duque padeseisa carilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Junni Jesús camicarinato itsantinue: —Matu to Noeca tenca calaquede! tinue. Lari tsachi ica jun joto manpatano inasa, Noé sonnanun mate cuwenta jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé sonnanun materi tsachilari pansi chuniraminlanue. Ano fin, ticatiya cuchin, sona can, unila quin, quinaminlanue. Ya Noeri barcobi wino ma fecári tsanque pansi chuniraminlanue. Junnasa quiranari mapiya janan, jerale tsachila puyalainue. Junni la manpatano inasa, tsachilari jun tsanquenan pansi chunilarachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Junni matu to Lot tinun tsachi sonnanun mate cuwentanan jochunae tinue. Jun matenan ano fin, ticatiya cuchin, titiya can, osin, wita quin, ya quin, quinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Junni Lótilari jun Sodoma tinun pueblobi nechi lonunsi, jeralela puyalainue. Jun mate asufrebe ninbe niyato puyalainue. Yari jamochi nechi patato jeralelaca totenue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aman la manquiraino mate jun cuwentanan jochunae tinue. Tsachilari padeseino jonunca natiya tenhituto, pansi chunilarachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aman jun mate wewe sujinola jochunae. Ya jamobi raminlari tamochi ticatiya tanunca mancábi wituminnan, sujinola jochunae tinue. Witabi raminlanan yaca manjituminnan, sujinola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lótichi sonaca mantenhilaide! Chunun puebloca laquichi manquiraereto puyanueque mantenhilaide! ");
INSERT INTO cofNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tenca munate pansi chuchique tenfeminlari jera piyarito puyanilaichunae tinue. Aman tsanque chunoca telaquepominlari numatotiya seque chuto polenilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Junni meralaquede! La manpatano ma quepen paluca tsachila manca lowabiri catson tsolarachunae tinue. Junni mancaca tanjinan, mancari puraichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O paluca sonala ticatiya ilinaminlaca mancaca tanjinan, mancari puraichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","O paluca tsachilari witabi raminlaca mancaca tanjinan, mancari puraichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Junni Jesús tsantinasanan, yachi tsachilari Miya, ¿nunchi tsanhichunan? tilatinue. Junni Jesuri beconan pato itsantinue: —Tiletiya animali puyanari, junteri barola layaito jalaichunae. Jun tsanquenan tiletiya jutsa quinanari, juntenan casticaquintsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Junni Jesús in cuentaca polarichinayoe tinue tsachilari pele tenca ituto Diosibe rocainola joeque micarichun. ");
INSERT INTO cofNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Itsantinue: —Pueblo máncabi comisario jochunae. Diosicanan, nin tsachilacanan tennatumin jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aman jun pueblobinan biuda manca chuchunae tinue. Uyan tsachila yaca juisio quiminla jochunae. Junni ya biudari comisariochica duque neca jito, feichun rocaichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Aman casaleri comisariori ayudaituchi tichunae tinue. Junni michi rocainasanan, comisariori itsanque tenca cachunae tinue: Ya biudari duque pasuwamin sona joe tichunae. Yaca ayudaitunari, laca nantanancari pasuwachunae. Junni Diosicanan, tsachilacanan tennatumin jotonan, yaca ayudaichinayoe tichunae tinue yape nantari pasuwatusa. Ya comisariori tsanque tenca cachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Junni Miya Jesús jun cuentaca polaritobi, itsantinue: —Seiton comisario paca jun fiquica meráto, tenca cato miilaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Aman Diosi wenteca junla quepen, malon Diosibe rocaiminla joe tinue. Junni jun comisario seiton jotonan jun biudaca ayudainue tinue. Junni Diosi sen joto, nantanancari ayudaichunae tinue. ¿Yari wanhichunan? Te, Diosi natiya wanhituto, yachi tsachilaca wewe ayudaichunae tinue. Junni tsan josanan la tsachi ica jun joto manpatanasa, tsachilari Diosica seque quereimin itolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aman weyan tsachilari sen jolajoyoe tito, uyanlaca seitolajoe timin jominlanue. Aman tsantiminlabe Jesuri cuenta polarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Itsantinue: —Aman paluca tsachilari Diosibe rocaibi Diosichi yaca jilaichunae tinue. Manca fariseo jochunae. Manca inpuesto cala camin tsachi jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Junni fariséori wiruito, Diosibe rocainayoe tito, itsantichunae: Diosi, la nube acradeseinayoe tichunae uyanlaca fe sen joyoeque. Tarintumin joyoe. Seiton quitumin joyoe. Uyanlachi sonaca catumin joyoe. Ja inpuesto cala caminca fe sen joyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tominco cura palu ma Diosichi tenchi ano fitunca imin joyoe. Chunca ticatiya cato, Diosichi manca cuwamin joyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Junni fariseo tsantinasanan, inpuesto cala camin tsachi jabile wirurachunae. Aman jamochi quirano lurato, jutsa quinunca telaquepochi tito, Diosibe itsanque rocaichunae tinue: Diosi, lari jutsa quimin joyoe. Laca laquirade! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Junni aman meralaquede! tinue. Ya inpuesto cala camin tsachiri jutsa piyarica jun manjichunae tinue. Fariséochi jutsaca mantimini piyarituchunae tinue. Sen joyoe timinlaca Diosi seitolajoe tichunae tinue. Sen joyoe tituminlaca Diosi sen jolajoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Junni weyan tsachilari tsotsoca nalalaca tanjanaminlanue yape Jesús yalaca tedechi tale quisa tito. Junni Jesube penenaminlari junca quirato, nalalaca tanjatusa tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Junni Jesuri yalaca jasa carito, tsachilabe itsantinue: —Nalalaca lachica jasa carinilaquede! tinue. Nalalaca natiya jatusa caritulajona! Yala tsan tsachilasiri Diosi mantananun tsachi bolonbi jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nulabe tsarasica pachinayoe tinue. Diosi mantananun bolonbi nalala cuwenta witutori, numanan wilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Junni aman mantamin tsachi manca Jesube itsantinue: —Nu sen joto micarimin joe; junto labe pade! tinue. Lachi numatotiya Diosibe sonnato poleno muquee. ¿Junni lari niyan quino jowan? numatotiya sonnato polechun. ");
INSERT INTO cofNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuri yaca meráto, beco manpato itsantinue: —¿Niyaito laca sen joe tiyun? Diosisiri sen joe. ");
INSERT INTO cofNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aman nu Diosichi mantaca mirae tinue. Uyan sonalabe nosa seitonque nenatulajonaque, tsachilaca totelaquitunaque, tarinlaquitunaque, uyanlaca nene patulajonaque, apabenan ayanbenan sen jolajonaque mantaca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Junni Jesuchi fiquica merasi, ya tsachiri itsantinue: —Na mánta ya mantaca jera meráto nenamin joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Junni Jesús junca meráto itsantinue: —Nuri man cosa quino cajoe tinue. Nu ticatiya tanunca jera osito, poperelachi cuwana! Aman tsantori, nu Diosichi tobi duque senca tachunae tinue. Junto aman calaca jera cuwatobi, lachica manjato labe penenana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Junni ya tsachiri Jesuchi fiquica meráto, duque laquiinue. Yari duque ticatiya tan tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Junni Jesuri ya tsachica seque quirato, itsantinue: —Fe oco tsachilari Diosi mantananun tsachi bolonbi pewino duque tenfe jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Meralaquede! Cameyo acusa forose numanan poleno podeituchunae tinue. Aman fe oco tsachila Diosi mantananun bolonbi pewino fécari tenfe jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Junni Jesús tsantinunca meráminlari itsanlatinue: —Junni oco tsachilatiya wino podeilaitunari, monantiya se lono podeitulajoanae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aman Jesuri beconan pato itsantinue: —Tsachilari tenca mánta ino podeitununca Diosiri isa carino podeichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Junni Jesús tsantinunsi, Pédrori yabe itsantinue: —Meráde! Chiquilari nube penenachun jera tanunca puralaquiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aman Jesunan yaca meráto itsantinue: —Nulabe tsarasica pachinayoe tinue. Weyan tsachilari Diosi mantananun tsachi bolonca suwachun ticatiya jera puralaquichunae tinue. Junni jerale tsanque puraminlari fécari mancalaquichunae tinue. Chunun yaca, o sonaca, o acolaca, o soquilaca, o apaca, o ayanca, o nalalaca purato jiminlari in totenan fécari mancalaquichunae tinue. Junni in tote tsanque duque mancatonan, to yucapiyarinunbi numatotiya Diosibe sonnato polelaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesuri yabe chunca paluca penenaminlaca chican larito, yalabe itsantinue: —Matu tote Diosichi mantate paminlari laca pila chutelaquinue. La tsachi ica jun jominca duque pila chutelaquinue niyanhino jonunca. Junni aman chiquila Jerusalenca jinan, yala paca jun fiqui jera tsa patichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Israelítala laca uyan to tsachilachi cuwapolaquichunae tinue. Yalari aman laca lucarin, yucacuran, pipichi quin, ");
INSERT INTO cofNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","asotaquin, quito totelaquichunae tinue. Tsanquica josanan, lari peman mate mansonhiyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesuchi tsachila mantimini jun fiquica tuilaitunue. Diosinan camiisa caritunan, yalari tuilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Junni Jesula Jericó pueblobi felainasa, quirano podeiton tsachiri minute chuto lemosi cala panhanaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Duque tsachila polenaminlaca meráto, yari yalabe panhanue niyainanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Junni yalari Jesús Nasareno polenae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Junni ya quirano podeiton tsachiri Jesuca otito itsantinue: —Miya Jesús, nu matu to miya Davichi alica joto, laca laquirato ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Junni caque jinaminlari yaca paito, Tsanque patude! Nosasaide! tilatinasanan, ya quirano podeiton tsachiri nantanancari sonba otito, Miya Davichi alica, laca laquirato ayudaide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Junni Jesús jinaminnan wiruito, ya quirano podeitonca tanjasa tinue. Junni yaca quelole tanjanan, Jesús yabe panhato, ");
INSERT INTO cofNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Nuca niyan quisa tenjan? tinue. Junni quirano podeiton tsachiri yaca Miya tito, manquirano podeino muquee tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Junni Jesús yabe itsantinue: —Nu quirano manpodeie tinue. Nuri laca tennato manseie tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aman tsantinunsi, manquirano podeinue. Junto Jesube penenamin ito, Diosica duque se tinaminue. Jeralela yaca quirato, yalanan Diosica se tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Junni Jesula Jericó tinun pueblose polenasa, ");
INSERT INTO cofNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","duque cala tan tsachi manca janue. Yari Zaqueo mumun jominue. Yari inpuesto caminla tala mantá tan jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Junni ya tsachiri Jesuca miichun quirachi titonan, podeitunue. Duque tsachila minute quirato wiruraminlanue. Junni Zaquéori na uni joto, weyan tsachilachi jamose Jesuca quirano podeitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Junto aman Jesuchi cachi sujito poleto, sicomo tinun chide pelebi lonue. Aman Jesuri junse poleno jominue. Junni Jesuca quirachique ya chide pelebi lonue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aman Jesús jun chide pele quelo fenaminnan, jamochi quirato, Zaquéoca itsantinue: —Zaqueo, wewe manpatade! tinue. Amana la nuchi yaca moora chubi jino joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Junni Zaquéori jun fiquica meráto, wewe manpatato, Jesuca son tito facarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Junni tsanhinanunca quiraminlari paito, yala tala itsanlatinue: —Jesuri jutsa quiminchicatiya jinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Junni Zaqueo mantimini wiruito, Miya Jesube itsantinue: —Miya, meráde! tinue. La tanunca man quitsa poperelachi cuwachinayoe tinue. Junsi encanato tarinca junlachi junpalu tsansi mancuwachinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Aman Jesús Zaqueo paca fiquica meráto, painaminlabe itsantinue: —Nulari pailaituna! tinue. In tsachiri matu to Abrahanchi alica joda chiquila cuwenta. Junni meralaquede! Lari tsachi ica jun joto seitonlaca se laribi jacayoe tinue. Jutsa quito topiyaca jun nenaminlaca neyato, se laribi jacayoe tinue. Junni amana in tsachicanan se lariyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aman Jesús Jerusalén quelote jinaminue. Junni weyanla junca quirato, Jesuca moora miya ino jonhoe latinue. Diosi ya mantananun tsachi bolon jera serawonan, Jesús yalachi miya ito mantano jonhoe latinue. Junni Jesús junca tenhito, tsachilaca micarinato manca cuenta polarinue. Yaca moora in tote miya ino joeque tenca catusa itsanque ");
INSERT INTO cofNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","cuenta polarinue: —La mantá tan tsachi cuwenta joanae tinue. Junni ya tsachiri ya chunun tobi miya ino jochunae tinue. Junto miya ibi bare toca jichunae yape yaca miya suwasa. Junni la inte nechi jito manjano jonun cuwenta, ya tsachinan miya itobi manjachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Junni jun tsachi jichinato, chunca peyunlaca jacarito, yalachi cala cuwachunae tinue. Mancachi mancachi duque cala cuwanato, itsantichunae tinue: La manjano fecári in calachi necosio quilaquinana! tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Junni aman bare toca jinasa, yachi tobi chuminla weyanlari yaca pa jolajochunae. Junni pa joto jun bare toca fiqui erelaquichunae tinue ya tsachica miya suwatudeque. Ya tsachibe mantaino muquetue tilatichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Junni tsanlatinasatiya, ya tsachica miya suwaniquichunae. Junni miya ito manjatobi, cala cuwaca jun peyunlaca jera manjasa carichunae nisi canaica jonunca miichun. ");
INSERT INTO cofNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Junni caque peyunni yachi cale jato itsantichunae: Miya, ¿nuri lachi duque cala cuwaco? Lari junca chunca tsansi suwacayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Junni miyari junca meráto, nuri seque quinue tichunae tinue. Sen peyun joe. Nuri nasiri calaca seque cuidaimin jominca cobernadori suwachinayoe. Nuri chunca puebloca mantamin jochunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Junsi aman benete peyunni miyachi cale jato, Miya tichunae. ¿Nuri duque cala cuwaco? Aman lari junca mante tsansi suwacayoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Junni miyari junca meráto itsantichunae: Nucanan cobernadori suwachinayoe. Nuri manteca puebloca mantachunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Junsi manca peyunman jato, Miya tichunae. Lari nuchi calaca panuchi coloto seto tamanyoe. Nen, nuchi cala tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Lari nuca jele tiyoe. Nuri duque sonba necosio quimin tsachi joe. Nuri uyanlachi calaca pecamin joe. Nuri uyanla waca junca pemancamin joe. Junni lari nuca jele tito, natiya necosio quitiyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Miya mantimini jun peyunbe itsantichunae tinue: Nuchi fiquichinan nuca culpa quechinayoe tichunae. ¿Nu laca duque sonba necosio quimin joe titiyun? ¿Laca uyanlachi calaca pecamin joe titiyun? ¿Laca uyanla waca junca pecamin joe titiyun? tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aman nuri laca tsanque tenca catori, lachi calaca bancobi pontsan jominue. Junni la manjatobi, calabe interebenan mancano jomin joinhie tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Junni aman miyari junte raminlabe itsantichunae tinue: Yachi calaca josoleto, fécari duque tanchi cuwade! tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Junni yalari beco pato, Miya, yari numa duque tae latichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Junni miyari manpato, itsantichunae tinue: Meralaquede! Jerale taminlachi fe cuwanan, nantanancari duque talarachunae. Itonlachi mantimini nasi tanuncatiya josolenan, natiya iton ilaichunae tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Junni ya miyari tsantisi, man fiquiman pato itsantichunae tinue: Ya calaca josoletobi, man cosanan quino cajoe. Laca pa joto miya itusa tinaminlaca intele tanjato, lachi cale misuca butunto totelaquede! tichunae tinue. Jesús tsanque cuenta polarinue yari jun miya cuwenta joichunae tito. ");
INSERT INTO cofNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Junni Jesuri jun cuentaca polaritobi, Jerusalenca cajiniinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aman jinaminnan, Olibo du quelote felainue. Aman Olibo du nanle paluca pueblo jominue Betfagé manca, Betania manca. Jun pueblo quelo féto, Jesuri yachi tsachila palucaca junchi erenue. Yalaca erechinato, itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Ja pueblobi wilaide! tinue. Junni junbi wisi, buro na tela junca quiralaquichunae tinue. Ya burori monantiya cachuditunun jochunae tinue. Yaca wolecato, inchi tanjalaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Junni uyan tsachilari nulabe panhato, ¿Ti quichun buroca wole calaquinayun? latinari, Miya buroca munarae tilatina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Junni Jesús ereca junlari jun pueblobi wito, Jesús paca jun fiqui tsanquenan patinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Junni buro náca wole calaquinasa, tsacuminlari ¿Yaca ti quichun wole calaquinayun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Junni yalari Miya munarae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Junto buro náca Jesúchica tanjato, yalachi tsanpaca burobi nancarito, aman Jesuca junbi chutelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Junni Jesús burobi chudito jinasa, yalachi tsanpaca minubi lowalaquinue yape Miya jananun minu uraran josa. ");
INSERT INTO cofNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Junni Jesube duque yabe penenaminlabe Jerusalén quelo jinato, Olibo tinun du polelainue. Jun du patalainato, jeralela son tito sonba pato, Diosica se tilatinue seque wepanato quirantsancari quinanunca quiralaquiyoe tito. ");
INSERT INTO cofNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Junni itsanlatinue: —Miya janae latinue. Miya Diosichi mantate janae. Yacari seque pantsan joe latinue. Junsi Diosichibinan son tito, yaca duque mantá tan joe tintsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aman junni weyan fariséolari junte pejoto, ya tsachila tsantinaminlaca meráto, Jesube itsanlatinue: —Nuri yalaca micarimin joto, mantaquede! yape nuca tsanque epe palaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Junni Jesuri yalabe beconan pato, itsantinue: —Lari nulabe tsarasica pachinayoe tinue: Inlaca nosasaisa carimanpari, sutiya sonba pato laca se tino jomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Junni Jesús Jerusalén pueblo quelo féto, jun puebloca laquiito wareto ");
INSERT INTO cofNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","itsantinue: —Nulari wepanatuto pansi chuchun niyan quino jonunca natiya miitolajoe tinue. Amanatiya nulaca junca mirasa tenjae tinue. Tsan josanan, nulari, te, tuino podeilaitue tinue. Nulari numa caca itonla cuwenta jolajoe. ");
INSERT INTO cofNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aman man mate nula duque padeseilaichunae. ¿Nulachi pueblo awinta wa serica joco? yape pa junlari wilaitusa. Junni pa junlari nulachi serica fecári fato, wa teranca tsan quilaquichunae tinue quera quebi wichun. Nulachi puebloca awintaito quera quilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nulachi pueblobi jerale yaca aralenan, su mancatiya jamo diquiratuchunae tinue. Junni nulacanan totelaquichunae. Junni Diosi nulachica amana jaca jonunca tenhitunun tenchi tsanque jera padeseilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Junni Jesús Diosichi yabi manwito, junbi osinaminlaca jera sularierenue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tsanquinato, itsantinue: —Diosichi Pilabi chuteca joe tinue Diosichi ya Diosibe rocainun ya jochunaeque. Diosichi Pilabi tsantica josanan, nulari in yaca tarinnun ya cuwenta suwacala joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Junsi Jesús ma cura Diosichi yabi micarinaminue. Junni mantaminlari yaca totechi latinue. Aman mantá tan patelelabe israelítala tala mantaca micariminlabe weyan mantá tanlabe tenpalaquinue Jesuca niya quiraque totentsan jonhonque. ");
INSERT INTO cofNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tsanque tenpalaquinatonan, jerale epe tsachila Jesuchi fiquica meráminla jonan, yaca natiya toteno capodeilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Junni manca mate Jesús Diosichi yabi wito, tsachilaca Diosichi sen fiquica micarinaminue. Junni micarinasanan, mantá tan patelelabe mantaca micariminlabe mantá tan unicalabe Jesúchica jato ");
INSERT INTO cofNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","itsanlatinue: —Nuri chiquilabe pade! ¿Nuri mochi mantate micarinayun? ¿Mo nuca mantaquin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Junni Jesús yalachi fiquica meráto itsantinue: —Aman casaleri nulabenan man fiqui panhachinayoe tinue. Nulari labe palaquede! ");
INSERT INTO cofNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Mumunmin Juanni mochi mantate mumunnamiyan? tinue. ¿Diosichi mantate, o tsachilachi mantateri mumunnamiyan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Junni Jesús tsantinunca meráto, israelita mantaminlari chicanle tenpato itsanlatinue: —¿Niyan ticaichunan? Juanca Diosichi mantate mumunnaminhe tituntsan joe. Chiquilari tsanlatinari, ¿Niyaito yaca quereilaitiyun? tichunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Junsi manan yari Diosichi mantá itominhe latinari, epe tsachila chiquilaca paito su walaca quito totelaquichunae latinue. Aman yalari Juanca pato, Diosichi mantate pamin jominhe timinlae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Junni mantaminlari tsanque tenpatobi, Jesube itsanlatinue: —Te, miituntsan joe latinue. Mumunmin Juan Diosichi mantate mumunnamin jonunca, o tsachilachi mantate mumunnamin jonunca miituntsan joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Junni Jesuri lanan nulabe pátiyoe tinue la mochi mantate micarinanunca. ");
INSERT INTO cofNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Junni Jesús israelita mantaminlabe tsanque cuenta polaritobi, jeralelabe man cuentaman polarinue. Itsantinue: —Diosiri wita tsacumin cuwenta jochunae tinue. Aman casale casaleri ya tsachiri uba wita quisa carichunae tinue. Junni wita quisa carisi, tsachilachi quitsa quitsa cachun cuwato, bare toca numari chubi jichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Junni aman uba cano mate peyunca erechunae yape wita cuidaiminlari quitsaca cuwalaquisa. Junni wita cuidaiminlari ya peyun janaminca sonba quito, natiya cuwatuminnan manherelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Junni wita tsacumiri manca peyuncaman erechunae. Junni yacaman jun tsanquenan chidechi misuto, seiton quito, yachinan natiya cuwatuminnan manherelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aman mancaca erenan, yacaman fudacarito, witabi nechi manlarito erelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Junni wita tsacumiri tenca cato, ¿Niyan queichunan? tichunae. Junsi lari mirayoe. Lachi munatinun naocaman erechinayoe tichunae tinue. Pansile yaca quirato respetailaichunae tichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Junni aman wita cuidaiminla mantimini wita tsacuminchi nao fanaminca quirato, yala tala itsantilatichunae: Ja mosori tsacuminchi nao joe. Yari ina tsacumin ichunae. Aman yacanan totentsan joe yape wita chiquilachi puraisa. ");
INSERT INTO cofNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsantisi tsacuminchi naocanan wita dechi tanjito totelaquichunae tinue. ¿Junni wita tsacumiri jun cuidaiminlaca niyan quichunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aman witaca manjato, cuidaiminlaca totechunae tinue. Yalaca toteto, ya witaca uyanlachi cuwachunae tinue. Junni Jesús jun cuentaca polarinato, israelita mantaminlari jun seiton cuidaiminla cuwenta jolajoeque pánaminue. Junni yalari jun cuentaca wepanato merasi, itsanlatinue: —Te, chiquilari yala cuwenta seiton quimin itolajoyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Junni Jesús yalaca beco manquirato, itsantinue: —Nulari yala cuwenta seiton quiminla itonari, ¿ti quichun Diosichi Pilabi itsanque chuteca junhun? tinue. Junbi itsanque nulaca chuteca joe: Suca ya quiminlari su mancaca seitoe tito, quepolaquichunaeque chuteca joe. Juntonan tsanquica josanan, wanbile ya suri fe munaranun sen su jochunaeque chuteca joe tinue. Junni Jesuri jun su cuwenta jono jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Junni jun subi tutulaito quepoiminla cojilaichunae tinue. Jun su darapatito tsachilachi jamo patinari, dilailaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Junni Jesús micarinato, jun cuenta quinato, israelita mantaminlaca seitonla joe tinaminue. Junni aman mantaca micariminlabe mantá tan patelelabe junca tenhito, yaca jun óratenan dochi latinue. Aman epe tsachila mantimini Jesuca se tinaminlanue. Junni mantaminlari Jesuca dolaquitunue tsachila pailaichunaeque jelechi. ");
INSERT INTO cofNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Juntonan Jesuca quirade quirade nenaminlanue. Junto uyan tsachilaca Jesúchica erelaquinue yape yaca palaque pasa carilaquisa. Junni ya ereca junlari Jesube sen tsachila cuwenta panhalaquinue yaca falta patarichique. Junni Jesuca falta pataritori, miyachi cuwapono jominlanue yape yaca casticaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Junni ereca junlari itsanlatinue: —Chiquilari miralarayoe latinue nu tsarasica pato micarimin joeque. Mantaminla, o epe tsachila nuberi jun tsannan jolajoe. Aman nuri yalaca tennatuto, Diosichi minuca tsarasica micarimin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aman Jesube tsantisi, jerale toca mantamin romano miyaca panhato itsanlatinue: —¿Chiquilari ya uyan to miyachi inpuesto cala cuwanola join, o cuwanola itoin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Junni Jesús tenhinue yaca falta patarichiqueri tsanlatinaeque. Junto aman yalabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Inpuesto cuwanun calaca lachi quirawolaquede! tinue. Aman calaca quirawonan, calaca quirato itsantinue: —¿In calabi mochi misu, mochi mumun chun? tinue. Junni Jesús tsantinan, yalari Ya romano miyachi joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Junni Jesús itsantinue: —Tsan jonari, cobierno miyachi cosateri yaca meralaquina! Aman Diosichi cosateri Diosica meralaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Junni panhaminlari peleilainue. Tsachilachi cale Jesuca palaque pasa carichique tenfetonan, podeilaitunue. Yachi fiquica wepanato meráto, nosale cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Man bolon israelítala uyan quiraque tenca caminla joto, puyaca junla mansonhilaituchunae timin jominlanue. Aman tsantiminlaca saduséola tinun jolajoe. Junni saduséola weyanlari Jesúchica jato ");
INSERT INTO cofNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","itsanlatinue: —Nuri micarimin joto, chiquilabe pade! tilatinue. Matu to Moisés Diosichi mantate pato, chiquilaca itsanque mantanue: Manca aco casalaito, na itonan puyanari, yachi benechi acoman ya sonabe casalaino jochunae tinue latinue aco puyan ocochi tenchi na tachun. ");
INSERT INTO cofNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Junni aman sieteca acola jominlanue tilatinue. Caque acori sonaca cato, na caitonan puyae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Junni benele acori caque aco puyan ocochi sona jominbe casalaito, yanan na caitonan puyae. ");
INSERT INTO cofNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Junni nantanan benechi acoman jun tsannan inue. Jun tsanquenan sieteca acola jera depoleto puyalainue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Junni aman acola jera puyalainunbi, ya sonanan na caitonan puyanue tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Junni saduséolari Jesube tsanque cuenta polarito, itsanlatinue: —Aman ya sonari sieteca acolabe casalaica jomin joto, ¿puyacala mansonhino mate mochi sona jochunan? latinue. Junbe tenhintsan joe latinue puyaca junla mansonhilaituchunaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aman jun fiquica meráto, Jesús itsantinue: —In tote sonnaminla unilalanan, sonalanan cayaacaiminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Senla mansonhito mantimini uyan quiraque jolajochunae tinue. Aman puyaca jominnan mansonhito, Diosichi nalala jolajochunae tinue. Anjelila cuwenta joto, manpuyatuminla ichunae. Junto jun casan tobi unilala sona mancalaquituchunae. Sonalanan unila manquilaquituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Junsi Jesús itsantinue: —Aman puyaca junla mansonhinola jonunca cuenta quilaquisa! tinue. Nula duque tennanun tsachiri, matu to Moisés, yanan pila chutenue puyacala mansonhilaichunaeque. Moisés tape lunaminbi nechi Diosichi fiquica itsanque meránue: Matu to Abrahanchi, Isaachi, Jacóbochi Diosi joe tinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aman Diosi puyaca junlachi Diosi itoe; sonnaminlachi Diosi joe. Junto ya pemanca tsachilari numari puyacala jotonan, Diosichibi casonnan chularae tinue. Yaberi jeralela sonnalarae. ");
INSERT INTO cofNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aman Jesús tsanque micarinasa, weyan mantaca micariminlari pemeránaminlanue. Yalari Jesuchi fiquica meráto, nuri seque micarimin joto, seque pae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aman juntele nechi israelita mantaminla luito yabe natiya manpanhalaquitunue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Junni Jesús israelita mantaminlabe manpato, itsanque panhanue: —Aman Diosi wenteca Cristo tinunca tenca calaquede! Weyanlari yaca matu to miya Davichi alica jochunae timinlae. Junni ¿niya jonan yaca tsantiminla jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David Salmo pilabi ya Crístoca Miya tinue. Itsanque chuteca joe: Miya Diosi lachi Miyaca mantachunae tinue yape yachi tsa tede nanchi chudito yabe pemantasa. Nuca fe losa cariyanae. Junni junte mechude! tichunae tinue ");
INSERT INTO cofNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nuca pa jominlaca fe lono fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Junni Jesús Diosichi Pilabi chutecaca tsanque manpasi, itsantinue: —Aman Cristo tinun tsachi miya Davichi alica jonari, ¿niya jonan Davinan yaca Miya tinun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aman jeralela meralaquinasa, Jesús yachi tsachilabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Israelítala tala mantaca micariminlaca tencabe nenalarana! tinue. Yalari fe baren camisa pochi timinlae yape tsachilari yalaca duque sen jolajoe latisa. Duque tsachila nenanunte yalaca duque respetaito saludaisa munaralarae. Diosichi fiqui miinun yabinan, o fiestatenan, fe mantá tanla chudinunbi chudichi timinlae fe jolajoyoe tito. ");
INSERT INTO cofNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Juntonan biudalachi yaca nosale josoleminla joe. Junni biudalachi yaca josoleminla jotonan, Diosibe wanca rocaiminlae yape tsachila yalaca meráto sen jolajoe tilatisa. Aman tsanquinun tenchi yalaca nantanancari casticaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Junni aman Diosichi yabi oco tsachilari epe cuwanun cajonbi duque cala ponaminlanue. Junni Jesús yalaca quiranaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Junto aman biuda mancacanan quiranue. Yari cala iton jotonan, paluca cala nacá jun cajonbi ponue. Ya paluca cala natiya mica iton cala nacári jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Junni Jesús yaca quirato, yachi tsachilabe itsantinue: —Lari nulabe tsarasica pachinayoe tinue. Oco tsachila ticatiya duque tan joto, puchuica jun calacari polaquinae tinue. Aman in biuda mantimini popere sona jotonan, jera tanunca cuwanae. Junto nasiri cala ponatonan, jerale ocolaca fécari Diosichi cuwamin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Junnasa Jesuchi tsachila weyanlari Diosichi yaca quirato, duque uraran joe latinue. Uraran suca quica joe. Ja yabi ticatiya uraranca Diosichi epe cuwacaca quirade! latinue. Junni Jesús yalachi fiquica meráto itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Meralaquede! tinue. In tsara moso wa ya jera yucapiyachunae tinue. Manca mate su mancatiya jamo diquiratuchunae tinue. Jera aralelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Junni yabe penenaminlari junca meráto, itsanlatinue: —Chiquilaca micaride! latinue numasi tsanhino jonunca. ¿Tsanhichinanunca chiquila niyaito miintsan jochunan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Junni Jesús itsantinue: —Tencabe nenalarana! tinue. Duque tsachila Cristo joyoe tide jalaichunae tinue. O Cristo manjano ma faca joe latichunae. Junni nula tencabe nenalarana! mobenantiya encanailaituchun. Yalabe penenatulajona! ");
INSERT INTO cofNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Quera quicaalaquinaeque mera jochunae. Weyanlari yalachi miyaca paito, jun tobi chuminla talanan quicaalaquichunaequenan mera jochunae tinue. Junni aman junca merátori, jeleralaratuna! tinue. Aman to jeraino ma ino nasi cajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Junni Jesús yachi tsachilaca camicarinato, itsantinue: —Manca tobe manca tobe pataato quera quicaalaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aman weyan postolate duque to wechunae. Weyan postolate tsachila ano fino itonan, duque tsachila padesein, quiyanpoin, ilaichunae tinue. Aman yoquidobinan duque jele tintsan quiraichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Junni catsanhitusanan nulaca cato, seitonque quilaquichunae. Nulaca Diosichi fiqui miinun yabi culpa quito, dosa carilaquichunae tinue. Mantaminlachicanan, miyalachicanan nulaca tanjilaichunae tinue labe penenaminla jonun tenchi culpa quito. ");
INSERT INTO cofNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Junni nulaca tsanque tanjilainari, nulari yalachi cale laca pano podeilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Junni yalabe cuenta quinola jotori, tennalaratuna! tinue. Niyaque beco manpano jonunca tennalaratuna! ");
INSERT INTO cofNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","La nulaca pasa cariyanae. Aman duque mi caya fiquica pasa cariyanae tinue. Tsanque seque pánaminlaca nulaca pa jominlari nene patarino podeilaituchunae tinue. Niyanlatiya quereintsan fiqui jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tsan josanan, nulaca cuwapolaquichunae tinue. Mantaminlachi cuwapolaquichunae yape nulaca seitonque quilaquisa. Nulachi apalanan, ayanlanan, acolanan, familialanan, amicolanan, tilatiya nulaca encanato cuwapolaquichunae tinue. Junni nulaca cuwapoca jonan, weyanlacari totelaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jerale tsachila nulaca pa jolajochunae tinue labe penenaminla jonun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aman tsan josanan nulachi tencaca natiya yucapiyarino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aman nulari peleituto wantaito, nulachi tenca se lolaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Junni Jesús yachi tsachilaca camicarinato itsantinue: —Junsi manca mate uyan to soldadola Jerusalén pueblo awinta ilaichunae tinue. Aman junca quirato miintsan jochunae Jerusalenca yucapiyarino ma fenaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Junto jun mate Judea tobi chuminlari du minu sujinola jochunae tinue. Jerusalenbi chuminlanan junbi nechi loto, sujinola jochunae. Pueblole nechi dechi nenaminlari manwituntsan jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Duque casticaquino ma jochunae tinue. Diosichi Pilabi duque chuteca joe Jerusalén pueblobi chuminlaca casticaquichunaeque. Junni aman jun mate jun fiqui jera tsa patichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Diosi israelítalaca pa jonan, in tobi chuminla jeralela padeseilaichunae tinue. Jun mate napunlabe cu cufiminlabe fécari padeseilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aman quera quinan, duque tsachila puyalaichunae tinue. Junsi duque tsachilaca cato, piyanle to minu do tanjilaichunae. Junni israelita itonlari Jerusalén pueblobi mantalaquichunae tinue yala mantaca tano jeraino fecári. Jesús yachi tsachilaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Junsi Jesús camicarinato itsantinue: —Jun mate yoquidobi niyan quirantiya iniichunae yape tsachila junca quirato wepanalaisa. Yo, pe, tsabo niyan quirantiya iniichunae. Totenan manca tobi, manca tobi tsachila duque wepanalaichunae. Lamari latsa duque pa jominca wepananun cuwenta, jera palaque tenca calaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yoquidobi tsaracari sonba raminlanan wecailaichunae tinue. Aman tsachilari yaca quirato, duque jele tilatichunae. Tobi niyanhichinanunca duque wepanalaichunae tinue. Wepanachi podeiton cayailaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Junni aman tsanlainasa quiranari, la tsachi ica jun joto manpatanae tinue. Tsara sonban joto, urara tsenbe manpatanae. Junni tsachila laca tsanque seque manpatanaminca quiralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aman junni jun padeseino ma fenasa, sonba tenca manhilaina! Nulaca se larino ma queloinaeque tenhito, sonba tenca ilaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Junni Jesús yabe penenaminlaca tsanque micaritobi, man fiquiman micarichun in cuentaca polarinue: —Meralaquede! tinue. Ico peleca, o ti chide pelecatiya tenca calaquede! ");
INSERT INTO cofNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","¿Aman in tobi wata cura chide pele japisu jera patimin joco? Junni fu ma manhichinasanan, japisu manquimanhe. Aman japisu manquinaminca quirato, nulari tenca mánta miiminla joe manfuichinaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aman Diosi yachi tsachi bolonca jera suwano ma jun chide pele cuwenta jochunae tinue. Jera la paca jun fiqui tsanhinaminca quiralaquitori, miintsan jochunae Diosi jera mantano ma fechinaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nulabe tsarasica pachinayoe: Ya tsachilari cajerailaitusanan, la paca jun fiqui jera tsanhichunae. ");
INSERT INTO cofNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yoquidonan, tonan, jeraichunae. Lachi fiqui mantimini numanan epe fiqui ituchunae; la tilacatiya tsanhichunae tinari, jun tsannan ichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Junni nulari tencabe nenalarana! tinue. Fiesta quito, polencari ano fito, winan ito seitonque nenatori, pele tenca ilaichunae. Ticatiya fe tachique wepanato nenatori, pele tenca ilaichunae. Junni junca tencabe nenalarana! pele tenca ituchun. Jana tsachilari la poca junbi moorari pichu cayaimanhe. Junni jun cuwentanan pele tenca tanlari jun mate moorari padeseino patilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jerale tote chuminlanan tsanquenan padeseinola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Junni aman tencabe nenalarana! tinue. Diosibe rocailaina! yape nulaca sonba tenca suwasa jun padeseinunle nechi se lono podeilaisa. La tsachi ica jun jonan, lachi cale wiruinola jochunae. Junni Diosibe rocailaina! lachi cale culpa itoto wiruino podeilaichun. Jesús yachi tsachilaca tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Junni aman ma cura Diosichi yabi micarinaminue. Junni quebi cura Jerusalén pueblobi nechi manloto, Olibo tinun dubi chumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aman ma cura quepenan jerale tsachila Diosichi yabi Jesuca merábi jamin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Junni aman casa ma fiesta queloinue lebadura iton bibuca finun fiesta. ");
INSERT INTO cofNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Junnasa mantá tan patelelabe mantaca micariminlabe tenpalaquinue niyaque Jesuca toteno podeicaichunanque. Tsachila quiralaquinasa yaca catuntsan joe latinue tsachilaca jelechi. ");
INSERT INTO cofNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Junni chunca paluca Jesube penenaminla manca Judas Iscariote jominue. Aman yucan ya tsachichibi wito, ");
INSERT INTO cofNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","mantá tan patelelachica jisa carinue. Junni yalachica jito, yalabenan Diosichi yaca cuidaimin capitanlabenan cuenta quinue Jesuca niya quiraque yalachi cuwapono podeiyanaeque. ");
INSERT INTO cofNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aman patelelari junca meráto, son tito yachi cala cuwalaquechinayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Junni aman Júdari se joe tito, junte nechi tenca cato nenaminue Jesuca niyaque cuwapono jonunca. Niya quiraque Jesuca tsachila itonte encanato cuwaponoca tenca cato nenaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Junni casa fiesta fenue lebadura iton bibuca finun fiesta. Jun mate opisa náca toteto fimin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aman junni Jesuri yachi paluca tsachilaca erenue yape fiesta ano dalaquisa. Pédrobe Juánbeca erechinato, yalabe itsantinue: —Nulari pueblobi fiesta ano dalaquinachin! tinue chiquila filaquichun. ");
INSERT INTO cofNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Junni yalanan itsanlatinue: —¿Aman tile dalaqueyanan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Junni Jesunan itsantinue: —Nula meralaquede! Pueblobi wilainaminnan, pi nana jun janamin unilabe tulailaichunae tinue. Nulari yachi beneca ya fecári jilaina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Junni jun ya tsacuminbe itsanlatina: Chiquilaca micarimin tsachi rocainae tilatina! fiesta ano fichun tamoca micuwasa. Junbi casa ma fiesta anoca yachi tsachilabe pefino muquee tinae latina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Junni aman tsanlatinunsi, jamobi wa tamoca micuwachunae tinue. Jun tamochi mesa, plato, titiya jera jochunae tinue. Junni nulari jun tamochi fiesta ano fichun jera selaquinana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesús tsanque mantanunsile, tsanquebi jilainue. Junni Jesús tsanque paca josa, jun tsanquenan patinue. Junni junbi casa ma fiesta ano fichun jera selaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Junni aman ano fino órate Jesube yachi mantá tanlabe ano fichun chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aman ano finato, Jesús yalabe itsantinue: —Aman lari capadeseituminnan, nulabe duque in fiesta ano fino muquinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Junni nulabe tsarasica pachinayoe: Itsan fiesta ano filaquinato, tenhintsan jominue la Diosi mantanasanan tsachilachi tenchi puyano jochunaeque. Junni lari tsanhino fecári in fiesta anoca manfituanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aman Jesús tsantisi, bino copa cato, Diosibe acradeseito, yachi tsachilachi cuwanato itsantinue: —Nen, inca nula tala cuchilaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Meralaquede! Binoca numanan mancuchituanae Diosi jera miya ito mantá cano fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Junni ano filaquinato, Jesuri bibu cato, Diosibe acradeseito, pisuleto, yalachi cuwanue. Aman cuwanato, itsantinue: —La nulachi tenchi puyano joyoe tinue. Junni in biburi lachi puca jochunae tinue. Aman nulanan laca mantenhito, jun tsannan quilaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Junto ano fitobi, bino copacaman cato, Diosibe acradeseito, yalachi cuwanato itsantinue: —Diosi tsachilabe casan fiqui pánae jutsa piyarino joyoeque. Nulachi tenchi asan larito puyano joyoe jutsa piyarichun. Junni in binori lachi asan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Junni meralaquede! tinue. Laca cuwapono jun tsachi labe ano pefinae. ");
INSERT INTO cofNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aman tsachi ica jun joto puyabi jichinayoe. Diosi laca tsanquenan paca joe puyano joeque. Laca cuwapomin tsachi mantimini duque padeseichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Junni tsantinan, Jesube penenaminlari yala tala beco beco panhacaalaquinue mo tsanquichunanque. ");
INSERT INTO cofNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Junni aman Jesube penenaminlari pacaalaquinue yala tala mo fe mantá tan joinhinque. ");
INSERT INTO cofNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Junni Jesuri yalabe itsantinue: —Diosica tennatuminla tala mantaminlari sonbaque mantaminla joe. Tsan josanan yalabe mantaiminlari ya mantaminlaca pato, ayudaiminla joe timinla joe. ");
INSERT INTO cofNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Junni nula tala mantimini uyan quiraque jolajochunae tinue. Nula talari fe mantá tanlari uyanlaca fécari epe tsachila cuwenta joto ayudainola jochunae tinue. Mantá tanla jotonan, weyanlabe mantaiminla cuwenta nenanola jochunae. ");
INSERT INTO cofNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Junni tenca calaquede! tinue. ¿Mo fe mantá tachunan? ¿Ano poto cuwacaca fimin tsachi fe mantá tachunan, o ano poto cuwamin tsachi fe mantá tachunan? ¿Ano poto cuwacaca fiminni fe mantá tan jochunaco? tinue. Aman la mantimini nulabe penenato, mantá tanla cuwenta nenatiyoe; lari mantaiminla cuwenta nenayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Junsi Jesús itsantinue: —Aman tsan josanan la padeseito nenasanan, nulari laca puratuto labe penenamin jominlae. ");
INSERT INTO cofNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Junni meralaquede! Lachi Apa Diosi laca mantá tan suwacae yape miya josa. Junto laman nulaca mantá tan suwanayoe yape labe pemantalaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Lari miya inunbi, nulanan labe ano pefiminla jochunae tinue. Nulari mantato chudinunbi chudito, jerale chunca palu bolon israelítalaca pemantalaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Junsi aman Jesuri Simón Pédrobe itsantinue: —Simón, meráde! tinue. Nulaca yucan cachi tica joe pele tenca isa carichique. Tricoca petse larichun nisi wecacarinonan, yucan nulaca tsansi wecacarichi tica joe tinue nulachi tencaca pele pochique. ");
INSERT INTO cofNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Junni lari nuchi tenchi rocaiyoe yape nu Diosica tennano peleitusa. Aman nuri sonban tenca manhitobi, weyan acolaca, soquilaca sonba tenca mansuwana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Junni Pedro jun fiquica meráto, Jesube beconan pato itsantinue: —Miya, lari nuca numanan puratuanae tinue. La nube parejo doino jototiya, o puyano jototiya, nucari numanan puratuanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aman Jesunan beco pato itsantinue: —Pedro, meráde! tinue. Nuri amana quepen laca purachunae. Nu walpa apaca capatusanan peman ne laca natiya miitoyoe tichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Junni Jesús yachi tsachilabe itsantinue: —Nanni matuleri nulaca cala iton, tolo iton, sapato iton ereca jomanyoe. Junni titiya iton nenasanan, ¿titiya falta jomiyan? tinue. Yalari falta itominhe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Junni Jesús itsantinue: —Meralaquede! Diosichi Pilabi laca jera chuteca jun fiquiri tsarasi patichunae tinue. Junni aman laca criminalilaca cuwenta culpa quilaquichunaeque chuteca joe. Junni tsanque chuteca josanan, jun tsannan ichunae tinue. Jun tenchi amana la nulaca uyan quiraque mantaquechinayoe tinue: Junni cala tatori, calaca tanjilaina! Tolo tatori, yacanan tanjilaina! Espadanan itotori, espada ticatiya calaquina! tinue. Cala itotori, panuca osito espada calaquina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aman yachi tsachilari jun fiquica merasi, itsanlatinue: —Miya, quirade! Palupe espada talarayoe latinue. Aman Jesuri yape josa! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aman Jesula fiesta ano finun tamochi nechi losi, Olibo tinun du minu jilainue. Aman jun du minu duque jimin jominlanue. Junni Jesuchi tsachila yaca benechi pejilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Junni jun postobi fetobi, Jesuri yalabe itsantinue: —Nulanan Diosibe rocailaide! tinue jutsa quituchun. ");
INSERT INTO cofNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsantisi, yalaca purato, jabile jinue su walato fein tsansiteri. Junchi jito telenhito, Diosibe ");
INSERT INTO cofNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","itsanque rocainue: —Apa, nuchi munajanari, la padeseino jonunca polarisa tenjae. Tsan josanan, lachi tenca munateri tsanhisa tenjatue. Aman nuchi tenca munateri tsanquisa tenjae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Junni anjeli jamochi nechi patato, Jesube quiraito sonba tenca cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Junsi Jesuri tsanque puyano joyoeque tencabi padeseinato, nantanancari sonba rocainue. Chipi larinan, asan wa tsoroca tsan tobi patinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Junto Diosibe rocaitobi manwiruito, yachi tsachilachica manjanasa, yalari laquichi catson tsominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Junni yalabe itsantinue: —¿Nulari niyaito catson tsolarayun? tinue. Mancupato Diosibe rocailaide! tinue jutsa manquituchun. ");
INSERT INTO cofNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aman Jesuri cuenta caquinasanan, polisialabe duque tsachilabe layaito jalainue. Junni yalaca tanjamin tsachiri Judas jominue. Yari chunca paluca Jesube penenaminla manca jominue. Junto Jesuca mo tito saludaibi janue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús mantimini yabe itsantinue: —Judas, ¿nuri ti quichun laca mo tito saludaito cuwaponayun? tinue. ¿Ti quichun laca tsachi ica junca tsanque cuwaponayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Junni Jesube pejinaminlari niyan quilaquechinanunca tenhilainue. Junca tenhito, Miya, ¿chiquilari yalaca espadachi quintsan junhun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsantisi, manca Jesube penenamin tsachiri espadaca laricato, mantá tan patelechi peyunchi tsa nan tala punquica balequinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aman Jesús mantimini yalaca tsanlaquitude! tito, punqui bajicaca taquirato, manse suwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aman mantá tan patelelabe Diosichi yabi mantá tan capitanlabe mantá tan unicalabe layaito, Jesuca cabi jaca jominlanue. Junni Jesús yalabe itsantinue: —¿Ti quichun laca espada tanla, chide tanla, tarinminca cuwenta cabi jalainayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Diosichi yabi ma cura nulachite micarito chuminca calaquitue. Tsanni amana nulachi óra joe. Yucan mantano óra joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Junni aman Jesuca cato, fécari mantá tan patelechica tanjilainue. Junni Jesuca junchi tanjilainasanan, Pedro comabile benechi jinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aman weyanlari patelechi selate nin quito, nin lobaito chuminlanue. Junni Pédronan yalabe pechudinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Junni aman Pedro tsente chuminca peyun sona manca yaca duque quiranaminnan, yaca manmiito, in tsachiri Jesube penenaminhe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro mantimini te, yaca natiya quiratumanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aman nanni inale manca tsachi yaca quirato, nunan Jesúlabe penenaminhe tinue. Junni Pédrori itsantinue: Te, lari itomanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aman man óra tsansi poletobi, manca tsachiri tsarasica pánayoe tito itsantinue: —In tsachiri Jesula cuwenta Galilea to tsachi joe. Junto yabe penenamin jonhoda tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Junni Pedro junca merasi, ¿Tica wari tsanlatinayun? tinue. Lari yaca natiya quiratumanyoe tinue. Junni Pedro tsantinasaleri, walpa apaca panue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Junni walpa pánasale, Miya Jesuri tamochi nechi Pédroca quiraerenue. Junni Pedro Jesuchi fiquica mantenhinue. Jesús Pédrobe itsantica jominue: Amana walpa apaca capatusanan, laca peman neca quiratumanyoe tichunae tica jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Junni Pedro jun fiquica mantenhito, sela dechi jito duque warenue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aman Jesuca taminlari yaca lucarinato, tedechi quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Junni yachi cacaca doto, yaca quito, Diosichi mantate nuchi tencabi miiniide! latinue mo nuca quinunca. ");
INSERT INTO cofNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Junto Jesuca yucacuranato, duque seiton fiquicanan palaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aman tseinasa israelita mantaminla tala layailainue. Mantá tan unicala, mantá tan patelela, mantaca micariminla jominlanue. Junto Jesuca yalachica tanjasa carito, yabe ");
INSERT INTO cofNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","itsanlatinue: —Chiquilabe pade! tilatinue. ¿Nuri Diosi wenteca jun Cristo joyun? tilatinue. Junni Jesús beconan pato itsantinue: —Lari Cristo joyoe tinari, laca natiya quereilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","O la nulabe ticatiya panhanari, nulari natiya tulanlaquituchunae, nin laca manlarilaquituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tsan josanan, amanale nechi la tsachi ica jun joto Diosichibi chuanae tinue. Ya tsara sonban joto, yachi tsa tede nanchi laca chutechunae tinue yape yabe pemantasa. ");
INSERT INTO cofNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Junni jerale mantaminlari jun fiquica meráto, Jesube itsantilatinue: —¿Junni nuri Diosichi Nao joyun? tilatinue. Jesuri tsanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aman junca merasi, mantaminlari yala tala itsanlatinue: —Wari yanan tsantinan, uyan testicolaca munaralaratiyoe yape yaca culpa quilaquisa. Ya tsantinaminca chiquilari meralaquinayoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Junni jerale israelita mantaminlari miya Pilátochica Jesuca tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Junni Jesuca culpa quechiqueri itsanlatinue: —In tsachiri jerale israelítalaca seiton suwanae tilatinue. Nulachi miyaca merátuto, nin inpuesto calaca cuwatusa timin joe. Aman nulachi miyaca merátuto, yanan Cristo tinun miya joyoe timin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aman Pilátori jun fiquica meráto Jesube itsantinue: —¿Nuri israelítalachi miya joyun? tinue. Jesuri tsan joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Junni Pilátori jun mantá tan patelelabenan, duque uyan israelítalabenan itsantinue: —Lachi tencari in tsachiri niyaquenantiya seiton quitumin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aman israelítala mantimini fécari sonba otito itsanlatinue: —Ya Jesús jerale israelítalaca seitonque nenasa carinae tilatinue. Casale Galilea tobi seitonque micarito, junsi inlatenan jun tsannan quinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Junni tsantinanunca meráto, Pilato panhanue Jesuca Galilea tsachi jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Junni aman miya Heróderi Galilea tobi mantamin jominue. Junni jun mate yanan Jerusalenbi pejominue. Junni Jesús Galilea tsachi joeque miito, Pilátori yaca Heródechica erenue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes mantimini Jesuca duque quirachi tinaminue. Pansile la quiranasa wepanato quirantsancari seque quichunae tito, Jesuca quirachi tinaminue. Junto yaca quirato, son tito, ");
INSERT INTO cofNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","duque panhanue. Jesús mantimini natiya beconan patunue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Junnasa mantá tan patelelabe mantaca micariminlabe quelole rato, duque culpa quechique pánaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Junni aman Heródebe yachi soldadolabe Jesuca lucarilaquinue. Yaca lucarinato, miya ponun camisaca pocarito, Pilátochica manherelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aman Pilátobe Heródebe pa tala jominnan, jun mate amico manhilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Junni aman Pilátori mantá tan patelelacanan, mantá tan israelítalacanan, junsi uyan israelítalacanan layaisa carito, ");
INSERT INTO cofNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yalabe itsantinue: —Nulari Jesuca tanjato, tsachilaca seitonque nenasa carinae latie tinue. Aman la mantimini nulachi cale yaca panhato, jera meráto miiyoe. Junni nulari meralaquede! tinue. Nulari in tsachica epe culpa quichi latinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heródenan yaca culpa itoe tito, chiquilachica manherenue. Junni meralaquede! tinue. Inni totentsancari jutsa natiya quitue tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Junni yaca casticaquito manlariyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aman Pilátori casa ma fiestate israelítalachi tenchi fabor ito, doraminla mancaca manlarino jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Junto Pilátori junca mantenhito, Jesuca nulachi tenchi manlariyanae tinue. Junni tsantinunsile, jerale israelítala layaito sonba pato, itsanlatinue: —Te, yacari totentsan joe latinue. Yaca natiya manlarituto, Barrabácari chiquilachi tenchi manlaride! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aman Barrabari jun pueblobi soldadolabe quicaanun tenchinan, aman tsachilaca totenun tenchinan doraminue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Junni Pilátori Jesuca manlarichi tito, yalabe manan manpanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aman tsantinasari, israelítalari sonba pato, itsanlatinue: —Jesúcari corosibi totesa caride! Corosibi totesa caride! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Junni tsanlatinasanan Pilato yalabe manan manpanue. Jerale nechi Jesuca manlarichique yalabe peman ne panue. Aman wari debi ne pánato itsantinue: —¿Niya jonan yaca totesa carisa tenjalaquin? ¿Niyaque nulaca seiton quica jun? tinue. Totentsancari jutsari natiya quica itoe tinue. Junni yaca casticaquitosiri manlariyanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Junni mantá tan patelelabe uyan israelítalabenan jun fiquica meráto, nantanancari sonba palaquinue yaca corosibi totesa carideque. Junto michi palaquinato, fe ilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilátori peleito, yalachi tenca munate quilaquisa mantanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yalari Pilátobe duque rocainaminlanue Barrabaca manlarisa. Yari quicaan, toten, quimin joto doraminue. Junni ya toteminca manlarito, Jesuca yalachi cuwaponue yape niyan quino muquinatiya quilaquisa. ");
INSERT INTO cofNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aman Jesuca junbi nechi tanjilainasa, Cirene to tsachi manca witabi nechi manjanaminue Simón tinun. Junni soldadolari ya Simonca Jesús puyano jun corosica nanasa carilaquinue. Jesuchi benele corosi pecato, nanato jinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aman Jesuchi benele duque uyan tsachilanan pejinaminlanue. Duque sonalanan yachi benele pejito, yaca quirato, laquiito warenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Junni Jesuri yalaca quirato, itsantinue: —Jerusalenbi chumin sonala, nulari lachi tenchi warelaquitude! tinue. Nulachi tencachique tenchi warelaquede! Nulachi nalalachi tenchinan warelaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nula meralaquede! Manca mate duque padeseino ma jonan, tsachilari itsanlatichunae tinue: Na itonlari fe son jolajoe latichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aman jun mate tsachilari padeseinoca jelechi, du chiquilaca delanto dosa latichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Junni tenca calaquede! La culpa itoncanan tsanque seitonque quilaquitori, culpa tanlacari niyantiya quinilaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Junni soldadolari Jesuca tanjinato, uyan paluca tsachilacanan petanjilainue yalacanan totechun. Junni ya palucari criminalila jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aman Misu Chide tinun postoca felaito, Jesuca corosibi wilocarilaquinue. Criminalilacanan Jesube parejo corosibi wilocarilaquinue. Manca tsa nan tala, manca jala nan tala corosibi totepolaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Junnasa Jesuri itsantinue: —Apa Diosi, yala niyan quilaquinanunca miitolajoe. Junni yalaca perdonaide! tinue. Junni soldadolari Jesuchi camisa tsanlaca cato, yala tala apostaito sorteailainue yaca mo cano jonunca miichun. ");
INSERT INTO cofNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aman israelítala junte quiranato, mantaminlari Jesuca lucarito itsanlatinue: —In tsachi uyanlaca se larimin joyoe timinhe latinue. Junni yari Diosi wenteca jun Cristo jotori, tencachiquenan se lontsan joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aman soldadolari Jesuchi quelole jato, pele binoca cutsawoto, yaca itsanque lucarito ");
INSERT INTO cofNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","palaquinue: —Nuri israelítalachi miya jotori, se loniide! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Junni pila quito yachi misu jamole ocarica jominlanue. IN ISRAELITALACHI MIYA JOE que pila chuteca jominlanue. Israelítalachi fiquichi, románolachi fiquichi, griégolachi fiquichi tsanque chuteca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aman Jesube petotaichinamin tsachi manca yaca yucacurato itsantinue: —¿Nuri Cristo joyoe titiyun? tinue. Junni Cristo jotori, nunan se loto, chiquilacanan se laride! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Junni manca puyano jun tsachiri tsantinaminca oleto itsantinue: —Tsantituntsan joe tinue. ¿Nuri Diosica jeleratiyun? Nunan Jesús cuwentanan corosibi totaino patinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tsannan chiquilari puyanola joyoda. Criminalila joto, puyanola joyoe. Ya Jesús mantimini ti culpanantiya itotonan, tsanhinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Junni tsantisi, Jesube itsantinue: —Jesús, nuri Miya itobi, laca mantenhina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Junni Jesús yabe manpato itsantinue: —La nube tsarasica pachinayoe tinue: Amanale nechi nuri labe jamochi pansi pechuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","47","Aman yotu jominue. Junni yo nemenhito, jerale jun tobi peman óra fecári nemenhinue. Junni Jesús sonba pato itsantinue: —Apa Diosi, lachi tencaca nuchi cuwaponayoe tinue yape cuidaisa. Junni tsantisi puyanue. Junni aman soldado capitan jun fiquica meráto, Diosica duque se tito, in tsachi natiya culpa itominue tinue. Junni aman Diosichi ya tamo quitsabi wa jali tsan dole tinraminue. Aman Jesús puyanasaleri, ya jaliri quitsale chile sujinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aman duque tsachila Jesuca totelaquinanunca quirabi jaca jominlanue. Yala jeralela jera niyanhinunca quirato, duque laquichi tenca tale cato manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jerale Jesuchi amicola jabile nechi quiranaminlanue. Aman Galilea tobi nechi Jesube pejaca jun sonalanan jabile wirurato quiranaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Junni aman tsachi manca jominue José mumun. Yari Arimatea pueblobi nechi jominue Judea tobi. Yari sen tsachi joto, Diosi ya mantananun tsachi bolon suwasa méraminue. Israelítala tala mantamin pejotonan, Jesuca totechi timinlachi parte peitominue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Junni yari Pilátochica jito, Jesús puyacaca mancuwasa rocainue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Junto Pilátori cade! tinunsiri, Joseri Jesús puyacaca corosibi nechi manpataricato, jalichi lapilaquinue. Aman Joseri su chupabi bobeda cuwenta menanun foro quisa carica jominue. Tsan jotonan, mocanantiya junbi catsoreca itominlanue. Junni aman Jesuca lapito, jun forochi tsorelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aman Jesús puyano mate ticatiya jera seno ma jominue ayuna nanchi jasaino ma jonan. ");
INSERT INTO cofNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aman Galilea tobi nechi pejamin sonalari Josebe pejilainue. Menaranun foroca quirato, Jesús niyaque tsonunca jera quiracala jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Junto manjito, puban pi jera selaquinue israelítalachi mite Jesús puyacaca ilipochun. Junni jasaino mate jasailainue Diosichi mantaca meráminla joto. ");
INSERT INTO cofNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Junni aman tominco ma tseinasa ya sonalari puban lucu secaca petanjito, menaranun foroca jilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aman Jesús menaranun foroca wa suchi docarica jominlanue. Aman sonalari féto quiranari, suca numa elanpoleca jonan forori fororaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Junni sonalari jun forochi wito quiranari, Miya Jesús itominue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Junca quirato, duque wepanato tenca calaquinasari, paluca unilala yalachi quelole quiraito wiruilainue. Yalachi camisa tsequiniquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Junni sonalari yalaca quirato, jeleito, tobi mutsailainue. Junnasa ya unilalari yalabe itsanlatinue: —¿Nulari niyaito menaranun forobiri son tsachica neyalaquinayun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","In forobi itoe. Puyaca jominnan mansonhie latinue. Aman nulari mantenhilaide! Galilea tobi canenatonan, Jesús nulabe cuenta quica jominhe. ");
INSERT INTO cofNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yari tsachi ica jun joto seitonlachi cuwapoiichunae tica jominhe latinue. Junni corosibi puyaca jominnan, peman mate mansonhiyanae tica jominhe latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Junni anjelila tsanlatinasanan, sonalari jun fiquica mantenhilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Junca mantenhito, menaranun forochi nechi manloto mansujitobi, anjelila paca fiquica jera cuenta quilaquinue. Chunca manca Jesuchi mantá tanlabe, junsi jerale weyanlabenan, tsanque jera cuenta quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalénabe Juánabe manca Maríabe weyan sonalabenan Crístochi mantá tanlachica jito, yalabe jera tsanque cuenta quilaquinue. Ya manca María Jacóbochi ayan jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Junni aman Crístochi mantá tanlari ya sonalachi fiquica meráto, yalaca natiya quereilaituto, epele palaquinae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro mantimini wiruito menaranun foroca sujito quiranue. Bontoito menaranun forochi quiraponari, Jesuca lapica jun jalisiri tsominue. Aman junca jera quirato, duque wepanato tenca cade manjinue niyanhica junhunque. ");
INSERT INTO cofNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aman jun mate paluca Jesube penenaminlari Emaús tinun puebloca manjinaminlanue. Ya pueblo Jerusalenbi nechi chunca man quilonbi jominue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Junni jilainato, cuenta quinaminlanue Jesuca niyantiya quicala jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Junni aman cuenta quede jilainasanan, Jesús patsanan yalachica jato, parejo pejinaminue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yala mantimini Jesuca quiranatonan, ya joeque miilaitunue. Diosi yalaca tenhisa carica itominue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Junni Jesús yalabe itsantinue: —¿Nulari tica cuenta quede jilainayun? ¿Niya jonan laqui jolajoyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Junni yala manca, Cleofas tinun, itsantinue: —In malate Jerusalenbi duque seiton quinaminlae. Jeralela junca miralarae tilatinue. ¿Nuri uyan tobi nechi joyun? Jerusalenbi nenatonan ¿junca merátiyun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Junni Jesuri ¿niyanhinanun? tinue. Junni yalari yabe itsanlatinue: —Aman Jesús tinun tsachi Diosichi mantate seque pamin jominhe tilatinue. Nasaret pueblobi nechi jato, tsara seque pato, wepanato quirantsancari seque quimin jominhe. Aman Diosinan, tsachilanan yaca se timin jominlae latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Junni mantá tan patelelabe chiquila tala mantaminlabe yaca totesa carilaquee latinue. Ya tsachica miyachi cuwapoto, corosibi totesa carilaquee tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","¿Chiquilari meralarayoco? yape Diosi ereca jun tsachi chiquilachi toca se larisa. Junni chiquilachi tencari, pansileri Jesuri jun se larimin tsachi jochunae tenjalaquee tilatinue. Chiquilari tsanque tenca talarasanan, yaca totelaquee. Aman yaca totenun peman mari joe. ");
INSERT INTO cofNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Junni chiquilari junca laqui chularasanan, chiquilachi bolon sonalari chiquilaca wepanarilaquee. Yalari amana quepenan menaranun foroca manquirabi jilainue latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Junni aman junchi jito, Jesuca itoe tide manjalaie. Junsi yalachi quirajanasa anjelilaca quiralaquiyoe latie tilatinue. Ya anjelilari wari Jesuca pato, ya mansonhica joe tilatitie tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aman jun fiquica merasi, chiquila tala weyanlaman menaranun foroca jito quiranari, Jesús itominue. Sonalachi fiqui tsa jominue tilatie latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Junni Cleófalari tsantinunsi Jesuri itsantinue: —Nulari tenca itonla joe. Aman matu tote Diosichi mantate paminlari Cristo tinun tsachica duque pila chutelaquinue. Nulari wari yalachi jera fiquica quereitumin tsanni jolajoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Aman yalari Diosi wenteca Cristo tinun tsachi tsanque padeseichunae ticala jotun? tinue. ¿Jera padeseitobiri duque mantá cachunae ticala jotun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aman Jesús tsantisi, yalaca Diosichi Pilaca duque micarinue. Casaleri Moisés chuteca pilabi, junsi Diosichi mantate paminlachi pilabi jera micarinue yaca niyan ticala jonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Junni micaride jinaminnan, Emaús pueblobi felainue. Aman Jesuri jun pueblose poleto jinamin tsanni tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Junni ya tsachilari yabe duque rocainato, nantari jitude! tilatinue. Quebi inae. Chiquilachibi catsoto, ayuna nanchi manaman jina! latinue. Junni aman yari junlachica pejinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aman inale ano filaquinaminnan, Jesús bibuca casi, Diosibe acradeseito, pisuleto, yalachi cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Junni bibu cuwanasaleri, yaca mantenhilainue Jesús joeque. Diosi yalaca mantenhisa carinue. Junni yalari yaca mantenhinunsileri, piyapoleniinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Junni yala tala itsanlatinue: —Minubi janato, chiquilaca Diosichi Pila micarito cuenta quinasanan, ¿chiquilachi tencabi tsaracari son ilaiyoco? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aman Jesús piyapolenunsileri, Jerusalenca manjito, Jesube penenaminlachica manjilainue. Chunca manca Crístochi mantá tanlabe weyan Jesube penenaminlabe junbi layaito chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Junni Emaúbi nechi janaminlari capatusanan, Jerusalenbi chuminlari casale paniquito, Miya Jesús tsa mansonhinue latinue. Simonbe quirainue latinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Junni yala tsanlatinunsi, Emaúbi nechi janamin tsachilanan jera cuenta pequilaquinue. Yala janasa minubi niyanhica jonunca, bibu cuwanasa mantenhica jonunca, jera cuenta polarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aman Jesuchi tsachila tsanque cuenta quilaquinasanan, Jesús patsa yalachi quitsabi quiraito itsantinue: Pansi chularana! tito saludainue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Junni Jesuchi tsachila yaca quirasi, puyan oco jonhoeque wepanato, duque jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Junni Jesús yalabe itsantinue: —¿Niyaito nulari jele tilatinayun? ¿Niyaito wepanato tenca calaquinayun? ");
INSERT INTO cofNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aman nula lachi tedeca, nedeca quiralaquede! La patsa joyoe. Puyan ocolari tsachica iton, chide iton, jolajoe. Laca taquirato miide! tinue puyan oco itonunca. ");
INSERT INTO cofNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Junni aman Jesús tsantisi, yachi tedeca, yachi nedeca quirawonue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Junca quirato, yalari son tilatinatonan wepanalainatonan, caquereilaitunue. Junnasa Jesuri itsantinue: —¿Ano fino talarayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Junni yachi watsa asuwaca juncanan, china picanan cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Junni Jesús junca cato, yalachi calenan finiquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Junsi Jesús yalabe itsantinue: —¿Diosichi Pilabi laca duque chuteca joco la niyanhino jonunca? Moisés Diosichi mantá chuteca pilabi, Diosichi mantate paminlachi pilabinan, Salmo pilabinan, jeralebi laca duque chutecala joe. Junni lari nulabe canenaminnan, nulaca micaricayoe junbi ticatiya chuteca jonari, jera jun tsannan patichunaeque. Junni amana jera jun tsanquenan patinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aman Jesús yalabe tsantinato, Diosichi Pilabi chuteca fiquica seque tuino podeisa carinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Junsi Jesús itsantinue: —Diosichi Pilabi laca Cristo tito, itsanque chuteca joe tinue. Puyaca jominnan, peman mate mansonhino joeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Junni la puyato mansonhicabi, piyanle tote tsachilaca jera meracarintsan jochunaeque chuteca joe tinue yalachi jutsaca piyarintsan jochunaeque. Aman jutsa quinunca telaquepoto, casan tala tenca mancalaquinari, yalachi jutsaca piyarichunaeque meracarintsan jochunae tinue. Casale Jerusalenbi, junte nechi piyanle tote, lachi mantate jera tsanque meracarintsan jochunaeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aman nulari la niyanhica jonunca jera quiraminla joto, meracarinola jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Junni meralaquede! tinue. Lachi Apa Diosi nulachi ticato cuwanae ticae tinue yape nulachi tenca sonba ilaisa. Junni lari junca nulachica ereyanae tinue. Junni nula Jerusalenbi meralarana! tinue tiyatotiya jamochi nechi patato, nulachi tencaca jera sonba suwano fecári. ");
INSERT INTO cofNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Junni Jesús tsantitobi, yachi tsachilaca Betania pueblo fecári petanjinue. Junto tedeca jalitato, yachi tsachilaca bendesiquinue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aman tsanquinaminca Diosiri yaca jamochi mantanlonue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Junni lonaminca quiratobi, yachi tsachila yaca duque se tito, son tito, Jerusalenca jera manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Junni yalari ma cura Diosichi yabi nenato, Diosica seque pamin jominlanue. Tsanqueri joe.");
INSERT INTO cofNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","To quino mate numa jominue. Diosibe pejominue. Yari tsachilachi micuwanue Diosi niyan jonunca. Junto yaca “Diosichi Fiqui” tinun joe. Junto “Diosichi Fiqui” tinun jotonan, yanan Diosinan jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Numari mate tinantiya caitosanan, yari Diosibe numa pejominue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yari jera quinue Diosichi sonbabe. Ya itomanpari, tinantiya itono jomin jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yari tsachilaca sonnasa carimin joe. Tsachilaca sonnasa carito, tencabinan tsen suwamin joe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yucan mantimini tsachilachi tencaca nemen suwachi timin joe. Tsantinatonan, ya tseminca piyarino podeitumin joe. Nementenan catsequiniquinae. ");
INSERT INTO cofNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Junni manca tsachiri Diosi mantaca jun jominue Juan mumun. ");
INSERT INTO cofNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yari tsen suwaminca cuenta polarichun jominue yape jeralela junca meráto tsen suwaminbe cayailaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanni tsen suwamin itominue; yaca cuenta quiminsiri jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tsen suwamin mantimini tobi pataca jominue. Yari jeralelachi tencabi tsemin joe. Tsachilachi tencabi yasiri tsaracari tsemin joe yape miralarasa. ");
INSERT INTO cofNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Junto to quimin jotonan, totenan chuminue. Tsan josanan, jerale tote chuminlari yaca mo jonunca tenhitulajonue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ya quica tobi manpatanan, yachi tsachilanan yabe cayailaitunue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Weyan weyanla mantimini yaca tennato yabe cayailainue. Junni yalaca Diosichi nalala ino podeisa mantá cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Junni Diosichi nalala inori uyan quiraque joe. Tsachi nalala nainun cuwenta itoe. Diosi patsa yachi nalala suwamin joe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Junni ya “Diosichi Fiqui” tinun jominnan tsachi inue. Tsachi ito, chiquilabe pesonnaminue. Duque laquirato, tsarasica pamin jominue. Apa Diosichi mancari Nao joto, duque mantá tan jominue. Junni tsan jominca chiquilari quiralaquiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Junni Juanni yaca quirato cuenta quee. Sonba pato, itsantie: —Nulabe cuenta quinato, laca fe mantá tan tsachica cuenta quicayoe. ¿Yari laca caquenan jominue tituan? tie. ¿Junto lachi benechi jatonan, laca fe jochunae tituan? tie. Junni la tsantica jun tsachiri Jesús joe tie. Juanni Jesuca tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Junto Jesuri tsaracari sen joto, jeralelabenan sen joe. Chiquilaca duque laquiramin joto, chiquilabe nantanancari seide seide jimin joe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jana Moisés matu mate Diosichi mantaca micarinatonan, Diosi tsaracari laquiraequeri patunue. Jesucrístori junca pae. Yari tsarasica pamin joto, Diosi laquiraeque pae. ");
INSERT INTO cofNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Uyanlari Diosica natiya quiralaquitue. Yachi mancari Nao mantimini yabe man parejo chumin joto yaca micuwae. ");
INSERT INTO cofNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Junni israelítalari Juanbe panhabi Jerusalenbi nechi jalaie. Patelelabe yalachi lebita tinun ayudaiminlabe jalaie. Yala israelita mantaminla mantaca junla jato, ¿Moyun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Junni Juannan tsaracari tuca pato, itsantie: —Diosi wenteca jun Cristo tinun tsachi itoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Junni Juan tsantinunsi, ya itotori, ¿matu to Elíayun? tilatie. Juanni yanan itoyoe tie. Junni yala jaca junlari mannan manpanhalaquee: —Diosichi mantate pamin tsachi jano jominue. ¿Yayun? tilatie. Junni Juanni te, yanan itoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Junni Juan tsantinan, israelítala manan manpato itsanlatie: —Mo jototiya paniquede! tilatie chiquilaca ereminlabe mo jonunca manpalaquichun. ¿Mo joyoe tiyun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Junni Juanni itsantie: —Matu to Isaías Diosichi mantate pila chuteto, laca panue. Niyanlanantiya chutunun postote tsachi manca sonba pato payimin jochunaeque chuteca joe tie. Miya jano jonun tenchi jera manseilainade! tichunaeque chuteca joe tie. Junni lari ya tsachi joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aman Juánchica jaminla weyanlari fariseo tinun bolon jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Junni yalari itsanlatie: —Nuri Cristo itotori, Elíanan itotori, Diosichi mantate jano jun tsachinan itotori, junni ¿ti quichun mumunnayun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Junni Juanni beco manpato itsantie: —Lari nulaca pibiri mumunnayoe. Manca tsachi mantimini laca benechi jachunae tie. Nulachite numa nenasanan, nulari yaca miitolajoe. Yari laca fécari mantá tan tsachi joe tie. Ya tsaracari sen jonan, lari yachi sapato silicari woleto cuwanotiya sen itoyoe tie seri sen jotonan. ");
INSERT INTO cofNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betábara pueblobi Juanbe tsanque panhalaquinaminhe Jordán pi man becochi. Juan junte mumunnaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Junni ayuna nanchi Jesús Juánchica janue. Junni janaminca quirato, Juan yaca itsantie: —Quiralaquede! tie. In Jesús Diosi cuwaca jun opisa na cuwenta jochunae tie. Piyanlelachi jutsaca piyarimin jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","¿Quisinan lari yaca patuan? ¿Laca benele laca fe sen tsachi manca jachunae tituan? tie. Lari na caitosanan, yari numa jominue; junto laca fe tsachi joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Junni lanan miitomanyoe tie mo jonunca. Tsan jotonan, yape israelítalari yaca miilaisa pibi mumunnamanyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Junto Juan Jesuca jun cuenta quinato, man fiquinan itsanque pae: —Lanan miitomanyoe tie ya mo jonunca. Junni Diosi lachi micuwae. Laca tsachilaca pibi mumunsa ereto, labe man fiquinan pae tie. La quiranasanan, yachi Tenca patachunae tie tie. Tsachi mancachibi patato jamo chudichunae tie tie. Ya tsachiri pibiri mumuntumin jochunae tie tie. Yari Diosichi Tencachi mumunmin jochunae tie tie. Diosi labe tsanque cuenta quee tie. Junni yachi Tencaca quirayoe tie. Paloma tsan jamochi nechi patato, Jesúchibi jamo chudie tie. ");
INSERT INTO cofNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Junto junca quirato nulabe pánayoe tie ya Jesuri Diosichi Nao joeque. Juan israelítalabe tsanque jera cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Junni aman ayuna nanchi Juan yachi tsachila palucabe wiruraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Junni yari Jesús jinaminca quirato, quiralaquinade! tinue. Ya Diosi cuwaca jun opisa na cuwenta joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Junni paluca Juanbe penenaminlari junca meráto, Jesuchi benechi jilainue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Junni Jesuri quiraereto, benechi janaminlaca quirato, ¿Tica neyalaquinayun? tinue. Yalari yaca Rabí tito, ¿Tile chuyun? latinue. (Aman israelítala tala micariminlaca “rabí” tinunla joe.) ");
INSERT INTO cofNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Junni yala tsantinan, Jesuri quirabi pejilaisa! tinue. Junni yachica quirabi pejito, jun mate yabe chuminlanue. Cuatro de la tarde tsansi jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Junni Jesuca quirabi pejimin manca, yari Andrés jominue. Ya Simón Pédrochi aco jominue. Andrebe manca amicobe Juan pacaca meráto, Jesube pejica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Junni Andreri yachi acoca neyato fenue ya Simón tinunca. Yaca fetobi, Crístoca quiralaquiyoe latinue. (Aman jun matu to fiquichi Diosi wenteto ereca jun tsachica Cristo tino jominue.) ");
INSERT INTO cofNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Junni Simonca Jesúchica tanjalainue. Junni Jesús ya Simonca tulan quirato, itsantinue: —Nu, Simón, Jonachi nao, amana nuca manca mumun manpochinayoe tinue. Nuca Cefas tinun jochunae tinue. (Aman israelítalachi fiquichi Pedro tito, Cefas timin jominlanue.) ");
INSERT INTO cofNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ayuna nanchi Jesuri Galilea toca jino tenca canue. Junto Felípeca neyato féto, yacanan labe pejisa! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felíperi Betsaida pueblobi nechi jominue. Andrebe Pédrobenan junbinan chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Junni Felíperi Nataniélica neyato féto, yabe itsantinue: —¿Moisés matu mate Diosichi mantaca chutenato, Diosi wenteto ereno jun tsachica pila quica joco? ¿Diosichi mantate paminlanan ya Cristo tinun tsachica pacala joco? tinue. Aman junni chiquilari wari yaca quiralaquiyoe tinue. Jesús mumun joe Josechi nao. Nasaret pueblobi nechi joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Junni Nataniéliri Felípeca meráto, ¿Nasarela sen jolajochinan? tinue. Felipe mantimini quirabi janiide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Junni Jesuri Nataniel janaminca quirato, yaca itsantinue: —Quiralaquede! Ja tsachi Nataniel sen israelita joe. Natiya nene patumin joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniéliri yaca meráto, ¿Niyaito laca miiyun? tinue. Junni Jesuri beconan pato itsantinue: —Felipe nuca cajasa titusanan quiracayoe tinue ico pele tenpe chuminca. ");
INSERT INTO cofNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Junni Nataniélinan Jesuca Rabí tito itsantinue: —Nu Diosichi Nao joe. Israelítalachi Miya joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesunan itsantinue: —¿Nuca ico pele tenpe quirayoe tinun tenchi labe cayainayun? tinue. Nantanancari wepanato quirantsancari quinunca quirachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","La tsachi ica jun joto tsarasica pachinayoe: Yoquido lasainan Diosichi anjelila lachite patato manlolaichunae. Junni nulari juncanan jera quiralaquichunae tinue. Jesube Nataniélibe tsanque cuenta quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Junni peman mate casalainaca fiesta jominhe Caná tinun pueblobi Galilea tobi. Jesuchi ayan junbi pejominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Junni fiesta quimin tsachi Jesúcanan jasa tica jominhe yachi tsachilabenan. ");
INSERT INTO cofNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Junni fiesta quilaquinasa, bino jerainue. Jerainunsi, Jesuchi ayan yachica jato, bino jeraie tie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesuri itsantie: —Ayan, ¿ti quichun labe tsantiyun? La titiya quino óra caitoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesuchi ayan mantimini fiestate mantaiminlaca itsantie: —Chiquechi nao nulaca ticatiya quisa tinari, quinilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aman junbi sotaca suca ponto quica jun chuminue. Ya ponto cura palu chunca calon tsansi pocamin jominue. Junbi pi ponun jominue yape israelítalachi mite tede tsalen, caforo tsalen, quilaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Junni Jesuri peyunlaca pi polaquede! tie. Jera pontobi tuwale pi polaquede! tie. Tsantinunsi jera pontobi pi tuwale polaquee. ");
INSERT INTO cofNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Junni ya pica manlaricato, fiestabi cuidaiminchica tanjide! tie. Junni pica laricato, fiestabi cuidaiminchica tanjito cutsawoe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tsan josanan, yari cuchito quiranari, pi itominue; bino ica jominue. Peyunlasiri miraminlanue casale pi jominca bino suwaca jonunca. Fiestabi cuidaiminni miitominue tile nechi bino jonunca. Junto casalainamin unilaca jacarito, ");
INSERT INTO cofNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","itsantie: —Jerale fiestate casale sen binoca cutsawominlae tie. Junni tsachila michi cuchilaquinasa, nanni seiton binoca cutsawominlae tie. Nu mantimini tsantuchinae tie. In bino tsara sen joe. Casale cutsawocaca fécari sen bino joe tie. Fiestabi cuidaimin tsantie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Junca wari Jesús casale wepanato quirantsancari seque quee yaca duque mantá tan joeque tenhilaisa. Caná pueblobi tsanquee Galilea tobi. Junni yachi tsachila junca quirato, yaca fécari quereilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Junni ya fiesta jeraitobi, Jesube yachi ayanbe yachi acolabe yachi tsachilabe Capernaum puebloca jito, junte nasi chuminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Junni aman israelítalachi casa ma fiesta inasa, Jesuri Jerusalenca jie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Junsi Diosichi yabi wito quiranari, duque necosio quinaminlanue. Weyanlari walaca, opisaca, palomaca osinaminlanue. Weyanlari cala waladalaquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Junni Jesús na sili tsominca cato, toreto, asota jera quee. Junsi asotaquito jerale necosio quinaminlaca sularie. Opisacanan, walacanan sularie. Junsi cala waladaminlachi cala jera ara talulu ereto, yalachi mesaca tulipoereto cuwae. ");
INSERT INTO cofNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paloma osinaminlaca palomaca Diosichi yabi nechi larilaquede! tie. Lachi Apachi yaca mercado suwatuntsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Junni Jesús necosio quinaminlaca sularinasa, yachi tsachilari Diosichi Pilabi man fiqui chutecaca mantenhilaiyoe. Diosichi yaca tsaracari respetaintsan joeque chuteca joe. Padeseino jototiya, jun yaca respetaisa carino joeque chuteca joe. Junni Jesús necosio quinaminlaca sularinasa, jun fiquica mantenhilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Junni Jesús tsanque sularierenasanan, israelita mantaminlari yabe itsanlatie: —Diosichi mantate tsanquinatori, ticatiya wepanato quirantsancari quede! tilatie mantá tan jonunca chiquilari miilaichun. ");
INSERT INTO cofNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Junni Jesuri beconan pato, yalabe itsantie: —In Diosichi yaca balelaquinari, peman materi manqueyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Israelita mantaminlari jun fiquica meráto itsanlatie: —Junpalu chunca sota wata fecári in yaca quinacala joe. ¿Junni nuri peman mate manquino podeichiton? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús mantimini peman materi manqueyanae tito, suca quica yaca tsantitunue; yachi pucaca tsantinaminue. Yachi pucaca Diosichi ya cuwenta joyoe tito tsantinaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Junni Jesús puyato peman mate mansonhinunbi yachi tsachila mantenhilaiyoe ya tsantica jonunca. Junca mantenhito, Diosichi Pilacanan, Jesuchi fiquicanan fécari quereilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Junni aman casa ma fiestate Jesús Jerusalenbi duque wepanato quirantsancari seque quede nenaminue yape tsachila miilaisa. Junni duque israelítala junca quirato, yabe cayailaie. ");
INSERT INTO cofNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Junni Jesús mantimini cayaiminlabe natiya mantaitue. Yari jerale tsachilaca miraminue. ");
INSERT INTO cofNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Uyanlabe tsachilaca panhatuminnan, yari tsachilachi tencaca numa miraminue niyan jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Junnasa israelita mantamin tsachi manca jominue Nicodemo mumun. Yari fariséola tala Diosica tenca camin jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yari Jesúchica quepen nosa jato, yaca respetaito pato, Rabí tito itsantinue: —Nuri duque seque wepanato quirantsancari quinae tinue. Junto miralarayoe tinue Diosi ereca jun joto micarimin joeque. Diosi ereca itomanpari, tsanquino podeino itomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Junni Jesunan Nicodémobe itsantinue: —Nube tsarasica pachinayoe tinue. Casanle nechi na manhintsan joe. Casanle nechi na manhitutori, Diosi mantananun tsachi bolonbi numanan wino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Junni Nicodemo itsantinue: —Unica jotori, ¿niyaito na manhino podeicaichunan? tinue. Ayanchi pecolobi manwito na manhino podeituntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesuri junca meráto itsantinue: —Nube tsarasica pachinayoe tinue: Pibe Diosichi Tencabenan na mansuwamin joe. Tsanhituminlari Diosi mantananun tsachi bolonbi wino podeilaituchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tsachilabe naica junlari tsachilachi nalala jolajochunae. Diosichi Tencabe naica junla mantimini Diosichi nalala jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na manhino joe ticaca wepanatude! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wu cuwenta jochunae. Wu nunchitiya quiniquichunae tinue. Wuca meránatonan, tile nechi jananunca miituntsan joe tinue. Nunchi jinanuncanan miituntsan joe tinue. Diosichi Tencabe naica junlari jun cuwenta jolajochunae tinue. Diosichi nalala jolajoeque miratonan, niyaito tsanhicala jonunca miituntsan jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Junni Nicodémori Jesuchi fiquica meráto, ¿Niyaito tsanhino junhun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Junni Jesunan yabe itsantinue: —Nuri israelítala tala micarimin jotonan, ¿junca entendeitiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nube tsarasica pachinayoe. Miranuncari cuenta quinayoe. Quiranuncari pánayoe. Tsantinasanan, nulari quereilaitue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Junni meránade! Toteri niya jonunca pánasanan quereitutori, jamochinan niya jonunca pánari ¿niyaito quereilaichun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Monantiya Diosichica lotulajoe. La mantimini tsachi ica jun joto Diosichibi chunyoe. Junni lasiri junbi nechi patacayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Matu tote Moisechi pinica mantenhide! tinue. Israelítala niyanlanantiya chutunun tose polenato, Moisés pini molde quito jamobi eruncarinue yape tsachila pinica quirato manseilaisa. Junni lanan tsachi ica jun joto corosibi erunhino joyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Corosibi erunhino joyoe yape labe cayaiminlachi tenca puyatuto numatotiya sonnato polelaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Diosi piyanlelaca duque laquirae. Tsancari laquirato, yachi mancari Naocanan erenue yape yabe cayaiminlachi tenca puyatuto numatotiya sonnato polelaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosi yachi Naoca erenue tobi nenasa. Junni tsachilaca culpa quisa eretunue. Te, tsachilaca se larisa erenue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yabe cayaiminlacari culpa itonla joe timin joe. Yabe cayaituminlacari numa culpa quica jochunae Diosichi mancari Naobe cayaitunun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","21","Tsarasica tenca calaquede! Jerale seiton quiminlari tsen jonunca munaratulajoe. Tsen jonunte jatuchi timinla joe yape seiton quilaquinaeque monantiya miilaitusa. Jutsa quituminla mantimini tsente janiiminlae yape uyanlanan miilaisa Diosibe seque nenalaraeque. Junni Diosi tsachilaca itsanque quirato miica joe seiton jolajoeque: Yachi Naoca toca erenue yape tseno cuwenta josa. Juntonan tsachila mantimini tsenoca munaratulajoe. Yucanbe nemente nenanoca fe munaralarae. Jun tenchi Diosi yalaca culpa tanla joe tica joe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Junte nechi Jesube yachi tsachilabe Judea toca jilaiyoe. Junbi chuto mumunnaminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Junnasa Mumunmin Juan Enón tinun pueblobi chuminue Salim pueblo quelote. Junte wapun pi jonan, tsachila jato Juanbe mumunhinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juanni cadoica itominue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Junte Juan mumunnasa, yabe penenaminlari israelítalabe cuenta quinaminlanue mumunhinoca. ");
INSERT INTO cofNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Junni Juanbe penenamin tsachila yachica jato itsanlatinue: —Jordán pi ja beco tsachi manca nuchica jaca jominhe. Nuri micarinato yaca paca jominhe Diosichi opisa na cuwenta jochunaeque. Junni yanan mumunnae latinue. Junni jeralela nuca puraniquito, yabesiri jera penenamin ilainae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Junni Juan yalaca meráto itsantinue: —Diosi yachi tenca munate chiquila palucaca mantamin joe. Junni Diosi Jesuca fe josa tinari, yari fe mantá tachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nula lachi fiquica meracalae Cristo itoyoe tinunca. ¿Cristo itoto yaca caquenan jamin joyoe tituan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Meralaquinade! tinue. Jesuri casalainamin unila cuwenta jochunae tinue. Casalainaminni sona camanhe. Casalainaminchi amico, yari sona catumanhe. Juntonan casalainamin unila janaminca meráto, yachi amiconan son jochunae. Yari sona catutonan, amicochi tenchi son pejochunae tinue. Junni tsachila Jesúchica jilainasa, lari jun tsanquenan son joyoe Jesuchi tenchi. ");
INSERT INTO cofNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tsachila Jesuca fe tenca cade cade jinola joe; laca nanni purade purade jinola joe tinue. Mumunmin Juan tsanque cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Junni Mumunmin Juan itsantinue: —Jamochi nechi patamin tsachiri jeralelaca fécari mantá tan joe. Tote nechi tsachi mantimini tsachilachi miteri nenamin joe. Tsachilachi miteri pamin joe. Jesús jamochi nechi pataca joto, ya jeralelaca fe joe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tsan josanan, ya quiraca jonunca, meraca jonunca cuenta quinasanan, tsachilari yaca merátuchi timinla joe. ");
INSERT INTO cofNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yaca meráminlari Diosi tsarasica pamin joe tilatichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jesuri Diosi ereca jun jato, Diosichi fiquica pamin joe. Junni Apa Diosi yachi Tencaca Jesuchi cuwanato, nasi nacári cuwatunue; jera cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apa Diosi yachi Naoca laquirato, yachi jera mantacanan cuwanue yape jeraleca mantamin josa. ");
INSERT INTO cofNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Diosichi Naobe cayaiminlari Diosibe numatotiya sonnato polelaichunae. Yaca merátuminlari Diosibe numatotiya sonnato polelaituchunae; Diosi yalaca paito casticaquichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Aman junni duque tsachila Jesube penenaminla ito mumunhilaie. Aman Jesús patsa mumuntue; yabe penenaminlari mumunnaminlayoe. Junni Jesuchi tsachilari Juanchi tsachilaca fécari duque seranaminlayoe. Junni fariséolari junca meralaquinue. Junni ya fariséola junca meralaquinueque miito, chiquilabe Jesube ");
INSERT INTO cofNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Judea tobi nechi lolaiyoe. Judéabi nechi loto, Galilea toca manjilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aman Galilea toca jinato, Samaria tose poleno jominlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Junni Samaria tobi jinaminnan, Sicari tinun pueblo quelole felaiyoe. Matu to Jacobo jun quelole to tato, yachi nao Josechi cuwaca jominue. Junni jun to quelole chiquilabe Jesube felaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Junni chiquila nenanunte Jacóbochi pi canun foro jominue. Junni Jesús duque nenato, pepaica joto, pi forote chudie. Quitsa ma jonan, ");
INSERT INTO cofNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","yabe penenaminlari ano finoca cabi puebloca jica jominlayoe. Junni chiquila jica josari, Samaria to sona pi cabi janue. Junni Jesuri yabe pi cuwade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Junni ya sonari Jesús tsanticaca meráto wepananue. Israelítalari Samárialaca pa jolajominue. Junni ya Samaria to sonari wepanato meráto itsantinue: —¿Nuri israelita joto, niyaito Samaria to sonabe pi panhanayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Junni Jesuri itsantinue: —Diosi epe cuwanunca nuri miitoe. Lacanan miitoe mo jonunca. ¿Nuberi pi panhanayoco? Junni la mo jonunca miramanpari, labenan pi panhano jomin jonhoe. Lari uyan quiraque pica cuwano jomin joinhie tinue. Sonnasa carimin pica nuchi cuwano jomin joinhie tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aman Jesuri yaca quereiminlaca Diosibe sonnasa carimin joyoeque pato, sonnasa carimin pica cuwamin joyoe tinue. Junni ya sonari junca tuituto, tsa pica tsantinaeque tenca cato, itsantinue: —In forobi duque tenpe pi poe. Nuri pi canun itoe tinue. ¿Junto sonnasa carimin pica niyaito cachun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Chiquilachi matu tata, Jacobo tinun, in foroca quinue. Aman yabe yachi familialabe yachi opisa, wala tsanlabe in pibi nechi pi cato cuchimin jominlanue tinue matu mate. Junni yari in pi foroca chiquilachi puranue. ¿Nuri wari Jacóbocanan fe poden joyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Junni Jesuri ya sonaca meráto itsantinue: —In pica cuchiminla manan pi manmunaralarachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","La pi cuwacari uyan quiraque jono joe. Ya pica cuchiminlari numatotiya peyan joto polelaichunae. Michi joe tilatichunae tinue. Yalachi tencabi pi bulananun cuwenta jochunae. Ya piri yalachi tencabi tenca mánta serade serade jiniichunae tinue. Jun piberi Diosichibi numatotiya sonnato polelaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Junni ya sonari Jesuchi fiquica jera catuituto, itsantinue: —Jun pica chiquechi cuwade! tinue. Cuwade! pi manmuquetusa, inte pi cabi manjatuchun. ");
INSERT INTO cofNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Junni Jesús yabe manpato, nuchi unilaca mancáchin! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Junni sonari unila itonyoe tinan, Jesuri junca meráto tsa tie tinue. Nuri manteca unila tamin jotonan, amana tanun unilari nuchi unila itoe tinue. Junto unila itonyoe tito tsa tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Junni ya sonari jun fiquica wepanato meráto itsantinue: —Nuri Diosichi mantate pamin jonhoda tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tsan jotori, chiquebe man fiqui pade! nasi. Samaria to tsachilari, chiquilachi matu tatalachi mite nenato, ja dubi Diosibe rocaito se timinlayoe tinue. Nula israelítala mantimini uyan tala paminlae. Jerusalénbiri Diosibe rocaito se tintsan joe timinlae tinue. ¿Junni nuchi niya quiraque tenca jan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Junni Jesuri yabe itsantinue: —Meráde! tinue. Nube tsarasica pachinayoe. Inale ja dunan, nin Jerusaléncanan jitutonan Apa Diosibe rocaito se tilatichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nula Samárialari Diosica miitolajoe. Miitonunbe rocailainae. Chiquila israelítala mantimini Diosica tsarasi mirato yabe rocaiminlayoe tinue. Aman se larimin tsachinan israelita jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Junni tenca cade! Diosibe rocainato yaca se tinatori, tencabiri tsanquintsan joe. Apa Diosi tsachilaca tsanquisa munarae. Diosibe tsarasi rocaiminla, yaca tsarasi se timinla, inale tencabiri tsanlaquichunae tinue. Amananan tsanquilaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosiri puca itoe. Tencari joe. Junni yabe rocaito yaca se timinlari yalachi tencabiri tsarasi tenca cato tsantinola joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Junni ya sonari jun fiquica meráto itsantinue: —Diosi ereca jun tsachiri, Cristo tinun, jano jonhoeque mirayoe tinue. Yari jatobi, chiquilaca jera tuca micarichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Junni Jesús yaca meráto la Cristo joyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Junni Jesús tsantinasale, yabe penenaminla manjalaiyoe. Junni chiquilari wepanalaiyoe sonacanan micarinaeque. Wepananatonan, natiya panhalaquitiyoe. Sonaca ¿tibi jayun? Jesuca ¿niyaito sonaca micarinayun? titulajoyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Junni ya sonari pi pocanunca purato, puebloca manjie. Junni pueblobi féto, junbi chuminlabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jalaide! tinue. Chiqueca ti quimin jonuncatiya jera miimin tsachica quirabi jalaide! ¿Yari Cristo jonhoncan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Junni sona tsantinunca meráto, pueblobi nechi Jesúchica jalainue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Junnasa Jesuchi tsachila yaca Miya, ano finiquede! tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Junni Jesuri nula miratununca ano finun tayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsantinan, ¿uyan tsachila yachi ano finoca tanjaca jonhoncan? latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Junni Jesuri itsantie: —Ano tito, tsa ano finoca tsantitiyoe tie. Diosi laca erenato mantaca joe tie jera ti quino jonunca. Junni tsanquino labe ano finun cuwenta joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nulari ja witaca quirato, junpalu pete cantsan ichunae tenhilaichunae tie. Te, tsantituntsan joe tiyoe. Jana janamin tsachilacari quiralaquede! tie. Yalachi tenca wita waca cuwenta jolajoe. Junni yalaca cachun camérano itoe. Numa cantsan icala joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Junni aman ¿witabi caminlachi pacara quintsan jotun? tie. Aman jun tsanquenan tsachilaca labe cayaisa cariminlachinan Diosi senca cuwachunae tie. Cayaiminlari Diosibe numatotiya sonnato polelaichunae tie yape waqueminlabe caminlabe parejo son tilatisa. ");
INSERT INTO cofNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","¿Israelítalari itsantiminla jotun? Waquemin manca joe; camin manca joe timinlae. ");
INSERT INTO cofNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Junni nulaca jun tsannan quisa carinayoe tie. Uyanlari yalaca Diosichi fiquica casale micarilaquee. Junni nulanan yalaca labe cayailaisa carilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Junni Jesús chiquilabe tsantinasanan, Samaria to tsachilari jun pueblobi nechi loto chiquilachica jalaie. Jun sona yalabe paca jominue ya titiya jera quimin jonunca miieque. Ya sonachi fiquica meráto, duque tsachila Jesube cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Junto Jesúchica jato, yalabe nasi pechusa latie. Junto palu ma fecári Samárialachite chuminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Junni Jesuchi fiquica meráto, nantanancari duque tsachilari yabe cayailaie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Junni yalari cayailaito, jun sonabe itsanlatie: —Nuchi fiquica meráto tsa jonhoe tilatiyoe. Junto Jesuchi fiquicari meráto, tsarasi miralarayoe latie Jesús jeralelaca se larimin joeque. Diosi ereca jun Cristo tinun tsachi joeque miralarayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Junni palu ma poletobi, Galilea toca jilaiyoe. Ya Jesús uwainun to jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aman Jesús chiquilabe cuenta quinato, Diosichi mantate paminlaca paca jominhe yalachi tobi chuminlari yalaca merátuminla jochunaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tsan josanan, Galilea to tsachila Jesuca facaricanilaquee. Yalanan Jerusalenca fiesta quirabi jica jominlanue. Junbi yalanan Jesús jera seque quinaminca quiraca jominlanue. Junto yaca facaricanilaquee yape yalachitenan jun tsannan quisa. ");
INSERT INTO cofNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aman Galilea tobi nenato, Caná puebloca manjilaiyoe. Junbi pica bino suwaca jominhe. Junni Jesuri Canabi chusanan, Capernaum tinun pueblobi na manca quiyainue. Yachi apari miyachi teniente jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yari Jesús Judéate nechi Galilea fecári jaca jonunca meráto, Jesúchica jae. Na puyachinaminca manse suwabi jade! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Junni Jesuri yaca meráto, itsantie: —Laca duque wepanato quirantsancari seque quinaminca quiratutori, laca quereilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Junni miyachi teniente tulanto itsantie: —Jiniisa! tie yape lachi na puyatusa. ");
INSERT INTO cofNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Junni Jesuri yaca pato, nuri manjiniide! tie. Nuchi na manseichunae tie. Junto nachi apari Jesuca quereito meráto manjiniie. ");
INSERT INTO cofNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Junni manjinaminnan yachi peyunlabe tulainue. Junni yalari nuchi na manseinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Junni nachi apari manpanhanue niyaque óra manseinunca. Junni peyunlari manpato, yotu pele inasale cupara mandeie latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jun fiquica meráto, nachi apari tenhinue Jesús manseichunae tica órate nechi manseinueque. Junca tenhito, yabe jerale yachi familialabenan Jesube cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Junni tsanque Jesuri Judea tobi nechi Galilea toca manjatobi, ya tenientechi náca manse suwae wepanato quirantsancari quito. Aman jun tobi man ne numa wepanato quirantsancari quica jominue yape tsachila quirato miilaisa. Inbe palu ne joe. ");
INSERT INTO cofNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Junni inale israelítalachi fiesta ma jonan, Jesús Jerusalenca jie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aman Jerusalén pueblobi winun tamolan mancaca Opisa Tamolan tinun jominue. Jun quelole pi foro joe. Israelítalachi fiquichi jun pi foroca Betesda tinun joe. Ya pi foro awintari manteca tamo iton ya joe. ");
INSERT INTO cofNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Junni jun yabi duque quiyanpunla, quirano podeitonla, jancanla, wecaino podeitonla titiya tsominlanue. Yalari pi wecaisa méraminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Anjeliri pansile pibi patato, pica wecacarimin jominue. Junni pica wecacarinasa, caque wimin manseimin jominue. Ti quiyanpunla jototiya manseimin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Junni tsan josanan tsachi manca peman chunca ochu wata quiyanpun joto, juntenan petsominue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Junni Jesuri yaca quirato, numari junbi tsominueque miito, yaca manseino muquinque panhae. ");
INSERT INTO cofNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Junni quiyanpun tsachiri itsantie: —Lari mocanantiya itoyoe tie pi wecainasa laca pibi posa. Pi wecainasaleri, la pica patino fecári uyanlari caquenan winiiminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Junni Jesuri yaca merasi, manwiruide! tie. Jalica mancato, nedechi manjide! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aman tsantinasale quiyanpun jomin tsachiri jera manseito, jalica mancato, nedechi manjiniie. Junni aman jun mate jasaino ma jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Junni israelita mantaminlari ya manseica jun tsachibe itsanlatinue: —Jasaino ma joe latinue. Jasaino mate jalica amanto jituntsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Junni ya quiyanpun jomin tsachiri beconan pato, itsantinue: —Laca manse suwamin tsachiri jalica amanto jiniisa ticae tinue. Lachi jalica mancato manjiniide! tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Junni mantaminlanan ¿Mo tsanquisa mantaquin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aman duque tsachila junte nenasa, Jesuri quiyanpunca manse suwasi, uyanchi mannenaniraminue. Junnan manseica jun tsachiri mo laca manse suwanunca miitoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Junni wanbile Jesuri ya quiyanpun jominca neyato, yaca Diosichi yabi manfee. Junsi yaca meráde! tie. Numa manseica joe. Junto jutsa manquituna! tie yape fe seiton quiyan mancatusa. ");
INSERT INTO cofNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Junni manseica jun tsachiri Jesuca tsanque merasi, israelita mantaminlachica manjinue. Yalachica manjito, yalabe paniquinue yaca manse suwamin tsachi Jesús joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Junni Jesús jasaino mate manse suwanun tenchi israelita mantaminlari Jesube seiton joto, yaca totechi latinaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús mantimini yalabe itsantie: —Lachi Apa Diosi trabajaquino cadeitue. Junnan lanan deitiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Junni ya fiquica meráto, israelita mantaminlari nantanancari pailainue. Jesús jasaino mate tennatumin jotonan, junsi Diosica “Apa” tinitinue. Diosica “Apa” tinato, yari Diosibe parejo joyoe tinaminue. Jun tenchi yaca nantanancari totechi tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsantin nenalarasanan, Jesús israelita mantaminlabe itsantie: —Nulabe tsarasica pachinayoe tie. Diosichi Nao jotonan, tenca mánta natiya quino podeitiyoe tie. Apa Diosi ticatiya quinanunca quiratori, lari jun tsannan quimin joyoe tie. Apa Diosi tsannan quimin joyoe tie yachi Nao joto. ");
INSERT INTO cofNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Apa Diosi laca Nao jonan laquirato, ya jera quinanunca micuwamin joe tie. Ya micuwanan, lanan Diosi tsannan quimin joyoe tie. Junni Apa Diosi lachi nanni fécari sen cosacanan quisa carichunae yape junca quirato nula wepanalaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Meralaquede! tie. Puyacalaca Apa Diosiri mansonhisa carimin joe. Junni yachi Nao joto lanan mansonhisa carimin joyoe tie. Lari mansoncarino munaranunlaca manson carimin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apa mantimini tsachilaca miito quiratuchunae mo sen jonunca o mo seiton jonunca. Lachi tsanque jera mantá cuwacae yape la yachi Nao joto jerale tsachilaca tsanque miito quirasa. ");
INSERT INTO cofNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Lachi tsanque jera mantá cuwacae yape jerale tsachila laca respetailaisa. Apa Diosica respetainola joe. Junni jun cuwentanan lacanan respetainola joe tie Diosichi Nao jonan. Lari Apa Diosichi Nao joto, Apa Diosi ereca jun jacayoe. Junni laca respetaituminlari Apa Diosicanan respetaitulajoe. ");
INSERT INTO cofNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","La nulabe tsarasica pachinayoe tie: Lachi fiquica merán, laca ereminbe cayain, iminlari numatotiya sonnato polelaichunae tie. Yalaca natiya culpa quino itochunae. Yalari yucanbe puyanun minuca purato, Diosibe sonnanun minuca uran penenalarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Junni nulabe tsarasica pachinayoe. Numa óra faca joe yape tenca puyaca junla lachi fiquica meralaquisa. Lari Diosichi Nao joto yalabe pachinayoe. Junni laca meráminlachi tencaca mansoncariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Junni Apa Diosiri tenca mánta sonnamin joto, uyanlacanan sonnasa carimin joe tie. Junto lacanan jun tsanquenan tenca mántanan sonnasa carinue. Junto lanan tenca mánta sonnamin joto, uyanlacanan sonnasa carimin joyoe Apa Diosi cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","La tsachi ica jun jonan, lachi mantá jera cuwacae yape jerale tsachilaca miito quirasa sen jolajonunca o seiton jolajonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Junni la tsantinanunca natiya wepanatulajona! tie. Man mate jerale puyaca joto menaraminlanan lachi fiquica meralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lachi fiquica meráto mansonhilaichunae tie. Seque quimin jominlari mansonhito labe pesonnalarachunae; seiton quimin jominlari mansonhito casticailaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Junni Jesús cacuenta quinato itsantie: —Lari tenca mánta natiya quino podeitiyoe tie. Apa Diosica meráto, yachi mantate miimin joyoe tsachila sen jonunca o seiton jonunca. Lachi tenca munateri quitumin joyoe tie. Laca ereminchi tenca munate quimin joyoe tie. Junto tsachilaca miito, seque miimin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Lachi tenca mánta pato, Diosi ereca jacayoe timanpari, nulari nene pánae tino jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","La tencachique paca fiquica meráno munaralaratuchunae. Junni lachi fiquica meráno muquilaquitunari, mancachi fiquica meráto, laca miilaide! mo jonunca. Yanan laca jun tsanquenan pachunae Diosi ereca jaca joeque. Yachi fiquica ura mirayoe tie laca tsarasica pamin joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nula tala weyanlaca Juánchica erelaquinue tie Crístoca panhalaquisa. Junni Juanni laca tsarasica panue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Junni la Juanca tsantinatonan, uyanchi fiquichi laca miilaide! titonan, Juanchi fiquica natiya tsantitiyoe. Yachi fiquiri sen fiqui josanan, Juanni tsachiri jominhe. Junni nulaca ayudaichunni Juanca tsanque pánamanyoe tie pansile yachi fiquica tenca cato se lolaichunaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanni lanparin cuwentari jominhe. Jana lanparinca tulito tile nenano jonunca miintsan joe. Tsanque Juanchi fiquica meráto, laca miino jominlanue laca Diosi ereca jun jaca joeque. Nula mantimini moorasiri Juan pacaca son titonan, mooranan yaca telaquinilaquee tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Junni la tsaina uyanchi fiquibe laca miilaide! tinato, Juanchi fiquica pátiyoe; lachi Apa Diosichi fiquica pánayoe tie. Lachi Apa laca mantaca joe tie ticatiya quisa. Junni nulari la tsanquinanunca quirato miino jominlanue laca Diosi ereca jaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Junni lachi Apa laca ereno joto, laca ura paca joe tie laca ereyanaeque. Nula mantimini yaca natiya merátumin, nin quiratumin jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nulari Diosi erecabe cayaituto, junsi Diosichi fiquica entendeituminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aman nulari Diosichi Pilaca quiracachiri quiraniquiminlae. Diosichi Pilabi niyaito numatotiya sonnato poleno jonunca miintsan joe tito, ya pilaca sen joe tito, duque quiraminla joe tie. Junni jun pilabi Diosi laca pánae. ");
INSERT INTO cofNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Diosichi Pila laca pamin pila josanan, nulari labe cayaituchi timinlae numatotiya sonnato polelaichun. ");
INSERT INTO cofNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tsan josanan tsachilari laca sen joe timinla josatiya, yaca la tennatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tsan jotonan nulaca mirayoe tie Diosica laquiramin itolajoeque. ");
INSERT INTO cofNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jun tenchi la lachi Apa Diosichi mantateri jaca jominca nulari tennatulajoe tie. Uyan tsachilari tencachique mantateri janari, yalaca tennalarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nulari Diosibe natiya cayaino podeitulajochunae tie. Nula talari beco beco sen joe tilatisa munaralarae tie. Mancari Diosi nulaca sen joe tisari natiya tennatulajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lari Apa Diosichi cale nulaca culpa quituanae. Culpa quichunaeque tenca calaquituna! Manca tsachi nulaca culpa quichunae tie. Matu to Moisés, ya Diosichi mantaca Diosichi Pilabi chutenue. Junni nulari Moisechi fiquicari tsarasica tennaminla joyoe timinlae. Junni ya Moisechi fiquibenan nula culpa ilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisechi fiquica tsarasi quereiminla jomanpari, lacanan quereino jominla jonhoe. Moisés pila chutenato, lacanan paca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Juntonan nulari yachi pilaca quereituto, lachi fiquicanan quereino podeilaituchunae tie. Jesús israelita mantaminlabe tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesús tsanque cuenta quetobi, Galilea tinun wa pipilu man becochi polelaiyoe. Ya pipilucanan Tiberia tinun joe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Junni pi poleto, Jesuri du minu jito yabe yachi tsachilabe chudilaiyoe. Du minu cajituminnan Jesuri duque wepanantsancari quito quiyanpunlaca manse suwanaminhe. Junca manse suwanaminca quirato, duque tsachila yachi beneca jalaie pi man becochi. ");
INSERT INTO cofNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israelítalachi casa ma fiesta queloinaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aman junni duque tsachila jalainaminca quirato, Jesuri Felípebe itsantie: —¿Inchi janaminlachi ano cuwachun tile cayaichunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús mantimini, yari numa miraminue niyan quino jonunca. Miichunni tsanque panhanue Felipe niyan tisa. ");
INSERT INTO cofNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Junni Felipe itsantie: —Duque animali ano munarachunae tie. Duque duque mican bibu canasatiya, jeralelachi nasi nasi nacári cuwano michi ichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aman Felipe tsantinunsile, manca Jesube penenamin tsachiman pae. Ya Andrés jominue Simón Pédrochi aco. Junni ya itsantie: ");
INSERT INTO cofNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Inte na manca nasi ano finocari tae tie; manteca sebada bibu, paluca watsa tae tie. In duque tsachilachi numanan michi ituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Junni Jesús Andrés tsanticaca meráto, tsachilaca chutelaquede! tie. Junte duque lapa jominue. Junto tsachila lapate chudilaie. Unilalacasiri minan, mante mili tsansi jominlae. ");
INSERT INTO cofNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Junni tsachila chudicala josa, Jesuri jun bibuca casi, Diosibe rocaisi, chiquilachi cuwanan, chiquila mantimini junte chumin tsachilachi cuwalaquiyoe yape bibuca filaquisa. Junsi ya watsacanan jun tsannan quilaquiyoe. Tsachila nisi munaranunca jera cuwalaquiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Junni tsachila peyaicala josa, Jesús yabe penenaminlaca itsantie: —Puchuicaca manlayalaquede! tie yape natiya puraitusa. ");
INSERT INTO cofNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Junni Jesús tsantinan, jera manlayalaquiyoe. Manteca bibu nacári jominnan, jun jerale tsachila ficala josanan, duquenan capuchuie. Puchuicaca manlayato tsalabi ponari, chunca paluca tsala tuwale jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tsanque wepanato quirantsancari seque quinanunca quirato, ya tsachilari itsanlatie: —¿Diosiri yachi mantate pamin tsachi mancaca ereno jominuco? ¿Junni inni ya jotun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aman junca son tito, Jesuca cabi janaminlae. Yalari sonba tito Jesuca miya suwachi tinaminlae. Junni Jesuri junca miito, du minu mancasiri jie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Junni aman quebite Jesuchi tsachilari wa pipiluca jilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesús chiquilachica cajatusanan, canoabi wito, Jesús ereca jun jilaiyoe. Wa pipiluca polebi jilaiyoe Capernaum puebloca jichun. Nemen jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Junsi sonban wu quinasa latsa lanaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Junsi mante quilon tsansi canoachi jinaminnan, Jesúcari quiralaquiyoe. Pi jamo nedechi janaminhe chiquilachi canoa fecári. Junni Jesús pi jamo janaminca quirato, chiquilari jele tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Junni Jesuri jele titulajode! tie. La joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ya tsantinunsi yaca son tito canoabi pocalaquiyoe. Junsi Jesús canoabi wiyanunsi, chiquila jinanun tobi numa feca jominla joanue. ");
INSERT INTO cofNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Pi man beco puraica jun tsachilari ayuna nanchi pi fecári manpatilainue. Junte Jesuri quisinchi Diosibe acradeseito yalachi ano cufica jominhe. Aman chiquila Jesube penenaminlari junte nechi jinato, Jesuca purato canoa mancari tsominbi jica jominlayoe. Tsan josanan ya tsachilari pica manjato quiranari, Jesús itominue. Nin chiquilanan nin Jesunan junte itominlayoe. Junni ya tsachilari Jesuca nunchi jica jonhoncanque tenca calaquinasa, canoa manca manca junse polenanue Tiberia tinun pueblobi nechi. Junni tsachilari Jesús junte itonunca tenhito, jun canoabi wito, yalanan Capernaum puebloca jalainue Jesuca manneyato. ");
INSERT INTO cofNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Junni ya tsachilari pi pola jato, Jesuca manneyato féto, yaca Miya tito, ¿Numasi jayun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuri yalabe beconan pato itsantie: —Nulabe tsarasica pachinayoe tie. La wepanato quirantsancari seque quinaminca quiranun tenchi laca manneyalaquitue. Nulachi duque ano cufiyoe. Junca manfichiqueri laca manneyalaquinae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Junni jun finoca cachiqueri tenfelaituna! Finori jerainiichunae tie. Lari tsachi ica jun joto, uyanca nulachi cuwano munarayoe tie. Apa Diosinan nulaca mantato laca meralaquina! tica joe tie. Lari uyan finun cuwentaca cuwano joyoe. Jun finun cuwentaca caminlachi tenca numatotiya sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Junni tsachilari Jesús tsanticaca meráto, itsantilatie: —¿Ti quino jolajoin? latie yape Diosi chiquilaca sen jolajoe tisa. ");
INSERT INTO cofNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Junni Jesuri itsantie: —Diosi nulaca itsanque mantaca joe tie: Diosi ereca jun tsachibe cayailaisa mantaca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Junni ya tsachilari itsanlatie: —Nube cayaisa tenjanari, manan wepanato quirantsancari seque quede! nuca Diosi ereca joeque quereilaichun. ¿Chiquilachi tenchi nu ti senca quito cuwachun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chiquilachi matu tatala niyanlanantiya chutunun tose polenato, maná tinun finoca filaquinue. Diosichi Pilabi chuteca joe jamochi nechi yalachi finoca cuwanaminueque. Moisés jun finoca cuwanaminue tilatie. ¿Junni nuri ti senca quito cuwachun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Junni Jesús yala pánanunca meráto itsantie: —Nulabe tsarasica pachinayoe tie: Moisés maná tinunca cuwatonan, yari Diosichibi nechi jonunca cuwamin itominue. Lachi Apa Diosiri jamochi nechi tsara sen finunca cuwano joe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jana jamochi nechi patato, jeralelaca sonnasa carimin, aman yari Diosi cuwaca finun cuwenta joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Junni ya tsachilari Jesús pánanunca natiya tuituto, tsa finoca pánaeque tenca cato, jun finoca chiquilachi piyanle ma cura cuwana! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuri itsantie: —La pato, sonnasa carimin fino tito, tsa finunca pátiyoe; tencachiqueca tsantinamanyoe. Lachica jaminlachiri ano manmuquilaquituchunae tie. Labe cayaiminlachiri pi manmuquilaquituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nula mantimini laca quiranatonan, cayaituchi timinla joe. Junca numa pacayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Junnasa Apa Diosiri weyan tsachilacari labe cayaisa carichunae tie. Yala jeralela labe cayailaichunae tie. Junni labe cayaiminlaca numanan telaquepotuanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","La Diosichibi nechi patato, lachi tenca munate nenabi patatiyoe tie. Laca ereminbe mantaito nenabi patacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Junni laca ereminni laca itsanque mantaquee: Jerale labe cayaisa carinunlaca cuidaino joyoe tie mancacatiya casticaisa carituto. Junto to jeraino mate yala cayaica junlaca mansoncarino joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Lachi Apari itsanque munarae: Yachi Naoca tennato yabe cayaiminlari jeralela numatotiya sonnato polenola joe. Junto to jeraino mate yalaca mansoncarino joyoe tie. Lachi Apa Diosi tsanque mansoncarisa munarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Junni Jesús tsantica josa, israelítala paito cuenta quilaquee Diosichibi nechi pataca jun finun cuwenta joyoe tinun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","¿Inni Jesuri jotun? latie. ¿Yachi apa Joseri tinun jotun? latie. Yachi apabe ayanbeca quiraminlayoe. ¿Aman niyaito Diosichibi nechi patacayoe tin tinan? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Paito tsanlatinasanan, Jesuri yalabe itsantie: —Paito cuenta quitulajode! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Apa Diosiri laca erecae tie. Diosi labe cayaino munarasa carinunlasiri labe cayaino podeilaichunae tie. Uyanla podeilaituchunae tie. Cayaica junlacari to jeraino mate la mansoncariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diosichi Pilabi itsanque chuteca joe: Jeralela Diosibe miilaichunaeque chuteca joe tie. Junni jeralela Diosica meráto yabe miiminlari labe cayailaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aman Diosica quiracachiri monantiya Apa Diosica quiratuminla joe. Diosichibi nechi pataca jun tsachisiri Apa Diosica quiraca joe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nulabe tsarasica pachinayoe tie. Labe cayaiminlachi tencari numatotiya sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lari ya sonnasa carimin finun joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Junni aman ya maná tinun finoca mantenca calaquede! tie. Chiquilachi matu to tatalari niyanlanantiya chutunun tose polenato, maná tinunca filaquinatonan, puyanilainue. ");
INSERT INTO cofNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lari uyan quiraque finun jonunca pánayoe tie. Diosichibi nechi patamin finunca fiminlari puyalaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Lari Diosichibi nechi patato, la sonnasa carimin finun joyoe tie. Jun finunca fiminlari numatotiya sonnato polelaichunae tie. Junni yape jeralela sonnano podeilaisa, jun anoca cufino joyoe tie. Junto fino tito lachi pucacanan tsantinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Junni Jesús tsantinunsile, israelítala tala tenpato itsanlatie: —¿In tsachi niyaito yachi pucaca chiquilachi cufichunan? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Junni Jesuri yalabe itsantie: —Nulabe tsarasica pachinayoe: La tsachi ica jun jonan lachi pucaca fin, lachi asanca cuchin, quitutori, nulachi tenca sonnalaratuchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lachi pucaca fin, lachi asanca cuchin, quitori, junto nulachi tenca numatotiya sonnato polelaichunae tie. To jeraino mate nulaca mansonhisa cariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Lachi pucari tsara sen finun jochunae tie. Lachi asanni tsara sen cuchinun jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Junni lachi pucaca fin, lachi asanca cuchin, quiminlari labe sonnalarachunae. Lanan yalachibi sonnanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Laca ereminni, ya Diosi joe. Ya Apa Diosi sonnanun tenchi lanan pesonnayoe tie. Jun tsanquenan lari sonnanun tenchi laca fiminlanan pesonnalarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Diosichibi nechi pataca finunca pánayoe tie. Chiquilachi matu to tatalari maná tinunca ficala jotonan, jera puyanilainue. La paca finun uyan quiraque finun joe. La panunca fiminlari numatotiya sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús Capernaum pueblobi tsanque micarinaminue Diosichi fiqui miinun yabi. ");
INSERT INTO cofNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Junni Jesús tsanque micarinasa, duque yabe penenaminlari jun fiquica meráto, yala tala nosa cuenta quito itsanlatinue: —Jun fiquica meráno duque tenfe jochunae latinue. Niyanlanantiya yaca meráno podeilaituchunae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús mantimini yachi tencabi miinue weyan yabe penenaminlari yachi fiquica paito tsantilatinunca. Junto junca miito yalabe itsantie: —Nulari jun fiquicari paituntsan joe. ");
INSERT INTO cofNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","La tsachi ica jun joto, jamochi manlono joanae tie. Junni lachi fiquicari paiminla jotori, junto la jamochi manlonaminca quiralaquinamanpari, ¿niyan tinola joyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Junni lachi fiquicari seque tenca calaquede! Lachi pucaca fide! tito, lachi tsa pucaca tsantitiyoe tie. Lachi pucaca filaquinari, epe jochunae tencaca sonnasa carino. Nulachi tencabi lachi fiquica quereinola joe sonnachun. Lachi fiquibe sonnano podeilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Junni Jesuri miraminue weyanla yabe tsa cayaica itolajonunca. Yala mo jonunca miraminue. Junsi mo yaca cuwapono jonuncanan miraminue. Junca jera mirato, Jesús itsantinue: —Nula weyanlari labe penenatonan, labe cayaitucala joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Junto la matulenan junca panunca mantenhilaide! tie. ¿Apa Diosi labe cayaisa carinunlasiri labe cayaino podeilaichunae tituan? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Junni Jesús tsantinunsi, duque yabe penenaminlari yaca mantelaquepolaquee. ");
INSERT INTO cofNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Junni Jesús chiquila chunca palucabenan panhae ¿Chiquilanan yaca telaquepolaquichun? tito. ");
INSERT INTO cofNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Junni Simón Pédrori itsantie: —Miya, nuca telaquepotori, ¿mochica jicaichunan? Nuchi fiquibesiri numatotiya sonnato poleno podeilaiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nuca quereito, miicalayoe tie nuri Cristo tinun joeque, sonnamin Diosichi Nao joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Junni Jesunan itsantie: —Nula chunca palucaca wenteca josanan, nula manca yucanchi joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscarióteca tsantica jominhe. Yari chiquila chunca palucabe manca pejotonan, nanni inale Jesuca cuwapono jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Junni Jesús tsachilaca tsanque micarinunbi, israelita mantaminla yaca totechi latinaminue. Jun tenchi Jesús Judea tobi nenatuto, Galilea tobiri nenaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tsantin nenasanan, israelítalachi jelen ya quinun fiesta queloinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Junni Jesuchi acolari yabe itsanlatie: —¿Niyaito intenan cachuyun? tilatie. Judéaca jiniide! latie. Junbi wepanato quirantsancari quiniquina! latie yape nube penenaminla quiralaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yaca miralarasa munaraminlari nosa nenalaratuchunae. Jeralelachi cale nenalarachunae. Junto nunan seque quimin jotori, jeralelachi cale tsanquiniquina! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aman Jesuchi acolanan yabe cayaituca jominlanue. Junto tsanlatie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Junni Jesuri yachi acolabe itsantie: —Lari fiesta quirabi jino óra caitoe tie. Nulachi niyan óra jino muquinari, jinilaintsan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Diosica tennatuminla talari nulaca pa jono podeilaituchunae. Laca pa jolajoe tie. Lachi fiquica meráto, jutsa quiminla joyoeque tenhiminla joe. Jun tenchi laca pa jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nulari fiesta quirabi jilaide! tie. Lari cajitiyoe. La jino óra cafetue tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesús tsantito, Galilea tobi puraie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Junni aman Jesuchi acola numa fiesta quirabi jilainunbi, Jesunan jie. Nosa jie layanlabe jituto. ");
INSERT INTO cofNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Junnasari fiestabi israelítalari yaca neyanaminlanue. ¿Tile niya ranancan? tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Yaca nosa duque cuenta quinaminlanue. Weyanlari yaca sen joe tinaminlanue. Weyanlari te, seitoe; tsachilaca encanamin joe tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Israelita mantaminlaca jelechi yaca nosa cuenta quinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Junni ya fiesta quitsa quinasale, Jesuri jato, Diosichi yabi wito micarie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Junni israelítalari yaca meráto wepanalaie. ¿Ja moso israelita mantaminlabe miica itotonan, niyaito tsaracari duque miran? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Junni Jesús yalabe itsantie: —La tencachique mantate micaritiyoe; laca ereminchi mantateri micarinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Diosichi fiquica meráchi timinlari miralarachunae la Diosichi mantate micarinanunca o tencachique mantate micarinanunca. ");
INSERT INTO cofNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tencachique mantate paminlari fe jochi timinla jochunae tie. La mantimini fe jochi titiyoe. Diosi ereca jun jaca joto, yacari fe mantá tan joe tintsan joe tiyoe tie. Junbe miintsan joe la tsarasica pamin joeque. Natiya nene pátiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moiseca mantenhilaide! Yari nulachi tenchi Diosichi mantaca polarinue. Tsan josanan, nula mancatiya jun mantaca merátuminlae tie. Junni ¿ti quichun laca totechi latinayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Junni Jesús tsantinan, tsachilari beconan pato, nuchibi yucanchi oco wica jonhoe latie. Monantiya nuca totechi titue latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Junni Jesuri itsantie: —Quiyanpun mancaca jasaino mate manse suwanaminca quirato, paito wepanalainae. ");
INSERT INTO cofNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tenca calaquede! tie. Matu to Moiseri nulaca micarinue nalalachi quidoca poreno joeque. (Junni aman junca Moisés camicaritusanan, Moisechi tatalanan jun tsanquimin jominlanue tie.) Junni nulari Moiseca meráminla joto, tsanque poreminlae israelita na joeque. Junni quidoca poreno ma jasaino mate patinari, jun matenan poreniquiminlae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Junni aman tenca calaquede! Jasaino matenan nalalachi quidoca poreniquiminlae Moisechi mantaca meráminla jochun. Tsanquiminla jotonan, la jasaino mate quiyanpunca jera manse suwanun tenchi paiminlae tie. Nulari epele tenca cato nenalarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jamoleri tenca casi culpa quiniquiminla joe. Tsanquitulajona! Sele tenca cato, tuca miilaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Junni aman Jesús pánanunca meránaminlari weyanla Jerusalenbi chumin jominlanue. Junni Jesús tsanque cuenta quinasa, yalari pato, inni totechi tinun tsachi jonhoda latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Junnan quiralaquede! tilatie. Jeralelachi cate micariniquinasanan, mantaminlari natiya palaquitue. ¿Yaca Diosi wenteca Cristo tinun tsachi joeque miicala jonhoncan? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Junni weyanlari pato, te latie. Cristo tinun iton jonhoe latie. Cristo janari, monantiya miitolajochunae nunchi nechi jaca jonunca. Inca wari nunchi nechi jaca jonunca miralarayoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Junni Jesús yalaca meráto, sonba pato itsantie: —¿Laca mirayoe tilatinayun? tie. ¿La nunchi nechi jaca jonunca mirayoe tilatinayun? tie. Juntonan lari tencachique mantate jatiyoe. Junsi laca ereminni tsarasica pamin joe. Nulari yaca miitolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","La mantimini ya ereca jun jato, yachibi nechi jacayoe tie. Junto yaca mirayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Junni Jesús tsantinun tenchi, yaca cato dochi tinaminlanue. Tsanlatinatonan calaquitunue. Jesús doino óra caitominue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Junni junnasanan duque israelítalari Jesuca contra josanan, weyan duque israelítalari Jesube cayainaminlae. Junni cayaiminlari itsanlatie: —Cristo tinun tsachiri seque wepanato quirantsancari quimin jochunae latie yape tsachila ya joeque miilaisa. Jesuri tsanquimin joto, ya Cristo jonhoda latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Junni fariséola tala mantaminlari meralaquinue duque israelítalari Jesuca Cristo joe latinaminca. Junto yalabe mantá tan patelelabe polisialaca erelaquinue yape Jesuca cato dolaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Junni Jesús israelítalabe itsantie: —Nulachite nasiri canenachinayoe tie. Junto laca ereminchica manjichinayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Laca neyanatonan, felaituchunae tie. La jinun postoca nula jano podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesús tsantinunsi, israelítala yala tala itsanlatie: —¿Nunchi jichunan? yape chiquila yaca feno podeilaitusa. ¿Uyan tobi chumin israelítalachica jito, israelita itonlacanan micaribi jichun tsantin tinancan? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yaca neyato felaituchunae tito ¿niyanhichunni tsantin tinancan? O ya jinun posto chiquilari feno podeilaituchunae tito, ¿niyanhichunni tsantin tinancan? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Junni ya fiestate, fiesta jeraino mate Diosica fécari tenca canun ma jominue. Junni jun mate Jesuri wiruito, sonba pato, itsantie: —Pi munaraminla lachica jato cuchilaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Diosichi Pilabi labe cayaiminlaca itsantica joe tie: Tencabi pi foro tsan jochunaeque chuteca joe tie. Junbi nechi piri loniinachunaeque chuteca joe tie tencaca sonnasa carimin pi. ");
INSERT INTO cofNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Aman Jesuri sonnasa carimin pi tito, Diosichi Tencaca tsantinaminhe. Yabe cayaiminlachi tencabi Diosichi Tenca wino jominue. Tsan josanan Jesús tsaracari mantá cacatuminnan, Diosichi Tencaca caereca itominue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Junni aman Jesuri sonnasa carimin pica cuenta quinaminca meráto, weyan israelítalari itsanlatie: —Yari Diosichi mantate pabi jano jomin tsachi jonhoda latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Weyanlari ya Cristo joe latie. Weyanla mantimini te latie. Ya Cristo itoe latie. Crístori Galilea tsachi itochunae latie. ");
INSERT INTO cofNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diosichi Pilabi tuca chuteca joe latie Cristo matu to Davichi alica joto, yachi pueblobi naino joe latie ya Belén tinun pueblobi. ");
INSERT INTO cofNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Junni tsantinato, israelítala Jesuca man tencari catulajoe. ");
INSERT INTO cofNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Junni weyanlari yaca cato dochi latinatonan, monantiya yaca catulajoe. ");
INSERT INTO cofNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsan joto Jesuca cano jomin polisialanan Jesuca catuminnan israelita mantaminlachica manjilainue. Junni fariséolabe mantá tan patelelabe ¿Niyaito yaca cato tanjalaitiyun? latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Junni polisialanan beconan manpato itsanlatinue: —Tsaracari seque pamin joe latinue. Monantiya ya tsansi seque pamin itominue latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aman jun fiquica meráto, fariséolari polisialaca paito itsanlatinue: —Nulacanan wari encanaca jonhoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ti mantaminlabe ti fariséolabe fe miraminla joto, yabe natiya cayailaitiyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Epe tsachilasiri yabe cayailainae. Diosichi mantaca miitoto, yucanhicala joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yala tsanlatinasanan, Nicodémori panue. Ya Nicodemo Jesuca quepen quirabi jica jominue. Junni yanan pemantamin joto, yalabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Chiquila Diosichi mantaca jera miralarayoco? tinue. Junni jun mantabi chuteca joe tinue tsachilaca camiituminnan culpa quituntsan joeque. Casale culpa quinun tsachica meráto, yaca miito quirato, junto aman culpa quino jonari, culpa quintsan joe tinue. Junto Jesuca camerátuminnan, yaca culpa quituntsan joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Junni Nicodemo tsantinan, uyan mantaminlari yaca merátuchi tito itsanlatinue: —¿Nunan tsan quiran Galilea to tsachiyun? latinue. Diosichi Pilabi quirade! Galiléabi nechi Diosichi mantate pamin tsachi natiya jano itochunaeque chuteca joe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Junni jeralela manjilainasa, ");
INSERT INTO cofNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesuri Olibo du minu jie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Junsi ayuna nanchi quepenan Diosichi yaca manjito, junbi chudito manmicarie. Layanla yaca merábi jaca jolajominue. ");
INSERT INTO cofNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Junni micarinasanan, israelítala tala mantaminla jalaie. Yala tala mantaca micariminlabe fariséolabe jominlanue. Junni aman yalari sona mancaca caya suwaca jominlanue uyanchi unilabe catsonaminca. Junni israelita mantaminlari jun sonaca tanjato, quitsabi wirucarito, ");
INSERT INTO cofNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesube itsanlatie: —Nuri micarimin joto, chiquilabe pade! tilatie. In sonaca caya suwalaquinue uyanchi unilabe catsonaminca. ");
INSERT INTO cofNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aman Moisés Diosichi mantaca Diosichi Pilabi chuteto, chiquilaca mantanue latie. Tsanhiminlaca su walacachi quito totelaquisa mantanue latie. ¿Nuri niyan tiyun? tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Junni yalari Jesuca falta patarichiqueri tsanlatinaminhe. Jesús mantimini dedeisi, tobi temisuchi pila quee. ");
INSERT INTO cofNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Junni yalari capanhalaquinasanan, Jesuri manwiruito itsantie: —Nula manca jutsaca numanan quitumin jotori, casale su walacachi quede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsantisi, manan dedeisi tobi temisuchi pila manquee. ");
INSERT INTO cofNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Junni sonaca tanjaminlari Jesús pacaca meráto, yalanan jutsa quiminla joyoeque tenhito jera manjinilaie. Unicala casale manjilaie; jun benele mosolanan jera manjilaie. Junni jera manjicala josa, Jesuri mancasiri puraica jominhe. Ya sonanan quitsale cawiruraminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Junni Jesús manwiruito quiranari, sonari wiruraminhe. Junni ya sonabe itsantie: —¿Manjicala joco? ¿Monantiya nuca su walacachi quitulajoco? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Junni ya sonari Miya, monantiya quitue tie. Junni Jesuri lanan quitiyoe tie. Manjiniide! Juntonan jutsa manquituna! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Junni aman Jesuri israelítalaca manan manmicarito itsantie: —La jeralelachi tenca tenchi tseno joyoe tie. Labe penenaminlari nemenbi cuwenta chularatuchunae; sonnasa carimin tsenbi chularachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Junni Jesús tsantinunsi, fariséolari itsanlatie: —Nu tencachique fe joyoe tinae. Tencachique pánanun fiquiri quereituntsan joe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Junni Jesuri beconan itsantie: —Lari nunchi nechi jaca jonunca mirayoe. Nunchi manjino jonuncanan mirayoe tie. Jun tenchi tencachique fe joyoe tinatonan, quereintsan fiquica pánayoe tie. Nulari natiya miitolajoe la nunchi nechi jaca jonunca, o nunchi manjino jonuncanan. ");
INSERT INTO cofNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nulari tsachilaca culpa quinato, cacachi quirato jamoleri miito culpa quiminlae. Lari mocanantiya culpa quitumin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tsanni culpa quitutonan, tsachilaca miimin joyoe culpa talaranunca. Junto la tsachilaca culpa tanunca miitonan, tenca mántari miitiyoe tie. Lachi Apari laca erecae. Junni lachi Apabe labe paluito miiminlayoe. Junto lari tsachilaca miito, tsarasica miimin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","¿Nulachi mantabi juncanan pila chuteca jotun? tie. ¿Paluca testicola palaquinari, tsa joe tintsan joeque chuteca jotun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","La tencachiqueca pánayoe. Junsi lachi Apa laca eremin joto, yanan laca pánae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Junni fariséolari Jesube manpanhato itsanlatie: —¿Nuchi apa tile chun? latie. Jesunan itsantie: —Lacanan, lachi Apacanan nula miitolajoe. Laca miralaramanpari, lachi Apacanan miica jono jominla jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús Diosichi yabi jun fiquica micarie cala canun postote. Jesús micarinasanan, yaca cano óra cafetunan, monantiya yaca cadolaquitunue. ");
INSERT INTO cofNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Junni aman Jesuri ya israelítalabe manan cuenta quito itsantie: —La manjino joyoe tie. Junni nulari laca neyato, fetuto, jutsaca tannan puyalaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Junni Jesús tsantinunsi, yala tala itsanlatinue: —¿Niyaito Jesús jino jonunca chiquilanan jino podeilaituchunae tin tinan? latie. ¿O tenca mántanan puyachunancan? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Junni Jesuri yalabe itsantie: —La jamochi nechi joyoe; nula in tote nechi jolajoe. Nula in tote chumin tsachila jolajoe; lari in tote nechi tsachi itoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","¿Jutsaca tannan puyalaichunae tituan? tie. Wari laca jamochi nechi joeque quereitutori, jutsaca tannan puyalaichunae tiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Junni Jesús tsanticaca meralaquito, ya israelítalari panhato, ¿Ti joyoe tito tsantinayun? latie. Jesunan itsantie: —Wari numari mánta nulabe junca pánamanyoe tie ti tsachi jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Junni lari nulacanan duque pano podeino joinhie tie nula niyan tsachila jolajonunca. Tsan jotonan yaca pátiyoe; laca ereminchi fiquicari pamin joyoe. Yachi fiquica meráto, jun fiquicari tsachilabe manpolarimin joyoe tie. Yari tsarasica pamin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Junni Jesús yaca eremin tinato, Apa Diosica tsantinaminhe. Jesuca meráminla mantimini yaca tuilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Junni Jesús yalabe manan pato itsantie: —La tsachi ica jun joto erunhito puyano joyoe tie. Laca jamobi eruncaritobi, la ti tsachi jonunca miilaichunae tie. Junni lachi tencachique mantateri tinantiya quitumin joeque, lachi Apa pacacasiri la manpamin joeque, miilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Junni laca eremin labenan pejoe. Lari lachi Apa munaranuncasiri quinanan, laca natiya puratuminhe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Junni Jesús jun cuenta quinasale, duque tsachila yabe cayailaie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Junni Jesús yaca tennamin israelítalabe itsantie: —Nula peleituto lachi fiquica meráto nenatori, lachi tsachila patsa jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Junto tsarasi fiquica miilaichunae. Amana uyanlari nulaca fe loto mantaminla joe; peyunla cuwenta suwacala joe. Junni tsarasi fiquica jera miitobi, uyanlachi peyun cuwenta natiya itolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Junni israelítala mantimini Jesuchi fiquica meráto, yaca paito itsanlatie: —Chiquilari matu to Abrahanchi alicala joto, mobenantiya numanan mantailaitiyoe latie. Junni chiquilaca pato uyanlabe mantailaituchunae tituntsan joe tilatie. Mantaitumin jolajoyoe tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Junni Jesunan manpato itsantie: —Nulabe tsarasica pachinayoe tie. Jerale jutsa quiminla jutsachi peyunla cuwenta jolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Junsi peyunlaca man fiquinan pachinayoe. Meralaquede! Peyunlari patronchi familia itoto, nasiri chuto uyanchi manjiniiminlae. Patronchi naola mantimini numatotiya pejoto polelaichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Junni lari Diosichi Nao joto, nulaca se larino podeiyoe yape jutsachi peyunla itolajosa. La nulaca se larinari, natiya peyun cuwenta manhitolajochunae. ");
INSERT INTO cofNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nulari matu to Abrahanchi alicala jolajoeque mirayoe. Tsanla jotonan, laca totechi latinae. Lachi fiquica merátuchi tito, totechi latinae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lachi Apa micarinan pánayoe. Nulari nulachi apabenan miito quilaquinae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Junni yalari Jesuchi fiquica tsanque meráto, Chiquilachi apala sen israelítala jolajoe latie. Matu to Abrahanchi alicala jolajoyoe tilatie. Junni Jesunan itsantie: —Nula Abrahanchi alicala jotonan, ya cuwenta nenatuminlae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","La Diosichi fiquica nulabe tsarasi pánaminca totechi tilatinae tie. Abrahanni tsanque nenatuminhe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Te, uyan nulachi apa joe. Nula ya cuwenta quilaquinae. Junni yalari manpato, chiquilari leyan sonachi na itolajoyoe latie. Mancacari chiquilachi apae timinlayoe latie. Diosicasiri Apa timinlayoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús mantimini itsantie: —Lari Diosichi joto, Diosichibi nechi jacayoe. Tenca mánta jatiyoe; Diosi ereca jun jacayoe tie. Junni nulanan Diosichi tsachila jomanpari, laca laquirano jominla jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Niyaito la pacaca entendeilaitiyun? Aman lachi fiquica munaratulajoto, laca entendeilaitue. ");
INSERT INTO cofNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yucan nulachi apa joe. Nula yachi tsachila joto, yachi mantate nenachi timinla joe tie. Casalebi nechi yucan tsachilaca totemin joe. Tsarasica patumin joto, nenesiri pamin joto, tsarasica panunca pa joe. Nene pamin jotonan, nenenan pasa carimin joe tie. Ya nene pánato, yachi mite nenanirae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","La mantimini nulabe tsarasica pamin joyoe. Jun tenchi lachi fiquica quereituchi timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nula monantiya laca culpa suwano podeilaituchunae tie. ¿Junni la tsarasi fiquica pánaminca niyaito quereilaitiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jerale Diosichi tsachila Diosichi fiquica meralaquichunae tie. Nulari Diosichi itoto, yachi fiquica merátuminla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Junni Jesús tsantinaminca meráto, israelítala yabe itsanlatie: —Yucanchi oco nuchibi wica joto, ti quiran Samaria to tsachila cuwenta seiton suwaca joe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús mantimini yaca meráto itsantie: —Lachibi yucanchi oco witucae tie. Lachi Apa Diosica meráto nenayoe. Nula mantimini laca merátuchi timinla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tsanla josanan, la fe jochique tenfetiyoe. Apa Diosi, yari tenfenae laca fe josa carichun. Yari tsachilaca miito quiramin joe senla jonunca o seitonla jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Junni nulabe tsarasica pachinayoe tie: Lachi fiquica meráminlari numatotiya puyatuto polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jesús jun cuenta quinasa, israelítalari yabe itsanlatie: —Jun fiquibe miilainayoe nuchibi yucanchi oco wica joeque. Matu to Abraham numari puyaca joe. Matu to Diosichi mantate paminlanan numari puyacala joe. Junni yalari nuchi fiquica meráto nenaminla jotori, ¿niyaito puyalainhin? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Matu to tata Abrahanca fe joyoe tinayun? Yari puyanue. Diosichi mantate paminlanan Diosichi tsachila jotonan puyalainue. ¿Ti joyoe tinayun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Junni Jesuri beconan pato itsantie: —Lari tenca mánta fe joyoe titori, epele pamin jono jomin joinhie tie. Junni lari fe joyoe titiyoe. Lachi Apari laca fe joe timin joe. Junni nula lachi Apaca nulachi Diosi joe timinla joe. Junni Diosi patsa laca pato, fe mantá tan joe timin joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nula mantimini lachi Apaca chiquilachi Diosi joe tinatonan, yaca natiya miitolajoe tie. Lari yaca mirayoe. Lari yaca miitoyoe timanpari, nene pun jono jomin joinhie nula cuwenta. Juntonan nene patumin joyoe. Yaca mirato, yachi fiquicanan merámin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nulachi matu to tata Abrahannan laca jano joeque miito son tie tie. Laca miito duque son tica jominhe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Junni Jesús tsantinan, israelítalari itsanlatie: —Nuri mante chunca wata caitoto, ¿Abrahanca quiraca jochiton? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Junni Jesunan itsantie: —Nulabe tsarasica pachinayoe: Abraham caitosanan, lari numa joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Junni Jesús tsantinunsi, israelítala su calaquee su walacachi quito totechun. Jesús mantimini tsaito, Diosichi yabi nechi manloe. Junsi yalachise poleto jiniie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chiquila nenaminnan, quirano podeiton tsachica quiralaquiyoe. Nainun mánta quirano podeiton jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Junni Jesube penenaminla Jesube itsanque panhalaquiyoe: —Miya, chiquilaca micaride! ¿Ya tsachi mochi jutsa tenchi quirano podeiton nainun? latiyoe. ¿Yachi jutsa tenchi jun, o yachi apachi, ayanchi jutsa tenchi jun? latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Junni Jesuri chiquilabe itsantie: —Yachi jutsa tenchi itoe. Yachi apachi o ayanchi jutsa tenchinan itoe tie. Ya tsachi tsanque nainue yape tsachila quiralaquisa Diosi wepanato quirantsancari seque quimin joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Junni meralaquede! Laca ereminchi mantate ticatiya quinola joyoe jola cajosanan. Lari in tote nenasanan, malon cuwenta jochunae tie. Ticatiya quino jola cajonun cuwenta jochunae tie. Inale mantimini la manjinunbi, quepen cuwenta jochunae. Jun órate monantiya ticatiya quino podeituntsan jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús tsantisi, tobi pipi patarito, pipa nacá quito, quirano podeitonchi cacabi ilipoe. ");
INSERT INTO cofNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Junca iliposi, junto jide! tie. Siloé tinun pipilubi cacaca tsalede! tie. (Aman chiquilachi fiquichi ereca jun pica “siloé” tinun joe.) Junni ya quirano podeiton tsachi Jesús ereca jun jito, jun pipilubi tsalenue. Junto quirano poden manjae. ");
INSERT INTO cofNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aman ya tsachi quirano podeiton jominnan lemosi cala panhato chumin jominue. Junni ya tsachica lemosi cala panhato chuminca quiramin jominlari yaca manquirato wepanalainue. Yachi quelole chuminlanan yaca manquirato wepanalainue quirano podeinueque. Junni itsanlatie: —¿Inni lemosi cala panhato chumin tsachi jomin jotun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Weyanlari yare latie. Weyanlari yanan quiran jotonan, ya patsa itoe latie. Ya mantimini la jomanyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Junni uyanlari yabe panhato, ¿Ya jotori, niyaito manquirano podeiyun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Junni ya tsachi itsantie: —Jesús tinun tsachi pipa nacá quito, lachi cacaca ilipoto, Siloé pipilubi tsalesa tie tie. Junto lari junchi jito, tsaleto, manquirano podeiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Junni yalari ¿ya Jesús tile nenan? latie. Junni manseica jun tsachiri miitoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Junni quirano podeiton jomin manseica tsachica fariséolachica tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aman Jesús yaca pipa ilipoto manse suwanun mari jasaino ma jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Junni fariséolanan yabe panhalaquinue niyaito quirano podeinunca. Junni lachi cacabi pipa ilipoe tinue. Junnan cacaca tsaleto, manquirano podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Junni weyan fariséolari itsanlatinue: —Nuca manse suwamin tsachi Diosichi tsachi itoe latie. Diosichi tsachi jomanpari, jasaino mate manse suwano itomin jonhoe latinue. Uyanla mantimini itsanlatinue: —Jutsa quimin tsachi jotori, ¿niyaito tsanque wepanato quirantsancari quino podeichunan? latinue. Tsanque fariséola man tencari itominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Junto quirano podeiton jominbe manan cuenta quito, ¿Nuri niyan tiyun? latinue. ¿Nuca quirano podeisa cariminca niyan tiyun? latinue. Junni yari Diosichi mantate pamin joe tiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Junni israelita mantaminlari junca nene jonhoe latinue. In tsachiri quirano podeiton itomin jonhoe latinue. Junto yachi apabe, ayanbeca jasa carito, yalabe ");
INSERT INTO cofNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","itsanque panhalaquinue: —¿Inni nulachi nao jun? latinue. ¿Ya nainun mánta quirano podeiton jominhe latiyun? latinue. ¿Tsan jonari, niyaito manquirano podeinan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Junni yachi apari, ayanni beconan pato itsanlatinue: —Chiquilachi nao joda. Nainun mánta quirano podeiton jominhe. Tsanqueri miralarayoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Niyaito manquirano podeinunca natiya miitolajoyoe latinue. Mo yaca manquirano podeisa carinuncanan miitolajoyoe. Yabe panhalaquede! Ya uwan joe. Ya tenca mánta pachunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yachi apari, ayanni, jelechi tsanlatinue. Israelita mantaminla wari paca jominlanue Jesuca Diosi wenteca Cristo tinun tsachi joe latitusa. Tsantiminlaca casticaquintsan jochunae tilatinue. Tsantiminla weyan israelítalabe Diosichi fiqui miinun yabi pelayaino podeituntsan jochunae latica jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Junni jun casticoca jelechi, yachi apabe ayanbe ya uwan joe; yabe panhalaquede! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Junni fariséolari manquirano podeica junca manan jasa carilaquinue. Manjasa carito, itsanlatinue: —Diosichi cale seque pade! Chiquilari ya Jesuca miralarayoe latinue jutsa quimin tsachi joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Junni manquirano podeica jun tsachinan itsantinue: —Seiton jonunca o sen jonunca miitoyoe. Man fiquiri mirayoe: Casale quirano podeiton jominnan, amana quirano podeiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Junni fariséolari itsanlatinue: —¿Nuca ti quin? latinue. ¿Niyan quito nuca manquirano podeisa carin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Junni yari beconan itsantinue: —Numa pacayoe wari. Nulari meralaquitue tinue. ¿Ti quichun manan manpanhalaquinayun? tinue. ¿Nulanan yabe penenamin ino muquilaquin? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsantinunsi yaca duque paito itsanlatinue: —Nuri jun tsan quiranbe penenamin joe. Chiquilari matu to Moisebe penenaminla joyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Diosi matu to Moisebe paca junca miralarayoe tilatinue. Jun tsachicari natiya miitolajoyoe latinue tichi mantate jaca jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Junni manquirano podeica jun tsachiri itsantinue: —¿Nula pánanunca wepanantsan fiqui jotun? tinue. Tichi mantate jaca jonuncari miratusanan, laca manse suwae tinue yape manquirano podeisa. ");
INSERT INTO cofNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","¿Diosi jutsa quiminlaca merátumin joco? Diosica jelerato respetaito, yaca meralaquinari, yalacari Diosi merámin joe. ");
INSERT INTO cofNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Junni la quirano podeiton naica jonunca yari manse suwae. Casale to quicale nechi monantiya tsanquitumin jominlanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jun tsachi Diosichi mantate jaca itomanpari, natiya tsanquino podeino itomin jonhoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aman israelita mantaminlari jun fiquica merasi, yacanan paito itsanlatinue: —Nunan jutsabe naica joto, ¿chiquilaca micarino podeichiton? latinue. Tsantisi yaca suerelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Junni Jesús meraé quirano podeica junca suerelaquinueque. Junto yaca manneyato féto, yabe panhato, ¿Tsachi ica junbe cayaicayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yari ¿moca tsachi ica jun tiyun? tie. Yaca quiratori, cayaino joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Junni Jesuri yabe manpato, tsachi ica junca quiranae tie. La tsachi ica jun joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Junni quirano podeica jun tsachiri Jesuchi fiquica meráto, Miya, nube cayaiyoe tito, yachi cale telenhie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Junni Jesús itsantie: —Tsachilaca miito quirabi, in toca patacayoe tie niyaque tenca jolajonunca miichun. Junni weyanlari Diosichi minuca seque jichi tinatonan tuitutori, quirano podeitonla cuwenta jolajoe. Tsanlachi minu micuwabi patacayoe tie yape sele quiralaquisa. Weyanla mantimini Diosichi minuca quirano mirayoe titonan jun minuca jituchi timinla joe. Yalacari quirano podeiton cuwenta suwabi patacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Junni weyan fariséolari junte perato, Jesuca meráto, ¿Chiquilacanan quirano podeitonla cuwenta jolajoe tinayun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús yalabe itsantie: —Nula quirano podeitonla cuwenta Diosichi minuca quirachique tenfelainamanpari, culpa itono jominla jonhoe. Tsan josanan, nulari Diosichi minuca seque quirano miralarayoe timinla joto, culpa tanla joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Junni Jesús itsanque micarie: —Nulabe tsarasica pachinayoe tie. Opisa tanlaca tenhilaide! tie. Tsachi manca opisa cotonlabi wichunae tie. Tamolanse wituto, uyanse witori, tarinmin jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tamolanse witori, opisa tsacumin jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yachi tenchi tamolan cuidaimin tsachi lasichunae. Junni opisa yaca meralaquichunae tie. Yachi opisalaca mumun pato oticato, lapa fisa tanlochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yachi opisalaca jera tanloto, yanan caqueito jichunae tie. Opisala yachi fiquica mirato, yabe bene janilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Opisalari uyanlachi fiquica miratuto, yalabe bene jilaituchunae tie. Sujilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús yalaca tsanque cuenta polarito micarie Diosichi tsachila opisala cuwenta jolajoeque. Tsan josanan, yaca meráminla natiya tuitulajoe tíca tsantinanunca. ");
INSERT INTO cofNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Junto Jesús manan micarito itsantie: —Nulabe tsarasica pachinayoe tie: La micarinato, tamolan tito, tencachiqueca tsantinamanyoe. Lachi tsachila lachi opisala cuwenta jolajoe. Junni la tamolan cuwenta joyoe tie yalachibi wichun. ");
INSERT INTO cofNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Uyanla laca caquenan jato, opisa cuwenta jun tsachilaca cuidaibi jalaiyoe timinlae tie. Tsantiminla jotonan, seitonla joe. Jeralela tarinminla cuwenta joto, opisa tsanlaca seque cuidaituminla joe tie. Junni Diosichi opisa cuwenta junlari ya nene paminlaca meralaquituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Lari jun opisa cotonlabi winun tamolan joyoe. Labe cayaito wiminlaca se larito, seque nenasa carito cuidaiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tarinpunla mantimini opisa tsanlaca cuidaibi jatuminla joe tie. Fudacarin, toten, seiton quin, quebi jaminla joe. La mantimini sonnasa caribi jacayoe. Fe son tito nenalarasa caribi jacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Lari opisalaca sen tsacumin joto opisalachi tenchi puyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uyanla mantimini lachi opisalaca seque cuidaituminla jochunae tie. Peyunlari joto, tsacumin itoto, seque cuidailaituchunae tie. Lobo janaminca quirato, opisalaca purato sujilaichunae tie. Junni lobo opisalaca cato, ara talulu suerechunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Peyunlari joto, opisalaca laquiratuto, sujinilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Junni Jesús camicarinato itsantie: —Lari opisalaca sen tsacumin joyoe tie. Lachi opisalaca mirayoe tie. Yalanan laca miralarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Lachi Apa Diosi laca mirae tie. Lanan yacanan mirayoe tie. Junto lachi opisalachi tenchi puyano joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","In tobi tsachilacasiri lachi opisala titiyoe; uyanlacanan lachi opisala tinayoe. Yalacanan cano joyoe tie. Junni yalanan lachi fiquica meráto pelayailaito, jeralelanan man junni jolajochunae tie. Lasiri jeralelaca tsacumin joanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Junni la opisalachi tenchi tenca mánta mansonhichun, tenca mánta puyano joyoe tie. Jun tenchi lachi Apa Diosiri laca laquirae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Monantiya laca yalachi munate puyasa carilaquituchunae tie. Lari tenca mántanan puyano joyoe tie. Tenca mánta puyano podeiyanae. Junsi tenca mántanan mansonhino podeiyanae tie. Lachi Apa Diosi laca tsanquisa mantato, jun tsannan quino podeisa carie tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Junni Jesús tsanticaca meráto, israelítalari yaca man parejori tenca calaquitue. ");
INSERT INTO cofNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Weyan israelítalari Jesuca pa joto, yaca merátuntsan joe latinaminhe. Yucanchi oco yachibi wica joto, loco suwaca jonhoe latinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Weyanla mantimini itsanlatie: —Yucanchi oco yachibi wica jomanpari, jun sen fiquica patuno jomin jonhoe latie. Yucanchi oco wica junlari quirano podeitonlaca manquirasa carino podeilaituchunae latie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Junni aman man nete Jesús pilu mate micarinaminhe Jerusalén pueblobi. Fiesta ma jominhe. Matu mate Diosichi ya yucapiyacaca jera mansenunca mantenhinun fiestate jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Junni Jesuri Diosichi yabi nenaminhe Salomonchi posto tinunte. ");
INSERT INTO cofNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Junni israelítalari Jesuchi awinta layaito itsanlatie: —¿Numasi nu chiquilabe pachun? latie. Diosi wenteca jun Cristo tinun jotori, paniquede! latie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Junni Jesús yalaca beco tulanto itsantie: —Wari la numa pánasanan, nulari quereilaitue tie. Apa Diosichi mantate la wepanato quirantsancari quinamanyoe. Junca quiratonan, ti quiracari miintsan jominue tie. Nulari lachi opisala cuwenta itolajoe. Junca wari numa pacayoe. Lachi opisa cuwenta itoto, laca quereituminlae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lachi opisa cuwentala lachi fiquica seque meráto, labe penenaminlae tie. Yalaca mirato, ");
INSERT INTO cofNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","numatotiya sonnato polesa carimanyoe tie. Numatotiya puyalaituchunae tie. La yalaca quiranasa, monantiya lachi tedebi nechi josoleno podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Lachi Apa Diosi ya opisa cuwenta junlaca labe cayaisa carimin joe. Yari jeralelaca fécari sonban jonan, monantiya yachi tedebi nechi josoleno podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Junni laberi lachi Apaberi man junni jolajoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Junni Jesús tsantinunsile, israelítala manaman suca mancalaquee yaca su walacachi quito totechun. ");
INSERT INTO cofNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Junni tsanquechinaminlaca quirato, Jesuri itsantie: —Lachi Apa Diosichi mantate duque seque quiyoe tie nulachi cate. La ticatiya sequesiri quinamanyoe. ¿Jun tenchi laca totechi latinayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Junni israelítalari itsanlatie: —Seque quinun tenchi totelaquitiyoe latie. Diosica seiton panun tenchi nuca totelaquechinayoe latie. Nu tsachiri jotonan, Diosi joyoe timin joe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Jesunan ya fiquica meráto itsantie: —¿Nula Diosichi Pilaca tennaminla joyoe latitiyun? tie. ¿Jun pilabi chuteca jun fiquica natiya telatuntsan joco? tie. Aman jun pilabi Diosi patsa tsachilaca pato, “diosila” tinue tie. Junni Apa Diosi jun tsachilachi yachi fiquica cuwaca jominue jera meralaquisa. Laca mantimini wenteto mantá tan suwato erecae tote patato nenasa. Junni Diosi ya tsachilaca diosila tica jonari, ¿niya jonan laca pailainayun tie Diosichi Nao joyoe tinun tenchi? ¿Niyaito laca Diosica seitonque pánae tino podeilaichun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","La lachi Apa Diosi cuwenta ticatiya quitunari, laca quereilaituna! ");
INSERT INTO cofNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Junni lanan lachi Apa Diosi cuwenta seque wepanato quirantsancari quimin joyoe. Junni lachi fiquicari quereilaitutonan, Diosi tsannan quimin jonun tenchi quereilaina! tie. Jun tsanquinaminca quirato miino podeilaichunae lachi Apa Diosi labe man junni pejoeque. Lanan yachibi pejoequenan miino podeilaichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Junni Jesús tsantinun tenchi, israelítalari yaca cachique manan tenfelainue. Junni tsanlainasanan, Jesuri se loto, jito polee. ");
INSERT INTO cofNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yalachibi nechi loto, Jordán pi man beco manjilaiyoe. Mumunmin Juan casale mumunnun postoca jito, junbi chuminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Junbinan duque tsachila Jesúchica janilaie. Junni yalari itsanlatie: —Juan wepanato quirantsancari quitutonan, Jesuca pánato tsarasica pamin jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Junni junte duque tsachila Jesube cayailaie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Junni aman man nete tsachi manca quiyaica jominue. Lázaro tinun jominue. Ya Lázaro Betania tinun pueblobi chuminue. Aman yachi soquila, María manca, Marta manca, yalanan jun pueblobi chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Junni ya María inale Miya Jesuchi nedebi puban pi poto, achi manfusuwano jominue. Yalachi cayan quiyanpun jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Junni Lázaro quiyanpun josa, yachi soquila Jesúchica fiqui erelaquinue yachi amico quiyanpun joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Junni Jesús jun fiquica meráto itsantie: —Lázaro quiyanpun jotonan, tsanle puyano itoe tie. Ya quiyanpun jonan, tsachila Diosica duque seque palaquichunae tie. Diosichi Naocanan seque palaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Junnan Jesuri Mártabe Maríabe Lázarobecanan duque laquiramin jotonan, ");
INSERT INTO cofNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","yalachica we jitue. Lázaro quiyanpun joeque merátonan, palu ma juntenan caratobi ");
INSERT INTO cofNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","yachi tsachilabe pato, Judea toca manjilaisa! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Junni chiquilari Jesube itsanlatiyoe: —Miya, ¿Judéabi israelita mantaminla tsaina nuca su walacachi quito totechi ticala jotun? latiyoe. Tsan josari, ¿niyaito junchi manjino muquin? tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Junni Jesuri chiquilabe itsantie: —Jino óra joe. Junni óraca tenca calaquede! ¿Man malon chunca palu óra jotun? tie. Junni malonni nenano óra joe. Yo pata quinasa seque quirato nenato, tutulailaituchunae. Nemente nenaminla mantimini quirano podeituto tutulailaichunae tie. Junni la puyano ma cafatusanan, lachi tenchi malon cuwenta joe. La titiya quito nenano óra joe. La puyano ma feno fecári monantiya laca niyanan quilaquituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesuri tsantito, junto chiquilachi amico Lázaro catson tsoe tie. Yaca mansoncaribi jichinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Junni Jesús catson tsoe tinato, tsa catson tsocaca tsantitunue. Puyaca josanan tsantinaminue. Chiquila mantimini junca natiya catuituto, itsanlatiyoe: —Miya, catson tsotori, quiyan manseino jonhoe latiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Junni Jesús tuca pato, Lázaro puyaca joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Junto Jesús chiquilachi tenchi pansi joyoe tie Lázaro puyano órate itominlayoeque. Tsanquenan chiquila yaca nanni fe quereilaichunae tie. Tsantisi aman Lázarochica jilaisa! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jesús tsantinan, Tomás chiquilabe pae. Ya Tomachi manca mumun Dídimo jominhe. Yanan Jesube penenamin pejoto, chiquilanan Jesube puyabi pejinilaisa! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Junsiri Lázarochica jilaiyoe. Junbi fenasa, Lázaro numa puyacaca menacala jominue. Junpalu ma poleca jominue yaca menanun. ");
INSERT INTO cofNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Junni Betania pueblo Jerusalén quelote joe. Peman quilon tsansiri joe. ");
INSERT INTO cofNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Junnan duque israelítala Jerusalenbi nechi Maríabe Mártabechica jaca jominlanue. Cayan puyanunbi, peaconpanaibi jaca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Junnasa Mártari meránue Jesús janaeque. Junca merasi, yabe tulaibi janue. Maríari yabi puraica jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Junni Marta Jesúchibi fato itsantie: —Miya, nu inte matunan jaca jomanpari, chiquechi cayan puyano itomin jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tsan josanan chique mirayoe tie nu niyaquetiya Diosibe rocainan, tsanquiniquichunaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Junni Jesús Mártabe itsantie: —Nuchi cayan Lázaro mansonhichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mártanan itsantie: —Chique mirayoe tie. To yucapiyarino mate uyanlanan mansonhilainasa, yanan mansonhino joeque mirayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Junni Jesunan beconan pato itsantie: —Lari sonnasa carin, junsi puyaca junlaca mansonhisa carin, quimin joyoe tie. Labe cayaica junlari puyaca jominnan mansonhilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Labe cayaica junlachi tenca numanan puyalaituchunae tie. ¿Junca quereiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jesús tsantinan, Mártari itsanque tulanquee: —Miya, chiqueri quereiyoe. Nu jamochi nechi patano jomin Cristo joe. Nu Diosichi Nao joe. Junca quereica talari quereiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta tsantito manjito, yachi miyanbe nosale pato itsantinue: —Miya jae tinue. Nuca jasa tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Junni Marta tsantinunsiri, Maríari wewe manwiruito Jesúchica jae. ");
INSERT INTO cofNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesuri jun pueblobi cawica itominhe. Marta tulainuntenan cawiruraminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Junni weyan israelítalari Maríabe peaconpanaibi jaca jominlanue. Junni yala jaca junla quiralaquinue María wewe wiruito, urachi loto jinaminca. Junto menaranun postote warebi jinhinaeque tenhito, yalanan benechi pejinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Junni Maríari Jesúchibi fasi, yaca quirato, yachi nedele telenhito, Miya tie. Nu inte ramanpari, chiquilachi cayan puyano itomin jonhoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maríabe yabe pejaminlabe duque warenaminlae. Junni Jesús yalaca yachi tencabi duque laquiinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Junto itsantie: —¿Puyacaca tile menalaquiyun? tie. Junni ya Maríabe Mártaberi Miya, quirabi pejilaisa! tilatie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Junni Jesunan junca jera quirato, waree. ");
INSERT INTO cofNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Junni Jesús warenaminca quirato, israelítalari itsanlatie: —Quiralaquede! latie. Lázaro puyacaca duque laquiraminue latie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aman junca quirato, weyanla itsanlatie: —Jesús quirano podeitonlaca quirasa carimin jotori, ¿niyaito Lázaro quiyanpunca manseno podeitu junhun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Junni Jesuri menaranun postobi fenato, manan duque laquiie. Junni puyacalaca menanun forote suchi doca jominca ");
INSERT INTO cofNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","suca junte nechi manlasilaquede! tie. Junni ya puyacachi soqui, ya Mártari, jun fiquica meráto, wepanato, itsantie: —Miya tie. Ya puyanun junpalu ma joe tie. Suca lasinari, peten puba jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Junni Jesuri itsantie: —¿La pacaca quereitori, Diosi wepanato quirantsancari quinaminca quirachunae tituan? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Junni Jesús tsantinunbi, puyacaca menaranun forote nechi suca manlasilaquee. Junni Jesuri jamochi quirato itsantie: —Apa, nuri laca meránun tenchi la acradeseiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mirayoe nu laca numasitiya merámin joeque. Tsan josanan inte labe pewiruraminla yape meralaquisa tsantinayoe tie. Yape nu laca ereca joeque quereilaisa tsantinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Junni Jesús tsantitobi, sonba pato, itsanque otie: —Lázaro, manlade! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsantinunsile ya Lázaro puyaca jomin forochi nechi manlaniie. Tedebinan, nedebinan piraca jun manlae. Caforobinan panuchi lapicaricala jominue. Junni manlanunsile Jesús yaca piraca jominca manwolelaquede! tie yape manjino podeisa. ");
INSERT INTO cofNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Junni duque israelítalari Maríabe pejato, yachi cayanca mansoncarinaminca quirato, Jesube cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Junto weyan israelítalari fariséolachica jito, fariséolabe jera cuenta quilaquinue Jesús niyantiya quica jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Junni fariséola junca meráto, yalabe mantá tan patelelabe layaito weyan mantaminlacanan jacarito, tenpalaquinue. Yala tenpanato, itsanlatinue: —¿Niyan quicaichunan? Ya tsachiri duque wepanato quirantsancari quinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yaca tsantin nenasa quiranilaquinari, jerale tsachila ya Jesúcari Miya joe tito, yabesiri cayailaichunae latinue. Tsanhilainari, romano soldadolari jato, Jesuca miya suwachique tsanlainae tito, chiquilaca pa jolajochunae latinue. Junto Diosichi yaca araleto, chiquilacanan quera quito, jera totelaquichunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Junni israelita mantaminla tsanque tenpalaquinato, Caifaman panue. Jun watate Caifás yala tala fe mantá tan patele jominue. Junto ya itsantinue: —Nulari tenca iton tala tenpalaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jeralela tenca calaquede! Puyantsan jotori, mancasiri puyano fe se jochunae tinue. Manca tsachisiri piyanle israelítalachi tenchi puyantsan joe yape jeralela puyano itolajosa. Tsanque chiquilachi tenchi fe se jono joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Junni Caifás yachi tenca mánta tsantica itominue. Jun watate ya fécari mantá tan patele jonan, Diosi yaca tsanque pasa carinue. Diosi ya Caifaca tsanque pasa carinue Jesús jerale israelítalachi tenchi puyano joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Junsi israelítalachi tenchisiri puyano itominue. Uyan tobi chumin tsachilanan, yalanan Diosibe cayaino jominlanue. Junni yalachi tenchinan Jesús pepuyano jominue jerale Diosichi tsachilaca layasuwato, yape man bolonni jolajosa. ");
INSERT INTO cofNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Junni Caifás tsantitobi, israelita mantaminlari Jesuca totesa carichique tenfeto nenaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jun tsanhilainanunca miito, Jesús israelítalachite nenatumin jominhe yape yala quiralaquitusa. Jesube yachi tsachilabe junbi nechi loto, Efraín tinun puebloca jito, junbi chuminlayoe. Ya Efraín pueblori niyanlanantiya chutunun posto quelote joe. ");
INSERT INTO cofNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Junni israelítalachi casa ma fiesta queloinaminhe. Junni casa ma caitusanan, duque israelítala Jerusalenca numa jera janaminlanue ya fiesta tenchi tenca manseichun. ");
INSERT INTO cofNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Junni ya jaca junlari Jesuca neyanaminlanue. Neyanato, Diosichi yabi nenato, yala tala cuenta quito itsantilatinue: —¿Nuchiri niya quiraque tenca jan? latinue. ¿Ya Jesús in fiestaca quirabi jachunan? latinaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aman mantá tan patelelabe fariséolaberi jerale tsachilaca mantaca jominlanue. Motiya Jesuca quiratori, ya mantá tanlabe meracaribi jana! tica jominlanue. Junto Jesuca cato dochun, tsanque mantaca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Junni casa ma fiesta ino sota ma cajosanan, chiquila Jesube Betania tinun puebloca jilaiyoe. Jun pueblobi Jesús mansoncarica jun tsachi chuminhe Lázaro tinun. ");
INSERT INTO cofNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Junto junbi chuminlari Jesús seque quimin jonun tenchi duque ano dato, duque amicolaca pejasa carilaquee. Lázaronan junbi ano pefinaminhe. Junni Lázarochi soqui Marta ano poto cuwanaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Junnasa Mártachi miyan Maríari man libra sen nardo tinun duque mica puban pica tanjae. Junni ya puban pica tanjato, Jesuchi nedebi poto yachi achinan manfu suwae. Jun yabi jeralete puba eree. ");
INSERT INTO cofNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Junni Jesúlabe Judas mumun tsachi pechuminhe. Simón Iscariótechi nao jominhe. Júdari Jesube penenamin jotonan, nanni inale yaca pa jominlachi cuwapono jominue. Junni María puban pica Jesuchi nedebi ponaminca Judas quirato, paito itsantie: ");
INSERT INTO cofNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ya puban pica potuntsan jominue. Osintsan jominue tie. Yaca osito, duque cala cato, ya calaca poperelachi cuwantsan jominue tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Junni Júdari tsantinatonan, poperelaca laquirato tsantitue. Yari chiquilachi calaca cuidaimin jotonan, tarinmin jominue. Ya cala senaminca pansile tarinmin jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Junni Judas Maríaca tsanque painaminca Jesús meráto, itsantie: —Ya sonaca paitude! tie. ¿Puyacalaca menachun puyacachi pucabi puban pica ilipono jotun? tie. Jun tenchi María puban pica senaminue tie laca menano mate tenchi. ");
INSERT INTO cofNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Poperelari nulabe numasitiya pechuto polelaichunae tie. Lari nulabe numasitiya pechutuanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Junni Jesús jaca jonunca meráto, duque israelítala yaca quirabi jalaie. Tsan jotonan, Jesúcasiri quirabiri jaca itominlanue. Jesús mansoncarica jun Lázaroca quirabi jaca jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Junni Lázaroca mansoncarica jonunca quirato, duque israelítalari mantá tan patelelaca telaquepoto, Jesube cayainaminlanue. Jun tenchi mantá tan patelelari Lázarocaman toteno tenca canaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ayuna nanchi man bolon tsachilari fiesta quirabi jaca joto, Jesús janaeque meralaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Junto cati japisunan quiranca cato, Jesuca tulaibi jalaie. Biba quede jalaie. Diosichi mantate janaminca seque pantsan joe latie. Israelítalachi miya joe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Junnasa Jesuri buro náca casa carito, junbi chudito pueblobi wie. Junni matu mate Diosichi Pilabi junca itsanque pila chuteca jominue: ");
INSERT INTO cofNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalenbi chuminla, nula jele tilatitunaque chuteca joe. Quiralaquede! Nulachi Miya buro nabi chudito jachunaeque chuteca joe. Matu mate Diosichi Pilabi tsanque chuteca josa, Jesús jun tsannan inaminue buro nabi chudito jaca. ");
INSERT INTO cofNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Aman Jesube penenaminlari casale jun órate jun tsannan inaeque tuilaitiyoe. Wanbile mantimini aman junca jera tuilaiyoe. Jesús puyato mansonhito, jera mantá tan inunbi, mantenhilaiyoe yaca tsanque chuteca jonan, jun tsannan patinueque. ");
INSERT INTO cofNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Junni aman Jesús Lázaro puyacaca mansonhisa carinasa, duque israelítalari quiranaminlanue. Menaranun forochi nechi manlade! tinamincanan yala meránaminlanue. Junni yalanan fiestaca jato, duque weyanla jun fiestabi pejaca jominlabe jun cuentaca jera quilaquinue Lázaroca mansoncaricaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Junni Jesús tsanque wepanato quirantsancari quinunca meráto, ya fiesta quirabi jaca jominlanan Jesuca tulaibi jalaie pueblobi winaminca. ");
INSERT INTO cofNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Junni junlaca quirato, fariséola tala itsanque cuenta quilaquinue: —Quiralaquede! latinue. Niyanantiya quino podeitulajoyoe latinue. Jeralela yabe penenachi latinae latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Junni griego tsachila israelítalachi fiestaca jalainue Diosibe rocaibi. ");
INSERT INTO cofNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aman Jesube penenamin tsachi manca, ya Felipe tinun, junbi peraminue. Ya Betsaida pueblobi nechi jominue Galilea tobi. Junni ya griégola Felípechica jato, duque respetaito pato, itsanlatie: —Chiquila Jesuca quirano munaralarayoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Junni griégola Felípebe tsantinunsile, Felíperi Andrebe cuenta quee. Junsi yala paluito Jesúbenan cuenta quilaquee griégola nuca quirachi latinaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Junni Jesuri Felípela tsanque cuenta quinunca meráto, itsanque micarie: —La tsachi ica jun jonan, Diosi lachi tsara uraran mantá cuwano óra fachinae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Junni nulabe tsarasica pachinayoe tie. Trico ni tobi arajica cuwenta joanae tie. Ya ni jopoto sutori, quido petechunae tie. Tsanhinari duque ni seque serachunae tie. Jun tsanquenan la puyanari, lachi tsachi bolonla duque seralaichunae tie. Juntonan trico niri pucale puraitori, man ni nacári puraito jera petechunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jun tsanquenan tenca munate pansi nenachi timinla jun trico ni peteca cuwenta epe jolajochunae tie. Lachi tenchi puyanocatiya jeleratuminlari numatotiya sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Labe mantaiminla la cuwentanan jonola joe. Labe mantaiminla la chununbinan pechularachunae tie. Labe mantaiminlaca Apa Diosi sen jolajoe tichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Junni Jesús tsachilabe cuenta caquinato, itsantie: —Tsainanan lachi tenca wepananae tie. ¿Junto niyan tino joinhin? Apa, nu laca padeseisa caritude! tituntsan jochunae tie. Padeseibinan jacayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Junni Apa, tsara wepanato quirantsancari seque quede! tie yape tsachila nuca duque sen joe tilatisa. Jesús tsanque panunsi, Diosichibi nechi fiqui mera jominhe. Itsantie: —Tsanquica joyoe tie. Junsi manaman tsanqueyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Junni junte duque israelítala pewiruraminla ya fiquica yucaleri meráto, cunta jonhoe latie. Weyanlari pato, anjeli Jesube cuenta quin quinae latie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Junto Jesuri yalabe beco manpato, itsantie: —Ya fiquiri lachi tenchi itominue tie; nulachi tenchiri jominue tie yape Diosica tenca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Junni meralaquede! Nanni inale jera miintsan jochunae jerale tobi chuminla seiton jolajoeque. Inale lari yucanca fe lochinayoe tie. Yucan Diosica tennatuminlaca mantaminca fe lochinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Junni lari corosibi totaito, lachi piyanle tsachilaca labe jera cayailaisa cariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yape Jesús corosibi puyano joeque tenhilaisa tsantinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Junni ya fiquica meráminlari itsanlatie: —Diosichi Pilabi Cristo tinunca pato, ya numatotiya sonnato polechunaeque chuteca joe latie. Nu Jesús mantimini tsachi ica jun joyoe tito, corosibi totaino joyoe tie latie. ¿Junni tsachi ica jun, yanan Cristo jotun? latie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Junni Jesunan yalabe beconan itsantie: —Nulaca nasi fecáriri catsenano joyoe tie. Junni catse josanan, seque nenalarana! tie nemente nenatuchun. Nemente nenaminla niyaque nenano jonunca miitolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Junni catse josanan, tseminbe cayailaide! tie Diosichi tsente nenaminla jochun. Jesús tsantisi manjito poleto, tsaito chuminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Junni Jesús israelítalachi cale duque wepanato quirantsancari seque quica jominue yape miilaisa. Tsanquinasanan, yabe cayaituchi latinaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Matu mate tsachi manca Diosichi mantate pamin jominue ya Isaías mumun. Yari Jesube cayaituchi timinlaca pilabi itsanque chuteca jominue: Miya Diosi, chiquila meracaricaca tsachila tennatuchi latieque chuteca joe. Nu duque wepanato quirantsancari seque quinaminca quiratonan, tennatuchi latieque chuteca joe. Isaías tsanque pila chuteca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Junni tsachila jun tsanla jonun tenchi Jesuca merátonan, yabe cayaino podeiton ilainue. Junni Isaías jun tsanla jonunca manpato, itsanque pila chuteca jominue: ");
INSERT INTO cofNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diosi miituchi timinlaca miino podeiton suwamin joe yape miilaitusa. Merátuchi timinlaca meráno podeiton suwamin joe yape meralaquitusa. Tsanque podeiton suwamin joe yape yala Diosibe cayaituto manseilaitusa. ");
INSERT INTO cofNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías tenhica jominue Jesús tsaracari uraran mantá tan jochunaeque. Tsanque tenhito, Isaías tsanque pila chuteca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Junni Isaías tsantica josanan, duquele israelítala Jesube cayainilaie. Weyan weyanlari israelítala tala mantá tanla jotonan, Jesube pecayainilaie. Junni mantá tanla cayaicala jotonan, nosa cayailaie. Weyan israelítalabe pánato, cayaicalayoeque patulajonue fariséolaca jelechi. Jesube cayaicalayoe tica jomanpari, fariséolari yalaca Diosichi fiqui miinun yabi pelayaisa carituno jominla jonhoe. ");
INSERT INTO cofNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yalari cayaicala jotonan, tsachilachi cate sen jono munaralaratonan, Diosichi cale sen jono layan munaratuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Junni Jesuri sonba pato itsantie: —Labe cayaiminla labesiri cayaicala itochunae tie; laca ereminbenan cayaicala jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Laca quirato, lacasiri quiratulajochunae tie; laca eremincanan quiralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Junni tsachilachi tenca nemen jominbi tse suwabi patacayoe tie. Labe cayaiminlachi tencaca nemenbi nechi laribi patacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Weyan tsachilari lachi fiquica punquichi merátonan, tenca cato merátuminla joe tie. Junni lari yalaca culpa quitiyoe. La seiton nenaminlaca culpa quebi patatucayoe; yalaca se laribi patacayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tsan josanan laca tennatuto, lachi fiquica merátuchi timinlari culpa patilaichunae tie. La paca jun fiquica merátuchi tilatinari, junni jun fiquibenan culpa patilaichunae tie. La jun tsantica fiquica mantenhinola jochunae tie in to jeraino mate. Junni jun merátuchi tinun fiquibenan nula culpa patilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Lari in fiquica tencachique mantate pátiyoe tie. Lachi Apa Diosi laca ereto, ya tsanque mantanae. ");
INSERT INTO cofNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Diosi tsanque mantánan, la tsachilaca numatotiya sonnasa carimin joyoe tie. Junni lari junca mirato, lachi Apa Diosichi mantatesiri tsanque pánayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Junni casa ma fiesta nasi nacá caitosanan, Jesube chiquilabe man parejo ano pefilaquinamanyoe. Junni junnasa yucan Júdaca seiton tenca suwaca jominue. Ya Júdari Simón Iscariótechi nao jominue. Junni yaca Jesuca pa jominlachi cuwapono tenca casa carica jominue. Jesús mantimini jera miraminue Apa Diosi yaca jera mantá tan suwaca joeque yape jeraleca mantasa. Diosichibi nechi pataca jomin joto, Diosichicanan manlono jominue. Yacanan Jesús miraminue. Junni jamochi manlono ma quelo inaminue yachi Apa Diosichica manlono ma. Chiquila yachi tsachila joto mantimini, tote canenanonan jominlayoe. Junni aman Jesuri juncanan tenhinue ya jamochi manlono ma quelo inaeque. Junca tenhito, chiquilaca duque laquiramin joto, sen quito quirawoe duque laquiramin joeque miralarasa. Itsanquee: ");
INSERT INTO cofNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ano filaquinaminnan, Jesús wiruito, camisa larito, towayaca awinto, ");
INSERT INTO cofNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","labacarabi pi poto, chiquilachi nedeca tsalee chiquilachi peyun cuwenta ito. Nedeca tsaleto, ya towayachinan nedeca manfu suwae. ");
INSERT INTO cofNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Junsi Simón Pédrochi nedecanan tsalechinaminca Miya tie. ¿Niyaito lachi nedeca tsalechinayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuri beco pato, itsantie: —La niyaque quinanunca nu amana tuituchunae tie; wanbile tuichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Junni aman Pedro itsantie: —Nuri lachi peyun itoe. Lachi nedeca numanan tsaletuchunae tie. Junni Jesuri itsantie: —Nuchi nedeca tsaletunari, lachi tsachi itochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tsantinunsile Simón Pedro itsantie: —Miya, nedecasiri tsaletude! tie. Tedecanan, misucanan tsalede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Junni Pedro tsantinunsi, Jesuri itsantie: —Te, nedecari tsalentsan joe tie. Pucalete pipiyatobi, pucalete manpipiyano itoe; tobi nenato nedecari mantsaleto, pucalete manpipiyaca cuwenta manjolajochunae tie. Jun tsanquenan nulachi tenca jera tsaleca jolajoe tie. Junni nula jeralelachi tencaca tsaleca jun itolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús miraminue mo yaca cuwapono jonunca. Jun tenchi nula jeralelachi tencaca tsaleca jun itolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Junni aman Jesús chiquilachi nedeca jera tsaletobi, yachi camisaca manpoto manchuditobi, itsantie: —¿La nulaca tsaina niyaque quinanunca entendeilaitiyun? tie. Tenca calaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nula laca Miya timinlae tie. Micarimin timinlae tie. Nulari tsa pato tsanlatinae tie. Nulachi Miya joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Junni lari nulachi Miya jotonan, peyun cuwenta ito nulachi nedeca tsaleyoe tie. Junni la tsanquinari, nula talanan ticatiya peyun cuwenta ito tsanquinilaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lari tsanquiyoe yape nulanan la cuwenta nenalarasa. ");
INSERT INTO cofNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nulabe tsarasica pachinayoe tie: Peyunla yalachi patronlaca fécari mantá tan itolajochunae tie. Ereca junla yalaca ereminlaca fe mantá tan itolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Junca miratonan merátutori, pansi itolajochunae; mirato meráminlari pansi jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nula jeralelacari tsantitiyoe tie. La mirayoe la wenteca jun tsachila niyan jolajonunca. Tsan josanan Diosichi Pilabi man fiquinan chuteca joe: Labe ano pefimin tsachi manca lachi contraino joeque chuteca joe tie. Jun fiquiri jun tsanquenan patichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Junni jun catsanhitusanan nulabe pánayoe tie tsanhinasa yape mantenhito quereilaisa. Junni Jesús capánato itsantie: —Jun mate la pacaca mantenhito, la mo jomin jonunca tenhilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nulabe tsarasica pachinayoe tie: La ereca junlaca facariminlari laca facariminla cuwenta jolajochunae; laca facariminlari laca ereminca facariminla cuwenta jolajochunae tie. Jesús chiquilabe tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Junni Jesús tsantito, yachi tencabi duque wepananato, chiquilabe itsantie: —La nulabe tsarasica pachinayoe tie: Nula manca laca cuwapochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Junni Jesube penenaminla tala beco beco quiracaalaquiyoe moca tsantin tinanque tenca cato. ");
INSERT INTO cofNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Junni Jesube penenamin manca, ya duque laquiranun tsachi, yachibi nanle chuminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Junni Simón Pedro yaca tedechi mipa mipa quee yape Jesube panhasa. Mo cuwapono jonunca miichun tsanquee. ");
INSERT INTO cofNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Junni ya tsachiri Jesube panhato, ¿Moca tsantiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Junni Jesús itsantie: —Bibuca pisule casi, tunpibi unto cuwachinayoe tie. Ya bibuca camin laca cuwapomin jochunae tie. Tsantisi bibuca cato tunpibi atacarito, Júdachi cuwae ya Simón Iscariótechi naochi. ");
INSERT INTO cofNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ya bibuca canunsi, yucan Júdachibi winue. Junni Jesús yabe itsantie: —Ti quino jototiya, we quiniquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Weyanla ano pefinaminlari miitolajominue tica tsantica jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas Jesube penenaminlachi calaca taminhe. Junni weyanlari tenca cato, fiesta ano fichun ticatiya casa mantaca jonhoe latie. O poperelachi ticatiya cato cuwasa tica jonhoe latie. Tica tsantica jonunca tsarasi miitominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Junni Judas jun bibuca fisi, tamochi nechi manloto jie. Quepen jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas loca josa, Jesús itsantie: —Inale miintsan ichunae la tsachi ica jun joto tsara sen patsa joeque. Lanan jerale tsachilaca quirawochinayoe Diosi tsara sen patsa joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Diosi tsara sen patsa joeque la micarinasanan, Diosinan laca tsara sen patsa joeque micarichunae tie. Moora tsan joeque micarichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Junni nalalabe cuwenta nulabe pachinayoe. Nulabe nasiri canenano joyoe tie. Matuleri la israelítalabe pato, itsanticayoe: La jinanunca nula jano podeilaituchunae ticayoe tie. Junni amana nulabenan jun tsannan tichinayoe tie. Nula la jinanunca pejino munaratonan, podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nulachi casan mantá cuwachinayoe tie yape nula tala laquiracaalaquisa. La nulaca laquiranun cuwenta, nula talanan laquiracaalaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nula tala laquiracaato nenalaranari, jeralela junbe miilaichunae labe penenaminla joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aman Jesús tsantinunsile, Simón Pedro pato, Miya, ¿nunchi jichinayun? tie. Jesunan itsantie: —La jinanunca nuri pejano podeitue tie. Man mate nu junchi pejano podeichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Junni Pédronan itsantie: —Miya, ¿niyaito nube pejino podeituichunan? tie. Nuchi tenchi puyanoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús Pedro tsantinanunca meráto, itsantie: —¿Lachi tenchi puyanoyun? tie. Te. Nube tsarasica pachinayoe tie: Nunan laca purachunae. Walpa apaca capatusanan, peman ne laca miitoyoe tichunae tie. Jesús tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Juntonan Jesús chiquilabe itsantie: —Nulachi tencabi wepanatulajona! tie. Diosica tennato, lacanan tennalarana! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lachi Apa Diosichibi duque chunun ya joe. Tsan itomanpari, nulabe tsantino itomin joinhie. Nula chuno jonun yaca sequebi jino joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yaca jera sequetobi, aman manpatano joyoe tie. Nulaca mancábi manpatano joyoe tie yape nulanan labe pechularasa. ");
INSERT INTO cofNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nula la jinanun postoca jinun minuca miralarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Junni Jesús tsantinunsi, Tomari itsanque tulanquee: —Miya, nu nunchi jino jonunca miitolajoyoe tie. ¿Junto junchi jino jun minucari niyaito miintsan jun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Junni Jesuri itsantie: —Lasiri Apa Diosichica jinun minu joyoe tie. Lasiri tsarasica micarimin joyoe tie. Lasiri sonnasa carimin joyoe tie. Labe cayaiminlasiri Apa Diosichibi feno podeilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nula laca miralaramanpari, lachi Apa Diosicanan mirano jominla jonhoe. Amanale nechi yaca miralarayoeque tenhilaide! tie. Yaca quiraminlanan joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Junni Jesús tsantinunsi, Felíperi itsantie: —Miya, Apa Diosica chiquilachi quirawode! tie. Wari chiquilari nantari panhalaquituanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Junni Felipe panunca meráto, Jesús itsantie: —Felipe, nulabe numari penenasanan, ¿laca camiitolajoyun? tie. Laca quiraminla Apa Diosicanan quiraminla joe tie. ¿Junni ti quichun Apa Diosica quirawode! tiyun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Labe Apa Diosibenan man junni jolajoyoe tie. ¿La paca fiquica quereiyun? tie. Nulabe cuenta quinato, tencachique mantate patumin joyoe. Lachi Apa Diosi lachi puca cuwentanan joto, tsanquimiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Quereilaide! labe Apa Diosibe man junni jolajoeque. O man quiraque tenca calaquede! ¿Wepanato quirantsancari seque quiyoco? tie. Junni lachi fiquicari quereino podeitutori, jun wepanato quirantsancari quinaminca quirato quereilaide! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nulabe tsarasica pachinayoe tie. Laca tennaminla la tsannan quinilaquichunae tie. La tsansinan wepanato quirantsancari quilaquichunae tie. Junni lachi Apa Diosichica manlonan, nula laca fécari wepanato quirantsancari quilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nula lachi mantate ticatiya quisa rocainari, ticatiya quiniquito cuwanae tie. La Diosichi Nao joto tsanqueyanae tie yape Apa Diosi tsara sen patsa joeque miilaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nula lachi mantate ticatiya rocailainari, tsanqueyanae tie. Jesús chiquilabe tsanque cuenta quee. ");
INSERT INTO cofNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Junto Jesús chiquilabe itsantie: —Nula laca laquiratori, la mantacaca meralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Junni la Apa Diosibe rocaiyanae tie yape tenca cuwamin mancaca nulachica eresa. Ya tenca cuwaminni nulabe numatotiya penenato polechunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Diosichi Tenca patsa ya tenca cuwamin jochunae tie. Junni yari tsarasica pamin joe. Juntonan Diosica tennatuminlari yachi Tencabe cayaino podeilaituchunae tie. Yalari Diosichi Tencaca quiratuto, yaca miratuminlae tie. Nula mantimini Diosichi Tencaca miralarae tie. Nulabe penenatonan, nanni ina nulachibinan wichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aman lari nulaca tsanle puracachiri puratuanae; la nulachica manjanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Inale piyanle tsachila laca quiralaquitusanan, nulari laca quiralaquichunae tie. La sonnato, nulacanan tsarasica sonnasa cariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jun mate nula tsarasica miralarachunae. La Diosibe man junni joeque, nulanan labe man junni jolajoyoeque, lanan nulabe man junni joeque miralarachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","La mantacaca miito meráminlari laca laquiraminla jochunae tie. Laca laquiraminlaca lachi Apa Diosinan laquirachunae tie. Lanan yalaca laquirato, yalabe quiraiyanae tie. Jesús chiquilabe tsantie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Junni manca Judas jominhe; Judas Iscariote itominhe. Yari Jesube itsanque panhae: —Miya tie. ¿Niya jonan piyanle tsachilabe quiraituchun? tie. ¿Niyaito chiquilaberi quiraichun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesunan yabe itsantie: —Laca laquiraminlari la pacaca meralaquichunae tie. Junni lachi Apa Diosi ya tsachilaca laquirachunae tie. Junto Apa Diosibe labe yalachica jato, yalabenan penenalaranae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Laca laquiratuminlari la pacaca meralaquituchunae tie. Junni in fiquica lachi tenca munate pátiyoe; Apa Diosi laca inchi ereto, tsanque pasa carinae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nulabe canenaminnan, la tsanque micarinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tsan josanan, inale Diosichi Tenca nulachica patato, ticatiya jera micarichunae tie. Apa Diosiri yachi Tencaca lachi tenchi erechunae tie. Yari nulachica jato tenca cuwato, la ticatiya pacaca jera mantenhisa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","La nulaca pansi suwato jichinayoe yape wepanatuto chularasa. La wepanatuto pansi chumin joto, nulacanan jun tsanquenan pansi chusa cariyanae tie. Diosica tennatuminlari nula tsanquenan pansi chuno podeilaituchunae. Junni nulari wepanatulajona! Jeleitulajona! ");
INSERT INTO cofNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","¿Nulaca purato jito, inale manjanae tituan? tie. Lachi Apa Diosichica manlochinayoe. Yari laca fe mantá tan joe tie. Junni nulari laca jera laquiramanpari, son tino jominla jonhoe yachica lochinaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nulaca capurato jituminnan, nulabe tsanque pánayoe tie la tsanhino mate nulari lachi fiquica mantenhito quereilaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Amanale nechi nulabe layan patuanae tie. Yucanni Diosica tennatuminlaca mantá tan joto, laca casa carichinae tie. Ya mantimini laca natiya mantano itoe. ");
INSERT INTO cofNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","La niyanhinatotiya yucanchi mantate natiya tsanhituanae tie; Apa Diosichi mantaca meráto tsanhiyanae tie. Apa Diosica merámin joto, tsanhiyanae tie yape Diosica tennatuminla miilaisa la Apa Diosica laquiraeque. Jesuri tsanque pato, junto aman cupalaide! Jilaisa! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Junto Jesuri itsantie: —La sen uba sili joyoe tie. Nulanan uba ali jolajoe tie. Lachi Apa Diosiri uba wita cuidaimin joe. ");
INSERT INTO cofNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Junni alibi puca ituminca poreto queerechunae. Puca imin alicari poreno itochunae. Jun alibiri seiton na alicari poreto quepochunae yape jun sen alibi fécari puca isa. ");
INSERT INTO cofNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","La pacaca meráto, jun sen uba ali cuwenta jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Junto nula labe man junni jonola joe. Lanan nulabe man junni joanae tie. Uba aliri silibi churatutori, numanan puca ino podeituchunae tie. Nulanan jun tsanquenan labe man junni itotori, natiya seque nenano podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Lari uba sili joyoe. Nulari lachi ali jolajoe. Junto labe man junni jolajona! Lanan nulabe man junni joanae tie. Motiya labe man junni jominla ticatiya duque seque quilaquichunae tie. Sen sili duque puca imin cuwenta jolajochunae tie. La itosa tinantiya quino podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Labe man junni itonlaca queerelaquichunae puca itumin alica cuwenta. Ya ali jequeicaca layato, ninbi quepolaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nulari labe man junni joto, lachi fiquica meráto nenatori, ti quisatiya rocaino podeilaichunae. Ti munaranuncatiya rocainari, Diosi ticatiya tsanquiniquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tsanque nenalaratori, duque sen jolajochunae titiya duque puca imin uba ali cuwenta. Jun tsanla jotori, labe seque penenaminla ichunae tie. Uyanla junca quirato lachi Apa Diosica duque seque palaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Junni Jesús cacuenta quinatonan itsantie: —Lachi Apa Diosi laca laquirae; jun cuwentanan la nulaca laquirayoe tie. Nulanan jun tsanquenan laquiracaato nenalarana! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","La mantacaca meráto nenatori, la cuwenta laquiracaato nenalarachunae tie. Lanan lachi Apa Diosi mantacaca meráto, ya cuwenta laquirato nenamin joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nulaca la cuwentanan son jolajosa tenjae. Man piti nacátiya laqui itolajosa tenjae tie. Jun tenchi la tsanque micarinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nulaca itsanque mantaquechinayoe tie. La nulaca laquirayoe; jun cuwenta nula talanan laquiracaalaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Junni meralaquede! Amicola tenchi tenca mánta puyachi timin tsachi duque laquiramin jochunae. Uyanla ya tsansi laquiratuminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Junni nulari la ticatiya mantaca junca merátori, lachi amicola jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jana patronlari ti quinanunca mantaiminlari miitolajochunae. La mantimini nulabenan jera pacayoe. Lachi Apa Diosi pacaca meráto, nulabe jera cuenta manpolaricayoe tie. Junto amanale nechi nulaca pato, mantaiminla titiyoe. Amanale nechi nulaca amicola tiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Laca wentetulajoe. Lari nulaca wentecayoe. Nulaca mantá tan suwayoe lachi tenchi titiya seque quito nenalarasa. Sen ali duque puca inun cuwenta, nulanan lachi tenchi duque seque quilaquichunae. Junni ya puca tsanni jeraituchunae. Tsan jonan lachi Apa Diosibe ticatiya rocailaina! Ticatiya lachi mantate rocailainari, cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Junni nulaca itsanque mantaquechinayoe tie. Nula tala laquiracaalaquina! tie. Jesús tsanque micarie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Junto Jesús yachi tsachilabe itsantie: —Diosica tennatuminlari nulaca pailainari, wepanalaituna! tie. Casale laca paiminlari nulacanan pailaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nulari yalabenan man junni jomanpari, nulaca laquiranola jomin jonhoe. Tsanni yalabe man junni itolajoe. Lari nulaca wentecayoe man quiraque nenasa carichun. Jun tenchi uyan tsachila nulaca pa jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nulabe man fiqui numa pacayoe. Mantenhilaide! tie. ¿Peyunla yalachi patronlaca fécari mantá tan itolajochunae tituan? tie. Junni labe seiton jominla nulabenan seitolajochunae tie. La pacaca meráminlari nulacanan meralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yalari laca ereminca tennatuminla joto, nulabenan jera niyaquetiya seiton jolajochunae tie. Nula labe penenamin jonun tenchi tsanlajochunae. ");
INSERT INTO cofNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yalaca payibi jacayoe. Payibi jaca itomanpari, culpa itono jominla jonhoe. Tsan josanan yalaca payibi jacayoe. Junni jun tenchi miitoto, culpa itoyoe tino podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yala laca pa nenaminla lachi Apa Diosicanan pa nenalarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Monantiya quino podeitununca lari quiniquiyoe tie. Yala quiralaquinasanan tsanquiyoe. La tsanquica itomanpari, yalari jutsa itono jominla jonhoe. Amana wari laca quiraminla jotonan, lachi Apa Diosicanan, lacanan jera pailaie tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Diosichi Pilabi yalachi tenchi itsanque chuteca joe tie. Laca epenan pailaichunaeque chuteca joe. Junni Diosichi Pilabi tsanque chuteca josa, jun tsanquenan patinae. ");
INSERT INTO cofNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Junni aman tsan josanan, Diosichi Tenca nulachica patachunae tie. Ya Apa Diosichi Tencari seque tenca cuwamin joe tie. Seque pamin joe tie. Diosichibi nechi pataca jochunae. Junni lari Diosichi Tencaca nulachica ereyanae tie. Apa Diosichibi nechi ereca jun patachunae nulachibi wichun. Yari laca jera cuenta polarichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aman la casale nenanunle nechi nulanan labe penenaminla joe. Junto nulanan laca cuenta polariminla jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús chiquilabe cacuenta quinato itsantie: —Yape nula labe penenano peleitusa, nulabe tsanque cuenta quinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Diosica tennatuminlari nulaca Seitonla joe tito, Diosichi fiqui miinun yabi nechi larilaquichunae yape weyanlabe pelayailaitusa. Man mate nulaca totenato, Diosichi tenchi seitonlaca totenayoe tilatichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Laca tennatuto, lachi Apa Diosicanan tennatuto, tsanlaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nula tsanhino mate lachi fiquica mantenhilaina! tie. Jun tenchi nulabe tsantinayoe tie. Jesús chiquilabe tsantie. Junni Jesús chiquilabe capánato itsantie: —Casale la nulabe canenaminnan, nulabe tsanque cuenta quino óra caitominhe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Tsan jomin josanan, amanari wari manjino inato tsantinayoe. Laca ereminchica manjino joyoe tie. Junni nulari duque laqui jolajoe tie. La padeseino jonunca meráto, duque laqui tenca jolajoe tie. Nulari duque laqui tenca jotonan, la nunchi manjino jonunca panhantiya quituminla joe. ");
INSERT INTO cofNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tsan josanan nulabe tsarasica pachinayoe tie. La inte nechi manjinari, nulachi tenchi fécari se jochunae tie. La manjinunbi, Diosichi Tencari nulachi tenca cuwabi patano joe tie. Junni la manjitunari, ya tenca cuwamin patatuchunae tie. La manjitobi yaca ereyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ya jatobi, Diosica tennatuminlaca itsanque tenhilaisa carichunae. Tsachilari jutsa tanla joeque, lari sen joeque, Diosiri seitonlaca casticaquimin joeque, tenhilaisa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tsachila labe cayaituchi timinla joe; junnan miintsan jochunae tsachila jutsa tanla joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Junsi lachi Apachica manjicabi laca manquiralaquituchunae; junnan miintsan jochunae laca sen jominueque. ");
INSERT INTO cofNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Junsi yucanni Diosica tennatuminlaca mantamin joe. Junni Diosi yaca culpa tae tito, casticaquintsan joe tichunae. Junnan miintsan jochunae Diosiri seitonlaca casticaquimin joeque. Aman Diosichi Tenca patato, jerale Diosica tennatuminlaca tsanque tenhilaisa carichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Junsi Jesús chiquilabe itsantie: —Nulabe duque cuenta quino cajoyoe tie. Tsan josanan amana jun fiquica meráno wantaino podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tsannan Diosichi Tencari nulachica patato, ya junca jera pachunae tie. Ya tsarasica pamin joto, jera tsa jonuncari miisa carichunae tie. Ya tenca mántari patuchunae; yabe panuncari manpachunae tie. Nanni ina niyanhino jonunca nulabe jera pachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nulaca micarinato, lachi cosaca pachunae. Junni ya paca fiquica meráto, laca duque fécari sen joeque tenhilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lachi Apa Diosi jera tanuncatiya lanan tsacumin joyoe. Jun tenchi Diosichi Tenca pánato lachi cosaca pachunae tiyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús chiquilabe cuenta caquinato itsantie: —Nulari laca inale quiralaquituchunae tie. Juntonan nanni inari laca manquiralaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Junni Jesuri tsantinanunca meráto, chiquila tala itsantilatiyoe: —¿Tica pato tsantin tinancan? tilatiyoe. Tsainaleri quiratuto, nanni ina quiralaquichunae tito, ¿tica tsantin tinancan? tilatiyoe. ¿Junsi tica “Apachica jino joyoe” tin tinancan? ");
INSERT INTO cofNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tica “ina” tin? tilatiyoe. Ya tsantica fiquica entendeilaitiyoe tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chiquila tala tsantinaminnan, Jesube panhano muquinaminlae ya tica tsantinanunca miichun. Junni Jesuri junca miito, chiquilabe pato itsantie: —¿Ti cuenta quilaquinayun? tie. ¿Tsainale quiratuto, nanni inari manquirano joe tinunca tenpalaquinayun? tie. ¿Tica tsantinanunca miino muquilaquin? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Junni nulabe tsarasica pachinayoe tie: Nula duque laquichi warelaquichunae tie. Junnasari, Diosica tennatuminlari son tilatichunae. Junni nulanan laqui jominlanan ina manson tilatichunae. ");
INSERT INTO cofNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nula na quimin sonala cuwenta jolajochunae tie. Na quino órate quiya tinaminnan, duque wepanachunae tie. Junto na quetobi, duque son tichunae na quiyoeque. Junni son joto, casale quiyanunca manpansichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nulanan jun tsanquenan amana laqui jominnan, laca manquiratobi manson tilatichunae tie. Nulaca monantiya laqui mansuwano podeilaituchunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jun mate labe panhalaquituchunae tie. Juntonan nulabe tsarasica pachinayoe tie: Nula lachi Apabe ticatiya lachi mantate rocainari, cuwachunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lachi mantate carocailaitue tie. Tsanque rocaito canilaquina! tie nula duque son jolajochun. ");
INSERT INTO cofNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Junto Jesuri chiquilabe cacuenta quinato itsantie: —La nulabe cuenta quito, conparasion quito cuenta quinamanyoe tie. Man nete mantimini tsantituanae. Apa Diosica tuca paniqueyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jun mate nula lachi mantate rocailaichunae tie. Junni lari nulachi tenchi Apa Diosibe rocaiyanae titiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","La rocaitusanan, nulacanan laquirato nulachi fiquibenan meraniquichunae tie. Nulari laca laquirato quereilaie Apa Diosi ereca jun joeque. Junni jun tenchi ya nulaca laquirae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","La Apa Diosichibi nechi patato, toca jacayoe. Junsi toca purato, Apa Diosichica manlochinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jesús tsantinunca meráto, chiquila yabe penenaminlari itsanlatiyoe: —Wari amananan tuca paniquinae conparasion quituto. ");
INSERT INTO cofNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amana jera miralarayoe tilatiyoe nu jera miramin joeque. Nantari panhatuntsan joe. Junberi quereilaiyoe nu Diosi ereca jun jaca joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Junni Jesuri chiquilabe tulanto itsantie: —Amana quereilaiyoe ");
INSERT INTO cofNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","tinaminlacatiya ara cura suerelaquichunae tie. Laca purato, yaca mansujilaichunae tie. Junni fe sele pato, sujilaichunae tituntsan joe; sujilaichinae tintsan joe. Aman nula laca purato sujica josanan, la mancari itoanae tie. Lachi Apanan labe pejochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Junni labe penenaminlaca pansi chularasa tenjae. Jun tenchi nulabe tsanque cuenta quinayoe tie. Junni meralaquinade! Nulari in tote cachuminnan, padeseilaichunae tie. Tsan jotonan, son tilatina! Tote mantanaminlaca jera fe loca joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús chiquilabe tsanque cuenta quetobi, jamochi quirato, itsanque Diosibe rocaie: —Apa Diosi, óra fae tie. La nuchi Nao jonan, duque sen joeque quirawode! tie. Tsanquede! lanan nuca tsara sen joeque quirawochun. ");
INSERT INTO cofNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Apa Diosi, lachi numa mantá cuwacae yape jeralelaca mantasa. Junni jun mantachi lachi tsachilaca numatotiya sonnato polesa cariyanae tie. Jerale labe cayaisa carica jun tsachilaca numatotiya sonnato polesa cariyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nusiri tsa Diosi joe; lari Jesucristo nu ereca jun joyoe. Junni chiquilaca miraminla, yalari numatotiya sonnato polelaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Junni Apa Diosi, nu laca ticatiya quisa mantaquee. Junni lari jera quito, nuca tsara sen joeque tote quirawoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Junni amana, Apa Diosi, lacanan tsara sen joeque quirawode! tie. To caitosanan, lari nube chuto uraran tsente chumanyoe tie. Junni amananan nuchibi jun tsannan mansuwade! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Junni Apa Diosi, nu weyan weyan tsachilaca labe cayaisa carie. Yalari uyan tsachilale nechi chican loto, labe cayailaie. Junni yalaca micariyoe yape nuca miilaisa. Nuchi tsachila jominlaca labe cayaisa carie. Yalari nuchi fiquica meráto nenalarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nuchi fiquica meráto miralarae laca nuchi mantatesiri nenaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Labe nu pacaca yalabenan jera manpolaricayoe. Yala jun fiquica meráto, tsarasica miralarae tie nuchibi nechi pataca joeque. Nu ereca jun jaeque quereilaie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Junni Apa Diosi, yalachi tenchi nube rocainayoe tie. Nuca tennatuminlachi tenchi rocaitiyoe. Labe cayaisa carica junla, yalari nuchi tsachila jolajoe. Junni yalachi tenchisiri rocainayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Junni lachi tsachila jeralela nuchinan jolajoe tie. Jerale nuchi tsachilari lachinan jolajoe tie. Uyanla wari yalaca quirato, laca tenhilaichunae tsara sen joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Junni tsainaban la wari in tote itochinayoe tie. Nuchica manlachinayoe. Labe penenaminla mantimini, yalari in tote canenalarachunae tie. Apa Diosi, nu tsara sen joe. Junto yalaca cuidaina! tie. Nuri lachi mantá cuwae. Junni yalaca jun mantate cuidaina! yape yala tala man junni jolajosa. Labe nube man junni jonan, yala jun tsannan jolajosa tenjae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nuri lachi mantá cuwae. Junni lanan yalabe canenaminnan, jun mantabe yalaca cuidainamanyoe tie. La yalaca cuidainasa, laca puratulajoe. Junni Diosichi Pilabi chuteca joe yala manca yucanchica jino joeque. Junni yasiri laca puraniquee; weyanlari mancanantiya puratulajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Junni Jesús yachi Apa Diosibe carocainato itsantie: —Junnasanan amana nuchica manlono joyoe tie. Nuchica camanlotuminnan, inlabe tsanque cuenta quinayoe yape labe duque son jolajosa. ");
INSERT INTO cofNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nuchi fiquica inlachi cuwayoe. Jun tenchi nuca tennatuminla inlaca pa jolajoe. Junni ya pa junlabe lari bolon peitoyoe. Junni labe penenaminlanan, yalanan nuca tennatuminlabe bolon peitolajoe tie. Jun tenchi laca pa jominla labe penenaminlacanan pa jolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Apa Diosi, nube rocainato, lachi tsachilaca tote nechi larideque rocaitiyoe; yalaca isaisari rocainayoe yape yucan yalaca feitusa. ");
INSERT INTO cofNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Lari nuca tennatuminlabe bolon peitomin jonan, inlanan la cuwenta ya tsachilabe bolon peitolajoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Inlaca sen suwade! Nu tsarasi paca fiquibe inlachi tencaca sen suwade! tie. ¿Nuchi fiqui tsarasi paca fiqui jotun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nuri laca eree nuca tennatuminlachica. Junni la jun tsanquenan inlacanan nuca tennatuminlachica erechinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Junni Jesús yachi Apa Diosibe carocainato itsantie: —Tencachiquenan cuwapoino joyoe tie. Inlachi tenchi cuwapoino joyoe yape inlanan nuchi cuwapoilaisa. Tsarasi paca fiquica meráto, inlari nuchi cuwapoilaichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nube rocainato, inlachi tenchisiri rocaitiyoe tie. Yalaca meráto labe cayaino junlachi tenchinan rocainayoe tie ");
INSERT INTO cofNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","yape jeralela man junni jolajosa. Apa Diosi, ¿labe nube man junni jolajoyoco? tie. Junni inlanan chiquilabe man junni jonola joe tie. Tsan jonola joe yape nuca tennatuminlari quereilaisa la nu ereca jun jaca joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nuri laca duque sen joeque micuwae. Junni lanan inlaca tsarasi sen suwanayoe yape man junni jolajosa chiquila cuwenta. ");
INSERT INTO cofNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Junni la inlabe man junni joichunae tie. Nunan labe man junni jochunae. Junni inla talanan jera seque man junni jonola jochunae tie yape uyanla miilaisa. Inla man junni jonari, nuca tennatuminlanan miilaichunae la nu ereca jun jaca joeque. Nuri inlaca laquirae laca cuwenta. Junni inlanan man junni jonola joe yape uyanla junca miilaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nu, Apa Diosi, inlaca labe cayaisa carica joe tie. Junni lachi inlaca labe pechularasa tenjae tie. To caitosanan, nu laca laquirato, tsaracari mantá tan chusa carie. Junni inlaca labe pechularasa tenjae yape uraran mantá tan chuminca pequiralaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sen Apa Diosi, uyanla nuca miitucala joe. La nuca tsarasica mirayoe. Lachi tsachilanan miralarae; la nu ereca jun jaca joeque miralarae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yalaca micariyoe yape nuca miilaisa. Nantanancari camicariyanae yape nuca fécari tennalarasa. Junni yalari laquiracaalaquichunae. Nu laca laquiranan, yala tala tsanquenan laquiracaanola joe tie labe man junni jolajoto. Jesús yachi Apa Diosibe tsanque rocaie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús Apa Diosibe tsanque rocaitobi, yabe yachi tsachilabe jilaiyoe. Junsi Cedrón tinun na pi poleto, wita tsanbi wilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Junbi Jesús yachi tsachilabe duque layaimin jominue. Junni Júdanan jun postoca miraminue. Ya Judas Jesuca cuwapochun jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","5","Junto jun postoca mirato, Jesuca pa junlaca junchi tanjananue. Mantá tan patelelanan, fariséolanan soldadolaca Júdabe peerelaquinue. Tsa soldadolabe tenientelabe pejalaie. Espada, tseno tanla jalaie. Junni Jesuca cuwapomin tsachi, ya Judas tinun, yari yalabe pejominue. Junni yala jalainasa, Jesús numa miraminue niyanhichinanunca. Junto yalachica tulaichun jito, Jesús itsantie: —¿Moca neyalaquinayun? tie. Yalari itsanlatie: —Jesús Nasarénoca neyalaquinayoe latie. Jesús mantimini la joyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Junni Jesús la joyoe tinasale, yaca cabi jaminla wepanato, bene tala jinamin, queereilaie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Junni Jesús manaman itsantie: —¿Moca neyalaquinayun? tie. Junni yalari manpato, Jesús Nasarénoca neyalaquinayoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Junni Jesunan ¿la joyoe tituan? tie. Junni laca neyalaquinatori, in tsachilaca pasuwalaquitude! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Nanni matuleri Jesús Diosibe rocainato, Diosi yabe cayaisa carica junlaca cuidaiyoe tica jominhe. Mancacanantiya piyarituto jeralelaca seque cuidaiyoe tica jominhe. Junni in tsachilaca pasuwalaquitude! tinato, chiquilaca isa pato cuidainaminhe.) ");
INSERT INTO cofNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Junnasa mantimini Simón Pedro espada taminhe. Yaca laricasi, mantá tan patelechi peyunca espadachi quito, tsa nanchi punquica balequee. Ya peyun Malco mumun jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús mantimini Pédroca espadaca manpode! tie. Apa Diosi laca padeseisa mantaca jonari padeseiniiyanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Junni soldadolanan, tenientelanan, israelita polisialanan Jesuca cato ");
INSERT INTO cofNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","teleto, Anásiochica tanjilaie. Jun watate Caifás fe mantá tan patele jonan, aman Anásiori yachi sonachi apa jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ya Caifari israelita mantaminlabe matuleri paca jominue Jesuca totesa carichun yape manca tsachi jeralelachi tenchi puyasa. ");
INSERT INTO cofNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Junni aman paluca Jesuchi tsachila Jesuca benechi jinaminlayoe labe Simón Pédrobe. La mantá tan pateleca quiramin joto selabi winiiyoe. Jesuca tanwilainasa lanan pewiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro mantimini selabi wituto, tamolan fecáriri jito méraminhe sela dechi. Junni la mantá tan pateleca quiramin joto, tamolanca manjito, tamolan cuidaimin sonabe cuenta quito, Pédrocanan pocasa cariyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Junni ya tamolan cuidaimin sona Pédrobe cuenta quito itsantie: —¿Nunan ya tsachibe penenamin itoyun? tie. Pédronan itsantie: —Te, yabe penenatumanyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Junni peyunlabe polisialabe jidá tinaminlae. Junto carbonca nin quito, nin awinta wiruito nin lobainaminlae. Pédronan yalabe pewiruito nin pelobainaminhe. ");
INSERT INTO cofNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Junnasa mantá tan pateleri Jesube panhanaminue. Mola yabe penenaminla jonunca, ti micarimin jonunca panhanaminue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Junni Jesús beconan pato, itsantinue: —Nosa micaritiyoe tie. Jeralelaca micarinamanyoe tie. ¿Diosichi yabi o Diosichi fiqui miinun yabi jerale israelítala layaiminla jotun? tie. Aman junbiri micarinamanyoe tie yape piyanlela meralaquisa. ");
INSERT INTO cofNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Junni ti quichun labe panhanayun? tie. Lachi fiquica meráminlabe panhade! tie. Yala laca miralarae tie yalabe niyaque micarinanunca. ");
INSERT INTO cofNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Junni Jesús tsantinaminca paito, polisia manca junte wiruramin joto, yaca tedechi quee. Junni tedechi quesi, mantá tan patelebe tsanque patuna! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesuri ya polisiabe itsantinue: —La niyaque seitonque pánari, nuri paniquede! Seitonque paca itonari, ¿ti quichun laca quiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Junni Jesús tsantinasa ya Anásiori Jesuca mantelesa carito, Caifás tinun mantá tan patelechica erenue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Junni Simón Pedro nin lobaito pewirurasa, tsachila yabe panhato itsanlatie: —¿Nunan Jesube penenamin jomin itoyun? latie. Pédrori te, lari yabe penenamin itoyoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Junni junte patelechi peyun manca peraminhe. Ya peyunni punqui balequica junchi familia jominue. Aman ya peyunni Pédroca pato, nucanan Jesuca cananunte la quirayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ya tsantinan, Pédrori te, lari itomanyoe tie. Junni tsantinasaleri walpa apaca pae. ");
INSERT INTO cofNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Junni quepenan israelita mantaminla Jesuca cato Pilátochica tanjilaie. Ya romano tsachi Jerusalenbi chuminlaca mantamin jominue. Junni Jesuca tanjito, Caifáchibi nechi jito Pilátochi mantanun yaca jilaie. Juntonan yala tanjiminlari jun yabi wilaitue. Casa ma fiesta ano fino podeichun, israelita itonlachi yabi wituntsan jominue. Israelita itonlachi yabi fiesta mate wiminla fiesta ano pefituntsan joe timin jominlanue Diosichi cale culpa ilaiichunaeque. ");
INSERT INTO cofNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jun tenchi miya Pilato jun yabi nechi lato, yalabe panhae: —¿In tsachica ti tenchi culpa quilaquinayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yala mantimini beco pato, Jesús culpa itomanpari, nuchica tanjatuno jominla joinhie latie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátori manpato, nula talari quinilaquede! tie. Nulachi mite juisio quinilaquede! tie. Israelítalari wari itsanlatie: —Podeilaitiyoe latie. Chiquilachi mite yaca totentsan joe. Tsan josanan nula románolari chiquilachi mantá cuwalaquitue seitonlaca totesa. Jun tenchi nuchica tanjalaiyoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Israelita mantaminla tsanlatinato, Jesús paca jun fiquica se larinaminlae. Jesús corosibi puyano joyoeque paca jominue. Tsannan israelítalari seitonlaca toteto, corosibi totetumin jominlanue; románolari corosibi totemin jominlanue. Junni israelita mantaminla romano miyabe tsanque totedeque rocainato, Jesuchi fiquica se larinaminlae.) ");
INSERT INTO cofNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aman junni Pilátori mantanun tamochi manwito, Jesuca oticato, itsanque panhanue: —¿Nu israelítalachi miya joyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Junni Jesuri tulanto, ¿Nusiri laca tsantinayun, o uyanlanan laca miya joe latinun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aman Pilátori itsantinue: —La israelita itoyoe tinue. Nuchi paisanolabe mantá tan patelelabe nuca cuwapolaquee. ¿Niyanhiyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Junni Jesús beconan pato, itsantinue: —La in tote miya itoyoe. In tote miya jomanpari, lachi tsachila quicaano jominla jonhoe tinue yape Judas laca israelítalachi cuwapotusa. Tsanni in tote miya itoyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Junni Pilato jun fiquica meráto, itsantinue: —¿Junni miya jono patico? tinue. Junni Jesuri itsantinue: —Nu tsa tie tinue. La miya joyoe. Tsarasica pamin joyoe tinue. Tsarasica pachun naicayoe tinue. Jun tenchi toca patacayoe tinue. Tsarasica pánanunca meráminlari lachi fiquica meralaquichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Junni Pilato Jesús tsanticaca meráto, ¿ti fiqui tsarasica jono jonhoncan? tinue. Aman Pilato Jesube tsantito, israelítalachica manlato itsantie: —Laberi Jesús natiya culpa itoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Junni nula meralaqude! tie. Nulachi mite doramin mancaca casa ma fiesta mate manlarino joyoe. Junni nulari israelítala joto, ¿nulachi miyaca manlarisa munaralarayun? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Junni jun fiquica meráto, israelítalari sonba pato, itsanlatie: —Te, Jesuca manlarituna! Barrabaca manlaride! latie. Ya Barrabás mantimini tarinmin jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsanlatinan, Pilato Jesuca asotaquisa carie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asotaquimin soldadolari Jesuca pamiyato quiralaquinue. Po silica torinca quito, yachi misubi polaquinue yaca miyae tito. Yaca miya ponun camisaca pocarito, ");
INSERT INTO cofNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","miyaca cuwenta Biba tilatinue. Israelítalachi miyaca biba quilaquisa! tilatinue. Junni biba quinatonan, tedechi quilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Junni Pilato manlato, israelítalabe itsantie: —Quiralaquede! Lachi tencari Jesús natiya culpa itoe tie. Junca miilaisa, yaca nulachica manlarichinayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tsantinunsi Jesús lae. Po silica torinca quito misubi poca jun, miya ponun camisaca pocarica jun, lae. Junni Pilato yaca quiralaquede! Ina joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Junni aman patelelabe polisialabe Jesuca quirato, sonba pato, itsanlatie: —Corosibi totesa caride! Corosibi totesa caride! tilatie. Pilátori itsanque pae: —Lari totesa caritiyoe tie. Jesús lachi tencari culpa itoe tie. Junni yaca nulachi totesa carino muquilaquinari, nula tala yaca cato totesa carilaquede! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Junni Pilato tsantinunsi, israelítala itsanlatie: —Chiquila tala mantá joe. Jun mantá tenchi totaino joe latie ya Diosichi Nao joyoe tinun tenchi. ");
INSERT INTO cofNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Junni Pilato mantimini jun fiquica meráto, fécari jeleie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Junni mantanun yabi Jesuca mantanwito, ¿Nunchi nechi joyun? tinue. Tsannan Jesús patunue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilátori itsantinue: —¿Labe cuenta quitiyun? tinue. La nuca manlarinonan, totesa carinonan mantá tayoe tinue. ¿Tsanque mantá tanunca miitoyun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Junni Jesús itsantinue: —Diosi nuchi mantá cuwaca itomanpari, laca natiya mantano itono jomin jonhoe tinue. Junni laca nuchi cuwapominlari fe culpa talarae tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesús tsantinan, Pilato yaca manlarichique tenfenaminhe. Tsan josanan, israelítala sonba pato itsanlatie: —Jesuri Miya joyoe tito, nulaca mantamin miyachi contra jochunae latie. Junni nu Jesuca manlaritori, nunan nuchi miyachi contra pejochunae latie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato jun fiquica meráto, Jesuca tanjato, mantato chudinunbi chudie. (Jun chudinun Cabata tinun postote chuminue. Israelítalachi fiquichi su layuque tsoreca junca “cabata” timinlayoe.) ");
INSERT INTO cofNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Junni casá ma quisinchi jominhe yotu tsansite. Junni Pilato junbi chudito, israelítalabe pato itsantie: —Nen, ina nulachi miya joe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Junni israelítalari jun fiquica merasi, itsanlatie: —Yaca tanjito, corosibi totesa caride! latie. Pilato mantimini lucarito tulanto, ¿Nulachi miyaca corosibi totentsan jun? tie. Junni aman mantá tan patelelanan pato itsanlatie: —Nula románolachinan miya chiquilachinan miya joe; uyan miya itolajoyoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsantinunsi Jesuca yalachi cuwapoe yape corosibi totesa carilaquisa. Junni soldadola Jesuca corosibi totesa caribi tanjilaie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yanan yachi corosica nanato jie. Junni Misu Chide tinun postoca tanjilaie. (Aman israelítalachi fiquichi misu chideca “cólcota” timin jominlayoe.) ");
INSERT INTO cofNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Junbi yaca corosibi wilocarilaquee yape puyasa. Junsi paluca tsachilacanan petotelaquee manca man nanchi, manca man nanchi. Jesús quitsale jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Junni Pilato pila quito, Jesuchi misu jamole chutesa carie. IN JESUS NASARENO JOE; ISRAELITALACHI MIYA JOE que pila chuteca jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jun pila israelítalachi fiquichi, románolachi fiquichi, griégolachi fiquichi chuteca jominue. Junni totenun posto pueblo quelole jonan, layan israelítala ya pilaca quiralaquee. ");
INSERT INTO cofNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Junto mantá tan patelelanan jun pilaca quirato, Pilátochica jito, itsanlatinue: —Ya pilaca munaralaratiyoe latinue. Jesuca israelítalachi miya joeque pila quituntsan jominue latie. Israelítalachi miya joyoe ticaequeri pila quintsan jominue latinue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Junni Pilátori beco pato, itsantinue: —La pila chutecaca natiya canbiyaquitiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Junni ya soldadola Jesuca corosibi clabochi totepotobi, yachi panu tsanlaca calaquee. Junpaluca soldadola ito, ya panu tsanca quitsaalaquee. Jesuchi camisa mantimini oróca itominue. Manqui jun siteca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Junni camisaca chiletuchique apostaito sorteaito miisa! latie mo ya camisa quijunle cano jonunca. Aman matu mate Diosichi Pilabi junca paca jominue tsanquinola jonunca. Itsanque chuteca jominue: Yachi panu tsanca quitsaato calaquichunaeque chuteca jominue. Mo cano jonunca miichun apostaito sorteaito calaquichunaeque chuteca jominue. Junni Diosichi Pilabi tsanque chuteca josa, ya jun tsanquenan patinue soldadola sorteaito canan. ");
INSERT INTO cofNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Junni tsan josanan sonalari corosi wiruranun posto quelote raminlae. Jesuchi ayan, Jesuchi ayanchi miyan, María Magdalena, Cleopachi sona, yala junte peraminlae. Aman ya Cleopachi sonanan María tinun jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Junsi lanan Jesús duque laquiranun joto, junte peramanyoe. Junni Jesús yachi ayancanan, lacanan laquirato quirato, Ayan tie. Quirade! In tsachiri nuchi nao cuwenta jochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Junsi aman labenan pato, quirade! tie. In sonari nuchi ayan cuwenta jochunae tie. Junni junte nechi Jesuchi ayanca lachi yabi pechusa carito cuidaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Junni Jesús numa tenhinue titiya jera quino jonunca jerayoeque. Junto Diosichi Pilabi chuteca jonun fiquica manpato, pi muquee tie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aman jun quelote nida máncabi pele bino pominhe. Junni pi muquee tinan, cuwa tsanbi ya pele binoca ata suwato, isopo tinun chidebi chuteto, Jesuchi fiquiforole tilicarilaquee yape yaca chusa. ");
INSERT INTO cofNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Junni yaca chuquesi, jerayoe tisi, misu bontoito tenca mánta puyae. ");
INSERT INTO cofNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Junni junnasa israelita mantaminlari wepananaminlanue corosibi puyano junla wewe puyalaisa. Ayuna nanchi casá ma jominue. Fécari respetainun jasaino ma jominue. Jun tenchi moora puyalaisa tenjalaquee tilatinue moora manpatarilaquisa yape jun jasaino mate corosibi itolajosa. Jun tenchi israelita mantaminlari Pilátobe rocailainue yape corosibi puyano junlachi nedeca colesa carisa. Nedeca colesa caride! latinue yape wewe puyalaisa, wewe corosibi nechi manpatarino podeilaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Junni soldadolari jato, Jesube parejo pepuyano jun mancachi nedeca colelaquee. Junsi mancachi nedecaman coleto, ");
INSERT INTO cofNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","junto aman Jesúchicaman jalaie yachi nedecaman colebi. Junni Jesúchica jato quiranari, Jesús numa puyaca jominue. Junto yachi nedeca natiya colelaquitue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tsan josanan soldado manca yaca quilinchile lansachi tilequee. Lansachi tilequinan, asanbe pibe lae. ");
INSERT INTO cofNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","La Juanni junca lachi cacachinan jera quirato, junca pila chutenayoe. Tsarasica pánayoe. Lari mirayoe tsarasica jonunca. Junto nulabenan cuenta manpolarinayoe yape nulanan in pilaca quirato quereilaisa. ");
INSERT INTO cofNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Junca matute Diosichi Pilabinan pila chuteca jominue. Itsanque chuteca joe: Yachi nede chidecari colelaquituchunaeque chuteca joe. Man postotenan man fiquinan chuteca joe. Itsanque joe: Yaca tileto quiralaquichunaeque chuteca joe. Junni tsanque chuteca josa, jun tsanquenan manpatie. ");
INSERT INTO cofNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesuca tsanlaquinunbi, Joseri Pilátochica jinue. Ya José Arimatea pueblobi nechi joto, Jesuchi tsachi pejominue. Juntonan israelita mantaminlaca jelechi, nosa Jesube penenamin jominue. Aman yari Pilátochica jito, Jesús puyacaca cuwasa rocainue. Pilátori manpatariniquede! tinan, Jesús puyacaca manpatarito tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodémonan pejinue. Yari casaleri Jesuca quepenteri quirabi jimin Nicodemo jominue. Junni yari man quintali tsansi puban lucu tanjanue. Ya puban lucu mira tinunbe áloe tinunbe palaca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Junto aman Jesús puyacaca tsanpachi lapilaquinue puban lucucanan pepoto. Israelítalachi mite puyacalaca menachun tsanquiminlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Junni Jesuca totenun quelote wita tsan jominue. Junni jun wita tsanbi menachun foro jominue bobeda cuwenta. Ya foro casan quica jun jonan, junbi mocanantiya catsoreca itominlanue. ");
INSERT INTO cofNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Junni ayuna nanchi jasaino ma jonan, Nicodémola titiya quino podeituntsan ma jono jominue. Junto jola itoto, jun foro quelote jonan, Jesús puyacaca junbi tsorelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Junni tominco ma tseinasa, María Magdalénala Jesús menaranunca manquirabi jilainue. Junbi féto quiranari, foro suchi docarica jun do itominue. Tsan jonunca quirato, ");
INSERT INTO cofNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","necanan mansujilainue. Junnasa lari Jesús laquiranun joto, Pédrobe uyan postote chuminlayoe. Junni María Magdalénala chiquilachica sujato, Miya Jesús puyaca junca cato tanjicala joe tilatie. Menaranun forobi nechi larito, nunchi tanjicala jonunca miitolajoyoe latie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Junni Pédrobe labe yabi nechi loto, menaranun foroca sujilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Palunan sujito, lari Pédroca caquenan feyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Caquenan féto, menaranun forochi bontoito quirapoyoe. Quirapoto, lapica jonun tsanpa tsonunca quiratonan, menaranun forochi witiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Junni Simón Pédrori benechi fato, yari menaranun forochi wito tsanpaca quirae. ");
INSERT INTO cofNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Junni misubi ponun tsanpa lapica jonun tsanpabe itominue; tiwica junni chicanle tsominue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","Junni lanan menaranun forochi bene pewito, ticatiya jera pequirayoe. Jun fecári Diosichi Pila quicaca miica itominlayoe Jesús puyaca jotonan mansonhino jonunca. Junni menaranun forochi ticatiya jera quiratobi, junca quereilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Junni menaranun forobi tsanque quiratobi manjilaiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Junni aman María Magdalénari menaranun foroca manjito, wareto manwiruraminue. Warenaminnan, bontoito forochi quiraponue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Junbi quiraponato, paluca anjelilaca quiranue fibaquin camisa punlaca. Jesús puyaca tsonun jominte chularaminue manca misule, manca nedele. ");
INSERT INTO cofNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Junni anjelila ya sonaca quirato, ¿Niya jonan warenayun? tilatie. María Magdalénari beconan pato, chiquilachi miya puyaca junca tarinlaquinue. Nunchi tanjica jonunca miitolajoyoe tinue. Jun tenchi warenayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsantisi, lecapoleto quiranari, Jesuri junte wiruraminue. Tsan josanan Jesús joeque mantenhitunue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Junni Jesunan itsantinue: —¿Niya jonan warenayun? tinue. ¿Moca neyanayun? tinue. Junni María Magdalena ya fiquica meráto, wita tsan cuidaimin jonhoeque tenhito, nuri Jesuca uyanchi tanjica jotori, tile tatotiya chiquebe paniquede! tinue yaca mancábi jichun. ");
INSERT INTO cofNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Junni Jesús yaca María tinue. Maríari ya fiquica meráto, lecapoleto, israelítalachi fiquichi pato, Raboni tinue. (Jun fiquichi “raboni” tito, micariminlaca tsantinun joe.) ");
INSERT INTO cofNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Junni Jesuri yabe itsantinue: —Lachi Apa Diosichica calotuminca laca talatude! tinue. Lachi acolachica, soquilachica jito, yalabe cuenta polaride! tinue. Yalachinan, lachinan Apa Diosichica manlochinayoe tie tina! tinue. ");
INSERT INTO cofNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Junni María Magdalénari Jesube penenaminlachica manjato, Miya Jesuca manquirayoe tie. Junni Jesuca manquiramin sona chiquilabe jera cuenta polarie Jesús tsantica fiquica meráto. ");
INSERT INTO cofNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jun mate quebi inasa Jesuchi tsachila layaito chuminlayoe. Tominco ma jominue. Israelita mantaminlaca jelechi tamo doito chuminlayoe. Junni tsanque chularasanan, Jesús moora chiquilachibi quiraie. Quiraisi, itsantie: —Pansi chularana! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsantisi yachi tedeca, quilinchica quirawoe. Aman junni chiquilari Miya Jesuca manquirato, son tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Junni Jesús manaman tsantito, pansi chularana! tie. Apa Diosi laca ereca jonun cuwenta, nulacanan erenayoe tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tsantito, chiquilaca jasá ereto, Diosichi Tencaca calaquina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nula molacatiya jutsa perdonainari, yalachi jutsaca perdonaica jochunae tie. Molacatiya jutsa perdonaitunari, yalachi jutsaca caperdonaica itochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Junni Jesuri chiquilabe manquirainasa, Tomás itominhe. Ya Tomás Jesuchi chunca paluca tsachila jonunbi manca pejominhe. Yachi tensaato mumun Dídimo tinun jominhe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Junni Tomás manjanunsi, chiquilari yabe cuenta quito, Miya Jesuca manquiralaquiyoe latiyoe. Ya mantimini quereitiyoe tie. Tedebi clabo wicaca quiratutori, clabo foroca temisuchi taquiratutori, quilinchile lansa wica foroca tedechi taquiratutori, natiya quereituanae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Junni ochu ma poletobi, Jesuchi tsachila talari tamochi manan manlayaica jominlayoe. Aman Tomás junte pejominhe. Junni tamo dorasanan, Jesús chiquilachibi manan manquiraie. Jesús chiquila junte chuminlabe pansi chularana! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Junto Tomabe pato, Jesús itsantie: —Nuchi temisuchi inte tilito quirade! tie. Nuchi tedechi quilinchile lansa wica jun foroca taquirade! tie. Nu quereitumin itona! tie. Quereimin jona! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Junni Jesús tsantinunsiri, Tomari manpato, lachi Miya, lachi Diosi tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Junni Jesús itsantie: —Nuri laca quirato quereie tie. Laca quiratuminnan quereiminlari tsaracari duque son jolajochunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesuri ticatiya seque wepanato quirantsancari duque quimin jominhe yachi tsachila quiralaquinasa. Tsan josanan jera tsanquicacari pila quitiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Weyancari pila quiyoe yape nula in pilaca quirato Jesuca quereilaisa. Jesús Diosi wenteca Cristo tinun joe. Ya Apa Diosichi Nao joe. Junca quereiminlari yachi mantate yabe numatotiya sonnato polelaiichunae. Junni nulanan junca jera quereilaisa, in pilaca quinayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Junni aman Jesuri man nete yachi tsachilabe manquiraie Tiberia tinun wa pipilute. Itsanque quiraie: ");
INSERT INTO cofNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yachi tsachila weyanla layaica jominlayoe. Simón Pedro, Dídimo tinun Tomás, Nataniel, Zebedéochi naola paluca, uyan tsachila paluca jominlayoe. Ya Nataniel Canabi chumin jominhe Galilea tobi. ");
INSERT INTO cofNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Junto jeralela layaito chuminnan, Simón Pédrori watsa cabi jichinayoe tie. Junni jeralela pejilaisa! tilatiyoe. Tsantisi canoabi wito jilaiyoe. Junsi man quepen watsa cachique tenfelaiyoe. Tsanhilainatonan, manca watsanantiya calaquitiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Junni tseinasa Jesuri pi fiquile wiruranue. Chiquila mantimini Jesús joeque tenhilaitiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Junni chiquilabe otito, Amicola, ¿watsa calaquinayun? tie. Junni chiquilari beco pato, Te, calaquitiyoe tilatiyoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Junni Jesús manpato, Dadaca canoa tsa nan tala quepolaquede! tie. Tsantori watsa calaquichunae tie. Jun tsantinunca meráto, dadaca tsa nan tala quepolaquiyoe. Junni mancanato quiranari, duque watsa ie. Duque watsa ica jonan, canoabi manpocano podeilaitiyoe jadochi. ");
INSERT INTO cofNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","La Jesús laquiranun junte pejomanyoe. Junto duque watsa icaca quirato, Pédrobe pato, Miya Jesús jonhoda tiyoe. Pédrori junca meráto, camisa laricaca we manpoto, pipilubi queereito, Jesúchica jie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","La mantimini canoabi puraito canoachi jiyoe. Watsa pun dadaca muricade tanjilaiyoe. Pi dele nechi nuwiri itominlayoe; patsa metro tsansiteri jominlayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Junni pi fiquile canoa nancarito, loto quiranari, nin carica jonue. Carbonca nin quito, jun ninbi watsa asuwanaminue. Bibunan junte jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Junni Jesús chiquilaca pato, Watsa tsaina caya junca nasi tanjade! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Junni Simón Pedro canoabi manwito, dadaca pi fiqui fecári muricade tanjae. Jun dadabi patsa mante chunca pemanca wa watsa ica jominue. Tsansi duque watsa potonan, dada yucapiyatue. ");
INSERT INTO cofNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Junni Jesuri chiquilaca ano fibi jalaide! tie. Chiquilari nasi jeleraminlayoe mo tsachiyunque panhano. Juntonan miraminlayoe Miya Jesús joeque. ");
INSERT INTO cofNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús jato, bibube watsabe cato, chiquilachi cuwae. ");
INSERT INTO cofNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(Jesús puyaca joto mansonhitobi yachi tsachilabe palu ne quiraica jominhe. Junto in quiraicabe peman ne quiraie.) ");
INSERT INTO cofNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Junni ano fitobi, Jesús Simón Pédrobe cuenta quee. Jesuri itsantie: —Simón, Jonachi nao, ¿nuri laca laquirato, inlaca fe laquirayun? tie. Junni Pédrori janhan tie. Miya, nu mirae tie nuca laquiraeque. Junni Jesús itsantie: —Laca laquiratori, lachi opisa na cuwenta junlaca cuidaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Junsi Jesús jun tsanquenan manan manpanhato, Simón, Jonachi nao, ¿laca laquirayun? tie. Junni Pedro janhan tie. Miya, nu mirae tie nuca laquiraeque. Junni Jesús Pédroca manpato, laca laquiratori, lachi opisa cuwenta junlaca cuidaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Junsi Jesús jun tsanquenan manpanhato, Simón, Jonachi nao, ¿laca laquirayun? tie. Pedro mantimini laquiie peman ne tsanquesiri panhanan. Junto Miya tie. Nu jera mirae tie. La nuca laquiraeque mirae tie. Tsantinan, Jesús laca laquiratori, lachi opisa cuwenta junlaca cuidaina! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Junni Jesús Pédrobe man fiquinan capae. Itsantie: —Nube tsarasica pachinayoe tie: Nu moso jono mate nuchi tenca munateri nenato, nu nenachi tinun minuca nenamin jominue uyanlabe mantaituto. Tsannan unica inunbi, uyan quiraque jochunae. Uyanlari yalachi tenca munateri nuca tedeca tusisa carito tebanalaquichunae. Junsi nu nenatuchi tinun minuca nenasa carilaquichunae tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Junni Jesús tsantisi, Pédroca labe penenana! tie. Aman Jesús Pédrobe tsantinato, Pedro niyaque puyano jonunca pánaminue. Junni duque wata poletobi, tsachila Pedro niya quiraque totainunca miito, Diosica duque seque palaquinue. ");
INSERT INTO cofNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Junni Jesús Pédrobe cuenta quinasanan, Pedro lecapoleto quirato, manca Jesube penenaminca benele janaminca quirae. Jesús duque laquiranun tsachi jominhe. Nanni matuleri fiesta ano finato, ya tsachi Jesuchi fe quelole chuto, yabe panhaca jominhe mo yaca cuwapono jonunca. ");
INSERT INTO cofNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Junni Pédrori jun tsachi benele janaminca quirato, Jesube itsantie: —Miya, ¿ya tsachiri niyanhichunan? tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús mantimini Pédrobe manpato, itsantie: —Yaca la manpatano fecári casonnasa tenjanari, nuchi yape josa! tie. Nuri labe penenana! tie. ");
INSERT INTO cofNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesús tsantica josa, yachi tsachilari epele tenca cato, cuenta polarilaquinue. Jun tsachi numatotiya puyatuchunaeque cuenta polarilaquinue. Ya fiquica piyanlete meralaquinue Jesuchi tsachila talari. Junni tsan josanan, Jesús ya tsachica numatotiya puyatuchunaeque paca itominue. Jesús manpatano fecári casonnasa tenjanari, Pédrochi yape josaqueri paca jominue. ");
INSERT INTO cofNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Junni tsanque cuenta polarinun tsachi Juan jomanyoe. La Jesucrístoca jera cuenta quito, in pila jera chutenayoe. Junni la in fiqui chuteca jun tsarasi joe. Tsarasi joeque miralarayoe. ");
INSERT INTO cofNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tsan jotonan, Jesús jera quicaca pila quitiyoe. Weyan weyancari pila quiyoe. Jesús jera quicaca pila jera quica jomanpari, duque animali pila jono jomin jonhoe. Jun pilaquidoca jera dunan, jerale totenan tilenantiya duno itono jomin jonhoe. Tsanqueri joe.");
INSERT INTO cofNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Amico Teófilo, in pilaca nuchi erechun quinayoe. Manqui pila numa quito nuchi erecayoe. Jun casale quica jun pilabi Jesuca in tote nenaminca chutecayoe. Diosichi toca manlono ma fecári ticatiya jera quito nenamin jonunca, ticatiya jera micarica jonunca, jera chutecayoe. Aman junni Jesús weyan tsachilaca wenteca jominue yape yachi mantá tanla josa. Jesús jamochi camanlotuminnan, yalaca Diosichi Tencachi sonbabe jera mantanue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Junni Jesús puyato mansonhitobi, yalabe manquiraidede nenaminue. Duque ticatiya quinue yape tsa mansonhinueque tenhilaisa. Diosi mantananun tsachi bolon niyan jonola jonunca jera micarinaminue. Junni junpalu chunca ma fecári Jesús yalabe tsantin nenaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Junto Jesús yalabe canenaminnan, itsanque mantanue: —Nula Jerusalén pueblobi nechi lotuto cameralarana! tinue. Lachi Apa Diosi pato, nulachica ticato ereyanae ticae tinue. Lari nulabe junca numa jera cuenta polaricayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Aman Mumunmin Juanbe penenaminlari pibiri mumunhilainue. Nula mantimini nanni ina Diosichi Tencachi mumunhilaichunae tinue. Yachi Tencaca erechunae tinue yape nulachibi wisa. Junni yaca ereno fecári Jerusalenbi cameralarana! tinue. Jesús yachi tsachilabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Junni Jesube penenaminla palaque tenca cato, yabe itsanque panhalaquinue: —Miya, ¿chiquilari israelítala jolajoyoco? ¿Aman nu numasi bare to románolachi mantaca manjosolechun? tilatinue yape chiquilachi tobi mantatulajosa. ¿Amana? ");
INSERT INTO cofNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jun fiquica meráto, Jesús beconan itsantinue: —Apa Diosiri junca mirae tinue. Nulari junca camiituntsan jochunae tinue numasi tsanhino jonunca. Apa Diosiri pato, junca yasiri mantano joyoe ticae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aman nula mantimini laca cuenta polarinola joe. Diosichi Tenca nulachica patatobi, nulaca duque sonba tenca suwachunae tinue. Junni jerale tote laca cuenta polaridede nenalarana! tinue. Jerusalén pueblobinan, in Judea tobinan, ja Samaria tobinan, fe nuwiri tobinan cuenta polaridede nenalarana! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Junni Jesús tsantinunsi, Diosiri yaca jamochi manlaricanue. Quiranasanan loniinue. Aman lonaminnan, lonaminnan, numa poyobi doinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Junni Jesuri jamochi doicabinan, yabe penenaminlari jamochi caquiranaminlanue. Junni yalari quirato wirurasa quiranari, paluca tsachila yalabe quirainilainue. Ya tsachilari tsaracari fibaquin camisa pun wirurato ");
INSERT INTO cofNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","itsantilatinue: —Galilea tsachila, ¿ti quichun jamochi caquiralaquinayun? Ya Jesús nulachile nechi quirasa loto, Diosichi toca numa locae tinue. Junni aman tsanque loto, jun tsanquenan manpatachunae tinue. Ya anjelila Jesube penenaminlabe tsanlatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Junni Jesuchi tsachilari Olibo tinun dubi nechi manpatato, man quilon tsansica manjato, Jerusalén pueblobi manwilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Junni aman Jerusalenbi manfato, yala chunun tamochinan manwilainue jamobi tamochi. Chunca manca Crístochi mantá tanla junte chuminlanue Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo, Simón Zelote, Judas. Aman manca Jacobo Alféochi nao jominue. Aman Judas Jacóbochi aco jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Junni yala piyanlela jun parejo tenca cato, Diosibe rocaito chuminlanue. Sonalanan rocaichun pelayaimin jominlanue Jesuchi ayan Maríabe, Jesuchi acolabe. ");
INSERT INTO cofNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Junni jun malate Jesucrístochi tsachila duque layaica jominlanue patsa palu chunca tsansi. Tsanque layaito chuminlabe, Pédrori quitsabi wiruito itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","—Acola, soquila, Judas Iscariote chiquilabe peayudaimin jominhe tinue. Chiquilabe peaconpanaimin jominhe. Tsan jominnan, ya Júdari Jesuca cuwaponue. Jesuca cachi timinlachi cuwaponue. Aman Diosichi Pilabi yaca chuteca jominue Jesuca tsanque osichunaeque. Matu to David Salmo pila quinasanan, Diosichi Tencari yaca pila chutesa carinue tinue. Itsanque jominue: ");
INSERT INTO cofNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aman Judas Iscariote Jesuca osito, cala canue. Junni jun seiton calachi to canue. Junni jun tobi palo tala darapatito, pecolo sipito pesili fofoduiniinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Junni Jerusalenbi chuminla jeralela junca meráto, ya toca “Asan To” tilatinue. (Aman israelítalachi fiquichi “asan to” tito “aséldama” tinun jominue.) ");
INSERT INTO cofNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Aman Salmo pilabi itsanque chuteca joe: Yachi to yape epe jonijosa! tinue. Monantiya junbi chuno itochunae tinue. Diosichi Pilabi tsanque chuteca josa, jun tsanquenan patinue. Judas Iscariótechi to epe inue. Junni Pedro manpato itsantinue: —Junsi Diosichi matu pilabi man fiquinan cajoe tinue Salmo tinun pilabi. Junbi Judas Iscarióteca itsanque chuteca joe tinue: Yachi mantaca josoleto, uyanchi mancuwano joeque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Junni tsanquenan tsachi mancaca mantá tan suwantsan joe tinue yape Júdachi mantaca mancasa. Mantá petano jun tsachi chiquilabe jera peaconpanaimin jomin jochunae tinue. Miya Jesús chiquilabe penenasanan yanan parejo penenamin jomin jochunae. Juan mumunnanunle nechi Jesús Diosichi toca manlono fecári chiquilabe parejo penenamin jomin tsachi jochunae tinue. Junni ya tsachi chiquilabe Jesuca cuenta pepolarimin jochunae tinue puyato mansonhinueque. ");
INSERT INTO cofNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Junni Pedro tsantitobi, yala tenpato, paluca tsachilaca wentelaquinue mancacari mantá tan suwachun. Aman manca José Barsabás tinun jominue. Manca Matías jominue. Aman Joseca Justo tensaato mumun tinun jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Junni junbi layaica junlari Diosibe rocaito itsantilatinue: —Miya Diosi, nu jeralelachi tencaca miramin joe. ¿Junni in palucale nechi moca mantá tan suwantsan jun? tilatinue. Judas Iscariote jutsa quito, ya mantaca jera piyarinue ya jino jonun minu jichun. Junni Miya Diosi, nu chiquilachi micuwade! ¿Nu moca wentenayun? yape Crístochi mantá tan pejosa. ");
INSERT INTO cofNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Junni Diosibe tsanque rocaitobi, palucachi mumunca pila chutelaquinue. Aman junca jera palacarito, manca mumunca larilaquinue mochi mumun lonunca miichun. Junni Matíachi mumun lonue. Junni Matíacanan Crístochi mantá tan pejoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Junni aman Pentecostés fiesta ma fanan, Jesube penenaminla jeralela layaito man tencari cato chuminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jun quiranari jamochi nechi sonban wu quinasa tsanni mera jominue. Jun yabi jeralete mera jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Junni jun quiranari nin lolonca tsanni patanue. Junsi ya nin lolonca tsan jera arajito, tsachilachi butuchi jera chudinue mancachibi mancachibi. ");
INSERT INTO cofNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tsanhinasa Diosichi Tenca patsa yalachica patato, jeralelachibi wito jera mantanue. Junsi Diosichi Tenca yalaca merátunun fiquichi jera cuenta quisa carinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aman junni jun fiesta mate Jerusalenbi duque israelítala jato nenaminlanue. Diosica tenca camin israelítala junte penenaminlanue piyanle tobi nechi jato. ");
INSERT INTO cofNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Junni yalari uyan fiquichi uyan fiquichi pánanunca meráto, quirachun layailainue. Layaito quiranari, jeralela tencachique fiquichi pánaminca meranilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Junni ¿Ti jonhoncan? tito wepananato itsanlatinue: —¿Inte cuenta quiminla jeralela Galilea to israelítala jolajotuncan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tsanla jotori, ¿niyaito chiquilachi to fiquichi palaquinan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partia tobi chuminla Partia to fiquica meralaquinayoe latinue. Media tobi chuminlari Media to fiquica meralaquinayoe latinue. Jun tsanquenan Elam tobi chuminla, Mesopotamia tobi chuminla, Judea tobi chuminla, Capadocia tobi, Ponto tobi, Asia tobi, ");
INSERT INTO cofNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia tobi, Panfilia tobi, Egipto tobi, Cirene quelote Africa tobi chuminla jeralela yalachi fiquichi pánaminca meralaquinayoe latinue. Junsi uyanlari Roma pueblobi nechinan jaca jolajoe latinue weyanlari tsa israelítala, weyanla israelítalabe peito Diosica tenca pecaminla. ");
INSERT INTO cofNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Junsi Creta tobi nechinan, Arabia tobi nechinan jaca jolajoe latinue. Junni jerale bare tobi nechi jaminlatiya Jesucrístochi mantá tanla pánaminlaca meráto wepanalainue. Diosi jera seque quica jonunca chiquila jerale tolachi fiquichi polarilaquinae tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jeralela junca niyaquenantiya tenca cano podeituto, duque wepanalainue. Niyaito tsanque palaquin quinanque beco beco panhalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aman weyanla mantimini cacarito, winanni jolajoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Junni chunca paluca Jesucrístochi mantá tanla wiruilaito, Pédrori sonba pato, layaica jun tsachilabe itsantinue: —Judea tobi chuminla, jerale Jerusalenca jaca junla, nulabe cuenta quino muquee. Niya josatiya la pánaminca seque meralaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Weyanlari chiquilaca winan jolajoe tilatinae. Te, natiya winan itolajoyoe. Quepenanan cajoe. Nuebe tsansiri joe. Monantiya in órate winan caitulajochunae. ");
INSERT INTO cofNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Inni Diosichi cosa joe. Joel matu tote Diosichi mantate pamin joto, itsan ichunaeque pato, itsanque pila chutenue tinue: ");
INSERT INTO cofNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","To yucapiyarino ma quelo inasa, Diosi yachi Tencaca jeralelachica ereyanae tieque chuteca joe. Nulachi naolabe namalabe Diosichi mantate cuenta quilaquichunae. Diosi nalan nalan unilalachi quirajasa carichunae. Unicalachi quipi quirasa carichunaeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Diosibe mantaiminlachica yachi Tencaca ereyanae tie unilalachibinan, sonalachibinan. Yalanan Diosichi mantate cuenta quilaquichunaeque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yoquidobi duque ticatiya quirawoanae tie wepanarichun. Tobinan ticatiya quirawoanae tieque chuteca joe asanca, ninca, nin poyoca, yape tsachila junca quirato tenca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yo neme ichunae. Penan asan cuwenta luban ichunaeque chuteca joe. Jun tsanhichunaeque chuteca joe Miya Diosi to yucapiyarino ma quelo inasa. Seque wepanato quirantsan sen ma jochunae. ");
INSERT INTO cofNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Juntonan Miyabe rocaiminlaca se lariyanae tieque chuteca joe. ");
INSERT INTO cofNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Junni Pedro Diosichi Pilabi chutecaca tsanque manpasi, ya tsachilabe itsantinue: —Israelita tsachila, la pánaminca meralaquede! tinue. Jesús Nasareno Diosi wenteca jun tsachi jominhe tinue. Yape nulari junca tenhilaisa, Jesús duque wepanato quirantsancari seque quimin jominhe. Diosichi mantate jera tsanquinaminhe tinue nula nenanunte. Nulanan yaca miralaranae. ");
INSERT INTO cofNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tsan josanan, nulari Jesuca totesa carinilaquinue tinue. Nulari Jesuca cato cuwapolaquinue tinue yape seiton tsachila yaca corosibi totelaquisa. Junnasa mantimini Diosiri junca natiya wepanatunue. Matulenan Diosi miraminue Jesuca totenola joeque. Diosi paca jominue tsanhiniino joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Junni yari tsanle puyaca tsono itonan, Diosi ya puyaca jominca mansoncarinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Aman matu to David Diosichi Pilaca chutenato, Jesuchi tenchi pato itsantinue tinue: Miya Diosi numasitiya labe pejochunaeque mirayoe tie tinue. Lachi tsa tede nanchi rato ayudainanan, peleituanae tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Junni lachi tencabi pansi joto, duque son tito cuenta quimin joyoe tie tinue. La puyano jotonan, wepanatiyoe; mansonhino joyoeque mirato, wepanatuto meranirayoe tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Diosi, nuri lachi tencaca puyan ocolachibi natiya puratuchunae tie tinue. Laca, nuchi sen tsachi jonan, nu petesa carituchunae tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sonnanun minuca lachi micuwachunae tie tinue. Nu labe penenato, laca duque pansi josa carichunae tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Junni David chuteca fiquica jera patobi, Pedro itsantinue: —Amicola, Miya Davica tuca pantsan joe tinue. Yari matu mate puyato menaito, ¿natiya camansonhituco? tinue. Amananantiya ya menaranun postoca quirantsan rae. ");
INSERT INTO cofNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Tsan josanan, Diosi miya Davibe tsarasica juraquito pato, itsantinue tinue: Davichi alica mancaca miya suwanae tinue Davica cuwenta. Junni Davichi alicari puyato mansonhino jominue tinue. David Diosichi mantate pamin joto, yaca miramin jominue tinue. Junto Daviri puyan ocolachibi puraino itoyoe tito, tencachiquenan patue; Cristo tinun alicachi tenchiri pánaminue tinue. Junni jun tsanquenan patinue; Diosi Cristo tinunca puyan ocolachibi puratunue tinue. Yaca petesa caritunue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Diosi ya Jesuca mansonhisa carinue tinue puyaca jominca. Chiquilanan jeralela yaca manson nenaminca manquirato, jera cuenta polarilaquinayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","35","Aman David man postote itsanque pila chutenue tinue: Miya Diosi lachi Miyaca jamochi losa tichunae tinue yape yachi tsa tede nanchi pechusa. Junte chude! tichunae tinue nube pa jominlaca fe losa carino fecári. Junni Pedro David chuteca fiquica tsanque pato, tsachilabe itsantinue: —Junni ya jamochi lomin tsachiri David itominue; Jesús jominue tinue. Diosi Jesuca mansoncarito, jamochi chutenue tinue. Yachi tsa tede nanchi chutenue yape yabe pemantasa. Junni Jesús junte chusanan, Diosi yachi mantaca cuwanue tinue yape Diosichi Tencaca chiquilachibi eresa. Junni amana ticatiya pánanunca jera wepanato meráto, ticatiya quinanunca jera wepanato quirato, nulari itsanque tenca calaquede! tinue: Tenca mánta tsanlaquitue; Diosichi Tencari tsansa carinaeque tenca cantsan joe tinue. Diosi matu mate cuenta quica jominue tinue tsanhino joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tsan josanan, nula israelítalari ya Jesuca corosibi totesa carilaquinue tinue. Tsanni nula Jesuca totesa carica josa, Diosi yaca wenteto miya suwanue tinue. Yaca wenteto Cristo tinun suwanue tinue. Nula jeralela junca meralaquede! Tsarasica pánayoe; nene pátiyoe tinue. Pedro tsanque cuenta polarinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Junni tsantinunca meráto, israelítalari tencabi duque wepanalainue jutsa quiminlayoeque. Junni Pédrobenan weyan Crístochi mantá tanlabenan itsanque panhalaquinue: —Acola, palaquede! tilatinue. ¿Ti quinola jowan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Junni Pédrori yalabenan itsantinue: —Nula jeralela jutsa quinunca telaquepoto, casan tala tenca mancato, mumunhilaide! tinue Jesucrístochi icayoe tito. Junni Diosi nulachi jutsaca piyarito, yachi Tencaca nulachibi wisa carichunae tinue. Epe cuwanique cuwenta, yachi Tencaca nulachibi wisa carichunae. ");
INSERT INTO cofNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chiquilachi Miya Diosi jutsaca piyariyanae tito, nulachi tenchinan tsantinue tinue. Duque tsachilaca yabe cayaisa tinae tinue nulacanan, nulachi nalalacanan, barebi chuminlacanan. Jerale cayaisa tica jun tsachilachi jutsaca piyarino joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Junni Pedro yalabe duque fiqui polarito, yalaca payito itsantinue: —Amana mate sonnamin tsachilachi tenca yucapiyaca jolajoe tinue. Junni nulari yalaca jera telato, se lolaide! tinue. Pedro tsanque payinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Junni Pedro pacaca quereiminlari mumunhilainue. Jun matenan peman mili tsachila tsansi Jesucrístochi tsachilabe peilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Junni Jesucrístobe penenaminla duque ne layaimin jominlanue yape Crístochi mantá tanla yalaca micarilaquisa. Man junnique tenca cato nenaminlanue. Diosibe rocain, bibu pisulaito fin, quichun layaimin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Junni Crístochi mantá tanla duque wepanato quirantsancari seque quinaminlanue yape tsachila tenca cato miilaisa. Junnan jeralela jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Junni jerale Jesube cayaica junla layaito, man junni tenca cato, jeralela man layanni taminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Toca, ticatiya tanunca osito, jerale munaraminlachi cuwamin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Diosichi yabi ma cura layaito, tsachilachi ya curanan bibu pisulaito fimin jominlanue. Duque son tito, sen tenca tato, beco beco ano fimiyamin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diosica seque pamin jominlanue. Junni jerale tsachila Jesucrístobe penenaminlaca quirato, sen jolajoe timin jominlanue. Junni Miya Diosi ma cura uyan tsachilacanan se larinan, yalanan Diosichi tsachilabe pelayailainue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Aman man nete Pédrobe Juanbe Diosichi yaca lolainue. Diosibe rocaino óra jominue tre de la tardete. ");
INSERT INTO cofNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Junni loto quiranari, jancan tsachica tanjanaminlanue. Diosichi ya tamolan quelole chutebi tanjanaminlanue. Ya tamolanni Uraran Tamolan tinun jominue. Aman ya jancan tsachica ya tamolan quelole ma cura chutemin jominlanue yape Diosichi yabi wiminlachica lemosi calaca farisa. Nainunle nechi natiya nenano podeitumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Junni aman jancan tsachi Pédrobe Juanbe tamolanse wilaichinaminca quirato, lemosi cala panhanue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Junni Pédrobe Juanberi yacanan caca tala quirato, Pedro itsantinue: —Chiquilaca quirade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Junni yalaca quiranue lemosi cala cuwachinaeque tenca cato. ");
INSERT INTO cofNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Junni ya quiranunsi, Pedro itsantinue: —Cala itoyoe tinue. Oronan itoyoe tinue. Juntonan uyan cosaca cuwachinayoe tinue. Jesús Nasarénochi mantate mantanayoe tinue. Junni tsantisi, manwiruito nenade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Junsi jancanca tsa tedele cato manwirucarinue. Junni tsannunsileri nede manseinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Junto jancan jomin tsachi sonba manwiruito, mannenaniraminue. Nenato, suloto, Diosica se tito, Pédrolabe Diosichi yabi pewinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Junni jeralela yaca quiralaquinue Diosica se tito nenaminca. ");
INSERT INTO cofNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yaca quirato, yari Uraran Tamolante chumin jominheque tenhilainue. Lemosi calaca panhato chumin jominheque tenhilainue. ¿Niyaito manseinun? tilatinue. Tsantinato, duque wepananaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jancan jomin tsachiri Pédrobe Juánbeca cachurasanan, jeralela yalachica wepanato sujato layailainue. Salomonchi posto tinunte jera layailainue Diosichi yabi. ");
INSERT INTO cofNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Junni Pedro jera layainaminlaca quirato itsantinue: —Israelita tsachila, ¿niyaito inca wepanalainayun? tinue. ¿Ti quichun chiquilaca wepanato quiralaquinayun? tinue. Chiquilari in tsachica mansechun natiya sonban itolajoyoe tinue. Diosi cuwenta natiya itolajoyoe in jancan jomin tsachica jera manse suwachun. ");
INSERT INTO cofNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chiquila tsanlaquitiyoe; Diosichi Nao tsanquee tinue. Diosi yachi Naochi duque mantá cuwanan, yari in jancan jominca manse suwae tinue. Aman Diosi chiquilachi matu to tatalaca, Abrahanbe, Isaabe, Jacóbobeca, aman yalaca Diosi wentenue yape yachi tsachila jolajosa. Junni nulachi tatalaca wentemin Diosi patsa Jesuchi mantá cuwaca joe. Junni tsan josanan nulari Jesuca cuwaponilaquee tinue yape yaca totelaquisa. Pilato miya yaca manlarichi tinasanan, nulari manlarisa carilaquitue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nulari Diosichi tsara sen tsachicari manlaritude! tito, tsachilaca toteminca manlaride! tilatie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sonnasa cariminca totesa carilaquee Jesucrístoca. Diosi mantimini yaca mansonhisa carinue tinue. Ya manson nenaminca chiquilari cacachi quiralaquiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Junni in jancan jomin tsachi ya Jesuca tennanue tinue. Jun tenchi Jesús yaca sonba wiruisa carinue tinue. ¿Inni jancan jomin tsachi joco? Aman Jesuca quereito, jera manseinue tinue. Jeralela quiranilaquede! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Aman nulabe nulachi miyalabe Jesuca totesa cuwaponato, miitoto cuwapolaquee tinue. Junca mirayoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aman jerale Diosichi mantate paminla matu mate pila chutenato, Jesucrístoca itsanque cuenta polarica jominlanue tinue: Diosi wenteca Cristo tinun tsachi padeseino jochunaeque chutelaquinue tinue. Junni Diosichi Pilabi tsantica josa, Diosiri jun tsannan isa carie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Junni nulari jutsa quinunca telaquepoto, casan tala tenca mancalaquede! tinue. Diosibe cayailaide! tinue. Tsanlaquinari, Diosi nulachi jutsaca jera piyarichunae tinue. Miya Diosi nulaca pansi chusa carichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Junsi Jesucrístocanan numarile nechi manhereyanae tito, nulachica manherechunae tinue. Diosi yaca mantá tan suwaca joe yape nulachi tenchi Cristo tinun Miya josa. ");
INSERT INTO cofNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tsan josanan, Jesucrístori tsainaleri camanjatuchunae. Casaleri Diosi jeraleca mansechunae tinue. Matunan Diosichi mantate seque paminlari junca cuenta polarica jominlanue tinue. Junni jera manseno fecári Jesucristo jamochinan cachuno jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Matu to Moisés Jesucrístoca pila chutenue tinue. Ya pilabi israelítalabe itsanque cuenta quinue tinue: Miya Diosi israelítalachile nechi tsachi mancaca wenteto mantá tan suwachunaeque paca joe yape Diosichi mantate pasa. Ya tsachi Moisés cuwenta mantá tan jochunaeque paca joe tinue. Junni ya tsachi jano mate israelítala yachi fiquica jera seque meránola jochunae tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ya pacaca merátuchi timinlacari casticaquito toteno jochunae tie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Junni Diosichi mantate matu tote paminlanan cuenta polarilaquinue tinue Jesucristo nenano mate niyan jono jonunca. Casale matu to Samuel junca cuenta quinue; junte nechi jeralelanan jun tsanquenan cuenta quilaquinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Junni ya Diosichi mantate paminla israelítalanan pejominlanue nula cuwenta. Yalari Diosichi fiquica matu mate patonan, nulachi tenchinan pánaminlanue. Aman Diosi patsa matu to Abrahanbe itsantinue. La nuchi alica mancaca wenteyanae tinue yape piyanle tote chuminlachi tenchi sen quisa. Junto Diosi nulachi matu to tata Abrahanbe tsantinato, nulachi tenchinan tsantinaminue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Junni Diosi yachi Naoca mansoncaritobi, nulachica casale erenue tinue. Yaca erenue yape nulachi jutsaca telaqueposa carito nulaca jera sen quisa. Pedro Diosichi yabi layaica junlabe tsanque micarinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Junni Pedro tsachilabe cuenta caquinasanan, israelita mantaminla jalainue. Patelelabe saduseo tinunlabe Diosichi yaca cuidaimin polisia capitanbe jalainue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aman Pédrobe Juanbe tsachilaca micarinato, Jesús puyato mansonhinueque micarinaminlanue. Jun tenchi jeralelanan mansonhicaichunaequenan micarinaminlanue. Junni Pédrola tsanque micarinaminlaca israelita mantaminla duque paito ");
INSERT INTO cofNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","yalaca calaquinue. Junni quebi cato, ayuna nanchi fecári Pédrolaca do taminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tsan josanan duque tsachila Pedro micaricaca meráto, Jesube cayailainue. Unilalacasiri minan, mante mili tsansi cayaica junla inue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aman junni ayuna nanchi israelita mantaminla ya Jerusalén pueblobi layailainue. Mantá tan unicalabe, israelítala tala mantaca micariminlabe, ");
INSERT INTO cofNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","fe mantá tan patelebe, Caifabe, manca Juanbe, Alejándrobe, mantá tan patelechi uyan familialabe layailainue. Aman fe mantá tan patele Anasio mumun jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Junni aman Pédrobe Juánbeca quitsabi wirucarito, itsanque panhalaquinue: —¿Ti mantate tsanlaquiyun? latinue. ¿Mo nulaca tsanquisa carin? latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Junni Pedro Diosichi Tencabe jera seque mantaito itsantinue: —Israelita mantaminla, israelita unicala, ");
INSERT INTO cofNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿nula chiquilabe tíca miino muquilaquin? tinue. ¿Jancan jomin tsachi manseica jonunca panhalaquinayun? Tsanque sen quinunca miino muquilaquinari, ");
INSERT INTO cofNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","junni meralaquede! tinue. Jerale israelita tsachila junca miinola joe. Jesús Nasareno yaca jera manse suwacae tinue. Jesucrístochi mantate in jancan jomin tsachi nulachi cale senan manwirurae tinue. Nulari Jesuca corosibi totesa carilaquee tinue. Diosi mantimini yaca puyaca jominca mansoncarinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Meralaquede! Diosichi Pilabi itsanque chuteca joe: Suca ya quiminla su mancaca seitoe tito quepolaquichunaeque chuteca joe. Tsan josanan, ya suri uraran fe munaranun su patichunaeque chuteca joe. Junni nulari jun ya quiminla cuwenta jolajoe. Jesucristo jun su cuwenta joe tinue. Nulari yaca seiton joe tito quepocala josanan, ");
INSERT INTO cofNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","yasiri jutsa quinaminlaca se larimin joe tinue. Diosi yaca mumun pato mantá cuwanue tinue yape jerale tote chumin tsachila yabesiri se lolaisa. ");
INSERT INTO cofNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aman Pédrobe Juanbe epe tsachila jominlanue. Duquenan estudiaica iton jominlanue. Tsanla jotonan, luratuto paniquinaminlanue. Junni israelita mantaminla Pédrobe Juanbe pánaminca meráto wepanalainue. Junsi tenhilainue Jesube miicala joto tsan jolajoeque. ");
INSERT INTO cofNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Junnasanan, ya manse suwaca jun tsachinan junbi Pédrolabe pemanwiruraminue. Jun tenchi israelita mantaminlari yaca quirato, man fiquinantiya beco pano podeitulajonue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Junsi Pédrolaca tamochi nechi moora larito, israelita mantaminla talari tenpalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Itsanlatinue: —¿In tsachilaca niyan quintsan junhun? latinue. Wepanato quirantsancari tsara seque quilaquee yape uyan tsachila jera quirato tennalarasa. Jerusalenbi chumin tsachila junca jera miralarae latinue. Jun tenchi chiquilari nene joe tino podeitulajoyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Junto aman yalaca sonba payito, jele pontsan joe latinue yape uyanlanan yalachi fiquica meralaquitusa. Jesuchi mantate mobenantiya cuenta manpolarilaquituna! tintsan joe latinue. Yachi mantate micarilaquinari, nulaca ura casticaquilaqueyanae tintsan joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Junni Pédrolaca manwiyasa carito, Jesuchi mantate natiya manpatusa mantalaquinue. Jesuchi mantate micarilaquituna! tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Junni tsantinaminlaca meráto, Pédrobe Juanbe beconan itsanlatinue: —Nulari tenca cato miilaide! Chiquilari Diosicari merátuto, nulacari meránari, ¿yari Diosibe sen jono jun? ");
INSERT INTO cofNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Chiquila quiranuncari, meránuncari, cuenta manpolarinonan jolajoyoe latinue. Pédrola israelita mantaminlabe tsantilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Junni mantaminlari duque pa jolajosanan, jerale epe tsachilari Diosica duque sen joe latinaminue jancanca manse suwanun tenchi. Jun tenchi mantaminlari epe tsachilaca jelechi Pédrobe Juánbeca casticaquitulajonue. Junto yalaca manan manholeto, manlarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aman ya jancan jomin manseica jun tsachiri junpalu chunca wata fe taminue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aman Pédrobe Juanbe manlolaitobi, Jesube penenaminlachica manjilainue. Junchi manjito, mantá tan patelelabe, mantá tan unicalabe palaquinanunca jera manpolarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Junni Jesuchi tsachila junca meráto, jeralela man parejori tenca cato Diosibe itsanque rocailainue: —Mantamin Diosi, nu yoquidoca quinue. Toca quinue. Lamarica quinue. Nu jeralete ticatiya sonnaminlaca jera quinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Matu to miya Daviri nube seque mantaimin jominue. Junni nuchi Tencabe mantaito David itsanque pila chutenue: Uyan to tsachilari paito cuenta quilaquichunaeque chutenue. In to tsachilanan seiton quino tenca calaquichunaeque chutenue. Juntonan yari epe jochunae. ¿Ti quichun tsanlatichunan? ");
INSERT INTO cofNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uyan to miyalanan layailaichunaeque chutenue Diosibe quicaachun. In to mantaminlanan layailaichunaeque chutenue. Miya Diosica pachi, ya wenteca jun Cristo tinunca pachi layailaichunaeque chutenue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Junni Diosi, nu tuca pila chutesa carinue latinue. Nuchi pilabi jera tsanhichunaeque chuteca josa, jun tsanquenan patinue latinue. In to miya Herodes, uyan to miya Poncio Pilato, aman yalabenan in to tsachilabenan, uyan to tsachilabenan, jeralela layaito Jesuchi contra jominlanue. Jesuri nuchi tsara sen Nao joe latinue. Nuri yaca wenteto, mantá tan suwanue. Tsan jominca yala jeralela yaca paito layaica jominlanue latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nu mantimini matulenan jera tenca caya jominue latinue Jesús jera niyan intsan jonunca. Nu tede ponue latinue. Junni Jesuca pa junlari jera ticatiya quinilaquee latinue. Nuri numa pato Itsanquichunae tica josa, jun tsannan quinilaquee latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chiquilari nube mantaiminla joyoe. Tsan josanan, chiquilaca seiton quichi latinae. Aman nu Diosi, junca meráto, chiquilaca sonba tenca suwade! chiquilari jeleratuto nuchi fiquica palaquichun. ");
INSERT INTO cofNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Junni chiquila nuchi fiquica palaquinasanan, nu Diosi tede poto quiyanpunlaca manse suwade! latinue. Jesús nuchi tsara sen Nao joe. Junni chiquilaca Jesuchi mantate duque wepanato quirantsancari seque quisa caride! latinue yape tsachilari junca quirato nuca tenca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Junni Diosibe tsanque rocainunsi, layainun tamori wecainue. Junnasale Diosichi Tenca yalachibi jera seque mantaquebi winue. Junnan yalari luratuto, Diosichi fiquica seque pánaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Junni Crístochi mantá tanla Miya Jesuca pánaminlanue yaca mansonhicaca quiracalayoeque. Diosi yala jeralelaca duque laquirato seque ayudainaminue. Junnan aman jerale Jesucrístobe cayaica junla man junni munaralarato, man tencari cato chuminlanue. Yala ticatiya tato, yaca tsacumin joyoe titumin jominlanue. Ticatiya tato, jeralela man parejo tamin jominlanue. Monantiya isapun itominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ticatiya munajanasa nenamin tsachilanan itominlanue. Aman molatiya to tatori, o ya tatori, junca jera osito cala cato, ");
INSERT INTO cofNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ya calaca Crístochi mantá tanlachi cuwamin jominlanue. Junni yalaman jerale munaraminlachi mancuwamin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aman junnasa Chipre tobi nechi jaca tsachi manca jominue. Crístochi mantá tanlari yaca Bernabé tensaato mumun polaquinue. Yalachi fiquichiri laqui jominlaca payimin tsachica Bernabé tinun jominue. Yari Levichi bolon israelita tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Junni yanan yachi toca osito, cala cato tanjato, Crístochi mantá tanlachi jera cuwanue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Junni aman manca tsachiman jominue Ananías mumun. Yachi sonari Safira mumun jominue. Aman yalaman to osilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Junto cala casi, Ananías weyanca nosa larito, jun puchuca Crístochi mantá tanlachi cuwato, jera cuwanayoe tinue. Yachi sonanan miraminue ya weyan calaca nosa laricaya joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Junni Ananías jera cala cuwanayoe tinunsi, Pédrori yabe itsantinue: —Ananías, nuri to tenchi cala cato, weyan calacari tsato, inni jera joe tito cuwanae tinue. Nuri Diosichi Tencabenan nene pánae. ¿Aman niyaito Satanás nuca tsanque encanasa carinan? ");
INSERT INTO cofNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ya toca caosituminnan, nu tsacumin jominue. Aman ositobinan, nunan calaca tsacumin jominue. ¿Junni ti quichun nene pano tenhiyun? Nuri tsachilaberi nene patue; Diosibenan nene pae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Junni Pedro tsantinaminca meráto, Ananías puyaca queereinue. Junni jerale junca meráminla duque jele tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Junni Ananías puyanunsi unila tsachila jato, ya puyacaca lapito menabi tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Junni peman órate Ananíachi sonaman janue. Yachi unila puyaca joeque miituto janiinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Junni Pedro yabenan itsantinue: —¿Nulachi toca tsansiteri osilaquiyun? tinue. Junni ya sonari tsansitere tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro mantimini beconan pato, itsantinue: —¿Ti quichun nula palunan Miya Diosica tsanlaquinayun? Nula miichi tinaminlanue Diosichi Tenca nisi fecári jutsa tenchi casticaquituminnan wantaino jonunca. Junni meráde! tinue. Nuchi unila puyan ococa menaminlari tamolante merará manjalainae tinue. Junni nucanan menabi tanjilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pedro tsantinunsi, ya sonari Pédrochi nedele queereito puyanue. Junni unila tsachilanan manwito, ya sona puyacacanan cato, yacanan tanjito, yachi unila puyan ocochile menalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Junni jerale Jesucrístobe cayaica junla junca jele tinaminlanue. Uyanlanan junca meráto jeralela jele tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Jerale Jesucrístobe penenaminla Diosichi yabi layaimin jominlanue Salomonchi tinun postote. Uyanlari Jesucrístochi tsachilabe layaino jeleratonan, yalaca sen jolajoeque cuenta quinaminlanue. Juntonan nantanancari fe tsachila Miya Jesucrístobe cayainaminlanue sonala, unilala. Junni tsachila quiralaquinasa Crístochi mantá tanlari duque wepanato quirantsancari seque quinaminlanue yape Diosica tenca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Junni tsachilari quiyanpunlaca minu quelote tanjato tsoremin jominlanue. Weyanlacari cuyanbi, weyanlacari lowa tsanbi tanjalainue. Pansile Pedro polenasanan, yachi ocopinchube doilaitotiya manseilaichunae latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Aman quelole pueblobi nechinan quiyanpunlacanan, yucanchi ocobe padeseinaminlacanan Jerusalenca tanjalainue yape manseilaisa. Junni jerale tanjaca junla manseilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Tsantin nenalarasanan, fe mantá tan pateleri yachi tsachilabe Crístochi mantá tanlaca pailainue. Aman ya patelebe penenaminla saduseo tinun israelítala jominlanue. Junni yala jeralela Crístochi mantá tanlaca pailainue uyan israelítala ya patelelaca telaquepoto Crístochi mantá tanlaca fécari meralaquinaeque. Junto Crístochi mantá tanlaca cato dolaquinue yape wari tsachilaca nantari micarilaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Junni doralarasanan, jun quepente Miya Diosi yachi anjelica erenue yape doranun tamolanca lasito cuwasa. Junni anjeliri Crístochi mantá tanlaca donun yabi nechi larisi, yalaca itsanque mantanue: ");
INSERT INTO cofNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Diosichi yaca jilaide! tinue. Junbi wiruito tsachilaca Diosibe pesonnanoca jera micaride! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Junni tsantinunca meráto, aman mantseinunsi Diosichi yabi manwito micarinaminlanue. Junnasa mantá tan patelebe yachi tsachilabe jerale israelita mantaminlaca layalaquinue. Junto jera layaitobi, donun yaca fiqui erenue yape Crístochi mantá tanlaca manlarito tanjalaisa. ");
INSERT INTO cofNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Junni polisiala donun yabi féto quiranari, Crístochi mantá tanlari itominlanue. Junca quirasi, mantá tan patelechica manjito, ");
INSERT INTO cofNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","itsanlatinue: —Chiquila féto quiranari, donun yari sequenan doraminue latinue. Quiramin polisialanan tamolante quirato wiruraminlanue latinue. Junni aman tamolan manlasito quiranari, fu tamo jominue latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Junni capitanbe mantá tan patelelabe ya fiquica meráto, duque wepanato, ¿Niyanhichunancan? tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsanlatinasa mantimini, tsachi manca yalachica jato itsantinue: —Nula doca jomin tsachilari Diosichi yabi tsachilaca manmicarilaquinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Junca merasi, capitanbe polisialabe Diosichi yaca manjito, Crístochi mantá tanlaca manan mancato tanjilainue. Aman yalaca canatonan, uyan tsachilaca jelechi natiya sonba catulajonue chiquilaca pansile su walaca tala quilaquichunae tito. ");
INSERT INTO cofNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Junni Crístochi mantá tanlaca mantanjato, israelita mantaminlachibi tanwilainue. Junni fe mantá tan pateleri yalabe ");
INSERT INTO cofNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","itsantinue: —Chiquilari nulaca duque sonba mantalaquiyoe tinue Jesuchi mantate natiya manmicarilaquitunaque. Tsantica josanan, nulari jerale Jerusalenbi chuminlaca micarinilaquinae tinue. Junsi chiquilacanan culpa quichi latinae tinue Jesuca totesa caricalaeque. ");
INSERT INTO cofNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pédrobe uyan Crístochi mantá tanlabe beconan pato, ya mantaminlabe itsanlatinue: —Chiquilari tsachilacari merátuto, Diosicasiri meránola joyoe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nulari Jesuca corosibi totesa carica josa, chiquilachi matu tatalachi Diosinan yaca mansoncarinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Junsi yaca jamochi laricanue tinue yape yachi tsa tede nanchi pemantato chusa. Junni Jesús jamochi chuto, israelítalaca yalachi jutsaca jera telaqueposa carino munarae. Yari nulachi jutsaca piyarino podeichunae. ");
INSERT INTO cofNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aman chiquilari junca jera mirato, Diosichi tenchi tsanque cuenta polariniquinayoe. Diosichi Tencanan junca jera mirato, yanan tsachilaca tsarasi fiqui joeque tenhisa carinae. Junni Diosi yaca meráminlachica yachi Tencaca eremin joe tinue yape yalachibi wito chusa. Junni Pedro jun fiquicari cuenta polarinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jun fecári meralaquinaminnan, israelita mantaminla Pédrolaca duque paito totechi latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Junni totechi latinasa, manca mantamin tsachiri cuenta quichun wiruinue. Yari fariséolachi bolon israelita joto, yala tala mantaca micarimin jominue. Gamaliel tinun mumun jominue. Jeralela yaca duque respetaimin jominlanue. Junni ya mantimini Pédrolaca urachi moora larisa carito, ");
INSERT INTO cofNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","weyan mantaminlabe itsantinue: —Israelita tsachila, nulari ya Jesube penenaminlaca tsarasica tencabe nenalarana! tinue. Seque tenca catuminnan tína tede potulajona! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aman meralaquede! Matulenan Teúda tinun tsachi mantamin joyoe tide janue tinue. Junpalu patsa tsachila tsansi yabe penenamin ica jominlanue. Junni ya Teúda totainunsi, yabe penenaminlari ara cura jera jilainue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aman Teúdachi benete Judas tinun tsachiman Galilea tobi nechi janue. Senso quinasanan janue. Weyan tsachila yabenan penenamin ica jominlanue. Junni yanan tsanquenan totainunsi, yabe penenaminlanan ara cura jera jilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Junto ya Jesucristo tinunbe penenaminlaca telaquede! tiyoe tinue. Tede tína potulajona! Tsachilachi mantatesiri micarilaquinatori, o tsachilachi mantatesiri manse suwato nenalaratori, yalanan epele ara cura jera jilaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Junni pansile Diosichi mantate micariminla jonari, chiquilari yalaca numanan fe lono podeicaituchunae tinue. Fe lochique tenfelainatori, pansile Diosichi contranan jono paticaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Junni jerale mantaminla ya pacaca meráto, seque pae tilatinue. Junto Crístochi mantá tanlaca tamochi manwiyasa carito, yalaca asotaquisa carito, Jesuchi mantate nantari micarilaquitunaque mantato, manherelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Junni tsanque padeseitobi, ya mantaminlachibi nechi duque son tide manlolainue. Diosi yalaca Jesuchi tenchi padeseisa carica jominue. Jun tenchi yalari son tito Diosibe acradeseilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Junni ma cura Jesucrístoca pato micarinaminlanue weyante Diosichi yabi, weyante tsachilachi yabi. ");
INSERT INTO cofNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tsan josanan, nantanancari duque tsachila Jesucrístobe cayailainue. Junni tsantin chuminnan, griego fiqui paminlari israelita fiqui paminlaca pailainue. Chiquilachi bolon biudalaca seiton quilaquinae tinaminlanue. Ma cura fino itonlachi finoca cuwanato, ya biudalachiri layan cuwatuminla joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Junni chunca paluca Crístochi mantá tanla piyanle Jesucrístobe penenaminlaca jera layaisa carito, itsanlatinue: —Chiquilari Diosichi fiquica micarinola joyoe. Chiquilari ano poto cuwachun junca puranari, ¿seitochunaco? latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jun tenchi, acola, soquila, meralaquede! Nula tala sieteca tsachilaca wentelaquede! Jera sen joe tinunla, Diosichi Tencabe jera mantaiminla, tenca tanla jonola joe. Junni chiquila yalaca ano poto cuwasa mantalaqueyanae latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Chiquila mantimini Diosibe rocain, Diosichi fiquica micarin, quinilaquinanae latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Junni Crístochi mantá tanla tsanticala josa, jeralela se joe latinue. Junsi casaleri Estébanca wentelaquinue. Yari Diosica tsara quereimin joto, Diosichi Tencabe jera seque mantaimin jominue. Junsi aman Felípeca, Prócoroca, Nicanórica, Timonca, Parménaca, Nicolaca wentelaquinue. Aman Nicolás mantimini Antioquíabi nechi jominue. Yari israelita itotonan, Jesube cacayaituminnan israelítalachi mite Diosica tenca camin ica jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Junni yalaca jera wenteto, Crístochi mantá tanlachica tanjalainue. Junni Crístochi mantá tanlari Diosibe rocaito, tedechi tale quito, mantá cuwalaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Junni nantanancari tsachila Diosichi fiquica miinaminlanue. Tsanhinato Jerusalenbi duque Jesucrístobe penenamin ilainue. Duque israelita patelela jominlanan Jesucrístoca meráto cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tsan josanan, Estébanni duque wepanato quirantsancari seque quinaminue yape tsachila junca quirato Diosica tennalarasa. Diosi Estébanca laquirato, duque sonba tenca suwanue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Junni Esteban tsantin nenasanan, weyan israelítala yabe pacaalaquinue. Israelítala tala Diosichi fiqui miinun ya manca Liberto tinun jominue. Junni Estébanca pa jominla junbi nechi jominlanue. Yalari Cirene tobi nechi, weyanlari Alejandría pueblobi nechi, weyanlari Cilicia tobi nechi, weyanlari Asia tobi nechi jominlanue. Yalari Estébanbe pacaato, ");
INSERT INTO cofNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","yalanan jera pele ilainue. Esteban Diosichi Tencabe jera seque mantaito tsara sen tencabe pánaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Junni yalari peleilaiyoeque tenhito, uyan tsachilachi nosa cala cuwalaquinue yape Estébanca seitonque nene palaquisa. Esteban Diosica seitonque pánaminca meralaquiyoe latinue. Matu to Moisécanan seitonque pánaminhe latinue. Estébanca tsanque nene palaquinue cala cachiqueri. ");
INSERT INTO cofNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Junsi israelítalaca firara tisa carilaquinue yape Estébanca cato dolaquisa. Mantá tan unicalaca, mantaca micariminlacanan, uyan israelítalacanan tsanque firara tisa carilaquinue. Junto Estébanca cato, mantá tan israelítalachica tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Junni nene pamin testicolacanan petanjilainue yape Estébanca seitonque palaquisa. Nene pato, itsanlatinue: —In Esteban Diosichi yacanan, Diosichi mantacanan, duque seitonqueri pamin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ya itsantinaminca chiquila meralaquiyoe tilatinue: Jesús Nasareno Diosichi yaca araleto, junsi Moisés micaricaca jera canbiyacarichunae tinaminca meralaquiyoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Testicola tsanlatinasanan, jerale mantaminlari Estébanca quiralaquinasari, yachi caforori anjelichi caforonan quiran jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Junni aman mantá tan pateleri Estébanbe panhato, ¿In testicolachi fiqui tsa jun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Junni Estébanni beconan manpato, baren cuenta polarinue yala Diosibe cayaituchi timinla joeque. Itsantinue: —Israelita pejunla, laca meralaquede! tinue. Chiquilachi matu to tata Abraham casale Mesopotamia tobi chuminue. ¿Yanan Caldea tinun to joco? Junni Abraham Harán toca chubi cajitusanan, tsara sen Diosi yabe quiraito ");
INSERT INTO cofNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","itsantica jominue tinue: Nuchi familialaca purato, nuchi tobi nechi lode! tica jominue tinue. Nu jinasanan, manca toca nuchi micuwanae tica jominue tinue yape nu junbi chusa. ");
INSERT INTO cofNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Junni Diosi tsantinunsiri, Abraham Caldea tobi nechi loto, Harán tobi chubi jinue. Junsi Abrahanchi apa puyanunbi, Harán tobi nechinan lonue. Junte nechi Diosi Abrahanca in tobinan chusa tanjanue tinue chiquila amana chunun tobi. ");
INSERT INTO cofNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Junni Diosi Abrahanca inchi tanjaca jotonan, toca nasi nacánantiya tsacumin caisa caritunue tinue. Tsan josanan nanni ina cuwanae tinue yape nu tsacumin josa. Junni Abraham puyanunbi, yachi alicalanan in toca tsacuminla jolajochunaeque paca jominue tinue. Junni aman Diosi Abrahanbe tsantino mate Abraham na caquiratumin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Junsi Diosi Abrahanbe itsantica jominue: Nuchi alicala uyanlachi tobi chularachunae tinue. Jun bare tobi chuminlari yalaca seiton quito sonba trabajaquisa carilaquichunae natiya pacara quituto. Junpalu patsa wata fecári nuchi alicala jun tobi tsanque padeseito chularachunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Junni Diosi jun tobi chuminlaca casticaqueyanae tinue nulabe seiton jonun tenchi. Junnan nuchi alicala jun tobi nechi manloto, in toca manjato, laca se tito, labe rocaito nenalarachunae tinue. Diosi Abrahanbe tsantica jominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Junsi Diosi Abrahanbe tratoca quinue yachi quidoca poresa Diosichi joyoe tito. Junni Abrahanchi sona na quinan, jun naoca Isaac mumun polaquinue. Ya na ochu ma tanca yachi quidocanan porenue yacanan Diosichi joe tito. Junni Isaachi naoman Jacobo mumun jominue tinue. Jacobo mantimini chunca paluca naola taminue tinue. Yala chiquilachi matu to tatala jominlanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Junsi Esteban israelita mantaminlabe cacuenta quinato itsantinue: —Junni aman Jacóbochi nao manca, ya José mumun jominue tinue. Junni Josechi acolari yaca pailainue tinue. Yari fe jochi tinae tito pailainue. Junto Joseca paito, yaca nosa tarinto osilaquinue tinue. Acolanan osilaquinue yape Joseca Egipto toca tanjilaisa. Diosi mantimini Joseca natiya puratunue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Diosiri yaca padeseinaminca seque ayudainue. Junsi Diosi Faraón tinun miyachi tenca cuwanue. Joseca tsara sen tenca tan tsachi joeque tenca casa carinue. Junto Faraonni Joseca duque mantá tan suwanue tinue. Yachi yacanan, jerale Egipto tocanan mantasa carinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Junni jun malate Egipto tobi ano itonan, duque padeseinaminlanue tinue. Aman Jacóbolanan in Canaán tobi cachuminnan, yalanan ano itominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tsantin chularasanan, Egíptobi ticatiya finolaca seto taminlanue. Junni Jacóbori junca merasi, yachi naolaca Egíptoca casale man ne erenue tinue yape fino cato manjalaisa. ");
INSERT INTO cofNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Junni wanbile yachi naolaca Egíptoca manan manherenue. Junni Josechi acolari yalachi apa ereca jun jito, Egíptoca manan manjilainue tinue. Manan fino cabi jilainue tinue. Junni jun jicate Joseri yalabe manpaniquito, nulachi aco Joséyoe tinue. Tsanque Egipto to miyari Joseca tile nechi jaca jonunca miinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Junsi Joseri yachi apachica fiqui manherenue tinue. Yachi apabe yachi familialabeca jeralelaca Josebe pechubi jalaideque fiqui erenue. Jerale nechi siete chunca manteca tsachila Egipto toca chubi jilainue tinue Jacóbobe yachi naolabe, weyan familialabe. Junni Jacobo Egíptobi chuminnan puyanue. Yachi naolanan, chiquilachi matu to familiala, yalanan Egíptobi chuminnan puyalainue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Junni wanbile yala puyacalaca Siquem puebloca menabi mantanjilainue tinue. Siquenbi Abraham pantiyon quichun to nasi nacá calachi caya jominue. Matulenan Hamórichi naolachica caya jominue. Junni chiquilachi matu to tatalaca jun pantiyonbi menalaquinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Junni Esteban capánato, ya mantaminlabe itsantinue: —Junni chiquilachi matu to familiala Egíptobi cachularasanan, to cuwano ma queloinaminue. Diosi yalachi in toca cuwano ma queloinaminue tinue. Matulenan pato, Abrahánlachi cuwanae tica jominue. Junnasanan Abrahanchi alicala Egíptobi duque seranaminlanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tsan josanan, manca tsachi Egipto to miya inue. Yari Joseca natiya miratumin jominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ya miyari chiquilachi matu to familialaca encanato seiton quinue. Tsotsoca unila nalalaca queposa mantanue yape israelítala seralaitusa. ");
INSERT INTO cofNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Junni tsantin chularasanan, Moisés nainue. Junni Diosinan yaca sen na joe tinue. Aman peman pe fecáriri yachi apari, ayanni ya náca tsato taminlanue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Junsi ya nácanan quepono patinue. Junni yaca epele tsoreto manjicala josa, Egipto miyachi namari Moisés náca mancanue tinue. Junni yachi naoca cuwenta Moiseca uwa suwanue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsanque Moisés uwainato, Egipto tobi miranunca jera pemiinue. Ya sonba meracari pamin tsachi jominue. Ticatiya seque quimin tsachi jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Junto Moisés junpalu chunca wata tato, ya israelita joto weyan israelítalaca manquirabi jino tenhinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Junte man ne jinato quiranari, Egipto tsachiri israelítaca seiton quinaminue. Junni Moiseri ya padeseinaminca isaito, Egipto tsachica totenue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","29","Junni ayuna nanchi paluca israelítalari pataato quicaanaminlanue tinue. Moisés mantimini yalaca quirato, yalachica jato, manse patarichi tito, itsantinue tinue: Israelítala, nulari familiala joto, ¿niyaito quicaalaquinayun? tinue. Junni fe seiton tsachiri Moiseca tulipoereto, itsantinue: ¿Nucari mo miya cuwenta josa mantaca jun? Nuri chiquilaca fe jochiqueri tsantinae. ¿Quisin Egipto tsachica totenun cuwenta, lacanan toteno muquin? tinue. Junni tsantinunca meráto, Moisés uyan toca sujinue tinue. Aman Diosi Moiseca ereca jominue israelítalaca Egíptobi nechi jera mantanlasa. Israelítala mantimini natiya quereituca jominlanue. Diosi Moiseca ereca jominheque quereituca jominlanue. Junni yalari quereitulajoeque Moiseri wepananaminue. Junni Moisés Egíptobi nechi sujito, uyan to tsachilabe chuminue Madián tinun tobi. Aman junbi chuto sona cato, paluca nao taminue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Junni Esteban israelita mantaminlabe cacuenta quinato itsantinue: —Aman junni junpalu chunca wata polecabi, Moiseri niyanlanantiya chutunun to minu nenaminue. Junni Sinaí tinun du quelole nenasa quiranari, tape lunaminue tinue. Junnasa quiranari, jun nin lunanunbi anjeli jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Junni Moisés junca quirato, duque wepananue tinue. Junni quelo féto quirabi jinaminnan, Miya Diosi pánanunca meránue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Diosi itsantinue tinue: Nuchi matu to tatalachi Diosi joyoe. Abrahanchi, Isaachi, Jacóbochi Diosi joyoe tinue. Junni Moisés jun fiquica meráto, jelechi jowinponato quirano jeleinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Junsi Miya Diosi yabe itsantinue tinue: Nuri lachi sen postobi wirurae; junni laca respetaito, sapatoca laride! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Junni lachi israelita tsachilaca Egíptobi quirayoe tinue. Egipto to tsachila yalaca seiton quinaminlacanan quirayoe. Israelítala warenaminlaca meracayoe tinue. Junto yala padeseinaminlaca se laribi patacayoe. Meráde! tinue. Nucari Egíptoca manherechinayoe tinue yape israelítalaca se larisa. Diosi Moisebe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Junni aman nanni matulenan israelítala Moisebe mantaituchique yaca pato ¿Nuca mo miya cuwenta josa mantá cuwaca jun? tica jominlanue tinue. Junni yalari Moisebe mantaituchi tinasanan, Diosi mantimini Moisés patsacari wenteca jominue yape yalaca mantato se larisa. Tapebi ramin anjeli Diosichi mantate pato, Moiseca tsanquenan mantá cuwaca jominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Junni nanni inale Moisés israelítalaca Egíptobi nechi manse larinue. Egíptobi nechi lolaito, Mar Rojo tinun wa pipilu polelaito, junpalu chunca wata fecári niyanlanantiya chutunun tobi nenaminlanue. Aman tiletiya nenato Moisés duque wepanato quirantsancari seque quede jinaminue yape israelítalari Diosica tenca calaquisa. ");
INSERT INTO cofNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Junni ya Moiseri israelítalabe itsantinue tinue: Miya Diosi manca mate nulachile nechi manca tsachicaman wentechunae tinue. Lachi cuwenta yachi mantá cuwachunae tinue yape Diosichi mantate pasa. Junni yaca meránola jochunae tinue. Moisés matu to israelítalabe tsantinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Junni ya israelítala layaito, niyanlanantiya chutunun tobi nenato, ya Moisenan yalabe pejominue. Junni yari Sinaí dubi lonue. Junbi anjeli Diosichi sen fiquica Moisebe jera panue chiquilachi tenchi. Junni ya sen fiquica merasi, chiquilachi matu to familialabe manpolarinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Aman junni Esteban cuenta caquinato itsantinue: —Ya israelítala mantimini Moiseca merátuchi timin jominlanue tinue. Moisés Sinaí dubi nechi camanpatatusanan, yalari Moisechi aco Aaronbe cuenta quito itsanlatinue tinue: Moisés chiquilaca Egíptobi nechi larito puraniquee tilatinue tinue. ¿Amana wari yaca niyantiya ica jonhoncan? latinue tinue. Natiya miituntsan joe. Junni nuri Aarón, chiquilachi tenchi diosilaca quede! Uyan diosilaca quede! tilatinue tinue yape chiquilaca mantanjilaisa. Tsanque israelítala Egíptoca necanan manjino tenca calaquinue tinue Moiseca telaquepoto. ");
INSERT INTO cofNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Junni jun mate wala nanan quiran molde quito, diosi joe tilatinue tinue. Junsi animalica toteto, ya wala nachi epe cuwalaquinue tsa Diosichi cuwanun cuwenta. Yala quica moldeca duque son tito, sen diosi joe tilatinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Junnasa mantimini tsa Diosi junca jera quirato, yalacanan jera telaqueponue yape tsaboca tennato nenalarasa. Diosica cuwenta tsaboca tenca taminlanue. Aman matu to tsachi manca Diosichi mantate pamin joto, junca cuenta quinue tinue. Diosi itsantinueque chuteca joe tinue: Israelítala, nula junpalu chunca wata fecári niyanlanantiya chutunun tobi nenaminnan, animalica toteto cuwanato, lachi cuwalaquitue tinue. Uyanlachi cuwalaquee tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moloc tinunbe rocaito, yachi yanan quiran nacáca nanalaquee tinue. Tsabo mancaca Renfán mumun diosi joe tito, yaca se tilatie tinue Diosica cuwenta. Manan Molobe Renfanbe tsan quiran moldesiri joe. Nula patsanan nulachi tedechi molde quito ya moldechi cale telenhilainae tinue. Junni tsan quiranlaca tennanun tenchi nulaca casticaqueyanae tinue. Nuwiri Babilonia to banachi ereyanae tinueque chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Junni Esteban Diosichi mantate pamin tsachi pila chutecaca tsanque manpatobi, itsantinue: —Junni aman niyanlanantiya chutunun tobi canenato, Moisés Diosichi tenchi jali ya quinue tinue. Diosi yabe cuenta quito, itsanque ya quede! tica jominue tinue. Junni Moisés jun tsanquenan Diosichi tenchi jali ya quinue. Tsanque chiquilachi matu to familiala Diosichi yaca taminlanue tinue. Jun yaca quirato, tsarasica Diosica tenca cantsan jominue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aman yalari puyanunbi, yalachi nalalaman Diosichi jali yaca taminlanue. Junto Josué yalachi miya joto, Diosichi jali yaca in toca tanjalainue tinue. Aman jun mate uyan ni tsachila in tobi chumin jominlanue tinue. Junni Diosi patsa yalaca larito suerenue yape israelítalari inte chularasa. Tsanque Diosichi jali ya in tote chuminue tinue David israelítalachi miya ino fecári. ");
INSERT INTO cofNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diosi Davica seque tenca camin jominue. Junni Daviri Diosibe itsanque rocainue tinue: Matu to Jacobo sonnano male nechi israelítala nube penenaminla joyoe. Junto nuchi tenchi tsa ya quino muquee tinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","David mantimini Diosichi ya quino podeitusanan, yachi nao Salomón Diosichi yaca quinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Junni tsachila Diosichi tenchi ya quica josanan, Diosi jun yabisiri chutuchunae. Diosiri fe jamochi chue. Tsachi manca Diosichi mantate pato, junca itsanque pila chutenue tinue: ");
INSERT INTO cofNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yoquido Diosi mantato chudinun cuwentasiri joe tinue. Tori Diosi tereranun teranca cuwenta joe tinue. Tsan jonari, ¿nulari Diosichi tenchi niyan quiran ya quilaquichun? tinue. ¿Diosi tile jasaino jochunan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ya tenca mánta jera quiyoe tinueque chuteca joe. Diosichi mantate pamin tsanque Diosichi fiquica pila chuteca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Junni Esteban israelítalaca matu male nechi tsanque jera cuenta depolariquetobi, israelita mantaminlabe itsantinue: —Chiquilachi matu to familiala tsanquenan Diosichi Tencaca natiya merátuchi tito nenaminlanue. Junni nulanan jun tsanquenan merátuchi timinla joe tinue. Uyan tala tenca talarae. Nula Diosica merátumin tenca jolajoe. Diosichi itonla cuwenta natiya merátuminla joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aman chiquilachi matu to familialari jerale Diosichi mantate paminlaca seiton quimin jominlanue. Ya Diosichi mantate paminlari pato, sen tsachi jano joe latinue. Junni chiquilachi matu to familialari tsantiminlaca totelaquinue tinue. Junni nulaman ya jano jomin sen tsachicanan totesa carilaquinue. Uyanlachi cuwapoto, yaca totesa carilaquinue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diosi matu tote anjelilaca erenue yape Diosichi mantaca cuwalaquisa. Junni nulari ya Diosichi mantaca tatonan, natiya merátuminla joe tinue. Aman Esteban tsanque israelita mantaminlabe cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Junni israelita mantaminlari Estébanchi fiquica meráto, duque pailainue. Pachi tefun dato dato quinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tsan josanan, Esteban Diosichi Tencabe seque jera mantaito, jamochi quirato, Diosichi toca quiranue. Diosicanan tsara senca quiranue. Junsi Jesúcanan Apa Diosichi tsa tede nanchi wiruraminca quiranue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Junni Esteban junca jera quirato, itsantinue: —Quiralaquede! Yoquido lasaicaca quiranayoe tinue. Diosichi tsa tede nanchi Jesús tsachi ica jun joto wirurae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Junni ya fiquica merasi, israelita mantaminlari sonba pato, pachi punquica dole calaquinue merátuchique. Junsi layaito, Estébanchica sujito calaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Junni Estébanca pueblobi nechi muricade tanjito, su walaca tala quito totelaquinue. Junni su walaca tala quinaminla yalachi camisa larito, manca mosochile tsorelaquinue yape ya cuidaisa. Ya moso Saulo mumun jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Junni Estébanca su walaca tala quilaquinasanan, yari itsanque Jesube rocainue: —Miya Jesús, lachi tencaca cade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Junsi telenhito, sonba pato itsantinue: —Miya Jesús, inlaca in jutsa tenchi culpa quituna! tinue. Junni tsantisi puyanue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Junni Diosica tenca tan tsachila Esteban puyacaca duque laqui tito menalaquinue. Aman israelita mantaminla Estébanca totelaquinasa, Sáulonan yaca totenilaquede! petinaminue. Junni jun male nechi Jesucrístochi tsachila Jerusalenbi duque padeseilainue. Seitonla yalaca Jesucrístobe penenaminla jonun tenchi padeseisa carinaminlanue. Sáulonan Jesucrístobe penenaminlabe duque seiton pejominue. Jesucrístobe penenaminlachi ya cura wito, yalaca muricade larito tanjinue. Unilalacanan, sonalacanan cato jera donue. Junni Jesuchi tsachila ara cura jera jilainue Judea tobinan, Samaria tobinan. Crístochi mantá tanlasiri ara cura jilaitunue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Junni aman Jesucrístobe penenaminla ara cura sujinato, Diosichi sen fiquica cuenta quedede jilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Junni Felipe Samaria toca jito, pueblo máncabi wito, Jesucrístoca jera cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Jun pueblobi yucanchi ocola duque tsachilachibi wica jominlanue. Junni Felíperi yucanchi ocolaca mansularinan, tsachilaca purato, sonba atide sujilainue. Felipe duque jancanlacanan, duque wecaino podeituminlacanan manse suwanue. Felipe tsanque wepanato quirantsancari seque quinaminue yape tsachila Diosica tenca calaquisa. Aman tsachilari junca jera quirato, Felipe pánanunca jera meráto, jeralela yaca seque meralaquinaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Junni jun pueblobi chuminla tsara son tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tsan josanan jun pueblobi manca tsachi chuminue Simón mumun. Yari pone joto, duque podenyoe timin jominue. Jerale Samaria tobi chuminlaca wepanarinaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Junni epe tsachilanan, mantaminlanan, yaca meraniquimin jominlanue. Ya pone tsachi Diosichi mantate duque sonba quimin joe latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ya Simón numarile nechi pone joto, yalaca encananaminue. Junnan yaca duque merámin jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Junni Simón tsantin chusanan, Felipe Jesucrístoca cuenta quebi janue. Diosi ya mantananun tsachi bolon suwananuncanan micarinaminue. Junni duque tsachila, unilala, sonala, Felipe cuenta quinaminca quereito mumunhilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Junsi Simonnan quereito mumunhito, Felípebe penenaminue. Felipe mantimini duque wepanato quirantsancari seque quinaminue yape tsachila Diosica tenca calaquisa. Junni Simonni junca quirato duque wepananue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Junnasa mantimini Crístochi mantá tanlari Jerusalenbi chuto meralaquinue Samaria tobi chuminlanan Diosichi fiquica seque meralaquinueque. Junca meráto, Pédrobe Juánbeca junchi erelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Junni Pédrobe Juanbe Samáriaca patito, Jesucrístobe penenaminlachi tenchi Diosibe rocailainue. Diosibe rocaito, nuchi Tencaca inlachibi erede! tilatinue yape yalachibi wito chusa. ");
INSERT INTO cofNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aman Diosichi Tenca yalachibi cawica itominue. Jesuchi icayoe titori mumunhica jominlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Junnan Pédrobe Juanbe Jesuchi tsachilaca tedechi tale quilaquinue. Junni tsanquinan Diosichi Tenca yalachibi winue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aman Simonni junca jera quirato miito, aman Crístochi mantá tanlabe itsantinue: ");
INSERT INTO cofNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Lachinan tsanque mantá cuwade! tinue yape lanan mocatiya tedechi tale quinan Diosichi Tenca ya tsachichibi wisa. La cala cuwanae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro mantimini ya Simonbe beconan manpato, itsantinue: —Nu nuchi calabe yucapiyade! tinue. Diosi epe cuwanacaca calachi cantsan joeque tenca canun tenchi padeseichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nuri natiya Diosichi tenchi titiya pequimin itoe tinue. Nu Diosibe seque nenatumin joe; epele tenca cato nenamin joe. ");
INSERT INTO cofNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Junni in jutsaca telaquepoto, casan tala tenca mancade! tinue. Junsi Diosibe rocaide! Pansile seitonque tenca cananunca perdonaichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","La nuca mirayoe tinue. Nuri fe mantá tachi tito, nuchi tenca duque seiton joe. Nuchi tenca jutsabe cadenachi telepoca jun cuwenta joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pedro tsantinunsi, Simón beconan pato itsantinue: —Pedro, nulanan lachi tenchi Miya Diosibe rocailaide! tinue yape laca tsanque padeseisa caritusa. ");
INSERT INTO cofNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Junni Pédrobe Juanbe Miya Jesucrístoca jera cuenta quetobi, Jerusalenca manjilainue Samaria tose poleto. Duque pueblobi wide wide jito, Jesucrístoca paca sen fiquica cuenta quedede manjilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Junni Miya Diosichi anjeli Felípebe itsantinue: —Wiruito jide! tinue. Nuri butunni tala jito, Gaza tinun puebloca jinun minuca jide! tinue. Aman Gázaca jinun minuri niyanlanantiya chutunun postose polenun minu jominue. Jerusalenbi nechi Gaza fecári jinunhe. ");
INSERT INTO cofNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Junni Felipe anjelichi fiquica merasi, wiruito jiniinue. Junni ya minuse jinasa quiranari, Etiopía tsachi jinaminue. Etiopía to miya sona Candace mumun jominue. Junni ya tsachiri Candácechi tenchi tesorero jominue eunuco tinun tsachi. Yari Jerusalén puebloca Diosibe rocaibi jica joto ");
INSERT INTO cofNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","manjinaminue. Calu muricanun carobi chudito, Diosichi Pilaca quiradede manjinaminue. Aman matu to tsachi Isaías mumun Diosichi mantate pila chuteca jominue. Junni Etiopía tsachi ya pilaca quiradede manjinaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tsan josanan, Diosichi Tencari Felípebe itsantinue: —Ja carobe parejo parejo jinade! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Junni Felipe caroca sujito, Etiopía tsachica Diosichi Pila quiranaminca meránue. Isaías Diosichi fiqui chutecaca quiranaminue. Junni Felipe itsantinue: —¿Jun pilabi niyan tinan? ¿Entendeinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Junni Etiopía tsachi itsantinue: —Monantiya micaritunari, miitiyoe tinue. Tsantisi, nuri lade! Lato chudide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aman Isaías chuteca jun pilabi itsanque chuteca jominue: Opisaca cuwenta totebi tanjichunae tinue. Jana opisa náca fu porecanasanan, atituto tsoniramanhe tinue. Junni yari jun tsanquenan beco patuchunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yaca lucarito seitonque quilaquichunae tinue. Yaca totelaquichunae tinue. Yabe parejo pesonnaminlari patuntsancari seiton jolajochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Junni Etiopía tsachi ya pilaca quirato, itsanque panhanue: —Nu pade! tinue. ¿Mo tsanque padeseino jun? tinue. ¿Isaías patsa, o uyan? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Junni Felipe yabe tulanto cuenta quito, Jesuca paca joe tinue. Ya tsanque padeseica joe tinue. Junni Felíperi casale Isaías chutecaca cuenta quito, junsi Jesuca paca sen fiquica jera cuenta quinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Junni minuse jinaminnan, pi quelole polelainue. Junni Etiopía tsachiri itsantinue: —Quirade! Ina pi poe tinue. ¿Lari mumunhino podeino joinhin? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Junni Felíperi itsantinue: —Nuchi tencabi Jesucrístobe jera cayaitori podeichunae tinue. Junni Etiopía tsachiri manpato, Jesucristo Diosichi Nao joeque quereiyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsantisi, caroca tsoresa carito, Felípebe Etiopía tsachibe pibi patilainue. Pibi wito, Felipe yaca mumunnue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Junni pibi nechi manlonaminnan, Felipe piyapoleniinue. Miya Diosichi Tenca yaca piyapolarinan, Etiopía tsachi Felípeca manquiratunue. Etiopía tsachi mantimini son tide manjito polenue. ");
INSERT INTO cofNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Junni Felíperi Azoto pueblobi manquirainue. Junsi Azótobi nechi Cesarea puebloca jinue. Junni Cesaréaca jinato, pueblo cura Jesucrístoca paca sen fiquica micaridede jinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Aman junnasa Saulo mantimini Miya Jesucrístobe penenaminlaca duque pa canenaminue. Tsaracari toteyanaequesiri pato nenaminue. Tsan jominnan israelítalachi mantá tan patelechica jito, ");
INSERT INTO cofNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yabe rocainue donun pilaca cuwasa. Junni donun pila casi, Damasco puebloca jinaminue. Jun puebloca jito, Diosichi fiqui miinun yabi ya donun pilaca mancuwano jominue. Junto Jesucrístobe penenaminlaca neyato féto catori, mantanjino jominue jun patelechi donun pilachi. Jesucrístobe penenaminlaca cato, Jerusalenca doquebi mantanjino jominue unilalacanan, sonalacanan. ");
INSERT INTO cofNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Junni aman Saulo Damasco pueblo quelobi jinasa, jamochi nechi tiri cuwenta duque tsequiniquinue yachi awinta. ");
INSERT INTO cofNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Junni Sáulori tobi queereito, fiquica meránue. Itsantinue: —Saulo, Saulo, ¿nuri laca ti quichun seiton quinayun? tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ya fiquica merasi, Saulo itsantinue: —Miya, ¿nuri moyun? tinue. Junni beconan pato itsantinue: —Jesúyoe tinue. ¿Ti quichun laca seiton quinayun? tinue. Laca seiton quinato, nu tencachiquenan fécari padeseinae tinue. Nuri calu chide teyanca terachi quimin cuwenta jochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Junni Saulo duque wepanachi jowinponato itsantinue: —Miya Jesús, ¿la ti quino jowan? tinue. Junni Miya Jesucrístori Sáulobenan itsantinue: —Mancupato, puebloca jide! tinue. Junbi tsachi manca nube cuenta quichunae tinue ti quino jonunca. ");
INSERT INTO cofNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tsanhinasanan, Sáulobe pejinaminla jelechi pano podeitulajonue. Fiquica meránato, mocanantiya quiratulajonue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Junni Saulo tobi nechi mancupato, caca mantsetonan, quirano podeiton inue. Junnan yaca tedele cato Damáscoca tanjilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Junni peman ma fecári quirano podeiton, ano fitumin, pi cuchitumin, jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tsan josanan Damáscobi manca tsachi chuminue Ananías mumun. Yanan Jesucrístobe penenamin jominue. Junni Ananíachi quirajanasa Miya Jesucrístoca quiranue. Junni Jesucristo yabe pato, Ananías tinue. Junni Ananíari Miya tinue. Ina chuyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Junni Miya Jesucristo Ananíabe quiraito, itsantinue: —Nuri cupato, Júdachi yaca jide! tinue. Ya Júdari Derecha tinun cayebi chue tinue. Junchi jito, Saulo tinunca panhade! tinue. Ya Saulo Tarso pueblobi nechi joe. Yari tsaina labe rocainae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Junni Sáulonan labe rocainasa, yachinan quirajaca joe tinue. Yachi quirajanasa, nuca janaminca quiraca joe. Nu yaca tedechi tale quebi janaminca quiraca joe tinue. Junni nu yaca tale quinunsi, Saulo manquirano podeichunae tinue. Sáulochi tsanque quirajaca joe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Junni Jesucristo yabe tsantica josa, Ananíanan beconan pato itsantinue: —Miya Jesús, ya Sáulori seiton joe tinue. Yaca duque mera joe tinue. Jerusalenbi nuchi sen tsachilaca duque padeseisa carinaminue latie tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Junni in pueblocanan jato, mantá tan patelelachi mantate jaca joe tinue nube rocaiminlaca cato jera dochun. ");
INSERT INTO cofNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Miya Jesús mantimini Ananías tsantinunca tennatuto, yabe itsantinue: —Nuri jiniide! tinue. Lari Sáuloca wentecayoe tinue. Yari laca cuenta polarimin jochunae. Uyan tobi chuminlabe, mantaminlabe, israelítalabenan laca cuenta polarimin pejochunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yaca micarichinayoe tinue yanan lachi tenchi duque padeseino joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Junni Jesucristo tsantinunsi, Ananíari Júdachi yaca jinue. Junbi fesi, Sáuloca tedechi tale quito itsantinue: —Aco Saulo, ¿nu janaminbe Miya Jesús quirainuco? tinue. Aman lanan Jesuchi joyoe tinue. Junni Miya Jesús ereca jun jayoe tinue yape nu manquirano podeisa. Junsi Diosichi Tencanan nuchibi jera pewichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Junni Ananías cuenta quinasaleri, Sáulochi cacabi nechi liquinan quiran bajinue. Tsanhinunsi manquirano podeinue. Junto mancupasi mumunhinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Junsi ano manfitobi, mansonbainue. Junni Damasco pueblobi Jesucrístochi tsachilabe nasi pechuminue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Junni Saulo mansonbaisi, israelítala tala Diosichi fiqui miinun yabi winue. Junbi Jesuca paca fiquica micarinaminue Diosichi Nao joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aman junni junbi chuminla Saulo pánanunca meráto, jera wepanalaito itsantilatinue: —¿Inni Jesucrístoca pa jomin tsachi jotun? latinue. Aman yari Jesube rocaiminlaca Jerusalenbi duque seiton quinaminue. Inchi janatonan, yalaca cabi janaminue tilatinue mantá tan patelelachica mantanjichun. Tsan jotori, ¿niyaito Jesucrístoca paca fiquica micariniquinan? latinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tsanlatinasanan Sáulori fe seque pade pade jiniinaminue. Damáscobi chumin israelítalari yaca meráto, beconan manpano podeilaitunue. Tenca jera palaicala joto podeilaitunue. Saulo mantimini seque micarinaminue Jesús Diosi wenteca Cristo tinun tsachi joeque. ");
INSERT INTO cofNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Junni Saulo numari micarinasanan, israelítala tenpalaquinue yaca totechun. ");
INSERT INTO cofNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Junni aman jun pueblo awinta wa serica jominue tamo cuwenta. Junni israelítala jun serica tamolante quirato Sáuloca méraminlanue. Quepen, malon méraminlanue Sáuloca cato totechun. Saulo mantimini junca jera meránue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Junni Jesuchi tsachilari yaca se larilaquinue yape totelaquitusa. Quepen nosa epele jun pueblobi nechi manlarilaquinue. Tsalabi poto, serica urachi manpatarilaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aman Sáuloca manlarilaquinan, Jerusalenca manjinue. Junbi Jesuchi tsachilabe layaichique tenfenasanan, yalari jelechi facaritulajonue. Nene joe tito, Jesucrístochi tsachi iton jonhoe tilatinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabé mantimini Sáuloca cato, Crístochi mantá tanlachica tanjinue. Junchi tanjito, Crístochi mantá tanlabe itsantinue: —In Saulo minuse jinasanan Miya Jesús yabe quiraito cuenta quinue tinue. Junni Damasco pueblobi Jesuchi mantate seque jeleratuto micarinaminue tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Junni Bernabé tsantinunbi, Saulo Jerusalenbi pechuto, yalabe penenaminue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Miya Jesuchi mantate seque jeleratuto micarinaminue. Griego fiqui pamin israelítalabe pacaanaminue. Junni yalaman Sáuloca paito totechi tinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Junni Jesucrístochi tsachilari junca miito, Sáuloca Cesarea puebloca tanjito Tarso puebloca manherelaquinue yape yaca totelaquitusa. ");
INSERT INTO cofNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Junte nechi Judea tobi, Galilea tobi, Samaria tobi, Jesucrístochi tsachi bolonla pansi chuto sonba tenca jera ilainue. Miya Diosica respetaito jelerato chuminlanue. Diosichi Tenca yalachi seque tenca cuwanan, serade serade jinaminlanue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Junni aman Pedro jerale Jesucrístobe penenaminlaca quiradede nenaminue. Junto Lida pueblocanan jito, junbinan Diosichi sen tsachilaca quirabi jinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aman junbi féto quiranari, jancan tsachi manca tsominue Eneas mumun. Ya Enéari wecaino podeituto, ochu wata fecári cupano podeiton tsominue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Junni Pédrori yabe itsantinue: —Eneas, Jesucristo nuca tsaina manse suwanae. Cupato, jalica mantepade! tinue. Junni Pedro tsantinasaleri, Eneas mancupanue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Junni jerale Lídabi chuminla, jerale Saronbi chuminla junca quirato, Miya Jesucrístobe cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Junnasa mantimini Jope pueblobi Jesucrístobe penenamin sona manca chuminue Tabita mumun. Aman Griego fiquichi paminla yaca Dorcas timin jominlanue. Ya sona tsarasi seque quito, titiya itonlachi duque epe cuwamin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aman Pedro Lídabi nenasanan, Tabítari duque quiyaito puyanue. Junni puyacaca pipiyarito, jamo tamobi tsorelaquinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Aman Jope pueblori Lida quelote joe. Junni Jesucrístochi tsachila meraca jominlanue Pedro Lídabi raeque. Junni paluca tsachilaca erelaquinue yape Pédroca we jade! latisa. ");
INSERT INTO cofNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pédrori junca merasi, yalabe pejinue. Junni Jópebi manfalainunsi, Pédroca jamo lowabi tanloto puyaca sona tsonunbi tanlolainue. Aman Tabita casonnaminnan, biudalachi tenchi duque camisa, panu, titiya quito epe cuwamin sona jominue. Aman Pédrochi awinta jun camisa tsanlaca quirawoto, wareto wiruilainue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Junni Pedro mantimini piyanlelaca urachi lolaide! tito, mancasiri telenhito Diosibe rocainue. Junni Diosibe rocaitobi, ya sona puyacaca manquirato, itsantie: —Tabita, mancupade! tinue. Junni Tabítari caca mantsequiniquito, Pédroca quirato mansonhinue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Junni Pedro yaca tedele cato mancuparinue. Junto biudalaca, Diosichi uyan tsachilaca, jeralelaca manhoticanue. Junto Tabítaca sonca yalachi manquirawonue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Junni jerale Jópebi chuminla junca miito, layanla Jesucrístobe cayailainue. ");
INSERT INTO cofNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Junni Simón Pedro Jope pueblobi numari fecári manca Simonbe pechuminue. Aman ya Simonni quidoca cato se suwamin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aman Cesarea pueblobi soldado capitan manca jominue Cornelio mumun. “Italiano” tinun bolonbi mantamin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yabe yachi familialabe Diosica respetaito jelerato, seque tenca camin jominlanue. Israelita itotonan, popere israelítalachi tenchi duque cala cuwamin jominue. Diosibe ma cura rocaimin jominue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Junni manca mate tre de la tardete Cornéliochi ura jera quirajanue. Anjeliri Diosi ereca jun jato, Cornelio tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornéliori anjelica duque jelenasa quirato, itsantinue: —Miya, ¿niyan jun? tinue. Junni anjeli yabe itsantinue: —Nu Diosibe rocain, poperelachi titiya cuwan, quimin joe tinue. Junnan Diosi nuca mantenhinae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Junni nuri tsachilaca Jope puebloca ereto, Simón Pédroca jasa caride! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yari quidoca cato se suwamin Simónchibi chue tinue lamari quelote. Junni Pédrori inte jato, nu ti quino jonunca jera micarichunae tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Junni anjeli manjinunsi, Cornelio pemanca tsachilaca jade! tinue peyun palucaca soldado mancaca. Cornéliobe mantaimin soldado jominue Diosica tenca camin soldado. ");
INSERT INTO cofNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Junni yalabe jera cuenta manpolarinue anjeli cuenta quicaca. Junsi yalaca Jope puebloca erenue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aman ayuna nanchi ya tsachila Jópeca jalainasanan, Pedro terasabi lonue. Yotute Diosibe rocaibi lonue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Junnasanan Pédrochi duque ano muquinaminue. Junni Pedro ano acari mérasanan, yachi quirajanue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yoquido lasaraminca quiranue. Junni wa jali tsan patanue. Jali junpalu puntabi tela jun to fecári patanue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Junni jun jalibi duque animalila pominue. Quela, susu, pini, baro, titiya pominue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Junni Pedro junca quiranaminnan fiqui meránue. Itsantinue: —Pedro, cupade! In animalilaca toteto fide! tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro mantimini beco pato itsantinue: —Te, fino miitoyoe tinue. Miya Diosi, nu mirae. La fitununca numanan fitumanyoe tinue. Chiranlaca fitumanyoe tinue. ");
INSERT INTO cofNT_vpl VALUES ("AC10_15","074_10_15