﻿USE sofia;
DROP TABLE IF EXISTS sofia.coe_vpl;
CREATE TABLE coe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES coe_vpl WRITE;
INSERT INTO coe_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aperʉmʉ pa'isina Jesucristo aipãi paasina mamire kʉajʉ tochasi'ea'me ie. Davina'me Abraham repaʉ aipãi paniasome. ");
INSERT INTO coe_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mamakʉ Isaac paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá mamachĩi Farena'me Zara paniasome. Repana pʉka'ko Tamar paniasomo. ");
INSERT INTO coe_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mamakʉ Aminadab paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón mamakʉ Booz paniasomʉ. Pʉka'ko Rahab paniasomo. ");
INSERT INTO coe_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí mamakʉ David paniasomʉ, pãi jainʉkore chʉ̃'ʉsi'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón mamakʉ Roboam paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mamakʉ Josafat paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías mamakʉ Jotam paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías mamakʉ Manasés paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías mamachĩi Jeconíana'me repaʉ cho'jechĩi pa'irʉmʉna Babilonia cheja cana sani Israelpãi chẽa repana pa'ichejana sasõasome. ");
INSERT INTO coe_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Repanare sasõsirʉmʉ pa'isina Jesús aipãi mamia'me ie: ");
INSERT INTO coe_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel mamakʉ Abiud paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mamakʉ Sadoc paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mamakʉ Eleazar paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob mamakʉ José paniasomʉ, María ʉ̃jʉ pa'isi'kʉ. Repao María, Jesús, pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉ chiicojñokʉ pʉka'ko paniasomo. ");
INSERT INTO coe_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham pa'irʉmʉpi David pa'irʉmʉjatʉ'ka repaʉ Abraham jojosina catorcerepana paajʉ saniasome. Ũcuachi'a David pa'irʉmʉpi Israelpãi Babilonia cheja chẽa sacojñorʉmʉjatʉ'ka David jojosina catorcerepana paajʉ saniasome. Ũcuachi'a Israelpãi repana Babilonia cheja chẽa sacojñorʉmʉpi Dios Raosi'kʉ Cristo'te jñaarʉmʉjatʉ'ka repana paasina catorcerepana paajʉ saniasome. ");
INSERT INTO coe_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo'te jñaasi'e ija'cheasomʉ: María repaʉ pʉka'ko Josere pasa chiikojeko so'opi paniasomo. Jã'ata'ni repana chuta'a veja kueñe pa'imarʉmʉna María te'eo pa'ikoji Dios Rekochoji jo'kaʉna chĩi sʉniasomo. ");
INSERT INTO coe_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Repaoji chĩi sʉnisõona José repao'te paara chiikʉ re'okʉjekʉ, “Pãipi repao chĩi sʉ'isi'e asa cu'ache i'kajanaa'me repao'te”, chini cuasa chekʉnare pãi kʉa jñauma'ñe repao'te rope'e jo'kasõʉache cuasaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jã'aja'ñe cho'ora chini cuasakʉta'ni repaʉ ʉokãisirʉmʉna ángel, Dios raosi'kʉ rani ija'che i'kaasomʉ repaʉ'te: —José, David jojosi'kʉ, María'te paavajʉchʉma'ñe veja paajʉ̃'ʉ. Repao sʉ'ipʉ chĩipʉ Dios Rekochoji jo'kaʉna sʉ'imo repao. ");
INSERT INTO coe_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chĩiva'ʉre ʉmʉva'ʉni paaja'mo repao. Repao María chĩiva'ʉre jñaasirʉmʉ Jesure ve'ojʉ̃'ʉ repava'ʉre. Pãi cu'ache cho'osi'e jũni ro'ikaijaʉjekʉ jã'aja'ñe ve'eja'mʉ repaʉ —chiniasomʉ ángel repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Peore jã'a Diopi i'kaʉna aperʉmʉ Repaʉ chʉ'o kʉasi'kʉ kʉakʉ tocha jo'kasi'epi ũcuarepa ti'jñesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ija'che chiimʉ repaʉ kʉakʉ tocha jo'kasi'e: Romichĩio ʉmʉʉ'terejẽ'e ja'me kãima'kopi chĩi sʉni, chĩiva'ʉre ʉmʉva'ʉni paaja'mo. Repava'ʉre pãi, Emanuelre ve'ojanaa'me, chiimʉ. (“Emanuel” chiiche “Dios maina'me pa'imʉ” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ũcuarʉmʉ José repaʉ kãni vʉisirʉmʉ ángel Dios raocojñosi'kʉ chʉ̃'ʉ jo'kasi'e cho'okʉ, María'te paara chini vejaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jã'ata'ni repana vejasirʉmʉ, chĩiva'ʉre jñaañejatʉ'ka ja'me kãima'ñe paniasome. Repaʉ rʉ̃jo chĩiva'ʉre jñaasirʉmʉ José ángel repaʉ'te ra kʉasi'ere mami, Jesure ve'oasomʉ repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes chʉ̃'ʉrʉmʉna Judea cheja cajoopona Belén vʉ'ejoopona jñaasiva'ʉasomʉ Jesús. Reparʉmʉ vañʉʉji ʉ̃sʉʉ mʉikã'kore pa'iʉna ʉmʉpãi repakã'ko pa'ina ma'jñoko pa'iche che'chenajejʉ ña masi, Jerusalén vʉ'ejoopona so'opi raniasome. ");
INSERT INTO coe_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rani tĩ'a repacheja pa'inare ija'che sẽniasaasome repana: —Chĩiva'ʉ, chura jñaasiva'ʉ judíopãi chʉ̃'ʉjava'ʉ, ¿jeechejare pa'ikʉ? Repaʉ'te jñaasi'ere kʉakʉ ʉ̃sʉʉ mʉikã'kore pa'iʉna vañʉʉ'te ñasinajejʉ repava'ʉni ro're pʉʉ ñu'ijʉ pojoñu chini ku'eme chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes repacheja chʉ̃'ʉkʉ repana i'kasi'ere chekʉnapi kʉarena asa, rʉa cuasaasomʉ. Jerusalén vʉ'ejoopo cana ũcuaja'che ũcuanʉko asa, rʉa cuasaasome. ");
INSERT INTO coe_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ũcuarʉmʉ Herodes jã'aja'ñe asa, cuasakʉ judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonare repaʉ pa'ivʉ'ena rani chi'ia'jʉ chini chʉ̃'ʉasomʉ. Rani chi'irena repanare, —Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raojaʉ, ¿jeechejana repaʉ'te chĩire jñaajanaa'ñe? —chiiʉ sẽniasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chikʉna i'kaasome repana repaʉ'te. —Judea cheja cajoopona Belén vʉ'ejoopona jñaajaʉasomʉ repaʉ. Aperʉmʉ Dios chʉ'o kʉasi'kʉ repaʉ'te jñaajachejare kʉakʉ tocha jo'kasi'e ija'che kʉamʉ: ");
INSERT INTO coe_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Mʉsanʉkona Judea cheja cajoopo Belén vʉ'ejoopo cana, “Ʉjajoopo, pa'ipãi pa'ijoopo pa'imanaa'me mai”, chiimanejʉ̃'ʉ. Mʉsanʉkona pa'ijoopo cajacojñojaʉ Israelpãi ũcuanʉkore chʉ̃'ʉja'mʉ. Ũcuaʉji chʉ'ʉ neenare Israelpãi mʉsanʉkonare kuirakʉ re'oja'che chʉ̃'ʉkʉ pa'ija'mʉ, chiimʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chitena asa Herodes, vañʉʉ pa'isirʉmʉre masira chini ma'jñoko pa'iche che'chenare rope'e soni rao, —Repaʉ vañʉʉ, ¿jeejarʉmʉna pakʉ? —chikʉna repaʉ'te kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kʉarena asa repanare ija'che i'kakʉ Belén vʉ'ejoopona saoasomʉ repaʉ:— Belén vʉ'ejoopona sani repaʉ chĩiva'ʉ pa'iche peore sẽniasajaijʉ̃'ʉ. Repava'ʉre ku'e jñaani ra kʉajʉ̃'ʉ chʉ'ʉre. Chʉ'ʉ ũcuaja'che repava'ʉre sani ro're ñu'iʉ pojora chiimʉ —chiiʉ joreasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pãi chʉ̃'ʉkʉji jã'aja'ñe i'kakʉ chʉ̃'ʉʉna asa saniasome repana. Saijʉna repana ʉ̃sʉʉ mʉikã'ko ñasi'kʉ vañʉʉ jo'e pa'iʉ repana saima'a sẽ'sevʉji charo saniasomʉ. Saiʉ chĩiva'ʉ ũhivʉ'e sẽ'sevʉna canʉkaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Vañʉʉ canʉkache ña rʉa pojoasome repana. ");
INSERT INTO coe_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jã'aja'ñe canʉkaʉna ña ũcuavʉ'ena kaka chĩiva'ʉna'me pʉka'ko María'te ñaasome repana. Repava'ʉre ña ro're ñu'ijʉ pojoasome repana repaʉ'te. Pojocuha repana rasi'e cãjovʉã vata pachokurina'me sũkima'ñana'me chekʉñʉãquee ma'ña ĩsiasome repana repava'ʉre chĩiva'ʉre. ");
INSERT INTO coe_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Repava'ʉre ñacuha pa'ijʉ repana ʉokãitona Dios i'kasi'e ija'che chiiche'te asaasome repana, “Herodes pa'icheja saima'ñe tĩima'api co'ijʉ̃'ʉ mʉsanʉkona”, chiiche'te. Asa repacheja saima'ñe tĩima'api repana pa'ichejana co'isõasome repana. ");
INSERT INTO coe_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma'jñoko pa'iche che'chena sanisõsirʉmʉna Dios neekʉ ángel Josere repaʉ ʉokãisirʉmʉna rani ija'che i'kaasomʉ: —Vʉni mʉ'ʉ jojava'ʉna'me pʉka'kore Egipto chejana pesa sajʉ̃'ʉ. Herodes mʉ'ʉ jojava'ʉre vanisõñe'te chʉ̃'ʉra chini ku'eja'mʉ. Jã'ajekʉna sani chʉ'ʉ mʉ'ʉre, “Co'ijʉ̃'ʉ”, chiirʉmʉjatʉ'ka pa'ijʉ̃'ʉ repacheja —chiniasomʉ ángel repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jã'aja'ñe i'kaʉna asa José vʉni ũcuañamipi repaʉ jojava'ʉna'me pʉka'kore sakʉ Egipto chejana sanisõasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sani Herodes jũnisõsirʉmʉjatʉ'ka repacheja paniasome repana. Jã'aja'ñe cho'orena Dios chʉ'o aperʉmʉ kʉasi'kʉ tocha jo'kasi'epi ija'che kʉacheji ũcuarepa ti'jñecuhasi'kʉa'mʉ, “Chʉ'ʉ chĩire Egipto cheja pa'ikʉni raaʉ chini soimʉ chʉ'ʉ”, chiicheji. ");
INSERT INTO coe_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ũcuarʉmʉ Herodes ma'jñoko pa'iche che'chena repaʉ'te jorejʉ tĩima'api co'isõsi'ere asa rʉa pe'rukʉ, repana ñasi'e kʉasi'ere jo'e cuasa, “Chura repaʉ chĩi ka'chaʉ̃sʉrʉmʉ panicuhamʉ ie”, chini cuasa Belén vʉ'ejoopona'me ũcuajoopo kueñe pa'ichejña cava'nare chĩiva'nare ʉmʉchĩiva'narechi'a te'eka'chapaʉ̃sʉrʉmʉ pa'iva'nana'me na'a cho'je pa'iva'nare ũcuanʉkore vanisõñe chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Repaʉji jã'aja'ñe cho'oʉna aperʉmʉ Dios chʉ'o kʉasi'kʉ Jeremías ija'che chiiche tocha jo'kasi'epi ũcuarepa ti'jñecuhaasomʉ: ");
INSERT INTO coe_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá cheja pa'ina ota oiche rʉa asoasomʉ. Raquelpi, repao mamachĩipi chuenisõrena oio paniasomo repa. Repaoji cuhaa'ko chini pãi, “Oimanejʉ̃'ʉ”, chinite'easome repao'te. Jã'ata'ni ũcua cuhama'ñe oniasomo repao mamachĩipi chuenisõrena, chiicheji. ");
INSERT INTO coe_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na'a pa'isirʉmʉ Herodes jũnisõsirʉmʉna Josere Egipto cheja pa'ikʉni repaʉ ʉokãisirʉmʉna Dios neekʉ ángel rani ija'che i'kaasomʉ repaʉ'te: ");
INSERT INTO coe_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Vʉni mʉ'ʉ jojava'ʉna'me pʉka'kore sakʉ Israel chejana jo'e co'ijʉ̃'ʉ. Mʉ'ʉ jojava'ʉre vanisõñu chiisina jũnisõcuhasinaa'me —chiniasomʉ ángel repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ũcuarʉmʉ José jã'aja'ñe i'kaʉna asa vʉni chĩiva'ʉna'me pʉka'kore Israel chejana saasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Jã'ata'ni José Herodes mamakʉji Arquelaopi Judea cheja canani chʉ̃'ʉa'kʉ chini jo'kacojñosi'ere asa Judea cheja saivajʉchʉasomʉ. Ũcuaja'che repaʉ ʉokãisirʉmʉ asa masisi'e Diopi, “Judea cheja saimanejʉ̃'ʉ”, chiisi'ejekʉna Galilea chejana saniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Repacheja sani tĩ'a Nazaret vʉ'ejoopo'te paniasomʉ repaʉ. Jã'aja'ñe cho'orena aperʉmʉ Dios chʉ'o kʉasina kʉajʉ tocha jo'kasi'epi ija'che chiicheji ũcuarepa ti'jñecuhaasomʉ, “Dios Raosi'kʉre, ‘Nazaret vʉ'ejoopo cakʉa'mʉ ikʉ’, chiijanaa'me pãi”, chiicheji. ");
INSERT INTO coe_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Reparʉmʉ Juan Pãi Okoro'vekʉ Judea cheja cachejare pãi peochejare sani pa'iʉ pãipi repaʉni sani chi'irena Dios chʉ'ore ija'che chiiʉ chʉ'vaasomʉ: —Mʉsanʉkona cu'ache cho'oche ũhasõ mama cuasajʉ̃'ʉ. Dios Raosi'kʉ pãi ũcuanʉkore chʉ̃'ʉpi'ramʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías repaʉ Juan cho'ojachere kʉakʉ ija'che i'kakʉ tocha jo'kaasomʉ: Pãiʉ pãi peochejare sani pa'iʉ pãipi repaʉni saito ʉjachʉ'opi ija'che i'kakʉ chʉ'vaja'mʉ: “Maire Paakʉ tĩ'api'ramʉ. Repaʉni cha'ajʉ mʉsanʉkona rekoñoã ma'a rũhiñe pa'ima'a care'vacheja'che re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ”, chiija'mʉ, chiiche tocha jo'kaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Repaʉ Juan ju'ikãa camello rañapi cho'osikãa paniasomʉ. Corejakãa va'i ca'ni kãare tʉ̃niasomʉ repaʉ. Ãu, pũ'suva'nana'me airo pũji ãiʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ũcuarʉmʉ Jerusalén vʉ'ejoopo pa'ina repacheja Judea cheja canana'me Jordán chiacha kueñe cachejña cana jainʉko repaʉ chʉ'vachʉ'ore asañu chini saniasome. ");
INSERT INTO coe_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sani repaʉ chʉ'vache'te asa repana cu'ache cho'osi'ere Dioni kʉarena Juan, Jordán chiachana okoro'veasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Reparʉmʉ Juan fariseopãina'me saduceopãi repaʉni okoro'vecojñoñu chini jainʉko satena ña ija'che i'kaasomʉ repanare: —Mʉsanʉkona te'ena chuta'a cu'ache cho'oche ũhamanajejʉ aña pa'icheja'che cu'ache pa'ime. “Maipi okoro'vecojñoru Dios maire cu'ache cho'omaneja'mʉ”, chini cuasajʉ raime mʉsanʉkona. ¿Neepi che'chorena jã'aja'ñe cuasache mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mʉsanʉkona cu'ache cho'oche'te ũhasõ re'oja'che pa'ijʉ Dios chʉ̃'ʉñe'te cho'ojʉ pa'ijʉ̃'ʉ. Mʉsanʉkonapi re'oja'che pa'ito chekʉnapi ñani, “Ina cu'ache cho'oche ũhasõsinajejʉ re'oja'che pa'ime”, chiijanaa'me mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ija'che cuasacosome mʉsanʉkona: “Abraham jojosinaa'me mai. Jã'ajekʉna Dios maire cu'ache cho'omaneja'mʉ”, chiijʉ cuasacosome mʉsanʉkona. Jã'aja'ñe cuasamanejʉ̃'ʉ. Dios chʉ̃'ʉñe cho'oma'me mʉsanʉkona. Diore Repaʉni cho'oʉato ira'karʉã catara'karʉãpi Abraham jojosinare chekʉnare cho'ore'omʉ, Repaʉ chʉ̃'ʉñe cho'ojanare. ");
INSERT INTO coe_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sũkiñʉã ãiñe kʉ̃iñʉãpi sãijapʉã kʉ̃ima'to, “Cu'amʉ iñʉã”, chini kueni ʉosõme pãi. Dios ũcuaja'che pãi cu'ache pa'inare cu'anajejʉna vati toana saomʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Chʉ'ʉ mʉsanʉkonare cu'ache cho'oche ũhasõsinare re'oja'che cho'okaiʉ okopi okoro'vemʉ. Na'a pa'isirʉmʉ chekʉ na'a rʉa masikʉji rani pa'iʉ na'a rʉa re'oja'che cho'okaija'mʉ mʉsanʉkonare. Chʉ'ʉre na'a rʉa masikʉjekʉna repaʉ'te cuasa, vajʉchʉkʉ pa'imʉ chʉ'ʉ. Na'a rʉa masikʉjekʉ repaʉ'te cuasanare Dios Rekocho'te ĩsija'mʉ repaʉ. Repaʉ'te cuasamanareta'ni ũcuaʉji chʉ̃'ʉʉna na'a pa'isirʉmʉna cu'ache ti'jñeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pãi trigo cho'oni po'te repacaã rũhikuanupʉ chi'i ũhame. Repasʉota'ni ʉosõme. Na'a pa'isirʉmʉ Raijaʉ pãi ũcuanʉkore chi'i trigo cho'ocheja'che cho'okʉ cu'ache cho'oche ũhamanare vati toana chachamatoana saoja'mʉ. Cu'ache cho'oche ũhasõ repaʉ'te cuasanareta'ni Pʉka'kʉ pa'ichejana saja'mʉ repaʉ —chiniasomʉ Juan repanare pãi. ");
INSERT INTO coe_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ũcuarʉmʉ Jesús Galilea cheja pa'isi'kʉpi Jordán chiachana Juan pa'ichejana saniasomʉ repaʉni okorocojñora chini. ");
INSERT INTO coe_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sakʉna Juan repaʉ'te okore rocuhekʉ ija'che i'kaasomʉ: —Mʉ'ʉpi chʉ'ʉre okorokairʉja'iʉji chʉ'ʉni rani, “Okorokaijʉ̃'ʉ chʉ'ʉre”, chiimʉ. Mʉ'ʉpi chʉ'ʉni rokaito na'a re'omʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jã'aja'ñe i'kaʉna asa repaʉ'te ija'che i'kaasomʉ repaʉ: —Cho'ocuhemanejʉ̃'ʉ. Dios chʉ̃'ʉ jo'kasi'e cho'oñu mai —chiniasomʉ repaʉ. Chikʉna Juan, “Jaʉ”, chini repaʉ'te Jesure okoroasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ũcuarʉmʉ Jesús okorocojñocuha chiacha nʉkasi'kʉpi po'ore mani nʉkakʉna cʉnaʉmʉ teana re'ojaʉmʉ care'o Dios Rekocho ũkupoja'iʉ ũcuaʉni cajekʉna ñaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dios Rekocho cajesirʉmʉ cʉnaʉmʉpi ija'che i'kache asoasomʉ: “Ikʉ chʉ'ʉ chĩi chʉ'ʉ oiʉ paakʉ'mʉ. Rʉa pojomʉ chʉ'ʉ ikʉre”, chiiche asoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ũcuarʉmʉ Jesús Dios Rekochoji chʉ̃'ʉʉna pãi peochejana sanisõasomʉ. Sani pa'iʉna vati ai repaʉni cacʉ'ora chini cu'are chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sani cuarentarepaumucujñana'me cuarentarepañami ãu ãima'ñe pa'iʉna ãucuhaasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ũcuarʉmʉ vati ai rani Jesuni cacʉ'ora chini ija'che i'kaasomʉ: —Mʉ'ʉpi Dios Mamarepakʉ pani ipʉã catapʉã mini, pãpʉã carʉñojʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chikʉna Jesús ija'che sãiñe i'kaasomʉ repaʉ'te: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Pãipi chʉ'ʉrejẽ'e cuasama'ñe repana ãijañe ãuchi'a cuasajʉ pa'ito cu'amʉ. Jã'achi'a cuasama'ñe chʉ'ʉ chʉ'o asa chẽa cho'ojʉ pani re'oja'che pa'ijanaa'me pãi, chiimʉ —chiniasomʉ Jesús repaʉ'te vatire. ");
INSERT INTO coe_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Jã'a i'kacuhasirʉmʉ vati ai repaʉ'te Jesure Dios neejoopo Jerusalén vʉ'ejoopona sa Dios vʉ'e sẽ'sevʉna mʉa ija'che i'kaasomʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Dios, mʉ'ʉni kuirajʉ mʉ'ʉ tuã'ito repana jʉ̃jñapi chẽaa'jʉ chini, ángele'te raoja'mʉ, mʉ'ʉpi tuãni asi cho'omanea'kʉ chini, chiimʉ. Jã'ajekʉna mʉ'ʉpi Dios Mamarepakʉ pani ichejapi chejana chã'ijʉ̃'ʉ. Dios i'kasi'epi ũcuarepa pa'ito ichejapi chãni asi cho'omaneja'mʉ mʉ'ʉ —chiniasomʉ vati ai. ");
INSERT INTO coe_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chikʉna Jesús i'kaasomʉ. —Ũcuachi'a Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉ cho'omasiche'te rupʉ ñañu chini sẽemanejʉ̃'ʉ mʉsanʉkona pãi, chiimʉ Dios —chiniasomʉ Jesús repaʉ'te vati aire. ");
INSERT INTO coe_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Jã'a cho'o pi'nisirʉmʉ vati ai repaʉ'te Jesure cuhacho aikũtina rʉa ʉmʉ pa'ikũtina sa mʉa teana te'erʉmʉ peore chejña pãi pa'ichejñana'me repachejña pa'imajñarʉã re'oja'chere ñokʉ ija'che i'kaasomʉ: —Mʉ'ʉpi chʉ'ʉni, “Peore masikʉ'mʉ mʉ'ʉ”, chiiʉ ro're ñu'iʉ pojoru mʉ'ʉni peore ĩsija'mʉ chʉ'ʉ ichejña —chiniasomʉ vati. ");
INSERT INTO coe_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chikʉna Jesús i'kaasomʉ repaʉ'te. —¡Vati ai, saijʉ̃'ʉ mʉ'ʉ! Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Diore Pãi Ũcuanʉkore Paakʉ'techi'a, “Peore masikʉ'mʉ mʉ'ʉ”, chiijʉ cuasajʉ pojojʉ Repaʉ chʉ̃'ʉñechi'a cho'ojʉ pa'ijʉ̃'ʉ mʉsanʉkona pãi, chiimʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jã'aja'ñe i'kaʉna vati ai Jesure jo'ka sanisõasomʉ. Repaʉ sanisõsirʉmʉ ángelepi rani kuiraasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jã'a cho'ocuha repaʉ co'isirʉmʉ Jesús, Juan Pãi Okoro'vesi'kʉre pãi chẽavʉ'e cuaosi'ere asa Galilea chejana saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Repacheja cajoopona Nazaret vʉ'ejoopona sani rʉa keerʉmʉ pa'ima'ñe chiara rʉ'tʉva cajoopona Zabulonna'me Neftalí ve'ochejña cajoopona Capernaum vʉ'ejoopo'te pasa chini saniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jã'aja'ñe cho'oʉna aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías tocha jo'kasi'epi ũcuarepa ti'jñesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Galilea chiara rʉ'tʉva pa'ichejñare Zabulón chejana'me Neftalí cheja ve'osichejñare judío peona jainʉko pa'ime. Chura Galilea cheja jã'aja'ñe ve'emʉ repachejña. Jordán chiacha chekʉkã'ko cacheja ũcuaja'che judío peona jainʉko pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ũcuachejñare pa'ijʉ chijacheja pa'inaja'ñe cu'ache pa'inapi miañe ñañeja'ñe chʉ'o re'oja'chere asaasome repana, re'oja'che pa'iche chʉ'vachʉ'ore. Ũcuaja'che cu'ache pa'inapi umucuse ñataʉna miañe ñoñeja'ñere re'oja'che pa'iche'te asaasome repana, chiimʉ Isaías tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Repacheja saisirʉmʉpi vʉa Jesús ija'che chiiʉ pãire chʉ'vakʉ paniasomʉ: —Mʉsanʉkona cu'ache cho'oche ũhasõ mama cuasajʉ̃'ʉ. Dios Raosi'kʉ pãi ũcuanʉkore chʉ̃'ʉpi'ramʉ —chiiʉ chʉ'vaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na'a pa'isirʉmʉ Jesús Galilea chiara rʉ'tʉva'te ku'iʉ Simonre cho'jeʉ Andrena'me pa'ikʉni ñaasomʉ. Repaʉ Simón cheke mami Pedro ve'emʉ. Va'i chonajejʉ va'i chorʉji chiara'te chojʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Repanare ña Jesús ija'che i'kaasomʉ: —Chʉ'ʉni ja'me ku'ijʉ chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ pa'ijʉ̃'ʉ. Va'i sani va'ire jñaa ranaa'me mʉsanʉkona. Chura chʉ'ʉpi cho'okaiʉna sani pãire jñaa chʉ'ʉni rakaijʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jã'aja'ñe i'kaʉna asa teana va'i chorʉã jo'ka ũcuaʉna'me saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jã'achejapi jo'e jmachenerʉ sani Zebedeo chĩire Santiagona'me Juanre ñaasomʉ repaʉ. Pʉka'kʉna'me choovʉ'te pa'ijʉ va'i chorʉãre care'vajʉ paniasome repana. Pa'ijʉna ña Jesús repanare, repaʉna'me saapʉ chini soniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Soiʉna asa, “Jaʉ”, chini choovʉna'me pʉka'kʉre teana jo'ka ũcuaʉna'me saniasome repana Santiagona'me Juan. ");
INSERT INTO coe_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Reparʉmʉ Jesús Galilea cheja si'achejña ku'iʉ repacheja pa'ivʉ'ña judíopãi chi'ivʉ'ñana si'arʉmʉ kaka che'chokʉ ku'iʉ pa'isi'kʉa'mʉ. Ũcuachi'a pãi cu'ache cho'oche ũhasõsinare Dios chẽa paache'te chʉ'vakʉ pãi si'ache ravʉ jũ'inare vasokʉ ca'nivʉã asiche si'ache jũ'inare vasokʉ ku'iʉ pa'isi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Repaʉ cho'oche'te ñajʉ pãipi si'arʉmʉ kʉajʉna asa Siria cheja si'achejña pa'ina pãi ravʉ si'ache jũ'iva'nare, ca'nivʉã asiche si'ache jũ'inare, vati paanare, vẽ've ravʉ paanana'me nʉka ku'imanare Jesuni saasome. Sarena Jesús repanare ũcuanʉkore vasokaisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Reparʉmʉ pãi rʉa jainʉko Jesure ja'me ku'ijʉ pa'isinaa'me, Galilea cheja cana Decápolis cheja cajoopoã cana Jerusalén vʉ'ejoopo cana Judea cheja canana'me Jordán chiacha chekʉkã'ko cana. ");
INSERT INTO coe_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Ũcuarʉmʉ Jesús pãipi jairepanʉko Repaʉ pa'ichejana chi'ijʉna ña aikũtina mʉni pʉʉsi'kʉa'mʉ. Mʉni ñu'iʉna chʉkʉna repaʉ neenana'me repaʉ'te chiinapi repaʉ ñu'ichejana mʉni chi'irena ũcuachejare ñu'iʉ Dios chʉ̃'ʉñe cho'ona Repaʉ neena pa'iche'te che'chokʉ ija'che chʉ'vasi'kʉa'mʉ repaʉ chʉkʉna'te: ");
INSERT INTO coe_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Pãi Diore masi cuasamanata'ni Repaʉ'te masi cuasañu chiito Diopi paakʉ cho'okaija'mʉ repanare. Ũcuaʉji cho'okaiʉna Repaʉni masi cuasajʉ jũnisõsirʉmʉ Repaʉ pa'ichejare ai sani pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ũcuachi'a oijʉ sʉmava'na pa'ina pãi, Diopi repana rekoñoãna chʉroʉna pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ũcuachi'a pãi cu'ache cho'ocojñonata'ni sãiñe cu'ache cho'omana Dios, “Ĩsija'mʉ chʉ'ʉ”, chiisichejare chejare ĩsiʉna pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ũcuachi'a pãi Dios chʉ̃'ʉñe cho'oneena Ũcuaʉji cho'okaiʉna Repaʉ chʉ̃'ʉñe'te masi cho'ojʉ pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ũcuachi'a chekʉnare ña oijʉ re'oja'che cho'okaina pãi, Diopi ũcuaja'che repanani oiʉ re'oja'che cho'okaiʉna pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ũcuachi'a pãi repana rekoñoã cu'achejẽ'e cuasamana Diore ñajanaa'me. Diore ñajanajejʉ pojojʉ pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ũcuachi'a chekʉnapi cavajʉna ñani, “Cavamairo re'oja'che pa'ijʉ̃'ʉ”, chiinare pãi, “Chʉ'ʉ chĩia'me ina”, chiija'mʉ Dios. Jã'ajekʉna pojojʉ pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ũcuachi'a Dios chʉ̃'ʉñe'te cho'ojʉ cu'ache cho'ocojñona pãi, Dios neenajejʉ Ũcuaʉji cho'okaiʉna pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Pãi mʉsanʉkonare chʉ'ʉni cuasajʉna rʉa cu'ache i'kajʉ cu'ache cho'ome. Ũcuachi'a mʉsanʉkona pa'iche'te chekʉnare kʉani, “Cu'ache pa'inaa'me jã'ana”, chiijʉ jorenaa'me repana, cheke si'ache na'a rʉa cu'ache i'kajʉ. Chʉ'ʉni cuasajʉ cu'ache cho'ocojñonata'ni pojojʉ pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Na'a pa'isirʉmʉ Dios mʉsanʉkonare Repaʉ pa'ichejana satena pa'iche re'oja'chere ĩsija'mʉ. Jã'ajekʉna pojojʉ pa'ijʉ̃'ʉ mʉsanʉkona. Mʉsanʉkonare irʉmʉ cu'ache cho'ocheja'che aperʉmʉ pa'isina pãi reparʉmʉ Dios chʉ'o kʉasinare ũcuaja'che cu'ache cho'oasome —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e chʉ'vasi'kʉa'mʉ. —Ũha sãija'iʉ rʉa re'omʉ. Mʉsanʉkona ũcuachi'a chʉ'ʉre cuasanajejʉ re'oja'che pa'ijʉ ũhaja'ñe pa'ime icheja cheja. Jã'ata'ni ũhapi sãija'ñeji si'asõru, ¿je'se cho'ojanaa'ñe pãi, ũhapi sãijaaʉ chini? Jo'e sãija'ñe cho'ocu'amʉ repa. Cu'akʉna ve'sena sẽjoru pãi chekʉnapi ku'ijʉ cha'came repa ũha. ");
INSERT INTO coe_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ũcuachi'a chʉ'ʉre cuasanajejʉ mʉsanʉkonapi re'oja'che cho'ojʉna ñajʉ, pãi chekʉna, “Diopi cho'okaiʉna re'oja'che cho'ome ina”, chiijʉ masime. Vʉ'ejoopo aikũti sẽ'sevʉ pa'ijoopo rʉa so'ña ñoñeja'ñe mʉsanʉkonapi re'oja'che cho'ojʉ ñojʉna ñajʉ, pãi chekʉna, “Diopi cho'okaiʉna re'oja'che pa'ime ina”, chiijʉ masime. ");
INSERT INTO coe_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pãiʉ ʉotʉopʉ chʉ̃oni totoroji jao nʉkoma'mʉ. Jã'aja'ñe cho'oma'ñe ʉotʉopʉ chʉ̃oni, “Chija'ito pãi ivʉ'e pa'ina ñamanejanaa'me”, chini cuasa, ʉmʉna tʉomʉ re'oja'che miakʉna repavʉ'e pa'inapi ũcuanʉko ñaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mʉsanʉkona ũcuaja'che ʉotʉopʉ re'oja'che miañeja'ñe re'oja'che cho'ojʉ pa'ijʉ̃'ʉ, pãipi ña, “Diopi cho'okaiʉna re'oja'che cho'onaa'me ina”, chiapʉ chini —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kakʉ chʉ'vasi'kʉa'mʉ: —Chʉ'ʉre ija'che cuasamanejʉ̃'ʉ mʉsanʉkona: “ ‘Diopi chʉ̃'ʉʉna Moisés tocha jo'kasi'ena'me Repaʉ chʉ'o aperʉmʉ kʉasina tocha jo'kasi'e kʉache'te cho'omanejʉ̃'ʉ’, chisa chini raisi'kʉcosomʉ ikʉ Jesús”, chiijʉ cuasamanejʉ̃'ʉ chʉ'ʉre. Jã'aja'ñe cho'oma'ñe repana chʉ'ʉ cho'ojachere kʉajʉ tocha jo'kasi'ere cho'ora chini raisi'kʉa'mʉ chʉ'ʉ, mʉsanʉkonapi ña chẽa ũcuaja'che cho'ojʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cʉnaʉmʉna'me cheja chuta'a si'amarʉmʉna repana tocha jo'kasi'e kʉache te'emakarʉjẽ'e karama'ñe peore pa'ija'mʉ, repa kʉache peore ti'jñerʉmʉjatʉ'ka. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jã'ajekʉna pãiʉ ũcuaʉakʉji repana chʉ̃'ʉ jo'kasi'ere jachakʉ peore cho'omaʉ chekʉnarejẽ'e, “Repana chʉ̃'ʉ jo'kasi'e peore cho'oma'tojẽ'e re'omʉ”, chiiʉ chʉ'vasi'kʉre Dios, “Ikʉ chʉ'ʉ neekʉta'ni rʉa vesʉʉ'mʉ”, chiija'mʉ. Jã'ata'ni pãiʉ ũcuaʉakʉji repana chʉ̃'ʉ jo'kasi'ere jachama'ñe cho'okʉ chekʉnare ũcuaja'che, “Jachama'ñe cho'ojʉ̃'ʉ”, chiiʉ chʉ'vasi'kʉre Dios, “Ikʉ chʉ'ʉ neekʉ rʉa masiʉ'mʉ”, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉsanʉkonapi repana chʉ̃'ʉ jo'kasi'ere judíopãi che'chonana'me fariseopãire na'a rʉa cho'omaneni Dios pa'icheja saimanejanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e chʉ'vakʉ ija'che che'chosi'kʉa'mʉ: —Moisés mai aipãire aperʉmʉ chʉ̃'ʉkʉ tocha jo'kasi'e kʉache asanaa'me mʉsanʉkona. Ija'che kʉamʉ repa: Chekʉnare vanisõmanejʉ̃'ʉ. Pãiʉ ũcuaʉakʉji chekʉre vanisõru repaʉ'te ũcuachi'a sãiñe vanisõjʉ̃'ʉ, chiimʉ repaʉ tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Chʉ'ʉta'ni, “Ija'che cho'ojʉ̃'ʉ”, chiiʉ chʉ̃'ʉmʉ mʉsanʉkonare: Pãiʉ ũcuaʉakʉji repaʉ'te ja'me pa'ikʉni pe'rutojẽ'e pe'rusi'e ro'i cu'ache ti'jñeja'mʉ repaʉ'te. Ũcuachi'a pãiʉ ũcuaʉakʉji repaʉ'te ja'me pa'ikʉni cu'ache i'kato pãi chʉ̃'ʉna repaʉ'te chẽajanaa'me, jo'e i'kamanea'kʉ chini. Ũcuachi'a pãiʉ ũcuaʉakʉji repaʉ'te ja'me pa'ikʉni, “Cu'akʉjekʉ vati toana sani uukʉ pa'ija'mʉ mʉ'ʉ”, chiikʉ ũcuaʉji vati toana saocojñoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Ũcuachi'a mʉsanʉkonapi ũcuaʉakʉji te'eʉ Diore ĩsimajñarʉãre Repaʉni ĩsira chini saikʉji mʉ'ʉre chekʉ pe'ruche'te cuasani mʉ'ʉ ĩsira chini samajñarʉã repamajñarʉã tʉo ʉoko'a ti'jñeñena ũha charo mʉ'ʉre pe'rukʉni, “Jo'e sãiñe pe'ruma'ñe re'oja'che pañu mai”, chiijaijʉ̃'ʉ. Pe'rusi'e care'vajani Diore ĩsimajñarʉã tʉo ʉoko'ana co'i, mʉ'ʉ rakʉ ũhasi'e churata'ni repamajñarʉã Diore ĩsijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chekʉrʉmʉ pãiʉ ũcuaʉakʉji chekʉni põsero'i paamʉ. Jã'ata'ni repaʉji jeereparʉmʉ ro'ima'to pe'rukʉ ro'ia'kʉ chini pãi chẽañe chʉ̃'ʉkʉ pa'ivʉ'ena saja'mʉ repaʉ'te. Jã'aja'ñe cho'opi'rato pesa chuta'a ma'a sairʉmʉna, “Põsero'ire charo care'vañu”, chiijʉ̃'ʉ repaʉ'te. Na'mi care'vama'to repaʉ'te pãi chẽañe chʉ̃'ʉkʉni saja'mʉ repaʉ. Sa jo'kaʉna pãi chẽañe chʉ̃'ʉkʉji repaʉ'te pãi chẽavʉ'ena cuaoa'jʉ chini pãi chẽanani chʉ̃'ʉja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cuao jo'karena põsero'i peore ro'i pi'niñetʉ'ka ũcuavʉ'ere pa'ija'mʉ repaʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che chʉ'vasi'kʉa'mʉ: —Ũcuachi'a Moisés aperʉmʉ chʉ̃'ʉkʉ tocha jo'kasi'e kʉache cheke asanaa'me mʉsanʉkona. Ija'che kʉamʉ repa: Ʉmʉpãi, mʉsanʉkona pa'imanare romi ja'me kãima'ñe pa'ijʉ̃'ʉ. Ũcuachi'a romi, mʉsanʉkona pa'imanare ʉmʉpãi ja'me kãima'ñe pa'ijʉ̃'ʉ, chiniasomʉ. Repana i'kasi'e chekʉnapi kʉajʉna asanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Chʉ'ʉta'ni ija'che i'kamʉ: Pãiʉ ũcuaʉakʉji romioni repaʉ paama'koni ʉache ñani repaʉ rekochoji repao'te paama'kʉpi ja'me kãisi'kʉja'che cho'omʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Chekʉrʉmʉ pãiʉ ũcuaʉakʉji repaʉ ñakova ʉjajʉ̃tʉ cakã'ko cañakovaji ñakʉ chekʉni cu'ache cho'omʉ. Jã'aja'ñe cho'oni repañakova ruta so'ona sẽjosõa'kʉ. Ñakovachi'a cho'osõto na'a re'omʉ repaʉ'te. Jã'aja'ñe cho'omaneni chekʉrʉmʉ repaʉ ũcuañakovaji ñakʉ jo'e na'a rʉa cu'ache cho'osi'kʉjekʉ vati toana saocojñoja'mʉ. Repaʉji ñakova te'eñakova peoto cu'amʉ. Jã'ata'ni Diopi repaʉ'te vati toana saoru na'a rʉa cu'ache pa'imʉ repaʉ'te, cu'a cho'osi'kʉre. ");
INSERT INTO coe_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ũcuachi'a pãiʉ ũcuaʉakʉji repaʉ ʉjajʉ̃tʉpi chekʉni cu'ache cho'oni, repajʉ̃tʉ tʉso so'ona sẽjosõa'kʉ. Jʉ̃tʉchi'a cho'osõto na'a re'omʉ repaʉ'te. Jã'aja'ñe cho'omaneni chekʉrʉmʉ repaʉ ũcuajʉ̃tʉpi jo'e na'a rʉa cu'ache cho'osi'kʉjekʉ vati toana saocojñoja'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Ũcuachi'a Moisés aperʉmʉ chʉ̃'ʉkʉ tocha jo'kasi'e cheke ija'che kʉamʉ: Pãiʉ ũcuaʉakʉji repaʉ rʉ̃jore paacuhekʉ sẽjora chiikʉ charo repao'te sẽjosi'e kʉache utija'ovana tocha ũcuaoni ĩsijʉ̃'ʉ repao chekʉnare ñojaja'ova. Repaja'ova tocha pi'ni ĩsiru sẽjore'omʉ repao'te, chiimʉ repaʉ chʉ̃'ʉ jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Chʉ'ʉta'ni ija'che cho'ojʉ̃'ʉ chiiʉ chʉ̃'ʉmʉ mʉsanʉkonare: Chekʉrʉmʉ pãiʉji repaʉ rʉ̃jopi chekʉni ja'me kãito sẽjore'omʉ repao'te. Jã'ata'ni repaʉ rʉ̃joni jã'aja'ñe cu'ache cho'oma'koni rurepapʉ sẽjoni cu'ache cho'omʉ. Sẽjosõru chekʉrʉmʉ repao jo'e chekʉni veja pa'ija'mo. Repaoji jã'aja'ñe cho'oru ʉ̃jʉ pa'isi'kʉpi sẽjosi'kʉpi chʉ'o paamʉ, repao cu'ache cho'osi'e. Repao'te vejasi'kʉ ũcuaja'che cu'ache cho'omʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kakʉ chʉ'vasi'kʉa'mʉ: —Ũcuachi'a Moisés mai aipãire aperʉmʉ chʉ̃'ʉkʉ tocha jo'kasi'e kʉache cheke asanaa'me mʉsanʉkona. Ija'che kʉamʉ repa: Mʉsanʉkona Diore roijʉ i'kasi'e jorema'ñe ũcuarepa cho'ojʉ pa'ijʉ̃'ʉ, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jã'ata'ni chʉ'ʉ mʉsanʉkonare jã'aja'ñe cho'omanea'jʉ chini ija'che chʉ'vamʉ: Diore jmamakarʉjẽ'e roijʉ i'kamanejʉ̃'ʉ mʉsanʉkona. Repaʉ mamire ve'ocuhejʉ cʉnaʉmʉjẽ'e roijʉ i'kamanejʉ̃'ʉ, Repaʉ chʉ̃'ʉkʉ pa'ichejajekʉna. ");
INSERT INTO coe_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ũcuachi'a chejajẽ'e roijʉ i'kamanejʉ̃'ʉ, Repaʉ chʉ̃'ʉcojñona pa'ichejajekʉna. Ũcuachi'a Jerusalén vʉ'ejoopojẽ'e roijʉ i'kamanejʉ̃'ʉ, Repaʉ Dios peore chʉ̃'ʉkʉ neejoopojekʉna. ");
INSERT INTO coe_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ũcuachi'a sĩjore roijʉ i'kamanejʉ̃'ʉ, mʉsanʉkonare raña te'era'chorʉjẽ'e pojaraña jã'apãani chijaraña carʉñocu'asĩjojekʉna. ");
INSERT INTO coe_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ũcuachi'a mʉsanʉkonare Diore cuasanare chekʉnapi i'kajʉna, “Jaʉ, cho'ora”, chiisi'e repare ũcuarepa cho'ora chini cheke na'a rʉa roijʉ i'kato cu'amʉ. Mʉsanʉkona chekʉnapi i'kajʉna, “Cho'oma'mʉ”, chiisi'e ũcuaja'che chekere roijʉ i'kamanejʉ̃'ʉ. Cheke na'a rʉa roijʉ i'kanapi vati chʉ̃'ʉñe cu'ache cho'ome repana —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e chʉ'vasi'kʉa'mʉ. —Ũcuachi'a Moisés chʉ̃'ʉkʉ tocha jo'kasi'e cheke ija'che kʉamʉ: Chekʉpi mʉ'ʉ ñakova'te tʉ'ka feosõru sãiñe tʉ'ka feosõkaijʉ̃'ʉ repaʉ'te. Ũcuachi'a chekʉpi mʉ'ʉ cõjiñʉ'te jẽo jʉchosõru sãiñe jẽo jʉchosõkaijʉ̃'ʉ repaʉ'te, chiimʉ repaʉ chʉ̃'ʉ jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Chʉ'ʉta'ni irʉmʉ ija'che chʉ̃'ʉmʉ mʉsanʉkonare: Chekʉpi mʉ'ʉni cu'ache cho'oto sãiñe cu'ache cho'omanejʉ̃'ʉ repaʉ'te. Ũcuachi'a chekʉpi pe'rukʉ mʉ'ʉ vachoturupʉna asi charato chekʉkã'ko ʉ̃semanejʉ̃'ʉ jo'e charaa'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ũcuachi'a chekʉrʉmʉ mʉ'ʉpi chekʉni põsero'i paakʉna repaʉji mʉ'ʉ sẽ'sevʉ ju'ikãare ĩsikʉ ro'ia'kʉ chini pãi chẽañe chʉ̃'ʉkʉ vʉ'ena saru chekʉkãa ũcuaja'che rupʉ ĩsijʉ̃'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ũcuachi'a chekʉpi mʉ'ʉni repaʉ põsere te'ekilómetrojatʉ'ka kuãa sakaaʉ chini chʉ̃'ʉto dos kilómetrojatʉ'ka pojokʉ kuãa sakaijʉ̃'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ũcuachi'a mʉ'ʉ paamajñarʉãre ũcuaʉakʉji sẽeto rupʉ ĩsijʉ̃'ʉ repaʉ'te. Ũcuachi'a chekʉpi mʉ'ʉni ũcuaʉache'te prestara chini sẽeto ʉ̃sema'ñe prestajʉ̃'ʉ repaʉ'te —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e chʉ'vasi'kʉa'mʉ. —Ũcuachi'a Moisés chʉ̃'ʉkʉ tocha jo'kasi'e cheke ija'che kʉamʉ: Mʉsanʉkonare re'onare oijʉ pa'ijʉ̃'ʉ. Mʉsanʉkonare cuhenareta'ni sãiñe cuhejʉ̃'ʉ, chiimʉ repaʉ chʉ̃'ʉ jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chʉ'ʉta'ni ija'che chʉ̃'ʉmʉ mʉsanʉkonare: Mʉsanʉkonare cuhenare oijʉ pa'ijʉ̃'ʉ. Mʉsanʉkonare cu'ache i'kanare Dioni re'oja'chere sẽekaijʉ̃'ʉ. Ũcuachi'a mʉsanʉkonare cu'ache cho'onare sãiñe re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mʉsanʉkonapi chʉ'ʉ chʉ̃'ʉsi'ere cho'oni mai Ja'kʉ Dios Cʉnaʉmʉ Pa'ikʉ cho'ocheja'che re'oja'che cho'ojʉ pa'ijanaa'me. Ũcuaʉji chʉ̃'ʉʉna ʉ̃sʉʉ asuche pãi cu'anana'me re'ona pa'icheja re'oja'che ñoñe miamʉ. Ũcuachi'a Diopi chʉ̃'ʉʉna oko pãi cu'ache pa'inana'me re'oja'che pa'ina pa'ichejña si'achejña rakʉ pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pãi chʉ̃'ʉnare kuri kookaina pãi ũcuanʉkore oima'ñe repanare oinarechi'a sãiñe oijʉ pa'ime. Mʉsanʉkona repanare na'a re'oja'che pa'ijʉ pãi ũcuanʉkore oijʉ pa'ito re'oja'che pa'iche jo'kaja'mʉ Dios mʉsanʉkonare. Jã'ata'ni repana pa'icheja'che mʉsanʉkonare oinarechi'a oijʉ pa'ito re'oja'che pa'iche jo'kamaneja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ũcuachi'a Diore cuasamana pãi ũcuanʉkore chẽse pojoma'ñe repanare re'onarechi'a chẽse pojojʉ pa'ime. Mʉsanʉkonata'ni mʉsanʉkonare re'onarechi'a chẽse pojojʉ pa'ima'ñe mʉsanʉkona ñamanarejẽ'e chẽse pojojʉ pa'ijʉ̃'ʉ, Diopi pojoa'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mai Ja'kʉ Dios, Cʉnaʉmʉ Pa'ikʉ cho'ocheja'che re'oja'chechi'a cho'ojʉ pa'ijʉ̃'ʉ mʉsanʉkona —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare ija'che chʉ'vasi'kʉa'mʉ: —Mʉsanʉkonapi chekʉnani re'oja'che cho'okañu chini rupʉ chekʉnapi pãipi ñaa'jʉ chini re'oja'che cho'ojʉ pa'imanejʉ̃'ʉ. Mʉsanʉkonapi jã'aja'ñe cho'ojʉ pa'ito Dios mai Ja'kʉ Cʉnaʉmʉ Pa'ikʉ mʉsanʉkonare re'oja'che cho'osi'e ro'i jmamakarʉjẽ'e ĩsimaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Jã'ajekʉna mʉsanʉkonapi chʉova'na pa'iva'nare cho'okani pãi jainʉko ñajʉ'te cho'omanejʉ̃'ʉ. Jã'aja'ñe cho'ome pãi sẽ'sevʉchi'a re'oja'cheja'che ñoñe pa'ina. Chʉova'na pa'iva'nani kurire ĩsiñu chini, mai judíopãi chi'ivʉ'ñana kaka pãi ñajʉ'te kuri ĩsinaa'me repana, pãipi jainʉko repana cho'oche'te ña, “Re'onaa'me ina”, chiapʉ chini. Chekʉrʉmʉ callejoovʉãre eta nʉka ku'ijʉ pãi chenevʉãna chʉova'na pa'iva'nare kuri ĩsinaa'me repana, pãipi jainʉko ña, “Re'onaa'me ina”, chiapʉ chini. Jã'aja'ñe cho'ojʉ pãire ũcuare re'oja'che i'kacojñosinajejʉ, re'oja'che cho'osinare Dios ro'ijache re'oja'che pa'iche koomanejanaa'me repana. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉsanʉkonapi te'eʉ, “Chʉova'na pa'iva'nani cho'okasa”, chini mʉ'ʉ na'a rʉa ja'me pa'ikʉ'terejẽ'e kʉama'ñe te'eʉ cuasakʉ cho'okaijʉ̃'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kʉama'ñe mʉ'ʉchi'a te'eʉ cuasakʉ cho'okaiʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oru mai Ja'kʉ Dios pãi ũcuanʉko rope'e cho'oche peore Ñakʉji mʉ'ʉ te'eʉ cuasakʉ cho'osi'e ña ro'ija'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ũcuarʉmʉ Jesús ija'che che'chosi'kʉa'mʉ: —Mʉsanʉkonapi Diore sẽni sẽ'sevʉchi'a re'oja'cheja'che ñoñe pa'ina cho'ocheja'che cho'omanejʉ̃'ʉ. Repana Diore sẽni mai judíopãi chi'ivʉ'ñana kaka pãi chenevʉãre nʉkajʉ sẽenaa'me, pãipi ña, “Re'onaa'me ina”, chiapʉ chini. Chekʉrʉmʉ callejoovʉãre nʉkajʉ Diore sẽenaa'me repana, chekʉnapi ña, “Re'onaa'me ina”, chiapʉ chini. Jã'aja'ñe cho'ojʉ pãire ũcuare re'oja'che i'kacojñosinajejʉ re'oja'che cho'osinare Dios ro'ijache re'oja'che pa'iche koomanejanaa'me repana. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉsanʉkonapi te'eʉ Diore sẽni mʉ'ʉ pa'iruupʉna kaka jeo mai Ja'kʉ Diore Ñoma'kʉni sẽejʉ̃'ʉ. Jã'aja'ñe cho'oto mai Ja'kʉ Dios pãi ũcuanʉko rope'e cho'oche peore Ñakʉji mʉ'ʉ te'eʉ cho'oche ña re'oja'che cho'osi'e ro'i re'oja'che ĩsija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ũcuachi'a mʉsanʉkonapi Diore sẽni Repaʉ'te masi cuasamana cho'ocheja'che ũcuate'ere i'kajʉ sẽemanejʉ̃'ʉ. Repana Diore masi cuasamana Repaʉ'te sẽni, “Maipi chʉ'o ũcuate'ere rʉarepañoã co'chajʉ sẽeto Dios maire asa cho'okaija'mʉ”, chini cuasajʉ jã'aja'ñe i'kajʉ sẽeme. ");
INSERT INTO coe_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Repana cho'ocheja'che cho'omanejʉ̃'ʉ mʉsanʉkona. Mʉ'ʉ chuta'a Repaʉ'te sẽemarʉmʉna mʉ'ʉ chiiche masimʉ Dios. ");
INSERT INTO coe_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mʉsanʉkonapi sẽni ija'che i'kajʉ̃'ʉ: Ja'kʉ, Cʉnaʉmʉ Pa'ikʉ, pãi mʉ'ʉre vajʉchʉjʉ pojoa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ũcuachi'a mʉ'ʉ chʉ̃'ʉñe pãi ũcuanʉko cho'ojarʉmʉ tĩ'aa'kʉ. Cʉnaʉmʉ pa'ina mʉ'ʉ chʉ̃'ʉñe masi cho'ocheja'che cheja pa'ina ũcuaja'che re'oja'che cho'ojʉ paapʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ũcuachi'a chʉkʉna chiiche ãu si'aumucujña ĩsijʉ̃'ʉ, chʉkʉna ãijañe. ");
INSERT INTO coe_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chʉkʉna cu'ache cho'oche jo'e cuasamanejʉ̃'ʉ, chʉkʉna'te pãi cu'ache cho'osi'e chʉkʉna jo'e cuasama'ñeja'ñe. ");
INSERT INTO coe_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chʉkʉna'te vatipi chʉ̃'ʉkʉna cu'ache cho'oñu chiito mʉ'ʉpi ʉ̃sekaijʉ̃'ʉ, cho'omanea'jʉ chini. Jã'aja'ñe i'kajʉ Diore sẽejʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Chekʉna cu'ache cho'osi'ere mʉsanʉkonapi jo'e cuasama'to mai Ja'kʉ Dios ũcuaja'che mʉsanʉkona Repaʉ'te cu'ache cho'oche jo'e cuasamaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jã'ata'ni mʉsanʉkonapi chekʉna cu'ache cho'osi'ere ũcua cuasajʉ pa'ito mai Ja'kʉ Dios ũcuaja'che mʉsanʉkona Repaʉ'te cu'ache cho'oche cavesʉma'ñe cuasakʉ pa'ija'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ũcuarʉmʉ Jesús ija'che che'chosi'kʉa'mʉ: —Mʉsanʉkonapi ãu ãima'ñe pa'ijʉ Dioni sẽejʉ pañu chini, sẽ'sevʉchi'a re'oja'cheja'che ñoñe pa'ina cho'ocheja'che cho'omanejʉ̃'ʉ. Repana pãi ãu ãima'ñe pa'ijʉ Dioni sẽni repana chiña, sʉmava'na ñoñe pa'inaa'me, pãipi ña, “Dioni sẽejʉ ãu ãima'ñe pa'inajejʉ re'onaa'me ina”, chiapʉ chini. Pãi repanare re'oja'che i'kasimakarʉchi'api ro'isi'eja'chea'me repanare. Ũcuarepaa'me jã'a. Mʉsanʉkonapi ãu ãima'ñe pa'ijʉ Dioni sẽni chʉova'na ñoñe pa'imanejʉ̃'ʉ. Ãu ãisina pa'icheja'che pojojʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mʉsanʉkonapi ũcuaʉakʉji ãu ãima'ñe pa'iʉ Dioni sẽeʉ pasa chini charo mʉsanʉkona chiña sĩ'sisõ cʉ̃'ʉ veni care'vajʉ̃'ʉ raña, pãipi mʉsanʉkona Diore sẽejʉ ãu ãima'ñe pa'iche'te ña masimanea'jʉ. Jã'aja'ñe cho'oto mai Ja'kʉ, Dios, Ñoma'kʉpi mʉsanʉkona kʉama'ñe re'oja'che cho'oche ña ro'ija'mʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Mʉsanʉkona rʉarepa põse si'ache koo paamanejʉ̃'ʉ. Icheja chejaquee põse pu'janajẽ'e pu'ja si'asõkaijʉ chekʉrʉmʉ macono phũ'ka cho'osõñe'me. Chekʉrʉmʉ ñaanapi rani peore ñaasõkaiche'me repa. ");
INSERT INTO coe_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mʉsanʉkona paache põse icheja chejaquee si'asõjañea'me. Jã'ajekʉna repa põse rʉarepa cuasama'ñe pa'ijʉ Dioni na'a rʉa cuasajʉ pa'ijʉ̃'ʉ. Repaʉ pa'icheja sani re'oja'che koojachere cuasajʉ̃'ʉ. Repaʉ ĩsiche pu'jacu'ache'me. Ũcuachi'a Repaʉ ĩsiche macono phũ'ka cho'osõma'ñea'me. Ũcuachi'a ñaanajẽ'e peochejaa'me repacheja. ");
INSERT INTO coe_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dios ĩsijache koojanajejʉ pojojʉ pa'ijʉ̃'ʉ mʉsanʉkona. Mʉsanʉkonapi põsere na'a rʉa cuasajʉ pani Dios ĩsijache rʉa cuasamanejanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ũcuarʉmʉ Jesús jo'e ija'che che'chosi'kʉa'mʉ: —Mʉsanʉkona ñakocaã masi ñoto cho'oche cho'ore'omʉ. Ũcuaja'che mʉsanʉkonapi cu'ache cuasama'ñe pa'ijʉ Dioni rʉa cuasajʉ pa'ito rekoñoã re'oja'che pa'ija'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jã'ata'ni ñakocaãpi masi ñoma'to cho'oche cho'ocu'amʉ. Ũcuaja'che mʉsanʉkonapi Dioni cuasama'ñe cu'ache cuasajʉ pa'ito re'oja'che pa'icu'aja'mʉ mʉsanʉkona rekoñoã. Mʉsanʉkonapi re'oja'che cuasani re'oja'chechi'a cho'ojʉ pa'ijanaa'me. Cu'ache cuasani ũcuachi'a cu'achechi'a cho'ojʉ pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ũcuarʉmʉ Jesús ija'che chʉ'vasi'kʉa'mʉ: —Pãi ka'chanapi ũcuate'eʉ'te paato repaʉ'te paanare ũcuapa'rʉvachi'a chiicu'amʉ repaʉ'te. Chekʉrʉmʉ repaʉ'te paanare te'eʉ'te na'a rʉa chiiʉ chekʉreta'ni cuhemʉ repaʉ. Ũcuachi'a kurina'me Diore ũcuapa'rʉvachi'a cuasama'me pãi. Kurire na'a rʉa cuasajʉ Dioreta'ni cuasama'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Kurina'me Diore ũcuapa'rʉvachi'a cuasacu'akʉna jo'e mʉsanʉkonare ija'chere chʉ'vamʉ chʉ'ʉ: Mʉsanʉkona pa'ichena'me ãu ãiñena'me ũkuchena'me kãña ju'iche rʉarepa cuasajʉ pa'imanejʉ̃'ʉ. Mai pa'iche ãuna'me kãñachi'ama'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pĩ'ava'na pa'iche'te cuasa ñajʉ̃'ʉ. Pĩ'ava'na ãujẽ'e tãmava'naa'me. Ĩsichejẽ'e cho'omava'naa'me. Ãu care'vavʉ'ñajẽ'e peova'naa'me repava'na. Jã'aja'ñe pa'iva'nareta'ni mai Ja'kʉ Cʉnaʉmʉ Pa'ikʉji ãu ĩsikʉ'mʉ repava'nare. Repaʉ Dios pĩ'ava'nare peore cuasakʉ rʉa re'oja'che kuirakʉ'mʉ. Jã'ata'ni mʉsanʉkonare pãi na'a rʉa cuasakʉ na'a re'oja'che kuirakʉ pa'imʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jã'ata'ni pãi repana ʉmʉ nʉkache rʉa cuasajʉ, “Na'a ʉmʉ ainee nʉkajanaa'me mai”, chiijʉ na'a ʉmʉ nʉkache chiinareta'ni na'a ʉmʉ nʉkacu'aja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Je'se pa'iʉna mʉsanʉkona kãñare rʉarepa cuasajʉ pa'iche? Korosi'e pa'iche'te cuasa ñajʉ̃'ʉ. Korosi'e cho'ochejẽ'e cho'oma'ñea'me. Kãñajẽ'e juhama'ñea'me. ");
INSERT INTO coe_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aperʉmʉ pa'iʉ pãi chʉ̃'ʉsi'kʉ Salomón ju'isikãña, repaʉji rʉa re'ojakãñare koo ju'iʉna rʉa re'oja'che ñoasomʉ, pãipi ñato. Jã'ata'ni Salomón ju'isikãña pa'icheja'che na'a rʉa re'oja'che ñomʉ korosi'e. Dios cho'oche'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diore rʉa cuasama'me mʉsanʉkona. U'chara'ñʉrʉã iumucujña pa'ira'ñʉrʉãre pãipi ʉosõru che'ro peoja'mʉ. Rʉa jeerʉmʉ pa'imara'ñʉrʉãta'ni repara'ñʉrʉã re'oja'che kuirakʉ'mʉ Dios. Mʉsanʉkonare pãi na'a rʉa re'oja'che kuirakʉ mʉsanʉkona ju'iche kãña ĩsikʉ'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jã'ajekʉna mʉsanʉkona si'areparʉmʉ, “¿Ʉ̃quere maiva'na ãijanaa'ñe?” “¿Ʉ̃quere maiva'na ũkujanaa'ñe?” “¿Ʉ̃quere maiva'na ju'ijanaa'ñe?”, chiijʉ rʉarepa cuasama'ñe pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pãi Diore cuasamana jã'amajñarʉã peore si'arʉmʉ rʉa cuasajʉ pa'ime. Mʉsanʉkona chiimajñarʉã mai Ja'kʉ Dios Cʉnaʉmʉ Pa'ikʉ, “Ina chʉ'ʉre cuasana jã'amajñarʉã chiime”, chiiʉ masimʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jã'ajekʉna jã'amajñarʉã rʉarepa cuasama'ñe pa'ijʉ Repaʉ chʉ̃'ʉñe'te na'a rʉa cuasajʉ cho'ojʉ pa'ijʉ̃'ʉ. Ũcuare Repaʉ mʉsanʉkonare ãuna'me ũkuche peore ĩsimʉ. ");
INSERT INTO coe_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mʉsanʉkonare che'ro cu'ache ti'jñejañe cuasajʉ oima'ñe pa'ijʉ̃'ʉ. Che'ro ũcuaumucusepi ñataʉna cuasajʉ̃'ʉ repamajñarʉã. Repaumucujña pa'iche te'enarechi'a cu'ache ti'jñemʉ maire. Dios mʉsanʉkonare cu'ache ti'jñejañe masikʉjekʉ cho'okaija'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Chekʉna cu'ache cho'oche ñani, “Cu'ache pa'inaa'me mʉsanʉkona”, chiijʉ ke'remanejʉ̃'ʉ. Jã'aja'ñe ke'rema'to Dios ũcuaja'che mʉsanʉkona cu'ache cho'oche ñakʉta'ni i'kamaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mʉsanʉkonapi chekʉna cu'ache cho'oche'te ñajʉ ke'reto Dios ũcuaja'che mʉsanʉkona cho'oche cuasa cu'ache cho'osi'e ro'i chʉ̃'ʉja'mʉ. Mʉsanʉkona chekʉnare cho'ocheja'che cho'ocojñojanaa'me, repanare ñajʉ i'kasi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ija'chea'me: Pãiʉ repaʉ ñakova'te chĩ'camaka ʉjamaka paakʉ'teta'ni cuasomaneasomʉ. Cuasama'kʉta'ni ja'me pa'ikʉ ñakova pa'imakarʉ jmamakarʉta'ni ñaasomʉ repaʉ. Rʉa tĩiñea'me jã'a. Mʉsanʉkona ũcuaja'che tĩiñe cho'ome. Rʉa cu'ache cho'onata'ni mʉsanʉkona cu'ache cho'oche cuasama'me. Jã'ata'ni chekʉnapi jmamakarʉ cu'ache cho'oche ñani rʉa cuasanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ũcuaja'che pãiʉ repaʉ ñakova'te chĩ'camaka ʉjamaka paakʉta'ni tʉnoma'ñe paamʉ. Jã'ata'ni chekʉpi ñakova'te chĩ'camakarʉ jmamakarʉ paakʉna ñanita'ni, “Raijʉ̃'ʉ. Mʉ'ʉ ñakova pa'imakarʉ chĩ'camakarʉ'te tʉnokasa”, chiimʉ. Rʉa tĩiñea'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mʉsanʉkona ũcuaja'che rʉa tĩiñe cho'ome. Rʉa cu'ache cho'onata'ni mʉsanʉkona cu'ache cho'oche'te ũhasõma'ñe pa'inata'ni chekʉna jmamakarʉ cu'ache cho'oche ñani, “Mʉsanʉkona cu'ache cho'oche ũhasõjʉ̃'ʉ”, chiinaa'me mʉsanʉkona. Jã'aja'ñe cho'oto cu'amʉ. Sẽ'sevʉchi'a re'oja'cheja'che ñoñe pa'inaa'me. Charo mʉsanʉkonapi cu'ache cho'oche'te ũhasõ re'oja'che pa'ijʉ chekʉnare mʉsanʉkona i'kache'te ũcuarepa cho'ojʉ chekʉnani jã'aja'ñe chʉ'vato re'omʉ. Jã'ata'ni ũcuarepa cho'omanapi chekʉnani chʉ'vato cu'amʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Jamuchai kokaneenare Dios neemajñarʉã ĩsimanejʉ̃'ʉ, chekʉrʉmʉ repanapi chʉri kũ'ijʉ. Ũcuachi'a perlara'karʉã rʉa ro'ira'karʉã jo'chasẽse pa'ichejñana jo'kamanejʉ̃'ʉ, repara'karʉãna cha'o cha'casõjʉ. Ũcuachi'a pãi repana cu'ache cho'oche ũhacuhenare Dios chʉ'o re'oja'che chʉ'vamanejʉ̃'ʉ. Chekʉrʉmʉ repana mʉsanʉkonapi chʉ'vato jo'chasẽse cho'ocheja'che Dios chʉ'o re'oja'chere si'si cho'ocheja'che cu'ache i'kajanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare jo'e ija'che chʉ'vasi'kʉa'mʉ: —Mʉsanʉkona chiiche cuhama'ñe Dioni rʉa sẽejʉ pa'ijʉ̃'ʉ ĩsia'kʉ. Cuhama'ñe sẽejʉ pa'ito ĩsija'mʉ Repaʉ. Ũcuachi'a mʉsanʉkona Repaʉ'te sẽesi'e cha'ajʉ̃'ʉ ĩsia'kʉ. Cha'ani koojanaa'me mʉsanʉkona. Ũcuachi'a pãiʉ repaʉ'te re'okʉ vʉ'ena tĩ'a jatisa'aro'te nʉkakʉ, repaʉ chiiche'te koorepara chini cuhama'ñe rʉa jeerʉmʉ sẽeʉ pa'icheja'che cuhasõma'ñe Diore rʉa sẽejʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'ojʉ pani koojanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Repanare karache'te Diore sẽena koojanaa'me. Ũcuachi'a Repaʉ'te sẽesi'e cha'ana koojanaa'me. Ũcuachi'a pãiʉ repaʉ'te re'okʉ vʉ'ena tĩ'a jatisa'aro'te nʉkakʉ, rʉa jeerʉmʉ sẽeʉ pa'iʉ koosi'eja'che koojanaa'me pãi, cuhasõma'ñe Diore rʉa sẽejʉ pa'ina. ");
INSERT INTO coe_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Asarepajʉ̃'ʉ, mʉsanʉkona ʉmʉpãi, chĩi paana. Mʉ'ʉ chĩipi mʉ'ʉni pãre sẽeto catapʉ'te mini ĩsima'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jã'apãani, chiacha va'ire sẽeto añani mini ĩsima'me mʉsanʉkona chĩire. ");
INSERT INTO coe_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cu'ache pa'inata'ni mʉsanʉkona chĩiva'nare re'oja'chere ĩsinaa'me mʉsanʉkona. Mai Ja'kʉ, Dios, Cʉnaʉmʉ Pa'ikʉ Repaʉ'te sẽenare na'a rʉa re'oja'chere ĩsikʉ pa'ikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ũcuachi'a mʉsanʉkona chiiche chekʉnapi cho'okaiche rʉa chiime mʉsanʉkona. Jã'ajekʉna chekʉnare ũcuaja'che mʉsanʉkona chiicheja'chere re'oja'chere cho'okaijʉ pa'ijʉ̃'ʉ. Mʉsanʉkonare re'oja'che cho'okaima'tojẽ'e ũcua re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ repanare. Moisés chʉ̃'ʉ jo'kasi'ena'me Dios chʉ'o kʉasina chʉ̃'ʉjʉ tocha jo'kasi'e jã'aja'ñe cho'okaijʉ pa'iche'te kʉamʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Dios pa'icheja sañu chini jatisa'aro jmaã'carʉji kakajʉ̃'ʉ. Repanare ʉache cho'ojʉ pãi rʉa jainʉko vati toa saicheja jatisa'aro ʉjaã'capʉ pa'isa'aroja'chejekʉna cu'achejana saime. Ũcuachi'a ma'a ʉjama'a saire'ocheja'chejekʉna ũcuachejana saime. ");
INSERT INTO coe_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jã'ata'ni chʉ'ʉ chʉ̃'ʉñe jatisa'aro jmaã'carʉ pa'isa'aro kakavesacheja'che cho'ovesakʉna Dios pa'icheja te'eva'na saime pãi —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Pãi, “Dios chʉ'o kʉakainaa'me chʉkʉna”, chiijʉ jorena i'kache asa, “Ũcuarepaa'me”, chiimanejʉ̃'ʉ mʉsanʉkona. Ovejava'na kokaneemapʉ cu'ache cho'omava'naja'ñe sẽ'sevʉchi'a re'oja'cheja'che cho'onaa'me repana. Jã'ata'ni repana rekoñoã chai kokaneenaja'ñe cu'ache pa'inaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sũkiñʉã repañʉã kʉ̃isi'ere ña masire'omʉ mʉsanʉkonare. Miusava ʉche kʉ̃ima'mʉ. Ũcuachi'a miusava higopʉã kʉ̃ima'mʉ. Ũcuaja'che repana Dios chʉ'o jorejʉ kʉana pa'iche ña masijanaa'me mʉsanʉkona, repana cu'ache cho'oche'te. ");
INSERT INTO coe_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sũkiñʉã ãiñe kʉ̃iñʉã koka pa'iñʉã re'ojañʉãjekʉ sãijapʉã kʉ̃imʉ. Koka peora'ñʉrʉãta'ni cu'añʉãjekʉ sãija'imapʉã kʉ̃imʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sũkiñʉã koka pa'iʉ re'ojañʉã sãija'imapʉã kʉ̃ima'mʉ. Ũcuachi'a koka peokʉ cu'añʉã sãijapʉã kʉ̃ima'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sũkiñʉã sãijapʉã kʉ̃imañʉã, “Cu'amʉ iñʉã”, chini kueni ʉosõme pãi. Dios ũcuaja'che pãi cu'ache pa'inare vati toana saoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sũkiñʉã repañʉã kʉ̃isi'ere ña masime pãi. Ũcuachi'a, “Dios chʉ'o kʉanaa'me chʉkʉna”, chiinapi Repaʉ chʉ̃'ʉ jo'kasi'e cho'omanare, repana pa'iche'te ña, “Joreme ina”, chini masijanaa'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Pãi te'ena ija'che i'kame chʉ'ʉre: “Chʉkʉna'te Paakʉ'mʉ mʉ'ʉ”, chiime. Jã'aja'ñe i'kanata'ni Dios pa'icheja ũcuarepanʉko saimanejanaa'me repana. Chʉ'ʉ Ja'kʉ Cʉnaʉmʉ Pa'ikʉ chiiche cho'onachi'a Repaʉ pa'icheja saijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dios ũcuanʉkore pãi chi'i ro'irʉmʉ pãi jainʉko ija'che i'kajanaa'me chʉ'ʉre: “Chʉkʉna'te Paakʉ'mʉ mʉ'ʉ. Mʉ'ʉpi cho'okaiʉna Dios chʉ'o pãire kʉajʉ pa'isinaa'me chʉkʉna. Ũcuachi'a mʉ'ʉpi cho'okaiʉna pãi sa'navʉã pa'isinare vati eto saosinaa'me chʉkʉna. Ũcuachi'a mʉ'ʉpi cho'okaiʉna Diochi'a cho'omasiche rʉarepañoã cho'ojʉ pa'isinaa'me chʉkʉna”, chiijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jã'aja'ñe i'kanareta'ni Ja'kʉ chiiche cho'omanesinajejʉna ija'che i'kaja'mʉ chʉ'ʉ repanare: “Mʉsanʉkonare ñama'kʉa'mʉ chʉ'ʉ. Chʉ'ʉre ja'me pa'ima'ñe saijʉ̃'ʉ. Cu'ache cho'onaa'me mʉsanʉkona”, chiija'mʉ chʉ'ʉ repanare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vasi'kʉa'mʉ: —Pãiʉ chʉ'ʉ chʉ̃'ʉñe asa chẽa cho'okʉ pa'iche ija'chea'me: Pãiʉ masiʉ vʉ'ere cho'ora chini cojña cata pa'ichetʉ'ka repa sa'navʉã ũni nʉ'keasomʉ vʉ'ña tuu. ");
INSERT INTO coe_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Repavʉ'e cho'o pi'nisirʉmʉ oko rʉa ra, vʉ'ejatʉ'ka chiacha ko'sa tĩ'aasomʉ. Ũcuachi'a tutache rʉa tutaasomʉ. Jã'ata'ni repavʉ'e tãimaneasomʉ, tuu cata pa'ichetʉ'ka ũni nʉ'ke cho'osivʉ'ejekʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ũcuachi'a pãiʉ chʉ'ʉ chʉ̃'ʉñe asakʉta'ni jachakʉ cho'oma'kʉ pa'iche ija'chea'me: Chekʉ pãiʉ vesʉkʉjekʉ masi cuasama'kʉ vʉ'ere cho'ora chini vʉ'ña tuu meja pa'ichejana cojña rʉa sẽ'serʉã ũni nʉ'keasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Vʉ'e cho'o pi'nisirʉmʉna oko rʉa ra, vʉ'ejatʉ'ka chiacha ko'sa tĩ'aasomʉ. Ũcuachi'a tutache rʉa tutaasomʉ. Tutakʉna masi cho'omanesivʉ'ejekʉ tãni peore ñaña measõasomʉ repavʉ'e —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Repana pãi Jesupi rʉa masikʉ masi che'chokʉna asa jñano, —Ikʉ Jesús judíopãi che'chona che'chocheja'che, che'choma'ñe rʉa masi che'chomʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Repaʉ Jesús aikũti mʉisi'kʉpi cajesirʉmʉ pãi rʉa jainʉko tuhasinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ũcuarʉmʉ pãiʉ asi ravʉ paava'ʉ Jesús pa'icheja sani repaʉ ti'jñeñe ro're ñu'iʉ ija'che i'kasi'kʉa'mʉ: —Pãi Ũcuanʉkore Paakʉ, mʉ'ʉre vasoʉato vasojʉ̃'ʉ chʉ'ʉva'ʉre; vajʉra —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chikʉna Jesús repaʉni chẽakʉ i'kasi'kʉa'mʉ. —Jaʉ, vasora. Vajʉjʉ̃'ʉ —chiiʉ chẽakʉna asi teana te'erʉmʉ peore ja'jusõsi'kʉa'mʉ repaʉ ca'nivʉ pa'isi'e. ");
INSERT INTO coe_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Repaʉ'te vasocuha Jesús ija'che chʉ̃'ʉsi'kʉa'mʉ: —Ñarepajʉ̃'ʉ. Chʉ'ʉ mʉ'ʉre vasosi'e pãi chekʉnare kʉamanejʉ̃'ʉ. Kʉama'ñe judío phairi'techi'a ñojaijʉ̃'ʉ mʉ'ʉ vajʉsica'nivʉ. Ũcuaja'che aperʉmʉ Moisés chʉ̃'ʉ jo'kasi'e cu'amajñarʉã sa ĩsijʉ̃'ʉ Diore, pãipi ña mʉ'ʉ vajʉsi'ere masia'jʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Repaʉ Jesús Capernaum vʉ'ejoopo sani tĩ'asirʉmʉ Romapãiʉ sõtao cienrepanare chʉ̃'ʉkʉ repaʉ pa'ichejana rani cho'okaaʉ chini ija'che chiiʉ sẽesi'kʉa'mʉ repaʉ'te: —Pãi Ũcuanʉkore Paakʉ, chʉ'ʉre cho'oche cho'okaiva'ʉ jũ'iʉ repaʉ ca'nivʉ ru'tusõsiva'ʉ ũhimʉ. Ũcuachi'a repaʉ ca'nivʉ peore rʉa asiche asikʉasomʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chikʉna Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉpi sani vasora repaʉ'te —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Pãi Ũcuanʉkore Paakʉ, chʉ'ʉ rʉa vesʉʉ vʉ'ena mʉ'ʉpi rʉa masiʉji kakache vajʉchʉamʉ chʉ'ʉre. Ija'che pa'ikʉ'mʉ chʉ'ʉ: Chekʉnapi sõtao ainapi chʉ̃'ʉnaa'me chʉ'ʉre. Chʉ'ʉ ũcuaja'che chekʉnare sõtao chʉ̃'ʉkʉ'mʉ. Chʉ'ʉpi sõtaoni te'eʉ'te, “Saijʉ̃'ʉ”, chiito saimʉ repaʉ. Ũcuaja'che chekʉre, “Raijʉ̃'ʉ”, chiito raimʉ repaʉ. Ũcuachi'a chʉ'ʉre cho'oche cho'okaikʉni ũcuaʉache'te chʉ'ʉpi chʉ̃'ʉto cho'okaimʉ repaʉ. Jã'ajamakarʉchi'a chʉ̃'ʉmasikʉ'mʉ chʉ'ʉ. Mʉ'ʉta'ni peore chʉ̃'ʉmasikʉ'mʉ. Jã'ajekʉna mʉ'ʉpi chʉ'ʉ vʉ'e saima'ñe, ũcua ichejapi chʉ'ʉre cho'oche cho'okaikʉni, “Vajʉjʉ̃'ʉ”, chiito vajʉja'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jã'aja'ñe i'kaʉna asa jñano Jesús, repaʉ'te ja'me ku'inare pãi ija'che i'kasi'kʉa'mʉ: —Israelpãi chʉ'ʉre jainʉko cuasanareta'ni te'eʉ'terejẽ'e ikʉ chʉ'ʉre masi cuasacheja'che cuasanare chuta'a tijñama'kʉa'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na'a pa'isirʉmʉ pãi judío peona chʉ'ʉre cuasanajejʉ ʉ̃sʉʉ mʉikã'kona'me ʉ̃sʉʉ na'ikã'kopi jainʉko rani Dios chʉ̃'ʉkʉ pa'ichejana sani Abrahamna'me Isaana'me Jacobna'me pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judíorepanata'ni, “Dios pa'icheja saijanaa'me chʉkʉna”, chiisina Repaʉ'te masi cuasamanajejʉ chijachejana vati toana saocojño uujʉ oijʉ cõjire asoche ãijʉ pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jã'aja'ñe i'kacuha sõtao chʉ̃'ʉkʉ'te ija'che i'kasi'kʉa'mʉ Jesús: —Mʉ'ʉ vʉ'ena co'ijʉ̃'ʉ. Mʉ'ʉ chʉ'ʉre, “Jesús chʉ'ʉre cho'oche cho'okaikʉ'te so'opi vasoja'mʉ”, chiiʉ cuasasi'e ũcuarepa cho'ocojñoja'mʉ —chiisi'kʉa'mʉ Jesús. Ũcuate'erʉmʉna jũ'iva'ʉ vʉ'e ũhiva'ʉ teana vajʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ũcuarʉmʉ Jesús Simón Pedro vʉ'ena saniasomʉ. Sani tĩ'a kaka ñato repaʉ vao cha'vo ravʉna jũ'io ũhio paniasomo. ");
INSERT INTO coe_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ũcuarʉmʉ Jesupi repao jʉ̃tʉna chẽaʉna cha'vosi'e teana chʉrʉsõasomʉ repao'te. Ũcuarʉmʉ repao ũhio pa'isiva'o teana vʉni ãure ãuasomo repanare. ");
INSERT INTO coe_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na'isõcuhasirʉmʉna pãi vati paava'nare rʉa jainʉkore Jesús pa'ichejana raasome. Ũcuarʉmʉ Jesús repanare pãi sa'navʉã pa'inare vati, chʉ'o te'echʉ'ochi'api i'ka eto saosõkaniasomʉ. Ũcuachi'a chekʉnare ravʉ jũ'iva'nare ũcuanʉkore vasoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesupi jã'aja'ñe cho'oʉna aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías tocha jo'kasi'epi ũcuarepa ti'jñecuhasi'kʉa'mʉ, ija'che chiicheji: Maipi koka peoto ja'me cho'okaimʉ repaʉ. Ũcuaja'che mai jũ'iñe ravʉ vasomʉ repaʉ, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ũcuarʉmʉ Jesús pãipi jairepanʉko si'acakã'jño pa'ijʉna ña chʉkʉna'te repaʉ neenare, “Ira chiara chekʉkã'kona jẽñu”, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chuta'a chʉkʉna jẽ'ema'tona judíopãi che'chokʉ rani Jesure ija'che i'kasi'kʉa'mʉ: —Masiʉ, mʉ'ʉna'me ũcuaʉachejña mʉ'ʉ ku'ichejña ku'iʉ mʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pasa chiimʉ chʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chikʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Ã'care'achai kãicojña paame. Pĩ'ava'na ũcuaja'che kãisʉovʉã paame. Chʉ'ʉ, pãire ja'me paaʉ chini Dios Raosi'kʉta'ni kãichejñajẽ'e peova'ʉ pa'imʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ũcuarʉmʉ chekʉ Jesure chiikʉ ija'che i'kasi'kʉa'mʉ repaʉ'te: —Pãi Ũcuanʉkore Paakʉ, cha'ajʉ̃'ʉ aperʉmʉ. Chʉ'ʉ ja'kʉva'ʉni tãjasa. ¿Ʉ̃sema'kʉ mʉ'ʉ? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chikʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Chekʉnapi chʉ'ʉre cuasamanajejʉ repana rekoñoã jũnisõsinaja'ñe pa'inapi repana majapãi jũ'isinare tãa'jʉ. Mʉ'ʉta'ni rani chʉ'ʉna'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ũcuarʉmʉ Jesús chʉkʉna repaʉ neenana'me choovʉ ʉjavʉji tuni jẽ'esi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jẽ'ejʉna rʉarepa tutakʉna chiaraji fa'akʉ okopi ja'ñʉkʉna choovʉ timupi'rasi'kʉa'mʉ. Jã'a cho'oto Jesús jẽ'eʉ kãnisõsi'kʉa'mʉ reparʉmʉ. ");
INSERT INTO coe_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ũcuarʉmʉ chʉkʉna repaʉ neena choovʉji runisõcuhakʉna ũcuaʉ ũhichejana mʉa ija'che ʉjachʉ'opi i'ka vʉosinaa'me repaʉ'te: —¡Chʉkʉna'te Paakʉ, runisõcuhame mai! Vʉni cho'okaijʉ̃'ʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chitena jñano vʉni chʉkʉna'te i'kasi'kʉa'mʉ repaʉ. —¿Je'se pa'iʉna mʉsanʉkona rʉarepa vajʉchʉche? Chʉ'ʉre masi cuasama'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ. Jã'aja'ñe i'ka vʉni, —Tutachena'me fa'ache cuhajʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. Chikʉna tutachena'me fa'ache teana ũcuapa'rʉva cuhasi'kʉa'mʉ. Jo'e re'oja'ira cuhasi'kʉa'mʉ chiara. ");
INSERT INTO coe_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jã'aja'ñe cho'oʉna ña jñano sãiñechi'a sẽniasasinaa'me chʉkʉna. —¿Keeja'iʉjekʉ ikʉ ija'che cho'okʉ? Tutachena'me fa'ache cuhamʉ ikʉ chʉ̃'ʉñe —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chiara chekʉkã'ko cacheja Gadara cheja chʉkʉna jẽni tĩ'asirʉmʉ pãi vati paana te'eka'chapana pãi tãchejña pa'inapi eta tijñasinaa'me Jesure. Repanapi si'arʉmʉ eta rʉarepa asivajʉchʉache cho'ojʉna pãi repacheja caraivajʉchʉasome. ");
INSERT INTO coe_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Repaʉ'te Jesure eta tijña cuijʉ ija'che i'kasinaa'me repana: —Jesús, Dios Mamakʉ, ¿ʉ̃que raikʉ mʉ'ʉ? Asi cho'omanejʉ̃'ʉ chʉkʉna'te. Chʉkʉna'te cu'ache cho'ojarʉmʉ chuta'a tĩ'ama'mʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ũcuacheja kueñere jo'chasẽse kuanupʉ ãure mu'ka ãijʉ pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jã'ajekʉna vati Jesure rʉa i'kajʉ ija'che sẽesinaa'me: —Chʉkʉna'te etoni jo'chasẽse sa'navʉã kakache ʉ̃semanejʉ̃'ʉ; kakañu chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jã'aja'ñe i'kajʉ rʉarepa sẽejʉna Jesús i'kasi'kʉa'mʉ repanare. —Jaʉ —chiisi'kʉa'mʉ. Chikʉna repana vati eta sani jo'chasẽseva'nani kakasinaa'me. Vatipi kakarena jo'chasẽseva'na teana ũcuanʉko vʉ'vʉ aikũti ʉjakũti caripaji chiarana tuã'tua ru'tu jũnisõsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Repava'nare kuirasiva'na pãi jã'aja'ñe cho'orena ña vati paasinare cho'osi'ere peore pãire kʉañu chini vʉ'ejoopona vʉ'vʉsõsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kʉarena asa kʉkʉsõ pãi ũcuanʉko Jesús pa'ichejana rani, repaʉ'te Jesure, —Icheja pa'ima'ñe tĩichejana saijʉ̃'ʉ —chiijʉ rʉa i'kasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jã'a cho'ocuhasirʉmʉ Jesús jo'e choovʉ tuni chiara chekʉkã'kona ũcuaʉ pa'ijoopona jẽni tĩ'aasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Repaʉ jẽni pa'itona pãi nʉka ku'imava'ʉre ũhikãa ũhiva'ʉni Jesús pa'ichejana kuãijʉ raasome, re'oja'che cuasajʉ. “Iva'ʉre Jesús vasoja'mʉ”, chini cuasajʉ rasi'ere ña jũ'iva'ʉre i'kaasomʉ Jesús. —Pojokʉ pa'ijʉ̃'ʉ jmava'ʉ. Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosi'e jo'e cuasamaneja'mʉ chʉ'ʉ —chiniasomʉ Jesús repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jã'aja'ñe i'kaʉna asa judíopãi che'chona te'ena cuasaasome. “Dios asacuheche'te i'kamʉ ikʉ jã'a”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jã'ata'ni Jesús repana cuasache'te ña masi ija'che i'kaasomʉ repanare: —¿Je'se pa'iʉna mʉsanʉkona cu'ache cuasache? ");
INSERT INTO coe_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chʉ'ʉ ikʉre, “Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ”, chiisi'ere asa, “Joreʉ'mʉ ikʉ. Pãi jã'aja'ñe cho'omasinajẽ'e peome”, chiijʉ cuasame. Jã'ata'ni chʉ'ʉpi ikʉre, “Vʉni nʉka ku'ijʉ̃'ʉ”, chikʉna ikʉpi vʉni nʉkakʉna ñani mʉsanʉkona, “Jorema'kʉa'mʉ Jesús. Repaʉ i'kasi'e ũcuarepa cho'omasimʉ”, chiijacosome. ");
INSERT INTO coe_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Chʉ'ʉ, pãire ja'me paaʉ chini Dios Raosi'kʉ chejare pa'iʉ pãi cu'ache cho'oche tʉnoñena'me pãi vasoche cho'omasiʉ pa'iche'te mʉsanʉkonapi ña masia'jʉ chini vasokaija'mʉ chʉ'ʉ ikʉre —chiniasomʉ Jesús repanare. Chini nʉka ku'imava'ʉre i'kaasomʉ repaʉ. —Vʉni mʉ'ʉ ũhisikãa mini vʉ'ena co'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chikʉna repaʉ nʉka ku'imanesi'kʉ vʉni vʉ'ena co'isõasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jã'aja'ñe cho'oʉna ña kʉkʉsõ pãi Dioni pojojʉ, “Dios peore Masiʉji cho'okaiʉna ikʉ maija'iʉ rʉa cho'omasikʉ'mʉ”, chiijʉ pojoasome. ");
INSERT INTO coe_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ũcuachejapi rani Jesús chʉ'ʉre Mateo'te pãi chʉ̃'ʉnare kuri sẽni kookaina pa'ivʉ'e ñu'iʉ pa'ikʉni ña i'kasi'kʉa'mʉ. —Rani, chʉ'ʉni ja'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ chʉ'ʉre. Chikʉna asa, “Jaʉ”, chini vʉni ũcuaʉna'me saisi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Reparʉmʉ Jesús repaʉ neenana'me chʉ'ʉ vʉ'ena mʉa ãu ãisi'kʉa'mʉ. Repaʉ ãu ãiʉ ñu'itona Roma vʉ'ejoopo canare pãi chʉ̃'ʉnare kuri kookainana'me chekʉna cu'ache pa'ina, mʉta kaka chʉkʉna ñu'ichejana pʉʉsinaa'me ãure ja'me ãñu chini. ");
INSERT INTO coe_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Repanapi chʉkʉnani ja'me ñu'ijʉna ña fariseopãi ija'che sẽniasasinaa'me chʉkʉna'te Jesús neenare: —¿Je'se pa'iʉna mʉsanʉkonare paakʉ che'chokʉ kuri kookainana'me cu'ache pa'inare ja'me ãu ãikʉ? —chiisinaa'me repana chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chitena asa Jesús ija'che i'kasi'kʉa'mʉ repanare: —Pãi vajʉna ʉ̃ko cho'oche chiima'me. Jũ'iva'nata'ni ʉ̃ko cho'oche chiime. ");
INSERT INTO coe_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Chʉ'ʉ pãi, “Re'onaa'me chʉkʉna”, chiinani, “Cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉma'mʉ icheja cheja. Pãi, “Cu'ache pa'inaa'me chʉkʉna”, chiiva'narechi'a, “Mʉsanʉkona cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉa'mʉ chʉ'ʉ. Dios chʉ'o aperʉmʉ tocha jo'kasi'ere che'chejʉ Repaʉ i'kache'te asa masijʉ̃'ʉ, ija'che kʉache'te: Mʉsanʉkona cu'ache cho'oche ro'iñu chini chʉ'ʉre ĩsisiva'nani va'iva'nare vani ʉosõjʉ̃'ʉ, chiiʉ chʉ̃'ʉmʉ chʉ'ʉ. Jã'ata'ni pãi chekʉnare ña oijʉ pa'ijʉ̃'ʉ, chiiʉ na'a rʉa chʉ̃'ʉmʉ chʉ'ʉ mʉsanʉkonare, chiimʉ repa —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ũcuarʉmʉ Juan Pãi Okoro'vekʉ neena rani ija'che i'kasinaa'me Jesure: —Chʉkʉna si'arʉmʉ te'eñoã ãu ãima'ñe pa'ijʉ Diore sẽejʉ pa'inaa'me, fariseopãi ũcuaja'che. Mʉ'ʉ neena, ¿je'se pa'iʉna jã'aja'ñe cho'ojʉ pa'ima'ñe? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chitena Jesús i'kasi'kʉa'mʉ repanare. —Pãi, romire vejajʉ ãure ãapʉ chini soicojñosina sʉmana pa'ima'ñe pojojʉ ãu ãime, romi vejakʉji pa'iʉna. Na'a pa'isirʉmʉna romi vejasi'kʉre chekʉnapi sasõjanaa'me chekʉchejana. Jã'arʉmʉta'ni repaʉni oijʉ ãu ãima'ñe pa'ijanaa'me repana. (Chʉ'ʉ neena ũcuaja'che na'a pa'isirʉmʉna Dioni sẽejʉ te'eñoã ãu ãima'ñe pa'ijanaa'me, chʉ'ʉpi peokʉna) —chiisi'kʉa'mʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Reparʉmʉ pãi te'ena aperʉmʉ che'chosi'ena'me mama che'choche ũcuapa'rʉvachi'a cuasañu chini aperʉmʉ che'chosi'e ũhacuhesinaa'me. Chekʉnata'ni mama che'choche asacuhesinaa'me. Jã'ajekʉna Jesús repanani chʉ'vakʉ ija'che i'kasi'kʉa'mʉ: —Aikãarʉji che'resõru mamase'rechoji che're aikãarʉna põ juhamanaa'me pãi. Jã'aja'ñe juha pi'ni choaru aikãarʉ mamase'recho põ juhasikãarʉjekʉ rueni ji'rosõʉna na'a ʉjacoje che'remʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ũcuachi'a pĩsi ʉche cono mama cho'oni va'iva'na ca'nituru aituruna ro'vemanaa'me pãi. Aituruna ro'veru conopi kosani saʉ che'resõ pĩsi ʉche conojẽ'e cho'osõkʉ turujẽ'e ũcuaja'che che're cho'osõmʉ. Jã'ajekʉna pãi pĩsi ʉche cono mama cho'oni turu mamaturuna ro'veme. Jã'aja'ñejekʉna turuna'me cono cho'osõma'mʉ —chiiʉ chʉ'vasi'kʉa'mʉ Jesús repanare Juan neenare. ");
INSERT INTO coe_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Repaʉ Jesús chuta'a i'katona judíopãi chi'ivʉ'e chʉ̃'ʉkʉ rani repaʉ ti'jñeñena ro're pʉʉ ñu'iʉ ija'che i'kasi'kʉa'mʉ: —Chʉ'ʉ chĩiva'o jũnisõcuhasi'koa'mo. Jã'ata'ni mʉ'ʉpi sani repava'oni chẽato vajʉraija'mo repava'o —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chikʉna asa Jesús vʉni ũcuaʉna'me saisi'kʉa'mʉ. Chʉkʉna repaʉ neena ũcuachi'a ja'me saisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Saijʉna romio docerepaʉ̃sʉrʉmʉ chie ravʉ jũ'iko rani Jesús cho'jepi repaʉ ju'ikãa pʉso juhasirʉ'tʉvana chẽaasomo. ");
INSERT INTO coe_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ija'che cuasaasomo repao: “Jesús ju'ikãa chẽanijẽ'e vajʉja'mo chʉ'ʉ”, chiio cuasako chẽaasomo repao. ");
INSERT INTO coe_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jã'ata'ni Jesús repaoji chẽaona chʉri ña ija'che i'kasi'kʉa'mʉ repao'te: —Mʉ'ʉva'o, pojoko pa'ijʉ̃'ʉ. “Ikʉ chʉ'ʉre vasoja'mʉ”, chiio cuasakojeko vajʉja'mo mʉ'ʉ —chiisi'kʉa'mʉ Jesús repao'te. Ũcuarʉmʉpi teana te'erʉmʉ vajʉasomo repao. ");
INSERT INTO coe_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jã'aja'ñe cho'ocuha Jesús jo'e saiʉ judíopãi chi'ivʉ'e chʉ̃'ʉkʉ vʉ'ena tĩ'a ñato pãi repava'oni sa tãpi'rajʉ phĩ'covʉãre juhijʉna chekʉna otare rʉa oijʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jã'aja'ñe cho'ojʉna ña Jesús i'kaasomʉ repanare. —Re'omʉ. Etajʉ̃'ʉ icheja mʉsanʉkona. Jũnisõsiva'oma'mo iko. Rupʉ kãisiva'oa'mo —chiniasomʉ repaʉ repanare. Jã'aja'ñe i'kakʉna asa jachajʉ Jesure pãisoasome repana. ");
INSERT INTO coe_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pãisojʉna repanare etosi'kʉa'mʉ repaʉ. Etocuha repava'o pa'iruupʉna kaka repao jʉ̃tʉna chẽa i'kaʉna vajʉrani teana vʉni nʉkaasomo repava'o. ");
INSERT INTO coe_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ũcuarʉmʉ pãipi Jesús repao'te vasosi'ere asa chekʉnani kʉarena repacheja si'achejña pa'ina repaʉ cho'osi'e rʉa jainʉko asajʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ũcuachejapi eta chʉkʉna repaʉ neenana'me saiʉna Jesure na'ava'na te'eka'chapana cuijʉ ʉjachʉ'opi ija'che i'kajʉ tuhasinaa'me: —David aperʉmʉ pa'isi'kʉ jojosi'kʉ, oijʉ̃'ʉ chʉkʉnava'nare —chiijʉ tuhasinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Repaʉ Jesús vʉ'e kakasirʉmʉ repana na'ava'na ja'me kaka repaʉni kueñe tĩ'arena repanare ija'che sẽniasasi'kʉa'mʉ repaʉ: —Mʉsanʉkona chʉ'ʉre, ¿“Maiva'nare vasoja'mʉ ikʉ”, chiijʉ cuasache? —chiisi'kʉa'mʉ. Chiiʉna, —Jʉ̃jʉ, Pãi Ũcuanʉkore Paakʉ, “Chʉkʉnava'nare vasoja'mʉ mʉ'ʉ”, chiijʉ cuasame chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chitena Jesús repanare ñakocaãna jʉ̃jñapi jakʉ ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkonapi chʉ'ʉni, “Jesús maire vasoja'mʉ”, chiijʉ cuasajʉna ñakocaã ñoja'mʉ mʉsanʉkonare chura —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Repaʉji jã'aja'ñe cho'okʉ i'kaʉna repana ñakocaã teana care'osõsi'kʉa'mʉ. Repanare ñakocaã vasocuha Jesús ija'che rʉa i'kasi'kʉa'mʉ repanare: —Chʉ'ʉ mʉsanʉkonare vasosi'e chekʉnare kʉamairo pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chiisi'eta'ni sani repacheja si'achejña ku'ijʉ kʉajʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Repana na'ava'na pa'isiva'na etatona pãi vatini paakʉ chʉ'o cutuma'kʉre Jesús pa'ivʉ'ena ra cuaasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cuaarena Jesupi vatini eto saokakʉna repaʉ pãiʉ chʉ'o cutumanesi'kʉ teana chʉ'o cutusi'kʉa'mʉ. Repaʉji cutukʉna asa jñano pãi ija'che i'kasinaa'me: —Mai Israel cheja cana ija'che cho'oche jmamakarʉjẽ'e ñamanaa'me —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseopãita'ni cu'ache cuasajʉ ija'che i'kasinaa'me: —Vati chʉ̃'ʉkʉji cho'okaiʉna ikʉ Jesús vati ũcuajanare eto saomasimʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ũcuarʉmʉ Jesús vʉ'ñajoopoã si'ajoopoã ku'iʉ ʉjajoopoãna'me jmajoorʉã judíopãi chi'ivʉ'ña repajoopoã pa'ivʉ'ñana kaka che'chokʉ ku'isi'kʉa'mʉ. Ũcuachi'a pãi cu'ache cho'oche ũhasinare Dios chẽa paache kʉachʉ'ore Repaʉ chʉ'o re'oja'chere chʉ'vakʉ ku'iʉ, pãiva'nare ravʉ si'ache jũ'iva'nare ca'nivʉã asiche si'ache jũ'iva'nare vasosi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Repaʉ ku'ichejña canapi pãipi Dios chʉ'o chʉ'vajʉ cho'okainani peojʉ ovejava'na kuirakʉ'te peova'naja'ñe pa'ijʉ vesʉjʉ chʉova'na pa'ijʉna Jesús ña oisi'kʉa'mʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Repanani ña oiʉ chʉkʉna'te repaʉ neenare ija'che i'kasi'kʉa'mʉ repaʉ: —Dios chʉ'o chʉ'vanapi karasõjʉna Repaʉ chʉ'o chuta'a asamana rʉa jainʉko pa'ime. Jã'ajekʉna Dioni sẽejʉ̃'ʉ mʉsanʉkona, Repaʉ chʉ'o chʉ'vanani na'a jainʉkore chẽa raoa'kʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare docerepanare soni rao ija'che i'kasi'kʉa'mʉ: “Chʉ'ʉpi cho'okaiʉna ija'che cho'omasijanaa'me mʉsanʉkona: Vati pãi sa'navʉã pa'inare eto saomasijanaa'me. Ũcuachi'a pãi ravʉ si'ache jũ'inare vasomasijanaa'me mʉsanʉkona”, chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chʉkʉna repaʉ chẽa saosina mamia'me ie: Charo Simonni chẽasi'kʉa'mʉ repaʉ. Cheke mami Pedro ve'esi'kʉa'mʉ repaʉ. Andrere repaʉ Simón Pedro cho'jeʉ'te ũcuaja'che chẽasi'kʉa'mʉ. Zebedeo mamachĩi ũcuachi'a Santiagona'me Juanre chẽasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ũcuaja'che Felipe'te, Bartolomere, Tomare, chʉ'ʉre Mateo'te Romapãi chʉ̃'ʉnare kuri kookaisi'kʉre chẽasi'kʉa'mʉ repaʉ. Chekʉre Santiago'te Alfeo mamakʉ'te chẽasi'kʉa'mʉ. Tadeo'te ũcuachi'a chẽasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Chekʉre Simonre ũcuachi'a, cananistapãi ja'me pa'ikʉ'te chẽasi'kʉa'mʉ. Ũcuachi'a Judas Iscariote'te chẽasi'kʉa'mʉ. Na'a pa'isirʉmʉ repaʉ Judas Iscariote Jesuni cu'ache cho'oa'jʉ chini chekʉnani ĩsiasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Reparʉmʉ Jesús chʉkʉna'te repaʉ chẽasinare docerepanare Dios chʉ'ore chʉ'vaa'jʉ chini saopi'rakʉ ija'che chʉ'vasi'kʉa'mʉ: —Judío peona pa'ichejña saimanejʉ̃'ʉ mʉsanʉkona. Ũcuachi'a Samaria cheja pa'ijoopoã saimanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jã'achejña saima'ñe Dios chʉ'o vesʉjʉ ovejava'na kuirakʉ'te peova'naja'ñe chʉova'na pa'inani judíopãire sani chʉ'vajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sani, “Dios Raosi'kʉ pãi ũcuanʉkore chʉ̃'ʉpi'ramʉ”, chiijʉ chʉ'vajʉ̃'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ũcuachi'a ravʉ jũ'iva'nare vasokaijʉ jũnisõsiva'narejẽ'e vasokaijʉ̃'ʉ. Asi ravʉ paanare vasojʉ̃'ʉ. Ũcuachi'a vati pãi sa'navʉã pa'inare eto saosõkaijʉ̃'ʉ. Jã'aja'ñe cho'omasiche Diopi rupʉ ĩsimʉ mʉsanʉkonare. Jã'ajekʉna chekʉnare kuri sẽema'ñe rupʉ cho'okaijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ũcuachi'a sani kurijẽ'e samanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Turu cu'amajñarʉã mañajaturujẽ'e samanejʉ̃'ʉ. Kãña sa'ñejʉ ju'ikãñajẽ'e sama'ñe mʉsanʉkona ju'ikãñarʉãchi'a ju'ijʉ ku'ijʉ̃'ʉ. Cũ'akorophe'rejẽ'e sama'ñe mʉsanʉkona ju'iphe'rerʉãchi'a ju'ijʉ ku'ijʉ̃'ʉ. Vãsoñoã jo'e chekʉñoã sama'ñe mʉsanʉkona jʉ'vejʉ ku'iñoãchi'a sajʉ̃'ʉ. Ãuta'ni mʉsanʉkona chʉ'vajanapi ãua'jʉ mʉsanʉkonare, repanare chʉ'vache ro'i. ");
INSERT INTO coe_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Sani ku'ijʉ vʉ'ejoopona tĩ'ani repajoopo cakʉpi re'okʉji, “Chʉ'ʉ vʉ'ere rani pa'ijʉ̃'ʉ”, chiikʉ vʉ'ere mʉa pa'ijʉ̃'ʉ, mʉsanʉkona repacheja sairʉmʉjatʉ'ka. ");
INSERT INTO coe_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Repaʉ vʉ'e mʉa kakani, repavʉ'e pa'inare, “Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona”, chiijʉ kakajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Repavʉ'e pa'inapi re'oja'che pa'ineena pa'ito mʉsanʉkona repanare Diore sẽekaisi'e ũcuarepa re'oja'che cho'okaija'mʉ Repaʉ. Jã'ata'ni repanapi re'oja'che pa'ineemana pa'ito pãaja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chekʉrʉmʉ mʉsanʉkonapi pãi vʉ'ena jã'apãani vʉ'ejoopona sani tĩ'arena repacheja pa'inapi mʉsanʉkonani cuaocuhejʉ Dios chʉ'ojẽ'e asacuheto mʉsanʉkona cũ'akorophe're chʉ̃'isi'ere cha'ore tĩ'to to'jñojʉ eta saijʉ̃'ʉ, pãipi ña repana cu'ache cho'osi'ere masia'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dios pãi ũcuanʉkore chi'i ro'iumucuse tĩ'aru Sodoma vʉ'ejoopona'me Gomorra vʉ'ejoopo pa'isinare rʉa cu'ache ti'jñeja'mʉ. Jã'ata'ni mʉsanʉkona chʉ'vache asacuhesinare na'a rʉa cu'ache ti'jñeja'mʉ reparʉmʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare jo'e ija'che i'kasi'kʉa'mʉ: —Ñarepajʉ pa'ijʉ̃'ʉ. Chʉ'ʉ mʉsanʉkonare, chai pa'ichejñana ovejava'nare saocheja'che mʉsanʉkonare cuhena pa'ichejñana saomʉ. Jã'ajekʉna aña masicheja'che ñarepajʉ ku'imasijʉ ũkupova'na kokaneema'ñeja'ñe re'oja'che pa'ijʉ chekʉnare cu'ache cho'oma'ñe chʉ'vajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ñarepajʉ pa'ijʉ̃'ʉ. Chekʉrʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna chẽa judíopãi chʉ̃'ʉna pa'ivʉ'ena sa jo'ka, repanapi suĩ'sueche'te chʉ̃'ʉrena judíopãi chi'ivʉ'ñana cuaa suĩ'suejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chekʉrʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna chẽa pãi te'eva'nare chʉ̃'ʉna pa'ivʉ'ñana ũcuachi'a jainʉkore chʉ̃'ʉna pa'ivʉ'ñajatʉ'ka sa jo'kajanaa'me mʉsanʉkonare, cu'ache cho'oche'te chʉ̃'ʉa'jʉ chini. Jã'aja'ñe cho'ojʉna repanare pãi chʉ̃'ʉnare chʉ'ʉ pa'iche'te kʉa asojanaa'me mʉsanʉkona judío peonare ũcuachi'a. ");
INSERT INTO coe_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jã'ata'ni pãipi mʉsanʉkonani jã'aja'ñe cho'oto, “¿Je'se sãiñe i'kaja'che chʉ'ʉ?” Ũcuachi'a, “¿Keejachʉ'opi i'kaja'che chʉ'ʉ?”, chiijʉ cuasamanejʉ̃'ʉ. Mʉsanʉkonare sãiñe i'kache tĩ'arʉmʉ mʉsanʉkona i'kajache chʉ'o Diopi rekoñoãna kʉaja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mʉsanʉkona te'ena cuasajʉ i'kama'ñe mai Ja'kʉ Dios Rekochoji cho'okaiʉna masi i'kajanaa'me repanare. ");
INSERT INTO coe_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Reparʉmʉ pãi repana cho'jechĩi chʉ'ʉni cuasajʉna chẽa sa, “Vanisõjʉ̃'ʉ inare”, chiijʉ jo'kajanaa'me. Chekʉna repana majaa'chʉpãipi chʉ'ʉni cuasajʉna ũcuaja'che cu'ache cho'ojanaa'me repanare. Pʉka'kʉpãi ũcuachi'a repana mamachĩipi chʉ'ʉni cuasajʉna chẽa sa, “Inare vanisõjʉ̃'ʉ”, chiijʉ jo'kajanaa'me. Chekʉna ũcuachi'a repana pʉka'kʉpãipi chʉ'ʉni cuasajʉna ũcuaja'che cu'ache cho'ojanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pãi ũcuanʉko mʉsanʉkonare chʉ'ʉni cuasajʉna rʉa cuhejanaa'me. Jã'ata'ni mʉsanʉkonapi chʉ'ʉre cuasache'te ũhama'ñe jũnisõrʉmʉjatʉ'ka masi cuasajʉ pani Dios pa'ichejare ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pãipi mʉsanʉkona saisijoopo canapi mʉsanʉkonani cu'ache cho'oto chekʉjoopona vʉ'vʉsõjʉ̃'ʉ. Chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ mʉsanʉkona chuta'a Israel cheja pa'ijoopoã peore kuni si'ama'tona cʉnaʉmʉ mʉisi'kʉpi jo'e cajeja'mʉ icheja cheja. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Utija'o che'chenapi repanare che'chokʉ cu'ache i'kacojñoñe'te, “Maita'ni cu'ache i'kacojñomanejanaa'me”, chiijʉ cuasato cu'amʉ. Ũcuachi'a cho'oche'te rupʉ cho'okaaʉ chini chẽa paacojñova'ʉpi repaʉ'te paakʉ cu'ache i'kacojñoñe'te, “Chʉ'ʉta'ni cu'ache i'kacojñomaneja'mʉ”, chiiʉ cuasato cu'amʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Utija'o che'chena repanare che'chokʉji cu'ache i'kacojñoto repaʉ i'kacojñosi'eja'che cu'ache i'kacojñojanaa'me. Ũcuachi'a pãiʉ'te cho'oche cho'okaiva'ʉ repaʉ'te paakʉji cu'ache i'kacojñoto repaʉ i'kacojñosi'eja'che cu'ache i'kacojñoja'mʉ. Mʉsanʉkona ũcuaja'che chʉ'ʉ cu'ache i'kacojñoñeja'ñe na'a rʉa cu'ache i'kacojñojanaa'me. Pãi chʉ'ʉre, “Vati chʉ̃'ʉkʉ'mʉ mʉ'ʉ; Beelzebua'mʉ”, chiisinaa'me. Jã'ajekʉna pãi mʉsanʉkonare chʉ'ʉ majapãijanajejʉna ũcuare i'kajʉ na'a rʉa cu'ache i'kajanaa'me —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ũcuarʉmʉ Jesús chʉkʉna'te ija'che i'kakʉ jo'e chʉ'vasi'kʉa'mʉ: —Pãi mʉsanʉkonare vanisõñu chiinare vajʉchʉmanejʉ̃'ʉ. Repana cu'ache cho'oñu chini rope'e cho'oche peore pãi ũcuanʉko masijanaa'me. Ũcuachi'a repana rope'e cutujʉ pa'isi'e peore pãi ũcuanʉko masijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ũcuachi'a chʉ'ʉ mʉsanʉkonare ñamina rope'e i'kasi'e pãi ũcuanʉko asajʉ'te umucusena kʉajʉ̃'ʉ. Ũcuachi'a chʉ'ʉ mʉsanʉkonare vʉ'ena cuaa rope'e kʉasi'e pãi ũcuanʉko pa'ichejana ʉjachʉ'o i'kajʉ kʉajʉ̃'ʉ ũcuanʉko asaa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉsanʉkonare vanisõñu chiinare pãi vajʉchʉmanejʉ̃'ʉ. Ca'nivʉã vanisõnijẽ'e mʉsanʉkona rekoñoãta'ni cu'ache cho'omanejanaa'me repana. Mʉsanʉkonare jũ'iñe chʉ̃'ʉmasikʉ vati toa Saomasikʉni Diorechi'a vajʉchʉjʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pĩ'a ka'chava'na jmava'na kuri te'ere'revachi'a ro'ime. Te'ere'revachi'a ro'iva'nare mai Ja'kʉ Diopi jũ'iʉ̃seto te'eva'ʉjẽ'e jũnisõmanera'ame repana. ");
INSERT INTO coe_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ũcuachi'a Repaʉ Dios mʉsanʉkona pa'iche peore masikʉjekʉ mʉsanʉkona sĩjoquee raña kuẽkuesi'echi'a paakʉjekʉ masimʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pĩ'ava'nare peore kuiramʉ Dios. Mʉsanʉkonare pãi na'a rʉa cuasakʉ na'a re'oja'che cho'okaiʉ pa'imʉ Repaʉ. Jã'ajekʉna chekʉnare pãi vajʉchʉmanejʉ̃'ʉ —chiisi'kʉa'mʉ Jesús chʉkʉna'te repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ũcuarʉmʉ Jesús jo'e ija'che i'kasi'kʉa'mʉ: —Pãi te'ena, chekʉna asajʉ'te vajʉchʉma'ñe, “Jesure cuasanaa'me chʉkʉna”, chiime. Na'a pa'isirʉmʉ chʉ'ʉ jã'aja'ñe i'kasinare Ja'kʉ Cʉnaʉmʉ Pa'ikʉ asakʉ'te, “Chʉ'ʉ neenaa'me ina”, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jã'ata'ni chekʉna pãire vajʉchʉjʉ repanapi asajʉ chini, “Jesure cuasamanaa'me chʉkʉna”, chiime. Na'a pa'isirʉmʉ jã'aja'ñe i'kasinare chʉ'ʉ Ja'kʉ Cʉnaʉmʉ Pa'ikʉ asakʉ'te, “Chʉ'ʉ neenama'me ina”, chiija'mʉ chʉ'ʉ repanare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ũcuarʉmʉ Jesús jo'e ija'che i'kasi'kʉa'mʉ chʉkʉna'te: —Ija'che cuasacosome mʉsanʉkona: “Jesús raisirʉmʉta'ni pãi chekʉnare cuhema'ñe re'oja'che pa'ijanaa'me”, chiijʉ cuasacosome. Jã'ata'ni chʉ'ʉpi rani che'chokʉna pãi chʉ'ʉ che'choche asacuhenapi asaneenani pe'rujʉ cuheme. ");
INSERT INTO coe_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chekʉrʉmʉ pʉka'kʉpi chʉ'ʉni cuasato mamakʉji cuheja'mʉ. Chekʉrʉmʉ pʉka'kopi chʉ'ʉni cuasato mamakoji cuheja'mo. Ũcuachi'a vaoji chʉ'ʉni cuasato mamakʉ'te pa'ikoji cuheja'mo. ");
INSERT INTO coe_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Majapãi ũcuate'evʉ'e pa'inapi te'eʉ chʉ'ʉni cuasato chekʉnapi cuhejanaa'me repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Mʉja'kʉpãi cuasajʉ pa'ito re'omʉ. Jã'ata'ni mʉsanʉkonapi chʉ'ʉni na'a rʉa cuasajʉ pa'imaneni chʉ'ʉ neena pa'imanejanaa'me. Ũcuachi'a mʉsanʉkona chĩiva'nare cuasajʉ pa'ito re'omʉ. Jã'ata'ni mʉsanʉkonapi chʉ'ʉni na'a rʉa cuasajʉ pa'imaneni chʉ'ʉ neena pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pãi mʉsanʉkonare chʉ'ʉ neenajejʉna cuhejʉ vanisõñu chiijanaa'me. Jã'ata'ni chʉ'ʉre cuasache jmamakarʉjẽ'e ũhasõma'ñe cuasajʉ pa'ijʉ̃'ʉ. Pãipi jã'aja'ñe cho'oñu chiijʉna vajʉchʉjʉ mʉsanʉkonapi chʉ'ʉre cuasache'te ũhasõni chʉ'ʉ neena pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ũcuachi'a chuenisõñe'te vajʉchʉjʉ repana asa chẽasi'e Dios chʉ'o ũhasõna, jũnisõsirʉmʉ vati toana sani cho'osõjanaa'me. Jã'ata'ni chuenisõñejẽ'e vajʉchʉma'ñe chʉ'ʉni ũcua cuasajʉ chuenisõsiva'na Dios pa'ichejare jũni sani re'oja'che pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare jo'e i'kasi'kʉa'mʉ. —Pãi mʉsanʉkonare pojona chʉ'ʉre ũcuachi'a pojome. Pãi chʉ'ʉre pojona chʉ'ʉre Raosi'kʉre ũcuachi'a pojome. ");
INSERT INTO coe_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pãipi Dios chʉ'o kʉajʉna, pãiʉ ũcuaʉakʉji, “Diopi raoʉna Repaʉ chʉ'o kʉame ina”, chini repanani pojoto Repaʉ chʉ'o kʉasinare ro'icheja'chere ũcuapa'rʉva ro'ija'mʉ Dios repaʉ'te. Ũcuachi'a pãiʉ chekʉnani, “Diopi cho'okaiʉna re'oja'che pa'ime ina”, chini repanani pojoto Dios ũcuaja'che re'oja'che pa'isinare ro'icheja'chere ũcuapa'rʉva ro'ija'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ũcuachi'a pãiʉ ũcuaʉakʉji chʉ'ʉ neekʉre rʉa vesʉkʉ'teta'ni ũcua, “Jesucristo neekʉa'mʉ ikʉ”, chini repaʉni oko ũkuato Diopi ro'ija'mʉ repaʉ'te —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare docerepanare chʉ'va pi'ni, ũcuachejapi sani ku'iʉ repacheja pa'ijoopoãre Dios chʉ'ore chʉ'vakʉ pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Ũcuarʉmʉ Juan Pãi Okoro'vesiva'ʉ cu'ache cho'onare chẽa cuaovʉ'ere pa'iʉ Jesús cho'oche'te asa, “Dios Raosi'kʉ Cristocosomʉ repaʉ”, chini cuasaasomʉ. Jã'aja'ñe cuasa repaʉ neenare te'enare soni rao, “Jesure ija'che chiijʉ sẽniasajaijʉ̃'ʉ mʉsanʉkona: ‘¿Dios Raosi'kʉa'ʉ mʉ'ʉ? Mʉ'ʉpi Dios raomanesi'kʉ pa'ito, ¿Dios Raojaʉni ũcua cha'ajanaa'ñe chʉkʉna?’, chiijʉ̃'ʉ repaʉ'te Jesure”, chini saoasomʉ Juan repanare. ");
INSERT INTO coe_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Saoʉna sani ũcuare sẽejʉna asa Jesús ija'che i'kasi'kʉa'mʉ: —Chura mʉsanʉkona Juan pa'ichejana co'i mʉsanʉkona ñasi'ena'me asasi'ere ija'che kʉajʉ̃'ʉ repaʉ'te: ");
INSERT INTO coe_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Pãi na'ana pa'isina ñame chura. Cu'acũ'a paasina re'oja'che nʉka ku'ime chura. Asi ravʉ paasina ũcuaja'che vajʉme. Cãjo asamanesina ũcuaja'che asame chura. Jũnisõsina ũcuaja'che vajʉrani jo'e pa'ime. Chʉova'na pa'iva'na chʉ'ʉ chʉ'vache'te chʉ'ʉre cuasache kʉachʉ'ore asajʉ pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pãi chʉ'ʉre cuasache ũhasõma'ñe cuasajʉ pa'ina pojojʉ pa'ijanaa'me”, chiijʉ sa kʉajʉ̃'ʉ repaʉ'te Juanre —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Repana co'isõsirʉmʉ Jesús Juan pa'iche'te i'kakʉ ija'che i'kasi'kʉa'mʉ repanare pãi: —¿Je'se pa'ikʉni ñañu chini pãi peocheja sate mʉsanʉkona? ¿Chʉ'chʉsava tutakʉna ñʉ'kuecheja'che repaʉ rekocho na'mi sa'ñekʉ cuasakʉni ñañu chini sate mʉsanʉkona? Jã'aja'ñe cuasama'kʉa'mʉ Juan. ");
INSERT INTO coe_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jã'aja'ñe pa'ikʉ'te ñañu chini saimaneni, ¿ʉ̃quere ñañu chini sate? ¿Pa'ipãi ju'ikãña ju'ikʉni ñañu chini sate mʉsanʉkona? Pãi, kãña rʉa ro'ikãña ju'ina pa'ipãi vʉ'ñachi'a pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jã'aja'ñe pa'ikʉni ñañu chini saimaneni, ¿ʉ̃quere ñañu chini sate mʉsanʉkona? ¿Dios chʉ'o kʉakaikʉni ñañu chini sate? Jã'aja'ñe pa'ikʉ'te ñañu chini saisinajejʉ te'erũhiñe cuasame mʉsanʉkona. Repaʉ Juan chekʉnare Dios chʉ'o kʉanare na'a rʉa masi kʉakʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Repaʉ Juan pa'ijachere kʉajʉna aperʉmʉ tocha jo'kasi'e Dios chʉ'o ija'che chiimʉ: Mʉ'ʉ cheja cajejache kʉajaʉni charo saoja'mʉ chʉ'ʉ, pãipi mʉ'ʉ cajejachere asa repana rekoñoãre care'va paapʉ chini, chiimʉ repana tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Icheja cheja Dios chʉ'o kʉakaina rʉa masina pa'ime. Jã'ata'ni Juan ũcuanʉkore na'a cajejaiche masiʉ'mʉ. Na'a pa'isirʉmʉ pa'ijana ũcuaja'che, rʉa vesʉsinata'ni Dios chʉ'ore asa chẽa cuasajʉ, Juanre na'a rʉa masijanaa'me, chʉ'ʉ pa'iche peore asasinajejʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan Pãi Okoro'vekʉ Dios chʉ'o apechʉ'varʉmʉpi iumucujñajatʉ'ka Dioni cuasajʉ Repaʉ chʉ̃'ʉñe cho'onare cuhejʉ cu'ache cho'ojʉ pa'ime pãi. ");
INSERT INTO coe_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moisés tocha jo'kasi'e Dios Raojaʉ pãi ũcuanʉkore chʉ̃'ʉjañere kʉamʉ. Dios chʉ'o kʉana ũcuachi'a, irʉmʉ Juan pa'irʉmʉjatʉ'ka ũcuate'ere kʉame. ");
INSERT INTO coe_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mʉsanʉkonapi iere chʉ'ʉ i'kache'te jachama'ñe cuasani masijanaa'me: “Juan, Dios raoja'mʉ chiicojñosi'kʉ aperʉmʉ Repaʉ chʉ'o kʉasi'kʉ Elías kʉasi'eja'che kʉamʉ”, chiimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chʉ'ʉ i'kache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Pãi irʉmʉ cana pa'iche'te kʉara. Chʉ'ʉpi ñato mʉsanʉkona irʉmʉ cana ija'che pa'ime: Jeerʉmʉ chĩi ãu ĩsichejare ñu'ijʉ ũcuajanani, “Apeñu”, chini soniasome. ");
INSERT INTO coe_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Chekʉnapi apecuhejʉna ija'che i'kaasome repana: “Chʉkʉna juhivʉã juhito ujacha'icuheme mʉsanʉkona. Ũcuachi'a chʉkʉna apejʉ jũ'isinare tãrʉmʉ ujacheja'che sʉma'ñe ujato ja'me ujacuheme mʉsanʉkona. Chʉkʉnani cuhejʉ pojoma'me mʉsanʉkona”, chiniasome repana chĩi. ");
INSERT INTO coe_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Repana chĩi ũcuajanare cuhecheja'che cuheme mʉsanʉkona chʉkʉna'te, Juanna'me chʉ'ʉre. Repaʉ Juan Pãi Okoro'vekʉ rani pa'iʉ Dioni cuasakʉ te'eñoã ãu ãima'ñe pa'iʉ, conojẽ'e ũkuma'ñe pa'iʉna ña, “Vatini paakʉ vẽ'veʉ'mʉ Juan”, chiijʉ cuhenaa'me mʉsanʉkona repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chura chʉ'ʉpi pãire ja'me paaʉ chini Dios Raosi'kʉpi rani pa'iʉ si'aumucujña ãu ãiʉ ũkukʉna ña, “Ãi aia'mʉ mʉ'ʉ. Cono ũku aia'mʉ mʉ'ʉ. Ũcuachi'a pãi cu'ache pa'inana'me pãi chʉ̃'ʉnare kuri kookainare oiʉ pa'ikʉ'mʉ mʉ'ʉ”, chiijʉ cuheme mʉsanʉkona chʉ'ʉre. Pãi rũhiñe cuasana, “Dios chʉ̃'ʉñe re'oja'chea'me. Peore masikʉ'mʉ Repaʉ”, chiijʉ cuasame —chiisi'kʉa'mʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Repaʉ Jesús Diochi'a cho'omasiche pãi jainʉko ñajʉ'te si'arʉmʉ cho'o ñokʉ pa'isi'kʉa'mʉ. Ũcuachi'a repana cu'ache cho'oche'te ũhasõa'jʉ chini chʉ'vasi'kʉa'mʉ repaʉ. Jã'ata'ni cu'ache cho'oche ũhasõmanesinaa'me repana. Ũcuarʉmʉ Jesús Diochi'a cho'omasiche repaʉ na'a rʉa cho'o ñojoopoã pa'inapi repana cu'ache cho'oche'te ũhamapʉna pe'rukʉ ija'che i'kasi'kʉa'mʉ repanare: ");
INSERT INTO coe_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Dios aperʉmʉ Sidón vʉ'ejoopona'me Tiro vʉ'ejoopo canare Repaʉ masiche cho'o ñomaneasomʉ. Repanani chʉ'vakʉ cho'o ñoru ña cu'ache pa'inajejʉ sʉmava'na pa'ijʉ cu'ache cho'oche ũhasõ, vãkiniokãñapi sa'che repana sĩjona ũhacʉtapi chu'chura'asinaa'me repana, chekʉnapi ña, “Cu'ache cho'oche ũhasõsinaa'me ina”, chiapʉ chini. Mʉsanʉkonata'ni chʉ'ʉpi chʉ'vakʉ Diochi'a cho'omasiche cho'o ñokʉna ñame, Corazín vʉ'ejoopo canana'me Betsaida vʉ'ejoopo cana. Ñanata'ni cu'ache cho'oche ũhasõma'me mʉsanʉkona. Jã'ajekʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dios pãi ũcuanʉkore chi'i ro'iumucuse tĩ'aru Sidón vʉ'ejoopo pa'isinana'me Tiro vʉ'ejoopo pa'isinare rʉa cu'ache ti'jñeja'mʉ. Jã'ata'ni mʉsanʉkonare Corazín vʉ'ejoopo canana'me Betsaida vʉ'ejoopo canare na'a rʉa cu'ache ti'jñeja'mʉ, Repaʉ cho'omasicheji chʉ'ʉ cho'oche ñasinata'ni jachasi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉsanʉkona Capernaum vʉ'ejoopo cana, “Dios pa'icheja saijanaa'me mai”, chiinaa'me. Jã'ata'ni Dios mʉsanʉkonare pãi ũcuanʉkore Repaʉ chi'i ro'iumucuse tĩ'aru vati toana saoja'mʉ. Dios aperʉmʉ Sodoma vʉ'ejoopo canare Repaʉ masiche cho'o ñomaneasomʉ. Repanani cho'o ñoru cu'ache cho'oche ũhasõ re'oja'che pa'ijʉna, ñañomaneʉna irʉmʉjatʉ'ka pa'ira'aasomʉ repajoopo. ");
INSERT INTO coe_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mʉsanʉkonare Capernaum vʉ'ejoopo canare ija'che i'kamʉ chʉ'ʉ: Na'a pa'isirʉmʉ Dios pãi ũcuanʉkore chi'i ro'iumucuse tĩ'aru Sodoma vʉ'ejoopo pa'isinare rʉa cu'ache ti'jñeja'mʉ. Jã'ata'ni mʉsanʉkonare na'a rʉa cu'ache ti'jñeja'mʉ, chʉ'ʉ cho'oche ñasinata'ni jachasi'e ro'i —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Reparʉmʉ Jesús, Pʉka'kʉni pojokʉ ija'che i'kasi'kʉa'mʉ: —Ja'kʉ, mʉ'ʉ cʉnaʉmʉ pa'inana'me cheja pa'inare peore chʉ̃'ʉkʉ'mʉ. Pãi, “Mʉ'ʉ chʉ'o peore masinaa'me chʉkʉna”, chiijʉ cuasanare chʉ'ʉ che'choche mʉ'ʉ chʉ'o asamasiche ʉ̃semʉ mʉ'ʉ, repanapi asavesʉa'jʉ chini. Jã'ata'ni pãi chĩiva'naja'ñe vesʉjʉ, “Dios chʉ'ojẽ'e vesʉnaa'me chʉkʉna”, chini cuasanarechi'a mʉ'ʉ chʉ'o asamasiche jo'kakʉ'mʉ mʉ'ʉ, repanapi asamasia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jã'aja'ñere chiimʉ mʉ'ʉ. Jã'ajekʉna mʉ'ʉre, “Re'orepamʉ”, chiimʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ Diore. ");
INSERT INTO coe_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chini pãire ija'che i'kasi'kʉa'mʉ repaʉ: —Chʉ'ʉ Ja'kʉ Repaʉ pa'iche masiche peore jo'kasi'kʉa'mʉ chʉ'ʉre. Chʉ'ʉ Repaʉ Mamakʉ pa'iche pãi te'eʉjẽ'e vesʉme. Chʉ'ʉ Ja'kʉta'ni masimʉ. Ũcuachi'a chʉ'ʉ Ja'kʉ pa'iche pãi te'eʉjẽ'e vesʉme. Chʉ'ʉ Repaʉ Mamakʉchi'a masimʉ Ja'kʉ pa'iche. Ũcuachi'a chʉ'ʉre kʉaʉanarechi'a chʉ'ʉ Ja'kʉ pa'iche kʉamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉsanʉkona aipãi chʉ̃'ʉ jo'kasi'ere, “Dios chʉ̃'ʉsi'ea'me ie”, chini peore cho'oñu chiime mʉsanʉkona te'ena. Jã'ata'ni repapi peore cho'ovesakʉna cho'ojʉ ca'nasõ rekoñoã sʉmava'na pa'ime mʉsanʉkona. Jã'aja'ñe pa'inare chʉ'ʉni raijʉ̃'ʉ chiimʉ chʉ'ʉ. Chʉ'ʉre rainare repana rekoñoãna cho'okaija'mʉ chʉ'ʉ, re'oja'che pa'ijʉ pojojʉ sʉmava'na pa'imanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chʉ'ʉ chʉ̃'ʉñe cho'ovesama'ñere asa chẽa cho'ojʉ pa'ijʉ̃'ʉ. Pãi oikʉta'ni meñe, “Masiʉ'mʉ”, chiima'kʉa'mʉ chʉ'ʉ. Mʉsanʉkonapi chʉ'ʉni rani, mʉsanʉkona cu'a chʉ'ʉpi tʉnosõkakʉna rekoñoãpi re'oja'che pa'ijʉ jo'e sʉmava'na pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chʉ'ʉ chʉ̃'ʉñeji cho'ovesamaʉna cho'ojʉ re'oja'che pa'ijʉ sʉmava'na pa'imanejanaa'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ũcuarʉmʉ Jesús pʉaumucusena chʉkʉna repaʉ neenana'me trigo chiopi saiʉ pa'isi'kʉa'mʉ. Ũcuarʉmʉ chʉkʉna repaʉ neena ãucuhakʉna trigocha'charʉãre pura ãisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chʉkʉnapi jã'aja'ñe cho'ojʉna ña fariseopãi ija'che i'kasinaa'me Jesure: —Ñajʉ̃'ʉ. Mʉ'ʉ neena pʉaumucuseta'ni cho'oche cho'ome —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Chitena Jesús i'kasi'kʉa'mʉ repanare. —¿Aperʉmʉ pa'isi'kʉ David cho'osi'ere kʉajʉ mai aipãi tocha jo'kasi'e ñamanaa'ñe mʉsanʉkona? Ija'che kʉamʉ repa: David, repaʉ'te ja'me pa'inana'me ãucuhakʉna Dios vʉ'ena kaka Diopi pojoa'kʉ chini judío phairipãi tʉosi'ere pã mini ãiʉ repaʉ'te ja'me pa'inare ãukʉ ãniasomʉ. Dios, phairipãichi'a ãijʉ̃'ʉ chiisi'ere ãnisõasomʉ repaʉ David, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ũcuaja'che cheke, ¿Diopi chʉ̃'ʉʉna Moisés tocha jo'kasi'e ñamanaa'ñe mʉsanʉkona? Ija'che kʉamʉ repa: Pʉaumucujñana Dios vʉ'e kaka repavʉ'e cho'omajñarʉã cho'onata'ni phairipãi Diopi ñato cu'ache cho'oma'me, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","David Dios vʉ'ena kaka cho'osi'ena'me phairipãi repavʉ'e kaka cho'oche, Dios peore chʉ̃'ʉkʉji ñato cu'ama'mʉ. Ũcuachi'a chʉ'ʉni peore ja'me chʉ̃'ʉa'kʉ chini jo'kacojñosi'kʉni pʉaumucusena cho'oche chʉ̃'ʉʉato chʉ̃'ʉre'omʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios chʉ'o aperʉmʉ tocha jo'kasi'e kʉache masi asavesʉme mʉsanʉkona. Ija'che chiimʉ repa: “Mʉsanʉkona cu'ache cho'oche'te ro'iñu chini chʉ'ʉre ĩsisiva'nare jo'cha va'iva'nare vani ʉosõjʉ̃'ʉ”, chiiʉ chʉ̃'ʉmʉ chʉ'ʉ. Jã'ata'ni, “Pãi chekʉnare ña oijʉ pa'ijʉ̃'ʉ”, chiiʉ na'a rʉa chʉ̃'ʉmʉ chʉ'ʉ mʉsanʉkonare, chiimʉ Dios. Repa tocha jo'kasi'e asa chẽa cho'ona pani chʉkʉna'te cu'ache cho'omanare, “Cu'ache cho'ome mʉsanʉkona”, chiimanera'asinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chʉ'ʉni Dios Raocojñosi'kʉni pʉaumucusena cho'oche'te chʉ̃'ʉto chʉ̃'ʉre'omʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jã'aja'ñe i'kacuha Jesús ũcuachejapi sani judíopãi chi'ivʉ'ena kakasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kaka ñato pãiʉ ũcuavʉ'ere cu'ajʉ̃tʉrʉ paakʉ pa'isi'kʉa'mʉ. Ũcuarʉmʉ repavʉ'e pa'ina Jesuni, “Cu'ache cho'omʉ mʉ'ʉ”, chiñu chini ija'che sẽesinaa'me repaʉ'te: —¿Pʉaumucusena pãi jũ'iva'nani vasoto re'okʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chitena Jesús i'kasi'kʉa'mʉ repanare. —Mʉsanʉkona te'eʉ mʉ'ʉ neeva'ʉpi ovejava'ʉpi pʉaumucusena cojena tuãni mañasõsiva'ʉni sani ñani miira'amʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ovejava'nare oikʉ'mʉ Dios. Jã'ata'ni pãire na'a rʉa oikʉ'mʉ Repaʉ. Jã'ajekʉna pãi jũ'iva'nani pʉaumucusena vasoto re'omʉ. Cu'ama'mʉ jã'a —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chini cu'ajʉ̃tʉrʉ paakʉ'te i'kasi'kʉa'mʉ. —Mʉ'ʉ jʉ̃tʉ saʉjʉ̃'ʉ —chiisi'kʉa'mʉ. Chikʉna saʉsi'kʉa'mʉ. Saʉʉna repajʉ̃tʉ teana re'ojajʉ̃tʉ care'osõsi'kʉa'mʉ, chekʉjʉ̃tʉ re'oja'icheja'che. ");
INSERT INTO coe_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jã'ata'ni fariseopãi Jesupi jã'aja'ñe cho'oʉna ña ũcuavʉ'epi eta mʉa, Jesure vanisõjañere care'vañu chini chi'i cutuasome. ");
INSERT INTO coe_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ũcuarʉmʉ Jesús repana cho'oñu chiiche'te masikʉ ũcuachejapi eta sanisõsi'kʉa'mʉ. Repaʉ sanisõsirʉmʉ pãi rʉa jainʉko tuhasinaa'me repaʉ'te. Tuharena repanare ja'me pa'inare jũ'iva'nare ũcuanʉkore vasokaisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jã'aja'ñe vasokʉ, “Chʉ'ʉ cho'oche chekʉnare pãi kʉamanejʉ̃'ʉ mʉsanʉkona”, chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesupi jã'aja'ñe cho'oʉna repaʉ cho'ojachere kʉakʉ aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías tocha jo'kasi'epi ũcuarepa ti'jñecuhasi'kʉa'mʉ, ija'che chiicheji: ");
INSERT INTO coe_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Dios Repaʉ Mamakʉni ija'che i'kaasomʉ: “Ikʉ chʉ'ʉre cho'oche cho'okaikʉ'mʉ. Chʉ'ʉ chẽa paakʉ'mʉ ikʉ. Rʉa cuasakʉ pojokʉ'mʉ chʉ'ʉ ikʉre. Chʉ'ʉ Rekocho'te ĩsiʉna ũcuaʉni ja'me pa'iʉ Reparekochoji chʉ̃'ʉkʉna sani judío peonani chʉ'ʉ pãi ũcuanʉkore ũcuarepa cho'okaiche'te kʉaja'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ũcuachi'a pe'ruchʉ'ojẽ'e i'kama'ñe cuima'ñe kʉaja'mʉ repaʉ. Vʉ'ñajoopoã kuni chʉ'o ʉjachʉ'ojẽ'e i'kama'kʉ ku'ija'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pãi re'oja'che pañu chiinata'ni re'oja'che pa'ivesʉjʉna cho'okaija'mʉ ikʉ. Chʉova'na pa'iva'nare ũcuaja'che oiʉ cho'okaija'mʉ ikʉ. Pãi ũcuanʉko cu'ache cho'oche peore repaʉ ai ʉ̃serʉmʉjatʉ'ka jã'aja'ñe pa'iva'nare cho'okaiʉ pa'ija'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ikʉpi jã'aja'ñe cho'okaiʉna judío peona ikʉre jachama'ñe cuasajanaa'me”, chiniasomʉ Dios, chiimʉ Isaías tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ũcuarʉmʉ pãi Jesús pa'ichejana na'ava'ʉre vatipi ʉ̃sekʉna chʉ'ojẽ'e cutumaʉ ñakocaãjẽ'e ñamava'ʉni rasinaa'me. Rarena Jesupi vatire eto saosõkakʉna ñakocaã ñasi'kʉa'mʉ repaʉ. Chʉ'o ũcuachi'a cutusi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jesupi jã'aja'ñe cho'oʉna ña jñano repana pãi ũcuanʉko sãiñechi'a sẽniasasinaa'me, ija'che chiijʉ: —¿Aperʉmʉ pa'isi'kʉ David Jojocojñosi'kʉa'ʉ ikʉ? ¿Maire chʉ̃'ʉa'kʉ chini Dios raoja'mʉ chiicojñosi'kʉa'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jã'aja'ñe i'kasi'eta'ni asa fariseopãi ija'che cu'ache i'kasinaa'me: —Vati chʉ̃'ʉkʉji Beelzebuji cho'okaiʉna vati ũcuajanare eto saomasimʉ ikʉ Jesús —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ũcuarʉmʉ Jesús repana cuasajʉ cutuche'te masikʉ ija'che i'kasi'kʉa'mʉ: —Pãi ũcuate'echeja pa'inapi sãiñechi'a cavani vaijʉ si'asõjanaa'me. Ũcuachi'a majapãichi'api ũcuate'evʉ'e pa'inapi sãiñechi'a cavani majapãi sẽjosõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ũcuachi'a vati aipi repaʉ neenana'me sãiñechi'a cavato repaʉ chʉ̃'ʉñe si'asõmʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jã'ata'ni mʉsanʉkona chʉ'ʉre, “Vati chʉ̃'ʉkʉji Beelzebuji vati ũcuajanare eto saomasiche jo'kasi'kʉa'mʉ mʉ'ʉre”, chiime. Mʉsanʉkonapi jã'aja'ñe i'karena iere sẽemʉ chʉ'ʉ: Mʉsanʉkona neenare, ¿kaʉpi vati etomasiche jo'kaʉ? ¿Vati aipi jo'kaʉ? Ija'che chiijʉ sẽniasajʉ̃'ʉ repanare: “¿Vati etomasiche vati aipi jo'kaʉ mʉsanʉkonare?”, chiijʉ̃'ʉ. Jã'aja'ñe sẽeto repana mʉsanʉkonare, “Rũhiñe cuasama'me mʉsanʉkona”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Chʉ'ʉ vati etomasiche Dios Rekocho jo'kasi'ea'me. Chʉ'ʉpi Dios Rekocho jo'kasi'ere cho'okʉna ña, “Dios ũcuanʉkore chʉ̃'ʉkʉ'mʉ”, chiijʉ cuasajanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Pãiʉ rʉa kokaʉji rʉa vaiche paakʉji repaʉ vʉ'ere pẽ'jeto ñaacu'amʉ repaʉ cu'amajñarʉã. Charo repaʉni chẽa quẽo sʉotota'ni repaʉ neemajñarʉã tʉtesõre'omʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Pãi chʉ'ʉre jovomana cuheme chʉ'ʉre. Cuhejʉ chekʉnapi chʉ'ʉni jovoñu chiito ʉ̃seme repana, chʉ'ʉni jovomanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jã'ajekʉna iere kʉamʉ chʉ'ʉ mʉsanʉkonare: Dios, Repaʉ'te pãi cu'ache cho'osi'ena'me cu'ache cutuche si'ache tʉ'nesõja'mʉ. Tʉ'nesi'e jo'e cuasamaneja'mʉ Repaʉ. Repaʉ Rekocho'te cu'ache cutusi'eta'ni cavesʉma'ñe cuasakʉ ro'iche chʉ̃'ʉja'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chʉ'ʉre, Dios Raocojñosi'kʉre pãi cu'ache cutuche jo'e cuasamaneja'mʉ Dios. Jã'ata'ni Repaʉ Rekocho'te pãi cu'ache cutucheta'ni irʉmʉpi mamacheja pa'itojẽ'e ũcua cavesʉma'ñe cuasaja'mʉ Repaʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ũcuarʉmʉ Jesús repanare jo'e ija'che i'kasi'kʉa'mʉ: —Sũkiñʉã ãiñe kʉ̃iñʉã koka pa'iñʉã sãijapʉã kʉ̃imʉ. Koka peora'ñʉrʉãta'ni sãija'ima'ñe kʉ̃imʉ. Sũkiñʉã repañʉã kʉ̃isi'ere ãni ña masime pãi repañʉ pa'iche. ");
INSERT INTO coe_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Aña pa'icheja'che cu'ache pa'ime mʉsanʉkona! Rekoñoã cu'ache cuasanajejʉ re'oja'che i'kama'me mʉsanʉkona. Pãi ũcuanʉko repana rekoñoã cuasache'te cutunaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pãi repana rekoñoã re'oja'che cuasana re'oja'chere cutume. Repana rekoñoã cu'ache cuasana ũcuachi'a cu'ache'te cutume. ");
INSERT INTO coe_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʉsanʉkonare ija'che i'kamʉ chʉ'ʉ: Dios pãi ũcuanʉkore chi'i ro'iumucuse pãi repana peoche cutujʉ pa'isi'e ro'i peore ro'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Re'oja'che i'kasinareta'ni reparʉmʉ, “Cu'ache cho'osi'e ro'iche peomʉ inare”, chiija'mʉ Repaʉ. Cu'ache i'kasinareta'ni repana cu'ache i'kasi'e ro'ia'jʉ chini chʉ̃'ʉja'mʉ Repaʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ũcuarʉmʉ fariseopãi te'ena judíopãi che'chonana'me Jesure ija'che i'kasinaa'me: —Masiʉ, mʉ'ʉpi Diochi'a cho'omasiche'te cho'okʉna ñañu chiime chʉkʉna —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chitena Jesús i'kasi'kʉa'mʉ. —Pãi irʉmʉ cana cu'ache pa'inaa'me. Chʉ'ʉre, “Dios raosi'kʉma'mʉ Jesús”, chiime repana. Jã'ata'ni chʉ'ʉre, “Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te”, chiime repana, chʉ'ʉ pa'iche'te masiñu chini. Jã'ata'ni cho'o ñoma'mʉ chʉ'ʉ repanare. Dios chʉ'o aperʉmʉ kʉasi'kʉ Jonás cho'ocojñosi'eja'chechi'a cho'ocojñoja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Repaʉ Jonás, va'i rʉa ʉjaʉ cʉtaro sa'navʉ choteumucujña ñami choteñami pa'isi'eja'che, chʉ'ʉ Dios Raocojñosi'kʉ ũcuaja'che cheja sa'navʉ tãcojñosi'kʉ choteumucujña ñami choteñami pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aperʉmʉ Jonapi rʉa masiʉji Dios chʉ'ore chʉ'vakʉna asa chẽa, Níneve vʉ'ejoopo pa'isina repana cu'ache cho'oche ũhasõasome. Repaʉ'te Jonare na'a rʉa masiʉji ichejare pa'imʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ chʉ'vache asacuheme mʉsanʉkona irʉmʉ cana. Jã'ajekʉna Dios pãi ũcuanʉkore chi'i ro'irʉmʉ tĩ'aru Níneve vʉ'ejoopo pa'isinapi ija'che i'kajanaa'me mʉsanʉkonare irʉmʉ pa'inare: “Cu'ache cho'oche ũhasõmanesinajejʉ ro'ijʉ pa'ijanaa'me mʉsanʉkona”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aperʉmʉ pa'io sʉripʉ cakã'ko canare pãi chʉ̃'ʉsi'ko rʉa so'opi Salomón rʉa masiʉ chʉ'vache'te asara chini raniasomo. Repaʉ'te Salomon'te na'a rʉa masiʉji ichejare pa'imʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ chʉ'vache asacuheme mʉsanʉkona irʉmʉ cana. Na'a pa'isirʉmʉ Dios pãi ũcuanʉkore chi'i ro'irʉmʉ tĩ'aru aperʉmʉ pa'io pãi chʉ̃'ʉsi'ko ija'che i'kaja'mo mʉsanʉkonare chura pa'inare chʉ'ʉre cuasamanesinare: “Cu'are cho'ojʉ Diore cuasamanesinajejʉ ro'ijʉ pa'ijanaa'me mʉsanʉkona”, chiija'mo —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Ũcuarʉmʉ Jesús repanare pãi jo'e ija'che i'kasi'kʉa'mʉ: —Pãiʉ sa'navʉ pa'isi'kʉni etosõru vati sani oko peochejñare ku'iʉ pa'imʉ pʉachejñare ku'ekʉ. Jã'ata'ni jñaamaneni, “Chʉ'ʉ vʉ'ejachejana co'ira pãiʉ sa'navʉna”, chini cuasamʉ repaʉ. Jã'aja'ñe cuasa repaʉ co'i ñato pãiʉ sa'navʉ vʉ'e jʉ'o care'vasivʉ'eja'che re'oja'imʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jã'ajekʉna jo'e sani chekʉnare vati repaʉ'te na'a rʉa cu'anani sieterepanare ku'e jñaa ra pãiʉ sa'navʉna pañu chini ũcuanʉko kakame repana. Jã'ajekʉna pãiʉ aperʉmʉ cu'ache pa'isi'e na'a rʉa cu'ache pa'imʉ. Irʉmʉ canare pãi cu'ache pa'inare ũcuaja'che rʉa cu'ache ti'jñeja'mʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Repanare pãi Jesús chuta'a cututona pʉka'ko, repaʉ cho'jechĩina'me ũcuaʉ pa'ivʉ'ena rani kakañu chiniasome repaʉni cutuñu chini. Kakañu chiisinareta'ni kakacu'akʉna ve'sere paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Repanani kakacu'akʉna chekʉpi kʉakaisi'kʉa'mʉ repaʉ'te Jesure, ija'che chiiʉ: —Mʉja'ko, mʉche'ʉchĩina'me mʉ'ʉni cutuñu chini ve'sere nʉkajʉ cha'ame —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chikʉna Jesús repaʉ'te kʉasi'kʉre ija'che i'kasi'kʉa'mʉ: —¿Kaoa'o chʉ'ʉ ja'ko? ¿Keejanaa'ñe chʉ'ʉ cho'jechĩi? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chini chʉkʉna'te repaʉ neenani ñakʉ ñʉ'okʉ i'kasi'kʉa'mʉ repaʉ. —Inaa'me chʉ'ʉ ja'koromijana. Ũcuachi'a inaa'me chʉ'ʉ cho'jechĩijana. ");
INSERT INTO coe_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cʉnaʉmʉ Pa'ikʉ chʉ'ʉ Ja'kʉ chʉ̃'ʉñe asa jachama'ñe cho'ona chʉ'ʉ cho'jechĩijanaa'me. Ũcuaja'che chʉ'ʉ ja'koromijanaa'me repana —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ũcuaumucusepi Jesús repaʉ pa'isivʉ'e eta sani chiara rʉ'tʉvana pʉʉsi'kʉa'mʉ pãire chʉ'vara chini. ");
INSERT INTO coe_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ũcuarʉmʉ repaʉ pãipi jairepanʉko rani chi'irena choovʉna caje pʉʉsi'kʉa'mʉ. Pãita'ni chiara rʉ'tʉva'te pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ũcuarʉmʉ Jesús choovʉ'te ñu'iʉ repanani rʉa chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Pãiʉ trigo'te chu'chura chini chiona saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sani tĩ'a pachu ku'iʉ chu'chukʉna trigocaã te'era'karʉã ma'ana tuã'tuaasomʉ. Ma'ana tuã'tuaʉna pĩ'ava'napi rani ãkuesõasome repara'karʉã. ");
INSERT INTO coe_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chekʉra'karʉãta'ni cata pa'ichejana cha'o jmamakarʉ pa'ichejana tuã'tuaasomʉ. Cha'o sẽ'serʉchi'a pa'ichejata'ni na'mi aineeasomʉ repara'karʉã. ");
INSERT INTO coe_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na'mi aineesi'eta'ni ʉ̃sʉʉji rʉarepa asukʉna uu phã'pha jũnisõasomʉ repasañarʉã, chitapi peokʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chekʉra'karʉã miu pa'ichejana tuã'tua miuna'me aineeʉna miupi ju'je vẽasõasomʉ repara'ñʉrʉã. ");
INSERT INTO coe_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Chekʉra'karʉãta'ni re'oja'che cha'o pa'ichejñana tuã'tuasira'karʉãjekʉ re'oja'che ainee ju'a ñaniasomʉ. Te'era'karʉ aineesi'ñʉ te'echa'chava treintarepara'karʉã pa'icha'cha ju'a ñaniasomʉ. Chekʉra'karʉã aineesiñʉã sesentarepara'karʉã pa'icha'cha ju'a ñaniasomʉ. Chekʉra'ñʉrʉã cienrepara'karʉã pa'icha'cha ju'a ñaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chʉ'ʉ chʉ'vache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ũcuarʉmʉ chʉkʉna Jesús neena repaʉji cuasakʉ kʉaʉna asa repaʉ'te kueñe tĩ'a, —¿Je'se pa'iʉna mʉ'ʉ pãire chʉ'vani mʉ'ʉ cuasachechi'a kʉakʉ chʉ'vakʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chitena Jesús ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkonare chʉ'ʉ neenajejʉna Diopi ʉ̃semaʉna Repaʉchi'a masiche te'erũhiñe kʉamʉ chʉ'ʉ, asamasia'jʉ chini. Jã'ata'ni chekʉnare chʉ'ʉre cuasacuhenare Repaʉchi'a masiche chʉ'ʉ cuasacheji kʉamʉ chʉ'ʉ, asanata'ni masi asamanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Dios chʉ'o asa jachamana si'arʉmʉ na'a rʉa re'oja'che pa'ijanaa'me. Repaʉ chʉ'ore na'a rʉa masia'jʉ chini cho'okaija'mʉ Dios repanare. Jã'ata'ni chekʉna chʉ'ʉ chʉ'vache asanata'ni masi cuasamapʉ chʉ'ʉpi cho'okʉna repana jmamakarʉ masiche cavesʉjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jã'ajekʉna pãire chʉ'vakʉ repana asavesʉcheji cuasakʉ kʉamʉ chʉ'ʉ, masi asamanea'jʉ chini. Ñanata'ni ñamanesina pa'icheja'che pa'ime repana. Ũcuachi'a asanata'ni asama'ñena pa'ime repana. ");
INSERT INTO coe_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Repana pa'ijachere kʉakʉ aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías tocha jo'kasi'e ũcuarepa ti'jñecuhamʉ. Ija'che chiimʉ repa: Asajʉ pa'inata'ni asavesʉjanaa'me mʉsanʉkona. Ñanata'ni ñamanesina pa'icheja'che pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ina pãi rʉa cu'ache pa'inaa'me. Ũcuachi'a cãjo asamanaja'ñe pa'ijʉ chʉ'ʉ chʉ'o asacuheme ina. Ũcuachi'a ñakocaã chamisinaja'ñe pa'ijʉ chʉ'ʉpi chʉ̃'ʉʉna tocha jo'kasi'e ñacuheme ina. Chʉ'ʉ chʉ'ore asa chẽa repana cu'ache cho'oche'te ũhasõru repana rekoñoã re'ojarekoñoã care'vakaija'mʉ chʉ'ʉ, repanapi re'oja'che paapʉ chini, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mʉsanʉkonata'ni chʉ'ʉ cho'okʉ pa'iche ñajʉ chʉ'ʉ chʉ'vachejẽ'e asamasijʉ, “Dios cho'oche'me jã'a”, chiijʉ masijʉ pojojʉ pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aperʉmʉ pa'isina Dios chʉ'o kʉasinana'me chekʉna pãi re'ona irʉmʉ mʉsanʉkona ñañeja'ñere ñañu chiisinata'ni ñamaneasome. Ũcuachi'a irʉmʉ mʉsanʉkona asacheja'chere asañu chiisinata'ni asamaneasome repana. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e i'kasi'kʉa'mʉ. —Chʉ'ʉ cuasakʉ kʉasi'ere trigo chu'chusi'ere jo'e ũcuare masi kʉaja'mʉ chʉ'ʉ mʉsanʉkonapi asamasia'jʉ chini. Ija'chea'me jã'a: ");
INSERT INTO coe_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trigora'karʉã te'era'karʉã ma'ana tuã'isira'karʉã chejapi rʉarepa jʉjakʉna sa'navʉ kakama'mʉ. Pãi te'enare repana rekoñoã chejapi rʉarepa jʉjakʉ trigocaã chu'chusicaã sa'navʉ kakama'ñeja'ñe Dios chʉ'o kakama'mʉ, jachajʉna. Asanareta'ni vatipi ʉ̃semʉ repanare, Dioni cuasamanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ũcuachi'a cata pa'ichejña tuã'tuasicaã na'mi aineesi'eta'ni chita saimaʉ na'mi jũnisõmʉ. Pãi ũcuachi'a te'ena Dios chʉ'o asa teana pojojʉ cuasame. Jã'ata'ni repanapi Dioni cuasajʉna pãipi cu'ache i'kajʉna chekʉrʉmʉ repanani cu'ache ti'jñekʉna masi cuasamanajejʉ Dios chʉ'o repana cuasache ũhasõme. ");
INSERT INTO coe_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ũcuachi'a miu pa'ichejña tuã'tuasira'karʉã miuna'me aineemʉ. Jã'ajekʉna miu sũkipi ju'jekʉna kʉ̃ima'ñe jũnisõmʉ repara'ñʉrʉã. Pãi ũcuachi'a te'ena Dios chʉ'o asa chẽa Repaʉ chʉ̃'ʉñe cho'onata'ni na'mi ũhasõme. Repana cho'oche'te kurina'me põsere rʉarepa cuasajʉ Dios chʉ'o repana asa chẽa cuasache ũhasõme. ");
INSERT INTO coe_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ũcuachi'a cheja re'ojachejñana tuã'tuasicaã ainee re'oja'che kʉ̃iñeja'ñe re'oja'che pa'ime pãi, Dios chʉ'o asa chẽa Repaʉ chʉ̃'ʉ jo'kasi'e cho'ojʉ pa'ina. Repana Diore cuasana te'ena trigoñʉã treintarepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe re'oja'che pa'ime repana rekoñoã. Chekʉna sesentarepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe na'a rʉa re'oja'che pa'ime. Chekʉna cienrepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe jo'e na'a rʉa re'oja'che pa'ime Repaʉ chʉ̃'ʉñe cho'ona —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ũcuarʉmʉ Jesús chʉkʉnani jo'e chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ona pa'iche ija'chea'me: Pãiʉ repaʉ chiona trigo re'oja'chere tãasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jã'ata'ni repaʉna'me repaʉ paana kãnisõsirʉmʉna repaʉ'te cuhekʉ ũcuachiona sani cu'ara'ñʉrʉã aineea'kʉ chini cu'ara'karʉãre tã jo'ka sanisõasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na'a pa'isirʉmʉ trigora'ñʉrʉã ainee pi'ni ju'a ñaniasomʉ. Cu'ara'ñʉrʉã ũcuaja'che ũcuapa'rʉva aineeasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ũcuarʉmʉ repaʉ'te cho'oche cho'okaina chio ñajani co'i repachio paakʉni kʉaasome, ija'che i'kajʉ: “Mʉ'ʉ chio trigora'karʉã re'ojara'karʉãchi'a tãsi'kʉa'mʉ. Jã'ata'ni, ¿je'se pa'iʉna repachio cu'ara'ñʉrʉã ja'me aineeʉ?”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chitena asa chio paakʉ i'kaasomʉ. “Chʉ'ʉre cuhekʉ cho'osi'ecosomʉ jã'a”, chiniasomʉ. Chikʉna repaʉ'te cho'oche cho'okaina jo'e ija'che i'kaasome: “¿Repara'ñʉrʉã cu'ara'ñʉrʉã ru'tesõkaijaijʉ̃'ʉ chiikʉ mʉ'ʉ chʉkʉna'te?”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chitena i'kaasomʉ repaʉ. “Pãamʉ. Jã'aja'ñe cho'omanejʉ̃'ʉ. Cu'ara'ñʉrʉã ru'teni chekʉrʉmʉ mʉsanʉkona trigora'ñʉrʉã ja'me ru'tesõme. ");
INSERT INTO coe_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ija'che cho'oto na'a re'omʉ: Repara'ñʉrʉã cu'ara'ñʉrʉã chura ru'tesõjaimanejʉ̃'ʉ, trigona'me ũcuapa'rʉva aineea'kʉ repa tʉarʉmʉjatʉ'ka. Repa trigo tʉache tĩ'asirʉmʉ, ‘Ija'che cho'ojʉ̃'ʉ’, chiiʉ chʉ̃'ʉ saoja'mʉ chʉ'ʉ repa tʉakaijanare: ‘Chio sani cu'ara'ñʉrʉãre charo ru'te rũhijuu quẽ'ke ʉosõjʉ̃'ʉ. Jã'aja'ñe cho'ocuha trigo tʉa pi'ni chʉ'ʉ ãumajñarʉã care'vavʉ'ena sa ũhakaijʉ̃'ʉ’, chiija'mʉ chʉ'ʉ”, chiniasomʉ —Jã'aja'ñe kʉasi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ũcuarʉmʉ Jesús pãire jo'e chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ona, ¿je'se pa'iche? Ija'che pa'ime: Pãiʉ repaʉ chiona mostazara'karʉ te'era'karʉ sa tãasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Repa mostazara'karʉã chekʉra'karʉã na'a jmara'karʉãa'me. Jã'ata'ni pãipi tãru chekʉra'ñʉrʉã tãsira'ñʉrʉã na'a ʉjañʉã aineemʉ repara'karʉã. Ʉjañʉãpi ka rʉa pa'iñʉã aineeʉna pĩ'ava'na ũcuañʉã kana chĩi sʉo suhame —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ũcuarʉmʉ Jesús pãire ũcua chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ona pa'iche ija'chea'me: Romio pãre cho'ora chini pã kosasica'rerʉ'te charo cha'pi harinaro'ro chotero'ro ũcuaca'rerʉna ja'measomo. Jã'ata'ni rʉa ʉjaca'repʉ saʉsõasomʉ repaca'repʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Reparʉmʉ Jesús pãire chʉ'vakʉ ũcuaʉji cuasakʉ kʉachechi'api chʉ'vasi'kʉa'mʉ. Cheke i'kamanesi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jã'aja'ñe cho'okʉna repaʉ cho'ojachere kʉakʉ aperʉmʉ Dios chʉ'o kʉasi'kʉ tocha jo'kasi'epi ũcuarepa ti'jñecuhamʉ, ija'che chiicheji: Chʉ'ʉ cuasakʉ kʉachechi'api pãi chʉ'vaja'mʉ chʉ'ʉ. Cheja cho'orʉmʉpi irʉmʉjatʉ'ka Diopi kʉamaʉna pãijẽ'e asama'ñere churana kʉaja'mʉ chʉ'ʉ, chiimʉ repa. ");
INSERT INTO coe_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ũcuarʉmʉ Jesús repanare pãi saosõ repaʉ aperʉmʉ pa'isivʉ'ena sani kakasi'kʉa'mʉ. Kakaʉna chʉkʉna repaʉ neena repaʉ'te kueñe tĩ'a ija'che i'kasinaa'me: —Mʉ'ʉ chʉkʉna'te cuasakʉ kʉasi'ere cu'ara'ñʉrʉãna'me trigora'ñʉrʉã ũcuate'echio aineesi'e pa'iche'te te'erũhiñe kʉajʉ̃'ʉ chʉkʉna'te —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chitena Jesús ija'che i'kasi'kʉa'mʉ: —Ija'chea'me jã'a: Chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ re'ojara'karʉã tãsi'kʉja'che pa'imʉ. Repaʉ pãiʉ trigora'karʉã re'ojara'karʉã tãasomʉ. Chʉ'ʉ ũcuaja'che Dios chʉ'o re'oja'chere chʉ'vamʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pãi icheja cheja pa'ina chioja'che pa'ime Dios chʉ'o chʉ'vacojñonajejʉ. Ũcuaja'che pãi Dios chʉ'o chʉ'vajʉna asa chẽa Repaʉ chʉ̃'ʉñe cho'ona Ũcuaʉ neenajejʉ re'oja'che pa'ijʉ re'ojara'karʉãja'ñe pa'ime. Jã'ata'ni Repaʉ chʉ'o asacuhena vati neenajejʉ cu'ara'karʉãja'ñe cu'ache pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Repaʉ vati pãipi cu'ache cho'oa'jʉ chini chʉ̃'ʉkʉjekʉ chio paakʉ'te cuhekʉja'che pa'ikʉ'mʉ. Ũcuachi'a Dios pãi ũcuanʉkore chi'i ro'irʉmʉ trigo tʉarʉmʉja'ñe cho'ocojñoja'mʉ. Reparʉmʉ ángelepi pãi ũcuanʉkore trigo tʉa chi'icheja'che chi'ijanaa'me. Ũcuaja'che trigo tʉacuha ãu care'vavʉ'ena sa jo'kacheja'che Dios Repaʉ'te cuasanare Repaʉ pa'ichejana saja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ũcuachi'a cu'ara'ñʉrʉã ru'te chi'i rũhijuu quẽ'ke ʉosõñeja'ñe Dios Repaʉ'te cuasamanare vati toana saoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Reparʉmʉ chʉ'ʉpi Dios Raosi'kʉpi chʉ̃'ʉʉna ángeles sani chʉ'ʉ neena pa'ichejña ja'me pa'ijʉ chekʉnani cacʉ'oñu chini cu'ache chʉ'vanana'me chekʉnare cu'ache cho'onare ũcuanʉkore ra chi'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Repanare peore chi'i vati toana saojanaa'me repana. Ũcuatoare uujʉ oijʉ cõjire asoche ãijʉ pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jã'ata'ni Dios chʉ̃'ʉñe cho'ojʉ re'oja'che pa'ina repana Ja'kʉ Dios pa'ichejare sani pa'ijʉ ʉ̃sʉʉ miañeja'ñe rʉa ko'sijana pa'ijanaa'me. Chʉ'ʉ chʉ'vache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ũcuarʉmʉ Jesús chʉkʉna'te chʉ'vakʉ jo'e ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ojʉ pañu chiina pa'iche ija'chea'me: Pãiʉ repaʉ kuri rʉare chavekʉ coje ũni ũcuacojena kuri mañaasomʉ. Jã'aja'ñe cho'osichejare chekʉ pãiʉ rupʉ ku'iʉ repacoje jñaa ũni, repa kuri jñaaasomʉ. Jñaasi'kʉta'ni repa kuri miima'ñe repacoje jo'e ta'pisõasomʉ repaʉ. Ta'pi jo'ka kuri jñaasi'kʉjekʉ pojokʉ co'i repaʉ nee cu'amajñarʉã peore ĩsisõ kuri koo repacoje pa'ichejare cheja kooasomʉ repaʉ, “Repare kurire ũni paara”, chini cuasakʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ũcuarʉmʉ Jesús chʉkʉnani chʉ'vakʉ jo'e ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ojʉ pañu chiina pa'iche ija'chea'me: Pãiʉ perlara'karʉã rʉa ro'ira'karʉãre koo paara chini si'achejña ku'ekʉ ku'iʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ku'ekʉ chekʉpi perlara'karʉ rʉa ro'ira'karʉ'te paakʉna ña pojokʉ koora chiniasomʉ. Jã'ata'ni repara'karʉji rʉarepa ro'ikʉ kuripi tĩ'amaʉna sani repaʉ nee cu'amajñarʉã peore ĩsisõ kuri rʉa koo jo'e sani kooasomʉ repara'karʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ũcuarʉmʉ Jesús chʉkʉnani ũcua chʉ'vakʉ jo'e ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉñe cho'ojʉ pañu chiina pa'iche ija'chea'me: Va'i chona repana va'i chorʉ va'ire chojʉ mar chiarana su'a rʉorena va'i si'ache kakaasome reparʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ũcuarʉmʉ repava'napi jairepanʉko kaka timusõrena mejavʉna reparʉ rueni maasome. Rueni ma ũha pʉʉ ñu'ijʉ repava'nare va'iva'nare re'ojava'narechi'a jʉ'ñana jña'nujʉ mañaasome. Cu'ava'iva'nareta'ni sẽjosõasome repana. ");
INSERT INTO coe_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Dios pãi ũcuanʉkore chi'i ro'irʉmʉ tĩ'aru jã'aja'ñe cho'ocojñoja'mʉ. Reparʉmʉ ángeles rani cu'ava'iva'nare jña'nu sẽjosi'eja'che pãi cu'ache pa'inapi re'oja'che pa'inani ja'me pa'isinare jña'nu vati toana saojanaa'me. Ũcuatoare pa'ijʉ uujʉ oijʉ cõjire asoche ãijʉ pa'ijanaa'me repana —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ũcuarʉmʉ Jesús chʉkʉna'te ija'che sẽesi'kʉa'mʉ: —¿Chʉ'ʉ cuasakʉ kʉasi'e peore asamasiche mʉsanʉkona? —chiisi'kʉa'mʉ. Chikʉna, —Jʉ̃jʉ, Chʉkʉna'te Paakʉ, peore asamasime chʉkʉna —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chitena Jesús i'kasi'kʉa'mʉ. —Pãiʉ vʉ'e paakʉ repaʉ paamajñarʉã peore masimʉ mamana'me ai. Judíopãi che'chona ũcuaʉana chʉ'ʉ che'choche asa chẽa cho'ona ũcuaja'che ka'chamajña masime, aperʉmʉ chʉ̃'ʉ jo'kasi'ena'me chʉ'ʉ irʉmʉ che'chokʉ chʉ̃'ʉñe —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jã'aja'ñe cuasakʉ kʉacuha ũcuachejapi eta repaʉ pa'irepajoopona sani pa'iʉ Jesús repajoopo pa'ivʉ'ena judíopãi chi'ivʉ'ena kaka che'chosi'kʉa'mʉ. Che'chokʉna pãi asa jñano ija'che i'kasinaa'me: —¿Je'se cho'okʉ ikʉ repaʉ che'chomasiche che'cheʉ? Ũcuaja'che, ¿je'se cho'okʉ ikʉ Diochi'a cho'omasiche cho'oche che'cheʉ? ");
INSERT INTO coe_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ijoopo pa'ikʉ chooko'ña si'ache cho'omasikʉ mamakʉ'mʉ ikʉ Jesús. Repaʉ pʉka'ko Maríaa'mo. Repaʉ cho'jechĩia'me jã'ana, Santiagona'me Josena'me Simonna'me Judas. ");
INSERT INTO coe_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Repaʉ cho'jeromi ũcuaja'che ijoopo'te maina'me pa'ime. ¿Je'se cho'o ikʉ jã'arepa rʉa masikʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jã'aja'ñe cuasanajejʉ repaʉ i'kache jachasinaa'me repana. Ũcuarʉmʉ Jesús repanare i'kasi'kʉa'mʉ. —Dios chʉ'o kʉakaikʉ aineesijoopo canana'me repaʉ majapãi asa jachame repaʉ kʉache. Mʉsanʉkona ũcuaja'che ijoopo chʉ'ʉ aineesijoopo cana chʉ'ʉ kʉache asa jachame —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Repanapi repaʉni cuasamapʉna Diochi'a cho'omasiche rʉarepa cho'o ñomanesi'kʉa'mʉ Jesús repajoopo pa'irʉmʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ũcuarʉmʉna Herodes Galilea cheja pa'inare chʉ̃'ʉkʉ Jesús cho'oche asaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jã'aja'ñe asa repaʉ'te cho'oche cho'okainare soni rao Jesús pa'iche'te vesʉkʉ ija'che i'kaasomʉ repaʉ: “Juan Pãi Okoro'vesi'kʉ chʉ'ʉpi chʉ̃'ʉʉna chuenisõsi'kʉpi jũni vajʉrani pa'icosomʉ jã'ʉ. Jã'aja'ñejekʉna Diochi'a cho'omasiche cho'omasicosomʉ repaʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Aperʉmʉ repaʉ Herodes repaʉ cho'jeʉ Felipe rʉ̃joni Herodíani tʉa paakʉna Juan asa, “Dios ʉ̃seche'te cu'ache cho'omʉ mʉ'ʉ”, chiiʉ chʉ'vaasomʉ repaʉ'te. Jã'aja'ñe chʉ'vakʉna Herodes asa pe'rukʉ repaʉ'te Juanre chẽa cʉnameji quẽo cu'ache cho'onare chẽa cuaovʉ'ena sa cuaoa'jʉ chini chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Juanre vanisõñe chʉ̃'ʉra chiniasomʉ repaʉ. Jã'ata'ni pãipi ũcuanʉko, “Juan Dios chʉ'o kʉakaikʉ'mʉ”, chiijʉ cuasajʉna chʉ̃'ʉvajʉchʉasomʉ repaʉ, “Pãipi pe'rujʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ũcuarʉmʉ Herodes repaʉ'te jñaasiumucusejarʉmʉjekʉna fiesta cho'ora chini pãi jainʉkore soni rao chi'iasomʉ. Fiesta'te cho'ojʉna Herodías mamako pãi jainʉko ñajʉ'te eta te'eo ujacha'iasomo. Jã'aja'ñe cho'okona ña Herodes rʉa pojoasomʉ repao'te. ");
INSERT INTO coe_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pojokʉ repao'te, —Mʉ'ʉre ʉache sẽejʉ̃'ʉ chʉ'ʉre. Mʉ'ʉ sẽeñe ũcuaʉache ĩsija'mʉ chʉ'ʉ mʉ'ʉre. Dios ñakʉ'te chʉ'o ũcuarepare i'kamʉ chʉ'ʉ, —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chikʉna eta pʉka'koni ija'che sẽniasomo repao: —¿Ʉ̃quere repaʉ'te sẽeja'ñe chʉ'ʉ? —chiniasomo. Chikona pʉka'kopi chʉ'vaona asa Herodes pa'iruupʉna jo'e kaka ija'chere sẽniasomo repao:— Juan Pãi Okoro'vekʉ sĩjopʉ'te tʉso cʉnare'avana maña ra ĩsijʉ̃'ʉ chʉ'ʉre —chiniasomo repao Herodías mamako. ");
INSERT INTO coe_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Repao sẽeñe'te asaʉna Herode'te rʉa sʉmaneasomʉ. Jã'ata'ni repaʉ soicojñosina asajʉ'te, “Ũcuarepare i'kamʉ chʉ'ʉ”, chiisi'kʉjekʉ ũcuare ra ĩsia'jʉ chini chʉ̃'ʉasomʉ repaʉ, pãipi, “Joreʉ'mʉ ikʉ”, chiimanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jã'ajekʉna, —Cu'ache cho'onare chẽa cuaovʉ'ena sani Juan sĩjopʉ tʉsojʉ̃'ʉ —chiiʉ chʉ̃'ʉasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chikʉna sani Juan sĩjopʉ tʉsocuha cʉnare'avana maña ra romichĩioni ĩsiasome repana. Ĩsirena koo pʉka'koni jo'e sa ĩsiasomo repao. ");
INSERT INTO coe_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jã'a cho'o pi'nisirʉmʉ repaʉ Juan neena pa'isina repaʉ'te vanisõsi'ere asa pãi cu'ache cho'onare chẽa cuaovʉ'ena sani repava'ʉre sa tãasome. Tã pi'ni sani Jesuni kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan chuenisõsi'e asasirʉmʉ Jesús ũcuachejapi chʉkʉna repaʉ neenana'me choovʉ tuni pãi peochejana chiara chekʉkã'kona jẽ'esi'kʉa'mʉ. Jã'ata'ni pãi repaʉ saisichejare asa vʉ'ñajoopoã pa'isina eta repara chekʉkã'kona po'opi tuhasinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chiara chekʉkã'ko jẽni tĩ'a mani Jesús, repaʉ'te tuhasinare pãi ñasi'kʉa'mʉ. Ũcuanani ña oiʉ repana sasiva'nare jũ'iva'nare vasokaisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ũcuarʉmʉ chʉkʉna repaʉ neena na'isõcuhakʉna repaʉ'te sani ija'che i'kasinaa'me: —Icheja vʉ'ñajoopoãjẽ'e peomʉ. Inare pãi saojʉ̃'ʉ vʉ'ñajoopoãna sani ãure koo ãapʉ. Na'isõcuhamʉ ie —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chitena Jesús i'kasi'kʉa'mʉ. —Saiche chiima'mʉ inare. Mʉsanʉkonapi ãu ãujʉ̃'ʉ inare —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chikʉna chʉkʉna i'kasinaa'me. —Pãpʉã, cincorepapʉã, va'i te'eka'chapanarechi'a paame chʉkʉna —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chitena Jesús i'kasi'kʉa'mʉ. —Mʉsanʉkona paache pãna'me va'iva'nare ichejana chʉ'ʉni rajʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ũcuarʉmʉ Jesús repanare pãi tachavʉna pʉʉa'jʉ chini chʉ̃'ʉsi'kʉa'mʉ. Pʉʉ ñu'ijʉna pã, cincorepapʉã va'iva'na te'eka'chapava'nare mini cãjikʉ cʉnaʉmʉre ñakʉ Dioni, “Re'orepamʉ Ja'kʉ”, chini chʉkʉnani repaʉ neenani tʉ'se ĩsisi'kʉa'mʉ. Ĩsiʉna pãire ĩsisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pãi ũcuanʉko chajiche ãisinaa'me repa. Jã'ata'ni repana ãijʉna cajejaisi'e ãu docerepajʉ'ña sia maña timusinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Repa ãu ãisina pãi romijẽ'e chĩijẽ'e kuẽkuema'ñe chekʉrʉmʉ cinco milrepana pa'icosome ʉmʉpãichi'a. ");
INSERT INTO coe_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jã'aja'ñe cho'ocuha Jesús chʉkʉna'te repaʉ neenare, ija'che i'kasi'kʉa'mʉ: “Chʉ'ʉ inare pãi saochetʉ'ka mʉsanʉkona choovʉ tuni chiara chekʉkã'kona charo jẽ'ejʉ pa'ijʉ̃'ʉ”, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Repanare sao pi'nisirʉmʉ Jesús aikũtina mʉnisõasomʉ, te'eʉ Dioni sẽsa chini. Mʉni pa'iʉ na'isõʉna ñami te'eʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jã'a cho'oto chʉkʉna chuta'a chiara joorepapo'te jẽ'ejʉ pa'isinaa'me. Chʉkʉna saichejapi rache tutakʉna rʉa fa'asi'kʉa'mʉ chiara. ");
INSERT INTO coe_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ũcuarʉmʉ Jesús ñatacuhatona chiara sẽ'sevʉji nʉka ku'iʉ tuhasi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jã'aja'ñe raiʉna ña kʉkʉsõ, vajʉchʉjʉ ija'che i'kajʉ rʉa cuisinaa'me chʉkʉna: —¡Jũ'isi'kʉpi reko raimʉ ikʉ! —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jã'aja'ñe i'kajʉna Jesús ija'che i'kasi'kʉa'mʉ: —Jʉjarekoñoã paajʉ̃'ʉ. Jesua'mʉ chʉ'ʉ. Vajʉchʉmanejʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chikʉna Pedro i'kasi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, mʉ'ʉpi ũcuaʉ pani chʉ̃'ʉjʉ̃'ʉ, chʉ'ʉ ũcuaja'che mʉ'ʉ nʉkachejana oko sẽ'sevʉji nʉka ku'iʉ saaʉ chini —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chikʉna Jesús, —Raijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ'te. Ũcuarʉmʉ Pedro choovʉji caje oko sẽ'sevʉji nʉka ku'iʉ ũcuaʉ nʉkachejana saisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jã'ata'ni rʉarepa tutakʉna ña kʉkʉsõ runisõpi'rakʉ ija'che chiiʉ cuisi'kʉa'mʉ repaʉ: —Chʉkʉna'te Paakʉ chʉ'ʉ ru'iche ʉ̃sekaijʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chikʉna Jesús teana repaʉ jʉ̃tʉna chẽa ija'che i'kasi'kʉa'mʉ repaʉ'te: —Chʉ'ʉre cuasamʉ mʉ'ʉ. Jã'ata'ni masi cuasama'mʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Repaʉ Jesús Pedrona'me choovʉna tutena tutasi'e cuhasõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ũcuarʉmʉ chʉkʉna repaʉ neena ũcuaʉji choovʉna tukʉna repaʉni pojojʉ ija'che i'kasinaa'me: —Dios Mamarepakʉ'mʉ mʉ'ʉ. Ũcuarepaa'me jã'a —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ũcuarʉmʉ chʉkʉna Jesuna'me chiaraji jẽni Genesaret chejana tĩ'asinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tĩ'a maito repacheja pa'ina pãi Jesure ña masisinaa'me. Ũcuachi'a repaʉ raisi'ere chekʉnapi kʉajʉna repacheja pa'ijoorʉã peore cana ũcuanʉko asaasome. Asa ravʉ jũ'iva'nare Jesús pa'ichejana rasinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Repava'nare jũ'iva'nare ra ija'che chiijʉ sẽesinaa'me repana: “Iva'na jũ'iva'na mʉ'ʉ ju'ikãa pʉso juhasirʉ'tʉ chẽseche jo'kajʉ̃'ʉ, chẽse vajʉa'jʉ”, chiisinaa'me. Ũcuarʉmʉ repana jũ'iva'na repaʉ ju'ikãa chẽsesina ũcuanʉko vajʉsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ũcuarʉmʉ fariseopãina'me judíopãi che'chona Jerusalén vʉ'ejoopo raisina Jesús pa'ichejana rani ija'che chʉ'o sẽesinaa'me repaʉ'te: ");
INSERT INTO coe_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Je'se pa'iʉna mʉ'ʉ neena mai aipãi chʉ̃'ʉ jo'kasi'e cho'oma'ñe? Repa chʉ̃'ʉ jo'kasi'e cho'oche ãu ãipi'rani jʉ̃jña masi choamanaa'me —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chitena Jesús repanare ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkona ũcuachi'a Dios chʉ̃'ʉ jo'kasi'ere jachajʉ rupʉ mʉsanʉkona cuasajʉ chʉ̃'ʉñechi'a cho'ojʉ pa'inaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios aperʉmʉ ija'che chiiʉ chʉ̃'ʉ jo'kasi'kʉa'mʉ: Mʉja'kʉpãi ña, kʉkʉjʉ pa'ijʉ̃'ʉ mʉsanʉkona. Ũcuachi'a, Mʉja'kʉpãi cu'ache i'kamanejʉ̃'ʉ. Jã'aja'ñe i'kanare vanisõñe pa'imʉ, cu'ache i'kasi'e ro'i, chiiʉ chʉ̃'ʉ jo'kasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Mʉsanʉkonata'ni chekʉnare ija'che chʉ̃'ʉnaa'me: “Mai ja'kʉpãire ija'che i'kato re'omʉ: ‘Ja'kʉpãi, mʉsanʉkonare kuirama'ñe chʉ'ʉ paache peore Dioni ĩsija'mʉ chʉ'ʉ. Jã'ajekʉna mʉsanʉkonare kuiracu'amʉ chʉ'ʉre’, chiito re'omʉ. Jã'aja'ñe i'kanare pʉka'kʉpãi kuirache peomʉ”, chiinaa'me mʉsanʉkona. Dios chʉ̃'ʉ jo'kasi'e jachanajejʉ pãipi rupʉ mʉsanʉkona cuasajʉ chʉ̃'ʉñechi'a cho'ojʉ paapʉ chini jã'aja'ñe i'kanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dios chʉ̃'ʉñe cho'ona cho'ocheja'che sẽ'sevʉchi'a cho'ojʉ pa'inaa'me mʉsanʉkona. Jã'ata'ni Repaʉ chʉ̃'ʉñe cuheme. Aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías mʉsanʉkona pa'ijachere masi kʉakʉ tocha jo'kasi'e ija'che i'kamʉ: ");
INSERT INTO coe_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jã'ana Israel jojosina, “Mʉ'ʉni cuasajʉ vajʉchʉnaa'me chʉkʉna”, chiime chʉ'ʉre. Jã'ata'ni repana rekoñoã chʉ'ʉre cuasamanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ũcuachi'a chʉ'ʉre cuasajʉ pojojʉ cho'ocheja'che sẽ'sevʉchi'a peoche cho'onaa'me repana. Rupʉ repana cuasajʉ chʉ̃'ʉñechi'a che'chonajejʉ chʉ'ʉni cuasamapʉ joreme jã'ana, chiimʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jã'aja'ñe i'kacuha Jesús, pãi soni rao ija'che i'kasi'kʉa'mʉ: —Chʉ'ʉ i'kache asa chẽa masijʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pãi ãu ãiñeji repana rekoñoã cu'ache cho'oma'me. Ija'chea'me: Repanapi cu'ache cuasani rekoñoã cu'ache cho'ome pãi —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ũcuarʉmʉ chʉkʉna repaʉ neena na'a kueñe sani sẽesinaa'me repaʉ'te. —¿Mʉ'ʉ i'kasi'ere asa fariseopãi pe'ruche vesʉkʉ mʉ'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chitena Jesús i'kasi'kʉa'mʉ. —Pãi repana chiño tãmanesiñʉã cu'ara'ñʉrʉã cuhejʉ ru'te sẽjosõme. Dios Cʉnaʉmʉ Pa'ikʉ ũcuaja'che Repaʉ chʉ'o masi che'chomana che'chocheji si'asõa'kʉ chini cuhekʉ chʉ̃'ʉja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Repana fariseopãi pe'ruche cuasamanejʉ̃'ʉ mʉsanʉkona. Diore masi cuasamanajejʉ repana rekoñoã na'ava'naja'ñe pa'inapi chekʉnani che'chojʉ, na'ava'napi ũcuaja'che na'ava'nani juha sacheja'che cho'ome repana. Na'ava'ʉpi chekʉni ũcuaja'che na'ava'ʉni juha sani ũcuanʉko cojena tuã'ijanaa'me repana ñamava'najejʉ. Fariseopãi ũcuaja'che repana che'chosinana'me Diopi chʉ̃'ʉʉna na'ava'na ti'jñecojñoñeja'ñe rʉa cu'ache ti'jñecojñojanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jã'aja'ñe i'kaʉna asa Pedro repaʉ'te i'kasi'kʉa'mʉ. —Mʉ'ʉ i'kasi'ere na'a masi kʉajʉ̃'ʉ chʉkʉna'te —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chikʉna Jesús ija'che i'kasi'kʉa'mʉ: —¿Mʉsanʉkona ũcuaja'che chʉ'ʉ i'kasi'e asavesʉche? ");
INSERT INTO coe_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ija'chea'me: Pãiʉ ãu ũcuaʉache'te ãni mevo cʉtapʉna jmamakarʉ paa sẽjosõmʉ. Rekocho kakamaʉ repaʉ rekochota'ni meno cho'oma'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jã'ata'ni pãi cu'ache cutuna repana rekoñoã cuasache'te i'kame. Jã'ajekʉna repana rekoñoã cu'ache pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pãi te'ena repana rekoñoã cu'ache cuasajʉ chekʉnare vanisõme. Chekʉna repana pa'imanare ja'me kãime. Chekʉna romineejʉ chekʉna ʉmʉneejʉ cu'ache cho'ome. Chekʉna põse ñaame. Chekʉna joreme. Chekʉna cu'ache cutume chekʉnare. Pãi cu'ache cuasana rʉa si'ache cu'ache cho'ome. ");
INSERT INTO coe_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jã'aja'ñe cuasajʉ cho'ona Diopi ñato repana rekoñoã rʉa meno paame. Jã'ata'ni pãi ũcuaʉanapi rupʉ mai aipãi chʉ̃'ʉ jo'kasi'ere jʉ̃jña masi choache'te cho'omaneni Diopi ñato repana rekoñoã meno peome —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ũcuarʉmʉ Jesús Genesaret chejapi eta Tiro vʉ'ejoopona'me Sidón vʉ'ejoopo pa'ichejana saisi'kʉa'mʉ, chʉkʉna repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sakʉna repacheja cako cananeapãio judío peokoji rani cuiko i'kasi'koa'mo repaʉ'te. —Pãi Ũcuanʉkore Paakʉ, aperʉmʉ pa'isi'kʉ David Jojocojñosi'kʉ, Dios Raosi'kʉjekʉ, oijʉ̃'ʉ chʉ'ʉva'ore. Chʉ'ʉ chĩiva'o vatini paako rʉarepa jũ'imo —chiisi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jã'aja'ñe chiiko'teta'ni Jesús i'kamanesi'kʉa'mʉ. Ũcuarʉmʉ chʉkʉna repaʉ neena repaoji jã'aja'ñe i'kaona asa repaʉ'te kueñe tĩ'a rʉa i'kasinaa'me. —Jã'ore saosõjʉ̃'ʉ. Maini tuhako rʉarepa cuiko i'kamo jã'o —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chitena Jesús i'kasi'kʉa'mʉ. —Dios chʉ'ʉre, Israel jojosina Repaʉ chʉ'ore vesʉjʉ ovejava'na kuirakʉ'te peova'naja'ñe pa'ijʉ chʉova'na pa'inani judíopãichi'a Repaʉ chʉ'ore kʉakʉ cho'okaaʉ chini raosi'kʉa'mʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jã'aja'ñe i'kakʉ'teta'ni Jesure ti'jñeñe ro're pʉʉ ñu'io i'kasi'koa'mo repao. —Pãi Ũcuanʉkore Paakʉ, chʉ'ʉva'ore cho'okaijʉ̃'ʉ —chiisi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chikona Jesús i'kasi'kʉa'mʉ repao'te. —Pãipi chĩiva'na ãiñe'te ãure tʉa jamuchaire ãuto cu'amʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chikʉna repao i'kasi'koa'mo. —Ũcuarepaa'me jã'a. Jã'ata'ni jamuchai, mesako'a vʉ'evʉ'te pa'ijʉ pãi ãu ãijʉ pu'che to'jñomajñarʉãre ãime —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chikona Jesús repao'te i'kasi'kʉa'mʉ. —Diore masi cuasamo mʉ'ʉ. Mʉ'ʉ chiiche cho'okaija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. Repaʉ jã'aja'ñe i'karʉmʉpi repao mamako teana vajʉasomo. ");
INSERT INTO coe_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ũcuarʉmʉ Jesús ũcuachejapi eta sani Galilea chiara rʉ'tʉvana tĩ'asi'kʉa'mʉ. Jã'achejapi aikũtina mʉni pʉʉsi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pʉʉ ñu'iʉna pãi jainʉko repaʉ ñu'ichejana rani chi'isinaa'me. Chekʉnare cu'acũ'a paava'nare, na'ava'nare, nʉka ku'imava'nare, chʉ'o cutumava'nare, chekʉnare ravʉ jũ'iva'nare ra chi'i repava'nare ũcuaʉ ti'jñeñena jo'karena Jesús vasokaisi'kʉa'mʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ũcuarʉmʉ repana pãi chʉ'o cutumanesinapi cutujʉna, nʉka ku'imanesinapi nʉka ku'ijʉna, cu'acũ'are paajʉ ro'osiva'napi re'oja'che ku'ijʉna, na'ava'na pa'isinapi ñajʉna, ña jñano, “Maire Israelpãi Paakʉ Dios cho'osi'ea'me ie”, chiijʉ Diore pojosinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare soni rao i'kasi'kʉa'mʉ. —Inare pãi repana rasi'ere ãu ãni si'asõ ãiñejẽ'e peova'napi chʉ'ʉna'me choteumucujña pa'ijʉna oimʉ chʉ'ʉ. Ãu ãimava'nare repana vʉ'ñana saoche cuhemʉ chʉ'ʉ, saijʉ ãucuhana phã'pha ai jũ'ijʉ chini —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chikʉna chʉkʉna repaʉ neena i'kasinaa'me repaʉ'te. —Icheja pãi peochejajekʉ ãu ãiñejẽ'e peomʉ. ¿Je'se chʉkʉna jã'arepanʉkore ãu jñaa ãujanaa'ñe? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chitena Jesús i'kasi'kʉa'mʉ. —¿Jetopʉpʉã pã paache mʉsanʉkona? —chiisi'kʉa'mʉ. Chikʉna chʉkʉna repaʉ neena, —Pã sieterepapʉãna'me va'iva'nare te'eva'narechi'a paame chʉkʉna —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ũcuarʉmʉ Jesús repanare pãi, chejana pʉʉa'jʉ chini chʉ̃'ʉsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pʉʉrena pãpʉã sieterepapʉãna'me va'iva'nare mini cãjikʉ Dioni, “Re'orepamʉ”, chini chʉkʉnani repaʉ neenani tʉ'se ĩsiʉna pãire ãusinaa'me chʉkʉna. Jmanʉkorʉ pa'isi'e ãu Ũcuaʉji Dioni sẽkʉna teana rʉa carũhisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pãi ũcuanʉko chajichechi'a ãisinaa'me repa. Jã'ata'ni repana ãijʉna cajejaisi'e sieterepajʉ'ña sia maña timusinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Repa ãu ãisina pãi romijẽ'e chĩijẽ'e kuẽkuema'ñe chekʉrʉmʉ cuatro milrepana pa'icosome. ");
INSERT INTO coe_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jã'a cho'o pi'nisirʉmʉ Jesús repanare pãi saosõ choovʉji tuni Magadán chejana jẽ'esi'kʉa'mʉ chʉkʉnana'me. ");
INSERT INTO coe_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ũcuarʉmʉ fariseopãina'me saduceopãi Jesuni ñañu chini raisinaa'me. Rani repaʉ'te, “Dios Raosi'kʉma'mʉ ikʉ”, chiijʉ cuasanajejʉ ũcuaʉni cu'ache cho'oñu chini, —Diochi'a te'eʉ cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jã'aja'ñe i'karena Jesús i'kasi'kʉa'mʉ repanare. —Icheja cana na'ito ija'che cuasajʉ i'kanaa'me mʉsanʉkona: “Ina'ito cʉnaʉmʉ maajaʉmʉ pa'iʉna che'ro re'o ñataja'mʉ”, chiinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Apeñataroã ũcuachi'a ija'che cuasajʉ i'kanaa'me mʉsanʉkona: “Cʉnaʉmʉ maajaʉmʉ pa'iʉ oko pikopi rʉa pa'iʉ iumucuse oko raja'mʉ”, chiinaa'me. Cʉnaʉmʉ ñani umucuse pa'ijache cuasa i'kamasinata'ni irʉmʉ chʉ'ʉre ñanata'ni chʉ'ʉ pa'iche vesʉme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mʉsanʉkona cu'ache pa'ijʉ chʉ'ʉre masi cuasamanapi, rupʉ ñañu chini, “Diochi'a te'eʉ cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te; mʉ'ʉ pa'iche'te masiñu chʉkʉna”, chiime chʉ'ʉre. Jã'ata'ni cho'o ñomaneja'mʉ chʉ'ʉ mʉsanʉkonare. Chʉ'ʉpi Dios chʉ'o kʉasi'kʉ Jonás cho'ocojñosi'eja'chechi'a cho'ocojñokʉna ñajanaa'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ repanare. Chini repanare jo'ka sanisõsi'kʉa'mʉ repaʉ, chʉkʉna repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chʉkʉna Jesús neena chiara chekʉkã'ko jẽ'erʉmʉ, pã cavesʉ jẽnisõsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ũcuarʉmʉ Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Ñarepajʉ̃'ʉ. Fariseopãina'me saduceopãi pã saʉcheja'chere ña chẽamanejʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chikʉna chʉkʉna ija'che cuasajʉ sãiñechi'a i'kasinaa'me: —Maipi pãre ramanerena jã'aja'ñe i'kacosomʉ ikʉ —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chʉkʉna cuasajʉ sãiñechi'a cutuche'te masikʉ Jesús ija'che i'kasi'kʉa'mʉ: —¿Je'se pa'iʉna mʉsanʉkona pã peoche'te cuasajʉ cutuche? Chʉ'ʉre chuta'a masi cuasama'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chʉ'ʉ i'kache chuta'a asa chẽama'ñe mʉsanʉkona? ¿Chʉ'ʉ aperʉmʉ pã cincorepapʉãpi ʉmʉpãi cinco milrepanare ãusi'e cuasama'ñe mʉsanʉkona? Repana ãijʉna cajejaisi'e, ¿jetopʉjʉ'ña maña timure mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ũcuachi'a pã sieterepapʉãpi ʉmʉpãi cuatro milrepanare chʉ'ʉ ãusi'e cuasama'ñe mʉsanʉkona? Repana ãijʉna cajejaisi'e, ¿jetopʉjʉ'ña maña timure mʉsanʉkona? ¿Peore jã'a chʉ'ʉ cho'osi'e cavesʉsõre mʉsanʉkona? Chʉ'ʉ peore cho'omasikʉ mʉsanʉkonare jã'aja'ñe kuiramasikʉjekʉna, “Mai ãijañe pã peome mai”, chiimanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Chʉ'ʉ i'kache masi asavesʉme mʉsanʉkona. Pãre i'kama'mʉ chʉ'ʉ. Repana fariseopãina'me saduceopãi pã saʉcheja'chere che'chemanejʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ũcuarʉmʉ chʉkʉna Jesús neena repaʉ i'kache'te asamasi ija'che cuasasinaa'me: “Ãa, ikʉ Jesús pã cho'orepache'te i'kama'mʉ. Rupʉ maipi repana fariseopãina'me saduceopãi che'choche'te asa chẽamanea'jʉ chini i'kamʉ ikʉ”, chiisinaa'me chʉkʉna sãiñechi'a. ");
INSERT INTO coe_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ũcuarʉmʉ Jesús Cesarea de Filipo vʉ'ejoopo pa'ichejana sani tĩ'a chʉkʉna'te repaʉ neenare ija'che sẽesi'kʉa'mʉ: —Pãi chʉ'ʉre, pãire ja'me paaʉ chini Dios Raosi'kʉ pa'iche cutuni, ¿je'se i'kache? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chikʉna chʉkʉna i'kasinaa'me. —Pãi te'ena mʉ'ʉ pa'iche'te cutuni, “Juan Pãi Okoro'vekʉ'mʉ jã'ʉ”, chiime. Chekʉna, “Aperʉmʉ pa'isi'kʉa'mʉ jã'ʉ; Elíaa'mʉ”, chiime. Jo'e chekʉna, “Jeremíaa'mʉ jã'ʉ. Jã'apãani chekʉa'mʉ jã'ʉ; aperʉmʉ Dios chʉ'o kʉasi'kʉa'mʉ”, chiime mʉ'ʉre —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chitena, —Mʉsanʉkonajẽ'e chʉ'ʉ pa'iche'te cutuni, ¿je'se i'kache? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chikʉna Simón Pedro i'kasi'kʉa'mʉ. —Dios, Si'arʉmʉ Pa'ikʉ Mamakʉ'mʉ mʉ'ʉ. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Ũcuaʉ Raosi'kʉa'mʉ mʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chikʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Mʉ'ʉre Simonre, Jonás mamakʉ'te pãiʉ te'eʉjẽ'e kʉamanesinaa'me jã'a, mʉ'ʉ cuasakʉ i'kasi'e. Chʉ'ʉ Ja'kʉ Cʉnaʉmʉ Pa'ikʉji mʉ'ʉ rekochona kʉa jñauʉna masikʉ i'kasi'kʉa'mʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chʉ'ʉ mʉ'ʉre, “Pedro'mʉ”, chiimʉ. “Pedro” chini “Catapʉ” chiimʉ. Mʉ'ʉ i'kasi'e ũcuarepajekʉ catapʉ jʉjacheja'che si'ama'ñe pa'ija'mʉ. Mʉ'ʉ chʉ'ʉre i'kakʉ masi cuasacheja'che cuasajʉ chʉ'ʉ chʉ̃'ʉñe asa jachama'ñe cho'onare si'arʉmʉ na'a rʉa jainʉkore chẽakʉ pa'ija'mʉ chʉ'ʉ, repanapi jũnisõsirʉmʉ jũ'isina pa'ichejare ai pa'ima'ñe Dios pa'ichejare ai sani paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chʉ'ʉ mʉ'ʉre, Dios chʉ'ore chʉ'vaa'kʉ chini jo'kamʉ. Mʉ'ʉpi chʉ'vakʉna pãipi asa chẽa Repaʉ'te cuasajʉ jovonare repana cu'ache cho'oche Dios Cʉnaʉmʉ Pa'ikʉ tʉnosõkaija'mʉ, repanapi Ũcuaʉ pa'ichejare sani paapʉ chini. Mʉ'ʉ chʉ'vache'te asa jachajʉ Repaʉ'te cuasacuhenareta'ni Dios Cʉnaʉmʉ Pa'ikʉ repana cu'ache cho'oche tʉnosõkaimaneja'mʉ. Jã'ajekʉna Repaʉ pa'icheja saimanejanaa'me repana —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare, repaʉ pa'iche'te chʉkʉnapi kʉamanea'jʉ chini ija'che chʉ̃'ʉsi'kʉa'mʉ: —Chʉ'ʉ pa'iche pãi chekʉnare te'eʉ'terejẽ'e, “Dios Raosi'kʉa'mʉ ikʉ”, chiijʉ kʉamanejʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jã'arʉmʉpi pi'ra Jesús chʉkʉna'te repaʉ neenare repaʉ Jerusalén sani cu'ache cho'ocojñojañere kʉasi'kʉa'mʉ. —Chʉ'ʉ repacheja saisirʉmʉ judío ainana'me judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonapi chʉ̃'ʉjʉna rʉa cu'ache cho'ojanaa'me chʉ'ʉre. Jã'aja'ñe cu'ache cho'ojʉ vanisõjanaa'me repana chʉ'ʉre. Jã'ata'ni chuenisõ tãcojñosi'kʉta'ni choteumucujña pa'itona jo'e vajʉraija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jesupi jã'aja'ñe i'kaʉna asa Pedro oiʉ repaʉ'te te'eʉ'te juha sa ija'che i'kasi'kʉa'mʉ: —¡Diopi ʉ̃sekaiʉna jã'aja'ñe cho'oche ti'jñemanea'kʉ mʉ'ʉre! ¡Mʉ'ʉni jã'aja'ñe ti'jñeto cu'amʉ! —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jã'ata'ni Jesús chʉri ña Pedro'te ija'che i'kasi'kʉa'mʉ: —Vati ai cuasacheja'che cuasakʉjekʉ chʉ'ʉre ja'me pa'ima'ñe saijʉ̃'ʉ mʉ'ʉ. Dios chʉ'ʉre jo'kasi'ere chʉ'ʉpi cho'oma'to cu'amʉ. Chekʉrʉmʉ mʉ'ʉpi ʉ̃sekʉ i'kaʉna chʉ'ʉpi cho'omaneni cu'ache cho'omʉ. Pãi, Dios cuasacheja'che cuasamanaa'me. Mʉ'ʉ ũcuaja'che Dios cuasacheja'che cuasama'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chini Jesús chʉkʉna'te repaʉ neenare i'kasi'kʉa'mʉ. —Mʉsanʉkonapi chʉ'ʉ neena pañu chini mʉsanʉkonare cho'oʉache'te jo'kasõ chʉ'ʉ chʉ̃'ʉñechi'a cho'ojʉ pa'ijʉ̃'ʉ. Chʉ'ʉre cuasanare chʉ'ʉre cho'ocheja'che vanisõñu chiijanaa'me pãi. Pãipi mʉsanʉkonani jã'aja'ñe cho'oñu chiiche'te asanijẽ'e chʉ'ʉre cuasache jo'kasõmanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mʉsanʉkonapi chuenisõñe'te vajʉchʉjʉ mʉsanʉkona asa chẽasi'ere jo'kasõni jũnisõsirʉmʉ vati toana sani uujʉ pa'ijanaa'me. Jã'ata'ni chuenisõñejẽ'e vajʉchʉma'ñe chʉ'ʉni ũcua cuasajʉ chuenisõna, Dios pa'ichejare ai sani re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pãi cu'amajñarʉã si'ache paanapi chʉ'ʉre cuasamaneni, repana jũnisõ vati toa saisirʉmʉ ũcuana paacheji ro'i eta Dios pa'ichejana saicu'amʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na'a pa'isirʉmʉ chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ chʉ'ʉ Ja'kʉja'iʉ ko'sija'iʉ chʉ'ʉ neena ángelena'me jo'e cajeja'mʉ. Reparʉmʉ, pãi ũcuanʉko re'oja'che cho'osi'ena'me cu'ache cho'osi'e ro'i ro'ija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mʉsanʉkona icheja chʉ'ʉre ja'me pa'ina te'ena chuta'a jũnisõma'ñe pa'ijʉ chʉ'ʉ Dios Raosi'kʉ pãire chʉ̃'ʉra chini raiche ñajanaa'me. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seirepaumucujña pa'isirʉmʉna Jesús, aikũtina mʉiʉ Pedro'te, Santiagona'me Juanre, Santiago cho'jeʉ'te chẽa chekʉnare jo'ka te'enare aikũtina rʉa ʉmʉ pa'ikũtina mʉasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mʉni pa'iʉ Jesús repana ñajʉ'te tĩiʉja'iʉ carũniasomʉ. Repaʉ chia ʉ̃sʉʉ miañeja'ñe ko'sijaniasomʉ. Repaʉ ju'ikãña rʉa poko'sijakãña carũniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ũcuarʉmʉ Jesús neena, aperʉmʉ pa'isinare Moisena'me Elía'te ũcuaʉna'me nʉkajʉ chʉ'o cutunani ñaasome. ");
INSERT INTO coe_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jã'aja'ñe pa'ijʉna ña Pedro ija'che i'kaasomʉ Jesure: —Chʉ'ʉre Paakʉ, maipi ichejare pa'ijʉna rʉa re'omʉ. Mʉ'ʉpi chiito vʉ'ñarʉã chotevʉ'ñarʉã cho'okaija'mʉ chʉ'ʉ, mʉ'ʉ vʉ'erʉna'me Moisés vʉ'erʉna'me Elías vʉ'erʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Repaʉ Pedro chuta'a jã'aja'ñe i'katona repana nʉkachejana piko rʉa poko'sija'chepi caje ta'pisõ piko sa'navʉji chʉ'o i'kache asoasomʉ repanare, ija'che chiicheji: “Ikʉ chʉ'ʉ chĩi chʉ'ʉ oiʉ paakʉ'mʉ. Rʉa pojomʉ chʉ'ʉ ikʉre. Repaʉ chʉ'ore asajʉ pa'ijʉ̃'ʉ mʉsanʉkona”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jã'aja'ñe i'kache'te asa kʉkʉcajejanisõ Jesús neena vajʉchʉjʉ tãni meñe ʉmeasome. ");
INSERT INTO coe_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ũcuarʉmʉ Jesús sani repanare chẽakʉ ija'che i'kaasomʉ: —Vʉijʉ̃'ʉ. Vajʉchʉmanejʉ̃'ʉ mʉsanʉkona —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chikʉna mʉñe ñato Jesús te'eʉ nʉkaasomʉ; chekʉna te'eʉjẽ'e peoasome. ");
INSERT INTO coe_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jã'aja'ñe cho'ocuha repana aikũti cajerʉmʉ Jesús ija'che chʉ̃'ʉasomʉ repanare: —Diopi ñokʉna mʉsanʉkona irʉmʉ ñasi'e, chʉ'ʉ Dios Raosi'kʉ jũnisõ vajʉraisirʉmʉjatʉ'ka chekʉnare te'eʉ'terejẽ'e kʉamanejʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chikʉna repaʉ neena Jesure ija'che i'kaasome: —Jã'ata'ni, ¿je'se pa'iʉna maire judíopãi che'chona, “Dios raoja'mʉ chiicojñokʉ chuta'a raimarʉmʉna Elías charo raija'mʉ”, chiijʉ che'choche? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chitena Jesús i'kaasomʉ. —Repana che'choche ũcuarepaa'me. Elíaa'mʉ charo rani peore si'ache mamare care'vajaʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jã'ata'ni chʉ'ʉ mʉsanʉkonare, Elías ranicuhasi'kʉa'mʉ, chiimʉ. Rani pa'iʉna repaʉ pa'iche'te vesʉjʉ pãi repanare ʉache peore cu'ache cho'osinaa'me repaʉ'te. Chʉ'ʉre Dios Raosi'kʉre ũcuaja'che repaʉ'te cho'osi'eja'che cu'ache cho'ojanaa'me repana —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jã'aja'ñe i'kaʉna repaʉ neena asa masi, “Aperʉmʉ pa'isi'kʉ Elías rani cho'ojachere i'kama'mʉ ikʉ. Irʉmʉ pa'isi'kʉ Juan Pãi Okoro'vesi'kʉ rani pa'iʉ Elías cho'osi'eja'che cho'osi'kʉ pa'isi'ere i'kamʉ ikʉ”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ũcuarʉmʉ repana Jesuna'me aikũti mʉisina chʉkʉna repaʉ neenana'me pãi repaʉ'te tuhasina cha'ajʉ nʉkachejana caje tĩ'asinaa'me. Caje tĩ'arena pãiʉ Jesús ti'jñeñena sani ro're pʉʉ ñu'iʉ ija'che i'kasi'kʉa'mʉ: ");
INSERT INTO coe_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pãi Ũcuanʉkore Paakʉ, chʉ'ʉ chĩiva'ʉre oijʉ̃'ʉ. Vatipi chẽa paakʉ chʉ̃'ʉkʉna si'arʉmʉ vẽ've curukʉ chekʉrʉmʉ toana tãiʉ chekʉrʉmʉ chiachana tãimʉ repava'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ'ʉ neenani rasi'kʉa'mʉ chʉ'ʉ repava'ʉre, repanapi vatini eto saosõkaapʉ chini. Jã'ata'ni eto saovesʉsinaa'me repana —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chitena Jesús i'kasi'kʉa'mʉ. —Mʉsanʉkona pãi irʉmʉ cana rʉa tĩiñe cuasajʉ masi cuasama'me chʉ'ʉre. ¿Keekerʉmʉ mʉsanʉkona tĩiñe cuasache ñakʉ pa'iche chʉ'ʉ? —Jã'aja'ñe i'ka pi'ni— Ichejana rajʉ̃'ʉ repava'ʉre mʉ'ʉ chĩiva'ʉre —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chini repava'ʉre raʉna Jesupi chʉ̃'ʉʉna eta sanisõsi'kʉa'mʉ vati. Jã'arʉmʉpi repava'ʉ teana vajʉʉ pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jã'a cho'o pi'nisirʉmʉ chʉkʉna Jesús neena ũcuaʉna'me te'ena cutujʉ ija'che sẽesinaa'me repaʉ'te: —¿Je'se pa'iʉna chʉkʉna'te vatire eto saocu'aʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chitena i'kasi'kʉa'mʉ repaʉ. —Dioni masi cuasamapʉna vatire eto saocu'asi'kʉa'mʉ mʉsanʉkonare. Mʉsanʉkonapi mostazara'karʉã rʉa jmara'karʉãja'ñe Diore jmamakarʉ cuasanapi, “Dios peore masikʉ'mʉ”, chini cuasajʉ ikũtire aikũtire, “Chekʉchejare kʉñʉ nʉkajʉ̃'ʉ”, chiito ikũti teana chekʉchejana kʉñʉra'amʉ. Mʉsanʉkonapi Dioni masi cuasarepato peore cho'ore'ochechi'a pa'ira'amʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Vati, iva'ʉ chĩiva'ʉ sa'navʉ pa'isi'kʉjanare Dioni cuasajʉ ãu ãima'ñe pa'ijʉ Repaʉ'te sẽenarechi'a eto saore'omʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ũcuarʉmʉ Jesús chuta'a repaʉ Galilea cheja ku'irʉmʉ ija'che i'kasi'kʉa'mʉ chʉkʉna'te repaʉ neenare: —Chʉ'ʉre Dios Raocojñosi'kʉre cuhena pãi cu'ache cho'oa'jʉ chini chẽa jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jo'karena chʉ'ʉre vanisõjanaa'me repana. Chuenisõ tãcojñosi'kʉta'ni choteumucujñana jo'e vajʉraija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. Jã'aja'ñe i'kache'te asarena rʉa sʉmanesi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ũcuarʉmʉ chʉkʉna Jesús neena Ũcuaʉna'me Capernaum vʉ'ejoopo sani tĩ'asirʉmʉ Dios vʉ'e chʉ̃'ʉnare kuri kookaina Pedroni ñañu chini rani ija'che sẽniasome: —Jesús, mʉsanʉkonare che'chokʉ, ¿Dios vʉ'e chʉ̃'ʉnare kuri ro'ima'kʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chitena Pedro, —Jʉ̃jʉ, ro'ikʉ'mʉ repaʉ —chiniasomʉ. Jã'aja'ñe i'kacuha ũcuaʉ pa'ivʉ'ena Pedroji kakaʉna ña Jesús ija'che i'kakʉ repaʉni charo sẽniasomʉ: —Simón, ¿je'se cuasakʉ mʉ'ʉ? Pãi chʉ̃'ʉna, ¿neeni pa'iche ro'i kuri sẽeñe? ¿Ũcuana mamachĩire sẽeñe? Jã'apãani, ¿chekʉnani sẽeñe? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chikʉna Pedro, —Chekʉnani sẽeme repana —chiniasomʉ. Chikʉna Jesús jo'e i'kaasomʉ. —Jã'a pa'ito repana mamachĩi kuri ro'ichejẽ'e peomʉ. Jã'ajekʉna chʉ'ʉre Dios Mamakʉjekʉna Ja'kʉ vʉ'e chʉ̃'ʉnare kuri ro'iche peomʉ. ");
INSERT INTO coe_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jã'ata'ni repanapi maini pe'rumanea'jʉ chini ija'che cho'ojʉ̃'ʉ: Chiarana caje pitome su'a rʉo va'ire chareparo no'isiva'ʉni mini ñato repava'ʉ chʉ'opo'te kurire'reva paaja'mʉ. Repare'reva kurire'reva chʉ'ʉna'me mʉ'ʉ Dios vʉ'e chʉ̃'ʉnare ro'iche ũcuapa'rʉva ro'ire'reva pa'ija'mʉ. Mini ma ũcuare'revaji Dios vʉ'e chʉ̃'ʉnani ro'ijaijʉ̃'ʉ —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Reparʉmʉ chʉkʉna Jesús neena ũcuaʉni sani ija'che i'kajʉ sẽesinaa'me repaʉ'te: —Chʉkʉna Dios neena, ¿kaʉpi na'a rʉa masikʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Chitena Jesús chĩiva'ʉre soni rao chʉkʉna chenevʉna nʉko ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkonapi tĩiñe cuasache'te jo'kasõ iva'ʉ chĩiva'ʉ cuasacheja'che cuasamaneni Dios pa'icheja saimanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jã'ajekʉna mʉsanʉkonapi iva'ʉ chĩiva'ʉ vesʉkʉ, “Cho'okaijʉ̃'ʉ chʉ'ʉre; vesʉmʉ chʉ'ʉ”, chiiʉ cuasacheja'che cuasanapi chʉ'ʉ neena chekʉnare na'a masina pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pãi chʉ'ʉni cuasajʉ chĩiva'nare ikʉjava'nare pojona chʉ'ʉ neenajejʉna chʉ'ʉre pojocheja'che cho'ome, Diopi ñato. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kasi'kʉa'mʉ: —Chĩiva'na cuasacheja'che chʉ'ʉre cuasakʉni te'eʉ'te cu'ache chʉ'vakʉ'te pãipi ija'che cho'oto na'a re'ora'amʉ: Repaʉ chuta'a chʉ'ʉ neeva'ʉre cu'ache chʉ'vamarʉmʉna toacʉnapʉji rʉa ʉjapʉji repaʉ cavʉna pãipi jepo vẽe chiarana tõ rʉoru na'a re'ora'amʉ repaʉ'te. Jã'aja'ñe cho'oma'to ũcua pa'iʉ chʉ'ʉ neeva'ʉre cu'ache chʉ'vaʉna Diopi repaʉ cu'ache cho'osi'e ro'ire chʉ̃'ʉto na'a rʉa cu'ache pa'ija'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pãi ũcuanʉko re'oja'che pañu chiinata'ni re'oja'che pa'ivesakʉna si'arʉmʉ ũcua cu'ache cho'ojʉ pa'ime. Jã'ajekʉna chʉ'ʉre cuasava'napi cu'ache cho'oa'jʉ chini cu'ache chʉ'vakʉ'te rʉa cu'ache ti'jñeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Jã'ajekʉna, mʉ'ʉ jʉ̃tʉpi chekʉni cu'ache cho'oni repa jʉ̃tʉ tʉso so'ona sẽjosõjʉ̃'ʉ. Chekʉrʉmʉ mʉ'ʉ cũ'apʉji chekʉni cu'ache cho'oni repa cũ'apʉ tʉso so'ona sẽjosõjʉ̃'ʉ. Jã'aja'ñe cho'omaneni jʉ̃jñana'me cũ'a peore paakʉta'ni vati toana saoʉna uukʉ pa'ija'mʉ mʉ'ʉ, ũcuapi jo'e cu'ache cho'osi'kʉjekʉ. Na'a re'omʉ mʉ'ʉpi jʉ̃tʉre tʉso sẽjosõ jã'apãani cũ'apʉ'te tʉso sẽjosõ rũhiroorʉ paava'ʉta'ni Dios pa'ichejana sani re'oja'che pa'ito. ");
INSERT INTO coe_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ũcuaja'che mʉ'ʉ ñakovaji ñakʉ chekʉni cu'ache cho'oni repa ñakova ruta so'ona sẽjosõjʉ̃'ʉ. Jã'aja'ñe cho'omaneni ñakocaã peore paakʉta'ni vati toana saoʉna uukʉ pa'ija'mʉ mʉ'ʉ, ũcua ñakovaji ñakʉ jo'e cu'ache cho'osi'kʉjekʉ. Na'a re'omʉ mʉ'ʉpi ñakova'te ruta sẽjosõ te'eñakova paava'ʉta'ni Dios pa'ichejana sani re'oja'che pa'ito —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kasi'kʉa'mʉ: —Iva'nare chĩiva'nare te'eʉ'terejẽ'e cu'ache cuasajʉ cuhemanejʉ̃'ʉ mʉsanʉkona. Iva'na chĩiva'na, chʉ'ʉ Ja'kʉre Cʉnaʉmʉ Pa'ikʉ'te Diore si'arʉmʉ ja'me pa'ina ángeles kuiracojñova'naa'me. ");
INSERT INTO coe_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chʉ'ʉ, pãire ja'me paaʉ chini Dios Raosi'kʉ, pãire vati toa sani uuche'te ʉ̃sekʉ chẽa paara chini chejana cajesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Je'se cuasokʉ mʉsanʉkonare? Chekʉrʉmʉ mʉsanʉkona te'eʉji ovejava'nare cienrepava'nare paamʉ. Jã'ajanʉkore paakʉni chekʉrʉmʉ ovejava'ʉ te'eva'ʉ tĩichejana sani cavesʉsõmʉ. Ũcuarʉmʉ mʉ'ʉ chekʉva'nare noventa y nueverepava'nare te'eva'nare aikũti ja'mevana jo'ka, cavesʉsiva'ʉni ku'era chini sanisõmʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sani ku'ekʉ pa'iʉ jñaani chekʉva'nare noventa y nueverepanare cavesʉmanesiva'nare na'a rʉa pojomʉ mʉ'ʉ repava'ʉre. Pojokʉ repava'ʉre mini kuãa ramʉ mʉ'ʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mai Ja'kʉ Dios Cʉnaʉmʉ Pa'ikʉ ũcuaja'che, Repaʉ'te cuasanare vesʉva'nare iva'nare chĩiva'nare oicheja'che oiʉ te'eʉ'terejẽ'e vati toana saapʉ chiima'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kasi'kʉa'mʉ: —Chekʉrʉmʉ mʉ'ʉ majapãiʉja'iʉji Diore cuasakʉji mʉ'ʉni cu'ache cho'oto, sani repaʉ'te te'eʉ'te i'kajʉ̃'ʉ, repaʉ cu'ache cho'osi'ere masia'kʉ. I'kaʉna asa jachama'to ũcua ja'me pa'imʉ mʉ'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jã'ata'ni repaʉji asa jachato chekʉni te'eʉ'te jã'apãani ka'chanare soni rao jo'e ũcuare repana asajʉ'te i'kajʉ̃'ʉ, repaʉni ja'me chʉ'vaa'jʉ. Repaʉ cho'osi'e asa kʉakainapi chotena jã'apãani te'eka'chapana pa'ito re'omʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Repana chʉ'vache'te asacuheto Diore cuasakuanupʉ'te soni rao kʉajʉ̃'ʉ repaʉ cho'oche, repanapi asa ja'me chʉ'vaa'jʉ. Jã'ana chʉ'vache'te ũcua asacuheto, “Diore cuasama'kʉja'che pa'iʉ Romapãi chʉ̃'ʉnare kuri kookaina pa'icheja'che cu'ache pa'imʉ ikʉ”, chini cuasakʉ ja'me pa'imanejʉ̃'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Mʉsanʉkonapi Diore cuasanapi jã'aja'ñe cho'onani chekʉre, “Mʉ'ʉ cu'ache cho'osi'e ro'i cu'ache chʉ̃'ʉcojñoja'mʉ mʉ'ʉ”, chiito Dios Cʉnaʉmʉ Pa'ikʉ ũcuaja'che i'kaja'mʉ. Jã'ata'ni mʉsanʉkonapi repaʉni, “Mʉ'ʉ cu'ache cho'osi'e ro'i cu'ache chʉ̃'ʉñe peomʉ mʉ'ʉre”, chiito Dios Cʉnaʉmʉ Pa'ikʉ ũcuaja'che i'kaja'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Jo'e ija'chere i'kamʉ chʉ'ʉ mʉsanʉkonare: Mʉsanʉkonapi ichejare chejare pa'ijʉ ka'chana ũcuate'e cuasa, “Dioni sẽñu maini cho'okaaʉ”, chini Repaʉni sẽeto chʉ'ʉ Ja'kʉ Dios Cʉnaʉmʉ Pa'ikʉ asa cho'okaija'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chʉ'ʉre cuasanapi chotena jã'apãani te'eka'chapana chi'i pa'ijʉ chʉ'ʉre pojonare repana chenevʉ'te ja'me pa'ija'mʉ chʉ'ʉ, ñoma'kʉta'ni —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ũcuarʉmʉ Pedro na'a kueñe sani Jesure ija'che sẽesi'kʉa'mʉ: —Chʉkʉna'te Paakʉ, chekʉrʉmʉ chʉ'ʉ majapãiʉja'iʉji chʉ'ʉni cuhama'ñe cu'ache cho'oto, ¿jetopʉñoã cuasamaneja'ñe chʉ'ʉ repaʉ cho'oche? ¿Sieterepañoãjatʉ'ka? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chikʉna Jesús repaʉ'te ija'che i'kasi'kʉa'mʉ: —Sieterepañoãjatʉ'kama'ñe, sieterepañoãchi'api setentarepañoã cho'otojẽ'e jo'e cuasamanejʉ̃'ʉ repaʉ cu'ache cho'oche —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e ija'che i'kasi'kʉa'mʉ: —Dios neena chekʉnare cu'ache cho'ocojño jo'e cuasama'ñe pa'inana'me cavesʉcuhenare Repaʉ cho'ojache ija'chea'me: Aperʉmʉ pa'isi'kʉ pãi chʉ̃'ʉkʉ repaʉ'te cho'oche cho'okainapi ũcuaʉni põsero'i paajʉna repanapi ro'ia'jʉ chini sẽsa chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chini ũcuanʉkore sẽepi'rakʉ repaʉ'te na'a rʉa põsero'i paakʉni te'eʉ'te charo soni raoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jã'ata'ni repaʉ'te cho'oche cho'okaiva'ʉ põsero'i ro'ijache kurijẽ'e peoasomʉ. Jã'ajekʉna pãi chʉ̃'ʉkʉ chekʉnare soni rao, “Ikʉre repaʉ rʉ̃jona'me mamachĩina'me repana paamajñarʉã tʉa peore ĩsisõjʉ̃'ʉ. Chʉ'ʉpi repaʉ põsero'i paache'te koora”, chiiʉ chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chikʉna asa repava'ʉ ũcuaʉ ti'jñeñena ro're pʉʉ ñu'iʉ ija'che i'kakʉ rʉa sẽniasomʉ: “Chʉ'ʉre paakʉ, oijʉ̃'ʉ chʉ'ʉva'ʉre. Na'mirepa sẽema'ñe cha'ajʉ̃'ʉ. Jmanʉkorʉãchi'a peore ro'isõra chʉ'ʉ mʉ'ʉre”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jã'aja'ñe i'kaʉna asa pãi chʉ̃'ʉkʉ repaʉni oiʉ, “Põsero'i sẽema'mʉ chʉ'ʉ mʉ'ʉre”, chini etoasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Jã'ata'ni repaʉ, etoʉna saiʉ repaʉ'te ja'me cho'oche cho'okaikʉ'te repaʉ'te jmanʉkorʉ põsero'i paakʉni tijñaasomʉ. Tijña repaʉ'te cavʉna chẽa rʉsokʉ, “Mʉ'ʉ põsero'i teana ro'isõjʉ̃'ʉ chʉ'ʉre”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jã'aja'ñe cho'oʉna repava'ʉ ũcuaʉ ti'jñeñena ro're pʉʉ ñu'iʉ ija'che i'kakʉ rʉa sẽniasomʉ: “Chʉ'ʉva'ʉre oiʉ na'mirepa sẽema'ñe cha'ajʉ̃'ʉ. Jmanʉkorʉãchi'a ro'isõra chʉ'ʉ mʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jã'aja'ñe i'kava'ʉreta'ni cha'acuhekʉ repaʉni cu'ache cho'onare chẽa cuaovʉ'ena cuao repaʉ põsero'i ro'i pi'niñetʉ'ka paaa'jʉ chini pãi chẽanani chʉ̃'ʉasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jã'aja'ñe cho'oʉna asa chekʉna repaʉna'me cho'oche cho'okaina sʉma'ñe cuasa oijʉ sani repanare paakʉni peore kʉaasome repaʉ cho'osi'e. ");
INSERT INTO coe_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kʉarena asa pãi chʉ̃'ʉkʉ repaʉni soijani raa'jʉ chini chʉ̃'ʉasomʉ. Rarena repaʉ'te, “Rʉa cu'akʉ'mʉ mʉ'ʉ. Chʉ'ʉre rʉa põsero'i paakʉ'teta'ni mʉ'ʉre sẽemanesi'kʉa'mʉ chʉ'ʉ, mʉ'ʉpi rʉa i'kakʉ, ‘Oijʉ̃'ʉ chʉ'ʉva'ʉre’, chiiʉ chʉ'ʉni sẽkʉna. ");
INSERT INTO coe_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chʉ'ʉ mʉ'ʉre oiʉ re'oja'che cho'osi'eja'che cho'okairʉja'chere chekʉre rʉa cu'ache cho'oasomʉ mʉ'ʉ. Rʉa cu'amʉ jã'a”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jã'aja'ñe i'kakʉ pãi chʉ̃'ʉkʉ rʉa pe'rukʉ repaʉ põsero'i peore ro'isõñetʉ'ka repaʉ'te cu'ache cho'oche chʉ̃'ʉasomʉ —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chini Jesús jo'e cheke ija'che i'kasi'kʉa'mʉ: —Chʉ'ʉ Ja'kʉ Cʉnaʉmʉ Pa'ikʉ ũcuaja'che cho'oja'mʉ mʉsanʉkonare, chekʉna cu'ache cho'osi'ere mʉsanʉkonapi cavesʉma'ñe cuasato —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jã'aja'ñe i'kacuha Jesús Galilea cheja pa'isi'kʉpi Judea chejana Jordán chiacha ʉ̃sʉʉ mʉikã'ko pa'ichejana sani tĩ'asi'kʉa'mʉ repaʉ, chʉkʉna repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pãi rʉa jainʉko ja'me tuhasinaa'me repaʉ'te. Tuharena ũcuachejana jũ'iva'nare vasosi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ũcuarʉmʉ fariseopãi te'ena Jesús pa'ichejana rani ija'che i'kajʉ sẽesinaa'me repaʉ'te, tĩiñe i'kaʉna repaʉni chẽa cu'ache cho'oñu chini: —¿Pãiʉ'te repaʉ rʉ̃jopi ũcuaʉache'te cho'oru cuhekʉ sẽjore'okʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chitena Jesús ija'che i'kasi'kʉa'mʉ: —¿Aperʉmʉ tocha jo'kasi'e Dios chʉ'o kʉache ñamanaa'ñe mʉsanʉkona? Ija'che chiimʉ repa: Dios apereparʉmʉ pãiʉ'te cho'osi'kʉ ʉmʉʉna'me romio'te cho'osi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jã'ajekʉna ʉmʉʉ repaʉ pʉka'kʉpãi ja'me pa'isi'e jo'kasõ rʉ̃jona'me pa'imʉ. Jã'aja'ñe cho'o ũcuate'eʉja'che pa'ime repana, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Diopi ñato ũcuate'eʉja'che pa'ijʉ ka'chanama'me repana. Jã'ajekʉna pãiʉji Dios jã'aja'ñe paapʉ chini jo'kasi'ere jachakʉ rʉ̃joni sẽjosõni cu'ache cho'omʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chikʉna repaʉ'te ija'che sẽesinaa'me repana: —Moisés aperʉmʉ ija'che chiiche chʉ̃'ʉ jo'kaasomʉ: Pãiʉ ũcuaʉakʉji repaʉ rʉ̃jore paacuhekʉ sẽjora chiikʉ charo repao'te sẽjojañere kʉakʉ utija'ovana tocha pi'ni ũcuaoni ĩsia'kʉ, repao chekʉnare ñojaja'ova. Jã'aja'ñe cho'ocuha repaʉ sẽjore'omʉ repao'te. ¿Je'se pa'iʉna jã'aja'ñe chiiche tocha jo'kaʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chitena Jesús repanare i'kasi'kʉa'mʉ. —Mʉsanʉkonapi cu'ache cho'oche'te jo'kacuhejʉ ũcuaʉache cho'oñu chiijʉna jã'aja'ñe chʉ̃'ʉ jo'kaasomʉ Moisés. Jã'ata'ni Dios mamarʉmʉ jã'aja'ñe chʉ̃'ʉ jo'kamanesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chʉ'ʉ mʉsanʉkonare ija'che i'kamʉ: Pãiʉ ũcuaʉakʉji repaʉ rʉ̃jore chekʉre ja'me kãima'koni rurepapʉ sẽjosõ chekoni vejani Dios ʉ̃seche'te cu'ache cho'omʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jã'aja'ñe i'kaʉna asa chʉkʉna repaʉ neena ija'che i'kasinaa'me repaʉ'te: —Jã'aja'ñejekʉna pãipi vejama'ñe pa'ito na'a re'ora'amʉ —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chitena Jesús jo'e i'kasi'kʉa'mʉ. —Jã'ata'ni pãi vejama'ñe te'ena pa'ina ũcuarepanʉko pa'imasima'me. Dios cho'okaicojñonachi'a pa'imasime vejama'ñe pa'ina. ");
INSERT INTO coe_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pãi si'ache cho'ojʉ romi vejamana pa'ime. Te'ena chĩirʉmʉna teana romi paacu'ava'na aineesiva'na pa'ime. Te'ena romire cu'a cho'oche'te ʉ̃sejʉ chekʉnapi re'vasõkatena romi peome. Chekʉnata'ni Dios chʉ̃'ʉñe'te cho'ojʉ pañu chini romi vejama'me. Pãi te'ena pa'imasini vejamanejʉ̃'ʉ. Jã'ata'ni te'ena pa'ivesʉni vejajʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ũcuarʉmʉ pãi repana chĩiva'nare Jesús pa'ichejana rasinaa'me, repaʉji chĩiva'nani chẽsekʉ Dioni re'oja'chere sẽekaaʉ chini. Jã'aja'ñe rajʉna ña chʉkʉna repaʉ neena ʉ̃sepi'rasinaa'me repanare. ");
INSERT INTO coe_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jã'aja'ñe cho'ojʉna Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Chĩiva'nare raiʉ̃semanejʉ̃'ʉ mʉsanʉkona chʉ'ʉni raapʉ. Iva'na chĩiva'naja'ñe pa'ijʉ chʉ'ʉre masi cuasanapi Dios chʉ'o asa chẽajanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chini Jesús repava'nare chĩiva'nare chẽsekʉ Diore sẽekani pi'ni ũcuachejapi jo'e tĩichejana sanisõsi'kʉa'mʉ chʉkʉnana'me. ");
INSERT INTO coe_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ũcuarʉmʉ põsʉʉ Jesuni ñara chini rani ija'che sẽesi'kʉa'mʉ repaʉ'te: —Masiʉ, ¿ʉ̃quere re'oja'che cho'oni'te Dios pa'icheja saija'che chʉ'ʉ? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chikʉna Jesús repaʉ'te i'kasi'kʉa'mʉ. —¿Je'se pa'iʉna mʉ'ʉ Dios pa'icheja sasa chiikʉta'ni re'oja'che cho'oche'te masira chini chʉ'ʉni sẽekʉ? Diochi'aa'mʉ te'eʉ re'oja'che cho'omasikʉ. Repaʉ pa'ichejana sasa chini Repaʉ chʉ̃'ʉ jo'kasi'ere asa jachama'ñe cho'okʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chikʉna põsʉʉ i'kasi'kʉa'mʉ. —Maipi cho'ojʉ paapʉ chini Dios chʉ̃'ʉ jo'kasimajñarʉã rʉaa'me. Jã'ata'ni, ¿jeere Dios na'a rʉa chiimajñarʉã cho'oja'che chʉ'ʉ? —chiisi'kʉa'mʉ. Chikʉna Jesús i'kasi'kʉa'mʉ. —Ija'chea'me Dios chiirepache, Repaʉ chʉ̃'ʉ jo'kasi'e: “Pãi vanisõmanejʉ̃'ʉ. Ʉmʉpãi, romi paana chekʉnare romi ja'me kãimanejʉ̃'ʉ. Ũcuaja'che romi ʉmʉ pa'ina chekʉnare ʉmʉpãi ja'me kãimanejʉ̃'ʉ. Chekʉna nee ñaamanejʉ̃'ʉ. Chekʉna pa'iche'te kʉani joremanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉja'kʉpãi ña, kʉkʉjʉ pa'ijʉ̃'ʉ. Chekʉnare oijʉ pa'ijʉ̃'ʉ mʉsanʉkona meñe oicheja'che”, chiimʉ. Jã'are cho'okʉ pa'ijʉ̃'ʉ mʉ'ʉ —chiisi'kʉa'mʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Peore jã'a jachama'ñe cho'okʉ pa'ikʉ'mʉ chʉ'ʉ. ¿Ʉ̃quepi chʉ'ʉre chuta'a re'oja'che cho'oche karakʉ? —chiisi'kʉa'mʉ repaʉ põsʉʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chikʉna Jesús repaʉ'te i'kasi'kʉa'mʉ. —Mʉ'ʉpi karama'ñe re'oja'che cho'ora chini mʉ'ʉ paache'te cu'amajñarʉãre peore ĩsisõ, kuri koo chʉova'na pa'iva'nani rupʉ ĩsijʉ̃'ʉ. Ĩsisõjani rani chʉ'ʉna'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oni'te Dios pa'ichejana sani re'oja'che pa'ija'mʉ mʉ'ʉ —chiisi'kʉa'mʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesupi jã'aja'ñe i'kaʉna asa põsʉʉ ĩsicuhekʉ sʉmava'ʉ sanisõsi'kʉa'mʉ rʉa kuriʉjekʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare ija'che i'kasi'kʉa'mʉ: —Kuriʉ'te Dios pa'icheja saiʉakʉ'teta'ni saicu'aja'mʉ, repaʉji kurire na'a rʉa cuasakʉ Dioni cuasama'to. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jo'e ũcuare i'kamʉ chʉ'ʉ mʉsanʉkonare. Camellova'ʉre miuñakarʉ cojerʉ kaka etajaicu'acheja'che kuriʉ'te Dios pa'icheja saicu'aja'mʉ, repaʉji kurire na'a rʉa cuasakʉ pa'ito —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesupi jã'aja'ñe i'kaʉna asa jñano repaʉ'te ija'che i'kasinaa'me chʉkʉna: —Jã'a pa'ito, ¿je'se cho'onani Dios pa'icheja saire'oja'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chitena Jesús chʉkʉnani ñakʉ ija'che i'kasi'kʉa'mʉ: —Maichi'a te'ena cuasajʉna Dios pa'icheja saicu'amʉ maire pãi. Diopi cho'okaitota'ni Repaʉ pa'icheja saiche vesama'mʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chikʉna Pedro ija'che i'kasi'kʉa'mʉ Jesure: —Chʉkʉna mʉ'ʉna'me pañu chini chʉkʉna paasimajñarʉã peore jo'kasõ rani mʉ'ʉna'me ku'ime. Jã'aja'ñe cho'osi'e ro'i, ¿ʉ̃quere koojanaa'ñe chʉkʉna? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Chikʉna Jesús chʉkʉna'te ija'che i'kasi'kʉa'mʉ: —Dios si'amajñarʉã peore jo'e mama cho'osirʉmʉ chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ pãi chʉ̃'ʉna ñu'isaivʉ'te ñu'iʉ chʉ̃'ʉja'mʉ. Reparʉmʉ mʉsanʉkona chʉ'ʉna'me ku'isina ũcuaja'che pãi chʉ̃'ʉna ñu'isai docerepasaire te'esaichi'a ñu'ijʉ Israelpãi docerepana jojosinani chʉ̃'ʉjʉ pa'ijanaa'me. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pãi chʉ'ʉni cuasajʉ Dios chʉ̃'ʉñe'te cho'ojʉ pañu chini chekʉrʉmʉ repana vʉ'ña jo'kasõme. Chekʉrʉmʉ repana majaa'chʉpãire jo'kasõme. Chekʉrʉmʉ repana majaa'choromire jo'kasõme. Chekʉrʉmʉ repana cho'jechĩire jo'kasõme. Chekʉrʉmʉ repana pʉka'kʉpãire jo'kasõme. Chekʉrʉmʉ repana mamachĩire jo'kasõme. Chekʉrʉmʉ chejña repana cho'oche cho'osichejña jo'kasõme. Jã'aja'ñe cho'osina ũcuanʉko repana aperʉmʉ paasinʉko na'a rʉa jñaajanaa'me. Ũcuachi'a jũnisõsirʉmʉ Dios pa'ichejare ai sani re'oja'che pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pãi te'ena põsʉʉ kuriʉ repaʉ nee jo'kacuhesi'eja'che repana neere jo'kacuhejʉ karama'ñe paajʉ chekʉnare, “Re'oja'che pa'inaa'me ina”, chiicojñome. Chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ repana paache jo'kasõnareta'ni chekʉna ña cu'ache cutume. Jã'ata'ni Dios na'a pa'isirʉmʉ repana paache'te jo'kacuhejʉ karama'ñe paajʉ chekʉnare, “Re'oja'che pa'ime ina”, chiicojñosinare, “Cu'ache pa'inaa'me ina”, chiija'mʉ. Chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ repana paache jo'kasõ chekʉnare cu'ache cutucojñosinareta'ni, “Re'oja'che pa'inaa'me ina”, chiija'mʉ Dios —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare jo'e ũcuaʉji cuasakʉ ija'chere kʉasi'kʉa'mʉ: —Repaʉ chʉ̃'ʉñe cho'onare Dios cho'ojache ija'chea'me: Pãiʉ cheja cho'oche cho'ocheja paakʉ rʉa apeñatato vʉni etaasomʉ, pãire ku'e jñaa repaʉ pĩsi ʉche chio tʉakaiche'te chʉ̃'ʉ jo'kara chini. ");
INSERT INTO coe_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ku'e jñaa repanare, “Cho'oche cho'oche te'eumucuse denario kurire'reva te'ere'reva ro'ija'mʉ chʉ'ʉ mʉsanʉkonare”, chiniasomʉ. Chini, “Jaʉ”, chitena repanare chiona chʉ̃'ʉ saoasomʉ repaʉ, pĩsi ʉchere tʉakaapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Repanare saocuha vʉ'ena co'i, nueve pa'itona umucuse jo'e vʉ'ejoopona eta ãu ĩsichejana mʉa chekʉnare pãi cho'oche'te peojʉ rupʉ pa'inani ñaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ña repanare ija'che i'kaasomʉ repaʉ: “Mʉsanʉkona ũcuaja'che, chʉ'ʉ ʉche chiona sani ʉchere ja'me tʉakaijʉ̃'ʉ. Cho'okaisi'e ro'i masi ro'ira”, chiniasomʉ. Chikʉna asa, “Jaʉ”, chini, saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Repana saisirʉmʉ jo'e vʉ'ena co'iasomʉ repaʉ. Co'i pa'iʉ nʉkarepaʉ sʉ'itona jo'e eta mʉa repaʉ charo cho'osi'eja'che cho'oasomʉ repaʉ. Tres pa'ito na'ito eta jo'e ũcuaja'che cho'oasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jã'aja'ñe cho'osi'kʉpi na'irepa chekʉrʉmʉ cinco pa'itona jo'e eta ãu ĩsichejana mʉa chekʉnare pãi rupʉ pa'inani ña ija'che i'kaasomʉ repaʉ: “¿Je'se pa'iʉna mʉsanʉkona cho'ochejẽ'e cho'oma'ñe si'aumucuse ichejare pa'ijʉ pa'iche?”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chikʉna repaʉ'te ija'che i'kaasome repana: “Pãi te'eʉjẽ'e, ‘Rani cho'oche cho'okaijʉ̃'ʉ chʉ'ʉre; ro'ira’, chiikʉjẽ'e peomʉ chʉkʉna'te”, chiniasome. Jã'aja'ñe i'karena asa, “Chʉ'ʉ ʉche chiona sani ʉchere tʉakaijʉ̃'ʉ chʉ'ʉni”, chiniasomʉ repaʉ. Chikʉna, “Jaʉ”, chini sani, na'isõcuhasirʉmʉta'ni tʉakaniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Ũcuarʉmʉ chio paakʉ, repaʉ'te cho'oche cho'okainare chʉ̃'ʉkaikʉ'te na'iʉna ija'che i'kaasomʉ: “Chʉ'ʉre cho'oche cho'okainare ũcuanʉkore soni rao, cho'jerepa raisinani charo ro'ijʉ̃'ʉ. Chareparo raisinare cho'jerepana ro'ijʉ̃'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chikʉna asa repaʉji sokʉna na'ito cinco pa'itona kaka cho'oche cho'osina raniasome. Rani ũcuanʉko denario kurire're te'ere'rechi'a cho'oche te'eumucuse ro'ichenʉko kooasome repana. ");
INSERT INTO coe_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jã'anare ro'i pi'nisirʉmʉ charo saisina ũcuanani ro'ipi'rajʉna ija'che cuasaasome: “Maita'ni si'aumucuse cho'oche cho'osinajejʉ na'a rʉa koojanaa'me”, chiijʉ cuasaasome. Jã'aja'ñe cuasanareta'ni repanare ũcuajanʉkorʉchi'a ro'iasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ro'iʉna koo ña chio paakʉni ke'rejʉ ");
INSERT INTO coe_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ija'che i'kaasome repana: “Inare na'irepa sani te'ehorachi'a cho'oche cho'osinare, chʉkʉna'te rʉa asucheja si'aumucuse cho'oche rʉa cho'ojʉ na'isinare ro'ichenʉko ro'isi'kʉa'mʉ mʉ'ʉ”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chitena chio paakʉ repanare te'eʉ'te i'kaasomʉ. “Ñakʉ, mʉ'ʉre tĩiñe cho'oma'ñe ũcuarepa cho'omʉ chʉ'ʉ. Aperʉmʉ chʉ'ʉ mʉ'ʉre, ‘Cho'oche cho'oche ro'i te'eumucuse denario kurire'reva te'ere'reva ro'ija'mʉ’, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jã'ajekʉna mʉ'ʉre ro'isinʉko sakʉ saijʉ̃'ʉ mʉ'ʉ. Chʉ'ʉpi chio paakʉji inani cho'jerepa saisinareta'ni mʉsanʉkonare ro'ichenʉko ro'ira chiito re'omʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chʉ'ʉ neea'me jã'a kuri. Repa kuri chʉ'ʉre ʉache cho'ore'omʉ. ¿Chʉ'ʉpi inani oiʉ ũcuajanʉkochi'a ro'ikʉna pe'ruche mʉsanʉkona?”, chiniasomʉ repaʉ —Jã'aja'ñe i'kakʉ chʉ'vasi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dios ũcuaja'che chio paakʉ repaʉ'te si'aumucuse cho'oche cho'osinana'me na'irepa sani cho'osinani ũcuajanʉkorʉchi'a ro'isi'eja'che Repaʉni cuasajʉ Repaʉ chʉ̃'ʉñe rʉa jeerʉmʉ cho'onare na'a cho'je cuasajʉ Repaʉ chʉ̃'ʉñe cho'onare ũcuapa'rʉvachi'a oiʉ repana jũnisõsirʉmʉ pa'iche re'oja'chere ĩsija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ũcuarʉmʉ Jesús Jerusalén vʉ'ejoopona maiʉ pãipi jainʉko ja'me maijʉna, chʉkʉna'te repaʉ neenare docerepanare te'enare soni ija'che kʉasi'kʉa'mʉ: ");
INSERT INTO coe_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalén vʉ'ejoopona maime mai. Ũcuachejana chʉ'ʉre Dios Raosi'kʉre pãipi chẽa judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonani sa jo'kajanaa'me. Ũcuanapi chʉ'ʉre vanisõjañe chʉ̃'ʉ ");
INSERT INTO coe_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","judío peonani jo'karena, rʉa cu'ache cutujʉ pãisojʉ suĩ'sue pi'ni kurususẽ'verona jẽ'jo nʉko vẽasõjanaa'me repana chʉ'ʉre. Jã'ata'ni choteumucujñana vajʉraija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ Jesús chʉkʉna'te repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ũcuarʉmʉ Zebedeo mamachĩi pʉka'kona'me Jesús pa'ichejana raisinaa'me. Rani repana pʉka'ko Jesús ti'jñeñena ro're pʉʉsi'koa'mo mamachĩire re'oja'che cho'okaijachere sẽsa chini. ");
INSERT INTO coe_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jã'aja'ñe cho'okona ña Jesús repao'te ija'che sẽesi'kʉa'mʉ: —¿Ʉ̃quere chiiko mʉ'ʉ? —chiisi'kʉa'mʉ repao'te. Chikʉna repao ija'che i'kasi'koa'mo: —Iva'nare chʉ'ʉ chĩiva'nare, mʉ'ʉ chʉ̃'ʉrʉmʉ te'eʉ'te mʉ'ʉ ʉjajʉ̃tʉ cakã'kona, chekʉni kã'kojʉ̃tʉ cakã'kona pʉʉche chʉ̃'ʉjʉ̃'ʉ ñu'ijʉ ja'me chʉ̃'ʉjʉ paapʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chikona Jesús repao mamachĩire ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkona Dios cho'ojachere vesʉjʉ jã'aja'ñe sẽeme. Pãipi mʉsanʉkonani chʉ'ʉre cho'opi'racheja'che vanisõñu chiito, ¿cuhemanejanaa'ñe mʉsanʉkona? —chiisi'kʉa'mʉ repaʉ. Chikʉna repana ija'che i'kasinaa'me: —Cuhema'ñe cho'ocojñojanaa'me chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chitena Jesús repanare ija'che i'kasi'kʉa'mʉ: —Chʉ'ʉ cho'ocojñoñeja'ñe cho'ocojñorepajanaa'me mʉsanʉkona. Jã'ata'ni mʉsanʉkonare chʉ'ʉna'me ñu'ijañe chʉ̃'ʉ jo'kacu'amʉ chʉ'ʉre. Chʉ'ʉ Ja'kʉ apereparʉmʉna Repaʉ ĩsija'mʉ chiicojñosinani jo'kaja'mʉ jã'a chʉ'ʉna'me ñu'iñe —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ũcuarʉmʉ chʉkʉna Jesús neena dierepana, repao sẽesi'ere asa mamachĩire ka'chanare rʉa pe'rusinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jã'aja'ñe pe'rujʉna ña Jesús chʉkʉna'te soni rao ija'che i'kasi'kʉa'mʉ: —Ie masicosome mʉsanʉkona: Icheja cheja pãi chʉ̃'ʉna repana neenare rʉa cuaja pa'iche'te chʉ̃'ʉjʉ rʉa chʉova'nare cho'ojʉ pa'ime. ");
INSERT INTO coe_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jã'ata'ni mʉsanʉkonapi te'eʉ pãi chʉ̃'ʉkʉ pasa chini repana cho'ocheja'che cho'omanejʉ̃'ʉ. Jã'aja'ñe cho'oma'ñe, cho'oche cho'okaiva'ʉja'che chekʉnare cho'okaiʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te'eʉji chekʉnare paara chini repana paacojñokʉ pa'icheja'che pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jã'aja'ñe pa'ikʉ'mʉ chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ. Pãipi cho'okaapʉ chini raisi'kʉma'mʉ chʉ'ʉ. Pãire ũcuanʉkore re'oja'che cho'okaiʉ repana cu'are jũni ro'ikasa chini raisi'kʉa'mʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ũcuarʉmʉ chʉkʉnapi Jericó vʉ'ejoopo pa'isinapi Jesuna'me eta saijʉna pãi rʉa jainʉko ja'me saisinaa'me chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eta saijʉ ñato na'ava'na ka'chava'na ma'a rʉ'tʉva'te ñu'isinaa'me. Ũcuarʉmʉ repana Jesús caraiche'te asa ija'che i'kajʉ ʉjachʉ'opi cuisinaa'me: —Pãi Ũcuanʉkore Paakʉ, David aperʉmʉ pa'isi'kʉ jojosi'kʉ, oijʉ̃'ʉ chʉkʉnava'nare —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jã'aja'ne i'kajʉna chʉkʉna'te tuhana pãi, —Re'omʉ. Jo'e i'kamanejʉ̃'ʉ —chiisinaa'me repanare. Jã'ata'ni repana jo'e na'a rʉa cuijʉ i'kasinaa'me. —Pãi Ũcuanʉkore Paakʉ, David aperʉmʉ pa'isi'kʉ jojosi'kʉ, oijʉ̃'ʉ chʉkʉnava'nare —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jã'aja'ñe i'kajʉ cuijʉna asa canʉka Jesús repanare soni rao ija'che sẽesi'kʉa'mʉ: —¿Ʉ̃quere cho'okaaʉ chini sẽeñe mʉsanʉkona chʉ'ʉre? —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chikʉna repana, —Pãi Ũcuanʉkore Paakʉ, chʉkʉna ñakocaã ñoa'kʉ chiime chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jã'aja'ñe i'karena Jesús repanani oiʉ repana ñakocaãna noʉna repana ñakocaã teana re'ojañakocaã care'osõsi'kʉa'mʉ. Ũcuarʉmʉ repana na'ava'na pa'isina ñakocaã re'oja'che ñajʉ ũcuaʉni jovo ja'me ku'ijʉ pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Ũcuarʉmʉ chʉkʉna Jesuna'me saijʉ Jerusalén kueñe cajoopo Olivo aikũti pa'ijoopona Betfagé vʉ'ejoopona tĩ'asinaa'me. Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare te'eka'chapanarechi'a saopi'rakʉ ija'che chʉ̃'ʉsi'kʉa'mʉ: —Jeejoopona kueñe cajoopona saijʉ̃'ʉ mʉsanʉkona. Sani ũcuachejana burrava'ore quẽo sʉosiva'ore chĩina'me rʉ̃iva'oni jñaajanaa'me mʉsanʉkona. Jñaa repava'nare jose ichejana rakaijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pãiʉ ũcuaʉakʉji mʉsanʉkonare, “¿Ʉ̃que cho'oñu chini mʉsanʉkona jã'ava'nare joseche?”, chiito, “Maire Paakʉ iva'nare chiimʉ. Na'mi co'choja'mʉ repaʉ iva'nare”, chiijʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jesupi jã'aja'ñe i'kaʉna, aperʉmʉ Dios chʉ'o kʉakaisi'kʉ tocha jo'kasi'epi ija'che chiicheji ũcuarepa ti'jñesi'kʉa'mʉ: ");
INSERT INTO coe_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén vʉ'ejoopo pa'inare ija'che i'kakaijʉ̃'ʉ: “Ñajʉ̃'ʉ, mʉsanʉkonare chʉ̃'ʉkʉ raiche. Pe'kerʉ pa'iʉ burrava'o põse ve'eva'o mamakʉni tuhiʉ raimʉ”, chiicheji. ");
INSERT INTO coe_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ũcuarʉmʉ repana Jesús neena sani repaʉ chʉ̃'ʉsi'e cho'oasome. ");
INSERT INTO coe_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrava'ore jñaa, repaona'me mamakʉ'te jose Jesús pa'ichejana ra, kãñapi tʉorena Jesús repava'ʉre tuhisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ũcuarʉmʉ pãi rʉa jainʉko repaʉ tuhiʉ saima'ana repana sẽ'sevʉ ju'ikãñapi tĩ'te ja ũhasinaa'me. Chekʉna pũti kare veri ũcua ma'ana ũhasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Repaʉ'te tuhana pãi charo sainana'me cho'je raina ija'che i'kajʉ cuisinaa'me: —¡Ikʉ aperʉmʉ pa'isi'kʉ David Jojocojñokʉ rʉa masiʉ'mʉ! ¡Diopi re'oja'che cho'okaaʉ ikʉre, Repaʉ Raosi'kʉre! Cʉnaʉmʉ Pa'ikʉ Dios peore Masiʉ'mʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Repaʉ Jesús Jerusalén vʉ'ejoopo sani tĩ'asirʉmʉ repajoopo pa'ina pãi repaʉni ñañu chini jainʉko chi'i repaʉ'te ja'me tuhasinani ija'che sẽesinaa'me: —¿Jeeja'iʉ'ʉ jã'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chitena chekʉna ija'che i'kasinaa'me: —Galilea cheja pa'ijoopo Nazaret vʉ'ejoopo raisi'kʉa'mʉ jã'ʉ. Jesua'mʉ. Dios chʉ'o kʉakaikʉ'mʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ũcuarʉmʉ Jesús Dios vʉ'ena kaka, repavʉ'e põse koosinana'me ĩsisinare peore eto saokʉ chekʉnare kuri sa'ñekaisina mesako'ñana'me ũkupova'nare ĩsisina ñu'isisaivʉã jʉjo tajño ũhasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jã'aja'ñe cho'okʉ ija'che i'kasi'kʉa'mʉ repaʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉ vʉ'e pãi chʉ'ʉre pojojʉ sẽevʉ'ea'me, chiimʉ. Jã'ata'ni mʉsanʉkona põse ñaana cho'ocheja'che kaka cu'ache cho'ome ivʉ'e —chiiʉ eto saosi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ũcuarʉmʉ na'ava'nana'me cu'acũ'a paava'na Dios vʉ'ena kakarena Jesús ña repanare vasosi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Jesupi Diochi'a masiche'te cho'oʉna ña judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona rʉa pe'rusinaa'me. Ũcuachi'a repavʉ'e pa'inapi chĩipi Jesús cho'osi'ere ña, cuijʉ ʉjachʉ'opi, “¡Ikʉ aperʉmʉ pa'isi'kʉ David Jojosi'kʉ Dios Raocojñosi'kʉ rʉa masiʉ'mʉ!”, chiijʉna asa pe'rujʉ Jesure ija'che i'kasinaa'me repana: —¿Chĩi i'kajʉ cuiche asama'kʉ mʉ'ʉ? —chiisinaa'me. Chitena Jesús i'kasi'kʉa'mʉ. —Jʉ̃jʉ, asamʉ chʉ'ʉ. Dios chʉ'o aperʉmʉ tocha jo'kasi'e, ¿ñamanaa'ñe mʉsanʉkona? Ija'che chiimʉ: Vĩjachĩina'me na'a aina Diopi cho'okaiʉna Ũcuaʉni pojojʉ re'oja'che i'kajanaa'me, chiimʉ —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ũcuarʉmʉ chʉkʉna repanare pãi jo'ka Jesuna'me Betania vʉ'ejoopona sani kãisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jo'e apeñatato Jesús chʉkʉnana'me Jerusalén vʉ'ejoopona jo'e co'isi'kʉa'mʉ. Co'ikʉna Jesure ãucuhaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Co'ikʉ higoñʉ ma'a rʉ'tʉva nʉkañʉ'te ña repañʉ kueñe sani ñato repara'pʉrʉã peoñʉji ja'ochi'a pa'isi'kʉa'mʉ. Jã'ajekʉna repañʉ ija'che i'kasi'kʉa'mʉ repaʉ: —Jmamakarʉjẽ'e jo'e ãira'pʉrʉã kʉ̃imaneja'mʉ iñʉ —chikʉna repañʉ teana te'erʉmʉ jũnisõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jã'aja'ñe cho'oʉna ña cuasajʉ chʉkʉna repaʉ neena ija'che sẽesinaa'me repaʉ'te: —¿Je'se cho'okʉna jã'añʉ higoñʉ teana jũnisõʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","22","Chitena Jesús i'kasi'kʉa'mʉ. —Mʉsanʉkonapi Diore jachama'ñe masi cuasani higoñʉ chʉ'ʉ cho'osi'eja'chechi'a cho'oma'ñe, cheke si'ache cho'omasijʉ ikũtire aikũtire, “Icheja kʉñʉ chiarana sʉ'a nʉkajʉ̃'ʉ”, chiito repakũti mʉsanʉkona chʉ̃'ʉñe cho'oja'mʉ. Mʉsanʉkona Repaʉ'te sẽeñe peore cho'okaija'mʉ Repaʉ, Ũcuaʉni masi cuasajʉna. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jã'aja'ñe cho'ocuha jo'e rani reparʉmʉ Jesús Dios vʉ'ena kakasi'kʉa'mʉ. Kaka pa'iʉ che'chokʉna judío phairi chʉ̃'ʉnana'me judío aina rani ija'che sẽesinaa'me repaʉ'te: —¿Je'se cuasa pãi chʉ̃'ʉna cho'ocheja'che cho'okʉ mʉ'ʉ? ¿Neepi chʉ̃'ʉrena rani cho'okʉ mʉ'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ ũcuaja'che mʉsanʉkonani chʉ'o sẽniasara. ¿Neepi Juanre Pãi Okoro'vekʉ'te chẽa raore? ¿Diopi raoʉ? Jã'apãani, ¿pãipi chẽa raore repaʉ'te? Mʉsanʉkonapi kʉaru chʉ'ʉ ũcuaja'che iere cho'oa'kʉ chini chʉ'ʉre chẽa raosi'kʉ mami kʉaja'mʉ mʉsanʉkonare —chiisi'kʉa'mʉ. Chikʉna sãiñechi'a ija'che cutusinaa'me repana: “¿Je'se mai ikʉre i'kajanaa'ñe? Maipi, ‘Juanre Dios chẽa raosi'kʉa'mʉ’, chiito ikʉ maire, ‘¿Mʉsanʉkona je'se pa'iʉna jã'aja'ñe cuasanata'ni Juan chʉ'vasi'e cuasamanere?’, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ũcuachi'a, ‘Pãipi chẽa raosinaa'me’, chiicu'amʉ maire. Ina pãi jainʉko, ‘Juan Dios chʉ'o kʉakaikʉ pa'isi'kʉa'mʉ’, chiijʉ cuasame. Jã'ajekʉna maipi jã'aja'ñe i'kato ina asa pe'rujʉ cu'ache cho'ojanaa'me maire”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sãiñechi'a jã'aja'ñe cutu pi'ni Jesure ija'che i'kasinaa'me repana: —Juanre raosi'kʉ mami vesʉme chʉkʉna —chiisinaa'me. Chitena Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ ũcuaja'che mʉsanʉkonapi jã'aja'ñe i'karena chʉ'ʉre chʉ̃'ʉ raosi'kʉ mami kʉamaneja'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ũcuarʉmʉ Jesús repanani chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —¿Ie je'se cuasokʉ mʉsanʉkonare? Pãiʉ chĩi ka'chanare ʉmʉpãichi'a paaasomʉ. Paakʉji repanare te'eʉ'te ija'che i'kaasomʉ repaʉ: “Jmava'ʉ, iumucuse chʉ'ʉ pĩsi ʉche chio cho'oche cho'ojaikaijʉ̃'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chikʉna mamakʉ i'kaasomʉ. “Saiʉama'mʉ chʉ'ʉre”, chiniasomʉ. Jã'ata'ni na'a pa'iʉ jo'e mama cuasa saniasomʉ repaʉ, pʉka'kʉni cho'oche'te cho'okasa chini. ");
INSERT INTO coe_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jã'aja'ñe cho'ocuha pʉka'kʉ chekʉre mamakʉ'te ũcuaja'che i'kaasomʉ. I'kaʉna asa, “Jaʉ, sasa”, chiniasomʉ. Jã'ata'ni saimaneasomʉ repaʉ —Jã'aja'ñe chiiʉ kʉasi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Jã'aja'ñe kʉa pi'ni repanare ija'che sẽniasasi'kʉa'mʉ repaʉ: —Mʉsanʉkona cuasato repaʉ mamachĩi, ¿kaʉpi pʉka'kʉ chiiche cho'okakʉ? —chiisi'kʉa'mʉ. Chikʉna i'kasinaa'me repana. —Charo i'kacojñosi'kʉ —chiisinaa'me. Chitena Jesús repanare ija'che i'kasi'kʉa'mʉ: —Juan Pãi Okoro'vekʉ rani mʉsanʉkonare, Dios chʉ̃'ʉñe cho'ona re'oja'che pa'iche'te chʉ'vasi'kʉa'mʉ. Jã'ata'ni jachasinaa'me mʉsanʉkona. Jã'a cho'oto Romapãi kuri kookainana'me sĩ'uromi, Juan chʉ'vasi'ere asa chẽa repana cu'ache cho'oche ũhasõsinaa'me. Jã'aja'ñe cho'osinajejʉ repana jũnisõsirʉmʉ Dios pa'ichejana saijanaa'me. Mʉsanʉkonata'ni repana cho'oche peore ñasinata'ni mama cuasa cu'ache cho'oche ũhasõmanesinajejʉ saimanejanaa'me. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ũcuarʉmʉ Jesús repanani chʉ'vakʉ jo'e chekere cuasakʉ kʉasi'kʉa'mʉ. —Pãiʉ cheja paakʉ pĩsi ʉche chio tã pi'ni si'acachio rũhiso'koro jeo tʉsʉasomʉ. Repaso'koro jeo pi'ni ʉche cha'ca chachojavʉ je'naasomʉ repaʉ ũcuate'evʉji conora'ka meajacheja pa'ivʉ. Ũcuachi'a repachio kuirakaijanapi si'acachio ñajʉ kuirakaijʉ paapʉ chini vʉ'e ʉmʉ nʉkavʉ'e cho'oasomʉ repaʉ. Peore cho'o pi'ni repa chio kuirakaijanare jñaa jo'ka tĩichejana sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sani pa'iʉ ʉche tʉarʉmʉ tĩ'aʉna repaʉ'te cho'oche cho'okainare ʉche chio kuirakaina pa'ichejana saoasomʉ repaʉ, ʉchere miijani rakaapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jã'ata'ni sani tĩ'arena ña repana ʉche kuirana repanare chẽa te'eʉ'te rʉa asi vaijʉ, chekʉni vanisõjʉ jo'e chekʉni catapi asi su'aasome. Jã'aja'ñe cho'o ʉchejẽ'e peonare asichi'a vani co'choasome repana. ");
INSERT INTO coe_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Co'irena ña ʉche chio paakʉ repaʉ'te cho'oche cho'okainare na'a jainʉkore jo'e ũcuachejana saoasomʉ. Jã'ata'ni sani tĩ'arena repana ʉche chio kuirakaina peore ũcuaja'che repanare asi vani co'choasome. ");
INSERT INTO coe_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Jo'e ũcuaja'che cho'o co'chorena ña ʉche chio paakʉ ija'che cuasakʉ i'kaasomʉ: “Chʉ'ʉ chĩini repana pa'ichejana saora. Jã'ʉreta'ni ña, kʉkʉjacosome repana”, chiiʉ cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jã'aja'ñe cuasa mamakʉni saoasomʉ repaʉ. Jã'ata'ni repaʉ mamakʉji sani tĩ'aʉna ña ʉche chio kuirakaina sãiñechi'a ija'che i'kaasome: “Jã'ʉ ʉche chio paakʉ mamakʉ'mʉ. Pʉka'kʉ jũnisõsirʉmʉ repaʉ paasi'e paajaʉa'mʉ jã'ʉ. Vanisõñu jã'ʉni. Maipi pʉka'kʉ jũnisõsirʉmʉ repaʉ paasi'ere paañu”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chini repaʉ'te chẽa chio rʉ'tʉvana juha sa vanisõasome repana —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jã'aja'ñe kʉacuha repaʉ kʉasi'e asasinare ija'che sẽesi'kʉa'mʉ Jesús: —Repaʉ mamakʉ'te vanisõsi'ere asa ʉche chio paakʉji sani, ¿je'se cho'oja'ʉ repanare ʉche kuirakainare? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chikʉna repana i'kasinaa'me. —Sani repaʉ mamakʉ'te vanisõsinare sãiñe vanisõja'mʉ repaʉ. Repanare vanisõ ʉche chio kuirakaijanare chekʉnani jñaa jo'kaja'mʉ repaʉ, cu'ache cho'oma'ñe ʉche tʉa pi'ni repaʉ'te sa ĩsijanani —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chitena Jesús i'kasi'kʉa'mʉ. —¿Dios chʉ'o aperʉmʉ tocha jo'kasi'e jmamakarʉjẽ'e ñamanaa'ñe mʉsanʉkona? Ija'che chiimʉ: Pãi vʉ'e cho'ona vʉ'ña tuu re'ojatuure ku'ejʉ paniasome. Ku'ejʉ te'etuupʉ jñaani cuheasome repana. Cuhejʉ jo'kaasome repatuupʉ. Chekʉnata'ni na'a rʉa masinajejʉ rani repatuupʉ mini kuãa sa repana vʉ'e chakavʉna nʉkoasome, repana vʉ'epi na'a rʉa jʉjaa'kʉ chini. Diopi cho'okaiʉna jã'aja'ñe cho'ojʉna ña cuasa Repaʉni pojojʉ i'kame chʉkʉna, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jã'ajekʉna mʉsanʉkonare ija'che i'kamʉ chʉ'ʉ: Repaʉ chʉ̃'ʉ jo'kasi'ere cho'oma'to ʉche paakʉ repaʉ chio kuirakaisinare cho'osi'eja'che cho'oja'mʉ Dios mʉsanʉkonare. Mʉsanʉkonare sẽjosõ chekʉnani chẽa paaja'mʉ, Repaʉ chʉ̃'ʉñe cho'ojanare. ");
INSERT INTO coe_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pãiʉ vʉ'e tuupʉna tãni rʉa asi tãimʉ. Ũcuachi'a vʉ'e tuupʉji pãiʉni tãito jũnisõmʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ũcuarʉmʉ judío phairipãi chʉ̃'ʉnana'me fariseopãi Jesús cuasakʉ i'kasi'ere asa masi, “Ikʉ Jesús Ũcuaʉ cuasakʉ kʉacheji maini cu'ache i'kamʉ”, chiijʉ pe'rusinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jã'aja'ñe i'kaʉna asa pe'rujʉ repaʉ'te chẽañu chiisinata'ni pãipi, “Jesús Dios chʉ'o kʉakaikʉ'mʉ”, chiijʉ cuasajʉna, “Maipi repaʉ'te chẽañe'te chʉ̃'ʉto pe'rujanaa'me ina maire”, chini vajʉchʉjʉ chẽamanesinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ũcuarʉmʉ Jesús jo'e judío phairipãi chʉ̃'ʉnana'me fariseopãire chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: ");
INSERT INTO coe_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Repaʉ chʉ̃'ʉñe cho'onare Dios cho'ojache ija'chea'me: Pãi chʉ̃'ʉkʉ repaʉ mamakʉji romioni vejakʉna pojokʉ fiesta cho'oasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jã'aja'ñe cho'okʉ ja'me fiesta cho'ojanare repaʉ aperʉmʉ kʉasinani soijani raa'jʉ chini, repaʉ'te cho'oche cho'okainare chʉ̃'ʉ saoasomʉ repaʉ. Jã'ata'ni repana sani soito raicuheasome. ");
INSERT INTO coe_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Raicuherena repaʉ'te cho'oche cho'okainare jo'e chekʉnani saoasomʉ. “Ija'che chʉ'o sa kʉajʉ̃'ʉ repanare: Chʉ'ʉpi chʉ̃'ʉʉna vacava'nare ãure ãujʉna jujusiva'nare vani peore care'vacuhasi'ea'me. Rani ñaa'jʉ; chʉ'ʉ neekʉ romi vejache'te pojojʉ ãure ãñu, chiijʉ̃'ʉ repanare”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jã'ata'ni repana soicojñosina asa jachajʉ raicuheasome. Cuhekʉ te'eʉ repaʉ chiore ñara chini saniasomʉ. Chekʉ põsere ĩsira chini saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chekʉnata'ni pãi chʉ̃'ʉkʉ saosinare chẽa te'enare asi vaijʉ chekʉnani vanisõasome. ");
INSERT INTO coe_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Repanare vanisõsi'ere asa pãi chʉ̃'ʉkʉ rʉa pe'rukʉ repaʉ neenare sõtaopãi chʉ̃'ʉ saoasomʉ, repaʉ'te cho'oche cho'okainare vanisõsinani sãiñe vanisõ repana pa'isijoopo peore ʉosõa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jã'aja'ñe cho'ocuhasirʉmʉ repaʉ pãi chʉ̃'ʉkʉ repaʉ'te cho'oche cho'okainare jo'e i'kaasomʉ. “Chʉ'ʉ neekʉ romi vejache ñajʉ pojojʉ fiesta cho'ojache peore care'vacuhasi'ea'me. Chʉ'ʉ charo soisinata'ni raicuhesinajejʉ fiesta ja'me cho'omanejanaa'me repana raicuhesi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jã'ajekʉna callejoovʉã pãi rʉa nʉka ku'ijoovʉãna sani mʉsanʉkona tijñanare ũcuaʉanare soni rajʉ̃'ʉ, fiesta'te ja'me cho'oa'jʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chikʉna eta sani ku'ijʉ repana tijñasinare pãi, cu'ache pa'inana'me re'oja'che pa'inare ũcuanʉkore soni ra pãi chʉ̃'ʉkʉ vʉ'ena cuaoasome repana. Jã'aja'ñe cho'orena repavʉ'e timuvʉ'e kakaasome pãi. ");
INSERT INTO coe_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ũcuarʉmʉ pãi chʉ̃'ʉkʉ repaʉ soisinani ñara chini fiesta cho'oruupʉna kaka pãiʉ'te te'eʉ'te romi vejakʉ'te pojona fiesta cho'ojʉ ju'ikãña ju'imava'ʉni ñaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ña repaʉ'te ija'che i'kaasomʉ: “¿Je'se pa'iʉna mʉ'ʉ romi vejakʉ'te fiesta cho'ona ju'ikãña ju'ima'kʉpi ja'me kaka pa'ikʉ icheja?”, chiniasomʉ. Jã'ata'ni repaʉ i'kamaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ũcuarʉmʉ repaʉ pãi chʉ̃'ʉkʉ ãu ãunare ija'che i'kaasomʉ: “Ikʉre jʉ̃jñana'me cũ'a vẽe chijachejana ve'sena etua jo'kajʉ̃'ʉ. Ũcuachejare pa'iʉ oiʉ cõjire asoche ãiʉ paaʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dios ũcuaja'che pãi chʉ̃'ʉkʉ cho'ocheja'che pãi ũcuanʉkore soimʉ Repaʉni cuasajʉ jovo re'oja'che paapʉ chini. Jã'ata'ni pãipi repaʉni cuhejʉ te'eva'na cuasajʉna jainʉkore chẽa paama'mʉ Dios —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ũcuarʉmʉ fariseopãi Jesupi jã'aja'ñe i'kaʉna asa sani sãiñechi'a cutuasome. —Chekʉnani Jesús pa'ichejana saoñu mai. Repanapi chʉ'ore sẽejʉna repaʉji tĩiñe i'kato maire chʉ̃'ʉnani kʉañu repaʉ i'kasi'e. Maipi kʉato chekʉrʉmʉ repaʉ'te chẽañe chʉ̃'ʉjanaa'me repana —chiijʉ repana cho'ojache care'vaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chini repana neenare te'enare chẽa Herode'te chiikuanupʉ ja'me pa'inare raosinaa'me repana, Jesuni ija'che i'kaa'jʉ chini: —Masiʉ, chʉ'o ũcuarepare cutukʉ'mʉ mʉ'ʉ. Pãipi asa chẽa re'oja'che paapʉ chini Dios chʉ̃'ʉñe ũcuarepare che'chokʉ'mʉ mʉ'ʉ. Jã'a masime chʉkʉna. Mʉ'ʉ che'choche'te chekʉnapi asa cu'ache i'katojẽ'e kʉkʉ cuasoma'ñe ũcua che'chokʉ pa'ikʉ'mʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jã'ajekʉna mʉ'ʉni chʉ'o sẽniasañu chiime chʉkʉna, mʉ'ʉ cuasakʉ i'kache'te asa masiñu chini. Romapãi chʉ̃'ʉkʉji Césapi, chʉkʉna pa'iche ro'ire sẽeto, ¿ro'ijanaa'ñe chʉkʉna repaʉ'te? Jã'apãani, ¿ro'imanejanaa'ñe? ¿Je'se cuasakʉ mʉ'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jã'ata'ni Jesús repana cu'ache cho'oñu chiiche'te masikʉ ija'che i'kasi'kʉa'mʉ: —Re'oja'che pa'ina cho'ocheja'che sẽ'sevʉchi'a re'oja'che cho'ome mʉsanʉkona. Chʉ'ʉpi tĩiñere i'kaa'kʉ chini jã'aja'ñe sẽeme mʉsanʉkona chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kurire'reva mʉsanʉkona pa'iche ro'i ro'ijare'reva'te mini ñojʉ̃'ʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ. Chikʉna repaʉ'te kurire'reva miijani ra ñosinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ñojʉna Jesús ija'che i'kasi'kʉa'mʉ repanare: —Ikʉ kurire'reva pa'ikʉ kuechʉsi'kʉ, ¿keeja'iʉ'ʉ? Ũcuachi'a, ¿nee mamipi pa'ikʉ ire'reva? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chikʉna i'kasinaa'me repana. —Maire chʉ̃'ʉkʉ César chiana'me repaʉ mami pa'imʉ jã'are'reva —chiisinaa'me repana. Chitena Jesús i'kasi'kʉa'mʉ repanare. —Jã'a pa'ito pa'iche ro'ire repaʉji kuri ro'iche chʉ̃'ʉto ro'ijʉ̃'ʉ repaʉ'te. Dios chʉ̃'ʉ jo'kasi'e ũcuachi'a cho'ojʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jã'aja'ñe i'kaʉna asa kʉkʉ repaʉ'te jo'ka sanisõsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ũcuaumucusena saduceopãi te'ena Jesuni ñañu chini raisinaa'me. “Pãi jũ'isina jo'e vajʉraimanejanaa'me”, chiijʉ cuasanajejʉ Jesure ija'che sẽesinaa'me repana: ");
INSERT INTO coe_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Masiʉ, Diopi chʉ̃'ʉʉna Moisés aperʉmʉ maire tocha jo'kasi'e ija'che chiimʉ: Pãiʉ romio'te vejasi'kʉpi, chuta'a chĩi peokʉji jo'ka jũnisõru repaʉ cho'jeʉji veja paaa'kʉ majaa'chʉ paasi'kore. Repaoni veja chĩire paakʉ ija'che cuasakʉ paaʉ: “Chʉ'ʉ a'chʉ jũnisõsiva'ʉ chĩijanaa'me ina chʉ'ʉ chĩi”, chiaʉ, chiimʉ repaʉ tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jã'ajekʉna chʉ'o kʉañu chiime chʉkʉna mʉ'ʉre. Icheja chʉkʉna'te ja'me pa'isina majapãichi'a sieterepana pa'isinaa'me ʉmʉpãi. Pa'ijʉ repana majaa'chʉ chareparo cakʉpi te'eʉ romio'te veja paakʉ chuta'a chĩi peokʉji jo'ka jũnisõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jo'ka jũnisõʉna cho'jeʉ repaʉ majaa'chʉ rʉ̃jo pa'isi'koni veja paakʉ ũcuaja'che chuta'a chĩi peokʉji jo'ka jũnisõsi'kʉa'mʉ. Jũnisõʉna na'a cho'je cakʉ ũcuate'eo'te veja ũcuaja'che chĩi peokʉji jũnisõsi'kʉa'mʉ. Jã'aja'ñechi'a sieterepana ũcuanʉko ũcuate'eo'te vejajʉ chĩi peonachi'a jo'ka jũnisõsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Repana peore jũnisõsirʉmʉ romio ũcuaja'che jũnisõsi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jã'ajekʉna pãi jũnisõsina ũcuanʉko jo'e vajʉraisirʉmʉ, ¿kaʉpi repao'te jo'e paaja'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chitena Jesús i'kasi'kʉa'mʉ repanare. —Tĩiñe cuasame mʉsanʉkona. Dios chʉ'o aperʉmʉ tocha jo'kasi'ejẽ'e vesʉjʉ jũ'isinare Dios vasomasichejẽ'e vesʉme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pãi ũcuanʉko jo'e jũni vajʉraisirʉmʉ ʉmʉpãina'me romi jo'e vejamanejanaa'me Diore ja'me pa'ina ángeles pa'icheja'che pa'inajejʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Diopi i'kakʉna asajʉ pãi jũ'isina vajʉraijachere kʉajʉ tocha jo'kasi'e, ¿ñamanaa'ñe mʉsanʉkona? Ija'che chiimʉ: ");
INSERT INTO coe_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Chʉ'ʉ Dios, pãi jũnisõsinarejẽ'e vajʉnareja'che ñakʉ'mʉ, repana rekoñoãpi vajʉkʉna. Jã'ajekʉna mʉsanʉkona aipãi vajʉrʉmʉ chʉ'ʉre cuasasinare paakʉ'mʉ chʉ'ʉ, Abrahamre, Isaare, Jacobre”, chiisi'kʉa'mʉ Dios, chiimʉ repa tocha jo'kasi'e —chiisi'kʉa'mʉ Jesús repanare saduceopãi. ");
INSERT INTO coe_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesupi jã'aja'ñe che'choʉna asa kʉkʉasome repana. ");
INSERT INTO coe_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesupi jã'aja'ñe masi chʉ'vaʉna saduceopãi jo'e i'kamanesi'ere asa fariseopãi repaʉ pa'ichejana rani chi'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chi'i repanare ja'me pa'ikʉ te'eʉ judíopãi che'chokʉji Jesure ija'che sẽesi'kʉa'mʉ, repaʉ masiche'te cho'o ñara chini: ");
INSERT INTO coe_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Dios maire chʉ̃'ʉ jokasi'e, ¿jeea'che Repaʉ maire na'a rʉa cho'ojʉ̃'ʉ chiiche? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chikʉna Jesús ija'che i'kasi'kʉa'mʉ: —Pãi Ũcuanʉkore Paakʉni Dioni mʉsanʉkona aʉji rʉa cuasajʉ pa'ijʉ̃'ʉ. Mʉsanʉkona rekoñoãna'me cuasache peore jã'api Dioni rʉa cuasajʉ pa'ijʉ̃'ʉ. Jã'aa'me Repaʉ chʉ̃'ʉrepache. ");
INSERT INTO coe_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","“Jã'are na'a rʉa cho'ojʉ pa'ijʉ̃'ʉ”, chiimʉ Dios. ");
INSERT INTO coe_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Cheke ũcuaja'chea'me, repaʉ chʉ̃'ʉrepache. Ija'che chiimʉ: “Mʉsanʉkona meñe oicheja'che chekʉnare oijʉ pa'ijʉ̃'ʉ”, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jã'are ka'chamajña cho'ojʉ pani, cheke Repaʉ chʉ̃'ʉsi'e ũcuate'erʉmʉ peore cho'ocheja'che cho'ome mʉsanʉkona Repaʉji ñato, aperʉmʉ Repaʉ chʉ'o kʉakaisina che'chosi'e ũcuachi'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Repana fariseopãi chi'isikuanupʉ chuta'a pa'ijʉna Jesús repaʉ pa'iche'te kʉara chini ija'che sẽesi'kʉa'mʉ repanare: —Cristo, Dios raoja'mʉ chiisi'kʉ pa'iche'te cuasani, ¿je'se cuasache mʉsanʉkona? ¿Nee chĩia'ʉ repaʉ? —chiisi'kʉa'mʉ Jesús repanare. Chikʉna i'kasinaa'me repana. —Aperʉmʉ pa'isi'kʉ David Jojosi'kʉa'mʉ repaʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Chitena Jesús i'kasi'kʉa'mʉ. —Repaʉ David, aperʉmʉ Dios Rekochoji cho'okaiʉna ija'che i'kaasomʉ: Cristo Dios Raojaʉ chʉ'ʉre paakʉ'mʉ, chiniasomʉ. Ũcuachi'a cheke ija'che chiimʉ repaʉ i'kakʉ tocha jo'kasi'e: Dios chʉ'ʉre Paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre kueñe ʉjajʉ̃tʉ cakã'kona pʉʉjʉ̃'ʉ. Chʉ'ʉpi cho'okaiʉna mʉ'ʉre cuhesina ũcuanʉko mʉ'ʉ chʉ̃'ʉñe cho'ojanaa'me”, chiniasomʉ Dios. Jã'aja'ñe tocha jo'kaasomʉ David. ");
INSERT INTO coe_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Je'se pa'iʉna, David, “Chʉ'ʉre paakʉ'mʉ Cristo”, chiisi'eta'ni, “David Jojosi'kʉa'mʉ Cristo”, chiiche pãi? —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jã'aja'ñe i'kaʉna asa sãiñe i'kavesʉjʉ te'echʉ'opojẽ'e i'kamanesinaa'me repana. Jã'ajekʉna repana fariseopãi jã'arʉmʉpi pi'ra repaʉ'te te'eʉjẽ'e jo'e chʉ'o sẽevajʉchʉsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jã'a i'ka pi'nisirʉmʉ pãire ija'che i'kasi'kʉa'mʉ Jesús, chʉkʉna'te repaʉ neenare ũcuachi'a: ");
INSERT INTO coe_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Maire judíopãi che'chonana'me fariseopãi si'arʉmʉ Moisés tocha jo'kasi'e chʉ'vajʉ pa'ime, pãipi asa chẽa cho'ojʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Repana chʉ'vajʉ chʉ̃'ʉñe peore asa jachama'ñe cho'ojʉ pa'ijʉ̃'ʉ. Repana pa'icheta'ni ña chẽa ũcuaja'che pa'imanejʉ̃'ʉ mʉsanʉkona. Ũcuana i'kache cho'oma'ñe chekere cho'onaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jmamakarʉjẽ'e repanare cho'oʉama'ñere chekʉnare rʉa cuajare si'ache chʉ̃'ʉ jo'kanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aperʉmʉ pa'isina judío ʉmʉpãi Dios chʉ̃'ʉsi'e cho'ojʉ va'i ca'nipi rũhira'vʉrʉã cho'o ũcuara'vʉrʉã sa'navʉãna Dios chʉ'o tochasija'orʉã mañaasome, repana jʉ̃jñare quẽo tʉ̃ñu chini. Jã'ajekʉna repana fariseopãi pãipi ña, “Re'onajejʉ Dios chʉ'o rʉa chiime ina”, chiapʉ chini si'ache cho'ojʉ Dios chʉ'o tocha maña tʉ̃ira'vʉrʉã na'a ʉjavʉã cho'o repana chiapʉãna'me jʉ̃jña quẽo tʉ̃ime repana. Ũcuaja'che pãipi ña, “Diore rʉa cuasanaa'me jã'ana”, chiapʉ chini kãña re'ojakãñapi ʉjacueñoãre ju'ijʉ nʉka ku'ime repana. ");
INSERT INTO coe_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ũcuaja'che pãipi repanani ãu ãuñu chini soito mʉa repanare soisi'kʉre kueñe ñu'ineeme repana. Ũcuachi'a mai judíopãi chi'ivʉ'ena mʉa kakani masina ñu'isaivʉãre ñu'ineenaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ũcuachi'a ãu ĩsichejñare ku'ijʉna, pãipi repanani ña chẽa pojojʉ, “Peore masinajejʉ pãi che'chonaa'me ina”, chiito rʉa pojonaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Mʉsanʉkonata'ni pãire che'choni rupʉ repanapi mʉsanʉkonani, “Peore masinajejʉ pãi che'chonaa'me ina”, chiapʉ chini che'choto cu'amʉ. Mʉsanʉkona chʉ'ʉre cuasajʉ majapãija'ñechi'a pa'inaa'me. Mʉsanʉkonare che'chokʉ peore Masiʉ ũcuate'eʉ'mʉ chʉ'ʉ, Dios Raosi'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ũcuachi'a icheja cheja pa'inare te'eʉ'terejẽ'e masinare, “Peore masiʉ'mʉ ikʉ”, chini repaʉ'te, “Ja'kʉ”, chiijʉ pa'imanejʉ̃'ʉ, Cʉnaʉmʉ Pa'ikʉ'te Diorechi'a ũcuate'eʉ'te peore Masiʉ'te Ja'kʉ paanajejʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ũcuachi'a pãi chʉ̃'ʉni rupʉ repanapi mʉsanʉkonani, “Peore masinajejʉ pãi chʉ̃'ʉnaa'me ina”, chiapʉ chini chʉ̃'ʉto cu'amʉ. Mʉsanʉkonare chʉ̃'ʉkʉ peore masiʉ ũcuate'eʉ'mʉ chʉ'ʉ, Dios Raosi'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉsanʉkonapi te'eʉ chekʉnare pãi chʉ̃'ʉra chini cho'oche cho'okaiva'ʉja'che chekʉnare re'oja'che cho'okaiʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ija'chea'me: Pãi ũcuanapi meñe, “Chekʉnare na'a rʉa masime chʉkʉna”, chiijʉ cuasanare, “Rʉa vesʉnaa'me ina”, chiija'mʉ Dios. Jã'ata'ni repanapi meñe, “Chekʉnare na'a rʉa vesʉnaa'me chʉkʉna”, chiijʉ cuasanare, “Rʉa masinaa'me ina”, chiija'mʉ Dios —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ũcuarʉmʉ Jesús fariseopãina'me judíopãi che'chonare ija'che i'kasi'kʉa'mʉ: —Sẽ'sevʉchi'a re'oja'che cho'onajejʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare judíopãi che'chonana'me fariseopãi. Dios chʉ'o masinata'ni chʉ'ʉni cuhejʉ Dios pa'icheja saimanejanaa'me mʉsanʉkona. Jã'ajekʉna chekʉna ũcuaja'che chʉ'ʉre cuasajʉ jovoñu chiisinata'ni jovoma'me mʉsanʉkona chʉ'ʉre cuheche'te ñani. ");
INSERT INTO coe_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ũcuachi'a va'jeva'na paache jorejʉ tʉtesõnaa'me mʉsanʉkona. Jã'aja'ñe cho'onata'ni pãipi ña, “Re'onaa'me ina”, chiapʉ chini Diore sẽni rʉa jeerʉmʉ sẽejʉ pa'inaa'me mʉsanʉkona. Jã'aja'ñe cho'onajejʉna Diopi chʉ̃'ʉʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare, sẽ'sevʉchi'a re'oja'che cho'onare. ");
INSERT INTO coe_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Sẽ'sevʉchi'a re'oja'che cho'onajejʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare judíopãi che'chonana'me fariseopãi. Jã'aja'ñe cu'ache pa'inapi si'achejña ku'ijʉ chiaraã chekʉkã'jño jẽni, pãi jainʉkore che'chome mʉsanʉkona, repanapi asa chẽaa'jʉ chini. Mʉsanʉkonapi che'chojʉna asa chẽasina mʉsanʉkonare na'a cajejaiche cu'ache pa'inajejʉ mʉsanʉkona saijatoana vati toana saijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Na'ava'napi ũcuaja'che na'ava'nani juha sacheja'che chekʉnare cu'ache che'chonajejʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. Ija'che i'kajʉ che'chonaa'me mʉsanʉkona: “Dios mamire i'kacuhejʉ Repaʉ vʉ'ere roijʉ, ‘Cho'ojanaa'me’, chiisi'ere cho'omaneni cu'ache cho'oma'me. Jã'ata'ni Dios vʉ'e pa'imajñarʉã pachokuri cho'osimajñarʉãre roijʉ, ‘Cho'ojanaa'me’, chiisi'ere cho'omaneni cu'ache cho'ome mʉsanʉkona”, chiinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ñakocaã ñamava'naja'ñe rʉa vesʉnaa'me mʉsanʉkona! ¿Keere Dios na'a rʉa chiikʉ? ¿Repaʉ vʉ'e? Jã'apãani, ¿pachokuri repavʉ'equee? Dios rʉa chiimʉ Repaʉ vʉ'e. Repa pachokuri ũcuachi'a repavʉ'e pa'ichejekʉna chiimʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ũcuachi'a ija'che i'kanaa'me mʉsanʉkona: “Mesako'a pãi Diore ĩsisimajñarʉã tʉo ʉoko'are roijʉ, mʉsanʉkona ‘Cho'ojanaa'me’, chiisi'ere cho'omaneni cu'ache cho'oma'me. Jã'ata'ni Diore ĩsisimajñarʉãre roijʉ, ‘Cho'ojanaa'me’, chiisi'ere cho'omaneni cu'ache cho'ome”, chiinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ñakocaã ñamava'naja'ñe rʉa vesʉnaa'me mʉsanʉkona! ¿Keere Dios na'a rʉa chiikʉ? ¿Repaʉ'te ĩsimajñarʉã? Jã'apãani, ¿repamajñarʉã ʉoko'a? Dios rʉa chiimʉ repaʉ'te ĩsimajñarʉã. Repako'a ũcuachi'a repaʉ'te ĩsimajñarʉã ʉoko'ajekʉna chiimʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Repako'are pãipi roijʉ i'kani repako'a tʉosi'e ũcuachi'a peore roijʉ i'kame. ");
INSERT INTO coe_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ũcuaja'che Dios vʉ'ere roijʉ i'kani repavʉ'e Pa'ikʉ'te Diore ũcuachi'a roijʉ i'kame. ");
INSERT INTO coe_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ũcuaja'che cʉnaʉmʉre roijʉ i'kani repacheja pa'isaivʉ Dios chʉ̃'ʉkʉ ñu'isaivʉ'te roijʉ ũcuachi'a repasaivʉ ñu'ikʉ'te Diore roijʉ i'kame. ");
INSERT INTO coe_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Dios chʉ̃'ʉ jo'kasi'ere cho'ojʉ ja'orʉã ãu va'isʉche maña kua'koja'orʉãre si'arʉmʉ ĩsijʉ pa'inaa'me mʉsanʉkona, Repaʉ chʉ'ʉre ĩsijʉ̃'ʉ chiisi'e. Chekʉrʉmʉ dierepaja'orʉã jñaani te'eja'orʉ ĩsinaa'me. Chekʉrʉmʉ cienrepaja'orʉã jñaani dierepaja'orʉã ĩsinaa'me. Jã'aja'ñe cho'onata'ni Dioni masi cuasama'ñe pa'ijʉ sẽ'sevʉchi'a re'oja'che cho'onajejʉ Dios chʉ̃'ʉrepache asa jachajʉ cho'omanaa'me mʉsanʉkona: re'oja'che cho'oche, chekʉnare oijʉ pa'iche, chekʉnare ũcuarepa cho'oche. Jã'aja'ñe cho'onajejʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare fariseopãina'me judíopãi che'chonare. Repa cu'amajñarʉã ũcua ĩsijʉ pa'ijʉ̃'ʉ Diore. Repaʉ chʉ̃'ʉsi'ea'me jã'a. Jã'ata'ni, “Chekʉnare re'oja'che cho'okaiche'te na'a rʉa cho'ojʉ pa'ijʉ̃'ʉ”, chiimʉ Dios. ");
INSERT INTO coe_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Na'ava'napi chekʉnani juha sacheja'che cho'ome mʉsanʉkona. Ãiñena mi'api tuãni mañaru jmava'ʉreta'ni ña mini sẽjo ãiñeja'ñe Dios rʉarepa chʉ̃'ʉma'ñere si'arʉmʉ cuasajʉ rʉa cho'ome mʉsanʉkona. Ũcuachi'a camelloji tuãni mañaru ʉjaʉ'teta'ni ña mini sẽjoma'ñe ũcuaʉ'te cuasoma'ñe teana rʉ̃osõñeja'ñe Repaʉ chʉ̃'ʉrepacheta'ni cuasamapʉ cho'oma'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Ũcuachi'a cʉnaro'rona'me cʉnare'a sẽ'sevʉãchi'a sosajʉ sa'navʉã sosama'ñeja'ñe mʉsanʉkona rekoñoã cu'ache cuasache jo'kasõmanajejʉ sẽ'sevʉchi'a re'onaja'ñe cho'ojʉ chekʉna nee jorejʉ tʉte paanaa'me mʉsanʉkona. Ũcuachi'a mʉsanʉkonare cho'oʉache ũcuaʉache cho'onaa'me. Jã'aja'ñe pa'ijʉna Diopi chʉ̃'ʉʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare fariseopãina'me judíopãi che'chonare. ");
INSERT INTO coe_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉsanʉkona fariseopãi rekoñoã cu'ache cuasanaa'me. Jã'ajekʉna mʉsanʉkona rekoñoã cu'ache cuasache'te jo'kasõjʉ̃'ʉ. Jo'kasõni re'oja'che cho'ojʉ pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","’Mʉsanʉkona judíopãi che'chonana'me fariseopãi pãiʉ'te tãsicheja catapʉ poja'che choasi'pʉre nʉkorena re'oja'che ñoñeja'ñe sẽ'sevʉchi'a re'onaja'ñe ñome. Jã'ata'ni mʉsanʉkona rekoñoã jũ'isi'kʉre tãsicoje sa'navʉ jã'jusi'ena'me tara pa'icheja'che cu'ache cuasanata'ni sẽ'sevʉchi'a re'onaja'ñe cho'ojʉna pãi ña, “Re'onaa'me ina”, chiime mʉsanʉkonare. Jã'aja'ñe cho'ojʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Sẽ'sevʉchi'a re'oja'che cho'onajejʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare judíopãi che'chonana'me fariseopãi. Ũcuachi'a aperʉmʉ Dios chʉ'o kʉasiva'nana'me Dioni cuasajʉ re'oja'che pa'isinare mʉsanʉkona aipãipi vanisõsiva'nare tãsichejña sẽ'sevʉãchi'a, re'oja'che ñochejña care'vajʉ pa'ime mʉsanʉkona, pãipi ña, “Dios chʉ'o kʉajʉ chuenisõsiva'nare oime jã'ana”, chiapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jã'aja'ñe cho'ojʉ ija'che i'kanaa'me mʉsanʉkona: “Mai aipãi pa'irʉmʉ chʉkʉnapi ja'me pani Dios chʉ'o kʉasiva'nare vanisõmanera'asinaa'me”, chiinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jã'aja'ñe i'kajʉ, “Dios chʉ'o kʉasiva'nare vanisõsina jojocojñosinaa'me chʉkʉna”, chiicheja'che kʉa jñaume mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉsanʉkona aipãi cho'osi'eja'che cu'ache cho'ojʉ pañu chiime mʉsanʉkona. Jã'aja'ñe cho'ojʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Aña pa'icheja'che rʉa cu'ache pa'inaa'me mʉsanʉkona. Jã'ajekʉna Dios mʉsanʉkonare vati toana saoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jã'aja'ñe pa'inani chʉ'ʉ mʉsanʉkonare Dios chʉ'o kʉajanana'me Repaʉ chʉ'o che'chojanana'me masinare chẽa raoja'mʉ. Jã'ata'ni mʉsanʉkona repanare cuhejʉ te'enare vanisõjʉ chekʉnare kurususẽ'veroãna jẽ'jo vẽasõjʉ jo'e chekʉnare mai judíopãi chi'ivʉ'ñana mʉva asi vaijanaa'me. Ũcuaja'che repanani cu'ache cho'oñu chini vʉ'ñajoopoã repana saisijoopoã tuha ku'ejanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jã'are cuhasõma'ñe cho'ojʉ pani, aperʉmʉ Dioni cuasajʉ re'oja'che pa'inare vanisõsi'e ro'i mʉsanʉkonapi peore ro'ijanaa'me. Chareparo re'oja'che cho'osi'kʉre Abelre vanisõsirʉmʉpi Berequías mamakʉ'te Zacaría'te, Diore ĩsimajñarʉã ʉochejana vanisõrʉmʉjatʉ'ka re'oja'che pa'isinare mʉsanʉkona aipãipi vanisõrena mʉsanʉkonapi ro'ijanaa'me repanare vanisõsi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ũcuarepaa'me jã'a. Irʉmʉ pa'inapi repana cho'osi'e peore ro'ijanaa'me mʉsanʉkona —chiisi'kʉa'mʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Mʉsanʉkona Jerusalén vʉ'ejoopo pa'ina cu'ache cho'oche'te ñakʉ rʉa sʉma'kʉ pa'imʉ chʉ'ʉ. Kurao repao chĩiva'nare kue'chaka vʉ'evʉãna soni paacheja'che re'oja'che cho'okasa chiikʉ'teta'ni cuheme mʉsanʉkona chʉ'ʉre. Mʉsanʉkona Jerusalén vʉ'ejoopo cana Repaʉ chʉ'ore mʉsanʉkonani kʉaa'jʉ chini Dios raosiva'nare cuhejʉ vanisõnaa'me. Ũcuachi'a Repaʉ chʉ'ore chʉ'vaa'jʉ chini Dios raosiva'nare cuhejʉ si'arʉmʉ catapi su'a vẽasõnaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Asarepajʉ̃'ʉ. Ijoopo mʉsanʉkona pa'ijoopo Jerusalén vʉ'ejoopo, pãipi cu'ache cho'oñu chiito ʉ̃semaneja'mʉ Dios. Ʉ̃semaʉna pãi rani peore ñañosõjanaa'me ijoopo. ");
INSERT INTO coe_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chekere kʉara. Saipi'ramʉ chʉ'ʉ chura. Sanisõʉna rʉa jeerʉmʉ ñamanejanaa'me mʉsanʉkona chʉ'ʉre. Jã'ata'ni chʉ'ʉpi jo'e chejana cajekʉna ña, “Diopi re'oja'che cho'okaaʉ ikʉre, Repaʉ Raokʉ'te”, chiijanaa'me mʉsanʉkona chʉ'ʉre —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ũcuarʉmʉ Jesús Dios vʉ'e pa'isi'kʉpi eta saiʉna chʉkʉna repaʉ neena repaʉ'te rani, —Dios vʉ'e pa'iche'te ñajʉ cutuñu —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chitena Jesús ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkona ivʉ'e Dios vʉ'e pa'iche'te peore ñajʉ cutume. Jã'ata'ni na'a pa'isirʉmʉ, catapʉã te'epʉjẽ'e chekʉpʉna'me sʉ'ima'ñe peore ñañosõjanaa'me pãi ivʉ'e —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jã'aja'ñe i'kacuha Jesús chʉkʉna repaʉ neenana'me sani Olivo aikũtina mʉni pʉʉ ñu'isi'kʉa'mʉ. Ũcuarʉmʉ chʉkʉna repaʉni chʉ'ore te'ena sẽniasañu chini raisinaa'me repaʉ'te. Rani ija'che sẽesinaa'me: —Mʉ'ʉ chʉkʉna'te kʉasi'e, ¿jeerʉmʉ cho'ojachea'che? Ũcuachi'a mʉ'ʉ jo'e raijarʉmʉna'me icheja cheja si'ajarʉmʉ tĩ'añe, ¿je'se masijanaa'ñe chʉkʉna? —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chitena Jesús i'kasi'kʉa'mʉ. —Ñarepajʉ pa'ijʉ jorena i'kache asa chẽama'ñe pa'ijʉ̃'ʉ. ¡Cacʉ'ocojñoñe! ");
INSERT INTO coe_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pãi jainʉko te'enachi'a ku'ijʉ jorejʉ chʉ'ʉni roijʉ, “Dios Raosi'kʉa'mʉ chʉ'ʉ. Cristoa'mʉ”, chiijanaa'me. Jã'aja'ñe i'kajʉ jorejʉna pãi jainʉko repanare cuasajʉ jovojanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ũcuachi'a si'achejña pãi vaiche asani kʉkʉmanejʉ̃'ʉ mʉsanʉkona. Jã'aja'ñe pa'ija'mʉ cheja si'api'rarʉmʉ. Jã'ata'ni cheja chuta'a si'amaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pãi ũcuate'echeja pa'ina chekʉchejña pa'inani sani vanisõjanaa'me. Ũcuaja'che rʉarepa asukʉ ãupi aineemaʉna pãi si'achejñarʉã ãucuhana jũnisõjanaa'me. Ũcuaja'che cheja si'achejñarʉã rʉa pi'ruja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jã'ata'ni peore jã'a na'a rʉa cu'ache cho'orʉmʉpi tĩ'api'rakʉ chareparo cho'oche'me. ");
INSERT INTO coe_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Reparʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna cuhejʉ chẽa sa chekʉnani jo'kajanaa'me, cu'ache cho'oa'jʉ chini. Jã'aja'ñe cho'ojʉ mʉsanʉkonare te'enare vanisõjanaa'me repana. Pãi si'avãjʉ mʉsanʉkonare chʉ'ʉni cuasajʉna cuhejanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Reparʉmʉ pãi jainʉko chʉ'ʉre cuasache jo'kasõ pa'ijʉ, chʉ'ʉre ũcua cuasava'nare cuhejʉ chekʉnapi repanani cu'ache cho'oa'jʉ chini rope'e chʉ̃'ʉ jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ũcuachi'a pãi jainʉko te'enachi'a ku'ijʉ, “Dios chʉ'o kʉakaikʉ'mʉ chʉ'ʉ”, chiijʉ jorejʉ pãi jainʉkore cacʉ'ojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Reparʉmʉ rʉa si'ache cu'ache cho'orʉmʉjekʉna pãi jainʉko chekʉnare cuasache jo'kasõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jã'ata'ni pãi repana jũnisõrʉmʉjatʉ'ka chʉ'ʉre masi cuasana Dios pa'ichejare ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pãi cu'ache cho'oche ũhasinare Dios chẽa paache kʉachʉ'o Repaʉ chʉ'o re'oja'che chʉ'ʉre cuasanapi ku'ijʉ chʉ'vajanaa'me, pãi si'achejña pa'ina asa chẽaa'jʉ chini. Jã'aja'ñe cho'o pi'nisirʉmʉna icheja cheja si'asõja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Dios chʉ'o aperʉmʉ kʉasi'kʉ Daniel tocha jo'kasi'e ija'che chiimʉ: Na'a pa'isirʉmʉ pãi Dios cuheche'te rupʉ tʉ̃osi'kʉni Dios vʉ'ena sa nʉko, “Dioa'mʉ ikʉ. Pojojʉ̃'ʉ ikʉre”, chiijanaa'me, chiimʉ. Repa tochasi'ere ña masijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pãipi jã'aja'ñe cho'ojʉna ñani Judea cheja pa'ina aikũjñana vʉ'vʉ katisõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pãi ũcuaʉana repana vʉ'ña ve'koroãre pani cu'amajñarʉãre miñu chini kakama'ñe teana vʉ'vʉsõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ũcuaja'che pãi chiño saisina pani repana vʉ'ña paache'te cu'amajñarʉãre miñu chini co'ima'ñe teana ũcuachejapi vʉ'vʉsõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Reparʉmʉ romiva'nare chĩi sʉ'iva'nana'me oje chũsava'nare rʉa vesache cu'ache pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dioni rʉa sẽejʉ pa'ijʉ̃'ʉ, reparʉmʉpi pʉaumucusena jã'apãani okorʉmʉna tĩ'amanea'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Reparʉmʉ tĩ'aru mamarʉmʉpi pi'ra irʉmʉjatʉ'ka pãi jmamakarʉjẽ'e ñama'ñepi cu'a rʉa cu'acheji pa'ija'mʉ. Ũcuachi'a reparʉmʉ cho'osi'e cu'a jo'e ti'jñemaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Repa cu'ache pa'irʉmʉre Diopi ʉ̃semaʉna na'a jeerʉmʉ cu'ache pa'ito pãi te'eʉjẽ'e jujama'ñe cho'osõra'ame. Jã'ata'ni Diopi Repaʉ chẽa paanani oiʉ ʉ̃sekʉna cu'a rʉa jeerʉmʉ pa'imaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Reparʉmʉ pãi mʉsanʉkonare ija'che i'kajanaa'me: “Rani ñajʉ̃'ʉ. Dios Raosi'kʉ Cristo ichejare pa'imʉ”. Jã'apãani, “Sani ñajʉ̃'ʉ. Dios Raosi'kʉ jeechejare pa'imʉ”, chiijanaa'me. Pãipi jã'aja'ñe i'kato asa jachajʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Reparʉmʉ pãi te'ena ku'ijʉ jorejʉ, “Dios Raosi'kʉa'mʉ chʉ'ʉ. Cristoa'mʉ”, chiijanaa'me. Chekʉna, “Dios chʉ'o kʉakainaa'me chʉkʉna”, chiijanaa'me. Jã'aja'ñe jorejʉ i'kajʉ Dios cho'ocheja'chere cho'o ñojanaa'me repana, Dios chẽa paanapi ña Repaʉ'te cuasache'te jo'kasõ ũcuanani jovo repana chʉ̃'ʉñe'te cho'ojʉ paapʉ chini. Jã'ata'ni Dios neenapi ñarepajʉ pa'imaneni repana jorena i'kachʉ'o asa cuasajʉ jovojanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mʉsanʉkonare chʉ'ʉ repana cho'ojachere masia'jʉ chini irʉmʉna kʉamʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jã'ajekʉna pãiʉ ũcuaʉakʉji mʉsanʉkonani, “Rani ñajʉ̃'ʉ. Dios Raosi'kʉ pãi peochejare pa'imʉ”, chiito sani ñamanejʉ̃'ʉ. Ũcuachi'a chekʉnapi, “Rani ñajʉ̃'ʉ. Dios Raosi'kʉ jeechejare kati pa'imʉ”, chiito cuasamanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cʉnaʉmʉpi oko fe'neni ʉ̃sʉʉ mʉikã'kopi ʉ̃sʉʉ na'ikã'kojatʉ'ka peore miañe fe'ne chʉvokʉna ñame pãi. Chʉ'ʉ ũcuaja'che Dios Raosi'kʉ icheja cheja jo'e cajerʉmʉ pãi ũcuanʉko ñajʉ'te cajeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cu'ava'nare jũni jã'jusiva'nare jñaa caje chi'ime vacho —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ũcuarʉmʉ Jesús chʉkʉna'te jo'e i'kasi'kʉa'mʉ. —Repa cu'ache cho'o pi'nisirʉmʉ ʉ̃sʉʉ miamaneja'mʉ. Pãimiaʉ ũcuaja'che miamaneja'mʉ. Cʉnaʉmʉ pa'ina ma'jñoko chejana tuã'tuasõjanaa'me. Ũcuachi'a cʉnaʉmʉ pa'imajñarʉã ñʉ'kueja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Reparʉmʉ pãi si'achejñarʉã pa'ina chʉ'ʉre cuhena cʉnaʉmʉ cho'oche'te ña, “Dios Raosi'kʉ jo'e cajepi'racosomʉ”, chini kʉkʉcajejani rʉa oijanaa'me. Jã'aja'ñe cho'otona chʉ'ʉ Dios Raosi'kʉ peore Masiʉji, rʉa re'oja'che ñoʉ ko'sija'iʉ cʉnaʉmʉpi pãi ũcuanʉko ñajʉ'te pikona'me cajeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Reparʉmʉ trompetavʉ rʉa asoche juhitona chʉ'ʉ neenare ángeles chʉ̃'ʉ saoja'mʉ chʉ'ʉ. Chʉ̃'ʉʉna sani ku'ijʉ chʉ'ʉ chẽa paanare cheja si'acheja pa'inare ʉ̃sʉʉ mʉikã'ko sʉripʉ cakã'ko, co'covʉ cakã'ko pa'inana'me ʉ̃sʉʉ na'ikã'ko pa'inare ra chi'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Chura higoñʉ pa'iche'te cuasajʉ̃'ʉ. Higoñʉ karʉã ã'jikarʉã carũni ja'o ma'mañe ñani, “Ʉ̃sʉrʉmʉ tĩ'api'ramʉ ie”, chiime mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ũcuaja'che chʉ'ʉ chura kʉasi'epi tĩ'akʉna ñani, “Jesús Dios Raosi'kʉ chejana jo'e cajepi'ramʉ”, chiijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mʉsanʉkona jojosina chuta'a jũnisõmarʉmʉna chʉ'ʉ kʉasi'e peore ti'jñeja'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cʉnaʉmʉna'me cheja si'asõja'mʉ. Chʉ'ʉ chʉ̃'ʉ jo'kasi'eta'ni si'asõma'ñe ũcua pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pãi te'eʉjẽ'e masima'me chʉ'ʉ kʉasi'e pa'ijarʉmʉ. Cʉnaʉmʉ pa'ina ángeles ũcuachi'a vesʉme. Chʉ'ʉ Dios Mamakʉ ũcuachi'a vesʉmʉ. Ja'kʉchi'a masimʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Chʉ'ʉ Dios Raosi'kʉ jo'e cajeumucuse tĩ'api'rarʉmʉ Noé pa'irʉmʉ pa'isina pa'isi'eja'che cu'ache pa'ijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Reparʉmʉ pãi chuta'a cheja peore ko'sa mevosõmarʉmʉ Dioni cuasamapʉ ãu ãijʉ, cono ũkujʉ, romi vejajʉ, repanare ʉache cho'ojʉ paniasome, Noé choovʉ ʉjavʉ kakaumucusejatʉ'ka. ");
INSERT INTO coe_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jã'ata'ni repana, “Cu'ache ti'jñeja'mʉ maire”, chiima'ñe pa'irʉmʉna okopi ra ko'saʉna peore runisõasome. Ũcuaja'che pãi chʉ'ʉ Dios Raosi'kʉ raijache cuasamarʉmʉna jo'e raija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Reparʉmʉ ángeles caje chekʉrʉmʉ ʉmʉpãi te'eka'chapana chio ũcuate'echio pa'inare te'eʉ'te sajʉ chekʉni jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chekʉrʉmʉ romi te'eka'chapana ũcuate'echeja ãu toanare te'eo'te sajʉ chekoni jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chʉ'ʉ mʉsanʉkonare paakʉ raijarʉmʉ vesʉme. Jã'ajekʉna ñarepajʉ pa'ijʉ chʉ'ʉni cha'ajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iere asa chẽajʉ̃'ʉ mʉsanʉkona. Pãiʉ vʉ'e paakʉ ñaaʉ rairʉmʉ masini pẽ'jemʉ, ñaaʉ kakache'te ʉ̃sera chini. ");
INSERT INTO coe_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mʉsanʉkona chʉ'ʉ raijache cuasamarʉmʉna icheja cheja jo'e cajeja'mʉ chʉ'ʉ, Dios Raosi'kʉ. Jã'ajekʉna vʉ'e paakʉ ñaaʉ'te pẽ'jeñeja'ñe chʉ'ʉ cajejachere pẽ'jejʉ mʉsanʉkona rekoñoã re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ũcuarʉmʉ Jesús chʉkʉnani chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Cho'oche cho'okaikʉ rũhiñe cuasakʉjekʉ repaʉ'te paakʉ chʉ̃'ʉ jo'kasi'e re'oja'che cho'okaiʉ paniasomʉ. Jã'aja'ñe cho'okʉna repaʉ'te paakʉ so'ona saipi'rakʉ ũcuaʉni cheke cho'oche chʉ̃'ʉ jo'kaasomʉ, chekʉnani repaʉ'te cho'oche cho'okainani repana chiiche'te ãure si'aumucujña ĩsikaiʉ paaʉ chini. Jã'aja'ñe jo'ka so'ona sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Sani pa'isi'kʉpi na'a pa'isirʉmʉna jo'e rani ñato repaʉ'te cho'oche cho'okaiva'ʉ, repaʉ chʉ̃'ʉ jo'kasi'e re'oja'che cho'okaiʉ paniasomʉ. Jã'aja'ñe re'oja'che cho'okaisi'ere co'i ña repaʉ'te paakʉ pojokʉ repaʉ paache peore ũcuaʉni jo'kaasomʉ, chʉ̃'ʉkaiʉ paaʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Jã'ata'ni repaʉji cu'ache cuasakʉ ija'che cho'oru rʉa cu'ache ti'jñera'amʉ repaʉ'te, “Chʉ'ʉre paakʉ, so'o saisi'kʉ pesa raimaneja'mʉ”, chini repaʉ'te ja'me cho'oche cho'okainare vaiʉ, cono jũ'inana'me jovo repaʉ'te paakʉ nee ãu rʉa ãiʉ conore ũkukʉ pa'ito. ");
INSERT INTO coe_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ũcuachi'a repaʉ'te paakʉ raijarʉmʉjẽ'e cuasama'ñe pa'iʉ repaʉjẽ'e vesʉrʉmʉna raira'amʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jã'aja'ñe cho'okʉ pa'ikʉni rani ña repaʉ'te paakʉ rʉa pe'rukʉ rʉa vani pi'ni cu'achejana saora'amʉ repaʉ'te, sẽ'sevʉchi'a re'oja'che cho'onare saochejana. Saoʉna ũcuachejare pa'iʉ rʉa oiʉ cõjire asoche ãiʉ rʉa chʉova'ʉ pa'ira'amʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ũcuarʉmʉ Jesús chʉkʉnani jo'e chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Pãi chʉ'ʉ jo'e raijachere cha'ajʉ repana rekoñoã re'ojarekoñoã care'vasinare chʉ'ʉ cho'ojache ija'chea'me: Pãiʉ romi vejajaʉ chekʉcheja sani pa'isi'kʉpi jo'e raiʉna romichĩi dierepana repaʉni tijña pojoñu chini ʉopʉã u'chape'epi miapʉã mini eta mʉaasome. (Aperʉmʉ judío romichĩi, romi vejapi'ranare jã'aja'ñe cho'oasome.) ");
INSERT INTO coe_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Repana romichĩi, cincorepana rũhiñe cuasamasina paniasome. Chekʉna cincorepana rũhiñe cuasavesʉasome. ");
INSERT INTO coe_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Repana romichĩi rũhiñe cuasavesʉna ʉopʉã mini sanata'ni u'chape'e repapʉã pa'iche si'aʉna jo'e ro'vejache samaneasome. ");
INSERT INTO coe_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Chekʉnata'ni rũhiñe cuasamasinajejʉ ʉopʉã mini u'chape'e repapʉã pa'iche si'aʉna jo'e ro'vejache churura'pʉrʉãna ro've saasome. ");
INSERT INTO coe_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sani repana romichĩi romi vejajaʉpi pesa raimaʉna cha'a ca'na ũcuanʉko ʉme kãnisõasome. ");
INSERT INTO coe_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ñamirepana pãi i'kache ija'che chiiche'te asaasome repana romichĩi: “Romi vejajaʉ ranicuhamʉ. Sani tijña pojojʉ̃'ʉ repaʉ'te”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jã'aja'ñe i'kache'te asa repana romichĩi, ũcuanʉko vʉni ʉopʉã care'vaasome. ");
INSERT INTO coe_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ũcuarʉmʉ rũhiñe cuasavesʉna chekʉnani masinani ija'che i'kaasome: “Chʉkʉna'te ʉopʉã chachapi'ramʉ. Mʉsanʉkona paache u'chape'e jmanʉkorʉã ĩsijʉ̃'ʉ chʉkʉna'te; ro'veñu”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chitena rũhiñe cuasamasina i'kaasome. “Pãame. Chʉkʉnapi ĩsisõru u'chape'e karasõja'mʉ maire ũcuanʉkore. U'chape'e ĩsichejana sani mʉsanʉkona chiiche koojʉ̃'ʉ. Jã'aja'ñe cho'oto na'a re'omʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Chitena repana u'chape'e kooñu chini saisirʉmʉna romi vejajaʉ raniasomʉ. Ũcuarʉmʉ romichĩi rũhiñe cuasamasina repaʉ'te tijña pojojʉ ũcuaʉna'me vʉ'ena kakaasome repaʉ romi vejache'te ñajʉ pojoñu chini. Kakarena repavʉ'e jatisa'aro jeosõasome. ");
INSERT INTO coe_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Repana kakasõsirʉmʉna romichĩi chekʉna u'chape'e kooñu chini saisina ũcuavʉ'ena rani tĩ'a ija'che i'kaasome repaʉ'te: “Jatisa'aro vatakaijʉ̃'ʉ chʉkʉna'te; kakañu”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jã'aja'ñe i'kanareta'ni ija'che i'kaasomʉ repaʉ: “Mʉsanʉkonare vesʉkʉ'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mʉsanʉkona ũcuaja'che chʉ'ʉ jo'e raijarʉmʉ vesʉnajejʉ ñarepajʉ pa'ijʉ, romichĩi cuasamasisina cho'osi'eja'che peore re'oja'che care'va pa'ijʉ cha'ajʉ̃'ʉ chʉ'ʉre —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ũcuarʉmʉ Jesús chʉkʉnani jo'e chʉ'vakʉ ija'chere cuasakʉ kʉasi'kʉa'mʉ: —Dios chʉ̃'ʉ jo'kasi'e masi cho'osinana'me masi cho'omanare Repaʉ cho'ojache ija'chea'me: Pãiʉ chekʉchejana saipi'rakʉ repaʉ'te cho'oche cho'okainare soni rao repanare te'enarechi'a kuri ĩsiasomʉ, ũcuapi cho'oche'te cho'oa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Soni te'eʉ'te cinco milrepare're kurire're ĩsiasomʉ, chekʉni dos milrepare're, jo'e chekʉni milrepare're. Na'a rʉa paamasikʉ'te na'a rʉa ĩsi, chekʉnare na'a vesʉnare jmanʉkorʉã ĩsi sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Repaʉ jo'ka sanisõsirʉmʉ repaʉ'te cho'oche cho'okaikʉ kuri cinco milrepare're koosi'kʉ põsere koo ĩsikʉ jo'e cinco milrepare're kooasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chekʉ dos milrepare're koosi'kʉ ũcuaja'che põsere koo ĩsikʉ jo'e dos milrepare're kooasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jã'ata'ni chekʉ milrepare're koosi'kʉ sani chejana coje ũni repaʉ'te paakʉ nee kurire're ũcuacojena chave paaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Rʉa jeerʉmʉ sani pa'isi'kʉpi repanare paakʉ co'i ũcuanani soapʉ chini chʉ̃'ʉ saoasomʉ, repaʉ ĩsisi'ere kurire repana paajʉ cho'osi'ere kuẽkue ña masira chini. ");
INSERT INTO coe_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sotena cinco milrepare're koosi'kʉ charo rani repaʉ'te paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre paakʉ, mʉ'ʉ chʉ'ʉre ĩsisire'repi põsere koo ĩsikʉ jo'e cinco milrepare're koosi'kʉa'mʉ chʉ'ʉ”, chini, repaʉ'te kurire're diez milrepare're ĩsiasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chikʉna repaʉ'te paakʉ i'kaasomʉ. “Re'omʉ jã'a. Cho'oche rʉa re'oja'che cho'okaisi'kʉa'mʉ mʉ'ʉ. Kuri ka'charʉ koosi'kʉta'ni re'oja'che cho'osi'kʉjekʉna mʉ'ʉre jo'e na'a rʉa jo'kaja'mʉ chʉ'ʉ. Chʉ'ʉ pa'icheja'che pojokʉ pa'ijʉ̃'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Repaʉ cho'ocuhasirʉmʉ chekʉ dos milrepare're koosi'kʉ rani repaʉ'te paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre paakʉ, mʉ'ʉ chʉ'ʉre ĩsisire'repi põsere koo ĩsikʉ jo'e dos milrepare're koosi'kʉa'mʉ chʉ'ʉ”, chini repaʉ'te cuatro milrepare're ĩsiasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chikʉna repaʉ'te paakʉ i'kaasomʉ. “Re'omʉ jã'a. Cho'oche rʉa re'oja'che cho'okaisi'kʉa'mʉ mʉ'ʉ. Kuri ka'charʉ koosi'kʉta'ni re'oja'che cho'osi'kʉjekʉna mʉ'ʉre jo'e na'a rʉa jo'kaja'mʉ chʉ'ʉ. Chʉ'ʉ pa'icheja'che pojokʉ pa'ijʉ̃'ʉ mʉ'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Jã'ata'ni chekʉ kurire're milrepare're koosi'kʉ rani repaʉ'te paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre paakʉ, mʉ'ʉ pa'iche masimʉ chʉ'ʉ. Mʉ'ʉre cho'oche cho'okainare oima'kʉa'mʉ mʉ'ʉ. Chekʉna cho'oche cho'o koosi'e kuri tʉasõkʉ'mʉ mʉ'ʉ. Ũcuaja'che ãu chekʉna tãsi'e tʉasõkʉ'mʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jã'ajekʉna jã'are cuasakʉ vajʉchʉkʉ mʉ'ʉ chʉ'ʉre ĩsisire're kurire're chejana coje ũni chave paakʉ ũcuare're co'chamʉ chʉ'ʉ mʉ'ʉre”, chini repaʉ'te kurire're milrepare're ĩsiasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Ĩsiʉna repaʉ'te paakʉ i'kaasomʉ. “Rʉa cu'akʉji ñameʉ'mʉ mʉ'ʉ. Chʉ'ʉ pãi oima'ñena'me chekʉna cho'oche cho'o koosi'e kuri tʉachena'me chekʉna tãsi'e ãu chʉ'ʉ tʉasõñe masikʉta'ni, ¿je'se pa'iʉna mʉ'ʉ chʉ'ʉ ĩsisi'e kurire're kuri vʉ'ena sa jo'kamaneʉ? Sa jo'karu rani na'a rʉa koora'amʉ chʉ'ʉ. Jã'aja'ñe cho'omaneʉna pe'rukʉ mʉ'ʉre cu'ache cho'oja'mʉ chʉ'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Chini chekʉnare repacheja pa'inare i'kaasomʉ repaʉ. “Pãiʉ ũcuaʉache'te koo masi paakʉ ũcuare paakʉta'ni na'a rʉa koo karama'ñe paaja'mʉ. Jã'ata'ni jmanʉkorʉ koosi'kʉpi masi paama'kʉ repaʉ paache rʉa jmanʉkorʉta'ni peore tʉasõcojñoja'mʉ. Jã'ajekʉna ikʉre kurire're milrepare're tʉa chekʉni, diez milrepare're paakʉni ĩsijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Repaʉ paasi'e tʉa chekʉni ĩsicuha ve'sena chijachejana saojʉ̃'ʉ repaʉ'te, chʉ'ʉre cho'oche re'oja'che cho'okaimanesi'kʉre. Ũcuachejare pa'iʉ chʉova'ʉ oiʉ cõjire asoche ãiʉ paaʉ”, chiniasomʉ repaʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Chʉ'ʉ Dios Raosi'kʉ re'oja'che ñoʉ ko'sija'iʉ chʉ'ʉ neena ángelena'me ũcuanʉko chejana jo'e caje pãi chʉ̃'ʉkʉ ñu'isaivʉ'te ñu'iʉ pãi ũcuanʉko re'oja'che cho'osi'ena'me cu'ache cho'osi'e ro'iche chʉ̃'ʉja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ñu'iʉ chʉ̃'ʉkʉna pãi ũcuanʉko rani chʉ'ʉ ti'jñeñena chi'ijanaa'me. Ũcuanʉko rani chi'irena oveja kuirakʉ ovejava'nana'me cabrava'nare te'ekuanuchi'a jña'nuñeja'ñe chʉ'ʉ Dios Raosi'kʉ repanare pãi re'oja'che pa'inana'me cu'ache pa'inare te'ekuanuchi'a jña'nuja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Re'oja'che pa'inare chʉ'ʉ ʉjajʉ̃tʉ cakã'kona raiche chʉ̃'ʉja'mʉ chʉ'ʉ. Cu'ache pa'inareta'ni chʉ'ʉ kã'kojʉ̃tʉ cakã'kona raiche chʉ̃'ʉja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chʉ̃'ʉ pi'ni chʉ'ʉ Pãi Ũcuanʉkore Chʉ̃'ʉkʉ ʉjajʉ̃tʉ cakã'ko pa'inare ija'che i'kaja'mʉ: “Raijʉ̃'ʉ mʉsanʉkona, chʉ'ʉ Ja'kʉ Dios re'oja'che cho'okaicojñona. Mʉsanʉkonare chʉ'ʉ neenani jo'kara chini chuta'a cheja cho'omarʉmʉna Dios care'vasichejare Repaʉ pa'ichejare sani re'oja'che pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chʉ'ʉre ãucuhato ãu ãusinaa'me mʉsanʉkona. Ũcuachi'a chʉ'ʉre okoʉato oko ũkuasinaa'me. Ũcuachi'a chʉ'ʉpi ku'iʉ kãiñe peoto chʉ'ʉre kãiñe jo'kasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ũcuaja'che chʉ'ʉpi kãña peoto chʉ'ʉre kãña rupʉ ĩsisinaa'me. Ũcuaja'che chʉ'ʉ jũ'ito kuirasinaa'me. Ũcuaja'che pãi cu'ache cho'onare chẽa cuaovʉ'e chʉ'ʉ pa'ito rani ñasinaa'me mʉsanʉkona chʉ'ʉre”, chiija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jã'aja'ñe i'kaʉna asa repana re'oja'che cho'osina chʉ'ʉre ija'che sẽniasajanaa'me: “Chʉkʉna'te Paakʉ, mʉ'ʉre chʉkʉna, ¿jeerʉmʉ ãucuhakʉni ãu ãure? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre okoʉakʉni oko ũkuare? ");
INSERT INTO coe_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre kãiñe peokʉni kãiñe jo'kare? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre kãñare peokʉna kãña ĩsire? ");
INSERT INTO coe_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre jũ'ikʉni kuirare? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre pãi cu'ache cho'onare chẽa cuaovʉ'e pa'ikʉni mʉa ñare?”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chitena chʉ'ʉ Pãi Ũcuanʉkore Chʉ̃'ʉkʉ ija'che i'kaja'mʉ repanare: “Chʉ'ʉ neenare rʉa vesʉva'narejẽ'e mʉsanʉkona re'oja'che cho'okaisi'e peore chʉ'ʉre cho'okaisi'eja'chea'me. Ũcuarepaa'me jã'a”, chiija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Repanare i'kacuha chʉ'ʉ Pãi Ũcuanʉkore Chʉ̃'ʉkʉ kã'kojʉ̃tʉ cakã'ko pa'inare ija'che i'kaja'mʉ: “Mʉsanʉkona, Diore cu'ache cho'ocojñopi'rana chʉ'ʉre ja'me pa'imanejʉ̃'ʉ. Vati toana si'arʉmʉ uukʉ pa'itoana saijʉ̃'ʉ, vati ai repaʉ neenana'me paaʉ chini Dios jo'kasitoana. ");
INSERT INTO coe_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chʉ'ʉre ãucuhato ãu ãumanesinaa'me mʉsanʉkona. Ũcuachi'a chʉ'ʉre okoʉato oko ũkuamanesinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ũcuachi'a chʉ'ʉpi ku'iʉ kãiñe peoto chʉ'ʉre kãiñe jo'kamanesinaa'me. Ũcuachi'a chʉ'ʉpi kãña peoto chʉ'ʉre kãña rupʉ ĩsimanesinaa'me. Ũcuachi'a chʉ'ʉpi jũ'ito kuiramanesinaa'me. Ũcuachi'a chʉ'ʉpi pãi cu'ache cho'onare chẽa cuaovʉ'e pa'ito rani ñamanesinaa'me mʉsanʉkona”, chiija'mʉ chʉ'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chikʉna repana chʉ'ʉre ija'che sẽniasajanaa'me: “Pãi Ũcuanʉkore Paakʉ, ¿jeerʉmʉ chʉkʉna mʉ'ʉre ãucuhakʉni ãu ãumanere? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre okoʉakʉni oko ũkuamanere? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre kãiñe peokʉni kãiñe jo'kamanere? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre kãña peokʉni kãña ĩsimanere? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre jũ'ikʉni kuiramanere? Ũcuachi'a, ¿jeerʉmʉ chʉkʉna mʉ'ʉre pãi cu'ache cho'onare chẽa cuaovʉ'e pa'ikʉni mʉa ñamanere?”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chitena chʉ'ʉ Pãi Ũcuanʉkore Chʉ̃'ʉkʉ ija'che i'kaja'mʉ repanare: “Chʉ'ʉ neenare rʉa vesʉva'narejẽ'e mʉsanʉkona te'echojẽ'e re'oja'che cho'okaimanesi'e chʉ'ʉre re'oja'che cho'okaimanesi'eja'chea'me. Ũcuarepaa'me jã'a”, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jã'aja'ñe i'kacuha chʉ'ʉpi chʉ̃'ʉʉna repana re'oja'che pa'imanesi'e ro'i vati toana sani si'arʉmʉ uujʉ pa'ijanaa'me. Re'oja'che pa'isinata'ni Dios pa'ichejare sani si'arʉmʉ re'oja'che pa'ijanaa'me —chiiʉ chʉ'vasi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Repa peore i'ka pi'nisirʉmʉ Jesús chʉkʉna'te repaʉ neenare i'kasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pã saʉma'ñe ãirʉmʉ, pascua tĩ'añe ka'chaumucujña karache masime mʉsanʉkona. Ũcuarʉmʉna pãi chʉ'ʉre Dios Raosi'kʉre chẽa sa jo'kajanaa'me, kurususẽ'verona jẽ'jo vẽasõa'jʉ chini —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Reparʉmʉ judío phairipãi chʉ̃'ʉnana'me judío aina, judío phairi ai Caifás vʉ'ena chi'iasome. ");
INSERT INTO coe_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chi'i repana, “Jesuni i'kajʉ cacʉ'o repaʉji cu'ache i'kaʉna chẽa sa vanisõñe'te chʉ̃'ʉñu”, chini repana cho'ojache care'vaasome. ");
INSERT INTO coe_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jã'aja'ñe cho'oñu chiinata'ni ija'che i'kaasome: —Pascuarʉmʉna repaʉ'te chẽañe chʉ̃'ʉmaneñu. Jã'arʉmʉna cho'oru pãi si'achejña raisina jainʉko asa pe'rujʉ cavajanaa'me —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jã'a cho'oto Jesús Betania vʉ'ejoopo'te pa'isi'kʉa'mʉ, Simón asi ravʉ paakʉ chiicojñokʉ vʉ'ere. ");
INSERT INTO coe_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Reparʉmʉ romio, okoma'ñatʉopʉ alabastroji cho'ositʉopʉ rʉa ro'itʉopʉ cãjiko mʉta ũcuavʉ'ena kaka, Jesure mesako'a ãu ãiʉ ñu'ikʉni repaʉ sĩjopʉna okoma'ña rosi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Jã'aja'ñe cho'oona ña chʉkʉna repaʉ neena pe'rujʉ ija'che i'kasinaa'me: —¿Je'se pa'iʉna iko jã'ara'ka rurepapʉ jañosõo, ĩsisõ kuri rʉa koo chʉova'na pa'iva'nani ĩsirʉja'chere? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jã'aja'ñe i'kajʉna asa Jesús chʉkʉna'te ija'che i'kasi'kʉa'mʉ: —Iko cho'oche ñajʉ ke'remanejʉ̃'ʉ mʉsanʉkona. Repao chʉ'ʉre okoma'ña rosi'e re'oja'chere cho'osi'koa'mo iko. ");
INSERT INTO coe_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pãi chʉova'na pa'ina mʉsanʉkonana'me si'arʉmʉ pa'ijanaa'me. Jã'ajekʉna repanare si'arʉmʉ re'oja'che cho'okaijʉ pa'ire'oja'mʉ mʉsanʉkonare. Chʉ'ʉta'ni mʉsanʉkonare si'arʉmʉ ja'me pa'imaneja'mʉ. Jã'ajekʉna chʉ'ʉre si'arʉmʉ jã'aja'ñe cho'okaicu'aja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iko chʉ'ʉre tãcojñopi'rakʉni okoma'ñapi ro care'vakaisi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cheja ũcuaʉachejña Dios chʉ'o re'oja'che chʉ'vachejña iko chʉ'ʉre cho'osi'e ũcuaja'che kʉajanaa'me, pãipi repao re'oja'che cho'osi'ere cavesʉma'ñe cuasaa'jʉ chini. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ũcuarʉmʉ chʉkʉna Jesús neena docerepana pa'ikʉji te'eʉ Judas Iscariote, judío phairipãi chʉ̃'ʉna pa'ivʉ'ena mʉa ");
INSERT INTO coe_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ija'che i'kaasomʉ repanare: —Chʉ'ʉpi, mʉsanʉkonani Jesuni jo'kato, ¿jeenʉko ro'iche mʉsanʉkona chʉ'ʉre? —chiniasomʉ. Chikʉna, Jesure jo'kajache ro'i, treintarepare're kurire're kuẽkue ĩsiasome repana. ");
INSERT INTO coe_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ĩsirena koo repaʉ Judas ũcuarʉmʉ teana Jesús pa'ichejana sani pẽ'je ñakʉ paniasomʉ, pãi jainʉko peorʉmʉna repaʉni jo'kara chini. ");
INSERT INTO coe_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ũcuarʉmʉ chʉkʉna Jesús neena judíopãi pã saʉma'ñe ãirʉmʉ pascua charo cho'oumucusepi tĩ'aʉna Jesure sani ija'che sẽniasasinaa'me: —¿Jeechejana mai pascuarʉmʉ ãijañe ãu care'vajaijʉ̃'ʉ chiikʉ mʉ'ʉ chʉkʉna'te? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chitena Jesús i'kasi'kʉa'mʉ. —Vʉ'ejoopona sani pãiʉ'te repajoopo cakʉre tijña ija'che kʉajʉ̃'ʉ: “Masiʉ mʉ'ʉre ija'che chiiʉ chʉ'o raomʉ: ‘Chʉ'ʉre cu'ache cho'ojarʉmʉ tĩ'acuhaja'mʉ. Pascua ãiñe ãu chʉ'ʉ neenana'me mʉ'ʉ vʉ'ena sani ãija'mʉ chʉ'ʉ’, chiisi'kʉa'mʉ Jesús”, chiijʉ̃'ʉ repaʉ'te —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ũcuarʉmʉ te'eka'chapana repaʉ neena sani Jesús i'kasi'e pãiʉ'te kʉa pi'ni ũcuaʉ vʉ'ena kaka pascuarʉmʉ ãijañe ãu care'vaasome. ");
INSERT INTO coe_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na'icuhasirʉmʉ Jesús chʉkʉna repaʉ neena docerepanana'me sani ãure ãiʉ ñu'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ãu ãiʉ ñu'ikʉji Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Mʉsanʉkonare ja'me pa'ikʉ te'eʉ chʉ'ʉre cuhenani jo'kaja'mʉ, repanapi chʉ'ʉni cu'ache cho'oa'jʉ chini. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jã'aja'ñe i'kaʉna asa chʉkʉna repaʉ neena sʉma'ñe cuasajʉ te'enachi'a ija'che sẽniasasinaa'me repaʉ'te: —Chʉkʉna'te Paakʉ, ¿chʉ'ʉa'che mʉ'ʉre jã'aja'ñe jo'kajaʉ? —chiisinaa'me chʉkʉna ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chitena Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉre cu'ache cho'ojaʉ, chʉ'ʉna'me ũcuate'ere'ava cʉnare'ava pãpʉ chũ'sekʉ pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chʉ'ʉre Dios Raosi'kʉre, Repaʉ chʉ'o aperʉmʉ tocha jo'kasi'e kʉache ũcuarepa cu'ache ti'jñeja'mʉ. Jã'ata'ni chʉ'ʉni vanisõa'jʉ chini jo'kasi'kʉre na'a rʉa cu'ache ti'jñeja'mʉ. Repaʉji aineemaneru na'a re'ora'amʉ repaʉ'te —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ũcuarʉmʉ Judas cu'ache cho'ojanare Jesure jo'kajaʉ ija'che sẽesi'kʉa'mʉ repaʉ'te: —Masiʉ, mʉ'ʉ i'kasi'kʉ, ¿chʉ'ʉa'che? —chiisi'kʉa'mʉ. Chikʉna Jesús, —Jʉ̃jʉ, ũcuaʉ'mʉ mʉ'ʉ —chiisi'kʉa'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chuta'a ãu ãiʉ ñu'ikʉji Jesús pãpʉ mini Diore, “Re'orepamʉ”, chini chʉkʉnani repaʉ neenani tʉ'se ĩsikʉ ija'che i'kasi'kʉa'mʉ: —Ie pã chʉ'ʉ ca'nivʉ'me. Ãijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Chini conoro'rova mini Dioni, “Re'orepamʉ”, chini chʉkʉnani repaʉ neenani ĩsikʉ ija'che i'kasi'kʉa'mʉ: —Ie ʉche cono chʉ'ʉ chiea'me. Mʉsanʉkona ũcuanʉko ũkujʉ̃'ʉ iro'rova. Pãi ũcuanʉko cu'ache cho'oche'te jũni ro'ikasa chini chuenisõja'mʉ chʉ'ʉ. Jã'aja'ñe cho'oche chʉ'ʉ chiepi menisõʉna Dios mamare, “Ija'che cho'oñu”, chiisi'ere cho'okʉ mʉsanʉkona cu'ache cho'oche tʉnosõ jo'e cuasama'ñere cuasajʉ chi'i iere ʉche conore ũkujʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jã'ata'ni mʉsanʉkonare ija'che i'kamʉ chʉ'ʉ: Chʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉjatʉ'ka ʉche cono jo'e ũkumaneja'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ũcuarʉmʉ chʉkʉna Jesuna'me Dioni pojojʉ uja pi'ni Olivo aikũtina saisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Repacheja sani tĩ'asirʉmʉ Jesús ija'che i'kasi'kʉa'mʉ chʉkʉna'te: —Iñami mʉsanʉkona ũcuanʉko chʉ'ʉni masi cuasamapʉ chʉ'ʉni cu'ache cho'ojʉna vajʉchʉjʉ jo'ka sanisõjanaa'me. Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Ovejava'na repanare kuirakʉni vanisõrena vajʉchʉjʉ te'enachi'a vʉ'vʉsõjanaa'me, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jã'ata'ni chʉ'ʉ jũni vajʉrani Galilea chejana mʉsanʉkonare charo saija'mʉ —chiisi'kʉa'mʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chikʉna Pedro i'kasi'kʉa'mʉ repaʉ'te. —Chekʉna ũcuanʉko mʉ'ʉre jo'kasõto chʉ'ʉta'ni mʉ'ʉre jmamakarʉjẽ'e jo'kamaneja'mʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chikʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Iñami chuta'a kura chu'ima'tona pãipi sẽejʉna choteñoã, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiija'mʉ mʉ'ʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chikʉna Pedro jo'e i'kasi'kʉa'mʉ. —Pãipi chʉ'ʉni vanisõñu chiitojẽ'e, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiima'ñe mʉ'ʉna'me chuenisõja'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. Chikʉna asa chʉkʉna ũcuanʉko Jesús neena ũcuaja'che i'kasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jã'aja'ñe i'ka pi'ni Jesús, chʉkʉna repaʉ neenana'me Getsemaní chiichejana sani tĩ'a ija'che i'kasi'kʉa'mʉ chʉkʉna'te: —Ichejare ñu'ijʉ cha'ajʉ̃'ʉ mʉsanʉkona, chʉ'ʉ na'a jã'achejarʉna sani Ja'kʉre sẽni pi'niñetʉ'ka —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chini repanare jo'ka Pedro'mʉ Zebedeo mamachĩi ka'chanare sa, sʉma'ñe cuasakʉ oniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jã'aja'ñe oiʉ repanare ija'che i'kaasomʉ repaʉ: —Chʉ'ʉ rekocho jũ'iʉache rʉa sʉma'mʉ chʉ'ʉre. Mʉsanʉkona ichejana canʉka kãima'ñe chʉ'ʉna'me pa'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chini te'eʉ jmachenerʉ sani ro're ñu'iʉ meñe sime chejana chia tĩ'iʉ Dioni ija'che sẽniasomʉ repaʉ: —Ja'kʉ, mʉ'ʉre ʉ̃seʉato pãi chʉ'ʉre cu'ache cho'opi'rache ʉ̃sekaijʉ̃'ʉ. Jã'ata'ni chʉ'ʉ chiicheta'ni cho'omanejʉ̃'ʉ. Ʉ̃seʉama'to mʉ'ʉre ʉache cho'ojʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jã'aja'ñe i'kacuha vʉni, repaʉ neena pa'ichejana co'i ñato kãni ũhijʉ paniasome repana. Kãnisõrena Pedroni i'kaasomʉ repaʉ. —¿Mʉsanʉkonare te'ehorajẽ'e kãima'ñe chʉ'ʉna'me pẽ'jecu'aʉ? ");
INSERT INTO coe_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rekoñoã re'oja'che cho'oñu chiime mʉsanʉkona; jã'ata'ni re'oja'che cho'ovesʉme. Jã'ajekʉna kãima'ñe Dioni sẽejʉ pa'ijʉ̃'ʉ, Ũcuaʉji cho'okaiʉna cu'ache cho'omaneñu chini —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chini Jesús jo'e sani Pʉka'kʉni ija'che sẽniasomʉ: —Ja'kʉ, chʉ'ʉre cu'ache cho'ojache ʉ̃sekaiʉama'to mʉ'ʉre ʉache cho'ojʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sẽnicuha co'i repaʉ neenare jo'e kãni ũhijʉ pa'inani ñaasomʉ repaʉ. Repanare ʉokʉacajejani repana ñakocaã ñañejẽ'e cu'ache ta'piasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pʉka'kʉni sẽsa chini repanare jo'ka jo'e sani, repaʉ aperʉmʉ i'kasi'ere ũcuate'ere i'kakʉ sẽniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","I'ka pi'ni co'i repaʉ neenare ija'che i'kaasomʉ repaʉ: —¿Chuta'a vʉima'ñe kãiñe ina? Chʉ'ʉre Dios Raosi'kʉre, pãi chẽa cu'ache cho'onare jo'karʉmʉ tĩ'acuhamʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Jʉna, vʉijʉ̃'ʉ; sañu! Chʉ'ʉni cu'ache cho'oa'jʉ chini chekʉnare jo'kajaʉ ranicuhamʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús chuta'a i'katona Judas chʉkʉna docerepana Jesús neenare ja'me pa'ikʉji, pãi rʉa jainʉkore va'jñana'me vãsoñoã cãjinani rakʉ charo raisi'kʉa'mʉ. Judío phairipãi chʉ̃'ʉnana'me judío aina chʉ̃'ʉrena raniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesure jo'kajaʉ Judas aperʉmʉ, repanare pãi ija'che i'kaasomʉ: “Mʉsanʉkonapi Jesuni masia'jʉ chini, repaʉ pa'ichejana sani tĩ'ani chũsu pojoja'mʉ chʉ'ʉ repaʉ'te. Chʉ'ʉ jã'aja'ñe cho'otona chẽa sajʉ̃'ʉ repaʉ'te”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jã'aja'ñe i'kasi'kʉjekʉ Judas, Jesús pa'ichejana rani tĩ'a, —¿Pa'ikʉ, Masiʉ? —chini repaʉ'te chũsu pojosi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jã'aja'ñe i'kakʉ chũsuʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Chʉ'ʉre ja'me pa'isi'kʉ, mʉ'ʉ cho'ora chini raisi'e teana cho'ojʉ̃'ʉ —chiisi'kʉa'mʉ. Chikʉna chekʉna rani Jesure chẽasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jã'aja'ñe cho'ojʉna ña Jesure ja'me pa'ikʉ te'eʉ va'ti ruta judío phairi aire cho'oche cho'okaikʉ'te cãjoro tẽo vatosõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tẽoʉna Jesús i'kasi'kʉa'mʉ. —Mʉ'ʉ va'ti mañajʉ̃'ʉ. Pãi ũcuanʉko va'jñapi cavajʉ chekʉnare vanisõna, va'jñana chuenisõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Chʉ'ʉpi Ja'kʉni sẽeto teana ángeles rʉa jainʉko pãi vaimasinani raora'amʉ, chʉ'ʉre ʉ̃sekaijanare. “Ikʉre jã'aja'ñe cho'ocu'amʉ”, chiiʉ cuasacosomʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jã'ata'ni chʉ'ʉpi jã'aja'ñe cho'oto, Dios chʉ'o aperʉmʉ tocha jo'kasi'e kʉache, “Ija'che cho'ocojñoja'mʉ”, chiiche ũcuarepa ti'jñema'mʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chini Jesús repanare pãi ija'che i'kasi'kʉa'mʉ: —¿Je'se pa'iʉna mʉsanʉkona chʉ'ʉre ñaaʉ'te cho'ocheja'che va'jñana'me vãsoñoã cãjijʉ chẽañu chini raiche? Si'aumucujña Dios vʉ'e mʉa mʉsanʉkonana'me pa'iʉ pãire che'chokʉ pa'isi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni mʉsanʉkona chʉ'ʉre chẽamanesinaa'me. Irʉmʉta'ni chʉ'ʉni Diopi ʉ̃semaʉna chẽame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jã'ata'ni peore ie irʉmʉ cho'oche Dios chʉ'o aperʉmʉ kʉakaisina kʉajʉ tocha jo'kasi'epi ũcuarepa ti'jñecuhamʉ —chiisi'kʉa'mʉ repaʉ. Ũcuarʉmʉ chʉkʉna Jesús neena ũcuanʉko vajʉchʉjʉ repaʉ'te te'eʉ'te jo'ka vʉ'vʉsõsinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Repana Jesure chẽasina judío phairi ai Caifás pa'ivʉ'ena saasome repaʉ'te, judíopãi che'chonana'me judío aina chi'i pa'ivʉ'ena. ");
INSERT INTO coe_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jã'a cho'oto Pedro so'opi ñakʉ cho'jepi phairi ai vʉ'e sa'navʉ pa'iraripʉjatʉ'ka tuhaasomʉ. Tuha ja'me kaka repavʉ'e pẽ'jekaina pãi chẽanana'me pʉʉasomʉ repaʉ, Jesure cho'oche'te ñara chini. ");
INSERT INTO coe_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Repavʉ'e chi'i pa'ina judío phairipãi chʉ̃'ʉnana'me judíopãi chʉ̃'ʉna ũcuanʉko jorenani ku'e raa'jʉ chini chekʉnani chʉ̃'ʉasome, “Jesús cu'ache cho'osi'kʉa'mʉ”, chiijʉ jorerena repaʉni vanisõñe'te chʉ̃'ʉñu chini. ");
INSERT INTO coe_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Ku'e jñaa rarena jorena jainʉko raisinata'ni ũcuanʉko ũcuate'e i'kamapʉna, Jesure vanisõñe chuta'a chʉ̃'ʉcu'aasomʉ repanare. Jã'ata'ni repana i'kacuhasirʉmʉ chekʉna ka'chana ũcuavʉ'ena rani kaka ija'che i'kaasome: —Ikʉ Jesús ija'che i'kasi'kʉa'mʉ: “Chʉ'ʉpi ivʉ'ere Dios vʉ'ere ñañosõni choteumucujñana jo'e cho'o pi'nija'mʉ”, chiisi'kʉa'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jã'aja'ñe kʉarena asa phairi ai vʉni Jesure ija'che sẽniasomʉ: —¿Je'se chiikʉ mʉ'ʉ? Ina mʉ'ʉre i'kache, ¿ũcuarepaa'che mʉ'ʉ i'kasi'e? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jã'ata'ni Jesús i'kamaneasomʉ. I'kamaʉna phairi ai jo'e i'kaasomʉ. —¡Dios Si'arʉmʉ Pa'ikʉni roiʉ chʉ'o ũcuarepare i'kaa'kʉ chini chʉ̃'ʉmʉ chʉ'ʉ mʉ'ʉre! Mʉ'ʉpi pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Mamakʉ Cristo pani kʉajʉ̃'ʉ chʉkʉna'te —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chikʉna Jesús i'kaasomʉ. —Ũcuaʉ'mʉ chʉ'ʉ. Ũcuachi'a ija'che i'kamʉ chʉ'ʉ mʉsanʉkonare: Na'a pa'isirʉmʉ mʉsanʉkona chʉ'ʉre Dios Raosi'kʉre Ja'kʉ peore Cho'omasiʉ ʉjajʉ̃tʉ cakã'kore kueñe ñu'ikʉji pikona'me cʉnaʉmʉpi cajekʉna ñajanaa'me —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jã'aja'ñe i'kaʉna asa pe'rukʉ phairi ai repaʉ ju'ikãña meñe rueni che'rekʉ chekʉnani ija'che i'kaasomʉ: —Dios rʉa cuheche'te i'kasi'kʉa'mʉ ikʉ. Ikʉ cu'ache cho'osi'e kʉanare chekʉnare chiima'me mai. Mʉsanʉkonare ikʉ i'kasi'e asasinare, ");
INSERT INTO coe_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿je'se cuasokʉ? —chiniasomʉ. Chikʉna i'kaasome repana. —Cu'ache cho'okʉ'te vanisõñe pa'imʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Ũcuarʉmʉ pãi Jesús ñakocaã kãase'rechoji quẽo tʉsʉ repaʉ chiana coo tutujʉ jẽsoasome. Chekʉna ija'che i'kajʉ repaʉ chiana charaasome: —Mʉ'ʉpi, Dios Raosi'kʉ pani cuasa i'kajʉ̃'ʉ. ¿Neepi mʉ'ʉre charare? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jã'a cho'oto Pedro repavʉ'e sa'navʉ cararipʉ'te ñu'iʉ paniasomʉ. Ũcuarʉmʉ romichĩio repavʉ'e cho'oche cho'okaiko repaʉ'te rani ija'che i'kaasomo: —Mʉ'ʉ ũcuaja'che Jesús Galilea cheja cakʉna'me ku'isi'kʉcosomʉ —chiniasomo. ");
INSERT INTO coe_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jã'ata'ni Pedro chekʉna ũcuanʉko asajʉ'te ija'che i'kakʉ jachaasomʉ: —Mʉ'ʉ i'kache vesʉmʉ chʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jã'aja'ñe i'kacuha repavʉ'e kakasa'aro'te sani pa'iʉna cheko romichĩio repaʉ'te ña chekʉnani ija'che i'kaasomo: —Ikʉ ũcuaja'che Jesús Nazaret vʉ'ejoopo cakʉna'me pa'isi'kʉcosomʉ —chiniasomo. ");
INSERT INTO coe_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chikona Pedro Dioni roiʉ jo'e jachakʉ ija'che i'kaasomʉ: —Jã'ʉre ñama'kʉa'mʉ chʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jmamakarʉ pa'isirʉmʉna repacheja pa'ina Pedro'te sani ija'che i'kaasome: —Mʉ'ʉ ũcuaja'che chekʉrʉmʉ Jesús neenare ja'me pa'isi'kʉcosomʉ. Mʉ'ʉ cutuchʉ'opi asa masime chʉkʉna, Galilea cheja cana cutuche chʉ'o i'kakʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chitena Pedro Dioni roiʉ, —Chʉ'ʉpi chʉ'o ũcuarepare i'kama'to Diopi cu'ache cho'oa'kʉ chʉ'ʉre —chiiʉ jachakʉ,— Jã'ʉre ñama'kʉa'mʉ chʉ'ʉ —chiniasomʉ. Repaʉ jã'aja'ñe i'katona kura chuniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chu'iʉna Pedro, repaʉ'te Jesús i'kasi'ere cuasaasomʉ, “Chuta'a kura chu'ima'tona choteñoã jachakʉ, ‘Jesure ñama'kʉa'mʉ chʉ'ʉ’, chiija'mʉ mʉ'ʉ”, chiisi'ere. Jã'are cuasa Pedro repacheja pa'isi'kʉ eta rʉa oiche oniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ñatasirʉmʉ repana judío phairipãi chʉ̃'ʉnana'me judío aina ũcuanʉko, “Pilatoji jã'ʉre Jesure vanisõñe chʉ̃'ʉa'kʉ chini ũcuaʉni sa jo'kañu”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Cutu pi'ni Jesure vẽe Romapãi chʉ̃'ʉkʉni Pilatoni sa jo'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ũcuarʉmʉ Judas, Jesure cu'ache cho'ojanare jo'kasi'kʉ repanapi, Jesuni vanisõñe'te Pilatoji chʉ̃'ʉa'kʉ chini sajʉna ña repaʉ cu'ache cho'osi'e sʉma'ñe cuasaasomʉ. Jã'aja'ñe cuasa repaʉ Jesure ĩsikʉ koosi'e kurire're treintarepare're repare're ro'isinani judío phairipãi chʉ̃'ʉnana'me judío ainani jo'e co'choasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jo'e co'chokʉ ija'che i'kaasomʉ repaʉ: —Jesure, cu'ache cho'omanesi'kʉni vanisõa'jʉ chini jo'kakʉ cu'ache cho'osi'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ repanare. Chikʉna i'kaasome repana. —Chʉkʉna'te chʉ'ojẽ'e peomʉ jã'a. Mʉ'ʉ cho'osi'ea'me jã'a —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chini koocuhejʉna Judas, kurire're Dios vʉ'ena kaka su'a ũha sanisõasomʉ. Sani sũkiñʉ ʉmʉ cakapʉna mʉni pĩsime quẽo sʉo ũcuaʉji meñe cavʉna pĩsimeji quẽo chãni rueeʉ jũnisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Repaʉ jũnisõsirʉmʉ phairipãi chʉ̃'ʉna repare're kurire're sia sãiñechi'a ija'che i'kaasome: —Ire're kurire're vanisõjaʉre sa jo'kasi'e ro'i, ro'isire'rejekʉna cãjovʉ Dios vʉ'e pa'ivʉ mañacu'amʉ. Mai aipãi chʉ̃'ʉ jo'kasi'e jã'aja'ñe cho'oche ʉ̃semʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chini repare're cho'ojache cutu pi'ni toto miicheja chiichejare kooasome repana, tĩipãi rani pa'ijʉ jũnisõrena tãjachejare cho'o care'va paañu chini. ");
INSERT INTO coe_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jã'ajekʉna repacheja vanisõjaʉre sa jo'kasi'e ro'i ro'isire're koosichejajekʉ irʉmʉjatʉ'ka Chiecheja ve'emʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jã'aja'ñe cho'orena aperʉmʉ Dios chʉ'o kʉasi'kʉ Jeremías kʉakʉ tocha jo'kasi'epi ũcuarepa ti'jñesi'kʉa'mʉ. Ija'che chiimʉ repa tocha jo'kasi'e: Diopi chʉ̃'ʉʉna chʉ'ʉ cho'osi'eja'che cho'ojʉ Israelpãi chejare kooñu chini pãiʉ'te jo'kasi'e ro'i ro'isinʉko kurire're treintarepare're mini saasome. ");
INSERT INTO coe_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Repare're mini sa toto miicheja chiichejare kooasome repana, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Reparʉmʉ pãi chʉ̃'ʉkʉ Pilato ũcuaʉ ti'jñeñena Jesuni sa nʉkorena ija'che sẽniasomʉ: —¿Judíopãi ũcuanʉkore chʉ̃'ʉkʉ'ʉ mʉ'ʉ? —chiniasomʉ. Chikʉna Jesús, —Ũcuaʉ'mʉ chʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Judío phairipãi chʉ̃'ʉnana'me judío aina, —Si'ache cu'ache cho'okʉ'mʉ ikʉ —chiniasome repaʉ'te. Jã'ata'ni Jesús repanare sãiñe i'kamaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jã'ajekʉna Pilato repaʉ'te sẽniasomʉ. —¿Ina mʉ'ʉre cu'ache i'kache asama'kʉ mʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jã'ata'ni Jesús jmamakarʉjẽ'e i'kamaneasomʉ. Repaʉ sẽeñe'te i'kamaʉna Pilato, “¿Jeeja'iʉ'ʉ ikʉ?”, chiiʉ cuasaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Repaʉ Pilato ʉ̃sʉrʉmʉ pa'iche pascuarʉmʉ tĩ'ato chẽacojñosi'kʉre te'eʉ'te etoasomʉ, pãi, “Jã'ʉni etojʉ̃'ʉ”, chiicojñokʉni. ");
INSERT INTO coe_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Reparʉmʉ pãiʉ rʉa cu'ache cho'osi'kʉ Barrabás pãi chẽavʉ'ere paniasomʉ, repaʉ cho'osi'e pãi ũcuanʉko asa masicojñokʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Ũcuarʉmʉ Pilato ija'che cuasa, “Ikʉre Jesure pãipi jainʉko jovojʉna ña pe'rujʉ chʉ'ʉni ra jo'kacosome”, chini pãi jainʉko chi'i pa'ichejana ija'che sẽniasomʉ: —¿Neeni etojʉ̃'ʉ chiiche mʉsanʉkona chʉ'ʉre? ¿Barrabani? Jã'apãani, ¿Dios Raosi'kʉ chiicojñokʉni Jesuni etoja'che chʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jã'aja'ñe sẽniasa repaʉ pãi chʉ̃'ʉkʉ ñu'isaivʉ ñu'itona repaʉ rʉ̃jo chʉ'o raoasomo repaʉ'te. “Jã'ʉre re'okʉ'te pãiʉ'te cu'ache cho'omanejʉ̃'ʉ. Mʉ'ʉpi repaʉni chẽa paakʉna ñami rʉa vajʉchʉache ñoñe'te cu'ache kãni ñasi'koa'mo chʉ'ʉ”, chiniasomo. ");
INSERT INTO coe_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jã'ata'ni judío phairipãi chʉ̃'ʉnana'me judío aina pãire rʉa i'kaasome, repanapi Barraba'te etochena'me Jesure vanisõñe'te sẽapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ũcuarʉmʉ Pilato repanare pãi jo'e sẽniasaasomʉ. —Inare ka'chanare, ¿jaʉni etojʉ̃'ʉ chiiche mʉsanʉkona chʉ'ʉre? —chiniasomʉ. Chikʉna repana, —Barrabani etojʉ̃'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chitena Pilato ija'che sẽniasomʉ: —Jã'aja'ñe cho'oni, Jesure, Dios Raosi'kʉ chiicojñokʉ'te, ¿je'se cho'oja'che chʉ'ʉ? —chiniasomʉ. Chikʉna repana ũcuanʉko, —Kurususẽ'verona jẽ'jo nʉko vẽasõjʉ̃'ʉ jã'ʉre —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chitena Pilato i'kaasomʉ. —¿Ʉ̃quere ikʉ Jesús cu'ache cho'oʉ? —chiniasomʉ. Jã'ata'ni repana jo'e ʉjachʉ'o cuijʉ, —Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jã'aja'ñe i'kajʉ repanapi na'a rʉa pe'rujʉ i'kajʉna asa Pilato, “I'kate'ecuhamʉ chʉ'ʉ inare”, chiiʉ cuasaasomʉ. Jã'ajekʉna repana cho'oñu chiiche'te chʉ̃'ʉcuhekʉ repaʉ chʉ'o peoche'te cho'o ñokʉ jʉ̃jñare choara chini okore raa'jʉ chini chʉ̃'ʉasomʉ repaʉ. Oko rarena repana ñajʉ'te jʉ̃jñare choakʉ repanare ija'che i'kaasomʉ repaʉ: —Chʉ'ʉ ikʉre vanisõñe chʉ̃'ʉcuhekʉjekʉ chʉ'o peomʉ. Mʉsanʉkona cho'oche'me jã'a —chiniasomʉ Pilato repanare. ");
INSERT INTO coe_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chikʉna pãi ũcuanʉko ija'che i'kaasome: —Jã'ʉre vanisõsi'e ro'i chʉkʉnana'me chʉkʉna jojocojñosina ro'ijanaa'me —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jã'aja'ñe i'karena asa Pilato repana chiiche cho'okʉ Barrabani etoasomʉ. Jesureta'ni suĩ'sueche'te chʉ̃'ʉasomʉ repaʉ. Suĩ'sue pi'nirena repaʉ neenani sõtaopãire Jesure jo'kaasomʉ repaʉ, sa kurususẽ'verona jẽ'jo nʉkoa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ũcuarʉmʉ sõtaopãipi Pilato neena repaʉ vʉ'ena sa nʉkoasome Jesure. Repaʉ'te sa nʉko chekʉnare sõtaopãi soni rao chi'i Jesure rũhiso'koro nʉkaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chi'i nʉkajʉ repaʉ'te, kãña tĩ'tesõ chimaajakãare sachaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ũcuachi'a miu tuhivʉ cho'o repaʉ sĩjopʉna tʉo vãsocho pãi chʉ̃'ʉna cãjiño repaʉ ʉjajʉ̃tʉna ĩsiasome repana, cãjia'kʉ chini. Jã'aja'ñe cho'o repaʉni pãisojʉ ũcuaʉ ti'jñeñena ro're pʉʉ ñu'ijʉ, ija'che i'kaasome repana: “Ikʉpi judíopãire si'arʉmʉ chʉ̃'ʉkʉ paaʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ũcuachi'a repaʉni coo tutujʉ vãsocho repaʉ cãjiñoji tʉa repaʉ sĩjopʉna rʉa vaniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jã'aja'ñe cho'ojʉ repaʉ'te pãiso pi'ni, repana sachasikãa tĩto repaʉ ju'isikãare jo'e sachaasome repana. Sacha pi'ni kurususẽ'verona jẽ'jo nʉkoñu chini repaʉ'te sasõasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Repacheja etua Jesure sajʉ Simonre Cirene cheja cakʉre chẽa repaʉ tãtavana kurususẽ'vero tʉo, “Mʉ'ʉpi isẽ'vero kuãa sakaijʉ̃'ʉ”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Saijʉ Gólgota aikũtina tĩ'asinaa'me repana. (“Gólgota” chini “Pãi sĩjopʉjakũti” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Repacheja tĩ'asirʉmʉ Jesure ʉche cono rʉara'ka ja'mesi'ere ũkuasinaa'me repana. Jã'ata'ni Jesús jmamakarʉ ũku ña jo'e ũkucuhesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Repana Jesure kurususẽ'vero jẽ'jo nʉkosirʉmʉ sõtaopãi repaʉ ju'isikãñare paañu chini catara'karʉã mami tochasira'karʉãpi chejana su'asinaa'me Jesús ju'isikãña paajaʉni jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jã'aja'ñe cho'o pi'ni Jesuni pẽ'jeñu chini ũcuachejana pʉʉsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ũcuachi'a repaʉni cho'ojʉ sojʉ repaʉ'te cu'ache i'kasi'ere kʉajʉ, Jesua'mʉ Ikʉ. Judiopãi Chʉ̃'ʉkʉ'mʉ, chiiche chooko'ana tocha kurususẽ'vero chã'tirona jẽ'jo sʉosinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ũcuachi'a põse ñaasinare ka'chanare kurususẽ'veroãna jẽ'jo Jesús ʉjajʉ̃tʉ cakã'kona chekʉre nʉkosinaa'me repana. Chekʉni kã'kojʉ̃tʉ cakã'kona nʉkosinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Repanare jẽ'jo nʉkosirʉmʉ repacheja caraina Jesure tea ñajʉ repana sĩjo sʉ̃'cuijʉ cu'ache i'kajʉ caraisinaa'me. —“Dios vʉ'e ñañosõni choteumucujñana jo'e cho'o pi'nija'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ mʉ'ʉ. Jã'aja'ñe i'kasi'kʉ chura mʉ'ʉpi meñe jũ'iñe ʉ̃sejʉ̃'ʉ, masini. Dios Mamakʉ pani cajejʉ̃'ʉ jã'acheja kurususẽ'vero —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me judío aina ũcuaja'che pãisojʉ repaʉ'te cu'ache i'kasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Chekʉnare jũ'iñe ʉ̃sesi'kʉasomʉ jã'ʉ. Jã'ata'ni repaʉ'te chura ũcuaʉji meñe jũ'iñe ʉ̃secu'amʉ. “Israelpãi chʉ̃'ʉkʉ'mʉ ikʉ”, chiicojñosi'kʉa'mʉ repaʉ. Jã'ajekʉna ũcuachejapi cajea'kʉ. Repaʉji cajeʉna ñani, “Dios Mamakʉ'mʉ ikʉ”, chiijʉ cuasajanaa'me mai. ");
INSERT INTO coe_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Dios chʉ'ʉre Ũcuaʉni cuasakʉna cho'okaija'mʉ”, chiisi'kʉa'mʉ repaʉ. Ũcuachi'a, “Dios Mamakʉ'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ. Jã'ajekʉna chura Pʉka'kʉ Diopi cho'okaaʉ repaʉ'te, Repaʉji ʉ̃sera chini —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Repaʉna'me kurususẽ'veroã jẽ'jo nʉkocojñosina ũcuachi'a ja'me cu'ache i'kasinaa'me Jesure. ");
INSERT INTO coe_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Reparʉmʉ nʉkarepaʉ sʉ'itona ʉ̃sʉʉ miañe ta'pisõʉna cheja si'acheja trejatʉ'ka chija'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jã'aja'ñe cho'otona Jesús ʉjachʉ'opi ija'che i'kakʉ cuisi'kʉa'mʉ: —Elí, Elí, ¿lema sabactani? —chiisi'kʉa'mʉ. (Ija'che chiimʉ jã'a, “Dios, chʉ'ʉre Paakʉ, Dios, chʉ'ʉre Paakʉ, ¿je'se pa'iʉna mʉ'ʉ chʉ'ʉre jo'kasõkʉ?” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jã'aja'ñe i'kaʉna asa repacheja pa'ina te'ena ija'che i'kasinaa'me: —Aperʉmʉ pa'isi'kʉni Elíani soicosomʉ jã'ʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ũcuarʉmʉ repanare ja'me pa'ikʉ te'eʉ vʉ'vʉ sani chʉisʉovʉ mini ʉche cono rʉara'kana chʉ̃ʉ vãsochona quẽo sʉo Jesuni mʉosi'kʉa'mʉ chʉ'chʉ ũkua'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jã'ata'ni chekʉna ija'che i'kasinaa'me: —Cho'omanejʉ̃'ʉ. Elíapi rani repaʉ'te jũ'iñe ʉ̃seche'te ñañu. Raimanejacosomʉ repaʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jã'aja'ñe i'katona Jesús jo'e rʉa cuicuha jũnisõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Repaʉ Jesús jũ'itona Dios vʉ'e sa'navʉ caruupʉ kakasa'aro rueekãa ũcuate'ekãapi joorepapoji ʉmʉpi vʉ'evʉna che're cajeasomʉ. Ũcuachi'a cheja si'acheja pi'rukʉna catapʉã jonisõasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ũcuachi'a jũ'isinare tãsicojña ta'pisipʉã cata ũcuate'epʉã vataasomʉ. Jã'aja'ñe cho'oʉna vajʉrʉmʉ Diore cuasasiva'na jainʉko Ũcuaʉji vasoʉna vajʉrani repanare tãsichejñapi etaasome. ");
INSERT INTO coe_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús jũnisõ tãcojñosi'kʉ vajʉraisirʉmʉna Jerusalén vʉ'ejoopona satena pãi rʉa jainʉko ñaasome repanare. ");
INSERT INTO coe_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ũcuarʉmʉ sõtaopãi cienrepanare chʉ̃'ʉkʉ sõtao Jesure pẽ'jekainana'me cheja pi'ruche'te ñajʉ reparʉmʉ cho'oche peore ña, kʉkʉsõ ija'che i'kasinaa'me: —Dios Mamarepakʉ pa'icosomʉ jã'ʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jã'a cho'oto Galilea chejapi ja'me raijʉ Jesure kuirasiva'na romiva'na so'opi nʉkajʉ ñajʉ pa'isinaa'me repaʉ'te cho'oche. ");
INSERT INTO coe_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","María Magdalenaa'mo, María Santiagona'me José pʉka'koa'mo, Zebedeo mamachĩi pʉka'koa'mo, chekʉna romina'me pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Na'isõsirʉmʉna José kuriʉ Arimatea vʉ'ejoopo cakʉpi rani pa'iʉ Jesure cuasakʉ jovosi'kʉ rani tĩ'a, Jesuni jũ'isi'kʉni sa tãra chini sani Pilatoni sẽniasomʉ. Sẽkʉna Pilato repaʉni ĩsia'jʉ chini chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Repaʉ'te sẽni ĩsiʉna sábanakãa menojẽ'e peokãapi rea aikũti caripana repaʉ mamarepa cho'osicojena sa cuaa ũhaasomʉ. Repacoje kakacheja catapʉ rʉa ʉjapʉji ũha ta'pisõ sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jã'ata'ni María Magdalenana'me cheko María repacoje ti'jñeñe'te ñu'ijʉ ñajʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jo'e apeñatato pʉaumucusena judío phairipãi chʉ̃'ʉnana'me fariseopãi Pilato pa'ivʉ'ena sani chi'i ija'che i'kaasome repaʉ'te: ");
INSERT INTO coe_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Chʉkʉna'te paakʉ, repaʉ joreʉ chuta'a vajʉrʉmʉ i'kasi'e churana cuasame chʉkʉna. Ija'che i'kasi'kʉa'mʉ repaʉ: “Chʉ'ʉpi chuenisõni choteumucujña pa'isirʉmʉna jo'e vajʉraija'mʉ”, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jã'ajekʉna mʉ'ʉpi repaʉ'te tãsicoje pẽ'jejanare choteumucujña chʉ̃'ʉ jo'kato na'a re'omʉ. Jã'aja'ñe cho'oma'to chekʉrʉmʉ repaʉ neena ñamina rani repaʉ'te ñaa sa jorejʉ, “Vajʉranicuhasi'kʉa'mʉ repaʉ”, chiijʉ pãire kʉajanaa'me. Aperʉmʉ ũcuanapi jorejʉna pãi jainʉko jachama'ñe, “Jesús Dios Raosi'kʉa'mʉ”, chiijʉ cuasasinaa'me. Jã'ajekʉna irʉmʉna repanapi jã'aja'ñe cho'o jorejʉ i'kajʉna pãipi na'a jainʉko jachama'ñe cuasato na'a rʉa cu'aja'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chitena Pilato i'kaasomʉ. —Jaʉ. Repaʉ paasina repaʉ'te ñaamanea'jʉ chini peore cho'ore'ochetʉ'ka cho'ojʉ inare sõtaopãi repacoje pẽ'jejanare sa repana cho'ojache masi i'ka jo'kajʉ̃'ʉ pẽ'jea'jʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chikʉna sani Jesure tãsicoje ta'pisi'pʉ catapʉ cha'opi je'na sʉoasome, pãipi vataru ña masiñu chini. Jã'aja'ñe cho'o pi'ni repacoje pẽ'jekaijanare sõtaopãi ũcuachejana jo'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Repana judíopãi pʉaumucuse carakʉna María Magdalenana'me cheko María romicorʉmʉ apeñatatona Jesure ũhasicojere ñañu chini saniasome. ");
INSERT INTO coe_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Repana sani tĩ'asirʉmʉ teana cheja rʉa pi'ruasomʉ cʉnaʉmʉ Diore ja'me pa'ikʉji ángelpi ũcuachejana cajekʉna. Caje Jesure tãsicoje sani tĩ'a repacoje ta'pisi'pʉ catapʉ kʉño ũha ũcuapʉ sẽ'sevʉ'te pʉʉ ñuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Repaʉ ángel oko fe'neñeja'ñe ko'sija'iʉ ñoasomʉ. Repaʉ ju'ikãña pojakãña paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jã'aja'ñe ju'ikʉni ña repacoje pẽ'jesina sõtaopãi kʉkʉcajejani kurukurujʉ jũnisõñena ũniasome. ");
INSERT INTO coe_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jã'ata'ni ángel repanare romi ija'che i'kaasomʉ: —Vajʉchʉmanejʉ̃'ʉ. Mʉsanʉkona Jesure ku'eche masimʉ chʉ'ʉ. Kurususẽ'verona jẽ'jo nʉko vẽasõsi'kʉni ku'eme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Icheja peomʉ repaʉ. Vajʉranicuhasi'kʉa'mʉ, repaʉ chuta'a jũ'imarʉmʉ cho'ora chiisi'e. Repaʉ'te ũhasicheja rani ñajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kaka ña pi'ni teana sani repaʉ neenare ija'che kʉajʉ̃'ʉ: “Jesús vajʉranicuhasi'kʉa'mʉ. Mʉsanʉkonare na'a charo Galilea chejana saija'mʉ repaʉ. Ũcuachejana sani repaʉ'te ñajanaa'me mʉsanʉkona”, chiijʉ̃'ʉ repanare. Mʉsanʉkona jã'are kʉara chini raisi'kʉa'mʉ chʉ'ʉ —chiniasomʉ ángel repanare. ");
INSERT INTO coe_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ũcuarʉmʉ romiva'na jã'aja'ñe i'kaʉna asa kʉkʉsõsiva'nata'ni ũcuacojepi cu'arepa eta pojojʉ vʉ'vʉasome, Jesús neenani chʉ'ore kʉañu chini. ");
INSERT INTO coe_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vʉ'vʉjʉna peosichejapi Jesús repanare ti'jñeñe rani nʉkakʉ ija'che i'kaasomʉ: —Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona —chiniasomʉ. Chikʉna repaʉ cũ'ana sũ'ka pojoasome repana. ");
INSERT INTO coe_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jã'aja'ñe cho'ojʉna Jesús repanare ija'che i'kaasomʉ:— Vajʉchʉmanejʉ̃'ʉ mʉsanʉkona. Sani chʉ'ʉ neenare ija'che kʉajʉ̃'ʉ: “Jesús mʉsanʉkonare, ‘Galilea chejana saijʉ̃'ʉ; ũcuachejana chʉ'ʉre ñajanaa'me’, chiisi'kʉa'mʉ”, chiijʉ̃'ʉ repanare —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Repana asasi'ere kʉañu chini romiva'na chuta'a saitona sõtaopãi Jesure tãsicoje pẽ'jesina chekʉna te'ena vʉ'ejoopona charo sani tĩ'a repacheja cho'osi'e peore judío phairipãi chʉ̃'ʉnani kʉaasome. ");
INSERT INTO coe_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Kʉarena asa repana judío phairipãi chʉ̃'ʉna judío ainana'me chi'i repana cho'ojache cutu pi'ni sõtaopãire ija'che i'kajʉ kuri rʉa ĩsiasome: —Pãi ũcuanʉkore ija'che kʉajʉ̃'ʉ: “Chʉkʉna kãnisõsirʉmʉna Jesure repaʉ neena ñamina rani ñaa sasõsinaa'me”, chiijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mʉsanʉkonapi jã'aja'ñe kʉarena asani chekʉrʉmʉ maire chʉ̃'ʉkʉ pe'ruja'mʉ mʉsanʉkonare. Jã'ata'ni chʉkʉnapi i'kajʉna cu'ache cho'oche chʉ̃'ʉmaneja'mʉ repaʉ mʉsanʉkonare —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chitena sõtaopãi kuri koo sani repana chʉ̃'ʉsi'e cho'oasome. Jã'aja'ñe cho'osi'ejekʉna judíopãi irʉmʉjatʉ'ka repana kʉasi'e, “Ũcuarepaa'me jã'a”, chini cuasajʉ chekʉnare ũcuare kʉame. ");
INSERT INTO coe_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ũcuarʉmʉ chʉkʉna Jesús neena oncerepana Galilea chejana sani aikũtina mʉisinaa'me, Jesús chʉkʉna'te saijʉ̃'ʉ chiisikũtina. ");
INSERT INTO coe_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sani mʉni Jesure ña pojojʉ ro're pʉʉsinaa'me chʉkʉna. Chekʉna te'ena jachajʉ, “Jesuma'mʉ ikʉ”, chiijʉ cuasasinaa'me. ");
INSERT INTO coe_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jã'aja'ñe cuasajʉna Jesús repanare kueñe sani ija'che i'kasi'kʉa'mʉ: —Dios chʉ'ʉre cʉnaʉmʉ pa'inana'me cheja pa'inare peore chʉ̃'ʉñe jo'kasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jã'ajekʉna sani ku'ijʉ pãire si'achejña pa'inani Dios chʉ'ore chʉ'vajʉ pa'ijʉ̃'ʉ, repanapi asa chẽa chʉ'ʉni cuasajʉ chʉ'ʉ neena paapʉ chini. Mʉsanʉkona chʉ'vachʉ'o asa chẽa chʉ'ʉre cuasanare okoro'vejʉ pa'ijʉ̃'ʉ, Ja'kʉna'me chʉ'ʉ Repaʉ Mamakʉna'me Repaʉ Rekocho repanare paacheji ñoa'kʉ. ");
INSERT INTO coe_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ũcuachi'a chʉ'ʉ mʉsanʉkonare chʉ̃'ʉsi'e peore che'chojʉ̃'ʉ repanare, jachama'ñe cho'ojʉ paapʉ. Chʉ'ʉ mʉsanʉkonare cheja si'asõñetʉ'ka si'arʉmʉ ja'me pa'ija'mʉ —chiisi'kʉa'mʉ repaʉ. Re'omʉ.");
INSERT INTO coe_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Dios Mamakʉ pa'iche'te chʉ'o re'oja'chere kʉapi'ramʉ ie chʉ'o: ");
INSERT INTO coe_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías ija'che tocha jo'kaasomʉ: Mʉ'ʉ cheja cajejache kʉajaʉni charo saoja'mʉ chʉ'ʉ, pãipi mʉ'ʉ cajejachere asa repana rekoñoãre care'va paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kʉakʉ pãi peochejare sani pa'iʉ pãipi repaʉni saito ʉjachʉ'opi ija'che i'kakʉ chʉ'vaja'mʉ: “Maire Paakʉ tĩ'api'ramʉ. Repaʉni cha'ajʉ mʉsanʉkona rekoñoã ma'a rũhiñe pa'ima'a care'vacheja'che re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ”, chiija'mʉ, chiiche tocha jo'kaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ũcuarʉmʉ Juan pãi peochejare sani pa'iʉ pãi okoro'vekʉ paniasomʉ. Ũcuachi'a repanare ija'che chʉ'vakʉ paniasomʉ repaʉ: —Mʉsanʉkona cu'ache cho'oche ũhaso re'oja'chere mama cuasajʉ̃'ʉ, Diopi mʉsanʉkona cu'ache cho'osi'ere tʉnoso jo'e cuasamanea'kʉ. Cu'ache cho'oche'te ũhaso Dioni cuasajʉ okoro'vecojñojʉ̃'ʉ —chiiʉ chʉ'vakʉ paniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ũcuarʉmʉ jainʉko pãi Judea cheja pa'inana'me Jerusalén vʉ'ejoopo pa'ina Juan chʉ'vachʉ'ore asañu chini saniasome. Sani repana cu'ache cho'osi'ere Dioni kʉarena Juan, Jordán chiachana okoro'veasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Repaʉ Juan ju'ikãa camello rañapi cho'osikãa paniasomʉ. Corejakãa va'i ca'ni kãare tʉ̃niasomʉ repaʉ. Ãu, pũ'suva'nana'me airo pũji ãiʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan repanare pãi chʉ'vakʉ ija'che i'kaasomʉ: —Na'a pa'isirʉmʉ chekʉ na'a rʉa masikʉji rani pa'iʉ na'a rʉa re'oja'che cho'okaija'mʉ mʉsanʉkonare. Chʉ'ʉre na'a rʉa masikʉjekʉna repaʉ'te cuasakʉ, vajʉchʉkʉ pa'imʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Chʉ'ʉ mʉsanʉkonare okopi okoro'vecuhamʉ. Repaʉta'ni na'a rʉa masiʉjekʉ rʉa masicheji cho'okʉ Dios Rekocho'te ĩsija'mʉ repaʉ mʉsanʉkonare —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ũcuarʉmʉ Jesús Nazaret vʉ'ejoopo Galilea cheja cajoopo pa'isi'kʉpi Jordán chiachana sani tĩ'aʉna Juan repaʉ'te okoroasomʉ ũcuachiachana. ");
INSERT INTO coe_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Okoroʉna Jesús chiacha nʉkasi'kʉpi po'ore mani nʉkakʉna cʉnaʉmʉ teana re'ojaʉmʉ care'o Dios Rekocho ũkupoja'iʉ ũcuaʉni cajekʉna ñaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dios Rekocho cajesirʉmʉ cʉnaʉmʉpi ija'che i'kache asoasomʉ: —Mʉ'ʉ chʉ'ʉ chĩi chʉ'ʉ oiʉ paakʉ'mʉ. Mʉ'ʉre rʉa pojomʉ chʉ'ʉ —chiiche asoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jã'a cho'ocuhasirʉmʉ Dios Rekochoji Jesure pãi peochejana saasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Saʉna ũcuachejare cuarentarepaumucujña paniasomʉ repaʉ cu'ava'nana'me. Pa'iʉna vati ai repaʉni cacʉ'ora chini rani rʉa chʉ̃'ʉte'easomʉ. Reparʉmʉ ángeles rani repaʉ'te kuiraasome. ");
INSERT INTO coe_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan Pãi Okoro'vesi'kʉ pãi chẽavʉ'e cuaosirʉmʉ Jesús Galilea chejana saniasomʉ Dios chʉ'o re'oja'chere chʉ'vara chini. ");
INSERT INTO coe_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chʉ'vakʉ ija'che i'kaasomʉ repaʉ: —Dios chiisirʉmʉ Repaʉ Raosi'kʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉ tĩ'api'ramʉ. Jã'ajekʉna mʉsanʉkona cu'ache cho'oche'te ũhasõ mama cuasa, “Dios chʉ'o ũcuarepaa'me”, chiijʉ asa chẽa cuasajʉ̃'ʉ —chiiʉ paniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ũcuarʉmʉ Jesús Galilea chiara rʉ'tʉva'te ku'iʉ Simonre repaʉ cho'jeʉ Andrena'me ñaasomʉ. Va'i chonajejʉ va'i chorʉji chiara'te chojʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Repanare Jesús ija'che i'kaasomʉ: —Rani chʉ'ʉni ja'me ku'ijʉ chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ pa'ijʉ̃'ʉ. Va'i sani va'ire jñaa ranaa'me mʉsanʉkona. Chura chʉ'ʉpi cho'okaiʉna sani pãire jñaa chʉ'ʉni rakaijʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jã'aja'ñe i'kaʉna asa teana va'i chorʉã jo'ka ũcuaʉna'me saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jã'achejapi jo'e jmachenerʉ sani Zebedeo chĩire Santiagona'me Juanre ñaasomʉ repaʉ. Choovʉ'te pa'ijʉ va'i chorʉãre care'vajʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ũcuarʉmʉ repanani Jesupi sokʉna, “Jaʉ”, chini, choovʉ pa'ikʉ'te pʉka'kʉre repaʉ'te cho'oche cho'okainare jo'ka Jesuna'me saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ũcuarʉmʉ Jesús repaʉ neenana'me sani Capernaum vʉ'ejoopona tĩ'aasome. Tĩ'a pa'iʉ pʉaumucuse Jesús judíopãi chi'ivʉ'ena kaka che'choasomʉ repavʉ'e chi'i pa'inare. ");
INSERT INTO coe_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Repana pãi Jesupi rʉa masikʉ masi che'chokʉna asa jñano, “Ikʉ Jesús judíopãi che'chona che'chocheja'che che'choma'ñe rʉa masi che'chomʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Reparʉmʉ ũcuavʉ'ere pãiʉ vatire paakʉ paniasomʉ. Vatire paakʉjekʉ Jesús i'kache'te asa cuikʉ i'kaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret raisi'kʉ chʉkʉna'te cho'omanejʉ̃'ʉ. Mʉ'ʉ pa'iche masimʉ chʉ'ʉ. Dios Raosi'kʉa'mʉ mʉ'ʉ. Re'okʉ'mʉ. ¿Chʉkʉnani cu'achejana saora chini rakʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jã'aja'ñe i'kaʉna Jesús repaʉ'te vatire jo'e i'kache ʉ̃sekʉ ija'che i'kaasomʉ: —Re'omʉ. Ũcuamakarʉ i'kajʉ̃'ʉ. Etajʉ̃'ʉ mʉ'ʉ jã'ʉre pãiʉ'te —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesupi, “Etajʉ̃'ʉ”, chikʉna vatipi cho'okʉna repaʉ pãiʉ rʉa kurukuruasomʉ. Ũcuarʉmʉ vati rʉa ʉjachʉ'opi cuikʉ eta sanisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jesupi vatini eto saoʉna ña kʉkʉso pãi ũcuanʉko sãiñechi'a sẽniasome. —¿Je'se pa'ikʉjekʉ ikʉ vati chʉ̃'ʉmasikʉ? ¿Ʉ̃quea'che ikʉ mama che'choche? Ikʉ Jesupi rʉa masikʉjekʉ chʉ̃'ʉto vatijatʉ'ka repaʉ chʉ̃'ʉñe jachama'ñe cho'ome —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesús cho'osi'e ñasinapi kueñe pa'inare kʉarena asa Jesús pa'iche'te Galilea cheja pa'ina ũcuanʉko rʉa na'mi asaasome. ");
INSERT INTO coe_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ũcuarʉmʉ Jesús judíopãi chi'ivʉ'e eta Simonna'me Andrés vʉ'ena mʉa kakaasomʉ Santiagona'me Juan. ");
INSERT INTO coe_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kaka ñato Simón vao cha'vo ravʉna jũ'io ũniasomo. Jã'ajekʉna, repaoni vasoa'kʉ chini Jesuni i'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I'kajʉna jũ'iko ũhiko'a kueñe sani repao jʉ̃tʉna chẽa vʉoʉna cha'vosi'e teana chʉrʉsoasomʉ repao'te. Chʉrʉʉna repao vajʉo ãure ãuasomo repanare. ");
INSERT INTO coe_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na'irepa chijajʉ̃vana Jesús pa'ivʉ'ena pãi jũ'iva'nare peore sajʉ vati paanare saasome. ");
INSERT INTO coe_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Repajoopo pa'ina rʉa jainʉko Jesús pa'ivʉ'e jatisa'arona chi'iasome. ");
INSERT INTO coe_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chi'irena Jesús jũ'inare si'ache ravʉ paanare jainʉkore vasosoasomʉ. Ũcuachi'a vati jainʉkore pãi sa'navʉã pa'isinare peore eto saosokaniasomʉ repaʉ. Eto saokʉ repanare vati repaʉ pa'iche'te masijʉna kʉajʉ chini ʉ̃seasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Apeñatato ñami vʉni Jesús vʉ'ejoopo pa'isi'kʉpi eta pãi peochejana saniasomʉ, Dioni sẽsa chini. ");
INSERT INTO coe_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sani te'eʉ pa'iʉna Simón repaʉ'te ja'me pa'inana'me Jesuni ku'eñu chini saniasome. ");
INSERT INTO coe_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ku'ejʉ jñaa ija'che i'kaasome repana repaʉ'te: —Pãi ũcuanʉko mʉ'ʉre ku'eme —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chitena Jesús ija'che i'kaasomʉ repanare: —Chekʉjoopoãna sañu mai kueñe pa'ijoopoãna. Jeejoopoã pa'inare ũcuaja'che Dios chʉ'ore chʉ'vara chiimʉ chʉ'ʉ. Jã'aja'ñe cho'ora chini raisi'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jã'aja'ñe cho'ora chiikʉjekʉ Galilea cheja si'achejña ku'iʉ repacheja pa'ivʉ'ña judíopãi chi'ivʉ'ñana si'arʉmʉ kaka Dios chʉ'ore chʉ'vakʉ paniasomʉ repaʉ. Ũcuachi'a vati pãi sa'navʉã pa'isinare eto saosokaiʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ũcuarʉmʉ pãiʉ asi ravʉ paakʉ Jesús pa'ichejana sani repaʉ ti'jñeñe ro're pʉʉ ñu'iʉ ija'che i'kaasomʉ: —Mʉ'ʉre vasoʉato vasojʉ̃'ʉ chʉ'ʉva'ʉre; vajʉra —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chikʉna Jesús repaʉ'te oiʉ repaʉni chẽakʉ i'kaasomʉ. —Jaʉ, vasora. Vajʉjʉ̃'ʉ —chiniasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jã'aja'ñe cho'oʉna asi teana peore ja'jusoasomʉ repaʉ ca'nivʉ pa'isi'e. ");
INSERT INTO coe_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Vaso pi'ni repaʉ'te ija'che chʉ̃'ʉasomʉ repaʉ: —Ñarepajʉ̃'ʉ. Chʉ'ʉ mʉ'ʉre vasosi'e pãi chekʉnare kʉamanejʉ̃'ʉ. Kʉama'ñe judío phairi'techi'a ñojaijʉ̃'ʉ mʉ'ʉ vajʉsica'nivʉ. Aperʉmʉ Moisés chʉ̃'ʉ jo'kasi'e cu'amajñarʉã sa ĩsijʉ̃'ʉ Diore, pãipi ña mʉ'ʉ vajʉsi'ere masia'jʉ —chini saoasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kʉamanejʉ̃'ʉ chiisi'eta'ni eta sani repaʉ'te cho'osi'e pãi ũcuanʉkore kʉaasomʉ repaʉ. Kʉaʉna pãi ũcuanʉko masijʉna vʉ'ñajoopoã tĩ'acu'aasomʉ Jesure, jainʉko pãi repaʉ'te ñañu chini chi'ijʉna. Jã'ajekʉna Jesús pãi peochejare sani paniasomʉ. Jã'ata'ni pãi si'ajoopoã raisina jainʉko repaʉ'te ñañu chini tuhaasome. ");
INSERT INTO coe_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te'eumucujña pa'isirʉmʉna Jesús Capernaum vʉ'ejoopo co'i pa'iʉna pãi asaasome repaʉ vʉ'e co'i pa'iche. ");
INSERT INTO coe_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Co'isi'ere asa pãi jainʉko repaʉ pa'ivʉ'ena sani chi'iasome. Pãipi jairepanʉko chi'irena Jesús pa'ivʉ'e timusoasomʉ. Ũcuaja'che jatisa'aro cacheja pãipi jairepanʉko rani timusoʉna kueñe pa'icu'aasomʉ repanare. Jã'aja'ñe pa'inani Jesús Dios chʉ'ore che'choasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Che'chotona ʉmʉpãi ũcuaka'chapana nʉka ku'imava'ʉre ũhikãa ũhikʉni Jesús pa'ivʉ'ena kuãijʉ raasome. ");
INSERT INTO coe_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rani tĩ'ato pãipi jairepanʉko pa'ijʉna repana Jesús nʉkacheja kueñe tĩ'acu'aasomʉ repanare. Jã'ajekʉna repavʉ'e sẽ'sevʉna mʉa ũcuachejapi coje racho ũcuacojepi repaʉ ũhikãapi Jesús ti'jñeñena caso ũhaasome repana repava'ʉre jũ'iva'ʉre. ");
INSERT INTO coe_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","“Iva'ʉre Jesús vasoja'mʉ”, chini cuasajʉ caso ũharena Jesús repana cuasasi'e ña i'kaasomʉ repava'ʉre. —Jmava'ʉ, mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ —chiniasomʉ Jesús repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Jã'aja'ñe i'kaʉna asa judíopãi che'chona te'ena, “¿Je'se pa'iʉna ikʉ jã'aja'ñe i'kakʉ? Dios asacuheche'te i'kamʉ ikʉ jã'a. Diochi'a pãi cu'ache cho'osi'e tʉnosõñe masikʉ'mʉ”, chiijʉ cuasaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jã'ata'ni Jesús repana cuasache'te ña masi ija'che i'kaasomʉ repanare: —¿Je'se pa'iʉna mʉsanʉkona jã'aja'ñe cuasache? ");
INSERT INTO coe_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chʉ'ʉ ikʉre, “Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ”, chiisi'ere asa, “Joreʉ'mʉ ikʉ. Pãi jã'aja'ñe cho'omasinajẽ'e peome”, chiijʉ cuasame. Jã'ata'ni chʉ'ʉpi ikʉre, “Vʉni mʉ'ʉ ũhikãa mini sajʉ̃'ʉ”, chikʉna ikʉpi vʉni nʉkakʉna ñani mʉsanʉkona, “Jorema'kʉa'mʉ Jesús. Repaʉ i'kasi'e ũcuarepa cho'omasimʉ”, chiijacosome. ");
INSERT INTO coe_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Chʉ'ʉ, pãire ja'me paaʉ chini Dios Raosi'kʉ chejare pa'iʉ pãi cu'ache cho'oche tʉnoñena'me pãi vasoche cho'omasiʉ pa'iche'te mʉsanʉkonapi ña masia'jʉ chini vasokaija'mʉ chʉ'ʉ ikʉre —chiniasomʉ repaʉ repanare. Chini Jesús nʉka ku'imava'ʉre ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Vʉni mʉ'ʉ ũhisikãa mini vʉ'ena co'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chikʉna nʉka ku'imanesi'kʉ vʉni repaʉ ũhisikãa mini repana pãi ũcuanʉko ñajʉ'te etaasomʉ. Jã'aja'ñe cho'oʉna ña jñano Dios cho'osi'ere cutujʉ ija'che i'kaasome repana: —Jmamakarʉjẽ'e ija'che cho'oche ñamanapi irʉmʉna ñame mai —chiniasome repana pãi. ");
INSERT INTO coe_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ũcuarʉmʉ Jesús jo'e Galilea chiara rʉ'tʉvana saniasomʉ. Ũcuachejare sani pa'iʉna pãi jainʉko repaʉni chi'ijʉna repanare che'chokʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Che'cho pi'ni Jesús ũcuachejapi sani Alfeo mamakʉ'te Levire pãi chʉ̃'ʉnare kuri kookaina pa'ivʉ'e ñu'ikʉni ña i'kaasomʉ. —Rani, chʉ'ʉni ja'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiniasomʉ. Chikʉna asa, “Jaʉ”, chini vʉni ũcuaʉna'me saniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na'a pa'isirʉmʉ Jesús repaʉ neenana'me Leví vʉ'ere pa'iʉ ãure ãiʉ paniasomʉ. Ũcuachi'a Roma vʉ'ejoopo chʉ̃'ʉnare kuri kookainana'me chekʉna pãi cu'ache cho'ona ja'me ñu'ijʉ ãure ãijʉ paniasome. Reparʉmʉ Jesure ja'me ku'ina rʉa jainʉko paniasome. ");
INSERT INTO coe_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Repanapi Jesuni ja'me ñu'ijʉna ña judíopãi che'chonana'me fariseopãi ija'che sẽniasaasome Jesús neenare: —¿Je'se pa'iʉna mʉsanʉkonare paakʉ kuri kookainana'me cu'ache pa'inare ja'me ãu ãikʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chitena asa Jesús ija'che i'kaasomʉ repanare: —Pãi vajʉna ʉ̃ko cho'oche chiima'me. Jũ'iva'nata'ni ʉ̃ko cho'oche chiime. Chʉ'ʉ ũcuaja'che pãi, “Re'onaa'me chʉkʉna”, chiinani, “Cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉma'mʉ icheja cheja. Pãi, “Cu'ache pa'inaa'me chʉkʉna”, chiiva'narechi'a, “Mʉsanʉkona cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ũcuarʉmʉ Juan neena Dioni sẽejʉ te'eñoã ãu ãima'ñe paniasome, fariseopãi neena ũcuaja'che. Jã'aja'ñe cho'ojʉna pãi chekʉna Jesús pa'ichejana sani ija'che sẽniasaasome repaʉ'te: —Juan neena Dioni sẽejʉ te'eñoã ãu ãima'ñe pa'ijʉasome, fariseopãi neena ũcuaja'che. Mʉ'ʉ neena, ¿je'se pa'iʉna jã'aja'ñe cho'ojʉ pa'ima'ñe? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chitena Jesús ija'che i'kaasomʉ repanare: —Pãi romi vejani majapãina'me repanare kueñe pa'inare peore soni chi'i ãu ãime. Romi vejakʉ pa'iʉna ãu ʉ̃secu'amʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na'a pa'isirʉmʉ repaʉ'te chekʉnapi sasõjanaa'me chekʉchejana. Jã'arʉmʉta'ni repaʉni oijʉ ãu ãimairo pa'ijanaa'me repana —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Reparʉmʉ pãi te'ena aperʉmʉ che'chosi'ena'me mama che'choche ũcuapa'rʉva cuasañu chini aperʉmʉ che'chosi'e ũhacuheasome. Chekʉnata'ni mama che'choche asacuheasome. Jã'ajekʉna Jesús repanani chʉ'vakʉ ija'che i'kaasomʉ: —Aikãarʉji che'resõru mamase'rechoji che're aikãana põ juhamanaa'me pãi. Jã'aja'ñe juha pi'ni choaru aikãarʉ mamase'recho põ juhasikãarʉjekʉ rueni ji'rosõʉna na'a ʉjacoje che'remʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ũcuachi'a pĩsi ʉche cono mama cho'oni va'iva'na ca'nituru aituruna ro'vemanaa'me pãi. Aituruna ro'veru conopi kosani saʉ che'resõ turujẽ'e cho'osõkʉ pĩsi ʉche cono ũcuaja'che cho'osõmʉ. Jã'ajekʉna pãi pĩsi ʉche cono mama cho'oni turu mamaturuna ro'veme. Mamaturuta'ni che'rema'ñe rupʉ saʉmʉ. Jã'ajekʉna cono kosa ñu'iʉ ja'ñʉsõma'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ũcuarʉmʉ Jesús pʉaumucusena repaʉ neenana'me trigo chiopi saijʉ paniasome. Saijʉ repaʉ neena trigocha'charʉã pura ãniasome. ");
INSERT INTO coe_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jã'aja'ñe cho'ojʉna ña fariseopãi i'kaasome repaʉ'te. —Ñajʉ̃'ʉ. ¿Je'se pa'iʉna mʉ'ʉ neena pʉaumucuseta'ni cho'oche cho'oche? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chitena, —¿Aperʉmʉ pa'isi'kʉ David cho'osi'ere kʉajʉ mai aipãi tocha jo'kasi'e ñamanaa'ñe mʉsanʉkona? Ija'che kʉamʉ repa: ");
INSERT INTO coe_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar judío phairipãi ũcuanʉko chʉ̃'ʉrʉmʉ David repaʉ'te ja'me pa'inana'me ãucuhakʉna Dios vʉ'ena kaka Diopi pojoa'kʉ chini judío phairipãi tʉosi'ere pã mini ãiʉ repaʉ'te ja'me pa'inare ãukʉ ãniasomʉ. Dios phairipãichi'a ãijʉ̃'ʉ chiisi'ere ãnisõasomʉ repaʉ David, chiimʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ repanare: —Aperʉmʉ Dios pãi ũcuanʉkore pʉaumucujña jo'kaasomʉ. Chareparo Dios pãire cho'oasomʉ. Repanare cho'o pi'ni pʉaumucujña jo'kaasomʉ, pʉaa'jʉ chini. Pa'ivesache'te jo'kamaʉ pa'ire'oumucujñachi'a jo'kaasomʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jã'ata'ni chʉ'ʉni Dios Raosi'kʉni pʉaumucusena cho'oche'te chʉ̃'ʉto re'omʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ũcuarʉmʉ Jesús judíopãi chi'ivʉ'e jo'e kakaasomʉ. Kaka ñato pãiʉ ũcuavʉ'ere cu'ajʉ̃tʉrʉ paakʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Repavʉ'e chi'isina pãi Jesure rʉa pãiñaasome. “¿Jesús iumucuse pʉaumucusena cu'ajʉ̃tʉrʉ paakʉ'te vasoja'ʉ?”, chini ñaasome repana. Repaʉji cho'oʉna ña repaʉni cu'ache i'kañu chini cha'aasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ũcuarʉmʉ Jesús cu'ajʉ̃tʉrʉ paakʉ'te ija'che i'kaasomʉ: —Vʉni rani pãi chenevʉ'te nʉkajʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chini chekʉnare pãi ija'che i'kaasomʉ repaʉ:— Pʉaumucujñana chekʉnani re'oja'che cho'okaito, ¿re'okʉ? Jã'apãani, ¿cu'ache cho'ore'okʉ? Ũcuachi'a, ¿chekʉnare vasore'okʉ? Jã'apãani, ¿vanisõre'okʉ repanare? —chiniasomʉ Jesús. Chiito i'kamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jã'ajekʉna Jesús repanare pe'rukʉ ñaasomʉ. Pãi oimanajejʉna rʉa sʉmaneasomʉ repaʉ'te. Ũcuarʉmʉ Jesús cu'ajʉ̃tʉrʉ paakʉ'te jo'e ija'che i'kaasomʉ: —Mʉ'ʉ jʉ̃tʉ saʉjʉ̃'ʉ —chiniasomʉ. Chikʉna saʉʉna repajʉ̃tʉ teana re'ojajʉ̃tʉ care'osoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ũcuarʉmʉ fariseopãi Jesupi jã'aja'ñe cho'oʉna ña ũcuavʉ'epi eta mʉa, Jesure vanisojachere care'vañu chini Herode'te pãi chʉ̃'ʉkʉ'te chiinana'me chi'i cutuasome. ");
INSERT INTO coe_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ũcuarʉmʉ Jesús repaʉ neenana'me vʉ'ejoopo eta chiara rʉ'tʉvana saniasomʉ. Repaʉ sanisosirʉmʉ pãi rʉa jainʉko Galilea cheja cana tuhaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Chekʉna pãi ũcuaja'che repaʉ cho'osi'ere asa rʉa jainʉko tuhaasome repaʉ'te, Judea cheja cana, chekʉna Jerusalén vʉ'ejoopo cana, chekʉna Idumea cheja cana, Jordán chiacha chekʉkã'ko cana, Tiro vʉ'ejoopo cana, Sidón vʉ'ejoopo cana. ");
INSERT INTO coe_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ũcuarʉmʉ Jesús pãipi jairepanʉko pa'ijʉ repaʉni rʉa tĩ'tijʉna, “Choovʉ care'vakaijʉ̃'ʉ chʉ'ʉre”, chiniasomʉ repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Repaʉ pãi jainʉko jũ'inare vasosi'kʉjekʉna chekʉna jũ'iva'na repaʉ'te tĩ'a kueñe raniasome chẽse vajʉñu chini. ");
INSERT INTO coe_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ũcuachi'a vati paana Jesuni ña repaʉ ti'jñeñena ro're pʉʉ ñu'ijʉ ʉjachʉ'opi cuijʉ ija'che i'kaasome: —Dios Mamakʉ'mʉ mʉ'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jã'aja'ñe i'kato, jo'e i'kache ʉ̃seasomʉ Jesús repanare, repaʉ pa'iche'te kʉamanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ũcuarʉmʉ Jesús aikũtina mani pa'iʉ ʉmʉpãire repaʉ'te ʉanarechi'a soniasomʉ. Sokʉna saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Satena Jesús docerepanare chẽaasomʉ, repaʉ'te ja'me pa'ijanare, Dios chʉ'ore chʉ'vaa'jʉ chini repaʉ saojanare. ");
INSERT INTO coe_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chẽa jũ'iva'nare vasomasichena'me, vati eto saomasiche chʉ̃'ʉ jo'kaasomʉ Jesús repanare, sani cho'ojʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Repaʉ chẽa jo'kasina docerepana mamia'me ie: Charo Simonni chẽaasomʉ repaʉ. Chẽa Jesús repaʉ'te jo'e mami cheke Pedro'te ve'oasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo mamachĩi ũcuachi'a Santiagona'me Juanre chẽaasomʉ repaʉ. Chẽa repanare cheke mami Boanerge'te ve'oasomʉ repaʉ. “Boanerges” chini “Oko curu chĩiva'na” chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ũcuaja'che Andrere, Felipe'te, Bartolomere, Mateo'te, Tomare, chekʉre Santiago'te Alfeo mamakʉ'te chẽaasomʉ. Tadeo'te ũcuachi'a chẽaasomʉ repaʉ. Chekʉre Simonre ũcuachi'a cananistapãi ja'me pa'ikʉ'te chẽaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ũcuachi'a Judas Iscariote'te chẽaasomʉ repaʉ. Na'a pa'isirʉmʉ repaʉ Judas Iscariote Jesuni cu'ache cho'oa'jʉ chini chekʉnani ĩsiasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ũcuarʉmʉ Jesús repaʉ neenana'me vʉ'ena kakaasomʉ. Kaka pa'iʉna, jainʉko pãi jo'e chi'iasome repaʉ'te. Jainʉko chi'irena ãu ãicu'aasomʉ repaʉ'te repaʉ neenare ũcuachi'a. ");
INSERT INTO coe_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ũcuarʉmʉ Jesús majapãi repaʉ cho'okʉ pa'iche'te asa, “Vẽ'veʉ cho'osõcosomʉ repaʉ”, chini cuasa saniasome repaʉni chẽa tĩichejana sañu chini. ");
INSERT INTO coe_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ũcuarʉmʉ judíopãi che'chona Jerusalén vʉ'ejoopo raisina Jesure cu'ache cutuasome. —Vati chʉ̃'ʉkʉ'te Beelzebu'te, ca'nivʉ'te paamʉ Jesús. Ũcuaʉji cho'okaiʉna vati ũcuajanare eto saomasimʉ repaʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jã'aja'ñe i'karena asa Jesús repanare soni ija'che i'kaasomʉ chʉ'vara chini: —Vati ai ũcuaja'iʉ'te, ¿je'se eto saokʉ? ");
INSERT INTO coe_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pãi ũcuate'echeja pa'inapi sãiñechi'a cavani vaijʉ si'asõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ũcuachi'a majapãichi'api ũcuate'evʉ'e pa'inapi sãiñechi'a cavani majapãi sẽjosõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ũcuachi'a vati aipi repaʉ neenana'me sãiñechi'a cavato repaʉ chʉ̃'ʉñe si'asõmʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Pãiʉ rʉa kokaʉji repaʉ vʉ'ere pẽ'jeto ñaacu'amʉ repaʉ cu'amajñarʉã. Charo repaʉni chẽa quẽo sʉotota'ni repaʉ neemajñarʉã tʉtesõre'omʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ũcuarʉmʉ Jesús judíopãi che'chonare jo'e ija'che i'kaasomʉ: —Ie chʉ'o ũcuarepare i'kamʉ chʉ'ʉ mʉsanʉkonare: Dios, pãi cu'ache cho'osi'ena'me cu'ache cutuche si'ache tʉ'nesõja'mʉ. Tʉ'nesi'e jo'e cuasamaneja'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Repaʉ Rekocho'te cu'ache cutusi'eta'ni jmamakarʉjẽ'e cavesʉma'ñe cuasakʉ ro'iche chʉ̃'ʉja'mʉ Repaʉ. Jã'are ai cuasakʉ pa'ija'mʉ Repaʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Repana judíopãi che'chona, “Jesús vatire paamʉ”, chiijʉna jã'aja'ñe i'kaasomʉ repaʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ũcuarʉmʉ Jesús pʉka'ko repaʉ cho'jechĩina'me ũcuaʉ pa'ivʉ'ena rani tĩ'a ve'sena canʉkaasome. Ve'sere pa'ijʉ chekʉnapi kaka repaʉ'te soikaapʉ chini i'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ũcuarʉmʉ pãi Jesuna'me rʉa jainʉko chi'i rũhiso'koro ñu'inapi ija'che i'kaasome repaʉ'te: —Mʉja'ko, mʉche'ʉchĩina'me mʉ'ʉre ku'ejʉ raisina ve'sere pa'ime —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chitena Jesús ija'che i'kaasomʉ repanare: —¿Kaoa'o chʉ'ʉ ja'ko? ¿Keejanaa'ñe chʉ'ʉ cho'jechĩi? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chini pãi repaʉ'te chi'i ñu'inani ñakʉ i'kaasomʉ repaʉ. —Inaa'me chʉ'ʉ ja'koromijana. Ũcuachi'a inaa'me chʉ'ʉ cho'jechĩijana. ");
INSERT INTO coe_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dios chʉ̃'ʉñe asa jachama'ñe cho'ona chʉ'ʉ cho'jechĩijanaa'me. Ũcuaja'che chʉ'ʉ ja'koromijanaa'me repana —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ũcuarʉmʉ Jesús chiara rʉ'tʉva'te pa'iʉ jo'e chʉ'vakʉna rʉa jainʉko pãi repaʉ pa'ichejana chi'iasome. Pãipi jairepanʉko rani chi'irena choovʉna tuni pʉʉasomʉ repaʉ. Pãita'ni chiara rʉ'tʉva'te paniasome. ");
INSERT INTO coe_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ũcuarʉmʉ Jesús choovʉ'te ñu'iʉ repanani chʉ'vakʉ ija'chere cuasakʉ rʉa kʉaasomʉ: ");
INSERT INTO coe_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Asarepajʉ̃'ʉ, mʉsanʉkona. Pãiʉ trigo'te chu'chura chini chiona saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sani tĩ'a pachu ku'iʉ chu'chukʉna trigocaã te'era'karʉã ma'ana tuã'tuaasomʉ. Ma'ana tuã'tuaʉna pĩ'ava'napi rani ãkuesõasome repara'karʉã. ");
INSERT INTO coe_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chekʉra'karʉãta'ni cata pa'ichejana cha'o jmamakarʉ pa'ichejana tuã'tuaasomʉ. Cha'o sẽ'serʉchi'a pa'ichejata'ni na'mi aineeasomʉ repara'karʉã. ");
INSERT INTO coe_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na'mi aineesi'eta'ni ʉ̃sʉʉji rʉarepa asukʉna uu phã'pha jũnisõasomʉ repasañarʉã, chitapi peokʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chekʉra'karʉã miu pa'ichejana tuã'tua miuna'me ainee miupi ju'je vẽasõʉna trigo kʉ̃imaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Chekʉra'karʉãta'ni re'oja'che cha'o pa'ichejñana tuã'tuasira'karʉãjekʉ re'oja'che ainee ju'a ñaniasomʉ. Te'era'karʉ aineesi'ñʉ te'echa'chava treintarepara'karʉã pa'icha'cha ju'a ñaniasomʉ. Chekʉra'karʉã aineesiñʉã sesentarepara'karʉã pa'icha'cha ju'a ñaniasomʉ. Chekʉra'ñʉrʉã cienrepara'karʉã pa'icha'cha ju'a ñaniasomʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ũcuarʉmʉ Jesús repanare pãi ija'che i'kaasomʉ: —Chʉ'ʉ chʉ'vache asa chẽa cho'oʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Repana pãi sanisosirʉmʉ Jesús te'eʉ pa'iʉna repaʉ neenana'me chekʉna repaʉ'te chiina repaʉ cuasakʉ kʉasi'e asavesʉjʉ te'erũhiñe kʉaa'kʉ chini sẽniasaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sẽtena Jesús ija'che i'kaasomʉ repanare: —Mʉsanʉkonani chʉ'ʉ neenajejʉna Diopi ʉ̃semaʉna Repaʉchi'a masiche te'erũhiñe kʉamʉ chʉ'ʉ, asamasia'jʉ chini. Jã'ata'ni chekʉnare chʉ'ʉre cuasacuhenare Repaʉchi'a masiche chʉ'ʉ cuasacheji kʉamʉ chʉ'ʉ, asanata'ni asavesʉa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ñanata'ni ñamanesina pa'icheja'che pa'ijanaa'me repana. Ũcuaja'che asanata'ni asavesʉjanaa'me repana. Pãi chʉ'ʉ chʉ'o asa chẽa repana cu'ache cho'oche'te ũhasõru Dios repana rekoñoã cu'ache pa'iche tʉnosõ jo'e cuasamaneja'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ repanare: —¿Chʉ'ʉ cuasakʉ kʉasi'e asavesʉche mʉsanʉkona? Jã'a pa'ito chʉ'ʉpi jo'e cuasakʉ kʉato, ¿je'se asamasijanaa'ñe mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ija'chea'me jã'a chʉ'ʉ cuasakʉ kʉasi'e: Trigo chu'chuna chio si'acachio ku'ijʉ chu'chume. Dios chʉ'o chʉ'vana ũcuaja'che chejña si'achejña ku'ijʉ Dios chʉ'o pãi ũcuanʉkore chʉ'vame. Trigo chu'chucheja'chea'me Dios chʉ'o chʉ'vache. ");
INSERT INTO coe_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Trigora'karʉã te'era'karʉã ma'ana tuãni chejapi rʉarepa jʉjakʉna kakama'mʉ. Trigocaã chu'chusicaã chejapi rʉarepa jʉjakʉna kakama'ñeja'ñe pãi te'enare repana rekoñoã Dios chʉ'o kakama'mʉ. Asanareta'ni vati aipi ʉ̃semʉ repanare, Dios chʉ'o asa chẽamanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ũcuachi'a cata pa'ichejña tuã'isicaã na'mi aineesi'eta'ni chita saimaʉ na'mi jũnisõmʉ. Pãi ũcuachi'a te'ena Dios chʉ'o asa teana pojojʉ cuasame. ");
INSERT INTO coe_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jã'ata'ni repanapi Dioni cuasajʉna pãipi cu'ache i'kajʉna chekʉrʉmʉ repanani cu'ache ti'jñekʉna masi cuasamanajejʉ Dios chʉ'o repana cuasache na'mi jo'kasõme. ");
INSERT INTO coe_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ũcuachi'a miu pa'ichejña tuã'tuasira'karʉã miuna'me aineemʉ. Jã'ajekʉna miu sũkipi ju'jekʉna kʉ̃ima'ñe jũnisõmʉ repara'ñʉrʉã. Pãi ũcuachi'a te'ena Dios chʉ'o asa chẽa Repaʉ chʉ̃'ʉñe cho'onata'ni ũhasõme. Repana cho'oche'te kurina'me põsere cheke si'ache rʉarepa cuasajʉ Dios chʉ'o repana asa chẽa cuasache cavesʉ ũhasõme. ");
INSERT INTO coe_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ũcuachi'a cheja re'ojachejana tuã'tuasicaã re'oja'che ainee re'oja'che kʉ̃iñeja'ñe re'oja'che pa'ime pãi. Dios chʉ'o asa chẽa Repaʉ chʉ̃'ʉ jo'kasi'e cho'ojʉ pa'ime. Repana te'ena trigoñʉ treintarepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe re'oja'che pa'ime repana rekoñoã. Chekʉna sesentarepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe na'a rʉa re'oja'che pa'ime. Chekʉna cienrepara'karʉã pa'icha'chava ju'a ña'isi'ñʉãja'ñe jo'e na'a rʉa re'oja'che pa'ime Repaʉ chʉ̃'ʉñe cho'ona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare. —Pãiʉ ʉotʉopʉ ra chʉ̃oni totoroji jao nʉkoma'mʉ. Ũcuaja'che kãiko'a vʉ'evʉna nʉkoma'mʉ. Jã'aja'ñe cho'oma'ñe ʉotʉopʉ chʉ̃oni ʉmʉna tʉomʉ re'oja'che miañe ñoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Diopi ʉ̃sekʉna pãi Repaʉ chʉ'o asavesʉsi'e na'a pa'isirʉmʉ peore rũhiñe kʉaja'mʉ Repaʉ, asamasia'jʉ chini. Ũcuachi'a Repaʉchi'a masiche na'a pa'isirʉmʉna peore kʉaja'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chʉ'ʉ i'kache asa chẽa cho'oʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare. —Chʉ'ʉ chʉ'vache cuasarepajʉ pa'ijʉ̃'ʉ. Mʉsanʉkona chʉ'ʉ chʉ'vache asa chẽa jachama'ñe cho'ojʉ pani chʉ'ʉpi cho'okaiʉna si'arʉmʉ na'a rʉa masina pa'ijanaa'me. Asa jachani vesʉjanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pãi, chʉ'ʉ chʉ'vache asa jachamana si'arʉmʉ na'a rʉa re'oja'che pa'ijanaa'me. Cho'okaija'mʉ chʉ'ʉ repanare, chʉ'ʉ chʉ'vache'te na'a rʉa masia'jʉ chini. Jã'ata'ni chekʉna chʉ'ʉ chʉ'vache asanata'ni masi cuasamapʉ chʉ'ʉpi cho'okʉna repana jmamakarʉ masiche cavesʉsõjanaa'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ũcuarʉmʉ Jesús repanare pãi jo'e chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ: —Dios chʉ̃'ʉñe cho'ona pa'iche ija'chea'me: Pãiʉ otera'karʉã tãasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tã pi'ni ñami kãimʉ repaʉ. Kãni vʉni jo'e cho'oche cho'omʉ. Jo'e na'iʉna jo'e kãimʉ repaʉ. Jã'aja'ñe cho'oto si'arʉmʉ ñami umucujña repaʉ tãsi'e aineekʉ pa'imʉ. Tãsi'e ñoma'ñe aineeñe vesʉmʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Charo repara'ñʉrʉã aineemʉ. Cho'je repara'ñʉrʉã ju'a ña'imʉ. Ju'a ñani repara'karʉã pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pa'iʉna tãsi'kʉ va'tipi repara'ñʉrʉã verisõmʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ũcuarʉmʉ Jesús repanare pãi jo'e ija'che chʉ'vaasomʉ: —Dios chʉ̃'ʉñe cho'ona, ¿keeja'cheja'che pa'iche? Repana pa'iche'te kʉara chini, ¿keeja'chere cuasakʉ kʉaja'che chʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ija'chere kʉara: Mostazara'karʉã rʉa jmara'karʉãa'me. ");
INSERT INTO coe_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jã'ata'ni pãipi tãru sũkiñʉã ʉjañʉãpi ka ʉjaka pa'iñʉã aineeʉna pĩ'ava'na ũcuaka vʉ'evʉãre chʉ'rʉjachejñare tuhijʉ pa'ime —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús repanare pãi chʉ'vakʉ repana asamasichetʉ'ka cuasakʉ kʉaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Repanare chʉ'vakʉ cheke i'kama'ñe ũcuaʉ cuasachechi'a kʉaasomʉ repaʉ. Jã'ata'ni chekʉna pãi peorʉmʉ repaʉ neenare repaʉ kʉasi'e te'erũhiñe kʉaasomʉ, asamasia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ũcuaumucuse na'icuhatona Jesús repaʉ neenare ija'che i'kaasomʉ: —Ira chiara chekʉkã'kona jẽñu mai —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chikʉna repanare pãi jo'ka repaʉ neenapi Jesure choovʉ pa'ikʉ'te jẽaasome. Jẽajʉna pãi chekʉna chekʉvʉãpi ja'me jẽniasome. ");
INSERT INTO coe_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jẽ'ejʉna chiara tutakʉ fa'akʉ ja'ñʉkʉ choovʉ oko timusopi'raasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jã'aja'ñe cho'okʉ pa'ito Jesús choovʉ tʉtipʉ kãiʉ paniasomʉ kãipʉji ũhiʉ. Choovʉji runisocuhakʉna ũcuaʉ ũhichejana mʉa ija'che i'ka vʉoasome repaʉ'te: —¡Masiʉ, runisõcuhame mai! ¿Chʉkʉna'te oima'kʉ mʉ'ʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chitena jñano vʉni tutachena'me chiara fa'ache'te ija'che i'kaasomʉ repaʉ: —¡Tutachena'me fa'ache cuhajʉ̃'ʉ! —chiniasomʉ repaʉ. Chikʉna tutachena'me fa'ache teana ũcuapa'rʉva cuhaasomʉ. Jo'e re'oja'ira cuhaasomʉ chiara. ");
INSERT INTO coe_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jã'aja'ñe cho'ocuha Jesús repaʉ neenare i'kaasomʉ. —¿Je'se pa'iʉna mʉsanʉkonare rʉarepa vajʉchʉakʉ? Chʉ'ʉre masi cuasama'me mʉsanʉkona —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chikʉna vajʉchʉjʉ rʉa cuasajʉ sãiñechi'a sẽniasaasome repana. —¿Keeja'iʉjekʉ ikʉ jã'aja'ñe cho'okʉ? Ikʉpi chʉ̃'ʉʉna tutasi'e cuhasõmʉ, fa'asi'ejẽ'e ũcuaja'che —chiniasome repana Jesús neena. ");
INSERT INTO coe_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ũcuarʉmʉ Jesús repaʉ neenana'me chiara chekʉkã'ko cacheja Gadara chejana jẽni tĩ'a matena pãiʉ vatire paakʉ eta tijñaasomʉ Jesure. ");
INSERT INTO coe_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Repaʉ si'arʉmʉ pa'ichejapi pãi tãchejñapi etaasomʉ. Repaʉ'te pãi chẽañu chiito chẽacu'aasomʉ. Cʉnamejẽ'e repaʉ'te vẽecu'aasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pãi repaʉ'te rʉarepañoã cʉnameãpi vẽesi'eta'ni si'arʉmʉ cũ'a jʉ̃jña vẽesi'e tʉteso repaʉ'te vẽesimeã jmarĩirʉã tʉtesoasomʉ repaʉ. Jmamakarʉjẽ'e chẽacojñomaneasomʉ repaʉ. Chẽacu'aasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Si'aumucujña si'añami aikũjñana'me pãi tãchejñare peore ku'iʉ cuikʉ catapʉãpi meñe asi vaiʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesupi Gadara chejana repaʉ pa'ichejana tĩ'aʉna so'opi ña vatire paakʉ Jesús nʉkachejana raniasomʉ. Vʉ'vʉ rani Jesús ti'jñeñena ro're pʉʉ ñuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ro're pʉʉ ñu'iʉna Jesús ija'che i'kaasomʉ repaʉ'te: —Vati, ikʉre eta jo'ka saijʉ̃'ʉ —chiniasomʉ repaʉ. Jã'aja'ñe chikʉna vatire paakʉ cuikʉ i'kaasomʉ repaʉ'te: —Jesús, Cʉnaʉmʉ Pa'ikʉ Dios Mamakʉ, ¿ʉ̃que raikʉ mʉ'ʉ? Dios ñakʉ'te ie sẽemʉ chʉ'ʉ mʉ'ʉre: Asi cho'omanejʉ̃'ʉ chʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chikʉna Jesús vatire ija'che i'kaasomʉ: —¿Ʉ̃quemamiʉ'ʉ mʉ'ʉ? —chiniasomʉ repaʉ'te. —Chʉkʉna jainʉko pa'inajejʉ, Vati Kuanupʉ ve'eme —chiniasome vati. ");
INSERT INTO coe_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ũcuarʉmʉ vati rʉarepañoã i'kaasome Jesure— Chʉkʉna'te chekʉcheja saomanejʉ̃'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ũcuacheja kueñere aikũti caripa'te jo'chasẽse kuanupʉ ãure mu'kajʉ ãijʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ũcuarʉmʉ vati Jesure rʉa i'kaasome— Chʉkʉna'te etoni jo'chasẽse sa'navʉã kakache ʉ̃semanejʉ̃'ʉ; kakañu chʉkʉna —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jã'aja'ñe i'kajʉ rʉarepa sẽejʉna Jesupi, “Jaʉ”, chikʉna repana vati eta sani jo'chasẽseva'nani kakaasome. Vatipi kakarena jo'chasẽseva'na teana ũcuanʉko vʉ'vʉ aikũti ʉjakũti caripaji chiarana tuã'tua ru'tu jũnisoasome. Chekʉrʉmʉ jo'chasẽseva'na dos milrepana pa'icosome. ");
INSERT INTO coe_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jã'aja'ñe cho'orena ña repava'nare kuirasiva'na kʉañu chini vʉ'vʉsoasome vʉ'ejoopo canana'me repachejña po'ña canare. Kʉarena asa cho'osi'ere ñañu chini eta saniasome pãi. ");
INSERT INTO coe_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sani Jesús pa'ichejana tĩ'a, vati paasi'kʉre ñaasome repana. Kãa peosi'kʉ churata'ni kãa ju'iʉ ñuniasomʉ repaʉ. Ũcuaja'che vẽ've cho'osi'kʉpi rũhiñe cuasakʉna ña kʉkʉsoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ũcuarʉmʉ vati paasi'kʉre cho'osi'ena'me jo'chasẽse ru'isi'e ñasina chekʉnani kʉaasome. ");
INSERT INTO coe_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kʉarena asa pãi Jesure rʉa i'kaasome, —Icheja pa'ima'ñe saijʉ̃'ʉ mʉ'ʉ —chiijʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ũcuarʉmʉ Jesús co'ira chini choovʉna jo'e tuniasomʉ. Co'ipi'rakʉna vati paasi'kʉ repaʉ'te ja'me sasa chini rʉa sẽniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jã'ata'ni Jesús repaʉ'te saiche ʉ̃sekʉ ija'che i'kaasomʉ: —Mʉ'ʉ majapãi pa'ichejana sani mʉ'ʉre Dios cho'okaisi'ere kʉajʉ̃'ʉ. Dios mʉ'ʉre oiʉ cho'okaisi'ere kʉajaijʉ̃'ʉ repanare —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jã'aja'ñe i'kaʉna repaʉ vati paasi'kʉ vʉ'ñajoopoã Decápolis cheja cajoopoã dierepajoopoã ku'iʉ Jesús repaʉ'te cho'okaisi'ere peore ũcuajoopoã canare kʉaasomʉ repaʉ. Kʉaʉna pãi asa rʉa jñanoasome. ");
INSERT INTO coe_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jã'aja'ñe cho'ocuha Jesús choovʉji chiara chekʉkã'kona jo'e jẽni co'iasomʉ. Jẽni tĩ'a chiara rʉ'tʉva'te pa'iʉna pãi jainʉko chi'iasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Reparʉmʉ Jairo judíopãi chi'ivʉ'e chʉ̃'ʉkʉ Jesús pa'ichejana raniasomʉ. Rani tĩ'a Jesure ña repaʉ ti'jñeñe ro're pʉʉ ñuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ro're pʉʉ ñu'iʉ Jesure rʉa sẽniasomʉ, ija'che i'kakʉ: —Chʉ'ʉ chĩiva'o jũnisõpi'ramo. Sani repao'te chẽa vasokaijʉ̃'ʉ vajʉa'ko —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chikʉna asa Jesús ũcuaʉna'me saniasomʉ. Ũcuaja'che pãi jainʉko Jesuna'me saijʉ jʉjo jã'kejʉ saniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ũcuaja'che romio, docerepaʉ̃sʉrʉmʉ chie ravʉ jũ'iko ja'me paniasomo. ");
INSERT INTO coe_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʉ̃kochaipãi rʉa ʉ̃ko cho'ote'easome repao'te. Rʉa ʉ̃ko si'ache cho'ojʉna na'a rʉa jũniasomo repao. Ʉ̃kore kooko kuri peore repao paasi'e ro'isoasomo repao vajʉra chini. ");
INSERT INTO coe_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aperʉmʉ Jesús cho'oche pãi vasoche asasi'kojeko pãi kuanupʉ joopoji rani Jesús cho'jepi repaʉ ju'ikãana chẽaasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ija'che cuasaasomo repao: “Jesús ju'ikãa chẽanijẽ'e vajʉja'mo chʉ'ʉ”, chiio cuasako chẽaasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chẽaona chie raisi'e churata'ni teana cuhasoasomʉ repao'te. Cuhasoʉna repao vajʉsi'ere cuasaasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Vajʉona Jesús repaʉ repao'te vasosi'e repaʉ rekocho masikʉ chʉri peore repakã'jño ña sẽniasomʉ repaʉ. —¿Neepi chʉ'ʉ ju'ikãa chẽare? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chikʉna repaʉ neena ija'che i'kaasome repaʉ'te: —Pãiva'na si'acakã'jño tĩ'time mʉ'ʉre. Jã'ata'ni, “¿Neepi chʉ'ʉre chẽare?”, sẽniasamʉ mʉ'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Chiisi'eta'ni Jesús repaʉ'te chẽasi'kore ñara chini si'acakã'jño ñakʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ñakʉna repao jũ'isi'ko vajʉchʉko kurukuruo repao'te vasosi'e masiko rani repaʉ'te ti'jñeñe ro're ñu'io peore kʉaasomo repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kʉaona asa Jesús i'kaasomʉ repao'te. —Mʉ'ʉva'o, “Ikʉ chʉ'ʉre vasoja'mʉ”, chiio cuasasi'kojeko vajʉcuhasi'koa'mo mʉ'ʉ. Sani re'oja'che pa'ijʉ̃'ʉ chura —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Repaʉ Jesús chuta'a i'katona, pãi Jairo vʉ'e pa'isina rani i'kaasome Jairo'te. —Mʉ'ʉ chĩiva'o jũnisõcuhasi'koa'mo. Masiʉ'te jo'e i'kamanejʉ̃'ʉ —chiniasome repana Jairo'te. ");
INSERT INTO coe_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Repana i'kasi'e Jesús asa jachakʉ Jairo'te ija'che i'kaasomʉ: —Vajʉchʉmanejʉ̃'ʉ. Mʉ'ʉpi, “Chʉ'ʉ chĩiva'ore vasokaija'mʉ Jesús”, chiiʉ cuasato mʉ'ʉ chĩiva'o vajʉja'mo —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I'ka pi'ni Jairo vʉ'ena saniasomʉ repaʉ Pedrona'me Santiagona'me Santiago cho'jeʉ Juan. Pãi chekʉnare saiche ʉ̃seasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sani judíopãi chi'ivʉ'e chʉ̃'ʉkʉ vʉ'ena tĩ'a ñato pãi jainʉko pa'ijʉ rʉa asojʉ otapi oijʉ cuijʉ cho'oasome. ");
INSERT INTO coe_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ña kaka i'kaasomʉ repaʉ repanare. —¿Je'se pa'iʉna mʉsanʉkona rʉa ota oijʉ rʉa asojʉ cho'oche? Jũnisõsiva'oma'mo iko. Rupʉ kãisiva'oa'mo —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jã'aja'ñe i'kakʉna asa jachajʉ Jesure pãisoasome repana. Pãisojʉna repanare ũcuanʉkore etoasomʉ repaʉ. Etocuha repava'o pa'iruupʉna jũnisosiva'o pʉka'kʉpãina'me repaʉ'te ja'me pa'inare cuaakʉ kakaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kaka Jesús jũ'isiva'o jʉ̃tʉna chẽakʉ i'kaasomʉ. —Talita, cumi —chiniasomʉ Jesús repava'ore. (“Talita, cumi” chini “Romichĩiva'o, vʉni nʉkajʉ̃'ʉ” chiimʉ tĩichʉ'o.) ");
INSERT INTO coe_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jã'aja'ñe i'kaʉna repava'o docerepaʉ̃sʉrʉmʉ pa'iko vajʉrani teana vʉni nʉka kuniasomo. Vʉni nʉka ku'iona repana pãi ña kʉkʉsoasome. ");
INSERT INTO coe_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ũcuarʉmʉ Jesús repanare pãi rʉa chʉ̃'ʉasomʉ, —Iva'ore chʉ'ʉ vasosi'e chekʉnare pãi kʉamanejʉ̃'ʉ —chiiʉ. Ũcuachi'a repaoni ãure ãua'jʉ chini chʉ̃'ʉasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jã'aja'ñe cho'ocuha ũcuachejapi eta repaʉ pa'irepajoopona co'iasomʉ Jesús, repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Co'i pa'iʉ pʉaumucuse judíopãi chi'ivʉ'ena kaka che'choasomʉ repaʉ. Che'chokʉna pãi asa jñano i'kaasome. —¿Je'se cho'okʉ ikʉ repaʉ che'chomasiche che'cheʉ? ¿Neepi ikʉre che'chore? ¿Je'se cho'okʉ ikʉ Diochi'a cho'omasiche cho'oche che'cheʉ? ");
INSERT INTO coe_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ijoopo pa'ikʉ chooko'ña cho'okʉ'mʉ ikʉ Jesús. María mamakʉ'mʉ. Jã'ana Santiagona'me Josena'me Judana'me Simón majaa'chʉa'mʉ ikʉ. Repaʉ cho'jeromi ũcuaja'che ijoopo'te maina'me pa'ime —chiniasome repana. Jã'aja'ñe cuasanajejʉ repaʉ i'kache jachaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ũcuarʉmʉ Jesús repanare i'kaasomʉ. —Dios chʉ'o kʉakaikʉ aineesijoopo pa'inana'me repaʉ majapãichi'a repaʉ kʉache Dios chʉ'o asa jachame. Mʉsanʉkona ũcuaja'che ijoopo chʉ'ʉ aineesijoopo pa'ina chʉ'ʉ kʉache Dios chʉ'o asa jachame —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Repanapi repaʉni cuasamapʉna Diochi'a cho'omasiche rʉarepa cho'o ñomaneasomʉ Jesús repajoopo pa'irʉmʉ. Pãi jũ'iva'nare te'eva'nare jʉ̃jñapi chẽa vasoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Repana pãi repaʉ'te masi cuasama'ñere cuasakʉ jñanoasomʉ Jesús. Reparʉmʉ Jesús vʉ'ñajoopoã kueñe pa'ijoopoã ku'iʉ che'chokʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ũcuarʉmʉ Jesús repaʉ neenare docerepanare soni chi'i, —Mʉsanʉkona ũcuanʉko te'eka'chapanachi'a ũcuate'echeja sani chʉ'ʉpi cho'okaiʉna pãi sa'navʉã pa'inare vati peore eto saojanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mʉsanʉkonapi sani cu'amakarʉjẽ'e samanejʉ̃'ʉ. Jã'ata'ni mʉsanʉkona jʉ'vejʉ ku'iñoãchi'a sajʉ̃'ʉ. Ãujẽ'e samanejʉ̃'ʉ. Turu cu'amajñarʉã mañajaturujẽ'e samanejʉ̃'ʉ. Kurijẽ'e samanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cũ'akorophe're ju'ijʉ saijʉ̃'ʉ. Kãñajẽ'e samanejʉ̃'ʉ. Kãña sa'ñejʉ ju'ikãñajẽ'e sama'ñe mʉsanʉkona ju'ikãñarʉãchi'a ju'ijʉ ku'ijʉ̃'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repaʉ neenare. —Sani ku'ijʉ vʉ'ejoopo tĩ'ani mʉsanʉkonare chiina vʉ'ere canʉka pa'ijʉ̃'ʉ, tĩicheja saichetʉ'ka. ");
INSERT INTO coe_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chekʉrʉmʉ mʉsanʉkona saicheja pa'inapi mʉsanʉkonani cuaocuhejʉ Dios chʉ'ojẽ'e asacuheto mʉsanʉkona cũ'akorophe're chʉ̃'isi'ere cha'ore tĩ'to to'jñojʉ eta saijʉ̃'ʉ, pãipi ña repana cu'ache cho'osi'ere masia'jʉ. Dios pãi ũcuanʉkore chi'i ro'iumucuse tĩ'aru Sodoma vʉ'ejoopona'me Gomorra vʉ'ejoopo pa'isinare rʉa cu'ache ti'jñeja'mʉ. Jã'ata'ni mʉsanʉkona chʉ'vache asacuhesinare na'a rʉa cu'ache ti'jñeja'mʉ reparʉmʉ. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jã'aja'ñe chʉ̃'ʉʉna Jesús neena sani ku'ijʉ pãipi repana cu'ache cho'oche'te ũhasoa'jʉ chini chʉ'vaasome. ");
INSERT INTO coe_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ũcuachi'a vatire pãi sa'navʉã pa'inare eto saosokaniasome repana. Ũcuachi'a ravʉ jũ'inare u'chape'era'kapi jmara'karʉji ro've vasoasome repana repanare pãi. ");
INSERT INTO coe_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ũcuarʉmʉ Herodes pãi chʉ̃'ʉkʉ Jesús cho'oche asaasomʉ, Jesús cho'oche'te pãi jainʉko masijʉ kʉajʉna. Jã'aja'ñere asa ija'che i'kaasomʉ repaʉ: —Juan Pãi Okoro'vesi'kʉ chʉ'ʉpi chʉ̃'ʉʉna chuenisõsi'kʉpi jũni vajʉrani pa'icosomʉ jã'ʉ. Jã'aja'ñejekʉna Diochi'a cho'omasiche cho'omasicosomʉ repaʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Chekʉnata'ni ija'che i'kaasome: —Aperʉmʉ Dios chʉ'o kʉasi'kʉpi Elíapi jo'e vajʉrani pa'imʉ jã'ʉ —chiniasome repana. Jo'e chekʉnata'ni ija'che i'kaasome: —Aperʉmʉ Dios chʉ'o kʉasina kʉasi'eja'che Dios chʉ'o kʉakʉ'mʉ jã'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Repana i'kasi'e asa Herodes ija'che i'kaasomʉ: —Juancosomʉ repaʉ. Aperʉmʉ chʉ'ʉpi repaʉ sĩjopʉ tʉsosõñe chʉ̃'ʉʉna jũnisõsi'kʉta'ni jo'e vajʉrani pa'icosomʉ jã'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Aperʉmʉ repaʉ Herodes repaʉ cho'jeʉ Felipe rʉ̃joni Herodíani tʉa veja paakʉna Juan asa, “Mʉche'ʉ paako'te tʉa paakʉ Dios ʉ̃seche'te cu'ache cho'omʉ mʉ'ʉ”, chiiʉ chʉ'vaasomʉ repaʉ'te. Jã'aja'ñe chʉ'vakʉna Herodes asa pe'rukʉ repaʉ'te Juanre chẽa cʉnameji quẽo pãi chẽavʉ'ena sa cuaoa'jʉ chini chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Jã'ajekʉna Herodías Juan i'kasi'ere asacuheasomo repaʉ'te. Cuheko Juanre vanisoche chʉ̃'ʉra chiniasomo repao. Jã'ata'ni Herodes ʉ̃seasomʉ. Repaʉ Herodes Juanni vajʉchʉkʉ ija'che cuasaasomʉ: “Repaʉ Juan rʉa re'okʉ'mʉ. Cu'ache cho'oma'mʉ repaʉ”, chiiʉ cuasaasomʉ. Ũcuachi'a Juan chʉ'vache'te asa, “¿Cho'oja'che chʉ'ʉ? ¿Pãaja'ñe?”, chiiʉ cuasaasomʉ repaʉ. Jã'ata'ni rʉa asara chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ũcuarʉmʉ Juanre vanisorʉmʉ churata'ni tĩ'aasomʉ Herodía'te. Herodes repaʉ'te jñaasiumucusejarʉmʉjekʉna ãure ãura chini repaʉ'te ja'me chʉ̃'ʉnana'me sõtaopãi chʉ̃'ʉnana'me pa'ipãi Galilea cheja canare soniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Reparʉmʉ fiesta'te cho'ojʉna Herodías mamako repana ãu ãiruupʉna kaka pãi jainʉko ñajʉ'te eta te'eo ujacha'iasomo. Jã'aja'ñe cho'okona ña Herodes rʉa pojoasomʉ repao'te, repaʉna'me ãu ãina ũcuaja'che. Repaoni pojokʉ repao'te i'kaasomʉ repaʉ. —Mʉ'ʉre ʉache sẽejʉ̃'ʉ chʉ'ʉre. Mʉ'ʉ sẽeñe ũcuaʉache ĩsija'mʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ũcuachi'a repao'te ija'che i'kaasomʉ repaʉ:— Chʉ'ʉ neechejña chʉ'ʉ chʉ̃'ʉkʉ pa'ichejña joopojatʉ'ka ĩsija'mʉ chʉ'ʉ mʉ'ʉre. Diopi ñakʉna ũcuarepa chʉ'o i'kamʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chikʉna eta pʉka'koni sẽniasomo repao. —¿Ʉ̃quere repaʉ'te sẽeja'ñe chʉ'ʉ? —chiniasomo. Chikona pʉka'ko ija'che i'kaasomo: —Juan Pãi Okoro'vekʉ sĩjopʉ tʉsoche'te sẽejʉ̃'ʉ repaʉ'te —chiniasomo pʉka'ko. ");
INSERT INTO coe_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chikona asa na'mi sani Herodes pa'iruupʉna jo'e kaka ija'che i'kaasomo repao repaʉ'te: —Juan Pãi Okoro'vekʉ sĩjopʉ'te tʉso cʉnare'avana maña teana ra ĩsijʉ̃'ʉ chʉ'ʉre —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Repao sẽeñe'te asaʉna Herode'te rʉa sʉmaneasomʉ. Jã'ata'ni repaʉ soicojñosina asajʉ'te, “Ũcuarepare i'kamʉ chʉ'ʉ”, chiisi'kʉjekʉ ũcuare ra ĩsia'jʉ chini chʉ̃'ʉasomʉ repaʉ. Pãipi, “Joreʉ'mʉ ikʉ”, chiimanea'jʉ chini, repao sẽesi'e ʉ̃secuheasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jã'aja'ñejekʉna sõtao'te repavʉ'e pẽ'jekaikʉ'te, “Sani Juan sĩjopʉ tʉsojʉ̃'ʉ”, chiiʉ chʉ̃'ʉasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chʉ̃'ʉʉna pãi chẽavʉ'ena sani Juan sĩjopʉ tʉsocuha cʉnare'avana maña ra romichĩioni ĩsiasomʉ. Ĩsiʉna koo pʉka'koni jo'e sa ĩsiasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ũcuarʉmʉ repaʉ Juan neena pa'isina repaʉ'te vanisosi'ere asa pãi chẽavʉ'ena sani repava'ʉre sa tãasome. ");
INSERT INTO coe_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jã'a cho'o pi'nisirʉmʉ Jesús neena, repaʉ saosina rani repana cho'osi'ena'me repana che'chosi'e peore kʉaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Reparʉmʉ pãipi jairepanʉko repana pa'ichejana raijʉna ãu ãicu'aasomʉ repaʉ'te Jesure, repaʉ neenare ũcuachi'a. Jã'aja'ñe cho'ojʉna Jesús repaʉ neenare ija'che i'kaasomʉ: —Jʉna, sañu mai. Pãi peochejana sani jmamakarʉ pʉañu —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ũcuarʉmʉ Jesús ũcuachejapi repaʉ neenana'me choovʉ tuni pãi peochejana chiara chekʉkã'kona jẽniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jã'ata'ni pãi jainʉko vʉ'ñajoopoã chekʉjoopoã pa'ina Jesuni ña masijʉ repara chekʉkã'kona po'opi vʉ'vʉ pachu repana jẽ'ejachejana charo tĩ'aasome. ");
INSERT INTO coe_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chiara chekʉkã'ko jẽni tĩ'a mani Jesús, repaʉ'te tuhasinare pãi ñaasomʉ. Repana pãipi Dios chʉ'o chʉ'vajʉ cho'okainani peojʉ ovejava'na kuirakʉ'te peova'naja'ñe chʉova'na pa'ijʉna repanare Jesús ña oniasomʉ. Repanani oiʉ Dios chʉ'o chʉ'vaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ũcuarʉmʉ repaʉ neena na'isocuhakʉna repaʉ'te sani ija'che i'kaasome: —Na'isõcuhamʉ ie. Icheja vʉ'ñajoopoãjẽ'e peomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jã'ajekʉna inare pãi saojʉ̃'ʉ kueñe pa'ivʉ'ñana ũcuachi'a vʉ'ñajoopoãna sani ãure koo ãapʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jã'aja'ñe i'kanareta'ni Jesús i'kaasomʉ repanare. —Mʉsanʉkonapi ãu ãujʉ̃'ʉ inare —chiniasomʉ repaʉ. Chikʉna i'kaasome repana repaʉ'te. —¿Mai kurire're denariore're doscientorepare're sa pã koojani ra ãujanaa'ñe chʉkʉna inare? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chitena Jesús i'kaasomʉ repanare. —¿Ketopʉpʉã pãpʉã paache mʉsanʉkona? Ñajaijʉ̃'ʉ —chiniasomʉ repaʉ repanare. Chikʉna ñajani rani repaʉ'te ija'che i'kaasome repana: —Pãpʉã, cincorepapʉã, va'iva'na te'eka'chapava'narechi'a paame chʉkʉna —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ũcuarʉmʉ Jesús repanare pãi tachavʉna te'ekuanuchi'a pʉʉa'jʉ chini chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chʉ̃'ʉʉna pãi ũcuanʉko te'ekuanuchi'a pʉʉasome. Chekʉkuanupʉã cienrepana, chekʉkuanupʉã cincuentarepana pʉʉasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pʉʉ ñu'ijʉna pã, cincorepapʉãre va'iva'nare te'eka'chapava'nare mini cãjikʉ cʉnaʉmʉre ñakʉ Dioni, “Re'orepamʉ Ja'kʉ”, chini repaʉ neenani repa pãre tʉ'se ĩsiasomʉ repaʉ, ũcuanʉkore ãua'jʉ chini. Va'iva'nare ũcuaja'che ĩsiasomʉ repaʉ, repanani ãua'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pãi ũcuanʉko chajiche ãniasome repa. ");
INSERT INTO coe_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jã'ata'ni repana ãijʉna cajejaisi'e pãna'me va'i docerepajʉ'ña sia maña timuasome repana Jesús neena. ");
INSERT INTO coe_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Repa ãu ãisina pãi chekʉrʉmʉ cinco milrepana na'a jainʉko pa'icosome ʉmʉpãichi'a kuẽkueto. ");
INSERT INTO coe_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jã'aja'ñe cho'ocuha Jesús repaʉ neenare ija'che i'kaasomʉ: “Chʉ'ʉ inare pãi saochetʉ'ka mʉsanʉkona choovʉ tuni chiara chekʉkã'ko cajoopo Betsaida vʉ'ejoopona charo jẽ'ejʉ pa'ijʉ̃'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Repanare pãi sao pi'nisirʉmʉ Jesús aikũtina mʉnisoasomʉ, te'eʉ Dioni sẽsa chini. ");
INSERT INTO coe_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Jã'a cho'oto ñami repaʉ neena chuta'a chiara joorepapo'te jẽ'ejʉ paniasome. Repana saichejapi tutapi rache tutakʉna ro'acu'aasomʉ repanare. Ũcuarʉmʉ Jesús po'o te'eʉ pa'ikʉji ñatacuhatona repanare ña chiara sẽ'sevʉji nʉka ku'iʉ tuha caraipi'raasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Jã'aja'ñe raiʉna repana ũcuanʉko ña, kʉkʉso vajʉchʉjʉ ija'che i'kajʉ rʉa cuiasome, “¡Jũ'isi'kʉpi reko raimʉ ikʉ!”, chiijʉ. Jã'aja'ñe i'kajʉna Jesús teana ija'che i'kaasomʉ: —Jʉjarekoñoã paajʉ̃'ʉ. Jesua'mʉ chʉ'ʉ. Vajʉchʉmanejʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Repaʉ Jesús choovʉ tukʉna tutasi'e cuhasoasomʉ. Jã'aja'ñe cho'oʉna rʉa jñanoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús pãpʉã cho'osi'e ñasinata'ni repaʉ pa'iche vesʉasome repana, repaʉ'te chuta'a masi cuasamanajejʉ. ");
INSERT INTO coe_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ũcuarʉmʉ Jesús repaʉ neenana'me chiaraji jẽni Genesaret chejana tĩ'aasome. Tĩ'a choovʉ jʉoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jʉo maito repacheja pa'ina pãi Jesure teana ña masiasome. ");
INSERT INTO coe_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jã'ajekʉna repana ũcuacheja pa'ivʉ'ña ũhinare jũ'iva'nare vʉ'vʉ miijani raasome. Repava'nare ra kãikãña ũhinare Jesús ku'ichejñana ũhaasome. ");
INSERT INTO coe_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Repaʉ Jesús vʉ'ñajoopoã chekʉrʉmʉ jmajoorʉã chekʉrʉmʉ ʉjajoopoã chekʉrʉmʉ po'ñare ku'iʉna pãi jũ'iva'nare repaʉ pa'ichejana ra ma'a rʉ'tʉvaãna ũhaasome. Ra ija'che chiijʉ sẽniasome repana: “Iva'na jũ'iva'na mʉ'ʉ ju'ikãa pʉso juhasirʉ'tʉ chẽseche jo'kajʉ̃'ʉ, chẽse vajʉa'jʉ”, chiniasome. Ũcuarʉmʉ repana jũ'iva'na repaʉ ju'ikãa chẽsesina ũcuanʉko vajʉasome. ");
INSERT INTO coe_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ũcuarʉmʉ fariseopãina'me judíopãi che'chona Jerusalén raisinapi Jesús pa'ichejana saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sani tĩ'a ñato Jesús neena te'ena judío aipãi chʉ̃'ʉ jo'kasi'e cho'omapʉ masi choamajʉ̃jñapi ãu ãniasome. Jã'aja'ñe cho'ojʉna fariseopãina'me judíopãi che'chona ña cu'ache i'kaasome repanare. ");
INSERT INTO coe_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Repana fariseopãina'me judíopãi ũcuanʉko cu'are cuhejʉ repana aipãi chʉ̃'ʉ jo'kasi'e cho'onaa'me. Charo jʉ̃jña masi choamaneni ãu ãimanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ũcuachi'a ãu ĩsicheja sani rani cuchamaneni ãu ãimanaa'me repana judíopãi. Cu'are cuhejʉ aperʉmʉ repana aipãi chʉ̃'ʉsi'e chuta'a cho'ojʉ pa'inaa'me repana. Cʉnaro'ro, cʉnaroã, cʉnare'a peore masi sosajʉ pa'inaa'me repana. Kãiko'ñajatʉ'ka masi choanaa'me repana, aipãi chʉ̃'ʉsi'ere cho'ojʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ũcuarʉmʉ repana fariseopãina'me judíopãi che'chona Jesure ija'che sẽniasome: —¿Je'se pa'iʉna mʉ'ʉ neena mai aipãi chʉ̃'ʉ jo'kasi'e cho'oma'ñe? Masi choamajʉ̃jñapi ãu ãime repana —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chitena Jesús ija'che i'kaasomʉ repanare: —Aperʉmʉ Dios chʉ'o kʉasi'kʉ Isaías mʉsanʉkona sẽ'sevʉchi'a re'oja'che pa'ijachere kʉakʉ tocha jo'kasi'e ija'che chiimʉ: Jã'ana Israel jojosina, “Mʉ'ʉre cuasajʉ vajʉchʉme chʉkʉna”, chiime chʉ'ʉre. Jã'ata'ni repana rekoñoã chʉ'ʉre cuasamanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ũcuachi'a chʉ'ʉre cuasajʉ pojojʉ cho'ocheja'che sẽ'sevʉchi'a peoche cho'onaa'me repana. Rupʉ repana cuasajʉ chʉ̃'ʉñechi'a che'chonajejʉ chʉ'ʉni cuasamapʉ jorenaa'me repana, chiiʉ tocha jo'kaasomʉ Isaías. ");
INSERT INTO coe_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dios chʉ̃'ʉ jo'kasi'ere jachajʉ cho'omapʉ rupʉ pãi cuasajʉ chʉ̃'ʉñechi'a cho'ojʉ pa'inaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Mʉsanʉkona aipãi cuasajʉ chʉ̃'ʉ jo'kasi'ere cho'oñu chiijʉ Dios chʉ̃'ʉ jo'kasi'e cho'omanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aperʉmʉ Moisés ija'che chʉ̃'ʉ jo'kaasomʉ: Mʉja'kʉpãi ña kʉkʉjʉ pa'ijʉ̃'ʉ mʉsanʉkona, Ũcuachi'a, Mʉja'kʉpãi cu'ache i'kamanejʉ̃'ʉ. Jã'aja'ñe i'kanare vanisõñe pa'imʉ, cu'ache i'kasi'e ro'i, chiiʉ chʉ̃'ʉ jo'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mʉsanʉkonata'ni chekʉnare ija'che chʉ̃'ʉnaa'me: “Mai ja'kʉpãire ija'che i'kato re'omʉ: ‘Ja'kʉpãi, mʉsanʉkonare ĩsira'asi'e chʉ'ʉ paache corban'me. Jã'ajekʉna mʉsanʉkonare kuiracu'amʉ’, chiito re'omʉ. Jã'aja'ñe i'kanare pʉka'kʉpãi kuirache peomʉ”, chiinaa'me mʉsanʉkona. (“Corbán” chini “Diore ĩsijachea'me” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mʉsanʉkona Dios chʉ̃'ʉ jo'kasi'e jachanajejʉ jã'aja'ñe chʉ̃'ʉme, pãipi rupʉ mʉsanʉkona cuasajʉ chʉ̃'ʉñe'te cho'ojʉ paapʉ chini. Cheke ũcuajamajñarʉã cu'ache cho'ojʉ pa'inaa'me mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chini Jesús pãi jo'e soni rao ija'che i'kaasomʉ repanare: —Chʉ'ʉ i'kache asa chẽa masijʉ̃'ʉ mʉsanʉkona ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pãi ãu ãiñeji repana rekoñoã cu'ache cho'omanaa'me. Repana cu'ache cuasanita'ni cu'ache cho'ome rekoñoã. ");
INSERT INTO coe_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chʉ'ʉ i'kache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","I'kacuha pãi jo'ka mʉa vʉ'ena kakaasomʉ Jesús. Kaka pa'iʉna repaʉ neena repaʉ chʉ'vasi'ere asavesʉjʉ sẽniasome repaʉ'te, masi kʉaa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Sẽtena ija'che i'kaasomʉ repaʉ: —¿Mʉsanʉkona ũcuaja'che chʉ'ʉ i'kasi'e asavesʉche? Pãiʉ ãu ũcuaʉache'te ãni cʉtapʉna mevo jmamakarʉ paa sẽjosõmʉ. Rekocho kakamaʉna repaʉ rekochota'ni cu'ache cho'oma'mʉ —chiniasomʉ Jesús. Jã'aja'ñe i'kakʉ, “Ãu ũcuaʉache ãire'omʉ pãi”, chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ: —Pãi cu'ache cho'ona repana rekoñoã cuasache cu'ache cho'ome. Cu'ache cuasanajejʉ repana rekoñoã cu'ache paame. ");
INSERT INTO coe_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pãi te'ena repana rekoñoã cu'ache cuasajʉ cu'ache cho'ome. Chekʉna romineejʉ chekʉna ʉmʉneejʉ cu'ache cho'ome. Chekʉna põse ñaasõme. Chekʉna pãi vanisõme. ");
INSERT INTO coe_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Chekʉna repana pa'imanare ja'me kãime. Chekʉna, pãi neemajñarʉãre tʉa paaʉache ñame. Chekʉna ũcuaʉache cu'ache cho'ome. Chekʉna joreme. Chekʉna ũcuaʉache cu'ache cho'ojʉ jʉvoma'ñe si'ache vajʉchʉache cho'onaa'me. Chekʉnare pãi re'oja'che ti'jñeto pe'rume. Chekʉna cu'ache i'kame chekʉnare. Chekʉna pãi chekʉnare cuhejʉ, “Chʉ'ʉchi'a re'okʉ'mʉ”, chiime. Chekʉna tĩiñe cuasame. ");
INSERT INTO coe_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pãi jã'aja'ñe cuasajʉ cho'onapi cu'ache paame rekoñoã, Diopi ñato —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ũcuarʉmʉ Jesús ũcuachejapi eta Tiro vʉ'ejoopona'me Sidón vʉ'ejoopo pa'ichejana saniasomʉ. Sani tĩ'a repacheja pa'ivʉ'ena kakaasomʉ repaʉ, kati te'eʉ pasa chini. Jã'ata'ni katicu'aasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Sani tĩ'aʉna repacheja pa'iko Sirofeniciapãio asa repaʉ pa'ivʉ'ena mʉa kaka repaʉ'te ti'jñeñe ro're pʉʉ ñuniasomo. Ñu'io repaʉ'te rʉa i'kaasomo repao, mamako'te pa'ikʉni vatini eto saokaaʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sẽeona Jesús i'kaasomʉ. —Pãipi chĩiva'na ãiñe'te ãure tʉa jamuchaire ãuto cu'amʉ. Pãi repana chĩiva'nani charo ãu ãume —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chikʉna repao i'kaasomo. —Ũcuarepaa'me jã'a, Pãi Ũcuanʉkore Paakʉ. Jã'ata'ni pãi chĩiva'na ãijʉ pu'che to'jñosimajñarʉãre ãime jamuchai —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chikona Jesús jo'e i'kaasomʉ repao'te. —Rʉa masi i'kamo mʉ'ʉ. Jã'aja'ñe cuasako i'kaona mʉ'ʉre re'oja'che cho'okaija'mʉ chʉ'ʉ. Mʉ'ʉ vʉ'ena co'ijʉ̃'ʉ. Mʉ'ʉ chĩiva'o sa'navʉ pa'isi'kʉ vati eta sanisõcuhasi'kʉa'mʉ —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jã'aja'ñe i'kaʉna vʉ'e co'i ñato chĩiva'o kãiko'are ũhio paniasomo, vatipi aperʉmʉ repao'te pa'isi'kʉ eta sanisoʉna. ");
INSERT INTO coe_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ũcuarʉmʉ Jesús Tiro vʉ'ejoopo pa'ichejapi sani Sidón vʉ'ejoopo carani jo'e Decápolis cheja pa'ijoopoã carani Galilea chiarana sani tĩ'aasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sani pa'iʉna repaʉ pa'ichejana pãi chekʉnapi cãjo asamaʉ chʉ'ojẽ'e cutuma'ñe pa'ikʉ'te ra, “Ikʉre chẽa vasojʉ̃'ʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chitena Jesús repaʉ'te jũ'ikʉ'te pãi peochejana juha sa repaʉ mʉoñoãpi jũ'ikʉ'te repacãjo pa'iche suãnicuha repaʉ coopi tutu jũ'ikʉ chemeñona noasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jã'aja'ñe cho'ocuha ʉmʉre ñakʉ rʉa chʉ'e mʉo jũ'ikʉ'te i'kaasomʉ repaʉ. “¡Efata!”, chiniasomʉ. (“Efata” chini “Vatajʉ̃'ʉ” chiimʉ hebreo chʉ'o.) ");
INSERT INTO coe_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jã'aja'ñe i'kaʉna jũ'ikʉ cãjo ta'pisi'e ũcuate'erʉmʉ repaʉ chemeño asoma'ñe i'kasi'chopi care'oʉna asoche cutuasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Repaʉ'te vasocuha repanare i'kaasomʉ Jesús. “Chʉ'ʉ ikʉre vasosi'e chekʉnare kʉamanejʉ̃'ʉ”, chiiʉ ʉ̃seasomʉ repaʉ. Jã'ata'ni Repaʉji na'a rʉa, “Kʉamanejʉ̃'ʉ”, chiito na'a rʉa chekʉnare kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jesupi jã'aja'ñe cho'oʉna repana pãi ña jñano ija'che i'kaasome: —Jesús rʉa si'ache re'oja'che cho'okʉ'mʉ. Repaʉji cho'oʉna cãjo asamanesina chura asame. Ũcuachi'a repaʉji cho'oʉna chʉ'o cutumanesina chʉ'o cutume chura —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ũcuarʉmʉ pãi jainʉko Jesús pa'ichejana sani chi'i pa'ijʉna ãu si'asoasomʉ repanare. Jã'ajekʉna Jesús repaʉ neenare soni rao ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Inare pãi repana rasi'e ãu ãni si'asõ ãiñejẽ'e peova'napi chʉ'ʉna'me choteumucujña pa'ijʉna oimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ãu ãimava'nani repana vʉ'ñana saoto repana saijʉ ãucuhana phã'phasõ ai jũnisõjanaa'me. Te'ena rʉa so'ñapi raniasome —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chikʉna repaʉ neena i'kaasome. —Icheja pãi peochejajekʉ ãu ãiñejẽ'e peomʉ. ¿Je'se chʉkʉna ãu jñaa ãujanaa'ñe inare pãi? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chitena Jesús ija'che sẽniasomʉ repanare: —¿Jetopʉpʉã pã paache mʉsanʉkona? —chiniasomʉ repaʉ. Chikʉna i'kaasome repana. —Pãpʉã sieterepapʉã paame chʉkʉna —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ũcuarʉmʉ Jesús asa pãipi chejana pʉʉa'jʉ chini chʉ̃'ʉasomʉ. Pʉʉrena Jesús repa pãpʉã sieterepapʉãre mini cãjikʉ Dioni, “Re'orepamʉ”, chini repaʉ neenare tʉ'se ĩsiʉna repana pãi ũcuanʉkore ãuasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ũcuachi'a repaʉ neena chiacha va'i te'eva'nare paajʉna Jesús repava'nare mini cãjikʉ Dioni, “Re'orepamʉ”, chiniasomʉ. Chini chʉ̃'ʉasomʉ, repaʉ neenapi pãire ũcuanʉkore ãua'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pãi ũcuanʉko chajichechi'a ãniasome repa. Repana ãijʉna cajejaisi'e sieterepajʉ'ña sia maña timuasome repana Jesús neena. ");
INSERT INTO coe_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Repa ãu ãisina pãi chekʉrʉmʉ cuatro milrepana pa'icosome, ʉmʉpãichi'a kuẽkueto. Jã'a cho'o pi'nisirʉmʉ Jesús repanare pãi saosoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Saocuha repaʉ neenana'me choovʉji tuni Dalmanuta chejana jẽniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ũcuarʉmʉ fariseopãi Jesús pa'ichejana rani ke'reasome repaʉ'te. “Dios raomanesi'kʉa'mʉ ikʉ”, chini cuasanajejʉ, repaʉni cu'ache cho'oñu chini, —Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jã'aja'ñe chitena Jesús repaʉ rekocho rʉa sʉma'ñe pa'iʉ ija'che i'kaasomʉ repanare: —Ina pãi chʉ'ʉre, “Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te”, chiime, chʉ'ʉ pa'iche'te masiñu chini. Jã'ata'ni cho'o ñomaneja'mʉ chʉ'ʉ repanare. Ũcuarepaa'me jã'a —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chini repanare jo'ka jo'e choovʉji tuni chiara chekʉkã'kona jẽniasomʉ Jesús repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ũcuarʉmʉ Jesús neena chiara jẽ'ejʉ, “Pã cavesʉ ranisõsinaa'me mai”, chiniasome sãiñechi'a. Pãpʉ te'epʉ paaasome repana choovʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jã'aja'ñe cuasajʉ i'kajʉna Jesús repanare ija'che chʉ'vaasomʉ: —Ñarepajʉ̃'ʉ. Fariseopãina'me Herodes pã saʉcheja'chere ñajʉ che'chemanejʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chikʉna repaʉ neena sãiñechi'a i'kaasome. —Maipi pãre ramanerena jã'aja'ñe i'kacosomʉ ikʉ maire —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús repana sãiñechi'a cutuche'te masikʉ ija'che i'kaasomʉ: —¿Je'se pa'iʉna mʉsanʉkona pã peoche'te cuasajʉ cutuche? Mʉsanʉkona chuta'a masi cuasamapʉ asavesʉme. Chʉ'ʉ che'chosi'e mʉsanʉkona rekoñoã chuta'a tĩ'ama'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mʉsanʉkona ñakocaã paanata'ni ñama'me. Ũcuachi'a cãjo paanata'ni asama'me. ¿Chʉ'ʉ cho'osi'e cuasama'ñe mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aperʉmʉ pã cincorepapʉãchi'a ʉmʉpãi cinco milrepanare ãukʉna cajejaisi'e, ¿jetopʉjʉ'ña sia maña timure mʉsanʉkona? —chiniasomʉ Jesús repanare. Chikʉna, —Docerepajʉ'ña sia maña timusinaa'me chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chitena Jesús jo'e i'kaasomʉ repanare. —Ũcuachi'a pã sieterepapʉã pãi cuatro milrepanare chʉ'ʉ ãukʉna cajejaisi'e, ¿jetopʉjʉ'ña sia maña timure mʉsanʉkona? —chiniasomʉ repaʉ repanare. Chikʉna, —Sieterepajʉ'ña sia maña timusinaa'me chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chitena Jesús jo'e i'kaasomʉ. —¿Chuta'a asavesʉche mʉsanʉkona? —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ũcuarʉmʉ Jesús repaʉ neenana'me Betsaida vʉ'ejoopona mani tĩ'aasomʉ. Tĩ'aʉna pãi na'ava'ʉni Jesús pa'ichejana ra rʉa i'kaasome, repava'ʉni vasoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sẽtena Jesús repava'ʉre vʉ'ejoopo rʉ'tʉvana jʉ̃tʉna chẽa juha saasomʉ. Sa repaʉ ñakocaãna coo tutucuha repaʉ ca'nivʉna jʉ̃jñapi jakʉ, “¿Ʉ̃quere ñakʉ mʉ'ʉ?”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chikʉna ñakʉ ija'che i'kaasomʉ: —Pãire ñamʉ chʉ'ʉ. Ñakʉ'teta'ni sũkiñʉãja'ñe ñoñe pãi ku'ime —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chikʉna Jesupi jo'e repaʉ ñakocaãna jaʉna repaʉ jo'e ñato churata'ni peore re'oja'che ñoasomʉ. Re'ojañakocaã care'oasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Care'oʉna Jesús repaʉ'te vʉ'ena saokʉ ija'che i'kaasomʉ: —Vʉ'ejoopo saima'ñe mʉ'ʉ vʉ'ena rũhiñe saijʉ̃'ʉ. Chʉ'ʉ mʉ'ʉre vasosi'e chekʉnare kʉamanejʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jã'a cho'ocuhasirʉmʉ Jesús repaʉ neenana'me Cesarea de Filipo vʉ'ejoopo kueñe cajoopoãna sani tĩ'a ku'iʉ Jesús repaʉ neenare ija'che sẽniasomʉ: —Pãi chʉ'ʉ pa'iche'te cutuni, ¿je'se chiiche? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sẽkʉna ija'che kʉaasome repana: —“Juan, Pãi Okoro'vesi'kʉcosomʉ jã'ʉ”, chiime pãi chekʉna mʉ'ʉre i'kani. Chekʉna, “Aperʉmʉ pa'isi'kʉ Elíaa'mʉ jã'ʉ”, chiime mʉ'ʉre. Jo'e chekʉna, “Aperʉmʉ Dios chʉ'o kʉasi'kʉpi jũnisõsi'kʉpi jo'e vajʉrani pa'imʉ jã'ʉ”, chiime mʉ'ʉre —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chitena Jesús jo'e ija'che sẽniasomʉ repanare: —Mʉsanʉkonajẽ'e chʉ'ʉ pa'iche'te cutuni, ¿je'se chiiche? —chiniasomʉ. Chikʉna asa Pedroji ija'che i'kaasomʉ repaʉ'te: —Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ mʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ũcuarʉmʉ Jesús repaʉ neenare chʉ̃'ʉasomʉ, repaʉ pa'iche'te chekʉnani kʉamanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ũcuarʉmʉ Jesús repaʉ neenare ija'che i'kaasomʉ: —Chʉ'ʉ Dios Raocojñosi'kʉ rʉa asi cho'ocojñoja'mʉ. Ũcuachi'a judío ainana'me judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona chʉ'ʉni cuhejʉ vanisõñe chʉ̃'ʉjanaa'me. Vanisõ tãcojñosi'kʉta'ni choteumucujñana jo'e vajʉraija'mʉ chʉ'ʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jã'a Jesús repaʉ neenare te'erũhiñe kʉaasomʉ. Jesupi jã'aja'ñe kʉaʉna asa Pedro repaʉ i'kache'te asacuhekʉ repaʉ'te chekʉna pãi peochejana juha sa ija'che i'kaasomʉ: —Jã'aja'ñe i'kamanejʉ̃'ʉ mʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jã'aja'ñe i'kaʉna asa Jesús Pedro i'kache'te asacuhekʉ repaʉ neenani chʉri ñakʉ ija'che i'kaasomʉ repaʉ'te: —Vati ai cuasacheja'che cuasakʉjekʉ chʉ'ʉre ja'me pa'ima'ñe saijʉ̃'ʉ mʉ'ʉ. Pãi Dios cuasacheja'che cuasamanaa'me. Mʉ'ʉ ũcuaja'che Dios cuasacheja'che cuasama'kʉa'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ũcuarʉmʉ Jesús repaʉ neenare pãi chekʉnana'me soni rao i'kaasomʉ. —Mʉsanʉkonapi chʉ'ʉ neena pañu chini mʉsanʉkonare cho'oʉache ũhasõ chʉ'ʉ chʉ̃'ʉñe'te si'aumucujña cho'ojʉ pa'ijʉ̃'ʉ. Chʉ'ʉre cuasanajejʉna chʉ'ʉre cho'ocheja'che vanisõñu chiijanaa'me pãi mʉsanʉkonare. Pãi mʉsanʉkonare jã'aja'ñe cho'oñu chiiche asanijẽ'e chʉ'ʉre cuasache ũhasõmanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chuenisõñe'te vajʉchʉjʉ repana asa chẽasi'ere Dios chʉ'ore ũhasõni repana jũnisõsirʉmʉ vati toana sani uujanaa'me. Jã'ata'ni, “Pãi chʉkʉna'te vanisõñu chiitojẽ'e Jesure ũcua cuasajʉ Dios chʉ'o chʉ'vajanaa'me chʉkʉna”, chiisina repana jũnisõsirʉmʉ Dios pa'ichejare ai sani re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Pãi cu'amajñarʉã si'ache paanapi chʉ'ʉre cuasamaneni, repana jũnisõsirʉmʉ vati toana sani ũcuana paacheji ro'i eta Dios pa'ichejana saicu'amʉ. ");
INSERT INTO coe_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pãi chʉ'ʉre cuasanata'ni chekʉnani irʉmʉ pa'ijʉ cu'ache cho'onani vajʉchʉjʉ, “Jesure cuasamanaa'me chʉkʉna. Ũcuachi'a Repaʉ chʉ'ojẽ'e vesʉnaa'me chʉkʉna”, chiime masinata'ni. Jã'aja'ñe i'kasinare rʉa cu'ache ti'jñeja'mʉ, na'a pa'isirʉmʉ chʉ'ʉ, Dios Raosi'kʉ, cʉnaʉmʉ mʉisi'kʉpi chejana jo'e cajerʉmʉ. Reparʉmʉ chʉ'ʉ Ja'kʉ Dios ko'sija'icheja'che ko'sija'iʉ cajeja'mʉ chʉ'ʉ Ja'kʉ neena ángelena'me. Caje jã'aja'ñe i'kasinare chʉ'ʉ ũcuaja'che, “Inare pãi vesʉmʉ chʉ'ʉ”, chiija'mʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ũcuarʉmʉ Jesús repanare pãi jo'e i'kaasomʉ. —Mʉsanʉkona icheja chʉ'ʉre ja'me pa'ina chuta'a jũnisõma'ñe pa'irʉmʉna chʉ'ʉ Dios Raosi'kʉpi pãire masi chʉ̃'ʉkʉna ñajanaa'me. Ũcuarepaa'me jã'a —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seirepaumucujña pa'isirʉmʉna Jesús aikũti rʉa ʉmʉ nʉkakũtina mʉiʉ Pedro'te Santiago'te Juanre jã'anarechi'a mʉaasomʉ. Mʉni pa'ijʉ Jesús tĩiʉja'iʉ carũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Repaʉ ju'ikãña ũcuaja'che rʉa poko'sijakãña carũnisoasomʉ. Pãi kãña choanare te'eʉ'terejẽ'e rʉa choatojẽ'e repaʉ kãñaja'ñe pojakãña choacu'amʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ũcuarʉmʉ Jesús neena ñato aperʉmʉ pa'isina Moisena'me Elías Jesuna'me pa'ijʉ chʉ'ore cutujʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jã'aja'ñe pa'ijʉna ña Pedroji Jesure i'kaasomʉ. —Masiʉ, maipi ichejare pa'ijʉna rʉa re'omʉ. Vʉ'ñarʉã chotevʉ'ñarʉã cho'okañu chiime chʉkʉna, mʉ'ʉ vʉ'erʉna'me Moisés vʉ'erʉna'me Elías vʉ'erʉ —chiniasomʉ Pedro repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Repana Jesús neena kʉkʉsojʉ masi cuasavesʉkʉ Pedroji jã'aja'ñe i'kaasomʉ Jesure. ");
INSERT INTO coe_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ũcuarʉmʉ repana nʉkachejana pikopi caje ta'pisoʉna piko sa'navʉji chʉ'o i'kache asoasomʉ repanare. —Ikʉ chʉ'ʉ chĩi chʉ'ʉ oiʉ paakʉ'mʉ. Repaʉ chʉ'ore asajʉ pa'ijʉ̃'ʉ mʉsanʉkona —chiiche'te asaasome. ");
INSERT INTO coe_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ũcuarʉmʉ repana teana si'acakã'jño ñato Jesús te'eʉ nʉkaasomʉ; chekʉna te'eʉjẽ'e peoasome. ");
INSERT INTO coe_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Repana aikũti cajerʉmʉ Jesús ija'che i'kaasomʉ repanare: “Diopi ñokʉna mʉsanʉkona irʉmʉ ñasi'e chʉ'ʉ Dios Raosi'kʉ jũnisõ vajʉraisirʉmʉjatʉ'ka chekʉnare te'eʉ'terejẽ'e kʉamanejʉ̃'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","“Kʉamanejʉ̃'ʉ”, chiisi'ejekʉna kʉama'ñe pa'ijʉ repanachi'a masijʉ paniasome. Jã'ata'ni repaʉ, “Jũnisõ jo'e vajʉraija'mʉ”, chiisi'ere masi asavesʉjʉ, “¿Je'se chiikʉ jã'a?”, chiijʉ sãiñechi'a cutujʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Reparʉmʉ Jesure ija'che sẽniasome repana: —¿Je'se pa'iʉna maire judíopãi che'chona, “Dios raoja'mʉ chiicojñokʉ chuta'a raimarʉmʉ Elíapi charo raija'mʉ”, chiijʉ che'choche? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chitena Jesús i'kaasomʉ. —Repana che'choche ũcuarepaa'me. Elíaa'mʉ charo rani peore si'ache mamare care'vajaʉ. Dios chʉ'o aperʉmʉ tocha jo'kasi'e chʉ'ʉ Repaʉ Raosi'kʉ pa'ijachere kʉakʉ ija'che chiimʉ: Dios Raojaʉre pãi cuhejʉ cu'ache cho'ojanaa'me, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jã'ata'ni chʉ'ʉ mʉsanʉkonare Elías ranicuhasi'kʉa'mʉ chiimʉ. Rani pa'iʉna pãi repanare ʉache cu'ache cho'osinaa'me repaʉ'te. Jã'aja'ñe kʉamʉ Dios chʉ'o aperʉmʉ tocha jo'kasi'e. Repaʉ'te cho'osi'eja'che cu'ache cho'ojanaa'me pãi chʉ'ʉre Dios Raosi'kʉre —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ũcuarʉmʉ repana Jesuna'me aikũti mʉisina repaʉ neena mʉimanesina nʉkachejana caje tĩ'aasome. Caje tĩ'a ñato pãi jainʉko paniasome. Ũcuachi'a judíopãi che'chona te'ena paniasome. Pa'ijʉ Jesús neenani ke'rejʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ũcuarʉmʉ repana pãi ũcuanʉko Jesure ña kʉkʉ vʉ'vʉasome repaʉni pojoñu chini. ");
INSERT INTO coe_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ũcuarʉmʉ Jesús repanare pãi ija'che sẽniasomʉ: —Chʉ'ʉ neenare, ¿ʉ̃quere cutuche mʉsanʉkona? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chikʉna repanare pãi ja'me pa'ikʉji Jesure i'kaasomʉ. —Masiʉ, chʉ'ʉ chĩiva'ʉre mʉ'ʉni ramʉ chʉ'ʉ. Vatire chʉ'o cutuche ʉ̃sekʉni paamʉ iva'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vatipi si'arʉmʉ chẽa paakʉna iva'ʉ chejana tãni vẽ've curukʉ coo rʉa raokʉ cõjire asoche ãiʉ ca'nivʉ jʉjaʉ quẽkemʉ. Iva'ʉre ra mʉ'ʉ neenani i'kasi'kʉa'mʉ chʉ'ʉ, vatini eto saokaapʉ chini. Jã'ata'ni eto saovesʉsinaa'me repana —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Mʉsanʉkona pãi irʉmʉ cana chʉ'ʉre masi cuasama'me. ¿Keekerʉmʉ mʉsanʉkona tĩiñe cuasache ñakʉ pa'iche chʉ'ʉ? —Jã'aja'ñe i'ka pi'ni— Ichejana rajʉ̃'ʉ mʉ'ʉ chĩiva'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chikʉna Jesuni chĩiva'ʉre raasome repana. Rarena vati Jesuni ña cho'okʉna chĩiva'ʉ rʉa kurukurukʉ chejana jũni tãni po'nʉʉ ku'iʉ chʉ'opo rʉa coo raoasomʉ repava'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jã'aja'ñe cho'okʉna ña Jesús chĩiva'ʉ pʉka'kʉre ija'che sẽniasomʉ: —¿Keekerʉmʉ ikʉ vatire paakʉ? —chiniasomʉ. Chikʉna pʉka'kʉ i'kaasomʉ repaʉ'te. —Chĩirʉmʉna paava'ʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vatipi iva'ʉni vanisõra chini chẽa paakʉ chʉ̃'ʉkʉna chekʉrʉmʉ toana tãiʉ chekʉrʉmʉ chiachana tãikʉ'mʉ iva'ʉ. Mʉ'ʉpi cho'omasini chʉkʉna'te oiʉ cho'okaijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Mʉ'ʉ chʉ'ʉre cuasato vasokaija'mʉ chʉ'ʉ ikʉre. Pãi chʉ'ʉre cuasanare peore cho'okaimʉ Dios repanare —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jã'aja'ñe chikʉna vatire paakʉ pʉka'kʉ ʉjachʉ'opi cuikʉ i'kaasomʉ. —Mʉ'ʉre cuasamʉ chʉ'ʉ. Jã'ata'ni chuta'a cuasache karamʉ. Cho'okaijʉ̃'ʉ chʉ'ʉre. Chʉ'ʉ rekocho mʉ'ʉre na'a rʉa cuasara chiimʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ũcuarʉmʉ Jesús repaʉ nʉkachejana pãipi jainʉko chi'ijʉna vatire cho'oche ʉ̃sekʉ ija'che i'kaasomʉ: —Vati, mʉ'ʉre chʉ̃'ʉmʉ chʉ'ʉ, chʉ'o cutuʉ̃sekʉ cãjo asache ʉ̃sekʉ'te. Chĩiva'ʉre jo'ka eta saijʉ̃'ʉ. Ai sani jo'e rani kakamanejʉ̃'ʉ mʉ'ʉ repava'ʉre —chiniasomʉ Jesús repaʉ'te vatire. ");
INSERT INTO coe_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesupi jã'aja'ñe chʉ̃'ʉʉna vati rʉa cuikʉ repaʉni cho'okʉna rʉa kurukuruasomʉ. Vatipi jã'aja'ñe cho'ocuha repaʉ'te eta sanisoʉna jũnisosiva'ʉja'iʉ ñokʉna ña repana pãi jainʉko, “Jũnisõcuhasiva'ʉa'mʉ iva'ʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Chiisi'eta'ni Jesús repaʉ jʉ̃tʉna chẽa vʉo nʉkoasomʉ repaʉ'te vatire paasi'kʉre. ");
INSERT INTO coe_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jã'aja'ñe cho'ocuha Jesús vʉ'ena kaka pa'iʉna repaʉ neena repaʉ'te te'eʉ'te sẽniasaasome. —¿Je'se pa'iʉna chʉkʉna'te vatire eto saocu'aʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chitena i'kaasomʉ repaʉ. —Vati ikʉre chĩiva'ʉre pa'isi'kʉjanare Diore cuasajʉ ãu ãima'ñe Repaʉ'te rʉa sẽenarechi'a eto saore'omʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ũcuarʉmʉ Jesús repaʉ neenana'me jã'achejapi sani Galilea cheja canʉkama'ñe ku'ijʉ paniasome. Repaʉ neenare che'chora chini Jesús repana saijacheja chekʉnare kʉama'ñe saiʉ ija'che che'choasomʉ repanare: “Chʉ'ʉre Dios Raosi'kʉre cuhena pãi cu'ache cho'oa'jʉ chini chẽa chekʉnani jo'kajanaa'me. Jo'karena chʉ'ʉre vanisõjanaa'me repana pãi. Vanisõ tãcojñosi'kʉta'ni choteumucujñana jo'e vajʉraija'mʉ chʉ'ʉ”, chiiʉ che'choasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jã'ata'ni repaʉ i'kache asavesʉasome repana. Asavesʉnata'ni repaʉ'te Jesure sẽevajʉchʉasome repana. ");
INSERT INTO coe_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ũcuarʉmʉ Jesús repaʉ neenana'me sani Capernaum vʉ'ejoopo tĩ'a vʉ'ena kakaasome repana. Kakasirʉmʉ Jesús ija'che sẽniasomʉ repanare: —Mai icheja rairʉmʉ, ¿ʉ̃quere cuture mʉsanʉkona? —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Chiitota'ni kʉavajʉchʉjʉ i'kamaneasome repana repaʉ'te. Repana rairʉmʉ ija'che sãiñechi'a cutuasome repana: “Mai icheja pa'ina, ¿neepi na'a rʉa masiche?”, chiijʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ũcuarʉmʉ Jesús pʉʉ ñu'iʉ repaʉ neenare docerepanare soni rao ija'che i'kaasomʉ repanare: —Pãiʉ chekʉnare chʉ̃'ʉra chini aperʉmʉ chʉ̃'ʉma'kʉ pa'icheja'che pa'iʉ chekʉnare cho'okaiʉ paaʉ. Jã'aja'ñe cho'oni, “Rʉa vesʉmʉ chʉ'ʉ”, chini chekʉnani cho'okaiʉ che'chesõʉna chekʉnare chʉ̃'ʉre'oja'mʉ repaʉ'te —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ũcuarʉmʉ Jesús chĩiva'ʉre juha ra, repana pãi chenevʉna nʉko repava'ʉre mini cajokʉ ija'che i'kaasomʉ repaʉ neenare: ");
INSERT INTO coe_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pãi chʉ'ʉre masi cuasana chĩiva'nare ikʉjava'nare pojona chʉ'ʉre ũcuaja'che pojome. Pãi chʉ'ʉre pojona chʉ'ʉrechi'a pojoma'me. Chʉ'ʉre Raosi'kʉre ũcuaja'che pojome repana —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ũcuarʉmʉ Juan Jesure ija'che i'kaasomʉ: —Masiʉ, chekʉre pãiʉ'te pãi sa'navʉã pa'inare vati eto saokʉ'te ñasinaa'me chʉkʉna. “Jesupi chʉ̃'ʉkʉna cho'omʉ chʉ'ʉ”, chiniasomʉ repaʉ vatire eto saoni. Jã'aja'ñe cho'oʉna ña, ʉ̃sejʉ repaʉ'te i'kasinaa'me chʉkʉna, maire ja'me cho'okaima'kʉjekʉna —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chikʉna asa Jesús i'kaasomʉ repaʉ'te. —Jã'aja'ñe cho'onare ʉ̃semanejʉ̃'ʉ. Pãi Diochi'a cho'omasiche cho'oni, “Jesupi chʉ̃'ʉkʉna cho'omʉ chʉ'ʉ”, chiime. Jã'aja'ñe cho'ojʉ i'kana chʉ'ʉre cu'ache i'kama'me. ");
INSERT INTO coe_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pãi maire cuhemana maire ja'me cho'okainaa'me. ");
INSERT INTO coe_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ũcuachi'a pãi ũcuaʉakʉji mʉsanʉkonare chʉ'ʉ neenare, “Inare Cristo neenajejʉna re'oja'che cho'okaimʉ chʉ'ʉ”, chini re'oja'che cho'okaiʉ oko te'ero'rorʉchi'a ũkuatojẽ'e Diopi ro'ija'mʉ repaʉ'te. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ũcuarʉmʉ Jesús Juanre jo'e i'kaasomʉ. —Chĩiva'na cuasacheja'che chʉ'ʉre cuasakʉni te'eʉ'te cu'ache chʉ'vakʉ'te pãipi ija'che cho'oto na'a re'ora'amʉ: Repaʉ chuta'a chʉ'ʉ neeva'ʉre cu'ache chʉ'vamarʉmʉna toacʉnapʉji rʉa ʉjapʉji pãipi repaʉ cavʉna jepo vẽe chiarana tõ rʉoru na'a re'ora'amʉ repaʉ'te. Jã'aja'ñe cho'oma'to ũcua pa'iʉ chʉ'ʉ neeva'ʉre cu'ache chʉ'vaʉna Diopi repaʉ cu'ache cho'osi'e ro'ire chʉ̃'ʉto na'a rʉa cu'ache pa'ija'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mʉ'ʉ jʉ̃tʉpi chekʉni cu'ache cho'oni tʉsosõjʉ̃'ʉ repajʉ̃tʉ. Na'a re'omʉ te'ejʉ̃tʉ paakʉji Dios pa'ichejana sani re'oja'che pa'ito. Jʉ̃tʉre jã'aja'ñe cho'omaneni peore paakʉta'ni ũcua jʉ̃tʉpi jo'e cu'ache cho'osi'kʉjekʉ vati toana chachocu'atoana sani uukʉ pa'ija'mʉ mʉ'ʉ. Na'a cu'amʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Repacheja saisinare ca'nivʉã ãina peko jũnisõma'ñe ãijʉ pa'inaa'me. Ũcuachi'a repa toa chachama'ñe uukʉ pa'itoaa'me. ");
INSERT INTO coe_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ũcuaja'che mʉ'ʉ cũ'apʉji chekʉni cu'ache cho'oni tʉsosõjʉ̃'ʉ repacũ'apʉ. Na'a re'omʉ te'ecũ'apʉ paakʉji Dios pa'ichejana sani re'oja'che pa'ito. Jã'aja'ñe cho'omaneni peore paakʉta'ni ũcua cũ'apʉji jo'e cu'ache cho'osi'kʉjekʉ vati toana chachocu'atoana sani uukʉ pa'ija'mʉ mʉ'ʉ. Na'a cu'amʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Repacheja saisinare ca'nivʉã ãina peko jũnisõma'ñe ãijʉ pa'inaa'me. Ũcuachi'a repa toa chachama'ñe uukʉ pa'ikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ũcuaja'che mʉ'ʉ ñakovaji ñakʉ cu'ache cho'oni ñakova'te rutasõjʉ̃'ʉ. Na'a re'omʉ te'eñakova paakʉji Dios pa'ichejana sani re'oja'che pa'ito. Jã'aja'ñe cho'omaneni ñakocaã peore paakʉta'ni ũcuañakovaji ñakʉ cu'ache cho'osi'kʉjekʉ vati toana sani uukʉ pa'ija'mʉ mʉ'ʉ. Na'a cu'amʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Repacheja saisinare ca'nivʉã ãina peko jũnisõma'ñe ãijʉ pa'inaa'me. Ũcuachi'a repa toa chachama'ñe ai uukʉ pa'ikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Aperʉmʉ Dioni pojojʉ pãi va'iva'nare vani ĩsiasome. Repava'nare vani ũhapi chu'chuasome. Ũha chu'churu na'a re'omʉ jã'a. Dios ũcuaja'che ũha chu'chucheja'che Repaʉ'te cuasanani pa'ivesache ti'jñeto te'eñoã ʉ̃sema'mʉ. Jã'ajekʉna na'a rʉa re'oja'che pa'imasijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ũha sãija'iʉ rʉa re'omʉ. Jã'ata'ni ũhapi sãija'ñepi si'asõru, ¿je'se cho'ojanaa'ñe pãi, ũhapi sãijaaʉ chini? Jo'e sãija'ñe cho'ocu'amʉ repa. Ũcuaja'che mʉsanʉkona re'oja'che pa'ijʉ chekʉnare pojoto re'omʉ. Re'oja'che cho'oche'te jo'kasõni ũha sãija'imaʉ cu'acheja'che cu'ame —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ũcuarʉmʉ Jesús Capernaum vʉ'ejoopo pa'isi'kʉpi Judea chejana saiʉ Jordán chiacha ʉ̃sʉʉ mʉikã'kona jẽni tĩ'aasomʉ. Tĩ'aʉna pãi repaʉ'te jo'e chi'irena si'arʉmʉ pãi che'chokʉjekʉ jo'e che'choasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ũcuarʉmʉ fariseopãi te'ena Jesús pa'ichejana sani ija'che i'kajʉ sẽniasome repaʉ'te, tĩiñe i'kaʉna repaʉni chẽa cu'ache cho'oñu chini: —¿Pãiʉni repaʉ rʉ̃jore sẽjoʉato sẽjore'okʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chitena Jesús ija'che i'kaasomʉ: —Aperʉmʉ pa'isi'kʉ Moisés, ¿ʉ̃quere mʉsanʉkonare chʉ̃'ʉkʉ tocha jo'kaʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chikʉna i'kaasome repana. —Aperʉmʉ Moisés ija'che chʉ̃'ʉ jo'kaasomʉ: Pãiʉ repaʉ rʉ̃jore paacuhekʉ sẽjora chiikʉ charo repao'te sẽjojañere kʉakʉ utija'ovana tocha pi'ni ũcuaoni ĩsia'kʉ, repao chekʉnare ñojaja'ova. Jã'aja'ñe cho'ocuha sẽjore'omʉ repao'te, chiiʉ chʉ̃'ʉ jo'kaasomʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chitena Jesús i'kaasomʉ repanare. —Mʉsanʉkonapi cu'ache cho'oche'te jo'kacuhejʉ ũcuaʉache cho'oñu chiijʉna jã'aja'ñe chʉ̃'ʉ jo'kaasomʉ Moisés. ");
INSERT INTO coe_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aperʉmʉ Dios peore cho'orʉmʉ pãi cho'okʉ ʉmʉʉna'me romio'te cho'oasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jã'ajekʉna ʉmʉʉ repaʉ pʉka'kʉpãi ja'me pa'isi'e jo'kasõ rʉ̃jona'me pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jã'aja'ñe cho'o ũcuate'eʉja'che pa'ime repana. Ʉmʉʉ rʉ̃jona'me te'eka'chapana pa'ime. Jã'ata'ni ũcuate'eʉja'che pa'ime repana. ");
INSERT INTO coe_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jã'ajekʉna pãiʉji Dios jã'aja'ñe paapʉ chini jo'kasi'ere jachakʉ rʉ̃joni sẽjosõni cu'ache cho'omʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na'a pani Jesús neena vʉ'ere pa'ijʉ jo'e rʉ̃joromi sẽjoñe'te sẽniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sẽtena Jesús jo'e i'kaasomʉ repanare. —Pãiʉ repaʉ rʉ̃jore paacuhekʉ sẽjo, chekoni vejani Dios ʉ̃seche'te cho'okʉ charo paasi'kore cu'ache cho'omʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ũcuaja'che romio repao ʉ̃jʉre sẽjo chekʉni vejani Dios ʉ̃seche'te cho'oko charo pa'isi'kʉre cu'ache cho'omo —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ũcuarʉmʉ pãi Jesús pa'ichejana repana chĩiva'nare raasome, repaʉji chẽse pojoa'kʉ chini. Jã'aja'ñe rajʉna ña repaʉ neena ʉ̃sepi'raasome repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ʉ̃sepi'rajʉna ña Jesús pe'rukʉ i'kaasomʉ repanare. —Chĩiva'nare chʉ'ʉre raiʉ̃semanejʉ̃'ʉ mʉsanʉkona, chʉ'ʉni raapʉ. Iva'na chĩiva'naja'ñe pa'ijʉ chʉ'ʉre masi cuasanapi Dios chʉ'o asa chẽajanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jã'ata'ni iva'na chĩiva'na chʉ'ʉre masi cuasacheja'che masi cuasamana Dios chʉ'o asa chẽamanejanaa'me. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chini Jesús repanare chĩiva'nare sũ'kakʉ jʉ̃jñapi chẽsekʉ Dioni re'oja'chere sẽekaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ũcuarʉmʉ Jesús jo'e ku'iʉna pãiʉ kuriʉ repaʉ'te vʉ'vʉ rani ro're ñu'iʉ ija'che sẽniasomʉ: —Masiʉ, re'okʉ'mʉ mʉ'ʉ. Dios pa'ichejana sasa chiimʉ chʉ'ʉ. ¿Je'se cho'oja'che chʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chikʉna Jesús i'kaasomʉ repaʉ'te. —¿Je'se cuasa, “Re'okʉ'mʉ mʉ'ʉ”, chiikʉ mʉ'ʉ chʉ'ʉre? Diochi'aa'mʉ Re'okʉ. Chekʉ pãiʉ re'okʉ peomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aperʉmʉ Dios chʉ̃'ʉ jo'kasi'e masicosomʉ mʉ'ʉ. Ija'che kʉamʉ: Mʉsanʉkona ʉmʉpãi romi paana chekʉnare romi ja'me kãimanejʉ̃'ʉ. Ũcuaja'che romi ʉmʉ pa'ina chekʉnare ʉmʉpãi ja'me kãimanejʉ̃'ʉ. Ũcuachi'a pãi vanisõmanejʉ̃'ʉ. Chekʉna nee ñaamanejʉ̃'ʉ. Chekʉna pa'iche'te ña kʉani joremanejʉ̃'ʉ. Repana neere tʉa paara chini chekʉnare joremanejʉ̃'ʉ. Ũcuaja'che mʉja'kʉpãi ña, kʉkʉjʉ̃'ʉ, chiimʉ Dios chʉ̃'ʉ jo'kasi'e —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chikʉna repaʉ kuriʉ jo'e i'kaasomʉ. —Masiʉ, chĩirʉmʉpi irʉmʉjatʉ'ka Dios chʉ̃'ʉ jo'kasi'e peore cho'okʉ pa'ikʉ'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jã'aja'ñe i'kaʉna Jesús ña repaʉ'te rʉa oiʉ i'kaasomʉ. —Ũcuarepa cho'okʉ'teta'ni karamʉ mʉ'ʉre. Mʉ'ʉ paache cu'amajñarʉãre peore ĩsisõ, kuri koo chʉova'na pa'iva'nani rupʉ ĩsijʉ̃'ʉ. Ĩsisõjani rani chʉ'ʉna'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oni'te Dios pa'ichejana sani re'oja'che pa'ija'mʉ mʉ'ʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesupi jã'aja'ñe i'kaʉna asa kurineekʉjekʉ ĩsiʉamaʉna rʉa sʉmava'ʉ sanisoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jo'ka sakʉna Jesús si'ache repakã'jño ña repaʉ neenare ija'che i'kaasomʉ: —Pãi kurinare Dios pa'icheja saineenareta'ni saivesamʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Repaʉ i'kache asa jñanoasome repaʉ neena. Jñanorena Jesús jo'e i'kaasomʉ repanare. —Pãi kurinare Dios pa'icheja saineenareta'ni saivesamʉ, “Rʉa kuri paakʉ cheke chiima'mʉ chʉ'ʉ. Diore chiima'mʉ chʉ'ʉ”, chiijʉ cuasanajejʉna —chiniasomʉ repaʉ.— ");
INSERT INTO coe_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camellova'ʉre miuñakarʉ cojerʉ kaka etajaicu'acheja'che kuriʉ'te Dios pa'icheja saicu'aja'mʉ, repaʉji kurire na'a rʉa cuasakʉ pa'ito —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jã'aja'ñe i'kaʉna asa jñano Jesús neena sãiñechi'a ija'che i'kaasome: “Jã'a pa'ito, ¿je'se pa'inani Dios pa'icheja saire'oja'ʉ?”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chitena Jesús repanare ñakʉ ija'che i'kaasomʉ: —Maichi'a te'ena cuasajʉna Dios pa'icheja saicu'amʉ maire pãi. Diopi cho'okaitota'ni Repaʉ pa'icheja saiche vesama'mʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chikʉna Pedro i'kaasomʉ. —Chʉkʉna mʉ'ʉna'me pañu chini chʉkʉna paasimajñarʉã peore jo'kasõ rani mʉ'ʉna'me ku'ime —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Chikʉna Jesús i'kaasomʉ repanare. —Pãiʉ ũcuaʉakʉ chʉ'ʉre cuasakʉ Dios chʉ'ore sani chʉ'vakʉ pasa chiikʉ chekʉrʉmʉ repaʉ vʉ'ere jo'kasõmʉ. Chekʉrʉmʉ repaʉ majaa'chʉpãire jo'kasõmʉ. Chekʉrʉmʉ majaa'choromire jo'kasõmʉ. Chekʉrʉmʉ repaʉ cho'jechĩire jo'kasõmʉ. Chekʉrʉmʉ repaʉ pʉka'kʉpãire jo'kasõmʉ. Chekʉrʉmʉ rʉ̃joni jo'kasõmʉ. Chekʉrʉmʉ repaʉ chĩire jo'kasõmʉ. Chekʉrʉmʉ chejña repaʉ paachejñare jo'kasõni repaʉ aperʉmʉ paasimajñarʉã vʉ'ña, a'chʉpãi, a'choromi, cho'jechĩi, ja'koromi, mamachĩi, chejña jo'e na'a rʉa jñaaja'mʉ repaʉ. Ũcuachi'a Dioni cuasakʉ cu'ache cho'ocojñokʉta'ni ũhasõmaneni jũnisõsirʉmʉ Dios pa'ichejare ai sani pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pãi te'ena kuriʉ repaʉ nee jo'kacuhesi'eja'che repana neere jo'kacuhejʉ karama'ñe paajʉ chekʉnare, “Re'oja'che pa'inaa'me ina”, chiicojñome. Chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ repana paache jo'kasõnareta'ni chekʉna ña cu'ache i'kame. Jã'ata'ni Dios na'a pa'isirʉmʉ repana paache'te jo'kacuhejʉ karama'ñe paajʉ chekʉnare, “Re'oja'che pa'ime ina”, chiicojñosinare, “Cu'ache pa'inaa'me ina”, chiija'mʉ. Chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ repana paache jo'kasõ chekʉnare cu'ache i'kacojñosinareta'ni, “Re'oja'che pa'inaa'me ina”, chiija'mʉ Dios. Ũcuarepaa'me jã'a —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ũcuarʉmʉ Jesús repaʉ neenana'me Jerusalén vʉ'ejoopona maiʉ charoji maniasomʉ. Repaʉ neena vajʉchʉjʉ cho'jepi maniasome. Reparʉmʉ Jesús repaʉ neenare docerepanare soni repaʉ'te cho'ojache kʉaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kʉakʉ ija'che i'kaasomʉ repaʉ: —Mai Jerusalén vʉ'ejoopo maiñe masime mʉsanʉkona. Ũcuachejana chʉ'ʉre Dios Raosi'kʉre pãipi chẽa judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonani sa jo'kajanaa'me. Ũcuanapi chʉ'ʉre vanisõjañe chʉ̃'ʉ judío peonani jo'kajanaa'me, repanapi chʉ'ʉni cu'ache cho'oa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jo'karena repana chʉ'ʉre pãisojanaa'me. Ũcuachi'a chʉ'ʉni coo tutujʉ suĩ'sue pi'ni kurususẽ'verona jẽ'jo vẽasõjanaa'me repana chʉ'ʉre. Jã'aja'ñe cho'ocojñosi'kʉta'ni choteumucujñana vajʉraija'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ũcuarʉmʉ Zebedeo mamachĩi Santiagona'me Juan Jesure kueñe tĩ'a i'kaasome. —Masiʉ, chʉkʉna'te mʉ'ʉpi re'oja'che cho'okaaʉ chini sẽñu chiime chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chitena i'kaasomʉ repaʉ. —¿Ʉ̃quere chʉ'ʉ mʉsanʉkonare cho'okaija'che? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chikʉna i'kaasome repana. —Mʉ'ʉpi ija'che jo'kaa'kʉ chiime chʉkʉna: Mʉja'kʉna'me mʉ'ʉ chʉ̃'ʉrʉmʉ chʉkʉna te'eʉ mʉ'ʉ ʉjajʉ̃tʉ cakã'kona pʉʉ, chekʉpi mʉ'ʉ kã'kojʉ̃tʉ cakã'kona pʉʉ ñu'ijʉ ja'me chʉ̃'ʉjʉ pañu chiime chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chitena Jesús i'kaasomʉ repanare. —Mʉsanʉkona vesʉjʉ jã'aja'ñe sẽeme. Pãi chʉ'ʉre cho'ojacheja'che mʉsanʉkonare vanisõñu chiito, ¿cuhemanejanaa'ñe mʉsanʉkona? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chikʉna repana Zebedeo mamachĩi i'kaasome repaʉ'te. —Jʉ̃jʉ, cuhemanejanaa'me chʉkʉna —chiniasome. Chitena Jesús jo'e i'kaasomʉ repanare. —Chʉ'ʉre cho'ocheja'che cu'ache cho'ocojñorepajanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jã'ata'ni chʉ'ʉre repakã'jño pa'iche pʉʉjanare chʉ̃'ʉcu'amʉ chʉ'ʉre. Chʉ'ʉ Ja'kʉ apereparʉmʉ ĩsija'mʉ chʉ'ʉ chiicojñosinarechi'a jo'kaja'mʉ Repaʉ repa —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zebedeo mamachĩipi jã'aja'ñe sẽtena asa Jesús neena chekʉna pe'ruasome repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pe'rujʉna Jesús repanare soni rao i'kaasomʉ. —Iere masicosome mʉsanʉkona: Icheja cheja pãi chʉ̃'ʉna repana neenare rʉa cuaja pa'iche'te chʉ̃'ʉjʉ rʉa chʉova'nare cho'ojʉ pa'ime. ");
INSERT INTO coe_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jã'ata'ni mʉsanʉkonapi te'eʉ pãi chʉ̃'ʉkʉ pasa chini repana cho'ocheja'che cho'omanejʉ̃'ʉ. Jã'aja'ñe cho'oma'ñe cho'oche cho'okaikʉja'che chekʉnare cho'okaiʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te'eʉji chekʉnare paara chini paacojñokʉ pa'icheja'che pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jã'aja'ñe pa'ikʉ'mʉ chʉ'ʉ pãire ja'me paaʉ chini Dios Raosi'kʉ. Pãire cho'okaicojñora chini raisi'kʉma'mʉ. Pãire ũcuanʉkore re'oja'che cho'okaiʉ repana cu'are jũni ro'ikasa chini raisi'kʉa'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ũcuarʉmʉ Jesús repaʉ neenana'me Jericó vʉ'ejoopo tĩ'a jmamakarʉ pani Jerusalén vʉ'ejoopona sañu chini Jesús repaʉ neena chekʉna pãi rʉa jainʉko ja'me repajoopoji etajʉ ñato ma'a rʉ'tʉva'te Timeo mamakʉ Bartimeo na'ava'ʉjekʉ ñu'iʉ kurire sẽeʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ñu'iʉ Jesús Nazaret vʉ'ejoopo cakʉ repaʉ ñu'ichejapi caraiche'te asa repaʉ Bartimeo rʉa cuikʉ ija'che i'kaasomʉ: —Jesús, David aperʉmʉ pa'isi'kʉ Jojosi'kʉ, oijʉ̃'ʉ chʉ'ʉva'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","I'kaʉna asa repana pãi jainʉko, —Re'omʉ. Jo'e i'kamanejʉ̃'ʉ —chiniasome repaʉ'te. Jo'e i'kamanejʉ̃'ʉ chiisi'eta'ni na'a rʉa cuikʉ i'kaasomʉ repaʉ. —Jesús, David aperʉmʉ pa'isi'kʉ Jojosi'kʉ, oijʉ̃'ʉ chʉ'ʉva'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jã'aja'ñe i'kakʉ cuikʉna asa canʉka, —Repaʉ'te soijʉ̃'ʉ —chiniasomʉ Jesús. Chikʉna repana pãi na'ava'ʉni soijʉ i'kaasome. —Koka paakʉ vʉni raijʉ̃'ʉ. Jesús mʉ'ʉre soimʉ —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chitena asa repaʉ sẽ'sevʉ ju'ikãa tĩto na'mi vʉni Jesuni saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sakʉna Jesús ija'che sẽniasomʉ repaʉ'te: —¿Ʉ̃quere cho'okaaʉ chini sẽekʉ mʉ'ʉ chʉ'ʉre? —chiniasomʉ Jesús repaʉ'te. Chikʉna repaʉ na'ava'ʉ i'kaasomʉ. —Masiʉ, chʉ'ʉ ñakocaã ñoa'kʉ chiimʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chikʉna Jesús jo'e i'kaasomʉ. —“Jesús chʉ'ʉre vasoja'mʉ”, chini cuasasi'kʉjekʉna mʉ'ʉ ñakocaã ñoja'mʉ mʉ'ʉre. Chura mʉ'ʉ vajʉ saijʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. Jesupi jã'aja'ñe i'kaʉna repaʉ ñakocaã teana care'osoasomʉ. Care'oʉna Jesure jovo ja'me saniasomʉ repaʉ na'ava'ʉ pa'isi'kʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ũcuarʉmʉ Jesús repaʉ neenana'me saijʉ Jerusalén vʉ'ejoopo kueñe cajoopoã Olivo aikũti pa'ijoopoã Betfagé vʉ'ejoopona'me Betania vʉ'ejoopo cachejñana tĩ'aasome. Tĩ'a Jesús repaʉ neenare te'eka'chapanarechi'a soniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Soni repanare saora chini ija'che i'kaasomʉ repaʉ: —Jeejoopona kueñe cajoopona saijʉ̃'ʉ mʉsanʉkona. Sani tĩ'a burrova'ʉre quẽo sʉosiva'ʉre, pãi chuta'a tuhimava'ʉni ñajanaa'me mʉsanʉkona. Ña repava'ʉre jose ichejana rakaijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pãi ũcuaʉakʉji mʉsanʉkonare, “¿Ʉ̃que cho'oñu chini mʉsanʉkona jã'ava'ʉre joseche?”, chiito, “Maire Paakʉ iva'ʉre chiimʉ. Na'mi co'choja'mʉ repaʉ iva'ʉre”, chiijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chikʉna repana sani ñato burrova'ʉ pãi vʉ'e kakasa'aro kueñere, ma'a rʉ'tʉva'te quẽo sʉosiva'ʉ rʉ̃niasomʉ. Ũcuarʉmʉ repana repava'ʉre sani joseasome. ");
INSERT INTO coe_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Josejʉna ũcuacheja pa'ina ija'che i'kaasome repanare: —¿Ʉ̃quere mʉsanʉkona cho'oche? ¿Je'se pa'iʉna jã'ava'ʉre joseche? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chitena repanare Jesús i'kakʉ chʉ̃'ʉ raosi'ere kʉaasome repana. Kʉarena repava'ʉre ʉ̃semaneasome repana. ");
INSERT INTO coe_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ʉ̃semapʉna repava'ʉre Jesús pa'ichejana sa repava'ʉ sõkʉñʉna kãñapi tʉorena Jesús mʉni tuniasomʉ repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuni saiʉna repaʉ saima'ana pãi jainʉko kãña jaasome. Chekʉna ũcuaja'che sũki ka ja'o pa'ikare veri ũcuama'ana ũhaasome. ");
INSERT INTO coe_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Charo Jesure ja'me sainana'me repaʉ cho'je saina pojojʉ cuijʉ ija'che i'kaasome: —¡Dios peore masikʉ'mʉ! ¡Diopi ikʉre pãire chʉ̃'ʉa'kʉ chini Repaʉ Raosi'kʉre re'oja'che cho'okaaʉ! ");
INSERT INTO coe_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Aperʉmʉ pa'isi'kʉ mai majapãiʉ David chʉ̃'ʉsi'eja'che ikʉ Jesús re'oja'che chʉ̃'ʉja'mʉ! ¡Dios peore masikʉ'mʉ! —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jã'aja'ñe cho'ojʉna Jesús Jerusalén vʉ'ejoopo tĩ'a Dios vʉ'ena kaka pa'iʉ na'isokʉna peore si'ache repakã'jño ña pi'ni eta Betania vʉ'ejoopona co'iasomʉ, repaʉ neena docerepanana'me. ");
INSERT INTO coe_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jo'e ñatato Jesús repaʉ neenana'me Betania vʉ'ejoopoji raijʉna Jesure ãucuhaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ãucuhakʉna so'opi ñato sũkiñʉ higoñʉ ja'o sã'sasi'ñʉ paniasomʉ. Jã'aja'ñe pa'iʉna Jesús na'a kueñe sani ñato higopʉã kʉ̃ima'ñʉ ja'ochi'a paniasomʉ. Kʉ̃irʉmʉ chuta'a tĩ'amaʉna repapʉã peoasomʉ repañʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jã'aja'ñe pa'iʉna repañʉ ija'che i'kaasomʉ repaʉ: —Iñʉ sũkiñʉ jo'e kʉ̃imairo paaʉ —chiniasomʉ repaʉ. Jã'aja'ñe i'kakʉna repaʉ neena asaasome. ");
INSERT INTO coe_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jã'aja'ñe cho'ocuha Jesús repaʉ neenana'me sani Jerusalenna tĩ'aasome. Tĩ'a Jesús Dios vʉ'ena kaka repavʉ'e põse koosinana'me ĩsisinare peore eto saoasomʉ. Eto saokʉ kuri sa'ñekaina mesako'ñana'me ũkupova'na ĩsina ñu'isaivʉãre jʉjo tajño ũhaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ũcuaja'che chekʉna repana põsemajñarʉã ve'ejʉ repavʉ'epi kaka etajani sañu chiinare ʉ̃seasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jã'aja'ñe cho'okʉ repanare che'chokʉ ija'che i'kaasomʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉ vʉ'e pãi ũcuanʉko chʉ'ʉre pojojʉ sẽevʉ'ea'me, chiimʉ. Jã'ata'ni mʉsanʉkona põse ñaana cho'ocheja'che kaka cu'ache cho'ome —chiiʉ eto saoasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jã'aja'ñe cho'oʉna asa judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona pe'rujʉ repaʉ'te vanisoche chʉ̃'ʉñu chiisinata'ni pãipi ũcuanʉko repaʉ che'choche'te asa jñanojʉna repaʉ'te vajʉchʉasome repana. ");
INSERT INTO coe_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jã'aja'ñe cho'ocuha Jesús na'ito repaʉ neenana'me repajoopoji saniasome. ");
INSERT INTO coe_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jo'e ñatato Jesús repaʉ neenana'me higoñʉ pa'icheja caraiʉ ñato repañʉ saivʉãjatʉ'ka jũnisosi'ñʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Repañʉji jã'aja'ñe pa'iʉna Jesús i'kasi'e Pedro jo'e cuasakʉ i'kaasomʉ. —¡Ñakʉ, Masiʉ! Mʉ'ʉpi repañʉ'te cu'ache i'kaʉna peore jũnisõsi'ñʉa'me —chiniasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chikʉna Jesús repaʉ neenare i'kaasomʉ. —Diore cuasajʉ pa'ijʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mʉsanʉkona ũcuaʉakʉji, “Diopi cho'okaiʉna chʉ'ʉ i'kache peore cho'ore'oja'mʉ”, chiiʉ cuasakʉ ikũtire, “Icheja kʉñʉ chiarana sʉ'a nʉkajʉ̃'ʉ”, chiito repakũti mʉsanʉkona chʉ̃'ʉñe cho'oja'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jã'ajekʉna ija'che i'kamʉ chʉ'ʉ mʉsanʉkonare: Mʉsanʉkona, “Diopi chʉ'ʉ ũcuaʉache sẽeto cho'okaija'mʉ chʉ'ʉre”, chiijʉ cuasajʉ pa'ito mʉsanʉkona sẽeñe cho'okaija'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mʉsanʉkona Diore sẽñu chini chekʉna mʉsanʉkonare cu'ache cho'osi'e cavesʉsõ jo'e cuasamanejʉ̃'ʉ. Jo'e cuasama'to Dios ũcuaja'che mʉsanʉkona cu'ache cho'osi'e jo'e cuasamaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jã'ata'ni mʉsanʉkonapi chekʉna cu'ache cho'osi'ere cavesʉma'ñe ũcua cuasato Dios ũcuaja'che mʉsanʉkona cu'ache cho'osi'e cavesʉma'ñe ũcua rʉa cuasakʉ pa'ija'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ũcuarʉmʉ Jesús repaʉ neenana'me Jerusalenna jo'e sani tĩ'aasome. Tĩ'a Jesús Dios vʉ'e kaka nʉka ku'iʉ ñakʉna judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me judío aina raniasome. ");
INSERT INTO coe_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Rani repaʉ'te ija'che sẽniasome repana: —¿Je'se cuasa pãi chʉ̃'ʉna cho'ocheja'che cho'okʉ mʉ'ʉ? ¿Neepi chʉ̃'ʉrena rani cho'okʉ mʉ'ʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chitena repanare sãiñe i'kaasomʉ repaʉ. —Chʉ'ʉ ũcuaja'che mʉsanʉkonani chʉ'o sẽniasara. Sẽeʉna kʉajʉ̃'ʉ chʉ'ʉre. Kʉaru chʉ'ʉ ũcuaja'che iere cho'oa'kʉ chini chʉ'ʉre chẽa raosi'kʉ mami kʉaja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Neepi Juanre Pãi Okoro'vekʉ'te chẽa raore? ¿Diopi chẽa raoʉ? Jã'apãani, ¿pãipi chẽa raore repaʉ'te? Kʉajʉ̃'ʉ chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sẽkʉna sãiñechi'a ija'che cutuasome repana: —¿Je'se mai ikʉre i'kajanaa'ñe? Maipi, “Juanre Dios chẽa raosi'kʉa'mʉ”, chiito ikʉ maire, “¿Je'se pa'iʉna mʉsanʉkona jã'aja'ñe cuasanata'ni Juan chʉ'vasi'e cuasamanere?”, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ũcuaja'che, “Pãipi Juanre chẽa raosinaa'me”, chiicu'amʉ maire —chiniasome repana. Reparʉmʉ pãi rʉa jainʉko, “Juan Dios chʉ'o kʉakaikʉ pa'isi'kʉa'mʉ”, chiijʉ cuasajʉna i'kavajʉchʉasome repana, chekʉnapi asa pe'rujʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Vajʉchʉjʉ Jesure ija'che i'kaasome repana: —Juanre raosi'kʉ mami vesʉme chʉkʉna —chiniasome. Chitena Jesús i'kaasomʉ repanare. —Chʉ'ʉ ũcuaja'che mʉsanʉkonapi jã'aja'ñe i'karena chʉ'ʉre chʉ̃'ʉ raosi'kʉ mami kʉamaneja'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ũcuarʉmʉ Jesús repanare chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ: —Pãiʉ pĩsi ʉche chio tã pi'ni si'acachio rũhiso'koro jeo tʉsʉasomʉ. Repaso'koro jeo pi'ni ʉche cha'ca chachojavʉ je'naasomʉ repaʉ ũcuate'evʉji conora'ka meajacheja pa'ivʉ. Ũcuachi'a repachio kuirakaijanapi si'acachio ñajʉ kuirakaijʉ paapʉ chini vʉ'e ʉmʉ nʉkavʉ'e cho'oasomʉ repaʉ. ’Peore cho'o pi'ni repa chio kuirakaijanare jñaa jo'ka tĩichejana sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sani pa'iʉ ʉche tʉarʉmʉ tĩ'aʉna repaʉ'te cho'oche cho'okaikʉ'te ʉche chio kuirakaina pa'ichejana saoasomʉ repaʉ, ʉchere miijani rakaaʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jã'ata'ni sani tĩ'aʉna ña repana ʉche kuirana repaʉ'te chẽa vani, ʉchejẽ'e peoʉ'te ʉche paakʉ pa'ichejana co'choasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Co'chorena ña ʉche paakʉ repaʉ'te cho'oche cho'okaikʉ'te chekʉni jo'e ũcuachejana saoʉna sani tĩ'aʉna ña repana ʉche kuirana repaʉ'te catapʉãpi repaʉ sĩjopʉna asi su'a repaʉ'te rʉa cu'ache cutu pi'ni ʉchejẽ'e peoʉ'te co'choasome. ");
INSERT INTO coe_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Co'chorena chekʉre jo'e saoasomʉ repaʉ. Saoʉna repaʉ'te vanisõasome repana. Chekʉnani asi vaniasome repana. Chekʉnare vanisõasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Jã'aja'ñe cho'ojʉna churata'ni repaʉ mamakʉ'te rʉa oiʉ paakʉ'te, “Chʉ'ʉ chĩireta'ni ña kʉkʉjacosome repana”, chiiʉ cuasa cho'jerepana mamakʉ'te saoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jã'ata'ni repaʉ mamakʉji sani tĩ'aʉna ña repachio kuirakaina sãiñechi'a ija'che i'kaasome: “Jã'ʉ ʉche paakʉ mamakʉ'mʉ. Pʉka'kʉ jũnisõsirʉmʉ repaʉ paasi'e paajaʉa'mʉ jã'ʉ. Vanisõñu jã'ʉni. Maipi pʉka'kʉ jũnisõsirʉmʉ repaʉ paasi'ere paañu”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chini repaʉ'te chẽa vanisõ chio rʉ'tʉvana sa ũhaasome repana repaʉ'te —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jã'aja'ñe kʉacuha repaʉ kʉasi'e asasinare ija'che sẽniasomʉ repaʉ: —Repaʉ mamakʉ'te vanisõsi'ere asa ʉche chio paakʉji sani, ¿je'se cho'oja'ʉ repanare ʉche kuirakainare? Sani repaʉ mamakʉ'te vanisõsinare sãiñe vanisõja'mʉ repaʉ. Repanare vanisõ ʉche chio kuirakaijanare chekʉnani jñaa jo'kaja'mʉ repaʉ, cu'ache cho'oma'ñe ʉche tʉa pi'ni repaʉ'te sa ĩsijanani. ");
INSERT INTO coe_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Dios chʉ'o aperʉmʉ tocha jo'kasi'e ñamanaa'ñe mʉsanʉkona? Ija'che kʉamʉ: Pãi vʉ'e cho'ona vʉ'ña tuu re'ojatuure ku'ejʉ paniasome. Ku'ejʉ te'etuupʉ jñaani cuheasome repana. Cuhejʉ jo'kaasome repatuupʉ. Chekʉnata'ni na'a rʉa masinajejʉ rani repatuupʉ mini kuãa sa repana vʉ'e chakavʉna nʉkoasome, repana vʉ'epi na'a rʉa jʉjaa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Diopi cho'okaiʉna jã'aja'ñe cho'orena ña cuasa Repaʉni pojojʉ i'kame chʉkʉna, chiimʉ Dios chʉ'o tocha jo'kasi'e —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesupi jã'aja'ñe i'kaʉna asa judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me judío aina asamasi, “Ikʉ Jesús ũcuaʉ cuasakʉ kʉacheji maini cu'ache cutumʉ”, chiijʉ pe'ruasome. Pe'rujʉ repaʉ'te chẽañu chiinata'ni pãire chekʉnani vajʉchʉjʉ repaʉ'te jo'ka sanisoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ũcuarʉmʉ judíopãi chʉ̃'ʉnapi fariseopãina'me Herode'te chiinare te'enare soni ija'che i'kaasome: —Jesús pa'ichejana sani repaʉ'te chʉ'o rʉa sẽniasajʉ̃'ʉ. Jã'aja'ñe sẽejʉna repaʉ tĩiñe i'kato asa repaʉ i'kasi'e maire chʉ̃'ʉnani kʉañu. Maipi kʉato chekʉrʉmʉ repaʉ'te chẽañe chʉ̃'ʉjanaa'me repana —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chini saoʉna sani Jesure ija'che i'kaasome repana: —Masiʉ, chʉ'o ũcuarepare cutukʉ'mʉ mʉ'ʉ. Pãipi asa chẽa re'oja'che paapʉ chini Dios chʉ̃'ʉñe ũcuarepare che'chokʉ'mʉ mʉ'ʉ. Jã'a masime chʉkʉna. Mʉ'ʉ che'choche'te chekʉnapi asa cu'ache i'katojẽ'e kʉkʉ cuasoma'ñe ũcua che'chokʉ pa'ikʉ'mʉ mʉ'ʉ. Jã'ajekʉna mʉ'ʉni chʉ'o sẽniasañu chiime chʉkʉna, mʉ'ʉ cuasakʉ i'kache'te asa masiñu chini. Romapãi chʉ̃'ʉkʉji Césapi chʉkʉna pa'iche ro'ire sẽeto, ¿ro'ijanaa'ñe chʉkʉna repaʉ'te? ¿Ro'imanejanaa'ñe? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jã'ata'ni Jesús repana cu'ache cho'oñu chiiche'te masikʉ ija'che i'kaasomʉ repanare: —Chʉ'ʉni cacʉ'oñu chini jã'aja'ñe sẽeme mʉsanʉkona. Kurire'reva chʉ'ʉre rajʉ̃'ʉ; ñara —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chikʉna repaʉ'te kurire'reva miijani ra ñoasome repana. Ñojʉna Jesús ija'che i'kaasomʉ repanare: —Ikʉ kurire'reva pa'ikʉ kuechʉsi'kʉ, ¿keeja'iʉ'ʉ? Ũcuachi'a, ¿nee mamipi pa'ikʉ ire'reva? —chiniasomʉ. Chikʉna i'kaasome repana. —Maire chʉ̃'ʉkʉ César chiana'me repaʉ mami pa'imʉ jã'are'reva —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chitena Jesús i'kaasomʉ repanare. —Jã'a pa'ito pa'iche ro'ire repaʉji kuri ro'iche chʉ̃'ʉto ro'ijʉ̃'ʉ repaʉ'te. Dios chʉ̃'ʉ jo'kasi'e ũcuachi'a cho'ojʉ pa'ijʉ̃'ʉ —chiniasomʉ repaʉ. Jã'aja'ñe i'kaʉna asa kʉkʉasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ũcuarʉmʉ saduceopãi Jesuni ñañu chini saniasome. “Pãi jũ'isina jo'e vajʉraimanejanaa'me”, chiijʉ cuasanajejʉ Jesure ija'che sẽniasome repana: ");
INSERT INTO coe_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Masiʉ, Diopi chʉ̃'ʉʉna Moisés aperʉmʉ tocha jo'kasi'e ija'che chiimʉ: Pãiʉ romio'te vejasi'kʉpi, chuta'a chĩi peokʉji jo'ka jũnisõru repaʉ cho'jeʉji veja paaa'kʉ majaa'chʉ paasi'kore. Repaoni veja chĩire paakʉ ija'che cuasakʉ paaʉ: “Chʉ'ʉ a'chʉ jũnisõsiva'ʉ chĩijanaa'me ina chʉ'ʉ chĩi”, chiaʉ, chiimʉ repaʉ tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jã'ajekʉna chʉ'o kʉañu chiime chʉkʉna mʉ'ʉre. Pãiʉ charo cakʉ cho'jechĩi ʉmʉpãichi'a seirepanare paaasomʉ. Repaʉ charo cakʉ romio'te veja paakʉ chuta'a chĩi peokʉji jo'ka jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jo'ka jũnisoʉna cho'jeʉ repaʉ majaa'chʉ rʉ̃jo pa'isi'koni veja paakʉ ũcuaja'che chuta'a chĩi peokʉji jo'ka jũnisoasomʉ. Jũnisoʉna na'a cho'je cakʉ ũcuate'eo'te veja ũcuaja'che chĩi peokʉji jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jã'aja'ñechi'a sieterepana ũcuanʉko ũcuate'eo'te vejajʉ chĩi peonachi'a jo'ka jũnisoasome repana. Repana peore jũnisosirʉmʉ romio ũcuaja'che jũnisoasomo. ");
INSERT INTO coe_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jã'ajekʉna pãi jũnisosina ũcuanʉko jo'e vajʉraisirʉmʉ, ¿kaʉpi repao'te jo'e paaja'ʉ, sieterepana veja paacojñosi'kore? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chitena Jesús i'kaasomʉ repanare. —Tĩiñe cuasame mʉsanʉkona. Dios chʉ'o aperʉmʉ tocha jo'kasi'ejẽ'e vesʉjʉ jũ'isinare Dios vasomasichejẽ'e vesʉme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pãi ũcuanʉko jo'e vajʉraisirʉmʉ ʉmʉpãina'me romi jo'e vejamanejanaa'me, Diore ja'me pa'ina ángeles pa'icheja'che pa'inajejʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","¿Diopi chʉ̃'ʉʉna Moisés tocha jo'kasi'e jũ'isina vajʉraiche kʉache ñamanaa'ñe mʉsanʉkona? Aperʉmʉ Moisés sũkira'ñʉrʉ uutoa toa kueñe nʉkakʉ ñakʉ paniasomʉ. Ñakʉ nʉkakʉna ũcuatoa sa'navʉji Diopi i'kakʉna asakʉ tocha jo'kaasomʉ repaʉ Moisés. “Chʉ'ʉ Dios, mʉsanʉkona aipãi icheja pa'irʉmʉ chʉ'ʉre cuasasinare paakʉ'mʉ chʉ'ʉ Abrahamre, Isaare, Jacobre”, chiisi'kʉa'mʉ Dios, chiimʉ repaʉ tocha jo'kasi'e. Diopi ñato pãi jũnisõsinajẽ'e vajʉme, repana rekoñoãpi vajʉkʉna. Jã'a jachajʉ cuasama'ñe rʉa tĩiñe cuasame mʉsanʉkona —chiniasomʉ Jesús repanare saduceopãi. ");
INSERT INTO coe_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ũcuarʉmʉ judíopãi che'chokʉ rani Jesure saduceopãi ke'resi'e asaasomʉ. Jesupi rʉa masi i'kakʉna asa ija'che sẽniasaasomʉ repaʉ: —Dios maire chʉ̃'ʉ jo'kasi'e, ¿jeea'che Repaʉ maire na'a rʉa cho'ojʉ̃'ʉ chiiche? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chikʉna Jesús ija'che i'kaasomʉ: —Dios maire ija'chere i'kakʉ na'a rʉa chʉ̃'ʉmʉ: Asarepajʉ̃'ʉ, Israelpãi. Chʉ'ʉ mʉsanʉkonare Paakʉ ũcuate'eʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jã'ajekʉna pãi mʉsanʉkonare ũcuanʉkore Paakʉ'te chʉ'ʉre mʉsanʉkona aʉna'me rekoñoãna'me kokana'me cuasache peore jã'api rʉa cuasajʉ pa'ijʉ̃'ʉ. Mʉsanʉkona meñe oicheja'che chekʉnare oijʉ pa'ijʉ̃'ʉ, chiiʉ chʉ̃'ʉmʉ Repaʉ. Dios jã'aja'ñe chʉ̃'ʉ jo'kakʉ maire, “Jã'are cho'ojʉ pa'ijʉ̃'ʉ”, chiiʉ na'a rʉa chʉ̃'ʉmʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Cheke ũcuaja'chea'me, Repaʉ chʉ̃'ʉrepache. Ija'che chiimʉ: Mʉsanʉkona meñe oicheja'che chekʉnare oijʉ pa'ijʉ̃'ʉ, chiimʉ Dios. Jã'aja'ñe, “Cho'ojʉ pa'ijʉ̃'ʉ”, chiiʉ na'a rʉa chʉ̃'ʉmʉ Dios maire. Chekejẽ'e na'a rʉa chʉ̃'ʉma'mʉ Repaʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chikʉna judíopãi che'chokʉ i'kaasomʉ repaʉ'te. —Masiʉ, ũcuarepaa'me jã'a, mʉ'ʉ i'kache. Dios ũcuate'eʉ'mʉ. Chekʉ maire paakʉjẽ'e peomʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mai judíopãi Diore pojojʉ cu'amajñarʉã Repaʉni ĩsijʉ ʉosome. Jã'aja'ñe cho'ojʉna pojocosomʉ Repaʉ maire. Jã'ata'ni maipi Repaʉni rekoñoãpi rʉa masi cuasajʉ mai meñe oicheja'che chekʉnare oijʉ pa'ito na'a rʉa pojocosomʉ Dios maire —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jã'aja'ñe i'kaʉna asa Jesús, “Ikʉ masi i'kasi'kʉa'mʉ”, chiiʉ cuasa ija'che i'kaasomʉ repaʉ'te: —Jã'aja'ñe cuasakʉjekʉ Dios chʉ̃'ʉñe asa chẽapi'ramʉ mʉ'ʉ —chiniasomʉ repaʉ repaʉ'te. Reparʉmʉ pãi Jesure chʉ'o jo'e sẽevajʉchʉasome. ");
INSERT INTO coe_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ũcuarʉmʉ Jesús Dios vʉ'ere pa'iʉ pãire che'chokʉ ija'che i'kaasomʉ: —Mai judíopãi che'chona ija'che i'kame: “Aperʉmʉ pa'isi'kʉ David Jojosi'kʉa'mʉ Cristo”, chiime. ");
INSERT INTO coe_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Repaʉ David, aperʉmʉ Dios Rekochoji kʉakʉna tocha jo'kasi'e ija'che chiimʉ: Dios chʉ'ʉre Paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre kueñe ʉjajʉ̃tʉ cakã'kona pʉʉjʉ̃'ʉ. Chʉ'ʉpi cho'okaiʉna mʉ'ʉre cuhesina ũcuanʉko mʉ'ʉ chʉ̃'ʉñe cho'ojanaa'me”, chiniasomʉ. Jã'aja'ñe tocha jo'kaasomʉ David. ");
INSERT INTO coe_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","’¿Je'se pa'iʉna David, “Chʉ'ʉre Paakʉ'mʉ Cristo”, chiisi'eta'ni, “David Jojosi'kʉa'mʉ Cristo”, chiiche mai judíopãi che'chona? —chiniasomʉ Jesús repanare. Reparʉmʉ pãi jainʉko Jesús i'kache asa pojoasome. ");
INSERT INTO coe_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ũcuarʉmʉ Jesús pãire jo'e che'chokʉ ija'che i'kaasomʉ: —Judíopãi che'chona pa'iche ña chẽamanejʉ̃'ʉ mʉsanʉkona. Kãña re'ojakãñapi ʉjacueñoã ju'ijʉ nʉka ku'ime repana, pãipi ña, “Diore rʉa cuasanaa'me jã'ana”, chiapʉ chini. Ãu ĩsichejñare ku'ijʉna pãipi repanani ña chẽa pojojʉ, “Peore masinajejʉ che'chonaa'me ina”, chiito rʉa pojonaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ũcuaja'che judíopãi chi'ivʉ'ena mʉa kakani masina ñu'isaivʉãre ñu'ineenaa'me repana. Ũcuaja'che pãipi repanani ãu ãuñu chini soito mʉa repanare soisi'kʉre kueñe ñu'ineenaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ũcuachi'a va'jeva'na paache jorejʉ tʉtesõnaa'me repana. Jã'aja'ñe cho'onata'ni pãipi ña, “Re'onaa'me jã'ana”, chiapʉ chini Diore sẽni rʉa jeerʉmʉ sẽejʉ pa'inaa'me repana. Jã'aja'ñe cho'onajejʉna Diopi chʉ̃'ʉʉna rʉa cu'ache ti'jñeja'mʉ repanare —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ũcuarʉmʉ Jesús Dios vʉ'ena kaka cãjovʉ kuri mañavʉ nʉkacheja kueñe pʉʉ ñu'iʉ ñato Dioni ĩsijʉ pãi jainʉko kuri mañajʉ paniasome. Ũcuachi'a kurina jainʉko kuri rʉa mañaasome. ");
INSERT INTO coe_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ũcuarʉmʉ va'jeva'o chʉova'o pa'iva'o ũcuaja'che te'eka'chapare'rerʉãchi'a ka'charʉ pa'ire'rerʉãre mañaasomo. ");
INSERT INTO coe_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Mañaona ña Jesús repaʉ neenare soni rao i'kaasomʉ. —Ina kurinata'ni repana koojʉna cajejaisi'ere ĩsisinaa'me. Iva'ota'ni repao ãu koo ãio pasa chiisire'rerʉãre Dioni pojoko peore ĩsisõsi'koa'mo. Kurina ĩsisi'e ña pojomʉ Dios. Jã'ata'ni iva'o ĩsisi'e ña na'a rʉa pojomʉ Dios. Ũcuarepaa'me jã'a —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ũcuarʉmʉ Jesús Dios vʉ'e pa'isi'kʉpi etaʉna repaʉ neena te'eʉ repaʉ'te i'kaasomʉ. —¡Ñakʉ, Masiʉ! Catapʉã rʉa re'ojapʉãpi cho'osivʉ'ñaa'me ivʉ'ña —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chikʉna Jesús i'kaasomʉ. —Mʉsanʉkona ivʉ'ña peore ñajʉ pa'ime, “Re'oja'imʉ”, chini. Jã'ata'ni na'a pa'isirʉmʉ, catapʉã te'epʉjẽ'e chekʉpʉna'me sʉ'ima'ñe peore ñañosõjanaa'me pãi ivʉ'ña —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jã'aja'ñe i'kacuha Jesús repaʉ neenana'me Olivo aikũti Dios vʉ'e ti'jñeñe cakũtina mʉni pʉʉ ñuniasome. Pʉʉ ñu'ijʉ Pedro, Santiago, Juan, Andrena'me repaʉ'te Jesure te'eʉ'te chʉ'ore sẽniasome. ");
INSERT INTO coe_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Mʉ'ʉ kʉasi'e, ivʉ'ña ñañosõjañe, ¿jeerʉmʉ cho'ojachea'che? Reparʉmʉ tĩ'añe, ¿je'se masijanaa'ñe chʉkʉna? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chitena Jesús i'kaasomʉ. —Ñarepajʉ pa'ijʉ jorena i'kache asa cuasama'ñe pa'ijʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pãi jainʉko te'enachi'a ku'ijʉ jorejʉ chʉ'ʉni roijʉ, “Dios Raosi'kʉa'mʉ chʉ'ʉ. Cristoa'mʉ”, chiijanaa'me. Jã'aja'ñe i'kajʉ jorejʉ pãi jainʉkore cacʉ'ojanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ũcuachi'a si'achejña pãi vaiche asani kʉkʉmanejʉ̃'ʉ mʉsanʉkona. Jã'aja'ñe pa'ija'mʉ cheja si'api'rarʉmʉ. Jã'ata'ni cheja chuta'a si'amaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pãi ũcuate'echeja pa'ina chekʉchejña pa'inani sani vanisõjanaa'me. Ũcuaja'che cheja si'achejñarʉã rʉa pi'ruja'mʉ. Ũcuaja'che rʉarepa asukʉ ãupi aineemaʉna si'achejñarʉã ãucuhana jũnisõjanaa'me pãi. Jã'ata'ni peore jã'a na'a rʉa cu'ache cho'orʉmʉpi tĩ'api'rakʉ cho'oche'me. ");
INSERT INTO coe_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ñarepajʉ pa'ijʉ̃'ʉ. Reparʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna chẽa judíopãi chʉ̃'ʉna pa'ivʉ'ena sa jo'ka, repanapi suĩ'sueche'te chʉ̃'ʉrena judíopãi chi'ivʉ'e cuaa suĩ'suejanaa'me. Chekʉrʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna chẽa pãi chʉ̃'ʉna pa'ivʉ'ñana sa jo'kajanaa'me, mʉsanʉkonare cu'ache cho'oche'te chʉ̃'ʉa'jʉ chini. Jã'aja'ñe cho'ojʉna repanare pãi chʉ̃'ʉnare chʉ'ʉ pa'iche'te kʉa asojanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dios chʉ'o re'oja'che chʉ'ʉre cuasanapi ku'ijʉ chʉ'vajanaa'me, pãipi si'achejña pa'ina asa chẽaa'jʉ chini. Jã'aja'ñe cho'o pi'nisirʉmʉna icheja cheja si'asõja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ũcuachi'a reparʉmʉ pãipi mʉsanʉkonani chẽa pãi chʉ̃'ʉna pa'ivʉ'ena sa jo'karu, “¿Je'se sãiñe i'kaja'che chʉ'ʉ?”, chiijʉ cuasamanejʉ̃'ʉ. Mʉsanʉkonare sãiñe i'kache tĩ'arʉmʉ mʉsanʉkona i'kajache chʉ'o Diopi rekoñoãna kʉaja'mʉ. Mʉsanʉkona te'ena cuasajʉ i'kama'ñe mai Ja'kʉ Dios Rekochoji cho'okaiʉna masi i'kajanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Reparʉmʉ pãi repana cho'jechĩi chʉ'ʉni cuasajʉna chẽa sa, “Vanisõjʉ̃'ʉ inare”, chiijʉ jo'kajanaa'me. Ũcuaja'che chekʉna repana majaa'chʉpãipi chʉ'ʉni cuasajʉna cu'ache cho'ojanaa'me. Pʉka'kʉpãi ũcuachi'a repana mamachĩipi chʉ'ʉni cuasajʉna chẽa sa, “Inare vanisõjʉ̃'ʉ”, chiijʉ jo'kajanaa'me. Ũcuaja'che chekʉna repana pʉka'kʉpãipi chʉ'ʉni cuasajʉna ũcuaja'che cu'ache cho'ojanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pãi jainʉko mʉsanʉkonare chʉ'ʉni cuasajʉna rʉa cuhejanaa'me. Jã'ata'ni mʉsanʉkonapi chʉ'ʉre cuasache'te ũhasõma'ñe jũnisõrʉmʉjatʉ'ka masi cuasajʉ pani Dios pa'ichejare ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Dios chʉ'o aperʉmʉ kʉasi'kʉ Daniel tocha jo'kasi'e ija'che chiimʉ: Na'a pa'isirʉmʉ pãi Dios cuheche'te rupʉ tʉ̃osi'kʉni Dios vʉ'ena sa nʉko, “Dioa'mʉ ikʉ. Pojojʉ̃'ʉ ikʉre”, chiijanaa'me, chiimʉ. Repa tochasi'ere ñani masijanaa'me mʉsanʉkona. Pãipi jã'aja'ñe cho'ojʉna ñani Judea cheja pa'ina aikũjñana vʉ'vʉ katisõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pãi ũcuaʉana repana vʉ'ña ve'koroãre pani cu'amajñarʉãre miñu chini kakama'ñe teana vʉ'vʉsõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ũcuaja'che pãi chiño saisina pani repana vʉ'ña paache'te cu'amajñarʉãre miñu chini co'ima'ñe teana vʉ'vʉsõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Reparʉmʉ romiva'nare chĩi sʉ'iva'nana'me oje chũsava'nare rʉa vesache cu'ache pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dioni rʉa sẽejʉ pa'ijʉ̃'ʉ, reparʉmʉpi okorʉmʉna tĩ'amanea'kʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Reparʉmʉ tĩ'aru mamarʉmʉpi irʉmʉjatʉ'ka pãi jmamakarʉjẽ'e ñama'ñepi cu'a rʉa cu'acheji pa'ija'mʉ. Ũcuachi'a reparʉmʉ cho'osi'e cu'a jo'e ti'jñemaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Repa cu'ache pa'irʉmʉre Diopi ʉ̃semaʉna na'a jeerʉmʉ cu'ache pa'ito pãi te'eʉjẽ'e jujama'ñe cho'osõra'ame. Jã'ata'ni Diopi Repaʉ chẽa paanani oiʉ ʉ̃sekʉna cu'a rʉa jeerʉmʉ pa'imaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Reparʉmʉ pãi mʉsanʉkonare ija'che i'kajanaa'me: “Rani ñajʉ̃'ʉ. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉ ichejare pa'imʉ.” Jã'apãani, “Sani ñajʉ̃'ʉ. Dios Raosi'kʉ jeechejare pa'imʉ”, chiijanaa'me. Pãipi jã'aja'ñe i'kato asa jachajʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Reparʉmʉ pãi te'enachi'a ku'ijʉ jorejʉ, “Dios Raosi'kʉa'mʉ chʉ'ʉ. Cristoa'mʉ”, chiijanaa'me. Chekʉnapi, “Dios chʉ'o kʉanaa'me chʉkʉna”, chiijanaa'me. Jã'aja'ñe jorejʉ i'kajʉ Diochi'a cho'omasicheja'chere cho'o ñojanaa'me repana, Dios chẽa paanapi ña Repaʉ'te cuasache'te jo'kasõ ũcuanani jovo repana chʉ̃'ʉñe'te cho'ojʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mʉsanʉkonare repana cho'ojachere masia'jʉ chini irʉmʉna kʉamʉ chʉ'ʉ. Jã'ajekʉna ñarepajʉ pa'ijʉ̃'ʉ mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ. —Repa cu'ache cho'o pi'nisirʉmʉ ʉ̃sʉʉ miamaneja'mʉ. Pãimiaʉ ũcuaja'che miamaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Cʉnaʉmʉ pa'ina ma'jñoko chejana tuã'tuasõjanaa'me. Ũcuachi'a cʉnaʉmʉ pa'imajñarʉã ñʉ'kueja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Reparʉmʉ chʉ'ʉ Dios Raosi'kʉ peore Masiʉji rʉa re'oja'che ñoʉ ko'sija'iʉ cʉnaʉmʉpi pãi ũcuanʉko ñajʉ'te pikona'me cajeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Caje chʉ'ʉ neenare ángeleva'nare chʉ̃'ʉ saoʉna sani chʉ'ʉ chẽa paanare cheja si'achejñarʉã pa'inare rʉa so'ñapi ra chi'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Chura higoñʉ pa'iche'te cuasajʉ̃'ʉ. Higoñʉ karʉã ã'jikarʉã carũni ja'o ma'mañe ñani, “Ʉ̃sʉrʉmʉ tĩ'api'ramʉ ie”, chiime mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ũcuaja'che chʉ'ʉ chura kʉasi'epi tĩ'akʉna ñani, “Jesús, Dios Raosi'kʉ chejana jo'e cajepi'ramʉ”, chiijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mʉsanʉkona jojosina chuta'a jũnisõmarʉmʉna chʉ'ʉ kʉasi'e peore ti'jñeja'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cʉnaʉmʉna'me cheja si'asõja'mʉ. Chʉ'ʉ chʉ̃'ʉ jo'kasi'eta'ni si'asõma'ñe ũcua pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pãi te'eʉjẽ'e masima'me chʉ'ʉ kʉasi'e ti'jñejarʉmʉ. Cʉnaʉmʉ pa'ina ángeles ũcuachi'a vesʉme. Chʉ'ʉ Dios Mamakʉ ũcuachi'a vesʉmʉ. Ja'kʉchi'a masimʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Chʉ'ʉ mʉsanʉkonare kʉasi'e ti'jñejarʉmʉ vesʉnajejʉ ñarepajʉ pa'ijʉ chʉ'ʉni cha'ajʉ Dioni sẽejʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ija'chea'me: Chekʉrʉmʉ pãiʉ chekʉchejana saipi'rakʉ repaʉ'te cho'oche cho'okainare soni rao vʉ'e kuirakaiche'te jo'kaasomʉ. Ũcuanʉkore si'acairo repana cho'ojache chʉ̃'ʉ jo'kaasomʉ repaʉ. Repa vʉ'e kakasa'aro pẽ'jekaikʉ'te ija'che i'kaasomʉ: “Chʉ'ʉ jo'e raijachere pẽ'jekʉ cha'akʉ pa'ijʉ̃'ʉ”, chiniasomʉ. Chini jo'ka saniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Repaʉ vʉ'e paakʉ raijarʉmʉ repaʉ neena vesʉcheja'che chʉ'ʉ mʉsanʉkonare Paakʉ jo'e raijarʉmʉ vesʉme mʉsanʉkona. Vesʉnajejʉ ñarepajʉ pa'ijʉ chʉ'ʉni cha'ajʉ pa'ijʉ̃'ʉ. Chekʉrʉmʉ na'itona chekʉrʉmʉ ñamirepana chekʉrʉmʉ kura chu'irʉmʉna chekʉrʉmʉ ñatacuhatona raija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mʉsanʉkonapi chʉ'ʉ jo'e raijachere ña jñanomaneñu chini cha'ajʉ pa'ijʉ̃'ʉ. Chekʉrʉmʉ peosi'kʉpi teana raija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chura chʉ'ʉ mʉsanʉkonare chʉ'vasi'e pãi ũcuanʉkore chʉ'vamʉ chʉ'ʉ. Chʉ'ʉ jo'e raijache cha'ajʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ũcuarʉmʉ judíopãi pã saʉmanesi'e ãirʉmʉ, pascua tĩ'añe ka'chaumucujña karatona judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona Jesuni vanisoche'te chʉ̃'ʉñu chini te'ena cutuasome. ");
INSERT INTO coe_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jã'aja'ñe cho'oñu chiinata'ni ija'che i'kaasome repana: —Pascuarʉmʉna repaʉ'te chẽañe chʉ̃'ʉmaneñu mai. Jã'arʉmʉna cho'oru pãi si'achejña raisina jainʉko asa pe'rujʉ cavajanaa'me —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ũcuarʉmʉ Jesús Betania vʉ'ejoopo'te paniasomʉ, Simón asi ravʉ paakʉ chiicojñokʉ vʉ'ere. Pa'iʉ mesako'a ñu'iʉ ãu ãitona romio ma'ñatʉopʉ alabastroji cho'ositʉopʉ okoma'ña nardoma'ña rʉa ro'isitʉopʉ ra ũcuavʉ'ena kakaasomo. Kaka repatʉopʉ jaopa'parʉ cachejapi chau Jesús sĩjopʉna roasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jã'aja'ñe cho'oona ña ũcuavʉ'e pa'ina chekʉna pe'rujʉ sãiñechi'a cutuasome. —¿Je'se pa'iʉna iko jã'ara'ka rurepapʉ jañosoo? ");
INSERT INTO coe_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Repara'kare ĩsisoni kuri trescientorepare're denariore're koora'amo repao. Jã'ajanʉko koo chʉova'na pa'iva'nare ĩsirʉja'chere cho'osomo repao —chiniasome repana. Pe'rujʉ repao'te rʉa i'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pe'rujʉ i'kajʉna asa Jesús i'kaasomʉ. —Iko cho'oche ñajʉ ke'remanejʉ̃'ʉ mʉsanʉkona. Repao chʉ'ʉre okoma'ña rosi'e re'oja'chere cho'osi'koa'mo iko. ");
INSERT INTO coe_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pãi chʉova'na pa'iva'na mʉsanʉkonana'me si'arʉmʉ pa'ijanaa'me. Jã'ajekʉna repanare si'arʉmʉ re'oja'che cho'okaijʉ pa'ire'oja'mʉ mʉsanʉkonare. Chʉ'ʉta'ni mʉsanʉkonare si'arʉmʉ ja'me pa'imaneja'mʉ. Jã'ajekʉna chʉ'ʉre si'arʉmʉ jã'aja'ñe cho'okaicu'aja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iko repao'te cho'ore'oche cho'oko chʉ'ʉre okoma'ña rosi'koa'mo. Iko chʉ'ʉre jũnisõ tãcojñopi'rakʉni irʉmʉ okoma'ña rosi'koa'mo, jũ'isinare cho'ocheja'che. ");
INSERT INTO coe_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cheja ũcuaʉachejña Dios chʉ'o chʉ'vachejña iko chʉ'ʉre cho'osi'e ũcuaja'che kʉajanaa'me, pãipi repao re'oja'che cho'osi'ere cavesʉma'ñe cuasajʉ paapʉ chini. Ũcuarepaa'me jã'a —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ũcuarʉmʉ Jesús neenare, docerepanare ja'me pa'ikʉji Judas Iscariote judío phairipãi chʉ̃'ʉna pa'ivʉ'ena mʉa i'kaasomʉ. —¿Je'se cho'oni'te mʉsanʉkonare Jesure jo'kaja'che chʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jã'aja'ñe i'kakʉna asa pojojʉ, —Mʉ'ʉpi jã'aja'ñe cho'oto kuri ro'ijanaa'me chʉkʉna —chiniasome repana. Jã'aja'ñe i'karena, “Jaʉ”, chini Jesús pa'ichejana sani pẽ'je ñakʉ paniasomʉ repaʉ, Jesuni jo'kara chini. ");
INSERT INTO coe_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ũcuarʉmʉ judíopãi pã saʉmanesi'e ãirʉmʉ pascua charo cho'oumucusena Dios aperʉmʉ cho'okaisi'e cuasajʉ ovejachĩiva'ʉni vaniso Diore ĩsiumucusena Jesús neena ija'che sẽniasaasome repaʉ'te: —¿Jeechejana mai pascuarʉmʉ ãijañe ãu care'vajaijʉ̃'ʉ chiikʉ mʉ'ʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chitena Jesús repaʉ neenare te'eka'chapanare saopi'rakʉ ija'che i'kaasomʉ repanare: —Chura vʉ'ejoopona sani tĩ'a pãiʉ'te churupʉ oko pa'ipʉ sakʉni tijñajanaa'me mʉsanʉkona. Tijña ũcuaʉna'me saijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sani repaʉ kakavʉ'ena kakajʉ̃'ʉ. Kaka vʉ'e paakʉ'te sẽniasajʉ̃'ʉ. “Masiʉ mʉ'ʉni sani sẽniasaa'jʉ chini raomʉ chʉkʉna'te. ‘¿Jeeruupʉna chʉ'ʉ neenana'me pascuarʉmʉ kaka ãu ãija'ñe chʉ'ʉ?’, chiisi'kʉa'mʉ Jesús”, chiijʉ̃'ʉ repaʉ'te vʉ'e paakʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mʉsanʉkonapi sẽeto ʉmʉ caruupʉ'te ʉjaruupʉ'te ñoja'mʉ repaʉ, masi care'vasiruupʉ'te. Ñoʉna ũcuaruupʉna kaka mai pascuarʉmʉ ãijañe ãu care'vajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chikʉna vʉ'ejoopo sani tĩ'ato Jesús i'kasi'e ũcuarepa paniasomʉ. Jã'ajekʉna pascuarʉmʉ ãijañe ãu care'vaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Care'vasirʉmʉ na'icuhatona Jesús repaʉ neena docerepanana'me repavʉ'ena sani kakaasome. ");
INSERT INTO coe_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kaka mesako'are ñu'ijʉ ãu ãirʉmʉna Jesús repaʉ neenare ija'che i'kaasomʉ: —Maina'me ãu ãikʉ te'eʉ chʉ'ʉni cu'ache cho'oa'jʉ chini chʉ'ʉre cuhenani jo'kaja'mʉ. Ũcuarepaa'me jã'a —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jã'aja'ñe i'kaʉna asa sʉma'ñe cuasajʉ repaʉ neena te'enachi'a repaʉ'te ija'che sẽniasome: —¿Chʉ'ʉa'che mʉ'ʉre jã'aja'ñe jo'kajaʉ? —chiniasome repana ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chitena Jesús i'kaasomʉ. —Chʉ'ʉre cu'ache cho'ojaʉ, mʉsanʉkonare chʉ'ʉ neena docerepanare ja'me pa'ikʉ'mʉ. Ũcuaʉji chʉ'ʉna'me ũcuate'ere'ava cʉnare'ava pãpʉ chũ'semʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chʉ'ʉre Dios Raosi'kʉre, Repaʉ chʉ'o aperʉmʉ tocha jo'kasi'e kʉache ũcuarepa cu'ache ti'jñeja'mʉ. Jã'ata'ni chʉ'ʉni vanisõa'jʉ chini jo'kasi'kʉre na'a rʉa cu'ache ti'jñeja'mʉ. Repaʉ aineemaneru na'a re'ora'amʉ repaʉ'te —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chuta'a ãu ãiʉ ñu'ikʉji Jesús pãpʉ mini Dioni, “Re'orepamʉ”, chini repaʉ neenani tʉ'se ĩsikʉ ija'che i'kaasomʉ: —Ipʉ pãpʉ chʉ'ʉ ca'nivʉ'me. Ãijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chini conoro'rova mini Dioni, “Re'orepamʉ”, chini ĩsikʉna koo ũkuasome repana ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ũcuarʉmʉ Jesús repanare jo'e i'kaasomʉ. —Ie ʉche cono chʉ'ʉ chiea'me. Mʉsanʉkona ũcuanʉko ũkujʉ̃'ʉ iro'rova. Pãi ũcuanʉkore cu'ache cho'oche'te jũni ro'ikasa chini chuenisõja'mʉ chʉ'ʉ. Jã'aja'ñe cho'oche chʉ'ʉ chiepi menisõʉna Dios mamare, “Ija'che cho'oñu”, chiisi'ere cho'ojachea'me. Jã'are cuasajʉ chi'i ie ʉche cono ũkujʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jã'ata'ni mʉsanʉkonare ija'che i'kamʉ chʉ'ʉ: Chʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉjatʉ'ka ʉche cono jo'e ũkumaneja'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ũcuarʉmʉ Jesús repaʉ neenana'me Dioni pojojʉ uja pi'ni Olivo aikũtina saniasome. ");
INSERT INTO coe_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Repacheja sani tĩ'a Jesús ija'che i'kaasomʉ repanare: —Iñami mʉsanʉkona ũcuanʉko chʉ'ʉni masi cuasamapʉ chʉ'ʉni cu'ache cho'ojʉna vajʉchʉjʉ jo'ka sanisõjanaa'me. Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Ovejava'na repanare kuirakʉni vanisõrena vajʉchʉjʉ te'enachi'a vʉ'vʉsõjanaa'me, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jã'ata'ni chʉ'ʉ jũni vajʉrani Galilea chejana mʉsanʉkonare charo saija'mʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chikʉna Pedro i'kaasomʉ repaʉ'te. —Chekʉna ũcuanʉko mʉ'ʉre jo'kasõto chʉ'ʉta'ni mʉ'ʉre jmamakarʉjẽ'e jo'kamaneja'mʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Iñami chuta'a kura ka'chañoã chu'ima'tona choteñoã, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiija'mʉ mʉ'ʉ. Ũcuarepaa'me jã'a —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chikʉna Pedro jo'e ija'che rʉa i'kaasomʉ: —Pãipi chʉ'ʉni vanisõñu chiitojẽ'e, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiima'ñe mʉ'ʉna'me chuenisõja'mʉ chʉ'ʉ —chiniasomʉ repaʉ. Chikʉna asa chekʉna Jesús neena ũcuanʉko ũcuaja'che i'kaasome. ");
INSERT INTO coe_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ũcuarʉmʉ Jesús repaʉ neenana'me Getsemaní chiichejana sani tĩ'a ija'che i'kaasomʉ repanare: —Ichejare ñu'ijʉ cha'ajʉ̃'ʉ mʉsanʉkona, chʉ'ʉ sani Ja'kʉre sẽni pi'niñetʉ'ka —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chini repanare jo'ka Pedro'mʉ Juan'mʉ Santiago'mʉ sa, sʉma'ñe cuasa oniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jã'aja'ñe oiʉ repaʉ neenare ija'che i'kaasomʉ repaʉ: —Chura rekocho jũ'iʉache rʉa sʉma'mʉ chʉ'ʉre. Mʉsanʉkona ichejana canʉka kãima'ñe chʉ'ʉna'me pa'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chini te'eʉ jmachenerʉ sani ro're ñu'iʉ meñe sime chejana chia tĩ'iʉ Dioni sẽniasomʉ repaʉ, cu'ache ʉ̃seʉato ʉ̃sekaaʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ija'che Diore sẽniasomʉ repaʉ: —Ja'kʉ, mʉ'ʉ si'ache cho'omasikʉ'mʉ. Mʉ'ʉre ʉ̃seʉato pãi chʉ'ʉre cu'ache cho'opi'rache ʉ̃sekaijʉ̃'ʉ. Jã'ata'ni chʉ'ʉ chiicheta'ni cho'omanejʉ̃'ʉ. Ʉ̃seʉama'to mʉ'ʉre ʉache cho'ojʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jã'aja'ñe i'kacuha vʉni, repaʉ neena pa'ichejana co'i ñato kãni ũhijʉ paniasome repana. Kãnisorena Pedroni i'kaasomʉ repaʉ. —Simón, ¿kãikʉ mʉ'ʉ? ¿Te'ehorajẽ'e kãima'ñe pa'icu'aʉ mʉ'ʉre? ");
INSERT INTO coe_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rekoñoã re'oja'che cho'oñu chiime mʉsanʉkona; jã'ata'ni re'oja'che cho'ovesʉme. Jã'ajekʉna kãima'ñe Dioni sẽejʉ pa'ijʉ̃'ʉ, Ũcuaʉji cho'okaiʉna cu'ache cho'omaneñu chini —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chini Jesús jo'e sani Pʉka'kʉre repaʉ aperʉmʉ i'kasi'ere ũcuate'ere sẽniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sẽnicuha repaʉ neenare jo'e kãni ũhijʉ pa'inani rani ñaasomʉ repaʉ. Repanare ʉokʉacajejani repana ñakocaã ñañejẽ'e cu'ache ta'piasomʉ repanare. Repaʉ vʉo i'kato vajʉchʉjʉ repaʉ'te sãiñe i'kavesʉasome. ");
INSERT INTO coe_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Repanare jo'ka Pʉka'kʉre sẽsa chini saisi'kʉpi jo'e co'i repanare i'kaasomʉ repaʉ. —¿Chuta'a vʉima'ñe kãiñe ina? Re'omʉ. Chʉ'ʉre Dios Raosi'kʉre, pãi chẽa cu'ache cho'onare jo'karʉmʉ tĩ'acuhamʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jʉna, vʉijʉ̃'ʉ; sañu! Chʉ'ʉni cu'ache cho'oa'jʉ chini chekʉnare jo'kajaʉ ranicuhamʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús chuta'a i'katona Judas Jesús neenare docerepanare ja'me pa'ikʉji, pãi jainʉkore pãi vaiva'jñana'me vãsoñoã cãjinani rakʉ charo raniasomʉ. Judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me judío ainapi chʉ̃'ʉrena raniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesure jo'kajaʉ Judas aperʉmʉ repanare pãi ija'che i'kaasomʉ: “Mʉsanʉkonapi Jesuni masia'jʉ chini, repaʉ pa'ichejana sani tĩ'a chũsu pojoja'mʉ chʉ'ʉ repaʉ'te. Chʉ'ʉ jã'aja'ñe cho'okʉni chẽa sajʉ̃'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jã'aja'ñe i'kasi'kʉjekʉ Judas, Jesús pa'ichejana sani tĩ'a, —¿Pa'ikʉ, Masiʉ? —chiniasomʉ. Chini repaʉ'te chũsu pojoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jã'aja'ñe chũsukʉ i'kakʉna chekʉna Jesure chẽaasome. ");
INSERT INTO coe_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jã'aja'ñe cho'ojʉna ña Jesure kueñe nʉkakʉji va'ti ruta phairi aire cho'oche cho'okaikʉ'te cãjoro tẽo vatoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tẽoʉna Jesús i'kaasomʉ. —¿Je'se pa'iʉna mʉsanʉkona chʉ'ʉre ñaaʉ'te cho'ocheja'che va'jñana'me vãsoñoã cãjijʉ chẽañu chini raiche? ");
INSERT INTO coe_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Si'aumucujña Dios vʉ'e mʉa mʉsanʉkonana'me pa'iʉ pãire che'chokʉ pa'isi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni mʉsanʉkona chʉ'ʉre chẽamanesinaa'me. Diopi kʉaʉna pãi chʉ'ʉre mʉsanʉkona chẽajañe aperʉmʉ tocha jo'kaasome. Repana tocha jo'kasi'e kʉache ũcuare cho'ome mʉsanʉkona chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chikʉna repaʉ neena ũcuanʉko vajʉchʉjʉ repaʉ'te te'eʉ'te jo'ka vʉ'vʉsoasome. ");
INSERT INTO coe_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ũcuarʉmʉ Jesuni sajʉna põsʉʉ repana cho'jepi saniasomʉ sábanakãa ca'nesi'kʉ. Ja'me saiʉna Jesure chẽasinapi repaʉ'te põsʉʉ'te ũcuaja'che chẽaasome. ");
INSERT INTO coe_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chẽarena repaʉ ca'nesi'kãare jose ũha, kãa peova'ʉ vʉ'vʉsoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Repana Jesure chẽasina phairi ai pa'ivʉ'ena saasome repaʉ'te, judío phairipãi chʉ̃'ʉnana'me judíopãi ainana'me judíopãi che'chona chi'i pa'ivʉ'ena. ");
INSERT INTO coe_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jã'a cho'oto Pedro so'opi ñakʉ cho'jepi phairi ai vʉ'e sa'navʉ pa'iraripʉjatʉ'ka tuhaasomʉ. Tuha sʉsʉkʉna repavʉ'e pẽ'jena sõtaopãi ñu'ichejana pʉʉ, toare ja'me kũniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Repavʉ'e chi'i pa'ina judío phairipãi chʉ̃'ʉnana'me judío pãi chʉ̃'ʉna ũcuanʉko jorenani ku'e raa'jʉ chini chekʉnani chʉ̃'ʉasome, “Jesús cu'ache cho'osi'kʉa'mʉ”, chiijʉ jorerena repaʉni vanisoche'te chʉ̃'ʉñu chini. Ku'e jñaa rarena jorena jainʉko raisinata'ni Jesure vanisoche chuta'a chʉ̃'ʉcu'aasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pãi jainʉko repaʉ pa'iche'te kʉajʉ joreasome. Jã'ata'ni ũcuate'e kʉamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Reparʉmʉ repana te'ena vʉni Jesús pa'iche'te jorejʉ ija'che kʉaasome: ");
INSERT INTO coe_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ikʉ Jesús ija'che i'kasi'kʉa'mʉ: “Chʉ'ʉpi ivʉ'ere Dios vʉ'e pãi cho'osivʉ'ere ñañosõja'mʉ. Ñañosõ choteumucujña chekʉvʉ'e pãi cho'omavʉ'ere jo'e cho'o pi'nija'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jã'aja'ñe kʉanata'ni ũcuate'e kʉamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jã'aja'ñe kʉarena asa phairi ai vʉni repana pãi chenevʉ'te nʉkakʉ Jesure ija'che sẽniasaasomʉ: —¿Je'se chiikʉ mʉ'ʉ? Ina mʉ'ʉre i'kasi'e, ¿jã'aja'ñe i'kaʉ mʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jã'ata'ni Jesús i'kama'ñe jʉvoasomʉ. I'kamaʉna phairi ai jo'e sẽniasomʉ. —¿Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'ʉ mʉ'ʉ? ¿Dios mai Cuasakʉ Mamakʉ'ʉ mʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Ũcuaʉ'mʉ chʉ'ʉ. Mʉsanʉkona chʉ'ʉre Dios Raosi'kʉre Ja'kʉ peore Cho'omasiʉ ʉjajʉ̃tʉ cakã'kore kueñe ñu'ikʉji cʉnaʉmʉpi pikona'me cajekʉna ñajanaa'me —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jã'aja'ñe i'kaʉna asa pe'rukʉ phairi ai repaʉ ju'ikãña meñe rueni che'rekʉ chekʉnani ija'che i'kaasomʉ: —Ikʉ cu'ache cho'osi'e kʉanare chekʉnare chiima'me mai. ");
INSERT INTO coe_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dios rʉa cuheche'te i'kasi'kʉa'mʉ ikʉ. Mʉsanʉkona ikʉ cu'ache i'kasi'e asasina, ¿je'se cuasache? —chiniasomʉ. Chikʉna repana ũcuanʉko ũcuate'e cuasajʉ, —Cu'ache cho'okʉ'te vanisoche pa'imʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chitena chekʉna repaʉni coore tutuasome. Ũcuachi'a repaʉ ñakocaã kãase'rechoji quẽo ta'pi repaʉ'te vaijʉ i'kaasome repana. —¡Cuasa i'kajʉ̃'ʉ! ¿Neepi mʉ'ʉre vate? —chiniasome. Ũcuachi'a repavʉ'e pẽ'jekaina sõtaopãi repaʉ'te chiana charaasome. ");
INSERT INTO coe_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Jã'a cho'oto Pedro repavʉ'e ve'se cararipʉ'te pa'iʉ toa kũhitona romichĩio judío phairipãi chʉ̃'ʉkʉ'te cho'oche cho'okaiko repaʉ'te ñako i'kaasomo. —Mʉ'ʉ ũcuaja'che Nazaret vʉ'ejoopo cakʉre Jesure ja'me ku'isi'kʉa'mʉ —chiniasomo. ");
INSERT INTO coe_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jã'ata'ni Pedro ija'che i'kakʉ jachaasomʉ: —Jesure ñama'kʉa'mʉ chʉ'ʉ. Mʉ'ʉ i'kache vesʉmʉ chʉ'ʉ —chiniasomʉ. Jã'aja'ñe i'kacuha repavʉ'e kakasa'arojatʉ'ka etaʉna kura chuniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ũcuarʉmʉ romichĩio aperʉmʉ repaʉ'te i'kasi'ko jo'e ña chekʉnare ija'che i'kaasomo: —Jesús neenare ja'me pa'isi'kʉa'mʉ ikʉ —chiniasomo. ");
INSERT INTO coe_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Chikona Pedro jo'e jachaasomʉ. Na'a pa'iʉna ũcuacheja pa'ina Pedro'te jo'e i'kaasome. —Mʉ'ʉ ũcuaja'che Galilea cheja pa'ikʉjekʉ chekʉrʉmʉ Jesús neenare ja'me pa'isi'kʉcosomʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chitena Pedro Dioni roiʉ, —Chʉ'ʉpi chʉ'o ũcuarepare i'kama'to Diopi cu'ache cho'oa'kʉ chʉ'ʉre —chini ija'che i'kaasomʉ:— Mʉsanʉkona i'kakʉ'te Jesure ñama'kʉa'mʉ chʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Repaʉ jã'aja'ñe i'katona kura jo'e chuniasomʉ. Chu'iʉna Pedro, repaʉ'te Jesús i'kasi'ere cuasaasomʉ, “Chuta'a kura ka'chañoã chu'ima'tona choteñoã, ‘Jesure ñama'kʉa'mʉ chʉ'ʉ’, chiija'mʉ mʉ'ʉ”, chiisi'ere. Jã'are cuasa Pedro rʉa oiche oniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ũcuarʉmʉ apeñatato judío phairipãi chʉ̃'ʉnana'me judío aina, pãi chʉ̃'ʉna, judíopãi che'chona, chekʉna pãi chʉ̃'ʉna ũcuanʉko chi'i Jesure cho'ojachere cutuasome. Cutu pi'ni repaʉ'te vẽe pãi chʉ̃'ʉkʉ Pilatoni sa jo'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sa jo'karena Pilato Jesure ija'che sẽniasaasomʉ: —¿Judíopãi ũcuanʉkore chʉ̃'ʉkʉ'ʉ mʉ'ʉ? —chiniasomʉ. Chikʉna, —Jʉ̃jʉ, ũcuaʉ'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Reparʉmʉ judío phairipãi chʉ̃'ʉna, —Rʉa si'ache cu'ache cho'okʉ'mʉ ikʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jã'aja'ñe i'kajʉna asa Pilato jo'e Jesure sẽniasomʉ. —Ina mʉ'ʉre, “Rʉa si'ache cu'ache cho'okʉ'mʉ ikʉ”, chiime. Asakʉta'ni, ¿i'kama'kʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jã'ata'ni Jesús jmamakarʉjẽ'e i'kamaneasomʉ. I'kamaʉna Pilato, “¿Keeja'iʉ'ʉ ikʉ?”, chiiʉ cuasaasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato ʉ̃sʉrʉmʉ pa'iche pascuarʉmʉ tĩ'ato chẽacojñosi'kʉre te'eʉ'te etoasomʉ, pãi etojʉ̃'ʉ chiikʉni. ");
INSERT INTO coe_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ũcuarʉmʉ Barrabás pãi chẽavʉ'ere paniasomʉ, repaʉna'me cu'ache cho'osina ũcuachi'a. Aperʉmʉ repaʉ Barrabás ũcuanana'me repanare chʉ̃'ʉnani cuhejʉ etoñu chini cavajʉ chekʉni vanisoasome. ");
INSERT INTO coe_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ũcuarʉmʉ pãi Pilato vʉ'ena sani repaʉ'te ija'che i'kaasome: —Mʉ'ʉ ʉ̃sʉrʉmʉ pa'iche chẽacojñosi'kʉre etokʉjekʉ te'eʉ'te etojʉ̃'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Chitena Pilato, “Ikʉre Jesure pãipi jovojʉna ña pe'rujʉ judío phairipãi ikʉre chʉ'ʉni ra jo'kacosome”, chiiʉ cuasakʉ repanare pãi ija'che i'kaasomʉ: —¿Jesús judíopãi chʉ̃'ʉkʉ chiicojñokʉni etoja'che chʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chikʉna judío phairipãi chʉ̃'ʉna repanare pãi rʉa i'kaasome, Barrabani etoche'te sẽapʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jã'aja'ñe cho'ojʉna Pilato repanare jo'e ija'che sẽniasaasomʉ: —Judíopãi chʉ̃'ʉkʉ chiikʉ'te, ¿je'se cho'oja'che chʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chikʉna repana pãi rʉa cuijʉ i'kaasome. —¡Kurususẽ'verona jẽ'jo nʉko vẽasõjʉ̃'ʉ jã'ʉre! —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chitena Pilato i'kaasomʉ. —¿Ʉ̃quere repaʉ cu'ache cho'oʉ? —chiniasomʉ. Chiicheta'ni repana jo'e ʉjachʉ'o cuijʉ, —¡Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre! —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jã'aja'ñe i'kajʉna asa Pilato repana chiiche'te cho'ora chini Barrabani etoasomʉ. Jesureta'ni suĩ'sueche'te chʉ̃'ʉasomʉ repaʉ. Suĩ'sue pi'nirena repaʉ neenani sõtaopãire Jesure jo'kaasomʉ, sa kurususẽ'verona jẽ'jo nʉkoa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ũcuarʉmʉ sõtaopãi Jesure Pilato vʉ'e sa'navʉ cararipʉna juha cuaa chekʉnare sõtaopãi soni chi'iasome. ");
INSERT INTO coe_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Repana chi'isirʉmʉ Jesure pãi chʉ̃'ʉna ju'ikãa chimaajakãare sachaasome repana. Ũcuachi'a repaʉ sĩjopʉ miu tuhivʉ cho'o tʉoasome. ");
INSERT INTO coe_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tʉo pãisojʉ cuijʉ ija'che i'kaasome repana: —¡Ikʉpi judíopãire si'arʉmʉ chʉ̃'ʉkʉ paaʉ! —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chini vãsochoji repaʉ sĩjopʉna vaijʉ ũcuaʉni coo tutujʉ pãisojʉ pãi chʉ̃'ʉnare pojojʉ cho'ocheja'che repaʉni ti'jñeñe ro're pʉʉ ñuniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jã'aja'ñe cho'ojʉ repaʉ'te pãiso pi'ni, repana sachasikãa tĩto repaʉ ju'isikãare jo'e sachaasome repana. Sacha pi'ni repaʉ'te kurususẽ'verona jẽ'jo nʉkoñu chini saasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Repana sõtaopãi Jesure satona Simón Cirene cheja cakʉ Alejandrona'me Rufo pʉka'kʉ po'o raikʉji caraiʉna chẽa, Jesure jẽ'jojasẽ'vero'te kuãikaaʉ chini chʉ̃'ʉasome. ");
INSERT INTO coe_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Simonpi kuãiʉ saiʉna Jesure Gólgota aikũtina sa tĩ'aasome repana. (“Gólgota” chini “Pãi sĩjopʉjakũti” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Repacheja tĩ'asirʉmʉ Jesure ʉche cono rʉara'ka ja'mesi'ere ũkuañu chiijʉna ũkucuheasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ũcuarʉmʉ repaʉ'te kurususẽ'verona jẽ'jo nʉkoasome repana. Jẽ'jo nʉko pi'ni sõtaopãi repaʉ ju'isikãñare paañu chini catara'karʉã mami tochasira'karʉãpi chejana su'aasome, Jesús ju'isikãña paajanani jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Apeñatato nueve pa'itona Jesure kurususẽ'verona jẽ'jo nʉkoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ũcuachi'a repaʉ cu'ache cho'osi'ere kʉajʉ, Judiopãi Chʉ̃'ʉkʉ'mʉ Ikʉ, chiiche chooko'ana tocha kurususẽ'vero chã'tirona jẽ'jo sʉoasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ũcuarʉmʉ ñaanare ũcuachi'a ka'chanare kurususẽ'veroãna jẽ'jo Jesús ʉjajʉ̃tʉ cakã'kona te'eʉ'te nʉkoasome repana. Chekʉni kã'kojʉ̃tʉ cakã'kona nʉkoasome. ");
INSERT INTO coe_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jã'aja'ñe cho'orena Dios chʉ'o aperʉmʉ tocha jo'kasi'epi ũcuarepa ti'jñesi'kʉa'mʉ: Chekʉnare cu'ache cho'osinare cho'ocheja'che repaʉ'te cho'ome pãi, chiicheji. ");
INSERT INTO coe_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Repanare nʉkosirʉmʉ repacheja caraina pãi Jesure cuhena repana sĩjo sʉ̃'cuijʉ ija'che cu'ache i'kajʉ caraniasome: —“Dios vʉ'e ñañosõ choteumucujña jo'e cho'o pi'nija'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jã'aja'ñe i'kasi'kʉ chura mʉ'ʉpi meñe jũ'iñe ʉ̃sekʉ cajejʉ̃'ʉ jã'acheja kurususẽ'vero —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ũcuarʉmʉ judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona ũcuaja'che pãisojʉ sãiñechi'a ija'che cutuasome: —Chekʉnare jũ'iñe ʉ̃sesi'kʉasomʉ jã'ʉ. Jã'ata'ni chura ũcuaʉji meñe jũ'iñe ʉ̃secu'amʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jã'ʉ, “Dios Raosi'kʉa'mʉ jã'ʉ. Ũcuachi'a judíopãi chʉ̃'ʉkʉ'mʉ”, chiicojñosi'kʉa'mʉ. Jã'ajekʉna ũcuachejapi cajea'kʉ. Repaʉji cajeʉna ñani, “Dios Mamakʉ'mʉ jã'ʉ”, chiijʉ cuasajanaa'me mai —chiijʉ pãisoasome repana. Repaʉna'me kurususẽ'veroã jẽ'jo nʉkocojñosina ũcuachi'a cu'ache i'kaasome Jesure. ");
INSERT INTO coe_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Reparʉmʉ nʉkarepaʉ sʉ'itona ʉ̃sʉʉ miañe ta'pisoʉna cheja si'acheja trejatʉ'ka chijaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tres pa'itona Jesús ʉjachʉ'o ija'che i'kakʉ cuiasomʉ: “Eloi, Eloi, ¿lama sabactani?”, chiniasomʉ. (Ija'che chiimʉ jã'a: “Dios, chʉ'ʉre Paakʉ, Dios chʉ'ʉre Paakʉ, ¿je'se pa'iʉna mʉ'ʉ chʉ'ʉre jo'kasõkʉ?” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jã'aja'ñe i'kaʉna asa repacheja pa'ina chekʉna ija'che i'kaasome: —Asajʉ̃'ʉ. Aperʉmʉ pa'isi'kʉni Elíani soicosomʉ jã'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ũcuarʉmʉ repanare ja'me pa'ikʉ vʉ'vʉ sani chʉisʉovʉji rʉara'kana chʉ̃ʉ vãsochona quẽo sʉo Jesupi ũkua'kʉ chini mʉo ija'che i'kaasomʉ: —Cha'a ñañu. Elíapi rani repaʉ'te casoche'te ñañu. Raimanejacosomʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jã'aja'ñe i'katona Jesús jo'e rʉa cuicuha jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Repaʉ Jesús jũ'itona Dios vʉ'e sa'navʉ caruupʉ kakasa'aro rueekãa ũcuate'ekãa joorepapoji ʉmʉpi vʉ'evʉna che're cajeasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesupi jũnisoʉna sõtaopãi chʉ̃'ʉkʉ Jesure ti'jñeñe nʉkakʉ ñakʉ i'kaasomʉ. —Dios Mamarepakʉ pa'icosomʉ jã'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jã'a cho'oto romiva'na so'opi nʉkajʉ ñajʉ paniasome repaʉ'te cho'oche. María Magdalenaa'mo, Santiago jmava'ʉna'me José pʉka'ko Maríaa'mo, Salomea'mo paniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aperʉmʉ repana romi Jesús Galilea cheja pa'irʉmʉ repaʉ'te ja'me ku'ijʉ kuirajʉ paniasome. Ũcuachi'a chekʉna romi repaʉna'me Jerusalén maisina ñajʉ nʉkajʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Pʉaumucuse ãijañe care'vaumucuse na'icuhakʉna José Arimatea vʉ'ejoopo cakʉ judíopãi chʉ̃'ʉnare ja'me chʉ̃'ʉkʉji Dios Raosi'kʉ chʉ̃'ʉrʉmʉ cha'akʉji Jesure jũ'isi'kʉni sa tãra chini vajʉchʉma'ñe sani Pilatoni sẽniasomʉ, ĩsia'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sẽeʉna Pilato asa kʉkʉ, “¿Jũnisocuhaʉ repaʉ Jesús?”, chiiʉ cuasaasomʉ. Jã'aja'ñe cuasakʉ sõtaopãi chʉ̃'ʉkʉ'te soni rao, “¿Jesús jũnisocuhaʉ?”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sẽniasa kʉaʉna Pilato chʉ̃'ʉasomʉ, repaʉ'te Joseni ĩsia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ĩsirena José sábanakãare koo Jesure caso ũcuakãapi repava'ʉre reaasomʉ. Rea pi'ni sa aikũti caripana tẽtoche ũhisicojena cuaa ũha eta, repacoje kakasa'aro catapʉ rʉa ʉjapʉji ũha ta'pisoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jã'aja'ñe cho'okʉna María Magdalenana'me María José pʉka'ko Jesure ũhasicheja ñaasome. ");
INSERT INTO coe_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ũcuarʉmʉ judíopãi pʉaumucuse carakʉna María Magdalenana'me cheko María Santiago pʉka'kona'me Salomé Jesure jũnisosi'kʉni sa ro'veñu chini okoma'ñare kooasome. ");
INSERT INTO coe_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ũcuarʉmʉ repana romicorʉmʉ aperepañatato Jesure tãsicojena saniasome repana. ");
INSERT INTO coe_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Saijʉ sãiñechi'a cutujʉ saniasome repana. —¿Neepi maiva'nare catapʉ repacoje ta'pisi'pʉ kʉñokaijanaa'ñe? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jã'aja'ñe i'kajʉ sani ñato repapʉ catapʉ rʉa ʉjapʉ repacoje ta'pisi'pʉ kʉñososi'pʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kʉñosi'pʉjekʉna repacoje kaka ñato põsʉʉ pojakãa ʉjacuecho ju'ikʉji ʉjajʉ̃tʉ cakã'kore ñuniasomʉ. Ñu'iʉna ña repana romi rʉa kʉkʉasome. ");
INSERT INTO coe_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kʉkʉrena repanare i'kaasomʉ repaʉ. —Vajʉchʉmanejʉ̃'ʉ. Mʉsanʉkona Jesure Nazaret vʉ'ejoopo raisi'kʉre ku'eche masimʉ chʉ'ʉ. Kurususẽ'verona jẽ'jo nʉko vẽasocojñosi'kʉni ku'eme mʉsanʉkona. Icheja peomʉ repaʉ; vajʉranicuhasi'kʉa'mʉ. Ñajʉ̃'ʉ repaʉ'te ũhasicheja. ");
INSERT INTO coe_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ña pi'ni sani repaʉ neenana'me Pedro'te ija'che sa kʉajʉ̃'ʉ: “Jesús vajʉranicuhasi'kʉa'mʉ. Mʉsanʉkonare na'a charo Galilea chejana saija'mʉ repaʉ. Ũcuachejana sani repaʉ'te ñajanaa'me mʉsanʉkona, repaʉ chuta'a jũ'imarʉmʉ i'kasi'e”, chiijʉ̃'ʉ repanare —chiniasomʉ repaʉ põsʉʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jã'aja'ñe i'kaʉna asa kʉkʉ kurukurujʉ repana romi ũcuacojepi eta vʉ'vʉsoasome. Kʉkʉcajejani chekʉnare kʉamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ũcuarʉmʉ Jesús romicorʉmʉ ñami mama vajʉraisi'kʉpi María Magdalena'te aperʉmʉ sieterepanare vati etocojñosi'koni charo peosichejapi ñoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ñoʉna ña sani repaʉ'te ja'me ku'isinare sʉma'ñe pa'ijʉ ota oinani kʉaasomo repao. ");
INSERT INTO coe_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Repao Jesure ñasi'ere kʉakona asa jachaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jã'a cho'ocuhasirʉmʉ repaʉ neena te'eka'chapanachi'a po'o sainani Jesús tĩiʉja'iʉ peosichejapi ñoasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ñoʉna ña repana sani repaʉ neenare chekʉnani kʉaasome. Ũcuaja'che kʉajʉna asa jachaasome repana. ");
INSERT INTO coe_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jã'a cho'ocuhasirʉmʉ repaʉ neena oncerepana ãu ãitona Jesús peosichejapi rani ñoasomʉ repanare. Repaʉ chekʉnare vajʉrani ñosi'ere ũcuanapi kʉajʉna asa jachasinajejʉna repanare rʉa i'kaasomʉ repaʉ. —¿Je'se pa'iʉna repana kʉasi'e cuasamanere mʉsanʉkona? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ũcuarʉmʉ Jesús repanare ija'che chʉ̃'ʉ jo'kaasomʉ:— Mʉsanʉkona cheja si'achejñarʉã sani pãi ũcuanʉkore Dios Repaʉ neenare vati toa sani uuche ʉ̃seche'te ku'ijʉ chʉ'vajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mʉsanʉkonapi chʉ'vajʉna pãi asa chẽa okoro'vecojñosinare Dios chẽa paaja'mʉ. Chẽa paakʉna jũnisõsirʉmʉ vati toa saima'ñe Repaʉ pa'ichejana saijanaa'me repana. Jã'ata'ni asa jachajʉ cuasamanesina repana cuasamanesi'e ro'i ro'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mʉsanʉkona chʉ'vasi'e asa chẽa cuasasinapi Diochi'a cho'omasiche ija'che cho'ojanaa'me: Chʉ'ʉ neenajejʉ chʉ'ʉpi cho'okaiʉna pãi sa'navʉã pa'inare vati eto saojanaa'me. Ũcuachi'a chʉ'ʉ neenajejʉ chʉ'ʉpi cho'okaiʉna repanajẽ'e che'chemanesi'ere tĩipãi chʉ'o i'kajanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ũcuachi'a repanapi añani chẽato asi kũ'imanejanaa'me. Eo ũkuni jũnisõmanejanaa'me repana. Ũcuachi'a repanapi chekʉnare jũ'inare jʉ̃jñapi jajʉ Dioni sẽeto vajʉjanaa'me repana jũ'iva'na. Jã'aja'ñe cho'oa'jʉ chini chʉ̃'ʉ jo'kamʉ chʉ'ʉ mʉsanʉkonare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jã'aja'ñe i'kacuha Jesús Diopi mʉakʉna cʉnaʉmʉna mʉni Dios ʉjajʉ̃tʉ cakã'kona kueñe pʉʉ ñu'iʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Repaʉ cʉnaʉmʉ mʉisirʉmʉ repaʉ neena sani Dios chʉ'o si'achejñarʉã ku'ijʉ chʉ'vajʉ paniasome. Jã'aja'ñe chʉ'vajʉna Jesucristo Maire Paakʉji repanare cho'okaniasomʉ, Diochi'a cho'omasiche'te cho'ojʉna pãipi ña, “Ina Dios chʉ'o ũcuarepare chʉ'vame”, chiijʉ cuasaa'jʉ chini.");
INSERT INTO coe_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Chʉ'ʉ Lucapi mʉ'ʉre Teófiloni rʉa masikʉni Jesucristo cheja pa'irʉmʉ cho'osi'ere kʉara chini ie chʉ'o tocha saomʉ chʉ'ʉ mʉ'ʉre: Aperʉmʉ pãi Jesucristo cho'oche ñaasome. Repaʉ apeche'chorʉmʉpi vʉa si'arʉmʉ ñajʉ paniasome repana repaʉ cho'oche peore. Ñasinajejʉ chʉkʉna'te kʉasinaa'me repana. Ũcuaja'che Dios chʉ'o chʉ'vasinaa'me repana. Ñasina kʉasi'ere asa jainʉko pãi cuasajʉ tocha jo'kaasome, maipi ñaa'jʉ chini. Tocha jo'karena ũcuare ñakʉ masi che'chekʉ pa'ikʉ'mʉ chʉ'ʉ. Jesucristo cho'osi'e pãipi kʉajʉna peore asakʉ pa'ikʉ'mʉ chʉ'ʉ. Jã'ajekʉna mʉ'ʉpi masia'kʉ chini ũcuare tocha saomʉ chʉ'ʉ mʉ'ʉre, “Jã'aja'ñe cho'oto re'ocosomʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Chʉ'ʉpi tocha saoʉna ña, “Ãja, jã'aja'ñe Jesucristo cho'oasomʉ”, chini, “Chekʉna kʉasi'e, ¿ũcuarepaa'che jã'a, jã'a pa'ito?”, chiija'mʉ mʉ'ʉ. Mʉ'ʉpi peore masia'kʉ chini ie chʉ'o tocha saomʉ chʉ'ʉ mʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea cheja canare Herodes chʉ̃'ʉrʉmʉ Zacarías judío phairipãiʉ paniasomʉ reparʉmʉ. Dios vʉ'e cho'oche cho'orʉmʉ tĩ'ato Abías paasinana'me si'arʉmʉ cho'okʉ paniasomʉ repaʉ Zacarías ũcuate'epãiʉjekʉ. Zacarías rʉ̃jo Elisabet ve'easomo. Ũcuaja'che aipãiʉ Aarón, judío phairi pa'isi'kʉ jojosi'koasomo Elisabet. ");
INSERT INTO coe_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Diopi ñato rʉa re'opãi paniasome repana Zacaríana'me Elisabet. Dios chʉ̃'ʉ jo'kasi'e jachama'ñe cho'ojʉ paniasome repana. Chekʉna pãi ñajʉ i'kacu'aasomʉ repanare, ũcuare re'oja'che pa'ijʉna. ");
INSERT INTO coe_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabeni chĩi paacu'akʉna chĩi peova'na paniasome repana. Ũcua chĩi peova'na pa'ijʉ airekosoasome repava'na. ");
INSERT INTO coe_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Reparʉmʉ Abíapãi cho'oche cho'orʉmʉ tĩ'aasomʉ. Tĩ'aʉna Zacarías Dios vʉ'e kaka ja'me paniasomʉ. Kaka pa'iʉ phairipãi cho'oche ja'me cho'okʉ paniasomʉ repaʉ ũcuaja'che phairijekʉ. Dios chʉ̃'ʉ jo'kasi'e cho'okʉ paniasomʉ repaʉ, Diopi pojoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Abíapãi Dios vʉ'ere chi'i pa'ijʉ Zacaríani chẽaasome ma'ñasʉche ʉojaʉre. Si'arʉmʉ jã'aja'ñe cho'ojʉ paniasome repana. Chẽarena ruupʉna kakaasomʉ repaʉ ma'ñasʉche'te ʉora chini. ");
INSERT INTO coe_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kaka ma'ñasʉche ʉokʉna rʉa jainʉko pãi ve'sere pa'ijʉ Dioni sẽejʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacaríaji ma'ñasʉche'te ʉokʉna Diore ja'me pa'ikʉ, ángel peosichejapi rani ma'ñasʉche ʉoko'a rʉ̃'ʉñe nʉkaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angelpi rani nʉkakʉna ña rʉa kʉkʉsoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kʉkʉsokʉna ángel i'kaasomʉ repaʉ'te. —Zacarías, vajʉchʉmanejʉ̃'ʉ. Mʉ'ʉ sẽeñe Dios cho'okaija'mʉ mʉ'ʉre. Jã'ajekʉna mʉrʉ̃jo mʉ'ʉ chĩini jñaaja'mo. Repaʉ'te chĩiva'ʉre cajaona Juanre ve'ojʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mʉrʉ̃jo chĩiva'ʉre jñaasirʉmʉ rʉa pojoja'mʉ mʉ'ʉ. Chekʉna pãi ũcuaja'che jainʉko asa pojojanaa'me repava'ʉre jñaasi'e. ");
INSERT INTO coe_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mʉ'ʉ chĩire, “Rʉa masimʉ ikʉ”, chiija'mʉ Dios. Cono vẽañejẽ'e ũkuma'kʉ pa'ija'mʉ repaʉ. Repaʉ'te chuta'a jñaamarʉmʉpi Dios Rekocho ja'me pa'ija'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ũcuachi'a ainee pa'iʉ Dios chʉ'o rʉa chʉ'vaja'mʉ repaʉ. Repaʉji chʉ'vakʉna asa Israelpãi jainʉko Dios chʉ̃'ʉñe aperʉmʉ cho'ojʉ ũhasosina jo'e cho'ojʉ re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na'a pa'isirʉmʉ Dios Repaʉ Mamakʉni chejana casoja'mʉ. Jã'ata'ni mʉ'ʉ chĩipi cheja charo pa'ija'mʉ. Pa'iʉ aperʉmʉ pa'isi'kʉ Elías Dios chʉ'o rʉa masi chʉ'vacheja'che mʉ'ʉ chĩi masi chʉ'vaja'mʉ. Pãi repana chĩiva'nare cuasache jo'kasosina mʉ'ʉ chĩipi Dios chʉ'ore chʉ'vakʉna asa repana chĩiva'nare jo'e cuasajanaa'me. Chekʉna pãi, Dios chʉ̃'ʉñe jachana mʉ'ʉ chĩipi Dios chʉ'ore chʉ'vakʉna asa jachama'ñe cuasajʉ re'oja'che pa'ijanaa'me. Mʉ'ʉ chĩi pãipi asa chẽa cu'ache cho'oche'te ũhasoa'jʉ chini Dios chʉ'o chʉ'vaja'mʉ. Chʉ'vakʉna asa chẽa cu'ache cho'oche ũhasosinajejʉ Dios Mamakʉ'te rakʉna cuasajanaa'me pãi, —chiniasomʉ ángel Zacaría'te. ");
INSERT INTO coe_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chikʉna, —Mʉ'ʉpi chʉ'o ũcuarepare i'kani, ¿ʉ̃quere mʉ'ʉ chʉ'ʉre cho'o ñoja'ʉ, chʉ'ʉpi mʉ'ʉ i'kache'te cuasaa'kʉ chini? Aiva'ʉa'mʉ chʉ'ʉ. Chʉ'ʉ romiojẽ'e ũcuachi'a aiva'oa'mo —chiniasomʉ Zacarías repaʉ'te ángel'te. ");
INSERT INTO coe_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chikʉna ángel ija'che i'kaasomʉ: —Gabriela'mʉ chʉ'ʉ. Dios chʉ̃'ʉñe cho'okaikʉ'mʉ chʉ'ʉ. Diopi casosi'kʉa'mʉ chʉ'ʉre, mʉ'ʉni chʉ'ore re'oja'chere kʉaa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chʉ'ʉ kʉasi'e na'a pa'isirʉmʉ ti'jñeja'mʉ mʉ'ʉre. Jã'ata'ni mʉ'ʉ chʉ'ʉ kʉache jachasi'kʉjekʉ mʉrʉ̃jo mʉ'ʉ chĩire jñaasirʉmʉjatʉ'ka chʉ'o i'kama'kʉ pa'ija'mʉ, jachasi'e ro'i —chiniasomʉ ángel repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jã'a cho'oto pãi chuta'a ve'sere pa'ijʉ Zacaríani cha'ajʉ paniasome. Cha'ajʉ, “¿Je'se pa'iʉna jã'arepa jeerʉmʉ etama'ñe pa'ikʉ jã'ʉ?”, chiijʉ cuasaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cha'atona etaasomʉ repaʉ. Etasirʉmʉ chekʉnare chʉ'o cutucu'aasomʉ repaʉ'te. Cutumaʉna, “¡Dios ñosi'ere ña jñanoso chʉ'o cutuma'kʉ jã'ʉ!”, chini cuasaasome repana. Cutucu'akʉna repanare rupʉ jʉ̃jñapi vevoasomʉ repaʉ. Ũcua chʉ'o cutucu'aasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Repaʉ cho'oche cho'o si'asirʉmʉ vʉ'ena co'iasomʉ repaʉ Zacarías. ");
INSERT INTO coe_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Co'i pa'iʉna repaʉ rʉ̃jo chĩi sʉniasomo. Sʉni cincorepapãimia vʉ'ere pa'io paniasomo repao. Vʉ'ere pa'io ija'che cuasako paniasomo repao: “Chura chʉ'ʉre Dios rʉa oiʉ re'oja'che cho'okaimʉ. Chĩi peova'ojekona rʉa vajʉchʉasi'kʉa'mʉ chʉ'ʉre aperʉmʉ. Jã'ata'ni Diopi cho'okaiʉna chĩi sʉ'iona vajʉchʉama'mʉ chʉ'ʉre chura”, chini cuasako pojoasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Repao Elisabet seirepapãimia chĩipʉ sʉ'irʉmʉna Dios ángel Gabrielre jo'e casoasomʉ, Galilea cheja cajoopo, Nazaret vʉ'ejoopona. ");
INSERT INTO coe_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Repajoopo cako romichĩio ʉmʉ peoko paniasomo. Repao mamia'me María. José vejao paniasomo repao. Aperʉmʉ pãi jainʉkore chʉ̃'ʉsi'kʉ David jojosina mamakʉasomʉ José. ");
INSERT INTO coe_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Diopi casoʉna ángel María'te repao pa'ichejana kaka i'kaasomʉ. —Dios oicojñoko'mo mʉ'ʉ. Dios mʉ'ʉre ja'me pa'ikʉ'mʉ. Chekʉnare romi na'a cajejaiche re'oja'che cho'okaija'mʉ Dios mʉ'ʉre —chiniasomʉ ángel repao'te. ");
INSERT INTO coe_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Angelpi jã'aja'ñe i'kaʉna asa jñano, “¿Je'se pa'iʉna ikʉ chʉ'ʉre jã'aja'ñe i'kakʉ?”, chini cuasaasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rʉa kʉkʉsi'kore jo'e i'kaasomʉ repaʉ. —María, vajʉchʉmanejʉ̃'ʉ. Dios mʉ'ʉre oikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Asarepajʉ̃'ʉ chʉ'ʉ i'kache. Chĩi sʉ'ija'mo mʉ'ʉ. Sʉni chĩiva'ʉre ʉmʉva'ʉni jñaaja'mo mʉ'ʉ. Jñaa repava'ʉre, mʉ'ʉ chĩiva'ʉre Jesure ve'ojʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rʉa masiʉ aineeja'mʉ mʉ'ʉ chĩi. Dios Cʉnaʉmʉ Pa'ikʉ repaʉ'te, “Ikʉ chʉ'ʉ chĩia'mʉ”, chiija'mʉ. Aipãiʉ'te Davire judíopãire chʉ̃'ʉa'kʉ chini jo'kasi'eja'che jo'e Jesuni judíopãi chʉ̃'ʉkʉ'te jo'kaja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mʉ'ʉ chĩipi Israelpãi si'arʉmʉ chʉ̃'ʉkʉ pa'ija'mʉ. Jmamakarʉjẽ'e cuhama'ñe chʉ̃'ʉkʉ pa'ija'mʉ repaʉ, —chiniasomʉ ángel repao'te María'te. ");
INSERT INTO coe_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jã'aja'ñe kʉaʉna asa, —¿Je'se chʉ'ʉ ʉmʉ peoko chĩire paaja'che? —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chikona ángel jo'e i'kaasomʉ repao'te. —Dios Rekocho mʉ'ʉni cajeja'mʉ. Dios peore Masikʉjekʉ chĩire jo'kaja'mʉ mʉ'ʉre. “Chʉ'ʉ chĩi cu'achejẽ'e peokʉ'mʉ ikʉ”, chiija'mʉ Dios repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","’Mʉ'ʉ majapãio Elisabet aiva'ota'ni chĩipʉ sʉ'imo. Ʉmʉva'ʉni chĩire sʉ'imo repao. “Chĩi paacu'amʉ jã'ore”, chiicojñosiva'ota'ni chĩi sʉ'imo repao. Seirepapãimia sʉ'imo repao chura. ");
INSERT INTO coe_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diore cho'ovesachejẽ'e peokʉ'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chikʉna, —Dios chẽa paacojñokojeko Repaʉ chʉ̃'ʉñe cho'okaiko'mo chʉ'ʉ. Mʉ'ʉ chʉ'ʉre kʉache Diopi chʉ'ʉre cho'okaito re'omʉ —chiniasomo repao. Chikona ángel jo'ka sanisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angel sanisosirʉmʉ repao María Judea cheja aikũti pa'ijoopona cu'arepa maniasomo. ");
INSERT INTO coe_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mani Zacarías vʉ'ena kaka, “¿Pa'iko?”, chiniasomo repao Elisabere. ");
INSERT INTO coe_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María i'kache'te asakona Elisabere repao sʉ'iva'ʉ chĩiva'ʉ cho'oasomʉ. Ũcuarʉmʉ Elisabere Dios Rekochoji rani chʉ'o i'kache chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chʉ̃'ʉkʉna María'te ʉjachʉ'opi ija'che i'kaasomo repao Elisabet: —Chekʉnare romi na'a cajejaiche re'oja'che cho'okaikʉ'mʉ Dios mʉ'ʉre. Ũcuaja'che mʉ'ʉ chĩiva'ʉre, chura sʉ'iva'ʉre re'oja'che cho'okaija'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chʉ'ʉre chʉova'o pa'iva'oni mʉ'ʉpi Maire Paakʉ pʉka'kopi rakona vajʉchʉkota'ni pojosomo chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mʉ'ʉ i'kache'te asakona chʉ'ʉ chĩi, chura sʉ'iva'ʉ pojokʉ cho'osi'kʉa'mʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios mʉ'ʉre aperʉmʉ kʉasi'ere asa, “Ũcuarepa ti'jñeja'mʉ chʉ'ʉre”, chini cuasako rʉa pojomo mʉ'ʉ —chiniasomo María'te. ");
INSERT INTO coe_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chikona María asa i'kaasomo. “Dios peore masikʉ'mʉ”, chini cuasako'mo chʉ'ʉ, chʉ'ʉ rekocho. ");
INSERT INTO coe_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","“Dios chʉ'ʉ rekocho vati toa saiche ʉ̃seja'mʉ”, chini repaʉni cuasako pojoko'mo chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Dios rʉa re'okʉ'mʉ. Chʉ'ʉre Repaʉ chẽa paacojñoko'te chʉova'o pa'iva'oreta'ni cuasakʉ re'oja'che cho'okaimʉ Dios. Peore Masikʉjekʉ chʉ'ʉva'ore rʉa re'oja'che cho'okaimʉ Repaʉ. Jã'ajekʉna irʉmʉ pa'inana'me cho'je pa'ijana ũcuanʉko chʉ'ʉ pa'iche'te cuasani, “Maríani re'orepaja'che cho'okaniasomʉ Dios”, chiijanaa'me pãi ũcuanʉko chʉ'ʉre cuasani. ");
INSERT INTO coe_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios Repaʉ'te vajʉchʉnare rʉa oikʉ'mʉ. Irʉmʉ pa'inarechi'a oima'mʉ repaʉ. Charo pa'inarejẽ'e oiʉ cho'je raijanare peore rʉa oikʉ'mʉ Dios, Repaʉ'te vajʉchʉnare. ");
INSERT INTO coe_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pãi, “Peore masinaa'me chʉkʉna”, chini cuasanare cuheasomʉ Dios. Dios peore Masikʉjekʉ repana cho'oñu chiisi'e ʉ̃seasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ʉ̃sekʉ chekʉnare, masijʉ pãi chʉ̃'ʉnare cuhekʉ chʉova'na pa'iva'nani saño pãi chʉ̃'ʉñe jo'kaasomʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chʉova'na pa'iva'nare karama'ñe paapʉ chini rʉa re'oja'chere ĩsiasomʉ Dios. Kuri paanare tʉasõasomʉ Dios. Tʉasõʉna kuri peova'na paniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mai aipãire oiʉ ija'che i'kaasomʉ Dios: “Mʉsanʉkonare Israelpãi re'oja'che cho'okaija'mʉ chʉ'ʉ”, chiisi'e cavesʉma'ñe cho'okaniasomʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abrahamre, mai aipãiʉ pa'isi'kʉre, “Re'oja'che cho'okaija'mʉ chʉ'ʉ mʉ'ʉre”, chiisi'e cavesʉma'ñe cho'okaniasomʉ Dios. Ũcuaja'che repaʉ Abraham jojosinare ũcuare Repaʉ i'kasi'ere re'oja'che cho'okaniasomʉ Repaʉ Dios, chiniasomo María. ");
INSERT INTO coe_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","I'ka pi'ni Elisabet vʉ'ena canʉka ũcuaona'me paniasomo repao. Chotepãimia pa'icosomo repao repacheja. Jã'api repao vʉ'ena co'iasomo repao María. ");
INSERT INTO coe_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na'a pa'isirʉmʉna repao Elisabet chĩire jñaaumucuse tĩ'aʉna chĩiva'ʉre jñaaasomo. ");
INSERT INTO coe_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jñaa pa'iona pãi repao'te kueñe pa'inana'me repao majapãi asaasome repao chĩire jñaasi'e. Diopi repaoni oiʉ re'oja'che cho'okakʉna asa saniasome repana repaoni ja'me pojokañu chini. ");
INSERT INTO coe_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chĩiva'ʉ ochorepaumucujña jñaasi'e pa'itona jo'e saniasome repana repavʉ'e. Pʉka'kʉpãipi chĩiva'ʉ jĩkora'murʉ chã'tirʉ pa'ica'nirʉ chʉto tʉache'te chʉ̃'ʉrena ñañu chini saniasome repana, judíopãi cho'oche. Ũcuachi'a reparʉmʉna chĩiva'ʉre mami ve'oñu chiniasome repana. Pʉka'kʉ mamire Zacaría'te ve'oñu chiniasome repana repava'ʉre. Jã'ata'ni pʉka'ko, ");
INSERT INTO coe_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","—Pãame. Jã'aja'ñe ve'omanejanaa'me chʉkʉna. Juanre ve'ojanaa'me chʉkʉna ikʉre —chiniasomo repanare. ");
INSERT INTO coe_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chikona, —Mʉ'ʉ majapãi Juan ve'enajẽ'e peome —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chini chĩiva'ʉ pʉka'kʉre cãjo asama'kʉjekʉna rupʉ vevoasome repana, repaʉ chĩiva'ʉre ve'ojachere mamire masiñu chini. ");
INSERT INTO coe_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Vevojʉna sãiñe vevoasomʉ repaʉ tochajako'arʉ'te rakatena tocha kʉara chini. Rarena, “Chʉ'ʉ chĩi mamia'me ie Juan”, chiiche tocha ñoasomʉ repaʉ. Tocha ñoʉna ña jñanoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tocha ñoʉna teana i'kare'oche care'osoasomʉ repaʉ chemeño. Chʉ'o cutumanesi'kʉ churata'ni jo'e chʉ'o cutuasomʉ repaʉ. —Dios rʉa re'okʉ'mʉ —chiniasomʉ repaʉ Zacarías. ");
INSERT INTO coe_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zacaríaji jã'aja'ñe cho'oʉna pãi chekʉna kueñe pa'ina asa jñanoasome ũcuanʉko. Ũcuachi'a Judea cheja aikũjña pa'ina ũcuare asa cutujʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Repana asasi'ere cuasajʉ, —¿Je'se jã'ava'ʉ chĩiva'ʉ pa'ija'ʉ? —chini cuasajʉ sãiñechi'a ũcuanʉko sẽniasajʉ paniasome repana. Diopi chĩiva'ʉni rʉa re'oja'che cho'okakʉna asa rʉa cuasajʉ paniasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ũcuarʉmʉ repaʉ Zacarías, chĩiva'ʉ pʉka'kʉ, Dios Rekochoji repaʉni chʉ̃'ʉʉna ija'che kʉaasomʉ Dios chʉ'o: ");
INSERT INTO coe_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Pãi chekʉnapi maini Israelpãire chẽa paajʉna tʉakaniasomʉ Dios. Jã'ajekʉna Maire Paakʉ'te, “Rʉa re'okʉ'mʉ mʉ'ʉ”, chini cuasajʉ pañu mai. ");
INSERT INTO coe_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ũcuachi'a maini oiʉ mai jũnisosirʉmʉ vati toa sani uuche Ʉ̃sejaʉni rʉa Masikʉni raoja'mʉ Dios maire. Aipãiʉ David Dios chʉ̃'ʉñe cho'okaniasomʉ aperʉmʉ. Ũcuaʉ David jojosinani te'eʉ'te chẽa raoja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aperʉmʉ Diopi kʉakʉna Repaʉ chʉ'o kʉana ija'che kʉaasome chekʉnare: ");
INSERT INTO coe_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Chekʉnapi maini Israelpãire cuhejʉ cu'ache cho'oñu chiito Diopi ʉ̃sekaija'mʉ.” Jã'aja'ñe cho'okasa chiniasomʉ Dios maire Israelpãi. ");
INSERT INTO coe_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Repaʉ Dios mai aipãire ija'che i'kaasomʉ: “Mʉsanʉkonani oiʉ re'oja'che cho'okaija'mʉ chʉ'ʉ”, chiisi'e cavesʉma'ñe cho'okaija'mʉ Repaʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ũcuachi'a Abrahamre mai aipãiʉ pa'isi'kʉre, “Ija'che cho'okasa chʉ'ʉ mʉsanʉkonare Israelpãi”, chiniasomʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","“Mʉsanʉkonare cuhenapi chẽa paajʉ cu'ache cho'ocojñonare chʉ'ʉpi tʉa paaja'mʉ mʉsanʉkonare. Tʉa paakʉna chʉ'ʉ neenajejʉ mʉsanʉkonare cuhenare vajʉchʉma'ñe chʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ re'oja'che pa'ijanaa'me mʉsanʉkona jũnisõñejatʉ'ka”, chiniasomʉ Dios Abrahamre. Jã'aja'ñe kʉaasomʉ Zacarías Dios chʉ'o. ");
INSERT INTO coe_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chini mamakʉ'te i'kaasomʉ repaʉ Zacarías. Jmava'ʉ, mʉ'ʉ pa'iche'te pãipi ñajʉ i'kani, “Dios Cʉnaʉmʉ Pa'ikʉ chʉ'o kʉakʉ'mʉ ikʉ”, chiijanaa'me mʉ'ʉre. Dios Raojaʉ raijachere kʉaja'mʉ mʉ'ʉ, pãipi asa care'va paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dios neenare masia'jʉ chini ija'che i'kaja'mʉ mʉ'ʉ: “Mʉsanʉkona cu'ache cho'osi'e tʉ'nesokani jo'e cuasamaneja'mʉ Dios. Tʉ'nesokakʉna vati toa sani uuche peoja'mʉ mʉsanʉkonare.” ");
INSERT INTO coe_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jã'aja'ñe cho'okaija'mʉ Dios pãi rʉa Oikʉjekʉ. Jã'ajekʉna Dios Repaʉ Mamakʉni raopi'ramʉ maire. ");
INSERT INTO coe_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Pa'ivesʉjʉ cu'ache cho'ojʉ chijacheja pa'icheja'che pa'inare jũnisochejẽ'e vajʉchʉnare Repaʉ Mamakʉni raopi'ramʉ Dios maire, maipi repaʉni cuasaa'jʉ chini. Rani pa'iʉ re'oja'che pa'imasiche'te che'choja'mʉ repaʉ maire, chiniasomʉ Zacarías repaʉ mamakʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Repava'ʉ chĩiva'ʉ Diore rʉa cuasakʉ aineekʉ paniasomʉ. Israelpãi chʉ'vamarʉmʉ pãi peochejñare te'eva'ʉ pa'iʉ paniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Jã'arʉmʉ Augusto pãi ũcuanʉkore chʉ̃'ʉkʉ paniasomʉ. Chekʉ Cirenio ũcuaja'che Siria cheja canani chʉ̃'ʉasomʉ reparʉmʉ. Augusto repaʉ paanare ũcuanʉkore chʉ̃'ʉasomʉ repana mamire tocharena kuẽkuera chini. Pãi kuẽkueche'te chʉ̃'ʉʉna repana aipãi pa'isijoopona saiche paniasomʉ repanare, mamire tochañu chini. ");
INSERT INTO coe_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pãipi saijʉna José ja'me saniasomʉ. Galilea cheja cajoopo Nazaret vʉ'ejoopo pa'isi'kʉpi Judea cheja cajoopona Belén vʉ'ejoopona saniasomʉ repaʉ, aipãiʉ David pa'isijoopona. ");
INSERT INTO coe_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","7","Maríana'me saniasomʉ repaʉ, ja'me kuẽkuecojñora chini. María repaʉ rʉ̃jo pa'ijao chĩipʉ sʉ'ikoji sani, tĩ'a pa'io repao chĩire jñaajarʉmʉpi tĩ'aʉna pi'raso chĩiva'ʉre ʉmʉva'ʉni jñaaasomo charo cava'ʉre. Jñaa repava'ʉre kãñase'repi rea, cu'ava'na ãu ãira'vʉrʉna ũhaasomo repao. Pãi kãivʉ'ñapi timusoʉna cu'ava'na kãivʉ'erʉna kãniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Reparʉmʉ Belén vʉ'ejoopo kueñere ovejava'nare kuirana paniasome. Ovejava'napi patu pa'ichejare pa'ijʉna ñamipi kuirajʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ũcuarʉmʉ Diore ja'me pa'ikʉji ángelpi rani pa'iʉna repana pa'ichejachi'a rũhiso'koro rʉa miañe miaasomʉ, Diopi cho'okʉna. Miakʉna ña rʉa kʉkʉsoasome repana oveja kuirana. ");
INSERT INTO coe_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Rʉa kʉkʉsinare ija'che i'kaasomʉ ángel: —Vajʉchʉmanejʉ̃'ʉ. Mʉsanʉkonare chʉ'o re'oja'chere kʉara chini raimʉ chʉ'ʉ Israelpãipi ũcuanʉko asa pojoa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Asarepajʉ̃'ʉ. Ija'chea'me chʉ'o chʉ'ʉ rasi'e: Chura iumucuse pãio chĩiva'ʉre jñaacuhasi'koa'mo, aperʉmʉ pa'isi'kʉ David pa'isijoopona. Repava'ʉ chĩiva'ʉ repaʉ'te cuasanare vati toa uuche Ʉ̃sejava'ʉpi ranicuhasi'kʉa'mʉ. Cristoa'mʉ repaʉ. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ. Pãi Ũcuanʉkore Paakʉ'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mʉsanʉkonapi sani ku'eni jñaa ñajanaa'me repava'ʉre. Ku'ejʉ jñaa ñato cu'ava'na ãu ãira'vʉrʉ'te reasiva'ʉ ũhija'mʉ chĩiva'ʉ. Repava'ʉre ñani, “Dios chĩia'mʉ ikʉ”, chiijanaa'me mʉsanʉkona —chiniasomʉ ángel repanare. ");
INSERT INTO coe_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angel te'eʉ kʉacuhaʉna chekʉna ángeles rʉa jainʉko rani paniasome. Pa'ijʉ Dioni pojojʉ ija'che i'kaasome repana: ");
INSERT INTO coe_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Cʉnaʉmʉ Pa'ikʉ Dios peore masikʉ'mʉ”, chiapʉ pãi ũcuanʉko! Ũcuaja'che, “Mʉsanʉkona Repaʉ oicojñona sãiñe pojojʉ pa'ijʉ̃'ʉ”, chiime chʉkʉna mʉsanʉkonare, chiniasome ángeles. ");
INSERT INTO coe_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","I'ka pi'ni cʉnaʉmʉna jo'e mʉnisorena sãiñechi'a ija'che i'kaasome repana oveja kuirana: —Belenna sañu mai. Repacheja cho'osi'ere Diopi raoʉna ra kʉamʉ ángel maire. Ñajañu chura cho'osi'ere —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chini cu'arepa sani tĩ'a Josena'me María'te ñaasome repana. Ũcuaja'che chĩiva'ʉre cu'ava'na ãu ãira'vʉrʉ ũhiva'ʉni ñaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ña pi'ni chĩiva'ʉ pa'iche'te ángel repanare kʉasi'ere kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kʉarena ũcuanʉko asa jñanoasome repana kʉache asasina. ");
INSERT INTO coe_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríata'ni repana kʉache asa i'kama'ko peore cuasako paniasomo. ");
INSERT INTO coe_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ña pi'ni co'iasome repana oveja kuirana. Co'ijʉ repana asasi'ena'me ñasi'e cuasa, “Peore masikʉ'mʉ Dios”, chiijʉ ángel kʉasi'e, “Ũcuarepaa'me”, chini Dioni pojojʉ co'isoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chĩiva'ʉ ochorepaumucujña jñaasi'e pa'itona jĩkora'murʉ chã'tirʉ pa'ica'nirʉ chʉto tʉa pi'ni mami ve'oasome repana. Jesure ve'oasome repana repava'ʉre chĩiva'ʉre. Aperʉmʉ chuta'a repaʉ'te sʉ'imarʉmʉ ángel kʉasi'ere mami ve'oasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dios aperʉmʉ Moisepi pãire kʉakaaʉ chini chĩire jñaasi'e cu'a pani pi'nirʉmʉ cho'ojache kʉaasomʉ. Jã'ajekʉna Dios chʉ̃'ʉ jo'kasi'ere cho'oñu chini Jesús pʉka'kʉpãi Jerusalén vʉ'ejoopona maniasome. Ũcuachi'a chĩiva'ʉni Dioni ñojʉ, “Ikʉ mʉ'ʉ neekʉa'mʉ”, chiñu chini maniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","24","Aperʉmʉ Diopi i'kakʉna Moisés tocha jo'kasi'e ija'che kʉamʉ: Mʉsanʉkona chĩiva'nare charo cava'nare ʉmʉpãiva'narechi'a chʉ'ʉni ĩsijʉ̃'ʉ. Chʉ'ʉ neenaa'me repana. Ũcuaja'che romi cu'a pa'ina cu'a pa'iche'te tʉnoñu chini jo'cha va'iva'nani ĩsijʉ̃'ʉ chʉ'ʉre. Airo jureva'nare ka'chava'nare peoni jo'cha ũkupo chĩiva'nani ũcuajanʉkorʉ'te ĩsijʉ̃'ʉ chʉ'ʉre, chiniasomʉ Dios. Jã'ajekʉna Jesús pʉka'kʉpãi Dios chʉ̃'ʉ jo'kasi'ere cho'oñu chini Jerusalén vʉ'ejoopona maniasome. ");
INSERT INTO coe_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Reparʉmʉ Jesús pʉka'kʉpãi Jerusalén vʉ'ejoopo mani ñato ũcuajoopo'te pãiʉ rʉa re'okʉ paniasomʉ Simeón, Diore cuasakʉ. Pa'iʉ Dios Raojaʉni cha'akʉ paniasomʉ repaʉ, pãi chekʉnapi Israelpãire cu'ache cho'oñu chiito Ʉ̃sejaʉni. Dios Rekocho repaʉ'te Simeonre ja'me paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ũcuarekochoji ja'me pa'iʉ ija'che kʉaasomʉ repaʉ'te: “Chuta'a jũnisomaneja'mʉ mʉ'ʉ. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉre ñañetʉ'ka vajʉʉ pa'ija'mʉ mʉ'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Ũcuarʉmʉ Simeón Dios Rekochoji chʉ̃'ʉkʉna Dios vʉ'ena mʉa kakaasomʉ. Kaka pa'iʉna Jesús pʉka'kʉpãi repaʉ'te cajajʉ ũcuavʉ'ena kakaasome. Dios chʉ̃'ʉ jo'kasi'ere cho'oñu chini kakarena repaʉ Simeón repava'ʉre chĩiva'ʉre cajo Dioni pojokʉ ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Chʉ'ʉre Paakʉ, mʉ'ʉ i'kasi'epi ũcuarepa ti'jñeʉna ñacuhamʉ chʉ'ʉ. Jã'ajekʉna chura chʉ'ʉre jũ'iñe ʉ̃semanejʉ̃'ʉ. Pojokʉ jũnisoja'mʉ chʉ'ʉ churata'ni, ũcuare iva'ʉre ñacuhasi'kʉjekʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mʉ'ʉ Raosi'kʉre ñacuhamʉ chʉ'ʉ pãi chẽa paakʉ vati toa uuche Ʉ̃sejaʉre. ");
INSERT INTO coe_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pãi ũcuanʉko ña masia'jʉ chini raosi'kʉa'mʉ mʉ'ʉ ikʉre. ");
INSERT INTO coe_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Churata'ni ikʉpi chʉ'vakʉna mʉ'ʉ chʉ'o asa chẽajanaa'me judío peona. Ũcuaja'che chura chʉkʉna'te judíopãi, mʉ'ʉ neenare re'oja'che cutujanaa'me pãi, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chĩiva'ʉni jã'aja'ñe i'kaʉna asa jñanoasome repana Jesús pʉka'kʉpãi. ");
INSERT INTO coe_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ũcuarʉmʉ repaʉ, —Diopi mʉsanʉkonare re'oja'che cho'okaaʉ —chini pʉka'kore María'techi'a i'kaasomʉ. Asarepajʉ̃'ʉ: Ikʉre Diopi raoʉna mai Israelpãi te'enachi'a ikʉni cuasajʉ re'oja'che pa'ijanaa'me. Chekʉnata'ni ikʉni cuasamapʉ cu'ache pa'ijanaa'me. Ikʉre pãi jainʉko cuhejanaa'me. Jã'ajekʉna iva'ʉre mʉ'ʉ chĩiva'ʉre rʉa oija'mo mʉ'ʉ. Pãi jainʉkore repana rekoñoã cuasache ña kʉaja'mʉ ikʉ, chiniasomʉ repaʉ Simeón. ");
INSERT INTO coe_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ũcuachi'a ũcuavʉ'ere Ana Dios chʉ'o kʉako, Fanuel, Aser pãiʉ mamako paniasomo. Rʉa aiva'o paniasomo repao. Rʉa romichĩiva'opi ʉmʉʉ'te veja sieterepaʉ̃sʉrʉmʉchi'a paniasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sieterepaʉ̃sʉrʉmʉ vejasi'e pa'ikoni ʉ̃jʉva'ʉpi jo'ka jũnisoʉna rʉa jeerʉmʉ te'eva'o pa'io paniasomo repao. Ochenta y cuatrorepaʉ̃sʉrʉmʉ te'eva'o paniasomo repao. Te'eo pa'io Dios vʉ'ere umucujñana'me ñami Dioni pojoko paniasomo repao, te'eñoãchi'a etako. Te'eumucujña ãu ãimairo pa'io Dioni sẽeo paniasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ũcuarʉmʉ Jesús pʉka'kʉpãi pa'iruupʉna kakaasomo repao. Kaka chĩiva'ʉre ña Dioni, “Re'orepamʉ”, chini chĩiva'ʉ pa'iche'te Israelpãire Jerusalén pa'inani repanare cu'ache cho'onare Ʉ̃sekaijaʉre cha'anani kʉaasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ũcuarʉmʉ Jesús pʉka'kʉpãi Dios chʉ̃'ʉ jo'kasi'e peore cho'o pi'ni chĩiva'ʉre co'chajʉ repana pa'ijoopona, Galilea cheja cajoopo Nazaret vʉ'ejoopona co'iasome. ");
INSERT INTO coe_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Co'i pa'ijʉna aineekʉ chĩiva'ʉ na'a rʉa kokaʉ paniasomʉ. Dios chʉ̃'ʉ jo'kasi'e rʉa che'chekʉ aineekʉ paniasomʉ repava'ʉ chĩiva'ʉ. Dios repaʉ'te pojokʉ re'oja'che cho'okaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús pʉka'kʉpãi Jerusalén vʉ'ejoopo si'aʉ̃sʉrʉmʉ maniasome. Aperʉmʉ Dios repana aipãi Egipto cheja pa'inare etua rasi'ere cuasajʉ pojojʉ fiesta'te ja'me cho'oñu chini maniasome. Repa fiesta mami pascuaa'me. ");
INSERT INTO coe_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chĩiva'ʉ docerepaʉ̃sʉrʉmʉ pa'itona fiestarʉmʉ tĩ'aʉna pʉka'kʉpãi Jesure majʉ maniasome Jerusalén vʉ'ejoopona. ");
INSERT INTO coe_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiesta cho'o pi'ni Jesús pʉka'kʉpãi co'ijʉna pãi jainʉko ja'me co'iasome. Ũcuanʉko co'ito te'eva'ʉ chĩiva'ʉ co'imaneasomʉ. Repaʉ co'ima'ñe pʉka'kʉpãi vesʉasome. ");
INSERT INTO coe_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Vesʉjʉ, “Chekʉnana'me co'icosomʉ mai chĩi”, chini te'eumucuse co'inapi mamakʉ'te ku'easome repana. Ku'ejʉ peore repana majapãina'me repaʉ ñanare sẽniasaasome repana chĩiva'ʉni jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jã'ata'ni repaʉ'te jñaamaneasome repana. Ku'ete'e Jerusalenna jo'e co'iasome repana repaʉni ku'e jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Choteumucujña ku'enapi Dios vʉ'e kaka ñato ũcuavʉ'ere pa'iʉ judíopãi che'chona chenevʉ'te ñu'iʉ repana i'kache'te asa sẽniasakʉ paniasomʉ repaʉ chĩi. ");
INSERT INTO coe_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sẽniasakʉna repanapi sãiñe chʉ'o sẽeto rʉa masi kʉaasomʉ repaʉ. Repaʉji masi kʉakʉna asa rʉa jñanoasome repana, “Rʉa masimʉ ikʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pʉka'kʉpãi repaʉ i'kache'te asa jñano pʉka'kochi'a ija'che i'kaasomo repaʉ'te: —Jmava'ʉ, ¿je'se pa'iʉna mʉ'ʉ chʉkʉna'te kʉamairo canʉkaʉ? Mʉja'kʉna'me chʉ'ʉ mʉ'ʉni oijʉ rʉa ku'ejʉ pa'ime —chiniasomo pʉka'ko. ");
INSERT INTO coe_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chikona, —¿Je'se pa'iʉna ku'ere chʉ'ʉre? Chʉ'ʉ Ja'kʉ chʉ̃'ʉ jo'kasi'e cho'oche pa'imʉ chʉ'ʉre ivʉ'e. ¿Jã'a mʉsanʉkona vesʉche? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jã'ata'ni repaʉ i'kasi'e asavesʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ũcuarʉmʉ Jesús pʉka'kʉpãina'me Nazaret vʉ'ejoopona co'iasomʉ. Co'i pa'iʉ pʉka'kʉpãi chʉ̃'ʉñe cho'okʉ paniasomʉ repaʉ. Repaʉ pʉka'ko Dios vʉ'e repaʉ cho'osi'ere rʉa cuasako paniasomo. ");
INSERT INTO coe_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Repaʉ Jesús aineekʉ na'a rʉa masi cuasaasomʉ. Dios repaʉ'te rʉa pojoasomʉ, pãi ũcuaja'che. ");
INSERT INTO coe_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Reparʉmʉ Tiberiopi pãi ũcuanʉkore chʉ̃'ʉasomʉ. Repaʉ Tiberio quincerepaʉ̃sʉrʉmʉ chʉ̃'ʉrʉmʉna Poncio Pilato ũcuaja'che Judea cheja pa'inani chʉ̃'ʉasomʉ. Herodes ũcuaja'che Galilea cheja pa'inani chʉ̃'ʉasomʉ. Felipe ũcuaja'che Herodes cho'jeʉ Iturea cheja pa'inana'me Traconite cheja pa'inare chʉ̃'ʉasomʉ. Lisanias ũcuaja'che Abilinia cheja pa'inani chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Repana chʉ̃'ʉrʉmʉ Anana'me Caifás judío phairipãire ũcuanʉkore chʉ̃'ʉasome. Reparʉmʉ Dios Zacarías mamakʉ'te Juanre pãi peochejare pa'iʉna pãire chʉ'vaa'kʉ chini chʉ̃'ʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chʉ̃'ʉʉna asa sani Jordán chiacha rʉ'tʉva pa'inani pãire chʉ'vakʉ paniasomʉ repaʉ peore repakã'jño ku'iʉ. Ija'che chʉ'vaasomʉ repaʉ: —Mʉsanʉkona cu'ache cho'oche ũhaso re'oja'chere mama cuasajʉ̃'ʉ, Diopi mʉsanʉkona cu'ache cho'osi'ere tʉnoso jo'e cuasamanea'kʉ. Cu'ache cho'oche'te ũhaso Dioni cuasajʉ okoro'vecojñojʉ̃'ʉ —chiiʉ chʉ'vakʉ paniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aperʉmʉ Isaías, Dios chʉ'o kʉasi'kʉ ija'che tocha jo'kaasomʉ maire, Juan cho'ojachere kʉakʉ: Pãiʉ pãi peochejare sani pa'iʉ pãipi repaʉni saito ʉjachʉ'opi ija'che i'kakʉ chʉ'vaja'mʉ: “Maire Paakʉ raipi'ramʉ. Repaʉni cha'ajʉ mʉsanʉkona rekoñoã ma'a rũhiñe pa'ima'a care'vacheja'che re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aikũjña chenevʉã peore cha'opi ta'pisõja'mʉ. Aikũjña rʉa ʉjakũjña pa'isikũjña jmakũjñarʉã ñañasõja'mʉ. Ma'ña jʉ'chʉ pa'ima'ña rũhima'ña carũhija'mʉ. Ma'ña cojñana'me chĩ'ca pa'isima'ña sʉ'kajama'ña care'oja'mʉ. Mʉsanʉkona aperʉmʉ pa'isi'e peore rũhiñe care'vajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dios Raojaʉ pãi oiʉ vati toa uuche Ʉ̃sejaʉ raija'mʉ maire. Rakʉna pãi ũcuanʉko ñajanaa'me repaʉ'te”, chiija'mʉ repaʉ, chiimʉ Isaías tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ũcuarʉmʉ pãi jainʉko Juanre okoro'vecojñoñu chini saniasome. Satena ija'che i'kaasomʉ repaʉ: —Mʉsanʉkona te'ena chuta'a cu'ache cho'oche ũhamanajejʉ aña pa'icheja'che cu'ache pa'ime. “Maipi okoro'vecojñoru Dios maire cu'ache cho'omaneja'mʉ”, chini cuasajʉ raime mʉsanʉkona. Jã'ata'ni mʉsanʉkona cu'ache cho'oche ũhasoma'to Diopi chʉ̃'ʉʉna cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mʉsanʉkona cu'ache cho'oche'te ũhaso re'oja'che pa'ijʉ Dios chʉ̃'ʉñe'te cho'ojʉ pa'ijʉ̃'ʉ. Mʉsanʉkonapi re'oja'che pa'ito chekʉnapi ñani, “Ina cu'ache cho'oche ũhasosinajejʉ re'oja'che pa'ime”, chiijanaa'me mʉsanʉkonare. Ija'che cuasacosome mʉsanʉkona: “Abraham jojosinaa'me mai. Jã'ajekʉna Dios maire cu'ache cho'omaneja'mʉ”, chiijʉ cuasacosome mʉsanʉkona. Jã'aja'ñe cuasamanejʉ̃'ʉ mʉsanʉkona. Diore Repaʉni cho'oʉato ira'karʉã catara'karʉãpi Abraham jojosinare chekʉnare cho'ore'omʉ, Repaʉ chʉ̃'ʉñe cho'ojanare. ");
INSERT INTO coe_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sũkiñʉã ãiñe kʉ̃iñʉãpi sãijapʉã kʉ̃ima'to, “Cu'amʉ iñʉã”, chini kueni ʉosome pãi. Dios ũcuaja'che pãi cu'ache pa'inare cu'anajejʉna vati toana saoja'mʉ —chiniasomʉ Juan repanare. ");
INSERT INTO coe_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chikʉna, —Jã'a pa'ito, ¿ʉ̃quere cho'ojanaa'ñe chʉkʉna? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chitena, —Ija'che cho'ojʉ̃'ʉ. Mʉsanʉkona ũcuaʉakʉji kãña ka'chakãña paani chekʉre kãña peova'ʉre te'ekãa ĩsijʉ̃'ʉ. Ũcuachi'a mʉsanʉkona ũcuaʉakʉji ãu paani chekʉnare ãu peova'nare ĩsijʉ̃'ʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","I'katona pãi chʉ̃'ʉnare kuri kookaina Juanni raniasome, okoro'vecojñoñu chini. Rani repaʉ'te ija'che sẽniasome repana: —Masiʉ, chʉkʉna, ¿ʉ̃quere cho'ojanaa'ñe? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chitena i'kaasomʉ repaʉ. —Pãi chʉ̃'ʉna mʉsanʉkonare chʉ̃'ʉsinʉkorʉchi'a kuri sẽni koojʉ pa'ijʉ̃'ʉ. Na'a cajejaiche sẽni koomanejʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sõtaopãi ũcuaja'che sẽniasome repaʉ'te. —¿Ʉ̃quere chʉkʉna cho'ojanaa'ñe? —chiniasome. Chitena i'kaasomʉ repaʉ. —Kuri ʉakʉna pãi paache'te cho'o kʉko tʉamanejʉ̃'ʉ. Ũcuachi'a kurire kʉko tʉasoñu chini cu'ache cho'omanani, “Cu'ache cho'osinaa'me mʉsanʉkona”, chiimanejʉ̃'ʉ. Cho'oche ro'ichi'a koojʉ pojojʉ pa'ijʉ̃'ʉ. Na'a rʉa kooche chiimanejʉ̃'ʉ —chiniasomʉ Juan repanare sõtaopãi. ");
INSERT INTO coe_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jã'aja'ñe i'kaʉna asa jñanoasome repana pãi. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raojaʉre Cristo'te cha'anajejʉ ija'che cuasaasome repana: “¿Dios Raosi'kʉa'ʉ ikʉ? ¿Cristoa'ʉ?”, chini cuasaasome repana. Juan pa'iche'te vesʉjʉ sãiñechi'a sẽniasaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Repanapi sãiñechi'a sẽniasajʉna asa Juan ũcuanʉkore i'kaasomʉ. —Chʉ'ʉ mʉsanʉkonare re'oja'che cho'okaiʉ okoro'vemʉ. Na'a pa'isirʉmʉ chekʉ na'a rʉa masikʉji rani pa'iʉ na'a rʉa re'oja'che cho'okaija'mʉ mʉsanʉkonare. Chʉ'ʉre na'a rʉa masikʉjekʉna repaʉ'te cuasakʉ vajʉchʉkʉ pa'imʉ chʉ'ʉ. Na'a rʉa masikʉjekʉ repaʉ'te cuasanare Dios Rekocho'te ĩsija'mʉ repaʉ. Repaʉ'te cuasamanareta'ni Ũcuaʉji chʉ̃'ʉʉna na'a pa'isirʉmʉna cu'ache ti'jñeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pãi trigo cho'oni po'te repacaã rũhikuanupʉ chi'i ũhame. Repasʉota'ni ʉosome. Na'a pa'isirʉmʉ Raijaʉ pãi ũcuanʉkore chi'i trigo cho'ocheja'che cho'okʉ cu'ache cho'oche ũhamanare vati toana chachamatoana saoja'mʉ. Cu'ache cho'oche ũhaso Repaʉ'te cuasanareta'ni pʉka'kʉ pa'ichejana saja'mʉ repaʉ —chiniasomʉ Juan repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dios chʉ'o re'oja'chere rʉa chʉ'vache chʉ'vaasomʉ Juan repanare. ");
INSERT INTO coe_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na'a pa'isirʉmʉ Herodes, pãi chʉ̃'ʉkʉji cho'jeʉ Felipe rʉ̃joni Herodíani tʉa paaasomʉ. Tʉa paakʉna Juan asa chʉ'vate'easomʉ repaʉ'te, ũcuachi'a cheke cu'ache cho'osi'ere asani. ");
INSERT INTO coe_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chʉ'vakʉ'teta'ni asa jachasokʉ jo'e na'a rʉa cu'ache cho'oasomʉ repaʉ. Repaʉ'te chʉ'vasiva'ʉre Juanre pãi chẽavʉ'ena cuaoasomʉ repaʉ Herodes. ");
INSERT INTO coe_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aperʉmʉ Juan pãi jainʉkore okoro'vekʉ paniasomʉ. Ũcuaja'che Jesure okoroasomʉ repaʉ. Okorocojñosirʉmʉ Jesús pʉka'kʉni sẽniasomʉ. Pʉka'kʉni sẽeʉna cʉnaʉmʉ teana re'ojaʉmʉ care'o ");
INSERT INTO coe_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dios Rekocho ũkupoja'iʉ ũcuaʉni cajeasomʉ. Dios Rekocho cajesirʉmʉ cʉnaʉmʉpi ija'che i'kache asoasomʉ: —Mʉ'ʉ chʉ'ʉ chĩia'mʉ. Mʉ'ʉre rʉa chiimʉ chʉ'ʉ. Mʉ'ʉre rʉa pojomʉ chʉ'ʉ —chiiche asoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treintarepaʉ̃sʉrʉmʉ pa'icosomʉ chekʉrʉmʉ, repaʉ pãi apechʉ'varʉmʉ. “Jã'ʉ Jesús, José chĩia'mʉ”, chiijʉ cuasaasome pãi repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí pʉka'kʉ pa'isi'kʉ Matat paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pʉka'kʉ pa'isi'kʉ Matatías paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pʉka'kʉ pa'isi'kʉ Maat paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pʉka'kʉ pa'isi'kʉ Joanán paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pʉka'kʉ pa'isi'kʉ Melqui paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pʉka'kʉ pa'isi'kʉ Josué paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pʉka'kʉ pa'isi'kʉ Leví paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim pʉka'kʉ pa'isi'kʉ Melea paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán pʉka'kʉ pa'isi'kʉ David paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón pʉka'kʉ pa'isi'kʉ Aminadab paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pʉka'kʉ pa'isi'kʉ Jacob paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pʉka'kʉ pa'isi'kʉ Serug paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pʉka'kʉ pa'isi'kʉ Cainán paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pʉka'kʉ pa'isi'kʉ Matusalén paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pʉka'kʉ pa'isi'kʉ Enós paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ũcuarʉmʉ Jesús Jordán chiacha saisi'kʉ rani Dios Rekocho chʉ̃'ʉñe peore si'arʉmʉ cho'okʉ paniasomʉ. Dios Rekochoji chʉ̃'ʉʉna pãi peochejare sani pa'iʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarentarepaumucujña pãi peochejare pa'iʉ ãu ãima'ñe pa'iʉna ãucuhaasomʉ repaʉ'te. Pãi peochejare pa'iʉna vati ai sani Jesuni cacʉ'ora chini ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—Mʉ'ʉpi Dios Mamarepakʉ pani ipʉ catapʉ mini, pãpʉ carʉñojʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chikʉna Jesús ija'che i'kaasomʉ repaʉ'te: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Pãipi chʉ'ʉrejẽ'e cuasama'ñe repana ãijañere ãuchi'a cuasajʉ pa'ito cu'amʉ. Jã'achi'a cuasama'ñe chʉ'ʉ chʉ̃'ʉñe'te cuasajʉ cho'ojʉ pani re'oja'che pa'ijanaa'me pãi, chiimʉ —chiniasomʉ Jesús vatire. ");
INSERT INTO coe_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jã'aja'ñe i'kacuhasirʉmʉ vati ai repaʉ'te Jesure aikũtina sa mʉa teana te'erʉmʉ peore chejña pãi pa'ichejña ñoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Ñokʉ ija'che i'kaasomʉ repaʉ repaʉ'te: —Cheja pa'iche peore rʉa re'oja'chea'me. Aperʉmʉna chʉ'ʉre ĩsisichejñaa'me ichejña, chʉ'ʉpi peore chʉ̃'ʉa'kʉ chini. Chura chʉ'ʉre ʉakʉni ĩsija'mʉ chʉ'ʉ. Jã'ajekʉna mʉ'ʉpi chʉ'ʉni, “Peore masikʉ'mʉ mʉ'ʉ”, chiiʉ, ro're ñu'iʉ pojoru mʉ'ʉni peore ichejña ĩsija'mʉ chʉ'ʉ, mʉ'ʉpi chʉ̃'ʉkʉ paaʉ chini. Cheja pa'imajñarʉã cu'amajñarʉã peore ĩsija'mʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ vati. ");
INSERT INTO coe_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Diore Pãi Ũcuanʉkore Paakʉ'techi'a, “Peore masikʉ'mʉ mʉ'ʉ”, chiijʉ pojojʉ Repaʉ chʉ̃'ʉñechi'a cho'ojʉ pa'ijʉ̃'ʉ mʉsanʉkona pãi, chiimʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Jã'a i'kacuhasirʉmʉ vati ai repaʉ'te Jerusalén vʉ'ejoopona sa Dios vʉ'e sẽ'sevʉna mʉa ija'che i'kaasomʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Dios ángeleva'nare, mʉ'ʉni kuirajʉ mʉ'ʉ tuã'ito repana jʉ̃jñapi chẽaa'jʉ chini raoja'mʉ, mʉ'ʉpi tuãni asi cho'omanea'kʉ chini, chiimʉ. Jã'ajekʉna mʉ'ʉpi Dios Mamarepakʉ pani ichejapi chejana chã'ijʉ̃'ʉ. Dios i'kasi'epi ũcuarepa pa'ito ichejapi chãni asi cho'omaneja'mʉ mʉ'ʉ —chiniasomʉ vati ai. ");
INSERT INTO coe_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chikʉna Jesús i'kaasomʉ. —Ũcuachi'a Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉ cho'omasiche'te rupʉ ñañu chini sẽemanejʉ̃'ʉ mʉsanʉkona pãi, chiimʉ Dios —chiniasomʉ Jesús repaʉ'te vati aire. ");
INSERT INTO coe_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chikʉna Jesure si'ache cu'ache cho'oa'kʉ chini chʉ̃'ʉte'e jo'ka sanisoasomʉ repaʉ vati ai, jo'e na'a pani rasa chini. ");
INSERT INTO coe_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jã'a cho'o pi'nisirʉmʉ Galilea chejana co'iasomʉ Jesús. Dios Rekocho chʉ̃'ʉñechi'a peore re'oja'chechi'a cho'okʉji co'iasomʉ repaʉ. Peore cho'okʉji co'iʉna Galilea cheja pa'inana'me ũcuacheja kueñe pa'ina jainʉko repaʉ pa'iche'te asa cutujʉ paniasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ũcuachejare pa'iʉ judíopãi chi'ivʉ'ñana si'arʉmʉ mʉa che'chokʉ paniasomʉ repaʉ. Che'chokʉna asa, “Rʉa masiʉ'ʉ ikʉ”, chini pãi ũcuanʉko re'oja'che cutuasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ũcuarʉmʉ Jesús Nazaret vʉ'ejoopona co'iasomʉ, repaʉ aineesijoopona. Co'i pa'iʉ pʉaumucusepi tĩ'aʉna judíopãi chi'ivʉ'ena mʉa kaka ñu'isi'kʉpi Dios chʉ'o tocha jo'kasi'ere ñakʉ i'kara chini vʉni nʉkaasomʉ repaʉ. Pʉaumucujña tĩ'ato judíopãi chi'ivʉ'e si'arʉmʉ mʉaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Vʉni nʉkakʉna Dios chʉ'o aperʉmʉ kʉasi'kʉ Isaías tocha jo'kasi'e pa'ikorovʉ'te mini ĩsiasome repaʉ'te, ñakʉ i'kaa'kʉ chini. Ĩsirena rũhikorovʉ ca'nesija'ovajekʉna repaʉ ñakʉ i'kajachere ku'ekʉ koraasomʉ repaʉ. Ku'e jñaa ija'chere ñakʉ i'kaasomʉ repaʉ: ");
INSERT INTO coe_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Dios Rekochoji chʉ̃'ʉmʉ chʉ'ʉre, chʉ'ʉpi pãire Dios chʉ'ore re'oja'chere chʉ'vaa'kʉ chini. “Pãire ija'che chʉ'vajʉ̃'ʉ”, chiimʉ chʉ'ʉre Dios Rekocho: “Chʉova'na pa'iva'nani Dios chʉ'ore chʉ'vajʉ̃'ʉ, Repaʉni cuasajʉ pojojʉ paapʉ. Ũcuaja'che Dios chʉ'o vesʉva'nare chʉ'vajʉ̃'ʉ masia'jʉ. Cu'ache cho'ocojñonare ũcuaja'che cu'ache cho'oche ʉ̃sekaijʉ̃'ʉ.” Ija'che kʉajʉ̃'ʉ repanare pãi: “Dios re'oja'che paapʉ chini vati ai paasinare pãi tʉa paaja'mʉ, vati chʉ̃'ʉñe'te cho'omanea'jʉ chini. Pãi ũcuanʉkore Dios re'oja'che cho'okairʉmʉ tĩ'acuhamʉ”, chiiche'te ñakʉ i'kaasomʉ Jesús, Isaías tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I'ka pi'ni repaja'ova ca'ne repavʉ'e kuirakʉni co'cho pʉʉ ñu'iʉna repavʉ'e chi'isina pãi ũcuanʉko rʉa pãiñaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ñajʉna repanare jo'e i'kaasomʉ repaʉ. —Chura chʉ'ʉ ñakʉ i'kasi'e aperʉmʉ Dios i'kasi'ea'me. Dios aperʉmʉ kʉasi'e mʉsanʉkona ñajʉ'te cho'o ñocuhamʉ iumucuse —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jã'aja'ñe i'kaʉna asa jñano pãi ũcuanʉko re'oja'che cutuasome repaʉ'te, “Chʉ'o re'oja'chere i'kamʉ ikʉ”, chiijʉ. Asa jñano sãiñechi'a sẽniasaasome repana. —¿Ikʉ José mamakʉma'kʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jã'aja'ñe i'kajʉna asa i'kaasomʉ repaʉ. —Chʉ'ʉ i'kasi'ere jachajʉ ija'che i'kañu chiime mʉsanʉkona chʉ'ʉre: “Mʉ'ʉ Capernaum vʉ'ejoopo pa'iʉ cho'osi'e asasinaa'me chʉkʉna. Chura ichejana mʉ'ʉ pa'ichejana ũcuare chʉkʉnani cho'o ñoto jachamanejanaa'me chʉkʉna mʉ'ʉre. Mai aipãi ija'che i'kaasome: ‘Ʉ̃ko chaipi jũni ũcuaʉji meñe ʉ̃ko cho'o vajʉre'omʉ’, chiniasome.” Jã'aja'ñe mʉsanʉkona i'kañu chiime chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chini jo'e i'kaasomʉ repaʉ. —Mʉsanʉkonare ũcuarepare chʉ'o i'kamʉ chʉ'ʉ. Dios chʉ'o kʉakaina aineesijoopoã cana pãi repana kʉache Dios chʉ'o asa jachame. Mʉsanʉkona ũcuaja'che ijoopo chʉ'ʉ aineesijoopo cana chʉ'ʉ kʉache Dios chʉ'o asa jachame. ");
INSERT INTO coe_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Aperʉmʉ cho'osi'ere kʉara. Aperʉmʉ ũcuaja'che Elíapi Dios chʉ'ore kʉakʉna judío aipãi asa jachaasome ũcuate'epãiʉ'teta'ni. Reparʉmʉ Israel cheja va'jeromiva'na rʉa jainʉko pa'irʉmʉna choteʉ̃sʉrʉmʉ jo'e chekʉʉ̃sʉrʉmʉ joopo okojẽ'e ramaʉna ãujẽ'e peoasomʉ. Ãure peojʉ si'achejña ãucuhava'na paniasome pãi. Repacheja canapi repaʉ chʉ'vache'te asa jachajʉna cho'okaimaneasomʉ Elías repanare. Diopi saoʉna judío peona pa'ichejare Sarepta vʉ'ejoopo'te sani repajoopo cava'oni te'eva'ore va'jeva'ore re'oja'che cho'okaniasomʉ repaʉ Elías. Sarepta vʉ'ejoopo kueñea'me Sidón. ");
INSERT INTO coe_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aperʉmʉ Eliseo Israel chejare pa'iʉ Dios chʉ'ore kʉakʉ paniasomʉ. Mai aipãi, asi ravʉ jũ'ina rʉa jainʉko paniasome reparʉmʉ. Eliseo repaʉ kʉache'te Dios chʉ'ore repanapi asa jachajʉna te'eʉ'terejẽ'e asi ravʉ jũ'ikʉ'te vasokaimaneasomʉ, Diopi ʉ̃sekʉna. Judío peokʉ'techi'a te'eʉ'te vasoasomʉ repaʉ, Naamán, Siria cheja cakʉrechi'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesupi judío peonare Dios cho'okaiche'te kʉaʉna asa repavʉ'e pa'ina ũcuanʉko rʉa pe'ruasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Asa pe'rujʉ vʉni Jesure chẽa vʉ'ejoopo rʉ'tʉvana juha saasome repana. Juha sa aikũti sẽ'sevʉ pa'ijoopojekʉna repakũti chu'chuvana na'a ʉmʉna mʉaasome repana repaʉ'te, ũcuachejapi jʉjo tõñu chini. ");
INSERT INTO coe_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jʉjo tõñu chiisinareta'ni repana chenevʉji eta sanisoasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eta sani Galilea cheja cajoopona Capernaum vʉ'ejoopona tĩ'aasomʉ repaʉ Jesús. Tĩ'a pa'iʉ pʉaumucusepi tĩ'aʉna judíopãi chi'ivʉ'ena mʉa che'choasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rʉa masikʉjekʉ masi che'chokʉna asa jñano, “Rʉarepa masikʉ ikʉ”, chiniasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Reparʉmʉ ũcuavʉ'ere pãiʉ vatire paakʉ paniasomʉ. Vatire paakʉjekʉ Jesús i'kache'te asa rʉa cuikʉ ija'che i'kaasomʉ repaʉ: ");
INSERT INTO coe_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, Nazaret raisi'kʉ chʉkʉna'te cho'omanejʉ̃'ʉ. Mʉ'ʉ pa'iche masimʉ chʉ'ʉ. Dios Raocojñosi'kʉa'mʉ mʉ'ʉ. Re'okʉ'mʉ. ¿Chʉkʉnani cu'achejana saora chini rakʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jã'aja'ñe i'kaʉna Jesús repaʉ'te vatire jo'e i'kache ʉ̃sekʉ ija'che i'kaasomʉ: —Re'omʉ. Ũcuamakarʉ i'kajʉ̃'ʉ. Etajʉ̃'ʉ mʉ'ʉ jã'ʉre pãiʉ'te —chiniasomʉ Jesús. Jesupi, “Etajʉ̃'ʉ”, chikʉna vati pãiva'ʉre pa'isi'kʉ repava'ʉre cho'o tãukʉ eta sanisoasomʉ. Pãiʉ'te asi cho'oma'ñe eta sanisoasomʉ vati. ");
INSERT INTO coe_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jesupi vatini eto saoʉna ña, kʉkʉso pãi ũcuanʉko sãiñechi'a cutuasome. —¿Je'se pa'ikʉjekʉ ikʉ vati chʉ̃'ʉmasikʉ? Jesupi rʉa masikʉjekʉ chʉ̃'ʉto eta sanisõnaa'me vati —chiniasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús cho'osi'e ñasinapi kueñe pa'inani kʉarena asa Jesús pa'iche'te cutujʉ paniasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ũcuarʉmʉ Jesús judíopãi chi'ivʉ'e eta Simón vʉ'ena mʉa kakaasomʉ. Kaka ñato Simón vao cha'vo ravʉna jũniasomo. Jũ'iona, repaoni vasoa'kʉ chini Jesure rʉa sẽniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Rʉarepa sẽejʉna jũ'iko ũhiko'a kueñere nʉkakʉ, “Cha'voche chʉrʉjʉ̃'ʉ ikore”, chiniasomʉ Jesús. Chikʉna teana vajʉasomo repao. Vajʉ vʉni repanare ãure ãuasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na'icuhatona chekʉnare jũ'inare saasome pãi, Jesupi vasoa'kʉ chini. Ravʉ rʉa si'ache jũ'inani saasome repana. Sarena repanare ũcuanʉkore rupʉ chẽse vasoasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ũcuachi'a vati jainʉkore pãi pa'isinare peore eto saosokaniasomʉ repaʉ. Eto saokʉna cuijʉ ija'che i'kaasome vati: —Dios Mamakʉ'mʉ mʉ'ʉ —chiniasome. Jã'aja'ñe i'kajʉna, “Jo'e i'kamanejʉ̃'ʉ”, chini i'kaʉ̃seasomʉ Jesús repanare vati. “Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ ikʉ. Cristoa'mʉ”, chiijʉ chini ʉ̃seasomʉ Jesús repanare vati. ");
INSERT INTO coe_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jo'e apeñatato vʉ'ejoopo pa'isi'kʉpi eta pãi peochejana saniasomʉ Jesús. Sani te'eʉ pa'iʉna repaʉ pa'isijoopo pa'ina ku'e jñaa tĩichejña saiʉ̃seasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ʉ̃sejʉna, —Dios chʉ'ʉre Repaʉ chʉ'ore kʉaa'kʉ chini raosi'kʉa'mʉ. Jã'ajekʉna chekʉchejñare sani ku'iʉ repachejña cajoopoã canani cu'ache cho'oche ũhasõsinare pãi Dios chẽa paache'te kʉache pa'imʉ chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Galilea cheja pa'irʉmʉ judíopãi chi'ivʉ'ña si'arʉmʉ mʉa Dios chʉ'ore chʉ'vakʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na'a pa'isirʉmʉ Jesupi Genesaret chiara rʉ'tʉva'te sani nʉkakʉna pãi jainʉko rani chi'iasome. Repaʉ i'kache'te Dios chʉ'ore kueñe nʉkajʉ asañu chini, jairepanʉkojejʉ repaʉ'te rʉ̃'ʉñe ji'risoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chi'irena nʉkakʉ chiara rʉ'tʉva ju'ivʉãre choovʉã te'eka'chapavʉã pãi peovʉã ju'ivʉãre ñaasomʉ repaʉ, va'i chonapi jʉo mani va'i chorʉãre choajʉna. ");
INSERT INTO coe_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ña sani Simón choovʉna tuni, “Chʉ'ʉre na'a joopona etuajʉ̃'ʉ”, chiniasomʉ repaʉ Simonre, choovʉ paakʉ'te. Chikʉna, “Jaʉ”, chini na'a joopona etuaʉna choovʉ'te ñu'iʉ pãire che'choasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Che'cho pi'ni Simonre jo'e i'kaasomʉ repaʉ. —Jeechejana rʉichejana sañu. Sani va'ire chojʉ̃'ʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chikʉna, —Masiʉ, ñami chʉkʉna si'añami chojʉ pa'isinaa'me. Jã'ata'ni va'irejẽ'e chomanesinaa'me chʉkʉna. Jã'ata'ni mʉ'ʉpi chʉ̃'ʉkʉna jo'e choja'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jesupi chʉ̃'ʉʉna cho churata'ni va'ire jairepanʉkore chorena va'i chorʉã che'reasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Che'resokʉna repanare ja'me pa'inare chekʉvʉ pa'inare vevojʉ soniasome repana, rani ja'me cho'okaapʉ chini. Sotena rani repana choovʉna'me chekʉna choovʉ peore va'ire jairepanʉkore tujña timuso runisora'aasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jã'aja'ñe cho'oʉna ña Simón Pedro Jesure ti'jñeñe ro're ñu'iʉ ija'che i'kaasomʉ: —Pãi Ũcuanʉkore Paakʉ, cu'ache pa'ikʉ'mʉ chʉ'ʉ. Jã'ajekʉna jo'ka saijʉ̃'ʉ chʉ'ʉre —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón Pedro va'ire jairepanʉkore cho repaʉ'te ja'me pa'inana'me kʉkʉsoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Va'i ja'me chosina, Zebedeo chĩi, repanare ja'me pa'ina Santiagona'me Juan ũcuaja'che kʉkʉasome. Kʉkʉjʉna Jesús Simonni i'kaasomʉ. —Vajʉchʉmanejʉ̃'ʉ mʉsanʉkona. Irʉmʉpi vʉa sani ku'iʉ pãire chʉ'vakʉ pa'ijʉ̃'ʉ mʉ'ʉ, chʉ'ʉni cuasajʉ jovoa'jʉ —chiniasomʉ Jesús repaʉ'te Simonre. ");
INSERT INTO coe_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jã'aja'ñe i'kaʉna asa, “Jaʉ”, chini choovʉã jñajñu mau ũha cu'amajñarʉã peore ũcuachejana jo'ka Jesuna'me saniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na'a pa'isirʉmʉ Jesupi vʉ'ejoopo'te sani pa'iʉna pãiʉ ca'nivʉ si'acaca'nivʉ asi ravʉ paava'ʉpi rani tijñaasomʉ Jesure. Tijña repaʉ chia meñe sime ro're ñu'iʉ Jesure rʉa sẽniasomʉ repaʉ. —Pãi Ũcuanʉkore Paakʉ, mʉ'ʉre vasoʉato vasojʉ̃'ʉ chʉ'ʉva'ʉre; vajʉra —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chikʉna Jesús repaʉni chẽakʉ i'kaasomʉ. —Jaʉ, vasora. Vajʉjʉ̃'ʉ —chiiʉ chẽakʉna asi teana te'erʉmʉ peore ja'jusoasomʉ repaʉ ca'nivʉ pa'isi'e. ");
INSERT INTO coe_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Repaʉ'te vasocuha Jesús ija'che chʉ̃'ʉasomʉ: —Chʉ'ʉ mʉ'ʉre vasosi'e pãi chekʉnare kʉamanejʉ̃'ʉ. Kʉama'ñe judío phairi'techi'a ñojaijʉ̃'ʉ mʉ'ʉ vajʉsica'nivʉ. Ũcuaja'che aperʉmʉ Moisés chʉ̃'ʉ jo'kasi'e cu'amajñarʉã sa ĩsijʉ̃'ʉ Diore, mʉ'ʉ cu'are tʉnokakʉna mʉ'ʉ vajʉsi'ere masia'jʉ pãi —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jã'ata'ni chekʉnapi repana asasi'ere jo'e chekʉnani kʉajʉna na'a rʉa jainʉko pãi Jesús pa'iche asaasome. Asa repaʉ pa'ichejana si'arʉmʉ na'a jainʉko chi'ijʉ paniasome pãi, repaʉ i'kache'te asañu chini. Jũ'iva'na ũcuaja'che vasocojñoñu chini ja'me chi'iasome. ");
INSERT INTO coe_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pãipi si'arʉmʉ repaʉ pa'ichejana na'a jainʉko raijʉna si'arʉmʉ pãi peochejana Dioni sẽsa chini saiʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na'a pa'isirʉmʉ Jesupi che'chokʉna fariseopãina'me judíopãi che'chona ñu'ijʉ asajʉ paniasome. Galilea cheja cajoopoãna'me Judea cheja cajoopoã si'ajoopoã raisinana'me, Jerusalén vʉ'ejoopo raisina paniasome repana. Diopi peore Cho'omasikʉji cho'okaiʉna jũ'iva'nare vasoasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesús repavʉ'e pa'itona pãi nʉka ku'imava'ʉre ũhikãa ũhiva'ʉni kuãijʉ raniasome. Jesús pa'ivʉ'ena cuaa repaʉ nʉkacheja ti'jñeñena ũhañu chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cuaa ũhañu chiinareta'ni repavʉ'ere pãipi timusorena cuaacu'aasomʉ repanare. Cuaacu'akʉna repavʉ'e sẽ'sevʉna mʉa ũcuachejapi coje racho ũcuacojepi repaʉ ũhikãapi pãi ũcuanʉko nʉkacheja chenevʉna Jesús ti'jñeñena caso ũhaasome repana jũ'iva'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Iva'ʉre Jesús vasoja'mʉ”, chini cuasajʉ caso ũharena Jesús repana cuasasi'e ña i'kaasomʉ repava'ʉre. —Asarepajʉ̃'ʉ mʉ'ʉ. Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ —chiniasomʉ Jesús repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jã'aja'ñe i'kaʉna asa judíopãi che'chonana'me fariseopãi ija'che cuasaasome: “¿Je'se pa'iʉna ikʉ jã'aja'ñe i'kakʉ? Dios asacuheche'te i'kamʉ ikʉ jã'a. Diochi'aa'mʉ pãi cu'ache cho'oche tʉnokaikʉ”, chiijʉ cuasaasome. ");
INSERT INTO coe_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jã'aja'ñe cuasajʉna Jesús repana cuasache'te ña masi ija'che i'kaasomʉ repanare: —¿Je'se pa'iʉna mʉsanʉkona jã'aja'ñe cuasache? ");
INSERT INTO coe_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chʉ'ʉ ikʉre, “Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ”, chiisi'ere asa, “Joreʉ'mʉ ikʉ. Pãi jã'aja'ñe cho'omasinajẽ'e peomʉ”, chiijʉ cuasame. Jã'ata'ni chʉ'ʉpi ikʉre, “Vʉni, nʉka ku'ijʉ̃'ʉ”, chikʉna vʉni nʉkakʉna ñani, “Jorema'kʉa'mʉ Jesús. Repaʉ i'kasi'e ũcuarepa cho'omasimʉ”, chiijacosome mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Chʉ'ʉ, pãire ja'me paaʉ chini Dios Raosi'kʉ chejare pa'iʉ pãi cu'ache cho'oche tʉnoñena'me pãi vasoche cho'omasiʉ pa'iche'te mʉsanʉkonapi ña masia'jʉ chini vasokaija'mʉ chʉ'ʉ ikʉre —chiniasomʉ Jesús repanare. Chini nʉka ku'imava'ʉre i'kaasomʉ repaʉ. —Vʉni mʉ'ʉ ũhisikãa mini vʉ'ena co'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chikʉna pãi ũcuanʉko ñajʉ'te vʉni repaʉ ũhisikãa mini vʉ'ena co'isoasomʉ repaʉ. Dios repaʉ'te cho'okaisi'ere cuasakʉ pojokʉ, “Peore masikʉ'mʉ Dios”, chiiʉ co'iasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jã'aja'ñe cho'oʉna pãi ũcuanʉko ña jñanoasome. Ũcuaja'che, “Dios peore masikʉ'mʉ”, chiijʉ pojoasome repana. Pojonata'ni vajʉchʉjʉ ija'che i'kaasome repana: —Irʉmʉ mai ñama'ñere re'oja'che cho'oche'te ñame mai —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jã'aja'ñe cho'o pi'ni eta pãi chʉ̃'ʉnare kuri kookaikʉ'te, Levire ñaasomʉ Jesús. Kuri kookaina pa'ivʉ'e ñu'ikʉni ña ija'che i'kaasomʉ Jesús repaʉ'te Levire: —Rani chʉ'ʉni ja'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chikʉna asa, “Jaʉ”, chini vʉni repaʉ paasi'e cu'amajñarʉã peore jo'kaso Jesuna'me saniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ũcuarʉmʉ Leví Jesuni pojokʉ pãire soniasomʉ ãure ãura chini. Sokʉna kuri kookainana'me chekʉna pãi rʉa jainʉko mʉa kaka pʉʉasome repavʉ'e. ");
INSERT INTO coe_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ñu'ijʉ fariseopãina'me judíopãi che'chona Jesús neenani ke'rejʉ, —¿Je'se pa'iʉna mʉsanʉkona kuri kookainana'me cu'ache pa'inare ja'me ãu ãiñe? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chitena asa Jesús ija'che i'kaasomʉ repanare: —Pãi vajʉna ʉ̃ko cho'oche chiima'me. Jũ'iva'nata'ni ʉ̃ko cho'oche chiime. ");
INSERT INTO coe_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chʉ'ʉ ũcuaja'che pãi, “Re'onaa'me chʉkʉna”, chiinani, “Cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉma'mʉ icheja cheja. Pãi, “Cu'ache pa'inaa'me chʉkʉna”, chiiva'narechi'a, “Mʉsanʉkona cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ”, chisa chini cajesi'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ũcuarʉmʉ repana fariseopãi ija'che i'kaasome Jesure: —Juan neena si'arʉmʉ te'eñoã ãu ãima'ñe pa'ijʉ Dioni sẽeme. Chʉkʉna neena ũcuaja'che cho'onaa'me. Mʉ'ʉ neenata'ni jã'aja'ñe cho'oma'me —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chitena Jesús i'kaasomʉ repanare. —Pãi, romi vejani majapãina'me repanare kueñe pa'inare peore soni chi'i ãu ãime. Romi vejakʉ pa'iʉna ãu ʉ̃secu'amʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Na'a pa'isirʉmʉna repaʉ'te chekʉnapi sasõjanaa'me chekʉchejana. Jã'arʉmʉta'ni repaʉni oijʉ te'eñoã ãu ãimairo pa'ijanaa'me repana. Chʉ'ʉ neena ũcuaja'che na'a pa'isirʉmʉ Dioni sẽejʉ te'eñoã ãu ãimairo pa'ijanaa'me chʉ'ʉ peorʉmʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Reparʉmʉ pãi te'ena aperʉmʉ che'chosi'ena'me mama che'choche ũcuapa'rʉva cuasañu chini aperʉmʉ che'chosi'e ũhacuheasome. Chekʉnata'ni mama che'choche asacuheasome. Jã'ajekʉna Jesús repanani chʉ'vakʉ ija'che i'kaasomʉ: —Aikãarʉji che'resõru mamase'rechoji che're aikãana põ juhamanaa'me pãi. Jã'aja'ñe juha pi'ni choaru aikãarʉ mamase'recho põ juhasikãarʉjekʉ rueni ji'rosõʉna na'a ʉjacoje che'remʉ. Ũcuachi'a mamase'rechoji aikãana põ juharu re'oja'che ñoma'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ũcuachi'a pĩsi ʉche cono mama cho'oni va'iva'na ca'nituru aituruna ro'vemanaa'me pãi. Aituruna ro'veru conopi kosani saʉ che'resõ turujẽ'e cho'osõkʉ pĩsi ʉche conojẽ'e ũcuaja'che cho'osõmʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jã'ajekʉna pãi pĩsi ʉche cono mama cho'oni turu mamaturuna ro'veme. Mamaturuta'ni che'remairo rupʉ saʉmʉ. Jã'ajekʉna cono kosa ñu'iʉ ja'ñʉsõma'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ũcuaja'che pãi aperʉmʉ cho'osi'ere cono ũku ñani mama cho'osi'e ũkucuheme, “Aperʉmʉ cho'osi'epi na'a sãija'imʉ”, chini cuasajʉ —Jã'aja'ñe chʉ'vaasomʉ Jesús repanare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ũcuarʉmʉ Jesús pʉaumucusena repaʉ neenana'me trigo chiopi saijʉ paniasome. Saijʉ repaʉ neena trigocha'charʉã pura ãniasome. ");
INSERT INTO coe_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jã'aja'ñe cho'ojʉna ña fariseopãi i'kaasome repanare. —¿Je'se pa'iʉna mʉsanʉkona pʉaumucuseta'ni cho'oche cho'oche? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Chitena Jesús i'kaasomʉ repanare. —¿Aperʉmʉ pa'isi'kʉ David cho'osi'ere kʉajʉ mai aipãi tocha jo'kasi'e ñamanaa'ñe mʉsanʉkona? Ija'che kʉamʉ repa: David, repaʉ'te ja'me pa'inana'me ãucuhakʉna Dios vʉ'ena kaka Diopi pojoa'kʉ chini judío phairipãi tʉosi'ere pã mini ãiʉ repaʉ'te ja'me pa'inare ãukʉ ãniasomʉ. Dios, phairipãichi'a ãijʉ̃'ʉ chiisi'ere ãnisõasomʉ repaʉ David, chiimʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chini, —Chʉ'ʉni Dios Raosi'kʉni pʉaumucusena cho'oche'te chʉ̃'ʉto chʉ̃'ʉre'omʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na'a pa'isirʉmʉ Jesús pʉaumucusena judíopãi chi'ivʉ'ena kaka che'choasomʉ. Che'choto ũcuavʉ'ere pãiʉ ʉjajʉ̃tʉre cu'ajʉ̃tʉrʉ paakʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Repavʉ'e chi'isina judíopãi che'chonana'me fariseopãi Jesure rʉa pãiñaasome. “¿Jesús iumucuse pʉaumucusena cu'ajʉ̃tʉrʉ paakʉ'te vasoja'ʉ?”, chini ñu'ijʉ ñaasome repana. Repaʉji cho'oʉna ña repaʉni cu'ache i'kañu chini cha'aasome repana. ");
INSERT INTO coe_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Repana cuasache masikʉta'ni cu'ajʉ̃tʉrʉ paakʉ'te ija'che i'kaasomʉ Jesús: —Vʉni rani pãi chenevʉ'te nʉkajʉ̃'ʉ —chiniasomʉ. Chikʉna vʉni sani nʉkaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ũcuarʉmʉ Jesús i'kaasomʉ repanare. —Mʉsanʉkonani chʉ'o sẽniasara. Pʉaumucujñana chekʉnani re'oja'che cho'okaito, ¿re'okʉ? Jã'apãani, ¿cu'ache cho'ore'okʉ? Ũcuachi'a, ¿chekʉnare vasore'okʉ? Jã'apãani, ¿vanisõre'okʉ repanare? —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chini ũcuanʉkore chʉri ña, cu'ajʉ̃tʉrʉ paakʉ'te ija'che i'kaasomʉ: —Mʉ'ʉ jʉ̃tʉ saʉjʉ̃'ʉ —chiniasomʉ. Chikʉna saʉasomʉ. Saʉʉna repajʉ̃tʉ teana re'ojajʉ̃tʉ care'osoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jã'aja'ñe cho'oʉna ña Jesure rʉa pe'ruche pe'ruasome repana. Pe'rujʉ, “¿Je'se mai jã'ʉre cho'ojanaa'ñe?”, chini sãiñechi'a cutuasome repana. ");
INSERT INTO coe_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na'a pa'isirʉmʉ Jesús aikũtina mʉniasomʉ, Dioni sẽsa chini. Mʉni te'eñami sẽeʉ ñataasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ñataʉna repaʉ'te chiinare soni rao docerepanarechi'a chẽa ija'che i'kaasomʉ repaʉ: “Dios chʉ'ore sani chʉ'vajʉ paapʉ chini saoja'mʉ chʉ'ʉ mʉsanʉkonare”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iea'me repaʉ chẽasina mami: Simonre chẽa chekere mami ve'oasomʉ repaʉ. Pedro'te ve'oasomʉ. Jã'ajekʉna Simón Pedro ve'easomʉ repaʉ. Andrere repaʉ Simón Pedro cho'jeʉ'te ũcuaja'che chẽaasomʉ repaʉ. Ũcuaja'che Santiago'te Juanre, Felipe'te, Bartolomere chẽaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ũcuaja'che Mateo'te, Tomare chẽaasomʉ. Chekʉre Santiago'te Alfeo mamakʉ'te ũcuaja'che chẽaasomʉ. Chekʉre ũcuaja'che Simonre, cananistapãi ja'me cho'oche cho'okaikʉ'te chẽaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ũcuaja'che Judare, chekʉ, Santiago mamakʉ'te chẽaasomʉ. Ũcuaja'che Judas Iscariote'te chẽaasomʉ. Na'a pa'isirʉmʉ repaʉ Judas Iscariote Jesuni cu'ache cho'oa'jʉ chini chekʉnani jo'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ũcuarʉmʉ Jesús aikũti pa'isi'kʉpi repaʉ neenana'me caje re'ojajaevana canʉkato repaʉ'te chiina, rʉa jainʉko paniasome. Pãi chekʉna ũcuaja'che rʉa jainʉko paniasome. Jerusalén vʉ'ejoopo cana, Judea cheja cajoopoã cana, ũcuachejña po'ña canana'me Tiro vʉ'ejoopo canana'me Sidón vʉ'ejoopo chiara rʉ'tʉva cajoopoã cana paniasome repana. Jã'achejña pa'inapi Jesús i'kache'te asañu chini raniasome repana. Jũ'iva'na repaʉni vasocojñoñu chini ratena vasoasomʉ Jesús repava'nare. ");
INSERT INTO coe_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ũcuaja'che vatire paajʉ jũ'iva'na vasocojñoasome. ");
INSERT INTO coe_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesure rʉa masiʉjekʉna jũ'iva'na rupʉ repaʉni chẽse vajʉasome. Jã'ajekʉna pãi jũ'iva'na ũcuanʉko chẽse vajʉñu chiniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ũcuarʉmʉ Jesús repaʉ neenani ñakʉ i'kaasomʉ. —Chʉova'na pa'inaa'me mʉsanʉkona. Jã'ata'ni mʉsanʉkonani Diopi paakʉna pojojʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ũcuachi'a chura ãucuhava'na pa'ime mʉsanʉkona. Jã'ata'ni pojojʉ pa'ijʉ̃'ʉ. Na'a pa'isirʉmʉ ãu karama'ñe paajanaa'me mʉsanʉkona. ’Ũcuachi'a chura oijʉ sʉmava'na pa'ime mʉsanʉkona. Jã'ata'ni pojojʉ pa'ijʉ̃'ʉ. Na'a pa'isirʉmʉ pojojʉ sojʉ pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Chura pãi mʉsanʉkonare cuheme, chʉ'ʉni Dios Raosi'kʉni cuasajʉna. Cuhejʉ kueñe pa'ima'me. Ũcuachi'a mʉsanʉkonare cu'ache i'kame repana. Ũcuachi'a mʉsanʉkona pa'iche'te chekʉnani kʉani joreme repana, “Cu'ache pa'inaa'me jã'ana”, chiijʉ. Jã'ata'ni pojojʉ pa'ijʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pãi cu'ache cho'ojanaa'me mʉsanʉkonare. Jã'ata'ni cha'ijʉ pojojʉ̃'ʉ. Na'a pa'isirʉmʉ Dios pa'ichejare sani pa'ijʉna rʉa re'oja'chere ĩsija'mʉ Dios mʉsanʉkonare. Aperʉmʉ ũcuaja'che mʉsanʉkonare cuhena aipãipi cu'ache cho'oasome Dios chʉ'o kʉakaisinare —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Chini pãi ũcuanʉkore jo'e i'kaasomʉ repaʉ. —Chura mʉsanʉkona kurire rʉa paajʉ, “Diore chiima'me chʉkʉna”, chini cuasajʉ pojojʉ pa'ime. Icheja cheja pa'irʉmʉchi'a pojojʉ pa'ime mʉsanʉkona. Jã'ata'ni mʉsanʉkona jũnisõsirʉmʉ cu'ache cuasasi'e ro'i cu'ache ti'jñeʉna oijʉ pojomanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Mʉsanʉkona te'ena ãu karama'ñe si'arʉmʉ chajiche ãijʉ pojojʉ pa'ime. Jã'ata'ni na'a pa'isirʉmʉ ãucuhava'na pa'ijanaa'me mʉsanʉkona, Diore cuasamanesi'e ro'i. ’Ũcuachi'a mʉsanʉkona te'ena si'arʉmʉ sojʉ pa'ime. Jã'ata'ni na'a pa'isirʉmʉ sʉmaʉna oijʉ pa'ijanaa'me mʉsanʉkona, Diore cuasamanesi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Mʉsanʉkonapi chʉ'ʉ chʉ'ore rũhiñe kʉato re'oja'chere ʉ̃sejʉ cu'ache i'kajanaa'me pãi mʉsanʉkonare. Rũhiñe kʉama'tota'ni re'oja'che i'kajanaa'me. Jã'ajekʉna pãipi mʉsanʉkonani si'areparʉmʉ re'oja'che cututo Dios chʉ'o rũhiñe kʉamanajejʉna cu'ache ti'jñeja'mʉ mʉsanʉkonare. Mʉsanʉkonare re'oja'che cutuna aipãipi aperʉmʉ jorejʉ, “Dios chʉ'o kʉakainaa'me chʉkʉna”, chiisinare re'oja'che cutujʉ paniasome —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Chini Jesús jo'e i'kaasomʉ repanare. —Mʉsanʉkonare chʉ'ʉ i'kache asa jachamanare ija'che chʉ'vamʉ chʉ'ʉ: Mʉsanʉkonare cuhenare oijʉ pa'ijʉ̃'ʉ. Re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","’Ũcuachi'a, “Mʉsanʉkonare cu'ache ti'jñea'kʉ”, chiinare sãiñe cu'ache i'kama'ñe, “Re'oja'che ti'jñea'kʉ mʉsanʉkonare”, chiijʉ̃'ʉ repanare. Ũcuachi'a, mʉsanʉkonare cu'ache cho'onare Dioni re'oja'chere sẽekaijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chekʉpi pe'rukʉ mʉ'ʉ vachoturupʉna asi charato jo'e chekʉkã'ko ʉ̃semanejʉ̃'ʉ jo'e charaa'kʉ. Ũcuachi'a chekʉpi mʉ'ʉ sẽ'sevʉ ju'ikãare tʉasõru chekʉkãare rupʉ ĩsijʉ̃'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ũcuachi'a mʉ'ʉ paamajñarʉãre ũcuaʉakʉji sẽeto rupʉ ĩsijʉ̃'ʉ repaʉ'te. Ũcuachi'a chekʉpi mʉ'ʉ paamajñarʉãre tʉasõru, “Co'chojʉ̃'ʉ chʉ'ʉre”, chiimanejʉ̃'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mʉsanʉkona chiiche chekʉnapi cho'okaiche rʉa chiime mʉsanʉkona. Jã'ajekʉna chekʉnare ũcuaja'che mʉsanʉkona chiiche'te re'oja'chere cho'okaijʉ pa'ijʉ̃'ʉ. Mʉsanʉkonare re'oja'che cho'oma'tojẽ'e ũcua re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Pãi cu'ana repanare oinarechi'a oijʉ pa'inaa'me. Jã'ajekʉna mʉsanʉkonapi mʉsanʉkonare oinarechi'a sãiñe oito pojomaneja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pãi cu'ana repanare re'oja'che cho'okainarechi'a sãiñe re'oja'che cho'okaijʉ pa'ime. Jã'ajekʉna mʉsanʉkonapi mʉsanʉkonare re'oja'che cho'okainarechi'a sãiñe re'oja'che cho'okaito pojomaneja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pãi cu'ana ũcuajanare kuri prestani, “Co'chojanaa'me ina”, chini prestame kuri. Jã'ajekʉna mʉsanʉkonapi co'choche cuasonarechi'a kurire prestato pojomaneja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jã'ajekʉna mʉsanʉkonare cuhenare oijʉ pa'ijʉ̃'ʉ. Ũcuaja'che re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ repanare. Mʉsanʉkonani ũcuaʉache'te prestañu chiito co'chochejẽ'e cuasama'ñe prestajʉ̃'ʉ repanare. Jã'aja'ñe cho'ojʉ pa'ito Dios re'oja'chere ĩsija'mʉ mʉsanʉkonare re'oja'che cho'osi'e ro'i. Mʉsanʉkonare cuhenani re'oja'che cho'ojʉ pani Dios Cʉnaʉmʉ Pa'ikʉ cho'ocheja'che re'oja'che cho'ojanaa'me mʉsanʉkona. Dios Repaʉ cho'okaiche, “Re'orepamʉ”, chiimanarejẽ'e re'oja'che cho'okaiʉ pa'ikʉ'mʉ. Cu'ache cho'onare ũcuachi'a re'oja'che cho'okaikʉ'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mai Ja'kʉ Dios pãi ũcuanʉkore oicheja'che chekʉnare pãi oijʉ pa'ijʉ̃'ʉ mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ repanare: —Chekʉna cu'ache cho'oche ñani, “Cu'ache pa'inaa'me mʉsanʉkona”, chiijʉ ke'remanejʉ̃'ʉ. Jã'aja'ñe ke'rema'to Dios ũcuaja'che mʉsanʉkona cu'ache cho'oche ñakʉta'ni i'kamaneja'mʉ. Ũcuachi'a mʉsanʉkonapi chekʉna cu'ache cho'oche'te ñani, “Cu'ache cho'osi'e ro'i, ro'iche pa'imʉ mʉsanʉkonare”, chiijʉ ke'remanejʉ̃'ʉ repanare. Jã'aja'ñe i'kama'to Dios ũcuaja'che mʉsanʉkona cu'ache cho'oche ñakʉta'ni, “Cu'ache cho'osi'e ro'i, ro'iche pa'imʉ mʉsanʉkonare”, chiimaneja'mʉ. Ũcuachi'a chekʉna cu'ache cho'oche ñani jo'e cuasamanejʉ̃'ʉ repana cho'osi'e. Jo'e cuasama'to Dios ũcuaja'che mʉsanʉkona cu'ache cho'oche ñakʉta'ni jo'e cuasamaneja'mʉ mʉsanʉkona cho'osi'e. ");
INSERT INTO coe_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mʉsanʉkonapi ũcuaʉamajñarʉã paani, chekʉnare rupʉ ĩsijʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oto Dios ũcuaja'che mʉsanʉkonare re'oja'chere ĩsija'mʉ. Mʉsanʉkona chekʉnare cu'amajñarʉã turu ʉjaturuna timuñe maña ĩsisi'eja'che ĩsija'mʉ Dios mʉsanʉkonare. Mʉsanʉkona, chekʉnani põsere ĩsiñu chini kuẽkue ĩsisi'eja'che kuẽkue ĩsija'mʉ Dios mʉsanʉkonare. Mʉsanʉkonapi chekʉnani jmamajñarʉã kuẽkue ĩsito Dios ũcuaja'che jmamajñarʉã ĩsija'mʉ mʉsanʉkonare. Jã'ata'ni mʉsanʉkonapi chekʉnani cajejaiche ĩsito Dios ũcuaja'che cajejaiche ĩsija'mʉ mʉsanʉkonare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","I'ka pi'ni repanani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ repaʉ: —Na'ava'ʉ chekʉre ũcuaja'che na'ava'ʉni juha sacu'amʉ. Sani ñamava'najejʉ ũcuatʉrʉpʉ cojena tuã'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Utija'o che'chena repanare che'chonare na'a rʉa masima'me. Jã'ata'ni utija'o peore che'che pi'nini repanare che'chona masicheja'che masijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Pãiʉ repaʉ ñakova'te chĩ'camaka ʉjamaka paakʉ'teta'ni cuasomaneasomʉ. Cuasama'kʉta'ni ja'me pa'ikʉ ñakova pa'imakarʉ jmamakarʉta'ni ñaasomʉ repaʉ. Rʉa tĩiñea'me jã'a. Mʉsanʉkona ũcuaja'che tĩiñe cho'ome. Rʉa cu'ache cho'onata'ni mʉsanʉkona cu'ache cho'oche cuasama'me. Jã'ata'ni chekʉnapi jmamakarʉ cu'ache cho'oche ñani rʉa cuasanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ũcuaja'che pãiʉ repaʉ ñakova'te chĩ'camaka ʉjamaka paakʉta'ni tʉnoma'ñe paamʉ. Jã'ata'ni chekʉpi ñakova'te chĩ'camakarʉ jmamakarʉ paache ñanita'ni, “Raijʉ̃'ʉ. Mʉ'ʉ ñakova pa'imakarʉ chĩ'camakarʉ'te tʉnokasa”, chiimʉ. Rʉa tĩiñea'me jã'a. Mʉsanʉkona ũcuaja'che rʉa tĩiñe cho'ome. Rʉa cu'ache cho'onata'ni mʉsanʉkona cu'ache cho'oche ũhasõma'ñe pa'inata'ni, chekʉna jmamakarʉ cu'ache cho'oche ñani, “Mʉsanʉkona cu'ache cho'oche ũhasõjʉ̃'ʉ”, chiinaa'me. Jã'aja'ñe cho'oto cu'amʉ. Sẽ'sevʉchi'a re'oja'cheja'che ñoñe pa'inaa'me. Pãiʉ ñakova chĩ'camaka ʉjamaka paakʉ repamaka tʉnosirʉmʉ na'a masi ñokʉna chekʉ chĩ'camakarʉ tʉnokaire'omʉ. Ũcuaja'che charo mʉsanʉkonapi cu'ache cho'oche'te ũhasõ re'oja'che pa'ijʉ chekʉnare mʉsanʉkona i'kache'te ũcuarepa cho'ojʉ chekʉnani jã'aja'ñe chʉ'vato re'omʉ. Jã'ata'ni ũcuarepa cho'omanapi chekʉnani chʉ'vato cu'amʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ũcuarʉmʉ Jesús pãire jo'e chʉ'vaasomʉ. —Sũkiñʉã ãiñe kʉ̃iñʉã koka pa'iñʉã sãija'imapʉã kʉ̃ima'mʉ. Ũcuachi'a koka peora'ñʉrʉã sãijapʉã kʉ̃ima'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sũkiñʉã repañʉã kʉ̃isi'ere ãni ña masime pãi repañʉ pa'iche. Miusava higopʉã kʉ̃ima'mʉ. Ũcuachi'a miusava ʉche kʉ̃ima'mʉ. Ʉcheñʉãpi ʉche kʉ̃imʉ. ");
INSERT INTO coe_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pãi ũcuaja'che re'oja'che cuasana re'oja'chere cutume. Ũcuaja'che pãi cu'ache cuasana cu'ache'te cutume. Pãi ũcuanʉko repana rekoñoã cuasache cutunaa'me —chiiʉ chʉ'vaasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ũcuarʉmʉ Jesús jo'e ija'che chʉ'vaasomʉ repanare pãi: —“Chʉkʉna'te Paakʉ'mʉ mʉ'ʉ”, chiime mʉsanʉkona chʉ'ʉre. Jã'aja'ñe i'kanata'ni, ¿je'se pa'iʉna chʉ'ʉ chʉ̃'ʉñe cho'oma'ñe mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pãiʉ chʉ'ʉni rani chʉ'ʉ chʉ̃'ʉñe asa chẽa cho'okʉ pa'iche ija'cheja'chea'me: ");
INSERT INTO coe_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pãiʉ vʉ'ere cho'ora chini cojña cata pa'ichetʉ'ka repa sa'navʉã ũni nʉ'keasomʉ vʉ'ña tuu. Repavʉ'e cho'o pi'nisirʉmʉ oko rʉa ra, vʉ'ejatʉ'ka chiacha ko'sa tĩ'aasomʉ. Ko'sa tĩ'asi'eta'ni rʉa masi cho'osivʉ'ejekʉ tãimaneasomʉ repavʉ'e. ");
INSERT INTO coe_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ũcuachi'a pãiʉ chʉ'ʉ chʉ̃'ʉñe jachakʉ cho'oma'kʉ pa'iche ija'cheja'chea'me: Chekʉ pãiʉ vʉ'ere cho'ora chini cojña rʉa sẽ'serʉã ũni vʉ'ña tuu nʉ'keasomʉ. Vʉ'e cho'o pi'nisirʉmʉna oko rʉa ra, vʉ'ejatʉ'ka chiacha ko'sa tĩ'aasomʉ. Ko'sa tĩ'aʉna masi cho'omanesivʉ'ejekʉ tãnisõasomʉ repavʉ'e —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ũcuarʉmʉ Jesús repanare pãi chʉ'va pi'ni Capernaum vʉ'ejoopona saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Repajoopo sani tĩ'ato Romapãiʉ sõtao cienrepanare chʉ̃'ʉkʉ paniasomʉ. Repaʉ'te cho'oche cho'okaikʉ repaʉ rʉa chiicojñokʉji jũnisopi'raasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Repaʉ sõtao chʉ̃'ʉkʉ jũ'iva'nare Jesús vasoche asasi'kʉjekʉ judíopãi ainare Jesús pa'ichejana saoasomʉ, Jesuni kʉa raorena repaʉ'te cho'oche cho'okaikʉni rani vasoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Jã'aja'ñe i'ka saoʉna Jesús pa'ichejana sani tĩ'a repaʉ'te rʉa i'kaasome repana. —Sõtao chʉ̃'ʉkʉ mʉ'ʉre soimʉ, sani repaʉ'te cho'oche cho'okaikʉni vasokaaʉ chini. Mai judíopãi chi'ivʉ'ere chʉkʉnapi cho'oa'jʉ chini kookaisi'kʉa'mʉ repaʉ. Rʉa re'opãiʉ'mʉ repaʉ sõtao chʉ̃'ʉkʉ. Maire judíopãi oikʉ'mʉ repaʉ. Jã'ajekʉna repaʉ sẽeñe cho'okaijʉ̃'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chitena Jesús ũcuanana'me saniasomʉ. Saijʉ repaʉ vʉ'e kueñe tĩ'ajʉna repaʉ sõtao chʉ̃'ʉkʉ jo'e chekʉnani saoasomʉ repaʉ'te chiinare, —Jesure tijña ija'che i'kakaijʉ̃'ʉ chʉ'ʉre —chiiʉ.— “Chʉ'ʉ mʉ'ʉre Pãi Ũcuanʉkore Paakʉ'te soimʉ. Jã'ata'ni raiʉama'to raimanejʉ̃'ʉ. Chʉ'ʉ rʉa vesʉʉ vʉ'ena mʉ'ʉpi rʉa masiʉji kakache vajʉchʉamʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Chʉ'ʉ rʉa vesʉkʉjekʉ saivajʉchʉsi'kʉa'mʉ mʉ'ʉ pa'icheja. Ija'che pa'ikʉ'mʉ chʉ'ʉ: Chekʉnapi sõtao ainapi chʉ̃'ʉnaa'me chʉ'ʉre. Chʉ'ʉ ũcuaja'che chekʉnare sõtao chʉ̃'ʉkʉ'mʉ. Chʉ'ʉpi sõtaoni te'eʉ'te, ‘Saijʉ̃'ʉ’, chiito saimʉ repaʉ. Ũcuaja'che chekʉre, ‘Raijʉ̃'ʉ’, chiito raimʉ repaʉ. Ũcuachi'a chʉ'ʉre cho'oche cho'okaikʉni ũcuaʉache'te chʉ'ʉpi chʉ̃'ʉto cho'okaimʉ repaʉ. Jã'ajamakarʉchi'a chʉ̃'ʉmasikʉ'mʉ chʉ'ʉ. Mʉ'ʉta'ni peore chʉ̃'ʉmasikʉ'mʉ. Jã'ajekʉna mʉ'ʉpi chʉ'ʉ vʉ'e saima'ñe, ũcua ichejapi chʉ'ʉre cho'oche cho'okaikʉni, ‘Vajʉjʉ̃'ʉ’, chiito vajʉja'mʉ”, chiijʉ̃'ʉ repaʉ'te —chini saoasomʉ repaʉ repanare. Chini saoʉna sani Jesure jã'aja'ñe kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jã'aja'ñe kʉajʉna asa jñano, Jesús repaʉ'te tuhasinani pãire chʉri ña ija'che i'kaasomʉ: —Israelpãi chʉ'ʉre jainʉko cuasanareta'ni te'eʉ'terejẽ'e ikʉ chʉ'ʉre masi cuasacheja'che cuasanare chuta'a tijñama'kʉa'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I'kaʉna asa sõtao chʉ̃'ʉkʉ saosina repaʉ vʉ'ena co'iasome. Co'i tĩ'a ñato repaʉ'te cho'oche cho'okaikʉ jũ'iva'ʉ vajʉsosi'kʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jã'a cho'o pi'nisirʉmʉna Jesupi Naín vʉ'ejoopona saiʉna repaʉ neenana'me pãi jainʉko ja'me saniasome. ");
INSERT INTO coe_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Saijʉ repajoopo kueñe tĩ'ato pãiʉ'te jũ'isiva'ʉni tãñu chini saasome pãi. Va'jeo mamakʉ ũcuate'eʉ pa'isiva'ʉ paniasomʉ repaʉ. Jũ'isiva'ʉ pʉka'kona'me repajoopo cana rʉa jainʉko saniasome. ");
INSERT INTO coe_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Saijʉna jũ'isiva'ʉ pʉka'koni ña oiʉ ija'che i'kaasomʉ Jesús: —Oimanejʉ̃'ʉ mʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chini jũ'isiva'ʉ ũhikãa kueñe tĩ'a ũcuakãana chẽaʉna repava'ʉre sana canʉkaasome. Canʉkarena Jesús jũ'isiva'ʉre ija'che i'kaasomʉ: —Põsʉʉ, vajʉraijʉ̃'ʉ chiimʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesupi jã'aja'ñe i'kaʉna põsʉʉ jũnisosiva'ʉ pa'isi'kʉ vajʉrani vʉni ñu'iʉ chʉ'ore cutuasomʉ. Repava'ʉre vaso pʉka'koni ĩsiasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jã'aja'ñe cho'oʉna ña pãi ũcuanʉko kʉkʉsoasome. “Dios rʉa re'okʉ'mʉ”, chini cuasajʉ ija'che i'kaasome repana: —Ikʉ Dios chʉ'o kʉakʉ, rʉa masiʉji rani maire ja'me pa'imʉ. Maini Israelpãire, Dios neenani re'oja'che cho'okasa chini raisi'kʉa'mʉ ikʉ —chiniasome repana pãi. ");
INSERT INTO coe_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ũcuarʉmʉ pãipi Jesús cho'osi'ere asa chekʉnani kʉarena Judea cheja pa'ina peore repaʉ cho'osi'e asaasome. Judea cheja kueñe pa'ina ũcuaja'che pãipi kʉajʉna repaʉ cho'osi'e asaasome. ");
INSERT INTO coe_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ũcuarʉmʉ Juan repaʉ neenapi Jesús cho'osi'ere repaʉni peore kʉarena te'eka'chapanare soniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Soni rao, “Jesús pa'ichejana sani ija'che sẽniasajʉ̃'ʉ repaʉ'te: ‘¿Dios Raosi'kʉa'ʉ mʉ'ʉ? Mʉ'ʉpi Dios Raomanesi'kʉ pa'ito, ¿Dios Raojaʉni ũcua cha'ajanaa'ñe chʉkʉna?’, chiijʉ̃'ʉ repaʉ'te Jesure”, chini saoasomʉ Juan repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Saoʉna sani Jesure i'kaasome repana. —Juan Pãi Okoro'vekʉji raosi'kʉa'mʉ chʉkʉna'te, mʉ'ʉni chʉ'ore sẽniasaa'jʉ chini. ¿Dios Raosi'kʉa'ʉ mʉ'ʉ? Dios Raomanesi'kʉ pa'ito, ¿Dios Raojaʉni ũcua cha'ajanaa'ñe chʉkʉna? —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ũcuarʉmʉna Jesús pãi ravʉ jũ'iva'nana'me na'ava'nare jainʉkore vasoasomʉ. Ũcuaja'che vati pãi sa'navʉ pa'isinare eto saosokaniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jã'aja'ñe cho'ocuha Jesús Juan raosina sẽesi'e chʉ'o i'kaasomʉ. —Chura mʉsanʉkona Juan pa'ichejana co'i mʉsanʉkona ñasi'ena'me asasi'ere ija'che kʉajʉ̃'ʉ repaʉ'te Juanre: “Pãi na'ana pa'isina ñame chura. Cu'acũ'a paasina re'oja'che nʉka ku'ime chura. Asi ravʉ paasina ũcuaja'che vajʉme. Cãjo asamanesina ũcuaja'che asame chura. Jũnisõsina ũcuaja'che vajʉrani jo'e pa'ime. Chʉova'na pa'iva'na chʉ'ʉ chʉ'vache'te Dios Repaʉ'te cuasanare chẽa paakʉ vati toa uuche ʉ̃seche'te asajʉ pa'ime. ");
INSERT INTO coe_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pãi chʉ'ʉre cuasache jo'kasõma'ñe cuasajʉ pa'ina pojojʉ pa'ijanaa'me”, chiijʉ sa kʉajʉ̃'ʉ repaʉ'te Juanre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan raosina co'isosirʉmʉ Jesús Juan pa'iche'te i'kakʉ ija'che i'kaasomʉ chekʉnare pãi: —¿Je'se pa'ikʉni ñañu chini pãi peocheja sate mʉsanʉkona? ¿Chʉ'chʉsava tutakʉna ñʉ'kuecheja'che repaʉ rekocho na'mi sa'ñekʉ cuasakʉni ñañu chini sate mʉsanʉkona? Jã'aja'ñe cuasama'kʉa'mʉ Juan. ");
INSERT INTO coe_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Jã'aja'ñe pa'ikʉ'te ñañu chini saimaneni, ¿ʉ̃quere ñañu chini sate? ¿Pa'ipãi ju'ikãña ju'ikʉni ñañu chini sate mʉsanʉkona? Pãi, kãña rʉa ro'ikãña ju'ina pa'ipãi vʉ'ñachi'a pa'ime. ");
INSERT INTO coe_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jã'aja'ñe pa'ikʉni ñañu chini saimaneni, ¿ʉ̃quere ñañu chini sate mʉsanʉkona? ¿Dios chʉ'o kʉakʉni ñañu chini sate? Jã'aja'ñe pa'ikʉ'te ñañu chini saisinajejʉ te'erũhiñe cuasame mʉsanʉkona. Repaʉ Juan chekʉnare Dios chʉ'o kʉanare na'a rʉa masi kʉakʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Repaʉ Juan pa'ijachere kʉajʉna aperʉmʉ tocha jo'kasi'e Dios chʉ'o ija'che chiimʉ: Mʉ'ʉ cheja cajejache kʉajaʉni charo saoja'mʉ chʉ'ʉ, pãipi mʉ'ʉ cajejachere asa repana rekoñoãre care'va paapʉ chini, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Asarepajʉ̃'ʉ. Mʉsanʉkonani chʉ'ore jo'e kʉara. Icheja cheja Dios chʉ'o kʉana rʉa masina pa'ime. Jã'ata'ni Juan ũcuanʉkore na'a rʉa masiʉ'mʉ. Na'a pa'isirʉmʉ pa'ijana ũcuachi'a, rʉa vesʉsinata'ni Dios chʉ'ore asa chẽa cuasajʉ Juanre na'a rʉa masijanaa'me, chʉ'ʉ pa'iche peore asasinajejʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jã'aja'ñe i'kakʉna kuri kookainana'me chekʉna pãi ũcuanʉko asaasome. Aperʉmʉ repana, “Dios chʉ̃'ʉsi'e re'oja'chea'me”, chini cuasajʉ Juanre okoro'vecojñoasome. ");
INSERT INTO coe_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jã'ata'ni fariseopãina'me judíopãi che'chona, Dios, “Mʉsanʉkona cu'ache cho'oche ũhasõjʉ̃'ʉ”, chiisi'e jachaasome. Dios chʉ̃'ʉñe'te jachajʉ Juanre okoro'vecojñocuheasome repana. ");
INSERT INTO coe_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ. —Pãi irʉmʉ cana, ¿keeja'cheja'chea'che? ¿Repana pa'iche'te kʉara chini je'se kʉaja'che chʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chʉ'ʉpi ñato mʉsanʉkona irʉmʉ cana ija'che pa'ime: Jeerʉmʉ chĩi ãu ĩsichejare ñu'ijʉ ũcuajanani, “Apeñu”, chini soniasome. Chekʉnapi apecuhejʉna ija'che i'kaasome repana: “Chʉkʉna juhivʉã juhito ujacha'icuheme mʉsanʉkona. Ũcuachi'a chʉkʉna apejʉ jũ'isinare tãrʉmʉ ujacheja'che sʉma'ñe ujato ja'me ujacuheme mʉsanʉkona. Chʉkʉnani cuhejʉ pojoma'me mʉsanʉkona”, chiniasome repana chĩi. ");
INSERT INTO coe_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Repana chĩi ũcuajanare cuhecheja'che cuheme mʉsanʉkona chʉkʉna'te, Juanna'me chʉ'ʉre. Repaʉ Juan Pãi Okoro'vekʉ rani pa'iʉ Dioni sẽekʉ te'eñoã ãu ãima'ñe pa'iʉ, conojẽ'e ũkuma'ñe pa'iʉna ña, “Vatini paakʉ vẽ'veʉ'mʉ Juan”, chiijʉ cuhenaa'me mʉsanʉkona repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chura chʉ'ʉpi Dios Raocojñosi'kʉpi rani pa'iʉ si'aumucujña ãu ãiʉ ũkukʉna ña, “Ãi aia'mʉ mʉ'ʉ. Cono ũku aia'mʉ mʉ'ʉ. Ũcuachi'a pãi cu'ache pa'inana'me pãi chʉ̃'ʉnare kuri kookainare oiʉ pa'ikʉ'mʉ mʉ'ʉ”, chiijʉ cuheme mʉsanʉkona chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pãi rũhiñe cuasana, “Dios chʉ̃'ʉñe re'oja'chea'me. Peore masikʉ'mʉ Repaʉ”, chiijʉ cuasame —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ũcuarʉmʉ fariseopãiʉ Simón Jesuni ãure ãura chini soniasomʉ. Sokʉna repaʉ vʉ'ena mʉa kaka ãure ãsa chini pʉʉ ñuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Reparʉmʉ romio, cu'ache pa'iko ũcuajoopo'te paniasomo. Jesús fariseopãiʉ vʉ'ena ãu ãsa chini mʉasi'ere asa, okoma'ñatʉopʉ alabastroji cho'ositʉopʉ mini ũcuavʉ'ena mʉaasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mʉa kaka Jesure kueñe nʉkako oiona Jesús cũ'ana meniasomʉ repao oni meoñe. Mekʉna repao rañapaji repao oni meosi'e tʉ'neso chũsu pojo, okoma'ñapi ro'veasomo repao repacũ'a. ");
INSERT INTO coe_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jã'aja'ñe cho'okona ña fariseopãiʉ Jesure soisi'kʉ ija'che cuasaasomʉ: “Ikʉ Jesús, Dios chʉ'o kʉakaikʉ pani repaʉ'te chẽako pa'iche masira'amʉ, ‘Cu'ache pa'iko'mo jã'o’, chini. Masini cuhera'amʉ repao cho'oche”, chiiʉ cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jã'aja'ñe cuasakʉna Jesús i'kaasomʉ repaʉ'te. —Simón, chʉ'o i'kara chiimʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ. Chikʉna, —Jaʉ, i'kajʉ̃'ʉ. Asara, Masiʉ —chiniasomʉ Simón repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chikʉna Jesús ija'che i'kaasomʉ: —Pãi te'eka'chapana ũcuate'eʉ'te põsero'i paaasome. Te'eʉ quinientos denario kuri põsero'i paaasomʉ. Chekʉ cincuenta denario põsero'i paaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Põsero'i paava'nata'ni kurire peojʉ ro'imaneasome repava'na. Ro'imanareta'ni repanare kuri prestasi'kʉ, “Põsero'i peome mʉsanʉkona chʉ'ʉre”, chiniasomʉ repanare. Repaʉ jã'aja'ñe i'kasirʉmʉ, mʉ'ʉ cuasato, ¿kaʉpi repanare kuri prestasi'kʉre na'a rʉa chiikʉ? —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chikʉna i'kaasomʉ repaʉ. —Na'a rʉa põsero'i paasi'kʉpi na'a rʉa chiicosomʉ repaʉ'te —chiniasomʉ repaʉ. Chikʉna, —Ũcuarepaa'me jã'a. Rũhiñe i'kamʉ mʉ'ʉ —chiniasomʉ Jesús repaʉ'te Simonre. ");
INSERT INTO coe_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chini repaʉ cũ'a choasi'koni romioni chʉri ñakʉ Simonre jo'e ija'che i'kaasomʉ repaʉ: —¿Iko chʉ'ʉre re'oja'che cho'okaisi'e ñamaneʉ mʉ'ʉ? Mʉ'ʉ vʉ'e mʉta kakasi'kʉreta'ni chʉ'ʉ cũ'a choajache oko ĩsimanesi'kʉa'mʉ mʉ'ʉ. Ikota'ni repao oni meoñeji chʉ'ʉ cũ'a choa pi'ni repao rañapaji tʉ'nesõkaisi'koa'mo chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ũcuachi'a mʉ'ʉ chʉ'ʉre chũsu pojomanesi'kʉa'mʉ. Ikota'ni chʉ'ʉ cũ'are chuta'a cuhama'ñe chũsuko pa'imo. ");
INSERT INTO coe_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ũcuachi'a chʉ'ʉ sĩjopʉ u'chape'era'ka rokaimanesi'kʉa'mʉ mʉ'ʉ. Ikota'ni chʉ'ʉ cũ'ana okoma'ña rokaisi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ikore rʉa cu'ache cho'osi'koreta'ni repao cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ. Chʉ'ʉpi jã'aja'ñe cho'okaiʉna chʉ'ʉre rʉa cuasamo iko. Jã'ata'ni chekʉna pãi, repana cu'ache cho'osi'e jmamajñarʉãre chʉ'ʉpi tʉnosõkatu jmamakarʉ cuasame chʉ'ʉre —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chini repao'te i'kaasomʉ. —Mʉ'ʉ cu'ache cho'osi'e tʉnosõmʉ chʉ'ʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ chʉ'ʉ —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jã'aja'ñe i'kaʉna asa ãu ãi soicojñosina sãiñechi'a ija'che i'kaasome: —¿Keeja'iʉ'ʉ ikʉ? Rʉa si'ache cho'omʉ. Pãi cu'ache cho'ochejẽ'e tʉ'nesõkaimʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chitena repao'te jo'e i'kaasomʉ repaʉ. —Chʉ'ʉni cuasakona mʉ'ʉ cu'ache cho'oche tʉnosõkaisi'kʉjekʉ vati toa uuche ʉ̃seja'mʉ chʉ'ʉ mʉ'ʉre. Sani re'oja'che pa'ijʉ̃'ʉ mʉ'ʉ —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jã'a cho'o pi'nisirʉmʉ Jesús vʉ'ñajoopoã si'ajoopoã ku'iʉ Dios chʉ'o re'oja'chere pãi cu'ache cho'oche ũhasinare Dios chẽa paache'te chʉ'vakʉ paniasomʉ, repaʉ neena docerepanana'me ku'iʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Romiva'na ũcuachi'a ja'me kuniasome. Aperʉmʉ Jesús repanare romiva'nare si'ache jũ'inani vasoasomʉ. Chekʉnare vatire paajʉna eto saosokaniasomʉ repaʉ. Repana mamia'me ie: María ja'me kuniasomo. María mami cheke Magdalenaa'mo, aperʉmʉ sieterepanare vati etocojñosi'ko. ");
INSERT INTO coe_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cuza rʉ̃jo Juana ũcuaja'che ja'me kuniasomo. Repaʉ Cuza Herode'te cho'oche cho'okainare chʉ̃'ʉkʉ paniasomʉ. Susana ũcuaja'che ja'me kuniasomo. Chekʉna romi ũcuaja'che rʉa jainʉko ja'me kuniasome, Jesús chʉ'vache'te asajʉ. Repaʉ'te Jesure repana paamajñarʉãpi kuirajʉ kuniasome repana romi, repaʉ neenare ũcuachi'a. ");
INSERT INTO coe_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ũcuarʉmʉ Jesupi ku'iʉ chʉ'vakʉna pãi jainʉko si'achejña pa'ijoopoã pa'inapi ñañu chini eta chi'iasome. Chi'irena repanani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ Jesús: ");
INSERT INTO coe_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Pãiʉ trigo'te chu'chura chini chiona saniasomʉ. Sani tĩ'a pachu ku'iʉ chu'chukʉna trigocaã te'era'karʉã ma'ana tuã'tuaasomʉ. Ma'ana tuã'tuaʉna repara'karʉã pãipi cha'caasome. Jã'ajekʉna pĩ'ava'napi rani ãkuesõasome repara'karʉã. ");
INSERT INTO coe_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chekʉra'karʉãta'ni cata pa'ichejana tuã'tua na'mi aineesi'eta'ni okopi peokʉna phã'pha jũnisõasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Chekʉra'karʉã miu pa'ichejana tuã'tua miuna'me aineeʉna miupi ju'je vẽasõasomʉ repara'ñʉrʉã. ");
INSERT INTO coe_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chekʉra'karʉãta'ni re'oja'che cha'o pa'ichejña tuã'tuasira'karʉãjekʉ re'oja'che ainee ju'a ñaniasomʉ. Te'era'karʉ aineesi'ñʉ te'echa'chava cienrepara'karʉã pa'icha'cha ju'a ñaniasomʉ —chiniasomʉ Jesús. Chini ʉjachʉ'opi jo'e i'kaasomʉ repaʉ. —Chʉ'ʉ chʉ'vache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jã'aja'ñe cuasakʉ kʉa pi'niʉna asa, —¿Ʉ̃quere chʉ'vakʉ jã'aja'ñe cuasakʉ kʉakʉ mʉ'ʉ? —chiniasome repaʉ neena. ");
INSERT INTO coe_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chitena repanare ija'che i'kaasomʉ repaʉ: —Mʉsanʉkonare chʉ'ʉ neenajejʉna Diopi ʉ̃semaʉna Repaʉchi'a masiche te'erũhiñe kʉamʉ chʉ'ʉ, masi asaa'jʉ chini. Jã'ata'ni chekʉnare chʉ'ʉre cuasacuhenare Diopi ʉ̃sekʉna Repaʉchi'a masiche cuasakʉ kʉamʉ chʉ'ʉ, masi asamanea'jʉ chini. Ñanata'ni ñamanesina pa'icheja'che pa'ijanaa'me repana. Ũcuaja'che asanata'ni asavesʉjanaa'me repana —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare. —Chʉ'ʉ cuasakʉ kʉasi'e jo'e ũcuare te'erũhiñe kʉaja'mʉ chʉ'ʉ mʉsanʉkonare. Ija'chea'me jã'a: Trigo chu'chuna chio si'acachio ku'ijʉ chu'chume. Dios chʉ'o chʉ'vana ũcuaja'che chejña si'achejña ku'ijʉ Dios chʉ'o pãi ũcuanʉkore chʉ'vame. Trigo chu'chucheja'chea'me Dios chʉ'o chʉ'vache. ");
INSERT INTO coe_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Trigora'karʉã te'era'karʉã ma'ana tuãni chejapi rʉarepa jʉjakʉna kakama'mʉ. Trigocaã chu'chusicaã chejapi rʉarepa jʉjakʉna kakama'ñeja'ñe pãi te'enare repana rekoñoã Dios chʉ'o kakama'mʉ. Jachame repana. Asanareta'ni vati aipi ʉ̃semʉ repanare, Dioni cuasamanea'jʉ chini. Ũcuaja'che, “Repaʉ'te cuasanapi jũnisõru vati toa uuche ʉ̃seja'mʉ Dios repanare”, chini cuasakʉ ʉ̃semʉ repaʉ vati ai. ");
INSERT INTO coe_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ũcuachi'a cata pa'ichejña tuã'isicaã na'mi aineesi'eta'ni chita saimaʉ na'mi jũnisõmʉ. Pãi ũcuachi'a te'ena Dios chʉ'o asa teana pojojʉ cuasame. Teana cuasanareta'ni vati aipi cu'ache chʉ̃'ʉkʉna Dios chʉ'o repana cuasache jo'kasõme. ");
INSERT INTO coe_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ũcuachi'a miu pa'ichejña tuã'tuasira'karʉã miuna'me aineemʉ. Jã'ajekʉna miu sũkipi ju'je vẽasõmʉ repara'ñʉrʉã. Pãi ũcuaja'che te'ena Dios chʉ'o asa chẽa Repaʉ chʉ̃'ʉñe cho'onata'ni na'mi ũhasõme. Repana cho'ochena'me kurina'me põse rʉarepa cuasajʉ Dios chʉ'o repana asa chẽasi'e ũhasõme. ");
INSERT INTO coe_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ũcuachi'a cheja re'ojachejñana tuã'tuasicaã re'oja'che ainee re'oja'che kʉ̃imʉ. Pãi ũcuaja'che te'ena Dios chʉ'o asa chẽa repana rekoñoã re'oja'che cuasajʉ Dios chʉ̃'ʉ jo'kasi'e cho'ojʉ pa'ime. Repana asa chẽasi'e ũhasõmapʉ si'arʉmʉ na'a rʉa re'oja'che pa'ime repana —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jã'aja'ñe i'ka pi'ni Jesús jo'e i'kaasomʉ repanare. —Pãiʉ ʉotʉopʉ chʉ̃o nʉkoni totoroji jaoma'mʉ. Ũcuaja'che kãiko'a vʉ'evʉna nʉkoma'mʉ. Jã'ata'ni, “Pãipi ivʉ'ena kakani chija'iʉna ñamanejanaa'me”, chini cuasa, ʉotʉopʉ chʉ̃o, ʉmʉna tʉomʉ repaʉ, re'oja'che miañe ñoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pãi rope'e cu'ache cho'ome. Jã'ata'ni repana cho'oche peore ñasi'kʉjekʉ pãi ũcuanʉko asajʉ'te kʉaja'mʉ Dios. Chave cho'osi'e peore masicojñoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jã'ajekʉna Dios chʉ'o asajʉ pa'ijʉ̃'ʉ mʉsanʉkona. Pãi, Dios chʉ'o asa jachamana si'arʉmʉ na'a rʉa re'oja'che pa'ijanaa'me. Cho'okaija'mʉ Dios repanare, Repaʉ chʉ'ore na'a rʉa masia'jʉ chini. Jã'ata'ni chekʉna chʉ'ʉ chʉ'vache asanata'ni masi cuasamapʉ chʉ'ʉpi cho'okʉna repana jmamakarʉ masiche'te cavesʉjanaa'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ũcuarʉmʉ Jesús pʉka'ko, repaʉ cho'jechĩina'me repaʉ pa'ivʉ'ena sani kakañu chiniasome. Kakañu chiisinareta'ni kakacu'aasomʉ repanare, pãipi jairepanʉkojejʉna. ");
INSERT INTO coe_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kakacu'akʉna ve'sere pa'ijʉna chekʉpi kʉaasomʉ Jesure. —Mʉja'ko, mʉche'ʉchĩina'me mʉ'ʉni ñañu chini ve'sere nʉkajʉ cha'ame —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chikʉna Jesús i'kaasomʉ. —Dios chʉ'o asa chẽa jachama'ñe cho'ona chʉ'ʉ ja'koromijanaa'me. Ũcuaja'che chʉ'ʉ cho'jechĩijanaa'me repana —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na'a pa'isirʉmʉna Jesús repaʉ neenana'me choovʉ ʉjavʉna tuni, —Ira chiara chekʉkã'kona jẽñu mai —chiniasomʉ. Chikʉna jẽaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jẽajʉna Jesús kãnisoasomʉ. Repaʉ kãnisosirʉmʉna rʉarepa tutakʉ choovʉna fa'a ja'ñʉkʉ okopi timusokʉna ru'ipi'raasome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Choovʉji runisocuhakʉna Jesuni vʉojʉ i'kaasome repana. —¡Masiʉ, Masiʉ, runisõcuhame mai! —chiniasome repana repaʉ'te. Chitena vʉni, —Tutachena'me fa'ache cuhajʉ̃'ʉ —chiniasomʉ repaʉ. Chikʉna tutachena'me fa'ache teana ũcuapa'rʉva cuhaasomʉ. Jo'e re'oja'ira cuhaasomʉ chiara. ");
INSERT INTO coe_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jã'aja'ñe cho'ocuha Jesús repaʉ neenare i'kaasomʉ. —¿Je'se pa'iʉna mʉsanʉkona chʉ'ʉre masi cuasama'ñe? —chiniasomʉ repaʉ. Chikʉna vajʉchʉjʉ rʉa cuasajʉ sãiñechi'a sẽniasaasome repana. —¿Keeja'iʉjekʉ ikʉ jã'aja'ñe cho'okʉ? Ikʉpi chʉ̃'ʉʉna tutasi'e cuhasõmʉ, fa'asi'ejẽ'e ũcuaja'che —chiniasome repana Jesús neena. ");
INSERT INTO coe_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ũcuarʉmʉ Gadara chejana Galilea cheja ti'jñeñe pa'ichejana tĩ'aasome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tĩ'a matena repacheja cajoopo cakʉ pãiʉ vatire paakʉji tijñaasomʉ Jesure. Rʉa jeerʉmʉ kãa peova'ʉ pa'iʉ, vʉ'ejẽ'e pa'imaʉ pãi tãchejñachi'a pa'iʉ paniasomʉ repava'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ũcuarʉmʉ Jesús repava'ʉre pa'inare vati, “Etajʉ̃'ʉ”, chiniasomʉ. Chikʉna vati paava'ʉ Jesure ña, cuikʉ repaʉ'te ti'jñeñe ro're ñu'iʉ ʉjachʉ'opi ija'che i'kaasomʉ: —Jesús, Cʉnaʉmʉ Pa'ikʉ Dios Mamakʉ, ¿ʉ̃que raikʉ mʉ'ʉ? Asi cho'omanejʉ̃'ʉ chʉ'ʉre —chiniasomʉ repaʉ. Aperʉmʉ repaʉni vatipi kaka chʉ̃'ʉkʉna vẽ've cho'okʉna pãi repaʉ'te chẽa repaʉ jʉ̃jñana'me cũ'a cʉnameãpi vẽeasome. Vẽesi'eta'ni rueni tʉteso, vatipi chʉ̃'ʉkʉna pãi peochejñare sani pa'iʉ paniasomʉ repava'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Reparʉmʉ Jesús, —¿Ʉ̃quemamiʉ'ʉ mʉ'ʉ? —chiniasomʉ vatire. Jesupi mamire sẽeʉna, —Chʉkʉna jainʉko pa'inajejʉ, Vati Kuanupʉ ve'eme —chiniasomʉ vati. Aperʉmʉ vati jainʉko kakaasome repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ũcuarʉmʉ vati i'kaasome Jesure. —Chʉkʉna'te vati chẽacojñosina pa'icoje rʉicoje casomanejʉ̃'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ũcuacheja kueñere aikũti caripa'te jo'chasẽse kuanupʉ ãure mu'kajʉ ãijʉ paniasome.— Jo'chasẽse sa'navʉãna saojʉ̃'ʉ chʉkʉna'te —chiniasome vati. Rʉarepa sẽejʉna Jesús ʉ̃semaneasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jesupi ʉ̃semaʉna eta jo'chasẽseva'na sa'navʉãna sani kakaasome repana vati. Kakarena jo'chasẽseva'na teana vʉ'vʉ aikũti ʉjakũti caripaji chiarana tuã'tua ru'tu jũnisoasome. ");
INSERT INTO coe_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jã'aja'ñe cho'orena ña repava'nare kuirasina kʉañu chini vʉ'vʉsoasome vʉ'ejoopo pa'inana'me repachejña po'ña pa'inare. ");
INSERT INTO coe_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kʉarena asa cho'osi'ere ñañu chini eta saniasome pãi. Sani Jesús pa'ichejana tĩ'a, vati paasi'kʉre ñaasome repana. Kãa peosi'kʉ churata'ni kãa ju'iʉ, Jesure ti'jñeñe ñuniasomʉ repaʉ. Ũcuaja'che vẽ've cho'osi'kʉpi rũhiñe cuasakʉna ña kʉkʉsoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ũcuachi'a repa cho'osi'e ñasinapi kʉaasome repanare ñañu chini raisinare. ");
INSERT INTO coe_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kʉarena Gadara cheja cana ũcuanʉko asa kʉkʉcajejaniso, —Pa'imanejʉ̃'ʉ mʉ'ʉ icheja. Saijʉ̃'ʉ —chiniasome Jesure. Chitena co'ira chini choovʉna tuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Co'ipi'rakʉna vati paasi'kʉ Jesuni ja'me sasa chini rʉa sẽniasomʉ. Sẽeʉna, ");
INSERT INTO coe_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mʉ'ʉ vʉ'ena co'ijʉ̃'ʉ. Co'i Dios mʉ'ʉre cho'okaisi'ere peore kʉajʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. Jã'aja'ñe i'kaʉna co'i Jesús repaʉ'te cho'okaisi'ere peore vʉ'ejoopo pa'inani ũcuanʉkore kʉaasomʉ repaʉ vati paasi'kʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Repaʉ Jesús chiara jẽni jo'e co'iʉna pãi jainʉko cha'ajʉ pa'isinajejʉ ña rʉa pojosoasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Reparʉmʉ Jairo judíopãi chi'ivʉ'e chʉ̃'ʉkʉ rani Jesure ti'jñeñe ro're pʉʉ ñu'iʉ, —Chʉ'ʉre vʉ'ena ja'me saijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Repaʉ mamako, ũcuate'eva'opi jũnisopi'raasomo, chekʉrʉmʉ docerepaʉ̃sʉrʉmʉ pa'ikoji. Jũ'iona Jesuni soniasomʉ repaʉ. Sokʉna ja'me saiʉna repaʉ'te tuhana pãi si'acakã'jño tĩ'tiasome repaʉ'te Jesure. ");
INSERT INTO coe_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ũcuaja'che romio, docerepaʉ̃sʉrʉmʉ chie ravʉ jũ'iko ja'me paniasomo. Ʉ̃kopãipi cho'o vasoa'jʉ chini repava'o paasi'e kuri peore ro'isoasomo repava'o. Jã'ata'ni repao'te ʉ̃ko cho'ote'easome repana. ");
INSERT INTO coe_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jã'aja'ñe pa'ikoji rani Jesús cho'jepi repaʉ ju'ikãa pʉso juhasirʉ'tʉvana chẽaasomo repao. Chẽaona chie raisi'e churata'ni teana cuhasoasomʉ repao'te. ");
INSERT INTO coe_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Repaoji chẽaona, —¿Neepi chʉ'ʉre chẽare? —chiniasomʉ Jesús. Chikʉna ũcuanʉko, —Chẽama'me chʉkʉna —chiniasome repaʉ'te. Chitena Pedro i'kaasomʉ. —Masiʉ, pãiva'na si'acakã'jño tĩ'time mʉ'ʉre —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chikʉna, —Jã'ata'ni pãi chʉ'ʉre chẽasinaa'me. Chʉ'ʉ masicheji pãi vasosi'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jã'aja'ñe i'kaʉna, “Chʉ'ʉ chẽasi'e masimʉ ikʉ”, chiio cuasa kʉkʉso, kurukuruo rani repaʉ'te ti'jñeñe ro're ñu'io, —Chʉ'ʉpi mʉ'ʉ kãa chẽasi'koa'mo vajʉra chini. Chẽa teana te'erʉmʉ vajʉsõsi'koa'mo chʉ'ʉ —chiniasomo repao, pãi ũcuanʉko asajʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kʉaona asa Jesús i'kaasomʉ repao'te. —Jmava'o, “Ikʉ chʉ'ʉre vasoja'mʉ”, chiio cuasasi'kojeko vajʉcuhasi'koa'mo mʉ'ʉ. Sani re'oja'che pa'ijʉ̃'ʉ chura —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Repaʉ Jesús chuta'a i'katona, chekʉ pãiʉ rani i'kaasomʉ Jairo'te. —Mʉ'ʉ chĩiva'o jũnisõcuhasi'koa'mo. Masiʉ'te jo'e i'kamanejʉ̃'ʉ —chiniasomʉ repaʉ Jairo'te. ");
INSERT INTO coe_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jã'aja'ñe kʉaʉna asa Jesús i'kaasomʉ. —Vajʉchʉmanejʉ̃'ʉ. Mʉ'ʉpi, “Chʉ'ʉ chĩiva'ore vasokaija'mʉ Jesús”, chiiʉ cuasato mʉ'ʉ chĩiva'o vajʉja'mo —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I'ka pi'ni Jairo vʉ'e sani tĩ'a Pedro'te, Santiago'te, Juanna'me jũ'isiva'o pʉka'kʉpãi cuaaasomʉ repaʉ repavʉ'e. Chekʉnareta'ni vʉ'e kakache ʉ̃seasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kaka ñato Jesús chuta'a raimarʉmʉ kakasina ũcuanʉko otare oijʉ paniasome. Oijʉna Jesús i'kaasomʉ repanare. —Re'omʉ. Ũcuamakarʉ oijʉ̃'ʉ mʉsanʉkona. Jũnisõsiva'oma'mo iko. Rupʉ kãisiva'oa'mo —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jã'aja'ñe i'kaʉna asa jachajʉ Jesure pãisoasome repana, repao jũ'isi'ere masijʉ. ");
INSERT INTO coe_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ũcuarʉmʉ Jesús jũ'isiva'o jʉ̃tʉna chẽa ʉjachʉ'opi i'kaasomʉ. —Romichĩio, vʉijʉ̃'ʉ —chiniasomʉ repaʉ repava'ore. ");
INSERT INTO coe_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chikʉna vajʉrani teana vʉniasomo repava'o. Vʉkona Jesús repaoni ãure ãua'jʉ chini chʉ̃'ʉasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jã'aja'ñe cho'oʉna ña repava'o pʉka'kʉpãi kʉkʉsoasome. Ña kʉkʉsorena, —Iva'ore chʉ'ʉ vasosi'e chekʉnare pãi kʉamanejʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ũcuarʉmʉ Jesús repaʉ neenare docerepanare soni chi'i, —Chʉ'ʉpi cho'okaiʉna pãi sa'navʉã pa'inare vati peore eto saojanaa'me mʉsanʉkona. Ũcuachi'a pãi jũ'iva'nare vasojanaa'me mʉsanʉkona. Jã'aja'ñe cho'oa'jʉ chini jo'kamʉ chʉ'ʉ mʉsanʉkonare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chini repanare ija'che chʉ̃'ʉasomʉ repaʉ: —Pãi cu'ache cho'oche ũhasinare Dios chẽa paache'te chekʉnare pãi kʉajʉ pa'ijʉ̃'ʉ mʉsanʉkona. Ũcuachi'a ravʉ jũ'iva'nare vasojʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jã'aja'ñe i'ka pi'ni Jesús ija'che i'kaasomʉ repanare: —Mʉsanʉkonapi sani cu'amakarʉjẽ'e samanejʉ̃'ʉ. Vãsoñoã mʉsanʉkona jʉ'vejʉ ku'iñoãjẽ'e samanejʉ̃'ʉ. Turu cu'amajñarʉã mañajaturujẽ'e samanejʉ̃'ʉ. Ãujẽ'e samanejʉ̃'ʉ. Kurijẽ'e samanejʉ̃'ʉ. Kãñajẽ'e samanejʉ̃'ʉ. Kãña sa'ñejʉ ju'ikãñajẽ'e sama'ñe mʉsanʉkona ju'ikãñarʉãchi'a ju'ijʉ ku'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sani ku'ijʉ vʉ'ejoopo tĩ'ani mʉsanʉkonare chiina vʉ'ere canʉka pa'ijʉ̃'ʉ, tĩicheja saichetʉ'ka. ");
INSERT INTO coe_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jã'ata'ni pãi mʉsanʉkonare cuhena pa'ijoopoã canʉkamanejʉ̃'ʉ. Mʉsanʉkonare cuhena pa'ijoopoã etani mʉsanʉkona cũ'akorophe're chʉ̃'isi'e cha'ore tĩ'to to'jñojʉ eta saijʉ̃'ʉ. Jã'aja'ñe cho'oru mʉsanʉkonare repana cuhesi'e masijanaa'me repana —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jã'aja'ñe chʉ̃'ʉʉna sani ku'ijʉ vʉ'ñajoopoã si'ajoopoã Dios chʉ'ore chʉ'vaasome repana. Ũcuachi'a pãi jũ'iva'nare vasoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ũcuarʉmʉ chekʉna pãi Jesús pa'iche'te cutujʉ, “Diopi vasoʉna Juan jũnisoʉna tãcojñosi'kʉpi jo'e vajʉrani pa'imʉ”, chiniasome. Chekʉnata'ni, “Aperʉmʉ Dios chʉ'o kʉasi'kʉpi Elíapi jo'e vajʉrani pa'imʉ jã'ʉ”, chiniasome. Chekʉnata'ni, “Aperʉmʉ Dios chʉ'o kʉasinapi te'eʉ vajʉrani pa'imʉ jã'ʉ”, chiniasome. Reparʉmʉ Herodes, pãi jainʉkore chʉ̃'ʉkʉ Jesús cho'oche'te pãipi kʉajʉna asaasomʉ, pãi Jesure cutusi'e ũcuaja'che. Asa, “¿Je'se paakʉ ie?”, chini rʉa cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Rʉa cuasakʉ i'kaasomʉ repaʉ. —Aperʉmʉ Juanre sĩjopʉ'te tʉsoa'jʉ chini chʉ̃'ʉsi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni, ¿jeeja'iʉ'ʉ jã'ʉ? Pãipi kʉajʉna repaʉ pa'iche rʉa si'ache asakʉ pa'imʉ chʉ'ʉ —chiniasomʉ repaʉ. Jã'ajekʉna repaʉ Herodes Jesuni ñaʉakʉna si'ache cho'oasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na'a pa'isirʉmʉ Jesús neena, repaʉ saosina rani repana cho'osi'e peore kʉaasome repaʉ'te. Kʉarena repanarechi'a Betsaida vʉ'ejoopo kueñena pãi peochejana saasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Saʉna repana saisichejana pãipi asa tuhajʉna ña pojoasomʉ Jesús repanare. Tuharena pãi cu'ache cho'oche ũhasosinare Dios chẽa paache'te kʉaasomʉ repaʉ repanare. Ũcuachi'a jũ'iva'nare vasoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na'isocuhakʉna repaʉ neena, docerepana repaʉ'te rani ija'che i'kaasome: —Icheja vʉ'ñajoopoãjẽ'e peomʉ. Inare pãi saojʉ̃'ʉ, vʉ'ñajoopoã kueñe pa'ijoopoãna, ʉjajoopoãna'me jmajoorʉãna sani ãuna'me kãivʉ'ña ku'ea'jʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jã'aja'ñe i'kanareta'ni Jesús i'kaasomʉ repanare. —Mʉsanʉkonapi ãu ãujʉ̃'ʉ inare —chiniasomʉ. Chikʉna, —Pãpʉã, cincorepapʉã, va'i te'eka'chapava'narechi'a paame chʉkʉna. ¿Chʉkʉnapi ãu koojani ra inare pãi ũcuanʉkore ãua'jʉ chiikʉ mʉ'ʉ? —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chekʉrʉmʉ repana pãi cinco milrepana na'a jainʉko pa'icosome, ʉmʉpãichi'a kuẽkueto. Pa'ijʉna, —Te'ekuanupʉ cincuentarepanachi'a pãi pʉʉa'jʉ. Ũcuanʉko ũcuajanʉkochi'a pʉʉa'jʉ. Jã'aja'ñe i'kajʉ̃'ʉ inare pãi —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chikʉna Jesús neenapi chʉ̃'ʉrena pãi ũcuanʉko te'ekuanuchi'a pʉʉasome. ");
INSERT INTO coe_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pʉʉ ñu'ijʉna pã, cincorepapʉã va'i te'eka'chapava'nare mini cãjikʉ cʉnaʉmʉre ñakʉ Dioni, “Re'orepamʉ, Ja'kʉ”, chini repaʉ neenani tʉ'se ĩsiasomʉ repaʉ, ũcuanʉkore ãua'jʉ chini. (Jmanʉkorʉ pa'isi'e ãu Dioni sẽkʉna teana rʉa paniasomʉ.) ");
INSERT INTO coe_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pãi ũcuanʉko chajiche ãniasome repa. Jã'ata'ni repana ãijʉna cajejaisi'e sia docerepajʉ'ña maña timuasome repana Jesús neena. ");
INSERT INTO coe_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na'a pa'isirʉmʉ Jesupi Dioni te'eʉ sẽeʉna repaʉ neena ja'me paniasome. Pa'ijʉna repanare chʉ'o sẽniasomʉ repaʉ. —Pãi chʉ'ʉ pa'iche cutuni, ¿je'se chiiche? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chikʉna i'kaasome repana. —“Juan, Pãi Okoro'vekʉ'mʉ jã'ʉ”, chiime pãi chekʉna mʉ'ʉre i'kani. Chekʉna, “Aperʉmʉ pa'isi'kʉ Elíaa'mʉ jã'ʉ”, chiime mʉ'ʉre. Jo'e chekʉna, “Aperʉmʉ Dios chʉ'o kʉasi'kʉpi jũnisõsi'kʉpi jo'e vajʉrani pa'imʉ jã'ʉ”, chiime mʉ'ʉre —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chitena asa repanare sẽniasomʉ repaʉ. —Mʉsanʉkonajẽ'e chʉ'ʉ pa'iche cutuni, ¿je'se chiiche? —chiniasomʉ repaʉ repanare. Chikʉna, —Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ mʉ'ʉ. Cristoa'mʉ —chiniasomʉ Pedro repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedroji, “Dios Raosi'kʉa'mʉ mʉ'ʉ; Cristoa'mʉ”, chikʉna, “Chekʉnare pãi kʉamanejʉ̃'ʉ”, chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chini jo'e i'kaasomʉ repaʉ. —Chʉ'ʉ Dios Raosi'kʉ rʉa asi cho'ocojñoja'mʉ. Judío ainana'me judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona chʉ'ʉni cuhejʉ vanisõñe chʉ̃'ʉjanaa'me. Chuenisõ tãcojñosi'kʉta'ni choteumucujñana jo'e vajʉraija'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Repaʉ neenare i'ka pi'ni pãi ũcuanʉkore i'kaasomʉ repaʉ. —Mʉsanʉkonapi chʉ'ʉ neena pañu chini mʉsanʉkonare cho'oʉache ũhasõ chʉ'ʉ chʉ̃'ʉñe'te si'aumucujña cho'ojʉ pa'ijʉ̃'ʉ. Chʉ'ʉre cuasanajejʉna chʉ'ʉre cho'ocheja'che vanisõñu chiijanaa'me pãi mʉsanʉkonare. Pãi mʉsanʉkonare jã'aja'ñe cho'oñu chiiche asanijẽ'e chʉ'ʉre cuasache ũhasõmanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chuenisõñe'te vajʉchʉjʉ mʉsanʉkona asa chẽasi'ere Dios chʉ'ore ũhasõni jũnisõsirʉmʉ vati toana sani uujanaa'me. Jã'ata'ni, “Pãi chʉkʉna'te vanisõñu chiitojẽ'e Jesure ũcua cuasajanaa'me chʉkʉna”, chiisina repana jũnisõsirʉmʉ Dios pa'ichejare ai sani re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pãi rʉa si'ache paanapi chʉ'ʉre cuasamaneni repana jũnisõsirʉmʉ vati toana sani uujanaa'me. Ũcuachi'a repana paasi'e peore cho'osõja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pãi chʉ'ʉre cuasanata'ni chekʉnani vajʉchʉjʉ, “Jesure cuasamanaa'me chʉkʉna. Ũcuachi'a Repaʉ chʉ'ojẽ'e vesʉnaa'me chʉkʉna”, chiime masinata'ni. Jã'aja'ñe i'kasinare rʉa cu'ache ti'jñeja'mʉ. Na'a pa'isirʉmʉ chʉ'ʉ, Dios Raosi'kʉ, cʉnaʉmʉ mʉisi'kʉpi chejana jo'e cajeja'mʉ. Chʉ'ʉ Ja'kʉ Dios ángelena'me ko'sija'icheja'che ko'sija'iʉ cajeja'mʉ chʉ'ʉ. Caje jã'aja'ñe i'kasinare ũcuaja'che, “Inare pãi vesʉmʉ chʉ'ʉ”, chiija'mʉ chʉ'ʉ reparʉmʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mʉsanʉkona icheja chʉ'ʉre ja'me pa'ina chuta'a jũnisõmarʉmʉna chʉ'ʉ Dios Raosi'kʉpi pãire masi chʉ̃'ʉkʉna ñajanaa'me mʉsanʉkona. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Repanare cutusirʉmʉ, ochorepaumucujña pa'isirʉmʉna Dioni sẽsa chini aikũtina mʉniasomʉ Jesús. Pedro'te, Santiago'te Juanre jã'anarechi'a ja'me mʉaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dioni sẽeʉ tĩiʉja'iʉ carũniasomʉ repaʉ. Repaʉ ju'ikãña ũcuaja'che rʉa poko'sijakãña carũniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Carũni nʉkakʉna ʉmʉpãi rʉa ko'sijanapi te'eka'chapana peosichejapi teana rani nʉkajʉ Jesús Jerusalén vʉ'ejoopo jũ'ijañere cutuasome. Aperʉmʉ pa'isina paniasome repana Moisena'me Elías. ");
INSERT INTO coe_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Cutujʉna Pedro chekʉnana'me rʉa ʉokʉanata'ni kãima'ñe Jesuni rʉa ko'sija'iʉni ñajʉ paniasome, repaʉ'te ja'me pa'inare ka'chanare ũcuachi'a. ");
INSERT INTO coe_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Repanapi Jesuni cutu pi'ni saipi'rajʉna masi cuasavesʉkʉ Pedro ija'che i'kaasomʉ Jesure: —Masiʉ, maipi ichejare pa'ijʉna rʉa re'omʉ. Vʉ'ñarʉã chotevʉ'ñarʉã cho'okañu chiime chʉkʉna, mʉ'ʉ vʉ'erʉna'me Moisés vʉ'erʉna'me Elías vʉ'erʉ —chiniasomʉ Pedro. ");
INSERT INTO coe_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chuta'a i'katona Moisena'me Elíana'me Jesús nʉkachejana pikopi caje ta'pisoʉna repanapi piko sa'navʉ'te nʉkajʉ Jesús neena rʉa kʉkʉsoasome. ");
INSERT INTO coe_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ũcuarʉmʉ piko sa'navʉji chʉ'o i'kache ija'chere asaasome repana: “Ikʉ chʉ'ʉ chĩi chʉ'ʉ oiʉ paakʉ'mʉ. Repaʉ chʉ'ore asajʉ pa'ijʉ̃'ʉ mʉsanʉkona”, chiiche'te asaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jã'aja'ñe chiiche asa jo'e ñato Jesús te'eʉ nʉkaasomʉ. I'kama'ñe ña repana ñasi'e reparʉmʉ chekʉnarejẽ'e kʉamaneasome repana Pedrona'me Santiagona'me Juan. ");
INSERT INTO coe_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jo'e apeñatato aikũti mʉisi'kʉpi Jesupi cajeʉna pãi jainʉko repaʉni ñañu chini raniasome. ");
INSERT INTO coe_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ratena repanare pãi ja'me pa'ikʉji cuikʉ Jesuni re'oja'chere sẽniasomʉ. —Masiʉ, chʉ'ʉ chĩiva'ʉre ñajʉ̃'ʉ. Ũcuate'eva'ʉa'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vatipi si'arʉmʉ chẽa paakʉ chʉ̃'ʉkʉna rʉa cuikʉ vẽ've curukʉ repaʉ chʉ'opoji coo rʉa raokʉ pa'imʉ iva'ʉ. Iva'ʉre rʉa asi cho'o etakʉta'ni vati, ai etama'mʉ iva'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ'ʉ neenare sẽesi'kʉa'mʉ chʉ'ʉ, vatini eto saokaapʉ chini. Jã'ata'ni etovesʉsinaa'me repana —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Mʉsanʉkona pãi irʉmʉ cana chʉ'ʉre masi cuasama'me. Rʉa tĩiñe cuasame mʉsanʉkona. ¿Keekerʉmʉ mʉsanʉkona tĩiñe cuasache ñakʉ pa'iche chʉ'ʉ? —Jã'aja'ñe i'ka pi'ni— Ichejana rajʉ̃'ʉ mʉ'ʉ chĩiva'ʉre —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chikʉna raniasomʉ repava'ʉ. Raiʉna vatipi cho'o tãuʉna ũhiʉ vẽ've curuasomʉ repaʉ. Jã'aja'ñe cho'okʉna ña Jesupi vatini, “Etajʉ̃'ʉ”, chikʉna etaasomʉ vati. Repava'ʉre vaso pi'ni, pʉka'kʉni co'choasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jesupi jã'aja'ñe cho'oʉna ña kʉkʉso pãi ũcuanʉko, “Dios peore masikʉ'mʉ”, chiniasome. Jã'ajekʉna Jesús repaʉ neenare ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Chʉ'ʉ i'kache asa cavesʉmanejʉ̃'ʉ. Chʉ'ʉre Dios Raosi'kʉre cuhena pãi cu'ache cho'oa'jʉ chini chẽa jo'kajanaa'me —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jã'ata'ni repaʉ i'kache asavesʉasome repana. Reparʉmʉ Dios repanapi masi asamanea'jʉ chini asavesache cho'oasomʉ repanare. Masi asamanata'ni repaʉ'te Jesure sẽevajʉchʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ũcuarʉmʉ Jesús neena ija'che sãiñechi'a cutuasome: “Mai icheja pa'ina, ¿neepi na'a rʉa masiche?”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Jã'aja'ñe cutujʉna repana cuasajʉ cutuche ñaasomʉ Jesús. Ña chĩiva'ʉre juha ra, repaʉ'te kueñe nʉko ija'che i'kaasomʉ repaʉ: —Pãi chʉ'ʉre masi cuasana chĩiva'nare ikʉjava'nare pojona chʉ'ʉre ũcuaja'che pojome. Pãi chʉ'ʉre pojona chʉ'ʉre Raosi'kʉre ũcuaja'che pojome. Pãi rʉa vesʉva'napi chʉ'ʉna'me Ja'kʉre pojoni Diopi ñato rʉa masinaa'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ũcuarʉmʉ Juan ija'che i'kaasomʉ Jesure: —Masiʉ, chekʉre pãiʉ'te vati pãi sa'navʉã pa'inare eto saokʉ'te ñasinaa'me chʉkʉna. “Jesupi chʉ̃'ʉkʉna cho'omʉ chʉ'ʉ”, chiisi'kʉa'mʉ repaʉ vatire eto saoni. Jã'aja'ñe cho'oʉna ña ʉ̃sejʉ i'kasinaa'me chʉkʉna repaʉ'te, maire ja'me cho'okaima'kʉjekʉna —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chitena asa, —Jã'aja'ñe cho'onare ʉ̃semanejʉ̃'ʉ. Pãi maire cuhemana maire ja'me cho'okainaa'me —chiniasomʉ Jesús repaʉ'te Juanre. ");
INSERT INTO coe_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ũcuarʉmʉ Jesús repaʉ cʉnaʉmʉ mʉirʉmʉ tĩ'acuhakʉna saivajʉchʉma'ñe Jerusalenna saipi'raasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Saipi'rakʉ chekʉnani charo saoʉna Samaria cheja cajoopona sani, repaʉ kãijavʉ'ere sẽekaniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sẽejatena Jesupi ũcuajoopona sakʉna repajoopo cana pojomaneasome repaʉ'te, Jerusalenna saiʉna. ");
INSERT INTO coe_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Repaʉni pojomapʉna ña repaʉ neena Santiagona'me Juan i'kaasome. —Chʉkʉna'te Paakʉ, ¿inapi mʉ'ʉre cuhenapi uusõa'jʉ chini, “Cʉnaʉmʉpi toa cajeche chʉ̃'ʉjʉ̃'ʉ”, chiikʉ mʉ'ʉ chʉkʉna'te? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jã'aja'ñe i'karena chʉri ña, —Jã'aja'ñe cho'omanejʉ̃'ʉ. Mʉsanʉkonapi cu'ache cho'oñu chiiche cuhemʉ Dios Rekocho. ");
INSERT INTO coe_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chʉ'ʉ, Dios Raosi'kʉ pãire cu'ache cho'ora chini cajesi'kʉma'mʉ. Pãire oiʉ vati toa sani uuche'te ʉ̃sera chini cajesi'kʉa'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ neenare. Ũcuarʉmʉ Jesús repaʉ neenana'me chekʉjoopona saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma'api saijʉna chekʉ pãiʉ i'kaasomʉ Jesure. —Mʉ'ʉna'me ũcuaʉachejña mʉ'ʉ ku'ichejña ku'iʉ mʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pasa chiimʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Ã'care'achai kãicojña paame. Pĩ'ava'na ũcuaja'che kãisʉovʉã paame. Chʉ'ʉ, Dios Raosi'kʉta'ni, kãichejñajẽ'e peova'ʉ pa'imʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chini Jesús chekʉni i'kaasomʉ. —Chʉ'ʉni ja'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. Chikʉna, —Pãi Ũcuanʉkore Paakʉ, cha'ajʉ̃'ʉ aperʉmʉ. Chʉ'ʉ ja'kʉva'ʉni tãjasa. ¿Ʉ̃sema'kʉ mʉ'ʉ? —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jã'aja'ñe i'kaʉna asa Jesús i'kaasomʉ repaʉ'te. —Chekʉnapi chʉ'ʉre cuasamanajejʉ repana rekoñoã jũnisõsinaja'ñe pa'inapi repana majapãi jũ'isinare tãa'jʉ. Mʉ'ʉta'ni pãi cu'ache cho'oche ũhasinare Dios chẽa paache'te rani kʉakʉ pa'ijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jã'aja'ñe i'kaʉna chekʉ i'kaasomʉ repaʉ'te. —Pãi Ũcuanʉkore Paakʉ, mʉ'ʉna'me kusa chiimʉ chʉ'ʉ. Jã'ata'ni charo chʉ'ʉ majapãire, “Saimʉ chʉ'ʉ”, chiijasa chiimʉ chʉ'ʉ. ¿Ʉ̃sema'kʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chikʉna asa i'kaasomʉ repaʉ. —Pãi Dios chʉ̃'ʉñe cho'oñu chiinapi repana aperʉmʉ pa'isi'ere jo'e pa'iʉakʉna Repaʉ chʉ̃'ʉñe'te cho'oma'to Dios neena pa'icu'amʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na'a pa'isirʉmʉ Jesús chekʉnare setentarepanare ku'e chẽa i'kaasomʉ. —Mʉsanʉkona ũcuanʉko te'eka'chapanachi'a vʉ'ñajoopoãna saijʉ̃'ʉ. Chʉ'ʉ saijajoopoãna'me chʉ'ʉ saijachejñana charo sani Dios chʉ'ore chʉ'vajʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Repanani saopi'rakʉ i'kaasomʉ repaʉ. —Asarepajʉ̃'ʉ. Trigo tʉarʉmʉ trigo chio paakʉji cho'oche cho'onare ku'e saoasomʉ, repaʉni trigo'te tʉakaapʉ chini. Repaʉ repanare saosirʉmʉ cho'ocheji rʉarepajekʉna cho'oche cho'onapi karasõasome. Cho'onapi karasõkʉna chio paakʉni chʉ'o raoasome repana, chekʉnani raoa'kʉ chini. Dios chʉ'o chʉ'vache ũcuaja'che jã'aja'ñea'me. Dios chʉ'o chʉ'vanapi karasõjʉna Dios chʉ'o asamana rʉa jainʉkoa'me. Jã'ajekʉna Dioni sẽejʉ̃'ʉ mʉsanʉkona, Repaʉ chʉ'o chʉ'vanani na'a jainʉkore ku'e raoa'kʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mʉsanʉkonare, “Saijʉ̃'ʉ”, chiimʉ chʉ'ʉ. Ovejachĩiva'nare chai pa'ichejñana saocheja'che mʉsanʉkonare cuhena pa'ichejñana saomʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mʉsanʉkonapi sani turu cu'amajñarʉã mañajaturujẽ'e samanejʉ̃'ʉ. Kurijẽ'e samanejʉ̃'ʉ. Cũ'akorophe'rejẽ'e samanejʉ̃'ʉ. Ũcuaja'che ma'a saijʉ ti'jñenare canʉkama'ñe sẽejʉ saijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ũcuaja'che mʉsanʉkonapi ku'ijʉ pãi vʉ'ñana kakani, “Diopi mʉsanʉkonare re'oja'che cho'okaaʉ”, chiijʉ̃'ʉ repavʉ'e pa'inare. ");
INSERT INTO coe_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Repavʉ'e pa'ikʉji re'oja'che pa'ineekʉ pa'ito mʉsanʉkona sẽekaisi'e Diopi re'oja'che cho'okaija'mʉ repanare. Jã'ata'ni re'oja'che pa'icuhekʉ pa'ito mʉsanʉkona sẽekaisi'e re'oja'che cho'okaimaneja'mʉ Dios repanare. Mʉsanʉkona Diore sẽekaisi'e sẽema'ñeja'ñe pa'ija'mʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ũcuate'evʉ'e pa'ijʉ pa'ijʉ̃'ʉ mʉsanʉkona. Chekʉvʉ'ña pa'imanejʉ̃'ʉ. Ũcuavʉ'ere pa'ijʉ repavʉ'e pa'ina ãuñe'te ãu ãijʉ pa'ijʉ̃'ʉ. Mʉsanʉkona ãijañe ãu pãi chʉ'vache ro'ia'me. ");
INSERT INTO coe_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ũcuaja'che mʉsanʉkonapi vʉ'ejoopona sani tĩ'arena repajoopo canapi mʉsanʉkonani cuhema'to repana ãuñe ãu ãijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ũcuaja'che repajoopo pa'iva'nare jũ'iva'nare vasojʉ̃'ʉ. Ũcuachi'a ija'che kʉajʉ̃'ʉ repanare: “Dios Raosi'kʉ pãire chʉ̃'ʉpi'ramʉ”, chiijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ũcuaja'che mʉsanʉkonapi vʉ'ejoopona sani tĩ'arena repajoopo canapi mʉsanʉkonani cuheto ija'che i'kajʉ callejoovʉna etajʉ̃'ʉ: ");
INSERT INTO coe_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ijoopoquee cha'o chʉkʉna cũ'akorophe're chʉ̃'isi'ere tĩ'to to'jñome chʉkʉna, pãipi mʉsanʉkona cu'ache cho'osi'ere ña masia'jʉ chini. Asarepajʉ̃'ʉ; Dios Raosi'kʉ pãire chʉ̃'ʉpi'ramʉ”, chiijʉ̃'ʉ mʉsanʉkonare cuhenare. ");
INSERT INTO coe_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iere mʉsanʉkonani kʉara: Pãi cho'oche Dios ña ro'iche chʉ̃'ʉrʉmʉ tĩ'aru rʉa cu'ache ti'jñeja'mʉ Sodoma vʉ'ejoopo pa'isinare. Jã'ata'ni mʉsanʉkona chʉ'vache asacuhesinare na'a rʉa cu'ache ti'jñeja'mʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ: —Dios aperʉmʉ Sidón vʉ'ejoopona'me Tiro vʉ'ejoopo pa'inare Repaʉ masiche cho'o ñomaneasomʉ. Repanani chʉ'vakʉ cho'o ñoru cu'ache cho'oche ũhasõ, vãkiniokãñapi sa'che repana sĩjona ũhacʉtapi chu'chura'asinaa'me repana, chekʉnapi ña, “Cu'ache cho'oche ũhasõsinaa'me ina”, chiapʉ chini. Mʉsanʉkonata'ni chʉ'ʉpi chʉ'vakʉ Diochi'a cho'omasiche cho'okʉna ñasinaa'me, Corazín vʉ'ejoopo pa'inana'me Betsaida vʉ'ejoopo pa'ina. Jã'ata'ni ũcua cu'ache cho'oche ũhasõmanesinaa'me mʉsanʉkona. Jã'ajekʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare Corazín vʉ'ejoopo pa'inana'me Betsaida vʉ'ejoopo pa'inare. ");
INSERT INTO coe_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na'a pa'isirʉmʉ Dios pãi ũcuanʉko cho'oche ña ro'iche chʉ̃'ʉumucuse tĩ'aru Sidón vʉ'ejoopo pa'isinana'me Tiro vʉ'ejoopo pa'isinare rʉa cu'ache ti'jñeja'mʉ. Jã'ata'ni mʉsanʉkonare Corazín vʉ'ejoopo pa'inana'me Betsaida vʉ'ejoopo pa'inare na'a rʉa cu'ache ti'jñeja'mʉ, chʉ'ʉ cho'oche ñasinata'ni jachasi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","’Mʉsanʉkona Capernaum vʉ'ejoopo pa'ina, “Dios pa'ichejana saijanaa'me mai”, chiime. Jã'ata'ni Dios mʉsanʉkonare Repaʉ pãi ũcuanʉko cho'oche ña ro'iche chʉ̃'ʉumucuse tĩ'aru vati toana saoja'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chini repaʉ neenare jo'e i'kaasomʉ repaʉ. —Pãi mʉsanʉkona i'kache asa jachamana chʉ'ʉ i'kache ũcuaja'che asa jachama'me. Pãi mʉsanʉkonare cuhena chʉ'ʉre ũcuaja'che cuheme. Pãi chʉ'ʉre cuhena chʉ'ʉre Raosi'kʉre Diore ũcuaja'che cuheme —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesupi saoʉna chʉ'vajani pojojʉ co'i repaʉni kʉaasome repana setentarepana. —Chʉkʉna'te Paakʉ, chʉkʉna mʉ'ʉ ku'e chẽa saosinapi chʉ̃'ʉjʉna pãi sa'navʉã pa'isina vati eta saisinaa'me —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jã'aja'ñe kʉarena asa repanare ija'che i'kaasomʉ repaʉ: —Vati aire cʉnaʉmʉpi oko fe'neñeja'ñe na'mi tuã'ikʉni ñasi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jã'ata'ni chʉ'ʉ mʉsanʉkonare Diochi'a cho'omasiche'te cho'oa'jʉ chini masire jo'kasi'kʉa'mʉ. Masinajejʉ mʉsanʉkonapi añana'me puni tumunijẽ'e asi cho'omanejanaa'me. Ũcuaja'che vati cho'oche peore ʉ̃sejanaa'me mʉsanʉkona. Jã'are cho'ojʉ jmamakarʉjẽ'e cu'ache cho'ocojñomanejanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pãi sa'navʉã pa'inare vati etoni pojomanejʉ̃'ʉ mʉsanʉkona. Utija'ophʉro cʉnaʉmʉ pa'iphʉrona Dios mʉsanʉkona mami tochasi'ere cuasajʉ pojojʉ̃'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Reparʉmʉ Jesús, Dios Rekochoji repaʉni ja'me pa'iʉna rʉa pojokʉ i'kaasomʉ. —Ja'kʉ, mʉ'ʉ cʉnaʉmʉ pa'inana'me cheja pa'inare peore chʉ̃'ʉkʉ'mʉ. Mʉ'ʉre rʉa pojokʉ i'kamʉ chʉ'ʉ. Pãi, “Mʉ'ʉ chʉ'o peore masinaa'me chʉkʉna”, chiijʉ cuasanare mʉ'ʉ chʉ'o asamasiche ʉ̃semʉ mʉ'ʉ, repanapi asavesʉa'jʉ chini. Jã'ata'ni pãi chĩiva'naja'ñe vesʉjʉ, “Dios chʉ'ojẽ'e vesʉnaa'me chʉkʉna”, chini cuasanarechi'a mʉ'ʉ chʉ'o asamasiche jo'kakʉ'mʉ mʉ'ʉ, repanapi asamasia'jʉ chini. Jã'aja'ñere chiimʉ mʉ'ʉ. Jã'ajekʉna, “Re'orepamʉ”, chiimʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ Jesús Pʉka'kʉre. ");
INSERT INTO coe_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Diore i'ka pi'ni pãire i'kaasomʉ repaʉ. —Chʉ'ʉ Ja'kʉ Repaʉ pa'iche masiche peore jo'kasi'kʉa'mʉ chʉ'ʉre. Chʉ'ʉ pa'iche vesʉme pãi. Chʉ'ʉ Ja'kʉta'ni masimʉ. Ũcuaja'che chʉ'ʉ Ja'kʉ pa'iche vesʉme pãi. Chʉ'ʉta'ni Repaʉ pa'iche masimʉ, Repaʉ Mamakʉjekʉ. Chʉ'ʉre kʉaʉanarechi'a chʉ'ʉ Ja'kʉ pa'iche kʉamʉ chʉ'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jã'aja'ñe i'kakʉ repaʉ neenarechi'a i'kaasomʉ repaʉ. —Chura chʉ'ʉni ja'me pa'ijʉna rʉa re'omʉ mʉsanʉkonare, chʉ'ʉpi si'ache cho'o ñokʉna. ");
INSERT INTO coe_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aperʉmʉ pa'isina Dios chʉ'o kʉasinana'me pãi chʉ̃'ʉsina irʉmʉ mʉsanʉkona ñañeja'ñere ñañu chiisinata'ni ñamaneasome. Ũcuachi'a irʉmʉ mʉsanʉkona asacheja'chere asañu chiisinata'ni asamanesinaa'me repana —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ũcuarʉmʉ judíopãi che'chokʉ Jesuni cutura chini mʉaasomʉ, repaʉ masiche'te cho'o ñara chini. Mʉa repaʉ'te ija'che sẽniasomʉ repaʉ: —Masiʉ, chʉ'ʉpi Dios pa'ichejana ai sani pasa chini, ¿je'se cho'oja'che? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Dios chʉ'o tocha jo'kasi'e, ¿ʉ̃quere kʉakʉ? Mʉ'ʉpi ñato, ¿je'se kʉakʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chikʉna i'kaasomʉ repaʉ. —Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Pãi mʉsanʉkonare ũcuanʉkore Paakʉ'te Diore mʉsanʉkona aʉna'me rekoñoãna'me kokana'me cuasache peore jã'api rʉa cuasajʉ pa'ijʉ̃'ʉ. Mʉsanʉkona meñe oicheja'che kueñe pa'inare oijʉ pa'ijʉ̃'ʉ. Jã'aja'ñe kʉamʉ Dios chʉ'o, aperʉmʉ tocha jo'kasi'e —chiniasomʉ repaʉ pãi che'chokʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jã'aja'ñe i'kaʉna asa Jesús i'kaasomʉ repaʉ'te. —Rũhiñe i'kamʉ mʉ'ʉ. Mʉ'ʉpi jã'aja'ñe cho'oni Dios pa'ichejare ai sani pa'ija'mʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jã'aja'ñe i'kaʉna asa, pãipi repaʉni ña, “Ũcuarepa cho'okʉ'mʉ ikʉ”, chiijʉ cuasaa'jʉ chini Jesure jo'e sẽniasomʉ repaʉ. —¿Neea'ñe chʉ'ʉre kueñe pa'ina? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chikʉna Jesús ija'chere cuasakʉ kʉaasomʉ repaʉ'te: —Pãiʉ Jerusalén vʉ'ejoopoji Jericó vʉ'ejoopona cajeasomʉ. Cajekʉna pãi cu'ana ma'ana tijña chẽaasome repaʉ'te. Chẽa repaʉ cu'amajñarʉã tʉtesõ, repaʉ ju'ikãñarʉã tĩ'te, repaʉ'te ai jũ'iñetʉ'ka rʉa vani jo'ka sanisõasome repana. ");
INSERT INTO coe_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Vani jo'ka satena judío phairipãiʉ ũcuama'api rani chueesiva'ʉni ña ma'a chekʉkã'kona jẽni pachu carani saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Carani sakʉna chekʉ, Leví jojosi'kʉ Dios vʉ'e cho'oche cho'okaikʉ ũcuama'api rani ũcuaja'che chueesiva'ʉ ũhicheja tĩ'a ma'a chekʉkã'kona jẽni pachu carani saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chekʉ, Samariapãiʉta'ni ũcuama'api raiʉ chueesiva'ʉ ũhicheja tĩ'a ña oniasomʉ repava'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ña oiʉ repava'ʉ asimajñana pĩsi ʉche conona'me u'chape'e ro'vecuha, kãñase'repi vẽekaniasomʉ repava'ʉre. Vẽe pi'ni repaʉ burrova'ʉpi tʉo sa, pãi kãivʉ'ere paakʉ kuiraasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jo'e apeñatato repaʉ Samariapãiʉ saipi'rakʉ, repavʉ'e paakʉ'te denario kurire're ka'chare're mini ĩsikʉ ija'che i'kaasomʉ: “Iva'ʉre chueesiva'ʉre kuirakaijʉ̃'ʉ chʉ'ʉre. Chʉ'ʉ ro'isinʉko tĩ'ama'to mʉ'ʉpi ro'ikaijʉ̃'ʉ. Chʉ'ʉ jo'e raisirʉmʉna mʉ'ʉ ro'ikaisinʉko ro'ira mʉ'ʉre”, chiniasomʉ Samariapãiʉ —Jã'aja'ñe kʉaasomʉ Jesús repaʉ'te judíopãi che'chokʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jã'aja'ñe kʉa pi'ni Jesús repaʉ'te chʉ'o sẽniasomʉ. —Chueesiva'ʉ ũhisima'a ʉmʉpãi chotena te'enachi'a saijʉ ñaasome repaʉ'te. Jã'ata'ni te'eʉ re'oja'che cho'okaniasomʉ repaʉ'te, pãi kueñe pa'inare re'oja'che cho'okaicheja'che. ¿Kaʉpi repaʉ'te jã'aja'ñe cho'okakʉ? —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chikʉna, —Chueesiva'ʉre ña oisi'kʉpi re'oja'che cho'okaisi'kʉa'mʉ repaʉ'te —chiniasomʉ judíopãi che'chokʉ. Chikʉna, —Ũcuarepaa'me jã'a. Mʉ'ʉjẽ'e ũcuaja'che sani chekʉnani ña oiʉ re'oja'che cho'okaiʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús judíopãi che'chokʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ũcuarʉmʉ Jesús repaʉ neenana'me jo'e saiʉ chekʉjoopona tĩ'aʉna romichĩio Marta repao vʉ'ena Jesure soni mʉtuaasomo. ");
INSERT INTO coe_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Repao Marta cho'jeo María ve'easomo. Jesupi kaka pʉʉʉna repaʉ che'choche'te asara chini repaʉ'te kueñe pʉʉasomo repao María. ");
INSERT INTO coe_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jã'ata'ni Marta, vʉ'e cho'omajñarʉãre te'eo cho'o ca'naso, Jesure kueñe rani ija'che i'kaasomo: —Pãi Ũcuanʉkore Paakʉ, chʉ'ʉ cho'jeo cho'omajñarʉã ja'me cho'oma'mo chʉ'ʉre. Chʉ'ʉchi'a te'eva'o cho'oko pa'imo. ¿Chʉ'ʉre ña oima'kʉ mʉ'ʉ? I'kajʉ̃'ʉ repao'te chʉ'ʉre ja'me cho'oa'ko —chiniasomo repao repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chikona Jesús i'kaasomʉ repao'te. —Asarepajʉ̃'ʉ, Marta. Mʉ'ʉ pa'iche'te rʉarepa peore cuasako oimo mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Re'oja'che pa'iche chuta'a chẽama'mo mʉ'ʉ. Mʉche'ota'ni chʉ'ʉ che'choche'te asaneeko re'oja'che pa'iche'te chẽacuhamo. Jã'aja'ñe cho'oko'te ʉ̃sema'mʉ chʉ'ʉ —chiniasomʉ Jesús repao'te Martare. ");
INSERT INTO coe_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ũcuarʉmʉ Jesús repaʉ saisichejare pa'iʉ Dioni sẽniasomʉ. Sẽni pi'niʉna repaʉ neekʉ te'eʉ ija'che i'kaasomʉ repaʉ'te: —Chʉkʉna'te Paakʉ, Diore sẽeñe'te che'chojʉ̃'ʉ chʉkʉna'te, Juan repaʉ neenare che'chosi'eja'che —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chikʉna Jesús repaʉ neenare i'kaasomʉ. —Mʉsanʉkonapi Diore sẽni ija'che i'kajʉ̃'ʉ: Ja'kʉ, Cʉnaʉmʉ Pa'ikʉ, pãi mʉ'ʉre vajʉchʉjʉ pojoa'jʉ. Ũcuachi'a mʉ'ʉ chʉ̃'ʉñe pãi ũcuanʉko cho'ojarʉmʉ tĩ'aa'kʉ. Cʉnaʉmʉ pa'ina mʉ'ʉ chʉ̃'ʉñe masi cho'ocheja'che cheja pa'ina ũcuaja'che re'oja'che cho'ojʉ paapʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ũcuachi'a chʉkʉna chiiche ãu si'aumucujña ĩsijʉ̃'ʉ, chʉkʉna ãijañe. ");
INSERT INTO coe_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chʉkʉna cu'ache cho'oche jo'e cuasamanejʉ̃'ʉ, chʉkʉna'te pãi cu'ache cho'osi'e chʉkʉna jo'e cuasama'ñeja'ñe. Chʉkʉna'te vatipi chʉ̃'ʉkʉna cu'ache cho'oñu chiito mʉ'ʉpi ʉ̃sekaijʉ̃'ʉ, cho'omanea'jʉ chini. Jã'aja'ñe i'kajʉ Diore sẽejʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Chini repanare jo'e i'kaasomʉ repaʉ. —Chekʉrʉmʉ mʉsanʉkona te'eʉ mʉ'ʉre kueñe pa'ikʉ mʉ'ʉ vʉ'ena ñamirepana mʉamʉ. Mʉa jatisa'aro tĩ'a ve'sere nʉkakʉ ija'che i'kamʉ: “Chʉ'ʉre re'okʉ, vʉni pãra'pʉrʉã chotera'pʉrʉã ĩsijʉ̃'ʉ chʉ'ʉre. Jo'e co'chora chʉ'ʉ mʉ'ʉre. Chekʉ chʉ'ʉre re'oja'che cho'okʉ so'opi raiʉ churepara chʉ'ʉ vʉ'ena tĩ'amʉ ãiñejẽ'e peokʉni”, chiimʉ repaʉ chekʉrʉmʉ mʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jã'aja'ñe sẽeto mʉ'ʉ chekʉrʉmʉ ija'che i'kamʉ: “Cho'oʉama'ñe cho'omanejʉ̃'ʉ chʉ'ʉre. Jatisa'aro jeosõcuhasi'kʉa'mʉ chʉ'ʉ. Kãsa chini chʉ'ʉ chĩiva'nana'me ʉmesõcuhasi'kʉa'mʉ chʉ'ʉ. Mʉ'ʉ sẽeñe vʉni ĩsima'mʉ chʉ'ʉ”, chiimʉ mʉ'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","’Asarepajʉ̃'ʉ, mʉsanʉkona. “Chʉ'ʉre re'okʉ'mʉ”, chiikʉta'ni repaʉ sẽeñe vʉni ĩsima'mʉ mʉ'ʉ. Jã'ata'ni, “Chʉ'ʉni jeereparʉmʉ sẽeto asa ca'nasõ, vʉni ĩsija'mʉ chʉ'ʉ”, chini cuasa, vʉni repaʉ chiiche peore ĩsija'mʉ mʉ'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Ija'che kʉamʉ chʉ'ʉ mʉsanʉkonare: Ũcuaja'che mʉsanʉkona chiiche cuhama'ñe Dioni rʉa sẽejʉ pa'ijʉ̃'ʉ ĩsia'kʉ. Cuhama'ñe sẽejʉ pa'ito ĩsija'mʉ Repaʉ. Ũcuachi'a mʉsanʉkona Repaʉ'te sẽesi'e cha'ajʉ̃'ʉ ĩsia'kʉ. Cha'ani koojanaa'me mʉsanʉkona. Ũcuachi'a pãiʉ repaʉ'te re'okʉ vʉ'ena mʉa tĩ'a jatisa'aro'te nʉkakʉ, repaʉ chiiche'te koorepara chini cuhama'ñe rʉa jeerʉmʉ sẽeʉ pa'icheja'che Diore rʉa jeerʉmʉ sẽejʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'ojʉ pani koojanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Repanare karache'te Diore sẽena koojanaa'me. Ũcuachi'a Repaʉ'te sẽesi'e cha'ana koojanaa'me. Ũcuachi'a pãiʉ repaʉ'te re'okʉ vʉ'ena mʉa tĩ'a jatisa'aro'te nʉkakʉ, rʉa jeerʉmʉ sẽeʉ pa'iʉ koocheja'che koojanaa'me pãi, Diore rʉa jeerʉmʉ sẽejʉ pa'ina. ");
INSERT INTO coe_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Mʉsanʉkona ʉmʉpãi chĩi paana, asarepajʉ̃'ʉ. Mʉ'ʉ chĩipi mʉ'ʉni pãre sẽeto catapʉ'te mini ĩsima'me mʉsanʉkona. Jã'apãani chiacha va'ire sẽeto añani mini ĩsima'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kura chiapʉ sẽeto punioni mini ĩsima'mʉ mʉ'ʉ repaʉ'te. Jã'aja'ñe cho'omanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Cu'ache pa'inata'ni mʉsanʉkona chĩiva'nare re'oja'chere ĩsinaa'me mʉsanʉkona. Mai Ja'kʉ, Dios, Cʉnaʉmʉ Pa'ikʉ na'a re'oja'chere ĩsikʉ'mʉ maire. Pãipi Repaʉ'te sẽeto Repaʉ Rekocho'te ĩsikʉ'mʉ Repaʉ repanare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ũcuarʉmʉ Jesús vatire pãiʉ'te chʉ'o cutuche ʉ̃sekʉni eto saokaniasomʉ. Eto saoʉna vatire paasi'kʉpi, chʉ'o cutumanesi'kʉpi chʉ'ore cutukʉna ña kʉkʉasome pãi. ");
INSERT INTO coe_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pãi te'ena ija'che i'kaasome: —Vati chʉ̃'ʉkʉji Beelzebuji cho'okaiʉna vati ũcuajanare eto saokʉ'mʉ ikʉ Jesús —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jã'aja'ñe i'karena chekʉna Jesús masiche'te masiñu chini ija'che i'kaasome: —Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jã'aja'ñe i'kajʉna Jesús repana cuasajʉ cutuche'te masikʉ ija'che i'kaasomʉ repanare: —Pãi ũcuate'echeja pa'inapi sãiñechi'a cavani vaijʉ si'asõjanaa'me. Ũcuachi'a majapãichi'api ũcuate'evʉ'e pa'inapi sãiñechi'a cavani majapãi sẽjosõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ũcuachi'a vati aipi repaʉ neenana'me sãiñechi'a cavato repaʉ chʉ̃'ʉñe si'asõmʉ. Jã'ata'ni mʉsanʉkona chʉ'ʉre, “Vati chʉ̃'ʉkʉji Beelzebuji vati ũcuajanare eto saomasiche jo'kasi'kʉa'mʉ mʉ'ʉre”, chiime. ");
INSERT INTO coe_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jã'aja'ñe mʉsanʉkonapi i'karena iere sẽemʉ chʉ'ʉ: Mʉsanʉkona neenare, ¿jaʉpi vati eto saomasiche jo'kaʉ? ¿Vati aipi jo'kaʉ? Ija'che chiijʉ sẽejʉ̃'ʉ repanare: “¿Vati eto saomasiche vati aipi jo'kaʉ mʉsanʉkonare?”, chiijʉ̃'ʉ. Jã'aja'ñe sẽeto repana mʉsanʉkonare, “Rũhiñe cuasama'me mʉsanʉkona”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Chʉ'ʉ vati eto saomasiche Dios jo'kasi'ea'me. Chʉ'ʉpi Dios jo'kasi'ere cho'okʉna ña, “Dios pãi ũcuanʉkore chʉ̃'ʉkʉ'mʉ”, chiijʉ masijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Pãiʉ rʉa kokaʉji rʉa vaiche paakʉji repaʉ vʉ'ere pẽ'jeto repaʉ cu'amajñarʉã ñaacu'amʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","“Vaiche'te paakʉna chʉ'ʉ neemajñarʉã ñaamanejanaa'me pãi chʉ'ʉre”, chini cuasakʉ pojomʉ repaʉ. Jã'ata'ni repaʉ'te na'a rʉa koka paakʉji rani, repaʉ'te vani kʉkosõ, repaʉ paakʉ pojosi'e vaichena'me cu'amajñarʉã tʉtesõja'mʉ repaʉ'te. Tʉtesõ repaʉ neenani ĩsija'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Chini ija'che i'kaasomʉ repaʉ: —Pãi chʉ'ʉre jovomana cuheme chʉ'ʉre. Cuhejʉ chekʉnapi chʉ'ʉni jovoñu chiito ʉ̃seme repana, chʉ'ʉni jovomanea'jʉ chini —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ũcuarʉmʉ Jesús repanare pãi jo'e ija'che i'kaasomʉ: —Pãiʉ sa'navʉ pa'isi'kʉni etosõru vati sani oko peochejñare ku'iʉ pa'imʉ pʉachejñare ku'ekʉ. Jã'ata'ni jñaamaneni, “Chʉ'ʉ vʉ'eja'chena co'ira pãiʉ sa'navʉna”, chini cuasamʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jã'aja'ñe cuasa repaʉ co'i ñato pãiʉ sa'navʉ vʉ'e jʉ'o care'vasivʉ'eja'che re'oja'imʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jã'aja'ñere rani ña jo'e sani chekʉnare vati repaʉ'te na'a rʉa cu'anani sieterepanare ku'e jñaa ra pãiʉ sa'navʉna pañu chini ũcuanʉko kakame repana. Jã'ajekʉna pãiʉ aperʉmʉ cu'ache pa'isi'e na'a rʉa cu'ache pa'imʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jã'aja'ñe i'katona pãina'me pa'ikoji romio ʉjachʉ'opi i'kaasomo Jesure. —Mʉ'ʉre jñaa jojasi'ko rʉa pojoko pa'icosomo —chiniasomo. ");
INSERT INTO coe_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chikona i'kaasomʉ repaʉ. —Ũcuarepaa'me jã'a. Pojoko pa'imo repao. Jã'ata'ni Dios chʉ'o asa jachama'ñe cho'ona repao'te na'a rʉa pojojʉ pa'ime —chiniasomʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ũcuarʉmʉ Jesús pãipi repaʉ pa'ichejana chi'irena ija'che i'kaasomʉ repanare: —Pãi irʉmʉ cana cu'ache pa'inaa'me. Chʉ'ʉre, “Dios Raosi'kʉma'mʉ Jesús”, chiime repana. Jã'ata'ni, “Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te”, chiime repana, chʉ'ʉ pa'iche'te masiñu chini. Jã'ata'ni cho'o ñoma'mʉ chʉ'ʉ repanare. Jonás cho'ocojñosi'eja'chechi'a cho'ocojñoja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aperʉmʉ Níneve vʉ'ejoopo pa'isina Jonás cho'ocojñosi'ere asa, “Dios raosi'kʉcosomʉ jã'ʉ”, chiniasome. Chʉ'ʉ Dios Raosi'kʉ Jonás cho'ocojñosi'eja'che cho'ocojñoja'mʉ, pãipi asa, “Jesús Dios Mamakʉ'mʉ”, chiijʉ cuasaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aperʉmʉ pa'isi'ko sʉripʉ cakã'ko canare pãi chʉ̃'ʉsi'ko rʉa so'opi Salomón rʉa masiʉ chʉ'vache'te asara chini raniasomo. Repaʉ'te Salomon'te na'a rʉa masiʉji ichejare pa'imʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ chʉ'vache asacuheme mʉsanʉkona irʉmʉ cana. Jã'ajekʉna Dios pãi ũcuanʉko cho'oche ña ro'iche chʉ̃'ʉumucuse tĩ'aru aperʉmʉ pa'io pãi chʉ̃'ʉsi'kopi ija'che i'kaja'mo mʉsanʉkonare, irʉmʉ pa'ijʉ chʉ'ʉre cuasamanesinare: “Cu'are cho'ojʉ Diore cuasamanesinajejʉ ro'ijʉ pa'ijanaa'me mʉsanʉkona”, chiija'mo. ");
INSERT INTO coe_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aperʉmʉ Jonapi rʉa masiʉji Dios chʉ'ore chʉ'vakʉna asa chẽa, Níneve vʉ'ejoopo pa'isina repana cu'ache cho'oche ũhasõasome. Repaʉ'te Jonare na'a rʉa masiʉji ichejare pa'imʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ chʉ'vache asacuheme mʉsanʉkona irʉmʉ cana. Níneve vʉ'ejoopo pa'isina cu'ache cho'oche ũhasõsi'eja'che cu'ache ũhasõmanaa'me mʉsanʉkona irʉmʉ cana. Jã'ajekʉna Dios pãi ũcuanʉko cho'osi'e ña ro'iche chʉ̃'ʉumucuse tĩ'aru Níneve vʉ'ejoopo pa'isinapi ija'che i'kajanaa'me mʉsanʉkonare irʉmʉ pa'inare: “Cu'ache cho'oche ũhasõmanesinajejʉ ro'ijʉ pa'ijanaa'me mʉsanʉkona”, chiijanaa'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ũcuarʉmʉ Jesús repanare pãi jo'e i'kaasomʉ. —Pãi te'eʉjẽ'e ʉotʉopʉ chʉ̃oni chave nʉkoma'me. Ũcuachi'a totoroji jao nʉkoma'me. Jã'ata'ni, “Pãi ivʉ'ena kakani chija'iʉna ñamanejanaa'me”, chini ʉotʉopʉ chʉ̃o, ʉmʉna tʉomʉ re'oja'che miakʉna ñaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mʉsanʉkona ñakocaã masi ñoto cho'oche cho'ore'omʉ. Jã'ata'ni ñakocaãpi masi ñoma'to cho'oche cho'ocu'amʉ. Ũcuaja'che mʉsanʉkonapi re'oja'che cuasani re'oja'chechi'a cho'ojʉ pa'ijanaa'me. Cu'ache cuasani cu'achechi'a cho'ojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pãi Dios chʉ'o masinapi Repaʉ'te cuasamaneni chijacheja pa'inaja'ñe cu'ache pa'ime repana rekoñoã. Jã'ajekʉna ñarepajʉ pa'ijʉ̃'ʉ mʉsanʉkona, jã'aja'ñe pa'imaneñu chini. ");
INSERT INTO coe_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mʉsanʉkonapi Dios chʉ'o asa cuasato rʉa re'oja'che pa'ija'mʉ mʉsanʉkona rekoñoã. Ʉotʉopʉ re'oja'che miañeja'ñe re'oja'che pa'ija'mʉ mʉsanʉkona rekoñoã —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jã'aja'ñe i'ka pi'niʉna fariseopãiʉ, “Chʉ'ʉ vʉ'ena mʉa ãu ãijʉ̃'ʉ”, chiniasomʉ Jesure. Chikʉna mʉa kaka ãure ãsa chini mesako'are pʉʉ ñuniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ãu ãipi'rakʉta'ni charo Jesupi repaʉ jʉ̃jñare choamaʉna ña, “Aipãi chʉ̃'ʉ jo'kasi'e cho'oma'mʉ ikʉ”, chini cuasa, kʉkʉasomʉ fariseopãiʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kʉkʉsokʉna ña Jesús ija'che i'kaasomʉ repaʉ'te: —Mʉsanʉkona fariseopãi rekoñoã cu'ache cuasache jo'kasõmanajejʉ cʉnaro'rona'me cʉnare'a sẽ'sevʉãchi'a sosajʉ sa'navʉã sosama'ñeja'ñe sẽ'sevʉchi'a re'onaja'ñe cho'ojʉ chekʉna nee jorejʉ tʉte paanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Rʉa vesʉnaa'me mʉsanʉkona. Sẽ'sevʉ pa'ichechi'a cho'oma'ñe sa'navʉquee ũcuachi'a cho'osi'kʉa'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ija'che cho'ojʉ pa'ijʉ̃'ʉ mʉsanʉkona: Pãi chʉova'na pa'iva'nare ña oijʉ cu'amajñarʉã ũcuaʉamajñarʉãre re'ojamajñarʉãre ĩsijʉ̃'ʉ repanare. Mʉsanʉkonapi jã'aja'ñe pãire oijʉ pani rekoñoã re'oja'che cuasani sẽ'sevʉ ũcuaja'che re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Mʉsanʉkona, fariseopãi, Dios chʉ̃'ʉ jo'kasi'ere cho'ojʉ ja'orʉã ãu va'isʉche maña kua'koja'orʉãre si'arʉmʉ ĩsijʉ pa'inaa'me, Repaʉ, “Chʉ'ʉre ĩsijʉ̃'ʉ”, chiisinʉkorʉ. Chekʉrʉmʉ dierepaja'orʉã paani te'eja'orʉ ĩsime. Chekʉrʉmʉ cienrepaja'orʉã paani dierepaja'orʉã ĩsime. Jã'achi'a ĩsinaa'me mʉsanʉkona. Jã'ata'ni chekʉnare ũcuarepa cho'omanaa'me mʉsanʉkona. Diore ũcuaja'che masi cuasamanaa'me mʉsanʉkona. Cu'amajñarʉã ũcua ĩsijʉ pa'ijʉ̃'ʉ Diore. Re'omʉ jã'a. Jã'ata'ni mʉsanʉkonapi chekʉnani ũcuarepa cho'omapʉna cu'amʉ. Ũcuachi'a Dioni masi cuasamapʉna cu'amʉ. Jã'ajekʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Ũcuaja'che mai judíopãi chi'ivʉ'ña mʉa kakani pa'ipãi ñu'isaivʉãre ñu'ineeme mʉsanʉkona. Ũcuaja'che ãu ĩsichejñare mʉsanʉkonapi ku'ijʉna pãipi ña kʉkʉjʉ sẽejʉna rʉa pojonaa'me mʉsanʉkona. Jã'aja'ñe pa'ijʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Pãiʉ'te jũ'isi'kʉre tãsichejare catapʉ tochasi'pʉre nʉkoma'to ñomaʉna vesʉjʉ ũcuachejapi cha'cajʉ ku'ime pãi. Mʉsanʉkona fariseopãi ũcuaja'che cu'ache pa'inata'ni pãipi ñato re'oja'che pa'inaja'ñe ñome. Chekʉna pãi mʉsanʉkona cu'ache cuasache vesʉme. Jã'aja'ñe pa'ijʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare judíopãi che'chonana'me fariseopãi —chiniasomʉ Jesús fariseopãiʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jã'aja'ñe i'kaʉna asa Dios chʉ̃'ʉsi'e che'chokʉ i'kaasomʉ Jesure. —Masiʉ, mʉ'ʉpi jã'aja'ñe i'kakʉ chʉkʉna'te ũcuaja'che Dios chʉ̃'ʉsi'e che'chonani cu'ache i'kamʉ mʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chikʉna asa Jesús jo'e i'kaasomʉ repaʉ'te. —Mʉsanʉkona Dios chʉ̃'ʉsi'e che'chona cho'okaimanata'ni chekʉnare rʉa si'ache cho'ovesache'te chʉ̃'ʉnaa'me. Jã'aja'ñe cho'ojʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Aperʉmʉ Dios chʉ'o kʉasinare mʉsanʉkona aipãipi vanisõrena repanare tãsichejña sẽ'sevʉãre re'ojachejña care'vajʉ pa'ime mʉsanʉkona, pãipi ña, “Dios chʉ'o kʉajʉ chuenisõsinare oime ina”, chiapʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jã'ata'ni repana kʉajʉ chʉ̃'ʉsi'e re'oja'che cho'omanaa'me mʉsanʉkona. Mʉsanʉkona aipãipi repanare vanisõrena repanare tãsichejñare re'ojachejña care'vajʉ mʉsanʉkona aipãi cu'ache cho'osi'eja'che cho'ome mʉsanʉkona. Jã'aja'ñe cho'ojʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Dios peore Masikʉjekʉ aperʉmʉ ija'che i'kaasomʉ mʉsanʉkona cho'ojache: Chʉ'ʉ chʉ'o kʉajanana'me che'chojanare chẽa saoja'mʉ chʉ'ʉ pãire chʉ'vaa'jʉ chini. Saoʉna repanani cuhejʉ cu'ache cho'oñu chini tuhajanaa'me pãi. Tuha te'enare vanisõjanaa'me repana, chiniasomʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cheja mamacheja pa'irʉmʉpi irʉmʉjatʉ'ka Dios chʉ'o kʉanani mʉsanʉkona majapãipi vanisõjʉna mʉsanʉkona irʉmʉ canapi repana cho'osi'eja'che cu'ache cho'onajejʉ ro'ijanaa'me, repanare vanisõsi'e ro'i. ");
INSERT INTO coe_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aperʉmʉ mʉsanʉkona majapãi Dios vʉ'ere pa'ijʉ Diore ĩsisimajñarʉã ʉochejana Zacaría'te vanisõasome. Abelre vanisõsirʉmʉpi Zacaría'te vanisõrʉmʉjatʉ'ka Dios chʉ'o kʉanare mai aipãipi vanisõrena mʉsanʉkona irʉmʉ canapi ro'ijanaa'me, repanare vanisõsi'e ro'i. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mʉsanʉkona Dios chʉ̃'ʉñe che'chona Dios chʉ'o masinata'ni masi cho'oma'me. Ũcuaja'che chekʉnapi asa chẽapi'ranapi cho'ovesʉa'jʉ chini masi che'chomanaa'me mʉsanʉkona. Jã'aja'ñe cho'ojʉna rʉa cu'ache ti'jñeja'mʉ mʉsanʉkonare Dios chʉ̃'ʉñe che'chonare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","I'ka pi'ni fariseopãiʉ vʉ'e pa'isi'kʉpi etaasomʉ Jesús. Etaʉna judíopãi che'chonana'me fariseopãi pe'rujʉ cu'ache i'kaasome repaʉ'te Jesure. Repaʉji tĩiñe i'kaʉna chẽañu chini chʉ'o rʉa vesache'te si'ache sẽniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ũcuarʉmʉ pãi kuẽkuecu'anʉko rʉa jainʉko chi'iasome. Jairepanʉkojejʉ ũcuajana cũ'ana cha'caasome repana. Chi'irena Jesús repaʉ neenani charo chʉ'vaasomʉ. —Asarepajʉ̃'ʉ, mʉsanʉkona. Fariseopãi pã saʉcheja'che pa'iche'te ña chẽamanejʉ̃'ʉ mʉsanʉkona. Repana cu'ache pa'iche'te i'kamʉ chʉ'ʉ. Repana fariseopãi pãipi ñato re'oja'che pa'ina cho'ocheja'che sẽ'sevʉchi'a re'oja'che cho'ojʉ pa'inaa'me. Jã'ata'ni repana rekoñoã rʉa cu'ache pa'inaa'me. ");
INSERT INTO coe_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","’Na'a pa'isirʉmʉ pãi rope'e cu'ache cho'osi'e peore kʉajachea'me. Ũcuaja'che pãi cu'ache cuasasi'e peore kʉajachea'me. ");
INSERT INTO coe_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pãi ñamina rope'e kʉasi'e umucusena peore kʉajachea'me, pãi ũcuanʉko asajʉ'te. Ũcuaja'che pãi repana vʉ'ena kaka rope'e kʉasi'e pãi ũcuanʉko pa'ichejana ʉjachʉ'opi peore kʉajachea'me —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ũcuarʉmʉ Jesús repanare pãi jo'e i'kaasomʉ. —Mʉsanʉkonare, chʉ'ʉre ja'me pa'inare ija'chere chʉ'vamʉ chʉ'ʉ: Mʉsanʉkonare vanisõñu chiinare vajʉchʉmanejʉ̃'ʉ. Mʉsanʉkona ca'nivʉã vanisõni rekoñoãta'ni cu'ache cho'oma'me repana. ");
INSERT INTO coe_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Diore vajʉchʉjʉ pa'ijʉ̃'ʉ”, chiimʉ chʉ'ʉ mʉsanʉkonare. Repaʉ Dios mʉsanʉkona jũ'iñe chʉ̃'ʉkʉ'mʉ. Ũcuaja'che jũ'iñe chʉ̃'ʉʉna jũnisõsirʉmʉ Repaʉ'te cuasamanare vati toana saokʉ'mʉ Repaʉ. Jã'ajekʉna Dioni vajʉchʉjʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Dios Repaʉ neenare kuirache'te kʉara chiimʉ chʉ'ʉ mʉsanʉkonare. Pĩ'a cincorepava'na jmava'na kurire're te'eka'chapare'rerʉãchi'a ro'ime. Ka'charʉ ro'iva'nareta'ni Dios te'eʉ'terejẽ'e cavesʉma'kʉa'mʉ repava'nare. ");
INSERT INTO coe_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Peore repava'nare pĩ'ava'nare cuasakʉ kuirakʉ'mʉ Dios. Mʉsanʉkonare pãi na'a rʉa cuasakʉ na'a re'oja'che kuirakʉ'mʉ Repaʉ. Mʉsanʉkona sĩjoquee raña kuẽkuesi'echi'a paakʉjekʉ masimʉ Repaʉ Dios. Mʉsanʉkona pa'iche peore masimʉ Repaʉ. Jã'ajekʉna mʉsanʉkona chekʉnare pãi vajʉchʉmanejʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ũcuarʉmʉ Jesús jo'e ija'che i'kaasomʉ repanare: —Chʉ'o chekere kʉara chiimʉ chʉ'ʉ mʉsanʉkonare: Pãi te'ena, chekʉna asajʉ'te vajʉchʉma'ñe, “Jesure cuasanaa'me chʉkʉna”, chiime. Na'a pa'isirʉmʉ jã'aja'ñe i'kasinare Diore ja'me pa'ina ángeles asajʉ'te, “Chʉ'ʉ neenaa'me ina”, chiija'mʉ chʉ'ʉ Dios Raosi'kʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jã'ata'ni chekʉna pãi ija'che cho'ome: Chekʉnapi asajʉ chini, chʉ'ʉre cuasanata'ni pãire vajʉchʉjʉ, “Jesure cuasamanaa'me chʉkʉna”, chiime. Na'a pa'isirʉmʉ jã'aja'ñe i'kasinare, Diore ja'me pa'ina ángeles asajʉ'te, “Chʉ'ʉ neenama'me ina”, chiija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Chʉ'ʉre, Dios Raosi'kʉre pãi cu'ache cutuche jo'e cuasamaneja'mʉ Dios. Jã'ata'ni Repaʉ Rekocho'te pãi cu'ache cutucheta'ni cavesʉma'ñe cuasamʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Chekʉrʉmʉ pãi mʉsanʉkonare chʉ'ʉni cuasajʉna chẽa mai judíopãi chi'ivʉ'ena juha cuaa nʉkojanaa'me, chekʉnapi cu'ache cho'oa'jʉ chini. Chekʉrʉmʉ pãi mʉsanʉkonare chẽa pãi chʉ̃'ʉna pa'ivʉ'ena juha cuaa nʉkojanaa'me, repanapi cu'ache cho'oa'jʉ chini. Repanapi, “Chʉkʉnani cu'ache i'kato, ¿je'se chʉkʉna i'ka tʉijanaa'ñe?”, chiijʉ cuasamanejʉ̃'ʉ. Mʉsanʉkona i'kajache cuasamanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mʉsanʉkona i'karʉmʉ tĩ'aru Dios Rekochoji kʉaja'mʉ mʉsanʉkonare, masi i'kaa'jʉ chini —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ũcuarʉmʉ repanare pãi ja'me pa'ikʉji i'kaasomʉ Jesure. —Masiʉ, cho'okaijʉ̃'ʉ chʉ'ʉre. Chʉkʉna ja'kʉ chuta'a jũ'imarʉmʉ ija'che i'kasi'kʉa'mʉ chʉkʉna'te, chʉ'ʉna'me a'chʉre: “Chʉ'ʉ jũnisosirʉmʉ chʉ'ʉ paasi'e chejana'me põse mʉsanʉkona ka'chana paajʉ̃'ʉ”, chiisi'kʉa'mʉ ja'kʉ. Chura ja'kʉva'ʉ jũnisocuhasi'kʉa'mʉ. Jã'ajekʉna chʉ'ʉ a'chʉre i'kakaijʉ̃'ʉ, ja'kʉ i'kasi'e cho'oa'kʉ, joopo ĩsia'kʉ chʉ'ʉre —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Tĩiñe i'kamʉ mʉ'ʉ. Pãi mʉsanʉkona ke'reche'te care'vaa'kʉ chini raomanesinaa'me chʉ'ʉre. Ũcuaja'che mʉja'kʉ jo'ka jũnisõsimajñarʉãre joopoãchi'a paache'te chʉ̃'ʉa'kʉ chini raomanesinaa'me chʉ'ʉre —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chini Jesús jo'e i'kaasomʉ repanare pãi. —Asarepajʉ̃'ʉ, mʉsanʉkona. Kurina'me si'ache paaneemanejʉ̃'ʉ mʉsanʉkona. Pãi, “Kurina'me põse si'ache paajʉ rʉa re'oja'che pa'ijanaa'me chʉkʉna”, chiime te'ena. Jã'ata'ni re'oja'che pa'iche kuripi kooma'ñea'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chini repanani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ repaʉ: —Pãiʉ kuriʉ cheja re'ojacheja paaasomʉ. Repaʉ tãsi'epi ãupi rʉa aineeʉna ãu rʉa paaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ãure rʉa paakʉ te'eʉji ija'che cuasakʉ i'kaasomʉ repaʉ: “Chʉ'ʉ ãumajñarʉã care'vavʉ'ñapi timusõʉna jo'e ãu care'vavʉ'ña peomʉ chʉ'ʉ. ¿Je'se cho'oja'che chʉ'ʉ?”, chiiʉ cuasaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jã'aja'ñe cuasakʉ, “Ãa, ija'che cho'ora chʉ'ʉ: Chʉ'ʉ ãumajñarʉã care'vavʉ'ñare peore ñañosõ, jo'e na'a ʉjavʉ'ña cho'ora. Cho'o pi'ni ãuna'me põse peore ũcuavʉ'ñana care'vara chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Peore care'va pi'ni te'eʉji ija'che i'kaja'mʉ chʉ'ʉ: Rʉa põse paamʉ chʉ'ʉ. Rʉa jeerʉmʉ si'amaneja'mʉ ie. Jã'ajekʉna rupʉ pa'ija'mʉ chʉ'ʉ chura. Ãu ãiʉ, cono ũkukʉ pojokʉ pa'ija'mʉ chʉ'ʉ chura”, chiiʉ cuasaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jã'aja'ñe cho'ora chiisi'kʉre ija'che i'kaasomʉ Dios: “Tĩiñe cuasamʉ mʉ'ʉ. Iñami jũnisõja'mʉ mʉ'ʉ. Mʉ'ʉ te'eʉ paakʉ pojora chini care'vasimajñarʉã peore cho'osõja'mʉ. Chekʉnapi mʉ'ʉ paasi'e paajanaa'me”, chiniasomʉ Dios repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pãi te'ena Dioni cuasamapʉ repanapi te'ena pojoñu chini põsena'me kuri si'ache rʉa care'vame. Diore cuasamanesinajejʉ peore cho'osõjanaa'me repana —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ũcuarʉmʉ Jesús repaʉ neenani chʉ'vaasomʉ. —Mʉsanʉkona pa'ichena'me ãu ãiñena'me kãña ju'iche rʉarepa cuasajʉ pa'imanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dios, mʉsanʉkonare kuirakʉ ãuna'me kãña mʉsanʉkona ju'ijache ĩsikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pĩ'ava'na pa'iche'te cuasa ñajʉ̃'ʉ. Pĩ'ava'na ãujẽ'e tãmava'naa'me. Ĩsichejẽ'e cho'omava'naa'me. Ãu care'vavʉ'ñajẽ'e peova'naa'me repava'na. Jã'aja'ñe pa'iva'nareta'ni Diopi ãu ĩsikʉ'mʉ repava'nare. Repaʉ Dios pĩ'ava'nare peore cuasakʉ rʉa re'oja'che kuirakʉ'mʉ. Jã'ata'ni mʉsanʉkonare pãi na'a rʉa cuasakʉ na'a re'oja'che kuirakʉ pa'imʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ija'chea'me: Chekʉrʉmʉ pãi repana ʉmʉ nʉkache rʉa cuasajʉ, “Na'a ʉmʉ ainee nʉkajanaa'me mai”, chiijʉ na'a ʉmʉ nʉkache chiinareta'ni na'a ʉmʉ nʉkacu'aja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mʉsanʉkonare pa'iche ĩsimʉ Dios. Cho'ovesama'mʉ Repaʉ'te. Jã'ata'ni mʉsanʉkonare jã'aja'ñe cho'ocu'amʉ. Repaʉ Dios mʉsanʉkonare pa'iche ĩsisi'kʉa'mʉ. Pa'iche ĩsisi'kʉjekʉ mʉsanʉkonare kuirakʉ'mʉ Repaʉ. Jã'ajekʉna mʉsanʉkona ãu ãiñena'me kãña ju'iche rʉarepa cuasama'ñe pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Chura korosi'e pa'iche'te cuasa ñajʉ̃'ʉ. Korosi'e cho'ochejẽ'e cho'oma'ñea'me. Kãñajẽ'e juhama'ñea'me. Aperʉmʉ pa'iʉ pãi chʉ̃'ʉsi'kʉ Salomón ju'isikãña kãña repaʉji rʉa re'ojakãñare koo ju'iʉna rʉa re'oja'che ñoasomʉ, pãipi ñato. Jã'ata'ni Salomón ju'isikãña pa'icheja'che na'a rʉa re'oja'che ñomʉ korosi'e. Dios cho'oche'me jã'a. ");
INSERT INTO coe_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diore rʉa cuasama'me mʉsanʉkona. U'chara'ñʉrʉã iumucujña pa'ira'ñʉrʉãre pãipi ʉosõru che'ro peoja'mʉ. Rʉa jeerʉmʉ pa'imara'ñʉrʉãta'ni repara'ñʉrʉã re'oja'che kuirakʉ'mʉ Dios. Mʉsanʉkonare pãi na'a rʉa re'oja'che kuiramʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jã'ajekʉna mʉsanʉkona ãu ãijañena'me ũkujache si'areparʉmʉ cuasama'ñe pa'ijʉ, “Chʉkʉna chiiche peore ĩsikʉ'mʉ Dios”, chiijʉ cuasajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pãi Diore cuasamana jã'amajñarʉãchi'a si'arʉmʉ rʉa cuasajʉ pa'ime. Jã'ata'ni mʉsanʉkona chiimajñarʉã, “Ina chʉ'ʉre cuasana jã'amajñarʉãre chiime”, chiiʉ masimʉ mai Ja'kʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jã'ajekʉna jã'amajñarʉã rʉarepa cuasama'ñe pa'ijʉ Repaʉ chʉ̃'ʉñe'te na'a rʉa cuasajʉ cho'ojʉ pa'ijʉ̃'ʉ. Ũcuare Repaʉ mʉsanʉkonare ãuna'me ũkuche peore ĩsimʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ũcuarʉmʉ Jesús repaʉ neenare jo'e chʉ'vaasomʉ. —Te'eva'naa'me mʉsanʉkona. Jã'ata'ni pãi ovejava'nare re'oja'che kuiracheja'che re'oja'che kuiramʉ chʉ'ʉ mʉsanʉkonare. Jã'ajekʉna vajʉchʉmanejʉ̃'ʉ. Mai Ja'kʉ Dios re'oja'chere ĩsija'mʉ mʉsanʉkonare, Repaʉ pa'ichejana satena. Jã'aja'ñe cho'ora chiimʉ Dios mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ija'che cho'ojʉ̃'ʉ: Mʉsanʉkona paamajñarʉã te'emajñarʉã ĩsisõ, kuri koo, chʉova'na pa'iva'nani rupʉ ĩsijʉ̃'ʉ. Mʉsanʉkona icheja cheja paamajñarʉã cu'amajñarʉã si'asõjañea'me. Jã'ajekʉna repamajñarʉã rʉarepa cuasamairo pa'ijʉ Dioni na'a rʉa cuasajʉ, Repaʉ pa'icheja sani re'oja'che koojachere na'a rʉa cuasajʉ pa'ijʉ̃'ʉ. Repaʉ ĩsicheta'ni si'ama'ñea'me. Jeecheja põse ñaanajẽ'e peome. Ũcuachi'a pãi paache pu'java'najẽ'e peome. ");
INSERT INTO coe_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dios ĩsijache koojanajejʉ pojojʉ pa'ijʉ̃'ʉ mʉsanʉkona. Mʉsanʉkonapi põsechi'a na'a rʉa cuasajʉ pani Dios ĩsijache rʉa cuasamanejanaa'me —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ũcuarʉmʉ Jesús repaʉ neenani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ: —Pãiʉ cho'oche cho'okainare paakʉji pãi romi vejache'te ñara chini saniasomʉ. Sakʉna repaʉ'te cho'oche cho'okaina, “Maire paakʉ jo'e raija'mʉ”, chini cha'ajʉ cho'oche cho'okãña sa'che, ʉopʉã chʉ̃o, peore care'vakaijʉ paniasome repaʉ'te. Ũcuarʉmʉ repana repaʉni cha'ajʉ care'vasinajejʉ repaʉji rakʉna vajʉchʉma'ñe jatisa'aro teana vataasome. ");
INSERT INTO coe_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cho'oche cho'okainapi kãima'ñe repanare paakʉni cha'ajʉ peore re'oja'che care'varu rani ña rʉa pojoja'mʉ repaʉ. Cho'oche cho'okainare kãima'ñe care'vakaisinajejʉna ña pojokʉ re'oja'che cho'okaija'mʉ repanare paakʉ. Charo cho'oche cho'okãña sa'che, repanare soni rao, pʉʉrena ãu ãuja'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Cho'oche cho'okaina masi care'varu repaʉ'te ʉarʉmʉ, chekʉrʉmʉ ñamirepana, chekʉrʉmʉ ñatacuhatona rani ña pojokʉ re'oja'che cho'okaija'mʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Iere asa chẽajʉ̃'ʉ mʉsanʉkona: Pãiʉ vʉ'e paakʉ ñaaʉ rairʉmʉ masini pẽ'jemʉ, ñaaʉ kakache'te ʉ̃sera chini. ");
INSERT INTO coe_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chʉ'ʉ raiche mʉsanʉkona cuasamarʉmʉna icheja cheja jo'e cajeja'mʉ chʉ'ʉ, Dios Raosi'kʉ. Jã'ajekʉna vʉ'e paakʉ pẽ'jeñeja'ñe chʉ'ʉ cajejachere pẽ'jejʉ mʉsanʉkona rekoñoã re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesupi cuasakʉ kʉaʉna asa Pedro ija'che sẽniasomʉ repaʉ'te: —Chʉkʉna'te Paakʉ, ¿chʉkʉna'te mʉ'ʉ neenarechi'a chʉ'vakʉ cuasakʉ kʉaʉ mʉ'ʉ? Jã'apãani, ¿pãi ũcuanʉkore chʉ'vakʉ kʉaʉ mʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Cho'oche cho'okaikʉ cho'osi'ere kʉara chiimʉ chʉ'ʉ. Cho'oche cho'okaikʉ rũhiñe cuasakʉjekʉ repaʉ'te paakʉ chʉ̃'ʉ jo'kasi'e ũcuarepa cho'oasomʉ. Jã'aja'ñe cho'oʉna repaʉ'te paakʉ so'ona saipi'rakʉ ũcuaʉni cho'oche jo'kaasomʉ, chekʉnani cho'oche cho'okainani kuirakʉ repana ãijañere ãure ĩsikʉ paaʉ chini. Repanare jo'ka so'ona sanisõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","So'o saisi'kʉpi jo'e na'a pani rani ñato repaʉ'te cho'oche cho'okaikʉ, repaʉ chʉ̃'ʉ jo'kasi'e re'oja'che cho'okaniasomʉ. Re'oja'che cho'okakʉna repaʉ'te paakʉ rani ña pojokʉ repaʉ paakʉ chʉ̃'ʉsi'e cho'oche peore ũcuaʉni jo'kaasomʉ. Jã'aja'ñe jo'kaʉna rʉa pojoasomʉ repaʉ'te cho'oche cho'okaikʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Jã'ata'ni cho'oche cho'okaikʉji ija'che cho'oto cu'ache ti'jñera'amʉ repaʉ'te: “Chʉ'ʉre paakʉ, so'o saisi'kʉ chuta'a raima'mʉ”, chini repaʉ'te ja'me cho'oche cho'okainare ʉmʉpãina'me romi vaiʉ ũcuaja'che repaʉ'te paakʉ neere ãu rʉa ãiʉ rʉa cono jũ'iʉ repaʉ'te paakʉ raichejẽ'e cuasama'ñe pa'ikʉni raija'mʉ repaʉ. Rani ña rʉa pe'rukʉ repaʉ'te cu'ache cho'o pi'ni jachanare saochejana saoja'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ija'chea'me: Cho'oche cho'okaina ũcuaʉana repanare paakʉ chʉ̃'ʉ jo'kasi'e masinata'ni cho'omaneni rʉa suĩ'suecojñojanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Chekʉna repanare paakʉ chʉ̃'ʉ jo'kasi'ere vesʉjʉ tĩiñe cho'oni jmanʉkorʉ suĩ'suecojñojanaa'me. Pãiʉ repaʉ'te cho'oche cho'okainare rʉa masinare, “Chʉ'ʉ chʉ̃'ʉsi'e masi cho'ojʉ̃'ʉ mʉsanʉkona”, chiija'mʉ. Chekʉnareta'ni ija'che i'kaja'mʉ: “Mʉsanʉkona na'a rʉa masinaa'me. Na'a rʉa masinajejʉ chʉ'ʉ chʉ̃'ʉsi'e na'a rʉa masi cho'ojʉ̃'ʉ mʉsanʉkona”, chiija'mʉ repanare paakʉ —chiniasomʉ Jesús repaʉ'te Pedro'te. ");
INSERT INTO coe_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ. —Pãiʉ chĩ'care cuhekʉ toapi peore ʉosõñeja'ñe pãi rekoñoã cu'ache cho'oche'te cuhekʉ jũni ro'ikasa chini cajesi'kʉa'mʉ chʉ'ʉ. Irʉmʉna jã'aja'ñe cho'o pi'nisi'e pa'itota'ni pojora'amʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Rʉa cu'ache ti'jñeja'mʉ chʉ'ʉre. Jã'ajekʉna rʉa sʉmava'ʉ chʉova'ʉ pa'iʉ pa'ija'mʉ chʉ'ʉ, chʉ'ʉre cu'ache ti'jñe caraisirʉmʉjatʉ'ka. ");
INSERT INTO coe_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ija'che cuasacosome mʉsanʉkona: “Jesupi rakʉna churata'ni pãi cavama'ñe re'oja'che pa'ijanaa'me”, chiijʉ cuasacosome. Jã'ata'ni chʉ'ʉpi rani che'chokʉna pãi chʉ'ʉ che'choche asacuhenapi asaneenani pe'rujʉ cuheme. ");
INSERT INTO coe_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chekʉrʉmʉ majapãi cincorepana ũcuate'evʉ'e pa'inapi te'ena chʉ'ʉni cuasato chekʉna cuhejanaa'me repanare. Chekʉrʉmʉ te'eka'chapana chʉ'ʉni cuasato chotena cuhejanaa'me. Chekʉrʉmʉ chotena chʉ'ʉni cuasato te'eka'chapana cuhejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chekʉrʉmʉ mamakʉji chʉ'ʉni cuasato pʉka'kʉpi cuheja'mʉ. Ũcuaja'che pʉka'kʉpi chʉ'ʉni cuasato mamakʉji cuheja'mʉ. Ũcuaja'che mamakoji chʉ'ʉni cuasato pʉka'kopi cuheja'mo. Ũcuaja'che pʉka'kopi chʉ'ʉni cuasato mamakoji cuheja'mo. Ũcuaja'che mamakʉ'te pa'ikoji chʉ'ʉni cuasato vaoji cuheja'mo. Ũcuaja'che vaoji chʉ'ʉni cuasato mamakʉ'te pa'ikoji cuheja'mo. Chʉ'ʉre cuasamana pãi jã'aja'ñe cho'ojanaa'me chʉ'ʉre cuasanare —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare pãi. —Ʉ̃sʉʉ na'ichejapi oko ka'nikʉna ñani, “Oko raja'mʉ iumucuse”, chini cuasa i'kame mʉsanʉkona icheja cana. Mʉsanʉkona i'kasi'e ti'jñemʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ũcuaja'che sʉripʉ cakã'kopi tutache ñani, “Rʉa asuja'mʉ iumucuse”, chini cuasa i'kame mʉsanʉkona icheja cana. Mʉsanʉkona i'kasi'e ti'jñemʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cʉnaʉmʉ ñani umucuse pa'ijache cuasa i'kamasime mʉsanʉkona. Jã'ata'ni irʉmʉ pa'iche ñanata'ni mʉsanʉkonare ti'jñejañe vesʉme. “Icheja pa'iche peore masime chʉkʉna”, chiime mʉsanʉkona. Jã'ata'ni joreme —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ũcuarʉmʉ jo'e i'kaasomʉ repaʉ. —¿Je'se pa'iʉna cu'ache pa'iche mʉsanʉkonachi'a ña care'vavesʉche? ");
INSERT INTO coe_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chekʉrʉmʉ pãi ũcuaʉakʉji chekʉni põsero'i paamʉ. Jã'ata'ni repaʉji ro'ima'to pe'rukʉ ro'ia'kʉ chini pãi chẽañe chʉ̃'ʉkʉ pa'ivʉ'ena saja'mʉ repaʉ. Jã'aja'ñe cho'oto chuta'a ma'a sairʉmʉna põsero'i care'vaa'kʉ repaʉ'te. Care'vama'to repaʉ'te pãi chẽañe chʉ̃'ʉkʉni saja'mʉ repaʉ. Sa jo'kaʉna repaʉ pãi chẽañe chʉ̃'ʉkʉji repaʉ'te pãi chẽavʉ'ena cuaoa'jʉ chini pãi chẽanare chʉ̃'ʉja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cuao jo'karena põsero'i peore ro'i pi'niñejatʉ'ka pãi chẽavʉ'ere pa'ija'mʉ repaʉ. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ũcuarʉmʉ pãi Jesuni ñañu chini saniasome. Sani Pilato cho'osi'ere repaʉ'te ija'che kʉaasome repana: —Repaʉ Pilato Galilea cheja pa'inapi Dioni pojojʉ ovejava'nare vanisojʉna repanani vanisoa'jʉ chini chʉ̃'ʉasomʉ repaʉ neenare. Chʉ̃'ʉʉna vanisorena pãiva'na chie rani meni cu'ava'na chiena'me ja'mesoasomʉ —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jã'aja'ñe kʉarena asa Jesús repanare i'kaasomʉ. —Ija'che cuasacosome mʉsanʉkona: “Repana Galilea cheja cana chekʉna repacheja canare na'a rʉa cu'ache pa'isinacosome. Jã'ajekʉna cu'ache ti'jñesi'kʉa'mʉ repanare”, chiijʉ cuasacosome mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jã'ata'ni repana chekʉnare na'a rʉa cu'ache pa'imanesinaa'me chiimʉ chʉ'ʉ. Jã'ata'ni mʉsanʉkonapi cu'ache cho'oche'te ũcuanʉko ũhasõ, mama cuasama'to mʉsanʉkonare ũcuaja'che rʉa cu'ache ti'jñeja'mʉ jũ'isirʉmʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chekere chʉ'o kʉara chiimʉ chʉ'ʉ mʉsanʉkonare: Aperʉmʉ Siloé chiara kueñe pa'isivʉ'e ʉmʉ pa'ivʉ'epi dieciochorepanare pãi tãni vẽasõasomʉ. Jã'a asa ija'che cuasacosome mʉsanʉkona: “Repana chekʉna Jerusalén pa'isinare ũcuanʉkore na'a rʉa cu'ache pa'isinacosome. Jã'ajekʉna cu'ache ti'jñesi'kʉa'mʉ repanare”, chiijʉ cuasacosome mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jã'ata'ni repana chekʉnare na'a rʉa cu'ache pa'imanesinaa'me, chiimʉ chʉ'ʉ. Jã'ata'ni mʉsanʉkonapi cu'ache cho'oche'te ũcuanʉko ũhasõ, mama cuasama'to mʉsanʉkonare ũcuaja'che rʉa cu'ache ti'jñeja'mʉ jũ'isirʉmʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ũcuarʉmʉ Jesús repanani chʉ'vakʉ ũcuaʉji cuasakʉ ija'chere kʉaasomʉ: —Pãiʉ repaʉ chiona higoñʉ tãñe chʉ̃'ʉasomʉ. Na'a pa'iʉ sani ñaasomʉ repaʉ, “Higopʉã kʉ̃icosomʉ”, chini. Sani ñato repañʉ repapʉãjẽ'e peoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Peokʉna repaʉ'te cho'oche cho'okaikʉ'te ija'che i'kaasomʉ repaʉ: “Ñakʉ; chura chʉ'ʉ choteʉ̃sʉrʉmʉ kunicuhamʉ icheja, iñʉre ñara chini, ‘Kʉ̃icosomʉ’, chini. Jã'ata'ni iñʉ jmamakarʉjẽ'e te'epʉjẽ'e kʉ̃ima'mʉ. Kuenisõjʉ̃'ʉ iñʉ. Re'ojachejare iñʉ sũkiñʉ kʉ̃ima'ñʉpi nʉkamʉ. Jã'ajekʉna iñʉ kuenisõ, chekʉñʉ'te ichejana tãto re'ocosomʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chikʉna repaʉ'te cho'oche cho'okaikʉ ija'che i'kaasomʉ: “Chʉ'ʉre paakʉ, chuta'a kueemaneñu iñʉ. Iʉ̃sʉrʉmʉ chʉ'ʉ iñʉjiipʉqueere cha'ore mu'kasõ, abonopi chu'chura chiimʉ. Cho'o ñara chiimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jo'e chekʉʉ̃sʉrʉmʉna kʉ̃ito re'omʉ iñʉ. Jã'aja'ñe cho'osi'ñʉpi kʉ̃ima'tota'ni chekʉʉ̃sʉrʉmʉ kueeche pa'imʉ iñʉ”, chiniasomʉ repaʉ —Jã'aja'ñe kʉaasomʉ Jesús repaʉ'te ñañu chini saisinare. ");
INSERT INTO coe_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pʉaumucusejekʉna Jesús judíopãi chi'ivʉ'ere pa'iʉ che'choasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ũcuavʉ'ere romio vatipi pa'iʉ cho'okʉna dieciochorepaʉ̃sʉrʉmʉ meñe cu'curʉ pa'iva'o paniasomo. Rũhiñe nʉkacu'aasomʉ repava'ore. ");
INSERT INTO coe_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pa'iona ña Jesús soni i'kaasomʉ repava'ore. —Ñako; mʉ'ʉni vasora chʉ'ʉ —chiniasomʉ Jesús repava'ore. ");
INSERT INTO coe_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chini repava'oni jʉ̃jñapi jaʉna teana rũhiñe vʉni nʉkako, “Dios peore masikʉ'mʉ”, chiio pojoasomo repava'o. ");
INSERT INTO coe_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesupi repava'oni pʉaumucusena vasoʉna ña repavʉ'e chʉ̃'ʉkʉ pe'ruasomʉ. Pe'rukʉ repanare pãi ija'che i'kaasomʉ repaʉ: —Seirepaumucujña cho'oche cho'oumucujña pa'imʉ te'esemana. Mʉsanʉkona jũ'ina vasocojñoñu chini cho'oche cho'oumucujñachi'a rani vasocojñojʉ̃'ʉ. Pʉaumucujñata'ni vasocojñoñu chini raimanejʉ̃'ʉ —chiniasomʉ repaʉ repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jã'aja'ñe i'kaʉna Jesús ija'che i'kaasomʉ repaʉ'te: —Re'oja'che pa'ina cho'ocheja'che sẽ'sevʉchi'a re'oja'che cho'onaa'me mʉsanʉkona. Jã'ata'ni rekoñoã cu'ache cuasanaa'me. Chekʉrʉmʉ mʉsanʉkona bueyva'ʉre paani, chekʉrʉmʉ burrova'ʉni paani, pʉaumucusena repava'nare jose same okore ũkuañu chini. ");
INSERT INTO coe_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pʉaumucujñana jã'aja'ñe cho'ocheta'ni ʉ̃semanaa'me mʉsanʉkona. Iko Abraham aperʉmʉ pa'isi'kʉ jojocojñosi'koa'mo. Vati aipi dieciochorepaʉ̃sʉrʉmʉ chẽa paamʉ ikore. ¿Je'se cuasa mʉsanʉkona pʉaumucusena vasoche ʉ̃seche ikore? Cu'ava'narechi'a oinaa'me mʉsanʉkona. Pãita'ni oimanaa'me —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jã'aja'ñe i'kaʉna asa repaʉ'te Jesure cuhena kʉkʉsoasome. Jã'ata'ni pãi chekʉna ũcuanʉko Jesús rʉa masiʉjekʉ vasoʉna ña pojosoasome. ");
INSERT INTO coe_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ũcuarʉmʉ Jesús repanare pãi jo'e che'choasomʉ. —Dios chʉ̃'ʉñe cho'ona, ¿keeja'cheja'che pa'iche? Repana pa'iche'te kʉara chini, ¿keeja'chere cuasakʉ kʉaja'che chʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ija'che kʉara: Mostazara'karʉ rʉa jmara'karʉ'me. Jã'ata'ni pãipi mostazara'karʉ'te tãru sũkiñʉ ʉjañʉji rʉa ka pa'iñʉ aineeʉna ũcuañʉna pĩ'ava'na chĩisʉo suhame. Ũcuaja'che Dios chʉ̃'ʉñe cho'ona te'eva'na pa'ime chura. Jã'ata'ni pãipi Dios chʉ'ore chʉ'vajʉna jainʉko asa chẽa jovojʉna, Repaʉ'te cuasakuanupʉ si'arʉmʉ na'a rʉa jainʉko jovome —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ũcuarʉmʉ Jesús jo'e che'choasomʉ. —Dios chʉ̃'ʉñe cho'ona pa'iche, ¿keeja'cheja'che pa'imʉ chiija'che chʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ija'chea'me: Romio pãre cho'ora chini kosasica'rerʉ'te charo cha'pi harinaro'ro chotero'ro ũcuaca'rerʉna ja'measomo. Pã saʉca'repʉ jmaca'rerʉ ja'mesi'eta'ni ʉjaca'repʉ saʉasomʉ. Dios chʉ̃'ʉñe cho'ona ũcuachi'a jã'aja'ñe pa'ijanaa'me. Pãipi Repaʉ chʉ'ore chʉ'vajʉna asa chẽa, te'ena chʉ'ʉni cuasajʉ chekʉnani chʉ'vajanaa'me. Jã'aja'ñe chʉ'vajʉna pãi si'achejñarʉã pa'ina asa chʉ'ʉni cuasajʉ jovo na'a pa'isirʉmʉ na'a jainʉko pa'ijanaa'me Dios chʉ̃'ʉñe cho'ona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Repanare pãi che'cho pi'ni Jerusalén vʉ'ejoopona saiʉ vʉ'ñajoopoã ʉjajoopoãna'me jmajoorʉã canʉka che'chokʉ saniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Saiʉ canʉka che'chokʉna repajoopo cakʉ pãiʉ te'eʉ ija'che sẽniasomʉ repaʉ'te: —Pãi Ũcuanʉkore Paakʉ, asarepajʉ̃'ʉ. ¿Cʉnaʉmʉ, Dios pa'icheja pãi te'ena sani pa'ijanaa'ñe? —chiniasomʉ. Chikʉna Jesús ija'che i'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Pãi jainʉko Dios pa'ichejare sani pañu chiime. Jã'ata'ni repacheja te'ena saijanaa'me saicu'akʉna. Mʉsanʉkonani Dios pa'icheja saiʉato jatisa'aro jmaã'carʉ pa'isa'aro kakana cho'ocheja'che mʉsanʉkona cu'ache cho'oche'te ũhasõ chʉ'ʉni cuasajʉ jovojʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ija'chea'me jã'a: Pãiʉ vʉ'e paakʉ paniasomʉ. Vʉ'e paakʉji jatisa'aro'te jeosõʉna chekʉna pãi ve'sere rani nʉkajʉ, “Jatisa'aro vatajʉ̃'ʉ chʉkʉna'te; kakañu”, chiniasome. Jã'aja'ñe i'kajʉna i'kaasomʉ vʉ'e paakʉ. “¿Jeecheja canaa'ñe mʉsanʉkona? Mʉsanʉkonare vesʉkʉ'mʉ chʉ'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jã'aja'ñe i'kaʉna ija'che i'kaasome repana: “Aperʉmʉ mʉ'ʉna'me ãu ãijʉ ũkusinaa'me chʉkʉna. Chʉkʉna pa'ijoopoã vʉ'ñajoopoã callejoovʉã ku'iʉ che'chosi'kʉa'mʉ mʉ'ʉ”, chiniasome repana repaʉ'te vʉ'e paakʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jã'aja'ñe i'kanareta'ni ija'che i'kaasomʉ repaʉ: “Mʉsanʉkonare vesʉkʉ'mʉ chʉ'ʉ. Mʉsanʉkona cu'ache cho'ona ũcuanʉko kueñe pa'imanejʉ̃'ʉ chʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na'a pa'isirʉmʉ Abrahamre, Isaare, Jacobre, chekʉna Dios chʉ'o kʉakaisinana'me Dios pa'ichejare pa'ijʉna ñajanaa'me mʉsanʉkona. Jã'ata'ni mʉsanʉkona cu'ache cho'oche ũhamanesinapi jũnisõru Dios Repaʉ pa'icheja saiche ʉ̃seja'mʉ mʉsanʉkonare. Ʉ̃seʉna oijʉ cõjire asoche ãijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Reparʉmʉ pãi si'achejña raisina Dios pa'ichejana tĩ'a ãure ãñu chini pʉʉjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ũcuachi'a reparʉmʉ ina, pãi Dios pa'icheja saimanejanaa'me chiicojñosinata'ni te'ena saijanaa'me Dios pa'icheja. Ũcuaja'che chekʉna Dios pa'icheja saijanaa'me ina chiicojñosinata'ni te'ena saimanejanaa'me Dios pa'icheja —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ũcuarʉmʉ fariseopãi Jesure ija'che kʉaasome: —Herodes mʉ'ʉre vanisora chiimʉ. Icheja pa'imanejʉ̃'ʉ mʉ'ʉ. Tĩichejana saijʉ̃'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kʉarena Jesús i'kaasomʉ repanare. —Repaʉ Herodes chai cho'ocheja'che rope'e cu'ache cho'okʉ pa'ikʉ'mʉ. Herode'te ija'che sa kʉajʉ̃'ʉ: “Iumucusena'me che'ro pãi sa'navʉã pa'inani vatire eto saokʉ pa'ija'mʉ chʉ'ʉ. Ũcuachi'a pãi jũ'iva'nare vasoja'mʉ chʉ'ʉ. Che'ro pãasirʉmʉ chʉ'ʉ Ja'kʉ chʉ'ʉre chʉ̃'ʉ jo'kasi'e peore cho'o pi'nija'mʉ chʉ'ʉ.” ");
INSERT INTO coe_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jã'aja'ñe sa kʉajʉ̃'ʉ repaʉ'te Herode'te. Iumucusepi che'roji che'ro pãasirʉmʉjatʉ'ka saiʉ pa'ija'mʉ chʉ'ʉ, Jerusalén vʉ'ejoopona tĩ'ara chini. Jerusalén vʉ'ejoopochi'a Dios chʉ'o kʉava'nare si'arʉmʉ vanisõnaa'me pãi. Chekʉjoopoã vʉ'ñajoopoã jã'aja'ñe cho'oma'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ũcuarʉmʉ Jesús ija'che i'kaasomʉ: —Mʉsanʉkona Jerusalén vʉ'ejoopo cana cu'ache cho'oche'te ñakʉ rʉa sʉmava'ʉ pa'imʉ chʉ'ʉ. Kurava'o repao chĩiva'nare kue'chaka vʉ'evʉãna soni paacheja'che re'oja'che cho'okasa chiikʉ'teta'ni cuheme mʉsanʉkona chʉ'ʉre. Mʉsanʉkona Jerusalén vʉ'ejoopo cana Repaʉ chʉ'ore mʉsanʉkonani kʉaa'jʉ chini Dios raosiva'nare cuhejʉ vanisõnaa'me. Ũcuachi'a Repaʉ chʉ'ore chʉ'vaa'jʉ chini Dios raosiva'nare cuhejʉ si'arʉmʉ catapi su'a vẽasõnaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Asarepajʉ̃'ʉ. Jerusalén vʉ'ejoopo mʉsanʉkona pa'ijoopo pãipi cu'ache cho'oñu chiito ʉ̃semaneja'mʉ Dios. Jã'ajekʉna mʉsanʉkona chʉ'ʉre rʉa jeerʉmʉ ñamanejanaa'me. Jã'ata'ni chʉ'ʉpi jo'e chejana cajekʉna ña, “Diopi re'oja'che cho'okaaʉ ikʉre, Repaʉ Raokʉ'te”, chiijanaa'me mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ũcuarʉmʉ Jesupi pʉaumucusena fariseopãi chʉ̃'ʉkʉ vʉ'ena ãu ãsa chini mʉaʉna chekʉna fariseopãi, “¿Je'se cho'oja'ʉ ikʉ?”, chini ñajʉ cha'aasome, cho'oʉna ña repaʉni cu'ache cho'oñu chini. ");
INSERT INTO coe_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ũcuavʉ'ere pãiʉ o'ro ravʉ jũ'iva'ʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ũcuarʉmʉ Jesús repanare ija'che sẽniasomʉ judíopãi che'chonana'me fariseopãi: —Diopi chʉ̃'ʉʉna tocha jo'kasi'e, ¿pʉaumucujñana jũ'iva'nare vasoche ʉ̃sekʉ? —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sẽekʉ'te i'kamaneasome repana. I'kamapʉna jũ'iva'ʉre chẽa vasoasomʉ repaʉ. Vasocuha, —Re'omʉ. Saijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chini fariseopãire i'kaasomʉ repaʉ. —Mʉsanʉkona ũcuaʉakʉ te'eʉ chĩipi chekʉrʉmʉ bueyva'ʉpi pʉaumucusena cojena tuãnisõʉna ñani, ¿rutama'ñe? —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chikʉna i'kavesʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús chuta'a fariseo vʉ'e pa'itona fiesta'te ja'me cho'oa'jʉ chini soicojñosina rani kakaasome. Kaka repanare soisi'kʉni kueñe pʉʉñu chini ku'easome repana. Jã'aja'ñe cho'ojʉna ña Jesús ija'che chʉ'vaasomʉ repanare: ");
INSERT INTO coe_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Mʉsanʉkonani pãi romi vejache'te ñaa'jʉ chini soito sani tĩ'a, soisi'kʉni kueñe pʉʉñu chini ku'emanejʉ̃'ʉ. Chekʉrʉmʉ mʉsanʉkonare na'a rʉa masinapi ratu mʉsanʉkonare soisi'kʉ, “Tĩichejana kʉñʉ pʉʉjʉ̃'ʉ mʉsanʉkona, inapi ichejana pʉʉa'jʉ”, chiija'mʉ. Chikʉna asa kʉkʉ vʉni sani, mesako'a chekʉchã'tiro casaivʉãna pʉʉjanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jã'ajekʉna ija'che cho'ojʉ̃'ʉ: Mʉsanʉkonare pãipi soito sani kaka, soisi'kʉre so'o pʉʉjʉ̃'ʉ, mesako'a chekʉchã'tiro casaivʉãna. Jã'aja'ñe cho'oto mʉsanʉkonare soisi'kʉ rani ña, “Chʉ'ʉre re'oja'che cho'ona, vʉni rani chʉ'ʉre na'a kueñe pʉʉjʉ̃'ʉ”, chiija'mʉ. Jã'aja'ñe i'kato chekʉna pãi repavʉ'e kaka pʉʉsina mʉsanʉkonare ña, “Rʉa masinacosome jã'ana”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Chekʉnare pãi na'a rʉa masime chʉkʉna”, chiijʉ cuasame pãi te'ena. Jã'aja'ñe cuasanare, “Rʉa vesʉnaa'me ina”, chiija'mʉ Dios, asa kʉkʉa'jʉ chini. Jã'ata'ni pãi chekʉna, “Chekʉnare pãi na'a rʉa vesʉnaa'me chʉkʉna”, chiijʉ cuasame. Jã'aja'ñe cuasanare, “Rʉa masinaa'me ina”, chiija'mʉ Dios, asa pojoa'jʉ chini —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chini repaʉ'te soisi'kʉre Jesús ija'che i'kaasomʉ: —Mʉ'ʉpi pãire ãure ãura chini, soni ija'che cuasamanejʉ̃'ʉ: “Chʉ'ʉre re'oja'che cho'onana'me chʉ'ʉ a'chʉpãina'me chʉ'ʉ majapãina'me kueñe pa'inare kurinarechi'a soni ãu ãuja'mʉ chʉ'ʉ. Jã'aja'ñe chʉ'ʉpi cho'oto chekʉrʉmʉ repanapi fiesta cho'oni chʉ'ʉ repanare soisi'eja'che sãiñe soijanaa'me chʉ'ʉre”, chiiʉ cuasamanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jã'ata'ni mʉ'ʉpi fiesta cho'oni chʉova'na pa'iva'nana'me nʉka ku'imava'nana'me ro'ocũ'ava'nana'me na'ava'nare soijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Repava'nata'ni mʉ'ʉre sãiñe soima'me. Jã'ajekʉna mʉ'ʉpi jã'aja'ñe pa'iva'nani ãure soni ãuto rʉa re'oja'che cho'okaija'mʉ Dios mʉ'ʉre. Na'a pa'isirʉmʉna pãi re'onapi jũ'isina jo'e vajʉraiumucuse tĩ'aru Dios mʉ'ʉre ro'ija'mʉ, chʉova'na pa'iva'nare re'oja'che cho'okaisi'e ro'i —chiniasomʉ Jesús repaʉ'te fariseopãiʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesupi jã'aja'ñe i'kaʉna asa, chekʉ ãu ãsa chini ũcuavʉ'e ñu'ikʉ ija'che i'kaasomʉ: —Pãi, Dios pa'icheja sani ãu ãijana rʉa pojojʉ pa'ijanaa'me —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","17","Chikʉna Jesús ija'che i'kaasomʉ repaʉ'te: —Pãiʉ repaʉ chiinarechi'a pãi jainʉkore repaʉ ãu ãujañere kʉa, ãu ãurʉmʉ tĩ'aʉna repaʉ'te cho'oche cho'okaikʉ'te saoasomʉ, repaʉ chiinani ija'che sa kʉaa'kʉ chini: “Rani ãijʉ̃'ʉ. Mʉsanʉkona ãijañe ãu peore care'vacuhasi'ea'me.” ");
INSERT INTO coe_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chini saoʉna sa kʉaʉna asa, “Saima'me chʉkʉna”, chiniasome repana. Charo soicojñosi'kʉ ija'che i'kaasomʉ: “Cheja koocuhasi'kʉa'mʉ chʉ'ʉ. Chʉ'ʉ koosichejare ñajasa chiimʉ chʉ'ʉ. Ãu ãura chini soisi'kʉreta'ni saimaneja'mʉ chʉ'ʉ. Pe'rumanejʉ̃'ʉ chʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ũcuaja'che chekʉ soicojñosi'kʉ ija'che i'kaasomʉ: “Bueyva'nare dierepanare koocuhasi'kʉa'mʉ chʉ'ʉ. Chʉ'ʉ koosiva'nani bueyva'nani cho'oche'te cho'o ñara chiimʉ chʉ'ʉ. Saima'mʉ chʉ'ʉ. Pe'rumanejʉ̃'ʉ chʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ũcuaja'che jo'e chekʉ ija'che i'kaasomʉ: “Chʉ'ʉ churepara romi vejasi'kʉa'mʉ. Chura chʉ'ʉre ãu ãi saicu'amʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ũcuanʉko jã'aja'ñe i'karena co'i, repaʉ'te paakʉni kʉaʉna asa pe'rukʉ ija'che chʉ̃'ʉasomʉ repaʉ: “Ivʉ'epi eta mʉa ijoopo callejoovʉã pa'inani, chʉova'na pa'iva'nana'me nʉka ku'imava'nana'me na'ava'nana'me ro'ocũ'ava'nare ku'e jñaa chʉ'ʉ vʉ'ena soni rajʉ̃'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chikʉna soijani rani, “Chʉ'ʉre paakʉ, mʉ'ʉ chʉ̃'ʉsi'e cho'ocuhasi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni mʉ'ʉ vʉ'e chuta'a pãi timuma'me”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chikʉna ija'che i'kaasomʉ repaʉ'te paakʉ: “Vʉ'ejoopo rʉ'tʉva pa'ima'ña ku'inani kʉajaijʉ̃'ʉ chʉ'ʉ vʉ'e timukʉ'te raapʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chʉ'ʉ charo soisi'e raicuhesinare te'eʉ'terejẽ'e ãumaneja'mʉ chʉ'ʉ”, chiniasomʉ repaʉ, repaʉ'te cho'oche cho'okaikʉ'te —Jã'aja'ñe kʉaasomʉ Jesús repaʉ'te i'kasi'kʉre. ");
INSERT INTO coe_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ũcuarʉmʉ Jesús pãipi jainʉko sʉni ku'ijʉna chʉri ña i'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mʉsanʉkonapi chʉ'ʉni jovoʉato ija'che cho'ojʉ̃'ʉ chiimʉ chʉ'ʉ mʉsanʉkonare: Mʉja'kʉpãi pa'ichena'me mʉrʉ̃joromi pa'iche, mʉchĩiva'na pa'iche, mʉa'chʉpãi pa'iche, mʉa'choromi pa'iche, mʉche'ʉchĩi pa'ichena'me mʉsanʉkona pa'iche rʉarepa cuasama'ñe pa'ijʉ chʉ'ʉni na'a rʉa cuasajʉ pa'ijʉ̃'ʉ. Mʉsanʉkonapi jã'aja'ñe cho'omaneni chʉ'ʉ neena pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mʉsanʉkonare chʉ'ʉ neenajejʉna chekʉna vanisõñu chiijanaa'me, chʉ'ʉre cho'oñu chiicheja'che. Jã'aja'ñe cho'oñu chiitojẽ'e chʉ'ʉre cuasache jmamakarʉjẽ'e ũhasõmanejʉ̃'ʉ. Mʉsanʉkonapi chʉ'ʉre cuasache'te ũhasõni chʉ'ʉ neena pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chekʉrʉmʉ mʉsanʉkona te'eʉji vʉ'e ʉmʉ nʉkavʉ'e cho'ora chiimʉ. Cho'ora chini charo repavʉ'e cho'ojamajñarʉã ro'inʉkore cuasa masi kuẽkue ñamʉ, “Kuri karato cho'omanera”, chini. ");
INSERT INTO coe_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Charo jã'aja'ñe cuasama'ñe cho'oni repaʉni kuri karasõʉna cho'o pi'nicu'amʉ repaʉ'te repavʉ'e. Cho'o pi'nimaneʉna chekʉnapi ñani pãisojanaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Vʉ'e cho'okʉta'ni cho'o pi'nimaneʉ ikʉ”, chiijanaa'me repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","Chekʉrʉmʉ pãiʉ jainʉkore paakʉ chʉ̃'ʉkʉji chekʉnani cavapi'rakʉ te'eʉji charo ija'che cuasamʉ: “Sõtaopãi diez milrepanare paakʉ'mʉ chʉ'ʉ. Chekʉta'ni na'a jainʉkore paamʉ, veinte milrepanare. ¿Jã'anani maipi cavani cajejaijanaa'ñe?”, chiimʉ. “Chekʉrʉmʉ repanapi maire cajejaijanaa'me”, chiiʉ cuasani ija'che cho'omʉ repaʉ: Chekʉpi repaʉ neenana'me chuta'a so'ore pa'ijʉna repaʉ'te cho'oche cho'okainare saomʉ, “Cavamaneñu mai. Re'oja'che pañu”, chiapʉ chini. Jã'ata'ni chekʉrʉmʉ, “Maipi cajejaijacosome”, chini cuasani, repaʉ neenare, “Cavañu mai”, chiimʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mʉsanʉkona ũcuaja'che chʉ'ʉ neena pa'iʉato pãi chʉ̃'ʉkʉ cuasasi'eja'che charo ija'che cuasajʉ̃'ʉ: “¿Diore cuasaja'che chʉ'ʉ? Cuasato chʉ'ʉre cho'oʉache cu'a peore ũhasõ, Repaʉ chʉ̃'ʉñechi'a cuasakʉ cho'oche pa'ija'mʉ chʉ'ʉ. Jã'aja'ñe cho'oma'to Dios neekʉ pa'icu'aja'mʉ” —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare pãi. —Ũha sãijani rʉa re'omʉ. Jã'ata'ni ũhapi sãija'ñepi si'asõru, ¿je'se cho'ojanaa'ñe pãi, ũhapi sãijaaʉ chini? Jo'e sãija'ñe cho'ocu'amʉ. ");
INSERT INTO coe_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sãija'ima'to cu'amʉ. Ũcuaja'che chio tãsimajñarʉãre ũha, sãija'ima'ñepi chu'chuto aineema'mʉ. Ũcuachi'a abonona ũha, sãija'ima'ñepi ja'meto na'a re'oja'ima'mʉ. Jã'ajekʉna ũhapi sãija'ima'to sẽjome pãi. Ũcuaja'che pãipi repana asa chẽasi'ere Dios chʉ'ore ũhasõni ũha sãija'imaʉ cu'acheja'che cu'ame. Jo'e re'oja'che pa'iche peomʉ repanare. Chʉ'ʉ i'kache asa chẽaʉana ũcuanʉko asa chẽajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ũcuarʉmʉ pãi chʉ̃'ʉnare kuri kookainana'me cu'ache pa'ina Jesús i'kache'te asañu chini chi'iasome. ");
INSERT INTO coe_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jã'anapi chi'irena ña fariseopãina'me judíopãi che'chona pe'rujʉ cu'ache i'kaasome Jesure. —Cu'ache pa'inare pojokʉ'mʉ ikʉ. Ũcuanana'me si'arʉmʉ ãu ãikʉ'mʉ ikʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jã'aja'ñe i'karena asa Jesús repanani chʉ'vakʉ ũcuaʉji cuasakʉ ija'chere kʉaasomʉ: ");
INSERT INTO coe_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Chekʉrʉmʉ mʉsanʉkona ovejava'nare te'eʉji cienrepava'nare paamʉ. Paakʉna chekʉrʉmʉ ovejava'ʉ te'eva'ʉ tĩichejana sani cavesʉsõru chekʉva'nare noventa y nueverepanare te'eva'nare pãi peochejana jo'ka, cavesʉsiva'ʉni ku'era chini sanisõmʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sani ku'ekʉ pa'iʉ jñaani repava'ʉre rʉa pojokʉ mini kuãa ramʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Rani tĩ'a mʉ'ʉre re'onana'me mʉ'ʉre kueñe pa'inare soni, “Ovejava'ʉre cavesʉsiva'ʉre ku'e jñaacuhasi'kʉa'mʉ chʉ'ʉ. Jñaa pojosõmʉ chʉ'ʉ. Ja'me pojokaijʉ̃'ʉ chʉ'ʉre”, chiimʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Asarepajʉ̃'ʉ, mʉsanʉkona. Chekʉrʉmʉ pãi re'ona noventa y nueverepana pa'ime. Re'onajejʉna cu'ache cho'oche ũhañe chiima'mʉ repanare. Jã'aja'ñe pa'ijʉna cʉnaʉmʉ pa'ina rʉa pojome repanare. Jã'ata'ni pãiʉ te'eʉji repaʉ cu'ache cho'oche'te ũhasõru cʉnaʉmʉ pa'ina na'a rʉa pojome repaʉ'te —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chini Jesús jo'e chʉ'vaasomʉ repanare. —Chekʉrʉmʉ romio kurire're dierepare're paakoji te'ere'reva cho'osõmo. Cho'osõ, repare'reva'te ku'e jñaara chini ʉopʉ chʉ̃o, rʉa masi ku'eko peore vʉ'e jʉ'omo repare'reva jñaañetʉ'ka. ");
INSERT INTO coe_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ku'e jñaa, repao'te re'onana'me repao'te kueñe pa'inare soni, “Kurire'reva cho'osõsire'reva ku'e jñaacuhasi'koa'mo chʉ'ʉ. Kurire'reva chʉ'ʉ jñaasi'e ja'me pojokaijʉ̃'ʉ chʉ'ʉre”, chiimo repao repanare. ");
INSERT INTO coe_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ũcuaja'che pãiʉ te'eʉji repaʉ cu'ache cho'oche'te ũhasõru ángeles Diore ja'me pa'ina rʉa pojome —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ũcuarʉmʉ Jesús jo'e chʉ'vaasomʉ repanare. —Pãiʉ mamachĩi ʉmʉpãi te'eka'chapanare paaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Paakʉna cho'je cakʉpi ija'che i'kaasomʉ pʉka'kʉre: “Ja'kʉ, mʉ'ʉ jũnisõrʉmʉ chʉ'ʉre jo'kajachere churana teana ĩsijʉ̃'ʉ chʉ'ʉre, chejana'me põse”, chiniasomʉ. Sẽkʉna pʉka'kʉ repanare mamachĩi chejana'me põse teana ĩsiasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ĩsiʉna cho'je cakʉ pʉka'kʉ repaʉ'te ĩsisi'e peore na'mi ĩsisõasomʉ. Ĩsisõ, kuri koo, so'ona sani ũcuaʉache cu'ache cho'okʉ ku'iʉ kuri rʉa na'mi si'asõasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Repaʉ kuri si'asõsirʉmʉna repaʉ saisichejapi jeereparʉmʉ okopi ramaʉna ãu si'asõasomʉ. Ãupi si'asõʉna si'ache repaʉjẽ'e kurijẽ'e si'asõsi'kʉjekʉ ãujẽ'e peokʉ kurijẽ'e peoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Repaʉni peore karakʉna ũcuacheja pa'ikʉ'te pãiʉ'te sani cho'oche'te sẽniasomʉ repaʉ cho'oche'te cho'okʉ ãure ãsa chini. Cho'oche'te sẽkʉna repaʉ'te jo'chasẽse kuirache'te jo'ka cu'ava'na pa'ichejana saoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Saoʉna sani pa'iʉ jo'chasẽsere kuirakʉna repaʉni rʉarepa ãucuhakʉna jo'chasẽse ãure ãni chajiʉakʉ'teta'ni repacheja pa'ina pãi te'eʉjẽ'e ãumaneasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na'a pa'iʉ rũhiñe cuasa, te'eʉji ija'che i'kaasomʉ repaʉ: “Chʉ'ʉ ja'kʉre cho'oche cho'okaina ãu karama'ñe paajʉ ãijʉna cajejaisi'e pa'ito chʉ'ʉva'ʉta'ni ichejare rani pa'iʉ ãucuhare jũ'iʉ pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jã'ajekʉna ja'kʉni co'i ija'che i'kara: ‘Ja'kʉ, mʉ'ʉrejẽ'e cu'ache cho'okʉ Diorejẽ'e cu'ache cho'osi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mʉ'ʉre cu'ache cho'osi'kʉjekʉna, Chʉ'ʉ chĩia'mʉ mʉ'ʉ, chiimanejʉ̃'ʉ chʉ'ʉre. Rupʉ mʉ'ʉre cho'oche cho'okaikʉ'te paacheja'che paajʉ̃'ʉ chʉ'ʉre chura’, chisa ja'kʉni co'ini”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Jã'aja'ñe chini cuasa co'iasomʉ repaʉ churata'ni. Co'ikʉna repaʉ pʉka'kʉ chuta'a ma'a so'o pa'ikʉni ñaasomʉ repaʉ'te. Ñasi'epi repaʉni oiʉ vʉ'vʉ tijña sũ'ka chũsu pojoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sũ'ka chũsu pojokʉ'teta'ni repaʉ cuasa co'isi'ere i'kaasomʉ repaʉ. “Ja'kʉ, mʉ'ʉrejẽ'e cu'ache cho'okʉ Diorejẽ'e cu'ache cho'osi'kʉa'mʉ chʉ'ʉ. Mʉ'ʉre cu'ache cho'osi'kʉjekʉna, Chʉ'ʉ chĩia'mʉ mʉ'ʉ, chiimanejʉ̃'ʉ chʉ'ʉre”, chiniasomʉ repaʉ pʉka'kʉre. ");
INSERT INTO coe_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jã'ata'ni pʉka'kʉ mamakʉji co'iʉna pojokʉ repaʉ'te cho'oche cho'okainare soni rao ija'che chʉ̃'ʉasomʉ: “Kãña, rʉa re'ojakãñare mini ra sa'chekaijʉ̃'ʉ iva'ʉre chʉ'ʉ chĩiva'ʉre. Kãña sa'che pi'ni aniñocava mini ra, mʉoñona cuachajʉ̃'ʉ iva'ʉre. Ũcuaja'che cũ'akorophe're mini ra sa'chejʉ̃'ʉ iva'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ũcuaja'che torochĩiva'ʉre jujusiva'ʉni chẽa vaijʉ̃'ʉ. Ãijʉ pojojʉ fiesta cho'oñu mai. ");
INSERT INTO coe_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chʉ'ʉ chĩiva'ʉ jũnisõsiva'ʉja'che peocheja pa'iva'ʉpi co'icuhasi'kʉa'mʉ. Ũcuachi'a sani cavesʉsõsiva'ʉja'che peocheja pa'isiva'ʉpi co'icuhasi'kʉa'mʉ jo'e”, chikʉna asa pojojʉ fiesta cho'oasome repana. ");
INSERT INTO coe_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jã'aja'ñe cho'otona chekʉ, repaʉ majaa'chʉ charo cakʉ chio saisi'kʉpi maniasomʉ. Maiʉ vʉ'e tĩ'api'rakʉji kueñejekʉna repana fiesta cho'oche asaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Asakʉ mani tĩ'a, repaʉ pʉka'kʉre cho'oche cho'okaikʉ'te te'eʉ'te soni sẽniasomʉ. “¿Ʉ̃quere jã'ana cho'oche?”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chikʉna i'kaasomʉ repaʉ. “Mʉche'ʉpi vajʉva'ʉ co'iʉna, ‘Torochĩiva'ʉre ãure ãu jujasiva'ʉni vaijʉ̃'ʉ. Ãijʉ fiesta cho'oñu mai’, chiisi'kʉa'mʉ mʉja'kʉ”, chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jã'aja'ñe kʉaʉna asa pe'rukʉ vʉ'e kakacuheasomʉ repaʉ. Kakacuhekʉna repaʉ pʉka'kʉ eta, “Jmava'ʉ, kakajʉ̃'ʉ”, chiiʉ rʉa chʉ̃'ʉasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jã'aja'ñe chʉ̃'ʉkʉna pʉka'kʉre ija'che i'kaasomʉ repaʉ: “Mʉ'ʉ chʉ̃'ʉñe jmamakarʉjẽ'e jachama'ñe rʉa jeerʉmʉ cho'okʉ pa'ikʉ'mʉ chʉ'ʉ. Jã'ata'ni mʉ'ʉ chʉ'ʉre jmamakarʉjẽ'e chivochĩiva'ʉrejẽ'e ĩsima'kʉa'mʉ. ‘Mʉ'ʉ ja'me pa'inana'me pojokʉ fiesta cho'ojʉ̃'ʉ’, chiima'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aperʉmʉ jã'ʉ chʉ'ʉ cho'jeʉ mʉ'ʉ ĩsisi'e koo jo'e chekʉnani ĩsisõ kuri koo sani ku'iʉ sĩ'uromire ja'me kãiʉ ro'isõsi'kʉa'mʉ. Jã'aja'ñe cho'osi'kʉreta'ni pojokʉ fiesta cho'ora chini torochĩiva'ʉre ãure ãu jujasiva'ʉre vaisi'kʉa'mʉ mʉ'ʉ”, chiniasomʉ repaʉ pʉka'kʉre. ");
INSERT INTO coe_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chikʉna pʉka'kʉ i'kaasomʉ repaʉ'te. “Jmava'ʉ, chʉ'ʉre si'arʉmʉ ja'me pa'ikʉ'mʉ mʉ'ʉ. Chʉ'ʉ paache cu'amajñarʉã peore mʉ'ʉ paajachechi'aa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʉche'ʉva'ʉta'ni jũnisõsiva'ʉja'che peocheja pa'isiva'ʉpi co'icuhasi'kʉa'mʉ. Ũcuaja'che sani cavesʉsõsiva'ʉja'che peocheja pa'isiva'ʉpi co'icuhasi'kʉa'mʉ jo'e. Jã'ajekʉna pojokʉ fiesta cho'omʉ chʉ'ʉ”, chiniasomʉ repaʉ —Jã'aja'ñe chʉ'vaasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ũcuarʉmʉ Jesús repaʉ neenani chʉ'vakʉ ũcuaʉji cuasakʉ ija'chere kʉaasomʉ: —Pãiʉ kuriʉ paniasomʉ. Cho'oche cho'okainare chʉ̃'ʉkʉ'te paaasomʉ repaʉ kuriʉ. Paakʉna chekʉnapi ija'che kʉaasome repaʉ'te kuriʉ'te: “Mʉ'ʉre cho'oche cho'okainare chʉ̃'ʉkʉji mʉ'ʉ neere masi kuirakaimaʉna rupʉ cho'osõmʉ”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kʉarena asa cho'oche cho'okainare chʉ̃'ʉkʉ'te soni i'kaasomʉ repaʉ. “Mʉ'ʉ cho'oche asasi'kʉa'mʉ chʉ'ʉ. ¿Je'se cuasa jã'aja'ñe cho'okʉ mʉ'ʉ? Chʉ'ʉ nee mʉ'ʉ cho'osi'ere tocha ra ñojʉ̃'ʉ chʉ'ʉre. Ũcuamakarʉ chʉ'ʉ nee kuirajʉ̃'ʉ mʉ'ʉ. Etora chiimʉ chʉ'ʉ mʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chikʉna asa repaʉ'te cho'oche chʉ̃'ʉkaikʉ ija'che cuasaasomʉ: “Chʉ'ʉre paakʉ etora chiimʉ chʉ'ʉre. ¿Je'se cho'oja'che chʉ'ʉ, repaʉ chʉ'ʉre etosirʉmʉ? Cho'oche cho'omava'ʉ pa'ija'mʉ chʉ'ʉ. Chio ãu tãñejẽ'e koka peokʉ'mʉ chʉ'ʉ. Chekʉnare kuri rupʉ sẽni koovajʉchʉkʉ'mʉ chʉ'ʉ”, chiiʉ cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cuasakʉ, “Ãa, chʉ'ʉ cho'ojache cuasacuhamʉ chʉ'ʉ. Ija'che cho'ora chʉ'ʉ, pãipi repana vʉ'ñana cuao paajʉ kuiraa'jʉ chʉ'ʉva'ʉre, cho'oche peova'ʉre”, chiiʉ cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ũcuarʉmʉ repaʉ cuasasi'e ija'che cho'oasomʉ repaʉ: Repaʉ'te paakʉ'te põsero'i paanare te'enarechi'a soni raoasomʉ repaʉ. Soni rao, charo raisi'kʉre i'kaasomʉ repaʉ. “Chʉ'ʉre paakʉ'te, ¿keenʉko põsero'i paakʉ mʉ'ʉ?”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chikʉna, “U'chape'e cienrepatʉo põsero'i paamʉ chʉ'ʉ”, chiniasomʉ repaʉ. Chikʉna repaʉ'te i'kaasomʉ repaʉ. “Ija'ova mʉ'ʉ põsero'i tochasija'ova sẽjo, pesa pʉʉ, chekʉja'ovana cincuentarepatʉochi'a tochajʉ̃'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tocha pi'niʉna chekʉre põsero'i paakʉ'te soni rao i'kaasomʉ repaʉ. “Mʉ'ʉjẽ'e, ¿keenʉko põsero'i paakʉ?”, chiniasomʉ. Chikʉna, “Trigopʉã cienrepapʉã põsero'i paamʉ chʉ'ʉ”, chiniasomʉ repaʉ. Chikʉna i'kaasomʉ repaʉ. “Ija'ova mʉ'ʉ põsero'i tochasija'ova sẽjo, chekʉja'ovana ochentarepapʉãchi'a tochajʉ̃'ʉ”, chiniasomʉ repaʉ repaʉ'te. Jã'aja'ñechi'a ũcuanʉkore põsero'i paanare cho'oasomʉ repaʉ. Repana ro'ijache casokaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jã'aja'ñe cho'oʉna repaʉ'te paakʉ repaja'ova'te ña i'kaasomʉ. “Chʉ'ʉ mʉ'ʉre etosirʉmʉ pa'ijachere cuasa, chʉova'ʉ pa'iʉamaʉna cu'ache cho'osi'kʉta'ni mʉ'ʉ masiche'te cho'o ñosi'kʉa'mʉ mʉ'ʉ, chʉ'ʉre põsero'i paanare casosi'e”, chiniasomʉ repaʉ. Repaʉ cho'osi'eja'che Diore cuasamanapi Diore cuasanare na'a rʉa cho'omasime icheja cheja cho'omajñarʉã. ");
INSERT INTO coe_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Iere chʉ'vamʉ chʉ'ʉ mʉsanʉkonare: Pãi kurina te'ena cu'ache cho'ome chekʉnare. Jã'ata'ni mʉsanʉkonapi kuri paani chekʉnare oijʉ re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ, re'oja'che cho'onare paaʉato. Jã'aja'ñe cho'oto kuri peore si'asõsirʉmʉ mʉsanʉkona re'oja'che cho'okaisi'ejekʉna repanapi Dioni jovo pa'ijʉ charo jũnisõni Repaʉ pa'icheja ai sani re'oja'che pa'inajejʉ mʉsanʉkonapi cho'jepi jũni saito ña pojojanaa'me mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Pãi te'ena kuri ka'charʉ paanata'ni repana kuripi chekʉnare re'oja'che cho'okaime. Jã'aja'ñe cho'onapi na'a rʉa kuri paani chekʉnare ũcua re'oja'che cho'okaira'ame repana. Pãi chekʉna ka'charʉ kuri paanata'ni jorejʉ chekʉnare cu'ache cho'ome. Jã'aja'ñe cho'onapi na'a rʉa kuri paani jorejʉ ũcua cu'ache cho'ora'ame repana chekʉnare. ");
INSERT INTO coe_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʉsanʉkona icheja cheja pa'irʉmʉ kuri rʉa paanata'ni chekʉnare re'oja'che cho'okaima'to Dios Repaʉ paache, rʉa re'oja'che ĩsimaneja'mʉ mʉsanʉkonare, “Paavesʉme ina”, chini. ");
INSERT INTO coe_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ũcuachi'a mʉsanʉkonapi chekʉna paamajñarʉãre masi kuirakaima'to Dios Repaʉ ĩsira chiisi'e cʉnaʉmʉ paache re'oja'che ĩsimaneja'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Pãi ka'chanapi ũcuate'eʉ'te paato repaʉ'te paanare ũcuapa'rʉvachi'a chiicu'amʉ. Chekʉrʉmʉ repaʉ'te paanare te'eʉ'te na'a rʉa chiiʉ chekʉreta'ni cuhemʉ repaʉ. Ũcuachi'a kurina'me Diore ũcuapa'rʉvachi'a cuasama'me pãi. Kurire na'a rʉa cuasajʉ Dioreta'ni cuasama'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesupi jã'aja'ñe i'kaʉna asa, fariseopãi kurineenajejʉ pãisoasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sojʉna Jesús ija'che i'kaasomʉ repanare: —Pãi re'ona cho'ocheja'che sẽ'sevʉchi'a re'oja'che cho'onaa'me mʉsanʉkona, chekʉnapi ña, “Re'onaa'me ina”, chiapʉ chini. Jã'ata'ni Dios mʉsanʉkona rekoñoã cu'ache cuasache ñakʉ'mʉ. Jã'aja'ñe pa'inare ñani pojoma'kʉa'mʉ Dios. Jã'aja'ñe pa'iche rʉa cuhemʉ Repaʉ. Pãita'ni jã'aja'ñe pa'inare ñani pojome —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ũcuarʉmʉ Jesús jo'e chʉ'vaasomʉ. —Dios chʉ̃'ʉñe Moisés Repaʉji i'kakʉna asakʉ tocha jo'kaasomʉ. Chekʉna, ũcuaja'che Dios chʉ'o kʉasina Repaʉ chʉ'o tocha jo'kaasome. Repana tocha jo'kasi'ere ñajʉ chʉ'vaasome pãi, Juan Pãi Okoro'vekʉ aineesirʉmʉjatʉ'ka. Juan pa'irʉmʉpi vʉa pãi cu'ache cho'oche ũhasinare Dios chẽa paache'te, chʉ'o re'oja'chere chʉ'vajʉ pa'ime pãi. Chʉ'vajʉna pãi Dios pa'icheja saineenajejʉ asa jachama'ñe cuasajʉ, jainʉko Repaʉ chʉ̃'ʉñe'te cho'ojʉ pañu chiime. ");
INSERT INTO coe_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Aperʉmʉ Dios chʉ̃'ʉ jo'kasi'e irʉmʉjatʉ'ka chʉ̃'ʉmʉ. Chekʉrʉmʉ Diopi chʉ̃'ʉʉna cʉnaʉmʉna'me cheja si'asõja'mʉ. Repaʉ chʉ̃'ʉ jo'kasi'eta'ni jmamakarʉjẽ'e si'amaneja'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Chini Jesús jo'e chʉ'vaasomʉ. —Pãiʉ ũcuaʉakʉji repaʉ rʉ̃jore paacuhekʉ sẽjosõ, chekoni vejani Dios cuheche'te cu'ache cho'omʉ. Ũcuaja'che pãiʉ sẽjosi'koni vejani Dios cuheche'te cu'ache cho'omʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ũcuarʉmʉ Jesús pãire chʉ'vakʉ ũcuaʉji cuasakʉ ija'chere kʉaasomʉ: —Pãiʉ kuriʉ paniasomʉ. Si'aumucujña kãña rʉa re'ojakãñare ju'iʉ, ãu rʉa re'oja'chere karama'ñe ãiʉ pojokʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jã'a cho'oto Lázaro, chʉova'ʉ pa'iva'ʉ ca'nivʉ si'acaca'nivʉ asi ravʉ paava'ʉpi repaʉ kuriʉ vʉ'e kakasa'aro'te si'aumucujña rani ñu'iʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kuriʉ ãiʉ to'jñomajñarʉãre sia ãni chajiʉache ñaasomʉ repava'ʉ. Ñu'iʉna jamuchai rani repava'ʉ asire vetoasome. ");
INSERT INTO coe_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Repaʉ chʉova'ʉ pa'iva'ʉ jũnisõsirʉmʉ Diore ja'me pa'inapi ángeleji cʉnaʉmʉna Dios pa'ichejana mʉaasome repava'ʉre, Abrahamni ja'me paaʉ chini. Kuriʉ ũcuaja'che jũnisõasomʉ. Jũnisõʉna pãi repaʉ'te tãasome. ");
INSERT INTO coe_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Kuriʉ pa'isi'kʉta'ni vati toana sani chʉova'ʉ uukʉ pa'iʉ Abrahamre so'opi mʉñe ñaasomʉ. Lázaro'te ũcuaja'che Abrahamna'me ñu'ikʉni ñaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ña cuikʉ Abrahamre ija'che i'kaasomʉ repaʉ: “Ja'kʉ Abraham, chʉ'ʉva'ʉre oijʉ̃'ʉ. Lázaro'te chʉ'ʉre raojʉ̃'ʉ, repaʉ mʉoño chã'tirona okopi chʉ̃ʉ ra chʉ'ʉ chemeñona noʉna asucheji chʉrʉa'kʉ. Toare chʉova'ʉ uukʉ pa'imʉ chʉ'ʉ”, chiniasomʉ repaʉ kuriʉ pa'isi'kʉ Abrahamre. ");
INSERT INTO coe_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jã'aja'ñe i'kakʉ'teta'ni Abraham ija'che i'kaasomʉ repaʉ'te: “Jmava'ʉ, mʉ'ʉ cheja pa'irʉmʉ pa'isi'ere cuasajʉ̃'ʉ. Mʉ'ʉ chiiche peore paasi'kʉa'mʉ mʉ'ʉ. Ikʉ Lázarota'ni chʉova'ʉ pa'isi'kʉa'mʉ. Chura repaʉni re'oja'che ti'jñeʉna pojokʉ pa'imʉ. Mʉ'ʉta'ni mʉ'ʉni cu'ache ti'jñeʉna chʉova'ʉ uukʉ pa'imʉ chura. ");
INSERT INTO coe_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ichejapi mʉ'ʉ pa'ichejajatʉ'ka rũhichenevʉ'me. Jã'ajekʉna icheja pa'inare mʉsanʉkona pa'icheja sañu chiinareta'ni saicu'amʉ. Ũcuaja'che mʉ'ʉ pa'icheja pa'inare rañu chiinareta'ni te'eʉ'terejẽ'e raicu'amʉ icheja chʉkʉna pa'icheja”, chiniasomʉ Abraham repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","’Chikʉna kuriʉ pa'isi'kʉ i'kaasomʉ Abrahamre. “Jã'a pa'ito, ja'kʉ Abraham, chʉ'ʉ mʉ'ʉre iere rʉa sẽeñe sẽemʉ: Chʉ'ʉ cho'jechĩi ʉmʉpãi, cincorepanare paakʉ'mʉ chʉ'ʉ. Chʉ'ʉ ja'kʉ vʉ'ena Lázaro'te saojʉ̃'ʉ, chʉ'ʉ cho'jechĩire Dios chʉ'ore chʉ'vakʉna asa chẽa repana cu'ache cho'oche'te ũhasõrena icheja vati toa raomanea'kʉ Dios”, chiniasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jã'aja'ñe sẽeʉna Abraham i'kaasomʉ repaʉ'te. “Moisés tocha jo'kasi'ena'me Dios chʉ'o kʉasina tocha jo'kasi'e paame repana mʉche'ʉchĩi. Dios chʉ'o tochana tocha jo'kasi'ere ñajʉ che'chejʉ jachamairo paapʉ”, chiniasomʉ Abraham repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chikʉna kuriʉ pa'isi'kʉ i'kaasomʉ repaʉ'te. “Dios chʉ'o tocha jo'kasi'e ñanata'ni jachanaa'me repana. Jã'ata'ni jũni vajʉraisiva'ʉpi sani repanani chʉ'vatota'ni asa chẽa repana cu'ache cho'oche ũhasõ, mama cuasajanaa'me repana”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chikʉna Abraham i'kaasomʉ repaʉ'te. “Dios chʉ'o, Moisés tocha jo'kasi'ena'me Dios chʉ'o kʉasina tocha jo'kasi'e ña jachanaa'me repana. Ña jachanajejʉ jũni vajʉraisiva'ʉpi Dios chʉ'ore chʉ'vato ũcua jachara'ame repana”, chiniasomʉ Abraham kuriʉ pa'isi'kʉre —Jã'aja'ñe kʉaasomʉ Jesús repanare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ũcuarʉmʉ Jesús repaʉ neenare i'kaasomʉ. —Chekʉnare cu'a chʉ'vana pãi si'arʉmʉ pa'inaa'me. Jã'ata'ni chʉ'ʉre cuasava'napi cu'ache cho'oa'jʉ chini cu'ache chʉ'vakʉ'te na'a rʉa cu'ache ti'jñeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pãiʉ'te Diore cuasakʉni te'eʉ'te cu'ache chʉ'vakʉ'te pãipi ija'che cho'oto re'ora'amʉ: Repaʉ chuta'a repaʉ'te cu'a chʉ'vamarʉmʉna toacʉnapʉji rʉa ʉjapʉji repaʉ cavʉna pãipi jepo vẽe chiarana tõ rʉosõru cu'ache pa'ira'amʉ repaʉ'te. Jã'aja'ñe cho'oma'to pa'iʉ chekʉrʉmʉ pãire cu'ache chʉ'vamʉ repaʉ. Pãire repaʉ cu'ache chʉ'va pi'nisirʉmʉ Diopi repaʉ cu'ache cho'osi'e ro'i chʉ̃'ʉto na'a rʉa cu'ache ti'jñeja'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ñarepajʉ pa'ijʉ̃'ʉ, mʉsanʉkona. Mʉ'ʉre kueñe pa'ikʉji mʉ'ʉ majapãiʉja'iʉ pa'iʉ mʉ'ʉni cu'ache cho'oto chʉ'vajʉ̃'ʉ repaʉ'te, jo'e cho'omanea'kʉ. Chʉ'vakʉna, “Cu'ache cho'osi'kʉa'mʉ chʉ'ʉ. Jo'e jã'aja'ñe cho'ocuhemʉ chʉ'ʉ”, chiito repaʉ cu'ache cho'osi'e jo'e cuasamanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chekʉrʉmʉ repaʉ mʉ'ʉre te'eumucuse sieterepañoã cu'ache cho'omʉ. Cu'ache cho'oñoã pa'iche sieterepañoã rani kʉamʉ repaʉ mʉ'ʉre. “Cu'ache cho'osi'kʉa'mʉ chʉ'ʉ. Jo'e cuasamanejʉ̃'ʉ chʉ'ʉ cho'osi'e”, chiimʉ. Jã'aja'ñe chiito repaʉ cu'ache cho'osi'e jo'e cuasamanejʉ̃'ʉ mʉsanʉkona —chiiʉ chʉ'vaasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ũcuarʉmʉ Jesús neena jo'e i'kaasome repaʉ'te. —Diore na'a rʉa cuasañu chiime chʉkʉna. Repaʉ, “Mʉsanʉkonare si'arʉmʉ cho'okaija'mʉ chʉ'ʉ”, chiisi'ere cavesʉmairo na'a rʉa cuasañu chiime chʉkʉna. Chʉkʉna'te cho'okaijʉ̃'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jã'aja'ñe i'karena Jesús i'kaasomʉ. —Mostazara'karʉ rʉa jmara'karʉ'me. Jã'ata'ni repara'karʉ'te tãru sũkiñʉ ʉjañʉ aineemʉ. Mʉsanʉkona ũcuaja'che jmamakarʉ Diore cuasanata'ni Repaʉchi'a cho'omasiche'te cho'ojanaa'me. Mʉsanʉkonapi, “Dios peore masikʉ'mʉ”, chini cuasajʉ iñʉre sicómoroñʉ'te, “Rʉ̃ni sani chiara joopona nʉkajʉ̃'ʉ”, chiito mʉ'ʉ chʉ̃'ʉñe cho'omʉ iñʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ũcuarʉmʉ Jesús jo'e i'kaasomʉ repanare. —Chekʉrʉmʉ mʉsanʉkona te'eʉji cho'oche cho'okaikʉ'te paamʉ. Paakʉna mʉ'ʉre cho'oche cho'okaikʉ mʉ'ʉ chiona sani chejare mu'kakʉ pa'imʉ ãure tãra chini. Chekʉrʉmʉ ovejava'nani kuirakaimʉ. Cho'oche cho'okasa chini saisiva'ʉre vʉ'ena makʉna, “Kaka pʉʉ, ãu ãijʉ̃'ʉ”, chiima'mʉ mʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Ãu chʉ'ʉre cho'okaijʉ̃'ʉ; ãsa. Chʉ'ʉpi ãu ãiʉ ũkukʉna chʉ'ʉ chiiche ũcuaʉache miijani rakaiʉ pa'ijʉ̃'ʉ, chʉ'ʉ ãu ãni pi'niñetʉ'ka. Jã'acho'je mʉ'ʉpi ãijʉ̃'ʉ.” Jã'aja'ñe i'kamʉ mʉ'ʉ, mʉ'ʉre cho'oche cho'okaikʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ũcuachi'a mʉ'ʉre cho'oche cho'okaikʉji mʉ'ʉ chʉ̃'ʉsi'ere masi cho'o pi'niru, “Re'orepamʉ. Rʉa re'oja'che cho'okaimʉ mʉ'ʉ chʉ'ʉre”, chiima'mʉ mʉ'ʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ũcuaja'che mʉsanʉkonapi Dios chʉ̃'ʉsi'ere peore cho'o pi'nini ija'che i'kajʉ̃'ʉ Repaʉ'te: “Rʉa vesʉnaa'me chʉkʉna. Jã'ata'ni mʉ'ʉ chʉ̃'ʉñe cho'okainajejʉ mʉ'ʉ chʉ̃'ʉsimakarʉchi'a cho'osinaa'me chʉkʉna”, chiijʉ̃'ʉ Repaʉ'te —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ũcuarʉmʉ Jesús Jerusalén vʉ'ejoopo sasa chiikʉjekʉ jo'e saiʉ Samaria chejana'me Galilea cheja tʉsʉsima'api saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Vʉ'ejoorʉ sani tĩ'atona ʉmʉpãi asi ravʉ jũ'ina dierepana raniasome repaʉ'te. Rani so'opi nʉkajʉ ñajʉ ʉjachʉ'opi cuijʉ ija'che i'kaasome repana repaʉ'te: —¡Jesús, Masiʉ, chʉkʉnava'nare oijʉ̃'ʉ! —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chitena ña i'kaasomʉ repaʉ. —Mʉsanʉkona ca'nivʉã phairipãire ñojaijʉ̃'ʉ —chiniasomʉ Jesús repanare. Jã'aja'ñe i'kaʉna, “Jaʉ”, chini saijʉna repana asi te'erʉmʉ ja'jusoasomʉ repana ca'nivʉã re'ojaca'nivʉã. ");
INSERT INTO coe_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Vajʉ te'eʉ repaʉ ja'jusica'nivʉ'te meñe sime ña pojokʉ chʉri co'iasomʉ Jesuni. Co'ikʉ Dioni pojokʉ ʉjachʉ'opi, “Rʉa re'okʉ'mʉ mʉ'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jã'aja'ñe i'kakʉ co'i, Jesús pa'ichejana tĩ'a, repaʉni pojokʉ repaʉ ti'jñeñe meñe sime ñu'iʉ, “Re'orepamʉ”, chiniasomʉ repaʉ. Samaria cheja cakʉ paniasomʉ repaʉ asi ravʉ jũ'isi'kʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jã'aja'ñe pojokʉ i'kaʉna Jesús i'kaasomʉ. —Asi ravʉ jũ'inare, dierepanare vasosi'kʉa'mʉ chʉ'ʉ. Chekʉna nueverepanata'ni co'i, “Re'orepamʉ”, chiima'me chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ikʉ tĩipãiʉchi'a judío peokʉji te'eʉ co'i Dioni pojokʉ, “Dios rʉa re'okʉ'mʉ”, chiimʉ. Chekʉnata'ni Diore pojoma'me —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chini Jesús repaʉ'te co'isi'kʉre i'kaasomʉ. —Chura vʉni saijʉ̃'ʉ. “Ikʉ Jesús chʉ'ʉre vasoja'mʉ”, chini cuasasi'kʉjekʉ vajʉcuhasi'kʉa'mʉ mʉ'ʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ũcuarʉmʉ fariseopãi Jesure ija'che sẽniasome: —¿Jeerʉmʉ Dios Raojaʉ rani pãi ũcuanʉkore chʉ̃'ʉja'ʉ? —chiniasome. Chitena Jesús i'kaasomʉ repanare. —Repa chʉ̃'ʉrʉmʉ tĩ'ajañe vesʉme pãi. ");
INSERT INTO coe_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dios Raosi'kʉ repaʉ'te cuasanarechi'a rekoñoãna chʉ̃'ʉkʉ pa'imʉ. Jã'ajekʉna pãi ija'che i'kamanejanaa'me: “Dios Raosi'kʉ ichejare chʉ̃'ʉmʉ.” Ũcuachi'a, “Jã'achejare Dios Raosi'kʉ chʉ̃'ʉmʉ”, chiimanejanaa'me pãi —chiniasomʉ Jesús repanare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chini Jesús repaʉ neenare i'kaasomʉ. —Na'a pa'isirʉmʉ mʉsanʉkona chʉ'ʉ jo'e cajejachere cha'ajʉ, “Dios Raosi'kʉpi jo'e caje, maire te'eumucusechi'a ja'me pa'ito re'ora'amʉ”, chiijʉ cuasajanaa'me mʉsanʉkona. Jã'ata'ni chʉ'ʉ cajerʉmʉ chuta'a tĩ'amaʉna jmamakarʉjẽ'e ñamanejanaa'me mʉsanʉkona chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pãi mʉsanʉkonare ija'che kʉajanaa'me: “Rani ñajʉ̃'ʉ. Dios Raosi'kʉ ichejare pa'imʉ.” Chekʉna, “Sani ñajʉ̃'ʉ. Dios Raosi'kʉ jeechejare pa'imʉ”, chiijanaa'me. Pãipi jã'aja'ñe kʉajʉna ja'me ñañu chini saimanejʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cʉnaʉmʉpi te'ekã'ko oko fe'neni chekʉkã'kojatʉ'ka rʉa na'mi peore miañe fe'ne chʉvokʉna ñame pãi. Ũcuaja'che chʉ'ʉ Dios Raosi'kʉ icheja cheja jo'e cajerʉmʉ pãi ũcuanʉko ñajanaa'me chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jã'ata'ni charo rʉa asi cho'ocojñoja'mʉ chʉ'ʉ. Ũcuachi'a irʉmʉ pa'ina pãi, “Dios Raosi'kʉma'mʉ mʉ'ʉ”, chiijʉ cuheme chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Chʉ'ʉ Dios Raosi'kʉ chejana jo'e cajeumucuse tĩ'api'rarʉmʉ Noé pa'irʉmʉ pa'isina pa'isi'eja'che cu'ache pa'ijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé pa'irʉmʉ pa'isina pãi ãu ãijʉ, cono ũkujʉ, romi vejajʉ, ʉmʉ vejajʉ, repanare ʉache cho'ojʉ paniasome, Dioni cuasamapʉ, repaʉ Noé choovʉ ʉjavʉ kakaumucusejatʉ'ka. Kakasirʉmʉna okopi ra ko'saʉna ũcuanʉko cho'osõasome repana pãi. ");
INSERT INTO coe_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ũcuaja'che chʉ'ʉ cajeumucuse tĩ'api'rarʉmʉ, Lot pa'irʉmʉ pa'isina cu'ache pa'isi'eja'che cu'ache pa'ijanaa'me pãi. Reparʉmʉ pãi ãu ãijʉ, cono ũkujʉ, põse koo ĩsijʉ, repana chiño ãu tãjʉ, vʉ'ña cho'ojʉ paniasome, Dioni cuasamairo pa'ijʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jã'aja'ñe pa'inani repaʉ Lot, Sodoma vʉ'ejoopo pa'isi'kʉpi eta sanisõasomʉ. Repaʉ Lot eta sanisõsirʉmʉna Diopi chʉ̃'ʉʉna cʉnaʉmʉpi toana'me toacatapi repajoopona tuã'tuakʉna pãi peore cho'osõasome. ");
INSERT INTO coe_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lot pa'irʉmʉ cho'osi'eja'che chʉ'ʉ Dios Raosi'kʉ jo'e cajerʉmʉna cu'ache cho'ojʉ pa'ijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Chʉ'ʉ jo'e cajerʉmʉ pãi ũcuaʉana repana vʉ'ña ve'koroãre pani cu'amajñarʉã mini sañu chini repana vʉ'ña kakama'ñe teana vʉ'vʉsõa'jʉ. Ũcuaja'che pãi chiño pa'ina repana vʉ'ña pa'iche'te cu'amajñarʉãre mini sañu chini co'ima'ñe teana vʉ'vʉsõa'jʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot rʉ̃jo cho'ocojñosi'ere cuasa, repao jachasi'eja'che Diore jachamanejʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pãi Dios chʉ̃'ʉñe'te cho'ocuhejʉ repanare ʉachechi'a cho'ojʉ pa'ito cu'amʉ. Jã'aja'ñe cho'onare chʉ'ʉpi rani vati toana saoja'mʉ repanare. Chekʉnareta'ni repanare cho'oʉache ũhasõ, Dios chʉ̃'ʉñe'te cho'ojʉ pa'inareta'ni Dios pa'ichejana saja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ija'chere kʉara chiimʉ chʉ'ʉ mʉsanʉkonare: Chekʉrʉmʉ ángeles ñamipi caje ʉmʉpãi te'eka'chapana ũcuate'eko'a kãinare te'eʉ'te sajʉ chekʉni jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chekʉrʉmʉ romi te'eka'chapana ũcuate'echeja ãu toanare te'eo'te sajʉ chekoni jo'kajanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chekʉrʉmʉ ʉmʉpãi te'eka'chapana chio ũcuate'echio pa'inare ũcuaja'che te'eʉ'te sajʉ chekʉni jo'kajanaa'me —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jã'aja'ñe i'kaʉna chʉ'o sẽniasome repana. —Chʉkʉna'te Paakʉ, ¿jeechejana jã'aja'ñe cho'oja'ʉ? —chiniasome repana. Chitena i'kaasomʉ repaʉ. —Cu'ava'nare jũni jã'jusiva'nare jñaa caje chi'ime vacho —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ũcuarʉmʉ Jesús repaʉ neenani chʉ'vaasomʉ. —Mʉsanʉkona Diore sẽeñe ũhamanejʉ̃'ʉ. Mʉsanʉkona chiiche cuhama'ñe Dioni sẽejʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jã'aja'ñe chʉ'vacuha ija'chere cuasakʉ kʉaasomʉ repaʉ, repanapi si'arʉmʉ Dioni sẽejʉ paapʉ chini: —Diore cuasama'kʉ, pãi chẽañe chʉ̃'ʉkʉ vʉ'ejoopo'te paniasomʉ. Ũcuaja'che pãijẽ'e oima'kʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ũcuarʉmʉ va'jeva'o ũcuajoopo pa'iva'o repaʉ'te pãi chẽañe chʉ̃'ʉkʉ'te si'arʉmʉ mʉa ija'chere kʉako paniasomo: “Pãiʉ chʉ'ʉni pe'rukʉ cu'ache cho'omʉ. Ʉ̃sekaijʉ̃'ʉ chʉ'ʉre repaʉ cu'ache cho'oche jo'e cho'omanea'kʉ”, chiniasomo repao repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Si'arʉmʉ sẽeko'teta'ni rupʉ asakʉ paniasomʉ repaʉ. Jã'ata'ni repaoji rʉarepa sẽeona ija'che cuasaasomʉ repaʉ: “Chʉ'ʉ Diore cuasama'kʉa'mʉ. Ũcuaja'che pãijẽ'e oima'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jã'ata'ni repaoji chʉ'ʉni si'areparʉmʉ mʉta sẽeona asa ca'nasõ cho'okaija'mʉ chʉ'ʉ. Repao'te cho'okatu jo'e mʉtamaneja'mo repao”, chini repao sẽesi'e cho'okaniasomʉ repaʉ —Jã'aja'ñe kʉaasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kʉa pi'ni repanare ija'che i'kaasomʉ repaʉ: —Pãi chẽañe chʉ̃'ʉkʉ cu'akʉ cho'osi'ere cuasa ñajʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Repaʉ pãi chẽañe chʉ̃'ʉkʉ pãi oima'kʉ paniasomʉ. Jã'ata'ni va'jeoji si'areparʉmʉ repaʉji cho'okaaʉ chini sẽeona cho'okaniasomʉ repaʉ. Diota'ni pãi chẽañe chʉ̃'ʉkʉ pa'icheja'che pa'ima'kʉa'mʉ. Jã'ajekʉna Repaʉ chẽa paanapi umucujñana'me ñami Repaʉji cho'okaaʉ chini si'arʉmʉ sẽeto, “Cha'ajʉ̃'ʉ. Na'a pani cho'okaija'mʉ chʉ'ʉ”, chiima'kʉa'mʉ Dios. Repana sẽeñe asa teana cho'okaikʉ'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Repana chiiche na'mi cho'okaikʉ'mʉ Dios. Chʉ'ʉ Dios Raosi'kʉ ichejana jo'e cajeni, ¿Diore cuasajʉ si'arʉmʉ sẽenare ñaja'ñe chʉ'ʉ? —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Reparʉmʉ pãi, “Rʉa re'onaa'me chʉkʉna. Chekʉnata'ni cu'anaa'me”, chiijʉ cuasanapi Jesure ja'me paniasome. Jã'aja'ñe cuasajʉna repanani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ Jesús: ");
INSERT INTO coe_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ʉmʉpãi te'eka'chapana fariseopãiʉna'me pãi chʉ̃'ʉnare kuri kookaikʉ Dios vʉ'ena mʉa kakaasome Dioni sẽeñu chini. ");
INSERT INTO coe_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ũcuarʉmʉ fariseopãiʉ nʉkakʉ ija'che sẽniasomʉ: “Ãa, Ja'kʉ Dios, chekʉna pãi cu'ache cho'ome. Põse ñaame. Ũcuaja'che chekʉnare ũcuarepa cho'oma'me. Ũcuaja'che rʉ̃joromi peonare ja'me kãijʉ pa'ime. Chʉ'ʉta'ni chekʉna cho'ocheja'che cu'ache cho'oma'kʉa'mʉ. Ikʉ kuri kookaikʉ ũcuaja'che kuri cajejaiche sẽni koo kʉamairo paakʉ'mʉ. Chʉ'ʉta'ni jã'aja'ñe cho'oma'kʉa'mʉ. Re'okʉ'mʉ chʉ'ʉ. Re'okʉjekʉ mʉ'ʉni pojokʉ mʉ'ʉre re'orepamʉ chiiʉ pa'ikʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Te'esemana te'eka'chapañoã ãu ãimairo pa'ikʉ'mʉ chʉ'ʉ, mʉ'ʉni pojokʉ. Chʉ'ʉ cho'oche cho'osi'ere pãipi chʉ'ʉni ro'ito aperʉmʉ mʉ'ʉ ĩsijʉ̃'ʉ chiisinʉkorʉ kuẽkue ña karama'ñe ĩsikʉ'mʉ chʉ'ʉ mʉ'ʉre. Chekʉrʉmʉ kurire're dierepare're kooni te'ere'rerʉ ĩsikʉ'mʉ chʉ'ʉ. Chekʉrʉmʉ cienrepare'rerʉã kooni dierepare're ĩsikʉ'mʉ chʉ'ʉ mʉ'ʉre. Jã'aja'ñechi'a ĩsikʉ'mʉ chʉ'ʉ mʉ'ʉre”, chiiʉ sẽniasomʉ repaʉ fariseopãiʉ. Cu'ache cho'okʉta'ni re'oja'che cho'ochechi'a kʉaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chekʉ kuri kookaikʉta'ni repaʉ cu'ache cho'osi'ere cuasa cʉnaʉmʉ Dios pa'ichejajekʉna ñavajʉchʉkʉ so'ore sʉmava'ʉ meñe sime nʉkakʉ paniasomʉ. Sʉmava'ʉ nʉkasi'kʉpi ã'capʉna vaiʉ Diore ija'che sẽniasomʉ repaʉ: “Ãa, Ja'kʉ Dios, cu'ache pa'ikʉ'mʉ chʉ'ʉ. Jã'ata'ni oijʉ̃'ʉ chʉ'ʉva'ʉre”, chiniasomʉ repaʉ —Jã'aja'ñe kʉaasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kʉacuha jo'e i'kaasomʉ repaʉ. —Asarepajʉ̃'ʉ mʉsanʉkona. Sẽni pi'ni eta repana vʉ'ñana co'iasome repana. Kuri kookaikʉji ũcuaʉji meñe, “Cu'ache pa'ikʉ'mʉ chʉ'ʉ”, chiiʉ Dioni sẽkʉna repaʉ cu'ache cho'osi'e tʉnosõkani, “Cu'ache cho'osi'e ro'iche peomʉ ikʉre”, chiniasomʉ Dios. Chekʉreta'ni repaʉji, “Re'oja'chechi'a cho'okʉ'mʉ chʉ'ʉ”, chikʉna repaʉ cu'ache cho'osi'e tʉnokaimaneasomʉ Dios. “Repaʉ cu'ache cho'oche kʉamanesi'e ro'iche pa'imʉ ikʉre”, chiniasomʉ Dios. Pãi te'ena, cu'ache cho'onata'ni, “Re'onaa'me chʉkʉna”, chiime, chekʉnapi asa, “Re'onaa'me jã'ana”, chiapʉ chini. Repana cu'ache cho'oche'te Dioni kʉamapʉna repana cu'ache cho'oche tʉnokaima'mʉ Dios. Diopi ñato cu'anaa'me repana. Jã'ata'ni chekʉna pãi, “Cu'ache cho'okʉ'mʉ chʉ'ʉ”, chini cuasa Dioni kʉajʉna repana cu'ache cho'oche tʉnokaimʉ Dios, repanani oiʉ. Diopi ñato re'onaa'me repana, cu'ache cho'oche tʉnosõcojñosinajejʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ũcuarʉmʉ pãi Jesús pa'ichejana repana chĩiva'nare raasome, Repaʉji chẽsekʉ Dioni re'oja'chere sẽekaaʉ chini. Jã'aja'ñe rajʉna ña repaʉ neena ʉ̃seasome repanare. ");
INSERT INTO coe_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ʉ̃sejʉna Jesús repaʉ neenare soni i'kaasomʉ. —Chĩiva'nare raiʉ̃semanejʉ̃'ʉ mʉsanʉkona chʉ'ʉni raapʉ. Iva'na chĩiva'naja'ñe pa'ijʉ chʉ'ʉre masi cuasanapi Dios chʉ'o asa chẽajanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jã'ata'ni iva'na chĩiva'na chʉ'ʉre masi cuasacheja'che masi cuasamana Dios chʉ'o asa chẽamanejanaa'me. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ũcuarʉmʉ judíopãi chʉ̃'ʉkʉ kuriʉ Jesuni chʉ'o sẽniasomʉ. —Masiʉ, re'okʉ'mʉ mʉ'ʉ. ¿Je'se cho'oni'te Dios pa'icheja saija'che chʉ'ʉ? —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chikʉna Jesús i'kaasomʉ repaʉ'te. —¿Je'se cuasa, “Re'okʉ'mʉ mʉ'ʉ”, chiikʉ mʉ'ʉ chʉ'ʉre? Diochi'aa'mʉ Re'okʉ. Chekʉ pãiʉ re'okʉ peomʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aperʉmʉ Dios chʉ̃'ʉ jo'kasi'e masicosomʉ mʉ'ʉ. Ija'che kʉamʉ repa: Mʉsanʉkona ʉmʉpãi romi paana chekʉnare romi ja'me kãimanejʉ̃'ʉ. Ũcuaja'che romi ʉmʉ pa'ina chekʉnare ʉmʉpãi ja'me kãimanejʉ̃'ʉ. Ũcuachi'a pãi vanisõmanejʉ̃'ʉ. Chekʉna nee ñaamanejʉ̃'ʉ. Chekʉna pa'iche'te kʉani joremanejʉ̃'ʉ. Ũcuaja'che mʉja'kʉpãi ña kʉkʉjʉ̃'ʉ. Jã'aja'ñe chʉ̃'ʉsi'kʉa'mʉ Dios —chiniasomʉ Jesús repaʉ'te kuriʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chikʉna i'kaasomʉ repaʉ. —Chĩirʉmʉpi irʉmʉjatʉ'ka Dios chʉ̃'ʉ jo'kasi'e peore jã'a jachama'ñe cho'okʉ pa'ikʉ'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jã'aja'ñe i'kaʉna Jesús ija'che i'kaasomʉ repaʉ'te: —Ũcuarepa cho'okʉ'teta'ni karamʉ mʉ'ʉre. Mʉ'ʉ paache cu'amajñarʉãre peore ĩsisõ, kuri koo chʉova'na pa'iva'nani rupʉ ĩsijʉ̃'ʉ. Ĩsisõjani rani chʉ'ʉna'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oni'te Dios pa'ichejana sani re'oja'che pa'ija'mʉ mʉ'ʉ —chiniasomʉ Jesús repaʉ'te kuriʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesupi jã'aja'ñe i'kaʉna asa, ĩsicuhekʉ sʉmava'ʉ paniasomʉ repaʉ, rʉa kuriʉjekʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sʉmava'ʉ pa'iʉna ña Jesús ija'che i'kaasomʉ repaʉ'te: —Pãi kurinare Dios pa'icheja saineenareta'ni saicu'aja'mʉ, repanapi kurire na'a rʉa cuasajʉ Dioni cuasama'to. ");
INSERT INTO coe_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camellova'ʉre miuñakarʉ cojerʉ kaka etajaicu'acheja'che kuriʉ'te Dios pa'icheja saicu'aja'mʉ, repaʉji kurire na'a rʉa cuasakʉ pa'ito —chiniasomʉ Jesús repaʉ'te kuriʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesús i'kache asasina ija'che sẽniasome repaʉ'te: —Jã'a pa'ito, ¿je'se cho'onani Dios pa'icheja saire'oja'ʉ? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chitena Jesús i'kaasomʉ. —Maichi'a te'ena cuasajʉna Dios pa'icheja saicu'amʉ maire pãi. Diopi cho'okaitota'ni Repaʉ pa'icheja saiche vesama'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chikʉna Pedro i'kaasomʉ. —Chʉkʉna mʉ'ʉna'me pañu chini chʉkʉna paasimajñarʉã peore jo'kasõ rani mʉ'ʉna'me ku'ime —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Pãiʉ ũcuaʉakʉ Dios chʉ̃'ʉñe'te cho'okʉ pasa chiikʉ chekʉrʉmʉ repaʉ vʉ'ere jo'kasõmʉ. Chekʉrʉmʉ repaʉ rʉ̃joni jo'kasõmʉ. Chekʉrʉmʉ repaʉ majaa'chʉpãire jo'kasõmʉ. Chekʉrʉmʉ repaʉ cho'jechĩire jo'kasõmʉ. Chekʉrʉmʉ repaʉ pʉka'kʉpãire jo'kasõmʉ. Chekʉrʉmʉ repaʉ chĩire jo'kasõni repaʉ aperʉmʉ paasinʉko na'a rʉa jñaaja'mʉ repaʉ, icheja cheja pa'irʉmʉ. Ũcuaja'che jũnisõsirʉmʉ Dios pa'ichejare ai sani pa'ija'mʉ repaʉ. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ũcuarʉmʉ Jesús repaʉ neenare docerepanare soni ija'che kʉaasomʉ: —Jerusalén vʉ'ejoopona maijanaa'me mai chura. Aperʉmʉ Dios chʉ'o kʉana tocha jo'kasi'e chʉ'ʉ Dios Raosi'kʉ cho'ocojñojañere kʉame. Repana kʉajʉ tocha jo'kasi'e Jerusalenna ti'jñeja'mʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Judíopãipi judío peonani jo'kajanaa'me chʉ'ʉre, repanapi cu'ache cho'oa'jʉ chini. Rʉa cu'ache cutujʉ pãisojʉ coo tutujanaa'me repana chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ũcuachi'a suĩ'sue pi'ni vanisõjanaa'me repana chʉ'ʉre. Jã'ata'ni choteumucujñana vajʉraija'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Repaʉ kʉache asanata'ni jmamakarʉjẽ'e asa chẽamaneasome repana. Diopi repanani asa chẽañe'te ʉ̃sekʉna asavesʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Repaʉ Jesús Jericó vʉ'ejoopo tĩ'acuhato na'ava'ʉ ma'a rʉ'tʉva'te ñu'iʉ kurire sẽeʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ñu'iʉna pãipi jainʉko ũcuachejapi caraijʉna asa, —¿Je'se cho'oche ina? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chikʉna, —Jesús, Nazaret vʉ'ejoopo raisi'kʉpi caraimʉ —chiniasome pãi repaʉ'te ja'me saina. ");
INSERT INTO coe_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chitena asa ʉjachʉ'opi ija'che cuikʉ i'kaasomʉ repaʉ: —Jesús, David aperʉmʉ pa'isi'kʉ Jojosi'kʉ, oijʉ̃'ʉ chʉ'ʉva'ʉre —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I'kaʉna asa charo saina, —Re'omʉ. Jo'e i'kamanejʉ̃'ʉ —chiniasome repaʉ'te. Jo'e i'kamanejʉ̃'ʉ chiinareta'ni na'a rʉa cuikʉ i'kaasomʉ repaʉ. —Jesús, David aperʉmʉ pa'isi'kʉ Jojosi'kʉ, oijʉ̃'ʉ chʉ'ʉva'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jã'aja'ñe i'kakʉ cuikʉna asa canʉka, —Chʉ'ʉni rajʉ̃'ʉ repaʉ'te —chiniasomʉ Jesús repanare. Chikʉna repaʉni kueñe rarena Jesús ija'che sẽniasomʉ repaʉ'te: ");
INSERT INTO coe_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ʉ̃quere cho'okaaʉ chini sẽekʉ mʉ'ʉ chʉ'ʉre? —chiniasomʉ Jesús repaʉ'te. Chikʉna, —Pãi Ũcuanʉkore Paakʉ, chʉ'ʉ ñakocaã ñoa'kʉ chiimʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chikʉna Jesús i'kaasomʉ. —Mʉ'ʉ ñakocaã ñoa'kʉ mʉ'ʉre. “Jesús chʉ'ʉre vasoja'mʉ”, chini cuasasi'kʉjekʉ vajʉcuhamʉ mʉ'ʉ chura —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesupi jã'aja'ñe i'kakʉna repaʉ ñakocaã teana care'osoasomʉ. Care'oʉna Jesuna'me saiʉ Dioni pojokʉ, “Rʉa re'okʉ'mʉ mʉ'ʉ”, chiniasomʉ repaʉ. Chekʉna ũcuaja'che repaʉ'te cho'osi'ere ña, “Dios peore masikʉ'mʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Ũcuarʉmʉ Jesús Jericó vʉ'ejoopo tĩ'a mʉato ũcuajoopo'te pãiʉ kuriʉ paniasomʉ. Repaʉ mamia'me Zaqueo. Pãi chʉ̃'ʉnare kuri kookainare chʉ̃'ʉkʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Repaʉ Zaqueo Jesure ñara chiikʉta'ni chejarʉ nʉkakʉjekʉ pãipi jairepanʉkojejʉna ñamaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñamanesi'kʉjekʉ Jesuni ñara chini charona vʉ'vʉ sũkiñʉ sicómoroñʉna mʉni tuhiʉ cha'aasomʉ repaʉ, “Jesús ichejapi caraija'mʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tuhiʉ cha'akʉna repaʉ Jesús ũcuachejana sani tĩ'a caraipi'rakʉji mʉñe ña sũkiñʉ tuhikʉ'te Zaqueo'te ija'che i'kaasomʉ: —Zaqueo, pesa cajejʉ̃'ʉ. Chura iumucuse mʉ'ʉ vʉ'ena canʉkache paamʉ chʉ'ʉ —chiniasomʉ repaʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jesupi jã'aja'ñe i'kaʉna asa pojokʉ na'mi caje repaʉ vʉ'ena mʉvaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mʉvakʉna ña pãi ũcuanʉko pe'rujʉ cu'ache i'kaasome Jesure. “Pãiʉ cu'akʉ vʉ'ena canʉkara chini mʉamʉ jã'ʉ Jesús”, chiniasome repana ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ũcuarʉmʉ repaʉ Zaqueo repaʉ vʉ'ere pa'iʉ vʉni nʉkakʉ i'kaasomʉ Jesure. —Ñakʉ, Pãi Ũcuanʉkore Paakʉ. Chura chʉ'ʉ paache cu'amajñarʉã chʉova'na pa'iva'nani joopo rupʉ ĩsija'mʉ chʉ'ʉ. Ũcuaja'che chʉ'ʉ jorekʉ chekʉnare na'a cajejaiche sẽni koosinʉko kuri ũcuaka'chapañoã jo'e ũcuajanʉko jovo co'choja'mʉ chʉ'ʉ repanare —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Mai aipãiʉ Abraham jojosi'kʉa'mʉ mʉ'ʉ. Iumucuse ivʉ'e pa'inare mʉsanʉkonani oiʉ chẽamʉ Dios, jũnisõsirʉmʉ vati toana saimanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chʉ'ʉ, Dios Raosi'kʉ, pãipi jũnisõ vati toana saimanea'jʉ chini chejana cajesi'kʉa'mʉ. Repanare chẽa paakʉ repana cu'ache cho'ocojñora'asi'e ʉ̃sekani paaja'mʉ chʉ'ʉ —chiniasomʉ Jesús repaʉ'te Zaqueo'te. ");
INSERT INTO coe_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesupi jã'aja'ñe i'kaʉna asa, repaʉji Jerusalén vʉ'ejoopona tĩ'api'rakʉna ija'che cuasaasome repana pãi: “Ikʉ Jerusalén vʉ'ejoopona tĩ'a teana pãi ũcuanʉkore chʉ̃'ʉja'mʉ”, chini cuasajʉna repanani chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ repaʉ, jã'aja'ñe cuasamanea'jʉ chini: ");
INSERT INTO coe_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Pãiʉ pa'ipãiʉ paniasomʉ. Repaʉni pãi chʉ̃'ʉkʉ'te jo'kañu chini chekʉcheja cana soniasome repaʉ'te. Sotena chekʉchejana so'ona saniasomʉ repaʉ, repanapi repaʉni pãi chʉ̃'ʉkʉ'te jo'karena repaʉ pa'icheja canani co'i chʉ̃'ʉra chini. ");
INSERT INTO coe_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Saipi'rakʉ repaʉ'te cho'oche cho'okainare dierepanare soniasomʉ repaʉ. Soni rao pachokurire're te'ere'rechi'a ĩsi pi'ni ija'che i'kaasomʉ repaʉ repanare: “Chura chʉ'ʉ ĩsisire're kurire'repi põsere koo ĩsijʉ na'a rʉa kurire koojʉ pa'ijʉ̃'ʉ. Chʉ'ʉ rairʉmʉjatʉ'ka jã'aja'ñe cho'ojʉ pa'ijʉ̃'ʉ mʉsanʉkona”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Chini jo'ka sanisõʉna repaʉ pa'icheja cana pãi, repaʉni cuhejʉ, te'enare pãi jñaa saoasome, repaʉ saisijoopona tuha chʉ̃'ʉñe jo'kajanani, “Ikʉ chʉ̃'ʉñe cuheme chʉkʉna”, chiapʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Cuhecheta'ni ũcua pãi chʉ̃'ʉkʉ'te jo'kaasome repana repaʉ'te. Pãi chʉ̃'ʉkʉ'te jo'karena repaʉ pa'ichejana co'i, repaʉ'te cho'oche cho'okainare repaʉ kuri ĩsisinani soapʉ chini chʉ̃'ʉasomʉ repaʉ, repana koosinʉkore kurire masira chini. ");
INSERT INTO coe_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sotena charo te'eʉ rani ija'che kʉaasomʉ: “Chʉ'ʉre paakʉ, mʉ'ʉ chʉ'ʉre ĩsisire'reva kurire'revaji põsere koo ĩsikʉ dierepare're koosi'kʉa'mʉ chʉ'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chikʉna i'kaasomʉ repaʉ. “Mʉ'ʉ rʉa masi cho'osi'kʉa'mʉ. Kuri ka'charʉ koosi'kʉta'ni na'a rʉa jñaasi'kʉa'mʉ mʉ'ʉ. Masi cho'osi'kʉjekʉna vʉ'ñajoopoã dierepajoopoã pa'inani pãire chʉ̃'ʉa'kʉ chini jo'kamʉ chʉ'ʉ mʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kʉacuhaʉna chekʉ ũcuaja'che kurire'reva koosi'kʉ rani kʉaasomʉ. “Chʉ'ʉre paakʉ, kurire'reva mʉ'ʉ chʉ'ʉre ĩsisire'revaji põsere koo ĩsikʉ cincorepare're koosi'kʉa'mʉ chʉ'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jã'aja'ñe kʉaʉna repaʉ'te paakʉ ija'che i'kaasomʉ: “Re'orepamʉ. Vʉ'ñajoopoã cincorepajoopoã pa'inani pãire chʉ̃'ʉa'kʉ chini jo'kamʉ chʉ'ʉ mʉ'ʉre”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Kʉacuhaʉna chekʉ kurire'reva koosi'kʉ rani kʉaasomʉ. “Chʉ'ʉre paakʉ, mʉ'ʉ chʉ'ʉre ĩsisire'reva kurire'reva ũcuare'reva co'chamʉ chʉ'ʉ mʉ'ʉre. Mʉ'ʉpi ĩsiʉna koo kãase'rechoji rea care'va paakʉ pa'isi'kʉa'mʉ chʉ'ʉ repare'reva. ");
INSERT INTO coe_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉ'ʉre cho'oche cho'okainare oima'kʉa'mʉ mʉ'ʉ. Chekʉna cho'oche cho'o koosi'e kuri tʉasõkʉ'mʉ mʉ'ʉ. Ũcuaja'che ãu chekʉna tãsi'e tʉasõkʉ'mʉ mʉ'ʉ. Jã'ajekʉna jã'are vajʉchʉkʉ mʉ'ʉ chʉ'ʉre ĩsisire'reva kurire'reva rupʉ paasi'kʉa'mʉ chʉ'ʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Repaʉ kurire'reva care'va paasi'ere kʉaʉna asa repaʉ'te paakʉ ija'che i'kaasomʉ repaʉ'te: “Rʉa cu'akʉ'mʉ mʉ'ʉ. Mʉ'ʉpi jã'aja'ñe cuasakʉ cho'omaneʉna asa pe'rukʉ cu'ache cho'oja'mʉ chʉ'ʉ mʉ'ʉre. Chʉ'ʉ pãi oima'ñena'me chekʉna cho'oche cho'o koosi'e kuri tʉachena'me chʉ'ʉ chekʉna tãsi'e ãu chʉ'ʉ tʉache masikʉta'ni, ¿je'se pa'iʉna mʉ'ʉ chʉ'ʉ ĩsisire'reva kurire'reva kuri vʉ'ena sa jo'kamaneʉ? Sa jo'karu rani na'a rʉa koora'asi'kʉa'mʉ chʉ'ʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chini chekʉnare ũcuacheja nʉkanare i'kaasomʉ repaʉ. “Repaʉ koosire'reva kurire'reva tʉa, chekʉni ĩsijʉ̃'ʉ dierepare're kurire're koosi'kʉni”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chikʉna i'kaasome repana. “Jã'ata'ni jã'ʉ ũcuare kurire're dierepare're paamʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chitena repanare i'kaasomʉ repaʉ. “Asarepajʉ̃'ʉ, mʉsanʉkona. Ija'chea'me: Pãiʉ ũcuaʉache'te koo masi paakʉ ũcuare paakʉta'ni na'a rʉa kooja'mʉ. Jã'ata'ni jmanʉkorʉ koosi'kʉpi masi paama'kʉ repaʉ paache rʉa jmanʉkorʉta'ni peore tʉasõcojñoja'mʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chini, “Chura chʉ'ʉni cuhejʉ, chʉ'ʉ chʉ̃'ʉñe cuhenare chẽa ichejana ra chʉ'ʉ ñakʉ'te vanisõjʉ̃'ʉ”, chiniasomʉ pãi chʉ̃'ʉkʉ repanare —Jã'aja'ñe kʉaasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jã'aja'ñe kʉa pi'ni Jerusalenna tĩ'ara chini jo'e saiʉ aikũtina mʉniasomʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mʉiʉ Betfagé vʉ'ejoopona'me Betania vʉ'ejoopo Olivo aikũti pa'ijoopoãna kueñe tĩ'aasomʉ repaʉ. Repajoopoã kueñe tĩ'a repaʉ neenare te'eka'chapanare soniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Repanare soni ija'che chʉ̃'ʉasomʉ repaʉ: —Jeejoopona kueñe cajoopona saijʉ̃'ʉ mʉsanʉkona. Sani tĩ'a burrova'ʉre quẽo sʉosiva'ʉre, pãi chuta'a tuhimava'ʉni jñaajanaa'me mʉsanʉkona. Jñaa repava'ʉre jose ichejana rakaijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pãiʉ ũcuaʉakʉji mʉsanʉkonare, “¿Ʉ̃que cho'oñu chini mʉsanʉkona jã'ava'ʉre joseche?”, chiito, “Maire Paakʉ iva'ʉre chiimʉ”, chiijʉ̃'ʉ repanare —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chikʉna repana sani ñato Jesús i'kasi'e ũcua paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrova'ʉre quẽo sʉosiva'ʉjekʉna josejʉna repava'ʉre paana i'kaasome. —¿Ʉ̃que cho'oñu chini mʉsanʉkona jã'ava'ʉre joseche? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chitena i'kaasome repana. —Maire Paakʉ iva'ʉre chiimʉ —chiniasome repana repanare. ");
INSERT INTO coe_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chini repava'ʉre burrova'ʉre Jesús pa'ichejana sa repaʉ sõkʉñʉna kãñapi tujñacuha Jesure tʉoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tʉorena tuhiʉ saiʉna repaʉ saima'ana kãña jaasome pãi, repaʉni pojojʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jarena ũcuama'api saiʉ Olivo aikũtipi Jerusalén cajechejana kueñe tĩ'aasomʉ repaʉ. Tĩ'akʉna Diochi'a te'eʉ cho'omasiche'te repaʉji cho'okʉna ñasi'ere cuasajʉ repaʉ'te chiina ũcuanʉko Dioni pojojʉ, “Rʉa re'okʉ'mʉ mʉ'ʉ”, chiijʉ cuijʉ ʉjachʉ'opi i'kaasome. ");
INSERT INTO coe_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ũcuachi'a ija'che i'kaasome: —¡Diopi ikʉre pãire chʉ̃'ʉa'kʉ chini Repaʉ Raosi'kʉre re'oja'che cho'okaaʉ! ¡Cʉnaʉmʉ pa'ina pojojʉ paapʉ! ¡Pãi ũcuanʉko, “Cʉnaʉmʉ Pa'ikʉ Dios peore masikʉ'mʉ”, chiapʉ! —chiniasome repana Jesure chiina ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jã'aja'ñe i'kajʉna ũcuanana'me pa'ina fariseopãi asa pe'rujʉ ija'che i'kaasome repaʉ'te Jesure: —Masiʉ, mʉ'ʉre chiinare jã'aja'ñe i'kache ʉ̃sejʉ̃'ʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chitena Jesús i'kaasomʉ repanare. —Ʉ̃sema'mʉ chʉ'ʉ. Inapi jã'aja'ñe cuijʉ i'kama'to catapi ũcuare i'kakʉ cuira'amʉ —chiniasomʉ Jesús repanare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chini na'a kueñe tĩ'a Jerusalén vʉ'ejoopo'te ña oniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Oiʉ ija'che i'kaasomʉ: —Dios mʉsanʉkonare Jerusalén pa'inare pa'iche rʉa re'oja'chere jo'kara chiimʉ, Repaʉni cuasajʉ pojojʉ paapʉ chini. Jã'ata'ni cuheme mʉsanʉkona. Cuhejʉ re'oja'che pa'iche vesʉme mʉsanʉkona, Diopi ʉ̃sekʉna. ");
INSERT INTO coe_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Mʉsanʉkonare cu'ache ti'jñerʉmʉ tĩ'acuhaja'mʉ. Mʉsanʉkonare cuhena ijoopona rani si'acajoopo rʉ'tʉna pachu cha'opi rũhiso'koro ñekua timu ũcuachejñapi pachu mʉni kakajanaa'me. Mʉsanʉkonapi vajʉchʉjʉ eta vʉ'vʉsõñu chiito ʉ̃sejʉ ijoopo ñañosõjanaa'me repana. Ñañosõsirʉmʉ vʉ'ña je'nasi'pʉã catapʉã te'epʉjẽ'e chekʉpʉna'me sʉ'imaneja'mʉ. Mʉsanʉkonare ainana'me chĩiva'nare vanisõjanaa'me repana. Chʉ'ʉni Dios Raosi'kʉni cuhejʉna cu'ache ti'jñeja'mʉ mʉsanʉkonare. Chʉ'ʉre cuheche ro'ia'me jã'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ũcuarʉmʉ Jesús Dios vʉ'ena kaka repavʉ'e põse ĩsinare eto saoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Repanani eto saokʉ ija'che i'kaasomʉ repaʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉ vʉ'e pãi chʉ'ʉre pojojʉ sẽevʉ'ea'me, chiimʉ. Jã'ata'ni mʉsanʉkona põse ñaana cho'ocheja'che kaka cu'ache cho'ome ivʉ'e —chiiʉ eto saoasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Reparʉmʉ Jesús Dios vʉ'e si'aumucujña kaka che'choasomʉ. Jã'ata'ni phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me pãi chʉ̃'ʉna, “¿Je'sepi vanisore'okʉ ikʉre?”, chiniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jã'ata'ni pãipi ũcuanʉko repaʉ che'choche'te asaneejʉna cho'ocu'aasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Reparʉmʉ Jesús Dios vʉ'ere pa'iʉ Dios chʉ'o re'oja'chere chʉ'vakʉ paniasomʉ repanare pãi. Chʉ'vakʉna judío phairipãi chʉ̃'ʉnana'me judíopãi che'chonana'me judío aina raniasome. ");
INSERT INTO coe_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rani repaʉ'te chʉ'o sẽniasome repana. —¿Je'se cuasa pãi chʉ̃'ʉna cho'ocheja'che rani cho'okʉ mʉ'ʉ? ¿Neepi chʉ̃'ʉrena cho'okʉ mʉ'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sẽejʉna repanare i'kaasomʉ repaʉ. —Chʉ'ʉ ũcuaja'che mʉsanʉkonani chʉ'o sẽniasara. Sẽeʉna kʉajʉ̃'ʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Neepi Juanre Pãi Okoro'vekʉ'te chẽa raore? ¿Diopi raoʉ? Jã'apãani, ¿pãipi chẽa raore repaʉ'te? —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sẽkʉna sãiñechi'a ija'che cutuasome repana: —¿Je'se mai ikʉre i'kajanaa'ñe? Maipi, “Juanre Diopi chẽa raosi'kʉa'mʉ”, chiito ikʉ maire, “¿Mʉsanʉkona je'se pa'iʉna jã'aja'ñe cuasanata'ni Juan chʉ'vasi'e cuasamanere?”, chiija'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ũcuaja'che, “Pãipi chẽa raosinaa'me”, chiicu'amʉ maire. Ina pãi jainʉko, “Juan Dios chʉ'o kʉakaikʉ pa'isi'kʉa'mʉ”, chiijʉ cuasame. Jã'ajekʉna maipi jã'aja'ñe i'kato ina pãi asa pe'rujʉ ũcuanʉko catapi su'a vẽasojanaa'me maire —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sãiñechi'a jã'aja'ñe cutu pi'ni Jesure ija'che i'kaasome repana: —Juanre okoro'vea'kʉ chini raosi'kʉre vesʉme chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chitena Jesús i'kaasomʉ. —Chʉ'ʉ ũcuaja'che mʉsanʉkonapi jã'aja'ñe i'karena chʉ'ʉre chʉ̃'ʉ raosi'kʉ mami kʉamaneja'mʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ũcuarʉmʉ Jesús pãire jo'e chʉ'vakʉ ija'chere cuasakʉ kʉaasomʉ: —Pãiʉ pĩsi ʉche chio tã pi'ni repachio kuirakaijanare jñaa jo'ka, “Ichio ʉche tʉarʉmʉ tĩ'aʉna tʉajʉ̃'ʉ. Reparʉmʉ chʉ'ʉre cho'oche cho'okaikʉ'te ichejana raoja'mʉ chʉ'ʉ, chʉ'ʉni ʉchere miiraikaaʉ chini”, chiniasomʉ repaʉ. Chini jo'ka tĩichejana sanisõasomʉ repaʉ rʉa jeerʉmʉ pasa chini. ");
INSERT INTO coe_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ʉche tʉarʉmʉ tĩ'aʉna repaʉ'te cho'oche cho'okaikʉ'te ʉche chio kuirakaina pa'ichejana saoasomʉ repaʉ, ʉchere miijani rakaaʉ chini. Jã'ata'ni repana ʉche kuirana sani tĩ'aʉna ña repaʉ'te chẽa vani ʉchejẽ'e peoʉ'te co'choasome repaʉ'te, ʉche paakʉ pa'ichejana. ");
INSERT INTO coe_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Co'chorena ʉche paakʉ repaʉ'te cho'oche cho'okaikʉ'te chekʉni jo'e ũcuachejana saoʉna sani tĩ'aʉna ʉche kuirakaina repaʉ'te ũcuaja'che vaniasome. Vani repaʉ'te rʉa cu'ache cutu pi'ni ʉchejẽ'e peoʉ'te co'choasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Co'chorena jo'e chekʉni saoʉna ũcuaja'che asi vani kʉko co'chosõasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Jã'aja'ñe cho'orena ʉche paakʉ cuasakʉ te'eʉji ija'che i'kaasomʉ: “¿Je'se cho'oja'che chʉ'ʉ? Chʉ'ʉ chĩini chʉ'ʉ rʉa oiʉ paava'ʉni repana pa'ichejana saora. Jã'ʉreta'ni ña kʉkʉjacosome repana”, chiiʉ cuasaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jã'aja'ñe cuasa repaʉ mamakʉni saoʉna ʉche chiona sani tĩ'aʉna ña repachio kuirana ija'che i'kaasome: “Jã'ʉ ʉche paakʉ mamakʉ'mʉ. Pʉka'kʉ jũnisõsirʉmʉ pʉka'kʉ paasi'e paajaʉa'mʉ jã'ʉ. Vanisõñu jã'ʉni. Maipi jã'ʉni vanisõni pʉka'kʉ jũnisõsirʉmʉ repaʉ paasi'e maipi paajanaa'me”, chiniasome repana sãiñechi'a. ");
INSERT INTO coe_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chini repaʉ'te chẽa chio rʉ'tʉvana juha sa vanisõasome repana —chiniasomʉ Jesús repanare pãi. Jã'aja'ñe kʉa pi'ni repaʉ kʉasi'e asasinare ija'che sẽniasomʉ repaʉ: —Repaʉ mamakʉ'te vanisõsi'ere asa ʉche chio paakʉji sani, ¿je'se cho'oja'ʉ repanare ʉche kuirakainare? ");
INSERT INTO coe_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ija'che cho'oja'mʉ repaʉ ʉche paakʉ: Ʉche chiona sani repaʉ mamakʉ'te vanisõsinare sãiñe vanisõja'mʉ repaʉ. Repanare vanisõ ʉche chio kuirakaijanare chekʉnani jñaa jo'kaja'mʉ repaʉ, ʉche chiore kuiraa'jʉ chini —chiniasomʉ Jesús repanare pãi. Jã'aja'ñe i'kaʉna asa, —¡Dios chʉkʉna'te jã'aja'ñe cho'omanea'kʉ! —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chitena Jesús repanani ñakʉ i'kaasomʉ. —Aperʉmʉ tocha jo'kasi'ere, Dios chʉ'ore asa chẽajʉ̃'ʉ mʉsanʉkona, ija'che chiiche'te: Pãi vʉ'e cho'ona vʉ'ña tuu re'ojatuure ku'ejʉ paniasome. Ku'ejʉ te'etuupʉ jñaani cuheasome repana. Cuhejʉ jo'kaasome repatuupʉ. Chekʉnata'ni na'a rʉa masinajejʉ rani repatuupʉ mini kuãa sa repana vʉ'e chakavʉna nʉkoasome, repana vʉ'epi na'a rʉa jʉjaa'kʉ chini, chiimʉ repa. ");
INSERT INTO coe_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pãiʉ vʉ'e tuupʉna tãni rʉa asi tãimʉ. Ũcuachi'a vʉ'e tuupʉji pãiʉni tãito jũnisõmʉ. Ũcuaja'che pãi chʉ'ʉre cuhenare rʉa cu'ache ti'jñeja'mʉ. Jũnisõsirʉmʉ vati toana sani uujanaa'me repana —chiniasomʉ Jesús repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesupi jã'aja'ñe i'kaʉna judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona ija'che cuasaasome: “Ikʉ Jesús jã'aja'ñe i'kacheji maini cu'ache i'kamʉ. Churana teana chẽañu ikʉre”, chiniasome repana. Chiisinata'ni pãire vajʉchʉjʉ repaʉ'te chẽamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Repaʉni chẽañu chini repanare ja'me pa'inare ũcuaʉanare soni i'kaasome repana. —Jesús pa'ichejana sani repaʉ cho'oche'te ñajʉ repaʉ chʉ'o asaneena cho'ocheja'che cho'ojʉ chʉ'o sẽniasajʉ̃'ʉ repaʉ'te. Chekʉrʉmʉ repaʉji tĩiñe i'kato chẽa sa, pãi chʉ̃'ʉkʉ vʉ'ena jo'kare'omʉ repaʉ'te churata'ni —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chini saorena Jesús pa'ichejana sani tĩ'a repaʉ chʉ'o asaneena i'kacheja'che i'kaasome repana repaʉ'te. —Masiʉ, rũhiñe che'chokʉ'mʉ mʉ'ʉ. Jã'a masime chʉkʉna. Mʉ'ʉ che'choche'te chekʉnapi asa cu'ache i'katojẽ'e kʉkʉ cuasoma'ñe ũcua che'chokʉ pa'ikʉ'mʉ mʉ'ʉ, Dios chʉ̃'ʉ jo'kasi'e ũcuarepa. ");
INSERT INTO coe_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jã'ajekʉna mʉ'ʉni chʉ'o sẽniasañu chiime chʉkʉna. Romapãi chʉ̃'ʉkʉji Césapi chʉkʉna pa'iche ro'ire sẽeto, ¿ro'ijanaa'ñe chʉkʉna repaʉ'te? ¿Ro'imanejanaa'ñe? —chiniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jã'ata'ni Jesús repana cu'ache cho'oñu chiiche'te masikʉ ija'che i'kaasomʉ repanare: ");
INSERT INTO coe_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kurire'reva'te mini ñojʉ̃'ʉ chʉ'ʉre. Kurire'reva pa'ikʉ kuechʉsi'kʉ, ¿keeja'iʉ'ʉ? Ũcuachi'a, ¿nee mamipi pa'ikʉ ire'reva? —chiniasomʉ repaʉ. Chikʉna i'kaasome repana. —Maire chʉ̃'ʉkʉ César chiana'me repaʉ mami pa'imʉ jã'are'reva —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chitena repanare i'kaasomʉ repaʉ. —Jã'a pa'ito pa'iche ro'ire repaʉji kuri ro'iche chʉ̃'ʉto ro'ijʉ̃'ʉ repaʉ'te. Dios chʉ̃'ʉ jo'kasi'e ũcuachi'a cho'ojʉ pa'ijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Repaʉji rʉa masikʉ sãiñe i'kaʉna asa kʉkʉ jo'e i'kamaneasome repana, fariseopãi raocojñosina. ");
INSERT INTO coe_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ũcuarʉmʉ saduceopãi te'ena Jesuni ñañu chini saniasome. “Pãi jũ'isina jo'e vajʉraimanejanaa'me”, chiijʉ cuasanajejʉ Jesure ija'che sẽniasome repana: ");
INSERT INTO coe_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Masiʉ, Diopi chʉ̃'ʉʉna Moisés aperʉmʉ maire tocha jo'kasi'e ija'che chiimʉ: Pãiʉ romio'te vejasi'kʉpi, chuta'a chĩi peokʉji jo'ka jũnisõru repaʉ cho'jeʉji veja paaa'kʉ majaa'chʉ paasi'kore. Repaoni veja chĩire paakʉ ija'che cuasakʉ paaʉ: “Chʉ'ʉ a'chʉ jũnisõsiva'ʉ chĩijanaa'me ina chʉ'ʉ chĩi”, chiaʉ, chiimʉ repaʉ tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jã'ajekʉna chʉ'o kʉañu chiime chʉkʉna mʉ'ʉre. Pãiʉ charo cakʉ cho'jechĩi ʉmʉpãichi'a seirepanare paaasomʉ. Repaʉ chareparo cakʉ romio'te veja paakʉ chuta'a chĩi peokʉji jo'ka jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jũnisoʉna cho'jeʉ repaʉ majaa'chʉ rʉ̃jo pa'isi'koni veja paakʉ ũcuaja'che chuta'a chĩi peokʉji jo'ka jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jũnisoʉna na'a cho'je cakʉ ũcuate'eo'te veja ũcuaja'che chĩi peokʉji jũnisoasomʉ. Jã'aja'ñechi'a sieterepana ũcuanʉko ũcuate'eo'te vejajʉ chĩi peonachi'a jo'ka jũnisoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Repana jũnisosirʉmʉna romio ũcuaja'che jũnisoasomo. ");
INSERT INTO coe_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jã'ajekʉna pãi jũnisosina ũcuanʉko jo'e vajʉraisirʉmʉ, ¿kaʉpi repao'te jo'e paaja'ʉ vajʉrʉmʉ sieterepana repao'te paasina? ¿Je'se chiikʉ mʉ'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chitena Jesús i'kaasomʉ repanare. —Icheja cheja pa'ina ʉmʉpãi romi vejame. Romi ũcuachi'a ʉmʉ vejame. ");
INSERT INTO coe_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pãi Diore cuasana, ʉmʉpãina'me romi jũnisõ vajʉrani Dios pa'icheja saisirʉmʉ jo'e vejamanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ũcuaja'che jo'e jũnisõmanejanaa'me repana, ũcuare vajʉraisinajejʉ. Angeles, Diore ja'me pa'ina pa'icheja'che jũnisõma'ñe pa'ijanaa'me repana. Ũcuaja'che Dios chĩia'me repana jũni vajʉrani repaʉ pa'icheja saisina. ");
INSERT INTO coe_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Aperʉmʉ Moisés sũkira'ñʉrʉ uutoa toa kueñe nʉkakʉ ñakʉ paniasomʉ. Ñakʉ nʉkakʉna ũcuatoa sa'navʉji Diopi i'kakʉna asakʉ pãi jũnisõsina jo'e vajʉraijachere kʉara chini ija'che tocha jo'kaasomʉ repaʉ Moisés: Mʉsanʉkona aipãi icheja pa'irʉmʉ chʉ'ʉre cuasasinare paakʉ'mʉ chʉ'ʉ, Abrahamre, Isaare, Jacobre, chiisi'kʉa'mʉ Dios. Pãi jũnisõsinarejẽ'e vajʉnareja'che ñakʉjekʉ paamʉ Dios repanare, rekoñoãpi vajʉkʉna —chiniasomʉ Jesús repanare saduceopãi. ");
INSERT INTO coe_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jã'aja'ñe i'kaʉna judíopãi che'chona i'kaasome repaʉ'te. —Masiʉ, rʉa masi i'kamʉ mʉ'ʉ —chiniasome repana Jesure. ");
INSERT INTO coe_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jesupi masi i'kaʉna repaʉ'te jo'e chʉ'o sẽniasavajʉchʉasome repana saduceopãina'me judíopãi che'chona. ");
INSERT INTO coe_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ũcuarʉmʉ Jesús repanare pãi repaʉ pa'iche'te kʉaasomʉ. —“Aperʉmʉ pa'isi'kʉ David Jojosi'kʉa'mʉ Cristo”, chiime mʉsanʉkona pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉre. ¿Je'se pa'iʉna mʉsanʉkona jã'aja'ñe i'kache? ");
INSERT INTO coe_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Repaʉ David Salmophʉrona ija'che tocha jo'kaasomʉ: Dios chʉ'ʉre Paakʉ'te ija'che i'kaasomʉ: “Chʉ'ʉre kueñe ʉjajʉ̃tʉ cakã'kona pʉʉjʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Chʉ'ʉpi cho'okʉna mʉ'ʉre cuhena ũcuanʉko mʉ'ʉ chʉ̃'ʉñe cho'ojanaa'me”, chiniasomʉ Dios, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Je'se pa'iʉna David, “Chʉ'ʉre Paakʉ'mʉ Cristo”, chiisi'eta'ni, “David Jojosi'kʉa'mʉ Cristo”, chiiche pãi? —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Repana pãi ũcuanʉko asajʉ'te Jesús repaʉ neenani chʉ'vaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Judíopãi che'chona pa'iche ña chẽamanejʉ̃'ʉ mʉsanʉkona. Kãña re'ojakãñapi ʉjacueñoã ju'ijʉ nʉka ku'ime repana, pãipi ña, “Diore rʉa cuasanaa'me jã'ana”, chiapʉ chini. Ãu ĩsichejñare ku'ijʉna pãipi repanani ña kʉkʉjʉ chẽa pojoto rʉa pojonaa'me repana. Ũcuaja'che judíopãi chi'ivʉ'ña mʉa kakani masina ñu'isaivʉãre ñu'ineenaa'me repana. Ũcuaja'che pãipi repanani ãu ãuñu chini soito mʉa repanare soisi'kʉre kueñe ñu'ineenaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ũcuaja'che va'jeva'na paache jorejʉ tʉtesõnaa'me repana. Jã'aja'ñe cho'onata'ni pãipi ña, “Re'onaa'me jã'ana”, chiapʉ chini Diore rʉa jeerʉmʉ sẽejʉ pa'inaa'me repana. Jã'aja'ñe cho'onajejʉna Diopi chʉ̃'ʉʉna rʉa cu'ache ti'jñeja'mʉ repanare —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ũcuarʉmʉ Jesús Dios vʉ'ere chuta'a pa'iʉ ñato pãi kurina kurire Dioni ĩsijʉ cãjovʉna rʉa mañaasome. ");
INSERT INTO coe_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Va'jeva'o chʉova'o pa'iva'o ũcuaja'che te'eka'chapare'rerʉãchi'a ka'charʉ pa'ire'rerʉãre mañaasomo. ");
INSERT INTO coe_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Mañaona ña Jesús ija'che i'kaasomʉ: —Ina kurinata'ni repana koojʉna cajejaisi'ere ĩsisinaa'me. Iva'ota'ni repao ãu koo ãio pasa chiisire'rerʉãre Dioni pojoko peore ĩsisõsi'koa'mo. Kurina ĩsisi'e ña pojomʉ Dios. Jã'ata'ni iva'o ĩsisi'e ña na'a rʉa pojomʉ Dios. Ũcuarepaa'me jã'a —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Reparʉmʉ chekʉna ũcuavʉ'e pa'ina Dios vʉ'e pa'iche'te cutuasome. —Catapʉã rʉa re'ojapʉãpi cho'osivʉ'ea'me ivʉ'e. Ũcuaja'che pãipi Dioni pojojʉ jo'kasimajñarʉãpi rʉa re'ojamajñarʉãpi pa'iʉ rʉa re'oja'imʉ ivʉ'e —chiniasome repana. Jã'aja'ñe cutujʉna asa Jesús i'kaasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Mʉsanʉkona ivʉ'e Dios vʉ'ere ñajʉ, “Re'oja'imʉ”, chiime. Jã'ata'ni na'a pa'isirʉmʉ, catapʉã te'epʉjẽ'e chekʉpʉna'me sʉ'ima'ñe peore ñañosõjanaa'me pãi ivʉ'e —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chikʉna asa repaʉ'te chʉ'o sẽniasaasome repana. —Masiʉ, mʉ'ʉ kʉasi'e, ¿jeerʉmʉ cho'ojachea'che? Reparʉmʉ tĩ'añe, ¿je'se masijanaa'ñe chʉkʉna? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sẽejʉna Jesús i'kaasomʉ repanare. —Ñarepajʉ pa'ijʉ jorena i'kache asa chẽama'ñe pa'ijʉ̃'ʉ mʉsanʉkona. ¡Cacʉ'ocojñoñe! Pãi jainʉko te'enachi'a ku'ijʉ jorejʉ chʉ'ʉni roijʉ, “Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ chʉ'ʉ”, chiijanaa'me. Jã'aja'ñe i'kajʉ, “Churata'ni cheja si'api'ramʉ”, chiijanaa'me repana. Jã'aja'ñe i'kanare jovomanejʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ũcuaja'che pãi vaichena'me pãi repanare chʉ̃'ʉnare cuhejʉ etoche asani kʉkʉmanejʉ̃'ʉ mʉsanʉkona. Jã'aja'ñe pa'ija'mʉ cheja si'api'rarʉmʉ. Jã'ata'ni cheja chuta'a si'amaneja'mʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chini Jesús jo'e i'kaasomʉ repanare. —Pãi ũcuate'echeja pa'ina chekʉchejña pa'inani sani vanisõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ũcuaja'che cheja si'achejñarʉã rʉa pi'ruja'mʉ. Ũcuaja'che rʉarepa asukʉ ãupi aineemaʉna pãi si'achejñarʉã ãucuhana jũnisõjanaa'me. Ũcuaja'che si'achejñarʉã ravʉ pa'iʉna pãi jainʉko jũ'ijanaa'me. Ũcuaja'che pãi cʉnaʉmʉre ñani repana ñamanesi'ere ñajʉ ñavajʉchʉache ñokʉna kʉkʉsõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Jã'aja'ñe chuta'a cho'omarʉmʉ mʉsanʉkonapi chʉ'ʉni cuasajʉna cuhejʉ chẽa rʉa cu'ache cho'ojanaa'me pãi mʉsanʉkonare. Chẽa judíopãi chi'ivʉ'ñana sa cu'ache i'ka pi'ni pãi chẽavʉ'ñana cuaojanaa'me repana mʉsanʉkonare. Chekʉrʉmʉ mʉsanʉkonare chẽa sa pãi chʉ̃'ʉna vʉ'ñana jo'kajanaa'me, repavʉ'ña pa'inapi cu'ache cho'oa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pãipi jã'aja'ñe cho'ojʉna chʉ'ʉ pa'iche'te kʉa asojanaa'me mʉsanʉkona repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pãipi maini jã'aja'ñe cho'oto, “¿Je'se sãiñe i'kajanaa'ñe mai cu'ache cho'omanea'jʉ chini?”, chiijʉ cuasamanejʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chʉ'ʉpi cho'okaiʉna mʉsanʉkonare pe'runare sãiñe i'kani rʉa masi i'kajanaa'me mʉsanʉkona. Masi i'karena, “Joreme ina”, chiimanejanaa'me repana mʉsanʉkonare pe'runa. Jo'e i'kamanejanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chekʉrʉmʉ mʉja'kʉpãipi mʉsanʉkonare cuhejʉ chẽa sa pãi chʉ̃'ʉna vʉ'ñana jo'kajanaa'me, repanapi cu'ache cho'oa'jʉ chini. Chekʉrʉmʉ mʉa'chʉpãipi chekʉrʉmʉ mʉche'ʉchĩipi chekʉrʉmʉ mʉsanʉkona majapãipi chekʉrʉmʉ mʉsanʉkonare re'osinapi cuhejʉ chẽa sa jo'kajanaa'me mʉsanʉkonare. Ũcuachi'a pãi mʉsanʉkonare ũcuaʉanare vanisõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pãi jainʉko mʉsanʉkonare chʉ'ʉni cuasajʉna cuhejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jã'ata'ni Diopi ʉ̃sekʉna mʉsanʉkona rekoñoãta'ni cu'ache cho'omanejanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mʉsanʉkonapi chʉ'ʉre cuasache ũhasõmanapi jũnisõni Dios pa'ichejare ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ũcuachi'a cheja si'api'rarʉmʉ ija'che cho'ojanaa'me pãi: Pãire vañu chini Jerusalén vʉ'ejoopona rani rũhiso'koro nʉkajanaa'me sõtaopãi. Sõtaopãipi jã'aja'ñe cho'ojʉna ñani, “Ijoopo vʉ'ejoopo ñañasõcuhaja'mʉ”, chini masijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Reparʉmʉ tĩ'ato Judea cheja pa'ina aikũjñana vʉ'vʉ katisõa'jʉ. Ũcuaja'che Jerusalén vʉ'ejoopo pa'ina eta sanisõa'jʉ. Ũcuaja'che chiño saisina Jerusalén vʉ'ejoopo maimanea'jʉ. ");
INSERT INTO coe_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Reparʉmʉ repana cu'ache cho'osi'e ro'i Jerusalén vʉ'ejoopo pa'inare rʉa cu'ache ti'jñeja'mʉ Diopi chʉ̃'ʉʉna. Aperʉmʉ Dios chʉ'o tochana kʉajʉ tocha jo'kasi'epi ti'jñeja'mʉ repanare Jerusalén pa'inare. ");
INSERT INTO coe_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Reparʉmʉ romiva'nare chĩi sʉ'iva'nana'me oje chũsava'nare rʉa vesache cu'ache pa'ija'mʉ. Reparʉmʉ Jerusalén pa'inare ũcuanʉkore rʉa cu'ache ti'jñeja'mʉ, Diopi pe'rukʉ chʉ̃'ʉʉna. ");
INSERT INTO coe_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Reparʉmʉ sõtaopãi tĩichejña raisinapi Jerusalén pa'inare ũcuaʉanare va'jñapi vanisõjanaa'me. Chekʉnare chẽa tĩichejñana sasõjanaa'me repana. Ũcuaja'che judío peonapi Jerusalén vʉ'ejoopo ñañosõ tʉa pa'ijanaa'me, Dios repanare repacheja pa'iʉ̃serʉmʉjatʉ'ka —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Chini Jesús jo'e i'kaasomʉ repanare. —Ũcuaja'che reparʉmʉ Diopi chʉ̃'ʉʉna ʉ̃sʉʉna'me pãimiaʉna'me ma'jñoko, vajʉchʉache ñojʉna ña kʉkʉsõjanaa'me pãi. Ũcuaja'che chiaraãpi rʉa asoche fa'akʉna ña rʉa kʉkʉsõjanaa'me pãi si'achejña pa'ina. ");
INSERT INTO coe_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Reparʉmʉ cho'oche'te ña, “¿Je'se maire ti'jñeja'ʉ?”, chini rʉarepa kʉkʉcajejanisõ ai jũnisõjanaa'me pãi, cʉnaʉmʉ pa'imajñarʉãjatʉ'ka peore ñʉ'kuekʉna ñani. ");
INSERT INTO coe_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Reparʉmʉ chʉ'ʉ Dios Raosi'kʉ peore Masiʉji rʉa re'oja'che ñoʉ ko'sija'iʉ cʉnaʉmʉpi pãi ũcuanʉko ñajʉ'te pikona'me cajeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chʉ'ʉ chura kʉasi'e apecho'oche ñani rʉa pojojʉ̃'ʉ mʉsanʉkona. “Dios maire Repaʉ neenajejʉna Repaʉ pa'ichejana sara chini raipi'ramʉ”, chini cuasajʉ cha'ajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ũcuarʉmʉ Jesús pãire chʉ'vakʉ ija'che i'kaasomʉ: —Chura sũkiñʉ higoñʉ pa'ichena'me sũkiñʉã si'ara'ñʉrʉã pa'iche'te cuasa ñajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sũkiñʉã ja'o ma'mañe ñani, “Ʉ̃sʉrʉmʉ tĩ'api'ramʉ ie”, chiime mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ũcuaja'che chʉ'ʉ chura kʉasi'epi tĩ'akʉna ñani, “Jesús Dios Raosi'kʉ pãi ũcuanʉkore chʉ̃'ʉra chini chejana jo'e cajepi'ramʉ”, chiijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Mʉsanʉkona jojosina chuta'a jũ'imarʉmʉna chʉ'ʉ kʉasi'e peore ti'jñeja'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cʉnaʉmʉna'me cheja si'asõja'mʉ. Chʉ'ʉ chʉ̃'ʉ jo'kasi'eta'ni si'ama'ñe ũcua pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’Ñarepajʉ pa'ijʉ cu'achejẽ'e cho'omairo pa'ijʉ̃'ʉ mʉsanʉkona. Cu'achejẽ'e cho'oma'ñe, conojẽ'e jũ'ima'ñe, mʉsanʉkona pa'ichejẽ'e rʉarepa cuasama'ñe pa'ijʉ̃'ʉ. Jã'are cho'ojʉ mʉsanʉkonapi chʉ'ʉ raijachejẽ'e cuasama'ñe vesʉ pani chʉ'ʉpi tãupa tãiñeja'ñe teana na'mi rakʉna ña kʉkʉsõjanaa'me mʉsanʉkona. Jã'ajekʉna chʉ'ʉni cha'ajʉ re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona. Chʉ'ʉpi cuasoma'ñe rakʉna pãi cu'ache pa'ina ũcuanʉko ña kʉkʉsõjanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ñarepajʉ pa'ijʉ chʉ'ʉni cha'ajʉ Dioni ija'che sẽejʉ pa'ijʉ̃'ʉ: “Ja'kʉ, chʉkʉna'te cho'okaijʉ̃'ʉ. Mʉ'ʉ neekʉ chʉ̃'ʉñe'te cho'ojʉ pañu chiime chʉkʉna. Chekʉna cho'ocheja'che cu'ache cho'omaneñu chiime chʉkʉna. Mʉ'ʉ neekʉ mʉ'ʉ Raosi'kʉpi raito vajʉchʉmanejanaa'me chʉkʉna mʉ'ʉpi cho'okaiʉna re'oja'che pa'inajejʉ.” Jã'aja'ñe sẽejʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Reparʉmʉ Jesús si'aumucujña Dios vʉ'e kaka che'choasomʉ. Si'ana'iroã Olivo aikũtina mʉni si'añami paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Si'aapeñataroã caje che'chokʉna pãi peore Dios vʉ'ena mʉaasome, repaʉ i'kache'te asañu chini. ");
INSERT INTO coe_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Reparʉmʉ judíopãi pã saʉmanesi'e ãirʉmʉ pascua tĩ'api'raasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ũcuarʉmʉ judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona Jesuni vanisoche'te chʉ̃'ʉñu chini te'ena cutuasome. Cutunata'ni chʉ̃'ʉmaneasome repana, “Pãipi pe'rujʉ cavajʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ũcuarʉmʉ vati ai cu'ache chʉ̃'ʉra chini Judas Iscarioteni kakaasomʉ. Jesús neena docerepanare ja'me pa'ikʉ paniasomʉ Judas. ");
INSERT INTO coe_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","5","Vati aipi kakaʉna judío phairipãi chʉ̃'ʉnana'me Dios vʉ'e pẽ'jekainare chʉ̃'ʉna pa'ivʉ'ena mʉa i'kaasomʉ repaʉ Judas. “Mʉsanʉkonare Jesure, ¿je'se jo'kaja'che chʉ'ʉ?”, chikʉna ũcuaʉna'me cutujʉ Judas cho'ora chiiche'te asa pojoasome repana. Pojojʉ, “Mʉ'ʉpi jã'aja'ñe cho'oto mʉ'ʉre kuri ro'ijanaa'me chʉkʉna”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jã'aja'ñe i'karena, “Jaʉ, jã'aja'ñe cho'ora, jã'a pa'ito”, chini Jesús pa'ichejana sani pẽ'je ñakʉ paniasomʉ repaʉ, pãi jainʉko peorʉmʉna rope'e repaʉni jo'kara chini. ");
INSERT INTO coe_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na'a pa'isirʉmʉ judíopãi pã saʉmanesi'e ãirʉmʉ pascuarʉmʉ ovejachĩiva'ʉre vanisoche paniasomʉ repanare, Diopi pojoa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jã'aja'ñe cho'opi'rajʉna Jesús Pedrona'me Juanre soni i'kaasomʉ. —Mai pascuarʉmʉ ãijañe ãu care'vajaijʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chikʉna repaʉ'te sẽniasome repana. —¿Jeechejana sani ãu care'vajanaa'ñe chʉkʉna? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chitena i'kaasomʉ repaʉ. —Chura vʉ'ejoopona sani tĩ'a pãiʉ'te churupʉ oko pa'ipʉ sakʉ'te tijñajanaa'me mʉsanʉkona. Tijña ja'me mʉa repaʉ kakavʉ'ena ja'me kakajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kaka vʉ'e paakʉ'te sẽniasajʉ̃'ʉ. “Masiʉ mʉ'ʉni sani ija'che sẽniasaa'jʉ chini raomʉ chʉkʉna'te: ‘¿Jeeruupʉna chʉ'ʉ neenana'me pascuarʉmʉ kaka ãu ãija'ñe chʉ'ʉ?’, chiisi'kʉa'mʉ Jesús”, chiijʉ̃'ʉ repaʉ'te vʉ'e paakʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mʉsanʉkonapi sẽeto repaʉ ʉmʉcaruupʉ'te ʉjaruupʉ'te ñoja'mʉ, masi care'vasiruupʉ'te. Ñoʉna ũcuaruupʉna kaka mai pascuarʉmʉ ãijañe ãu care'vajʉ̃'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chikʉna vʉ'ejoopo sani tĩ'ato Jesús i'kasi'e ũcuarepa paniasomʉ. Jã'ajekʉna pascuarʉmʉ ãijañe ãu care'vaasome repana Pedrona'me Juan. ");
INSERT INTO coe_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ũcuarʉmʉ Jesús pascuarʉmʉ tĩ'aʉna ãu ãsa chini mesako'are pʉʉ ñuniasomʉ, repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pʉʉ ñu'iʉ repanare i'kaasomʉ repaʉ. —“Chʉ'ʉ chuta'a jũ'imarʉmʉ chʉ'ʉ neenana'me pascuarʉmʉ ãu ãiñe'te ãineemʉ chʉ'ʉ”, chiisi'kʉjekʉ chura mʉsanʉkonana'me ãipi'ramʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iere pascuarʉmʉ ãiñe ãu rʉa jeerʉmʉ jo'e ãimaneja'mʉ chʉ'ʉ. Na'a pa'isirʉmʉna chʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉna jo'e ãija'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chini conoro'rova mini Dioni, “Re'orepamʉ”, chini ũku repaʉ neenani ĩsikʉ i'kaasomʉ repaʉ. —Mʉsanʉkona ũcuanʉko iro'rova ũcuate'ero'rova ũkujʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉjatʉ'ka ʉche cono jo'e ũkumaneja'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chini pãpʉ mini Dioni, “Re'orepamʉ”, chini repaʉ neenani tʉ'se ĩsikʉ i'kaasomʉ repaʉ. —Ipʉ pãpʉ chʉ'ʉ ca'nivʉ'me. Chʉ'ʉni vanisõa'jʉ chini chʉ'ʉ ca'nivʉ ʉ̃sema'mʉ chʉ'ʉ, vatena mʉsanʉkona cu'ache cho'oche'te jũni ro'ikasa chini. Chʉ'ʉni cuasajʉ si'arʉmʉ ija'che cho'ojʉ ãu ãijʉ pa'ijʉ̃'ʉ mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ãu ãni pi'nisirʉmʉ conoro'rova mini jo'e i'kaasomʉ repaʉ. —Pãi ũcuanʉkore cu'ache cho'oche'te jũni ro'ikasa chini chuenisõja'mʉ chʉ'ʉ. Jã'aja'ñe cho'oche chʉ'ʉ chiepi menisõʉna Dios mamare, “Ija'che cho'oñu”, chiisi'ere cho'ojachea'me. Jã'are cuasajʉ chi'i ie ʉche cono ũkujʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jã'ata'ni pãipi cu'ache cho'oa'jʉ chini chʉ'ʉre jo'kajaʉ ichejare maina'me ñu'imʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chʉ'ʉ Dios Raosi'kʉ jũnisõja'mʉ. Jã'aja'ñe chʉ̃'ʉmʉ Dios. Jã'ata'ni chʉ'ʉni vanisõa'jʉ chini jo'kasi'kʉre na'a rʉa cu'ache ti'jñeja'mʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jã'aja'ñe i'kaʉna asa ũcuanachi'a sãiñe sẽniasaasome repana. “¿Kaʉpi ikʉre jo'kaja'ʉ?”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ũcuarʉmʉ Jesús neena sãiñechi'a ke'rejʉ ija'che cutuasome: —Ikʉpi inare na'a rʉa chʉ̃'ʉmasikʉ'mʉ —chiniasome te'ena. Chekʉnata'ni, —Ikʉ pãakʉ'mʉ. Ikʉpi na'a rʉa chʉ̃'ʉmasikʉ'mʉ —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jã'aja'ñe i'kajʉna asa Jesús i'kaasomʉ repanare. —Icheja cheja pãi chʉ̃'ʉna rʉa cuajare chʉ̃'ʉjʉna rʉa chʉova'na pa'ime pãi. Cuajare chʉ̃'ʉnata'ni, “Chʉkʉna neenare rʉa re'oja'che kuiranaa'me chʉkʉna”, chiime repana pãi chʉ̃'ʉna. ");
INSERT INTO coe_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Repana pa'icheja'che pa'imanejʉ̃'ʉ mʉsanʉkona. Mʉsanʉkona te'eʉji na'a masini vesʉva'ʉ cuasacheja'che cuasakʉ, “Rʉa vesʉkʉ'mʉ chʉ'ʉ”, chiiʉ cuasakʉ pa'ijʉ̃'ʉ. Ũcuaja'che mʉsanʉkona te'eʉji pãi chʉ̃'ʉkʉ pani cho'oche cho'okaikʉ cho'ocheja'che chekʉnare cho'okaiʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pãi chʉ̃'ʉkʉji ãu ãsa chini pʉʉto cho'oche cho'okaikʉji ãu ramʉ repaʉ'te. Ñu'iʉ ãu ãikʉji na'a rʉa masiʉ'mʉ. Icheja cheja pãi chʉ̃'ʉna pa'iche'me jã'a. Chʉ'ʉta'ni cho'oche cho'okaikʉ cho'ocheja'che cho'okaikʉ'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pãi chʉ'ʉre rʉa cu'ache cho'ome. Jã'ata'ni mʉsanʉkona chʉ'ʉni oijʉ ja'me pa'inaa'me. ");
INSERT INTO coe_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja'kʉ chʉ'ʉre pãire chʉ̃'ʉa'kʉ chini jo'kasi'kʉa'mʉ. Chʉ'ʉ ũcuaja'che mʉsanʉkonare chʉ'ʉ neenare pãire chʉ̃'ʉa'jʉ chini jo'kaja'mʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pãi chʉ̃'ʉnare jo'kaʉna chʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉ chʉ'ʉna'me ãu ãijʉ ũkujʉ ñu'ijanaa'me mʉsanʉkona. Ũcuaja'che pãi chʉ̃'ʉna ñu'isaire ñu'ijʉ Israelpãi, docerepavãjʉ jojosinani chʉ̃'ʉjanaa'me mʉsanʉkona —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chini Jesús Simón Pedro'te i'kaasomʉ. —Asarepajʉ̃'ʉ, Simón. Vati ai mʉsanʉkonare cu'ache chʉ̃'ʉra chiimʉ, mʉsanʉkonapi chʉ'ʉre cuasache'te ũhasõa'jʉ chini. Jã'are cho'ora chini Dioni sẽemʉ repaʉ, Diopi ʉ̃semanea'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jã'ata'ni mʉ'ʉre Dioni rʉa sẽekaimʉ chʉ'ʉ, mʉ'ʉpi chʉ'ʉre cuasache'te ũhasõmanea'kʉ chini. “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiija'mʉ mʉ'ʉ. Jã'ata'ni chʉ'ʉre jachasi'kʉjekʉ cuasa oiʉ, “Cu'ache cho'osi'kʉa'mʉ chʉ'ʉ. Jo'e jã'aja'ñe cho'omaneja'mʉ chʉ'ʉ”, chini cuasaja'mʉ mʉ'ʉ. Jã'aja'ñe cuasasirʉmʉ chʉ'ʉ neenare chekʉnare chʉ'vajʉ̃'ʉ, repanapi chʉ'ʉni na'a rʉa cuasajʉ paapʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chikʉna Simón i'kaasomʉ. —Chʉ'ʉre Paakʉ, mʉ'ʉre cuhena pãi chẽavʉ'ena chẽa cuaoto ja'me kakaja'mʉ chʉ'ʉ. Ũcuaja'che pãipi mʉ'ʉre vanisõto ja'me jũ'ija'mʉ chʉ'ʉ —chiniasomʉ Simón repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chikʉna Jesús sãiñe i'kaasomʉ. —Pedro, asarepajʉ̃'ʉ. Chʉ'o kʉara chiimʉ chʉ'ʉ mʉ'ʉre. Iñami chuta'a kura chu'ima'tona pãipi sẽejʉna choteñoã, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiija'mʉ mʉ'ʉ —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chini Jesús repaʉ neenare ũcuanʉkore i'kaasomʉ. —Aperʉmʉ chʉ'ʉ mʉsanʉkonare Dios chʉ'ore chʉ'vaa'jʉ chini chʉ̃'ʉ saosi'ere cuasajʉ̃'ʉ. Chʉ'ʉpi chʉ̃'ʉʉna põse mañaturujẽ'e, kurijẽ'e, cũ'akorophe'rejẽ'e samairo saisinaa'me mʉsanʉkona. Jã'aja'ñe peova'na saisinare, ¿cu'amajñarʉã karamaneʉ mʉsanʉkonare? —chiniasomʉ Jesús repanare. Chikʉna, —Pãasi'kʉa'mʉ. Cu'amajñarʉãjẽ'e karamanesi'kʉa'mʉ chʉkʉna'te —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chitena Jesús i'kaasomʉ. —Aperʉmʉ peona saisinaa'me mʉsanʉkona. Churata'ni cheke cho'ojʉ̃'ʉ. Chura jo'e sani põse mañaturu paani, kuri paani sajʉ̃'ʉ. Ũcuaja'che te'eʉ va'ti peoni sẽ'sevʉ ju'ikãare ĩsisõ, va'tire koo sajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dios chʉ'o aperʉmʉ tocha jo'kasi'ere ñani chʉ'ʉre cho'ojache masijanaa'me mʉsanʉkona. Ija'che kʉamʉ: Na'a pa'isirʉmʉ pa'ijaʉ cu'ache cho'osinana'me chuenisõja'mʉ, chiimʉ. Chʉ'ʉre cho'ojachere kʉajʉ tocha jo'kasi'epi apeti'jñemʉ chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jã'aja'ñe kʉaʉna asa i'kaasome repana. —Ñakʉ, Chʉkʉna'te Paakʉ. Ichejare va'jña ka'chava'jña paame chʉkʉna —chiniasome repana. Chitena, —¡Re'omʉ! —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","I'ka pi'ni Jesús eta Olivo aikũtina repaʉ si'arʉmʉ sani pa'ikũtina saniasomʉ. Saiʉna repaʉ neena ja'me saniasome. ");
INSERT INTO coe_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sani tĩ'a repaʉ neenani chʉ'vaasomʉ repaʉ. —Dioni sẽejʉ pa'ijʉ̃'ʉ, Ũcuaʉji cho'okaiʉna cu'ache cho'omaneñu chini —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chini te'eʉ jmachenerʉ sani ro're ñu'iʉ Dioni sẽniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ija'che sẽniasomʉ repaʉ: “Ja'kʉ, mʉ'ʉre ʉ̃seʉato pãi chʉ'ʉre cu'ache cho'ojache ʉ̃sekaijʉ̃'ʉ. Chʉ'ʉre ʉacheta'ni cho'omanejʉ̃'ʉ. Ʉ̃seʉama'to mʉ'ʉre ʉache cho'ojʉ̃'ʉ”, chiniasomʉ repaʉ Diore. ");
INSERT INTO coe_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ũcuarʉmʉ cʉnaʉmʉ pa'ikʉji ángel peosichejapi teana rani pa'iʉ cho'okaniasomʉ repaʉ'te Jesure, koka paaa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús repaʉ'te cho'ojachere rʉa cuasakʉna sʉmaʉna Dioni na'a rʉa sẽniasomʉ. Sẽeʉna repaʉ ʉ̃sʉca'nañe chejana rʉa meeñe meniasomʉ, chie raiʉ meeñeja'ñe. ");
INSERT INTO coe_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sẽni pi'ni vʉni, repaʉ neena pa'ichejana co'i ñato sʉmava'na pa'ijʉ kãni ũhijʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kãnisorena repanare i'kaasomʉ repaʉ. —¿Je'se pa'iʉna mʉsanʉkona kãiñe? Dioni sẽejʉ̃'ʉ, Ũcuaʉji cho'okaiʉna cu'ache cho'omaneñu chini —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Repaʉ Jesús chuta'a i'katona pãi jainʉko raniasome. Jesús neenare docerepanare ja'me pa'ikʉji Judas charo raniasomʉ Jesuni chũsu pojora chini. ");
INSERT INTO coe_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Rani tĩ'a chũsu pojoʉna Jesús i'kaasomʉ repaʉ'te. —Judas, ¿mʉ'ʉ chʉ'ʉre cuhenani chʉ'ʉni Dios Raosi'kʉni jo'kakʉ chũsu pojokʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chikʉna Jesure ja'me pa'ina repaʉ'te chẽajañere masijʉ ija'che i'kaasome repaʉ'te: —Chʉkʉna'te Paakʉ, ¿inare va'jñapi ruta vaijanaa'ñe chʉkʉna? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I'kajʉ Jesús neekʉ te'eʉ judío phairi aire cho'oche cho'okaikʉ cãjorona tẽo vatoasomʉ ʉjajʉ̃tʉ cakã'ko cacãjorona. ");
INSERT INTO coe_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tẽoʉna, —Re'omʉ. Jo'e cho'omanejʉ̃'ʉ —chiniasomʉ Jesús repaʉ'te. Chini Jesús cãjoro tẽocojñosi'kʉre ũcuacãjorona chẽa vasoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Vaso repaʉ'te chẽañu chini raisinare judío phairipãi chʉ̃'ʉnana'me Dios vʉ'e pẽ'jekainare chʉ̃'ʉnana'me judío ainare ija'che i'kaasomʉ Jesús: —Mʉsanʉkona chʉ'ʉni chẽañu chini vãsoñoãna'me va'jña cãjijʉ raime. Ñaaʉ'te cho'ocheja'che cho'ome mʉsanʉkona chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aperʉmʉ chʉ'ʉ mʉsanʉkonana'me si'aumucujña Dios vʉ'e mʉa ja'me pa'isi'kʉa'mʉ. Jã'ata'ni mʉsanʉkona chʉ'ʉre chẽamanesinaa'me. Irʉmʉta'ni Diopi ʉ̃semaʉna chẽame mʉsanʉkona chʉ'ʉre, vati chʉ̃'ʉñe'te cho'ojʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ũcuarʉmʉ repana pãi repaʉ'te chẽa judío phairi ai vʉ'ena sajʉna Pedro so'opi ñakʉ tuhaasomʉ ũcuavʉ'ena. ");
INSERT INTO coe_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Repanapi sani kaka vʉ'e sa'navʉ cararipʉ joorepapona toa suha rũhiso'koro pʉʉ ñu'ijʉ kũhijʉna Pedro ja'me pʉʉ ñuniasomʉ, cho'je tuhasi'kʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ñu'ijʉna romichĩio phairi aire cho'oche cho'okaiko toa ñu'iʉ kũhikʉ'te Pedro'te rorepa ñako i'kaasomo. —Ikʉ Jesure ja'me pa'isi'kʉa'mʉ —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chikona asa Pedro i'kaasomʉ. —Jesure ñama'kʉa'mʉ chʉ'ʉ —chiiʉ jachaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na'a pani chekʉ ña i'kaasomʉ Pedro'te. —Jesús neenare ja'me pa'ikʉ'mʉ mʉ'ʉ —chiniasomʉ repaʉ. Chikʉna Pedro i'kaasomʉ. —Pãakʉ'mʉ. Jã'anare ja'me pa'ima'kʉa'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jmamakarʉ pa'isirʉmʉna chekʉ repaʉni ña rʉa i'kaasomʉ. —Ikʉ Galilea cheja pa'ikʉjekʉ Jesure ja'me pa'ikʉcosomʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chikʉna Pedro jachakʉ i'kaasomʉ repaʉ'te. —Mʉ'ʉ i'kache vesʉmʉ chʉ'ʉ —chiniasomʉ repaʉ. Pedro jã'aja'ñe i'katona kura chuniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chu'iʉna Jesús chʉri ñaasomʉ Pedro'te. Ñakʉna repaʉ Pedro Jesús i'kasi'ere cuasaasomʉ, “Iñami kura chuta'a chu'ima'tona choteñoã, ‘Jesure ñama'kʉa'mʉ chʉ'ʉ’, chiija'mʉ mʉ'ʉ”, chiisi'ere. ");
INSERT INTO coe_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jã'are cuasa Pedro eta rʉa oiche oniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ũcuarʉmʉ Jesure chẽasina repaʉni pãisojʉ vaniasome. ");
INSERT INTO coe_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vaijʉ repaʉ ñakocaã kãase'rechoji quẽo ta'pi jo'e vani sẽniasome repana. —Cuasa i'kajʉ̃'ʉ. ¿Neepi mʉ'ʉre vate? —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jã'aja'ñe i'kajʉ repaʉ'te Jesure cheke rʉa cu'ache i'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ñatasirʉmʉ judío ainana'me judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona chi'iasome. Chi'i chʉ̃'ʉrena repana vʉ'ena chekʉnapi Jesure raasome. Rarena repaʉ'te chʉ'o sẽniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉ Cristo pani kʉajʉ̃'ʉ mʉ'ʉ chʉkʉna'te —chiniasome repana repaʉ'te. Chitena Jesús i'kaasomʉ repanare. —Chʉ'ʉpi kʉato jachajanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ũcuaja'che chʉ'ʉpi sãiñe sẽeto i'kamanejanaa'me mʉsanʉkona chʉ'ʉre. Ũcuachi'a chʉ'ʉre eto saomanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Chʉ'ʉ Dios Raosi'kʉ cʉnaʉmʉna jo'e mʉni, Dios peore Cho'omasikʉ ʉjajʉ̃tʉ cakã'kona pʉʉ si'arʉmʉ ñu'ija'mʉ —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chikʉna ũcuanʉko sẽniasome repana. —Jã'a pa'ito, ¿Dios chĩia'ʉ mʉ'ʉ? —chiniasome repana. Chitena, —Ũcuaʉ'mʉ chʉ'ʉ —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chikʉna i'kaasome repana. —Ikʉ cu'ache cho'osi'e kʉanare chiima'me mai. Re'omʉ. Dios asacuheche'te, “Dios chĩia'mʉ chʉ'ʉ”, chiimʉ ikʉ —chiniasome repana judío ainana'me phairipãi chʉ̃'ʉnana'me judíopãi che'chona. ");
INSERT INTO coe_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jã'aja'ñe i'ka pi'ni ñu'isina vʉni repaʉ'te Jesure jo'e chẽa, Pilato ti'jñeñena sa nʉkoasome repana. ");
INSERT INTO coe_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sa nʉko repaʉ'te cu'ache cho'oche roijʉ ija'che i'kaasome: —Mai pa'icheja canare ikʉ cu'ache chʉ'vache asasinaa'me chʉkʉna. Pãi repanare chʉ̃'ʉna chʉ̃'ʉñe jachajʉ cho'omanea'jʉ chini chʉ'vakʉ'mʉ ikʉ. “Mʉsanʉkonare chʉ̃'ʉkʉ Césapi pa'iche ro'ire kuri sẽeto ro'imanejʉ̃'ʉ mʉsanʉkona”, chiisi'kʉa'mʉ ikʉ. Ũcuaja'che, “Cristoa'mʉ chʉ'ʉ. Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ”, chiikʉ'mʉ ikʉ —chiniasome repana repaʉ'te Pilato'te. ");
INSERT INTO coe_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chitena Pilato repaʉ'te Jesure sẽniasomʉ. —¿Judíopãi ũcuanʉkore chʉ̃'ʉkʉ'ʉ mʉ'ʉ? —chiniasomʉ. Sẽeʉna, —Jʉ̃jʉ, ũcuaʉ'mʉ chʉ'ʉ —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chikʉna Pilato i'kaasomʉ repanare judío phairipãi chʉ̃'ʉnana'me chekʉnare pãi ũcuavʉ'e pa'inare. —Cu'ache cho'osi'e peomʉ ikʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chiisi'eta'ni jo'e na'a rʉa i'kaasome repana. —Ikʉ Judea cheja pa'inare ũcuanʉkore rʉa cu'ache chʉ'vakʉ'mʉ, repanare chʉ̃'ʉnani pe'rujʉ cu'ache i'kajʉ cavaa'jʉ chini. Galilea chejapi ichejajatʉ'ka rʉa cu'ache chʉ'vakʉ'mʉ ikʉ —chiniasome repana Pilato'te. ");
INSERT INTO coe_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","I'karena asa, —¿Galilea cheja cakʉa'ʉ ikʉ? —chiniasomʉ Pilato repanare pãi. ");
INSERT INTO coe_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chikʉna, —Jʉ̃jʉ, ũcuacheja cakʉa'mʉ ikʉ —chiniasome repana. Kʉarena, “Ãa, Herodes chʉ̃'ʉcheja cakʉa'ʉ ikʉ”, chini cuasaasomʉ Pilato. Reparʉmʉ Herodepi Jerusalén vʉ'ejoopo'te rani pa'iʉna repaʉ pa'ivʉ'ena Jesure mʉvoasomʉ Pilato. ");
INSERT INTO coe_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mʉvoʉna repaʉ cho'oche chekʉnapi kʉajʉna asakʉ pa'ikʉjekʉ Jesure ña rʉa pojoasomʉ Herodes, rʉa jeerʉmʉ Jesús cho'oche ñaʉache cuasakʉjekʉ. Diochi'a cho'omasiche'te Jesupi cho'okʉna ñara chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Repaʉ'te ñara chiikʉjekʉ Jesure rʉa si'ache chʉ'o sẽniasomʉ repaʉ. Sẽekʉ'teta'ni Jesús jmamakarʉjẽ'e i'kamaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ũcuachi'a judío phairipãi chʉ̃'ʉnana'me judíopãi che'chona rʉa i'kajʉ, “Cu'ache cho'okʉ'mʉ ikʉ”, chiniasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jã'aja'ñe i'kajʉna Herodes Jesuni cuhekʉ rʉa pãisoasomʉ sõtaopãina'me. Repaʉni pãisojʉ rʉa re'ojakãñare, pãi chʉ̃'ʉna ju'ikãñare sa'cheasome repaʉ'te. Pãiso pi'ni repaʉ'te jo'e Pilato vʉ'ena co'choasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jã'aja'ñe cho'osiumucusepi sãiñechi'a re'oja'che cho'oasome repana Herodena'me Pilato, aperʉmʉ sãiñechi'a cuhesina. ");
INSERT INTO coe_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ũcuarʉmʉ Pilato judío phairipãi chʉ̃'ʉnana'me pãi chʉ̃'ʉnana'me chekʉnare pãi soni i'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Chʉ'ʉni mʉsanʉkona ikʉre rasinaa'me. Ra, “Ikʉ rʉa cu'ache chʉ'vakʉ'mʉ, pãipi repanare chʉ̃'ʉnani pe'rujʉ cavaa'jʉ chini”, chiisinaa'me. Mʉsanʉkona ñajʉ'te ikʉre chʉ'o sẽesi'kʉa'mʉ chʉ'ʉ, ikʉ cho'osi'ere asara chini. Jã'ata'ni chʉ'ʉ cuasato, mʉsanʉkona, “Cu'ache cho'okʉ'mʉ ikʉ”, chiiche cho'oma'kʉcosomʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ũcuachi'a, “Cu'ache cho'oma'kʉa'mʉ ikʉ”, chiniasomʉ ikʉre. Jã'ajekʉna ikʉre ichejana jo'e co'chosi'kʉa'mʉ repaʉ. Ikʉre vanisoche chʉ̃'ʉcu'amʉ cu'ache cho'oma'kʉjekʉna. ");
INSERT INTO coe_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jã'ajekʉna ikʉre rupʉ suĩ'sueche'te chʉ̃'ʉja'mʉ chʉ'ʉ. Suĩ'sue pi'ni etoja'mʉ chʉ'ʉ ikʉre —chiniasomʉ Pilato repanare. ");
INSERT INTO coe_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato te'eʉ̃sʉrʉmʉ pa'iche pascuarʉmʉ tĩ'ato chẽacojñosi'kʉre te'eʉ'te etoasomʉ, pãi etojʉ̃'ʉ chiisi'kʉni. Reparʉmʉ tĩ'aʉna jã'aja'ñe cho'oche paniasomʉ Pilato'te. ");
INSERT INTO coe_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jã'ajekʉna Pilato, “Jesuni etoja'mʉ chʉ'ʉ”, chikʉna pãi asa ũcuanʉko rʉa cuijʉ ija'che i'kaasome: —¡Jesuni vanisojʉ̃'ʉ! ¡Chʉkʉna'te Barrabani etokaijʉ̃'ʉ! —chiniasome repana ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aperʉmʉ repaʉ Barrabás chekʉnana'me repajoopo pa'inare chʉ̃'ʉnani cuhekʉ etora chini cavakʉ chekʉni vanisoasomʉ. Vanisoʉna pãi repaʉ'te chẽa pãi chẽavʉ'ena cuaoasome. ");
INSERT INTO coe_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pãipi jã'aja'ñe i'kajʉ cuirena repaʉ Pilato Jesuni etora chini jo'e i'kaasomʉ. “¿Ikʉre Jesure etomaneja'ñe chʉ'ʉ? Cu'ache cho'omanesi'kʉa'mʉ ikʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jã'aja'ñe i'kaʉna asa na'a rʉa cuijʉ i'kaasome repana. —¡Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre! ¡Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre! —Jã'aja'ñe i'kajʉ cuiasome repana. ");
INSERT INTO coe_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Cuijʉ jã'aja'ñe i'karena repaʉ Pilato ka'chañoã i'kasi'kʉta'ni jo'e i'kaasomʉ repanare pãi. —¿Ʉ̃quere ikʉ Jesús cu'ache cho'oʉ? Repaʉ cu'ache cho'osi'ere asa masira chini sẽnite'esi'kʉa'mʉ chʉ'ʉ. Jã'ajekʉna ikʉre vanisoche chʉ̃'ʉcu'amʉ. Ikʉre rupʉ suĩ'sueche'te chʉ̃'ʉja'mʉ chʉ'ʉ. Suĩ'sue pi'nirena etoja'mʉ chʉ'ʉ ikʉre —chiniasomʉ Pilato repanare. ");
INSERT INTO coe_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jã'aja'ñe i'kaʉna asa na'a rʉa cuijʉ, “Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ repaʉ'te”, chiniasome repana. Rʉarepa cuijʉ i'kajʉna repana chiiche chʉ̃'ʉasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Repana sẽeñe cho'ora chiniasomʉ Pilato. ");
INSERT INTO coe_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Repana sẽeñe cho'ora chini chekʉre pãi chʉ̃'ʉnani cuhekʉ cu'ache cho'okʉ pãiʉ'te vanisosi'kʉni etoasomʉ repaʉ Pilato, pãi chẽavʉ'e pa'isi'kʉre. Jesureta'ni sõtaopãire jo'kaasomʉ, repana pãi sẽesi'e cho'oa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jo'kaʉna repana sõtaopãi Jesure chẽa saasome. Sajʉ Simonre Cirene cheja cakʉre po'o raikʉni chẽa repaʉ tãtavana kurususẽ'vero tʉo, “Mʉ'ʉpi isẽ'vero kuãiʉ Jesús cho'jepi raijʉ̃'ʉ”, chiniasome sõtaopãi repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Simonre chẽa jo'e saijʉna chekʉna pãi jainʉko Jesús cho'jepi tuhaasome ʉmʉpãina'me romi. Tuhajʉ romi Jesure cho'ojachere cuasajʉ ota oniasome. ");
INSERT INTO coe_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Oijʉna Jesús repanare chʉri ña i'kaasomʉ. —Jerusalén pa'ina romi, chʉ'ʉre oima'ñe meñe oijʉ̃'ʉ. Mʉsanʉkonare ti'jñejañena'me mʉsanʉkona chĩiva'nare ti'jñejañere cuasajʉ oijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Na'a pa'isirʉmʉna mʉsanʉkona chĩire cu'ache ti'jñekʉna ña ija'che i'kajanaa'me pãi: “Romi, chĩi paava'na sʉmava'na pa'ime. Romi, chĩi peonata'ni pojome”, chiijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cu'ache ti'jñerʉmʉ katiñu chini aikũjñare ija'che i'kajanaa'me pãi: “Ñaña ta'pisõjʉ̃'ʉ chʉkʉna'te”, chiijanaa'me. ");
INSERT INTO coe_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chʉ'ʉre cu'ache cho'omanesi'kʉreta'ni pãi, “Cu'ache cho'osi'kʉa'mʉ mʉ'ʉ”, chini cu'ache cho'ome chʉ'ʉre. Jã'ata'ni pãi cu'ache cho'onare Diopi chʉ̃'ʉʉna na'a rʉa cu'ache ti'jñeja'mʉ repanare —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chekʉnare te'eka'chapanare cu'ache cho'osinare vanisõñu chini ja'me saasome repana. ");
INSERT INTO coe_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Saijʉ aikũti Sĩjopʉjakũti chiikũtina tĩ'aasome repana. Tĩ'a repaʉ'te Jesure ũcuakũtina kurususẽ'verona jẽ'jo nʉkoasome repana. Chekʉnare cu'ache cho'osinare ũcuaja'che kurususẽ'veroãna jẽ'jo nʉkoasome repana. Te'eʉ'te Jesús ʉjajʉ̃tʉ cakã'kona nʉkoasome. Chekʉni Jesús kã'kojʉ̃tʉ cakã'kona nʉkoasome. ");
INSERT INTO coe_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jẽ'jo nʉkorena Jesús i'kaasomʉ. —Ja'kʉ, ina chʉ'ʉre cu'ache cho'oche jo'e cuasamanejʉ̃'ʉ. Repana cho'oche vesʉme ina —chiniasomʉ repaʉ. Jã'a cho'oto repana sõtaopãi repaʉ ju'isikãñare paañu chini catara'karʉã mami tochasira'karʉãpi chejana su'aasome, Jesús ju'isikãña paajaʉni jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ũcuacheja pa'ina pãi Jesuni ñajʉ nʉkajʉ paniasome. Pãi chʉ̃'ʉnata'ni repaʉni ñajʉ pãisojʉ cu'ache i'kaasome. —Chekʉnare jũ'iñe ʉ̃sesi'kʉasomʉ ikʉ. Repaʉ Cristo, pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios chẽa Raosi'kʉ pani ũcuaʉji meñe jũ'iñe ʉ̃sea'kʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sõtaopãi ũcuaja'che repaʉni pãisojʉ ʉche cono rʉara'kare, “Ũkujʉ̃'ʉ”, chiijʉ ija'che i'kaasome: ");
INSERT INTO coe_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Mʉ'ʉpi judíopãi ũcuanʉkore chʉ̃'ʉkʉ pani jũ'iñe meñe ʉ̃sejʉ̃'ʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kurususẽ'vero chã'tiro'te tochasiko'a sʉniasomʉ, Ikʉ Judiopãi Chʉ̃'ʉkʉ'mʉ, chiiko'a. ");
INSERT INTO coe_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chekʉ ũcuaja'che, cu'ache cho'osi'kʉpi ja'me jẽ'jocojñosi'kʉ Jesure cu'ache i'kaasomʉ. —¿Dios Raosi'kʉa'ʉ mʉ'ʉ? Ũcuaʉ pani jũ'iñe meñe ʉ̃sekʉ chʉkʉna jũ'iñe ũcuaja'che ʉ̃sekaijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chikʉna chekʉ ũcuaja'che jẽ'jocojñosi'kʉ jã'aja'ñe i'kamanea'kʉ chini ija'che i'kaasomʉ: —¿Diore vajʉchʉma'kʉ mʉ'ʉ? Chotena cu'ache cho'ocojñome mai. ");
INSERT INTO coe_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maita'ni cu'ache cho'osinajejʉ cu'ache cho'ocojñome. Mai cu'ache cho'osi'e ro'ia'me ie. Ikʉta'ni cu'ache cho'omanesi'kʉpi cu'ache cho'ocojñomʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chini Jesure ija'che i'kaasomʉ:— Jesús, mʉ'ʉ pãi ũcuanʉkore chʉ̃'ʉrʉmʉ cuasajʉ̃'ʉ chʉ'ʉva'ʉre —chiniasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Iumucuse Dios pa'ichejana pãi rʉa pojojʉ pa'ichejana sani chʉ'ʉna'me pa'ija'mʉ mʉ'ʉ. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Reparʉmʉ nʉkarepaʉ sʉ'itona ʉ̃sʉʉ miañe ta'pisoʉna cheja si'acheja trejatʉ'ka chijaniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ʉ̃sʉʉ miamaneasomʉ. Ũcuachi'a Dios vʉ'e sa'navʉ caruupʉ kakasa'aro rueekãa ũcuate'ekãapi joorepapoji che'resoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ũcuarʉmʉ Jesús rʉa cuikʉ ija'che i'kaasomʉ: —Ja'kʉ, chʉ'ʉ rekocho mʉ'ʉni ĩsimʉ chʉ'ʉ —chiniasomʉ repaʉ. Chini Jesús jũnisoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ũcuarʉmʉ sõtaopãi cienrepanare chʉ̃'ʉkʉ ũcuachejare kueñe nʉkakʉ repa cho'osi'ere ña Dioni pojokʉ ija'che i'kaasomʉ: —Rʉa re'okʉ pa'isi'kʉa'mʉ jã'ʉ. Ũcuarepaa'me —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jesure cho'oche'te ñañu chini raisina pãi ũcuanʉko repaʉ jũ'isi'ere ña repana ã'capʉãna vaijʉ oijʉ repana vʉ'ñana co'iasome. ");
INSERT INTO coe_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesure ja'me pa'isina so'ore nʉkajʉ repaʉ'te cho'oche peore ñaasome. Romi ũcuaja'che Galilea chejapi Jesure jovo ja'me raisina repaʉ'te cho'oche so'ore nʉkajʉ peore ñaasome. ");
INSERT INTO coe_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ũcuarʉmʉ pãiʉ rʉa re'okʉ, Judea cheja cajoopo Arimatea cakʉ paniasomʉ. Repaʉ mami Josea'mʉ. Dios Raosi'kʉ chʉ̃'ʉjarʉmʉ tĩ'añe'te cha'akʉ paniasomʉ repaʉ. Judíopãi chʉ̃'ʉnare ja'me chʉ̃'ʉasomʉ repaʉ. Jã'ata'ni repaʉ'te ja'me chʉ̃'ʉnapi Jesure vanisoche'te chʉ̃'ʉto ja'me chʉ̃'ʉcuheasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesuni jũ'isi'kʉni sa tãra chini sani Pilatoni sẽniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sẽejani rani Jesure caso sábanakãapi reaasomʉ repaʉ. Rea pi'ni sa aikũti caripana tẽtoche ũhisicojena cuaa ũhaasomʉ repaʉ, chuta'a te'eʉ'terejẽ'e jũ'isi'kʉre cuaa ũhamacojena. ");
INSERT INTO coe_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pʉaumucuse tĩ'api'rakʉna peore care'vache paniasomʉ repanare. ");
INSERT INTO coe_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Romi Galilea cheja Jesure ja'me raisina Jesure cojena cuaa ũhañe ja'me tuha ñaasome. ");
INSERT INTO coe_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ũhañe ñasinajejʉ repana vʉ'ñana co'i okoma'ña cheke ma'ña suiriche care'vaasome repana sa Jesuni jũ'isi'kʉni ro'vejʉ suiriñu chini. Care'va pi'ni pʉaumucuse tĩ'aʉna pʉaasome repana romi, aperʉmʉna Diopi pʉaumucuse jo'kasi'ejekʉna. ");
INSERT INTO coe_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Romicorʉmʉ apeñatatona repana care'vasi'e ma'ña sajʉ saniasome repana romi Jesure ũhasicojena. ");
INSERT INTO coe_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sani ñato catapʉ rʉa ʉjapʉ repacoje ta'pisi'pʉ kʉñososi'pʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kʉñosi'pʉjekʉna coje kaka ñato Pãi Ũcuanʉkore Paakʉ vaniso tãcojñosi'kʉ Jesús peoasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Peokʉna ña kʉkʉ, “¿Je'se paakʉ ie?”, chini cuasatona peosichejapi teana ʉmʉpãi te'eka'chapana, rʉa ko'sijakãña ju'inapi repanare romi kueñe nʉkaasome. ");
INSERT INTO coe_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Peosichejapi pa'ijʉna ña kʉkʉso, meñe sime nʉkajʉna ija'che i'kaasome: —¿Je'se pa'iʉna mʉsanʉkona vajʉraisi'kʉni pãi jũ'isina pa'ichejare ku'eche? ");
INSERT INTO coe_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Icheja peomʉ repaʉ. Vajʉranicuhasi'kʉa'mʉ. Repaʉ Galilea cheja pa'irʉmʉ kʉasi'ere cuasajʉ̃'ʉ. Ija'che kʉasi'kʉa'mʉ repaʉ: ");
INSERT INTO coe_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Chʉ'ʉre Dios Raosi'kʉre chẽa cu'ache cho'onani jo'kajanaa'me pãi, cu'ache cho'oa'jʉ chini. Jo'karena kurususẽ'verona jẽ'jo vẽasõjanaa'me repana chʉ'ʉre. Vanisõcojñosi'kʉta'ni choteumucujñana vajʉraija'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ Jesús —Jã'aja'ñe kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Kʉarena asa Jesús kʉasi'ere cuasa repacojepi eta Jesús neenare oncerepanani kʉañu chini saniasome. Sani tĩ'a peore kʉaasome repana romi. Ũcuachi'a chekʉnare Jesure chiinare ũcuanʉkore kʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalenaa'mo, Juanaa'mo, Santiago pʉka'ko Maríaa'mo chekʉna romi repanare ja'me saisina ũcuanʉko kʉaasome Jesús neenare, repaʉ saosinare. ");
INSERT INTO coe_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kʉajʉna, “Rʉa tĩiñe kʉame ina”, chiijʉ jachaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedrota'ni asa Jesure tãsichejana vʉ'vʉasomʉ ñara chini. Vʉ'vʉ tĩ'a sime ñato coje sa'navʉ Jesure reasikãñachi'a ũniasomʉ. Kãñachi'a ũhiʉna ña vʉ'ena co'ikʉ, “¿Je'se paakʉ ie?”, chiiʉ cuasaasomʉ Pedro. ");
INSERT INTO coe_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ũcuaumucusena Jesure chiina, te'eka'chapana Emaús vʉ'ejoopona saniasome. Jerusalén vʉ'ejoopoji Emaús vʉ'ejoopojatʉ'ka once kilómetros pa'iʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Emaús vʉ'ejoopona saijʉ reparʉmʉ cho'osi'ere cutuasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sãiñechi'a cutujʉ chʉ'o rʉa sẽniasajʉ saijʉna repanare Jesús rani tĩ'a ja'me saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ja'me saikʉ'teta'ni ña vesʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ña vesʉjʉna repanare chʉ'o sẽniasomʉ repaʉ. —¿Ʉ̃quere mʉsanʉkona cutujʉ saiche? —chiniasomʉ Jesús repanare. Jã'aja'ñe i'kaʉna sʉmava'na canʉkaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Canʉkasirʉmʉ te'eʉ Cleofaji i'kaasomʉ repaʉ'te. —Irʉmʉ Jerusalén vʉ'ejoopo pãi jainʉko raisina pa'ime. Repana rani pa'ijʉ repajoopo iumucujña cho'osi'e ũcuanʉko masime. ¿Mʉ'ʉ vesʉkʉ? —chiniasomʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chikʉna Jesús i'kaasomʉ. —¿Je'se cho'ore? —chiniasomʉ. Sẽeʉna i'kaasome repana. —Jesús, Nazaret cakʉre cho'osi'ere i'kame chʉkʉna. Dios chʉ'o kʉakaikʉ pa'isi'kʉa'mʉ repaʉ. Diochi'a cho'omasiche'te cho'o ñokʉ Dios chʉ'o rʉa masi kʉasi'kʉa'mʉ repaʉ. Jã'aja'ñe cho'okʉna Dios rʉa pojoasomʉ repaʉ'te. Pãi ũcuaja'che rʉa pojosinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jã'aja'ñe pa'ikʉni judío phairipãi chʉ̃'ʉnana'me maire chʉ̃'ʉna, repaʉ'te chẽa sa chekʉnani jo'kasinaa'me, vanisõñe'te chʉ̃'ʉa'jʉ chini. Sa jo'karena repaʉ'te kurususẽ'verona jẽ'jo nʉko vẽasõsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ija'che cuasasinaa'me chʉkʉna: “Ikʉ Jesús maire Israelpãi Romapãi chẽa paacojñonare tʉa paaja'mʉ”, chini cuasajʉ pa'isinaa'me chʉkʉna. Jã'ata'ni irʉmʉ repaʉji chuenisõʉna tãsi'e choteumucujñaa'me. ");
INSERT INTO coe_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Chʉkʉna'te ja'me pa'ina romi iapeñatato repaʉ'te tãsicheja sani ñaasome. Sani kaka ñato tãcojñosi'kʉ Jesús peoasomʉ. Peokʉna rani ija'che kʉasinaa'me repana chʉkʉna'te: “Angeles peosichejapi rani pa'ijʉna ñasinaa'me chʉkʉna. Rani, ‘Jesús vajʉranicuhasi'kʉa'mʉ’, chiisinaa'me ángeles chʉkʉna'te”, chiisinaa'me repana romi. Romipi jã'aja'ñe ra kʉajʉna asa kʉkʉsinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kʉarena asa chʉkʉna'te ja'me pa'ina repacoje sani ñato romi kʉasi'e ũcuarepa paniasomʉ. Tãcojñosi'kʉ Jesús peoasomʉ —chiniasome repana Jesure Emaús vʉ'ejoopo saina. ");
INSERT INTO coe_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jã'aja'ñe kʉarena asa i'kaasomʉ repaʉ. —Dios chʉ'o kʉasina tocha jo'kasi'e masime mʉsanʉkona. Jã'ata'ni rũhiñe cuasamanajejʉ repana tocha jo'kasi'e masi cuasama'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aperʉmʉ Dios chʉ'o kʉasina Cristo'te ti'jñejañere kʉajʉ ija'che tocha jo'kaasome: Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉ pãi cu'anani cu'ache cho'ocojñosi'kʉta'ni na'a pa'isirʉmʉ pãi ũcuanʉkore chʉ̃'ʉja'mʉ, chiimʉ repana tocha jo'kasi'e —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Repanapi repaʉ pa'iche'te na'a rʉa masia'jʉ chini, repaʉ pa'ijachere kʉara chini Moisés tocha jo'kasi'ena'me aperʉmʉ Dios chʉ'o kʉasina repaʉ pa'ijachere kʉañu chini tocha jo'kasi'e peore masi kʉaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kʉakʉ saiʉ repana saijoopona tĩ'ajʉna Jesús canʉkama'kʉ ñoñe saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Canʉkama'ñe ñoñe saiʉna saimanea'kʉ chini repaʉ'te rʉa i'kaasome repana. —Na'isõsi'ea'me ie. Saimairo chʉkʉnana'me canʉkajʉ̃'ʉ —chiniasome repana repaʉ'te. Chiijʉna ũcuana vʉ'ena kaka canʉkaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Canʉka pa'iʉ ũcuanana'me mesako'are ñu'iʉ pãpʉ mini Dioni, “Re'orepamʉ”, chini tʉ'se ĩsiasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tʉ'se ĩsiʉna repaʉ'te ñavesʉsina ña masiasome repana. Ña masirena ũcuachejapi teana peoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Peokʉna sãiñechi'a i'kaasome repana. —Ma'a rairʉmʉ repaʉji Dios chʉ'o tocha jo'kasi'ere masi kʉakʉna asa pojojʉ raisinaa'me mai —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ũcuarʉmʉ ñu'isinapi vʉni Jerusalenna co'i repaʉ neenare oncerepanana'me repanare ja'me chi'i pa'inani ñaasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Co'irena ija'che i'kaasome chi'isina: —Maire Paakʉ vajʉraisi'e ũcuarepaasomʉ. Simonni peosichejapi rani ñoasomʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chitena Emaús ma'a saisina ũcuaja'che Jesure ñasi'ere kʉaasome. “Chʉkʉna'te ũcuaja'che peosichejapi rani pa'isi'kʉa'mʉ repaʉ. Jã'ata'ni repaʉ'te ñavesʉsina repaʉji chʉkʉnani pãpʉ'te mini tʉ'se ĩsiʉna ña masisinaa'me chʉkʉna”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Repanare chuta'a ũcuare cutunani Jesús repana chenevʉna peosichejapi rani nʉkakʉ ija'che i'kaasomʉ: —Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nʉkakʉna ña, “Jũ'isi'kʉpi ikʉ reko raimʉ”, chini cuasajʉ rʉa kʉkʉasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kʉkʉjʉna i'kaasomʉ repaʉ. —¿Je'se pa'iʉna mʉsanʉkona kʉkʉche? ¿Je'se pa'iʉna mʉsanʉkona chʉ'ʉ vajʉraisi'e jachache? ");
INSERT INTO coe_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chʉ'ʉa'mʉ. Ñajʉ̃'ʉ chʉ'ʉ jʉ̃jñana'me cũ'a. Chẽse ña masijʉ̃'ʉ chʉ'ʉre. Jũ'isi'kʉ rekocho ca'nivʉjẽ'e peomʉ. Chʉ'ʉta'ni ca'nivʉna'me tara paamʉ. Ñame mʉsanʉkona chʉ'ʉ paache —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chini repanare jʉ̃jñana'me cũ'a ñoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ñokʉna ña pojonata'ni repaʉ'te jachaasome repana. “¿Ikʉ chʉ'o ũcuarepare i'kakʉ?”, chini cuasaasome repana. Jã'aja'ñe cuasajʉna i'kaasomʉ repaʉ. —¿Mʉsanʉkona icheja ãiñe peoche? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chikʉna repaʉ'te chiacha va'imaka posimakare ĩsiasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ĩsirena koo, repana ñajʉ'te ãniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ãni pi'ni ija'che i'kaasomʉ repaʉ: —Aperʉmʉ mʉsanʉkonare ja'me pa'irʉmʉ ija'che kʉasi'kʉa'mʉ chʉ'ʉ: “Moisés tocha jo'kasi'ena'me Dios chʉ'o kʉasina tocha jo'kasi'ena'me Salmophʉro tocha jo'kasi'e chʉ'ʉ cho'ocojñojañere kʉamʉ. Repana tocha jo'kasi'epi ti'jñeja'mʉ chʉ'ʉre”, chiisi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. Ũcuapi ti'jñecuhasi'kʉa'mʉ chʉ'ʉre —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dios chʉ'o tocha jo'kasi'ere repanapi asavesʉjʉna repana rekoñoãna asamasiche cho'oasomʉ Jesús repanare, asamasia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Asamasiche cho'o ija'che i'kaasomʉ repaʉ: —Dios chʉ'o aperʉmʉ tocha jo'kasi'e ija'che kʉamʉ: Cristo'te, Dios Raosi'kʉre jũ'iñe pa'ija'mʉ. Jũnisõʉna tãcojñosi'kʉta'ni choteumucujñana vajʉraija'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Repaʉ vajʉraisirʉmʉ repaʉ neena, “Cristoji maire cho'okaija'mʉ”, chini cuasajʉ Dios chʉ'o pãire ija'che chʉ'vajanaa'me: “Mʉsanʉkona cu'ache cho'oche ũhasõ re'oja'che pa'ijʉ̃'ʉ. Jã'aja'ñe cho'oto Dios mʉsanʉkona cu'ache cho'osi'e tʉnosõja'mʉ. Tʉnosõsi'e jo'e cuasamaneja'mʉ Repaʉ”, chiijanaa'me. Charo Jerusalén vʉ'ejoopo canani chʉ'vajanaa'me repana. Jã'achejapi si'achejñarʉã sani ku'ijʉ chʉ'vajanaa'me repana, chiimʉ repana tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jã'ajekʉna mʉsanʉkona ñasi'ere chekʉnani kʉajʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dios Rekocho chʉ'ʉ Ja'kʉ aperʉmʉ saoja'mʉ chiisirekocho'te raoja'mʉ chʉ'ʉ mʉsanʉkonare. Saima'ñe Jerusalén vʉ'ejoopo'te pa'ijʉ cha'ajʉ̃'ʉ mʉsanʉkona, Dios Repaʉ Rekocho peore Masirekocho raochetʉ'ka. Repaʉ Rekochoji cho'okaiʉna na'a rʉa masijanaa'me mʉsanʉkona —chiniasomʉ Jesús repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","I'ka pi'ni Jesús repaʉ neenare Betania vʉ'ejoopona saasomʉ. Sa tĩ'a repaʉ jʉ̃jña mʉñe ruhika'java pe'che nʉkakʉ, “Diopi mʉsanʉkonare re'oja'che cho'okaaʉ”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jã'aja'ñe i'ka repanare jo'ka Diopi mʉakʉna cʉnaʉmʉna mʉnisoasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mʉnisoʉna ro're ñu'ijʉ, “Rʉa re'okʉ'mʉ repaʉ”, chiijʉ cuasajʉ pojoasome repana repaʉ'te. Ro're ñu'isinapi vʉni rʉa pojojʉ Jerusalén vʉ'ejoopona co'iasome repana. ");
INSERT INTO coe_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Co'i pa'ijʉ Dios vʉ'e si'arʉmʉ mʉa Dioni pojojʉ paniasome repana, “Rʉa re'okʉ'mʉ mʉ'ʉ”, chiijʉ.");
INSERT INTO coe_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Chuta'a cʉnaʉmʉna'me cheja cho'omarʉmʉ Jesucristo Dios pa'iche kʉajaʉ paniasomʉ. Diona'me paniasomʉ repaʉ. Dioa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Reparʉmʉ Diona'me paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diopi repaʉji ja'me cho'oa'kʉ chini chʉ̃'ʉʉna peore cho'oasomʉ repaʉ ũcuaʉna'me. Repaʉji ja'me cho'omaneru peora'amʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Repaʉ Jesucristo mai rekoñoã pa'iche re'oja'chere ĩsikʉ'mʉ. Jã'ajekʉna Miañeja'ñe Pa'ikʉji rani mai rekoñoã Dios pa'iche masire'oche cho'okaiʉna Repaʉ pa'iche'te masijʉ re'oja'che pa'ire'omʉ maire. ");
INSERT INTO coe_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Repaʉ Miañeja'ñe Pa'ikʉ icheja mai pa'icheja chijachejaja'che cu'ache pa'ina pa'ichejana rani re'oja'che cho'osi'kʉa'mʉ. Jã'aja'ñe pa'ikʉni pãi repaʉni cuhejʉ repaʉ re'oja'che cho'oche ʉ̃señu chiime. Jã'ata'ni ʉ̃secu'amʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pãiʉ'te chẽa raoasomʉ Dios. Repaʉ mamia'me Juan. ");
INSERT INTO coe_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Miañeja'ñe Pa'ikʉ Jesucristo pa'iche'te kʉaa'kʉ chini chẽa raoasomʉ Dios repaʉ'te, pãipi ũcuanʉko repaʉ kʉache'te asa chẽa Jesucristoni cuasaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Miañeja'ñe Pa'ikʉma'mʉ Juan. Repaʉ Miañeja'ñe Pa'ikʉ pa'iche'te kʉakaaʉ chini raocojñosi'kʉasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na'a pa'isirʉmʉna Miañeja'ñe Pa'ikʉ raniasomʉ, pãipi Dios pa'iche'te masijʉ re'oja'che pa'imasia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Repaʉ Jesucristo chejare pãina'me pa'isi'kʉa'mʉ. Diopi chʉ̃'ʉʉna peore cho'okʉ'teta'ni repaʉ pa'iche vesʉsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Repaʉ cho'osichejana raisi'kʉreta'ni repaʉ majapãi Israelpãi pojomanesinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Chekʉnare repaʉ'te cuasajʉ pojonareta'ni, “Dios chĩia'me ina”, chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Repaʉ'te cuasana pa'iche'te maipi ija'che cuasato cu'amʉ: “Pãi ũcuanʉko Dios chĩichi'aa'me”, chini cuasato cu'amʉ. Ũcuachi'a, “Ʉmʉʉna'me romiochi'a chiijʉ chĩiva'nare paa Dios chĩia'me ina”, chini cuasato cu'amʉ. Ũcuachi'a, “Pãiʉ chĩi paaneekʉ chĩiva'nare paa Dios chĩia'me ina”, chini cuasato cu'amʉ. Peore jã'aja'ñe cuasache cu'amʉ. Jã'ata'ni, “Repanapi Dioni cuasajʉna Repaʉji chẽa paatota'ni Repaʉ chĩia'me jã'ana”, chini cuasato re'omʉ. Jã'aja'ñeta'ni ũcuarepaa'me. ");
INSERT INTO coe_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesús Dios pa'iche Kʉajaʉ pãioji jñaaona maija'iʉ pãiʉ ainee jmamakarʉ maina'me pa'isi'kʉa'mʉ repaʉ. Pãire oiʉ re'oja'che cho'okaisi'kʉa'mʉ repaʉ. Ũcuachi'a Dios pa'iche ũcuarepare kʉasi'kʉa'mʉ. Pʉka'kʉpi, repaʉ'te ũcuate'eʉ'te rʉa Masiʉ'te jo'kaʉna rʉa Masiʉ pa'iʉna ñasinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Repaʉ Juan Pãi Okoro'vesi'kʉ Jesure ña ʉjachʉ'opi ija'che i'kaasomʉ: “Aperʉmʉ ikʉ pa'ijache ija'che kʉasi'kʉa'mʉ chʉ'ʉ: ‘Pãiʉ, cho'je Raijaʉ chʉ'ʉre na'a rʉa masiʉ'mʉ, chʉ'ʉ chuta'a peorʉmʉ pa'ikʉjekʉ’, chiisi'kʉa'mʉ chʉ'ʉ”, chiniasomʉ repaʉ Juan Pãi Okoro'vesi'kʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Repaʉ Jesús maire rʉa oikʉjekʉ si'arʉmʉ rʉa re'oja'che cho'okaiʉ pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios Repaʉ chʉ̃'ʉñe'te tocha jo'kaa'kʉ chini Moiseni chʉ̃'ʉasomʉ. Jesucristo'teta'ni pãire oiʉ re'oja'che cho'okaiʉ Repaʉ pa'iche'te ũcuarepare kʉaa'kʉ chini chʉ̃'ʉ raoasomʉ Repaʉ Dios. ");
INSERT INTO coe_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Diore ñoma'kʉjekʉna ñamanaa'me pãi. Mamakʉta'ni ũcuate'eʉji Pʉka'kʉre si'arʉmʉ kueñe ja'me pa'ikʉji Pʉka'kʉ pa'iche kʉasi'kʉa'mʉ maire. ");
INSERT INTO coe_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ũcuarʉmʉ Jerusalén vʉ'ejoopo cana judíopãi chʉ̃'ʉna Juan pa'ichejana sani, “¿Keeja'iʉ'ʉ mʉ'ʉ?”, chiapʉ chini phairipãina'me Leví jojosinare Dios vʉ'e cho'oche cho'okainani saoasome. ");
INSERT INTO coe_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Saorena sani repaʉ pa'iche'te sẽejʉna rũhiñe kʉaasomʉ Juan repanare. —Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raoja'mʉ chiisi'kʉma'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Chikʉna jo'e sẽniasome repana. —Jã'a pa'ito, ¿keeja'iʉ'ʉ mʉ'ʉ? ¿Aperʉmʉ pa'isi'kʉ, Elíaa'ʉ? ¿Dios chʉ'o kʉakʉ'ʉ? —chiniasome repana. Chitena i'kaasomʉ repaʉ. —Elíama'mʉ chʉ'ʉ —chiniasomʉ repaʉ. Chikʉna jo'e sẽniasome repana. —Jã'a pa'ito, ¿chʉkʉna cha'acojñokʉ'ʉ mʉ'ʉ? ¿Dios chʉ'o kʉakaijaʉa'ʉ? —chiniasome repana. Chitena i'kaasomʉ repaʉ. —Mʉsanʉkona cha'acojñokʉma'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chikʉna jo'e i'kaasome repana. —Jã'a pa'ito, ¿keeja'iʉ'ʉ mʉ'ʉ? Kʉajʉ̃'ʉ chʉkʉna'te. Mʉ'ʉ kʉasi'ere chʉkʉna'te raosinare sa kʉache pa'imʉ. Mʉ'ʉ cho'oche, ¿ʉ̃quea'che? —chiniasome repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chitena i'kaasomʉ repaʉ. —Pãi peochejare rani pa'iʉ pãipi raito ʉjachʉ'opi ija'che i'kakʉ chʉ'vamʉ chʉ'ʉ: “Maire Paakʉni cha'ajʉ mʉsanʉkona rekoñoã ma'a rũhiñe pa'ima'a care'vacheja'che, re'ojarekoñoã care'vajʉ pa'ijʉ̃'ʉ.” “Jã'aja'ñe i'kaja'mʉ repaʉ”, chiiʉ aperʉmʉ Isaías, Dios chʉ'o kʉasi'kʉ tocha jo'kaasomʉ, chʉ'ʉ i'kajachere kʉara chini —chiniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ũcuarʉmʉ Juanre sẽniasaa'jʉ chini fariseopãi saosina repaʉ'te jo'e i'kaasome. —“Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raoja'mʉ chiisi'kʉma'mʉ chʉ'ʉ. Elíama'mʉ chʉ'ʉ. Dios chʉ'o kʉakaikʉma'mʉ chʉ'ʉ. Mʉsanʉkona cha'acojñokʉma'mʉ chʉ'ʉ”, chiikʉta'ni, ¿je'se pa'iʉna pãi okoro'vekʉ mʉ'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chitena i'kaasomʉ repaʉ. —Pãi okoro'vekʉ'mʉ chʉ'ʉ. Chekʉ mʉsanʉkonani ja'me pa'imʉ. Jã'ata'ni repaʉ'te pojoma'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","“Chʉ'ʉre cho'je raija'mʉ”, chiisi'kʉre mʉsanʉkonare ja'me pa'ikʉ'te na'a rʉa masikʉjekʉna repaʉ'te cuasa, vajʉchʉkʉ pa'imʉ chʉ'ʉ —chiniasomʉ repaʉ Juan Pãi Okoro'vekʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordán chiacha chekʉkã'ko ʉ̃sʉʉ mʉikã'ko cacheja Betania chejana Juan Pãi Okoro'vekʉ pa'ichejana jã'aja'ñe cho'oasome repana. ");
INSERT INTO coe_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jo'e apeñatato Jesupi repaʉ pa'ichejana saiʉna ña i'kaasomʉ Juan. —Ñajʉ̃'ʉ jã'ʉre Dios Raosi'kʉre. Pãi ũcuanʉko cu'ache cho'oche'te ro'ikasa chini chuenisõja'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aperʉmʉ repaʉ pa'ijache ija'che kʉasi'kʉa'mʉ chʉ'ʉ: “Chʉ'ʉ cho'je Raijaʉta'ni chʉ'ʉ chuta'a peorʉmʉ pa'ikʉjekʉ chʉ'ʉre na'a rʉa masikʉ'mʉ”, chiisi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aperʉmʉna repaʉ pa'iche vesʉkʉta'ni rani pãire okoro'vemʉ chʉ'ʉ, Israelpãipi ũcuanʉko repaʉ pa'iche'te masia'jʉ chini —chiniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ũcuarʉmʉ Juan ija'che kʉaasomʉ: —Dios Rekocho ũkupoja'iʉ cʉnaʉmʉpi ñoʉ caje ikʉni canʉkaʉna ñasi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jã'aja'ñe repaʉ pa'iche chuta'a ñamarʉmʉ vesʉsi'kʉa'mʉ chʉ'ʉ. Chʉ'ʉpi pãire okoro'vea'kʉ chini chʉ'ʉre Raosi'kʉ Dios aperʉmʉ ija'che i'kasi'kʉa'mʉ chʉ'ʉre: “Na'a pa'isirʉmʉ chʉ'ʉ Rekochoji caje pãiʉni canʉkache ñaja'mʉ mʉ'ʉ. Ũcuarekocho'te pãire ĩsija'mʉ repaʉ, repaʉ'te cuasanani ja'me paaʉ chini”, chiisi'kʉa'mʉ Dios chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dios kʉasi'e Repaʉ Rekocho cajeche ñasi'kʉa'mʉ chʉ'ʉ. Ñasi'kʉjekʉ, “Dios Mamakʉ'mʉ ikʉ”, chiiʉ kʉamʉ chʉ'ʉ —chiniasomʉ repaʉ Juan. ");
INSERT INTO coe_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Jo'e chekʉumucuse Juan repaʉ neena te'eka'chapanana'me ũcuachejare paniasome. Jesupi ũcuachejapi caraiʉna ña i'kaasomʉ repaʉ. —Ñajʉ̃'ʉ jã'ʉre, Dios Raosi'kʉre. Pãi ũcuanʉko repana cu'ache cho'oche'te ro'ikasa chini chuenisõja'mʉ jã'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chikʉna asa repaʉ neena te'eka'chapana Jesure tuhaasome. ");
INSERT INTO coe_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tuhajʉna Jesús chʉri ña i'kaasomʉ repanare. —¿Ʉ̃que tuhache mʉsanʉkona chʉ'ʉre? —chiniasomʉ repaʉ. Chikʉna i'kaasome repana. —Masiʉ, ¿keecheja cavʉ'ere pa'iʉ ku'ikʉ mʉ'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chitena Jesús i'kaasomʉ. —Raijʉ̃'ʉ. Sani ñañu —chiniasomʉ repaʉ. (Reparʉmʉ na'ito chekʉrʉmʉ cuatro pa'icosomʉ.) Chikʉna repaʉ pa'ivʉ'e tuha ña ũcuavʉ'ere pa'ijʉ na'iasome repana. ");
INSERT INTO coe_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Repana te'eka'chapana Juanpi i'kaʉna asa tuhasina te'eʉ Andrea'mʉ, Simón Pedro cho'jeʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ũcuarʉmʉ Andrés na'mi sani repaʉ majaa'chʉni Simonre ku'e jñaa i'kaasomʉ. —Cristo'te tijñasinaa'me chʉkʉna —chiniasomʉ repaʉ. (“Cristo” chini “Pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raosi'kʉa'mʉ” chiimʉ griego chʉ'o.) ");
INSERT INTO coe_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","I'ka pi'ni majaa'chʉre Simonre Jesús pa'ichejana saasomʉ repaʉ. Saʉna ña Jesús repaʉ'te Simonre ija'che i'kaasomʉ: —Mʉ'ʉ mamia'me Simón. Juan mamakʉ'mʉ mʉ'ʉ. Jo'e chekere mami ve'oja'mʉ chʉ'ʉ mʉ'ʉre Cefa'te —chiniasomʉ repaʉ Jesús. (“Cefas” chini “Pedro” chiimʉ griego chʉ'o.) ");
INSERT INTO coe_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jo'e apeñatato repaʉ Jesús Galilea chejana sasa chiniasomʉ. Chuta'a saima'ñe pa'iʉ Felipe'te tijña i'kaasomʉ. —Chʉ'ʉni ja'me ku'iʉ chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Repaʉ Felipe Betsaida vʉ'ejoopo cakʉasomʉ. Andrena'me Pedro ũcuachi'a ũcuate'ejoopo canaasome. ");
INSERT INTO coe_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ũcuarʉmʉ Felipe Natanaelre ku'e jñaa i'kaasomʉ. —Dios Raoja'mʉ chiisi'kʉni tijñacuhasinaa'me chʉkʉna. Moisés aperʉmʉ Dios chʉ̃'ʉsi'e tocha jo'kasiphʉro repaʉ pa'ijachere kʉamʉ, Dios chʉ'o kʉasina ũcuachi'a. Churata'ni ũcuarepaʉni ñame mai. Jesua'mʉ repaʉ. Nazaret vʉ'ejoopo cakʉa'mʉ. José mamakʉasomʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chikʉna Natanael i'kaasomʉ. —Nazaret vʉ'ejoopo cana te'eʉjẽ'e re'okʉjẽ'e peocosome —chiniasomʉ. Chikʉna Felipe i'kaasomʉ. —Rani ña masijʉ̃'ʉ repaʉ'te —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","“Jaʉ”, chini Jesús pa'ichejana Natanaelpi tĩ'akʉna ña i'kaasomʉ Jesús. —Ñajʉ̃'ʉ. Israelrepaʉji jmamakarʉjẽ'e jorema'kʉpi raimʉ jã'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chikʉna Natanael ija'che sẽniasaasomʉ repaʉ'te: —¿Je'se pa'iʉna chʉ'ʉ pa'iche masikʉ mʉ'ʉ? —chiniasomʉ. Chikʉna Jesús i'kaasomʉ. —Felipe mʉ'ʉre chuta'a soimarʉmʉ higoñʉ vʉ'evʉ pa'ikʉni ñasi'kʉa'mʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chikʉna Natanael i'kaasomʉ repaʉ'te. —Masiʉ, Dios Mamakʉ'mʉ mʉ'ʉ. Israelpãi chʉ̃'ʉkʉ'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Chʉ'ʉpi repacheja pa'imanesi'kʉpi mʉ'ʉni, “Higoñʉ vʉ'evʉ pa'ikʉni ñasi'kʉa'mʉ chʉ'ʉ mʉ'ʉre”, chikʉna asa, “Dios Mamakʉ'mʉ mʉ'ʉ”, chini cuasamʉ mʉ'ʉ chʉ'ʉre. Jã'ajekʉna chʉ'ʉpi chekere na'a vesache'te cho'okʉna ñaja'mʉ mʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chini jo'e i'kaasomʉ Jesús. —Chʉ'ʉre pãire ja'me paaʉ chini Dios Raosi'kʉre cʉnaʉmʉpi vataʉna chʉ'ʉ nʉkachejana ángeles Diore ja'me pa'inapi mʉni caje jo'e mʉni cajejʉ cho'onani ñajanaa'me mʉsanʉkona. Ũcuarepaa'me jã'a —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka'chaumucujña pa'isirʉmʉna Galilea cheja cajoopo Caná vʉ'ejoopona pãiʉji romioni vejakʉna fiesta cho'osinaa'me pãi. Jesús pʉka'ko repanare ja'me pa'isi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Sotena chʉkʉna Jesús neena repaʉna'me saisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fiesta cho'orʉmʉna pĩsi ʉche conopi si'asõʉna Jesús pʉka'ko repaʉ'te ija'che i'kasi'koa'mo: —Pĩsi ʉche cono si'asõmʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chikona Jesús i'kasi'kʉa'mʉ. —Ja'ko, ¿je'se pa'iʉna chʉ'ʉni kʉako mʉ'ʉ? Chʉ'ʉ masiche cho'o ñorʉmʉ chuta'a tĩ'ama'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chikʉna pĩsi ʉche cono ũkuanare i'kasi'koa'mo repao. —Chʉ'ʉ neekʉ chʉ̃'ʉñe peore cho'ojʉ̃'ʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Repana nʉkacheja kueñere churupʉã catapi cho'osipʉã seirepapʉã pa'isi'kʉa'mʉ. (Judíopãi cu'a tʉnorʉmʉ ũcuapʉãqueepi oko jʉ̃jña masi choasinaa'me. Te'epʉ cincuenta litros chekʉrʉmʉ setenta litrojatʉ'ka oko ro've paaasome repana.) ");
INSERT INTO coe_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Reparʉmʉ Jesús pĩsi ʉche cono ũkuanare ija'che i'kasi'kʉa'mʉ: —Ipʉã oko ro've timujʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. Chikʉna repapʉã oko ro've timusinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Reparʉmʉ Jesús repanare jo'e i'kasi'kʉa'mʉ. —Chura jmara'karʉ ea sa fiesta chʉ̃'ʉkʉni ũkuajʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ repanare. Chikʉna repaʉ chʉ̃'ʉsi'e cho'osinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Sa ĩsirena fiesta chʉ̃'ʉkʉji charo ũku ñasi'kʉa'mʉ okopi pĩsi ʉche cono carũhisi'e. Jã'ata'ni repaʉ repana ea rasicheja vesʉsi'kʉa'mʉ. Repaʉ'te cho'oche cho'okainata'ni masisinaa'me easinajejʉ. Ũku pi'ni fiesta chʉ̃'ʉkʉ romi vejasi'kʉre soni i'kasi'kʉa'mʉ. —Pãi chekʉna fiesta cho'oni pĩsi ʉche cono na'a rʉa re'oja'chere charo ũkuanaa'me. Repana soicojñosina rʉa ũkusirʉmʉna pĩsi ʉche cono na'a jmamakarʉ re'oja'chere ũkuame. Mʉ'ʉta'ni cho'jepi pĩsi ʉche cono rʉa re'oja'chere ũkuamʉ mʉ'ʉ soisinare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Charo Galilea cheja cajoopo Caná vʉ'ejoopona Diochi'a cho'omasiche'te cho'osi'kʉa'mʉ Jesús, repaʉ aperʉmʉ cho'omanesi'e. Repaʉ masiche'te pãire cho'o ñoʉna chʉkʉna repaʉ neena na'a rʉa cuasasinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jã'a cho'o pi'nisirʉmʉ Capernaum vʉ'ejoopona saisi'kʉa'mʉ repaʉ Jesús, pʉka'kona'me cho'jechĩina'me chʉkʉna repaʉ neena. Sani tĩ'a jmamakarʉ pa'isinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua, judíopãi fiestarʉmʉ tĩ'api'rakʉna Jesús Jerusalén vʉ'ejoopona maisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mani Dios vʉ'e kaka ñato pãi jo'chava'nare vacana'me ovejana'me ũkupova'nare ĩsijʉ pa'isinaa'me. Ũcuachi'a chekʉna so'ña raisinani kuri tĩikurire sa'ñekaijʉ ñu'isinaa'me na'a rʉa jñaañu chini. ");
INSERT INTO coe_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jã'aja'ñe cho'ojʉna ña Jesús pĩsipi ʉjame vãto pi'ni peochejñana suĩ'suekʉ etosi'kʉa'mʉ repanare pãina'me ovejana'me vaca. Ũcuachi'a kuri sa'ñena nee kurire're kʉni to'jñosõ mesako'ña sia po'ne ũhasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jã'aja'ñe cho'o pi'ni ũkupova'nare ĩsinare ija'che i'kasi'kʉa'mʉ repaʉ: —Mʉsanʉkona neemajñarʉã etuajʉ̃'ʉ. Põse ĩsivʉ'e cho'ocheja'che cho'omanejʉ̃'ʉ chʉ'ʉ Ja'kʉ vʉ'e —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jã'aja'ñe i'kaʉna asa chʉkʉna repaʉ neena Dios chʉ'o tocha jo'kasi'ere cuasasinaa'me. Ija'che kʉamʉ repa: Mʉ'ʉ vʉ'e kuiraneekʉjekʉna cu'ache ti'jñeja'mʉ chʉ'ʉre, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ũcuarʉmʉ Jesús cho'osi'ere ña judíopãi chʉ̃'ʉna ija'che sẽesinaa'me repaʉ'te: —¿Neepi chʉ̃'ʉ raorena Dios vʉ'e pa'isinare etoʉ mʉ'ʉ? Dios Raosi'kʉ pani Diochi'a cho'omasiche'te cho'o ñojʉ̃'ʉ chʉkʉna'te —chiisinaa'me repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chitena Jesús i'kasi'kʉa'mʉ. —Ivʉ'ere mʉsanʉkonapi ñañosõru choteumucujña jo'e cho'o pi'nija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chikʉna judíopãi i'kasinaa'me repaʉ'te. —Cuarenta y seirepaʉ̃sʉrʉmʉ cho'ojʉ paniasome pãi ivʉ'e pi'niñetʉ'ka. Jã'arepakeerʉmʉ cho'osivʉ'e, ¿je'se cho'okʉ choteumucujñachi'a cho'oja'ʉ mʉ'ʉ? —chiisinaa'me repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jã'ata'ni Dios vʉ'e cho'oche'te i'kamanesi'kʉa'mʉ Jesús. Repaʉ ca'nivʉ'te i'kasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na'a pa'isirʉmʉ repaʉ Jesús jũni vajʉraisirʉmʉ repaʉ i'kasi'ere jo'e cuasasinaa'me chʉkʉna repaʉ neena. Cuasajʉ, “Dios chʉ'o tocha jo'kasi'ena'me Jesús i'kasi'e ũcuarepaa'me”, chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascuarʉmʉjekʉna Jesús Jerusalén vʉ'ejoopo'te pa'iʉ Diochi'a cho'omasiche'te cho'o ñokʉna ña pãi jainʉko cuasaasome repaʉ'te, “Dios Raosi'kʉa'mʉ ikʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jã'ata'ni pãi ũcuanʉko cuasache masikʉjekʉ sẽ'sevʉchi'a cuasana i'kache jachaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pãi cuasache kʉanare ku'ema'kʉa'mʉ repaʉ, pãi ũcuanʉko cuasache masikʉjekʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Reparʉmʉ Nicodemo paniasomʉ fariseopãiʉ. Judíopãi te'enare chʉ̃'ʉkʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesuni ñara chini ñamipi mʉa i'kaasomʉ repaʉ Nicodemo. —Masiʉ, Diopi mʉ'ʉre raocosomʉ pãire che'choa'kʉ chini. Diopi mʉ'ʉre cho'okaima'to Repaʉchi'a cho'omasiche cho'omanera'amʉ mʉ'ʉ. Masime chʉkʉna jã'a —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chikʉna Jesús i'kaasomʉ. —Pãipi chĩiva'ʉ jñaacojñoñeja'ñe jo'e mama jñaacojñomaneni Dios neena pa'icu'amʉ repanare. Ũcuarepaa'me jã'a —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chikʉna Nicodemo i'kaasomʉ repaʉ'te. —Pãiʉ ai, ¿je'se jo'e mama jñaacojñoja'ʉ? Pʉka'ko cʉtaro kaka jo'e mama etacu'amʉ maire ainare —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chikʉna Jesús i'kaasomʉ. —Pãi ũcuanʉkore romipi jñaame. Jã'ata'ni Dios Rekochoji pãi rekoñoãre care'vakaima'to Repaʉ neena pa'icu'amʉ repanare. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pãi romi jñaasinajejʉ pãia'me mai. Dios Rekochoji pãi rekoñoã care'vacojñosina Repaʉ Rekochoji repanani ja'me pa'iʉna pa'iche re'oja'chere mama pa'ime repana. ");
INSERT INTO coe_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Chʉ'ʉ mʉsanʉkonare, “Chĩiva'ʉ jñaacojñoñeja'ñe jo'e mama jñaacojñojʉ̃'ʉ”, chiisi'e asa tĩiñe cuasamanejʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mʉsanʉkona tutache asanata'ni tutu raichejajẽ'e vesʉjʉ tutu saichejajẽ'e vesʉme. Ũcuaja'che Dios Rekocho cho'oche vesʉme pãi. Pãi rekoñoã care'vakani ja'me pa'imʉ Reparekocho, re'oja'che paapʉ chini —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chikʉna Nicodemo i'kaasomʉ. —Mʉ'ʉ i'kache asavesʉmʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Mʉ'ʉ judíopãi che'chokʉta'ni, ¿je'se pa'iʉna rʉa masiʉta'ni chʉ'ʉ i'kache asavesʉkʉ? ");
INSERT INTO coe_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mʉ'ʉre chʉ'o ũcuarepare ija'che i'kamʉ chʉ'ʉ: Chʉ'ʉ masiche'te i'kakʉ'mʉ chʉ'ʉ. Ũcuachi'a chʉ'ʉ ñasi'ere kʉakʉ'mʉ chʉ'ʉ. Jã'ata'ni asa jachame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chʉ'ʉre icheja cheja pa'iche kʉakʉ'teta'ni asa jachame mʉsanʉkona. Jã'ajekʉna chʉ'ʉpi Dios pa'ichejaqueere kʉato na'a rʉa jachajanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Dios pa'icheja mʉni cajesinajẽ'e peome. Jã'ajekʉna repacheja pa'iche masina peome. Pãire ja'me paaʉ chini Dios Raosi'kʉjekʉ te'eʉ masimʉ chʉ'ʉ, ũcuacheja cajesi'kʉjekʉ. Jã'ajekʉna repacheja pa'iche kʉamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ũcuachi'a iere kʉara: Aperʉmʉ Moisés repaʉ pãi peocheja pa'irʉmʉ cʉnapi añajava'ʉre cho'o vãsochona quẽo sʉo nʉkocheja'che kurususẽ'verona jẽ'jo nʉkojanaa'me pãi chʉ'ʉre Dios Raosi'kʉre. Chʉ'ʉre jã'aja'ñe vanisõjañe ʉ̃semaneja'mʉ Dios, ");
INSERT INTO coe_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pãipi chʉ'ʉre cuasanapi Repaʉ pa'ichejare sani paapʉ chini —chiniasomʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ũcuarʉmʉ Jesús repaʉ'te jo'e ija'che i'kaasomʉ: —Dios pãi ũcuanʉkore rʉa oikʉjekʉ chʉ'ʉre Repaʉ Mamakʉ'te ũcuate'eʉni chejana raosi'kʉa'mʉ, pãipi chʉ'ʉni cuasajʉ vati toa uuma'ñe Repaʉ pa'ichejare ai sani paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pãire, “Mʉsanʉkona cu'ache cho'osi'e ro'ijʉ̃'ʉ”, chiaʉ chini raomanesi'kʉa'mʉ Dios chʉ'ʉre Repaʉ Mamakʉ'te. Pãire vati toa uuche'te ʉ̃sea'kʉ chini raosi'kʉa'mʉ Dios chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Pãi chʉ'ʉre Dios Mamakʉ'te cuasana repana cu'ache cho'osi'e ro'imanejanaa'me. Jã'ata'ni chʉ'ʉre cuasamana repana cu'ache cho'osi'e ro'ijanaa'me, Dios Mamakʉ'te ũcuate'eʉni cuasamanajejʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chʉ'ʉ miañeja'ñe re'oja'che pa'ikʉ pãipi Dios pa'iche masia'jʉ chini chejana raisi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni pãi chijachejaja'che pa'iche'te cu'are na'a rʉa chiijʉ miañeja'ñe re'oja'che pa'iche cuhejʉ cuasama'me chʉ'ʉre. Jã'ajekʉna chʉ'ʉre cuasama'ñe ro'i ro'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Cu'ache pa'ina ũcuanʉko chʉ'ʉre Miañeja'ñe Pa'ikʉ'te raima'me repana cu'ache cho'ojʉ pa'iche'te kʉakʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dios chʉ'o jachamanata'ni cuhema'ñe jovome chʉ'ʉre Miañeja'ñe Pa'ikʉ'te, re'oja'che pa'ijʉna pãipi ña, “Diopi cho'okaiʉna Repaʉ chʉ̃'ʉñe cho'onaa'me ina”, chiapʉ chini —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","I'ka pi'nisirʉmʉ chʉkʉna repaʉ neena Jesuna'me Judea chejare sani jmamakarʉ pa'isinaa'me. Ũcuachejare pa'ijʉ pãire okoro'vesinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Reparʉmʉ Juan Salim cheja kueñe cachejare Enón chejare pa'iʉ pãire okore ro'vekʉ paniasomʉ, chĩichiañaã rʉa pa'ichejajekʉna. Pãi si'arʉmʉ sani okoro'vecojñoasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jã'aja'ñe cho'okʉ paniasomʉ Juan pãi chẽavʉ'e repaʉ'te chuta'a cuaomarʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Reparʉmʉ Juan neenapi judíopãiʉni cu'a tʉnoñe'te cutujʉ ke'reasome. ");
INSERT INTO coe_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jã'aja'ñe cho'ocuha repanare paakʉni Juanni i'kañu chini saniasome repana. —Masiʉ, mʉ'ʉ Jordán chiacha ʉ̃sʉʉ mʉikã'ko pa'irʉmʉ mʉ'ʉre ja'me pa'isi'kʉ, mʉ'ʉ ña i'kasi'kʉ Jesupi pãire okoro'vekʉna pãi jainʉko jovojʉasome repaʉ'te —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chitena Juan i'kaasomʉ. —Pãi ũcuanʉko repana cho'omasiche Dios jo'kasi'ea'me. Jo'kama'to cho'ovesʉra'ame repana. ");
INSERT INTO coe_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ija'che i'kasi'kʉa'mʉ chʉ'ʉ aperʉmʉ: “Dios chʉ'ʉre pãire ũcuanʉkore chʉ̃'ʉa'kʉ chini raomanesi'kʉa'mʉ. Repaʉ Raojaʉ raijachere kʉaa'kʉ chini raosi'kʉa'mʉ Dios chʉ'ʉre”, chiiche asasinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ija'chea'me: Pãiʉ romio'te vejani paamʉ. Paakʉ repaoni pojokʉ i'kato repaʉ'te ja'me pa'ikʉ repaʉ vejarʉmʉ cho'okaisi'kʉpi kueñere nʉkakʉ asani rʉa pojosõmʉ. Ũcuaja'che pãipi Jesuni cuhema'ñe asa jovojʉna rʉa pojosõmʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesuni pãi na'a jainʉko jovoa'jʉ chiimʉ chʉ'ʉ. Chʉ'ʉreta'ni na'a te'eva'na jovoa'jʉ chiimʉ chʉ'ʉ —chiniasomʉ repaʉ Juan Pãi Okoro'vekʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","32","Ũcuarʉmʉ Juan jo'e i'kaasomʉ. —Cʉnaʉmʉ cajesi'kʉ Dios Mamakʉ pãi ũcuanʉkore na'a rʉa masikʉ'mʉ. Pãi icheja cheja jñaacojñosinajejʉ cheja pa'ichechi'a masijʉ i'kame. Cʉnaʉmʉ cajesi'kʉta'ni pãi ũcuanʉkore na'a rʉa masiʉjekʉ cʉnaʉmʉ repaʉ pa'iʉ ñasi'ena'me asasi'e kʉamʉ. Jã'ata'ni pãi jainʉko jachame repaʉ kʉache. ");
INSERT INTO coe_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Repaʉ kʉache jachamanata'ni, “Repaʉ pa'iche'te Dios kʉasi'e ũcuarepaa'me”, chiijʉ cuasame. ");
INSERT INTO coe_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Repaʉ Jesús Dios Raosi'kʉjekʉ Dios chʉ'ore kʉamʉ. Dios Repaʉ Mamakʉ'te Jesure Repaʉ Rekocho'te ʉ̃sema'ñe ĩsisi'kʉa'mʉ, ũcuaʉni si'arʉmʉ ja'me pa'iʉ peore re'oja'che cho'okaaʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mai Ja'kʉ Dios Repaʉ Mamakʉ'te chiimʉ. Peore paakʉ chʉ̃'ʉa'kʉ chini ũcuaʉni jo'kaasomʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dios Mamakʉ'te cuasana repana jũnisõsirʉmʉ Dios pa'ichejare ai sani pa'ijanaa'me. Dios Mamakʉ'te cuasamanata'ni Repaʉ pa'icheja saima'ñe Diopi chʉ̃'ʉʉna si'arʉmʉ uujʉ pa'ijanaa'me repana —chiniasomʉ Juan Pãi Okoro'vekʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ũcuarʉmʉ ija'che cutuasome pãi: “Pãi jainʉko repaʉ neena pañu chini Juanre jovo okoro'vecojñome. Jã'ata'ni Jesuni na'a jainʉko pãi jovo okoro'vecojñome, repaʉ neena pañu chini”, chiniasome. Pãi okoro'vemanesi'kʉa'mʉ Jesús. Chʉkʉna repaʉ neenata'ni pãi okoro'vesinaa'me. Ũcuarʉmʉ repaʉ Jesús, “Pãipi rʉa cutujʉna asa fariseopãi chʉ'ʉ cho'oche masime”, chini Judea cheja pa'ikʉji, “Galilea chejana co'iñu”, chiisi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria chejapi caraiche pa'isi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Saijʉ Samaria cheja cajoopo Sicar vʉ'ejoopona tĩ'asinaa'me chʉkʉna. Aperʉmʉ Jacob repaʉ mamakʉ'te Josere repajoopo kueñe cachejare cheja jo'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ũcuachejare oko eacoje pa'imʉ, “Jacob ũhisicojea'me”, chiicojñocoje. Ũcuarʉmʉ Jesús ku'iʉ ca'nasõ repacoje rʉ'tʉvana pʉʉsi'kʉa'mʉ. Nʉkarepaʉ pa'icosomʉ reparʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chʉkʉna repaʉ neena ãure kooñu chini vʉ'ejoopona saisinaa'me. Chʉkʉna saisirʉmʉ Samariapãio okore eara chini oko eacojena rani tĩ'aona Jesús ija'che i'kaasomʉ repao'te: —Oko ũkuajʉ̃'ʉ chʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chikʉna i'kaasomo repao. —¿Je'se pa'iʉna mʉ'ʉ chʉ'ʉre Samariapãioni judíopãiʉji okore sẽekʉ? Tĩiñe cho'omʉ mʉ'ʉ —chiniasomo repao. (Judíopãipi Samariapãire cutucuheme. Jã'ajekʉna repaʉ i'kache'te asa jñano jã'aja'ñe i'kaasomo repao.) ");
INSERT INTO coe_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chikona i'kaasomʉ repaʉ. —Dios ĩsira chiichena'me chʉ'ʉ mʉ'ʉre oko sẽesi'kʉ pa'iche masini sẽera'amo mʉ'ʉ chʉ'ʉre. Sẽeto mʉ'ʉ rekocho ũku vajʉche'te oko ũkuara'amʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chikʉna i'kaasomo repao. —Rʉa rʉimʉ icoje. ¿Ʉ̃quepi eaja'ʉ mʉ'ʉ? ¿Jeechejare chʉ'ʉ rekocho ũku vajʉche oko eaja'ʉ mʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mai aipãiʉ Jacobpi jo'kaasomʉ icoje maire oko ũkure'oche pa'icoje. Repaʉna'me repaʉ mamachĩina'me repaʉ jo'chava'na ũkuasome icoje pa'iche oko. ¿Icoje pa'iche oko na'a rʉa re'oja'chere ũkuaja'ʉ mʉ'ʉ chʉ'ʉre? ¿Repaʉ'te na'a rʉa masikʉ mʉ'ʉ? —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chikona i'kaasomʉ repaʉ. —Icoje pa'iche oko ũkusinare jo'e okoʉaja'mʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jã'ata'ni chʉ'ʉ ũkuache'te oko ũkunare jo'e okoʉamaneja'mʉ. Chʉ'ʉ ũkuache'te oko ũkuna oko puniʉ si'ama'ñe oko raicheja'che repana rekoñoã si'arʉmʉ re'oja'che pa'ijanaa'me —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chikʉna i'kaasomo repao. —Mʉ'ʉ i'kache'te oko ũkuajʉ̃'ʉ chʉ'ʉre, jo'e chʉ'ʉni okoʉamanea'kʉ, icoje rani jo'e oko eache peoa'kʉ chʉ'ʉre —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chikona i'kaasomʉ repaʉ. —Mʉʉ̃jʉre soijani ichejana rajʉ̃'ʉ —chiniasomʉ repaʉ repao'te. ");
INSERT INTO coe_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Chikʉna i'kaasomo repao. —Ʉmʉ peoko'mo chʉ'ʉ —chiniasomo. Chikona i'kaasomʉ repaʉ. —Cincorepanare ʉmʉpãi veja panicuhasi'koa'mo mʉ'ʉ. Chura chekʉre mʉʉ̃jʉma'kʉni pa'imo mʉ'ʉ. Jã'ajekʉna, “Ʉmʉ peoko'mo chʉ'ʉ”, chini chʉ'o ũcuarepare i'kasi'koa'mo mʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","I'kaʉna asa i'kaasomo repao. —Dios chʉ'o kʉakʉcosomʉ mʉ'ʉ. Chʉkʉna aipãi pa'isina ikũtina mʉni Dioni pojoñu chini ro're ñuniasome. Mʉsanʉkona judíopãita'ni ija'che i'kanaa'me: “Jerusalén vʉ'ejoopona sani Diore pojoche pa'imʉ maire”, chiinaa'me mʉsanʉkona —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chikona i'kaasomʉ repaʉ. —Chʉ'ʉ i'kache jachama'ñe cuasajʉ̃'ʉ mʉ'ʉ. Na'a pa'isirʉmʉ pãi ũcuanʉko Pʉka'kʉre Diore pojoñu chiina ikũti mʉimanejanaa'me. Ũcuachi'a Jerusalén vʉ'ejoopo saimanejanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉsanʉkona Samariapãi mʉsanʉkona pojokʉ pa'iche vesʉme. Chʉkʉna judíopãita'ni chʉkʉna pojokʉ pa'iche masime, vati toa uuche Ʉ̃sekaikʉji Dios Raosi'kʉpi judíopãiʉjekʉna. ");
INSERT INTO coe_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pãi Dios chʉ'o jachama'ñe repana rekoñoã Repaʉ'te masirepa pojorʉmʉ tĩ'aja'mʉ. Chura reparʉmʉ tĩ'acuhamʉ. Jã'aja'ñe cho'ojʉ paapʉ pãi chiimʉ Repaʉ Dios. ");
INSERT INTO coe_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios ca'nivʉjẽ'e peokʉjekʉ ñoma'kʉa'mʉ. Pãipi Repaʉ chʉ'ore jachama'ñe rekoñoãpi Repaʉni masi cuasajʉ pojoa'jʉ chiimʉ Dios —chiniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chikʉna i'kaasomo repao. —Iere masiko'mo chʉ'ʉ: Mesías, pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Dios Raojaʉ raija'mʉ. Rani maire peore che'choja'mʉ —chiniasomo repao. (“Mesías” chini “Cristo” chiimʉ griego chʉ'o.) ");
INSERT INTO coe_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chikona i'kaasomʉ repaʉ. —Chʉ'ʉ mʉ'ʉre i'kakʉ ũcuaʉ'mʉ —chiniasomʉ repaʉ repao'te. ");
INSERT INTO coe_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ũcuarʉmʉ chʉkʉna repaʉ neena tĩ'a Jesupi romiona'me cutukʉna ña jñanosinaa'me. Jã'ata'ni, “¿Je'se pa'iʉna ikore i'kakʉ mʉ'ʉ? ¿Ʉ̃quere mʉsanʉkona cutuche?”, chiimanesinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ũcuarʉmʉ repao oko eapʉ ũcuachejana jo'ka vʉ'ejoopona sani pãire ija'che i'kaasomo: ");
INSERT INTO coe_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Chʉ'ʉ pa'io cho'osi'e ñamanesi'kʉta'ni peore masikʉ kʉasi'kʉre ñajañu. Dios Raosi'kʉcosomʉ repaʉ —chiniasomo repao repanare. ");
INSERT INTO coe_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chikona asa vʉ'ejoopo eta chʉkʉna pa'ichejana raisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Repana chuta'a tĩ'amarʉmʉ chʉkʉna Jesús neena rʉa i'kasinaa'me repaʉ'te. —Masiʉ, ãu ãijʉ̃'ʉ —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Chitena i'kasi'kʉa'mʉ repaʉ. —Ãu paamʉ chʉ'ʉ, mʉsanʉkona vesʉche'te —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chikʉna sãiñechi'a cutusinaa'me chʉkʉna repaʉ neena. —¿Chekʉnapi ãu ra ãure ikʉre? —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chʉkʉna cutuche masikʉ i'kasi'kʉa'mʉ repaʉ. —Ãu chʉ'ʉ paache'me ie: Chʉ'ʉ ãu ãiñe chiicheja'che chʉ'ʉre Raosi'kʉ chʉ̃'ʉ jo'kasi'e cho'o pi'nira chiimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mʉsanʉkona ija'che i'kanaa'me: “Ũcuaka'chapapãimia pani tʉare'omʉ trigo”, chiinaa'me. Ija'che kʉamʉ chʉ'ʉ mʉsanʉkonare: Jã'anare pãi, chʉ'ʉre rainare ñajʉ̃'ʉ. Trigo re'ocheja'che pa'imʉ repana rekoñoã. Irʉmʉ chʉ'ʉ chʉ'o asa chẽare'omʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Chekʉrʉmʉ pãiʉji Dios chʉ'o chʉ'vakʉna asanata'ni jachame pãi. Na'a pa'isirʉmʉ chekʉpi ũcuanani chʉ'vakʉna Dioni cuasajʉ jũnisõsirʉmʉ Dios pa'ichejare sani pa'ijanaa'me. Jã'aja'ñe cho'oru pojosõjanaa'me repanare chʉ'vasina charo chʉ'vasi'kʉna'me cho'je chʉ'vasi'kʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aperʉmʉ pãi ija'che i'kaasome: “Pãiʉ trigo tãʉna ainee rʉa pa'iʉna chekʉpi tʉakaimʉ”, chiniasome repana. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jã'aja'ñe pa'imʉ Dios chʉ'o chʉ'vache. Ija'chea'me: Mʉsanʉkonare saomʉ chʉ'ʉ, Dios chʉ'ore chʉ'vajʉna pãipi asa chẽa Repaʉni cuasaa'jʉ chini. Dios chʉ'o asa chẽamanesinani chʉ'vajanaa'me mʉsanʉkona. Repanare aperʉmʉ chʉ'vasina chʉ'vasi'eja'chere ũcuare jo'e mʉsanʉkonapi chʉ'vajʉna asa chẽa Diore cuasajanaa'me repana churata'ni, chiimʉ chʉ'ʉ —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ũcuarʉmʉ repajoopo cana rʉa jainʉko, repaoji, “Chʉ'ʉ pa'io cho'osi'e ñamanesi'kʉta'ni peore masikʉ kʉasi'kʉa'mʉ”, chikona asa Jesure cuasajʉ jovosinaa'me, “Dios Raosi'kʉa'mʉ repaʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jã'ajekʉna Samariapãi Jesuni tĩ'a i'kasinaa'me, repaʉji saima'ñe repanana'me paaʉ chini. I'karena ka'chaumucujña repanare ja'me pa'isi'kʉa'mʉ repaʉ, chʉkʉnana'me. ");
INSERT INTO coe_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ũcuaʉji Jesupi i'kaʉna asa na'a jainʉko pãi cuasajʉ jovosinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ũcuarʉmʉ romio'te i'kasinaa'me repana. —Chura mʉ'ʉ kʉasi'echi'a asa cuasama'me chʉkʉna. Ũcuaʉ i'kache asasinajejʉ cuasame chʉkʉna repaʉ'te. “Dios Raosi'kʉa'mʉ ikʉ. Maire si'achejña pa'inare vati toa uuche Ʉ̃sekʉ'mʉ”, chini masijʉ cuasame chʉkʉna repaʉ'te —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka'chaumucujña pa'isirʉmʉna Jesús Samaria cheja pa'isi'kʉpi eta jo'e kuniasomʉ Galilea chejana sasa chini. ");
INSERT INTO coe_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Repaʉ Jesús si'arʉmʉ ija'che i'kasi'kʉa'mʉ: “Dios chʉ'o kʉana aineesijoopoã cana pãi repana kʉache Dios chʉ'o asa jachame”, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jã'ata'ni Galilea cheja sani apetĩ'asirʉmʉ repacheja cana ña pojoasome repaʉ'te, pascuarʉmʉna Jerusalén vʉ'ejoopona sani repaʉ rʉa masi cho'oche peore ñasinajejʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ũcuarʉmʉ Jesús repaʉ okopi pĩsi ʉche cono carʉñosijoopo jo'e co'iasomʉ, Galilea cheja cajoopo Caná vʉ'ejoopona. Ũcuarʉmʉ chekʉjoopo Capernaum vʉ'ejoopo cakʉ, pãi chʉ̃'ʉkʉ'te cho'oche cho'okaikʉ mamakʉ ravʉ jũ'iva'ʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judea chejapi Galilea chejana Jesús raisi'e asaasomʉ repaʉ. Asa, repaʉ mamakʉji jũnisõpi'rakʉna Jesús pa'ichejana sani rʉa i'kaasomʉ repaʉ, Jesupi repaʉ vʉ'ena sani mamakʉni vasokaaʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sẽeʉna Jesús i'kaasomʉ. —Diochi'a cho'omasiche'te chʉ'ʉ cho'o ñoma'to cuasamanera'ame mʉsanʉkona chʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chikʉna i'kaasomʉ repaʉ. —Chʉ'ʉre paakʉ, pesa sañu. Chʉ'ʉ chĩi jũnisõcuhaja'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chikʉna i'kaasomʉ repaʉ. —Mʉ'ʉ vʉ'ena co'ijʉ̃'ʉ. Mʉ'ʉ chĩi vajʉcuhasi'kʉa'mʉ —chiniasomʉ repaʉ. Jesús i'kasi'e jachama'ñe cuasa repaʉ vʉ'ena co'iasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Co'iʉna repaʉ'te cho'oche cho'okaina eta tijña kʉaasome repaʉ'te. —Mʉ'ʉ chĩi vajʉcuhasi'kʉa'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jã'aja'ñe kʉarena, “¿Keerʉmʉna repava'ʉ vajʉʉ?”, chiniasomʉ repaʉ. Chikʉna i'kaasome repana. —Neato una pa'ito cha'voche chʉrʉsi'kʉa'mʉ repaʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chitena asa ũcuajarʉmʉna Jesús, “Mʉ'ʉ chĩi vajʉcuhasi'kʉa'mʉ”, chiisi'ere cuasaasomʉ repaʉ. Ũcuarʉmʉ Jesuni cuasakʉ jovoasomʉ repaʉ majapãina'me repaʉ'te cho'oche cho'okaina. ");
INSERT INTO coe_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jã'ana'me te'eka'chapañoã cho'o ñocuhamʉ Jesús Diochi'a cho'omasiche, repaʉ Judea chejapi Galilea cheja saisirʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na'a pa'isirʉmʉ judíopãipi Jerusalén vʉ'ejoopona fiesta cho'ojʉna ũcuajoopona jo'e maniasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Repajoopo kakasa'aro “Ovejasa'aro” chiicojñosa'aro kueñere okoruruvʉ pa'isi'kʉa'mʉ. Reparuruvʉ mami hebreo chʉ'o “Betzata” chiimʉ. Reparuruvʉ rʉ'tʉva'te vʉ'ñarʉã cincorepavʉ'ñarʉã jeomavʉ'ñarʉã pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Angel cʉnaʉmʉ pa'ikʉji te'eñoã ũcuaruruvʉna caje chʉ̃'ʉkʉna fa'aasomʉ oko reparuruvʉ pa'iche. Fa'akʉna ravʉ jũ'ikʉ charo vani kakasi'kʉpi vajʉasomʉ. Jã'ajekʉna pãi jũ'ina jainʉko ũcuavʉ'ñarʉãre cha'ajʉ ũhisinaa'me, na'ava'na ro'ova'nana'me nʉka ku'imava'na. ");
INSERT INTO coe_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te'eʉ repanare ja'me ũhikʉ treinta y ochorepaʉ̃sʉrʉmʉ jũ'iva'ʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ũcuarʉmʉ Jesús repaʉ'te ña, repaʉ jeerʉmʉ jũ'iñe'te masikʉ ija'che i'kaasomʉ repaʉ'te: —¿Vajʉra chiikʉ mʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chikʉna i'kaasomʉ jũ'ikʉ. —Repa oko fa'arʉmʉ casokʉjẽ'e peomʉ chʉ'ʉre. Jã'ajekʉna repa oko fa'akʉna vani kaka vajʉra chiikʉ'teta'ni chekʉnapi si'arʉmʉ charo vani kakame —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chikʉna Jesús i'kaasomʉ repaʉ'te. —Vʉni mʉ'ʉ kãikãa mini saijʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesupi i'kaʉna teana vajʉ vʉni repaʉ kãikãa mini saniasomʉ repaʉ. Pʉaumucuse paniasomʉ repaʉ vajʉsiumucuse. ");
INSERT INTO coe_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Repaʉ kãikãa mini kuãa saiʉna ña judíopãi chʉ̃'ʉna i'kaasome. —Pʉaumucusea'me iumucuse. Mʉ'ʉ kãikãare mini saiʉ cu'ache cho'omʉ mʉ'ʉ. Mai aipãi chʉ̃'ʉ jo'kasi'e pʉaumucuse jã'aja'ñe cho'oche ʉ̃semʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chitena i'kaasomʉ repaʉ. —Chʉ'ʉre vasosi'kʉ, “Mʉ'ʉ kãikãa mini saijʉ̃'ʉ”, chiisi'kʉa'mʉ chʉ'ʉre —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chikʉna i'kaasome repana. —Mʉ'ʉre, “Mʉ'ʉ kãikãa mini saijʉ̃'ʉ”, chiisi'kʉ, ¿kaʉa'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sẽeto repaʉ'te vasosi'kʉre vesʉasomʉ repaʉ, pãipi jairepanʉko pa'ijʉna Jesupi ñoma'ñe sanisõʉna. ");
INSERT INTO coe_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na'a pa'isirʉmʉ Jesús Dios vʉ'ere pa'iʉ repaʉ vasosi'kʉre jo'e tijña i'kaasomʉ. —Chura vajʉmʉ mʉ'ʉ. Cu'ache cho'oche ũhasõjʉ̃'ʉ, mʉ'ʉni na'a rʉa cu'ache ti'jñemanea'kʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chikʉna sani judíopãi chʉ̃'ʉnare kʉaasomʉ repaʉ, “Jesupi chʉ'ʉre vasosi'kʉa'mʉ”, chiiʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesupi pʉaumucusena jũ'ikʉni vasoʉna judíopãi chʉ̃'ʉna repaʉ'te cu'ache i'kajʉ vanisõñu chiniasome. ");
INSERT INTO coe_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Repaʉ'te cu'ache i'kajʉna ija'che i'kaasomʉ repaʉ: —Chʉ'ʉ Ja'kʉ si'arʉmʉ pãi re'oja'che cho'okaiʉ pa'ikʉ'mʉ. Jã'ajekʉna chʉ'ʉ ũcuaja'che pãi re'oja'che cho'okaikʉ'mʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesupi pʉaumucusena pãiʉ'te vasosi'kʉpi, “Dios chʉ'ʉ Ja'kʉa'mʉ”, chikʉna asa, “ ‘Dios pa'icheja'che pa'ikʉ'mʉ chʉ'ʉ’, chini cuasacosomʉ ikʉ”, chini pe'rujʉ repaʉ'te na'a rʉa vanisõñu chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Reparʉmʉ Jesús i'kaasomʉ repanare. —Chʉ'ʉ Dios Mamakʉ chʉ'ʉchi'a te'eʉ cuasakʉ cho'oma'mʉ. Chʉ'ʉ Ja'kʉ cho'oche'te ñakʉ ũcuare cho'okʉ'mʉ chʉ'ʉ. Chʉ'ʉ Ja'kʉ cho'ocheja'che cho'okʉ'mʉ chʉ'ʉ Repaʉ Mamakʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja'kʉ chʉ'ʉre rʉa chiimʉ. Repaʉ cho'oche peore ñomʉ chʉ'ʉre. Na'a rʉa masiche ñoja'mʉ Repaʉ chʉ'ʉre. Ñoʉna chʉ'ʉpi ũcuare cho'okʉna ña jñanojanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ja'kʉ jũnisõsinare vasokʉ'mʉ vajʉa'jʉ chini. Chʉ'ʉ Repaʉ Mamakʉ ũcuaja'che chʉ'ʉre ʉanare vasokʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Chʉ'ʉ Ja'kʉ, “Mʉsanʉkonare pãi cu'ache cho'osi'e ro'iche pa'imʉ”, chiimaneja'mʉ. Chʉ'ʉpi jã'aja'ñe cho'oa'kʉ chini jo'kasi'kʉa'mʉ Ja'kʉ chʉ'ʉre, pãipi Repaʉ'te cuasa, vajʉchʉcheja'che chʉ'ʉni ña, vajʉchʉa'jʉ chini. Chʉ'ʉre Dios Mamakʉ'te ña, vajʉchʉmana chʉ'ʉre Raosi'kʉre Ja'kʉre ũcuaja'che cuasa, vajʉchʉma'me. ");
INSERT INTO coe_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Pãi ũcuaʉana chʉ'ʉ i'kache asa jachama'ñe Dios chʉ'ʉre Raosi'kʉre cuasani, pa'iche re'oja'chere pa'ijʉ repana jũnisõsirʉmʉ Dios pa'ichejana ai sani si'arʉmʉ pa'ijanaa'me. Cu'ache cho'osi'e ro'iche peomʉ repanare. Vati toa saira'asinaa'me repana Diore cuasamana pani. Diore cuasanajejʉ re'ojachejana saijanaa'me repana Dios pa'ichejana. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pãi Diore cuasamana jũnisõsinaja'ñe pa'ime. Jã'ata'ni chʉ'ʉpi Dios Mamakʉji chʉ'vakʉna asa pãi ũcuaʉana cuasani jũni vajʉraisina pa'icheja'che, pa'iche re'oja'chere pa'ijanaa'me. Na'a pa'isirʉmʉ ti'jñeja'mʉ chʉ'ʉ i'kasi'e. Chura tijñacuhamʉ repa. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ja'kʉchi'a pa'iche re'oja'chere ĩsikʉ'mʉ. Jã'aja'ñe cho'oche Ja'kʉ chʉ'ʉni Repaʉ Mamakʉni jo'kasi'kʉa'mʉ ũcuaja'che ĩsia'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chʉ'ʉre Dios Raosi'kʉjekʉna cu'ache cho'onare pãi, “Mʉsanʉkona cu'ache cho'osi'e ro'i ro'iche pa'imʉ”, chiichena'me cu'ache cho'oche ũhasinare, “Ro'iche peomʉ mʉsanʉkonare”, chiiche jo'kasi'kʉa'mʉ Ja'kʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Chʉ'ʉ i'kache asa, kʉkʉmanejʉ̃'ʉ mʉsanʉkona. Na'a pa'isirʉmʉ pãi jũ'isina ũcuanʉko chʉ'ʉpi soito asa vajʉraijanaa'me. Re'oja'che pa'isina vajʉrani Diona'me si'arʉmʉ pa'ijʉ pa'ijanaa'me. Cu'ache pa'isinata'ni vajʉrani uujʉ pa'ijanaa'me —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ũcuarʉmʉ Jesús jo'e ija'chere i'kaasomʉ: —Chʉ'ʉchi'a te'eʉ cuasakʉ cho'oma'mʉ chʉ'ʉ. Pãi cho'oche ñani chʉ'ʉ cuasache i'kama'kʉa'mʉ. Chʉ'ʉ Ja'kʉpi chʉ̃'ʉkʉna asakʉ ũcuare i'kakʉ'mʉ. Chʉ'ʉ chiichechi'a i'kama'kʉjekʉ ũcuarepa i'kakʉ'mʉ chʉ'ʉ. Pãi repana cu'ache cho'osi'e ro'ichi'a ro'iche chʉ̃'ʉmʉ chʉ'ʉ. Chʉ'ʉre Raosi'kʉ Ja'kʉ chiichechi'a i'kakʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chʉ'ʉ pa'iche'te chʉ'ʉpi meñe kʉato pãipi asa, “Joreʉ'mʉ mʉ'ʉ”, chiira'acosome. ");
INSERT INTO coe_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jã'ata'ni chekʉpi chʉ'ʉ pa'iche'te kʉamʉ. Repaʉ kʉache ũcuarepaa'me. Jã'are masimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉsanʉkonapi chekʉnare Juan pa'ichejana saoasome, chʉ'ʉ pa'iche'te sẽniasaa'jʉ chini. Sẽeto chʉ'o ũcuarepare kʉasi'kʉa'mʉ Juan. ");
INSERT INTO coe_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Dios Raosi'kʉa'mʉ mʉ'ʉ”, chiinare ku'ema'mʉ chʉ'ʉ. Jã'ata'ni, chʉ'ʉ pa'iche'te Juan kʉasi'ere cuasajʉ̃'ʉ mʉsanʉkona, chiimʉ chʉ'ʉ, mʉsanʉkonapi asa chẽa chʉ'ʉni cuasajʉ vati toana sani uumanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ʉopʉ rʉa miañeja'ñe re'oja'che che'chosi'kʉa'mʉ Juan. Repaʉ apeche'chorʉmʉchi'a asa pojosinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juanpi kʉaʉna chʉ'ʉ pa'iche masime pãi. Rʉa re'oja'imʉ jã'a. Jã'ata'ni pãipi chʉ'ʉre Ja'kʉ raosi'ere masia'jʉ chini na'a ña masire'oche cho'omʉ chʉ'ʉ ie: Chʉ'ʉpi cho'o pi'nia'kʉ chini Ja'kʉ chʉ̃'ʉ jo'kasi'ere cho'okʉna ña chʉ'ʉre Ja'kʉ raosi'e masijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pãipi chʉ'ʉ pa'iche'te tocha jo'kaa'jʉ chini chʉ̃'ʉsi'kʉa'mʉ Ja'kʉ, chʉ'ʉre Raosi'kʉ. Repaʉ i'kachejẽ'e asamanaa'me mʉsanʉkona. Ũcuachi'a Repaʉ'terejẽ'e ñamanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Chʉ'ʉ Repaʉ Raosi'kʉ kʉache asa jachanajejʉ Dios chʉ'o asa chẽama'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ija'che cuasame mʉsanʉkona: “Dios chʉ'o tocha jo'kasi'ere che'cheni Dios pa'icheja saiche masijanaa'me mai”, chini cuasajʉ rʉa che'cheme mʉsanʉkona. Repa tocha jo'kasi'e chʉ'ʉ pa'iche'te kʉamʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jã'ata'ni mʉsanʉkona chʉ'ʉre cuheme. Chʉ'ʉni cuasajʉ jovoni pa'iche re'oja'chere pa'ijʉ jũnisõsirʉmʉ Dios pa'ichejana saira'ame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Pãi chʉ'ʉ cho'oche cuasa ña, “Peore masikʉ'mʉ Jesús”, chiina peoto karama'mʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉsanʉkona pa'iche masimʉ chʉ'ʉ. Diore chiima'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ja'kʉpi raoʉna chejare caje pa'iʉ che'chokʉ'teta'ni jachame mʉsanʉkona chʉ'ʉre. Chekʉpi Dios raocojñomanesi'kʉpi rani repaʉ cuasache'te che'chotota'ni asa jachamanera'ame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Dios Ũcuate'eʉji ña pojoa'kʉ, re'oja'che cho'oñu mai”, chiima'me mʉsanʉkona. Pãichi'a ña pojoa'jʉ chini, “Re'oja'che cho'oñu”, chiinaa'me mʉsanʉkona. Jã'aja'ñe cuasanajejʉ mʉsanʉkona chʉ'ʉre cuasamanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ija'che cuasame mʉsanʉkona: “Mai Moisés chʉ̃'ʉ jo'kasi'ere cho'oni jũnisõsirʉmʉ Dios pa'ichejana ai sani pa'ijanaa'me”, chiime mʉsanʉkona. Jã'ata'ni repaʉ Moisés mʉsanʉkonare, “Cu'ache pa'isinaa'me ina”, chiija'mʉ chʉ'ʉ Ja'kʉre. Jã'ajekʉna chʉ'ʉ jã'aja'ñe i'kamaneja'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chʉ'ʉ pa'ijache Moisés aperʉmʉ tocha jo'kasi'kʉa'mʉ. Repaʉ tocha jo'kasi'e jachama'ñe cuasani chʉ'ʉ i'kache ũcuaja'che jachama'ñe cuasara'ame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Repaʉ tocha jo'kasi'e jachanajejʉ chʉ'ʉ i'kache jachame mʉsanʉkona —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na'a pa'isirʉmʉ Jesús Galilea chiara chekʉkã'kona jẽ'esi'kʉa'mʉ. Repara chiara mami cheke Tiberiaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesupi Diochi'a cho'omasiche'te jũ'inani vasokʉna pãi jainʉko tuhasinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ũcuarʉmʉ chʉkʉna Jesús neena ũcuaʉna'me aikũtina mʉni pʉʉsinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Reparʉmʉ judíopãi fiesta pascuarʉmʉ tĩ'api'rasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pãipi jairepanʉko repaʉni raijʉna ña Felipeni ija'che i'kasi'kʉa'mʉ repaʉ Jesús: —¿Jeechejana ãu koojanaa'ñe mai inare ũcuanʉkore ãujañe? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús repaʉ cho'ojache masikʉta'ni Felipe i'kache'te asara chini sẽesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Sẽkʉna Felipe i'kasi'kʉa'mʉ. —Maipi kurire're denariore're doscientorepare'repi pãre koo ãuto ũcuanʉkore tĩ'amanera'amʉ ãu inare —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ũcuarʉmʉ chekʉ Jesús neekʉ, Simón Pedro cho'jeʉ Andrés ija'che i'kasi'kʉa'mʉ: ");
INSERT INTO coe_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Icheja chĩiva'ʉ pãpʉã cebadaji cho'osipʉã cincorepapʉã chiacha va'i ka'chava'nare paava'ʉ pa'imʉ. Jã'ata'ni inani pãire ãuñu chini chĩiva'ʉ paache'te maipi kooto tĩ'ama'mʉ. Jairepanʉkoa'me ina —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chikʉna i'kasi'kʉa'mʉ Jesús. —Inare pãi ũcuanʉkore chʉ̃'ʉjʉ̃'ʉ pʉʉa'jʉ —chiisi'kʉa'mʉ chʉkʉna'te repaʉ neenare. Chikʉna chʉ̃'ʉrena pʉʉsinaa'me repana pãi. Pãi cinco milrepana na'a jainʉko pa'icosome, ʉmʉpãichi'a kuẽkueto. Repacheja rʉa patu pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pʉʉsirʉmʉ repaʉ Jesús chĩiva'ʉ paache pã sẽni koo cãjikʉ Diore, “Re'orepamʉ”, chiisi'kʉa'mʉ. Chini chʉkʉnani repaʉ neenani ĩsiʉna repanare pãi ũcuanʉkore ãusinaa'me chʉkʉna. Va'iva'nare sẽni koo ũcuaja'che cho'osi'kʉa'mʉ repaʉ. Repanare ãiʉachetʉ'ka ãisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pãi ũcuanʉko ãni chajirena i'kasi'kʉa'mʉ Jesús chʉkʉna'te. —Cajejaisimajñarʉã siajʉ̃'ʉ, jmamakarʉjẽ'e cho'osõmanea'kʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chikʉna cebada pã pãi ãijʉna cajejaisi'e docerepajʉ'ña sia timusinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Diochi'a cho'omasiche'te Jesupi cho'oʉna ña ija'che i'kasinaa'me repana pãi: —“Diopi Repaʉ chʉ'o Kʉajaʉre raoja'mʉ”, chiijʉ cha'anaa'me mai. Ũcuaʉcosomʉ ikʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Repanani chʉ̃'ʉa'kʉ chini repaʉ'te chẽa sañu chiijʉna masikʉ cuhekʉ aikũtina jo'e te'eʉ mʉisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Na'isõsirʉmʉ chʉkʉna Jesús neena chiarana caje choovʉna tuhisinaa'me, Capernaum vʉ'ejoopona jẽñu chini. Chijanisõcuhasi'eta'ni repaʉ Jesús aikũti mʉisi'kʉ chuta'a cajemanesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ũcuarʉmʉ jẽ'ejʉna churata'ni rʉa tutakʉ rʉa fa'asi'kʉa'mʉ chiara. ");
INSERT INTO coe_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco kilómetros chekʉrʉmʉ seis kilómetros jẽ'enapi Jesure chiara sẽ'sevʉji nʉka ku'iʉ choovʉ kueñe tĩ'akʉni ña rʉa kʉkʉsõsinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Vajʉchʉjʉna i'kasi'kʉa'mʉ repaʉ. —Vajʉchʉmanejʉ̃'ʉ chʉ'ʉre. Jesua'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chikʉna asa, “Ũcuaʉ'mʉ”, chini masijʉ pojojʉ choovʉ tuhiche ʉ̃semanesinaa'me chʉkʉna repaʉ'te. Repaʉ tuhisirʉmʉ chʉkʉna saichejana teana tĩ'asinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jo'e apeñatato repana pãi chiara jẽ'ema'ñe canʉkasina ija'che cuasaasome: “Neato icheja ju'isi'vʉ choovʉ ũcuate'evʉ'te Jesús neena chiara chekʉkã'kona jẽnisõsinaa'me. Jesuta'ni ja'me tuni jẽ'emanesi'kʉa'mʉ”, chini cuasaasome repana. ");
INSERT INTO coe_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ũcuarʉmʉ pãi choovʉãpi Tiberias vʉ'ejoopo raisina rani tĩ'a jʉoasome. Jesús pã cãjikʉ Diore, “Re'orepamʉ”, chini ãukʉna ãisicheja kueñe paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Repacheja Jesupi peokʉna chʉkʉna repaʉ neenajẽ'e peojʉna choovʉãpi jo'e tuni Capernaum vʉ'ejoopona jẽniasome repana repaʉni ku'eñu chini. ");
INSERT INTO coe_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Repana pãi chiara chekʉkã'ko jẽni tĩ'a Jesure ku'e jñaa sẽesinaa'me. —Masiʉ, mʉ'ʉ, ¿jeerʉmʉ icheja jẽkʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉpi Diochi'a te'eʉ cho'omasiche'te cho'okʉna ña, “Dios Raosi'kʉa'mʉ mʉ'ʉ”, chiima'me mʉsanʉkona chʉ'ʉre. Rupʉ chʉ'ʉ ãuñe pã chajiche ãisinajejʉ ku'eme mʉsanʉkona chʉ'ʉre. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉsanʉkona ãu koochechi'a cuasamanejʉ̃'ʉ. Repa ãu si'asõja'mʉ. Chʉ'ʉ Dios Raosi'kʉ ĩsicheta'ni si'ama'ñea'me. Jã'are cuasajʉ̃'ʉ. Chʉ'ʉ ĩsiche'te kooni Dios pa'ichejare ai sani pa'ijanaa'me mʉsanʉkona. Jã'are chʉ'ʉpi ĩsia'kʉ chini chʉ'ʉ Ja'kʉ Dios chʉ'ʉni chiiʉ jo'kasi'kʉa'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chikʉna sẽesinaa'me repana. —¿Je'se cho'ojanaa'ñe chʉkʉna, Dios chʉ̃'ʉñe'te cho'oñu chini? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chitena i'kasi'kʉa'mʉ repaʉ. —Iea'me Dios chʉ̃'ʉñe: Repaʉ Raosi'kʉni cuasajʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chikʉna i'kasinaa'me repana. —Mʉ'ʉpi Diochi'a te'eʉ cho'omasiche'te cho'o ñoru, “Dios Raosi'kʉa'mʉ mʉ'ʉ”, chiijanaa'me chʉkʉna. ¿Ʉ̃quere cho'o ñoja'ʉ mʉ'ʉ? ");
INSERT INTO coe_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mai aipãi pãi peocheja pa'irʉmʉ manacaã ãniasome. Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Dios repanapi ãapʉ chini ãu cʉnaʉmʉpi ĩsisi'kʉa'mʉ, chiimʉ repa tocha jo'kasi'e —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chitena Jesús ija'che i'kasi'kʉa'mʉ: —Moisema'mʉ cʉnaʉmʉpi ãu ĩsisi'kʉ. Chʉ'ʉ Ja'kʉa'mʉ cʉnaʉmʉpi ãurepa ĩsikʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ãu Dios ĩsisi'e cʉnaʉmʉ casosi'ea'me. Pãipi repa ãu ãni pa'iche re'oja'chere pa'ijanaa'me. Ũcuaja'che cʉnaʉmʉpi Dios Raosi'kʉre chʉ'ʉni cuasa vajʉjʉ pa'iche re'oja'chere pa'ijanaa'me pãi —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chikʉna i'kasinaa'me repana. —Chʉkʉna'te Paakʉ, ũcuare ãu si'arʉmʉ ĩsikʉ pa'ijʉ̃'ʉ chʉkʉna'te —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chitena i'kasi'kʉa'mʉ repaʉ. —Ãu ãni re'oja'che pa'icheja'che chʉ'ʉpi jo'kaʉna chʉ'ʉre cuasana jũnisõsirʉmʉ Dios pa'ichejana ai sani re'oja'che pa'ijʉ pa'ijanaa'me. Pãi ãu ãisinare jo'e ãucuhaja'mʉ repanare. Ũcuachi'a pãi oko ũkusinare jo'e okoʉaja'mʉ. Na'a pa'isirʉmʉ jo'e ãuna'me oko chiijanaa'me repana. Jã'ata'ni chʉ'ʉ ĩsiche koosina chʉ'ʉre cuasana karamaʉna jo'e chiima'ñe si'arʉmʉ re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉsanʉkonare ija'che i'kasi'kʉa'mʉ chʉ'ʉ: “Chʉ'ʉ cho'oche ñanata'ni cuasama'me mʉsanʉkona chʉ'ʉre”, chiisi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Cʉnaʉmʉpi chʉ'ʉ chiichechi'a cho'ora chini cajemanesi'kʉa'mʉ chʉ'ʉ. Chʉ'ʉre Raosi'kʉ Dios chʉ̃'ʉñe'te cho'ora chini cajesi'kʉa'mʉ. Jã'ajekʉna chʉ'ʉ Ja'kʉpi cho'okaiʉna pãi chʉ'ʉre jovojanaa'me. Chʉ'ʉre jovonare te'eʉ'terejẽ'e cuhemaneja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chʉ'ʉre Raosi'kʉ Ja'kʉ ija'che chʉ̃'ʉmʉ chʉ'ʉre: “Mʉ'ʉre cuasajʉ jovosinapi jũnisõsinare na'a pa'isirʉmʉ pãi ũcuanʉko cho'osi'e chʉ'ʉ ro'iche chʉ̃'ʉumucusena vasojʉ̃'ʉ repanare, te'eʉjẽ'e cho'osõmanea'jʉ”, chiimʉ Dios chʉ'ʉre. Jã'aja'ñere chiimʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ũcuachi'a chʉ'ʉ Ja'kʉ ija'chere chiimʉ: Chʉ'ʉre Repaʉ Mamakʉni cuasajʉ chʉ'ʉ pa'iche'te ña chẽa pa'iche re'oja'chere pa'ijʉ Repaʉ pa'icheja ai sani paapʉ chiimʉ. Chʉ'ʉpi pãi ũcuanʉko cho'oche Dios ro'iche chʉ̃'ʉumucusena chʉ̃'ʉʉna chʉ'ʉre cuasasinapi jũ'isina jo'e vajʉraijanaa'me —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","“Ãu cʉnaʉmʉ casosi'eja'che pa'ikʉ'mʉ chʉ'ʉ cʉnaʉmʉ cajesi'kʉjekʉ”, chikʉna judíopãi asa pe'rujʉ ija'che sãiñechi'a i'kaasome: —¿Ikʉ José mamakʉma'kʉ? ¿Jesuma'kʉ? Ikʉ pʉka'kʉpãi masime mai. Jã'ata'ni, ¿je'se ikʉ cuasakʉ, “Cʉnaʉmʉpi cajesi'kʉa'mʉ chʉ'ʉ”, chiikʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jã'aja'ñe i'karena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉni pe'rujʉ sãiñechi'a cu'ache cutumairo pa'ijʉ̃'ʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chʉ'ʉre Raosi'kʉ Ja'kʉ cho'okaima'to pãi te'eʉjẽ'e jovomanera'ame chʉ'ʉre. Chʉ'ʉpi chejana jo'e caje chʉ'ʉre jovosina jũ'isinare vasoja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios chʉ'o kʉasina tocha jo'kasi'e ija'che kʉamʉ: Pãi ũcuanʉkore che'choja'mʉ Dios, chiimʉ. Chʉ'ʉ Ja'kʉ chʉ'o asa chẽana chʉ'ʉni cuasajʉ jovome. ");
INSERT INTO coe_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Pãi te'eʉjẽ'e chʉ'ʉ Ja'kʉre ñama'me. Chʉ'ʉchi'a Repaʉ pa'icheja cajesi'kʉjekʉ ñakʉ'mʉ Repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chʉ'ʉre cuasana pa'iche re'oja'chere pa'ijʉ jũnisõsirʉmʉ Dios pa'ichejana ai sani pa'ijanaa'me. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ãu ãni re'oja'che pa'icheja'che chʉ'ʉpi re'oja'chere jo'kaʉna chʉ'ʉre cuasana re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mai aipãi pãi peocheja pa'irʉmʉ manacaã ãisinata'ni jũnisõasome. ");
INSERT INTO coe_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jã'ata'ni iere ãu cʉnaʉmʉ casosi'ere ãina rekoñoã jũnisõmanejanaa'me. Ija'chea'me: ");
INSERT INTO coe_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ãu cʉnaʉmʉ casosi'eja'che pa'ikʉ'mʉ chʉ'ʉ cʉnaʉmʉ cajesi'kʉjekʉ. Chʉ'ʉ ca'nivʉ vanisõñe ʉ̃sema'mʉ chʉ'ʉ, mʉsanʉkona cu'ache cho'oche'te jũni ro'ikasa chini. Chʉ'ʉ ĩsiche ãu chʉ'ʉ ca'nivʉ'me. Repa ãu ãina jũnisõma'ñe si'arʉmʉ pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jã'aja'ñe i'kaʉna asa judíopãi sãiñechi'a ija'che i'kasinaa'me: —¿Je'se ikʉ maire repaʉ ca'nivʉ ãuja'ʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chitena i'kasi'kʉa'mʉ repaʉ. —Mʉsanʉkonapi chʉ'ʉ Dios Raosi'kʉ ca'nivʉ'te ãimaneni chʉ'ʉ chiejẽ'e ũkumaneni re'oja'che pa'imanejanaa'me. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pãi chʉ'ʉ ca'nivʉ ãijʉ chʉ'ʉ chiejẽ'e ũkuna re'oja'che pa'ijanaa'me. Jã'aja'ñe pa'ijʉ jũ'isina pãi ũcuanʉko cho'osi'e Ja'kʉ ro'iche chʉ̃'ʉumucusena chʉ'ʉpi chʉ̃'ʉʉna repana ca'nivʉã vajʉrani Repaʉ pa'ichejana sani pa'ijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chʉ'ʉ ca'nivʉ ãu rʉa ãire'ocheja'che pa'imʉ. Ũcuachi'a chʉ'ʉ chie oko rʉa ũkure'ocheja'che pa'imʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pãi chʉ'ʉ ca'nivʉ ãijʉ chʉ'ʉ chiejẽ'e ũkuna chʉ'ʉna'me si'arʉmʉ pa'inaa'me. Chʉ'ʉ ũcuachi'a repana rekoñoãre si'arʉmʉ ja'me pa'ikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Chʉ'ʉre Raosi'kʉ Ja'kʉ jũnisõma'ñe Si'arʉmʉ Pa'ikʉji cho'okaiʉna ai pa'ikʉ'mʉ chʉ'ʉ. Ũcuaja'che chʉ'ʉpi cho'okaiʉna chʉ'ʉ ca'nivʉ ãina ai pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mai aipãi ãisicaãre manacaãre i'kama'mʉ chʉ'ʉ. Repacaã ãisina ũcuanʉko ai pa'ima'ñe jũnisõasome. Ãu chura cʉnaʉmʉ casosi'ere i'kamʉ chʉ'ʉ. Repa ãu chura cʉnaʉmʉ casosi'e ãina Dios pa'ichejana sani jo'e jũnisõma'ñe pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jã'aja'ñe che'chosi'kʉa'mʉ Jesús, Capernaum vʉ'ejoopo pa'ivʉ'e judíopãi chi'ivʉ'e pa'irʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Repaʉ che'choche'te asa repaʉ'te chiijʉ ja'me ku'ina jainʉko ija'che i'kasinaa'me: —Repaʉ che'choche rʉa asavesamʉ. Te'eʉjẽ'e asa chẽamanejacosome mai —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Repana jachajʉ ke'reche'te masikʉ i'kasi'kʉa'mʉ Jesús. —¿Chʉ'ʉ che'chosi'ere asa pe'ruche mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chekʉrʉmʉ chʉ'ʉpi Dios Raosi'kʉ chʉ'ʉ pa'isichejana jo'e mʉnisõʉna ñani, ¿je'se cuasajanaa'ñe mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dios Rekochochi'a mama pa'iche ĩsikʉ'mʉ. Repaʉ Rekochoji cho'okaima'to asa chẽa re'oja'che pa'ivesʉme pãi. Mʉsanʉkonapi asa chẽa chʉ'ʉni cuasajʉ jovo pa'iche mamare paapʉ chini, “Chʉ'ʉ ca'nivʉ ãijʉ̃'ʉ”, chiisi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jã'ata'ni mʉsanʉkona chuta'a te'ena chʉ'ʉre cuasama'me —chiisi'kʉa'mʉ Jesús. Apereparʉmʉpi repaʉ'te cuasamanejanana'me repaʉ'te cu'ache cho'ojanare jo'kajaʉre masiasomʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Mʉsanʉkona te'ena chʉ'ʉre cuasamapʉna, ija'che che'chosi'kʉa'mʉ chʉ'ʉ: “Ja'kʉ cho'okaima'to pãi te'eʉjẽ'e cuasajʉ jovomanera'ame chʉ'ʉre”, chiisi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jã'aja'ñe i'kasirʉmʉpi repaʉ'te ja'me ku'isina jainʉko jokasõ jo'e ja'me ku'imanesinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jo'kasõrena Jesús chʉkʉna'te repaʉ neena docerepanare ija'che sẽesi'kʉa'mʉ: —¿Mʉsanʉkona ũcuaja'che chʉ'ʉre jo'kasõñu chiiche? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chikʉna Simón Pedro i'kasi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, mʉ'ʉ che'chocheja'che che'chokʉ'te chekʉre ku'eni jñaamanera'ame chʉkʉna. Mʉ'ʉchi'aa'mʉ pa'iche re'oja'chena'me Diore si'arʉmʉ ja'me pa'ijache che'chokʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mʉ'ʉ che'choche jachama'me chʉkʉna. Mʉ'ʉ pa'iche masime chʉkʉna. Dios Si'arʉmʉ Pa'ikʉ Mamakʉ'mʉ mʉ'ʉ; Repaʉ Raosi'kʉa'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chikʉna Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Mʉsanʉkonare docerepanare chẽasi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni te'eʉ vati ai chʉ̃'ʉñe cho'okʉ'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jã'aja'ñe i'kakʉ repaʉ'te cu'ache cho'ojanare jo'kajaʉ Judas pa'iche'te kʉasi'kʉa'mʉ repaʉ Jesús. Jesús neena docerepanare ja'me pa'isi'kʉa'mʉ repaʉ Judas, Simón Iscariote mamakʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jã'a cho'o pi'nisirʉmʉ repaʉ Jesús Galilea chejare pa'iʉ vʉ'ñajoopoã peore ku'isi'kʉa'mʉ. Judea chejata'ni saicuheasomʉ repaʉ, judíopãi chʉ̃'ʉnapi repaʉni vanisõñu chiijʉna. ");
INSERT INTO coe_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Ũcuarʉmʉ judíopãi vʉ'ñarʉã cho'o pa'irʉmʉpi fiesta tĩ'api'rakʉna Jesús cho'jechĩi i'kasinaa'me repaʉ'te. —Icheja pa'imanejʉ̃'ʉ mʉ'ʉ. Judea chejana sani mʉ'ʉ cho'oche'te cho'ojʉ̃'ʉ, repacheja pa'inapi mʉ'ʉre chiinapi ñaa'jʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chekʉna pãi repana pa'iche pãi jainʉko masia'jʉ chiina repana cho'oche rope'e cho'oma'me. Pãi chenevʉãna cho'ome repana, pãipi ñaa'jʉ chini. Jã'ajekʉna mʉ'ʉ masiche pãi ũcuanʉkore cho'o ñojʉ̃'ʉ, ña masia'jʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Repaʉ cho'jechĩijẽ'e, “Dios raosi'kʉma'mʉ ikʉ”, chiijʉ jachajʉ cuasamanesinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","7","Ũcuarʉmʉ Jesús ija'che i'kasi'kʉa'mʉ repanare: —Pãi mʉsanʉkonare cuhema'me. Jã'ajekʉna ũcuaʉarʉmʉjẽ'e saire'omʉ mʉsanʉkonare. Chʉ'ʉreta'ni pãi cuheme, repana cho'oche'te ñakʉ, “Cu'ache cho'ome mʉsanʉkona”, chiiʉ chʉ'vakʉjekʉna. Jã'ajekʉna chʉ'ʉre fiesta saicu'amʉ chura. ");
INSERT INTO coe_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chʉ'ʉre saire'orʉmʉ chuta'a tĩ'amaʉna saima'mʉ chʉ'ʉ. Mʉsanʉkonachi'a saijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jã'aja'ñe i'ka pi'nisirʉmʉ saima'ñe canʉka Galilea chejare pa'isi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Repaʉ cho'jechĩi sanisõsirʉmʉna Jesús chekʉnare kʉama'ñe rope'e te'eʉ fiesta saniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ũcuarʉmʉ judíopãi chʉ̃'ʉna fiesta cho'ocheja Jesuni ku'ejʉ pãi ũcuanʉkore sẽniasome. —¿Jeechejare Jesús pa'ikʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Reparʉmʉ pãi jainʉko Jesús pa'iche sãiñechi'a cutuasome. Te'ena, “Re'okʉ'mʉ repaʉ”, chiniasome. Chekʉnata'ni, “Re'oma'mʉ repaʉ. Jorekʉ pãi cu'ache che'chokʉ'mʉ”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jã'ata'ni judíopãi chʉ̃'ʉnani vajʉchʉjʉ repaʉ pa'iche rope'e cutuasome repana pãi, “Chekʉnapi asajʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Repa fiesta joorepapo cho'ocuharʉmʉna Dios vʉ'ena Jesús kaka che'chosi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Che'chokʉna judíopãi chʉ̃'ʉna asa jñano i'kasinaa'me. —Ikʉ utija'o che'chemanesi'kʉta'ni, ¿je'se pa'iʉna jã'arepa rʉa masikʉ? —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chitena Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ cuasache'te che'choma'mʉ chʉ'ʉ. Chʉ'ʉre Raosi'kʉ kʉache'te che'chomʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios chʉ̃'ʉñe cho'oñu chiina chʉ'ʉ che'choche asa chẽajanaa'me. Asa chẽa, “Repaʉ cuasache che'chomʉ ikʉ”, chiimanejanaa'me repana. “Diopi kʉakʉna che'chomʉ ikʉ”, chini masijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pãiʉ ũcuaʉakʉ repaʉ cuasachechi'a che'choni, pãipi, “Rʉa masikʉ'mʉ mʉ'ʉ”, chiapʉ chini che'chomʉ. Jã'ata'ni pãiʉ repaʉ'te raosi'kʉ kʉachechi'a che'choni, chekʉnapi, “Mʉ'ʉre raosi'kʉ rʉa masikʉ'mʉ”, chiapʉ chini che'chomʉ. Jã'aja'ñe pa'ikʉ jorema'ñe chʉ'o ũcuarepare che'chomʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Dios chʉ̃'ʉñe Moisés tocha jo'kaasomʉ mʉsanʉkonare. Jã'ata'ni repa te'eʉjẽ'e cho'omanaa'me mʉsanʉkona. ¿Je'se pa'iʉna mʉsanʉkona, Diopi chʉ̃'ʉʉna Moisés tocha jo'kasi'e cho'omanata'ni chʉ'ʉre, “Ũcuare cho'oma'mʉ”, chini vanisõñu chiiche? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chikʉna i'kasinaa'me repana. —Vatire paakʉjekʉ jã'aja'ñe i'kacosomʉ mʉ'ʉ. Mʉ'ʉre vanisõñu chiina peome —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chitena Jesús i'kasi'kʉa'mʉ. —Pʉaumucusena chʉ'ʉpi pãiʉni vasoʉna ũcuanʉko ña jñanosinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés chuta'a peorʉmʉ mʉsanʉkona aipãi cho'osi'e jĩkochã'tirʉ chʉto tʉache Moisepi chʉ̃'ʉ jo'kaʉna cho'oñu chini chekʉrʉmʉ mʉsanʉkona pʉaumucuseta'ni chĩiva'ʉ jĩkochã'tirʉ caca'nirʉ chʉto tʉame. ");
INSERT INTO coe_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés chʉ̃'ʉ jo'kasi'ere jachacuhejʉ chekʉrʉmʉ mʉsanʉkona pʉaumucuseta'ni chĩiva'ʉ jĩkochã'tirʉ chʉto tʉame. Jã'aja'ñe cho'onata'ni chʉ'ʉre pe'rume mʉsanʉkona, chʉ'ʉpi pʉaumucusena pãiʉni vasoʉna. ");
INSERT INTO coe_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʉsanʉkona chʉ'ʉ cho'oche'te ña masi cuasama'ñe teana, “Cu'ache cho'omʉ ikʉ”, chiime. Jã'aja'ñe cho'omanejʉ̃'ʉ mʉsanʉkona. Chʉ'ʉ cho'oche ña peore masi cuasa pi'ni rũhiñe cuasajʉ i'kajʉ̃'ʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Reparʉmʉ Jerusalén vʉ'ejoopo cana te'ena ija'che sãiñechi'a sẽniasome: —¿Pãi vanisoñu chini ku'ecojñokʉ'ʉ ikʉ? ");
INSERT INTO coe_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pãi ũcuanʉko asajʉ'te i'kamʉ ikʉ. Jã'ata'ni maire chʉ̃'ʉna te'eʉjẽ'e ʉ̃sema'me ikʉre. ¿“Dios Raosi'kʉa'mʉ ikʉ”, chiijʉ cuasache repana? ");
INSERT INTO coe_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dios Raojaʉ ratu repaʉ raisichejata'ni te'eʉjẽ'e masimanejanaa'me. Ikʉ Jesús raisicheja masime mai. Jã'ajekʉna tĩiʉcosomʉ ikʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Repana i'kache'te asa Jesús Dios vʉ'ere pa'iʉ che'chokʉ ʉjachʉ'opi ija'che i'kasi'kʉa'mʉ: —¿Mʉsanʉkona chʉ'ʉ pa'iche masiche? ¿Chʉ'ʉ raisicheja ũcuachi'a masiche? Chʉ'ʉ te'eʉ cuasakʉ raisi'kʉma'mʉ. Chekʉpi Jorema'kʉpi raoʉna raisi'kʉa'mʉ chʉ'ʉ. Repaʉ pa'iche vesʉme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Chʉ'ʉta'ni Repaʉ pa'icheja raisi'kʉjekʉ Repaʉ pa'iche masimʉ. Ũcuaʉji raosi'kʉa'mʉ chʉ'ʉre —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jã'aja'ñe i'kakʉna asanata'ni repaʉ'te chẽañu chiina te'eʉjẽ'e chẽamanesinaa'me repaʉ'te, Dios chiisirʉmʉpi chuta'a tĩ'amaʉna. ");
INSERT INTO coe_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Chekʉnata'ni jainʉko repaʉni cuasajʉ ija'che i'kasinaa'me: —Ikʉ cho'omasicheja'che cho'omasina peome. Chekʉrʉmʉ ikʉ Dios Raosi'kʉcosomʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pãipi Jesús pa'iche'te cutujʉna asa judío phairipãi chʉ̃'ʉnana'me fariseopãi Jesuni chẽaa'jʉ chini Dios vʉ'e pẽ'jekainani pãi chẽanani saoasome. ");
INSERT INTO coe_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Saorena sani i'kajʉna Jesús ija'che i'kasi'kʉa'mʉ repanare: —Jmamakarʉ mʉsanʉkonare ja'me pa'ija'mʉ chʉ'ʉ. Pani pi'ni chʉ'ʉre Raosi'kʉ pa'ichejana co'ija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chʉ'ʉre mʉsanʉkona ku'ejanaa'me. Jã'ata'ni chʉ'ʉ saisichejare mʉsanʉkonani saicu'akʉna chʉ'ʉre jñaamanejanaa'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chikʉna repana judíopãi sãiñechi'a i'kasinaa'me. —¿Keechejana sakʉna ikʉre mai jñaamanejanaa'ñe? ¿Aperʉmʉ judíopãi jainʉko saisichejñana griegopãi pa'ichejñana sani griegopãire che'choja'ʉ ikʉ? ");
INSERT INTO coe_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ikʉ maire, “Chʉ'ʉ saisicheja mʉsanʉkonani saicu'akʉna ku'enata'ni chʉ'ʉre jñaamanejanaa'me mʉsanʉkona”, chiisi'kʉa'mʉ. ¿Je'se chiikʉ jã'a? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Repa fiesta cuhacho cho'oumucusena na'a rʉa fiesta cho'orʉmʉna Jesús vʉni nʉkakʉ ʉjachʉ'opi i'kasi'kʉa'mʉ. —Pãi ũcuaʉana okoʉato chʉ'ʉni rani ũkujʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dios chʉ'o tocha jo'kasi'e chʉ'ʉre cuasana pa'iche ija'che kʉamʉ: Chiañaã si'arʉmʉ mevoñeja'ñe repana rekoñoã si'arʉmʉ re'oja'che pa'ijanaa'me, chiimʉ repa tocha jo'kasi'e —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Repaʉ Jesús jã'aja'ñe i'kakʉ repaʉ'te cuasanare Dios Rekocho raijachere i'kaasomʉ. Reparʉmʉ Jesupi chuta'a cʉnaʉmʉna mʉimaʉna Dios Rekocho pãi ja'me Pa'ijarekocho chuta'a raimaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús i'kasi'ere asa pãi te'ena ija'che i'kasinaa'me: —“Chʉ'ʉ chʉ'o kʉajaʉre raoja'mʉ chʉ'ʉ”, chiniasomʉ Dios. Ũcuaʉcosomʉ ikʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Chekʉna ija'che i'kasinaa'me: —Dios Raosi'kʉa'mʉ ikʉ. Cristoa'mʉ —chiisinaa'me. Chekʉnata'ni ija'che i'kasinaa'me: —Dios Raojaʉ Galilea chejapi raimaʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Aperʉmʉ pa'isi'kʉ David aineesijoopo Belén vʉ'ejoopoji raija'mʉ Dios Raojaʉ. Mai aipãiʉ David Jojocojñosi'kʉ pa'ija'mʉ repaʉ Dios Raojaʉ, chiimʉ repa tocha jo'kasi'e —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesús pa'iche rʉa cutusinaa'me repana pãi. Jã'ata'ni ũcuate'e cutumanesinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Repana te'ena repaʉ'te chẽañu chiisinaa'me. Jã'ata'ni te'eʉjẽ'e chẽamanesinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ũcuarʉmʉ judío phairipãi chʉ̃'ʉnana'me fariseopãi repana pa'ichejana pãi chẽanapi co'irena i'kaasome repanare. —¿Je'se pa'iʉna mʉsanʉkona Jesure chẽa ramanere? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chitena repana pãi chẽana i'kaasome. —Repaʉ masi i'kacheja'che i'kanare te'eʉ'terejẽ'e asamanaa'me chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chitena repana fariseopãi i'kaasome. —¿Mʉsanʉkona ũcuachi'a repaʉ jorechʉ'o asa chẽare? ");
INSERT INTO coe_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maire chʉ̃'ʉna te'eʉjẽ'e cuasama'me repaʉ'te. Ũcuachi'a chʉkʉna fariseopãi te'eʉjẽ'e cuasama'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Diopi chʉ̃'ʉkʉna Moisés tocha jo'kasi'e vesʉnachi'a Jesús i'kache asa chẽame. Jã'ajekʉna Dios repanare cu'ache cho'oja'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Reparʉmʉ Nicodemo fariseopãiʉ Jesuni ñara chini aperʉmʉ ñamipi saisi'kʉ i'kaasomʉ chekʉnare fariseopãi. ");
INSERT INTO coe_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Mai aipãi tocha jo'kasi'e Dios chʉ'o ija'che kʉamʉ: Chekʉnapi, “Cu'ache cho'osi'kʉa'mʉ ikʉ”, chiijʉna asani teana, “Jã'a pa'ito cu'ache cho'ocojñoja'mʉ mʉ'ʉ”, chiimanejʉ̃'ʉ mʉsanʉkona. Charo repaʉni sẽniasajʉ̃'ʉ, repaʉ cho'osi'ere masirepa asañu chini. Sẽejʉna repana i'kasi'e ũcuarepa pa'ito, “Cu'ache cho'ocojñoja'mʉ mʉ'ʉ”, chiito re'omʉ. Jã'aja'ñe chiimʉ repa tocha jo'kasi'e —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chikʉna i'kaasome repana. —¿Mʉ'ʉ ũcuaja'che Galilea cheja raisi'kʉa'ʉ? Dios chʉ'o tocha jo'kasi'ere ña masijʉ̃'ʉ. Jmamakarʉjẽ'e, “Dios chʉ'o kʉajaʉ Galilea chejapi raija'mʉ”, chiima'mʉ repa —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ũcuarʉmʉ repana pãi fiesta cho'o pi'nisirʉmʉ te'enachi'a repana vʉ'ñana co'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesuta'ni Olivo aikũtina mʉisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jo'e apeñatatona caje Dios vʉ'ena kakasi'kʉa'mʉ repaʉ. Kakaʉna pãipi repaʉni jainʉko chi'irena pʉʉ ñu'iʉ che'chosi'kʉa'mʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ũcuarʉmʉ judíopãi che'chona fariseopãina'me romio'te ʉ̃jʉma'kʉre kãisi'koni chẽa rasinaa'me. Ra repao'te pãi chenevʉna nʉko ");
INSERT INTO coe_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesuni i'kasinaa'me repana. —Masiʉ, ikore chekʉna'me kãiona ñaasome pãi. ");
INSERT INTO coe_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Diopi chʉ̃'ʉkʉna Moisés tocha jo'kasiphʉro ija'che kʉamʉ: Romio'te ʉmʉ pa'ikoji chekʉna'me kãito catapi su'a vẽasõjʉ̃'ʉ, chiimʉ. Mʉ'ʉjẽ'e, ¿je'se chiikʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Repaʉji tĩiñere i'kaʉna chẽañu chini jã'aja'ñe i'kasinaa'me repana repaʉ'te. Repana i'kache sãiñe i'kama'ñe pʉʉ ñu'iʉ mʉoñoji chejana tochakʉ pa'isi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Repanapi cuharepama'ñe sẽejʉna vʉni nʉkakʉ i'kasi'kʉa'mʉ repaʉ. —Mʉsanʉkonapi te'eʉ cu'achejẽ'e peokʉ pani catapʉ mini charo su'ajʉ̃'ʉ ikore —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chini jo'e pʉʉ ñu'iʉ chejana tochasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Repaʉji jã'aja'ñe i'kaʉna asa ũcuanʉko te'enachi'a sanisõsinaa'me repana. Ainapi charo saisinaa'me. Sanisõrena repaʉ Jesús repaona'me te'eka'chapana canʉkasinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ũcuarʉmʉ Jesús vʉni i'kasi'kʉa'mʉ repao'te. —Mʉ'ʉre i'kasina, ¿keechejare pa'iche? ¿Te'eʉjẽ'e, “Mʉ'ʉ cu'ache cho'osi'e ro'ijʉ̃'ʉ”, chiimanere repana mʉ'ʉre? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chikʉna repao i'kasi'koa'mo. —Te'eʉjẽ'e jã'aja'ñe i'kamanesinaa'me chʉ'ʉre —chiisi'koa'mo. Chikona i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ ũcuaja'che, “Mʉ'ʉ cu'ache cho'osi'e ro'ijʉ̃'ʉ”, chiima'mʉ mʉ'ʉre. Chura sani mʉ'ʉ cu'ache cho'oche ũhasõ jo'e cho'omanejʉ̃'ʉ —chiisi'kʉa'mʉ Jesús repao'te. ");
INSERT INTO coe_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ repanare Dios vʉ'e pa'inare. —Pãi chʉ'ʉre cuasajʉ jovosina chʉ'ʉpi pa'iche re'oja'chere ĩsiʉna cu'ache pa'ima'ñe miacheja pa'inaja'ñe repana rekoñoã re'oja'che pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chikʉna fariseopãi i'kasinaa'me repaʉ'te. —Mʉ'ʉ pa'iche'te meñe kʉakʉ joremʉ mʉ'ʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ raisichejajẽ'e vesʉjʉ chʉ'ʉ saijachejajẽ'e vesʉme mʉsanʉkona. Chʉ'ʉta'ni masimʉ. Jã'ajekʉna chʉ'ʉ pa'iche'te chʉ'ʉ meñe kʉasi'e ũcuarepaa'me. ");
INSERT INTO coe_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉsanʉkonata'ni chekʉna i'kacheja'che chʉ'ʉ pa'iche'te vesʉjʉ, “Cu'ache cho'omʉ ikʉ”, chiime. Chʉ'ʉta'ni pãire jã'aja'ñe i'kara chini raisi'kʉma'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Chekʉrʉmʉ chʉ'ʉpi mʉsanʉkona pa'iche'te ña i'kani ũcuarepa i'kara'amʉ. Chʉ'ʉ te'eʉ cuasache'te i'kama'mʉ chʉ'ʉ. Ja'kʉ chʉ'ʉre Raosi'kʉ kʉachena'me chʉ'ʉ cuasache i'kakʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mai aipãi tocha jo'kasi'e ija'che kʉamʉ: Pãi te'eka'chapanapi chekʉ pa'iche'te ña ũcuate'e kʉato jachamanejʉ̃'ʉ repana kʉache, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chʉ'ʉ pa'iche'te meñe kʉamʉ chʉ'ʉ. Chʉ'ʉre Raosi'kʉ Ja'kʉ ũcuaja'che chʉ'ʉ pa'iche kʉamʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chikʉna sẽesinaa'me repana repaʉ'te. —Mʉja'kʉ, ¿keechejare pa'ikʉ? —chiisinaa'me repana. Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ pa'iche vesʉme mʉsanʉkona. Chʉ'ʉ Ja'kʉ pa'iche ũcuaja'che vesʉme. Chʉ'ʉ pa'iche masini Ja'kʉ pa'iche ũcuaja'che masira'ame mʉsanʉkona —chiisi'kʉa'mʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dios vʉ'ere pa'iʉ che'chokʉ jã'aja'ñe i'kasi'kʉa'mʉ Jesús, Dioni ĩsijʉ kuri mañavʉã cachejare nʉkakʉ. Repaʉ'te chẽare'orʉmʉ Dios chiisirʉmʉpi chuta'a tĩ'amaʉna te'eʉjẽ'e chẽamanesinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ repanare. —Sanisõja'mʉ chʉ'ʉ. Chʉ'ʉ saisirʉmʉ ku'ejanaa'me mʉsanʉkona chʉ'ʉre. Jã'ata'ni jñaamapʉ rekoñoã cu'ache tʉnocojñomanapi jũnisõjanaa'me mʉsanʉkona. Chʉ'ʉ saicheja saicu'amʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chikʉna i'kasinaa'me repana judíopãi chʉ̃'ʉna. —¿Je'se pa'iʉna, “Chʉ'ʉ saicheja saicu'amʉ mʉsanʉkonare”, chiikʉ ikʉ? ¿Repaʉji meñe vanisõja'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chitena i'kasi'kʉa'mʉ repaʉ. —Cheja canaa'me mʉsanʉkona. Chʉ'ʉta'ni cʉnaʉmʉ cakʉa'mʉ. Pãi cuasachechi'a cuasanaa'me mʉsanʉkona. Chʉ'ʉta'ni Dios cuasacheja'che cuasakʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jã'ajekʉna pãi cuasachechi'a cuasanajejʉna, “Rekoñoã cu'ache tʉnocojñomanapi jũnisõjanaa'me mʉsanʉkona”, chiisi'kʉa'mʉ. Chʉ'ʉ pa'iche'te mʉsanʉkonare chʉ'ʉ kʉasi'ere asa chẽamaneni cu'ache tʉnocojñomanapi jũnisõjanaa'me mʉsanʉkona —chiisi'kʉa'mʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chikʉna repaʉ'te sẽesinaa'me repana. —¿Jeeja'iʉ'ʉ mʉ'ʉ? —chiisinaa'me repana. Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ apeche'chorʉmʉpi vʉa chʉ'ʉ pa'iche kʉakʉ pa'imʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Chuta'a chʉ'o rʉa i'kache paamʉ chʉ'ʉ. Mʉsanʉkona cho'ojʉ pa'iche'te ñakʉ i'kani, “Cu'ache cho'ome ina”, chiira'amʉ chʉ'ʉ. Ñakʉta'ni i'kama'mʉ chʉ'ʉ. Chʉ'ʉre Raosi'kʉpi chʉ'o ũcuarepare si'arʉmʉ i'kakʉna asakʉ ũcuare pãire kʉamʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Repaʉ Jesús Pʉka'kʉ Dios pa'iche'te kʉasi'kʉa'mʉ. Jã'ata'ni asavesʉsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Asavesʉjʉna ija'che i'kasi'kʉa'mʉ repaʉ: —Mʉsanʉkonapi chʉ'ʉni Dios Raosi'kʉni kurususẽ'verona jẽ'jo nʉkoni chʉ'ʉ pa'iche masijʉ ija'che i'kajanaa'me: “Dios Raosi'kʉa'mʉ ikʉ. Repaʉ cuasachechi'a i'kamanesi'kʉa'mʉ. Repaʉ Pʉka'kʉ che'chochechi'a i'kasi'kʉa'mʉ ikʉ”, chiijʉ masijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chʉ'ʉre Raosi'kʉ chʉ'ʉna'me pa'imʉ. Repaʉ chiiche'te chʉ'ʉpi si'arʉmʉ cho'okʉna jmamakarʉjẽ'e jo'kama'kʉa'mʉ Repaʉ chʉ'ʉre —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Repaʉji jã'aja'ñe i'kaʉna reparʉmʉ pãi jainʉko, “Dios Raosi'kʉa'mʉ ikʉ”, chiijʉ cuasajʉ jovosinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ũcuarʉmʉ Jesús repaʉ'te cuasanare judíopãi ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkonapi chʉ'ʉ chʉ̃'ʉñe'te jo'kasõma'ñe si'arʉmʉ cho'ojʉ pani chʉ'ʉ neerepana pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chʉ'ʉ kʉache'te chʉ'o ũcuarepare asa chẽa masijʉna pãi chẽa paacojñonaja'ñe cu'ache pa'isinare etocheja'che re'oja'che cho'okaija'mʉ chʉ'ʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chikʉna i'kasinaa'me repana. —Aperʉmʉ pa'isi'kʉ Abraham jojosinaa'me chʉkʉna. Jã'ajekʉna jmamakarʉjẽ'e chekʉna chẽa paacojñomanaa'me chʉkʉna. Jã'ata'ni ija'che i'kasi'kʉa'mʉ mʉ'ʉ chʉkʉna'te: “Mʉsanʉkonare pãi chẽa paacojñonaja'ñe pa'isinare etocheja'che re'oja'che cho'okaija'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ mʉ'ʉ. ¿Je'se pa'iʉna jã'aja'ñe i'kaʉ? —chiisinaa'me repana repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chitena i'kasi'kʉa'mʉ repaʉ. —Cu'ache cho'ona ũcuanʉko cu'api chẽa paakʉna cho'oche'te rupʉ cho'okaapʉ chini chẽa paacojñonaja'ñe pa'ime. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pãiʉ repaʉ chẽa paakʉ'te majapãiʉma'kʉjekʉna ai paama'mʉ. Repaʉ mamakʉ'teta'ni majapãiʉjekʉna ai paamʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chʉ'ʉpi Dios Mamakʉji mʉsanʉkonare pãi chẽa paacojñonaja'ñe pa'inani etocheja'che re'oja'che cho'okatu chẽacojño etasina pa'icheja'che ũcuarepa re'oja'che pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham jojocojñosinaa'me mʉsanʉkona. Masimʉ chʉ'ʉ jã'a. Repaʉ jojocojñosinata'ni chʉ'ʉ che'choche'te jachajʉ vanisõñu chiime mʉsanʉkona chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chʉ'ʉ Ja'kʉna'me pa'iʉ ñasi'ere kʉamʉ chʉ'ʉ. Mʉsanʉkonata'ni mʉja'kʉrepaʉ i'kache'te cho'ome —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chikʉna i'kasinaa'me repana. —Abraham jojocojñosinaa'me chʉkʉna —chiisinaa'me repana. Chitena i'kasi'kʉa'mʉ repaʉ. —Mʉsanʉkonapi Abraham cho'osi'eja'che re'oja'che cho'oni repaʉ jojorepasina pa'ira'ame. ");
INSERT INTO coe_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Diopi chʉ'o ũcuarepare kʉakʉna asa kʉakʉ'te vanisõñu chiime mʉsanʉkona chʉ'ʉre. Jmamakarʉjẽ'e mʉsanʉkona cho'ocheja'che cu'ache cho'omanesi'kʉa'mʉ Abraham. ");
INSERT INTO coe_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉja'kʉrepaʉ cho'ocheja'che cho'ome mʉsanʉkona —chiisi'kʉa'mʉ repaʉ. Chikʉna i'kasinaa'me repana. —Chekʉ chĩima'me chʉkʉna. Chʉkʉna Ja'kʉrepaʉ te'eʉ'mʉ Diochi'a —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chitena i'kasi'kʉa'mʉ repaʉ. —Diopi raoʉna ichejare rani pa'imʉ chʉ'ʉ. Dios mʉsanʉkona Ja'kʉrepaʉ pa'ito chʉ'ʉre Repaʉ raosi'kʉre chiira'ame mʉsanʉkona. Chʉ'ʉchi'a te'eʉ cuasa cajesi'kʉma'mʉ chʉ'ʉ. Diopi raosi'kʉa'mʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Je'se pa'iʉna chʉ'ʉ i'kache asavesʉche mʉsanʉkona? Chʉ'ʉ i'kache'te asacuhejʉna asoma'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉja'kʉa'mʉ jã'ʉ vati ai. Repaʉ neenajejʉ repaʉ chiichechi'a cho'oñu chiime mʉsanʉkona. Mamarʉmʉpi vʉa pãi vaikʉ'mʉ repaʉ. Chʉ'o ũcuarepa cuhekʉjekʉ si'arʉmʉ jorekʉ'mʉ repaʉ. Jore aia'mʉ repaʉ. Jore aijekʉ joreni repaʉ cho'oche'te cho'omʉ. Repaʉ pa'iche'me jã'a. Jã'ajekʉna pãi ũcuanʉko jorena pʉka'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chʉ'ʉreta'ni chʉ'o ũcuarepare i'kakʉna jachame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mʉsanʉkonapi te'eʉ chʉ'ʉ cu'ache cho'oche ñasi'kʉ pani kʉajʉ̃'ʉ. Chʉ'o ũcuarepare i'kakʉ'mʉ chʉ'ʉ. ¿Je'se pa'iʉna mʉsanʉkona chʉ'ʉ i'kache cuasama'ñe? ");
INSERT INTO coe_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios neena Repaʉ chʉ'o asa chẽame. Mʉsanʉkonata'ni Dios neemanajejʉ Repaʉ chʉ'o asacuheme —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ũcuarʉmʉ judío aina i'kasinaa'me repaʉ'te Jesure. —“Samariapãiʉjekʉ vatire paamʉ mʉ'ʉ”, chiijʉ chʉ'o ũcuarepare i'kame chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chitena Jesús i'kasi'kʉa'mʉ. —Vatijẽ'e peomʉ chʉ'ʉ. Chʉ'ʉ Ja'kʉre cuasakʉjekʉ Repaʉ'te re'oja'che i'kakʉ'mʉ chʉ'ʉ. Mʉsanʉkonata'ni chʉ'ʉni ña kʉkʉmapʉ cu'ache i'kame. ");
INSERT INTO coe_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Pãi, ña kʉkʉjʉ̃'ʉ chʉ'ʉre”, chiima'mʉ chʉ'ʉ. Ja'kʉta'ni, “Pãi ña kʉkʉa'jʉ mʉ'ʉre”, chini raosi'kʉa'mʉ chʉ'ʉre. Chʉ'ʉre ña kʉkʉmana Ũcuaʉji ro'iche chʉ̃'ʉʉna cu'ache cho'ocojñojanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chʉ'ʉ i'kache jachama'ñe cho'ona cho'osõmanejanaa'me. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chikʉna i'kasinaa'me repana. —Aperʉmʉ pa'isi'kʉ Abraham jũnisõasomʉ, Dios chʉ'o kʉasina ũcuaja'che. Mʉ'ʉta'ni, “Chʉ'ʉ i'kache jachama'ñe cho'ona cho'osõmanejanaa'me”, chiimʉ. Vatire paakʉjekʉ jã'aja'ñe i'kamʉ mʉ'ʉ. Chura masime chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","“¿Mai aipãiʉ'te Abrahamre na'a rʉa masimʉ chʉ'ʉ”, chiikʉ mʉ'ʉ? Repaʉ Abraham jũnisõasomʉ, Dios chʉ'o kʉasina ũcuaja'che. “Repanare na'a rʉa masikʉ'mʉ chʉ'ʉ”, chiiʉ cuasacosomʉ mʉ'ʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chitena i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉpi meñe, “Rʉa masiʉ'mʉ chʉ'ʉ”, chiito jachara'ame pãi chʉ'ʉre. Chʉ'ʉ Ja'kʉta'ni, “Chʉ'ʉ chĩi rʉa masiʉ'mʉ”, chiikʉ'mʉ chʉ'ʉre. Repaʉ i'kache asacuhenata'ni, “Dios chʉkʉna'te paakʉ'mʉ”, chiime mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","“Dios chʉkʉna'te paakʉ'mʉ”, chiinata'ni Repaʉ pa'iche vesʉnaa'me mʉsanʉkona. Chʉ'ʉta'ni Repaʉ pa'iche masikʉ'mʉ. Chʉ'ʉpi, “Dios pa'iche vesʉkʉ'mʉ chʉ'ʉ”, chini jorera'amʉ mʉsanʉkona jorecheja'che. Repaʉ pa'iche masikʉjekʉ Repaʉ chʉ̃'ʉñe cho'okʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mai aipãiʉ Abraham chʉ'ʉ icheja cheja raijachere masikʉ pojosi'kʉa'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chikʉna i'kasinaa'me repana. —¿Je'se pa'iʉna chuta'a cincuentarepaʉ̃sʉrʉmʉjẽ'e peokʉta'ni, “Abrahamre ñasi'kʉa'mʉ chʉ'ʉ”, chiikʉ mʉ'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chitena i'kasi'kʉa'mʉ repaʉ. —Repaʉ Abraham chuta'a peorʉmʉ pa'ikʉ'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jã'aja'ñe i'kaʉna asa pe'rujʉ catare siasinaa'me repana, Jesuni su'a vẽasõñu chini. Jã'aja'ñe cho'ojʉna Dios vʉ'e pa'isi'kʉ kati eta pãi kuanupʉ chenevʉji ñoma'ñe sanisõsi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ũcuarʉmʉ repaʉ Jesús ku'iʉ pãiʉ'te na'ava'ʉ aineesi'kʉni ñasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ñaʉna chʉkʉna repaʉ neena i'kasinaa'me repaʉ'te. —Masiʉ, ¿je'se pa'iʉna iva'ʉ na'ava'ʉ jñaacojñoʉ? ¿Repaʉ rekocho cu'ache paache ro'ire na'ava'ʉ jñaacojñoʉ? Jã'apãani, ¿pʉka'kʉpãi cu'ache pa'iche ro'ire na'ava'ʉ jñaacojñoʉ? —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chitena Jesús i'kasi'kʉa'mʉ. —Repaʉ cu'ache paache ro'ima'mʉ jã'a. Ũcuachi'a pʉka'kʉpãi cu'ache cho'oche ro'ima'mʉ. Rupʉ Diopi vasoʉna pãipi ña, “Dios peore masikʉ'mʉ”, chiijʉ masia'jʉ chini na'ava'ʉ aineesi'kʉa'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pãi repana cho'oche umucusena cho'ore'omʉ. Ñamita'ni cho'ocu'amʉ. Ũcuaja'che chʉ'ʉre Raosi'kʉ Dios chʉ̃'ʉ jo'kasi'ere maipi churana cho'oma'to cu'amʉ. Na'a pa'isirʉmʉ cho'ocu'aja'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chejare chuta'a pa'iʉ pãire Miañeja'ñe Pa'ikʉ'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jã'aja'ñe i'ka pi'ni chejana coo tutu cha'o chacho mini na'ava'ʉ ñakocaãna suirisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cho'o pi'ni repaʉ'te i'kasi'kʉa'mʉ repaʉ. —Okoruruvʉ Siloé chiicojñoruruvʉna sani mʉ'ʉ chia choasõjʉ̃'ʉ cha'o —chiisi'kʉa'mʉ repaʉ. (“Siloé” chini “Saosi'e” chiimʉ.) I'kaʉna sani choasõ rakʉna ñakocaã ñosi'kʉa'mʉ repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ñakocaãre ñakʉna repaʉ'te kueñe pa'inana'me repaʉji kuri si'arʉmʉ sẽeʉ ñu'iʉna ñasina i'kasinaa'me. —¿Na'ava'ʉjekʉ aperʉmʉ ichejare ñu'iʉ kuri sẽesi'kʉma'kʉ repa ikʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Chitena chekʉna i'kasinaa'me. —Ũcuaʉ'mʉ ikʉ —chiisinaa'me. Chekʉna ija'che i'kasinaa'me: —Tĩiʉta'ni rupʉ ũcuaʉja'iʉ'mʉ ikʉ —chiisinaa'me. Ũcuarʉmʉ ũcuaʉji i'kasi'kʉa'mʉ. —Ũcuaʉ'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chikʉna sẽesinaa'me repana. —¿Je'se pa'iʉna na'ava'ʉ pa'isi'kʉta'ni chura ñakʉ mʉ'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chitena i'kasi'kʉa'mʉ repaʉ. —Pãiʉ Jesús ve'ekʉji coo tutu cha'o chacho mini chʉ'ʉ ñakocaãna suiri ija'che i'kasi'kʉa'mʉ chʉ'ʉre: “Okoruruvʉ Siloé chiiruruvʉna sani mʉ'ʉ chia cha'ore choasõjʉ̃'ʉ”, chiisi'kʉa'mʉ. Chikʉna sani choa pi'niʉna ñakocaã ñosi'kʉa'mʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chikʉna sẽesinaa'me repana. —¿Jeechejare pa'ikʉ repaʉ, mʉ'ʉ i'kakʉ? —chiisinaa'me. Chitena i'kasi'kʉa'mʉ repaʉ. —Vesʉmʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ na'ava'ʉ pa'isi'kʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesús cha'opi chacho mini na'ava'ʉre vasoumucuse pʉaumucuse pa'isi'kʉa'mʉ. Jã'ajekʉna pãi na'ava'ʉ pa'isi'kʉre fariseopãi pa'ivʉ'ena mʉvaasome. ");
INSERT INTO coe_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mʉvarena repana fariseopãi na'ava'ʉ pa'isi'kʉre chekʉna sẽesi'eja'che sẽniasome. —¿Je'se cho'o ñakocaã ñakʉ mʉ'ʉ? —chiniasome. Chitena i'kaasomʉ repaʉ. —Chʉ'ʉ ñakocaãna cha'opi chacho suiriʉna okopi choasõjani ñamʉ chʉ'ʉ chura —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chikʉna fariseopãi te'ena ija'che i'kaasome: —Mʉ'ʉre pʉaumucusena vasosi'kʉ Dios raomanesi'kʉcosomʉ. Dios Raosi'kʉ pani pʉaumucuse jã'aja'ñe cho'omanera'amʉ repaʉ —chiniasome. Chekʉnata'ni ija'che i'kaasome: —Ikʉre vasosi'kʉ cu'ache pa'ikʉ pani Diochi'a te'eʉ cho'omasiche cho'omanera'amʉ —chiniasome. Ũcuate'e cuasamaneasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jã'ajekʉna na'ava'ʉ pa'isi'kʉre jo'e sẽniasome repana. —Mʉ'ʉre vasosi'kʉ pa'iche, ¿je'se chiikʉ mʉ'ʉ? —chiniasome repana. Chitena i'kaasomʉ repaʉ. —“Dios chʉ'o kʉakʉ'mʉ”, chiimʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ũcuarʉmʉ judío aina repaʉ'te vasosi'ere jachajʉ, “Na'ava'ʉ pa'isi'kʉma'mʉ ikʉ”, chiijʉ jachaasome. Jachajʉ repaʉ pʉka'kʉpãi soni rao ");
INSERT INTO coe_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","sẽniasome repana. —¿Ikʉ mʉsanʉkona chĩia'ʉ? Iva'ʉ mʉsanʉkona, “¿Chĩirʉmʉna teana na'ava'ʉ aineesi'kʉ”, chiicojñova'ʉa'ʉ? Jã'a pa'ito, ¿je'se cho'o chura ñakocaã ñakʉ ikʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chitena pʉka'kʉpãi i'kaasome repanare. —Chʉkʉna chĩia'mʉ ikʉ. Teana na'ava'ʉ aineesi'kʉa'mʉ ikʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jã'ata'ni repaʉ ñakocaã cho'o ñañe vesʉme chʉkʉna. Repaʉ'te vasosi'kʉre ũcuaja'che vesʉme chʉkʉna. Sẽniasajʉ̃'ʉ repaʉni kʉaa'kʉ. Aia'mʉ repaʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Fariseopãire vajʉchʉjʉ jã'aja'ñe i'kaasome repana pʉka'kʉpãi. Aperʉmʉ judíopãi chʉ̃'ʉna, “ ‘Jesús Dios Raocojñosi'kʉa'mʉ’, chiinare mai judíopãi chi'ivʉ'e kakache ʉ̃señu”, chiniasome. ");
INSERT INTO coe_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jã'aja'ñe chiisi'ejekʉna, “Aia'mʉ repaʉ. Repaʉni sẽniasajʉ̃'ʉ”, chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ũcuarʉmʉ repana judío aina na'ava'ʉ pa'isi'kʉre jo'e soni i'kaasome. —Dios ñakʉ'te chʉ'o ũcuarepare i'kajʉ̃'ʉ. “Mʉ'ʉre vasomʉ chʉ'ʉ”, chiisi'kʉ cu'akʉ'mʉ —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chitena i'kaasomʉ repaʉ. —Chekʉrʉmʉ cu'ache cho'okʉ'mʉ repaʉ. Chekʉrʉmʉ pãakʉ'mʉ. Vesʉmʉ chʉ'ʉ. Ieta'ni masimʉ: Aperʉmʉ na'ava'ʉ pa'isi'kʉ chura ñamʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chikʉna jo'e sẽniasome repana repaʉ'te. —¿Je'se cho'oʉ repaʉ? ¿Je'se cho'oʉna ñakocaã ñoʉ mʉ'ʉre? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chitena i'kaasomʉ repaʉ. —Repaʉ cho'osi'e kʉacuhasi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni jachame mʉsanʉkona. ¿Je'se pa'iʉna jo'e, “Kʉajʉ̃'ʉ”, chiiche mʉsanʉkona chʉ'ʉre? ¿Mʉsanʉkona ũcuachi'a repaʉni jovoñu chiiche? —chiniasomʉ repaʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chikʉna asa pe'rujʉ repaʉ'te ija'che i'kaasome repana: —Mʉ'ʉ repaʉ chʉ̃'ʉñe cho'okʉ'mʉ. Chʉkʉnata'ni Moisés chʉ̃'ʉ jo'kasi'e cho'onaa'me. ");
INSERT INTO coe_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dios Moisere i'kasi'e masinaa'me chʉkʉna. Mʉ'ʉre vasosi'kʉre raosi'kʉreta'ni vesʉme chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chitena i'kaasomʉ repaʉ. —¿Repaʉ'te raosi'kʉre vesʉche mʉsanʉkona? ¡Jeerʉa tĩiñea'ñe jã'a! Chʉ'ʉre vasosi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cu'ache pa'ina sẽeñe cho'okaima'mʉ Dios. Jã'are masime mai. Repaʉ'te Diore pojojʉ Repaʉ chʉ̃'ʉñe cho'ona sẽeñeta'ni cho'okaikʉ'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te'eʉ'terejẽ'e na'ava'ʉ aineesi'kʉre vasoasomʉ chiicojñokʉ'te asamanaa'me mai. ");
INSERT INTO coe_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Repaʉji Dios raomanesi'kʉ pani Diochi'a te'eʉ cho'omasiche cho'omanera'amʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chikʉna i'kaasome repana. —¿Chĩirʉmʉna teana cu'ache aineesiva'ʉpi che'chora chiikʉ mʉ'ʉ chʉkʉna'te? Rʉa tĩiñea'me jã'a —chiniasome repana. Chini repaʉ'te ve'sena etoasome repana. ");
INSERT INTO coe_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ũcuarʉmʉ Jesús na'ava'ʉ pa'isi'kʉre etosi'e asasi'kʉa'mʉ. Asasi'kʉjekʉ repaʉ'te ku'e jñaa ija'che i'kasi'kʉa'mʉ repaʉ: —¿Dios Raosi'kʉre cuasakʉ mʉ'ʉ? —chiisi'kʉa'mʉ repaʉ ũcuaʉji. ");
INSERT INTO coe_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chikʉna i'kasi'kʉa'mʉ repaʉ. —¿Kaʉa'ʉ repaʉ? Kʉajʉ̃'ʉ chʉ'ʉre; repaʉni cuasara —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chikʉna Jesús i'kasi'kʉa'mʉ repaʉ'te. —Ñacuhamʉ mʉ'ʉ repaʉ'te. Ũcuaʉ'mʉ chʉ'ʉ, mʉ'ʉre i'kakʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chikʉna asa Jesure ti'jñeñe ro're pʉʉ ñu'iʉ i'kasi'kʉa'mʉ repaʉ. —Pãi Ũcuanʉkore Paakʉ, cuasamʉ chʉ'ʉ mʉ'ʉre —chiiʉ repaʉ'te pojosi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ũcuarʉmʉ Jesús i'kasi'kʉa'mʉ. —Ichejare chejare caje pa'iʉ che'chomʉ chʉ'ʉ, cu'ache pa'inajejʉ, “Na'ava'na pa'icheja'che pa'inaa'me chʉkʉna”, chiinapi asa chẽa chʉ'ʉni cuasajʉ ñakocaã ñana pa'icheja'che re'oja'che paapʉ chini. Jã'ata'ni chekʉnare, “Dios chʉ'o masinajejʉ re'oja'che pa'inaa'me chʉkʉna”, chiinani, “Dios chʉ'o masinata'ni chʉ'ʉni cuhejʉ na'ava'na pa'icheja'che pa'ime mʉsanʉkona”, chisa chini cajesi'kʉa'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Repaʉ i'kasi'ere asa fariseopãi te'ena repaʉ'te ja'me pa'ina sẽesinaa'me. —¿Mʉ'ʉ cuasato chʉkʉna na'ava'na pa'icheja'che pa'inaa'ñe? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chitena i'kasi'kʉa'mʉ repaʉ. —Mʉsanʉkonapi Dios chʉ'ore vesʉjʉ na'ava'na pa'icheja'che pani chʉ'ʉre cuheche ro'iche peora'amʉ mʉsanʉkonare. Jã'ata'ni, “Dios chʉ'o masime chʉkʉna”, chiinapi chʉ'ʉni cuhejʉna ro'iche pa'imʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ũcuarʉmʉ Jesús repanani chʉ'vakʉ ija'che i'kasi'kʉa'mʉ: —Pãiʉ ñaaʉji ovejava'na pa'iso'korona rani jatisa'aro kakama'ñe tĩichejapi kakamʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Repava'nare kuirakʉta'ni jatisa'aroji kakamʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Repava'nare kuirakʉji ũcuaso'korona kakara chiito repasa'aro pẽ'jekaikʉji jatisa'aro vatakaimʉ. Vataʉna kaka repava'na mamire ve'okʉ soito ũcuanʉko repava'na mami asamasime repana. Soiʉna tuha ja'me etame repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Repava'nare ũcuanʉkore etua charo saiʉ soiʉna asamasijʉ tuha repaʉ ku'ichejña ja'me ku'ime repava'na. ");
INSERT INTO coe_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tĩiʉpi repanare soito asavesʉjʉ tuhama'ñe vʉ'vʉsõme tĩiʉjekʉna. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Repanani chʉ'vakʉ jã'aja'ñe i'kasi'kʉa'mʉ Jesús. Jã'ata'ni repaʉ i'kache asavesʉsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Repana pa'iso'korona ovejava'na kakasa'aroja'che pa'ikʉ'mʉ chʉ'ʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Chʉ'ʉ chuta'a raimarʉmʉ pãi jainʉko te'enachi'a rani, “Dios raosi'kʉa'mʉ chʉ'ʉ”, chiijʉ jorejʉ che'chosinaa'me. Ñaana cho'ocheja'che cho'osinaa'me repana. Repana che'choche chʉ'ʉ neena jachasinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ovejava'na pa'iso'koro kakasa'aroja'che pa'ikʉ'mʉ chʉ'ʉ. Jã'ajekʉna ovejava'napi repana pa'iso'korona kakacheja'che pãipi chʉ'ʉni cuasani chʉ'ʉpi chẽa paakʉ kuirakʉna rʉa pojojʉ re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ñaaʉji rani ovejava'nare ñaasõmʉ. Chekʉrʉmʉ repava'nare vani si'asõmʉ. Jã'aja'ñe cho'ora chini'te raimʉ ñaaʉ. Repaʉ cho'ocheja'che cho'ome jorejʉ che'chona. Chʉ'ʉta'ni pa'iche re'oja'chere ĩsira chini raisi'kʉa'mʉ, pãipi karama'ñe re'oja'che paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejava'nare re'oja'che paakʉ pa'icheja'che pa'ikʉ'mʉ chʉ'ʉ. Chekʉrʉmʉ ovejava'nare paakʉ re'okʉjekʉ, chaipi ovejava'nani ãnisõra chini raiʉna ñani, “Chʉ'ʉpi iva'nare cu'ache cho'oche'te ʉ̃seto chai chʉ'ʉni ãnisõja'mʉ”, chiikʉta'ni ũcua ʉ̃semʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Chekʉrʉmʉ kurire koora chini tĩiʉpi kuirakaimʉ repava'nare. Kuirakʉna chekʉrʉmʉ chaipi repava'nani ãnisõra chini raiʉna ñani repava'nare jo'ka vʉ'vʉsõmʉ repaʉ, repanare paakʉma'kʉjekʉ. Jo'ka vʉ'vʉsõʉna chaipi rani te'eva'ʉre chẽaʉna chekʉna te'enachi'a vʉ'vʉsõme. ");
INSERT INTO coe_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kurire koora chini kuirakʉjekʉ repava'nare oima'ñe jo'ka vʉ'vʉsõmʉ repaʉ, chaipi rakʉna. ");
INSERT INTO coe_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ovejava'nare re'oja'che paakʉ pa'icheja'che pa'ikʉ'mʉ chʉ'ʉ. Chʉ'ʉ neenare masimʉ chʉ'ʉ. Chʉ'ʉre ũcuaja'che masime repana. ");
INSERT INTO coe_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Chʉ'ʉ Ja'kʉ masimʉ chʉ'ʉre. Chʉ'ʉ ũcuaja'che Repaʉ'te masimʉ. Chʉ'ʉ neenani cu'ache cho'oche'te ʉ̃sera chini chuenisõñe cuhema'ñe jũ'ija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chekʉnare ũcuachi'a judío peonare paamʉ chʉ'ʉ. Repanani soiʉna asa jachama'ñe rani chʉ'ʉni jovo judío pãina'me ũcuate'ekuanupʉja'che pa'ijʉna te'eʉ paakʉ kuiraja'mʉ chʉ'ʉ repanare ũcuanʉkore. ");
INSERT INTO coe_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Pãi cu'ache cho'oche'te ro'ikasa chini chuenisõñe'te cuhemaʉna Ja'kʉ chʉ'ʉre rʉa chiimʉ. Jo'e vajʉrasa chini cuhema'ñe chuenisõja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Chʉ'ʉpi cuheto te'eʉjẽ'e vanisõmanejanaa'me chʉ'ʉre. Jã'ata'ni chʉ'ʉ ca'nivʉ ʉ̃sema'ñe ĩsija'mʉ chʉ'ʉ, pãipi vanisõa'jʉ chini. Chʉ'ʉ ca'nivʉ ĩsire'omʉ. Ũcuachi'a chʉ'ʉpi jũnisõ vajʉrasa chiito vajʉraire'omʉ chʉ'ʉre. Jã'aja'ñe cho'oa'kʉ chini chʉ̃'ʉ jo'kasi'kʉa'mʉ Ja'kʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jã'aja'ñe i'kaʉna asa ũcuate'e cuasamapʉ sãiñechi'a ke'resinaa'me repana judío aina. ");
INSERT INTO coe_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jainʉko ija'che i'kasinaa'me: —Vatire paakʉjekʉ vẽ'veʉ'mʉ ikʉ. Ikʉ i'kache asamaneñu mai —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Chekʉnata'ni ija'che i'kasinaa'me: —Vati paana jã'aja'ñe i'kamanaa'me. Ũcuachi'a vati na'ava'nare vasomanaa'me —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ũcuarʉmʉ judíopãi Jerusalén vʉ'ejoopona Dios vʉ'e aperʉmʉ judío peonani tʉa care'vasi'ere cuasajʉ fiesta cho'osinaa'me. Okorʉmʉ pa'isi'kʉa'mʉ reparʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","24","Ũcuarʉmʉ Jesupi Dios vʉ'e ve'se cakachapa'te Portal de Salomón chiikachapa'te nʉka ku'iʉna ña judío ainapi rani rũhiso'koro nʉkajʉ ija'che i'kasinaa'me repaʉ'te: —Mʉ'ʉpi asavesache kʉakʉna vesʉme chʉkʉna mʉ'ʉ pa'iche. Dios Raosi'kʉ Cristo pani teana rũhiñe kʉajʉ̃'ʉ chʉkʉna'te —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chitena i'kasi'kʉa'mʉ repaʉ. —Ũcuare kʉasi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni jachame mʉsanʉkona. Ja'kʉpi chʉ̃'ʉ raoʉna rani Repaʉchi'a te'eʉ cho'omasiche cho'o ñomʉ chʉ'ʉ, pãipi chʉ'ʉ pa'iche'te masia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mʉsanʉkona chʉ'ʉ neenamanajejʉ jachajʉ cuasama'me chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chʉ'ʉ neena chʉ'ʉ i'kache asamasijʉ jovo ja'me ku'ijʉ chʉ'ʉ chʉ̃'ʉñe cho'ome. Repanare masimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chʉ'ʉpi repanani cho'okaiʉna re'oja'che pa'ijʉ jũnisõsirʉmʉ vati toa saima'ñe Dios pa'ichejare ai sani pa'ijanaa'me repana. Te'eʉjẽ'e tʉamanejanaa'me repanare chʉ'ʉ neenare. ");
INSERT INTO coe_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ja'kʉpi pãi ũcuanʉkore na'a rʉa Masikʉji chʉ'ʉni jo'kaʉna te'eʉ'terejẽ'e tʉacu'amʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Chʉ'ʉna'me Ja'kʉ ũcuate'eʉja'che pa'inaa'me chʉkʉna —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jã'aja'ñe i'kaʉna asa pe'rujʉ jo'e cata siasinaa'me repana judío aina repaʉni su'a vẽasõñu chini. ");
INSERT INTO coe_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jã'aja'ñe cho'oñu chiijʉna Jesús i'kasi'kʉa'mʉ repanare. —Ja'kʉpi chʉ'ʉni cho'okaiʉna Repaʉchi'a cho'omasiche mʉsanʉkona ñajʉ'te cho'oche re'oja'chere rʉa cho'osi'kʉa'mʉ chʉ'ʉ. Chʉ'ʉ cho'osi'e, ¿jeere mʉsanʉkona cuhejʉ chʉ'ʉre catapi su'a vẽasõñu chiiche? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chikʉna jo'e i'kasinaa'me repana. —Mʉ'ʉ re'oja'che cho'osi'ere cuhejʉ catapi su'a vẽasõñu chiima'me chʉkʉna. Mʉ'ʉpi, “Chʉ'ʉna'me Ja'kʉ ũcuate'eʉja'che pa'inaa'me chʉkʉna”, chikʉna cuhejʉ catapi su'a vẽasõñu chiime chʉkʉna mʉ'ʉre, Dios cuheche'te i'kaʉna. Dioma'mʉ mʉ'ʉ. Rupʉ pãiʉ'mʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chitena i'kasi'kʉa'mʉ repaʉ. —Mai aipãi tocha jo'kasi'e Dios chʉ'o ija'che kʉamʉ: Diova'naa'me mʉsanʉkona, chiiche tocha jo'kaasome repana. ");
INSERT INTO coe_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Repana tocha jo'kasi'e, “Diova'naa'me mʉsanʉkona”, chini Dios chʉ'o asa chẽana pa'iche'te i'kamʉ. “Dios chʉ'o jorechʉ'oa'me”, chiicu'amʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jã'ata'ni chʉ'ʉpi, “Dios chĩia'mʉ chʉ'ʉ”, chiiʉna asa, “Dios asacuheche'te i'kamʉ mʉ'ʉ”, chiime mʉsanʉkona chʉ'ʉre, Repaʉ Chẽa Raosi'kʉni. ¿Je'se pa'iʉna mʉsanʉkona jã'aja'ñe i'kache? ");
INSERT INTO coe_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chʉ'ʉ Ja'kʉ chiiche'te cho'oma'to jachare'omʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Chʉ'ʉ i'kache jachanata'ni chʉ'ʉ Ja'kʉ chiiche Repaʉchi'a cho'omasiche'te chʉ'ʉpi cho'o ñokʉna jachamanejʉ̃'ʉ mʉsanʉkona. Jachama'ñe ija'che cuasajʉ̃'ʉ: “Diona'me ũcuate'eʉja'che pa'ikʉ'mʉ ikʉ”, chini cuasa masijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chikʉna jo'e chẽañu chiinareta'ni jo'ka sanisõsi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Eta Jordán chiacha chekʉkã'kona aperʉmʉ Juan pãi okoro'vesichejana ʉ̃sʉʉ mʉikã'kona jẽni canʉka pa'isi'kʉa'mʉ repaʉ, chʉkʉna repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ũcuachejare pa'ijʉna pãi jainʉko repaʉni ñañu chini rani te'ena ija'che i'kasinaa'me: —Juan Diochi'a te'eʉ cho'omasiche cho'omanesi'kʉa'mʉ. Jã'ata'ni ikʉ Jesús pa'iche repaʉ kʉasi'e peore ũcuarepaa'me —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ũcuachejana pãi jainʉko repaʉ'te Jesure cuasajʉ jovosinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ũcuarʉmʉ Betania vʉ'ejoopo cakʉ Lázaro ravʉna jũniasomʉ. Repaʉ cho'jeromi ũcuajoopo'te paniasome Maríana'me Marta. ");
INSERT INTO coe_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Repao María Jesús cũ'ana okoma'ña ro repao rañapi tʉ'nesi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Majaa'chʉ Lázaroji jũ'iʉna cho'jeromi chekʉnani raoasome Jesuni, “Mʉ'ʉ chiicojñokʉ jũ'imʉ”, chiapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sa kʉarena asa i'kasi'kʉa'mʉ repaʉ. —Jũnisõa'kʉ chini ravʉ jũ'iñe cho'omaneasomʉ Dios Lázaro'te. Rupʉ Repaʉ cho'omasiche'te pãire cho'o ñora chini cho'oasomʉ. Jã'ajekʉna jũnisõsi'kʉta'ni vajʉrakʉna ña, “Dios peore masikʉ'mʉ”, chiijanaa'me pãi. Ũcuachi'a, “Dios Mamakʉ rʉa masimʉ”, chiijanaa'me repana —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Repaʉ Jesús repanare Martana'me cho'jeona'me Lázaro'te rʉa chiikʉta'ni, “Lázaro jũ'imʉ”, chiito asa teana saimanesi'kʉa'mʉ. Saima'ñe te'eka'chapaumucujña ũcuachejare canʉka pa'isi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ũcuarʉmʉ repaʉ chʉkʉna'te repaʉ neenare i'kasi'kʉa'mʉ. —Judea chejana jo'e sañu mai —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chikʉna i'kasinaa'me chʉkʉna. —Masiʉ, aperʉmʉ repacheja pa'ina judío aina catapi su'a vẽasõñu chiniasome mʉ'ʉre. ¿Ũcuachejana jo'e sasa chiikʉ mʉ'ʉ? —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chitena i'kasi'kʉa'mʉ repaʉ. —Te'eumucuse doce horas pa'imʉ. Pãiʉji umucusena kuni tota tãima'ñe ku'imʉ miakʉna. ");
INSERT INTO coe_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pãiʉji ñamipi kuni tota tãiʉ ku'imʉ miañeji karakʉna —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Mai cuasacojñokʉ Lázaro kãnisõcuhasi'kʉa'mʉ. Jã'ajekʉna saimʉ chʉ'ʉ repaʉni vʉora chini —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chikʉna jo'e i'kasinaa'me chʉkʉna. —Chʉkʉna'te Paakʉ, Lázaroji jũ'iʉ kãnisõsi'kʉ pani vajʉja'mʉ —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Repaʉ Jesús, “Lázaro kãnisõsi'kʉa'mʉ”, chiiʉ repaʉ jũnisõsi'ere i'kasi'kʉa'mʉ. Repaʉ i'kache'te asavesʉjʉ, “Lázaro rupʉ kãisi'ere i'kamʉ ikʉ”, chini cuasasinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jã'aja'ñe cuasajʉna Jesús rũhiñe kʉasi'kʉa'mʉ chʉkʉna'te. —Repaʉ Lázaro jũnisõsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Repana chʉ'ʉre soito teana saimanesi'kʉa'mʉ chʉ'ʉ, mʉsanʉkonapi chʉ'ʉni masi cuasaa'jʉ chini. Mʉsanʉkona chʉ'ʉre masi cuasajachere cuasakʉ pojomʉ chʉ'ʉ. Chura sani ñañu mai —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ũcuarʉmʉ Tomás Gemelo chiicojñokʉji i'kasi'kʉa'mʉ chʉkʉna'te. —Ikʉni ja'me sañu mai. Sani pãipi repaʉni vaito ũcuaʉna'me chuenisõñu mai —chiisi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chʉkʉna sani tĩ'a ñato ũcuaka'chapaumucujña tãcojñosi'kʉ pa'isi'kʉa'mʉ repaʉ Lázaro. ");
INSERT INTO coe_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania vʉ'ejoopo Jerusalén vʉ'ejoopo kueñere pa'imʉ. Chekʉrʉmʉ tres kilómetrocosomʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Maríana'me Marta majaa'chʉpi jũnisõʉna otare oijʉna chʉroñu chini saisina judío aina jainʉko pa'isinaa'me reparʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ũcuarʉmʉ Jesupi raiʉna asa etasi'koa'mo Marta repaʉni tijña pojora chini. Maríata'ni etama'ñe vʉ'ere pa'isi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Eta tijña pojo pi'ni i'kasi'koa'mo repao. —Pãi Ũcuanʉkore Paakʉ, mʉ'ʉpi ichejare pa'ito chʉ'ʉ a'chʉ jũnisõmanera'asi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jã'ata'ni mʉ'ʉ sẽeñe peore ĩsija'mʉ Dios mʉ'ʉre. Masimo chʉ'ʉ jã'a —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chikona Jesús i'kasi'kʉa'mʉ. —Mʉa'chʉ vajʉraija'mʉ —chiisi'kʉa'mʉ repaʉ. Chikʉna Marta i'kasi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Masimo chʉ'ʉ jã'a. Pãi ũcuanʉko cho'osi'e Dios cuasa ro'iche chʉ̃'ʉumucusena vajʉraija'mʉ repaʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chikona i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉa'mʉ pãi jũnisõsinare vasokʉ. Ũcuachi'a pãi rekoñoãna re'oja'chere pa'iche jo'kakʉ'mʉ chʉ'ʉ. Pãi chʉ'ʉre cuasanapi jũnisõsina chʉ'ʉpi jo'e rani vasoʉna vajʉrani re'oja'che pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Chʉ'ʉre cuasana reparʉmʉ chuta'a vajʉna ũcuachi'a Dios pa'ichejare ai sani pa'ijanaa'me. ¿Chʉ'ʉ i'kache jachama'ñe cuasako mʉ'ʉ? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chikʉna i'kasi'koa'mo repao. —Jʉ̃jʉ, Cristo, Dios Raocojñosi'kʉa'mʉ mʉ'ʉ. Dios aperʉmʉ, “Chejana chʉ'ʉ neekʉre saoja'mʉ chʉ'ʉ”, chiniasomʉ. Ũcuaʉ'mʉ mʉ'ʉ. Jã'aja'ñe cuasamo chʉ'ʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jã'aja'ñe i'ka pi'ni repao Marta vʉ'ena co'i cho'jeo'te María'te soni te'eo'te kʉaasomo. —Pãi che'chokʉ ranicuhasi'kʉa'mʉ. Mʉ'ʉni soimʉ repaʉ —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chikona repao María asa teana vʉni etaasomo repaʉni tijñara chini. ");
INSERT INTO coe_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Chʉkʉna chuta'a repajoopo vʉ'ejoopo tĩ'amanesinaa'me. Marta chʉkʉna'te tijñasichejare chuta'a ma'are pa'isinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maríapi vʉni eta raiona ña judío aina repanapi otare oijʉna chʉroñu chini raisina repavʉ'e ja'me chi'i pa'ina ja'me tuhasinaa'me repao'te, “Majaa'chʉre tãsichejare osa chini saicosomo”, chini. ");
INSERT INTO coe_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eta rani chʉkʉna pa'icheja tĩ'a Jesús ti'jñeñena meñe sime ñu'io ija'che i'kasi'koa'mo repao: —Pãi Ũcuanʉkore Paakʉ, mʉ'ʉpi ichejare pa'ito chʉ'ʉ a'chʉva'ʉ jũnisõmanera'asi'kʉa'mʉ —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Judío ainapi repaona'me oijʉ raiche'te ña sʉmava'ʉ pa'isi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Repaʉni sʉmaʉna repanare sẽesi'kʉa'mʉ repaʉ. —¿Jeechejana mʉsanʉkona repava'ʉre tãre? —chiisi'kʉa'mʉ. Chikʉna i'kasinaa'me repana. —Pãi Ũcuanʉkore Paakʉ, rani ñajʉ̃'ʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús reparʉmʉ oisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oiʉna repana judío aina i'kasinaa'me. —Ñajʉ̃'ʉ; Lázaro'te rʉa chiicosomʉ ikʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Chekʉna te'ena ija'che i'kasinaa'me repaʉ'te: —Na'ava'ʉre vasoasomʉ ikʉ. ¿Je'se pa'iʉna Lázaro'te jũ'iñe ʉ̃sekaimaneʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Reparʉmʉ Jesús jo'e cuasa oiʉ na'a rʉa sʉmava'ʉ Lázaro'te tãsicojena saisi'kʉa'mʉ. Aikũti caripana tẽtoche ũhisicoje pa'isi'kʉa'mʉ repacoje. Ũcuachi'a catapʉ ʉjapʉji ta'pisicoje pa'isi'kʉa'mʉ repacoje. ");
INSERT INTO coe_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sani tĩ'a i'kasi'kʉa'mʉ repaʉ. —Catapʉ'te kʉñojʉ̃'ʉ —chiisi'kʉa'mʉ. Jã'aja'ñe i'kaʉna jũnisõsiva'ʉ cho'jeo Marta i'kasi'koa'mo. —Pãi Ũcuanʉkore Paakʉ, repava'ʉre tãsi'e ũcuaka'chapaumucujñaa'me ie chura. Jã'ajekʉna icoje vataru rʉa ʉ̃tosʉjacosomʉ —chiisi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chikona i'kasi'kʉa'mʉ repaʉ. —Mʉ'ʉre ija'che i'kasi'kʉa'mʉ chʉ'ʉ: “Chʉ'ʉre cuasani Dios peore Masiʉ cho'oche ñaja'mo mʉ'ʉ”, chiisi'kʉa'mʉ chʉ'ʉ mʉ'ʉre —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chikʉna repapʉ kʉñosinaa'me repana. Kʉñorena repaʉ Jesús ʉmʉre ñakʉ ija'che i'kasi'kʉa'mʉ: —Ja'kʉ, mʉ'ʉpi chʉ'ʉ sẽeñe'te asakʉna, “Re'orepamʉ”, chiimʉ chʉ'ʉ mʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Chʉ'ʉ sẽeñe si'arʉmʉ asakʉ'mʉ mʉ'ʉ. Masimʉ chʉ'ʉ jã'a. Jã'ata'ni chura ʉjachʉ'opi i'kakʉ sẽemʉ chʉ'ʉ mʉ'ʉre, inapi asa, “Dios Raosi'kʉa'mʉ ikʉ”, chini cuasaa'jʉ chini —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jã'aja'ñe i'ka pi'ni ʉjachʉ'opi ija'che i'kasi'kʉa'mʉ repaʉ: —Lázaro, etajʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chikʉna repaʉ jũnisõsiva'ʉ vajʉrani etasi'kʉa'mʉ jʉ̃jñana'me cũ'ana'me chia reasõsi'kʉ. Etaʉna Jesús i'kasi'kʉa'mʉ. —Repaʉ'te reasikãña vanakaijʉ̃'ʉ saaʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesupi jã'aja'ñe cho'oʉna judío aina jainʉko María'te ñañu chini saisina repaʉ vasosi'ere ña cuasa jovoasome Jesure. ");
INSERT INTO coe_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Chekʉnata'ni sani Jesús cho'osi'ere fariseopãire kʉaasome. ");
INSERT INTO coe_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kʉarena asa repana fariseopãina'me phairipãi chʉ̃'ʉna judíopãi ũcuanʉkore chʉ̃'ʉnare soni chi'i i'kaasome. —Repaʉ Jesús Diochi'a cho'omasiche rʉa cho'okʉasomʉ. ¿Je'se cho'ojanaa'ñe mai? ");
INSERT INTO coe_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Maipi ʉ̃sema'to pãipi ũcuanʉko repaʉni cuasajʉ repaʉ chʉ̃'ʉñe'te chiijʉ jovorena Romapãi chʉ̃'ʉnapi asani pe'rujʉ rani Dios vʉ'e ñañosõ maire ũcuaja'che jainʉkore vanisõjanaa'me —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chitena Caifás repaʉ̃sʉrʉmʉ judío phairi ai i'kaasomʉ repanare ja'me pa'ikʉji. —Rʉa vesʉme mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Maipi repaʉ cho'oche'te ʉ̃semapʉ jainʉko chuenisõto cu'amʉ. “Cho'okʉchi'a ũcuate'eʉ pãi ũcuanʉko chuenisõmanea'jʉ chini chuenisõkaito na'a re'omʉ maire”, chiimacosome mʉsanʉkona —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Repaʉchi'a cuasache'te jã'aja'ñe i'kamaneasomʉ repaʉ. Repaʉ̃sʉrʉmʉ phairi aijekʉna Diopi repaʉ rekochona kʉaʉna judíopãi cu'ache cho'oche'te ro'ikasa chini Jesús chuenisõjañere i'kaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Judíopãichi'a jũni ro'ikaijachere i'kamaneasomʉ repaʉ. Ũcuachi'a Dios Repaʉ neenare si'achejñarʉã pa'inare ũcuate'ekuanupʉ jovojachere i'kaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ũcuaumucusepi vʉa repana judíopãi chʉ̃'ʉna Jesure vanisõjañere rʉa cutujʉ paniasome. ");
INSERT INTO coe_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jã'ajekʉna repaʉ Jesús reparʉmʉpi vʉa judíopãi chʉ̃'ʉna pa'ichejña ku'ima'ñe pa'iʉ Judea cheja pa'isi'kʉpi eta pãi peocheja kueñe cajoopo Efraín vʉ'ejoopona sani canʉka pa'isi'kʉa'mʉ, chʉkʉna repaʉ neenana'me. ");
INSERT INTO coe_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Reparʉmʉ Jerusalén vʉ'ejoopo judíopãi repana fiestapi pascuarʉmʉpi tĩ'api'rakʉna repajoopo kueñe cana pãi jainʉko ũcuajoopona maniasome, aperʉmʉ chʉ̃'ʉ jo'kasi'ere cho'ojʉ cu'are tʉ'neñu chini. ");
INSERT INTO coe_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mani Dios vʉ'ere kaka pa'ijʉ Jesure ku'enajejʉ ija'che cutuasome repana sãiñechi'a: —¿Je'se cuasache mʉsanʉkona? ¿Icheja fiesta cho'ochejana raija'ʉ repaʉ? ¿Pãaja'ʉ? —chiniasome repana pãi. ");
INSERT INTO coe_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Phairipãi chʉ̃'ʉna fariseopãina'me ija'che i'kaasome: —Pãiʉ ũcuaʉakʉji repaʉ Jesús pa'ichejare masini rani kʉajʉ̃'ʉ chʉkʉna'te. Repaʉni chẽañu chiime chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Repaʉ Jesús seirepaumucujña pascuarʉmʉ tĩ'añe karatona Betania vʉ'ejoopona saisi'kʉa'mʉ, repaʉji vasoʉna Lázaro vajʉraisi'kʉ pa'ijoopona. ");
INSERT INTO coe_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sakʉna repajoopo cana, pãipi chi'i Jesuni pojoa'jʉ chini ãure cho'osinaa'me. Chi'irena Martapi ãure ãukona Jesuna'me ñu'ijʉ ãisinaa'me repana. Lázaro ũcuaja'che ũcuaʉna'me ñu'iʉ ãisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ũcuarʉmʉ repao María trescientos gramos pa'ira'ka okoma'ñara'ka nardochi'a cho'osira'kajekʉ rʉa ro'isira'kapi Jesús cũ'ana ro've pi'ni repao rañapapi tʉ'nesõkaisi'koa'mo. Ro'veona vʉ'e peore ma'ñasʉsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ũcuarʉmʉ Jesús neekʉ Judas Iscariote Jesuni cu'ache cho'oa'jʉ chini jo'kajaʉ i'kasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Je'se pa'iʉna repao trescientorepare're ĩsisõjʉ kuri denariore're koorʉra'kare rupʉ jañosõo? Ira'kare ĩsisõ kuri koo chʉova'na pa'iva'nani ĩsirʉja'chere rurepapʉ cho'osõmʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Chʉova'na pa'iva'nare oiche'te i'kamanesi'kʉa'mʉ repaʉ. Rupʉ ñaaʉjekʉ jã'aja'ñe i'kasi'kʉa'mʉ. Chʉkʉna Jesús neena chi'iche kuri paakaiʉ si'arʉmʉ te'ere'rechi'a siasõkaiʉ pa'isi'kʉa'mʉ repaʉ Judas. ");
INSERT INTO coe_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jã'aja'ñe i'kaʉna Jesús i'kasi'kʉa'mʉ. —Iko cho'oche ʉ̃semanejʉ̃'ʉ. Chʉ'ʉpi jũnisõʉna chʉ'ʉre tãumucuse chʉ'ʉ ca'nivʉ'te ro'vejara'kare care'va paamo repao. ");
INSERT INTO coe_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chʉova'na pa'iva'na mʉsanʉkonare si'arʉmʉ ja'me pa'ijava'naa'me. Jã'ajekʉna repanare si'arʉmʉ re'oja'che cho'okaijʉ pa'ire'oja'mʉ mʉsanʉkonare. Chʉ'ʉta'ni mʉsanʉkonare si'arʉmʉ ja'me pa'imaneja'mʉ. Jã'ajekʉna chʉ'ʉre si'arʉmʉ jã'aja'ñe cho'okaicu'aja'mʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ũcuarʉmʉ judíopãi jainʉko Jesús Betania vʉ'ejoopo pa'iche'te asa saniasome repaʉni ñañu chini. Ũcuachi'a jũnisõʉna Jesús vasosi'kʉni Lázaroni ñañu chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesús repaʉ'te vasosi'ere asa judíopãi jainʉko Jesure cuasajʉ jovoasome. Jã'ajekʉna phairipãi chʉ̃'ʉna, “Mai che'choche pãi jainʉko ũhasõ Jesuni cuasajʉ jovome”, chini pe'rujʉ Lázaroni vanisõñu chiniasome, Jesure vanisõñu chiicheja'che. ");
INSERT INTO coe_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ũcuarʉmʉ judíopãi repana fiestaji pascuarʉmʉpi tĩ'api'rakʉna Jerusalén vʉ'ejoopona jainʉko maniasome. Mani pa'ijʉ jo'e apeñatatona Jesús raijache asaasome repana. ");
INSERT INTO coe_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Asa pũti kare veri eta repaʉni tijña ʉjachʉ'opi ija'che i'kasinaa'me repana: —Dios peore masikʉ'mʉ. Ikʉre Israelpãire chʉ̃'ʉa'kʉ chini repaʉ Raosi'kʉre re'oja'che cho'okaaʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ũcuarʉmʉ repaʉ Jesús burrova'ʉre jñaa tuhisi'kʉa'mʉ. Dios chʉ'o aperʉmʉ tocha jo'kasi'e kʉache cho'osi'kʉa'mʉ. Ija'che kʉamʉ repa: ");
INSERT INTO coe_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ũcuanʉko vajʉchʉma'ñe pa'ijʉ̃'ʉ mʉsanʉkona Jerusalén vʉ'ejoopo cana. Mʉsanʉkonare chʉ̃'ʉkʉ'te burrochĩiva'ʉni tuhiʉ raiʉna ñajʉ̃'ʉ, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Reparʉmʉ chʉkʉna Jesús neena, “Dios chʉ'o kʉache'te cho'ome ina ikʉre”, chiimanesinaa'me. Repaʉ Jesús jũni vajʉrani cʉnaʉmʉ mʉisirʉmʉta'ni repa tocha jo'kasi'ere asamasijʉ, “Repa tochasi'e kʉache cho'osinaa'me pãi Jesure”, chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pãi Jesuni ja'me pa'ijʉ repaʉji Lázaroni jũnisõ tãcojñosi'kʉni soiʉna vajʉrani etaʉna ñasina chekʉnare kʉajʉ pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Diochi'a cho'omasiche Jesús cho'oche kʉajʉna asanajejʉ etasinaa'me repana pãi repaʉni tijñañu chini. ");
INSERT INTO coe_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jã'aja'ñe cho'ojʉna ña sãiñechi'a i'kasinaa'me fariseopãi. —Rʉa cu'amʉ ija'che pa'ito. Ñajʉ̃'ʉ. Pãi ũcuanʉko repaʉ'te jovome. Ʉ̃secu'amʉ jã'aja'ñe cho'oto —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fiestarʉmʉjekʉna Dios cho'okaisi'ere cuasajʉ pojoñu chini Jerusalén vʉ'ejoopona sani pa'inare griegopãi sani ja'me pa'isinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pa'ijʉ Galilea cheja cajoopo Betsaida vʉ'ejoopo cakʉre Felipe'te mʉa rʉa i'kaasome repana griegopãi. —Jesuni ñañu chiime chʉkʉna —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chitena asa mʉa Andreni kʉaasomʉ repaʉ. Kʉa ũcuaʉna'me Jesuni kʉañu chini mʉaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kʉarena asa Jesús i'kaasomʉ. —Chʉ'ʉ Dios Raosi'kʉ pa'iche'te pãi jainʉko masirʉmʉ tĩ'acuhaja'mʉ. “Rʉa masiʉ'mʉ ikʉ”, chiijanaa'me pãi chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ija'chea'me: Ãura'karʉã tãru charo joimʉ. Repacaãpi jonisõmaneni aineema'mʉ. Jonisõni ainee pi'ni repañʉ rʉa kʉ̃ija'mʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ũcuaja'che pãiʉ ũcuaʉakʉji repaʉ chiichechi'a cho'ora chiikʉ cu'ache pa'iʉ Dios pa'icheja saimaneja'mʉ. Pãiʉ Dios chʉ̃'ʉñe cho'ora chiikʉta'ni re'oja'che pa'iʉ repaʉ jũnisõsirʉmʉ Dios pa'ichejana ai sani re'oja'che pa'ija'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chʉ'ʉ chʉ̃'ʉñe cho'oñu chiinare, “Chʉ'ʉni jovojʉ̃'ʉ”, chiimʉ chʉ'ʉ. Chʉ'ʉre jovoni Dios pa'ichejare sani chʉ'ʉna'me pa'ijanaa'me repana. Chʉ'ʉ chʉ̃'ʉñe cho'onare re'oja'che cho'okaija'mʉ Dios, “Re'onaa'me ina”, chini —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ũcuarʉmʉ Jesús ija'che i'kaasomʉ: —Chura rʉa sʉma'mʉ chʉ'ʉre. Ja'kʉre, ¿je'se chiija'che chʉ'ʉ? “¿Chʉ'ʉre ti'jñejañe cu'ache ʉ̃sekaijʉ̃'ʉ”, chiija'che chʉ'ʉ? Pãara. Jã'are cho'ocojñora chini cajesi'kʉa'mʉ chʉ'ʉ —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ũcuarʉmʉ Pʉka'kʉre ija'che i'kasi'kʉa'mʉ repaʉ: —Ja'kʉ, mʉ'ʉ si'ache cho'omasiche'te cho'o ñora chini mʉ'ʉre ʉache cho'ojʉ̃'ʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ. Chikʉna cʉnaʉmʉpi chʉ'o i'kache asosi'kʉa'mʉ. —Chʉ'ʉ masiche si'ache cho'o ñocuhasi'kʉa'mʉ chʉ'ʉ. Jo'e cho'o ñora —chiisi'kʉa'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","I'kaʉna asa pãi te'ena ija'che i'kasinaa'me: —Okocurucosomʉ jã'a —chiisinaa'me. Chekʉnata'ni, —Angelpi ikʉni i'kacosomʉ jã'a —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chitena Jesús jo'e i'kasi'kʉa'mʉ. —Chʉ'ʉpi asaa'kʉ chini i'kasi'ema'mʉ jã'a. Mʉsanʉkonapi asaa'jʉ chini i'kasi'ea'me. ");
INSERT INTO coe_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chʉ'ʉre cuasamanajejʉ cu'ache pa'inare cu'ache ti'jñerʉmʉ tĩ'acuhamʉ. Ũcuachi'a cu'ache pa'ijʉ chʉ'ʉre cuasamanare chʉ̃'ʉkʉ'te vati aire ʉ̃serʉmʉ tĩ'acuhamʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Chʉ'ʉre jẽ'jo nʉkosirʉmʉ chʉ'ʉpi soiʉna pãi si'achejña pa'ina chʉ'ʉni cuasajʉ jovojanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Repaʉ'te kurususẽ'verona jẽ'jo nʉko vẽasõjañere repaʉ jã'aja'ñe i'kakʉ kʉasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jã'aja'ñe i'kaʉna asa i'kasinaa'me pãi. —Mai aipãi tocha jo'kasi'e Dios chʉ'o ija'che kʉamʉ: Cristo Dios Raosi'kʉ jũnisõma'ñe ai pa'ija'mʉ, chiimʉ. Jã'ata'ni mʉ'ʉ, ¿je'se pa'iʉna, “Pãire ja'me paaʉ chini Dios Raosi'kʉre jẽ'jo nʉkojanaa'me pãi”, chiikʉ? Jã'a pa'ito, Cristo chiicojñokʉ, ¿tĩiʉ'ʉ? —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chitena Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ icheja cheja pa'inare pãi Miañeja'ñe Pa'ikʉ mʉsanʉkonare jmamakarʉ ja'me pani sanisõja'mʉ. Jã'ajekʉna chuta'a miarʉmʉna churana ku'ijʉ̃'ʉ mʉsanʉkona, ru'ru na'isõmaneñu chini. Ru'ru na'isõni ñamipi ku'ijʉ ma'api ñomaʉna cavesʉsõjanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chʉ'ʉre Miañeja'ñe Pa'ikʉ'te chuta'a mʉsanʉkonare ja'me pa'irʉmʉna cuasajʉ̃'ʉ chʉ'ʉ pa'icheja'che re'oja'che pañu chini —chiisi'kʉa'mʉ repaʉ. Jã'aja'ñe i'ka pi'ni sani katisõsi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Repana ñajʉ'te Diochi'a cho'omasiche si'arʉmʉ cho'okʉ'teta'ni repaʉ'te Jesure cuasamanesinaa'me repana pãi. ");
INSERT INTO coe_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dios chʉ'o kʉakaisi'kʉ Isaías tocha jo'kasi'e kʉache cho'osinaa'me repana. Repaʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉre Paakʉ, mai kʉache jachajʉ cuasama'me pãi. Mʉ'ʉ masiche si'ache cho'o ñokʉ'teta'ni jachame pãi, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pãipi cuasavesʉjʉna repaʉ Isaías cheke ija'che tocha jo'kaasomʉ: ");
INSERT INTO coe_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ñakocaã ñamava'naja'ñe paapʉ chini jo'kaasomʉ Dios. Ũcuachi'a Repaʉ chʉ'o asavesache cho'oasomʉ repanare. Diopi jã'aja'ñe cho'oʉna, “Ikʉ maire vasoja'mʉ”, chiimapʉ chʉ'ʉre raima'me repana, chiiʉ tocha jo'kaasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Diopi ñokʉna Jesús Masiʉ pa'iche ñasi'kʉjekʉ repaʉ pa'iche'te kʉakʉ jã'aja'ñe tocha jo'kaasomʉ Isaías maire. ");
INSERT INTO coe_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Reparʉmʉ judíopãi jainʉko Jesuni cuhejʉ cuasamanesinaa'me. Chekʉnata'ni jachama'ñe cuasasinaa'me repaʉ'te. Ũcuachi'a repanare chʉ̃'ʉna te'ena cuasasinaa'me. Cuasanata'ni fariseopãire vajʉchʉjʉ kʉamanesinaa'me, “Kʉarena fariseopãipi asa mai judíopãi chi'ivʉ'e kakache'te ʉ̃sejʉ”, chini. ");
INSERT INTO coe_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ũcuachi'a repanare pãi pojoche'te na'a rʉa chiijʉ kʉamaneasome repana, “Kʉato pojoja'mʉ Dios maire”, chiimapʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ũcuarʉmʉ Jesús ʉjachʉ'opi ija'che i'kasi'kʉa'mʉ: —Pãi chʉ'ʉre cuasana chʉ'ʉrechi'a cuasama'me. Chʉ'ʉre Raosi'kʉre Diore ũcuachi'a cuasame repana. ");
INSERT INTO coe_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chʉ'ʉ pa'iche masina ũcuaja'che chʉ'ʉre Raosi'kʉ pa'iche masime. ");
INSERT INTO coe_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Chʉ'ʉ Miañeja'ñe Pa'ikʉ chejana raisi'kʉa'mʉ, pãi chʉ'ʉre cuasanapi chijacheja pa'ina pa'icheja'che cu'ache pa'imanea'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Chʉ'ʉ i'kache asanata'ni jachajʉ cho'omanare, “Jachasi'e ro'iche pa'imʉ”, chisa chini cajesi'kʉma'mʉ chʉ'ʉ. Chʉ'ʉre cuasanani chẽa paakʉ vati toa saiche'te ʉ̃sekasa chini cajesi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jã'ata'ni pãi chʉ'ʉni cuhejʉ chʉ'ʉ i'kache asana jachajʉ cho'omanesi'e ro'ijanaa'me Dios pãi ũcuanʉko cho'osi'e ro'iche chʉ̃'ʉumucuse. ");
INSERT INTO coe_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chʉ'ʉchi'a cuasache'te i'kama'mʉ chʉ'ʉ. Ja'kʉ, chʉ'ʉre Raosi'kʉ kʉache'te i'kamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iere masimʉ chʉ'ʉ: Ja'kʉ kʉache'te chʉ'ʉpi i'kakʉna pãipi asa chẽa cho'ona Repaʉ pa'ichejana ai sani pa'ijanaa'me. Jã'ajekʉna Ja'kʉ chʉ'ʉre kʉache'techi'a i'kakʉ'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Reparʉmʉ pascuarʉmʉ tĩ'aumucuse pa'isi'kʉa'mʉ. Reparʉmʉ Jesús repaʉ saijarʉmʉ tĩ'akʉna masiasomʉ icheja cheja pa'iche jo'ka Pʉka'kʉ pa'icheja saijachere. Chʉkʉna'te repaʉ neenare cheja pa'inare cuhama'ñe si'arʉmʉ rʉa cuasakʉ pa'isi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Simón Iscariote mamakʉni Judare aperʉmʉ vati aipi repaʉ rekochona cu'ache chʉ̃'ʉasomʉ, Jesure cu'ache cho'ojanani jo'kaa'kʉ chini. Repaʉ Jesús Pʉka'kʉ Dios repaʉ'te raosi'ena'me repaʉ pa'icheja repaʉ jo'e saijachena'me pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini Pʉka'kʉ repaʉ'te jo'kasi'e masiasomʉ. Jã'aja'ñe masikʉji chʉkʉna repaʉ neenana'me ãu ãiʉ ñu'isi'kʉpi vʉni repaʉ sẽ'sevʉ ju'ikãa tĩto repaʉ jiisaivʉna toalla kãapi quẽosi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Quẽo pi'ni totore'avana oko ro chʉkʉna repaʉ neena cũ'are choa pi'ni ũcuakãapi jose tʉ'nesõkaisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Choakʉ saiʉ Simón Pedro cũ'a choapi'rakʉna ija'che i'kasi'kʉa'mʉ repaʉ: —Chʉ'ʉre Paakʉ, ¿chʉ'ʉ cũ'are choaja'ʉ mʉ'ʉ? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chikʉna Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ chura cho'oche vesʉmʉ mʉ'ʉ. Na'a pa'isirʉmʉ masija'mʉ mʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chikʉna Pedro jo'e i'kasi'kʉa'mʉ repaʉ'te. —Chʉ'ʉ cũ'a choache ʉ̃semʉ chʉ'ʉ —chiisi'kʉa'mʉ. Chikʉna Jesús i'kasi'kʉa'mʉ. —Mʉ'ʉ cũ'a choache ʉ̃seni chʉ'ʉ neekʉ pa'imaneja'mʉ mʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jã'aja'ñe i'kaʉna i'kasi'kʉa'mʉ repaʉ. —Jã'a pa'ito, Chʉ'ʉre Paakʉ, chʉ'ʉre cũ'ana'me jʉ̃jña sĩjopʉ peore choajʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Pãiʉ cucha pi'nisi'kʉ jo'e cuchache chiima'mʉ ũcuare meno peoca'nivʉ cuchasi'kʉjekʉ. Cũ'achi'a choache chiimʉ cha'o cha'casicũ'ajekʉna. Ũcuaja'che mʉsanʉkona rekoñoã cuchasinaja'ñe cu'achejẽ'e peonaa'me. Jã'ata'ni mʉsanʉkonare ja'me pa'ikʉ te'eʉ repaʉ rekocho ũcua cu'ache cuasakʉ pa'imʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Repaʉ'te cu'ache cho'ojanare jo'kajaʉni masikʉ, “Mʉsanʉkonare ja'me pa'ikʉ te'eʉ repaʉ rekocho ũcua cu'ache cuasakʉ pa'imʉ”, chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chʉkʉna cũ'a choa pi'ni repaʉ sẽ'sevʉ ju'ikãa sacha jo'e pʉʉ ñu'iʉ i'kasi'kʉa'mʉ repaʉ. —¿Chʉ'ʉ mʉsanʉkonare cho'osi'e masiche? ");
INSERT INTO coe_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Chʉ'ʉre mʉsanʉkona, “Masiʉ, Chʉkʉna'te Paakʉ”, chiinaa'me. Jã'aja'ñe i'kajʉ ũcuarepa i'kanaa'me mʉsanʉkona. Mʉsanʉkonare che'chokʉ paakʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mʉsanʉkonare paakʉta'ni cũ'a choakaisi'kʉa'mʉ chʉ'ʉ. Jã'ajekʉna mʉsanʉkona ũcuaja'che chʉ'ʉ cho'osi'eja'che sãiñechi'a cho'okaijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʉsanʉkonapi ña chẽa cho'ojʉ paapʉ chini cho'o ñocuhasi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cho'oche'te rupʉ cho'okaaʉ chini chẽa paacojñokʉ repaʉ paakʉ'te na'a cajejaiche pa'ikʉma'mʉ. Saocojñosi'kʉ ũcuachi'a repaʉ'te saosi'kʉre na'a cajejaiche pa'ikʉma'mʉ. Ũcuarepaa'me jã'a. Mʉsanʉkona ũcuaja'che chʉ'ʉre na'a cajejaiche pa'inama'me. Jã'ajekʉna mʉsanʉkonare chʉ'ʉ cho'ocheja'che sãiñechi'a re'oja'che cho'okaijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mʉsanʉkonapi chʉ'ʉ i'kasi'ere asa chẽa cho'ojʉ pani pojojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Jã'ata'ni mʉsanʉkona ũcuanʉkore i'kama'mʉ chʉ'ʉ. Chʉ'ʉ chẽasina pa'iche masimʉ chʉ'ʉ. Dios chʉ'o tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉre ja'me ãu ãikʉji cu'ache cho'oja'mʉ chʉ'ʉre, chiimʉ. Repa tocha jo'kasi'e ũcuarepa ti'jñeja'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chuta'a repa tocha jo'kasi'e ti'jñemarʉmʉna kʉamʉ chʉ'ʉ mʉsanʉkonare, asa repapi ti'jñeʉna, “Jesús Dios Raosi'kʉa'mʉ”, chiijʉ cuasaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Pãi chʉ'ʉ saosinare pojona chʉ'ʉre ũcuaja'che pojome. Pãi chʉ'ʉre pojona chʉ'ʉ Ja'kʉre ũcuaja'che pojome. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jã'aja'ñe i'ka pi'ni Jesús rʉa sʉmava'ʉ pa'iʉ ija'che i'kasi'kʉa'mʉ: —Mʉsanʉkonare ja'me pa'ikʉ chʉ'ʉni cu'ache cho'oa'jʉ chini chʉ'ʉre cuhenani jo'kaja'mʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","I'kakʉna asa repaʉni vesʉjʉ sãiñechi'a ñasinaa'me chʉkʉna repaʉ neena. ");
INSERT INTO coe_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chʉ'ʉ repaʉ neekʉ rʉa chiicojñokʉ repaʉ'te rʉ̃'ʉñe ñu'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ũcuarʉmʉ Simón Pedro chʉ'ʉre Jesure rʉ̃'ʉñe ñu'ikʉjekʉna repaʉ'te jo'kajaʉni sẽniasa kʉaa'kʉ chini rupʉ vevosi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Vevoʉna sẽesi'kʉa'mʉ chʉ'ʉ Jesure. —Chʉkʉna'te Paakʉ, ¿kaʉni i'kakʉ mʉ'ʉ, mʉ'ʉre cu'ache cho'ojanare jo'kajaʉre? —chiisi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Pãmakarʉ'te chũsa ĩsija'mʉ chʉ'ʉ repaʉ'te chʉ'ʉre jo'kajaʉre —chiisi'kʉa'mʉ. Chini pãmaka chũsa Simón Iscariote mamakʉni Judani ĩsisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pãmakare ĩsiʉna koosirʉmʉ repaʉ'te vati ai teana kakaasomʉ. Kakaʉna Jesús repaʉ'te i'kasi'kʉa'mʉ. —Mʉ'ʉ cho'ojache pesa cho'ojaijʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesús repaʉ'te i'kasi'e ãu ãijʉ ñu'ina ũcuanʉko asavesʉsinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Asavesʉjʉ ija'che cuasaasome te'ena: “Chʉkʉna chi'isi'e kuri paakaikʉjekʉna Judare pascua cho'ojamajñarʉã koojaaʉ chini saocosomʉ Jesús”, chiisinaa'me. Chekʉna ija'che cuasaasome: “Judapi chʉova'na pa'iva'nare kurire ĩsia'kʉ chini saocosomʉ Jesús”, chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Repaʉ Judas pãmaka koo ãni pi'ni vʉni eta sanisõsi'kʉa'mʉ. Reparʉmʉ ñami pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Repaʉ Judas etasirʉmʉ Jesús ija'che i'kasi'kʉa'mʉ: —Chura chʉ'ʉ Dios Raosi'kʉ peore Masiʉ pa'iche ñoja'mʉ Dios. Ũcuachi'a Repaʉ chiiche'te chʉ'ʉpi jachama'ñe cho'o ñoʉna Repaʉ peore masiche'te masijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chʉ'ʉpi Repaʉ peore Masiʉ pa'iche'te cho'o ñoʉna Repaʉ ũcuaja'che chʉ'ʉ peore Masiʉ pa'iche cho'o ñoja'mʉ. Chura ñoja'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Asarepajʉ̃'ʉ, chʉ'ʉ chĩiva'na. Mʉsanʉkonare rʉa jeerʉmʉ ja'me pa'ima'ñe jo'ka sanisõja'mʉ chʉ'ʉ. Chʉ'ʉpi sanisõʉna ku'ejanaa'me mʉsanʉkona chʉ'ʉre. Jã'ajekʉna chura mʉsanʉkonani judíopãi chʉ̃'ʉnare i'kasi'eja'che i'kamʉ chʉ'ʉ: “Mʉsanʉkonare chʉ'ʉ saicheja saicu'amʉ.” ");
INSERT INTO coe_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ie mamare chʉ̃'ʉ jo'kamʉ chʉ'ʉ mʉsanʉkonare: Sãiñechi'a oijʉ pa'ijʉ̃'ʉ. Chʉ'ʉ mʉsanʉkonare oicheja'che mʉsanʉkona ũcuaja'che sãiñechi'a oijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉsanʉkonapi sãiñechi'a oijʉ pa'ito pãipi ñani ũcuanʉko, “Jesús neenaa'me ina”, chiijanaa'me —chiisi'kʉa'mʉ repaʉ Jesús chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ũcuarʉmʉ Simón Pedro Jesure sẽesi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, ¿jeechejana saija'ʉ mʉ'ʉ? —chiisi'kʉa'mʉ. Chikʉna Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ saicheja saicu'amʉ mʉ'ʉre chura. Na'a pa'isirʉmʉta'ni saire'oja'mʉ mʉ'ʉre —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chikʉna Pedro i'kasi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, ¿je'se pa'iʉna mʉ'ʉna'me churana saicu'akʉ chʉ'ʉre? Pãipi mʉ'ʉni vanisõñu chiito chuenisõñejẽ'e vajʉchʉma'ñe mʉ'ʉni ʉ̃sechiiʉ chuenisõra chiimʉ chʉ'ʉ, mʉ'ʉpi chuenisõmanea'kʉ chini —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chikʉna Jesús i'kasi'kʉa'mʉ. —¿Chuenisõkairepaja'ʉ mʉ'ʉ chʉ'ʉre? Jã'aja'ñe i'kasi'kʉta'ni chuta'a kura chu'ima'tona pãipi sẽejʉna choteñoã, “Jesure ñama'kʉa'mʉ chʉ'ʉ”, chiija'mʉ mʉ'ʉ. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenare i'kasi'kʉa'mʉ. —Sʉmava'na pa'imanejʉ̃'ʉ mʉsanʉkona. “Diopi cho'okaiʉna vajʉchʉma'ñe pañu”, chini Repaʉni masi cuasajʉ̃'ʉ. Ũcuaja'che, “Ikʉ Jesupi cho'okaiʉna vajʉchʉma'ñe pañu”, chini chʉ'ʉni masi cuasajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chʉ'ʉ Ja'kʉ pa'ichejare cʉnaʉmʉre vʉ'ña rʉa pa'imʉ. Jã'aja'ñe peoto kʉara'asi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. Ũcuachejana saimʉ chʉ'ʉ mʉsanʉkona pa'ijavʉ'ñare care'vakasa chini. ");
INSERT INTO coe_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Care'va pi'ni jo'e ichejana rani ũcuachejana saja'mʉ chʉ'ʉ mʉsanʉkonare, chʉ'ʉ pa'ichejare ja'me sani paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Chʉ'ʉ saicheja saima'a masime mʉsanʉkona —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chikʉna Tomás i'kasi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, mʉ'ʉ saichejare vesʉjʉ repacheja saima'ajẽ'e vesʉme chʉkʉna —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chikʉna Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ Ja'kʉ pa'icheja saima'aja'ñe pa'ikʉ'mʉ chʉ'ʉ. Jã'ajekʉna chʉ'ʉre cuasanachi'a Repaʉ pa'icheja saijanaa'me. Ja'kʉ pa'iche ũcuarepare kʉakʉ'mʉ chʉ'ʉ. Chʉ'ʉre cuasanapi jũnisõsirʉmʉ Dios pa'icheja ai sani paapʉ chini chʉ'ʉpi jo'kaʉna repanachi'a Repaʉ pa'icheja ai sani pa'ijanaa'me. Chʉ'ʉre cuasamanata'ni Dios pa'icheja saimanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mʉsanʉkonapi chʉ'ʉ pa'iche masini Ja'kʉ pa'iche ũcuaja'che masira'ame. Churana Ja'kʉ pa'iche masime mʉsanʉkona chʉ'ʉre ñanajejʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chikʉna Felipe jo'e i'kasi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, mʉja'kʉni ñojʉ̃'ʉ chʉkʉna'te. Ñoru pojosõjanaa'me chʉkʉna —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Felipe, asarepajʉ̃'ʉ. ¿Chʉ'ʉre mʉsanʉkonare rʉa jeerʉmʉ ja'me pa'ikʉ'te chʉ'ʉ pa'iche chuta'a vesʉkʉ mʉ'ʉ? Pãi chʉ'ʉ pa'iche ñana Ja'kʉ pa'iche ũcuaja'che ñame. Jã'ata'ni, ¿je'sejekʉna mʉ'ʉ chʉ'ʉre, “Mʉja'kʉni ñojʉ̃'ʉ chʉkʉna'te”, chiikʉ? ");
INSERT INTO coe_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Chʉ'ʉna'me Ja'kʉ ũcuate'eʉja'che pa'inaa'me chʉkʉna. ¿Jã'a mʉsanʉkona cuasama'ñe? Chʉ'ʉ i'kache chʉ'o chʉ'ʉchi'a cuasakʉ i'kachema'mʉ. Ja'kʉ kʉachechi'a i'kakʉ'mʉ chʉ'ʉ. Ũcuachi'a Repaʉji ja'me pa'iʉ cho'okaiʉna Repaʉchi'a cho'omasiche'te cho'okʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chʉ'ʉ i'kasi'e jachamanejʉ̃'ʉ mʉsanʉkona, “Chʉ'ʉna'me Ja'kʉ ũcuate'eʉja'che pa'inaa'me chʉkʉna”, chiisi'e. Mʉsanʉkonapi chʉ'ʉ i'kasi'ere asa jachanijẽ'e chʉ'ʉpi Diochi'a cho'omasiche'te cho'okʉna ñani jachama'ñe cuasajʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chʉ'ʉre cuasana chʉ'ʉ Diochi'a cho'omasiche cho'ocheja'che cho'ojanaa'me. Ũcuaja'che chʉ'ʉ sanisõsirʉmʉ chʉ'ʉ cho'osi'eja'che na'a rʉa vesache'te cho'ojanaa'me repana, chʉ'ʉ Ja'kʉ pa'ichejana sakʉna. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mʉsanʉkonapi chʉ'ʉ Ja'kʉni sẽejʉ, “Chʉkʉna'te Jesús neenajejʉna cho'okaijʉ̃'ʉ chʉkʉna sẽeñe”, chiijʉ sẽeto cho'okaija'mʉ chʉ'ʉ, Repaʉ peore Cho'omasikʉjekʉ mʉsanʉkonare oiʉ cho'okaiche'te pãipi masia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mʉsanʉkonapi chʉ'ʉni ũcuaʉache'te sẽejʉ, “Chʉkʉna'te mʉ'ʉ neenajejʉna cho'okaijʉ̃'ʉ chʉkʉna sẽeñe”, chiijʉ sẽeto cho'okaija'mʉ chʉ'ʉ mʉsanʉkonare —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Mʉsanʉkonapi chʉ'ʉre chini chʉ'ʉ chʉ̃'ʉñe cho'ojʉ pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ja'kʉni sẽekaimʉ chʉ'ʉ mʉsanʉkonare chʉ'ʉ cho'okaicheja'che Cho'okaijarekocho'te Repaʉ Rekocho'te chʉ'o ũcuarepa Kʉarekocho'te raoa'kʉ chini, raoʉna mʉsanʉkonani si'arʉmʉ ja'me pa'iʉ cho'okaiʉ paaʉ chini. Diore cuasamana Repaʉ Rekocho cho'ochejẽ'e vesʉjʉ Reparekocho pa'ichejẽ'e vesʉme. Vesʉjʉna Repaʉ Rekocho paacu'amʉ repanare. Dios Rekochoji mʉsanʉkonare ja'me pa'iʉ mʉsanʉkona rekoñoãre si'arʉmʉ ja'me Pa'ijarekocho pa'iche masijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Mʉsanʉkonare chʉviva'nareja'che jo'kamaneja'mʉ chʉ'ʉ. Jo'kaja'mʉ chʉ'ʉ mʉsanʉkonare. Jã'ata'ni jmamakarʉ pani jo'e rani ja'me pa'ija'mʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jmamakarʉ pa'isirʉmʉ Diore cuasamana jo'e ñamanejanaa'me chʉ'ʉre. Mʉsanʉkona chʉ'ʉpi jũnisõsi'kʉta'ni jo'e vajʉrakʉna ñajanaa'me. Chʉ'ʉ jũni vajʉraisi'eja'che mʉsanʉkona ũcuaja'che chʉ'ʉre cuasana jũnisõsinata'ni vajʉrani Dios pa'icheja ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dios Rekocho mʉsanʉkonare raiumucuse chʉ'ʉna'me Ja'kʉ ũcuate'eʉja'che pa'iche masijʉ mʉsanʉkonare chʉ'ʉ ja'me pa'ichena'me chʉ'ʉre mʉsanʉkona ja'me pa'iche masijanaa'me mʉsanʉkona repaumucuse. ");
INSERT INTO coe_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chʉ'ʉ chʉ̃'ʉñe asa jachama'ñe cho'ona chiime chʉ'ʉre. Chʉ'ʉre chiinare Ja'kʉ ũcuaja'che chiimʉ. Chʉ'ʉ ũcuaja'che repanare chiiʉ chʉ'ʉ pa'iche ñoja'mʉ masia'jʉ chini —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ũcuarʉmʉ chekʉ Judas, Iscariotema'kʉpi, ija'che i'kasi'kʉa'mʉ: —Chʉkʉna'te Paakʉ, mʉ'ʉ pa'iche chʉkʉna'techi'a ñoja'mʉ chiisi'kʉa'mʉ. ¿Je'se pa'iʉna chekʉnare pãi ñomaneja'ʉ? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chikʉna Jesús i'kasi'kʉa'mʉ. —Pãi chʉ'ʉre chiina chʉ'ʉ chʉ̃'ʉsi'e asa jachama'ñe cho'ojanaa'me. Chʉ'ʉ Ja'kʉ repanare chiimʉ. Chʉ'ʉ Ja'kʉna'me rani ja'me pa'ijanaa'me chʉkʉna repanare. ");
INSERT INTO coe_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Chʉ'ʉre cuhenata'ni chʉ'ʉ chʉ̃'ʉñe asa jachajʉ cho'oma'me. Chʉ'ʉchi'a te'eʉ cuasache'te i'kama'mʉ mʉsanʉkonare. Chʉ'ʉre Raosi'kʉ Ja'kʉ kʉachechi'a i'kakʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Irʉmʉ mʉsanʉkonare ja'me pa'irʉmʉna teana iere peore i'kamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Chʉ'ʉ mʉsanʉkonare cho'okaisi'eja'che Cho'okaijarekocho'te Repaʉ Rekocho'te raoja'mʉ Dios. Raoʉna mʉsanʉkonare Dios chʉ'o peore che'choja'mʉ Reparekocho, mʉsanʉkonapi chʉ'ʉ i'kasi'ere cavesʉma'ñe cuasajʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Saipi'rakʉ mʉsanʉkona rekoñoãre pojojʉ pa'iche'te jo'kamʉ chʉ'ʉ. Chʉ'ʉre cuasamana pojojʉ pa'icheja'chema'mʉ chʉ'ʉ jo'kache. Vajʉchʉma'ñe pa'ijʉ sʉmava'na pa'imanejʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chʉ'ʉ i'kasi'e asasinaa'me mʉsanʉkona, “Saimʉ chʉ'ʉ. Jã'ata'ni jo'e rani mʉsanʉkonare ja'me pa'ija'mʉ chʉ'ʉ”, chiisi'e. Mʉsanʉkonapi chʉ'ʉre chiirepana pani chʉ'ʉre na'a rʉa Masikʉ Ja'kʉ pa'icheja chʉ'ʉ saijache asa pojokaira'ame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Chuta'a chʉ'ʉ saimarʉmʉna jã'are kʉamʉ chʉ'ʉ mʉsanʉkonare, reparʉmʉpi tĩ'aʉna chʉ'ʉni jachama'ñe cuasaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Chura jmanʉkorʉ kʉache paamʉ chʉ'ʉ mʉsanʉkonare. Chura chʉ'ʉre cuasamanare paakʉji vati aipi chʉ̃'ʉʉna pãi raipi'rame, chʉ'ʉni chẽa sa cu'ache cho'oñu chini. Chʉ'ʉreta'ni paama'kʉa'mʉ repaʉ vati ai. ");
INSERT INTO coe_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ja'kʉ chʉ̃'ʉsi'e peore cho'okʉ'mʉ chʉ'ʉ, pãipi ña Ja'kʉre chʉ'ʉ chiiche'te masia'jʉ chini. Re'omʉ. Jʉna, mʉañu —chiisi'kʉa'mʉ repaʉ chʉkʉna'te repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ũcuarʉmʉ Jesús chʉkʉna'te repaʉ neenani chʉ'vakʉ ija'che i'kasi'kʉa'mʉ: —Ʉcherepañʉ pa'icheja'che pa'ikʉ'mʉ chʉ'ʉ. Chʉ'ʉ Ja'kʉta'ni ʉcheñʉ paakʉja'che pa'ikʉ'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jã'ajekʉna repañʉ kapi ũcuaʉakapi ʉche kʉ̃ima'to tʉ'sesõmʉ Repaʉ repaka. Kʉ̃itota'ni repañʉ care'vakʉjekʉ repakapi na'a rʉa kʉ̃aʉ chini repaka pa'ikarʉãre cu'akarʉãre verisõmʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Repañʉ kapi na'a rʉa kʉ̃aʉ chini care'vakʉ cho'ocheja'che Dios mʉsanʉkona chʉ'ʉ che'choche Dios chʉ'o asa chẽana rekoñoãre ũcuaja'che care'vamʉ Dios, si'arʉmʉ na'a re'oja'che paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chʉ'ʉni si'arʉmʉ cuasajʉ mʉsanʉkona rekoñoã chʉ'ʉna'me pa'ijʉ̃'ʉ. Chʉ'ʉ mʉsanʉkonare si'arʉmʉ cuasakʉ mʉsanʉkonana'me pa'ija'mʉ. Ʉche kapi repañʉ'te sʉ'imaneni ʉchecha'cha kʉ̃ima'mʉ. Ũcuaja'che mʉsanʉkonapi chʉ'ʉni si'arʉmʉ cuasajʉ pa'imaneni re'oja'che pa'imanejanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ʉcheñʉ pa'icheja'che pa'ikʉ'mʉ chʉ'ʉ. Mʉsanʉkona chʉ'ʉre cuasana repañʉ ka re'oja'che kʉ̃iñeja'ñe pa'inaa'me. Mʉsanʉkona rekoñoã chʉ'ʉna'me pani chʉ'ʉpi mʉsanʉkonani ja'me pa'iʉ cho'okaiʉna si'arʉmʉ na'a re'oja'che pa'ijanaa'me. Chʉ'ʉpi cho'okaima'to re'oja'che pa'imanejanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mʉsanʉkona rekoñoã chʉ'ʉna'me pa'imaneni ʉche ka kʉ̃imanesika cho'ocojñoñeja'ñe cho'ocojñojanaa'me, pãi veri sẽjo jũkʉna ʉosõñeja'ñe. ");
INSERT INTO coe_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mʉsanʉkona chʉ'ʉre cuasache'te ũhama'ñe chʉ'ʉna'me pa'ijʉ chʉ'ʉ che'choche'te cho'ojʉ mʉsanʉkonare ʉache ũcuaʉache'te sẽejʉ̃'ʉ chʉ'ʉre. Sẽeto ĩsija'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mʉsanʉkonapi re'oja'che pa'ijʉna chekʉnapi ñani, “Ina Jesús neena, Diopi cho'okaiʉna, re'oja'che pa'inaa'me”, chini Diore pojojanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Chʉ'ʉre Ja'kʉ oicheja'che mʉsanʉkonare oimʉ chʉ'ʉ. Chʉ'ʉ oiche cuhema'ñe mʉsanʉkona rekoñoã chʉ'ʉna'me pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ja'kʉ chʉ̃'ʉñe jachama'ñe cho'okʉjekʉ Repaʉ oicojñokʉ'mʉ chʉ'ʉ. Mʉsanʉkona ũcuaja'che chʉ'ʉ chʉ̃'ʉñe'te asa jachama'ñe cho'oni chʉ'ʉ oicojñona pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mʉsanʉkonapi chʉ'ʉ pojokʉ pa'icheja'che si'arʉmʉ pojojʉ paapʉ chini jã'are peore i'kamʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ija'che paapʉ chini chʉ̃'ʉmʉ chʉ'ʉ mʉsanʉkonare: Chʉ'ʉ mʉsanʉkonare oicheja'che sãiñechi'a oijʉ pa'ijʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pãiʉ repaʉ'te ja'me pa'ikʉji repaʉ'te cu'ache cho'oche'te ʉ̃sekʉ jũnisõñejẽ'e cuhema'ñe chuenisõkʉ repaʉ'te ja'me pa'ikʉ'te oirepamʉ repaʉ. Oiʉ repaʉ cho'okaisi'eja'che cheke jo'e na'a rʉa oiʉ cho'okaichejẽ'e peomʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mʉsanʉkonapi chʉ'ʉ chʉ̃'ʉñe'te cho'oni chʉ'ʉna'me pa'ijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Chʉ'ʉre cho'oche cho'okainaa'me ina”, chiima'mʉ chʉ'ʉ chura mʉsanʉkonare. Cho'oche cho'okaina repanare paakʉ cho'oche vesʉme, kʉamaʉna. Chʉ'ʉta'ni, “Chʉ'ʉre ja'me pa'inaa'me ina”, chiimʉ chʉ'ʉ mʉsanʉkonare. Jã'ajekʉna chʉ'ʉre Ja'kʉ i'kasi'e peore kʉasi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉsanʉkonapi chẽamanesinaa'me chʉ'ʉre. Chʉ'ʉa'mʉ mʉsanʉkonare chẽasi'kʉ. Chẽa paakʉ iere chʉ̃'ʉ jo'kamʉ chʉ'ʉ: Si'arʉmʉ cuhama'ñe re'oja'che cho'ojʉ pa'ijʉ̃'ʉ, chekʉnapi ña chẽa chʉ'ʉni cuasaa'jʉ chini. Jã'aja'ñe cho'ojʉ mʉsanʉkonare ʉache'te Dioni sẽeto cho'okaija'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ija'che paapʉ chini chʉ̃'ʉmʉ chʉ'ʉ mʉsanʉkonare: Sãiñechi'a oijʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Diore cuasamanapi mʉsanʉkonare cuhejʉna repana chʉ'ʉre charo cuhesi'ere cuasajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mʉsanʉkonapi Diore cuasamana pa'ito chiira'ame repana mʉsanʉkonare repana pa'icheja'che pa'inajejʉna. Aperʉmʉ repana cuasacheja'che cuasasinaa'me mʉsanʉkona. Chura chʉ'ʉpi mʉsanʉkonare chẽa paakʉna repana cuasacheja'che cuasama'me mʉsanʉkona. Jã'ajekʉna repana mʉsanʉkonare cuheme. ");
INSERT INTO coe_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chʉ'ʉ mʉsanʉkonare ija'che i'kasi'e cavesʉmanejʉ̃'ʉ, “Cho'oche cho'okaikʉ repaʉ paakʉ'te na'a rʉa pa'ikʉma'mʉ”, chiisi'ere. Chʉ'ʉre cuhejʉ cu'ache cho'ona mʉsanʉkonare ũcuaja'che cuhejʉ cu'ache cho'ojanaa'me. Chʉ'ʉ chʉ'vache asa jachama'ñe cho'onapi mʉsanʉkona chʉ'vache ũcuaja'che asa jachama'ñe cho'ojanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chʉ'ʉ neenajejʉna mʉsanʉkonare jã'aja'ñe cho'ojanaa'me repana chʉ'ʉre Raosi'kʉ pa'iche vesʉnajejʉ. ");
INSERT INTO coe_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Chʉ'ʉ repanare rani chʉ'vama'to repana cu'ache cho'oche vesʉra'ame repana. Jã'ata'ni chura chʉ'ʉpi rani chʉ'vakʉna asasinajejʉna, “Vesʉjʉ cho'osinaa'me chʉkʉna”, chiicu'amʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pãi chʉ'ʉre cuhena chʉ'ʉ Ja'kʉre ũcuachi'a cuheme. ");
INSERT INTO coe_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Chʉ'ʉpi chekʉna pãi cho'omanesi'e Diochi'a cho'omasiche'te rani cho'o ñoma'to ro'iche peora'asi'kʉa'mʉ repanare. Jã'ata'ni chʉ'ʉ cho'oche ñasinata'ni chʉ'ʉre cuheme repana, chʉ'ʉ Ja'kʉre ũcuachi'a. Jã'ajekʉna ro'iche pa'imʉ repanare jachasinajejʉna. ");
INSERT INTO coe_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aperʉmʉ tocha jo'kasi'e Dios chʉ'o repana cho'ojachere ija'che kʉamʉ: Chʉ'ʉre rupʉ peoche cuheme repana, chiimʉ. Repa tocha jo'kasi'e ũcuare cho'ocuhame repana chʉ'ʉre cuhena. ");
INSERT INTO coe_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Chʉ'ʉpi sẽkʉna Ja'kʉ mʉsanʉkonare Repaʉ Rekocho'te raoja'mʉ, mʉsanʉkonare cho'okaiʉ chʉ'o ũcuarepa Kʉajarekocho'te. Raoʉna rani mʉsanʉkonare chʉ'ʉ pa'iche'te kʉaja'mʉ Reparekocho. ");
INSERT INTO coe_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mʉsanʉkona ũcuaja'che chʉ'ʉ apeche'chorʉmʉpi irʉmʉjatʉ'ka chʉ'ʉre ja'me pa'ijʉ ñanajejʉ chekʉnani kʉajʉ pa'ijʉ̃'ʉ chʉ'ʉ pa'iche'te —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Chʉ'ʉre cuasache'te ũhasõmanea'jʉ chini mʉsanʉkonare jã'are peore kʉamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pãi mʉsanʉkonare chʉ'ʉre cuasanajejʉna mai judíopãi chi'ivʉ'ña kakache ʉ̃sejanaa'me. Na'a pa'isirʉmʉ pãiʉ ũcuaʉakʉji pãiʉ'te chʉ'ʉre cuasakʉni vanisõni, “Diore cho'oche cho'okaikʉ'mʉ chʉ'ʉ”, chiiʉ cuasaja'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Reparʉmʉ mʉsanʉkonare jã'aja'ñe cho'ojana chʉ'ʉrejẽ'e Ja'kʉrejẽ'e vesʉnajejʉ jã'aja'ñe cho'ojanaa'me repana mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jã'ajekʉna mʉsanʉkonare churana teana peore kʉamʉ chʉ'ʉ jã'a, jã'aja'ñe cho'orʉmʉ tĩ'aru, “Maire Paakʉ kʉasi'epi ti'jñecuhamʉ maire”, chiijʉ cuasaa'jʉ chini —chiisi'kʉa'mʉ repaʉ. Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Chʉ'ʉ apeche'chorʉmʉ mʉsanʉkonani ja'me pa'iʉ chuta'a saimaʉ mʉsanʉkonare ti'jñejañe kʉamanesi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Chura chʉ'ʉre Raosi'kʉni ja'me pasa chini co'imʉ chʉ'ʉ. Te'eʉjẽ'e mʉsanʉkona chʉ'ʉre, “¿Jeechejana saikʉ mʉ'ʉ?”, chiima'me. ");
INSERT INTO coe_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chʉ'ʉpi mʉsanʉkonani chʉ'ʉ saijachena'me mʉsanʉkonare ti'jñejañe kʉaʉna sʉma'mʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Chʉ'ʉ saima'to Dios Rekocho mʉsanʉkonare ja'me pa'iʉ Cho'okaijarekocho raimaneja'mʉ mʉsanʉkona rekoñoã. Chʉ'ʉpi sanita'ni Dios Rekocho raoja'mʉ. Jã'ajekʉna chʉ'ʉpi mʉsanʉkonani jo'ka sanisõru, na'a re'oja'mʉ mʉsanʉkonare. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Dios Rekochoji rani pãi rekoñoãna kʉakʉna repana rekoñoã cu'ache pa'iche cuasa masijanaa'me repana. Ũcuachi'a Dios chiiche rũhiñe pa'iche Repaʉ Rekochoji kʉakʉna masijanaa'me repana. Ũcuachi'a cu'ache cho'oche ũhamana ro'ijache Dios Rekochoji kʉakʉna masijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dios Rekochoji kʉaʉna, “Jesucristoni cuasamapʉ cu'ache cho'ojʉ pa'ime mai”, chiijʉ masijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chʉ'ʉ Ja'kʉ pa'ichejana co'isõʉna pãi chʉ'ʉre jo'e ñamanejanaa'me. Jã'ata'ni Dios Rekochoji kʉaʉna chʉ'ʉ rũhiñe pa'iche masijanaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chʉ'ʉpi icheja cheja pa'inare chʉ̃'ʉkʉni vati aini cajejanisõʉna repaʉ cu'ache cho'okʉ pa'iche peore ro'ija'mʉ repaʉ. Jã'a peore masijanaa'me pãi, Dios Rekochoji kʉaʉna. ");
INSERT INTO coe_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Chʉ'o na'a rʉa i'kache paamʉ chʉ'ʉ. Jã'ata'ni chura kʉama'mʉ chʉ'ʉ. Churana teana kʉatojẽ'e asa chẽamanera'ame mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dios Rekochoji chʉ'o ũcuarepa Kʉarekochoji rani Dios chʉ'o ũcuarepare peore karama'ñe kʉaʉna asa masijanaa'me mʉsanʉkona. Jã'ata'ni Reparekocho Te'erekocho cuasakʉ kʉamaneja'mʉ. Asasi'echi'a kʉaja'mʉ na'a pa'isirʉmʉ ti'jñejañere. ");
INSERT INTO coe_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dios Rekochoji chʉ'ʉ i'kachena'me chʉ'ʉ cho'oche kʉaʉna asa chʉ'ʉ Masiʉ pa'iche masijanaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ja'kʉpi i'kaʉna asa jo'e ũcuare i'kamʉ chʉ'ʉ. Jã'ajekʉna, “Chʉ'ʉ i'kachena'me chʉ'ʉ cho'oche Dios Rekochoji kʉaʉna asa chʉ'ʉ Masiʉ pa'iche masijanaa'me mʉsanʉkona”, chiisi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. ");
INSERT INTO coe_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jmamakarʉ pa'isirʉmʉ mʉsanʉkona chʉ'ʉre ñamanejanaa'me. Jã'ata'ni jmamakarʉ pani jo'e ñajanaa'me mʉsanʉkona chʉ'ʉre. Ja'kʉ pa'ichejana co'imʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jã'aja'ñe i'kaʉna asa chʉkʉna repaʉ neena te'ena sãiñechi'a ija'che sẽesinaa'me: —¿Je'sere i'kakʉ jã'ʉ maire? “Jmamakarʉ pa'isirʉmʉ mʉsanʉkona chʉ'ʉre ñamanejanaa'me. Jã'ata'ni mʉsanʉkona chʉ'ʉre jmamakarʉ pani jo'e ñajanaa'me. Ja'kʉ pa'ichejana co'imʉ chʉ'ʉ”, chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Repaʉ, “Jmamakarʉ”, chiisi'e, ¿je'se chiikʉ jã'a? Repaʉ i'kache asavesʉme mai —chiisinaa'me repana. Asavesʉjʉ repaʉni sẽniasañu chiinata'ni sẽemanesinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Repaʉ'te sẽni asañu chiiche'te masikʉ i'kasi'kʉa'mʉ repaʉ. —Chʉ'ʉ mʉsanʉkonare, “Jmamakarʉ pa'isirʉmʉ mʉsanʉkona chʉ'ʉre ñamanejanaa'me. Jã'ata'ni mʉsanʉkona chʉ'ʉre jmamakarʉ pani jo'e ñajanaa'me”, chiisi'ere asavesʉjʉ, ¿sãiñechi'a sẽniasajʉ pa'iche mʉsanʉkona? ");
INSERT INTO coe_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ũcuachi'a chʉ'ʉre cu'ache ti'jñeʉna ña otare oijʉ sʉmava'na pa'ijanaa'me mʉsanʉkona. Chʉ'ʉre cuasamanata'ni pojojʉ pa'ijanaa'me. Mʉsanʉkona sʉmava'na pa'isinata'ni na'a pa'isirʉmʉ pojojʉ pa'ijanaa'me. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Romio chĩipi'rani rʉarepa asikʉna oimo, reparʉmʉpi tĩ'aʉna. Jã'ata'ni repao jñaasirʉmʉ chĩiva'ʉni pojoko repao'te asisi'ejẽ'e cuasama'mo. ");
INSERT INTO coe_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jã'aja'ñe pa'ime mʉsanʉkona. Chura sʉmava'na pa'ime. Jã'ata'ni mʉsanʉkonani jo'e ñara chini raija'mʉ chʉ'ʉ. Reparʉmʉ repao romio pojocheja'che rʉa pojojanaa'me mʉsanʉkona. Pãi te'eʉ'terejẽ'e ʉ̃secu'aja'mʉ mʉsanʉkona pojoche. ");
INSERT INTO coe_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Reparʉmʉta'ni mʉsanʉkona chʉ'ʉre jmamakarʉjẽ'e chʉ'o sẽniasamanejanaa'me. Reparʉmʉ mʉsanʉkonapi chʉ'ʉ Ja'kʉni, “Chʉkʉna Jesús neenaa'me. Chʉkʉna sẽeñe cho'okaijʉ̃'ʉ”, chiijʉ ũcuaʉache'te sẽeto cho'okaija'mʉ Repaʉ. Ũcuarepaa'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Irʉmʉjatʉ'ka mʉsanʉkona, “Chʉkʉna Jesús neenajejʉ chʉkʉna sẽeñe cho'okaijʉ̃'ʉ”, chiijʉ Diore jmamakarʉjẽ'e sẽemanaa'me. Churata'ni Ja'kʉni jã'aja'ñe sẽejʉ̃'ʉ. Sẽeto cho'okaija'mʉ Repaʉ, mʉsanʉkonapi pojojʉ paapʉ chini. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ũcuarʉmʉ Jesús jo'e i'kasi'kʉa'mʉ. —Mʉsanʉkonare Ja'kʉ pa'iche'te kʉakʉ vesache chʉ'ʉ cuasacheji kʉasi'kʉa'mʉ chʉ'ʉ. Na'a pa'isirʉmʉta'ni Ja'kʉ pa'iche jã'aja'ñe kʉama'ñe te'erũhiñe kʉaja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Reparʉmʉ mʉsanʉkonare ʉache'te Dioni sẽni, “Jesús neenaa'me chʉkʉna. Jã'ajekʉna chʉkʉna sẽeñe cho'okaijʉ̃'ʉ”, chiijanaa'me mʉsanʉkona. Reparʉmʉ mʉsanʉkonani Ja'kʉpi oiʉ ũcuare cho'okasa chiiʉna, “Repana sẽeñe cho'okaijʉ̃'ʉ”, chiimaneja'mʉ chʉ'ʉ Ja'kʉre. Mʉsanʉkonapi chʉ'ʉni chiijʉ, “Dios Raosi'kʉa'mʉ ikʉ”, chini cuasanajejʉna mʉsanʉkonare oiʉ cho'okaija'mʉ Ja'kʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja'kʉ pa'icheja pa'isi'kʉpi icheja chejana cajesi'kʉa'mʉ chʉ'ʉ. Chura icheja cheja pa'isi'kʉpi jo'ka Ja'kʉ pa'ichejana co'ipi'ramʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chikʉna chʉkʉna repaʉ neena i'kasinaa'me. —Churata'ni mʉ'ʉ aperʉmʉ i'kasi'eja'che i'kama'ñe te'erũhiñe i'kamʉ mʉ'ʉ, asamasire'oche. ");
INSERT INTO coe_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Peore masikʉ'mʉ mʉ'ʉ. Masime chʉkʉna chura jã'a. Pãi ũcuanʉko cuasache masikʉ'mʉ mʉ'ʉ. Jã'ajekʉna pãi, “¿Ʉ̃quere mʉsanʉkona chʉ'ʉre sẽñu chiiche?”, chiima'kʉa'mʉ mʉ'ʉ. Mʉ'ʉpi jã'aja'ñe pa'iʉna, “Dios Raosi'kʉa'mʉ ikʉ”, chiinaa'me chʉkʉna mʉ'ʉre —chiisinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chitena Jesús i'kasi'kʉa'mʉ. —Chura mʉsanʉkona chʉ'ʉre cuasarepame. ");
INSERT INTO coe_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jã'ata'ni mʉsanʉkona jmamakarʉ pa'isirʉmʉ vajʉchʉjʉ te'enachi'a chʉ'ʉre te'eʉ'te jo'ka mʉsanʉkona vʉ'ñana co'isõjanaa'me. Te'eva'ʉre jo'ka co'isõcojñosiva'ʉta'ni chʉ'ʉni Ja'kʉpi ja'me pa'iʉna te'eva'ʉ pa'imaneja'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mʉsanʉkonare chʉ'ʉre cuasanajejʉna jã'are i'kamʉ chʉ'ʉ, asa re'oja'che pojojʉ paapʉ chini. Diore cuasamana mʉsanʉkonare cu'ache cho'ojanaa'me. Cu'ache cho'ocojñojanata'ni vajʉchʉma'ñe pojojʉ re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona. Diore cuhenare na'a cajejaiche pa'ikʉjekʉ mʉsanʉkonare cho'okaija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ Jesús. ");
INSERT INTO coe_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jã'aja'ñe i'kacuha Jesús cʉnaʉmʉre mʉñe ñakʉ ija'che i'kasi'kʉa'mʉ: —Ja'kʉ, mʉ'ʉ chiisirʉmʉ tĩ'acuhamʉ. Mʉ'ʉpi chʉ'ʉ peore Masiʉ pa'iche pãire cho'o ñojʉ̃'ʉ. Chʉ'ʉ ũcuaja'che mʉ'ʉ peore Masiʉ pa'iche cho'o ñora. ");
INSERT INTO coe_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chʉ'ʉre mʉ'ʉ chĩire pãire ũcuanʉkore chʉ̃'ʉa'kʉ chini jo'kasi'kʉa'mʉ mʉ'ʉ. Chʉ'ʉpi paakʉ chʉ̃'ʉa'kʉ chini mʉ'ʉ chẽa jo'kasinare mʉ'ʉ pa'icheja sani pa'iche'te jo'kamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mʉ'ʉre Diorepaʉ'te Ũcuate'eʉ'te cuasajʉ chʉ'ʉre mʉ'ʉ Raosi'kʉre Jesucristo'te cuasana mʉ'ʉ pa'ichejare ai sani pa'ijanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Mʉ'ʉ, “Chejana sani cho'ojʉ̃'ʉ”, chiisi'ere chʉ'ʉpi ichejare chejare rani pa'iʉ cho'o pi'niʉna ña mʉ'ʉ peore Masiʉ pa'iche masime pãi. ");
INSERT INTO coe_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja'kʉ, chura chʉ'ʉre chuta'a cheja cho'omarʉmʉpi vʉa mʉ'ʉna'me pa'iʉ chʉ'ʉ aperʉmʉ chʉ̃'ʉsi'eja'chere jo'e jo'kajʉ̃'ʉ chʉ'ʉre, ũcuaja'che chʉ'ʉpi jo'e chʉ̃'ʉkʉ paaʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Pãi mʉ'ʉre cuasamanesinapi chura mʉ'ʉni cuasajʉna chʉ'ʉni chẽa jo'kasi'kʉa'mʉ mʉ'ʉ, chʉ'ʉpi paaa'kʉ chini. Mʉ'ʉ pa'iche'te kʉasi'kʉa'mʉ chʉ'ʉ repanare, asa masia'jʉ chini. Mʉ'ʉ neenaa'me repana. Chʉ'ʉpi paaa'kʉ chini chʉ'ʉni jo'kasi'kʉa'mʉ mʉ'ʉ repanare. Mʉ'ʉ chʉ̃'ʉñe asa jachama'ñe cho'ome repana. ");
INSERT INTO coe_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chʉ'ʉ che'chochena'me chʉ'ʉ pa'iche peore mʉ'ʉ jo'kasi'ea'me. Chura masime repana jã'a. ");
INSERT INTO coe_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mʉ'ʉ chʉ'ʉre kʉasi'e chʉ'ʉpi kʉaʉna asa chẽasinaa'me repana. Jã'ajekʉna chʉ'ʉre, “Dios pa'icheja raisi'kʉa'mʉ ikʉ. Dios Raorepasi'kʉa'mʉ”, chiijʉ masime repana. ");
INSERT INTO coe_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Mʉ'ʉni sẽekaimʉ chʉ'ʉ repanare. Mʉ'ʉre cuasamanareta'ni sẽekaima'mʉ chʉ'ʉ. Chʉ'ʉpi paaa'kʉ chini mʉ'ʉ chẽa jo'kasinarechi'a sẽekaimʉ chʉ'ʉ, mʉ'ʉ neenajejʉna. ");
INSERT INTO coe_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chʉ'ʉ neenare ũcuanʉkore ja'me paakʉ'mʉ mʉ'ʉ. Chʉ'ʉ ũcuaja'che mʉ'ʉ neenare ũcuanʉkore ja'me paakʉ'mʉ. Repanapi re'oja'che pa'ijʉna ñani, “Inare Paakʉ Jesucristo peore masikʉ'mʉ”, chiijanaa'me pãi. ");
INSERT INTO coe_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Icheja cheja na'a jeerʉmʉ pa'imaneja'mʉ chʉ'ʉ. Mʉ'ʉ pa'ichejana co'ipi'racuhamʉ chʉ'ʉ. Repanata'ni saimairo ichejare chejare pa'ijʉ pa'ijanaa'me. Ja'kʉ, re'okʉ'mʉ mʉ'ʉ. Repanare mʉ'ʉ chʉ'ʉre jo'kasinare mʉ'ʉpi peore Masikʉji kuirajʉ̃'ʉ, mai ũcuate'eʉ pa'icheja'che repanapi ũcuate'eʉja'che paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mʉ'ʉpi cho'okaiʉna chʉ'ʉ neenani ja'me pa'iʉ kuirakʉ pa'ikʉ'mʉ chʉ'ʉ, mʉ'ʉre cuasache'te ũhasõ cho'osõmanea'jʉ chini. Jã'ata'ni cho'osõjaʉ te'eʉ pa'imʉ. Repaʉ cho'okʉ cho'osõjañere kʉañu chini Dios chʉ'o kʉana tocha jo'kasi'epi ũcuarepa ti'jñeja'mʉ repaʉ'te. Chekʉnareta'ni te'eʉ'terejẽ'e cho'osõmanesi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chura mʉ'ʉ pa'ichejana saipi'ramʉ chʉ'ʉ. Jã'ata'ni chuta'a ichejare chejare pa'iʉ chʉ'ʉ neenani iere peore i'kamʉ chʉ'ʉ, repanapi chʉ'ʉ pojokʉ pa'icheja'che cuhama'ñe pojojʉ paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉ'ʉ chʉ'ʉre kʉasi'e chʉ'o kʉasi'kʉa'mʉ chʉ'ʉ repanare. Mʉ'ʉre cuasamana cuasacheja'che cuasama'kʉa'mʉ chʉ'ʉ. Chʉ'ʉ neena ũcuaja'che repana cuasacheja'che cuasamanaa'me. Jã'ajekʉna mʉ'ʉre cuasamana cuheme repanare. ");
INSERT INTO coe_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mʉ'ʉpi repanani tĩichejana saa'kʉ chini sẽema'mʉ chʉ'ʉ. Rupʉ mʉ'ʉpi vati repanare cu'ache cho'ora chiiche'te ʉ̃sea'kʉ chini sẽekaimʉ chʉ'ʉ repanare. ");
INSERT INTO coe_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mʉ'ʉre cuasamana cuasacheja'che cuasama'kʉa'mʉ chʉ'ʉ. Chʉ'ʉ neena ũcuaja'che repana cuasacheja'che cuasamanaa'me. ");
INSERT INTO coe_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉ'ʉ chʉ'o ũcuarepaa'me. Repanare che'chojʉ̃'ʉ repachʉ'o, asa chẽa mʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ re'oja'che paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʉ'ʉ chʉ'ʉre icheja raosi'eja'che chʉ'ʉ repanare mʉ'ʉ chʉ'ore si'achejña ku'ijʉ chʉ'vajʉ paapʉ chini saoja'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chʉ'ʉ neenapi ña chẽa chʉ'ʉ cho'ocheja'che mʉ'ʉ chʉ̃'ʉñe'te cho'ojʉ paapʉ chini mʉ'ʉ chʉ̃'ʉñechi'a cho'okʉ'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Repanarechi'a sẽekaima'mʉ chʉ'ʉ. Repanapi chʉ'vajʉna asa chẽa chʉ'ʉre cuasajanare ũcuachi'a sẽekaimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mʉ'ʉna'me chʉ'ʉ ũcuate'eʉja'che pa'inaa'me mai. Ja'kʉ, mʉ'ʉni sẽemʉ chʉ'ʉ, chʉ'ʉ neenapi mai ũcuate'eʉ pa'icheja'che ũcuate'eʉja'che paapʉ chini, ũcuachi'a maina'me si'arʉmʉ ũcuate'eʉja'che paapʉ chini. Jã'aja'ñe pa'ijʉna repana re'oja'che pa'iche'te ñani mʉ'ʉre cuasamana, “Jesús inare paakʉ Dios Raosi'kʉa'mʉ”, chiijanaa'me. Jã'aja'ñere chiimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mʉ'ʉ chʉ'ʉre ĩsisi'eja'che chʉ'ʉ neenare jo'kamʉ chʉ'ʉ, repanapi mai ũcuate'eʉ pa'icheja'che ũcuate'eʉja'che paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Repanare ja'me pa'ikʉ'mʉ chʉ'ʉ. Mʉ'ʉ ũcuaja'che chʉ'ʉre ja'me pa'ikʉ'mʉ. Pãipi mʉ'ʉre cuasamanapi repanapi ũcuate'eʉja'che pa'ijʉna ña, “Jesús Dios Raosi'kʉa'mʉ; Repaʉ Mamakʉ'te oicheja'che oimʉ Dios inare”, chiijʉ masia'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ja'kʉ, mʉ'ʉ chʉ'ʉre paaa'kʉ chini jo'kasinare chʉ'ʉ sani pa'ijachejare mʉ'ʉ pa'ichejare sani ja'me paapʉ chiimʉ chʉ'ʉ, chʉ'ʉ Masiʉ pa'iche'te ñajʉ paapʉ chini. Mʉ'ʉ chʉ'ʉre chuta'a cheja cho'omarʉmʉpi vʉa oikʉjekʉ chʉ'ʉni Masiʉ pa'iche jo'kasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ja'kʉ, re'okʉ'mʉ mʉ'ʉ. Mʉ'ʉre cuasamana mʉ'ʉ pa'iche vesʉme. Chʉ'ʉta'ni masimʉ. Chʉ'ʉ neena ũcuaja'che mʉ'ʉ chʉ'ʉre raosi'e masime. ");
INSERT INTO coe_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉ'ʉ pa'iche kʉasi'kʉa'mʉ chʉ'ʉ repanare. Ũcua cuhama'ñe kʉakʉ pa'ija'mʉ chʉ'ʉ, repanapi mʉ'ʉ chʉ'ʉre oicheja'che sãiñechi'a oijʉ paapʉ chini. Repana rekoñoãre ja'me pa'ija'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús Diore sẽni pi'nisirʉmʉ chʉkʉna repaʉ neena ũcuaʉna'me eta sani Cedrón chiara'charʉ chekʉkã'kona jẽ'esinaa'me. Jẽni sani olivo sũkiñʉã pa'ichejana tĩ'asinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aperʉmʉ chʉkʉna Jesuna'me si'arʉmʉ chi'isichejajekʉna Judas masisi'kʉa'mʉ repacheja, pãipi cu'ache cho'oa'jʉ chini Jesure jo'kajaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jã'ajekʉna Judapi saʉna Jesuni chẽajaapʉ chini phairipãi chʉ̃'ʉna fariseopãina'me Dios vʉ'e pẽ'jekainani chʉ̃'ʉasome. Chʉ̃'ʉrena Jesús pa'ichejana Dios vʉ'e pẽ'jekainana'me sõtaopãi Judapi rakʉna vaichena'me ʉoñoãna'me ʉopʉã rajʉ raisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ũcuarʉmʉ Jesús repaʉ'te ti'jñejañe peore masikʉjekʉ repanare eta tijña sẽesi'kʉa'mʉ. —¿Neeni ku'eche mʉsanʉkona? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chikʉna i'kasinaa'me repana. —Nazaret vʉ'ejoopo cakʉni Jesuni ku'eme chʉkʉna —chiisinaa'me. Chitena i'kasi'kʉa'mʉ repaʉ. —Ũcuaʉ'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. Repaʉ Judas Jesure cu'ache cho'oa'jʉ chini rasi'kʉ ũcuanana'me pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesupi, “Ũcuaʉ'mʉ chʉ'ʉ”, chikʉna asa teana cho'je co'iche tãisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Cho'je co'iche tãijʉna repanare jo'e i'kasi'kʉa'mʉ repaʉ. —¿Neeni ku'eche mʉsanʉkona? —chiisi'kʉa'mʉ. Chikʉna jo'e i'kasinaa'me repana. —Nazaret vʉ'ejoopo cakʉni Jesuni ku'eme chʉkʉna —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chitena Jesús jo'e i'kasi'kʉa'mʉ. —“Ũcuaʉ'mʉ”, chinicuhasi'kʉa'mʉ chʉ'ʉ mʉsanʉkonare. Chʉ'ʉre ku'eni inare chʉ'ʉ neenareta'ni chẽamanejʉ̃'ʉ, sani paapʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aperʉmʉ Jesús Pʉka'kʉni sẽeʉ ija'che i'kasi'kʉa'mʉ: “Ja'kʉ, chʉ'ʉpi paakʉ chʉ̃'ʉa'kʉ chini mʉ'ʉ chʉ'ʉre jo'kasinare te'eʉ'terejẽ'e cho'osõmanesi'kʉa'mʉ chʉ'ʉ”, chiisi'kʉa'mʉ. Jã'ajekʉna aperʉmʉ repaʉ i'kasi'epi ũcuarepa ti'jñea'kʉ chini, “Inare chekʉnareta'ni chẽamanejʉ̃'ʉ sani paapʉ”, chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ũcuarʉmʉ Simón Pedro va'ti paakʉjekʉ ruta judío phairi aire cho'oche cho'okaikʉ Malco'te cãjoro ʉjajʉ̃tʉ cakã'ko pa'icãjoro'te tẽo vatosi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tẽoʉna Jesús repaʉ'te Pedro'te i'kasi'kʉa'mʉ. —Repava'ti jo'e jʉojʉ̃'ʉ. Ina chʉ'ʉre cu'ache cho'ojache Ja'kʉ jo'kasi'ea'me. Ja'kʉ jo'kasi'e cuhema'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ũcuarʉmʉ repana sõtaopãi repanare chʉ̃'ʉkʉna'me judíopãi chʉ̃'ʉna chẽa vẽesinaa'me repaʉ'te Jesure. ");
INSERT INTO coe_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chẽa vẽe repaʉ'te charo Anás vʉ'ena sasinaa'me repana. Reparʉmʉ Caifás Anás mamakoni paasi'kʉa'mʉ. Repaʉ Caifás repaʉ̃sʉrʉmʉ judío phairi ai pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aperʉmʉ repaʉ Caifás judíopãi chʉ̃'ʉnare ija'che chʉ'vaasomʉ: “Maipi Jesús cho'oche'te ʉ̃semapʉ jainʉko chuenisõto cu'amʉ. Pãi ũcuanʉko chuenisõmanea'jʉ chini cho'okʉchi'a ũcuate'eʉ chuenisõto na'a re'omʉ”, chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesuni sasõjʉna chʉkʉna repaʉ neena Simón Pedrona'me chʉ'ʉ cho'jepi tuhasinaa'me repanare. Tuha judío phairi ai vʉ'e sa'navʉ cararipʉna cuaajʉna ja'me kakasi'kʉa'mʉ chʉ'ʉ phairi ai masicojñokʉjekʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrota'ni kakama'ñe jatisa'aro kueñena canʉkasi'kʉa'mʉ. Ũcuarʉmʉ chʉ'ʉ Jesús neekʉ jo'e eta repavʉ'e cho'omajñarʉã cho'okaio jatisa'aro ñakaikoni sẽeʉna vataona Pedro'te cuaosi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jã'aja'ñe vata cuaoko ña i'kasi'koa'mo repao Pedro'te. —¿Jesús neekʉma'kʉ mʉ'ʉ? —chiisi'koa'mo repao. Chiiona i'kasi'kʉa'mʉ repaʉ. —Pãamʉ. Jã'ʉ neekʉma'mʉ chʉ'ʉ —chiiʉ joresi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Reparʉmʉ rʉa sʉsʉkʉna toa suha rũhiso'koro nʉkajʉ kũhisinaa'me repavʉ'e cho'oche cho'okainana'me Dios vʉ'e pẽ'jekaina. Ũcuaja'che Pedro repanare ja'me nʉkakʉ kũhisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ũcuarʉmʉ judío phairi ai Jesure repaʉ che'chochena'me repaʉ neena pa'iche sẽesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sẽeʉna Jesús i'kasi'kʉa'mʉ. —Pãi ũcuanʉko asajʉ'te judíopãi chi'ivʉ'ñana kaka che'chosi'kʉa'mʉ chʉ'ʉ. Chekʉrʉmʉ Dios vʉ'ena kaka che'chosi'kʉa'mʉ, repana judíopãi si'arʉmʉ chi'ivʉ'ñana. Rope'e che'chomanesi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chʉ'ʉre sẽemanejʉ̃'ʉ. Chʉ'ʉ i'kache asasinani sẽniasajʉ̃'ʉ. Chʉ'ʉ i'kasi'e masime repana —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesupi jã'aja'ñe i'kaʉna Dios vʉ'e pẽ'jekaikʉ pãi chẽakʉ kueñere nʉkakʉ Jesure chiana vaiʉ ija'che i'kasi'kʉa'mʉ: —¿Je'se pa'iʉna mʉ'ʉ ikʉre phairi aire jã'aja'ñe i'kakʉ? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chikʉna Jesús i'kasi'kʉa'mʉ. —¿Ʉ̃quere chʉ'ʉ cu'ache i'kare? Chʉ'ʉ cu'ache i'kasi'e pa'ito kʉajʉ̃'ʉ. Jã'ata'ni, ¿je'se cuasakʉ mʉ'ʉ chʉ'ʉre cu'ache i'kamanesi'kʉre vaikʉ? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chikʉna Anás repaʉ'te Jesure vẽesi'e chuta'a josema'kʉni judío phairi ai Caifás vʉ'ena mʉvaa'jʉ chini chʉ̃'ʉsi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ũcuarʉmʉ Pedro'te nʉkakʉ kũhikʉni ija'che sẽesinaa'me repana: —¿Jesús neekʉma'kʉ mʉ'ʉ? —chiisinaa'me. Chiijʉna Pedro jachakʉ, —Pãamʉ. Jã'ʉ neekʉma'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jã'api phairi aire cho'oche cho'okaikʉji cãjoro tẽo vatocojñosi'kʉ majapãiʉji i'kasi'kʉa'mʉ Pedro'te. —Mʉ'ʉre olivo sũkiñʉã pa'ichejana Jesuna'me pa'ikʉni ñasi'kʉa'mʉ chʉ'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chikʉna Pedro jo'e jachasi'kʉa'mʉ. Jachatona kura chu'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ũcuarʉmʉ judíopãi chʉ̃'ʉna ñatapi'ratona Jesure Caifás vʉ'e pa'isi'kʉre Romapãi chʉ̃'ʉkʉ Pilato vʉ'ena mʉvasinaa'me. Mʉva tĩ'a judío peona vʉ'ejekʉna cu'are cuhejʉ kakamanesinaa'me repana pascua ãijañere ãure ãñu chini. Aperʉmʉ repana aipãipi pascua tĩ'api'rarʉmʉ judío peona vʉ'ña kakache ʉ̃seasome. Jã'ajekʉna repanapi ũcuavʉ'ena kakaru pascua ãiñe ãu ãicu'ara'amʉ, repanapi cu'are paajʉna. ");
INSERT INTO coe_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jã'ajekʉna Pilato repanare ve'sena eta i'kasi'kʉa'mʉ. —¿Ʉ̃quere cu'ache cho'oʉna mʉsanʉkona ikʉre rare? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chikʉna i'kasinaa'me repana. —Chʉkʉna ikʉre cu'ache cho'omanesi'kʉ pa'ito ramanera'asinaa'me —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chitena Pilato i'kasi'kʉa'mʉ. —Ikʉre mʉsanʉkonapi sa mʉsanʉkona aipãi chʉ̃'ʉ jo'kasi'epi cu'ache cho'ojʉ̃'ʉ —chiisi'kʉa'mʉ. Chikʉna i'kasinaa'me repana. —Chʉkʉna judíopãi pãiʉ'te te'eʉ'terejẽ'e vanisõñe jo'kacojñomanesinajejʉna cu'ache cho'onare vanisõñu chiitojẽ'e vaicu'akʉ'mʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jã'aja'ñe cho'ojʉna Jesús i'kasi'e repaʉ, “Kurususẽ'vero jẽ'jo vẽasõjanaa'me chʉ'ʉre”, chiisi'e ti'jñepi'rasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato jo'e kaka Jesure soni rao i'kaasomʉ. —¿Mʉ'ʉ judíopãi ũcuanʉkore chʉ̃'ʉkʉ'ʉ? —chiniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chikʉna Jesús i'kaasomʉ. —¿Mʉ'ʉ te'eʉ cuasache'te sẽekʉ mʉ'ʉ chʉ'ʉre? Rupʉ chekʉnapi kʉajʉna asasi'ere, ¿jã'aja'ñe sẽekʉ mʉ'ʉ chʉ'ʉre? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chikʉna Pilato i'kaasomʉ. —Judíopãiʉma'mʉ chʉ'ʉ. Mʉ'ʉ majapãi judíopãipi judío phairipãi chʉ̃'ʉnana'me rasinaa'me mʉ'ʉre. ¿Ʉ̃quere mʉ'ʉ cho'oʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chikʉna Jesús i'kaasomʉ. —Pãi chʉ̃'ʉkʉta'ni icheja canare chʉ̃'ʉma'kʉa'mʉ chʉ'ʉ. Chʉ'ʉpi icheja canare chʉ̃'ʉkʉ pa'ito chʉ'ʉ neenapi chʉ'ʉre sa judíopãi chʉ̃'ʉnani jo'kamanea'jʉ chini ʉ̃sejʉ cavajʉ vaira'asinaa'me. Icheja canare chʉ̃'ʉkʉma'mʉ chʉ'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chikʉna Pilato sẽniasomʉ repaʉ'te. —¿Jã'a pa'ito mʉ'ʉ pãi chʉ̃'ʉkʉ'ʉ? —chiniasomʉ. Chikʉna Jesús i'kaasomʉ. —Jʉ̃jʉ, mʉ'ʉ i'kache ũcuarepaa'me. Pãi chʉ̃'ʉkʉ'mʉ chʉ'ʉ. Cʉnaʉmʉ pa'isi'kʉpi icheja chejana pãio jñaacojñosi'kʉa'mʉ chʉ'ʉ Dios pa'iche'te chʉ'o ũcuarepare kʉara chini. Dios pa'iche masiñu chiinachi'a chʉ'ʉ kʉache ũcuarepa jachama'ñe asa chẽame —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chikʉna Pilato jo'e i'kaasomʉ. —¿Ʉ̃quea'che jã'a, chʉ'o ũcuarepa kʉache? —chiniasomʉ repaʉ. Repaʉ'te sẽni pi'ni Pilato jo'e eta i'kasi'kʉa'mʉ repanare judíopãi chʉ̃'ʉnare. —Ikʉre repaʉ cu'ache cho'osi'ere kʉakʉna asara chini chʉ'o sẽniasasi'kʉa'mʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ cuasato jmamakarʉjẽ'e repaʉ cu'ache cho'osi'e peomʉ. Mʉsanʉkona, “Cu'ache cho'okʉ'mʉ ikʉ”, chiiche cho'oma'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascuarʉmʉ tĩ'ato ʉ̃sʉrʉmʉ pa'iche chẽacojñosi'kʉre te'eʉ'te etokʉ'mʉ chʉ'ʉ, mʉsanʉkona etojʉ̃'ʉ chiikʉni. ¿Ikʉni judíopãi chʉ̃'ʉkʉni etojʉ̃'ʉ chiiche mʉsanʉkona? —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chikʉna asa ũcuanʉko cuijʉ i'kasinaa'me repana. —Etomanejʉ̃'ʉ jã'ʉre. Barrabani etokaijʉ̃'ʉ chʉkʉna'te —chiijʉ cuisinaa'me repana. Repaʉ Barrabás ñaaʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Repanapi jã'aja'ñe i'kajʉ cuirena Pilato Jesuni sa suĩ'suea'jʉ chini chʉ̃'ʉasomʉ. Chʉ̃'ʉʉna sõtaopãipi sa suĩ'sueasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ũcuachi'a miu tuhivʉ cho'o Jesús sĩjopʉna tʉo kãa pãi chʉ̃'ʉna ju'ikãare chimaajakãare sachaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sacha pi'ni repaʉ'te rʉarepañoã kueñe raijʉ ija'che i'kaasome repana: —¡Ikʉpi judíopãire si'arʉmʉ chʉ̃'ʉkʉ paaʉ! —chiijʉ repaʉ chiana vaniasome repana. ");
INSERT INTO coe_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jã'aja'ñe cho'orena Pilato repanare pãi jo'e eta i'kasi'kʉa'mʉ. —Asarepajʉ̃'ʉ, mʉsanʉkona. Eto ñoja'mʉ chʉ'ʉ repaʉ'te. Chʉ'ʉ cuasato cu'ache cho'oma'kʉa'mʉ repaʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ũcuarʉmʉ Jesupi sĩjopʉ'te miu tuhivʉ tuhiʉ kãa chimaajakãare ju'iʉ etaʉna ija'che i'kasi'kʉa'mʉ Pilato: —¡Ñajʉ̃'ʉ! Ikʉa'mʉ repaʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chikʉna phairipãi chʉ̃'ʉnana'me Dios vʉ'e pẽ'jekaina repaʉ'te Jesure ña cuijʉ i'kasinaa'me. —Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre. Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ —chiisinaa'me repana. Chitena Pilato i'kasi'kʉa'mʉ. —Chʉ'ʉ cuasato cu'ache cho'omanesi'kʉa'mʉ ikʉ. Jã'ajekʉna ikʉre vanisõñe chʉ̃'ʉcuhemʉ chʉ'ʉ. Mʉsanʉkonapi sa kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ ikʉre —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chikʉna judíopãi chʉ̃'ʉna i'kasinaa'me. —“Dios Mamakʉ'mʉ chʉ'ʉ”, chiiʉ jorekʉ'mʉ ikʉ. Chʉkʉna aipãi jã'aja'ñe i'kajʉ jorenare, “Vanisõjʉ̃'ʉ”, chiijʉ chʉ̃'ʉ jo'kaasome. Jã'ajekʉna repana chʉ̃'ʉ jo'kasi'e vanisõñe pa'imʉ ikʉre —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jã'aja'ñe i'kache'te asa Pilato na'a rʉa vajʉchʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ũcuarʉmʉ repaʉ jo'e vʉ'ena Jesure cuaa sẽniasomʉ. —¿Jeecheja cakʉa'ʉ mʉ'ʉ? —chiniasomʉ repaʉ. Sẽekʉ'teta'ni Jesús i'kamaneasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","I'kamaʉna Pilato jo'e i'kaasomʉ. —¿Chʉ'ʉ sẽeñe kʉamaneja'ʉ mʉ'ʉ? Pãi chʉ̃'ʉkʉjekʉna chʉ'ʉre ʉache chʉ̃'ʉre'omʉ chʉ'ʉre, mʉ'ʉre kurususẽ'verona jẽ'jo nʉkochena'me jose etoche. ¿Jã'a vesʉkʉ mʉ'ʉ? —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chikʉna Jesús i'kaasomʉ. —Mʉ'ʉni Diopi pãi chʉ̃'ʉñe jo'kamaneru chʉ'ʉre jã'aja'ñe cho'ojache chʉ̃'ʉcu'ara'amʉ mʉ'ʉre. Chʉ'ʉre chẽaa'jʉ chini sa jo'kasi'kʉ mʉ'ʉre na'a rʉa cu'ache cho'osi'kʉa'mʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jã'aja'ñe i'kaʉna asa Pilato repaʉni jose etora chini jo'e eta rʉa i'kasi'kʉa'mʉ repanare pãi. I'kakʉ'teta'ni repana judíopãi cuijʉ i'kasinaa'me. —“Pãi chʉ̃'ʉkʉ'mʉ chʉ'ʉ”, chiinapi maire ũcuanʉkore chʉ̃'ʉkʉ'te Césa'te cuheme. Jã'ajekʉna mʉ'ʉpi jã'ʉni ũcuare jã'aja'ñe i'kasi'kʉni jose etoni repaʉ'te maire ũcuanʉkore chʉ̃'ʉkʉ'te ja'me pa'ikʉma'mʉ mʉ'ʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Repana i'kache asa pi'ni Pilato Jesure ve'sena etojʉ̃'ʉ chini pãi cu'ache cho'osi'e kʉajʉna asakʉ ñu'isaivʉna pʉʉsi'kʉa'mʉ. (Repasaivʉ rʉ̃iraripʉ “Gabata” chiimʉ hebreo chʉ'o. “Gabata” chini “Cata je'nasiraripʉ” chiimʉ.) ");
INSERT INTO coe_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascuarʉmʉ tĩ'añe te'eumucuse karatona nʉkarepaʉ sʉ'itona judíopãi chʉ̃'ʉnare i'kasi'kʉa'mʉ Pilato. —¡Ñajʉ̃'ʉ ikʉre, mʉsanʉkonare ũcuanʉkore chʉ̃'ʉkʉ'te! —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Chikʉna cuijʉ i'kasinaa'me repana. —Sa vanisõjʉ̃'ʉ jã'ʉre. Sa vanisõjʉ̃'ʉ jã'ʉre. Kurususẽ'verona jẽ'jo nʉkojʉ̃'ʉ jã'ʉre —chiisinaa'me repana. Chitena i'kasi'kʉa'mʉ repaʉ. —¿Mʉsanʉkonare chʉ̃'ʉkʉ'te kurususẽ'verona jẽ'jo nʉko vẽasõjʉ̃'ʉ chiiche mʉsanʉkona? —chiisi'kʉa'mʉ. Chikʉna judío phairipãi chʉ̃'ʉna i'kasinaa'me. —Césachi'aa'mʉ pãi ũcuanʉkore chʉ̃'ʉkʉ —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chitena Pilato Jesure sõtaopãire jo'kasi'kʉa'mʉ, sa kurususẽ'verona jẽ'jo nʉkoa'jʉ chini. Jo'kaʉna repaʉ'te sasõsinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sajʉna Jesús repaʉ'te jẽ'jo nʉkojasẽ'vero kurususẽ'vero kuãiʉ Calavera aikũtina Pãi sĩjopʉjakũti chiikũtina saisi'kʉa'mʉ. “Calavera” chini “Gólgota” chiimʉ hebreo chʉ'o. ");
INSERT INTO coe_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ũcuachejana repana Jesure kurususẽ'verona jẽ'jo nʉkosinaa'me. Chekʉnare ũcuaja'che ka'chanare kurususẽ'veroãna jẽ'jo nʉkosinaa'me repana. Te'eʉ'te Jesús ʉjajʉ̃tʉ cakã'kona nʉkosinaa'me repana. Chekʉni kã'kojʉ̃tʉ cakã'kona nʉkosinaa'me. Jesure repana chenevʉna nʉkosinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ũcuarʉmʉ Pilatoji chʉ̃'ʉʉna tochasiko'a kurususẽ'vero chã'tirona jẽ'jo sʉosinaa'me repana, Ikʉ Jesus, Nazaret Vʉ'ejoopo Cakʉa'mʉ. Judiopãi Chʉ̃'ʉkʉ'mʉ, chiiche tochasiko'are. ");
INSERT INTO coe_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pilatoji chʉ̃'ʉʉna hebreo chʉ'o, griego chʉ'o, latín chʉ'o tochasinaa'me repako'a. Repacheja Jesure kurususẽ'vero jẽ'jo nʉkosicheja Jerusalén vʉ'ejoopo kueñe pa'isi'kʉa'mʉ. Jã'ajekʉna judíopãi jainʉko rani repako'a tochasi'e ñasinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Judío phairipãi chʉ̃'ʉna repako'a tochasi'ere ña i'kasinaa'me Pilato'te. —Jã'a, “Judíopãi chʉ̃'ʉkʉ'mʉ ikʉ”, chiijʉ tochasi'e tʉnosõ, “ ‘Judíopãi chʉ̃'ʉkʉ'mʉ chʉ'ʉ’, chiisi'kʉa'mʉ ikʉ”, chiiche tocha sʉojʉ̃'ʉ —chiisinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chitena Pilato i'kasi'kʉa'mʉ. —Chʉ'ʉpi chʉ̃'ʉʉna tochasi'ea'me jã'a. ¡Ũcua jã'aja'ñe paaʉ! —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Repana sõtaopãi Jesure kurususẽ'verona jẽ'jo nʉko pi'ni repaʉ ju'isikãa mini ũcuaka'chapana te'ese'rechi'a che're paasinaa'me. Chekʉkãa tʉ̃osikãa repakãapi juhasi'epi peokʉna te'eʉjakãajekʉna sãiñechi'a ija'che i'kasinaa'me repana: ");
INSERT INTO coe_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Ikãa che'resõmaneñu mai. Rupʉ ikãa paajaʉni catara'karʉã tochasira'karʉãpi chejana su'a jñaañu —chiisinaa'me repana. Jã'aja'ñe cho'ojʉ Dios chʉ'o kʉakaisina tocha jo'kasi'e kʉache'te ũcuarepa cho'osinaa'me repana sõtaopãi, ija'che kʉache'te: Chʉ'ʉ ju'isikãa te'ese'rechi'a che're paasinaa'me repana. Chekʉkãa tʉ̃osikãa paajaʉni jñaañu chini catara'karʉã mami tochasira'karʉãpi chejana su'asinaa'me repana, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús jẽ'jo sʉocojñosi'kʉ nʉkasẽ'vero kueñere romi ũcuaka'chapana nʉkasinaa'me, repaʉ pʉka'kona'me repao cho'jeo, cheko María Cleofas rʉ̃jona'me María Magdalena. ");
INSERT INTO coe_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nʉkajʉna chʉ'ʉ Jesús neekʉ repaʉ rʉa chiicojñokʉ repaʉ pʉka'kore kueñe nʉkasi'kʉa'mʉ. Nʉkakʉna ña Jesús repaʉ pʉka'kore i'kasi'kʉa'mʉ. —Ja'ko, mʉ'ʉ chĩija'iʉ pa'ija'mʉ ikʉ —chiisi'kʉa'mʉ repaʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chini chʉ'ʉre ũcuaja'che i'kasi'kʉa'mʉ repaʉ— Mʉja'koja'io pa'ija'mo iko —chiisi'kʉa'mʉ repaʉ. Jã'aja'ñe i'kaʉna asa jã'arʉmʉpi teana repao'te chʉ'ʉ vʉ'ena sa kuirasi'kʉa'mʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jã'aja'ñe i'ka pi'ni, “Ja'kʉ chʉ̃'ʉ jo'kasi'e peore cho'o pi'nicuhasi'ea'me”, chini cuasakʉ ija'che i'kasi'kʉa'mʉ: —Okoʉamʉ chʉ'ʉre —chiisi'kʉa'mʉ repaʉ. Jã'aja'ñe i'kakʉ Dios chʉ'o aperʉmʉ kʉasina tocha jo'kasi'e kʉache'te ũcuarepa cho'osi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ũcuachejare churura'pʉrʉ ʉche cono rʉara'ka timusira'pʉrʉ ñu'isi'kʉa'mʉ. Repana sõtaopãi ũcuara'kana chʉisʉovʉji chũsa chʉ̃ʉ hisopo vãsocho chã'tirona repasʉorʉ quẽo sʉo mʉo repaʉ chʉ'opona nosinaa'me chʉ'chʉa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mʉorena chʉ'chʉ ũku pi'ni ija'che i'kasi'kʉa'mʉ repaʉ: —Peore cho'o pi'nicuhasi'ea'me —chini meñe sime jũnisõsi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pʉaumucuse chuta'a tĩ'amarʉmʉjekʉna repana judíopãi, “Maipi kurususẽ'veroã jẽ'jocojñosinani casoma'to cu'amʉ. Che'ro pascuarʉmʉ na'a rʉa fiesta cho'oumucusea'me. Jã'ajekʉna maipi repana cũ'are tʉ'ka jʉ'chesõñu na'a na'mi jũnisõrena na'mi caso re'oa'kʉ”, chini repana Pilatoni sani i'kaasome jã'aja'ñe cho'oche'te chʉ̃'ʉa'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ũcuarʉmʉ repana sõtaopãi Pilatoji chʉ̃'ʉʉna rani Jesure ja'me jẽ'jo nʉkocojñosi'kʉre charo nʉkakʉni repaʉ cũ'a tʉ'ka jʉ'chesinaa'me. Chekʉre ũcuaja'che cho'osinaa'me repana. ");
INSERT INTO coe_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cho'o pi'ni Jesure ñasinaa'me. “Ikʉta'ni jũnisõsi'kʉa'mʉ”, chini repaʉ cũ'a tʉ'ka jʉ'chemanesinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jã'ata'ni sõtao te'eʉ cʉnarʉji Jesús me'jupona totasi'kʉa'mʉ. Totaʉna chiena'me oko raisi'kʉa'mʉ repaʉ totasicoje. ");
INSERT INTO coe_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jã'aja'ñe cho'oche ñasi'kʉjekʉ jorema'ñe ũcuarepare chʉ'o kʉamʉ chʉ'ʉ, mʉsanʉkonapi ña, “Jesús Dios Mamakʉ'mʉ”, chini repaʉni cuasaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Repaʉ cũ'are tʉ'ka jʉ'chemanerena Dios chʉ'o aperʉmʉ kʉakaisina tocha jo'kasi'e ũcuarepa ti'jñesi'kʉa'mʉ. Repaʉ tara te'etarapʉjẽ'e jʉchʉmaneja'mʉ, chiimʉ repa tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dios chʉ'o tochasiphʉro chekʉcheja ija'che kʉamʉ: Repana totasi'kʉre ñajanaa'me pãi, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jã'a cho'o pi'nisirʉmʉ José Arimatea vʉ'ejoopo cakʉ Jesure jũ'isi'kʉre Pilatoni sẽniasomʉ sa tãra chini. (Repaʉ José judíopãire vajʉchʉkʉ Jesure ñoma'ñe chiikʉ paniasomʉ.) Sẽeʉna Pilatoji, “Jaʉ”, chikʉna sani Jesure caso saasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Saʉna Nicodemo Jesure ñamipi mʉa cutusi'kʉ ja'me saiʉ ma'ña jũ'isiva'nare ro'veche mirrana'me áloe ja'mesi'e treinta kilos saasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sa kãana reajakãana ma'ñapi chʉ̃ʉ Jesure reaasome repana Josena'me Nicodemo. Jũ'isinare judíopãi cho'oche'me jã'a. ");
INSERT INTO coe_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesure kurususẽ'vero jẽ'jo nʉkosichejare otera'ñʉrʉã pa'icheja pa'isi'kʉa'mʉ. Ũcuachejare mamacoje chuta'a jũ'isi'kʉre te'eʉ'terejẽ'e tãmacoje pa'isi'kʉa'mʉ, aikũti caripana tẽtoche ũhisicoje. ");
INSERT INTO coe_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Reparʉmʉ judíopãi pʉaumucuse tĩ'acuhakʉna repacojepi kueñe pa'iʉna ũcuacojena cuaa ũhaasome repaʉ'te Jesure. Ũha eta repacoje kakasa'aro catapʉji rʉa ʉjapʉji ta'pi vʉ'ena co'iasome repana. ");
INSERT INTO coe_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Romicorʉmʉ apeñatato rʉa ñami chuta'a chijajʉ̃vana María Magdalena Jesure ũhasicojena saniasomo. Sani ñato catapʉ repacoje ta'pisi'pʉ kʉñosõsi'pʉ paniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ña vʉ'vʉsõ Simonna'me chʉ'ʉ Jesús neekʉ repaʉ rʉa chiicojñokʉ pa'ichejana rani kʉasi'koa'mo repao. —Maire Paakʉ'te pãi mini etua sasõsinaa'me. Repaʉ'te sa ũhasicheja vesʉme mai —chiisi'koa'mo repao. ");
INSERT INTO coe_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chikona asa chʉ'ʉ Pedrona'me eta ũcuacojena saisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vʉ'vʉjʉ saisinaa'me chʉkʉna Jesús neena. Jã'ata'ni chʉ'ʉ Pedro'te na'a charo vʉ'vʉ tĩ'asi'kʉa'mʉ repacoje. ");
INSERT INTO coe_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Vʉ'vʉ tĩ'a repacoje sa'navʉ rʉ̃a ñato Jesure reasikãñachi'a ũhisi'kʉa'mʉ. Rʉ̃a ñakʉta'ni chʉ'ʉ kakamanesi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Na'a cho'jepi vʉ'vʉ tĩ'asi'kʉa'mʉ Simón Pedro repacoje. Ũcuaja'che repakãña kaka ñasi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ũcuachi'a Jesús sĩjopʉ reasikãa tĩichejana pʉ'se ũhasikãare ñaasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ũcuarʉmʉ chʉ'ʉ charo vʉ'vʉ tĩ'asi'kʉ repacoje ũcuaja'che kaka ña, “¡Vajʉranicuhacosomʉ repaʉ!”, chini cuasasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Reparʉmʉ Dios chʉ'o aperʉmʉ tocha jo'kasi'e repaʉ vajʉraijache kʉache asanata'ni chuta'a asavesʉsinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ña pi'ni vʉ'ena co'isinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","María Magdalenata'ni chʉkʉna'te tuhasi'ko co'imanesi'koa'mo. Co'ima'ñe pa'io repacoje kueñere nʉkako oniasomo repao. Oio repacoje sa'navʉ rʉ̃a ñato Jesús ũhisichejare ángeles te'eka'chapana pojakãña ju'inapi ñuniasome. Jesús sĩjopʉ caru'ru pa'isichejare chekʉ ñuniasomʉ. Chekʉta'ni Jesús cũ'a caru'ru pa'isichejare ñuniasomʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ũcuarʉmʉ ángeles repao'te sẽniasome. —¿Je'se pa'iʉna oiko mʉ'ʉ? —chiniasome repana. Chitena i'kaasomo. —Chʉkʉna'te Paakʉ'te pãipi sasõsinaa'me. Repaʉ'te sa ũhasichejajẽ'e vesʉmo chʉ'ʉ —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jã'aja'ñe i'kacuha chʉriko Jesure ũcuacheja nʉkakʉni ñaasomo repao. Ñakota'ni ñavesʉasomo repao repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Vesʉkona i'kaasomʉ Jesús repao'te. —¿Je'se pa'iʉna oiko mʉ'ʉ? ¿Neeni ku'eko mʉ'ʉ? —chiniasomʉ repaʉ. Chikʉna, “Otera'ñʉrʉã kuirakʉcosomʉ ikʉ”, chini cuasako i'kaasomo repao. —Mʉ'ʉpi sasi'kʉ pani kʉajʉ̃'ʉ chʉ'ʉre repaʉ'te sa ũhasicheja. Miijani rara chiimo chʉ'ʉ —chiniasomo repao. ");
INSERT INTO coe_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chikona Jesús i'kaasomʉ. —¡María! —chiniasomʉ. Chikʉna asa chʉri hebreo chʉ'opi i'kaasomo repao. —¡Rabuni! —chiniasomo. (“Rabuni” chini “Masiʉ” chiimʉ hebreo chʉ'o.) ");
INSERT INTO coe_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jã'aja'ñe i'kaona i'kaasomʉ Jesús. —Chẽamanejʉ̃'ʉ chʉ'ʉre. Ja'kʉ pa'icheja chuta'a co'ima'kʉa'mʉ chʉ'ʉ. Jã'ajekʉna chẽamanejʉ̃'ʉ chʉ'ʉre. Jã'ata'ni chʉ'ʉ neenare chʉ'ʉ cho'jechĩija'ñe pa'inare co'i ija'che kʉakaijʉ̃'ʉ: “Jesús, ‘Chʉ'ʉ Ja'kʉ Dios pa'ichejana co'imʉ chʉ'ʉ. Repaʉ chʉ'ʉ Ja'kʉ ũcuachi'a Mʉja'kʉa'mʉ. Chʉ'ʉre paakʉ'mʉ Repaʉ. Ũcuachi'a mʉsanʉkonare Paakʉ'mʉ Repaʉ’, chiisi'kʉa'mʉ”, chiijʉ̃'ʉ repanare —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chikʉna repao María Magdalena rani chʉkʉna'te repaʉ neenare repaʉ'te ñasi'ena'me repaʉ i'kasi'e kʉasi'koa'mo. ");
INSERT INTO coe_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ũcuaumucuse romicorʉmʉ na'itona chʉkʉna Jesús neena judíopãi chʉ̃'ʉnani vajʉchʉjʉ jatisa'ñaroã peore masi jeo ta'chesõ chi'i pa'isinaa'me. Jã'aja'ñe chi'i pa'inani Jesús chʉkʉna chenevʉ'te peosichejapi rani nʉkakʉ ija'che i'kasi'kʉa'mʉ: —Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chini repaʉ jʉ̃jñana'me me'jupo totasicoje ñosi'kʉa'mʉ repaʉ chʉkʉna'te. Ñokʉna ña, “Maire Paakʉ'mʉ ikʉ”, chini pojosinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ũcuarʉmʉ repaʉ jo'e ũcuare i'kasi'kʉa'mʉ. —Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona. Repaʉ chʉ̃'ʉñe cho'oa'kʉ chini Ja'kʉ chʉ'ʉre raosi'eja'che mʉsanʉkonare saomʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chini chʉkʉnani jujukʉ ija'che i'kasi'kʉa'mʉ: —¡Dios Rekochoji mʉsanʉkona rekoñoãre ja'me paaʉ! ");
INSERT INTO coe_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Cu'ache cho'oche ũhasõsinare pãi, “Mʉsanʉkona cu'ache cho'osi'e tʉnosõsi'ea'me”, chiire'omʉ mʉsanʉkonare. Chiito tʉnorepasi'ea'me repa. Jã'ata'ni cu'ache cho'oche ũhamanareta'ni, “Mʉsanʉkona cu'ache cho'oche tʉnoma'ñea'me”, chiire'omʉ mʉsanʉkonare, tʉnoma'ñejekʉna —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Reparʉmʉ chʉkʉna'te Jesús neenare docerepanare ja'me pa'ikʉ, “Gemelo”, chiicojñokʉ Tomás peosi'kʉa'mʉ, Jesús chʉkʉna'te peosichejapi rani ñorʉmʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Peosi'kʉjekʉna repaʉ'te ija'che kʉasinaa'me chʉkʉna: —Maire Paakʉ'te ñasinaa'me chʉkʉna —chiisinaa'me chʉkʉna repaʉ'te. Chitena Tomás jachakʉ ija'che i'kasi'kʉa'mʉ: —Repaʉ jʉ̃jña jẽ'josicojña ña chʉ'ʉ mʉoñoji cuacha ñani'te ũcuachi'a repaʉ me'jupo totasicoje chʉ'ʉ jʉ̃tʉpi suãni ñani'te mʉsanʉkona i'kache cuasaja'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Te'esemana pa'isirʉmʉna jo'e ũcuavʉ'ena chi'isinaa'me chʉkʉna. Reparʉmʉta'ni Tomás ja'me pa'isi'kʉa'mʉ. Chi'i pa'ijʉ jatisa'ñaroã masi jeo ta'chesõsisa'ñaroãta'ni Jesús chʉkʉna chenevʉ'te peosichejapi rani nʉkakʉ ija'che i'kasi'kʉa'mʉ: —Re'oja'che pa'ijʉ̃'ʉ mʉsanʉkona —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chini repaʉ'te Tomare i'kasi'kʉa'mʉ. —Chʉ'ʉ jʉ̃jña jẽ'josicojñana mʉ'ʉ mʉoñoji cuacha ñajʉ̃'ʉ. Ũcuachi'a chʉ'ʉ me'jupo totacojñosicoje mʉ'ʉ jʉ̃tʉpi suãni ña jachama'ñe cuasajʉ̃'ʉ chʉ'ʉre. Ũcuaʉ'mʉ chʉ'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Dioa'mʉ mʉ'ʉ. Chʉ'ʉre Paakʉ'mʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chikʉna i'kasi'kʉa'mʉ repaʉ. —Chura chʉ'ʉre ñasi'kʉjekʉ jachama'ñe cuasamʉ mʉ'ʉ. Jã'ata'ni chʉ'ʉre ñamanapi cuasana mʉ'ʉre na'a rʉa pojojʉ pa'ijanaa'me —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Repaʉ Jesús cheja pa'irʉmʉ chʉkʉna repaʉ neena ñajʉ'te Diochi'a cho'omasiche rʉa cho'o ñosi'kʉa'mʉ. Jã'ata'ni repa chʉkʉna ñasi'e peore kʉakʉ tocha jo'kama'mʉ chʉ'ʉ iphʉro. ");
INSERT INTO coe_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ie iphʉro tochasi'e peore mʉsanʉkonapi ña, “Jesucristo Dios Raosi'kʉa'mʉ. Ũcuaʉ Mamakʉ'mʉ repaʉ”, chini cuasa, repaʉni cuasajʉ re'oja'che pa'ijʉ jũnisõsirʉmʉ Dios pa'ichejare ai sani paapʉ chini tocha jo'kamʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jã'aja'ñe cho'osirʉmʉ chʉkʉna Jesús neena na'a pa'ijʉ Tiberias chiara rʉ'tʉva'te pa'ijʉna Jesús jo'e peosichejapi ñosi'kʉa'mʉ chʉkʉna'te aperʉmʉ cho'osi'eja'che. Ija'che cho'osi'kʉa'mʉ repaʉ: ");
INSERT INTO coe_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Repacheja Simón Pedro'mʉ, “Gemelo” chiikʉ Tomaa'mʉ, Galilea cheja cajoopo Caná vʉ'ejoopo cakʉ Natanaela'mʉ, chʉkʉna Zebedeo chĩi te'eka'chapana a'chʉna'me pa'isi'kʉa'mʉ chʉ'ʉ. Ũcuachi'a chekʉna te'eka'chapana chʉkʉna'te ja'me pa'isinaa'me Jesús neena. ");
INSERT INTO coe_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ũcuarʉmʉ Simón Pedro chʉkʉna'te i'kasi'kʉa'mʉ. —Va'i saimʉ chʉ'ʉ —chiisi'kʉa'mʉ. Chiiʉna chʉkʉna, —Ja'me sañu —chiisinaa'me. Chini choovʉ caje tuni ja'me va'i saisinaa'me chʉkʉna. Sani si'añami chonata'ni te'eva'ʉrejẽ'e va'ire chomanesinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ñatapi'ratona repaʉ Jesús chiara rʉ'tʉva'te peosichejapi rani nʉkasi'kʉa'mʉ. Jã'ata'ni chʉkʉna repaʉ neena repaʉ'te ñavesʉsinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ũcuarʉmʉ Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Põsʉpãi, ¿va'i chomanere? —chiisi'kʉa'mʉ. Chikʉna chʉkʉna i'kasinaa'me. —Pãasinaa'me chʉkʉna —chiisinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chitena i'kasi'kʉa'mʉ repaʉ. —Va'i chorʉ choovʉ ʉjajʉ̃tʉ cakã'kona su'a rʉoru va'i kakajanaa'me —chiisi'kʉa'mʉ repaʉ. Chikʉna repaʉ chʉ̃'ʉñe cho'ojʉ jairepanʉkore va'ire chorena va'i chorʉ miicu'asi'kʉa'mʉ chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ũcuarʉmʉ chʉ'ʉ Jesús rʉa chiicojñokʉji i'kasi'kʉa'mʉ Pedro'te. —Maire Paakʉ'mʉ jã'ʉ —chiisi'kʉa'mʉ chʉ'ʉ. Jã'aja'ñe i'kaʉna asa Simón Pedro Jesuni ñara chini sẽ'sevʉ ju'ikãa repaʉ tĩtosikãa mini sacha chiarana sʉ'a tuãni runi chu'asi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chʉkʉnata'ni repaʉ neena canʉka choovʉji va'i chorʉji va'ipi timusõrena chiachaji vavo rajʉ pa'isinaa'me. Chʉkʉna raisicheja cien metros pa'isi'kʉa'mʉ chiara joopo. ");
INSERT INTO coe_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rani rʉ'tʉvana jʉo mani toa ñasinaa'me chʉkʉna. Ũcuatoare chiacha va'ina'me pã pa'isi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ũcuarʉmʉ Jesús chʉkʉna'te i'kasi'kʉa'mʉ. —Va'i mʉsanʉkona chosiva'nare te'eva'nare rajʉ̃'ʉ —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chikʉna jo'e Simón Pedro choovʉna caje tuni va'i chorʉ ciento cincuenta y trerepana va'i ʉjanachi'a timusi'rʉre jñajñu ma ũhasi'kʉa'mʉ. Va'i jainʉko pa'irʉta'ni che'remanesi'kʉa'mʉ reparʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jã'aja'ñe cho'o pi'niʉna Jesús i'kasi'kʉa'mʉ chʉkʉna'te. —Rani ãijʉ̃'ʉ ãu —chiisi'kʉa'mʉ. Chʉkʉna repaʉ neena te'eʉjẽ'e, “¿Jeeja'iʉ'ʉ mʉ'ʉ?”, chiimanesinaa'me, repaʉni ña masijʉ. “Chʉkʉna'te Paakʉ'mʉ ikʉ”, chini cuasasinaa'me. ");
INSERT INTO coe_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ũcuarʉmʉ Jesús chʉkʉna'te pãna'me va'i mini ãusi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Repaʉ Jesús vajʉrani pa'iʉ chʉkʉna'te repaʉ neenare peosichejapi rani ñosi'e chura choteñoãa'me. ");
INSERT INTO coe_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ãu ãni pi'nisirʉmʉ Jesús Simón Pedro'te sẽesi'kʉa'mʉ. —Simón, Juan mamakʉ, ina chiime chʉ'ʉre. Jã'ata'ni, ¿mʉ'ʉ chʉ'ʉre na'a rʉa chiima'kʉ? —chiisi'kʉa'mʉ. Chiiʉna Pedro i'kasi'kʉa'mʉ. —Jʉ̃jʉ, Chʉ'ʉre Paakʉ, mʉ'ʉre rʉa chiimʉ chʉ'ʉ. Masimʉ mʉ'ʉ jã'a —chiisi'kʉa'mʉ repaʉ. Chikʉna Jesús i'kasi'kʉa'mʉ. —Jã'aja'ñe pa'ito ovejachĩiva'nare kuiracheja'che kuirakaijʉ̃'ʉ mʉ'ʉ chʉ'ʉ neenare —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chini repaʉ'te jo'e sẽesi'kʉa'mʉ repaʉ. —Simón, Juan mamakʉ, ¿chʉ'ʉre chiikʉ mʉ'ʉ? —chiisi'kʉa'mʉ. Chiiʉna i'kasi'kʉa'mʉ repaʉ. —Jʉ̃jʉ, Chʉ'ʉre Paakʉ, mʉ'ʉre chiimʉ chʉ'ʉ. Masimʉ mʉ'ʉ jã'a —chiisi'kʉa'mʉ repaʉ. Chiiʉna Jesús i'kasi'kʉa'mʉ. —Ovejava'nare kuiracheja'che kuirakaijʉ̃'ʉ chʉ'ʉ neenare —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jo'e ũcuate'ere sẽesi'kʉa'mʉ Jesús repaʉ'te. —Simón, Juan mamakʉ, ¿chʉ'ʉre chiikʉ mʉ'ʉ? —chiisi'kʉa'mʉ. Jesupi ũcuate'ere choteñoã, “¿Chʉ'ʉre chiikʉ mʉ'ʉ?”, chiiʉna Simón Pedro sʉmaʉna i'kasi'kʉa'mʉ. —Chʉ'ʉre Paakʉ, peore masikʉ'mʉ mʉ'ʉ. Chʉ'ʉ mʉ'ʉre chiiche masimʉ mʉ'ʉ —chiisi'kʉa'mʉ. Chikʉna i'kasi'kʉa'mʉ repaʉ. —Jã'aja'ñe pa'ito mʉ'ʉpi ovejava'nare kuiracheja'che kuirakaijʉ̃'ʉ chʉ'ʉ neenare. ");
INSERT INTO coe_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ija'chere i'kamʉ chʉ'ʉ mʉ'ʉre: Mʉ'ʉ aperʉmʉ põsʉʉ pa'irʉmʉ kãña sa'che mʉ'ʉre ʉachejña ku'isi'kʉa'mʉ mʉ'ʉ. Jã'ata'ni na'a pa'isirʉmʉ mʉ'ʉ aiva'ʉ pa'itona chekʉpi mʉ'ʉ jʉ̃jña saʉʉna vẽe mʉ'ʉre saiʉamachejñana saja'mʉ mʉ'ʉre. Ũcuarepaa'me jã'a —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jã'aja'ñe i'kacheji Jesús Simón Pedro Dios chʉ'ore chʉ'vakʉ chuenisõʉna pãi Diore cuasajachere kʉasi'kʉa'mʉ, ũcuaʉji asa masia'kʉ chini. Jã'aja'ñe chiimʉ Dios. Ũcuarʉmʉ Jesús Simón Pedro'te jo'e i'kasi'kʉa'mʉ. —¡Chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ! —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ũcuarʉmʉ chʉ'ʉ, Jesús neekʉ repaʉ rʉa chiicojñokʉji repanani cho'jepi tuhakʉna Pedro chʉri ñasi'kʉa'mʉ chʉ'ʉre, aperʉmʉ pascua ãu ãirʉmʉ Jesuni kueñe ñu'iʉ repaʉ'te jo'kajaʉni, sẽesi'kʉni. ");
INSERT INTO coe_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ũcuarʉmʉ Pedro chʉ'ʉni ña Jesure sẽesi'kʉa'mʉ. —Chʉkʉna'te Paakʉ, ikʉrejẽ'e, ¿je'se ti'jñeja'ʉ? —chiisi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chikʉna Jesús i'kasi'kʉa'mʉ. —Chʉ'ʉ cheja jo'e cajerʉmʉjatʉ'ka jũnisõma'ñe pa'iche'te chʉ̃'ʉ jo'kaʉato jo'kare'omʉ chʉ'ʉre ikʉre. Mʉ'ʉta'ni ikʉ pa'ijache cuasama'ñe chʉ'ʉ chʉ̃'ʉñe'te cho'okʉ pa'ijʉ̃'ʉ —chiisi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesupi jã'aja'ñe i'kaʉna asa chekʉna repaʉ neena asavesʉjʉ sãiñechi'a ija'che cutuasome: “Repaʉ Juan jũnisõma'ñe ai pa'ijaʉasomʉ”, chiniasome. Jã'ata'ni repaʉ Jesús, “Jũnisõma'ñe ai pa'ija'mʉ ikʉ”, chiimanesi'kʉa'mʉ chʉ'ʉre Juanre. Rupʉ, “Chʉ'ʉ cheja jo'e cajerʉmʉjatʉ'ka jũnisõma'ñe pa'iche'te ikʉre chʉ'ʉni jo'kaʉato jo'kare'omʉ”, chiisi'kʉa'mʉ Jesús chʉ'ʉre Juanre. ");
INSERT INTO coe_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chʉ'ʉ Jesús neekʉ pa'iche'te i'kasinaa'me repana. Chʉ'ʉ ũcuaʉji ie chʉ'o reparʉmʉ cho'osi'ere iphʉrona tochamʉ. Chʉ'ʉ kʉache chʉ'o ũcuarepaa'me. Masime mai jã'a. ");
INSERT INTO coe_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Chekʉmajñarʉã Jesús rʉa si'ache cho'osi'kʉa'mʉ. Iphʉro tochama'mʉ chʉ'ʉ repa. Repaʉ cho'osi'ere peore tocharu chekʉrʉmʉ repaʉ cho'osi'e kʉaphʉroã timusõra'acosomʉ cheja. Jã'aja'ñe cuasamʉ chʉ'ʉ. Ũcuamakarʉ tochamʉ chʉ'ʉ Juan.");
INSERT INTO coe_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chʉ'ʉ Lucas mʉ'ʉre Teófiloni ie chʉ'o tocha saomʉ, Jesús pa'iche'te masia'kʉ chini. Aperʉmʉ chʉ'ʉ mʉ'ʉre chekʉphʉro utija'ophʉro tocha saosi'kʉa'mʉ, Jesucristo cho'osi'ena'me che'chosi'e kʉara chini. ");
INSERT INTO coe_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Repaʉ Jesús cheja pa'isi'ena'me cʉnaʉmʉ mʉisi'e kʉara chini tocha saosi'kʉa'mʉ chʉ'ʉ mʉ'ʉre. Dios Rekochoji cho'okaiʉna Repaʉ mʉipi'rarʉmʉ Jesús Repaʉ neenare soni chʉ̃'ʉ jo'kaasomʉ, repana cho'ojache. ");
INSERT INTO coe_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Repaʉ Jesús jũniso tãcojñosi'kʉta'ni jo'e vajʉrani pa'iʉna Repaʉ neena ñaasome Repaʉ'te. Jũni vajʉrani jo'e cuarentarepaumucujña cheja pa'iʉ te'eñoã ñokʉ paniasomʉ Repaʉ, repanapi Repaʉ jũni vajʉraisi'ere masia'jʉ chini. Ñokʉna, “Jesua'mʉ ikʉ”, chini Repaʉ'te ña masiasome repana. Ũcuachi'a cu'ache cho'oche ũhasinare Dios chẽa paache'te kʉakʉ che'choasomʉ Jesús Repaʉ neenare. ");
INSERT INTO coe_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Vajʉrani Repaʉ neenana'me pa'iʉ ija'che chʉ̃'ʉasomʉ: —Icheja Jerusalén vʉ'ejoopo saima'ñe pa'ijʉ cha'ajʉ̃'ʉ. Saimʉ chʉ'ʉ. Jã'ata'ni chʉ'ʉ Ja'kʉ Dios mʉsanʉkonare Repaʉ Rekocho'te raopi'ramʉ, mʉsanʉkona rekoñoãre ja'me paaʉ chini. Repaʉ aperʉmʉ cho'ora chiisi'e cho'opi'ramʉ Dios. Aperʉmʉ chʉ'ʉ mʉsanʉkonare Repaʉ Dios Rekocho raojache kʉasi'kʉa'mʉ. Chura Dios Rekocho'te cha'ajʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Aperʉmʉ Juan pãi jainʉkore re'oja'che okoro'veasomʉ. Chura Diopi mʉsanʉkonare na'a re'oja'che cho'okaija'mʉ. Jeerʉmʉ pa'ima'tona mʉsanʉkona rekoñoãna Dios Rekocho raocojñojanaa'me mʉsanʉkonani ja'me paaʉ chini —chiniasomʉ Jesús repanare. ");
INSERT INTO coe_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Repaʉ Jesús neena Ũcuaʉni ja'me pa'ijʉ ija'che sẽniasaasome Repaʉ'te: —Asarepajʉ̃'ʉ, Chʉkʉna'te Paakʉ. Maijana judíopãi chʉ̃'ʉñechi'a chiime chʉkʉna. Jã'ata'ni maire chura tĩinapi chʉ̃'ʉme, judío peonapi. Jã'aja'ñe cuheme chʉkʉna. ¿Chura mʉ'ʉ chʉkʉna'te judío peona chʉ̃'ʉñe ʉ̃sekaija'ʉ? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chitena, —Chʉ'ʉ Ja'kʉ masiche'me jã'a. Repaʉ'te ʉ̃seʉarʉmʉ judío peona chʉ̃'ʉñe ʉ̃sekaija'mʉ Repaʉ. Chuta'a reparʉmʉ kʉama'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ie chʉ'ʉ i'kache asa chẽajʉ̃'ʉ: Mʉsanʉkonare Dios Rekocho raipi'ramʉ. Rani ja'me pa'iʉ Ũcuarekochoji cho'okaija'mʉ mʉsanʉkonare, chʉ'ʉ pa'iche'te chekʉnani masi kʉaa'jʉ chini. Ũcuaʉji cho'okaiʉna chʉ'ʉ pa'iche masi kʉajanaa'me mʉsanʉkona ijoopo Jerusalén vʉ'ejoopo pa'inare peore, icheja Judea cheja pa'inare, ũcuachi'a Samaria cheja pa'inare. Mʉsanʉkonapi kʉajʉna si'achejñarʉã rʉa so'ña pa'ina pãi peore asajanaa'me chʉ'ʉ pa'iche —chiniasomʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I'ka pi'ni Repaʉ neena ñajʉ'te cʉnaʉmʉna mʉnisoasomʉ Repaʉ. Mʉiʉna ñañu chiinareta'ni pikopi ñañejẽ'e peoche ta'pisoʉna ñama'ñe mʉosoasome repana. ");
INSERT INTO coe_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chuta'a mʉñe ñajʉ pa'ijʉna peosichejapi rani ʉmʉpãi te'eka'chapana pojakãña ju'inapi rani repana chenevʉ'te nʉkaasome. ");
INSERT INTO coe_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nʉkajʉ repanare Jesús neenare ija'che i'kaasome repana: —Mʉsanʉkona Galilea cheja raisina, ¿je'se pa'iʉna chuta'a mʉñe ñajʉ pa'iche? Repaʉ Jesús cʉnaʉmʉna mʉnisocuhasi'kʉa'mʉ. Na'a pa'isirʉmʉ Ũcuaʉ mʉisi'eja'che jo'e cajeja'mʉ Repaʉ —chiniasome repana ángeles cʉnaʉmʉ pa'ina. ");
INSERT INTO coe_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ũcuarʉmʉ repana te'ekilómetro Olivo aikũti caje Jerusalén vʉ'ejoopona co'i tĩ'aasome. ");
INSERT INTO coe_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Vʉ'ejoopo tĩ'a vʉ'e mʉni repana pa'iruupʉna kakaasome oncerepana, Pedro'mʉ, Santiago'mʉ, Juan'mʉ, Andre'mʉ, Felipe'mʉ, Tomaa'mʉ, Bartolome'mʉ, Mateo'mʉ, Santiago Alfeo mamakʉ'mʉ, Simón cananistapãi cho'okaisi'kʉna'me Judas Santiago cho'jeʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Repana oncerepana si'aumucujña chekʉnana'me chi'ijʉ paniasome Repaʉ Jesús cho'jechĩina'me, pʉka'ko Maríana'me chekʉna romi. Chi'i si'arʉmʉ Dioni sẽejʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Reparʉmʉ repana Jesucristo'te cuasanachi'a chi'iasome. Ciento veinterepana chi'isina pa'icosome. Chi'irena Pedro repana chenevʉji vʉni nʉkakʉ ija'che i'kakʉ chʉ'vaasomʉ repanare: ");
INSERT INTO coe_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Asarepajʉ̃'ʉ, chʉ'ʉ majapãi. Aperʉmʉ Dios Rekochoji kʉakʉna David Judas cho'ojachere kʉakʉ tocha jo'kasi'e ũcuarepa ti'jñesi'kʉa'mʉ. Dios Rekocho peoche i'kama'kʉa'mʉ. Jã'ajekʉna aperʉmʉ Dios Rekocho i'ka jo'kasi'e pa'ikʉ'mʉ Judas. Repaʉ Judas Jesuni chẽa sa vanisõa'jʉ chini chekʉnani Repaʉ sani pa'ichejana sasi'kʉa'mʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Chuta'a jã'aja'ñe cho'omarʉmʉ Repaʉ Jesús Judare soni chẽa paasi'kʉa'mʉ. Chẽa paakʉna chʉkʉnana'me pa'iʉ Diore re'oja'che ja'me cho'okaiʉ pa'isi'kʉa'mʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","’Repaʉ Judas aperʉmʉ re'oja'che pa'isi'kʉpi Jesuni cu'ache cho'oʉna repaʉ'te ro'iasome pãi. Ro'isinareta'ni repa kuri sʉma'ñe cuasa co'choasomʉ repaʉ. Co'choʉna repa kuri chejare kooasome repana. Repaʉ Judas cʉtapʉ'te tuãni che're cʉtatʉopʉji etaʉna jũnisõasomʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Repaʉ tuãni jũnisõsi'e Jerusalén pa'ina ũcuanʉko asaasome. Jã'aja'ñe asa repana chʉ'o Acéldama ve'oasome repacheja. Repana chʉ'o “Acéldama” chini “Chiecheja” chiiʉasomʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","’David mai aipãiʉ pa'isi'kʉ tocha jo'kasi'e ija'che kʉamʉ: Repaʉ vʉ'e pãi peovʉ'e jo'kasõsivʉ'e paaʉ. Repaʉ cho'oche chekʉni jo'kajʉ̃'ʉ, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Jã'ajekʉna Judas aperʉmʉ cho'osi'eja'che re'oja'che cho'okʉni chekʉni jñaa jo'kañu chiime mai. Jo'e te'eʉ'te jñaañu Jesús pa'iche'te maina'me kʉajaʉre, “Jesús jũnisõ tãcojñosi'kʉ jo'e vajʉrani pa'ikʉ'mʉ”, jã'aja'ñe chiiʉ kʉaa'kʉ. Jesús maina'me ku'irʉmʉ, ũcuaja'che Juan Repaʉ'te okorosi'e ñasi'kʉni si'ache maina'me ku'iʉ Repaʉ cʉnaʉmʉ mʉnisõñe ñasi'kʉni jñaañu chiime mai —chiniasomʉ repaʉ Pedro repanare. ");
INSERT INTO coe_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chikʉna, repana te'eka'chapanare ve'oasome, repana chiinani. José Barsabana'me Matía'te ve'oasome repana. José Barsabás jo'e ũcuate'eʉji Justo ve'easomʉ. ");
INSERT INTO coe_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Repanani chini ũcuanʉko Jesuni sẽniasome repana, Repaʉ chiikʉni masiñu chini. Ija'che i'kajʉ sẽniasome repana: —Mʉ'ʉ, Chʉkʉna'te Paakʉ, pãi ũcuanʉko rekoñoã cuasache masikʉ'mʉ. Chekʉni te'eʉ'te jñaañu chiime chʉkʉna Judas re'oja'che pa'irʉmʉ cho'osi'eja'che cho'oa'kʉ chini. Mʉ'ʉ chiikʉni kʉajʉ̃'ʉ chʉkʉna'te. ¿Jaʉni jñaajanaa'ñe chʉkʉna? Repaʉ Judas re'oja'che cho'osi'e jo'kasõ, cu'ache cho'osi'kʉjekʉ jũnisõ vati toare sani pa'iʉasomʉ, cu'ache cho'osi'e ro'i. Chura chʉkʉna'te ja'me pa'ikʉji karamʉ. ¿Jaʉni jñaajanaa'ñe chʉkʉna ja'me chʉ'vajaʉre? —Jã'aja'ñe i'kajʉ sẽniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sẽni pi'ni repana chiinani te'eka'chapanare repana mami catapʉãna tochaasome repana. Tocha pi'ni su'aasome Jesús chiikʉni masiñu chini. Su'a ña Matíani chẽaasome repana ũcuanani ja'me pa'iʉ cho'okaaʉ chini. Chẽarena ũcuanani Jesús saosinani oncerepanani jovoasomʉ Matías, ja'me chʉ'vara chini. ");
INSERT INTO coe_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ũcuarʉmʉ fiesta Pentecostés pa'irʉmʉ ũcuate'evʉ'e Jesucristo'te cuasanachi'a ũcuanʉko chi'iasome. ");
INSERT INTO coe_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Repavʉ'ere chi'i pa'ijʉna cʉnaʉmʉpi rʉa asoche tutacheja'che asoasomʉ. Repavʉ'e pa'ina ũcuanʉko asaasome. ");
INSERT INTO coe_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Asoʉna ñato repanare ũcuanʉkore sĩjo sẽ'sevʉã toñarʉãja'ñe ñoasomʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dios Rekochoji raiʉ ũcuanʉkore jã'aja'ñe cho'oasomʉ. Repanare Repaʉ Rekochoji rani ja'me pa'iʉ cho'okaiʉna repanajẽ'e che'chemanesi'ere tĩipãi chʉ'o i'kaasome repana ũcuanʉko. ");
INSERT INTO coe_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Reparʉmʉ repacheja Jerusalén vʉ'ejoopo judíopãi jainʉko si'achejñarʉã raisina paniasome Diore cuasana. ");
INSERT INTO coe_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","7","Ʉmʉpi rʉa asoche cho'okʉna asa repana Jerusalén pa'ina jainʉko vʉ'vʉ mʉa chi'iasome asañu chini. Vʉ'vʉ mʉa asato Jesucristo'te cuasanapi repanajẽ'e che'chemanesi'ere tĩipãi chʉ'ore i'kaasome. Jã'aja'ñe i'kajʉna asa rʉa cuasajʉ paniasome repana. Rʉa si'achejñarʉã raisina i'kachʉ'ore i'kajʉna asa sãiñechi'a ija'che i'kaasome repana: —¿Je'se paakʉ ie? Ina tĩipãi chʉ'o i'kana ũcuanʉko Galilea cheja raisinaa'me. ");
INSERT INTO coe_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Je'se pa'iʉna ina mai so'ña pa'ina i'kache peore i'kamasiche? ");
INSERT INTO coe_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mai rʉa si'achejñarʉã raisinaa'me. Partia cheja, Media cheja, Elam cheja, Mesopotamia cheja, Judea cheja, Capadocia cheja, Ponto cheja pa'inana'me Asia cheja raisina pa'ime mai. ");
INSERT INTO coe_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ũcuachi'a Frigia cheja, Panfilia cheja, Egipto cheja, Africa cheja Cirene chekʉkã'ko pa'inana'me pa'ime mai. Ũcuachi'a Roma vʉ'ejoopo raisina judíopãina'me judío peonapi judío pa'iche che'chesinana'me pa'ime mai icheja. ");
INSERT INTO coe_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ũcuachi'a Creta cheja pa'ina Arabia cheja pa'inana'me pa'ime mai icheja. Si'achejñarʉã raisinaa'me mai. Jã'ata'ni mai ũcuanʉko Dios re'oja'che cho'oche'te kʉajʉna asajʉ pa'ime. Peore mai chʉ'opi i'kajʉna asame mai —chiniasome repana sãiñechi'a. ");
INSERT INTO coe_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jã'aja'ñe i'kache'te asarena rʉa cuasoasomʉ repanare. Jã'ajekʉna sãiñechi'a ija'che i'kajʉ sẽniasome repana: “¿Je'se pa'iʉna ina ija'che i'kache?”, chiijʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Chekʉna vʉ'vʉ mʉasinata'ni asa pãisojʉ cu'ache cutuasome repanare Jesure cuasanare. “Cono jũ'ime ina”, chiniasome repana sãiñechi'a. ");
INSERT INTO coe_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chitena Pedro oncerepanare ja'me pa'ikʉji vʉni nʉkakʉ pãi kuanupʉ vʉ'vʉ raisikuanupʉ'te ija'che chʉ'vaasomʉ: —Asarepajʉ̃'ʉ, mʉsanʉkona judíopãi, Jerusalén pa'ina. ");
INSERT INTO coe_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Ina cono jũ'ime”, chiime mʉsanʉkona te'ena. Jã'ata'ni cono jũ'ima'me chʉkʉna. Chuta'a apeñatamʉ ie. Nueve'me. Mai judíopãi umucujña cono ũkumanaa'me. ");
INSERT INTO coe_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ija'che pa'imʉ: Apereparʉmʉ Dios chʉ'o kʉasi'kʉ, Joel, irʉmʉ cho'ojachere kʉakʉ tocha jo'kasi'e ija'che kʉamʉ: ");
INSERT INTO coe_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cheja si'api'rarʉmʉ pãi ũcuanʉkore Repaʉ Rekocho'te raoja'mʉ Dios. Raoʉna Ũcuarekochoji cho'okaiʉna mai chĩipi Repaʉ chʉ'ore chʉ'vajanaa'me. Cho'okaija'mʉ põsʉpãipi Dios ñoñe'te tochare ñaa'jʉ chini. Cho'okaija'mʉ ainapi ʉokãni ñaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ũcuachi'a reparʉmʉ Repaʉ'te cho'oche cho'okainare ʉmʉpãina'me romi Repaʉ Rekocho'te raoja'mʉ Dios repanapi Ũcuaʉ chʉ'ore chʉ'vaa'jʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Repaʉ Dios cʉnaʉmʉna'me cheja Ũcuaʉchi'a cho'omasiche'te pãi rʉa cuasajʉ'te cho'o ñoja'mʉ. Chiena'me toana'me piko cho'o ñoja'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ʉ̃sʉʉ miañe ʉ̃seja'mʉ. Ũcuaja'che pãimiaʉ chieja'che ñoja'mʉ. Repaʉ jo'e cajepi'rarʉmʉ jã'aja'ñe cho'oja'mʉ Maire Paakʉ. Reparʉmʉ Dios pãi ũcuanʉko pa'ijʉ cho'osi'e ro'iche chʉ̃'ʉja'mʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ũcuachi'a reparʉmʉ pãipi Maire Paakʉni sẽejʉ, “Chʉ'ʉre oijʉ̃'ʉ; mʉ'ʉre cuasakʉ'mʉ chʉ'ʉ”, chiito repanare Chẽa Paakʉ re'oja'che cho'okaija'mʉ, chiimʉ Joel tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Israelpãi, asa chẽajʉ̃'ʉ. Diopi raoʉna pa'isi'kʉa'mʉ Jesús. Ũcuaʉji cho'okaiʉna rʉa re'oja'chere, Diochi'a cho'omasiche'te, pãi rʉa cuasajʉ'te cho'osi'kʉa'mʉ Repaʉ. Icheja jã'aja'ñe cho'osi'kʉa'mʉ. Masime mʉsanʉkona jã'a. ");
INSERT INTO coe_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jã'ata'ni mʉsanʉkonapi Repaʉni vanisõa'jʉ chini cu'apãire chʉ̃'ʉrena vanisõsinaa'me Repaʉ'te. Mʉsanʉkonapi chʉ̃'ʉrena kurususẽ'vero cho'o ũcuasẽ'verona jẽ'jo nʉkorena jũnisõsi'kʉa'mʉ Repaʉ. Jã'ata'ni Dios maini re'oja'che cho'okasa chini ʉ̃semanesi'kʉa'mʉ jã'a. Chuta'a cheja cho'omarʉmʉ masiasomʉ Dios mʉsanʉkona cho'ojache. Masikʉta'ni ʉ̃semanesi'kʉa'mʉ Repaʉ, maini re'oja'che cho'okasa chini. “Jã'aja'ñe cho'oja'mʉ chʉ'ʉ”, chiniasomʉ Dios aperʉmʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jã'ajekʉna Repaʉ Jesucristo chuenisõ tãcojñosi'kʉa'mʉ. Jã'ata'ni jmamakarʉ pani Diopi vasoʉna jo'e vajʉrani etasi'kʉa'mʉ Jesús. Jũnisõsina pa'icheja pa'ikʉni etosi'kʉa'mʉ Dios. Jũnisõsiva'na pa'icheja ai pa'icu'aasomʉ Repaʉ'te. Chuenisõsi'kʉ vajʉrani jo'e chejare pa'isi'kʉa'mʉ Repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Aperʉmʉ pa'isi'kʉ David Repaʉ Jesús pa'ijachere kʉakʉ tocha jo'kasi'e ija'che kʉamʉ: Chʉ'ʉre Paakʉji chʉ'ʉre ja'me pa'ikʉ'mʉ. Ñato si'arʉmʉ pa'ikʉ'mʉ Repaʉ. Chʉ'ʉre cho'okaikʉ'mʉ Repaʉ, vajʉchʉmanea'kʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jã'ajekʉna chʉ'ʉ rekocho rʉa pojomʉ. Pojokʉ ija'che i'kamʉ chʉ'ʉ: Chʉ'ʉ jũnisõsirʉmʉ re'oja'che pa'ija'mʉ chʉ'ʉre. Jã'are masimʉ chʉ'ʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ja'kʉ, mʉ'ʉ chʉ'ʉre jũnisõsina pa'icheja ai saomaneja'mʉ. Chʉ'ʉre saoja'mʉ mʉ'ʉ. Jã'ata'ni rʉa jeerʉmʉ jo'kamaneja'mʉ mʉ'ʉ chʉ'ʉre repacheja. Mʉ'ʉpi ʉ̃sekʉna chʉ'ʉ ca'nivʉ jã'jumaneja'mʉ chʉ'ʉre. ");
INSERT INTO coe_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mʉ'ʉpi chʉ'ʉre re'oja'che pa'iche che'choʉna re'oja'che pa'imasikʉ'mʉ chʉ'ʉ. Mʉ'ʉpi chʉ'ʉni ja'me pa'iʉna rʉa pojokʉ'mʉ chʉ'ʉ, chiimʉ repaʉ David tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Asarepajʉ̃'ʉ, chʉ'ʉ majapãi, chʉ'ʉ ũcuarepa i'kache. Mai aipãiʉ pa'isi'kʉre Davire jũnisõʉna tãsõasome pãi. Repaʉ'te tãsicheja chuta'a pa'imʉ. Kueñea'me repacheja. Jã'ajekʉna ie masime mai: “Chʉ'ʉ ca'nivʉ jã'jumaneja'mʉ”, chiisi'e David ca'nivʉ pa'iche kʉama'ñe chekʉ ca'nivʉ pa'iche'te kʉamʉ jã'a. ");
INSERT INTO coe_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Repaʉ David cheja pa'irʉmʉ Dios chʉ'o asa kʉakaiʉ paniasomʉ. Repaʉ'te ija'che i'kaasomʉ Dios: Mʉ'ʉ jojosinare na'a pa'isirʉmʉ jainʉkore paaja'mʉ mʉ'ʉ. Ũcuana Mamakʉji Israelpãire re'oja'che chʉ̃'ʉja'mʉ. Mʉ'ʉ chʉ̃'ʉñeja'ñe re'oja'che chʉ̃'ʉkʉ pa'ija'mʉ Repaʉ. Chʉ'o ũcuarepare i'kamʉ chʉ'ʉ, chiniasomʉ Dios repaʉ'te Davire. ");
INSERT INTO coe_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Repaʉ Dios cho'ojache asaasomʉ David. Asasi'kʉjekʉ Dios Raojaʉ Cristo jũnisõ jo'e vajʉraijache tocha jo'kaasomʉ repaʉ. Ija'che chiimʉ repa: Repaʉji jũnisõru jũnisõsina pa'icheja ai jo'kamaneja'mʉ Dios. Repaʉ ca'nivʉjẽ'e jã'jumaneja'mʉ, chiimʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Repaʉ cho'oja'mʉ chiisi'e cho'ocuhasi'kʉa'mʉ Dios. Jesús chuenisõ tãcojñosi'kʉ Diopi vasoʉna vajʉrani jo'e ku'isi'kʉa'mʉ cheja. Ku'iʉna Repaʉ'te peore ũcuanʉko ñasinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Vajʉrakʉna Dios Repaʉ'te cʉnaʉmʉna mʉa, “Chʉ'ʉre kueñe ʉjajʉ̃tʉ cakã'kore pʉʉ ñu'iʉ chʉ'ʉna'me chʉ̃'ʉjʉ̃'ʉ”, chiniasomʉ. Aperʉmʉ Repaʉ Pʉka'kʉ, Dios, “Chʉ'ʉ Rekocho'te ĩsija'mʉ chʉ'ʉ mʉ'ʉre”, chiniasomʉ Mamakʉ'te. Churata'ni ĩsicuhasi'kʉa'mʉ Repaʉ. Pʉka'kʉpi ĩsiʉna Repaʉ Rekocho Jesús Ũcuarekocho'te jo'e chʉkʉnani ĩsicuhasi'kʉa'mʉ ja'me paaʉ chini. Ũcuarekochoji re'oja'che cho'okaimʉ chʉkʉna'te. Mʉsanʉkona ñasi'ena'me asasi'e cho'okaimʉ Dios Rekocho chʉkʉna'te. ");
INSERT INTO coe_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Repaʉ David cʉnaʉmʉ mʉimaneasomʉ. Cheke repaʉ tocha jo'kasi'e ija'che chiimʉ: Chʉ'ʉre Paakʉ'te Dios ija'che i'kaasomʉ: “Chʉ'ʉni kueñe pʉʉjʉ̃'ʉ ʉjajʉ̃tʉ cakã'kona. Chʉ'ʉpi cho'okaiʉna mʉ'ʉre cuhena ũcuanʉko mʉ'ʉ chʉ̃'ʉñe cho'ojanaa'me”, chiniasomʉ Dios Repaʉ'te, chiimʉ repaʉ tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israelpãi ũcuanʉko, asa chẽajʉ̃'ʉ ie chʉ'o: Mʉsanʉkonapi vanisõñe'te chʉ̃'ʉrena Jesure kurususẽ'verona jẽ'josinaa'me pãi. Jã'ata'ni Dios Jesure pãi chʉ̃'ʉñe jo'kasi'kʉa'mʉ. Maire Chẽa Paajaʉre Jesuni jñaasi'kʉa'mʉ Dios. Repaʉ'te pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini raosi'kʉa'mʉ —chiniasomʉ repaʉ Pedro. ");
INSERT INTO coe_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Repaʉ i'kasi'ere asarena rʉa sʉmaneasomʉ repanare. Sʉma'ñe asa repaʉ'te ija'che i'kajʉ sẽniasaasome repana chekʉnare oncerepanare ũcuachi'a: —Chʉkʉna majapãi, jã'a pa'ito, ¿je'se cho'ojanaa'ñe chʉkʉna? —chiniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Chitena, repaʉ Pedro jo'e i'kaasomʉ. —Mʉsanʉkona cu'ache cho'oche'te ũcuanʉko jo'kasõ Dios chʉ̃'ʉñe'te cho'ojʉ pa'ijʉ̃'ʉ. Cu'are jo'kasõ re'oja'che pa'ijʉ okoro'vecojñojʉ̃'ʉ, “Jesucristo'te cuasanaa'me chʉkʉna”, chiijʉ. Jã'aja'ñe cho'oru Dios mʉsanʉkonare cu'ache cho'osi'e tʉ'nesõkaija'mʉ. Tʉ'nesõ Ũcuaʉ Rekocho'te ĩsija'mʉ Repaʉ mʉsanʉkonare, ai ja'me paaʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jã'aja'ñe cho'okasa chiimʉ Dios mʉsanʉkonare, mʉsanʉkona chĩina'me so'ña pa'inare peore. Maire Paakʉ Jesucristo chẽa paajanarechi'a cho'okasa chiimʉ Dios —chiniasomʉ Pedro. ");
INSERT INTO coe_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chini repanare rʉa chʉ'vaasomʉ repaʉ, ija'che chiiʉ: —Ina pãi icheja pa'ina Jesucristo'te cuhena peore cho'osõjanaa'me. Rʉa cu'ache pa'ija'mʉ repanare. Mʉsanʉkonata'ni cho'osõmanejʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","I'ka pi'niʉna repaʉ chʉ'vache asa chẽasinachi'a Jesucristoni cuasajʉ jovo okoro'vecojñoasome. Repaumucuse pãi chekʉrʉmʉ tres milrepana chekʉnani Jesucristo'te cuasanani jovoasome. ");
INSERT INTO coe_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Repana Jesucristo'te cuasana ũcuanʉko si'arʉmʉ chi'ijʉ paniasome. Jesucristo'te ja'me ku'isinapi Dios chʉ'ore che'chojʉna chi'i che'chejʉ paniasome repana. Jainʉko chi'i ãu ãijʉ ũcuachi'a chi'i Diore sẽejʉ paniasome. Jã'aja'ñe cho'ojʉ ũcuanʉko sãiñechi'a pojojʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ũcuarʉmʉ pãi ũcuanʉko Jesús saosina docerepanapi Ũcuaʉji cho'okaiʉna rʉa re'oja'chere Diochi'a cho'omasiche'te cho'ojʉna ñajʉ rʉa cuasaasome. Ña jña'nejʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Repana Jesucristo'te cuasana sãiñechi'a pojojʉ si'arʉmʉ chi'ijʉ paniasome. Re'oja'chechi'a pa'ijʉ sãiñechi'a kuirajʉ paniasome repana. Chekʉnare põsena'me ãu karato chekʉnapi põse paanapi põsere ĩsiso, kuri koo, ĩsiasome repanare kuri peova'nare. Ũcuaja'che chejña paanapi chejñare ĩsiso, kuri koo, ĩsiasome chʉova'na pa'iva'nare. Na'a rʉa chʉova'na pa'iva'nare kuri na'a rʉa ĩsiasome repana. ");
INSERT INTO coe_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dios vʉ'ena repaumucujña pa'iche chi'ijʉ paniasome repana. Ũcuachi'a repana vʉ'ñana chi'i pojojʉ ãu ãijʉ paniasome. Sãiñechi'a soni ãu ãujʉ pojorepache pojojʉ paniasome repana. ");
INSERT INTO coe_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Si'arʉmʉ chi'i, “Dios rʉa re'okʉ'mʉ”, chiijʉ paniasome repana. Chekʉna pãi tijñani re'oja'che cutuasome repanare. Repaʉ Jesucristoji cho'okaiʉna Dios chʉ'ore asa chẽa repaumucujña pa'iche na'a rʉa jainʉko cuasajʉ jovojʉ paniasome pãi Repaʉ'te Jesure. ");
INSERT INTO coe_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ũcuarʉmʉ Juanna'me Pedro Dios vʉ'ena mʉajʉ paniasome. Judíopãi Diore sẽerʉmʉna tres pa'itona na'ito mʉaasome repana. ");
INSERT INTO coe_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Repana mʉajʉ ñato ũcuavʉ'ere pãiʉ nʉka ku'imava'ʉ ñuniasomʉ. Vĩjachĩirʉmʉna cu'acũ'a paava'ʉ paniasomʉ repaʉ. Nʉka ku'imava'ʉjekʉ ñu'iʉ Dios vʉ'e kakanani kurire sẽeʉ paniasomʉ repaʉ. Kurire sẽaʉ chini si'aumucujña cajo ra ñoocojñokʉjekʉ Dios vʉ'e kakasa'aro'te, pãi “Re'ojasa'aro” chiisa'aro'te ñu'iʉ paniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ũcuarʉmʉ repana, Pedrona'me Juan, Dios vʉ'ena mʉa tĩ'a kakapi'rajʉna ña kurire sẽniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sẽeʉna repaʉ'te rʉa rorepa ñaasome repana. Rorepa ñajʉ repaʉ'te Pedroji i'kaasomʉ. —Chʉkʉnani ñajʉ̃'ʉ —chiniasomʉ repaʉ. ");
INSERT INTO coe_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chiiʉna ũcuanani pojokʉ ñaasomʉ. Pojokʉ cha'aasomʉ repaʉ, “Chʉ'ʉni ina kuri ĩsipi'rame”, chini. ");
INSERT INTO coe_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Cha'akʉna Pedro jo'e i'kaasomʉ repaʉ'te. —Kurijẽ'e peomʉ chʉ'ʉ. Jã'ata'ni chekere na'a re'oja'chere cho'okaija'mʉ chʉ'ʉ mʉ'ʉre. Jesucristo Nazaret raisi'kʉpi chʉ̃'ʉkʉna, vʉni nʉka ku'ijʉ̃'ʉ mʉ'ʉ. Vajʉjʉ̃'ʉ chiimʉ chʉ'ʉ mʉ'ʉre —chiniasomʉ Pedro repaʉ'te, nʉka ku'imava'ʉre. ");
INSERT INTO coe_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chini repaʉ'te ʉjajʉ̃tʉna chẽa juha vʉoasomʉ repaʉ. Juha vʉokʉna ku'icu'asicũ'a teana care'oso nʉka ku'ire'oasomʉ repaʉ'te. Koka paniasomʉ repaʉ cũ'a. ");
INSERT INTO coe_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Teana vʉni sʉ'a nʉka kuniasomʉ repaʉ. Pojokʉ nʉka ku'iʉ, chã'sakʉ, Dios vʉ'ena ja'me kakaasomʉ repaʉ, “Dios rʉa re'okʉ'mʉ”, chiiʉ. ");
INSERT INTO coe_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ũcuaʉji nʉka ku'iʉ, “Dios rʉa re'okʉ'mʉ”, chiiʉna, pãi kuanupʉ repavʉ'e pa'ina rorepa ñaasome repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Repaʉ'te ña masiasome repana ija'che chiijʉ: —Ãa, ¡ikʉ Re'ojasa'aro ñu'iʉ kuri sẽesi'kʉa'ʉ! Ũcuaʉ'mʉ ikʉ —chiniasome repana. Repaʉ cho'ocojñosi'ere rʉa ña jñanoasome pãi. ");
INSERT INTO coe_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Diore sẽni pi'ni ve'sena etaasome repana nʉka ku'imanesi'kʉna'me Juanna'me Pedro. Dios vʉ'e eta ve'se pa'ikachapa'te paniasome repana. Repakachapa mami Portal de Salomón ve'easomʉ. Nʉka ku'imanesi'kʉni vasorena vajʉ pa'iʉ pojokʉ repanare jñu'ima'ñe chẽa sʉ'iʉ paniasomʉ repaʉ. Jñu'ima'ñe ve'sere ja'me pa'iʉna pãi kuanupʉ ña jñano ũcuachejana vʉ'vʉ sani chi'iasome. ");
INSERT INTO coe_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chi'irena, ña Pedro ija'che chʉ'vaasomʉ repanare: —Chʉkʉna majapãi, ¿je'se pa'iʉna ña jñanoñe mʉsanʉkona? Chʉkʉna'te rʉa pãiñame mʉsanʉkona. Chekʉrʉmʉ ija'che cuasacosome mʉsanʉkona: “Ãa, ina rʉa re'onajejʉ, masijʉ ikʉre vasome”, chini cuasajʉ ñacosome. Ikʉ nʉka ku'imʉ chura. Jã'ata'ni chʉkʉna cho'osi'ema'mʉ ie. ");
INSERT INTO coe_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios cho'osi'ea'me. Mai aipãi, aperʉmʉ pa'isina, Abraham, Isaac, Jacob Repaʉ'te Diore cuasajʉ Ũcuate'eʉni Diore pojoasome. Ija'che chiimʉ Dios maire: “Jesús chʉ'ʉ chĩia'mʉ. Chʉ'ʉre cho'oche cho'okaikʉ'mʉ Repaʉ, pãi chʉ'vachena'me pãi vasoche. Rʉa Masiʉji rʉa re'okʉ'mʉ Repaʉ”, chiimʉ Dios maire. Jã'ata'ni mʉsanʉkona Repaʉ'te Jesure jachasinaa'me. Repaʉ'te chẽa pãi chʉ̃'ʉnani jo'kasinaa'me mʉsanʉkona, Repaʉni cu'ache cho'oa'jʉ chini. Pãi chʉ̃'ʉkʉ'te Pilato'te, “Ikʉre etora chʉ'ʉ”, chiikʉ'teta'ni, “Vanisõjʉ̃'ʉ jã'ʉre Jesure”, chiisinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dios chʉ̃'ʉñe re'oja'chechi'a cho'okʉ'te Jesure cuhesinaa'me mʉsanʉkona. Repaʉni cuhejʉ, chekʉni pãi vanisõsi'kʉni, “Barrabani etojʉ̃'ʉ”, chiisinaa'me mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jã'ata'ni Jesure pãi re'oja'che pa'iche ĩsikʉ'te vanisõñe'te chʉ̃'ʉsinaa'me mʉsanʉkona. Vanisõ tãcojñosi'kʉreta'ni Diopi vaso etosi'kʉa'mʉ repaʉ'te. Vajʉrani pa'iʉna repaʉ'te ñasinaa'me chʉkʉna. ");
INSERT INTO coe_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ũcuaʉji vasoʉna nʉka ku'imʉ ikʉ chura, mʉsanʉkona si'arʉmʉ ñava'ʉ. Repaʉ vasosi'e ñasinaa'me mʉsanʉkona. Jesús ikʉre vasocuhasi'kʉa'mʉ chʉkʉnapi Repaʉni cuasajʉna. ");
INSERT INTO coe_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jã'ata'ni, mʉsanʉkona, chʉkʉna majapãi, repaʉ pa'iche'te vesʉjʉ cu'ache cho'osinaa'me Jesure. Masimʉ chʉ'ʉ jã'a. Mʉsanʉkonare chʉ̃'ʉna ũcuaja'che repaʉ pa'iche'te vesʉjʉ vanisõñe chʉ̃'ʉsinaa'me repaʉ'te. ");
INSERT INTO coe_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jã'ata'ni Dios repaʉ'te cu'ache cho'ojache peore masisi'kʉa'mʉ. Masikʉta'ni Repaʉ'te Jesure cu'ache cho'oche ʉ̃sekaimanesi'kʉa'mʉ Repaʉ. Ʉ̃semaʉna Repaʉ apereparʉmʉ kʉasi'e cho'ocuhasinaa'me Repaʉ'te. Aperʉmʉ Repaʉ chʉ'o kʉasina tocha jo'kasi'e ija'che kʉamʉ: Na'a pa'isirʉmʉ Dios Repaʉ Neekʉre pãi ũcuanʉkore Chʉ̃'ʉjaʉre chejana raoja'mʉ. Raoʉna pãi cu'ache cho'ojanaa'me Repaʉ'te, chiimʉ Repaʉ chʉ'o kʉasina ũcuanʉko tocha jo'kasi'e. ");
INSERT INTO coe_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jã'ajekʉna mʉsanʉkona cu'ache cho'oche'te ũhasõ re'oja'che pa'ijʉ Dioni cuasajʉ jovojʉ̃'ʉ, Repaʉji mʉsanʉkona cu'ache cho'oche'te cuasamanea'kʉ. Mʉsanʉkonapi jã'aja'ñe cho'oto rekoñoãna re'oja'che pa'iche ĩsija'mʉ Dios. ");
INSERT INTO coe_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dios aperʉmʉ, “Ikʉre chʉ'ʉ Neekʉre pãi ũcuanʉkore chʉ̃'ʉa'kʉ chini chejana saoja'mʉ chʉ'ʉ”, chiniasomʉ. Jã'ajekʉna mʉsanʉkonapi Dioni jovoto Ũcuaʉni raoja'mʉ Repaʉ, mʉsanʉkona rekoñoãre ja'me paaʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Repaʉ Jesús cʉnaʉmʉre pa'imʉ chura. Diopi chʉ̃'ʉmaʉna chuta'a cajema'ñe pa'imʉ Repaʉ. Na'a pa'isirʉmʉna chʉ̃'ʉʉna jo'e cajeja'mʉ Repaʉ. Reparʉmʉ, Dios peore re'oja'che care'vaja'mʉ. Aperʉmʉ Diopi chʉ̃'ʉkʉna Repaʉ chʉ'o kʉasina Repaʉ Jesucristo jo'e raijachere kʉajʉ tocha jo'kaasome. Repana kʉasi'e cho'oja'mʉ Dios reparʉmʉ, Jesucristo jo'e cajerʉmʉ. ");
INSERT INTO coe_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Te'eʉ, aperʉmʉ Dios chʉ'o kʉasi'kʉ Moisés, chekʉnare mai aipãi pa'isinare ija'che i'kaasomʉ: Na'a pa'isirʉmʉ Maire Paakʉ Dios chekʉre Repaʉ chʉ'o Kʉajaʉre chejana raoja'mʉ, chʉ'ʉ kʉacheja'che Kʉajaʉre. Mai majapãiʉ pa'ija'mʉ repaʉ. Repaʉ rani chʉ'vato ũcuanʉko asa jachama'ñe cho'ojʉ̃'ʉ mʉsanʉkona. ");
INSERT INTO coe_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pãi repaʉ'te jachana cho'osõjanaa'me. Dios pa'icheja saimanejanaa'me. Jã'ajekʉna Repaʉ neenare ja'me pa'imanejanaa'me repana, chiniasomʉ Moisés. ");
INSERT INTO coe_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Aperʉmʉ Dios chʉ'o kʉasina ũcuanʉko, irʉmʉ cho'ojachere kʉaasome, ũcuachi'a Samuel, cho'je pa'isina. ");
INSERT INTO coe_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Repana Dios chʉ'o kʉasina mai aipãi paniasome. Maipi ñajʉ che'chea'jʉ chini Dios chʉ'o tocha jo'kaasome repana. Chekʉ, Abraham, mai aipãiʉ na'a charo paniasomʉ. Repaʉ'te ija'che i'kaasomʉ Dios: Na'a pa'isirʉmʉ mʉ'ʉ Jojosi'kʉre chejana raoja'mʉ chʉ'ʉ, pãi ũcuanʉkore re'oja'che cho'okaaʉ chini, chiniasomʉ Dios. Repaʉ i'kasi'e cho'okanicuhasi'kʉa'mʉ Dios maire. ");
INSERT INTO coe_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chareparo maini judíopãire re'oja'che cho'okasa chini, Repaʉ Mamakʉ'te, Jesure, vaso raocuhasi'kʉa'mʉ Dios maipi peore cu'are ũhasõa'jʉ chini —chiniasomʉ Pedro repanare pãi. ");
INSERT INTO coe_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Repaʉ Pedro chuta'a Juanna'me pãire cututona judío phairipãi Dios vʉ'e pẽ'jekainare chʉ̃'ʉkʉna'me saduceopãi rani tĩ'aasome. ");
INSERT INTO coe_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tĩ'a Pedrona'me Juanre rʉa pe'ruasome repana pãire ija'che chʉ'vajʉna: “Jesús jũnisõ tãcojñosi'kʉ jo'e vajʉrani pa'ikʉ'mʉ. Jã'ajekʉna na'a pa'isirʉmʉna pãi jũnisõsina jo'e vajʉraijanaa'me ũcuachi'a”, chiniasome repana. Jã'aja'ñe che'chojʉna pãi jo'e vajʉraiche jachanajejʉ pe'ruasome repana saduceopãi. ");
INSERT INTO coe_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pe'rujʉ Pedrona'me Juanre chẽa sa na'itojekʉna pãi chẽavʉ'ena cuaoasome repana, chekʉumucusejatʉ'ka paapʉ chini. ");
INSERT INTO coe_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jã'ata'ni pãi jainʉko repana chʉ'vasi'e asa chẽasina Jesucristoni cuasajʉ jovoasome. Jã'aja'ñe jovorena chura Jesucristo'te cuasana ʉmʉpãichi'a kuẽkue ñato peore chekʉrʉmʉ cinco milrepana pa'icosome. ");
INSERT INTO coe_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jo'e apeñatato judío phairipãi chʉ̃'ʉna, judío ainana'me judíopãi che'chona chʉ'ore cutuñu chini Jerusalén vʉ'ejoopona chi'iasome. ");
INSERT INTO coe_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Reparʉmʉ judío phairi ai, Anás, repaʉ majapãina'me rani paniasomʉ. Repaʉ majapãi mamia'me ie: Caifaa'mʉ, Juan'mʉ, Alejandro'mʉ jo'e chekʉna. ");
INSERT INTO coe_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chi'i repanare pãi chẽavʉ'e pa'isinare Pedrona'me Juanre etua raa'jʉ chini chʉ̃'ʉasome repana. Rarena ũcuana chenevʉna nʉko repanare sẽniasaasome repana judío phairipãi. —¿Neepi chʉ̃'ʉjʉna mʉsanʉkona jã'aja'ñe si'ache cho'ojʉ pãi vasomasiche? —chiniasome. ");
INSERT INTO coe_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chitena Pedro Dios Rekochoji ja'me pa'iʉ cho'okaiʉna ija'che i'kaasomʉ repanare: —Chʉkʉna'te paana, aina asarepajʉ̃'ʉ. ");
INSERT INTO coe_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mʉsanʉkona chʉkʉna'te jũ'iva'ʉre re'oja'che cho'okaisi'ere sẽeme, “¿Je'se cho'ojʉ vasoche ina?”, chini. ");
INSERT INTO coe_vpl VALUES (